import os
from setuptools import setup

def read(fname):
    return open(os.path.join(os.path.dirname(__file__), fname)).read()

setup(
    name = "linfir.mdtex",
    version = "0.1.0",
    author = "Yann Villessuzanne",
    author_email = "yann@miomio.fr",
    description = ("Process a variant of markdown."),
    license = "MIT",
    keywords = "markdown latex html5 mathjax",
    url = "https://github.com/linfir/mdtex",
    packages = [ "linfir.mdtex" ],
    package_data = { "linfir.mdtex": [ "data/*" ] },
    long_description = read("README.md"),
    classifiers = [
        "Development Status :: 1 - Planning",
        "Topic :: Utilities",
        "License :: OSI Approved :: MIT License",
    ],
    entry_points = {
        'console_scripts': [
            'mdtex = linfir.mdtex.main:main',
        ],
    },
    install_requires = [
        'roman'
    ],
)
