from linfir.mdtex.resources import resource
from linfir.mdtex.parser import parse_inline
from linfir.mdtex.math import process_matrix
import re

__all__ = ['expand']


def read_assoc_file(filename):
    """Read a file into a hash"""
    h = {}
    for n, l in enumerate(resource(filename).split('\n')):
        l = re.sub('#.*', '', l).strip()
        if not l:
            continue
        m = re.match(r"(\S+)\s+(.+)$", l)
        assert m, "Invalid line {} in {}".format(n+1, filename)
        h[m.group(1).strip()] = m.group(2).strip()
    return h


abbrevs = read_assoc_file("abbreviations.txt")
symbols = read_assoc_file("symbols.txt")

R_letter = re.compile(r"[a-zA-Z]")


def expand_symbols(src):
    dst = ""
    for i, c in enumerate(src):
        try:
            x = symbols[c]
            if R_letter.match(src, i+1):
                x += " "
            dst += "\\" + x
        except KeyError:
            dst += c
    return dst.strip()


def symbols_to_unicode(x):
    # FIX: slow!
    for k, v in symbols.items():
        x = re.sub(" *" + re.escape("\\"+v) + "(?![a-zA-Z]) *", k, x)
    return x


def expand(x):
    def f(x):
        assert isinstance(x, list)
        return [f2(y) for y in x]

    def f2(x):
        assert isinstance(x, tuple)
        if x[0] == 'Header':
            return (x[0], x[1], g(x[2]))
        if x[0] in ('Theorem', 'Paragraph'):
            return (x[0], g(x[1]))
        if x[0] in ('Itemize', 'Enumerate', 'Item'):
            return (x[0], f(x[1]))
        assert False

    def g(x):
        assert isinstance(x, list)
        L = []
        for y in x:
            assert isinstance(y, tuple)
            if y[0] == 'emph':
                L.append((y[0], g(y[1])))
            elif y[0] == 'abbrev':
                L.extend(g(parse_inline(abbrevs[y[1]])))
            elif y[0] in ('math', 'mathfull'):
                L.append((y[0], process_matrix(expand_symbols(y[1]))))
            else:
                L.append(y)
        return L

    return {'meta': x['meta'], 'doc': f(x['doc'])}
