/*
 Copyright 2009-2013 Luc Saffre
 This file is part of the Lino project.
 Lino is free software; you can redistribute it and/or modify 
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 3 of the License, or
 (at your option) any later version.
 Lino is distributed in the hope that it will be useful, 
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the 
 GNU General Public License for more details.
 You should have received a copy of the GNU General Public License
 along with Lino; if not, see <http://www.gnu.org/licenses/>.
*/

// lino.js --- generated Thu Sep  5 13:38:41 2013 by Lino version 1.6.11.
Ext.BLANK_IMAGE_URL = '/media/extjs/resources/images/default/s.gif';
LANGUAGE_CHOICES = [ [ "en", "Englisch" ], [ "fr", "Franz\u00f6sisch" ], [ "de", "Deutsch" ], [ "nl", "Niederl\u00e4ndisch" ] ];
MEDIA_URL = "/media";

/* MonthPickerPlugin: thanks to keypoint @ sencha forum
   http://www.sencha.com/forum/showthread.php?74002-3.x-Ext.ux.MonthMenu&p=356860#post356860
*/
Ext.namespace('Ext.ux'); 

Ext.ux.MonthPickerPlugin = function() { 
    var picker; 
    var oldDateDefaults; 

    this.init = function(pk) { 
        picker = pk; 
        picker.onTriggerClick = picker.onTriggerClick.createSequence(onClick); 
        picker.getValue = picker.getValue.createInterceptor(setDefaultMonthDay).createSequence(restoreDefaultMonthDay); 
        picker.beforeBlur = picker.beforeBlur.createInterceptor(setDefaultMonthDay).createSequence(restoreDefaultMonthDay); 
    }; 

    function setDefaultMonthDay() { 
        oldDateDefaults = Date.defaults.d; 
        Date.defaults.d = 1; 
        return true; 
    } 

    function restoreDefaultMonthDay(ret) { 
        Date.defaults.d = oldDateDefaults; 
        return ret; 
    } 

    function onClick(e, el, opt) { 
        var p = picker.menu.picker; 
        p.activeDate = p.activeDate.getFirstDateOfMonth(); 
        if (p.value) { 
            p.value = p.value.getFirstDateOfMonth(); 
        } 

        p.showMonthPicker(); 
         
        if (!p.disabled) { 
            p.monthPicker.stopFx(); 
            p.monthPicker.show(); 

            p.mun(p.monthPicker, 'click', p.onMonthClick, p); 
            p.mun(p.monthPicker, 'dblclick', p.onMonthDblClick, p); 
            p.onMonthClick = p.onMonthClick.createSequence(pickerClick); 
            p.onMonthDblClick = p.onMonthDblClick.createSequence(pickerDblclick); 
            p.mon(p.monthPicker, 'click', p.onMonthClick, p); 
            p.mon(p.monthPicker, 'dblclick', p.onMonthDblClick, p); 
        } 
    } 

    function pickerClick(e, t) { 
        var el = new Ext.Element(t); 
        if (el.is('button.x-date-mp-cancel')) { 
            picker.menu.hide(); 
        } else if(el.is('button.x-date-mp-ok')) { 
            var p = picker.menu.picker; 
            p.setValue(p.activeDate); 
            p.fireEvent('select', p, p.value); 
        } 
    } 

    function pickerDblclick(e, t) { 
        var el = new Ext.Element(t); 
        if (el.parent() 
            && (el.parent().is('td.x-date-mp-month') 
            || el.parent().is('td.x-date-mp-year'))) { 

            var p = picker.menu.picker; 
            p.setValue(p.activeDate); 
            p.fireEvent('select', p, p.value); 
        } 
    } 
}; 

Ext.preg('monthPickerPlugin', Ext.ux.MonthPickerPlugin);  

//~ /* 
  //~ http://www.diloc.de/blog/2008/03/05/how-to-submit-ext-forms-the-right-way/
//~ */
//~ /**
 //~ * This submit action is basically the same as the normal submit action,
 //~ * only that it uses the fields getSubmitValue() to compose the values to submit,
 //~ * instead of looping over the input-tags in the form-tag of the form.
 //~ *
 //~ * To use it, just use the OOSubmit-plugin on either a FormPanel or a BasicForm,
 //~ * or explicitly call form.doAction('oosubmit');
 //~ *
 //~ * @param {Object} form
 //~ * @param {Object} options
 //~ */
//~ Ext.ux.OOSubmitAction = function(form, options){
    //~ Ext.ux.OOSubmitAction.superclass.constructor.call(this, form, options);
//~ };

//~ Ext.extend(Ext.ux.OOSubmitAction, Ext.form.Action.Submit, {
    //~ /**
    //~ * @cfg {boolean} clientValidation Determines whether a Form's fields are validated
    //~ * in a final call to {@link Ext.form.BasicForm#isValid isValid} prior to submission.
    //~ * Pass <tt>false</tt> in the Form's submit options to prevent this. If not defined, pre-submission field validation
    //~ * is performed.
    //~ */
    //~ type : 'oosubmit',

    //~ // private
    //~ /**
     //~ * This is nearly a copy of the original submit action run method
     //~ */
    //~ run : function(){
        //~ var o = this.options;
        //~ var method = this.getMethod();
        //~ var isPost = method == 'POST';

        //~ var params = this.options.params || {};
        //~ if (isPost) Ext.applyIf(params, this.form.baseParams);

        //~ //now add the form parameters
        //~ this.form.items.each(function(field)
        //~ {
            //~ if (!field.disabled)
            //~ {
                //~ //check if the form item provides a specialized getSubmitValue() and use that if available
                //~ if (typeof field.getSubmitValue == "function")
                    //~ params[field.getName()] = field.getSubmitValue();
                //~ else
                    //~ params[field.getName()] = field.getValue();
            //~ }
        //~ });

        //~ //convert params to get style if we are not post
        //~ if (!isPost) params=Ext.urlEncode(params);

        //~ if(o.clientValidation === false || this.form.isValid()){
            //~ Ext.Ajax.request(Ext.apply(this.createCallback(o), {
                //~ url:this.getUrl(!isPost),
                //~ method: method,
                //~ params:params, //add our values
                //~ isUpload: this.form.fileUpload
            //~ }));

        //~ }else if (o.clientValidation !== false){ // client validation failed
            //~ this.failureType = Ext.form.Action.CLIENT_INVALID;
            //~ this.form.afterAction(this, false);
        //~ }
    //~ },

//~ });
//~ //add our action to the registry of known actions
//~ Ext.form.Action.ACTION_TYPES['oosubmit'] = Ext.ux.OOSubmitAction;




/**
JC Watsons solution (adapted to ExtJS 3.3.1 by LS) is elegant and simple:
`A "fix" for unchecked checkbox submission  behaviour
<http://www.sencha.com/forum/showthread.php?28449>`_

Added special handling for checkbox inputs. 
ExtJS defines disabled checkboxes `readonly`, not `disabled` as for other inputs.

*/
Ext.lib.Ajax.serializeForm = function(form) {
    //~ console.log('20120203 linolib.js serializeForm',form);
    var fElements = form.elements || (document.forms[form] || Ext.getDom(form)).elements, 
        hasSubmit = false, 
        encoder = encodeURIComponent, 
        name, 
        data = '', 
        type, 
        hasValue;

    Ext.each(fElements, function(element){
        name = element.name;
        type = element.type;

        if (!element.disabled && name && !(type == 'checkbox' && element.readonly)) {
            if (/select-(one|multiple)/i.test(type)) {
                Ext.each(element.options, function(opt){
                    if (opt.selected) {
                        hasValue = opt.hasAttribute ? opt.hasAttribute('value') : opt.getAttributeNode('value').specified;
                        data += String.format("{0}={1}&", encoder(name), encoder(hasValue ? opt.value : opt.text));
                    }
                });
            } else if (!(/file|undefined|reset|button/i.test(type))) {
                //~ if (!(/radio|checkbox/i.test(type) && !element.checked) && !(type == 'submit' && hasSubmit)) {
                if (!(type == 'submit' && hasSubmit)) {
                    if (type == 'checkbox') {
                        //~ console.log('20111001',element,'data += ',encoder(name) + '=' + (element.checked ? 'on' : 'off') + '&');
                        data += encoder(name) + '=' + (element.checked ? 'on' : 'off') + '&';
                    } else {
                        //~ console.log('20111001',element,'data += ',encoder(name) + '=' + encoder(element.value) + '&');
                        data += encoder(name) + '=' + encoder(element.value) + '&';
                    }
                    hasSubmit = /submit/i.test(type);
                }
            }
        //~ } else {
            //~ console.log(name,type,element.readonly);
        }
    });
    return data.substr(0, data.length - 1);
};



/*
Set a long timeout of fifteen minutes. 
See /blog/2012/0307
*/
Ext.Ajax.timeout = 15 * 60 * 1000; 

/*
 * Thanks to 
 * `huuze <http://stackoverflow.com/users/10040/huuuze>`_ for the question
 * and to 
 * `chrisv <http://stackoverflow.com/users/683808/chrisv>`_
 * for the answer on
 * http://stackoverflow.com/questions/3764589/how-do-i-include-django-1-2s-csrf-token-in-a-javascript-generated-html-form/5485616#5485616
 * 
 * */
 
Ext.Ajax.on('beforerequest', function (conn, options) {
   if (!(/^http:.*/.test(options.url) || /^https:.*/.test(options.url))) {
     if (typeof(options.headers) == "undefined") {
       options.headers = {'X-CSRFToken': Ext.util.Cookies.get('csrftoken')};
     } else {
       options.headers.extend({'X-CSRFToken': Ext.util.Cookies.get('csrftoken')});
     }                        
   }
}, this);


/*
My fix for the "Cannot set QuickTips dismissDelay to 0" bug,
see http://www.sencha.com/forum/showthread.php?183515 
*/
Ext.override(Ext.QuickTip,{
  showAt : function(xy){
        var t = this.activeTarget;
        //~ console.log("20120224 QuickTip.showAt",this.title,this.dismissDelay,t.dismissDelay);
        if(t){
            if(!this.rendered){
                this.render(Ext.getBody());
                this.activeTarget = t;
            }
            if(t.width){
                this.setWidth(t.width);
                this.body.setWidth(this.adjustBodyWidth(t.width - this.getFrameWidth()));
                this.measureWidth = false;
            } else{
                this.measureWidth = true;
            }
            this.setTitle(t.title || '');
            this.body.update(t.text);
            this.autoHide = t.autoHide;
            // bugfix by Luc 20120226
            if (t.dismissDelay != undefined) this.dismissDelay = t.dismissDelay;
            //~ this.dismissDelay = t.dismissDelay || this.dismissDelay;
            if(this.lastCls){
                this.el.removeClass(this.lastCls);
                delete this.lastCls;
            }
            if(t.cls){
                this.el.addClass(t.cls);
                this.lastCls = t.cls;
            }
            if(this.anchor){
                this.constrainPosition = false;
            }else if(t.align){ 
                xy = this.el.getAlignToXY(t.el, t.align);
                this.constrainPosition = false;
            }else{
                this.constrainPosition = true;
            }
        }
        Ext.QuickTip.superclass.showAt.call(this, xy);
    }
});

/*
Another hack. See /docs/blog/2012/0228
*/
Ext.Element.addMethods(
    function() {
        var VISIBILITY      = "visibility",
            DISPLAY         = "display",
            HIDDEN          = "hidden",
            NONE            = "none",
            XMASKED         = "x-masked",
            XMASKEDRELATIVE = "x-masked-relative",
            data            = Ext.Element.data;

        return {
            
            mask : function(msg, msgCls) {
                var me  = this,
                    dom = me.dom,
                    dh  = Ext.DomHelper,
                    EXTELMASKMSG = "ext-el-mask-msg",
                    el,
                    mask;
                // removed the following lines. See /docs/blog/2012/0228
                //~ if (!(/^body/i.test(dom.tagName) && me.getStyle('position') == 'static')) {
                    //~ console.log(20120228,dom.tagName,me);
                    //~ me.addClass(XMASKEDRELATIVE); 
                //~ }
                if (el = data(dom, 'maskMsg')) {
                    el.remove();
                }
                if (el = data(dom, 'mask')) {
                    el.remove();
                }

                mask = dh.append(dom, {cls : "ext-el-mask"}, true);
                data(dom, 'mask', mask);

                me.addClass(XMASKED);
                mask.setDisplayed(true);
                
                if (typeof msg == 'string') {
                    var mm = dh.append(dom, {cls : EXTELMASKMSG, cn:{tag:'div'}}, true);
                    data(dom, 'maskMsg', mm);
                    mm.dom.className = msgCls ? EXTELMASKMSG + " " + msgCls : EXTELMASKMSG;
                    mm.dom.firstChild.innerHTML = msg;
                    mm.setDisplayed(true);
                    mm.center(me);
                }
                
                
                if (Ext.isIE && !(Ext.isIE7 && Ext.isStrict) && me.getStyle('height') == 'auto') {
                    mask.setSize(undefined, me.getHeight());
                }
                
                return mask;
            }

            
        };
    }()
);



Ext.namespace('Lino');
    
    

//~ Lino.subst_user_field = new Ext.form.ComboBox({});
//~ Lino.subst_user = null;
Lino.insert_subst_user = function(p){
    //~ console.log('20120714 insert_subst_user',Lino.subst_user,p);
    //~ if (Lino.subst_user_field.getValue()) {
    if (p.su) return;
    if (Lino.subst_user) {
        //~ p.su = Lino.subst_user_field.getValue();
        p.su = Lino.subst_user;
    //~ } else {
        //~ delete p.su;
    }
    //~ console.log('20120714 insert_subst_user -->',Lino.subst_user,p);
}

Lino.login_window = null;


Lino.show_login_window = function(on_login) {
  //~ console.log('20121103 show_login_window',arguments);
  //~ var current_window = Lino.current_window;
  if (Lino.login_window == null) {
    
      function do_login() { 
            Lino.viewport.loadMask.show()
            //~ Lino.body_loadMask.show()
            login_panel.getForm().submit({ 
                method:'POST', 
                waitTitle:'Connecting', 
                waitMsg:'Sending data...',
                success:function(){ 
                  //~ console.log('20121104 logged in',arguments);
                  Lino.login_window.hide();
                  Lino.close_all_windows();
                  Lino.viewport.loadMask.hide();
                  if (typeof on_login == 'string') {
                      //~ console.log("20130829 on_login",on_login);
                      //~ alert("20130829 on_login gonna load_url");
                      Lino.load_url(on_login);
                      //~ eval(on_login);
                  }
                  //~ Lino.body_loadMask.hide();
                },
                failure: function(form,action) { 
                  //~ this.loadMask.hide();
                  Lino.on_submit_failure(form,action);
                  Lino.viewport.loadMask.hide()
                  //~ Lino.body_loadMask.hide()
                  //~ if (Lino.current_window) Lino.current_window.main_item.loadMask.hide()
                }
                //~ failure:function(form, action){ 
                    //~ alert_msg
                    //~ if(action.failureType == 'server'){ 
                        //~ obj = Ext.util.JSON.decode(action.response.responseText); 
                        //~ Ext.Msg.alert('Login Failed!', obj.errors.reason); 
                    //~ }else{ 
                        //~ Ext.Msg.alert('Warning!', 'Authentication server is unreachable : ' + action.response.responseText); 
                    //~ } 
                    //~ Lino.login_panel.getForm().reset(); 
                //~ } 
            }); 
      };
    
      var login_button = new Ext.Button({ 
        text:"Anmelden",
        formBind: true,	 
        // Function that fires when user clicks the button 
        handler: do_login});
    
      var login_panel = new Ext.FormPanel({ 
        //~ inspired by http://www.sencha.com/learn/a-basic-login/
        autoHeight:true,
        labelWidth:90,
        url:'/auth', 
        frame:true, 
        defaultType:'textfield',
        monitorValid:true,
        items:[{ 
            fieldLabel:"Benutzername", 
            id: 'username',
            name:'username', 
            autoHeight:true,
            allowBlank:false 
        },{ 
            fieldLabel:"Passwort", 
            name:'password', 
            inputType:'password', 
            autoHeight:true,
            allowBlank:false 
        }],        
        buttons:[ login_button ]});
        
      Lino.login_window = new Ext.Window({
          layout:'fit',
          defaultButton: 'username',
          width:300,
          title:"Anmelden", 
          autoHeight:true,
          modal: true,
          closeAction: "hide",
          keys: {
            key: Ext.EventObject.ENTER,
            fn: function() { do_login()}
          },
          //~ defaultButton: login_button,
          //~ height:'auto',
          //~ closable: false,
          //~ resizable: false,
          //~ plain: true,
          //~ border: false,
          items: [login_panel] });
  };
  Lino.login_window.show();
};

Lino.logout = function(id,name) {
    //~ console.log('20121104 gonna log out',arguments);
    //~ Lino.do_action
    Lino.call_ajax_action(Lino.viewport,'GET','/auth',{},'logout',undefined,undefined,function(){
        //~ console.log('20121104 logged out',arguments);
        //~ Lino.login_window.hide();
        Lino.close_all_windows();
    })
}

Lino.set_subst_user = function(id,name) {
    //~ console.log(20130723,'Lino.set_subst_user',id,name,Lino.current_window,Lino.viewport);
    Lino.subst_user = id;
//~ 
    if (Lino.current_window) 
        Lino.current_window.main_item.set_base_param("su",id);
    if (Lino.viewport) 
        Lino.permalink_handler(Lino.current_window)();
}



//~ Lino.select_subst_user = function(cmp,rec,value){
    //~ Lino.subst_user=value;
    //~ console.log(20120713,rec);
//~ }
    
Lino.current_window = null;
Lino.window_history = Array();
    
Lino.chars2width = function(cols) {  return cols * 9; }
Lino.rows2height = function(cols) {  return cols * 20; }



Lino.MainPanel = {
  is_home_page : false,
  setting_param_values : false,
  config_containing_window : function(wincfg) { }
  ,init_containing_window : function(win) { }
  ,is_loading : function() { 
      if (!this.rendered) return true;
      //~ return (Ext.select('.x-loading-msg').elements.length > 0);
      return true; 
    } 
  ,do_when_clean : function(auto_save,todo) { todo() }
  ,get_master_params : function() {
    var p = {}
    p['mt'] = this.content_type; 
    rec = this.get_current_record()
    if (rec) {
      if (rec.phantom) {
          p['mk'] = undefined; 
      }else{
          p['mk'] = rec.id; 
      }
    } else {
      p['mk'] = undefined;
    }
    //~ console.log('get_master_params returns',p,'using record',rec);
    return p;
  }
  ,get_permalink : function() {
    //~ var p = this.main_item.get_base_params() || {};
    var p = Ext.apply({},this.get_base_params());
    delete p.fmt;
    //~ if (p.fmt) delete p.fmt;
    Ext.apply(p,this.get_permalink_params());
    
    if (this.toggle_params_panel_btn) {
        p.sp = this.toggle_params_panel_btn.pressed;
        //~ if (this.toggle_params_panel_btn.pressed == this.params_panel_hidden) {
          //~ p.sp = true;
        //~ }
    }
    
    //~ Lino.insert_subst_user(p);
     //~ p.fmt = 'html';
    //~ console.log('get_permalink',p,this.get_permalink_params());
    if (this.is_home_page)
        //~ var url = '';
        var url = '/';
    else 
        var url = this.get_permalink_url();
    if (p.su == null) 
        delete p.su;
    if (Ext.urlEncode(p)) url = url + "?" + Ext.urlEncode(p);
    return url;
  }
  ,get_record_url : function(record_id) {
      var url = '/api' + this.ls_url
      //~ var url = this.containing_window.config.url_data; // ls_url;
      url += '/' + (record_id === undefined ? '-99999' : String(record_id));
      //~ if (record_id !== undefined) url += '/' + String(record_id);
      //~ url += '/' + String(record_id);
      return url;
  }
  ,get_permalink_url : function() {
      return '/api' + this.ls_url;
  }
  ,get_permalink_params : function() {
      //~ return {an:'grid'};
      var p = {};
      if (this.action_name)
          p.an = this.action_name;
      this.add_param_values(p,false)
      return p;
  }
  ,set_status : function(status) {}
  ,get_status : function() { return {}}
  ,refresh : function() {}
  ,get_base_params : function() { 
    var p = {};
    Lino.insert_subst_user(p);
    return p;
  }
  ,add_params_panel : function (tbar) {
      if (this.params_panel) {
        this.toggle_params_panel_btn = new Ext.Button({ scope:this, 
          //~ text: "$_("[parameters]")", // gear
          iconCls: 'x-tbar-parameters',
          tooltip:"Parameter-Panel ein- bzw. ausblenden",
          enableToggle: true,
          //~ pressed: ! this.params_panel.hidden,
          pressed: ! this.params_panel_hidden,
          toggleHandler: function(btn,state) { 
            //~ if (this.params_panel.isVisible()) 
                //~ this.params_panel.hide();
            //~ else
                //~ this.params_panel.show();
            //~ console.log("20120210 add_params_panel",state,this.params_panel);
            if (state) {
              this.params_panel.show();
              this.params_panel.doLayout();
            } else this.params_panel.hide();
            this.get_containing_window().doLayout();
          }
        });
        tbar = tbar.concat([this.toggle_params_panel_btn]);
        var t = this;
        var refresh = function() {if (!t.setting_param_values) {t._force_dirty = true; t.refresh();}}
        Ext.each(this.params_panel.fields,function(f) {
          //~ f.on('valid',function() {t.refresh()});
          if (f instanceof Ext.form.Checkbox) {
              f.on('check',refresh);
          } else if (f instanceof Ext.DatePicker) {
              f.on('select',refresh);
          } else if (f instanceof Ext.form.TriggerField) {
              f.on('select',refresh);
              //~ f.on('change',refresh);
              //~ f.on('valid',refresh);
          } else {
              if (! f.on) 
                  console.log("20121010 no method 'on'",f);
              else
                  f.on('change',refresh);
            }
          });
      }
      return tbar;
  }
  ,add_param_values : function (p,unused_force_dirty) {
    if (this.params_panel) {
      /* 
      * 20120918 add param_values to the request string 
      * *only if the params_form is dirty*.
      * Otherwise Actor.default_params() would never be used.
      *
      * 20121023 But IntegClients.params_default has non-empty default values. 
      * Users must have the possibility to make them empty.
      * 
      * 20130605 : added `force_dirty` parameter because Checkbox fields don't 
      * mark their form as dirty when check is fired.
      * 
      * 20130721 : `force_dirty` not as a parameter but as 
      * `this._force_dirty` because
      * 
      */
      if (this._force_dirty || this.params_panel.form.isDirty()) {
        p.pv = this.get_param_values();
        console.log("20130605 form.isDirty",p);
      }else{
        console.log("20130605 form not dirty:",this.params_panel.form);
        if (this.status_param_values) 
          p.pv = Lino.fields2array(
            this.params_panel.fields,this.status_param_values);
      }
      //~ if (!this.params_panel.form.isDirty()) return;
      //~ p.pv = this.get_param_values();
      //~ console.log("20120203 add_param_values added pv",pv,"to",p);
    }
  },
  get_param_values : function() { // similar to get_field_values()
      return Lino.fields2array(this.params_panel.fields);
  },
  set_param_values : function(pv) {
    if (this.params_panel) {
      //~ console.log('20120203 MainPanel.set_param_values', pv);
      this.status_param_values = pv;
      //~ this.params_panel.form.suspendEvents(false);
      this.setting_param_values = true;
      if (pv) { 
          this.params_panel.form.my_loadRecord(pv);
      } else { 
        this.params_panel.form.reset(); 
      }
      this.setting_param_values = false;
      //~ this.params_panel.form.resumeEvents();
    }
  }
};




Lino.Viewport = Ext.extend(Ext.Viewport,Lino.MainPanel);
Lino.Viewport = Ext.extend(Lino.Viewport,{
  layout : "fit"
  ,is_home_page : true
  ,initComponent : function(){
    Lino.Viewport.superclass.initComponent.call(this);
    this.on('render',function(){
      this.loadMask = new Ext.LoadMask(this.el,{msg:"Bitte warten..."});
      //~ console.log("20121118 Lino.viewport.loadMask",this.loadMask);
    },this);
  }
  ,get_base_params : function() { 
    var p = {};
    Lino.insert_subst_user(p);
    return p;
  }
  ,refresh : function() {
      var caller = this;
      //~ console.log("20121120 Lino.Viewport.refresh()");
      if (caller.loadMask) caller.loadMask.show();
      var success = function(response) {
        if (caller.loadMask) caller.loadMask.hide();
        if (response.responseText) {
          var result = Ext.decode(response.responseText);
          //~ console.log('Lino.do_action()',action.name,'result is',result);
          if (result.html) {
              Ext.getCmp('main_area').update(result.html);
          }
          if (result.message) {
              if (result.alert) {
                  //~ Ext.MessageBox.alert('Alert',result.alert_msg);
                  Ext.MessageBox.alert('Alert',result.message);
              } else {
                  Lino.notify(result.message);
              }
          }
          
          if (result.notify_msg) Lino.notify(result.notify_msg);
          if (result.js_code) { 
            var jsr = result.js_code(caller);
            //~ console.log('Lino.do_action()',action,'returned from js_code in',result);
          };
        }
      };
      var action = {
        url : '/api/main_html',
        waitMsg: "Bitte warten...",
        failure: Lino.ajax_error_handler(caller),
        success: success,
        method: 'GET',
        params: {}
      };
      Lino.insert_subst_user(action.params);
      Ext.Ajax.request(action);
    
  }
});




Lino.open_window = function(win,st,requesting_panel) {
  //~ console.log("20120918 Lino.open_window()",win,st);
  var cw = Lino.current_window;
  if (cw) {
    //~ console.log("20120918 Lino.open_window() save current status",cw.main_item.get_status());
    Lino.window_history.push({
      window:cw,
      status:cw.main_item.get_status()
    });
  }
  Lino.current_window = win;
  //~ if (st.su) 
      //~ Lino.subst_user_field.setValue(st.su);
  win.main_item.set_status(st,requesting_panel);
  win.show();
};

Lino.load_url = function(url) {
    //~ foo.bar.baz = 2; 
    //~ console.log("20121120 Lino.load_url()");
    //~ Lino.body_loadMask.show();
    Lino.viewport.loadMask.show();
    //~ location.replace(url);
    document.location = url;
}

Lino.close_window = function(status_update) {
  var cw = Lino.current_window;
  var ww = Lino.window_history.pop();
  if (ww) {
    //~ if (status_update) Ext.apply(ww.status,status_update);
    if (status_update) status_update(ww);
    ww.window.main_item.set_status(ww.status);
    Lino.current_window = ww.window;
  } else {
    Lino.current_window = null;
  }
  if (cw) cw.hide_really();
};

Lino.close_all_windows = function() {
  if (Lino.window_history.length == 0) {
      //~ Lino.viewport.refresh();
      var url =  "/"
      //~ console.log("20121120 Lino.close_all_windows() : no window_history");
      //~ if (ADMIN_URL) 
      var p = {};
      Lino.insert_subst_user(p)
      if (Ext.urlEncode(p)) url = url + "?" + Ext.urlEncode(p);
      Lino.load_url(url);
  } else {
    //~ console.log("20121120 Lino.close_all_windows() with window_history");
    while (Lino.window_history.length > 0) {
      Lino.close_window();
      //~ Lino.window_history.pop().hide_really();
    }
  }
  //~ Lino.current_window = null;
  //~ Lino.close_window();
  //~ var ww = 
}

Lino.kill_current_window = function() {
  var cw = Lino.current_window;
  Lino.current_window = null;
  if (cw) cw.hide_really();
};

Lino.calling_window = function() {
    if (Lino.window_history.length) return Lino.window_history[Lino.window_history.length-1];
}

//~ Lino.WindowAction = function(mainItemClass,windowConfig,mainConfig,ppf) {
Lino.WindowAction = function(windowConfig,main_item_fn) {
    //~ if(!mainConfig) mainConfig = {};
    //~ mainConfig.is_main_window = true;
    this.windowConfig = windowConfig;
    this.main_item_fn = main_item_fn;
    //~ if (ppf) mainConfig.params_panel.fields = ppf;
    //~ this.mainConfig = mainConfig;
    //~ this.mainItemClass = mainItemClass;
};

Lino.WindowAction = Ext.extend(Lino.WindowAction,{
    window : null,
    //~ mainItemClass: null,
    get_window : function() {
      //~ if(mainConfig) Ext.apply(this.mainConfig,mainConfig);
      if (this.window == null)  {
          //~ this.windowConfig.main_item = new this.mainItemClass(this.mainConfig);
          this.windowConfig.main_item = this.main_item_fn();
          this.window = new Lino.Window(this.windowConfig);
      }
      return this.window;
    },
    run : function(requesting_panel,status) {
      //~ console.log('20120625 window_action.run()',this)
      Lino.open_window(this.get_window(),status,requesting_panel);
    }
  
});


Lino.PanelMixin = {
  get_containing_window : function (){
      if (this.containing_window) return this.containing_window;
      return this.containing_panel.get_containing_window();
  }
  ,set_window_title : function(title) {
    //~ this.setTitle(title);
    var cw = this.get_containing_window();

    //~ if (cw) {
    //~ if (cw && cw.closable) {
    if (cw && !cw.main_item.hide_window_title) {
      //~ console.log('20111202 set_window_title(',title,') for',this.containing_window);
      //~ if (! this.containing_window.rendered) console.log("WARNING: not rendered!");
      cw.setTitle(title);
    //~ } else {
      //~ document.title = title;
    }
    //~ else console.log('20111202 not set_window_title(',title,') for',this);
  }
  
};


// Lino.status_bar = new Ext.ux.StatusBar({defaultText:'Lino version 1.6.11.'});
Lino.status_bar = new Ext.ux.StatusBar({
    autoClear: 10000, // 10 seconds
    defaultText:'Lino Welfare 1.1.9.'
    });



Lino.edit_tinymce_text = function(panel,options) {
  // `panel` is the RichTextPanel
  //~ console.log(20111220,panel);
  //~ var rec = panel.get_current_record();
  var rec = panel.containing_panel.get_current_record();
  var value = rec ? rec.data[panel.editor.name] : '';
  var saving = false;
  var todo_after_save = false;
  var discard_changes = false;
  
  
  function save() {
    //~ if (todo_after_save) {alert('tried to save again'); return; }
    if (saving) {alert('tried to save again'); return; }
    //~ var url = panel.containing_window.main_item.get_record_url(rec.id);
    var url = panel.containing_panel.get_record_url(rec.id);
    var params = Ext.apply({},panel.containing_panel.get_base_params());
    params[panel.editor.name] = editor.getValue();
    //~ params.su = Lino.subst_user;
    //~ Lino.insert_subst_user(params);
    var a = { 
      params: params, 
      method: 'PUT',
      url: url,
      failure: function() {
          //~ if (editor.ed.getContainer()) 
          editor.ed.setProgressState(0);
          todo_after_save = false;
          saving = false;
          console.log('tinymce.save() failed. sorry.',arguments);
        },
      success: function() {
        saving = false;
        //~ if (editor.ed.getContainer()) 
        editor.ed.setProgressState(0);
        rec.data[panel.editor.name] = editor.getValue();
        if(todo_after_save) {
            var fn = todo_after_save;
            todo_after_save = false;
            fn();
        }
        //~ panel.containing_window.set_current_record(rec);
        panel.refresh();
      }
    };
    //~ if (editor.ed.getContainer()) 
    editor.ed.setProgressState(1); // Show progress
    saving = true;
    //~ console.log(a);
    Ext.Ajax.request(a);
  };
  function save_callback() {
      save();
      //~ save(function(){editor.ed.setDirty(false);})
      /* return true have the save button disabled.  
      That's not perfect because the PUT is asynchronous 
      and the response is not yet known.
      */
      return true;
  }
  //~ var actions = [
    //~ {text:"Save",handler:save}
  //~ ]; 
  //~ console.log(20110610,panel.editor.disabled);
  var settings = {};
  Ext.apply(settings,{
        readonly: panel.editor.disabled,
        //~ language: "de",
        plugins : "save,emotions,spellchecker,advhr,insertdatetime,preview,table,searchreplace,template", 
        // Theme options - button# indicated the row# only
        theme_advanced_buttons1 : "save,cancel,|,bold,italic,underline,|,justifyleft,justifycenter,justifyright,fontselect,fontsizeselect,formatselect,|,search,replace",
        theme_advanced_buttons2 : "cut,copy,paste,template,|,bullist,numlist,|,outdent,indent,|,undo,redo,|,link,unlink,anchor,image,|,code,preview,|,forecolor,backcolor",
        theme_advanced_buttons3 : "insertdate,inserttime,|,spellchecker,advhr,,removeformat,|,sub,sup,|,charmap,emotions,|,tablecontrols",      
        theme_advanced_resizing : false,
        convert_urls : false,
        save_onsavecallback : save_callback,
        save_enablewhendirty : true
        //~ save_oncancelcallback: on_cancel
  });
  Ext.apply(settings,options);
  var editor = new Ext.ux.TinyMCE({
      value : value,
      tinymceSettings: settings
    });
  var win = new Ext.Window({
    title: rec.title, 
    //~ bbar: actions,
    layout: 'fit',
    items: editor,
    width: 600, 
    height:500,
    minWidth: 100,
		minHeight: 100,
    modal: true,
    resizable: true,
    maximizable: true,
    //~ maximized: true,
    //~ closeAction: "close"
    closeAction: "hide"
    //~ hideMode: "offsets",
    //~ constrainHeader: true,
    //~ bodyStyle: 'padding: 10px'
  });

  //~ win.on('beforeclose',function() {
  win.on('beforehide',function() {
    if (todo_after_save) return false;
    if (discard_changes) return true;
    if (editor.isDirty()) {
        //~ var ok = false;
        //~ var allowClose = true;
        var config = {title:"Bestätigung"};
        config.buttons = Ext.MessageBox.YESNOCANCEL;
        config.msg = "Änderungen im Text speichern?";
        config.modal = true;
        config.fn = function(buttonId,text,opt) {
          //~ console.log('do_when_clean',buttonId)
          if (buttonId == "yes") {
              /* we cancel this close, but save()'s onSuccess will call again.*/
              //~ allowClose = false;
              todo_after_save = function(){win.hide();}
              editor.ed.execCommand('mceSave');
              //~ editor.ed.save(function(){win.close();});
          } else if (buttonId == "no") { 
              discard_changes = true;
              win.hide()
          //~ } else if (buttonId == "cancel") { 
            //~ ok = true;
              //~ allowClose = false;
          //~ } else { 
            //~ console.log('unknwon buttonId:',buttonId);
          }
        }
        Ext.MessageBox.show(config);
        return false;
        //~ return allowClose;
    }
  });
  win.show();
}







/* 
  Originally copied from Ext JS Library 3.3.1
  Modifications by Luc Saffre : 
  - rendering of phantom records
  - fire afteredit event
  - react on dblclcik, not on single click

 */
Lino.CheckColumn = Ext.extend(Ext.grid.Column, {

    processEvent : function(name, e, grid, rowIndex, colIndex){
        //~ console.log('20110713 Lino.CheckColumn.processEvent',name)
        if (name == 'click') {
        //~ if (name == 'mousedown') {
        //~ if (name == 'dblclick') {
            return this.toggleValue(grid, rowIndex, colIndex);
        } else {
            return Ext.grid.ActionColumn.superclass.processEvent.apply(this, arguments);
        }
    },
    
    toggleValue : function (grid,rowIndex,colIndex) {
        var record = grid.store.getAt(rowIndex);
        var dataIndex = grid.colModel.getDataIndex(colIndex);
        // 20120514
        //~ if(record.data.disabled_fields && record.data.disabled_fields[dataIndex]) {
          //~ Lino.notify("Dieses Feld ist deaktiviert");
          //~ return false;
        //~ }
      
        //~ if (dataIndex in record.data['disabled_fields']) {
            //~ Lino.notify("This field is disabled.");
            //~ return false;
        //~ }
        var startValue = record.data[dataIndex];
        var value = !startValue;
        //~ record.set(this.dataIndex, value);
        var e = {
            grid: grid,
            record: record,
            field: dataIndex,
            originalValue: startValue,
            value: value,
            row: rowIndex,
            column: colIndex,
            cancel: false
        };
        if(grid.fireEvent("beforeedit", e) !== false && !e.cancel){
        //~ if(grid.fireEvent("validateedit", e) !== false && !e.cancel){
            record.set(dataIndex, value);
            delete e.cancel;
            grid.fireEvent("afteredit", e);
        }
        return false; // Cancel event propagation
    },

    renderer : function(v, p, record){
        if (record.phantom) return '';
        p.css += ' x-grid3-check-col-td'; 
        return String.format('<div class="x-grid3-check-col{0}">&#160;</div>', v ? '-on' : '');
    }

    // Deprecate use as a plugin. Remove in 4.0
    // init: Ext.emptyFn
});

// register ptype. Deprecate. Remove in 4.0
// Ext.preg('checkcolumn', Lino.CheckColumn);

// backwards compat. Remove in 4.0
// Ext.grid.CheckColumn = Lino.CheckColumn;

// register Column xtype
Ext.grid.Column.types.checkcolumn = Lino.CheckColumn;


/* 20110725 : 
Lino.on_tab_activate is necessary 
in contacts.Person.2.dtl 
(but don't ask me why...)
*/
Lino.on_tab_activate = function(item) {
  //~ console.log('activate',item); 
  if (item.rendered && item.doLayout) item.doLayout();
  //~ if (item.rendered) item.doLayout();
}

Lino.TimeField = Ext.extend(Ext.form.TimeField,{
  format: 'H:i',
  increment: 15
  });
Lino.DateField = Ext.extend(Ext.form.DateField,{
  boxMinWidth: Lino.chars2width(11),
  format: 'd.m.Y',
  altFormats: 'd/m/Y|Y-m-d'
  });
Lino.DatePickerField = Ext.extend(Ext.DatePicker,{
  //~ boxMinWidth: Lino.chars2width(11),
  format: 'd.m.Y',
  //~ altFormats: 'd/m/Y|Y-m-d'
  formatDate : function(date){
      //~ console.log("20121203 formatDate",this.name,date);
      return Ext.isDate(date) ? date.dateFormat(this.format) : date;
  }
  });
Lino.DateTimeField = Ext.extend(Ext.ux.form.DateTime,{
  dateFormat: 'd.m.Y',
  timeFormat: 'H:i'
  //~ ,hiddenFormat: 'd.m.Y H:i'
  });
Lino.URLField = Ext.extend(Ext.form.TriggerField,{
  triggerClass : 'x-form-search-trigger',
  //~ triggerClass : 'x-form-world-trigger',
  vtype: 'url',
  onTriggerClick : function() {
    //~ console.log('Lino.URLField.onTriggerClick',this.value)
    //~ document.location = this.value;
    window.open(this.getValue(),'_blank');
  }
});
Lino.IncompleteDateField = Ext.extend(Ext.form.TextField,{
  //~ regex: /^-?\d+-[01]\d-[0123]\d$/,
  //~ regex: /^[0123]\d\.[01]\d\.-?\d+$/,
  maxLength: 10,
  boxMinWidth: Lino.chars2width(10),
  regex: /^[0123]?\d\.[01]?\d\.-?\d+$/,
  regexText: 'Datum im Format JJJJ-MM-TT eingeben (Nullen für unbekannte Teile)'
  });


//~ Lino.make_dropzone = function(cmp) {
    //~ cmp.on('render', function(ct, position){
      //~ ct.el.on({
        //~ dragenter:function(event){
          //~ event.browserEvent.dataTransfer.dropEffect = 'move';
          //~ return true;
        //~ }
        //~ ,dragover:function(event){
          //~ event.browserEvent.dataTransfer.dropEffect = 'move';
          //~ event.stopEvent();
          //~ return true;
        //~ }
        //~ ,drop:{
          //~ scope:this
          //~ ,fn:function(event){
            //~ event.stopEvent();
            //~ console.log(20110516);
            //~ var files = event.browserEvent.dataTransfer.files;
            //~ if(files === undefined){
              //~ return true;
            //~ }
            //~ var len = files.length;
            //~ while(--len >= 0){
              //~ console.log(files[len]);
              //~ // this.processDragAndDropFileUpload(files[len]);
            //~ }
          //~ }
        //~ }
      //~ });
    //~ });
//~ };

//~ Lino.FileUploadField = Ext.ux.form.FileUploadField;

Lino.FileUploadField = Ext.extend(Ext.ux.form.FileUploadField,{
    onRender : function(ct, position){
      Lino.FileUploadField.superclass.onRender.call(this, ct, position);
      this.el.on({
        dragenter:function(event){
          event.browserEvent.dataTransfer.dropEffect = 'move';
          return true;
        }
        ,dragover:function(event){
          event.browserEvent.dataTransfer.dropEffect = 'move';
          event.stopEvent();
          return true;
        }
        ,drop:{
          scope:this
          ,fn:function(event){
            event.stopEvent();
            //~ console.log(20110516);
            var files = event.browserEvent.dataTransfer.files;
            if(files === undefined){
              return true;
            }
            var len = files.length;
            while(--len >= 0){
              console.log(files[len]);
              //~ this.processDragAndDropFileUpload(files[len]);
            }
          }
        }
      });
    }
});

Lino.FileField = Ext.extend(Ext.form.TriggerField,{
  triggerClass : 'x-form-search-trigger',
  editable: false,
  onTriggerClick : function() {
    //~ console.log('Lino.URLField.onTriggerClick',this.value)
    //~ document.location = this.value;
    if (this.getValue()) window.open(MEDIA_URL + '/'+this.getValue(),'_blank');
  }
});

Lino.file_field_handler = function(panel,config) {
  //~ if (instanceof Lino.DetailWrapper) {
  if (panel.action_name == 'insert') {
  //~ if (panel.get_current_record().phantom) {
      panel.has_file_upload = true;

      var f = new Lino.FileUploadField(config);
      //~ Lino.make_dropzone(f);
      return f;
      //~ return new Ext.ux.form.FileUploadField(config);
      //~ return new Lino.FileField(config);
      
  } else {
      //~ return new Lino.URLField(config);
      return new Lino.FileField(config);
  }
}

Lino.VBorderPanel = Ext.extend(Ext.Panel,{
    constructor : function(config) {
      config.layout = 'border';
      delete config.layoutConfig;
      Lino.VBorderPanel.superclass.constructor.call(this,config);
      for(var i=0; i < this.items.length;i++) {
        var item = this.items.get(i);
        if (this.isVertical(item) && item.collapsible) {
          item.on('collapse',this.onBodyResize,this);
          item.on('expand',this.onBodyResize,this);
        }
      }
    },
    isVertical : function(item) {
       return (item.region == 'north' || item.region == 'south' || item.region == 'center');
    },
    onBodyResize: function(w, h){
        //~ console.log('VBorderPanel.onBodyResize',this.title)
      if (this.isVisible()) { // to avoid "Uncaught TypeError: Cannot call method 'getHeight' of undefined."
        var sumflex = 0;
        var availableHeight = this.getInnerHeight();
        var me = this;
        this.items.each(function(item){
          if (me.isVertical(item)) {
              if (item.collapsed || item.flex == 0 || item.flex === undefined) {
                  if (item.rendered) availableHeight -= item.getHeight();
              } else {
                  sumflex += item.flex;
              }
          } 
          
        });
        //~ for(var i=0; i < this.items.length;i++) {
          //~ var item = this.items.get(i);
          //~ // if (this.isVertical(item) && item.getResizeEl()) {
          //~ if (this.isVertical(item)) {
              //~ if (item.collapsed || item.flex == 0 || item.flex === undefined) {
                  //~ // item.syncSize()
                  //~ // item.doLayout()
                  //~ // if (item.region == "north") console.log('region north',item.getHeight(),item.id, item);
                  //~ // if (item.getHeight() == 0) console.log(20100921,'both flex and getHeight() are 0!');
                  //~ availableHeight -= item.getHeight();
              //~ } else {
                  //~ sumflex += item.flex;
                  //~ // console.log(item.flex);
              //~ }
          //~ } 
          //~ // else console.log('non-vertical item in VBoderPanel:',item)
        //~ }
        var hunit = availableHeight / sumflex;
        //~ console.log('sumflex=',sumflex,'hunit=',hunit, 'availableHeight=',availableHeight);
        for(var i=0; i < this.items.length;i++) {
          var item = this.items.get(i);
          if (this.isVertical(item)) {
              if (item.flex != 0 && ! item.collapsed) {
                  item.setHeight(hunit * item.flex);
                  //~ console.log(item.region,' : height set to',item.getHeight());
              }
          }
          //~ else console.log('non-vertical item in VBoderPanel:',item)
        }
      }
      Lino.VBorderPanel.superclass.onBodyResize.call(this, w, h);
    }
});


/*
  modifications to the standard behaviour of a CellSelectionModel:
  
*/
Ext.override(Ext.grid.CellSelectionModel, {
//~ var dummy = {

    handleKeyDown : function(e){
        /* removed because F2 wouldn't pass
        if(!e.isNavKeyPress()){
            return;
        }
        */
        //~ console.log('handleKeyDown',e)
        var k = e.getKey(),
            g = this.grid,
            s = this.selection,
            sm = this,
            walk = function(row, col, step){
                return g.walkCells(
                    row,
                    col,
                    step,
                    g.isEditor && g.editing ? sm.acceptsNav : sm.isSelectable, 
                    sm
                );
            },
            cell, newCell, r, c, ae;

        switch(k){
            case e.ESC:
            case e.PAGE_UP:
            case e.PAGE_DOWN:
                break;
            default:
                // e.stopEvent(); // removed because Browser keys like Alt-Home, Ctrl-R wouldn't work
                break;
        }

        if(!s){
            cell = walk(0, 0, 1); 
            if(cell){
                this.select(cell[0], cell[1]);
            }
            return;
        }

        cell = s.cell;  
        r = cell[0];    
        c = cell[1];    
        
        switch(k){
            case e.TAB:
                if(e.shiftKey){
                    newCell = walk(r, c - 1, -1);
                }else{
                    newCell = walk(r, c + 1, 1);
                }
                break;
            case e.HOME:
                if (! (g.isEditor && g.editing)) {
                  if (!e.hasModifier()){
                      newCell = [r, 0];
                      //~ console.log('home',newCell);
                      break;
                  }else if(e.ctrlKey){
                      var t = g.getTopToolbar();
                      var activePage = Math.ceil((t.cursor + t.pageSize) / t.pageSize);
                      if (activePage > 1) {
                          e.stopEvent();
                          t.moveFirst();
                          return;
                      }
                      newCell = [0, c];
                      break;
                  }
                }
            case e.END:
                if (! (g.isEditor && g.editing)) {
                  c = g.colModel.getColumnCount()-1;
                  if (!e.hasModifier()) {
                      newCell = [r, c];
                      //~ console.log('end',newCell);
                      break;
                  }else if(e.ctrlKey){
                      var t = g.getTopToolbar();
                      var d = t.getPageData();
                      if (d.activePage < d.pages) {
                          e.stopEvent();
                          var self = this;
                          t.on('change',function(tb,pageData) {
                              var r = g.store.getCount()-2;
                              self.select(r, c);
                              //~ console.log('change',r,c);
                          },this,{single:true});
                          t.moveLast();
                          return;
                      } else {
                          newCell = [g.store.getCount()-1, c];
                          //~ console.log('ctrl-end',newCell);
                          break;
                      }
                  }
                }
            case e.DOWN:
                newCell = walk(r + 1, c, 1);
                break;
            case e.UP:
                newCell = walk(r - 1, c, -1);
                break;
            case e.RIGHT:
                newCell = walk(r, c + 1, 1);
                break;
            case e.LEFT:
                newCell = walk(r, c - 1, -1);
                break;
            case e.F2:
                if (!e.hasModifier()) {
                    if (g.isEditor && !g.editing) {
                        g.startEditing(r, c);
                        e.stopEvent();
                        return;
                    }
                    break;
                }
            case e.INSERT:
                if (!e.hasModifier()) {
                    if (g.ls_insert_handler && !g.editing) {
                        e.stopEvent();
                        Lino.show_insert(g);
                        return;
                    }
                    break;
                }
            case e.DELETE:
                if (!e.hasModifier()) {
                    if (!g.editing) {
                        e.stopEvent();
                        Lino.delete_selected(g);
                        return;
                    }
                    break;
                }
            case e.ENTER:
                e.stopEvent();
                g.onCellDblClick(r,c);
                break;
                
        }
        

        if(newCell){
          e.stopEvent();
          r = newCell[0];
          c = newCell[1];
          this.select(r, c); 
          if(g.isEditor && g.editing){ 
            ae = g.activeEditor;
            if(ae && ae.field.triggerBlur){
                ae.field.triggerBlur();
            }
            g.startEditing(r, c);
          }
        //~ } else if (g.isEditor && !g.editing && e.charCode) {
        //~ // } else if (!e.isSpecialKey() && g.isEditor && !g.editing) {
            //~ g.set_start_value(String.fromCharCode(e.charCode));
            //~ // g.set_start_value(String.fromCharCode(k));
            //~ // g.set_start_value(e.charCode);
            //~ g.startEditing(r, c);
            //~ // e.stopEvent();
            //~ return;
        // } else {
          // console.log('20120513',e,g);
        }
        
    }


//~ };
});

 

function PseudoConsole() {
    this.log = function() {};
};
if (typeof(console) == 'undefined') console = new PseudoConsole();

Lino.notify = function(msg) {
  if (msg == undefined) msg = ''; else console.log(msg);
  //~ Ext.getCmp('konsole').update(msg);
  Lino.status_bar.setStatus({
    text: msg,
    iconCls: 'ok-icon',
    clear: true // auto-clear after a set interval
  });
  //~ Ext.getCmp('konsole').setTitle(msg.replace(/\n/g,'<br/>'));
  //~ Ext.getCmp('konsole').update(msg.replace(/\n/g,'<br/>'));
};
Lino.alert = function(msg) {
  //~ if (msg == undefined) msg = ''; else console.log(msg);
  Ext.MessageBox.alert('Notify',msg);
};


//~ Lino.show_about = function() {
  //~ new Ext.Window({
    //~ width: 400, height: 400,
    //~ title: "About",
    //~ html: '<a href="http://www.extjs.com" target="_blank">ExtJS</a> version ' + Ext.version
  //~ }).show();
//~ };

function obj2str(o) {
  if (typeof o != 'object') return String(o);
  var s = '';
  for (var p in o) {
    s += p + ': ' + obj2str(o[p]) + '\n';
  }
  return s;
}

Lino.on_store_exception = function (store,type,action,options,response,arg) {
  //~ throw response;
  console.log("on_store_exception: store=",store,
    "type=",type,
    "action=",action,
    "options=",options,
    "response=",response,
    "arg=",arg);
  if (arg) { console.log(arg.stack)};
};

//~ Lino.on_submit_success = function(form, action) {
   //~ Lino.notify(action.result.message);
   //~ this.close();
//~ };

Lino.on_submit_failure = function(form, action) {
    //~ Lino.notify();
  // action may be undefined
    switch (action.failureType) {
        case Ext.form.Action.CLIENT_INVALID:
            Ext.Msg.alert('Client-side failure', 'Form fields may not be submitted with invalid values');
            break;
        case Ext.form.Action.CONNECT_FAILURE:
            Ext.Msg.alert('Connection failure', 'Ajax communication failed');
            break;
        case Ext.form.Action.SERVER_INVALID:
            Ext.Msg.alert('Server-side failure', action.result.message);
   }
};



/*
Lino.save_wc_handler = function(ww) {
  return function(event,toolEl,panel,tc) {
    var pos = panel.getPosition();
    var size = panel.getSize();
    wc = ww.get_window_config();
    Ext.applyIf(wc,{ 
      x:pos[0],y:pos[1],height:size.height,width:size.width,
      maximized:panel.maximized});
    Lino.do_action(ww,{url:'/window_configs/'+ww.config.permalink_name,params:wc,method:'POST'});
  }
};

*/

Lino.show_in_own_window_button = function(handler) {
  return {
    qtip: "Dieses Panel in eigenem Fenster öffnen", 
    id: "up",
    handler: function(event,toolEl,panel, tc) {
      //~ console.log('20111206 report_window_button',panel,handler);
      handler.run(null,{base_params:panel.containing_panel.get_master_params()});
    }
  }
}




Lino.delete_selected = function(panel) {
  //~ console.log("Lino.delete_selected",panel);
  var recs1 = panel.get_selected();
  var recs = [];
  for ( var i=0; i < recs1.length; i++ ) { if (! recs1[i].phantom) recs.push(recs1[i]); }
  if (recs.length == 0) {
    Lino.notify("Please select at least one record.");
    return;
  };
  if (recs.length == 1) {
      if (recs[0].disable_delete) {
        Lino.alert(recs[0].disable_delete);
        return;
      }
  };
  //~ console.log(recs);
  Ext.MessageBox.show({
    title: "Bestätigung",
    msg: String.format("Es werden {0} Datensätze gelöscht. Sind Sie sicher?",String(recs.length)),
    //~ msg: "Delete " + String(recs.length) + " rows. Are you sure?",
    //~ buttons: Ext.MessageBox.YESNOCANCEL,
    buttons: Ext.MessageBox.YESNO,
    fn: function(btn) {
      if (btn == 'yes') {
        for ( var i=0; i < recs.length; i++ ) {
          Lino.do_action(panel,{
              method:'DELETE',
              url:  '/api' + panel.ls_url + '/' + recs[i].id,
              after_success: panel.after_delete.createDelegate(panel)
          })
        }
        //~ caller.after_delete();
      }
      else Lino.notify("Dann eben nicht.");
    }
  });
};

Lino.action_handler = function (panel,on_success,on_confirm) {
  return function (response) {
    //~ console.log(20120608,panel);
    if (panel instanceof Lino.GridPanel) {
        //~ gridmode = false;
        gridmode = true;
        //~ console.log('20120608 yes');
    } else {
        gridmode = false;
        //~ console.log('20120608 no');
    }
    if (panel.loadMask) panel.loadMask.hide(); // 20120211
    if (!response.responseText) return ;
    var result = Ext.decode(response.responseText);
    //~ console.log('Lino.action_handler()','result is',result,'on_confirm is',on_confirm);
    
    if (result.eval_js) {
        //~ console.log(20120618,result.eval_js);
        eval(result.eval_js);
    }
    
    //~ if (result.goto_record) {
        //~ var js = "Lino." + result.goto_record[0] + '.detail.run';
        //~ var h = eval(js);
        //~ h(panel,{record_id:result.goto_record[1]});
    //~ }
    
    if (result.xcallback) {
        //~ var config = {title:"Bestätigung"};
        var config = {title:result.xcallback.title};
        //~ config.buttons = Ext.MessageBox.YESNOCANCEL;
        //~ config.buttons = Ext.MessageBox.YESNO;
        config.buttons = result.xcallback.buttons;
        config.msg = result.message;
        config.fn = function(buttonId,text,opt) {
          panel.loadMask.show(); 
          //~ Lino.insert_subst_user(p);
          Ext.Ajax.request({
            method: 'GET',
            url: '/callbacks/'+result.xcallback.id + '/' + buttonId,
            //~ params: {bi: buttonId},
            success: Lino.action_handler(panel,on_success,on_confirm)
          });
          //~ Lino.call_ajax_action(panel,'GET',)
        }
        Ext.MessageBox.show(config);
        return;
    }
    
    if (on_success && result.success) on_success(result);
    
    //~ if (on_confirm && result.confirm_message) {
        //~ var config = {title:"Bestätigung"};
        //~ // config.buttons = Ext.MessageBox.YESNOCANCEL;
        //~ config.buttons = Ext.MessageBox.YESNO;
        //~ config.msg = result.confirm_message;
        //~ config.fn = function(buttonId,text,opt) {
          //~ if (buttonId == "yes") {
              //~ on_confirm(panel,undefined,result.step);
          //~ }
        //~ }
        //~ Ext.MessageBox.show(config);
        //~ return;
    //~ }
    //~ if (result.dialog_fn) {
        //~ console.log('20120928 TODO',result.dialog_fn);
    //~ }
    if (result.data_record && ! gridmode) {
        //~ not used
        panel.set_status({data_record:result.data_record});
    }  else if (result.new_status && ! gridmode) {
        //~ not used
        //~ console.log('20120607 new_status');
        panel.set_status(result.new_status);
    } else if (result.goto_record_id != undefined && ! gridmode) {
        //~ Uncaught TypeError: Cannot call method 'run' of undefined 
        panel.load_record_id(result.goto_record_id);
    } 
    
    if (result.message) {
        //~ if (result.alert && ! gridmode) {
        if (result.alert) { // 20120628b 
            //~ Ext.MessageBox.alert('Alert',result.alert_msg);
            if (result.alert === true) result.alert = "Alarm";
            Ext.MessageBox.alert(result.alert,result.message);
        } else {
            Lino.notify(result.message);
        }
    }
     
    if (result.refresh_all) {
        var cw = panel.get_containing_window();
        //~ console.log("20120123 refresh_all");
        if (cw) {
          cw.main_item.refresh();
        }
        //~ else console.log("20120123 cannot refresh_all",panel);
    } else {
        //~ console.log("20121212 b gonna refresh",panel);
        if (result.refresh) panel.refresh();
    }
    
    if (result.open_davlink_url) {
       Lino.davlink_open(result.open_davlink_url);
    }
    
    if (result.open_url) {
        //~ console.log(20111126,result.open_url);
        //~ if (!result.message)
            //~ Lino.notify('Open new window <a href="'+result.open_url+'" target="_blank">'+result.open_url+'</a>');
        window.open(result.open_url,'foo',"");
        //~ document.location = result.open_url;
    }
  }
};

Lino.do_action = function(caller,action) {
  action.success = function(response) {
    if (caller.loadMask) caller.loadMask.hide();
    //~ console.log('Lino.do_action()',action,'action success',response);
    if (action.after_success) {
        //~ console.log('Lino.do_action() calling after_success');
        action.after_success();
    }
    if (response.responseText) {
      var result = Ext.decode(response.responseText);
      //~ console.log('Lino.do_action()',action.name,'result is',result);
      if (result.message) {
          if (result.alert) {
              //~ Ext.MessageBox.alert('Alert',result.alert_msg);
              Ext.MessageBox.alert('Alert',result.message);
          } else {
              Lino.notify(result.message);
          }
      }
      
      //~ if (result.alert_msg) Ext.MessageBox.alert('Alert',result.alert_msg);
      //~ if (result.message) Lino.notify(result.message);
      if (result.notify_msg) Lino.notify(result.notify_msg);
      if (result.js_code) { 
        //~ console.log('Lino.do_action()',action,'gonna call js_code in',result);
        var jsr = result.js_code(caller);
        //~ console.log('Lino.do_action()',action,'returned from js_code in',result);
        if (action.after_js_code) {
          //~ console.log('Lino.do_action()',action,'gonna call after_js_code');
          action.after_js_code(jsr);
          //~ console.log('Lino.do_action()',action,'returned from after_js_code');
        //~ } else {
          //~ console.log('Lino.do_action()',action,' : after_js_code is false');
        }
      };
    }
  };
  Ext.applyIf(action,{
    waitMsg: "Bitte warten...",
    failure: Lino.ajax_error_handler(caller),
    params: {}
  });
  //~ action.params.su = Lino.subst_user;
  Lino.insert_subst_user(action.params);
  
  Ext.Ajax.request(action);
};

//~ Lino.gup = function( name )
//~ {
  //~ // Thanks to http://www.netlobo.com/url_query_string_javascript.html
  //~ name = name.replace(/[\[]/,"\\\[").replace(/[\]]/,"\\\]");
  //~ var regexS = "[\\?&]"+name+"=([^&#]*)";
  //~ var regex = new RegExp( regexS );
  //~ var results = regex.exec( window.location.href );
  //~ if( results == null )
    //~ return "";
  //~ else
    //~ return results[1];
//~ };

//~ Lino.refresh_handler = function (ww) {
  //~ return function() { 
      //~ console.log('refresh',ww);
      //~ ww.main_item.doLayout(false,true);
      //~ ww.main_item.syncSize();
  //~ }
//~ };

//~ Lino.tools_close_handler = function (ww) {
  //~ return function() { 
      //~ ww.close();
  //~ }
//~ };
Lino.permalink_handler = function (ww) {
  return function() { 
    //~ document.location = ww.main_item.get_permalink();
    //~ console.log('20130723 Lino.permalink_handler',ww);
    
    /* Uncaught TypeError: Cannot read property 'main_item' of null  */
    if (ww) {
        var url = ww.main_item.get_permalink();
    } else {
        var url = Lino.viewport.get_permalink();
        //~ var url = '/';
    }
    Lino.load_url(url);
  }
};
//~ Lino.run_permalink = function() {
  //~ var plink = Lino.gup('permalink');
  //~ if(plink) { eval('Lino.'+plink); }
//~ }

Lino.ajax_error_handler = function(panel) {
  return function(response,options) {
    console.log('Ajax failure:',response,options);
    if (panel.loadMask) panel.loadMask.hide();
    if (response.responseText) {
      var lines = response.responseText.split('\n');
      if (lines.length > 10) {
          line = lines.splice(5,lines.length-10,"(...)");
      }
      Ext.MessageBox.alert(
        response.statusText,
        lines.join('<br/>')
        //~ response.responseText.replace(/\n/g,'<br/>'))
      )
    } else {
      Ext.MessageBox.alert('Action failed',
        'Lino server did not respond to Ajax request');
    }
  }
}
// Ext.Ajax.on('requestexception',Lino.ajax_error_handler)
 


Ext.QuickTips.init();

/* setting QuickTips dismissDelay to 0 */
// Apply a set of config properties to the singleton
//~ Ext.apply(Ext.QuickTips.getQuickTip(), {
//~ Ext.apply(Ext.ToolTip, {
    //~ dismissDelay: 0
    //~ autoHide: false,
    //~ closable: true,
    //~ maxWidth: 200,
    //~ minWidth: 100,
    //~ showDelay: 50      // Show 50ms after entering target
    //~ ,trackMouse: true
//~ });


//~ Ext.apply(Ext.QuickTip, {
    //~ dismissDelay: 0,
//~ });
  
Lino.quicktip_renderer = function(title,body) {
  return function(c) {
    //~ if (c instanceof Ext.Panel) var t = c.bwrap; else // 20130129
    if (c instanceof Ext.Panel) var t = c.header; else // 20130129
    var t = c.getEl();
    //~ console.log(20130129,t,title,body);
    //~ t.dismissDelay = 0;
    Ext.QuickTips.register({
      target: t,
      //~ cls: 'lino-quicktip-classical',
      dismissDelay: 0,
      //~ autoHide: false,
      showDelay: 50,      // Show 50ms after entering target
      //~ title: title,
      text: body
    });
  }
};


  
Lino.help_text_editor = function() {
  //~ var bp = {
      //~ mk:this.content_type,
      //~ mt:1
    //~ };
    //~ console.log(20120202,bp);
  //~ Lino.lino.ContentTypes.detail({},{base_params:bp});
  //~ Lino.lino.ContentTypes.detail.run(null,{record_id:this.content_type});
  Lino.lino.ContentTypes.detail.run(null,{record_id:this.content_type});
}

// Path to the blank image should point to a valid location on your server
//~ Ext.BLANK_IMAGE_URL = MEDIA_URL + '/extjs/resources/images/default/s.gif'; 


// used as Ext.grid.Column.renderer for id columns in order to hide the special id value -99999
Lino.id_renderer = function(value, metaData, record, rowIndex, colIndex, store) {
  //~ if (record.phantom) return '';
  return value;
}

Lino.raw_renderer = function(value, metaData, record, rowIndex, colIndex, store) {
  return value;
}

Lino.text_renderer = function(value, metaData, record, rowIndex, colIndex, store) {
  //~ return "not implemented"; 
  return value;
}

Lino.NullNumberColumn = Ext.extend(Ext.grid.Column, {
    align : 'right', 
    format : '0,00/i', 
    renderer : function(value, metaData, record, rowIndex, colIndex, store) {
        //~ console.log(20130128,"NullNumberColumn.renderer",value);
        if (value === null) return '';
        return Ext.util.Format.number(value, this.format);
    }
});

//~ Lino.NullNumberColumn = Ext.extend(Ext.grid.NumberColumn, {
    //~ align : 'right', 
    //~ constructor: function(cfg){
        //~ Ext.grid.NumberColumn.superclass.constructor.call(this, cfg);
        //~ var t = this;
        //~ this.renderer = function(value, metaData, record, rowIndex, colIndex, store) {
          //~ console.log(20130128,"NullNumberColumn.renderer",value);
          //~ if (value === null) return '';
          //~ return Ext.util.Format.number(value, t.format);
      //~ };
    //~ }
//~ });




//~ Lino.cell_button_renderer = function(value, metaData, record, rowIndex, colIndex, store) {
  //~ return '<input type="button" onclick="alert(value)" value=" ? ">' ;
//~ }


//~ Lino.default_renderer = function(value, metaData, record, rowIndex, colIndex, store) {
  //~ if (record.phantom) return '';
  //~ return value;
//~ }

Lino.fk_renderer = function(fkname,handlername) {
  //~ console.log('Lino.fk_renderer handler=',handler);
  return function(value, metaData, record, rowIndex, colIndex, store) {
    //~ console.log('Lino.fk_renderer',fkname,rowIndex,colIndex,record,metaData,store);
    //~ if (record.phantom) return '';
    if (value) {
        var s = '<a href="javascript:' ;
        s += handlername + '.run(null,{record_id:\'' + String(record.data[fkname]) + '\'})">';
        s += value + '</a>';
        //~ console.log('Lino.fk_renderer',value,'-->',s);
        return s
    }
    return '';
  }
};

Lino.lfk_renderer = function(panel,fkname) {
  //~ console.log('Lino.fk_renderer handler=',handler);
  var handlername = 'console.log';
  return function(value, metaData, record, rowIndex, colIndex, store) {
    //~ console.log('Lino.fk_renderer',fkname,rowIndex,colIndex,record,metaData,store);
    if (record.phantom) return '';
    if (value) {
        var s = '<a href="javascript:' ;
        s += handlername + '({},{record_id:\'' + String(record.data[fkname]) + '\'})">';
        s += value + '</a>';
        //~ console.log('Lino.fk_renderer',value,'-->',s);
        return s
    }
    return '';
  }
};

//~ Lino.gfk_renderer = function() {
  //~ return function(value, metaData, record, rowIndex, colIndex, store) {
    //~ if (record.phantom) return '';
    //~ console.log('Lino.gfk_renderer',value,colIndex,record,metaData,store);
    //~ return value;
  //~ }
//~ };


Lino.build_buttons = function(panel,actions) {
  //~ console.log("20121006 Lino.build_buttons",actions);
  if (actions) {
    var buttons = Array(actions.length);
    var cmenu = Array(actions.length);
    for (var i=0; i < actions.length; i++) { 
      buttons[i] = new Ext.Toolbar.Button(actions[i]);
      cmenu[i] = actions[i]
      cmenu[i].text = actions[i].menu_item_text;
      if (actions[i].panel_btn_handler) {
          var h = actions[i].panel_btn_handler.createCallback(panel,buttons[i]);
          //~ if (actions[i].must_save) {
          if (actions[i].auto_save == true) {
              buttons[i].on('click',panel.do_when_clean.createDelegate(panel,[true,h]));
          } else if (actions[i].auto_save == null) {
              buttons[i].on('click',panel.do_when_clean.createDelegate(panel,[false,h]));
          } else if (actions[i].auto_save == false) {
              buttons[i].on('click',h);
          } else {
              console.log("20120703 unhandled auto_save value",actions[i])
          }
          cmenu[i].handler = actions[i].panel_btn_handler.createCallback(panel,cmenu[i]);
      }
    }
    return {bbar:buttons, cmenu:new Ext.menu.Menu(cmenu)};
  }
}

Lino.do_when_visible = function(cmp,todo) {
  //~ if (cmp.el && cmp.el.dom) 
  if (cmp.isVisible()) { 
    // 'visible' means 'rendered and not hidden'
    //~ console.log(cmp.title,'-> cmp is visible now');
    todo(); 
  //~ } else {
      //~ cmp.on('resize',todo,cmp,{single:true});
  //~ }
  //~ if (false) { // 20120213
  } else { 
    //~ console.log('Lino.do_when_visible() must defer because not isVisible()',todo,cmp);
    if (cmp.rendered) {
      //~ console.log(cmp,'-> cmp is rendered but not visible: and now?');
      //~ console.log(cmp.title,'-> cmp is rendered but not visible: try again in a moment...');
      //~ var fn = function() {Lino.do_when_visible(cmp,todo)};
      //~ fn.defer(100);
      
      Lino.do_when_visible.defer(50,this,[cmp,todo]);
      //~ Lino.do_when_visible.defer(100,this,[cmp,todo]);
      
    } else {
      //~ console.log(cmp.title,'-> after render');
      cmp.on('afterrender',todo,cmp,{single:true});
    }
  }
  
};    

/*
*/
Lino.do_on_current_record = function(panel,fn,phantom_fn) {
  var rec = panel.get_current_record();
  if (rec == undefined) {
    Lino.notify("There's no selected record.");
    return;
  }
  // 20120307 A VirtualTable with a Detail (lino.Models) has only "phantom" records.
  if (rec.phantom) {
    //~ if (!panel.editable) { console.log("20120312 not editable:",panel)}
    if (phantom_fn) {
      phantom_fn(panel);
    } else {
      Lino.notify("Aktion nicht verfügbar auf dem Phantom-Record.");
    }
    return;
  }
  return fn(rec);
};






Lino.call_ajax_action = function(panel,method,url,p,actionName,step,on_confirm,on_success) {
  p.an = actionName;
  if (!panel) {
      if (Lino.current_window) 
          panel = Lino.current_window.main_item;
      else panel = Lino.viewport;
  }
  //~ console.log("20130809 Lino.call_ajax_action",panel);
  Ext.apply(p,panel.get_base_params());
  
  if (panel.get_selected) {
      var selected_recs = panel.get_selected();
      //~ console.log("20130831",selected_recs);
      var rs = Array(selected_recs.length);
      for(var i=0; i < selected_recs.length;i++) {
          rs[i] = selected_recs[i].data.id;
      };
      p.sr = rs;
  }
  
  if (panel.loadMask) panel.loadMask.show(); 
  //~ p.$ext_requests.URL_PARAM_SUBST_USER = Lino.subst_user;
  //~ Lino.insert_subst_user(p);
    
  //~ if (step) p['$ext_requests.URL_PARAM_ACTION_STEP'] = step;
  //~ if (pp) pp(p); // "parameter processor" : first used for read beid card
  Ext.Ajax.request({
    method: method,
    url: url,
    params: p,
    success: Lino.action_handler(panel,on_success,on_confirm)
  });
};

Lino.row_action_handler = function(actionName,hm,pp) {
  var p = {};
  var fn = function(panel,btn,step) {
      if (pp) { p = pp(); if (! p) return; }
      
      if (panel.get_current_record == undefined) { // AFTER_20130725
        panel = Ext.getCmp(panel);
        if (panel == undefined) {
          Lino.notify("Invalid panel spec.");
          return;
        }
      }
      
      Lino.do_on_current_record(panel,function(rec) {
          //~ console.log(panel);
          //~ 20120723 Lino.call_ajax_action(panel,rec.id,actionName,step,fn);
          Lino.call_ajax_action(panel,hm,panel.get_record_url(rec.id),p,actionName,step,fn);
      });
  };
  return fn;
};

Lino.list_action_handler = function(ls_url,actionName,hm,pp) {
  var p = {};
  var url = '/api' + ls_url
  var fn = function(panel,btn,step) {
      //~ console.log("20121210 Lino.list_action_handler",arguments);
      //~ var url = ADMIN_URL + '/api' + panel.ls_url
      if (pp) { p = pp();  if (! p) return; }
      Lino.call_ajax_action(panel,hm,url,p,actionName,step,fn);
  };
  return fn;
};

Lino.param_action_handler = function(window_action) { // 20121012
  var fn = function(panel,btn,step) {
    Lino.do_on_current_record(panel,function(rec) {
      //~ console.log(panel);
      //~ 20120723 Lino.call_ajax_action(panel,rec.id,actionName,step,fn);
      window_action.run(panel.getId(),{}); 
    });
  };
  return fn;
};


//~ 20130726 Lino.run_row_action = function(requesting_panel,url,pk,actionName,pp) {
Lino.run_row_action = function(requesting_panel,url,meth,pk,actionName,preprocessor) {
  //~ var panel = action.get_window().main_item;
  url = '/api' + url  + '/' + pk;
  var panel = Ext.getCmp(requesting_panel);
  if (preprocessor) var p = preprocessor(); else var p = {};
  var fn = function(panel,btn,step) {
    //~ 20120723 Lino.call_ajax_action(panel,pk,actionName,step,fn);
    //~ 20130726 Lino.call_ajax_action(panel,'GET',url,p,actionName,step,fn);
    Lino.call_ajax_action(panel,meth,url,p,actionName,step,fn);
  }
  fn(panel,null,null);
}



Lino.show_detail = function(panel,btn) {
  Lino.do_on_current_record(panel, 
    function(rec) {
      //~ panel.loadMask.show();
      Lino.run_detail_handler(panel,rec.id);
    },
    Lino.show_insert
  );
};

Lino.run_detail_handler = function(panel,pk) {
  var bp = panel.get_base_params();
  //~ var bp = {};
  panel.add_param_values(bp); // 20120918
  var status = {
    record_id:pk,
    base_params:bp
    //~ param_values: pv.$ext_requests.URL_PARAM_PARAM_VALUES
  }
  //~ console.log("20120918 Lino.show_detail",status);
  panel.ls_detail_handler.run(null,status);
  //~ panel.loadMask.hide();
  //~ panel.containing_window.window.hideMask();
  //~ panel.el.unmask();
}

Lino.show_fk_detail = function(combo,detail_action) {
    //~ console.log("Lino.show_fk_detail",combo,handler);
    pk = combo.getValue();
    if (pk) {
        detail_action.run(null,{record_id: pk})
      } else {
        Lino.notify("Cannot show detail for empty foreign key.");
      }
};

Lino.show_insert = function(panel,btn) {
  var bp = panel.get_base_params();
  //~ console.log('20120125 Lino.show_insert',bp)
  //~ panel.ls_insert_handler.run(null,{record_id:-99999,base_params:bp});
  panel.ls_insert_handler.run(panel.getId(),{record_id:-99999,base_params:bp});
};

Lino.show_insert_duplicate = function(panel,btn) {
  Lino.do_on_current_record(panel,
    function(rec) {
      var newRec = {};
      Ext.apply(newRec,rec);
      newRec.id = -99999;
      panel.ls_insert_handler.run(null,{data_record:rec});
    });
};

//~ Lino.update_row_handler = function(action_name) {
  //~ return function(panel,btn) {
    //~ Lino.notify("Sorry, " + action_name + " is not implemented.");
  //~ }
//~ };




if (Ext.ux.grid !== undefined) {
    Lino.GridFilters = Ext.extend(Ext.ux.grid.GridFilters,{
      encode:true,
      local:false
    });
} else {
    Lino.GridFilters = function() {}; // dummy
    Ext.override(Lino.GridFilters,{
      init : function() {}
    });
};



//~ Lino.ButtonField = Ext.extend(Ext.form.TextField,{
//~ Lino.ButtonField = Ext.extend(Ext.form.Field,{
    //~ editable : false,
    //~ constructor : function(ww,config,params){
      //~ this.containing_window = ww;
      //~ if (params) Ext.apply(config,params);
      //~ Lino.ButtonField.superclass.constructor.call(this, config);
    //~ },
    //~ setButtons : function(buttons){
      //~ console.log('setButtons',buttons);
    //~ },
    //~ onRender : function(ct, position){
        //~ if(!this.el){
            //~ this.panel = new Ext.Container({items:[
              //~ {xtype:'button',text:'upload'},
              //~ {xtype:'button',text:'show'},
              //~ {xtype:'button',text:'edit'}
            //~ ]});
            //~ this.panel.ownerCt = this;
            //~ this.el = this.panel.getEl();

        //~ }
        //~ Lino.ButtonField.superclass.onRender.call(this, ct, position);
    //~ },

  
//~ });

Lino.FieldBoxMixin = {
  before_init : function(config,params) {
    if (params) Ext.apply(config,params);
    var actions = Lino.build_buttons(this,config.ls_bbar_actions);
    if (actions) config.bbar = actions.bbar;
  },
  //~ constructor : function(ww,config,params){
    //~ this.containing_window = ww;
    //~ if (params) Ext.apply(config,params);
    //~ var actions = Lino.build_buttons(this,config.ls_bbar_actions);
    //~ if (actions) config.bbar = actions.bbar;
    //~ Lino.FieldBoxMixin.superclass.constructor.call(this, config);
  //~ },
  do_when_clean : function(auto_save,todo) { todo() },
  //~ format_data : function(html) { return '<div class="htmlText">' + html + '</div>' },
  format_data : function(html) { return html },
  get_base_params : function() {
    // needed for insert action
    var p = Ext.apply({},this.base_params);
    Lino.insert_subst_user(p);
    return p;
  },
  set_base_params : function(p) {
    this.base_params = Ext.apply({},p);
    //~ if (p.param_values) this.set_param_values(p.param_values);  
  },
  clear_base_params : function() {
      this.base_params = {};
      Lino.insert_subst_user(this.base_params);
  },
  set_base_param : function(k,v) {
    this.base_params[k] = v;
  }
};



Lino.HtmlBoxPanel = Ext.extend(Ext.Panel,Lino.PanelMixin);
Lino.HtmlBoxPanel = Ext.extend(Lino.HtmlBoxPanel,Lino.FieldBoxMixin);
Lino.HtmlBoxPanel = Ext.extend(Lino.HtmlBoxPanel,{
  disabled_in_insert_window : true,
  constructor : function(config,params) {
    this.before_init(config,params);
    Lino.HtmlBoxPanel.superclass.constructor.call(this, config);
  },
  //~ constructor : function(ww,config,params){
    //~ this.ww = ww;
    //~ if (params) Ext.apply(config,params);
    //~ var actions = Lino.build_buttons(this,config.ls_bbar_actions);
    //~ if (actions) config.bbar = actions.bbar;
    //~ Lino.FieldBoxMixin.constructor.call(this, ww,config,params);
  //~ },
  //~ constructor : function(ww,config,params){
    //~ this.ww = ww;
    //~ if (params) Ext.apply(config,params);
    //~ var actions = Lino.build_buttons(this,config.ls_bbar_actions);
    //~ if (actions) config.bbar = actions.bbar;
    //~ Lino.FieldBoxMixin.superclass.constructor.call(this, config);
  //~ },
  //~ disable : function() { var tb = this.getBottomToolbar(); if(tb) tb.disable()},
  //~ enable : function() { var tb = this.getBottomToolbar(); if(tb) tb.enable()},
  onRender : function(ct, position){
    Lino.HtmlBoxPanel.superclass.onRender.call(this, ct, position);
    //~ console.log(20111125,this.containing_window);
    if (this.containing_panel) {
      this.containing_panel.on('enable',this.enable,this);
      this.containing_panel.on('disable',this.disable,this);
    }
    this.el.on({
      dragenter:function(event){
        event.browserEvent.dataTransfer.dropEffect = 'move';
        return true;
      }
      ,dragover:function(event){
        event.browserEvent.dataTransfer.dropEffect = 'move';
        event.stopEvent();
        return true;
      }
      ,drop:{
        scope:this
        ,fn:function(event){
          event.stopEvent();
          //~ console.log(20110516);
          var files = event.browserEvent.dataTransfer.files;
          if(files === undefined){
            return true;
          }
          var len = files.length;
          while(--len >= 0){
            console.log(files[len]);
            //~ this.processDragAndDropFileUpload(files[len]);
          }
          Lino.show_insert(this);
        }
      }
    });
  },
  refresh : function(unused) { 
      this.refresh_with_after();
  },
  refresh_with_after : function(after) {
    //~ if (this.master_panel) {
      var record = this.containing_panel.get_current_record();
      //~ console.log('HtmlBox.refresh()',this.title,record,record.title);
      var box = this.items.get(0);
      var todo = function() {
        if (this.disabled) return;
        //~ this.set_base_params(this.containing_window.get_base_params());
        this.set_base_params(this.containing_panel.get_master_params());
        var el = box.getEl();
        if (el) {
          el.update(record ? this.format_data(record.data[this.name]) : '');
          //~ console.log('20130723 HtmlBox.refresh()',this.name);
        //~ } else {
          //~ console.log('HtmlBox.refresh() failed for',this.name);
        }
      };
      Lino.do_when_visible(box,todo.createDelegate(this));
    //~ }
  }
});
//~ Ext.override(Lino.HtmlBoxPanel,Lino.FieldBoxMixin);



Lino.RichTextPanel = Ext.extend(Ext.Panel,Lino.PanelMixin);
Lino.RichTextPanel = Ext.extend(Lino.RichTextPanel,Lino.FieldBoxMixin);
Lino.RichTextPanel = Ext.extend(Lino.RichTextPanel,{
    
  //~ initComponent : function(){
    //~ Lino.RichTextPanel.superclass.initComponent.call(this);
  //~ },
  constructor : function(config,params) {
    //~ console.log('Lino.RichTextPanel.initComponent',this);
    //~ var url = TEMPLATES_URL + config.ls_url + "/" + String(rec.id) + "/" + config.name;
    //~ var url = TEMPLATES_URL + config.ls_url + "/" + config.name;
    var t = this;
    var tinymce_options = {
        theme : "advanced",
        content_css: '/media/lino/extjs/lino.css',
        language: 'en',
        //~ template_external_list_url : url,
        theme_advanced_toolbar_location : "top",
        theme_advanced_toolbar_align : "left",
        theme_advanced_statusbar_location : "bottom",
        template_popup_width : 700,
        template_popup_height : 500,
        template_replace_values : { 
            data_field : function(element){ 
                //~ console.log(20110722,fieldName,t.containing_window.get_current_record()); 
                var fieldName = element.innerHTML;
                element.innerHTML = t.containing_panel.get_current_record().data[fieldName];
            } 
        }
      };
      
    var editorConfig = {
      tinymceSettings: {
        plugins : "noneditable,template", 
        // Theme options - button# indicated the row# only
        theme_advanced_buttons1 : "bold,italic,underline,|,justifyleft,justifycenter,justifyright,|,bullist,numlist,|,outdent,indent,|,undo,redo,|,removeformat,template",
        theme_advanced_buttons2 : "",
        theme_advanced_buttons3 : "", // ,|,sub,sup,|,charmap",      
        theme_advanced_resizing : false
        //~ save_onsavecallback : save_callback,
        //~ save_enablewhendirty : true
        //~ save_oncancelcallback: on_cancel
        
    }};
    Ext.apply(editorConfig.tinymceSettings,tinymce_options);
    //~ editorConfig.name = config.action_name;
    editorConfig.name = config.name;
    delete config.name;
    //~ config.title = config.label;
    //~ delete config.label;
    this.before_init(config,params);
    
    this.editor = new Ext.ux.TinyMCE(editorConfig);
    var t = this;
    config.tools = [{
                      qtip: "Edit text in own window", 
                      id: "up",
                      handler: function(){
                        if(t.editor.isDirty()) {
                            var record = t.containing_panel.get_current_record();
                            record.data[t.editor.name] = t.editor.getValue();
                        }
                        Lino.edit_tinymce_text(t,tinymce_options)
                      }
                    }];
    
    config.items = this.editor;
    config.layout = "fit";
    Lino.RichTextPanel.superclass.constructor.call(this, config);
  },
  refresh : function(unused) { 
      this.refresh_with_after();
  },
  refresh_with_after : function(after) {
    var record = this.containing_panel.get_current_record();
    //~ console.log('RichTextPanel.refresh()',this.title,record.title,record);
    var todo = function() {
      //~ this.set_base_params(this.containing_window.get_base_params());
      if (record) {
        var url = '/templates' + this.containing_panel.ls_url + "/" 
            + String(record.id) + "/" + this.editor.name;
        //~ console.log('RichTextPanel.refresh()',url);
        if (this.editor.ed) this.editor.ed.settings.template_external_list_url = url;
        this.set_base_params(this.containing_panel.get_master_params());
        //~ var v = record ? this.format_data(record.data[this.editor.name]) : ''
        var v = this.format_data(record.data[this.editor.name])
        this.editor.setValue(v);
      } else {
        this.editor.setValue('(no data)');
      }
    };
    Lino.do_when_visible(this,todo.createDelegate(this));
  }
});
//~ Ext.override(Lino.RichTextPanel,Lino.FieldBoxMixin);



Lino.ActionFormPanel = Ext.extend(Ext.form.FormPanel,Lino.MainPanel);
Lino.ActionFormPanel = Ext.extend(Lino.ActionFormPanel,Lino.PanelMixin);
Lino.ActionFormPanel = Ext.extend(Lino.ActionFormPanel,Lino.FieldBoxMixin);
Lino.ActionFormPanel = Ext.extend(Lino.ActionFormPanel,{
  //~ layout:'fit'
  //~ ,autoHeight: true
  //~ ,frame: true
  window_title: "Action Parameters",
  constructor : function(config){
    config.bbar = [
        {text:'OK',handler:this.on_ok,scope:this},
        {text:'Cancel',handler:this.on_cancel,scope:this}
    ];
    //~ config.items = config.params_panel;
    Lino.ActionFormPanel.superclass.constructor.call(this, config);
  }
  //~ ,initComponent : function(){
    //~ Lino.ActionFormPanel.superclass.initComponent.call(this);
  //~ }
  ,on_cancel : function() { 
    this.get_containing_window().close();
  }
  ,on_ok : function() { 
    //~ var rp = this.requesting_panel;
    //~ console.log("on_ok",this.requesting_panel,arguments);
    var panel = this.requesting_panel;
    //~ if (panel == undefined) {
        //~ Lino.alert("Sorry, dialog actions don't work without a requesting_panel");
        //~ return;
    //~ }
    //~ var rec = panel.get_current_record();
    var actionName = this.action_name;
    var pk = this.base_params.mk;
    if (pk == undefined && panel) {
        pk = panel.get_current_record().id;
    }
    if (pk == undefined) {
        Lino.alert("Sorry, dialog action without base_params.mk");
        return;
    }
    var self = this;
    function on_success() { self.get_containing_window().close(); };
    var url = '/api' + this.ls_url + '/' + pk;
    var fn = function(panel,btn,step) {
      var p = {};
      self.add_field_values(p)
      //~ Lino.call_ajax_action(panel,'GET',panel.get_record_url(rec.id),p,actionName,step,fn,on_success);
      Lino.call_ajax_action(panel,'GET',url,p,actionName,step,fn,on_success);
    }
    fn(panel,null,null);
    
    
  }
  ,set_status : function(status,rp){
    this.requesting_panel = Ext.getCmp(rp);
    //~ console.log('20120918 ActionFormPanel.set_status()',status,rp,this.requesting_panel);
    this.clear_base_params();
    if (status == undefined) status = {};
    //~ if (status.param_values) 
    this.set_field_values(status.field_values);
    if (status.base_params) this.set_base_params(status.base_params);
  }
  
  ,add_field_values : function (p) { // similar to add_param_values()
      //~ 20121023 
      if (this.form.isDirty()) {
        p.fv = this.get_field_values();
      }else{
        if (this.status_field_values) 
          p.fv = Lino.fields2array(this.fields,this.status_field_values);
      }
      //~ if (!this.form.isDirty()) return;
      //~ p.$ext_requests.URL_PARAM_FIELD_VALUES = this.get_field_values();
      //~ console.log("20120203 add_param_values added pv",pv,"to",p);
  }
  ,get_field_values : function() {
      return Lino.fields2array(this.fields);
  }
  ,set_field_values : function(pv) {
      //~ console.log('20120203 MainPanel.set_param_values', pv);
      this.status_field_values = pv;
      if (pv) this.form.my_loadRecord(pv);
      else this.form.reset(); 
  }
  ,config_containing_window : function(wincfg) { 
      wincfg.title = this.window_title;
      wincfg.keys = [
        { key: Ext.EventObject.ENTER, fn: this.on_ok }
      ]
  }
});

//~ Lino.add_blank = function(oa) {
    //~ return [].concat(oa)
    //~ return 
    //~ }
    
Lino.fields2array = function(fields,values) {
    //~ console.log('20130605 fields2array gonna loop on', fields,values);
    var pv = Array(fields.length);
    for(var i=0; i < fields.length;i++) {
        var f = fields[i]
        if (values) 
          var v = values[f.name];
        else 
          var v = f.getValue();
        if (f.formatDate) {
            pv[i] = f.formatDate(v); 
        } else {
            pv[i] = v; // f.getValue(); 
        }
    }
    return pv;
}


Lino.FormPanel = Ext.extend(Ext.form.FormPanel,Lino.MainPanel);
Lino.FormPanel = Ext.extend(Lino.FormPanel,Lino.PanelMixin);
Lino.FormPanel = Ext.extend(Lino.FormPanel,{
  params_panel_hidden : false,
  //~ base_params : {},
  //~ trackResetOnLoad : true,
  //~ query_params : {},
  //~ 20110119b quick_search_text : '',
  constructor : function(config,params){
    if (params) Ext.apply(config,params);
    this.base_params = {};
    //~ ww.config.base_params.query = ''; // 20111018
    //~ console.log(config);
    //~ console.log('FormPanel.constructor() 1',config)
    //~ Ext.applyIf(config,{base_params:{}});
    //~ console.log('FormPanel.constructor() 2',config)
      
    config.trackResetOnLoad = true;
    
    Lino.FormPanel.superclass.constructor.call(this, config);
      
    //~ this.set_base_param('$URL_PARAM_FILTER',null); // 20111018
    //~ this.set_base_param('$URL_PARAM_FILTER',''); // 20111018
      
  },
  initComponent : function(){
    
    //~ console.log("20111201 containing_window",this.containing_window,this);
    
    var actions = Lino.build_buttons(this,this.ls_bbar_actions);
    if (actions) {
        this.bbar = actions.bbar;
    //~ } else {
        //~ this.bbar = [];
    }
    //~ Ext.apply(config,Lino.build_buttons(this,config.ls_bbar_actions));
    //~ config.bbar = Lino.build_buttons(this,config.ls_bbar_actions);
    //~ var config = this;
    
    //~ if (this.containing_window instanceof Lino.DetailWrapper) {
    
    //~ console.log('20120121 initComponent', this.action_name);
    //~ if (this.action_name == 'detail' | this.action_name == 'show') {
    //~ if (this.action_name != 'insert') {
    if (! this.hide_top_toolbar) {
      this.tbar = [];
      // 20111015    
      if (! this.hide_navigator) {
        this.record_selector = new Lino.RemoteComboFieldElement({
          store: new Lino.ComplexRemoteComboStore({
            //~ baseParams: this.containing_window.config.base_params,
            baseParams: this.get_base_params(),
            //~ value: this.containing_window.config.base_params.query,
            proxy: new Ext.data.HttpProxy({
              url: '/choices' + this.ls_url,
              method:'GET'
            })
          }),
          pageSize:25,
          listeners: { 
            scope:this, 
            select:function(combo,record,index) {
              //~ console.log('jumpto_select',arguments);
              this.goto_record_id(record.id);
            }
          },
          emptyText: "Gehe zu Datensatz"
        })
        this.tbar = this.tbar.concat([this.record_selector]);
        
        this.tbar = this.tbar.concat([
          this.first = new Ext.Toolbar.Button({
            tooltip:"Erster",disabled:true,handler:this.moveFirst,scope:this,iconCls:'x-tbar-page-first'}),
          this.prev = new Ext.Toolbar.Button({
            tooltip:"Voriger",disabled:true,handler:this.movePrev,scope:this,iconCls:'x-tbar-page-prev'}),
          this.next = new Ext.Toolbar.Button({
            tooltip:"Nächster",disabled:true,handler:this.moveNext,scope:this,iconCls:'x-tbar-page-next'}),
          this.last = new Ext.Toolbar.Button({
            tooltip:"Letzter",disabled:true,handler:this.moveLast,scope:this,iconCls:'x-tbar-page-last'})
        ]);
      }
      this.tbar = this.add_params_panel(this.tbar);
      
      //~ console.log(20101117,this.containing_window.refresh);
      this.tbar = this.tbar.concat([
        {
          //~ text:'Refresh',
          handler:function(){ this.do_when_clean(true,this.refresh.createDelegate(this)) },
          iconCls: 'x-tbar-loading',
          tooltip:"Datensatz neu laden",
          scope:this}
      ]);
          
      if (this.bbar) { // since 20121016
        if (this.tbar) {
            this.tbar = this.tbar.concat(['-']) ;
        } else {
          this.tbar = [];
        }
        this.tbar = this.tbar.concat(this.bbar) ;
        this.bbar = undefined;
      }
    
      this.tbar = this.tbar.concat([
          '->',
          this.displayItem = new Ext.Toolbar.TextItem({})
      ]);
          
    }
    //~ if (this.content_type && this.action_name != 'insert') {
      //~ this.bbar = this.bbar.concat([
        //~ '->',
        //~ { text: "[$_('Help Text Editor')]",
          //~ handler: Lino.help_text_editor,
          //~ qtip: "$_('Edit help texts for fields on this model.')",
          //~ scope: this}
      //~ ])
    //~ }
    //~ this.before_row_edit = config.before_row_edit.createDelegate(this);
      
    //~ if (this.master_panel) {
        //~ this.set_base_params(this.master_panel.get_master_params());
    //~ }
      
    Lino.FormPanel.superclass.initComponent.call(this);
    
    this.on('render',function(){
      this.loadMask = new Ext.LoadMask(this.bwrap,{msg:"Bitte warten..."});
    },this);
    
    
    //~ var this_ = this;
    //~ this.cascade(function(cmp){
      //~ // var active_field = false;
      //~ for (i = 0; i < this_.active_fields.length; i++) {
        //~ if (cmp.name == this_.active_fields[i]) {
            //~ // active_field = true; break;
            //~ cmp.on("change",function() {this_.save()});
        //~ }
      //~ };
      //~ if (active_field) {
      // if (cmp instanceof Lino.GridPanel) {
          //~ cmp.on("change",function() {this_.save()});
      //~ }
    //~ });
    
    if (this.action_name == 'insert') {
      this.cascade(function(cmp){
        // console.log('20110613 cascade',cmp);
        if (cmp.disabled_in_insert_window) {
            //~ cmp.disable();
            cmp.hide();
        }
      });
      
    }
    
  },
  
  unused_is_loading : function() { 
    if (this.current_record == null) {
        //~ console.log("20130515 current_record is null");
        return true; 
    }
    
    if (! this.loadMask) return true; // not even rendered: 
    if (! this.loadMask.el) return true; // not even rendered: 
    // thanks to Marco Pegoraro http://movableapp.com/2011/09/sencha-touch-loadmask-isvisible/
    var loading = (this.loadMask.el.select('.x-loading-msg').elements.length > 0);
    //~ console.log('20130515 GridPanel.is_loading() returns',loading);
    return loading;

    
    var loading = false;
    this.cascade(function(cmp){
        if (cmp instanceof Lino.GridPanel && cmp.is_loading()) {
            //~ console.log(20130515, cmp.title,'is loading');
            loading = true;
            return false;
        }
      });
    return loading;
    //~ var a = this.findByType(Lino.GridPanel);
    //~ for (i=0;i<a.length;i++) {
        //~ if (a[i].is_loading()) return true;
    //~ }
    //~ return false;
  },
  
  get_status : function(){
      var st = {
        base_params: this.get_base_params(),
        data_record : this.get_current_record()
        }
      var tp = this.items.get(0);
      if (tp instanceof Ext.TabPanel) {
        st.active_tab = tp.getActiveTab();
      }
      st.param_values = this.status_param_values;
      return st;
  },
  /* FormPanel */
  set_status : function(status,rp){
    this.requesting_panel = Ext.getCmp(rp);
    //~ console.log('20120918 FormPanel.set_status()',status);
    this.clear_base_params();
    if (status == undefined) status = {};
    //~ if (status.param_values) 
    this.set_param_values(status.param_values);
    if (status.base_params) this.set_base_params(status.base_params);
    var tp = this.items.get(0);
    if (tp instanceof Ext.TabPanel) {
      if (status.active_tab) {
        //~ console.log('20111201 active_tab',this.active_tab,this.items.get(0));
        //~ tp.activeTab = status.active_tab;
        tp.setActiveTab(status.active_tab);
        //~ this.main_item.items.get(0).activate(status.active_tab);
      } else {
        tp.setActiveTab(0);
      }
      }
    
    if (status.data_record) {
      //~ console.log('20111201 Lino.FormPanel with data_record',this.data_record.title,this.containing_window);
      //~ this.main_item.on_master_changed.defer(2000,this.main_item,[status.data_record]);
      //~ Lino.do_when_visible(this.main_item,function(){this.on_master_changed(status.data_record)});
      //~ this.main_item.on('afterrender',function(){
      //~   this.main_item.on_master_changed(status.data_record)},this,{single:true});
      /* must defer because because set_window_title() didn't work otherwise */
      this.set_current_record.createDelegate(this,[status.data_record]).defer(100);
      //~ this.set_current_record(this.data_record);
      //~ return;
    } else if (status.record_id != undefined) { 
      /* possible values include 0 and null, 0 being a valid record id, 
      null the equivalent of undefined
      */
      //~ this.main_item.goto_record_id(this.status.record_id);
      this.load_record_id(status.record_id);
    } else {
      this.set_current_record(undefined);
    }
  },
    
  get_base_params : function() {
    // needed for insert_action
    var p = Ext.apply({},this.base_params);
    Lino.insert_subst_user(p);
    return p;
    //~ return this.base_params;
  },
  set_base_params : function(p) {
    //~ this.base_params = Ext.apply({},this.base_params); // make sure it is an instance variable
    delete p['query'] // 20120725
    Ext.apply(this.base_params,p);
    if (this.record_selector) {
        var store = this.record_selector.getStore();
        for (k in p) store.setBaseParam(k,p[k]);
        delete this.record_selector.lastQuery;
        //~ console.log("20120725 record_selector.setBaseParam",p)
    }
  },
  clear_base_params : function() {
      this.base_params = {};
      Lino.insert_subst_user(this.base_params);
        
      //~ if (this.record_selector) {
          //~ var store = this.record_selector.getStore();
          //~ for (k in store.baseParams) store.setBaseParam(k,undefined);
          //~ delete this.record_selector.lastQuery;
          //~ console.log("20120725 record_selector.getBaseParams() -->",store.baseParams)
      //~ }
  },
  set_base_param : function(k,v) {
    //~ this.base_params = Ext.apply({},this.base_params); // make sure it is an instance variable
    this.base_params[k] = v;
    //~ if (this.record_selector) {
        //~ this.record_selector.getStore().setBaseParam(k,v);
        //~ delete this.record_selector.lastQuery;
    //~ }
  },
  
  after_delete : function() {
    if (this.current_record.navinfo.next)
      this.moveNext();
    else if (this.current_record.navinfo.prev)
      this.movePrev();
    else 
      this.abandon();
  },
  moveFirst : function() {this.goto_record_id(this.current_record.navinfo.first)},
  movePrev : function() {this.goto_record_id(this.current_record.navinfo.prev)},
  moveNext : function() {this.goto_record_id(this.current_record.navinfo.next)},
  moveLast : function() {this.goto_record_id(this.current_record.navinfo.last)},
  
  
  refresh : function(unused) { 
      this.refresh_with_after();
  },
  refresh_with_after : function(after) { 
    //~ console.log('20120121 Lino.FormPanel.refresh()',this);
    if (this.current_record) {
        this.load_record_id(this.current_record.id,after);
    } else {
        this.set_current_record(undefined,after);
    }
  },
  
  do_when_clean : function(auto_save,todo) {
    var this_ = this;
    if (this.form.isDirty()) {
        if (auto_save) {
            this_.save(todo);
        } else {
          //~ console.log('20111217 do_when_clean() form is dirty',this.form);
          var config = {title:"Bestätigung"};
          config.buttons = Ext.MessageBox.YESNOCANCEL;
          config.msg = "Änderungen in diesem Datensatz speichern?";
          config.fn = function(buttonId,text,opt) {
            //~ console.log('do_when_clean',buttonId)
            if (buttonId == "yes") {
                //~ Lino.submit_detail(this_,undefined,todo);
                //~ this_.containing_window.save(todo);
                this_.save(todo);
            } else if (buttonId == "no") { 
              todo();
            }
          }
        }
        Ext.MessageBox.show(config);
    }else{
      //~ console.log('do_when_clean : now!')
      todo();
    }
  },
  
  goto_record_id : function(record_id) {
    //~ console.log('20110701 Lino.FormPanel.goto_record_id()',record_id);
    //~ var this_ = this;
    //~ this.do_when_clean(function() { this_.load_record_id(record_id) }
    this.do_when_clean(true,this.load_record_id.createDelegate(this,[record_id]));
  },
  
  load_record_id : function(record_id,after) {
    var this_ = this;
    //~ var p = { fmt: this.containing_window.config.action_name};
    //~ var p = Ext.apply({},this.containing_window.config.base_params);
    var p = Ext.apply({},this.get_base_params());
    //~ Lino.insert_subst_user(p);
    //~ console.log('20110713 action_name=',this.containing_window.config.action_name,
      //~ 'base_params=',this.containing_window.config.base_params);
    if (this.action_name)
        p.an = this.action_name;
    //~ p.an = this.action_name;
    //~ p.an = this.containing_window.config.action_name;
    //~ p.fmt = 'json';
    //~ p.fmt = '$ext_requests.URL_FORMAT_JSON';
    p.rp = this.getId();
    //~ p.$ext_requests.URL_PARAM_SUBST_USER = Lino.subst_user;
    p.fmt = 'json';
    //~ 20110119b p['$URL_PARAM_FILTER'] = this.quick_search_text;
    //~ Ext.apply(p,this.query_params);
    this.add_param_values(p);
    //~ console.log('20121120 FormPanel.load_record_id',record_id,p);
    if (this.loadMask) this.loadMask.show();
    Ext.Ajax.request({ 
      waitMsg: 'Loading record...',
      method: 'GET',
      params: p,
      scope: this,
      url: this.get_record_url(record_id),
      success: function(response) {   
        // todo: convert to Lino.action_handler.... but result 
        if (this.loadMask) this.loadMask.hide();
        if (response.responseText) {
          var rec = Ext.decode(response.responseText);
          //~ console.log('20120918 goto_record_id success',rec);
          this.set_param_values(rec.param_values);
          this.set_current_record(rec,after);
        }
      },
      failure: Lino.ajax_error_handler(this)
    });
  },

  abandon : function () {
    Ext.MessageBox.alert('Note',
      "Keine weiteren Datensätze zu sehen. Detail-Fenster wird geschlossen.");
    Lino.close_window();
    //~ if (this.containing_window) {
        //~ this.containing_window.hide();
    //~ }
  },
  
  set_current_record : function(record,after) {
    //~ console.log('20120722 Lino.FormPanel.set_current_record',record.title,record);
    if (this.record_selector) {
        this.record_selector.clearValue();
        // e.g. InsertWrapper FormPanel doesn't have a record_selector
    }
    this.current_record = record;
    //~ if (record) 
        //~ console.log('Lino.FormPanel.set_current_record',record.title,record);
    //~ else
        //~ console.log('Lino.FormPanel.set_current_record',record);
    //~ this.config.main_panel.form.load(record);    
    if (record) {
      this.enable();
      this.form.my_loadRecord(record.data);
      this.set_window_title(record.title);
      //~ this.getBottomToolbar().enable();
      var da = record.data.disabled_actions;
      if (da) {
          //~ console.log('20120528 disabled_actions =',da,this.getBottomToolbar());
          //~ 20121016 this.getBottomToolbar().items.each(function(item,index,length){
          var tb = this.getTopToolbar();
          if (tb) tb.items.each(function(item,index,length){
              //~ console.log('20120528 ',item.itemId,'-->',da[item.itemId]);
              if (da[item.itemId]) item.disable(); else item.enable();
          });
      };
      if (this.disable_editing | record.data.disable_editing) {
          //~ console.log("20120202 disable_editing",record.title);
          this.form.items.each(function(cmp){
            if (!cmp.always_enabled) cmp.disable();
          },this);
      } else {
          this.form.items.each(function(cmp){
            //~ console.log("20120202",cmp);
            if (record.data.disabled_fields[cmp.name]) cmp.disable();
            else cmp.enable();
          },this);
        
          //~ if (record.data.disabled_fields) {
              //~ for (i = 0; i < record.data.disabled_fields.length; i++) {
                  //~ var flds = this.find('name',record.data.disabled_fields[i]);
                  //~ if (flds.length == 1) { 
                    //~ flds[0].disable(); 
                  //~ }
              //~ }
          //~ }
      };
      if (this.first) {
        if (record.navinfo  && ! this.hide_navigator) {
          this.first.setDisabled(!record.navinfo.first);
          this.prev.setDisabled(!record.navinfo.prev);
          this.next.setDisabled(!record.navinfo.next);
          this.last.setDisabled(!record.navinfo.last);
          this.displayItem.setText(record.navinfo.message);
        } else {
          this.first.setDisabled(true);
          this.prev.setDisabled(true);
          this.next.setDisabled(true);
          this.last.setDisabled(true);
        }
      }
    } else {
      if (this.form.rendered) 
        this.form.reset(); /* FileUploadField would fail when resetting a non-rendered form */
      //~ this.disable();
      //~ this.getBottomToolbar().disable();
      this.form.items.each(function(cmp){
        cmp.disable();
      },this);
      this.set_window_title(this.empty_title);
      //~ this.containing_window.window.setTitle(this.empty_title);
      if (!this.hide_navigator) {
        this.first.disable();
        this.prev.disable();
        this.next.disable();
        this.last.disable();
      }
    }
    //~ console.log('20100531 Lino.DetailMixin.on_load_master_record',this.main_form);
    this.before_row_edit(record);
    if (after) after();
  },
  
  before_row_edit : function(record) {},
  search_change : function(field,oldValue,newValue) {
    //~ console.log('search_change',field.getValue(),oldValue,newValue)
    this.set_base_param('query',field.getValue()); 
    this.refresh();
  },
  
  get_selected : function() { return [ this.current_record ] },
  get_current_record : function() {  
    //~ console.log(20100714,this.current_record);
    return this.current_record 
  },
  
  get_permalink_url : function() {
      var rec = this.get_current_record();
      if (rec && ! rec.phantom && rec.id != -99998)
          return '/api' + this.ls_url + '/' + rec.id;
      return '/api' + this.ls_url;
    
  },
  get_permalink_params : function() {
    var p = {};
    //~ var p = {an:'detail'};
    if (this.action_name)
        p.an = this.action_name;
    //~ var p = {an:this.action_name};
    var main = this.items.get(0);
    if (main.activeTab) {
      var tab = main.items.indexOf(main.activeTab);
      //~ console.log('main.activeTab',tab,main.activeTab);
      if (tab) p.tab = tab;
    }
    this.add_param_values(p)
    return p;
  },
  
  /* 
  Lino.FormPanel.save() 
  */
  save : function(after,switch_to_detail,action_name) {
    //~ var panel = this;
    //~ console.log('20121120 FormPanel.save');
    this.loadMask.show();
    var rec = this.get_current_record();
    if (this.has_file_upload) this.form.fileUpload = true;
    //~ console.log('FormPanel.save()',rec);
    if (!action_name) action_name = this.action_name;
    if (rec) {
      var p = {};
      Ext.apply(p,this.get_base_params());
      p.rp = this.getId();
      //~ if (this.action_name) 
          //~ p.$ext_requests.URL_PARAM_ACTION_NAME = this.action_name;
      p.an = action_name;
      if (rec.phantom) {
        //~ if (this.action_name != 'insert') 
            //~ console.log("Warning: phantom record, but action_name is",this.action_name)
        this.form.submit({
          url: '/api' + this.ls_url,
          method: 'POST',
          params: p, 
          scope: this,
          success: function(form, action) {
            this.loadMask.hide();
            Lino.notify(action.result.message);
            /***
            Close this window, but update the status of the 
            calling window.
            If the calling window is a detail on the same table,
            then it should skip to the new record. But only then.
            A successful response usually has a data_record,
            except if it is a fileupload form where some mysterious 
            decoding problems (20120209) force us to return a record_id 
            which will lead to an additional GET.
            ***/
            var url = this.ls_url;
            var ww = Lino.calling_window();
            if (ww && ww.window.main_item instanceof Lino.FormPanel 
                   && ww.window.main_item.ls_url == this.ls_url) {
                //~ console.log("20120217 case 1");
                ww.status.record_id = action.result.record_id;
                ww.status.data_record = action.result.data_record;
                Lino.close_window();
            } else if (this.ls_detail_handler && switch_to_detail) {
                //~ console.log("20120217 case 2");
                Lino.kill_current_window();
                this.ls_detail_handler.run(null,{
                    record_id:action.result.record_id,
                    data_record: action.result.data_record,
                    base_params:this.get_base_params()
                });
            } else {
                //~ console.log("20120217 case 3");
                Lino.close_window();
            }
            //~ Lino.close_window(function(ww){
                //~ if (ww.window.main_item instanceof Lino.FormPanel 
                    //~ && ww.window.main_item.ls_url == url) {
                  //~ ww.status.record_id = action.result.record_id,
                  //~ ww.status.data_record = action.result.data_record
                //~ }
            //~ });
          },
          failure: function(form,action) { 
            this.loadMask.hide();
            Lino.on_submit_failure(form,action);
          },
          clientValidation: true
        })
      } else {
        //~ if (this.action_name != 'detail') 
            //~ console.log("Warning: non-phantom record, but action_name is",this.action_name)
        this.form.submit({
          url: '/api' + this.ls_url + '/' + rec.id,
          method: 'PUT',
          //~ headers: { 'HTTP_X_REQUESTED_WITH' : 'XMLHttpRequest'},
          scope: this,
          params: p, 
          success: function(form, action) {
            //~ panel.form.setValues(rec.data);
            //~ 20110701 panel.form.my_loadRecord(rec);
            this.loadMask.hide();
            Lino.notify(action.result.message);
            if (action.result.data_record)
                this.set_current_record(action.result.data_record,after);
            else
                console.log("Warning: no data_record in response to FormPanel.PUT")
            //~ this.refresh_with_after(after);
            //~ if (after) after(); else panel.refresh();
          },
          failure: function(form,action) { 
            this.loadMask.hide();
            Lino.on_submit_failure(form,action)},
          clientValidation: true
        })
      }
    } else Lino.notify("Sorry, no current record.");
  }
  
  ,on_cancel : function() { 
    this.get_containing_window().close();
  }
  ,on_ok : function() { 
      this.save(null,true);
      //~ var rec = this.get_current_record();
      //~ if (rec && rec.phantom)
          //~ this.do_when_clean(true,function() { Lino.close_window(); });
  }
  ,config_containing_window : function(wincfg) { 
      wincfg.keys = [
        { key: Ext.EventObject.ENTER, fn: this.on_ok, scope:this }
        ,{ key: Ext.EventObject.ESCAPE, fn: this.on_cancel, scope:this }
      ]
  }
  
  
  /* not used (no longer possible without .dtl files)
  , edit_detail_config : function () {
    var active_tab = {};
    var main = this.items.get(0);
    if (main.getActiveTab !== undefined) {
      var tabitem = main.getActiveTab();
      Ext.apply(active_tab,{$ext_requests.URL_PARAM_TAB : main.items.indexOf(tabitem)});
    }
    var editor = new Ext.form.TextArea();
    var close = function() { win.close(); }
    var _this = this;
    var save = function() { 
      //~ console.log(20110609,arguments); 
      var params = {desc: editor.getValue()};
      Ext.apply(params,active_tab);
      var a = { 
        params: params, 
        method: 'PUT',
        url: ADMIN_URL + '/detail_config' + _this.ls_url,
        failure : Lino.ajax_error_handler(this),
        success: Lino.action_handler( _this, function(result) {
          //~ console.log('detail_config/save success',result);
          win.close();
          document.location = _this.get_permalink();
        })
      };
      //~ console.log('detail_config/save sent',a);
      _this.loadMask.show(); // 20120211
      Ext.Ajax.request(a);
    }
    var save_btn = new Ext.Button({text:'Save',handler:save,disabled:true});
    var win = new Ext.Window({title:'Detail Layout',
      items:editor, layout:'fit',
      width:500,height:500,
      bbar:[{text:'Cancel',handler:close},save_btn]});
    var a = { 
      params:active_tab, 
      method:'GET',
      url:ADMIN_URL+'/detail_config'+_this.ls_url,
      success : function(response) {
        if (response.responseText) {
          var result = Ext.decode(response.responseText);
          if (result.success) {
            editor.setValue(result.desc);
            save_btn.enable();
          }
        }
      }
    };
    Ext.Ajax.request(a);
    win.show();
  }
  */
});



Lino.getRowClass = function(record, rowIndex, rowParams, store) {
    //~ console.log(20130816,record);
    //~ return 'x-grid3-row-green';
    return record.data.row_class;
  //~ if (true) {
      //~ return 'x-grid3-row-red';
  //~ }
  //~ if (record.phantom) {
    //~ console.log(20101009,record);
    //~ rowParams.bodyStyle = "color:red;background-color:blue";
    //~ return 'lino-phantom-row';
    //~ }
  //~ console.log('20101009 not a phantom:',record);
  //~ return '';
}

//~ FOO = 0;



Lino.GridStore = Ext.extend(Ext.data.ArrayStore,{ 
  autoLoad: false
  ,load: function(options) {
    //~ foo.bar = baz; // 20120213
    if (!options) options = {};
    if (!options.params) options.params = {};
    options.params.fmt = 'json';
    options.params.rp = this.grid_panel.getId();
    Lino.insert_subst_user(options.params); // since 20121016
      
    if (this.grid_panel.hide_top_toolbar) {
        //~ console.log("20120206 GridStore.load() toolbar is hidden");
        options.params.start = 0;
        if (this.grid_panel.preview_limit) {
          options.params.limit = this.grid_panel.preview_limit;
        }
    } else {
        var ps = this.grid_panel.calculatePageSize();
        if (!ps) {
            //~ this.gridpanel.on('render',this.load())
          //~ console.log("20120814 GridStore.load() failed to calculate pagesize");
          return false;
            //~ params.$URL_PARAM_LIMIT = 1;
            //~ this.grid_panel.on('render',this.load.createDelegate(this,options))
            //~ return;
        } 
        options.params.limit = ps;
      
        //~ options.params.start = this.grid_panel.getTopToolbar().cursor;
        //~ if (this.grid_panel.getTopToolbar().pageSize !=  ps) {
          //~ console.log("20120206 abort load because toolbar says pagesize",
            //~ this.grid_panel.getTopToolbar().pageSize,
            //~ "while actual pagesize is",ps);
            //~ return;
        //~ }
        
        this.grid_panel.getTopToolbar().pageSize =  ps;
        if (options.params.start == undefined)
            options.params.start = this.grid_panel.getTopToolbar().cursor;
      
    }
      
    this.grid_panel.add_param_values(options.params,true);
    //~ Lino.insert_subst_user(options.params);
    //~ console.log("20120814 GridStore.load()",options.params,this.baseParams);
    //~ if (FOO > 0) {
        //~ foo.bar = baz;
    //~ } else FOO += 1;
    return Lino.GridStore.superclass.load.call(this,options);
  }
});

    
Lino.GridPanel = Ext.extend(Ext.grid.EditorGridPanel,Lino.MainPanel);
Lino.GridPanel = Ext.extend(Lino.GridPanel,Lino.PanelMixin);
Lino.GridPanel = Ext.extend(Lino.GridPanel,{
  quick_search_text : '',
  is_searching : false,
  disabled_in_insert_window : true,
  clicksToEdit:2,
  enableColLock: false,
  autoHeight: false,
  params_panel_hidden : false,
  preview_limit : undefined, 
  //~ loadMask: true,
  //~ viewConfig: {
          //~ getRowClass: Lino.getRowClass,
          //~ emptyText:"$_('No data to display.')"
        //~ },
  loadMask: {msg:"Bitte warten..."},
  
  constructor : function(config){

    config.plugins = [new Lino.GridFilters()];
    
    
    Lino.GridPanel.superclass.constructor.call(this,config);
    
    //~ if (this.containing_window) {
        //~ console.log("20111206 install refresh");
        //~ this.containing_window.on('show',this.refresh,this);
    //~ }
    
  },
  
  unused_is_loading : function() { 
    if (! this.loadMask.el) return true; // not even rendered: 
    // thanks to Marco Pegoraro http://movableapp.com/2011/09/sencha-touch-loadmask-isvisible/
    var loading = (this.loadMask.el.select('.x-loading-msg').elements.length > 0);
    //~ console.log('20130515 GridPanel.is_loading() returns',loading);
    return loading;
    //~ return this.store.getCount() > 0; 
    //~ return (this.loadMask.el.select('.x-loading-msg').elements.length)
    //~ return !this.viewReady; 
    //~ return this.loadMask.isVisible(); 
    //~ return !this.loadMask.disabled; 
  },
  
  unused_config_containing_window : function(wincfg) { 
      //~ temporarily remove save_grid_config button (see /blog(2012/1107)
      if (wincfg.tools != undefined) 
        wincfg.tools = [
          //~ {handler:this.save_grid_data,
            //~ qtip:"$_("Save Grid Data")",
            //~ scope:this, id:"save_data"}, // 20120814
          {handler:this.save_grid_config,
            qtip:"Tabellenkonfiguration speichern",
            scope:this, id:"save"}
        ].concat(wincfg.tools);
      //~ wincfg.listeners = { show: ... };
  },
  init_containing_window : function(win) { 
    //~ console.log("20111206 install refresh");
    //~ win.on('show',this.refresh,this);
  },
  
  initComponent : function(){
    
    /* 
    Problem 20111206:
    When a GridPanel is the main item of the window, then it doesn't 
    have it's own header but uses the window's header bar.
    We must do this in initComponent because e.g. in beforerender 
    it's already to late: a header element has been created because 
    there was a title.
    But Lino.Window adds itself as `this.containing_window` 
    only after the GridPanel has been initialized.
    Workaround is to generate a line "params.containing_window = true;" 
    in the handler function.
    */ 
    //~ if (this.containing_window) {
    if (this.is_main_window) {
        //~ console.log(20111206, 'delete title',this.title,'from',this);
        //~ delete this.title;
        this.tools = undefined;  
        this.title = undefined;  /* simply deleting it 
          isn't enough because that would only 
          unhide the title defined in some base class. */
    } 
    //~ else console.log(20111206, 'dont delete title',this.title,'from',this);
    
    /* e.g. when slave gridwindow called from a permalink */
    //~ if (this.base_params) Ext.apply(bp,this.base_params);  
    //~ bp['fmt'] = 'json';
    
    //~ function on_proxy_write( proxy, action,data, response,rs,options) {
      //~ console.log('20120814 on_proxy_write',action,data,response)
      //~ this.getStore().doUpdate();
      //~ this.getStore().loadData(data);
    //~ }
    //~ function on_proxy_load( proxy, transactionObject, callbackOptions ) {
      //~ console.log('on_proxy_load',transactionObject)
    //~ }
    var proxy = new Ext.data.HttpProxy({ 
      // 20120814 
      url: '/api' + this.ls_url
      ,method: "GET"
      //~ ,url: ADMIN_URL + '/restful' + this.ls_url
      //~ ,restful: true 
      //~ ,listeners: {load:on_proxy_load} 
      //~ ,listeners: {write:on_proxy_write} 
    });
    //~ config.store = new Ext.data.JsonStore({ 
    //~ this.store = new Ext.data.ArrayStore({ 
    this.store = new Lino.GridStore({ 
      grid_panel: this
      ,listeners: { exception: Lino.on_store_exception }
      ,remoteSort: true
      ,totalProperty: "count"
      ,root: "rows"
      //~ ,id: "id" 
      ,proxy: proxy
      //~ autoLoad: this.containing_window ? true : false
      ,idIndex: this.pk_index
      //~ ,baseParams: bp
      ,fields: this.ls_store_fields
      ,idProperty: this.ls_id_property 
      // 20120814
      //~ ,writer : new Ext.data.JsonWriter({
        //~ writeAllFields: false
        //~ ,listful: true
      //~ })
      //~ ,restful : true
    });
      
    //~ console.log('config.pk_index',config.pk_index,config.store),
    delete this.ls_store_fields;
      
    var this_ = this;
    //~ var grid = this;
    this.store.on('load', function() {
        //~ console.log('20120814 GridStore.on(load)',this_.store);
        //~ var da = this_.store.reader.arrayData.disabled_actions;
        //~ if (da) {
            //~ this.cmenu.cascade(function(item){ 
              //~ console.log(20120531, item.itemId, da[item.itemId]);
              //~ if (da[item.itemId]) item.disable(); else item.enable();
            //~ });
        //~ };
        this_.set_param_values(this_.store.reader.arrayData.param_values);
        //~ this_.set_status(this_.store.reader.arrayData.status);
        //~ 20120918
        this.getView().getRowClass = Lino.getRowClass;
        if (this_.store.reader.arrayData.no_data_text) {
            //~ this.viewConfig.emptyText = this_.store.reader.arrayData.no_data_text;
            this.getView().emptyText = this_.store.reader.arrayData.no_data_text;
            this.getView().refresh();
        }
        if (this_.containing_window)
            this_.set_window_title(this_.store.reader.arrayData.title);
            //~ this_.containing_window.setTitle(this_.store.reader.arrayData.title);
        if (!this.is_searching) { // disabled 20121025: quick_search_field may not lose focus
          this.is_searching = false;
          if (this_.selModel.getSelectedCell){
              if (this_.getStore().getCount()) // there may be no data
                  this_.selModel.select(0,0); 
          } else {
              this_.selModel.selectFirstRow();
              this_.getView().focusEl.focus();
          }
        } 
        //~ else console.log("is_searching -> no focussing");
        //~ var t = this.getTopToolbar();
        //~ var activePage = Math.ceil((t.cursor + t.pageSize) / t.pageSize);
        //~ this.quick_search_field.focus(); // 20121024
      }, this
    );
    var actions = Lino.build_buttons(this,this.ls_bbar_actions);
    //~ Ext.apply(config,Lino.build_buttons(this,config.ls_bbar_actions));
    //~ config.bbar, this.cmenu = Lino.build_buttons(this,config.ls_bbar_actions);
    //~ this.cmenu = new Ext.menu.Menu({items: config.bbar});
    delete this.ls_bbar_actions
    if (actions) {
        this.cmenu = actions.cmenu;
    }
    
    if (!this.hide_top_toolbar) {  
      var tbar = [ 
        this.quick_search_field = new Ext.form.TextField({ 
          //~ fieldLabel: "Search"
          listeners: { 
            scope:this_
            //~ ,change:this_.search_change
            
            ,render: Lino.quicktip_renderer("Schnellsuche","Hier Text eingeben für Schnellsuche.")
            
            //~ ,keypress: this.search_keypress 
            ,blur: function() { this.is_searching = false}
          }
          ,validator:function(value) { return this_.search_validate(value) }
          //~ ,tooltip: "Enter a quick search text, then press TAB"
          //~ value: text
          //~ scope:this, 
          //~ ,enableKeyEvents: true
          //~ listeners: { keypress: this.search_keypress }, 
          //~ id: "seachString" 
      })];
      tbar = this.add_params_panel(tbar);
      tbar = tbar.concat([
        { scope:this, 
          //~ text: "[csv]", 
          tooltip: "Diese Tabelle in eine .csv-Datei exportieren", 
          iconCls: 'x-tbar-csv',
          handler: function() { 
            //~ 20130116 var p = Ext.apply({},this.get_base_params());
            //~ 20130116 p.fmt = 'csv';
            //~ url += "?" + Ext.urlEncode(p);
            var p = this.get_current_grid_config();
            Ext.apply(p,this.get_base_params());
            p.fmt = "csv";
            this.add_param_values(p,true);
            
            window.open('/api'+this.ls_url + "?" + Ext.urlEncode(p)) 
          } },
        //~ { scope:this, 
          //~ text: "[html]", 
          //~ handler: function() { 
            //~ var p = this.get_current_grid_config();
            //~ Ext.apply(p,this.get_base_params());
            //~ p.$ext_requests.URL_PARAM_FORMAT = "$ext_requests.URL_FORMAT_PRINTER";
            //~ this.add_param_values(p);
            //~ window.open(ADMIN_URL+'/api'+this.ls_url + "?" + Ext.urlEncode(p)) 
          //~ } },
        { scope:this, 
          //~ text: "[html]", 
          tooltip: "Tabelle als HTML anzeigen", 
          iconCls: 'x-tbar-html',
          handler: function() { 
            var p = this.get_current_grid_config();
            Ext.apply(p,this.get_base_params());
            //~ since 20121226 p.$ext_requests.URL_PARAM_FORMAT = "$ext_requests.URL_FORMAT_PLAIN";
            this.add_param_values(p,true);
            //~ since 20121226 window.open(ADMIN_URL+'/api'+this.ls_url + "?" + Ext.urlEncode(p)) 
            window.open('/plain'+this.ls_url + "?" + Ext.urlEncode(p)) 
          } }
        
        ,{ scope:this, 
          //~ text: "[pdf]", 
          tooltip: "Diese Tabelle in eine .pdf-Datei exportieren", 
          iconCls: 'x-tbar-pdf',
          handler: function() { 
            var p = this.get_current_grid_config();
            Ext.apply(p,this.get_base_params());
            p.fmt = "pdf";
            this.add_param_values(p,true);
            window.open('/api'+this.ls_url + "?" + Ext.urlEncode(p)) 
          } }
        
      ]);
    
    
      var menu = [];
      var set_gc = function(index) {
        return function() {
          //~ console.log('set_gc() 20100812');
          this.getColumnModel().setConfig(
              this.apply_grid_config(index,this.ls_grid_configs,this.ls_columns));
        }
      }
      for (var i = 0; i < this.ls_grid_configs.length;i++) {
        var gc = this.ls_grid_configs[i];
        menu.push({text:gc.label,handler:set_gc(i),scope:this})
      }
      if(menu.length > 1) {
        tbar = tbar.concat([
          { text:"Ansicht",
            menu: menu,
            tooltip:"Andere Ansicht auswählen"
          }
        ]);
      }
      
      if (actions) {
        tbar = tbar.concat(actions.bbar);
          //~ this.bbar = actions.bbar;
      }
      
      this.tbar = new Ext.PagingToolbar({ 
        store: this.store, 
        prependButtons: true, 
        //~ pageSize: this.page_length, 
        pageSize: 1, 
        displayInfo: true, 
        beforePageText: "Seite",
        afterPageText: "von {0}",
        displayMsg: "Zeilen {0} bis {1} von {2}",
        firstText: "Erste Seite",
        lastText: "Letzte Seite",
        prevText: "Vorige Seite",
        nextText: "Nächste Seite",
        items: tbar
      });
      //~ this.on('resize', function(cmp,aw,ah,rw,rh) {
          //~ var ps = this.calculatePageSize();
          //~ if (ps && ps != this.getTopToolbar().pageSize) {
              //~ // console.log('20120203 resize : pageSize',this.getTopToolbar().pageSize,'->',ps);
              //~ // this.getTopToolbar().pageSize =  ps;
              //~ cmp.refresh();
              //~ // this.getTopToolbar().doRefresh();
          //~ }
        //~ }, this);
      //~ this.on('resize', function(cmp,aw,ah,rw,rh) {
          //~ cmp.getTopToolbar().pageSize = this.calculatePageSize(aw,ah,rw,rh) || 10;
          //~ cmp.refresh();
        //~ }, this, {delay:500});
    }
    
    //~ delete this.page_length
    
    
      
    if (this.cell_edit) {
      this.selModel = new Ext.grid.CellSelectionModel()
      this.get_selected = function() {
        //~ console.log(this.getSelectionModel().selection);
        if (this.selModel.selection)
            return [ this.selModel.selection.record ];
        return [this.store.getAt(0)];
      };
      this.get_current_record = function() { 
        if (this.getSelectionModel().selection) 
          return this.selModel.selection.record;
        return this.store.getAt(0);
      };
    } else { 
      this.selModel = new Ext.grid.RowSelectionModel() 
      this.get_selected = function() {
        var sels = this.selModel.getSelections();
        if (sels.length == 0) sels = [this.store.getAt(0)];
        return sels
        //~ var sels = this.getSelectionModel().getSelections();
        //~ return Ext.pluck(sels,'id');
      };
      this.get_current_record = function() { 
        var rec = this.selModel.getSelected();
        if (rec == undefined) rec = this.store.getAt(0);
        return rec
      };
    };
    delete this.cell_edit;
    
    this.columns  = this.apply_grid_config(this.gc_name,this.ls_grid_configs,this.ls_columns);
    
    //~ var grid = this;
    //~ this.colModel = new Ext.grid.ColumnModel({
      //~ columns: this.apply_grid_config(this.gc_name,this.ls_grid_configs,this.ls_columns),
      //~ isCellEditable: function(col, row) {
        //~ var record = grid.store.getAt(row);
        //~ console.log('20120514',col,record); // dataIndex
        //~ var dataIndex = grid.colModel.getDataIndex(col);
        //~ if (dataIndex in record.data['disabled_fields']) {
            //~ Lino.notify("$_("This field is disabled")");
            //~ return false;
        //~ }
        //~ return Ext.grid.ColumnModel.prototype.isCellEditable.call(this, col, row);
      //~ }
    //~ });    
    
    
    Lino.GridPanel.superclass.initComponent.call(this);
    
    //~ if (this.containing_window) 
        //~ this.on('afterlayout', this.refresh, this);
        //~ this.on('afterrender', this.refresh,this);
    //~ else
        //~ this.on('show', this.refresh,this);
    //~ this.on('afterlayout', function() {
      //~ if (this.id == "ext-comp-1157") 
        //~ console.log("20120213 afterlayout",this); 
      //~ // this.refresh();
      //~ },this);
    //~ this.on('afterrender', this.refresh);
    //~ this.on('resize', this.refresh,this,{delay:500});
    //~ this.on('resize', function(){console.log("20120213 resize",arguments)},this);
    this.on('resize', function(){
      //~ console.log("20120213 resize",arguments)
      this.refresh();
      },this);
    this.on('viewready', function(){
      //~ console.log("20120213 resize",arguments);
      this.view_is_ready = true;
      this.refresh();
      },this);
    this.on('afteredit', this.on_afteredit); // 20120814
    //~ this.on('afteredit', this.new_on_afteredit);
    this.on('beforeedit', this.on_beforeedit);
    this.on('beforeedit',function(e) { this.before_row_edit(e.record)},this);
    this.on('cellcontextmenu', Lino.cell_context_menu, this);
    //~ this.on('contextmenu', Lino.grid_context_menu, this);
    
    
    //~ if (this.id == "ext-comp-1157") captureEvents(this);    
    
  },
  
  //~ onResize : function(){
      //~ console.log("20120206 GridPanel.onResize",arguments);
      //~ Lino.GridPanel.superclass.onResize.apply(this, arguments);
      //~ this.refresh();
  //~ },
  
  
  get_status : function(){
    var st = { base_params : this.get_base_params()};
    if (!this.hide_top_toolbar) {
        st.current_page = this.getTopToolbar().current;
    }
    st.param_values = this.status_param_values;
    //~ console.log("20120213 GridPanel.get_status",st);
    return st;
  },
  
  /* 
  Lino.GridPanel.set_status() 
  */
  set_status : function(status){
    //~ console.log("20130605 GridPanel.set_status",status);
    this.clear_base_params();
    if (status == undefined) status = {};
    this.set_param_values(status.param_values);
    if (status.base_params) { 
      this.set_base_params(status.base_params);
    }
    if (status.show_params_panel != undefined) {
        if (this.toggle_params_panel_btn) {
            //~ this.toggle_params_panel_btn.toggle(status.show_params_panel=='true');
            this.toggle_params_panel_btn.toggle(status.show_params_panel);
        }
    }
    if (!this.hide_top_toolbar) {
      //~ console.log("20120213 GridPanel.getTopToolbar().changePage",
          //~ status.current_page || 1);
      this.getTopToolbar().changePage(status.current_page || 1);
    }
    //~ this.fireEvent('resize');
    //~ this.refresh.defer(100,this); 
    //~ this.onResize.defer(100,this); 
    //~ this.refresh(); 
    //~ this.doLayout(); 
    //~ this.onResize(); 
    //~ this.store.load();
  },
  
  refresh : function(unused) { 
    this.refresh_with_after();
  },
  refresh_with_after : function(after) { 
    //~ Lino.notify('20120204 Lino.GridPanel.refresh');
    //~ Lino.notify('Lino.GridPanel.refresh '+this.store.proxy.url);
    //~ var bp = { fmt:'json' }
    if (this.containing_panel) {
        //~ Ext.apply(p,this.master_panel.get_master_params());
        //~ Ext.apply(options.params,this.containing_panel.get_master_params());
        this.set_base_params(this.containing_panel.get_master_params());
    }
    
    if (! this.view_is_ready) return;
    
    var options = {};
    if (after) {
        options.callback = function(r,options,success) {if(success) after()}
    }
      
    //~ if (!this.rendered) {
        //~ console.log("20120206 GridPanel.refresh() must wait until rendered",options);
        //~ this.grid_panel.on('render',this.load.createDelegate(this,options))
        //~ return;
    //~ }
    
    this.store.load(options);
  },
  
  /* pageSize depends on grid height (Trying to remove scrollbar)
  Thanks to 
  - Christophe Badoit on http://www.sencha.com/forum/showthread.php?82647
  - http://www.sencha.com/forum/archive/index.php/t-37231.html
  */
  calculatePageSize : function(second_attempt) {
    //~ if (!this.rendered) { 
    if (!this.view_is_ready) { 
      //~ console.log('Cannot calculatePageSize() : not rendered');
      return false; }
    //~ if (!this.isVisible()) { 
      //~ console.log('calculatePageSize : not visible');
      //~ return false; }
      
    //~ console.log('getFrameHeight() is',this.getFrameHeight());
    //~ console.log('getView().scroller.getHeight() is',this.getView().scroller.getHeight());
    //~ console.log('mainBody.getHeight() is',this.getView().mainBody.getHeight());
    //~ console.log('getInnerHeight() is',this.getInnerHeight());
    //~ console.log('getHeight() is',this.getHeight());
    //~ console.log('el.getHeight() is',this.getEl().getHeight());
    //~ console.log('getGridEl().getHeight() is',this.getGridEl().getHeight());
    //~ console.log('getOuterSize().height is',this.getOuterSize().height);
    //~ console.log('getBox().height is',this.getBox().height);
    //~ console.log('getResizeEl.getHeight() is',this.getResizeEl().getHeight());
    //~ console.log('getLayoutTarget().getHeight() is',this.getLayoutTarget().getHeight());
      
    //~ var rowHeight = 52; // experimental value
    var row = this.view.getRow(0);
    if (row) {
      //~ console.log('20120213 yes');
      var rowHeight = Ext.get(row).getHeight();
    } else {
        //~ var rowHeight = this.getFrameHeight();
        //~ var rowHeight = 10; // reasonably smallest approximative value
        //~ There is no data yet. Construct a fake row and get its height
        var Element = Ext.Element;
        var gv = this.view;
        var fakeBody = new Element(Element.fly(gv.scroller).child('div.x-grid3-body'));
        var rowTemplate = gv.templates.row;
        var cellTemplate = gv.templates.cell;
        var tstyle  = 'width:' + gv.getGridInnerWidth() + 'px;';
        var cells = cellTemplate.apply({value:'&#160;'});
        var markup = rowTemplate.apply({
                tstyle: tstyle,
                cols  : 1,
                cells : cells,
                alt   : ''
            });        
        fakeBody.dom.innerHTML = gv.templates.body.apply({rows: markup});
        var row = fakeBody.dom.childNodes[0];
        var rowHeight = Ext.get(row).getHeight();
    }
    //~ console.log('rowHeight is ',rowHeight,this,caller);
    //~ this.getView().syncScroll();
    //~ this.getView().initTemplates();
    var height = this.getView().scroller.getHeight();
    //~ console.log('getView().scroller.getHeight() is',this.getView().scroller.getHeight());
    //~ console.log('getInnerHeight() - getFrameHeight() is',
      //~ this.getInnerHeight(), '-',
      //~ this.getFrameHeight(), '=',
      //~ this.getInnerHeight() - this.getFrameHeight());
    //~ var height = this.getView().mainBody.getHeight();
    //~ var height = this.getView().mainWrap.getHeight();
    //~ var height = this.getView().resizeMarker.getHeight();
    //~ this.syncSize();
    //~ var height = this.getInnerHeight() - this.getFrameHeight();
    //~ var height = this.getHeight() - this.getFrameHeight();
    height -= Ext.getScrollBarWidth(); // leave room for a possible horizontal scrollbar... 
    //~ height -= this.getView().scrollOffset;
    var ps = Math.floor(height / rowHeight);
    //~ console.log('20130816 calculatePageSize():',height,'/',rowHeight,'->',ps);
    ps -= 1; // leave room for a possible phantom row
    //~ return (ps > 1 ? ps : false);
    if (ps > 1) return ps;
    //~ console.log('calculatePageSize() found less than 1 row:',height,'/',rowHeight,'->',ps);
    //~ foo.bar = baz; // 20120213
    return 5; // preview_limit
    //~ if (second_attempt) {
        //~ console.log('calculatePageSize() abandons after second attempt:',
          //~ height,'/',rowHeight,'->',ps);
      //~ return 5;
    //~ }
    //~ return this.calculatePageSize.defer(500,this,[true]);
  },
  
  onCellDblClick : function(grid, row, col){
      //~ console.log("20120307 onCellDblClick",this,grid, row, col);
      if (this.ls_detail_handler) {
          //~ Lino.notify('show detail');
          Lino.show_detail(this);
          return false;
      }else{
        //~ console.log('startEditing');
        this.startEditing(row,col);
      }
  },
  
  get_base_params : function() {
    //~ return this.containing_window.config.base_params;
    //~ console.log(20120717,this.store.baseParams);
    var p = Ext.apply({},this.store.baseParams);
    Lino.insert_subst_user(p);
    //~ console.log("20120717 GRidPanel.get_base_params() returns",p);
    return p;
    //~ return this.store.baseParams;
  },
  set_base_params : function(p) {
    //~ console.log('GridPanel.set_base_params',p)
    for (k in p) this.store.setBaseParam(k,p[k]);
    //~ this.store.baseParams = p;
    if (p.query) 
        this.quick_search_field.setValue(p.query);
    //~ if (p.param_values) 
        //~ this.set_param_values(p.param_values);  
  },
  clear_base_params : function() {
      this.store.baseParams = {};
      Lino.insert_subst_user(this.store.baseParams);
  },
  set_base_param : function(k,v) {
    this.store.setBaseParam(k,v);
  },
  
  //~ get_permalink_params : function() {
    //~ var p = {};
    //~ return p;
  //~ },
  
  before_row_edit : function(record) {},
    
  //~ search_keypress : function(){
    //~ console.log("2012124 search_keypress",arguments);
  //~ },
  search_validate : function(value) {
    if (value == this.quick_search_text) return true;
    this.is_searching = true;
    //~ console.log('search_validate',value)
    this.quick_search_text = value;
    this.set_base_param('query',value); 
    //~ this.getTopToolbar().changePage(1);
    this.getTopToolbar().moveFirst();
    //~ this.refresh();
    return true;
  },
  
  search_change : function(field,oldValue,newValue) {
    //~ console.log('search_change',field.getValue(),oldValue,newValue)
    this.set_base_param('query',field.getValue()); 
    this.getTopToolbar().moveFirst();
    //~ this.refresh();
  },
  
  apply_grid_config : function(index,grid_configs,rpt_columns) {
    //~ var rpt_columns = this.ls_columns;
    var gc = grid_configs[index];    
    //~ console.log('apply_grid_config() 20100812',name,gc);
    this.gc_name = index;
    if (gc == undefined) {
      return rpt_columns;
      //~ config.columns = config.ls_columns;
      //~ return;
    } 
    //~ delete config.ls_filters
    
    //~ console.log(20100805,config.ls_columns);
    var columns = Array(gc.columns.length);
    for (var j = 0; j < rpt_columns.length;j++) {
      var col = rpt_columns[j];
      for (var i = 0; i < gc.columns.length; i++) {
        if (col.dataIndex == gc.ci[i]) {
          col.width = gc.cw[i];
          col.hidden = gc.ch[i];
          columns[i] = col;
          break;
        }
      }
    }
    
    //~ var columns = Array(rpt_columns.length);
    //~ for (var i = 0; i < rpt_columns.length; i++) {
      //~ columns[i] = rpt_columns[gc.columns[i]];
      //~ columns[i].width = gc.widths[i];
    //~ }
    
    //~ if (gc.hidden_cols) {
      //~ for (var i = 0; i < gc.hidden_cols.length; i++) {
        //~ var hc = gc.hidden_cols[i];
        //~ for (var j = 0; j < columns.length;j++) {
          //~ var col = columns[j];
          //~ if (col.dataIndex == hc) {
            //~ col.hidden = true;
            //~ break
          //~ }
        //~ }
      //~ }
    //~ }
    if (gc.filters) {
      //~ console.log(20100811,'config.ls_filters',config.ls_filters);
      //~ console.log(20100811,'config.ls_grid_config.filters',config.ls_grid_config.filters);
      for (var i = 0; i < gc.filters.length; i++) {
        var fv = gc.filters[i];
        for (var j = 0; j < columns.length;j++) {
          var col = columns[j];
          if (col.dataIndex == fv.field) {
            //~ console.log(20100811, f,' == ',fv);
            if (fv.type == 'string') {
              col.filter.value = fv.value;
              //~ if (fv.comparison !== undefined) f.comparison = fv.comparison;
            } else {
              //~ console.log(20100811, fv);
              col.filter.value = {};
              col.filter.value[fv.comparison] = fv.value;
            }
            break;
          }
        };
      }
    }
    
    return columns;
    //~ config.columns = cols;
    //~ delete config.ls_columns
  },
  
  get_current_grid_config : function () {
    var cm = this.getColumnModel();
    var widths = Array(cm.config.length);
    var hiddens = Array(cm.config.length);
    //~ var hiddens = Array(cm.config.length);
    var columns = Array(cm.config.length);
    //~ var columns = Array(cm.config.length);
    //~ var hidden_cols = [];
    //~ var filters = this.filters.getFilterValues();
    var p = this.filters.buildQuery(this.filters.getFilterData())
    for (var i = 0; i < cm.config.length; i++) {
      var col = cm.config[i];
      columns[i] = col.dataIndex;
      //~ hiddens[i] = col.hidden;
      widths[i] = col.width;
      hiddens[i] = col.hidden;
      //~ if (col.hidden) hidden_cols.push(col.dataIndex);
    }
    //~ p['hidden_cols'] = hidden_cols;
    p.cw = widths;
    p.ch = hiddens;
    p.ci = columns;
    //~ p['widths'] = widths;
    //~ p['hiddens'] = hiddens;
    //~ p['columns'] = columns;
    p['name'] = this.gc_name;
    //~ var gc = this.ls_grid_configs[this.gc_name];
    //~ if (gc !== undefined) 
        //~ p['label'] = gc.label
    //~ console.log('20100810 save_grid_config',p);
    return p;
  },
  
  unused_manage_grid_configs : function() {
    var data = [];
    for (k in this.ls_grid_configs) {
      var v = this.ls_grid_configs[k];
      var i = [k,String(v.columns),String(v.hidden_cols),String(v.filters)];
      data.push(i)
    }
    if (this.ls_grid_configs[this.gc_name] == undefined) {
      var v = this.get_current_grid_config();
      var i = [k,String(v.columns),String(v.hidden_cols),String(v.filters)];
      data.push(i);
    }
    //~ console.log(20100811, data);
    var main = new Ext.grid.GridPanel({
      store: new Ext.data.ArrayStore({
        idIndex:0,
        fields:['name','columns','hidden_cols','filters'],
        autoDestroy:true,
        data: data}),
      //~ autoHeight:true,
      selModel: new Ext.grid.RowSelectionModel(),
      listeners: { 
        rowdblclick: function(grid,rowIndex,e) {
          console.log('row doubleclicked',grid, rowIndex,e);
        },
        rowclick: function(grid,rowIndex,e) {
          console.log('row clicked',grid, rowIndex,e);
        }
      },
      columns: [ 
        {dataIndex:'name',header:'Name'}, 
        {dataIndex:'columns',header:'columns'}, 
        {dataIndex:'hidden_cols',header:'hidden columns'}, 
        {dataIndex:'filters',header:'filters'} 
      ]
    });
    var win = new Ext.Window({title:'GridConfigs Manager',layout:'fit',items:main,height:200});
    win.show();
  },
  
  unused_edit_grid_config : function(name) {
    gc = this.ls_grid_configs[name];
    var win = new Ext.Window({
      title:'Edit Grid Config',layout:'vbox', 
      //~ layoutConfig:'stretch'
      items:[
        {xtype:'text', value: gc.name},
        {xtype:'text', value: gc.columns},
        {xtype:'text', value: gc.hidden_cols},
        {xtype:'text', value: gc.filters}
      ]
    });
    win.show();
  },
  
  save_grid_config : function () {
    //~ console.log('TODO: save_grid_config',this);
    //~ p.column_widths = Ext.pluck(this.colModel.columns,'width');
    var a = { 
      params:this.get_current_grid_config(), 
      method:'PUT',
      url:'/grid_config' + this.ls_url,
      success: Lino.action_handler(this),
      scope: this,
      failure: Lino.ajax_error_handler(this)
    };
    this.loadMask.show(); // 20120211
    Ext.Ajax.request(a);
    //~ Lino.do_action(this,a);
  },
  
  on_beforeedit : function(e) {
    //~ console.log('20130128 GridPanel.on_beforeedit()',e,e.record.data.disable_editing);
    if(this.disable_editing | e.record.data.disable_editing) {
      e.cancel = true;
      Lino.notify("Dieser Datensatz ist deaktiviert");
      return;
    }
    if(e.record.data.disabled_fields && e.record.data.disabled_fields[e.field]) {
      e.cancel = true;
      Lino.notify("Dieses Feld ist deaktiviert");
      return;
    }
    //~ if (e.record.data.disabled_fields) {
      //~ for (i in e.record.data.disabled_fields) {
        //~ if(e.record.data.disabled_fields[i] == e.field) {
          //~ e.cancel = true;
          //~ Lino.notify(String.format('Field "{0}" is disabled for this record',e.field));
          //~ return
        //~ }
      //~ }
    //~ }
  },
  save_grid_data : function() {
      //~ console.log("20120814 save_grid_data");
      this.getStore().commitChanges();
  },
  new_on_afteredit : function(e) {
      //~ this.getStore().commitChanges();
      //~ this.getStore().doUpdate();
      //~ this.getStore().loadData(data);
      console.log("20120814 new_on_afteredit",e);
  },
  on_afteredit : function(e) {
    /*
    e.grid - The grid that fired the event
    e.record - The record being edited
    e.field - The field name being edited
    e.value - The value being set
    e.originalValue - The original value for the field, before the edit.
    e.row - The grid row index
    e.column - The grid column index
    */
    var p = {};
    //~ console.log('20101130 modified: ',e.record.modified);
    //~ console.log('20101130 value: ',e.value);
    //~ var p = e.record.getChanges();
    //~ console.log('20101130 getChanges: ',e.record.getChanges());
    //~ this.before_row_edit(e.record);
    for(k in e.record.getChanges()) {
        var v = e.record.get(k);
    //~ for(k in e.record.modified) {
        //~ console.log('20101130',k,'=',v);
        //~ var cm = e.grid.getColumnModel();
        //~ var di = cm.getDataIndex(k);
        var f = e.record.fields.get(k);
        //~ console.log('20101130 f = ',f);
        //~ var v = e.record.get(di);
        if (f.type.type == 'date') {
            p[k] = Ext.util.Format.date(v, f.dateFormat);
        }else{
            p[k] = v;
            var v = e.record.get(k+'Hidden');
            if (v !== undefined) {
              p[k+'Hidden'] = v;
            }
        }
        //~ var i = cm.findColumnIndex(k);
        //~ var r = cm.getRenderer(i);
        //~ var editor = cm.getCellEditor(i,e.row);
        //~ var col = e.grid.getColumnModel().getColumnById(k);
        //~ console.log('20101130 r = ',r(v));
        //~ var f = e.record.fields[k];
        //~ console.log('20101130 f = ',f);
        //~ console.log('20101130 editor = ',editor);
        //~ p[k] = f.getValue();
        //~ p[k] = r(v);
    }
    //~ console.log('20101130 p:',p);
    //~ var cm = e.grid.getColumnModel();
    //~ var di = cm.getDataIndex(e.column);
    //~ var f = e.record.fields.get(di);
    //~ console.log('20101130 f = ',f);
    //~ if (f.type.type == 'date') e.record.set(di,Ext.util.Format.date(e.value, f.dateFormat));
    
    
    //~ var p = e.record.data;
    
    // var p = {};
    //~ p['grid_afteredit_colname'] = e.field;
    //~ p[e.field] = e.value;
    //~ console.log('20100723 GridPanel.on_afteredit()',e);
    // add value used by ForeignKeyStoreField CHOICES_HIDDEN_SUFFIX
    // not sure whether this is still needed:
    p[e.field+'Hidden'] = e.value;
    //~ p.su = Lino.subst_user;
    Lino.insert_subst_user(p);
    // this one is needed so that this field can serve as choice context:
    e.record.data[e.field+'Hidden'] = e.value;
    // p[pk] = e.record.data[pk];
    // console.log("grid_afteredit:",e.field,'=',e.value);
    Ext.apply(p,this.get_base_params()); // needed for POST, ignored for PUT
    //~ Ext.apply(p,this.containing_window.config.base_params);
    //~ 20121109 p['$ext_requests.URL_PARAM_ACTION_NAME'] = 'grid';
    var self = this;
    var req = {
        params:p,
        waitMsg: 'Saving your data...',
        success: Lino.action_handler( this, function(result) {
          //~ if (result.data_record) {
          if (result.refresh_all) {
              var cw = self.get_containing_window();
              if (cw) {
                  cw.main_item.refresh();
              }
              else console.log("20120123 cannot refresh_all",self);
          } else if (result.rows) {
              //~ self.getStore().loadData(result,true);
              var r = self.getStore().reader.readRecords(result);
              if (e.record.phantom) {
                  //~ console.log("20120816 afteredit.success POST",r);
                  self.getStore().insert(e.row,r.records);
              }else{
                  //~ console.log("20120816 afteredit.success PUT",r);
                  self.getStore().doUpdate(r.records[0]);
              }
              self.getStore().rejectChanges(); /* 
              get rid of the red triangles without saving the record again
              */
              //~ self.getStore().commitChanges(); // get rid of the red triangles
          } else {
              self.getStore().commitChanges(); // get rid of the red triangles
              self.getStore().reload();        // reload our datastore.
          }
          }),
        scope: this,
        failure: Lino.ajax_error_handler(this)
    };
    if (e.record.phantom) {
      req.params.an = 'post'; // SubmitInsert.action_name
      Ext.apply(req,{
        method: 'POST',
        url: '/api' + this.ls_url
      });
    } else {
      req.params.an = 'put'; // SubmitDetail.action_name
      Ext.apply(req,{
        method: 'PUT',
        url: '/api' + this.ls_url + '/' + e.record.id
      });
    }
    //~ console.log('20110406 on_afteredit',req);
    this.loadMask.show(); // 20120211
    Ext.Ajax.request(req);
  },

  afterRender : function() {
    Lino.GridPanel.superclass.afterRender.call(this);
    // this.getView().mainBody.focus();
    // console.log(20100114,this.getView().getRows());
    // if (this.getView().getRows().length > 0) {
    //  this.getView().focusRow(1);
    // }
    //~ this.my_load_mask = new Ext.LoadMask(this.getEl(), {
        //~ msg:'$_("Please wait...")',
        //~ store:this.store});
      
    var tbar = this.getTopToolbar();
    // tbar.on('change',function() {this.getView().focusRow(1);},this);
    // tbar.on('change',function() {this.getSelectionModel().selectFirstRow();this.getView().mainBody.focus();},this);
    // tbar.on('change',function() {this.getView().mainBody.focus();},this);
    // tbar.on('change',function() {this.getView().focusRow(1);},this);
    this.nav = new Ext.KeyNav(this.getEl(),{
      pageUp: function() {tbar.movePrevious(); },
      pageDown: function() {tbar.moveNext(); },
      home: function() {tbar.moveFirst(); },
      end: function() {tbar.moveLast(); },
      scope: this
    });
  },
  after_delete : function() {
    //~ console.log('Lino.GridPanel.after_delete');
    this.refresh();
  },
  add_row_listener : function(fn,scope) {
    this.getSelectionModel().addListener('rowselect',fn,scope);
  },
  postEditValue : function(value, originalValue, r, field){
    value = Lino.GridPanel.superclass.postEditValue.call(this,value,originalValue,r,field);
    //~ console.log('GridPanel.postEdit()',value, originalValue, r, field);
    return value;
  },
  
  set_start_value : function(v) {
      this.start_value = v;
  },
  preEditValue : function(r, field){
      if (this.start_value) {
        var v = this.start_value;
        delete this.start_value;
        this.activeEditor.selectOnFocus = false;
        return v;
      }
      var value = r.data[field];
      return this.autoEncode && Ext.isString(value) ? Ext.util.Format.htmlDecode(value) : value;
  },
  
  on_master_changed : function() {
    //~ if (! this.enabled) return;
    //~ cmp = this;
    //~ console.log('Lino.GridPanel.on_master_changed()',this.title);
    if (! this.rendered) return; // 20120213
    var todo = function() {
      if (this.disabled) return;
      //~ if (this.disabled) return;
      //~ if (this.enabled) {
          //~ var src = caller.config.url_data + "/" + record.id + ".jpg"
          //~ console.log(20111125, this.containing_window);
          //~ for (k in p) this.getStore().setBaseParam(k,p[k]);
          //~ console.log('Lino.GridPanel.on_master_changed()',this.title,p);
          this.refresh();
          //~ this.set_base_params(this.master_panel.get_master_params());
          //~ this.getStore().load(); 
      //~ }
    };
    Lino.do_when_visible(this,todo.createDelegate(this));
  },
  load_record_id : function(record_id,after) {
      Lino.run_detail_handler(this,record_id)
  }
  
});
  

//~ Lino.MainPanelMixin = {
  //~ tbar_items : function() {
      //~ return ;
  //~ }
//~ };

//~ Ext.override(Lino.GridPanel,Lino.MainPanelMixin);
//~ Ext.override(Lino.FormPanel,Lino.MainPanelMixin);

//~ Lino.grid_context_menu = function(e) {
  //~ console.log('contextmenu',arguments);
//~ }

Lino.cell_context_menu = function(grid,row,col,e) {
  //~ console.log('20120531 cellcontextmenu',grid,row,col,e,grid.store.reader.arrayData.rows[row]);
  e.stopEvent();
  //~ grid.getView().focusCell(row,col);
  grid.getSelectionModel().select(row,col);
  //~ console.log(grid.store.getAt(row));
  //~ grid.getView().focusRow(row);
  //~ return;
  if(!grid.cmenu.el){grid.cmenu.render(); }
  //~ if(e.record.data.disabled_fields) {
  
  var da = grid.store.reader.arrayData.rows[row][grid.disabled_actions_index];
  if (da) {
      this.cmenu.cascade(function(item){ 
        //~ console.log(20120531, item.itemId, da[item.itemId]);
        if (da[item.itemId]) item.disable(); else item.enable();
      });
  };
  
  var xy = e.getXY();
  xy[1] -= grid.cmenu.el.getHeight();
  grid.cmenu.showAt(xy);
}


//~ Lino.load_main_menu = function() {
  //~ Ext.Ajax.request({
    //~ waitMsg: 'Loading main menu...',
    //~ method: 'GET',
    //~ url: '/menu',
    //~ success: Lino.on_load_menu,
    //~ failure: Lino.ajax_error_handler
  //~ });
//~ };



//~ Lino.SlavePlugin = function(caller) {
  //~ this.caller = caller;
//~ };

Lino.chooser_handler = function(combo,name) {
  return function(cmp,newValue,oldValue) {
    //~ console.log('Lino.chooser_handler()',cmp,oldValue,newValue);
    combo.setContextValue(name,newValue);
  }
};



Lino.ComboBox = Ext.extend(Ext.form.ComboBox,{
  forceSelection: true,
  triggerAction: 'all',
  minListWidth:230,
  autoSelect: false,
  selectOnFocus: true, // select any existing text in the field immediately on focus.
  submitValue: true,
  displayField: 'text', // 'text', 
  valueField: 'value', // 'value',
  
  //~ initComponent : Ext.form.ComboBox.prototype.initComponent.createSequence(function() {
  initComponent : function(){
      this.contextParams = {};
      //~ Ext.form.ComboBox.initComponent(this);
      Lino.ComboBox.superclass.initComponent.call(this);
  },
  setValue : function(v,record_data){
      /*
      Based on feature request developed in http://extjs.net/forum/showthread.php?t=75751
      */
      /* `record_data` is used to get the text corresponding to this value */
      //~ if(this.name == 'city') 
      //~ console.log('20120203', this.name,'.setValue(', v ,') this=', this,'record_data=',record_data);
      var text = v;
      if(this.valueField){
        if(v == null || v == '') { 
            //~ if (this.name == 'birth_country') 
                //~ console.log(this.name,'.setValue',v,'no lookup needed, value is empty');
            //~ v = undefined;
            v = '';
            //~ text = '';
        } else if (Ext.isDefined(record_data)) {
          text = record_data[this.name];
          //~ if (this.name == 'birth_country') 
            //~ console.log(this.name,'.setValue',v,'got text ',text,' from record ',record);
        } else {
          // if(this.mode == 'remote' && !Ext.isDefined(this.store.totalLength)){
          if(this.mode == 'remote' && ( this.lastQuery === null || (!Ext.isDefined(this.store.totalLength)))){
              //~ if (this.name == 'birth_country') console.log(this.name,'.setValue',v,'store not yet loaded');
              this.store.on('load', this.setValue.createDelegate(this, arguments), null, {single: true});
              if(this.store.lastOptions === null || this.lastQuery === null){
                  var params;
                  if(this.valueParam){
                      params = {};
                      params[this.valueParam] = v;
                  }else{
                      var q = this.allQuery;
                      this.lastQuery = q;
                      this.store.setBaseParam(this.queryParam, q);
                      params = this.getParams(q);
                  }
                  //~ if (this.name == 'birth_country') 
                    //~ console.log(this.name,'.setValue',v,' : call load() with params ',params);
                  this.store.load({params: params});
              //~ }else{
                  //~ if (this.name == 'birth_country') 
                    //~ console.log(this.name,'.setValue',v,' : but store is loading',this.store.lastOptions);
              }
              return;
          //~ }else{
              //~ if (this.name == 'birth_country') 
                //~ console.log(this.name,'.setValue',v,' : store is loaded, lastQuery is "',this.lastQuery,'"');
          }
          var r = this.findRecord(this.valueField, v);
          if(r){
              text = r.data[this.displayField];
          }else if(this.valueNotFoundText !== undefined){
              text = this.valueNotFoundText;
          }
        }
      }
      this.lastSelectionText = text;
      //~ this.lastSelectionText = v;
      if(this.hiddenField){
          //~ this.hiddenField.originalValue = v;
          this.hiddenField.value = v;
      }
      Ext.form.ComboBox.superclass.setValue.call(this, text);
      this.value = v; // needed for grid.afteredit
  },
  
  getParams : function(q){
    // p = Ext.form.ComboBox.superclass.getParams.call(this, q);
    // causes "Ext.form.ComboBox.superclass.getParams is undefined"
    var p = {};
    //p[this.queryParam] = q;
    if(this.pageSize){
        //~ p.start = 0;
        //~ p.limit = this.pageSize;
        p['start'] = 0;
        p['limit'] = this.pageSize;
    }
    // now my code:
    if(this.contextParams) Ext.apply(p,this.contextParams);
    //~ if(this.contextParams && this.contextValues) {
      //~ for(i = 0; i <= this.contextParams.length; i++)
        //~ p[this.contextParams[i]] = this.contextValues[i];
    //~ }
    return p;
  },
  setContextValue : function(name,value) {
    //~ console.log('setContextValue',this,this.name,':',name,'=',value);
    //~ if (this.contextValues === undefined) {
        //~ this.contextValues = Array(); // this.contextParams.length);
    //~ }
    if (this.contextParams[name] != value) {
      //~ console.log('setContextValue 1',this.contextParams);
      this.contextParams[name] = value;
      this.lastQuery = null;
      //~ console.log('setContextValue 2',this.contextParams);
    }
  }
});

Lino.ChoicesFieldElement = Ext.extend(Lino.ComboBox,{
  mode: 'local'
});


Lino.SimpleRemoteComboStore = Ext.extend(Ext.data.JsonStore,{
  forceSelection: true,
  constructor: function(config){
      Lino.SimpleRemoteComboStore.superclass.constructor.call(this, Ext.apply(config, {
          totalProperty: 'count',
          root: 'rows',
          id: 'value', // ext_requests.CHOICES_VALUE_FIELD
          fields: ['value' ], // ext_requests.CHOICES_VALUE_FIELD, // ext_requests.CHOICES_TEXT_FIELD
          listeners: { exception: Lino.on_store_exception }
      }));
  }
});

Lino.ComplexRemoteComboStore = Ext.extend(Ext.data.JsonStore,{
  constructor: function(config){
      Lino.ComplexRemoteComboStore.superclass.constructor.call(this, Ext.apply(config, {
          totalProperty: 'count',
          root: 'rows',
          id: 'value', // ext_requests.CHOICES_VALUE_FIELD
          fields: ['value','text'], // ext_requests.CHOICES_VALUE_FIELD, // ext_requests.CHOICES_TEXT_FIELD
          listeners: { exception: Lino.on_store_exception }
      }));
  }
});

Lino.RemoteComboFieldElement = Ext.extend(Lino.ComboBox,{
  mode: 'remote',
  //~ forceSelection:false,
  minChars: 2, // default 4 is too much
  queryDelay: 300, // default 500 is maybe slow
  queryParam: 'query', 
  //~ typeAhead: true,
  //~ selectOnFocus: true, // select any existing text in the field immediately on focus.
  resizable: true
});

/*
Thanks to Animal for posting the basic idea:
http://www.sencha.com/forum/showthread.php?15842-2.0-SOLVED-Combobox-twintrigger-clear&p=76130&viewfull=1#post76130

*/
Lino.TwinCombo = Ext.extend(Lino.RemoteComboFieldElement,{
    trigger2Class : 'x-form-search-trigger',
    //~ trigger2Class : 'x-tbar-detail',
    initComponent : function() {
        //~ Lino.TwinCombo.superclass.initComponent.call(this);
        Lino.ComboBox.prototype.initComponent.call(this);
        Ext.form.TwinTriggerField.prototype.initComponent.call(this);
    },
    onTrigger2Click : function() {
        //~ console.log('onTrigger2Click',this,arguments);
    }
  });
//~ Lino.TwinCombo.prototype.initComponent = Ext.form.TwinTriggerField.prototype.initComponent;
Lino.TwinCombo.prototype.getTrigger = Ext.form.TwinTriggerField.prototype.getTrigger;
Lino.TwinCombo.prototype.getOuterSize = Ext.form.TwinTriggerField.prototype.getOuterSize;
Lino.TwinCombo.prototype.initTrigger = Ext.form.TwinTriggerField.prototype.initTrigger;
Lino.TwinCombo.prototype.onTrigger1Click = Ext.form.ComboBox.prototype.onTriggerClick;
//~ Lino.TwinCombo.prototype.onTrigger2Click = function() {
    //~ console.log('onTrigger2Click',arguments);
//~ };



Lino.SimpleRemoteComboFieldElement = Ext.extend(Lino.RemoteComboFieldElement,{
  displayField: 'value', 
  valueField: null,
  forceSelection: false
});




Lino.Window = Ext.extend(Ext.Window,{
  //~ layout: "fit", 
  closeAction : 'hide',
  renderTo: 'main_area', 
  constrain: true,
  maximized: true,
  draggable: false,
  width: 700,
  height: 500,
  maximizable: false,
  constructor : function (config) {
    if (config.main_item.params_panel) {
        config.layout = 'border';
        config.main_item.region = 'center';
        config.main_item.params_panel.region = 'north';
        config.main_item.params_panel.hidden = config.main_item.params_panel_hidden;
        config.items = [config.main_item.params_panel, config.main_item];
    } else {
        config.layout = 'fit';
        config.items = config.main_item;
    }
    this.main_item = config.main_item; 
    
    delete config.main_item;
    //~ delete config.params_item;
    
    //~ this.main_item = config.items.get(0);
    this.main_item.containing_window = this;
    
    //~ console.log('20120110 Lino.Window.constructor() 1');
    //~ if (Lino.current_window) { // all windows except the top are closable
    if (this.main_item.hide_window_title) { 
      config.closable = false;
      config.frame = false;
      config.shadow = false;
      //~ config.border = true;
      //~ config.title = undefined;
      //~ config.tools = null;
      delete config.title;
      delete config.tools;
    } else {
      config.title = this.main_item.empty_title;
      config.closable = true;
      config.tools = [ 
        { qtip: 'permalink', handler: Lino.permalink_handler(this), id: "pin" }
      ];
      if (this.main_item.content_type && this.main_item.action_name != 'insert') {
        config.tools = [ {
          handler: Lino.help_text_editor,
          qtip: "Hilfetexte der Eingabefelder dieser Tabelle bearbeiten",
          scope: this.main_item,
          id: "gear"
        }].concat(config.tools);
      }
        
    //~ { qtip: '', handler: Lino.save_wc_handler(this), id: "save" }, 
    //~ { qtip: this.config.qtip, handler: Lino.save_wc_handler(this), id: "save" }, 
    //~ { qtip: 'Call doLayout() on main Container.', handler: Lino.refresh_handler(this), id: "refresh" },
    //~ if (this.main_item.params_panel) {
        //~ config.tools = config.tools.concat([ 
          //~ { qtip: 'Show/hide parameter panel', handler: this.toggle_params_panel, id: "gear", scope:this } 
        //~ ]);
    //~ }
    //~ if (config.closable !== false) {
      // if undefined, will take default behaviour
      //~ config.tools = config.tools.concat([ 
        //~ { qtip: 'close', handler: this.hide, id: "close", scope:this } 
      //~ ]);
    }
    
    this.main_item.config_containing_window(config);
    
    //~ console.log('20120110 Lino.Window.constructor() 2');
    Lino.Window.superclass.constructor.call(this,config);
    
    //~ console.log('20120110 Lino.Window.constructor() 3');
    
  },
  initComponent : function() {
    this.main_item.init_containing_window(this);
    Lino.Window.superclass.initComponent.call(this);
  
  },
  hide : function() { 
      this.main_item.do_when_clean(false,function() { 
        Lino.close_window(); });
  },
  hide_really : function() { 
    Lino.Window.superclass.hide.call(this);
  },
  onRender : function(ct, position){
    //~ console.log('20120110 Lino.Window.onRender() 1');
    Lino.Window.superclass.onRender.call(this, ct, position);
    var main_area = Ext.getCmp('main_area')
    //~ console.log('20120110 Lino.Window.onRender() 2');
  
    this.on('show', function(win) {
        //~ console.log('20120110 Lino.Window.on show 1');
        main_area.on('resize', win.onWindowResize, win);
    });
    this.on('hide', function(win) {
        main_area.un('resize', win.onWindowResize, win);
    });
    //~ console.log('20120110 Lino.Window.onRender() 3');
  }
});


Lino.unused_ParamWindow = Ext.extend(Lino.Window,{
  //~ layout: "border", 
  constructor : function (config) {
    Lino.ParamWindow.superclass.constructor.call(this,config);
    this.main_item = config.items; // `items` must be a single component
    config.layout = 'border';
    this.main_item.region = 'center';
    config.params.region = 'north';
    config.items = [config.params, config.items];
    //~ delete config.params;
  }
});




(function(){
    var ns = Ext.ns('Ext.ux.plugins');

    /**
     * @class Ext.ux.plugins.DefaultButton
     * @extends Object
     *
     * Plugin for Button that will click() the button if the user presses ENTER while
     * a component in the button's form has focus.
     *
     * @author Stephen Friedrich
     * @date 09-DEC-2009
     * @version 0.1
     *
     */
    ns.DefaultButton =  Ext.extend(Object, {
        init: function(button) {
            button.on('afterRender', setupKeyListener, button);
        }
    });

    function setupKeyListener() {
        var formPanel = this.findParentByType('form');
        new Ext.KeyMap(formPanel.el, {
            key: Ext.EventObject.ENTER,
            shift: false,
            alt: false,
            fn: function(keyCode, e){
                if(e.target.type === 'textarea' && !e.ctrlKey) {
                    return true;
                }

                this.el.select('button').item(0).dom.click();
                return false;
            },
            scope: this
        });
    }

    Ext.ComponentMgr.registerPlugin('defaultButton', ns.DefaultButton);

})(); 

Ext.override(Ext.form.BasicForm,{
    my_loadRecord : function(values){
    //~ loadRecord : function(record){
        /* Same as ExtJS's loadRecord() (setValues()), except that we 
        forward also the record to field.setValue() so that Lino.Combobox 
        can use it. 
        */
        //~ console.log('20120918 my_loadRecord',values)
        if(Ext.isArray(values)){ 
            for(var i = 0, len = values.length; i < len; i++){
                var v = values[i];
                var f = this.findField(v.id);
                if(f){
                    f.setValue(v.value,values);
                    if(this.trackResetOnLoad){
                        f.originalValue = f.getValue();
                    }
                }
            }
        }else{ 
            var field, id;
            for(id in values){
                if(!Ext.isFunction(values[id]) && (field = this.findField(id))){
                    field.setValue(values[id],values);
                    if(this.trackResetOnLoad){
                        field.originalValue = field.getValue();
                        //~ if (field.hiddenField) {
                          //~ field.hiddenField.originalValue = field.hiddenField.value;
                        //~ }
                    }
                }
            }
        }
        return this;
    }
});




function initializeFooBarDropZone(cmp) {
    //~ console.log('initializeFooBarDropZone',cmp);
    cmp.dropTarget = new Ext.dd.DropTarget(cmp.bwrap, {
      //~ ddGroup     : 'gridDDGroup',
      notifyEnter : function(ddSource, e, data) {
        console.log('notifyEnter',ddSource,e,data);
        //Add some flare to invite drop.
        cmp.body.stopFx();
        cmp.body.highlight();
      },
      notifyDrop  : function(ddSource, e, data){
        console.log('notifyDrop',ddSource,e,data);
        // Reference the record (single selection) for readability
        //~ var selectedRecord = ddSource.dragData.selections[0];


        // Load the record into the form
        //~ formPanel.getForm().my_loadRecord(selectedRecord);


        // Delete record from the grid.  not really required.
        //~ ddSource.grid.store.remove(selectedRecord);

        return(true);
      }
    })
}



Lino.show_mti_child = function(fieldname,detail_handler) {
  //~ console.log('show_mti_child',this);
  //~ console.log('show_mti_child',panel.find("main_area"));
  rec = Lino.current_window.main_item.get_current_record();
  //~ rec = panel.get_current_record();
  if (rec) {
    //~ console.log('show_mti_child',Lino.current_window,rec);
    if (rec.phantom) {
      Lino.notify('Not allowed on phantom record.');
    }else if (rec.data[fieldname]) {
      //~ console.log('show_mti_child',rec.id);
      //~ detail_handler(Lino.current_window.main_item,{},{record_id:rec.id});
      detail_handler.run(null,{record_id:rec.id});
      //~ window.open(urlroot + '/' + rec.id);
      //~ document.location = urlroot + '/' + rec.id;
      //~ window.open(urlroot + '/' + rec.id,'_blank');
    } else {
      Lino.alert("Kann MTI-Kind nicht anzeigen wenn Checkbox abgeschlatet ist.");
    }
  } else {
    Lino.notify('No current record.');
  }
};



Lino.davlink_open = function(webdavURL) {
  /* Calls lino.applets.davlink.DavLink.open()
  */
  //~ console.log('Going to call document.applets.DavLink.open(',webdavURL,')');
  var rv = document.applets.DavLink.open(webdavURL);
  if (rv) window.alert(rv);
}






/*
Mappings towards lino.modlib.cal.models.PanelCalendars
*/
// Sset SS = Ssite.modules.cal.PanelCalendars.get_handle(Sui).store
Ext.ensible.cal.CalendarMappings = {
    CalendarId:   {name:'ID',       mapping: 'id', type: 'int'},
    Title:        {name:'CalTitle', mapping: 'babel_name', type: 'string'},
    Description:  {name:'Desc',     mapping: 'description', type: 'string'},
    ColorId:      {name:'Color',    mapping: 'color', type: 'int'},
    IsHidden:     {name:'Hidden',   mapping: 'is_hidden', type: 'boolean'},    
};
Ext.ensible.cal.CalendarRecord.reconfigure();  


/*
Mappings towards lino.modlib.cal.models.PanelEvents 
*/
// Sset SS = Ssite.modules.cal.PanelEvents.get_handle(Sui).store
Ext.ensible.cal.EventMappings = {
    EventId:     {name: 'ID',        mapping: 'id', type:'int'},
    CalendarId:  {name: 'CalID',     mapping: 'calendarHidden', type: 'int'},
    Title:       {name: 'EvtTitle',  mapping: 'summary'},
    StartDate:   {name: 'StartDt',   mapping: 'start_dt', 
      type: 'date', 
      dateFormat: "Y-m-d\TH:i:s" },
    EndDate:     {name: 'EndDt',     mapping: 'end_dt', 
      type: 'date', 
      dateFormat: "Y-m-d\TH:i:s"},
    RRule:       {name: 'RecurRule', mapping: 'rsetHidden'},
    Location:    {name: 'Location',  mapping: 'placeHidden'},
    Notes:       {name: 'Desc',      mapping: 'description'},
    Url:         {name: 'LinkUrl',   mapping: 'url'},
    IsAllDay:    {name: 'AllDay',    mapping: 'all_day', type: 'boolean'},
    Reminder:    {name: 'Reminder',  mapping: 'reminder'}
    
};
Ext.ensible.cal.EventRecord.reconfigure();


//~ Lino.on_eventclick = 
    
Lino.on_editdetails = 

Lino.format_time = function(dt) {
    return dt.getHours() + ':' + dt.getMinutes();
}
    
Lino.on_eventdelete = function() {
  //~ console.log("Lino.on_eventdelete",arguments);
};

Lino.on_eventadd  = function(cp,rec,el) {
  //~ console.log("Lino.on_eventadd ",arguments);
  return false;
}
    
Lino.on_eventresize  = function(cp,rec,el) {
  //~ console.log("Lino.on_eventresize ",arguments);
  //~ Lino.cal.Events.insert(cp);
  //~ return false;
}
    
Lino.on_eventupdate  = function(cp,rec,el) {
  //~ console.log("Lino.on_eventupdate",arguments);
  //~ Lino.cal.Events.insert(cp);
  //~ return false;
}
    

//~ Lino.eventStore = new Ext.ensible.cal.EventStore({ 
//~ Lino.eventStore = new Ext.data.ArrayStore({ 
Lino.unused_eventStore = new Ext.data.JsonStore({ 
  listeners: { exception: Lino.on_store_exception }
  ,url: '/restful/cal/PanelEvents'
  ,restful : true
  ,proxy: new Ext.data.HttpProxy({ 
      url: '/restful/cal/PanelEvents', 
      disableCaching: false // no need for cache busting when loading via Ajax
      //~ disableCaching:true,
  })
  ,fields: Ext.ensible.cal.EventRecord.prototype.fields.getRange()
  ,totalProperty: "count"
  ,root: "rows"
  ,idProperty: Ext.ensible.cal.EventMappings.EventId.mapping
  ,writer : new Ext.data.JsonWriter({
    writeAllFields: false
  })
  ,load: function(options) {
    //~ foo.bar = baz; // 20120213
      if (!options) options = {};
      if (!options.params) options.params = {};
      //~ options.params.$ext_requests.URL_PARAM_TEAM_VIEW = Lino.calendar_app.team_view_button.pressed;
      
      var view = this.cal_panel.getActiveView();
      var bounds = view.getViewBounds();
      //~ var p = {sd:'05.02.2012',ed:'11.02.2012'};
      //~ var p = {};
      options.params[view.dateParamStart] = bounds.start.format(view.dateParamFormat);
      options.params[view.dateParamEnd] = bounds.end.format(view.dateParamFormat);
      Lino.insert_subst_user(options.params);
      //~ Ext.apply(options.params,p)
      //~ console.log('20120710 eventStore.load()',this.baseParams,options);
    
    return Ext.data.JsonStore.prototype.load.call(this,options);
  }
});

//~ Lino.eventStore.on('load', function() {
//~ });


    //~ Lino.subst_user = id;


//~ Lino.calendarStore = new Ext.data.ArrayStore({ 
Lino.unused_calendarStore = new Ext.data.JsonStore({ 
      listeners: { exception: Lino.on_store_exception }
      ,restful : true
      ,proxy: new Ext.data.HttpProxy({ 
          url: '/restful/cal/PanelCalendars?fmt=json', 
          disableCaching: false // no need for cache busting when loading via Ajax
          //~ restful : true
          //~ method: "GET"
      })
      //~ ,autoLoad: true
      //~ ,remoteSort: true
      //~ ,baseParams: bp
      ,totalProperty: "count"
      ,root: "rows"
      ,fields: Ext.ensible.cal.CalendarRecord.prototype.fields.getRange()
      ,idProperty: Ext.ensible.cal.CalendarMappings.CalendarId.mapping
      //~ ,idIndex: Ext.ensible.cal.CalendarMappings.CalendarId.mapping
    });


Lino.CalendarCfg = {
    dateParamFormat: 'd.m.Y',
    dateParamStart:'sd',
    dateParamEnd:'ed'
};
//~ 20120704 Lino.CalendarPanel = Ext.extend(Ext.ensible.cal.CalendarPanel,Lino.MainPanel);
//~ Lino.CalendarPanel = Ext.extend(Lino.CalendarPanel,{
Ext.override(Ext.ensible.cal.CalendarPanel,Lino.MainPanel);
Ext.override(Ext.ensible.cal.CalendarPanel,{
  //~ empty_title : "\$ui.get_actor('cal.Panel').report.label",
  empty_title : "Kalender"
  ,activeItem: 1 // 0: day, 1: week
  ,ls_url: '/cal/CalendarPanel'
  //~ ,disableCaching:true
  //~ ,eventStore: Lino.eventStore
  //~ ,calendarStore: Lino.calendarStore
  //~ ,initComponent : function(){
    //~ Ext.ensible.cal.CalendarPanel.superclass.initComponent.call(this);
    //~ this.eventStore.on('load',function(){
      //~ console.log("20130808",Lino.eventStore);
      //~ if (this.eventStore.reader.jsonData) {
        //~ console.log("20130808 b",this.eventStore.reader.jsonData.title);
        //~ this.set_window_title(this.eventStore.reader.jsonData.title);
      //~ }
    //~ },this);
  //~ }
  ,listeners: { 
    editdetails: function(cp,rec,el) {
      //~ console.log("Lino.on_editdetails",arguments);
      if (rec.data.ID)
          Lino.cal.PanelEvents.detail.run(null,{record_id:rec.data.ID,base_params:this.app_instance.event_store.baseParams});
      return false;
    }
    ,eventclick: function(cp,rec,el) {
      //~ console.log("Lino.on_eventclick",arguments);
      //~ Lino.cal.Events.detail_action.run({record_id:rec.data.ID});
      Lino.cal.PanelEvents.detail.run(null,{record_id:rec.data.ID,base_params:this.app_instance.event_store.baseParams});
      return false;
    }
    //~ ,eventadd: Lino.on_eventadd
    //~ ,eventdelete: Lino.on_eventdelete
    //~ ,eventresize: Lino.on_eventresize
    ,afterrender : function(config) {
      //~ console.log("20120704 afterrender");
      this.app_instance.calendar_store.load();
      //~ console.log("20120704 afterrender calls eventStore.load()",p);
      this.app_instance.event_store.cal_panel = this;
      //~ Lino.eventStore.load({params:p});
      this.app_instance.event_store.load();
      //~ Lino.CalendarPanel.superclass.constructor.call(this, config);
      //~ console.log(20120118, config,this);
    }
    }
  ,enableEditDetails: false
  //~ ,monthViewCfg: Lino.CalendarCfg
  //~ ,weekViewCfg: Lino.CalendarCfg
  //~ ,multiDayViewCfg: Lino.CalendarCfg
  //~ ,multiWeekViewCfg: Lino.CalendarCfg
  //~ ,dayViewCfg: Lino.CalendarCfg
  //~ ,initComponent : function() {
    //~ // this.on('eventadd',Lino.on_eventadd);
    //~ Lino.CalendarPanel.superclass.initComponent.call(this);
  //~ }
});




Lino.CalendarAppPanel = Ext.extend(Ext.Panel,Lino.MainPanel);
Lino.CalendarAppPanel = Ext.extend(Lino.CalendarAppPanel,Lino.PanelMixin);
Lino.CalendarAppPanel = Ext.extend(Lino.CalendarAppPanel,{
  app_instance : null
  //~ empty_title : "\$ui.get_actor('cal.Panel').report.label",
  ,empty_title : "Kalender"
  ,ls_url: '/cal/CalendarPanel'
  ,set_status : function(status,rp) { 
      this.requesting_panel = Ext.getCmp(rp);
      //~ console.log('20120918 CalendarAppPanel.set_status()',status,rp,this.requesting_panel);
      this.clear_base_params();
      if (status == undefined) status = {};
      //~ if (status.param_values) 
      //~ this.set_field_values(status.field_values);
      if (status.base_params) this.set_base_params(status.base_params);
      this.refresh();
      }
  ,refresh : function() {
      this.app_instance.event_store.reload();
  }
  ,layout: 'fit'
  ,get_base_params : function() {
    var p = Ext.apply({},this.base_params);
    Lino.insert_subst_user(p);
    return p;
  }
  ,set_base_params : function(p) {
    this.base_params = Ext.apply(this.app_instance.event_store.baseParams,p);
    this.app_instance.event_store.baseParams = this.base_params;
  }
  ,clear_base_params : function() {
      this.base_params = {};
      Lino.insert_subst_user(this.base_params);
  }
  ,set_base_param : function(k,v) {
      if (!this.base_params) this.base_params = {};
      this.base_params[k] = v;
  }
});

Lino.CalendarApp = function() { return {
  team_view_button : null 
  ,get_main_panel : function() {
      this.event_store = new Ext.data.JsonStore({ 
          listeners: { exception: Lino.on_store_exception }
          ,url: '/restful/cal/PanelEvents'
          ,restful : true
          ,proxy: new Ext.data.HttpProxy({ 
              url: '/restful/cal/PanelEvents', 
              disableCaching: false // no need for cache busting when loading via Ajax
              //~ disableCaching:true,
          })
          ,fields: Ext.ensible.cal.EventRecord.prototype.fields.getRange()
          ,totalProperty: "count"
          ,root: "rows"
          ,idProperty: Ext.ensible.cal.EventMappings.EventId.mapping
          ,writer : new Ext.data.JsonWriter({
            writeAllFields: false
          })
          ,load: function(options) {
            //~ foo.bar = baz; // 20120213
              if (!options) options = {};
              if (!options.params) options.params = {};
              //~ options.params.$ext_requests.URL_PARAM_TEAM_VIEW = Lino.calendar_app.team_view_button.pressed;
              
              var view = this.cal_panel.getActiveView();
              var bounds = view.getViewBounds();
              //~ var p = {sd:'05.02.2012',ed:'11.02.2012'};
              //~ var p = {};
              options.params[view.dateParamStart] = bounds.start.format(view.dateParamFormat);
              options.params[view.dateParamEnd] = bounds.end.format(view.dateParamFormat);
              Lino.insert_subst_user(options.params);
              //~ Ext.apply(options.params,p)
              //~ console.log('20120710 eventStore.load()',this.baseParams,options);
            
            return Ext.data.JsonStore.prototype.load.call(this,options);
          }
      });

      //~ Lino.calendarStore
      this.calendar_store = new Ext.data.JsonStore({ 
          listeners: { exception: Lino.on_store_exception }
          ,restful : true
          ,proxy: new Ext.data.HttpProxy({ 
              url: '/restful/cal/PanelCalendars?fmt=json', 
              disableCaching: false // no need for cache busting when loading via Ajax
              //~ restful : true
              //~ method: "GET"
          })
          //~ ,autoLoad: true
          //~ ,remoteSort: true
          //~ ,baseParams: bp
          ,totalProperty: "count"
          ,root: "rows"
          ,fields: Ext.ensible.cal.CalendarRecord.prototype.fields.getRange()
          ,idProperty: Ext.ensible.cal.CalendarMappings.CalendarId.mapping
          //~ ,idIndex: Ext.ensible.cal.CalendarMappings.CalendarId.mapping
      });
      
      var cap = new Lino.CalendarAppPanel({ 
          app_instance: this, 
          items : 
        //~ [{
          //~ id: 'app-header',
          //~ region: 'north',
          //~ height: 35,
          //~ border: false,
          // contentEl: 'app-header-content'
        //~ },
      {
          id: 'app-center',
          title: '...', // will be updated to the current view's date range
          region: 'center',
          layout: 'border',
          listeners: {
              'afterrender': function(){
                  Ext.getCmp('app-center').header.addClass('app-center-header');
              }
          },
          items: [{
              id:'app-west',
              region: 'west',
              width: 176,
              border: false,
              items: [{
                  xtype: 'datepicker',
                  id: 'app-nav-picker',
                  cls: 'ext-cal-nav-picker',
                  listeners: {
                      'select': {
                          fn: function(dp, dt){
                              //~ Lino.calendarPanel.setStartDate(dt);
                              this.setStartDate(dt);
                          },
                          scope: this
                      }
                  }
              //~ },{ 
                //~ layout:'fit',
                //~ items: [
                  //~ new Ext.form.Checkbox({
                    //~ boxLabel:"$_('Team view')",
                    //~ hideLabel:true
                    //~ listeners: { click: }
                  //~ })
                //~ ]
              },{ 
                layout:'form',
                items: [
                  this.team_view_button = new Ext.Button({
                    text:"Team-Ansicht",
                    enableToggle:true,
                    pressed:false,
                    toggleHandler: function(btn,state) { 
                      //~ console.log('20120716 teamView.toggle()');
                      this.event_store.setBaseParam('tv',state);
                      this.event_store.load();
                      //~ Lino.eventStore.load({params:{$ext_requests.URL_PARAM_TEAM_VIEW:state}});
                      //~ console.log("team view",state);
                    }
                  })
                ]
              },{
                  xtype: 'extensible.calendarlist',
                  store: this.calendar_store,
                  border: false,
                  width: 175
              }]
          },{
              xtype: 'extensible.calendarpanel', // Ext.ensible.cal.CalendarPanel
              eventStore: this.event_store,
              app_instance: this,
              calendarStore: this.calendar_store,
              border: false,
              id:'app-calendar',
              region: 'center',
              //~ activeItem: 3, // month view
              
              // Any generic view options that should be applied to all sub views:
              viewConfig: {
                  // Lino.CalendarCfg
                  dateParamFormat: 'd.m.Y',
                  dateParamStart:'sd',
                  dateParamEnd:'ed',
                
                  //enableFx: false,
                  //ddIncrement: 10, //only applies to DayView and subclasses, but convenient to put it here
                  viewStartHour: 8,
                  viewEndHour: 18
                  //minEventDisplayMinutes: 15
              },
              
              // View options specific to a certain view (if the same options exist in viewConfig
              // they will be overridden by the view-specific config):
              monthViewCfg: {
                  showHeader: true,
                  showWeekLinks: true,
                  showWeekNumbers: true,
                  eventBodyMarkup: ['{Title}',
                    //~ '<tpl if="url">',
                        //~ '<a href="{url}">XX</a>',
                    //~ '</tpl>',
                    '<tpl if="_isReminder">',
                        '<i class="ext-cal-ic ext-cal-ic-rem">&#160;</i>',
                    '</tpl>',
                    '<tpl if="_isRecurring">',
                        '<i class="ext-cal-ic ext-cal-ic-rcr">&#160;</i>',
                    '</tpl>',
                    '<tpl if="spanLeft">',
                        '<i class="ext-cal-spl">&#160;</i>',
                    '</tpl>',
                    '<tpl if="spanRight">',
                        '<i class="ext-cal-spr">&#160;</i>',
                    '</tpl>'
                ].join('')
              },
              
              multiWeekViewCfg: {
                  //weekCount: 3
              },
              
              // Some optional CalendarPanel configs to experiment with:
              //readOnly: true,
              //showDayView: false,
              //showMultiDayView: true,
              //showWeekView: false,
              //showMultiWeekView: false,
              //showMonthView: false,
              //showNavBar: false,
              //showTodayText: false,
              //showTime: false,
              //editModal: true,
              //enableEditDetails: false,
              //title: 'My Calendar', // the header of the calendar, could be a subtitle for the app
              
              // Once this component inits it will set a reference to itself as an application
              // member property for easy reference in other functions within App.
              //~ initComponent: function() {
                  //~ Lino.calendarPanel = this;
                  //~ this.constructor.prototype.initComponent.apply(this, arguments);
              //~ },
              
              listeners: {
                  //~ 'eventclick': {
                      //~ fn: function(vw, rec, el){
                          //~ this.clearMsg();
                      //~ },
                      //~ scope: this
                  //~ },
                  'eventover': function(vw, rec, el){
                      //console.log('Entered evt rec='+rec.data[Ext.ensible.cal.EventMappings.Title.name]', view='+ vw.id +', el='+el.id);
                  },
                  'eventout': function(vw, rec, el){
                      //console.log('Leaving evt rec='+rec.data[Ext.ensible.cal.EventMappings.Title.name]+', view='+ vw.id +', el='+el.id);
                  },
                  'eventadd': {
                      fn: function(cp, rec){
                          this.showMsg('Event '+ rec.data[Ext.ensible.cal.EventMappings.Title.name] +' was added');
                      },
                      scope: this
                  },
                  'eventupdate': {
                      fn: function(cp, rec){
                          this.showMsg('Event '+ rec.data[Ext.ensible.cal.EventMappings.Title.name] +' was updated');
                      },
                      scope: this
                  },
                  'eventdelete': {
                      fn: function(cp, rec){
                          //this.eventStore.remove(rec);
                          this.showMsg('Event '+ rec.data[Ext.ensible.cal.EventMappings.Title.name] +' was deleted');
                      },
                      scope: this
                  },
                  'eventcancel': {
                      fn: function(cp, rec){
                          // edit canceled
                      },
                      scope: this
                  },
                  'viewchange': {
                      fn: function(p, vw, dateInfo){
                          if(this.editWin){
                              this.editWin.hide();
                          };
                          if(dateInfo !== null){
                              // will be null when switching to the event edit form so ignore
                              Ext.getCmp('app-nav-picker').setValue(dateInfo.activeDate);
                              this.updateTitle(dateInfo.viewStart, dateInfo.viewEnd);
                          }
                          
                      },
                      scope: this
                  },
                  'dayclick': {
                      fn: function(vw, dt, ad, el){
                          this.clearMsg();
                      },
                      scope: this
                  },
                  'rangeselect': {
                      fn: function(vw, dates, onComplete){
                          this.clearMsg();
                      },
                      scope: this
                  },
                  'eventmove': {
                      fn: function(vw, rec){
                          rec.commit();
                          var time = rec.data[Ext.ensible.cal.EventMappings.IsAllDay.name] ? '' : ' \\a\\t g:i a';
                          this.showMsg('Event '+ rec.data[Ext.ensible.cal.EventMappings.Title.name] +' was moved to '+
                              rec.data[Ext.ensible.cal.EventMappings.StartDate.name].format('F jS'+time));
                      },
                      scope: this
                  },
                  'eventresize': {
                      fn: function(vw, rec){
                          rec.commit();
                          this.showMsg('Event '+ rec.data[Ext.ensible.cal.EventMappings.Title.name] +' was updated');
                      },
                      scope: this
                  },
                  'eventdelete': {
                      fn: function(win, rec){
                          this.event_store.remove(rec);
                          this.showMsg('Event '+ rec.data[Ext.ensible.cal.EventMappings.Title.name] +' was deleted');
                      },
                      scope: this
                  },
                  'initdrag': {
                      fn: function(vw){
                          if(this.editWin && this.editWin.isVisible()){
                              this.editWin.hide();
                          }
                      },
                      scope: this
                  }
              }
          }]
        }
        //~ ]
        
      });
      
      this.event_store.on('load',function(){
        //~ console.log("20130808",this.event_store);
        if (this.event_store.reader.jsonData) {
          //~ console.log("20130808 b",this.event_store.reader.jsonData.title);
          //~ console.log("20130808 c",this);
          cap.set_window_title(this.event_store.reader.jsonData.title);
        }
      },this);
      
      //~ cap.app_instance = this;
      return cap;
      
  }
  ,updateTitle: function(startDt, endDt){
      var p = Ext.getCmp('app-center');
      
      if(startDt.clearTime().getTime() == endDt.clearTime().getTime()){
          p.setTitle(startDt.format('F j, Y'));
      }
      else if(startDt.getFullYear() == endDt.getFullYear()){
          if(startDt.getMonth() == endDt.getMonth()){
              p.setTitle(startDt.format('F j') + ' - ' + endDt.format('j, Y'));
          }
          else{
              p.setTitle(startDt.format('F j') + ' - ' + endDt.format('F j, Y'));
          }
      }
      else{
          p.setTitle(startDt.format('F j, Y') + ' - ' + endDt.format('F j, Y'));
      }
  }
  // This is an application-specific way to communicate CalendarPanel event messages back to the user.
  // This could be replaced with a function to do "toast" style messages, growl messages, etc. This will
  // vary based on application requirements, which is why it's not baked into the CalendarPanel.
  ,showMsg: function(msg){
      Lino.notify(msg);
      //~ Ext.fly('app-msg').update(msg).removeClass('x-hidden');
  }
  
  ,clearMsg: function(){
      Lino.notify('');
      //~ Ext.fly('app-msg').update('').addClass('x-hidden');
  }
}
};




/*
captureEvents utility by Aaron Conran
<http://www.sencha.com/learn/grid-faq/>

Ext.onReady(function(){
    var grid = new Ext.grid.GridPanel({
        ... 
    });
    captureEvents(grid);
});
*/
function captureEvents(observable) {
    Ext.util.Observable.capture(
        observable,
        function(eventName) {
            console.info(eventName);
        },
        this
    );		
}
 




var cardReader = new be.belgium.eid.CardReader();

function noCardPresentHandler() {
  window.alert("No card present!");
}
cardReader.setNoCardPresentHandler(noCardPresentHandler);

function noReaderDetectedHandler() {
  window.alert("No reader detected!");
}
cardReader.setNoReaderDetectedHandler(noReaderDetectedHandler);

function appletNotFoundHandler() {
  window.alert("Applet not found!");
}
cardReader.setAppletNotFoundHandler(appletNotFoundHandler);

function appletExceptionHandler(e) {
  window.alert("Error reading card!\r\nException: " + e + "\r\nPlease try again.");
}
cardReader.setAppletExceptionHandler(appletExceptionHandler);

//~ function clearPicture() {
  //~ document.getElementById("encoded_picture").src = "data:image/jpeg;base64,";
//~ }

Lino.beid_read_card_processor = function() {
    var card = cardReader.read();
    if (!card) {
        //~ Lino.alert("No card returned.");
        return null;
    } 
    console.log(card.getPicture());
    return {
      cardNumber: card.cardNumber,
      validityBeginDate:card.validityBeginDate.format("d.m.Y"),
      validityEndDate: card.validityEndDate.format("d.m.Y"),
      chipNumber:card.chipNumber,
      issuingMunicipality:card.issuingMunicipality,
      nationalNumber:card.nationalNumber,
      surname:card.surname,
      firstName1:card.firstName1,
      firstName2:card.firstName2,
      firstName3:card.firstName3,
      nationality:card.nationality,
      birthLocation:card.birthLocation,
      birthDate: card.birthDate.format("d.m.Y"),
      sex:card.sex,
      nobleCondition:card.nobleCondition,
      documentType:card.documentType,
      specialStatus:card.specialStatus,
      whiteCane:card.whiteCane,
      yellowCane:card.yellowCane,
      extendedMinority:card.extendedMinority,
      street:card.street,
      streetNumber:card.streetNumber,
      boxNumber:card.boxNumber,
      zipCode:card.zipCode,
      municipality:card.municipality,
      country:card.country
      //~ comment the following line out to test whether the picture takes a lot of time
      //~ test 20121214 on my machine revealed no perceivable gain
      ,picture:base64.encode(card.getPicture())
    };
}





Lino.main_menu = [ { "menu": { "items": [ { "text": "Personen", "handler": function() {Lino.contacts.Persons.grid.run(null)} }, { "text": " \u25b6 Klienten", "handler": function() {Lino.pcsw.Clients.grid.run(null)} }, { "text": "Organisationen", "handler": function() {Lino.contacts.Companies.grid.run(null)} }, "-", { "text": "Partner (alle)", "handler": function() {Lino.contacts.Partners.grid.run(null)} }, { "text": "Haushalte", "handler": function() {Lino.households.Households.grid.run(null)} } ] }, "text": "Kontakte" }, { "menu": { "items": [ { "text": "Mein E-Mail-Ausgang", "handler": function() {Lino.outbox.MyOutbox.grid.run(null)} }, { "text": "Meine Notizen", "handler": function() {Lino.notes.MyNotes.grid.run(null)} } ] }, "text": "B\u00fcro" }, { "menu": { "items": [ { "text": "Kalender", "iconCls": "x-tbar-calendar", "handler": function() {Lino.cal.CalendarPanel.grid.run(null)}, "listeners": { "render": Lino.quicktip_renderer("Foo","Displays your events in a classical \"calendar view\", \nwith the possibility to switch between daily, weekly, monthly view.") } }, { "text": "Meine Termine", "listeners": { "render": Lino.quicktip_renderer("Foo","Alle meine Termine") }, "handler": function() {Lino.cal.MyEvents.grid.run(null)} }, { "text": "Meine Aufgaben", "listeners": { "render": Lino.quicktip_renderer("Foo","Alle meine Aufgaben") }, "handler": function() {Lino.cal.MyTasks.grid.run(null)} }, { "text": "Meine G\u00e4ste", "handler": function() {Lino.cal.MyGuests.grid.run(null)} }, { "text": "Meine Anwesenheiten", "listeners": { "render": Lino.quicktip_renderer("Foo","Shows all my presences in calendar events, independently of their state.") }, "handler": function() {Lino.cal.MyPresences.grid.run(null)} } ] }, "text": "Kalender" }, { "menu": { "items": [ { "text": "Wartende Besucher", "handler": function() {Lino.reception.MyWaitingGuests.grid.run(null)} } ] }, "text": "Empfang" }, { "menu": { "items": [ { "text": "Klienten", "listeners": { "render": Lino.quicktip_renderer("Foo","Wie Kontakte --> Klienten, aber mit DSBE-spezifischen Kolonnen und Filterparametern.") }, "handler": function() {Lino.integ.Clients.grid.run(null)} }, { "text": "VSEs", "handler": function() {Lino.isip.MyContracts.grid.run(null)} }, { "text": "Art.60\u00a77-Konventionen", "handler": function() {Lino.jobs.MyContracts.grid.run(null)} }, { "text": "Stellenanbieter", "handler": function() {Lino.jobs.JobProviders.grid.run(null)} }, { "text": "Stellen", "listeners": { "render": Lino.quicktip_renderer("Foo","\n    Eine Stelle ist ein Arbeitsplatz bei einem Stellenabieter. \n    ") }, "handler": function() {Lino.jobs.Jobs.grid.run(null)} }, { "text": "Stellenangebote", "handler": function() {Lino.jobs.Offers.grid.run(null)} } ] }, "text": "DSBE" }, { "menu": { "items": [ { "text": "Kursanbieter", "handler": function() {Lino.courses.CourseProviders.grid.run(null)} }, { "text": "Kursangebote", "handler": function() {Lino.courses.CourseOffers.grid.run(null)} }, { "text": "Offene Kursanfragen", "handler": function() {Lino.courses.PendingCourseRequests.grid.run(null)} } ] }, "text": "Kurse" }, { "menu": { "items": [ { "menu": { "items": [ { "text": "Benutzer und ihre Klienten", "handler": function() {Lino.integ.UsersWithClients.grid.run(null)} }, { "text": "\u00dcbersicht Art.60\u00a77-Konventionen", "listeners": { "render": Lino.quicktip_renderer("Foo","Detail-Fenster auf diesem Datensatz \u00f6ffnen") }, "handler": function() {Lino.jobs.JobsOverview.show.run(null,{ "record_id": -99998 })} }, { "text": "T\u00e4tigkeitsbericht", "listeners": { "render": Lino.quicktip_renderer("Foo","Detail-Fenster auf diesem Datensatz \u00f6ffnen") }, "handler": function() {Lino.integ.ActivityReport.show.run(null,{ "record_id": -99998 })} } ] }, "text": "DSBE" } ] }, "text": "Listings" }, { "menu": { "items": [ { "menu": { "items": [ { "text": "Meine Einf\u00fcgetexte", "handler": function() {Lino.system.MyTextFieldTemplates.grid.run(null)} } ] }, "text": "B\u00fcro" }, { "menu": { "items": [ { "text": "L\u00e4nder", "listeners": { "render": Lino.quicktip_renderer("Foo","\n    A country is a geographic entity considered a \"nation\".\n    ") }, "handler": function() {Lino.countries.Countries.grid.run(null)} }, { "text": "Sprachen", "handler": function() {Lino.languages.Languages.grid.run(null)} } ] }, "text": "Kontakte" }, { "menu": { "items": [ { "text": "R\u00e4ume", "listeners": { "render": Lino.quicktip_renderer("Foo","List of rooms where calendar events can happen.") }, "handler": function() {Lino.cal.Rooms.grid.run(null)} }, { "text": "Priorit\u00e4ten", "listeners": { "render": Lino.quicktip_renderer("Foo","List of possible priorities of calendar events.") }, "handler": function() {Lino.cal.Priorities.grid.run(null)} }, { "text": "Kalenderliste", "listeners": { "render": Lino.quicktip_renderer("Foo","The list of calendars defined on this system.\n    A calendar is a list of events which have certain things in common,\n    especially they are displayed in the same colour in the calendar panel") }, "handler": function() {Lino.cal.Calendars.grid.run(null)} } ] }, "text": "Kalender" }, { "menu": { "items": [ { "text": "Integrationsphasen", "listeners": { "render": Lino.quicktip_renderer("Foo","Liste der m\u00f6glichen Integrationsphasen.") }, "handler": function() {Lino.pcsw.PersonGroups.grid.run(null)} }, { "text": "Begleitungsbeendigungsgr\u00fcnde", "listeners": { "render": Lino.quicktip_renderer("Foo","A list of reasons expressing why a coaching was ended") }, "handler": function() {Lino.pcsw.CoachingEndings.grid.run(null)} }, { "text": "Dispenzgr\u00fcnde", "listeners": { "render": Lino.quicktip_renderer("Foo","A list of reasons for being dispensed") }, "handler": function() {Lino.pcsw.DispenseReasons.grid.run(null)} } ] }, "text": "\u00d6SHZ" }, { "menu": { "items": [ { "text": "VSE-Arten", "handler": function() {Lino.isip.ContractTypes.grid.run(null)} }, { "text": "Vertragsbeendigungsgr\u00fcnde", "handler": function() {Lino.isip.ContractEndings.grid.run(null)} }, { "text": "Auswertungsstrategien", "handler": function() {Lino.isip.ExamPolicies.grid.run(null)} }, { "text": "Art.60\u00a77-Konventionsarten", "handler": function() {Lino.jobs.ContractTypes.grid.run(null)} }, { "text": "Stellenarten", "handler": function() {Lino.jobs.JobTypes.grid.run(null)} }, { "text": "Sektoren", "handler": function() {Lino.jobs.Sectors.grid.run(null)} }, { "text": "Funktionen", "handler": function() {Lino.jobs.Functions.grid.run(null)} }, { "text": "Stundenpl\u00e4ne", "handler": function() {Lino.jobs.Schedules.grid.run(null)} }, { "text": "Regimes", "handler": function() {Lino.jobs.Regimes.grid.run(null)} } ] }, "text": "DSBE" }, { "menu": { "items": [ { "text": "Kursinhalte", "handler": function() {Lino.courses.CourseContents.grid.run(null)} } ] }, "text": "Kurse" } ] }, "text": "Konfigurierung" }, { "menu": { "items": [ { "menu": { "items": [ { "text": "E-Mail-Ausg\u00e4nge", "handler": function() {Lino.outbox.Mails.grid.run(null)} }, { "text": "Anh\u00e4nge", "handler": function() {Lino.outbox.Attachments.grid.run(null)} } ] }, "text": "B\u00fcro" }, { "menu": { "items": [ { "text": "Aufgaben", "listeners": { "render": Lino.quicktip_renderer("Foo","A calendar task is something you need to do.\n    ") }, "handler": function() {Lino.cal.Tasks.grid.run(null)} }, { "text": "Abonnements", "handler": function() {Lino.cal.Subscriptions.grid.run(null)} } ] }, "text": "Kalender" }, { "menu": { "items": [ { "text": "Sprachkenntnisse", "handler": function() {Lino.cv.LanguageKnowledges.grid.run(null)} } ] }, "text": "CV" }, { "menu": { "items": [ { "text": "VSEs", "handler": function() {Lino.isip.Contracts.grid.run(null)} }, { "text": "Art.60\u00a77-Konventionen", "handler": function() {Lino.jobs.Contracts.grid.run(null)} }, { "text": "Stellenanfragen", "handler": function() {Lino.jobs.Candidatures.grid.run(null)} }, { "text": "Ausbildungen und Studien", "handler": function() {Lino.jobs.Studies.grid.run(null)} } ] }, "text": "DSBE" }, { "menu": { "items": [ { "text": "Kursanfragen", "handler": function() {Lino.courses.CourseRequests.grid.run(null)} } ] }, "text": "Kurse" } ] }, "text": "Explorer" }, { "menu": { "items": [ { "text": "Info", "listeners": { "render": Lino.quicktip_renderer("Foo","Zeigt Informationen \u00fcber diese Site an.") }, "handler": function() {Lino.about.About.show.run(null,{ "record_id": -99998 })} } ] }, "text": "Site" }, { "text": "Startseite", "handler": function() {Lino.close_all_windows()} } ];
Ext.namespace('Lino.system.SiteConfigs')
Ext.namespace('Lino.system.ContentTypes')
Ext.namespace('Lino.system.HelpTexts')
Ext.namespace('Lino.system.TextFieldTemplates')
Ext.namespace('Lino.users.Users')
Ext.namespace('Lino.users.MySettings')
Ext.namespace('Lino.users.UsersOverview')
Ext.namespace('Lino.users.Teams')
Ext.namespace('Lino.users.Memberships')
Ext.namespace('Lino.users.Authorities')
Ext.namespace('Lino.changes.Changes')
Ext.namespace('Lino.countries.Countries')
Ext.namespace('Lino.countries.Cities')
Ext.namespace('Lino.properties.PropGroups')
Ext.namespace('Lino.properties.PropTypes')
Ext.namespace('Lino.properties.Properties')
Ext.namespace('Lino.properties.PropChoices')
Ext.namespace('Lino.contacts.CompanyTypes')
Ext.namespace('Lino.contacts.Partners')
Ext.namespace('Lino.contacts.Companies')
Ext.namespace('Lino.contacts.RoleTypes')
Ext.namespace('Lino.contacts.Roles')
Ext.namespace('Lino.contacts.Persons')
Ext.namespace('Lino.outbox.Recipients')
Ext.namespace('Lino.outbox.Mails')
Ext.namespace('Lino.outbox.Attachments')
Ext.namespace('Lino.cal.Calendars')
Ext.namespace('Lino.cal.Subscriptions')
Ext.namespace('Lino.cal.Rooms')
Ext.namespace('Lino.cal.Priorities')
Ext.namespace('Lino.cal.Events')
Ext.namespace('Lino.cal.OneEvent')
Ext.namespace('Lino.cal.MyEvents')
Ext.namespace('Lino.cal.MyAssignedEvents')
Ext.namespace('Lino.cal.Tasks')
Ext.namespace('Lino.cal.MyTasks')
Ext.namespace('Lino.cal.GuestRoles')
Ext.namespace('Lino.cal.Guests')
Ext.namespace('Lino.cal.MyPresences')
Ext.namespace('Lino.cal.MyPendingPresences')
Ext.namespace('Lino.cal.MyGuests')
Ext.namespace('Lino.cal.PanelCalendars')
Ext.namespace('Lino.cal.PanelEvents')
Ext.namespace('Lino.uploads.UploadTypes')
Ext.namespace('Lino.uploads.Uploads')
Ext.namespace('Lino.households.Types')
Ext.namespace('Lino.households.Households')
Ext.namespace('Lino.households.Roles')
Ext.namespace('Lino.households.Members')
Ext.namespace('Lino.reception.ExpectedGuests')
Ext.namespace('Lino.reception.ReceivedGuests')
Ext.namespace('Lino.reception.MyWaitingGuests')
Ext.namespace('Lino.notes.NoteTypes')
Ext.namespace('Lino.notes.EventTypes')
Ext.namespace('Lino.notes.Notes')
Ext.namespace('Lino.cv.LanguageKnowledges')
Ext.namespace('Lino.cv.PersonProperties')
Ext.namespace('Lino.isip.ContractTypes')
Ext.namespace('Lino.isip.ExamPolicies')
Ext.namespace('Lino.isip.ContractEndings')
Ext.namespace('Lino.isip.StudyTypes')
Ext.namespace('Lino.isip.Contracts')
Ext.namespace('Lino.isip.MyContracts')
Ext.namespace('Lino.jobs.Schedules')
Ext.namespace('Lino.jobs.Regimes')
Ext.namespace('Lino.jobs.JobProviders')
Ext.namespace('Lino.jobs.ContractTypes')
Ext.namespace('Lino.jobs.Sectors')
Ext.namespace('Lino.jobs.Functions')
Ext.namespace('Lino.jobs.Contracts')
Ext.namespace('Lino.jobs.MyContracts')
Ext.namespace('Lino.jobs.Offers')
Ext.namespace('Lino.jobs.Studies')
Ext.namespace('Lino.jobs.Experiences')
Ext.namespace('Lino.jobs.Candidatures')
Ext.namespace('Lino.jobs.Jobs')
Ext.namespace('Lino.jobs.JobTypes')
Ext.namespace('Lino.jobs.ContractsSearch')
Ext.namespace('Lino.pcsw.Clients')
Ext.namespace('Lino.pcsw.DebtsClients')
Ext.namespace('Lino.pcsw.AllClients')
Ext.namespace('Lino.pcsw.ClientsTest')
Ext.namespace('Lino.pcsw.PersonGroups')
Ext.namespace('Lino.pcsw.Activities')
Ext.namespace('Lino.pcsw.DispenseReasons')
Ext.namespace('Lino.pcsw.Dispenses')
Ext.namespace('Lino.pcsw.ExclusionTypes')
Ext.namespace('Lino.pcsw.Exclusions')
Ext.namespace('Lino.pcsw.AidTypes')
Ext.namespace('Lino.pcsw.ClientContactTypes')
Ext.namespace('Lino.pcsw.ClientContacts')
Ext.namespace('Lino.pcsw.CoachingTypes')
Ext.namespace('Lino.pcsw.CoachingEndings')
Ext.namespace('Lino.pcsw.Coachings')
Ext.namespace('Lino.reception.Clients')
Ext.namespace('Lino.reception.WaitingGuests')
Ext.namespace('Lino.languages.Languages')
Ext.namespace('Lino.accounts.Charts')
Ext.namespace('Lino.accounts.Groups')
Ext.namespace('Lino.accounts.Accounts')
Ext.namespace('Lino.courses.CourseProviders')
Ext.namespace('Lino.courses.CourseContents')
Ext.namespace('Lino.courses.Courses')
Ext.namespace('Lino.courses.CourseOffers')
Ext.namespace('Lino.courses.CourseRequests')
Ext.namespace('Lino.courses.PendingCourseRequests')
Ext.namespace('Lino.integ.Clients')
Ext.namespace('Lino.integ.CoachingEndingsByUser')
Ext.namespace('Lino.integ.CoachingEndingsByType')
Ext.namespace('Lino.integ.ContractEndingsByType')
Ext.namespace('Lino.integ.JobsContractEndingsByType')
Ext.namespace('Lino.integ.ContractsPerUserAndContractType')
Ext.namespace('Lino.integ.JobsContractsPerUserAndContractType')
Ext.namespace('Lino.integ.StudyTypesAndContracts')
Ext.namespace('Lino.integ.CompaniesAndContracts')
Ext.namespace('Lino.integ.JobProvidersAndContracts')
Ext.namespace('Lino.newcomers.Brokers')
Ext.namespace('Lino.newcomers.Faculties')
Ext.namespace('Lino.newcomers.Competences')
Ext.namespace('Lino.newcomers.NewClients')
Ext.namespace('Lino.newcomers.AvailableCoaches')
Ext.namespace('Lino.debts.Budgets')
Ext.namespace('Lino.debts.Actors')
Ext.namespace('Lino.debts.Entries')
Ext.namespace('Lino.debts.EntriesByType')
Ext.namespace('Lino.cbss.Sectors')
Ext.namespace('Lino.cbss.Purposes')
Ext.namespace('Lino.cbss.IdentifyPersonRequests')
Ext.namespace('Lino.cbss.ManageAccessRequests')
Ext.namespace('Lino.cbss.RetrieveTIGroupsRequests')
Ext.namespace('Lino.sessions.SessionTable')
Ext.namespace('Lino.system.MyTextFieldTemplates')
Ext.namespace('Lino.users.MembershipsByUser')
Ext.namespace('Lino.users.AuthoritiesGiven')
Ext.namespace('Lino.users.AuthoritiesTaken')
Ext.namespace('Lino.countries.CitiesByCity')
Ext.namespace('Lino.countries.CitiesByCountry')
Ext.namespace('Lino.properties.PropsByGroup')
Ext.namespace('Lino.properties.PropsByType')
Ext.namespace('Lino.properties.ChoicesByType')
Ext.namespace('Lino.contacts.PartnersByCity')
Ext.namespace('Lino.contacts.PartnersByCountry')
Ext.namespace('Lino.contacts.RolesByCompany')
Ext.namespace('Lino.contacts.RolesByPerson')
Ext.namespace('Lino.outbox.RecipientsByMail')
Ext.namespace('Lino.outbox.MyOutbox')
Ext.namespace('Lino.outbox.MailsByUser')
Ext.namespace('Lino.outbox.MailsByProject')
Ext.namespace('Lino.outbox.SentByPartner')
Ext.namespace('Lino.outbox.AttachmentsByMail')
Ext.namespace('Lino.cal.SubscriptionsByCalendar')
Ext.namespace('Lino.cal.SubscriptionsByUser')
Ext.namespace('Lino.cal.EventsByCalendar')
Ext.namespace('Lino.cal.EventsByRoom')
Ext.namespace('Lino.cal.EventsByProject')
Ext.namespace('Lino.cal.TasksByUser')
Ext.namespace('Lino.cal.TasksByProject')
Ext.namespace('Lino.cal.GuestsByEvent')
Ext.namespace('Lino.cal.GuestsByRole')
Ext.namespace('Lino.cal.GuestsByPartner')
Ext.namespace('Lino.uploads.MyUploads')
Ext.namespace('Lino.households.HouseholdsByType')
Ext.namespace('Lino.households.MembersByHousehold')
Ext.namespace('Lino.households.MembersByPerson')
Ext.namespace('Lino.households.MembersByRole')
Ext.namespace('Lino.reception.AppointmentsByGuest')
Ext.namespace('Lino.notes.MyNotes')
Ext.namespace('Lino.notes.NotesByType')
Ext.namespace('Lino.notes.NotesByEventType')
Ext.namespace('Lino.notes.NotesByProject')
Ext.namespace('Lino.cv.LanguageKnowledgesByPerson')
Ext.namespace('Lino.cv.KnowledgesByLanguage')
Ext.namespace('Lino.cv.PropsByPerson')
Ext.namespace('Lino.cv.PersonPropsByProp')
Ext.namespace('Lino.cv.ConfiguredPropsByPerson')
Ext.namespace('Lino.cv.SkillsByPerson')
Ext.namespace('Lino.cv.SoftSkillsByPerson')
Ext.namespace('Lino.cv.ObstaclesByPerson')
Ext.namespace('Lino.isip.ContractsByPerson')
Ext.namespace('Lino.isip.ContractsByPolicy')
Ext.namespace('Lino.isip.ContractsByType')
Ext.namespace('Lino.isip.ContractsByEnding')
Ext.namespace('Lino.isip.ContractsByStudyType')
Ext.namespace('Lino.jobs.FunctionsBySector')
Ext.namespace('Lino.jobs.ContractsByPerson')
Ext.namespace('Lino.jobs.ContractsByProvider')
Ext.namespace('Lino.jobs.ContractsByPolicy')
Ext.namespace('Lino.jobs.ContractsByEnding')
Ext.namespace('Lino.jobs.ContractsByJob')
Ext.namespace('Lino.jobs.ContractsByRegime')
Ext.namespace('Lino.jobs.ContractsBySchedule')
Ext.namespace('Lino.jobs.StudiesByCountry')
Ext.namespace('Lino.jobs.StudiesByCity')
Ext.namespace('Lino.jobs.StudiesByPerson')
Ext.namespace('Lino.jobs.ExperiencesByFunction')
Ext.namespace('Lino.jobs.ExperiencesByPerson')
Ext.namespace('Lino.jobs.CandidaturesByPerson')
Ext.namespace('Lino.jobs.CandidaturesBySector')
Ext.namespace('Lino.jobs.CandidaturesByFunction')
Ext.namespace('Lino.jobs.CandidaturesByJob')
Ext.namespace('Lino.jobs.CandidaturesByOffer')
Ext.namespace('Lino.jobs.ExperiencesByOffer')
Ext.namespace('Lino.jobs.JobsByProvider')
Ext.namespace('Lino.jobs.JobsByType')
Ext.namespace('Lino.jobs.ContractsByType')
Ext.namespace('Lino.jobs.JobsOverviewByType')
Ext.namespace('Lino.pcsw.ClientsByNationality')
Ext.namespace('Lino.pcsw.DispensesByClient')
Ext.namespace('Lino.pcsw.ExclusionsByClient')
Ext.namespace('Lino.pcsw.ContactsByClient')
Ext.namespace('Lino.pcsw.CoachingsByClient')
Ext.namespace('Lino.pcsw.CoachingsByUser')
Ext.namespace('Lino.pcsw.CoachingsByEnding')
Ext.namespace('Lino.pcsw.NotesByPerson')
Ext.namespace('Lino.pcsw.NotesByCompany')
Ext.namespace('Lino.reception.CoachingsByClient')
Ext.namespace('Lino.accounts.GroupsByChart')
Ext.namespace('Lino.accounts.AccountsByGroup')
Ext.namespace('Lino.courses.CoursesByOffer')
Ext.namespace('Lino.courses.CourseOffersByProvider')
Ext.namespace('Lino.courses.CourseOffersByContent')
Ext.namespace('Lino.courses.CourseRequestsByPerson')
Ext.namespace('Lino.courses.CourseRequestsByContent')
Ext.namespace('Lino.courses.RequestsByCourse')
Ext.namespace('Lino.courses.ParticipantsByCourse')
Ext.namespace('Lino.courses.CandidatesByCourse')
Ext.namespace('Lino.newcomers.CompetencesByUser')
Ext.namespace('Lino.newcomers.CompetencesByFaculty')
Ext.namespace('Lino.newcomers.MyCompetences')
Ext.namespace('Lino.newcomers.ClientsByFaculty')
Ext.namespace('Lino.newcomers.AvailableCoachesByClient')
Ext.namespace('Lino.debts.MyBudgets')
Ext.namespace('Lino.debts.BudgetsByPartner')
Ext.namespace('Lino.debts.ActorsByBudget')
Ext.namespace('Lino.debts.ActorsByPartner')
Ext.namespace('Lino.debts.EntriesByBudget')
Ext.namespace('Lino.debts.ExpensesByBudget')
Ext.namespace('Lino.debts.IncomesByBudget')
Ext.namespace('Lino.debts.LiabilitiesByBudget')
Ext.namespace('Lino.debts.AssetsByBudget')
Ext.namespace('Lino.debts.DistByBudget')
Ext.namespace('Lino.cbss.MyIdentifyPersonRequests')
Ext.namespace('Lino.cbss.IdentifyRequestsByPerson')
Ext.namespace('Lino.cbss.ManageAccessRequestsByPerson')
Ext.namespace('Lino.cbss.MyManageAccessRequests')
Ext.namespace('Lino.cbss.RetrieveTIGroupsRequestsByPerson')
Ext.namespace('Lino.cbss.MyRetrieveTIGroupsRequests')
Ext.namespace('Lino.uploads.UploadsByController')
Ext.namespace('Lino.system.HelpTextsByModel')
Ext.namespace('Lino.cal.TasksByController')
Ext.namespace('Lino.outbox.MailsByController')
Ext.namespace('Lino.changes.ChangesByMaster')
Ext.namespace('Lino.outbox.AttachmentsByController')
Ext.namespace('Lino.cal.EventsByController')
Ext.namespace('Lino.about.Models')
Ext.namespace('Lino.about.FieldsByModel')
Ext.namespace('Lino.about.Inspector')
Ext.namespace('Lino.about.SourceFiles')
Ext.namespace('Lino.reception.ButtonsTable')
Ext.namespace('Lino.reception.CreateNoteActionsByClient')
Ext.namespace('Lino.integ.UsersWithClients')
Ext.namespace('Lino.integ.CompareRequestsTable')
Ext.namespace('Lino.integ.PeriodicNumbers')
Ext.namespace('Lino.debts.PrintEntriesByBudget')
Ext.namespace('Lino.debts.PrintExpensesByBudget')
Ext.namespace('Lino.debts.PrintIncomesByBudget')
Ext.namespace('Lino.debts.PrintLiabilitiesByBudget')
Ext.namespace('Lino.debts.PrintAssetsByBudget')
Ext.namespace('Lino.debts.SummaryTable')
Ext.namespace('Lino.debts.ResultByBudget')
Ext.namespace('Lino.debts.DebtsByBudget')
Ext.namespace('Lino.debts.BailiffDebtsByBudget')
Ext.namespace('Lino.cbss.IdentifyPersonResult')
Ext.namespace('Lino.cbss.RetrieveTIGroupsResult')
Ext.namespace('Lino.lino.Report')
Ext.namespace('Lino.about.About')
Ext.namespace('Lino.system.Home')
Ext.namespace('Lino.cal.CalendarPanel')
Ext.namespace('Lino.jobs.OldJobsOverview')
Ext.namespace('Lino.jobs.JobsOverview')
Ext.namespace('Lino.integ.ActivityReport')
Ext.namespace('Lino.courses.CourseRequestStates')
Ext.namespace('Lino.cal.DurationUnits')
Ext.namespace('Lino.cal.TaskStates')
Ext.namespace('Lino.cal.Weekdays')
Ext.namespace('Lino.lino.UserLevels')
Ext.namespace('Lino.pcsw.CoachingEvents')
Ext.namespace('Lino.lino.YesNo')
Ext.namespace('Lino.cal.EventStates')
Ext.namespace('Lino.lino.BeIdCardTypes')
Ext.namespace('Lino.accounts.AccountTypes')
Ext.namespace('Lino.cal.Recurrencies')
Ext.namespace('Lino.properties.HowWell')
Ext.namespace('Lino.cv.CefLevel')
Ext.namespace('Lino.jobs.CandidatureStates')
Ext.namespace('Lino.outbox.RecipientType')
Ext.namespace('Lino.cal.EventEvents')
Ext.namespace('Lino.cal.GuestStates')
Ext.namespace('Lino.pcsw.CivilState')
Ext.namespace('Lino.pcsw.ClientStates')
Ext.namespace('Lino.countries.CityTypes')
Ext.namespace('Lino.properties.DoYouLike')
Ext.namespace('Lino.cbss.RequestLanguages')
Ext.namespace('Lino.cbss.ManageAction')
Ext.namespace('Lino.pcsw.RefusalReasons')
Ext.namespace('Lino.lino.UserGroups')
Ext.namespace('Lino.cbss.RequestStates')
Ext.namespace('Lino.lino.ChangeTypes')
Ext.namespace('Lino.cal.AccessClasses')
Ext.namespace('Lino.cbss.QueryRegister')
Ext.namespace('Lino.isip.ContractEvents')
Ext.namespace('Lino.lino.Genders')
Ext.namespace('Lino.pcsw.ClientEvents')
Ext.namespace('Lino.lino.UserProfiles')
Ext.namespace('Lino.pcsw.ResidenceType')

// ChoiceLists: 
Lino.courses.CourseRequestStates = [ [ "10", "Offen" ], [ "20", "Eingetragen" ], [ "30", "Bestanden" ], [ "40", "Gut bestanden" ], [ "50", "Nicht bestanden" ], [ "60", "Abgebrochen" ], [ "70", "Inaktiv" ] ];
Lino.cal.DurationUnits = [ [ "s", "Sekunden" ], [ "m", "Minuten" ], [ "h", "Stunden" ], [ "D", "Tage" ], [ "W", "Wochen" ], [ "M", "Monate" ], [ "Y", "Jahre" ] ];
Lino.cal.TaskStates = [ [ "10", "Zu tun" ], [ "20", "Begonnen" ], [ "30", "Erledigt" ], [ "50", "Storniert" ] ];
Lino.cal.Weekdays = [ [ "1", "Montag" ], [ "2", "Dienstag" ], [ "3", "Mittwoch" ], [ "4", "Donnerstag" ], [ "5", "Freitag" ], [ "6", "Samstag" ], [ "7", "Sonntag" ] ];
Lino.lino.UserLevels = [ [ "10", "Gast" ], [ "30", "Benutzer" ], [ "40", "Manager" ], [ "50", "Verwalter" ] ];
Lino.pcsw.CoachingEvents = [ [ "10", "Begonnen" ], [ "20", "Aktiv" ], [ "30", "Beendet" ] ];
Lino.lino.YesNo = [ [ "y", "Ja" ], [ "n", "Nein" ] ];
Lino.cal.EventStates = [ [ "10", "Vorgeschlagen" ], [ "20", "Entwurf" ], [ "40", "Published" ], [ "50", "Stattgefunden" ], [ "70", "Storniert" ] ];
Lino.lino.BeIdCardTypes = [ [ "1", "Belgischer Staatsb\u00fcrger" ], [ "6", "Kind unter 12 Jahren" ], [ "11", "A (Bescheinigung der Eintragung im Ausl\u00e4nderregister - Vor\u00fcbergehender Aufenthalt)" ], [ "12", "B (Bescheinigung der Eintragung im Ausl\u00e4nderregister)" ], [ "13", "C (Personalausweis f\u00fcr Ausl\u00e4nder)" ], [ "14", "D (Daueraufenthalt - EG)" ], [ "15", "E (Anmeldebescheinigung)" ], [ "16", "E+" ], [ "17", "F (Aufenthaltskarte f\u00fcr Familienangeh\u00f6rige eines Unionsb\u00fcrgers)" ], [ "18", "F+" ] ];
Lino.accounts.AccountTypes = [ [ "A", "Verm\u00f6gen" ], [ "L", "Verpflichtungen" ], [ "I", "Eink\u00fcnfte" ], [ "E", "Ausgaben" ], [ "C", "Kapital" ], [ "B", "Bankkonten" ] ];
Lino.cal.Recurrencies = [ [ "D", "t\u00e4glich" ], [ "W", "w\u00f6chentlich" ], [ "M", "monatlich" ], [ "Y", "j\u00e4hrlich" ], [ "P", "pro Wochentag" ] ];
Lino.properties.HowWell = [ [ "0", "gar nicht" ], [ "1", "ein bisschen" ], [ "2", "mittelm\u00e4\u00dfig" ], [ "3", "gut" ], [ "4", "sehr gut" ] ];
Lino.cv.CefLevel = [ [ "A1", "A1 (Elementare Sprachverwendung)" ], [ "A2", "A2 (Elementare Sprachverwendung)" ], [ "A2+", "A2+ (Elementare Sprachverwendung)" ], [ "B1", "B1 (Selbstst\u00e4ndige Sprachverwendung)" ], [ "B2", "B2 (Selbstst\u00e4ndige Sprachverwendung)" ], [ "B2+", "B2+ (Selbstst\u00e4ndige Sprachverwendung)" ], [ "C1", "C1 (Exzellente Sprachverwendung)" ], [ "C2", "C2 (Exzellente Sprachverwendung)" ], [ "C2+", "C2+ (Exzellente Sprachverwendung)" ] ];
Lino.jobs.CandidatureStates = [ [ "10", "Aktiv" ], [ "20", "Probezeit" ], [ "25", "Probezeit ohne Erfolg" ], [ "27", "Arbeitet" ], [ "30", "Inaktiv" ] ];
Lino.outbox.RecipientType = [ [ "to", "Empf\u00e4nger" ], [ "cc", "Kopie an" ], [ "bcc", "Blindkopie an" ] ];
Lino.cal.EventEvents = [ [ "10", "Okay" ], [ "20", "Pending" ] ];
Lino.cal.GuestStates = [ [ "10", "Eingeladen" ], [ "20", "Zugesagt" ], [ "30", "Abgesagt" ], [ "40", "Anwesend" ], [ "50", "Abwesend" ] ];
Lino.pcsw.CivilState = [ [ "10", "Ledig" ], [ "13", "Ledig zusammenwohnend" ], [ "18", "Ledig mit Kind" ], [ "20", "Verheiratet" ], [ "21", "Verheirated (allein lebend)" ], [ "22", "Verheirated (mit anderem Partner lebend)" ], [ "30", "Verwitwet" ], [ "33", "Verwitwet (zusammenwohnend)" ], [ "40", "Geschieden" ], [ "50", "Getrennt von Tisch und Bett" ] ];
Lino.pcsw.ClientStates = [ [ "10", "Neuantrag" ], [ "20", "Abgelehnt" ], [ "30", "Begleitet" ], [ "50", "Ehemalig" ] ];
Lino.countries.CityTypes = [ [ "10", "Bundesland" ], [ "11", "Division" ], [ "12", "Region" ], [ "13", "Gemeinschaft" ], [ "14", "Territorium" ], [ "20", "Regierungsbezirk" ], [ "21", "Provinz" ], [ "22", "Grafschaft" ], [ "23", "Unterregion" ], [ "24", "Departement" ], [ "25", "Arrondissement" ], [ "26", "Pr\u00e4fektur" ], [ "27", "Distrikt" ], [ "28", "Sektor" ], [ "50", "Stadt" ], [ "51", "Kleinstadt" ], [ "52", "Gemeinde" ], [ "54", "Pfarre" ], [ "55", "Stadtteil" ], [ "56", "Viertel" ], [ "61", "Ortschaft" ], [ "62", "Kleine Ortschaft" ], [ "70", "Dorf" ] ];
Lino.properties.DoYouLike = [ [ "0", "blo\u00df nicht" ], [ "1", "eher nicht" ], [ "2", "normal" ], [ "3", "gerne" ], [ "4", "sehr gerne" ] ];
Lino.cbss.RequestLanguages = [ [ "nl", "Niederl\u00e4ndisch" ], [ "fr", "Franz\u00f6sisch" ], [ "de", "Deutsch" ] ];
Lino.cbss.ManageAction = [ [ "1", "Registrieren" ], [ "2", "Austragen" ], [ "3", "Auflisten" ] ];
Lino.pcsw.RefusalReasons = [ [ "10", "Information (keine Begleitung erforderlich)" ], [ "20", "\u00d6SHZ ist nicht zust\u00e4ndig" ], [ "30", "Antragsteller ist nicht zur\u00fcck gekommen" ] ];
Lino.lino.UserGroups = [ [ "office", "office (B\u00fcro)" ], [ "reception", "reception (Empfang)" ], [ "accounting", "accounting (Buchhaltung)" ], [ "integ", "integ (DSBE)" ], [ "newcomers", "newcomers (Neuantr\u00e4ge)" ], [ "debts", "debts (Schuldnerberatung)" ], [ "cbss", "cbss (ZDSS)" ] ];
Lino.cbss.RequestStates = [ [ "10", "Versendet" ], [ "20", "Fehlgeschlagen" ], [ "25", "Validiert" ], [ "30", "OK" ], [ "40", "Warnungen" ], [ "50", "Fehlermeldungen" ] ];
Lino.lino.ChangeTypes = [ [ "C", "Erstellen" ], [ "U", "Aktualisierung" ], [ "D", "L\u00f6schen" ], [ "R", "Remove child" ], [ "A", "Add child" ], [ "M", "Fusionieren" ] ];
Lino.cal.AccessClasses = [ [ "10", "Privat" ], [ "20", "halb \u00f6ffentlich (\"Besch\u00e4ftigt\")" ], [ "30", "\u00d6ffentlich" ] ];
Lino.cbss.QueryRegister = [ [ "1", "Prim\u00e4r" ], [ "2", "Sekund\u00e4r" ], [ "3", "Alle" ] ];
Lino.isip.ContractEvents = [ [ "10", "Begonnen" ], [ "20", "Aktiv" ], [ "30", "Beendet" ], [ "40", "Unterschrieben" ] ];
Lino.lino.Genders = [ [ "M", "M\u00e4nnlich" ], [ "F", "Weiblich" ] ];
Lino.pcsw.ClientEvents = [ [ "10", "Aktiv" ], [ "20", "VSE" ], [ "21", "Art.60\u00a77-Konvention" ], [ "22", "Dispenz" ], [ "30", "AG-Sperre" ], [ "40", "Notiz" ], [ "50", "Erstellt" ], [ "60", "Bearbeitet" ] ];
Lino.lino.UserProfiles = [ [ "000", "000 (Anonym)" ], [ "100", "100 (Begleiter im DSBE)" ], [ "110", "110 (Integrations-Assistent (Manager))" ], [ "200", "200 (Berater Neuantr\u00e4ge)" ], [ "210", "210 (Empfangsschalter)" ], [ "300", "300 (Schuldenberater)" ], [ "500", "500 (nur ZDSS)" ], [ "900", "900 (Verwalter)" ] ];
Lino.pcsw.ResidenceType = [ [ "1", "Bev\u00f6lkerungsregister" ], [ "2", "Fremdenregister" ], [ "3", "Warteregister" ] ];

Lino.integ.ActivityReport.ParamsPanel = Ext.extend(Ext.form.FormPanel,{
  autoHeight: true,
  layout: "hbox",
  frame: true,
  layoutConfig: { "align": "stretchmax" },
  hideCheckBoxLabels: true,
  autoScroll: false,
  labelWidth: 108,
  border: false,
  bodyBorder: false,
  labelAlign: "top",
  initComponent : function() {
    var containing_panel = this;
    var start_date3057 = new Lino.DateField({ "listeners": { "render": Lino.quicktip_renderer("Periode vom","(integ.ActivityReport.start_date) ") }, "fieldLabel": "Periode vom", "name": "start_date", "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var end_date3058 = new Lino.DateField({ "listeners": { "render": Lino.quicktip_renderer("bis","(integ.ActivityReport.end_date) ") }, "fieldLabel": "bis", "name": "end_date", "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var include_jobs3059 = new Ext.form.Checkbox({ "boxLabel": "Art.60\u00a77", "listeners": { "render": Lino.quicktip_renderer("Art.60\u00a77","(integ.ActivityReport.include_jobs) ") }, "hideLabel": true, "checked": false, "name": "include_jobs", "selectOnFocus": true, "anchor": "-20" });
    var include_isip3060 = new Ext.form.Checkbox({ "boxLabel": "VSE", "listeners": { "render": Lino.quicktip_renderer("VSE","(integ.ActivityReport.include_isip) ") }, "hideLabel": true, "checked": false, "name": "include_isip", "selectOnFocus": true, "anchor": "-20" });
    this.items = [ { "flex": 22, "autoHeight": true, "layout": "form", "xtype": "panel", "items": start_date3057, "labelAlign": "top" }, { "flex": 22, "autoHeight": true, "layout": "form", "xtype": "panel", "items": end_date3058, "labelAlign": "top" }, { "flex": 27, "autoHeight": true, "layout": "form", "xtype": "panel", "items": include_jobs3059, "labelAlign": "top" }, { "flex": 27, "autoHeight": true, "layout": "form", "xtype": "panel", "items": include_isip3060, "labelAlign": "top" } ];
    this.fields = [ start_date3057, end_date3058, include_jobs3059, include_isip3060 ];
    Lino.integ.ActivityReport.ParamsPanel.superclass.initComponent.call(this);
  }
});


Lino.jobs.OldJobsOverview.ParamsPanel = Ext.extend(Ext.form.FormPanel,{
  autoHeight: true,
  layout: "hbox",
  frame: true,
  layoutConfig: { "align": "stretchmax" },
  hideCheckBoxLabels: true,
  autoScroll: false,
  labelWidth: 216,
  border: false,
  bodyBorder: false,
  labelAlign: "top",
  initComponent : function() {
    var containing_panel = this;
    var contract_type3043 = new Lino.TwinCombo({ "preferred_width": 20, "fieldLabel": "Art.60\u00a77-Konventionsart", "name": "contract_type", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.jobs.ContractTypes.detail)}, "hiddenName": "contract_typeHidden", "listeners": { "render": Lino.quicktip_renderer("Art.60\u00a77-Konventionsart","(jobs.OldJobsOverview.contract_type) ") }, "selectOnFocus": true, "emptyText": "Art.60\u00a77-Konventionsart ausw\u00e4hlen...", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/jobs/OldJobsOverview/contract_type", "method": "GET" }) }) });
    var date3044 = new Lino.DateField({ "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Datum","(jobs.OldJobsOverview.date) ") }, "fieldLabel": "Datum", "anchor": "-20", "name": "date" });
    var job_type3045 = new Lino.TwinCombo({ "fieldLabel": "Stellenart", "name": "job_type", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.jobs.JobTypes.detail)}, "emptyText": "Stellenart ausw\u00e4hlen...", "listeners": { "render": Lino.quicktip_renderer("Stellenart","(jobs.OldJobsOverview.job_type) ") }, "selectOnFocus": true, "hiddenName": "job_typeHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/jobs/OldJobsOverview/job_type", "method": "GET" }) }) });
    this.items = [ { "flex": 41, "autoHeight": true, "layout": "form", "xtype": "panel", "items": contract_type3043, "labelAlign": "top" }, { "flex": 16, "autoHeight": true, "layout": "form", "xtype": "panel", "items": date3044, "labelAlign": "top" }, { "flex": 41, "autoHeight": true, "layout": "form", "xtype": "panel", "items": job_type3045, "labelAlign": "top" } ];
    this.fields = [ contract_type3043, date3044, job_type3045 ];
    Lino.jobs.OldJobsOverview.ParamsPanel.superclass.initComponent.call(this);
  }
});


Lino.pcsw.CoachingsByClient.ParamsPanel = Ext.extend(Ext.form.FormPanel,{
  autoScroll: false,
  autoHeight: true,
  border: false,
  layout: "form",
  hideCheckBoxLabels: true,
  frame: true,
  bodyBorder: false,
  labelAlign: "top",
  initComponent : function() {
    var containing_panel = this;
    var start_date204 = new Lino.DateField({ "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Periode vom","(pcsw.Coachings.start_date) Start date of observed period") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Periode vom</span>", "anchor": "-20", "name": "start_date" });
    var end_date205 = new Lino.DateField({ "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("bis","(pcsw.Coachings.end_date) End date of observed period") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">bis</span>", "anchor": "-20", "name": "end_date" });
    var observed_event206 = new Lino.ChoicesFieldElement({ "forceSelection": true, "fieldLabel": "Beobachtungskriterium", "name": "observed_event", "hiddenName": "observed_eventHidden", "listeners": { "render": Lino.quicktip_renderer("Beobachtungskriterium","(pcsw.Coachings.observed_event) ") }, "selectOnFocus": true, "anchor": "-20", "store": [['','<br>']].concat(Lino.pcsw.CoachingEvents) });
    var coached_by207 = new Lino.TwinCombo({ "preferred_width": 15, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Begleitet durch</span>", "name": "coached_by", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.users.Users.detail)}, "hiddenName": "coached_byHidden", "listeners": { "render": Lino.quicktip_renderer("Begleitet durch","(pcsw.Coachings.coached_by) Nur Begleitungen dieses Benutzers.") }, "selectOnFocus": true, "emptyText": "Benutzer ausw\u00e4hlen...", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/pcsw/Coachings/coached_by", "method": "GET" }) }) });
    var and_coached_by208 = new Lino.TwinCombo({ "preferred_width": 15, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">und durch</span>", "name": "and_coached_by", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.users.Users.detail)}, "hiddenName": "and_coached_byHidden", "listeners": { "render": Lino.quicktip_renderer("und durch","(pcsw.Coachings.and_coached_by) ... und auch Begleitungen dieses Benutzers.") }, "selectOnFocus": true, "emptyText": "Benutzer ausw\u00e4hlen...", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/pcsw/Coachings/and_coached_by", "method": "GET" }) }) });
    var main_1_panel209 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 12, "autoHeight": true, "layout": "form", "xtype": "panel", "items": start_date204, "labelAlign": "top" }, { "flex": 12, "autoHeight": true, "layout": "form", "xtype": "panel", "items": end_date205, "labelAlign": "top" }, { "flex": 15, "autoHeight": true, "layout": "form", "xtype": "panel", "items": observed_event206, "labelAlign": "top" }, { "flex": 30, "autoHeight": true, "layout": "form", "xtype": "panel", "items": coached_by207, "labelAlign": "top" }, { "flex": 30, "autoHeight": true, "layout": "form", "xtype": "panel", "items": and_coached_by208, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 198, "border": false, "anchor": "-20", "labelAlign": "top" });
    var primary_coachings215 = new Lino.ChoicesFieldElement({ "forceSelection": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Prim\u00e4re Begleitungen</span>", "name": "primary_coachings", "hiddenName": "primary_coachingsHidden", "listeners": { "render": Lino.quicktip_renderer("Prim\u00e4re Begleitungen","(pcsw.Coachings.primary_coachings) Accompagnements primaires.") }, "selectOnFocus": true, "anchor": "-20", "store": [['','<br>']].concat(Lino.lino.YesNo) });
    var coaching_type216 = new Lino.RemoteComboFieldElement({ "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Dienst</span>", "name": "coaching_type", "pageSize": 20, "emptyText": "Dienst ausw\u00e4hlen...", "listeners": { "render": Lino.quicktip_renderer("Dienst","(pcsw.Coachings.coaching_type) Nur Begleitungen dieses Dienstes.") }, "selectOnFocus": true, "hiddenName": "coaching_typeHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/pcsw/Coachings/coaching_type", "method": "GET" }) }) });
    var ending217 = new Lino.TwinCombo({ "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Beendigungsgrund</span>", "name": "ending", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.pcsw.CoachingEndings.detail)}, "emptyText": "Beendigungsgrund ausw\u00e4hlen...", "listeners": { "render": Lino.quicktip_renderer("Beendigungsgrund","(pcsw.Coachings.ending) Nur Begleitungen mit diesem Beendigungsgrund.") }, "selectOnFocus": true, "hiddenName": "endingHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/pcsw/Coachings/ending", "method": "GET" }) }) });
    var main_2_panel218 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 14, "autoHeight": true, "layout": "form", "xtype": "panel", "items": primary_coachings215, "labelAlign": "top" }, { "flex": 42, "autoHeight": true, "layout": "form", "xtype": "panel", "items": coaching_type216, "labelAlign": "top" }, { "flex": 42, "autoHeight": true, "layout": "form", "xtype": "panel", "items": ending217, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 189, "border": false, "anchor": "-20", "labelAlign": "top" });
    this.items = [ main_1_panel209, main_2_panel218 ];
    this.fields = [ start_date204, end_date205, observed_event206, coached_by207, and_coached_by208, primary_coachings215, coaching_type216, ending217 ];
    Lino.pcsw.CoachingsByClient.ParamsPanel.superclass.initComponent.call(this);
  }
});


Lino.contacts.Persons.ParamsPanel = Ext.extend(Ext.form.FormPanel,{
  autoScroll: false,
  border: false,
  layout: "fit",
  hideCheckBoxLabels: true,
  frame: true,
  bodyBorder: false,
  labelAlign: "top",
  initComponent : function() {
    var containing_panel = this;
    var gender906 = new Lino.ChoicesFieldElement({ "forceSelection": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Geschlecht</span>", "name": "gender", "hiddenName": "genderHidden", "listeners": { "render": Lino.quicktip_renderer("Geschlecht","(contacts.Persons.gender) Nur Personen, deren Feld \"Geschlecht\" ausgef\u00fcllt ist und dem angegebenen Wert entspricht.") }, "selectOnFocus": true, "anchor": "-20", "store": [['','<br>']].concat(Lino.lino.Genders) });
    var also_obsolete907 = new Ext.form.Checkbox({ "boxLabel": "Auch veraltete Daten", "listeners": { "render": Lino.quicktip_renderer("Auch veraltete Daten","(contacts.Persons.also_obsolete) Auch Datens\u00e4tze anzeigen, die als veraltet markiert sind.") }, "hideLabel": true, "checked": false, "name": "also_obsolete", "selectOnFocus": true, "anchor": "-20" });
    var main_1_panel908 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 189, "hideCheckBoxLabels": true, "items": [ { "flex": 47, "autoHeight": true, "layout": "form", "xtype": "panel", "items": gender906, "labelAlign": "top" }, { "flex": 52, "autoHeight": true, "layout": "form", "xtype": "panel", "items": also_obsolete907, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    this.items = [ main_1_panel908 ];
    this.fields = [ gender906, also_obsolete907 ];
    Lino.contacts.Persons.ParamsPanel.superclass.initComponent.call(this);
  }
});


Lino.jobs.JobsOverview.ParamsPanel = Ext.extend(Ext.form.FormPanel,{
  autoHeight: true,
  layout: "hbox",
  frame: true,
  layoutConfig: { "align": "stretchmax" },
  hideCheckBoxLabels: true,
  autoScroll: false,
  labelWidth: 99,
  border: false,
  bodyBorder: false,
  labelAlign: "top",
  initComponent : function() {
    var containing_panel = this;
    var job_type3052 = new Lino.TwinCombo({ "fieldLabel": "Stellenart", "name": "job_type", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.jobs.JobTypes.detail)}, "emptyText": "Stellenart ausw\u00e4hlen...", "listeners": { "render": Lino.quicktip_renderer("Stellenart","(jobs.JobsOverview.job_type) ") }, "selectOnFocus": true, "hiddenName": "job_typeHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/jobs/JobsOverview/job_type", "method": "GET" }) }) });
    var today3053 = new Lino.DateField({ "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Datum","(jobs.JobsOverview.today) ") }, "fieldLabel": "Datum", "anchor": "-20", "name": "today" });
    this.items = [ { "flex": 71, "autoHeight": true, "layout": "form", "xtype": "panel", "items": job_type3052, "labelAlign": "top" }, { "flex": 28, "autoHeight": true, "layout": "form", "xtype": "panel", "items": today3053, "labelAlign": "top" } ];
    this.fields = [ job_type3052, today3053 ];
    Lino.jobs.JobsOverview.ParamsPanel.superclass.initComponent.call(this);
  }
});


Lino.courses.PendingCourseRequests.ParamsPanel = Ext.extend(Ext.form.FormPanel,{
  autoScroll: false,
  autoHeight: true,
  border: false,
  layout: "form",
  hideCheckBoxLabels: true,
  frame: true,
  bodyBorder: false,
  labelAlign: "top",
  initComponent : function() {
    var containing_panel = this;
    var aged_from2677 = new Ext.form.NumberField({ "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Alter von","(courses.PendingCourseRequests.aged_from) Nur Klienten, die mindestens so alt sind.") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Alter von</span>", "anchor": "-20", "name": "aged_from" });
    var aged_to2678 = new Ext.form.NumberField({ "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Alter bis","(courses.PendingCourseRequests.aged_to) Nur Klienten, die h\u00f6chstens so alt sind.") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Alter bis</span>", "anchor": "-20", "name": "aged_to" });
    var gender2679 = new Lino.ChoicesFieldElement({ "forceSelection": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Geschlecht</span>", "name": "gender", "hiddenName": "genderHidden", "listeners": { "render": Lino.quicktip_renderer("Geschlecht","(courses.PendingCourseRequests.gender) Nur Personen, deren Feld \"Geschlecht\" ausgef\u00fcllt ist und dem angegebenen Wert entspricht.") }, "selectOnFocus": true, "anchor": "-20", "store": [['','<br>']].concat(Lino.lino.Genders) });
    var nationality2680 = new Lino.TwinCombo({ "fieldLabel": "Staatsangeh\u00f6rigkeit", "name": "nationality", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.countries.Countries.detail)}, "emptyText": "Land ausw\u00e4hlen...", "listeners": { "render": Lino.quicktip_renderer("Staatsangeh\u00f6rigkeit","(courses.PendingCourseRequests.nationality) ") }, "selectOnFocus": true, "hiddenName": "nationalityHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/courses/PendingCourseRequests/nationality", "method": "GET" }) }) });
    var also_obsolete2681 = new Ext.form.Checkbox({ "boxLabel": "Auch veraltete Daten", "listeners": { "render": Lino.quicktip_renderer("Auch veraltete Daten","(courses.PendingCourseRequests.also_obsolete) Auch Datens\u00e4tze anzeigen, die als veraltet markiert sind.") }, "hideLabel": true, "checked": false, "name": "also_obsolete", "selectOnFocus": true, "anchor": "-20" });
    var main_1_panel2682 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 10, "autoHeight": true, "layout": "form", "xtype": "panel", "items": aged_from2677, "labelAlign": "top" }, { "flex": 10, "autoHeight": true, "layout": "form", "xtype": "panel", "items": aged_to2678, "labelAlign": "top" }, { "flex": 18, "autoHeight": true, "layout": "form", "xtype": "panel", "items": gender2679, "labelAlign": "top" }, { "flex": 40, "autoHeight": true, "layout": "form", "xtype": "panel", "items": nationality2680, "labelAlign": "top" }, { "flex": 20, "autoHeight": true, "layout": "form", "xtype": "panel", "items": also_obsolete2681, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 189, "border": false, "anchor": "-20", "labelAlign": "top" });
    var client_state2688 = new Lino.ChoicesFieldElement({ "forceSelection": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Zustand</span>", "name": "client_state", "hiddenName": "client_stateHidden", "listeners": { "render": Lino.quicktip_renderer("Zustand","(courses.PendingCourseRequests.client_state) Nur Klienten mit diesem Status (Aktenzustand).") }, "selectOnFocus": true, "anchor": "-20", "store": [['','<br>']].concat(Lino.pcsw.ClientStates) });
    var coached_by2689 = new Lino.TwinCombo({ "preferred_width": 15, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Begleitet durch</span>", "name": "coached_by", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.users.Users.detail)}, "hiddenName": "coached_byHidden", "listeners": { "render": Lino.quicktip_renderer("Begleitet durch","(courses.PendingCourseRequests.coached_by) Nur Klienten, die eine Begleitung mit diesem Benutzer haben.") }, "selectOnFocus": true, "emptyText": "Benutzer ausw\u00e4hlen...", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/courses/PendingCourseRequests/coached_by", "method": "GET" }) }) });
    var and_coached_by2690 = new Lino.TwinCombo({ "preferred_width": 15, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">und durch</span>", "name": "and_coached_by", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.users.Users.detail)}, "hiddenName": "and_coached_byHidden", "listeners": { "render": Lino.quicktip_renderer("und durch","(courses.PendingCourseRequests.and_coached_by) Nur Klienten, die auch mit diesem Benutzer eine Begleitung haben.") }, "selectOnFocus": true, "emptyText": "Benutzer ausw\u00e4hlen...", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/courses/PendingCourseRequests/and_coached_by", "method": "GET" }) }) });
    var start_date2691 = new Lino.DateField({ "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Periode vom","(courses.PendingCourseRequests.start_date) Start date of observed period") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Periode vom</span>", "anchor": "-20", "name": "start_date" });
    var end_date2692 = new Lino.DateField({ "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("bis","(courses.PendingCourseRequests.end_date) End date of observed period") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">bis</span>", "anchor": "-20", "name": "end_date" });
    var observed_event2693 = new Lino.ChoicesFieldElement({ "forceSelection": true, "fieldLabel": "Beobachtungskriterium", "name": "observed_event", "hiddenName": "observed_eventHidden", "listeners": { "render": Lino.quicktip_renderer("Beobachtungskriterium","(courses.PendingCourseRequests.observed_event) ") }, "selectOnFocus": true, "anchor": "-20", "store": [['','<br>']].concat(Lino.pcsw.ClientEvents) });
    var only_primary2694 = new Ext.form.Checkbox({ "boxLabel": "Nur prim\u00e4re Begleitungen", "listeners": { "render": Lino.quicktip_renderer("Nur prim\u00e4re Begleitungen","(courses.PendingCourseRequests.only_primary) Nur Klienten, die eine effektive <b>prim\u00e4re</b> Begleitung haben.") }, "hideLabel": true, "checked": false, "name": "only_primary", "selectOnFocus": true, "anchor": "-20" });
    var main_2_panel2695 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 11, "autoHeight": true, "layout": "form", "xtype": "panel", "items": client_state2688, "labelAlign": "top" }, { "flex": 20, "autoHeight": true, "layout": "form", "xtype": "panel", "items": coached_by2689, "labelAlign": "top" }, { "flex": 20, "autoHeight": true, "layout": "form", "xtype": "panel", "items": and_coached_by2690, "labelAlign": "top" }, { "flex": 8, "autoHeight": true, "layout": "form", "xtype": "panel", "items": start_date2691, "labelAlign": "top" }, { "flex": 8, "autoHeight": true, "layout": "form", "xtype": "panel", "items": end_date2692, "labelAlign": "top" }, { "flex": 20, "autoHeight": true, "layout": "form", "xtype": "panel", "items": observed_event2693, "labelAlign": "top" }, { "flex": 10, "autoHeight": true, "layout": "form", "xtype": "panel", "items": only_primary2694, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 225, "border": false, "anchor": "-20", "labelAlign": "top" });
    var request_state2703 = new Lino.ChoicesFieldElement({ "forceSelection": true, "fieldLabel": "Zustand", "name": "request_state", "hiddenName": "request_stateHidden", "listeners": { "render": Lino.quicktip_renderer("Zustand","(courses.PendingCourseRequests.request_state) ") }, "selectOnFocus": true, "anchor": "-20", "store": [['','<br>']].concat(Lino.courses.CourseRequestStates) });
    var course_content2704 = new Lino.TwinCombo({ "fieldLabel": "Kursinhalt", "name": "course_content", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.courses.CourseContents.detail)}, "emptyText": "Kursinhalt ausw\u00e4hlen...", "listeners": { "render": Lino.quicktip_renderer("Kursinhalt","(courses.PendingCourseRequests.course_content) ") }, "selectOnFocus": true, "hiddenName": "course_contentHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/courses/PendingCourseRequests/course_content", "method": "GET" }) }) });
    var course_provider2705 = new Lino.TwinCombo({ "preferred_width": 20, "fieldLabel": "Kursanbieter", "name": "course_provider", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.courses.CourseProviders.detail)}, "hiddenName": "course_providerHidden", "listeners": { "render": Lino.quicktip_renderer("Kursanbieter","(courses.PendingCourseRequests.course_provider) ") }, "selectOnFocus": true, "emptyText": "Kursanbieter ausw\u00e4hlen...", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/courses/PendingCourseRequests/course_provider", "method": "GET" }) }) });
    var course_offer2706 = new Lino.TwinCombo({ "fieldLabel": "Kursangebot", "name": "course_offer", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.courses.CourseOffers.detail)}, "emptyText": "Kursangebot ausw\u00e4hlen...", "listeners": { "render": Lino.quicktip_renderer("Kursangebot","(courses.PendingCourseRequests.course_offer) ") }, "selectOnFocus": true, "hiddenName": "course_offerHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/courses/PendingCourseRequests/course_offer", "method": "GET" }) }) });
    var main_3_panel2707 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 17, "autoHeight": true, "layout": "form", "xtype": "panel", "items": request_state2703, "labelAlign": "top" }, { "flex": 27, "autoHeight": true, "layout": "form", "xtype": "panel", "items": course_content2704, "labelAlign": "top" }, { "flex": 27, "autoHeight": true, "layout": "form", "xtype": "panel", "items": course_provider2705, "labelAlign": "top" }, { "flex": 27, "autoHeight": true, "layout": "form", "xtype": "panel", "items": course_offer2706, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 117, "border": false, "anchor": "-20", "labelAlign": "top" });
    this.items = [ main_1_panel2682, main_2_panel2695, main_3_panel2707 ];
    this.fields = [ aged_from2677, aged_to2678, gender2679, nationality2680, also_obsolete2681, client_state2688, coached_by2689, and_coached_by2690, start_date2691, end_date2692, observed_event2693, only_primary2694, request_state2703, course_content2704, course_provider2705, course_offer2706 ];
    Lino.courses.PendingCourseRequests.ParamsPanel.superclass.initComponent.call(this);
  }
});


Lino.cal.MyPresences.ParamsPanel = Ext.extend(Ext.form.FormPanel,{
  autoScroll: false,
  autoHeight: true,
  border: false,
  layout: "form",
  hideCheckBoxLabels: true,
  frame: true,
  bodyBorder: false,
  labelAlign: "top",
  initComponent : function() {
    var containing_panel = this;
    var start_date1051 = new Lino.DateField({ "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Periode vom","(cal.Guests.start_date) Start date of observed period") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Periode vom</span>", "anchor": "-20", "name": "start_date" });
    var end_date1052 = new Lino.DateField({ "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("bis","(cal.Guests.end_date) End date of observed period") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">bis</span>", "anchor": "-20", "name": "end_date" });
    var user1053 = new Lino.TwinCombo({ "preferred_width": 15, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Verantwortlicher</span>", "name": "user", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.users.Users.detail)}, "hiddenName": "userHidden", "listeners": { "render": Lino.quicktip_renderer("Verantwortlicher","(cal.Guests.user) Only rows managed by this user.") }, "selectOnFocus": true, "emptyText": "Benutzer ausw\u00e4hlen...", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/Guests/user", "method": "GET" }) }) });
    var event_state1054 = new Lino.ChoicesFieldElement({ "forceSelection": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Zustand Termin</span>", "name": "event_state", "hiddenName": "event_stateHidden", "listeners": { "render": Lino.quicktip_renderer("Zustand Termin","(cal.Guests.event_state) Only rows having this event state.") }, "selectOnFocus": true, "anchor": "-20", "store": [['','<br>']].concat(Lino.cal.EventStates) });
    var guest_state1055 = new Lino.ChoicesFieldElement({ "forceSelection": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Zustand Gast</span>", "name": "guest_state", "hiddenName": "guest_stateHidden", "listeners": { "render": Lino.quicktip_renderer("Zustand Gast","(cal.Guests.guest_state) Only rows having this guest state.") }, "selectOnFocus": true, "anchor": "-20", "store": [['','<br>']].concat(Lino.cal.GuestStates) });
    var main_1_panel1056 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 13, "autoHeight": true, "layout": "form", "xtype": "panel", "items": start_date1051, "labelAlign": "top" }, { "flex": 13, "autoHeight": true, "layout": "form", "xtype": "panel", "items": end_date1052, "labelAlign": "top" }, { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": user1053, "labelAlign": "top" }, { "flex": 21, "autoHeight": true, "layout": "form", "xtype": "panel", "items": event_state1054, "labelAlign": "top" }, { "flex": 18, "autoHeight": true, "layout": "form", "xtype": "panel", "items": guest_state1055, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 153, "border": false, "anchor": "-20", "labelAlign": "top" });
    var project1062 = new Lino.TwinCombo({ "preferred_width": 20, "fieldLabel": "Klient", "name": "project", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.pcsw.Clients.detail)}, "hiddenName": "projectHidden", "listeners": { "render": Lino.quicktip_renderer("Klient","(cal.Guests.project) ") }, "selectOnFocus": true, "emptyText": "Klient ausw\u00e4hlen...", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/Guests/project", "method": "GET" }) }) });
    var partner1063 = new Lino.TwinCombo({ "preferred_width": 20, "fieldLabel": "Partner", "name": "partner", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.contacts.Partners.detail)}, "hiddenName": "partnerHidden", "listeners": { "render": Lino.quicktip_renderer("Partner","(cal.Guests.partner) ") }, "selectOnFocus": true, "emptyText": "Partner ausw\u00e4hlen...", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/Guests/partner", "method": "GET" }) }) });
    var main_2_panel1064 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": project1062, "labelAlign": "top" }, { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": partner1063, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 72, "border": false, "anchor": "-20", "labelAlign": "top" });
    this.items = [ main_1_panel1056, main_2_panel1064 ];
    this.fields = [ start_date1051, end_date1052, user1053, event_state1054, guest_state1055, project1062, partner1063 ];
    Lino.cal.MyPresences.ParamsPanel.superclass.initComponent.call(this);
  }
});


Lino.cal.Events.ParamsPanel = Ext.extend(Ext.form.FormPanel,{
  autoScroll: false,
  autoHeight: true,
  border: false,
  layout: "form",
  hideCheckBoxLabels: true,
  frame: true,
  bodyBorder: false,
  labelAlign: "top",
  initComponent : function() {
    var containing_panel = this;
    var start_date989 = new Lino.DateField({ "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Periode vom","(cal.Events.start_date) Start date of observed period") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Periode vom</span>", "anchor": "-20", "name": "start_date" });
    var end_date990 = new Lino.DateField({ "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("bis","(cal.Events.end_date) End date of observed period") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">bis</span>", "anchor": "-20", "name": "end_date" });
    var observed_event991 = new Lino.ChoicesFieldElement({ "forceSelection": true, "fieldLabel": "Beobachtungskriterium", "name": "observed_event", "hiddenName": "observed_eventHidden", "listeners": { "render": Lino.quicktip_renderer("Beobachtungskriterium","(cal.Events.observed_event) ") }, "selectOnFocus": true, "anchor": "-20", "store": [['','<br>']].concat(Lino.cal.EventEvents) });
    var state992 = new Lino.ChoicesFieldElement({ "forceSelection": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Zustand</span>", "name": "state", "hiddenName": "stateHidden", "listeners": { "render": Lino.quicktip_renderer("Zustand","(cal.Events.state) Only rows having this state.") }, "selectOnFocus": true, "anchor": "-20", "store": [['','<br>']].concat(Lino.cal.EventStates) });
    var main_1_panel993 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 20, "autoHeight": true, "layout": "form", "xtype": "panel", "items": start_date989, "labelAlign": "top" }, { "flex": 20, "autoHeight": true, "layout": "form", "xtype": "panel", "items": end_date990, "labelAlign": "top" }, { "flex": 25, "autoHeight": true, "layout": "form", "xtype": "panel", "items": observed_event991, "labelAlign": "top" }, { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": state992, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 198, "border": false, "anchor": "-20", "labelAlign": "top" });
    var user998 = new Lino.TwinCombo({ "preferred_width": 15, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Verwaltet durch</span>", "name": "user", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.users.Users.detail)}, "hiddenName": "userHidden", "listeners": { "render": Lino.quicktip_renderer("Verwaltet durch","(cal.Events.user) Only rows managed by this user.") }, "selectOnFocus": true, "emptyText": "Benutzer ausw\u00e4hlen...", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/Events/user", "method": "GET" }) }) });
    var assigned_to999 = new Lino.TwinCombo({ "preferred_width": 15, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Zugewiesen zu</span>", "name": "assigned_to", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.users.Users.detail)}, "hiddenName": "assigned_toHidden", "listeners": { "render": Lino.quicktip_renderer("Zugewiesen zu","(cal.Events.assigned_to) Only events assigned to this user.") }, "selectOnFocus": true, "emptyText": "Benutzer ausw\u00e4hlen...", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/Events/assigned_to", "method": "GET" }) }) });
    var project1000 = new Lino.TwinCombo({ "preferred_width": 20, "fieldLabel": "Klient", "name": "project", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.pcsw.Clients.detail)}, "hiddenName": "projectHidden", "listeners": { "render": Lino.quicktip_renderer("Klient","(cal.Events.project) ") }, "selectOnFocus": true, "emptyText": "Klient ausw\u00e4hlen...", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/Events/project", "method": "GET" }) }) });
    var calendar1001 = new Lino.TwinCombo({ "fieldLabel": "Kalender", "name": "calendar", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.cal.Calendars.detail)}, "emptyText": "Kalender ausw\u00e4hlen...", "listeners": { "render": Lino.quicktip_renderer("Kalender","(cal.Events.calendar) ") }, "selectOnFocus": true, "hiddenName": "calendarHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/Events/calendar", "method": "GET" }) }) });
    var show_appointments1002 = new Lino.ChoicesFieldElement({ "forceSelection": true, "fieldLabel": "Termine", "name": "show_appointments", "hiddenName": "show_appointmentsHidden", "listeners": { "render": Lino.quicktip_renderer("Termine","(cal.Events.show_appointments) ") }, "selectOnFocus": true, "anchor": "-20", "store": [['','<br>']].concat(Lino.lino.YesNo) });
    var main_2_panel1003 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 22, "autoHeight": true, "layout": "form", "xtype": "panel", "items": user998, "labelAlign": "top" }, { "flex": 22, "autoHeight": true, "layout": "form", "xtype": "panel", "items": assigned_to999, "labelAlign": "top" }, { "flex": 22, "autoHeight": true, "layout": "form", "xtype": "panel", "items": project1000, "labelAlign": "top" }, { "flex": 22, "autoHeight": true, "layout": "form", "xtype": "panel", "items": calendar1001, "labelAlign": "top" }, { "flex": 8, "autoHeight": true, "layout": "form", "xtype": "panel", "items": show_appointments1002, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 144, "border": false, "anchor": "-20", "labelAlign": "top" });
    this.items = [ main_1_panel993, main_2_panel1003 ];
    this.fields = [ start_date989, end_date990, observed_event991, state992, user998, assigned_to999, project1000, calendar1001, show_appointments1002 ];
    Lino.cal.Events.ParamsPanel.superclass.initComponent.call(this);
  }
});


Lino.pcsw.Clients.ParamsPanel = Ext.extend(Ext.form.FormPanel,{
  autoScroll: false,
  autoHeight: true,
  border: false,
  layout: "form",
  hideCheckBoxLabels: true,
  frame: true,
  bodyBorder: false,
  labelAlign: "top",
  initComponent : function() {
    var containing_panel = this;
    var aged_from2474 = new Ext.form.NumberField({ "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Alter von","(pcsw.Clients.aged_from) Nur Klienten, die mindestens so alt sind.") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Alter von</span>", "anchor": "-20", "name": "aged_from" });
    var aged_to2475 = new Ext.form.NumberField({ "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Alter bis","(pcsw.Clients.aged_to) Nur Klienten, die h\u00f6chstens so alt sind.") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Alter bis</span>", "anchor": "-20", "name": "aged_to" });
    var gender2476 = new Lino.ChoicesFieldElement({ "forceSelection": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Geschlecht</span>", "name": "gender", "hiddenName": "genderHidden", "listeners": { "render": Lino.quicktip_renderer("Geschlecht","(pcsw.Clients.gender) Nur Personen, deren Feld \"Geschlecht\" ausgef\u00fcllt ist und dem angegebenen Wert entspricht.") }, "selectOnFocus": true, "anchor": "-20", "store": [['','<br>']].concat(Lino.lino.Genders) });
    var nationality2477 = new Lino.TwinCombo({ "fieldLabel": "Staatsangeh\u00f6rigkeit", "name": "nationality", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.countries.Countries.detail)}, "emptyText": "Land ausw\u00e4hlen...", "listeners": { "render": Lino.quicktip_renderer("Staatsangeh\u00f6rigkeit","(pcsw.Clients.nationality) ") }, "selectOnFocus": true, "hiddenName": "nationalityHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/pcsw/Clients/nationality", "method": "GET" }) }) });
    var also_obsolete2478 = new Ext.form.Checkbox({ "boxLabel": "Auch veraltete Daten", "listeners": { "render": Lino.quicktip_renderer("Auch veraltete Daten","(pcsw.Clients.also_obsolete) Auch Datens\u00e4tze anzeigen, die als veraltet markiert sind.") }, "hideLabel": true, "checked": false, "name": "also_obsolete", "selectOnFocus": true, "anchor": "-20" });
    var main_1_panel2479 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 10, "autoHeight": true, "layout": "form", "xtype": "panel", "items": aged_from2474, "labelAlign": "top" }, { "flex": 10, "autoHeight": true, "layout": "form", "xtype": "panel", "items": aged_to2475, "labelAlign": "top" }, { "flex": 18, "autoHeight": true, "layout": "form", "xtype": "panel", "items": gender2476, "labelAlign": "top" }, { "flex": 40, "autoHeight": true, "layout": "form", "xtype": "panel", "items": nationality2477, "labelAlign": "top" }, { "flex": 20, "autoHeight": true, "layout": "form", "xtype": "panel", "items": also_obsolete2478, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 189, "border": false, "anchor": "-20", "labelAlign": "top" });
    var client_state2485 = new Lino.ChoicesFieldElement({ "forceSelection": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Zustand</span>", "name": "client_state", "hiddenName": "client_stateHidden", "listeners": { "render": Lino.quicktip_renderer("Zustand","(pcsw.Clients.client_state) Nur Klienten mit diesem Status (Aktenzustand).") }, "selectOnFocus": true, "anchor": "-20", "store": [['','<br>']].concat(Lino.pcsw.ClientStates) });
    var coached_by2486 = new Lino.TwinCombo({ "preferred_width": 15, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Begleitet durch</span>", "name": "coached_by", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.users.Users.detail)}, "hiddenName": "coached_byHidden", "listeners": { "render": Lino.quicktip_renderer("Begleitet durch","(pcsw.Clients.coached_by) Nur Klienten, die eine Begleitung mit diesem Benutzer haben.") }, "selectOnFocus": true, "emptyText": "Benutzer ausw\u00e4hlen...", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/pcsw/Clients/coached_by", "method": "GET" }) }) });
    var and_coached_by2487 = new Lino.TwinCombo({ "preferred_width": 15, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">und durch</span>", "name": "and_coached_by", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.users.Users.detail)}, "hiddenName": "and_coached_byHidden", "listeners": { "render": Lino.quicktip_renderer("und durch","(pcsw.Clients.and_coached_by) Nur Klienten, die auch mit diesem Benutzer eine Begleitung haben.") }, "selectOnFocus": true, "emptyText": "Benutzer ausw\u00e4hlen...", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/pcsw/Clients/and_coached_by", "method": "GET" }) }) });
    var start_date2488 = new Lino.DateField({ "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Periode vom","(pcsw.Clients.start_date) Start date of observed period") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Periode vom</span>", "anchor": "-20", "name": "start_date" });
    var end_date2489 = new Lino.DateField({ "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("bis","(pcsw.Clients.end_date) End date of observed period") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">bis</span>", "anchor": "-20", "name": "end_date" });
    var observed_event2490 = new Lino.ChoicesFieldElement({ "forceSelection": true, "fieldLabel": "Beobachtungskriterium", "name": "observed_event", "hiddenName": "observed_eventHidden", "listeners": { "render": Lino.quicktip_renderer("Beobachtungskriterium","(pcsw.Clients.observed_event) ") }, "selectOnFocus": true, "anchor": "-20", "store": [['','<br>']].concat(Lino.pcsw.ClientEvents) });
    var only_primary2491 = new Ext.form.Checkbox({ "boxLabel": "Nur prim\u00e4re Begleitungen", "listeners": { "render": Lino.quicktip_renderer("Nur prim\u00e4re Begleitungen","(pcsw.Clients.only_primary) Nur Klienten, die eine effektive <b>prim\u00e4re</b> Begleitung haben.") }, "hideLabel": true, "checked": false, "name": "only_primary", "selectOnFocus": true, "anchor": "-20" });
    var main_2_panel2492 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 11, "autoHeight": true, "layout": "form", "xtype": "panel", "items": client_state2485, "labelAlign": "top" }, { "flex": 20, "autoHeight": true, "layout": "form", "xtype": "panel", "items": coached_by2486, "labelAlign": "top" }, { "flex": 20, "autoHeight": true, "layout": "form", "xtype": "panel", "items": and_coached_by2487, "labelAlign": "top" }, { "flex": 8, "autoHeight": true, "layout": "form", "xtype": "panel", "items": start_date2488, "labelAlign": "top" }, { "flex": 8, "autoHeight": true, "layout": "form", "xtype": "panel", "items": end_date2489, "labelAlign": "top" }, { "flex": 20, "autoHeight": true, "layout": "form", "xtype": "panel", "items": observed_event2490, "labelAlign": "top" }, { "flex": 10, "autoHeight": true, "layout": "form", "xtype": "panel", "items": only_primary2491, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 225, "border": false, "anchor": "-20", "labelAlign": "top" });
    this.items = [ main_1_panel2479, main_2_panel2492 ];
    this.fields = [ aged_from2474, aged_to2475, gender2476, nationality2477, also_obsolete2478, client_state2485, coached_by2486, and_coached_by2487, start_date2488, end_date2489, observed_event2490, only_primary2491 ];
    Lino.pcsw.Clients.ParamsPanel.superclass.initComponent.call(this);
  }
});


Lino.jobs.JobsOverviewByType.ParamsPanel = Ext.extend(Ext.form.FormPanel,{
  autoHeight: true,
  layout: "hbox",
  frame: true,
  layoutConfig: { "align": "stretchmax" },
  hideCheckBoxLabels: true,
  autoScroll: false,
  labelWidth: 216,
  border: false,
  bodyBorder: false,
  labelAlign: "top",
  initComponent : function() {
    var containing_panel = this;
    var contract_type3012 = new Lino.TwinCombo({ "preferred_width": 20, "fieldLabel": "Art.60\u00a77-Konventionsart", "name": "contract_type", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.jobs.ContractTypes.detail)}, "hiddenName": "contract_typeHidden", "listeners": { "render": Lino.quicktip_renderer("Art.60\u00a77-Konventionsart","(jobs.JobsOverviewByType.contract_type) ") }, "selectOnFocus": true, "emptyText": "Art.60\u00a77-Konventionsart ausw\u00e4hlen...", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/jobs/JobsOverviewByType/contract_type", "method": "GET" }) }) });
    var date3013 = new Lino.DateField({ "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Datum","(jobs.JobsOverviewByType.date) ") }, "fieldLabel": "Datum", "anchor": "-20", "name": "date" });
    this.items = [ { "flex": 71, "autoHeight": true, "layout": "form", "xtype": "panel", "items": contract_type3012, "labelAlign": "top" }, { "flex": 28, "autoHeight": true, "layout": "form", "xtype": "panel", "items": date3013, "labelAlign": "top" } ];
    this.fields = [ contract_type3012, date3013 ];
    Lino.jobs.JobsOverviewByType.ParamsPanel.superclass.initComponent.call(this);
  }
});


Lino.isip.Contracts.ParamsPanel = Ext.extend(Ext.form.FormPanel,{
  autoScroll: false,
  autoHeight: true,
  border: false,
  layout: "form",
  hideCheckBoxLabels: true,
  frame: true,
  bodyBorder: false,
  labelAlign: "top",
  initComponent : function() {
    var containing_panel = this;
    var user1295 = new Lino.TwinCombo({ "preferred_width": 15, "fieldLabel": "Benutzer", "name": "user", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.users.Users.detail)}, "hiddenName": "userHidden", "listeners": { "render": Lino.quicktip_renderer("Benutzer","(isip.Contracts.user) ") }, "selectOnFocus": true, "emptyText": "Benutzer ausw\u00e4hlen...", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/isip/Contracts/user", "method": "GET" }) }) });
    var type1296 = new Lino.TwinCombo({ "preferred_width": 20, "fieldLabel": "VSE-Art", "name": "type", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.isip.ContractTypes.detail)}, "hiddenName": "typeHidden", "listeners": { "render": Lino.quicktip_renderer("VSE-Art","(isip.Contracts.type) ") }, "selectOnFocus": true, "emptyText": "VSE-Art ausw\u00e4hlen...", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/isip/Contracts/type", "method": "GET" }) }) });
    var start_date1297 = new Lino.DateField({ "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Periode vom","(isip.Contracts.start_date) Start date of observed period") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Periode vom</span>", "anchor": "-20", "name": "start_date" });
    var end_date1298 = new Lino.DateField({ "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("bis","(isip.Contracts.end_date) End date of observed period") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">bis</span>", "anchor": "-20", "name": "end_date" });
    var observed_event1299 = new Lino.ChoicesFieldElement({ "forceSelection": true, "fieldLabel": "Beobachtungskriterium", "name": "observed_event", "hiddenName": "observed_eventHidden", "listeners": { "render": Lino.quicktip_renderer("Beobachtungskriterium","(isip.Contracts.observed_event) ") }, "selectOnFocus": true, "anchor": "-20", "store": [['','<br>']].concat(Lino.isip.ContractEvents) });
    var main_1_panel1300 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 30, "autoHeight": true, "layout": "form", "xtype": "panel", "items": user1295, "labelAlign": "top" }, { "flex": 30, "autoHeight": true, "layout": "form", "xtype": "panel", "items": type1296, "labelAlign": "top" }, { "flex": 12, "autoHeight": true, "layout": "form", "xtype": "panel", "items": start_date1297, "labelAlign": "top" }, { "flex": 12, "autoHeight": true, "layout": "form", "xtype": "panel", "items": end_date1298, "labelAlign": "top" }, { "flex": 15, "autoHeight": true, "layout": "form", "xtype": "panel", "items": observed_event1299, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 198, "border": false, "anchor": "-20", "labelAlign": "top" });
    var company1306 = new Lino.TwinCombo({ "preferred_width": 20, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Organisation</span>", "name": "company", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.contacts.Companies.detail)}, "hiddenName": "companyHidden", "listeners": { "render": Lino.quicktip_renderer("Organisation","(isip.Contracts.company) Nur Konventionen mit dieser Organisation als Drittpartner.") }, "selectOnFocus": true, "emptyText": "Organisation ausw\u00e4hlen...", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/isip/Contracts/company", "method": "GET" }) }) });
    var study_type1307 = new Lino.TwinCombo({ "fieldLabel": "Ausbildungsart", "name": "study_type", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.isip.StudyTypes.detail)}, "emptyText": "Ausbildungsart ausw\u00e4hlen...", "listeners": { "render": Lino.quicktip_renderer("Ausbildungsart","(isip.Contracts.study_type) ") }, "selectOnFocus": true, "hiddenName": "study_typeHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/isip/Contracts/study_type", "method": "GET" }) }) });
    var ending_success1308 = new Lino.ChoicesFieldElement({ "forceSelection": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Erfolgreich abgeschlossen</span>", "name": "ending_success", "hiddenName": "ending_successHidden", "listeners": { "render": Lino.quicktip_renderer("Erfolgreich abgeschlossen","(isip.Contracts.ending_success) Contrats termin\u00e9s avec succ\u00e8s.") }, "selectOnFocus": true, "anchor": "-20", "store": [['','<br>']].concat(Lino.lino.YesNo) });
    var ending1309 = new Lino.TwinCombo({ "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Beendigungsgrund</span>", "name": "ending", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.isip.ContractEndings.detail)}, "emptyText": "Beendigungsgrund ausw\u00e4hlen...", "listeners": { "render": Lino.quicktip_renderer("Beendigungsgrund","(isip.Contracts.ending) Nur Konventionen mit diesem Beendigungsgrund.") }, "selectOnFocus": true, "hiddenName": "endingHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/isip/Contracts/ending", "method": "GET" }) }) });
    var main_2_panel1310 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 26, "autoHeight": true, "layout": "form", "xtype": "panel", "items": company1306, "labelAlign": "top" }, { "flex": 20, "autoHeight": true, "layout": "form", "xtype": "panel", "items": study_type1307, "labelAlign": "top" }, { "flex": 26, "autoHeight": true, "layout": "form", "xtype": "panel", "items": ending_success1308, "labelAlign": "top" }, { "flex": 26, "autoHeight": true, "layout": "form", "xtype": "panel", "items": ending1309, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 234, "border": false, "anchor": "-20", "labelAlign": "top" });
    this.items = [ main_1_panel1300, main_2_panel1310 ];
    this.fields = [ user1295, type1296, start_date1297, end_date1298, observed_event1299, company1306, study_type1307, ending_success1308, ending1309 ];
    Lino.isip.Contracts.ParamsPanel.superclass.initComponent.call(this);
  }
});


Lino.integ.Clients.ParamsPanel = Ext.extend(Ext.form.FormPanel,{
  autoScroll: false,
  autoHeight: true,
  border: false,
  layout: "form",
  hideCheckBoxLabels: true,
  frame: true,
  bodyBorder: false,
  labelAlign: "top",
  initComponent : function() {
    var containing_panel = this;
    var client_state2713 = new Lino.ChoicesFieldElement({ "forceSelection": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Zustand</span>", "name": "client_state", "hiddenName": "client_stateHidden", "listeners": { "render": Lino.quicktip_renderer("Zustand","(integ.Clients.client_state) Nur Klienten mit diesem Status (Aktenzustand).") }, "selectOnFocus": true, "anchor": "-20", "store": [['','<br>']].concat(Lino.pcsw.ClientStates) });
    var coached_by2714 = new Lino.TwinCombo({ "preferred_width": 15, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Begleitet durch</span>", "name": "coached_by", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.users.Users.detail)}, "hiddenName": "coached_byHidden", "listeners": { "render": Lino.quicktip_renderer("Begleitet durch","(integ.Clients.coached_by) Nur Klienten, die eine Begleitung mit diesem Benutzer haben.") }, "selectOnFocus": true, "emptyText": "Benutzer ausw\u00e4hlen...", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/integ/Clients/coached_by", "method": "GET" }) }) });
    var and_coached_by2715 = new Lino.TwinCombo({ "preferred_width": 15, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">und durch</span>", "name": "and_coached_by", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.users.Users.detail)}, "hiddenName": "and_coached_byHidden", "listeners": { "render": Lino.quicktip_renderer("und durch","(integ.Clients.and_coached_by) Nur Klienten, die auch mit diesem Benutzer eine Begleitung haben.") }, "selectOnFocus": true, "emptyText": "Benutzer ausw\u00e4hlen...", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/integ/Clients/and_coached_by", "method": "GET" }) }) });
    var start_date2716 = new Lino.DateField({ "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Periode vom","(integ.Clients.start_date) Start date of observed period") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Periode vom</span>", "anchor": "-20", "name": "start_date" });
    var end_date2717 = new Lino.DateField({ "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("bis","(integ.Clients.end_date) End date of observed period") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">bis</span>", "anchor": "-20", "name": "end_date" });
    var observed_event2718 = new Lino.ChoicesFieldElement({ "forceSelection": true, "fieldLabel": "Beobachtungskriterium", "name": "observed_event", "hiddenName": "observed_eventHidden", "listeners": { "render": Lino.quicktip_renderer("Beobachtungskriterium","(integ.Clients.observed_event) ") }, "selectOnFocus": true, "anchor": "-20", "store": [['','<br>']].concat(Lino.pcsw.ClientEvents) });
    var main_1_panel2719 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 12, "autoHeight": true, "layout": "form", "xtype": "panel", "items": client_state2713, "labelAlign": "top" }, { "flex": 22, "autoHeight": true, "layout": "form", "xtype": "panel", "items": coached_by2714, "labelAlign": "top" }, { "flex": 22, "autoHeight": true, "layout": "form", "xtype": "panel", "items": and_coached_by2715, "labelAlign": "top" }, { "flex": 9, "autoHeight": true, "layout": "form", "xtype": "panel", "items": start_date2716, "labelAlign": "top" }, { "flex": 9, "autoHeight": true, "layout": "form", "xtype": "panel", "items": end_date2717, "labelAlign": "top" }, { "flex": 22, "autoHeight": true, "layout": "form", "xtype": "panel", "items": observed_event2718, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 198, "border": false, "anchor": "-20", "labelAlign": "top" });
    var aged_from2726 = new Ext.form.NumberField({ "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Alter von","(integ.Clients.aged_from) Nur Klienten, die mindestens so alt sind.") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Alter von</span>", "anchor": "-20", "name": "aged_from" });
    var aged_to2727 = new Ext.form.NumberField({ "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Alter bis","(integ.Clients.aged_to) Nur Klienten, die h\u00f6chstens so alt sind.") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Alter bis</span>", "anchor": "-20", "name": "aged_to" });
    var gender2728 = new Lino.ChoicesFieldElement({ "forceSelection": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Geschlecht</span>", "name": "gender", "hiddenName": "genderHidden", "listeners": { "render": Lino.quicktip_renderer("Geschlecht","(integ.Clients.gender) Nur Personen, deren Feld \"Geschlecht\" ausgef\u00fcllt ist und dem angegebenen Wert entspricht.") }, "selectOnFocus": true, "anchor": "-20", "store": [['','<br>']].concat(Lino.lino.Genders) });
    var nationality2729 = new Lino.TwinCombo({ "fieldLabel": "Staatsangeh\u00f6rigkeit", "name": "nationality", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.countries.Countries.detail)}, "emptyText": "Land ausw\u00e4hlen...", "listeners": { "render": Lino.quicktip_renderer("Staatsangeh\u00f6rigkeit","(integ.Clients.nationality) ") }, "selectOnFocus": true, "hiddenName": "nationalityHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/integ/Clients/nationality", "method": "GET" }) }) });
    var also_obsolete2730 = new Ext.form.Checkbox({ "boxLabel": "Auch veraltete Daten", "listeners": { "render": Lino.quicktip_renderer("Auch veraltete Daten","(integ.Clients.also_obsolete) Auch Datens\u00e4tze anzeigen, die als veraltet markiert sind.") }, "hideLabel": true, "checked": false, "name": "also_obsolete", "selectOnFocus": true, "anchor": "-20" });
    var main_2_panel2731 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 10, "autoHeight": true, "layout": "form", "xtype": "panel", "items": aged_from2726, "labelAlign": "top" }, { "flex": 10, "autoHeight": true, "layout": "form", "xtype": "panel", "items": aged_to2727, "labelAlign": "top" }, { "flex": 18, "autoHeight": true, "layout": "form", "xtype": "panel", "items": gender2728, "labelAlign": "top" }, { "flex": 40, "autoHeight": true, "layout": "form", "xtype": "panel", "items": nationality2729, "labelAlign": "top" }, { "flex": 20, "autoHeight": true, "layout": "form", "xtype": "panel", "items": also_obsolete2730, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 189, "border": false, "anchor": "-20", "labelAlign": "top" });
    var language2737 = new Lino.TwinCombo({ "fieldLabel": "Sprachkenntnis", "name": "language", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.languages.Languages.detail)}, "emptyText": "Sprache ausw\u00e4hlen...", "listeners": { "render": Lino.quicktip_renderer("Sprachkenntnis","(integ.Clients.language) ") }, "selectOnFocus": true, "hiddenName": "languageHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/integ/Clients/language", "method": "GET" }) }) });
    var wanted_property2738 = new Lino.TwinCombo({ "fieldLabel": "Erw\u00fcnschte Eigenschaft", "name": "wanted_property", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.properties.Properties.detail)}, "emptyText": "Eigenschaft ausw\u00e4hlen...", "listeners": { "render": Lino.quicktip_renderer("Erw\u00fcnschte Eigenschaft","(integ.Clients.wanted_property) ") }, "selectOnFocus": true, "hiddenName": "wanted_propertyHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/integ/Clients/wanted_property", "method": "GET" }) }) });
    var group2739 = new Lino.RemoteComboFieldElement({ "fieldLabel": "Integrationsphase", "name": "group", "pageSize": 20, "emptyText": "Integrationsphase ausw\u00e4hlen...", "listeners": { "render": Lino.quicktip_renderer("Integrationsphase","(integ.Clients.group) ") }, "selectOnFocus": true, "hiddenName": "groupHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/integ/Clients/group", "method": "GET" }) }) });
    var only_active2740 = new Ext.form.Checkbox({ "boxLabel": "Nur aktive Klienten", "listeners": { "render": Lino.quicktip_renderer("Nur aktive Klienten","(integ.Clients.only_active) Show only clients in 'active' integration phases") }, "hideLabel": true, "checked": false, "name": "only_active", "selectOnFocus": true, "anchor": "-20" });
    var only_primary2741 = new Ext.form.Checkbox({ "boxLabel": "Nur prim\u00e4re Begleitungen", "listeners": { "render": Lino.quicktip_renderer("Nur prim\u00e4re Begleitungen","(integ.Clients.only_primary) Nur Klienten, die eine effektive <b>prim\u00e4re</b> Begleitung haben.") }, "hideLabel": true, "checked": false, "name": "only_primary", "selectOnFocus": true, "anchor": "-20" });
    var main_3_panel2742 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 25, "autoHeight": true, "layout": "form", "xtype": "panel", "items": language2737, "labelAlign": "top" }, { "flex": 25, "autoHeight": true, "layout": "form", "xtype": "panel", "items": wanted_property2738, "labelAlign": "top" }, { "flex": 25, "autoHeight": true, "layout": "form", "xtype": "panel", "items": group2739, "labelAlign": "top" }, { "flex": 12, "autoHeight": true, "layout": "form", "xtype": "panel", "items": only_active2740, "labelAlign": "top" }, { "flex": 12, "autoHeight": true, "layout": "form", "xtype": "panel", "items": only_primary2741, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 225, "border": false, "anchor": "-20", "labelAlign": "top" });
    this.items = [ main_1_panel2719, main_2_panel2731, main_3_panel2742 ];
    this.fields = [ client_state2713, coached_by2714, and_coached_by2715, start_date2716, end_date2717, observed_event2718, aged_from2726, aged_to2727, gender2728, nationality2729, also_obsolete2730, language2737, wanted_property2738, group2739, only_active2740, only_primary2741 ];
    Lino.integ.Clients.ParamsPanel.superclass.initComponent.call(this);
  }
});


Lino.cal.Tasks.ParamsPanel = Ext.extend(Ext.form.FormPanel,{
  autoScroll: false,
  border: false,
  layout: "fit",
  hideCheckBoxLabels: true,
  frame: true,
  bodyBorder: false,
  labelAlign: "top",
  initComponent : function() {
    var containing_panel = this;
    var start_date135 = new Lino.DateField({ "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Periode vom","(cal.Tasks.start_date) Start date of observed period") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Periode vom</span>", "anchor": "-20", "name": "start_date" });
    var end_date136 = new Lino.DateField({ "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("bis","(cal.Tasks.end_date) End date of observed period") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">bis</span>", "anchor": "-20", "name": "end_date" });
    var user137 = new Lino.TwinCombo({ "preferred_width": 15, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Verwaltet durch</span>", "name": "user", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.users.Users.detail)}, "hiddenName": "userHidden", "listeners": { "render": Lino.quicktip_renderer("Verwaltet durch","(cal.Tasks.user) Only rows managed by this user.") }, "selectOnFocus": true, "emptyText": "Benutzer ausw\u00e4hlen...", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/Tasks/user", "method": "GET" }) }) });
    var state138 = new Lino.ChoicesFieldElement({ "forceSelection": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Zustand</span>", "name": "state", "hiddenName": "stateHidden", "listeners": { "render": Lino.quicktip_renderer("Zustand","(cal.Tasks.state) Only rows having this state.") }, "selectOnFocus": true, "anchor": "-20", "store": [['','<br>']].concat(Lino.cal.TaskStates) });
    var project139 = new Lino.TwinCombo({ "preferred_width": 20, "fieldLabel": "Klient", "name": "project", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.pcsw.Clients.detail)}, "hiddenName": "projectHidden", "listeners": { "render": Lino.quicktip_renderer("Klient","(cal.Tasks.project) ") }, "selectOnFocus": true, "emptyText": "Klient ausw\u00e4hlen...", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/Tasks/project", "method": "GET" }) }) });
    var main_1_panel140 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 144, "hideCheckBoxLabels": true, "items": [ { "flex": 11, "autoHeight": true, "layout": "form", "xtype": "panel", "items": start_date135, "labelAlign": "top" }, { "flex": 11, "autoHeight": true, "layout": "form", "xtype": "panel", "items": end_date136, "labelAlign": "top" }, { "flex": 29, "autoHeight": true, "layout": "form", "xtype": "panel", "items": user137, "labelAlign": "top" }, { "flex": 17, "autoHeight": true, "layout": "form", "xtype": "panel", "items": state138, "labelAlign": "top" }, { "flex": 29, "autoHeight": true, "layout": "form", "xtype": "panel", "items": project139, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    this.items = [ main_1_panel140 ];
    this.fields = [ start_date135, end_date136, user137, state138, project139 ];
    Lino.cal.Tasks.ParamsPanel.superclass.initComponent.call(this);
  }
});


Lino.jobs.Contracts.ParamsPanel = Ext.extend(Ext.form.FormPanel,{
  autoScroll: false,
  autoHeight: true,
  border: false,
  layout: "form",
  hideCheckBoxLabels: true,
  frame: true,
  bodyBorder: false,
  labelAlign: "top",
  initComponent : function() {
    var containing_panel = this;
    var user1452 = new Lino.TwinCombo({ "preferred_width": 15, "fieldLabel": "Benutzer", "name": "user", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.users.Users.detail)}, "hiddenName": "userHidden", "listeners": { "render": Lino.quicktip_renderer("Benutzer","(jobs.Contracts.user) ") }, "selectOnFocus": true, "emptyText": "Benutzer ausw\u00e4hlen...", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/jobs/Contracts/user", "method": "GET" }) }) });
    var type1453 = new Lino.TwinCombo({ "preferred_width": 20, "fieldLabel": "Vertragsart", "name": "type", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.jobs.ContractTypes.detail)}, "hiddenName": "typeHidden", "listeners": { "render": Lino.quicktip_renderer("Vertragsart","(jobs.Contracts.type) ") }, "selectOnFocus": true, "emptyText": "Art.60\u00a77-Konventionsart ausw\u00e4hlen...", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/jobs/Contracts/type", "method": "GET" }) }) });
    var start_date1454 = new Lino.DateField({ "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Periode vom","(jobs.Contracts.start_date) Start date of observed period") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Periode vom</span>", "anchor": "-20", "name": "start_date" });
    var end_date1455 = new Lino.DateField({ "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("bis","(jobs.Contracts.end_date) End date of observed period") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">bis</span>", "anchor": "-20", "name": "end_date" });
    var observed_event1456 = new Lino.ChoicesFieldElement({ "forceSelection": true, "fieldLabel": "Beobachtungskriterium", "name": "observed_event", "hiddenName": "observed_eventHidden", "listeners": { "render": Lino.quicktip_renderer("Beobachtungskriterium","(jobs.Contracts.observed_event) ") }, "selectOnFocus": true, "anchor": "-20", "store": [['','<br>']].concat(Lino.isip.ContractEvents) });
    var main_1_panel1457 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 30, "autoHeight": true, "layout": "form", "xtype": "panel", "items": user1452, "labelAlign": "top" }, { "flex": 30, "autoHeight": true, "layout": "form", "xtype": "panel", "items": type1453, "labelAlign": "top" }, { "flex": 12, "autoHeight": true, "layout": "form", "xtype": "panel", "items": start_date1454, "labelAlign": "top" }, { "flex": 12, "autoHeight": true, "layout": "form", "xtype": "panel", "items": end_date1455, "labelAlign": "top" }, { "flex": 15, "autoHeight": true, "layout": "form", "xtype": "panel", "items": observed_event1456, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 198, "border": false, "anchor": "-20", "labelAlign": "top" });
    var company1463 = new Lino.TwinCombo({ "preferred_width": 20, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Organisation</span>", "name": "company", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.contacts.Companies.detail)}, "hiddenName": "companyHidden", "listeners": { "render": Lino.quicktip_renderer("Organisation","(jobs.Contracts.company) Nur Konventionen mit dieser Organisation als Drittpartner.") }, "selectOnFocus": true, "emptyText": "Organisation ausw\u00e4hlen...", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/jobs/Contracts/company", "method": "GET" }) }) });
    var ending_success1464 = new Lino.ChoicesFieldElement({ "forceSelection": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Erfolgreich abgeschlossen</span>", "name": "ending_success", "hiddenName": "ending_successHidden", "listeners": { "render": Lino.quicktip_renderer("Erfolgreich abgeschlossen","(jobs.Contracts.ending_success) Contrats termin\u00e9s avec succ\u00e8s.") }, "selectOnFocus": true, "anchor": "-20", "store": [['','<br>']].concat(Lino.lino.YesNo) });
    var ending1465 = new Lino.TwinCombo({ "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Beendigungsgrund</span>", "name": "ending", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.isip.ContractEndings.detail)}, "emptyText": "Beendigungsgrund ausw\u00e4hlen...", "listeners": { "render": Lino.quicktip_renderer("Beendigungsgrund","(jobs.Contracts.ending) Nur Konventionen mit diesem Beendigungsgrund.") }, "selectOnFocus": true, "hiddenName": "endingHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/jobs/Contracts/ending", "method": "GET" }) }) });
    var main_2_panel1466 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 42, "autoHeight": true, "layout": "form", "xtype": "panel", "items": company1463, "labelAlign": "top" }, { "flex": 14, "autoHeight": true, "layout": "form", "xtype": "panel", "items": ending_success1464, "labelAlign": "top" }, { "flex": 42, "autoHeight": true, "layout": "form", "xtype": "panel", "items": ending1465, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 234, "border": false, "anchor": "-20", "labelAlign": "top" });
    this.items = [ main_1_panel1457, main_2_panel1466 ];
    this.fields = [ user1452, type1453, start_date1454, end_date1455, observed_event1456, company1463, ending_success1464, ending1465 ];
    Lino.jobs.Contracts.ParamsPanel.superclass.initComponent.call(this);
  }
});


Lino.pcsw.CoachingsByClient.create_visit_ActionFormPanel = Ext.extend(Lino.ActionFormPanel,{
  autoScroll: false,
  autoHeight: true,
  border: false,
  layout: "form",
  labelWidth: 63,
  hideCheckBoxLabels: true,
  frame: true,
  bodyBorder: false,
  labelAlign: "top",
  action_name: 'create_visit',
  ls_url: "/pcsw/CoachingsByClient",
  window_title: "Visite erstellen",
  autoHeight: true,
  initComponent : function() {
    var containing_panel = this;
    var user48 = new Lino.TwinCombo({ "preferred_width": 15, "fieldLabel": "Benutzer", "allowBlank": false, "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.users.Users.detail)}, "emptyText": "Benutzer ausw\u00e4hlen...", "listeners": { "render": Lino.quicktip_renderer("User","(<CreateCoachingVisit create_visit (u'Create visit')>.user) ") }, "selectOnFocus": true, "hiddenName": "userHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/apchoices/pcsw/Coachings/create_visit/user", "method": "GET" }) }), "name": "user" });
    var summary49 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Reason","(<CreateCoachingVisit create_visit (u'Create visit')>.summary) ") }, "fieldLabel": "Begr\u00fcndung", "name": "summary", "maxLength": null, "selectOnFocus": true, "anchor": "-20" });
    this.items = [ { "autoHeight": true, "layout": "form", "xtype": "panel", "items": user48, "anchor": "-20", "labelAlign": "top" }, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": summary49, "anchor": "-20", "labelAlign": "top" } ];
    this.fields = [ user48, summary49 ];
    Lino.pcsw.CoachingsByClient.create_visit_ActionFormPanel.superclass.initComponent.call(this);
  }
});


Lino.pcsw.Clients.wf1_ActionFormPanel = Ext.extend(Lino.ActionFormPanel,{
  autoScroll: false,
  border: false,
  layout: "vbox",
  labelWidth: 63,
  hideCheckBoxLabels: true,
  frame: true,
  layoutConfig: { "align": "stretch" },
  bodyBorder: false,
  labelAlign: "top",
  action_name: 'wf1',
  ls_url: "/pcsw/Clients",
  window_title: "Ablehnen",
  initComponent : function() {
    var containing_panel = this;
    var reason27 = new Lino.ChoicesFieldElement({ "forceSelection": true, "fieldLabel": "reason", "allowBlank": false, "hiddenName": "reasonHidden", "listeners": { "render": Lino.quicktip_renderer("reason","(<RefuseClient wf1 (u'Refuse')>.reason) ") }, "selectOnFocus": true, "anchor": "-20", "store": Lino.pcsw.RefusalReasons, "name": "reason" });
    var remark28 = new Ext.form.TextArea({ "listeners": { "render": Lino.quicktip_renderer("Remark","(<RefuseClient wf1 (u'Refuse')>.remark) ") }, "fieldLabel": "Bemerkung", "name": "remark", "growMax": 2000, "selectOnFocus": true, "anchor": "-20 -10" });
    this.items = [ { "items": reason27, "autoHeight": true, "layout": "form", "xtype": "panel", "labelAlign": "top" }, { "items": remark28, "labelAlign": "top", "layout": "form", "xtype": "panel", "flex": 83 } ];
    this.fields = [ reason27, remark28 ];
    Lino.pcsw.Clients.wf1_ActionFormPanel.superclass.initComponent.call(this);
  }
});


Lino.cal.MyPresences.wf1_ActionFormPanel = Ext.extend(Lino.ActionFormPanel,{
  autoScroll: false,
  border: false,
  layout: "vbox",
  labelWidth: 270,
  hideCheckBoxLabels: true,
  frame: true,
  layoutConfig: { "align": "stretch" },
  bodyBorder: false,
  labelAlign: "top",
  action_name: 'wf1',
  ls_url: "/cal/MyPresences",
  window_title: "Zusagen",
  initComponent : function() {
    var containing_panel = this;
    var notify_subject6 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Summary","(<AcceptInvitation wf1 (u'Accept')>.notify_subject) ") }, "fieldLabel": "Kurzbeschreibung", "name": "notify_subject", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var notify_body7 = new Ext.form.TextArea({ "listeners": { "render": Lino.quicktip_renderer("Description","(<AcceptInvitation wf1 (u'Accept')>.notify_body) ") }, "fieldLabel": "Beschreibung", "name": "notify_body", "growMax": 2000, "selectOnFocus": true, "anchor": "-20 -10" });
    var notify_silent8 = new Ext.form.Checkbox({ "boxLabel": "Keine Benachrichtigung per E-Mail schicken", "listeners": { "render": Lino.quicktip_renderer("Don't send email notification","(<AcceptInvitation wf1 (u'Accept')>.notify_silent) ") }, "hideLabel": true, "checked": false, "name": "notify_silent", "selectOnFocus": true, "anchor": "-20" });
    this.items = [ { "items": notify_subject6, "autoHeight": true, "layout": "form", "xtype": "panel", "labelAlign": "top" }, { "items": notify_body7, "labelAlign": "top", "layout": "form", "xtype": "panel", "flex": 71 }, { "items": notify_silent8, "autoHeight": true, "layout": "form", "xtype": "panel", "labelAlign": "top" } ];
    this.fields = [ notify_subject6, notify_body7, notify_silent8 ];
    Lino.cal.MyPresences.wf1_ActionFormPanel.superclass.initComponent.call(this);
  }
});


Lino.cal.MyPresences.checkin_ActionFormPanel = Ext.extend(Lino.ActionFormPanel,{
  autoScroll: false,
  border: false,
  layout: "vbox",
  labelWidth: 270,
  hideCheckBoxLabels: true,
  frame: true,
  layoutConfig: { "align": "stretch" },
  bodyBorder: false,
  labelAlign: "top",
  action_name: 'checkin',
  ls_url: "/cal/MyPresences",
  window_title: "Einchecken",
  initComponent : function() {
    var containing_panel = this;
    var notify_subject20 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Summary","(<CheckinGuest checkin (u'Checkin')>.notify_subject) ") }, "fieldLabel": "Kurzbeschreibung", "name": "notify_subject", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var notify_body21 = new Ext.form.TextArea({ "listeners": { "render": Lino.quicktip_renderer("Description","(<CheckinGuest checkin (u'Checkin')>.notify_body) ") }, "fieldLabel": "Beschreibung", "name": "notify_body", "growMax": 2000, "selectOnFocus": true, "anchor": "-20 -10" });
    var notify_silent22 = new Ext.form.Checkbox({ "boxLabel": "Keine Benachrichtigung per E-Mail schicken", "listeners": { "render": Lino.quicktip_renderer("Don't send email notification","(<CheckinGuest checkin (u'Checkin')>.notify_silent) ") }, "hideLabel": true, "checked": false, "name": "notify_silent", "selectOnFocus": true, "anchor": "-20" });
    this.items = [ { "items": notify_subject20, "autoHeight": true, "layout": "form", "xtype": "panel", "labelAlign": "top" }, { "items": notify_body21, "labelAlign": "top", "layout": "form", "xtype": "panel", "flex": 71 }, { "items": notify_silent22, "autoHeight": true, "layout": "form", "xtype": "panel", "labelAlign": "top" } ];
    this.fields = [ notify_subject20, notify_body21, notify_silent22 ];
    Lino.cal.MyPresences.checkin_ActionFormPanel.superclass.initComponent.call(this);
  }
});


Lino.cal.MyPresences.wf2_ActionFormPanel = Ext.extend(Lino.ActionFormPanel,{
  autoScroll: false,
  border: false,
  layout: "vbox",
  labelWidth: 270,
  hideCheckBoxLabels: true,
  frame: true,
  layoutConfig: { "align": "stretch" },
  bodyBorder: false,
  labelAlign: "top",
  action_name: 'wf2',
  ls_url: "/cal/MyPresences",
  window_title: "Absagen",
  initComponent : function() {
    var containing_panel = this;
    var notify_subject13 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Summary","(<RejectInvitation wf2 (u'Reject')>.notify_subject) ") }, "fieldLabel": "Kurzbeschreibung", "name": "notify_subject", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var notify_body14 = new Ext.form.TextArea({ "listeners": { "render": Lino.quicktip_renderer("Description","(<RejectInvitation wf2 (u'Reject')>.notify_body) ") }, "fieldLabel": "Beschreibung", "name": "notify_body", "growMax": 2000, "selectOnFocus": true, "anchor": "-20 -10" });
    var notify_silent15 = new Ext.form.Checkbox({ "boxLabel": "Keine Benachrichtigung per E-Mail schicken", "listeners": { "render": Lino.quicktip_renderer("Don't send email notification","(<RejectInvitation wf2 (u'Reject')>.notify_silent) ") }, "hideLabel": true, "checked": false, "name": "notify_silent", "selectOnFocus": true, "anchor": "-20" });
    this.items = [ { "items": notify_subject13, "autoHeight": true, "layout": "form", "xtype": "panel", "labelAlign": "top" }, { "items": notify_body14, "labelAlign": "top", "layout": "form", "xtype": "panel", "flex": 71 }, { "items": notify_silent15, "autoHeight": true, "layout": "form", "xtype": "panel", "labelAlign": "top" } ];
    this.fields = [ notify_subject13, notify_body14, notify_silent15 ];
    Lino.cal.MyPresences.wf2_ActionFormPanel.superclass.initComponent.call(this);
  }
});


Lino.contacts.Companies.merge_row_ActionFormPanel = Ext.extend(Lino.ActionFormPanel,{
  autoScroll: false,
  autoHeight: true,
  border: false,
  layout: "form",
  labelWidth: 72,
  hideCheckBoxLabels: true,
  frame: true,
  bodyBorder: false,
  labelAlign: "top",
  action_name: 'merge_row',
  ls_url: "/contacts/Companies",
  window_title: "Merge",
  autoHeight: true,
  initComponent : function() {
    var containing_panel = this;
    var merge_to1 = new Lino.TwinCombo({ "preferred_width": 20, "fieldLabel": "into...", "allowBlank": false, "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.contacts.Companies.detail)}, "emptyText": "Organisation ausw\u00e4hlen...", "listeners": { "render": Lino.quicktip_renderer("into...","(<MergeAction merge_row (u'Merge')>.merge_to) ") }, "selectOnFocus": true, "hiddenName": "merge_toHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/apchoices/contacts/Companies/merge_row/merge_to", "method": "GET" }) }), "name": "merge_to" });
    var reason2 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Reason","(<MergeAction merge_row (u'Merge')>.reason) ") }, "fieldLabel": "Reason", "name": "reason", "maxLength": 100, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    this.items = [ { "autoHeight": true, "layout": "form", "xtype": "panel", "items": merge_to1, "anchor": "-20", "labelAlign": "top" }, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": reason2, "anchor": "-20", "labelAlign": "top" } ];
    this.fields = [ merge_to1, reason2 ];
    Lino.contacts.Companies.merge_row_ActionFormPanel.superclass.initComponent.call(this);
  }
});


Lino.pcsw.Clients.merge_row_ActionFormPanel = Ext.extend(Lino.ActionFormPanel,{
  autoScroll: false,
  autoHeight: true,
  border: false,
  layout: "form",
  labelWidth: 72,
  hideCheckBoxLabels: true,
  frame: true,
  bodyBorder: false,
  labelAlign: "top",
  action_name: 'merge_row',
  ls_url: "/pcsw/Clients",
  window_title: "Merge",
  autoHeight: true,
  initComponent : function() {
    var containing_panel = this;
    var merge_to32 = new Lino.TwinCombo({ "preferred_width": 20, "fieldLabel": "into...", "allowBlank": false, "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.pcsw.Clients.detail)}, "emptyText": "Klient ausw\u00e4hlen...", "listeners": { "render": Lino.quicktip_renderer("into...","(<MergeAction merge_row (u'Merge')>.merge_to) ") }, "selectOnFocus": true, "hiddenName": "merge_toHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/apchoices/pcsw/Clients/merge_row/merge_to", "method": "GET" }) }), "name": "merge_to" });
    var pcsw_Dispense33 = new Ext.form.Checkbox({ "boxLabel": "Dispenzen", "listeners": { "render": Lino.quicktip_renderer("Dispenses","(<MergeAction merge_row (u'Merge')>.pcsw_Dispense) ") }, "hideLabel": true, "checked": false, "name": "pcsw_Dispense", "selectOnFocus": true, "anchor": "-20" });
    var pcsw_Coaching34 = new Ext.form.Checkbox({ "boxLabel": "Begleitungen", "listeners": { "render": Lino.quicktip_renderer("Coachings","(<MergeAction merge_row (u'Merge')>.pcsw_Coaching) ") }, "hideLabel": true, "checked": false, "name": "pcsw_Coaching", "selectOnFocus": true, "anchor": "-20" });
    var keep_volatiles_1_panel35 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": pcsw_Dispense33, "labelAlign": "top" }, { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": pcsw_Coaching34, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 90, "border": false, "anchor": "-20", "labelAlign": "top" });
    var cv_LanguageKnowledge38 = new Ext.form.Checkbox({ "boxLabel": "Sprachkenntnisse", "listeners": { "render": Lino.quicktip_renderer("language knowledges","(<MergeAction merge_row (u'Merge')>.cv_LanguageKnowledge) ") }, "hideLabel": true, "checked": false, "name": "cv_LanguageKnowledge", "selectOnFocus": true, "anchor": "-20" });
    var properties_PersonProperty39 = new Ext.form.Checkbox({ "boxLabel": "Eigenschaften", "listeners": { "render": Lino.quicktip_renderer("Properties","(<MergeAction merge_row (u'Merge')>.properties_PersonProperty) ") }, "hideLabel": true, "checked": false, "name": "properties_PersonProperty", "selectOnFocus": true, "anchor": "-20" });
    var keep_volatiles_2_panel40 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": cv_LanguageKnowledge38, "labelAlign": "top" }, { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": properties_PersonProperty39, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 180, "border": false, "anchor": "-20", "labelAlign": "top" });
    var keep_volatiles_panel43 = new Ext.form.FieldSet({ "autoHeight": true, "layout": "form", "title": "Also reassign volatile related objects", "items": [ keep_volatiles_1_panel35, keep_volatiles_2_panel40 ], "frame": true, "bodyBorder": false, "autoScroll": false, "hideCheckBoxLabels": true, "border": false, "anchor": "-20", "labelAlign": "top" });
    var reason44 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Reason","(<MergeAction merge_row (u'Merge')>.reason) ") }, "fieldLabel": "Reason", "name": "reason", "maxLength": 100, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    this.items = [ { "autoHeight": true, "layout": "form", "xtype": "panel", "items": merge_to32, "anchor": "-20", "labelAlign": "top" }, keep_volatiles_panel43, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": reason44, "anchor": "-20", "labelAlign": "top" } ];
    this.fields = [ merge_to32, pcsw_Dispense33, pcsw_Coaching34, cv_LanguageKnowledge38, properties_PersonProperty39, reason44 ];
    Lino.pcsw.Clients.merge_row_ActionFormPanel.superclass.initComponent.call(this);
  }
});


Lino.isip.ContractTypes.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 60,
  initComponent : function() {
    var containing_panel = this;
    var id1253 = new Ext.form.NumberField({ "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("ID","(isip.ContractTypes.id) ") }, "fieldLabel": "ID", "anchor": "-20", "name": "id" });
    var name1254 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Bezeichnung","(isip.ContractTypes.name) ") }, "fieldLabel": "Bezeichnung", "name": "name", "maxLength": 200, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var name_fr1255 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Bezeichnung (fr)","(isip.ContractTypes.name_fr) ") }, "fieldLabel": "Bezeichnung (fr)", "name": "name_fr", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var name_de1256 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Bezeichnung (de)","(isip.ContractTypes.name_de) ") }, "fieldLabel": "Bezeichnung (de)", "name": "name_de", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var name_nl1257 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Bezeichnung (nl)","(isip.ContractTypes.name_nl) ") }, "fieldLabel": "Bezeichnung (nl)", "name": "name_nl", "maxLength": 200, "selectOnFocus": true, "hidden": true, "anchor": "-20" });
    var main_1_panel1258 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 153, "hideCheckBoxLabels": true, "items": [ { "flex": 5, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id1253, "labelAlign": "top" }, { "flex": 23, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name1254, "labelAlign": "top" }, { "flex": 23, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_fr1255, "labelAlign": "top" }, { "flex": 23, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_de1256, "labelAlign": "top" }, { "flex": 23, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_nl1257, "hidden": true, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var ref1264 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Referenz","(isip.ContractTypes.ref) ") }, "fieldLabel": "Referenz", "name": "ref", "maxLength": 20, "selectOnFocus": true, "anchor": "-20" });
    var build_method1265 = new Lino.ChoicesFieldElement({ "listeners": { "render": Lino.quicktip_renderer("Konstruktionsmethode","(isip.ContractTypes.build_method) ") }, "fieldLabel": "Konstruktionsmethode", "name": "build_method", "selectOnFocus": true, "anchor": "-20", "store": [ [ "appyodt", "AppyOdtBuildMethod" ], [ "appypdf", "AppyPdfBuildMethod" ], [ "appyrtf", "AppyRtfBuildMethod" ], [ "latex", "LatexBuildMethod" ], [ "pisa", "PisaBuildMethod" ], [ "rtf", "RtfBuildMethod" ] ], "hiddenName": "build_methodHidden" });
    var template1266 = new Lino.SimpleRemoteComboFieldElement({ "listeners": { "render": Lino.quicktip_renderer("Vorlage","(isip.ContractTypes.template) ") }, "fieldLabel": "Vorlage", "name": "template", "selectOnFocus": true, "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/isip/ContractTypes/template", "method": "GET" }) }) });
    var exam_policy1267 = new Lino.TwinCombo({ "fieldLabel": "Auswertungsstrategie", "name": "exam_policy", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.isip.ExamPolicies.detail)}, "emptyText": "Auswertungsstrategie ausw\u00e4hlen...", "listeners": { "render": Lino.quicktip_renderer("Auswertungsstrategie","(isip.ContractTypes.exam_policy) ") }, "selectOnFocus": true, "hiddenName": "exam_policyHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/isip/ContractTypes/exam_policy", "method": "GET" }) }) });
    var needs_study_type1268 = new Ext.form.Checkbox({ "boxLabel": "erfordert Ausbildungsart ", "listeners": { "render": Lino.quicktip_renderer("erfordert Ausbildungsart ","(isip.ContractTypes.needs_study_type) ") }, "hideLabel": true, "checked": false, "name": "needs_study_type", "selectOnFocus": true, "anchor": "-20" });
    var main_2_panel1269 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 234, "hideCheckBoxLabels": true, "items": [ { "flex": 25, "autoHeight": true, "layout": "form", "xtype": "panel", "items": ref1264, "labelAlign": "top" }, { "flex": 24, "autoHeight": true, "layout": "form", "xtype": "panel", "items": build_method1265, "labelAlign": "top" }, { "flex": 12, "autoHeight": true, "layout": "form", "xtype": "panel", "items": template1266, "labelAlign": "top" }, { "flex": 24, "autoHeight": true, "layout": "form", "xtype": "panel", "items": exam_policy1267, "labelAlign": "top" }, { "flex": 12, "autoHeight": true, "layout": "form", "xtype": "panel", "items": needs_study_type1268, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var ContractsByType_grid1382 = new Lino.isip.ContractsByType.GridPanel({ "flex": 71, "hide_top_toolbar": true, "containing_panel": this, "params_panel_hidden": true, "master_panel": this, "preview_limit": 15, "listeners": { "render": Lino.quicktip_renderer("VSEs","(isip.isip.ContractsByType) ") }, "tools": [ Lino.show_in_own_window_button(Lino.isip.ContractsByType.grid) ] });
    var main_panel1383 = new Ext.Panel({ "autoScroll": false, "border": false, "layout": "vbox", "hideCheckBoxLabels": true, "items": [ main_1_panel1258, main_2_panel1269, ContractsByType_grid1382 ], "frame": true, "layoutConfig": { "align": "stretch" }, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel1383;
    this.before_row_edit = function(record) {
      template1266.setContextValue('build_method',record ? record.data['build_methodHidden'] : undefined);
      ContractsByType_grid1382.on_master_changed();
    }
    this.onRender = function(ct, position) {
      build_method1265.on('change',Lino.chooser_handler(template1266,'build_method'));
      Lino.isip.ContractTypes.DetailFormPanel.superclass.onRender.call(this, ct, position);
    }
    Lino.isip.ContractTypes.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.countries.Countries.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 11,
  initComponent : function() {
    var containing_panel = this;
    var isocode244 = new Ext.form.TextField({ "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">ISO-Code</span>", "name": "isocode", "boxMinWidth": Lino.chars2width(4), "listeners": { "render": Lino.quicktip_renderer("ISO-Code","(countries.Countries.isocode)         The two-letter code for this country as defined by ISO 3166-1. \n        For countries that no longer exist it may be a 4-letter code.") }, "maxLength": 4, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var name245 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Bezeichnung","(countries.Countries.name) ") }, "fieldLabel": "Bezeichnung", "name": "name", "maxLength": 200, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var name_fr246 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Bezeichnung (fr)","(countries.Countries.name_fr) ") }, "fieldLabel": "Bezeichnung (fr)", "name": "name_fr", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var name_de247 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Bezeichnung (de)","(countries.Countries.name_de) ") }, "fieldLabel": "Bezeichnung (de)", "name": "name_de", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var name_nl248 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Bezeichnung (nl)","(countries.Countries.name_nl) ") }, "fieldLabel": "Bezeichnung (nl)", "name": "name_nl", "maxLength": 200, "selectOnFocus": true, "hidden": true, "anchor": "-20" });
    var short_code249 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Short code","(countries.Countries.short_code) A short abbreviation for regional usage. Obsolete.") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Short code</span>", "name": "short_code", "maxLength": 4, "selectOnFocus": true, "boxMinWidth": Lino.chars2width(4), "anchor": "-20" });
    var inscode250 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("INS-Code","(countries.Countries.inscode) The official code for this country used by statbel.fgov.be") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">INS-Code</span>", "name": "inscode", "maxLength": 3, "selectOnFocus": true, "boxMinWidth": Lino.chars2width(3), "anchor": "-20" });
    var main_1_panel251 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 153, "hideCheckBoxLabels": true, "items": [ { "flex": 5, "autoHeight": true, "layout": "form", "xtype": "panel", "items": isocode244, "labelAlign": "top" }, { "flex": 21, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name245, "labelAlign": "top" }, { "flex": 21, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_fr246, "labelAlign": "top" }, { "flex": 21, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_de247, "labelAlign": "top" }, { "flex": 21, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_nl248, "hidden": true, "labelAlign": "top" }, { "flex": 5, "autoHeight": true, "layout": "form", "xtype": "panel", "items": short_code249, "labelAlign": "top" }, { "flex": 4, "autoHeight": true, "layout": "form", "xtype": "panel", "items": inscode250, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var countries_CitiesByCountry_grid589 = new Lino.countries.CitiesByCountry.GridPanel({ "flex": 50, "listeners": { "render": Lino.quicktip_renderer("Orte","(countries.countries.CitiesByCountry) ") }, "hide_top_toolbar": true, "containing_panel": this, "tools": [ Lino.show_in_own_window_button(Lino.countries.CitiesByCountry.grid) ], "preview_limit": 15, "master_panel": this });
    var jobs_StudiesByCountry_grid602 = new Lino.jobs.StudiesByCountry.GridPanel({ "flex": 50, "listeners": { "render": Lino.quicktip_renderer("Ausbildungen und Studien","(jobs.jobs.StudiesByCountry) ") }, "hide_top_toolbar": true, "containing_panel": this, "tools": [ Lino.show_in_own_window_button(Lino.jobs.StudiesByCountry.grid) ], "preview_limit": 15, "master_panel": this });
    var main_2_panel603 = new Ext.Panel({ "flex": 83, "border": false, "layout": "hbox", "hideCheckBoxLabels": true, "items": [ countries_CitiesByCountry_grid589, jobs_StudiesByCountry_grid602 ], "autoScroll": false, "layoutConfig": { "align": "stretch" }, "frame": false, "labelAlign": "top" });
    var main_panel604 = new Ext.Panel({ "autoScroll": false, "border": false, "layout": "vbox", "hideCheckBoxLabels": true, "items": [ main_1_panel251, main_2_panel603 ], "frame": true, "layoutConfig": { "align": "stretch" }, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel604;
    this.before_row_edit = function(record) {
      countries_CitiesByCountry_grid589.on_master_changed();
      jobs_StudiesByCountry_grid602.on_master_changed();
    }
    Lino.countries.Countries.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.jobs.Regimes.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 76,
  initComponent : function() {
    var containing_panel = this;
    var id1640 = new Ext.form.NumberField({ "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("ID","(jobs.Regimes.id) ") }, "fieldLabel": "ID", "anchor": "-20", "name": "id" });
    var name1641 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Bezeichnung","(jobs.Regimes.name) ") }, "fieldLabel": "Bezeichnung", "name": "name", "maxLength": 200, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var name_fr1642 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Bezeichnung (fr)","(jobs.Regimes.name_fr) ") }, "fieldLabel": "Bezeichnung (fr)", "name": "name_fr", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var name_de1643 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Bezeichnung (de)","(jobs.Regimes.name_de) ") }, "fieldLabel": "Bezeichnung (de)", "name": "name_de", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var name_nl1644 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Bezeichnung (nl)","(jobs.Regimes.name_nl) ") }, "fieldLabel": "Bezeichnung (nl)", "name": "name_nl", "maxLength": 200, "selectOnFocus": true, "hidden": true, "anchor": "-20" });
    var main_1_panel1645 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 153, "hideCheckBoxLabels": true, "items": [ { "flex": 5, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id1640, "labelAlign": "top" }, { "flex": 23, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name1641, "labelAlign": "top" }, { "flex": 23, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_fr1642, "labelAlign": "top" }, { "flex": 23, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_de1643, "labelAlign": "top" }, { "flex": 23, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_nl1644, "hidden": true, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var ContractsByRegime_grid1678 = new Lino.jobs.ContractsByRegime.GridPanel({ "flex": 83, "hide_top_toolbar": true, "containing_panel": this, "params_panel_hidden": true, "master_panel": this, "preview_limit": 15, "listeners": { "render": Lino.quicktip_renderer("Art.60\u00a77-Konventionen","(jobs.jobs.ContractsByRegime) ") }, "tools": [ Lino.show_in_own_window_button(Lino.jobs.ContractsByRegime.grid) ] });
    var main_panel1679 = new Ext.Panel({ "autoScroll": false, "border": false, "layout": "vbox", "hideCheckBoxLabels": true, "items": [ main_1_panel1645, ContractsByRegime_grid1678 ], "frame": true, "layoutConfig": { "align": "stretch" }, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel1679;
    this.before_row_edit = function(record) {
      ContractsByRegime_grid1678.on_master_changed();
    }
    Lino.jobs.Regimes.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.notes.MyNotes.InsertFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  autoHeight: true,
  content_type: 93,
  initComponent : function() {
    var containing_panel = this;
    var event_type778 = new Lino.TwinCombo({ "fieldLabel": "Ereignisart (Form)", "name": "event_type", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.notes.EventTypes.detail)}, "emptyText": "Event Type ausw\u00e4hlen...", "listeners": { "render": Lino.quicktip_renderer("Ereignisart (Form)","(notes.Notes.event_type) ") }, "selectOnFocus": true, "hiddenName": "event_typeHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/notes/Notes/event_type", "method": "GET" }) }) });
    var type779 = new Lino.TwinCombo({ "fieldLabel": "Notizart (Inhalt)", "name": "type", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.notes.NoteTypes.detail)}, "emptyText": "Notizart ausw\u00e4hlen...", "listeners": { "render": Lino.quicktip_renderer("Notizart (Inhalt)","(notes.Notes.type) ") }, "selectOnFocus": true, "hiddenName": "typeHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/notes/Notes/type", "method": "GET" }) }) });
    var main_1_panel780 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": event_type778, "labelAlign": "top" }, { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": type779, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 171, "border": false, "anchor": "-20", "labelAlign": "top" });
    var subject783 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Betreff","(notes.Notes.subject) ") }, "fieldLabel": "Betreff", "name": "subject", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var project784 = new Lino.TwinCombo({ "preferred_width": 20, "fieldLabel": "Klient", "name": "project", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.pcsw.Clients.detail)}, "hiddenName": "projectHidden", "listeners": { "render": Lino.quicktip_renderer("Klient","(notes.Notes.project) ") }, "selectOnFocus": true, "emptyText": "Klient ausw\u00e4hlen...", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/notes/Notes/project", "method": "GET" }) }) });
    var company785 = new Lino.TwinCombo({ "preferred_width": 20, "fieldLabel": "Empf\u00e4nger (Organisation)", "name": "company", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.contacts.Companies.detail)}, "hiddenName": "companyHidden", "listeners": { "render": Lino.quicktip_renderer("Empf\u00e4nger (Organisation)","(notes.Notes.company) ") }, "selectOnFocus": true, "emptyText": "Organisation ausw\u00e4hlen...", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/notes/Notes/company", "method": "GET" }) }) });
    var main_3_panel786 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": project784, "labelAlign": "top" }, { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": company785, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 225, "border": false, "anchor": "-20", "labelAlign": "top" });
    var main_panel789 = new Ext.Panel({ "hideCheckBoxLabels": true, "autoHeight": true, "border": false, "layout": "form", "labelWidth": 72, "autoScroll": false, "items": [ main_1_panel780, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": subject783, "anchor": "-20", "labelAlign": "top" }, main_3_panel786 ], "frame": true, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel789;
    this.before_row_edit = function(record) {
    }
    Lino.notes.MyNotes.InsertFormPanel.superclass.initComponent.call(this);
  }
});


Lino.jobs.Sectors.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 64,
  initComponent : function() {
    var containing_panel = this;
    var id1893 = new Ext.form.NumberField({ "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("ID","(jobs.Sectors.id) ") }, "fieldLabel": "ID", "anchor": "-20", "name": "id" });
    var name1894 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Bezeichnung","(jobs.Sectors.name) ") }, "fieldLabel": "Bezeichnung", "name": "name", "maxLength": 200, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var name_fr1895 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Bezeichnung (fr)","(jobs.Sectors.name_fr) ") }, "fieldLabel": "Bezeichnung (fr)", "name": "name_fr", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var name_de1896 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Bezeichnung (de)","(jobs.Sectors.name_de) ") }, "fieldLabel": "Bezeichnung (de)", "name": "name_de", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var name_nl1897 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Bezeichnung (nl)","(jobs.Sectors.name_nl) ") }, "fieldLabel": "Bezeichnung (nl)", "name": "name_nl", "maxLength": 200, "selectOnFocus": true, "hidden": true, "anchor": "-20" });
    var main_1_panel1898 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 5, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id1893, "labelAlign": "top" }, { "flex": 23, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name1894, "labelAlign": "top" }, { "flex": 23, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_fr1895, "labelAlign": "top" }, { "flex": 23, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_de1896, "labelAlign": "top" }, { "flex": 23, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_nl1897, "hidden": true, "labelAlign": "top" } ], "region": "north", "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "split": true, "autoScroll": false, "labelWidth": 153, "border": false, "frame": false, "labelAlign": "top" });
    var remark1904 = new Ext.form.TextArea({ "listeners": { "render": Lino.quicktip_renderer("Bemerkung","(jobs.Sectors.remark) ") }, "fieldLabel": "Bemerkung", "name": "remark", "growMax": 2000, "selectOnFocus": true, "anchor": "-20 -10" });
    var FunctionsBySector_grid1949 = new Lino.jobs.FunctionsBySector.GridPanel({ "flex": 66, "listeners": { "render": Lino.quicktip_renderer("Funktionen","(jobs.jobs.FunctionsBySector) ") }, "hide_top_toolbar": true, "containing_panel": this, "tools": [ Lino.show_in_own_window_button(Lino.jobs.FunctionsBySector.grid) ], "preview_limit": 15, "master_panel": this });
    var main_2_panel1950 = new Ext.Panel({ "flex": 5, "layout": "hbox", "items": [ { "items": remark1904, "labelAlign": "top", "layout": "form", "xtype": "panel", "flex": 33 }, FunctionsBySector_grid1949 ], "region": "center", "layoutConfig": { "align": "stretch" }, "hideCheckBoxLabels": true, "split": true, "autoScroll": false, "labelWidth": 90, "border": false, "frame": false, "labelAlign": "top" });
    var CandidaturesBySector_grid1960 = new Lino.jobs.CandidaturesBySector.GridPanel({ "flex": 5, "hide_top_toolbar": true, "containing_panel": this, "region": "south", "preview_limit": 15, "master_panel": this, "listeners": { "render": Lino.quicktip_renderer("Stellenanfragen","(jobs.jobs.CandidaturesBySector) ") }, "split": true, "tools": [ Lino.show_in_own_window_button(Lino.jobs.CandidaturesBySector.grid) ] });
    var main_panel1961 = new Lino.VBorderPanel({ "autoScroll": false, "border": false, "hideCheckBoxLabels": true, "items": [ main_1_panel1898, main_2_panel1950, CandidaturesBySector_grid1960 ], "frame": true, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel1961;
    this.before_row_edit = function(record) {
      FunctionsBySector_grid1949.on_master_changed();
      CandidaturesBySector_grid1960.on_master_changed();
    }
    Lino.jobs.Sectors.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.cbss.IdentifyPersonRequests.InsertFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  autoHeight: true,
  content_type: 92,
  initComponent : function() {
    var containing_panel = this;
    var person2804 = new Lino.TwinCombo({ "preferred_width": 20, "fieldLabel": "Klient", "allowBlank": false, "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.pcsw.Clients.detail)}, "emptyText": "Klient ausw\u00e4hlen...", "listeners": { "render": Lino.quicktip_renderer("Klient","(cbss.IdentifyPersonRequests.person) ") }, "selectOnFocus": true, "hiddenName": "personHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cbss/IdentifyPersonRequests/person", "method": "GET" }) }), "name": "person" });
    var national_id2805 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("NR-Nummer","(cbss.IdentifyPersonRequests.national_id) ") }, "fieldLabel": "NR-Nummer", "name": "national_id", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var main_1_panel2806 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 48, "autoHeight": true, "layout": "form", "xtype": "panel", "items": person2804, "labelAlign": "top" }, { "flex": 51, "autoHeight": true, "layout": "form", "xtype": "panel", "items": national_id2805, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 90, "border": false, "anchor": "-20", "labelAlign": "top" });
    var first_name2809 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Vorname","(cbss.IdentifyPersonRequests.first_name) ") }, "fieldLabel": "Vorname", "name": "first_name", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var middle_name2810 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Mittelnamen","(cbss.IdentifyPersonRequests.middle_name) Whatever this means...") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Mittelnamen</span>", "name": "middle_name", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var last_name2811 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Familienname","(cbss.IdentifyPersonRequests.last_name) ") }, "fieldLabel": "Familienname", "name": "last_name", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var p2_1_panel2812 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": first_name2809, "labelAlign": "top" }, { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": middle_name2810, "labelAlign": "top" }, { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": last_name2811, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 117, "border": false, "anchor": "-20", "labelAlign": "top" });
    var birth_date2816 = new Lino.IncompleteDateField({ "listeners": { "render": Lino.quicktip_renderer("Geburtsdatum","(cbss.IdentifyPersonRequests.birth_date) Uncomplete dates are allowed, e.g. \n\"00.00.1980\" means \"some day in 1980\", \n\"00.07.1980\" means \"in July 1980\"\nor \"23.07.0000\" means \"on a 23th of July\".") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Geburtsdatum</span>", "name": "birth_date", "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var tolerance2817 = new Ext.form.NumberField({ "listeners": { "render": Lino.quicktip_renderer("Toleranz","(cbss.IdentifyPersonRequests.tolerance) \n      Falls Monat oder Tag des Geburtsdatums unbekannt sind, \n      um wieviel Monate bzw. Tage die Suche nach unten/oben ausgeweitet wird.\n      G\u00fcltige Werte: 0 bis 10.\n      ") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Toleranz</span>", "name": "tolerance", "selectOnFocus": true, "anchor": "-20", "value": 0, "allowBlank": false });
    var gender2818 = new Lino.ChoicesFieldElement({ "forceSelection": true, "fieldLabel": "Geschlecht", "name": "gender", "hiddenName": "genderHidden", "listeners": { "render": Lino.quicktip_renderer("Geschlecht","(cbss.IdentifyPersonRequests.gender) ") }, "selectOnFocus": true, "anchor": "-20", "store": [['','<br>']].concat(Lino.lino.Genders) });
    var p2_2_panel2819 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 46, "autoHeight": true, "layout": "form", "xtype": "panel", "items": birth_date2816, "labelAlign": "top" }, { "flex": 19, "autoHeight": true, "layout": "form", "xtype": "panel", "items": tolerance2817, "labelAlign": "top" }, { "flex": 34, "autoHeight": true, "layout": "form", "xtype": "panel", "items": gender2818, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 117, "border": false, "anchor": "-20", "labelAlign": "top" });
    var p2_panel2823 = new Ext.form.FieldSet({ "autoHeight": true, "layout": "form", "title": "Phonetische Suche", "items": [ p2_1_panel2812, p2_2_panel2819 ], "frame": true, "bodyBorder": false, "autoScroll": false, "hideCheckBoxLabels": true, "border": false, "anchor": "-20", "labelAlign": "top" });
    var main_panel2824 = new Ext.Panel({ "hideCheckBoxLabels": true, "autoHeight": true, "border": false, "layout": "form", "autoScroll": false, "items": [ main_1_panel2806, p2_panel2823 ], "frame": true, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel2824;
    this.before_row_edit = function(record) {
    }
    Lino.cbss.IdentifyPersonRequests.InsertFormPanel.superclass.initComponent.call(this);
    // active_fields:
    person2804.on("change",function(){this.save()},this);
  }
});


Lino.jobs.Schedules.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 67,
  initComponent : function() {
    var containing_panel = this;
    var id1600 = new Ext.form.NumberField({ "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("ID","(jobs.Schedules.id) ") }, "fieldLabel": "ID", "anchor": "-20", "name": "id" });
    var name1601 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Bezeichnung","(jobs.Schedules.name) ") }, "fieldLabel": "Bezeichnung", "name": "name", "maxLength": 200, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var name_fr1602 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Bezeichnung (fr)","(jobs.Schedules.name_fr) ") }, "fieldLabel": "Bezeichnung (fr)", "name": "name_fr", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var name_de1603 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Bezeichnung (de)","(jobs.Schedules.name_de) ") }, "fieldLabel": "Bezeichnung (de)", "name": "name_de", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var name_nl1604 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Bezeichnung (nl)","(jobs.Schedules.name_nl) ") }, "fieldLabel": "Bezeichnung (nl)", "name": "name_nl", "maxLength": 200, "selectOnFocus": true, "hidden": true, "anchor": "-20" });
    var main_1_panel1605 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 153, "hideCheckBoxLabels": true, "items": [ { "flex": 5, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id1600, "labelAlign": "top" }, { "flex": 23, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name1601, "labelAlign": "top" }, { "flex": 23, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_fr1602, "labelAlign": "top" }, { "flex": 23, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_de1603, "labelAlign": "top" }, { "flex": 23, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_nl1604, "hidden": true, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var ContractsBySchedule_grid1638 = new Lino.jobs.ContractsBySchedule.GridPanel({ "flex": 83, "hide_top_toolbar": true, "containing_panel": this, "params_panel_hidden": true, "master_panel": this, "preview_limit": 15, "listeners": { "render": Lino.quicktip_renderer("Art.60\u00a77-Konventionen","(jobs.jobs.ContractsBySchedule) ") }, "tools": [ Lino.show_in_own_window_button(Lino.jobs.ContractsBySchedule.grid) ] });
    var main_panel1639 = new Ext.Panel({ "autoScroll": false, "border": false, "layout": "vbox", "hideCheckBoxLabels": true, "items": [ main_1_panel1605, ContractsBySchedule_grid1638 ], "frame": true, "layoutConfig": { "align": "stretch" }, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel1639;
    this.before_row_edit = function(record) {
      ContractsBySchedule_grid1638.on_master_changed();
    }
    Lino.jobs.Schedules.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.about.Models.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  disable_editing: true,
  initComponent : function() {
    var containing_panel = this;
    var app_disp3017 = new Ext.form.DisplayField({ "disabled": true, "listeners": { "render": Lino.quicktip_renderer("app_label","(about.Models.app) ") }, "fieldLabel": "app_label", "name": "app", "anchor": "-20", "value": "<br/>", "always_enabled": true });
    var name_disp3018 = new Ext.form.DisplayField({ "disabled": true, "listeners": { "render": Lino.quicktip_renderer("name","(about.Models.name) ") }, "fieldLabel": "name", "name": "name", "anchor": "-20", "value": "<br/>", "always_enabled": true });
    var docstring_disp3019 = new Ext.form.DisplayField({ "disabled": true, "listeners": { "render": Lino.quicktip_renderer("docstring","(about.Models.docstring) ") }, "fieldLabel": "docstring", "name": "docstring", "anchor": "-20", "value": "<br/>", "always_enabled": true });
    var rows3020 = new Ext.form.NumberField({ "disabled": true, "listeners": { "render": Lino.quicktip_renderer("Zeilen","(about.Models.rows) ") }, "fieldLabel": "Zeilen", "anchor": "-20", "name": "rows" });
    var main_1_panel3021 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 90, "hideCheckBoxLabels": true, "items": [ { "flex": 31, "autoHeight": true, "layout": "form", "xtype": "panel", "items": app_disp3017, "labelAlign": "top" }, { "flex": 31, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_disp3018, "labelAlign": "top" }, { "flex": 31, "autoHeight": true, "layout": "form", "xtype": "panel", "items": docstring_disp3019, "labelAlign": "top" }, { "flex": 5, "autoHeight": true, "layout": "form", "xtype": "panel", "items": rows3020, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var about_FieldsByModel_grid3030 = new Lino.about.FieldsByModel.GridPanel({ "flex": 62, "listeners": { "render": Lino.quicktip_renderer("Felder","(about.about.FieldsByModel) ") }, "hide_top_toolbar": true, "containing_panel": this, "tools": [ Lino.show_in_own_window_button(Lino.about.FieldsByModel.grid) ], "preview_limit": 15, "master_panel": this });
    var main_panel3031 = new Ext.Panel({ "autoScroll": false, "border": false, "layout": "vbox", "hideCheckBoxLabels": true, "items": [ main_1_panel3021, about_FieldsByModel_grid3030 ], "frame": true, "layoutConfig": { "align": "stretch" }, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel3031;
    this.before_row_edit = function(record) {
      about_FieldsByModel_grid3030.on_master_changed();
    }
    Lino.about.Models.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.system.MyTextFieldTemplates.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 2,
  initComponent : function() {
    var containing_panel = this;
    var id2957 = new Ext.form.NumberField({ "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("ID","(system.TextFieldTemplates.id) ") }, "fieldLabel": "ID", "anchor": "-20", "name": "id" });
    var name2958 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Bezeichnung","(system.TextFieldTemplates.name) ") }, "fieldLabel": "Bezeichnung", "name": "name", "maxLength": 200, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var user2959 = new Lino.TwinCombo({ "preferred_width": 15, "fieldLabel": "Autor", "name": "user", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.users.Users.detail)}, "hiddenName": "userHidden", "listeners": { "render": Lino.quicktip_renderer("Autor","(system.TextFieldTemplates.user) ") }, "selectOnFocus": true, "emptyText": "Benutzer ausw\u00e4hlen...", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/system/TextFieldTemplates/user", "method": "GET" }) }) });
    var team2960 = new Lino.RemoteComboFieldElement({ "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Team</span>", "name": "team", "pageSize": 20, "emptyText": "Team ausw\u00e4hlen...", "listeners": { "render": Lino.quicktip_renderer("Team","(system.TextFieldTemplates.team) If not empty, then this template is reserved to members of this team.") }, "selectOnFocus": true, "hiddenName": "teamHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/system/TextFieldTemplates/team", "method": "GET" }) }) });
    var main_1_panel2961 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 7, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id2957, "labelAlign": "top" }, { "flex": 31, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name2958, "labelAlign": "top" }, { "flex": 30, "autoHeight": true, "layout": "form", "xtype": "panel", "items": user2959, "labelAlign": "top" }, { "flex": 30, "autoHeight": true, "layout": "form", "xtype": "panel", "items": team2960, "labelAlign": "top" } ], "region": "north", "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "split": true, "autoScroll": false, "labelWidth": 108, "border": false, "frame": false, "labelAlign": "top" });
    var description2966 = new Ext.form.TextArea({ "listeners": { "render": Lino.quicktip_renderer("Beschreibung","(system.TextFieldTemplates.description) ") }, "fieldLabel": "Beschreibung", "name": "description", "growMax": 2000, "selectOnFocus": true, "anchor": "-20 -10" });
    var text2967 = new Lino.RichTextPanel({ "flex": 5, "split": true, "containing_panel": this, "selectOnFocus": true, "region": "south", "title": "Vorlagentext", "name": "text" });
    var main_panel2968 = new Lino.VBorderPanel({ "autoScroll": false, "border": false, "labelWidth": 117, "hideCheckBoxLabels": true, "items": [ main_1_panel2961, { "flex": 5, "layout": "form", "xtype": "panel", "items": description2966, "region": "center", "labelAlign": "top", "split": true }, text2967 ], "frame": true, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel2968;
    this.before_row_edit = function(record) {
      text2967.refresh();
    }
    Lino.system.MyTextFieldTemplates.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.jobs.ContractTypes.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 73,
  initComponent : function() {
    var containing_panel = this;
    var id1845 = new Ext.form.NumberField({ "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("ID","(jobs.ContractTypes.id) ") }, "fieldLabel": "ID", "anchor": "-20", "name": "id" });
    var name1846 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Bezeichnung","(jobs.ContractTypes.name) ") }, "fieldLabel": "Bezeichnung", "name": "name", "maxLength": 200, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var name_fr1847 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Bezeichnung (fr)","(jobs.ContractTypes.name_fr) ") }, "fieldLabel": "Bezeichnung (fr)", "name": "name_fr", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var name_de1848 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Bezeichnung (de)","(jobs.ContractTypes.name_de) ") }, "fieldLabel": "Bezeichnung (de)", "name": "name_de", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var name_nl1849 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Bezeichnung (nl)","(jobs.ContractTypes.name_nl) ") }, "fieldLabel": "Bezeichnung (nl)", "name": "name_nl", "maxLength": 200, "selectOnFocus": true, "hidden": true, "anchor": "-20" });
    var main_1_panel1850 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 153, "hideCheckBoxLabels": true, "items": [ { "flex": 5, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id1845, "labelAlign": "top" }, { "flex": 23, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name1846, "labelAlign": "top" }, { "flex": 23, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_fr1847, "labelAlign": "top" }, { "flex": 23, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_de1848, "labelAlign": "top" }, { "flex": 23, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_nl1849, "hidden": true, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var ref1856 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Referenz","(jobs.ContractTypes.ref) ") }, "fieldLabel": "Referenz", "name": "ref", "maxLength": 20, "selectOnFocus": true, "anchor": "-20" });
    var build_method1857 = new Lino.ChoicesFieldElement({ "listeners": { "render": Lino.quicktip_renderer("Konstruktionsmethode","(jobs.ContractTypes.build_method) ") }, "fieldLabel": "Konstruktionsmethode", "name": "build_method", "selectOnFocus": true, "anchor": "-20", "store": [ [ "appyodt", "AppyOdtBuildMethod" ], [ "appypdf", "AppyPdfBuildMethod" ], [ "appyrtf", "AppyRtfBuildMethod" ], [ "latex", "LatexBuildMethod" ], [ "pisa", "PisaBuildMethod" ], [ "rtf", "RtfBuildMethod" ] ], "hiddenName": "build_methodHidden" });
    var template1858 = new Lino.SimpleRemoteComboFieldElement({ "listeners": { "render": Lino.quicktip_renderer("Vorlage","(jobs.ContractTypes.template) ") }, "fieldLabel": "Vorlage", "name": "template", "selectOnFocus": true, "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/jobs/ContractTypes/template", "method": "GET" }) }) });
    var main_2_panel1859 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 189, "hideCheckBoxLabels": true, "items": [ { "flex": 41, "autoHeight": true, "layout": "form", "xtype": "panel", "items": ref1856, "labelAlign": "top" }, { "flex": 39, "autoHeight": true, "layout": "form", "xtype": "panel", "items": build_method1857, "labelAlign": "top" }, { "flex": 19, "autoHeight": true, "layout": "form", "xtype": "panel", "items": template1858, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var ContractsByType_grid1891 = new Lino.jobs.ContractsByType.GridPanel({ "flex": 71, "hide_top_toolbar": true, "containing_panel": this, "params_panel_hidden": true, "master_panel": this, "preview_limit": 15, "listeners": { "render": Lino.quicktip_renderer("Art.60\u00a77-Konventionen","(jobs.jobs.ContractsByType) ") }, "tools": [ Lino.show_in_own_window_button(Lino.jobs.ContractsByType.grid) ] });
    var main_panel1892 = new Ext.Panel({ "autoScroll": false, "border": false, "layout": "vbox", "hideCheckBoxLabels": true, "items": [ main_1_panel1850, main_2_panel1859, ContractsByType_grid1891 ], "frame": true, "layoutConfig": { "align": "stretch" }, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel1892;
    this.before_row_edit = function(record) {
      template1858.setContextValue('build_method',record ? record.data['build_methodHidden'] : undefined);
      ContractsByType_grid1891.on_master_changed();
    }
    this.onRender = function(ct, position) {
      build_method1857.on('change',Lino.chooser_handler(template1858,'build_method'));
      Lino.jobs.ContractTypes.DetailFormPanel.superclass.onRender.call(this, ct, position);
    }
    Lino.jobs.ContractTypes.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.jobs.Functions.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 65,
  initComponent : function() {
    var containing_panel = this;
    var id1913 = new Ext.form.NumberField({ "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("ID","(jobs.Functions.id) ") }, "fieldLabel": "ID", "anchor": "-20", "name": "id" });
    var name1914 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Bezeichnung","(jobs.Functions.name) ") }, "fieldLabel": "Bezeichnung", "name": "name", "maxLength": 200, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var name_fr1915 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Bezeichnung (fr)","(jobs.Functions.name_fr) ") }, "fieldLabel": "Bezeichnung (fr)", "name": "name_fr", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var name_de1916 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Bezeichnung (de)","(jobs.Functions.name_de) ") }, "fieldLabel": "Bezeichnung (de)", "name": "name_de", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var name_nl1917 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Bezeichnung (nl)","(jobs.Functions.name_nl) ") }, "fieldLabel": "Bezeichnung (nl)", "name": "name_nl", "maxLength": 200, "selectOnFocus": true, "hidden": true, "anchor": "-20" });
    var sector1918 = new Lino.TwinCombo({ "fieldLabel": "Sektor", "allowBlank": false, "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.jobs.Sectors.detail)}, "emptyText": "Sektor ausw\u00e4hlen...", "listeners": { "render": Lino.quicktip_renderer("Sektor","(jobs.Functions.sector) ") }, "selectOnFocus": true, "hiddenName": "sectorHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/jobs/Functions/sector", "method": "GET" }) }), "name": "sector" });
    var main_1_panel1919 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 153, "hideCheckBoxLabels": true, "items": [ { "flex": 4, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id1913, "labelAlign": "top" }, { "flex": 19, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name1914, "labelAlign": "top" }, { "flex": 19, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_fr1915, "labelAlign": "top" }, { "flex": 19, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_de1916, "labelAlign": "top" }, { "flex": 19, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_nl1917, "hidden": true, "labelAlign": "top" }, { "flex": 18, "autoHeight": true, "layout": "form", "xtype": "panel", "items": sector1918, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var remark1926 = new Ext.form.TextArea({ "listeners": { "render": Lino.quicktip_renderer("Bemerkung","(jobs.Functions.remark) ") }, "fieldLabel": "Bemerkung", "name": "remark", "growMax": 2000, "selectOnFocus": true, "anchor": "-20 -10" });
    var CandidaturesByFunction_grid1935 = new Lino.jobs.CandidaturesByFunction.GridPanel({ "flex": 31, "listeners": { "render": Lino.quicktip_renderer("Stellenanfragen","(jobs.jobs.CandidaturesByFunction) ") }, "hide_top_toolbar": true, "containing_panel": this, "tools": [ Lino.show_in_own_window_button(Lino.jobs.CandidaturesByFunction.grid) ], "preview_limit": 15, "master_panel": this });
    var ExperiencesByFunction_grid1946 = new Lino.jobs.ExperiencesByFunction.GridPanel({ "flex": 31, "listeners": { "render": Lino.quicktip_renderer("Berufserfahrungen","(jobs.jobs.ExperiencesByFunction) ") }, "hide_top_toolbar": true, "containing_panel": this, "tools": [ Lino.show_in_own_window_button(Lino.jobs.ExperiencesByFunction.grid) ], "preview_limit": 15, "master_panel": this });
    var main_panel1947 = new Ext.Panel({ "autoScroll": false, "border": false, "layout": "vbox", "labelWidth": 90, "hideCheckBoxLabels": true, "items": [ main_1_panel1919, { "items": remark1926, "labelAlign": "top", "layout": "form", "xtype": "panel", "flex": 31 }, CandidaturesByFunction_grid1935, ExperiencesByFunction_grid1946 ], "frame": true, "layoutConfig": { "align": "stretch" }, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel1947;
    this.before_row_edit = function(record) {
      CandidaturesByFunction_grid1935.on_master_changed();
      ExperiencesByFunction_grid1946.on_master_changed();
    }
    Lino.jobs.Functions.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.pcsw.CoachingEndings.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 45,
  initComponent : function() {
    var containing_panel = this;
    var id2501 = new Ext.form.NumberField({ "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("ID","(pcsw.CoachingEndings.id) ") }, "fieldLabel": "ID", "anchor": "-20", "name": "id" });
    var name2502 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Bezeichnung","(pcsw.CoachingEndings.name) ") }, "fieldLabel": "Bezeichnung", "name": "name", "maxLength": 200, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var name_fr2503 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Bezeichnung (fr)","(pcsw.CoachingEndings.name_fr) ") }, "fieldLabel": "Bezeichnung (fr)", "name": "name_fr", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var name_de2504 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Bezeichnung (de)","(pcsw.CoachingEndings.name_de) ") }, "fieldLabel": "Bezeichnung (de)", "name": "name_de", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var name_nl2505 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Bezeichnung (nl)","(pcsw.CoachingEndings.name_nl) ") }, "fieldLabel": "Bezeichnung (nl)", "name": "name_nl", "maxLength": 200, "selectOnFocus": true, "hidden": true, "anchor": "-20" });
    var seqno2506 = new Ext.form.NumberField({ "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Seq.-Nr.","(pcsw.CoachingEndings.seqno) ") }, "fieldLabel": "Seq.-Nr.", "anchor": "-20", "name": "seqno" });
    var main_1_panel2507 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 153, "hideCheckBoxLabels": true, "items": [ { "flex": 5, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id2501, "labelAlign": "top" }, { "flex": 22, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name2502, "labelAlign": "top" }, { "flex": 22, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_fr2503, "labelAlign": "top" }, { "flex": 22, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_de2504, "labelAlign": "top" }, { "flex": 22, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_nl2505, "hidden": true, "labelAlign": "top" }, { "flex": 5, "autoHeight": true, "layout": "form", "xtype": "panel", "items": seqno2506, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var main_panel2523 = new Ext.Panel({ "autoScroll": false, "border": false, "layout": "vbox", "hideCheckBoxLabels": true, "items": [ main_1_panel2507 ], "frame": true, "layoutConfig": { "align": "stretch" }, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel2523;
    this.before_row_edit = function(record) {
    }
    Lino.pcsw.CoachingEndings.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.cbss.RetrieveTIGroupsRequests.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 89,
  initComponent : function() {
    var containing_panel = this;
    var id2910 = new Ext.form.NumberField({ "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("ID","(cbss.RetrieveTIGroupsRequests.id) ") }, "fieldLabel": "ID", "anchor": "-20", "name": "id" });
    var person2911 = new Lino.TwinCombo({ "preferred_width": 20, "fieldLabel": "Klient", "allowBlank": false, "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.pcsw.Clients.detail)}, "emptyText": "Klient ausw\u00e4hlen...", "listeners": { "render": Lino.quicktip_renderer("Klient","(cbss.RetrieveTIGroupsRequests.person) ") }, "selectOnFocus": true, "hiddenName": "personHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cbss/RetrieveTIGroupsRequests/person", "method": "GET" }) }), "name": "person" });
    var user2912 = new Lino.TwinCombo({ "preferred_width": 15, "fieldLabel": "Autor", "allowBlank": false, "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.users.Users.detail)}, "emptyText": "Benutzer ausw\u00e4hlen...", "listeners": { "render": Lino.quicktip_renderer("Autor","(cbss.RetrieveTIGroupsRequests.user) ") }, "selectOnFocus": true, "hiddenName": "userHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cbss/RetrieveTIGroupsRequests/user", "method": "GET" }) }), "name": "user" });
    var environment2913 = new Ext.form.TextField({ "disabled": true, "listeners": { "render": Lino.quicktip_renderer("T/A/B","(cbss.RetrieveTIGroupsRequests.environment) ") }, "fieldLabel": "T/A/B", "name": "environment", "maxLength": 4, "boxMinWidth": Lino.chars2width(4), "anchor": "-20" });
    var sent2914 = new Ext.form.DisplayField({ "disabled": true, "listeners": { "render": Lino.quicktip_renderer("Versendet","(cbss.RetrieveTIGroupsRequests.sent) The date and time when this request has been executed. \nThis is empty for requests than haven't been sent.\nRead-only.") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Versendet</span>", "name": "sent", "anchor": "-20", "value": "<br>" });
    var status2915 = new Lino.ChoicesFieldElement({ "forceSelection": true, "fieldLabel": "Zustand", "name": "status", "hiddenName": "statusHidden", "disabled": true, "listeners": { "render": Lino.quicktip_renderer("Zustand","(cbss.RetrieveTIGroupsRequests.status) ") }, "anchor": "-20", "store": [['','<br>']].concat(Lino.cbss.RequestStates) });
    var ticket2916 = new Ext.form.TextField({ "disabled": true, "listeners": { "render": Lino.quicktip_renderer("Ticket","(cbss.RetrieveTIGroupsRequests.ticket) ") }, "fieldLabel": "Ticket", "name": "ticket", "maxLength": 36, "anchor": "-20" });
    var info_1_panel2917 = new Ext.form.FieldSet({ "autoHeight": true, "layout": "hbox", "title": "Info zur Anfrage", "layoutConfig": { "align": "stretchmax" }, "frame": false, "bodyBorder": true, "autoScroll": false, "items": [ { "flex": 5, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id2910, "labelAlign": "top" }, { "flex": 20, "autoHeight": true, "layout": "form", "xtype": "panel", "items": person2911, "labelAlign": "top" }, { "flex": 20, "autoHeight": true, "layout": "form", "xtype": "panel", "items": user2912, "labelAlign": "top" }, { "flex": 5, "autoHeight": true, "layout": "form", "xtype": "panel", "items": environment2913, "labelAlign": "top" }, { "flex": 16, "autoHeight": true, "layout": "form", "xtype": "panel", "items": sent2914, "labelAlign": "top" }, { "flex": 12, "autoHeight": true, "layout": "form", "xtype": "panel", "items": status2915, "labelAlign": "top" }, { "flex": 21, "autoHeight": true, "layout": "form", "xtype": "panel", "items": ticket2916, "labelAlign": "top" } ], "hideCheckBoxLabels": true, "labelWidth": 90, "border": false, "labelAlign": "top" });
    var national_id2925 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("NR-Nummer","(cbss.RetrieveTIGroupsRequests.national_id) ") }, "fieldLabel": "NR-Nummer", "name": "national_id", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var language2926 = new Lino.ChoicesFieldElement({ "forceSelection": true, "fieldLabel": "Sprache", "name": "language", "hiddenName": "languageHidden", "listeners": { "render": Lino.quicktip_renderer("Sprache","(cbss.RetrieveTIGroupsRequests.language) ") }, "selectOnFocus": true, "anchor": "-20", "store": [['','<br>']].concat(Lino.cbss.RequestLanguages) });
    var history2927 = new Ext.form.Checkbox({ "boxLabel": "Historie", "listeners": { "render": Lino.quicktip_renderer("Historie","(cbss.RetrieveTIGroupsRequests.history) Whatever this means.") }, "hideLabel": true, "checked": true, "name": "history", "selectOnFocus": true, "anchor": "-20" });
    var parameters_panel2928 = new Ext.form.FieldSet({ "autoHeight": true, "layout": "hbox", "title": "Parameter", "layoutConfig": { "align": "stretchmax" }, "frame": false, "bodyBorder": true, "autoScroll": false, "items": [ { "flex": 52, "autoHeight": true, "layout": "form", "xtype": "panel", "items": national_id2925, "labelAlign": "top" }, { "flex": 22, "autoHeight": true, "layout": "form", "xtype": "panel", "items": language2926, "labelAlign": "top" }, { "flex": 25, "autoHeight": true, "layout": "form", "xtype": "panel", "items": history2927, "labelAlign": "top" } ], "hideCheckBoxLabels": true, "labelWidth": 90, "border": false, "labelAlign": "top" });
    var cbss_RetrieveTIGroupsResult_grid2937 = new Lino.cbss.RetrieveTIGroupsResult.GridPanel({ "flex": 71, "listeners": { "render": Lino.quicktip_renderer("Resultate","(cbss.cbss.RetrieveTIGroupsResult) ") }, "hide_top_toolbar": true, "containing_panel": this, "tools": [ Lino.show_in_own_window_button(Lino.cbss.RetrieveTIGroupsResult.grid) ], "preview_limit": 15, "master_panel": this });
    var request_panel2938 = new Ext.Panel({ "layout": "vbox", "title": "Abfrage", "items": [ info_1_panel2917, parameters_panel2928, cbss_RetrieveTIGroupsResult_grid2937 ], "frame": true, "layoutConfig": { "align": "stretch" }, "hideCheckBoxLabels": true, "listeners": { "activate": Lino.on_tab_activate }, "autoScroll": false, "border": false, "bodyBorder": false, "labelAlign": "top" });
    var response_xml2939 = new Ext.form.TextArea({ "disabled": true, "listeners": { "render": Lino.quicktip_renderer("Antwort","(cbss.RetrieveTIGroupsRequests.response_xml) The raw XML response received. \n") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Antwort</span>", "name": "response_xml", "growMax": 2000, "anchor": "-20 -10" });
    var info_messages2940 = new Ext.form.TextArea({ "disabled": true, "listeners": { "render": Lino.quicktip_renderer("Info-Meldungen","(cbss.RetrieveTIGroupsRequests.info_messages) ") }, "fieldLabel": "Info-Meldungen", "name": "info_messages", "growMax": 2000, "anchor": "-20 -10" });
    var debug_messages2941 = new Ext.form.TextArea({ "disabled": true, "listeners": { "render": Lino.quicktip_renderer("Debug-Meldungen","(cbss.RetrieveTIGroupsRequests.debug_messages) ") }, "fieldLabel": "Debug-Meldungen", "name": "debug_messages", "growMax": 2000, "anchor": "-20 -10" });
    var technical_panel2942 = new Lino.VBorderPanel({ "autoScroll": false, "listeners": { "activate": Lino.on_tab_activate }, "border": false, "labelWidth": 144, "title": "Technisch", "hideCheckBoxLabels": true, "items": [ { "flex": 5, "layout": "form", "xtype": "panel", "items": response_xml2939, "region": "north", "labelAlign": "top", "split": true }, { "flex": 5, "layout": "form", "xtype": "panel", "items": info_messages2940, "region": "center", "labelAlign": "top", "split": true }, { "flex": 5, "layout": "form", "xtype": "panel", "items": debug_messages2941, "region": "south", "labelAlign": "top", "split": true } ], "frame": true, "bodyBorder": false, "labelAlign": "top" });
    var main_panel2946 = new Ext.TabPanel({ "hideCheckBoxLabels": true, "border": false, "split": true, "autoScroll": false, "items": [ request_panel2938, technical_panel2942 ], "activeTab": 0, "bodyBorder": false, "frame": true, "labelAlign": "top" });
    this.items = main_panel2946;
    this.before_row_edit = function(record) {
      cbss_RetrieveTIGroupsResult_grid2937.on_master_changed();
    }
    Lino.cbss.RetrieveTIGroupsRequests.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.jobs.Jobs.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 71,
  initComponent : function() {
    var containing_panel = this;
    var name1753 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Name","(jobs.Jobs.name) ") }, "fieldLabel": "Name", "name": "name", "maxLength": 100, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var provider1754 = new Lino.TwinCombo({ "preferred_width": 20, "fieldLabel": "Stellenanbieter", "name": "provider", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.jobs.JobProviders.detail)}, "hiddenName": "providerHidden", "listeners": { "render": Lino.quicktip_renderer("Stellenanbieter","(jobs.Jobs.provider) ") }, "selectOnFocus": true, "emptyText": "Stellenanbieter ausw\u00e4hlen...", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/jobs/Jobs/provider", "method": "GET" }) }) });
    var contract_type1755 = new Lino.TwinCombo({ "preferred_width": 20, "fieldLabel": "Vertragsart", "name": "contract_type", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.jobs.ContractTypes.detail)}, "hiddenName": "contract_typeHidden", "listeners": { "render": Lino.quicktip_renderer("Vertragsart","(jobs.Jobs.contract_type) ") }, "selectOnFocus": true, "emptyText": "Art.60\u00a77-Konventionsart ausw\u00e4hlen...", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/jobs/Jobs/contract_type", "method": "GET" }) }) });
    var type1756 = new Lino.TwinCombo({ "fieldLabel": "Stellenart", "name": "type", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.jobs.JobTypes.detail)}, "emptyText": "Stellenart ausw\u00e4hlen...", "listeners": { "render": Lino.quicktip_renderer("Stellenart","(jobs.Jobs.type) ") }, "selectOnFocus": true, "hiddenName": "typeHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/jobs/Jobs/type", "method": "GET" }) }) });
    var id1757 = new Ext.form.NumberField({ "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("ID","(jobs.Jobs.id) ") }, "fieldLabel": "ID", "anchor": "-20", "name": "id" });
    var main_1_panel1758 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 144, "hideCheckBoxLabels": true, "items": [ { "flex": 24, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name1753, "labelAlign": "top" }, { "flex": 23, "autoHeight": true, "layout": "form", "xtype": "panel", "items": provider1754, "labelAlign": "top" }, { "flex": 23, "autoHeight": true, "layout": "form", "xtype": "panel", "items": contract_type1755, "labelAlign": "top" }, { "flex": 23, "autoHeight": true, "layout": "form", "xtype": "panel", "items": type1756, "labelAlign": "top" }, { "flex": 5, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id1757, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var sector1764 = new Lino.TwinCombo({ "fieldLabel": "Sektor", "name": "sector", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.jobs.Sectors.detail)}, "emptyText": "Sektor ausw\u00e4hlen...", "listeners": { "render": Lino.quicktip_renderer("Sektor","(jobs.Jobs.sector) ") }, "selectOnFocus": true, "hiddenName": "sectorHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/jobs/Jobs/sector", "method": "GET" }) }) });
    var function1765 = new Lino.TwinCombo({ "fieldLabel": "Funktion", "name": "function", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.jobs.Functions.detail)}, "emptyText": "Funktion ausw\u00e4hlen...", "listeners": { "render": Lino.quicktip_renderer("Funktion","(jobs.Jobs.function) ") }, "selectOnFocus": true, "hiddenName": "functionHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/jobs/Jobs/function", "method": "GET" }) }) });
    var capacity1766 = new Ext.form.NumberField({ "listeners": { "render": Lino.quicktip_renderer("Kapazit\u00e4t","(jobs.Jobs.capacity) ") }, "fieldLabel": "Kapazit\u00e4t", "name": "capacity", "selectOnFocus": true, "anchor": "-20", "value": 1, "allowBlank": false });
    var hourly_rate1767 = new Ext.form.NumberField({ "decimalPrecision": 2, "fieldLabel": "Stundensatz", "name": "hourly_rate", "decimalSeparator": ",", "listeners": { "render": Lino.quicktip_renderer("Stundensatz","(jobs.Jobs.hourly_rate) ") }, "selectOnFocus": true, "anchor": "-20", "allowBlank": true });
    var main_2_panel1768 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 108, "hideCheckBoxLabels": true, "items": [ { "flex": 35, "autoHeight": true, "layout": "form", "xtype": "panel", "items": sector1764, "labelAlign": "top" }, { "flex": 35, "autoHeight": true, "layout": "form", "xtype": "panel", "items": function1765, "labelAlign": "top" }, { "flex": 8, "autoHeight": true, "layout": "form", "xtype": "panel", "items": capacity1766, "labelAlign": "top" }, { "flex": 21, "autoHeight": true, "layout": "form", "xtype": "panel", "items": hourly_rate1767, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var remark1773 = new Ext.form.TextArea({ "listeners": { "render": Lino.quicktip_renderer("Bemerkung","(jobs.Jobs.remark) ") }, "fieldLabel": "Bemerkung", "name": "remark", "growMax": 2000, "selectOnFocus": true, "anchor": "-20 -10" });
    var CandidaturesByJob_grid1782 = new Lino.jobs.CandidaturesByJob.GridPanel({ "flex": 66, "listeners": { "render": Lino.quicktip_renderer("Stellenanfragen","(jobs.jobs.CandidaturesByJob) ") }, "hide_top_toolbar": true, "containing_panel": this, "tools": [ Lino.show_in_own_window_button(Lino.jobs.CandidaturesByJob.grid) ], "preview_limit": 15, "master_panel": this });
    var main_3_panel1783 = new Ext.Panel({ "flex": 41, "border": false, "layout": "hbox", "labelWidth": 90, "hideCheckBoxLabels": true, "items": [ { "items": remark1773, "labelAlign": "top", "layout": "form", "xtype": "panel", "flex": 33 }, CandidaturesByJob_grid1782 ], "autoScroll": false, "layoutConfig": { "align": "stretch" }, "frame": false, "labelAlign": "top" });
    var ContractsByJob_grid1812 = new Lino.jobs.ContractsByJob.GridPanel({ "flex": 41, "hide_top_toolbar": true, "containing_panel": this, "params_panel_hidden": true, "master_panel": this, "preview_limit": 15, "listeners": { "render": Lino.quicktip_renderer("Art.60\u00a77-Konventionen","(jobs.jobs.ContractsByJob) ") }, "tools": [ Lino.show_in_own_window_button(Lino.jobs.ContractsByJob.grid) ] });
    var main_panel1813 = new Ext.Panel({ "autoScroll": false, "border": false, "layout": "vbox", "hideCheckBoxLabels": true, "items": [ main_1_panel1758, main_2_panel1768, main_3_panel1783, ContractsByJob_grid1812 ], "frame": true, "layoutConfig": { "align": "stretch" }, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel1813;
    this.before_row_edit = function(record) {
      function1765.setContextValue('sector',record ? record.data['sectorHidden'] : undefined);
      CandidaturesByJob_grid1782.on_master_changed();
      ContractsByJob_grid1812.on_master_changed();
    }
    this.onRender = function(ct, position) {
      sector1764.on('change',Lino.chooser_handler(function1765,'sector'));
      Lino.jobs.Jobs.DetailFormPanel.superclass.onRender.call(this, ct, position);
    }
    Lino.jobs.Jobs.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.courses.CoursesByOffer.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 78,
  initComponent : function() {
    var containing_panel = this;
    var id2626 = new Ext.form.NumberField({ "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("ID","(courses.Courses.id) ") }, "fieldLabel": "ID", "anchor": "-20", "name": "id" });
    var start_date2627 = new Lino.DateField({ "listeners": { "render": Lino.quicktip_renderer("Beginndatum","(courses.Courses.start_date) ") }, "fieldLabel": "Beginndatum", "name": "start_date", "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var offer2628 = new Lino.TwinCombo({ "fieldLabel": "Kursangebot", "allowBlank": false, "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.courses.CourseOffers.detail)}, "emptyText": "Kursangebot ausw\u00e4hlen...", "listeners": { "render": Lino.quicktip_renderer("Kursangebot","(courses.Courses.offer) ") }, "selectOnFocus": true, "hiddenName": "offerHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/courses/Courses/offer", "method": "GET" }) }), "name": "offer" });
    var title2629 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Name","(courses.Courses.title) ") }, "fieldLabel": "Name", "name": "title", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var main_1_panel2630 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 108, "hideCheckBoxLabels": true, "items": [ { "flex": 14, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id2626, "labelAlign": "top" }, { "flex": 14, "autoHeight": true, "layout": "form", "xtype": "panel", "items": start_date2627, "labelAlign": "top" }, { "flex": 35, "autoHeight": true, "layout": "form", "xtype": "panel", "items": offer2628, "labelAlign": "top" }, { "flex": 36, "autoHeight": true, "layout": "form", "xtype": "panel", "items": title2629, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var remark2635 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Bemerkung","(courses.Courses.remark) ") }, "fieldLabel": "Bemerkung", "name": "remark", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var courses_ParticipantsByCourse_grid2641 = new Lino.courses.ParticipantsByCourse.GridPanel({ "flex": 41, "listeners": { "render": Lino.quicktip_renderer("Teilnehmer","(courses.courses.ParticipantsByCourse) ") }, "hide_top_toolbar": true, "containing_panel": this, "tools": [ Lino.show_in_own_window_button(Lino.courses.ParticipantsByCourse.grid) ], "preview_limit": 15, "master_panel": this });
    var courses_CandidatesByCourse_grid2648 = new Lino.courses.CandidatesByCourse.GridPanel({ "flex": 41, "listeners": { "render": Lino.quicktip_renderer("Kandidaten","(courses.courses.CandidatesByCourse) ") }, "hide_top_toolbar": true, "containing_panel": this, "tools": [ Lino.show_in_own_window_button(Lino.courses.CandidatesByCourse.grid) ], "preview_limit": 15, "master_panel": this });
    var main_panel2649 = new Ext.Panel({ "autoScroll": false, "border": false, "layout": "vbox", "labelWidth": 90, "hideCheckBoxLabels": true, "items": [ main_1_panel2630, { "items": remark2635, "autoHeight": true, "layout": "form", "xtype": "panel", "labelAlign": "top" }, courses_ParticipantsByCourse_grid2641, courses_CandidatesByCourse_grid2648 ], "frame": true, "layoutConfig": { "align": "stretch" }, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel2649;
    this.before_row_edit = function(record) {
      courses_ParticipantsByCourse_grid2641.on_master_changed();
      courses_CandidatesByCourse_grid2648.on_master_changed();
    }
    Lino.courses.CoursesByOffer.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.outbox.Mails.InsertFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 26,
  initComponent : function() {
    var containing_panel = this;
    var project762 = new Lino.TwinCombo({ "preferred_width": 20, "fieldLabel": "Klient", "name": "project", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.pcsw.Clients.detail)}, "hiddenName": "projectHidden", "listeners": { "render": Lino.quicktip_renderer("Klient","(outbox.Mails.project) ") }, "selectOnFocus": true, "emptyText": "Klient ausw\u00e4hlen...", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/outbox/Mails/project", "method": "GET" }) }) });
    var subject763 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Betreff","(outbox.Mails.subject) ") }, "fieldLabel": "Betreff", "name": "subject", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var body764 = new Lino.RichTextPanel({ "selectOnFocus": true, "flex": 71, "containing_panel": this, "name": "body", "title": "Inhalt" });
    var main_panel765 = new Ext.Panel({ "autoScroll": false, "border": false, "layout": "vbox", "labelWidth": 72, "hideCheckBoxLabels": true, "items": [ { "items": project762, "autoHeight": true, "layout": "form", "xtype": "panel", "labelAlign": "top" }, { "items": subject763, "autoHeight": true, "layout": "form", "xtype": "panel", "labelAlign": "top" }, body764 ], "frame": true, "layoutConfig": { "align": "stretch" }, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel765;
    this.before_row_edit = function(record) {
      body764.refresh();
    }
    Lino.outbox.Mails.InsertFormPanel.superclass.initComponent.call(this);
  }
});


Lino.cal.Calendars.InsertFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  autoHeight: true,
  content_type: 33,
  initComponent : function() {
    var containing_panel = this;
    var name1133 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Bezeichnung","(cal.Calendars.name) ") }, "fieldLabel": "Bezeichnung", "name": "name", "maxLength": 200, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var name_fr1134 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Bezeichnung (fr)","(cal.Calendars.name_fr) ") }, "fieldLabel": "Bezeichnung (fr)", "name": "name_fr", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var name_de1135 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Bezeichnung (de)","(cal.Calendars.name_de) ") }, "fieldLabel": "Bezeichnung (de)", "name": "name_de", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var name_nl1136 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Bezeichnung (nl)","(cal.Calendars.name_nl) ") }, "fieldLabel": "Bezeichnung (nl)", "name": "name_nl", "maxLength": 200, "selectOnFocus": true, "hidden": true, "anchor": "-20" });
    var main_1_panel1137 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 25, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name1133, "labelAlign": "top" }, { "flex": 25, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_fr1134, "labelAlign": "top" }, { "flex": 25, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_de1135, "labelAlign": "top" }, { "flex": 25, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_nl1136, "hidden": true, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 153, "border": false, "anchor": "-20", "labelAlign": "top" });
    var type1142 = new Lino.ChoicesFieldElement({ "fieldLabel": "Art", "allowBlank": false, "value": "local", "hiddenName": "typeHidden", "listeners": { "render": Lino.quicktip_renderer("Art","(cal.Calendars.type) ") }, "selectOnFocus": true, "anchor": "-20", "store": [ [ "local", "Local Calendar" ], [ "google", "Google Calendar" ] ], "name": "type" });
    var invite_team_members1143 = new Lino.RemoteComboFieldElement({ "fieldLabel": "Team", "name": "invite_team_members", "pageSize": 20, "emptyText": "Team ausw\u00e4hlen...", "listeners": { "render": Lino.quicktip_renderer("Team","(cal.Calendars.invite_team_members) ") }, "selectOnFocus": true, "hiddenName": "invite_team_membersHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/Calendars/invite_team_members", "method": "GET" }) }) });
    var color1144 = new Ext.form.NumberField({ "listeners": { "render": Lino.quicktip_renderer("Farbe","(cal.Calendars.color) ") }, "fieldLabel": "Farbe", "name": "color", "selectOnFocus": true, "anchor": "-20", "value": 1, "allowBlank": false });
    var main_2_panel1145 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 44, "autoHeight": true, "layout": "form", "xtype": "panel", "items": type1142, "labelAlign": "top" }, { "flex": 44, "autoHeight": true, "layout": "form", "xtype": "panel", "items": invite_team_members1143, "labelAlign": "top" }, { "flex": 11, "autoHeight": true, "layout": "form", "xtype": "panel", "items": color1144, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 54, "border": false, "anchor": "-20", "labelAlign": "top" });
    var invite_client1149 = new Ext.form.Checkbox({ "boxLabel": "Klient einladen", "listeners": { "render": Lino.quicktip_renderer("Klient einladen","(cal.Calendars.invite_client) ") }, "hideLabel": true, "checked": false, "name": "invite_client", "selectOnFocus": true, "anchor": "-20" });
    var main_panel1150 = new Ext.Panel({ "hideCheckBoxLabels": true, "autoHeight": true, "border": false, "layout": "form", "labelWidth": 144, "autoScroll": false, "items": [ main_1_panel1137, main_2_panel1145, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": invite_client1149, "anchor": "-20", "labelAlign": "top" } ], "frame": true, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel1150;
    this.before_row_edit = function(record) {
    }
    Lino.cal.Calendars.InsertFormPanel.superclass.initComponent.call(this);
  }
});


Lino.contacts.Companies.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 19,
  initComponent : function() {
    var containing_panel = this;
    var prefix605 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("prefix","(contacts.Companies.prefix) ") }, "fieldLabel": "prefix", "name": "prefix", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var name606 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Name","(contacts.Companies.name) ") }, "fieldLabel": "Name", "name": "name", "maxLength": 200, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var id607 = new Ext.form.NumberField({ "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("ID","(contacts.Companies.id) ") }, "fieldLabel": "ID", "anchor": "-20", "name": "id" });
    var language608 = new Lino.ChoicesFieldElement({ "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Sprache</span>", "allowBlank": false, "hiddenName": "languageHidden", "listeners": { "render": Lino.quicktip_renderer("Sprache","(contacts.Companies.language) Die Sprache, in der Dokumente ausgestellt werden sollen.") }, "selectOnFocus": true, "anchor": "-20", "store": [ [ "en", "Englisch" ], [ "fr", "Franz\u00f6sisch" ], [ "de", "Deutsch" ], [ "nl", "Niederl\u00e4ndisch" ] ], "name": "language" });
    var intro_box_1_panel609 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 31, "autoHeight": true, "layout": "form", "xtype": "panel", "items": prefix605, "labelAlign": "top" }, { "flex": 31, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name606, "labelAlign": "top" }, { "flex": 7, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id607, "labelAlign": "top" }, { "flex": 29, "autoHeight": true, "layout": "form", "xtype": "panel", "items": language608, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 72, "border": false, "anchor": "-20", "labelAlign": "top" });
    var vat_id614 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("MWSt.-Nr.","(contacts.Companies.vat_id) ") }, "fieldLabel": "MWSt.-Nr.", "name": "vat_id", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var activity615 = new Lino.RemoteComboFieldElement({ "fieldLabel": "Beruf", "name": "activity", "pageSize": 20, "emptyText": "Beruf ausw\u00e4hlen...", "listeners": { "render": Lino.quicktip_renderer("Beruf","(contacts.Companies.activity) ") }, "selectOnFocus": true, "hiddenName": "activityHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/contacts/Companies/activity", "method": "GET" }) }) });
    var type616 = new Lino.RemoteComboFieldElement({ "fieldLabel": "Organisationsart", "name": "type", "pageSize": 20, "emptyText": "Organisationsart ausw\u00e4hlen...", "listeners": { "render": Lino.quicktip_renderer("Organisationsart","(contacts.Companies.type) ") }, "selectOnFocus": true, "hiddenName": "typeHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/contacts/Companies/type", "method": "GET" }) }) });
    var intro_box_2_panel617 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 23, "autoHeight": true, "layout": "form", "xtype": "panel", "items": vat_id614, "labelAlign": "top" }, { "flex": 38, "autoHeight": true, "layout": "form", "xtype": "panel", "items": activity615, "labelAlign": "top" }, { "flex": 38, "autoHeight": true, "layout": "form", "xtype": "panel", "items": type616, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 153, "border": false, "anchor": "-20", "labelAlign": "top" });
    var bank_account1621 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Bankkonto 1","(contacts.Companies.bank_account1) ") }, "fieldLabel": "Bankkonto 1", "name": "bank_account1", "maxLength": 40, "selectOnFocus": true, "anchor": "-20" });
    var bank_account2622 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Bankkonto 2","(contacts.Companies.bank_account2) ") }, "fieldLabel": "Bankkonto 2", "name": "bank_account2", "maxLength": 40, "selectOnFocus": true, "anchor": "-20" });
    var is_obsolete623 = new Ext.form.Checkbox({ "boxLabel": "veraltet", "listeners": { "render": Lino.quicktip_renderer("veraltet","(contacts.Companies.is_obsolete) Altf\u00e4lle sind Partner, deren Stammdaten nicht mehr gepflegt werden und \nf\u00fcr neue Operationen nicht benutzt werden k\u00f6nnen.") }, "hideLabel": true, "checked": false, "name": "is_obsolete", "selectOnFocus": true, "anchor": "-20" });
    var intro_box_3_panel624 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 40, "autoHeight": true, "layout": "form", "xtype": "panel", "items": bank_account1621, "labelAlign": "top" }, { "flex": 40, "autoHeight": true, "layout": "form", "xtype": "panel", "items": bank_account2622, "labelAlign": "top" }, { "flex": 19, "autoHeight": true, "layout": "form", "xtype": "panel", "items": is_obsolete623, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 108, "border": false, "anchor": "-20", "labelAlign": "top" });
    var intro_box_panel628 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "form", "hideCheckBoxLabels": true, "items": [ intro_box_1_panel609, intro_box_2_panel617, intro_box_3_panel624 ], "frame": true, "bodyBorder": false, "labelAlign": "top" });
    var country629 = new Lino.TwinCombo({ "fieldLabel": "Land", "name": "country", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.countries.Countries.detail)}, "emptyText": "Land ausw\u00e4hlen...", "listeners": { "render": Lino.quicktip_renderer("Land","(contacts.Companies.country) ") }, "selectOnFocus": true, "hiddenName": "countryHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/contacts/Companies/country", "method": "GET" }) }) });
    var region630 = new Lino.TwinCombo({ "fieldLabel": "Region", "name": "region", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.countries.Cities.detail)}, "emptyText": "Ort ausw\u00e4hlen...", "listeners": { "render": Lino.quicktip_renderer("Region","(contacts.Companies.region) ") }, "selectOnFocus": true, "hiddenName": "regionHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/contacts/Companies/region", "method": "GET" }) }) });
    var box3_1_panel631 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": country629, "labelAlign": "top" }, { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": region630, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 63, "border": false, "anchor": "-20", "labelAlign": "top" });
    var city634 = new Lino.TwinCombo({ "forceSelection": false, "fieldLabel": "Ort", "name": "city", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.countries.Cities.detail)}, "emptyText": "Ort ausw\u00e4hlen...", "listeners": { "render": Lino.quicktip_renderer("Ort","(contacts.Companies.city) ") }, "selectOnFocus": true, "hiddenName": "cityHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/contacts/Companies/city", "method": "GET" }) }) });
    var zip_code635 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Postleitzahl","(contacts.Companies.zip_code) ") }, "fieldLabel": "Postleitzahl", "name": "zip_code", "maxLength": 10, "selectOnFocus": true, "boxMinWidth": Lino.chars2width(10), "anchor": "-20" });
    var box3_2_panel636 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 66, "autoHeight": true, "layout": "form", "xtype": "panel", "items": city634, "labelAlign": "top" }, { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": zip_code635, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 117, "border": false, "anchor": "-20", "labelAlign": "top" });
    var street_prefix639 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Pr\u00e4fix Stra\u00dfe","(contacts.Companies.street_prefix) Text to print before name of street, but to ignore for sorting.") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Pr\u00e4fix Stra\u00dfe</span>", "name": "street_prefix", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var street640 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Stra\u00dfe","(contacts.Companies.street) Name of street. Without house number.") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Stra\u00dfe</span>", "name": "street", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var street_no641 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Nr.","(contacts.Companies.street_no) House number") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Nr.</span>", "name": "street_no", "maxLength": 10, "selectOnFocus": true, "boxMinWidth": Lino.chars2width(10), "anchor": "-20" });
    var street_box642 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Box","(contacts.Companies.street_box) Text to print after :attr:`steet_no` on the same line") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Box</span>", "name": "street_box", "maxLength": 10, "selectOnFocus": true, "boxMinWidth": Lino.chars2width(10), "anchor": "-20" });
    var box3_3_panel643 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 30, "autoHeight": true, "layout": "form", "xtype": "panel", "items": street_prefix639, "labelAlign": "top" }, { "flex": 36, "autoHeight": true, "layout": "form", "xtype": "panel", "items": street640, "labelAlign": "top" }, { "flex": 16, "autoHeight": true, "layout": "form", "xtype": "panel", "items": street_no641, "labelAlign": "top" }, { "flex": 16, "autoHeight": true, "layout": "form", "xtype": "panel", "items": street_box642, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 126, "border": false, "anchor": "-20", "labelAlign": "top" });
    var addr2648 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Adresszeile nach Stra\u00dfe","(contacts.Companies.addr2) Address line to print below street line") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Adresszeile nach Stra\u00dfe</span>", "name": "addr2", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var box3_panel649 = new Ext.Panel({ "flex": 62, "autoHeight": true, "layout": "form", "items": [ box3_1_panel631, box3_2_panel636, box3_3_panel643, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": addr2648, "anchor": "-20", "labelAlign": "top" } ], "frame": true, "bodyBorder": false, "autoScroll": false, "hideCheckBoxLabels": true, "labelWidth": 216, "border": false, "labelAlign": "top" });
    var email651 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("E-Mail","(contacts.Companies.email) ") }, "fieldLabel": "E-Mail", "name": "email", "maxLength": 75, "selectOnFocus": true, "anchor": "-20" });
    var url652 = new Lino.URLField({ "listeners": { "render": Lino.quicktip_renderer("URL","(contacts.Companies.url) ") }, "fieldLabel": "URL", "name": "url", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var phone653 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Telefon","(contacts.Companies.phone) ") }, "fieldLabel": "Telefon", "name": "phone", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var gsm654 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("GSM","(contacts.Companies.gsm) ") }, "fieldLabel": "GSM", "name": "gsm", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var box4_panel655 = new Ext.Panel({ "flex": 37, "autoHeight": true, "layout": "form", "items": [ { "autoHeight": true, "layout": "form", "xtype": "panel", "items": email651, "anchor": "-20", "labelAlign": "top" }, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": url652, "anchor": "-20", "labelAlign": "top" }, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": phone653, "anchor": "-20", "labelAlign": "top" }, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": gsm654, "anchor": "-20", "labelAlign": "top" } ], "frame": true, "bodyBorder": false, "autoScroll": false, "hideCheckBoxLabels": true, "labelWidth": 72, "border": false, "labelAlign": "top" });
    var address_box_panel660 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "hideCheckBoxLabels": true, "items": [ box3_panel649, box4_panel655 ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var remarks661 = new Ext.form.TextArea({ "listeners": { "render": Lino.quicktip_renderer("Bemerkungen","(contacts.Companies.remarks) ") }, "fieldLabel": "Bemerkungen", "name": "remarks", "growMax": 2000, "selectOnFocus": true, "anchor": "-20 -10" });
    var is_courseprovider662 = new Ext.form.Checkbox({ "boxLabel": "ist Kursanbieter (<a href=\"javascript:Lino.show_mti_child('is_courseprovider',Lino.courses.CourseProviders.detail)\">zeigen</a>)", "listeners": { "render": Lino.quicktip_renderer("ist Kursanbieter","(contacts.Companies.is_courseprovider) ") }, "hideLabel": true, "name": "is_courseprovider", "selectOnFocus": true, "anchor": "-20" });
    var is_jobprovider663 = new Ext.form.Checkbox({ "boxLabel": "Stellenanbieter (<a href=\"javascript:Lino.show_mti_child('is_jobprovider',Lino.jobs.JobProviders.detail)\">zeigen</a>)", "listeners": { "render": Lino.quicktip_renderer("Stellenanbieter","(contacts.Companies.is_jobprovider) ") }, "hideLabel": true, "name": "is_jobprovider", "selectOnFocus": true, "anchor": "-20" });
    var client_contact_type664 = new Lino.RemoteComboFieldElement({ "fieldLabel": "Klientenkontaktart", "name": "client_contact_type", "pageSize": 20, "emptyText": "Klientenkontaktart ausw\u00e4hlen...", "listeners": { "render": Lino.quicktip_renderer("Klientenkontaktart","(contacts.Companies.client_contact_type) ") }, "selectOnFocus": true, "hiddenName": "client_contact_typeHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/contacts/Companies/client_contact_type", "method": "GET" }) }) });
    var box5_2_panel665 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 171, "hideCheckBoxLabels": true, "items": [ { "flex": 25, "autoHeight": true, "layout": "form", "xtype": "panel", "items": is_courseprovider662, "labelAlign": "top" }, { "flex": 25, "autoHeight": true, "layout": "form", "xtype": "panel", "items": is_jobprovider663, "labelAlign": "top" }, { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": client_contact_type664, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var box5_panel669 = new Ext.Panel({ "flex": 57, "layout": "vbox", "items": [ { "items": remarks661, "labelAlign": "top", "layout": "form", "xtype": "panel", "flex": 83 }, box5_2_panel665 ], "frame": true, "layoutConfig": { "align": "stretch" }, "autoScroll": false, "hideCheckBoxLabels": true, "labelWidth": 108, "border": false, "bodyBorder": false, "labelAlign": "top" });
    var contacts_RolesByCompany_grid675 = new Lino.contacts.RolesByCompany.GridPanel({ "flex": 42, "listeners": { "render": Lino.quicktip_renderer("Kontaktpersonen","(contacts.contacts.RolesByCompany) ") }, "hide_top_toolbar": true, "containing_panel": this, "tools": [ Lino.show_in_own_window_button(Lino.contacts.RolesByCompany.grid) ], "preview_limit": 15, "master_panel": this });
    var bottom_box_panel676 = new Ext.Panel({ "flex": 46, "border": false, "layout": "hbox", "hideCheckBoxLabels": true, "items": [ box5_panel669, contacts_RolesByCompany_grid675 ], "autoScroll": false, "layoutConfig": { "align": "stretch" }, "frame": false, "labelAlign": "top" });
    var general_panel677 = new Ext.Panel({ "layout": "vbox", "title": "Allgemein", "items": [ intro_box_panel628, address_box_panel660, bottom_box_panel676 ], "frame": true, "layoutConfig": { "align": "stretch" }, "hideCheckBoxLabels": true, "listeners": { "activate": Lino.on_tab_activate }, "autoScroll": false, "border": false, "bodyBorder": false, "labelAlign": "top" });
    var pcsw_NotesByCompany_grid791 = new Lino.pcsw.NotesByCompany.GridPanel({ "listeners": { "activate": Lino.on_tab_activate }, "hide_top_toolbar": true, "containing_panel": this, "title": "Ereignisse/Notizen", "tools": [ Lino.show_in_own_window_button(Lino.pcsw.NotesByCompany.grid) ], "preview_limit": 15, "master_panel": this });
    var main_panel792 = new Ext.TabPanel({ "hideCheckBoxLabels": true, "border": false, "split": true, "autoScroll": false, "items": [ general_panel677, pcsw_NotesByCompany_grid791 ], "activeTab": 0, "bodyBorder": false, "frame": true, "labelAlign": "top" });
    this.items = main_panel792;
    this.before_row_edit = function(record) {
      region630.setContextValue('country',record ? record.data['countryHidden'] : undefined);
      city634.setContextValue('country',record ? record.data['countryHidden'] : undefined);
      city634.setContextValue('region',record ? record.data['regionHidden'] : undefined);
      contacts_RolesByCompany_grid675.on_master_changed();
      pcsw_NotesByCompany_grid791.on_master_changed();
    }
    this.onRender = function(ct, position) {
      country629.on('change',Lino.chooser_handler(region630,'country'));
      country629.on('change',Lino.chooser_handler(city634,'country'));
      region630.on('change',Lino.chooser_handler(city634,'region'));
      Lino.contacts.Companies.DetailFormPanel.superclass.onRender.call(this, ct, position);
    }
    Lino.contacts.Companies.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.about.About.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  disable_editing: true,
  initComponent : function() {
    var containing_panel = this;
    var server_status_disp3035 = new Ext.form.DisplayField({ "disabled": true, "listeners": { "render": Lino.quicktip_renderer("Server-Status","(about.About.server_status) ") }, "fieldLabel": "Server-Status", "name": "server_status", "anchor": "-20", "value": "<br/>", "always_enabled": true });
    var main_panel3036 = new Ext.Panel({ "autoScroll": false, "border": false, "layout": "vbox", "labelWidth": 126, "hideCheckBoxLabels": true, "items": [ { "flex": 25, "html": "<div class=\"htmlText\"><span>This is <a href=\"http://welfare.lino-framework.org\" target=\"_blank\">Lino Welfare</a> 1.1.9 using <a href=\"http://north.lino-framework.org\" target=\"_blank\">North</a> 0.1.6, <a href=\"http://babel.edgewall.org/\" target=\"_blank\">Babel</a> 1.0, <a href=\"http://site.lino-framework.org\" target=\"_blank\">djangosite</a> 0.1.7, <a href=\"http://www.djangoproject.com\" target=\"_blank\">Django</a> 1.5.1, <a href=\"http://www.python.org/\" target=\"_blank\">Python</a> 2.7.3, <a href=\"http://www.sencha.com\" target=\"_blank\">ExtJS</a> <a href=\"#\" onclick=\"alert('ExtJS client version is ' + Ext.version);\" title=\"Click to see ExtJS client version\">(version)</a>, <a href=\"http://ext.ensible.com/products/calendar/\" target=\"_blank\">Extensible</a> <a href=\"#\" onclick=\"alert('Extensible Calendar version is ' + Ext.ensible.version);\" title=\"Click to see Extensible Calendar version\">(version)</a>, <a href=\"http://www.famfamfam.com/lab/icons/silk/\" target=\"_blank\">Silk Icons</a> 1.3</span><p>Server l&#228;uft seit : <b>Donnerstag, 5. September 2013 um 13:38:37.156662</b></p><p>Source timestamps:</p><ul><li>lino_welfare : <b>Donnerstag, 5. September 2013 um 13:38:34.707045</b></li><li>lino : <b>Donnerstag, 5. September 2013 um 11:07:35.115283</b></li><li>djangosite : <b>Sonntag, 1. September 2013 um 21:29:01.460541</b></li><li>atelier : <b>Samstag, 31. August 2013 um 22:37:13.287741</b></li><li>django : <b>Freitag, 30. August 2013 um 13:02:10.834631</b></li><li>north : <b>Mittwoch, 28. August 2013 um 11:25:41.253661</b></li></ul></div>", "xtype": "label" }, { "items": server_status_disp3035, "autoHeight": true, "layout": "form", "xtype": "panel", "labelAlign": "top" } ], "frame": true, "layoutConfig": { "align": "stretch" }, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel3036;
    this.before_row_edit = function(record) {
    }
    Lino.about.About.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.contacts.Partners.InsertFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  autoHeight: true,
  content_type: 22,
  initComponent : function() {
    var containing_panel = this;
    var name560 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Name","(contacts.Partners.name) ") }, "fieldLabel": "Name", "name": "name", "maxLength": 200, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var language561 = new Lino.ChoicesFieldElement({ "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Sprache</span>", "allowBlank": false, "hiddenName": "languageHidden", "listeners": { "render": Lino.quicktip_renderer("Sprache","(contacts.Partners.language) Die Sprache, in der Dokumente ausgestellt werden sollen.") }, "selectOnFocus": true, "anchor": "-20", "store": [ [ "en", "Englisch" ], [ "fr", "Franz\u00f6sisch" ], [ "de", "Deutsch" ], [ "nl", "Niederl\u00e4ndisch" ] ], "name": "language" });
    var email562 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("E-Mail","(contacts.Partners.email) ") }, "fieldLabel": "E-Mail", "name": "email", "maxLength": 75, "selectOnFocus": true, "anchor": "-20" });
    var main_2_panel563 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 48, "autoHeight": true, "layout": "form", "xtype": "panel", "items": language561, "labelAlign": "top" }, { "flex": 51, "autoHeight": true, "layout": "form", "xtype": "panel", "items": email562, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 72, "border": false, "anchor": "-20", "labelAlign": "top" });
    var main_panel566 = new Ext.Panel({ "hideCheckBoxLabels": true, "autoHeight": true, "border": false, "layout": "form", "labelWidth": 45, "autoScroll": false, "items": [ { "autoHeight": true, "layout": "form", "xtype": "panel", "items": name560, "anchor": "-20", "labelAlign": "top" }, main_2_panel563 ], "frame": true, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel566;
    this.before_row_edit = function(record) {
    }
    Lino.contacts.Partners.InsertFormPanel.superclass.initComponent.call(this);
  }
});


Lino.countries.CitiesByCity.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 12,
  initComponent : function() {
    var containing_panel = this;
    var name269 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Bezeichnung","(countries.Cities.name) ") }, "fieldLabel": "Bezeichnung", "name": "name", "maxLength": 200, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var name_fr270 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Bezeichnung (fr)","(countries.Cities.name_fr) ") }, "fieldLabel": "Bezeichnung (fr)", "name": "name_fr", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var name_de271 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Bezeichnung (de)","(countries.Cities.name_de) ") }, "fieldLabel": "Bezeichnung (de)", "name": "name_de", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var name_nl272 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Bezeichnung (nl)","(countries.Cities.name_nl) ") }, "fieldLabel": "Bezeichnung (nl)", "name": "name_nl", "maxLength": 200, "selectOnFocus": true, "hidden": true, "anchor": "-20" });
    var country273 = new Lino.TwinCombo({ "fieldLabel": "Land", "allowBlank": false, "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.countries.Countries.detail)}, "emptyText": "Land ausw\u00e4hlen...", "listeners": { "render": Lino.quicktip_renderer("Land","(countries.Cities.country) ") }, "selectOnFocus": true, "hiddenName": "countryHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/countries/Cities/country", "method": "GET" }) }), "name": "country" });
    var inscode274 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("INS-Code","(countries.Cities.inscode) The official code for this place used by statbel.fgov.be") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">INS-Code</span>", "name": "inscode", "maxLength": 5, "selectOnFocus": true, "boxMinWidth": Lino.chars2width(5), "anchor": "-20" });
    var zip_code275 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("zip code","(countries.Cities.zip_code) ") }, "fieldLabel": "zip code", "name": "zip_code", "maxLength": 8, "selectOnFocus": true, "boxMinWidth": Lino.chars2width(8), "anchor": "-20" });
    var main_1_panel276 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 153, "hideCheckBoxLabels": true, "items": [ { "flex": 17, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name269, "labelAlign": "top" }, { "flex": 17, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_fr270, "labelAlign": "top" }, { "flex": 17, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_de271, "labelAlign": "top" }, { "flex": 17, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_nl272, "hidden": true, "labelAlign": "top" }, { "flex": 16, "autoHeight": true, "layout": "form", "xtype": "panel", "items": country273, "labelAlign": "top" }, { "flex": 5, "autoHeight": true, "layout": "form", "xtype": "panel", "items": inscode274, "labelAlign": "top" }, { "flex": 7, "autoHeight": true, "layout": "form", "xtype": "panel", "items": zip_code275, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var parent284 = new Lino.TwinCombo({ "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Teil von</span>", "name": "parent", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.countries.Cities.detail)}, "emptyText": "Ort ausw\u00e4hlen...", "listeners": { "render": Lino.quicktip_renderer("Teil von","(countries.Cities.parent) The superordinate geographic place of which this place is a part.") }, "selectOnFocus": true, "hiddenName": "parentHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/countries/Cities/parent", "method": "GET" }) }) });
    var type285 = new Lino.RemoteComboFieldElement({ "listeners": { "render": Lino.quicktip_renderer("Ortsart","(countries.Cities.type) ") }, "fieldLabel": "Ortsart", "name": "type", "selectOnFocus": true, "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/countries/Cities/type", "method": "GET" }) }), "hiddenName": "typeHidden" });
    var id286 = new Ext.form.NumberField({ "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("ID","(countries.Cities.id) ") }, "fieldLabel": "ID", "anchor": "-20", "name": "id" });
    var main_2_panel287 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 81, "hideCheckBoxLabels": true, "items": [ { "flex": 57, "autoHeight": true, "layout": "form", "xtype": "panel", "items": parent284, "labelAlign": "top" }, { "flex": 28, "autoHeight": true, "layout": "form", "xtype": "panel", "items": type285, "labelAlign": "top" }, { "flex": 14, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id286, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var CitiesByCity_grid584 = new Lino.countries.CitiesByCity.GridPanel({ "flex": 41, "listeners": { "render": Lino.quicktip_renderer("Unterteilungen","(countries.countries.CitiesByCity) ") }, "hide_top_toolbar": true, "containing_panel": this, "tools": [ Lino.show_in_own_window_button(Lino.countries.CitiesByCity.grid) ], "preview_limit": 15, "master_panel": this });
    var contacts_PartnersByCity_grid585 = new Lino.contacts.PartnersByCity.GridPanel({ "flex": 50, "listeners": { "render": Lino.quicktip_renderer("Partner","(contacts.contacts.PartnersByCity) ") }, "hide_top_toolbar": true, "containing_panel": this, "tools": [ Lino.show_in_own_window_button(Lino.contacts.PartnersByCity.grid) ], "preview_limit": 15, "master_panel": this });
    var jobs_StudiesByCity_grid586 = new Lino.jobs.StudiesByCity.GridPanel({ "flex": 50, "listeners": { "render": Lino.quicktip_renderer("Ausbildungen und Studien","(jobs.jobs.StudiesByCity) ") }, "hide_top_toolbar": true, "containing_panel": this, "tools": [ Lino.show_in_own_window_button(Lino.jobs.StudiesByCity.grid) ], "preview_limit": 15, "master_panel": this });
    var main_4_panel587 = new Ext.Panel({ "flex": 41, "border": false, "layout": "hbox", "hideCheckBoxLabels": true, "items": [ contacts_PartnersByCity_grid585, jobs_StudiesByCity_grid586 ], "autoScroll": false, "layoutConfig": { "align": "stretch" }, "frame": false, "labelAlign": "top" });
    var main_panel588 = new Ext.Panel({ "autoScroll": false, "border": false, "layout": "vbox", "hideCheckBoxLabels": true, "items": [ main_1_panel276, main_2_panel287, CitiesByCity_grid584, main_4_panel587 ], "frame": true, "layoutConfig": { "align": "stretch" }, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel588;
    this.before_row_edit = function(record) {
      type285.setContextValue('country',record ? record.data['countryHidden'] : undefined);
      CitiesByCity_grid584.on_master_changed();
      contacts_PartnersByCity_grid585.on_master_changed();
      jobs_StudiesByCity_grid586.on_master_changed();
    }
    this.onRender = function(ct, position) {
      country273.on('change',Lino.chooser_handler(type285,'country'));
      Lino.countries.CitiesByCity.DetailFormPanel.superclass.onRender.call(this, ct, position);
    }
    Lino.countries.CitiesByCity.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.courses.CourseProviders.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 79,
  initComponent : function() {
    var containing_panel = this;
    var prefix2545 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("prefix","(courses.CourseProviders.prefix) ") }, "fieldLabel": "prefix", "name": "prefix", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var name2546 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Name","(courses.CourseProviders.name) ") }, "fieldLabel": "Name", "name": "name", "maxLength": 200, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var id2547 = new Ext.form.NumberField({ "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("ID","(courses.CourseProviders.id) ") }, "fieldLabel": "ID", "anchor": "-20", "name": "id" });
    var language2548 = new Lino.ChoicesFieldElement({ "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Sprache</span>", "allowBlank": false, "hiddenName": "languageHidden", "listeners": { "render": Lino.quicktip_renderer("Sprache","(courses.CourseProviders.language) Die Sprache, in der Dokumente ausgestellt werden sollen.") }, "selectOnFocus": true, "anchor": "-20", "store": [ [ "en", "Englisch" ], [ "fr", "Franz\u00f6sisch" ], [ "de", "Deutsch" ], [ "nl", "Niederl\u00e4ndisch" ] ], "name": "language" });
    var intro_box_1_panel2549 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 31, "autoHeight": true, "layout": "form", "xtype": "panel", "items": prefix2545, "labelAlign": "top" }, { "flex": 31, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name2546, "labelAlign": "top" }, { "flex": 7, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id2547, "labelAlign": "top" }, { "flex": 29, "autoHeight": true, "layout": "form", "xtype": "panel", "items": language2548, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 72, "border": false, "anchor": "-20", "labelAlign": "top" });
    var vat_id2554 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("MWSt.-Nr.","(courses.CourseProviders.vat_id) ") }, "fieldLabel": "MWSt.-Nr.", "name": "vat_id", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var activity2555 = new Lino.RemoteComboFieldElement({ "fieldLabel": "Beruf", "name": "activity", "pageSize": 20, "emptyText": "Beruf ausw\u00e4hlen...", "listeners": { "render": Lino.quicktip_renderer("Beruf","(courses.CourseProviders.activity) ") }, "selectOnFocus": true, "hiddenName": "activityHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/courses/CourseProviders/activity", "method": "GET" }) }) });
    var type2556 = new Lino.RemoteComboFieldElement({ "fieldLabel": "Organisationsart", "name": "type", "pageSize": 20, "emptyText": "Organisationsart ausw\u00e4hlen...", "listeners": { "render": Lino.quicktip_renderer("Organisationsart","(courses.CourseProviders.type) ") }, "selectOnFocus": true, "hiddenName": "typeHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/courses/CourseProviders/type", "method": "GET" }) }) });
    var intro_box_2_panel2557 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 23, "autoHeight": true, "layout": "form", "xtype": "panel", "items": vat_id2554, "labelAlign": "top" }, { "flex": 38, "autoHeight": true, "layout": "form", "xtype": "panel", "items": activity2555, "labelAlign": "top" }, { "flex": 38, "autoHeight": true, "layout": "form", "xtype": "panel", "items": type2556, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 153, "border": false, "anchor": "-20", "labelAlign": "top" });
    var bank_account12561 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Bankkonto 1","(courses.CourseProviders.bank_account1) ") }, "fieldLabel": "Bankkonto 1", "name": "bank_account1", "maxLength": 40, "selectOnFocus": true, "anchor": "-20" });
    var bank_account22562 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Bankkonto 2","(courses.CourseProviders.bank_account2) ") }, "fieldLabel": "Bankkonto 2", "name": "bank_account2", "maxLength": 40, "selectOnFocus": true, "anchor": "-20" });
    var is_obsolete2563 = new Ext.form.Checkbox({ "boxLabel": "veraltet", "listeners": { "render": Lino.quicktip_renderer("veraltet","(courses.CourseProviders.is_obsolete) Altf\u00e4lle sind Partner, deren Stammdaten nicht mehr gepflegt werden und \nf\u00fcr neue Operationen nicht benutzt werden k\u00f6nnen.") }, "hideLabel": true, "checked": false, "name": "is_obsolete", "selectOnFocus": true, "anchor": "-20" });
    var intro_box_3_panel2564 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 40, "autoHeight": true, "layout": "form", "xtype": "panel", "items": bank_account12561, "labelAlign": "top" }, { "flex": 40, "autoHeight": true, "layout": "form", "xtype": "panel", "items": bank_account22562, "labelAlign": "top" }, { "flex": 19, "autoHeight": true, "layout": "form", "xtype": "panel", "items": is_obsolete2563, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 108, "border": false, "anchor": "-20", "labelAlign": "top" });
    var intro_box_panel2568 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "form", "hideCheckBoxLabels": true, "items": [ intro_box_1_panel2549, intro_box_2_panel2557, intro_box_3_panel2564 ], "frame": true, "bodyBorder": false, "labelAlign": "top" });
    var country2569 = new Lino.TwinCombo({ "fieldLabel": "Land", "name": "country", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.countries.Countries.detail)}, "emptyText": "Land ausw\u00e4hlen...", "listeners": { "render": Lino.quicktip_renderer("Land","(courses.CourseProviders.country) ") }, "selectOnFocus": true, "hiddenName": "countryHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/courses/CourseProviders/country", "method": "GET" }) }) });
    var region2570 = new Lino.TwinCombo({ "fieldLabel": "Region", "name": "region", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.countries.Cities.detail)}, "emptyText": "Ort ausw\u00e4hlen...", "listeners": { "render": Lino.quicktip_renderer("Region","(courses.CourseProviders.region) ") }, "selectOnFocus": true, "hiddenName": "regionHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/courses/CourseProviders/region", "method": "GET" }) }) });
    var box3_1_panel2571 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": country2569, "labelAlign": "top" }, { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": region2570, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 63, "border": false, "anchor": "-20", "labelAlign": "top" });
    var city2574 = new Lino.TwinCombo({ "forceSelection": false, "fieldLabel": "Ort", "name": "city", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.countries.Cities.detail)}, "emptyText": "Ort ausw\u00e4hlen...", "listeners": { "render": Lino.quicktip_renderer("Ort","(courses.CourseProviders.city) ") }, "selectOnFocus": true, "hiddenName": "cityHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/courses/CourseProviders/city", "method": "GET" }) }) });
    var zip_code2575 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Postleitzahl","(courses.CourseProviders.zip_code) ") }, "fieldLabel": "Postleitzahl", "name": "zip_code", "maxLength": 10, "selectOnFocus": true, "boxMinWidth": Lino.chars2width(10), "anchor": "-20" });
    var box3_2_panel2576 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 66, "autoHeight": true, "layout": "form", "xtype": "panel", "items": city2574, "labelAlign": "top" }, { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": zip_code2575, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 117, "border": false, "anchor": "-20", "labelAlign": "top" });
    var street_prefix2579 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Pr\u00e4fix Stra\u00dfe","(courses.CourseProviders.street_prefix) Text to print before name of street, but to ignore for sorting.") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Pr\u00e4fix Stra\u00dfe</span>", "name": "street_prefix", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var street2580 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Stra\u00dfe","(courses.CourseProviders.street) Name of street. Without house number.") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Stra\u00dfe</span>", "name": "street", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var street_no2581 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Nr.","(courses.CourseProviders.street_no) House number") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Nr.</span>", "name": "street_no", "maxLength": 10, "selectOnFocus": true, "boxMinWidth": Lino.chars2width(10), "anchor": "-20" });
    var street_box2582 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Box","(courses.CourseProviders.street_box) Text to print after :attr:`steet_no` on the same line") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Box</span>", "name": "street_box", "maxLength": 10, "selectOnFocus": true, "boxMinWidth": Lino.chars2width(10), "anchor": "-20" });
    var box3_3_panel2583 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 30, "autoHeight": true, "layout": "form", "xtype": "panel", "items": street_prefix2579, "labelAlign": "top" }, { "flex": 36, "autoHeight": true, "layout": "form", "xtype": "panel", "items": street2580, "labelAlign": "top" }, { "flex": 16, "autoHeight": true, "layout": "form", "xtype": "panel", "items": street_no2581, "labelAlign": "top" }, { "flex": 16, "autoHeight": true, "layout": "form", "xtype": "panel", "items": street_box2582, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 126, "border": false, "anchor": "-20", "labelAlign": "top" });
    var addr22588 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Adresszeile nach Stra\u00dfe","(courses.CourseProviders.addr2) Address line to print below street line") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Adresszeile nach Stra\u00dfe</span>", "name": "addr2", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var box3_panel2589 = new Ext.Panel({ "flex": 62, "autoHeight": true, "layout": "form", "items": [ box3_1_panel2571, box3_2_panel2576, box3_3_panel2583, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": addr22588, "anchor": "-20", "labelAlign": "top" } ], "frame": true, "bodyBorder": false, "autoScroll": false, "hideCheckBoxLabels": true, "labelWidth": 216, "border": false, "labelAlign": "top" });
    var email2591 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("E-Mail","(courses.CourseProviders.email) ") }, "fieldLabel": "E-Mail", "name": "email", "maxLength": 75, "selectOnFocus": true, "anchor": "-20" });
    var url2592 = new Lino.URLField({ "listeners": { "render": Lino.quicktip_renderer("URL","(courses.CourseProviders.url) ") }, "fieldLabel": "URL", "name": "url", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var phone2593 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Telefon","(courses.CourseProviders.phone) ") }, "fieldLabel": "Telefon", "name": "phone", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var gsm2594 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("GSM","(courses.CourseProviders.gsm) ") }, "fieldLabel": "GSM", "name": "gsm", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var box4_panel2595 = new Ext.Panel({ "flex": 37, "autoHeight": true, "layout": "form", "items": [ { "autoHeight": true, "layout": "form", "xtype": "panel", "items": email2591, "anchor": "-20", "labelAlign": "top" }, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": url2592, "anchor": "-20", "labelAlign": "top" }, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": phone2593, "anchor": "-20", "labelAlign": "top" }, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": gsm2594, "anchor": "-20", "labelAlign": "top" } ], "frame": true, "bodyBorder": false, "autoScroll": false, "hideCheckBoxLabels": true, "labelWidth": 72, "border": false, "labelAlign": "top" });
    var address_box_panel2600 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "hideCheckBoxLabels": true, "items": [ box3_panel2589, box4_panel2595 ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var remarks2601 = new Ext.form.TextArea({ "listeners": { "render": Lino.quicktip_renderer("Bemerkungen","(courses.CourseProviders.remarks) ") }, "fieldLabel": "Bemerkungen", "name": "remarks", "growMax": 2000, "selectOnFocus": true, "anchor": "-20 -10" });
    var contacts_RolesByCompany_grid2602 = new Lino.contacts.RolesByCompany.GridPanel({ "flex": 42, "listeners": { "render": Lino.quicktip_renderer("Kontaktpersonen","(contacts.contacts.RolesByCompany) ") }, "hide_top_toolbar": true, "containing_panel": this, "tools": [ Lino.show_in_own_window_button(Lino.contacts.RolesByCompany.grid) ], "preview_limit": 15, "master_panel": this });
    var bottom_box_panel2603 = new Ext.Panel({ "flex": 41, "border": false, "layout": "hbox", "labelWidth": 108, "hideCheckBoxLabels": true, "items": [ { "items": remarks2601, "labelAlign": "top", "layout": "form", "xtype": "panel", "flex": 57 }, contacts_RolesByCompany_grid2602 ], "autoScroll": false, "layoutConfig": { "align": "stretch" }, "frame": false, "labelAlign": "top" });
    var general_panel2605 = new Ext.Panel({ "layout": "vbox", "title": "Allgemein", "items": [ intro_box_panel2568, address_box_panel2600, bottom_box_panel2603 ], "frame": true, "layoutConfig": { "align": "stretch" }, "hideCheckBoxLabels": true, "listeners": { "activate": Lino.on_tab_activate }, "autoScroll": false, "border": false, "bodyBorder": false, "labelAlign": "top" });
    var pcsw_NotesByCompany_grid2606 = new Lino.pcsw.NotesByCompany.GridPanel({ "listeners": { "activate": Lino.on_tab_activate }, "hide_top_toolbar": true, "containing_panel": this, "title": "Ereignisse/Notizen", "tools": [ Lino.show_in_own_window_button(Lino.pcsw.NotesByCompany.grid) ], "preview_limit": 15, "master_panel": this });
    var CourseOffersByProvider_grid2653 = new Lino.courses.CourseOffersByProvider.GridPanel({ "listeners": { "activate": Lino.on_tab_activate }, "hide_top_toolbar": true, "containing_panel": this, "title": "Kursangebote", "tools": [ Lino.show_in_own_window_button(Lino.courses.CourseOffersByProvider.grid) ], "preview_limit": 15, "master_panel": this });
    var main_panel2654 = new Ext.TabPanel({ "hideCheckBoxLabels": true, "border": false, "split": true, "autoScroll": false, "items": [ general_panel2605, pcsw_NotesByCompany_grid2606, CourseOffersByProvider_grid2653 ], "activeTab": 0, "bodyBorder": false, "frame": true, "labelAlign": "top" });
    this.items = main_panel2654;
    this.before_row_edit = function(record) {
      region2570.setContextValue('country',record ? record.data['countryHidden'] : undefined);
      city2574.setContextValue('country',record ? record.data['countryHidden'] : undefined);
      city2574.setContextValue('region',record ? record.data['regionHidden'] : undefined);
      contacts_RolesByCompany_grid2602.on_master_changed();
      pcsw_NotesByCompany_grid2606.on_master_changed();
      CourseOffersByProvider_grid2653.on_master_changed();
    }
    this.onRender = function(ct, position) {
      country2569.on('change',Lino.chooser_handler(region2570,'country'));
      country2569.on('change',Lino.chooser_handler(city2574,'country'));
      region2570.on('change',Lino.chooser_handler(city2574,'region'));
      Lino.courses.CourseProviders.DetailFormPanel.superclass.onRender.call(this, ct, position);
    }
    Lino.courses.CourseProviders.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.cbss.ManageAccessRequests.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 90,
  initComponent : function() {
    var containing_panel = this;
    var id2825 = new Ext.form.NumberField({ "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("ID","(cbss.ManageAccessRequests.id) ") }, "fieldLabel": "ID", "anchor": "-20", "name": "id" });
    var person2826 = new Lino.TwinCombo({ "preferred_width": 20, "fieldLabel": "Klient", "allowBlank": false, "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.pcsw.Clients.detail)}, "emptyText": "Klient ausw\u00e4hlen...", "listeners": { "render": Lino.quicktip_renderer("Klient","(cbss.ManageAccessRequests.person) ") }, "selectOnFocus": true, "hiddenName": "personHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cbss/ManageAccessRequests/person", "method": "GET" }) }), "name": "person" });
    var user2827 = new Lino.TwinCombo({ "preferred_width": 15, "fieldLabel": "Autor", "allowBlank": false, "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.users.Users.detail)}, "emptyText": "Benutzer ausw\u00e4hlen...", "listeners": { "render": Lino.quicktip_renderer("Autor","(cbss.ManageAccessRequests.user) ") }, "selectOnFocus": true, "hiddenName": "userHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cbss/ManageAccessRequests/user", "method": "GET" }) }), "name": "user" });
    var environment2828 = new Ext.form.TextField({ "disabled": true, "listeners": { "render": Lino.quicktip_renderer("T/A/B","(cbss.ManageAccessRequests.environment) ") }, "fieldLabel": "T/A/B", "name": "environment", "maxLength": 4, "boxMinWidth": Lino.chars2width(4), "anchor": "-20" });
    var sent2829 = new Ext.form.DisplayField({ "disabled": true, "listeners": { "render": Lino.quicktip_renderer("Versendet","(cbss.ManageAccessRequests.sent) The date and time when this request has been executed. \nThis is empty for requests than haven't been sent.\nRead-only.") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Versendet</span>", "name": "sent", "anchor": "-20", "value": "<br>" });
    var status2830 = new Lino.ChoicesFieldElement({ "forceSelection": true, "fieldLabel": "Zustand", "name": "status", "hiddenName": "statusHidden", "disabled": true, "listeners": { "render": Lino.quicktip_renderer("Zustand","(cbss.ManageAccessRequests.status) ") }, "anchor": "-20", "store": [['','<br>']].concat(Lino.cbss.RequestStates) });
    var ticket2831 = new Ext.form.TextField({ "disabled": true, "listeners": { "render": Lino.quicktip_renderer("Ticket","(cbss.ManageAccessRequests.ticket) ") }, "fieldLabel": "Ticket", "name": "ticket", "maxLength": 36, "anchor": "-20" });
    var info_1_panel2832 = new Ext.form.FieldSet({ "autoHeight": true, "layout": "hbox", "title": "Info zur Anfrage", "layoutConfig": { "align": "stretchmax" }, "frame": false, "bodyBorder": true, "autoScroll": false, "items": [ { "flex": 5, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id2825, "labelAlign": "top" }, { "flex": 20, "autoHeight": true, "layout": "form", "xtype": "panel", "items": person2826, "labelAlign": "top" }, { "flex": 20, "autoHeight": true, "layout": "form", "xtype": "panel", "items": user2827, "labelAlign": "top" }, { "flex": 5, "autoHeight": true, "layout": "form", "xtype": "panel", "items": environment2828, "labelAlign": "top" }, { "flex": 16, "autoHeight": true, "layout": "form", "xtype": "panel", "items": sent2829, "labelAlign": "top" }, { "flex": 12, "autoHeight": true, "layout": "form", "xtype": "panel", "items": status2830, "labelAlign": "top" }, { "flex": 21, "autoHeight": true, "layout": "form", "xtype": "panel", "items": ticket2831, "labelAlign": "top" } ], "hideCheckBoxLabels": true, "labelWidth": 90, "border": false, "labelAlign": "top" });
    var action2840 = new Lino.ChoicesFieldElement({ "forceSelection": true, "fieldLabel": "Aktion", "allowBlank": false, "hiddenName": "actionHidden", "listeners": { "render": Lino.quicktip_renderer("Aktion","(cbss.ManageAccessRequests.action) ") }, "selectOnFocus": true, "anchor": "-20", "store": Lino.cbss.ManageAction, "name": "action" });
    var start_date2841 = new Lino.DateField({ "listeners": { "render": Lino.quicktip_renderer("Periode vom","(cbss.ManageAccessRequests.start_date) ") }, "fieldLabel": "Periode vom", "name": "start_date", "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var end_date2842 = new Lino.DateField({ "listeners": { "render": Lino.quicktip_renderer("Periode bis","(cbss.ManageAccessRequests.end_date) ") }, "fieldLabel": "Periode bis", "name": "end_date", "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var p1_1_panel2843 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 44, "autoHeight": true, "layout": "form", "xtype": "panel", "items": action2840, "labelAlign": "top" }, { "flex": 27, "autoHeight": true, "layout": "form", "xtype": "panel", "items": start_date2841, "labelAlign": "top" }, { "flex": 27, "autoHeight": true, "layout": "form", "xtype": "panel", "items": end_date2842, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 108, "border": false, "anchor": "-20", "labelAlign": "top" });
    var purpose2847 = new Lino.RemoteComboFieldElement({ "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Eigenschafts-Code</span>", "allowBlank": false, "pageSize": 20, "emptyText": "Eigenschafts-Code ausw\u00e4hlen...", "listeners": { "render": Lino.quicktip_renderer("Eigenschafts-Code","(cbss.ManageAccessRequests.purpose) The purpose for which the inscription needs to be \nregistered/unregistered or listed. \nFor listing this field is optional, \nfor register/unregister it is mandatory.") }, "selectOnFocus": true, "hiddenName": "purposeHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cbss/ManageAccessRequests/purpose", "method": "GET" }) }), "name": "purpose" });
    var query_register2848 = new Lino.ChoicesFieldElement({ "forceSelection": true, "fieldLabel": "Abfrageregister", "allowBlank": false, "hiddenName": "query_registerHidden", "listeners": { "render": Lino.quicktip_renderer("Abfrageregister","(cbss.ManageAccessRequests.query_register) ") }, "selectOnFocus": true, "anchor": "-20", "store": Lino.cbss.QueryRegister, "name": "query_register" });
    var p1_2_panel2849 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 62, "autoHeight": true, "layout": "form", "xtype": "panel", "items": purpose2847, "labelAlign": "top" }, { "flex": 37, "autoHeight": true, "layout": "form", "xtype": "panel", "items": query_register2848, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 162, "border": false, "anchor": "-20", "labelAlign": "top" });
    var p1_panel2852 = new Ext.form.FieldSet({ "flex": 37, "autoHeight": true, "layout": "form", "title": "Angefragte Aktion", "items": [ p1_1_panel2843, p1_2_panel2849 ], "frame": true, "bodyBorder": false, "autoScroll": false, "hideCheckBoxLabels": true, "border": false, "labelAlign": "top" });
    var national_id2853 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("NR-Nummer","(cbss.ManageAccessRequests.national_id) The SSIN of the person to register/unregister/list.\n") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">NR-Nummer</span>", "name": "national_id", "maxLength": 200, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var sis_card_no2854 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("SIS-Karten-Nr","(cbss.ManageAccessRequests.sis_card_no) The number of the SIS card used to authenticate the person.") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">SIS-Karten-Nr</span>", "name": "sis_card_no", "maxLength": 10, "selectOnFocus": true, "boxMinWidth": Lino.chars2width(10), "anchor": "-20" });
    var id_card_no2855 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("ID-Karten-Nr","(cbss.ManageAccessRequests.id_card_no) The number of the ID card used to authenticate the person.") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">ID-Karten-Nr</span>", "name": "id_card_no", "maxLength": 20, "selectOnFocus": true, "anchor": "-20" });
    var proof_1_panel2856 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 39, "autoHeight": true, "layout": "form", "xtype": "panel", "items": national_id2853, "labelAlign": "top" }, { "flex": 20, "autoHeight": true, "layout": "form", "xtype": "panel", "items": sis_card_no2854, "labelAlign": "top" }, { "flex": 39, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id_card_no2855, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 126, "border": false, "anchor": "-20", "labelAlign": "top" });
    var first_name2860 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Vorname","(cbss.ManageAccessRequests.first_name) ") }, "fieldLabel": "Vorname", "name": "first_name", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var last_name2861 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Familienname","(cbss.ManageAccessRequests.last_name) ") }, "fieldLabel": "Familienname", "name": "last_name", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var birth_date2862 = new Lino.IncompleteDateField({ "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Geburtsdatum","(cbss.ManageAccessRequests.birth_date) Uncomplete dates are allowed, e.g. \n\"00.00.1980\" means \"some day in 1980\", \n\"00.07.1980\" means \"in July 1980\"\nor \"23.07.0000\" means \"on a 23th of July\".") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Geburtsdatum</span>", "anchor": "-20", "name": "birth_date" });
    var proof_2_panel2863 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 38, "autoHeight": true, "layout": "form", "xtype": "panel", "items": first_name2860, "labelAlign": "top" }, { "flex": 38, "autoHeight": true, "layout": "form", "xtype": "panel", "items": last_name2861, "labelAlign": "top" }, { "flex": 22, "autoHeight": true, "layout": "form", "xtype": "panel", "items": birth_date2862, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 117, "border": false, "anchor": "-20", "labelAlign": "top" });
    var proof_panel2867 = new Ext.form.FieldSet({ "flex": 62, "autoHeight": true, "layout": "form", "title": "Authentifizierungsbeleg", "items": [ proof_1_panel2856, proof_2_panel2863 ], "frame": true, "bodyBorder": false, "autoScroll": false, "hideCheckBoxLabels": true, "border": false, "labelAlign": "top" });
    var parameters_panel2868 = new Ext.form.FieldSet({ "autoHeight": true, "layout": "hbox", "title": "Parameter", "layoutConfig": { "align": "stretchmax" }, "frame": false, "bodyBorder": true, "autoScroll": false, "items": [ p1_panel2852, proof_panel2867 ], "hideCheckBoxLabels": true, "border": false, "labelAlign": "top" });
    var result_htmlbox2869 = new Lino.HtmlBoxPanel({ "flex": 50, "layout": "fit", "name": "result", "containing_panel": this, "master_panel": this, "items": new Ext.BoxComponent({autoScroll:true}), "title": "Resultat", "bodyStyle": "overflow-x:hidden;", "value": "<br/>", "always_enabled": true, "listeners": { "render": Lino.quicktip_renderer("Resultat","(cbss.ManageAccessRequests.result) ") } });
    var request_panel2870 = new Ext.Panel({ "layout": "vbox", "title": "Abfrage", "items": [ info_1_panel2832, parameters_panel2868, result_htmlbox2869 ], "frame": true, "layoutConfig": { "align": "stretch" }, "hideCheckBoxLabels": true, "listeners": { "activate": Lino.on_tab_activate }, "autoScroll": false, "labelWidth": 81, "border": false, "bodyBorder": false, "labelAlign": "top" });
    var main_panel2878 = new Ext.TabPanel({ "hideCheckBoxLabels": true, "border": false, "split": true, "autoScroll": false, "items": [ request_panel2870 ], "activeTab": 0, "bodyBorder": false, "frame": true, "labelAlign": "top" });
    this.items = main_panel2878;
    this.before_row_edit = function(record) {
      purpose2847.setContextValue('sector',record ? record.data['sectorHidden'] : undefined);
      result_htmlbox2869.refresh();
    }
    Lino.cbss.ManageAccessRequests.DetailFormPanel.superclass.initComponent.call(this);
    // active_fields:
    person2826.on("change",function(){this.save()},this);
  }
});


Lino.jobs.OldJobsOverview.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  disable_editing: true,
  initComponent : function() {
    var containing_panel = this;
    var body_htmlbox3041 = new Lino.HtmlBoxPanel({ "layout": "fit", "name": "body", "containing_panel": this, "master_panel": this, "items": new Ext.BoxComponent({autoScroll:true}), "bodyStyle": "overflow-x:hidden;", "value": "<br/>", "always_enabled": true, "listeners": { "render": Lino.quicktip_renderer(null,"(jobs.OldJobsOverview.body) ") } });
    var main_panel3042 = new Ext.Panel({ "autoScroll": false, "border": false, "layout": "fit", "labelWidth": 0, "hideCheckBoxLabels": true, "items": [ body_htmlbox3041 ], "frame": true, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel3042;
    this.before_row_edit = function(record) {
      body_htmlbox3041.refresh();
    }
    Lino.jobs.OldJobsOverview.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.cbss.ManageAccessRequests.InsertFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  autoHeight: true,
  content_type: 90,
  initComponent : function() {
    var containing_panel = this;
    var person2879 = new Lino.TwinCombo({ "preferred_width": 20, "fieldLabel": "Klient", "allowBlank": false, "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.pcsw.Clients.detail)}, "emptyText": "Klient ausw\u00e4hlen...", "listeners": { "render": Lino.quicktip_renderer("Klient","(cbss.ManageAccessRequests.person) ") }, "selectOnFocus": true, "hiddenName": "personHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cbss/ManageAccessRequests/person", "method": "GET" }) }), "name": "person" });
    var action2880 = new Lino.ChoicesFieldElement({ "forceSelection": true, "fieldLabel": "Aktion", "allowBlank": false, "hiddenName": "actionHidden", "listeners": { "render": Lino.quicktip_renderer("Aktion","(cbss.ManageAccessRequests.action) ") }, "selectOnFocus": true, "anchor": "-20", "store": Lino.cbss.ManageAction, "name": "action" });
    var start_date2881 = new Lino.DateField({ "listeners": { "render": Lino.quicktip_renderer("Periode vom","(cbss.ManageAccessRequests.start_date) ") }, "fieldLabel": "Periode vom", "name": "start_date", "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var end_date2882 = new Lino.DateField({ "listeners": { "render": Lino.quicktip_renderer("Periode bis","(cbss.ManageAccessRequests.end_date) ") }, "fieldLabel": "Periode bis", "name": "end_date", "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var p1_1_panel2883 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 44, "autoHeight": true, "layout": "form", "xtype": "panel", "items": action2880, "labelAlign": "top" }, { "flex": 27, "autoHeight": true, "layout": "form", "xtype": "panel", "items": start_date2881, "labelAlign": "top" }, { "flex": 27, "autoHeight": true, "layout": "form", "xtype": "panel", "items": end_date2882, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 108, "border": false, "anchor": "-20", "labelAlign": "top" });
    var purpose2887 = new Lino.RemoteComboFieldElement({ "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Eigenschafts-Code</span>", "allowBlank": false, "pageSize": 20, "emptyText": "Eigenschafts-Code ausw\u00e4hlen...", "listeners": { "render": Lino.quicktip_renderer("Eigenschafts-Code","(cbss.ManageAccessRequests.purpose) The purpose for which the inscription needs to be \nregistered/unregistered or listed. \nFor listing this field is optional, \nfor register/unregister it is mandatory.") }, "selectOnFocus": true, "hiddenName": "purposeHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cbss/ManageAccessRequests/purpose", "method": "GET" }) }), "name": "purpose" });
    var query_register2888 = new Lino.ChoicesFieldElement({ "forceSelection": true, "fieldLabel": "Abfrageregister", "allowBlank": false, "hiddenName": "query_registerHidden", "listeners": { "render": Lino.quicktip_renderer("Abfrageregister","(cbss.ManageAccessRequests.query_register) ") }, "selectOnFocus": true, "anchor": "-20", "store": Lino.cbss.QueryRegister, "name": "query_register" });
    var p1_2_panel2889 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 62, "autoHeight": true, "layout": "form", "xtype": "panel", "items": purpose2887, "labelAlign": "top" }, { "flex": 37, "autoHeight": true, "layout": "form", "xtype": "panel", "items": query_register2888, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 162, "border": false, "anchor": "-20", "labelAlign": "top" });
    var p1_panel2892 = new Ext.form.FieldSet({ "autoHeight": true, "layout": "form", "title": "Angefragte Aktion", "items": [ p1_1_panel2883, p1_2_panel2889 ], "frame": true, "bodyBorder": false, "autoScroll": false, "hideCheckBoxLabels": true, "border": false, "anchor": "-20", "labelAlign": "top" });
    var national_id2893 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("NR-Nummer","(cbss.ManageAccessRequests.national_id) The SSIN of the person to register/unregister/list.\n") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">NR-Nummer</span>", "name": "national_id", "maxLength": 200, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var sis_card_no2894 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("SIS-Karten-Nr","(cbss.ManageAccessRequests.sis_card_no) The number of the SIS card used to authenticate the person.") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">SIS-Karten-Nr</span>", "name": "sis_card_no", "maxLength": 10, "selectOnFocus": true, "boxMinWidth": Lino.chars2width(10), "anchor": "-20" });
    var id_card_no2895 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("ID-Karten-Nr","(cbss.ManageAccessRequests.id_card_no) The number of the ID card used to authenticate the person.") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">ID-Karten-Nr</span>", "name": "id_card_no", "maxLength": 20, "selectOnFocus": true, "anchor": "-20" });
    var proof_1_panel2896 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 39, "autoHeight": true, "layout": "form", "xtype": "panel", "items": national_id2893, "labelAlign": "top" }, { "flex": 20, "autoHeight": true, "layout": "form", "xtype": "panel", "items": sis_card_no2894, "labelAlign": "top" }, { "flex": 39, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id_card_no2895, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 126, "border": false, "anchor": "-20", "labelAlign": "top" });
    var first_name2900 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Vorname","(cbss.ManageAccessRequests.first_name) ") }, "fieldLabel": "Vorname", "name": "first_name", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var last_name2901 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Familienname","(cbss.ManageAccessRequests.last_name) ") }, "fieldLabel": "Familienname", "name": "last_name", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var birth_date2902 = new Lino.IncompleteDateField({ "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Geburtsdatum","(cbss.ManageAccessRequests.birth_date) Uncomplete dates are allowed, e.g. \n\"00.00.1980\" means \"some day in 1980\", \n\"00.07.1980\" means \"in July 1980\"\nor \"23.07.0000\" means \"on a 23th of July\".") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Geburtsdatum</span>", "anchor": "-20", "name": "birth_date" });
    var proof_2_panel2903 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 38, "autoHeight": true, "layout": "form", "xtype": "panel", "items": first_name2900, "labelAlign": "top" }, { "flex": 38, "autoHeight": true, "layout": "form", "xtype": "panel", "items": last_name2901, "labelAlign": "top" }, { "flex": 22, "autoHeight": true, "layout": "form", "xtype": "panel", "items": birth_date2902, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 117, "border": false, "anchor": "-20", "labelAlign": "top" });
    var proof_panel2907 = new Ext.form.FieldSet({ "autoHeight": true, "layout": "form", "title": "Authentifizierungsbeleg", "items": [ proof_1_panel2896, proof_2_panel2903 ], "frame": true, "bodyBorder": false, "autoScroll": false, "hideCheckBoxLabels": true, "border": false, "anchor": "-20", "labelAlign": "top" });
    var main_panel2908 = new Ext.Panel({ "hideCheckBoxLabels": true, "autoHeight": true, "border": false, "layout": "form", "labelWidth": 63, "autoScroll": false, "items": [ { "autoHeight": true, "layout": "form", "xtype": "panel", "items": person2879, "anchor": "-20", "labelAlign": "top" }, p1_panel2892, proof_panel2907 ], "frame": true, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel2908;
    this.before_row_edit = function(record) {
      purpose2887.setContextValue('sector',record ? record.data['sectorHidden'] : undefined);
    }
    Lino.cbss.ManageAccessRequests.InsertFormPanel.superclass.initComponent.call(this);
    // active_fields:
    person2879.on("change",function(){this.save()},this);
  }
});


Lino.cbss.RetrieveTIGroupsRequests.InsertFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  autoHeight: true,
  content_type: 89,
  initComponent : function() {
    var containing_panel = this;
    var person2947 = new Lino.TwinCombo({ "preferred_width": 20, "fieldLabel": "Klient", "allowBlank": false, "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.pcsw.Clients.detail)}, "emptyText": "Klient ausw\u00e4hlen...", "listeners": { "render": Lino.quicktip_renderer("Klient","(cbss.RetrieveTIGroupsRequests.person) ") }, "selectOnFocus": true, "hiddenName": "personHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cbss/RetrieveTIGroupsRequests/person", "method": "GET" }) }), "name": "person" });
    var national_id2948 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("NR-Nummer","(cbss.RetrieveTIGroupsRequests.national_id) ") }, "fieldLabel": "NR-Nummer", "name": "national_id", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var language2949 = new Lino.ChoicesFieldElement({ "forceSelection": true, "fieldLabel": "Sprache", "name": "language", "hiddenName": "languageHidden", "listeners": { "render": Lino.quicktip_renderer("Sprache","(cbss.RetrieveTIGroupsRequests.language) ") }, "selectOnFocus": true, "anchor": "-20", "store": [['','<br>']].concat(Lino.cbss.RequestLanguages) });
    var main_2_panel2950 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 70, "autoHeight": true, "layout": "form", "xtype": "panel", "items": national_id2948, "labelAlign": "top" }, { "flex": 30, "autoHeight": true, "layout": "form", "xtype": "panel", "items": language2949, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 90, "border": false, "anchor": "-20", "labelAlign": "top" });
    var history2953 = new Ext.form.Checkbox({ "boxLabel": "Historie", "listeners": { "render": Lino.quicktip_renderer("Historie","(cbss.RetrieveTIGroupsRequests.history) Whatever this means.") }, "hideLabel": true, "checked": true, "name": "history", "selectOnFocus": true, "anchor": "-20" });
    var main_panel2954 = new Ext.Panel({ "hideCheckBoxLabels": true, "autoHeight": true, "border": false, "layout": "form", "labelWidth": 81, "autoScroll": false, "items": [ { "autoHeight": true, "layout": "form", "xtype": "panel", "items": person2947, "anchor": "-20", "labelAlign": "top" }, main_2_panel2950, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": history2953, "anchor": "-20", "labelAlign": "top" } ], "frame": true, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel2954;
    this.before_row_edit = function(record) {
    }
    Lino.cbss.RetrieveTIGroupsRequests.InsertFormPanel.superclass.initComponent.call(this);
  }
});


Lino.contacts.Persons.InsertFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  autoHeight: true,
  content_type: 20,
  initComponent : function() {
    var containing_panel = this;
    var title893 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Anrede","(contacts.Persons.title) ") }, "fieldLabel": "Anrede", "name": "title", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var first_name894 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Vorname","(contacts.Persons.first_name) ") }, "fieldLabel": "Vorname", "name": "first_name", "maxLength": 200, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var last_name895 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Familienname","(contacts.Persons.last_name) ") }, "fieldLabel": "Familienname", "name": "last_name", "maxLength": 200, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var main_1_panel896 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": title893, "labelAlign": "top" }, { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": first_name894, "labelAlign": "top" }, { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": last_name895, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 117, "border": false, "anchor": "-20", "labelAlign": "top" });
    var gender900 = new Lino.ChoicesFieldElement({ "forceSelection": true, "fieldLabel": "Geschlecht", "name": "gender", "hiddenName": "genderHidden", "listeners": { "render": Lino.quicktip_renderer("Geschlecht","(contacts.Persons.gender) ") }, "selectOnFocus": true, "anchor": "-20", "store": [['','<br>']].concat(Lino.lino.Genders) });
    var language901 = new Lino.ChoicesFieldElement({ "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Sprache</span>", "allowBlank": false, "hiddenName": "languageHidden", "listeners": { "render": Lino.quicktip_renderer("Sprache","(contacts.Persons.language) Die Sprache, in der Dokumente ausgestellt werden sollen.") }, "selectOnFocus": true, "anchor": "-20", "store": [ [ "en", "Englisch" ], [ "fr", "Franz\u00f6sisch" ], [ "de", "Deutsch" ], [ "nl", "Niederl\u00e4ndisch" ] ], "name": "language" });
    var main_2_panel902 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 31, "autoHeight": true, "layout": "form", "xtype": "panel", "items": gender900, "labelAlign": "top" }, { "flex": 68, "autoHeight": true, "layout": "form", "xtype": "panel", "items": language901, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 99, "border": false, "anchor": "-20", "labelAlign": "top" });
    var main_panel905 = new Ext.Panel({ "hideCheckBoxLabels": true, "autoHeight": true, "border": false, "layout": "form", "autoScroll": false, "items": [ main_1_panel896, main_2_panel902 ], "frame": true, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel905;
    this.before_row_edit = function(record) {
    }
    Lino.contacts.Persons.InsertFormPanel.superclass.initComponent.call(this);
  }
});


Lino.courses.CourseRequests.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 77,
  initComponent : function() {
    var containing_panel = this;
    var date_submitted2248 = new Lino.DateField({ "listeners": { "render": Lino.quicktip_renderer("Anfragedatum","(courses.CourseRequests.date_submitted) Datum, an dem die Anfrage erstellt wurde.") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Anfragedatum</span>", "name": "date_submitted", "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var person2249 = new Lino.TwinCombo({ "preferred_width": 20, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Klient</span>", "allowBlank": false, "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.pcsw.Clients.detail)}, "emptyText": "Klient ausw\u00e4hlen...", "listeners": { "render": Lino.quicktip_renderer("Klient","(courses.CourseRequests.person) Le client qui d\u00e9sire suivre un cours.") }, "selectOnFocus": true, "hiddenName": "personHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/courses/CourseRequests/person", "method": "GET" }) }), "name": "person" });
    var content2250 = new Lino.TwinCombo({ "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Kursinhalt</span>", "allowBlank": false, "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.courses.CourseContents.detail)}, "emptyText": "Kursinhalt ausw\u00e4hlen...", "listeners": { "render": Lino.quicktip_renderer("Kursinhalt","(courses.CourseRequests.content) Der gew\u00fcnschte Kursinhalt.)") }, "selectOnFocus": true, "hiddenName": "contentHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/courses/CourseRequests/content", "method": "GET" }) }), "name": "content" });
    var offer2251 = new Lino.TwinCombo({ "fieldLabel": "Kursangebot", "name": "offer", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.courses.CourseOffers.detail)}, "emptyText": "Kursangebot ausw\u00e4hlen...", "listeners": { "render": Lino.quicktip_renderer("Kursangebot","(courses.CourseRequests.offer) ") }, "selectOnFocus": true, "hiddenName": "offerHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/courses/CourseRequests/offer", "method": "GET" }) }) });
    var urgent2252 = new Ext.form.Checkbox({ "boxLabel": "professionelle Eingliederung", "listeners": { "render": Lino.quicktip_renderer("professionelle Eingliederung","(courses.CourseRequests.urgent) Ankreuzen, wenn der Kurs f\u00fcr die Arbeitssuche ben\u00f6tigt wird.") }, "hideLabel": true, "checked": false, "name": "urgent", "selectOnFocus": true, "anchor": "-20" });
    var main_1_panel2253 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 261, "hideCheckBoxLabels": true, "items": [ { "flex": 10, "autoHeight": true, "layout": "form", "xtype": "panel", "items": date_submitted2248, "labelAlign": "top" }, { "flex": 25, "autoHeight": true, "layout": "form", "xtype": "panel", "items": person2249, "labelAlign": "top" }, { "flex": 25, "autoHeight": true, "layout": "form", "xtype": "panel", "items": content2250, "labelAlign": "top" }, { "flex": 25, "autoHeight": true, "layout": "form", "xtype": "panel", "items": offer2251, "labelAlign": "top" }, { "flex": 12, "autoHeight": true, "layout": "form", "xtype": "panel", "items": urgent2252, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var course2259 = new Lino.TwinCombo({ "fieldLabel": "Kurs gefunden", "name": "course", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.courses.Courses.detail)}, "emptyText": "Kurs ausw\u00e4hlen...", "listeners": { "render": Lino.quicktip_renderer("Kurs gefunden","(courses.CourseRequests.course) ") }, "selectOnFocus": true, "hiddenName": "courseHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/courses/CourseRequests/course", "method": "GET" }) }) });
    var state2260 = new Lino.ChoicesFieldElement({ "forceSelection": true, "fieldLabel": "Zustand", "allowBlank": false, "hiddenName": "stateHidden", "listeners": { "render": Lino.quicktip_renderer("Zustand","(courses.CourseRequests.state) ") }, "selectOnFocus": true, "anchor": "-20", "store": Lino.courses.CourseRequestStates, "name": "state" });
    var date_ended2261 = new Lino.DateField({ "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Enddatum","(courses.CourseRequests.date_ended) ") }, "fieldLabel": "Enddatum", "anchor": "-20", "name": "date_ended" });
    var id2262 = new Ext.form.NumberField({ "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("ID","(courses.CourseRequests.id) ") }, "fieldLabel": "ID", "anchor": "-20", "name": "id" });
    var main_2_panel2263 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 126, "hideCheckBoxLabels": true, "items": [ { "flex": 40, "autoHeight": true, "layout": "form", "xtype": "panel", "items": course2259, "labelAlign": "top" }, { "flex": 26, "autoHeight": true, "layout": "form", "xtype": "panel", "items": state2260, "labelAlign": "top" }, { "flex": 16, "autoHeight": true, "layout": "form", "xtype": "panel", "items": date_ended2261, "labelAlign": "top" }, { "flex": 16, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id2262, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var remark2268 = new Ext.form.TextArea({ "listeners": { "render": Lino.quicktip_renderer("Bemerkung","(courses.CourseRequests.remark) ") }, "fieldLabel": "Bemerkung", "name": "remark", "growMax": 2000, "selectOnFocus": true, "anchor": "-20 -10" });
    var UploadsByController_htmlbox2269 = new Lino.HtmlBoxPanel({ "flex": 33, "ls_bbar_actions": [ { "itemId": "insert", "menu_item_text": "Neu", "must_save": true, "tooltip": "Neuen Datensatz erstellen", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-new", "overflowText": "Neu", "auto_save": true } ], "name": "UploadsByController", "containing_panel": this, "items": new Ext.BoxComponent({autoScroll:true}), "title": "Uploads", "master_panel": this, "value": "<br/>", "always_enabled": true, "listeners": { "render": Lino.quicktip_renderer("Uploads","(courses.CourseRequests.UploadsByController) ") }, "bodyStyle": "overflow-x:hidden;", "ls_insert_handler": Lino.uploads.UploadsByController.insert, "layout": "fit", "tools": [ Lino.show_in_own_window_button(Lino.uploads.UploadsByController.grid) ] });
    var main_3_panel2270 = new Ext.Panel({ "flex": 71, "border": false, "layout": "hbox", "labelWidth": 90, "hideCheckBoxLabels": true, "items": [ { "items": remark2268, "labelAlign": "top", "layout": "form", "xtype": "panel", "flex": 66 }, UploadsByController_htmlbox2269 ], "autoScroll": false, "layoutConfig": { "align": "stretch" }, "frame": false, "labelAlign": "top" });
    var main_panel2272 = new Ext.Panel({ "autoScroll": false, "border": false, "layout": "vbox", "hideCheckBoxLabels": true, "items": [ main_1_panel2253, main_2_panel2263, main_3_panel2270 ], "frame": true, "layoutConfig": { "align": "stretch" }, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel2272;
    this.before_row_edit = function(record) {
      offer2251.setContextValue('content',record ? record.data['contentHidden'] : undefined);
      UploadsByController_htmlbox2269.refresh();
    }
    this.onRender = function(ct, position) {
      content2250.on('change',Lino.chooser_handler(offer2251,'content'));
      Lino.courses.CourseRequests.DetailFormPanel.superclass.onRender.call(this, ct, position);
    }
    Lino.courses.CourseRequests.DetailFormPanel.superclass.initComponent.call(this);
    // active_fields:
    offer2251.on("change",function(){this.save()},this);
  }
});


Lino.outbox.Mails.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 26,
  initComponent : function() {
    var containing_panel = this;
    var subject734 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Betreff","(outbox.Mails.subject) ") }, "fieldLabel": "Betreff", "name": "subject", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var project735 = new Lino.TwinCombo({ "preferred_width": 20, "fieldLabel": "Klient", "name": "project", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.pcsw.Clients.detail)}, "hiddenName": "projectHidden", "listeners": { "render": Lino.quicktip_renderer("Klient","(outbox.Mails.project) ") }, "selectOnFocus": true, "emptyText": "Klient ausw\u00e4hlen...", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/outbox/Mails/project", "method": "GET" }) }) });
    var date736 = new Lino.DateField({ "listeners": { "render": Lino.quicktip_renderer("Datum","(outbox.Mails.date) \n        The official date to be printed on the document.\n        ") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Datum</span>", "name": "date", "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var main_1_panel737 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 72, "hideCheckBoxLabels": true, "items": [ { "flex": 42, "autoHeight": true, "layout": "form", "xtype": "panel", "items": subject734, "labelAlign": "top" }, { "flex": 40, "autoHeight": true, "layout": "form", "xtype": "panel", "items": project735, "labelAlign": "top" }, { "flex": 16, "autoHeight": true, "layout": "form", "xtype": "panel", "items": date736, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var user741 = new Lino.TwinCombo({ "preferred_width": 15, "fieldLabel": "Absender", "name": "user", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.users.Users.detail)}, "hiddenName": "userHidden", "listeners": { "render": Lino.quicktip_renderer("Absender","(outbox.Mails.user) ") }, "selectOnFocus": true, "emptyText": "Benutzer ausw\u00e4hlen...", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/outbox/Mails/user", "method": "GET" }) }) });
    var sent742 = new Ext.form.DisplayField({ "disabled": true, "listeners": { "render": Lino.quicktip_renderer("sent","(outbox.Mails.sent) ") }, "fieldLabel": "sent", "name": "sent", "anchor": "-20", "value": "<br>" });
    var id743 = new Ext.form.NumberField({ "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("ID","(outbox.Mails.id) ") }, "fieldLabel": "ID", "anchor": "-20", "name": "id" });
    var owner_disp744 = new Ext.form.DisplayField({ "disabled": true, "fieldLabel": "Verkn\u00fcpft mit", "anchor": "-20", "name": "owner" });
    var main_2_panel745 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 126, "hideCheckBoxLabels": true, "items": [ { "flex": 39, "autoHeight": true, "layout": "form", "xtype": "panel", "items": user741, "labelAlign": "top" }, { "flex": 31, "autoHeight": true, "layout": "form", "xtype": "panel", "items": sent742, "labelAlign": "top" }, { "flex": 9, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id743, "labelAlign": "top" }, { "flex": 19, "autoHeight": true, "layout": "form", "xtype": "panel", "items": owner_disp744, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var RecipientsByMail_grid756 = new Lino.outbox.RecipientsByMail.GridPanel({ "flex": 55, "listeners": { "render": Lino.quicktip_renderer("Empf\u00e4nger","(outbox.outbox.RecipientsByMail) ") }, "hide_top_toolbar": true, "containing_panel": this, "tools": [ Lino.show_in_own_window_button(Lino.outbox.RecipientsByMail.grid) ], "preview_limit": 15, "master_panel": this });
    var AttachmentsByMail_htmlbox757 = new Lino.HtmlBoxPanel({ "flex": 22, "layout": "fit", "name": "AttachmentsByMail", "containing_panel": this, "items": new Ext.BoxComponent({autoScroll:true}), "title": "Anh\u00e4nge", "master_panel": this, "value": "<br/>", "always_enabled": true, "listeners": { "render": Lino.quicktip_renderer("Anh\u00e4nge","(outbox.Mails.AttachmentsByMail) ") }, "bodyStyle": "overflow-x:hidden;", "tools": [ Lino.show_in_own_window_button(Lino.outbox.AttachmentsByMail.grid) ] });
    var UploadsByController_htmlbox758 = new Lino.HtmlBoxPanel({ "flex": 22, "ls_bbar_actions": [ { "itemId": "insert", "menu_item_text": "Neu", "must_save": true, "tooltip": "Neuen Datensatz erstellen", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-new", "overflowText": "Neu", "auto_save": true } ], "name": "UploadsByController", "containing_panel": this, "items": new Ext.BoxComponent({autoScroll:true}), "title": "Uploads", "master_panel": this, "value": "<br/>", "always_enabled": true, "listeners": { "render": Lino.quicktip_renderer("Uploads","(outbox.Mails.UploadsByController) ") }, "bodyStyle": "overflow-x:hidden;", "ls_insert_handler": Lino.uploads.UploadsByController.insert, "layout": "fit", "tools": [ Lino.show_in_own_window_button(Lino.uploads.UploadsByController.grid) ] });
    var main_3_panel759 = new Ext.Panel({ "flex": 29, "border": false, "layout": "hbox", "labelWidth": 72, "hideCheckBoxLabels": true, "items": [ RecipientsByMail_grid756, AttachmentsByMail_htmlbox757, UploadsByController_htmlbox758 ], "autoScroll": false, "layoutConfig": { "align": "stretch" }, "frame": false, "labelAlign": "top" });
    var body760 = new Lino.RichTextPanel({ "selectOnFocus": true, "flex": 58, "containing_panel": this, "name": "body", "title": "Inhalt" });
    var main_panel761 = new Ext.Panel({ "autoScroll": false, "border": false, "layout": "vbox", "labelWidth": 0, "hideCheckBoxLabels": true, "items": [ main_1_panel737, main_2_panel745, main_3_panel759, body760 ], "frame": true, "layoutConfig": { "align": "stretch" }, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel761;
    this.before_row_edit = function(record) {
      RecipientsByMail_grid756.on_master_changed();
      AttachmentsByMail_htmlbox757.refresh();
      UploadsByController_htmlbox758.refresh();
      body760.refresh();
    }
    Lino.outbox.Mails.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.cal.Calendars.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 33,
  initComponent : function() {
    var containing_panel = this;
    var type912 = new Lino.ChoicesFieldElement({ "fieldLabel": "Art", "allowBlank": false, "value": "local", "hiddenName": "typeHidden", "listeners": { "render": Lino.quicktip_renderer("Art","(cal.Calendars.type) ") }, "selectOnFocus": true, "anchor": "-20", "store": [ [ "local", "Local Calendar" ], [ "google", "Google Calendar" ] ], "name": "type" });
    var name913 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Bezeichnung","(cal.Calendars.name) ") }, "fieldLabel": "Bezeichnung", "name": "name", "maxLength": 200, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var name_fr914 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Bezeichnung (fr)","(cal.Calendars.name_fr) ") }, "fieldLabel": "Bezeichnung (fr)", "name": "name_fr", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var name_de915 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Bezeichnung (de)","(cal.Calendars.name_de) ") }, "fieldLabel": "Bezeichnung (de)", "name": "name_de", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var name_nl916 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Bezeichnung (nl)","(cal.Calendars.name_nl) ") }, "fieldLabel": "Bezeichnung (nl)", "name": "name_nl", "maxLength": 200, "selectOnFocus": true, "hidden": true, "anchor": "-20" });
    var id917 = new Ext.form.NumberField({ "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("ID","(cal.Calendars.id) ") }, "fieldLabel": "ID", "anchor": "-20", "name": "id" });
    var main_1_panel918 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 153, "hideCheckBoxLabels": true, "items": [ { "flex": 18, "autoHeight": true, "layout": "form", "xtype": "panel", "items": type912, "labelAlign": "top" }, { "flex": 19, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name913, "labelAlign": "top" }, { "flex": 19, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_fr914, "labelAlign": "top" }, { "flex": 19, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_de915, "labelAlign": "top" }, { "flex": 19, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_nl916, "hidden": true, "labelAlign": "top" }, { "flex": 4, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id917, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var invite_team_members925 = new Lino.RemoteComboFieldElement({ "fieldLabel": "Team", "name": "invite_team_members", "pageSize": 20, "emptyText": "Team ausw\u00e4hlen...", "listeners": { "render": Lino.quicktip_renderer("Team","(cal.Calendars.invite_team_members) ") }, "selectOnFocus": true, "hiddenName": "invite_team_membersHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/Calendars/invite_team_members", "method": "GET" }) }) });
    var event_label926 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Event label","(cal.Calendars.event_label) ") }, "fieldLabel": "Event label", "name": "event_label", "maxLength": 200, "selectOnFocus": true, "anchor": "-20", "value": "Termin" });
    var event_label_fr927 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Event label (fr)","(cal.Calendars.event_label_fr) ") }, "fieldLabel": "Event label (fr)", "name": "event_label_fr", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var event_label_de928 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Event label (de)","(cal.Calendars.event_label_de) ") }, "fieldLabel": "Event label (de)", "name": "event_label_de", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var event_label_nl929 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Event label (nl)","(cal.Calendars.event_label_nl) ") }, "fieldLabel": "Event label (nl)", "name": "event_label_nl", "maxLength": 200, "selectOnFocus": true, "hidden": true, "anchor": "-20" });
    var main_2_panel930 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 153, "hideCheckBoxLabels": true, "items": [ { "flex": 19, "autoHeight": true, "layout": "form", "xtype": "panel", "items": invite_team_members925, "labelAlign": "top" }, { "flex": 20, "autoHeight": true, "layout": "form", "xtype": "panel", "items": event_label926, "labelAlign": "top" }, { "flex": 20, "autoHeight": true, "layout": "form", "xtype": "panel", "items": event_label_fr927, "labelAlign": "top" }, { "flex": 20, "autoHeight": true, "layout": "form", "xtype": "panel", "items": event_label_de928, "labelAlign": "top" }, { "flex": 20, "autoHeight": true, "layout": "form", "xtype": "panel", "items": event_label_nl929, "hidden": true, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var url_template936 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("URL-Vorlage","(cal.Calendars.url_template) ") }, "fieldLabel": "URL-Vorlage", "name": "url_template", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var username937 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Benutzername","(cal.Calendars.username) ") }, "fieldLabel": "Benutzername", "name": "username", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var password938 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Passwort","(cal.Calendars.password) ") }, "fieldLabel": "Passwort", "name": "password", "maxLength": 200, "selectOnFocus": true, "anchor": "-20", "inputType": "password" });
    var main_3_panel939 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 117, "hideCheckBoxLabels": true, "items": [ { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": url_template936, "labelAlign": "top" }, { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": username937, "labelAlign": "top" }, { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": password938, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var readonly943 = new Ext.form.Checkbox({ "boxLabel": "schreibgesch\u00fctzt", "listeners": { "render": Lino.quicktip_renderer("schreibgesch\u00fctzt","(cal.Calendars.readonly) ") }, "hideLabel": true, "checked": false, "name": "readonly", "selectOnFocus": true, "anchor": "-20" });
    var is_appointment944 = new Ext.form.Checkbox({ "boxLabel": "Event is an appointment", "listeners": { "render": Lino.quicktip_renderer("Event is an appointment","(cal.Calendars.is_appointment) ") }, "hideLabel": true, "checked": true, "name": "is_appointment", "selectOnFocus": true, "anchor": "-20" });
    var invite_client945 = new Ext.form.Checkbox({ "boxLabel": "Klient einladen", "listeners": { "render": Lino.quicktip_renderer("Klient einladen","(cal.Calendars.invite_client) ") }, "hideLabel": true, "checked": false, "name": "invite_client", "selectOnFocus": true, "anchor": "-20" });
    var color946 = new Ext.form.NumberField({ "listeners": { "render": Lino.quicktip_renderer("Farbe","(cal.Calendars.color) ") }, "fieldLabel": "Farbe", "name": "color", "selectOnFocus": true, "anchor": "-20", "value": 1, "allowBlank": false });
    var start_date947 = new Lino.DateField({ "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Beginnt am","(cal.Calendars.start_date) ") }, "fieldLabel": "Beginnt am", "anchor": "-20", "name": "start_date" });
    var main_4_panel948 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 216, "hideCheckBoxLabels": true, "items": [ { "flex": 23, "autoHeight": true, "layout": "form", "xtype": "panel", "items": readonly943, "labelAlign": "top" }, { "flex": 23, "autoHeight": true, "layout": "form", "xtype": "panel", "items": is_appointment944, "labelAlign": "top" }, { "flex": 23, "autoHeight": true, "layout": "form", "xtype": "panel", "items": invite_client945, "labelAlign": "top" }, { "flex": 11, "autoHeight": true, "layout": "form", "xtype": "panel", "items": color946, "labelAlign": "top" }, { "flex": 18, "autoHeight": true, "layout": "form", "xtype": "panel", "items": start_date947, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var build_method954 = new Lino.ChoicesFieldElement({ "listeners": { "render": Lino.quicktip_renderer("Konstruktionsmethode","(cal.Calendars.build_method) ") }, "fieldLabel": "Konstruktionsmethode", "name": "build_method", "selectOnFocus": true, "anchor": "-20", "store": [ [ "appyodt", "AppyOdtBuildMethod" ], [ "appypdf", "AppyPdfBuildMethod" ], [ "appyrtf", "AppyRtfBuildMethod" ], [ "latex", "LatexBuildMethod" ], [ "pisa", "PisaBuildMethod" ], [ "rtf", "RtfBuildMethod" ] ], "hiddenName": "build_methodHidden" });
    var template955 = new Lino.SimpleRemoteComboFieldElement({ "listeners": { "render": Lino.quicktip_renderer("Vorlage","(cal.Calendars.template) ") }, "fieldLabel": "Vorlage", "name": "template", "selectOnFocus": true, "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/Calendars/template", "method": "GET" }) }) });
    var email_template956 = new Lino.SimpleRemoteComboFieldElement({ "listeners": { "render": Lino.quicktip_renderer("E-Mail-Vorlage","(cal.Calendars.email_template) The name of the file to be used as \ntemplate when creating an email from a mailable of this type.") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">E-Mail-Vorlage</span>", "name": "email_template", "selectOnFocus": true, "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/Calendars/email_template", "method": "GET" }) }) });
    var attach_to_email957 = new Ext.form.Checkbox({ "boxLabel": "als Anhang per E-Mail", "listeners": { "render": Lino.quicktip_renderer("als Anhang per E-Mail","(cal.Calendars.attach_to_email) Whether the printable file should be attached to the email\nwhen creating an email from a mailable of this type.\n") }, "hideLabel": true, "checked": false, "name": "attach_to_email", "selectOnFocus": true, "anchor": "-20" });
    var main_5_panel958 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 198, "hideCheckBoxLabels": true, "items": [ { "flex": 40, "autoHeight": true, "layout": "form", "xtype": "panel", "items": build_method954, "labelAlign": "top" }, { "flex": 20, "autoHeight": true, "layout": "form", "xtype": "panel", "items": template955, "labelAlign": "top" }, { "flex": 20, "autoHeight": true, "layout": "form", "xtype": "panel", "items": email_template956, "labelAlign": "top" }, { "flex": 20, "autoHeight": true, "layout": "form", "xtype": "panel", "items": attach_to_email957, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var EventsByCalendar_grid1125 = new Lino.cal.EventsByCalendar.GridPanel({ "flex": 77, "hide_top_toolbar": true, "containing_panel": this, "params_panel_hidden": true, "master_panel": this, "preview_limit": 15, "listeners": { "render": Lino.quicktip_renderer("Termine","(cal.cal.EventsByCalendar) ") }, "tools": [ Lino.show_in_own_window_button(Lino.cal.EventsByCalendar.grid) ] });
    var SubscriptionsByCalendar_grid1130 = new Lino.cal.SubscriptionsByCalendar.GridPanel({ "flex": 22, "listeners": { "render": Lino.quicktip_renderer("Abonnements","(cal.cal.SubscriptionsByCalendar) ") }, "hide_top_toolbar": true, "containing_panel": this, "tools": [ Lino.show_in_own_window_button(Lino.cal.SubscriptionsByCalendar.grid) ], "preview_limit": 15, "master_panel": this });
    var main_6_panel1131 = new Ext.Panel({ "flex": 50, "border": false, "layout": "hbox", "hideCheckBoxLabels": true, "items": [ EventsByCalendar_grid1125, SubscriptionsByCalendar_grid1130 ], "autoScroll": false, "layoutConfig": { "align": "stretch" }, "frame": false, "labelAlign": "top" });
    var main_panel1132 = new Ext.Panel({ "autoScroll": false, "border": false, "layout": "vbox", "hideCheckBoxLabels": true, "items": [ main_1_panel918, main_2_panel930, main_3_panel939, main_4_panel948, main_5_panel958, main_6_panel1131 ], "frame": true, "layoutConfig": { "align": "stretch" }, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel1132;
    this.before_row_edit = function(record) {
      template955.setContextValue('build_method',record ? record.data['build_methodHidden'] : undefined);
      EventsByCalendar_grid1125.on_master_changed();
      SubscriptionsByCalendar_grid1130.on_master_changed();
    }
    this.onRender = function(ct, position) {
      build_method954.on('change',Lino.chooser_handler(template955,'build_method'));
      Lino.cal.Calendars.DetailFormPanel.superclass.onRender.call(this, ct, position);
    }
    Lino.cal.Calendars.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.contacts.Persons.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 20,
  initComponent : function() {
    var containing_panel = this;
    var last_name806 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Familienname","(contacts.Persons.last_name) ") }, "fieldLabel": "Familienname", "name": "last_name", "maxLength": 200, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var first_name807 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Vorname","(contacts.Persons.first_name) ") }, "fieldLabel": "Vorname", "name": "first_name", "maxLength": 200, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var gender808 = new Lino.ChoicesFieldElement({ "forceSelection": true, "fieldLabel": "Geschlecht", "name": "gender", "hiddenName": "genderHidden", "listeners": { "render": Lino.quicktip_renderer("Geschlecht","(contacts.Persons.gender) ") }, "selectOnFocus": true, "anchor": "-20", "store": [['','<br>']].concat(Lino.lino.Genders) });
    var title809 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Anrede","(contacts.Persons.title) ") }, "fieldLabel": "Anrede", "name": "title", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var name_box_panel810 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 38, "autoHeight": true, "layout": "form", "xtype": "panel", "items": last_name806, "labelAlign": "top" }, { "flex": 27, "autoHeight": true, "layout": "form", "xtype": "panel", "items": first_name807, "labelAlign": "top" }, { "flex": 16, "autoHeight": true, "layout": "form", "xtype": "panel", "items": gender808, "labelAlign": "top" }, { "flex": 18, "autoHeight": true, "layout": "form", "xtype": "panel", "items": title809, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 117, "border": false, "anchor": "-20", "labelAlign": "top" });
    var country815 = new Lino.TwinCombo({ "fieldLabel": "Land", "name": "country", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.countries.Countries.detail)}, "emptyText": "Land ausw\u00e4hlen...", "listeners": { "render": Lino.quicktip_renderer("Land","(contacts.Persons.country) ") }, "selectOnFocus": true, "hiddenName": "countryHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/contacts/Persons/country", "method": "GET" }) }) });
    var region816 = new Lino.TwinCombo({ "fieldLabel": "Region", "name": "region", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.countries.Cities.detail)}, "emptyText": "Ort ausw\u00e4hlen...", "listeners": { "render": Lino.quicktip_renderer("Region","(contacts.Persons.region) ") }, "selectOnFocus": true, "hiddenName": "regionHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/contacts/Persons/region", "method": "GET" }) }) });
    var city817 = new Lino.TwinCombo({ "forceSelection": false, "fieldLabel": "Ort", "name": "city", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.countries.Cities.detail)}, "emptyText": "Ort ausw\u00e4hlen...", "listeners": { "render": Lino.quicktip_renderer("Ort","(contacts.Persons.city) ") }, "selectOnFocus": true, "hiddenName": "cityHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/contacts/Persons/city", "method": "GET" }) }) });
    var zip_code818 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Postleitzahl","(contacts.Persons.zip_code) ") }, "fieldLabel": "Postleitzahl", "name": "zip_code", "maxLength": 10, "selectOnFocus": true, "boxMinWidth": Lino.chars2width(10), "anchor": "-20" });
    var address_box_2_panel819 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 28, "autoHeight": true, "layout": "form", "xtype": "panel", "items": country815, "labelAlign": "top" }, { "flex": 28, "autoHeight": true, "layout": "form", "xtype": "panel", "items": region816, "labelAlign": "top" }, { "flex": 28, "autoHeight": true, "layout": "form", "xtype": "panel", "items": city817, "labelAlign": "top" }, { "flex": 14, "autoHeight": true, "layout": "form", "xtype": "panel", "items": zip_code818, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 117, "border": false, "anchor": "-20", "labelAlign": "top" });
    var addr1824 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Adresszeile vor Stra\u00dfe","(contacts.Persons.addr1) Address line before street") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Adresszeile vor Stra\u00dfe</span>", "name": "addr1", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var street_prefix825 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Pr\u00e4fix Stra\u00dfe","(contacts.Persons.street_prefix) Text to print before name of street, but to ignore for sorting.") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Pr\u00e4fix Stra\u00dfe</span>", "name": "street_prefix", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var street826 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Stra\u00dfe","(contacts.Persons.street) Name of street. Without house number.") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Stra\u00dfe</span>", "name": "street", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var street_no827 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Nr.","(contacts.Persons.street_no) House number") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Nr.</span>", "name": "street_no", "maxLength": 10, "selectOnFocus": true, "boxMinWidth": Lino.chars2width(10), "anchor": "-20" });
    var street_box828 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Box","(contacts.Persons.street_box) Text to print after :attr:`steet_no` on the same line") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Box</span>", "name": "street_box", "maxLength": 10, "selectOnFocus": true, "boxMinWidth": Lino.chars2width(10), "anchor": "-20" });
    var address_box_4_panel829 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 30, "autoHeight": true, "layout": "form", "xtype": "panel", "items": street_prefix825, "labelAlign": "top" }, { "flex": 36, "autoHeight": true, "layout": "form", "xtype": "panel", "items": street826, "labelAlign": "top" }, { "flex": 16, "autoHeight": true, "layout": "form", "xtype": "panel", "items": street_no827, "labelAlign": "top" }, { "flex": 16, "autoHeight": true, "layout": "form", "xtype": "panel", "items": street_box828, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 126, "border": false, "anchor": "-20", "labelAlign": "top" });
    var addr2834 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Adresszeile nach Stra\u00dfe","(contacts.Persons.addr2) Address line to print below street line") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Adresszeile nach Stra\u00dfe</span>", "name": "addr2", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var address_box_panel835 = new Ext.form.FieldSet({ "flex": 66, "autoHeight": true, "layout": "form", "title": "Adresse", "items": [ name_box_panel810, address_box_2_panel819, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": addr1824, "anchor": "-20", "labelAlign": "top" }, address_box_4_panel829, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": addr2834, "anchor": "-20", "labelAlign": "top" } ], "frame": true, "bodyBorder": false, "autoScroll": false, "hideCheckBoxLabels": true, "labelWidth": 216, "border": false, "labelAlign": "top" });
    var id838 = new Ext.form.NumberField({ "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("ID","(contacts.Persons.id) ") }, "fieldLabel": "ID", "anchor": "-20", "name": "id" });
    var language839 = new Lino.ChoicesFieldElement({ "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Sprache</span>", "allowBlank": false, "hiddenName": "languageHidden", "listeners": { "render": Lino.quicktip_renderer("Sprache","(contacts.Persons.language) Die Sprache, in der Dokumente ausgestellt werden sollen.") }, "selectOnFocus": true, "anchor": "-20", "store": [ [ "en", "Englisch" ], [ "fr", "Franz\u00f6sisch" ], [ "de", "Deutsch" ], [ "nl", "Niederl\u00e4ndisch" ] ], "name": "language" });
    var info_box_panel840 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id838, "labelAlign": "top" }, { "flex": 66, "autoHeight": true, "layout": "form", "xtype": "panel", "items": language839, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 72, "border": false, "anchor": "-20", "labelAlign": "top" });
    var email843 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("E-Mail","(contacts.Persons.email) ") }, "fieldLabel": "E-Mail", "name": "email", "maxLength": 75, "selectOnFocus": true, "anchor": "-20" });
    var url844 = new Lino.URLField({ "listeners": { "render": Lino.quicktip_renderer("URL","(contacts.Persons.url) ") }, "fieldLabel": "URL", "name": "url", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var phone845 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Telefon","(contacts.Persons.phone) ") }, "fieldLabel": "Telefon", "name": "phone", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var gsm846 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("GSM","(contacts.Persons.gsm) ") }, "fieldLabel": "GSM", "name": "gsm", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var fax847 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Fax","(contacts.Persons.fax) ") }, "fieldLabel": "Fax", "name": "fax", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var contact_box_5_panel848 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": gsm846, "labelAlign": "top" }, { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": fax847, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 36, "border": false, "anchor": "-20", "labelAlign": "top" });
    var contact_box_panel851 = new Ext.form.FieldSet({ "flex": 33, "autoHeight": true, "layout": "form", "title": "Kontakt", "items": [ info_box_panel840, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": email843, "anchor": "-20", "labelAlign": "top" }, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": url844, "anchor": "-20", "labelAlign": "top" }, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": phone845, "anchor": "-20", "labelAlign": "top" }, contact_box_5_panel848 ], "frame": true, "bodyBorder": false, "autoScroll": false, "hideCheckBoxLabels": true, "labelWidth": 72, "border": false, "labelAlign": "top" });
    var general_1_panel855 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "hideCheckBoxLabels": true, "items": [ address_box_panel835, contact_box_panel851 ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var activity856 = new Lino.RemoteComboFieldElement({ "fieldLabel": "Beruf", "name": "activity", "pageSize": 20, "emptyText": "Beruf ausw\u00e4hlen...", "listeners": { "render": Lino.quicktip_renderer("Beruf","(contacts.Persons.activity) ") }, "selectOnFocus": true, "hiddenName": "activityHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/contacts/Persons/activity", "method": "GET" }) }) });
    var bank_account1857 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Bankkonto 1","(contacts.Persons.bank_account1) ") }, "fieldLabel": "Bankkonto 1", "name": "bank_account1", "maxLength": 40, "selectOnFocus": true, "anchor": "-20" });
    var bank_account2858 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Bankkonto 2","(contacts.Persons.bank_account2) ") }, "fieldLabel": "Bankkonto 2", "name": "bank_account2", "maxLength": 40, "selectOnFocus": true, "anchor": "-20" });
    var is_obsolete859 = new Ext.form.Checkbox({ "boxLabel": "veraltet", "listeners": { "render": Lino.quicktip_renderer("veraltet","(contacts.Persons.is_obsolete) Altf\u00e4lle sind Partner, deren Stammdaten nicht mehr gepflegt werden und \nf\u00fcr neue Operationen nicht benutzt werden k\u00f6nnen.") }, "hideLabel": true, "checked": false, "name": "is_obsolete", "selectOnFocus": true, "anchor": "-20" });
    var bottom_box_1_panel860 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 108, "hideCheckBoxLabels": true, "items": [ { "flex": 27, "autoHeight": true, "layout": "form", "xtype": "panel", "items": activity856, "labelAlign": "top" }, { "flex": 29, "autoHeight": true, "layout": "form", "xtype": "panel", "items": bank_account1857, "labelAlign": "top" }, { "flex": 29, "autoHeight": true, "layout": "form", "xtype": "panel", "items": bank_account2858, "labelAlign": "top" }, { "flex": 13, "autoHeight": true, "layout": "form", "xtype": "panel", "items": is_obsolete859, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var is_client865 = new Ext.form.Checkbox({ "boxLabel": "ist Klient (<a href=\"javascript:Lino.show_mti_child('is_client',Lino.pcsw.Clients.detail)\">zeigen</a>)", "listeners": { "render": Lino.quicktip_renderer("ist Klient","(contacts.Persons.is_client) Ob diese Person ein Klient ist") }, "hideLabel": true, "name": "is_client", "selectOnFocus": true, "anchor": "-20" });
    var created866 = new Ext.form.DisplayField({ "disabled": true, "listeners": { "render": Lino.quicktip_renderer("Erstellt","(contacts.Persons.created) ") }, "fieldLabel": "Erstellt", "name": "created", "anchor": "-20", "value": "<br>" });
    var modified867 = new Ext.form.DisplayField({ "disabled": true, "listeners": { "render": Lino.quicktip_renderer("Bearbeitet","(contacts.Persons.modified) ") }, "fieldLabel": "Bearbeitet", "name": "modified", "anchor": "-20", "value": "<br>" });
    var bottom_box_2_panel868 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 99, "hideCheckBoxLabels": true, "items": [ { "flex": 23, "autoHeight": true, "layout": "form", "xtype": "panel", "items": is_client865, "labelAlign": "top" }, { "flex": 38, "autoHeight": true, "layout": "form", "xtype": "panel", "items": created866, "labelAlign": "top" }, { "flex": 38, "autoHeight": true, "layout": "form", "xtype": "panel", "items": modified867, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var remarks872 = new Ext.form.TextArea({ "listeners": { "render": Lino.quicktip_renderer("Bemerkungen","(contacts.Persons.remarks) ") }, "fieldLabel": "Bemerkungen", "name": "remarks", "growMax": 2000, "selectOnFocus": true, "anchor": "-20 -10" });
    var contacts_RolesByPerson_grid877 = new Lino.contacts.RolesByPerson.GridPanel({ "flex": 27, "listeners": { "render": Lino.quicktip_renderer("Kontaktperson f\u00fcr","(contacts.contacts.RolesByPerson) ") }, "hide_top_toolbar": true, "containing_panel": this, "tools": [ Lino.show_in_own_window_button(Lino.contacts.RolesByPerson.grid) ], "preview_limit": 15, "master_panel": this });
    var households_MembersByPerson_grid884 = new Lino.households.MembersByPerson.GridPanel({ "flex": 36, "listeners": { "render": Lino.quicktip_renderer("Mitglied von","(households.households.MembersByPerson) ") }, "hide_top_toolbar": true, "containing_panel": this, "tools": [ Lino.show_in_own_window_button(Lino.households.MembersByPerson.grid) ], "preview_limit": 15, "master_panel": this });
    var bottom_box_3_panel885 = new Ext.Panel({ "flex": 71, "border": false, "layout": "hbox", "labelWidth": 108, "hideCheckBoxLabels": true, "items": [ { "items": remarks872, "labelAlign": "top", "layout": "form", "xtype": "panel", "flex": 36 }, contacts_RolesByPerson_grid877, households_MembersByPerson_grid884 ], "autoScroll": false, "layoutConfig": { "align": "stretch" }, "frame": false, "labelAlign": "top" });
    var bottom_box_panel887 = new Ext.Panel({ "flex": 58, "border": false, "layout": "vbox", "bodyBorder": false, "hideCheckBoxLabels": true, "items": [ bottom_box_1_panel860, bottom_box_2_panel868, bottom_box_3_panel885 ], "autoScroll": false, "layoutConfig": { "align": "stretch" }, "frame": true, "labelAlign": "top" });
    var general_panel888 = new Ext.Panel({ "layout": "vbox", "title": "Allgemein", "items": [ general_1_panel855, bottom_box_panel887 ], "frame": true, "layoutConfig": { "align": "stretch" }, "hideCheckBoxLabels": true, "listeners": { "activate": Lino.on_tab_activate }, "autoScroll": false, "border": false, "bodyBorder": false, "labelAlign": "top" });
    var main_panel892 = new Ext.TabPanel({ "hideCheckBoxLabels": true, "border": false, "split": true, "autoScroll": false, "items": [ general_panel888 ], "activeTab": 0, "bodyBorder": false, "frame": true, "labelAlign": "top" });
    this.items = main_panel892;
    this.before_row_edit = function(record) {
      region816.setContextValue('country',record ? record.data['countryHidden'] : undefined);
      city817.setContextValue('country',record ? record.data['countryHidden'] : undefined);
      city817.setContextValue('region',record ? record.data['regionHidden'] : undefined);
      contacts_RolesByPerson_grid877.on_master_changed();
      households_MembersByPerson_grid884.on_master_changed();
    }
    this.onRender = function(ct, position) {
      country815.on('change',Lino.chooser_handler(region816,'country'));
      country815.on('change',Lino.chooser_handler(city817,'country'));
      region816.on('change',Lino.chooser_handler(city817,'region'));
      Lino.contacts.Persons.DetailFormPanel.superclass.onRender.call(this, ct, position);
    }
    Lino.contacts.Persons.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.jobs.JobsOverview.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  disable_editing: true,
  initComponent : function() {
    var containing_panel = this;
    var preview_htmlbox3050 = new Lino.HtmlBoxPanel({ "layout": "fit", "name": "preview", "containing_panel": this, "master_panel": this, "items": new Ext.BoxComponent({autoScroll:true}), "bodyStyle": "overflow-x:hidden;", "value": "<br/>", "always_enabled": true, "listeners": { "render": Lino.quicktip_renderer(null,"(jobs.JobsOverview.preview) ") } });
    var main_panel3051 = new Ext.Panel({ "autoScroll": false, "border": false, "layout": "fit", "labelWidth": 0, "hideCheckBoxLabels": true, "items": [ preview_htmlbox3050 ], "frame": true, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel3051;
    this.before_row_edit = function(record) {
      preview_htmlbox3050.refresh();
    }
    Lino.jobs.JobsOverview.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.cal.Rooms.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 30,
  initComponent : function() {
    var containing_panel = this;
    var id1152 = new Ext.form.NumberField({ "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("ID","(cal.Rooms.id) ") }, "fieldLabel": "ID", "anchor": "-20", "name": "id" });
    var name1153 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Bezeichnung","(cal.Rooms.name) ") }, "fieldLabel": "Bezeichnung", "name": "name", "maxLength": 200, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var name_fr1154 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Bezeichnung (fr)","(cal.Rooms.name_fr) ") }, "fieldLabel": "Bezeichnung (fr)", "name": "name_fr", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var name_de1155 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Bezeichnung (de)","(cal.Rooms.name_de) ") }, "fieldLabel": "Bezeichnung (de)", "name": "name_de", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var name_nl1156 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Bezeichnung (nl)","(cal.Rooms.name_nl) ") }, "fieldLabel": "Bezeichnung (nl)", "name": "name_nl", "maxLength": 200, "selectOnFocus": true, "hidden": true, "anchor": "-20" });
    var main_1_panel1157 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 153, "hideCheckBoxLabels": true, "items": [ { "flex": 5, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id1152, "labelAlign": "top" }, { "flex": 23, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name1153, "labelAlign": "top" }, { "flex": 23, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_fr1154, "labelAlign": "top" }, { "flex": 23, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_de1155, "labelAlign": "top" }, { "flex": 23, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_nl1156, "hidden": true, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var cal_EventsByRoom_grid1188 = new Lino.cal.EventsByRoom.GridPanel({ "flex": 83, "hide_top_toolbar": true, "containing_panel": this, "params_panel_hidden": true, "master_panel": this, "preview_limit": 15, "listeners": { "render": Lino.quicktip_renderer("Termine","(cal.cal.EventsByRoom) ") }, "tools": [ Lino.show_in_own_window_button(Lino.cal.EventsByRoom.grid) ] });
    var main_panel1189 = new Ext.Panel({ "autoScroll": false, "border": false, "layout": "vbox", "hideCheckBoxLabels": true, "items": [ main_1_panel1157, cal_EventsByRoom_grid1188 ], "frame": true, "layoutConfig": { "align": "stretch" }, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel1189;
    this.before_row_edit = function(record) {
      cal_EventsByRoom_grid1188.on_master_changed();
    }
    Lino.cal.Rooms.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.users.MySettings.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 7,
  initComponent : function() {
    var containing_panel = this;
    var username65 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Benutzername","(users.Users.username) Required. Must be unique.") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Benutzername</span>", "name": "username", "maxLength": 30, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var profile66 = new Lino.ChoicesFieldElement({ "forceSelection": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Benutzerprofil</span>", "name": "profile", "hiddenName": "profileHidden", "listeners": { "render": Lino.quicktip_renderer("Benutzerprofil","(users.Users.profile) Users with an empty `profile` field are considered inactive and cannot log in.") }, "selectOnFocus": true, "anchor": "-20", "store": [['','<br>']].concat(Lino.lino.UserProfiles) });
    var partner67 = new Lino.TwinCombo({ "preferred_width": 20, "fieldLabel": "Partner", "name": "partner", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.contacts.Partners.detail)}, "hiddenName": "partnerHidden", "listeners": { "render": Lino.quicktip_renderer("Partner","(users.Users.partner) ") }, "selectOnFocus": true, "emptyText": "Partner ausw\u00e4hlen...", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/users/Users/partner", "method": "GET" }) }) });
    var box1_1_panel68 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 34, "autoHeight": true, "layout": "form", "xtype": "panel", "items": username65, "labelAlign": "top" }, { "flex": 32, "autoHeight": true, "layout": "form", "xtype": "panel", "items": profile66, "labelAlign": "top" }, { "flex": 32, "autoHeight": true, "layout": "form", "xtype": "panel", "items": partner67, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 135, "border": false, "anchor": "-20", "labelAlign": "top" });
    var first_name72 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Vorname","(users.Users.first_name) ") }, "fieldLabel": "Vorname", "name": "first_name", "maxLength": 30, "selectOnFocus": true, "anchor": "-20" });
    var last_name73 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Familienname","(users.Users.last_name) ") }, "fieldLabel": "Familienname", "name": "last_name", "maxLength": 30, "selectOnFocus": true, "anchor": "-20" });
    var initials74 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Initials","(users.Users.initials) ") }, "fieldLabel": "Initials", "name": "initials", "maxLength": 10, "selectOnFocus": true, "boxMinWidth": Lino.chars2width(10), "anchor": "-20" });
    var box1_2_panel75 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 39, "autoHeight": true, "layout": "form", "xtype": "panel", "items": first_name72, "labelAlign": "top" }, { "flex": 39, "autoHeight": true, "layout": "form", "xtype": "panel", "items": last_name73, "labelAlign": "top" }, { "flex": 20, "autoHeight": true, "layout": "form", "xtype": "panel", "items": initials74, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 117, "border": false, "anchor": "-20", "labelAlign": "top" });
    var email79 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("e-mail address","(users.Users.email) ") }, "fieldLabel": "e-mail address", "name": "email", "maxLength": 75, "selectOnFocus": true, "anchor": "-20" });
    var language80 = new Lino.ChoicesFieldElement({ "listeners": { "render": Lino.quicktip_renderer("Sprache","(users.Users.language) ") }, "fieldLabel": "Sprache", "name": "language", "selectOnFocus": true, "anchor": "-20", "store": [ [ "en", "Englisch" ], [ "fr", "Franz\u00f6sisch" ], [ "de", "Deutsch" ], [ "nl", "Niederl\u00e4ndisch" ] ], "hiddenName": "languageHidden" });
    var box1_3_panel81 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 51, "autoHeight": true, "layout": "form", "xtype": "panel", "items": email79, "labelAlign": "top" }, { "flex": 48, "autoHeight": true, "layout": "form", "xtype": "panel", "items": language80, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 135, "border": false, "anchor": "-20", "labelAlign": "top" });
    var id84 = new Ext.form.NumberField({ "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("ID","(users.Users.id) ") }, "fieldLabel": "ID", "anchor": "-20", "name": "id" });
    var created85 = new Ext.form.DisplayField({ "disabled": true, "listeners": { "render": Lino.quicktip_renderer("Erstellt","(users.Users.created) ") }, "fieldLabel": "Erstellt", "name": "created", "anchor": "-20", "value": "<br>" });
    var modified86 = new Ext.form.DisplayField({ "disabled": true, "listeners": { "render": Lino.quicktip_renderer("Bearbeitet","(users.Users.modified) ") }, "fieldLabel": "Bearbeitet", "name": "modified", "anchor": "-20", "value": "<br>" });
    var box1_4_panel87 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 13, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id84, "labelAlign": "top" }, { "flex": 43, "autoHeight": true, "layout": "form", "xtype": "panel", "items": created85, "labelAlign": "top" }, { "flex": 43, "autoHeight": true, "layout": "form", "xtype": "panel", "items": modified86, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 99, "border": false, "anchor": "-20", "labelAlign": "top" });
    var box1_panel91 = new Ext.Panel({ "flex": 66, "autoHeight": true, "border": false, "layout": "form", "hideCheckBoxLabels": true, "items": [ box1_1_panel68, box1_2_panel75, box1_3_panel81, box1_4_panel87 ], "frame": true, "autoScroll": false, "bodyBorder": false, "labelAlign": "top" });
    var general_1_panel95 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "hideCheckBoxLabels": true, "items": [ box1_panel91 ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var remarks96 = new Ext.form.TextArea({ "listeners": { "render": Lino.quicktip_renderer("Bemerkungen","(users.Users.remarks) ") }, "fieldLabel": "Bemerkungen", "name": "remarks", "growMax": 2000, "selectOnFocus": true, "anchor": "-20 -10" });
    var AuthoritiesGiven_grid99 = new Lino.users.AuthoritiesGiven.GridPanel({ "flex": 33, "hide_top_toolbar": true, "containing_panel": this, "preview_limit": 15, "master_panel": this, "listeners": { "render": Lino.quicktip_renderer("Erteilte Vollmachten","(users.users.AuthoritiesGiven) ") }, "tools": [ Lino.show_in_own_window_button(Lino.users.AuthoritiesGiven.grid) ], "hideHeaders": true });
    var general_2_panel100 = new Ext.Panel({ "flex": 50, "border": false, "layout": "hbox", "labelWidth": 108, "hideCheckBoxLabels": true, "items": [ { "items": remarks96, "labelAlign": "top", "layout": "form", "xtype": "panel", "flex": 66 }, AuthoritiesGiven_grid99 ], "autoScroll": false, "layoutConfig": { "align": "stretch" }, "frame": false, "labelAlign": "top" });
    var general_panel102 = new Ext.Panel({ "layout": "vbox", "title": "Allgemein", "items": [ general_1_panel95, general_2_panel100 ], "frame": true, "layoutConfig": { "align": "stretch" }, "hideCheckBoxLabels": true, "listeners": { "activate": Lino.on_tab_activate }, "autoScroll": false, "border": false, "bodyBorder": false, "labelAlign": "top" });
    var calendar103 = new Lino.TwinCombo({ "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Standard-Kalender</span>", "name": "calendar", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.cal.Calendars.detail)}, "emptyText": "Kalender ausw\u00e4hlen...", "listeners": { "render": Lino.quicktip_renderer("Standard-Kalender","(users.Users.calendar) The default calendar for your events and tasks.") }, "selectOnFocus": true, "hiddenName": "calendarHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/users/Users/calendar", "method": "GET" }) }) });
    var access_class104 = new Lino.ChoicesFieldElement({ "forceSelection": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Standardm\u00e4\u00dfige Zugriffsklasse</span>", "allowBlank": false, "hiddenName": "access_classHidden", "listeners": { "render": Lino.quicktip_renderer("Standardm\u00e4\u00dfige Zugriffsklasse","(users.Users.access_class) Die standardm\u00e4\u00dfige Zugriffsklasse f\u00fcr Ihre Termine und Aufgaben") }, "selectOnFocus": true, "anchor": "-20", "store": Lino.cal.AccessClasses, "name": "access_class" });
    var cal_left_1_panel105 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 270, "hideCheckBoxLabels": true, "items": [ { "flex": 62, "autoHeight": true, "layout": "form", "xtype": "panel", "items": calendar103, "labelAlign": "top" }, { "flex": 37, "autoHeight": true, "layout": "form", "xtype": "panel", "items": access_class104, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var cal_SubscriptionsByUser_grid112 = new Lino.cal.SubscriptionsByUser.GridPanel({ "flex": 83, "listeners": { "render": Lino.quicktip_renderer("Abonnements","(cal.cal.SubscriptionsByUser) ") }, "hide_top_toolbar": true, "containing_panel": this, "tools": [ Lino.show_in_own_window_button(Lino.cal.SubscriptionsByUser.grid) ], "preview_limit": 15, "master_panel": this });
    var cal_left_panel113 = new Ext.Panel({ "flex": 33, "border": false, "layout": "vbox", "bodyBorder": false, "hideCheckBoxLabels": true, "items": [ cal_left_1_panel105, cal_SubscriptionsByUser_grid112 ], "autoScroll": false, "layoutConfig": { "align": "stretch" }, "frame": true, "labelAlign": "top" });
    var cal_TasksByUser_grid182 = new Lino.cal.TasksByUser.GridPanel({ "flex": 66, "hide_top_toolbar": true, "containing_panel": this, "params_panel_hidden": true, "preview_limit": 15, "master_panel": this, "listeners": { "render": Lino.quicktip_renderer("Aufgaben","(cal.cal.TasksByUser) ") }, "tools": [ Lino.show_in_own_window_button(Lino.cal.TasksByUser.grid) ] });
    var cal_1_panel183 = new Ext.Panel({ "autoScroll": false, "listeners": { "activate": Lino.on_tab_activate }, "border": false, "layout": "hbox", "title": "Kalender", "hideCheckBoxLabels": true, "items": [ cal_left_panel113, cal_TasksByUser_grid182 ], "frame": false, "layoutConfig": { "align": "stretch" }, "labelAlign": "top" });
    var newcomer_quota184 = new Ext.form.NumberField({ "listeners": { "render": Lino.quicktip_renderer("Quote NZ","(users.Users.newcomer_quota) Wieviel Arbeitszeit dieser Benutzer f\u00fcr Neuantr\u00e4ge zur Verf\u00fcgung steht\n(100 = ganztags, 50 = halbtags, 0 = gar nicht).\nWenn zwei Benutzer die gleiche Belastungspunktzahl haben, \naber einer davon sich nur zu 50% um Neuantr\u00e4ge k\u00fcmmert, \ngilt er als doppelt so belastet wie sein Kollege.\n") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Quote NZ</span>", "name": "newcomer_quota", "selectOnFocus": true, "anchor": "-20", "value": 0, "allowBlank": false });
    var coaching_type185 = new Lino.RemoteComboFieldElement({ "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Dienst</span>", "name": "coaching_type", "pageSize": 20, "emptyText": "Dienst ausw\u00e4hlen...", "listeners": { "render": Lino.quicktip_renderer("Dienst","(users.Users.coaching_type) The default CoachingType used when creating Coachings.") }, "selectOnFocus": true, "hiddenName": "coaching_typeHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/users/Users/coaching_type", "method": "GET" }) }) });
    var coaching_supervisor186 = new Ext.form.Checkbox({ "boxLabel": "Benachrichtigung wenn ein Begleiter zugewiesen wird", "listeners": { "render": Lino.quicktip_renderer("Benachrichtigung wenn ein Begleiter zugewiesen wird","(users.Users.coaching_supervisor) Wenn ein Neuantrag einem Begleiter zugewiesen wurde, wird au\u00dfer dem Begleiter auch dieser Benutzer benachrichtigt.") }, "hideLabel": true, "checked": false, "name": "coaching_supervisor", "selectOnFocus": true, "anchor": "-20" });
    var newcomers_CompetencesByUser_grid192 = new Lino.newcomers.CompetencesByUser.GridPanel({ "flex": 62, "listeners": { "render": Lino.quicktip_renderer("Kompetenzen","(newcomers.newcomers.CompetencesByUser) ") }, "hide_top_toolbar": true, "containing_panel": this, "tools": [ Lino.show_in_own_window_button(Lino.newcomers.CompetencesByUser.grid) ], "preview_limit": 15, "master_panel": this });
    var coaching_a_panel193 = new Ext.Panel({ "flex": 33, "layout": "vbox", "items": [ { "items": newcomer_quota184, "autoHeight": true, "layout": "form", "xtype": "panel", "labelAlign": "top" }, { "items": coaching_type185, "autoHeight": true, "layout": "form", "xtype": "panel", "labelAlign": "top" }, { "items": coaching_supervisor186, "autoHeight": true, "layout": "form", "xtype": "panel", "labelAlign": "top" }, newcomers_CompetencesByUser_grid192 ], "frame": true, "layoutConfig": { "align": "stretch" }, "autoScroll": false, "hideCheckBoxLabels": true, "labelWidth": 468, "border": false, "bodyBorder": false, "labelAlign": "top" });
    var pcsw_CoachingsByUser_grid223 = new Lino.pcsw.CoachingsByUser.GridPanel({ "flex": 66, "hide_top_toolbar": true, "containing_panel": this, "params_panel_hidden": true, "preview_limit": 15, "master_panel": this, "listeners": { "render": Lino.quicktip_renderer("Begleitungen","(pcsw.pcsw.CoachingsByUser) ") }, "tools": [ Lino.show_in_own_window_button(Lino.pcsw.CoachingsByUser.grid) ] });
    var coaching_1_panel224 = new Ext.Panel({ "autoScroll": false, "listeners": { "activate": Lino.on_tab_activate }, "border": false, "layout": "hbox", "title": "Begleitung", "hideCheckBoxLabels": true, "items": [ coaching_a_panel193, pcsw_CoachingsByUser_grid223 ], "frame": false, "layoutConfig": { "align": "stretch" }, "labelAlign": "top" });
    var main_panel225 = new Ext.TabPanel({ "hideCheckBoxLabels": true, "border": false, "split": true, "autoScroll": false, "items": [ general_panel102, cal_1_panel183, coaching_1_panel224 ], "activeTab": 0, "bodyBorder": false, "frame": true, "labelAlign": "top" });
    this.items = main_panel225;
    this.before_row_edit = function(record) {
      AuthoritiesGiven_grid99.on_master_changed();
      cal_SubscriptionsByUser_grid112.on_master_changed();
      cal_TasksByUser_grid182.on_master_changed();
      newcomers_CompetencesByUser_grid192.on_master_changed();
      pcsw_CoachingsByUser_grid223.on_master_changed();
    }
    Lino.users.MySettings.DetailFormPanel.superclass.initComponent.call(this);
    // active_fields:
    partner67.on("change",function(){this.save()},this);
  }
});


Lino.cal.MyPresences.InsertFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  autoHeight: true,
  content_type: 36,
  initComponent : function() {
    var containing_panel = this;
    var event1084 = new Lino.TwinCombo({ "fieldLabel": "Termin", "allowBlank": false, "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.cal.OneEvent.detail)}, "emptyText": "Termin ausw\u00e4hlen...", "listeners": { "render": Lino.quicktip_renderer("Termin","(cal.Guests.event) ") }, "selectOnFocus": true, "hiddenName": "eventHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/Guests/event", "method": "GET" }) }), "name": "event" });
    var partner1085 = new Lino.TwinCombo({ "preferred_width": 20, "fieldLabel": "Partner", "allowBlank": false, "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.contacts.Partners.detail)}, "emptyText": "Partner ausw\u00e4hlen...", "listeners": { "render": Lino.quicktip_renderer("Partner","(cal.Guests.partner) ") }, "selectOnFocus": true, "hiddenName": "partnerHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/Guests/partner", "method": "GET" }) }), "name": "partner" });
    var role1086 = new Lino.TwinCombo({ "fieldLabel": "Rolle", "name": "role", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.cal.GuestRoles.detail)}, "emptyText": "Gastrolle ausw\u00e4hlen...", "listeners": { "render": Lino.quicktip_renderer("Rolle","(cal.Guests.role) ") }, "selectOnFocus": true, "hiddenName": "roleHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/Guests/role", "method": "GET" }) }) });
    var main_panel1087 = new Ext.Panel({ "hideCheckBoxLabels": true, "autoHeight": true, "border": false, "layout": "form", "labelWidth": 72, "autoScroll": false, "items": [ { "autoHeight": true, "layout": "form", "xtype": "panel", "items": event1084, "anchor": "-20", "labelAlign": "top" }, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": partner1085, "anchor": "-20", "labelAlign": "top" }, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": role1086, "anchor": "-20", "labelAlign": "top" } ], "frame": true, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel1087;
    this.before_row_edit = function(record) {
    }
    Lino.cal.MyPresences.InsertFormPanel.superclass.initComponent.call(this);
  }
});


Lino.jobs.JobTypes.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 75,
  initComponent : function() {
    var containing_panel = this;
    var id2004 = new Ext.form.NumberField({ "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("ID","(jobs.JobTypes.id) ") }, "fieldLabel": "ID", "anchor": "-20", "name": "id" });
    var name2005 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Bezeichnung","(jobs.JobTypes.name) ") }, "fieldLabel": "Bezeichnung", "name": "name", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var main_1_panel2006 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 108, "hideCheckBoxLabels": true, "items": [ { "flex": 19, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id2004, "labelAlign": "top" }, { "flex": 80, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name2005, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var JobsByType_grid2019 = new Lino.jobs.JobsByType.GridPanel({ "flex": 83, "listeners": { "render": Lino.quicktip_renderer("Stellen","(jobs.jobs.JobsByType) ") }, "hide_top_toolbar": true, "containing_panel": this, "tools": [ Lino.show_in_own_window_button(Lino.jobs.JobsByType.grid) ], "preview_limit": 15, "master_panel": this });
    var main_panel2020 = new Ext.Panel({ "autoScroll": false, "border": false, "layout": "vbox", "hideCheckBoxLabels": true, "items": [ main_1_panel2006, JobsByType_grid2019 ], "frame": true, "layoutConfig": { "align": "stretch" }, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel2020;
    this.before_row_edit = function(record) {
      JobsByType_grid2019.on_master_changed();
    }
    Lino.jobs.JobTypes.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.cal.MyPresences.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 36,
  initComponent : function() {
    var containing_panel = this;
    var event1068 = new Lino.TwinCombo({ "fieldLabel": "Termin", "allowBlank": false, "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.cal.OneEvent.detail)}, "emptyText": "Termin ausw\u00e4hlen...", "listeners": { "render": Lino.quicktip_renderer("Termin","(cal.Guests.event) ") }, "selectOnFocus": true, "hiddenName": "eventHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/Guests/event", "method": "GET" }) }), "name": "event" });
    var partner1069 = new Lino.TwinCombo({ "preferred_width": 20, "fieldLabel": "Partner", "allowBlank": false, "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.contacts.Partners.detail)}, "emptyText": "Partner ausw\u00e4hlen...", "listeners": { "render": Lino.quicktip_renderer("Partner","(cal.Guests.partner) ") }, "selectOnFocus": true, "hiddenName": "partnerHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/Guests/partner", "method": "GET" }) }), "name": "partner" });
    var role1070 = new Lino.TwinCombo({ "fieldLabel": "Rolle", "name": "role", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.cal.GuestRoles.detail)}, "emptyText": "Gastrolle ausw\u00e4hlen...", "listeners": { "render": Lino.quicktip_renderer("Rolle","(cal.Guests.role) ") }, "selectOnFocus": true, "hiddenName": "roleHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/Guests/role", "method": "GET" }) }) });
    var main_1_panel1071 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 72, "hideCheckBoxLabels": true, "items": [ { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": event1068, "labelAlign": "top" }, { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": partner1069, "labelAlign": "top" }, { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": role1070, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var state1075 = new Lino.ChoicesFieldElement({ "forceSelection": true, "fieldLabel": "Zustand", "allowBlank": false, "hiddenName": "stateHidden", "listeners": { "render": Lino.quicktip_renderer("Zustand","(cal.Guests.state) ") }, "selectOnFocus": true, "anchor": "-20", "store": Lino.cal.GuestStates, "name": "state" });
    var remark1076 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Bemerkung","(cal.Guests.remark) ") }, "fieldLabel": "Bemerkung", "name": "remark", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var workflow_buttons_disp1077 = new Ext.form.DisplayField({ "disabled": true, "listeners": { "render": Lino.quicktip_renderer("Arbeitsablauf","(cal.Guests.workflow_buttons) ") }, "fieldLabel": "Arbeitsablauf", "name": "workflow_buttons", "anchor": "-20", "value": "<br/>", "always_enabled": true });
    var main_2_panel1078 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 126, "hideCheckBoxLabels": true, "items": [ { "flex": 17, "autoHeight": true, "layout": "form", "xtype": "panel", "items": state1075, "labelAlign": "top" }, { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": remark1076, "labelAlign": "top" }, { "flex": 48, "autoHeight": true, "layout": "form", "xtype": "panel", "items": workflow_buttons_disp1077, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var outbox_MailsByController_grid1082 = new Lino.outbox.MailsByController.GridPanel({ "flex": 55, "listeners": { "render": Lino.quicktip_renderer("E-Mail-Ausg\u00e4nge","(outbox.outbox.MailsByController) ") }, "hide_top_toolbar": true, "containing_panel": this, "tools": [ Lino.show_in_own_window_button(Lino.outbox.MailsByController.grid) ], "preview_limit": 15, "master_panel": this });
    var main_panel1083 = new Ext.Panel({ "autoScroll": false, "border": false, "layout": "vbox", "hideCheckBoxLabels": true, "items": [ main_1_panel1071, main_2_panel1078, outbox_MailsByController_grid1082 ], "frame": true, "layoutConfig": { "align": "stretch" }, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel1083;
    this.before_row_edit = function(record) {
      outbox_MailsByController_grid1082.on_master_changed();
    }
    Lino.cal.MyPresences.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.system.MyTextFieldTemplates.InsertFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  autoHeight: true,
  content_type: 2,
  initComponent : function() {
    var containing_panel = this;
    var name2970 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Bezeichnung","(system.TextFieldTemplates.name) ") }, "fieldLabel": "Bezeichnung", "name": "name", "maxLength": 200, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var user2971 = new Lino.TwinCombo({ "preferred_width": 15, "fieldLabel": "Autor", "name": "user", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.users.Users.detail)}, "hiddenName": "userHidden", "listeners": { "render": Lino.quicktip_renderer("Autor","(system.TextFieldTemplates.user) ") }, "selectOnFocus": true, "emptyText": "Benutzer ausw\u00e4hlen...", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/system/TextFieldTemplates/user", "method": "GET" }) }) });
    var team2972 = new Lino.RemoteComboFieldElement({ "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Team</span>", "name": "team", "pageSize": 20, "emptyText": "Team ausw\u00e4hlen...", "listeners": { "render": Lino.quicktip_renderer("Team","(system.TextFieldTemplates.team) If not empty, then this template is reserved to members of this team.") }, "selectOnFocus": true, "hiddenName": "teamHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/system/TextFieldTemplates/team", "method": "GET" }) }) });
    var main_2_panel2973 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": user2971, "labelAlign": "top" }, { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": team2972, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 54, "border": false, "anchor": "-20", "labelAlign": "top" });
    var main_panel2976 = new Ext.Panel({ "hideCheckBoxLabels": true, "autoHeight": true, "border": false, "layout": "form", "labelWidth": 108, "autoScroll": false, "items": [ { "autoHeight": true, "layout": "form", "xtype": "panel", "items": name2970, "anchor": "-20", "labelAlign": "top" }, main_2_panel2973 ], "frame": true, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel2976;
    this.before_row_edit = function(record) {
    }
    Lino.system.MyTextFieldTemplates.InsertFormPanel.superclass.initComponent.call(this);
  }
});


Lino.contacts.Partners.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 22,
  initComponent : function() {
    var containing_panel = this;
    var name349 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Name","(contacts.Partners.name) ") }, "fieldLabel": "Name", "name": "name", "maxLength": 200, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var country350 = new Lino.TwinCombo({ "fieldLabel": "Land", "name": "country", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.countries.Countries.detail)}, "emptyText": "Land ausw\u00e4hlen...", "listeners": { "render": Lino.quicktip_renderer("Land","(contacts.Partners.country) ") }, "selectOnFocus": true, "hiddenName": "countryHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/contacts/Partners/country", "method": "GET" }) }) });
    var region351 = new Lino.TwinCombo({ "fieldLabel": "Region", "name": "region", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.countries.Cities.detail)}, "emptyText": "Ort ausw\u00e4hlen...", "listeners": { "render": Lino.quicktip_renderer("Region","(contacts.Partners.region) ") }, "selectOnFocus": true, "hiddenName": "regionHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/contacts/Partners/region", "method": "GET" }) }) });
    var city352 = new Lino.TwinCombo({ "forceSelection": false, "fieldLabel": "Ort", "name": "city", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.countries.Cities.detail)}, "emptyText": "Ort ausw\u00e4hlen...", "listeners": { "render": Lino.quicktip_renderer("Ort","(contacts.Partners.city) ") }, "selectOnFocus": true, "hiddenName": "cityHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/contacts/Partners/city", "method": "GET" }) }) });
    var zip_code353 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Postleitzahl","(contacts.Partners.zip_code) ") }, "fieldLabel": "Postleitzahl", "name": "zip_code", "maxLength": 10, "selectOnFocus": true, "boxMinWidth": Lino.chars2width(10), "anchor": "-20" });
    var address_box_2_panel354 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 28, "autoHeight": true, "layout": "form", "xtype": "panel", "items": country350, "labelAlign": "top" }, { "flex": 28, "autoHeight": true, "layout": "form", "xtype": "panel", "items": region351, "labelAlign": "top" }, { "flex": 28, "autoHeight": true, "layout": "form", "xtype": "panel", "items": city352, "labelAlign": "top" }, { "flex": 14, "autoHeight": true, "layout": "form", "xtype": "panel", "items": zip_code353, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 117, "border": false, "anchor": "-20", "labelAlign": "top" });
    var addr1359 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Adresszeile vor Stra\u00dfe","(contacts.Partners.addr1) Address line before street") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Adresszeile vor Stra\u00dfe</span>", "name": "addr1", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var street_prefix360 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Pr\u00e4fix Stra\u00dfe","(contacts.Partners.street_prefix) Text to print before name of street, but to ignore for sorting.") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Pr\u00e4fix Stra\u00dfe</span>", "name": "street_prefix", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var street361 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Stra\u00dfe","(contacts.Partners.street) Name of street. Without house number.") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Stra\u00dfe</span>", "name": "street", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var street_no362 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Nr.","(contacts.Partners.street_no) House number") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Nr.</span>", "name": "street_no", "maxLength": 10, "selectOnFocus": true, "boxMinWidth": Lino.chars2width(10), "anchor": "-20" });
    var street_box363 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Box","(contacts.Partners.street_box) Text to print after :attr:`steet_no` on the same line") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Box</span>", "name": "street_box", "maxLength": 10, "selectOnFocus": true, "boxMinWidth": Lino.chars2width(10), "anchor": "-20" });
    var address_box_4_panel364 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 30, "autoHeight": true, "layout": "form", "xtype": "panel", "items": street_prefix360, "labelAlign": "top" }, { "flex": 36, "autoHeight": true, "layout": "form", "xtype": "panel", "items": street361, "labelAlign": "top" }, { "flex": 16, "autoHeight": true, "layout": "form", "xtype": "panel", "items": street_no362, "labelAlign": "top" }, { "flex": 16, "autoHeight": true, "layout": "form", "xtype": "panel", "items": street_box363, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 126, "border": false, "anchor": "-20", "labelAlign": "top" });
    var addr2369 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Adresszeile nach Stra\u00dfe","(contacts.Partners.addr2) Address line to print below street line") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Adresszeile nach Stra\u00dfe</span>", "name": "addr2", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var address_box_panel370 = new Ext.form.FieldSet({ "flex": 66, "autoHeight": true, "layout": "form", "title": "Adresse", "items": [ { "autoHeight": true, "layout": "form", "xtype": "panel", "items": name349, "anchor": "-20", "labelAlign": "top" }, address_box_2_panel354, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": addr1359, "anchor": "-20", "labelAlign": "top" }, address_box_4_panel364, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": addr2369, "anchor": "-20", "labelAlign": "top" } ], "frame": true, "bodyBorder": false, "autoScroll": false, "hideCheckBoxLabels": true, "labelWidth": 216, "border": false, "labelAlign": "top" });
    var id374 = new Ext.form.NumberField({ "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("ID","(contacts.Partners.id) ") }, "fieldLabel": "ID", "anchor": "-20", "name": "id" });
    var language375 = new Lino.ChoicesFieldElement({ "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Sprache</span>", "allowBlank": false, "hiddenName": "languageHidden", "listeners": { "render": Lino.quicktip_renderer("Sprache","(contacts.Partners.language) Die Sprache, in der Dokumente ausgestellt werden sollen.") }, "selectOnFocus": true, "anchor": "-20", "store": [ [ "en", "Englisch" ], [ "fr", "Franz\u00f6sisch" ], [ "de", "Deutsch" ], [ "nl", "Niederl\u00e4ndisch" ] ], "name": "language" });
    var info_box_panel376 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 20, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id374, "labelAlign": "top" }, { "flex": 80, "autoHeight": true, "layout": "form", "xtype": "panel", "items": language375, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 72, "border": false, "anchor": "-20", "labelAlign": "top" });
    var email379 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("E-Mail","(contacts.Partners.email) ") }, "fieldLabel": "E-Mail", "name": "email", "maxLength": 75, "selectOnFocus": true, "anchor": "-20" });
    var url380 = new Lino.URLField({ "listeners": { "render": Lino.quicktip_renderer("URL","(contacts.Partners.url) ") }, "fieldLabel": "URL", "name": "url", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var phone381 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Telefon","(contacts.Partners.phone) ") }, "fieldLabel": "Telefon", "name": "phone", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var gsm382 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("GSM","(contacts.Partners.gsm) ") }, "fieldLabel": "GSM", "name": "gsm", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var fax383 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Fax","(contacts.Partners.fax) ") }, "fieldLabel": "Fax", "name": "fax", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var contact_box_5_panel384 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": gsm382, "labelAlign": "top" }, { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": fax383, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 36, "border": false, "anchor": "-20", "labelAlign": "top" });
    var contact_box_panel387 = new Ext.form.FieldSet({ "flex": 33, "autoHeight": true, "layout": "form", "title": "Kontakt", "items": [ info_box_panel376, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": email379, "anchor": "-20", "labelAlign": "top" }, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": url380, "anchor": "-20", "labelAlign": "top" }, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": phone381, "anchor": "-20", "labelAlign": "top" }, contact_box_5_panel384 ], "frame": true, "bodyBorder": false, "autoScroll": false, "hideCheckBoxLabels": true, "labelWidth": 72, "border": false, "labelAlign": "top" });
    var general_1_panel391 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "hideCheckBoxLabels": true, "items": [ address_box_panel370, contact_box_panel387 ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var remarks392 = new Ext.form.TextArea({ "listeners": { "render": Lino.quicktip_renderer("Bemerkungen","(contacts.Partners.remarks) ") }, "fieldLabel": "Bemerkungen", "name": "remarks", "growMax": 2000, "selectOnFocus": true, "anchor": "-20 -10" });
    var activity393 = new Lino.RemoteComboFieldElement({ "fieldLabel": "Beruf", "name": "activity", "pageSize": 20, "emptyText": "Beruf ausw\u00e4hlen...", "listeners": { "render": Lino.quicktip_renderer("Beruf","(contacts.Partners.activity) ") }, "selectOnFocus": true, "hiddenName": "activityHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/contacts/Partners/activity", "method": "GET" }) }) });
    var bank_account1394 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Bankkonto 1","(contacts.Partners.bank_account1) ") }, "fieldLabel": "Bankkonto 1", "name": "bank_account1", "maxLength": 40, "selectOnFocus": true, "anchor": "-20" });
    var bank_account2395 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Bankkonto 2","(contacts.Partners.bank_account2) ") }, "fieldLabel": "Bankkonto 2", "name": "bank_account2", "maxLength": 40, "selectOnFocus": true, "anchor": "-20" });
    var is_obsolete396 = new Ext.form.Checkbox({ "boxLabel": "veraltet", "listeners": { "render": Lino.quicktip_renderer("veraltet","(contacts.Partners.is_obsolete) Altf\u00e4lle sind Partner, deren Stammdaten nicht mehr gepflegt werden und \nf\u00fcr neue Operationen nicht benutzt werden k\u00f6nnen.") }, "hideLabel": true, "checked": false, "name": "is_obsolete", "selectOnFocus": true, "anchor": "-20" });
    var bottom_box_2_panel397 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 108, "hideCheckBoxLabels": true, "items": [ { "flex": 27, "autoHeight": true, "layout": "form", "xtype": "panel", "items": activity393, "labelAlign": "top" }, { "flex": 29, "autoHeight": true, "layout": "form", "xtype": "panel", "items": bank_account1394, "labelAlign": "top" }, { "flex": 29, "autoHeight": true, "layout": "form", "xtype": "panel", "items": bank_account2395, "labelAlign": "top" }, { "flex": 13, "autoHeight": true, "layout": "form", "xtype": "panel", "items": is_obsolete396, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var is_person402 = new Ext.form.Checkbox({ "boxLabel": "ist eine Person (<a href=\"javascript:Lino.show_mti_child('is_person',Lino.contacts.Persons.detail)\">zeigen</a>)", "listeners": { "render": Lino.quicktip_renderer("ist eine Person","(contacts.Partners.is_person) Ob dieser Partner auch eine Person ist.") }, "hideLabel": true, "name": "is_person", "selectOnFocus": true, "anchor": "-20" });
    var is_company403 = new Ext.form.Checkbox({ "boxLabel": "ist eine Organisation (<a href=\"javascript:Lino.show_mti_child('is_company',Lino.contacts.Companies.detail)\">zeigen</a>)", "listeners": { "render": Lino.quicktip_renderer("ist eine Organisation","(contacts.Partners.is_company) Ob dieser Partner auch eine Organisation ist.") }, "hideLabel": true, "name": "is_company", "selectOnFocus": true, "anchor": "-20" });
    var is_household404 = new Ext.form.Checkbox({ "boxLabel": "ist ein Haushalt (<a href=\"javascript:Lino.show_mti_child('is_household',Lino.households.Households.detail)\">zeigen</a>)", "listeners": { "render": Lino.quicktip_renderer("ist ein Haushalt","(contacts.Partners.is_household) ") }, "hideLabel": true, "name": "is_household", "selectOnFocus": true, "anchor": "-20" });
    var created405 = new Ext.form.DisplayField({ "disabled": true, "listeners": { "render": Lino.quicktip_renderer("Erstellt","(contacts.Partners.created) ") }, "fieldLabel": "Erstellt", "name": "created", "anchor": "-20", "value": "<br>" });
    var modified406 = new Ext.form.DisplayField({ "disabled": true, "listeners": { "render": Lino.quicktip_renderer("Bearbeitet","(contacts.Partners.modified) ") }, "fieldLabel": "Bearbeitet", "name": "modified", "anchor": "-20", "value": "<br>" });
    var bottom_box_3_panel407 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 198, "hideCheckBoxLabels": true, "items": [ { "flex": 16, "autoHeight": true, "layout": "form", "xtype": "panel", "items": is_person402, "labelAlign": "top" }, { "flex": 16, "autoHeight": true, "layout": "form", "xtype": "panel", "items": is_company403, "labelAlign": "top" }, { "flex": 16, "autoHeight": true, "layout": "form", "xtype": "panel", "items": is_household404, "labelAlign": "top" }, { "flex": 25, "autoHeight": true, "layout": "form", "xtype": "panel", "items": created405, "labelAlign": "top" }, { "flex": 25, "autoHeight": true, "layout": "form", "xtype": "panel", "items": modified406, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var bottom_box_panel413 = new Ext.Panel({ "flex": 58, "layout": "vbox", "items": [ { "items": remarks392, "labelAlign": "top", "layout": "form", "xtype": "panel", "flex": 71 }, bottom_box_2_panel397, bottom_box_3_panel407 ], "frame": true, "layoutConfig": { "align": "stretch" }, "autoScroll": false, "hideCheckBoxLabels": true, "labelWidth": 108, "border": false, "bodyBorder": false, "labelAlign": "top" });
    var general_panel415 = new Ext.Panel({ "layout": "vbox", "title": "Allgemein", "items": [ general_1_panel391, bottom_box_panel413 ], "frame": true, "layoutConfig": { "align": "stretch" }, "hideCheckBoxLabels": true, "listeners": { "activate": Lino.on_tab_activate }, "autoScroll": false, "border": false, "bodyBorder": false, "labelAlign": "top" });
    var changes_ChangesByMaster_grid440 = new Lino.changes.ChangesByMaster.GridPanel({ "listeners": { "activate": Lino.on_tab_activate }, "hide_top_toolbar": true, "containing_panel": this, "title": "\u00c4nderungen", "tools": [ Lino.show_in_own_window_button(Lino.changes.ChangesByMaster.grid) ], "preview_limit": 15, "master_panel": this });
    var main_panel559 = new Ext.TabPanel({ "hideCheckBoxLabels": true, "border": false, "split": true, "autoScroll": false, "items": [ general_panel415, changes_ChangesByMaster_grid440 ], "activeTab": 0, "bodyBorder": false, "frame": true, "labelAlign": "top" });
    this.items = main_panel559;
    this.before_row_edit = function(record) {
      region351.setContextValue('country',record ? record.data['countryHidden'] : undefined);
      city352.setContextValue('country',record ? record.data['countryHidden'] : undefined);
      city352.setContextValue('region',record ? record.data['regionHidden'] : undefined);
      changes_ChangesByMaster_grid440.on_master_changed();
    }
    this.onRender = function(ct, position) {
      country350.on('change',Lino.chooser_handler(region351,'country'));
      country350.on('change',Lino.chooser_handler(city352,'country'));
      region351.on('change',Lino.chooser_handler(city352,'region'));
      Lino.contacts.Partners.DetailFormPanel.superclass.onRender.call(this, ct, position);
    }
    Lino.contacts.Partners.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.jobs.JobProviders.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 74,
  initComponent : function() {
    var containing_panel = this;
    var prefix1680 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("prefix","(jobs.JobProviders.prefix) ") }, "fieldLabel": "prefix", "name": "prefix", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var name1681 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Name","(jobs.JobProviders.name) ") }, "fieldLabel": "Name", "name": "name", "maxLength": 200, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var id1682 = new Ext.form.NumberField({ "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("ID","(jobs.JobProviders.id) ") }, "fieldLabel": "ID", "anchor": "-20", "name": "id" });
    var language1683 = new Lino.ChoicesFieldElement({ "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Sprache</span>", "allowBlank": false, "hiddenName": "languageHidden", "listeners": { "render": Lino.quicktip_renderer("Sprache","(jobs.JobProviders.language) Die Sprache, in der Dokumente ausgestellt werden sollen.") }, "selectOnFocus": true, "anchor": "-20", "store": [ [ "en", "Englisch" ], [ "fr", "Franz\u00f6sisch" ], [ "de", "Deutsch" ], [ "nl", "Niederl\u00e4ndisch" ] ], "name": "language" });
    var intro_box_1_panel1684 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 31, "autoHeight": true, "layout": "form", "xtype": "panel", "items": prefix1680, "labelAlign": "top" }, { "flex": 31, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name1681, "labelAlign": "top" }, { "flex": 7, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id1682, "labelAlign": "top" }, { "flex": 29, "autoHeight": true, "layout": "form", "xtype": "panel", "items": language1683, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 72, "border": false, "anchor": "-20", "labelAlign": "top" });
    var vat_id1689 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("MWSt.-Nr.","(jobs.JobProviders.vat_id) ") }, "fieldLabel": "MWSt.-Nr.", "name": "vat_id", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var activity1690 = new Lino.RemoteComboFieldElement({ "fieldLabel": "Beruf", "name": "activity", "pageSize": 20, "emptyText": "Beruf ausw\u00e4hlen...", "listeners": { "render": Lino.quicktip_renderer("Beruf","(jobs.JobProviders.activity) ") }, "selectOnFocus": true, "hiddenName": "activityHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/jobs/JobProviders/activity", "method": "GET" }) }) });
    var type1691 = new Lino.RemoteComboFieldElement({ "fieldLabel": "Organisationsart", "name": "type", "pageSize": 20, "emptyText": "Organisationsart ausw\u00e4hlen...", "listeners": { "render": Lino.quicktip_renderer("Organisationsart","(jobs.JobProviders.type) ") }, "selectOnFocus": true, "hiddenName": "typeHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/jobs/JobProviders/type", "method": "GET" }) }) });
    var intro_box_2_panel1692 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 23, "autoHeight": true, "layout": "form", "xtype": "panel", "items": vat_id1689, "labelAlign": "top" }, { "flex": 38, "autoHeight": true, "layout": "form", "xtype": "panel", "items": activity1690, "labelAlign": "top" }, { "flex": 38, "autoHeight": true, "layout": "form", "xtype": "panel", "items": type1691, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 153, "border": false, "anchor": "-20", "labelAlign": "top" });
    var bank_account11696 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Bankkonto 1","(jobs.JobProviders.bank_account1) ") }, "fieldLabel": "Bankkonto 1", "name": "bank_account1", "maxLength": 40, "selectOnFocus": true, "anchor": "-20" });
    var bank_account21697 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Bankkonto 2","(jobs.JobProviders.bank_account2) ") }, "fieldLabel": "Bankkonto 2", "name": "bank_account2", "maxLength": 40, "selectOnFocus": true, "anchor": "-20" });
    var is_obsolete1698 = new Ext.form.Checkbox({ "boxLabel": "veraltet", "listeners": { "render": Lino.quicktip_renderer("veraltet","(jobs.JobProviders.is_obsolete) Altf\u00e4lle sind Partner, deren Stammdaten nicht mehr gepflegt werden und \nf\u00fcr neue Operationen nicht benutzt werden k\u00f6nnen.") }, "hideLabel": true, "checked": false, "name": "is_obsolete", "selectOnFocus": true, "anchor": "-20" });
    var intro_box_3_panel1699 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 40, "autoHeight": true, "layout": "form", "xtype": "panel", "items": bank_account11696, "labelAlign": "top" }, { "flex": 40, "autoHeight": true, "layout": "form", "xtype": "panel", "items": bank_account21697, "labelAlign": "top" }, { "flex": 19, "autoHeight": true, "layout": "form", "xtype": "panel", "items": is_obsolete1698, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 108, "border": false, "anchor": "-20", "labelAlign": "top" });
    var intro_box_panel1703 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "form", "hideCheckBoxLabels": true, "items": [ intro_box_1_panel1684, intro_box_2_panel1692, intro_box_3_panel1699 ], "frame": true, "bodyBorder": false, "labelAlign": "top" });
    var country1704 = new Lino.TwinCombo({ "fieldLabel": "Land", "name": "country", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.countries.Countries.detail)}, "emptyText": "Land ausw\u00e4hlen...", "listeners": { "render": Lino.quicktip_renderer("Land","(jobs.JobProviders.country) ") }, "selectOnFocus": true, "hiddenName": "countryHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/jobs/JobProviders/country", "method": "GET" }) }) });
    var region1705 = new Lino.TwinCombo({ "fieldLabel": "Region", "name": "region", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.countries.Cities.detail)}, "emptyText": "Ort ausw\u00e4hlen...", "listeners": { "render": Lino.quicktip_renderer("Region","(jobs.JobProviders.region) ") }, "selectOnFocus": true, "hiddenName": "regionHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/jobs/JobProviders/region", "method": "GET" }) }) });
    var box3_1_panel1706 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": country1704, "labelAlign": "top" }, { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": region1705, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 63, "border": false, "anchor": "-20", "labelAlign": "top" });
    var city1709 = new Lino.TwinCombo({ "forceSelection": false, "fieldLabel": "Ort", "name": "city", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.countries.Cities.detail)}, "emptyText": "Ort ausw\u00e4hlen...", "listeners": { "render": Lino.quicktip_renderer("Ort","(jobs.JobProviders.city) ") }, "selectOnFocus": true, "hiddenName": "cityHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/jobs/JobProviders/city", "method": "GET" }) }) });
    var zip_code1710 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Postleitzahl","(jobs.JobProviders.zip_code) ") }, "fieldLabel": "Postleitzahl", "name": "zip_code", "maxLength": 10, "selectOnFocus": true, "boxMinWidth": Lino.chars2width(10), "anchor": "-20" });
    var box3_2_panel1711 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 66, "autoHeight": true, "layout": "form", "xtype": "panel", "items": city1709, "labelAlign": "top" }, { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": zip_code1710, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 117, "border": false, "anchor": "-20", "labelAlign": "top" });
    var street_prefix1714 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Pr\u00e4fix Stra\u00dfe","(jobs.JobProviders.street_prefix) Text to print before name of street, but to ignore for sorting.") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Pr\u00e4fix Stra\u00dfe</span>", "name": "street_prefix", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var street1715 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Stra\u00dfe","(jobs.JobProviders.street) Name of street. Without house number.") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Stra\u00dfe</span>", "name": "street", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var street_no1716 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Nr.","(jobs.JobProviders.street_no) House number") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Nr.</span>", "name": "street_no", "maxLength": 10, "selectOnFocus": true, "boxMinWidth": Lino.chars2width(10), "anchor": "-20" });
    var street_box1717 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Box","(jobs.JobProviders.street_box) Text to print after :attr:`steet_no` on the same line") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Box</span>", "name": "street_box", "maxLength": 10, "selectOnFocus": true, "boxMinWidth": Lino.chars2width(10), "anchor": "-20" });
    var box3_3_panel1718 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 30, "autoHeight": true, "layout": "form", "xtype": "panel", "items": street_prefix1714, "labelAlign": "top" }, { "flex": 36, "autoHeight": true, "layout": "form", "xtype": "panel", "items": street1715, "labelAlign": "top" }, { "flex": 16, "autoHeight": true, "layout": "form", "xtype": "panel", "items": street_no1716, "labelAlign": "top" }, { "flex": 16, "autoHeight": true, "layout": "form", "xtype": "panel", "items": street_box1717, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 126, "border": false, "anchor": "-20", "labelAlign": "top" });
    var addr21723 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Adresszeile nach Stra\u00dfe","(jobs.JobProviders.addr2) Address line to print below street line") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Adresszeile nach Stra\u00dfe</span>", "name": "addr2", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var box3_panel1724 = new Ext.Panel({ "flex": 62, "autoHeight": true, "layout": "form", "items": [ box3_1_panel1706, box3_2_panel1711, box3_3_panel1718, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": addr21723, "anchor": "-20", "labelAlign": "top" } ], "frame": true, "bodyBorder": false, "autoScroll": false, "hideCheckBoxLabels": true, "labelWidth": 216, "border": false, "labelAlign": "top" });
    var email1726 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("E-Mail","(jobs.JobProviders.email) ") }, "fieldLabel": "E-Mail", "name": "email", "maxLength": 75, "selectOnFocus": true, "anchor": "-20" });
    var url1727 = new Lino.URLField({ "listeners": { "render": Lino.quicktip_renderer("URL","(jobs.JobProviders.url) ") }, "fieldLabel": "URL", "name": "url", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var phone1728 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Telefon","(jobs.JobProviders.phone) ") }, "fieldLabel": "Telefon", "name": "phone", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var gsm1729 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("GSM","(jobs.JobProviders.gsm) ") }, "fieldLabel": "GSM", "name": "gsm", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var box4_panel1730 = new Ext.Panel({ "flex": 37, "autoHeight": true, "layout": "form", "items": [ { "autoHeight": true, "layout": "form", "xtype": "panel", "items": email1726, "anchor": "-20", "labelAlign": "top" }, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": url1727, "anchor": "-20", "labelAlign": "top" }, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": phone1728, "anchor": "-20", "labelAlign": "top" }, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": gsm1729, "anchor": "-20", "labelAlign": "top" } ], "frame": true, "bodyBorder": false, "autoScroll": false, "hideCheckBoxLabels": true, "labelWidth": 72, "border": false, "labelAlign": "top" });
    var address_box_panel1735 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "hideCheckBoxLabels": true, "items": [ box3_panel1724, box4_panel1730 ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var remarks1736 = new Ext.form.TextArea({ "listeners": { "render": Lino.quicktip_renderer("Bemerkungen","(jobs.JobProviders.remarks) ") }, "fieldLabel": "Bemerkungen", "name": "remarks", "growMax": 2000, "selectOnFocus": true, "anchor": "-20 -10" });
    var contacts_RolesByCompany_grid1737 = new Lino.contacts.RolesByCompany.GridPanel({ "flex": 42, "listeners": { "render": Lino.quicktip_renderer("Kontaktpersonen","(contacts.contacts.RolesByCompany) ") }, "hide_top_toolbar": true, "containing_panel": this, "tools": [ Lino.show_in_own_window_button(Lino.contacts.RolesByCompany.grid) ], "preview_limit": 15, "master_panel": this });
    var bottom_box_panel1738 = new Ext.Panel({ "flex": 41, "border": false, "layout": "hbox", "labelWidth": 108, "hideCheckBoxLabels": true, "items": [ { "items": remarks1736, "labelAlign": "top", "layout": "form", "xtype": "panel", "flex": 57 }, contacts_RolesByCompany_grid1737 ], "autoScroll": false, "layoutConfig": { "align": "stretch" }, "frame": false, "labelAlign": "top" });
    var general_panel1740 = new Ext.Panel({ "layout": "vbox", "title": "Allgemein", "items": [ intro_box_panel1703, address_box_panel1735, bottom_box_panel1738 ], "frame": true, "layoutConfig": { "align": "stretch" }, "hideCheckBoxLabels": true, "listeners": { "activate": Lino.on_tab_activate }, "autoScroll": false, "border": false, "bodyBorder": false, "labelAlign": "top" });
    var pcsw_NotesByCompany_grid1741 = new Lino.pcsw.NotesByCompany.GridPanel({ "listeners": { "activate": Lino.on_tab_activate }, "hide_top_toolbar": true, "containing_panel": this, "title": "Ereignisse/Notizen", "tools": [ Lino.show_in_own_window_button(Lino.pcsw.NotesByCompany.grid) ], "preview_limit": 15, "master_panel": this });
    var JobsByProvider_grid1814 = new Lino.jobs.JobsByProvider.GridPanel({ "flex": 5, "hide_top_toolbar": true, "containing_panel": this, "region": "north", "preview_limit": 15, "master_panel": this, "listeners": { "render": Lino.quicktip_renderer("Stellen","(jobs.jobs.JobsByProvider) ") }, "split": true, "tools": [ Lino.show_in_own_window_button(Lino.jobs.JobsByProvider.grid) ] });
    var ContractsByProvider_grid1842 = new Lino.jobs.ContractsByProvider.GridPanel({ "flex": 5, "hide_top_toolbar": true, "containing_panel": this, "region": "center", "params_panel_hidden": true, "master_panel": this, "preview_limit": 15, "listeners": { "render": Lino.quicktip_renderer("Art.60\u00a77-Konventionen","(jobs.jobs.ContractsByProvider) ") }, "split": true, "tools": [ Lino.show_in_own_window_button(Lino.jobs.ContractsByProvider.grid) ] });
    var jobs_panel1843 = new Lino.VBorderPanel({ "autoScroll": false, "listeners": { "activate": Lino.on_tab_activate }, "border": false, "title": "Stellen", "hideCheckBoxLabels": true, "items": [ JobsByProvider_grid1814, ContractsByProvider_grid1842 ], "frame": true, "bodyBorder": false, "labelAlign": "top" });
    var main_panel1844 = new Ext.TabPanel({ "hideCheckBoxLabels": true, "border": false, "split": true, "autoScroll": false, "items": [ general_panel1740, pcsw_NotesByCompany_grid1741, jobs_panel1843 ], "activeTab": 0, "bodyBorder": false, "frame": true, "labelAlign": "top" });
    this.items = main_panel1844;
    this.before_row_edit = function(record) {
      region1705.setContextValue('country',record ? record.data['countryHidden'] : undefined);
      city1709.setContextValue('country',record ? record.data['countryHidden'] : undefined);
      city1709.setContextValue('region',record ? record.data['regionHidden'] : undefined);
      contacts_RolesByCompany_grid1737.on_master_changed();
      pcsw_NotesByCompany_grid1741.on_master_changed();
      JobsByProvider_grid1814.on_master_changed();
      ContractsByProvider_grid1842.on_master_changed();
    }
    this.onRender = function(ct, position) {
      country1704.on('change',Lino.chooser_handler(region1705,'country'));
      country1704.on('change',Lino.chooser_handler(city1709,'country'));
      region1705.on('change',Lino.chooser_handler(city1709,'region'));
      Lino.jobs.JobProviders.DetailFormPanel.superclass.onRender.call(this, ct, position);
    }
    Lino.jobs.JobProviders.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.isip.Contracts.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 59,
  initComponent : function() {
    var containing_panel = this;
    var id1316 = new Ext.form.NumberField({ "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("ID","(isip.Contracts.id) ") }, "fieldLabel": "ID", "anchor": "-20", "name": "id" });
    var client1317 = new Lino.TwinCombo({ "preferred_width": 20, "fieldLabel": "Klient", "allowBlank": false, "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.pcsw.Clients.detail)}, "emptyText": "Klient ausw\u00e4hlen...", "listeners": { "render": Lino.quicktip_renderer("Klient","(isip.Contracts.client) ") }, "selectOnFocus": true, "hiddenName": "clientHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/isip/Contracts/client", "method": "GET" }) }), "name": "client" });
    var type1318 = new Lino.TwinCombo({ "preferred_width": 20, "fieldLabel": "Vertragsart", "name": "type", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.isip.ContractTypes.detail)}, "hiddenName": "typeHidden", "listeners": { "render": Lino.quicktip_renderer("Vertragsart","(isip.Contracts.type) ") }, "selectOnFocus": true, "emptyText": "VSE-Art ausw\u00e4hlen...", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/isip/Contracts/type", "method": "GET" }) }) });
    var user1319 = new Lino.TwinCombo({ "preferred_width": 15, "fieldLabel": "Autor", "name": "user", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.users.Users.detail)}, "hiddenName": "userHidden", "listeners": { "render": Lino.quicktip_renderer("Autor","(isip.Contracts.user) ") }, "selectOnFocus": true, "emptyText": "Benutzer ausw\u00e4hlen...", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/isip/Contracts/user", "method": "GET" }) }) });
    var user_asd1320 = new Lino.TwinCombo({ "preferred_width": 15, "fieldLabel": "Verantwortlicher (ASD)", "name": "user_asd", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.users.Users.detail)}, "hiddenName": "user_asdHidden", "listeners": { "render": Lino.quicktip_renderer("Verantwortlicher (ASD)","(isip.Contracts.user_asd) ") }, "selectOnFocus": true, "emptyText": "Benutzer ausw\u00e4hlen...", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/isip/Contracts/user_asd", "method": "GET" }) }) });
    var general_1_panel1321 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 207, "hideCheckBoxLabels": true, "items": [ { "flex": 9, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id1316, "labelAlign": "top" }, { "flex": 30, "autoHeight": true, "layout": "form", "xtype": "panel", "items": client1317, "labelAlign": "top" }, { "flex": 24, "autoHeight": true, "layout": "form", "xtype": "panel", "items": type1318, "labelAlign": "top" }, { "flex": 18, "autoHeight": true, "layout": "form", "xtype": "panel", "items": user1319, "labelAlign": "top" }, { "flex": 18, "autoHeight": true, "layout": "form", "xtype": "panel", "items": user_asd1320, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var study_type1327 = new Lino.TwinCombo({ "fieldLabel": "Ausbildungsart", "name": "study_type", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.isip.StudyTypes.detail)}, "emptyText": "Ausbildungsart ausw\u00e4hlen...", "listeners": { "render": Lino.quicktip_renderer("Ausbildungsart","(isip.Contracts.study_type) ") }, "selectOnFocus": true, "hiddenName": "study_typeHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/isip/Contracts/study_type", "method": "GET" }) }) });
    var company1328 = new Lino.TwinCombo({ "preferred_width": 20, "fieldLabel": "Organisation", "name": "company", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.contacts.Companies.detail)}, "hiddenName": "companyHidden", "listeners": { "render": Lino.quicktip_renderer("Organisation","(isip.Contracts.company) ") }, "selectOnFocus": true, "emptyText": "Organisation ausw\u00e4hlen...", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/isip/Contracts/company", "method": "GET" }) }) });
    var contact_person1329 = new Lino.TwinCombo({ "preferred_width": 20, "fieldLabel": "Vertreten durch", "name": "contact_person", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.contacts.Persons.detail)}, "hiddenName": "contact_personHidden", "listeners": { "render": Lino.quicktip_renderer("Vertreten durch","(isip.Contracts.contact_person) ") }, "selectOnFocus": true, "emptyText": "Person ausw\u00e4hlen...", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/isip/Contracts/contact_person", "method": "GET" }) }) });
    var contact_role1330 = new Lino.RemoteComboFieldElement({ "fieldLabel": "in seiner Eigenschaft als", "name": "contact_role", "pageSize": 20, "emptyText": "Funktion ausw\u00e4hlen...", "listeners": { "render": Lino.quicktip_renderer("in seiner Eigenschaft als","(isip.Contracts.contact_role) ") }, "selectOnFocus": true, "hiddenName": "contact_roleHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/isip/Contracts/contact_role", "method": "GET" }) }) });
    var general_2_panel1331 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 234, "hideCheckBoxLabels": true, "items": [ { "flex": 25, "autoHeight": true, "layout": "form", "xtype": "panel", "items": study_type1327, "labelAlign": "top" }, { "flex": 25, "autoHeight": true, "layout": "form", "xtype": "panel", "items": company1328, "labelAlign": "top" }, { "flex": 25, "autoHeight": true, "layout": "form", "xtype": "panel", "items": contact_person1329, "labelAlign": "top" }, { "flex": 25, "autoHeight": true, "layout": "form", "xtype": "panel", "items": contact_role1330, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var applies_from1336 = new Lino.DateField({ "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Laufzeit von","(isip.Contracts.applies_from) ") }, "fieldLabel": "Laufzeit von", "anchor": "-20", "name": "applies_from" });
    var applies_until1337 = new Lino.DateField({ "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Laufzeit bis","(isip.Contracts.applies_until) ") }, "fieldLabel": "Laufzeit bis", "anchor": "-20", "name": "applies_until" });
    var exam_policy1338 = new Lino.TwinCombo({ "fieldLabel": "Auswertungsstrategie", "name": "exam_policy", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.isip.ExamPolicies.detail)}, "emptyText": "Auswertungsstrategie ausw\u00e4hlen...", "listeners": { "render": Lino.quicktip_renderer("Auswertungsstrategie","(isip.Contracts.exam_policy) ") }, "selectOnFocus": true, "hiddenName": "exam_policyHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/isip/Contracts/exam_policy", "method": "GET" }) }) });
    var language1339 = new Lino.ChoicesFieldElement({ "fieldLabel": "Sprache", "allowBlank": false, "hiddenName": "languageHidden", "listeners": { "render": Lino.quicktip_renderer("Sprache","(isip.Contracts.language) ") }, "selectOnFocus": true, "anchor": "-20", "store": [ [ "en", "Englisch" ], [ "fr", "Franz\u00f6sisch" ], [ "de", "Deutsch" ], [ "nl", "Niederl\u00e4ndisch" ] ], "name": "language" });
    var general_3_panel1340 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 189, "hideCheckBoxLabels": true, "items": [ { "flex": 18, "autoHeight": true, "layout": "form", "xtype": "panel", "items": applies_from1336, "labelAlign": "top" }, { "flex": 18, "autoHeight": true, "layout": "form", "xtype": "panel", "items": applies_until1337, "labelAlign": "top" }, { "flex": 45, "autoHeight": true, "layout": "form", "xtype": "panel", "items": exam_policy1338, "labelAlign": "top" }, { "flex": 18, "autoHeight": true, "layout": "form", "xtype": "panel", "items": language1339, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var date_decided1345 = new Lino.DateField({ "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Beschlossen am","(isip.Contracts.date_decided) ") }, "fieldLabel": "Beschlossen am", "anchor": "-20", "name": "date_decided" });
    var date_issued1346 = new Lino.DateField({ "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Ausgestellt am","(isip.Contracts.date_issued) ") }, "fieldLabel": "Ausgestellt am", "anchor": "-20", "name": "date_issued" });
    var date_ended1347 = new Lino.DateField({ "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Enddatum","(isip.Contracts.date_ended) ") }, "fieldLabel": "Enddatum", "anchor": "-20", "name": "date_ended" });
    var ending1348 = new Lino.TwinCombo({ "fieldLabel": "Beendigungsgrund", "name": "ending", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.isip.ContractEndings.detail)}, "emptyText": "Beendigungsgrund ausw\u00e4hlen...", "listeners": { "render": Lino.quicktip_renderer("Beendigungsgrund","(isip.Contracts.ending) ") }, "selectOnFocus": true, "hiddenName": "endingHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/isip/Contracts/ending", "method": "GET" }) }) });
    var general_4_panel1349 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 153, "hideCheckBoxLabels": true, "items": [ { "flex": 18, "autoHeight": true, "layout": "form", "xtype": "panel", "items": date_decided1345, "labelAlign": "top" }, { "flex": 18, "autoHeight": true, "layout": "form", "xtype": "panel", "items": date_issued1346, "labelAlign": "top" }, { "flex": 18, "autoHeight": true, "layout": "form", "xtype": "panel", "items": date_ended1347, "labelAlign": "top" }, { "flex": 45, "autoHeight": true, "layout": "form", "xtype": "panel", "items": ending1348, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var cal_TasksByController_grid1354 = new Lino.cal.TasksByController.GridPanel({ "flex": 45, "hide_top_toolbar": true, "containing_panel": this, "params_panel_hidden": true, "master_panel": this, "preview_limit": 15, "listeners": { "render": Lino.quicktip_renderer("Aufgaben","(cal.cal.TasksByController) ") }, "tools": [ Lino.show_in_own_window_button(Lino.cal.TasksByController.grid) ] });
    var cal_EventsByController_grid1360 = new Lino.cal.EventsByController.GridPanel({ "flex": 54, "hide_top_toolbar": true, "containing_panel": this, "params_panel_hidden": true, "master_panel": this, "preview_limit": 15, "listeners": { "render": Lino.quicktip_renderer("Termine","(cal.cal.EventsByController) ") }, "tools": [ Lino.show_in_own_window_button(Lino.cal.EventsByController.grid) ] });
    var general_5_panel1361 = new Ext.Panel({ "flex": 55, "border": false, "layout": "hbox", "hideCheckBoxLabels": true, "items": [ cal_TasksByController_grid1354, cal_EventsByController_grid1360 ], "autoScroll": false, "layoutConfig": { "align": "stretch" }, "frame": false, "labelAlign": "top" });
    var general_panel1362 = new Ext.Panel({ "layout": "vbox", "title": "Allgemein", "items": [ general_1_panel1321, general_2_panel1331, general_3_panel1340, general_4_panel1349, general_5_panel1361 ], "frame": true, "layoutConfig": { "align": "stretch" }, "hideCheckBoxLabels": true, "listeners": { "activate": Lino.on_tab_activate }, "autoScroll": false, "border": false, "bodyBorder": false, "labelAlign": "top" });
    var stages1363 = new Lino.RichTextPanel({ "selectOnFocus": true, "flex": 50, "containing_panel": this, "name": "stages", "title": "Etappen" });
    var goals1364 = new Lino.RichTextPanel({ "selectOnFocus": true, "flex": 50, "containing_panel": this, "name": "goals", "title": "Zielsetzungen" });
    var isip_1_panel1365 = new Ext.Panel({ "flex": 5, "layout": "hbox", "items": [ stages1363, goals1364 ], "region": "north", "layoutConfig": { "align": "stretch" }, "hideCheckBoxLabels": true, "split": true, "autoScroll": false, "labelWidth": 0, "border": false, "frame": false, "labelAlign": "top" });
    var duties_asd1366 = new Lino.RichTextPanel({ "selectOnFocus": true, "flex": 50, "containing_panel": this, "name": "duties_asd", "title": "Verpflichtungen ASD" });
    var duties_dsbe1367 = new Lino.RichTextPanel({ "selectOnFocus": true, "flex": 50, "containing_panel": this, "name": "duties_dsbe", "title": "Verpflichtungen DSBE" });
    var isip_2_panel1368 = new Ext.Panel({ "flex": 5, "layout": "hbox", "items": [ duties_asd1366, duties_dsbe1367 ], "region": "center", "layoutConfig": { "align": "stretch" }, "hideCheckBoxLabels": true, "split": true, "autoScroll": false, "labelWidth": 0, "border": false, "frame": false, "labelAlign": "top" });
    var duties_company1369 = new Lino.RichTextPanel({ "selectOnFocus": true, "flex": 50, "containing_panel": this, "name": "duties_company", "title": "Verpflichtungen Firma" });
    var duties_person1370 = new Lino.RichTextPanel({ "selectOnFocus": true, "flex": 50, "containing_panel": this, "name": "duties_person", "title": "Verpflichtungen Person" });
    var isip_3_panel1371 = new Ext.Panel({ "flex": 5, "layout": "hbox", "items": [ duties_company1369, duties_person1370 ], "region": "south", "layoutConfig": { "align": "stretch" }, "hideCheckBoxLabels": true, "split": true, "autoScroll": false, "labelWidth": 0, "border": false, "frame": false, "labelAlign": "top" });
    var isip_panel1372 = new Lino.VBorderPanel({ "autoScroll": false, "listeners": { "activate": Lino.on_tab_activate }, "border": false, "title": "VSE", "hideCheckBoxLabels": true, "items": [ isip_1_panel1365, isip_2_panel1368, isip_3_panel1371 ], "frame": true, "bodyBorder": false, "labelAlign": "top" });
    var main_panel1373 = new Ext.TabPanel({ "hideCheckBoxLabels": true, "border": false, "split": true, "autoScroll": false, "items": [ general_panel1362, isip_panel1372 ], "activeTab": 0, "bodyBorder": false, "frame": true, "labelAlign": "top" });
    this.items = main_panel1373;
    this.before_row_edit = function(record) {
      contact_person1329.setContextValue('company',record ? record.data['companyHidden'] : undefined);
      cal_TasksByController_grid1354.on_master_changed();
      cal_EventsByController_grid1360.on_master_changed();
      stages1363.refresh();
      goals1364.refresh();
      duties_asd1366.refresh();
      duties_dsbe1367.refresh();
      duties_company1369.refresh();
      duties_person1370.refresh();
    }
    this.onRender = function(ct, position) {
      company1328.on('change',Lino.chooser_handler(contact_person1329,'company'));
      Lino.isip.Contracts.DetailFormPanel.superclass.onRender.call(this, ct, position);
    }
    Lino.isip.Contracts.DetailFormPanel.superclass.initComponent.call(this);
    // active_fields:
    company1328.on("change",function(){this.save()},this);
  }
});


Lino.cal.Tasks.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 29,
  initComponent : function() {
    var containing_panel = this;
    var start_date147 = new Lino.DateField({ "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Beginnt am","(cal.Tasks.start_date) ") }, "fieldLabel": "Beginnt am", "anchor": "-20", "name": "start_date" });
    var due_date148 = new Lino.DateField({ "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Zahlungsziel","(cal.Tasks.due_date) ") }, "fieldLabel": "Zahlungsziel", "anchor": "-20", "name": "due_date" });
    var id149 = new Ext.form.NumberField({ "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("ID","(cal.Tasks.id) ") }, "fieldLabel": "ID", "anchor": "-20", "name": "id" });
    var workflow_buttons_disp150 = new Ext.form.DisplayField({ "disabled": true, "listeners": { "render": Lino.quicktip_renderer("Arbeitsablauf","(cal.Tasks.workflow_buttons) ") }, "fieldLabel": "Arbeitsablauf", "name": "workflow_buttons", "anchor": "-20", "value": "<br/>", "always_enabled": true });
    var main_1_panel151 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 126, "hideCheckBoxLabels": true, "items": [ { "flex": 15, "autoHeight": true, "layout": "form", "xtype": "panel", "items": start_date147, "labelAlign": "top" }, { "flex": 15, "autoHeight": true, "layout": "form", "xtype": "panel", "items": due_date148, "labelAlign": "top" }, { "flex": 9, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id149, "labelAlign": "top" }, { "flex": 58, "autoHeight": true, "layout": "form", "xtype": "panel", "items": workflow_buttons_disp150, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var summary156 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Kurzbeschreibung","(cal.Tasks.summary) ") }, "fieldLabel": "Kurzbeschreibung", "name": "summary", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var user157 = new Lino.TwinCombo({ "preferred_width": 15, "fieldLabel": "Autor", "name": "user", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.users.Users.detail)}, "hiddenName": "userHidden", "listeners": { "render": Lino.quicktip_renderer("Autor","(cal.Tasks.user) ") }, "selectOnFocus": true, "emptyText": "Benutzer ausw\u00e4hlen...", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/Tasks/user", "method": "GET" }) }) });
    var project158 = new Lino.TwinCombo({ "preferred_width": 20, "fieldLabel": "Klient", "name": "project", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.pcsw.Clients.detail)}, "hiddenName": "projectHidden", "listeners": { "render": Lino.quicktip_renderer("Klient","(cal.Tasks.project) ") }, "selectOnFocus": true, "emptyText": "Klient ausw\u00e4hlen...", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/Tasks/project", "method": "GET" }) }) });
    var main_3_panel159 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 63, "hideCheckBoxLabels": true, "items": [ { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": user157, "labelAlign": "top" }, { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": project158, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var calendar162 = new Lino.TwinCombo({ "fieldLabel": "Kalender", "name": "calendar", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.cal.Calendars.detail)}, "emptyText": "Kalender ausw\u00e4hlen...", "listeners": { "render": Lino.quicktip_renderer("Kalender","(cal.Tasks.calendar) ") }, "selectOnFocus": true, "hiddenName": "calendarHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/Tasks/calendar", "method": "GET" }) }) });
    var owner_disp163 = new Ext.form.DisplayField({ "disabled": true, "fieldLabel": "Verkn\u00fcpft mit", "anchor": "-20", "name": "owner" });
    var created164 = new Ext.form.DisplayField({ "disabled": true, "listeners": { "render": Lino.quicktip_renderer("Erstellt","(cal.Tasks.created) ") }, "fieldLabel": "Erstellt", "name": "created", "anchor": "-20", "value": "<br>" });
    var modified165 = new Ext.form.DisplayField({ "disabled": true, "listeners": { "render": Lino.quicktip_renderer("Bearbeitet","(cal.Tasks.modified) ") }, "fieldLabel": "Bearbeitet", "name": "modified", "anchor": "-20", "value": "<br>" });
    var main_4_panel166 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 126, "hideCheckBoxLabels": true, "items": [ { "flex": 28, "autoHeight": true, "layout": "form", "xtype": "panel", "items": calendar162, "labelAlign": "top" }, { "flex": 14, "autoHeight": true, "layout": "form", "xtype": "panel", "items": owner_disp163, "labelAlign": "top" }, { "flex": 28, "autoHeight": true, "layout": "form", "xtype": "panel", "items": created164, "labelAlign": "top" }, { "flex": 28, "autoHeight": true, "layout": "form", "xtype": "panel", "items": modified165, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var description171 = new Lino.RichTextPanel({ "selectOnFocus": true, "flex": 45, "containing_panel": this, "name": "description", "title": "Beschreibung" });
    var main_panel172 = new Ext.Panel({ "autoScroll": false, "border": false, "layout": "vbox", "labelWidth": 153, "hideCheckBoxLabels": true, "items": [ main_1_panel151, { "items": summary156, "autoHeight": true, "layout": "form", "xtype": "panel", "labelAlign": "top" }, main_3_panel159, main_4_panel166, description171 ], "frame": true, "layoutConfig": { "align": "stretch" }, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel172;
    this.before_row_edit = function(record) {
      description171.refresh();
    }
    Lino.cal.Tasks.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.isip.Contracts.InsertFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  autoHeight: true,
  content_type: 59,
  initComponent : function() {
    var containing_panel = this;
    var client1374 = new Lino.TwinCombo({ "preferred_width": 20, "fieldLabel": "Klient", "allowBlank": false, "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.pcsw.Clients.detail)}, "emptyText": "Klient ausw\u00e4hlen...", "listeners": { "render": Lino.quicktip_renderer("Klient","(isip.Contracts.client) ") }, "selectOnFocus": true, "hiddenName": "clientHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/isip/Contracts/client", "method": "GET" }) }), "name": "client" });
    var type1375 = new Lino.TwinCombo({ "preferred_width": 20, "fieldLabel": "Vertragsart", "name": "type", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.isip.ContractTypes.detail)}, "hiddenName": "typeHidden", "listeners": { "render": Lino.quicktip_renderer("Vertragsart","(isip.Contracts.type) ") }, "selectOnFocus": true, "emptyText": "VSE-Art ausw\u00e4hlen...", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/isip/Contracts/type", "method": "GET" }) }) });
    var company1376 = new Lino.TwinCombo({ "preferred_width": 20, "fieldLabel": "Organisation", "name": "company", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.contacts.Companies.detail)}, "hiddenName": "companyHidden", "listeners": { "render": Lino.quicktip_renderer("Organisation","(isip.Contracts.company) ") }, "selectOnFocus": true, "emptyText": "Organisation ausw\u00e4hlen...", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/isip/Contracts/company", "method": "GET" }) }) });
    var main_2_panel1377 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": type1375, "labelAlign": "top" }, { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": company1376, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 117, "border": false, "anchor": "-20", "labelAlign": "top" });
    var main_panel1380 = new Ext.Panel({ "hideCheckBoxLabels": true, "autoHeight": true, "border": false, "layout": "form", "labelWidth": 63, "autoScroll": false, "items": [ { "autoHeight": true, "layout": "form", "xtype": "panel", "items": client1374, "anchor": "-20", "labelAlign": "top" }, main_2_panel1377 ], "frame": true, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel1380;
    this.before_row_edit = function(record) {
    }
    Lino.isip.Contracts.InsertFormPanel.superclass.initComponent.call(this);
    // active_fields:
    company1376.on("change",function(){this.save()},this);
  }
});


Lino.uploads.MyUploads.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 25,
  initComponent : function() {
    var containing_panel = this;
    var file2978 = Lino.file_field_handler(this,{ "listeners": { "render": Lino.quicktip_renderer("File","(uploads.Uploads.file) ") }, "fieldLabel": "File", "name": "file", "maxLength": 100, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var user2979 = new Lino.TwinCombo({ "preferred_width": 15, "fieldLabel": "Autor", "name": "user", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.users.Users.detail)}, "hiddenName": "userHidden", "listeners": { "render": Lino.quicktip_renderer("Autor","(uploads.Uploads.user) ") }, "selectOnFocus": true, "emptyText": "Benutzer ausw\u00e4hlen...", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/uploads/Uploads/user", "method": "GET" }) }) });
    var main_1_panel2980 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 54, "hideCheckBoxLabels": true, "items": [ { "flex": 51, "autoHeight": true, "layout": "form", "xtype": "panel", "items": file2978, "labelAlign": "top" }, { "flex": 48, "autoHeight": true, "layout": "form", "xtype": "panel", "items": user2979, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var type2983 = new Lino.RemoteComboFieldElement({ "fieldLabel": "Upload-Art", "name": "type", "pageSize": 20, "emptyText": "Upload-Art ausw\u00e4hlen...", "listeners": { "render": Lino.quicktip_renderer("Upload-Art","(uploads.Uploads.type) ") }, "selectOnFocus": true, "hiddenName": "typeHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/uploads/Uploads/type", "method": "GET" }) }) });
    var description2984 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Beschreibung","(uploads.Uploads.description) ") }, "fieldLabel": "Beschreibung", "name": "description", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var valid_until2985 = new Lino.DateField({ "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("g\u00fcltig bis","(uploads.Uploads.valid_until) ") }, "fieldLabel": "g\u00fcltig bis", "anchor": "-20", "name": "valid_until" });
    var main_2_panel2986 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 117, "hideCheckBoxLabels": true, "items": [ { "flex": 40, "autoHeight": true, "layout": "form", "xtype": "panel", "items": type2983, "labelAlign": "top" }, { "flex": 42, "autoHeight": true, "layout": "form", "xtype": "panel", "items": description2984, "labelAlign": "top" }, { "flex": 16, "autoHeight": true, "layout": "form", "xtype": "panel", "items": valid_until2985, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var modified2990 = new Ext.form.DisplayField({ "disabled": true, "listeners": { "render": Lino.quicktip_renderer("Bearbeitet","(uploads.Uploads.modified) ") }, "fieldLabel": "Bearbeitet", "name": "modified", "anchor": "-20", "value": "<br>" });
    var created2991 = new Ext.form.DisplayField({ "disabled": true, "listeners": { "render": Lino.quicktip_renderer("Erstellt","(uploads.Uploads.created) ") }, "fieldLabel": "Erstellt", "name": "created", "anchor": "-20", "value": "<br>" });
    var owner_disp2992 = new Ext.form.DisplayField({ "disabled": true, "fieldLabel": "Verkn\u00fcpft mit", "anchor": "-20", "name": "owner" });
    var main_3_panel2993 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 126, "hideCheckBoxLabels": true, "items": [ { "flex": 38, "autoHeight": true, "layout": "form", "xtype": "panel", "items": modified2990, "labelAlign": "top" }, { "flex": 38, "autoHeight": true, "layout": "form", "xtype": "panel", "items": created2991, "labelAlign": "top" }, { "flex": 23, "autoHeight": true, "layout": "form", "xtype": "panel", "items": owner_disp2992, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var cal_TasksByController_grid2997 = new Lino.cal.TasksByController.GridPanel({ "flex": 62, "hide_top_toolbar": true, "containing_panel": this, "params_panel_hidden": true, "master_panel": this, "preview_limit": 15, "listeners": { "render": Lino.quicktip_renderer("Aufgaben","(cal.cal.TasksByController) ") }, "tools": [ Lino.show_in_own_window_button(Lino.cal.TasksByController.grid) ] });
    var main_panel2998 = new Ext.Panel({ "autoScroll": false, "border": false, "layout": "vbox", "hideCheckBoxLabels": true, "items": [ main_1_panel2980, main_2_panel2986, main_3_panel2993, cal_TasksByController_grid2997 ], "frame": true, "layoutConfig": { "align": "stretch" }, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel2998;
    this.before_row_edit = function(record) {
      cal_TasksByController_grid2997.on_master_changed();
    }
    Lino.uploads.MyUploads.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.jobs.Contracts.InsertFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  autoHeight: true,
  content_type: 70,
  initComponent : function() {
    var containing_panel = this;
    var client1532 = new Lino.TwinCombo({ "preferred_width": 20, "fieldLabel": "Klient", "allowBlank": false, "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.pcsw.Clients.detail)}, "emptyText": "Klient ausw\u00e4hlen...", "listeners": { "render": Lino.quicktip_renderer("Klient","(jobs.Contracts.client) ") }, "selectOnFocus": true, "hiddenName": "clientHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/jobs/Contracts/client", "method": "GET" }) }), "name": "client" });
    var job1533 = new Lino.TwinCombo({ "preferred_width": 20, "fieldLabel": "Stelle", "allowBlank": false, "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.jobs.Jobs.detail)}, "emptyText": "Stelle ausw\u00e4hlen...", "listeners": { "render": Lino.quicktip_renderer("Stelle","(jobs.Contracts.job) ") }, "selectOnFocus": true, "hiddenName": "jobHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/jobs/Contracts/job", "method": "GET" }) }), "name": "job" });
    var main_panel1534 = new Ext.Panel({ "hideCheckBoxLabels": true, "autoHeight": true, "border": false, "layout": "form", "labelWidth": 63, "autoScroll": false, "items": [ { "autoHeight": true, "layout": "form", "xtype": "panel", "items": client1532, "anchor": "-20", "labelAlign": "top" }, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": job1533, "anchor": "-20", "labelAlign": "top" } ], "frame": true, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel1534;
    this.before_row_edit = function(record) {
    }
    Lino.jobs.Contracts.InsertFormPanel.superclass.initComponent.call(this);
    // active_fields:
    job1533.on("change",function(){this.save()},this);
  }
});


Lino.system.Home.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  disable_editing: true,
  initComponent : function() {
    var containing_panel = this;
    var quick_links_htmlbox3038 = new Lino.HtmlBoxPanel({ "flex": 1, "layout": "fit", "name": "quick_links", "containing_panel": this, "master_panel": this, "items": new Ext.BoxComponent({autoScroll:true}), "region": "north", "bodyStyle": "overflow-x:hidden;", "value": "<br/>", "always_enabled": true, "listeners": { "render": Lino.quicktip_renderer(null,"(system.Home.quick_links) ") }, "split": true });
    var welcome_htmlbox3039 = new Lino.HtmlBoxPanel({ "flex": 3, "layout": "fit", "name": "welcome", "containing_panel": this, "master_panel": this, "items": new Ext.BoxComponent({autoScroll:true}), "region": "center", "title": "Willkommen", "bodyStyle": "overflow-x:hidden;", "value": "<br/>", "always_enabled": true, "listeners": { "render": Lino.quicktip_renderer("Willkommen","(system.Home.welcome) ") }, "split": true });
    var main_panel3040 = new Lino.VBorderPanel({ "autoScroll": false, "border": false, "labelWidth": 99, "hideCheckBoxLabels": true, "items": [ quick_links_htmlbox3038, welcome_htmlbox3039 ], "frame": true, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel3040;
    this.before_row_edit = function(record) {
      quick_links_htmlbox3038.refresh();
      welcome_htmlbox3039.refresh();
    }
    Lino.system.Home.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.users.MySettings.InsertFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  autoHeight: true,
  content_type: 7,
  initComponent : function() {
    var containing_panel = this;
    var username226 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Benutzername","(users.Users.username) Required. Must be unique.") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Benutzername</span>", "name": "username", "maxLength": 30, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var email227 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("e-mail address","(users.Users.email) ") }, "fieldLabel": "e-mail address", "name": "email", "maxLength": 75, "selectOnFocus": true, "anchor": "-20" });
    var main_1_panel228 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": username226, "labelAlign": "top" }, { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": email227, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 135, "border": false, "anchor": "-20", "labelAlign": "top" });
    var first_name231 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Vorname","(users.Users.first_name) ") }, "fieldLabel": "Vorname", "name": "first_name", "maxLength": 30, "selectOnFocus": true, "anchor": "-20" });
    var last_name232 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Familienname","(users.Users.last_name) ") }, "fieldLabel": "Familienname", "name": "last_name", "maxLength": 30, "selectOnFocus": true, "anchor": "-20" });
    var main_2_panel233 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": first_name231, "labelAlign": "top" }, { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": last_name232, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 117, "border": false, "anchor": "-20", "labelAlign": "top" });
    var partner236 = new Lino.TwinCombo({ "preferred_width": 20, "fieldLabel": "Partner", "name": "partner", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.contacts.Partners.detail)}, "hiddenName": "partnerHidden", "listeners": { "render": Lino.quicktip_renderer("Partner","(users.Users.partner) ") }, "selectOnFocus": true, "emptyText": "Partner ausw\u00e4hlen...", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/users/Users/partner", "method": "GET" }) }) });
    var language237 = new Lino.ChoicesFieldElement({ "listeners": { "render": Lino.quicktip_renderer("Sprache","(users.Users.language) ") }, "fieldLabel": "Sprache", "name": "language", "selectOnFocus": true, "anchor": "-20", "store": [ [ "en", "Englisch" ], [ "fr", "Franz\u00f6sisch" ], [ "de", "Deutsch" ], [ "nl", "Niederl\u00e4ndisch" ] ], "hiddenName": "languageHidden" });
    var profile238 = new Lino.ChoicesFieldElement({ "forceSelection": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Benutzerprofil</span>", "name": "profile", "hiddenName": "profileHidden", "listeners": { "render": Lino.quicktip_renderer("Benutzerprofil","(users.Users.profile) Users with an empty `profile` field are considered inactive and cannot log in.") }, "selectOnFocus": true, "anchor": "-20", "store": [['','<br>']].concat(Lino.lino.UserProfiles) });
    var main_4_panel239 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 35, "autoHeight": true, "layout": "form", "xtype": "panel", "items": language237, "labelAlign": "top" }, { "flex": 64, "autoHeight": true, "layout": "form", "xtype": "panel", "items": profile238, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 135, "border": false, "anchor": "-20", "labelAlign": "top" });
    var main_panel242 = new Ext.Panel({ "hideCheckBoxLabels": true, "autoHeight": true, "border": false, "layout": "form", "labelWidth": 72, "autoScroll": false, "items": [ main_1_panel228, main_2_panel233, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": partner236, "anchor": "-20", "labelAlign": "top" }, main_4_panel239 ], "frame": true, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel242;
    this.before_row_edit = function(record) {
    }
    Lino.users.MySettings.InsertFormPanel.superclass.initComponent.call(this);
    // active_fields:
    partner236.on("change",function(){this.save()},this);
  }
});


Lino.cal.Tasks.InsertFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  autoHeight: true,
  content_type: 29,
  initComponent : function() {
    var containing_panel = this;
    var summary174 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Kurzbeschreibung","(cal.Tasks.summary) ") }, "fieldLabel": "Kurzbeschreibung", "name": "summary", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var user175 = new Lino.TwinCombo({ "preferred_width": 15, "fieldLabel": "Autor", "name": "user", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.users.Users.detail)}, "hiddenName": "userHidden", "listeners": { "render": Lino.quicktip_renderer("Autor","(cal.Tasks.user) ") }, "selectOnFocus": true, "emptyText": "Benutzer ausw\u00e4hlen...", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/Tasks/user", "method": "GET" }) }) });
    var project176 = new Lino.TwinCombo({ "preferred_width": 20, "fieldLabel": "Klient", "name": "project", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.pcsw.Clients.detail)}, "hiddenName": "projectHidden", "listeners": { "render": Lino.quicktip_renderer("Klient","(cal.Tasks.project) ") }, "selectOnFocus": true, "emptyText": "Klient ausw\u00e4hlen...", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/Tasks/project", "method": "GET" }) }) });
    var main_2_panel177 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": user175, "labelAlign": "top" }, { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": project176, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 63, "border": false, "anchor": "-20", "labelAlign": "top" });
    var main_panel180 = new Ext.Panel({ "hideCheckBoxLabels": true, "autoHeight": true, "border": false, "layout": "form", "labelWidth": 153, "autoScroll": false, "items": [ { "autoHeight": true, "layout": "form", "xtype": "panel", "items": summary174, "anchor": "-20", "labelAlign": "top" }, main_2_panel177 ], "frame": true, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel180;
    this.before_row_edit = function(record) {
    }
    Lino.cal.Tasks.InsertFormPanel.superclass.initComponent.call(this);
  }
});


Lino.households.Households.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 39,
  initComponent : function() {
    var containing_panel = this;
    var type1190 = new Lino.TwinCombo({ "fieldLabel": "Haushaltsart", "name": "type", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.households.Types.detail)}, "emptyText": "Haushaltsart ausw\u00e4hlen...", "listeners": { "render": Lino.quicktip_renderer("Haushaltsart","(households.Households.type) ") }, "selectOnFocus": true, "hiddenName": "typeHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/households/Households/type", "method": "GET" }) }) });
    var name1191 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Name","(households.Households.name) ") }, "fieldLabel": "Name", "name": "name", "maxLength": 200, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var language1192 = new Lino.ChoicesFieldElement({ "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Sprache</span>", "allowBlank": false, "hiddenName": "languageHidden", "listeners": { "render": Lino.quicktip_renderer("Sprache","(households.Households.language) Die Sprache, in der Dokumente ausgestellt werden sollen.") }, "selectOnFocus": true, "anchor": "-20", "store": [ [ "en", "Englisch" ], [ "fr", "Franz\u00f6sisch" ], [ "de", "Deutsch" ], [ "nl", "Niederl\u00e4ndisch" ] ], "name": "language" });
    var id1193 = new Ext.form.NumberField({ "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("ID","(households.Households.id) ") }, "fieldLabel": "ID", "anchor": "-20", "name": "id" });
    var intro_box_1_panel1194 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 117, "hideCheckBoxLabels": true, "items": [ { "flex": 35, "autoHeight": true, "layout": "form", "xtype": "panel", "items": type1190, "labelAlign": "top" }, { "flex": 37, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name1191, "labelAlign": "top" }, { "flex": 17, "autoHeight": true, "layout": "form", "xtype": "panel", "items": language1192, "labelAlign": "top" }, { "flex": 8, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id1193, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var country1199 = new Lino.TwinCombo({ "fieldLabel": "Land", "name": "country", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.countries.Countries.detail)}, "emptyText": "Land ausw\u00e4hlen...", "listeners": { "render": Lino.quicktip_renderer("Land","(households.Households.country) ") }, "selectOnFocus": true, "hiddenName": "countryHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/households/Households/country", "method": "GET" }) }) });
    var region1200 = new Lino.TwinCombo({ "fieldLabel": "Region", "name": "region", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.countries.Cities.detail)}, "emptyText": "Ort ausw\u00e4hlen...", "listeners": { "render": Lino.quicktip_renderer("Region","(households.Households.region) ") }, "selectOnFocus": true, "hiddenName": "regionHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/households/Households/region", "method": "GET" }) }) });
    var box3_1_panel1201 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": country1199, "labelAlign": "top" }, { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": region1200, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 63, "border": false, "anchor": "-20", "labelAlign": "top" });
    var city1204 = new Lino.TwinCombo({ "forceSelection": false, "fieldLabel": "Ort", "name": "city", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.countries.Cities.detail)}, "emptyText": "Ort ausw\u00e4hlen...", "listeners": { "render": Lino.quicktip_renderer("Ort","(households.Households.city) ") }, "selectOnFocus": true, "hiddenName": "cityHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/households/Households/city", "method": "GET" }) }) });
    var zip_code1205 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Postleitzahl","(households.Households.zip_code) ") }, "fieldLabel": "Postleitzahl", "name": "zip_code", "maxLength": 10, "selectOnFocus": true, "boxMinWidth": Lino.chars2width(10), "anchor": "-20" });
    var box3_2_panel1206 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 66, "autoHeight": true, "layout": "form", "xtype": "panel", "items": city1204, "labelAlign": "top" }, { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": zip_code1205, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 117, "border": false, "anchor": "-20", "labelAlign": "top" });
    var street_prefix1209 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Pr\u00e4fix Stra\u00dfe","(households.Households.street_prefix) Text to print before name of street, but to ignore for sorting.") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Pr\u00e4fix Stra\u00dfe</span>", "name": "street_prefix", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var street1210 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Stra\u00dfe","(households.Households.street) Name of street. Without house number.") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Stra\u00dfe</span>", "name": "street", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var street_no1211 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Nr.","(households.Households.street_no) House number") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Nr.</span>", "name": "street_no", "maxLength": 10, "selectOnFocus": true, "boxMinWidth": Lino.chars2width(10), "anchor": "-20" });
    var street_box1212 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Box","(households.Households.street_box) Text to print after :attr:`steet_no` on the same line") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Box</span>", "name": "street_box", "maxLength": 10, "selectOnFocus": true, "boxMinWidth": Lino.chars2width(10), "anchor": "-20" });
    var box3_3_panel1213 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 30, "autoHeight": true, "layout": "form", "xtype": "panel", "items": street_prefix1209, "labelAlign": "top" }, { "flex": 36, "autoHeight": true, "layout": "form", "xtype": "panel", "items": street1210, "labelAlign": "top" }, { "flex": 16, "autoHeight": true, "layout": "form", "xtype": "panel", "items": street_no1211, "labelAlign": "top" }, { "flex": 16, "autoHeight": true, "layout": "form", "xtype": "panel", "items": street_box1212, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 126, "border": false, "anchor": "-20", "labelAlign": "top" });
    var addr21218 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Adresszeile nach Stra\u00dfe","(households.Households.addr2) Address line to print below street line") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Adresszeile nach Stra\u00dfe</span>", "name": "addr2", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var activity1219 = new Lino.RemoteComboFieldElement({ "fieldLabel": "Beruf", "name": "activity", "pageSize": 20, "emptyText": "Beruf ausw\u00e4hlen...", "listeners": { "render": Lino.quicktip_renderer("Beruf","(households.Households.activity) ") }, "selectOnFocus": true, "hiddenName": "activityHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/households/Households/activity", "method": "GET" }) }) });
    var bank_account11220 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Bankkonto 1","(households.Households.bank_account1) ") }, "fieldLabel": "Bankkonto 1", "name": "bank_account1", "maxLength": 40, "selectOnFocus": true, "anchor": "-20" });
    var bank_account21221 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Bankkonto 2","(households.Households.bank_account2) ") }, "fieldLabel": "Bankkonto 2", "name": "bank_account2", "maxLength": 40, "selectOnFocus": true, "anchor": "-20" });
    var box3_5_panel1222 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 45, "autoHeight": true, "layout": "form", "xtype": "panel", "items": activity1219, "labelAlign": "top" }, { "flex": 27, "autoHeight": true, "layout": "form", "xtype": "panel", "items": bank_account11220, "labelAlign": "top" }, { "flex": 27, "autoHeight": true, "layout": "form", "xtype": "panel", "items": bank_account21221, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 108, "border": false, "anchor": "-20", "labelAlign": "top" });
    var box3_panel1226 = new Ext.Panel({ "flex": 62, "autoHeight": true, "layout": "form", "items": [ box3_1_panel1201, box3_2_panel1206, box3_3_panel1213, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": addr21218, "anchor": "-20", "labelAlign": "top" }, box3_5_panel1222 ], "frame": true, "bodyBorder": false, "autoScroll": false, "hideCheckBoxLabels": true, "labelWidth": 216, "border": false, "labelAlign": "top" });
    var email1228 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("E-Mail","(households.Households.email) ") }, "fieldLabel": "E-Mail", "name": "email", "maxLength": 75, "selectOnFocus": true, "anchor": "-20" });
    var url1229 = new Lino.URLField({ "listeners": { "render": Lino.quicktip_renderer("URL","(households.Households.url) ") }, "fieldLabel": "URL", "name": "url", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var phone1230 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Telefon","(households.Households.phone) ") }, "fieldLabel": "Telefon", "name": "phone", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var gsm1231 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("GSM","(households.Households.gsm) ") }, "fieldLabel": "GSM", "name": "gsm", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var box4_panel1232 = new Ext.Panel({ "flex": 37, "autoHeight": true, "layout": "form", "items": [ { "autoHeight": true, "layout": "form", "xtype": "panel", "items": email1228, "anchor": "-20", "labelAlign": "top" }, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": url1229, "anchor": "-20", "labelAlign": "top" }, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": phone1230, "anchor": "-20", "labelAlign": "top" }, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": gsm1231, "anchor": "-20", "labelAlign": "top" } ], "frame": true, "bodyBorder": false, "autoScroll": false, "hideCheckBoxLabels": true, "labelWidth": 72, "border": false, "labelAlign": "top" });
    var address_box_panel1237 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "hideCheckBoxLabels": true, "items": [ box3_panel1226, box4_panel1232 ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var remarks1238 = new Ext.form.TextArea({ "listeners": { "render": Lino.quicktip_renderer("Bemerkungen","(households.Households.remarks) ") }, "fieldLabel": "Bemerkungen", "name": "remarks", "growMax": 2000, "selectOnFocus": true, "anchor": "-20 -10" });
    var households_MembersByHousehold_grid1245 = new Lino.households.MembersByHousehold.GridPanel({ "flex": 50, "listeners": { "render": Lino.quicktip_renderer("Mitglieder","(households.households.MembersByHousehold) ") }, "hide_top_toolbar": true, "containing_panel": this, "tools": [ Lino.show_in_own_window_button(Lino.households.MembersByHousehold.grid) ], "preview_limit": 15, "master_panel": this });
    var bottom_box_panel1246 = new Ext.Panel({ "flex": 45, "border": false, "layout": "hbox", "labelWidth": 108, "hideCheckBoxLabels": true, "items": [ { "items": remarks1238, "labelAlign": "top", "layout": "form", "xtype": "panel", "flex": 49 }, households_MembersByHousehold_grid1245 ], "autoScroll": false, "layoutConfig": { "align": "stretch" }, "frame": false, "labelAlign": "top" });
    var general_panel1248 = new Ext.Panel({ "layout": "vbox", "title": "Allgemein", "items": [ intro_box_1_panel1194, address_box_panel1237, bottom_box_panel1246 ], "frame": true, "layoutConfig": { "align": "stretch" }, "hideCheckBoxLabels": true, "listeners": { "activate": Lino.on_tab_activate }, "autoScroll": false, "border": false, "bodyBorder": false, "labelAlign": "top" });
    var main_panel1252 = new Ext.TabPanel({ "hideCheckBoxLabels": true, "border": false, "split": true, "autoScroll": false, "items": [ general_panel1248 ], "activeTab": 0, "bodyBorder": false, "frame": true, "labelAlign": "top" });
    this.items = main_panel1252;
    this.before_row_edit = function(record) {
      region1200.setContextValue('country',record ? record.data['countryHidden'] : undefined);
      city1204.setContextValue('country',record ? record.data['countryHidden'] : undefined);
      city1204.setContextValue('region',record ? record.data['regionHidden'] : undefined);
      households_MembersByHousehold_grid1245.on_master_changed();
    }
    this.onRender = function(ct, position) {
      country1199.on('change',Lino.chooser_handler(region1200,'country'));
      country1199.on('change',Lino.chooser_handler(city1204,'country'));
      region1200.on('change',Lino.chooser_handler(city1204,'region'));
      Lino.households.Households.DetailFormPanel.superclass.onRender.call(this, ct, position);
    }
    Lino.households.Households.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.courses.CourseOffers.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 81,
  initComponent : function() {
    var containing_panel = this;
    var id2611 = new Ext.form.NumberField({ "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("ID","(courses.CourseOffers.id) ") }, "fieldLabel": "ID", "anchor": "-20", "name": "id" });
    var title2612 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Name","(courses.CourseOffers.title) ") }, "fieldLabel": "Name", "name": "title", "maxLength": 200, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var content2613 = new Lino.TwinCombo({ "fieldLabel": "Kursinhalt", "allowBlank": false, "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.courses.CourseContents.detail)}, "emptyText": "Kursinhalt ausw\u00e4hlen...", "listeners": { "render": Lino.quicktip_renderer("Kursinhalt","(courses.CourseOffers.content) ") }, "selectOnFocus": true, "hiddenName": "contentHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/courses/CourseOffers/content", "method": "GET" }) }), "name": "content" });
    var provider2614 = new Lino.TwinCombo({ "preferred_width": 20, "fieldLabel": "Kursanbieter", "allowBlank": false, "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.courses.CourseProviders.detail)}, "emptyText": "Kursanbieter ausw\u00e4hlen...", "listeners": { "render": Lino.quicktip_renderer("Kursanbieter","(courses.CourseOffers.provider) ") }, "selectOnFocus": true, "hiddenName": "providerHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/courses/CourseOffers/provider", "method": "GET" }) }), "name": "provider" });
    var main_1_panel2615 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 11, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id2611, "labelAlign": "top" }, { "flex": 30, "autoHeight": true, "layout": "form", "xtype": "panel", "items": title2612, "labelAlign": "top" }, { "flex": 28, "autoHeight": true, "layout": "form", "xtype": "panel", "items": content2613, "labelAlign": "top" }, { "flex": 28, "autoHeight": true, "layout": "form", "xtype": "panel", "items": provider2614, "labelAlign": "top" } ], "region": "north", "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "split": true, "autoScroll": false, "labelWidth": 117, "border": false, "frame": false, "labelAlign": "top" });
    var description2620 = new Lino.RichTextPanel({ "flex": 5, "split": true, "containing_panel": this, "selectOnFocus": true, "region": "center", "title": "Beschreibung", "name": "description" });
    var CoursesByOffer_grid2651 = new Lino.courses.CoursesByOffer.GridPanel({ "flex": 5, "hide_top_toolbar": true, "containing_panel": this, "region": "south", "preview_limit": 15, "master_panel": this, "listeners": { "render": Lino.quicktip_renderer("Kurse","(courses.courses.CoursesByOffer) ") }, "split": true, "tools": [ Lino.show_in_own_window_button(Lino.courses.CoursesByOffer.grid) ] });
    var main_panel2652 = new Lino.VBorderPanel({ "autoScroll": false, "border": false, "labelWidth": 0, "hideCheckBoxLabels": true, "items": [ main_1_panel2615, description2620, CoursesByOffer_grid2651 ], "frame": true, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel2652;
    this.before_row_edit = function(record) {
      description2620.refresh();
      CoursesByOffer_grid2651.on_master_changed();
    }
    Lino.courses.CourseOffers.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.contacts.Companies.InsertFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  autoHeight: true,
  content_type: 19,
  initComponent : function() {
    var containing_panel = this;
    var name793 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Name","(contacts.Companies.name) ") }, "fieldLabel": "Name", "name": "name", "maxLength": 200, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var language794 = new Lino.ChoicesFieldElement({ "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Sprache</span>", "allowBlank": false, "hiddenName": "languageHidden", "listeners": { "render": Lino.quicktip_renderer("Sprache","(contacts.Companies.language) Die Sprache, in der Dokumente ausgestellt werden sollen.") }, "selectOnFocus": true, "anchor": "-20", "store": [ [ "en", "Englisch" ], [ "fr", "Franz\u00f6sisch" ], [ "de", "Deutsch" ], [ "nl", "Niederl\u00e4ndisch" ] ], "name": "language" });
    var email795 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("E-Mail","(contacts.Companies.email) ") }, "fieldLabel": "E-Mail", "name": "email", "maxLength": 75, "selectOnFocus": true, "anchor": "-20" });
    var main_2_panel796 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": language794, "labelAlign": "top" }, { "flex": 66, "autoHeight": true, "layout": "form", "xtype": "panel", "items": email795, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 72, "border": false, "anchor": "-20", "labelAlign": "top" });
    var type799 = new Lino.RemoteComboFieldElement({ "fieldLabel": "Organisationsart", "name": "type", "pageSize": 20, "emptyText": "Organisationsart ausw\u00e4hlen...", "listeners": { "render": Lino.quicktip_renderer("Organisationsart","(contacts.Companies.type) ") }, "selectOnFocus": true, "hiddenName": "typeHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/contacts/Companies/type", "method": "GET" }) }) });
    var id800 = new Ext.form.NumberField({ "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("ID","(contacts.Companies.id) ") }, "fieldLabel": "ID", "anchor": "-20", "name": "id" });
    var main_3_panel801 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 80, "autoHeight": true, "layout": "form", "xtype": "panel", "items": type799, "labelAlign": "top" }, { "flex": 20, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id800, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 153, "border": false, "anchor": "-20", "labelAlign": "top" });
    var main_panel804 = new Ext.Panel({ "hideCheckBoxLabels": true, "autoHeight": true, "border": false, "layout": "form", "labelWidth": 45, "autoScroll": false, "items": [ { "autoHeight": true, "layout": "form", "xtype": "panel", "items": name793, "anchor": "-20", "labelAlign": "top" }, main_2_panel796, main_3_panel801 ], "frame": true, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel804;
    this.before_row_edit = function(record) {
    }
    Lino.contacts.Companies.InsertFormPanel.superclass.initComponent.call(this);
  }
});


Lino.jobs.Contracts.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 70,
  initComponent : function() {
    var containing_panel = this;
    var id1471 = new Ext.form.NumberField({ "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("ID","(jobs.Contracts.id) ") }, "fieldLabel": "ID", "anchor": "-20", "name": "id" });
    var client1472 = new Lino.TwinCombo({ "preferred_width": 20, "fieldLabel": "Klient", "allowBlank": false, "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.pcsw.Clients.detail)}, "emptyText": "Klient ausw\u00e4hlen...", "listeners": { "render": Lino.quicktip_renderer("Klient","(jobs.Contracts.client) ") }, "selectOnFocus": true, "hiddenName": "clientHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/jobs/Contracts/client", "method": "GET" }) }), "name": "client" });
    var user1473 = new Lino.TwinCombo({ "preferred_width": 15, "fieldLabel": "Autor", "name": "user", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.users.Users.detail)}, "hiddenName": "userHidden", "listeners": { "render": Lino.quicktip_renderer("Autor","(jobs.Contracts.user) ") }, "selectOnFocus": true, "emptyText": "Benutzer ausw\u00e4hlen...", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/jobs/Contracts/user", "method": "GET" }) }) });
    var user_asd1474 = new Lino.TwinCombo({ "preferred_width": 15, "fieldLabel": "Verantwortlicher (ASD)", "name": "user_asd", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.users.Users.detail)}, "hiddenName": "user_asdHidden", "listeners": { "render": Lino.quicktip_renderer("Verantwortlicher (ASD)","(jobs.Contracts.user_asd) ") }, "selectOnFocus": true, "emptyText": "Benutzer ausw\u00e4hlen...", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/jobs/Contracts/user_asd", "method": "GET" }) }) });
    var language1475 = new Lino.ChoicesFieldElement({ "fieldLabel": "Sprache", "allowBlank": false, "hiddenName": "languageHidden", "listeners": { "render": Lino.quicktip_renderer("Sprache","(jobs.Contracts.language) ") }, "selectOnFocus": true, "anchor": "-20", "store": [ [ "en", "Englisch" ], [ "fr", "Franz\u00f6sisch" ], [ "de", "Deutsch" ], [ "nl", "Niederl\u00e4ndisch" ] ], "name": "language" });
    var box1_1_panel1476 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 207, "hideCheckBoxLabels": true, "items": [ { "flex": 11, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id1471, "labelAlign": "top" }, { "flex": 35, "autoHeight": true, "layout": "form", "xtype": "panel", "items": client1472, "labelAlign": "top" }, { "flex": 21, "autoHeight": true, "layout": "form", "xtype": "panel", "items": user1473, "labelAlign": "top" }, { "flex": 21, "autoHeight": true, "layout": "form", "xtype": "panel", "items": user_asd1474, "labelAlign": "top" }, { "flex": 11, "autoHeight": true, "layout": "form", "xtype": "panel", "items": language1475, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var job1482 = new Lino.TwinCombo({ "preferred_width": 20, "fieldLabel": "Stelle", "allowBlank": false, "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.jobs.Jobs.detail)}, "emptyText": "Stelle ausw\u00e4hlen...", "listeners": { "render": Lino.quicktip_renderer("Stelle","(jobs.Contracts.job) ") }, "selectOnFocus": true, "hiddenName": "jobHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/jobs/Contracts/job", "method": "GET" }) }), "name": "job" });
    var type1483 = new Lino.TwinCombo({ "preferred_width": 20, "fieldLabel": "Vertragsart", "name": "type", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.jobs.ContractTypes.detail)}, "hiddenName": "typeHidden", "listeners": { "render": Lino.quicktip_renderer("Vertragsart","(jobs.Contracts.type) ") }, "selectOnFocus": true, "emptyText": "Art.60\u00a77-Konventionsart ausw\u00e4hlen...", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/jobs/Contracts/type", "method": "GET" }) }) });
    var company1484 = new Lino.TwinCombo({ "preferred_width": 20, "fieldLabel": "Organisation", "name": "company", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.contacts.Companies.detail)}, "hiddenName": "companyHidden", "listeners": { "render": Lino.quicktip_renderer("Organisation","(jobs.Contracts.company) ") }, "selectOnFocus": true, "emptyText": "Organisation ausw\u00e4hlen...", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/jobs/Contracts/company", "method": "GET" }) }) });
    var contact_person1485 = new Lino.TwinCombo({ "preferred_width": 20, "fieldLabel": "Vertreten durch", "name": "contact_person", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.contacts.Persons.detail)}, "hiddenName": "contact_personHidden", "listeners": { "render": Lino.quicktip_renderer("Vertreten durch","(jobs.Contracts.contact_person) ") }, "selectOnFocus": true, "emptyText": "Person ausw\u00e4hlen...", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/jobs/Contracts/contact_person", "method": "GET" }) }) });
    var contact_role1486 = new Lino.RemoteComboFieldElement({ "fieldLabel": "in seiner Eigenschaft als", "name": "contact_role", "pageSize": 20, "emptyText": "Funktion ausw\u00e4hlen...", "listeners": { "render": Lino.quicktip_renderer("in seiner Eigenschaft als","(jobs.Contracts.contact_role) ") }, "selectOnFocus": true, "hiddenName": "contact_roleHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/jobs/Contracts/contact_role", "method": "GET" }) }) });
    var box1_2_panel1487 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 234, "hideCheckBoxLabels": true, "items": [ { "flex": 20, "autoHeight": true, "layout": "form", "xtype": "panel", "items": job1482, "labelAlign": "top" }, { "flex": 20, "autoHeight": true, "layout": "form", "xtype": "panel", "items": type1483, "labelAlign": "top" }, { "flex": 20, "autoHeight": true, "layout": "form", "xtype": "panel", "items": company1484, "labelAlign": "top" }, { "flex": 20, "autoHeight": true, "layout": "form", "xtype": "panel", "items": contact_person1485, "labelAlign": "top" }, { "flex": 20, "autoHeight": true, "layout": "form", "xtype": "panel", "items": contact_role1486, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var applies_from1493 = new Lino.DateField({ "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Laufzeit von","(jobs.Contracts.applies_from) ") }, "fieldLabel": "Laufzeit von", "anchor": "-20", "name": "applies_from" });
    var duration1494 = new Lino.SimpleRemoteComboFieldElement({ "listeners": { "render": Lino.quicktip_renderer("Dauer (Arbeitstage)","(jobs.Contracts.duration) ") }, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/jobs/Contracts/duration", "method": "GET" }) }), "fieldLabel": "Dauer (Arbeitstage)", "name": "duration", "selectOnFocus": true, "anchor": "-20", "value": null });
    var applies_until1495 = new Lino.DateField({ "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Laufzeit bis","(jobs.Contracts.applies_until) ") }, "fieldLabel": "Laufzeit bis", "anchor": "-20", "name": "applies_until" });
    var exam_policy1496 = new Lino.TwinCombo({ "fieldLabel": "Auswertungsstrategie", "name": "exam_policy", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.isip.ExamPolicies.detail)}, "emptyText": "Auswertungsstrategie ausw\u00e4hlen...", "listeners": { "render": Lino.quicktip_renderer("Auswertungsstrategie","(jobs.Contracts.exam_policy) ") }, "selectOnFocus": true, "hiddenName": "exam_policyHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/jobs/Contracts/exam_policy", "method": "GET" }) }) });
    var box1_3_panel1497 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 189, "hideCheckBoxLabels": true, "items": [ { "flex": 17, "autoHeight": true, "layout": "form", "xtype": "panel", "items": applies_from1493, "labelAlign": "top" }, { "flex": 21, "autoHeight": true, "layout": "form", "xtype": "panel", "items": duration1494, "labelAlign": "top" }, { "flex": 17, "autoHeight": true, "layout": "form", "xtype": "panel", "items": applies_until1495, "labelAlign": "top" }, { "flex": 43, "autoHeight": true, "layout": "form", "xtype": "panel", "items": exam_policy1496, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var regime1502 = new Lino.TwinCombo({ "fieldLabel": "Regime", "name": "regime", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.jobs.Regimes.detail)}, "emptyText": "Regime ausw\u00e4hlen...", "listeners": { "render": Lino.quicktip_renderer("Regime","(jobs.Contracts.regime) ") }, "selectOnFocus": true, "hiddenName": "regimeHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/jobs/Contracts/regime", "method": "GET" }) }) });
    var schedule1503 = new Lino.TwinCombo({ "fieldLabel": "Stundenplan", "name": "schedule", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.jobs.Schedules.detail)}, "emptyText": "Stundenplan ausw\u00e4hlen...", "listeners": { "render": Lino.quicktip_renderer("Stundenplan","(jobs.Contracts.schedule) ") }, "selectOnFocus": true, "hiddenName": "scheduleHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/jobs/Contracts/schedule", "method": "GET" }) }) });
    var hourly_rate1504 = new Ext.form.NumberField({ "decimalPrecision": 2, "fieldLabel": "Stundensatz", "name": "hourly_rate", "decimalSeparator": ",", "listeners": { "render": Lino.quicktip_renderer("Stundensatz","(jobs.Contracts.hourly_rate) ") }, "selectOnFocus": true, "anchor": "-20", "allowBlank": true });
    var refund_rate1505 = new Lino.SimpleRemoteComboFieldElement({ "listeners": { "render": Lino.quicktip_renderer("R\u00fcckzahlung","(jobs.Contracts.refund_rate) ") }, "fieldLabel": "R\u00fcckzahlung", "name": "refund_rate", "selectOnFocus": true, "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/jobs/Contracts/refund_rate", "method": "GET" }) }) });
    var box1_4_panel1506 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 108, "hideCheckBoxLabels": true, "items": [ { "flex": 28, "autoHeight": true, "layout": "form", "xtype": "panel", "items": regime1502, "labelAlign": "top" }, { "flex": 42, "autoHeight": true, "layout": "form", "xtype": "panel", "items": schedule1503, "labelAlign": "top" }, { "flex": 14, "autoHeight": true, "layout": "form", "xtype": "panel", "items": hourly_rate1504, "labelAlign": "top" }, { "flex": 14, "autoHeight": true, "layout": "form", "xtype": "panel", "items": refund_rate1505, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var reference_person1511 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Referenzperson","(jobs.Contracts.reference_person) ") }, "fieldLabel": "Referenzperson", "name": "reference_person", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var build_time1512 = new Ext.form.DisplayField({ "disabled": true, "listeners": { "render": Lino.quicktip_renderer("Druckdatum","(jobs.Contracts.build_time) ") }, "fieldLabel": "Druckdatum", "name": "build_time", "anchor": "-20", "value": "<br>" });
    var box1_5_panel1513 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 135, "hideCheckBoxLabels": true, "items": [ { "flex": 56, "autoHeight": true, "layout": "form", "xtype": "panel", "items": reference_person1511, "labelAlign": "top" }, { "flex": 43, "autoHeight": true, "layout": "form", "xtype": "panel", "items": build_time1512, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var date_decided1516 = new Lino.DateField({ "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Beschlossen am","(jobs.Contracts.date_decided) ") }, "fieldLabel": "Beschlossen am", "anchor": "-20", "name": "date_decided" });
    var date_issued1517 = new Lino.DateField({ "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Ausgestellt am","(jobs.Contracts.date_issued) ") }, "fieldLabel": "Ausgestellt am", "anchor": "-20", "name": "date_issued" });
    var date_ended1518 = new Lino.DateField({ "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Enddatum","(jobs.Contracts.date_ended) ") }, "fieldLabel": "Enddatum", "anchor": "-20", "name": "date_ended" });
    var ending1519 = new Lino.TwinCombo({ "fieldLabel": "Beendigungsgrund", "name": "ending", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.isip.ContractEndings.detail)}, "emptyText": "Beendigungsgrund ausw\u00e4hlen...", "listeners": { "render": Lino.quicktip_renderer("Beendigungsgrund","(jobs.Contracts.ending) ") }, "selectOnFocus": true, "hiddenName": "endingHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/jobs/Contracts/ending", "method": "GET" }) }) });
    var box1_6_panel1520 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 153, "hideCheckBoxLabels": true, "items": [ { "flex": 18, "autoHeight": true, "layout": "form", "xtype": "panel", "items": date_decided1516, "labelAlign": "top" }, { "flex": 18, "autoHeight": true, "layout": "form", "xtype": "panel", "items": date_issued1517, "labelAlign": "top" }, { "flex": 18, "autoHeight": true, "layout": "form", "xtype": "panel", "items": date_ended1518, "labelAlign": "top" }, { "flex": 45, "autoHeight": true, "layout": "form", "xtype": "panel", "items": ending1519, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var responsibilities1525 = new Lino.RichTextPanel({ "selectOnFocus": true, "flex": 45, "containing_panel": this, "name": "responsibilities", "title": "Aufgabenbereich" });
    var box1_panel1526 = new Ext.Panel({ "flex": 70, "layout": "vbox", "items": [ box1_1_panel1476, box1_2_panel1487, box1_3_panel1497, box1_4_panel1506, box1_5_panel1513, box1_6_panel1520, responsibilities1525 ], "frame": true, "layoutConfig": { "align": "stretch" }, "autoScroll": false, "hideCheckBoxLabels": true, "labelWidth": 0, "border": false, "bodyBorder": false, "labelAlign": "top" });
    var cal_EventsByController_grid1527 = new Lino.cal.EventsByController.GridPanel({ "flex": 5, "hide_top_toolbar": true, "containing_panel": this, "region": "north", "params_panel_hidden": true, "master_panel": this, "preview_limit": 15, "listeners": { "render": Lino.quicktip_renderer("Termine","(cal.cal.EventsByController) ") }, "split": true, "tools": [ Lino.show_in_own_window_button(Lino.cal.EventsByController.grid) ] });
    var cal_TasksByController_grid1528 = new Lino.cal.TasksByController.GridPanel({ "flex": 5, "hide_top_toolbar": true, "containing_panel": this, "region": "center", "params_panel_hidden": true, "master_panel": this, "preview_limit": 15, "listeners": { "render": Lino.quicktip_renderer("Aufgaben","(cal.cal.TasksByController) ") }, "split": true, "tools": [ Lino.show_in_own_window_button(Lino.cal.TasksByController.grid) ] });
    var right_panel1529 = new Lino.VBorderPanel({ "flex": 30, "border": false, "hideCheckBoxLabels": true, "items": [ cal_EventsByController_grid1527, cal_TasksByController_grid1528 ], "frame": true, "autoScroll": false, "bodyBorder": false, "labelAlign": "top" });
    var main_1_panel1530 = new Ext.Panel({ "autoScroll": false, "border": false, "layout": "hbox", "hideCheckBoxLabels": true, "items": [ box1_panel1526, right_panel1529 ], "frame": false, "layoutConfig": { "align": "stretch" }, "labelAlign": "top" });
    var main_panel1531 = new Ext.Panel({ "autoScroll": false, "border": false, "layout": "fit", "hideCheckBoxLabels": true, "items": [ main_1_panel1530 ], "frame": true, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel1531;
    this.before_row_edit = function(record) {
      contact_person1485.setContextValue('company',record ? record.data['companyHidden'] : undefined);
      responsibilities1525.refresh();
      cal_EventsByController_grid1527.on_master_changed();
      cal_TasksByController_grid1528.on_master_changed();
    }
    this.onRender = function(ct, position) {
      company1484.on('change',Lino.chooser_handler(contact_person1485,'company'));
      Lino.jobs.Contracts.DetailFormPanel.superclass.onRender.call(this, ct, position);
    }
    Lino.jobs.Contracts.DetailFormPanel.superclass.initComponent.call(this);
    // active_fields:
    job1482.on("change",function(){this.save()},this);
    company1484.on("change",function(){this.save()},this);
    contact_person1485.on("change",function(){this.save()},this);
    contact_role1486.on("change",function(){this.save()},this);
  }
});


Lino.cal.Events.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 35,
  initComponent : function() {
    var containing_panel = this;
    var calendar1010 = new Lino.TwinCombo({ "fieldLabel": "Kalender", "name": "calendar", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.cal.Calendars.detail)}, "emptyText": "Kalender ausw\u00e4hlen...", "listeners": { "render": Lino.quicktip_renderer("Kalender","(cal.Events.calendar) ") }, "selectOnFocus": true, "hiddenName": "calendarHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/Events/calendar", "method": "GET" }) }) });
    var summary1011 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Kurzbeschreibung","(cal.Events.summary) ") }, "fieldLabel": "Kurzbeschreibung", "name": "summary", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var project1012 = new Lino.TwinCombo({ "preferred_width": 20, "fieldLabel": "Klient", "name": "project", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.pcsw.Clients.detail)}, "hiddenName": "projectHidden", "listeners": { "render": Lino.quicktip_renderer("Klient","(cal.Events.project) ") }, "selectOnFocus": true, "emptyText": "Klient ausw\u00e4hlen...", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/Events/project", "method": "GET" }) }) });
    var general_1_panel1013 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 153, "hideCheckBoxLabels": true, "items": [ { "flex": 32, "autoHeight": true, "layout": "form", "xtype": "panel", "items": calendar1010, "labelAlign": "top" }, { "flex": 34, "autoHeight": true, "layout": "form", "xtype": "panel", "items": summary1011, "labelAlign": "top" }, { "flex": 32, "autoHeight": true, "layout": "form", "xtype": "panel", "items": project1012, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var start_date1017 = new Lino.DateField({ "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Beginnt am","(cal.Events.start_date) ") }, "fieldLabel": "Beginnt am", "anchor": "-20", "name": "start_date" });
    var start_time1018 = new Lino.TimeField({ "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Beginnt um","(cal.Events.start_time) ") }, "fieldLabel": "Beginnt um", "anchor": "-20", "name": "start_time" });
    var start_panel1019 = new Ext.Panel({ "flex": 22, "autoHeight": true, "layout": "hbox", "items": [ { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": start_date1017, "labelAlign": "top" }, { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": start_time1018, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "autoScroll": false, "hideCheckBoxLabels": true, "labelWidth": 99, "border": false, "labelAlign": "top" });
    var end_date1022 = new Lino.DateField({ "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Endet am","(cal.Events.end_date) ") }, "fieldLabel": "Endet am", "anchor": "-20", "name": "end_date" });
    var end_time1023 = new Lino.TimeField({ "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Endet um","(cal.Events.end_time) ") }, "fieldLabel": "Endet um", "anchor": "-20", "name": "end_time" });
    var end_panel1024 = new Ext.Panel({ "flex": 22, "autoHeight": true, "layout": "hbox", "items": [ { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": end_date1022, "labelAlign": "top" }, { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": end_time1023, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "autoScroll": false, "hideCheckBoxLabels": true, "labelWidth": 81, "border": false, "labelAlign": "top" });
    var user1027 = new Lino.TwinCombo({ "preferred_width": 15, "fieldLabel": "Verantwortlicher", "name": "user", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.users.Users.detail)}, "hiddenName": "userHidden", "listeners": { "render": Lino.quicktip_renderer("Verantwortlicher","(cal.Events.user) ") }, "selectOnFocus": true, "emptyText": "Benutzer ausw\u00e4hlen...", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/Events/user", "method": "GET" }) }) });
    var assigned_to1028 = new Lino.TwinCombo({ "preferred_width": 15, "fieldLabel": "Zugewiesen zu", "name": "assigned_to", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.users.Users.detail)}, "hiddenName": "assigned_toHidden", "listeners": { "render": Lino.quicktip_renderer("Zugewiesen zu","(cal.Events.assigned_to) ") }, "selectOnFocus": true, "emptyText": "Benutzer ausw\u00e4hlen...", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/Events/assigned_to", "method": "GET" }) }) });
    var general_2_panel1029 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 153, "hideCheckBoxLabels": true, "items": [ start_panel1019, end_panel1024, { "flex": 27, "autoHeight": true, "layout": "form", "xtype": "panel", "items": user1027, "labelAlign": "top" }, { "flex": 27, "autoHeight": true, "layout": "form", "xtype": "panel", "items": assigned_to1028, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var room1032 = new Lino.TwinCombo({ "fieldLabel": "Raum", "name": "room", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.cal.Rooms.detail)}, "emptyText": "Raum ausw\u00e4hlen...", "listeners": { "render": Lino.quicktip_renderer("Raum","(cal.Events.room) ") }, "selectOnFocus": true, "hiddenName": "roomHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/Events/room", "method": "GET" }) }) });
    var priority1033 = new Lino.RemoteComboFieldElement({ "fieldLabel": "Priorit\u00e4t", "name": "priority", "pageSize": 20, "emptyText": "Priorit\u00e4t ausw\u00e4hlen...", "listeners": { "render": Lino.quicktip_renderer("Priorit\u00e4t","(cal.Events.priority) ") }, "selectOnFocus": true, "hiddenName": "priorityHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/Events/priority", "method": "GET" }) }) });
    var access_class1034 = new Lino.ChoicesFieldElement({ "forceSelection": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Zugriffsklasse</span>", "name": "access_class", "hiddenName": "access_classHidden", "listeners": { "render": Lino.quicktip_renderer("Zugriffsklasse","(cal.Events.access_class) Ob dieser Termin  privat, \u00f6ffentlich oder halb \u00f6ffentlich ist") }, "selectOnFocus": true, "anchor": "-20", "store": [['','<br>']].concat(Lino.cal.AccessClasses) });
    var transparent1035 = new Ext.form.Checkbox({ "boxLabel": "nicht blockierend", "listeners": { "render": Lino.quicktip_renderer("nicht blockierend","(cal.Events.transparent) Dieser Termin l\u00e4sst auch andere Termine zur gleichen Zeit zu.") }, "hideLabel": true, "checked": false, "name": "transparent", "selectOnFocus": true, "anchor": "-20" });
    var general_3_panel1036 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 162, "hideCheckBoxLabels": true, "items": [ { "flex": 32, "autoHeight": true, "layout": "form", "xtype": "panel", "items": room1032, "labelAlign": "top" }, { "flex": 32, "autoHeight": true, "layout": "form", "xtype": "panel", "items": priority1033, "labelAlign": "top" }, { "flex": 19, "autoHeight": true, "layout": "form", "xtype": "panel", "items": access_class1034, "labelAlign": "top" }, { "flex": 16, "autoHeight": true, "layout": "form", "xtype": "panel", "items": transparent1035, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var owner_disp1041 = new Ext.form.DisplayField({ "disabled": true, "fieldLabel": "Verkn\u00fcpft mit", "anchor": "-20", "name": "owner" });
    var workflow_buttons_disp1042 = new Ext.form.DisplayField({ "disabled": true, "listeners": { "render": Lino.quicktip_renderer("Arbeitsablauf","(cal.Events.workflow_buttons) ") }, "fieldLabel": "Arbeitsablauf", "name": "workflow_buttons", "anchor": "-20", "value": "<br/>", "always_enabled": true });
    var general_4_panel1043 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 126, "hideCheckBoxLabels": true, "items": [ { "flex": 25, "autoHeight": true, "layout": "form", "xtype": "panel", "items": owner_disp1041, "labelAlign": "top" }, { "flex": 75, "autoHeight": true, "layout": "form", "xtype": "panel", "items": workflow_buttons_disp1042, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var description1046 = new Lino.RichTextPanel({ "selectOnFocus": true, "flex": 46, "containing_panel": this, "name": "description", "title": "Beschreibung" });
    var GuestsByEvent_grid1091 = new Lino.cal.GuestsByEvent.GridPanel({ "flex": 53, "listeners": { "render": Lino.quicktip_renderer("G\u00e4ste","(cal.cal.GuestsByEvent) ") }, "hide_top_toolbar": true, "containing_panel": this, "tools": [ Lino.show_in_own_window_button(Lino.cal.GuestsByEvent.grid) ], "preview_limit": 15, "master_panel": this });
    var general_5_panel1092 = new Ext.Panel({ "flex": 45, "border": false, "layout": "hbox", "labelWidth": 0, "hideCheckBoxLabels": true, "items": [ description1046, GuestsByEvent_grid1091 ], "autoScroll": false, "layoutConfig": { "align": "stretch" }, "frame": false, "labelAlign": "top" });
    var general_panel1093 = new Ext.Panel({ "layout": "vbox", "title": "Allgemein", "items": [ general_1_panel1013, general_2_panel1029, general_3_panel1036, general_4_panel1043, general_5_panel1092 ], "frame": true, "layoutConfig": { "align": "stretch" }, "hideCheckBoxLabels": true, "listeners": { "activate": Lino.on_tab_activate }, "autoScroll": false, "border": false, "bodyBorder": false, "labelAlign": "top" });
    var id1094 = new Ext.form.NumberField({ "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("ID","(cal.Events.id) ") }, "fieldLabel": "ID", "anchor": "-20", "name": "id" });
    var created1095 = new Ext.form.DisplayField({ "disabled": true, "listeners": { "render": Lino.quicktip_renderer("Erstellt","(cal.Events.created) ") }, "fieldLabel": "Erstellt", "name": "created", "anchor": "-20", "value": "<br>" });
    var modified1096 = new Ext.form.DisplayField({ "disabled": true, "listeners": { "render": Lino.quicktip_renderer("Bearbeitet","(cal.Events.modified) ") }, "fieldLabel": "Bearbeitet", "name": "modified", "anchor": "-20", "value": "<br>" });
    var state1097 = new Lino.ChoicesFieldElement({ "forceSelection": true, "fieldLabel": "Zustand", "allowBlank": false, "hiddenName": "stateHidden", "listeners": { "render": Lino.quicktip_renderer("Zustand","(cal.Events.state) ") }, "selectOnFocus": true, "anchor": "-20", "store": Lino.cal.EventStates, "name": "state" });
    var more_1_panel1098 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 99, "hideCheckBoxLabels": true, "items": [ { "flex": 8, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id1094, "labelAlign": "top" }, { "flex": 34, "autoHeight": true, "layout": "form", "xtype": "panel", "items": created1095, "labelAlign": "top" }, { "flex": 34, "autoHeight": true, "layout": "form", "xtype": "panel", "items": modified1096, "labelAlign": "top" }, { "flex": 22, "autoHeight": true, "layout": "form", "xtype": "panel", "items": state1097, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var outbox_MailsByController_grid1103 = new Lino.outbox.MailsByController.GridPanel({ "flex": 83, "listeners": { "render": Lino.quicktip_renderer("E-Mail-Ausg\u00e4nge","(outbox.outbox.MailsByController) ") }, "hide_top_toolbar": true, "containing_panel": this, "tools": [ Lino.show_in_own_window_button(Lino.outbox.MailsByController.grid) ], "preview_limit": 15, "master_panel": this });
    var more_panel1104 = new Ext.Panel({ "layout": "vbox", "title": "Mehr", "items": [ more_1_panel1098, outbox_MailsByController_grid1103 ], "frame": true, "layoutConfig": { "align": "stretch" }, "hideCheckBoxLabels": true, "listeners": { "activate": Lino.on_tab_activate }, "autoScroll": false, "border": false, "bodyBorder": false, "labelAlign": "top" });
    var main_panel1105 = new Ext.TabPanel({ "hideCheckBoxLabels": true, "border": false, "split": true, "autoScroll": false, "items": [ general_panel1093, more_panel1104 ], "activeTab": 0, "bodyBorder": false, "frame": true, "labelAlign": "top" });
    this.items = main_panel1105;
    this.before_row_edit = function(record) {
      description1046.refresh();
      GuestsByEvent_grid1091.on_master_changed();
      outbox_MailsByController_grid1103.on_master_changed();
    }
    Lino.cal.Events.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.cal.Events.InsertFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  autoHeight: true,
  content_type: 35,
  initComponent : function() {
    var containing_panel = this;
    var summary1106 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Kurzbeschreibung","(cal.Events.summary) ") }, "fieldLabel": "Kurzbeschreibung", "name": "summary", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var start_date1107 = new Lino.DateField({ "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Beginnt am","(cal.Events.start_date) ") }, "fieldLabel": "Beginnt am", "anchor": "-20", "name": "start_date" });
    var start_time1108 = new Lino.TimeField({ "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Beginnt um","(cal.Events.start_time) ") }, "fieldLabel": "Beginnt um", "anchor": "-20", "name": "start_time" });
    var start_panel1109 = new Ext.Panel({ "flex": 50, "autoHeight": true, "layout": "hbox", "items": [ { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": start_date1107, "labelAlign": "top" }, { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": start_time1108, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "autoScroll": false, "hideCheckBoxLabels": true, "labelWidth": 99, "border": false, "labelAlign": "top" });
    var end_date1112 = new Lino.DateField({ "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Endet am","(cal.Events.end_date) ") }, "fieldLabel": "Endet am", "anchor": "-20", "name": "end_date" });
    var end_time1113 = new Lino.TimeField({ "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Endet um","(cal.Events.end_time) ") }, "fieldLabel": "Endet um", "anchor": "-20", "name": "end_time" });
    var end_panel1114 = new Ext.Panel({ "flex": 50, "autoHeight": true, "layout": "hbox", "items": [ { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": end_date1112, "labelAlign": "top" }, { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": end_time1113, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "autoScroll": false, "hideCheckBoxLabels": true, "labelWidth": 81, "border": false, "labelAlign": "top" });
    var main_2_panel1117 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "hideCheckBoxLabels": true, "items": [ start_panel1109, end_panel1114 ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "anchor": "-20", "labelAlign": "top" });
    var calendar1118 = new Lino.TwinCombo({ "fieldLabel": "Kalender", "name": "calendar", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.cal.Calendars.detail)}, "emptyText": "Kalender ausw\u00e4hlen...", "listeners": { "render": Lino.quicktip_renderer("Kalender","(cal.Events.calendar) ") }, "selectOnFocus": true, "hiddenName": "calendarHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/Events/calendar", "method": "GET" }) }) });
    var project1119 = new Lino.TwinCombo({ "preferred_width": 20, "fieldLabel": "Klient", "name": "project", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.pcsw.Clients.detail)}, "hiddenName": "projectHidden", "listeners": { "render": Lino.quicktip_renderer("Klient","(cal.Events.project) ") }, "selectOnFocus": true, "emptyText": "Klient ausw\u00e4hlen...", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/Events/project", "method": "GET" }) }) });
    var main_3_panel1120 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": calendar1118, "labelAlign": "top" }, { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": project1119, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 81, "border": false, "anchor": "-20", "labelAlign": "top" });
    var main_panel1123 = new Ext.Panel({ "hideCheckBoxLabels": true, "autoHeight": true, "border": false, "layout": "form", "labelWidth": 153, "autoScroll": false, "items": [ { "autoHeight": true, "layout": "form", "xtype": "panel", "items": summary1106, "anchor": "-20", "labelAlign": "top" }, main_2_panel1117, main_3_panel1120 ], "frame": true, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel1123;
    this.before_row_edit = function(record) {
    }
    Lino.cal.Events.InsertFormPanel.superclass.initComponent.call(this);
  }
});


Lino.lino.Report.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  disable_editing: true,
  initComponent : function() {
    var containing_panel = this;
    var body_htmlbox3032 = new Lino.HtmlBoxPanel({ "layout": "fit", "name": "body", "containing_panel": this, "master_panel": this, "items": new Ext.BoxComponent({autoScroll:true}), "bodyStyle": "overflow-x:hidden;", "value": "<br/>", "always_enabled": true, "listeners": { "render": Lino.quicktip_renderer(null,"(lino.Report.body) ") } });
    var main_panel3033 = new Ext.Panel({ "autoScroll": false, "border": false, "layout": "fit", "labelWidth": 0, "hideCheckBoxLabels": true, "items": [ body_htmlbox3032 ], "frame": true, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel3033;
    this.before_row_edit = function(record) {
      body_htmlbox3032.refresh();
    }
    Lino.lino.Report.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.pcsw.Clients.InsertFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  autoHeight: true,
  content_type: 52,
  initComponent : function() {
    var containing_panel = this;
    var first_name2461 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Vorname","(pcsw.Clients.first_name) ") }, "fieldLabel": "Vorname", "name": "first_name", "maxLength": 200, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var last_name2462 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Familienname","(pcsw.Clients.last_name) ") }, "fieldLabel": "Familienname", "name": "last_name", "maxLength": 200, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var main_1_panel2463 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": first_name2461, "labelAlign": "top" }, { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": last_name2462, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 117, "border": false, "anchor": "-20", "labelAlign": "top" });
    var national_id2466 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("NR-Nummer","(pcsw.Clients.national_id) ") }, "fieldLabel": "NR-Nummer", "name": "national_id", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var gender2467 = new Lino.ChoicesFieldElement({ "forceSelection": true, "fieldLabel": "Geschlecht", "name": "gender", "hiddenName": "genderHidden", "listeners": { "render": Lino.quicktip_renderer("Geschlecht","(pcsw.Clients.gender) ") }, "selectOnFocus": true, "anchor": "-20", "store": [['','<br>']].concat(Lino.lino.Genders) });
    var language2468 = new Lino.ChoicesFieldElement({ "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Sprache</span>", "allowBlank": false, "hiddenName": "languageHidden", "listeners": { "render": Lino.quicktip_renderer("Sprache","(pcsw.Clients.language) Die Sprache, in der Dokumente ausgestellt werden sollen.") }, "selectOnFocus": true, "anchor": "-20", "store": [ [ "en", "Englisch" ], [ "fr", "Franz\u00f6sisch" ], [ "de", "Deutsch" ], [ "nl", "Niederl\u00e4ndisch" ] ], "name": "language" });
    var main_3_panel2469 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 31, "autoHeight": true, "layout": "form", "xtype": "panel", "items": gender2467, "labelAlign": "top" }, { "flex": 68, "autoHeight": true, "layout": "form", "xtype": "panel", "items": language2468, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 99, "border": false, "anchor": "-20", "labelAlign": "top" });
    var main_panel2472 = new Ext.Panel({ "hideCheckBoxLabels": true, "autoHeight": true, "border": false, "layout": "form", "labelWidth": 90, "autoScroll": false, "items": [ main_1_panel2463, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": national_id2466, "anchor": "-20", "labelAlign": "top" }, main_3_panel2469 ], "frame": true, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel2472;
    this.before_row_edit = function(record) {
    }
    Lino.pcsw.Clients.InsertFormPanel.superclass.initComponent.call(this);
  }
});


Lino.pcsw.Clients.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 52,
  initComponent : function() {
    var containing_panel = this;
    var last_name2021 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Familienname","(pcsw.Clients.last_name) ") }, "fieldLabel": "Familienname", "name": "last_name", "maxLength": 200, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var first_name2022 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Vorname","(pcsw.Clients.first_name) ") }, "fieldLabel": "Vorname", "name": "first_name", "maxLength": 200, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var title2023 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Anrede","(pcsw.Clients.title) ") }, "fieldLabel": "Anrede", "name": "title", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var box1_1_panel2024 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 45, "autoHeight": true, "layout": "form", "xtype": "panel", "items": last_name2021, "labelAlign": "top" }, { "flex": 32, "autoHeight": true, "layout": "form", "xtype": "panel", "items": first_name2022, "labelAlign": "top" }, { "flex": 21, "autoHeight": true, "layout": "form", "xtype": "panel", "items": title2023, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 117, "border": false, "anchor": "-20", "labelAlign": "top" });
    var country2028 = new Lino.TwinCombo({ "fieldLabel": "Land", "name": "country", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.countries.Countries.detail)}, "emptyText": "Land ausw\u00e4hlen...", "listeners": { "render": Lino.quicktip_renderer("Land","(pcsw.Clients.country) ") }, "selectOnFocus": true, "hiddenName": "countryHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/pcsw/Clients/country", "method": "GET" }) }) });
    var city2029 = new Lino.TwinCombo({ "forceSelection": false, "fieldLabel": "Ort", "name": "city", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.countries.Cities.detail)}, "emptyText": "Ort ausw\u00e4hlen...", "listeners": { "render": Lino.quicktip_renderer("Ort","(pcsw.Clients.city) ") }, "selectOnFocus": true, "hiddenName": "cityHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/pcsw/Clients/city", "method": "GET" }) }) });
    var zip_code2030 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Postleitzahl","(pcsw.Clients.zip_code) ") }, "fieldLabel": "Postleitzahl", "name": "zip_code", "maxLength": 10, "selectOnFocus": true, "boxMinWidth": Lino.chars2width(10), "anchor": "-20" });
    var box1_2_panel2031 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 40, "autoHeight": true, "layout": "form", "xtype": "panel", "items": country2028, "labelAlign": "top" }, { "flex": 40, "autoHeight": true, "layout": "form", "xtype": "panel", "items": city2029, "labelAlign": "top" }, { "flex": 20, "autoHeight": true, "layout": "form", "xtype": "panel", "items": zip_code2030, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 117, "border": false, "anchor": "-20", "labelAlign": "top" });
    var street_prefix2035 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Pr\u00e4fix Stra\u00dfe","(pcsw.Clients.street_prefix) Text to print before name of street, but to ignore for sorting.") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Pr\u00e4fix Stra\u00dfe</span>", "name": "street_prefix", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var street2036 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Stra\u00dfe","(pcsw.Clients.street) Name of street. Without house number.") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Stra\u00dfe</span>", "name": "street", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var street_no2037 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Nr.","(pcsw.Clients.street_no) House number") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Nr.</span>", "name": "street_no", "maxLength": 10, "selectOnFocus": true, "boxMinWidth": Lino.chars2width(10), "anchor": "-20" });
    var street_box2038 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Box","(pcsw.Clients.street_box) Text to print after :attr:`steet_no` on the same line") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Box</span>", "name": "street_box", "maxLength": 10, "selectOnFocus": true, "boxMinWidth": Lino.chars2width(10), "anchor": "-20" });
    var box1_3_panel2039 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 30, "autoHeight": true, "layout": "form", "xtype": "panel", "items": street_prefix2035, "labelAlign": "top" }, { "flex": 36, "autoHeight": true, "layout": "form", "xtype": "panel", "items": street2036, "labelAlign": "top" }, { "flex": 16, "autoHeight": true, "layout": "form", "xtype": "panel", "items": street_no2037, "labelAlign": "top" }, { "flex": 16, "autoHeight": true, "layout": "form", "xtype": "panel", "items": street_box2038, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 126, "border": false, "anchor": "-20", "labelAlign": "top" });
    var addr22044 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Adresszeile nach Stra\u00dfe","(pcsw.Clients.addr2) Address line to print below street line") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Adresszeile nach Stra\u00dfe</span>", "name": "addr2", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var box1_panel2045 = new Ext.form.FieldSet({ "flex": 61, "autoHeight": true, "layout": "form", "title": "Adresse", "items": [ box1_1_panel2024, box1_2_panel2031, box1_3_panel2039, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": addr22044, "anchor": "-20", "labelAlign": "top" } ], "frame": true, "bodyBorder": false, "autoScroll": false, "hideCheckBoxLabels": true, "labelWidth": 216, "border": false, "labelAlign": "top" });
    var id2047 = new Ext.form.NumberField({ "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("ID","(pcsw.Clients.id) ") }, "fieldLabel": "ID", "anchor": "-20", "name": "id" });
    var language2048 = new Lino.ChoicesFieldElement({ "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Sprache</span>", "allowBlank": false, "hiddenName": "languageHidden", "listeners": { "render": Lino.quicktip_renderer("Sprache","(pcsw.Clients.language) Die Sprache, in der Dokumente ausgestellt werden sollen.") }, "selectOnFocus": true, "anchor": "-20", "store": [ [ "en", "Englisch" ], [ "fr", "Franz\u00f6sisch" ], [ "de", "Deutsch" ], [ "nl", "Niederl\u00e4ndisch" ] ], "name": "language" });
    var box2_1_panel2049 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 37, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id2047, "labelAlign": "top" }, { "flex": 62, "autoHeight": true, "layout": "form", "xtype": "panel", "items": language2048, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 72, "border": false, "anchor": "-20", "labelAlign": "top" });
    var email2052 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("E-Mail","(pcsw.Clients.email) ") }, "fieldLabel": "E-Mail", "name": "email", "maxLength": 75, "selectOnFocus": true, "anchor": "-20" });
    var phone2053 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Telefon","(pcsw.Clients.phone) ") }, "fieldLabel": "Telefon", "name": "phone", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var fax2054 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Fax","(pcsw.Clients.fax) ") }, "fieldLabel": "Fax", "name": "fax", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var box2_3_panel2055 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": phone2053, "labelAlign": "top" }, { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": fax2054, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 72, "border": false, "anchor": "-20", "labelAlign": "top" });
    var gsm2058 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("GSM","(pcsw.Clients.gsm) ") }, "fieldLabel": "GSM", "name": "gsm", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var box2_panel2059 = new Ext.form.FieldSet({ "flex": 38, "autoHeight": true, "layout": "form", "title": "Kontakt", "items": [ box2_1_panel2049, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": email2052, "anchor": "-20", "labelAlign": "top" }, box2_3_panel2055, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": gsm2058, "anchor": "-20", "labelAlign": "top" } ], "frame": true, "bodyBorder": false, "autoScroll": false, "hideCheckBoxLabels": true, "labelWidth": 63, "border": false, "labelAlign": "top" });
    var general_1_panel2062 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "hideCheckBoxLabels": true, "items": [ box1_panel2045, box2_panel2059 ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "anchor": "-20", "labelAlign": "top" });
    var gender2063 = new Lino.ChoicesFieldElement({ "forceSelection": true, "fieldLabel": "Geschlecht", "name": "gender", "hiddenName": "genderHidden", "listeners": { "render": Lino.quicktip_renderer("Geschlecht","(pcsw.Clients.gender) ") }, "selectOnFocus": true, "anchor": "-20", "store": [['','<br>']].concat(Lino.lino.Genders) });
    var birth_date2064 = new Lino.IncompleteDateField({ "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Geburtsdatum","(pcsw.Clients.birth_date) Uncomplete dates are allowed, e.g. \n\"00.00.1980\" means \"some day in 1980\", \n\"00.07.1980\" means \"in July 1980\"\nor \"23.07.0000\" means \"on a 23th of July\".") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Geburtsdatum</span>", "anchor": "-20", "name": "birth_date" });
    var age_disp2065 = new Ext.form.DisplayField({ "disabled": true, "listeners": { "render": Lino.quicktip_renderer("Alter","(pcsw.Clients.age) ") }, "fieldLabel": "Alter", "name": "age", "anchor": "-20", "value": "<br/>", "always_enabled": true });
    var civil_state2066 = new Lino.ChoicesFieldElement({ "forceSelection": true, "fieldLabel": "Zivilstand", "name": "civil_state", "hiddenName": "civil_stateHidden", "listeners": { "render": Lino.quicktip_renderer("Zivilstand","(pcsw.Clients.civil_state) ") }, "selectOnFocus": true, "anchor": "-20", "store": [['','<br>']].concat(Lino.pcsw.CivilState) });
    var noble_condition2067 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Adelstitel","(pcsw.Clients.noble_condition) The eventual noble condition of this person. Imported from TIM.") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Adelstitel</span>", "name": "noble_condition", "maxLength": 50, "selectOnFocus": true, "anchor": "-20" });
    var box3_1_panel2068 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 14, "autoHeight": true, "layout": "form", "xtype": "panel", "items": gender2063, "labelAlign": "top" }, { "flex": 17, "autoHeight": true, "layout": "form", "xtype": "panel", "items": birth_date2064, "labelAlign": "top" }, { "flex": 14, "autoHeight": true, "layout": "form", "xtype": "panel", "items": age_disp2065, "labelAlign": "top" }, { "flex": 22, "autoHeight": true, "layout": "form", "xtype": "panel", "items": civil_state2066, "labelAlign": "top" }, { "flex": 30, "autoHeight": true, "layout": "form", "xtype": "panel", "items": noble_condition2067, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 117, "border": false, "anchor": "-20", "labelAlign": "top" });
    var birth_country2074 = new Lino.TwinCombo({ "fieldLabel": "Geburtsland", "name": "birth_country", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.countries.Countries.detail)}, "emptyText": "Land ausw\u00e4hlen...", "listeners": { "render": Lino.quicktip_renderer("Geburtsland","(pcsw.Clients.birth_country) ") }, "selectOnFocus": true, "hiddenName": "birth_countryHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/pcsw/Clients/birth_country", "method": "GET" }) }) });
    var birth_place2075 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Geburtsort","(pcsw.Clients.birth_place) ") }, "fieldLabel": "Geburtsort", "name": "birth_place", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var nationality2076 = new Lino.TwinCombo({ "fieldLabel": "Staatsangeh\u00f6rigkeit", "name": "nationality", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.countries.Countries.detail)}, "emptyText": "Land ausw\u00e4hlen...", "listeners": { "render": Lino.quicktip_renderer("Staatsangeh\u00f6rigkeit","(pcsw.Clients.nationality) ") }, "selectOnFocus": true, "hiddenName": "nationalityHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/pcsw/Clients/nationality", "method": "GET" }) }) });
    var national_id2077 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("NR-Nummer","(pcsw.Clients.national_id) ") }, "fieldLabel": "NR-Nummer", "name": "national_id", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var box3_2_panel2078 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 28, "autoHeight": true, "layout": "form", "xtype": "panel", "items": birth_country2074, "labelAlign": "top" }, { "flex": 29, "autoHeight": true, "layout": "form", "xtype": "panel", "items": birth_place2075, "labelAlign": "top" }, { "flex": 21, "autoHeight": true, "layout": "form", "xtype": "panel", "items": nationality2076, "labelAlign": "top" }, { "flex": 21, "autoHeight": true, "layout": "form", "xtype": "panel", "items": national_id2077, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 180, "border": false, "anchor": "-20", "labelAlign": "top" });
    var box3_panel2083 = new Ext.form.FieldSet({ "autoHeight": true, "layout": "form", "title": "Geburtsangaben", "items": [ box3_1_panel2068, box3_2_panel2078 ], "frame": true, "bodyBorder": false, "autoScroll": false, "hideCheckBoxLabels": true, "border": false, "anchor": "-20", "labelAlign": "top" });
    var eid_info_disp2084 = new Ext.form.DisplayField({ "disabled": true, "listeners": { "render": Lino.quicktip_renderer("eID-Karte","(pcsw.Clients.eid_info) ") }, "fieldLabel": "eID-Karte", "name": "eid_info", "anchor": "-20", "value": "<br/>", "always_enabled": true });
    var created2085 = new Ext.form.DisplayField({ "disabled": true, "listeners": { "render": Lino.quicktip_renderer("Erstellt","(pcsw.Clients.created) ") }, "fieldLabel": "Erstellt", "name": "created", "anchor": "-20", "value": "<br>" });
    var modified2086 = new Ext.form.DisplayField({ "disabled": true, "listeners": { "render": Lino.quicktip_renderer("Bearbeitet","(pcsw.Clients.modified) ") }, "fieldLabel": "Bearbeitet", "name": "modified", "anchor": "-20", "value": "<br>" });
    var box4_3_panel2087 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": created2085, "labelAlign": "top" }, { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": modified2086, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 99, "border": false, "anchor": "-20", "labelAlign": "top" });
    var box4_panel2090 = new Ext.Panel({ "flex": 82, "autoHeight": true, "layout": "form", "items": [ box3_panel2083, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": eid_info_disp2084, "anchor": "-20", "labelAlign": "top" }, box4_3_panel2087 ], "frame": true, "bodyBorder": false, "autoScroll": false, "hideCheckBoxLabels": true, "labelWidth": 90, "border": false, "labelAlign": "top" });
    var image_htmlbox2092 = new Lino.HtmlBoxPanel({ "flex": 17, "layout": "fit", "name": "image", "containing_panel": this, "master_panel": this, "items": new Ext.BoxComponent({autoScroll:true}), "bodyStyle": "overflow-x:hidden;", "value": "<br/>", "always_enabled": true, "listeners": { "render": Lino.quicktip_renderer(null,"(pcsw.Clients.image) ") } });
    var general_2_panel2093 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ box4_panel2090, image_htmlbox2092 ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 0, "border": false, "anchor": "-20", "labelAlign": "top" });
    var general_panel2094 = new Ext.Panel({ "autoHeight": true, "layout": "form", "title": "Person", "items": [ general_1_panel2062, general_2_panel2093 ], "frame": true, "bodyBorder": false, "hideCheckBoxLabels": true, "listeners": { "activate": Lino.on_tab_activate }, "autoScroll": false, "border": false, "labelAlign": "top" });
    var in_belgium_since2095 = new Lino.DateField({ "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Lebt in Belgien seit","(pcsw.Clients.in_belgium_since) Since when this person in Belgium lives.\n<b>Important:</b> help_text can be formatted.") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Lebt in Belgien seit</span>", "anchor": "-20", "name": "in_belgium_since" });
    var residence_type2096 = new Lino.ChoicesFieldElement({ "forceSelection": true, "fieldLabel": "Register", "name": "residence_type", "hiddenName": "residence_typeHidden", "listeners": { "render": Lino.quicktip_renderer("Register","(pcsw.Clients.residence_type) ") }, "selectOnFocus": true, "anchor": "-20", "store": [['','<br>']].concat(Lino.pcsw.ResidenceType) });
    var gesdos_id2097 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Gesdos-Nr","(pcsw.Clients.gesdos_id) ") }, "fieldLabel": "Gesdos-Nr", "name": "gesdos_id", "maxLength": 40, "selectOnFocus": true, "anchor": "-20" });
    var status_1_panel2098 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 24, "autoHeight": true, "layout": "form", "xtype": "panel", "items": in_belgium_since2095, "labelAlign": "top" }, { "flex": 40, "autoHeight": true, "layout": "form", "xtype": "panel", "items": residence_type2096, "labelAlign": "top" }, { "flex": 34, "autoHeight": true, "layout": "form", "xtype": "panel", "items": gesdos_id2097, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 189, "border": false, "anchor": "-20", "labelAlign": "top" });
    var bank_account12102 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Bankkonto 1","(pcsw.Clients.bank_account1) ") }, "fieldLabel": "Bankkonto 1", "name": "bank_account1", "maxLength": 40, "selectOnFocus": true, "anchor": "-20" });
    var bank_account22103 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Bankkonto 2","(pcsw.Clients.bank_account2) ") }, "fieldLabel": "Bankkonto 2", "name": "bank_account2", "maxLength": 40, "selectOnFocus": true, "anchor": "-20" });
    var status_2_panel2104 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": bank_account12102, "labelAlign": "top" }, { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": bank_account22103, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 108, "border": false, "anchor": "-20", "labelAlign": "top" });
    var job_agents2107 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Interim-Agenturen","(pcsw.Clients.job_agents) ") }, "fieldLabel": "Interim-Agenturen", "name": "job_agents", "maxLength": 100, "selectOnFocus": true, "anchor": "-20" });
    var group2108 = new Lino.RemoteComboFieldElement({ "fieldLabel": "Integrationsphase", "name": "group", "pageSize": 20, "emptyText": "Integrationsphase ausw\u00e4hlen...", "listeners": { "render": Lino.quicktip_renderer("Integrationsphase","(pcsw.Clients.group) ") }, "selectOnFocus": true, "hiddenName": "groupHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/pcsw/Clients/group", "method": "GET" }) }) });
    var status_3_panel2109 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 56, "autoHeight": true, "layout": "form", "xtype": "panel", "items": job_agents2107, "labelAlign": "top" }, { "flex": 43, "autoHeight": true, "layout": "form", "xtype": "panel", "items": group2108, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 162, "border": false, "anchor": "-20", "labelAlign": "top" });
    var status_panel2112 = new Ext.Panel({ "flex": 68, "autoHeight": true, "border": false, "layout": "form", "hideCheckBoxLabels": true, "items": [ status_1_panel2098, status_2_panel2104, status_3_panel2109 ], "frame": true, "autoScroll": false, "bodyBorder": false, "labelAlign": "top" });
    var aid_type2113 = new Lino.RemoteComboFieldElement({ "fieldLabel": "Sozialhilfeart", "name": "aid_type", "pageSize": 20, "emptyText": "Sozialhilfeart ausw\u00e4hlen...", "listeners": { "render": Lino.quicktip_renderer("Sozialhilfeart","(pcsw.Clients.aid_type) ") }, "selectOnFocus": true, "hiddenName": "aid_typeHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/pcsw/Clients/aid_type", "method": "GET" }) }) });
    var income_ag2114 = new Ext.form.Checkbox({ "boxLabel": "Arbeitslosengeld", "listeners": { "render": Lino.quicktip_renderer("Arbeitslosengeld","(pcsw.Clients.income_ag) ") }, "hideLabel": true, "checked": false, "name": "income_ag", "selectOnFocus": true, "anchor": "-20" });
    var income_wg2115 = new Ext.form.Checkbox({ "boxLabel": "Wartegeld", "listeners": { "render": Lino.quicktip_renderer("Wartegeld","(pcsw.Clients.income_wg) ") }, "hideLabel": true, "checked": false, "name": "income_wg", "selectOnFocus": true, "anchor": "-20" });
    var income_2_panel2116 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": income_ag2114, "labelAlign": "top" }, { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": income_wg2115, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 153, "border": false, "anchor": "-20", "labelAlign": "top" });
    var income_kg2119 = new Ext.form.Checkbox({ "boxLabel": "Krankengeld", "listeners": { "render": Lino.quicktip_renderer("Krankengeld","(pcsw.Clients.income_kg) ") }, "hideLabel": true, "checked": false, "name": "income_kg", "selectOnFocus": true, "anchor": "-20" });
    var income_rente2120 = new Ext.form.Checkbox({ "boxLabel": "Rente", "listeners": { "render": Lino.quicktip_renderer("Rente","(pcsw.Clients.income_rente) ") }, "hideLabel": true, "checked": false, "name": "income_rente", "selectOnFocus": true, "anchor": "-20" });
    var income_3_panel2121 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": income_kg2119, "labelAlign": "top" }, { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": income_rente2120, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 108, "border": false, "anchor": "-20", "labelAlign": "top" });
    var income_misc2124 = new Ext.form.Checkbox({ "boxLabel": "andere Einkommen", "listeners": { "render": Lino.quicktip_renderer("andere Einkommen","(pcsw.Clients.income_misc) ") }, "hideLabel": true, "checked": false, "name": "income_misc", "selectOnFocus": true, "anchor": "-20" });
    var income_panel2125 = new Ext.Panel({ "flex": 31, "autoHeight": true, "layout": "form", "items": [ { "autoHeight": true, "layout": "form", "xtype": "panel", "items": aid_type2113, "anchor": "-20", "labelAlign": "top" }, income_2_panel2116, income_3_panel2121, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": income_misc2124, "anchor": "-20", "labelAlign": "top" } ], "frame": true, "bodyBorder": false, "autoScroll": false, "hideCheckBoxLabels": true, "labelWidth": 153, "border": false, "labelAlign": "top" });
    var status_tab_1_panel2128 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "hideCheckBoxLabels": true, "items": [ status_panel2112, income_panel2125 ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var pcsw_DispensesByClient_grid2134 = new Lino.pcsw.DispensesByClient.GridPanel({ "flex": 3, "hide_top_toolbar": true, "containing_panel": this, "region": "north", "preview_limit": 15, "master_panel": this, "listeners": { "render": Lino.quicktip_renderer("Dispenzen","(pcsw.pcsw.DispensesByClient) ") }, "split": true, "tools": [ Lino.show_in_own_window_button(Lino.pcsw.DispensesByClient.grid) ] });
    var pcsw_ExclusionsByClient_grid2140 = new Lino.pcsw.ExclusionsByClient.GridPanel({ "flex": 3, "hide_top_toolbar": true, "containing_panel": this, "region": "center", "preview_limit": 15, "master_panel": this, "listeners": { "render": Lino.quicktip_renderer("AG-Sperren","(pcsw.pcsw.ExclusionsByClient) ") }, "split": true, "tools": [ Lino.show_in_own_window_button(Lino.pcsw.ExclusionsByClient.grid) ] });
    var suche_panel2141 = new Lino.VBorderPanel({ "flex": 50, "border": false, "hideCheckBoxLabels": true, "items": [ pcsw_DispensesByClient_grid2134, pcsw_ExclusionsByClient_grid2140 ], "frame": true, "autoScroll": false, "bodyBorder": false, "labelAlign": "top" });
    var is_seeking2142 = new Ext.form.Checkbox({ "boxLabel": "Arbeit suchend", "listeners": { "render": Lino.quicktip_renderer("Arbeit suchend","(pcsw.Clients.is_seeking) ") }, "hideLabel": true, "checked": false, "name": "is_seeking", "selectOnFocus": true, "anchor": "-20" });
    var unemployed_since2143 = new Lino.DateField({ "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("eingetragen seit","(pcsw.Clients.unemployed_since) ") }, "fieldLabel": "eingetragen seit", "anchor": "-20", "name": "unemployed_since" });
    var work_permit_suspended_until2144 = new Lino.DateField({ "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Wartezeit bis","(pcsw.Clients.work_permit_suspended_until) ") }, "fieldLabel": "Wartezeit bis", "anchor": "-20", "name": "work_permit_suspended_until" });
    var papers_1_panel2145 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 153, "hideCheckBoxLabels": true, "items": [ { "flex": 38, "autoHeight": true, "layout": "form", "xtype": "panel", "items": is_seeking2142, "labelAlign": "top" }, { "flex": 30, "autoHeight": true, "layout": "form", "xtype": "panel", "items": unemployed_since2143, "labelAlign": "top" }, { "flex": 30, "autoHeight": true, "layout": "form", "xtype": "panel", "items": work_permit_suspended_until2144, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var needs_residence_permit2149 = new Ext.form.Checkbox({ "boxLabel": "Braucht Aufenthaltserlaubnis", "listeners": { "render": Lino.quicktip_renderer("Braucht Aufenthaltserlaubnis","(pcsw.Clients.needs_residence_permit) ") }, "hideLabel": true, "checked": false, "name": "needs_residence_permit", "selectOnFocus": true, "anchor": "-20" });
    var needs_work_permit2150 = new Ext.form.Checkbox({ "boxLabel": "Braucht Arb.Erl.", "listeners": { "render": Lino.quicktip_renderer("Braucht Arb.Erl.","(pcsw.Clients.needs_work_permit) ") }, "hideLabel": true, "checked": false, "name": "needs_work_permit", "selectOnFocus": true, "anchor": "-20" });
    var papers_2_panel2151 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 261, "hideCheckBoxLabels": true, "items": [ { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": needs_residence_permit2149, "labelAlign": "top" }, { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": needs_work_permit2150, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var residence_permit_disp2154 = new Ext.form.DisplayField({ "disabled": true, "listeners": { "render": Lino.quicktip_renderer("Aufenthaltserlaubnis","(pcsw.Clients.residence_permit) ") }, "fieldLabel": "Aufenthaltserlaubnis", "name": "residence_permit", "anchor": "-20", "value": "<br/>", "always_enabled": true });
    var work_permit_disp2155 = new Ext.form.DisplayField({ "disabled": true, "listeners": { "render": Lino.quicktip_renderer("Arbeitserlaubnis","(pcsw.Clients.work_permit) ") }, "fieldLabel": "Arbeitserlaubnis", "name": "work_permit", "anchor": "-20", "value": "<br/>", "always_enabled": true });
    var driving_licence_disp2156 = new Ext.form.DisplayField({ "disabled": true, "listeners": { "render": Lino.quicktip_renderer("F\u00fchrerschein","(pcsw.Clients.driving_licence) ") }, "fieldLabel": "F\u00fchrerschein", "name": "driving_licence", "anchor": "-20", "value": "<br/>", "always_enabled": true });
    var papers_3_panel2157 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 189, "hideCheckBoxLabels": true, "items": [ { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": residence_permit_disp2154, "labelAlign": "top" }, { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": work_permit_disp2155, "labelAlign": "top" }, { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": driving_licence_disp2156, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var UploadsByController_htmlbox2161 = new Lino.HtmlBoxPanel({ "flex": 37, "ls_bbar_actions": [ { "itemId": "insert", "menu_item_text": "Neu", "must_save": true, "tooltip": "Neuen Datensatz erstellen", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-new", "overflowText": "Neu", "auto_save": true } ], "name": "UploadsByController", "containing_panel": this, "items": new Ext.BoxComponent({autoScroll:true}), "title": "Uploads", "master_panel": this, "value": "<br/>", "always_enabled": true, "listeners": { "render": Lino.quicktip_renderer("Uploads","(pcsw.Clients.UploadsByController) ") }, "bodyStyle": "overflow-x:hidden;", "ls_insert_handler": Lino.uploads.UploadsByController.insert, "layout": "fit", "tools": [ Lino.show_in_own_window_button(Lino.uploads.UploadsByController.grid) ] });
    var papers_panel2162 = new Ext.Panel({ "flex": 50, "layout": "vbox", "items": [ papers_1_panel2145, papers_2_panel2151, papers_3_panel2157, UploadsByController_htmlbox2161 ], "frame": true, "layoutConfig": { "align": "stretch" }, "autoScroll": false, "hideCheckBoxLabels": true, "labelWidth": 72, "border": false, "bodyBorder": false, "labelAlign": "top" });
    var status_tab_2_panel2163 = new Ext.Panel({ "flex": 66, "border": false, "layout": "hbox", "hideCheckBoxLabels": true, "items": [ suche_panel2141, papers_panel2162 ], "autoScroll": false, "layoutConfig": { "align": "stretch" }, "frame": false, "labelAlign": "top" });
    var status_tab_panel2164 = new Ext.Panel({ "layout": "vbox", "title": "Status", "items": [ status_tab_1_panel2128, status_tab_2_panel2163 ], "frame": true, "layoutConfig": { "align": "stretch" }, "hideCheckBoxLabels": true, "listeners": { "activate": Lino.on_tab_activate }, "autoScroll": false, "border": false, "bodyBorder": false, "labelAlign": "top" });
    var workflow_buttons_disp2165 = new Ext.form.DisplayField({ "disabled": true, "listeners": { "render": Lino.quicktip_renderer("Arbeitsablauf","(pcsw.Clients.workflow_buttons) ") }, "fieldLabel": "Arbeitsablauf", "name": "workflow_buttons", "anchor": "-20", "value": "<br/>", "always_enabled": true });
    var broker2166 = new Lino.RemoteComboFieldElement({ "fieldLabel": "Vermittler", "name": "broker", "pageSize": 20, "emptyText": "Vermittler ausw\u00e4hlen...", "listeners": { "render": Lino.quicktip_renderer("Vermittler","(pcsw.Clients.broker) ") }, "selectOnFocus": true, "hiddenName": "brokerHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/pcsw/Clients/broker", "method": "GET" }) }) });
    var faculty2167 = new Lino.TwinCombo({ "fieldLabel": "Fachbereich", "name": "faculty", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.newcomers.Faculties.detail)}, "emptyText": "Fachbereich ausw\u00e4hlen...", "listeners": { "render": Lino.quicktip_renderer("Fachbereich","(pcsw.Clients.faculty) ") }, "selectOnFocus": true, "hiddenName": "facultyHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/pcsw/Clients/faculty", "method": "GET" }) }) });
    var newcomers_left_panel2168 = new Ext.Panel({ "flex": 33, "autoHeight": true, "layout": "form", "items": [ { "autoHeight": true, "layout": "form", "xtype": "panel", "items": workflow_buttons_disp2165, "anchor": "-20", "labelAlign": "top" }, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": broker2166, "anchor": "-20", "labelAlign": "top" }, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": faculty2167, "anchor": "-20", "labelAlign": "top" } ], "frame": true, "bodyBorder": false, "autoScroll": false, "hideCheckBoxLabels": true, "labelWidth": 126, "border": false, "labelAlign": "top" });
    var coaching_1_panel2187 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "hideCheckBoxLabels": true, "items": [ newcomers_left_panel2168 ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var pcsw_ContactsByClient_grid2195 = new Lino.pcsw.ContactsByClient.GridPanel({ "flex": 50, "listeners": { "render": Lino.quicktip_renderer("Kontakte","(pcsw.pcsw.ContactsByClient) ") }, "hide_top_toolbar": true, "containing_panel": this, "tools": [ Lino.show_in_own_window_button(Lino.pcsw.ContactsByClient.grid) ], "preview_limit": 15, "master_panel": this });
    var pcsw_CoachingsByClient_grid2204 = new Lino.pcsw.CoachingsByClient.GridPanel({ "flex": 50, "hide_top_toolbar": true, "containing_panel": this, "params_panel_hidden": true, "preview_limit": 15, "master_panel": this, "listeners": { "render": Lino.quicktip_renderer("Begleitungen","(pcsw.pcsw.CoachingsByClient) ") }, "tools": [ Lino.show_in_own_window_button(Lino.pcsw.CoachingsByClient.grid) ] });
    var coaching_2_panel2205 = new Ext.Panel({ "flex": 50, "border": false, "layout": "hbox", "hideCheckBoxLabels": true, "items": [ pcsw_ContactsByClient_grid2195, pcsw_CoachingsByClient_grid2204 ], "autoScroll": false, "layoutConfig": { "align": "stretch" }, "frame": false, "labelAlign": "top" });
    var coaching_panel2206 = new Ext.Panel({ "layout": "vbox", "title": "Begleitung", "items": [ coaching_1_panel2187, coaching_2_panel2205 ], "frame": true, "layoutConfig": { "align": "stretch" }, "hideCheckBoxLabels": true, "listeners": { "activate": Lino.on_tab_activate }, "autoScroll": false, "border": false, "bodyBorder": false, "labelAlign": "top" });
    var jobs_StudiesByPerson_grid2219 = new Lino.jobs.StudiesByPerson.GridPanel({ "flex": 5, "hide_top_toolbar": true, "containing_panel": this, "region": "north", "preview_limit": 15, "master_panel": this, "listeners": { "render": Lino.quicktip_renderer("Ausbildungen und Studien","(jobs.jobs.StudiesByPerson) List of studies for a given person.") }, "split": true, "tools": [ Lino.show_in_own_window_button(Lino.jobs.StudiesByPerson.grid) ] });
    var jobs_ExperiencesByPerson_grid2229 = new Lino.jobs.ExperiencesByPerson.GridPanel({ "flex": 5, "hide_top_toolbar": true, "containing_panel": this, "region": "center", "preview_limit": 15, "master_panel": this, "listeners": { "render": Lino.quicktip_renderer("Berufserfahrungen","(jobs.jobs.ExperiencesByPerson) ") }, "split": true, "tools": [ Lino.show_in_own_window_button(Lino.jobs.ExperiencesByPerson.grid) ] });
    var education_panel2230 = new Lino.VBorderPanel({ "autoScroll": false, "listeners": { "activate": Lino.on_tab_activate }, "border": false, "title": "Ausbildung", "hideCheckBoxLabels": true, "items": [ jobs_StudiesByPerson_grid2219, jobs_ExperiencesByPerson_grid2229 ], "frame": true, "bodyBorder": false, "labelAlign": "top" });
    var cv_LanguageKnowledgesByPerson_grid2237 = new Lino.cv.LanguageKnowledgesByPerson.GridPanel({ "flex": 5, "hide_top_toolbar": true, "containing_panel": this, "region": "north", "preview_limit": 15, "master_panel": this, "listeners": { "render": Lino.quicktip_renderer("Sprachkenntnisse","(cv.cv.LanguageKnowledgesByPerson) ") }, "split": true, "tools": [ Lino.show_in_own_window_button(Lino.cv.LanguageKnowledgesByPerson.grid) ] });
    var courses_CourseRequestsByPerson_grid2273 = new Lino.courses.CourseRequestsByPerson.GridPanel({ "flex": 5, "hide_top_toolbar": true, "containing_panel": this, "region": "center", "preview_limit": 15, "master_panel": this, "listeners": { "render": Lino.quicktip_renderer("Kursanfragen","(courses.courses.CourseRequestsByPerson) ") }, "split": true, "tools": [ Lino.show_in_own_window_button(Lino.courses.CourseRequestsByPerson.grid) ] });
    var languages_panel2274 = new Lino.VBorderPanel({ "autoScroll": false, "listeners": { "activate": Lino.on_tab_activate }, "border": false, "title": "Sprachen", "hideCheckBoxLabels": true, "items": [ cv_LanguageKnowledgesByPerson_grid2237, courses_CourseRequestsByPerson_grid2273 ], "frame": true, "bodyBorder": false, "labelAlign": "top" });
    var cv_SkillsByPerson_grid2281 = new Lino.cv.SkillsByPerson.GridPanel({ "flex": 35, "listeners": { "render": Lino.quicktip_renderer("Fachkompetenzen","(cv.cv.SkillsByPerson) ") }, "hide_top_toolbar": true, "containing_panel": this, "tools": [ Lino.show_in_own_window_button(Lino.cv.SkillsByPerson.grid) ], "preview_limit": 15, "master_panel": this });
    var cv_SoftSkillsByPerson_grid2288 = new Lino.cv.SoftSkillsByPerson.GridPanel({ "flex": 35, "listeners": { "render": Lino.quicktip_renderer("Sozialkompetenzen","(cv.cv.SoftSkillsByPerson) ") }, "hide_top_toolbar": true, "containing_panel": this, "tools": [ Lino.show_in_own_window_button(Lino.cv.SoftSkillsByPerson.grid) ], "preview_limit": 15, "master_panel": this });
    var skills2289 = new Ext.form.TextArea({ "listeners": { "render": Lino.quicktip_renderer("Sonstige F\u00e4higkeiten","(pcsw.Clients.skills) ") }, "fieldLabel": "Sonstige F\u00e4higkeiten", "name": "skills", "growMax": 2000, "selectOnFocus": true, "anchor": "-20 -10" });
    var competences_1_panel2290 = new Ext.Panel({ "flex": 5, "layout": "hbox", "items": [ cv_SkillsByPerson_grid2281, cv_SoftSkillsByPerson_grid2288, { "items": skills2289, "labelAlign": "top", "layout": "form", "xtype": "panel", "flex": 28 } ], "region": "north", "layoutConfig": { "align": "stretch" }, "hideCheckBoxLabels": true, "split": true, "autoScroll": false, "labelWidth": 189, "border": false, "frame": false, "labelAlign": "top" });
    var cv_ObstaclesByPerson_grid2298 = new Lino.cv.ObstaclesByPerson.GridPanel({ "flex": 55, "listeners": { "render": Lino.quicktip_renderer("Hindernisse","(cv.cv.ObstaclesByPerson) ") }, "hide_top_toolbar": true, "containing_panel": this, "tools": [ Lino.show_in_own_window_button(Lino.cv.ObstaclesByPerson.grid) ], "preview_limit": 15, "master_panel": this });
    var obstacles2299 = new Ext.form.TextArea({ "listeners": { "render": Lino.quicktip_renderer("Hindernisse","(pcsw.Clients.obstacles) ") }, "fieldLabel": "Hindernisse", "name": "obstacles", "growMax": 2000, "selectOnFocus": true, "anchor": "-20 -10" });
    var competences_2_panel2300 = new Ext.Panel({ "flex": 5, "layout": "hbox", "items": [ cv_ObstaclesByPerson_grid2298, { "items": obstacles2299, "labelAlign": "top", "layout": "form", "xtype": "panel", "flex": 44 } ], "region": "center", "layoutConfig": { "align": "stretch" }, "hideCheckBoxLabels": true, "split": true, "autoScroll": false, "labelWidth": 108, "border": false, "frame": false, "labelAlign": "top" });
    var competences_panel2302 = new Lino.VBorderPanel({ "autoScroll": false, "listeners": { "activate": Lino.on_tab_activate }, "border": false, "title": "Kompetenzen", "hideCheckBoxLabels": true, "items": [ competences_1_panel2290, competences_2_panel2300 ], "frame": true, "bodyBorder": false, "labelAlign": "top" });
    var jobs_CandidaturesByPerson_grid2311 = new Lino.jobs.CandidaturesByPerson.GridPanel({ "listeners": { "activate": Lino.on_tab_activate }, "hide_top_toolbar": true, "containing_panel": this, "title": "Stellenanfragen", "tools": [ Lino.show_in_own_window_button(Lino.jobs.CandidaturesByPerson.grid) ], "preview_limit": 15, "master_panel": this });
    var isip_ContractsByPerson_grid2332 = new Lino.isip.ContractsByPerson.GridPanel({ "flex": 5, "hide_top_toolbar": true, "containing_panel": this, "region": "north", "params_panel_hidden": true, "master_panel": this, "preview_limit": 15, "listeners": { "render": Lino.quicktip_renderer("VSEs","(isip.isip.ContractsByPerson) ") }, "split": true, "tools": [ Lino.show_in_own_window_button(Lino.isip.ContractsByPerson.grid) ] });
    var jobs_ContractsByPerson_grid2360 = new Lino.jobs.ContractsByPerson.GridPanel({ "flex": 5, "hide_top_toolbar": true, "containing_panel": this, "region": "center", "params_panel_hidden": true, "master_panel": this, "preview_limit": 15, "listeners": { "render": Lino.quicktip_renderer("Art.60\u00a77-Konventionen","(jobs.jobs.ContractsByPerson) ") }, "split": true, "tools": [ Lino.show_in_own_window_button(Lino.jobs.ContractsByPerson.grid) ] });
    var contracts_panel2361 = new Lino.VBorderPanel({ "autoScroll": false, "listeners": { "activate": Lino.on_tab_activate }, "border": false, "title": "Vertr\u00e4ge", "hideCheckBoxLabels": true, "items": [ isip_ContractsByPerson_grid2332, jobs_ContractsByPerson_grid2360 ], "frame": true, "bodyBorder": false, "labelAlign": "top" });
    var pcsw_NotesByPerson_grid2378 = new Lino.pcsw.NotesByPerson.GridPanel({ "listeners": { "activate": Lino.on_tab_activate }, "hide_top_toolbar": true, "containing_panel": this, "title": "Historie", "tools": [ Lino.show_in_own_window_button(Lino.pcsw.NotesByPerson.grid) ], "preview_limit": 15, "master_panel": this });
    var find_appointment_disp2379 = new Ext.form.DisplayField({ "disabled": true, "listeners": { "render": Lino.quicktip_renderer("Termin finden","(pcsw.Clients.find_appointment) ") }, "fieldLabel": "Termin finden", "name": "find_appointment", "anchor": "-20", "value": "<br/>", "always_enabled": true });
    var cal_EventsByProject_grid2385 = new Lino.cal.EventsByProject.GridPanel({ "flex": 5, "hide_top_toolbar": true, "containing_panel": this, "region": "center", "params_panel_hidden": true, "master_panel": this, "preview_limit": 15, "listeners": { "render": Lino.quicktip_renderer("Termine","(cal.cal.EventsByProject) ") }, "split": true, "tools": [ Lino.show_in_own_window_button(Lino.cal.EventsByProject.grid) ] });
    var cal_TasksByProject_grid2407 = new Lino.cal.TasksByProject.GridPanel({ "flex": 5, "hide_top_toolbar": true, "containing_panel": this, "region": "south", "params_panel_hidden": true, "master_panel": this, "preview_limit": 15, "listeners": { "render": Lino.quicktip_renderer("Aufgaben","(cal.cal.TasksByProject) ") }, "split": true, "tools": [ Lino.show_in_own_window_button(Lino.cal.TasksByProject.grid) ] });
    var calendar_panel2408 = new Lino.VBorderPanel({ "autoScroll": false, "listeners": { "activate": Lino.on_tab_activate }, "border": false, "labelWidth": 126, "title": "Kalender", "hideCheckBoxLabels": true, "items": [ { "autoHeight": true, "layout": "form", "xtype": "panel", "items": find_appointment_disp2379, "region": "north", "labelAlign": "top", "split": true }, cal_EventsByProject_grid2385, cal_TasksByProject_grid2407 ], "frame": true, "bodyBorder": false, "labelAlign": "top" });
    var outbox_MailsByProject_grid2420 = new Lino.outbox.MailsByProject.GridPanel({ "listeners": { "activate": Lino.on_tab_activate }, "hide_top_toolbar": true, "containing_panel": this, "title": "E-Mail-Ausgang", "tools": [ Lino.show_in_own_window_button(Lino.outbox.MailsByProject.grid) ], "preview_limit": 15, "master_panel": this });
    var activity2421 = new Lino.RemoteComboFieldElement({ "fieldLabel": "Beruf", "name": "activity", "pageSize": 20, "emptyText": "Beruf ausw\u00e4hlen...", "listeners": { "render": Lino.quicktip_renderer("Beruf","(pcsw.Clients.activity) ") }, "selectOnFocus": true, "hiddenName": "activityHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/pcsw/Clients/activity", "method": "GET" }) }) });
    var client_state2422 = new Lino.ChoicesFieldElement({ "forceSelection": true, "fieldLabel": "Zustand", "allowBlank": false, "hiddenName": "client_stateHidden", "listeners": { "render": Lino.quicktip_renderer("Zustand","(pcsw.Clients.client_state) ") }, "selectOnFocus": true, "anchor": "-20", "store": Lino.pcsw.ClientStates, "name": "client_state" });
    var refusal_reason2423 = new Lino.ChoicesFieldElement({ "forceSelection": true, "fieldLabel": "refusal reason", "name": "refusal_reason", "hiddenName": "refusal_reasonHidden", "listeners": { "render": Lino.quicktip_renderer("refusal reason","(pcsw.Clients.refusal_reason) ") }, "selectOnFocus": true, "anchor": "-20", "store": [['','<br>']].concat(Lino.pcsw.RefusalReasons) });
    var unavailable_until2424 = new Lino.DateField({ "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Nicht verf\u00fcgbar bis","(pcsw.Clients.unavailable_until) ") }, "fieldLabel": "Nicht verf\u00fcgbar bis", "anchor": "-20", "name": "unavailable_until" });
    var unavailable_why2425 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Grund","(pcsw.Clients.unavailable_why) ") }, "fieldLabel": "Grund", "name": "unavailable_why", "maxLength": 100, "selectOnFocus": true, "anchor": "-20" });
    var misc_1_panel2426 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 180, "hideCheckBoxLabels": true, "items": [ { "flex": 16, "autoHeight": true, "layout": "form", "xtype": "panel", "items": activity2421, "labelAlign": "top" }, { "flex": 9, "autoHeight": true, "layout": "form", "xtype": "panel", "items": client_state2422, "labelAlign": "top" }, { "flex": 36, "autoHeight": true, "layout": "form", "xtype": "panel", "items": refusal_reason2423, "labelAlign": "top" }, { "flex": 12, "autoHeight": true, "layout": "form", "xtype": "panel", "items": unavailable_until2424, "labelAlign": "top" }, { "flex": 25, "autoHeight": true, "layout": "form", "xtype": "panel", "items": unavailable_why2425, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var is_cpas2432 = new Ext.form.Checkbox({ "boxLabel": "Sozialhilfeempf\u00e4nger", "listeners": { "render": Lino.quicktip_renderer("Sozialhilfeempf\u00e4nger","(pcsw.Clients.is_cpas) ") }, "hideLabel": true, "checked": false, "name": "is_cpas", "selectOnFocus": true, "anchor": "-20" });
    var is_senior2433 = new Ext.form.Checkbox({ "boxLabel": "Altenheim", "listeners": { "render": Lino.quicktip_renderer("Altenheim","(pcsw.Clients.is_senior) ") }, "hideLabel": true, "checked": false, "name": "is_senior", "selectOnFocus": true, "anchor": "-20" });
    var is_obsolete2434 = new Ext.form.Checkbox({ "boxLabel": "veraltet", "listeners": { "render": Lino.quicktip_renderer("veraltet","(pcsw.Clients.is_obsolete) Altf\u00e4lle sind Partner, deren Stammdaten nicht mehr gepflegt werden und \nf\u00fcr neue Operationen nicht benutzt werden k\u00f6nnen.") }, "hideLabel": true, "checked": false, "name": "is_obsolete", "selectOnFocus": true, "anchor": "-20" });
    var misc_2_panel2435 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 189, "hideCheckBoxLabels": true, "items": [ { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": is_cpas2432, "labelAlign": "top" }, { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": is_senior2433, "labelAlign": "top" }, { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": is_obsolete2434, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var remarks2439 = new Ext.form.TextArea({ "listeners": { "render": Lino.quicktip_renderer("Bemerkungen","(pcsw.Clients.remarks) ") }, "fieldLabel": "Bemerkungen", "name": "remarks", "growMax": 2000, "selectOnFocus": true, "anchor": "-20 -10" });
    var remarks22440 = new Ext.form.TextArea({ "listeners": { "render": Lino.quicktip_renderer("Bemerkungen (Sozialsekretariat)","(pcsw.Clients.remarks2) ") }, "fieldLabel": "Bemerkungen (Sozialsekretariat)", "name": "remarks2", "growMax": 2000, "selectOnFocus": true, "anchor": "-20 -10" });
    var misc_3_panel2441 = new Ext.Panel({ "flex": 41, "border": false, "layout": "hbox", "labelWidth": 288, "hideCheckBoxLabels": true, "items": [ { "items": remarks2439, "labelAlign": "top", "layout": "form", "xtype": "panel", "flex": 50 }, { "items": remarks22440, "labelAlign": "top", "layout": "form", "xtype": "panel", "flex": 50 } ], "autoScroll": false, "layoutConfig": { "align": "stretch" }, "frame": false, "labelAlign": "top" });
    var contacts_RolesByPerson_grid2444 = new Lino.contacts.RolesByPerson.GridPanel({ "flex": 33, "listeners": { "render": Lino.quicktip_renderer("Kontaktperson f\u00fcr","(contacts.contacts.RolesByPerson) ") }, "hide_top_toolbar": true, "containing_panel": this, "tools": [ Lino.show_in_own_window_button(Lino.contacts.RolesByPerson.grid) ], "preview_limit": 15, "master_panel": this });
    var households_MembersByPerson_grid2445 = new Lino.households.MembersByPerson.GridPanel({ "flex": 66, "listeners": { "render": Lino.quicktip_renderer("Mitglied von","(households.households.MembersByPerson) ") }, "hide_top_toolbar": true, "containing_panel": this, "tools": [ Lino.show_in_own_window_button(Lino.households.MembersByPerson.grid) ], "preview_limit": 15, "master_panel": this });
    var misc_4_panel2446 = new Ext.Panel({ "flex": 41, "border": false, "layout": "hbox", "hideCheckBoxLabels": true, "items": [ contacts_RolesByPerson_grid2444, households_MembersByPerson_grid2445 ], "autoScroll": false, "layoutConfig": { "align": "stretch" }, "frame": false, "labelAlign": "top" });
    var misc_panel2447 = new Ext.Panel({ "layout": "vbox", "title": "Sonstiges", "items": [ misc_1_panel2426, misc_2_panel2435, misc_3_panel2441, misc_4_panel2446 ], "frame": true, "layoutConfig": { "align": "stretch" }, "hideCheckBoxLabels": true, "listeners": { "activate": Lino.on_tab_activate }, "autoScroll": false, "border": false, "bodyBorder": false, "labelAlign": "top" });
    var cbss_identify_person_disp2448 = new Ext.form.DisplayField({ "disabled": true, "listeners": { "render": Lino.quicktip_renderer("IdentifyPerson-Anfragen","(pcsw.Clients.cbss_identify_person) ") }, "fieldLabel": "IdentifyPerson-Anfragen", "name": "cbss_identify_person", "anchor": "-20", "value": "<br/>", "always_enabled": true });
    var cbss_manage_access_disp2449 = new Ext.form.DisplayField({ "disabled": true, "listeners": { "render": Lino.quicktip_renderer("ManageAccess-Anfragen","(pcsw.Clients.cbss_manage_access) ") }, "fieldLabel": "ManageAccess-Anfragen", "name": "cbss_manage_access", "anchor": "-20", "value": "<br/>", "always_enabled": true });
    var cbss_retrieve_ti_groups_disp2450 = new Ext.form.DisplayField({ "disabled": true, "listeners": { "render": Lino.quicktip_renderer("Tx25-Anfragen","(pcsw.Clients.cbss_retrieve_ti_groups) ") }, "fieldLabel": "Tx25-Anfragen", "name": "cbss_retrieve_ti_groups", "anchor": "-20", "value": "<br/>", "always_enabled": true });
    var cbss_1_panel2451 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 216, "hideCheckBoxLabels": true, "items": [ { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": cbss_identify_person_disp2448, "labelAlign": "top" }, { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": cbss_manage_access_disp2449, "labelAlign": "top" }, { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": cbss_retrieve_ti_groups_disp2450, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var cbss_summary_htmlbox2455 = new Lino.HtmlBoxPanel({ "flex": 50, "layout": "fit", "name": "cbss_summary", "containing_panel": this, "master_panel": this, "items": new Ext.BoxComponent({autoScroll:true}), "title": "Zusammenfassung ZDSS", "bodyStyle": "overflow-x:hidden;", "value": "<br/>", "always_enabled": true, "listeners": { "render": Lino.quicktip_renderer("Zusammenfassung ZDSS","(pcsw.Clients.cbss_summary) ") } });
    var cbss_panel2456 = new Ext.Panel({ "layout": "vbox", "title": "ZDSS", "items": [ cbss_1_panel2451, cbss_summary_htmlbox2455 ], "frame": true, "layoutConfig": { "align": "stretch" }, "hideCheckBoxLabels": true, "listeners": { "activate": Lino.on_tab_activate }, "autoScroll": false, "labelWidth": 189, "border": false, "bodyBorder": false, "labelAlign": "top" });
    var main_panel2460 = new Ext.TabPanel({ "hideCheckBoxLabels": true, "border": false, "split": true, "autoScroll": false, "items": [ general_panel2094, status_tab_panel2164, coaching_panel2206, education_panel2230, languages_panel2274, competences_panel2302, jobs_CandidaturesByPerson_grid2311, contracts_panel2361, pcsw_NotesByPerson_grid2378, calendar_panel2408, outbox_MailsByProject_grid2420, misc_panel2447, cbss_panel2456 ], "activeTab": 0, "bodyBorder": false, "frame": true, "labelAlign": "top" });
    this.items = main_panel2460;
    this.before_row_edit = function(record) {
      city2029.setContextValue('country',record ? record.data['countryHidden'] : undefined);
      city2029.setContextValue('region',record ? record.data['regionHidden'] : undefined);
      image_htmlbox2092.refresh();
      pcsw_DispensesByClient_grid2134.on_master_changed();
      pcsw_ExclusionsByClient_grid2140.on_master_changed();
      UploadsByController_htmlbox2161.refresh();
      pcsw_ContactsByClient_grid2195.on_master_changed();
      pcsw_CoachingsByClient_grid2204.on_master_changed();
      jobs_StudiesByPerson_grid2219.on_master_changed();
      jobs_ExperiencesByPerson_grid2229.on_master_changed();
      cv_LanguageKnowledgesByPerson_grid2237.on_master_changed();
      courses_CourseRequestsByPerson_grid2273.on_master_changed();
      cv_SkillsByPerson_grid2281.on_master_changed();
      cv_SoftSkillsByPerson_grid2288.on_master_changed();
      cv_ObstaclesByPerson_grid2298.on_master_changed();
      jobs_CandidaturesByPerson_grid2311.on_master_changed();
      isip_ContractsByPerson_grid2332.on_master_changed();
      jobs_ContractsByPerson_grid2360.on_master_changed();
      pcsw_NotesByPerson_grid2378.on_master_changed();
      cal_EventsByProject_grid2385.on_master_changed();
      cal_TasksByProject_grid2407.on_master_changed();
      outbox_MailsByProject_grid2420.on_master_changed();
      contacts_RolesByPerson_grid2444.on_master_changed();
      households_MembersByPerson_grid2445.on_master_changed();
      cbss_summary_htmlbox2455.refresh();
    }
    this.onRender = function(ct, position) {
      country2028.on('change',Lino.chooser_handler(city2029,'country'));
      Lino.pcsw.Clients.DetailFormPanel.superclass.onRender.call(this, ct, position);
    }
    Lino.pcsw.Clients.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.cbss.IdentifyPersonRequests.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 92,
  initComponent : function() {
    var containing_panel = this;
    var id2749 = new Ext.form.NumberField({ "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("ID","(cbss.IdentifyPersonRequests.id) ") }, "fieldLabel": "ID", "anchor": "-20", "name": "id" });
    var person2750 = new Lino.TwinCombo({ "preferred_width": 20, "fieldLabel": "Klient", "allowBlank": false, "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.pcsw.Clients.detail)}, "emptyText": "Klient ausw\u00e4hlen...", "listeners": { "render": Lino.quicktip_renderer("Klient","(cbss.IdentifyPersonRequests.person) ") }, "selectOnFocus": true, "hiddenName": "personHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cbss/IdentifyPersonRequests/person", "method": "GET" }) }), "name": "person" });
    var user2751 = new Lino.TwinCombo({ "preferred_width": 15, "fieldLabel": "Autor", "allowBlank": false, "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.users.Users.detail)}, "emptyText": "Benutzer ausw\u00e4hlen...", "listeners": { "render": Lino.quicktip_renderer("Autor","(cbss.IdentifyPersonRequests.user) ") }, "selectOnFocus": true, "hiddenName": "userHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cbss/IdentifyPersonRequests/user", "method": "GET" }) }), "name": "user" });
    var environment2752 = new Ext.form.TextField({ "disabled": true, "listeners": { "render": Lino.quicktip_renderer("T/A/B","(cbss.IdentifyPersonRequests.environment) ") }, "fieldLabel": "T/A/B", "name": "environment", "maxLength": 4, "boxMinWidth": Lino.chars2width(4), "anchor": "-20" });
    var sent2753 = new Ext.form.DisplayField({ "disabled": true, "listeners": { "render": Lino.quicktip_renderer("Versendet","(cbss.IdentifyPersonRequests.sent) The date and time when this request has been executed. \nThis is empty for requests than haven't been sent.\nRead-only.") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Versendet</span>", "name": "sent", "anchor": "-20", "value": "<br>" });
    var status2754 = new Lino.ChoicesFieldElement({ "forceSelection": true, "fieldLabel": "Zustand", "name": "status", "hiddenName": "statusHidden", "disabled": true, "listeners": { "render": Lino.quicktip_renderer("Zustand","(cbss.IdentifyPersonRequests.status) ") }, "anchor": "-20", "store": [['','<br>']].concat(Lino.cbss.RequestStates) });
    var ticket2755 = new Ext.form.TextField({ "disabled": true, "listeners": { "render": Lino.quicktip_renderer("Ticket","(cbss.IdentifyPersonRequests.ticket) ") }, "fieldLabel": "Ticket", "name": "ticket", "maxLength": 36, "anchor": "-20" });
    var info_1_panel2756 = new Ext.form.FieldSet({ "autoHeight": true, "layout": "hbox", "title": "Info zur Anfrage", "layoutConfig": { "align": "stretchmax" }, "frame": false, "bodyBorder": true, "autoScroll": false, "items": [ { "flex": 5, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id2749, "labelAlign": "top" }, { "flex": 20, "autoHeight": true, "layout": "form", "xtype": "panel", "items": person2750, "labelAlign": "top" }, { "flex": 20, "autoHeight": true, "layout": "form", "xtype": "panel", "items": user2751, "labelAlign": "top" }, { "flex": 5, "autoHeight": true, "layout": "form", "xtype": "panel", "items": environment2752, "labelAlign": "top" }, { "flex": 16, "autoHeight": true, "layout": "form", "xtype": "panel", "items": sent2753, "labelAlign": "top" }, { "flex": 12, "autoHeight": true, "layout": "form", "xtype": "panel", "items": status2754, "labelAlign": "top" }, { "flex": 21, "autoHeight": true, "layout": "form", "xtype": "panel", "items": ticket2755, "labelAlign": "top" } ], "hideCheckBoxLabels": true, "labelWidth": 90, "border": false, "labelAlign": "top" });
    var national_id2764 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("NR-Nummer","(cbss.IdentifyPersonRequests.national_id) ") }, "fieldLabel": "NR-Nummer", "name": "national_id", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var p1_panel2766 = new Ext.form.FieldSet({ "flex": 25, "layout": "vbox", "title": "Suche per NISS", "layoutConfig": { "align": "stretch" }, "frame": true, "bodyBorder": false, "autoScroll": false, "items": [ { "items": national_id2764, "autoHeight": true, "layout": "form", "xtype": "panel", "labelAlign": "top" }, { "flex": 50, "html": "<br/>", "xtype": "label" } ], "hideCheckBoxLabels": true, "labelWidth": 90, "border": false, "labelAlign": "top" });
    var first_name2768 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Vorname","(cbss.IdentifyPersonRequests.first_name) ") }, "fieldLabel": "Vorname", "name": "first_name", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var middle_name2769 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Mittelnamen","(cbss.IdentifyPersonRequests.middle_name) Whatever this means...") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Mittelnamen</span>", "name": "middle_name", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var last_name2770 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Familienname","(cbss.IdentifyPersonRequests.last_name) ") }, "fieldLabel": "Familienname", "name": "last_name", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var p2_1_panel2771 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": first_name2768, "labelAlign": "top" }, { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": middle_name2769, "labelAlign": "top" }, { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": last_name2770, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 117, "border": false, "anchor": "-20", "labelAlign": "top" });
    var birth_date2775 = new Lino.IncompleteDateField({ "listeners": { "render": Lino.quicktip_renderer("Geburtsdatum","(cbss.IdentifyPersonRequests.birth_date) Uncomplete dates are allowed, e.g. \n\"00.00.1980\" means \"some day in 1980\", \n\"00.07.1980\" means \"in July 1980\"\nor \"23.07.0000\" means \"on a 23th of July\".") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Geburtsdatum</span>", "name": "birth_date", "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var tolerance2776 = new Ext.form.NumberField({ "listeners": { "render": Lino.quicktip_renderer("Toleranz","(cbss.IdentifyPersonRequests.tolerance) \n      Falls Monat oder Tag des Geburtsdatums unbekannt sind, \n      um wieviel Monate bzw. Tage die Suche nach unten/oben ausgeweitet wird.\n      G\u00fcltige Werte: 0 bis 10.\n      ") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Toleranz</span>", "name": "tolerance", "selectOnFocus": true, "anchor": "-20", "value": 0, "allowBlank": false });
    var gender2777 = new Lino.ChoicesFieldElement({ "forceSelection": true, "fieldLabel": "Geschlecht", "name": "gender", "hiddenName": "genderHidden", "listeners": { "render": Lino.quicktip_renderer("Geschlecht","(cbss.IdentifyPersonRequests.gender) ") }, "selectOnFocus": true, "anchor": "-20", "store": [['','<br>']].concat(Lino.lino.Genders) });
    var p2_2_panel2778 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 46, "autoHeight": true, "layout": "form", "xtype": "panel", "items": birth_date2775, "labelAlign": "top" }, { "flex": 19, "autoHeight": true, "layout": "form", "xtype": "panel", "items": tolerance2776, "labelAlign": "top" }, { "flex": 34, "autoHeight": true, "layout": "form", "xtype": "panel", "items": gender2777, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 117, "border": false, "anchor": "-20", "labelAlign": "top" });
    var p2_panel2782 = new Ext.form.FieldSet({ "flex": 75, "autoHeight": true, "layout": "form", "title": "Phonetische Suche", "items": [ p2_1_panel2771, p2_2_panel2778 ], "frame": true, "bodyBorder": false, "autoScroll": false, "hideCheckBoxLabels": true, "border": false, "labelAlign": "top" });
    var parameters_panel2783 = new Ext.form.FieldSet({ "autoHeight": true, "layout": "hbox", "title": "Parameter", "layoutConfig": { "align": "stretchmax" }, "frame": false, "bodyBorder": true, "autoScroll": false, "items": [ p1_panel2766, p2_panel2782 ], "hideCheckBoxLabels": true, "border": false, "labelAlign": "top" });
    var IdentifyPersonResult_grid2794 = new Lino.cbss.IdentifyPersonResult.GridPanel({ "flex": 62, "listeners": { "render": Lino.quicktip_renderer("Resultate","(cbss.cbss.IdentifyPersonResult) ") }, "hide_top_toolbar": true, "containing_panel": this, "tools": [ Lino.show_in_own_window_button(Lino.cbss.IdentifyPersonResult.grid) ], "preview_limit": 15, "master_panel": this });
    var request_panel2795 = new Ext.Panel({ "layout": "vbox", "title": "Abfrage", "items": [ info_1_panel2756, parameters_panel2783, IdentifyPersonResult_grid2794 ], "frame": true, "layoutConfig": { "align": "stretch" }, "hideCheckBoxLabels": true, "listeners": { "activate": Lino.on_tab_activate }, "autoScroll": false, "border": false, "bodyBorder": false, "labelAlign": "top" });
    var response_xml2796 = new Ext.form.TextArea({ "disabled": true, "listeners": { "render": Lino.quicktip_renderer("Antwort","(cbss.IdentifyPersonRequests.response_xml) The raw XML response received. \n") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Antwort</span>", "name": "response_xml", "growMax": 2000, "anchor": "-20 -10" });
    var info_messages2797 = new Ext.form.TextArea({ "disabled": true, "listeners": { "render": Lino.quicktip_renderer("Info-Meldungen","(cbss.IdentifyPersonRequests.info_messages) ") }, "fieldLabel": "Info-Meldungen", "name": "info_messages", "growMax": 2000, "anchor": "-20 -10" });
    var debug_messages2798 = new Ext.form.TextArea({ "disabled": true, "listeners": { "render": Lino.quicktip_renderer("Debug-Meldungen","(cbss.IdentifyPersonRequests.debug_messages) ") }, "fieldLabel": "Debug-Meldungen", "name": "debug_messages", "growMax": 2000, "anchor": "-20 -10" });
    var technical_panel2799 = new Lino.VBorderPanel({ "autoScroll": false, "listeners": { "activate": Lino.on_tab_activate }, "border": false, "labelWidth": 144, "title": "Technisch", "hideCheckBoxLabels": true, "items": [ { "flex": 5, "layout": "form", "xtype": "panel", "items": response_xml2796, "region": "north", "labelAlign": "top", "split": true }, { "flex": 5, "layout": "form", "xtype": "panel", "items": info_messages2797, "region": "center", "labelAlign": "top", "split": true }, { "flex": 5, "layout": "form", "xtype": "panel", "items": debug_messages2798, "region": "south", "labelAlign": "top", "split": true } ], "frame": true, "bodyBorder": false, "labelAlign": "top" });
    var main_panel2803 = new Ext.TabPanel({ "hideCheckBoxLabels": true, "border": false, "split": true, "autoScroll": false, "items": [ request_panel2795, technical_panel2799 ], "activeTab": 0, "bodyBorder": false, "frame": true, "labelAlign": "top" });
    this.items = main_panel2803;
    this.before_row_edit = function(record) {
      IdentifyPersonResult_grid2794.on_master_changed();
    }
    Lino.cbss.IdentifyPersonRequests.DetailFormPanel.superclass.initComponent.call(this);
    // active_fields:
    person2750.on("change",function(){this.save()},this);
  }
});


Lino.languages.Languages.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 41,
  initComponent : function() {
    var containing_panel = this;
    var id2524 = new Ext.form.TextField({ "fieldLabel": "id", "name": "id", "boxMinWidth": Lino.chars2width(3), "listeners": { "render": Lino.quicktip_renderer("id","(languages.Languages.id) ") }, "maxLength": 3, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var iso22525 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("iso2","(languages.Languages.iso2) ") }, "fieldLabel": "iso2", "name": "iso2", "maxLength": 2, "selectOnFocus": true, "boxMinWidth": Lino.chars2width(2), "anchor": "-20" });
    var name2526 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Bezeichnung","(languages.Languages.name) ") }, "fieldLabel": "Bezeichnung", "name": "name", "maxLength": 200, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var name_fr2527 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Bezeichnung (fr)","(languages.Languages.name_fr) ") }, "fieldLabel": "Bezeichnung (fr)", "name": "name_fr", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var name_de2528 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Bezeichnung (de)","(languages.Languages.name_de) ") }, "fieldLabel": "Bezeichnung (de)", "name": "name_de", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var name_nl2529 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Bezeichnung (nl)","(languages.Languages.name_nl) ") }, "fieldLabel": "Bezeichnung (nl)", "name": "name_nl", "maxLength": 200, "selectOnFocus": true, "hidden": true, "anchor": "-20" });
    var main_1_panel2530 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 153, "hideCheckBoxLabels": true, "items": [ { "flex": 4, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id2524, "labelAlign": "top" }, { "flex": 4, "autoHeight": true, "layout": "form", "xtype": "panel", "items": iso22525, "labelAlign": "top" }, { "flex": 22, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name2526, "labelAlign": "top" }, { "flex": 22, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_fr2527, "labelAlign": "top" }, { "flex": 22, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_de2528, "labelAlign": "top" }, { "flex": 22, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_nl2529, "hidden": true, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var cv_KnowledgesByLanguage_grid2543 = new Lino.cv.KnowledgesByLanguage.GridPanel({ "flex": 83, "listeners": { "render": Lino.quicktip_renderer("Sprachkenntnisse","(cv.cv.KnowledgesByLanguage) ") }, "hide_top_toolbar": true, "containing_panel": this, "tools": [ Lino.show_in_own_window_button(Lino.cv.KnowledgesByLanguage.grid) ], "preview_limit": 15, "master_panel": this });
    var main_panel2544 = new Ext.Panel({ "autoScroll": false, "border": false, "layout": "vbox", "hideCheckBoxLabels": true, "items": [ main_1_panel2530, cv_KnowledgesByLanguage_grid2543 ], "frame": true, "layoutConfig": { "align": "stretch" }, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel2544;
    this.before_row_edit = function(record) {
      cv_KnowledgesByLanguage_grid2543.on_master_changed();
    }
    Lino.languages.Languages.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.changes.ChangesByMaster.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 10,
  disable_editing: true,
  initComponent : function() {
    var containing_panel = this;
    var time424 = new Ext.form.DisplayField({ "listeners": { "render": Lino.quicktip_renderer("time","(changes.Changes.time) ") }, "fieldLabel": "time", "name": "time", "selectOnFocus": true, "anchor": "-20", "value": "<br>", "allowBlank": false });
    var user425 = new Lino.TwinCombo({ "preferred_width": 15, "fieldLabel": "Benutzer", "allowBlank": false, "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.users.Users.detail)}, "emptyText": "Benutzer ausw\u00e4hlen...", "listeners": { "render": Lino.quicktip_renderer("Benutzer","(changes.Changes.user) ") }, "selectOnFocus": true, "hiddenName": "userHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/changes/Changes/user", "method": "GET" }) }), "name": "user" });
    var type426 = new Lino.ChoicesFieldElement({ "forceSelection": true, "fieldLabel": "\u00c4nderungsart", "allowBlank": false, "hiddenName": "typeHidden", "listeners": { "render": Lino.quicktip_renderer("\u00c4nderungsart","(changes.Changes.type) ") }, "selectOnFocus": true, "anchor": "-20", "store": Lino.lino.ChangeTypes, "name": "type" });
    var master_disp427 = new Ext.form.DisplayField({ "disabled": true, "fieldLabel": "Stammdaten", "anchor": "-20", "name": "master" });
    var object_disp428 = new Ext.form.DisplayField({ "disabled": true, "fieldLabel": "Object", "anchor": "-20", "name": "object" });
    var id429 = new Ext.form.NumberField({ "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("ID","(changes.Changes.id) ") }, "fieldLabel": "ID", "anchor": "-20", "name": "id" });
    var main_1_panel430 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 117, "hideCheckBoxLabels": true, "items": [ { "flex": 21, "autoHeight": true, "layout": "form", "xtype": "panel", "items": time424, "labelAlign": "top" }, { "flex": 26, "autoHeight": true, "layout": "form", "xtype": "panel", "items": user425, "labelAlign": "top" }, { "flex": 19, "autoHeight": true, "layout": "form", "xtype": "panel", "items": type426, "labelAlign": "top" }, { "flex": 13, "autoHeight": true, "layout": "form", "xtype": "panel", "items": master_disp427, "labelAlign": "top" }, { "flex": 13, "autoHeight": true, "layout": "form", "xtype": "panel", "items": object_disp428, "labelAlign": "top" }, { "flex": 6, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id429, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var diff437 = new Ext.form.TextArea({ "listeners": { "render": Lino.quicktip_renderer("\u00c4nderungen","(changes.Changes.diff) ") }, "fieldLabel": "\u00c4nderungen", "name": "diff", "growMax": 2000, "selectOnFocus": true, "anchor": "-20 -10" });
    var main_panel438 = new Ext.Panel({ "autoScroll": false, "border": false, "layout": "vbox", "labelWidth": 99, "hideCheckBoxLabels": true, "items": [ main_1_panel430, { "items": diff437, "labelAlign": "top", "layout": "form", "xtype": "panel", "flex": 83 } ], "frame": true, "layoutConfig": { "align": "stretch" }, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel438;
    this.before_row_edit = function(record) {
    }
    Lino.changes.ChangesByMaster.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.courses.CourseContents.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 80,
  initComponent : function() {
    var containing_panel = this;
    var id2655 = new Ext.form.NumberField({ "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("ID","(courses.CourseContents.id) ") }, "fieldLabel": "ID", "anchor": "-20", "name": "id" });
    var name2656 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Name","(courses.CourseContents.name) ") }, "fieldLabel": "Name", "name": "name", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var main_1_panel2657 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 19, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id2655, "labelAlign": "top" }, { "flex": 80, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name2656, "labelAlign": "top" } ], "region": "north", "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "split": true, "autoScroll": false, "labelWidth": 45, "border": false, "frame": false, "labelAlign": "top" });
    var courses_CourseOffersByContent_grid2664 = new Lino.courses.CourseOffersByContent.GridPanel({ "flex": 5, "hide_top_toolbar": true, "containing_panel": this, "region": "center", "preview_limit": 15, "master_panel": this, "listeners": { "render": Lino.quicktip_renderer("Kursangebote","(courses.courses.CourseOffersByContent) ") }, "split": true, "tools": [ Lino.show_in_own_window_button(Lino.courses.CourseOffersByContent.grid) ] });
    var courses_CourseRequestsByContent_grid2675 = new Lino.courses.CourseRequestsByContent.GridPanel({ "flex": 5, "hide_top_toolbar": true, "containing_panel": this, "region": "south", "preview_limit": 15, "master_panel": this, "listeners": { "render": Lino.quicktip_renderer("Kursanfragen","(courses.courses.CourseRequestsByContent) ") }, "split": true, "tools": [ Lino.show_in_own_window_button(Lino.courses.CourseRequestsByContent.grid) ] });
    var main_panel2676 = new Lino.VBorderPanel({ "autoScroll": false, "border": false, "hideCheckBoxLabels": true, "items": [ main_1_panel2657, courses_CourseOffersByContent_grid2664, courses_CourseRequestsByContent_grid2675 ], "frame": true, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel2676;
    this.before_row_edit = function(record) {
      courses_CourseOffersByContent_grid2664.on_master_changed();
      courses_CourseRequestsByContent_grid2675.on_master_changed();
    }
    Lino.courses.CourseContents.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.notes.MyNotes.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 93,
  initComponent : function() {
    var containing_panel = this;
    var date694 = new Lino.DateField({ "listeners": { "render": Lino.quicktip_renderer("Datum","(notes.Notes.date) ") }, "fieldLabel": "Datum", "name": "date", "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var event_type695 = new Lino.TwinCombo({ "fieldLabel": "Ereignisart (Form)", "name": "event_type", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.notes.EventTypes.detail)}, "emptyText": "Event Type ausw\u00e4hlen...", "listeners": { "render": Lino.quicktip_renderer("Ereignisart (Form)","(notes.Notes.event_type) ") }, "selectOnFocus": true, "hiddenName": "event_typeHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/notes/Notes/event_type", "method": "GET" }) }) });
    var type696 = new Lino.TwinCombo({ "fieldLabel": "Notizart (Inhalt)", "name": "type", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.notes.NoteTypes.detail)}, "emptyText": "Notizart ausw\u00e4hlen...", "listeners": { "render": Lino.quicktip_renderer("Notizart (Inhalt)","(notes.Notes.type) ") }, "selectOnFocus": true, "hiddenName": "typeHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/notes/Notes/type", "method": "GET" }) }) });
    var left_1_panel697 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 171, "hideCheckBoxLabels": true, "items": [ { "flex": 16, "autoHeight": true, "layout": "form", "xtype": "panel", "items": date694, "labelAlign": "top" }, { "flex": 41, "autoHeight": true, "layout": "form", "xtype": "panel", "items": event_type695, "labelAlign": "top" }, { "flex": 41, "autoHeight": true, "layout": "form", "xtype": "panel", "items": type696, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var project701 = new Lino.TwinCombo({ "preferred_width": 20, "fieldLabel": "Klient", "name": "project", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.pcsw.Clients.detail)}, "hiddenName": "projectHidden", "listeners": { "render": Lino.quicktip_renderer("Klient","(notes.Notes.project) ") }, "selectOnFocus": true, "emptyText": "Klient ausw\u00e4hlen...", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/notes/Notes/project", "method": "GET" }) }) });
    var subject702 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Betreff","(notes.Notes.subject) ") }, "fieldLabel": "Betreff", "name": "subject", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var left_2_panel703 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 72, "hideCheckBoxLabels": true, "items": [ { "flex": 48, "autoHeight": true, "layout": "form", "xtype": "panel", "items": project701, "labelAlign": "top" }, { "flex": 51, "autoHeight": true, "layout": "form", "xtype": "panel", "items": subject702, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var company706 = new Lino.TwinCombo({ "preferred_width": 20, "fieldLabel": "Empf\u00e4nger (Organisation)", "name": "company", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.contacts.Companies.detail)}, "hiddenName": "companyHidden", "listeners": { "render": Lino.quicktip_renderer("Empf\u00e4nger (Organisation)","(notes.Notes.company) ") }, "selectOnFocus": true, "emptyText": "Organisation ausw\u00e4hlen...", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/notes/Notes/company", "method": "GET" }) }) });
    var contact_person707 = new Lino.TwinCombo({ "preferred_width": 20, "fieldLabel": "Empf\u00e4nger (Person)", "name": "contact_person", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.contacts.Persons.detail)}, "hiddenName": "contact_personHidden", "listeners": { "render": Lino.quicktip_renderer("Empf\u00e4nger (Person)","(notes.Notes.contact_person) ") }, "selectOnFocus": true, "emptyText": "Person ausw\u00e4hlen...", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/notes/Notes/contact_person", "method": "GET" }) }) });
    var left_3_panel708 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 225, "hideCheckBoxLabels": true, "items": [ { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": company706, "labelAlign": "top" }, { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": contact_person707, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var user711 = new Lino.TwinCombo({ "preferred_width": 15, "fieldLabel": "Autor", "name": "user", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.users.Users.detail)}, "hiddenName": "userHidden", "listeners": { "render": Lino.quicktip_renderer("Autor","(notes.Notes.user) ") }, "selectOnFocus": true, "emptyText": "Benutzer ausw\u00e4hlen...", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/notes/Notes/user", "method": "GET" }) }) });
    var language712 = new Lino.ChoicesFieldElement({ "fieldLabel": "Sprache", "allowBlank": false, "hiddenName": "languageHidden", "listeners": { "render": Lino.quicktip_renderer("Sprache","(notes.Notes.language) ") }, "selectOnFocus": true, "anchor": "-20", "store": [ [ "en", "Englisch" ], [ "fr", "Franz\u00f6sisch" ], [ "de", "Deutsch" ], [ "nl", "Niederl\u00e4ndisch" ] ], "name": "language" });
    var build_time713 = new Ext.form.DisplayField({ "disabled": true, "listeners": { "render": Lino.quicktip_renderer("Druckdatum","(notes.Notes.build_time) ") }, "fieldLabel": "Druckdatum", "name": "build_time", "anchor": "-20", "value": "<br>" });
    var id714 = new Ext.form.NumberField({ "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("ID","(notes.Notes.id) ") }, "fieldLabel": "ID", "anchor": "-20", "name": "id" });
    var left_4_panel715 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 99, "hideCheckBoxLabels": true, "items": [ { "flex": 25, "autoHeight": true, "layout": "form", "xtype": "panel", "items": user711, "labelAlign": "top" }, { "flex": 20, "autoHeight": true, "layout": "form", "xtype": "panel", "items": language712, "labelAlign": "top" }, { "flex": 41, "autoHeight": true, "layout": "form", "xtype": "panel", "items": build_time713, "labelAlign": "top" }, { "flex": 12, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id714, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var body720 = new Lino.RichTextPanel({ "selectOnFocus": true, "flex": 55, "containing_panel": this, "name": "body", "title": "Inhalt" });
    var left_panel721 = new Ext.Panel({ "flex": 66, "layout": "vbox", "items": [ left_1_panel697, left_2_panel703, left_3_panel708, left_4_panel715, body720 ], "frame": true, "layoutConfig": { "align": "stretch" }, "autoScroll": false, "hideCheckBoxLabels": true, "labelWidth": 0, "border": false, "bodyBorder": false, "labelAlign": "top" });
    var UploadsByController_htmlbox722 = new Lino.HtmlBoxPanel({ "flex": 3, "ls_bbar_actions": [ { "itemId": "insert", "menu_item_text": "Neu", "must_save": true, "tooltip": "Neuen Datensatz erstellen", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-new", "overflowText": "Neu", "auto_save": true } ], "name": "UploadsByController", "containing_panel": this, "items": new Ext.BoxComponent({autoScroll:true}), "region": "north", "title": "Uploads", "master_panel": this, "value": "<br/>", "always_enabled": true, "listeners": { "render": Lino.quicktip_renderer("Uploads","(notes.Notes.UploadsByController) ") }, "bodyStyle": "overflow-x:hidden;", "ls_insert_handler": Lino.uploads.UploadsByController.insert, "layout": "fit", "tools": [ Lino.show_in_own_window_button(Lino.uploads.UploadsByController.grid) ], "split": true });
    var outbox_MailsByController_grid768 = new Lino.outbox.MailsByController.GridPanel({ "flex": 5, "hide_top_toolbar": true, "containing_panel": this, "region": "center", "preview_limit": 15, "master_panel": this, "listeners": { "render": Lino.quicktip_renderer("E-Mail-Ausg\u00e4nge","(outbox.outbox.MailsByController) ") }, "split": true, "tools": [ Lino.show_in_own_window_button(Lino.outbox.MailsByController.grid) ] });
    var cal_TasksByController_grid774 = new Lino.cal.TasksByController.GridPanel({ "flex": 5, "hide_top_toolbar": true, "containing_panel": this, "region": "south", "params_panel_hidden": true, "master_panel": this, "preview_limit": 15, "listeners": { "render": Lino.quicktip_renderer("Aufgaben","(cal.cal.TasksByController) ") }, "split": true, "tools": [ Lino.show_in_own_window_button(Lino.cal.TasksByController.grid) ] });
    var right_panel775 = new Lino.VBorderPanel({ "flex": 33, "border": false, "labelWidth": 72, "hideCheckBoxLabels": true, "items": [ UploadsByController_htmlbox722, outbox_MailsByController_grid768, cal_TasksByController_grid774 ], "frame": true, "autoScroll": false, "bodyBorder": false, "labelAlign": "top" });
    var main_1_panel776 = new Ext.Panel({ "autoScroll": false, "border": false, "layout": "hbox", "hideCheckBoxLabels": true, "items": [ left_panel721, right_panel775 ], "frame": false, "layoutConfig": { "align": "stretch" }, "labelAlign": "top" });
    var main_panel777 = new Ext.Panel({ "autoScroll": false, "border": false, "layout": "fit", "hideCheckBoxLabels": true, "items": [ main_1_panel776 ], "frame": true, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel777;
    this.before_row_edit = function(record) {
      contact_person707.setContextValue('company',record ? record.data['companyHidden'] : undefined);
      body720.refresh();
      UploadsByController_htmlbox722.refresh();
      outbox_MailsByController_grid768.on_master_changed();
      cal_TasksByController_grid774.on_master_changed();
    }
    this.onRender = function(ct, position) {
      company706.on('change',Lino.chooser_handler(contact_person707,'company'));
      Lino.notes.MyNotes.DetailFormPanel.superclass.onRender.call(this, ct, position);
    }
    Lino.notes.MyNotes.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.isip.ContractEndings.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 63,
  initComponent : function() {
    var containing_panel = this;
    var name1539 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Bezeichnung","(isip.ContractEndings.name) ") }, "fieldLabel": "Bezeichnung", "name": "name", "maxLength": 200, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var use_in_isip1540 = new Ext.form.Checkbox({ "boxLabel": "VSE", "listeners": { "render": Lino.quicktip_renderer("VSE","(isip.ContractEndings.use_in_isip) ") }, "hideLabel": true, "checked": true, "name": "use_in_isip", "selectOnFocus": true, "anchor": "-20" });
    var use_in_jobs1541 = new Ext.form.Checkbox({ "boxLabel": "Art.60\u00a77", "listeners": { "render": Lino.quicktip_renderer("Art.60\u00a77","(isip.ContractEndings.use_in_jobs) ") }, "hideLabel": true, "checked": true, "name": "use_in_jobs", "selectOnFocus": true, "anchor": "-20" });
    var is_success1542 = new Ext.form.Checkbox({ "boxLabel": "Erfolgreich abgeschlossen", "listeners": { "render": Lino.quicktip_renderer("Erfolgreich abgeschlossen","(isip.ContractEndings.is_success) ") }, "hideLabel": true, "checked": false, "name": "is_success", "selectOnFocus": true, "anchor": "-20" });
    var needs_date_ended1543 = new Ext.form.Checkbox({ "boxLabel": "erfordert Enddatum", "listeners": { "render": Lino.quicktip_renderer("erfordert Enddatum","(isip.ContractEndings.needs_date_ended) ") }, "hideLabel": true, "checked": false, "name": "needs_date_ended", "selectOnFocus": true, "anchor": "-20" });
    var main_2_panel1544 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 234, "hideCheckBoxLabels": true, "items": [ { "flex": 25, "autoHeight": true, "layout": "form", "xtype": "panel", "items": use_in_isip1540, "labelAlign": "top" }, { "flex": 25, "autoHeight": true, "layout": "form", "xtype": "panel", "items": use_in_jobs1541, "labelAlign": "top" }, { "flex": 25, "autoHeight": true, "layout": "form", "xtype": "panel", "items": is_success1542, "labelAlign": "top" }, { "flex": 25, "autoHeight": true, "layout": "form", "xtype": "panel", "items": needs_date_ended1543, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var isip_ContractsByEnding_grid1569 = new Lino.isip.ContractsByEnding.GridPanel({ "flex": 41, "hide_top_toolbar": true, "containing_panel": this, "params_panel_hidden": true, "master_panel": this, "preview_limit": 15, "listeners": { "render": Lino.quicktip_renderer("VSEs","(isip.isip.ContractsByEnding) ") }, "tools": [ Lino.show_in_own_window_button(Lino.isip.ContractsByEnding.grid) ] });
    var jobs_ContractsByEnding_grid1597 = new Lino.jobs.ContractsByEnding.GridPanel({ "flex": 41, "hide_top_toolbar": true, "containing_panel": this, "params_panel_hidden": true, "master_panel": this, "preview_limit": 15, "listeners": { "render": Lino.quicktip_renderer("Art.60\u00a77-Konventionen","(jobs.jobs.ContractsByEnding) ") }, "tools": [ Lino.show_in_own_window_button(Lino.jobs.ContractsByEnding.grid) ] });
    var main_panel1598 = new Ext.Panel({ "autoScroll": false, "border": false, "layout": "vbox", "labelWidth": 108, "hideCheckBoxLabels": true, "items": [ { "items": name1539, "autoHeight": true, "layout": "form", "xtype": "panel", "labelAlign": "top" }, main_2_panel1544, isip_ContractsByEnding_grid1569, jobs_ContractsByEnding_grid1597 ], "frame": true, "layoutConfig": { "align": "stretch" }, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel1598;
    this.before_row_edit = function(record) {
      isip_ContractsByEnding_grid1569.on_master_changed();
      jobs_ContractsByEnding_grid1597.on_master_changed();
    }
    Lino.isip.ContractEndings.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.uploads.MyUploads.InsertFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  autoHeight: true,
  content_type: 25,
  initComponent : function() {
    var containing_panel = this;
    var file2999 = Lino.file_field_handler(this,{ "listeners": { "render": Lino.quicktip_renderer("File","(uploads.Uploads.file) ") }, "fieldLabel": "File", "name": "file", "maxLength": 100, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var user3000 = new Lino.TwinCombo({ "preferred_width": 15, "fieldLabel": "Autor", "name": "user", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.users.Users.detail)}, "hiddenName": "userHidden", "listeners": { "render": Lino.quicktip_renderer("Autor","(uploads.Uploads.user) ") }, "selectOnFocus": true, "emptyText": "Benutzer ausw\u00e4hlen...", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/uploads/Uploads/user", "method": "GET" }) }) });
    var main_1_panel3001 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 51, "autoHeight": true, "layout": "form", "xtype": "panel", "items": file2999, "labelAlign": "top" }, { "flex": 48, "autoHeight": true, "layout": "form", "xtype": "panel", "items": user3000, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 54, "border": false, "anchor": "-20", "labelAlign": "top" });
    var type3004 = new Lino.RemoteComboFieldElement({ "fieldLabel": "Upload-Art", "name": "type", "pageSize": 20, "emptyText": "Upload-Art ausw\u00e4hlen...", "listeners": { "render": Lino.quicktip_renderer("Upload-Art","(uploads.Uploads.type) ") }, "selectOnFocus": true, "hiddenName": "typeHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/uploads/Uploads/type", "method": "GET" }) }) });
    var valid_until3005 = new Lino.DateField({ "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("g\u00fcltig bis","(uploads.Uploads.valid_until) ") }, "fieldLabel": "g\u00fcltig bis", "anchor": "-20", "name": "valid_until" });
    var main_2_panel3006 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 71, "autoHeight": true, "layout": "form", "xtype": "panel", "items": type3004, "labelAlign": "top" }, { "flex": 28, "autoHeight": true, "layout": "form", "xtype": "panel", "items": valid_until3005, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 99, "border": false, "anchor": "-20", "labelAlign": "top" });
    var description3009 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Beschreibung","(uploads.Uploads.description) ") }, "fieldLabel": "Beschreibung", "name": "description", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var main_panel3010 = new Ext.Panel({ "hideCheckBoxLabels": true, "autoHeight": true, "border": false, "layout": "form", "labelWidth": 117, "autoScroll": false, "items": [ main_1_panel3001, main_2_panel3006, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": description3009, "anchor": "-20", "labelAlign": "top" } ], "frame": true, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel3010;
    this.before_row_edit = function(record) {
    }
    Lino.uploads.MyUploads.InsertFormPanel.superclass.initComponent.call(this);
  }
});


Lino.jobs.Offers.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 69,
  initComponent : function() {
    var containing_panel = this;
    var name1962 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Name","(jobs.Offers.name) ") }, "fieldLabel": "Name", "name": "name", "maxLength": 100, "selectOnFocus": true, "anchor": "-20" });
    var provider1963 = new Lino.TwinCombo({ "preferred_width": 20, "fieldLabel": "Stellenanbieter", "name": "provider", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.jobs.JobProviders.detail)}, "hiddenName": "providerHidden", "listeners": { "render": Lino.quicktip_renderer("Stellenanbieter","(jobs.Offers.provider) ") }, "selectOnFocus": true, "emptyText": "Stellenanbieter ausw\u00e4hlen...", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/jobs/Offers/provider", "method": "GET" }) }) });
    var sector1964 = new Lino.TwinCombo({ "fieldLabel": "Sektor", "name": "sector", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.jobs.Sectors.detail)}, "emptyText": "Sektor ausw\u00e4hlen...", "listeners": { "render": Lino.quicktip_renderer("Sektor","(jobs.Offers.sector) ") }, "selectOnFocus": true, "hiddenName": "sectorHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/jobs/Offers/sector", "method": "GET" }) }) });
    var function1965 = new Lino.TwinCombo({ "fieldLabel": "Funktion", "name": "function", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.jobs.Functions.detail)}, "emptyText": "Funktion ausw\u00e4hlen...", "listeners": { "render": Lino.quicktip_renderer("Funktion","(jobs.Offers.function) ") }, "selectOnFocus": true, "hiddenName": "functionHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/jobs/Offers/function", "method": "GET" }) }) });
    var main_1_panel1966 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 144, "hideCheckBoxLabels": true, "items": [ { "flex": 25, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name1962, "labelAlign": "top" }, { "flex": 24, "autoHeight": true, "layout": "form", "xtype": "panel", "items": provider1963, "labelAlign": "top" }, { "flex": 24, "autoHeight": true, "layout": "form", "xtype": "panel", "items": sector1964, "labelAlign": "top" }, { "flex": 24, "autoHeight": true, "layout": "form", "xtype": "panel", "items": function1965, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var selection_from1971 = new Lino.DateField({ "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Beginn Auswahl","(jobs.Offers.selection_from) ") }, "fieldLabel": "Beginn Auswahl", "anchor": "-20", "name": "selection_from" });
    var selection_until1972 = new Lino.DateField({ "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Ende Auswahl","(jobs.Offers.selection_until) ") }, "fieldLabel": "Ende Auswahl", "anchor": "-20", "name": "selection_until" });
    var start_date1973 = new Lino.DateField({ "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Beginndatum","(jobs.Offers.start_date) ") }, "fieldLabel": "Beginndatum", "anchor": "-20", "name": "start_date" });
    var main_2_panel1974 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 135, "hideCheckBoxLabels": true, "items": [ { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": selection_from1971, "labelAlign": "top" }, { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": selection_until1972, "labelAlign": "top" }, { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": start_date1973, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var remark1978 = new Ext.form.TextArea({ "listeners": { "render": Lino.quicktip_renderer("Bemerkung","(jobs.Offers.remark) ") }, "fieldLabel": "Bemerkung", "name": "remark", "growMax": 2000, "selectOnFocus": true, "anchor": "-20 -10" });
    var ExperiencesByOffer_grid1990 = new Lino.jobs.ExperiencesByOffer.GridPanel({ "flex": 50, "listeners": { "render": Lino.quicktip_renderer("Experiences","(jobs.jobs.ExperiencesByOffer) ") }, "hide_top_toolbar": true, "containing_panel": this, "tools": [ Lino.show_in_own_window_button(Lino.jobs.ExperiencesByOffer.grid) ], "preview_limit": 15, "master_panel": this });
    var CandidaturesByOffer_grid2000 = new Lino.jobs.CandidaturesByOffer.GridPanel({ "flex": 50, "listeners": { "render": Lino.quicktip_renderer("Kandidaten","(jobs.jobs.CandidaturesByOffer) ") }, "hide_top_toolbar": true, "containing_panel": this, "tools": [ Lino.show_in_own_window_button(Lino.jobs.CandidaturesByOffer.grid) ], "preview_limit": 15, "master_panel": this });
    var main_4_panel2001 = new Ext.Panel({ "flex": 41, "border": false, "layout": "hbox", "hideCheckBoxLabels": true, "items": [ ExperiencesByOffer_grid1990, CandidaturesByOffer_grid2000 ], "autoScroll": false, "layoutConfig": { "align": "stretch" }, "frame": false, "labelAlign": "top" });
    var main_panel2002 = new Ext.Panel({ "autoScroll": false, "border": false, "layout": "vbox", "labelWidth": 90, "hideCheckBoxLabels": true, "items": [ main_1_panel1966, main_2_panel1974, { "items": remark1978, "labelAlign": "top", "layout": "form", "xtype": "panel", "flex": 41 }, main_4_panel2001 ], "frame": true, "layoutConfig": { "align": "stretch" }, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel2002;
    this.before_row_edit = function(record) {
      function1965.setContextValue('sector',record ? record.data['sectorHidden'] : undefined);
      ExperiencesByOffer_grid1990.on_master_changed();
      CandidaturesByOffer_grid2000.on_master_changed();
    }
    this.onRender = function(ct, position) {
      sector1964.on('change',Lino.chooser_handler(function1965,'sector'));
      Lino.jobs.Offers.DetailFormPanel.superclass.onRender.call(this, ct, position);
    }
    Lino.jobs.Offers.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.isip.ExamPolicies.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 61,
  initComponent : function() {
    var containing_panel = this;
    var id1384 = new Ext.form.NumberField({ "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("ID","(isip.ExamPolicies.id) ") }, "fieldLabel": "ID", "anchor": "-20", "name": "id" });
    var name1385 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Bezeichnung","(isip.ExamPolicies.name) ") }, "fieldLabel": "Bezeichnung", "name": "name", "maxLength": 200, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var name_fr1386 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Bezeichnung (fr)","(isip.ExamPolicies.name_fr) ") }, "fieldLabel": "Bezeichnung (fr)", "name": "name_fr", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var name_de1387 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Bezeichnung (de)","(isip.ExamPolicies.name_de) ") }, "fieldLabel": "Bezeichnung (de)", "name": "name_de", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var name_nl1388 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Bezeichnung (nl)","(isip.ExamPolicies.name_nl) ") }, "fieldLabel": "Bezeichnung (nl)", "name": "name_nl", "maxLength": 200, "selectOnFocus": true, "hidden": true, "anchor": "-20" });
    var main_1_panel1389 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 153, "hideCheckBoxLabels": true, "items": [ { "flex": 5, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id1384, "labelAlign": "top" }, { "flex": 23, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name1385, "labelAlign": "top" }, { "flex": 23, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_fr1386, "labelAlign": "top" }, { "flex": 23, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_de1387, "labelAlign": "top" }, { "flex": 23, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_nl1388, "hidden": true, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var max_events1395 = new Ext.form.NumberField({ "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Anzahl Termine","(isip.ExamPolicies.max_events) ") }, "fieldLabel": "Anzahl Termine", "anchor": "-20", "name": "max_events" });
    var every1396 = new Ext.form.NumberField({ "listeners": { "render": Lino.quicktip_renderer("... alle","(isip.ExamPolicies.every) ") }, "fieldLabel": "... alle", "name": "every", "selectOnFocus": true, "anchor": "-20", "value": 0, "allowBlank": false });
    var every_unit1397 = new Lino.ChoicesFieldElement({ "forceSelection": true, "fieldLabel": "Wiederholung", "name": "every_unit", "hiddenName": "every_unitHidden", "listeners": { "render": Lino.quicktip_renderer("Wiederholung","(isip.ExamPolicies.every_unit) ") }, "selectOnFocus": true, "anchor": "-20", "store": [['','<br>']].concat(Lino.cal.Recurrencies) });
    var calendar1398 = new Lino.TwinCombo({ "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Kalender</span>", "name": "calendar", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.cal.Calendars.detail)}, "emptyText": "Kalender ausw\u00e4hlen...", "listeners": { "render": Lino.quicktip_renderer("Kalender","(isip.ExamPolicies.calendar) The calendar to which events will be generated.") }, "selectOnFocus": true, "hiddenName": "calendarHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/isip/ExamPolicies/calendar", "method": "GET" }) }) });
    var main_2_panel1399 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 135, "hideCheckBoxLabels": true, "items": [ { "flex": 11, "autoHeight": true, "layout": "form", "xtype": "panel", "items": max_events1395, "labelAlign": "top" }, { "flex": 11, "autoHeight": true, "layout": "form", "xtype": "panel", "items": every1396, "labelAlign": "top" }, { "flex": 31, "autoHeight": true, "layout": "form", "xtype": "panel", "items": every_unit1397, "labelAlign": "top" }, { "flex": 45, "autoHeight": true, "layout": "form", "xtype": "panel", "items": calendar1398, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var isip_ContractsByPolicy_grid1424 = new Lino.isip.ContractsByPolicy.GridPanel({ "flex": 41, "hide_top_toolbar": true, "containing_panel": this, "params_panel_hidden": true, "master_panel": this, "preview_limit": 15, "listeners": { "render": Lino.quicktip_renderer("VSEs","(isip.isip.ContractsByPolicy) ") }, "tools": [ Lino.show_in_own_window_button(Lino.isip.ContractsByPolicy.grid) ] });
    var jobs_ContractsByPolicy_grid1537 = new Lino.jobs.ContractsByPolicy.GridPanel({ "flex": 41, "hide_top_toolbar": true, "containing_panel": this, "params_panel_hidden": true, "master_panel": this, "preview_limit": 15, "listeners": { "render": Lino.quicktip_renderer("Art.60\u00a77-Konventionen","(jobs.jobs.ContractsByPolicy) ") }, "tools": [ Lino.show_in_own_window_button(Lino.jobs.ContractsByPolicy.grid) ] });
    var main_panel1538 = new Ext.Panel({ "autoScroll": false, "border": false, "layout": "vbox", "hideCheckBoxLabels": true, "items": [ main_1_panel1389, main_2_panel1399, isip_ContractsByPolicy_grid1424, jobs_ContractsByPolicy_grid1537 ], "frame": true, "layoutConfig": { "align": "stretch" }, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel1538;
    this.before_row_edit = function(record) {
      isip_ContractsByPolicy_grid1424.on_master_changed();
      jobs_ContractsByPolicy_grid1537.on_master_changed();
    }
    Lino.isip.ExamPolicies.DetailFormPanel.superclass.initComponent.call(this);
  }
});

Lino.contacts.Companies.merge_row = new Lino.WindowAction({ "draggable": true, "width": Lino.chars2width(50), "autoHeight": true, "maximizable": true, "modal": true, "maximized": false },function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.contacts.Companies.merge_row_ActionFormPanel({});
});
Lino.cal.GuestStates.wf1 = new Lino.WindowAction({ "draggable": true, "width": Lino.chars2width(50), "maximizable": true, "modal": true, "maximized": false, "height": Lino.rows2height(15) },function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.cal.MyPresences.wf1_ActionFormPanel({});
});
Lino.cal.GuestStates.wf2 = new Lino.WindowAction({ "draggable": true, "width": Lino.chars2width(50), "maximizable": true, "modal": true, "maximized": false, "height": Lino.rows2height(15) },function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.cal.MyPresences.wf2_ActionFormPanel({});
});
Lino.cal.Guests.checkin = new Lino.WindowAction({ "draggable": true, "width": Lino.chars2width(50), "maximizable": true, "modal": true, "maximized": false, "height": Lino.rows2height(15) },function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.cal.MyPresences.checkin_ActionFormPanel({});
});
Lino.pcsw.ClientStates.wf1 = new Lino.WindowAction({ "draggable": true, "width": Lino.chars2width(50), "maximizable": true, "modal": true, "maximized": false, "height": Lino.rows2height(15) },function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.pcsw.Clients.wf1_ActionFormPanel({});
});
Lino.pcsw.Clients.merge_row = new Lino.WindowAction({ "draggable": true, "width": Lino.chars2width(70), "autoHeight": true, "maximizable": true, "modal": true, "maximized": false },function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.pcsw.Clients.merge_row_ActionFormPanel({});
});
Lino.pcsw.Coachings.create_visit = new Lino.WindowAction({ "draggable": true, "width": Lino.chars2width(50), "autoHeight": true, "maximizable": true, "modal": true, "maximized": false },function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.pcsw.CoachingsByClient.create_visit_ActionFormPanel({});
});

// js_render_GridPanel_class users.MySettings
Lino.users.MySettings.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "Keine Daten anzuzeigen." },
  ls_url : "/users/MySettings",
  ls_bbar_actions : [ { "itemId": "put", "menu_item_text": "Speichern", "tooltip": "\u00c4nderungen in diesem Formular speichern", "panel_btn_handler": function(panel){panel.save(null,false,'put')}, "iconCls": "x-tbar-save", "overflowText": "Speichern", "auto_save": false }, { "itemId": "update_reminders", "menu_item_text": "Erinnerungen aktualisieren", "must_save": true, "panel_btn_handler": Lino.row_action_handler('update_reminders','GET',null), "text": "Erinnerungen aktualisieren", "overflowText": "Erinnerungen aktualisieren", "auto_save": true } ],
  cell_edit : true,
  title : "Benutzer",
  page_length : 20,
  stripeRows : true,
  disabled_actions_index : 25,
  ls_store_fields : [ { "name": "username" }, { "name": "profile" }, 'profileHidden', { "name": "first_name" }, { "name": "last_name" }, { "type": "int", "name": "id" }, { "name": "created" }, { "name": "modified" }, { "name": "password" }, { "name": "initials" }, { "name": "email" }, { "name": "remarks" }, { "name": "language" }, 'languageHidden', { "name": "partner" }, 'partnerHidden', { "name": "access_class" }, 'access_classHidden', { "name": "calendar" }, 'calendarHidden', { "name": "coaching_type" }, 'coaching_typeHidden', { "type": "boolean", "name": "coaching_supervisor" }, { "type": "int", "name": "newcomer_quota" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 5,
  ls_grid_configs : [  ],
  content_type : 7,
  ls_id_property : "id",
  gc_name : 0,
  initComponent : function() {
    this.ls_detail_handler = Lino.users.MySettings.detail;
    this.ls_insert_handler = Lino.users.Users.insert;
    var ww = this.containing_window;
    var username3066 = new Ext.form.TextField({ "selectOnFocus": true, "allowBlank": false, "maxLength": 30 });
    var profile3067 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "forceSelection": true, "store": [['','<br>']].concat(Lino.lino.UserProfiles) });
    var first_name3068 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 30 });
    var last_name3069 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 30 });
    var id3070 = new Ext.form.NumberField({ "selectOnFocus": true });
    var created3071 = new Ext.form.DisplayField({ "disabled": true, "value": "<br>" });
    var modified3072 = new Ext.form.DisplayField({ "disabled": true, "value": "<br>" });
    var password3073 = new Ext.form.TextField({ "selectOnFocus": true, "allowBlank": false, "maxLength": 128 });
    var initials3074 = new Ext.form.TextField({ "selectOnFocus": true, "boxMinWidth": Lino.chars2width(10), "maxLength": 10 });
    var email3075 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 75 });
    var remarks3076 = new Ext.form.TextArea({ "selectOnFocus": true, "growMax": 2000 });
    var language3077 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "store": [ [ "en", "Englisch" ], [ "fr", "Franz\u00f6sisch" ], [ "de", "Deutsch" ], [ "nl", "Niederl\u00e4ndisch" ] ] });
    var partner3078 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "preferred_width": 20, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/users/MySettings/partner", "method": "GET" }) }), "pageSize": 20, "emptyText": "Partner ausw\u00e4hlen..." });
    var access_class3079 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "forceSelection": true, "allowBlank": false, "store": Lino.cal.AccessClasses });
    var calendar3080 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/users/MySettings/calendar", "method": "GET" }) }), "pageSize": 20, "emptyText": "Kalender ausw\u00e4hlen..." });
    var coaching_type3081 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/users/MySettings/coaching_type", "method": "GET" }) }), "pageSize": 20, "emptyText": "Dienst ausw\u00e4hlen..." });
    var coaching_supervisor3082 = new Ext.form.Checkbox({ "selectOnFocus": true, "checked": false });
    var newcomer_quota3083 = new Ext.form.NumberField({ "selectOnFocus": true, "allowBlank": false, "value": 0 });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ { "colIndex": 0, "sortable": true, "header": "Benutzername", "editable": true, "tooltip": "(users.MySettings.username) Required. Must be unique.", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "username", "editor": username3066 }, { "colIndex": 1, "sortable": true, "header": "Benutzerprofil", "editable": true, "tooltip": "(users.MySettings.profile) Users with an empty `profile` field are considered inactive and cannot log in.", "filter": { "type": "string" }, "width": Lino.chars2width(37), "dataIndex": "profile", "editor": profile3067 }, { "colIndex": 2, "sortable": true, "header": "Vorname", "editable": true, "tooltip": "(users.MySettings.first_name) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "first_name", "editor": first_name3068 }, { "colIndex": 3, "sortable": true, "header": "Familienname", "editable": true, "tooltip": "(users.MySettings.last_name) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "last_name", "editor": last_name3069 }, new Lino.NullNumberColumn({ "colIndex": 4, "sortable": true, "format": "0", "editable": true, "tooltip": "(users.MySettings.id) ", "filter": { "type": "numeric" }, "header": "ID", "renderer": Lino.id_renderer, "editor": id3070, "width": Lino.chars2width(6), "dataIndex": "id" }), { "width": Lino.chars2width(17), "colIndex": 5, "sortable": true, "dataIndex": "created", "header": "Erstellt", "editable": false, "tooltip": "(users.MySettings.created) " }, { "width": Lino.chars2width(17), "colIndex": 6, "sortable": true, "dataIndex": "modified", "header": "Bearbeitet", "editable": false, "tooltip": "(users.MySettings.modified) " }, { "colIndex": 7, "sortable": true, "header": "Passwort", "editable": true, "tooltip": "(users.MySettings.password) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "password", "hidden": true, "editor": password3073 }, { "colIndex": 8, "sortable": true, "header": "Initials", "editable": true, "tooltip": "(users.MySettings.initials) ", "filter": { "type": "string" }, "width": Lino.chars2width(12), "dataIndex": "initials", "editor": initials3074 }, { "colIndex": 9, "sortable": true, "header": "e-mail address", "editable": true, "tooltip": "(users.MySettings.email) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "email", "editor": email3075 }, { "colIndex": 10, "sortable": false, "width": Lino.chars2width(61), "editable": true, "tooltip": "(users.MySettings.remarks) ", "filter": { "type": "string" }, "header": "Bemerkungen", "renderer": Lino.text_renderer, "hidden": true, "editor": remarks3076, "dataIndex": "remarks" }, { "colIndex": 11, "sortable": true, "header": "Sprache", "editable": true, "tooltip": "(users.MySettings.language) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "language", "editor": language3077 }, { "colIndex": 12, "sortable": true, "header": "Partner", "editable": true, "tooltip": "(users.MySettings.partner) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('partnerHidden','Lino.contacts.Partners.detail'), "editor": partner3078, "dataIndex": "partner" }, { "colIndex": 13, "sortable": true, "header": "Standardm\u00e4\u00dfige Zugriffsklasse", "editable": true, "tooltip": "(users.MySettings.access_class) Die standardm\u00e4\u00dfige Zugriffsklasse f\u00fcr Ihre Termine und Aufgaben", "filter": { "type": "string" }, "width": Lino.chars2width(13), "dataIndex": "access_class", "editor": access_class3079 }, { "colIndex": 14, "sortable": true, "header": "Standard-Kalender", "editable": true, "tooltip": "(users.MySettings.calendar) The default calendar for your events and tasks.", "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('calendarHidden','Lino.cal.Calendars.detail'), "editor": calendar3080, "dataIndex": "calendar" }, { "colIndex": 15, "sortable": true, "header": "Dienst", "editable": true, "tooltip": "(users.MySettings.coaching_type) The default CoachingType used when creating Coachings.", "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "coaching_type", "editor": coaching_type3081 }, { "colIndex": 16, "sortable": false, "xtype": "checkcolumn", "header": "Benachrichtigung wenn ein Begleiter zugewiesen wird", "editable": true, "tooltip": "(users.MySettings.coaching_supervisor) Wenn ein Neuantrag einem Begleiter zugewiesen wurde, wird au\u00dfer dem Begleiter auch dieser Benutzer benachrichtigt.", "filter": { "type": "boolean" }, "width": Lino.chars2width(11), "dataIndex": "coaching_supervisor" }, new Lino.NullNumberColumn({ "colIndex": 17, "sortable": true, "format": "0", "editable": true, "tooltip": "(users.MySettings.newcomer_quota) Wieviel Arbeitszeit dieser Benutzer f\u00fcr Neuantr\u00e4ge zur Verf\u00fcgung steht\n(100 = ganztags, 50 = halbtags, 0 = gar nicht).\nWenn zwei Benutzer die gleiche Belastungspunktzahl haben, \naber einer davon sich nur zu 50% um Neuantr\u00e4ge k\u00fcmmert, \ngilt er als doppelt so belastet wie sein Kollege.\n", "filter": { "type": "numeric" }, "header": "Quote NZ", "dataIndex": "newcomer_quota", "width": Lino.chars2width(6), "editor": newcomer_quota3083 }) ];
    Lino.users.MySettings.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.users.MySettings.put = function(rp,pk) { 
  Lino.run_row_action(rp,"/users/MySettings","GET",pk,"put",null);
};
Lino.users.MySettings.post = function(rp,pk) { 
  Lino.run_row_action(rp,"/users/MySettings","GET",pk,"post",null);
};

Lino.users.MySettings.detailPanel = Ext.extend(Lino.users.MySettings.DetailFormPanel,{
  empty_title: "Benutzer",
  ls_bbar_actions: [ { "itemId": "put", "menu_item_text": "Speichern", "tooltip": "\u00c4nderungen in diesem Formular speichern", "panel_btn_handler": function(panel){panel.save(null,false,'put')}, "iconCls": "x-tbar-save", "overflowText": "Speichern", "auto_save": false }, { "itemId": "update_reminders", "menu_item_text": "Erinnerungen aktualisieren", "must_save": true, "panel_btn_handler": Lino.row_action_handler('update_reminders','GET',null), "text": "Erinnerungen aktualisieren", "overflowText": "Erinnerungen aktualisieren", "auto_save": true } ],
  ls_url: "/users/MySettings",
  initComponent : function() {
    this.ls_detail_handler = Lino.users.MySettings.detail;
    this.ls_insert_handler = Lino.users.Users.insert;
    Lino.users.MySettings.detailPanel.superclass.initComponent.call(this);
  }
});

Lino.users.MySettings.detail = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.users.MySettings.detailPanel(p);
});

Lino.users.MySettings.detailPanel = Ext.extend(Lino.users.MySettings.DetailFormPanel,{
  empty_title: "Benutzer",
  ls_bbar_actions: [ { "itemId": "put", "menu_item_text": "Speichern", "tooltip": "\u00c4nderungen in diesem Formular speichern", "panel_btn_handler": function(panel){panel.save(null,false,'put')}, "iconCls": "x-tbar-save", "overflowText": "Speichern", "auto_save": false }, { "itemId": "update_reminders", "menu_item_text": "Erinnerungen aktualisieren", "must_save": true, "panel_btn_handler": Lino.row_action_handler('update_reminders','GET',null), "text": "Erinnerungen aktualisieren", "overflowText": "Erinnerungen aktualisieren", "auto_save": true } ],
  ls_url: "/users/MySettings",
  initComponent : function() {
    this.ls_detail_handler = Lino.users.MySettings.detail;
    this.ls_insert_handler = Lino.users.Users.insert;
    Lino.users.MySettings.detailPanel.superclass.initComponent.call(this);
  }
});

Lino.users.MySettings.detail = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.users.MySettings.detailPanel(p);
});
Lino.users.MySettings.update_reminders = function(rp,pk) { 
  Lino.run_row_action(rp,"/users/MySettings","GET",pk,"update_reminders",null);
};

// js_render_GridPanel_class countries.Countries
Lino.countries.Countries.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "Keine Daten anzuzeigen." },
  ls_url : "/countries/Countries",
  ls_bbar_actions : [ { "itemId": "insert", "menu_item_text": "Neu", "must_save": true, "tooltip": "Neuen Datensatz erstellen", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-new", "overflowText": "Neu", "auto_save": true }, { "itemId": "detail", "menu_item_text": "Detail", "tooltip": "Detail-Fenster auf diesem Datensatz \u00f6ffnen", "panel_btn_handler": Lino.show_detail, "iconCls": "x-tbar-detail", "overflowText": "Detail", "auto_save": true }, { "itemId": null, "menu_item_text": "L\u00f6schen", "tooltip": "Diesen Datensatz l\u00f6schen", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "L\u00f6schen", "auto_save": false } ],
  cell_edit : true,
  title : "L\u00e4nder",
  page_length : 20,
  stripeRows : true,
  disabled_actions_index : 9,
  ls_store_fields : [ { "name": "name" }, { "name": "name_fr" }, { "name": "name_de" }, { "name": "name_nl" }, { "name": "isocode" }, { "name": "short_code" }, { "name": "iso3" }, { "name": "inscode" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 4,
  ls_grid_configs : [  ],
  content_type : 11,
  ls_id_property : "isocode",
  gc_name : 0,
  initComponent : function() {
    this.ls_detail_handler = Lino.countries.Countries.detail;
    this.ls_insert_handler = Lino.countries.Countries.insert;
    var ww = this.containing_window;
    var name3085 = new Ext.form.TextField({ "selectOnFocus": true, "allowBlank": false, "maxLength": 200 });
    var name_fr3086 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var name_de3087 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var name_nl3088 = new Ext.form.TextField({ "selectOnFocus": true, "hidden": true, "maxLength": 200 });
    var isocode3089 = new Ext.form.TextField({ "selectOnFocus": true, "boxMinWidth": Lino.chars2width(4), "allowBlank": false, "maxLength": 4 });
    var short_code3090 = new Ext.form.TextField({ "selectOnFocus": true, "boxMinWidth": Lino.chars2width(4), "maxLength": 4 });
    var iso33091 = new Ext.form.TextField({ "selectOnFocus": true, "boxMinWidth": Lino.chars2width(3), "maxLength": 3 });
    var inscode3092 = new Ext.form.TextField({ "selectOnFocus": true, "boxMinWidth": Lino.chars2width(3), "maxLength": 3 });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ { "colIndex": 0, "sortable": true, "header": "Bezeichnung", "editable": true, "tooltip": "(countries.Countries.name) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "name", "editor": name3085 }, { "colIndex": 1, "sortable": true, "header": "Bezeichnung (fr)", "editable": true, "tooltip": "(countries.Countries.name_fr) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "name_fr", "editor": name_fr3086 }, { "colIndex": 2, "sortable": true, "header": "Bezeichnung (de)", "editable": true, "tooltip": "(countries.Countries.name_de) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "name_de", "editor": name_de3087 }, { "colIndex": 3, "sortable": true, "header": "Bezeichnung (nl)", "editable": true, "tooltip": "(countries.Countries.name_nl) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "name_nl", "hidden": true, "editor": name_nl3088 }, { "colIndex": 4, "sortable": true, "header": "ISO-Code", "editable": true, "tooltip": "(countries.Countries.isocode)         The two-letter code for this country as defined by ISO 3166-1. \n        For countries that no longer exist it may be a 4-letter code.", "filter": { "type": "string" }, "width": Lino.chars2width(6), "dataIndex": "isocode", "editor": isocode3089 }, { "colIndex": 5, "sortable": true, "header": "Short code", "editable": true, "tooltip": "(countries.Countries.short_code) A short abbreviation for regional usage. Obsolete.", "filter": { "type": "string" }, "width": Lino.chars2width(6), "dataIndex": "short_code", "editor": short_code3090 }, { "colIndex": 6, "sortable": true, "header": "ISO3-Code", "editable": true, "tooltip": "(countries.Countries.iso3) The three-letter code for this country as defined by ISO 3166-1.", "filter": { "type": "string" }, "width": Lino.chars2width(5), "dataIndex": "iso3", "editor": iso33091 }, { "colIndex": 7, "sortable": true, "header": "INS-Code", "editable": true, "tooltip": "(countries.Countries.inscode) The official code for this country used by statbel.fgov.be", "filter": { "type": "string" }, "width": Lino.chars2width(5), "dataIndex": "inscode", "editor": inscode3092 } ];
    Lino.countries.Countries.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.countries.Countries.put = function(rp,pk) { 
  Lino.run_row_action(rp,"/countries/Countries","GET",pk,"put",null);
};
Lino.countries.Countries.post = function(rp,pk) { 
  Lino.run_row_action(rp,"/countries/Countries","GET",pk,"post",null);
};

Lino.countries.Countries.insertPanel = Ext.extend(Lino.countries.Countries.DetailFormPanel,{
  empty_title: "Neu L\u00e4nder",
  hide_navigator: true,
  ls_bbar_actions: [ { "itemId": "post", "menu_item_text": "Erstellen", "tooltip": "Datensatz erstellen und dann im Detail-Fenster \u00f6ffnen", "panel_btn_handler": function(panel){panel.save(null,true,'post')}, "text": "Erstellen", "overflowText": "Erstellen", "auto_save": false }, { "itemId": "poststay", "menu_item_text": "Erstellen ohne Detail", "tooltip": "Nach Erstellen des Datensatzes kein Detail-Fenster \u00f6ffnen", "panel_btn_handler": function(panel){panel.save(null,false,'poststay')}, "text": "Erstellen ohne Detail", "overflowText": "Erstellen ohne Detail", "auto_save": false } ],
  ls_url: "/countries/Countries",
  action_name: "insert",
  initComponent : function() {
    this.ls_detail_handler = Lino.countries.Countries.detail;
    this.ls_insert_handler = Lino.countries.Countries.insert;
    Lino.countries.Countries.insertPanel.superclass.initComponent.call(this);
  }
});

Lino.countries.Countries.insert = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.countries.Countries.insertPanel(p);
});
Lino.countries.Countries.poststay = function(rp,pk) { 
  Lino.run_row_action(rp,"/countries/Countries","GET",pk,"poststay",null);
};

Lino.countries.Countries.detailPanel = Ext.extend(Lino.countries.Countries.DetailFormPanel,{
  empty_title: "Detail L\u00e4nder",
  ls_bbar_actions: [ { "itemId": "put", "menu_item_text": "Speichern", "tooltip": "\u00c4nderungen in diesem Formular speichern", "panel_btn_handler": function(panel){panel.save(null,false,'put')}, "iconCls": "x-tbar-save", "overflowText": "Speichern", "auto_save": false }, { "itemId": "insert", "menu_item_text": "Neu", "must_save": true, "tooltip": "Neuen Datensatz erstellen", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-new", "overflowText": "Neu", "auto_save": true }, { "itemId": null, "menu_item_text": "L\u00f6schen", "tooltip": "Diesen Datensatz l\u00f6schen", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "L\u00f6schen", "auto_save": false } ],
  ls_url: "/countries/Countries",
  action_name: "detail",
  initComponent : function() {
    this.ls_detail_handler = Lino.countries.Countries.detail;
    this.ls_insert_handler = Lino.countries.Countries.insert;
    Lino.countries.Countries.detailPanel.superclass.initComponent.call(this);
  }
});

Lino.countries.Countries.detail = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.countries.Countries.detailPanel(p);
});
Lino.countries.Countries.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.countries.Countries.GridPanel(p);
});

// js_render_GridPanel_class properties.PropChoices
Lino.properties.PropChoices.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "Keine Daten anzuzeigen." },
  ls_url : "/properties/PropChoices",
  ls_bbar_actions : [ { "itemId": null, "menu_item_text": "L\u00f6schen", "tooltip": "Diesen Datensatz l\u00f6schen", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "L\u00f6schen", "auto_save": false } ],
  cell_edit : true,
  title : "Auswahlm\u00f6glichkeiten",
  page_length : 20,
  stripeRows : true,
  disabled_actions_index : 9,
  ls_store_fields : [ { "type": "int", "name": "id" }, { "name": "type" }, 'typeHidden', { "name": "value" }, { "name": "text" }, { "name": "text_fr" }, { "name": "text_de" }, { "name": "text_nl" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 0,
  ls_grid_configs : [  ],
  content_type : 16,
  ls_id_property : "id",
  gc_name : 0,
  initComponent : function() {
    var ww = this.containing_window;
    var id3094 = new Ext.form.NumberField({ "selectOnFocus": true });
    var type3095 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/properties/PropChoices/type", "method": "GET" }) }), "allowBlank": false, "pageSize": 20, "emptyText": "Eigenschafts-Datentyp ausw\u00e4hlen..." });
    var value3096 = new Ext.form.TextField({ "selectOnFocus": true, "allowBlank": false, "maxLength": 200 });
    var text3097 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var text_fr3098 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var text_de3099 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var text_nl3100 = new Ext.form.TextField({ "selectOnFocus": true, "hidden": true, "maxLength": 200 });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ new Lino.NullNumberColumn({ "colIndex": 0, "sortable": true, "format": "0", "editable": true, "tooltip": "(properties.PropChoices.id) ", "filter": { "type": "numeric" }, "header": "ID", "renderer": Lino.id_renderer, "editor": id3094, "width": Lino.chars2width(6), "dataIndex": "id" }), { "colIndex": 1, "sortable": true, "header": "Eigenschafts-Datentyp", "editable": true, "tooltip": "(properties.PropChoices.type) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "type", "editor": type3095 }, { "colIndex": 2, "sortable": true, "header": "Wert", "editable": true, "tooltip": "(properties.PropChoices.value) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "value", "editor": value3096 }, { "colIndex": 3, "sortable": true, "header": "Bezeichnung", "editable": true, "tooltip": "(properties.PropChoices.text) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "text", "editor": text3097 }, { "colIndex": 4, "sortable": true, "header": "Bezeichnung (fr)", "editable": true, "tooltip": "(properties.PropChoices.text_fr) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "text_fr", "editor": text_fr3098 }, { "colIndex": 5, "sortable": true, "header": "Bezeichnung (de)", "editable": true, "tooltip": "(properties.PropChoices.text_de) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "text_de", "editor": text_de3099 }, { "colIndex": 6, "sortable": true, "header": "Bezeichnung (nl)", "editable": true, "tooltip": "(properties.PropChoices.text_nl) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "text_nl", "hidden": true, "editor": text_nl3100 } ];
    Lino.properties.PropChoices.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.properties.PropChoices.put = function(rp,pk) { 
  Lino.run_row_action(rp,"/properties/PropChoices","GET",pk,"put",null);
};
Lino.properties.PropChoices.post = function(rp,pk) { 
  Lino.run_row_action(rp,"/properties/PropChoices","GET",pk,"post",null);
};
Lino.properties.PropChoices.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.properties.PropChoices.GridPanel(p);
});

// js_render_GridPanel_class contacts.Partners
Lino.contacts.Partners.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "Keine Daten anzuzeigen." },
  ls_url : "/contacts/Partners",
  ls_bbar_actions : [ { "itemId": "insert", "menu_item_text": "Neu", "must_save": true, "tooltip": "Neuen Datensatz erstellen", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-new", "overflowText": "Neu", "auto_save": true }, { "itemId": "detail", "menu_item_text": "Detail", "tooltip": "Detail-Fenster auf diesem Datensatz \u00f6ffnen", "panel_btn_handler": Lino.show_detail, "iconCls": "x-tbar-detail", "overflowText": "Detail", "auto_save": true }, { "itemId": null, "menu_item_text": "L\u00f6schen", "tooltip": "Diesen Datensatz l\u00f6schen", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "L\u00f6schen", "auto_save": false } ],
  cell_edit : true,
  title : "Partner",
  page_length : 20,
  stripeRows : true,
  disabled_actions_index : 31,
  ls_store_fields : [ { "name": "name" }, { "name": "email" }, { "name": "created" }, { "name": "modified" }, { "name": "country" }, 'countryHidden', { "name": "city" }, 'cityHidden', { "name": "region" }, 'regionHidden', { "name": "zip_code" }, { "name": "addr1" }, { "name": "street_prefix" }, { "name": "street" }, { "name": "street_no" }, { "name": "street_box" }, { "name": "addr2" }, { "name": "language" }, 'languageHidden', { "name": "url" }, { "name": "phone" }, { "name": "gsm" }, { "name": "fax" }, { "name": "remarks" }, { "type": "boolean", "name": "is_obsolete" }, { "name": "activity" }, 'activityHidden', { "name": "bank_account1" }, { "name": "bank_account2" }, { "type": "int", "name": "id" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 29,
  ls_grid_configs : [  ],
  content_type : 22,
  ls_id_property : "id",
  gc_name : 0,
  initComponent : function() {
    this.ls_detail_handler = Lino.contacts.Partners.detail;
    this.ls_insert_handler = Lino.contacts.Partners.insert;
    var ww = this.containing_window;
    var name3102 = new Ext.form.TextField({ "selectOnFocus": true, "allowBlank": false, "maxLength": 200 });
    var email3103 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 75 });
    var created3104 = new Ext.form.DisplayField({ "disabled": true, "value": "<br>" });
    var modified3105 = new Ext.form.DisplayField({ "disabled": true, "value": "<br>" });
    var country3106 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/contacts/Partners/country", "method": "GET" }) }), "pageSize": 20, "emptyText": "Land ausw\u00e4hlen..." });
    var city3107 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "forceSelection": false, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/contacts/Partners/city", "method": "GET" }) }), "pageSize": 20, "emptyText": "Ort ausw\u00e4hlen..." });
    var region3108 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/contacts/Partners/region", "method": "GET" }) }), "pageSize": 20, "emptyText": "Ort ausw\u00e4hlen..." });
    var zip_code3109 = new Ext.form.TextField({ "selectOnFocus": true, "boxMinWidth": Lino.chars2width(10), "maxLength": 10 });
    var addr13110 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var street_prefix3111 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var street3112 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var street_no3113 = new Ext.form.TextField({ "selectOnFocus": true, "boxMinWidth": Lino.chars2width(10), "maxLength": 10 });
    var street_box3114 = new Ext.form.TextField({ "selectOnFocus": true, "boxMinWidth": Lino.chars2width(10), "maxLength": 10 });
    var addr23115 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var language3116 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "allowBlank": false, "store": [ [ "en", "Englisch" ], [ "fr", "Franz\u00f6sisch" ], [ "de", "Deutsch" ], [ "nl", "Niederl\u00e4ndisch" ] ] });
    var url3117 = new Lino.URLField({ "selectOnFocus": true, "maxLength": 200 });
    var phone3118 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var gsm3119 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var fax3120 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var remarks3121 = new Ext.form.TextArea({ "selectOnFocus": true, "growMax": 2000 });
    var is_obsolete3122 = new Ext.form.Checkbox({ "selectOnFocus": true, "checked": false });
    var activity3123 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/contacts/Partners/activity", "method": "GET" }) }), "pageSize": 20, "emptyText": "Beruf ausw\u00e4hlen..." });
    var bank_account13124 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 40 });
    var bank_account23125 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 40 });
    var id3126 = new Ext.form.NumberField({ "selectOnFocus": true });
    this.before_row_edit = function(record) {
      city3107.setContextValue('country',record ? record.data['countryHidden'] : undefined);
      city3107.setContextValue('region',record ? record.data['regionHidden'] : undefined);
      region3108.setContextValue('country',record ? record.data['countryHidden'] : undefined);
    };
    this.onRender = function(ct, position) {
      country3106.on('change',Lino.chooser_handler(city3107,'country'));
      region3108.on('change',Lino.chooser_handler(city3107,'region'));
      country3106.on('change',Lino.chooser_handler(region3108,'country'));
      Lino.contacts.Partners.GridPanel.superclass.onRender.call(this, ct, position);
    }
    this.ls_columns = [ { "colIndex": 0, "sortable": true, "header": "Name", "editable": true, "tooltip": "(contacts.Partners.name) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "name", "editor": name3102 }, { "colIndex": 1, "sortable": true, "header": "E-Mail", "editable": true, "tooltip": "(contacts.Partners.email) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "email", "editor": email3103 }, { "colIndex": 2, "sortable": true, "header": "Erstellt", "editable": false, "tooltip": "(contacts.Partners.created) ", "width": Lino.chars2width(17), "dataIndex": "created", "hidden": true }, { "colIndex": 3, "sortable": true, "header": "Bearbeitet", "editable": false, "tooltip": "(contacts.Partners.modified) ", "width": Lino.chars2width(17), "dataIndex": "modified", "hidden": true }, { "colIndex": 4, "sortable": true, "header": "Land", "editable": true, "tooltip": "(contacts.Partners.country) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('countryHidden','Lino.countries.Countries.detail'), "editor": country3106, "dataIndex": "country" }, { "colIndex": 5, "sortable": true, "header": "Ort", "editable": true, "tooltip": "(contacts.Partners.city) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "city", "editor": city3107 }, { "colIndex": 6, "sortable": true, "header": "Region", "editable": true, "tooltip": "(contacts.Partners.region) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "region", "editor": region3108 }, { "colIndex": 7, "sortable": true, "header": "Postleitzahl", "editable": true, "tooltip": "(contacts.Partners.zip_code) ", "filter": { "type": "string" }, "width": Lino.chars2width(12), "dataIndex": "zip_code", "editor": zip_code3109 }, { "colIndex": 8, "sortable": true, "header": "Adresszeile vor Stra\u00dfe", "editable": true, "tooltip": "(contacts.Partners.addr1) Address line before street", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "addr1", "editor": addr13110 }, { "colIndex": 9, "sortable": true, "header": "Pr\u00e4fix Stra\u00dfe", "editable": true, "tooltip": "(contacts.Partners.street_prefix) Text to print before name of street, but to ignore for sorting.", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "street_prefix", "editor": street_prefix3111 }, { "colIndex": 10, "sortable": true, "header": "Stra\u00dfe", "editable": true, "tooltip": "(contacts.Partners.street) Name of street. Without house number.", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "street", "editor": street3112 }, { "colIndex": 11, "sortable": true, "header": "Nr.", "editable": true, "tooltip": "(contacts.Partners.street_no) House number", "filter": { "type": "string" }, "width": Lino.chars2width(12), "dataIndex": "street_no", "editor": street_no3113 }, { "colIndex": 12, "sortable": true, "header": "Box", "editable": true, "tooltip": "(contacts.Partners.street_box) Text to print after :attr:`steet_no` on the same line", "filter": { "type": "string" }, "width": Lino.chars2width(12), "dataIndex": "street_box", "editor": street_box3114 }, { "colIndex": 13, "sortable": true, "header": "Adresszeile nach Stra\u00dfe", "editable": true, "tooltip": "(contacts.Partners.addr2) Address line to print below street line", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "addr2", "editor": addr23115 }, { "colIndex": 14, "sortable": true, "header": "Sprache", "editable": true, "tooltip": "(contacts.Partners.language) Die Sprache, in der Dokumente ausgestellt werden sollen.", "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "language", "editor": language3116 }, { "colIndex": 15, "sortable": true, "header": "URL", "editable": true, "tooltip": "(contacts.Partners.url) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "url", "editor": url3117 }, { "colIndex": 16, "sortable": true, "header": "Telefon", "editable": true, "tooltip": "(contacts.Partners.phone) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "phone", "editor": phone3118 }, { "colIndex": 17, "sortable": true, "header": "GSM", "editable": true, "tooltip": "(contacts.Partners.gsm) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "gsm", "editor": gsm3119 }, { "colIndex": 18, "sortable": true, "header": "Fax", "editable": true, "tooltip": "(contacts.Partners.fax) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "fax", "editor": fax3120 }, { "colIndex": 19, "sortable": false, "header": "Bemerkungen", "editable": true, "tooltip": "(contacts.Partners.remarks) ", "filter": { "type": "string" }, "width": Lino.chars2width(61), "renderer": Lino.text_renderer, "editor": remarks3121, "dataIndex": "remarks" }, { "colIndex": 20, "sortable": false, "xtype": "checkcolumn", "header": "veraltet", "editable": true, "tooltip": "(contacts.Partners.is_obsolete) Altf\u00e4lle sind Partner, deren Stammdaten nicht mehr gepflegt werden und \nf\u00fcr neue Operationen nicht benutzt werden k\u00f6nnen.", "filter": { "type": "boolean" }, "width": Lino.chars2width(11), "dataIndex": "is_obsolete" }, { "colIndex": 21, "sortable": true, "header": "Beruf", "editable": true, "tooltip": "(contacts.Partners.activity) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "activity", "hidden": true, "editor": activity3123 }, { "colIndex": 22, "sortable": true, "header": "Bankkonto 1", "editable": true, "tooltip": "(contacts.Partners.bank_account1) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "bank_account1", "hidden": true, "editor": bank_account13124 }, { "colIndex": 23, "sortable": true, "header": "Bankkonto 2", "editable": true, "tooltip": "(contacts.Partners.bank_account2) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "bank_account2", "hidden": true, "editor": bank_account23125 }, new Lino.NullNumberColumn({ "colIndex": 24, "sortable": true, "format": "0", "editable": true, "tooltip": "(contacts.Partners.id) ", "filter": { "type": "numeric" }, "header": "ID", "renderer": Lino.id_renderer, "editor": id3126, "width": Lino.chars2width(6), "dataIndex": "id" }) ];
    Lino.contacts.Partners.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.contacts.Partners.put = function(rp,pk) { 
  Lino.run_row_action(rp,"/contacts/Partners","GET",pk,"put",null);
};
Lino.contacts.Partners.post = function(rp,pk) { 
  Lino.run_row_action(rp,"/contacts/Partners","GET",pk,"post",null);
};

Lino.contacts.Partners.insertPanel = Ext.extend(Lino.contacts.Partners.InsertFormPanel,{
  empty_title: "Neu Partner",
  hide_navigator: true,
  ls_bbar_actions: [ { "itemId": "post", "menu_item_text": "Erstellen", "tooltip": "Datensatz erstellen und dann im Detail-Fenster \u00f6ffnen", "panel_btn_handler": function(panel){panel.save(null,true,'post')}, "text": "Erstellen", "overflowText": "Erstellen", "auto_save": false }, { "itemId": "poststay", "menu_item_text": "Erstellen ohne Detail", "tooltip": "Nach Erstellen des Datensatzes kein Detail-Fenster \u00f6ffnen", "panel_btn_handler": function(panel){panel.save(null,false,'poststay')}, "text": "Erstellen ohne Detail", "overflowText": "Erstellen ohne Detail", "auto_save": false } ],
  ls_url: "/contacts/Partners",
  action_name: "insert",
  initComponent : function() {
    this.ls_detail_handler = Lino.contacts.Partners.detail;
    this.ls_insert_handler = Lino.contacts.Partners.insert;
    Lino.contacts.Partners.insertPanel.superclass.initComponent.call(this);
  }
});

Lino.contacts.Partners.insert = new Lino.WindowAction({ "draggable": true, "width": Lino.chars2width(40), "autoHeight": true, "maximizable": true, "modal": true, "maximized": false },function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.contacts.Partners.insertPanel(p);
});
Lino.contacts.Partners.poststay = function(rp,pk) { 
  Lino.run_row_action(rp,"/contacts/Partners","GET",pk,"poststay",null);
};

Lino.contacts.Partners.detailPanel = Ext.extend(Lino.contacts.Partners.DetailFormPanel,{
  empty_title: "Detail Partner",
  ls_bbar_actions: [ { "itemId": "put", "menu_item_text": "Speichern", "tooltip": "\u00c4nderungen in diesem Formular speichern", "panel_btn_handler": function(panel){panel.save(null,false,'put')}, "iconCls": "x-tbar-save", "overflowText": "Speichern", "auto_save": false }, { "itemId": "insert", "menu_item_text": "Neu", "must_save": true, "tooltip": "Neuen Datensatz erstellen", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-new", "overflowText": "Neu", "auto_save": true }, { "itemId": null, "menu_item_text": "L\u00f6schen", "tooltip": "Diesen Datensatz l\u00f6schen", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "L\u00f6schen", "auto_save": false } ],
  ls_url: "/contacts/Partners",
  action_name: "detail",
  initComponent : function() {
    this.ls_detail_handler = Lino.contacts.Partners.detail;
    this.ls_insert_handler = Lino.contacts.Partners.insert;
    Lino.contacts.Partners.detailPanel.superclass.initComponent.call(this);
  }
});

Lino.contacts.Partners.detail = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.contacts.Partners.detailPanel(p);
});
Lino.contacts.Partners.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.contacts.Partners.GridPanel(p);
});

// js_render_GridPanel_class contacts.Companies
Lino.contacts.Companies.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "Keine Daten anzuzeigen." },
  ls_url : "/contacts/Companies",
  ls_bbar_actions : [ { "itemId": "insert", "menu_item_text": "Neu", "must_save": true, "tooltip": "Neuen Datensatz erstellen", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-new", "overflowText": "Neu", "auto_save": true }, { "itemId": "detail", "menu_item_text": "Detail", "tooltip": "Detail-Fenster auf diesem Datensatz \u00f6ffnen", "panel_btn_handler": Lino.show_detail, "iconCls": "x-tbar-detail", "overflowText": "Detail", "auto_save": true }, { "itemId": null, "menu_item_text": "L\u00f6schen", "tooltip": "Diesen Datensatz l\u00f6schen", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "L\u00f6schen", "auto_save": false } ],
  cell_edit : true,
  title : "Organisationen",
  page_length : 20,
  stripeRows : true,
  disabled_actions_index : 37,
  ls_store_fields : [ { "name": "name" }, { "name": "email" }, { "name": "created" }, { "name": "modified" }, { "name": "country" }, 'countryHidden', { "name": "city" }, 'cityHidden', { "name": "region" }, 'regionHidden', { "name": "zip_code" }, { "name": "addr1" }, { "name": "street_prefix" }, { "name": "street" }, { "name": "street_no" }, { "name": "street_box" }, { "name": "addr2" }, { "name": "language" }, 'languageHidden', { "name": "url" }, { "name": "phone" }, { "name": "gsm" }, { "name": "fax" }, { "name": "remarks" }, { "type": "boolean", "name": "is_obsolete" }, { "name": "activity" }, 'activityHidden', { "name": "bank_account1" }, { "name": "bank_account2" }, { "name": "prefix" }, { "name": "vat_id" }, { "name": "type" }, 'typeHidden', { "name": "client_contact_type" }, 'client_contact_typeHidden', { "type": "int", "name": "id" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 35,
  ls_grid_configs : [  ],
  content_type : 22,
  ls_id_property : "id",
  gc_name : 0,
  initComponent : function() {
    this.ls_detail_handler = Lino.contacts.Companies.detail;
    this.ls_insert_handler = Lino.contacts.Companies.insert;
    var ww = this.containing_window;
    var name3128 = new Ext.form.TextField({ "selectOnFocus": true, "allowBlank": false, "maxLength": 200 });
    var email3129 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 75 });
    var created3130 = new Ext.form.DisplayField({ "disabled": true, "value": "<br>" });
    var modified3131 = new Ext.form.DisplayField({ "disabled": true, "value": "<br>" });
    var country3132 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/contacts/Companies/country", "method": "GET" }) }), "pageSize": 20, "emptyText": "Land ausw\u00e4hlen..." });
    var city3133 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "forceSelection": false, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/contacts/Companies/city", "method": "GET" }) }), "pageSize": 20, "emptyText": "Ort ausw\u00e4hlen..." });
    var region3134 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/contacts/Companies/region", "method": "GET" }) }), "pageSize": 20, "emptyText": "Ort ausw\u00e4hlen..." });
    var zip_code3135 = new Ext.form.TextField({ "selectOnFocus": true, "boxMinWidth": Lino.chars2width(10), "maxLength": 10 });
    var addr13136 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var street_prefix3137 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var street3138 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var street_no3139 = new Ext.form.TextField({ "selectOnFocus": true, "boxMinWidth": Lino.chars2width(10), "maxLength": 10 });
    var street_box3140 = new Ext.form.TextField({ "selectOnFocus": true, "boxMinWidth": Lino.chars2width(10), "maxLength": 10 });
    var addr23141 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var language3142 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "allowBlank": false, "store": [ [ "en", "Englisch" ], [ "fr", "Franz\u00f6sisch" ], [ "de", "Deutsch" ], [ "nl", "Niederl\u00e4ndisch" ] ] });
    var url3143 = new Lino.URLField({ "selectOnFocus": true, "maxLength": 200 });
    var phone3144 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var gsm3145 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var fax3146 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var remarks3147 = new Ext.form.TextArea({ "selectOnFocus": true, "growMax": 2000 });
    var is_obsolete3148 = new Ext.form.Checkbox({ "selectOnFocus": true, "checked": false });
    var activity3149 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/contacts/Companies/activity", "method": "GET" }) }), "pageSize": 20, "emptyText": "Beruf ausw\u00e4hlen..." });
    var bank_account13150 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 40 });
    var bank_account23151 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 40 });
    var prefix3152 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var vat_id3153 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var type3154 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/contacts/Companies/type", "method": "GET" }) }), "pageSize": 20, "emptyText": "Organisationsart ausw\u00e4hlen..." });
    var client_contact_type3155 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/contacts/Companies/client_contact_type", "method": "GET" }) }), "pageSize": 20, "emptyText": "Klientenkontaktart ausw\u00e4hlen..." });
    var id3156 = new Ext.form.NumberField({ "selectOnFocus": true });
    this.before_row_edit = function(record) {
      city3133.setContextValue('country',record ? record.data['countryHidden'] : undefined);
      city3133.setContextValue('region',record ? record.data['regionHidden'] : undefined);
      region3134.setContextValue('country',record ? record.data['countryHidden'] : undefined);
    };
    this.onRender = function(ct, position) {
      country3132.on('change',Lino.chooser_handler(city3133,'country'));
      region3134.on('change',Lino.chooser_handler(city3133,'region'));
      country3132.on('change',Lino.chooser_handler(region3134,'country'));
      Lino.contacts.Companies.GridPanel.superclass.onRender.call(this, ct, position);
    }
    this.ls_columns = [ { "colIndex": 0, "sortable": true, "header": "Name", "editable": true, "tooltip": "(contacts.Companies.name) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "name", "editor": name3128 }, { "colIndex": 1, "sortable": true, "header": "E-Mail", "editable": true, "tooltip": "(contacts.Companies.email) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "email", "editor": email3129 }, { "colIndex": 2, "sortable": true, "header": "Erstellt", "editable": false, "tooltip": "(contacts.Companies.created) ", "width": Lino.chars2width(17), "dataIndex": "created", "hidden": true }, { "colIndex": 3, "sortable": true, "header": "Bearbeitet", "editable": false, "tooltip": "(contacts.Companies.modified) ", "width": Lino.chars2width(17), "dataIndex": "modified", "hidden": true }, { "colIndex": 4, "sortable": true, "header": "Land", "editable": true, "tooltip": "(contacts.Companies.country) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('countryHidden','Lino.countries.Countries.detail'), "editor": country3132, "dataIndex": "country" }, { "colIndex": 5, "sortable": true, "header": "Ort", "editable": true, "tooltip": "(contacts.Companies.city) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "city", "editor": city3133 }, { "colIndex": 6, "sortable": true, "header": "Region", "editable": true, "tooltip": "(contacts.Companies.region) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "region", "editor": region3134 }, { "colIndex": 7, "sortable": true, "header": "Postleitzahl", "editable": true, "tooltip": "(contacts.Companies.zip_code) ", "filter": { "type": "string" }, "width": Lino.chars2width(12), "dataIndex": "zip_code", "editor": zip_code3135 }, { "colIndex": 8, "sortable": true, "header": "Adresszeile vor Stra\u00dfe", "editable": true, "tooltip": "(contacts.Companies.addr1) Address line before street", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "addr1", "editor": addr13136 }, { "colIndex": 9, "sortable": true, "header": "Pr\u00e4fix Stra\u00dfe", "editable": true, "tooltip": "(contacts.Companies.street_prefix) Text to print before name of street, but to ignore for sorting.", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "street_prefix", "editor": street_prefix3137 }, { "colIndex": 10, "sortable": true, "header": "Stra\u00dfe", "editable": true, "tooltip": "(contacts.Companies.street) Name of street. Without house number.", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "street", "editor": street3138 }, { "colIndex": 11, "sortable": true, "header": "Nr.", "editable": true, "tooltip": "(contacts.Companies.street_no) House number", "filter": { "type": "string" }, "width": Lino.chars2width(12), "dataIndex": "street_no", "editor": street_no3139 }, { "colIndex": 12, "sortable": true, "header": "Box", "editable": true, "tooltip": "(contacts.Companies.street_box) Text to print after :attr:`steet_no` on the same line", "filter": { "type": "string" }, "width": Lino.chars2width(12), "dataIndex": "street_box", "editor": street_box3140 }, { "colIndex": 13, "sortable": true, "header": "Adresszeile nach Stra\u00dfe", "editable": true, "tooltip": "(contacts.Companies.addr2) Address line to print below street line", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "addr2", "editor": addr23141 }, { "colIndex": 14, "sortable": true, "header": "Sprache", "editable": true, "tooltip": "(contacts.Companies.language) Die Sprache, in der Dokumente ausgestellt werden sollen.", "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "language", "editor": language3142 }, { "colIndex": 15, "sortable": true, "header": "URL", "editable": true, "tooltip": "(contacts.Companies.url) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "url", "editor": url3143 }, { "colIndex": 16, "sortable": true, "header": "Telefon", "editable": true, "tooltip": "(contacts.Companies.phone) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "phone", "editor": phone3144 }, { "colIndex": 17, "sortable": true, "header": "GSM", "editable": true, "tooltip": "(contacts.Companies.gsm) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "gsm", "editor": gsm3145 }, { "colIndex": 18, "sortable": true, "header": "Fax", "editable": true, "tooltip": "(contacts.Companies.fax) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "fax", "editor": fax3146 }, { "colIndex": 19, "sortable": false, "header": "Bemerkungen", "editable": true, "tooltip": "(contacts.Companies.remarks) ", "filter": { "type": "string" }, "width": Lino.chars2width(61), "renderer": Lino.text_renderer, "editor": remarks3147, "dataIndex": "remarks" }, { "colIndex": 20, "sortable": false, "xtype": "checkcolumn", "header": "veraltet", "editable": true, "tooltip": "(contacts.Companies.is_obsolete) Altf\u00e4lle sind Partner, deren Stammdaten nicht mehr gepflegt werden und \nf\u00fcr neue Operationen nicht benutzt werden k\u00f6nnen.", "filter": { "type": "boolean" }, "width": Lino.chars2width(11), "dataIndex": "is_obsolete" }, { "colIndex": 21, "sortable": true, "header": "Beruf", "editable": true, "tooltip": "(contacts.Companies.activity) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "activity", "hidden": true, "editor": activity3149 }, { "colIndex": 22, "sortable": true, "header": "Bankkonto 1", "editable": true, "tooltip": "(contacts.Companies.bank_account1) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "bank_account1", "hidden": true, "editor": bank_account13150 }, { "colIndex": 23, "sortable": true, "header": "Bankkonto 2", "editable": true, "tooltip": "(contacts.Companies.bank_account2) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "bank_account2", "hidden": true, "editor": bank_account23151 }, { "colIndex": 24, "sortable": true, "header": "prefix", "editable": true, "tooltip": "(contacts.Companies.prefix) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "prefix", "editor": prefix3152 }, { "colIndex": 25, "sortable": true, "header": "MWSt.-Nr.", "editable": true, "tooltip": "(contacts.Companies.vat_id) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "vat_id", "editor": vat_id3153 }, { "colIndex": 26, "sortable": true, "header": "Organisationsart", "editable": true, "tooltip": "(contacts.Companies.type) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "type", "editor": type3154 }, { "colIndex": 27, "sortable": true, "header": "Klientenkontaktart", "editable": true, "tooltip": "(contacts.Companies.client_contact_type) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "client_contact_type", "editor": client_contact_type3155 }, new Lino.NullNumberColumn({ "colIndex": 28, "sortable": true, "format": "0", "editable": true, "tooltip": "(contacts.Companies.id) ", "filter": { "type": "numeric" }, "header": "ID", "renderer": Lino.id_renderer, "editor": id3156, "width": Lino.chars2width(6), "dataIndex": "id" }) ];
    Lino.contacts.Companies.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.contacts.Companies.put = function(rp,pk) { 
  Lino.run_row_action(rp,"/contacts/Companies","GET",pk,"put",null);
};
Lino.contacts.Companies.post = function(rp,pk) { 
  Lino.run_row_action(rp,"/contacts/Companies","GET",pk,"post",null);
};

Lino.contacts.Companies.insertPanel = Ext.extend(Lino.contacts.Companies.InsertFormPanel,{
  empty_title: "Neu Organisationen",
  hide_navigator: true,
  ls_bbar_actions: [ { "itemId": "post", "menu_item_text": "Erstellen", "tooltip": "Datensatz erstellen und dann im Detail-Fenster \u00f6ffnen", "panel_btn_handler": function(panel){panel.save(null,true,'post')}, "text": "Erstellen", "overflowText": "Erstellen", "auto_save": false }, { "itemId": "poststay", "menu_item_text": "Erstellen ohne Detail", "tooltip": "Nach Erstellen des Datensatzes kein Detail-Fenster \u00f6ffnen", "panel_btn_handler": function(panel){panel.save(null,false,'poststay')}, "text": "Erstellen ohne Detail", "overflowText": "Erstellen ohne Detail", "auto_save": false } ],
  ls_url: "/contacts/Companies",
  action_name: "insert",
  initComponent : function() {
    this.ls_detail_handler = Lino.contacts.Companies.detail;
    this.ls_insert_handler = Lino.contacts.Companies.insert;
    Lino.contacts.Companies.insertPanel.superclass.initComponent.call(this);
  }
});

Lino.contacts.Companies.insert = new Lino.WindowAction({ "draggable": true, "width": Lino.chars2width(60), "autoHeight": true, "maximizable": true, "modal": true, "maximized": false },function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.contacts.Companies.insertPanel(p);
});
Lino.contacts.Companies.poststay = function(rp,pk) { 
  Lino.run_row_action(rp,"/contacts/Companies","GET",pk,"poststay",null);
};

Lino.contacts.Companies.detailPanel = Ext.extend(Lino.contacts.Companies.DetailFormPanel,{
  empty_title: "Detail Organisationen",
  ls_bbar_actions: [ { "itemId": "put", "menu_item_text": "Speichern", "tooltip": "\u00c4nderungen in diesem Formular speichern", "panel_btn_handler": function(panel){panel.save(null,false,'put')}, "iconCls": "x-tbar-save", "overflowText": "Speichern", "auto_save": false }, { "itemId": "insert", "menu_item_text": "Neu", "must_save": true, "tooltip": "Neuen Datensatz erstellen", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-new", "overflowText": "Neu", "auto_save": true }, { "itemId": null, "menu_item_text": "L\u00f6schen", "tooltip": "Diesen Datensatz l\u00f6schen", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "L\u00f6schen", "auto_save": false } ],
  ls_url: "/contacts/Companies",
  action_name: "detail",
  initComponent : function() {
    this.ls_detail_handler = Lino.contacts.Companies.detail;
    this.ls_insert_handler = Lino.contacts.Companies.insert;
    Lino.contacts.Companies.detailPanel.superclass.initComponent.call(this);
  }
});

Lino.contacts.Companies.detail = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.contacts.Companies.detailPanel(p);
});
Lino.contacts.Companies.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.contacts.Companies.GridPanel(p);
});

// js_render_GridPanel_class contacts.Persons
Lino.contacts.Persons.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "Keine Daten anzuzeigen." },
  ls_url : "/contacts/Persons",
  ls_bbar_actions : [ { "itemId": "insert", "menu_item_text": "Neu", "must_save": true, "tooltip": "Neuen Datensatz erstellen", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-new", "overflowText": "Neu", "auto_save": true }, { "itemId": "detail", "menu_item_text": "Detail", "tooltip": "Detail-Fenster auf diesem Datensatz \u00f6ffnen", "panel_btn_handler": Lino.show_detail, "iconCls": "x-tbar-detail", "overflowText": "Detail", "auto_save": true }, { "itemId": null, "menu_item_text": "L\u00f6schen", "tooltip": "Diesen Datensatz l\u00f6schen", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "L\u00f6schen", "auto_save": false } ],
  cell_edit : true,
  title : "Personen",
  page_length : 20,
  params_panel_hidden : true,
  stripeRows : true,
  disabled_actions_index : 39,
  ls_store_fields : [ { "name": "name_column" }, { "name": "address_column" }, { "name": "email" }, { "name": "phone" }, { "name": "gsm" }, { "type": "int", "name": "id" }, { "name": "language" }, 'languageHidden', { "name": "created" }, { "name": "modified" }, { "name": "country" }, 'countryHidden', { "name": "city" }, 'cityHidden', { "name": "region" }, 'regionHidden', { "name": "zip_code" }, { "name": "name" }, { "name": "addr1" }, { "name": "street_prefix" }, { "name": "street" }, { "name": "street_no" }, { "name": "street_box" }, { "name": "addr2" }, { "name": "url" }, { "name": "fax" }, { "name": "remarks" }, { "type": "boolean", "name": "is_obsolete" }, { "name": "activity" }, 'activityHidden', { "name": "bank_account1" }, { "name": "bank_account2" }, { "name": "first_name" }, { "name": "last_name" }, { "name": "gender" }, 'genderHidden', { "name": "birth_date" }, { "name": "title" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 5,
  ls_grid_configs : [  ],
  content_type : 22,
  ls_id_property : "id",
  gc_name : 0,
  initComponent : function() {
    this.ls_detail_handler = Lino.contacts.Persons.detail;
    this.ls_insert_handler = Lino.contacts.Persons.insert;
    var ww = this.containing_window;
    var name_column_disp3158 = new Ext.form.DisplayField({ "disabled": true, "value": "<br/>", "always_enabled": true });
    var address_column_disp3159 = new Ext.form.DisplayField({ "disabled": true, "value": "<br/>", "always_enabled": true });
    var email3160 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 75 });
    var phone3161 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var gsm3162 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var id3163 = new Ext.form.NumberField({ "selectOnFocus": true });
    var language3164 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "allowBlank": false, "store": [ [ "en", "Englisch" ], [ "fr", "Franz\u00f6sisch" ], [ "de", "Deutsch" ], [ "nl", "Niederl\u00e4ndisch" ] ] });
    var created3165 = new Ext.form.DisplayField({ "disabled": true, "value": "<br>" });
    var modified3166 = new Ext.form.DisplayField({ "disabled": true, "value": "<br>" });
    var country3167 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/contacts/Persons/country", "method": "GET" }) }), "pageSize": 20, "emptyText": "Land ausw\u00e4hlen..." });
    var city3168 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "forceSelection": false, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/contacts/Persons/city", "method": "GET" }) }), "pageSize": 20, "emptyText": "Ort ausw\u00e4hlen..." });
    var region3169 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/contacts/Persons/region", "method": "GET" }) }), "pageSize": 20, "emptyText": "Ort ausw\u00e4hlen..." });
    var zip_code3170 = new Ext.form.TextField({ "selectOnFocus": true, "boxMinWidth": Lino.chars2width(10), "maxLength": 10 });
    var name3171 = new Ext.form.TextField({ "selectOnFocus": true, "allowBlank": false, "maxLength": 200 });
    var addr13172 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var street_prefix3173 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var street3174 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var street_no3175 = new Ext.form.TextField({ "selectOnFocus": true, "boxMinWidth": Lino.chars2width(10), "maxLength": 10 });
    var street_box3176 = new Ext.form.TextField({ "selectOnFocus": true, "boxMinWidth": Lino.chars2width(10), "maxLength": 10 });
    var addr23177 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var url3178 = new Lino.URLField({ "selectOnFocus": true, "maxLength": 200 });
    var fax3179 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var remarks3180 = new Ext.form.TextArea({ "selectOnFocus": true, "growMax": 2000 });
    var is_obsolete3181 = new Ext.form.Checkbox({ "selectOnFocus": true, "checked": false });
    var activity3182 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/contacts/Persons/activity", "method": "GET" }) }), "pageSize": 20, "emptyText": "Beruf ausw\u00e4hlen..." });
    var bank_account13183 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 40 });
    var bank_account23184 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 40 });
    var first_name3185 = new Ext.form.TextField({ "selectOnFocus": true, "allowBlank": false, "maxLength": 200 });
    var last_name3186 = new Ext.form.TextField({ "selectOnFocus": true, "allowBlank": false, "maxLength": 200 });
    var gender3187 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "forceSelection": true, "store": [['','<br>']].concat(Lino.lino.Genders) });
    var birth_date3188 = new Lino.IncompleteDateField({ "selectOnFocus": true });
    var title3189 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    this.before_row_edit = function(record) {
      city3168.setContextValue('country',record ? record.data['countryHidden'] : undefined);
      city3168.setContextValue('region',record ? record.data['regionHidden'] : undefined);
      region3169.setContextValue('country',record ? record.data['countryHidden'] : undefined);
    };
    this.onRender = function(ct, position) {
      country3167.on('change',Lino.chooser_handler(city3168,'country'));
      region3169.on('change',Lino.chooser_handler(city3168,'region'));
      country3167.on('change',Lino.chooser_handler(region3169,'country'));
      Lino.contacts.Persons.GridPanel.superclass.onRender.call(this, ct, position);
    }
    this.ls_columns = [ { "width": Lino.chars2width(21), "colIndex": 0, "sortable": false, "dataIndex": "name_column", "header": "Name", "editable": false, "tooltip": "(contacts.Persons.name_column) " }, { "width": Lino.chars2width(31), "colIndex": 1, "sortable": false, "dataIndex": "address_column", "header": "Adresse", "editable": false, "tooltip": "(contacts.Persons.address_column) " }, { "colIndex": 2, "sortable": true, "header": "E-Mail", "editable": true, "tooltip": "(contacts.Persons.email) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "email", "editor": email3160 }, { "colIndex": 3, "sortable": true, "header": "Telefon", "editable": true, "tooltip": "(contacts.Persons.phone) ", "filter": { "type": "string" }, "width": Lino.chars2width(11), "dataIndex": "phone", "editor": phone3161 }, { "colIndex": 4, "sortable": true, "header": "GSM", "editable": true, "tooltip": "(contacts.Persons.gsm) ", "filter": { "type": "string" }, "width": Lino.chars2width(11), "dataIndex": "gsm", "editor": gsm3162 }, new Lino.NullNumberColumn({ "colIndex": 5, "sortable": true, "format": "0", "editable": true, "tooltip": "(contacts.Persons.id) ", "filter": { "type": "numeric" }, "header": "ID", "renderer": Lino.id_renderer, "editor": id3163, "width": Lino.chars2width(6), "dataIndex": "id" }), { "colIndex": 6, "sortable": true, "header": "Sprache", "editable": true, "tooltip": "(contacts.Persons.language) Die Sprache, in der Dokumente ausgestellt werden sollen.", "filter": { "type": "string" }, "width": Lino.chars2width(11), "dataIndex": "language", "editor": language3164 }, { "colIndex": 7, "sortable": true, "header": "Erstellt", "editable": false, "tooltip": "(contacts.Persons.created) ", "width": Lino.chars2width(17), "dataIndex": "created", "hidden": true }, { "colIndex": 8, "sortable": true, "header": "Bearbeitet", "editable": false, "tooltip": "(contacts.Persons.modified) ", "width": Lino.chars2width(17), "dataIndex": "modified", "hidden": true }, { "colIndex": 9, "sortable": true, "header": "Land", "editable": true, "tooltip": "(contacts.Persons.country) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('countryHidden','Lino.countries.Countries.detail'), "editor": country3167, "dataIndex": "country" }, { "colIndex": 10, "sortable": true, "header": "Ort", "editable": true, "tooltip": "(contacts.Persons.city) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "city", "editor": city3168 }, { "colIndex": 11, "sortable": true, "header": "Region", "editable": true, "tooltip": "(contacts.Persons.region) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "region", "editor": region3169 }, { "colIndex": 12, "sortable": true, "header": "Postleitzahl", "editable": true, "tooltip": "(contacts.Persons.zip_code) ", "filter": { "type": "string" }, "width": Lino.chars2width(12), "dataIndex": "zip_code", "editor": zip_code3170 }, { "colIndex": 13, "sortable": true, "header": "Name", "editable": true, "tooltip": "(contacts.Persons.name) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "name", "editor": name3171 }, { "colIndex": 14, "sortable": true, "header": "Adresszeile vor Stra\u00dfe", "editable": true, "tooltip": "(contacts.Persons.addr1) Address line before street", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "addr1", "editor": addr13172 }, { "colIndex": 15, "sortable": true, "header": "Pr\u00e4fix Stra\u00dfe", "editable": true, "tooltip": "(contacts.Persons.street_prefix) Text to print before name of street, but to ignore for sorting.", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "street_prefix", "editor": street_prefix3173 }, { "colIndex": 16, "sortable": true, "header": "Stra\u00dfe", "editable": true, "tooltip": "(contacts.Persons.street) Name of street. Without house number.", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "street", "editor": street3174 }, { "colIndex": 17, "sortable": true, "header": "Nr.", "editable": true, "tooltip": "(contacts.Persons.street_no) House number", "filter": { "type": "string" }, "width": Lino.chars2width(12), "dataIndex": "street_no", "editor": street_no3175 }, { "colIndex": 18, "sortable": true, "header": "Box", "editable": true, "tooltip": "(contacts.Persons.street_box) Text to print after :attr:`steet_no` on the same line", "filter": { "type": "string" }, "width": Lino.chars2width(12), "dataIndex": "street_box", "editor": street_box3176 }, { "colIndex": 19, "sortable": true, "header": "Adresszeile nach Stra\u00dfe", "editable": true, "tooltip": "(contacts.Persons.addr2) Address line to print below street line", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "addr2", "editor": addr23177 }, { "colIndex": 20, "sortable": true, "header": "URL", "editable": true, "tooltip": "(contacts.Persons.url) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "url", "editor": url3178 }, { "colIndex": 21, "sortable": true, "header": "Fax", "editable": true, "tooltip": "(contacts.Persons.fax) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "fax", "editor": fax3179 }, { "colIndex": 22, "sortable": false, "header": "Bemerkungen", "editable": true, "tooltip": "(contacts.Persons.remarks) ", "filter": { "type": "string" }, "width": Lino.chars2width(61), "renderer": Lino.text_renderer, "editor": remarks3180, "dataIndex": "remarks" }, { "colIndex": 23, "sortable": false, "xtype": "checkcolumn", "header": "veraltet", "editable": true, "tooltip": "(contacts.Persons.is_obsolete) Altf\u00e4lle sind Partner, deren Stammdaten nicht mehr gepflegt werden und \nf\u00fcr neue Operationen nicht benutzt werden k\u00f6nnen.", "filter": { "type": "boolean" }, "width": Lino.chars2width(11), "dataIndex": "is_obsolete" }, { "colIndex": 24, "sortable": true, "header": "Beruf", "editable": true, "tooltip": "(contacts.Persons.activity) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "activity", "hidden": true, "editor": activity3182 }, { "colIndex": 25, "sortable": true, "header": "Bankkonto 1", "editable": true, "tooltip": "(contacts.Persons.bank_account1) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "bank_account1", "hidden": true, "editor": bank_account13183 }, { "colIndex": 26, "sortable": true, "header": "Bankkonto 2", "editable": true, "tooltip": "(contacts.Persons.bank_account2) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "bank_account2", "hidden": true, "editor": bank_account23184 }, { "colIndex": 27, "sortable": true, "header": "Vorname", "editable": true, "tooltip": "(contacts.Persons.first_name) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "first_name", "editor": first_name3185 }, { "colIndex": 28, "sortable": true, "header": "Familienname", "editable": true, "tooltip": "(contacts.Persons.last_name) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "last_name", "editor": last_name3186 }, { "colIndex": 29, "sortable": true, "header": "Geschlecht", "editable": true, "tooltip": "(contacts.Persons.gender) ", "filter": { "type": "string" }, "width": Lino.chars2width(10), "dataIndex": "gender", "editor": gender3187 }, { "colIndex": 30, "sortable": true, "header": "Geburtsdatum", "editable": true, "tooltip": "(contacts.Persons.birth_date) Uncomplete dates are allowed, e.g. \n\"00.00.1980\" means \"some day in 1980\", \n\"00.07.1980\" means \"in July 1980\"\nor \"23.07.0000\" means \"on a 23th of July\".", "filter": { "type": "string" }, "width": Lino.chars2width(13), "dataIndex": "birth_date", "editor": birth_date3188 }, { "colIndex": 31, "sortable": true, "header": "Anrede", "editable": true, "tooltip": "(contacts.Persons.title) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "title", "editor": title3189 } ];
    Lino.contacts.Persons.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.contacts.Persons.put = function(rp,pk) { 
  Lino.run_row_action(rp,"/contacts/Persons","GET",pk,"put",null);
};
Lino.contacts.Persons.post = function(rp,pk) { 
  Lino.run_row_action(rp,"/contacts/Persons","GET",pk,"post",null);
};

Lino.contacts.Persons.insertPanel = Ext.extend(Lino.contacts.Persons.InsertFormPanel,{
  empty_title: "Neu Personen",
  hide_navigator: true,
  params_panel_hidden: true,
  ls_bbar_actions: [ { "itemId": "post", "menu_item_text": "Erstellen", "tooltip": "Datensatz erstellen und dann im Detail-Fenster \u00f6ffnen", "panel_btn_handler": function(panel){panel.save(null,true,'post')}, "text": "Erstellen", "overflowText": "Erstellen", "auto_save": false }, { "itemId": "poststay", "menu_item_text": "Erstellen ohne Detail", "tooltip": "Nach Erstellen des Datensatzes kein Detail-Fenster \u00f6ffnen", "panel_btn_handler": function(panel){panel.save(null,false,'poststay')}, "text": "Erstellen ohne Detail", "overflowText": "Erstellen ohne Detail", "auto_save": false } ],
  ls_url: "/contacts/Persons",
  action_name: "insert",
  initComponent : function() {
    this.ls_detail_handler = Lino.contacts.Persons.detail;
    this.ls_insert_handler = Lino.contacts.Persons.insert;
    Lino.contacts.Persons.insertPanel.superclass.initComponent.call(this);
  }
});

Lino.contacts.Persons.insert = new Lino.WindowAction({ "draggable": true, "width": Lino.chars2width(60), "autoHeight": true, "maximizable": true, "modal": true, "maximized": false },function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.contacts.Persons.insertPanel(p);
});
Lino.contacts.Persons.poststay = function(rp,pk) { 
  Lino.run_row_action(rp,"/contacts/Persons","GET",pk,"poststay",null);
};

Lino.contacts.Persons.detailPanel = Ext.extend(Lino.contacts.Persons.DetailFormPanel,{
  empty_title: "Detail Personen",
  params_panel_hidden: true,
  ls_bbar_actions: [ { "itemId": "put", "menu_item_text": "Speichern", "tooltip": "\u00c4nderungen in diesem Formular speichern", "panel_btn_handler": function(panel){panel.save(null,false,'put')}, "iconCls": "x-tbar-save", "overflowText": "Speichern", "auto_save": false }, { "itemId": "insert", "menu_item_text": "Neu", "must_save": true, "tooltip": "Neuen Datensatz erstellen", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-new", "overflowText": "Neu", "auto_save": true }, { "itemId": null, "menu_item_text": "L\u00f6schen", "tooltip": "Diesen Datensatz l\u00f6schen", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "L\u00f6schen", "auto_save": false } ],
  ls_url: "/contacts/Persons",
  action_name: "detail",
  initComponent : function() {
    this.ls_detail_handler = Lino.contacts.Persons.detail;
    this.ls_insert_handler = Lino.contacts.Persons.insert;
    Lino.contacts.Persons.detailPanel.superclass.initComponent.call(this);
  }
});

Lino.contacts.Persons.detail = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.contacts.Persons.detailPanel(p);
});
Lino.contacts.Persons.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  p.params_panel = new Lino.contacts.Persons.ParamsPanel({});
  return new Lino.contacts.Persons.GridPanel(p);
});

// js_render_GridPanel_class outbox.Recipients
Lino.outbox.Recipients.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "Keine Daten anzuzeigen." },
  ls_url : "/outbox/Recipients",
  ls_bbar_actions : [ { "itemId": null, "menu_item_text": "L\u00f6schen", "tooltip": "Diesen Datensatz l\u00f6schen", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "L\u00f6schen", "auto_save": false } ],
  cell_edit : true,
  title : "Empf\u00e4nger",
  page_length : 20,
  stripeRows : true,
  disabled_actions_index : 10,
  ls_store_fields : [ { "type": "int", "name": "id" }, { "name": "mail" }, 'mailHidden', { "name": "partner" }, 'partnerHidden', { "name": "type" }, 'typeHidden', { "name": "address" }, { "name": "name" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 0,
  ls_grid_configs : [  ],
  content_type : 27,
  ls_id_property : "id",
  gc_name : 0,
  initComponent : function() {
    var ww = this.containing_window;
    var id3191 = new Ext.form.NumberField({ "selectOnFocus": true });
    var mail3192 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/outbox/Recipients/mail", "method": "GET" }) }), "allowBlank": false, "pageSize": 20, "emptyText": "E-Mail-Ausgang ausw\u00e4hlen..." });
    var partner3193 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "preferred_width": 20, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/outbox/Recipients/partner", "method": "GET" }) }), "pageSize": 20, "emptyText": "Partner ausw\u00e4hlen..." });
    var type3194 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "forceSelection": true, "allowBlank": false, "store": Lino.outbox.RecipientType });
    var address3195 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 75 });
    var name3196 = new Ext.form.TextField({ "selectOnFocus": true, "allowBlank": false, "maxLength": 200 });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ new Lino.NullNumberColumn({ "colIndex": 0, "sortable": true, "format": "0", "editable": true, "tooltip": "(outbox.Recipients.id) ", "filter": { "type": "numeric" }, "header": "ID", "renderer": Lino.id_renderer, "editor": id3191, "width": Lino.chars2width(6), "dataIndex": "id" }), { "colIndex": 1, "sortable": true, "header": "E-Mail-Ausgang", "editable": true, "tooltip": "(outbox.Recipients.mail) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('mailHidden','Lino.outbox.Mails.detail'), "editor": mail3192, "dataIndex": "mail" }, { "colIndex": 2, "sortable": true, "header": "Partner", "editable": true, "tooltip": "(outbox.Recipients.partner) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('partnerHidden','Lino.contacts.Partners.detail'), "editor": partner3193, "dataIndex": "partner" }, { "colIndex": 3, "sortable": true, "header": "Empf\u00e4ngerart", "editable": true, "tooltip": "(outbox.Recipients.type) ", "filter": { "type": "string" }, "width": Lino.chars2width(8), "dataIndex": "type", "editor": type3194 }, { "colIndex": 4, "sortable": true, "header": "Adresse", "editable": true, "tooltip": "(outbox.Recipients.address) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "address", "editor": address3195 }, { "colIndex": 5, "sortable": true, "header": "Name", "editable": true, "tooltip": "(outbox.Recipients.name) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "name", "editor": name3196 } ];
    Lino.outbox.Recipients.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.outbox.Recipients.put = function(rp,pk) { 
  Lino.run_row_action(rp,"/outbox/Recipients","GET",pk,"put",null);
};
Lino.outbox.Recipients.post = function(rp,pk) { 
  Lino.run_row_action(rp,"/outbox/Recipients","GET",pk,"post",null);
};
Lino.outbox.Recipients.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.outbox.Recipients.GridPanel(p);
});

// js_render_GridPanel_class outbox.Mails
Lino.outbox.Mails.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "Keine Daten anzuzeigen." },
  ls_url : "/outbox/Mails",
  ls_bbar_actions : [ { "itemId": "insert", "menu_item_text": "Neu", "must_save": true, "tooltip": "Neuen Datensatz erstellen", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-new", "overflowText": "Neu", "auto_save": true }, { "itemId": "detail", "menu_item_text": "Detail", "tooltip": "Detail-Fenster auf diesem Datensatz \u00f6ffnen", "panel_btn_handler": Lino.show_detail, "iconCls": "x-tbar-detail", "overflowText": "Detail", "auto_save": true }, { "itemId": null, "menu_item_text": "L\u00f6schen", "tooltip": "Diesen Datensatz l\u00f6schen", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "L\u00f6schen", "auto_save": false }, { "itemId": "do_print", "menu_item_text": "Drucken", "must_save": true, "tooltip": "Drucken", "panel_btn_handler": Lino.row_action_handler('do_print','GET',null), "iconCls": "x-tbar-print", "overflowText": "Drucken", "auto_save": true }, { "itemId": "edit_template", "menu_item_text": "Vorlage bearbeiten", "must_save": true, "panel_btn_handler": Lino.row_action_handler('edit_template','GET',null), "text": "Vorlage bearbeiten", "overflowText": "Vorlage bearbeiten", "auto_save": true }, { "itemId": "send_mail", "menu_item_text": "E-Mail senden", "must_save": true, "tooltip": "E-Mail senden", "panel_btn_handler": Lino.row_action_handler('send_mail','GET',null), "iconCls": "x-tbar-email_send", "overflowText": "E-Mail senden", "auto_save": true } ],
  cell_edit : true,
  title : "E-Mail-Ausg\u00e4nge",
  page_length : 20,
  stripeRows : true,
  disabled_actions_index : 16,
  ls_store_fields : [ { "name": "sent" }, { "name": "recipients" }, { "name": "subject" }, { "type": "int", "name": "id" }, { "name": "owner_type" }, 'owner_typeHidden', { "name": "owner_id" }, 'owner_idHidden', { "name": "user" }, 'userHidden', { "name": "project" }, 'projectHidden', { "type": "date", "name": "date", "dateFormat": "d.m.Y" }, { "name": "owner" }, { "name": "body" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 3,
  ls_grid_configs : [  ],
  content_type : 26,
  ls_id_property : "id",
  gc_name : 0,
  initComponent : function() {
    this.ls_detail_handler = Lino.outbox.Mails.detail;
    this.ls_insert_handler = Lino.outbox.Mails.insert;
    var ww = this.containing_window;
    var sent3198 = new Ext.form.DisplayField({ "disabled": true, "value": "<br>" });
    var recipients_htmlbox3199 = new Lino.HtmlBoxPanel({ "layout": "fit", "name": "recipients", "containing_panel": this, "items": new Ext.BoxComponent({autoScroll:true}), "title": "Empf\u00e4nger", "master_panel": this, "value": "<br/>", "always_enabled": true, "bodyStyle": "overflow-x:hidden;" });
    var subject3200 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var id3201 = new Ext.form.NumberField({ "selectOnFocus": true });
    var owner_type3202 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/outbox/Mails/owner_type", "method": "GET" }) }), "pageSize": 20, "emptyText": "Inhaltstyp ausw\u00e4hlen..." });
    var owner_id3203 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/outbox/Mails/owner_id", "method": "GET" }) }) });
    var user3204 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "preferred_width": 15, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/outbox/Mails/user", "method": "GET" }) }), "pageSize": 20, "emptyText": "Benutzer ausw\u00e4hlen..." });
    var project3205 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "preferred_width": 20, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/outbox/Mails/project", "method": "GET" }) }), "pageSize": 20, "emptyText": "Klient ausw\u00e4hlen..." });
    var date3206 = new Lino.DateField({ "selectOnFocus": true, "allowBlank": false });
    var owner_disp3207 = new Ext.form.DisplayField({ "disabled": true });
    var body3208 = new Lino.RichTextPanel({ "selectOnFocus": true, "containing_panel": this, "title": "Inhalt" });
    this.before_row_edit = function(record) {
      recipients_htmlbox3199.refresh();
      owner_id3203.setContextValue('owner_type',record ? record.data['owner_typeHidden'] : undefined);
      body3208.refresh();
    };
    this.onRender = function(ct, position) {
      owner_type3202.on('change',Lino.chooser_handler(owner_id3203,'owner_type'));
      Lino.outbox.Mails.GridPanel.superclass.onRender.call(this, ct, position);
    }
    this.ls_columns = [ { "width": Lino.chars2width(17), "colIndex": 0, "sortable": true, "dataIndex": "sent", "header": "sent", "editable": false, "tooltip": "(outbox.Mails.sent) " }, { "width": Lino.chars2width(31), "colIndex": 1, "sortable": false, "dataIndex": "recipients", "header": "Empf\u00e4nger", "editable": false, "tooltip": "(outbox.Mails.recipients) " }, { "colIndex": 2, "sortable": true, "header": "Betreff", "editable": true, "tooltip": "(outbox.Mails.subject) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "subject", "editor": subject3200 }, new Lino.NullNumberColumn({ "colIndex": 3, "sortable": true, "format": "0", "editable": true, "tooltip": "(outbox.Mails.id) ", "filter": { "type": "numeric" }, "header": "ID", "renderer": Lino.id_renderer, "editor": id3201, "width": Lino.chars2width(6), "dataIndex": "id" }), { "colIndex": 4, "sortable": true, "header": "Verkn\u00fcpft mit (Modell)", "editable": true, "tooltip": "(outbox.Mails.owner_type) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "owner_type", "editor": owner_type3202 }, { "colIndex": 5, "sortable": true, "header": "Verkn\u00fcpft mit (Objekt)", "editable": true, "tooltip": "(outbox.Mails.owner_id) ", "filter": { "type": "string" }, "width": Lino.chars2width(11), "dataIndex": "owner_id", "editor": owner_id3203 }, { "colIndex": 6, "sortable": true, "header": "Absender", "editable": true, "tooltip": "(outbox.Mails.user) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "user", "editor": user3204 }, { "colIndex": 7, "sortable": true, "header": "Klient", "editable": true, "tooltip": "(outbox.Mails.project) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('projectHidden','Lino.pcsw.Clients.detail'), "editor": project3205, "dataIndex": "project" }, { "colIndex": 8, "sortable": true, "xtype": "datecolumn", "format": "d.m.Y", "editable": true, "tooltip": "(outbox.Mails.date) \n        The official date to be printed on the document.\n        ", "filter": { "type": "date", "dateFormat": "d.m.Y" }, "header": "Datum", "dataIndex": "date", "width": Lino.chars2width(9), "editor": date3206 }, { "width": Lino.chars2width(11), "colIndex": 9, "sortable": false, "dataIndex": "owner", "header": "Verkn\u00fcpft mit", "editable": false, "tooltip": "(outbox.Mails.owner) " }, { "colIndex": 10, "sortable": false, "width": Lino.chars2width(61), "editable": true, "tooltip": "(outbox.Mails.body) ", "filter": { "type": "string" }, "header": "body", "renderer": Lino.text_renderer, "hidden": true, "editor": body3208, "dataIndex": "body" } ];
    Lino.outbox.Mails.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.outbox.Mails.put = function(rp,pk) { 
  Lino.run_row_action(rp,"/outbox/Mails","GET",pk,"put",null);
};
Lino.outbox.Mails.post = function(rp,pk) { 
  Lino.run_row_action(rp,"/outbox/Mails","GET",pk,"post",null);
};

Lino.outbox.Mails.insertPanel = Ext.extend(Lino.outbox.Mails.InsertFormPanel,{
  empty_title: "Neu E-Mail-Ausg\u00e4nge",
  hide_navigator: true,
  ls_bbar_actions: [ { "itemId": "post", "menu_item_text": "Erstellen", "tooltip": "Datensatz erstellen und dann im Detail-Fenster \u00f6ffnen", "panel_btn_handler": function(panel){panel.save(null,true,'post')}, "text": "Erstellen", "overflowText": "Erstellen", "auto_save": false }, { "itemId": "poststay", "menu_item_text": "Erstellen ohne Detail", "tooltip": "Nach Erstellen des Datensatzes kein Detail-Fenster \u00f6ffnen", "panel_btn_handler": function(panel){panel.save(null,false,'poststay')}, "text": "Erstellen ohne Detail", "overflowText": "Erstellen ohne Detail", "auto_save": false } ],
  ls_url: "/outbox/Mails",
  action_name: "insert",
  initComponent : function() {
    this.ls_detail_handler = Lino.outbox.Mails.detail;
    this.ls_insert_handler = Lino.outbox.Mails.insert;
    Lino.outbox.Mails.insertPanel.superclass.initComponent.call(this);
  }
});

Lino.outbox.Mails.insert = new Lino.WindowAction({ "draggable": true, "width": Lino.chars2width(60), "maximizable": true, "modal": true, "maximized": false, "height": Lino.rows2height(20) },function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.outbox.Mails.insertPanel(p);
});
Lino.outbox.Mails.poststay = function(rp,pk) { 
  Lino.run_row_action(rp,"/outbox/Mails","GET",pk,"poststay",null);
};

Lino.outbox.Mails.detailPanel = Ext.extend(Lino.outbox.Mails.DetailFormPanel,{
  empty_title: "Detail E-Mail-Ausg\u00e4nge",
  ls_bbar_actions: [ { "itemId": "put", "menu_item_text": "Speichern", "tooltip": "\u00c4nderungen in diesem Formular speichern", "panel_btn_handler": function(panel){panel.save(null,false,'put')}, "iconCls": "x-tbar-save", "overflowText": "Speichern", "auto_save": false }, { "itemId": "insert", "menu_item_text": "Neu", "must_save": true, "tooltip": "Neuen Datensatz erstellen", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-new", "overflowText": "Neu", "auto_save": true }, { "itemId": null, "menu_item_text": "L\u00f6schen", "tooltip": "Diesen Datensatz l\u00f6schen", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "L\u00f6schen", "auto_save": false }, { "itemId": "do_print", "menu_item_text": "Drucken", "must_save": true, "tooltip": "Drucken", "panel_btn_handler": Lino.row_action_handler('do_print','GET',null), "iconCls": "x-tbar-print", "overflowText": "Drucken", "auto_save": true }, { "itemId": "edit_template", "menu_item_text": "Vorlage bearbeiten", "must_save": true, "panel_btn_handler": Lino.row_action_handler('edit_template','GET',null), "text": "Vorlage bearbeiten", "overflowText": "Vorlage bearbeiten", "auto_save": true }, { "itemId": "send_mail", "menu_item_text": "E-Mail senden", "must_save": true, "tooltip": "E-Mail senden", "panel_btn_handler": Lino.row_action_handler('send_mail','GET',null), "iconCls": "x-tbar-email_send", "overflowText": "E-Mail senden", "auto_save": true } ],
  ls_url: "/outbox/Mails",
  action_name: "detail",
  initComponent : function() {
    this.ls_detail_handler = Lino.outbox.Mails.detail;
    this.ls_insert_handler = Lino.outbox.Mails.insert;
    Lino.outbox.Mails.detailPanel.superclass.initComponent.call(this);
  }
});

Lino.outbox.Mails.detail = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.outbox.Mails.detailPanel(p);
});
Lino.outbox.Mails.do_print = function(rp,pk) { 
  Lino.run_row_action(rp,"/outbox/Mails","GET",pk,"do_print",null);
};
Lino.outbox.Mails.edit_template = function(rp,pk) { 
  Lino.run_row_action(rp,"/outbox/Mails","GET",pk,"edit_template",null);
};
Lino.outbox.Mails.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.outbox.Mails.GridPanel(p);
});
Lino.outbox.Mails.send_mail = function(rp,pk) { 
  Lino.run_row_action(rp,"/outbox/Mails","GET",pk,"send_mail",null);
};

// js_render_GridPanel_class outbox.Attachments
Lino.outbox.Attachments.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "Keine Daten anzuzeigen." },
  ls_url : "/outbox/Attachments",
  ls_bbar_actions : [ { "itemId": null, "menu_item_text": "L\u00f6schen", "tooltip": "Diesen Datensatz l\u00f6schen", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "L\u00f6schen", "auto_save": false } ],
  cell_edit : true,
  title : "Anh\u00e4nge",
  page_length : 20,
  stripeRows : true,
  disabled_actions_index : 9,
  ls_store_fields : [ { "type": "int", "name": "id" }, { "name": "owner_type" }, 'owner_typeHidden', { "name": "owner_id" }, 'owner_idHidden', { "name": "mail" }, 'mailHidden', { "name": "owner" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 0,
  ls_grid_configs : [  ],
  content_type : 28,
  ls_id_property : "id",
  gc_name : 0,
  initComponent : function() {
    var ww = this.containing_window;
    var id3210 = new Ext.form.NumberField({ "selectOnFocus": true });
    var owner_type3211 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/outbox/Attachments/owner_type", "method": "GET" }) }), "pageSize": 20, "emptyText": "Inhaltstyp ausw\u00e4hlen..." });
    var owner_id3212 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/outbox/Attachments/owner_id", "method": "GET" }) }) });
    var mail3213 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/outbox/Attachments/mail", "method": "GET" }) }), "allowBlank": false, "pageSize": 20, "emptyText": "E-Mail-Ausgang ausw\u00e4hlen..." });
    var owner_disp3214 = new Ext.form.DisplayField({ "disabled": true });
    this.before_row_edit = function(record) {
      owner_id3212.setContextValue('owner_type',record ? record.data['owner_typeHidden'] : undefined);
    };
    this.onRender = function(ct, position) {
      owner_type3211.on('change',Lino.chooser_handler(owner_id3212,'owner_type'));
      Lino.outbox.Attachments.GridPanel.superclass.onRender.call(this, ct, position);
    }
    this.ls_columns = [ new Lino.NullNumberColumn({ "colIndex": 0, "sortable": true, "format": "0", "editable": true, "tooltip": "(outbox.Attachments.id) ", "filter": { "type": "numeric" }, "header": "ID", "renderer": Lino.id_renderer, "editor": id3210, "width": Lino.chars2width(6), "dataIndex": "id" }), { "colIndex": 1, "sortable": true, "header": "Verkn\u00fcpft mit (Modell)", "editable": true, "tooltip": "(outbox.Attachments.owner_type) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "owner_type", "editor": owner_type3211 }, { "colIndex": 2, "sortable": true, "header": "Verkn\u00fcpft mit (Objekt)", "editable": true, "tooltip": "(outbox.Attachments.owner_id) ", "filter": { "type": "string" }, "width": Lino.chars2width(11), "dataIndex": "owner_id", "editor": owner_id3212 }, { "colIndex": 3, "sortable": true, "header": "E-Mail-Ausgang", "editable": true, "tooltip": "(outbox.Attachments.mail) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('mailHidden','Lino.outbox.Mails.detail'), "editor": mail3213, "dataIndex": "mail" }, { "width": Lino.chars2width(11), "colIndex": 4, "sortable": false, "dataIndex": "owner", "header": "Verkn\u00fcpft mit", "editable": false, "tooltip": "(outbox.Attachments.owner) " } ];
    Lino.outbox.Attachments.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.outbox.Attachments.put = function(rp,pk) { 
  Lino.run_row_action(rp,"/outbox/Attachments","GET",pk,"put",null);
};
Lino.outbox.Attachments.post = function(rp,pk) { 
  Lino.run_row_action(rp,"/outbox/Attachments","GET",pk,"post",null);
};
Lino.outbox.Attachments.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.outbox.Attachments.GridPanel(p);
});

// js_render_GridPanel_class cal.Calendars
Lino.cal.Calendars.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "Keine Daten anzuzeigen." },
  ls_url : "/cal/Calendars",
  ls_bbar_actions : [ { "itemId": "insert", "menu_item_text": "Neu", "must_save": true, "tooltip": "Neuen Datensatz erstellen", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-new", "overflowText": "Neu", "auto_save": true }, { "itemId": "duplicate", "menu_item_text": "Duplizieren", "must_save": true, "tooltip": "Duplizieren", "panel_btn_handler": Lino.row_action_handler('duplicate','GET',null), "iconCls": "x-tbar-duplicate", "overflowText": "Duplizieren", "auto_save": true }, { "itemId": "detail", "menu_item_text": "Detail", "tooltip": "Detail-Fenster auf diesem Datensatz \u00f6ffnen", "panel_btn_handler": Lino.show_detail, "iconCls": "x-tbar-detail", "overflowText": "Detail", "auto_save": true }, { "itemId": null, "menu_item_text": "L\u00f6schen", "tooltip": "Diesen Datensatz l\u00f6schen", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "L\u00f6schen", "auto_save": false }, { "itemId": "move_up", "menu_item_text": "Rauf", "must_save": true, "tooltip": "Move this row one row upwards", "panel_btn_handler": Lino.row_action_handler('move_up','GET',null), "iconCls": "x-tbar-moveup", "overflowText": "Rauf", "auto_save": true }, { "itemId": "move_down", "menu_item_text": "Down", "must_save": true, "tooltip": "Move this row one row downwards", "panel_btn_handler": Lino.row_action_handler('move_down','GET',null), "iconCls": "x-tbar-movedown", "overflowText": "Down", "auto_save": true } ],
  cell_edit : true,
  title : "Kalenderliste",
  page_length : 20,
  stripeRows : true,
  disabled_actions_index : 28,
  ls_store_fields : [ { "name": "name" }, { "name": "name_fr" }, { "name": "name_de" }, { "name": "name_nl" }, { "name": "type" }, 'typeHidden', { "type": "int", "name": "color" }, { "type": "boolean", "name": "readonly" }, { "name": "build_method" }, 'build_methodHidden', { "name": "template" }, { "type": "int", "name": "id" }, { "type": "int", "name": "seqno" }, { "type": "boolean", "name": "attach_to_email" }, { "name": "email_template" }, { "name": "url_template" }, { "name": "username" }, { "name": "password" }, { "type": "boolean", "name": "is_appointment" }, { "type": "date", "name": "start_date", "dateFormat": "d.m.Y" }, { "name": "event_label" }, { "name": "event_label_fr" }, { "name": "event_label_de" }, { "name": "event_label_nl" }, { "name": "invite_team_members" }, 'invite_team_membersHidden', { "type": "boolean", "name": "invite_client" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 11,
  ls_grid_configs : [  ],
  content_type : 33,
  ls_id_property : "id",
  gc_name : 0,
  initComponent : function() {
    this.ls_detail_handler = Lino.cal.Calendars.detail;
    this.ls_insert_handler = Lino.cal.Calendars.insert;
    var ww = this.containing_window;
    var name3216 = new Ext.form.TextField({ "selectOnFocus": true, "allowBlank": false, "maxLength": 200 });
    var name_fr3217 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var name_de3218 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var name_nl3219 = new Ext.form.TextField({ "selectOnFocus": true, "hidden": true, "maxLength": 200 });
    var type3220 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "store": [ [ "local", "Local Calendar" ], [ "google", "Google Calendar" ] ], "allowBlank": false, "value": "local" });
    var color3221 = new Ext.form.NumberField({ "selectOnFocus": true, "allowBlank": false, "value": 1 });
    var readonly3222 = new Ext.form.Checkbox({ "selectOnFocus": true, "checked": false });
    var build_method3223 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "store": [ [ "appyodt", "AppyOdtBuildMethod" ], [ "appypdf", "AppyPdfBuildMethod" ], [ "appyrtf", "AppyRtfBuildMethod" ], [ "latex", "LatexBuildMethod" ], [ "pisa", "PisaBuildMethod" ], [ "rtf", "RtfBuildMethod" ] ] });
    var template3224 = new Lino.SimpleRemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/Calendars/template", "method": "GET" }) }) });
    var id3225 = new Ext.form.NumberField({ "selectOnFocus": true });
    var seqno3226 = new Ext.form.NumberField({ "selectOnFocus": true });
    var attach_to_email3227 = new Ext.form.Checkbox({ "selectOnFocus": true, "checked": false });
    var email_template3228 = new Lino.SimpleRemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/Calendars/email_template", "method": "GET" }) }) });
    var url_template3229 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var username3230 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var password3231 = new Ext.form.TextField({ "selectOnFocus": true, "inputType": "password", "maxLength": 200 });
    var is_appointment3232 = new Ext.form.Checkbox({ "selectOnFocus": true, "checked": true });
    var start_date3233 = new Lino.DateField({ "selectOnFocus": true });
    var event_label3234 = new Ext.form.TextField({ "selectOnFocus": true, "value": "Termin", "maxLength": 200 });
    var event_label_fr3235 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var event_label_de3236 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var event_label_nl3237 = new Ext.form.TextField({ "selectOnFocus": true, "hidden": true, "maxLength": 200 });
    var invite_team_members3238 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/Calendars/invite_team_members", "method": "GET" }) }), "pageSize": 20, "emptyText": "Team ausw\u00e4hlen..." });
    var invite_client3239 = new Ext.form.Checkbox({ "selectOnFocus": true, "checked": false });
    this.before_row_edit = function(record) {
      template3224.setContextValue('build_method',record ? record.data['build_methodHidden'] : undefined);
    };
    this.onRender = function(ct, position) {
      build_method3223.on('change',Lino.chooser_handler(template3224,'build_method'));
      Lino.cal.Calendars.GridPanel.superclass.onRender.call(this, ct, position);
    }
    this.ls_columns = [ { "colIndex": 0, "sortable": true, "header": "Bezeichnung", "editable": true, "tooltip": "(cal.Calendars.name) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "name", "editor": name3216 }, { "colIndex": 1, "sortable": true, "header": "Bezeichnung (fr)", "editable": true, "tooltip": "(cal.Calendars.name_fr) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "name_fr", "editor": name_fr3217 }, { "colIndex": 2, "sortable": true, "header": "Bezeichnung (de)", "editable": true, "tooltip": "(cal.Calendars.name_de) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "name_de", "editor": name_de3218 }, { "colIndex": 3, "sortable": true, "header": "Bezeichnung (nl)", "editable": true, "tooltip": "(cal.Calendars.name_nl) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "name_nl", "hidden": true, "editor": name_nl3219 }, { "colIndex": 4, "sortable": true, "header": "Art", "editable": true, "tooltip": "(cal.Calendars.type) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "type", "editor": type3220 }, new Lino.NullNumberColumn({ "colIndex": 5, "sortable": true, "format": "0", "editable": true, "tooltip": "(cal.Calendars.color) ", "filter": { "type": "numeric" }, "header": "Farbe", "dataIndex": "color", "width": Lino.chars2width(6), "editor": color3221 }), { "colIndex": 6, "sortable": false, "xtype": "checkcolumn", "header": "schreibgesch\u00fctzt", "editable": true, "tooltip": "(cal.Calendars.readonly) ", "filter": { "type": "boolean" }, "width": Lino.chars2width(11), "dataIndex": "readonly" }, { "colIndex": 7, "sortable": true, "header": "Konstruktionsmethode", "editable": true, "tooltip": "(cal.Calendars.build_method) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "build_method", "editor": build_method3223 }, { "colIndex": 8, "sortable": true, "header": "Vorlage", "editable": true, "tooltip": "(cal.Calendars.template) ", "filter": { "type": "string" }, "width": Lino.chars2width(11), "dataIndex": "template", "editor": template3224 }, new Lino.NullNumberColumn({ "colIndex": 9, "sortable": true, "format": "0", "editable": true, "tooltip": "(cal.Calendars.id) ", "filter": { "type": "numeric" }, "header": "ID", "renderer": Lino.id_renderer, "editor": id3225, "width": Lino.chars2width(6), "dataIndex": "id" }), new Lino.NullNumberColumn({ "colIndex": 10, "sortable": true, "format": "0", "editable": true, "tooltip": "(cal.Calendars.seqno) ", "filter": { "type": "numeric" }, "header": "Seq.-Nr.", "dataIndex": "seqno", "width": Lino.chars2width(6), "editor": seqno3226 }), { "colIndex": 11, "sortable": false, "xtype": "checkcolumn", "header": "als Anhang per E-Mail", "editable": true, "tooltip": "(cal.Calendars.attach_to_email) Whether the printable file should be attached to the email\nwhen creating an email from a mailable of this type.\n", "filter": { "type": "boolean" }, "width": Lino.chars2width(11), "dataIndex": "attach_to_email" }, { "colIndex": 12, "sortable": true, "header": "E-Mail-Vorlage", "editable": true, "tooltip": "(cal.Calendars.email_template) The name of the file to be used as \ntemplate when creating an email from a mailable of this type.", "filter": { "type": "string" }, "width": Lino.chars2width(11), "dataIndex": "email_template", "editor": email_template3228 }, { "colIndex": 13, "sortable": true, "header": "URL-Vorlage", "editable": true, "tooltip": "(cal.Calendars.url_template) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "url_template", "editor": url_template3229 }, { "colIndex": 14, "sortable": true, "header": "Benutzername", "editable": true, "tooltip": "(cal.Calendars.username) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "username", "editor": username3230 }, { "colIndex": 15, "sortable": true, "header": "Passwort", "editable": true, "tooltip": "(cal.Calendars.password) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "password", "editor": password3231 }, { "colIndex": 16, "sortable": false, "xtype": "checkcolumn", "header": "Event is an appointment", "editable": true, "tooltip": "(cal.Calendars.is_appointment) ", "filter": { "type": "boolean" }, "width": Lino.chars2width(11), "dataIndex": "is_appointment" }, { "colIndex": 17, "sortable": true, "xtype": "datecolumn", "format": "d.m.Y", "editable": true, "tooltip": "(cal.Calendars.start_date) ", "filter": { "type": "date", "dateFormat": "d.m.Y" }, "header": "Beginnt am", "dataIndex": "start_date", "width": Lino.chars2width(9), "editor": start_date3233 }, { "colIndex": 18, "sortable": true, "header": "Event label", "editable": true, "tooltip": "(cal.Calendars.event_label) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "event_label", "editor": event_label3234 }, { "colIndex": 19, "sortable": true, "header": "Event label (fr)", "editable": true, "tooltip": "(cal.Calendars.event_label_fr) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "event_label_fr", "editor": event_label_fr3235 }, { "colIndex": 20, "sortable": true, "header": "Event label (de)", "editable": true, "tooltip": "(cal.Calendars.event_label_de) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "event_label_de", "editor": event_label_de3236 }, { "colIndex": 21, "sortable": true, "header": "Event label (nl)", "editable": true, "tooltip": "(cal.Calendars.event_label_nl) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "event_label_nl", "hidden": true, "editor": event_label_nl3237 }, { "colIndex": 22, "sortable": true, "header": "Team", "editable": true, "tooltip": "(cal.Calendars.invite_team_members) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "invite_team_members", "editor": invite_team_members3238 }, { "colIndex": 23, "sortable": false, "xtype": "checkcolumn", "header": "Klient einladen", "editable": true, "tooltip": "(cal.Calendars.invite_client) ", "filter": { "type": "boolean" }, "width": Lino.chars2width(11), "dataIndex": "invite_client" } ];
    Lino.cal.Calendars.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.cal.Calendars.put = function(rp,pk) { 
  Lino.run_row_action(rp,"/cal/Calendars","GET",pk,"put",null);
};
Lino.cal.Calendars.post = function(rp,pk) { 
  Lino.run_row_action(rp,"/cal/Calendars","GET",pk,"post",null);
};

Lino.cal.Calendars.insertPanel = Ext.extend(Lino.cal.Calendars.InsertFormPanel,{
  empty_title: "Neu Kalenderliste",
  hide_navigator: true,
  ls_bbar_actions: [ { "itemId": "post", "menu_item_text": "Erstellen", "tooltip": "Datensatz erstellen und dann im Detail-Fenster \u00f6ffnen", "panel_btn_handler": function(panel){panel.save(null,true,'post')}, "text": "Erstellen", "overflowText": "Erstellen", "auto_save": false }, { "itemId": "poststay", "menu_item_text": "Erstellen ohne Detail", "tooltip": "Nach Erstellen des Datensatzes kein Detail-Fenster \u00f6ffnen", "panel_btn_handler": function(panel){panel.save(null,false,'poststay')}, "text": "Erstellen ohne Detail", "overflowText": "Erstellen ohne Detail", "auto_save": false } ],
  ls_url: "/cal/Calendars",
  action_name: "insert",
  initComponent : function() {
    this.ls_detail_handler = Lino.cal.Calendars.detail;
    this.ls_insert_handler = Lino.cal.Calendars.insert;
    Lino.cal.Calendars.insertPanel.superclass.initComponent.call(this);
  }
});

Lino.cal.Calendars.insert = new Lino.WindowAction({ "draggable": true, "width": Lino.chars2width(60), "autoHeight": true, "maximizable": true, "modal": true, "maximized": false },function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.cal.Calendars.insertPanel(p);
});
Lino.cal.Calendars.poststay = function(rp,pk) { 
  Lino.run_row_action(rp,"/cal/Calendars","GET",pk,"poststay",null);
};
Lino.cal.Calendars.duplicate = function(rp,pk) { 
  Lino.run_row_action(rp,"/cal/Calendars","GET",pk,"duplicate",null);
};

Lino.cal.Calendars.detailPanel = Ext.extend(Lino.cal.Calendars.DetailFormPanel,{
  empty_title: "Detail Kalenderliste",
  ls_bbar_actions: [ { "itemId": "put", "menu_item_text": "Speichern", "tooltip": "\u00c4nderungen in diesem Formular speichern", "panel_btn_handler": function(panel){panel.save(null,false,'put')}, "iconCls": "x-tbar-save", "overflowText": "Speichern", "auto_save": false }, { "itemId": "insert", "menu_item_text": "Neu", "must_save": true, "tooltip": "Neuen Datensatz erstellen", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-new", "overflowText": "Neu", "auto_save": true }, { "itemId": "duplicate", "menu_item_text": "Duplizieren", "must_save": true, "tooltip": "Duplizieren", "panel_btn_handler": Lino.row_action_handler('duplicate','GET',null), "iconCls": "x-tbar-duplicate", "overflowText": "Duplizieren", "auto_save": true }, { "itemId": null, "menu_item_text": "L\u00f6schen", "tooltip": "Diesen Datensatz l\u00f6schen", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "L\u00f6schen", "auto_save": false }, { "itemId": "move_up", "menu_item_text": "Rauf", "must_save": true, "tooltip": "Move this row one row upwards", "panel_btn_handler": Lino.row_action_handler('move_up','GET',null), "iconCls": "x-tbar-moveup", "overflowText": "Rauf", "auto_save": true }, { "itemId": "move_down", "menu_item_text": "Down", "must_save": true, "tooltip": "Move this row one row downwards", "panel_btn_handler": Lino.row_action_handler('move_down','GET',null), "iconCls": "x-tbar-movedown", "overflowText": "Down", "auto_save": true } ],
  ls_url: "/cal/Calendars",
  action_name: "detail",
  initComponent : function() {
    this.ls_detail_handler = Lino.cal.Calendars.detail;
    this.ls_insert_handler = Lino.cal.Calendars.insert;
    Lino.cal.Calendars.detailPanel.superclass.initComponent.call(this);
  }
});

Lino.cal.Calendars.detail = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.cal.Calendars.detailPanel(p);
});
Lino.cal.Calendars.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.cal.Calendars.GridPanel(p);
});
Lino.cal.Calendars.move_up = function(rp,pk) { 
  Lino.run_row_action(rp,"/cal/Calendars","GET",pk,"move_up",null);
};
Lino.cal.Calendars.move_down = function(rp,pk) { 
  Lino.run_row_action(rp,"/cal/Calendars","GET",pk,"move_down",null);
};

// js_render_GridPanel_class cal.Subscriptions
Lino.cal.Subscriptions.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "Keine Daten anzuzeigen." },
  ls_url : "/cal/Subscriptions",
  ls_bbar_actions : [ { "itemId": null, "menu_item_text": "L\u00f6schen", "tooltip": "Diesen Datensatz l\u00f6schen", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "L\u00f6schen", "auto_save": false } ],
  cell_edit : true,
  title : "Abonnements",
  page_length : 20,
  stripeRows : true,
  disabled_actions_index : 7,
  ls_store_fields : [ { "type": "int", "name": "id" }, { "name": "user" }, 'userHidden', { "name": "calendar" }, 'calendarHidden', { "type": "boolean", "name": "is_hidden" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 0,
  ls_grid_configs : [  ],
  content_type : 34,
  ls_id_property : "id",
  gc_name : 0,
  initComponent : function() {
    var ww = this.containing_window;
    var id3241 = new Ext.form.NumberField({ "selectOnFocus": true });
    var user3242 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "preferred_width": 15, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/Subscriptions/user", "method": "GET" }) }), "pageSize": 20, "emptyText": "Benutzer ausw\u00e4hlen..." });
    var calendar3243 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/Subscriptions/calendar", "method": "GET" }) }), "allowBlank": false, "pageSize": 20, "emptyText": "Kalender ausw\u00e4hlen..." });
    var is_hidden3244 = new Ext.form.Checkbox({ "selectOnFocus": true, "checked": false });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ new Lino.NullNumberColumn({ "colIndex": 0, "sortable": true, "format": "0", "editable": true, "tooltip": "(cal.Subscriptions.id) ", "filter": { "type": "numeric" }, "header": "ID", "renderer": Lino.id_renderer, "editor": id3241, "width": Lino.chars2width(6), "dataIndex": "id" }), { "colIndex": 1, "sortable": true, "header": "Autor", "editable": true, "tooltip": "(cal.Subscriptions.user) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "user", "editor": user3242 }, { "colIndex": 2, "sortable": true, "header": "Kalender", "editable": true, "tooltip": "(cal.Subscriptions.calendar) The calendar you want to subscribe to.\nYou can subscribe to *non-private* calendars of *other* users.", "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('calendarHidden','Lino.cal.Calendars.detail'), "editor": calendar3243, "dataIndex": "calendar" }, { "colIndex": 3, "sortable": false, "xtype": "checkcolumn", "header": "versteckt", "editable": true, "tooltip": "(cal.Subscriptions.is_hidden) Ob dieser Kalender im Kalender-Fenster anfangs deaktiviert sein sol.", "filter": { "type": "boolean" }, "width": Lino.chars2width(11), "dataIndex": "is_hidden" } ];
    Lino.cal.Subscriptions.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.cal.Subscriptions.put = function(rp,pk) { 
  Lino.run_row_action(rp,"/cal/Subscriptions","GET",pk,"put",null);
};
Lino.cal.Subscriptions.post = function(rp,pk) { 
  Lino.run_row_action(rp,"/cal/Subscriptions","GET",pk,"post",null);
};
Lino.cal.Subscriptions.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.cal.Subscriptions.GridPanel(p);
});

// js_render_GridPanel_class cal.Rooms
Lino.cal.Rooms.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "Keine Daten anzuzeigen." },
  ls_url : "/cal/Rooms",
  ls_bbar_actions : [ { "itemId": "insert", "menu_item_text": "Neu", "must_save": true, "tooltip": "Neuen Datensatz erstellen", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-new", "overflowText": "Neu", "auto_save": true }, { "itemId": "detail", "menu_item_text": "Detail", "tooltip": "Detail-Fenster auf diesem Datensatz \u00f6ffnen", "panel_btn_handler": Lino.show_detail, "iconCls": "x-tbar-detail", "overflowText": "Detail", "auto_save": true }, { "itemId": null, "menu_item_text": "L\u00f6schen", "tooltip": "Diesen Datensatz l\u00f6schen", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "L\u00f6schen", "auto_save": false } ],
  cell_edit : true,
  title : "R\u00e4ume",
  page_length : 20,
  stripeRows : true,
  disabled_actions_index : 6,
  ls_store_fields : [ { "type": "int", "name": "id" }, { "name": "name" }, { "name": "name_fr" }, { "name": "name_de" }, { "name": "name_nl" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 0,
  ls_grid_configs : [  ],
  content_type : 30,
  ls_id_property : "id",
  gc_name : 0,
  initComponent : function() {
    this.ls_detail_handler = Lino.cal.Rooms.detail;
    this.ls_insert_handler = Lino.cal.Rooms.insert;
    var ww = this.containing_window;
    var id3246 = new Ext.form.NumberField({ "selectOnFocus": true });
    var name3247 = new Ext.form.TextField({ "selectOnFocus": true, "allowBlank": false, "maxLength": 200 });
    var name_fr3248 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var name_de3249 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var name_nl3250 = new Ext.form.TextField({ "selectOnFocus": true, "hidden": true, "maxLength": 200 });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ new Lino.NullNumberColumn({ "colIndex": 0, "sortable": true, "format": "0", "editable": true, "tooltip": "(cal.Rooms.id) ", "filter": { "type": "numeric" }, "header": "ID", "renderer": Lino.id_renderer, "editor": id3246, "width": Lino.chars2width(6), "dataIndex": "id" }), { "colIndex": 1, "sortable": true, "header": "Bezeichnung", "editable": true, "tooltip": "(cal.Rooms.name) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "name", "editor": name3247 }, { "colIndex": 2, "sortable": true, "header": "Bezeichnung (fr)", "editable": true, "tooltip": "(cal.Rooms.name_fr) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "name_fr", "editor": name_fr3248 }, { "colIndex": 3, "sortable": true, "header": "Bezeichnung (de)", "editable": true, "tooltip": "(cal.Rooms.name_de) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "name_de", "editor": name_de3249 }, { "colIndex": 4, "sortable": true, "header": "Bezeichnung (nl)", "editable": true, "tooltip": "(cal.Rooms.name_nl) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "name_nl", "hidden": true, "editor": name_nl3250 } ];
    Lino.cal.Rooms.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.cal.Rooms.put = function(rp,pk) { 
  Lino.run_row_action(rp,"/cal/Rooms","GET",pk,"put",null);
};
Lino.cal.Rooms.post = function(rp,pk) { 
  Lino.run_row_action(rp,"/cal/Rooms","GET",pk,"post",null);
};

Lino.cal.Rooms.insertPanel = Ext.extend(Lino.cal.Rooms.DetailFormPanel,{
  empty_title: "Neu R\u00e4ume",
  hide_navigator: true,
  ls_bbar_actions: [ { "itemId": "post", "menu_item_text": "Erstellen", "tooltip": "Datensatz erstellen und dann im Detail-Fenster \u00f6ffnen", "panel_btn_handler": function(panel){panel.save(null,true,'post')}, "text": "Erstellen", "overflowText": "Erstellen", "auto_save": false }, { "itemId": "poststay", "menu_item_text": "Erstellen ohne Detail", "tooltip": "Nach Erstellen des Datensatzes kein Detail-Fenster \u00f6ffnen", "panel_btn_handler": function(panel){panel.save(null,false,'poststay')}, "text": "Erstellen ohne Detail", "overflowText": "Erstellen ohne Detail", "auto_save": false } ],
  ls_url: "/cal/Rooms",
  action_name: "insert",
  initComponent : function() {
    this.ls_detail_handler = Lino.cal.Rooms.detail;
    this.ls_insert_handler = Lino.cal.Rooms.insert;
    Lino.cal.Rooms.insertPanel.superclass.initComponent.call(this);
  }
});

Lino.cal.Rooms.insert = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.cal.Rooms.insertPanel(p);
});
Lino.cal.Rooms.poststay = function(rp,pk) { 
  Lino.run_row_action(rp,"/cal/Rooms","GET",pk,"poststay",null);
};

Lino.cal.Rooms.detailPanel = Ext.extend(Lino.cal.Rooms.DetailFormPanel,{
  empty_title: "Detail R\u00e4ume",
  ls_bbar_actions: [ { "itemId": "put", "menu_item_text": "Speichern", "tooltip": "\u00c4nderungen in diesem Formular speichern", "panel_btn_handler": function(panel){panel.save(null,false,'put')}, "iconCls": "x-tbar-save", "overflowText": "Speichern", "auto_save": false }, { "itemId": "insert", "menu_item_text": "Neu", "must_save": true, "tooltip": "Neuen Datensatz erstellen", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-new", "overflowText": "Neu", "auto_save": true }, { "itemId": null, "menu_item_text": "L\u00f6schen", "tooltip": "Diesen Datensatz l\u00f6schen", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "L\u00f6schen", "auto_save": false } ],
  ls_url: "/cal/Rooms",
  action_name: "detail",
  initComponent : function() {
    this.ls_detail_handler = Lino.cal.Rooms.detail;
    this.ls_insert_handler = Lino.cal.Rooms.insert;
    Lino.cal.Rooms.detailPanel.superclass.initComponent.call(this);
  }
});

Lino.cal.Rooms.detail = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.cal.Rooms.detailPanel(p);
});
Lino.cal.Rooms.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.cal.Rooms.GridPanel(p);
});

// js_render_GridPanel_class cal.Priorities
Lino.cal.Priorities.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "Keine Daten anzuzeigen." },
  ls_url : "/cal/Priorities",
  ls_bbar_actions : [ { "itemId": null, "menu_item_text": "L\u00f6schen", "tooltip": "Diesen Datensatz l\u00f6schen", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "L\u00f6schen", "auto_save": false } ],
  cell_edit : true,
  title : "Priorit\u00e4ten",
  page_length : 20,
  stripeRows : true,
  disabled_actions_index : 7,
  ls_store_fields : [ { "name": "name" }, { "name": "name_fr" }, { "name": "name_de" }, { "name": "name_nl" }, { "type": "int", "name": "id" }, { "name": "ref" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 4,
  ls_grid_configs : [  ],
  content_type : 31,
  ls_id_property : "id",
  gc_name : 0,
  initComponent : function() {
    var ww = this.containing_window;
    var name3252 = new Ext.form.TextField({ "selectOnFocus": true, "allowBlank": false, "maxLength": 200 });
    var name_fr3253 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var name_de3254 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var name_nl3255 = new Ext.form.TextField({ "selectOnFocus": true, "hidden": true, "maxLength": 200 });
    var id3256 = new Ext.form.NumberField({ "selectOnFocus": true });
    var ref3257 = new Ext.form.TextField({ "selectOnFocus": true, "allowBlank": false, "maxLength": "1" });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ { "colIndex": 0, "sortable": true, "header": "Bezeichnung", "editable": true, "tooltip": "(cal.Priorities.name) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "name", "editor": name3252 }, { "colIndex": 1, "sortable": true, "header": "Bezeichnung (fr)", "editable": true, "tooltip": "(cal.Priorities.name_fr) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "name_fr", "editor": name_fr3253 }, { "colIndex": 2, "sortable": true, "header": "Bezeichnung (de)", "editable": true, "tooltip": "(cal.Priorities.name_de) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "name_de", "editor": name_de3254 }, { "colIndex": 3, "sortable": true, "header": "Bezeichnung (nl)", "editable": true, "tooltip": "(cal.Priorities.name_nl) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "name_nl", "hidden": true, "editor": name_nl3255 }, new Lino.NullNumberColumn({ "colIndex": 4, "sortable": true, "format": "0", "editable": true, "tooltip": "(cal.Priorities.id) ", "filter": { "type": "numeric" }, "header": "ID", "renderer": Lino.id_renderer, "editor": id3256, "width": Lino.chars2width(6), "dataIndex": "id" }), { "colIndex": 5, "sortable": true, "header": "ref", "editable": true, "tooltip": "(cal.Priorities.ref) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "ref", "editor": ref3257 } ];
    Lino.cal.Priorities.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.cal.Priorities.put = function(rp,pk) { 
  Lino.run_row_action(rp,"/cal/Priorities","GET",pk,"put",null);
};
Lino.cal.Priorities.post = function(rp,pk) { 
  Lino.run_row_action(rp,"/cal/Priorities","GET",pk,"post",null);
};
Lino.cal.Priorities.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.cal.Priorities.GridPanel(p);
});

// js_render_GridPanel_class cal.Events
Lino.cal.Events.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "Keine Daten anzuzeigen." },
  ls_url : "/cal/Events",
  ls_bbar_actions : [ { "itemId": "insert", "menu_item_text": "Neu", "must_save": true, "tooltip": "Neuen Datensatz erstellen", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-new", "overflowText": "Neu", "auto_save": true }, { "itemId": "duplicate", "menu_item_text": "Duplizieren", "must_save": true, "tooltip": "Duplizieren", "panel_btn_handler": Lino.row_action_handler('duplicate','GET',null), "iconCls": "x-tbar-duplicate", "overflowText": "Duplizieren", "auto_save": true }, { "itemId": "detail", "menu_item_text": "Detail", "tooltip": "Detail-Fenster auf diesem Datensatz \u00f6ffnen", "panel_btn_handler": Lino.show_detail, "iconCls": "x-tbar-detail", "overflowText": "Detail", "auto_save": true }, { "itemId": null, "menu_item_text": "L\u00f6schen", "tooltip": "Diesen Datensatz l\u00f6schen", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "L\u00f6schen", "auto_save": false }, { "itemId": "do_print", "menu_item_text": "Drucken", "must_save": true, "tooltip": "Drucken", "panel_btn_handler": Lino.list_action_handler('/cal/Events','do_print','POST',null), "iconCls": "x-tbar-print", "overflowText": "Drucken", "auto_save": true }, { "itemId": "do_clear_cache", "menu_item_text": "Cache l\u00f6schen", "must_save": true, "tooltip": "Cache l\u00f6schen", "panel_btn_handler": Lino.row_action_handler('do_clear_cache','GET',null), "iconCls": "x-tbar-clearcache", "overflowText": "Cache l\u00f6schen", "auto_save": true }, { "itemId": "create_mail", "menu_item_text": "per E-Mail", "must_save": true, "tooltip": "Create an email from this", "panel_btn_handler": Lino.row_action_handler('create_mail','GET',null), "iconCls": "x-tbar-email_add", "overflowText": "per E-Mail", "auto_save": true } ],
  cell_edit : true,
  title : "Termine",
  page_length : 20,
  params_panel_hidden : true,
  stripeRows : true,
  disabled_actions_index : 36,
  ls_store_fields : [ { "name": "when_text" }, { "name": "user" }, 'userHidden', { "name": "summary" }, { "name": "calendar" }, 'calendarHidden', { "type": "int", "name": "id" }, { "name": "owner_type" }, 'owner_typeHidden', { "name": "owner_id" }, 'owner_idHidden', { "name": "created" }, { "name": "modified" }, { "name": "project" }, 'projectHidden', { "name": "build_time" }, { "type": "date", "name": "start_date", "dateFormat": "d.m.Y" }, { "name": "start_time" }, { "type": "date", "name": "end_date", "dateFormat": "d.m.Y" }, { "name": "end_time" }, { "name": "uid" }, { "name": "access_class" }, 'access_classHidden', { "type": "int", "name": "sequence" }, { "type": "int", "name": "auto_type" }, { "type": "boolean", "name": "transparent" }, { "name": "room" }, 'roomHidden', { "name": "priority" }, 'priorityHidden', { "name": "state" }, 'stateHidden', { "name": "assigned_to" }, 'assigned_toHidden', { "name": "owner" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 6,
  ls_grid_configs : [  ],
  content_type : 35,
  ls_id_property : "id",
  gc_name : 0,
  initComponent : function() {
    this.ls_detail_handler = Lino.cal.Events.detail;
    this.ls_insert_handler = Lino.cal.Events.insert;
    var ww = this.containing_window;
    var when_text_disp3259 = new Ext.form.DisplayField({ "disabled": true, "value": "<br/>", "always_enabled": true });
    var user3260 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "preferred_width": 15, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/Events/user", "method": "GET" }) }), "pageSize": 20, "emptyText": "Benutzer ausw\u00e4hlen..." });
    var summary3261 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var calendar3262 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/Events/calendar", "method": "GET" }) }), "pageSize": 20, "emptyText": "Kalender ausw\u00e4hlen..." });
    var id3263 = new Ext.form.NumberField({ "selectOnFocus": true });
    var owner_type3264 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/Events/owner_type", "method": "GET" }) }), "pageSize": 20, "emptyText": "Inhaltstyp ausw\u00e4hlen..." });
    var owner_id3265 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/Events/owner_id", "method": "GET" }) }) });
    var created3266 = new Ext.form.DisplayField({ "disabled": true, "value": "<br>" });
    var modified3267 = new Ext.form.DisplayField({ "disabled": true, "value": "<br>" });
    var project3268 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "preferred_width": 20, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/Events/project", "method": "GET" }) }), "pageSize": 20, "emptyText": "Klient ausw\u00e4hlen..." });
    var build_time3269 = new Ext.form.DisplayField({ "disabled": true, "value": "<br>" });
    var start_date3270 = new Lino.DateField({ "selectOnFocus": true });
    var start_time3271 = new Lino.TimeField({ "selectOnFocus": true });
    var end_date3272 = new Lino.DateField({ "selectOnFocus": true });
    var end_time3273 = new Lino.TimeField({ "selectOnFocus": true });
    var uid3274 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var access_class3275 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "forceSelection": true, "store": [['','<br>']].concat(Lino.cal.AccessClasses) });
    var sequence3276 = new Ext.form.NumberField({ "selectOnFocus": true, "allowBlank": false, "value": 0 });
    var auto_type3277 = new Ext.form.NumberField({ "disabled": true });
    var transparent3278 = new Ext.form.Checkbox({ "selectOnFocus": true, "checked": false });
    var room3279 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/Events/room", "method": "GET" }) }), "pageSize": 20, "emptyText": "Raum ausw\u00e4hlen..." });
    var priority3280 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/Events/priority", "method": "GET" }) }), "pageSize": 20, "emptyText": "Priorit\u00e4t ausw\u00e4hlen..." });
    var state3281 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "forceSelection": true, "allowBlank": false, "store": Lino.cal.EventStates });
    var assigned_to3282 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "preferred_width": 15, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/Events/assigned_to", "method": "GET" }) }), "pageSize": 20, "emptyText": "Benutzer ausw\u00e4hlen..." });
    var owner_disp3283 = new Ext.form.DisplayField({ "disabled": true });
    this.before_row_edit = function(record) {
      owner_id3265.setContextValue('owner_type',record ? record.data['owner_typeHidden'] : undefined);
    };
    this.onRender = function(ct, position) {
      owner_type3264.on('change',Lino.chooser_handler(owner_id3265,'owner_type'));
      Lino.cal.Events.GridPanel.superclass.onRender.call(this, ct, position);
    }
    this.ls_columns = [ { "width": Lino.chars2width(21), "colIndex": 0, "sortable": false, "dataIndex": "when_text", "header": "Wann", "editable": false, "tooltip": "(cal.Events.when_text) " }, { "colIndex": 1, "sortable": true, "header": "Verantwortlicher", "editable": true, "tooltip": "(cal.Events.user) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "user", "editor": user3260 }, { "colIndex": 2, "sortable": true, "header": "Kurzbeschreibung", "editable": true, "tooltip": "(cal.Events.summary) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "summary", "editor": summary3261 }, { "colIndex": 3, "sortable": true, "header": "Kalender", "editable": true, "tooltip": "(cal.Events.calendar) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('calendarHidden','Lino.cal.Calendars.detail'), "editor": calendar3262, "dataIndex": "calendar" }, new Lino.NullNumberColumn({ "colIndex": 4, "sortable": true, "format": "0", "editable": true, "tooltip": "(cal.Events.id) ", "filter": { "type": "numeric" }, "header": "ID", "renderer": Lino.id_renderer, "editor": id3263, "width": Lino.chars2width(6), "dataIndex": "id" }), { "colIndex": 5, "sortable": true, "header": "Verkn\u00fcpft mit (Modell)", "editable": true, "tooltip": "(cal.Events.owner_type) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "owner_type", "hidden": true, "editor": owner_type3264 }, { "colIndex": 6, "sortable": true, "header": "Verkn\u00fcpft mit (Objekt)", "editable": true, "tooltip": "(cal.Events.owner_id) ", "filter": { "type": "string" }, "width": Lino.chars2width(11), "dataIndex": "owner_id", "hidden": true, "editor": owner_id3265 }, { "colIndex": 7, "sortable": true, "header": "Erstellt", "editable": false, "tooltip": "(cal.Events.created) ", "width": Lino.chars2width(17), "dataIndex": "created", "hidden": true }, { "colIndex": 8, "sortable": true, "header": "Bearbeitet", "editable": false, "tooltip": "(cal.Events.modified) ", "width": Lino.chars2width(17), "dataIndex": "modified", "hidden": true }, { "colIndex": 9, "sortable": true, "header": "Klient", "editable": true, "tooltip": "(cal.Events.project) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('projectHidden','Lino.pcsw.Clients.detail'), "editor": project3268, "dataIndex": "project" }, { "colIndex": 10, "sortable": true, "header": "Druckdatum", "editable": false, "tooltip": "(cal.Events.build_time) ", "width": Lino.chars2width(17), "dataIndex": "build_time", "hidden": true }, { "colIndex": 11, "sortable": true, "xtype": "datecolumn", "format": "d.m.Y", "editable": true, "tooltip": "(cal.Events.start_date) ", "filter": { "type": "date", "dateFormat": "d.m.Y" }, "header": "Beginnt am", "dataIndex": "start_date", "width": Lino.chars2width(9), "editor": start_date3270 }, { "colIndex": 12, "sortable": true, "header": "Beginnt um", "editable": true, "tooltip": "(cal.Events.start_time) ", "width": Lino.chars2width(9), "dataIndex": "start_time", "editor": start_time3271 }, { "colIndex": 13, "sortable": true, "xtype": "datecolumn", "format": "d.m.Y", "editable": true, "tooltip": "(cal.Events.end_date) ", "filter": { "type": "date", "dateFormat": "d.m.Y" }, "header": "Endet am", "dataIndex": "end_date", "hidden": true, "width": Lino.chars2width(9), "editor": end_date3272 }, { "colIndex": 14, "sortable": true, "header": "Endet um", "editable": true, "tooltip": "(cal.Events.end_time) ", "width": Lino.chars2width(9), "dataIndex": "end_time", "hidden": true, "editor": end_time3273 }, { "colIndex": 15, "sortable": true, "header": "UID", "editable": true, "tooltip": "(cal.Events.uid) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "uid", "hidden": true, "editor": uid3274 }, { "colIndex": 16, "sortable": true, "header": "Zugriffsklasse", "editable": true, "tooltip": "(cal.Events.access_class) Ob dieser Termin  privat, \u00f6ffentlich oder halb \u00f6ffentlich ist", "filter": { "type": "string" }, "width": Lino.chars2width(13), "dataIndex": "access_class", "hidden": true, "editor": access_class3275 }, new Lino.NullNumberColumn({ "colIndex": 17, "sortable": true, "format": "0", "editable": true, "tooltip": "(cal.Events.sequence) ", "filter": { "type": "numeric" }, "header": "Revisionsnummer", "dataIndex": "sequence", "hidden": true, "width": Lino.chars2width(6), "editor": sequence3276 }), new Lino.NullNumberColumn({ "colIndex": 18, "sortable": true, "format": "0", "editable": false, "tooltip": "(cal.Events.auto_type) ", "filter": { "type": "numeric" }, "header": "auto type", "dataIndex": "auto_type", "hidden": true, "width": Lino.chars2width(6) }), { "colIndex": 19, "sortable": false, "xtype": "checkcolumn", "header": "nicht blockierend", "editable": true, "tooltip": "(cal.Events.transparent) Dieser Termin l\u00e4sst auch andere Termine zur gleichen Zeit zu.", "filter": { "type": "boolean" }, "width": Lino.chars2width(11), "dataIndex": "transparent", "hidden": true }, { "colIndex": 20, "sortable": true, "header": "Raum", "editable": true, "tooltip": "(cal.Events.room) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('roomHidden','Lino.cal.Rooms.detail'), "editor": room3279, "dataIndex": "room" }, { "colIndex": 21, "sortable": true, "header": "Priorit\u00e4t", "editable": true, "tooltip": "(cal.Events.priority) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "priority", "hidden": true, "editor": priority3280 }, { "colIndex": 22, "sortable": true, "header": "Zustand", "editable": true, "tooltip": "(cal.Events.state) ", "filter": { "type": "string" }, "width": Lino.chars2width(14), "dataIndex": "state", "editor": state3281 }, { "colIndex": 23, "sortable": true, "header": "Zugewiesen zu", "editable": true, "tooltip": "(cal.Events.assigned_to) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "assigned_to", "editor": assigned_to3282 }, { "colIndex": 24, "sortable": false, "header": "Verkn\u00fcpft mit", "editable": false, "tooltip": "(cal.Events.owner) ", "width": Lino.chars2width(11), "dataIndex": "owner", "hidden": true } ];
    Lino.cal.Events.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.cal.Events.put = function(rp,pk) { 
  Lino.run_row_action(rp,"/cal/Events","GET",pk,"put",null);
};
Lino.cal.Events.post = function(rp,pk) { 
  Lino.run_row_action(rp,"/cal/Events","GET",pk,"post",null);
};

Lino.cal.Events.insertPanel = Ext.extend(Lino.cal.Events.InsertFormPanel,{
  empty_title: "Neu Termine",
  hide_navigator: true,
  params_panel_hidden: true,
  ls_bbar_actions: [ { "itemId": "post", "menu_item_text": "Erstellen", "tooltip": "Datensatz erstellen und dann im Detail-Fenster \u00f6ffnen", "panel_btn_handler": function(panel){panel.save(null,true,'post')}, "text": "Erstellen", "overflowText": "Erstellen", "auto_save": false }, { "itemId": "poststay", "menu_item_text": "Erstellen ohne Detail", "tooltip": "Nach Erstellen des Datensatzes kein Detail-Fenster \u00f6ffnen", "panel_btn_handler": function(panel){panel.save(null,false,'poststay')}, "text": "Erstellen ohne Detail", "overflowText": "Erstellen ohne Detail", "auto_save": false } ],
  ls_url: "/cal/Events",
  action_name: "insert",
  initComponent : function() {
    this.ls_detail_handler = Lino.cal.Events.detail;
    this.ls_insert_handler = Lino.cal.Events.insert;
    Lino.cal.Events.insertPanel.superclass.initComponent.call(this);
  }
});

Lino.cal.Events.insert = new Lino.WindowAction({ "draggable": true, "width": Lino.chars2width(60), "autoHeight": true, "maximizable": true, "modal": true, "maximized": false },function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.cal.Events.insertPanel(p);
});
Lino.cal.Events.wf1 = function(rp,pk) { 
  Lino.run_row_action(rp,"/cal/Events","GET",pk,"wf1",null);
};
Lino.cal.Events.poststay = function(rp,pk) { 
  Lino.run_row_action(rp,"/cal/Events","GET",pk,"poststay",null);
};
Lino.cal.Events.duplicate = function(rp,pk) { 
  Lino.run_row_action(rp,"/cal/Events","GET",pk,"duplicate",null);
};
Lino.cal.Events.wf2 = function(rp,pk) { 
  Lino.run_row_action(rp,"/cal/Events","GET",pk,"wf2",null);
};
Lino.cal.Events.wf3 = function(rp,pk) { 
  Lino.run_row_action(rp,"/cal/Events","GET",pk,"wf3",null);
};
Lino.cal.Events.wf4 = function(rp,pk) { 
  Lino.run_row_action(rp,"/cal/Events","GET",pk,"wf4",null);
};

Lino.cal.Events.detailPanel = Ext.extend(Lino.cal.Events.DetailFormPanel,{
  empty_title: "Detail Termine",
  params_panel_hidden: true,
  ls_bbar_actions: [ { "itemId": "put", "menu_item_text": "Speichern", "tooltip": "\u00c4nderungen in diesem Formular speichern", "panel_btn_handler": function(panel){panel.save(null,false,'put')}, "iconCls": "x-tbar-save", "overflowText": "Speichern", "auto_save": false }, { "itemId": "insert", "menu_item_text": "Neu", "must_save": true, "tooltip": "Neuen Datensatz erstellen", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-new", "overflowText": "Neu", "auto_save": true }, { "itemId": "duplicate", "menu_item_text": "Duplizieren", "must_save": true, "tooltip": "Duplizieren", "panel_btn_handler": Lino.row_action_handler('duplicate','GET',null), "iconCls": "x-tbar-duplicate", "overflowText": "Duplizieren", "auto_save": true }, { "itemId": null, "menu_item_text": "L\u00f6schen", "tooltip": "Diesen Datensatz l\u00f6schen", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "L\u00f6schen", "auto_save": false }, { "itemId": "do_print", "menu_item_text": "Drucken", "must_save": true, "tooltip": "Drucken", "panel_btn_handler": Lino.list_action_handler('/cal/Events','do_print','POST',null), "iconCls": "x-tbar-print", "overflowText": "Drucken", "auto_save": true }, { "itemId": "do_clear_cache", "menu_item_text": "Cache l\u00f6schen", "must_save": true, "tooltip": "Cache l\u00f6schen", "panel_btn_handler": Lino.row_action_handler('do_clear_cache','GET',null), "iconCls": "x-tbar-clearcache", "overflowText": "Cache l\u00f6schen", "auto_save": true }, { "itemId": "create_mail", "menu_item_text": "per E-Mail", "must_save": true, "tooltip": "Create an email from this", "panel_btn_handler": Lino.row_action_handler('create_mail','GET',null), "iconCls": "x-tbar-email_add", "overflowText": "per E-Mail", "auto_save": true } ],
  ls_url: "/cal/Events",
  action_name: "detail",
  initComponent : function() {
    this.ls_detail_handler = Lino.cal.Events.detail;
    this.ls_insert_handler = Lino.cal.Events.insert;
    Lino.cal.Events.detailPanel.superclass.initComponent.call(this);
  }
});

Lino.cal.Events.detail = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.cal.Events.detailPanel(p);
});
Lino.cal.Events.do_print = function(rp,pk) { 
  Lino.run_row_action(rp,"/cal/Events","POST",pk,"do_print",null);
};
Lino.cal.Events.do_clear_cache = function(rp,pk) { 
  Lino.run_row_action(rp,"/cal/Events","GET",pk,"do_clear_cache",null);
};
Lino.cal.Events.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  p.params_panel = new Lino.cal.Events.ParamsPanel({});
  return new Lino.cal.Events.GridPanel(p);
});
Lino.cal.Events.create_mail = function(rp,pk) { 
  Lino.run_row_action(rp,"/cal/Events","GET",pk,"create_mail",null);
};
Lino.cal.Events.take = function(rp,pk) { 
  Lino.run_row_action(rp,"/cal/Events","GET",pk,"take",null);
};

// js_render_GridPanel_class cal.OneEvent
Lino.cal.OneEvent.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "Keine Daten anzuzeigen." },
  ls_url : "/cal/OneEvent",
  ls_bbar_actions : [ { "itemId": "insert", "menu_item_text": "Neu", "must_save": true, "tooltip": "Neuen Datensatz erstellen", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-new", "overflowText": "Neu", "auto_save": true }, { "itemId": "duplicate", "menu_item_text": "Duplizieren", "must_save": true, "tooltip": "Duplizieren", "panel_btn_handler": Lino.row_action_handler('duplicate','GET',null), "iconCls": "x-tbar-duplicate", "overflowText": "Duplizieren", "auto_save": true }, { "itemId": "detail", "menu_item_text": "Detail", "tooltip": "Detail-Fenster auf diesem Datensatz \u00f6ffnen", "panel_btn_handler": Lino.show_detail, "iconCls": "x-tbar-detail", "overflowText": "Detail", "auto_save": true }, { "itemId": null, "menu_item_text": "L\u00f6schen", "tooltip": "Diesen Datensatz l\u00f6schen", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "L\u00f6schen", "auto_save": false }, { "itemId": "do_print", "menu_item_text": "Drucken", "must_save": true, "tooltip": "Drucken", "panel_btn_handler": Lino.list_action_handler('/cal/OneEvent','do_print','POST',null), "iconCls": "x-tbar-print", "overflowText": "Drucken", "auto_save": true }, { "itemId": "do_clear_cache", "menu_item_text": "Cache l\u00f6schen", "must_save": true, "tooltip": "Cache l\u00f6schen", "panel_btn_handler": Lino.row_action_handler('do_clear_cache','GET',null), "iconCls": "x-tbar-clearcache", "overflowText": "Cache l\u00f6schen", "auto_save": true }, { "itemId": "create_mail", "menu_item_text": "per E-Mail", "must_save": true, "tooltip": "Create an email from this", "panel_btn_handler": Lino.row_action_handler('create_mail','GET',null), "iconCls": "x-tbar-email_add", "overflowText": "per E-Mail", "auto_save": true } ],
  cell_edit : true,
  title : "Termine",
  page_length : 20,
  params_panel_hidden : true,
  stripeRows : true,
  disabled_actions_index : 36,
  ls_store_fields : [ { "name": "when_text" }, { "name": "user" }, 'userHidden', { "name": "summary" }, { "name": "calendar" }, 'calendarHidden', { "type": "int", "name": "id" }, { "name": "owner_type" }, 'owner_typeHidden', { "name": "owner_id" }, 'owner_idHidden', { "name": "created" }, { "name": "modified" }, { "name": "project" }, 'projectHidden', { "name": "build_time" }, { "type": "date", "name": "start_date", "dateFormat": "d.m.Y" }, { "name": "start_time" }, { "type": "date", "name": "end_date", "dateFormat": "d.m.Y" }, { "name": "end_time" }, { "name": "uid" }, { "name": "access_class" }, 'access_classHidden', { "type": "int", "name": "sequence" }, { "type": "int", "name": "auto_type" }, { "type": "boolean", "name": "transparent" }, { "name": "room" }, 'roomHidden', { "name": "priority" }, 'priorityHidden', { "name": "state" }, 'stateHidden', { "name": "assigned_to" }, 'assigned_toHidden', { "name": "owner" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 6,
  ls_grid_configs : [  ],
  content_type : 35,
  ls_id_property : "id",
  gc_name : 0,
  initComponent : function() {
    this.ls_detail_handler = Lino.cal.OneEvent.detail;
    this.ls_insert_handler = Lino.cal.OneEvent.insert;
    var ww = this.containing_window;
    var when_text_disp3285 = new Ext.form.DisplayField({ "disabled": true, "value": "<br/>", "always_enabled": true });
    var user3286 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "preferred_width": 15, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/OneEvent/user", "method": "GET" }) }), "pageSize": 20, "emptyText": "Benutzer ausw\u00e4hlen..." });
    var summary3287 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var calendar3288 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/OneEvent/calendar", "method": "GET" }) }), "pageSize": 20, "emptyText": "Kalender ausw\u00e4hlen..." });
    var id3289 = new Ext.form.NumberField({ "selectOnFocus": true });
    var owner_type3290 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/OneEvent/owner_type", "method": "GET" }) }), "pageSize": 20, "emptyText": "Inhaltstyp ausw\u00e4hlen..." });
    var owner_id3291 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/OneEvent/owner_id", "method": "GET" }) }) });
    var created3292 = new Ext.form.DisplayField({ "disabled": true, "value": "<br>" });
    var modified3293 = new Ext.form.DisplayField({ "disabled": true, "value": "<br>" });
    var project3294 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "preferred_width": 20, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/OneEvent/project", "method": "GET" }) }), "pageSize": 20, "emptyText": "Klient ausw\u00e4hlen..." });
    var build_time3295 = new Ext.form.DisplayField({ "disabled": true, "value": "<br>" });
    var start_date3296 = new Lino.DateField({ "selectOnFocus": true });
    var start_time3297 = new Lino.TimeField({ "selectOnFocus": true });
    var end_date3298 = new Lino.DateField({ "selectOnFocus": true });
    var end_time3299 = new Lino.TimeField({ "selectOnFocus": true });
    var uid3300 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var access_class3301 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "forceSelection": true, "store": [['','<br>']].concat(Lino.cal.AccessClasses) });
    var sequence3302 = new Ext.form.NumberField({ "selectOnFocus": true, "allowBlank": false, "value": 0 });
    var auto_type3303 = new Ext.form.NumberField({ "disabled": true });
    var transparent3304 = new Ext.form.Checkbox({ "selectOnFocus": true, "checked": false });
    var room3305 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/OneEvent/room", "method": "GET" }) }), "pageSize": 20, "emptyText": "Raum ausw\u00e4hlen..." });
    var priority3306 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/OneEvent/priority", "method": "GET" }) }), "pageSize": 20, "emptyText": "Priorit\u00e4t ausw\u00e4hlen..." });
    var state3307 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "forceSelection": true, "allowBlank": false, "store": Lino.cal.EventStates });
    var assigned_to3308 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "preferred_width": 15, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/OneEvent/assigned_to", "method": "GET" }) }), "pageSize": 20, "emptyText": "Benutzer ausw\u00e4hlen..." });
    var owner_disp3309 = new Ext.form.DisplayField({ "disabled": true });
    this.before_row_edit = function(record) {
      owner_id3291.setContextValue('owner_type',record ? record.data['owner_typeHidden'] : undefined);
    };
    this.onRender = function(ct, position) {
      owner_type3290.on('change',Lino.chooser_handler(owner_id3291,'owner_type'));
      Lino.cal.OneEvent.GridPanel.superclass.onRender.call(this, ct, position);
    }
    this.ls_columns = [ { "width": Lino.chars2width(21), "colIndex": 0, "sortable": false, "dataIndex": "when_text", "header": "Wann", "editable": false, "tooltip": "(cal.OneEvent.when_text) " }, { "colIndex": 1, "sortable": true, "header": "Verantwortlicher", "editable": true, "tooltip": "(cal.OneEvent.user) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "user", "editor": user3286 }, { "colIndex": 2, "sortable": true, "header": "Kurzbeschreibung", "editable": true, "tooltip": "(cal.OneEvent.summary) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "summary", "editor": summary3287 }, { "colIndex": 3, "sortable": true, "header": "Kalender", "editable": true, "tooltip": "(cal.OneEvent.calendar) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('calendarHidden','Lino.cal.Calendars.detail'), "editor": calendar3288, "dataIndex": "calendar" }, new Lino.NullNumberColumn({ "colIndex": 4, "sortable": true, "format": "0", "editable": true, "tooltip": "(cal.OneEvent.id) ", "filter": { "type": "numeric" }, "header": "ID", "renderer": Lino.id_renderer, "editor": id3289, "width": Lino.chars2width(6), "dataIndex": "id" }), { "colIndex": 5, "sortable": true, "header": "Verkn\u00fcpft mit (Modell)", "editable": true, "tooltip": "(cal.OneEvent.owner_type) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "owner_type", "hidden": true, "editor": owner_type3290 }, { "colIndex": 6, "sortable": true, "header": "Verkn\u00fcpft mit (Objekt)", "editable": true, "tooltip": "(cal.OneEvent.owner_id) ", "filter": { "type": "string" }, "width": Lino.chars2width(11), "dataIndex": "owner_id", "hidden": true, "editor": owner_id3291 }, { "colIndex": 7, "sortable": true, "header": "Erstellt", "editable": false, "tooltip": "(cal.OneEvent.created) ", "width": Lino.chars2width(17), "dataIndex": "created", "hidden": true }, { "colIndex": 8, "sortable": true, "header": "Bearbeitet", "editable": false, "tooltip": "(cal.OneEvent.modified) ", "width": Lino.chars2width(17), "dataIndex": "modified", "hidden": true }, { "colIndex": 9, "sortable": true, "header": "Klient", "editable": true, "tooltip": "(cal.OneEvent.project) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('projectHidden','Lino.pcsw.Clients.detail'), "editor": project3294, "dataIndex": "project" }, { "colIndex": 10, "sortable": true, "header": "Druckdatum", "editable": false, "tooltip": "(cal.OneEvent.build_time) ", "width": Lino.chars2width(17), "dataIndex": "build_time", "hidden": true }, { "colIndex": 11, "sortable": true, "xtype": "datecolumn", "format": "d.m.Y", "editable": true, "tooltip": "(cal.OneEvent.start_date) ", "filter": { "type": "date", "dateFormat": "d.m.Y" }, "header": "Beginnt am", "dataIndex": "start_date", "width": Lino.chars2width(9), "editor": start_date3296 }, { "colIndex": 12, "sortable": true, "header": "Beginnt um", "editable": true, "tooltip": "(cal.OneEvent.start_time) ", "width": Lino.chars2width(9), "dataIndex": "start_time", "editor": start_time3297 }, { "colIndex": 13, "sortable": true, "xtype": "datecolumn", "format": "d.m.Y", "editable": true, "tooltip": "(cal.OneEvent.end_date) ", "filter": { "type": "date", "dateFormat": "d.m.Y" }, "header": "Endet am", "dataIndex": "end_date", "hidden": true, "width": Lino.chars2width(9), "editor": end_date3298 }, { "colIndex": 14, "sortable": true, "header": "Endet um", "editable": true, "tooltip": "(cal.OneEvent.end_time) ", "width": Lino.chars2width(9), "dataIndex": "end_time", "hidden": true, "editor": end_time3299 }, { "colIndex": 15, "sortable": true, "header": "UID", "editable": true, "tooltip": "(cal.OneEvent.uid) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "uid", "hidden": true, "editor": uid3300 }, { "colIndex": 16, "sortable": true, "header": "Zugriffsklasse", "editable": true, "tooltip": "(cal.OneEvent.access_class) Ob dieser Termin  privat, \u00f6ffentlich oder halb \u00f6ffentlich ist", "filter": { "type": "string" }, "width": Lino.chars2width(13), "dataIndex": "access_class", "hidden": true, "editor": access_class3301 }, new Lino.NullNumberColumn({ "colIndex": 17, "sortable": true, "format": "0", "editable": true, "tooltip": "(cal.OneEvent.sequence) ", "filter": { "type": "numeric" }, "header": "Revisionsnummer", "dataIndex": "sequence", "hidden": true, "width": Lino.chars2width(6), "editor": sequence3302 }), new Lino.NullNumberColumn({ "colIndex": 18, "sortable": true, "format": "0", "editable": false, "tooltip": "(cal.OneEvent.auto_type) ", "filter": { "type": "numeric" }, "header": "auto type", "dataIndex": "auto_type", "hidden": true, "width": Lino.chars2width(6) }), { "colIndex": 19, "sortable": false, "xtype": "checkcolumn", "header": "nicht blockierend", "editable": true, "tooltip": "(cal.OneEvent.transparent) Dieser Termin l\u00e4sst auch andere Termine zur gleichen Zeit zu.", "filter": { "type": "boolean" }, "width": Lino.chars2width(11), "dataIndex": "transparent", "hidden": true }, { "colIndex": 20, "sortable": true, "header": "Raum", "editable": true, "tooltip": "(cal.OneEvent.room) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('roomHidden','Lino.cal.Rooms.detail'), "editor": room3305, "dataIndex": "room" }, { "colIndex": 21, "sortable": true, "header": "Priorit\u00e4t", "editable": true, "tooltip": "(cal.OneEvent.priority) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "priority", "hidden": true, "editor": priority3306 }, { "colIndex": 22, "sortable": true, "header": "Zustand", "editable": true, "tooltip": "(cal.OneEvent.state) ", "filter": { "type": "string" }, "width": Lino.chars2width(14), "dataIndex": "state", "editor": state3307 }, { "colIndex": 23, "sortable": true, "header": "Zugewiesen zu", "editable": true, "tooltip": "(cal.OneEvent.assigned_to) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "assigned_to", "editor": assigned_to3308 }, { "colIndex": 24, "sortable": false, "header": "Verkn\u00fcpft mit", "editable": false, "tooltip": "(cal.OneEvent.owner) ", "width": Lino.chars2width(11), "dataIndex": "owner", "hidden": true } ];
    Lino.cal.OneEvent.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.cal.OneEvent.put = function(rp,pk) { 
  Lino.run_row_action(rp,"/cal/OneEvent","GET",pk,"put",null);
};
Lino.cal.OneEvent.post = function(rp,pk) { 
  Lino.run_row_action(rp,"/cal/OneEvent","GET",pk,"post",null);
};

Lino.cal.OneEvent.insertPanel = Ext.extend(Lino.cal.Events.InsertFormPanel,{
  empty_title: "Neu Termine",
  hide_navigator: true,
  params_panel_hidden: true,
  ls_bbar_actions: [ { "itemId": "post", "menu_item_text": "Erstellen", "tooltip": "Datensatz erstellen und dann im Detail-Fenster \u00f6ffnen", "panel_btn_handler": function(panel){panel.save(null,true,'post')}, "text": "Erstellen", "overflowText": "Erstellen", "auto_save": false }, { "itemId": "poststay", "menu_item_text": "Erstellen ohne Detail", "tooltip": "Nach Erstellen des Datensatzes kein Detail-Fenster \u00f6ffnen", "panel_btn_handler": function(panel){panel.save(null,false,'poststay')}, "text": "Erstellen ohne Detail", "overflowText": "Erstellen ohne Detail", "auto_save": false } ],
  ls_url: "/cal/OneEvent",
  action_name: "insert",
  initComponent : function() {
    this.ls_detail_handler = Lino.cal.OneEvent.detail;
    this.ls_insert_handler = Lino.cal.OneEvent.insert;
    Lino.cal.OneEvent.insertPanel.superclass.initComponent.call(this);
  }
});

Lino.cal.OneEvent.insert = new Lino.WindowAction({ "draggable": true, "width": Lino.chars2width(60), "autoHeight": true, "maximizable": true, "modal": true, "maximized": false },function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.cal.OneEvent.insertPanel(p);
});
Lino.cal.OneEvent.wf1 = function(rp,pk) { 
  Lino.run_row_action(rp,"/cal/OneEvent","GET",pk,"wf1",null);
};
Lino.cal.OneEvent.poststay = function(rp,pk) { 
  Lino.run_row_action(rp,"/cal/OneEvent","GET",pk,"poststay",null);
};
Lino.cal.OneEvent.duplicate = function(rp,pk) { 
  Lino.run_row_action(rp,"/cal/OneEvent","GET",pk,"duplicate",null);
};
Lino.cal.OneEvent.wf2 = function(rp,pk) { 
  Lino.run_row_action(rp,"/cal/OneEvent","GET",pk,"wf2",null);
};
Lino.cal.OneEvent.wf3 = function(rp,pk) { 
  Lino.run_row_action(rp,"/cal/OneEvent","GET",pk,"wf3",null);
};
Lino.cal.OneEvent.wf4 = function(rp,pk) { 
  Lino.run_row_action(rp,"/cal/OneEvent","GET",pk,"wf4",null);
};

Lino.cal.OneEvent.detailPanel = Ext.extend(Lino.cal.Events.DetailFormPanel,{
  empty_title: "Detail Termine",
  params_panel_hidden: true,
  ls_bbar_actions: [ { "itemId": "put", "menu_item_text": "Speichern", "tooltip": "\u00c4nderungen in diesem Formular speichern", "panel_btn_handler": function(panel){panel.save(null,false,'put')}, "iconCls": "x-tbar-save", "overflowText": "Speichern", "auto_save": false }, { "itemId": "insert", "menu_item_text": "Neu", "must_save": true, "tooltip": "Neuen Datensatz erstellen", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-new", "overflowText": "Neu", "auto_save": true }, { "itemId": "duplicate", "menu_item_text": "Duplizieren", "must_save": true, "tooltip": "Duplizieren", "panel_btn_handler": Lino.row_action_handler('duplicate','GET',null), "iconCls": "x-tbar-duplicate", "overflowText": "Duplizieren", "auto_save": true }, { "itemId": null, "menu_item_text": "L\u00f6schen", "tooltip": "Diesen Datensatz l\u00f6schen", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "L\u00f6schen", "auto_save": false }, { "itemId": "do_print", "menu_item_text": "Drucken", "must_save": true, "tooltip": "Drucken", "panel_btn_handler": Lino.list_action_handler('/cal/OneEvent','do_print','POST',null), "iconCls": "x-tbar-print", "overflowText": "Drucken", "auto_save": true }, { "itemId": "do_clear_cache", "menu_item_text": "Cache l\u00f6schen", "must_save": true, "tooltip": "Cache l\u00f6schen", "panel_btn_handler": Lino.row_action_handler('do_clear_cache','GET',null), "iconCls": "x-tbar-clearcache", "overflowText": "Cache l\u00f6schen", "auto_save": true }, { "itemId": "create_mail", "menu_item_text": "per E-Mail", "must_save": true, "tooltip": "Create an email from this", "panel_btn_handler": Lino.row_action_handler('create_mail','GET',null), "iconCls": "x-tbar-email_add", "overflowText": "per E-Mail", "auto_save": true } ],
  ls_url: "/cal/OneEvent",
  action_name: "detail",
  initComponent : function() {
    this.ls_detail_handler = Lino.cal.OneEvent.detail;
    this.ls_insert_handler = Lino.cal.OneEvent.insert;
    Lino.cal.OneEvent.detailPanel.superclass.initComponent.call(this);
  }
});

Lino.cal.OneEvent.detail = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.cal.OneEvent.detailPanel(p);
});
Lino.cal.OneEvent.do_print = function(rp,pk) { 
  Lino.run_row_action(rp,"/cal/OneEvent","POST",pk,"do_print",null);
};
Lino.cal.OneEvent.do_clear_cache = function(rp,pk) { 
  Lino.run_row_action(rp,"/cal/OneEvent","GET",pk,"do_clear_cache",null);
};
Lino.cal.OneEvent.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  p.params_panel = new Lino.cal.Events.ParamsPanel({});
  return new Lino.cal.OneEvent.GridPanel(p);
});
Lino.cal.OneEvent.create_mail = function(rp,pk) { 
  Lino.run_row_action(rp,"/cal/OneEvent","GET",pk,"create_mail",null);
};
Lino.cal.OneEvent.take = function(rp,pk) { 
  Lino.run_row_action(rp,"/cal/OneEvent","GET",pk,"take",null);
};

// js_render_GridPanel_class cal.MyEvents
Lino.cal.MyEvents.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "Keine Daten anzuzeigen." },
  ls_url : "/cal/MyEvents",
  ls_bbar_actions : [ { "itemId": "insert", "menu_item_text": "Neu", "must_save": true, "tooltip": "Neuen Datensatz erstellen", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-new", "overflowText": "Neu", "auto_save": true }, { "itemId": "duplicate", "menu_item_text": "Duplizieren", "must_save": true, "tooltip": "Duplizieren", "panel_btn_handler": Lino.row_action_handler('duplicate','GET',null), "iconCls": "x-tbar-duplicate", "overflowText": "Duplizieren", "auto_save": true }, { "itemId": "detail", "menu_item_text": "Detail", "tooltip": "Detail-Fenster auf diesem Datensatz \u00f6ffnen", "panel_btn_handler": Lino.show_detail, "iconCls": "x-tbar-detail", "overflowText": "Detail", "auto_save": true }, { "itemId": null, "menu_item_text": "L\u00f6schen", "tooltip": "Diesen Datensatz l\u00f6schen", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "L\u00f6schen", "auto_save": false }, { "itemId": "do_print", "menu_item_text": "Drucken", "must_save": true, "tooltip": "Drucken", "panel_btn_handler": Lino.list_action_handler('/cal/MyEvents','do_print','POST',null), "iconCls": "x-tbar-print", "overflowText": "Drucken", "auto_save": true }, { "itemId": "do_clear_cache", "menu_item_text": "Cache l\u00f6schen", "must_save": true, "tooltip": "Cache l\u00f6schen", "panel_btn_handler": Lino.row_action_handler('do_clear_cache','GET',null), "iconCls": "x-tbar-clearcache", "overflowText": "Cache l\u00f6schen", "auto_save": true }, { "itemId": "create_mail", "menu_item_text": "per E-Mail", "must_save": true, "tooltip": "Create an email from this", "panel_btn_handler": Lino.row_action_handler('create_mail','GET',null), "iconCls": "x-tbar-email_add", "overflowText": "per E-Mail", "auto_save": true } ],
  cell_edit : true,
  title : "Meine Termine",
  page_length : 20,
  params_panel_hidden : true,
  stripeRows : true,
  disabled_actions_index : 7,
  ls_store_fields : [ { "name": "when_text" }, { "name": "summary" }, { "name": "workflow_buttons" }, { "name": "project" }, 'projectHidden', { "type": "int", "name": "id" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 5,
  ls_grid_configs : [  ],
  content_type : 35,
  ls_id_property : "id",
  gc_name : 0,
  initComponent : function() {
    this.ls_detail_handler = Lino.cal.MyEvents.detail;
    this.ls_insert_handler = Lino.cal.MyEvents.insert;
    var ww = this.containing_window;
    var when_text_disp3311 = new Ext.form.DisplayField({ "disabled": true, "value": "<br/>", "always_enabled": true });
    var summary3312 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var workflow_buttons_disp3313 = new Ext.form.DisplayField({ "disabled": true, "value": "<br/>", "always_enabled": true });
    var project3314 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "preferred_width": 20, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/MyEvents/project", "method": "GET" }) }), "pageSize": 20, "emptyText": "Klient ausw\u00e4hlen..." });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ { "width": Lino.chars2width(31), "colIndex": 0, "sortable": false, "dataIndex": "when_text", "header": "Wann", "editable": false, "tooltip": "(cal.MyEvents.when_text) " }, { "colIndex": 1, "sortable": true, "header": "Kurzbeschreibung", "editable": true, "tooltip": "(cal.MyEvents.summary) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "summary", "editor": summary3312 }, { "width": Lino.chars2width(31), "colIndex": 2, "sortable": false, "dataIndex": "workflow_buttons", "header": "Arbeitsablauf", "editable": false, "tooltip": "(cal.MyEvents.workflow_buttons) " }, { "colIndex": 3, "sortable": true, "header": "Klient", "editable": true, "tooltip": "(cal.MyEvents.project) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('projectHidden','Lino.pcsw.Clients.detail'), "editor": project3314, "dataIndex": "project" } ];
    Lino.cal.MyEvents.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.cal.MyEvents.put = function(rp,pk) { 
  Lino.run_row_action(rp,"/cal/MyEvents","GET",pk,"put",null);
};
Lino.cal.MyEvents.post = function(rp,pk) { 
  Lino.run_row_action(rp,"/cal/MyEvents","GET",pk,"post",null);
};

Lino.cal.MyEvents.insertPanel = Ext.extend(Lino.cal.Events.InsertFormPanel,{
  empty_title: "Neu Meine Termine",
  hide_navigator: true,
  params_panel_hidden: true,
  ls_bbar_actions: [ { "itemId": "post", "menu_item_text": "Erstellen", "tooltip": "Datensatz erstellen und dann im Detail-Fenster \u00f6ffnen", "panel_btn_handler": function(panel){panel.save(null,true,'post')}, "text": "Erstellen", "overflowText": "Erstellen", "auto_save": false }, { "itemId": "poststay", "menu_item_text": "Erstellen ohne Detail", "tooltip": "Nach Erstellen des Datensatzes kein Detail-Fenster \u00f6ffnen", "panel_btn_handler": function(panel){panel.save(null,false,'poststay')}, "text": "Erstellen ohne Detail", "overflowText": "Erstellen ohne Detail", "auto_save": false } ],
  ls_url: "/cal/MyEvents",
  action_name: "insert",
  initComponent : function() {
    this.ls_detail_handler = Lino.cal.MyEvents.detail;
    this.ls_insert_handler = Lino.cal.MyEvents.insert;
    Lino.cal.MyEvents.insertPanel.superclass.initComponent.call(this);
  }
});

Lino.cal.MyEvents.insert = new Lino.WindowAction({ "draggable": true, "width": Lino.chars2width(60), "autoHeight": true, "maximizable": true, "modal": true, "maximized": false },function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.cal.MyEvents.insertPanel(p);
});
Lino.cal.MyEvents.wf1 = function(rp,pk) { 
  Lino.run_row_action(rp,"/cal/MyEvents","GET",pk,"wf1",null);
};
Lino.cal.MyEvents.poststay = function(rp,pk) { 
  Lino.run_row_action(rp,"/cal/MyEvents","GET",pk,"poststay",null);
};
Lino.cal.MyEvents.duplicate = function(rp,pk) { 
  Lino.run_row_action(rp,"/cal/MyEvents","GET",pk,"duplicate",null);
};
Lino.cal.MyEvents.wf2 = function(rp,pk) { 
  Lino.run_row_action(rp,"/cal/MyEvents","GET",pk,"wf2",null);
};
Lino.cal.MyEvents.wf3 = function(rp,pk) { 
  Lino.run_row_action(rp,"/cal/MyEvents","GET",pk,"wf3",null);
};
Lino.cal.MyEvents.wf4 = function(rp,pk) { 
  Lino.run_row_action(rp,"/cal/MyEvents","GET",pk,"wf4",null);
};

Lino.cal.MyEvents.detailPanel = Ext.extend(Lino.cal.Events.DetailFormPanel,{
  empty_title: "Detail Meine Termine",
  params_panel_hidden: true,
  ls_bbar_actions: [ { "itemId": "put", "menu_item_text": "Speichern", "tooltip": "\u00c4nderungen in diesem Formular speichern", "panel_btn_handler": function(panel){panel.save(null,false,'put')}, "iconCls": "x-tbar-save", "overflowText": "Speichern", "auto_save": false }, { "itemId": "insert", "menu_item_text": "Neu", "must_save": true, "tooltip": "Neuen Datensatz erstellen", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-new", "overflowText": "Neu", "auto_save": true }, { "itemId": "duplicate", "menu_item_text": "Duplizieren", "must_save": true, "tooltip": "Duplizieren", "panel_btn_handler": Lino.row_action_handler('duplicate','GET',null), "iconCls": "x-tbar-duplicate", "overflowText": "Duplizieren", "auto_save": true }, { "itemId": null, "menu_item_text": "L\u00f6schen", "tooltip": "Diesen Datensatz l\u00f6schen", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "L\u00f6schen", "auto_save": false }, { "itemId": "do_print", "menu_item_text": "Drucken", "must_save": true, "tooltip": "Drucken", "panel_btn_handler": Lino.list_action_handler('/cal/MyEvents','do_print','POST',null), "iconCls": "x-tbar-print", "overflowText": "Drucken", "auto_save": true }, { "itemId": "do_clear_cache", "menu_item_text": "Cache l\u00f6schen", "must_save": true, "tooltip": "Cache l\u00f6schen", "panel_btn_handler": Lino.row_action_handler('do_clear_cache','GET',null), "iconCls": "x-tbar-clearcache", "overflowText": "Cache l\u00f6schen", "auto_save": true }, { "itemId": "create_mail", "menu_item_text": "per E-Mail", "must_save": true, "tooltip": "Create an email from this", "panel_btn_handler": Lino.row_action_handler('create_mail','GET',null), "iconCls": "x-tbar-email_add", "overflowText": "per E-Mail", "auto_save": true } ],
  ls_url: "/cal/MyEvents",
  action_name: "detail",
  initComponent : function() {
    this.ls_detail_handler = Lino.cal.MyEvents.detail;
    this.ls_insert_handler = Lino.cal.MyEvents.insert;
    Lino.cal.MyEvents.detailPanel.superclass.initComponent.call(this);
  }
});

Lino.cal.MyEvents.detail = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.cal.MyEvents.detailPanel(p);
});
Lino.cal.MyEvents.do_print = function(rp,pk) { 
  Lino.run_row_action(rp,"/cal/MyEvents","POST",pk,"do_print",null);
};
Lino.cal.MyEvents.do_clear_cache = function(rp,pk) { 
  Lino.run_row_action(rp,"/cal/MyEvents","GET",pk,"do_clear_cache",null);
};
Lino.cal.MyEvents.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  p.params_panel = new Lino.cal.Events.ParamsPanel({});
  return new Lino.cal.MyEvents.GridPanel(p);
});
Lino.cal.MyEvents.take = function(rp,pk) { 
  Lino.run_row_action(rp,"/cal/MyEvents","GET",pk,"take",null);
};
Lino.cal.MyEvents.create_mail = function(rp,pk) { 
  Lino.run_row_action(rp,"/cal/MyEvents","GET",pk,"create_mail",null);
};

// js_render_GridPanel_class cal.MyAssignedEvents
Lino.cal.MyAssignedEvents.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "Keine Daten anzuzeigen." },
  ls_url : "/cal/MyAssignedEvents",
  ls_bbar_actions : [ { "itemId": "insert", "menu_item_text": "Neu", "must_save": true, "tooltip": "Neuen Datensatz erstellen", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-new", "overflowText": "Neu", "auto_save": true }, { "itemId": "duplicate", "menu_item_text": "Duplizieren", "must_save": true, "tooltip": "Duplizieren", "panel_btn_handler": Lino.row_action_handler('duplicate','GET',null), "iconCls": "x-tbar-duplicate", "overflowText": "Duplizieren", "auto_save": true }, { "itemId": "detail", "menu_item_text": "Detail", "tooltip": "Detail-Fenster auf diesem Datensatz \u00f6ffnen", "panel_btn_handler": Lino.show_detail, "iconCls": "x-tbar-detail", "overflowText": "Detail", "auto_save": true }, { "itemId": null, "menu_item_text": "L\u00f6schen", "tooltip": "Diesen Datensatz l\u00f6schen", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "L\u00f6schen", "auto_save": false }, { "itemId": "do_print", "menu_item_text": "Drucken", "must_save": true, "tooltip": "Drucken", "panel_btn_handler": Lino.list_action_handler('/cal/MyAssignedEvents','do_print','POST',null), "iconCls": "x-tbar-print", "overflowText": "Drucken", "auto_save": true }, { "itemId": "do_clear_cache", "menu_item_text": "Cache l\u00f6schen", "must_save": true, "tooltip": "Cache l\u00f6schen", "panel_btn_handler": Lino.row_action_handler('do_clear_cache','GET',null), "iconCls": "x-tbar-clearcache", "overflowText": "Cache l\u00f6schen", "auto_save": true }, { "itemId": "create_mail", "menu_item_text": "per E-Mail", "must_save": true, "tooltip": "Create an email from this", "panel_btn_handler": Lino.row_action_handler('create_mail','GET',null), "iconCls": "x-tbar-email_add", "overflowText": "per E-Mail", "auto_save": true } ],
  cell_edit : true,
  title : "Events assigned to me",
  page_length : 20,
  params_panel_hidden : true,
  stripeRows : true,
  disabled_actions_index : 7,
  ls_store_fields : [ { "name": "when_text" }, { "name": "summary" }, { "name": "workflow_buttons" }, { "name": "project" }, 'projectHidden', { "type": "int", "name": "id" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 5,
  ls_grid_configs : [  ],
  content_type : 35,
  ls_id_property : "id",
  gc_name : 0,
  initComponent : function() {
    this.ls_detail_handler = Lino.cal.MyAssignedEvents.detail;
    this.ls_insert_handler = Lino.cal.MyAssignedEvents.insert;
    var ww = this.containing_window;
    var when_text_disp3316 = new Ext.form.DisplayField({ "disabled": true, "value": "<br/>", "always_enabled": true });
    var summary3317 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var workflow_buttons_disp3318 = new Ext.form.DisplayField({ "disabled": true, "value": "<br/>", "always_enabled": true });
    var project3319 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "preferred_width": 20, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/MyAssignedEvents/project", "method": "GET" }) }), "pageSize": 20, "emptyText": "Klient ausw\u00e4hlen..." });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ { "width": Lino.chars2width(31), "colIndex": 0, "sortable": false, "dataIndex": "when_text", "header": "Wann", "editable": false, "tooltip": "(cal.MyAssignedEvents.when_text) " }, { "colIndex": 1, "sortable": true, "header": "Kurzbeschreibung", "editable": true, "tooltip": "(cal.MyAssignedEvents.summary) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "summary", "editor": summary3317 }, { "width": Lino.chars2width(31), "colIndex": 2, "sortable": false, "dataIndex": "workflow_buttons", "header": "Arbeitsablauf", "editable": false, "tooltip": "(cal.MyAssignedEvents.workflow_buttons) " }, { "colIndex": 3, "sortable": true, "header": "Klient", "editable": true, "tooltip": "(cal.MyAssignedEvents.project) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('projectHidden','Lino.pcsw.Clients.detail'), "editor": project3319, "dataIndex": "project" } ];
    Lino.cal.MyAssignedEvents.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.cal.MyAssignedEvents.put = function(rp,pk) { 
  Lino.run_row_action(rp,"/cal/MyAssignedEvents","GET",pk,"put",null);
};
Lino.cal.MyAssignedEvents.post = function(rp,pk) { 
  Lino.run_row_action(rp,"/cal/MyAssignedEvents","GET",pk,"post",null);
};

Lino.cal.MyAssignedEvents.insertPanel = Ext.extend(Lino.cal.Events.InsertFormPanel,{
  empty_title: "Neu Events assigned to me",
  hide_navigator: true,
  params_panel_hidden: true,
  ls_bbar_actions: [ { "itemId": "post", "menu_item_text": "Erstellen", "tooltip": "Datensatz erstellen und dann im Detail-Fenster \u00f6ffnen", "panel_btn_handler": function(panel){panel.save(null,true,'post')}, "text": "Erstellen", "overflowText": "Erstellen", "auto_save": false }, { "itemId": "poststay", "menu_item_text": "Erstellen ohne Detail", "tooltip": "Nach Erstellen des Datensatzes kein Detail-Fenster \u00f6ffnen", "panel_btn_handler": function(panel){panel.save(null,false,'poststay')}, "text": "Erstellen ohne Detail", "overflowText": "Erstellen ohne Detail", "auto_save": false } ],
  ls_url: "/cal/MyAssignedEvents",
  action_name: "insert",
  initComponent : function() {
    this.ls_detail_handler = Lino.cal.MyAssignedEvents.detail;
    this.ls_insert_handler = Lino.cal.MyAssignedEvents.insert;
    Lino.cal.MyAssignedEvents.insertPanel.superclass.initComponent.call(this);
  }
});

Lino.cal.MyAssignedEvents.insert = new Lino.WindowAction({ "draggable": true, "width": Lino.chars2width(60), "autoHeight": true, "maximizable": true, "modal": true, "maximized": false },function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.cal.MyAssignedEvents.insertPanel(p);
});
Lino.cal.MyAssignedEvents.wf1 = function(rp,pk) { 
  Lino.run_row_action(rp,"/cal/MyAssignedEvents","GET",pk,"wf1",null);
};
Lino.cal.MyAssignedEvents.poststay = function(rp,pk) { 
  Lino.run_row_action(rp,"/cal/MyAssignedEvents","GET",pk,"poststay",null);
};
Lino.cal.MyAssignedEvents.duplicate = function(rp,pk) { 
  Lino.run_row_action(rp,"/cal/MyAssignedEvents","GET",pk,"duplicate",null);
};
Lino.cal.MyAssignedEvents.wf2 = function(rp,pk) { 
  Lino.run_row_action(rp,"/cal/MyAssignedEvents","GET",pk,"wf2",null);
};
Lino.cal.MyAssignedEvents.wf3 = function(rp,pk) { 
  Lino.run_row_action(rp,"/cal/MyAssignedEvents","GET",pk,"wf3",null);
};
Lino.cal.MyAssignedEvents.wf4 = function(rp,pk) { 
  Lino.run_row_action(rp,"/cal/MyAssignedEvents","GET",pk,"wf4",null);
};

Lino.cal.MyAssignedEvents.detailPanel = Ext.extend(Lino.cal.Events.DetailFormPanel,{
  empty_title: "Detail Events assigned to me",
  params_panel_hidden: true,
  ls_bbar_actions: [ { "itemId": "put", "menu_item_text": "Speichern", "tooltip": "\u00c4nderungen in diesem Formular speichern", "panel_btn_handler": function(panel){panel.save(null,false,'put')}, "iconCls": "x-tbar-save", "overflowText": "Speichern", "auto_save": false }, { "itemId": "insert", "menu_item_text": "Neu", "must_save": true, "tooltip": "Neuen Datensatz erstellen", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-new", "overflowText": "Neu", "auto_save": true }, { "itemId": "duplicate", "menu_item_text": "Duplizieren", "must_save": true, "tooltip": "Duplizieren", "panel_btn_handler": Lino.row_action_handler('duplicate','GET',null), "iconCls": "x-tbar-duplicate", "overflowText": "Duplizieren", "auto_save": true }, { "itemId": null, "menu_item_text": "L\u00f6schen", "tooltip": "Diesen Datensatz l\u00f6schen", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "L\u00f6schen", "auto_save": false }, { "itemId": "do_print", "menu_item_text": "Drucken", "must_save": true, "tooltip": "Drucken", "panel_btn_handler": Lino.list_action_handler('/cal/MyAssignedEvents','do_print','POST',null), "iconCls": "x-tbar-print", "overflowText": "Drucken", "auto_save": true }, { "itemId": "do_clear_cache", "menu_item_text": "Cache l\u00f6schen", "must_save": true, "tooltip": "Cache l\u00f6schen", "panel_btn_handler": Lino.row_action_handler('do_clear_cache','GET',null), "iconCls": "x-tbar-clearcache", "overflowText": "Cache l\u00f6schen", "auto_save": true }, { "itemId": "create_mail", "menu_item_text": "per E-Mail", "must_save": true, "tooltip": "Create an email from this", "panel_btn_handler": Lino.row_action_handler('create_mail','GET',null), "iconCls": "x-tbar-email_add", "overflowText": "per E-Mail", "auto_save": true } ],
  ls_url: "/cal/MyAssignedEvents",
  action_name: "detail",
  initComponent : function() {
    this.ls_detail_handler = Lino.cal.MyAssignedEvents.detail;
    this.ls_insert_handler = Lino.cal.MyAssignedEvents.insert;
    Lino.cal.MyAssignedEvents.detailPanel.superclass.initComponent.call(this);
  }
});

Lino.cal.MyAssignedEvents.detail = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.cal.MyAssignedEvents.detailPanel(p);
});
Lino.cal.MyAssignedEvents.do_print = function(rp,pk) { 
  Lino.run_row_action(rp,"/cal/MyAssignedEvents","POST",pk,"do_print",null);
};
Lino.cal.MyAssignedEvents.do_clear_cache = function(rp,pk) { 
  Lino.run_row_action(rp,"/cal/MyAssignedEvents","GET",pk,"do_clear_cache",null);
};
Lino.cal.MyAssignedEvents.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  p.params_panel = new Lino.cal.Events.ParamsPanel({});
  return new Lino.cal.MyAssignedEvents.GridPanel(p);
});
Lino.cal.MyAssignedEvents.create_mail = function(rp,pk) { 
  Lino.run_row_action(rp,"/cal/MyAssignedEvents","GET",pk,"create_mail",null);
};
Lino.cal.MyAssignedEvents.take = function(rp,pk) { 
  Lino.run_row_action(rp,"/cal/MyAssignedEvents","GET",pk,"take",null);
};

// js_render_GridPanel_class cal.Tasks
Lino.cal.Tasks.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "Keine Daten anzuzeigen." },
  ls_url : "/cal/Tasks",
  ls_bbar_actions : [ { "itemId": "insert", "menu_item_text": "Neu", "must_save": true, "tooltip": "Neuen Datensatz erstellen", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-new", "overflowText": "Neu", "auto_save": true }, { "itemId": "detail", "menu_item_text": "Detail", "tooltip": "Detail-Fenster auf diesem Datensatz \u00f6ffnen", "panel_btn_handler": Lino.show_detail, "iconCls": "x-tbar-detail", "overflowText": "Detail", "auto_save": true }, { "itemId": null, "menu_item_text": "L\u00f6schen", "tooltip": "Diesen Datensatz l\u00f6schen", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "L\u00f6schen", "auto_save": false } ],
  cell_edit : true,
  title : "Aufgaben",
  page_length : 20,
  params_panel_hidden : true,
  stripeRows : true,
  disabled_actions_index : 29,
  ls_store_fields : [ { "type": "date", "name": "start_date", "dateFormat": "d.m.Y" }, { "name": "summary" }, { "name": "workflow_buttons" }, { "type": "int", "name": "id" }, { "name": "owner_type" }, 'owner_typeHidden', { "name": "owner_id" }, 'owner_idHidden', { "name": "user" }, 'userHidden', { "name": "created" }, { "name": "modified" }, { "name": "project" }, 'projectHidden', { "name": "start_time" }, { "name": "uid" }, { "name": "calendar" }, 'calendarHidden', { "name": "access_class" }, 'access_classHidden', { "type": "int", "name": "sequence" }, { "type": "int", "name": "auto_type" }, { "type": "date", "name": "due_date", "dateFormat": "d.m.Y" }, { "name": "due_time" }, { "type": "int", "name": "percent" }, { "name": "state" }, 'stateHidden', { "name": "owner" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 3,
  ls_grid_configs : [  ],
  content_type : 29,
  ls_id_property : "id",
  gc_name : 0,
  initComponent : function() {
    this.ls_detail_handler = Lino.cal.Tasks.detail;
    this.ls_insert_handler = Lino.cal.Tasks.insert;
    var ww = this.containing_window;
    var start_date3321 = new Lino.DateField({ "selectOnFocus": true });
    var summary3322 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var workflow_buttons_disp3323 = new Ext.form.DisplayField({ "disabled": true, "value": "<br/>", "always_enabled": true });
    var id3324 = new Ext.form.NumberField({ "selectOnFocus": true });
    var owner_type3325 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/Tasks/owner_type", "method": "GET" }) }), "pageSize": 20, "emptyText": "Inhaltstyp ausw\u00e4hlen..." });
    var owner_id3326 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/Tasks/owner_id", "method": "GET" }) }) });
    var user3327 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "preferred_width": 15, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/Tasks/user", "method": "GET" }) }), "pageSize": 20, "emptyText": "Benutzer ausw\u00e4hlen..." });
    var created3328 = new Ext.form.DisplayField({ "disabled": true, "value": "<br>" });
    var modified3329 = new Ext.form.DisplayField({ "disabled": true, "value": "<br>" });
    var project3330 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "preferred_width": 20, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/Tasks/project", "method": "GET" }) }), "pageSize": 20, "emptyText": "Klient ausw\u00e4hlen..." });
    var start_time3331 = new Lino.TimeField({ "selectOnFocus": true });
    var uid3332 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var calendar3333 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/Tasks/calendar", "method": "GET" }) }), "pageSize": 20, "emptyText": "Kalender ausw\u00e4hlen..." });
    var access_class3334 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "forceSelection": true, "store": [['','<br>']].concat(Lino.cal.AccessClasses) });
    var sequence3335 = new Ext.form.NumberField({ "selectOnFocus": true, "allowBlank": false, "value": 0 });
    var auto_type3336 = new Ext.form.NumberField({ "disabled": true });
    var due_date3337 = new Lino.DateField({ "selectOnFocus": true });
    var due_time3338 = new Lino.TimeField({ "selectOnFocus": true });
    var percent3339 = new Ext.form.NumberField({ "selectOnFocus": true });
    var state3340 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "forceSelection": true, "allowBlank": false, "store": Lino.cal.TaskStates });
    var owner_disp3341 = new Ext.form.DisplayField({ "disabled": true });
    this.before_row_edit = function(record) {
      owner_id3326.setContextValue('owner_type',record ? record.data['owner_typeHidden'] : undefined);
    };
    this.onRender = function(ct, position) {
      owner_type3325.on('change',Lino.chooser_handler(owner_id3326,'owner_type'));
      Lino.cal.Tasks.GridPanel.superclass.onRender.call(this, ct, position);
    }
    this.ls_columns = [ { "colIndex": 0, "sortable": true, "xtype": "datecolumn", "format": "d.m.Y", "editable": true, "tooltip": "(cal.Tasks.start_date) ", "filter": { "type": "date", "dateFormat": "d.m.Y" }, "header": "Beginnt am", "dataIndex": "start_date", "width": Lino.chars2width(9), "editor": start_date3321 }, { "colIndex": 1, "sortable": true, "header": "Kurzbeschreibung", "editable": true, "tooltip": "(cal.Tasks.summary) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "summary", "editor": summary3322 }, { "width": Lino.chars2width(31), "colIndex": 2, "sortable": false, "dataIndex": "workflow_buttons", "header": "Arbeitsablauf", "editable": false, "tooltip": "(cal.Tasks.workflow_buttons) " }, new Lino.NullNumberColumn({ "colIndex": 3, "sortable": true, "format": "0", "editable": true, "tooltip": "(cal.Tasks.id) ", "filter": { "type": "numeric" }, "header": "ID", "renderer": Lino.id_renderer, "editor": id3324, "width": Lino.chars2width(6), "dataIndex": "id" }), { "colIndex": 4, "sortable": true, "header": "Verkn\u00fcpft mit (Modell)", "editable": true, "tooltip": "(cal.Tasks.owner_type) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "owner_type", "editor": owner_type3325 }, { "colIndex": 5, "sortable": true, "header": "Verkn\u00fcpft mit (Objekt)", "editable": true, "tooltip": "(cal.Tasks.owner_id) ", "filter": { "type": "string" }, "width": Lino.chars2width(11), "dataIndex": "owner_id", "editor": owner_id3326 }, { "colIndex": 6, "sortable": true, "header": "Autor", "editable": true, "tooltip": "(cal.Tasks.user) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "user", "editor": user3327 }, { "width": Lino.chars2width(17), "colIndex": 7, "sortable": true, "dataIndex": "created", "header": "Erstellt", "editable": false, "tooltip": "(cal.Tasks.created) " }, { "width": Lino.chars2width(17), "colIndex": 8, "sortable": true, "dataIndex": "modified", "header": "Bearbeitet", "editable": false, "tooltip": "(cal.Tasks.modified) " }, { "colIndex": 9, "sortable": true, "header": "Klient", "editable": true, "tooltip": "(cal.Tasks.project) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('projectHidden','Lino.pcsw.Clients.detail'), "editor": project3330, "dataIndex": "project" }, { "colIndex": 10, "sortable": true, "header": "Beginnt um", "editable": true, "tooltip": "(cal.Tasks.start_time) ", "width": Lino.chars2width(9), "dataIndex": "start_time", "editor": start_time3331 }, { "colIndex": 11, "sortable": true, "header": "UID", "editable": true, "tooltip": "(cal.Tasks.uid) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "uid", "editor": uid3332 }, { "colIndex": 12, "sortable": true, "header": "Kalender", "editable": true, "tooltip": "(cal.Tasks.calendar) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('calendarHidden','Lino.cal.Calendars.detail'), "editor": calendar3333, "dataIndex": "calendar" }, { "colIndex": 13, "sortable": true, "header": "Zugriffsklasse", "editable": true, "tooltip": "(cal.Tasks.access_class) Ob dieser Termin  privat, \u00f6ffentlich oder halb \u00f6ffentlich ist", "filter": { "type": "string" }, "width": Lino.chars2width(13), "dataIndex": "access_class", "editor": access_cl