/*
 Copyright 2009-2013 Luc Saffre
 This file is part of the Lino project.
 Lino is free software; you can redistribute it and/or modify 
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 3 of the License, or
 (at your option) any later version.
 Lino is distributed in the hope that it will be useful, 
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the 
 GNU General Public License for more details.
 You should have received a copy of the GNU General Public License
 along with Lino; if not, see <http://www.gnu.org/licenses/>.
*/

// lino.js --- generated Thu Aug 29 15:39:36 2013 by Lino version 1.6.11.
Ext.BLANK_IMAGE_URL = '/media/extjs/resources/images/default/s.gif';
LANGUAGE_CHOICES = [ [ "en", "Englisch" ], [ "fr", "Franz\u00f6sisch" ], [ "de", "Deutsch" ], [ "nl", "Niederl\u00e4ndisch" ] ];
MEDIA_URL = "/media";

/* MonthPickerPlugin: thanks to keypoint @ sencha forum
   http://www.sencha.com/forum/showthread.php?74002-3.x-Ext.ux.MonthMenu&p=356860#post356860
*/
Ext.namespace('Ext.ux'); 

Ext.ux.MonthPickerPlugin = function() { 
    var picker; 
    var oldDateDefaults; 

    this.init = function(pk) { 
        picker = pk; 
        picker.onTriggerClick = picker.onTriggerClick.createSequence(onClick); 
        picker.getValue = picker.getValue.createInterceptor(setDefaultMonthDay).createSequence(restoreDefaultMonthDay); 
        picker.beforeBlur = picker.beforeBlur.createInterceptor(setDefaultMonthDay).createSequence(restoreDefaultMonthDay); 
    }; 

    function setDefaultMonthDay() { 
        oldDateDefaults = Date.defaults.d; 
        Date.defaults.d = 1; 
        return true; 
    } 

    function restoreDefaultMonthDay(ret) { 
        Date.defaults.d = oldDateDefaults; 
        return ret; 
    } 

    function onClick(e, el, opt) { 
        var p = picker.menu.picker; 
        p.activeDate = p.activeDate.getFirstDateOfMonth(); 
        if (p.value) { 
            p.value = p.value.getFirstDateOfMonth(); 
        } 

        p.showMonthPicker(); 
         
        if (!p.disabled) { 
            p.monthPicker.stopFx(); 
            p.monthPicker.show(); 

            p.mun(p.monthPicker, 'click', p.onMonthClick, p); 
            p.mun(p.monthPicker, 'dblclick', p.onMonthDblClick, p); 
            p.onMonthClick = p.onMonthClick.createSequence(pickerClick); 
            p.onMonthDblClick = p.onMonthDblClick.createSequence(pickerDblclick); 
            p.mon(p.monthPicker, 'click', p.onMonthClick, p); 
            p.mon(p.monthPicker, 'dblclick', p.onMonthDblClick, p); 
        } 
    } 

    function pickerClick(e, t) { 
        var el = new Ext.Element(t); 
        if (el.is('button.x-date-mp-cancel')) { 
            picker.menu.hide(); 
        } else if(el.is('button.x-date-mp-ok')) { 
            var p = picker.menu.picker; 
            p.setValue(p.activeDate); 
            p.fireEvent('select', p, p.value); 
        } 
    } 

    function pickerDblclick(e, t) { 
        var el = new Ext.Element(t); 
        if (el.parent() 
            && (el.parent().is('td.x-date-mp-month') 
            || el.parent().is('td.x-date-mp-year'))) { 

            var p = picker.menu.picker; 
            p.setValue(p.activeDate); 
            p.fireEvent('select', p, p.value); 
        } 
    } 
}; 

Ext.preg('monthPickerPlugin', Ext.ux.MonthPickerPlugin);  

//~ /* 
  //~ http://www.diloc.de/blog/2008/03/05/how-to-submit-ext-forms-the-right-way/
//~ */
//~ /**
 //~ * This submit action is basically the same as the normal submit action,
 //~ * only that it uses the fields getSubmitValue() to compose the values to submit,
 //~ * instead of looping over the input-tags in the form-tag of the form.
 //~ *
 //~ * To use it, just use the OOSubmit-plugin on either a FormPanel or a BasicForm,
 //~ * or explicitly call form.doAction('oosubmit');
 //~ *
 //~ * @param {Object} form
 //~ * @param {Object} options
 //~ */
//~ Ext.ux.OOSubmitAction = function(form, options){
    //~ Ext.ux.OOSubmitAction.superclass.constructor.call(this, form, options);
//~ };

//~ Ext.extend(Ext.ux.OOSubmitAction, Ext.form.Action.Submit, {
    //~ /**
    //~ * @cfg {boolean} clientValidation Determines whether a Form's fields are validated
    //~ * in a final call to {@link Ext.form.BasicForm#isValid isValid} prior to submission.
    //~ * Pass <tt>false</tt> in the Form's submit options to prevent this. If not defined, pre-submission field validation
    //~ * is performed.
    //~ */
    //~ type : 'oosubmit',

    //~ // private
    //~ /**
     //~ * This is nearly a copy of the original submit action run method
     //~ */
    //~ run : function(){
        //~ var o = this.options;
        //~ var method = this.getMethod();
        //~ var isPost = method == 'POST';

        //~ var params = this.options.params || {};
        //~ if (isPost) Ext.applyIf(params, this.form.baseParams);

        //~ //now add the form parameters
        //~ this.form.items.each(function(field)
        //~ {
            //~ if (!field.disabled)
            //~ {
                //~ //check if the form item provides a specialized getSubmitValue() and use that if available
                //~ if (typeof field.getSubmitValue == "function")
                    //~ params[field.getName()] = field.getSubmitValue();
                //~ else
                    //~ params[field.getName()] = field.getValue();
            //~ }
        //~ });

        //~ //convert params to get style if we are not post
        //~ if (!isPost) params=Ext.urlEncode(params);

        //~ if(o.clientValidation === false || this.form.isValid()){
            //~ Ext.Ajax.request(Ext.apply(this.createCallback(o), {
                //~ url:this.getUrl(!isPost),
                //~ method: method,
                //~ params:params, //add our values
                //~ isUpload: this.form.fileUpload
            //~ }));

        //~ }else if (o.clientValidation !== false){ // client validation failed
            //~ this.failureType = Ext.form.Action.CLIENT_INVALID;
            //~ this.form.afterAction(this, false);
        //~ }
    //~ },

//~ });
//~ //add our action to the registry of known actions
//~ Ext.form.Action.ACTION_TYPES['oosubmit'] = Ext.ux.OOSubmitAction;




/**
JC Watsons solution (adapted to ExtJS 3.3.1 by LS) is elegant and simple:
`A "fix" for unchecked checkbox submission  behaviour
<http://www.sencha.com/forum/showthread.php?28449>`_

Added special handling for checkbox inputs. 
ExtJS defines disabled checkboxes `readonly`, not `disabled` as for other inputs.

*/
Ext.lib.Ajax.serializeForm = function(form) {
    //~ console.log('20120203 linolib.js serializeForm',form);
    var fElements = form.elements || (document.forms[form] || Ext.getDom(form)).elements, 
        hasSubmit = false, 
        encoder = encodeURIComponent, 
        name, 
        data = '', 
        type, 
        hasValue;

    Ext.each(fElements, function(element){
        name = element.name;
        type = element.type;

        if (!element.disabled && name && !(type == 'checkbox' && element.readonly)) {
            if (/select-(one|multiple)/i.test(type)) {
                Ext.each(element.options, function(opt){
                    if (opt.selected) {
                        hasValue = opt.hasAttribute ? opt.hasAttribute('value') : opt.getAttributeNode('value').specified;
                        data += String.format("{0}={1}&", encoder(name), encoder(hasValue ? opt.value : opt.text));
                    }
                });
            } else if (!(/file|undefined|reset|button/i.test(type))) {
                //~ if (!(/radio|checkbox/i.test(type) && !element.checked) && !(type == 'submit' && hasSubmit)) {
                if (!(type == 'submit' && hasSubmit)) {
                    if (type == 'checkbox') {
                        //~ console.log('20111001',element,'data += ',encoder(name) + '=' + (element.checked ? 'on' : 'off') + '&');
                        data += encoder(name) + '=' + (element.checked ? 'on' : 'off') + '&';
                    } else {
                        //~ console.log('20111001',element,'data += ',encoder(name) + '=' + encoder(element.value) + '&');
                        data += encoder(name) + '=' + encoder(element.value) + '&';
                    }
                    hasSubmit = /submit/i.test(type);
                }
            }
        //~ } else {
            //~ console.log(name,type,element.readonly);
        }
    });
    return data.substr(0, data.length - 1);
};



/*
Set a long timeout of fifteen minutes. 
See /blog/2012/0307
*/
Ext.Ajax.timeout = 15 * 60 * 1000; 

/*
 * Thanks to 
 * `huuze <http://stackoverflow.com/users/10040/huuuze>`_ for the question
 * and to 
 * `chrisv <http://stackoverflow.com/users/683808/chrisv>`_
 * for the answer on
 * http://stackoverflow.com/questions/3764589/how-do-i-include-django-1-2s-csrf-token-in-a-javascript-generated-html-form/5485616#5485616
 * 
 * */
 
Ext.Ajax.on('beforerequest', function (conn, options) {
   if (!(/^http:.*/.test(options.url) || /^https:.*/.test(options.url))) {
     if (typeof(options.headers) == "undefined") {
       options.headers = {'X-CSRFToken': Ext.util.Cookies.get('csrftoken')};
     } else {
       options.headers.extend({'X-CSRFToken': Ext.util.Cookies.get('csrftoken')});
     }                        
   }
}, this);


/*
My fix for the "Cannot set QuickTips dismissDelay to 0" bug,
see http://www.sencha.com/forum/showthread.php?183515 
*/
Ext.override(Ext.QuickTip,{
  showAt : function(xy){
        var t = this.activeTarget;
        //~ console.log("20120224 QuickTip.showAt",this.title,this.dismissDelay,t.dismissDelay);
        if(t){
            if(!this.rendered){
                this.render(Ext.getBody());
                this.activeTarget = t;
            }
            if(t.width){
                this.setWidth(t.width);
                this.body.setWidth(this.adjustBodyWidth(t.width - this.getFrameWidth()));
                this.measureWidth = false;
            } else{
                this.measureWidth = true;
            }
            this.setTitle(t.title || '');
            this.body.update(t.text);
            this.autoHide = t.autoHide;
            // bugfix by Luc 20120226
            if (t.dismissDelay != undefined) this.dismissDelay = t.dismissDelay;
            //~ this.dismissDelay = t.dismissDelay || this.dismissDelay;
            if(this.lastCls){
                this.el.removeClass(this.lastCls);
                delete this.lastCls;
            }
            if(t.cls){
                this.el.addClass(t.cls);
                this.lastCls = t.cls;
            }
            if(this.anchor){
                this.constrainPosition = false;
            }else if(t.align){ 
                xy = this.el.getAlignToXY(t.el, t.align);
                this.constrainPosition = false;
            }else{
                this.constrainPosition = true;
            }
        }
        Ext.QuickTip.superclass.showAt.call(this, xy);
    }
});

/*
Another hack. See /docs/blog/2012/0228
*/
Ext.Element.addMethods(
    function() {
        var VISIBILITY      = "visibility",
            DISPLAY         = "display",
            HIDDEN          = "hidden",
            NONE            = "none",
            XMASKED         = "x-masked",
            XMASKEDRELATIVE = "x-masked-relative",
            data            = Ext.Element.data;

        return {
            
            mask : function(msg, msgCls) {
                var me  = this,
                    dom = me.dom,
                    dh  = Ext.DomHelper,
                    EXTELMASKMSG = "ext-el-mask-msg",
                    el,
                    mask;
                // removed the following lines. See /docs/blog/2012/0228
                //~ if (!(/^body/i.test(dom.tagName) && me.getStyle('position') == 'static')) {
                    //~ console.log(20120228,dom.tagName,me);
                    //~ me.addClass(XMASKEDRELATIVE); 
                //~ }
                if (el = data(dom, 'maskMsg')) {
                    el.remove();
                }
                if (el = data(dom, 'mask')) {
                    el.remove();
                }

                mask = dh.append(dom, {cls : "ext-el-mask"}, true);
                data(dom, 'mask', mask);

                me.addClass(XMASKED);
                mask.setDisplayed(true);
                
                if (typeof msg == 'string') {
                    var mm = dh.append(dom, {cls : EXTELMASKMSG, cn:{tag:'div'}}, true);
                    data(dom, 'maskMsg', mm);
                    mm.dom.className = msgCls ? EXTELMASKMSG + " " + msgCls : EXTELMASKMSG;
                    mm.dom.firstChild.innerHTML = msg;
                    mm.setDisplayed(true);
                    mm.center(me);
                }
                
                
                if (Ext.isIE && !(Ext.isIE7 && Ext.isStrict) && me.getStyle('height') == 'auto') {
                    mask.setSize(undefined, me.getHeight());
                }
                
                return mask;
            }

            
        };
    }()
);



Ext.namespace('Lino');
    
    

//~ Lino.subst_user_field = new Ext.form.ComboBox({});
//~ Lino.subst_user = null;
Lino.insert_subst_user = function(p){
    //~ console.log('20120714 insert_subst_user',Lino.subst_user,p);
    //~ if (Lino.subst_user_field.getValue()) {
    if (p.su) return;
    if (Lino.subst_user) {
        //~ p.su = Lino.subst_user_field.getValue();
        p.su = Lino.subst_user;
    //~ } else {
        //~ delete p.su;
    }
    //~ console.log('20120714 insert_subst_user -->',Lino.subst_user,p);
}

Lino.login_window = null;


Lino.show_login_window = function(on_login) {
  //~ console.log('20121103 show_login_window',arguments);
  //~ var current_window = Lino.current_window;
  if (Lino.login_window == null) {
    
      function do_login() { 
            Lino.viewport.loadMask.show()
            //~ Lino.body_loadMask.show()
            login_panel.getForm().submit({ 
                method:'POST', 
                waitTitle:'Connecting', 
                waitMsg:'Sending data...',
                success:function(){ 
                  //~ console.log('20121104 logged in',arguments);
                  Lino.login_window.hide();
                  Lino.close_all_windows();
                  Lino.viewport.loadMask.hide();
                  if (typeof on_login == 'string') {
                      //~ console.log("20130829 on_login",on_login);
                      //~ alert("20130829 on_login gonna load_url");
                      Lino.load_url(on_login);
                      //~ eval(on_login);
                  }
                  //~ Lino.body_loadMask.hide();
                },
                failure: function(form,action) { 
                  //~ this.loadMask.hide();
                  Lino.on_submit_failure(form,action);
                  Lino.viewport.loadMask.hide()
                  //~ Lino.body_loadMask.hide()
                  //~ if (Lino.current_window) Lino.current_window.main_item.loadMask.hide()
                }
                //~ failure:function(form, action){ 
                    //~ alert_msg
                    //~ if(action.failureType == 'server'){ 
                        //~ obj = Ext.util.JSON.decode(action.response.responseText); 
                        //~ Ext.Msg.alert('Login Failed!', obj.errors.reason); 
                    //~ }else{ 
                        //~ Ext.Msg.alert('Warning!', 'Authentication server is unreachable : ' + action.response.responseText); 
                    //~ } 
                    //~ Lino.login_panel.getForm().reset(); 
                //~ } 
            }); 
      };
    
      var login_button = new Ext.Button({ 
        text:"Anmelden",
        formBind: true,	 
        // Function that fires when user clicks the button 
        handler: do_login});
    
      var login_panel = new Ext.FormPanel({ 
        //~ inspired by http://www.sencha.com/learn/a-basic-login/
        autoHeight:true,
        labelWidth:90,
        url:'/auth', 
        frame:true, 
        defaultType:'textfield',
        monitorValid:true,
        items:[{ 
            fieldLabel:"Benutzername", 
            id: 'username',
            name:'username', 
            autoHeight:true,
            allowBlank:false 
        },{ 
            fieldLabel:"Passwort", 
            name:'password', 
            inputType:'password', 
            autoHeight:true,
            allowBlank:false 
        }],        
        buttons:[ login_button ]});
        
      Lino.login_window = new Ext.Window({
          layout:'fit',
          defaultButton: 'username',
          width:300,
          title:"Anmelden", 
          autoHeight:true,
          modal: true,
          closeAction: "hide",
          keys: {
            key: Ext.EventObject.ENTER,
            fn: function() { do_login()}
          },
          //~ defaultButton: login_button,
          //~ height:'auto',
          //~ closable: false,
          //~ resizable: false,
          //~ plain: true,
          //~ border: false,
          items: [login_panel] });
  };
  Lino.login_window.show();
};

Lino.logout = function(id,name) {
    //~ console.log('20121104 gonna log out',arguments);
    //~ Lino.do_action
    Lino.call_ajax_action(Lino.viewport,'GET','/auth',{},'logout',undefined,undefined,function(){
        //~ console.log('20121104 logged out',arguments);
        //~ Lino.login_window.hide();
        Lino.close_all_windows();
    })
}

Lino.set_subst_user = function(id,name) {
    //~ console.log(20130723,'Lino.set_subst_user',id,name,Lino.current_window,Lino.viewport);
    Lino.subst_user = id;
//~ 
    if (Lino.current_window) 
        Lino.current_window.main_item.set_base_param("su",id);
    if (Lino.viewport) 
        Lino.permalink_handler(Lino.current_window)();
}



//~ Lino.select_subst_user = function(cmp,rec,value){
    //~ Lino.subst_user=value;
    //~ console.log(20120713,rec);
//~ }
    
Lino.current_window = null;
Lino.window_history = Array();
    
Lino.chars2width = function(cols) {  return cols * 9; }
Lino.rows2height = function(cols) {  return cols * 20; }



Lino.MainPanel = {
  is_home_page : false,
  setting_param_values : false,
  config_containing_window : function(wincfg) { }
  ,init_containing_window : function(win) { }
  ,is_loading : function() { 
      if (!this.rendered) return true;
      //~ return (Ext.select('.x-loading-msg').elements.length > 0);
      return true; 
    } 
  ,do_when_clean : function(auto_save,todo) { todo() }
  ,get_master_params : function() {
    var p = {}
    p['mt'] = this.content_type; 
    rec = this.get_current_record()
    if (rec) {
      if (rec.phantom) {
          p['mk'] = undefined; 
      }else{
          p['mk'] = rec.id; 
      }
    } else {
      p['mk'] = undefined;
    }
    //~ console.log('get_master_params returns',p,'using record',rec);
    return p;
  }
  ,get_permalink : function() {
    //~ var p = this.main_item.get_base_params() || {};
    var p = Ext.apply({},this.get_base_params());
    delete p.fmt;
    //~ if (p.fmt) delete p.fmt;
    Ext.apply(p,this.get_permalink_params());
    
    if (this.toggle_params_panel_btn) {
        p.sp = this.toggle_params_panel_btn.pressed;
        //~ if (this.toggle_params_panel_btn.pressed == this.params_panel_hidden) {
          //~ p.sp = true;
        //~ }
    }
    
    //~ Lino.insert_subst_user(p);
     //~ p.fmt = 'html';
    //~ console.log('get_permalink',p,this.get_permalink_params());
    if (this.is_home_page)
        //~ var url = '';
        var url = '/';
    else 
        var url = this.get_permalink_url();
    if (p.su == null) 
        delete p.su;
    if (Ext.urlEncode(p)) url = url + "?" + Ext.urlEncode(p);
    return url;
  }
  ,get_record_url : function(record_id) {
      var url = '/api' + this.ls_url
      //~ var url = this.containing_window.config.url_data; // ls_url;
      url += '/' + (record_id === undefined ? '-99999' : String(record_id));
      //~ if (record_id !== undefined) url += '/' + String(record_id);
      //~ url += '/' + String(record_id);
      return url;
  }
  ,get_permalink_url : function() {
      return '/api' + this.ls_url;
  }
  ,get_permalink_params : function() {
      //~ return {an:'grid'};
      var p = {};
      if (this.action_name)
          p.an = this.action_name;
      this.add_param_values(p,false)
      return p;
  }
  ,set_status : function(status) {}
  ,get_status : function() { return {}}
  ,refresh : function() {}
  ,get_base_params : function() { 
    var p = {};
    Lino.insert_subst_user(p);
    return p;
  }
  ,add_params_panel : function (tbar) {
      if (this.params_panel) {
        this.toggle_params_panel_btn = new Ext.Button({ scope:this, 
          //~ text: "$_("[parameters]")", // gear
          iconCls: 'x-tbar-parameters',
          tooltip:"Parameter-Panel ein- bzw. ausblenden",
          enableToggle: true,
          //~ pressed: ! this.params_panel.hidden,
          pressed: ! this.params_panel_hidden,
          toggleHandler: function(btn,state) { 
            //~ if (this.params_panel.isVisible()) 
                //~ this.params_panel.hide();
            //~ else
                //~ this.params_panel.show();
            //~ console.log("20120210 add_params_panel",state,this.params_panel);
            if (state) {
              this.params_panel.show();
              this.params_panel.doLayout();
            } else this.params_panel.hide();
            this.get_containing_window().doLayout();
          }
        });
        tbar = tbar.concat([this.toggle_params_panel_btn]);
        var t = this;
        var refresh = function() {if (!t.setting_param_values) {t._force_dirty = true; t.refresh();}}
        Ext.each(this.params_panel.fields,function(f) {
          //~ f.on('valid',function() {t.refresh()});
          if (f instanceof Ext.form.Checkbox) {
              f.on('check',refresh);
          } else if (f instanceof Ext.DatePicker) {
              f.on('select',refresh);
          } else if (f instanceof Ext.form.TriggerField) {
              f.on('select',refresh);
              //~ f.on('change',refresh);
              //~ f.on('valid',refresh);
          } else {
              if (! f.on) 
                  console.log("20121010 no method 'on'",f);
              else
                  f.on('change',refresh);
            }
          });
      }
      return tbar;
  }
  ,add_param_values : function (p,unused_force_dirty) {
    if (this.params_panel) {
      /* 
      * 20120918 add param_values to the request string 
      * *only if the params_form is dirty*.
      * Otherwise Actor.default_params() would never be used.
      *
      * 20121023 But IntegClients.params_default has non-empty default values. 
      * Users must have the possibility to make them empty.
      * 
      * 20130605 : added `force_dirty` parameter because Checkbox fields don't 
      * mark their form as dirty when check is fired.
      * 
      * 20130721 : `force_dirty` not as a parameter but as 
      * `this._force_dirty` because
      * 
      */
      if (this._force_dirty || this.params_panel.form.isDirty()) {
        p.pv = this.get_param_values();
        //~ console.log("20130605 form.isDirty",p);
      }else{
        //~ console.log("20130605 form not dirty:",this.params_panel.form);
        if (this.status_param_values) 
          p.pv = Lino.fields2array(
            this.params_panel.fields,this.status_param_values);
      }
      //~ if (!this.params_panel.form.isDirty()) return;
      //~ p.pv = this.get_param_values();
      //~ console.log("20120203 add_param_values added pv",pv,"to",p);
    }
  },
  get_param_values : function() { // similar to get_field_values()
      return Lino.fields2array(this.params_panel.fields);
  },
  set_param_values : function(pv) {
    if (this.params_panel) {
      //~ console.log('20120203 MainPanel.set_param_values', pv);
      this.status_param_values = pv;
      //~ this.params_panel.form.suspendEvents(false);
      this.setting_param_values = true;
      if (pv) { 
          this.params_panel.form.my_loadRecord(pv);
      } else { 
        this.params_panel.form.reset(); 
      }
      this.setting_param_values = false;
      //~ this.params_panel.form.resumeEvents();
    }
  }
};




Lino.Viewport = Ext.extend(Ext.Viewport,Lino.MainPanel);
Lino.Viewport = Ext.extend(Lino.Viewport,{
  layout : "fit"
  ,is_home_page : true
  ,initComponent : function(){
    Lino.Viewport.superclass.initComponent.call(this);
    this.on('render',function(){
      this.loadMask = new Ext.LoadMask(this.el,{msg:"Bitte warten..."});
      //~ console.log("20121118 Lino.viewport.loadMask",this.loadMask);
    },this);
  }
  ,get_base_params : function() { 
    var p = {};
    Lino.insert_subst_user(p);
    return p;
  }
  ,refresh : function() {
      var caller = this;
      //~ console.log("20121120 Lino.Viewport.refresh()");
      if (caller.loadMask) caller.loadMask.show();
      var success = function(response) {
        if (caller.loadMask) caller.loadMask.hide();
        if (response.responseText) {
          var result = Ext.decode(response.responseText);
          //~ console.log('Lino.do_action()',action.name,'result is',result);
          if (result.html) {
              Ext.getCmp('main_area').update(result.html);
          }
          if (result.message) {
              if (result.alert) {
                  //~ Ext.MessageBox.alert('Alert',result.alert_msg);
                  Ext.MessageBox.alert('Alert',result.message);
              } else {
                  Lino.notify(result.message);
              }
          }
          
          if (result.notify_msg) Lino.notify(result.notify_msg);
          if (result.js_code) { 
            var jsr = result.js_code(caller);
            //~ console.log('Lino.do_action()',action,'returned from js_code in',result);
          };
        }
      };
      var action = {
        url : '/api/main_html',
        waitMsg: "Bitte warten...",
        failure: Lino.ajax_error_handler(caller),
        success: success,
        method: 'GET',
        params: {}
      };
      Lino.insert_subst_user(action.params);
      Ext.Ajax.request(action);
    
  }
});




Lino.open_window = function(win,st,requesting_panel) {
  //~ console.log("20120918 Lino.open_window()",win,st);
  var cw = Lino.current_window;
  if (cw) {
    //~ console.log("20120918 Lino.open_window() save current status",cw.main_item.get_status());
    Lino.window_history.push({
      window:cw,
      status:cw.main_item.get_status()
    });
  }
  Lino.current_window = win;
  //~ if (st.su) 
      //~ Lino.subst_user_field.setValue(st.su);
  win.main_item.set_status(st,requesting_panel);
  win.show();
};

Lino.load_url = function(url) {
    //~ foo.bar.baz = 2; 
    //~ console.log("20121120 Lino.load_url()");
    //~ Lino.body_loadMask.show();
    Lino.viewport.loadMask.show();
    //~ location.replace(url);
    document.location = url;
}

Lino.close_window = function(status_update) {
  var cw = Lino.current_window;
  var ww = Lino.window_history.pop();
  if (ww) {
    //~ if (status_update) Ext.apply(ww.status,status_update);
    if (status_update) status_update(ww);
    ww.window.main_item.set_status(ww.status);
    Lino.current_window = ww.window;
  } else {
    Lino.current_window = null;
  }
  if (cw) cw.hide_really();
};

Lino.close_all_windows = function() {
  if (Lino.window_history.length == 0) {
      //~ Lino.viewport.refresh();
      var url =  "/"
      //~ console.log("20121120 Lino.close_all_windows() : no window_history");
      //~ if (ADMIN_URL) 
      var p = {};
      Lino.insert_subst_user(p)
      if (Ext.urlEncode(p)) url = url + "?" + Ext.urlEncode(p);
      Lino.load_url(url);
  } else {
    //~ console.log("20121120 Lino.close_all_windows() with window_history");
    while (Lino.window_history.length > 0) {
      Lino.close_window();
      //~ Lino.window_history.pop().hide_really();
    }
  }
  //~ Lino.current_window = null;
  //~ Lino.close_window();
  //~ var ww = 
}

Lino.kill_current_window = function() {
  var cw = Lino.current_window;
  Lino.current_window = null;
  if (cw) cw.hide_really();
};

Lino.calling_window = function() {
    if (Lino.window_history.length) return Lino.window_history[Lino.window_history.length-1];
}

//~ Lino.WindowAction = function(mainItemClass,windowConfig,mainConfig,ppf) {
Lino.WindowAction = function(windowConfig,main_item_fn) {
    //~ if(!mainConfig) mainConfig = {};
    //~ mainConfig.is_main_window = true;
    this.windowConfig = windowConfig;
    this.main_item_fn = main_item_fn;
    //~ if (ppf) mainConfig.params_panel.fields = ppf;
    //~ this.mainConfig = mainConfig;
    //~ this.mainItemClass = mainItemClass;
};

Lino.WindowAction = Ext.extend(Lino.WindowAction,{
    window : null,
    //~ mainItemClass: null,
    get_window : function() {
      //~ if(mainConfig) Ext.apply(this.mainConfig,mainConfig);
      if (this.window == null)  {
          //~ this.windowConfig.main_item = new this.mainItemClass(this.mainConfig);
          this.windowConfig.main_item = this.main_item_fn();
          this.window = new Lino.Window(this.windowConfig);
      }
      return this.window;
    },
    run : function(requesting_panel,status) {
      //~ console.log('20120625 window_action.run()',this)
      Lino.open_window(this.get_window(),status,requesting_panel);
    }
  
});


Lino.PanelMixin = {
  get_containing_window : function (){
      if (this.containing_window) return this.containing_window;
      return this.containing_panel.get_containing_window();
  }
  ,set_window_title : function(title) {
    //~ this.setTitle(title);
    var cw = this.get_containing_window();

    //~ if (cw) {
    //~ if (cw && cw.closable) {
    if (cw && !cw.main_item.hide_window_title) {
      //~ console.log('20111202 set_window_title(',title,') for',this.containing_window);
      //~ if (! this.containing_window.rendered) console.log("WARNING: not rendered!");
      cw.setTitle(title);
    //~ } else {
      //~ document.title = title;
    }
    //~ else console.log('20111202 not set_window_title(',title,') for',this);
  }
  
};


// Lino.status_bar = new Ext.ux.StatusBar({defaultText:'Lino version 1.6.11.'});
Lino.status_bar = new Ext.ux.StatusBar({
    autoClear: 10000, // 10 seconds
    defaultText:'Lino Welfare 1.1.9.'
    });



Lino.edit_tinymce_text = function(panel,options) {
  // `panel` is the RichTextPanel
  //~ console.log(20111220,panel);
  //~ var rec = panel.get_current_record();
  var rec = panel.containing_panel.get_current_record();
  var value = rec ? rec.data[panel.editor.name] : '';
  var saving = false;
  var todo_after_save = false;
  var discard_changes = false;
  
  
  function save() {
    //~ if (todo_after_save) {alert('tried to save again'); return; }
    if (saving) {alert('tried to save again'); return; }
    //~ var url = panel.containing_window.main_item.get_record_url(rec.id);
    var url = panel.containing_panel.get_record_url(rec.id);
    var params = Ext.apply({},panel.containing_panel.get_base_params());
    params[panel.editor.name] = editor.getValue();
    //~ params.su = Lino.subst_user;
    //~ Lino.insert_subst_user(params);
    var a = { 
      params: params, 
      method: 'PUT',
      url: url,
      failure: function() {
          //~ if (editor.ed.getContainer()) 
          editor.ed.setProgressState(0);
          todo_after_save = false;
          saving = false;
          console.log('tinymce.save() failed. sorry.',arguments);
        },
      success: function() {
        saving = false;
        //~ if (editor.ed.getContainer()) 
        editor.ed.setProgressState(0);
        rec.data[panel.editor.name] = editor.getValue();
        if(todo_after_save) {
            var fn = todo_after_save;
            todo_after_save = false;
            fn();
        }
        //~ panel.containing_window.set_current_record(rec);
        panel.refresh();
      }
    };
    //~ if (editor.ed.getContainer()) 
    editor.ed.setProgressState(1); // Show progress
    saving = true;
    //~ console.log(a);
    Ext.Ajax.request(a);
  };
  function save_callback() {
      save();
      //~ save(function(){editor.ed.setDirty(false);})
      /* return true have the save button disabled.  
      That's not perfect because the PUT is asynchronous 
      and the response is not yet known.
      */
      return true;
  }
  //~ var actions = [
    //~ {text:"Save",handler:save}
  //~ ]; 
  //~ console.log(20110610,panel.editor.disabled);
  var settings = {};
  Ext.apply(settings,{
        readonly: panel.editor.disabled,
        //~ language: "de",
        plugins : "save,emotions,spellchecker,advhr,insertdatetime,preview,table,searchreplace,template", 
        // Theme options - button# indicated the row# only
        theme_advanced_buttons1 : "save,cancel,|,bold,italic,underline,|,justifyleft,justifycenter,justifyright,fontselect,fontsizeselect,formatselect,|,search,replace",
        theme_advanced_buttons2 : "cut,copy,paste,template,|,bullist,numlist,|,outdent,indent,|,undo,redo,|,link,unlink,anchor,image,|,code,preview,|,forecolor,backcolor",
        theme_advanced_buttons3 : "insertdate,inserttime,|,spellchecker,advhr,,removeformat,|,sub,sup,|,charmap,emotions,|,tablecontrols",      
        theme_advanced_resizing : false,
        convert_urls : false,
        save_onsavecallback : save_callback,
        save_enablewhendirty : true
        //~ save_oncancelcallback: on_cancel
  });
  Ext.apply(settings,options);
  var editor = new Ext.ux.TinyMCE({
      value : value,
      tinymceSettings: settings
    });
  var win = new Ext.Window({
    title: rec.title, 
    //~ bbar: actions,
    layout: 'fit',
    items: editor,
    width: 600, 
    height:500,
    minWidth: 100,
		minHeight: 100,
    modal: true,
    resizable: true,
    maximizable: true,
    //~ maximized: true,
    //~ closeAction: "close"
    closeAction: "hide"
    //~ hideMode: "offsets",
    //~ constrainHeader: true,
    //~ bodyStyle: 'padding: 10px'
  });

  //~ win.on('beforeclose',function() {
  win.on('beforehide',function() {
    if (todo_after_save) return false;
    if (discard_changes) return true;
    if (editor.isDirty()) {
        //~ var ok = false;
        //~ var allowClose = true;
        var config = {title:"Bestätigung"};
        config.buttons = Ext.MessageBox.YESNOCANCEL;
        config.msg = "Änderungen im Text speichern?";
        config.modal = true;
        config.fn = function(buttonId,text,opt) {
          //~ console.log('do_when_clean',buttonId)
          if (buttonId == "yes") {
              /* we cancel this close, but save()'s onSuccess will call again.*/
              //~ allowClose = false;
              todo_after_save = function(){win.hide();}
              editor.ed.execCommand('mceSave');
              //~ editor.ed.save(function(){win.close();});
          } else if (buttonId == "no") { 
              discard_changes = true;
              win.hide()
          //~ } else if (buttonId == "cancel") { 
            //~ ok = true;
              //~ allowClose = false;
          //~ } else { 
            //~ console.log('unknwon buttonId:',buttonId);
          }
        }
        Ext.MessageBox.show(config);
        return false;
        //~ return allowClose;
    }
  });
  win.show();
}







/* 
  Originally copied from Ext JS Library 3.3.1
  Modifications by Luc Saffre : 
  - rendering of phantom records
  - fire afteredit event
  - react on dblclcik, not on single click

 */
Lino.CheckColumn = Ext.extend(Ext.grid.Column, {

    processEvent : function(name, e, grid, rowIndex, colIndex){
        //~ console.log('20110713 Lino.CheckColumn.processEvent',name)
        if (name == 'click') {
        //~ if (name == 'mousedown') {
        //~ if (name == 'dblclick') {
            return this.toggleValue(grid, rowIndex, colIndex);
        } else {
            return Ext.grid.ActionColumn.superclass.processEvent.apply(this, arguments);
        }
    },
    
    toggleValue : function (grid,rowIndex,colIndex) {
        var record = grid.store.getAt(rowIndex);
        var dataIndex = grid.colModel.getDataIndex(colIndex);
        // 20120514
        //~ if(record.data.disabled_fields && record.data.disabled_fields[dataIndex]) {
          //~ Lino.notify("Dieses Feld ist deaktiviert");
          //~ return false;
        //~ }
      
        //~ if (dataIndex in record.data['disabled_fields']) {
            //~ Lino.notify("This field is disabled.");
            //~ return false;
        //~ }
        var startValue = record.data[dataIndex];
        var value = !startValue;
        //~ record.set(this.dataIndex, value);
        var e = {
            grid: grid,
            record: record,
            field: dataIndex,
            originalValue: startValue,
            value: value,
            row: rowIndex,
            column: colIndex,
            cancel: false
        };
        if(grid.fireEvent("beforeedit", e) !== false && !e.cancel){
        //~ if(grid.fireEvent("validateedit", e) !== false && !e.cancel){
            record.set(dataIndex, value);
            delete e.cancel;
            grid.fireEvent("afteredit", e);
        }
        return false; // Cancel event propagation
    },

    renderer : function(v, p, record){
        if (record.phantom) return '';
        p.css += ' x-grid3-check-col-td'; 
        return String.format('<div class="x-grid3-check-col{0}">&#160;</div>', v ? '-on' : '');
    }

    // Deprecate use as a plugin. Remove in 4.0
    // init: Ext.emptyFn
});

// register ptype. Deprecate. Remove in 4.0
// Ext.preg('checkcolumn', Lino.CheckColumn);

// backwards compat. Remove in 4.0
// Ext.grid.CheckColumn = Lino.CheckColumn;

// register Column xtype
Ext.grid.Column.types.checkcolumn = Lino.CheckColumn;


/* 20110725 : 
Lino.on_tab_activate is necessary 
in contacts.Person.2.dtl 
(but don't ask me why...)
*/
Lino.on_tab_activate = function(item) {
  //~ console.log('activate',item); 
  if (item.rendered && item.doLayout) item.doLayout();
  //~ if (item.rendered) item.doLayout();
}

Lino.TimeField = Ext.extend(Ext.form.TimeField,{
  format: 'H:i',
  increment: 15
  });
Lino.DateField = Ext.extend(Ext.form.DateField,{
  boxMinWidth: Lino.chars2width(11),
  format: 'd.m.Y',
  altFormats: 'd/m/Y|Y-m-d'
  });
Lino.DatePickerField = Ext.extend(Ext.DatePicker,{
  //~ boxMinWidth: Lino.chars2width(11),
  format: 'd.m.Y',
  //~ altFormats: 'd/m/Y|Y-m-d'
  formatDate : function(date){
      //~ console.log("20121203 formatDate",this.name,date);
      return Ext.isDate(date) ? date.dateFormat(this.format) : date;
  }
  });
Lino.DateTimeField = Ext.extend(Ext.ux.form.DateTime,{
  dateFormat: 'd.m.Y',
  timeFormat: 'H:i'
  //~ ,hiddenFormat: 'd.m.Y H:i'
  });
Lino.URLField = Ext.extend(Ext.form.TriggerField,{
  triggerClass : 'x-form-search-trigger',
  //~ triggerClass : 'x-form-world-trigger',
  vtype: 'url',
  onTriggerClick : function() {
    //~ console.log('Lino.URLField.onTriggerClick',this.value)
    //~ document.location = this.value;
    window.open(this.getValue(),'_blank');
  }
});
Lino.IncompleteDateField = Ext.extend(Ext.form.TextField,{
  //~ regex: /^-?\d+-[01]\d-[0123]\d$/,
  //~ regex: /^[0123]\d\.[01]\d\.-?\d+$/,
  maxLength: 10,
  boxMinWidth: Lino.chars2width(10),
  regex: /^[0123]?\d\.[01]?\d\.-?\d+$/,
  regexText: 'Datum im Format JJJJ-MM-TT eingeben (Nullen für unbekannte Teile)'
  });


//~ Lino.make_dropzone = function(cmp) {
    //~ cmp.on('render', function(ct, position){
      //~ ct.el.on({
        //~ dragenter:function(event){
          //~ event.browserEvent.dataTransfer.dropEffect = 'move';
          //~ return true;
        //~ }
        //~ ,dragover:function(event){
          //~ event.browserEvent.dataTransfer.dropEffect = 'move';
          //~ event.stopEvent();
          //~ return true;
        //~ }
        //~ ,drop:{
          //~ scope:this
          //~ ,fn:function(event){
            //~ event.stopEvent();
            //~ console.log(20110516);
            //~ var files = event.browserEvent.dataTransfer.files;
            //~ if(files === undefined){
              //~ return true;
            //~ }
            //~ var len = files.length;
            //~ while(--len >= 0){
              //~ console.log(files[len]);
              //~ // this.processDragAndDropFileUpload(files[len]);
            //~ }
          //~ }
        //~ }
      //~ });
    //~ });
//~ };

//~ Lino.FileUploadField = Ext.ux.form.FileUploadField;

Lino.FileUploadField = Ext.extend(Ext.ux.form.FileUploadField,{
    onRender : function(ct, position){
      Lino.FileUploadField.superclass.onRender.call(this, ct, position);
      this.el.on({
        dragenter:function(event){
          event.browserEvent.dataTransfer.dropEffect = 'move';
          return true;
        }
        ,dragover:function(event){
          event.browserEvent.dataTransfer.dropEffect = 'move';
          event.stopEvent();
          return true;
        }
        ,drop:{
          scope:this
          ,fn:function(event){
            event.stopEvent();
            //~ console.log(20110516);
            var files = event.browserEvent.dataTransfer.files;
            if(files === undefined){
              return true;
            }
            var len = files.length;
            while(--len >= 0){
              console.log(files[len]);
              //~ this.processDragAndDropFileUpload(files[len]);
            }
          }
        }
      });
    }
});

Lino.FileField = Ext.extend(Ext.form.TriggerField,{
  triggerClass : 'x-form-search-trigger',
  editable: false,
  onTriggerClick : function() {
    //~ console.log('Lino.URLField.onTriggerClick',this.value)
    //~ document.location = this.value;
    if (this.getValue()) window.open(MEDIA_URL + '/'+this.getValue(),'_blank');
  }
});

Lino.file_field_handler = function(panel,config) {
  //~ if (instanceof Lino.DetailWrapper) {
  if (panel.action_name == 'insert') {
  //~ if (panel.get_current_record().phantom) {
      panel.has_file_upload = true;

      var f = new Lino.FileUploadField(config);
      //~ Lino.make_dropzone(f);
      return f;
      //~ return new Ext.ux.form.FileUploadField(config);
      //~ return new Lino.FileField(config);
      
  } else {
      //~ return new Lino.URLField(config);
      return new Lino.FileField(config);
  }
}

Lino.VBorderPanel = Ext.extend(Ext.Panel,{
    constructor : function(config) {
      config.layout = 'border';
      delete config.layoutConfig;
      Lino.VBorderPanel.superclass.constructor.call(this,config);
      for(var i=0; i < this.items.length;i++) {
        var item = this.items.get(i);
        if (this.isVertical(item) && item.collapsible) {
          item.on('collapse',this.onBodyResize,this);
          item.on('expand',this.onBodyResize,this);
        }
      }
    },
    isVertical : function(item) {
       return (item.region == 'north' || item.region == 'south' || item.region == 'center');
    },
    onBodyResize: function(w, h){
        //~ console.log('VBorderPanel.onBodyResize',this.title)
      if (this.isVisible()) { // to avoid "Uncaught TypeError: Cannot call method 'getHeight' of undefined."
        var sumflex = 0;
        var availableHeight = this.getInnerHeight();
        var me = this;
        this.items.each(function(item){
          if (me.isVertical(item)) {
              if (item.collapsed || item.flex == 0 || item.flex === undefined) {
                  if (item.rendered) availableHeight -= item.getHeight();
              } else {
                  sumflex += item.flex;
              }
          } 
          
        });
        //~ for(var i=0; i < this.items.length;i++) {
          //~ var item = this.items.get(i);
          //~ // if (this.isVertical(item) && item.getResizeEl()) {
          //~ if (this.isVertical(item)) {
              //~ if (item.collapsed || item.flex == 0 || item.flex === undefined) {
                  //~ // item.syncSize()
                  //~ // item.doLayout()
                  //~ // if (item.region == "north") console.log('region north',item.getHeight(),item.id, item);
                  //~ // if (item.getHeight() == 0) console.log(20100921,'both flex and getHeight() are 0!');
                  //~ availableHeight -= item.getHeight();
              //~ } else {
                  //~ sumflex += item.flex;
                  //~ // console.log(item.flex);
              //~ }
          //~ } 
          //~ // else console.log('non-vertical item in VBoderPanel:',item)
        //~ }
        var hunit = availableHeight / sumflex;
        //~ console.log('sumflex=',sumflex,'hunit=',hunit, 'availableHeight=',availableHeight);
        for(var i=0; i < this.items.length;i++) {
          var item = this.items.get(i);
          if (this.isVertical(item)) {
              if (item.flex != 0 && ! item.collapsed) {
                  item.setHeight(hunit * item.flex);
                  //~ console.log(item.region,' : height set to',item.getHeight());
              }
          }
          //~ else console.log('non-vertical item in VBoderPanel:',item)
        }
      }
      Lino.VBorderPanel.superclass.onBodyResize.call(this, w, h);
    }
});


/*
  modifications to the standard behaviour of a CellSelectionModel:
  
*/
Ext.override(Ext.grid.CellSelectionModel, {
//~ var dummy = {

    handleKeyDown : function(e){
        /* removed because F2 wouldn't pass
        if(!e.isNavKeyPress()){
            return;
        }
        */
        //~ console.log('handleKeyDown',e)
        var k = e.getKey(),
            g = this.grid,
            s = this.selection,
            sm = this,
            walk = function(row, col, step){
                return g.walkCells(
                    row,
                    col,
                    step,
                    g.isEditor && g.editing ? sm.acceptsNav : sm.isSelectable, 
                    sm
                );
            },
            cell, newCell, r, c, ae;

        switch(k){
            case e.ESC:
            case e.PAGE_UP:
            case e.PAGE_DOWN:
                break;
            default:
                // e.stopEvent(); // removed because Browser keys like Alt-Home, Ctrl-R wouldn't work
                break;
        }

        if(!s){
            cell = walk(0, 0, 1); 
            if(cell){
                this.select(cell[0], cell[1]);
            }
            return;
        }

        cell = s.cell;  
        r = cell[0];    
        c = cell[1];    
        
        switch(k){
            case e.TAB:
                if(e.shiftKey){
                    newCell = walk(r, c - 1, -1);
                }else{
                    newCell = walk(r, c + 1, 1);
                }
                break;
            case e.HOME:
                if (! (g.isEditor && g.editing)) {
                  if (!e.hasModifier()){
                      newCell = [r, 0];
                      //~ console.log('home',newCell);
                      break;
                  }else if(e.ctrlKey){
                      var t = g.getTopToolbar();
                      var activePage = Math.ceil((t.cursor + t.pageSize) / t.pageSize);
                      if (activePage > 1) {
                          e.stopEvent();
                          t.moveFirst();
                          return;
                      }
                      newCell = [0, c];
                      break;
                  }
                }
            case e.END:
                if (! (g.isEditor && g.editing)) {
                  c = g.colModel.getColumnCount()-1;
                  if (!e.hasModifier()) {
                      newCell = [r, c];
                      //~ console.log('end',newCell);
                      break;
                  }else if(e.ctrlKey){
                      var t = g.getTopToolbar();
                      var d = t.getPageData();
                      if (d.activePage < d.pages) {
                          e.stopEvent();
                          var self = this;
                          t.on('change',function(tb,pageData) {
                              var r = g.store.getCount()-2;
                              self.select(r, c);
                              //~ console.log('change',r,c);
                          },this,{single:true});
                          t.moveLast();
                          return;
                      } else {
                          newCell = [g.store.getCount()-1, c];
                          //~ console.log('ctrl-end',newCell);
                          break;
                      }
                  }
                }
            case e.DOWN:
                newCell = walk(r + 1, c, 1);
                break;
            case e.UP:
                newCell = walk(r - 1, c, -1);
                break;
            case e.RIGHT:
                newCell = walk(r, c + 1, 1);
                break;
            case e.LEFT:
                newCell = walk(r, c - 1, -1);
                break;
            case e.F2:
                if (!e.hasModifier()) {
                    if (g.isEditor && !g.editing) {
                        g.startEditing(r, c);
                        e.stopEvent();
                        return;
                    }
                    break;
                }
            case e.INSERT:
                if (!e.hasModifier()) {
                    if (g.ls_insert_handler && !g.editing) {
                        e.stopEvent();
                        Lino.show_insert(g);
                        return;
                    }
                    break;
                }
            case e.DELETE:
                if (!e.hasModifier()) {
                    if (!g.editing) {
                        e.stopEvent();
                        Lino.delete_selected(g);
                        return;
                    }
                    break;
                }
            case e.ENTER:
                e.stopEvent();
                g.onCellDblClick(r,c);
                break;
                
        }
        

        if(newCell){
          e.stopEvent();
          r = newCell[0];
          c = newCell[1];
          this.select(r, c); 
          if(g.isEditor && g.editing){ 
            ae = g.activeEditor;
            if(ae && ae.field.triggerBlur){
                ae.field.triggerBlur();
            }
            g.startEditing(r, c);
          }
        //~ } else if (g.isEditor && !g.editing && e.charCode) {
        //~ // } else if (!e.isSpecialKey() && g.isEditor && !g.editing) {
            //~ g.set_start_value(String.fromCharCode(e.charCode));
            //~ // g.set_start_value(String.fromCharCode(k));
            //~ // g.set_start_value(e.charCode);
            //~ g.startEditing(r, c);
            //~ // e.stopEvent();
            //~ return;
        // } else {
          // console.log('20120513',e,g);
        }
        
    }


//~ };
});

 

function PseudoConsole() {
    this.log = function() {};
};
if (typeof(console) == 'undefined') console = new PseudoConsole();

Lino.notify = function(msg) {
  if (msg == undefined) msg = ''; else console.log(msg);
  //~ Ext.getCmp('konsole').update(msg);
  Lino.status_bar.setStatus({
    text: msg,
    iconCls: 'ok-icon',
    clear: true // auto-clear after a set interval
  });
  //~ Ext.getCmp('konsole').setTitle(msg.replace(/\n/g,'<br/>'));
  //~ Ext.getCmp('konsole').update(msg.replace(/\n/g,'<br/>'));
};
Lino.alert = function(msg) {
  //~ if (msg == undefined) msg = ''; else console.log(msg);
  Ext.MessageBox.alert('Notify',msg);
};


//~ Lino.show_about = function() {
  //~ new Ext.Window({
    //~ width: 400, height: 400,
    //~ title: "About",
    //~ html: '<a href="http://www.extjs.com" target="_blank">ExtJS</a> version ' + Ext.version
  //~ }).show();
//~ };

function obj2str(o) {
  if (typeof o != 'object') return String(o);
  var s = '';
  for (var p in o) {
    s += p + ': ' + obj2str(o[p]) + '\n';
  }
  return s;
}

Lino.on_store_exception = function (store,type,action,options,response,arg) {
  //~ throw response;
  console.log("on_store_exception: store=",store,
    "type=",type,
    "action=",action,
    "options=",options,
    "response=",response,
    "arg=",arg);
  if (arg) { console.log(arg.stack)};
};

//~ Lino.on_submit_success = function(form, action) {
   //~ Lino.notify(action.result.message);
   //~ this.close();
//~ };

Lino.on_submit_failure = function(form, action) {
    //~ Lino.notify();
  // action may be undefined
    switch (action.failureType) {
        case Ext.form.Action.CLIENT_INVALID:
            Ext.Msg.alert('Client-side failure', 'Form fields may not be submitted with invalid values');
            break;
        case Ext.form.Action.CONNECT_FAILURE:
            Ext.Msg.alert('Connection failure', 'Ajax communication failed');
            break;
        case Ext.form.Action.SERVER_INVALID:
            Ext.Msg.alert('Server-side failure', action.result.message);
   }
};



/*
Lino.save_wc_handler = function(ww) {
  return function(event,toolEl,panel,tc) {
    var pos = panel.getPosition();
    var size = panel.getSize();
    wc = ww.get_window_config();
    Ext.applyIf(wc,{ 
      x:pos[0],y:pos[1],height:size.height,width:size.width,
      maximized:panel.maximized});
    Lino.do_action(ww,{url:'/window_configs/'+ww.config.permalink_name,params:wc,method:'POST'});
  }
};

*/

Lino.show_in_own_window_button = function(handler) {
  return {
    qtip: "Dieses Panel in eigenem Fenster öffnen", 
    id: "up",
    handler: function(event,toolEl,panel, tc) {
      //~ console.log('20111206 report_window_button',panel,handler);
      handler.run(null,{base_params:panel.containing_panel.get_master_params()});
    }
  }
}




Lino.delete_selected = function(panel) {
  //~ console.log("Lino.delete_selected",panel);
  var recs1 = panel.get_selected();
  var recs = [];
  for ( var i=0; i < recs1.length; i++ ) { if (! recs1[i].phantom) recs.push(recs1[i]); }
  if (recs.length == 0) {
    Lino.notify("Please select at least one record.");
    return;
  };
  if (recs.length == 1) {
      if (recs[0].disable_delete) {
        Lino.alert(recs[0].disable_delete);
        return;
      }
  };
  //~ console.log(recs);
  Ext.MessageBox.show({
    title: "Bestätigung",
    msg: String.format("Es werden {0} Datensätze gelöscht. Sind Sie sicher?",String(recs.length)),
    //~ msg: "Delete " + String(recs.length) + " rows. Are you sure?",
    //~ buttons: Ext.MessageBox.YESNOCANCEL,
    buttons: Ext.MessageBox.YESNO,
    fn: function(btn) {
      if (btn == 'yes') {
        for ( var i=0; i < recs.length; i++ ) {
          Lino.do_action(panel,{
              method:'DELETE',
              url:  '/api' + panel.ls_url + '/' + recs[i].id,
              after_success: panel.after_delete.createDelegate(panel)
          })
        }
        //~ caller.after_delete();
      }
      else Lino.notify("Dann eben nicht.");
    }
  });
};

Lino.action_handler = function (panel,on_success,on_confirm) {
  return function (response) {
    //~ console.log(20120608,panel);
    if (panel instanceof Lino.GridPanel) {
        //~ gridmode = false;
        gridmode = true;
        //~ console.log('20120608 yes');
    } else {
        gridmode = false;
        //~ console.log('20120608 no');
    }
    if (panel.loadMask) panel.loadMask.hide(); // 20120211
    if (!response.responseText) return ;
    var result = Ext.decode(response.responseText);
    //~ console.log('Lino.action_handler()','result is',result,'on_confirm is',on_confirm);
    
    if (result.eval_js) {
        //~ console.log(20120618,result.eval_js);
        eval(result.eval_js);
    }
    
    //~ if (result.goto_record) {
        //~ var js = "Lino." + result.goto_record[0] + '.detail.run';
        //~ var h = eval(js);
        //~ h(panel,{record_id:result.goto_record[1]});
    //~ }
    
    if (result.xcallback) {
        //~ var config = {title:"Bestätigung"};
        var config = {title:result.xcallback.title};
        //~ config.buttons = Ext.MessageBox.YESNOCANCEL;
        //~ config.buttons = Ext.MessageBox.YESNO;
        config.buttons = result.xcallback.buttons;
        config.msg = result.message;
        config.fn = function(buttonId,text,opt) {
          panel.loadMask.show(); 
          //~ Lino.insert_subst_user(p);
          Ext.Ajax.request({
            method: 'GET',
            url: '/callbacks/'+result.xcallback.id + '/' + buttonId,
            //~ params: {bi: buttonId},
            success: Lino.action_handler(panel,on_success,on_confirm)
          });
          //~ Lino.call_ajax_action(panel,'GET',)
        }
        Ext.MessageBox.show(config);
        return;
    }
    
    if (on_success && result.success) on_success(result);
    
    //~ if (on_confirm && result.confirm_message) {
        //~ var config = {title:"Bestätigung"};
        //~ // config.buttons = Ext.MessageBox.YESNOCANCEL;
        //~ config.buttons = Ext.MessageBox.YESNO;
        //~ config.msg = result.confirm_message;
        //~ config.fn = function(buttonId,text,opt) {
          //~ if (buttonId == "yes") {
              //~ on_confirm(panel,undefined,result.step);
          //~ }
        //~ }
        //~ Ext.MessageBox.show(config);
        //~ return;
    //~ }
    //~ if (result.dialog_fn) {
        //~ console.log('20120928 TODO',result.dialog_fn);
    //~ }
    if (result.data_record && ! gridmode) {
        //~ not used
        panel.set_status({data_record:result.data_record});
    }  else if (result.new_status && ! gridmode) {
        //~ not used
        //~ console.log('20120607 new_status');
        panel.set_status(result.new_status);
    } else if (result.goto_record_id != undefined) {
        panel.load_record_id(result.goto_record_id);
    } 
    
    if (result.message) {
        //~ if (result.alert && ! gridmode) {
        if (result.alert) { // 20120628b 
            //~ Ext.MessageBox.alert('Alert',result.alert_msg);
            if (result.alert === true) result.alert = "Alarm";
            Ext.MessageBox.alert(result.alert,result.message);
        } else {
            Lino.notify(result.message);
        }
    }
     
    if (result.refresh_all) {
        var cw = panel.get_containing_window();
        //~ console.log("20120123 refresh_all");
        if (cw) {
          cw.main_item.refresh();
        }
        //~ else console.log("20120123 cannot refresh_all",panel);
    } else {
        //~ console.log("20121212 b gonna refresh",panel);
        if (result.refresh) panel.refresh();
    }
    
    if (result.open_davlink_url) {
       Lino.davlink_open(result.open_davlink_url);
    }
    
    if (result.open_url) {
        //~ console.log(20111126,result.open_url);
        //~ if (!result.message)
            //~ Lino.notify('Open new window <a href="'+result.open_url+'" target="_blank">'+result.open_url+'</a>');
        window.open(result.open_url,'foo',"");
        //~ document.location = result.open_url;
    }
  }
};

Lino.do_action = function(caller,action) {
  action.success = function(response) {
    if (caller.loadMask) caller.loadMask.hide();
    //~ console.log('Lino.do_action()',action,'action success',response);
    if (action.after_success) {
        //~ console.log('Lino.do_action() calling after_success');
        action.after_success();
    }
    if (response.responseText) {
      var result = Ext.decode(response.responseText);
      //~ console.log('Lino.do_action()',action.name,'result is',result);
      if (result.message) {
          if (result.alert) {
              //~ Ext.MessageBox.alert('Alert',result.alert_msg);
              Ext.MessageBox.alert('Alert',result.message);
          } else {
              Lino.notify(result.message);
          }
      }
      
      //~ if (result.alert_msg) Ext.MessageBox.alert('Alert',result.alert_msg);
      //~ if (result.message) Lino.notify(result.message);
      if (result.notify_msg) Lino.notify(result.notify_msg);
      if (result.js_code) { 
        //~ console.log('Lino.do_action()',action,'gonna call js_code in',result);
        var jsr = result.js_code(caller);
        //~ console.log('Lino.do_action()',action,'returned from js_code in',result);
        if (action.after_js_code) {
          //~ console.log('Lino.do_action()',action,'gonna call after_js_code');
          action.after_js_code(jsr);
          //~ console.log('Lino.do_action()',action,'returned from after_js_code');
        //~ } else {
          //~ console.log('Lino.do_action()',action,' : after_js_code is false');
        }
      };
    }
  };
  Ext.applyIf(action,{
    waitMsg: "Bitte warten...",
    failure: Lino.ajax_error_handler(caller),
    params: {}
  });
  //~ action.params.su = Lino.subst_user;
  Lino.insert_subst_user(action.params);
  
  Ext.Ajax.request(action);
};

//~ Lino.gup = function( name )
//~ {
  //~ // Thanks to http://www.netlobo.com/url_query_string_javascript.html
  //~ name = name.replace(/[\[]/,"\\\[").replace(/[\]]/,"\\\]");
  //~ var regexS = "[\\?&]"+name+"=([^&#]*)";
  //~ var regex = new RegExp( regexS );
  //~ var results = regex.exec( window.location.href );
  //~ if( results == null )
    //~ return "";
  //~ else
    //~ return results[1];
//~ };

//~ Lino.refresh_handler = function (ww) {
  //~ return function() { 
      //~ console.log('refresh',ww);
      //~ ww.main_item.doLayout(false,true);
      //~ ww.main_item.syncSize();
  //~ }
//~ };

//~ Lino.tools_close_handler = function (ww) {
  //~ return function() { 
      //~ ww.close();
  //~ }
//~ };
Lino.permalink_handler = function (ww) {
  return function() { 
    //~ document.location = ww.main_item.get_permalink();
    //~ console.log('20130723 Lino.permalink_handler',ww);
    
    /* Uncaught TypeError: Cannot read property 'main_item' of null  */
    if (ww) {
        var url = ww.main_item.get_permalink();
    } else {
        var url = Lino.viewport.get_permalink();
        //~ var url = '/';
    }
    Lino.load_url(url);
  }
};
//~ Lino.run_permalink = function() {
  //~ var plink = Lino.gup('permalink');
  //~ if(plink) { eval('Lino.'+plink); }
//~ }

Lino.ajax_error_handler = function(panel) {
  return function(response,options) {
    console.log('Ajax failure:',response,options);
    if (panel.loadMask) panel.loadMask.hide();
    if (response.responseText) {
      var lines = response.responseText.split('\n');
      if (lines.length > 10) {
          line = lines.splice(5,lines.length-10,"(...)");
      }
      Ext.MessageBox.alert(
        response.statusText,
        lines.join('<br/>')
        //~ response.responseText.replace(/\n/g,'<br/>'))
      )
    } else {
      Ext.MessageBox.alert('Action failed',
        'Lino server did not respond to Ajax request');
    }
  }
}
// Ext.Ajax.on('requestexception',Lino.ajax_error_handler)
 


Ext.QuickTips.init();

/* setting QuickTips dismissDelay to 0 */
// Apply a set of config properties to the singleton
//~ Ext.apply(Ext.QuickTips.getQuickTip(), {
//~ Ext.apply(Ext.ToolTip, {
    //~ dismissDelay: 0
    //~ autoHide: false,
    //~ closable: true,
    //~ maxWidth: 200,
    //~ minWidth: 100,
    //~ showDelay: 50      // Show 50ms after entering target
    //~ ,trackMouse: true
//~ });


//~ Ext.apply(Ext.QuickTip, {
    //~ dismissDelay: 0,
//~ });
  
Lino.quicktip_renderer = function(title,body) {
  return function(c) {
    //~ if (c instanceof Ext.Panel) var t = c.bwrap; else // 20130129
    if (c instanceof Ext.Panel) var t = c.header; else // 20130129
    var t = c.getEl();
    //~ console.log(20130129,t,title,body);
    //~ t.dismissDelay = 0;
    Ext.QuickTips.register({
      target: t,
      //~ cls: 'lino-quicktip-classical',
      dismissDelay: 0,
      //~ autoHide: false,
      showDelay: 50,      // Show 50ms after entering target
      //~ title: title,
      text: body
    });
  }
};


  
Lino.help_text_editor = function() {
  //~ var bp = {
      //~ mk:this.content_type,
      //~ mt:1
    //~ };
    //~ console.log(20120202,bp);
  //~ Lino.lino.ContentTypes.detail({},{base_params:bp});
  //~ Lino.lino.ContentTypes.detail.run(null,{record_id:this.content_type});
  Lino.lino.ContentTypes.detail.run(null,{record_id:this.content_type});
}

// Path to the blank image should point to a valid location on your server
//~ Ext.BLANK_IMAGE_URL = MEDIA_URL + '/extjs/resources/images/default/s.gif'; 


// used as Ext.grid.Column.renderer for id columns in order to hide the special id value -99999
Lino.id_renderer = function(value, metaData, record, rowIndex, colIndex, store) {
  //~ if (record.phantom) return '';
  return value;
}

Lino.raw_renderer = function(value, metaData, record, rowIndex, colIndex, store) {
  return value;
}

Lino.text_renderer = function(value, metaData, record, rowIndex, colIndex, store) {
  //~ return "not implemented"; 
  return value;
}

Lino.NullNumberColumn = Ext.extend(Ext.grid.Column, {
    align : 'right', 
    format : '0,00/i', 
    renderer : function(value, metaData, record, rowIndex, colIndex, store) {
        //~ console.log(20130128,"NullNumberColumn.renderer",value);
        if (value === null) return '';
        return Ext.util.Format.number(value, this.format);
    }
});

//~ Lino.NullNumberColumn = Ext.extend(Ext.grid.NumberColumn, {
    //~ align : 'right', 
    //~ constructor: function(cfg){
        //~ Ext.grid.NumberColumn.superclass.constructor.call(this, cfg);
        //~ var t = this;
        //~ this.renderer = function(value, metaData, record, rowIndex, colIndex, store) {
          //~ console.log(20130128,"NullNumberColumn.renderer",value);
          //~ if (value === null) return '';
          //~ return Ext.util.Format.number(value, t.format);
      //~ };
    //~ }
//~ });




//~ Lino.cell_button_renderer = function(value, metaData, record, rowIndex, colIndex, store) {
  //~ return '<input type="button" onclick="alert(value)" value=" ? ">' ;
//~ }


//~ Lino.default_renderer = function(value, metaData, record, rowIndex, colIndex, store) {
  //~ if (record.phantom) return '';
  //~ return value;
//~ }

Lino.fk_renderer = function(fkname,handlername) {
  //~ console.log('Lino.fk_renderer handler=',handler);
  return function(value, metaData, record, rowIndex, colIndex, store) {
    //~ console.log('Lino.fk_renderer',fkname,rowIndex,colIndex,record,metaData,store);
    //~ if (record.phantom) return '';
    if (value) {
        var s = '<a href="javascript:' ;
        s += handlername + '.run(null,{record_id:\'' + String(record.data[fkname]) + '\'})">';
        s += value + '</a>';
        //~ console.log('Lino.fk_renderer',value,'-->',s);
        return s
    }
    return '';
  }
};

Lino.lfk_renderer = function(panel,fkname) {
  //~ console.log('Lino.fk_renderer handler=',handler);
  var handlername = 'console.log';
  return function(value, metaData, record, rowIndex, colIndex, store) {
    //~ console.log('Lino.fk_renderer',fkname,rowIndex,colIndex,record,metaData,store);
    if (record.phantom) return '';
    if (value) {
        var s = '<a href="javascript:' ;
        s += handlername + '({},{record_id:\'' + String(record.data[fkname]) + '\'})">';
        s += value + '</a>';
        //~ console.log('Lino.fk_renderer',value,'-->',s);
        return s
    }
    return '';
  }
};

//~ Lino.gfk_renderer = function() {
  //~ return function(value, metaData, record, rowIndex, colIndex, store) {
    //~ if (record.phantom) return '';
    //~ console.log('Lino.gfk_renderer',value,colIndex,record,metaData,store);
    //~ return value;
  //~ }
//~ };


Lino.build_buttons = function(panel,actions) {
  //~ console.log("20121006 Lino.build_buttons",actions);
  if (actions) {
    var buttons = Array(actions.length);
    var cmenu = Array(actions.length);
    for (var i=0; i < actions.length; i++) { 
      buttons[i] = new Ext.Toolbar.Button(actions[i]);
      cmenu[i] = actions[i]
      cmenu[i].text = actions[i].menu_item_text;
      if (actions[i].panel_btn_handler) {
          var h = actions[i].panel_btn_handler.createCallback(panel,buttons[i]);
          //~ if (actions[i].must_save) {
          if (actions[i].auto_save == true) {
              buttons[i].on('click',panel.do_when_clean.createDelegate(panel,[true,h]));
          } else if (actions[i].auto_save == null) {
              buttons[i].on('click',panel.do_when_clean.createDelegate(panel,[false,h]));
          } else if (actions[i].auto_save == false) {
              buttons[i].on('click',h);
          } else {
              console.log("20120703 unhandled auto_save value",actions[i])
          }
          cmenu[i].handler = actions[i].panel_btn_handler.createCallback(panel,cmenu[i]);
      }
    }
    return {bbar:buttons, cmenu:new Ext.menu.Menu(cmenu)};
  }
}

Lino.do_when_visible = function(cmp,todo) {
  //~ if (cmp.el && cmp.el.dom) 
  if (cmp.isVisible()) { 
    // 'visible' means 'rendered and not hidden'
    //~ console.log(cmp.title,'-> cmp is visible now');
    todo(); 
  //~ } else {
      //~ cmp.on('resize',todo,cmp,{single:true});
  //~ }
  //~ if (false) { // 20120213
  } else { 
    //~ console.log('Lino.do_when_visible() must defer because not isVisible()',todo,cmp);
    if (cmp.rendered) {
      //~ console.log(cmp,'-> cmp is rendered but not visible: and now?');
      //~ console.log(cmp.title,'-> cmp is rendered but not visible: try again in a moment...');
      //~ var fn = function() {Lino.do_when_visible(cmp,todo)};
      //~ fn.defer(100);
      
      Lino.do_when_visible.defer(50,this,[cmp,todo]);
      //~ Lino.do_when_visible.defer(100,this,[cmp,todo]);
      
    } else {
      //~ console.log(cmp.title,'-> after render');
      cmp.on('afterrender',todo,cmp,{single:true});
    }
  }
  
};    

/*
*/
Lino.do_on_current_record = function(panel,fn,phantom_fn) {
  var rec = panel.get_current_record();
  if (rec == undefined) {
    Lino.notify("There's no selected record.");
    return;
  }
  // 20120307 A VirtualTable with a Detail (lino.Models) has only "phantom" records.
  if (rec.phantom) {
    //~ if (!panel.editable) { console.log("20120312 not editable:",panel)}
    if (phantom_fn) {
      phantom_fn(panel);
    } else {
      Lino.notify("Aktion nicht verfügbar auf dem Phantom-Record.");
    }
    return;
  }
  return fn(rec);
};






Lino.call_ajax_action = function(panel,method,url,p,actionName,step,on_confirm,on_success) {
  p.an = actionName;
  if (!panel) {
      if (Lino.current_window) 
          panel = Lino.current_window.main_item;
      else panel = Lino.viewport;
  }
  //~ console.log("20130809 Lino.call_ajax_action",panel);
  Ext.apply(p,panel.get_base_params());
  if (panel.loadMask) panel.loadMask.show(); 
  //~ p.$ext_requests.URL_PARAM_SUBST_USER = Lino.subst_user;
  //~ Lino.insert_subst_user(p);
    
  //~ if (step) p['$ext_requests.URL_PARAM_ACTION_STEP'] = step;
  //~ if (pp) pp(p); // "parameter processor" : first used for read beid card
  Ext.Ajax.request({
    method: method,
    url: url,
    params: p,
    success: Lino.action_handler(panel,on_success,on_confirm)
  });
};

Lino.row_action_handler = function(actionName,hm,pp) {
  var p = {};
  var fn = function(panel,btn,step) {
      if (pp) { p = pp(); if (! p) return; }
      
      if (panel.get_current_record == undefined) { // AFTER_20130725
        panel = Ext.getCmp(panel);
        if (panel == undefined) {
          Lino.notify("Invalid panel spec.");
          return;
        }
      }
      
      Lino.do_on_current_record(panel,function(rec) {
          //~ console.log(panel);
          //~ 20120723 Lino.call_ajax_action(panel,rec.id,actionName,step,fn);
          Lino.call_ajax_action(panel,hm,panel.get_record_url(rec.id),p,actionName,step,fn);
      });
  };
  return fn;
};

Lino.list_action_handler = function(ls_url,actionName,hm,pp) {
  var p = {};
  var url = '/api' + ls_url
  var fn = function(panel,btn,step) {
      //~ console.log("20121210 Lino.list_action_handler",arguments);
      //~ var url = ADMIN_URL + '/api' + panel.ls_url
      if (pp) { p = pp();  if (! p) return; }
      Lino.call_ajax_action(panel,hm,url,p,actionName,step,fn);
  };
  return fn;
};

Lino.param_action_handler = function(window_action) { // 20121012
  var fn = function(panel,btn,step) {
    Lino.do_on_current_record(panel,function(rec) {
      //~ console.log(panel);
      //~ 20120723 Lino.call_ajax_action(panel,rec.id,actionName,step,fn);
      window_action.run(panel.getId(),{}); 
    });
  };
  return fn;
};


//~ 20130726 Lino.run_row_action = function(requesting_panel,url,pk,actionName,pp) {
Lino.run_row_action = function(requesting_panel,url,meth,pk,actionName,preprocessor) {
  //~ var panel = action.get_window().main_item;
  url = '/api' + url  + '/' + pk;
  var panel = Ext.getCmp(requesting_panel);
  if (preprocessor) var p = preprocessor(); else var p = {};
  var fn = function(panel,btn,step) {
    //~ 20120723 Lino.call_ajax_action(panel,pk,actionName,step,fn);
    //~ 20130726 Lino.call_ajax_action(panel,'GET',url,p,actionName,step,fn);
    Lino.call_ajax_action(panel,meth,url,p,actionName,step,fn);
  }
  fn(panel,null,null);
}



Lino.show_detail = function(panel,btn) {
  Lino.do_on_current_record(panel, 
    function(rec) {
      //~ panel.loadMask.show();
      Lino.run_detail_handler(panel,rec.id);
    },
    Lino.show_insert
  );
};

Lino.run_detail_handler = function(panel,pk) {
  var bp = panel.get_base_params();
  //~ var bp = {};
  panel.add_param_values(bp); // 20120918
  var status = {
    record_id:pk,
    base_params:bp
    //~ param_values: pv.$ext_requests.URL_PARAM_PARAM_VALUES
  }
  //~ console.log("20120918 Lino.show_detail",status);
  panel.ls_detail_handler.run(null,status);
  //~ panel.loadMask.hide();
  //~ panel.containing_window.window.hideMask();
  //~ panel.el.unmask();
}

Lino.show_fk_detail = function(combo,detail_action) {
    //~ console.log("Lino.show_fk_detail",combo,handler);
    pk = combo.getValue();
    if (pk) {
        detail_action.run(null,{record_id: pk})
      } else {
        Lino.notify("Cannot show detail for empty foreign key.");
      }
};

Lino.show_insert = function(panel,btn) {
  var bp = panel.get_base_params();
  //~ console.log('20120125 Lino.show_insert',bp)
  //~ panel.ls_insert_handler.run(null,{record_id:-99999,base_params:bp});
  panel.ls_insert_handler.run(panel.getId(),{record_id:-99999,base_params:bp});
};

Lino.show_insert_duplicate = function(panel,btn) {
  Lino.do_on_current_record(panel,
    function(rec) {
      var newRec = {};
      Ext.apply(newRec,rec);
      newRec.id = -99999;
      panel.ls_insert_handler.run(null,{data_record:rec});
    });
};

//~ Lino.update_row_handler = function(action_name) {
  //~ return function(panel,btn) {
    //~ Lino.notify("Sorry, " + action_name + " is not implemented.");
  //~ }
//~ };




if (Ext.ux.grid !== undefined) {
    Lino.GridFilters = Ext.extend(Ext.ux.grid.GridFilters,{
      encode:true,
      local:false
    });
} else {
    Lino.GridFilters = function() {}; // dummy
    Ext.override(Lino.GridFilters,{
      init : function() {}
    });
};



//~ Lino.ButtonField = Ext.extend(Ext.form.TextField,{
//~ Lino.ButtonField = Ext.extend(Ext.form.Field,{
    //~ editable : false,
    //~ constructor : function(ww,config,params){
      //~ this.containing_window = ww;
      //~ if (params) Ext.apply(config,params);
      //~ Lino.ButtonField.superclass.constructor.call(this, config);
    //~ },
    //~ setButtons : function(buttons){
      //~ console.log('setButtons',buttons);
    //~ },
    //~ onRender : function(ct, position){
        //~ if(!this.el){
            //~ this.panel = new Ext.Container({items:[
              //~ {xtype:'button',text:'upload'},
              //~ {xtype:'button',text:'show'},
              //~ {xtype:'button',text:'edit'}
            //~ ]});
            //~ this.panel.ownerCt = this;
            //~ this.el = this.panel.getEl();

        //~ }
        //~ Lino.ButtonField.superclass.onRender.call(this, ct, position);
    //~ },

  
//~ });

Lino.FieldBoxMixin = {
  before_init : function(config,params) {
    if (params) Ext.apply(config,params);
    var actions = Lino.build_buttons(this,config.ls_bbar_actions);
    if (actions) config.bbar = actions.bbar;
  },
  //~ constructor : function(ww,config,params){
    //~ this.containing_window = ww;
    //~ if (params) Ext.apply(config,params);
    //~ var actions = Lino.build_buttons(this,config.ls_bbar_actions);
    //~ if (actions) config.bbar = actions.bbar;
    //~ Lino.FieldBoxMixin.superclass.constructor.call(this, config);
  //~ },
  do_when_clean : function(auto_save,todo) { todo() },
  //~ format_data : function(html) { return '<div class="htmlText">' + html + '</div>' },
  format_data : function(html) { return html },
  get_base_params : function() {
    // needed for insert action
    var p = Ext.apply({},this.base_params);
    Lino.insert_subst_user(p);
    return p;
  },
  set_base_params : function(p) {
    this.base_params = Ext.apply({},p);
    //~ if (p.param_values) this.set_param_values(p.param_values);  
  },
  clear_base_params : function() {
      this.base_params = {};
      Lino.insert_subst_user(this.base_params);
  },
  set_base_param : function(k,v) {
    this.base_params[k] = v;
  }
};



Lino.HtmlBoxPanel = Ext.extend(Ext.Panel,Lino.PanelMixin);
Lino.HtmlBoxPanel = Ext.extend(Lino.HtmlBoxPanel,Lino.FieldBoxMixin);
Lino.HtmlBoxPanel = Ext.extend(Lino.HtmlBoxPanel,{
  disabled_in_insert_window : true,
  constructor : function(config,params) {
    this.before_init(config,params);
    Lino.HtmlBoxPanel.superclass.constructor.call(this, config);
  },
  //~ constructor : function(ww,config,params){
    //~ this.ww = ww;
    //~ if (params) Ext.apply(config,params);
    //~ var actions = Lino.build_buttons(this,config.ls_bbar_actions);
    //~ if (actions) config.bbar = actions.bbar;
    //~ Lino.FieldBoxMixin.constructor.call(this, ww,config,params);
  //~ },
  //~ constructor : function(ww,config,params){
    //~ this.ww = ww;
    //~ if (params) Ext.apply(config,params);
    //~ var actions = Lino.build_buttons(this,config.ls_bbar_actions);
    //~ if (actions) config.bbar = actions.bbar;
    //~ Lino.FieldBoxMixin.superclass.constructor.call(this, config);
  //~ },
  //~ disable : function() { var tb = this.getBottomToolbar(); if(tb) tb.disable()},
  //~ enable : function() { var tb = this.getBottomToolbar(); if(tb) tb.enable()},
  onRender : function(ct, position){
    Lino.HtmlBoxPanel.superclass.onRender.call(this, ct, position);
    //~ console.log(20111125,this.containing_window);
    if (this.containing_panel) {
      this.containing_panel.on('enable',this.enable,this);
      this.containing_panel.on('disable',this.disable,this);
    }
    this.el.on({
      dragenter:function(event){
        event.browserEvent.dataTransfer.dropEffect = 'move';
        return true;
      }
      ,dragover:function(event){
        event.browserEvent.dataTransfer.dropEffect = 'move';
        event.stopEvent();
        return true;
      }
      ,drop:{
        scope:this
        ,fn:function(event){
          event.stopEvent();
          //~ console.log(20110516);
          var files = event.browserEvent.dataTransfer.files;
          if(files === undefined){
            return true;
          }
          var len = files.length;
          while(--len >= 0){
            console.log(files[len]);
            //~ this.processDragAndDropFileUpload(files[len]);
          }
          Lino.show_insert(this);
        }
      }
    });
  },
  refresh : function(unused) { 
      this.refresh_with_after();
  },
  refresh_with_after : function(after) {
    //~ if (this.master_panel) {
      var record = this.containing_panel.get_current_record();
      //~ console.log('HtmlBox.refresh()',this.title,record,record.title);
      var box = this.items.get(0);
      var todo = function() {
        if (this.disabled) return;
        //~ this.set_base_params(this.containing_window.get_base_params());
        this.set_base_params(this.containing_panel.get_master_params());
        var el = box.getEl();
        if (el) {
          el.update(record ? this.format_data(record.data[this.name]) : '');
          //~ console.log('20130723 HtmlBox.refresh()',this.name);
        //~ } else {
          //~ console.log('HtmlBox.refresh() failed for',this.name);
        }
      };
      Lino.do_when_visible(box,todo.createDelegate(this));
    //~ }
  }
});
//~ Ext.override(Lino.HtmlBoxPanel,Lino.FieldBoxMixin);



Lino.RichTextPanel = Ext.extend(Ext.Panel,Lino.PanelMixin);
Lino.RichTextPanel = Ext.extend(Lino.RichTextPanel,Lino.FieldBoxMixin);
Lino.RichTextPanel = Ext.extend(Lino.RichTextPanel,{
    
  //~ initComponent : function(){
    //~ Lino.RichTextPanel.superclass.initComponent.call(this);
  //~ },
  constructor : function(config,params) {
    //~ console.log('Lino.RichTextPanel.initComponent',this);
    //~ var url = TEMPLATES_URL + config.ls_url + "/" + String(rec.id) + "/" + config.name;
    //~ var url = TEMPLATES_URL + config.ls_url + "/" + config.name;
    var t = this;
    var tinymce_options = {
        theme : "advanced",
        content_css: '/media/lino/extjs/lino.css',
        language: 'en',
        //~ template_external_list_url : url,
        theme_advanced_toolbar_location : "top",
        theme_advanced_toolbar_align : "left",
        theme_advanced_statusbar_location : "bottom",
        template_popup_width : 700,
        template_popup_height : 500,
        template_replace_values : { 
            data_field : function(element){ 
                //~ console.log(20110722,fieldName,t.containing_window.get_current_record()); 
                var fieldName = element.innerHTML;
                element.innerHTML = t.containing_panel.get_current_record().data[fieldName];
            } 
        }
      };
      
    var editorConfig = {
      tinymceSettings: {
        plugins : "noneditable,template", 
        // Theme options - button# indicated the row# only
        theme_advanced_buttons1 : "bold,italic,underline,|,justifyleft,justifycenter,justifyright,|,bullist,numlist,|,outdent,indent,|,undo,redo,|,removeformat,template",
        theme_advanced_buttons2 : "",
        theme_advanced_buttons3 : "", // ,|,sub,sup,|,charmap",      
        theme_advanced_resizing : false
        //~ save_onsavecallback : save_callback,
        //~ save_enablewhendirty : true
        //~ save_oncancelcallback: on_cancel
        
    }};
    Ext.apply(editorConfig.tinymceSettings,tinymce_options);
    //~ editorConfig.name = config.action_name;
    editorConfig.name = config.name;
    delete config.name;
    //~ config.title = config.label;
    //~ delete config.label;
    this.before_init(config,params);
    
    this.editor = new Ext.ux.TinyMCE(editorConfig);
    var t = this;
    config.tools = [{
                      qtip: "Edit text in own window", 
                      id: "up",
                      handler: function(){
                        if(t.editor.isDirty()) {
                            var record = t.containing_panel.get_current_record();
                            record.data[t.editor.name] = t.editor.getValue();
                        }
                        Lino.edit_tinymce_text(t,tinymce_options)
                      }
                    }];
    
    config.items = this.editor;
    config.layout = "fit";
    Lino.RichTextPanel.superclass.constructor.call(this, config);
  },
  refresh : function(unused) { 
      this.refresh_with_after();
  },
  refresh_with_after : function(after) {
    var record = this.containing_panel.get_current_record();
    //~ console.log('RichTextPanel.refresh()',this.title,record.title,record);
    var todo = function() {
      //~ this.set_base_params(this.containing_window.get_base_params());
      if (record) {
        var url = '/templates' + this.containing_panel.ls_url + "/" 
            + String(record.id) + "/" + this.editor.name;
        //~ console.log('RichTextPanel.refresh()',url);
        if (this.editor.ed) this.editor.ed.settings.template_external_list_url = url;
        this.set_base_params(this.containing_panel.get_master_params());
        //~ var v = record ? this.format_data(record.data[this.editor.name]) : ''
        var v = this.format_data(record.data[this.editor.name])
        this.editor.setValue(v);
      } else {
        this.editor.setValue('(no data)');
      }
    };
    Lino.do_when_visible(this,todo.createDelegate(this));
  }
});
//~ Ext.override(Lino.RichTextPanel,Lino.FieldBoxMixin);



Lino.ActionFormPanel = Ext.extend(Ext.form.FormPanel,Lino.MainPanel);
Lino.ActionFormPanel = Ext.extend(Lino.ActionFormPanel,Lino.PanelMixin);
Lino.ActionFormPanel = Ext.extend(Lino.ActionFormPanel,Lino.FieldBoxMixin);
Lino.ActionFormPanel = Ext.extend(Lino.ActionFormPanel,{
  //~ layout:'fit'
  //~ ,autoHeight: true
  //~ ,frame: true
  window_title: "Action Parameters",
  constructor : function(config){
    config.bbar = [
        {text:'OK',handler:this.on_ok,scope:this},
        {text:'Cancel',handler:this.on_cancel,scope:this}
    ];
    //~ config.items = config.params_panel;
    Lino.ActionFormPanel.superclass.constructor.call(this, config);
  }
  //~ ,initComponent : function(){
    //~ Lino.ActionFormPanel.superclass.initComponent.call(this);
  //~ }
  ,on_cancel : function() { 
    this.get_containing_window().close();
  }
  ,on_ok : function() { 
    //~ var rp = this.requesting_panel;
    //~ console.log("on_ok",this.requesting_panel,arguments);
    var panel = this.requesting_panel;
    //~ if (panel == undefined) {
        //~ Lino.alert("Sorry, dialog actions don't work without a requesting_panel");
        //~ return;
    //~ }
    //~ var rec = panel.get_current_record();
    var actionName = this.action_name;
    var pk = this.base_params.mk;
    if (pk == undefined && panel) {
        pk = panel.get_current_record().id;
    }
    if (pk == undefined) {
        Lino.alert("Sorry, dialog action without base_params.mk");
        return;
    }
    var self = this;
    function on_success() { self.get_containing_window().close(); };
    var url = '/api' + this.ls_url + '/' + pk;
    var fn = function(panel,btn,step) {
      var p = {};
      self.add_field_values(p)
      //~ Lino.call_ajax_action(panel,'GET',panel.get_record_url(rec.id),p,actionName,step,fn,on_success);
      Lino.call_ajax_action(panel,'GET',url,p,actionName,step,fn,on_success);
    }
    fn(panel,null,null);
    
    
  }
  ,set_status : function(status,rp){
    this.requesting_panel = Ext.getCmp(rp);
    //~ console.log('20120918 ActionFormPanel.set_status()',status,rp,this.requesting_panel);
    this.clear_base_params();
    if (status == undefined) status = {};
    //~ if (status.param_values) 
    this.set_field_values(status.field_values);
    if (status.base_params) this.set_base_params(status.base_params);
  }
  
  ,add_field_values : function (p) { // similar to add_param_values()
      //~ 20121023 
      if (this.form.isDirty()) {
        p.fv = this.get_field_values();
      }else{
        if (this.status_field_values) 
          p.fv = Lino.fields2array(this.fields,this.status_field_values);
      }
      //~ if (!this.form.isDirty()) return;
      //~ p.$ext_requests.URL_PARAM_FIELD_VALUES = this.get_field_values();
      //~ console.log("20120203 add_param_values added pv",pv,"to",p);
  }
  ,get_field_values : function() {
      return Lino.fields2array(this.fields);
  }
  ,set_field_values : function(pv) {
      //~ console.log('20120203 MainPanel.set_param_values', pv);
      this.status_field_values = pv;
      if (pv) this.form.my_loadRecord(pv);
      else this.form.reset(); 
  }
  ,config_containing_window : function(wincfg) { 
      wincfg.title = this.window_title;
      wincfg.keys = [
        { key: Ext.EventObject.ENTER, fn: this.on_ok }
      ]
  }
});

//~ Lino.add_blank = function(oa) {
    //~ return [].concat(oa)
    //~ return 
    //~ }
    
Lino.fields2array = function(fields,values) {
    //~ console.log('20130605 fields2array gonna loop on', fields,values);
    var pv = Array(fields.length);
    for(var i=0; i < fields.length;i++) {
        var f = fields[i]
        if (values) 
          var v = values[f.name];
        else 
          var v = f.getValue();
        if (f.formatDate) {
            pv[i] = f.formatDate(v); 
        } else {
            pv[i] = v; // f.getValue(); 
        }
    }
    return pv;
}


Lino.FormPanel = Ext.extend(Ext.form.FormPanel,Lino.MainPanel);
Lino.FormPanel = Ext.extend(Lino.FormPanel,Lino.PanelMixin);
Lino.FormPanel = Ext.extend(Lino.FormPanel,{
  params_panel_hidden : false,
  //~ base_params : {},
  //~ trackResetOnLoad : true,
  //~ query_params : {},
  //~ 20110119b quick_search_text : '',
  constructor : function(config,params){
    if (params) Ext.apply(config,params);
    this.base_params = {};
    //~ ww.config.base_params.query = ''; // 20111018
    //~ console.log(config);
    //~ console.log('FormPanel.constructor() 1',config)
    //~ Ext.applyIf(config,{base_params:{}});
    //~ console.log('FormPanel.constructor() 2',config)
      
    config.trackResetOnLoad = true;
    
    Lino.FormPanel.superclass.constructor.call(this, config);
      
    //~ this.set_base_param('$URL_PARAM_FILTER',null); // 20111018
    //~ this.set_base_param('$URL_PARAM_FILTER',''); // 20111018
      
  },
  initComponent : function(){
    
    //~ console.log("20111201 containing_window",this.containing_window,this);
    
    var actions = Lino.build_buttons(this,this.ls_bbar_actions);
    if (actions) {
        this.bbar = actions.bbar;
    //~ } else {
        //~ this.bbar = [];
    }
    //~ Ext.apply(config,Lino.build_buttons(this,config.ls_bbar_actions));
    //~ config.bbar = Lino.build_buttons(this,config.ls_bbar_actions);
    //~ var config = this;
    
    //~ if (this.containing_window instanceof Lino.DetailWrapper) {
    
    //~ console.log('20120121 initComponent', this.action_name);
    //~ if (this.action_name == 'detail' | this.action_name == 'show') {
    //~ if (this.action_name != 'insert') {
    if (! this.hide_top_toolbar) {
      this.tbar = [];
      // 20111015    
      if (! this.hide_navigator) {
        this.record_selector = new Lino.RemoteComboFieldElement({
          store: new Lino.ComplexRemoteComboStore({
            //~ baseParams: this.containing_window.config.base_params,
            baseParams: this.get_base_params(),
            //~ value: this.containing_window.config.base_params.query,
            proxy: new Ext.data.HttpProxy({
              url: '/choices' + this.ls_url,
              method:'GET'
            })
          }),
          pageSize:25,
          listeners: { 
            scope:this, 
            select:function(combo,record,index) {
              //~ console.log('jumpto_select',arguments);
              this.goto_record_id(record.id);
            }
          },
          emptyText: "Gehe zu Datensatz"
        })
        this.tbar = this.tbar.concat([this.record_selector]);
        
        this.tbar = this.tbar.concat([
          this.first = new Ext.Toolbar.Button({
            tooltip:"Erster",disabled:true,handler:this.moveFirst,scope:this,iconCls:'x-tbar-page-first'}),
          this.prev = new Ext.Toolbar.Button({
            tooltip:"Voriger",disabled:true,handler:this.movePrev,scope:this,iconCls:'x-tbar-page-prev'}),
          this.next = new Ext.Toolbar.Button({
            tooltip:"Nächster",disabled:true,handler:this.moveNext,scope:this,iconCls:'x-tbar-page-next'}),
          this.last = new Ext.Toolbar.Button({
            tooltip:"Letzter",disabled:true,handler:this.moveLast,scope:this,iconCls:'x-tbar-page-last'})
        ]);
      }
      this.tbar = this.add_params_panel(this.tbar);
      
      //~ console.log(20101117,this.containing_window.refresh);
      this.tbar = this.tbar.concat([
        {
          //~ text:'Refresh',
          handler:function(){ this.do_when_clean(true,this.refresh.createDelegate(this)) },
          iconCls: 'x-tbar-loading',
          tooltip:"Datensatz neu laden",
          scope:this}
      ]);
          
      if (this.bbar) { // since 20121016
        if (this.tbar) {
            this.tbar = this.tbar.concat(['-']) ;
        } else {
          this.tbar = [];
        }
        this.tbar = this.tbar.concat(this.bbar) ;
        this.bbar = undefined;
      }
    
      this.tbar = this.tbar.concat([
          '->',
          this.displayItem = new Ext.Toolbar.TextItem({})
      ]);
          
    }
    //~ if (this.content_type && this.action_name != 'insert') {
      //~ this.bbar = this.bbar.concat([
        //~ '->',
        //~ { text: "[$_('Help Text Editor')]",
          //~ handler: Lino.help_text_editor,
          //~ qtip: "$_('Edit help texts for fields on this model.')",
          //~ scope: this}
      //~ ])
    //~ }
    //~ this.before_row_edit = config.before_row_edit.createDelegate(this);
      
    //~ if (this.master_panel) {
        //~ this.set_base_params(this.master_panel.get_master_params());
    //~ }
      
    Lino.FormPanel.superclass.initComponent.call(this);
    
    this.on('render',function(){
      this.loadMask = new Ext.LoadMask(this.bwrap,{msg:"Bitte warten..."});
    },this);
    
    
    //~ var this_ = this;
    //~ this.cascade(function(cmp){
      //~ // var active_field = false;
      //~ for (i = 0; i < this_.active_fields.length; i++) {
        //~ if (cmp.name == this_.active_fields[i]) {
            //~ // active_field = true; break;
            //~ cmp.on("change",function() {this_.save()});
        //~ }
      //~ };
      //~ if (active_field) {
      // if (cmp instanceof Lino.GridPanel) {
          //~ cmp.on("change",function() {this_.save()});
      //~ }
    //~ });
    
    if (this.action_name == 'insert') {
      this.cascade(function(cmp){
        // console.log('20110613 cascade',cmp);
        if (cmp.disabled_in_insert_window) {
            //~ cmp.disable();
            cmp.hide();
        }
      });
      
    }
    
  },
  
  unused_is_loading : function() { 
    if (this.current_record == null) {
        //~ console.log("20130515 current_record is null");
        return true; 
    }
    
    if (! this.loadMask) return true; // not even rendered: 
    if (! this.loadMask.el) return true; // not even rendered: 
    // thanks to Marco Pegoraro http://movableapp.com/2011/09/sencha-touch-loadmask-isvisible/
    var loading = (this.loadMask.el.select('.x-loading-msg').elements.length > 0);
    //~ console.log('20130515 GridPanel.is_loading() returns',loading);
    return loading;

    
    var loading = false;
    this.cascade(function(cmp){
        if (cmp instanceof Lino.GridPanel && cmp.is_loading()) {
            //~ console.log(20130515, cmp.title,'is loading');
            loading = true;
            return false;
        }
      });
    return loading;
    //~ var a = this.findByType(Lino.GridPanel);
    //~ for (i=0;i<a.length;i++) {
        //~ if (a[i].is_loading()) return true;
    //~ }
    //~ return false;
  },
  
  get_status : function(){
      var st = {
        base_params: this.get_base_params(),
        data_record : this.get_current_record()
        }
      var tp = this.items.get(0);
      if (tp instanceof Ext.TabPanel) {
        st.active_tab = tp.getActiveTab();
      }
      st.param_values = this.status_param_values;
      return st;
  },
  /* FormPanel */
  set_status : function(status,rp){
    this.requesting_panel = Ext.getCmp(rp);
    //~ console.log('20120918 FormPanel.set_status()',status);
    this.clear_base_params();
    if (status == undefined) status = {};
    //~ if (status.param_values) 
    this.set_param_values(status.param_values);
    if (status.base_params) this.set_base_params(status.base_params);
    var tp = this.items.get(0);
    if (tp instanceof Ext.TabPanel) {
      if (status.active_tab) {
        //~ console.log('20111201 active_tab',this.active_tab,this.items.get(0));
        //~ tp.activeTab = status.active_tab;
        tp.setActiveTab(status.active_tab);
        //~ this.main_item.items.get(0).activate(status.active_tab);
      } else {
        tp.setActiveTab(0);
      }
      }
    
    if (status.data_record) {
      //~ console.log('20111201 Lino.FormPanel with data_record',this.data_record.title,this.containing_window);
      //~ this.main_item.on_master_changed.defer(2000,this.main_item,[status.data_record]);
      //~ Lino.do_when_visible(this.main_item,function(){this.on_master_changed(status.data_record)});
      //~ this.main_item.on('afterrender',function(){
      //~   this.main_item.on_master_changed(status.data_record)},this,{single:true});
      /* must defer because because set_window_title() didn't work otherwise */
      this.set_current_record.createDelegate(this,[status.data_record]).defer(100);
      //~ this.set_current_record(this.data_record);
      //~ return;
    } else if (status.record_id != undefined) { 
      /* possible values include 0 and null, 0 being a valid record id, 
      null the equivalent of undefined
      */
      //~ this.main_item.goto_record_id(this.status.record_id);
      this.load_record_id(status.record_id);
    } else {
      this.set_current_record(undefined);
    }
  },
    
  get_base_params : function() {
    // needed for insert_action
    var p = Ext.apply({},this.base_params);
    Lino.insert_subst_user(p);
    return p;
    //~ return this.base_params;
  },
  set_base_params : function(p) {
    //~ this.base_params = Ext.apply({},this.base_params); // make sure it is an instance variable
    delete p['query'] // 20120725
    Ext.apply(this.base_params,p);
    if (this.record_selector) {
        var store = this.record_selector.getStore();
        for (k in p) store.setBaseParam(k,p[k]);
        delete this.record_selector.lastQuery;
        //~ console.log("20120725 record_selector.setBaseParam",p)
    }
  },
  clear_base_params : function() {
      this.base_params = {};
      Lino.insert_subst_user(this.base_params);
        
      //~ if (this.record_selector) {
          //~ var store = this.record_selector.getStore();
          //~ for (k in store.baseParams) store.setBaseParam(k,undefined);
          //~ delete this.record_selector.lastQuery;
          //~ console.log("20120725 record_selector.getBaseParams() -->",store.baseParams)
      //~ }
  },
  set_base_param : function(k,v) {
    //~ this.base_params = Ext.apply({},this.base_params); // make sure it is an instance variable
    this.base_params[k] = v;
    //~ if (this.record_selector) {
        //~ this.record_selector.getStore().setBaseParam(k,v);
        //~ delete this.record_selector.lastQuery;
    //~ }
  },
  
  after_delete : function() {
    if (this.current_record.navinfo.next)
      this.moveNext();
    else if (this.current_record.navinfo.prev)
      this.movePrev();
    else 
      this.abandon();
  },
  moveFirst : function() {this.goto_record_id(this.current_record.navinfo.first)},
  movePrev : function() {this.goto_record_id(this.current_record.navinfo.prev)},
  moveNext : function() {this.goto_record_id(this.current_record.navinfo.next)},
  moveLast : function() {this.goto_record_id(this.current_record.navinfo.last)},
  
  
  refresh : function(unused) { 
      this.refresh_with_after();
  },
  refresh_with_after : function(after) { 
    //~ console.log('20120121 Lino.FormPanel.refresh()',this);
    if (this.current_record) {
        this.load_record_id(this.current_record.id,after);
    } else {
        this.set_current_record(undefined,after);
    }
  },
  
  do_when_clean : function(auto_save,todo) {
    var this_ = this;
    if (this.form.isDirty()) {
        if (auto_save) {
            this_.save(todo);
        } else {
          //~ console.log('20111217 do_when_clean() form is dirty',this.form);
          var config = {title:"Bestätigung"};
          config.buttons = Ext.MessageBox.YESNOCANCEL;
          config.msg = "Änderungen in diesem Datensatz speichern?";
          config.fn = function(buttonId,text,opt) {
            //~ console.log('do_when_clean',buttonId)
            if (buttonId == "yes") {
                //~ Lino.submit_detail(this_,undefined,todo);
                //~ this_.containing_window.save(todo);
                this_.save(todo);
            } else if (buttonId == "no") { 
              todo();
            }
          }
        }
        Ext.MessageBox.show(config);
    }else{
      //~ console.log('do_when_clean : now!')
      todo();
    }
  },
  
  goto_record_id : function(record_id) {
    //~ console.log('20110701 Lino.FormPanel.goto_record_id()',record_id);
    //~ var this_ = this;
    //~ this.do_when_clean(function() { this_.load_record_id(record_id) }
    this.do_when_clean(true,this.load_record_id.createDelegate(this,[record_id]));
  },
  
  load_record_id : function(record_id,after) {
    var this_ = this;
    //~ var p = { fmt: this.containing_window.config.action_name};
    //~ var p = Ext.apply({},this.containing_window.config.base_params);
    var p = Ext.apply({},this.get_base_params());
    //~ Lino.insert_subst_user(p);
    //~ console.log('20110713 action_name=',this.containing_window.config.action_name,
      //~ 'base_params=',this.containing_window.config.base_params);
    if (this.action_name)
        p.an = this.action_name;
    //~ p.an = this.action_name;
    //~ p.an = this.containing_window.config.action_name;
    //~ p.fmt = 'json';
    //~ p.fmt = '$ext_requests.URL_FORMAT_JSON';
    p.rp = this.getId();
    //~ p.$ext_requests.URL_PARAM_SUBST_USER = Lino.subst_user;
    p.fmt = 'json';
    //~ 20110119b p['$URL_PARAM_FILTER'] = this.quick_search_text;
    //~ Ext.apply(p,this.query_params);
    this.add_param_values(p);
    //~ console.log('20121120 FormPanel.load_record_id',record_id,p);
    if (this.loadMask) this.loadMask.show();
    Ext.Ajax.request({ 
      waitMsg: 'Loading record...',
      method: 'GET',
      params: p,
      scope: this,
      url: this.get_record_url(record_id),
      success: function(response) {   
        // todo: convert to Lino.action_handler.... but result 
        if (this.loadMask) this.loadMask.hide();
        if (response.responseText) {
          var rec = Ext.decode(response.responseText);
          //~ console.log('20120918 goto_record_id success',rec);
          this.set_param_values(rec.param_values);
          this.set_current_record(rec,after);
        }
      },
      failure: Lino.ajax_error_handler(this)
    });
  },

  abandon : function () {
    Ext.MessageBox.alert('Note',
      "Keine weiteren Datensätze zu sehen. Detail-Fenster wird geschlossen.");
    Lino.close_window();
    //~ if (this.containing_window) {
        //~ this.containing_window.hide();
    //~ }
  },
  
  set_current_record : function(record,after) {
    //~ console.log('20120722 Lino.FormPanel.set_current_record',record.title,record);
    if (this.record_selector) {
        this.record_selector.clearValue();
        // e.g. InsertWrapper FormPanel doesn't have a record_selector
    }
    this.current_record = record;
    //~ if (record) 
        //~ console.log('Lino.FormPanel.set_current_record',record.title,record);
    //~ else
        //~ console.log('Lino.FormPanel.set_current_record',record);
    //~ this.config.main_panel.form.load(record);    
    if (record) {
      this.enable();
      this.form.my_loadRecord(record.data);
      this.set_window_title(record.title);
      //~ this.getBottomToolbar().enable();
      var da = record.data.disabled_actions;
      if (da) {
          //~ console.log('20120528 disabled_actions =',da,this.getBottomToolbar());
          //~ 20121016 this.getBottomToolbar().items.each(function(item,index,length){
          var tb = this.getTopToolbar();
          if (tb) tb.items.each(function(item,index,length){
              //~ console.log('20120528 ',item.itemId,'-->',da[item.itemId]);
              if (da[item.itemId]) item.disable(); else item.enable();
          });
      };
      if (this.disable_editing | record.data.disable_editing) {
          //~ console.log("20120202 disable_editing",record.title);
          this.form.items.each(function(cmp){
            if (!cmp.always_enabled) cmp.disable();
          },this);
      } else {
          this.form.items.each(function(cmp){
            //~ console.log("20120202",cmp);
            if (record.data.disabled_fields[cmp.name]) cmp.disable();
            else cmp.enable();
          },this);
        
          //~ if (record.data.disabled_fields) {
              //~ for (i = 0; i < record.data.disabled_fields.length; i++) {
                  //~ var flds = this.find('name',record.data.disabled_fields[i]);
                  //~ if (flds.length == 1) { 
                    //~ flds[0].disable(); 
                  //~ }
              //~ }
          //~ }
      };
      if (this.first) {
        if (record.navinfo  && ! this.hide_navigator) {
          this.first.setDisabled(!record.navinfo.first);
          this.prev.setDisabled(!record.navinfo.prev);
          this.next.setDisabled(!record.navinfo.next);
          this.last.setDisabled(!record.navinfo.last);
          this.displayItem.setText(record.navinfo.message);
        } else {
          this.first.setDisabled(true);
          this.prev.setDisabled(true);
          this.next.setDisabled(true);
          this.last.setDisabled(true);
        }
      }
    } else {
      if (this.form.rendered) 
        this.form.reset(); /* FileUploadField would fail when resetting a non-rendered form */
      //~ this.disable();
      //~ this.getBottomToolbar().disable();
      this.form.items.each(function(cmp){
        cmp.disable();
      },this);
      this.set_window_title(this.empty_title);
      //~ this.containing_window.window.setTitle(this.empty_title);
      if (!this.hide_navigator) {
        this.first.disable();
        this.prev.disable();
        this.next.disable();
        this.last.disable();
      }
    }
    //~ console.log('20100531 Lino.DetailMixin.on_load_master_record',this.main_form);
    this.before_row_edit(record);
    if (after) after();
  },
  
  before_row_edit : function(record) {},
  search_change : function(field,oldValue,newValue) {
    //~ console.log('search_change',field.getValue(),oldValue,newValue)
    this.set_base_param('query',field.getValue()); 
    this.refresh();
  },
  
  get_selected : function() { return [ this.current_record ] },
  get_current_record : function() {  
    //~ console.log(20100714,this.current_record);
    return this.current_record 
  },
  
  get_permalink_url : function() {
      var rec = this.get_current_record();
      if (rec && ! rec.phantom && rec.id != -99998)
          return '/api' + this.ls_url + '/' + rec.id;
      return '/api' + this.ls_url;
    
  },
  get_permalink_params : function() {
    var p = {};
    //~ var p = {an:'detail'};
    if (this.action_name)
        p.an = this.action_name;
    //~ var p = {an:this.action_name};
    var main = this.items.get(0);
    if (main.activeTab) {
      var tab = main.items.indexOf(main.activeTab);
      //~ console.log('main.activeTab',tab,main.activeTab);
      if (tab) p.tab = tab;
    }
    this.add_param_values(p)
    return p;
  },
  
  /* 
  Lino.FormPanel.save() 
  */
  save : function(after,switch_to_detail,action_name) {
    //~ var panel = this;
    //~ console.log('20121120 FormPanel.save');
    this.loadMask.show();
    var rec = this.get_current_record();
    if (this.has_file_upload) this.form.fileUpload = true;
    //~ console.log('FormPanel.save()',rec);
    if (!action_name) action_name = this.action_name;
    if (rec) {
      var p = {};
      Ext.apply(p,this.get_base_params());
      p.rp = this.getId();
      //~ if (this.action_name) 
          //~ p.$ext_requests.URL_PARAM_ACTION_NAME = this.action_name;
      p.an = action_name;
      if (rec.phantom) {
        //~ if (this.action_name != 'insert') 
            //~ console.log("Warning: phantom record, but action_name is",this.action_name)
        this.form.submit({
          url: '/api' + this.ls_url,
          method: 'POST',
          params: p, 
          scope: this,
          success: function(form, action) {
            this.loadMask.hide();
            Lino.notify(action.result.message);
            /***
            Close this window, but update the status of the 
            calling window.
            If the calling window is a detail on the same table,
            then it should skip to the new record. But only then.
            A successful response usually has a data_record,
            except if it is a fileupload form where some mysterious 
            decoding problems (20120209) force us to return a record_id 
            which will lead to an additional GET.
            ***/
            var url = this.ls_url;
            var ww = Lino.calling_window();
            if (ww && ww.window.main_item instanceof Lino.FormPanel 
                   && ww.window.main_item.ls_url == this.ls_url) {
                //~ console.log("20120217 case 1");
                ww.status.record_id = action.result.record_id;
                ww.status.data_record = action.result.data_record;
                Lino.close_window();
            } else if (this.ls_detail_handler && switch_to_detail) {
                //~ console.log("20120217 case 2");
                Lino.kill_current_window();
                this.ls_detail_handler.run(null,{
                    record_id:action.result.record_id,
                    data_record: action.result.data_record,
                    base_params:this.get_base_params()
                });
            } else {
                //~ console.log("20120217 case 3");
                Lino.close_window();
            }
            //~ Lino.close_window(function(ww){
                //~ if (ww.window.main_item instanceof Lino.FormPanel 
                    //~ && ww.window.main_item.ls_url == url) {
                  //~ ww.status.record_id = action.result.record_id,
                  //~ ww.status.data_record = action.result.data_record
                //~ }
            //~ });
          },
          failure: function(form,action) { 
            this.loadMask.hide();
            Lino.on_submit_failure(form,action);
          },
          clientValidation: true
        })
      } else {
        //~ if (this.action_name != 'detail') 
            //~ console.log("Warning: non-phantom record, but action_name is",this.action_name)
        this.form.submit({
          url: '/api' + this.ls_url + '/' + rec.id,
          method: 'PUT',
          //~ headers: { 'HTTP_X_REQUESTED_WITH' : 'XMLHttpRequest'},
          scope: this,
          params: p, 
          success: function(form, action) {
            //~ panel.form.setValues(rec.data);
            //~ 20110701 panel.form.my_loadRecord(rec);
            this.loadMask.hide();
            Lino.notify(action.result.message);
            if (action.result.data_record)
                this.set_current_record(action.result.data_record,after);
            else
                console.log("Warning: no data_record in response to FormPanel.PUT")
            //~ this.refresh_with_after(after);
            //~ if (after) after(); else panel.refresh();
          },
          failure: function(form,action) { 
            this.loadMask.hide();
            Lino.on_submit_failure(form,action)},
          clientValidation: true
        })
      }
    } else Lino.notify("Sorry, no current record.");
  }
  
  ,on_cancel : function() { 
    this.get_containing_window().close();
  }
  ,on_ok : function() { 
      this.save(null,true);
      //~ var rec = this.get_current_record();
      //~ if (rec && rec.phantom)
          //~ this.do_when_clean(true,function() { Lino.close_window(); });
  }
  ,config_containing_window : function(wincfg) { 
      wincfg.keys = [
        { key: Ext.EventObject.ENTER, fn: this.on_ok, scope:this }
        ,{ key: Ext.EventObject.ESCAPE, fn: this.on_cancel, scope:this }
      ]
  }
  
  
  /* not used (no longer possible without .dtl files)
  , edit_detail_config : function () {
    var active_tab = {};
    var main = this.items.get(0);
    if (main.getActiveTab !== undefined) {
      var tabitem = main.getActiveTab();
      Ext.apply(active_tab,{$ext_requests.URL_PARAM_TAB : main.items.indexOf(tabitem)});
    }
    var editor = new Ext.form.TextArea();
    var close = function() { win.close(); }
    var _this = this;
    var save = function() { 
      //~ console.log(20110609,arguments); 
      var params = {desc: editor.getValue()};
      Ext.apply(params,active_tab);
      var a = { 
        params: params, 
        method: 'PUT',
        url: ADMIN_URL + '/detail_config' + _this.ls_url,
        failure : Lino.ajax_error_handler(this),
        success: Lino.action_handler( _this, function(result) {
          //~ console.log('detail_config/save success',result);
          win.close();
          document.location = _this.get_permalink();
        })
      };
      //~ console.log('detail_config/save sent',a);
      _this.loadMask.show(); // 20120211
      Ext.Ajax.request(a);
    }
    var save_btn = new Ext.Button({text:'Save',handler:save,disabled:true});
    var win = new Ext.Window({title:'Detail Layout',
      items:editor, layout:'fit',
      width:500,height:500,
      bbar:[{text:'Cancel',handler:close},save_btn]});
    var a = { 
      params:active_tab, 
      method:'GET',
      url:ADMIN_URL+'/detail_config'+_this.ls_url,
      success : function(response) {
        if (response.responseText) {
          var result = Ext.decode(response.responseText);
          if (result.success) {
            editor.setValue(result.desc);
            save_btn.enable();
          }
        }
      }
    };
    Ext.Ajax.request(a);
    win.show();
  }
  */
});



Lino.getRowClass = function(record, rowIndex, rowParams, store) {
    //~ console.log(20130816,record);
    //~ return 'x-grid3-row-green';
    return record.data.row_class;
  //~ if (true) {
      //~ return 'x-grid3-row-red';
  //~ }
  //~ if (record.phantom) {
    //~ console.log(20101009,record);
    //~ rowParams.bodyStyle = "color:red;background-color:blue";
    //~ return 'lino-phantom-row';
    //~ }
  //~ console.log('20101009 not a phantom:',record);
  //~ return '';
}

//~ FOO = 0;



Lino.GridStore = Ext.extend(Ext.data.ArrayStore,{ 
  autoLoad: false
  ,load: function(options) {
    //~ foo.bar = baz; // 20120213
    if (!options) options = {};
    if (!options.params) options.params = {};
    options.params.fmt = 'json';
    options.params.rp = this.grid_panel.getId();
    Lino.insert_subst_user(options.params); // since 20121016
      
    if (this.grid_panel.hide_top_toolbar) {
        //~ console.log("20120206 GridStore.load() toolbar is hidden");
        options.params.start = 0;
        if (this.grid_panel.preview_limit) {
          options.params.limit = this.grid_panel.preview_limit;
        }
    } else {
        var ps = this.grid_panel.calculatePageSize();
        if (!ps) {
            //~ this.gridpanel.on('render',this.load())
          //~ console.log("20120814 GridStore.load() failed to calculate pagesize");
          return false;
            //~ params.$URL_PARAM_LIMIT = 1;
            //~ this.grid_panel.on('render',this.load.createDelegate(this,options))
            //~ return;
        } 
        options.params.limit = ps;
      
        //~ options.params.start = this.grid_panel.getTopToolbar().cursor;
        //~ if (this.grid_panel.getTopToolbar().pageSize !=  ps) {
          //~ console.log("20120206 abort load because toolbar says pagesize",
            //~ this.grid_panel.getTopToolbar().pageSize,
            //~ "while actual pagesize is",ps);
            //~ return;
        //~ }
        
        this.grid_panel.getTopToolbar().pageSize =  ps;
        if (options.params.start == undefined)
            options.params.start = this.grid_panel.getTopToolbar().cursor;
      
    }
      
    this.grid_panel.add_param_values(options.params,true);
    //~ Lino.insert_subst_user(options.params);
    //~ console.log("20120814 GridStore.load()",options.params,this.baseParams);
    //~ if (FOO > 0) {
        //~ foo.bar = baz;
    //~ } else FOO += 1;
    return Lino.GridStore.superclass.load.call(this,options);
  }
});

    
Lino.GridPanel = Ext.extend(Ext.grid.EditorGridPanel,Lino.MainPanel);
Lino.GridPanel = Ext.extend(Lino.GridPanel,Lino.PanelMixin);
Lino.GridPanel = Ext.extend(Lino.GridPanel,{
  quick_search_text : '',
  is_searching : false,
  disabled_in_insert_window : true,
  clicksToEdit:2,
  enableColLock: false,
  autoHeight: false,
  params_panel_hidden : false,
  preview_limit : undefined, 
  //~ loadMask: true,
  //~ viewConfig: {
          //~ getRowClass: Lino.getRowClass,
          //~ emptyText:"$_('No data to display.')"
        //~ },
  loadMask: {msg:"Bitte warten..."},
  
  constructor : function(config){

    config.plugins = [new Lino.GridFilters()];
    
    
    Lino.GridPanel.superclass.constructor.call(this,config);
    
    //~ if (this.containing_window) {
        //~ console.log("20111206 install refresh");
        //~ this.containing_window.on('show',this.refresh,this);
    //~ }
    
  },
  
  unused_is_loading : function() { 
    if (! this.loadMask.el) return true; // not even rendered: 
    // thanks to Marco Pegoraro http://movableapp.com/2011/09/sencha-touch-loadmask-isvisible/
    var loading = (this.loadMask.el.select('.x-loading-msg').elements.length > 0);
    //~ console.log('20130515 GridPanel.is_loading() returns',loading);
    return loading;
    //~ return this.store.getCount() > 0; 
    //~ return (this.loadMask.el.select('.x-loading-msg').elements.length)
    //~ return !this.viewReady; 
    //~ return this.loadMask.isVisible(); 
    //~ return !this.loadMask.disabled; 
  },
  
  unused_config_containing_window : function(wincfg) { 
      //~ temporarily remove save_grid_config button (see /blog(2012/1107)
      if (wincfg.tools != undefined) 
        wincfg.tools = [
          //~ {handler:this.save_grid_data,
            //~ qtip:"$_("Save Grid Data")",
            //~ scope:this, id:"save_data"}, // 20120814
          {handler:this.save_grid_config,
            qtip:"Tabellenkonfiguration speichern",
            scope:this, id:"save"}
        ].concat(wincfg.tools);
      //~ wincfg.listeners = { show: ... };
  },
  init_containing_window : function(win) { 
    //~ console.log("20111206 install refresh");
    //~ win.on('show',this.refresh,this);
  },
  
  initComponent : function(){
    
    /* 
    Problem 20111206:
    When a GridPanel is the main item of the window, then it doesn't 
    have it's own header but uses the window's header bar.
    We must do this in initComponent because e.g. in beforerender 
    it's already to late: a header element has been created because 
    there was a title.
    But Lino.Window adds itself as `this.containing_window` 
    only after the GridPanel has been initialized.
    Workaround is to generate a line "params.containing_window = true;" 
    in the handler function.
    */ 
    //~ if (this.containing_window) {
    if (this.is_main_window) {
        //~ console.log(20111206, 'delete title',this.title,'from',this);
        //~ delete this.title;
        this.tools = undefined;  
        this.title = undefined;  /* simply deleting it 
          isn't enough because that would only 
          unhide the title defined in some base class. */
    } 
    //~ else console.log(20111206, 'dont delete title',this.title,'from',this);
    
    /* e.g. when slave gridwindow called from a permalink */
    //~ if (this.base_params) Ext.apply(bp,this.base_params);  
    //~ bp['fmt'] = 'json';
    
    //~ function on_proxy_write( proxy, action,data, response,rs,options) {
      //~ console.log('20120814 on_proxy_write',action,data,response)
      //~ this.getStore().doUpdate();
      //~ this.getStore().loadData(data);
    //~ }
    //~ function on_proxy_load( proxy, transactionObject, callbackOptions ) {
      //~ console.log('on_proxy_load',transactionObject)
    //~ }
    var proxy = new Ext.data.HttpProxy({ 
      // 20120814 
      url: '/api' + this.ls_url
      ,method: "GET"
      //~ ,url: ADMIN_URL + '/restful' + this.ls_url
      //~ ,restful: true 
      //~ ,listeners: {load:on_proxy_load} 
      //~ ,listeners: {write:on_proxy_write} 
    });
    //~ config.store = new Ext.data.JsonStore({ 
    //~ this.store = new Ext.data.ArrayStore({ 
    this.store = new Lino.GridStore({ 
      grid_panel: this
      ,listeners: { exception: Lino.on_store_exception }
      ,remoteSort: true
      ,totalProperty: "count"
      ,root: "rows"
      //~ ,id: "id" 
      ,proxy: proxy
      //~ autoLoad: this.containing_window ? true : false
      ,idIndex: this.pk_index
      //~ ,baseParams: bp
      ,fields: this.ls_store_fields
      ,idProperty: this.ls_id_property 
      // 20120814
      //~ ,writer : new Ext.data.JsonWriter({
        //~ writeAllFields: false
        //~ ,listful: true
      //~ })
      //~ ,restful : true
    });
      
    //~ console.log('config.pk_index',config.pk_index,config.store),
    delete this.ls_store_fields;
      
    var this_ = this;
    //~ var grid = this;
    this.store.on('load', function() {
        //~ console.log('20120814 GridStore.on(load)',this_.store);
        //~ var da = this_.store.reader.arrayData.disabled_actions;
        //~ if (da) {
            //~ this.cmenu.cascade(function(item){ 
              //~ console.log(20120531, item.itemId, da[item.itemId]);
              //~ if (da[item.itemId]) item.disable(); else item.enable();
            //~ });
        //~ };
        this_.set_param_values(this_.store.reader.arrayData.param_values);
        //~ this_.set_status(this_.store.reader.arrayData.status);
        //~ 20120918
        this.getView().getRowClass = Lino.getRowClass;
        if (this_.store.reader.arrayData.no_data_text) {
            //~ this.viewConfig.emptyText = this_.store.reader.arrayData.no_data_text;
            this.getView().emptyText = this_.store.reader.arrayData.no_data_text;
            this.getView().refresh();
        }
        if (this_.containing_window)
            this_.set_window_title(this_.store.reader.arrayData.title);
            //~ this_.containing_window.setTitle(this_.store.reader.arrayData.title);
        if (!this.is_searching) { // disabled 20121025: quick_search_field may not lose focus
          this.is_searching = false;
          if (this_.selModel.getSelectedCell){
              if (this_.getStore().getCount()) // there may be no data
                  this_.selModel.select(0,0); 
          } else {
              this_.selModel.selectFirstRow();
              this_.getView().focusEl.focus();
          }
        } 
        //~ else console.log("is_searching -> no focussing");
        //~ var t = this.getTopToolbar();
        //~ var activePage = Math.ceil((t.cursor + t.pageSize) / t.pageSize);
        //~ this.quick_search_field.focus(); // 20121024
      }, this
    );
    var actions = Lino.build_buttons(this,this.ls_bbar_actions);
    //~ Ext.apply(config,Lino.build_buttons(this,config.ls_bbar_actions));
    //~ config.bbar, this.cmenu = Lino.build_buttons(this,config.ls_bbar_actions);
    //~ this.cmenu = new Ext.menu.Menu({items: config.bbar});
    delete this.ls_bbar_actions
    if (actions) {
        this.cmenu = actions.cmenu;
    }
    
    if (!this.hide_top_toolbar) {  
      var tbar = [ 
        this.quick_search_field = new Ext.form.TextField({ 
          //~ fieldLabel: "Search"
          listeners: { 
            scope:this_
            //~ ,change:this_.search_change
            
            ,render: Lino.quicktip_renderer("Schnellsuche","Hier Text eingeben für Schnellsuche.")
            
            //~ ,keypress: this.search_keypress 
            ,blur: function() { this.is_searching = false}
          }
          ,validator:function(value) { return this_.search_validate(value) }
          //~ ,tooltip: "Enter a quick search text, then press TAB"
          //~ value: text
          //~ scope:this, 
          //~ ,enableKeyEvents: true
          //~ listeners: { keypress: this.search_keypress }, 
          //~ id: "seachString" 
      })];
      tbar = this.add_params_panel(tbar);
      tbar = tbar.concat([
        { scope:this, 
          //~ text: "[csv]", 
          tooltip: "Diese Tabelle in eine .csv-Datei exportieren", 
          iconCls: 'x-tbar-csv',
          handler: function() { 
            //~ 20130116 var p = Ext.apply({},this.get_base_params());
            //~ 20130116 p.fmt = 'csv';
            //~ url += "?" + Ext.urlEncode(p);
            var p = this.get_current_grid_config();
            Ext.apply(p,this.get_base_params());
            p.fmt = "csv";
            this.add_param_values(p,true);
            
            window.open('/api'+this.ls_url + "?" + Ext.urlEncode(p)) 
          } },
        //~ { scope:this, 
          //~ text: "[html]", 
          //~ handler: function() { 
            //~ var p = this.get_current_grid_config();
            //~ Ext.apply(p,this.get_base_params());
            //~ p.$ext_requests.URL_PARAM_FORMAT = "$ext_requests.URL_FORMAT_PRINTER";
            //~ this.add_param_values(p);
            //~ window.open(ADMIN_URL+'/api'+this.ls_url + "?" + Ext.urlEncode(p)) 
          //~ } },
        { scope:this, 
          //~ text: "[html]", 
          tooltip: "Tabelle als HTML anzeigen", 
          iconCls: 'x-tbar-html',
          handler: function() { 
            var p = this.get_current_grid_config();
            Ext.apply(p,this.get_base_params());
            //~ since 20121226 p.$ext_requests.URL_PARAM_FORMAT = "$ext_requests.URL_FORMAT_PLAIN";
            this.add_param_values(p,true);
            //~ since 20121226 window.open(ADMIN_URL+'/api'+this.ls_url + "?" + Ext.urlEncode(p)) 
            window.open('/plain'+this.ls_url + "?" + Ext.urlEncode(p)) 
          } }
        
        ,{ scope:this, 
          //~ text: "[pdf]", 
          tooltip: "Diese Tabelle in eine .pdf-Datei exportieren", 
          iconCls: 'x-tbar-pdf',
          handler: function() { 
            var p = this.get_current_grid_config();
            Ext.apply(p,this.get_base_params());
            p.fmt = "pdf";
            this.add_param_values(p,true);
            window.open('/api'+this.ls_url + "?" + Ext.urlEncode(p)) 
          } }
        
      ]);
    
    
      var menu = [];
      var set_gc = function(index) {
        return function() {
          //~ console.log('set_gc() 20100812');
          this.getColumnModel().setConfig(
              this.apply_grid_config(index,this.ls_grid_configs,this.ls_columns));
        }
      }
      for (var i = 0; i < this.ls_grid_configs.length;i++) {
        var gc = this.ls_grid_configs[i];
        menu.push({text:gc.label,handler:set_gc(i),scope:this})
      }
      if(menu.length > 1) {
        tbar = tbar.concat([
          { text:"Ansicht",
            menu: menu,
            tooltip:"Andere Ansicht auswählen"
          }
        ]);
      }
      
      if (actions) {
        tbar = tbar.concat(actions.bbar);
          //~ this.bbar = actions.bbar;
      }
      
      this.tbar = new Ext.PagingToolbar({ 
        store: this.store, 
        prependButtons: true, 
        //~ pageSize: this.page_length, 
        pageSize: 1, 
        displayInfo: true, 
        beforePageText: "Seite",
        afterPageText: "von {0}",
        displayMsg: "Zeilen {0} bis {1} von {2}",
        firstText: "Erste Seite",
        lastText: "Letzte Seite",
        prevText: "Vorige Seite",
        nextText: "Nächste Seite",
        items: tbar
      });
      //~ this.on('resize', function(cmp,aw,ah,rw,rh) {
          //~ var ps = this.calculatePageSize();
          //~ if (ps && ps != this.getTopToolbar().pageSize) {
              //~ // console.log('20120203 resize : pageSize',this.getTopToolbar().pageSize,'->',ps);
              //~ // this.getTopToolbar().pageSize =  ps;
              //~ cmp.refresh();
              //~ // this.getTopToolbar().doRefresh();
          //~ }
        //~ }, this);
      //~ this.on('resize', function(cmp,aw,ah,rw,rh) {
          //~ cmp.getTopToolbar().pageSize = this.calculatePageSize(aw,ah,rw,rh) || 10;
          //~ cmp.refresh();
        //~ }, this, {delay:500});
    }
    
    //~ delete this.page_length
    
    
      
    if (this.ls_quick_edit) {
      this.selModel = new Ext.grid.CellSelectionModel()
      this.get_selected = function() {
        //~ console.log(this.getSelectionModel().selection);
        if (this.selModel.selection)
            return [ this.selModel.selection.record ];
        return [this.store.getAt(0)];
      };
      this.get_current_record = function() { 
        if (this.getSelectionModel().selection) 
          return this.selModel.selection.record;
        return this.store.getAt(0);
      };
    } else { 
      this.selModel = new Ext.grid.RowSelectionModel() 
      this.get_selected = function() {
        var sels = this.selModel.getSelections();
        if (sels.length == 0) sels = [this.store.getAt(0)];
        return sels
        //~ var sels = this.getSelectionModel().getSelections();
        //~ return Ext.pluck(sels,'id');
      };
      this.get_current_record = function() { 
        var rec = this.selModel.getSelected();
        if (rec == undefined) rec = this.store.getAt(0);
        return rec
      };
    };
    delete this.ls_quick_edit;
    
    this.columns  = this.apply_grid_config(this.gc_name,this.ls_grid_configs,this.ls_columns);
    
    //~ var grid = this;
    //~ this.colModel = new Ext.grid.ColumnModel({
      //~ columns: this.apply_grid_config(this.gc_name,this.ls_grid_configs,this.ls_columns),
      //~ isCellEditable: function(col, row) {
        //~ var record = grid.store.getAt(row);
        //~ console.log('20120514',col,record); // dataIndex
        //~ var dataIndex = grid.colModel.getDataIndex(col);
        //~ if (dataIndex in record.data['disabled_fields']) {
            //~ Lino.notify("$_("This field is disabled")");
            //~ return false;
        //~ }
        //~ return Ext.grid.ColumnModel.prototype.isCellEditable.call(this, col, row);
      //~ }
    //~ });    
    
    
    Lino.GridPanel.superclass.initComponent.call(this);
    
    //~ if (this.containing_window) 
        //~ this.on('afterlayout', this.refresh, this);
        //~ this.on('afterrender', this.refresh,this);
    //~ else
        //~ this.on('show', this.refresh,this);
    //~ this.on('afterlayout', function() {
      //~ if (this.id == "ext-comp-1157") 
        //~ console.log("20120213 afterlayout",this); 
      //~ // this.refresh();
      //~ },this);
    //~ this.on('afterrender', this.refresh);
    //~ this.on('resize', this.refresh,this,{delay:500});
    //~ this.on('resize', function(){console.log("20120213 resize",arguments)},this);
    this.on('resize', function(){
      //~ console.log("20120213 resize",arguments)
      this.refresh();
      },this);
    this.on('viewready', function(){
      //~ console.log("20120213 resize",arguments);
      this.view_is_ready = true;
      this.refresh();
      },this);
    this.on('afteredit', this.on_afteredit); // 20120814
    //~ this.on('afteredit', this.new_on_afteredit);
    this.on('beforeedit', this.on_beforeedit);
    this.on('beforeedit',function(e) { this.before_row_edit(e.record)},this);
    this.on('cellcontextmenu', Lino.cell_context_menu, this);
    //~ this.on('contextmenu', Lino.grid_context_menu, this);
    
    
    //~ if (this.id == "ext-comp-1157") captureEvents(this);    
    
  },
  
  //~ onResize : function(){
      //~ console.log("20120206 GridPanel.onResize",arguments);
      //~ Lino.GridPanel.superclass.onResize.apply(this, arguments);
      //~ this.refresh();
  //~ },
  
  
  get_status : function(){
    var st = { base_params : this.get_base_params()};
    if (!this.hide_top_toolbar) {
        st.current_page = this.getTopToolbar().current;
    }
    st.param_values = this.status_param_values;
    //~ console.log("20120213 GridPanel.get_status",st);
    return st;
  },
  
  /* 
  Lino.GridPanel.set_status() 
  */
  set_status : function(status){
    //~ console.log("20130605 GridPanel.set_status",status);
    this.clear_base_params();
    if (status == undefined) status = {};
    this.set_param_values(status.param_values);
    if (status.base_params) { 
      this.set_base_params(status.base_params);
    }
    if (status.show_params_panel != undefined) {
        if (this.toggle_params_panel_btn) {
            //~ this.toggle_params_panel_btn.toggle(status.show_params_panel=='true');
            this.toggle_params_panel_btn.toggle(status.show_params_panel);
        }
    }
    if (!this.hide_top_toolbar) {
      //~ console.log("20120213 GridPanel.getTopToolbar().changePage",
          //~ status.current_page || 1);
      this.getTopToolbar().changePage(status.current_page || 1);
    }
    //~ this.fireEvent('resize');
    //~ this.refresh.defer(100,this); 
    //~ this.onResize.defer(100,this); 
    //~ this.refresh(); 
    //~ this.doLayout(); 
    //~ this.onResize(); 
    //~ this.store.load();
  },
  
  refresh : function(unused) { 
    this.refresh_with_after();
  },
  refresh_with_after : function(after) { 
    //~ Lino.notify('20120204 Lino.GridPanel.refresh');
    //~ Lino.notify('Lino.GridPanel.refresh '+this.store.proxy.url);
    //~ var bp = { fmt:'json' }
    if (this.containing_panel) {
        //~ Ext.apply(p,this.master_panel.get_master_params());
        //~ Ext.apply(options.params,this.containing_panel.get_master_params());
        this.set_base_params(this.containing_panel.get_master_params());
    }
    
    if (! this.view_is_ready) return;
    
    var options = {};
    if (after) {
        options.callback = function(r,options,success) {if(success) after()}
    }
      
    //~ if (!this.rendered) {
        //~ console.log("20120206 GridPanel.refresh() must wait until rendered",options);
        //~ this.grid_panel.on('render',this.load.createDelegate(this,options))
        //~ return;
    //~ }
    
    this.store.load(options);
  },
  
  /* pageSize depends on grid height (Trying to remove scrollbar)
  Thanks to 
  - Christophe Badoit on http://www.sencha.com/forum/showthread.php?82647
  - http://www.sencha.com/forum/archive/index.php/t-37231.html
  */
  calculatePageSize : function(second_attempt) {
    //~ if (!this.rendered) { 
    if (!this.view_is_ready) { 
      //~ console.log('Cannot calculatePageSize() : not rendered');
      return false; }
    //~ if (!this.isVisible()) { 
      //~ console.log('calculatePageSize : not visible');
      //~ return false; }
      
    //~ console.log('getFrameHeight() is',this.getFrameHeight());
    //~ console.log('getView().scroller.getHeight() is',this.getView().scroller.getHeight());
    //~ console.log('mainBody.getHeight() is',this.getView().mainBody.getHeight());
    //~ console.log('getInnerHeight() is',this.getInnerHeight());
    //~ console.log('getHeight() is',this.getHeight());
    //~ console.log('el.getHeight() is',this.getEl().getHeight());
    //~ console.log('getGridEl().getHeight() is',this.getGridEl().getHeight());
    //~ console.log('getOuterSize().height is',this.getOuterSize().height);
    //~ console.log('getBox().height is',this.getBox().height);
    //~ console.log('getResizeEl.getHeight() is',this.getResizeEl().getHeight());
    //~ console.log('getLayoutTarget().getHeight() is',this.getLayoutTarget().getHeight());
      
    //~ var rowHeight = 52; // experimental value
    var row = this.view.getRow(0);
    if (row) {
      //~ console.log('20120213 yes');
      var rowHeight = Ext.get(row).getHeight();
    } else {
        //~ var rowHeight = this.getFrameHeight();
        //~ var rowHeight = 10; // reasonably smallest approximative value
        //~ There is no data yet. Construct a fake row and get its height
        var Element = Ext.Element;
        var gv = this.view;
        var fakeBody = new Element(Element.fly(gv.scroller).child('div.x-grid3-body'));
        var rowTemplate = gv.templates.row;
        var cellTemplate = gv.templates.cell;
        var tstyle  = 'width:' + gv.getGridInnerWidth() + 'px;';
        var cells = cellTemplate.apply({value:'&#160;'});
        var markup = rowTemplate.apply({
                tstyle: tstyle,
                cols  : 1,
                cells : cells,
                alt   : ''
            });        
        fakeBody.dom.innerHTML = gv.templates.body.apply({rows: markup});
        var row = fakeBody.dom.childNodes[0];
        var rowHeight = Ext.get(row).getHeight();
    }
    //~ console.log('rowHeight is ',rowHeight,this,caller);
    //~ this.getView().syncScroll();
    //~ this.getView().initTemplates();
    var height = this.getView().scroller.getHeight();
    //~ console.log('getView().scroller.getHeight() is',this.getView().scroller.getHeight());
    //~ console.log('getInnerHeight() - getFrameHeight() is',
      //~ this.getInnerHeight(), '-',
      //~ this.getFrameHeight(), '=',
      //~ this.getInnerHeight() - this.getFrameHeight());
    //~ var height = this.getView().mainBody.getHeight();
    //~ var height = this.getView().mainWrap.getHeight();
    //~ var height = this.getView().resizeMarker.getHeight();
    //~ this.syncSize();
    //~ var height = this.getInnerHeight() - this.getFrameHeight();
    //~ var height = this.getHeight() - this.getFrameHeight();
    height -= Ext.getScrollBarWidth(); // leave room for a possible horizontal scrollbar... 
    //~ height -= this.getView().scrollOffset;
    var ps = Math.floor(height / rowHeight);
    //~ console.log('20130816 calculatePageSize():',height,'/',rowHeight,'->',ps);
    ps -= 1; // leave room for a possible phantom row
    //~ return (ps > 1 ? ps : false);
    if (ps > 1) return ps;
    //~ console.log('calculatePageSize() found less than 1 row:',height,'/',rowHeight,'->',ps);
    //~ foo.bar = baz; // 20120213
    return 5; // preview_limit
    //~ if (second_attempt) {
        //~ console.log('calculatePageSize() abandons after second attempt:',
          //~ height,'/',rowHeight,'->',ps);
      //~ return 5;
    //~ }
    //~ return this.calculatePageSize.defer(500,this,[true]);
  },
  
  onCellDblClick : function(grid, row, col){
      //~ console.log("20120307 onCellDblClick",this,grid, row, col);
      if (this.ls_detail_handler) {
          //~ Lino.notify('show detail');
          Lino.show_detail(this);
          return false;
      }else{
        //~ console.log('startEditing');
        this.startEditing(row,col);
      }
  },
  
  get_base_params : function() {
    //~ return this.containing_window.config.base_params;
    //~ console.log(20120717,this.store.baseParams);
    var p = Ext.apply({},this.store.baseParams);
    Lino.insert_subst_user(p);
    //~ console.log("20120717 GRidPanel.get_base_params() returns",p);
    return p;
    //~ return this.store.baseParams;
  },
  set_base_params : function(p) {
    //~ console.log('GridPanel.set_base_params',p)
    for (k in p) this.store.setBaseParam(k,p[k]);
    //~ this.store.baseParams = p;
    if (p.query) 
        this.quick_search_field.setValue(p.query);
    //~ if (p.param_values) 
        //~ this.set_param_values(p.param_values);  
  },
  clear_base_params : function() {
      this.store.baseParams = {};
      Lino.insert_subst_user(this.store.baseParams);
  },
  set_base_param : function(k,v) {
    this.store.setBaseParam(k,v);
  },
  
  //~ get_permalink_params : function() {
    //~ var p = {};
    //~ return p;
  //~ },
  
  before_row_edit : function(record) {},
    
  //~ search_keypress : function(){
    //~ console.log("2012124 search_keypress",arguments);
  //~ },
  search_validate : function(value) {
    if (value == this.quick_search_text) return true;
    this.is_searching = true;
    //~ console.log('search_validate',value)
    this.quick_search_text = value;
    this.set_base_param('query',value); 
    //~ this.getTopToolbar().changePage(1);
    this.getTopToolbar().moveFirst();
    //~ this.refresh();
    return true;
  },
  
  search_change : function(field,oldValue,newValue) {
    //~ console.log('search_change',field.getValue(),oldValue,newValue)
    this.set_base_param('query',field.getValue()); 
    this.getTopToolbar().moveFirst();
    //~ this.refresh();
  },
  
  apply_grid_config : function(index,grid_configs,rpt_columns) {
    //~ var rpt_columns = this.ls_columns;
    var gc = grid_configs[index];    
    //~ console.log('apply_grid_config() 20100812',name,gc);
    this.gc_name = index;
    if (gc == undefined) {
      return rpt_columns;
      //~ config.columns = config.ls_columns;
      //~ return;
    } 
    //~ delete config.ls_filters
    
    //~ console.log(20100805,config.ls_columns);
    var columns = Array(gc.columns.length);
    for (var j = 0; j < rpt_columns.length;j++) {
      var col = rpt_columns[j];
      for (var i = 0; i < gc.columns.length; i++) {
        if (col.dataIndex == gc.ci[i]) {
          col.width = gc.cw[i];
          col.hidden = gc.ch[i];
          columns[i] = col;
          break;
        }
      }
    }
    
    //~ var columns = Array(rpt_columns.length);
    //~ for (var i = 0; i < rpt_columns.length; i++) {
      //~ columns[i] = rpt_columns[gc.columns[i]];
      //~ columns[i].width = gc.widths[i];
    //~ }
    
    //~ if (gc.hidden_cols) {
      //~ for (var i = 0; i < gc.hidden_cols.length; i++) {
        //~ var hc = gc.hidden_cols[i];
        //~ for (var j = 0; j < columns.length;j++) {
          //~ var col = columns[j];
          //~ if (col.dataIndex == hc) {
            //~ col.hidden = true;
            //~ break
          //~ }
        //~ }
      //~ }
    //~ }
    if (gc.filters) {
      //~ console.log(20100811,'config.ls_filters',config.ls_filters);
      //~ console.log(20100811,'config.ls_grid_config.filters',config.ls_grid_config.filters);
      for (var i = 0; i < gc.filters.length; i++) {
        var fv = gc.filters[i];
        for (var j = 0; j < columns.length;j++) {
          var col = columns[j];
          if (col.dataIndex == fv.field) {
            //~ console.log(20100811, f,' == ',fv);
            if (fv.type == 'string') {
              col.filter.value = fv.value;
              //~ if (fv.comparison !== undefined) f.comparison = fv.comparison;
            } else {
              //~ console.log(20100811, fv);
              col.filter.value = {};
              col.filter.value[fv.comparison] = fv.value;
            }
            break;
          }
        };
      }
    }
    
    return columns;
    //~ config.columns = cols;
    //~ delete config.ls_columns
  },
  
  get_current_grid_config : function () {
    var cm = this.getColumnModel();
    var widths = Array(cm.config.length);
    var hiddens = Array(cm.config.length);
    //~ var hiddens = Array(cm.config.length);
    var columns = Array(cm.config.length);
    //~ var columns = Array(cm.config.length);
    //~ var hidden_cols = [];
    //~ var filters = this.filters.getFilterValues();
    var p = this.filters.buildQuery(this.filters.getFilterData())
    for (var i = 0; i < cm.config.length; i++) {
      var col = cm.config[i];
      columns[i] = col.dataIndex;
      //~ hiddens[i] = col.hidden;
      widths[i] = col.width;
      hiddens[i] = col.hidden;
      //~ if (col.hidden) hidden_cols.push(col.dataIndex);
    }
    //~ p['hidden_cols'] = hidden_cols;
    p.cw = widths;
    p.ch = hiddens;
    p.ci = columns;
    //~ p['widths'] = widths;
    //~ p['hiddens'] = hiddens;
    //~ p['columns'] = columns;
    p['name'] = this.gc_name;
    //~ var gc = this.ls_grid_configs[this.gc_name];
    //~ if (gc !== undefined) 
        //~ p['label'] = gc.label
    //~ console.log('20100810 save_grid_config',p);
    return p;
  },
  
  unused_manage_grid_configs : function() {
    var data = [];
    for (k in this.ls_grid_configs) {
      var v = this.ls_grid_configs[k];
      var i = [k,String(v.columns),String(v.hidden_cols),String(v.filters)];
      data.push(i)
    }
    if (this.ls_grid_configs[this.gc_name] == undefined) {
      var v = this.get_current_grid_config();
      var i = [k,String(v.columns),String(v.hidden_cols),String(v.filters)];
      data.push(i);
    }
    //~ console.log(20100811, data);
    var main = new Ext.grid.GridPanel({
      store: new Ext.data.ArrayStore({
        idIndex:0,
        fields:['name','columns','hidden_cols','filters'],
        autoDestroy:true,
        data: data}),
      //~ autoHeight:true,
      selModel: new Ext.grid.RowSelectionModel(),
      listeners: { 
        rowdblclick: function(grid,rowIndex,e) {
          console.log('row doubleclicked',grid, rowIndex,e);
        },
        rowclick: function(grid,rowIndex,e) {
          console.log('row clicked',grid, rowIndex,e);
        }
      },
      columns: [ 
        {dataIndex:'name',header:'Name'}, 
        {dataIndex:'columns',header:'columns'}, 
        {dataIndex:'hidden_cols',header:'hidden columns'}, 
        {dataIndex:'filters',header:'filters'} 
      ]
    });
    var win = new Ext.Window({title:'GridConfigs Manager',layout:'fit',items:main,height:200});
    win.show();
  },
  
  unused_edit_grid_config : function(name) {
    gc = this.ls_grid_configs[name];
    var win = new Ext.Window({
      title:'Edit Grid Config',layout:'vbox', 
      //~ layoutConfig:'stretch'
      items:[
        {xtype:'text', value: gc.name},
        {xtype:'text', value: gc.columns},
        {xtype:'text', value: gc.hidden_cols},
        {xtype:'text', value: gc.filters}
      ]
    });
    win.show();
  },
  
  save_grid_config : function () {
    //~ console.log('TODO: save_grid_config',this);
    //~ p.column_widths = Ext.pluck(this.colModel.columns,'width');
    var a = { 
      params:this.get_current_grid_config(), 
      method:'PUT',
      url:'/grid_config' + this.ls_url,
      success: Lino.action_handler(this),
      scope: this,
      failure: Lino.ajax_error_handler(this)
    };
    this.loadMask.show(); // 20120211
    Ext.Ajax.request(a);
    //~ Lino.do_action(this,a);
  },
  
  on_beforeedit : function(e) {
    //~ console.log('20130128 GridPanel.on_beforeedit()',e,e.record.data.disable_editing);
    if(this.disable_editing | e.record.data.disable_editing) {
      e.cancel = true;
      Lino.notify("Dieser Datensatz ist deaktiviert");
      return;
    }
    if(e.record.data.disabled_fields && e.record.data.disabled_fields[e.field]) {
      e.cancel = true;
      Lino.notify("Dieses Feld ist deaktiviert");
      return;
    }
    //~ if (e.record.data.disabled_fields) {
      //~ for (i in e.record.data.disabled_fields) {
        //~ if(e.record.data.disabled_fields[i] == e.field) {
          //~ e.cancel = true;
          //~ Lino.notify(String.format('Field "{0}" is disabled for this record',e.field));
          //~ return
        //~ }
      //~ }
    //~ }
  },
  save_grid_data : function() {
      //~ console.log("20120814 save_grid_data");
      this.getStore().commitChanges();
  },
  new_on_afteredit : function(e) {
      //~ this.getStore().commitChanges();
      //~ this.getStore().doUpdate();
      //~ this.getStore().loadData(data);
      console.log("20120814 new_on_afteredit",e);
  },
  on_afteredit : function(e) {
    /*
    e.grid - The grid that fired the event
    e.record - The record being edited
    e.field - The field name being edited
    e.value - The value being set
    e.originalValue - The original value for the field, before the edit.
    e.row - The grid row index
    e.column - The grid column index
    */
    var p = {};
    //~ console.log('20101130 modified: ',e.record.modified);
    //~ console.log('20101130 value: ',e.value);
    //~ var p = e.record.getChanges();
    //~ console.log('20101130 getChanges: ',e.record.getChanges());
    //~ this.before_row_edit(e.record);
    for(k in e.record.getChanges()) {
        var v = e.record.get(k);
    //~ for(k in e.record.modified) {
        //~ console.log('20101130',k,'=',v);
        //~ var cm = e.grid.getColumnModel();
        //~ var di = cm.getDataIndex(k);
        var f = e.record.fields.get(k);
        //~ console.log('20101130 f = ',f);
        //~ var v = e.record.get(di);
        if (f.type.type == 'date') {
            p[k] = Ext.util.Format.date(v, f.dateFormat);
        }else{
            p[k] = v;
            var v = e.record.get(k+'Hidden');
            if (v !== undefined) {
              p[k+'Hidden'] = v;
            }
        }
        //~ var i = cm.findColumnIndex(k);
        //~ var r = cm.getRenderer(i);
        //~ var editor = cm.getCellEditor(i,e.row);
        //~ var col = e.grid.getColumnModel().getColumnById(k);
        //~ console.log('20101130 r = ',r(v));
        //~ var f = e.record.fields[k];
        //~ console.log('20101130 f = ',f);
        //~ console.log('20101130 editor = ',editor);
        //~ p[k] = f.getValue();
        //~ p[k] = r(v);
    }
    //~ console.log('20101130 p:',p);
    //~ var cm = e.grid.getColumnModel();
    //~ var di = cm.getDataIndex(e.column);
    //~ var f = e.record.fields.get(di);
    //~ console.log('20101130 f = ',f);
    //~ if (f.type.type == 'date') e.record.set(di,Ext.util.Format.date(e.value, f.dateFormat));
    
    
    //~ var p = e.record.data;
    
    // var p = {};
    //~ p['grid_afteredit_colname'] = e.field;
    //~ p[e.field] = e.value;
    //~ console.log('20100723 GridPanel.on_afteredit()',e);
    // add value used by ForeignKeyStoreField CHOICES_HIDDEN_SUFFIX
    // not sure whether this is still needed:
    p[e.field+'Hidden'] = e.value;
    //~ p.su = Lino.subst_user;
    Lino.insert_subst_user(p);
    // this one is needed so that this field can serve as choice context:
    e.record.data[e.field+'Hidden'] = e.value;
    // p[pk] = e.record.data[pk];
    // console.log("grid_afteredit:",e.field,'=',e.value);
    Ext.apply(p,this.get_base_params()); // needed for POST, ignored for PUT
    //~ Ext.apply(p,this.containing_window.config.base_params);
    //~ 20121109 p['$ext_requests.URL_PARAM_ACTION_NAME'] = 'grid';
    var self = this;
    var req = {
        params:p,
        waitMsg: 'Saving your data...',
        success: Lino.action_handler( this, function(result) {
          //~ if (result.data_record) {
          if (result.refresh_all) {
              var cw = self.get_containing_window();
              if (cw) {
                  cw.main_item.refresh();
              }
              else console.log("20120123 cannot refresh_all",self);
          } else if (result.rows) {
              //~ self.getStore().loadData(result,true);
              var r = self.getStore().reader.readRecords(result);
              if (e.record.phantom) {
                  //~ console.log("20120816 afteredit.success POST",r);
                  self.getStore().insert(e.row,r.records);
              }else{
                  //~ console.log("20120816 afteredit.success PUT",r);
                  self.getStore().doUpdate(r.records[0]);
              }
              self.getStore().rejectChanges(); /* 
              get rid of the red triangles without saving the record again
              */
              //~ self.getStore().commitChanges(); // get rid of the red triangles
          } else {
              self.getStore().commitChanges(); // get rid of the red triangles
              self.getStore().reload();        // reload our datastore.
          }
          }),
        scope: this,
        failure: Lino.ajax_error_handler(this)
    };
    if (e.record.phantom) {
      req.params.an = 'post'; // SubmitInsert.action_name
      Ext.apply(req,{
        method: 'POST',
        url: '/api' + this.ls_url
      });
    } else {
      req.params.an = 'put'; // SubmitDetail.action_name
      Ext.apply(req,{
        method: 'PUT',
        url: '/api' + this.ls_url + '/' + e.record.id
      });
    }
    //~ console.log('20110406 on_afteredit',req);
    this.loadMask.show(); // 20120211
    Ext.Ajax.request(req);
  },

  afterRender : function() {
    Lino.GridPanel.superclass.afterRender.call(this);
    // this.getView().mainBody.focus();
    // console.log(20100114,this.getView().getRows());
    // if (this.getView().getRows().length > 0) {
    //  this.getView().focusRow(1);
    // }
    //~ this.my_load_mask = new Ext.LoadMask(this.getEl(), {
        //~ msg:'$_("Please wait...")',
        //~ store:this.store});
      
    var tbar = this.getTopToolbar();
    // tbar.on('change',function() {this.getView().focusRow(1);},this);
    // tbar.on('change',function() {this.getSelectionModel().selectFirstRow();this.getView().mainBody.focus();},this);
    // tbar.on('change',function() {this.getView().mainBody.focus();},this);
    // tbar.on('change',function() {this.getView().focusRow(1);},this);
    this.nav = new Ext.KeyNav(this.getEl(),{
      pageUp: function() {tbar.movePrevious(); },
      pageDown: function() {tbar.moveNext(); },
      home: function() {tbar.moveFirst(); },
      end: function() {tbar.moveLast(); },
      scope: this
    });
  },
  after_delete : function() {
    //~ console.log('Lino.GridPanel.after_delete');
    this.refresh();
  },
  add_row_listener : function(fn,scope) {
    this.getSelectionModel().addListener('rowselect',fn,scope);
  },
  postEditValue : function(value, originalValue, r, field){
    value = Lino.GridPanel.superclass.postEditValue.call(this,value,originalValue,r,field);
    //~ console.log('GridPanel.postEdit()',value, originalValue, r, field);
    return value;
  },
  
  set_start_value : function(v) {
      this.start_value = v;
  },
  preEditValue : function(r, field){
      if (this.start_value) {
        var v = this.start_value;
        delete this.start_value;
        this.activeEditor.selectOnFocus = false;
        return v;
      }
      var value = r.data[field];
      return this.autoEncode && Ext.isString(value) ? Ext.util.Format.htmlDecode(value) : value;
  },
  
  on_master_changed : function() {
    //~ if (! this.enabled) return;
    //~ cmp = this;
    //~ console.log('Lino.GridPanel.on_master_changed()',this.title);
    if (! this.rendered) return; // 20120213
    var todo = function() {
      if (this.disabled) return;
      //~ if (this.disabled) return;
      //~ if (this.enabled) {
          //~ var src = caller.config.url_data + "/" + record.id + ".jpg"
          //~ console.log(20111125, this.containing_window);
          //~ for (k in p) this.getStore().setBaseParam(k,p[k]);
          //~ console.log('Lino.GridPanel.on_master_changed()',this.title,p);
          this.refresh();
          //~ this.set_base_params(this.master_panel.get_master_params());
          //~ this.getStore().load(); 
      //~ }
    };
    Lino.do_when_visible(this,todo.createDelegate(this));
  },
  load_record_id : function(record_id,after) {
      Lino.run_detail_handler(this,record_id)
  }
  
});
  

//~ Lino.MainPanelMixin = {
  //~ tbar_items : function() {
      //~ return ;
  //~ }
//~ };

//~ Ext.override(Lino.GridPanel,Lino.MainPanelMixin);
//~ Ext.override(Lino.FormPanel,Lino.MainPanelMixin);

//~ Lino.grid_context_menu = function(e) {
  //~ console.log('contextmenu',arguments);
//~ }

Lino.cell_context_menu = function(grid,row,col,e) {
  //~ console.log('20120531 cellcontextmenu',grid,row,col,e,grid.store.reader.arrayData.rows[row]);
  e.stopEvent();
  //~ grid.getView().focusCell(row,col);
  grid.getSelectionModel().select(row,col);
  //~ console.log(grid.store.getAt(row));
  //~ grid.getView().focusRow(row);
  //~ return;
  if(!grid.cmenu.el){grid.cmenu.render(); }
  //~ if(e.record.data.disabled_fields) {
  
  var da = grid.store.reader.arrayData.rows[row][grid.disabled_actions_index];
  if (da) {
      this.cmenu.cascade(function(item){ 
        //~ console.log(20120531, item.itemId, da[item.itemId]);
        if (da[item.itemId]) item.disable(); else item.enable();
      });
  };
  
  var xy = e.getXY();
  xy[1] -= grid.cmenu.el.getHeight();
  grid.cmenu.showAt(xy);
}


//~ Lino.load_main_menu = function() {
  //~ Ext.Ajax.request({
    //~ waitMsg: 'Loading main menu...',
    //~ method: 'GET',
    //~ url: '/menu',
    //~ success: Lino.on_load_menu,
    //~ failure: Lino.ajax_error_handler
  //~ });
//~ };



//~ Lino.SlavePlugin = function(caller) {
  //~ this.caller = caller;
//~ };

Lino.chooser_handler = function(combo,name) {
  return function(cmp,newValue,oldValue) {
    //~ console.log('Lino.chooser_handler()',cmp,oldValue,newValue);
    combo.setContextValue(name,newValue);
  }
};



Lino.ComboBox = Ext.extend(Ext.form.ComboBox,{
  forceSelection: true,
  triggerAction: 'all',
  minListWidth:230,
  autoSelect: false,
  selectOnFocus: true, // select any existing text in the field immediately on focus.
  submitValue: true,
  displayField: 'text', // 'text', 
  valueField: 'value', // 'value',
  
  //~ initComponent : Ext.form.ComboBox.prototype.initComponent.createSequence(function() {
  initComponent : function(){
      this.contextParams = {};
      //~ Ext.form.ComboBox.initComponent(this);
      Lino.ComboBox.superclass.initComponent.call(this);
  },
  setValue : function(v,record_data){
      /*
      Based on feature request developed in http://extjs.net/forum/showthread.php?t=75751
      */
      /* `record_data` is used to get the text corresponding to this value */
      //~ if(this.name == 'city') 
      //~ console.log('20120203', this.name,'.setValue(', v ,') this=', this,'record_data=',record_data);
      var text = v;
      if(this.valueField){
        if(v == null || v == '') { 
            //~ if (this.name == 'birth_country') 
                //~ console.log(this.name,'.setValue',v,'no lookup needed, value is empty');
            //~ v = undefined;
            v = '';
            //~ text = '';
        } else if (Ext.isDefined(record_data)) {
          text = record_data[this.name];
          //~ if (this.name == 'birth_country') 
            //~ console.log(this.name,'.setValue',v,'got text ',text,' from record ',record);
        } else {
          // if(this.mode == 'remote' && !Ext.isDefined(this.store.totalLength)){
          if(this.mode == 'remote' && ( this.lastQuery === null || (!Ext.isDefined(this.store.totalLength)))){
              //~ if (this.name == 'birth_country') console.log(this.name,'.setValue',v,'store not yet loaded');
              this.store.on('load', this.setValue.createDelegate(this, arguments), null, {single: true});
              if(this.store.lastOptions === null || this.lastQuery === null){
                  var params;
                  if(this.valueParam){
                      params = {};
                      params[this.valueParam] = v;
                  }else{
                      var q = this.allQuery;
                      this.lastQuery = q;
                      this.store.setBaseParam(this.queryParam, q);
                      params = this.getParams(q);
                  }
                  //~ if (this.name == 'birth_country') 
                    //~ console.log(this.name,'.setValue',v,' : call load() with params ',params);
                  this.store.load({params: params});
              //~ }else{
                  //~ if (this.name == 'birth_country') 
                    //~ console.log(this.name,'.setValue',v,' : but store is loading',this.store.lastOptions);
              }
              return;
          //~ }else{
              //~ if (this.name == 'birth_country') 
                //~ console.log(this.name,'.setValue',v,' : store is loaded, lastQuery is "',this.lastQuery,'"');
          }
          var r = this.findRecord(this.valueField, v);
          if(r){
              text = r.data[this.displayField];
          }else if(this.valueNotFoundText !== undefined){
              text = this.valueNotFoundText;
          }
        }
      }
      this.lastSelectionText = text;
      //~ this.lastSelectionText = v;
      if(this.hiddenField){
          //~ this.hiddenField.originalValue = v;
          this.hiddenField.value = v;
      }
      Ext.form.ComboBox.superclass.setValue.call(this, text);
      this.value = v; // needed for grid.afteredit
  },
  
  getParams : function(q){
    // p = Ext.form.ComboBox.superclass.getParams.call(this, q);
    // causes "Ext.form.ComboBox.superclass.getParams is undefined"
    var p = {};
    //p[this.queryParam] = q;
    if(this.pageSize){
        //~ p.start = 0;
        //~ p.limit = this.pageSize;
        p['start'] = 0;
        p['limit'] = this.pageSize;
    }
    // now my code:
    if(this.contextParams) Ext.apply(p,this.contextParams);
    //~ if(this.contextParams && this.contextValues) {
      //~ for(i = 0; i <= this.contextParams.length; i++)
        //~ p[this.contextParams[i]] = this.contextValues[i];
    //~ }
    return p;
  },
  setContextValue : function(name,value) {
    //~ console.log('setContextValue',this,this.name,':',name,'=',value);
    //~ if (this.contextValues === undefined) {
        //~ this.contextValues = Array(); // this.contextParams.length);
    //~ }
    if (this.contextParams[name] != value) {
      //~ console.log('setContextValue 1',this.contextParams);
      this.contextParams[name] = value;
      this.lastQuery = null;
      //~ console.log('setContextValue 2',this.contextParams);
    }
  }
});

Lino.ChoicesFieldElement = Ext.extend(Lino.ComboBox,{
  mode: 'local'
});


Lino.SimpleRemoteComboStore = Ext.extend(Ext.data.JsonStore,{
  forceSelection: true,
  constructor: function(config){
      Lino.SimpleRemoteComboStore.superclass.constructor.call(this, Ext.apply(config, {
          totalProperty: 'count',
          root: 'rows',
          id: 'value', // ext_requests.CHOICES_VALUE_FIELD
          fields: ['value' ], // ext_requests.CHOICES_VALUE_FIELD, // ext_requests.CHOICES_TEXT_FIELD
          listeners: { exception: Lino.on_store_exception }
      }));
  }
});

Lino.ComplexRemoteComboStore = Ext.extend(Ext.data.JsonStore,{
  constructor: function(config){
      Lino.ComplexRemoteComboStore.superclass.constructor.call(this, Ext.apply(config, {
          totalProperty: 'count',
          root: 'rows',
          id: 'value', // ext_requests.CHOICES_VALUE_FIELD
          fields: ['value','text'], // ext_requests.CHOICES_VALUE_FIELD, // ext_requests.CHOICES_TEXT_FIELD
          listeners: { exception: Lino.on_store_exception }
      }));
  }
});

Lino.RemoteComboFieldElement = Ext.extend(Lino.ComboBox,{
  mode: 'remote',
  //~ forceSelection:false,
  minChars: 2, // default 4 is too much
  queryDelay: 300, // default 500 is maybe slow
  queryParam: 'query', 
  //~ typeAhead: true,
  //~ selectOnFocus: true, // select any existing text in the field immediately on focus.
  resizable: true
});

/*
Thanks to Animal for posting the basic idea:
http://www.sencha.com/forum/showthread.php?15842-2.0-SOLVED-Combobox-twintrigger-clear&p=76130&viewfull=1#post76130

*/
Lino.TwinCombo = Ext.extend(Lino.RemoteComboFieldElement,{
    trigger2Class : 'x-form-search-trigger',
    //~ trigger2Class : 'x-tbar-detail',
    initComponent : function() {
        //~ Lino.TwinCombo.superclass.initComponent.call(this);
        Lino.ComboBox.prototype.initComponent.call(this);
        Ext.form.TwinTriggerField.prototype.initComponent.call(this);
    },
    onTrigger2Click : function() {
        //~ console.log('onTrigger2Click',this,arguments);
    }
  });
//~ Lino.TwinCombo.prototype.initComponent = Ext.form.TwinTriggerField.prototype.initComponent;
Lino.TwinCombo.prototype.getTrigger = Ext.form.TwinTriggerField.prototype.getTrigger;
Lino.TwinCombo.prototype.getOuterSize = Ext.form.TwinTriggerField.prototype.getOuterSize;
Lino.TwinCombo.prototype.initTrigger = Ext.form.TwinTriggerField.prototype.initTrigger;
Lino.TwinCombo.prototype.onTrigger1Click = Ext.form.ComboBox.prototype.onTriggerClick;
//~ Lino.TwinCombo.prototype.onTrigger2Click = function() {
    //~ console.log('onTrigger2Click',arguments);
//~ };



Lino.SimpleRemoteComboFieldElement = Ext.extend(Lino.RemoteComboFieldElement,{
  displayField: 'value', 
  valueField: null,
  forceSelection: false
});




Lino.Window = Ext.extend(Ext.Window,{
  //~ layout: "fit", 
  closeAction : 'hide',
  renderTo: 'main_area', 
  constrain: true,
  maximized: true,
  draggable: false,
  width: 700,
  height: 500,
  maximizable: false,
  constructor : function (config) {
    if (config.main_item.params_panel) {
        config.layout = 'border';
        config.main_item.region = 'center';
        config.main_item.params_panel.region = 'north';
        config.main_item.params_panel.hidden = config.main_item.params_panel_hidden;
        config.items = [config.main_item.params_panel, config.main_item];
    } else {
        config.layout = 'fit';
        config.items = config.main_item;
    }
    this.main_item = config.main_item; 
    
    delete config.main_item;
    //~ delete config.params_item;
    
    //~ this.main_item = config.items.get(0);
    this.main_item.containing_window = this;
    
    //~ console.log('20120110 Lino.Window.constructor() 1');
    //~ if (Lino.current_window) { // all windows except the top are closable
    if (this.main_item.hide_window_title) { 
      config.closable = false;
      config.frame = false;
      config.shadow = false;
      //~ config.border = true;
      //~ config.title = undefined;
      //~ config.tools = null;
      delete config.title;
      delete config.tools;
    } else {
      config.title = this.main_item.empty_title;
      config.closable = true;
      config.tools = [ 
        { qtip: 'permalink', handler: Lino.permalink_handler(this), id: "pin" }
      ];
      if (this.main_item.content_type && this.main_item.action_name != 'insert') {
        config.tools = [ {
          handler: Lino.help_text_editor,
          qtip: "Hilfetexte der Eingabefelder dieser Tabelle bearbeiten",
          scope: this.main_item,
          id: "gear"
        }].concat(config.tools);
      }
        
    //~ { qtip: '', handler: Lino.save_wc_handler(this), id: "save" }, 
    //~ { qtip: this.config.qtip, handler: Lino.save_wc_handler(this), id: "save" }, 
    //~ { qtip: 'Call doLayout() on main Container.', handler: Lino.refresh_handler(this), id: "refresh" },
    //~ if (this.main_item.params_panel) {
        //~ config.tools = config.tools.concat([ 
          //~ { qtip: 'Show/hide parameter panel', handler: this.toggle_params_panel, id: "gear", scope:this } 
        //~ ]);
    //~ }
    //~ if (config.closable !== false) {
      // if undefined, will take default behaviour
      //~ config.tools = config.tools.concat([ 
        //~ { qtip: 'close', handler: this.hide, id: "close", scope:this } 
      //~ ]);
    }
    
    this.main_item.config_containing_window(config);
    
    //~ console.log('20120110 Lino.Window.constructor() 2');
    Lino.Window.superclass.constructor.call(this,config);
    
    //~ console.log('20120110 Lino.Window.constructor() 3');
    
  },
  initComponent : function() {
    this.main_item.init_containing_window(this);
    Lino.Window.superclass.initComponent.call(this);
  
  },
  hide : function() { 
      this.main_item.do_when_clean(false,function() { 
        Lino.close_window(); });
  },
  hide_really : function() { 
    Lino.Window.superclass.hide.call(this);
  },
  onRender : function(ct, position){
    //~ console.log('20120110 Lino.Window.onRender() 1');
    Lino.Window.superclass.onRender.call(this, ct, position);
    var main_area = Ext.getCmp('main_area')
    //~ console.log('20120110 Lino.Window.onRender() 2');
  
    this.on('show', function(win) {
        //~ console.log('20120110 Lino.Window.on show 1');
        main_area.on('resize', win.onWindowResize, win);
    });
    this.on('hide', function(win) {
        main_area.un('resize', win.onWindowResize, win);
    });
    //~ console.log('20120110 Lino.Window.onRender() 3');
  }
});


Lino.unused_ParamWindow = Ext.extend(Lino.Window,{
  //~ layout: "border", 
  constructor : function (config) {
    Lino.ParamWindow.superclass.constructor.call(this,config);
    this.main_item = config.items; // `items` must be a single component
    config.layout = 'border';
    this.main_item.region = 'center';
    config.params.region = 'north';
    config.items = [config.params, config.items];
    //~ delete config.params;
  }
});




(function(){
    var ns = Ext.ns('Ext.ux.plugins');

    /**
     * @class Ext.ux.plugins.DefaultButton
     * @extends Object
     *
     * Plugin for Button that will click() the button if the user presses ENTER while
     * a component in the button's form has focus.
     *
     * @author Stephen Friedrich
     * @date 09-DEC-2009
     * @version 0.1
     *
     */
    ns.DefaultButton =  Ext.extend(Object, {
        init: function(button) {
            button.on('afterRender', setupKeyListener, button);
        }
    });

    function setupKeyListener() {
        var formPanel = this.findParentByType('form');
        new Ext.KeyMap(formPanel.el, {
            key: Ext.EventObject.ENTER,
            shift: false,
            alt: false,
            fn: function(keyCode, e){
                if(e.target.type === 'textarea' && !e.ctrlKey) {
                    return true;
                }

                this.el.select('button').item(0).dom.click();
                return false;
            },
            scope: this
        });
    }

    Ext.ComponentMgr.registerPlugin('defaultButton', ns.DefaultButton);

})(); 

Ext.override(Ext.form.BasicForm,{
    my_loadRecord : function(values){
    //~ loadRecord : function(record){
        /* Same as ExtJS's loadRecord() (setValues()), except that we 
        forward also the record to field.setValue() so that Lino.Combobox 
        can use it. 
        */
        //~ console.log('20120918 my_loadRecord',values)
        if(Ext.isArray(values)){ 
            for(var i = 0, len = values.length; i < len; i++){
                var v = values[i];
                var f = this.findField(v.id);
                if(f){
                    f.setValue(v.value,values);
                    if(this.trackResetOnLoad){
                        f.originalValue = f.getValue();
                    }
                }
            }
        }else{ 
            var field, id;
            for(id in values){
                if(!Ext.isFunction(values[id]) && (field = this.findField(id))){
                    field.setValue(values[id],values);
                    if(this.trackResetOnLoad){
                        field.originalValue = field.getValue();
                        //~ if (field.hiddenField) {
                          //~ field.hiddenField.originalValue = field.hiddenField.value;
                        //~ }
                    }
                }
            }
        }
        return this;
    }
});




function initializeFooBarDropZone(cmp) {
    //~ console.log('initializeFooBarDropZone',cmp);
    cmp.dropTarget = new Ext.dd.DropTarget(cmp.bwrap, {
      //~ ddGroup     : 'gridDDGroup',
      notifyEnter : function(ddSource, e, data) {
        console.log('notifyEnter',ddSource,e,data);
        //Add some flare to invite drop.
        cmp.body.stopFx();
        cmp.body.highlight();
      },
      notifyDrop  : function(ddSource, e, data){
        console.log('notifyDrop',ddSource,e,data);
        // Reference the record (single selection) for readability
        //~ var selectedRecord = ddSource.dragData.selections[0];


        // Load the record into the form
        //~ formPanel.getForm().my_loadRecord(selectedRecord);


        // Delete record from the grid.  not really required.
        //~ ddSource.grid.store.remove(selectedRecord);

        return(true);
      }
    })
}



Lino.show_mti_child = function(fieldname,detail_handler) {
  //~ console.log('show_mti_child',this);
  //~ console.log('show_mti_child',panel.find("main_area"));
  rec = Lino.current_window.main_item.get_current_record();
  //~ rec = panel.get_current_record();
  if (rec) {
    //~ console.log('show_mti_child',Lino.current_window,rec);
    if (rec.phantom) {
      Lino.notify('Not allowed on phantom record.');
    }else if (rec.data[fieldname]) {
      //~ console.log('show_mti_child',rec.id);
      //~ detail_handler(Lino.current_window.main_item,{},{record_id:rec.id});
      detail_handler.run(null,{record_id:rec.id});
      //~ window.open(urlroot + '/' + rec.id);
      //~ document.location = urlroot + '/' + rec.id;
      //~ window.open(urlroot + '/' + rec.id,'_blank');
    } else {
      Lino.alert("Kann MTI-Kind nicht anzeigen wenn Checkbox abgeschlatet ist.");
    }
  } else {
    Lino.notify('No current record.');
  }
};



Lino.davlink_open = function(webdavURL) {
  /* Calls lino.applets.davlink.DavLink.open()
  */
  //~ console.log('Going to call document.applets.DavLink.open(',webdavURL,')');
  var rv = document.applets.DavLink.open(webdavURL);
  if (rv) window.alert(rv);
}






/*
Mappings towards lino.modlib.cal.models.PanelCalendars
*/
// Sset SS = Ssite.modules.cal.PanelCalendars.get_handle(Sui).store
Ext.ensible.cal.CalendarMappings = {
    CalendarId:   {name:'ID',       mapping: 'id', type: 'int'},
    Title:        {name:'CalTitle', mapping: 'babel_name', type: 'string'},
    Description:  {name:'Desc',     mapping: 'description', type: 'string'},
    ColorId:      {name:'Color',    mapping: 'color', type: 'int'},
    IsHidden:     {name:'Hidden',   mapping: 'is_hidden', type: 'boolean'},    
};
Ext.ensible.cal.CalendarRecord.reconfigure();  


/*
Mappings towards lino.modlib.cal.models.PanelEvents 
*/
// Sset SS = Ssite.modules.cal.PanelEvents.get_handle(Sui).store
Ext.ensible.cal.EventMappings = {
    EventId:     {name: 'ID',        mapping: 'id', type:'int'},
    CalendarId:  {name: 'CalID',     mapping: 'calendarHidden', type: 'int'},
    Title:       {name: 'EvtTitle',  mapping: 'summary'},
    StartDate:   {name: 'StartDt',   mapping: 'start_dt', 
      type: 'date', 
      dateFormat: "Y-m-d\TH:i:s" },
    EndDate:     {name: 'EndDt',     mapping: 'end_dt', 
      type: 'date', 
      dateFormat: "Y-m-d\TH:i:s"},
    RRule:       {name: 'RecurRule', mapping: 'rsetHidden'},
    Location:    {name: 'Location',  mapping: 'placeHidden'},
    Notes:       {name: 'Desc',      mapping: 'description'},
    Url:         {name: 'LinkUrl',   mapping: 'url'},
    IsAllDay:    {name: 'AllDay',    mapping: 'all_day', type: 'boolean'},
    Reminder:    {name: 'Reminder',  mapping: 'reminder'}
    
};
Ext.ensible.cal.EventRecord.reconfigure();


//~ Lino.on_eventclick = 
    
Lino.on_editdetails = 

Lino.format_time = function(dt) {
    return dt.getHours() + ':' + dt.getMinutes();
}
    
Lino.on_eventdelete = function() {
  //~ console.log("Lino.on_eventdelete",arguments);
};

Lino.on_eventadd  = function(cp,rec,el) {
  //~ console.log("Lino.on_eventadd ",arguments);
  return false;
}
    
Lino.on_eventresize  = function(cp,rec,el) {
  //~ console.log("Lino.on_eventresize ",arguments);
  //~ Lino.cal.Events.insert(cp);
  //~ return false;
}
    
Lino.on_eventupdate  = function(cp,rec,el) {
  //~ console.log("Lino.on_eventupdate",arguments);
  //~ Lino.cal.Events.insert(cp);
  //~ return false;
}
    

//~ Lino.eventStore = new Ext.ensible.cal.EventStore({ 
//~ Lino.eventStore = new Ext.data.ArrayStore({ 
Lino.unused_eventStore = new Ext.data.JsonStore({ 
  listeners: { exception: Lino.on_store_exception }
  ,url: '/restful/cal/PanelEvents'
  ,restful : true
  ,proxy: new Ext.data.HttpProxy({ 
      url: '/restful/cal/PanelEvents', 
      disableCaching: false // no need for cache busting when loading via Ajax
      //~ disableCaching:true,
  })
  ,fields: Ext.ensible.cal.EventRecord.prototype.fields.getRange()
  ,totalProperty: "count"
  ,root: "rows"
  ,idProperty: Ext.ensible.cal.EventMappings.EventId.mapping
  ,writer : new Ext.data.JsonWriter({
    writeAllFields: false
  })
  ,load: function(options) {
    //~ foo.bar = baz; // 20120213
      if (!options) options = {};
      if (!options.params) options.params = {};
      //~ options.params.$ext_requests.URL_PARAM_TEAM_VIEW = Lino.calendar_app.team_view_button.pressed;
      
      var view = this.cal_panel.getActiveView();
      var bounds = view.getViewBounds();
      //~ var p = {sd:'05.02.2012',ed:'11.02.2012'};
      //~ var p = {};
      options.params[view.dateParamStart] = bounds.start.format(view.dateParamFormat);
      options.params[view.dateParamEnd] = bounds.end.format(view.dateParamFormat);
      Lino.insert_subst_user(options.params);
      //~ Ext.apply(options.params,p)
      //~ console.log('20120710 eventStore.load()',this.baseParams,options);
    
    return Ext.data.JsonStore.prototype.load.call(this,options);
  }
});

//~ Lino.eventStore.on('load', function() {
//~ });


    //~ Lino.subst_user = id;


//~ Lino.calendarStore = new Ext.data.ArrayStore({ 
Lino.unused_calendarStore = new Ext.data.JsonStore({ 
      listeners: { exception: Lino.on_store_exception }
      ,restful : true
      ,proxy: new Ext.data.HttpProxy({ 
          url: '/restful/cal/PanelCalendars?fmt=json', 
          disableCaching: false // no need for cache busting when loading via Ajax
          //~ restful : true
          //~ method: "GET"
      })
      //~ ,autoLoad: true
      //~ ,remoteSort: true
      //~ ,baseParams: bp
      ,totalProperty: "count"
      ,root: "rows"
      ,fields: Ext.ensible.cal.CalendarRecord.prototype.fields.getRange()
      ,idProperty: Ext.ensible.cal.CalendarMappings.CalendarId.mapping
      //~ ,idIndex: Ext.ensible.cal.CalendarMappings.CalendarId.mapping
    });


Lino.CalendarCfg = {
    dateParamFormat: 'd.m.Y',
    dateParamStart:'sd',
    dateParamEnd:'ed'
};
//~ 20120704 Lino.CalendarPanel = Ext.extend(Ext.ensible.cal.CalendarPanel,Lino.MainPanel);
//~ Lino.CalendarPanel = Ext.extend(Lino.CalendarPanel,{
Ext.override(Ext.ensible.cal.CalendarPanel,Lino.MainPanel);
Ext.override(Ext.ensible.cal.CalendarPanel,{
  //~ empty_title : "\$ui.get_actor('cal.Panel').report.label",
  empty_title : "Kalender"
  ,activeItem: 1 // 0: day, 1: week
  ,ls_url: '/cal/CalendarPanel'
  //~ ,disableCaching:true
  //~ ,eventStore: Lino.eventStore
  //~ ,calendarStore: Lino.calendarStore
  //~ ,initComponent : function(){
    //~ Ext.ensible.cal.CalendarPanel.superclass.initComponent.call(this);
    //~ this.eventStore.on('load',function(){
      //~ console.log("20130808",Lino.eventStore);
      //~ if (this.eventStore.reader.jsonData) {
        //~ console.log("20130808 b",this.eventStore.reader.jsonData.title);
        //~ this.set_window_title(this.eventStore.reader.jsonData.title);
      //~ }
    //~ },this);
  //~ }
  ,listeners: { 
    editdetails: function(cp,rec,el) {
      //~ console.log("Lino.on_editdetails",arguments);
      if (rec.data.ID)
          Lino.cal.PanelEvents.detail.run(null,{record_id:rec.data.ID,base_params:this.app_instance.event_store.baseParams});
      return false;
    }
    ,eventclick: function(cp,rec,el) {
      //~ console.log("Lino.on_eventclick",arguments);
      //~ Lino.cal.Events.detail_action.run({record_id:rec.data.ID});
      Lino.cal.PanelEvents.detail.run(null,{record_id:rec.data.ID,base_params:this.app_instance.event_store.baseParams});
      return false;
    }
    //~ ,eventadd: Lino.on_eventadd
    //~ ,eventdelete: Lino.on_eventdelete
    //~ ,eventresize: Lino.on_eventresize
    ,afterrender : function(config) {
      //~ console.log("20120704 afterrender");
      this.app_instance.calendar_store.load();
      //~ console.log("20120704 afterrender calls eventStore.load()",p);
      this.app_instance.event_store.cal_panel = this;
      //~ Lino.eventStore.load({params:p});
      this.app_instance.event_store.load();
      //~ Lino.CalendarPanel.superclass.constructor.call(this, config);
      //~ console.log(20120118, config,this);
    }
    }
  ,enableEditDetails: false
  //~ ,monthViewCfg: Lino.CalendarCfg
  //~ ,weekViewCfg: Lino.CalendarCfg
  //~ ,multiDayViewCfg: Lino.CalendarCfg
  //~ ,multiWeekViewCfg: Lino.CalendarCfg
  //~ ,dayViewCfg: Lino.CalendarCfg
  //~ ,initComponent : function() {
    //~ // this.on('eventadd',Lino.on_eventadd);
    //~ Lino.CalendarPanel.superclass.initComponent.call(this);
  //~ }
});




Lino.CalendarAppPanel = Ext.extend(Ext.Panel,Lino.MainPanel);
Lino.CalendarAppPanel = Ext.extend(Lino.CalendarAppPanel,Lino.PanelMixin);
Lino.CalendarAppPanel = Ext.extend(Lino.CalendarAppPanel,{
  app_instance : null
  //~ empty_title : "\$ui.get_actor('cal.Panel').report.label",
  ,empty_title : "Kalender"
  ,ls_url: '/cal/CalendarPanel'
  ,set_status : function(status,rp) { 
      this.requesting_panel = Ext.getCmp(rp);
      //~ console.log('20120918 CalendarAppPanel.set_status()',status,rp,this.requesting_panel);
      this.clear_base_params();
      if (status == undefined) status = {};
      //~ if (status.param_values) 
      //~ this.set_field_values(status.field_values);
      if (status.base_params) this.set_base_params(status.base_params);
      this.refresh();
      }
  ,refresh : function() {
      this.app_instance.event_store.reload();
  }
  ,layout: 'fit'
  ,get_base_params : function() {
    var p = Ext.apply({},this.base_params);
    Lino.insert_subst_user(p);
    return p;
  }
  ,set_base_params : function(p) {
    this.base_params = Ext.apply(this.app_instance.event_store.baseParams,p);
    this.app_instance.event_store.baseParams = this.base_params;
  }
  ,clear_base_params : function() {
      this.base_params = {};
      Lino.insert_subst_user(this.base_params);
  }
  ,set_base_param : function(k,v) {
      if (!this.base_params) this.base_params = {};
      this.base_params[k] = v;
  }
});

Lino.CalendarApp = function() { return {
  team_view_button : null 
  ,get_main_panel : function() {
      this.event_store = new Ext.data.JsonStore({ 
          listeners: { exception: Lino.on_store_exception }
          ,url: '/restful/cal/PanelEvents'
          ,restful : true
          ,proxy: new Ext.data.HttpProxy({ 
              url: '/restful/cal/PanelEvents', 
              disableCaching: false // no need for cache busting when loading via Ajax
              //~ disableCaching:true,
          })
          ,fields: Ext.ensible.cal.EventRecord.prototype.fields.getRange()
          ,totalProperty: "count"
          ,root: "rows"
          ,idProperty: Ext.ensible.cal.EventMappings.EventId.mapping
          ,writer : new Ext.data.JsonWriter({
            writeAllFields: false
          })
          ,load: function(options) {
            //~ foo.bar = baz; // 20120213
              if (!options) options = {};
              if (!options.params) options.params = {};
              //~ options.params.$ext_requests.URL_PARAM_TEAM_VIEW = Lino.calendar_app.team_view_button.pressed;
              
              var view = this.cal_panel.getActiveView();
              var bounds = view.getViewBounds();
              //~ var p = {sd:'05.02.2012',ed:'11.02.2012'};
              //~ var p = {};
              options.params[view.dateParamStart] = bounds.start.format(view.dateParamFormat);
              options.params[view.dateParamEnd] = bounds.end.format(view.dateParamFormat);
              Lino.insert_subst_user(options.params);
              //~ Ext.apply(options.params,p)
              //~ console.log('20120710 eventStore.load()',this.baseParams,options);
            
            return Ext.data.JsonStore.prototype.load.call(this,options);
          }
      });

      //~ Lino.calendarStore
      this.calendar_store = new Ext.data.JsonStore({ 
          listeners: { exception: Lino.on_store_exception }
          ,restful : true
          ,proxy: new Ext.data.HttpProxy({ 
              url: '/restful/cal/PanelCalendars?fmt=json', 
              disableCaching: false // no need for cache busting when loading via Ajax
              //~ restful : true
              //~ method: "GET"
          })
          //~ ,autoLoad: true
          //~ ,remoteSort: true
          //~ ,baseParams: bp
          ,totalProperty: "count"
          ,root: "rows"
          ,fields: Ext.ensible.cal.CalendarRecord.prototype.fields.getRange()
          ,idProperty: Ext.ensible.cal.CalendarMappings.CalendarId.mapping
          //~ ,idIndex: Ext.ensible.cal.CalendarMappings.CalendarId.mapping
      });
      
      var cap = new Lino.CalendarAppPanel({ 
          app_instance: this, 
          items : 
        //~ [{
          //~ id: 'app-header',
          //~ region: 'north',
          //~ height: 35,
          //~ border: false,
          // contentEl: 'app-header-content'
        //~ },
      {
          id: 'app-center',
          title: '...', // will be updated to the current view's date range
          region: 'center',
          layout: 'border',
          listeners: {
              'afterrender': function(){
                  Ext.getCmp('app-center').header.addClass('app-center-header');
              }
          },
          items: [{
              id:'app-west',
              region: 'west',
              width: 176,
              border: false,
              items: [{
                  xtype: 'datepicker',
                  id: 'app-nav-picker',
                  cls: 'ext-cal-nav-picker',
                  listeners: {
                      'select': {
                          fn: function(dp, dt){
                              //~ Lino.calendarPanel.setStartDate(dt);
                              this.setStartDate(dt);
                          },
                          scope: this
                      }
                  }
              //~ },{ 
                //~ layout:'fit',
                //~ items: [
                  //~ new Ext.form.Checkbox({
                    //~ boxLabel:"$_('Team view')",
                    //~ hideLabel:true
                    //~ listeners: { click: }
                  //~ })
                //~ ]
              },{ 
                layout:'form',
                items: [
                  this.team_view_button = new Ext.Button({
                    text:"Team-Ansicht",
                    enableToggle:true,
                    pressed:false,
                    toggleHandler: function(btn,state) { 
                      //~ console.log('20120716 teamView.toggle()');
                      this.event_store.setBaseParam('tv',state);
                      this.event_store.load();
                      //~ Lino.eventStore.load({params:{$ext_requests.URL_PARAM_TEAM_VIEW:state}});
                      //~ console.log("team view",state);
                    }
                  })
                ]
              },{
                  xtype: 'extensible.calendarlist',
                  store: this.calendar_store,
                  border: false,
                  width: 175
              }]
          },{
              xtype: 'extensible.calendarpanel', // Ext.ensible.cal.CalendarPanel
              eventStore: this.event_store,
              app_instance: this,
              calendarStore: this.calendar_store,
              border: false,
              id:'app-calendar',
              region: 'center',
              //~ activeItem: 3, // month view
              
              // Any generic view options that should be applied to all sub views:
              viewConfig: {
                  // Lino.CalendarCfg
                  dateParamFormat: 'd.m.Y',
                  dateParamStart:'sd',
                  dateParamEnd:'ed',
                
                  //enableFx: false,
                  //ddIncrement: 10, //only applies to DayView and subclasses, but convenient to put it here
                  viewStartHour: 8,
                  viewEndHour: 18
                  //minEventDisplayMinutes: 15
              },
              
              // View options specific to a certain view (if the same options exist in viewConfig
              // they will be overridden by the view-specific config):
              monthViewCfg: {
                  showHeader: true,
                  showWeekLinks: true,
                  showWeekNumbers: true,
                  eventBodyMarkup: ['{Title}',
                    //~ '<tpl if="url">',
                        //~ '<a href="{url}">XX</a>',
                    //~ '</tpl>',
                    '<tpl if="_isReminder">',
                        '<i class="ext-cal-ic ext-cal-ic-rem">&#160;</i>',
                    '</tpl>',
                    '<tpl if="_isRecurring">',
                        '<i class="ext-cal-ic ext-cal-ic-rcr">&#160;</i>',
                    '</tpl>',
                    '<tpl if="spanLeft">',
                        '<i class="ext-cal-spl">&#160;</i>',
                    '</tpl>',
                    '<tpl if="spanRight">',
                        '<i class="ext-cal-spr">&#160;</i>',
                    '</tpl>'
                ].join('')
              },
              
              multiWeekViewCfg: {
                  //weekCount: 3
              },
              
              // Some optional CalendarPanel configs to experiment with:
              //readOnly: true,
              //showDayView: false,
              //showMultiDayView: true,
              //showWeekView: false,
              //showMultiWeekView: false,
              //showMonthView: false,
              //showNavBar: false,
              //showTodayText: false,
              //showTime: false,
              //editModal: true,
              //enableEditDetails: false,
              //title: 'My Calendar', // the header of the calendar, could be a subtitle for the app
              
              // Once this component inits it will set a reference to itself as an application
              // member property for easy reference in other functions within App.
              //~ initComponent: function() {
                  //~ Lino.calendarPanel = this;
                  //~ this.constructor.prototype.initComponent.apply(this, arguments);
              //~ },
              
              listeners: {
                  //~ 'eventclick': {
                      //~ fn: function(vw, rec, el){
                          //~ this.clearMsg();
                      //~ },
                      //~ scope: this
                  //~ },
                  'eventover': function(vw, rec, el){
                      //console.log('Entered evt rec='+rec.data[Ext.ensible.cal.EventMappings.Title.name]', view='+ vw.id +', el='+el.id);
                  },
                  'eventout': function(vw, rec, el){
                      //console.log('Leaving evt rec='+rec.data[Ext.ensible.cal.EventMappings.Title.name]+', view='+ vw.id +', el='+el.id);
                  },
                  'eventadd': {
                      fn: function(cp, rec){
                          this.showMsg('Event '+ rec.data[Ext.ensible.cal.EventMappings.Title.name] +' was added');
                      },
                      scope: this
                  },
                  'eventupdate': {
                      fn: function(cp, rec){
                          this.showMsg('Event '+ rec.data[Ext.ensible.cal.EventMappings.Title.name] +' was updated');
                      },
                      scope: this
                  },
                  'eventdelete': {
                      fn: function(cp, rec){
                          //this.eventStore.remove(rec);
                          this.showMsg('Event '+ rec.data[Ext.ensible.cal.EventMappings.Title.name] +' was deleted');
                      },
                      scope: this
                  },
                  'eventcancel': {
                      fn: function(cp, rec){
                          // edit canceled
                      },
                      scope: this
                  },
                  'viewchange': {
                      fn: function(p, vw, dateInfo){
                          if(this.editWin){
                              this.editWin.hide();
                          };
                          if(dateInfo !== null){
                              // will be null when switching to the event edit form so ignore
                              Ext.getCmp('app-nav-picker').setValue(dateInfo.activeDate);
                              this.updateTitle(dateInfo.viewStart, dateInfo.viewEnd);
                          }
                          
                      },
                      scope: this
                  },
                  'dayclick': {
                      fn: function(vw, dt, ad, el){
                          this.clearMsg();
                      },
                      scope: this
                  },
                  'rangeselect': {
                      fn: function(vw, dates, onComplete){
                          this.clearMsg();
                      },
                      scope: this
                  },
                  'eventmove': {
                      fn: function(vw, rec){
                          rec.commit();
                          var time = rec.data[Ext.ensible.cal.EventMappings.IsAllDay.name] ? '' : ' \\a\\t g:i a';
                          this.showMsg('Event '+ rec.data[Ext.ensible.cal.EventMappings.Title.name] +' was moved to '+
                              rec.data[Ext.ensible.cal.EventMappings.StartDate.name].format('F jS'+time));
                      },
                      scope: this
                  },
                  'eventresize': {
                      fn: function(vw, rec){
                          rec.commit();
                          this.showMsg('Event '+ rec.data[Ext.ensible.cal.EventMappings.Title.name] +' was updated');
                      },
                      scope: this
                  },
                  'eventdelete': {
                      fn: function(win, rec){
                          this.event_store.remove(rec);
                          this.showMsg('Event '+ rec.data[Ext.ensible.cal.EventMappings.Title.name] +' was deleted');
                      },
                      scope: this
                  },
                  'initdrag': {
                      fn: function(vw){
                          if(this.editWin && this.editWin.isVisible()){
                              this.editWin.hide();
                          }
                      },
                      scope: this
                  }
              }
          }]
        }
        //~ ]
        
      });
      
      this.event_store.on('load',function(){
        //~ console.log("20130808",this.event_store);
        if (this.event_store.reader.jsonData) {
          //~ console.log("20130808 b",this.event_store.reader.jsonData.title);
          //~ console.log("20130808 c",this);
          cap.set_window_title(this.event_store.reader.jsonData.title);
        }
      },this);
      
      //~ cap.app_instance = this;
      return cap;
      
  }
  ,updateTitle: function(startDt, endDt){
      var p = Ext.getCmp('app-center');
      
      if(startDt.clearTime().getTime() == endDt.clearTime().getTime()){
          p.setTitle(startDt.format('F j, Y'));
      }
      else if(startDt.getFullYear() == endDt.getFullYear()){
          if(startDt.getMonth() == endDt.getMonth()){
              p.setTitle(startDt.format('F j') + ' - ' + endDt.format('j, Y'));
          }
          else{
              p.setTitle(startDt.format('F j') + ' - ' + endDt.format('F j, Y'));
          }
      }
      else{
          p.setTitle(startDt.format('F j, Y') + ' - ' + endDt.format('F j, Y'));
      }
  }
  // This is an application-specific way to communicate CalendarPanel event messages back to the user.
  // This could be replaced with a function to do "toast" style messages, growl messages, etc. This will
  // vary based on application requirements, which is why it's not baked into the CalendarPanel.
  ,showMsg: function(msg){
      Lino.notify(msg);
      //~ Ext.fly('app-msg').update(msg).removeClass('x-hidden');
  }
  
  ,clearMsg: function(){
      Lino.notify('');
      //~ Ext.fly('app-msg').update('').addClass('x-hidden');
  }
}
};




/*
captureEvents utility by Aaron Conran
<http://www.sencha.com/learn/grid-faq/>

Ext.onReady(function(){
    var grid = new Ext.grid.GridPanel({
        ... 
    });
    captureEvents(grid);
});
*/
function captureEvents(observable) {
    Ext.util.Observable.capture(
        observable,
        function(eventName) {
            console.info(eventName);
        },
        this
    );		
}
 




var cardReader = new be.belgium.eid.CardReader();

function noCardPresentHandler() {
  window.alert("No card present!");
}
cardReader.setNoCardPresentHandler(noCardPresentHandler);

function noReaderDetectedHandler() {
  window.alert("No reader detected!");
}
cardReader.setNoReaderDetectedHandler(noReaderDetectedHandler);

function appletNotFoundHandler() {
  window.alert("Applet not found!");
}
cardReader.setAppletNotFoundHandler(appletNotFoundHandler);

function appletExceptionHandler(e) {
  window.alert("Error reading card!\r\nException: " + e + "\r\nPlease try again.");
}
cardReader.setAppletExceptionHandler(appletExceptionHandler);

//~ function clearPicture() {
  //~ document.getElementById("encoded_picture").src = "data:image/jpeg;base64,";
//~ }

Lino.beid_read_card_processor = function() {
    var card = cardReader.read();
    if (!card) {
        //~ Lino.alert("No card returned.");
        return null;
    } 
    console.log(card.getPicture());
    return {
      cardNumber: card.cardNumber,
      validityBeginDate:card.validityBeginDate.format("d.m.Y"),
      validityEndDate: card.validityEndDate.format("d.m.Y"),
      chipNumber:card.chipNumber,
      issuingMunicipality:card.issuingMunicipality,
      nationalNumber:card.nationalNumber,
      surname:card.surname,
      firstName1:card.firstName1,
      firstName2:card.firstName2,
      firstName3:card.firstName3,
      nationality:card.nationality,
      birthLocation:card.birthLocation,
      birthDate: card.birthDate.format("d.m.Y"),
      sex:card.sex,
      nobleCondition:card.nobleCondition,
      documentType:card.documentType,
      specialStatus:card.specialStatus,
      whiteCane:card.whiteCane,
      yellowCane:card.yellowCane,
      extendedMinority:card.extendedMinority,
      street:card.street,
      streetNumber:card.streetNumber,
      boxNumber:card.boxNumber,
      zipCode:card.zipCode,
      municipality:card.municipality,
      country:card.country
      //~ comment the following line out to test whether the picture takes a lot of time
      //~ test 20121214 on my machine revealed no perceivable gain
      ,picture:base64.encode(card.getPicture())
    };
}





Lino.main_menu = [ { "menu": { "items": [ { "text": "Personen", "handler": function() {Lino.contacts.Persons.grid.run(null)} }, { "text": " \u25b6 Klienten", "handler": function() {Lino.pcsw.Clients.grid.run(null)} }, { "text": "Organisationen", "handler": function() {Lino.contacts.Companies.grid.run(null)} }, "-", { "text": "Partner (alle)", "handler": function() {Lino.contacts.Partners.grid.run(null)} }, { "text": "Haushalte", "handler": function() {Lino.households.Households.grid.run(null)} } ] }, "text": "Kontakte" }, { "menu": { "items": [ { "text": "Mein E-Mail-Ausgang", "handler": function() {Lino.outbox.MyOutbox.grid.run(null)} }, { "text": "Meine Notizen", "handler": function() {Lino.notes.MyNotes.grid.run(null)} } ] }, "text": "B\u00fcro" }, { "menu": { "items": [ { "text": "Kalender", "iconCls": "x-tbar-calendar", "handler": function() {Lino.cal.CalendarPanel.grid.run(null)} }, { "text": "Meine Termine", "listeners": { "render": Lino.quicktip_renderer("Foo","Alle meine Termine") }, "handler": function() {Lino.cal.MyEvents.grid.run(null)} }, { "text": "Meine Aufgaben", "listeners": { "render": Lino.quicktip_renderer("Foo","Alle meine Aufgaben") }, "handler": function() {Lino.cal.MyTasks.grid.run(null)} }, { "text": "Meine G\u00e4ste", "handler": function() {Lino.cal.MyGuests.grid.run(null)} }, { "text": "Meine Anwesenheiten", "listeners": { "render": Lino.quicktip_renderer("Foo","Shows all my presences in calendar events, independently of their state.") }, "handler": function() {Lino.cal.MyPresences.grid.run(null)} } ] }, "text": "Kalender" }, { "menu": { "items": [ { "text": "Wartende Besucher", "handler": function() {Lino.reception.MyWaitingGuests.grid.run(null)} } ] }, "text": "Empfang" }, { "menu": { "items": [ { "text": "Neue Klienten", "listeners": { "render": Lino.quicktip_renderer("Foo","Liste der neuen Klienten zwecks Zuweisung \neines Begleiters oder Ablehnen des Hilfeantrags.") }, "handler": function() {Lino.newcomers.NewClients.grid.run(null)} }, { "text": "Verf\u00fcgbare Begleiter", "listeners": { "render": Lino.quicktip_renderer("Foo","List of users available for new coachings") }, "handler": function() {Lino.newcomers.AvailableCoaches.grid.run(null)} } ] }, "text": "Neuantr\u00e4ge" }, { "menu": { "items": [ { "menu": { "items": [ { "text": "Benutzer und ihre Klienten", "handler": function() {Lino.integ.UsersWithClients.grid.run(null)} } ] }, "text": "DSBE" } ] }, "text": "Listings" }, { "menu": { "items": [ { "menu": { "items": [ { "text": "Meine Einf\u00fcgetexte", "handler": function() {Lino.system.MyTextFieldTemplates.grid.run(null)} } ] }, "text": "B\u00fcro" }, { "menu": { "items": [ { "text": "L\u00e4nder", "listeners": { "render": Lino.quicktip_renderer("Foo","\n    A country is a geographic entity considered a \"nation\".\n    ") }, "handler": function() {Lino.countries.Countries.grid.run(null)} }, { "text": "Sprachen", "handler": function() {Lino.languages.Languages.grid.run(null)} } ] }, "text": "Kontakte" } ] }, "text": "Konfigurierung" }, { "menu": { "items": [ { "text": "Info", "listeners": { "render": Lino.quicktip_renderer("Foo","Zeigt Informationen \u00fcber diese Site an.") }, "handler": function() {Lino.about.About.show.run(null,{ "record_id": -99998 })} } ] }, "text": "Site" }, { "text": "Startseite", "handler": function() {Lino.close_all_windows()} } ];
Ext.namespace('Lino.system.SiteConfigs')
Ext.namespace('Lino.system.ContentTypes')
Ext.namespace('Lino.system.HelpTexts')
Ext.namespace('Lino.system.TextFieldTemplates')
Ext.namespace('Lino.users.Users')
Ext.namespace('Lino.users.MySettings')
Ext.namespace('Lino.users.UsersOverview')
Ext.namespace('Lino.users.Teams')
Ext.namespace('Lino.users.Memberships')
Ext.namespace('Lino.users.Authorities')
Ext.namespace('Lino.changes.Changes')
Ext.namespace('Lino.countries.Countries')
Ext.namespace('Lino.countries.Cities')
Ext.namespace('Lino.properties.PropGroups')
Ext.namespace('Lino.properties.PropTypes')
Ext.namespace('Lino.properties.Properties')
Ext.namespace('Lino.properties.PropChoices')
Ext.namespace('Lino.contacts.CompanyTypes')
Ext.namespace('Lino.contacts.Partners')
Ext.namespace('Lino.contacts.Companies')
Ext.namespace('Lino.contacts.RoleTypes')
Ext.namespace('Lino.contacts.Roles')
Ext.namespace('Lino.contacts.Persons')
Ext.namespace('Lino.outbox.Recipients')
Ext.namespace('Lino.outbox.Mails')
Ext.namespace('Lino.outbox.Attachments')
Ext.namespace('Lino.cal.Calendars')
Ext.namespace('Lino.cal.Subscriptions')
Ext.namespace('Lino.cal.Rooms')
Ext.namespace('Lino.cal.Priorities')
Ext.namespace('Lino.cal.Events')
Ext.namespace('Lino.cal.OneEvent')
Ext.namespace('Lino.cal.MyEvents')
Ext.namespace('Lino.cal.MyAssignedEvents')
Ext.namespace('Lino.cal.Tasks')
Ext.namespace('Lino.cal.MyTasks')
Ext.namespace('Lino.cal.GuestRoles')
Ext.namespace('Lino.cal.Guests')
Ext.namespace('Lino.cal.MyPresences')
Ext.namespace('Lino.cal.MyPendingPresences')
Ext.namespace('Lino.cal.MyGuests')
Ext.namespace('Lino.cal.PanelCalendars')
Ext.namespace('Lino.cal.PanelEvents')
Ext.namespace('Lino.uploads.UploadTypes')
Ext.namespace('Lino.uploads.Uploads')
Ext.namespace('Lino.households.Types')
Ext.namespace('Lino.households.Households')
Ext.namespace('Lino.households.Roles')
Ext.namespace('Lino.households.Members')
Ext.namespace('Lino.reception.ExpectedGuests')
Ext.namespace('Lino.reception.ReceivedGuests')
Ext.namespace('Lino.reception.MyWaitingGuests')
Ext.namespace('Lino.notes.NoteTypes')
Ext.namespace('Lino.notes.EventTypes')
Ext.namespace('Lino.notes.Notes')
Ext.namespace('Lino.cv.LanguageKnowledges')
Ext.namespace('Lino.cv.PersonProperties')
Ext.namespace('Lino.isip.ContractTypes')
Ext.namespace('Lino.isip.ExamPolicies')
Ext.namespace('Lino.isip.ContractEndings')
Ext.namespace('Lino.isip.StudyTypes')
Ext.namespace('Lino.isip.Contracts')
Ext.namespace('Lino.isip.MyContracts')
Ext.namespace('Lino.jobs.Schedules')
Ext.namespace('Lino.jobs.Regimes')
Ext.namespace('Lino.jobs.JobProviders')
Ext.namespace('Lino.jobs.ContractTypes')
Ext.namespace('Lino.jobs.Sectors')
Ext.namespace('Lino.jobs.Functions')
Ext.namespace('Lino.jobs.Contracts')
Ext.namespace('Lino.jobs.MyContracts')
Ext.namespace('Lino.jobs.Offers')
Ext.namespace('Lino.jobs.Studies')
Ext.namespace('Lino.jobs.Experiences')
Ext.namespace('Lino.jobs.Candidatures')
Ext.namespace('Lino.jobs.Jobs')
Ext.namespace('Lino.jobs.JobTypes')
Ext.namespace('Lino.jobs.ContractsSearch')
Ext.namespace('Lino.pcsw.Clients')
Ext.namespace('Lino.pcsw.DebtsClients')
Ext.namespace('Lino.pcsw.ClientsTest')
Ext.namespace('Lino.pcsw.PersonGroups')
Ext.namespace('Lino.pcsw.Activities')
Ext.namespace('Lino.pcsw.DispenseReasons')
Ext.namespace('Lino.pcsw.Dispenses')
Ext.namespace('Lino.pcsw.ExclusionTypes')
Ext.namespace('Lino.pcsw.Exclusions')
Ext.namespace('Lino.pcsw.AidTypes')
Ext.namespace('Lino.pcsw.ClientContactTypes')
Ext.namespace('Lino.pcsw.ClientContacts')
Ext.namespace('Lino.pcsw.CoachingTypes')
Ext.namespace('Lino.pcsw.CoachingEndings')
Ext.namespace('Lino.pcsw.Coachings')
Ext.namespace('Lino.reception.Clients')
Ext.namespace('Lino.reception.WaitingGuests')
Ext.namespace('Lino.languages.Languages')
Ext.namespace('Lino.accounts.Charts')
Ext.namespace('Lino.accounts.Groups')
Ext.namespace('Lino.accounts.Accounts')
Ext.namespace('Lino.courses.CourseProviders')
Ext.namespace('Lino.courses.CourseContents')
Ext.namespace('Lino.courses.Courses')
Ext.namespace('Lino.courses.CourseOffers')
Ext.namespace('Lino.courses.CourseRequests')
Ext.namespace('Lino.courses.PendingCourseRequests')
Ext.namespace('Lino.integ.Clients')
Ext.namespace('Lino.integ.CoachingEndingsByUser')
Ext.namespace('Lino.integ.CoachingEndingsByType')
Ext.namespace('Lino.integ.ContractEndingsByType')
Ext.namespace('Lino.integ.JobsContractEndingsByType')
Ext.namespace('Lino.integ.ContractsPerUserAndContractType')
Ext.namespace('Lino.integ.JobsContractsPerUserAndContractType')
Ext.namespace('Lino.integ.StudyTypesAndContracts')
Ext.namespace('Lino.integ.CompaniesAndContracts')
Ext.namespace('Lino.integ.JobProvidersAndContracts')
Ext.namespace('Lino.newcomers.Brokers')
Ext.namespace('Lino.newcomers.Faculties')
Ext.namespace('Lino.newcomers.Competences')
Ext.namespace('Lino.newcomers.NewClients')
Ext.namespace('Lino.newcomers.AvailableCoaches')
Ext.namespace('Lino.debts.Budgets')
Ext.namespace('Lino.debts.Actors')
Ext.namespace('Lino.debts.Entries')
Ext.namespace('Lino.debts.EntriesByType')
Ext.namespace('Lino.cbss.Sectors')
Ext.namespace('Lino.cbss.Purposes')
Ext.namespace('Lino.cbss.IdentifyPersonRequests')
Ext.namespace('Lino.cbss.ManageAccessRequests')
Ext.namespace('Lino.cbss.RetrieveTIGroupsRequests')
Ext.namespace('Lino.sessions.SessionTable')
Ext.namespace('Lino.system.MyTextFieldTemplates')
Ext.namespace('Lino.users.MembershipsByUser')
Ext.namespace('Lino.users.AuthoritiesGiven')
Ext.namespace('Lino.users.AuthoritiesTaken')
Ext.namespace('Lino.countries.CitiesByCity')
Ext.namespace('Lino.countries.CitiesByCountry')
Ext.namespace('Lino.properties.PropsByGroup')
Ext.namespace('Lino.properties.PropsByType')
Ext.namespace('Lino.properties.ChoicesByType')
Ext.namespace('Lino.contacts.PartnersByCity')
Ext.namespace('Lino.contacts.PartnersByCountry')
Ext.namespace('Lino.contacts.RolesByCompany')
Ext.namespace('Lino.contacts.RolesByPerson')
Ext.namespace('Lino.outbox.RecipientsByMail')
Ext.namespace('Lino.outbox.MyOutbox')
Ext.namespace('Lino.outbox.MailsByUser')
Ext.namespace('Lino.outbox.MailsByProject')
Ext.namespace('Lino.outbox.SentByPartner')
Ext.namespace('Lino.outbox.AttachmentsByMail')
Ext.namespace('Lino.cal.SubscriptionsByCalendar')
Ext.namespace('Lino.cal.SubscriptionsByUser')
Ext.namespace('Lino.cal.EventsByCalendar')
Ext.namespace('Lino.cal.EventsByRoom')
Ext.namespace('Lino.cal.EventsByProject')
Ext.namespace('Lino.cal.TasksByUser')
Ext.namespace('Lino.cal.TasksByProject')
Ext.namespace('Lino.cal.GuestsByEvent')
Ext.namespace('Lino.cal.GuestsByRole')
Ext.namespace('Lino.cal.GuestsByPartner')
Ext.namespace('Lino.uploads.MyUploads')
Ext.namespace('Lino.households.HouseholdsByType')
Ext.namespace('Lino.households.MembersByHousehold')
Ext.namespace('Lino.households.MembersByPerson')
Ext.namespace('Lino.households.MembersByRole')
Ext.namespace('Lino.reception.AppointmentsByGuest')
Ext.namespace('Lino.notes.MyNotes')
Ext.namespace('Lino.notes.NotesByType')
Ext.namespace('Lino.notes.NotesByEventType')
Ext.namespace('Lino.notes.NotesByProject')
Ext.namespace('Lino.cv.LanguageKnowledgesByPerson')
Ext.namespace('Lino.cv.KnowledgesByLanguage')
Ext.namespace('Lino.cv.PropsByPerson')
Ext.namespace('Lino.cv.PersonPropsByProp')
Ext.namespace('Lino.cv.ConfiguredPropsByPerson')
Ext.namespace('Lino.cv.SkillsByPerson')
Ext.namespace('Lino.cv.SoftSkillsByPerson')
Ext.namespace('Lino.cv.ObstaclesByPerson')
Ext.namespace('Lino.isip.ContractsByPerson')
Ext.namespace('Lino.isip.ContractsByPolicy')
Ext.namespace('Lino.isip.ContractsByType')
Ext.namespace('Lino.isip.ContractsByEnding')
Ext.namespace('Lino.isip.ContractsByStudyType')
Ext.namespace('Lino.jobs.FunctionsBySector')
Ext.namespace('Lino.jobs.ContractsByPerson')
Ext.namespace('Lino.jobs.ContractsByProvider')
Ext.namespace('Lino.jobs.ContractsByPolicy')
Ext.namespace('Lino.jobs.ContractsByEnding')
Ext.namespace('Lino.jobs.ContractsByJob')
Ext.namespace('Lino.jobs.ContractsByRegime')
Ext.namespace('Lino.jobs.ContractsBySchedule')
Ext.namespace('Lino.jobs.StudiesByCountry')
Ext.namespace('Lino.jobs.StudiesByCity')
Ext.namespace('Lino.jobs.StudiesByPerson')
Ext.namespace('Lino.jobs.ExperiencesByFunction')
Ext.namespace('Lino.jobs.ExperiencesByPerson')
Ext.namespace('Lino.jobs.CandidaturesByPerson')
Ext.namespace('Lino.jobs.CandidaturesBySector')
Ext.namespace('Lino.jobs.CandidaturesByFunction')
Ext.namespace('Lino.jobs.CandidaturesByJob')
Ext.namespace('Lino.jobs.CandidaturesByOffer')
Ext.namespace('Lino.jobs.ExperiencesByOffer')
Ext.namespace('Lino.jobs.JobsByProvider')
Ext.namespace('Lino.jobs.JobsByType')
Ext.namespace('Lino.jobs.ContractsByType')
Ext.namespace('Lino.jobs.JobsOverviewByType')
Ext.namespace('Lino.pcsw.ClientsByNationality')
Ext.namespace('Lino.pcsw.DispensesByClient')
Ext.namespace('Lino.pcsw.ExclusionsByClient')
Ext.namespace('Lino.pcsw.ContactsByClient')
Ext.namespace('Lino.pcsw.CoachingsByClient')
Ext.namespace('Lino.pcsw.CoachingsByUser')
Ext.namespace('Lino.pcsw.CoachingsByEnding')
Ext.namespace('Lino.pcsw.NotesByPerson')
Ext.namespace('Lino.pcsw.NotesByCompany')
Ext.namespace('Lino.reception.CoachingsByClient')
Ext.namespace('Lino.accounts.GroupsByChart')
Ext.namespace('Lino.accounts.AccountsByGroup')
Ext.namespace('Lino.courses.CoursesByOffer')
Ext.namespace('Lino.courses.CourseOffersByProvider')
Ext.namespace('Lino.courses.CourseOffersByContent')
Ext.namespace('Lino.courses.CourseRequestsByPerson')
Ext.namespace('Lino.courses.CourseRequestsByContent')
Ext.namespace('Lino.courses.RequestsByCourse')
Ext.namespace('Lino.courses.ParticipantsByCourse')
Ext.namespace('Lino.courses.CandidatesByCourse')
Ext.namespace('Lino.newcomers.CompetencesByUser')
Ext.namespace('Lino.newcomers.CompetencesByFaculty')
Ext.namespace('Lino.newcomers.MyCompetences')
Ext.namespace('Lino.newcomers.ClientsByFaculty')
Ext.namespace('Lino.newcomers.AvailableCoachesByClient')
Ext.namespace('Lino.debts.MyBudgets')
Ext.namespace('Lino.debts.BudgetsByPartner')
Ext.namespace('Lino.debts.ActorsByBudget')
Ext.namespace('Lino.debts.ActorsByPartner')
Ext.namespace('Lino.debts.EntriesByBudget')
Ext.namespace('Lino.debts.ExpensesByBudget')
Ext.namespace('Lino.debts.IncomesByBudget')
Ext.namespace('Lino.debts.LiabilitiesByBudget')
Ext.namespace('Lino.debts.AssetsByBudget')
Ext.namespace('Lino.debts.DistByBudget')
Ext.namespace('Lino.cbss.MyIdentifyPersonRequests')
Ext.namespace('Lino.cbss.IdentifyRequestsByPerson')
Ext.namespace('Lino.cbss.ManageAccessRequestsByPerson')
Ext.namespace('Lino.cbss.MyManageAccessRequests')
Ext.namespace('Lino.cbss.RetrieveTIGroupsRequestsByPerson')
Ext.namespace('Lino.cbss.MyRetrieveTIGroupsRequests')
Ext.namespace('Lino.uploads.UploadsByController')
Ext.namespace('Lino.system.HelpTextsByModel')
Ext.namespace('Lino.cal.TasksByController')
Ext.namespace('Lino.outbox.MailsByController')
Ext.namespace('Lino.changes.ChangesByMaster')
Ext.namespace('Lino.outbox.AttachmentsByController')
Ext.namespace('Lino.cal.EventsByController')
Ext.namespace('Lino.about.Models')
Ext.namespace('Lino.about.FieldsByModel')
Ext.namespace('Lino.about.Inspector')
Ext.namespace('Lino.about.SourceFiles')
Ext.namespace('Lino.reception.ButtonsTable')
Ext.namespace('Lino.reception.CreateNoteActionsByClient')
Ext.namespace('Lino.integ.UsersWithClients')
Ext.namespace('Lino.integ.CompareRequestsTable')
Ext.namespace('Lino.integ.PeriodicNumbers')
Ext.namespace('Lino.debts.PrintEntriesByBudget')
Ext.namespace('Lino.debts.PrintExpensesByBudget')
Ext.namespace('Lino.debts.PrintIncomesByBudget')
Ext.namespace('Lino.debts.PrintLiabilitiesByBudget')
Ext.namespace('Lino.debts.PrintAssetsByBudget')
Ext.namespace('Lino.debts.SummaryTable')
Ext.namespace('Lino.debts.ResultByBudget')
Ext.namespace('Lino.debts.DebtsByBudget')
Ext.namespace('Lino.debts.BailiffDebtsByBudget')
Ext.namespace('Lino.cbss.IdentifyPersonResult')
Ext.namespace('Lino.cbss.RetrieveTIGroupsResult')
Ext.namespace('Lino.lino.Report')
Ext.namespace('Lino.about.About')
Ext.namespace('Lino.system.Home')
Ext.namespace('Lino.cal.CalendarPanel')
Ext.namespace('Lino.jobs.OldJobsOverview')
Ext.namespace('Lino.jobs.JobsOverview')
Ext.namespace('Lino.integ.ActivityReport')
Ext.namespace('Lino.courses.CourseRequestStates')
Ext.namespace('Lino.cal.DurationUnits')
Ext.namespace('Lino.cal.TaskStates')
Ext.namespace('Lino.cal.Weekdays')
Ext.namespace('Lino.lino.UserLevels')
Ext.namespace('Lino.pcsw.CoachingEvents')
Ext.namespace('Lino.lino.YesNo')
Ext.namespace('Lino.cal.EventStates')
Ext.namespace('Lino.lino.BeIdCardTypes')
Ext.namespace('Lino.accounts.AccountTypes')
Ext.namespace('Lino.cal.Recurrencies')
Ext.namespace('Lino.properties.HowWell')
Ext.namespace('Lino.cv.CefLevel')
Ext.namespace('Lino.jobs.CandidatureStates')
Ext.namespace('Lino.outbox.RecipientType')
Ext.namespace('Lino.cal.EventEvents')
Ext.namespace('Lino.cal.GuestStates')
Ext.namespace('Lino.pcsw.CivilState')
Ext.namespace('Lino.pcsw.ClientStates')
Ext.namespace('Lino.countries.CityTypes')
Ext.namespace('Lino.properties.DoYouLike')
Ext.namespace('Lino.cbss.RequestLanguages')
Ext.namespace('Lino.cbss.ManageAction')
Ext.namespace('Lino.pcsw.RefusalReasons')
Ext.namespace('Lino.lino.UserGroups')
Ext.namespace('Lino.cbss.RequestStates')
Ext.namespace('Lino.lino.ChangeTypes')
Ext.namespace('Lino.cal.AccessClasses')
Ext.namespace('Lino.cbss.QueryRegister')
Ext.namespace('Lino.isip.ContractEvents')
Ext.namespace('Lino.lino.Genders')
Ext.namespace('Lino.pcsw.ClientEvents')
Ext.namespace('Lino.lino.UserProfiles')
Ext.namespace('Lino.pcsw.ResidenceType')

// ChoiceLists: 
Lino.courses.CourseRequestStates = [ [ "10", "Offen" ], [ "20", "Eingetragen" ], [ "30", "Bestanden" ], [ "40", "Gut bestanden" ], [ "50", "Nicht bestanden" ], [ "60", "Abgebrochen" ], [ "70", "Inaktiv" ] ];
Lino.cal.DurationUnits = [ [ "s", "Sekunden" ], [ "m", "Minuten" ], [ "h", "Stunden" ], [ "D", "Tage" ], [ "W", "Wochen" ], [ "M", "Monate" ], [ "Y", "Jahre" ] ];
Lino.cal.TaskStates = [ [ "10", "Zu tun" ], [ "20", "Begonnen" ], [ "30", "Erledigt" ], [ "50", "Storniert" ] ];
Lino.cal.Weekdays = [ [ "1", "Montag" ], [ "2", "Dienstag" ], [ "3", "Mittwoch" ], [ "4", "Donnerstag" ], [ "5", "Freitag" ], [ "6", "Samstag" ], [ "7", "Sonntag" ] ];
Lino.lino.UserLevels = [ [ "10", "Gast" ], [ "30", "Benutzer" ], [ "40", "Manager" ], [ "50", "Verwalter" ], [ "90", "Experte" ] ];
Lino.pcsw.CoachingEvents = [ [ "10", "Begonnen" ], [ "20", "Aktiv" ], [ "30", "Beendet" ] ];
Lino.lino.YesNo = [ [ "y", "Ja" ], [ "n", "Nein" ] ];
Lino.cal.EventStates = [ [ "10", "Vorgeschlagen" ], [ "20", "Entwurf" ], [ "50", "Stattgefunden" ], [ "70", "Storniert" ], [ "40", "Geplant" ] ];
Lino.lino.BeIdCardTypes = [ [ "1", "Belgischer Staatsb\u00fcrger" ], [ "6", "Kind unter 12 Jahren" ], [ "11", "A (Bescheinigung der Eintragung im Ausl\u00e4nderregister - Vor\u00fcbergehender Aufenthalt)" ], [ "12", "B (Bescheinigung der Eintragung im Ausl\u00e4nderregister)" ], [ "13", "C (Personalausweis f\u00fcr Ausl\u00e4nder)" ], [ "14", "D (Daueraufenthalt - EG)" ], [ "15", "E (Anmeldebescheinigung)" ], [ "16", "E+" ], [ "17", "F (Aufenthaltskarte f\u00fcr Familienangeh\u00f6rige eines Unionsb\u00fcrgers)" ], [ "18", "F+" ] ];
Lino.accounts.AccountTypes = [ [ "A", "Verm\u00f6gen" ], [ "L", "Verpflichtungen" ], [ "I", "Eink\u00fcnfte" ], [ "E", "Ausgaben" ], [ "C", "Kapital" ], [ "B", "Bankkonten" ] ];
Lino.cal.Recurrencies = [ [ "D", "t\u00e4glich" ], [ "W", "w\u00f6chentlich" ], [ "M", "monatlich" ], [ "Y", "j\u00e4hrlich" ], [ "P", "pro Wochentag" ] ];
Lino.properties.HowWell = [ [ "0", "gar nicht" ], [ "1", "ein bisschen" ], [ "2", "mittelm\u00e4\u00dfig" ], [ "3", "gut" ], [ "4", "sehr gut" ] ];
Lino.cv.CefLevel = [ [ "A1", "A1 (Elementare Sprachverwendung)" ], [ "A2", "A2 (Elementare Sprachverwendung)" ], [ "A2+", "A2+ (Elementare Sprachverwendung)" ], [ "B1", "B1 (Selbstst\u00e4ndige Sprachverwendung)" ], [ "B2", "B2 (Selbstst\u00e4ndige Sprachverwendung)" ], [ "B2+", "B2+ (Selbstst\u00e4ndige Sprachverwendung)" ], [ "C1", "C1 (Exzellente Sprachverwendung)" ], [ "C2", "C2 (Exzellente Sprachverwendung)" ], [ "C2+", "C2+ (Exzellente Sprachverwendung)" ] ];
Lino.jobs.CandidatureStates = [ [ "10", "Aktiv" ], [ "20", "Probezeit" ], [ "25", "Probezeit ohne Erfolg" ], [ "27", "Arbeitet" ], [ "30", "Inaktiv" ] ];
Lino.outbox.RecipientType = [ [ "to", "Empf\u00e4nger" ], [ "cc", "Kopie an" ], [ "bcc", "Blindkopie an" ] ];
Lino.cal.EventEvents = [ [ "10", "Okay" ], [ "20", "Pending" ] ];
Lino.cal.GuestStates = [ [ "10", "Eingeladen" ], [ "20", "Zugesagt" ], [ "30", "Abgesagt" ], [ "40", "Anwesend" ], [ "50", "Abwesend" ] ];
Lino.pcsw.CivilState = [ [ "10", "Ledig" ], [ "13", "Ledig zusammenwohnend" ], [ "18", "Ledig mit Kind" ], [ "20", "Verheiratet" ], [ "21", "Verheirated (allein lebend)" ], [ "22", "Verheirated (mit anderem Partner lebend)" ], [ "30", "Verwitwet" ], [ "33", "Verwitwet (zusammenwohnend)" ], [ "40", "Geschieden" ], [ "50", "Getrennt von Tisch und Bett" ] ];
Lino.pcsw.ClientStates = [ [ "10", "Neuantrag" ], [ "20", "Abgelehnt" ], [ "30", "Begleitet" ], [ "50", "Ehemalig" ] ];
Lino.countries.CityTypes = [ [ "10", "Bundesland" ], [ "11", "Division" ], [ "12", "Region" ], [ "13", "Gemeinschaft" ], [ "14", "Territorium" ], [ "20", "Regierungsbezirk" ], [ "21", "Provinz" ], [ "22", "Grafschaft" ], [ "23", "Unterregion" ], [ "24", "Departement" ], [ "25", "Arrondissement" ], [ "26", "Pr\u00e4fektur" ], [ "27", "Distrikt" ], [ "28", "Sektor" ], [ "50", "Stadt" ], [ "51", "Kleinstadt" ], [ "52", "Gemeinde" ], [ "54", "Pfarre" ], [ "55", "Stadtteil" ], [ "56", "Viertel" ], [ "61", "Ortschaft" ], [ "62", "Kleine Ortschaft" ], [ "70", "Dorf" ] ];
Lino.properties.DoYouLike = [ [ "0", "blo\u00df nicht" ], [ "1", "eher nicht" ], [ "2", "normal" ], [ "3", "gerne" ], [ "4", "sehr gerne" ] ];
Lino.cbss.RequestLanguages = [ [ "nl", "Niederl\u00e4ndisch" ], [ "fr", "Franz\u00f6sisch" ], [ "de", "Deutsch" ] ];
Lino.cbss.ManageAction = [ [ "1", "Registrieren" ], [ "2", "Austragen" ], [ "3", "Auflisten" ] ];
Lino.pcsw.RefusalReasons = [ [ "10", "Information (keine Begleitung erforderlich)" ], [ "20", "\u00d6SHZ ist nicht zust\u00e4ndig" ], [ "30", "Antragsteller ist nicht zur\u00fcck gekommen" ] ];
Lino.lino.UserGroups = [ [ "office", "office (B\u00fcro)" ], [ "reception", "reception (Empfang)" ], [ "accounting", "accounting (Buchhaltung)" ], [ "integ", "integ (DSBE)" ], [ "newcomers", "newcomers (Neuantr\u00e4ge)" ], [ "debts", "debts (Schuldnerberatung)" ], [ "cbss", "cbss (ZDSS)" ] ];
Lino.cbss.RequestStates = [ [ "10", "Versendet" ], [ "20", "Fehlgeschlagen" ], [ "25", "Validiert" ], [ "30", "OK" ], [ "40", "Warnungen" ], [ "50", "Fehlermeldungen" ] ];
Lino.lino.ChangeTypes = [ [ "C", "Erstellen" ], [ "U", "Aktualisierung" ], [ "D", "L\u00f6schen" ], [ "R", "Remove child" ], [ "A", "Add child" ], [ "M", "Fusionieren" ] ];
Lino.cal.AccessClasses = [ [ "10", "Privat" ], [ "20", "halb \u00f6ffentlich (\"Besch\u00e4ftigt\")" ], [ "30", "\u00d6ffentlich" ] ];
Lino.cbss.QueryRegister = [ [ "1", "Prim\u00e4r" ], [ "2", "Sekund\u00e4r" ], [ "3", "Alle" ] ];
Lino.isip.ContractEvents = [ [ "10", "Begonnen" ], [ "20", "Aktiv" ], [ "30", "Beendet" ], [ "40", "Unterschrieben" ] ];
Lino.lino.Genders = [ [ "M", "M\u00e4nnlich" ], [ "F", "Weiblich" ] ];
Lino.pcsw.ClientEvents = [ [ "10", "Aktiv" ], [ "20", "VSE" ], [ "21", "Art.60\u00a77-Konvention" ], [ "22", "Dispenz" ], [ "30", "AG-Sperre" ], [ "40", "Note" ], [ "50", "Erstellt" ], [ "60", "Bearbeitet" ] ];
Lino.lino.UserProfiles = [ [ "000", "000 (Anonym)" ], [ "100", "100 (Begleiter im DSBE)" ], [ "110", "110 (Integrations-Assistent (Manager))" ], [ "200", "200 (Berater Neuantr\u00e4ge)" ], [ "210", "210 (Empfangsschalter)" ], [ "300", "300 (Schuldenberater)" ], [ "500", "500 (nur ZDSS)" ], [ "900", "900 (Verwalter)" ] ];
Lino.pcsw.ResidenceType = [ [ "1", "Bev\u00f6lkerungsregister" ], [ "2", "Fremdenregister" ], [ "3", "Warteregister" ] ];

Lino.newcomers.NewClients.ParamsPanel = Ext.extend(Ext.form.FormPanel,{
  autoHeight: true,
  layout: "hbox",
  frame: true,
  layoutConfig: { "align": "stretchmax" },
  hideCheckBoxLabels: true,
  autoScroll: false,
  labelWidth: 225,
  border: false,
  bodyBorder: false,
  labelAlign: "top",
  initComponent : function() {
    var containing_panel = this;
    var new_since3473 = new Lino.DateField({ "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Neue Klienten seit","(newcomers.NewClients.new_since) Auch Klienten, die erst seit Kurzem begleitet sind.") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Neue Klienten seit</span>", "anchor": "-20", "name": "new_since" });
    var also_refused3474 = new Ext.form.Checkbox({ "boxLabel": "Auch abgelehnte Klienten", "listeners": { "render": Lino.quicktip_renderer("Auch abgelehnte Klienten","(newcomers.NewClients.also_refused) ") }, "hideLabel": true, "checked": false, "name": "also_refused", "selectOnFocus": true, "anchor": "-20" });
    var also_obsolete3475 = new Ext.form.Checkbox({ "boxLabel": "Auch veraltete Daten", "listeners": { "render": Lino.quicktip_renderer("Auch veraltete Daten","(newcomers.NewClients.also_obsolete) ") }, "hideLabel": true, "checked": false, "name": "also_obsolete", "selectOnFocus": true, "anchor": "-20" });
    var coached_by3476 = new Lino.TwinCombo({ "preferred_width": 15, "fieldLabel": "Begleitet durch", "name": "coached_by", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.users.Users.detail)}, "hiddenName": "coached_byHidden", "listeners": { "render": Lino.quicktip_renderer("Begleitet durch","(newcomers.NewClients.coached_by) ") }, "selectOnFocus": true, "emptyText": "Benutzer ausw\u00e4hlen...", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/newcomers/NewClients/coached_by", "method": "GET" }) }) });
    this.items = [ { "flex": 16, "autoHeight": true, "layout": "form", "xtype": "panel", "items": new_since3473, "labelAlign": "top" }, { "flex": 20, "autoHeight": true, "layout": "form", "xtype": "panel", "items": also_refused3474, "labelAlign": "top" }, { "flex": 20, "autoHeight": true, "layout": "form", "xtype": "panel", "items": also_obsolete3475, "labelAlign": "top" }, { "flex": 41, "autoHeight": true, "layout": "form", "xtype": "panel", "items": coached_by3476, "labelAlign": "top" } ];
    this.fields = [ new_since3473, also_refused3474, also_obsolete3475, coached_by3476 ];
    Lino.newcomers.NewClients.ParamsPanel.superclass.initComponent.call(this);
  }
});


Lino.cal.MyPresences.ParamsPanel = Ext.extend(Ext.form.FormPanel,{
  autoScroll: false,
  autoHeight: true,
  border: false,
  layout: "form",
  hideCheckBoxLabels: true,
  frame: true,
  bodyBorder: false,
  labelAlign: "top",
  initComponent : function() {
    var containing_panel = this;
    var start_date1272 = new Lino.DateField({ "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Periode vom","(cal.Guests.start_date) Start date of observed period") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Periode vom</span>", "anchor": "-20", "name": "start_date" });
    var end_date1273 = new Lino.DateField({ "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("bis","(cal.Guests.end_date) End date of observed period") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">bis</span>", "anchor": "-20", "name": "end_date" });
    var user1274 = new Lino.TwinCombo({ "preferred_width": 15, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Verantwortlicher</span>", "name": "user", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.users.Users.detail)}, "hiddenName": "userHidden", "listeners": { "render": Lino.quicktip_renderer("Verantwortlicher","(cal.Guests.user) Only rows managed by this user.") }, "selectOnFocus": true, "emptyText": "Benutzer ausw\u00e4hlen...", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/Guests/user", "method": "GET" }) }) });
    var event_state1275 = new Lino.ChoicesFieldElement({ "forceSelection": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Zustand Termin</span>", "name": "event_state", "hiddenName": "event_stateHidden", "listeners": { "render": Lino.quicktip_renderer("Zustand Termin","(cal.Guests.event_state) Only rows having this event state.") }, "selectOnFocus": true, "anchor": "-20", "store": [['','<br>']].concat(Lino.cal.EventStates) });
    var guest_state1276 = new Lino.ChoicesFieldElement({ "forceSelection": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Zustand Gast</span>", "name": "guest_state", "hiddenName": "guest_stateHidden", "listeners": { "render": Lino.quicktip_renderer("Zustand Gast","(cal.Guests.guest_state) Only rows having this guest state.") }, "selectOnFocus": true, "anchor": "-20", "store": [['','<br>']].concat(Lino.cal.GuestStates) });
    var main_1_panel1277 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 13, "autoHeight": true, "layout": "form", "xtype": "panel", "items": start_date1272, "labelAlign": "top" }, { "flex": 13, "autoHeight": true, "layout": "form", "xtype": "panel", "items": end_date1273, "labelAlign": "top" }, { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": user1274, "labelAlign": "top" }, { "flex": 21, "autoHeight": true, "layout": "form", "xtype": "panel", "items": event_state1275, "labelAlign": "top" }, { "flex": 18, "autoHeight": true, "layout": "form", "xtype": "panel", "items": guest_state1276, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 153, "border": false, "anchor": "-20", "labelAlign": "top" });
    var project1283 = new Lino.TwinCombo({ "preferred_width": 20, "fieldLabel": "Klient", "name": "project", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.pcsw.Clients.detail)}, "hiddenName": "projectHidden", "listeners": { "render": Lino.quicktip_renderer("Klient","(cal.Guests.project) ") }, "selectOnFocus": true, "emptyText": "Klient ausw\u00e4hlen...", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/Guests/project", "method": "GET" }) }) });
    var partner1284 = new Lino.TwinCombo({ "preferred_width": 20, "fieldLabel": "Partner", "name": "partner", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.contacts.Partners.detail)}, "hiddenName": "partnerHidden", "listeners": { "render": Lino.quicktip_renderer("Partner","(cal.Guests.partner) ") }, "selectOnFocus": true, "emptyText": "Partner ausw\u00e4hlen...", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/Guests/partner", "method": "GET" }) }) });
    var main_2_panel1285 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": project1283, "labelAlign": "top" }, { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": partner1284, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 72, "border": false, "anchor": "-20", "labelAlign": "top" });
    this.items = [ main_1_panel1277, main_2_panel1285 ];
    this.fields = [ start_date1272, end_date1273, user1274, event_state1275, guest_state1276, project1283, partner1284 ];
    Lino.cal.MyPresences.ParamsPanel.superclass.initComponent.call(this);
  }
});


Lino.cal.OneEvent.ParamsPanel = Ext.extend(Ext.form.FormPanel,{
  autoScroll: false,
  autoHeight: true,
  border: false,
  layout: "form",
  hideCheckBoxLabels: true,
  frame: true,
  bodyBorder: false,
  labelAlign: "top",
  initComponent : function() {
    var containing_panel = this;
    var start_date1210 = new Lino.DateField({ "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Periode vom","(cal.Events.start_date) Start date of observed period") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Periode vom</span>", "anchor": "-20", "name": "start_date" });
    var end_date1211 = new Lino.DateField({ "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("bis","(cal.Events.end_date) End date of observed period") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">bis</span>", "anchor": "-20", "name": "end_date" });
    var observed_event1212 = new Lino.ChoicesFieldElement({ "forceSelection": true, "fieldLabel": "Beobachtungskriterium", "name": "observed_event", "hiddenName": "observed_eventHidden", "listeners": { "render": Lino.quicktip_renderer("Beobachtungskriterium","(cal.Events.observed_event) ") }, "selectOnFocus": true, "anchor": "-20", "store": [['','<br>']].concat(Lino.cal.EventEvents) });
    var state1213 = new Lino.ChoicesFieldElement({ "forceSelection": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Zustand</span>", "name": "state", "hiddenName": "stateHidden", "listeners": { "render": Lino.quicktip_renderer("Zustand","(cal.Events.state) Only rows having this state.") }, "selectOnFocus": true, "anchor": "-20", "store": [['','<br>']].concat(Lino.cal.EventStates) });
    var main_1_panel1214 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 20, "autoHeight": true, "layout": "form", "xtype": "panel", "items": start_date1210, "labelAlign": "top" }, { "flex": 20, "autoHeight": true, "layout": "form", "xtype": "panel", "items": end_date1211, "labelAlign": "top" }, { "flex": 25, "autoHeight": true, "layout": "form", "xtype": "panel", "items": observed_event1212, "labelAlign": "top" }, { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": state1213, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 198, "border": false, "anchor": "-20", "labelAlign": "top" });
    var user1219 = new Lino.TwinCombo({ "preferred_width": 15, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Verwaltet durch</span>", "name": "user", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.users.Users.detail)}, "hiddenName": "userHidden", "listeners": { "render": Lino.quicktip_renderer("Verwaltet durch","(cal.Events.user) Only rows managed by this user.") }, "selectOnFocus": true, "emptyText": "Benutzer ausw\u00e4hlen...", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/Events/user", "method": "GET" }) }) });
    var assigned_to1220 = new Lino.TwinCombo({ "preferred_width": 15, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Zugewiesen zu</span>", "name": "assigned_to", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.users.Users.detail)}, "hiddenName": "assigned_toHidden", "listeners": { "render": Lino.quicktip_renderer("Zugewiesen zu","(cal.Events.assigned_to) Only events assigned to this user.") }, "selectOnFocus": true, "emptyText": "Benutzer ausw\u00e4hlen...", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/Events/assigned_to", "method": "GET" }) }) });
    var project1221 = new Lino.TwinCombo({ "preferred_width": 20, "fieldLabel": "Klient", "name": "project", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.pcsw.Clients.detail)}, "hiddenName": "projectHidden", "listeners": { "render": Lino.quicktip_renderer("Klient","(cal.Events.project) ") }, "selectOnFocus": true, "emptyText": "Klient ausw\u00e4hlen...", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/Events/project", "method": "GET" }) }) });
    var calendar1222 = new Lino.TwinCombo({ "fieldLabel": "Kalender", "name": "calendar", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.cal.Calendars.detail)}, "emptyText": "Kalender ausw\u00e4hlen...", "listeners": { "render": Lino.quicktip_renderer("Kalender","(cal.Events.calendar) ") }, "selectOnFocus": true, "hiddenName": "calendarHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/Events/calendar", "method": "GET" }) }) });
    var show_appointments1223 = new Lino.ChoicesFieldElement({ "forceSelection": true, "fieldLabel": "Termine", "name": "show_appointments", "hiddenName": "show_appointmentsHidden", "listeners": { "render": Lino.quicktip_renderer("Termine","(cal.Events.show_appointments) ") }, "selectOnFocus": true, "anchor": "-20", "store": [['','<br>']].concat(Lino.lino.YesNo) });
    var main_2_panel1224 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 22, "autoHeight": true, "layout": "form", "xtype": "panel", "items": user1219, "labelAlign": "top" }, { "flex": 22, "autoHeight": true, "layout": "form", "xtype": "panel", "items": assigned_to1220, "labelAlign": "top" }, { "flex": 22, "autoHeight": true, "layout": "form", "xtype": "panel", "items": project1221, "labelAlign": "top" }, { "flex": 22, "autoHeight": true, "layout": "form", "xtype": "panel", "items": calendar1222, "labelAlign": "top" }, { "flex": 8, "autoHeight": true, "layout": "form", "xtype": "panel", "items": show_appointments1223, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 144, "border": false, "anchor": "-20", "labelAlign": "top" });
    this.items = [ main_1_panel1214, main_2_panel1224 ];
    this.fields = [ start_date1210, end_date1211, observed_event1212, state1213, user1219, assigned_to1220, project1221, calendar1222, show_appointments1223 ];
    Lino.cal.OneEvent.ParamsPanel.superclass.initComponent.call(this);
  }
});


Lino.pcsw.Clients.ParamsPanel = Ext.extend(Ext.form.FormPanel,{
  autoScroll: false,
  autoHeight: true,
  border: false,
  layout: "form",
  hideCheckBoxLabels: true,
  frame: true,
  bodyBorder: false,
  labelAlign: "top",
  initComponent : function() {
    var containing_panel = this;
    var aged_from2968 = new Ext.form.NumberField({ "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Alter von","(pcsw.Clients.aged_from) Nur Klienten, die mindestens so alt sind.") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Alter von</span>", "anchor": "-20", "name": "aged_from" });
    var aged_to2969 = new Ext.form.NumberField({ "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Alter bis","(pcsw.Clients.aged_to) Nur Klienten, die h\u00f6chstens so alt sind.") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Alter bis</span>", "anchor": "-20", "name": "aged_to" });
    var gender2970 = new Lino.ChoicesFieldElement({ "forceSelection": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Geschlecht</span>", "name": "gender", "hiddenName": "genderHidden", "listeners": { "render": Lino.quicktip_renderer("Geschlecht","(pcsw.Clients.gender) Nur Personen, deren Feld \"Geschlecht\" ausgef\u00fcllt ist und dem angegebenen Wert entspricht.") }, "selectOnFocus": true, "anchor": "-20", "store": [['','<br>']].concat(Lino.lino.Genders) });
    var nationality2971 = new Lino.TwinCombo({ "fieldLabel": "Staatsangeh\u00f6rigkeit", "name": "nationality", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.countries.Countries.detail)}, "emptyText": "Land ausw\u00e4hlen...", "listeners": { "render": Lino.quicktip_renderer("Staatsangeh\u00f6rigkeit","(pcsw.Clients.nationality) ") }, "selectOnFocus": true, "hiddenName": "nationalityHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/pcsw/Clients/nationality", "method": "GET" }) }) });
    var also_obsolete2972 = new Ext.form.Checkbox({ "boxLabel": "Auch veraltete Daten", "listeners": { "render": Lino.quicktip_renderer("Auch veraltete Daten","(pcsw.Clients.also_obsolete) Auch Datens\u00e4tze anzeigen, die als veraltet markiert sind.") }, "hideLabel": true, "checked": false, "name": "also_obsolete", "selectOnFocus": true, "anchor": "-20" });
    var main_1_panel2973 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 10, "autoHeight": true, "layout": "form", "xtype": "panel", "items": aged_from2968, "labelAlign": "top" }, { "flex": 10, "autoHeight": true, "layout": "form", "xtype": "panel", "items": aged_to2969, "labelAlign": "top" }, { "flex": 18, "autoHeight": true, "layout": "form", "xtype": "panel", "items": gender2970, "labelAlign": "top" }, { "flex": 40, "autoHeight": true, "layout": "form", "xtype": "panel", "items": nationality2971, "labelAlign": "top" }, { "flex": 20, "autoHeight": true, "layout": "form", "xtype": "panel", "items": also_obsolete2972, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 189, "border": false, "anchor": "-20", "labelAlign": "top" });
    var client_state2979 = new Lino.ChoicesFieldElement({ "forceSelection": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Zustand</span>", "name": "client_state", "hiddenName": "client_stateHidden", "listeners": { "render": Lino.quicktip_renderer("Zustand","(pcsw.Clients.client_state) Nur Klienten mit diesem Status (Aktenzustand).") }, "selectOnFocus": true, "anchor": "-20", "store": [['','<br>']].concat(Lino.pcsw.ClientStates) });
    var coached_by2980 = new Lino.TwinCombo({ "preferred_width": 15, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Begleitet durch</span>", "name": "coached_by", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.users.Users.detail)}, "hiddenName": "coached_byHidden", "listeners": { "render": Lino.quicktip_renderer("Begleitet durch","(pcsw.Clients.coached_by) Nur Klienten, die eine Begleitung mit diesem Benutzer haben.") }, "selectOnFocus": true, "emptyText": "Benutzer ausw\u00e4hlen...", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/pcsw/Clients/coached_by", "method": "GET" }) }) });
    var and_coached_by2981 = new Lino.TwinCombo({ "preferred_width": 15, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">und durch</span>", "name": "and_coached_by", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.users.Users.detail)}, "hiddenName": "and_coached_byHidden", "listeners": { "render": Lino.quicktip_renderer("und durch","(pcsw.Clients.and_coached_by) Nur Klienten, die auch mit diesem Benutzer eine Begleitung haben.") }, "selectOnFocus": true, "emptyText": "Benutzer ausw\u00e4hlen...", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/pcsw/Clients/and_coached_by", "method": "GET" }) }) });
    var start_date2982 = new Lino.DateField({ "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Periode vom","(pcsw.Clients.start_date) Start date of observed period") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Periode vom</span>", "anchor": "-20", "name": "start_date" });
    var end_date2983 = new Lino.DateField({ "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("bis","(pcsw.Clients.end_date) End date of observed period") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">bis</span>", "anchor": "-20", "name": "end_date" });
    var observed_event2984 = new Lino.ChoicesFieldElement({ "forceSelection": true, "fieldLabel": "Beobachtungskriterium", "name": "observed_event", "hiddenName": "observed_eventHidden", "listeners": { "render": Lino.quicktip_renderer("Beobachtungskriterium","(pcsw.Clients.observed_event) ") }, "selectOnFocus": true, "anchor": "-20", "store": [['','<br>']].concat(Lino.pcsw.ClientEvents) });
    var only_primary2985 = new Ext.form.Checkbox({ "boxLabel": "Nur prim\u00e4re Begleitungen", "listeners": { "render": Lino.quicktip_renderer("Nur prim\u00e4re Begleitungen","(pcsw.Clients.only_primary) Nur Klienten, die eine effektive <b>prim\u00e4re</b> Begleitung haben.") }, "hideLabel": true, "checked": false, "name": "only_primary", "selectOnFocus": true, "anchor": "-20" });
    var main_2_panel2986 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 11, "autoHeight": true, "layout": "form", "xtype": "panel", "items": client_state2979, "labelAlign": "top" }, { "flex": 20, "autoHeight": true, "layout": "form", "xtype": "panel", "items": coached_by2980, "labelAlign": "top" }, { "flex": 20, "autoHeight": true, "layout": "form", "xtype": "panel", "items": and_coached_by2981, "labelAlign": "top" }, { "flex": 8, "autoHeight": true, "layout": "form", "xtype": "panel", "items": start_date2982, "labelAlign": "top" }, { "flex": 8, "autoHeight": true, "layout": "form", "xtype": "panel", "items": end_date2983, "labelAlign": "top" }, { "flex": 20, "autoHeight": true, "layout": "form", "xtype": "panel", "items": observed_event2984, "labelAlign": "top" }, { "flex": 10, "autoHeight": true, "layout": "form", "xtype": "panel", "items": only_primary2985, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 225, "border": false, "anchor": "-20", "labelAlign": "top" });
    this.items = [ main_1_panel2973, main_2_panel2986 ];
    this.fields = [ aged_from2968, aged_to2969, gender2970, nationality2971, also_obsolete2972, client_state2979, coached_by2980, and_coached_by2981, start_date2982, end_date2983, observed_event2984, only_primary2985 ];
    Lino.pcsw.Clients.ParamsPanel.superclass.initComponent.call(this);
  }
});


Lino.contacts.Persons.ParamsPanel = Ext.extend(Ext.form.FormPanel,{
  autoScroll: false,
  border: false,
  layout: "fit",
  hideCheckBoxLabels: true,
  frame: true,
  bodyBorder: false,
  labelAlign: "top",
  initComponent : function() {
    var containing_panel = this;
    var gender1126 = new Lino.ChoicesFieldElement({ "forceSelection": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Geschlecht</span>", "name": "gender", "hiddenName": "genderHidden", "listeners": { "render": Lino.quicktip_renderer("Geschlecht","(contacts.Persons.gender) Nur Personen, deren Feld \"Geschlecht\" ausgef\u00fcllt ist und dem angegebenen Wert entspricht.") }, "selectOnFocus": true, "anchor": "-20", "store": [['','<br>']].concat(Lino.lino.Genders) });
    var also_obsolete1127 = new Ext.form.Checkbox({ "boxLabel": "Auch veraltete Daten", "listeners": { "render": Lino.quicktip_renderer("Auch veraltete Daten","(contacts.Persons.also_obsolete) Auch Datens\u00e4tze anzeigen, die als veraltet markiert sind.") }, "hideLabel": true, "checked": false, "name": "also_obsolete", "selectOnFocus": true, "anchor": "-20" });
    var main_1_panel1128 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 189, "hideCheckBoxLabels": true, "items": [ { "flex": 47, "autoHeight": true, "layout": "form", "xtype": "panel", "items": gender1126, "labelAlign": "top" }, { "flex": 52, "autoHeight": true, "layout": "form", "xtype": "panel", "items": also_obsolete1127, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    this.items = [ main_1_panel1128 ];
    this.fields = [ gender1126, also_obsolete1127 ];
    Lino.contacts.Persons.ParamsPanel.superclass.initComponent.call(this);
  }
});


Lino.cal.MyTasks.ParamsPanel = Ext.extend(Ext.form.FormPanel,{
  autoScroll: false,
  border: false,
  layout: "fit",
  hideCheckBoxLabels: true,
  frame: true,
  bodyBorder: false,
  labelAlign: "top",
  initComponent : function() {
    var containing_panel = this;
    var start_date308 = new Lino.DateField({ "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Periode vom","(cal.Tasks.start_date) Start date of observed period") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Periode vom</span>", "anchor": "-20", "name": "start_date" });
    var end_date309 = new Lino.DateField({ "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("bis","(cal.Tasks.end_date) End date of observed period") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">bis</span>", "anchor": "-20", "name": "end_date" });
    var user310 = new Lino.TwinCombo({ "preferred_width": 15, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Verwaltet durch</span>", "name": "user", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.users.Users.detail)}, "hiddenName": "userHidden", "listeners": { "render": Lino.quicktip_renderer("Verwaltet durch","(cal.Tasks.user) Only rows managed by this user.") }, "selectOnFocus": true, "emptyText": "Benutzer ausw\u00e4hlen...", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/Tasks/user", "method": "GET" }) }) });
    var state311 = new Lino.ChoicesFieldElement({ "forceSelection": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Zustand</span>", "name": "state", "hiddenName": "stateHidden", "listeners": { "render": Lino.quicktip_renderer("Zustand","(cal.Tasks.state) Only rows having this state.") }, "selectOnFocus": true, "anchor": "-20", "store": [['','<br>']].concat(Lino.cal.TaskStates) });
    var project312 = new Lino.TwinCombo({ "preferred_width": 20, "fieldLabel": "Klient", "name": "project", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.pcsw.Clients.detail)}, "hiddenName": "projectHidden", "listeners": { "render": Lino.quicktip_renderer("Klient","(cal.Tasks.project) ") }, "selectOnFocus": true, "emptyText": "Klient ausw\u00e4hlen...", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/Tasks/project", "method": "GET" }) }) });
    var main_1_panel313 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 144, "hideCheckBoxLabels": true, "items": [ { "flex": 11, "autoHeight": true, "layout": "form", "xtype": "panel", "items": start_date308, "labelAlign": "top" }, { "flex": 11, "autoHeight": true, "layout": "form", "xtype": "panel", "items": end_date309, "labelAlign": "top" }, { "flex": 29, "autoHeight": true, "layout": "form", "xtype": "panel", "items": user310, "labelAlign": "top" }, { "flex": 17, "autoHeight": true, "layout": "form", "xtype": "panel", "items": state311, "labelAlign": "top" }, { "flex": 29, "autoHeight": true, "layout": "form", "xtype": "panel", "items": project312, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    this.items = [ main_1_panel313 ];
    this.fields = [ start_date308, end_date309, user310, state311, project312 ];
    Lino.cal.MyTasks.ParamsPanel.superclass.initComponent.call(this);
  }
});


Lino.pcsw.CoachingsByClient.ParamsPanel = Ext.extend(Ext.form.FormPanel,{
  autoScroll: false,
  autoHeight: true,
  border: false,
  layout: "form",
  hideCheckBoxLabels: true,
  frame: true,
  bodyBorder: false,
  labelAlign: "top",
  initComponent : function() {
    var containing_panel = this;
    var start_date377 = new Lino.DateField({ "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Periode vom","(pcsw.Coachings.start_date) Start date of observed period") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Periode vom</span>", "anchor": "-20", "name": "start_date" });
    var end_date378 = new Lino.DateField({ "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("bis","(pcsw.Coachings.end_date) End date of observed period") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">bis</span>", "anchor": "-20", "name": "end_date" });
    var observed_event379 = new Lino.ChoicesFieldElement({ "forceSelection": true, "fieldLabel": "Beobachtungskriterium", "name": "observed_event", "hiddenName": "observed_eventHidden", "listeners": { "render": Lino.quicktip_renderer("Beobachtungskriterium","(pcsw.Coachings.observed_event) ") }, "selectOnFocus": true, "anchor": "-20", "store": [['','<br>']].concat(Lino.pcsw.CoachingEvents) });
    var coached_by380 = new Lino.TwinCombo({ "preferred_width": 15, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Begleitet durch</span>", "name": "coached_by", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.users.Users.detail)}, "hiddenName": "coached_byHidden", "listeners": { "render": Lino.quicktip_renderer("Begleitet durch","(pcsw.Coachings.coached_by) Nur Begleitungen dieses Benutzers.") }, "selectOnFocus": true, "emptyText": "Benutzer ausw\u00e4hlen...", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/pcsw/Coachings/coached_by", "method": "GET" }) }) });
    var and_coached_by381 = new Lino.TwinCombo({ "preferred_width": 15, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">und durch</span>", "name": "and_coached_by", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.users.Users.detail)}, "hiddenName": "and_coached_byHidden", "listeners": { "render": Lino.quicktip_renderer("und durch","(pcsw.Coachings.and_coached_by) ... und auch Begleitungen dieses Benutzers.") }, "selectOnFocus": true, "emptyText": "Benutzer ausw\u00e4hlen...", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/pcsw/Coachings/and_coached_by", "method": "GET" }) }) });
    var main_1_panel382 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 12, "autoHeight": true, "layout": "form", "xtype": "panel", "items": start_date377, "labelAlign": "top" }, { "flex": 12, "autoHeight": true, "layout": "form", "xtype": "panel", "items": end_date378, "labelAlign": "top" }, { "flex": 15, "autoHeight": true, "layout": "form", "xtype": "panel", "items": observed_event379, "labelAlign": "top" }, { "flex": 30, "autoHeight": true, "layout": "form", "xtype": "panel", "items": coached_by380, "labelAlign": "top" }, { "flex": 30, "autoHeight": true, "layout": "form", "xtype": "panel", "items": and_coached_by381, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 198, "border": false, "anchor": "-20", "labelAlign": "top" });
    var primary_coachings388 = new Lino.ChoicesFieldElement({ "forceSelection": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Prim\u00e4re Begleitungen</span>", "name": "primary_coachings", "hiddenName": "primary_coachingsHidden", "listeners": { "render": Lino.quicktip_renderer("Prim\u00e4re Begleitungen","(pcsw.Coachings.primary_coachings) Accompagnements primaires.") }, "selectOnFocus": true, "anchor": "-20", "store": [['','<br>']].concat(Lino.lino.YesNo) });
    var coaching_type389 = new Lino.RemoteComboFieldElement({ "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Dienst</span>", "name": "coaching_type", "pageSize": 20, "emptyText": "Dienst ausw\u00e4hlen...", "listeners": { "render": Lino.quicktip_renderer("Dienst","(pcsw.Coachings.coaching_type) Nur Begleitungen dieses Dienstes.") }, "selectOnFocus": true, "hiddenName": "coaching_typeHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/pcsw/Coachings/coaching_type", "method": "GET" }) }) });
    var ending390 = new Lino.TwinCombo({ "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Beendigungsgrund</span>", "name": "ending", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.pcsw.CoachingEndings.detail)}, "emptyText": "Beendigungsgrund ausw\u00e4hlen...", "listeners": { "render": Lino.quicktip_renderer("Beendigungsgrund","(pcsw.Coachings.ending) Nur Begleitungen mit diesem Beendigungsgrund.") }, "selectOnFocus": true, "hiddenName": "endingHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/pcsw/Coachings/ending", "method": "GET" }) }) });
    var main_2_panel391 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 14, "autoHeight": true, "layout": "form", "xtype": "panel", "items": primary_coachings388, "labelAlign": "top" }, { "flex": 42, "autoHeight": true, "layout": "form", "xtype": "panel", "items": coaching_type389, "labelAlign": "top" }, { "flex": 42, "autoHeight": true, "layout": "form", "xtype": "panel", "items": ending390, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 189, "border": false, "anchor": "-20", "labelAlign": "top" });
    this.items = [ main_1_panel382, main_2_panel391 ];
    this.fields = [ start_date377, end_date378, observed_event379, coached_by380, and_coached_by381, primary_coachings388, coaching_type389, ending390 ];
    Lino.pcsw.CoachingsByClient.ParamsPanel.superclass.initComponent.call(this);
  }
});


Lino.newcomers.AvailableCoaches.ParamsPanel = Ext.extend(Ext.form.FormPanel,{
  autoHeight: true,
  layout: "hbox",
  frame: true,
  layoutConfig: { "align": "stretchmax" },
  hideCheckBoxLabels: true,
  autoScroll: false,
  labelWidth: 189,
  border: false,
  bodyBorder: false,
  labelAlign: "top",
  initComponent : function() {
    var containing_panel = this;
    var for_client2665 = new Lino.TwinCombo({ "preferred_width": 20, "fieldLabel": "Zeige Vorschl\u00e4ge f\u00fcr", "name": "for_client", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.pcsw.Clients.detail)}, "hiddenName": "for_clientHidden", "listeners": { "render": Lino.quicktip_renderer("Zeige Vorschl\u00e4ge f\u00fcr","(newcomers.AvailableCoaches.for_client) ") }, "selectOnFocus": true, "emptyText": "Klient ausw\u00e4hlen...", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/newcomers/AvailableCoaches/for_client", "method": "GET" }) }) });
    var since2666 = new Lino.DateField({ "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Neue Klienten seit","(newcomers.AvailableCoaches.since) Neue Klienten sind die, deren Begleitung nach diesem Datum beginnt") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Neue Klienten seit</span>", "anchor": "-20", "name": "since" });
    this.items = [ { "flex": 71, "autoHeight": true, "layout": "form", "xtype": "panel", "items": for_client2665, "labelAlign": "top" }, { "flex": 28, "autoHeight": true, "layout": "form", "xtype": "panel", "items": since2666, "labelAlign": "top" } ];
    this.fields = [ for_client2665, since2666 ];
    Lino.newcomers.AvailableCoaches.ParamsPanel.superclass.initComponent.call(this);
  }
});


Lino.cal.MyPresences.wf1_ActionFormPanel = Ext.extend(Lino.ActionFormPanel,{
  autoScroll: false,
  border: false,
  layout: "vbox",
  labelWidth: 270,
  hideCheckBoxLabels: true,
  frame: true,
  layoutConfig: { "align": "stretch" },
  bodyBorder: false,
  labelAlign: "top",
  action_name: 'wf1',
  ls_url: "/cal/MyPresences",
  window_title: "Zusagen",
  initComponent : function() {
    var containing_panel = this;
    var notify_subject6 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Summary","(<AcceptInvitation wf1 (u'Accept')>.notify_subject) ") }, "fieldLabel": "Kurzbeschreibung", "name": "notify_subject", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var notify_body7 = new Ext.form.TextArea({ "listeners": { "render": Lino.quicktip_renderer("Description","(<AcceptInvitation wf1 (u'Accept')>.notify_body) ") }, "fieldLabel": "Beschreibung", "name": "notify_body", "growMax": 2000, "selectOnFocus": true, "anchor": "-20 -10" });
    var notify_silent8 = new Ext.form.Checkbox({ "boxLabel": "Keine Benachrichtigung per E-Mail schicken", "listeners": { "render": Lino.quicktip_renderer("Don't send email notification","(<AcceptInvitation wf1 (u'Accept')>.notify_silent) ") }, "hideLabel": true, "checked": false, "name": "notify_silent", "selectOnFocus": true, "anchor": "-20" });
    this.items = [ { "items": notify_subject6, "autoHeight": true, "layout": "form", "xtype": "panel", "labelAlign": "top" }, { "items": notify_body7, "labelAlign": "top", "layout": "form", "xtype": "panel", "flex": 71 }, { "items": notify_silent8, "autoHeight": true, "layout": "form", "xtype": "panel", "labelAlign": "top" } ];
    this.fields = [ notify_subject6, notify_body7, notify_silent8 ];
    Lino.cal.MyPresences.wf1_ActionFormPanel.superclass.initComponent.call(this);
  }
});


Lino.newcomers.AvailableCoachesByClient.assign_coach_ActionFormPanel = Ext.extend(Lino.ActionFormPanel,{
  autoScroll: false,
  border: false,
  layout: "vbox",
  labelWidth: 270,
  hideCheckBoxLabels: true,
  frame: true,
  layoutConfig: { "align": "stretch" },
  bodyBorder: false,
  labelAlign: "top",
  action_name: 'assign_coach',
  ls_url: "/newcomers/AvailableCoachesByClient",
  window_title: "Zuweisen",
  initComponent : function() {
    var containing_panel = this;
    var notify_subject58 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Summary","(<AssignCoach assign_coach (u'Assign')>.notify_subject) ") }, "fieldLabel": "Kurzbeschreibung", "name": "notify_subject", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var notify_body59 = new Ext.form.TextArea({ "listeners": { "render": Lino.quicktip_renderer("Description","(<AssignCoach assign_coach (u'Assign')>.notify_body) ") }, "fieldLabel": "Beschreibung", "name": "notify_body", "growMax": 2000, "selectOnFocus": true, "anchor": "-20 -10" });
    var notify_silent60 = new Ext.form.Checkbox({ "boxLabel": "Keine Benachrichtigung per E-Mail schicken", "listeners": { "render": Lino.quicktip_renderer("Don't send email notification","(<AssignCoach assign_coach (u'Assign')>.notify_silent) ") }, "hideLabel": true, "checked": false, "name": "notify_silent", "selectOnFocus": true, "anchor": "-20" });
    this.items = [ { "items": notify_subject58, "autoHeight": true, "layout": "form", "xtype": "panel", "labelAlign": "top" }, { "items": notify_body59, "labelAlign": "top", "layout": "form", "xtype": "panel", "flex": 71 }, { "items": notify_silent60, "autoHeight": true, "layout": "form", "xtype": "panel", "labelAlign": "top" } ];
    this.fields = [ notify_subject58, notify_body59, notify_silent60 ];
    Lino.newcomers.AvailableCoachesByClient.assign_coach_ActionFormPanel.superclass.initComponent.call(this);
  }
});


Lino.pcsw.CoachingsByClient.create_visit_ActionFormPanel = Ext.extend(Lino.ActionFormPanel,{
  autoScroll: false,
  autoHeight: true,
  border: false,
  layout: "form",
  labelWidth: 63,
  hideCheckBoxLabels: true,
  frame: true,
  bodyBorder: false,
  labelAlign: "top",
  action_name: 'create_visit',
  ls_url: "/pcsw/CoachingsByClient",
  window_title: "Create visit",
  autoHeight: true,
  initComponent : function() {
    var containing_panel = this;
    var user48 = new Lino.TwinCombo({ "preferred_width": 15, "fieldLabel": "Benutzer", "allowBlank": false, "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.users.Users.detail)}, "emptyText": "Benutzer ausw\u00e4hlen...", "listeners": { "render": Lino.quicktip_renderer("User","(<CreateCoachingVisit create_visit (u'Create visit')>.user) ") }, "selectOnFocus": true, "hiddenName": "userHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/apchoices/pcsw/Coachings/create_visit/user", "method": "GET" }) }), "name": "user" });
    var summary49 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Reason","(<CreateCoachingVisit create_visit (u'Create visit')>.summary) ") }, "fieldLabel": "Begr\u00fcndung", "name": "summary", "maxLength": null, "selectOnFocus": true, "anchor": "-20" });
    this.items = [ { "autoHeight": true, "layout": "form", "xtype": "panel", "items": user48, "anchor": "-20", "labelAlign": "top" }, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": summary49, "anchor": "-20", "labelAlign": "top" } ];
    this.fields = [ user48, summary49 ];
    Lino.pcsw.CoachingsByClient.create_visit_ActionFormPanel.superclass.initComponent.call(this);
  }
});


Lino.cal.MyPresences.wf2_ActionFormPanel = Ext.extend(Lino.ActionFormPanel,{
  autoScroll: false,
  border: false,
  layout: "vbox",
  labelWidth: 270,
  hideCheckBoxLabels: true,
  frame: true,
  layoutConfig: { "align": "stretch" },
  bodyBorder: false,
  labelAlign: "top",
  action_name: 'wf2',
  ls_url: "/cal/MyPresences",
  window_title: "Absagen",
  initComponent : function() {
    var containing_panel = this;
    var notify_subject13 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Summary","(<RejectInvitation wf2 (u'Reject')>.notify_subject) ") }, "fieldLabel": "Kurzbeschreibung", "name": "notify_subject", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var notify_body14 = new Ext.form.TextArea({ "listeners": { "render": Lino.quicktip_renderer("Description","(<RejectInvitation wf2 (u'Reject')>.notify_body) ") }, "fieldLabel": "Beschreibung", "name": "notify_body", "growMax": 2000, "selectOnFocus": true, "anchor": "-20 -10" });
    var notify_silent15 = new Ext.form.Checkbox({ "boxLabel": "Keine Benachrichtigung per E-Mail schicken", "listeners": { "render": Lino.quicktip_renderer("Don't send email notification","(<RejectInvitation wf2 (u'Reject')>.notify_silent) ") }, "hideLabel": true, "checked": false, "name": "notify_silent", "selectOnFocus": true, "anchor": "-20" });
    this.items = [ { "items": notify_subject13, "autoHeight": true, "layout": "form", "xtype": "panel", "labelAlign": "top" }, { "items": notify_body14, "labelAlign": "top", "layout": "form", "xtype": "panel", "flex": 71 }, { "items": notify_silent15, "autoHeight": true, "layout": "form", "xtype": "panel", "labelAlign": "top" } ];
    this.fields = [ notify_subject13, notify_body14, notify_silent15 ];
    Lino.cal.MyPresences.wf2_ActionFormPanel.superclass.initComponent.call(this);
  }
});


Lino.pcsw.Clients.wf2_ActionFormPanel = Ext.extend(Lino.ActionFormPanel,{
  autoScroll: false,
  border: false,
  layout: "vbox",
  labelWidth: 63,
  hideCheckBoxLabels: true,
  frame: true,
  layoutConfig: { "align": "stretch" },
  bodyBorder: false,
  labelAlign: "top",
  action_name: 'wf2',
  ls_url: "/pcsw/Clients",
  window_title: "Ablehnen",
  initComponent : function() {
    var containing_panel = this;
    var reason27 = new Lino.ChoicesFieldElement({ "forceSelection": true, "fieldLabel": "reason", "allowBlank": false, "hiddenName": "reasonHidden", "listeners": { "render": Lino.quicktip_renderer("reason","(<RefuseClient wf2 (u'Refuse')>.reason) ") }, "selectOnFocus": true, "anchor": "-20", "store": Lino.pcsw.RefusalReasons, "name": "reason" });
    var remark28 = new Ext.form.TextArea({ "listeners": { "render": Lino.quicktip_renderer("Remark","(<RefuseClient wf2 (u'Refuse')>.remark) ") }, "fieldLabel": "Bemerkung", "name": "remark", "growMax": 2000, "selectOnFocus": true, "anchor": "-20 -10" });
    this.items = [ { "items": reason27, "autoHeight": true, "layout": "form", "xtype": "panel", "labelAlign": "top" }, { "items": remark28, "labelAlign": "top", "layout": "form", "xtype": "panel", "flex": 83 } ];
    this.fields = [ reason27, remark28 ];
    Lino.pcsw.Clients.wf2_ActionFormPanel.superclass.initComponent.call(this);
  }
});


Lino.pcsw.Clients.merge_row_ActionFormPanel = Ext.extend(Lino.ActionFormPanel,{
  autoScroll: false,
  autoHeight: true,
  border: false,
  layout: "form",
  labelWidth: 72,
  hideCheckBoxLabels: true,
  frame: true,
  bodyBorder: false,
  labelAlign: "top",
  action_name: 'merge_row',
  ls_url: "/pcsw/Clients",
  window_title: "Merge",
  autoHeight: true,
  initComponent : function() {
    var containing_panel = this;
    var merge_to32 = new Lino.TwinCombo({ "preferred_width": 20, "fieldLabel": "into...", "allowBlank": false, "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.pcsw.Clients.detail)}, "emptyText": "Klient ausw\u00e4hlen...", "listeners": { "render": Lino.quicktip_renderer("into...","(<MergeAction merge_row (u'Merge')>.merge_to) ") }, "selectOnFocus": true, "hiddenName": "merge_toHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/apchoices/pcsw/Clients/merge_row/merge_to", "method": "GET" }) }), "name": "merge_to" });
    var pcsw_Dispense33 = new Ext.form.Checkbox({ "boxLabel": "Dispenzen", "listeners": { "render": Lino.quicktip_renderer("Dispenses","(<MergeAction merge_row (u'Merge')>.pcsw_Dispense) ") }, "hideLabel": true, "checked": false, "name": "pcsw_Dispense", "selectOnFocus": true, "anchor": "-20" });
    var pcsw_Coaching34 = new Ext.form.Checkbox({ "boxLabel": "Begleitungen", "listeners": { "render": Lino.quicktip_renderer("Coachings","(<MergeAction merge_row (u'Merge')>.pcsw_Coaching) ") }, "hideLabel": true, "checked": false, "name": "pcsw_Coaching", "selectOnFocus": true, "anchor": "-20" });
    var keep_volatiles_1_panel35 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": pcsw_Dispense33, "labelAlign": "top" }, { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": pcsw_Coaching34, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 90, "border": false, "anchor": "-20", "labelAlign": "top" });
    var cv_LanguageKnowledge38 = new Ext.form.Checkbox({ "boxLabel": "Sprachkenntnisse", "listeners": { "render": Lino.quicktip_renderer("language knowledges","(<MergeAction merge_row (u'Merge')>.cv_LanguageKnowledge) ") }, "hideLabel": true, "checked": false, "name": "cv_LanguageKnowledge", "selectOnFocus": true, "anchor": "-20" });
    var properties_PersonProperty39 = new Ext.form.Checkbox({ "boxLabel": "Eigenschaften", "listeners": { "render": Lino.quicktip_renderer("Properties","(<MergeAction merge_row (u'Merge')>.properties_PersonProperty) ") }, "hideLabel": true, "checked": false, "name": "properties_PersonProperty", "selectOnFocus": true, "anchor": "-20" });
    var keep_volatiles_2_panel40 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": cv_LanguageKnowledge38, "labelAlign": "top" }, { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": properties_PersonProperty39, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 180, "border": false, "anchor": "-20", "labelAlign": "top" });
    var keep_volatiles_panel43 = new Ext.form.FieldSet({ "autoHeight": true, "layout": "form", "title": "Also reassign volatile related objects", "items": [ keep_volatiles_1_panel35, keep_volatiles_2_panel40 ], "frame": true, "bodyBorder": false, "autoScroll": false, "hideCheckBoxLabels": true, "border": false, "anchor": "-20", "labelAlign": "top" });
    var reason44 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Reason","(<MergeAction merge_row (u'Merge')>.reason) ") }, "fieldLabel": "Reason", "name": "reason", "maxLength": 100, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    this.items = [ { "autoHeight": true, "layout": "form", "xtype": "panel", "items": merge_to32, "anchor": "-20", "labelAlign": "top" }, keep_volatiles_panel43, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": reason44, "anchor": "-20", "labelAlign": "top" } ];
    this.fields = [ merge_to32, pcsw_Dispense33, pcsw_Coaching34, cv_LanguageKnowledge38, properties_PersonProperty39, reason44 ];
    Lino.pcsw.Clients.merge_row_ActionFormPanel.superclass.initComponent.call(this);
  }
});


Lino.contacts.Companies.merge_row_ActionFormPanel = Ext.extend(Lino.ActionFormPanel,{
  autoScroll: false,
  autoHeight: true,
  border: false,
  layout: "form",
  labelWidth: 72,
  hideCheckBoxLabels: true,
  frame: true,
  bodyBorder: false,
  labelAlign: "top",
  action_name: 'merge_row',
  ls_url: "/contacts/Companies",
  window_title: "Merge",
  autoHeight: true,
  initComponent : function() {
    var containing_panel = this;
    var merge_to1 = new Lino.TwinCombo({ "preferred_width": 20, "fieldLabel": "into...", "allowBlank": false, "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.contacts.Companies.detail)}, "emptyText": "Organisation ausw\u00e4hlen...", "listeners": { "render": Lino.quicktip_renderer("into...","(<MergeAction merge_row (u'Merge')>.merge_to) ") }, "selectOnFocus": true, "hiddenName": "merge_toHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/apchoices/contacts/Companies/merge_row/merge_to", "method": "GET" }) }), "name": "merge_to" });
    var reason2 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Reason","(<MergeAction merge_row (u'Merge')>.reason) ") }, "fieldLabel": "Reason", "name": "reason", "maxLength": 100, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    this.items = [ { "autoHeight": true, "layout": "form", "xtype": "panel", "items": merge_to1, "anchor": "-20", "labelAlign": "top" }, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": reason2, "anchor": "-20", "labelAlign": "top" } ];
    this.fields = [ merge_to1, reason2 ];
    Lino.contacts.Companies.merge_row_ActionFormPanel.superclass.initComponent.call(this);
  }
});


Lino.cal.MyPresences.checkin_ActionFormPanel = Ext.extend(Lino.ActionFormPanel,{
  autoScroll: false,
  border: false,
  layout: "vbox",
  labelWidth: 270,
  hideCheckBoxLabels: true,
  frame: true,
  layoutConfig: { "align": "stretch" },
  bodyBorder: false,
  labelAlign: "top",
  action_name: 'checkin',
  ls_url: "/cal/MyPresences",
  window_title: "Einchecken",
  initComponent : function() {
    var containing_panel = this;
    var notify_subject20 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Summary","(<CheckinGuest checkin (u'Checkin')>.notify_subject) ") }, "fieldLabel": "Kurzbeschreibung", "name": "notify_subject", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var notify_body21 = new Ext.form.TextArea({ "listeners": { "render": Lino.quicktip_renderer("Description","(<CheckinGuest checkin (u'Checkin')>.notify_body) ") }, "fieldLabel": "Beschreibung", "name": "notify_body", "growMax": 2000, "selectOnFocus": true, "anchor": "-20 -10" });
    var notify_silent22 = new Ext.form.Checkbox({ "boxLabel": "Keine Benachrichtigung per E-Mail schicken", "listeners": { "render": Lino.quicktip_renderer("Don't send email notification","(<CheckinGuest checkin (u'Checkin')>.notify_silent) ") }, "hideLabel": true, "checked": false, "name": "notify_silent", "selectOnFocus": true, "anchor": "-20" });
    this.items = [ { "items": notify_subject20, "autoHeight": true, "layout": "form", "xtype": "panel", "labelAlign": "top" }, { "items": notify_body21, "labelAlign": "top", "layout": "form", "xtype": "panel", "flex": 71 }, { "items": notify_silent22, "autoHeight": true, "layout": "form", "xtype": "panel", "labelAlign": "top" } ];
    this.fields = [ notify_subject20, notify_body21, notify_silent22 ];
    Lino.cal.MyPresences.checkin_ActionFormPanel.superclass.initComponent.call(this);
  }
});


Lino.outbox.MyOutbox.InsertFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 26,
  initComponent : function() {
    var containing_panel = this;
    var project982 = new Lino.TwinCombo({ "preferred_width": 20, "fieldLabel": "Klient", "name": "project", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.pcsw.Clients.detail)}, "hiddenName": "projectHidden", "listeners": { "render": Lino.quicktip_renderer("Klient","(outbox.Mails.project) ") }, "selectOnFocus": true, "emptyText": "Klient ausw\u00e4hlen...", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/outbox/Mails/project", "method": "GET" }) }) });
    var subject983 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Betreff","(outbox.Mails.subject) ") }, "fieldLabel": "Betreff", "name": "subject", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var body984 = new Lino.RichTextPanel({ "selectOnFocus": true, "flex": 71, "containing_panel": this, "name": "body", "title": "Inhalt" });
    var main_panel985 = new Ext.Panel({ "autoScroll": false, "border": false, "layout": "vbox", "labelWidth": 72, "hideCheckBoxLabels": true, "items": [ { "items": project982, "autoHeight": true, "layout": "form", "xtype": "panel", "labelAlign": "top" }, { "items": subject983, "autoHeight": true, "layout": "form", "xtype": "panel", "labelAlign": "top" }, body984 ], "frame": true, "layoutConfig": { "align": "stretch" }, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel985;
    this.before_row_edit = function(record) {
      body984.refresh();
    }
    Lino.outbox.MyOutbox.InsertFormPanel.superclass.initComponent.call(this);
  }
});


Lino.lino.Report.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  disable_editing: true,
  initComponent : function() {
    var containing_panel = this;
    var body_htmlbox3715 = new Lino.HtmlBoxPanel({ "layout": "fit", "name": "body", "containing_panel": this, "master_panel": this, "items": new Ext.BoxComponent({autoScroll:true}), "bodyStyle": "overflow-x:hidden;", "value": "<br/>", "always_enabled": true, "listeners": { "render": Lino.quicktip_renderer(null,"(lino.Report.body) ") } });
    var main_panel3716 = new Ext.Panel({ "autoScroll": false, "border": false, "layout": "fit", "labelWidth": 0, "hideCheckBoxLabels": true, "items": [ body_htmlbox3715 ], "frame": true, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel3716;
    this.before_row_edit = function(record) {
      body_htmlbox3715.refresh();
    }
    Lino.lino.Report.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.contacts.Companies.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 19,
  initComponent : function() {
    var containing_panel = this;
    var prefix825 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("prefix","(contacts.Companies.prefix) ") }, "fieldLabel": "prefix", "name": "prefix", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var name826 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Name","(contacts.Companies.name) ") }, "fieldLabel": "Name", "name": "name", "maxLength": 200, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var id827 = new Ext.form.NumberField({ "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("ID","(contacts.Companies.id) ") }, "fieldLabel": "ID", "anchor": "-20", "name": "id" });
    var language828 = new Lino.ChoicesFieldElement({ "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Sprache</span>", "allowBlank": false, "hiddenName": "languageHidden", "listeners": { "render": Lino.quicktip_renderer("Sprache","(contacts.Companies.language) Die Sprache, in der Dokumente ausgestellt werden sollen.") }, "selectOnFocus": true, "anchor": "-20", "store": [ [ "en", "Englisch" ], [ "fr", "Franz\u00f6sisch" ], [ "de", "Deutsch" ], [ "nl", "Niederl\u00e4ndisch" ] ], "name": "language" });
    var intro_box_1_panel829 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 31, "autoHeight": true, "layout": "form", "xtype": "panel", "items": prefix825, "labelAlign": "top" }, { "flex": 31, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name826, "labelAlign": "top" }, { "flex": 7, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id827, "labelAlign": "top" }, { "flex": 29, "autoHeight": true, "layout": "form", "xtype": "panel", "items": language828, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 72, "border": false, "anchor": "-20", "labelAlign": "top" });
    var vat_id834 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("MWSt.-Nr.","(contacts.Companies.vat_id) ") }, "fieldLabel": "MWSt.-Nr.", "name": "vat_id", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var activity835 = new Lino.RemoteComboFieldElement({ "fieldLabel": "Beruf", "name": "activity", "pageSize": 20, "emptyText": "Beruf ausw\u00e4hlen...", "listeners": { "render": Lino.quicktip_renderer("Beruf","(contacts.Companies.activity) ") }, "selectOnFocus": true, "hiddenName": "activityHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/contacts/Companies/activity", "method": "GET" }) }) });
    var type836 = new Lino.RemoteComboFieldElement({ "fieldLabel": "Organisationsart", "name": "type", "pageSize": 20, "emptyText": "Organisationsart ausw\u00e4hlen...", "listeners": { "render": Lino.quicktip_renderer("Organisationsart","(contacts.Companies.type) ") }, "selectOnFocus": true, "hiddenName": "typeHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/contacts/Companies/type", "method": "GET" }) }) });
    var intro_box_2_panel837 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 23, "autoHeight": true, "layout": "form", "xtype": "panel", "items": vat_id834, "labelAlign": "top" }, { "flex": 38, "autoHeight": true, "layout": "form", "xtype": "panel", "items": activity835, "labelAlign": "top" }, { "flex": 38, "autoHeight": true, "layout": "form", "xtype": "panel", "items": type836, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 153, "border": false, "anchor": "-20", "labelAlign": "top" });
    var bank_account1841 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Bankkonto 1","(contacts.Companies.bank_account1) ") }, "fieldLabel": "Bankkonto 1", "name": "bank_account1", "maxLength": 40, "selectOnFocus": true, "anchor": "-20" });
    var bank_account2842 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Bankkonto 2","(contacts.Companies.bank_account2) ") }, "fieldLabel": "Bankkonto 2", "name": "bank_account2", "maxLength": 40, "selectOnFocus": true, "anchor": "-20" });
    var is_obsolete843 = new Ext.form.Checkbox({ "boxLabel": "veraltet", "listeners": { "render": Lino.quicktip_renderer("veraltet","(contacts.Companies.is_obsolete) Altf\u00e4lle sind Partner, deren Stammdaten nicht mehr gepflegt werden und \nf\u00fcr neue Operationen nicht benutzt werden k\u00f6nnen.") }, "hideLabel": true, "checked": false, "name": "is_obsolete", "selectOnFocus": true, "anchor": "-20" });
    var intro_box_3_panel844 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 40, "autoHeight": true, "layout": "form", "xtype": "panel", "items": bank_account1841, "labelAlign": "top" }, { "flex": 40, "autoHeight": true, "layout": "form", "xtype": "panel", "items": bank_account2842, "labelAlign": "top" }, { "flex": 19, "autoHeight": true, "layout": "form", "xtype": "panel", "items": is_obsolete843, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 108, "border": false, "anchor": "-20", "labelAlign": "top" });
    var intro_box_panel848 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "form", "hideCheckBoxLabels": true, "items": [ intro_box_1_panel829, intro_box_2_panel837, intro_box_3_panel844 ], "frame": true, "bodyBorder": false, "labelAlign": "top" });
    var country849 = new Lino.TwinCombo({ "fieldLabel": "Land", "name": "country", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.countries.Countries.detail)}, "emptyText": "Land ausw\u00e4hlen...", "listeners": { "render": Lino.quicktip_renderer("Land","(contacts.Companies.country) ") }, "selectOnFocus": true, "hiddenName": "countryHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/contacts/Companies/country", "method": "GET" }) }) });
    var region850 = new Lino.TwinCombo({ "fieldLabel": "Region", "name": "region", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.countries.Cities.detail)}, "emptyText": "Ort ausw\u00e4hlen...", "listeners": { "render": Lino.quicktip_renderer("Region","(contacts.Companies.region) ") }, "selectOnFocus": true, "hiddenName": "regionHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/contacts/Companies/region", "method": "GET" }) }) });
    var box3_1_panel851 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": country849, "labelAlign": "top" }, { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": region850, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 63, "border": false, "anchor": "-20", "labelAlign": "top" });
    var city854 = new Lino.TwinCombo({ "forceSelection": false, "fieldLabel": "Ort", "name": "city", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.countries.Cities.detail)}, "emptyText": "Ort ausw\u00e4hlen...", "listeners": { "render": Lino.quicktip_renderer("Ort","(contacts.Companies.city) ") }, "selectOnFocus": true, "hiddenName": "cityHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/contacts/Companies/city", "method": "GET" }) }) });
    var zip_code855 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Postleitzahl","(contacts.Companies.zip_code) ") }, "fieldLabel": "Postleitzahl", "name": "zip_code", "maxLength": 10, "selectOnFocus": true, "boxMinWidth": Lino.chars2width(10), "anchor": "-20" });
    var box3_2_panel856 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 66, "autoHeight": true, "layout": "form", "xtype": "panel", "items": city854, "labelAlign": "top" }, { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": zip_code855, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 117, "border": false, "anchor": "-20", "labelAlign": "top" });
    var street_prefix859 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Pr\u00e4fix Stra\u00dfe","(contacts.Companies.street_prefix) Text to print before name of street, but to ignore for sorting.") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Pr\u00e4fix Stra\u00dfe</span>", "name": "street_prefix", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var street860 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Stra\u00dfe","(contacts.Companies.street) Name of street. Without house number.") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Stra\u00dfe</span>", "name": "street", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var street_no861 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Nr.","(contacts.Companies.street_no) House number") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Nr.</span>", "name": "street_no", "maxLength": 10, "selectOnFocus": true, "boxMinWidth": Lino.chars2width(10), "anchor": "-20" });
    var street_box862 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Box","(contacts.Companies.street_box) Text to print after :attr:`steet_no` on the same line") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Box</span>", "name": "street_box", "maxLength": 10, "selectOnFocus": true, "boxMinWidth": Lino.chars2width(10), "anchor": "-20" });
    var box3_3_panel863 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 30, "autoHeight": true, "layout": "form", "xtype": "panel", "items": street_prefix859, "labelAlign": "top" }, { "flex": 36, "autoHeight": true, "layout": "form", "xtype": "panel", "items": street860, "labelAlign": "top" }, { "flex": 16, "autoHeight": true, "layout": "form", "xtype": "panel", "items": street_no861, "labelAlign": "top" }, { "flex": 16, "autoHeight": true, "layout": "form", "xtype": "panel", "items": street_box862, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 126, "border": false, "anchor": "-20", "labelAlign": "top" });
    var addr2868 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Adresszeile nach Stra\u00dfe","(contacts.Companies.addr2) Address line to print below street line") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Adresszeile nach Stra\u00dfe</span>", "name": "addr2", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var box3_panel869 = new Ext.Panel({ "flex": 62, "autoHeight": true, "layout": "form", "items": [ box3_1_panel851, box3_2_panel856, box3_3_panel863, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": addr2868, "anchor": "-20", "labelAlign": "top" } ], "frame": true, "bodyBorder": false, "autoScroll": false, "hideCheckBoxLabels": true, "labelWidth": 216, "border": false, "labelAlign": "top" });
    var email871 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("E-Mail","(contacts.Companies.email) ") }, "fieldLabel": "E-Mail", "name": "email", "maxLength": 75, "selectOnFocus": true, "anchor": "-20" });
    var url872 = new Lino.URLField({ "listeners": { "render": Lino.quicktip_renderer("URL","(contacts.Companies.url) ") }, "fieldLabel": "URL", "name": "url", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var phone873 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Telefon","(contacts.Companies.phone) ") }, "fieldLabel": "Telefon", "name": "phone", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var gsm874 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("GSM","(contacts.Companies.gsm) ") }, "fieldLabel": "GSM", "name": "gsm", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var box4_panel875 = new Ext.Panel({ "flex": 37, "autoHeight": true, "layout": "form", "items": [ { "autoHeight": true, "layout": "form", "xtype": "panel", "items": email871, "anchor": "-20", "labelAlign": "top" }, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": url872, "anchor": "-20", "labelAlign": "top" }, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": phone873, "anchor": "-20", "labelAlign": "top" }, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": gsm874, "anchor": "-20", "labelAlign": "top" } ], "frame": true, "bodyBorder": false, "autoScroll": false, "hideCheckBoxLabels": true, "labelWidth": 72, "border": false, "labelAlign": "top" });
    var address_box_panel880 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "hideCheckBoxLabels": true, "items": [ box3_panel869, box4_panel875 ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var remarks881 = new Ext.form.TextArea({ "listeners": { "render": Lino.quicktip_renderer("Bemerkungen","(contacts.Companies.remarks) ") }, "fieldLabel": "Bemerkungen", "name": "remarks", "growMax": 2000, "selectOnFocus": true, "anchor": "-20 -10" });
    var is_courseprovider882 = new Ext.form.Checkbox({ "boxLabel": "ist Kursanbieter (<a href=\"javascript:Lino.show_mti_child('is_courseprovider',Lino.courses.CourseProviders.detail)\">zeigen</a>)", "listeners": { "render": Lino.quicktip_renderer("ist Kursanbieter","(contacts.Companies.is_courseprovider) ") }, "hideLabel": true, "name": "is_courseprovider", "selectOnFocus": true, "anchor": "-20" });
    var is_jobprovider883 = new Ext.form.Checkbox({ "boxLabel": "Stellenanbieter (<a href=\"javascript:Lino.show_mti_child('is_jobprovider',Lino.jobs.JobProviders.detail)\">zeigen</a>)", "listeners": { "render": Lino.quicktip_renderer("Stellenanbieter","(contacts.Companies.is_jobprovider) ") }, "hideLabel": true, "name": "is_jobprovider", "selectOnFocus": true, "anchor": "-20" });
    var client_contact_type884 = new Lino.RemoteComboFieldElement({ "fieldLabel": "Klientenkontaktart", "name": "client_contact_type", "pageSize": 20, "emptyText": "Klientenkontaktart ausw\u00e4hlen...", "listeners": { "render": Lino.quicktip_renderer("Klientenkontaktart","(contacts.Companies.client_contact_type) ") }, "selectOnFocus": true, "hiddenName": "client_contact_typeHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/contacts/Companies/client_contact_type", "method": "GET" }) }) });
    var box5_2_panel885 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 171, "hideCheckBoxLabels": true, "items": [ { "flex": 25, "autoHeight": true, "layout": "form", "xtype": "panel", "items": is_courseprovider882, "labelAlign": "top" }, { "flex": 25, "autoHeight": true, "layout": "form", "xtype": "panel", "items": is_jobprovider883, "labelAlign": "top" }, { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": client_contact_type884, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var box5_panel889 = new Ext.Panel({ "flex": 57, "layout": "vbox", "items": [ { "items": remarks881, "labelAlign": "top", "layout": "form", "xtype": "panel", "flex": 83 }, box5_2_panel885 ], "frame": true, "layoutConfig": { "align": "stretch" }, "autoScroll": false, "hideCheckBoxLabels": true, "labelWidth": 108, "border": false, "bodyBorder": false, "labelAlign": "top" });
    var contacts_RolesByCompany_grid895 = new Lino.contacts.RolesByCompany.GridPanel({ "flex": 42, "listeners": { "render": Lino.quicktip_renderer("Kontaktpersonen","(contacts.contacts.RolesByCompany) ") }, "hide_top_toolbar": true, "containing_panel": this, "tools": [ Lino.show_in_own_window_button(Lino.contacts.RolesByCompany.grid) ], "master_panel": this });
    var bottom_box_panel896 = new Ext.Panel({ "flex": 46, "border": false, "layout": "hbox", "hideCheckBoxLabels": true, "items": [ box5_panel889, contacts_RolesByCompany_grid895 ], "autoScroll": false, "layoutConfig": { "align": "stretch" }, "frame": false, "labelAlign": "top" });
    var general_panel897 = new Ext.Panel({ "layout": "vbox", "title": "Allgemein", "items": [ intro_box_panel848, address_box_panel880, bottom_box_panel896 ], "frame": true, "layoutConfig": { "align": "stretch" }, "hideCheckBoxLabels": true, "listeners": { "activate": Lino.on_tab_activate }, "autoScroll": false, "border": false, "bodyBorder": false, "labelAlign": "top" });
    var pcsw_NotesByCompany_grid1011 = new Lino.pcsw.NotesByCompany.GridPanel({ "listeners": { "activate": Lino.on_tab_activate }, "hide_top_toolbar": true, "containing_panel": this, "title": "Ereignisse/Notizen", "tools": [ Lino.show_in_own_window_button(Lino.pcsw.NotesByCompany.grid) ], "master_panel": this });
    var main_panel1012 = new Ext.TabPanel({ "hideCheckBoxLabels": true, "border": false, "split": true, "autoScroll": false, "items": [ general_panel897, pcsw_NotesByCompany_grid1011 ], "activeTab": 0, "bodyBorder": false, "frame": true, "labelAlign": "top" });
    this.items = main_panel1012;
    this.before_row_edit = function(record) {
      region850.setContextValue('country',record ? record.data['countryHidden'] : undefined);
      city854.setContextValue('country',record ? record.data['countryHidden'] : undefined);
      city854.setContextValue('region',record ? record.data['regionHidden'] : undefined);
      contacts_RolesByCompany_grid895.on_master_changed();
      pcsw_NotesByCompany_grid1011.on_master_changed();
    }
    this.onRender = function(ct, position) {
      country849.on('change',Lino.chooser_handler(region850,'country'));
      country849.on('change',Lino.chooser_handler(city854,'country'));
      region850.on('change',Lino.chooser_handler(city854,'region'));
      Lino.contacts.Companies.DetailFormPanel.superclass.onRender.call(this, ct, position);
    }
    Lino.contacts.Companies.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.cbss.IdentifyPersonRequests.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 92,
  initComponent : function() {
    var containing_panel = this;
    var id3482 = new Ext.form.NumberField({ "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("ID","(cbss.IdentifyPersonRequests.id) ") }, "fieldLabel": "ID", "anchor": "-20", "name": "id" });
    var person3483 = new Lino.TwinCombo({ "preferred_width": 20, "fieldLabel": "Klient", "allowBlank": false, "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.pcsw.Clients.detail)}, "emptyText": "Klient ausw\u00e4hlen...", "listeners": { "render": Lino.quicktip_renderer("Klient","(cbss.IdentifyPersonRequests.person) ") }, "selectOnFocus": true, "hiddenName": "personHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cbss/IdentifyPersonRequests/person", "method": "GET" }) }), "name": "person" });
    var user3484 = new Lino.TwinCombo({ "preferred_width": 15, "fieldLabel": "Autor", "allowBlank": false, "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.users.Users.detail)}, "emptyText": "Benutzer ausw\u00e4hlen...", "listeners": { "render": Lino.quicktip_renderer("Autor","(cbss.IdentifyPersonRequests.user) ") }, "selectOnFocus": true, "hiddenName": "userHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cbss/IdentifyPersonRequests/user", "method": "GET" }) }), "name": "user" });
    var environment3485 = new Ext.form.TextField({ "disabled": true, "listeners": { "render": Lino.quicktip_renderer("T/A/B","(cbss.IdentifyPersonRequests.environment) ") }, "fieldLabel": "T/A/B", "name": "environment", "maxLength": 4, "boxMinWidth": Lino.chars2width(4), "anchor": "-20" });
    var sent3486 = new Ext.form.DisplayField({ "disabled": true, "listeners": { "render": Lino.quicktip_renderer("Versendet","(cbss.IdentifyPersonRequests.sent) The date and time when this request has been executed. \nThis is empty for requests than haven't been sent.\nRead-only.") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Versendet</span>", "name": "sent", "anchor": "-20", "value": "<br>" });
    var status3487 = new Lino.ChoicesFieldElement({ "forceSelection": true, "fieldLabel": "Zustand", "name": "status", "hiddenName": "statusHidden", "disabled": true, "listeners": { "render": Lino.quicktip_renderer("Zustand","(cbss.IdentifyPersonRequests.status) ") }, "anchor": "-20", "store": [['','<br>']].concat(Lino.cbss.RequestStates) });
    var ticket3488 = new Ext.form.TextField({ "disabled": true, "listeners": { "render": Lino.quicktip_renderer("Ticket","(cbss.IdentifyPersonRequests.ticket) ") }, "fieldLabel": "Ticket", "name": "ticket", "maxLength": 36, "anchor": "-20" });
    var info_1_panel3489 = new Ext.form.FieldSet({ "autoHeight": true, "layout": "hbox", "title": "Info zur Anfrage", "layoutConfig": { "align": "stretchmax" }, "frame": false, "bodyBorder": true, "autoScroll": false, "items": [ { "flex": 5, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id3482, "labelAlign": "top" }, { "flex": 20, "autoHeight": true, "layout": "form", "xtype": "panel", "items": person3483, "labelAlign": "top" }, { "flex": 20, "autoHeight": true, "layout": "form", "xtype": "panel", "items": user3484, "labelAlign": "top" }, { "flex": 5, "autoHeight": true, "layout": "form", "xtype": "panel", "items": environment3485, "labelAlign": "top" }, { "flex": 16, "autoHeight": true, "layout": "form", "xtype": "panel", "items": sent3486, "labelAlign": "top" }, { "flex": 12, "autoHeight": true, "layout": "form", "xtype": "panel", "items": status3487, "labelAlign": "top" }, { "flex": 21, "autoHeight": true, "layout": "form", "xtype": "panel", "items": ticket3488, "labelAlign": "top" } ], "hideCheckBoxLabels": true, "labelWidth": 90, "border": false, "labelAlign": "top" });
    var national_id3497 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("NR-Nummer","(cbss.IdentifyPersonRequests.national_id) ") }, "fieldLabel": "NR-Nummer", "name": "national_id", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var p1_panel3499 = new Ext.form.FieldSet({ "flex": 25, "layout": "vbox", "title": "Suche per NISS", "layoutConfig": { "align": "stretch" }, "frame": true, "bodyBorder": false, "autoScroll": false, "items": [ { "items": national_id3497, "autoHeight": true, "layout": "form", "xtype": "panel", "labelAlign": "top" }, { "flex": 50, "html": "<br/>", "xtype": "label" } ], "hideCheckBoxLabels": true, "labelWidth": 90, "border": false, "labelAlign": "top" });
    var first_name3501 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Vorname","(cbss.IdentifyPersonRequests.first_name) ") }, "fieldLabel": "Vorname", "name": "first_name", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var middle_name3502 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Mittelnamen","(cbss.IdentifyPersonRequests.middle_name) Whatever this means...") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Mittelnamen</span>", "name": "middle_name", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var last_name3503 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Familienname","(cbss.IdentifyPersonRequests.last_name) ") }, "fieldLabel": "Familienname", "name": "last_name", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var p2_1_panel3504 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": first_name3501, "labelAlign": "top" }, { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": middle_name3502, "labelAlign": "top" }, { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": last_name3503, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 117, "border": false, "anchor": "-20", "labelAlign": "top" });
    var birth_date3508 = new Lino.IncompleteDateField({ "listeners": { "render": Lino.quicktip_renderer("Geburtsdatum","(cbss.IdentifyPersonRequests.birth_date) Uncomplete dates are allowed, e.g. \n\"00.00.1980\" means \"some day in 1980\", \n\"00.07.1980\" means \"in July 1980\"\nor \"23.07.0000\" means \"on a 23th of July\".") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Geburtsdatum</span>", "name": "birth_date", "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var tolerance3509 = new Ext.form.NumberField({ "listeners": { "render": Lino.quicktip_renderer("Toleranz","(cbss.IdentifyPersonRequests.tolerance) \n      Falls Monat oder Tag des Geburtsdatums unbekannt sind, \n      um wieviel Monate bzw. Tage die Suche nach unten/oben ausgeweitet wird.\n      G\u00fcltige Werte: 0 bis 10.\n      ") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Toleranz</span>", "name": "tolerance", "selectOnFocus": true, "anchor": "-20", "value": 0, "allowBlank": false });
    var gender3510 = new Lino.ChoicesFieldElement({ "forceSelection": true, "fieldLabel": "Geschlecht", "name": "gender", "hiddenName": "genderHidden", "listeners": { "render": Lino.quicktip_renderer("Geschlecht","(cbss.IdentifyPersonRequests.gender) ") }, "selectOnFocus": true, "anchor": "-20", "store": [['','<br>']].concat(Lino.lino.Genders) });
    var p2_2_panel3511 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 46, "autoHeight": true, "layout": "form", "xtype": "panel", "items": birth_date3508, "labelAlign": "top" }, { "flex": 19, "autoHeight": true, "layout": "form", "xtype": "panel", "items": tolerance3509, "labelAlign": "top" }, { "flex": 34, "autoHeight": true, "layout": "form", "xtype": "panel", "items": gender3510, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 117, "border": false, "anchor": "-20", "labelAlign": "top" });
    var p2_panel3515 = new Ext.form.FieldSet({ "flex": 75, "autoHeight": true, "layout": "form", "title": "Phonetische Suche", "items": [ p2_1_panel3504, p2_2_panel3511 ], "frame": true, "bodyBorder": false, "autoScroll": false, "hideCheckBoxLabels": true, "border": false, "labelAlign": "top" });
    var parameters_panel3516 = new Ext.form.FieldSet({ "autoHeight": true, "layout": "hbox", "title": "Parameter", "layoutConfig": { "align": "stretchmax" }, "frame": false, "bodyBorder": true, "autoScroll": false, "items": [ p1_panel3499, p2_panel3515 ], "hideCheckBoxLabels": true, "border": false, "labelAlign": "top" });
    var IdentifyPersonResult_grid3527 = new Lino.cbss.IdentifyPersonResult.GridPanel({ "flex": 62, "listeners": { "render": Lino.quicktip_renderer("Resultate","(cbss.cbss.IdentifyPersonResult) ") }, "hide_top_toolbar": true, "containing_panel": this, "tools": [ Lino.show_in_own_window_button(Lino.cbss.IdentifyPersonResult.grid) ], "master_panel": this });
    var request_panel3528 = new Ext.Panel({ "layout": "vbox", "title": "Abfrage", "items": [ info_1_panel3489, parameters_panel3516, IdentifyPersonResult_grid3527 ], "frame": true, "layoutConfig": { "align": "stretch" }, "hideCheckBoxLabels": true, "listeners": { "activate": Lino.on_tab_activate }, "autoScroll": false, "border": false, "bodyBorder": false, "labelAlign": "top" });
    var response_xml3529 = new Ext.form.TextArea({ "disabled": true, "listeners": { "render": Lino.quicktip_renderer("Antwort","(cbss.IdentifyPersonRequests.response_xml) The raw XML response received. \n") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Antwort</span>", "name": "response_xml", "growMax": 2000, "anchor": "-20 -10" });
    var info_messages3530 = new Ext.form.TextArea({ "disabled": true, "listeners": { "render": Lino.quicktip_renderer("Info-Meldungen","(cbss.IdentifyPersonRequests.info_messages) ") }, "fieldLabel": "Info-Meldungen", "name": "info_messages", "growMax": 2000, "anchor": "-20 -10" });
    var debug_messages3531 = new Ext.form.TextArea({ "disabled": true, "listeners": { "render": Lino.quicktip_renderer("Debug-Meldungen","(cbss.IdentifyPersonRequests.debug_messages) ") }, "fieldLabel": "Debug-Meldungen", "name": "debug_messages", "growMax": 2000, "anchor": "-20 -10" });
    var technical_panel3532 = new Lino.VBorderPanel({ "autoScroll": false, "listeners": { "activate": Lino.on_tab_activate }, "border": false, "labelWidth": 144, "title": "Technisch", "hideCheckBoxLabels": true, "items": [ { "flex": 5, "layout": "form", "xtype": "panel", "items": response_xml3529, "region": "north", "labelAlign": "top", "split": true }, { "flex": 5, "layout": "form", "xtype": "panel", "items": info_messages3530, "region": "center", "labelAlign": "top", "split": true }, { "flex": 5, "layout": "form", "xtype": "panel", "items": debug_messages3531, "region": "south", "labelAlign": "top", "split": true } ], "frame": true, "bodyBorder": false, "labelAlign": "top" });
    var main_panel3536 = new Ext.TabPanel({ "hideCheckBoxLabels": true, "border": false, "split": true, "autoScroll": false, "items": [ request_panel3528, technical_panel3532 ], "activeTab": 0, "bodyBorder": false, "frame": true, "labelAlign": "top" });
    this.items = main_panel3536;
    this.before_row_edit = function(record) {
      IdentifyPersonResult_grid3527.on_master_changed();
    }
    Lino.cbss.IdentifyPersonRequests.DetailFormPanel.superclass.initComponent.call(this);
    // active_fields:
    person3483.on("change",function(){this.save()},this);
  }
});


Lino.pcsw.Clients.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 52,
  initComponent : function() {
    var containing_panel = this;
    var last_name2505 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Familienname","(pcsw.Clients.last_name) ") }, "fieldLabel": "Familienname", "name": "last_name", "maxLength": 200, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var first_name2506 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Vorname","(pcsw.Clients.first_name) ") }, "fieldLabel": "Vorname", "name": "first_name", "maxLength": 200, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var title2507 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Anrede","(pcsw.Clients.title) ") }, "fieldLabel": "Anrede", "name": "title", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var box1_1_panel2508 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 45, "autoHeight": true, "layout": "form", "xtype": "panel", "items": last_name2505, "labelAlign": "top" }, { "flex": 32, "autoHeight": true, "layout": "form", "xtype": "panel", "items": first_name2506, "labelAlign": "top" }, { "flex": 21, "autoHeight": true, "layout": "form", "xtype": "panel", "items": title2507, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 117, "border": false, "anchor": "-20", "labelAlign": "top" });
    var country2512 = new Lino.TwinCombo({ "fieldLabel": "Land", "name": "country", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.countries.Countries.detail)}, "emptyText": "Land ausw\u00e4hlen...", "listeners": { "render": Lino.quicktip_renderer("Land","(pcsw.Clients.country) ") }, "selectOnFocus": true, "hiddenName": "countryHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/pcsw/Clients/country", "method": "GET" }) }) });
    var city2513 = new Lino.TwinCombo({ "forceSelection": false, "fieldLabel": "Ort", "name": "city", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.countries.Cities.detail)}, "emptyText": "Ort ausw\u00e4hlen...", "listeners": { "render": Lino.quicktip_renderer("Ort","(pcsw.Clients.city) ") }, "selectOnFocus": true, "hiddenName": "cityHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/pcsw/Clients/city", "method": "GET" }) }) });
    var zip_code2514 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Postleitzahl","(pcsw.Clients.zip_code) ") }, "fieldLabel": "Postleitzahl", "name": "zip_code", "maxLength": 10, "selectOnFocus": true, "boxMinWidth": Lino.chars2width(10), "anchor": "-20" });
    var box1_2_panel2515 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 40, "autoHeight": true, "layout": "form", "xtype": "panel", "items": country2512, "labelAlign": "top" }, { "flex": 40, "autoHeight": true, "layout": "form", "xtype": "panel", "items": city2513, "labelAlign": "top" }, { "flex": 20, "autoHeight": true, "layout": "form", "xtype": "panel", "items": zip_code2514, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 117, "border": false, "anchor": "-20", "labelAlign": "top" });
    var street_prefix2519 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Pr\u00e4fix Stra\u00dfe","(pcsw.Clients.street_prefix) Text to print before name of street, but to ignore for sorting.") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Pr\u00e4fix Stra\u00dfe</span>", "name": "street_prefix", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var street2520 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Stra\u00dfe","(pcsw.Clients.street) Name of street. Without house number.") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Stra\u00dfe</span>", "name": "street", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var street_no2521 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Nr.","(pcsw.Clients.street_no) House number") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Nr.</span>", "name": "street_no", "maxLength": 10, "selectOnFocus": true, "boxMinWidth": Lino.chars2width(10), "anchor": "-20" });
    var street_box2522 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Box","(pcsw.Clients.street_box) Text to print after :attr:`steet_no` on the same line") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Box</span>", "name": "street_box", "maxLength": 10, "selectOnFocus": true, "boxMinWidth": Lino.chars2width(10), "anchor": "-20" });
    var box1_3_panel2523 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 30, "autoHeight": true, "layout": "form", "xtype": "panel", "items": street_prefix2519, "labelAlign": "top" }, { "flex": 36, "autoHeight": true, "layout": "form", "xtype": "panel", "items": street2520, "labelAlign": "top" }, { "flex": 16, "autoHeight": true, "layout": "form", "xtype": "panel", "items": street_no2521, "labelAlign": "top" }, { "flex": 16, "autoHeight": true, "layout": "form", "xtype": "panel", "items": street_box2522, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 126, "border": false, "anchor": "-20", "labelAlign": "top" });
    var addr22528 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Adresszeile nach Stra\u00dfe","(pcsw.Clients.addr2) Address line to print below street line") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Adresszeile nach Stra\u00dfe</span>", "name": "addr2", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var box1_panel2529 = new Ext.form.FieldSet({ "flex": 61, "autoHeight": true, "layout": "form", "title": "Adresse", "items": [ box1_1_panel2508, box1_2_panel2515, box1_3_panel2523, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": addr22528, "anchor": "-20", "labelAlign": "top" } ], "frame": true, "bodyBorder": false, "autoScroll": false, "hideCheckBoxLabels": true, "labelWidth": 216, "border": false, "labelAlign": "top" });
    var id2531 = new Ext.form.NumberField({ "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("ID","(pcsw.Clients.id) ") }, "fieldLabel": "ID", "anchor": "-20", "name": "id" });
    var language2532 = new Lino.ChoicesFieldElement({ "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Sprache</span>", "allowBlank": false, "hiddenName": "languageHidden", "listeners": { "render": Lino.quicktip_renderer("Sprache","(pcsw.Clients.language) Die Sprache, in der Dokumente ausgestellt werden sollen.") }, "selectOnFocus": true, "anchor": "-20", "store": [ [ "en", "Englisch" ], [ "fr", "Franz\u00f6sisch" ], [ "de", "Deutsch" ], [ "nl", "Niederl\u00e4ndisch" ] ], "name": "language" });
    var box2_1_panel2533 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 37, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id2531, "labelAlign": "top" }, { "flex": 62, "autoHeight": true, "layout": "form", "xtype": "panel", "items": language2532, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 72, "border": false, "anchor": "-20", "labelAlign": "top" });
    var email2536 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("E-Mail","(pcsw.Clients.email) ") }, "fieldLabel": "E-Mail", "name": "email", "maxLength": 75, "selectOnFocus": true, "anchor": "-20" });
    var phone2537 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Telefon","(pcsw.Clients.phone) ") }, "fieldLabel": "Telefon", "name": "phone", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var fax2538 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Fax","(pcsw.Clients.fax) ") }, "fieldLabel": "Fax", "name": "fax", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var box2_3_panel2539 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": phone2537, "labelAlign": "top" }, { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": fax2538, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 72, "border": false, "anchor": "-20", "labelAlign": "top" });
    var gsm2542 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("GSM","(pcsw.Clients.gsm) ") }, "fieldLabel": "GSM", "name": "gsm", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var box2_panel2543 = new Ext.form.FieldSet({ "flex": 38, "autoHeight": true, "layout": "form", "title": "Kontakt", "items": [ box2_1_panel2533, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": email2536, "anchor": "-20", "labelAlign": "top" }, box2_3_panel2539, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": gsm2542, "anchor": "-20", "labelAlign": "top" } ], "frame": true, "bodyBorder": false, "autoScroll": false, "hideCheckBoxLabels": true, "labelWidth": 63, "border": false, "labelAlign": "top" });
    var general_1_panel2546 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "hideCheckBoxLabels": true, "items": [ box1_panel2529, box2_panel2543 ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "anchor": "-20", "labelAlign": "top" });
    var gender2547 = new Lino.ChoicesFieldElement({ "forceSelection": true, "fieldLabel": "Geschlecht", "name": "gender", "hiddenName": "genderHidden", "listeners": { "render": Lino.quicktip_renderer("Geschlecht","(pcsw.Clients.gender) ") }, "selectOnFocus": true, "anchor": "-20", "store": [['','<br>']].concat(Lino.lino.Genders) });
    var birth_date2548 = new Lino.IncompleteDateField({ "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Geburtsdatum","(pcsw.Clients.birth_date) Uncomplete dates are allowed, e.g. \n\"00.00.1980\" means \"some day in 1980\", \n\"00.07.1980\" means \"in July 1980\"\nor \"23.07.0000\" means \"on a 23th of July\".") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Geburtsdatum</span>", "anchor": "-20", "name": "birth_date" });
    var age_disp2549 = new Ext.form.DisplayField({ "disabled": true, "listeners": { "render": Lino.quicktip_renderer("Alter","(pcsw.Clients.age) ") }, "fieldLabel": "Alter", "name": "age", "anchor": "-20", "value": "<br/>", "always_enabled": true });
    var civil_state2550 = new Lino.ChoicesFieldElement({ "forceSelection": true, "fieldLabel": "Zivilstand", "name": "civil_state", "hiddenName": "civil_stateHidden", "listeners": { "render": Lino.quicktip_renderer("Zivilstand","(pcsw.Clients.civil_state) ") }, "selectOnFocus": true, "anchor": "-20", "store": [['','<br>']].concat(Lino.pcsw.CivilState) });
    var noble_condition2551 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Adelstitel","(pcsw.Clients.noble_condition) The eventual noble condition of this person. Imported from TIM.") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Adelstitel</span>", "name": "noble_condition", "maxLength": 50, "selectOnFocus": true, "anchor": "-20" });
    var box3_1_panel2552 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 14, "autoHeight": true, "layout": "form", "xtype": "panel", "items": gender2547, "labelAlign": "top" }, { "flex": 17, "autoHeight": true, "layout": "form", "xtype": "panel", "items": birth_date2548, "labelAlign": "top" }, { "flex": 14, "autoHeight": true, "layout": "form", "xtype": "panel", "items": age_disp2549, "labelAlign": "top" }, { "flex": 22, "autoHeight": true, "layout": "form", "xtype": "panel", "items": civil_state2550, "labelAlign": "top" }, { "flex": 30, "autoHeight": true, "layout": "form", "xtype": "panel", "items": noble_condition2551, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 117, "border": false, "anchor": "-20", "labelAlign": "top" });
    var birth_country2558 = new Lino.TwinCombo({ "fieldLabel": "Geburtsland", "name": "birth_country", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.countries.Countries.detail)}, "emptyText": "Land ausw\u00e4hlen...", "listeners": { "render": Lino.quicktip_renderer("Geburtsland","(pcsw.Clients.birth_country) ") }, "selectOnFocus": true, "hiddenName": "birth_countryHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/pcsw/Clients/birth_country", "method": "GET" }) }) });
    var birth_place2559 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Geburtsort","(pcsw.Clients.birth_place) ") }, "fieldLabel": "Geburtsort", "name": "birth_place", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var nationality2560 = new Lino.TwinCombo({ "fieldLabel": "Staatsangeh\u00f6rigkeit", "name": "nationality", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.countries.Countries.detail)}, "emptyText": "Land ausw\u00e4hlen...", "listeners": { "render": Lino.quicktip_renderer("Staatsangeh\u00f6rigkeit","(pcsw.Clients.nationality) ") }, "selectOnFocus": true, "hiddenName": "nationalityHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/pcsw/Clients/nationality", "method": "GET" }) }) });
    var national_id2561 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("NR-Nummer","(pcsw.Clients.national_id) ") }, "fieldLabel": "NR-Nummer", "name": "national_id", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var box3_2_panel2562 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 28, "autoHeight": true, "layout": "form", "xtype": "panel", "items": birth_country2558, "labelAlign": "top" }, { "flex": 29, "autoHeight": true, "layout": "form", "xtype": "panel", "items": birth_place2559, "labelAlign": "top" }, { "flex": 21, "autoHeight": true, "layout": "form", "xtype": "panel", "items": nationality2560, "labelAlign": "top" }, { "flex": 21, "autoHeight": true, "layout": "form", "xtype": "panel", "items": national_id2561, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 180, "border": false, "anchor": "-20", "labelAlign": "top" });
    var box3_panel2567 = new Ext.form.FieldSet({ "autoHeight": true, "layout": "form", "title": "Geburtsangaben", "items": [ box3_1_panel2552, box3_2_panel2562 ], "frame": true, "bodyBorder": false, "autoScroll": false, "hideCheckBoxLabels": true, "border": false, "anchor": "-20", "labelAlign": "top" });
    var eid_info_disp2568 = new Ext.form.DisplayField({ "disabled": true, "listeners": { "render": Lino.quicktip_renderer("eID-Karte","(pcsw.Clients.eid_info) ") }, "fieldLabel": "eID-Karte", "name": "eid_info", "anchor": "-20", "value": "<br/>", "always_enabled": true });
    var created2569 = new Ext.form.DisplayField({ "disabled": true, "listeners": { "render": Lino.quicktip_renderer("Erstellt","(pcsw.Clients.created) ") }, "fieldLabel": "Erstellt", "name": "created", "anchor": "-20", "value": "<br>" });
    var modified2570 = new Ext.form.DisplayField({ "disabled": true, "listeners": { "render": Lino.quicktip_renderer("Bearbeitet","(pcsw.Clients.modified) ") }, "fieldLabel": "Bearbeitet", "name": "modified", "anchor": "-20", "value": "<br>" });
    var box4_3_panel2571 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": created2569, "labelAlign": "top" }, { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": modified2570, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 99, "border": false, "anchor": "-20", "labelAlign": "top" });
    var box4_panel2574 = new Ext.Panel({ "flex": 82, "autoHeight": true, "layout": "form", "items": [ box3_panel2567, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": eid_info_disp2568, "anchor": "-20", "labelAlign": "top" }, box4_3_panel2571 ], "frame": true, "bodyBorder": false, "autoScroll": false, "hideCheckBoxLabels": true, "labelWidth": 90, "border": false, "labelAlign": "top" });
    var image_htmlbox2576 = new Lino.HtmlBoxPanel({ "flex": 17, "layout": "fit", "name": "image", "containing_panel": this, "master_panel": this, "items": new Ext.BoxComponent({autoScroll:true}), "bodyStyle": "overflow-x:hidden;", "value": "<br/>", "always_enabled": true, "listeners": { "render": Lino.quicktip_renderer(null,"(pcsw.Clients.image) ") } });
    var general_2_panel2577 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ box4_panel2574, image_htmlbox2576 ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 0, "border": false, "anchor": "-20", "labelAlign": "top" });
    var general_panel2578 = new Ext.Panel({ "autoHeight": true, "layout": "form", "title": "Person", "items": [ general_1_panel2546, general_2_panel2577 ], "frame": true, "bodyBorder": false, "hideCheckBoxLabels": true, "listeners": { "activate": Lino.on_tab_activate }, "autoScroll": false, "border": false, "labelAlign": "top" });
    var in_belgium_since2579 = new Lino.DateField({ "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Lebt in Belgien seit","(pcsw.Clients.in_belgium_since) Since when this person in Belgium lives.\n<b>Important:</b> help_text can be formatted.") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Lebt in Belgien seit</span>", "anchor": "-20", "name": "in_belgium_since" });
    var residence_type2580 = new Lino.ChoicesFieldElement({ "forceSelection": true, "fieldLabel": "Register", "name": "residence_type", "hiddenName": "residence_typeHidden", "listeners": { "render": Lino.quicktip_renderer("Register","(pcsw.Clients.residence_type) ") }, "selectOnFocus": true, "anchor": "-20", "store": [['','<br>']].concat(Lino.pcsw.ResidenceType) });
    var gesdos_id2581 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Gesdos-Nr","(pcsw.Clients.gesdos_id) ") }, "fieldLabel": "Gesdos-Nr", "name": "gesdos_id", "maxLength": 40, "selectOnFocus": true, "anchor": "-20" });
    var status_1_panel2582 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 24, "autoHeight": true, "layout": "form", "xtype": "panel", "items": in_belgium_since2579, "labelAlign": "top" }, { "flex": 40, "autoHeight": true, "layout": "form", "xtype": "panel", "items": residence_type2580, "labelAlign": "top" }, { "flex": 34, "autoHeight": true, "layout": "form", "xtype": "panel", "items": gesdos_id2581, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 189, "border": false, "anchor": "-20", "labelAlign": "top" });
    var bank_account12586 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Bankkonto 1","(pcsw.Clients.bank_account1) ") }, "fieldLabel": "Bankkonto 1", "name": "bank_account1", "maxLength": 40, "selectOnFocus": true, "anchor": "-20" });
    var bank_account22587 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Bankkonto 2","(pcsw.Clients.bank_account2) ") }, "fieldLabel": "Bankkonto 2", "name": "bank_account2", "maxLength": 40, "selectOnFocus": true, "anchor": "-20" });
    var status_2_panel2588 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": bank_account12586, "labelAlign": "top" }, { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": bank_account22587, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 108, "border": false, "anchor": "-20", "labelAlign": "top" });
    var job_agents2591 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Interim-Agenturen","(pcsw.Clients.job_agents) ") }, "fieldLabel": "Interim-Agenturen", "name": "job_agents", "maxLength": 100, "selectOnFocus": true, "anchor": "-20" });
    var group2592 = new Lino.RemoteComboFieldElement({ "fieldLabel": "Integrationsphase", "name": "group", "pageSize": 20, "emptyText": "Integrationsphase ausw\u00e4hlen...", "listeners": { "render": Lino.quicktip_renderer("Integrationsphase","(pcsw.Clients.group) ") }, "selectOnFocus": true, "hiddenName": "groupHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/pcsw/Clients/group", "method": "GET" }) }) });
    var status_3_panel2593 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 56, "autoHeight": true, "layout": "form", "xtype": "panel", "items": job_agents2591, "labelAlign": "top" }, { "flex": 43, "autoHeight": true, "layout": "form", "xtype": "panel", "items": group2592, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 162, "border": false, "anchor": "-20", "labelAlign": "top" });
    var status_panel2596 = new Ext.Panel({ "flex": 68, "autoHeight": true, "border": false, "layout": "form", "hideCheckBoxLabels": true, "items": [ status_1_panel2582, status_2_panel2588, status_3_panel2593 ], "frame": true, "autoScroll": false, "bodyBorder": false, "labelAlign": "top" });
    var aid_type2597 = new Lino.RemoteComboFieldElement({ "fieldLabel": "Sozialhilfeart", "name": "aid_type", "pageSize": 20, "emptyText": "Sozialhilfeart ausw\u00e4hlen...", "listeners": { "render": Lino.quicktip_renderer("Sozialhilfeart","(pcsw.Clients.aid_type) ") }, "selectOnFocus": true, "hiddenName": "aid_typeHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/pcsw/Clients/aid_type", "method": "GET" }) }) });
    var income_ag2598 = new Ext.form.Checkbox({ "boxLabel": "Arbeitslosengeld", "listeners": { "render": Lino.quicktip_renderer("Arbeitslosengeld","(pcsw.Clients.income_ag) ") }, "hideLabel": true, "checked": false, "name": "income_ag", "selectOnFocus": true, "anchor": "-20" });
    var income_wg2599 = new Ext.form.Checkbox({ "boxLabel": "Wartegeld", "listeners": { "render": Lino.quicktip_renderer("Wartegeld","(pcsw.Clients.income_wg) ") }, "hideLabel": true, "checked": false, "name": "income_wg", "selectOnFocus": true, "anchor": "-20" });
    var income_2_panel2600 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": income_ag2598, "labelAlign": "top" }, { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": income_wg2599, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 153, "border": false, "anchor": "-20", "labelAlign": "top" });
    var income_kg2603 = new Ext.form.Checkbox({ "boxLabel": "Krankengeld", "listeners": { "render": Lino.quicktip_renderer("Krankengeld","(pcsw.Clients.income_kg) ") }, "hideLabel": true, "checked": false, "name": "income_kg", "selectOnFocus": true, "anchor": "-20" });
    var income_rente2604 = new Ext.form.Checkbox({ "boxLabel": "Rente", "listeners": { "render": Lino.quicktip_renderer("Rente","(pcsw.Clients.income_rente) ") }, "hideLabel": true, "checked": false, "name": "income_rente", "selectOnFocus": true, "anchor": "-20" });
    var income_3_panel2605 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": income_kg2603, "labelAlign": "top" }, { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": income_rente2604, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 108, "border": false, "anchor": "-20", "labelAlign": "top" });
    var income_misc2608 = new Ext.form.Checkbox({ "boxLabel": "andere Einkommen", "listeners": { "render": Lino.quicktip_renderer("andere Einkommen","(pcsw.Clients.income_misc) ") }, "hideLabel": true, "checked": false, "name": "income_misc", "selectOnFocus": true, "anchor": "-20" });
    var income_panel2609 = new Ext.Panel({ "flex": 31, "autoHeight": true, "layout": "form", "items": [ { "autoHeight": true, "layout": "form", "xtype": "panel", "items": aid_type2597, "anchor": "-20", "labelAlign": "top" }, income_2_panel2600, income_3_panel2605, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": income_misc2608, "anchor": "-20", "labelAlign": "top" } ], "frame": true, "bodyBorder": false, "autoScroll": false, "hideCheckBoxLabels": true, "labelWidth": 153, "border": false, "labelAlign": "top" });
    var status_tab_1_panel2612 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "hideCheckBoxLabels": true, "items": [ status_panel2596, income_panel2609 ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var is_seeking2626 = new Ext.form.Checkbox({ "boxLabel": "Arbeit suchend", "listeners": { "render": Lino.quicktip_renderer("Arbeit suchend","(pcsw.Clients.is_seeking) ") }, "hideLabel": true, "checked": false, "name": "is_seeking", "selectOnFocus": true, "anchor": "-20" });
    var unemployed_since2627 = new Lino.DateField({ "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("eingetragen seit","(pcsw.Clients.unemployed_since) ") }, "fieldLabel": "eingetragen seit", "anchor": "-20", "name": "unemployed_since" });
    var work_permit_suspended_until2628 = new Lino.DateField({ "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Wartezeit bis","(pcsw.Clients.work_permit_suspended_until) ") }, "fieldLabel": "Wartezeit bis", "anchor": "-20", "name": "work_permit_suspended_until" });
    var papers_1_panel2629 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 153, "hideCheckBoxLabels": true, "items": [ { "flex": 38, "autoHeight": true, "layout": "form", "xtype": "panel", "items": is_seeking2626, "labelAlign": "top" }, { "flex": 30, "autoHeight": true, "layout": "form", "xtype": "panel", "items": unemployed_since2627, "labelAlign": "top" }, { "flex": 30, "autoHeight": true, "layout": "form", "xtype": "panel", "items": work_permit_suspended_until2628, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var needs_residence_permit2633 = new Ext.form.Checkbox({ "boxLabel": "Braucht Aufenthaltserlaubnis", "listeners": { "render": Lino.quicktip_renderer("Braucht Aufenthaltserlaubnis","(pcsw.Clients.needs_residence_permit) ") }, "hideLabel": true, "checked": false, "name": "needs_residence_permit", "selectOnFocus": true, "anchor": "-20" });
    var needs_work_permit2634 = new Ext.form.Checkbox({ "boxLabel": "Braucht Arb.Erl.", "listeners": { "render": Lino.quicktip_renderer("Braucht Arb.Erl.","(pcsw.Clients.needs_work_permit) ") }, "hideLabel": true, "checked": false, "name": "needs_work_permit", "selectOnFocus": true, "anchor": "-20" });
    var papers_2_panel2635 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 261, "hideCheckBoxLabels": true, "items": [ { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": needs_residence_permit2633, "labelAlign": "top" }, { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": needs_work_permit2634, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var residence_permit_disp2638 = new Ext.form.DisplayField({ "disabled": true, "listeners": { "render": Lino.quicktip_renderer("Aufenthaltserlaubnis","(pcsw.Clients.residence_permit) ") }, "fieldLabel": "Aufenthaltserlaubnis", "name": "residence_permit", "anchor": "-20", "value": "<br/>", "always_enabled": true });
    var work_permit_disp2639 = new Ext.form.DisplayField({ "disabled": true, "listeners": { "render": Lino.quicktip_renderer("Arbeitserlaubnis","(pcsw.Clients.work_permit) ") }, "fieldLabel": "Arbeitserlaubnis", "name": "work_permit", "anchor": "-20", "value": "<br/>", "always_enabled": true });
    var driving_licence_disp2640 = new Ext.form.DisplayField({ "disabled": true, "listeners": { "render": Lino.quicktip_renderer("F\u00fchrerschein","(pcsw.Clients.driving_licence) ") }, "fieldLabel": "F\u00fchrerschein", "name": "driving_licence", "anchor": "-20", "value": "<br/>", "always_enabled": true });
    var papers_3_panel2641 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 189, "hideCheckBoxLabels": true, "items": [ { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": residence_permit_disp2638, "labelAlign": "top" }, { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": work_permit_disp2639, "labelAlign": "top" }, { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": driving_licence_disp2640, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var UploadsByController_htmlbox2645 = new Lino.HtmlBoxPanel({ "flex": 37, "ls_bbar_actions": [ { "itemId": "insert", "menu_item_text": "Neu", "must_save": true, "tooltip": "Neuen Datensatz erstellen", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-new", "overflowText": "Neu", "auto_save": true } ], "name": "UploadsByController", "containing_panel": this, "items": new Ext.BoxComponent({autoScroll:true}), "title": "Uploads", "master_panel": this, "value": "<br/>", "always_enabled": true, "listeners": { "render": Lino.quicktip_renderer("Uploads","(pcsw.Clients.UploadsByController) ") }, "bodyStyle": "overflow-x:hidden;", "ls_insert_handler": Lino.uploads.UploadsByController.insert, "layout": "fit", "tools": [ Lino.show_in_own_window_button(Lino.uploads.UploadsByController.grid) ] });
    var papers_panel2646 = new Ext.Panel({ "flex": 50, "layout": "vbox", "items": [ papers_1_panel2629, papers_2_panel2635, papers_3_panel2641, UploadsByController_htmlbox2645 ], "frame": true, "layoutConfig": { "align": "stretch" }, "autoScroll": false, "hideCheckBoxLabels": true, "labelWidth": 72, "border": false, "bodyBorder": false, "labelAlign": "top" });
    var status_tab_2_panel2647 = new Ext.Panel({ "flex": 66, "border": false, "layout": "hbox", "hideCheckBoxLabels": true, "items": [ papers_panel2646 ], "autoScroll": false, "layoutConfig": { "align": "stretch" }, "frame": false, "labelAlign": "top" });
    var status_tab_panel2648 = new Ext.Panel({ "layout": "vbox", "title": "Status", "items": [ status_tab_1_panel2612, status_tab_2_panel2647 ], "frame": true, "layoutConfig": { "align": "stretch" }, "hideCheckBoxLabels": true, "listeners": { "activate": Lino.on_tab_activate }, "autoScroll": false, "border": false, "bodyBorder": false, "labelAlign": "top" });
    var workflow_buttons_disp2649 = new Ext.form.DisplayField({ "disabled": true, "listeners": { "render": Lino.quicktip_renderer("Arbeitsablauf","(pcsw.Clients.workflow_buttons) ") }, "fieldLabel": "Arbeitsablauf", "name": "workflow_buttons", "anchor": "-20", "value": "<br/>", "always_enabled": true });
    var broker2650 = new Lino.RemoteComboFieldElement({ "fieldLabel": "Vermittler", "name": "broker", "pageSize": 20, "emptyText": "Vermittler ausw\u00e4hlen...", "listeners": { "render": Lino.quicktip_renderer("Vermittler","(pcsw.Clients.broker) ") }, "selectOnFocus": true, "hiddenName": "brokerHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/pcsw/Clients/broker", "method": "GET" }) }) });
    var faculty2651 = new Lino.TwinCombo({ "fieldLabel": "Fachbereich", "name": "faculty", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.newcomers.Faculties.detail)}, "emptyText": "Fachbereich ausw\u00e4hlen...", "listeners": { "render": Lino.quicktip_renderer("Fachbereich","(pcsw.Clients.faculty) ") }, "selectOnFocus": true, "hiddenName": "facultyHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/pcsw/Clients/faculty", "method": "GET" }) }) });
    var newcomers_left_panel2652 = new Ext.Panel({ "flex": 33, "autoHeight": true, "layout": "form", "items": [ { "autoHeight": true, "layout": "form", "xtype": "panel", "items": workflow_buttons_disp2649, "anchor": "-20", "labelAlign": "top" }, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": broker2650, "anchor": "-20", "labelAlign": "top" }, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": faculty2651, "anchor": "-20", "labelAlign": "top" } ], "frame": true, "bodyBorder": false, "autoScroll": false, "hideCheckBoxLabels": true, "labelWidth": 126, "border": false, "labelAlign": "top" });
    var newcomers_AvailableCoachesByClient_grid2670 = new Lino.newcomers.AvailableCoachesByClient.GridPanel({ "flex": 66, "listeners": { "render": Lino.quicktip_renderer("Verf\u00fcgbare Begleiter","(newcomers.newcomers.AvailableCoachesByClient) ") }, "hide_top_toolbar": true, "containing_panel": this, "tools": [ Lino.show_in_own_window_button(Lino.newcomers.AvailableCoachesByClient.grid) ], "master_panel": this });
    var coaching_1_panel2671 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "hideCheckBoxLabels": true, "items": [ newcomers_left_panel2652, newcomers_AvailableCoachesByClient_grid2670 ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var pcsw_ContactsByClient_grid2679 = new Lino.pcsw.ContactsByClient.GridPanel({ "flex": 50, "listeners": { "render": Lino.quicktip_renderer("Kontakte","(pcsw.pcsw.ContactsByClient) ") }, "hide_top_toolbar": true, "containing_panel": this, "tools": [ Lino.show_in_own_window_button(Lino.pcsw.ContactsByClient.grid) ], "master_panel": this });
    var pcsw_CoachingsByClient_grid2688 = new Lino.pcsw.CoachingsByClient.GridPanel({ "flex": 50, "listeners": { "render": Lino.quicktip_renderer("Begleitungen","(pcsw.pcsw.CoachingsByClient) ") }, "hide_top_toolbar": true, "containing_panel": this, "params_panel_hidden": true, "tools": [ Lino.show_in_own_window_button(Lino.pcsw.CoachingsByClient.grid) ], "master_panel": this });
    var coaching_2_panel2689 = new Ext.Panel({ "flex": 50, "border": false, "layout": "hbox", "hideCheckBoxLabels": true, "items": [ pcsw_ContactsByClient_grid2679, pcsw_CoachingsByClient_grid2688 ], "autoScroll": false, "layoutConfig": { "align": "stretch" }, "frame": false, "labelAlign": "top" });
    var coaching_panel2690 = new Ext.Panel({ "layout": "vbox", "title": "Begleitung", "items": [ coaching_1_panel2671, coaching_2_panel2689 ], "frame": true, "layoutConfig": { "align": "stretch" }, "hideCheckBoxLabels": true, "listeners": { "activate": Lino.on_tab_activate }, "autoScroll": false, "border": false, "bodyBorder": false, "labelAlign": "top" });
    var skills2773 = new Ext.form.TextArea({ "listeners": { "render": Lino.quicktip_renderer("Sonstige F\u00e4higkeiten","(pcsw.Clients.skills) ") }, "fieldLabel": "Sonstige F\u00e4higkeiten", "name": "skills", "growMax": 2000, "selectOnFocus": true, "anchor": "-20 -10" });
    var competences_1_panel2774 = new Ext.Panel({ "flex": 5, "layout": "hbox", "items": [ { "items": skills2773, "labelAlign": "top", "layout": "form", "xtype": "panel", "flex": 28 } ], "region": "north", "layoutConfig": { "align": "stretch" }, "hideCheckBoxLabels": true, "split": true, "autoScroll": false, "labelWidth": 189, "border": false, "frame": false, "labelAlign": "top" });
    var obstacles2783 = new Ext.form.TextArea({ "listeners": { "render": Lino.quicktip_renderer("Hindernisse","(pcsw.Clients.obstacles) ") }, "fieldLabel": "Hindernisse", "name": "obstacles", "growMax": 2000, "selectOnFocus": true, "anchor": "-20 -10" });
    var competences_2_panel2784 = new Ext.Panel({ "flex": 5, "layout": "hbox", "items": [ { "items": obstacles2783, "labelAlign": "top", "layout": "form", "xtype": "panel", "flex": 44 } ], "region": "center", "layoutConfig": { "align": "stretch" }, "hideCheckBoxLabels": true, "split": true, "autoScroll": false, "labelWidth": 108, "border": false, "frame": false, "labelAlign": "top" });
    var competences_panel2786 = new Lino.VBorderPanel({ "autoScroll": false, "listeners": { "activate": Lino.on_tab_activate }, "border": false, "title": "Kompetenzen", "hideCheckBoxLabels": true, "items": [ competences_1_panel2774, competences_2_panel2784 ], "frame": true, "bodyBorder": false, "labelAlign": "top" });
    var pcsw_NotesByPerson_grid2869 = new Lino.pcsw.NotesByPerson.GridPanel({ "listeners": { "activate": Lino.on_tab_activate }, "hide_top_toolbar": true, "containing_panel": this, "title": "Historie", "tools": [ Lino.show_in_own_window_button(Lino.pcsw.NotesByPerson.grid) ], "master_panel": this });
    var find_appointment_disp2870 = new Ext.form.DisplayField({ "disabled": true, "listeners": { "render": Lino.quicktip_renderer("Termin finden","(pcsw.Clients.find_appointment) ") }, "fieldLabel": "Termin finden", "name": "find_appointment", "anchor": "-20", "value": "<br/>", "always_enabled": true });
    var cal_EventsByProject_grid2876 = new Lino.cal.EventsByProject.GridPanel({ "flex": 5, "hide_top_toolbar": true, "containing_panel": this, "region": "center", "params_panel_hidden": true, "master_panel": this, "listeners": { "render": Lino.quicktip_renderer("Termine","(cal.cal.EventsByProject) ") }, "split": true, "tools": [ Lino.show_in_own_window_button(Lino.cal.EventsByProject.grid) ] });
    var cal_TasksByProject_grid2899 = new Lino.cal.TasksByProject.GridPanel({ "flex": 5, "hide_top_toolbar": true, "containing_panel": this, "region": "south", "params_panel_hidden": true, "master_panel": this, "listeners": { "render": Lino.quicktip_renderer("Aufgaben","(cal.cal.TasksByProject) ") }, "split": true, "tools": [ Lino.show_in_own_window_button(Lino.cal.TasksByProject.grid) ] });
    var calendar_panel2900 = new Lino.VBorderPanel({ "autoScroll": false, "listeners": { "activate": Lino.on_tab_activate }, "border": false, "labelWidth": 126, "title": "Kalender", "hideCheckBoxLabels": true, "items": [ { "autoHeight": true, "layout": "form", "xtype": "panel", "items": find_appointment_disp2870, "region": "north", "labelAlign": "top", "split": true }, cal_EventsByProject_grid2876, cal_TasksByProject_grid2899 ], "frame": true, "bodyBorder": false, "labelAlign": "top" });
    var outbox_MailsByProject_grid2913 = new Lino.outbox.MailsByProject.GridPanel({ "listeners": { "activate": Lino.on_tab_activate }, "hide_top_toolbar": true, "containing_panel": this, "title": "E-Mail-Ausgang", "tools": [ Lino.show_in_own_window_button(Lino.outbox.MailsByProject.grid) ], "master_panel": this });
    var activity2914 = new Lino.RemoteComboFieldElement({ "fieldLabel": "Beruf", "name": "activity", "pageSize": 20, "emptyText": "Beruf ausw\u00e4hlen...", "listeners": { "render": Lino.quicktip_renderer("Beruf","(pcsw.Clients.activity) ") }, "selectOnFocus": true, "hiddenName": "activityHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/pcsw/Clients/activity", "method": "GET" }) }) });
    var client_state2915 = new Lino.ChoicesFieldElement({ "forceSelection": true, "fieldLabel": "Zustand", "allowBlank": false, "hiddenName": "client_stateHidden", "listeners": { "render": Lino.quicktip_renderer("Zustand","(pcsw.Clients.client_state) ") }, "selectOnFocus": true, "anchor": "-20", "store": Lino.pcsw.ClientStates, "name": "client_state" });
    var refusal_reason2916 = new Lino.ChoicesFieldElement({ "forceSelection": true, "fieldLabel": "refusal reason", "name": "refusal_reason", "hiddenName": "refusal_reasonHidden", "listeners": { "render": Lino.quicktip_renderer("refusal reason","(pcsw.Clients.refusal_reason) ") }, "selectOnFocus": true, "anchor": "-20", "store": [['','<br>']].concat(Lino.pcsw.RefusalReasons) });
    var misc_1_panel2917 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 135, "hideCheckBoxLabels": true, "items": [ { "flex": 27, "autoHeight": true, "layout": "form", "xtype": "panel", "items": activity2914, "labelAlign": "top" }, { "flex": 14, "autoHeight": true, "layout": "form", "xtype": "panel", "items": client_state2915, "labelAlign": "top" }, { "flex": 58, "autoHeight": true, "layout": "form", "xtype": "panel", "items": refusal_reason2916, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var is_cpas2921 = new Ext.form.Checkbox({ "boxLabel": "Sozialhilfeempf\u00e4nger", "listeners": { "render": Lino.quicktip_renderer("Sozialhilfeempf\u00e4nger","(pcsw.Clients.is_cpas) ") }, "hideLabel": true, "checked": false, "name": "is_cpas", "selectOnFocus": true, "anchor": "-20" });
    var is_senior2922 = new Ext.form.Checkbox({ "boxLabel": "Altenheim", "listeners": { "render": Lino.quicktip_renderer("Altenheim","(pcsw.Clients.is_senior) ") }, "hideLabel": true, "checked": false, "name": "is_senior", "selectOnFocus": true, "anchor": "-20" });
    var is_obsolete2923 = new Ext.form.Checkbox({ "boxLabel": "veraltet", "listeners": { "render": Lino.quicktip_renderer("veraltet","(pcsw.Clients.is_obsolete) Altf\u00e4lle sind Partner, deren Stammdaten nicht mehr gepflegt werden und \nf\u00fcr neue Operationen nicht benutzt werden k\u00f6nnen.") }, "hideLabel": true, "checked": false, "name": "is_obsolete", "selectOnFocus": true, "anchor": "-20" });
    var misc_2_panel2924 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 189, "hideCheckBoxLabels": true, "items": [ { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": is_cpas2921, "labelAlign": "top" }, { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": is_senior2922, "labelAlign": "top" }, { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": is_obsolete2923, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var unavailable_until2928 = new Lino.DateField({ "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Nicht verf\u00fcgbar bis","(pcsw.Clients.unavailable_until) ") }, "fieldLabel": "Nicht verf\u00fcgbar bis", "anchor": "-20", "name": "unavailable_until" });
    var unavailable_why2929 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Grund","(pcsw.Clients.unavailable_why) ") }, "fieldLabel": "Grund", "name": "unavailable_why", "maxLength": 100, "selectOnFocus": true, "anchor": "-20" });
    var misc_3_panel2930 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 180, "hideCheckBoxLabels": true, "items": [ { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": unavailable_until2928, "labelAlign": "top" }, { "flex": 66, "autoHeight": true, "layout": "form", "xtype": "panel", "items": unavailable_why2929, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var remarks2933 = new Ext.form.TextArea({ "listeners": { "render": Lino.quicktip_renderer("Bemerkungen","(pcsw.Clients.remarks) ") }, "fieldLabel": "Bemerkungen", "name": "remarks", "growMax": 2000, "selectOnFocus": true, "anchor": "-20 -10" });
    var remarks22934 = new Ext.form.TextArea({ "listeners": { "render": Lino.quicktip_renderer("Bemerkungen (Sozialsekretariat)","(pcsw.Clients.remarks2) ") }, "fieldLabel": "Bemerkungen (Sozialsekretariat)", "name": "remarks2", "growMax": 2000, "selectOnFocus": true, "anchor": "-20 -10" });
    var misc_4_panel2935 = new Ext.Panel({ "flex": 38, "border": false, "layout": "hbox", "labelWidth": 288, "hideCheckBoxLabels": true, "items": [ { "items": remarks2933, "labelAlign": "top", "layout": "form", "xtype": "panel", "flex": 50 }, { "items": remarks22934, "labelAlign": "top", "layout": "form", "xtype": "panel", "flex": 50 } ], "autoScroll": false, "layoutConfig": { "align": "stretch" }, "frame": false, "labelAlign": "top" });
    var contacts_RolesByPerson_grid2938 = new Lino.contacts.RolesByPerson.GridPanel({ "flex": 33, "listeners": { "render": Lino.quicktip_renderer("Kontaktperson f\u00fcr","(contacts.contacts.RolesByPerson) ") }, "hide_top_toolbar": true, "containing_panel": this, "tools": [ Lino.show_in_own_window_button(Lino.contacts.RolesByPerson.grid) ], "master_panel": this });
    var households_MembersByPerson_grid2939 = new Lino.households.MembersByPerson.GridPanel({ "flex": 66, "listeners": { "render": Lino.quicktip_renderer("Mitglied von","(households.households.MembersByPerson) ") }, "hide_top_toolbar": true, "containing_panel": this, "tools": [ Lino.show_in_own_window_button(Lino.households.MembersByPerson.grid) ], "master_panel": this });
    var misc_5_panel2940 = new Ext.Panel({ "flex": 38, "border": false, "layout": "hbox", "hideCheckBoxLabels": true, "items": [ contacts_RolesByPerson_grid2938, households_MembersByPerson_grid2939 ], "autoScroll": false, "layoutConfig": { "align": "stretch" }, "frame": false, "labelAlign": "top" });
    var misc_panel2941 = new Ext.Panel({ "layout": "vbox", "title": "Sonstiges", "items": [ misc_1_panel2917, misc_2_panel2924, misc_3_panel2930, misc_4_panel2935, misc_5_panel2940 ], "frame": true, "layoutConfig": { "align": "stretch" }, "hideCheckBoxLabels": true, "listeners": { "activate": Lino.on_tab_activate }, "autoScroll": false, "border": false, "bodyBorder": false, "labelAlign": "top" });
    var cbss_identify_person_disp2942 = new Ext.form.DisplayField({ "disabled": true, "listeners": { "render": Lino.quicktip_renderer("IdentifyPerson-Anfragen","(pcsw.Clients.cbss_identify_person) ") }, "fieldLabel": "IdentifyPerson-Anfragen", "name": "cbss_identify_person", "anchor": "-20", "value": "<br/>", "always_enabled": true });
    var cbss_manage_access_disp2943 = new Ext.form.DisplayField({ "disabled": true, "listeners": { "render": Lino.quicktip_renderer("ManageAccess-Anfragen","(pcsw.Clients.cbss_manage_access) ") }, "fieldLabel": "ManageAccess-Anfragen", "name": "cbss_manage_access", "anchor": "-20", "value": "<br/>", "always_enabled": true });
    var cbss_retrieve_ti_groups_disp2944 = new Ext.form.DisplayField({ "disabled": true, "listeners": { "render": Lino.quicktip_renderer("Tx25-Anfragen","(pcsw.Clients.cbss_retrieve_ti_groups) ") }, "fieldLabel": "Tx25-Anfragen", "name": "cbss_retrieve_ti_groups", "anchor": "-20", "value": "<br/>", "always_enabled": true });
    var cbss_1_panel2945 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 216, "hideCheckBoxLabels": true, "items": [ { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": cbss_identify_person_disp2942, "labelAlign": "top" }, { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": cbss_manage_access_disp2943, "labelAlign": "top" }, { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": cbss_retrieve_ti_groups_disp2944, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var cbss_summary_htmlbox2949 = new Lino.HtmlBoxPanel({ "flex": 50, "layout": "fit", "name": "cbss_summary", "containing_panel": this, "master_panel": this, "items": new Ext.BoxComponent({autoScroll:true}), "title": "Zusammenfassung ZDSS", "bodyStyle": "overflow-x:hidden;", "value": "<br/>", "always_enabled": true, "listeners": { "render": Lino.quicktip_renderer("Zusammenfassung ZDSS","(pcsw.Clients.cbss_summary) ") } });
    var cbss_panel2950 = new Ext.Panel({ "layout": "vbox", "title": "ZDSS", "items": [ cbss_1_panel2945, cbss_summary_htmlbox2949 ], "frame": true, "layoutConfig": { "align": "stretch" }, "hideCheckBoxLabels": true, "listeners": { "activate": Lino.on_tab_activate }, "autoScroll": false, "labelWidth": 189, "border": false, "bodyBorder": false, "labelAlign": "top" });
    var main_panel2954 = new Ext.TabPanel({ "hideCheckBoxLabels": true, "border": false, "split": true, "autoScroll": false, "items": [ general_panel2578, status_tab_panel2648, coaching_panel2690, competences_panel2786, pcsw_NotesByPerson_grid2869, calendar_panel2900, outbox_MailsByProject_grid2913, misc_panel2941, cbss_panel2950 ], "activeTab": 0, "bodyBorder": false, "frame": true, "labelAlign": "top" });
    this.items = main_panel2954;
    this.before_row_edit = function(record) {
      city2513.setContextValue('country',record ? record.data['countryHidden'] : undefined);
      city2513.setContextValue('region',record ? record.data['regionHidden'] : undefined);
      image_htmlbox2576.refresh();
      UploadsByController_htmlbox2645.refresh();
      newcomers_AvailableCoachesByClient_grid2670.on_master_changed();
      pcsw_ContactsByClient_grid2679.on_master_changed();
      pcsw_CoachingsByClient_grid2688.on_master_changed();
      pcsw_NotesByPerson_grid2869.on_master_changed();
      cal_EventsByProject_grid2876.on_master_changed();
      cal_TasksByProject_grid2899.on_master_changed();
      outbox_MailsByProject_grid2913.on_master_changed();
      contacts_RolesByPerson_grid2938.on_master_changed();
      households_MembersByPerson_grid2939.on_master_changed();
      cbss_summary_htmlbox2949.refresh();
    }
    this.onRender = function(ct, position) {
      country2512.on('change',Lino.chooser_handler(city2513,'country'));
      Lino.pcsw.Clients.DetailFormPanel.superclass.onRender.call(this, ct, position);
    }
    Lino.pcsw.Clients.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.cbss.RetrieveTIGroupsRequests.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 89,
  initComponent : function() {
    var containing_panel = this;
    var id3643 = new Ext.form.NumberField({ "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("ID","(cbss.RetrieveTIGroupsRequests.id) ") }, "fieldLabel": "ID", "anchor": "-20", "name": "id" });
    var person3644 = new Lino.TwinCombo({ "preferred_width": 20, "fieldLabel": "Klient", "allowBlank": false, "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.pcsw.Clients.detail)}, "emptyText": "Klient ausw\u00e4hlen...", "listeners": { "render": Lino.quicktip_renderer("Klient","(cbss.RetrieveTIGroupsRequests.person) ") }, "selectOnFocus": true, "hiddenName": "personHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cbss/RetrieveTIGroupsRequests/person", "method": "GET" }) }), "name": "person" });
    var user3645 = new Lino.TwinCombo({ "preferred_width": 15, "fieldLabel": "Autor", "allowBlank": false, "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.users.Users.detail)}, "emptyText": "Benutzer ausw\u00e4hlen...", "listeners": { "render": Lino.quicktip_renderer("Autor","(cbss.RetrieveTIGroupsRequests.user) ") }, "selectOnFocus": true, "hiddenName": "userHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cbss/RetrieveTIGroupsRequests/user", "method": "GET" }) }), "name": "user" });
    var environment3646 = new Ext.form.TextField({ "disabled": true, "listeners": { "render": Lino.quicktip_renderer("T/A/B","(cbss.RetrieveTIGroupsRequests.environment) ") }, "fieldLabel": "T/A/B", "name": "environment", "maxLength": 4, "boxMinWidth": Lino.chars2width(4), "anchor": "-20" });
    var sent3647 = new Ext.form.DisplayField({ "disabled": true, "listeners": { "render": Lino.quicktip_renderer("Versendet","(cbss.RetrieveTIGroupsRequests.sent) The date and time when this request has been executed. \nThis is empty for requests than haven't been sent.\nRead-only.") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Versendet</span>", "name": "sent", "anchor": "-20", "value": "<br>" });
    var status3648 = new Lino.ChoicesFieldElement({ "forceSelection": true, "fieldLabel": "Zustand", "name": "status", "hiddenName": "statusHidden", "disabled": true, "listeners": { "render": Lino.quicktip_renderer("Zustand","(cbss.RetrieveTIGroupsRequests.status) ") }, "anchor": "-20", "store": [['','<br>']].concat(Lino.cbss.RequestStates) });
    var ticket3649 = new Ext.form.TextField({ "disabled": true, "listeners": { "render": Lino.quicktip_renderer("Ticket","(cbss.RetrieveTIGroupsRequests.ticket) ") }, "fieldLabel": "Ticket", "name": "ticket", "maxLength": 36, "anchor": "-20" });
    var info_1_panel3650 = new Ext.form.FieldSet({ "autoHeight": true, "layout": "hbox", "title": "Info zur Anfrage", "layoutConfig": { "align": "stretchmax" }, "frame": false, "bodyBorder": true, "autoScroll": false, "items": [ { "flex": 5, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id3643, "labelAlign": "top" }, { "flex": 20, "autoHeight": true, "layout": "form", "xtype": "panel", "items": person3644, "labelAlign": "top" }, { "flex": 20, "autoHeight": true, "layout": "form", "xtype": "panel", "items": user3645, "labelAlign": "top" }, { "flex": 5, "autoHeight": true, "layout": "form", "xtype": "panel", "items": environment3646, "labelAlign": "top" }, { "flex": 16, "autoHeight": true, "layout": "form", "xtype": "panel", "items": sent3647, "labelAlign": "top" }, { "flex": 12, "autoHeight": true, "layout": "form", "xtype": "panel", "items": status3648, "labelAlign": "top" }, { "flex": 21, "autoHeight": true, "layout": "form", "xtype": "panel", "items": ticket3649, "labelAlign": "top" } ], "hideCheckBoxLabels": true, "labelWidth": 90, "border": false, "labelAlign": "top" });
    var national_id3658 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("NR-Nummer","(cbss.RetrieveTIGroupsRequests.national_id) ") }, "fieldLabel": "NR-Nummer", "name": "national_id", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var language3659 = new Lino.ChoicesFieldElement({ "forceSelection": true, "fieldLabel": "Sprache", "name": "language", "hiddenName": "languageHidden", "listeners": { "render": Lino.quicktip_renderer("Sprache","(cbss.RetrieveTIGroupsRequests.language) ") }, "selectOnFocus": true, "anchor": "-20", "store": [['','<br>']].concat(Lino.cbss.RequestLanguages) });
    var history3660 = new Ext.form.Checkbox({ "boxLabel": "Historie", "listeners": { "render": Lino.quicktip_renderer("Historie","(cbss.RetrieveTIGroupsRequests.history) Whatever this means.") }, "hideLabel": true, "checked": true, "name": "history", "selectOnFocus": true, "anchor": "-20" });
    var parameters_panel3661 = new Ext.form.FieldSet({ "autoHeight": true, "layout": "hbox", "title": "Parameter", "layoutConfig": { "align": "stretchmax" }, "frame": false, "bodyBorder": true, "autoScroll": false, "items": [ { "flex": 52, "autoHeight": true, "layout": "form", "xtype": "panel", "items": national_id3658, "labelAlign": "top" }, { "flex": 22, "autoHeight": true, "layout": "form", "xtype": "panel", "items": language3659, "labelAlign": "top" }, { "flex": 25, "autoHeight": true, "layout": "form", "xtype": "panel", "items": history3660, "labelAlign": "top" } ], "hideCheckBoxLabels": true, "labelWidth": 90, "border": false, "labelAlign": "top" });
    var cbss_RetrieveTIGroupsResult_grid3670 = new Lino.cbss.RetrieveTIGroupsResult.GridPanel({ "flex": 71, "listeners": { "render": Lino.quicktip_renderer("Resultate","(cbss.cbss.RetrieveTIGroupsResult) ") }, "hide_top_toolbar": true, "containing_panel": this, "tools": [ Lino.show_in_own_window_button(Lino.cbss.RetrieveTIGroupsResult.grid) ], "master_panel": this });
    var request_panel3671 = new Ext.Panel({ "layout": "vbox", "title": "Abfrage", "items": [ info_1_panel3650, parameters_panel3661, cbss_RetrieveTIGroupsResult_grid3670 ], "frame": true, "layoutConfig": { "align": "stretch" }, "hideCheckBoxLabels": true, "listeners": { "activate": Lino.on_tab_activate }, "autoScroll": false, "border": false, "bodyBorder": false, "labelAlign": "top" });
    var response_xml3672 = new Ext.form.TextArea({ "disabled": true, "listeners": { "render": Lino.quicktip_renderer("Antwort","(cbss.RetrieveTIGroupsRequests.response_xml) The raw XML response received. \n") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Antwort</span>", "name": "response_xml", "growMax": 2000, "anchor": "-20 -10" });
    var info_messages3673 = new Ext.form.TextArea({ "disabled": true, "listeners": { "render": Lino.quicktip_renderer("Info-Meldungen","(cbss.RetrieveTIGroupsRequests.info_messages) ") }, "fieldLabel": "Info-Meldungen", "name": "info_messages", "growMax": 2000, "anchor": "-20 -10" });
    var debug_messages3674 = new Ext.form.TextArea({ "disabled": true, "listeners": { "render": Lino.quicktip_renderer("Debug-Meldungen","(cbss.RetrieveTIGroupsRequests.debug_messages) ") }, "fieldLabel": "Debug-Meldungen", "name": "debug_messages", "growMax": 2000, "anchor": "-20 -10" });
    var technical_panel3675 = new Lino.VBorderPanel({ "autoScroll": false, "listeners": { "activate": Lino.on_tab_activate }, "border": false, "labelWidth": 144, "title": "Technisch", "hideCheckBoxLabels": true, "items": [ { "flex": 5, "layout": "form", "xtype": "panel", "items": response_xml3672, "region": "north", "labelAlign": "top", "split": true }, { "flex": 5, "layout": "form", "xtype": "panel", "items": info_messages3673, "region": "center", "labelAlign": "top", "split": true }, { "flex": 5, "layout": "form", "xtype": "panel", "items": debug_messages3674, "region": "south", "labelAlign": "top", "split": true } ], "frame": true, "bodyBorder": false, "labelAlign": "top" });
    var main_panel3679 = new Ext.TabPanel({ "hideCheckBoxLabels": true, "border": false, "split": true, "autoScroll": false, "items": [ request_panel3671, technical_panel3675 ], "activeTab": 0, "bodyBorder": false, "frame": true, "labelAlign": "top" });
    this.items = main_panel3679;
    this.before_row_edit = function(record) {
      cbss_RetrieveTIGroupsResult_grid3670.on_master_changed();
    }
    Lino.cbss.RetrieveTIGroupsRequests.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.cal.OneEvent.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 35,
  initComponent : function() {
    var containing_panel = this;
    var calendar1231 = new Lino.TwinCombo({ "fieldLabel": "Kalender", "name": "calendar", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.cal.Calendars.detail)}, "emptyText": "Kalender ausw\u00e4hlen...", "listeners": { "render": Lino.quicktip_renderer("Kalender","(cal.Events.calendar) ") }, "selectOnFocus": true, "hiddenName": "calendarHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/Events/calendar", "method": "GET" }) }) });
    var summary1232 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Kurzbeschreibung","(cal.Events.summary) ") }, "fieldLabel": "Kurzbeschreibung", "name": "summary", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var project1233 = new Lino.TwinCombo({ "preferred_width": 20, "fieldLabel": "Klient", "name": "project", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.pcsw.Clients.detail)}, "hiddenName": "projectHidden", "listeners": { "render": Lino.quicktip_renderer("Klient","(cal.Events.project) ") }, "selectOnFocus": true, "emptyText": "Klient ausw\u00e4hlen...", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/Events/project", "method": "GET" }) }) });
    var general_1_panel1234 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 153, "hideCheckBoxLabels": true, "items": [ { "flex": 32, "autoHeight": true, "layout": "form", "xtype": "panel", "items": calendar1231, "labelAlign": "top" }, { "flex": 34, "autoHeight": true, "layout": "form", "xtype": "panel", "items": summary1232, "labelAlign": "top" }, { "flex": 32, "autoHeight": true, "layout": "form", "xtype": "panel", "items": project1233, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var start_date1238 = new Lino.DateField({ "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Beginnt am","(cal.Events.start_date) ") }, "fieldLabel": "Beginnt am", "anchor": "-20", "name": "start_date" });
    var start_time1239 = new Lino.TimeField({ "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Beginnt um","(cal.Events.start_time) ") }, "fieldLabel": "Beginnt um", "anchor": "-20", "name": "start_time" });
    var start_panel1240 = new Ext.Panel({ "flex": 22, "autoHeight": true, "layout": "hbox", "items": [ { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": start_date1238, "labelAlign": "top" }, { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": start_time1239, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "autoScroll": false, "hideCheckBoxLabels": true, "labelWidth": 99, "border": false, "labelAlign": "top" });
    var end_date1243 = new Lino.DateField({ "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Endet am","(cal.Events.end_date) ") }, "fieldLabel": "Endet am", "anchor": "-20", "name": "end_date" });
    var end_time1244 = new Lino.TimeField({ "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Endet um","(cal.Events.end_time) ") }, "fieldLabel": "Endet um", "anchor": "-20", "name": "end_time" });
    var end_panel1245 = new Ext.Panel({ "flex": 22, "autoHeight": true, "layout": "hbox", "items": [ { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": end_date1243, "labelAlign": "top" }, { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": end_time1244, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "autoScroll": false, "hideCheckBoxLabels": true, "labelWidth": 81, "border": false, "labelAlign": "top" });
    var user1248 = new Lino.TwinCombo({ "preferred_width": 15, "fieldLabel": "Verantwortlicher", "name": "user", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.users.Users.detail)}, "hiddenName": "userHidden", "listeners": { "render": Lino.quicktip_renderer("Verantwortlicher","(cal.Events.user) ") }, "selectOnFocus": true, "emptyText": "Benutzer ausw\u00e4hlen...", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/Events/user", "method": "GET" }) }) });
    var assigned_to1249 = new Lino.TwinCombo({ "preferred_width": 15, "fieldLabel": "Zugewiesen zu", "name": "assigned_to", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.users.Users.detail)}, "hiddenName": "assigned_toHidden", "listeners": { "render": Lino.quicktip_renderer("Zugewiesen zu","(cal.Events.assigned_to) ") }, "selectOnFocus": true, "emptyText": "Benutzer ausw\u00e4hlen...", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/Events/assigned_to", "method": "GET" }) }) });
    var general_2_panel1250 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 153, "hideCheckBoxLabels": true, "items": [ start_panel1240, end_panel1245, { "flex": 27, "autoHeight": true, "layout": "form", "xtype": "panel", "items": user1248, "labelAlign": "top" }, { "flex": 27, "autoHeight": true, "layout": "form", "xtype": "panel", "items": assigned_to1249, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var room1253 = new Lino.TwinCombo({ "fieldLabel": "Raum", "name": "room", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.cal.Rooms.detail)}, "emptyText": "Raum ausw\u00e4hlen...", "listeners": { "render": Lino.quicktip_renderer("Raum","(cal.Events.room) ") }, "selectOnFocus": true, "hiddenName": "roomHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/Events/room", "method": "GET" }) }) });
    var priority1254 = new Lino.RemoteComboFieldElement({ "fieldLabel": "Priorit\u00e4t", "name": "priority", "pageSize": 20, "emptyText": "Priorit\u00e4t ausw\u00e4hlen...", "listeners": { "render": Lino.quicktip_renderer("Priorit\u00e4t","(cal.Events.priority) ") }, "selectOnFocus": true, "hiddenName": "priorityHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/Events/priority", "method": "GET" }) }) });
    var access_class1255 = new Lino.ChoicesFieldElement({ "forceSelection": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Zugriffsklasse</span>", "name": "access_class", "hiddenName": "access_classHidden", "listeners": { "render": Lino.quicktip_renderer("Zugriffsklasse","(cal.Events.access_class) Ob dieser Termin  privat, \u00f6ffentlich oder halb \u00f6ffentlich ist") }, "selectOnFocus": true, "anchor": "-20", "store": [['','<br>']].concat(Lino.cal.AccessClasses) });
    var transparent1256 = new Ext.form.Checkbox({ "boxLabel": "nicht blockierend", "listeners": { "render": Lino.quicktip_renderer("nicht blockierend","(cal.Events.transparent) Dieser Termin l\u00e4sst auch andere Termine zur gleichen Zeit zu.") }, "hideLabel": true, "checked": false, "name": "transparent", "selectOnFocus": true, "anchor": "-20" });
    var general_3_panel1257 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 162, "hideCheckBoxLabels": true, "items": [ { "flex": 32, "autoHeight": true, "layout": "form", "xtype": "panel", "items": room1253, "labelAlign": "top" }, { "flex": 32, "autoHeight": true, "layout": "form", "xtype": "panel", "items": priority1254, "labelAlign": "top" }, { "flex": 19, "autoHeight": true, "layout": "form", "xtype": "panel", "items": access_class1255, "labelAlign": "top" }, { "flex": 16, "autoHeight": true, "layout": "form", "xtype": "panel", "items": transparent1256, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var owner_disp1262 = new Ext.form.DisplayField({ "disabled": true, "fieldLabel": "Verkn\u00fcpft mit", "anchor": "-20", "name": "owner" });
    var workflow_buttons_disp1263 = new Ext.form.DisplayField({ "disabled": true, "listeners": { "render": Lino.quicktip_renderer("Arbeitsablauf","(cal.Events.workflow_buttons) ") }, "fieldLabel": "Arbeitsablauf", "name": "workflow_buttons", "anchor": "-20", "value": "<br/>", "always_enabled": true });
    var general_4_panel1264 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 126, "hideCheckBoxLabels": true, "items": [ { "flex": 25, "autoHeight": true, "layout": "form", "xtype": "panel", "items": owner_disp1262, "labelAlign": "top" }, { "flex": 75, "autoHeight": true, "layout": "form", "xtype": "panel", "items": workflow_buttons_disp1263, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var description1267 = new Lino.RichTextPanel({ "selectOnFocus": true, "flex": 46, "containing_panel": this, "name": "description", "title": "Beschreibung" });
    var GuestsByEvent_grid1312 = new Lino.cal.GuestsByEvent.GridPanel({ "flex": 53, "listeners": { "render": Lino.quicktip_renderer("G\u00e4ste","(cal.cal.GuestsByEvent) ") }, "hide_top_toolbar": true, "containing_panel": this, "tools": [ Lino.show_in_own_window_button(Lino.cal.GuestsByEvent.grid) ], "master_panel": this });
    var general_5_panel1313 = new Ext.Panel({ "flex": 45, "border": false, "layout": "hbox", "labelWidth": 0, "hideCheckBoxLabels": true, "items": [ description1267, GuestsByEvent_grid1312 ], "autoScroll": false, "layoutConfig": { "align": "stretch" }, "frame": false, "labelAlign": "top" });
    var general_panel1314 = new Ext.Panel({ "layout": "vbox", "title": "Allgemein", "items": [ general_1_panel1234, general_2_panel1250, general_3_panel1257, general_4_panel1264, general_5_panel1313 ], "frame": true, "layoutConfig": { "align": "stretch" }, "hideCheckBoxLabels": true, "listeners": { "activate": Lino.on_tab_activate }, "autoScroll": false, "border": false, "bodyBorder": false, "labelAlign": "top" });
    var id1315 = new Ext.form.NumberField({ "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("ID","(cal.Events.id) ") }, "fieldLabel": "ID", "anchor": "-20", "name": "id" });
    var created1316 = new Ext.form.DisplayField({ "disabled": true, "listeners": { "render": Lino.quicktip_renderer("Erstellt","(cal.Events.created) ") }, "fieldLabel": "Erstellt", "name": "created", "anchor": "-20", "value": "<br>" });
    var modified1317 = new Ext.form.DisplayField({ "disabled": true, "listeners": { "render": Lino.quicktip_renderer("Bearbeitet","(cal.Events.modified) ") }, "fieldLabel": "Bearbeitet", "name": "modified", "anchor": "-20", "value": "<br>" });
    var state1318 = new Lino.ChoicesFieldElement({ "forceSelection": true, "fieldLabel": "Zustand", "allowBlank": false, "hiddenName": "stateHidden", "listeners": { "render": Lino.quicktip_renderer("Zustand","(cal.Events.state) ") }, "selectOnFocus": true, "anchor": "-20", "store": Lino.cal.EventStates, "name": "state" });
    var more_1_panel1319 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 99, "hideCheckBoxLabels": true, "items": [ { "flex": 8, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id1315, "labelAlign": "top" }, { "flex": 34, "autoHeight": true, "layout": "form", "xtype": "panel", "items": created1316, "labelAlign": "top" }, { "flex": 34, "autoHeight": true, "layout": "form", "xtype": "panel", "items": modified1317, "labelAlign": "top" }, { "flex": 22, "autoHeight": true, "layout": "form", "xtype": "panel", "items": state1318, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var outbox_MailsByController_grid1324 = new Lino.outbox.MailsByController.GridPanel({ "flex": 83, "listeners": { "render": Lino.quicktip_renderer("E-Mail-Ausg\u00e4nge","(outbox.outbox.MailsByController) ") }, "hide_top_toolbar": true, "containing_panel": this, "tools": [ Lino.show_in_own_window_button(Lino.outbox.MailsByController.grid) ], "master_panel": this });
    var more_panel1325 = new Ext.Panel({ "layout": "vbox", "title": "Mehr", "items": [ more_1_panel1319, outbox_MailsByController_grid1324 ], "frame": true, "layoutConfig": { "align": "stretch" }, "hideCheckBoxLabels": true, "listeners": { "activate": Lino.on_tab_activate }, "autoScroll": false, "border": false, "bodyBorder": false, "labelAlign": "top" });
    var main_panel1326 = new Ext.TabPanel({ "hideCheckBoxLabels": true, "border": false, "split": true, "autoScroll": false, "items": [ general_panel1314, more_panel1325 ], "activeTab": 0, "bodyBorder": false, "frame": true, "labelAlign": "top" });
    this.items = main_panel1326;
    this.before_row_edit = function(record) {
      description1267.refresh();
      GuestsByEvent_grid1312.on_master_changed();
      outbox_MailsByController_grid1324.on_master_changed();
    }
    Lino.cal.OneEvent.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.cal.OneEvent.InsertFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  autoHeight: true,
  content_type: 35,
  initComponent : function() {
    var containing_panel = this;
    var summary1327 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Kurzbeschreibung","(cal.Events.summary) ") }, "fieldLabel": "Kurzbeschreibung", "name": "summary", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var start_date1328 = new Lino.DateField({ "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Beginnt am","(cal.Events.start_date) ") }, "fieldLabel": "Beginnt am", "anchor": "-20", "name": "start_date" });
    var start_time1329 = new Lino.TimeField({ "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Beginnt um","(cal.Events.start_time) ") }, "fieldLabel": "Beginnt um", "anchor": "-20", "name": "start_time" });
    var start_panel1330 = new Ext.Panel({ "flex": 50, "autoHeight": true, "layout": "hbox", "items": [ { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": start_date1328, "labelAlign": "top" }, { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": start_time1329, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "autoScroll": false, "hideCheckBoxLabels": true, "labelWidth": 99, "border": false, "labelAlign": "top" });
    var end_date1333 = new Lino.DateField({ "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Endet am","(cal.Events.end_date) ") }, "fieldLabel": "Endet am", "anchor": "-20", "name": "end_date" });
    var end_time1334 = new Lino.TimeField({ "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Endet um","(cal.Events.end_time) ") }, "fieldLabel": "Endet um", "anchor": "-20", "name": "end_time" });
    var end_panel1335 = new Ext.Panel({ "flex": 50, "autoHeight": true, "layout": "hbox", "items": [ { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": end_date1333, "labelAlign": "top" }, { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": end_time1334, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "autoScroll": false, "hideCheckBoxLabels": true, "labelWidth": 81, "border": false, "labelAlign": "top" });
    var main_2_panel1338 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "hideCheckBoxLabels": true, "items": [ start_panel1330, end_panel1335 ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "anchor": "-20", "labelAlign": "top" });
    var calendar1339 = new Lino.TwinCombo({ "fieldLabel": "Kalender", "name": "calendar", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.cal.Calendars.detail)}, "emptyText": "Kalender ausw\u00e4hlen...", "listeners": { "render": Lino.quicktip_renderer("Kalender","(cal.Events.calendar) ") }, "selectOnFocus": true, "hiddenName": "calendarHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/Events/calendar", "method": "GET" }) }) });
    var project1340 = new Lino.TwinCombo({ "preferred_width": 20, "fieldLabel": "Klient", "name": "project", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.pcsw.Clients.detail)}, "hiddenName": "projectHidden", "listeners": { "render": Lino.quicktip_renderer("Klient","(cal.Events.project) ") }, "selectOnFocus": true, "emptyText": "Klient ausw\u00e4hlen...", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/Events/project", "method": "GET" }) }) });
    var main_3_panel1341 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": calendar1339, "labelAlign": "top" }, { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": project1340, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 81, "border": false, "anchor": "-20", "labelAlign": "top" });
    var main_panel1344 = new Ext.Panel({ "hideCheckBoxLabels": true, "autoHeight": true, "border": false, "layout": "form", "labelWidth": 153, "autoScroll": false, "items": [ { "autoHeight": true, "layout": "form", "xtype": "panel", "items": summary1327, "anchor": "-20", "labelAlign": "top" }, main_2_panel1338, main_3_panel1341 ], "frame": true, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel1344;
    this.before_row_edit = function(record) {
    }
    Lino.cal.OneEvent.InsertFormPanel.superclass.initComponent.call(this);
  }
});


Lino.contacts.Persons.InsertFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  autoHeight: true,
  content_type: 20,
  initComponent : function() {
    var containing_panel = this;
    var title1113 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Anrede","(contacts.Persons.title) ") }, "fieldLabel": "Anrede", "name": "title", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var first_name1114 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Vorname","(contacts.Persons.first_name) ") }, "fieldLabel": "Vorname", "name": "first_name", "maxLength": 200, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var last_name1115 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Familienname","(contacts.Persons.last_name) ") }, "fieldLabel": "Familienname", "name": "last_name", "maxLength": 200, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var main_1_panel1116 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": title1113, "labelAlign": "top" }, { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": first_name1114, "labelAlign": "top" }, { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": last_name1115, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 117, "border": false, "anchor": "-20", "labelAlign": "top" });
    var gender1120 = new Lino.ChoicesFieldElement({ "forceSelection": true, "fieldLabel": "Geschlecht", "name": "gender", "hiddenName": "genderHidden", "listeners": { "render": Lino.quicktip_renderer("Geschlecht","(contacts.Persons.gender) ") }, "selectOnFocus": true, "anchor": "-20", "store": [['','<br>']].concat(Lino.lino.Genders) });
    var language1121 = new Lino.ChoicesFieldElement({ "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Sprache</span>", "allowBlank": false, "hiddenName": "languageHidden", "listeners": { "render": Lino.quicktip_renderer("Sprache","(contacts.Persons.language) Die Sprache, in der Dokumente ausgestellt werden sollen.") }, "selectOnFocus": true, "anchor": "-20", "store": [ [ "en", "Englisch" ], [ "fr", "Franz\u00f6sisch" ], [ "de", "Deutsch" ], [ "nl", "Niederl\u00e4ndisch" ] ], "name": "language" });
    var main_2_panel1122 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 31, "autoHeight": true, "layout": "form", "xtype": "panel", "items": gender1120, "labelAlign": "top" }, { "flex": 68, "autoHeight": true, "layout": "form", "xtype": "panel", "items": language1121, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 99, "border": false, "anchor": "-20", "labelAlign": "top" });
    var main_panel1125 = new Ext.Panel({ "hideCheckBoxLabels": true, "autoHeight": true, "border": false, "layout": "form", "autoScroll": false, "items": [ main_1_panel1116, main_2_panel1122 ], "frame": true, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel1125;
    this.before_row_edit = function(record) {
    }
    Lino.contacts.Persons.InsertFormPanel.superclass.initComponent.call(this);
  }
});


Lino.contacts.Partners.InsertFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  autoHeight: true,
  content_type: 22,
  initComponent : function() {
    var containing_panel = this;
    var name735 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Name","(contacts.Partners.name) ") }, "fieldLabel": "Name", "name": "name", "maxLength": 200, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var language736 = new Lino.ChoicesFieldElement({ "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Sprache</span>", "allowBlank": false, "hiddenName": "languageHidden", "listeners": { "render": Lino.quicktip_renderer("Sprache","(contacts.Partners.language) Die Sprache, in der Dokumente ausgestellt werden sollen.") }, "selectOnFocus": true, "anchor": "-20", "store": [ [ "en", "Englisch" ], [ "fr", "Franz\u00f6sisch" ], [ "de", "Deutsch" ], [ "nl", "Niederl\u00e4ndisch" ] ], "name": "language" });
    var email737 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("E-Mail","(contacts.Partners.email) ") }, "fieldLabel": "E-Mail", "name": "email", "maxLength": 75, "selectOnFocus": true, "anchor": "-20" });
    var main_2_panel738 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 48, "autoHeight": true, "layout": "form", "xtype": "panel", "items": language736, "labelAlign": "top" }, { "flex": 51, "autoHeight": true, "layout": "form", "xtype": "panel", "items": email737, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 72, "border": false, "anchor": "-20", "labelAlign": "top" });
    var main_panel741 = new Ext.Panel({ "hideCheckBoxLabels": true, "autoHeight": true, "border": false, "layout": "form", "labelWidth": 45, "autoScroll": false, "items": [ { "autoHeight": true, "layout": "form", "xtype": "panel", "items": name735, "anchor": "-20", "labelAlign": "top" }, main_2_panel738 ], "frame": true, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel741;
    this.before_row_edit = function(record) {
    }
    Lino.contacts.Partners.InsertFormPanel.superclass.initComponent.call(this);
  }
});


Lino.system.MyTextFieldTemplates.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 2,
  initComponent : function() {
    var containing_panel = this;
    var id216 = new Ext.form.NumberField({ "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("ID","(system.TextFieldTemplates.id) ") }, "fieldLabel": "ID", "anchor": "-20", "name": "id" });
    var name217 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Bezeichnung","(system.TextFieldTemplates.name) ") }, "fieldLabel": "Bezeichnung", "name": "name", "maxLength": 200, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var user218 = new Lino.TwinCombo({ "preferred_width": 15, "fieldLabel": "Autor", "name": "user", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.users.Users.detail)}, "hiddenName": "userHidden", "listeners": { "render": Lino.quicktip_renderer("Autor","(system.TextFieldTemplates.user) ") }, "selectOnFocus": true, "emptyText": "Benutzer ausw\u00e4hlen...", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/system/TextFieldTemplates/user", "method": "GET" }) }) });
    var team219 = new Lino.RemoteComboFieldElement({ "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Team</span>", "name": "team", "pageSize": 20, "emptyText": "Team ausw\u00e4hlen...", "listeners": { "render": Lino.quicktip_renderer("Team","(system.TextFieldTemplates.team) If not empty, then this template is reserved to members of this team.") }, "selectOnFocus": true, "hiddenName": "teamHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/system/TextFieldTemplates/team", "method": "GET" }) }) });
    var main_1_panel220 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 7, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id216, "labelAlign": "top" }, { "flex": 31, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name217, "labelAlign": "top" }, { "flex": 30, "autoHeight": true, "layout": "form", "xtype": "panel", "items": user218, "labelAlign": "top" }, { "flex": 30, "autoHeight": true, "layout": "form", "xtype": "panel", "items": team219, "labelAlign": "top" } ], "region": "north", "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "split": true, "autoScroll": false, "labelWidth": 108, "border": false, "frame": false, "labelAlign": "top" });
    var description225 = new Ext.form.TextArea({ "listeners": { "render": Lino.quicktip_renderer("Beschreibung","(system.TextFieldTemplates.description) ") }, "fieldLabel": "Beschreibung", "name": "description", "growMax": 2000, "selectOnFocus": true, "anchor": "-20 -10" });
    var text226 = new Lino.RichTextPanel({ "flex": 5, "split": true, "containing_panel": this, "selectOnFocus": true, "region": "south", "title": "Vorlagentext", "name": "text" });
    var main_panel227 = new Lino.VBorderPanel({ "autoScroll": false, "border": false, "labelWidth": 117, "hideCheckBoxLabels": true, "items": [ main_1_panel220, { "flex": 5, "layout": "form", "xtype": "panel", "items": description225, "region": "center", "labelAlign": "top", "split": true }, text226 ], "frame": true, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel227;
    this.before_row_edit = function(record) {
      text226.refresh();
    }
    Lino.system.MyTextFieldTemplates.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.outbox.MyOutbox.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 26,
  initComponent : function() {
    var containing_panel = this;
    var subject954 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Betreff","(outbox.Mails.subject) ") }, "fieldLabel": "Betreff", "name": "subject", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var project955 = new Lino.TwinCombo({ "preferred_width": 20, "fieldLabel": "Klient", "name": "project", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.pcsw.Clients.detail)}, "hiddenName": "projectHidden", "listeners": { "render": Lino.quicktip_renderer("Klient","(outbox.Mails.project) ") }, "selectOnFocus": true, "emptyText": "Klient ausw\u00e4hlen...", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/outbox/Mails/project", "method": "GET" }) }) });
    var date956 = new Lino.DateField({ "listeners": { "render": Lino.quicktip_renderer("Datum","(outbox.Mails.date) \n        The official date to be printed on the document.\n        ") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Datum</span>", "name": "date", "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var main_1_panel957 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 72, "hideCheckBoxLabels": true, "items": [ { "flex": 42, "autoHeight": true, "layout": "form", "xtype": "panel", "items": subject954, "labelAlign": "top" }, { "flex": 40, "autoHeight": true, "layout": "form", "xtype": "panel", "items": project955, "labelAlign": "top" }, { "flex": 16, "autoHeight": true, "layout": "form", "xtype": "panel", "items": date956, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var user961 = new Lino.TwinCombo({ "preferred_width": 15, "fieldLabel": "Absender", "name": "user", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.users.Users.detail)}, "hiddenName": "userHidden", "listeners": { "render": Lino.quicktip_renderer("Absender","(outbox.Mails.user) ") }, "selectOnFocus": true, "emptyText": "Benutzer ausw\u00e4hlen...", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/outbox/Mails/user", "method": "GET" }) }) });
    var sent962 = new Ext.form.DisplayField({ "disabled": true, "listeners": { "render": Lino.quicktip_renderer("sent","(outbox.Mails.sent) ") }, "fieldLabel": "sent", "name": "sent", "anchor": "-20", "value": "<br>" });
    var id963 = new Ext.form.NumberField({ "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("ID","(outbox.Mails.id) ") }, "fieldLabel": "ID", "anchor": "-20", "name": "id" });
    var owner_disp964 = new Ext.form.DisplayField({ "disabled": true, "fieldLabel": "Verkn\u00fcpft mit", "anchor": "-20", "name": "owner" });
    var main_2_panel965 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 126, "hideCheckBoxLabels": true, "items": [ { "flex": 39, "autoHeight": true, "layout": "form", "xtype": "panel", "items": user961, "labelAlign": "top" }, { "flex": 31, "autoHeight": true, "layout": "form", "xtype": "panel", "items": sent962, "labelAlign": "top" }, { "flex": 9, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id963, "labelAlign": "top" }, { "flex": 19, "autoHeight": true, "layout": "form", "xtype": "panel", "items": owner_disp964, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var RecipientsByMail_grid976 = new Lino.outbox.RecipientsByMail.GridPanel({ "flex": 55, "listeners": { "render": Lino.quicktip_renderer("Empf\u00e4nger","(outbox.outbox.RecipientsByMail) ") }, "hide_top_toolbar": true, "containing_panel": this, "tools": [ Lino.show_in_own_window_button(Lino.outbox.RecipientsByMail.grid) ], "master_panel": this });
    var AttachmentsByMail_htmlbox977 = new Lino.HtmlBoxPanel({ "flex": 22, "layout": "fit", "name": "AttachmentsByMail", "containing_panel": this, "items": new Ext.BoxComponent({autoScroll:true}), "title": "Anh\u00e4nge", "master_panel": this, "value": "<br/>", "always_enabled": true, "listeners": { "render": Lino.quicktip_renderer("Anh\u00e4nge","(outbox.Mails.AttachmentsByMail) ") }, "bodyStyle": "overflow-x:hidden;", "tools": [ Lino.show_in_own_window_button(Lino.outbox.AttachmentsByMail.grid) ] });
    var UploadsByController_htmlbox978 = new Lino.HtmlBoxPanel({ "flex": 22, "ls_bbar_actions": [ { "itemId": "insert", "menu_item_text": "Neu", "must_save": true, "tooltip": "Neuen Datensatz erstellen", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-new", "overflowText": "Neu", "auto_save": true } ], "name": "UploadsByController", "containing_panel": this, "items": new Ext.BoxComponent({autoScroll:true}), "title": "Uploads", "master_panel": this, "value": "<br/>", "always_enabled": true, "listeners": { "render": Lino.quicktip_renderer("Uploads","(outbox.Mails.UploadsByController) ") }, "bodyStyle": "overflow-x:hidden;", "ls_insert_handler": Lino.uploads.UploadsByController.insert, "layout": "fit", "tools": [ Lino.show_in_own_window_button(Lino.uploads.UploadsByController.grid) ] });
    var main_3_panel979 = new Ext.Panel({ "flex": 29, "border": false, "layout": "hbox", "labelWidth": 72, "hideCheckBoxLabels": true, "items": [ RecipientsByMail_grid976, AttachmentsByMail_htmlbox977, UploadsByController_htmlbox978 ], "autoScroll": false, "layoutConfig": { "align": "stretch" }, "frame": false, "labelAlign": "top" });
    var body980 = new Lino.RichTextPanel({ "selectOnFocus": true, "flex": 58, "containing_panel": this, "name": "body", "title": "Inhalt" });
    var main_panel981 = new Ext.Panel({ "autoScroll": false, "border": false, "layout": "vbox", "labelWidth": 0, "hideCheckBoxLabels": true, "items": [ main_1_panel957, main_2_panel965, main_3_panel979, body980 ], "frame": true, "layoutConfig": { "align": "stretch" }, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel981;
    this.before_row_edit = function(record) {
      RecipientsByMail_grid976.on_master_changed();
      AttachmentsByMail_htmlbox977.refresh();
      UploadsByController_htmlbox978.refresh();
      body980.refresh();
    }
    Lino.outbox.MyOutbox.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.cal.MyPresences.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 36,
  initComponent : function() {
    var containing_panel = this;
    var event1289 = new Lino.TwinCombo({ "fieldLabel": "Termin", "allowBlank": false, "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.cal.OneEvent.detail)}, "emptyText": "Termin ausw\u00e4hlen...", "listeners": { "render": Lino.quicktip_renderer("Termin","(cal.Guests.event) ") }, "selectOnFocus": true, "hiddenName": "eventHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/Guests/event", "method": "GET" }) }), "name": "event" });
    var partner1290 = new Lino.TwinCombo({ "preferred_width": 20, "fieldLabel": "Partner", "allowBlank": false, "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.contacts.Partners.detail)}, "emptyText": "Partner ausw\u00e4hlen...", "listeners": { "render": Lino.quicktip_renderer("Partner","(cal.Guests.partner) ") }, "selectOnFocus": true, "hiddenName": "partnerHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/Guests/partner", "method": "GET" }) }), "name": "partner" });
    var role1291 = new Lino.TwinCombo({ "fieldLabel": "Rolle", "name": "role", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.cal.GuestRoles.detail)}, "emptyText": "Gastrolle ausw\u00e4hlen...", "listeners": { "render": Lino.quicktip_renderer("Rolle","(cal.Guests.role) ") }, "selectOnFocus": true, "hiddenName": "roleHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/Guests/role", "method": "GET" }) }) });
    var main_1_panel1292 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 72, "hideCheckBoxLabels": true, "items": [ { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": event1289, "labelAlign": "top" }, { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": partner1290, "labelAlign": "top" }, { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": role1291, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var state1296 = new Lino.ChoicesFieldElement({ "forceSelection": true, "fieldLabel": "Zustand", "allowBlank": false, "hiddenName": "stateHidden", "listeners": { "render": Lino.quicktip_renderer("Zustand","(cal.Guests.state) ") }, "selectOnFocus": true, "anchor": "-20", "store": Lino.cal.GuestStates, "name": "state" });
    var remark1297 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Bemerkung","(cal.Guests.remark) ") }, "fieldLabel": "Bemerkung", "name": "remark", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var workflow_buttons_disp1298 = new Ext.form.DisplayField({ "disabled": true, "listeners": { "render": Lino.quicktip_renderer("Arbeitsablauf","(cal.Guests.workflow_buttons) ") }, "fieldLabel": "Arbeitsablauf", "name": "workflow_buttons", "anchor": "-20", "value": "<br/>", "always_enabled": true });
    var main_2_panel1299 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 126, "hideCheckBoxLabels": true, "items": [ { "flex": 17, "autoHeight": true, "layout": "form", "xtype": "panel", "items": state1296, "labelAlign": "top" }, { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": remark1297, "labelAlign": "top" }, { "flex": 48, "autoHeight": true, "layout": "form", "xtype": "panel", "items": workflow_buttons_disp1298, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var outbox_MailsByController_grid1303 = new Lino.outbox.MailsByController.GridPanel({ "flex": 55, "listeners": { "render": Lino.quicktip_renderer("E-Mail-Ausg\u00e4nge","(outbox.outbox.MailsByController) ") }, "hide_top_toolbar": true, "containing_panel": this, "tools": [ Lino.show_in_own_window_button(Lino.outbox.MailsByController.grid) ], "master_panel": this });
    var main_panel1304 = new Ext.Panel({ "autoScroll": false, "border": false, "layout": "vbox", "hideCheckBoxLabels": true, "items": [ main_1_panel1292, main_2_panel1299, outbox_MailsByController_grid1303 ], "frame": true, "layoutConfig": { "align": "stretch" }, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel1304;
    this.before_row_edit = function(record) {
      outbox_MailsByController_grid1303.on_master_changed();
    }
    Lino.cal.MyPresences.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.changes.ChangesByMaster.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 10,
  disable_editing: true,
  initComponent : function() {
    var containing_panel = this;
    var time417 = new Ext.form.DisplayField({ "listeners": { "render": Lino.quicktip_renderer("time","(changes.Changes.time) ") }, "fieldLabel": "time", "name": "time", "selectOnFocus": true, "anchor": "-20", "value": "<br>", "allowBlank": false });
    var user418 = new Lino.TwinCombo({ "preferred_width": 15, "fieldLabel": "Benutzer", "allowBlank": false, "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.users.Users.detail)}, "emptyText": "Benutzer ausw\u00e4hlen...", "listeners": { "render": Lino.quicktip_renderer("Benutzer","(changes.Changes.user) ") }, "selectOnFocus": true, "hiddenName": "userHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/changes/Changes/user", "method": "GET" }) }), "name": "user" });
    var type419 = new Lino.ChoicesFieldElement({ "forceSelection": true, "fieldLabel": "\u00c4nderungsart", "allowBlank": false, "hiddenName": "typeHidden", "listeners": { "render": Lino.quicktip_renderer("\u00c4nderungsart","(changes.Changes.type) ") }, "selectOnFocus": true, "anchor": "-20", "store": Lino.lino.ChangeTypes, "name": "type" });
    var master_disp420 = new Ext.form.DisplayField({ "disabled": true, "fieldLabel": "Stammdaten", "anchor": "-20", "name": "master" });
    var object_disp421 = new Ext.form.DisplayField({ "disabled": true, "fieldLabel": "Object", "anchor": "-20", "name": "object" });
    var id422 = new Ext.form.NumberField({ "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("ID","(changes.Changes.id) ") }, "fieldLabel": "ID", "anchor": "-20", "name": "id" });
    var main_1_panel423 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 117, "hideCheckBoxLabels": true, "items": [ { "flex": 21, "autoHeight": true, "layout": "form", "xtype": "panel", "items": time417, "labelAlign": "top" }, { "flex": 26, "autoHeight": true, "layout": "form", "xtype": "panel", "items": user418, "labelAlign": "top" }, { "flex": 19, "autoHeight": true, "layout": "form", "xtype": "panel", "items": type419, "labelAlign": "top" }, { "flex": 13, "autoHeight": true, "layout": "form", "xtype": "panel", "items": master_disp420, "labelAlign": "top" }, { "flex": 13, "autoHeight": true, "layout": "form", "xtype": "panel", "items": object_disp421, "labelAlign": "top" }, { "flex": 6, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id422, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var diff430 = new Ext.form.TextArea({ "listeners": { "render": Lino.quicktip_renderer("\u00c4nderungen","(changes.Changes.diff) ") }, "fieldLabel": "\u00c4nderungen", "name": "diff", "growMax": 2000, "selectOnFocus": true, "anchor": "-20 -10" });
    var main_panel431 = new Ext.Panel({ "autoScroll": false, "border": false, "layout": "vbox", "labelWidth": 99, "hideCheckBoxLabels": true, "items": [ main_1_panel423, { "items": diff430, "labelAlign": "top", "layout": "form", "xtype": "panel", "flex": 83 } ], "frame": true, "layoutConfig": { "align": "stretch" }, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel431;
    this.before_row_edit = function(record) {
    }
    Lino.changes.ChangesByMaster.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.contacts.Persons.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 20,
  initComponent : function() {
    var containing_panel = this;
    var last_name1026 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Familienname","(contacts.Persons.last_name) ") }, "fieldLabel": "Familienname", "name": "last_name", "maxLength": 200, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var first_name1027 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Vorname","(contacts.Persons.first_name) ") }, "fieldLabel": "Vorname", "name": "first_name", "maxLength": 200, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var gender1028 = new Lino.ChoicesFieldElement({ "forceSelection": true, "fieldLabel": "Geschlecht", "name": "gender", "hiddenName": "genderHidden", "listeners": { "render": Lino.quicktip_renderer("Geschlecht","(contacts.Persons.gender) ") }, "selectOnFocus": true, "anchor": "-20", "store": [['','<br>']].concat(Lino.lino.Genders) });
    var title1029 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Anrede","(contacts.Persons.title) ") }, "fieldLabel": "Anrede", "name": "title", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var name_box_panel1030 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 38, "autoHeight": true, "layout": "form", "xtype": "panel", "items": last_name1026, "labelAlign": "top" }, { "flex": 27, "autoHeight": true, "layout": "form", "xtype": "panel", "items": first_name1027, "labelAlign": "top" }, { "flex": 16, "autoHeight": true, "layout": "form", "xtype": "panel", "items": gender1028, "labelAlign": "top" }, { "flex": 18, "autoHeight": true, "layout": "form", "xtype": "panel", "items": title1029, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 117, "border": false, "anchor": "-20", "labelAlign": "top" });
    var country1035 = new Lino.TwinCombo({ "fieldLabel": "Land", "name": "country", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.countries.Countries.detail)}, "emptyText": "Land ausw\u00e4hlen...", "listeners": { "render": Lino.quicktip_renderer("Land","(contacts.Persons.country) ") }, "selectOnFocus": true, "hiddenName": "countryHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/contacts/Persons/country", "method": "GET" }) }) });
    var region1036 = new Lino.TwinCombo({ "fieldLabel": "Region", "name": "region", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.countries.Cities.detail)}, "emptyText": "Ort ausw\u00e4hlen...", "listeners": { "render": Lino.quicktip_renderer("Region","(contacts.Persons.region) ") }, "selectOnFocus": true, "hiddenName": "regionHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/contacts/Persons/region", "method": "GET" }) }) });
    var city1037 = new Lino.TwinCombo({ "forceSelection": false, "fieldLabel": "Ort", "name": "city", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.countries.Cities.detail)}, "emptyText": "Ort ausw\u00e4hlen...", "listeners": { "render": Lino.quicktip_renderer("Ort","(contacts.Persons.city) ") }, "selectOnFocus": true, "hiddenName": "cityHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/contacts/Persons/city", "method": "GET" }) }) });
    var zip_code1038 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Postleitzahl","(contacts.Persons.zip_code) ") }, "fieldLabel": "Postleitzahl", "name": "zip_code", "maxLength": 10, "selectOnFocus": true, "boxMinWidth": Lino.chars2width(10), "anchor": "-20" });
    var address_box_2_panel1039 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 28, "autoHeight": true, "layout": "form", "xtype": "panel", "items": country1035, "labelAlign": "top" }, { "flex": 28, "autoHeight": true, "layout": "form", "xtype": "panel", "items": region1036, "labelAlign": "top" }, { "flex": 28, "autoHeight": true, "layout": "form", "xtype": "panel", "items": city1037, "labelAlign": "top" }, { "flex": 14, "autoHeight": true, "layout": "form", "xtype": "panel", "items": zip_code1038, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 117, "border": false, "anchor": "-20", "labelAlign": "top" });
    var addr11044 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Adresszeile vor Stra\u00dfe","(contacts.Persons.addr1) Address line before street") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Adresszeile vor Stra\u00dfe</span>", "name": "addr1", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var street_prefix1045 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Pr\u00e4fix Stra\u00dfe","(contacts.Persons.street_prefix) Text to print before name of street, but to ignore for sorting.") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Pr\u00e4fix Stra\u00dfe</span>", "name": "street_prefix", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var street1046 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Stra\u00dfe","(contacts.Persons.street) Name of street. Without house number.") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Stra\u00dfe</span>", "name": "street", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var street_no1047 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Nr.","(contacts.Persons.street_no) House number") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Nr.</span>", "name": "street_no", "maxLength": 10, "selectOnFocus": true, "boxMinWidth": Lino.chars2width(10), "anchor": "-20" });
    var street_box1048 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Box","(contacts.Persons.street_box) Text to print after :attr:`steet_no` on the same line") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Box</span>", "name": "street_box", "maxLength": 10, "selectOnFocus": true, "boxMinWidth": Lino.chars2width(10), "anchor": "-20" });
    var address_box_4_panel1049 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 30, "autoHeight": true, "layout": "form", "xtype": "panel", "items": street_prefix1045, "labelAlign": "top" }, { "flex": 36, "autoHeight": true, "layout": "form", "xtype": "panel", "items": street1046, "labelAlign": "top" }, { "flex": 16, "autoHeight": true, "layout": "form", "xtype": "panel", "items": street_no1047, "labelAlign": "top" }, { "flex": 16, "autoHeight": true, "layout": "form", "xtype": "panel", "items": street_box1048, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 126, "border": false, "anchor": "-20", "labelAlign": "top" });
    var addr21054 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Adresszeile nach Stra\u00dfe","(contacts.Persons.addr2) Address line to print below street line") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Adresszeile nach Stra\u00dfe</span>", "name": "addr2", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var address_box_panel1055 = new Ext.form.FieldSet({ "flex": 66, "autoHeight": true, "layout": "form", "title": "Adresse", "items": [ name_box_panel1030, address_box_2_panel1039, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": addr11044, "anchor": "-20", "labelAlign": "top" }, address_box_4_panel1049, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": addr21054, "anchor": "-20", "labelAlign": "top" } ], "frame": true, "bodyBorder": false, "autoScroll": false, "hideCheckBoxLabels": true, "labelWidth": 216, "border": false, "labelAlign": "top" });
    var id1058 = new Ext.form.NumberField({ "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("ID","(contacts.Persons.id) ") }, "fieldLabel": "ID", "anchor": "-20", "name": "id" });
    var language1059 = new Lino.ChoicesFieldElement({ "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Sprache</span>", "allowBlank": false, "hiddenName": "languageHidden", "listeners": { "render": Lino.quicktip_renderer("Sprache","(contacts.Persons.language) Die Sprache, in der Dokumente ausgestellt werden sollen.") }, "selectOnFocus": true, "anchor": "-20", "store": [ [ "en", "Englisch" ], [ "fr", "Franz\u00f6sisch" ], [ "de", "Deutsch" ], [ "nl", "Niederl\u00e4ndisch" ] ], "name": "language" });
    var info_box_panel1060 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id1058, "labelAlign": "top" }, { "flex": 66, "autoHeight": true, "layout": "form", "xtype": "panel", "items": language1059, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 72, "border": false, "anchor": "-20", "labelAlign": "top" });
    var email1063 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("E-Mail","(contacts.Persons.email) ") }, "fieldLabel": "E-Mail", "name": "email", "maxLength": 75, "selectOnFocus": true, "anchor": "-20" });
    var url1064 = new Lino.URLField({ "listeners": { "render": Lino.quicktip_renderer("URL","(contacts.Persons.url) ") }, "fieldLabel": "URL", "name": "url", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var phone1065 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Telefon","(contacts.Persons.phone) ") }, "fieldLabel": "Telefon", "name": "phone", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var gsm1066 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("GSM","(contacts.Persons.gsm) ") }, "fieldLabel": "GSM", "name": "gsm", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var fax1067 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Fax","(contacts.Persons.fax) ") }, "fieldLabel": "Fax", "name": "fax", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var contact_box_5_panel1068 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": gsm1066, "labelAlign": "top" }, { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": fax1067, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 36, "border": false, "anchor": "-20", "labelAlign": "top" });
    var contact_box_panel1071 = new Ext.form.FieldSet({ "flex": 33, "autoHeight": true, "layout": "form", "title": "Kontakt", "items": [ info_box_panel1060, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": email1063, "anchor": "-20", "labelAlign": "top" }, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": url1064, "anchor": "-20", "labelAlign": "top" }, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": phone1065, "anchor": "-20", "labelAlign": "top" }, contact_box_5_panel1068 ], "frame": true, "bodyBorder": false, "autoScroll": false, "hideCheckBoxLabels": true, "labelWidth": 72, "border": false, "labelAlign": "top" });
    var general_1_panel1075 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "hideCheckBoxLabels": true, "items": [ address_box_panel1055, contact_box_panel1071 ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var activity1076 = new Lino.RemoteComboFieldElement({ "fieldLabel": "Beruf", "name": "activity", "pageSize": 20, "emptyText": "Beruf ausw\u00e4hlen...", "listeners": { "render": Lino.quicktip_renderer("Beruf","(contacts.Persons.activity) ") }, "selectOnFocus": true, "hiddenName": "activityHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/contacts/Persons/activity", "method": "GET" }) }) });
    var bank_account11077 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Bankkonto 1","(contacts.Persons.bank_account1) ") }, "fieldLabel": "Bankkonto 1", "name": "bank_account1", "maxLength": 40, "selectOnFocus": true, "anchor": "-20" });
    var bank_account21078 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Bankkonto 2","(contacts.Persons.bank_account2) ") }, "fieldLabel": "Bankkonto 2", "name": "bank_account2", "maxLength": 40, "selectOnFocus": true, "anchor": "-20" });
    var is_obsolete1079 = new Ext.form.Checkbox({ "boxLabel": "veraltet", "listeners": { "render": Lino.quicktip_renderer("veraltet","(contacts.Persons.is_obsolete) Altf\u00e4lle sind Partner, deren Stammdaten nicht mehr gepflegt werden und \nf\u00fcr neue Operationen nicht benutzt werden k\u00f6nnen.") }, "hideLabel": true, "checked": false, "name": "is_obsolete", "selectOnFocus": true, "anchor": "-20" });
    var bottom_box_1_panel1080 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 108, "hideCheckBoxLabels": true, "items": [ { "flex": 27, "autoHeight": true, "layout": "form", "xtype": "panel", "items": activity1076, "labelAlign": "top" }, { "flex": 29, "autoHeight": true, "layout": "form", "xtype": "panel", "items": bank_account11077, "labelAlign": "top" }, { "flex": 29, "autoHeight": true, "layout": "form", "xtype": "panel", "items": bank_account21078, "labelAlign": "top" }, { "flex": 13, "autoHeight": true, "layout": "form", "xtype": "panel", "items": is_obsolete1079, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var is_client1085 = new Ext.form.Checkbox({ "boxLabel": "ist Klient (<a href=\"javascript:Lino.show_mti_child('is_client',Lino.pcsw.Clients.detail)\">zeigen</a>)", "listeners": { "render": Lino.quicktip_renderer("ist Klient","(contacts.Persons.is_client) Ob diese Person ein Klient ist") }, "hideLabel": true, "name": "is_client", "selectOnFocus": true, "anchor": "-20" });
    var created1086 = new Ext.form.DisplayField({ "disabled": true, "listeners": { "render": Lino.quicktip_renderer("Erstellt","(contacts.Persons.created) ") }, "fieldLabel": "Erstellt", "name": "created", "anchor": "-20", "value": "<br>" });
    var modified1087 = new Ext.form.DisplayField({ "disabled": true, "listeners": { "render": Lino.quicktip_renderer("Bearbeitet","(contacts.Persons.modified) ") }, "fieldLabel": "Bearbeitet", "name": "modified", "anchor": "-20", "value": "<br>" });
    var bottom_box_2_panel1088 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 99, "hideCheckBoxLabels": true, "items": [ { "flex": 23, "autoHeight": true, "layout": "form", "xtype": "panel", "items": is_client1085, "labelAlign": "top" }, { "flex": 38, "autoHeight": true, "layout": "form", "xtype": "panel", "items": created1086, "labelAlign": "top" }, { "flex": 38, "autoHeight": true, "layout": "form", "xtype": "panel", "items": modified1087, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var remarks1092 = new Ext.form.TextArea({ "listeners": { "render": Lino.quicktip_renderer("Bemerkungen","(contacts.Persons.remarks) ") }, "fieldLabel": "Bemerkungen", "name": "remarks", "growMax": 2000, "selectOnFocus": true, "anchor": "-20 -10" });
    var contacts_RolesByPerson_grid1097 = new Lino.contacts.RolesByPerson.GridPanel({ "flex": 27, "listeners": { "render": Lino.quicktip_renderer("Kontaktperson f\u00fcr","(contacts.contacts.RolesByPerson) ") }, "hide_top_toolbar": true, "containing_panel": this, "tools": [ Lino.show_in_own_window_button(Lino.contacts.RolesByPerson.grid) ], "master_panel": this });
    var households_MembersByPerson_grid1104 = new Lino.households.MembersByPerson.GridPanel({ "flex": 36, "listeners": { "render": Lino.quicktip_renderer("Mitglied von","(households.households.MembersByPerson) ") }, "hide_top_toolbar": true, "containing_panel": this, "tools": [ Lino.show_in_own_window_button(Lino.households.MembersByPerson.grid) ], "master_panel": this });
    var bottom_box_3_panel1105 = new Ext.Panel({ "flex": 71, "border": false, "layout": "hbox", "labelWidth": 108, "hideCheckBoxLabels": true, "items": [ { "items": remarks1092, "labelAlign": "top", "layout": "form", "xtype": "panel", "flex": 36 }, contacts_RolesByPerson_grid1097, households_MembersByPerson_grid1104 ], "autoScroll": false, "layoutConfig": { "align": "stretch" }, "frame": false, "labelAlign": "top" });
    var bottom_box_panel1107 = new Ext.Panel({ "flex": 58, "border": false, "layout": "vbox", "bodyBorder": false, "hideCheckBoxLabels": true, "items": [ bottom_box_1_panel1080, bottom_box_2_panel1088, bottom_box_3_panel1105 ], "autoScroll": false, "layoutConfig": { "align": "stretch" }, "frame": true, "labelAlign": "top" });
    var general_panel1108 = new Ext.Panel({ "layout": "vbox", "title": "Allgemein", "items": [ general_1_panel1075, bottom_box_panel1107 ], "frame": true, "layoutConfig": { "align": "stretch" }, "hideCheckBoxLabels": true, "listeners": { "activate": Lino.on_tab_activate }, "autoScroll": false, "border": false, "bodyBorder": false, "labelAlign": "top" });
    var main_panel1112 = new Ext.TabPanel({ "hideCheckBoxLabels": true, "border": false, "split": true, "autoScroll": false, "items": [ general_panel1108 ], "activeTab": 0, "bodyBorder": false, "frame": true, "labelAlign": "top" });
    this.items = main_panel1112;
    this.before_row_edit = function(record) {
      region1036.setContextValue('country',record ? record.data['countryHidden'] : undefined);
      city1037.setContextValue('country',record ? record.data['countryHidden'] : undefined);
      city1037.setContextValue('region',record ? record.data['regionHidden'] : undefined);
      contacts_RolesByPerson_grid1097.on_master_changed();
      households_MembersByPerson_grid1104.on_master_changed();
    }
    this.onRender = function(ct, position) {
      country1035.on('change',Lino.chooser_handler(region1036,'country'));
      country1035.on('change',Lino.chooser_handler(city1037,'country'));
      region1036.on('change',Lino.chooser_handler(city1037,'region'));
      Lino.contacts.Persons.DetailFormPanel.superclass.onRender.call(this, ct, position);
    }
    Lino.contacts.Persons.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.notes.MyNotes.InsertFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  autoHeight: true,
  content_type: 93,
  initComponent : function() {
    var containing_panel = this;
    var event_type998 = new Lino.TwinCombo({ "fieldLabel": "Ereignisart (Form)", "name": "event_type", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.notes.EventTypes.detail)}, "emptyText": "Event Type ausw\u00e4hlen...", "listeners": { "render": Lino.quicktip_renderer("Ereignisart (Form)","(notes.Notes.event_type) ") }, "selectOnFocus": true, "hiddenName": "event_typeHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/notes/Notes/event_type", "method": "GET" }) }) });
    var type999 = new Lino.TwinCombo({ "fieldLabel": "Notizart (Inhalt)", "name": "type", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.notes.NoteTypes.detail)}, "emptyText": "Notizart ausw\u00e4hlen...", "listeners": { "render": Lino.quicktip_renderer("Notizart (Inhalt)","(notes.Notes.type) ") }, "selectOnFocus": true, "hiddenName": "typeHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/notes/Notes/type", "method": "GET" }) }) });
    var main_1_panel1000 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": event_type998, "labelAlign": "top" }, { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": type999, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 171, "border": false, "anchor": "-20", "labelAlign": "top" });
    var subject1003 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Betreff","(notes.Notes.subject) ") }, "fieldLabel": "Betreff", "name": "subject", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var project1004 = new Lino.TwinCombo({ "preferred_width": 20, "fieldLabel": "Klient", "name": "project", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.pcsw.Clients.detail)}, "hiddenName": "projectHidden", "listeners": { "render": Lino.quicktip_renderer("Klient","(notes.Notes.project) ") }, "selectOnFocus": true, "emptyText": "Klient ausw\u00e4hlen...", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/notes/Notes/project", "method": "GET" }) }) });
    var company1005 = new Lino.TwinCombo({ "preferred_width": 20, "fieldLabel": "Empf\u00e4nger (Organisation)", "name": "company", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.contacts.Companies.detail)}, "hiddenName": "companyHidden", "listeners": { "render": Lino.quicktip_renderer("Empf\u00e4nger (Organisation)","(notes.Notes.company) ") }, "selectOnFocus": true, "emptyText": "Organisation ausw\u00e4hlen...", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/notes/Notes/company", "method": "GET" }) }) });
    var main_3_panel1006 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": project1004, "labelAlign": "top" }, { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": company1005, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 225, "border": false, "anchor": "-20", "labelAlign": "top" });
    var main_panel1009 = new Ext.Panel({ "hideCheckBoxLabels": true, "autoHeight": true, "border": false, "layout": "form", "labelWidth": 72, "autoScroll": false, "items": [ main_1_panel1000, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": subject1003, "anchor": "-20", "labelAlign": "top" }, main_3_panel1006 ], "frame": true, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel1009;
    this.before_row_edit = function(record) {
    }
    Lino.notes.MyNotes.InsertFormPanel.superclass.initComponent.call(this);
  }
});


Lino.system.Home.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  disable_editing: true,
  initComponent : function() {
    var containing_panel = this;
    var quick_links_htmlbox3721 = new Lino.HtmlBoxPanel({ "flex": 1, "layout": "fit", "name": "quick_links", "containing_panel": this, "master_panel": this, "items": new Ext.BoxComponent({autoScroll:true}), "region": "north", "bodyStyle": "overflow-x:hidden;", "value": "<br/>", "always_enabled": true, "listeners": { "render": Lino.quicktip_renderer(null,"(system.Home.quick_links) ") }, "split": true });
    var welcome_htmlbox3722 = new Lino.HtmlBoxPanel({ "flex": 3, "layout": "fit", "name": "welcome", "containing_panel": this, "master_panel": this, "items": new Ext.BoxComponent({autoScroll:true}), "region": "center", "title": "Willkommen", "bodyStyle": "overflow-x:hidden;", "value": "<br/>", "always_enabled": true, "listeners": { "render": Lino.quicktip_renderer("Willkommen","(system.Home.welcome) ") }, "split": true });
    var main_panel3723 = new Lino.VBorderPanel({ "autoScroll": false, "border": false, "labelWidth": 99, "hideCheckBoxLabels": true, "items": [ quick_links_htmlbox3721, welcome_htmlbox3722 ], "frame": true, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel3723;
    this.before_row_edit = function(record) {
      quick_links_htmlbox3721.refresh();
      welcome_htmlbox3722.refresh();
    }
    Lino.system.Home.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.contacts.Partners.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 22,
  initComponent : function() {
    var containing_panel = this;
    var name538 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Name","(contacts.Partners.name) ") }, "fieldLabel": "Name", "name": "name", "maxLength": 200, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var country539 = new Lino.TwinCombo({ "fieldLabel": "Land", "name": "country", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.countries.Countries.detail)}, "emptyText": "Land ausw\u00e4hlen...", "listeners": { "render": Lino.quicktip_renderer("Land","(contacts.Partners.country) ") }, "selectOnFocus": true, "hiddenName": "countryHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/contacts/Partners/country", "method": "GET" }) }) });
    var region540 = new Lino.TwinCombo({ "fieldLabel": "Region", "name": "region", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.countries.Cities.detail)}, "emptyText": "Ort ausw\u00e4hlen...", "listeners": { "render": Lino.quicktip_renderer("Region","(contacts.Partners.region) ") }, "selectOnFocus": true, "hiddenName": "regionHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/contacts/Partners/region", "method": "GET" }) }) });
    var city541 = new Lino.TwinCombo({ "forceSelection": false, "fieldLabel": "Ort", "name": "city", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.countries.Cities.detail)}, "emptyText": "Ort ausw\u00e4hlen...", "listeners": { "render": Lino.quicktip_renderer("Ort","(contacts.Partners.city) ") }, "selectOnFocus": true, "hiddenName": "cityHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/contacts/Partners/city", "method": "GET" }) }) });
    var zip_code542 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Postleitzahl","(contacts.Partners.zip_code) ") }, "fieldLabel": "Postleitzahl", "name": "zip_code", "maxLength": 10, "selectOnFocus": true, "boxMinWidth": Lino.chars2width(10), "anchor": "-20" });
    var address_box_2_panel543 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 28, "autoHeight": true, "layout": "form", "xtype": "panel", "items": country539, "labelAlign": "top" }, { "flex": 28, "autoHeight": true, "layout": "form", "xtype": "panel", "items": region540, "labelAlign": "top" }, { "flex": 28, "autoHeight": true, "layout": "form", "xtype": "panel", "items": city541, "labelAlign": "top" }, { "flex": 14, "autoHeight": true, "layout": "form", "xtype": "panel", "items": zip_code542, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 117, "border": false, "anchor": "-20", "labelAlign": "top" });
    var addr1548 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Adresszeile vor Stra\u00dfe","(contacts.Partners.addr1) Address line before street") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Adresszeile vor Stra\u00dfe</span>", "name": "addr1", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var street_prefix549 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Pr\u00e4fix Stra\u00dfe","(contacts.Partners.street_prefix) Text to print before name of street, but to ignore for sorting.") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Pr\u00e4fix Stra\u00dfe</span>", "name": "street_prefix", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var street550 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Stra\u00dfe","(contacts.Partners.street) Name of street. Without house number.") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Stra\u00dfe</span>", "name": "street", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var street_no551 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Nr.","(contacts.Partners.street_no) House number") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Nr.</span>", "name": "street_no", "maxLength": 10, "selectOnFocus": true, "boxMinWidth": Lino.chars2width(10), "anchor": "-20" });
    var street_box552 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Box","(contacts.Partners.street_box) Text to print after :attr:`steet_no` on the same line") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Box</span>", "name": "street_box", "maxLength": 10, "selectOnFocus": true, "boxMinWidth": Lino.chars2width(10), "anchor": "-20" });
    var address_box_4_panel553 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 30, "autoHeight": true, "layout": "form", "xtype": "panel", "items": street_prefix549, "labelAlign": "top" }, { "flex": 36, "autoHeight": true, "layout": "form", "xtype": "panel", "items": street550, "labelAlign": "top" }, { "flex": 16, "autoHeight": true, "layout": "form", "xtype": "panel", "items": street_no551, "labelAlign": "top" }, { "flex": 16, "autoHeight": true, "layout": "form", "xtype": "panel", "items": street_box552, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 126, "border": false, "anchor": "-20", "labelAlign": "top" });
    var addr2558 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Adresszeile nach Stra\u00dfe","(contacts.Partners.addr2) Address line to print below street line") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Adresszeile nach Stra\u00dfe</span>", "name": "addr2", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var address_box_panel559 = new Ext.form.FieldSet({ "flex": 66, "autoHeight": true, "layout": "form", "title": "Adresse", "items": [ { "autoHeight": true, "layout": "form", "xtype": "panel", "items": name538, "anchor": "-20", "labelAlign": "top" }, address_box_2_panel543, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": addr1548, "anchor": "-20", "labelAlign": "top" }, address_box_4_panel553, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": addr2558, "anchor": "-20", "labelAlign": "top" } ], "frame": true, "bodyBorder": false, "autoScroll": false, "hideCheckBoxLabels": true, "labelWidth": 216, "border": false, "labelAlign": "top" });
    var id563 = new Ext.form.NumberField({ "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("ID","(contacts.Partners.id) ") }, "fieldLabel": "ID", "anchor": "-20", "name": "id" });
    var language564 = new Lino.ChoicesFieldElement({ "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Sprache</span>", "allowBlank": false, "hiddenName": "languageHidden", "listeners": { "render": Lino.quicktip_renderer("Sprache","(contacts.Partners.language) Die Sprache, in der Dokumente ausgestellt werden sollen.") }, "selectOnFocus": true, "anchor": "-20", "store": [ [ "en", "Englisch" ], [ "fr", "Franz\u00f6sisch" ], [ "de", "Deutsch" ], [ "nl", "Niederl\u00e4ndisch" ] ], "name": "language" });
    var info_box_panel565 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 20, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id563, "labelAlign": "top" }, { "flex": 80, "autoHeight": true, "layout": "form", "xtype": "panel", "items": language564, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 72, "border": false, "anchor": "-20", "labelAlign": "top" });
    var email568 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("E-Mail","(contacts.Partners.email) ") }, "fieldLabel": "E-Mail", "name": "email", "maxLength": 75, "selectOnFocus": true, "anchor": "-20" });
    var url569 = new Lino.URLField({ "listeners": { "render": Lino.quicktip_renderer("URL","(contacts.Partners.url) ") }, "fieldLabel": "URL", "name": "url", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var phone570 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Telefon","(contacts.Partners.phone) ") }, "fieldLabel": "Telefon", "name": "phone", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var gsm571 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("GSM","(contacts.Partners.gsm) ") }, "fieldLabel": "GSM", "name": "gsm", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var fax572 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Fax","(contacts.Partners.fax) ") }, "fieldLabel": "Fax", "name": "fax", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var contact_box_5_panel573 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": gsm571, "labelAlign": "top" }, { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": fax572, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 36, "border": false, "anchor": "-20", "labelAlign": "top" });
    var contact_box_panel576 = new Ext.form.FieldSet({ "flex": 33, "autoHeight": true, "layout": "form", "title": "Kontakt", "items": [ info_box_panel565, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": email568, "anchor": "-20", "labelAlign": "top" }, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": url569, "anchor": "-20", "labelAlign": "top" }, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": phone570, "anchor": "-20", "labelAlign": "top" }, contact_box_5_panel573 ], "frame": true, "bodyBorder": false, "autoScroll": false, "hideCheckBoxLabels": true, "labelWidth": 72, "border": false, "labelAlign": "top" });
    var general_1_panel580 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "hideCheckBoxLabels": true, "items": [ address_box_panel559, contact_box_panel576 ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var remarks581 = new Ext.form.TextArea({ "listeners": { "render": Lino.quicktip_renderer("Bemerkungen","(contacts.Partners.remarks) ") }, "fieldLabel": "Bemerkungen", "name": "remarks", "growMax": 2000, "selectOnFocus": true, "anchor": "-20 -10" });
    var activity582 = new Lino.RemoteComboFieldElement({ "fieldLabel": "Beruf", "name": "activity", "pageSize": 20, "emptyText": "Beruf ausw\u00e4hlen...", "listeners": { "render": Lino.quicktip_renderer("Beruf","(contacts.Partners.activity) ") }, "selectOnFocus": true, "hiddenName": "activityHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/contacts/Partners/activity", "method": "GET" }) }) });
    var bank_account1583 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Bankkonto 1","(contacts.Partners.bank_account1) ") }, "fieldLabel": "Bankkonto 1", "name": "bank_account1", "maxLength": 40, "selectOnFocus": true, "anchor": "-20" });
    var bank_account2584 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Bankkonto 2","(contacts.Partners.bank_account2) ") }, "fieldLabel": "Bankkonto 2", "name": "bank_account2", "maxLength": 40, "selectOnFocus": true, "anchor": "-20" });
    var is_obsolete585 = new Ext.form.Checkbox({ "boxLabel": "veraltet", "listeners": { "render": Lino.quicktip_renderer("veraltet","(contacts.Partners.is_obsolete) Altf\u00e4lle sind Partner, deren Stammdaten nicht mehr gepflegt werden und \nf\u00fcr neue Operationen nicht benutzt werden k\u00f6nnen.") }, "hideLabel": true, "checked": false, "name": "is_obsolete", "selectOnFocus": true, "anchor": "-20" });
    var bottom_box_2_panel586 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 108, "hideCheckBoxLabels": true, "items": [ { "flex": 27, "autoHeight": true, "layout": "form", "xtype": "panel", "items": activity582, "labelAlign": "top" }, { "flex": 29, "autoHeight": true, "layout": "form", "xtype": "panel", "items": bank_account1583, "labelAlign": "top" }, { "flex": 29, "autoHeight": true, "layout": "form", "xtype": "panel", "items": bank_account2584, "labelAlign": "top" }, { "flex": 13, "autoHeight": true, "layout": "form", "xtype": "panel", "items": is_obsolete585, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var is_person591 = new Ext.form.Checkbox({ "boxLabel": "ist eine Person (<a href=\"javascript:Lino.show_mti_child('is_person',Lino.contacts.Persons.detail)\">zeigen</a>)", "listeners": { "render": Lino.quicktip_renderer("ist eine Person","(contacts.Partners.is_person) Ob dieser Partner auch eine Person ist.") }, "hideLabel": true, "name": "is_person", "selectOnFocus": true, "anchor": "-20" });
    var is_company592 = new Ext.form.Checkbox({ "boxLabel": "ist eine Organisation (<a href=\"javascript:Lino.show_mti_child('is_company',Lino.contacts.Companies.detail)\">zeigen</a>)", "listeners": { "render": Lino.quicktip_renderer("ist eine Organisation","(contacts.Partners.is_company) Ob dieser Partner auch eine Organisation ist.") }, "hideLabel": true, "name": "is_company", "selectOnFocus": true, "anchor": "-20" });
    var is_household593 = new Ext.form.Checkbox({ "boxLabel": "ist ein Haushalt (<a href=\"javascript:Lino.show_mti_child('is_household',Lino.households.Households.detail)\">zeigen</a>)", "listeners": { "render": Lino.quicktip_renderer("ist ein Haushalt","(contacts.Partners.is_household) ") }, "hideLabel": true, "name": "is_household", "selectOnFocus": true, "anchor": "-20" });
    var created594 = new Ext.form.DisplayField({ "disabled": true, "listeners": { "render": Lino.quicktip_renderer("Erstellt","(contacts.Partners.created) ") }, "fieldLabel": "Erstellt", "name": "created", "anchor": "-20", "value": "<br>" });
    var modified595 = new Ext.form.DisplayField({ "disabled": true, "listeners": { "render": Lino.quicktip_renderer("Bearbeitet","(contacts.Partners.modified) ") }, "fieldLabel": "Bearbeitet", "name": "modified", "anchor": "-20", "value": "<br>" });
    var bottom_box_3_panel596 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 198, "hideCheckBoxLabels": true, "items": [ { "flex": 16, "autoHeight": true, "layout": "form", "xtype": "panel", "items": is_person591, "labelAlign": "top" }, { "flex": 16, "autoHeight": true, "layout": "form", "xtype": "panel", "items": is_company592, "labelAlign": "top" }, { "flex": 16, "autoHeight": true, "layout": "form", "xtype": "panel", "items": is_household593, "labelAlign": "top" }, { "flex": 25, "autoHeight": true, "layout": "form", "xtype": "panel", "items": created594, "labelAlign": "top" }, { "flex": 25, "autoHeight": true, "layout": "form", "xtype": "panel", "items": modified595, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var bottom_box_panel602 = new Ext.Panel({ "flex": 58, "layout": "vbox", "items": [ { "items": remarks581, "labelAlign": "top", "layout": "form", "xtype": "panel", "flex": 71 }, bottom_box_2_panel586, bottom_box_3_panel596 ], "frame": true, "layoutConfig": { "align": "stretch" }, "autoScroll": false, "hideCheckBoxLabels": true, "labelWidth": 108, "border": false, "bodyBorder": false, "labelAlign": "top" });
    var general_panel604 = new Ext.Panel({ "layout": "vbox", "title": "Allgemein", "items": [ general_1_panel580, bottom_box_panel602 ], "frame": true, "layoutConfig": { "align": "stretch" }, "hideCheckBoxLabels": true, "listeners": { "activate": Lino.on_tab_activate }, "autoScroll": false, "border": false, "bodyBorder": false, "labelAlign": "top" });
    var changes_ChangesByMaster_grid613 = new Lino.changes.ChangesByMaster.GridPanel({ "listeners": { "activate": Lino.on_tab_activate }, "hide_top_toolbar": true, "containing_panel": this, "title": "\u00c4nderungen", "tools": [ Lino.show_in_own_window_button(Lino.changes.ChangesByMaster.grid) ], "master_panel": this });
    var main_panel734 = new Ext.TabPanel({ "hideCheckBoxLabels": true, "border": false, "split": true, "autoScroll": false, "items": [ general_panel604, changes_ChangesByMaster_grid613 ], "activeTab": 0, "bodyBorder": false, "frame": true, "labelAlign": "top" });
    this.items = main_panel734;
    this.before_row_edit = function(record) {
      region540.setContextValue('country',record ? record.data['countryHidden'] : undefined);
      city541.setContextValue('country',record ? record.data['countryHidden'] : undefined);
      city541.setContextValue('region',record ? record.data['regionHidden'] : undefined);
      changes_ChangesByMaster_grid613.on_master_changed();
    }
    this.onRender = function(ct, position) {
      country539.on('change',Lino.chooser_handler(region540,'country'));
      country539.on('change',Lino.chooser_handler(city541,'country'));
      region540.on('change',Lino.chooser_handler(city541,'region'));
      Lino.contacts.Partners.DetailFormPanel.superclass.onRender.call(this, ct, position);
    }
    Lino.contacts.Partners.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.users.MySettings.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 7,
  initComponent : function() {
    var containing_panel = this;
    var username237 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Benutzername","(users.Users.username) Required. Must be unique.") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Benutzername</span>", "name": "username", "maxLength": 30, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var profile238 = new Lino.ChoicesFieldElement({ "forceSelection": true, "fieldLabel": "Benutzerprofil", "name": "profile", "hiddenName": "profileHidden", "listeners": { "render": Lino.quicktip_renderer("Benutzerprofil","(users.Users.profile) ") }, "selectOnFocus": true, "anchor": "-20", "store": [['','<br>']].concat(Lino.lino.UserProfiles) });
    var partner239 = new Lino.TwinCombo({ "preferred_width": 20, "fieldLabel": "Partner", "name": "partner", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.contacts.Partners.detail)}, "hiddenName": "partnerHidden", "listeners": { "render": Lino.quicktip_renderer("Partner","(users.Users.partner) ") }, "selectOnFocus": true, "emptyText": "Partner ausw\u00e4hlen...", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/users/Users/partner", "method": "GET" }) }) });
    var box1_1_panel240 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 34, "autoHeight": true, "layout": "form", "xtype": "panel", "items": username237, "labelAlign": "top" }, { "flex": 32, "autoHeight": true, "layout": "form", "xtype": "panel", "items": profile238, "labelAlign": "top" }, { "flex": 32, "autoHeight": true, "layout": "form", "xtype": "panel", "items": partner239, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 135, "border": false, "anchor": "-20", "labelAlign": "top" });
    var first_name244 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Vorname","(users.Users.first_name) ") }, "fieldLabel": "Vorname", "name": "first_name", "maxLength": 30, "selectOnFocus": true, "anchor": "-20" });
    var last_name245 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Familienname","(users.Users.last_name) ") }, "fieldLabel": "Familienname", "name": "last_name", "maxLength": 30, "selectOnFocus": true, "anchor": "-20" });
    var initials246 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Initials","(users.Users.initials) ") }, "fieldLabel": "Initials", "name": "initials", "maxLength": 10, "selectOnFocus": true, "boxMinWidth": Lino.chars2width(10), "anchor": "-20" });
    var box1_2_panel247 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 39, "autoHeight": true, "layout": "form", "xtype": "panel", "items": first_name244, "labelAlign": "top" }, { "flex": 39, "autoHeight": true, "layout": "form", "xtype": "panel", "items": last_name245, "labelAlign": "top" }, { "flex": 20, "autoHeight": true, "layout": "form", "xtype": "panel", "items": initials246, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 117, "border": false, "anchor": "-20", "labelAlign": "top" });
    var email251 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("e-mail address","(users.Users.email) ") }, "fieldLabel": "e-mail address", "name": "email", "maxLength": 75, "selectOnFocus": true, "anchor": "-20" });
    var language252 = new Lino.ChoicesFieldElement({ "listeners": { "render": Lino.quicktip_renderer("Sprache","(users.Users.language) ") }, "fieldLabel": "Sprache", "name": "language", "selectOnFocus": true, "anchor": "-20", "store": [ [ "en", "Englisch" ], [ "fr", "Franz\u00f6sisch" ], [ "de", "Deutsch" ], [ "nl", "Niederl\u00e4ndisch" ] ], "hiddenName": "languageHidden" });
    var box1_3_panel253 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 51, "autoHeight": true, "layout": "form", "xtype": "panel", "items": email251, "labelAlign": "top" }, { "flex": 48, "autoHeight": true, "layout": "form", "xtype": "panel", "items": language252, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 135, "border": false, "anchor": "-20", "labelAlign": "top" });
    var id256 = new Ext.form.NumberField({ "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("ID","(users.Users.id) ") }, "fieldLabel": "ID", "anchor": "-20", "name": "id" });
    var created257 = new Ext.form.DisplayField({ "disabled": true, "listeners": { "render": Lino.quicktip_renderer("Erstellt","(users.Users.created) ") }, "fieldLabel": "Erstellt", "name": "created", "anchor": "-20", "value": "<br>" });
    var modified258 = new Ext.form.DisplayField({ "disabled": true, "listeners": { "render": Lino.quicktip_renderer("Bearbeitet","(users.Users.modified) ") }, "fieldLabel": "Bearbeitet", "name": "modified", "anchor": "-20", "value": "<br>" });
    var box1_4_panel259 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 13, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id256, "labelAlign": "top" }, { "flex": 43, "autoHeight": true, "layout": "form", "xtype": "panel", "items": created257, "labelAlign": "top" }, { "flex": 43, "autoHeight": true, "layout": "form", "xtype": "panel", "items": modified258, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 99, "border": false, "anchor": "-20", "labelAlign": "top" });
    var box1_panel263 = new Ext.Panel({ "flex": 66, "autoHeight": true, "border": false, "layout": "form", "hideCheckBoxLabels": true, "items": [ box1_1_panel240, box1_2_panel247, box1_3_panel253, box1_4_panel259 ], "frame": true, "autoScroll": false, "bodyBorder": false, "labelAlign": "top" });
    var general_1_panel267 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "hideCheckBoxLabels": true, "items": [ box1_panel263 ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var remarks268 = new Ext.form.TextArea({ "listeners": { "render": Lino.quicktip_renderer("Bemerkungen","(users.Users.remarks) ") }, "fieldLabel": "Bemerkungen", "name": "remarks", "growMax": 2000, "selectOnFocus": true, "anchor": "-20 -10" });
    var AuthoritiesGiven_grid271 = new Lino.users.AuthoritiesGiven.GridPanel({ "flex": 33, "listeners": { "render": Lino.quicktip_renderer("Erteilte Vollmachten","(users.users.AuthoritiesGiven) ") }, "hide_top_toolbar": true, "containing_panel": this, "tools": [ Lino.show_in_own_window_button(Lino.users.AuthoritiesGiven.grid) ], "master_panel": this, "hideHeaders": true });
    var general_2_panel272 = new Ext.Panel({ "flex": 50, "border": false, "layout": "hbox", "labelWidth": 108, "hideCheckBoxLabels": true, "items": [ { "items": remarks268, "labelAlign": "top", "layout": "form", "xtype": "panel", "flex": 66 }, AuthoritiesGiven_grid271 ], "autoScroll": false, "layoutConfig": { "align": "stretch" }, "frame": false, "labelAlign": "top" });
    var general_panel274 = new Ext.Panel({ "layout": "vbox", "title": "Allgemein", "items": [ general_1_panel267, general_2_panel272 ], "frame": true, "layoutConfig": { "align": "stretch" }, "hideCheckBoxLabels": true, "listeners": { "activate": Lino.on_tab_activate }, "autoScroll": false, "border": false, "bodyBorder": false, "labelAlign": "top" });
    var calendar275 = new Lino.TwinCombo({ "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Standard-Kalender</span>", "name": "calendar", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.cal.Calendars.detail)}, "emptyText": "Kalender ausw\u00e4hlen...", "listeners": { "render": Lino.quicktip_renderer("Standard-Kalender","(users.Users.calendar) The default calendar for your events and tasks.") }, "selectOnFocus": true, "hiddenName": "calendarHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/users/Users/calendar", "method": "GET" }) }) });
    var access_class276 = new Lino.ChoicesFieldElement({ "forceSelection": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Standardm\u00e4\u00dfige Zugriffsklasse</span>", "allowBlank": false, "hiddenName": "access_classHidden", "listeners": { "render": Lino.quicktip_renderer("Standardm\u00e4\u00dfige Zugriffsklasse","(users.Users.access_class) Die standardm\u00e4\u00dfige Zugriffsklasse f\u00fcr Ihre Termine und Aufgaben") }, "selectOnFocus": true, "anchor": "-20", "store": Lino.cal.AccessClasses, "name": "access_class" });
    var cal_left_1_panel277 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 270, "hideCheckBoxLabels": true, "items": [ { "flex": 62, "autoHeight": true, "layout": "form", "xtype": "panel", "items": calendar275, "labelAlign": "top" }, { "flex": 37, "autoHeight": true, "layout": "form", "xtype": "panel", "items": access_class276, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var cal_SubscriptionsByUser_grid284 = new Lino.cal.SubscriptionsByUser.GridPanel({ "flex": 83, "listeners": { "render": Lino.quicktip_renderer("Abonnements","(cal.cal.SubscriptionsByUser) ") }, "hide_top_toolbar": true, "containing_panel": this, "tools": [ Lino.show_in_own_window_button(Lino.cal.SubscriptionsByUser.grid) ], "master_panel": this });
    var cal_left_panel285 = new Ext.Panel({ "flex": 33, "border": false, "layout": "vbox", "bodyBorder": false, "hideCheckBoxLabels": true, "items": [ cal_left_1_panel277, cal_SubscriptionsByUser_grid284 ], "autoScroll": false, "layoutConfig": { "align": "stretch" }, "frame": true, "labelAlign": "top" });
    var cal_TasksByUser_grid355 = new Lino.cal.TasksByUser.GridPanel({ "flex": 66, "listeners": { "render": Lino.quicktip_renderer("Aufgaben","(cal.cal.TasksByUser) ") }, "hide_top_toolbar": true, "containing_panel": this, "params_panel_hidden": true, "tools": [ Lino.show_in_own_window_button(Lino.cal.TasksByUser.grid) ], "master_panel": this });
    var cal_1_panel356 = new Ext.Panel({ "autoScroll": false, "listeners": { "activate": Lino.on_tab_activate }, "border": false, "layout": "hbox", "title": "Kalender", "hideCheckBoxLabels": true, "items": [ cal_left_panel285, cal_TasksByUser_grid355 ], "frame": false, "layoutConfig": { "align": "stretch" }, "labelAlign": "top" });
    var newcomer_quota357 = new Ext.form.NumberField({ "listeners": { "render": Lino.quicktip_renderer("Quote NZ","(users.Users.newcomer_quota) Wieviel Arbeitszeit dieser Benutzer f\u00fcr Neuantr\u00e4ge zur Verf\u00fcgung steht\n(100 = ganztags, 50 = halbtags, 0 = gar nicht).\nWenn zwei Benutzer die gleiche Belastungspunktzahl haben, \naber einer davon sich nur zu 50% um Neuantr\u00e4ge k\u00fcmmert, \ngilt er als doppelt so belastet wie sein Kollege.\n") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Quote NZ</span>", "name": "newcomer_quota", "selectOnFocus": true, "anchor": "-20", "value": 0, "allowBlank": false });
    var coaching_type358 = new Lino.RemoteComboFieldElement({ "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Dienst</span>", "name": "coaching_type", "pageSize": 20, "emptyText": "Dienst ausw\u00e4hlen...", "listeners": { "render": Lino.quicktip_renderer("Dienst","(users.Users.coaching_type) The default CoachingType used when creating Coachings.") }, "selectOnFocus": true, "hiddenName": "coaching_typeHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/users/Users/coaching_type", "method": "GET" }) }) });
    var coaching_supervisor359 = new Ext.form.Checkbox({ "boxLabel": "Benachrichtigung wenn ein Begleiter zugewiesen wird", "listeners": { "render": Lino.quicktip_renderer("Benachrichtigung wenn ein Begleiter zugewiesen wird","(users.Users.coaching_supervisor) Wenn ein Neuantrag einem Begleiter zugewiesen wurde, wird au\u00dfer dem Begleiter auch dieser Benutzer benachrichtigt.") }, "hideLabel": true, "checked": false, "name": "coaching_supervisor", "selectOnFocus": true, "anchor": "-20" });
    var newcomers_CompetencesByUser_grid365 = new Lino.newcomers.CompetencesByUser.GridPanel({ "flex": 62, "listeners": { "render": Lino.quicktip_renderer("Kompetenzen","(newcomers.newcomers.CompetencesByUser) ") }, "hide_top_toolbar": true, "containing_panel": this, "tools": [ Lino.show_in_own_window_button(Lino.newcomers.CompetencesByUser.grid) ], "master_panel": this });
    var coaching_a_panel366 = new Ext.Panel({ "flex": 33, "layout": "vbox", "items": [ { "items": newcomer_quota357, "autoHeight": true, "layout": "form", "xtype": "panel", "labelAlign": "top" }, { "items": coaching_type358, "autoHeight": true, "layout": "form", "xtype": "panel", "labelAlign": "top" }, { "items": coaching_supervisor359, "autoHeight": true, "layout": "form", "xtype": "panel", "labelAlign": "top" }, newcomers_CompetencesByUser_grid365 ], "frame": true, "layoutConfig": { "align": "stretch" }, "autoScroll": false, "hideCheckBoxLabels": true, "labelWidth": 468, "border": false, "bodyBorder": false, "labelAlign": "top" });
    var pcsw_CoachingsByUser_grid396 = new Lino.pcsw.CoachingsByUser.GridPanel({ "flex": 66, "listeners": { "render": Lino.quicktip_renderer("Begleitungen","(pcsw.pcsw.CoachingsByUser) ") }, "hide_top_toolbar": true, "containing_panel": this, "params_panel_hidden": true, "tools": [ Lino.show_in_own_window_button(Lino.pcsw.CoachingsByUser.grid) ], "master_panel": this });
    var coaching_1_panel397 = new Ext.Panel({ "autoScroll": false, "listeners": { "activate": Lino.on_tab_activate }, "border": false, "layout": "hbox", "title": "Begleitung", "hideCheckBoxLabels": true, "items": [ coaching_a_panel366, pcsw_CoachingsByUser_grid396 ], "frame": false, "layoutConfig": { "align": "stretch" }, "labelAlign": "top" });
    var main_panel398 = new Ext.TabPanel({ "hideCheckBoxLabels": true, "border": false, "split": true, "autoScroll": false, "items": [ general_panel274, cal_1_panel356, coaching_1_panel397 ], "activeTab": 0, "bodyBorder": false, "frame": true, "labelAlign": "top" });
    this.items = main_panel398;
    this.before_row_edit = function(record) {
      AuthoritiesGiven_grid271.on_master_changed();
      cal_SubscriptionsByUser_grid284.on_master_changed();
      cal_TasksByUser_grid355.on_master_changed();
      newcomers_CompetencesByUser_grid365.on_master_changed();
      pcsw_CoachingsByUser_grid396.on_master_changed();
    }
    Lino.users.MySettings.DetailFormPanel.superclass.initComponent.call(this);
    // active_fields:
    partner239.on("change",function(){this.save()},this);
  }
});


Lino.system.MyTextFieldTemplates.InsertFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  autoHeight: true,
  content_type: 2,
  initComponent : function() {
    var containing_panel = this;
    var name229 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Bezeichnung","(system.TextFieldTemplates.name) ") }, "fieldLabel": "Bezeichnung", "name": "name", "maxLength": 200, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var user230 = new Lino.TwinCombo({ "preferred_width": 15, "fieldLabel": "Autor", "name": "user", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.users.Users.detail)}, "hiddenName": "userHidden", "listeners": { "render": Lino.quicktip_renderer("Autor","(system.TextFieldTemplates.user) ") }, "selectOnFocus": true, "emptyText": "Benutzer ausw\u00e4hlen...", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/system/TextFieldTemplates/user", "method": "GET" }) }) });
    var team231 = new Lino.RemoteComboFieldElement({ "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Team</span>", "name": "team", "pageSize": 20, "emptyText": "Team ausw\u00e4hlen...", "listeners": { "render": Lino.quicktip_renderer("Team","(system.TextFieldTemplates.team) If not empty, then this template is reserved to members of this team.") }, "selectOnFocus": true, "hiddenName": "teamHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/system/TextFieldTemplates/team", "method": "GET" }) }) });
    var main_2_panel232 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": user230, "labelAlign": "top" }, { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": team231, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 54, "border": false, "anchor": "-20", "labelAlign": "top" });
    var main_panel235 = new Ext.Panel({ "hideCheckBoxLabels": true, "autoHeight": true, "border": false, "layout": "form", "labelWidth": 108, "autoScroll": false, "items": [ { "autoHeight": true, "layout": "form", "xtype": "panel", "items": name229, "anchor": "-20", "labelAlign": "top" }, main_2_panel232 ], "frame": true, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel235;
    this.before_row_edit = function(record) {
    }
    Lino.system.MyTextFieldTemplates.InsertFormPanel.superclass.initComponent.call(this);
  }
});


Lino.cbss.IdentifyPersonRequests.InsertFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  autoHeight: true,
  content_type: 92,
  initComponent : function() {
    var containing_panel = this;
    var person3537 = new Lino.TwinCombo({ "preferred_width": 20, "fieldLabel": "Klient", "allowBlank": false, "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.pcsw.Clients.detail)}, "emptyText": "Klient ausw\u00e4hlen...", "listeners": { "render": Lino.quicktip_renderer("Klient","(cbss.IdentifyPersonRequests.person) ") }, "selectOnFocus": true, "hiddenName": "personHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cbss/IdentifyPersonRequests/person", "method": "GET" }) }), "name": "person" });
    var national_id3538 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("NR-Nummer","(cbss.IdentifyPersonRequests.national_id) ") }, "fieldLabel": "NR-Nummer", "name": "national_id", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var main_1_panel3539 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 48, "autoHeight": true, "layout": "form", "xtype": "panel", "items": person3537, "labelAlign": "top" }, { "flex": 51, "autoHeight": true, "layout": "form", "xtype": "panel", "items": national_id3538, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 90, "border": false, "anchor": "-20", "labelAlign": "top" });
    var first_name3542 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Vorname","(cbss.IdentifyPersonRequests.first_name) ") }, "fieldLabel": "Vorname", "name": "first_name", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var middle_name3543 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Mittelnamen","(cbss.IdentifyPersonRequests.middle_name) Whatever this means...") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Mittelnamen</span>", "name": "middle_name", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var last_name3544 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Familienname","(cbss.IdentifyPersonRequests.last_name) ") }, "fieldLabel": "Familienname", "name": "last_name", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var p2_1_panel3545 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": first_name3542, "labelAlign": "top" }, { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": middle_name3543, "labelAlign": "top" }, { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": last_name3544, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 117, "border": false, "anchor": "-20", "labelAlign": "top" });
    var birth_date3549 = new Lino.IncompleteDateField({ "listeners": { "render": Lino.quicktip_renderer("Geburtsdatum","(cbss.IdentifyPersonRequests.birth_date) Uncomplete dates are allowed, e.g. \n\"00.00.1980\" means \"some day in 1980\", \n\"00.07.1980\" means \"in July 1980\"\nor \"23.07.0000\" means \"on a 23th of July\".") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Geburtsdatum</span>", "name": "birth_date", "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var tolerance3550 = new Ext.form.NumberField({ "listeners": { "render": Lino.quicktip_renderer("Toleranz","(cbss.IdentifyPersonRequests.tolerance) \n      Falls Monat oder Tag des Geburtsdatums unbekannt sind, \n      um wieviel Monate bzw. Tage die Suche nach unten/oben ausgeweitet wird.\n      G\u00fcltige Werte: 0 bis 10.\n      ") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Toleranz</span>", "name": "tolerance", "selectOnFocus": true, "anchor": "-20", "value": 0, "allowBlank": false });
    var gender3551 = new Lino.ChoicesFieldElement({ "forceSelection": true, "fieldLabel": "Geschlecht", "name": "gender", "hiddenName": "genderHidden", "listeners": { "render": Lino.quicktip_renderer("Geschlecht","(cbss.IdentifyPersonRequests.gender) ") }, "selectOnFocus": true, "anchor": "-20", "store": [['','<br>']].concat(Lino.lino.Genders) });
    var p2_2_panel3552 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 46, "autoHeight": true, "layout": "form", "xtype": "panel", "items": birth_date3549, "labelAlign": "top" }, { "flex": 19, "autoHeight": true, "layout": "form", "xtype": "panel", "items": tolerance3550, "labelAlign": "top" }, { "flex": 34, "autoHeight": true, "layout": "form", "xtype": "panel", "items": gender3551, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 117, "border": false, "anchor": "-20", "labelAlign": "top" });
    var p2_panel3556 = new Ext.form.FieldSet({ "autoHeight": true, "layout": "form", "title": "Phonetische Suche", "items": [ p2_1_panel3545, p2_2_panel3552 ], "frame": true, "bodyBorder": false, "autoScroll": false, "hideCheckBoxLabels": true, "border": false, "anchor": "-20", "labelAlign": "top" });
    var main_panel3557 = new Ext.Panel({ "hideCheckBoxLabels": true, "autoHeight": true, "border": false, "layout": "form", "autoScroll": false, "items": [ main_1_panel3539, p2_panel3556 ], "frame": true, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel3557;
    this.before_row_edit = function(record) {
    }
    Lino.cbss.IdentifyPersonRequests.InsertFormPanel.superclass.initComponent.call(this);
    // active_fields:
    person3537.on("change",function(){this.save()},this);
  }
});


Lino.languages.Languages.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 41,
  initComponent : function() {
    var containing_panel = this;
    var id3100 = new Ext.form.TextField({ "fieldLabel": "id", "name": "id", "boxMinWidth": Lino.chars2width(3), "listeners": { "render": Lino.quicktip_renderer("id","(languages.Languages.id) ") }, "maxLength": 3, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var iso23101 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("iso2","(languages.Languages.iso2) ") }, "fieldLabel": "iso2", "name": "iso2", "maxLength": 2, "selectOnFocus": true, "boxMinWidth": Lino.chars2width(2), "anchor": "-20" });
    var name3102 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Bezeichnung","(languages.Languages.name) ") }, "fieldLabel": "Bezeichnung", "name": "name", "maxLength": 200, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var name_fr3103 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Bezeichnung (fr)","(languages.Languages.name_fr) ") }, "fieldLabel": "Bezeichnung (fr)", "name": "name_fr", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var name_de3104 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Bezeichnung (de)","(languages.Languages.name_de) ") }, "fieldLabel": "Bezeichnung (de)", "name": "name_de", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var name_nl3105 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Bezeichnung (nl)","(languages.Languages.name_nl) ") }, "fieldLabel": "Bezeichnung (nl)", "name": "name_nl", "maxLength": 200, "selectOnFocus": true, "hidden": true, "anchor": "-20" });
    var main_1_panel3106 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 153, "hideCheckBoxLabels": true, "items": [ { "flex": 4, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id3100, "labelAlign": "top" }, { "flex": 4, "autoHeight": true, "layout": "form", "xtype": "panel", "items": iso23101, "labelAlign": "top" }, { "flex": 22, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name3102, "labelAlign": "top" }, { "flex": 22, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_fr3103, "labelAlign": "top" }, { "flex": 22, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_de3104, "labelAlign": "top" }, { "flex": 22, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_nl3105, "hidden": true, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var main_panel3120 = new Ext.Panel({ "autoScroll": false, "border": false, "layout": "vbox", "hideCheckBoxLabels": true, "items": [ main_1_panel3106 ], "frame": true, "layoutConfig": { "align": "stretch" }, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel3120;
    this.before_row_edit = function(record) {
    }
    Lino.languages.Languages.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.cal.MyPresences.InsertFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  autoHeight: true,
  content_type: 36,
  initComponent : function() {
    var containing_panel = this;
    var event1305 = new Lino.TwinCombo({ "fieldLabel": "Termin", "allowBlank": false, "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.cal.OneEvent.detail)}, "emptyText": "Termin ausw\u00e4hlen...", "listeners": { "render": Lino.quicktip_renderer("Termin","(cal.Guests.event) ") }, "selectOnFocus": true, "hiddenName": "eventHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/Guests/event", "method": "GET" }) }), "name": "event" });
    var partner1306 = new Lino.TwinCombo({ "preferred_width": 20, "fieldLabel": "Partner", "allowBlank": false, "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.contacts.Partners.detail)}, "emptyText": "Partner ausw\u00e4hlen...", "listeners": { "render": Lino.quicktip_renderer("Partner","(cal.Guests.partner) ") }, "selectOnFocus": true, "hiddenName": "partnerHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/Guests/partner", "method": "GET" }) }), "name": "partner" });
    var role1307 = new Lino.TwinCombo({ "fieldLabel": "Rolle", "name": "role", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.cal.GuestRoles.detail)}, "emptyText": "Gastrolle ausw\u00e4hlen...", "listeners": { "render": Lino.quicktip_renderer("Rolle","(cal.Guests.role) ") }, "selectOnFocus": true, "hiddenName": "roleHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/Guests/role", "method": "GET" }) }) });
    var main_panel1308 = new Ext.Panel({ "hideCheckBoxLabels": true, "autoHeight": true, "border": false, "layout": "form", "labelWidth": 72, "autoScroll": false, "items": [ { "autoHeight": true, "layout": "form", "xtype": "panel", "items": event1305, "anchor": "-20", "labelAlign": "top" }, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": partner1306, "anchor": "-20", "labelAlign": "top" }, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": role1307, "anchor": "-20", "labelAlign": "top" } ], "frame": true, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel1308;
    this.before_row_edit = function(record) {
    }
    Lino.cal.MyPresences.InsertFormPanel.superclass.initComponent.call(this);
  }
});


Lino.users.MySettings.InsertFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  autoHeight: true,
  content_type: 7,
  initComponent : function() {
    var containing_panel = this;
    var username399 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Benutzername","(users.Users.username) Required. Must be unique.") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Benutzername</span>", "name": "username", "maxLength": 30, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var email400 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("e-mail address","(users.Users.email) ") }, "fieldLabel": "e-mail address", "name": "email", "maxLength": 75, "selectOnFocus": true, "anchor": "-20" });
    var main_1_panel401 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": username399, "labelAlign": "top" }, { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": email400, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 135, "border": false, "anchor": "-20", "labelAlign": "top" });
    var first_name404 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Vorname","(users.Users.first_name) ") }, "fieldLabel": "Vorname", "name": "first_name", "maxLength": 30, "selectOnFocus": true, "anchor": "-20" });
    var last_name405 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Familienname","(users.Users.last_name) ") }, "fieldLabel": "Familienname", "name": "last_name", "maxLength": 30, "selectOnFocus": true, "anchor": "-20" });
    var main_2_panel406 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": first_name404, "labelAlign": "top" }, { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": last_name405, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 117, "border": false, "anchor": "-20", "labelAlign": "top" });
    var partner409 = new Lino.TwinCombo({ "preferred_width": 20, "fieldLabel": "Partner", "name": "partner", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.contacts.Partners.detail)}, "hiddenName": "partnerHidden", "listeners": { "render": Lino.quicktip_renderer("Partner","(users.Users.partner) ") }, "selectOnFocus": true, "emptyText": "Partner ausw\u00e4hlen...", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/users/Users/partner", "method": "GET" }) }) });
    var language410 = new Lino.ChoicesFieldElement({ "listeners": { "render": Lino.quicktip_renderer("Sprache","(users.Users.language) ") }, "fieldLabel": "Sprache", "name": "language", "selectOnFocus": true, "anchor": "-20", "store": [ [ "en", "Englisch" ], [ "fr", "Franz\u00f6sisch" ], [ "de", "Deutsch" ], [ "nl", "Niederl\u00e4ndisch" ] ], "hiddenName": "languageHidden" });
    var profile411 = new Lino.ChoicesFieldElement({ "forceSelection": true, "fieldLabel": "Benutzerprofil", "name": "profile", "hiddenName": "profileHidden", "listeners": { "render": Lino.quicktip_renderer("Benutzerprofil","(users.Users.profile) ") }, "selectOnFocus": true, "anchor": "-20", "store": [['','<br>']].concat(Lino.lino.UserProfiles) });
    var main_4_panel412 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 35, "autoHeight": true, "layout": "form", "xtype": "panel", "items": language410, "labelAlign": "top" }, { "flex": 64, "autoHeight": true, "layout": "form", "xtype": "panel", "items": profile411, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 135, "border": false, "anchor": "-20", "labelAlign": "top" });
    var main_panel415 = new Ext.Panel({ "hideCheckBoxLabels": true, "autoHeight": true, "border": false, "layout": "form", "labelWidth": 72, "autoScroll": false, "items": [ main_1_panel401, main_2_panel406, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": partner409, "anchor": "-20", "labelAlign": "top" }, main_4_panel412 ], "frame": true, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel415;
    this.before_row_edit = function(record) {
    }
    Lino.users.MySettings.InsertFormPanel.superclass.initComponent.call(this);
    // active_fields:
    partner409.on("change",function(){this.save()},this);
  }
});


Lino.about.Models.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  disable_editing: true,
  initComponent : function() {
    var containing_panel = this;
    var app_disp3695 = new Ext.form.DisplayField({ "disabled": true, "listeners": { "render": Lino.quicktip_renderer("app_label","(about.Models.app) ") }, "fieldLabel": "app_label", "name": "app", "anchor": "-20", "value": "<br/>", "always_enabled": true });
    var name_disp3696 = new Ext.form.DisplayField({ "disabled": true, "listeners": { "render": Lino.quicktip_renderer("name","(about.Models.name) ") }, "fieldLabel": "name", "name": "name", "anchor": "-20", "value": "<br/>", "always_enabled": true });
    var docstring_disp3697 = new Ext.form.DisplayField({ "disabled": true, "listeners": { "render": Lino.quicktip_renderer("docstring","(about.Models.docstring) ") }, "fieldLabel": "docstring", "name": "docstring", "anchor": "-20", "value": "<br/>", "always_enabled": true });
    var rows3698 = new Ext.form.NumberField({ "disabled": true, "listeners": { "render": Lino.quicktip_renderer("Zeilen","(about.Models.rows) ") }, "fieldLabel": "Zeilen", "anchor": "-20", "name": "rows" });
    var main_1_panel3699 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 90, "hideCheckBoxLabels": true, "items": [ { "flex": 31, "autoHeight": true, "layout": "form", "xtype": "panel", "items": app_disp3695, "labelAlign": "top" }, { "flex": 31, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_disp3696, "labelAlign": "top" }, { "flex": 31, "autoHeight": true, "layout": "form", "xtype": "panel", "items": docstring_disp3697, "labelAlign": "top" }, { "flex": 5, "autoHeight": true, "layout": "form", "xtype": "panel", "items": rows3698, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var about_FieldsByModel_grid3708 = new Lino.about.FieldsByModel.GridPanel({ "flex": 62, "listeners": { "render": Lino.quicktip_renderer("Felder","(about.about.FieldsByModel) ") }, "hide_top_toolbar": true, "containing_panel": this, "tools": [ Lino.show_in_own_window_button(Lino.about.FieldsByModel.grid) ], "master_panel": this });
    var main_panel3709 = new Ext.Panel({ "autoScroll": false, "border": false, "layout": "vbox", "hideCheckBoxLabels": true, "items": [ main_1_panel3699, about_FieldsByModel_grid3708 ], "frame": true, "layoutConfig": { "align": "stretch" }, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel3709;
    this.before_row_edit = function(record) {
      about_FieldsByModel_grid3708.on_master_changed();
    }
    Lino.about.Models.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.cal.MyTasks.InsertFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  autoHeight: true,
  content_type: 29,
  initComponent : function() {
    var containing_panel = this;
    var summary347 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Kurzbeschreibung","(cal.Tasks.summary) ") }, "fieldLabel": "Kurzbeschreibung", "name": "summary", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var user348 = new Lino.TwinCombo({ "preferred_width": 15, "fieldLabel": "Autor", "name": "user", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.users.Users.detail)}, "hiddenName": "userHidden", "listeners": { "render": Lino.quicktip_renderer("Autor","(cal.Tasks.user) ") }, "selectOnFocus": true, "emptyText": "Benutzer ausw\u00e4hlen...", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/Tasks/user", "method": "GET" }) }) });
    var project349 = new Lino.TwinCombo({ "preferred_width": 20, "fieldLabel": "Klient", "name": "project", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.pcsw.Clients.detail)}, "hiddenName": "projectHidden", "listeners": { "render": Lino.quicktip_renderer("Klient","(cal.Tasks.project) ") }, "selectOnFocus": true, "emptyText": "Klient ausw\u00e4hlen...", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/Tasks/project", "method": "GET" }) }) });
    var main_2_panel350 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": user348, "labelAlign": "top" }, { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": project349, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 63, "border": false, "anchor": "-20", "labelAlign": "top" });
    var main_panel353 = new Ext.Panel({ "hideCheckBoxLabels": true, "autoHeight": true, "border": false, "layout": "form", "labelWidth": 153, "autoScroll": false, "items": [ { "autoHeight": true, "layout": "form", "xtype": "panel", "items": summary347, "anchor": "-20", "labelAlign": "top" }, main_2_panel350 ], "frame": true, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel353;
    this.before_row_edit = function(record) {
    }
    Lino.cal.MyTasks.InsertFormPanel.superclass.initComponent.call(this);
  }
});


Lino.cal.PanelCalendars.InsertFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  autoHeight: true,
  content_type: 33,
  initComponent : function() {
    var containing_panel = this;
    var name1354 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Bezeichnung","(cal.Calendars.name) ") }, "fieldLabel": "Bezeichnung", "name": "name", "maxLength": 200, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var name_fr1355 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Bezeichnung (fr)","(cal.Calendars.name_fr) ") }, "fieldLabel": "Bezeichnung (fr)", "name": "name_fr", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var name_de1356 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Bezeichnung (de)","(cal.Calendars.name_de) ") }, "fieldLabel": "Bezeichnung (de)", "name": "name_de", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var name_nl1357 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Bezeichnung (nl)","(cal.Calendars.name_nl) ") }, "fieldLabel": "Bezeichnung (nl)", "name": "name_nl", "maxLength": 200, "selectOnFocus": true, "hidden": true, "anchor": "-20" });
    var main_1_panel1358 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 25, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name1354, "labelAlign": "top" }, { "flex": 25, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_fr1355, "labelAlign": "top" }, { "flex": 25, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_de1356, "labelAlign": "top" }, { "flex": 25, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_nl1357, "hidden": true, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 153, "border": false, "anchor": "-20", "labelAlign": "top" });
    var type1363 = new Lino.ChoicesFieldElement({ "fieldLabel": "Art", "allowBlank": false, "value": "local", "hiddenName": "typeHidden", "listeners": { "render": Lino.quicktip_renderer("Art","(cal.Calendars.type) ") }, "selectOnFocus": true, "anchor": "-20", "store": [ [ "local", "Local Calendar" ], [ "google", "Google Calendar" ] ], "name": "type" });
    var invite_team_members1364 = new Lino.RemoteComboFieldElement({ "fieldLabel": "Team", "name": "invite_team_members", "pageSize": 20, "emptyText": "Team ausw\u00e4hlen...", "listeners": { "render": Lino.quicktip_renderer("Team","(cal.Calendars.invite_team_members) ") }, "selectOnFocus": true, "hiddenName": "invite_team_membersHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/Calendars/invite_team_members", "method": "GET" }) }) });
    var color1365 = new Ext.form.NumberField({ "listeners": { "render": Lino.quicktip_renderer("Farbe","(cal.Calendars.color) ") }, "fieldLabel": "Farbe", "name": "color", "selectOnFocus": true, "anchor": "-20", "value": 1, "allowBlank": false });
    var main_2_panel1366 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 44, "autoHeight": true, "layout": "form", "xtype": "panel", "items": type1363, "labelAlign": "top" }, { "flex": 44, "autoHeight": true, "layout": "form", "xtype": "panel", "items": invite_team_members1364, "labelAlign": "top" }, { "flex": 11, "autoHeight": true, "layout": "form", "xtype": "panel", "items": color1365, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 54, "border": false, "anchor": "-20", "labelAlign": "top" });
    var invite_client1370 = new Ext.form.Checkbox({ "boxLabel": "Klient einladen", "listeners": { "render": Lino.quicktip_renderer("Klient einladen","(cal.Calendars.invite_client) ") }, "hideLabel": true, "checked": false, "name": "invite_client", "selectOnFocus": true, "anchor": "-20" });
    var main_panel1371 = new Ext.Panel({ "hideCheckBoxLabels": true, "autoHeight": true, "border": false, "layout": "form", "labelWidth": 144, "autoScroll": false, "items": [ main_1_panel1358, main_2_panel1366, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": invite_client1370, "anchor": "-20", "labelAlign": "top" } ], "frame": true, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel1371;
    this.before_row_edit = function(record) {
    }
    Lino.cal.PanelCalendars.InsertFormPanel.superclass.initComponent.call(this);
  }
});


Lino.about.About.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  disable_editing: true,
  initComponent : function() {
    var containing_panel = this;
    var server_status_disp3718 = new Ext.form.DisplayField({ "disabled": true, "listeners": { "render": Lino.quicktip_renderer("Server-Status","(about.About.server_status) ") }, "fieldLabel": "Server-Status", "name": "server_status", "anchor": "-20", "value": "<br/>", "always_enabled": true });
    var main_panel3719 = new Ext.Panel({ "autoScroll": false, "border": false, "layout": "vbox", "labelWidth": 126, "hideCheckBoxLabels": true, "items": [ { "flex": 25, "html": "<div class=\"htmlText\"><span>This is <a href=\"http://welfare.lino-framework.org\" target=\"_blank\">Lino Welfare</a> 1.1.9 using <a href=\"http://www.lino-framework.org\" target=\"_blank\">Lino</a> 1.6.11, <a href=\"http://jinja.pocoo.org/\" target=\"_blank\">Jinja</a> 2.6, <a href=\"http://sphinx-doc.org/\" target=\"_blank\">Sphinx</a> 1.2b1, <a href=\"http://labix.org/python-dateutil\" target=\"_blank\">python-dateutil</a> 2.1, <a href=\"http://pypi.python.org/pypi/odfpy\" target=\"_blank\">OdfPy</a> ODFPY/0.9.6, <a href=\"http://docutils.sourceforge.net/\" target=\"_blank\">docutils</a> 0.8.1, <a href=\"https://fedorahosted.org/suds/\" target=\"_blank\">suds</a> 0.4, <a href=\"http://pyyaml.org/\" target=\"_blank\">PyYaml</a> 3.10, <a href=\"http://appyframework.org/pod.html\" target=\"_blank\">Appy</a> 0.8.3 (2013/02/22 15:29), <a href=\"http://babel.edgewall.org/\" target=\"_blank\">Babel</a> 1.0, <a href=\"http://site.lino-framework.org\" target=\"_blank\">djangosite</a> 0.1.7, <a href=\"http://www.djangoproject.com\" target=\"_blank\">Django</a> 1.5.1, <a href=\"http://www.python.org/\" target=\"_blank\">Python</a> 2.7.3, <a href=\"http://www.sencha.com\" target=\"_blank\">ExtJS</a> <a href=\"#\" onclick=\"alert('ExtJS client version is ' + Ext.version);\" title=\"Click to see ExtJS client version\">(version)</a>, <a href=\"http://ext.ensible.com/products/calendar/\" target=\"_blank\">Extensible</a> <a href=\"#\" onclick=\"alert('Extensible Calendar version is ' + Ext.ensible.version);\" title=\"Click to see Extensible Calendar version\">(version)</a>, <a href=\"http://www.famfamfam.com/lab/icons/silk/\" target=\"_blank\">Silk Icons</a> 1.3</span><p>Server l&#228;uft seit : <b>Donnerstag, 29. August 2013 um 15:38:19.657040</b></p><p>Source timestamps:</p><ul><li>lino_welfare : <b>Donnerstag, 29. August 2013 um 15:38:18.483767</b></li><li>lino : <b>Donnerstag, 29. August 2013 um 15:29:53.719782</b></li><li>django : <b>Mittwoch, 28. August 2013 um 22:37:33.244067</b></li><li>north : <b>Mittwoch, 28. August 2013 um 11:25:41.253661</b></li><li>djangosite : <b>Mittwoch, 28. August 2013 um 10:33:15.877785</b></li><li>atelier : <b>Mittwoch, 28. August 2013 um 05:15:31.302605</b></li></ul></div>", "xtype": "label" }, { "items": server_status_disp3718, "autoHeight": true, "layout": "form", "xtype": "panel", "labelAlign": "top" } ], "frame": true, "layoutConfig": { "align": "stretch" }, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel3719;
    this.before_row_edit = function(record) {
    }
    Lino.about.About.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.countries.Countries.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 11,
  initComponent : function() {
    var containing_panel = this;
    var isocode433 = new Ext.form.TextField({ "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">ISO-Code</span>", "name": "isocode", "boxMinWidth": Lino.chars2width(4), "listeners": { "render": Lino.quicktip_renderer("ISO-Code","(countries.Countries.isocode)         The two-letter code for this country as defined by ISO 3166-1. \n        For countries that no longer exist it may be a 4-letter code.") }, "maxLength": 4, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var name434 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Bezeichnung","(countries.Countries.name) ") }, "fieldLabel": "Bezeichnung", "name": "name", "maxLength": 200, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var name_fr435 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Bezeichnung (fr)","(countries.Countries.name_fr) ") }, "fieldLabel": "Bezeichnung (fr)", "name": "name_fr", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var name_de436 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Bezeichnung (de)","(countries.Countries.name_de) ") }, "fieldLabel": "Bezeichnung (de)", "name": "name_de", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var name_nl437 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Bezeichnung (nl)","(countries.Countries.name_nl) ") }, "fieldLabel": "Bezeichnung (nl)", "name": "name_nl", "maxLength": 200, "selectOnFocus": true, "hidden": true, "anchor": "-20" });
    var short_code438 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Short code","(countries.Countries.short_code) A short abbreviation for regional usage. Obsolete.") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Short code</span>", "name": "short_code", "maxLength": 4, "selectOnFocus": true, "boxMinWidth": Lino.chars2width(4), "anchor": "-20" });
    var inscode439 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("INS-Code","(countries.Countries.inscode) The official code for this country used by statbel.fgov.be") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">INS-Code</span>", "name": "inscode", "maxLength": 3, "selectOnFocus": true, "boxMinWidth": Lino.chars2width(3), "anchor": "-20" });
    var main_1_panel440 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 153, "hideCheckBoxLabels": true, "items": [ { "flex": 5, "autoHeight": true, "layout": "form", "xtype": "panel", "items": isocode433, "labelAlign": "top" }, { "flex": 21, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name434, "labelAlign": "top" }, { "flex": 21, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_fr435, "labelAlign": "top" }, { "flex": 21, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_de436, "labelAlign": "top" }, { "flex": 21, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_nl437, "hidden": true, "labelAlign": "top" }, { "flex": 5, "autoHeight": true, "layout": "form", "xtype": "panel", "items": short_code438, "labelAlign": "top" }, { "flex": 4, "autoHeight": true, "layout": "form", "xtype": "panel", "items": inscode439, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var countries_CitiesByCountry_grid764 = new Lino.countries.CitiesByCountry.GridPanel({ "flex": 50, "listeners": { "render": Lino.quicktip_renderer("Orte","(countries.countries.CitiesByCountry) ") }, "hide_top_toolbar": true, "containing_panel": this, "tools": [ Lino.show_in_own_window_button(Lino.countries.CitiesByCountry.grid) ], "master_panel": this });
    var main_2_panel778 = new Ext.Panel({ "flex": 83, "border": false, "layout": "hbox", "hideCheckBoxLabels": true, "items": [ countries_CitiesByCountry_grid764 ], "autoScroll": false, "layoutConfig": { "align": "stretch" }, "frame": false, "labelAlign": "top" });
    var main_panel779 = new Ext.Panel({ "autoScroll": false, "border": false, "layout": "vbox", "hideCheckBoxLabels": true, "items": [ main_1_panel440, main_2_panel778 ], "frame": true, "layoutConfig": { "align": "stretch" }, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel779;
    this.before_row_edit = function(record) {
      countries_CitiesByCountry_grid764.on_master_changed();
    }
    Lino.countries.Countries.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.countries.CitiesByCity.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 12,
  initComponent : function() {
    var containing_panel = this;
    var name458 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Bezeichnung","(countries.Cities.name) ") }, "fieldLabel": "Bezeichnung", "name": "name", "maxLength": 200, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var name_fr459 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Bezeichnung (fr)","(countries.Cities.name_fr) ") }, "fieldLabel": "Bezeichnung (fr)", "name": "name_fr", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var name_de460 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Bezeichnung (de)","(countries.Cities.name_de) ") }, "fieldLabel": "Bezeichnung (de)", "name": "name_de", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var name_nl461 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Bezeichnung (nl)","(countries.Cities.name_nl) ") }, "fieldLabel": "Bezeichnung (nl)", "name": "name_nl", "maxLength": 200, "selectOnFocus": true, "hidden": true, "anchor": "-20" });
    var country462 = new Lino.TwinCombo({ "fieldLabel": "Land", "allowBlank": false, "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.countries.Countries.detail)}, "emptyText": "Land ausw\u00e4hlen...", "listeners": { "render": Lino.quicktip_renderer("Land","(countries.Cities.country) ") }, "selectOnFocus": true, "hiddenName": "countryHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/countries/Cities/country", "method": "GET" }) }), "name": "country" });
    var inscode463 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("INS-Code","(countries.Cities.inscode) The official code for this place used by statbel.fgov.be") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">INS-Code</span>", "name": "inscode", "maxLength": 5, "selectOnFocus": true, "boxMinWidth": Lino.chars2width(5), "anchor": "-20" });
    var zip_code464 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("zip code","(countries.Cities.zip_code) ") }, "fieldLabel": "zip code", "name": "zip_code", "maxLength": 8, "selectOnFocus": true, "boxMinWidth": Lino.chars2width(8), "anchor": "-20" });
    var main_1_panel465 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 153, "hideCheckBoxLabels": true, "items": [ { "flex": 17, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name458, "labelAlign": "top" }, { "flex": 17, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_fr459, "labelAlign": "top" }, { "flex": 17, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_de460, "labelAlign": "top" }, { "flex": 17, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_nl461, "hidden": true, "labelAlign": "top" }, { "flex": 16, "autoHeight": true, "layout": "form", "xtype": "panel", "items": country462, "labelAlign": "top" }, { "flex": 5, "autoHeight": true, "layout": "form", "xtype": "panel", "items": inscode463, "labelAlign": "top" }, { "flex": 7, "autoHeight": true, "layout": "form", "xtype": "panel", "items": zip_code464, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var parent473 = new Lino.TwinCombo({ "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Teil von</span>", "name": "parent", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.countries.Cities.detail)}, "emptyText": "Ort ausw\u00e4hlen...", "listeners": { "render": Lino.quicktip_renderer("Teil von","(countries.Cities.parent) The superordinate geographic place of which this place is a part.") }, "selectOnFocus": true, "hiddenName": "parentHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/countries/Cities/parent", "method": "GET" }) }) });
    var type474 = new Lino.RemoteComboFieldElement({ "listeners": { "render": Lino.quicktip_renderer("Ortsart","(countries.Cities.type) ") }, "fieldLabel": "Ortsart", "name": "type", "selectOnFocus": true, "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/countries/Cities/type", "method": "GET" }) }), "hiddenName": "typeHidden" });
    var id475 = new Ext.form.NumberField({ "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("ID","(countries.Cities.id) ") }, "fieldLabel": "ID", "anchor": "-20", "name": "id" });
    var main_2_panel476 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 81, "hideCheckBoxLabels": true, "items": [ { "flex": 57, "autoHeight": true, "layout": "form", "xtype": "panel", "items": parent473, "labelAlign": "top" }, { "flex": 28, "autoHeight": true, "layout": "form", "xtype": "panel", "items": type474, "labelAlign": "top" }, { "flex": 14, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id475, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var CitiesByCity_grid759 = new Lino.countries.CitiesByCity.GridPanel({ "flex": 41, "listeners": { "render": Lino.quicktip_renderer("Unterteilungen","(countries.countries.CitiesByCity) ") }, "hide_top_toolbar": true, "containing_panel": this, "tools": [ Lino.show_in_own_window_button(Lino.countries.CitiesByCity.grid) ], "master_panel": this });
    var contacts_PartnersByCity_grid760 = new Lino.contacts.PartnersByCity.GridPanel({ "flex": 50, "listeners": { "render": Lino.quicktip_renderer("Partner","(contacts.contacts.PartnersByCity) ") }, "hide_top_toolbar": true, "containing_panel": this, "tools": [ Lino.show_in_own_window_button(Lino.contacts.PartnersByCity.grid) ], "master_panel": this });
    var main_4_panel762 = new Ext.Panel({ "flex": 41, "border": false, "layout": "hbox", "hideCheckBoxLabels": true, "items": [ contacts_PartnersByCity_grid760 ], "autoScroll": false, "layoutConfig": { "align": "stretch" }, "frame": false, "labelAlign": "top" });
    var main_panel763 = new Ext.Panel({ "autoScroll": false, "border": false, "layout": "vbox", "hideCheckBoxLabels": true, "items": [ main_1_panel465, main_2_panel476, CitiesByCity_grid759, main_4_panel762 ], "frame": true, "layoutConfig": { "align": "stretch" }, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel763;
    this.before_row_edit = function(record) {
      type474.setContextValue('country',record ? record.data['countryHidden'] : undefined);
      CitiesByCity_grid759.on_master_changed();
      contacts_PartnersByCity_grid760.on_master_changed();
    }
    this.onRender = function(ct, position) {
      country462.on('change',Lino.chooser_handler(type474,'country'));
      Lino.countries.CitiesByCity.DetailFormPanel.superclass.onRender.call(this, ct, position);
    }
    Lino.countries.CitiesByCity.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.notes.MyNotes.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 93,
  initComponent : function() {
    var containing_panel = this;
    var date914 = new Lino.DateField({ "listeners": { "render": Lino.quicktip_renderer("Datum","(notes.Notes.date) ") }, "fieldLabel": "Datum", "name": "date", "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var event_type915 = new Lino.TwinCombo({ "fieldLabel": "Ereignisart (Form)", "name": "event_type", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.notes.EventTypes.detail)}, "emptyText": "Event Type ausw\u00e4hlen...", "listeners": { "render": Lino.quicktip_renderer("Ereignisart (Form)","(notes.Notes.event_type) ") }, "selectOnFocus": true, "hiddenName": "event_typeHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/notes/Notes/event_type", "method": "GET" }) }) });
    var type916 = new Lino.TwinCombo({ "fieldLabel": "Notizart (Inhalt)", "name": "type", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.notes.NoteTypes.detail)}, "emptyText": "Notizart ausw\u00e4hlen...", "listeners": { "render": Lino.quicktip_renderer("Notizart (Inhalt)","(notes.Notes.type) ") }, "selectOnFocus": true, "hiddenName": "typeHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/notes/Notes/type", "method": "GET" }) }) });
    var left_1_panel917 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 171, "hideCheckBoxLabels": true, "items": [ { "flex": 16, "autoHeight": true, "layout": "form", "xtype": "panel", "items": date914, "labelAlign": "top" }, { "flex": 41, "autoHeight": true, "layout": "form", "xtype": "panel", "items": event_type915, "labelAlign": "top" }, { "flex": 41, "autoHeight": true, "layout": "form", "xtype": "panel", "items": type916, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var project921 = new Lino.TwinCombo({ "preferred_width": 20, "fieldLabel": "Klient", "name": "project", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.pcsw.Clients.detail)}, "hiddenName": "projectHidden", "listeners": { "render": Lino.quicktip_renderer("Klient","(notes.Notes.project) ") }, "selectOnFocus": true, "emptyText": "Klient ausw\u00e4hlen...", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/notes/Notes/project", "method": "GET" }) }) });
    var subject922 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Betreff","(notes.Notes.subject) ") }, "fieldLabel": "Betreff", "name": "subject", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var left_2_panel923 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 72, "hideCheckBoxLabels": true, "items": [ { "flex": 48, "autoHeight": true, "layout": "form", "xtype": "panel", "items": project921, "labelAlign": "top" }, { "flex": 51, "autoHeight": true, "layout": "form", "xtype": "panel", "items": subject922, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var company926 = new Lino.TwinCombo({ "preferred_width": 20, "fieldLabel": "Empf\u00e4nger (Organisation)", "name": "company", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.contacts.Companies.detail)}, "hiddenName": "companyHidden", "listeners": { "render": Lino.quicktip_renderer("Empf\u00e4nger (Organisation)","(notes.Notes.company) ") }, "selectOnFocus": true, "emptyText": "Organisation ausw\u00e4hlen...", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/notes/Notes/company", "method": "GET" }) }) });
    var contact_person927 = new Lino.TwinCombo({ "preferred_width": 20, "fieldLabel": "Empf\u00e4nger (Person)", "name": "contact_person", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.contacts.Persons.detail)}, "hiddenName": "contact_personHidden", "listeners": { "render": Lino.quicktip_renderer("Empf\u00e4nger (Person)","(notes.Notes.contact_person) ") }, "selectOnFocus": true, "emptyText": "Person ausw\u00e4hlen...", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/notes/Notes/contact_person", "method": "GET" }) }) });
    var left_3_panel928 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 225, "hideCheckBoxLabels": true, "items": [ { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": company926, "labelAlign": "top" }, { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": contact_person927, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var user931 = new Lino.TwinCombo({ "preferred_width": 15, "fieldLabel": "Autor", "name": "user", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.users.Users.detail)}, "hiddenName": "userHidden", "listeners": { "render": Lino.quicktip_renderer("Autor","(notes.Notes.user) ") }, "selectOnFocus": true, "emptyText": "Benutzer ausw\u00e4hlen...", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/notes/Notes/user", "method": "GET" }) }) });
    var language932 = new Lino.ChoicesFieldElement({ "fieldLabel": "Sprache", "allowBlank": false, "hiddenName": "languageHidden", "listeners": { "render": Lino.quicktip_renderer("Sprache","(notes.Notes.language) ") }, "selectOnFocus": true, "anchor": "-20", "store": [ [ "en", "Englisch" ], [ "fr", "Franz\u00f6sisch" ], [ "de", "Deutsch" ], [ "nl", "Niederl\u00e4ndisch" ] ], "name": "language" });
    var build_time933 = new Ext.form.DisplayField({ "disabled": true, "listeners": { "render": Lino.quicktip_renderer("Druckdatum","(notes.Notes.build_time) ") }, "fieldLabel": "Druckdatum", "name": "build_time", "anchor": "-20", "value": "<br>" });
    var id934 = new Ext.form.NumberField({ "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("ID","(notes.Notes.id) ") }, "fieldLabel": "ID", "anchor": "-20", "name": "id" });
    var left_4_panel935 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 99, "hideCheckBoxLabels": true, "items": [ { "flex": 25, "autoHeight": true, "layout": "form", "xtype": "panel", "items": user931, "labelAlign": "top" }, { "flex": 20, "autoHeight": true, "layout": "form", "xtype": "panel", "items": language932, "labelAlign": "top" }, { "flex": 41, "autoHeight": true, "layout": "form", "xtype": "panel", "items": build_time933, "labelAlign": "top" }, { "flex": 12, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id934, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var body940 = new Lino.RichTextPanel({ "selectOnFocus": true, "flex": 55, "containing_panel": this, "name": "body", "title": "Inhalt" });
    var left_panel941 = new Ext.Panel({ "flex": 66, "layout": "vbox", "items": [ left_1_panel917, left_2_panel923, left_3_panel928, left_4_panel935, body940 ], "frame": true, "layoutConfig": { "align": "stretch" }, "autoScroll": false, "hideCheckBoxLabels": true, "labelWidth": 0, "border": false, "bodyBorder": false, "labelAlign": "top" });
    var UploadsByController_htmlbox942 = new Lino.HtmlBoxPanel({ "flex": 3, "ls_bbar_actions": [ { "itemId": "insert", "menu_item_text": "Neu", "must_save": true, "tooltip": "Neuen Datensatz erstellen", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-new", "overflowText": "Neu", "auto_save": true } ], "name": "UploadsByController", "containing_panel": this, "items": new Ext.BoxComponent({autoScroll:true}), "region": "north", "title": "Uploads", "master_panel": this, "value": "<br/>", "always_enabled": true, "listeners": { "render": Lino.quicktip_renderer("Uploads","(notes.Notes.UploadsByController) ") }, "bodyStyle": "overflow-x:hidden;", "ls_insert_handler": Lino.uploads.UploadsByController.insert, "layout": "fit", "tools": [ Lino.show_in_own_window_button(Lino.uploads.UploadsByController.grid) ], "split": true });
    var outbox_MailsByController_grid988 = new Lino.outbox.MailsByController.GridPanel({ "flex": 5, "hide_top_toolbar": true, "containing_panel": this, "region": "center", "master_panel": this, "listeners": { "render": Lino.quicktip_renderer("E-Mail-Ausg\u00e4nge","(outbox.outbox.MailsByController) ") }, "split": true, "tools": [ Lino.show_in_own_window_button(Lino.outbox.MailsByController.grid) ] });
    var cal_TasksByController_grid994 = new Lino.cal.TasksByController.GridPanel({ "flex": 5, "hide_top_toolbar": true, "containing_panel": this, "region": "south", "params_panel_hidden": true, "master_panel": this, "listeners": { "render": Lino.quicktip_renderer("Aufgaben","(cal.cal.TasksByController) ") }, "split": true, "tools": [ Lino.show_in_own_window_button(Lino.cal.TasksByController.grid) ] });
    var right_panel995 = new Lino.VBorderPanel({ "flex": 33, "border": false, "labelWidth": 72, "hideCheckBoxLabels": true, "items": [ UploadsByController_htmlbox942, outbox_MailsByController_grid988, cal_TasksByController_grid994 ], "frame": true, "autoScroll": false, "bodyBorder": false, "labelAlign": "top" });
    var main_1_panel996 = new Ext.Panel({ "autoScroll": false, "border": false, "layout": "hbox", "hideCheckBoxLabels": true, "items": [ left_panel941, right_panel995 ], "frame": false, "layoutConfig": { "align": "stretch" }, "labelAlign": "top" });
    var main_panel997 = new Ext.Panel({ "autoScroll": false, "border": false, "layout": "fit", "hideCheckBoxLabels": true, "items": [ main_1_panel996 ], "frame": true, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel997;
    this.before_row_edit = function(record) {
      contact_person927.setContextValue('company',record ? record.data['companyHidden'] : undefined);
      body940.refresh();
      UploadsByController_htmlbox942.refresh();
      outbox_MailsByController_grid988.on_master_changed();
      cal_TasksByController_grid994.on_master_changed();
    }
    this.onRender = function(ct, position) {
      company926.on('change',Lino.chooser_handler(contact_person927,'company'));
      Lino.notes.MyNotes.DetailFormPanel.superclass.onRender.call(this, ct, position);
    }
    Lino.notes.MyNotes.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.uploads.MyUploads.InsertFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  autoHeight: true,
  content_type: 25,
  initComponent : function() {
    var containing_panel = this;
    var file1467 = Lino.file_field_handler(this,{ "listeners": { "render": Lino.quicktip_renderer("File","(uploads.Uploads.file) ") }, "fieldLabel": "File", "name": "file", "maxLength": 100, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var user1468 = new Lino.TwinCombo({ "preferred_width": 15, "fieldLabel": "Autor", "name": "user", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.users.Users.detail)}, "hiddenName": "userHidden", "listeners": { "render": Lino.quicktip_renderer("Autor","(uploads.Uploads.user) ") }, "selectOnFocus": true, "emptyText": "Benutzer ausw\u00e4hlen...", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/uploads/Uploads/user", "method": "GET" }) }) });
    var main_1_panel1469 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 51, "autoHeight": true, "layout": "form", "xtype": "panel", "items": file1467, "labelAlign": "top" }, { "flex": 48, "autoHeight": true, "layout": "form", "xtype": "panel", "items": user1468, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 54, "border": false, "anchor": "-20", "labelAlign": "top" });
    var type1472 = new Lino.RemoteComboFieldElement({ "fieldLabel": "Upload-Art", "name": "type", "pageSize": 20, "emptyText": "Upload-Art ausw\u00e4hlen...", "listeners": { "render": Lino.quicktip_renderer("Upload-Art","(uploads.Uploads.type) ") }, "selectOnFocus": true, "hiddenName": "typeHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/uploads/Uploads/type", "method": "GET" }) }) });
    var valid_until1473 = new Lino.DateField({ "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("g\u00fcltig bis","(uploads.Uploads.valid_until) ") }, "fieldLabel": "g\u00fcltig bis", "anchor": "-20", "name": "valid_until" });
    var main_2_panel1474 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 71, "autoHeight": true, "layout": "form", "xtype": "panel", "items": type1472, "labelAlign": "top" }, { "flex": 28, "autoHeight": true, "layout": "form", "xtype": "panel", "items": valid_until1473, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 99, "border": false, "anchor": "-20", "labelAlign": "top" });
    var description1477 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Beschreibung","(uploads.Uploads.description) ") }, "fieldLabel": "Beschreibung", "name": "description", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var main_panel1478 = new Ext.Panel({ "hideCheckBoxLabels": true, "autoHeight": true, "border": false, "layout": "form", "labelWidth": 117, "autoScroll": false, "items": [ main_1_panel1469, main_2_panel1474, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": description1477, "anchor": "-20", "labelAlign": "top" } ], "frame": true, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel1478;
    this.before_row_edit = function(record) {
    }
    Lino.uploads.MyUploads.InsertFormPanel.superclass.initComponent.call(this);
  }
});


Lino.households.Households.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 39,
  initComponent : function() {
    var containing_panel = this;
    var type1516 = new Lino.TwinCombo({ "fieldLabel": "Haushaltsart", "name": "type", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.households.Types.detail)}, "emptyText": "Haushaltsart ausw\u00e4hlen...", "listeners": { "render": Lino.quicktip_renderer("Haushaltsart","(households.Households.type) ") }, "selectOnFocus": true, "hiddenName": "typeHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/households/Households/type", "method": "GET" }) }) });
    var name1517 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Name","(households.Households.name) ") }, "fieldLabel": "Name", "name": "name", "maxLength": 200, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var language1518 = new Lino.ChoicesFieldElement({ "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Sprache</span>", "allowBlank": false, "hiddenName": "languageHidden", "listeners": { "render": Lino.quicktip_renderer("Sprache","(households.Households.language) Die Sprache, in der Dokumente ausgestellt werden sollen.") }, "selectOnFocus": true, "anchor": "-20", "store": [ [ "en", "Englisch" ], [ "fr", "Franz\u00f6sisch" ], [ "de", "Deutsch" ], [ "nl", "Niederl\u00e4ndisch" ] ], "name": "language" });
    var id1519 = new Ext.form.NumberField({ "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("ID","(households.Households.id) ") }, "fieldLabel": "ID", "anchor": "-20", "name": "id" });
    var intro_box_1_panel1520 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 117, "hideCheckBoxLabels": true, "items": [ { "flex": 35, "autoHeight": true, "layout": "form", "xtype": "panel", "items": type1516, "labelAlign": "top" }, { "flex": 37, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name1517, "labelAlign": "top" }, { "flex": 17, "autoHeight": true, "layout": "form", "xtype": "panel", "items": language1518, "labelAlign": "top" }, { "flex": 8, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id1519, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var country1525 = new Lino.TwinCombo({ "fieldLabel": "Land", "name": "country", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.countries.Countries.detail)}, "emptyText": "Land ausw\u00e4hlen...", "listeners": { "render": Lino.quicktip_renderer("Land","(households.Households.country) ") }, "selectOnFocus": true, "hiddenName": "countryHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/households/Households/country", "method": "GET" }) }) });
    var region1526 = new Lino.TwinCombo({ "fieldLabel": "Region", "name": "region", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.countries.Cities.detail)}, "emptyText": "Ort ausw\u00e4hlen...", "listeners": { "render": Lino.quicktip_renderer("Region","(households.Households.region) ") }, "selectOnFocus": true, "hiddenName": "regionHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/households/Households/region", "method": "GET" }) }) });
    var box3_1_panel1527 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": country1525, "labelAlign": "top" }, { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": region1526, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 63, "border": false, "anchor": "-20", "labelAlign": "top" });
    var city1530 = new Lino.TwinCombo({ "forceSelection": false, "fieldLabel": "Ort", "name": "city", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.countries.Cities.detail)}, "emptyText": "Ort ausw\u00e4hlen...", "listeners": { "render": Lino.quicktip_renderer("Ort","(households.Households.city) ") }, "selectOnFocus": true, "hiddenName": "cityHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/households/Households/city", "method": "GET" }) }) });
    var zip_code1531 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Postleitzahl","(households.Households.zip_code) ") }, "fieldLabel": "Postleitzahl", "name": "zip_code", "maxLength": 10, "selectOnFocus": true, "boxMinWidth": Lino.chars2width(10), "anchor": "-20" });
    var box3_2_panel1532 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 66, "autoHeight": true, "layout": "form", "xtype": "panel", "items": city1530, "labelAlign": "top" }, { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": zip_code1531, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 117, "border": false, "anchor": "-20", "labelAlign": "top" });
    var street_prefix1535 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Pr\u00e4fix Stra\u00dfe","(households.Households.street_prefix) Text to print before name of street, but to ignore for sorting.") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Pr\u00e4fix Stra\u00dfe</span>", "name": "street_prefix", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var street1536 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Stra\u00dfe","(households.Households.street) Name of street. Without house number.") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Stra\u00dfe</span>", "name": "street", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var street_no1537 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Nr.","(households.Households.street_no) House number") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Nr.</span>", "name": "street_no", "maxLength": 10, "selectOnFocus": true, "boxMinWidth": Lino.chars2width(10), "anchor": "-20" });
    var street_box1538 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Box","(households.Households.street_box) Text to print after :attr:`steet_no` on the same line") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Box</span>", "name": "street_box", "maxLength": 10, "selectOnFocus": true, "boxMinWidth": Lino.chars2width(10), "anchor": "-20" });
    var box3_3_panel1539 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 30, "autoHeight": true, "layout": "form", "xtype": "panel", "items": street_prefix1535, "labelAlign": "top" }, { "flex": 36, "autoHeight": true, "layout": "form", "xtype": "panel", "items": street1536, "labelAlign": "top" }, { "flex": 16, "autoHeight": true, "layout": "form", "xtype": "panel", "items": street_no1537, "labelAlign": "top" }, { "flex": 16, "autoHeight": true, "layout": "form", "xtype": "panel", "items": street_box1538, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 126, "border": false, "anchor": "-20", "labelAlign": "top" });
    var addr21544 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Adresszeile nach Stra\u00dfe","(households.Households.addr2) Address line to print below street line") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Adresszeile nach Stra\u00dfe</span>", "name": "addr2", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var activity1545 = new Lino.RemoteComboFieldElement({ "fieldLabel": "Beruf", "name": "activity", "pageSize": 20, "emptyText": "Beruf ausw\u00e4hlen...", "listeners": { "render": Lino.quicktip_renderer("Beruf","(households.Households.activity) ") }, "selectOnFocus": true, "hiddenName": "activityHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/households/Households/activity", "method": "GET" }) }) });
    var bank_account11546 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Bankkonto 1","(households.Households.bank_account1) ") }, "fieldLabel": "Bankkonto 1", "name": "bank_account1", "maxLength": 40, "selectOnFocus": true, "anchor": "-20" });
    var bank_account21547 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Bankkonto 2","(households.Households.bank_account2) ") }, "fieldLabel": "Bankkonto 2", "name": "bank_account2", "maxLength": 40, "selectOnFocus": true, "anchor": "-20" });
    var box3_5_panel1548 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 45, "autoHeight": true, "layout": "form", "xtype": "panel", "items": activity1545, "labelAlign": "top" }, { "flex": 27, "autoHeight": true, "layout": "form", "xtype": "panel", "items": bank_account11546, "labelAlign": "top" }, { "flex": 27, "autoHeight": true, "layout": "form", "xtype": "panel", "items": bank_account21547, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 108, "border": false, "anchor": "-20", "labelAlign": "top" });
    var box3_panel1552 = new Ext.Panel({ "flex": 62, "autoHeight": true, "layout": "form", "items": [ box3_1_panel1527, box3_2_panel1532, box3_3_panel1539, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": addr21544, "anchor": "-20", "labelAlign": "top" }, box3_5_panel1548 ], "frame": true, "bodyBorder": false, "autoScroll": false, "hideCheckBoxLabels": true, "labelWidth": 216, "border": false, "labelAlign": "top" });
    var email1554 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("E-Mail","(households.Households.email) ") }, "fieldLabel": "E-Mail", "name": "email", "maxLength": 75, "selectOnFocus": true, "anchor": "-20" });
    var url1555 = new Lino.URLField({ "listeners": { "render": Lino.quicktip_renderer("URL","(households.Households.url) ") }, "fieldLabel": "URL", "name": "url", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var phone1556 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Telefon","(households.Households.phone) ") }, "fieldLabel": "Telefon", "name": "phone", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var gsm1557 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("GSM","(households.Households.gsm) ") }, "fieldLabel": "GSM", "name": "gsm", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var box4_panel1558 = new Ext.Panel({ "flex": 37, "autoHeight": true, "layout": "form", "items": [ { "autoHeight": true, "layout": "form", "xtype": "panel", "items": email1554, "anchor": "-20", "labelAlign": "top" }, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": url1555, "anchor": "-20", "labelAlign": "top" }, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": phone1556, "anchor": "-20", "labelAlign": "top" }, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": gsm1557, "anchor": "-20", "labelAlign": "top" } ], "frame": true, "bodyBorder": false, "autoScroll": false, "hideCheckBoxLabels": true, "labelWidth": 72, "border": false, "labelAlign": "top" });
    var address_box_panel1563 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "hideCheckBoxLabels": true, "items": [ box3_panel1552, box4_panel1558 ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var remarks1564 = new Ext.form.TextArea({ "listeners": { "render": Lino.quicktip_renderer("Bemerkungen","(households.Households.remarks) ") }, "fieldLabel": "Bemerkungen", "name": "remarks", "growMax": 2000, "selectOnFocus": true, "anchor": "-20 -10" });
    var households_MembersByHousehold_grid1571 = new Lino.households.MembersByHousehold.GridPanel({ "flex": 50, "listeners": { "render": Lino.quicktip_renderer("Mitglieder","(households.households.MembersByHousehold) ") }, "hide_top_toolbar": true, "containing_panel": this, "tools": [ Lino.show_in_own_window_button(Lino.households.MembersByHousehold.grid) ], "master_panel": this });
    var bottom_box_panel1572 = new Ext.Panel({ "flex": 45, "border": false, "layout": "hbox", "labelWidth": 108, "hideCheckBoxLabels": true, "items": [ { "items": remarks1564, "labelAlign": "top", "layout": "form", "xtype": "panel", "flex": 49 }, households_MembersByHousehold_grid1571 ], "autoScroll": false, "layoutConfig": { "align": "stretch" }, "frame": false, "labelAlign": "top" });
    var general_panel1574 = new Ext.Panel({ "layout": "vbox", "title": "Allgemein", "items": [ intro_box_1_panel1520, address_box_panel1563, bottom_box_panel1572 ], "frame": true, "layoutConfig": { "align": "stretch" }, "hideCheckBoxLabels": true, "listeners": { "activate": Lino.on_tab_activate }, "autoScroll": false, "border": false, "bodyBorder": false, "labelAlign": "top" });
    var main_panel1578 = new Ext.TabPanel({ "hideCheckBoxLabels": true, "border": false, "split": true, "autoScroll": false, "items": [ general_panel1574 ], "activeTab": 0, "bodyBorder": false, "frame": true, "labelAlign": "top" });
    this.items = main_panel1578;
    this.before_row_edit = function(record) {
      region1526.setContextValue('country',record ? record.data['countryHidden'] : undefined);
      city1530.setContextValue('country',record ? record.data['countryHidden'] : undefined);
      city1530.setContextValue('region',record ? record.data['regionHidden'] : undefined);
      households_MembersByHousehold_grid1571.on_master_changed();
    }
    this.onRender = function(ct, position) {
      country1525.on('change',Lino.chooser_handler(region1526,'country'));
      country1525.on('change',Lino.chooser_handler(city1530,'country'));
      region1526.on('change',Lino.chooser_handler(city1530,'region'));
      Lino.households.Households.DetailFormPanel.superclass.onRender.call(this, ct, position);
    }
    Lino.households.Households.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.cbss.ManageAccessRequests.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 90,
  initComponent : function() {
    var containing_panel = this;
    var id3558 = new Ext.form.NumberField({ "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("ID","(cbss.ManageAccessRequests.id) ") }, "fieldLabel": "ID", "anchor": "-20", "name": "id" });
    var person3559 = new Lino.TwinCombo({ "preferred_width": 20, "fieldLabel": "Klient", "allowBlank": false, "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.pcsw.Clients.detail)}, "emptyText": "Klient ausw\u00e4hlen...", "listeners": { "render": Lino.quicktip_renderer("Klient","(cbss.ManageAccessRequests.person) ") }, "selectOnFocus": true, "hiddenName": "personHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cbss/ManageAccessRequests/person", "method": "GET" }) }), "name": "person" });
    var user3560 = new Lino.TwinCombo({ "preferred_width": 15, "fieldLabel": "Autor", "allowBlank": false, "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.users.Users.detail)}, "emptyText": "Benutzer ausw\u00e4hlen...", "listeners": { "render": Lino.quicktip_renderer("Autor","(cbss.ManageAccessRequests.user) ") }, "selectOnFocus": true, "hiddenName": "userHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cbss/ManageAccessRequests/user", "method": "GET" }) }), "name": "user" });
    var environment3561 = new Ext.form.TextField({ "disabled": true, "listeners": { "render": Lino.quicktip_renderer("T/A/B","(cbss.ManageAccessRequests.environment) ") }, "fieldLabel": "T/A/B", "name": "environment", "maxLength": 4, "boxMinWidth": Lino.chars2width(4), "anchor": "-20" });
    var sent3562 = new Ext.form.DisplayField({ "disabled": true, "listeners": { "render": Lino.quicktip_renderer("Versendet","(cbss.ManageAccessRequests.sent) The date and time when this request has been executed. \nThis is empty for requests than haven't been sent.\nRead-only.") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Versendet</span>", "name": "sent", "anchor": "-20", "value": "<br>" });
    var status3563 = new Lino.ChoicesFieldElement({ "forceSelection": true, "fieldLabel": "Zustand", "name": "status", "hiddenName": "statusHidden", "disabled": true, "listeners": { "render": Lino.quicktip_renderer("Zustand","(cbss.ManageAccessRequests.status) ") }, "anchor": "-20", "store": [['','<br>']].concat(Lino.cbss.RequestStates) });
    var ticket3564 = new Ext.form.TextField({ "disabled": true, "listeners": { "render": Lino.quicktip_renderer("Ticket","(cbss.ManageAccessRequests.ticket) ") }, "fieldLabel": "Ticket", "name": "ticket", "maxLength": 36, "anchor": "-20" });
    var info_1_panel3565 = new Ext.form.FieldSet({ "autoHeight": true, "layout": "hbox", "title": "Info zur Anfrage", "layoutConfig": { "align": "stretchmax" }, "frame": false, "bodyBorder": true, "autoScroll": false, "items": [ { "flex": 5, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id3558, "labelAlign": "top" }, { "flex": 20, "autoHeight": true, "layout": "form", "xtype": "panel", "items": person3559, "labelAlign": "top" }, { "flex": 20, "autoHeight": true, "layout": "form", "xtype": "panel", "items": user3560, "labelAlign": "top" }, { "flex": 5, "autoHeight": true, "layout": "form", "xtype": "panel", "items": environment3561, "labelAlign": "top" }, { "flex": 16, "autoHeight": true, "layout": "form", "xtype": "panel", "items": sent3562, "labelAlign": "top" }, { "flex": 12, "autoHeight": true, "layout": "form", "xtype": "panel", "items": status3563, "labelAlign": "top" }, { "flex": 21, "autoHeight": true, "layout": "form", "xtype": "panel", "items": ticket3564, "labelAlign": "top" } ], "hideCheckBoxLabels": true, "labelWidth": 90, "border": false, "labelAlign": "top" });
    var action3573 = new Lino.ChoicesFieldElement({ "forceSelection": true, "fieldLabel": "Aktion", "allowBlank": false, "hiddenName": "actionHidden", "listeners": { "render": Lino.quicktip_renderer("Aktion","(cbss.ManageAccessRequests.action) ") }, "selectOnFocus": true, "anchor": "-20", "store": Lino.cbss.ManageAction, "name": "action" });
    var start_date3574 = new Lino.DateField({ "listeners": { "render": Lino.quicktip_renderer("Periode vom","(cbss.ManageAccessRequests.start_date) ") }, "fieldLabel": "Periode vom", "name": "start_date", "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var end_date3575 = new Lino.DateField({ "listeners": { "render": Lino.quicktip_renderer("Periode bis","(cbss.ManageAccessRequests.end_date) ") }, "fieldLabel": "Periode bis", "name": "end_date", "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var p1_1_panel3576 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 44, "autoHeight": true, "layout": "form", "xtype": "panel", "items": action3573, "labelAlign": "top" }, { "flex": 27, "autoHeight": true, "layout": "form", "xtype": "panel", "items": start_date3574, "labelAlign": "top" }, { "flex": 27, "autoHeight": true, "layout": "form", "xtype": "panel", "items": end_date3575, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 108, "border": false, "anchor": "-20", "labelAlign": "top" });
    var purpose3580 = new Lino.RemoteComboFieldElement({ "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Eigenschafts-Code</span>", "allowBlank": false, "pageSize": 20, "emptyText": "Eigenschafts-Code ausw\u00e4hlen...", "listeners": { "render": Lino.quicktip_renderer("Eigenschafts-Code","(cbss.ManageAccessRequests.purpose) The purpose for which the inscription needs to be \nregistered/unregistered or listed. \nFor listing this field is optional, \nfor register/unregister it is mandatory.") }, "selectOnFocus": true, "hiddenName": "purposeHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cbss/ManageAccessRequests/purpose", "method": "GET" }) }), "name": "purpose" });
    var query_register3581 = new Lino.ChoicesFieldElement({ "forceSelection": true, "fieldLabel": "Abfrageregister", "allowBlank": false, "hiddenName": "query_registerHidden", "listeners": { "render": Lino.quicktip_renderer("Abfrageregister","(cbss.ManageAccessRequests.query_register) ") }, "selectOnFocus": true, "anchor": "-20", "store": Lino.cbss.QueryRegister, "name": "query_register" });
    var p1_2_panel3582 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 62, "autoHeight": true, "layout": "form", "xtype": "panel", "items": purpose3580, "labelAlign": "top" }, { "flex": 37, "autoHeight": true, "layout": "form", "xtype": "panel", "items": query_register3581, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 162, "border": false, "anchor": "-20", "labelAlign": "top" });
    var p1_panel3585 = new Ext.form.FieldSet({ "flex": 37, "autoHeight": true, "layout": "form", "title": "Angefragte Aktion", "items": [ p1_1_panel3576, p1_2_panel3582 ], "frame": true, "bodyBorder": false, "autoScroll": false, "hideCheckBoxLabels": true, "border": false, "labelAlign": "top" });
    var national_id3586 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("NR-Nummer","(cbss.ManageAccessRequests.national_id) The SSIN of the person to register/unregister/list.\n") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">NR-Nummer</span>", "name": "national_id", "maxLength": 200, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var sis_card_no3587 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("SIS-Karten-Nr","(cbss.ManageAccessRequests.sis_card_no) The number of the SIS card used to authenticate the person.") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">SIS-Karten-Nr</span>", "name": "sis_card_no", "maxLength": 10, "selectOnFocus": true, "boxMinWidth": Lino.chars2width(10), "anchor": "-20" });
    var id_card_no3588 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("ID-Karten-Nr","(cbss.ManageAccessRequests.id_card_no) The number of the ID card used to authenticate the person.") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">ID-Karten-Nr</span>", "name": "id_card_no", "maxLength": 20, "selectOnFocus": true, "anchor": "-20" });
    var proof_1_panel3589 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 39, "autoHeight": true, "layout": "form", "xtype": "panel", "items": national_id3586, "labelAlign": "top" }, { "flex": 20, "autoHeight": true, "layout": "form", "xtype": "panel", "items": sis_card_no3587, "labelAlign": "top" }, { "flex": 39, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id_card_no3588, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 126, "border": false, "anchor": "-20", "labelAlign": "top" });
    var first_name3593 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Vorname","(cbss.ManageAccessRequests.first_name) ") }, "fieldLabel": "Vorname", "name": "first_name", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var last_name3594 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Familienname","(cbss.ManageAccessRequests.last_name) ") }, "fieldLabel": "Familienname", "name": "last_name", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var birth_date3595 = new Lino.IncompleteDateField({ "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Geburtsdatum","(cbss.ManageAccessRequests.birth_date) Uncomplete dates are allowed, e.g. \n\"00.00.1980\" means \"some day in 1980\", \n\"00.07.1980\" means \"in July 1980\"\nor \"23.07.0000\" means \"on a 23th of July\".") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Geburtsdatum</span>", "anchor": "-20", "name": "birth_date" });
    var proof_2_panel3596 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 38, "autoHeight": true, "layout": "form", "xtype": "panel", "items": first_name3593, "labelAlign": "top" }, { "flex": 38, "autoHeight": true, "layout": "form", "xtype": "panel", "items": last_name3594, "labelAlign": "top" }, { "flex": 22, "autoHeight": true, "layout": "form", "xtype": "panel", "items": birth_date3595, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 117, "border": false, "anchor": "-20", "labelAlign": "top" });
    var proof_panel3600 = new Ext.form.FieldSet({ "flex": 62, "autoHeight": true, "layout": "form", "title": "Authentifizierungsbeleg", "items": [ proof_1_panel3589, proof_2_panel3596 ], "frame": true, "bodyBorder": false, "autoScroll": false, "hideCheckBoxLabels": true, "border": false, "labelAlign": "top" });
    var parameters_panel3601 = new Ext.form.FieldSet({ "autoHeight": true, "layout": "hbox", "title": "Parameter", "layoutConfig": { "align": "stretchmax" }, "frame": false, "bodyBorder": true, "autoScroll": false, "items": [ p1_panel3585, proof_panel3600 ], "hideCheckBoxLabels": true, "border": false, "labelAlign": "top" });
    var result_htmlbox3602 = new Lino.HtmlBoxPanel({ "flex": 50, "layout": "fit", "name": "result", "containing_panel": this, "master_panel": this, "items": new Ext.BoxComponent({autoScroll:true}), "title": "Resultat", "bodyStyle": "overflow-x:hidden;", "value": "<br/>", "always_enabled": true, "listeners": { "render": Lino.quicktip_renderer("Resultat","(cbss.ManageAccessRequests.result) ") } });
    var request_panel3603 = new Ext.Panel({ "layout": "vbox", "title": "Abfrage", "items": [ info_1_panel3565, parameters_panel3601, result_htmlbox3602 ], "frame": true, "layoutConfig": { "align": "stretch" }, "hideCheckBoxLabels": true, "listeners": { "activate": Lino.on_tab_activate }, "autoScroll": false, "labelWidth": 81, "border": false, "bodyBorder": false, "labelAlign": "top" });
    var main_panel3611 = new Ext.TabPanel({ "hideCheckBoxLabels": true, "border": false, "split": true, "autoScroll": false, "items": [ request_panel3603 ], "activeTab": 0, "bodyBorder": false, "frame": true, "labelAlign": "top" });
    this.items = main_panel3611;
    this.before_row_edit = function(record) {
      purpose3580.setContextValue('sector',record ? record.data['sectorHidden'] : undefined);
      result_htmlbox3602.refresh();
    }
    Lino.cbss.ManageAccessRequests.DetailFormPanel.superclass.initComponent.call(this);
    // active_fields:
    person3559.on("change",function(){this.save()},this);
  }
});


Lino.cbss.ManageAccessRequests.InsertFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  autoHeight: true,
  content_type: 90,
  initComponent : function() {
    var containing_panel = this;
    var person3612 = new Lino.TwinCombo({ "preferred_width": 20, "fieldLabel": "Klient", "allowBlank": false, "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.pcsw.Clients.detail)}, "emptyText": "Klient ausw\u00e4hlen...", "listeners": { "render": Lino.quicktip_renderer("Klient","(cbss.ManageAccessRequests.person) ") }, "selectOnFocus": true, "hiddenName": "personHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cbss/ManageAccessRequests/person", "method": "GET" }) }), "name": "person" });
    var action3613 = new Lino.ChoicesFieldElement({ "forceSelection": true, "fieldLabel": "Aktion", "allowBlank": false, "hiddenName": "actionHidden", "listeners": { "render": Lino.quicktip_renderer("Aktion","(cbss.ManageAccessRequests.action) ") }, "selectOnFocus": true, "anchor": "-20", "store": Lino.cbss.ManageAction, "name": "action" });
    var start_date3614 = new Lino.DateField({ "listeners": { "render": Lino.quicktip_renderer("Periode vom","(cbss.ManageAccessRequests.start_date) ") }, "fieldLabel": "Periode vom", "name": "start_date", "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var end_date3615 = new Lino.DateField({ "listeners": { "render": Lino.quicktip_renderer("Periode bis","(cbss.ManageAccessRequests.end_date) ") }, "fieldLabel": "Periode bis", "name": "end_date", "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var p1_1_panel3616 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 44, "autoHeight": true, "layout": "form", "xtype": "panel", "items": action3613, "labelAlign": "top" }, { "flex": 27, "autoHeight": true, "layout": "form", "xtype": "panel", "items": start_date3614, "labelAlign": "top" }, { "flex": 27, "autoHeight": true, "layout": "form", "xtype": "panel", "items": end_date3615, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 108, "border": false, "anchor": "-20", "labelAlign": "top" });
    var purpose3620 = new Lino.RemoteComboFieldElement({ "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Eigenschafts-Code</span>", "allowBlank": false, "pageSize": 20, "emptyText": "Eigenschafts-Code ausw\u00e4hlen...", "listeners": { "render": Lino.quicktip_renderer("Eigenschafts-Code","(cbss.ManageAccessRequests.purpose) The purpose for which the inscription needs to be \nregistered/unregistered or listed. \nFor listing this field is optional, \nfor register/unregister it is mandatory.") }, "selectOnFocus": true, "hiddenName": "purposeHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cbss/ManageAccessRequests/purpose", "method": "GET" }) }), "name": "purpose" });
    var query_register3621 = new Lino.ChoicesFieldElement({ "forceSelection": true, "fieldLabel": "Abfrageregister", "allowBlank": false, "hiddenName": "query_registerHidden", "listeners": { "render": Lino.quicktip_renderer("Abfrageregister","(cbss.ManageAccessRequests.query_register) ") }, "selectOnFocus": true, "anchor": "-20", "store": Lino.cbss.QueryRegister, "name": "query_register" });
    var p1_2_panel3622 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 62, "autoHeight": true, "layout": "form", "xtype": "panel", "items": purpose3620, "labelAlign": "top" }, { "flex": 37, "autoHeight": true, "layout": "form", "xtype": "panel", "items": query_register3621, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 162, "border": false, "anchor": "-20", "labelAlign": "top" });
    var p1_panel3625 = new Ext.form.FieldSet({ "autoHeight": true, "layout": "form", "title": "Angefragte Aktion", "items": [ p1_1_panel3616, p1_2_panel3622 ], "frame": true, "bodyBorder": false, "autoScroll": false, "hideCheckBoxLabels": true, "border": false, "anchor": "-20", "labelAlign": "top" });
    var national_id3626 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("NR-Nummer","(cbss.ManageAccessRequests.national_id) The SSIN of the person to register/unregister/list.\n") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">NR-Nummer</span>", "name": "national_id", "maxLength": 200, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var sis_card_no3627 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("SIS-Karten-Nr","(cbss.ManageAccessRequests.sis_card_no) The number of the SIS card used to authenticate the person.") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">SIS-Karten-Nr</span>", "name": "sis_card_no", "maxLength": 10, "selectOnFocus": true, "boxMinWidth": Lino.chars2width(10), "anchor": "-20" });
    var id_card_no3628 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("ID-Karten-Nr","(cbss.ManageAccessRequests.id_card_no) The number of the ID card used to authenticate the person.") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">ID-Karten-Nr</span>", "name": "id_card_no", "maxLength": 20, "selectOnFocus": true, "anchor": "-20" });
    var proof_1_panel3629 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 39, "autoHeight": true, "layout": "form", "xtype": "panel", "items": national_id3626, "labelAlign": "top" }, { "flex": 20, "autoHeight": true, "layout": "form", "xtype": "panel", "items": sis_card_no3627, "labelAlign": "top" }, { "flex": 39, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id_card_no3628, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 126, "border": false, "anchor": "-20", "labelAlign": "top" });
    var first_name3633 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Vorname","(cbss.ManageAccessRequests.first_name) ") }, "fieldLabel": "Vorname", "name": "first_name", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var last_name3634 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Familienname","(cbss.ManageAccessRequests.last_name) ") }, "fieldLabel": "Familienname", "name": "last_name", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var birth_date3635 = new Lino.IncompleteDateField({ "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Geburtsdatum","(cbss.ManageAccessRequests.birth_date) Uncomplete dates are allowed, e.g. \n\"00.00.1980\" means \"some day in 1980\", \n\"00.07.1980\" means \"in July 1980\"\nor \"23.07.0000\" means \"on a 23th of July\".") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Geburtsdatum</span>", "anchor": "-20", "name": "birth_date" });
    var proof_2_panel3636 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 38, "autoHeight": true, "layout": "form", "xtype": "panel", "items": first_name3633, "labelAlign": "top" }, { "flex": 38, "autoHeight": true, "layout": "form", "xtype": "panel", "items": last_name3634, "labelAlign": "top" }, { "flex": 22, "autoHeight": true, "layout": "form", "xtype": "panel", "items": birth_date3635, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 117, "border": false, "anchor": "-20", "labelAlign": "top" });
    var proof_panel3640 = new Ext.form.FieldSet({ "autoHeight": true, "layout": "form", "title": "Authentifizierungsbeleg", "items": [ proof_1_panel3629, proof_2_panel3636 ], "frame": true, "bodyBorder": false, "autoScroll": false, "hideCheckBoxLabels": true, "border": false, "anchor": "-20", "labelAlign": "top" });
    var main_panel3641 = new Ext.Panel({ "hideCheckBoxLabels": true, "autoHeight": true, "border": false, "layout": "form", "labelWidth": 63, "autoScroll": false, "items": [ { "autoHeight": true, "layout": "form", "xtype": "panel", "items": person3612, "anchor": "-20", "labelAlign": "top" }, p1_panel3625, proof_panel3640 ], "frame": true, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel3641;
    this.before_row_edit = function(record) {
      purpose3620.setContextValue('sector',record ? record.data['sectorHidden'] : undefined);
    }
    Lino.cbss.ManageAccessRequests.InsertFormPanel.superclass.initComponent.call(this);
    // active_fields:
    person3612.on("change",function(){this.save()},this);
  }
});


Lino.contacts.Companies.InsertFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  autoHeight: true,
  content_type: 19,
  initComponent : function() {
    var containing_panel = this;
    var name1013 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Name","(contacts.Companies.name) ") }, "fieldLabel": "Name", "name": "name", "maxLength": 200, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var language1014 = new Lino.ChoicesFieldElement({ "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Sprache</span>", "allowBlank": false, "hiddenName": "languageHidden", "listeners": { "render": Lino.quicktip_renderer("Sprache","(contacts.Companies.language) Die Sprache, in der Dokumente ausgestellt werden sollen.") }, "selectOnFocus": true, "anchor": "-20", "store": [ [ "en", "Englisch" ], [ "fr", "Franz\u00f6sisch" ], [ "de", "Deutsch" ], [ "nl", "Niederl\u00e4ndisch" ] ], "name": "language" });
    var email1015 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("E-Mail","(contacts.Companies.email) ") }, "fieldLabel": "E-Mail", "name": "email", "maxLength": 75, "selectOnFocus": true, "anchor": "-20" });
    var main_2_panel1016 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": language1014, "labelAlign": "top" }, { "flex": 66, "autoHeight": true, "layout": "form", "xtype": "panel", "items": email1015, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 72, "border": false, "anchor": "-20", "labelAlign": "top" });
    var type1019 = new Lino.RemoteComboFieldElement({ "fieldLabel": "Organisationsart", "name": "type", "pageSize": 20, "emptyText": "Organisationsart ausw\u00e4hlen...", "listeners": { "render": Lino.quicktip_renderer("Organisationsart","(contacts.Companies.type) ") }, "selectOnFocus": true, "hiddenName": "typeHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/contacts/Companies/type", "method": "GET" }) }) });
    var id1020 = new Ext.form.NumberField({ "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("ID","(contacts.Companies.id) ") }, "fieldLabel": "ID", "anchor": "-20", "name": "id" });
    var main_3_panel1021 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 80, "autoHeight": true, "layout": "form", "xtype": "panel", "items": type1019, "labelAlign": "top" }, { "flex": 20, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id1020, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 153, "border": false, "anchor": "-20", "labelAlign": "top" });
    var main_panel1024 = new Ext.Panel({ "hideCheckBoxLabels": true, "autoHeight": true, "border": false, "layout": "form", "labelWidth": 45, "autoScroll": false, "items": [ { "autoHeight": true, "layout": "form", "xtype": "panel", "items": name1013, "anchor": "-20", "labelAlign": "top" }, main_2_panel1016, main_3_panel1021 ], "frame": true, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel1024;
    this.before_row_edit = function(record) {
    }
    Lino.contacts.Companies.InsertFormPanel.superclass.initComponent.call(this);
  }
});


Lino.cbss.RetrieveTIGroupsRequests.InsertFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  autoHeight: true,
  content_type: 89,
  initComponent : function() {
    var containing_panel = this;
    var person3680 = new Lino.TwinCombo({ "preferred_width": 20, "fieldLabel": "Klient", "allowBlank": false, "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.pcsw.Clients.detail)}, "emptyText": "Klient ausw\u00e4hlen...", "listeners": { "render": Lino.quicktip_renderer("Klient","(cbss.RetrieveTIGroupsRequests.person) ") }, "selectOnFocus": true, "hiddenName": "personHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cbss/RetrieveTIGroupsRequests/person", "method": "GET" }) }), "name": "person" });
    var national_id3681 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("NR-Nummer","(cbss.RetrieveTIGroupsRequests.national_id) ") }, "fieldLabel": "NR-Nummer", "name": "national_id", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var language3682 = new Lino.ChoicesFieldElement({ "forceSelection": true, "fieldLabel": "Sprache", "name": "language", "hiddenName": "languageHidden", "listeners": { "render": Lino.quicktip_renderer("Sprache","(cbss.RetrieveTIGroupsRequests.language) ") }, "selectOnFocus": true, "anchor": "-20", "store": [['','<br>']].concat(Lino.cbss.RequestLanguages) });
    var main_2_panel3683 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 70, "autoHeight": true, "layout": "form", "xtype": "panel", "items": national_id3681, "labelAlign": "top" }, { "flex": 30, "autoHeight": true, "layout": "form", "xtype": "panel", "items": language3682, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 90, "border": false, "anchor": "-20", "labelAlign": "top" });
    var history3686 = new Ext.form.Checkbox({ "boxLabel": "Historie", "listeners": { "render": Lino.quicktip_renderer("Historie","(cbss.RetrieveTIGroupsRequests.history) Whatever this means.") }, "hideLabel": true, "checked": true, "name": "history", "selectOnFocus": true, "anchor": "-20" });
    var main_panel3687 = new Ext.Panel({ "hideCheckBoxLabels": true, "autoHeight": true, "border": false, "layout": "form", "labelWidth": 81, "autoScroll": false, "items": [ { "autoHeight": true, "layout": "form", "xtype": "panel", "items": person3680, "anchor": "-20", "labelAlign": "top" }, main_2_panel3683, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": history3686, "anchor": "-20", "labelAlign": "top" } ], "frame": true, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel3687;
    this.before_row_edit = function(record) {
    }
    Lino.cbss.RetrieveTIGroupsRequests.InsertFormPanel.superclass.initComponent.call(this);
  }
});


Lino.cal.MyTasks.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 29,
  initComponent : function() {
    var containing_panel = this;
    var start_date320 = new Lino.DateField({ "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Beginnt am","(cal.Tasks.start_date) ") }, "fieldLabel": "Beginnt am", "anchor": "-20", "name": "start_date" });
    var due_date321 = new Lino.DateField({ "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Zahlungsziel","(cal.Tasks.due_date) ") }, "fieldLabel": "Zahlungsziel", "anchor": "-20", "name": "due_date" });
    var id322 = new Ext.form.NumberField({ "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("ID","(cal.Tasks.id) ") }, "fieldLabel": "ID", "anchor": "-20", "name": "id" });
    var workflow_buttons_disp323 = new Ext.form.DisplayField({ "disabled": true, "listeners": { "render": Lino.quicktip_renderer("Arbeitsablauf","(cal.Tasks.workflow_buttons) ") }, "fieldLabel": "Arbeitsablauf", "name": "workflow_buttons", "anchor": "-20", "value": "<br/>", "always_enabled": true });
    var main_1_panel324 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 126, "hideCheckBoxLabels": true, "items": [ { "flex": 15, "autoHeight": true, "layout": "form", "xtype": "panel", "items": start_date320, "labelAlign": "top" }, { "flex": 15, "autoHeight": true, "layout": "form", "xtype": "panel", "items": due_date321, "labelAlign": "top" }, { "flex": 9, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id322, "labelAlign": "top" }, { "flex": 58, "autoHeight": true, "layout": "form", "xtype": "panel", "items": workflow_buttons_disp323, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var summary329 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Kurzbeschreibung","(cal.Tasks.summary) ") }, "fieldLabel": "Kurzbeschreibung", "name": "summary", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var user330 = new Lino.TwinCombo({ "preferred_width": 15, "fieldLabel": "Autor", "name": "user", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.users.Users.detail)}, "hiddenName": "userHidden", "listeners": { "render": Lino.quicktip_renderer("Autor","(cal.Tasks.user) ") }, "selectOnFocus": true, "emptyText": "Benutzer ausw\u00e4hlen...", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/Tasks/user", "method": "GET" }) }) });
    var project331 = new Lino.TwinCombo({ "preferred_width": 20, "fieldLabel": "Klient", "name": "project", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.pcsw.Clients.detail)}, "hiddenName": "projectHidden", "listeners": { "render": Lino.quicktip_renderer("Klient","(cal.Tasks.project) ") }, "selectOnFocus": true, "emptyText": "Klient ausw\u00e4hlen...", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/Tasks/project", "method": "GET" }) }) });
    var main_3_panel332 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 63, "hideCheckBoxLabels": true, "items": [ { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": user330, "labelAlign": "top" }, { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": project331, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var calendar335 = new Lino.TwinCombo({ "fieldLabel": "Kalender", "name": "calendar", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.cal.Calendars.detail)}, "emptyText": "Kalender ausw\u00e4hlen...", "listeners": { "render": Lino.quicktip_renderer("Kalender","(cal.Tasks.calendar) ") }, "selectOnFocus": true, "hiddenName": "calendarHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/Tasks/calendar", "method": "GET" }) }) });
    var owner_disp336 = new Ext.form.DisplayField({ "disabled": true, "fieldLabel": "Verkn\u00fcpft mit", "anchor": "-20", "name": "owner" });
    var created337 = new Ext.form.DisplayField({ "disabled": true, "listeners": { "render": Lino.quicktip_renderer("Erstellt","(cal.Tasks.created) ") }, "fieldLabel": "Erstellt", "name": "created", "anchor": "-20", "value": "<br>" });
    var modified338 = new Ext.form.DisplayField({ "disabled": true, "listeners": { "render": Lino.quicktip_renderer("Bearbeitet","(cal.Tasks.modified) ") }, "fieldLabel": "Bearbeitet", "name": "modified", "anchor": "-20", "value": "<br>" });
    var main_4_panel339 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 126, "hideCheckBoxLabels": true, "items": [ { "flex": 28, "autoHeight": true, "layout": "form", "xtype": "panel", "items": calendar335, "labelAlign": "top" }, { "flex": 14, "autoHeight": true, "layout": "form", "xtype": "panel", "items": owner_disp336, "labelAlign": "top" }, { "flex": 28, "autoHeight": true, "layout": "form", "xtype": "panel", "items": created337, "labelAlign": "top" }, { "flex": 28, "autoHeight": true, "layout": "form", "xtype": "panel", "items": modified338, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var description344 = new Lino.RichTextPanel({ "selectOnFocus": true, "flex": 45, "containing_panel": this, "name": "description", "title": "Beschreibung" });
    var main_panel345 = new Ext.Panel({ "autoScroll": false, "border": false, "layout": "vbox", "labelWidth": 153, "hideCheckBoxLabels": true, "items": [ main_1_panel324, { "items": summary329, "autoHeight": true, "layout": "form", "xtype": "panel", "labelAlign": "top" }, main_3_panel332, main_4_panel339, description344 ], "frame": true, "layoutConfig": { "align": "stretch" }, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel345;
    this.before_row_edit = function(record) {
      description344.refresh();
    }
    Lino.cal.MyTasks.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.pcsw.Clients.InsertFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  autoHeight: true,
  content_type: 52,
  initComponent : function() {
    var containing_panel = this;
    var first_name2955 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Vorname","(pcsw.Clients.first_name) ") }, "fieldLabel": "Vorname", "name": "first_name", "maxLength": 200, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var last_name2956 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Familienname","(pcsw.Clients.last_name) ") }, "fieldLabel": "Familienname", "name": "last_name", "maxLength": 200, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var main_1_panel2957 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": first_name2955, "labelAlign": "top" }, { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": last_name2956, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 117, "border": false, "anchor": "-20", "labelAlign": "top" });
    var national_id2960 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("NR-Nummer","(pcsw.Clients.national_id) ") }, "fieldLabel": "NR-Nummer", "name": "national_id", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var gender2961 = new Lino.ChoicesFieldElement({ "forceSelection": true, "fieldLabel": "Geschlecht", "name": "gender", "hiddenName": "genderHidden", "listeners": { "render": Lino.quicktip_renderer("Geschlecht","(pcsw.Clients.gender) ") }, "selectOnFocus": true, "anchor": "-20", "store": [['','<br>']].concat(Lino.lino.Genders) });
    var language2962 = new Lino.ChoicesFieldElement({ "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Sprache</span>", "allowBlank": false, "hiddenName": "languageHidden", "listeners": { "render": Lino.quicktip_renderer("Sprache","(pcsw.Clients.language) Die Sprache, in der Dokumente ausgestellt werden sollen.") }, "selectOnFocus": true, "anchor": "-20", "store": [ [ "en", "Englisch" ], [ "fr", "Franz\u00f6sisch" ], [ "de", "Deutsch" ], [ "nl", "Niederl\u00e4ndisch" ] ], "name": "language" });
    var main_3_panel2963 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 31, "autoHeight": true, "layout": "form", "xtype": "panel", "items": gender2961, "labelAlign": "top" }, { "flex": 68, "autoHeight": true, "layout": "form", "xtype": "panel", "items": language2962, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 99, "border": false, "anchor": "-20", "labelAlign": "top" });
    var main_panel2966 = new Ext.Panel({ "hideCheckBoxLabels": true, "autoHeight": true, "border": false, "layout": "form", "labelWidth": 90, "autoScroll": false, "items": [ main_1_panel2957, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": national_id2960, "anchor": "-20", "labelAlign": "top" }, main_3_panel2963 ], "frame": true, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel2966;
    this.before_row_edit = function(record) {
    }
    Lino.pcsw.Clients.InsertFormPanel.superclass.initComponent.call(this);
  }
});


Lino.cal.PanelCalendars.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 33,
  initComponent : function() {
    var containing_panel = this;
    var type1132 = new Lino.ChoicesFieldElement({ "fieldLabel": "Art", "allowBlank": false, "value": "local", "hiddenName": "typeHidden", "listeners": { "render": Lino.quicktip_renderer("Art","(cal.Calendars.type) ") }, "selectOnFocus": true, "anchor": "-20", "store": [ [ "local", "Local Calendar" ], [ "google", "Google Calendar" ] ], "name": "type" });
    var name1133 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Bezeichnung","(cal.Calendars.name) ") }, "fieldLabel": "Bezeichnung", "name": "name", "maxLength": 200, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var name_fr1134 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Bezeichnung (fr)","(cal.Calendars.name_fr) ") }, "fieldLabel": "Bezeichnung (fr)", "name": "name_fr", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var name_de1135 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Bezeichnung (de)","(cal.Calendars.name_de) ") }, "fieldLabel": "Bezeichnung (de)", "name": "name_de", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var name_nl1136 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Bezeichnung (nl)","(cal.Calendars.name_nl) ") }, "fieldLabel": "Bezeichnung (nl)", "name": "name_nl", "maxLength": 200, "selectOnFocus": true, "hidden": true, "anchor": "-20" });
    var id1137 = new Ext.form.NumberField({ "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("ID","(cal.Calendars.id) ") }, "fieldLabel": "ID", "anchor": "-20", "name": "id" });
    var main_1_panel1138 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 153, "hideCheckBoxLabels": true, "items": [ { "flex": 18, "autoHeight": true, "layout": "form", "xtype": "panel", "items": type1132, "labelAlign": "top" }, { "flex": 19, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name1133, "labelAlign": "top" }, { "flex": 19, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_fr1134, "labelAlign": "top" }, { "flex": 19, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_de1135, "labelAlign": "top" }, { "flex": 19, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_nl1136, "hidden": true, "labelAlign": "top" }, { "flex": 4, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id1137, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var invite_team_members1145 = new Lino.RemoteComboFieldElement({ "fieldLabel": "Team", "name": "invite_team_members", "pageSize": 20, "emptyText": "Team ausw\u00e4hlen...", "listeners": { "render": Lino.quicktip_renderer("Team","(cal.Calendars.invite_team_members) ") }, "selectOnFocus": true, "hiddenName": "invite_team_membersHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/Calendars/invite_team_members", "method": "GET" }) }) });
    var event_label1146 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Event label","(cal.Calendars.event_label) ") }, "fieldLabel": "Event label", "name": "event_label", "maxLength": 200, "selectOnFocus": true, "anchor": "-20", "value": "Termin" });
    var event_label_fr1147 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Event label (fr)","(cal.Calendars.event_label_fr) ") }, "fieldLabel": "Event label (fr)", "name": "event_label_fr", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var event_label_de1148 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Event label (de)","(cal.Calendars.event_label_de) ") }, "fieldLabel": "Event label (de)", "name": "event_label_de", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var event_label_nl1149 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Event label (nl)","(cal.Calendars.event_label_nl) ") }, "fieldLabel": "Event label (nl)", "name": "event_label_nl", "maxLength": 200, "selectOnFocus": true, "hidden": true, "anchor": "-20" });
    var main_2_panel1150 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 153, "hideCheckBoxLabels": true, "items": [ { "flex": 19, "autoHeight": true, "layout": "form", "xtype": "panel", "items": invite_team_members1145, "labelAlign": "top" }, { "flex": 20, "autoHeight": true, "layout": "form", "xtype": "panel", "items": event_label1146, "labelAlign": "top" }, { "flex": 20, "autoHeight": true, "layout": "form", "xtype": "panel", "items": event_label_fr1147, "labelAlign": "top" }, { "flex": 20, "autoHeight": true, "layout": "form", "xtype": "panel", "items": event_label_de1148, "labelAlign": "top" }, { "flex": 20, "autoHeight": true, "layout": "form", "xtype": "panel", "items": event_label_nl1149, "hidden": true, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var url_template1156 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("URL-Vorlage","(cal.Calendars.url_template) ") }, "fieldLabel": "URL-Vorlage", "name": "url_template", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var username1157 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Benutzername","(cal.Calendars.username) ") }, "fieldLabel": "Benutzername", "name": "username", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var password1158 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Passwort","(cal.Calendars.password) ") }, "fieldLabel": "Passwort", "name": "password", "maxLength": 200, "selectOnFocus": true, "anchor": "-20", "inputType": "password" });
    var main_3_panel1159 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 117, "hideCheckBoxLabels": true, "items": [ { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": url_template1156, "labelAlign": "top" }, { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": username1157, "labelAlign": "top" }, { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": password1158, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var readonly1163 = new Ext.form.Checkbox({ "boxLabel": "schreibgesch\u00fctzt", "listeners": { "render": Lino.quicktip_renderer("schreibgesch\u00fctzt","(cal.Calendars.readonly) ") }, "hideLabel": true, "checked": false, "name": "readonly", "selectOnFocus": true, "anchor": "-20" });
    var is_appointment1164 = new Ext.form.Checkbox({ "boxLabel": "Event is an appointment", "listeners": { "render": Lino.quicktip_renderer("Event is an appointment","(cal.Calendars.is_appointment) ") }, "hideLabel": true, "checked": true, "name": "is_appointment", "selectOnFocus": true, "anchor": "-20" });
    var invite_client1165 = new Ext.form.Checkbox({ "boxLabel": "Klient einladen", "listeners": { "render": Lino.quicktip_renderer("Klient einladen","(cal.Calendars.invite_client) ") }, "hideLabel": true, "checked": false, "name": "invite_client", "selectOnFocus": true, "anchor": "-20" });
    var color1166 = new Ext.form.NumberField({ "listeners": { "render": Lino.quicktip_renderer("Farbe","(cal.Calendars.color) ") }, "fieldLabel": "Farbe", "name": "color", "selectOnFocus": true, "anchor": "-20", "value": 1, "allowBlank": false });
    var start_date1167 = new Lino.DateField({ "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Beginnt am","(cal.Calendars.start_date) ") }, "fieldLabel": "Beginnt am", "anchor": "-20", "name": "start_date" });
    var main_4_panel1168 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 216, "hideCheckBoxLabels": true, "items": [ { "flex": 23, "autoHeight": true, "layout": "form", "xtype": "panel", "items": readonly1163, "labelAlign": "top" }, { "flex": 23, "autoHeight": true, "layout": "form", "xtype": "panel", "items": is_appointment1164, "labelAlign": "top" }, { "flex": 23, "autoHeight": true, "layout": "form", "xtype": "panel", "items": invite_client1165, "labelAlign": "top" }, { "flex": 11, "autoHeight": true, "layout": "form", "xtype": "panel", "items": color1166, "labelAlign": "top" }, { "flex": 18, "autoHeight": true, "layout": "form", "xtype": "panel", "items": start_date1167, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var build_method1174 = new Lino.ChoicesFieldElement({ "listeners": { "render": Lino.quicktip_renderer("Konstruktionsmethode","(cal.Calendars.build_method) ") }, "fieldLabel": "Konstruktionsmethode", "name": "build_method", "selectOnFocus": true, "anchor": "-20", "store": [ [ "appyodt", "AppyOdtBuildMethod" ], [ "appypdf", "AppyPdfBuildMethod" ], [ "appyrtf", "AppyRtfBuildMethod" ], [ "latex", "LatexBuildMethod" ], [ "pisa", "PisaBuildMethod" ], [ "rtf", "RtfBuildMethod" ] ], "hiddenName": "build_methodHidden" });
    var template1175 = new Lino.SimpleRemoteComboFieldElement({ "listeners": { "render": Lino.quicktip_renderer("Vorlage","(cal.Calendars.template) ") }, "fieldLabel": "Vorlage", "name": "template", "selectOnFocus": true, "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/Calendars/template", "method": "GET" }) }) });
    var email_template1176 = new Lino.SimpleRemoteComboFieldElement({ "listeners": { "render": Lino.quicktip_renderer("E-Mail-Vorlage","(cal.Calendars.email_template) The name of the file to be used as \ntemplate when creating an email from a mailable of this type.") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">E-Mail-Vorlage</span>", "name": "email_template", "selectOnFocus": true, "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/Calendars/email_template", "method": "GET" }) }) });
    var attach_to_email1177 = new Ext.form.Checkbox({ "boxLabel": "als Anhang per E-Mail", "listeners": { "render": Lino.quicktip_renderer("als Anhang per E-Mail","(cal.Calendars.attach_to_email) Whether the printable file should be attached to the email\nwhen creating an email from a mailable of this type.\n") }, "hideLabel": true, "checked": false, "name": "attach_to_email", "selectOnFocus": true, "anchor": "-20" });
    var main_5_panel1178 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 198, "hideCheckBoxLabels": true, "items": [ { "flex": 40, "autoHeight": true, "layout": "form", "xtype": "panel", "items": build_method1174, "labelAlign": "top" }, { "flex": 20, "autoHeight": true, "layout": "form", "xtype": "panel", "items": template1175, "labelAlign": "top" }, { "flex": 20, "autoHeight": true, "layout": "form", "xtype": "panel", "items": email_template1176, "labelAlign": "top" }, { "flex": 20, "autoHeight": true, "layout": "form", "xtype": "panel", "items": attach_to_email1177, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var main_panel1353 = new Ext.Panel({ "autoScroll": false, "border": false, "layout": "vbox", "hideCheckBoxLabels": true, "items": [ main_1_panel1138, main_2_panel1150, main_3_panel1159, main_4_panel1168, main_5_panel1178 ], "frame": true, "layoutConfig": { "align": "stretch" }, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel1353;
    this.before_row_edit = function(record) {
      template1175.setContextValue('build_method',record ? record.data['build_methodHidden'] : undefined);
    }
    this.onRender = function(ct, position) {
      build_method1174.on('change',Lino.chooser_handler(template1175,'build_method'));
      Lino.cal.PanelCalendars.DetailFormPanel.superclass.onRender.call(this, ct, position);
    }
    Lino.cal.PanelCalendars.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.uploads.MyUploads.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 25,
  initComponent : function() {
    var containing_panel = this;
    var file1446 = Lino.file_field_handler(this,{ "listeners": { "render": Lino.quicktip_renderer("File","(uploads.Uploads.file) ") }, "fieldLabel": "File", "name": "file", "maxLength": 100, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var user1447 = new Lino.TwinCombo({ "preferred_width": 15, "fieldLabel": "Autor", "name": "user", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.users.Users.detail)}, "hiddenName": "userHidden", "listeners": { "render": Lino.quicktip_renderer("Autor","(uploads.Uploads.user) ") }, "selectOnFocus": true, "emptyText": "Benutzer ausw\u00e4hlen...", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/uploads/Uploads/user", "method": "GET" }) }) });
    var main_1_panel1448 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 54, "hideCheckBoxLabels": true, "items": [ { "flex": 51, "autoHeight": true, "layout": "form", "xtype": "panel", "items": file1446, "labelAlign": "top" }, { "flex": 48, "autoHeight": true, "layout": "form", "xtype": "panel", "items": user1447, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var type1451 = new Lino.RemoteComboFieldElement({ "fieldLabel": "Upload-Art", "name": "type", "pageSize": 20, "emptyText": "Upload-Art ausw\u00e4hlen...", "listeners": { "render": Lino.quicktip_renderer("Upload-Art","(uploads.Uploads.type) ") }, "selectOnFocus": true, "hiddenName": "typeHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/uploads/Uploads/type", "method": "GET" }) }) });
    var description1452 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Beschreibung","(uploads.Uploads.description) ") }, "fieldLabel": "Beschreibung", "name": "description", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var valid_until1453 = new Lino.DateField({ "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("g\u00fcltig bis","(uploads.Uploads.valid_until) ") }, "fieldLabel": "g\u00fcltig bis", "anchor": "-20", "name": "valid_until" });
    var main_2_panel1454 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 117, "hideCheckBoxLabels": true, "items": [ { "flex": 40, "autoHeight": true, "layout": "form", "xtype": "panel", "items": type1451, "labelAlign": "top" }, { "flex": 42, "autoHeight": true, "layout": "form", "xtype": "panel", "items": description1452, "labelAlign": "top" }, { "flex": 16, "autoHeight": true, "layout": "form", "xtype": "panel", "items": valid_until1453, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var modified1458 = new Ext.form.DisplayField({ "disabled": true, "listeners": { "render": Lino.quicktip_renderer("Bearbeitet","(uploads.Uploads.modified) ") }, "fieldLabel": "Bearbeitet", "name": "modified", "anchor": "-20", "value": "<br>" });
    var created1459 = new Ext.form.DisplayField({ "disabled": true, "listeners": { "render": Lino.quicktip_renderer("Erstellt","(uploads.Uploads.created) ") }, "fieldLabel": "Erstellt", "name": "created", "anchor": "-20", "value": "<br>" });
    var owner_disp1460 = new Ext.form.DisplayField({ "disabled": true, "fieldLabel": "Verkn\u00fcpft mit", "anchor": "-20", "name": "owner" });
    var main_3_panel1461 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 126, "hideCheckBoxLabels": true, "items": [ { "flex": 38, "autoHeight": true, "layout": "form", "xtype": "panel", "items": modified1458, "labelAlign": "top" }, { "flex": 38, "autoHeight": true, "layout": "form", "xtype": "panel", "items": created1459, "labelAlign": "top" }, { "flex": 23, "autoHeight": true, "layout": "form", "xtype": "panel", "items": owner_disp1460, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var cal_TasksByController_grid1465 = new Lino.cal.TasksByController.GridPanel({ "flex": 62, "listeners": { "render": Lino.quicktip_renderer("Aufgaben","(cal.cal.TasksByController) ") }, "hide_top_toolbar": true, "containing_panel": this, "params_panel_hidden": true, "tools": [ Lino.show_in_own_window_button(Lino.cal.TasksByController.grid) ], "master_panel": this });
    var main_panel1466 = new Ext.Panel({ "autoScroll": false, "border": false, "layout": "vbox", "hideCheckBoxLabels": true, "items": [ main_1_panel1448, main_2_panel1454, main_3_panel1461, cal_TasksByController_grid1465 ], "frame": true, "layoutConfig": { "align": "stretch" }, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel1466;
    this.before_row_edit = function(record) {
      cal_TasksByController_grid1465.on_master_changed();
    }
    Lino.uploads.MyUploads.DetailFormPanel.superclass.initComponent.call(this);
  }
});

Lino.contacts.Companies.merge_row = new Lino.WindowAction({ "draggable": true, "width": Lino.chars2width(50), "autoHeight": true, "maximizable": true, "modal": true, "maximized": false },function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.contacts.Companies.merge_row_ActionFormPanel({});
});
Lino.cal.GuestStates.wf1 = new Lino.WindowAction({ "draggable": true, "width": Lino.chars2width(50), "maximizable": true, "modal": true, "maximized": false, "height": Lino.rows2height(15) },function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.cal.MyPresences.wf1_ActionFormPanel({});
});
Lino.cal.GuestStates.wf2 = new Lino.WindowAction({ "draggable": true, "width": Lino.chars2width(50), "maximizable": true, "modal": true, "maximized": false, "height": Lino.rows2height(15) },function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.cal.MyPresences.wf2_ActionFormPanel({});
});
Lino.cal.Guests.checkin = new Lino.WindowAction({ "draggable": true, "width": Lino.chars2width(50), "maximizable": true, "modal": true, "maximized": false, "height": Lino.rows2height(15) },function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.cal.MyPresences.checkin_ActionFormPanel({});
});
Lino.pcsw.ClientStates.wf2 = new Lino.WindowAction({ "draggable": true, "width": Lino.chars2width(50), "maximizable": true, "modal": true, "maximized": false, "height": Lino.rows2height(15) },function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.pcsw.Clients.wf2_ActionFormPanel({});
});
Lino.pcsw.Clients.merge_row = new Lino.WindowAction({ "draggable": true, "width": Lino.chars2width(70), "autoHeight": true, "maximizable": true, "modal": true, "maximized": false },function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.pcsw.Clients.merge_row_ActionFormPanel({});
});
Lino.pcsw.Coachings.create_visit = new Lino.WindowAction({ "draggable": true, "width": Lino.chars2width(50), "autoHeight": true, "maximizable": true, "modal": true, "maximized": false },function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.pcsw.CoachingsByClient.create_visit_ActionFormPanel({});
});
Lino.newcomers.AvailableCoachesByClient.assign_coach = new Lino.WindowAction({ "draggable": true, "width": Lino.chars2width(50), "maximizable": true, "modal": true, "maximized": false, "height": Lino.rows2height(15) },function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.newcomers.AvailableCoachesByClient.assign_coach_ActionFormPanel({});
});

// js_render_GridPanel_class users.MySettings
Lino.users.MySettings.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "Keine Daten anzuzeigen." },
  ls_url : "/users/MySettings",
  ls_bbar_actions : [ { "itemId": "put", "menu_item_text": "Speichern", "tooltip": "\u00c4nderungen in diesem Formular speichern", "panel_btn_handler": function(panel){panel.save(null,false,'put')}, "iconCls": "x-tbar-save", "overflowText": "Speichern", "auto_save": false }, { "itemId": "update_reminders", "menu_item_text": "Erinnerungen aktualisieren", "must_save": true, "panel_btn_handler": Lino.row_action_handler('update_reminders','GET',null), "text": "Erinnerungen aktualisieren", "overflowText": "Erinnerungen aktualisieren", "auto_save": true } ],
  title : "Benutzer",
  page_length : 20,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "name": "username" }, { "name": "profile" }, 'profileHidden', { "name": "first_name" }, { "name": "last_name" }, { "type": "int", "name": "id" }, { "name": "created" }, { "name": "modified" }, { "name": "password" }, { "name": "initials" }, { "name": "email" }, { "name": "remarks" }, { "name": "language" }, 'languageHidden', { "name": "partner" }, 'partnerHidden', { "name": "access_class" }, 'access_classHidden', { "name": "calendar" }, 'calendarHidden', { "name": "coaching_type" }, 'coaching_typeHidden', { "type": "boolean", "name": "coaching_supervisor" }, { "type": "int", "name": "newcomer_quota" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 5,
  ls_grid_configs : [  ],
  content_type : 7,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 25,
  initComponent : function() {
    this.ls_detail_handler = Lino.users.MySettings.detail;
    this.ls_insert_handler = Lino.users.Users.insert;
    var ww = this.containing_window;
    var username3786 = new Ext.form.TextField({ "selectOnFocus": true, "allowBlank": false, "maxLength": 30 });
    var profile3787 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "forceSelection": true, "store": [['','<br>']].concat(Lino.lino.UserProfiles) });
    var first_name3788 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 30 });
    var last_name3789 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 30 });
    var id3790 = new Ext.form.NumberField({ "selectOnFocus": true });
    var created3791 = new Ext.form.DisplayField({ "disabled": true, "value": "<br>" });
    var modified3792 = new Ext.form.DisplayField({ "disabled": true, "value": "<br>" });
    var password3793 = new Ext.form.TextField({ "selectOnFocus": true, "allowBlank": false, "maxLength": 128 });
    var initials3794 = new Ext.form.TextField({ "selectOnFocus": true, "boxMinWidth": Lino.chars2width(10), "maxLength": 10 });
    var email3795 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 75 });
    var remarks3796 = new Ext.form.TextArea({ "selectOnFocus": true, "growMax": 2000 });
    var language3797 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "store": [ [ "en", "Englisch" ], [ "fr", "Franz\u00f6sisch" ], [ "de", "Deutsch" ], [ "nl", "Niederl\u00e4ndisch" ] ] });
    var partner3798 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "preferred_width": 20, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/users/MySettings/partner", "method": "GET" }) }), "pageSize": 20, "emptyText": "Partner ausw\u00e4hlen..." });
    var access_class3799 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "forceSelection": true, "allowBlank": false, "store": Lino.cal.AccessClasses });
    var calendar3800 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/users/MySettings/calendar", "method": "GET" }) }), "pageSize": 20, "emptyText": "Kalender ausw\u00e4hlen..." });
    var coaching_type3801 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/users/MySettings/coaching_type", "method": "GET" }) }), "pageSize": 20, "emptyText": "Dienst ausw\u00e4hlen..." });
    var coaching_supervisor3802 = new Ext.form.Checkbox({ "selectOnFocus": true, "checked": false });
    var newcomer_quota3803 = new Ext.form.NumberField({ "selectOnFocus": true, "allowBlank": false, "value": 0 });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ { "colIndex": 0, "sortable": true, "header": "Benutzername", "editable": true, "tooltip": "(users.MySettings.username) Required. Must be unique.", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "username", "editor": username3786 }, { "colIndex": 1, "sortable": true, "header": "Benutzerprofil", "editable": true, "tooltip": "(users.MySettings.profile) ", "filter": { "type": "string" }, "width": Lino.chars2width(37), "dataIndex": "profile", "editor": profile3787 }, { "colIndex": 2, "sortable": true, "header": "Vorname", "editable": true, "tooltip": "(users.MySettings.first_name) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "first_name", "editor": first_name3788 }, { "colIndex": 3, "sortable": true, "header": "Familienname", "editable": true, "tooltip": "(users.MySettings.last_name) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "last_name", "editor": last_name3789 }, new Lino.NullNumberColumn({ "colIndex": 4, "sortable": true, "format": "0", "editable": true, "tooltip": "(users.MySettings.id) ", "filter": { "type": "numeric" }, "header": "ID", "renderer": Lino.id_renderer, "editor": id3790, "width": Lino.chars2width(6), "dataIndex": "id" }), { "width": Lino.chars2width(17), "colIndex": 5, "sortable": true, "dataIndex": "created", "header": "Erstellt", "editable": false, "tooltip": "(users.MySettings.created) " }, { "width": Lino.chars2width(17), "colIndex": 6, "sortable": true, "dataIndex": "modified", "header": "Bearbeitet", "editable": false, "tooltip": "(users.MySettings.modified) " }, { "colIndex": 7, "sortable": true, "header": "Passwort", "editable": true, "tooltip": "(users.MySettings.password) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "password", "hidden": true, "editor": password3793 }, { "colIndex": 8, "sortable": true, "header": "Initials", "editable": true, "tooltip": "(users.MySettings.initials) ", "filter": { "type": "string" }, "width": Lino.chars2width(12), "dataIndex": "initials", "editor": initials3794 }, { "colIndex": 9, "sortable": true, "header": "e-mail address", "editable": true, "tooltip": "(users.MySettings.email) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "email", "editor": email3795 }, { "colIndex": 10, "sortable": false, "width": Lino.chars2width(61), "editable": true, "tooltip": "(users.MySettings.remarks) ", "filter": { "type": "string" }, "header": "Bemerkungen", "renderer": Lino.text_renderer, "hidden": true, "editor": remarks3796, "dataIndex": "remarks" }, { "colIndex": 11, "sortable": true, "header": "Sprache", "editable": true, "tooltip": "(users.MySettings.language) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "language", "editor": language3797 }, { "colIndex": 12, "sortable": true, "header": "Partner", "editable": true, "tooltip": "(users.MySettings.partner) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('partnerHidden','Lino.contacts.Partners.detail'), "editor": partner3798, "dataIndex": "partner" }, { "colIndex": 13, "sortable": true, "header": "Standardm\u00e4\u00dfige Zugriffsklasse", "editable": true, "tooltip": "(users.MySettings.access_class) Die standardm\u00e4\u00dfige Zugriffsklasse f\u00fcr Ihre Termine und Aufgaben", "filter": { "type": "string" }, "width": Lino.chars2width(13), "dataIndex": "access_class", "editor": access_class3799 }, { "colIndex": 14, "sortable": true, "header": "Standard-Kalender", "editable": true, "tooltip": "(users.MySettings.calendar) The default calendar for your events and tasks.", "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "calendar", "editor": calendar3800 }, { "colIndex": 15, "sortable": true, "header": "Dienst", "editable": true, "tooltip": "(users.MySettings.coaching_type) The default CoachingType used when creating Coachings.", "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "coaching_type", "editor": coaching_type3801 }, { "colIndex": 16, "sortable": false, "xtype": "checkcolumn", "header": "Benachrichtigung wenn ein Begleiter zugewiesen wird", "editable": true, "tooltip": "(users.MySettings.coaching_supervisor) Wenn ein Neuantrag einem Begleiter zugewiesen wurde, wird au\u00dfer dem Begleiter auch dieser Benutzer benachrichtigt.", "filter": { "type": "boolean" }, "width": Lino.chars2width(11), "dataIndex": "coaching_supervisor" }, new Lino.NullNumberColumn({ "colIndex": 17, "sortable": true, "format": "0", "editable": true, "tooltip": "(users.MySettings.newcomer_quota) Wieviel Arbeitszeit dieser Benutzer f\u00fcr Neuantr\u00e4ge zur Verf\u00fcgung steht\n(100 = ganztags, 50 = halbtags, 0 = gar nicht).\nWenn zwei Benutzer die gleiche Belastungspunktzahl haben, \naber einer davon sich nur zu 50% um Neuantr\u00e4ge k\u00fcmmert, \ngilt er als doppelt so belastet wie sein Kollege.\n", "filter": { "type": "numeric" }, "header": "Quote NZ", "dataIndex": "newcomer_quota", "width": Lino.chars2width(6), "editor": newcomer_quota3803 }) ];
    Lino.users.MySettings.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.users.MySettings.put = function(rp,pk) { 
  Lino.run_row_action(rp,"/users/MySettings","GET",pk,"put",null);
};
Lino.users.MySettings.post = function(rp,pk) { 
  Lino.run_row_action(rp,"/users/MySettings","GET",pk,"post",null);
};

Lino.users.MySettings.detailPanel = Ext.extend(Lino.users.MySettings.DetailFormPanel,{
  empty_title: "Benutzer",
  ls_bbar_actions: [ { "itemId": "put", "menu_item_text": "Speichern", "tooltip": "\u00c4nderungen in diesem Formular speichern", "panel_btn_handler": function(panel){panel.save(null,false,'put')}, "iconCls": "x-tbar-save", "overflowText": "Speichern", "auto_save": false }, { "itemId": "update_reminders", "menu_item_text": "Erinnerungen aktualisieren", "must_save": true, "panel_btn_handler": Lino.row_action_handler('update_reminders','GET',null), "text": "Erinnerungen aktualisieren", "overflowText": "Erinnerungen aktualisieren", "auto_save": true } ],
  ls_url: "/users/MySettings",
  initComponent : function() {
    this.ls_detail_handler = Lino.users.MySettings.detail;
    this.ls_insert_handler = Lino.users.Users.insert;
    Lino.users.MySettings.detailPanel.superclass.initComponent.call(this);
  }
});

Lino.users.MySettings.detail = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.users.MySettings.detailPanel(p);
});

Lino.users.MySettings.detailPanel = Ext.extend(Lino.users.MySettings.DetailFormPanel,{
  empty_title: "Benutzer",
  ls_bbar_actions: [ { "itemId": "put", "menu_item_text": "Speichern", "tooltip": "\u00c4nderungen in diesem Formular speichern", "panel_btn_handler": function(panel){panel.save(null,false,'put')}, "iconCls": "x-tbar-save", "overflowText": "Speichern", "auto_save": false }, { "itemId": "update_reminders", "menu_item_text": "Erinnerungen aktualisieren", "must_save": true, "panel_btn_handler": Lino.row_action_handler('update_reminders','GET',null), "text": "Erinnerungen aktualisieren", "overflowText": "Erinnerungen aktualisieren", "auto_save": true } ],
  ls_url: "/users/MySettings",
  initComponent : function() {
    this.ls_detail_handler = Lino.users.MySettings.detail;
    this.ls_insert_handler = Lino.users.Users.insert;
    Lino.users.MySettings.detailPanel.superclass.initComponent.call(this);
  }
});

Lino.users.MySettings.detail = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.users.MySettings.detailPanel(p);
});
Lino.users.MySettings.update_reminders = function(rp,pk) { 
  Lino.run_row_action(rp,"/users/MySettings","GET",pk,"update_reminders",null);
};

// js_render_GridPanel_class countries.Countries
Lino.countries.Countries.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "Keine Daten anzuzeigen." },
  ls_url : "/countries/Countries",
  ls_bbar_actions : [ { "itemId": "insert", "menu_item_text": "Neu", "must_save": true, "tooltip": "Neuen Datensatz erstellen", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-new", "overflowText": "Neu", "auto_save": true }, { "itemId": "detail", "menu_item_text": "Detail", "tooltip": "Detail-Fenster auf diesem Datensatz \u00f6ffnen", "panel_btn_handler": Lino.show_detail, "iconCls": "x-tbar-detail", "overflowText": "Detail", "auto_save": true }, { "itemId": null, "menu_item_text": "L\u00f6schen", "tooltip": "Diesen Datensatz l\u00f6schen", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "L\u00f6schen", "auto_save": false } ],
  title : "L\u00e4nder",
  page_length : 20,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "name": "name" }, { "name": "name_fr" }, { "name": "name_de" }, { "name": "name_nl" }, { "name": "isocode" }, { "name": "short_code" }, { "name": "iso3" }, { "name": "inscode" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 4,
  ls_grid_configs : [  ],
  content_type : 11,
  ls_id_property : "isocode",
  gc_name : 0,
  disabled_actions_index : 9,
  initComponent : function() {
    this.ls_detail_handler = Lino.countries.Countries.detail;
    this.ls_insert_handler = Lino.countries.Countries.insert;
    var ww = this.containing_window;
    var name3835 = new Ext.form.TextField({ "selectOnFocus": true, "allowBlank": false, "maxLength": 200 });
    var name_fr3836 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var name_de3837 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var name_nl3838 = new Ext.form.TextField({ "selectOnFocus": true, "hidden": true, "maxLength": 200 });
    var isocode3839 = new Ext.form.TextField({ "selectOnFocus": true, "boxMinWidth": Lino.chars2width(4), "allowBlank": false, "maxLength": 4 });
    var short_code3840 = new Ext.form.TextField({ "selectOnFocus": true, "boxMinWidth": Lino.chars2width(4), "maxLength": 4 });
    var iso33841 = new Ext.form.TextField({ "selectOnFocus": true, "boxMinWidth": Lino.chars2width(3), "maxLength": 3 });
    var inscode3842 = new Ext.form.TextField({ "selectOnFocus": true, "boxMinWidth": Lino.chars2width(3), "maxLength": 3 });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ { "colIndex": 0, "sortable": true, "header": "Bezeichnung", "editable": true, "tooltip": "(countries.Countries.name) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "name", "editor": name3835 }, { "colIndex": 1, "sortable": true, "header": "Bezeichnung (fr)", "editable": true, "tooltip": "(countries.Countries.name_fr) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "name_fr", "editor": name_fr3836 }, { "colIndex": 2, "sortable": true, "header": "Bezeichnung (de)", "editable": true, "tooltip": "(countries.Countries.name_de) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "name_de", "editor": name_de3837 }, { "colIndex": 3, "sortable": true, "header": "Bezeichnung (nl)", "editable": true, "tooltip": "(countries.Countries.name_nl) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "name_nl", "hidden": true, "editor": name_nl3838 }, { "colIndex": 4, "sortable": true, "header": "ISO-Code", "editable": true, "tooltip": "(countries.Countries.isocode)         The two-letter code for this country as defined by ISO 3166-1. \n        For countries that no longer exist it may be a 4-letter code.", "filter": { "type": "string" }, "width": Lino.chars2width(6), "dataIndex": "isocode", "editor": isocode3839 }, { "colIndex": 5, "sortable": true, "header": "Short code", "editable": true, "tooltip": "(countries.Countries.short_code) A short abbreviation for regional usage. Obsolete.", "filter": { "type": "string" }, "width": Lino.chars2width(6), "dataIndex": "short_code", "editor": short_code3840 }, { "colIndex": 6, "sortable": true, "header": "ISO3-Code", "editable": true, "tooltip": "(countries.Countries.iso3) The three-letter code for this country as defined by ISO 3166-1.", "filter": { "type": "string" }, "width": Lino.chars2width(5), "dataIndex": "iso3", "editor": iso33841 }, { "colIndex": 7, "sortable": true, "header": "INS-Code", "editable": true, "tooltip": "(countries.Countries.inscode) The official code for this country used by statbel.fgov.be", "filter": { "type": "string" }, "width": Lino.chars2width(5), "dataIndex": "inscode", "editor": inscode3842 } ];
    Lino.countries.Countries.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.countries.Countries.put = function(rp,pk) { 
  Lino.run_row_action(rp,"/countries/Countries","GET",pk,"put",null);
};
Lino.countries.Countries.post = function(rp,pk) { 
  Lino.run_row_action(rp,"/countries/Countries","GET",pk,"post",null);
};

Lino.countries.Countries.insertPanel = Ext.extend(Lino.countries.Countries.DetailFormPanel,{
  empty_title: "Neu L\u00e4nder",
  hide_navigator: true,
  ls_bbar_actions: [ { "itemId": "post", "menu_item_text": "Erstellen", "tooltip": "Datensatz erstellen und dann im Detail-Fenster \u00f6ffnen", "panel_btn_handler": function(panel){panel.save(null,true,'post')}, "text": "Erstellen", "overflowText": "Erstellen", "auto_save": false }, { "itemId": "poststay", "menu_item_text": "Erstellen ohne Detail", "tooltip": "Nach Erstellen des Datensatzes kein Detail-Fenster \u00f6ffnen", "panel_btn_handler": function(panel){panel.save(null,false,'poststay')}, "text": "Erstellen ohne Detail", "overflowText": "Erstellen ohne Detail", "auto_save": false } ],
  ls_url: "/countries/Countries",
  action_name: "insert",
  initComponent : function() {
    this.ls_detail_handler = Lino.countries.Countries.detail;
    this.ls_insert_handler = Lino.countries.Countries.insert;
    Lino.countries.Countries.insertPanel.superclass.initComponent.call(this);
  }
});

Lino.countries.Countries.insert = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.countries.Countries.insertPanel(p);
});
Lino.countries.Countries.poststay = function(rp,pk) { 
  Lino.run_row_action(rp,"/countries/Countries","GET",pk,"poststay",null);
};

Lino.countries.Countries.detailPanel = Ext.extend(Lino.countries.Countries.DetailFormPanel,{
  empty_title: "Detail L\u00e4nder",
  ls_bbar_actions: [ { "itemId": "put", "menu_item_text": "Speichern", "tooltip": "\u00c4nderungen in diesem Formular speichern", "panel_btn_handler": function(panel){panel.save(null,false,'put')}, "iconCls": "x-tbar-save", "overflowText": "Speichern", "auto_save": false }, { "itemId": "insert", "menu_item_text": "Neu", "must_save": true, "tooltip": "Neuen Datensatz erstellen", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-new", "overflowText": "Neu", "auto_save": true }, { "itemId": null, "menu_item_text": "L\u00f6schen", "tooltip": "Diesen Datensatz l\u00f6schen", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "L\u00f6schen", "auto_save": false } ],
  ls_url: "/countries/Countries",
  action_name: "detail",
  initComponent : function() {
    this.ls_detail_handler = Lino.countries.Countries.detail;
    this.ls_insert_handler = Lino.countries.Countries.insert;
    Lino.countries.Countries.detailPanel.superclass.initComponent.call(this);
  }
});

Lino.countries.Countries.detail = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.countries.Countries.detailPanel(p);
});
Lino.countries.Countries.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.countries.Countries.GridPanel(p);
});

// js_render_GridPanel_class properties.PropChoices
Lino.properties.PropChoices.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "Keine Daten anzuzeigen." },
  ls_url : "/properties/PropChoices",
  ls_bbar_actions : [ { "itemId": null, "menu_item_text": "L\u00f6schen", "tooltip": "Diesen Datensatz l\u00f6schen", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "L\u00f6schen", "auto_save": false } ],
  title : "Auswahlm\u00f6glichkeiten",
  page_length : 20,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "type": "int", "name": "id" }, { "name": "type" }, 'typeHidden', { "name": "value" }, { "name": "text" }, { "name": "text_fr" }, { "name": "text_de" }, { "name": "text_nl" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 0,
  ls_grid_configs : [  ],
  content_type : 16,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 9,
  initComponent : function() {
    var ww = this.containing_window;
    var id3879 = new Ext.form.NumberField({ "selectOnFocus": true });
    var type3880 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/properties/PropChoices/type", "method": "GET" }) }), "allowBlank": false, "pageSize": 20, "emptyText": "Eigenschafts-Datentyp ausw\u00e4hlen..." });
    var value3881 = new Ext.form.TextField({ "selectOnFocus": true, "allowBlank": false, "maxLength": 200 });
    var text3882 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var text_fr3883 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var text_de3884 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var text_nl3885 = new Ext.form.TextField({ "selectOnFocus": true, "hidden": true, "maxLength": 200 });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ new Lino.NullNumberColumn({ "colIndex": 0, "sortable": true, "format": "0", "editable": true, "tooltip": "(properties.PropChoices.id) ", "filter": { "type": "numeric" }, "header": "ID", "renderer": Lino.id_renderer, "editor": id3879, "width": Lino.chars2width(6), "dataIndex": "id" }), { "colIndex": 1, "sortable": true, "header": "Eigenschafts-Datentyp", "editable": true, "tooltip": "(properties.PropChoices.type) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "type", "editor": type3880 }, { "colIndex": 2, "sortable": true, "header": "Wert", "editable": true, "tooltip": "(properties.PropChoices.value) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "value", "editor": value3881 }, { "colIndex": 3, "sortable": true, "header": "Bezeichnung", "editable": true, "tooltip": "(properties.PropChoices.text) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "text", "editor": text3882 }, { "colIndex": 4, "sortable": true, "header": "Bezeichnung (fr)", "editable": true, "tooltip": "(properties.PropChoices.text_fr) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "text_fr", "editor": text_fr3883 }, { "colIndex": 5, "sortable": true, "header": "Bezeichnung (de)", "editable": true, "tooltip": "(properties.PropChoices.text_de) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "text_de", "editor": text_de3884 }, { "colIndex": 6, "sortable": true, "header": "Bezeichnung (nl)", "editable": true, "tooltip": "(properties.PropChoices.text_nl) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "text_nl", "hidden": true, "editor": text_nl3885 } ];
    Lino.properties.PropChoices.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.properties.PropChoices.put = function(rp,pk) { 
  Lino.run_row_action(rp,"/properties/PropChoices","GET",pk,"put",null);
};
Lino.properties.PropChoices.post = function(rp,pk) { 
  Lino.run_row_action(rp,"/properties/PropChoices","GET",pk,"post",null);
};
Lino.properties.PropChoices.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.properties.PropChoices.GridPanel(p);
});

// js_render_GridPanel_class contacts.Partners
Lino.contacts.Partners.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "Keine Daten anzuzeigen." },
  ls_url : "/contacts/Partners",
  ls_bbar_actions : [ { "itemId": "insert", "menu_item_text": "Neu", "must_save": true, "tooltip": "Neuen Datensatz erstellen", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-new", "overflowText": "Neu", "auto_save": true }, { "itemId": "detail", "menu_item_text": "Detail", "tooltip": "Detail-Fenster auf diesem Datensatz \u00f6ffnen", "panel_btn_handler": Lino.show_detail, "iconCls": "x-tbar-detail", "overflowText": "Detail", "auto_save": true }, { "itemId": null, "menu_item_text": "L\u00f6schen", "tooltip": "Diesen Datensatz l\u00f6schen", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "L\u00f6schen", "auto_save": false } ],
  title : "Partner",
  page_length : 20,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "name": "name" }, { "name": "email" }, { "name": "created" }, { "name": "modified" }, { "name": "country" }, 'countryHidden', { "name": "city" }, 'cityHidden', { "name": "region" }, 'regionHidden', { "name": "zip_code" }, { "name": "addr1" }, { "name": "street_prefix" }, { "name": "street" }, { "name": "street_no" }, { "name": "street_box" }, { "name": "addr2" }, { "name": "language" }, 'languageHidden', { "name": "url" }, { "name": "phone" }, { "name": "gsm" }, { "name": "fax" }, { "name": "remarks" }, { "type": "boolean", "name": "is_obsolete" }, { "name": "activity" }, 'activityHidden', { "name": "bank_account1" }, { "name": "bank_account2" }, { "type": "int", "name": "id" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 29,
  ls_grid_configs : [  ],
  content_type : 22,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 31,
  initComponent : function() {
    this.ls_detail_handler = Lino.contacts.Partners.detail;
    this.ls_insert_handler = Lino.contacts.Partners.insert;
    var ww = this.containing_window;
    var name3897 = new Ext.form.TextField({ "selectOnFocus": true, "allowBlank": false, "maxLength": 200 });
    var email3898 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 75 });
    var created3899 = new Ext.form.DisplayField({ "disabled": true, "value": "<br>" });
    var modified3900 = new Ext.form.DisplayField({ "disabled": true, "value": "<br>" });
    var country3901 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/contacts/Partners/country", "method": "GET" }) }), "pageSize": 20, "emptyText": "Land ausw\u00e4hlen..." });
    var city3902 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "forceSelection": false, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/contacts/Partners/city", "method": "GET" }) }), "pageSize": 20, "emptyText": "Ort ausw\u00e4hlen..." });
    var region3903 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/contacts/Partners/region", "method": "GET" }) }), "pageSize": 20, "emptyText": "Ort ausw\u00e4hlen..." });
    var zip_code3904 = new Ext.form.TextField({ "selectOnFocus": true, "boxMinWidth": Lino.chars2width(10), "maxLength": 10 });
    var addr13905 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var street_prefix3906 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var street3907 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var street_no3908 = new Ext.form.TextField({ "selectOnFocus": true, "boxMinWidth": Lino.chars2width(10), "maxLength": 10 });
    var street_box3909 = new Ext.form.TextField({ "selectOnFocus": true, "boxMinWidth": Lino.chars2width(10), "maxLength": 10 });
    var addr23910 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var language3911 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "allowBlank": false, "store": [ [ "en", "Englisch" ], [ "fr", "Franz\u00f6sisch" ], [ "de", "Deutsch" ], [ "nl", "Niederl\u00e4ndisch" ] ] });
    var url3912 = new Lino.URLField({ "selectOnFocus": true, "maxLength": 200 });
    var phone3913 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var gsm3914 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var fax3915 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var remarks3916 = new Ext.form.TextArea({ "selectOnFocus": true, "growMax": 2000 });
    var is_obsolete3917 = new Ext.form.Checkbox({ "selectOnFocus": true, "checked": false });
    var activity3918 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/contacts/Partners/activity", "method": "GET" }) }), "pageSize": 20, "emptyText": "Beruf ausw\u00e4hlen..." });
    var bank_account13919 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 40 });
    var bank_account23920 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 40 });
    var id3921 = new Ext.form.NumberField({ "selectOnFocus": true });
    this.before_row_edit = function(record) {
      city3902.setContextValue('country',record ? record.data['countryHidden'] : undefined);
      city3902.setContextValue('region',record ? record.data['regionHidden'] : undefined);
      region3903.setContextValue('country',record ? record.data['countryHidden'] : undefined);
    };
    this.onRender = function(ct, position) {
      country3901.on('change',Lino.chooser_handler(city3902,'country'));
      region3903.on('change',Lino.chooser_handler(city3902,'region'));
      country3901.on('change',Lino.chooser_handler(region3903,'country'));
      Lino.contacts.Partners.GridPanel.superclass.onRender.call(this, ct, position);
    }
    this.ls_columns = [ { "colIndex": 0, "sortable": true, "header": "Name", "editable": true, "tooltip": "(contacts.Partners.name) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "name", "editor": name3897 }, { "colIndex": 1, "sortable": true, "header": "E-Mail", "editable": true, "tooltip": "(contacts.Partners.email) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "email", "editor": email3898 }, { "colIndex": 2, "sortable": true, "header": "Erstellt", "editable": false, "tooltip": "(contacts.Partners.created) ", "width": Lino.chars2width(17), "dataIndex": "created", "hidden": true }, { "colIndex": 3, "sortable": true, "header": "Bearbeitet", "editable": false, "tooltip": "(contacts.Partners.modified) ", "width": Lino.chars2width(17), "dataIndex": "modified", "hidden": true }, { "colIndex": 4, "sortable": true, "header": "Land", "editable": true, "tooltip": "(contacts.Partners.country) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('countryHidden','Lino.countries.Countries.detail'), "editor": country3901, "dataIndex": "country" }, { "colIndex": 5, "sortable": true, "header": "Ort", "editable": true, "tooltip": "(contacts.Partners.city) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "city", "editor": city3902 }, { "colIndex": 6, "sortable": true, "header": "Region", "editable": true, "tooltip": "(contacts.Partners.region) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "region", "editor": region3903 }, { "colIndex": 7, "sortable": true, "header": "Postleitzahl", "editable": true, "tooltip": "(contacts.Partners.zip_code) ", "filter": { "type": "string" }, "width": Lino.chars2width(12), "dataIndex": "zip_code", "editor": zip_code3904 }, { "colIndex": 8, "sortable": true, "header": "Adresszeile vor Stra\u00dfe", "editable": true, "tooltip": "(contacts.Partners.addr1) Address line before street", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "addr1", "editor": addr13905 }, { "colIndex": 9, "sortable": true, "header": "Pr\u00e4fix Stra\u00dfe", "editable": true, "tooltip": "(contacts.Partners.street_prefix) Text to print before name of street, but to ignore for sorting.", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "street_prefix", "editor": street_prefix3906 }, { "colIndex": 10, "sortable": true, "header": "Stra\u00dfe", "editable": true, "tooltip": "(contacts.Partners.street) Name of street. Without house number.", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "street", "editor": street3907 }, { "colIndex": 11, "sortable": true, "header": "Nr.", "editable": true, "tooltip": "(contacts.Partners.street_no) House number", "filter": { "type": "string" }, "width": Lino.chars2width(12), "dataIndex": "street_no", "editor": street_no3908 }, { "colIndex": 12, "sortable": true, "header": "Box", "editable": true, "tooltip": "(contacts.Partners.street_box) Text to print after :attr:`steet_no` on the same line", "filter": { "type": "string" }, "width": Lino.chars2width(12), "dataIndex": "street_box", "editor": street_box3909 }, { "colIndex": 13, "sortable": true, "header": "Adresszeile nach Stra\u00dfe", "editable": true, "tooltip": "(contacts.Partners.addr2) Address line to print below street line", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "addr2", "editor": addr23910 }, { "colIndex": 14, "sortable": true, "header": "Sprache", "editable": true, "tooltip": "(contacts.Partners.language) Die Sprache, in der Dokumente ausgestellt werden sollen.", "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "language", "editor": language3911 }, { "colIndex": 15, "sortable": true, "header": "URL", "editable": true, "tooltip": "(contacts.Partners.url) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "url", "editor": url3912 }, { "colIndex": 16, "sortable": true, "header": "Telefon", "editable": true, "tooltip": "(contacts.Partners.phone) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "phone", "editor": phone3913 }, { "colIndex": 17, "sortable": true, "header": "GSM", "editable": true, "tooltip": "(contacts.Partners.gsm) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "gsm", "editor": gsm3914 }, { "colIndex": 18, "sortable": true, "header": "Fax", "editable": true, "tooltip": "(contacts.Partners.fax) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "fax", "editor": fax3915 }, { "colIndex": 19, "sortable": false, "header": "Bemerkungen", "editable": true, "tooltip": "(contacts.Partners.remarks) ", "filter": { "type": "string" }, "width": Lino.chars2width(61), "renderer": Lino.text_renderer, "editor": remarks3916, "dataIndex": "remarks" }, { "colIndex": 20, "sortable": false, "xtype": "checkcolumn", "header": "veraltet", "editable": true, "tooltip": "(contacts.Partners.is_obsolete) Altf\u00e4lle sind Partner, deren Stammdaten nicht mehr gepflegt werden und \nf\u00fcr neue Operationen nicht benutzt werden k\u00f6nnen.", "filter": { "type": "boolean" }, "width": Lino.chars2width(11), "dataIndex": "is_obsolete" }, { "colIndex": 21, "sortable": true, "header": "Beruf", "editable": true, "tooltip": "(contacts.Partners.activity) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "activity", "hidden": true, "editor": activity3918 }, { "colIndex": 22, "sortable": true, "header": "Bankkonto 1", "editable": true, "tooltip": "(contacts.Partners.bank_account1) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "bank_account1", "hidden": true, "editor": bank_account13919 }, { "colIndex": 23, "sortable": true, "header": "Bankkonto 2", "editable": true, "tooltip": "(contacts.Partners.bank_account2) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "bank_account2", "hidden": true, "editor": bank_account23920 }, new Lino.NullNumberColumn({ "colIndex": 24, "sortable": true, "format": "0", "editable": true, "tooltip": "(contacts.Partners.id) ", "filter": { "type": "numeric" }, "header": "ID", "renderer": Lino.id_renderer, "editor": id3921, "width": Lino.chars2width(6), "dataIndex": "id" }) ];
    Lino.contacts.Partners.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.contacts.Partners.put = function(rp,pk) { 
  Lino.run_row_action(rp,"/contacts/Partners","GET",pk,"put",null);
};
Lino.contacts.Partners.post = function(rp,pk) { 
  Lino.run_row_action(rp,"/contacts/Partners","GET",pk,"post",null);
};

Lino.contacts.Partners.insertPanel = Ext.extend(Lino.contacts.Partners.InsertFormPanel,{
  empty_title: "Neu Partner",
  hide_navigator: true,
  ls_bbar_actions: [ { "itemId": "post", "menu_item_text": "Erstellen", "tooltip": "Datensatz erstellen und dann im Detail-Fenster \u00f6ffnen", "panel_btn_handler": function(panel){panel.save(null,true,'post')}, "text": "Erstellen", "overflowText": "Erstellen", "auto_save": false }, { "itemId": "poststay", "menu_item_text": "Erstellen ohne Detail", "tooltip": "Nach Erstellen des Datensatzes kein Detail-Fenster \u00f6ffnen", "panel_btn_handler": function(panel){panel.save(null,false,'poststay')}, "text": "Erstellen ohne Detail", "overflowText": "Erstellen ohne Detail", "auto_save": false } ],
  ls_url: "/contacts/Partners",
  action_name: "insert",
  initComponent : function() {
    this.ls_detail_handler = Lino.contacts.Partners.detail;
    this.ls_insert_handler = Lino.contacts.Partners.insert;
    Lino.contacts.Partners.insertPanel.superclass.initComponent.call(this);
  }
});

Lino.contacts.Partners.insert = new Lino.WindowAction({ "draggable": true, "width": Lino.chars2width(40), "autoHeight": true, "maximizable": true, "modal": true, "maximized": false },function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.contacts.Partners.insertPanel(p);
});
Lino.contacts.Partners.poststay = function(rp,pk) { 
  Lino.run_row_action(rp,"/contacts/Partners","GET",pk,"poststay",null);
};

Lino.contacts.Partners.detailPanel = Ext.extend(Lino.contacts.Partners.DetailFormPanel,{
  empty_title: "Detail Partner",
  ls_bbar_actions: [ { "itemId": "put", "menu_item_text": "Speichern", "tooltip": "\u00c4nderungen in diesem Formular speichern", "panel_btn_handler": function(panel){panel.save(null,false,'put')}, "iconCls": "x-tbar-save", "overflowText": "Speichern", "auto_save": false }, { "itemId": "insert", "menu_item_text": "Neu", "must_save": true, "tooltip": "Neuen Datensatz erstellen", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-new", "overflowText": "Neu", "auto_save": true }, { "itemId": null, "menu_item_text": "L\u00f6schen", "tooltip": "Diesen Datensatz l\u00f6schen", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "L\u00f6schen", "auto_save": false } ],
  ls_url: "/contacts/Partners",
  action_name: "detail",
  initComponent : function() {
    this.ls_detail_handler = Lino.contacts.Partners.detail;
    this.ls_insert_handler = Lino.contacts.Partners.insert;
    Lino.contacts.Partners.detailPanel.superclass.initComponent.call(this);
  }
});

Lino.contacts.Partners.detail = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.contacts.Partners.detailPanel(p);
});
Lino.contacts.Partners.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.contacts.Partners.GridPanel(p);
});

// js_render_GridPanel_class contacts.Companies
Lino.contacts.Companies.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "Keine Daten anzuzeigen." },
  ls_url : "/contacts/Companies",
  ls_bbar_actions : [ { "itemId": "insert", "menu_item_text": "Neu", "must_save": true, "tooltip": "Neuen Datensatz erstellen", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-new", "overflowText": "Neu", "auto_save": true }, { "itemId": "detail", "menu_item_text": "Detail", "tooltip": "Detail-Fenster auf diesem Datensatz \u00f6ffnen", "panel_btn_handler": Lino.show_detail, "iconCls": "x-tbar-detail", "overflowText": "Detail", "auto_save": true }, { "itemId": null, "menu_item_text": "L\u00f6schen", "tooltip": "Diesen Datensatz l\u00f6schen", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "L\u00f6schen", "auto_save": false } ],
  title : "Organisationen",
  page_length : 20,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "name": "name" }, { "name": "email" }, { "name": "created" }, { "name": "modified" }, { "name": "country" }, 'countryHidden', { "name": "city" }, 'cityHidden', { "name": "region" }, 'regionHidden', { "name": "zip_code" }, { "name": "addr1" }, { "name": "street_prefix" }, { "name": "street" }, { "name": "street_no" }, { "name": "street_box" }, { "name": "addr2" }, { "name": "language" }, 'languageHidden', { "name": "url" }, { "name": "phone" }, { "name": "gsm" }, { "name": "fax" }, { "name": "remarks" }, { "type": "boolean", "name": "is_obsolete" }, { "name": "activity" }, 'activityHidden', { "name": "bank_account1" }, { "name": "bank_account2" }, { "name": "prefix" }, { "name": "vat_id" }, { "name": "type" }, 'typeHidden', { "name": "client_contact_type" }, 'client_contact_typeHidden', { "type": "int", "name": "id" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 35,
  ls_grid_configs : [  ],
  content_type : 19,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 37,
  initComponent : function() {
    this.ls_detail_handler = Lino.contacts.Companies.detail;
    this.ls_insert_handler = Lino.contacts.Companies.insert;
    var ww = this.containing_window;
    var name3923 = new Ext.form.TextField({ "selectOnFocus": true, "allowBlank": false, "maxLength": 200 });
    var email3924 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 75 });
    var created3925 = new Ext.form.DisplayField({ "disabled": true, "value": "<br>" });
    var modified3926 = new Ext.form.DisplayField({ "disabled": true, "value": "<br>" });
    var country3927 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/contacts/Companies/country", "method": "GET" }) }), "pageSize": 20, "emptyText": "Land ausw\u00e4hlen..." });
    var city3928 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "forceSelection": false, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/contacts/Companies/city", "method": "GET" }) }), "pageSize": 20, "emptyText": "Ort ausw\u00e4hlen..." });
    var region3929 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/contacts/Companies/region", "method": "GET" }) }), "pageSize": 20, "emptyText": "Ort ausw\u00e4hlen..." });
    var zip_code3930 = new Ext.form.TextField({ "selectOnFocus": true, "boxMinWidth": Lino.chars2width(10), "maxLength": 10 });
    var addr13931 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var street_prefix3932 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var street3933 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var street_no3934 = new Ext.form.TextField({ "selectOnFocus": true, "boxMinWidth": Lino.chars2width(10), "maxLength": 10 });
    var street_box3935 = new Ext.form.TextField({ "selectOnFocus": true, "boxMinWidth": Lino.chars2width(10), "maxLength": 10 });
    var addr23936 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var language3937 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "allowBlank": false, "store": [ [ "en", "Englisch" ], [ "fr", "Franz\u00f6sisch" ], [ "de", "Deutsch" ], [ "nl", "Niederl\u00e4ndisch" ] ] });
    var url3938 = new Lino.URLField({ "selectOnFocus": true, "maxLength": 200 });
    var phone3939 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var gsm3940 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var fax3941 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var remarks3942 = new Ext.form.TextArea({ "selectOnFocus": true, "growMax": 2000 });
    var is_obsolete3943 = new Ext.form.Checkbox({ "selectOnFocus": true, "checked": false });
    var activity3944 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/contacts/Companies/activity", "method": "GET" }) }), "pageSize": 20, "emptyText": "Beruf ausw\u00e4hlen..." });
    var bank_account13945 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 40 });
    var bank_account23946 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 40 });
    var prefix3947 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var vat_id3948 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var type3949 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/contacts/Companies/type", "method": "GET" }) }), "pageSize": 20, "emptyText": "Organisationsart ausw\u00e4hlen..." });
    var client_contact_type3950 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/contacts/Companies/client_contact_type", "method": "GET" }) }), "pageSize": 20, "emptyText": "Klientenkontaktart ausw\u00e4hlen..." });
    var id3951 = new Ext.form.NumberField({ "selectOnFocus": true });
    this.before_row_edit = function(record) {
      city3928.setContextValue('country',record ? record.data['countryHidden'] : undefined);
      city3928.setContextValue('region',record ? record.data['regionHidden'] : undefined);
      region3929.setContextValue('country',record ? record.data['countryHidden'] : undefined);
    };
    this.onRender = function(ct, position) {
      country3927.on('change',Lino.chooser_handler(city3928,'country'));
      region3929.on('change',Lino.chooser_handler(city3928,'region'));
      country3927.on('change',Lino.chooser_handler(region3929,'country'));
      Lino.contacts.Companies.GridPanel.superclass.onRender.call(this, ct, position);
    }
    this.ls_columns = [ { "colIndex": 0, "sortable": true, "header": "Name", "editable": true, "tooltip": "(contacts.Companies.name) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "name", "editor": name3923 }, { "colIndex": 1, "sortable": true, "header": "E-Mail", "editable": true, "tooltip": "(contacts.Companies.email) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "email", "editor": email3924 }, { "colIndex": 2, "sortable": true, "header": "Erstellt", "editable": false, "tooltip": "(contacts.Companies.created) ", "width": Lino.chars2width(17), "dataIndex": "created", "hidden": true }, { "colIndex": 3, "sortable": true, "header": "Bearbeitet", "editable": false, "tooltip": "(contacts.Companies.modified) ", "width": Lino.chars2width(17), "dataIndex": "modified", "hidden": true }, { "colIndex": 4, "sortable": true, "header": "Land", "editable": true, "tooltip": "(contacts.Companies.country) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('countryHidden','Lino.countries.Countries.detail'), "editor": country3927, "dataIndex": "country" }, { "colIndex": 5, "sortable": true, "header": "Ort", "editable": true, "tooltip": "(contacts.Companies.city) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "city", "editor": city3928 }, { "colIndex": 6, "sortable": true, "header": "Region", "editable": true, "tooltip": "(contacts.Companies.region) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "region", "editor": region3929 }, { "colIndex": 7, "sortable": true, "header": "Postleitzahl", "editable": true, "tooltip": "(contacts.Companies.zip_code) ", "filter": { "type": "string" }, "width": Lino.chars2width(12), "dataIndex": "zip_code", "editor": zip_code3930 }, { "colIndex": 8, "sortable": true, "header": "Adresszeile vor Stra\u00dfe", "editable": true, "tooltip": "(contacts.Companies.addr1) Address line before street", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "addr1", "editor": addr13931 }, { "colIndex": 9, "sortable": true, "header": "Pr\u00e4fix Stra\u00dfe", "editable": true, "tooltip": "(contacts.Companies.street_prefix) Text to print before name of street, but to ignore for sorting.", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "street_prefix", "editor": street_prefix3932 }, { "colIndex": 10, "sortable": true, "header": "Stra\u00dfe", "editable": true, "tooltip": "(contacts.Companies.street) Name of street. Without house number.", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "street", "editor": street3933 }, { "colIndex": 11, "sortable": true, "header": "Nr.", "editable": true, "tooltip": "(contacts.Companies.street_no) House number", "filter": { "type": "string" }, "width": Lino.chars2width(12), "dataIndex": "street_no", "editor": street_no3934 }, { "colIndex": 12, "sortable": true, "header": "Box", "editable": true, "tooltip": "(contacts.Companies.street_box) Text to print after :attr:`steet_no` on the same line", "filter": { "type": "string" }, "width": Lino.chars2width(12), "dataIndex": "street_box", "editor": street_box3935 }, { "colIndex": 13, "sortable": true, "header": "Adresszeile nach Stra\u00dfe", "editable": true, "tooltip": "(contacts.Companies.addr2) Address line to print below street line", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "addr2", "editor": addr23936 }, { "colIndex": 14, "sortable": true, "header": "Sprache", "editable": true, "tooltip": "(contacts.Companies.language) Die Sprache, in der Dokumente ausgestellt werden sollen.", "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "language", "editor": language3937 }, { "colIndex": 15, "sortable": true, "header": "URL", "editable": true, "tooltip": "(contacts.Companies.url) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "url", "editor": url3938 }, { "colIndex": 16, "sortable": true, "header": "Telefon", "editable": true, "tooltip": "(contacts.Companies.phone) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "phone", "editor": phone3939 }, { "colIndex": 17, "sortable": true, "header": "GSM", "editable": true, "tooltip": "(contacts.Companies.gsm) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "gsm", "editor": gsm3940 }, { "colIndex": 18, "sortable": true, "header": "Fax", "editable": true, "tooltip": "(contacts.Companies.fax) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "fax", "editor": fax3941 }, { "colIndex": 19, "sortable": false, "header": "Bemerkungen", "editable": true, "tooltip": "(contacts.Companies.remarks) ", "filter": { "type": "string" }, "width": Lino.chars2width(61), "renderer": Lino.text_renderer, "editor": remarks3942, "dataIndex": "remarks" }, { "colIndex": 20, "sortable": false, "xtype": "checkcolumn", "header": "veraltet", "editable": true, "tooltip": "(contacts.Companies.is_obsolete) Altf\u00e4lle sind Partner, deren Stammdaten nicht mehr gepflegt werden und \nf\u00fcr neue Operationen nicht benutzt werden k\u00f6nnen.", "filter": { "type": "boolean" }, "width": Lino.chars2width(11), "dataIndex": "is_obsolete" }, { "colIndex": 21, "sortable": true, "header": "Beruf", "editable": true, "tooltip": "(contacts.Companies.activity) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "activity", "hidden": true, "editor": activity3944 }, { "colIndex": 22, "sortable": true, "header": "Bankkonto 1", "editable": true, "tooltip": "(contacts.Companies.bank_account1) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "bank_account1", "hidden": true, "editor": bank_account13945 }, { "colIndex": 23, "sortable": true, "header": "Bankkonto 2", "editable": true, "tooltip": "(contacts.Companies.bank_account2) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "bank_account2", "hidden": true, "editor": bank_account23946 }, { "colIndex": 24, "sortable": true, "header": "prefix", "editable": true, "tooltip": "(contacts.Companies.prefix) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "prefix", "editor": prefix3947 }, { "colIndex": 25, "sortable": true, "header": "MWSt.-Nr.", "editable": true, "tooltip": "(contacts.Companies.vat_id) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "vat_id", "editor": vat_id3948 }, { "colIndex": 26, "sortable": true, "header": "Organisationsart", "editable": true, "tooltip": "(contacts.Companies.type) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "type", "editor": type3949 }, { "colIndex": 27, "sortable": true, "header": "Klientenkontaktart", "editable": true, "tooltip": "(contacts.Companies.client_contact_type) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "client_contact_type", "editor": client_contact_type3950 }, new Lino.NullNumberColumn({ "colIndex": 28, "sortable": true, "format": "0", "editable": true, "tooltip": "(contacts.Companies.id) ", "filter": { "type": "numeric" }, "header": "ID", "renderer": Lino.id_renderer, "editor": id3951, "width": Lino.chars2width(6), "dataIndex": "id" }) ];
    Lino.contacts.Companies.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.contacts.Companies.put = function(rp,pk) { 
  Lino.run_row_action(rp,"/contacts/Companies","GET",pk,"put",null);
};
Lino.contacts.Companies.post = function(rp,pk) { 
  Lino.run_row_action(rp,"/contacts/Companies","GET",pk,"post",null);
};

Lino.contacts.Companies.insertPanel = Ext.extend(Lino.contacts.Companies.InsertFormPanel,{
  empty_title: "Neu Organisationen",
  hide_navigator: true,
  ls_bbar_actions: [ { "itemId": "post", "menu_item_text": "Erstellen", "tooltip": "Datensatz erstellen und dann im Detail-Fenster \u00f6ffnen", "panel_btn_handler": function(panel){panel.save(null,true,'post')}, "text": "Erstellen", "overflowText": "Erstellen", "auto_save": false }, { "itemId": "poststay", "menu_item_text": "Erstellen ohne Detail", "tooltip": "Nach Erstellen des Datensatzes kein Detail-Fenster \u00f6ffnen", "panel_btn_handler": function(panel){panel.save(null,false,'poststay')}, "text": "Erstellen ohne Detail", "overflowText": "Erstellen ohne Detail", "auto_save": false } ],
  ls_url: "/contacts/Companies",
  action_name: "insert",
  initComponent : function() {
    this.ls_detail_handler = Lino.contacts.Companies.detail;
    this.ls_insert_handler = Lino.contacts.Companies.insert;
    Lino.contacts.Companies.insertPanel.superclass.initComponent.call(this);
  }
});

Lino.contacts.Companies.insert = new Lino.WindowAction({ "draggable": true, "width": Lino.chars2width(60), "autoHeight": true, "maximizable": true, "modal": true, "maximized": false },function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.contacts.Companies.insertPanel(p);
});
Lino.contacts.Companies.poststay = function(rp,pk) { 
  Lino.run_row_action(rp,"/contacts/Companies","GET",pk,"poststay",null);
};

Lino.contacts.Companies.detailPanel = Ext.extend(Lino.contacts.Companies.DetailFormPanel,{
  empty_title: "Detail Organisationen",
  ls_bbar_actions: [ { "itemId": "put", "menu_item_text": "Speichern", "tooltip": "\u00c4nderungen in diesem Formular speichern", "panel_btn_handler": function(panel){panel.save(null,false,'put')}, "iconCls": "x-tbar-save", "overflowText": "Speichern", "auto_save": false }, { "itemId": "insert", "menu_item_text": "Neu", "must_save": true, "tooltip": "Neuen Datensatz erstellen", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-new", "overflowText": "Neu", "auto_save": true }, { "itemId": null, "menu_item_text": "L\u00f6schen", "tooltip": "Diesen Datensatz l\u00f6schen", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "L\u00f6schen", "auto_save": false } ],
  ls_url: "/contacts/Companies",
  action_name: "detail",
  initComponent : function() {
    this.ls_detail_handler = Lino.contacts.Companies.detail;
    this.ls_insert_handler = Lino.contacts.Companies.insert;
    Lino.contacts.Companies.detailPanel.superclass.initComponent.call(this);
  }
});

Lino.contacts.Companies.detail = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.contacts.Companies.detailPanel(p);
});
Lino.contacts.Companies.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.contacts.Companies.GridPanel(p);
});

// js_render_GridPanel_class contacts.Persons
Lino.contacts.Persons.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "Keine Daten anzuzeigen." },
  ls_url : "/contacts/Persons",
  ls_bbar_actions : [ { "itemId": "insert", "menu_item_text": "Neu", "must_save": true, "tooltip": "Neuen Datensatz erstellen", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-new", "overflowText": "Neu", "auto_save": true }, { "itemId": "detail", "menu_item_text": "Detail", "tooltip": "Detail-Fenster auf diesem Datensatz \u00f6ffnen", "panel_btn_handler": Lino.show_detail, "iconCls": "x-tbar-detail", "overflowText": "Detail", "auto_save": true }, { "itemId": null, "menu_item_text": "L\u00f6schen", "tooltip": "Diesen Datensatz l\u00f6schen", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "L\u00f6schen", "auto_save": false } ],
  title : "Personen",
  page_length : 20,
  params_panel_hidden : true,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "name": "name_column" }, { "name": "address_column" }, { "name": "email" }, { "name": "phone" }, { "name": "gsm" }, { "type": "int", "name": "id" }, { "name": "language" }, 'languageHidden', { "name": "created" }, { "name": "modified" }, { "name": "country" }, 'countryHidden', { "name": "city" }, 'cityHidden', { "name": "region" }, 'regionHidden', { "name": "zip_code" }, { "name": "name" }, { "name": "addr1" }, { "name": "street_prefix" }, { "name": "street" }, { "name": "street_no" }, { "name": "street_box" }, { "name": "addr2" }, { "name": "url" }, { "name": "fax" }, { "name": "remarks" }, { "type": "boolean", "name": "is_obsolete" }, { "name": "activity" }, 'activityHidden', { "name": "bank_account1" }, { "name": "bank_account2" }, { "name": "first_name" }, { "name": "last_name" }, { "name": "gender" }, 'genderHidden', { "name": "birth_date" }, { "name": "title" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 5,
  ls_grid_configs : [  ],
  content_type : 20,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 39,
  initComponent : function() {
    this.ls_detail_handler = Lino.contacts.Persons.detail;
    this.ls_insert_handler = Lino.contacts.Persons.insert;
    var ww = this.containing_window;
    var name_column_disp3965 = new Ext.form.DisplayField({ "disabled": true, "value": "<br/>", "always_enabled": true });
    var address_column_disp3966 = new Ext.form.DisplayField({ "disabled": true, "value": "<br/>", "always_enabled": true });
    var email3967 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 75 });
    var phone3968 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var gsm3969 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var id3970 = new Ext.form.NumberField({ "selectOnFocus": true });
    var language3971 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "allowBlank": false, "store": [ [ "en", "Englisch" ], [ "fr", "Franz\u00f6sisch" ], [ "de", "Deutsch" ], [ "nl", "Niederl\u00e4ndisch" ] ] });
    var created3972 = new Ext.form.DisplayField({ "disabled": true, "value": "<br>" });
    var modified3973 = new Ext.form.DisplayField({ "disabled": true, "value": "<br>" });
    var country3974 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/contacts/Persons/country", "method": "GET" }) }), "pageSize": 20, "emptyText": "Land ausw\u00e4hlen..." });
    var city3975 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "forceSelection": false, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/contacts/Persons/city", "method": "GET" }) }), "pageSize": 20, "emptyText": "Ort ausw\u00e4hlen..." });
    var region3976 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/contacts/Persons/region", "method": "GET" }) }), "pageSize": 20, "emptyText": "Ort ausw\u00e4hlen..." });
    var zip_code3977 = new Ext.form.TextField({ "selectOnFocus": true, "boxMinWidth": Lino.chars2width(10), "maxLength": 10 });
    var name3978 = new Ext.form.TextField({ "selectOnFocus": true, "allowBlank": false, "maxLength": 200 });
    var addr13979 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var street_prefix3980 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var street3981 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var street_no3982 = new Ext.form.TextField({ "selectOnFocus": true, "boxMinWidth": Lino.chars2width(10), "maxLength": 10 });
    var street_box3983 = new Ext.form.TextField({ "selectOnFocus": true, "boxMinWidth": Lino.chars2width(10), "maxLength": 10 });
    var addr23984 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var url3985 = new Lino.URLField({ "selectOnFocus": true, "maxLength": 200 });
    var fax3986 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var remarks3987 = new Ext.form.TextArea({ "selectOnFocus": true, "growMax": 2000 });
    var is_obsolete3988 = new Ext.form.Checkbox({ "selectOnFocus": true, "checked": false });
    var activity3989 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/contacts/Persons/activity", "method": "GET" }) }), "pageSize": 20, "emptyText": "Beruf ausw\u00e4hlen..." });
    var bank_account13990 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 40 });
    var bank_account23991 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 40 });
    var first_name3992 = new Ext.form.TextField({ "selectOnFocus": true, "allowBlank": false, "maxLength": 200 });
    var last_name3993 = new Ext.form.TextField({ "selectOnFocus": true, "allowBlank": false, "maxLength": 200 });
    var gender3994 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "forceSelection": true, "store": [['','<br>']].concat(Lino.lino.Genders) });
    var birth_date3995 = new Lino.IncompleteDateField({ "selectOnFocus": true });
    var title3996 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    this.before_row_edit = function(record) {
      city3975.setContextValue('country',record ? record.data['countryHidden'] : undefined);
      city3975.setContextValue('region',record ? record.data['regionHidden'] : undefined);
      region3976.setContextValue('country',record ? record.data['countryHidden'] : undefined);
    };
    this.onRender = function(ct, position) {
      country3974.on('change',Lino.chooser_handler(city3975,'country'));
      region3976.on('change',Lino.chooser_handler(city3975,'region'));
      country3974.on('change',Lino.chooser_handler(region3976,'country'));
      Lino.contacts.Persons.GridPanel.superclass.onRender.call(this, ct, position);
    }
    this.ls_columns = [ { "width": Lino.chars2width(21), "colIndex": 0, "sortable": false, "dataIndex": "name_column", "header": "Name", "editable": false, "tooltip": "(contacts.Persons.name_column) " }, { "width": Lino.chars2width(31), "colIndex": 1, "sortable": false, "dataIndex": "address_column", "header": "Adresse", "editable": false, "tooltip": "(contacts.Persons.address_column) " }, { "colIndex": 2, "sortable": true, "header": "E-Mail", "editable": true, "tooltip": "(contacts.Persons.email) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "email", "editor": email3967 }, { "colIndex": 3, "sortable": true, "header": "Telefon", "editable": true, "tooltip": "(contacts.Persons.phone) ", "filter": { "type": "string" }, "width": Lino.chars2width(11), "dataIndex": "phone", "editor": phone3968 }, { "colIndex": 4, "sortable": true, "header": "GSM", "editable": true, "tooltip": "(contacts.Persons.gsm) ", "filter": { "type": "string" }, "width": Lino.chars2width(11), "dataIndex": "gsm", "editor": gsm3969 }, new Lino.NullNumberColumn({ "colIndex": 5, "sortable": true, "format": "0", "editable": true, "tooltip": "(contacts.Persons.id) ", "filter": { "type": "numeric" }, "header": "ID", "renderer": Lino.id_renderer, "editor": id3970, "width": Lino.chars2width(6), "dataIndex": "id" }), { "colIndex": 6, "sortable": true, "header": "Sprache", "editable": true, "tooltip": "(contacts.Persons.language) Die Sprache, in der Dokumente ausgestellt werden sollen.", "filter": { "type": "string" }, "width": Lino.chars2width(11), "dataIndex": "language", "editor": language3971 }, { "colIndex": 7, "sortable": true, "header": "Erstellt", "editable": false, "tooltip": "(contacts.Persons.created) ", "width": Lino.chars2width(17), "dataIndex": "created", "hidden": true }, { "colIndex": 8, "sortable": true, "header": "Bearbeitet", "editable": false, "tooltip": "(contacts.Persons.modified) ", "width": Lino.chars2width(17), "dataIndex": "modified", "hidden": true }, { "colIndex": 9, "sortable": true, "header": "Land", "editable": true, "tooltip": "(contacts.Persons.country) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('countryHidden','Lino.countries.Countries.detail'), "editor": country3974, "dataIndex": "country" }, { "colIndex": 10, "sortable": true, "header": "Ort", "editable": true, "tooltip": "(contacts.Persons.city) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "city", "editor": city3975 }, { "colIndex": 11, "sortable": true, "header": "Region", "editable": true, "tooltip": "(contacts.Persons.region) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "region", "editor": region3976 }, { "colIndex": 12, "sortable": true, "header": "Postleitzahl", "editable": true, "tooltip": "(contacts.Persons.zip_code) ", "filter": { "type": "string" }, "width": Lino.chars2width(12), "dataIndex": "zip_code", "editor": zip_code3977 }, { "colIndex": 13, "sortable": true, "header": "Name", "editable": true, "tooltip": "(contacts.Persons.name) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "name", "editor": name3978 }, { "colIndex": 14, "sortable": true, "header": "Adresszeile vor Stra\u00dfe", "editable": true, "tooltip": "(contacts.Persons.addr1) Address line before street", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "addr1", "editor": addr13979 }, { "colIndex": 15, "sortable": true, "header": "Pr\u00e4fix Stra\u00dfe", "editable": true, "tooltip": "(contacts.Persons.street_prefix) Text to print before name of street, but to ignore for sorting.", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "street_prefix", "editor": street_prefix3980 }, { "colIndex": 16, "sortable": true, "header": "Stra\u00dfe", "editable": true, "tooltip": "(contacts.Persons.street) Name of street. Without house number.", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "street", "editor": street3981 }, { "colIndex": 17, "sortable": true, "header": "Nr.", "editable": true, "tooltip": "(contacts.Persons.street_no) House number", "filter": { "type": "string" }, "width": Lino.chars2width(12), "dataIndex": "street_no", "editor": street_no3982 }, { "colIndex": 18, "sortable": true, "header": "Box", "editable": true, "tooltip": "(contacts.Persons.street_box) Text to print after :attr:`steet_no` on the same line", "filter": { "type": "string" }, "width": Lino.chars2width(12), "dataIndex": "street_box", "editor": street_box3983 }, { "colIndex": 19, "sortable": true, "header": "Adresszeile nach Stra\u00dfe", "editable": true, "tooltip": "(contacts.Persons.addr2) Address line to print below street line", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "addr2", "editor": addr23984 }, { "colIndex": 20, "sortable": true, "header": "URL", "editable": true, "tooltip": "(contacts.Persons.url) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "url", "editor": url3985 }, { "colIndex": 21, "sortable": true, "header": "Fax", "editable": true, "tooltip": "(contacts.Persons.fax) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "fax", "editor": fax3986 }, { "colIndex": 22, "sortable": false, "header": "Bemerkungen", "editable": true, "tooltip": "(contacts.Persons.remarks) ", "filter": { "type": "string" }, "width": Lino.chars2width(61), "renderer": Lino.text_renderer, "editor": remarks3987, "dataIndex": "remarks" }, { "colIndex": 23, "sortable": false, "xtype": "checkcolumn", "header": "veraltet", "editable": true, "tooltip": "(contacts.Persons.is_obsolete) Altf\u00e4lle sind Partner, deren Stammdaten nicht mehr gepflegt werden und \nf\u00fcr neue Operationen nicht benutzt werden k\u00f6nnen.", "filter": { "type": "boolean" }, "width": Lino.chars2width(11), "dataIndex": "is_obsolete" }, { "colIndex": 24, "sortable": true, "header": "Beruf", "editable": true, "tooltip": "(contacts.Persons.activity) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "activity", "hidden": true, "editor": activity3989 }, { "colIndex": 25, "sortable": true, "header": "Bankkonto 1", "editable": true, "tooltip": "(contacts.Persons.bank_account1) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "bank_account1", "hidden": true, "editor": bank_account13990 }, { "colIndex": 26, "sortable": true, "header": "Bankkonto 2", "editable": true, "tooltip": "(contacts.Persons.bank_account2) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "bank_account2", "hidden": true, "editor": bank_account23991 }, { "colIndex": 27, "sortable": true, "header": "Vorname", "editable": true, "tooltip": "(contacts.Persons.first_name) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "first_name", "editor": first_name3992 }, { "colIndex": 28, "sortable": true, "header": "Familienname", "editable": true, "tooltip": "(contacts.Persons.last_name) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "last_name", "editor": last_name3993 }, { "colIndex": 29, "sortable": true, "header": "Geschlecht", "editable": true, "tooltip": "(contacts.Persons.gender) ", "filter": { "type": "string" }, "width": Lino.chars2width(10), "dataIndex": "gender", "editor": gender3994 }, { "colIndex": 30, "sortable": true, "header": "Geburtsdatum", "editable": true, "tooltip": "(contacts.Persons.birth_date) Uncomplete dates are allowed, e.g. \n\"00.00.1980\" means \"some day in 1980\", \n\"00.07.1980\" means \"in July 1980\"\nor \"23.07.0000\" means \"on a 23th of July\".", "filter": { "type": "string" }, "width": Lino.chars2width(13), "dataIndex": "birth_date", "editor": birth_date3995 }, { "colIndex": 31, "sortable": true, "header": "Anrede", "editable": true, "tooltip": "(contacts.Persons.title) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "title", "editor": title3996 } ];
    Lino.contacts.Persons.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.contacts.Persons.put = function(rp,pk) { 
  Lino.run_row_action(rp,"/contacts/Persons","GET",pk,"put",null);
};
Lino.contacts.Persons.post = function(rp,pk) { 
  Lino.run_row_action(rp,"/contacts/Persons","GET",pk,"post",null);
};

Lino.contacts.Persons.insertPanel = Ext.extend(Lino.contacts.Persons.InsertFormPanel,{
  empty_title: "Neu Personen",
  hide_navigator: true,
  params_panel_hidden: true,
  ls_bbar_actions: [ { "itemId": "post", "menu_item_text": "Erstellen", "tooltip": "Datensatz erstellen und dann im Detail-Fenster \u00f6ffnen", "panel_btn_handler": function(panel){panel.save(null,true,'post')}, "text": "Erstellen", "overflowText": "Erstellen", "auto_save": false }, { "itemId": "poststay", "menu_item_text": "Erstellen ohne Detail", "tooltip": "Nach Erstellen des Datensatzes kein Detail-Fenster \u00f6ffnen", "panel_btn_handler": function(panel){panel.save(null,false,'poststay')}, "text": "Erstellen ohne Detail", "overflowText": "Erstellen ohne Detail", "auto_save": false } ],
  ls_url: "/contacts/Persons",
  action_name: "insert",
  initComponent : function() {
    this.ls_detail_handler = Lino.contacts.Persons.detail;
    this.ls_insert_handler = Lino.contacts.Persons.insert;
    Lino.contacts.Persons.insertPanel.superclass.initComponent.call(this);
  }
});

Lino.contacts.Persons.insert = new Lino.WindowAction({ "draggable": true, "width": Lino.chars2width(60), "autoHeight": true, "maximizable": true, "modal": true, "maximized": false },function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.contacts.Persons.insertPanel(p);
});
Lino.contacts.Persons.poststay = function(rp,pk) { 
  Lino.run_row_action(rp,"/contacts/Persons","GET",pk,"poststay",null);
};

Lino.contacts.Persons.detailPanel = Ext.extend(Lino.contacts.Persons.DetailFormPanel,{
  empty_title: "Detail Personen",
  params_panel_hidden: true,
  ls_bbar_actions: [ { "itemId": "put", "menu_item_text": "Speichern", "tooltip": "\u00c4nderungen in diesem Formular speichern", "panel_btn_handler": function(panel){panel.save(null,false,'put')}, "iconCls": "x-tbar-save", "overflowText": "Speichern", "auto_save": false }, { "itemId": "insert", "menu_item_text": "Neu", "must_save": true, "tooltip": "Neuen Datensatz erstellen", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-new", "overflowText": "Neu", "auto_save": true }, { "itemId": null, "menu_item_text": "L\u00f6schen", "tooltip": "Diesen Datensatz l\u00f6schen", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "L\u00f6schen", "auto_save": false } ],
  ls_url: "/contacts/Persons",
  action_name: "detail",
  initComponent : function() {
    this.ls_detail_handler = Lino.contacts.Persons.detail;
    this.ls_insert_handler = Lino.contacts.Persons.insert;
    Lino.contacts.Persons.detailPanel.superclass.initComponent.call(this);
  }
});

Lino.contacts.Persons.detail = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.contacts.Persons.detailPanel(p);
});
Lino.contacts.Persons.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  p.params_panel = new Lino.contacts.Persons.ParamsPanel({});
  return new Lino.contacts.Persons.GridPanel(p);
});

// js_render_GridPanel_class cal.OneEvent
Lino.cal.OneEvent.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "Keine Daten anzuzeigen." },
  ls_url : "/cal/OneEvent",
  ls_bbar_actions : [ { "itemId": "insert", "menu_item_text": "Neu", "must_save": true, "tooltip": "Neuen Datensatz erstellen", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-new", "overflowText": "Neu", "auto_save": true }, { "itemId": "duplicate", "menu_item_text": "Duplizieren", "must_save": true, "tooltip": "Duplizieren", "panel_btn_handler": Lino.row_action_handler('duplicate','GET',null), "iconCls": "x-tbar-duplicate", "overflowText": "Duplizieren", "auto_save": true }, { "itemId": "detail", "menu_item_text": "Detail", "tooltip": "Detail-Fenster auf diesem Datensatz \u00f6ffnen", "panel_btn_handler": Lino.show_detail, "iconCls": "x-tbar-detail", "overflowText": "Detail", "auto_save": true }, { "itemId": null, "menu_item_text": "L\u00f6schen", "tooltip": "Diesen Datensatz l\u00f6schen", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "L\u00f6schen", "auto_save": false }, { "itemId": "do_print", "menu_item_text": "Drucken", "must_save": true, "tooltip": "Drucken", "panel_btn_handler": Lino.row_action_handler('do_print','GET',null), "iconCls": "x-tbar-print", "overflowText": "Drucken", "auto_save": true }, { "itemId": "do_clear_cache", "menu_item_text": "Cache l\u00f6schen", "must_save": true, "tooltip": "Cache l\u00f6schen", "panel_btn_handler": Lino.row_action_handler('do_clear_cache','GET',null), "iconCls": "x-tbar-clearcache", "overflowText": "Cache l\u00f6schen", "auto_save": true }, { "itemId": "create_mail", "menu_item_text": "per E-Mail", "must_save": true, "tooltip": "Create an email from this", "panel_btn_handler": Lino.row_action_handler('create_mail','GET',null), "iconCls": "x-tbar-email_add", "overflowText": "per E-Mail", "auto_save": true } ],
  title : "Termine",
  page_length : 20,
  params_panel_hidden : true,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "name": "when_text" }, { "name": "user" }, 'userHidden', { "name": "summary" }, { "name": "calendar" }, 'calendarHidden', { "type": "int", "name": "id" }, { "name": "owner_type" }, 'owner_typeHidden', { "name": "owner_id" }, 'owner_idHidden', { "name": "created" }, { "name": "modified" }, { "name": "project" }, 'projectHidden', { "name": "build_time" }, { "type": "date", "name": "start_date", "dateFormat": "d.m.Y" }, { "name": "start_time" }, { "type": "date", "name": "end_date", "dateFormat": "d.m.Y" }, { "name": "end_time" }, { "name": "description" }, { "name": "uid" }, { "name": "access_class" }, 'access_classHidden', { "type": "int", "name": "sequence" }, { "type": "int", "name": "auto_type" }, { "type": "boolean", "name": "transparent" }, { "name": "room" }, 'roomHidden', { "name": "priority" }, 'priorityHidden', { "name": "state" }, 'stateHidden', { "name": "assigned_to" }, 'assigned_toHidden', { "name": "owner" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 6,
  ls_grid_configs : [  ],
  content_type : 35,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 37,
  initComponent : function() {
    this.ls_detail_handler = Lino.cal.OneEvent.detail;
    this.ls_insert_handler = Lino.cal.OneEvent.insert;
    var ww = this.containing_window;
    var when_text_disp4094 = new Ext.form.DisplayField({ "disabled": true, "value": "<br/>", "always_enabled": true });
    var user4095 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "preferred_width": 15, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/OneEvent/user", "method": "GET" }) }), "pageSize": 20, "emptyText": "Benutzer ausw\u00e4hlen..." });
    var summary4096 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var calendar4097 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/OneEvent/calendar", "method": "GET" }) }), "pageSize": 20, "emptyText": "Kalender ausw\u00e4hlen..." });
    var id4098 = new Ext.form.NumberField({ "selectOnFocus": true });
    var owner_type4099 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/OneEvent/owner_type", "method": "GET" }) }), "pageSize": 20, "emptyText": "Inhaltstyp ausw\u00e4hlen..." });
    var owner_id4100 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/OneEvent/owner_id", "method": "GET" }) }) });
    var created4101 = new Ext.form.DisplayField({ "disabled": true, "value": "<br>" });
    var modified4102 = new Ext.form.DisplayField({ "disabled": true, "value": "<br>" });
    var project4103 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "preferred_width": 20, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/OneEvent/project", "method": "GET" }) }), "pageSize": 20, "emptyText": "Klient ausw\u00e4hlen..." });
    var build_time4104 = new Ext.form.DisplayField({ "disabled": true, "value": "<br>" });
    var start_date4105 = new Lino.DateField({ "selectOnFocus": true });
    var start_time4106 = new Lino.TimeField({ "selectOnFocus": true });
    var end_date4107 = new Lino.DateField({ "selectOnFocus": true });
    var end_time4108 = new Lino.TimeField({ "selectOnFocus": true });
    var description4109 = new Lino.RichTextPanel({ "selectOnFocus": true, "containing_panel": this, "title": "Beschreibung" });
    var uid4110 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var access_class4111 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "forceSelection": true, "store": [['','<br>']].concat(Lino.cal.AccessClasses) });
    var sequence4112 = new Ext.form.NumberField({ "selectOnFocus": true, "allowBlank": false, "value": 0 });
    var auto_type4113 = new Ext.form.NumberField({ "disabled": true });
    var transparent4114 = new Ext.form.Checkbox({ "selectOnFocus": true, "checked": false });
    var room4115 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/OneEvent/room", "method": "GET" }) }), "pageSize": 20, "emptyText": "Raum ausw\u00e4hlen..." });
    var priority4116 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/OneEvent/priority", "method": "GET" }) }), "pageSize": 20, "emptyText": "Priorit\u00e4t ausw\u00e4hlen..." });
    var state4117 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "forceSelection": true, "allowBlank": false, "store": Lino.cal.EventStates });
    var assigned_to4118 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "preferred_width": 15, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/OneEvent/assigned_to", "method": "GET" }) }), "pageSize": 20, "emptyText": "Benutzer ausw\u00e4hlen..." });
    var owner_disp4119 = new Ext.form.DisplayField({ "disabled": true });
    this.before_row_edit = function(record) {
      owner_id4100.setContextValue('owner_type',record ? record.data['owner_typeHidden'] : undefined);
      description4109.refresh();
    };
    this.onRender = function(ct, position) {
      owner_type4099.on('change',Lino.chooser_handler(owner_id4100,'owner_type'));
      Lino.cal.OneEvent.GridPanel.superclass.onRender.call(this, ct, position);
    }
    this.ls_columns = [ { "width": Lino.chars2width(21), "colIndex": 0, "sortable": false, "dataIndex": "when_text", "header": "Wann", "editable": false, "tooltip": "(cal.OneEvent.when_text) " }, { "colIndex": 1, "sortable": true, "header": "Verantwortlicher", "editable": true, "tooltip": "(cal.OneEvent.user) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "user", "editor": user4095 }, { "colIndex": 2, "sortable": true, "header": "Kurzbeschreibung", "editable": true, "tooltip": "(cal.OneEvent.summary) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "summary", "editor": summary4096 }, { "colIndex": 3, "sortable": true, "header": "Kalender", "editable": true, "tooltip": "(cal.OneEvent.calendar) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "calendar", "editor": calendar4097 }, new Lino.NullNumberColumn({ "colIndex": 4, "sortable": true, "format": "0", "editable": true, "tooltip": "(cal.OneEvent.id) ", "filter": { "type": "numeric" }, "header": "ID", "renderer": Lino.id_renderer, "editor": id4098, "width": Lino.chars2width(6), "dataIndex": "id" }), { "colIndex": 5, "sortable": true, "header": "Verkn\u00fcpft mit (Modell)", "editable": true, "tooltip": "(cal.OneEvent.owner_type) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "owner_type", "hidden": true, "editor": owner_type4099 }, { "colIndex": 6, "sortable": true, "header": "Verkn\u00fcpft mit (Objekt)", "editable": true, "tooltip": "(cal.OneEvent.owner_id) ", "filter": { "type": "string" }, "width": Lino.chars2width(11), "dataIndex": "owner_id", "hidden": true, "editor": owner_id4100 }, { "colIndex": 7, "sortable": true, "header": "Erstellt", "editable": false, "tooltip": "(cal.OneEvent.created) ", "width": Lino.chars2width(17), "dataIndex": "created", "hidden": true }, { "colIndex": 8, "sortable": true, "header": "Bearbeitet", "editable": false, "tooltip": "(cal.OneEvent.modified) ", "width": Lino.chars2width(17), "dataIndex": "modified", "hidden": true }, { "colIndex": 9, "sortable": true, "header": "Klient", "editable": true, "tooltip": "(cal.OneEvent.project) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('projectHidden','Lino.pcsw.Clients.detail'), "editor": project4103, "dataIndex": "project" }, { "colIndex": 10, "sortable": true, "header": "Druckdatum", "editable": false, "tooltip": "(cal.OneEvent.build_time) ", "width": Lino.chars2width(17), "dataIndex": "build_time", "hidden": true }, { "colIndex": 11, "sortable": true, "xtype": "datecolumn", "format": "d.m.Y", "editable": true, "tooltip": "(cal.OneEvent.start_date) ", "filter": { "type": "date", "dateFormat": "d.m.Y" }, "header": "Beginnt am", "dataIndex": "start_date", "width": Lino.chars2width(9), "editor": start_date4105 }, { "colIndex": 12, "sortable": true, "header": "Beginnt um", "editable": true, "tooltip": "(cal.OneEvent.start_time) ", "width": Lino.chars2width(9), "dataIndex": "start_time", "editor": start_time4106 }, { "colIndex": 13, "sortable": true, "xtype": "datecolumn", "format": "d.m.Y", "editable": true, "tooltip": "(cal.OneEvent.end_date) ", "filter": { "type": "date", "dateFormat": "d.m.Y" }, "header": "Endet am", "dataIndex": "end_date", "hidden": true, "width": Lino.chars2width(9), "editor": end_date4107 }, { "colIndex": 14, "sortable": true, "header": "Endet um", "editable": true, "tooltip": "(cal.OneEvent.end_time) ", "width": Lino.chars2width(9), "dataIndex": "end_time", "hidden": true, "editor": end_time4108 }, { "colIndex": 15, "sortable": false, "width": Lino.chars2width(61), "editable": true, "tooltip": "(cal.OneEvent.description) ", "filter": { "type": "string" }, "header": "description", "renderer": Lino.text_renderer, "hidden": true, "editor": description4109, "dataIndex": "description" }, { "colIndex": 16, "sortable": true, "header": "UID", "editable": true, "tooltip": "(cal.OneEvent.uid) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "uid", "hidden": true, "editor": uid4110 }, { "colIndex": 17, "sortable": true, "header": "Zugriffsklasse", "editable": true, "tooltip": "(cal.OneEvent.access_class) Ob dieser Termin  privat, \u00f6ffentlich oder halb \u00f6ffentlich ist", "filter": { "type": "string" }, "width": Lino.chars2width(13), "dataIndex": "access_class", "hidden": true, "editor": access_class4111 }, new Lino.NullNumberColumn({ "colIndex": 18, "sortable": true, "format": "0", "editable": true, "tooltip": "(cal.OneEvent.sequence) ", "filter": { "type": "numeric" }, "header": "Revisionsnummer", "dataIndex": "sequence", "hidden": true, "width": Lino.chars2width(6), "editor": sequence4112 }), new Lino.NullNumberColumn({ "colIndex": 19, "sortable": true, "format": "0", "editable": false, "tooltip": "(cal.OneEvent.auto_type) ", "filter": { "type": "numeric" }, "header": "auto type", "dataIndex": "auto_type", "hidden": true, "width": Lino.chars2width(6) }), { "colIndex": 20, "sortable": false, "xtype": "checkcolumn", "header": "nicht blockierend", "editable": true, "tooltip": "(cal.OneEvent.transparent) Dieser Termin l\u00e4sst auch andere Termine zur gleichen Zeit zu.", "filter": { "type": "boolean" }, "width": Lino.chars2width(11), "dataIndex": "transparent", "hidden": true }, { "colIndex": 21, "sortable": true, "header": "Raum", "editable": true, "tooltip": "(cal.OneEvent.room) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "room", "editor": room4115 }, { "colIndex": 22, "sortable": true, "header": "Priorit\u00e4t", "editable": true, "tooltip": "(cal.OneEvent.priority) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "priority", "hidden": true, "editor": priority4116 }, { "colIndex": 23, "sortable": true, "header": "Zustand", "editable": true, "tooltip": "(cal.OneEvent.state) ", "filter": { "type": "string" }, "width": Lino.chars2width(14), "dataIndex": "state", "editor": state4117 }, { "colIndex": 24, "sortable": true, "header": "Zugewiesen zu", "editable": true, "tooltip": "(cal.OneEvent.assigned_to) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "assigned_to", "editor": assigned_to4118 }, { "colIndex": 25, "sortable": false, "header": "Verkn\u00fcpft mit", "editable": false, "tooltip": "(cal.OneEvent.owner) ", "width": Lino.chars2width(11), "dataIndex": "owner", "hidden": true } ];
    Lino.cal.OneEvent.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.cal.OneEvent.put = function(rp,pk) { 
  Lino.run_row_action(rp,"/cal/OneEvent","GET",pk,"put",null);
};
Lino.cal.OneEvent.post = function(rp,pk) { 
  Lino.run_row_action(rp,"/cal/OneEvent","GET",pk,"post",null);
};

Lino.cal.OneEvent.insertPanel = Ext.extend(Lino.cal.OneEvent.InsertFormPanel,{
  empty_title: "Neu Termine",
  hide_navigator: true,
  params_panel_hidden: true,
  ls_bbar_actions: [ { "itemId": "post", "menu_item_text": "Erstellen", "tooltip": "Datensatz erstellen und dann im Detail-Fenster \u00f6ffnen", "panel_btn_handler": function(panel){panel.save(null,true,'post')}, "text": "Erstellen", "overflowText": "Erstellen", "auto_save": false }, { "itemId": "poststay", "menu_item_text": "Erstellen ohne Detail", "tooltip": "Nach Erstellen des Datensatzes kein Detail-Fenster \u00f6ffnen", "panel_btn_handler": function(panel){panel.save(null,false,'poststay')}, "text": "Erstellen ohne Detail", "overflowText": "Erstellen ohne Detail", "auto_save": false } ],
  ls_url: "/cal/OneEvent",
  action_name: "insert",
  initComponent : function() {
    this.ls_detail_handler = Lino.cal.OneEvent.detail;
    this.ls_insert_handler = Lino.cal.OneEvent.insert;
    Lino.cal.OneEvent.insertPanel.superclass.initComponent.call(this);
  }
});

Lino.cal.OneEvent.insert = new Lino.WindowAction({ "draggable": true, "width": Lino.chars2width(60), "autoHeight": true, "maximizable": true, "modal": true, "maximized": false },function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.cal.OneEvent.insertPanel(p);
});
Lino.cal.OneEvent.wf1 = function(rp,pk) { 
  Lino.run_row_action(rp,"/cal/OneEvent","GET",pk,"wf1",null);
};
Lino.cal.OneEvent.poststay = function(rp,pk) { 
  Lino.run_row_action(rp,"/cal/OneEvent","GET",pk,"poststay",null);
};
Lino.cal.OneEvent.duplicate = function(rp,pk) { 
  Lino.run_row_action(rp,"/cal/OneEvent","GET",pk,"duplicate",null);
};
Lino.cal.OneEvent.wf2 = function(rp,pk) { 
  Lino.run_row_action(rp,"/cal/OneEvent","GET",pk,"wf2",null);
};
Lino.cal.OneEvent.wf3 = function(rp,pk) { 
  Lino.run_row_action(rp,"/cal/OneEvent","GET",pk,"wf3",null);
};
Lino.cal.OneEvent.wf4 = function(rp,pk) { 
  Lino.run_row_action(rp,"/cal/OneEvent","GET",pk,"wf4",null);
};

Lino.cal.OneEvent.detailPanel = Ext.extend(Lino.cal.OneEvent.DetailFormPanel,{
  empty_title: "Detail Termine",
  params_panel_hidden: true,
  ls_bbar_actions: [ { "itemId": "put", "menu_item_text": "Speichern", "tooltip": "\u00c4nderungen in diesem Formular speichern", "panel_btn_handler": function(panel){panel.save(null,false,'put')}, "iconCls": "x-tbar-save", "overflowText": "Speichern", "auto_save": false }, { "itemId": "insert", "menu_item_text": "Neu", "must_save": true, "tooltip": "Neuen Datensatz erstellen", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-new", "overflowText": "Neu", "auto_save": true }, { "itemId": "duplicate", "menu_item_text": "Duplizieren", "must_save": true, "tooltip": "Duplizieren", "panel_btn_handler": Lino.row_action_handler('duplicate','GET',null), "iconCls": "x-tbar-duplicate", "overflowText": "Duplizieren", "auto_save": true }, { "itemId": null, "menu_item_text": "L\u00f6schen", "tooltip": "Diesen Datensatz l\u00f6schen", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "L\u00f6schen", "auto_save": false }, { "itemId": "do_print", "menu_item_text": "Drucken", "must_save": true, "tooltip": "Drucken", "panel_btn_handler": Lino.row_action_handler('do_print','GET',null), "iconCls": "x-tbar-print", "overflowText": "Drucken", "auto_save": true }, { "itemId": "do_clear_cache", "menu_item_text": "Cache l\u00f6schen", "must_save": true, "tooltip": "Cache l\u00f6schen", "panel_btn_handler": Lino.row_action_handler('do_clear_cache','GET',null), "iconCls": "x-tbar-clearcache", "overflowText": "Cache l\u00f6schen", "auto_save": true }, { "itemId": "create_mail", "menu_item_text": "per E-Mail", "must_save": true, "tooltip": "Create an email from this", "panel_btn_handler": Lino.row_action_handler('create_mail','GET',null), "iconCls": "x-tbar-email_add", "overflowText": "per E-Mail", "auto_save": true } ],
  ls_url: "/cal/OneEvent",
  action_name: "detail",
  initComponent : function() {
    this.ls_detail_handler = Lino.cal.OneEvent.detail;
    this.ls_insert_handler = Lino.cal.OneEvent.insert;
    Lino.cal.OneEvent.detailPanel.superclass.initComponent.call(this);
  }
});

Lino.cal.OneEvent.detail = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.cal.OneEvent.detailPanel(p);
});
Lino.cal.OneEvent.do_print = function(rp,pk) { 
  Lino.run_row_action(rp,"/cal/OneEvent","GET",pk,"do_print",null);
};
Lino.cal.OneEvent.do_clear_cache = function(rp,pk) { 
  Lino.run_row_action(rp,"/cal/OneEvent","GET",pk,"do_clear_cache",null);
};
Lino.cal.OneEvent.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  p.params_panel = new Lino.cal.OneEvent.ParamsPanel({});
  return new Lino.cal.OneEvent.GridPanel(p);
});
Lino.cal.OneEvent.create_mail = function(rp,pk) { 
  Lino.run_row_action(rp,"/cal/OneEvent","GET",pk,"create_mail",null);
};
Lino.cal.OneEvent.take = function(rp,pk) { 
  Lino.run_row_action(rp,"/cal/OneEvent","GET",pk,"take",null);
};

// js_render_GridPanel_class cal.MyEvents
Lino.cal.MyEvents.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "Keine Daten anzuzeigen." },
  ls_url : "/cal/MyEvents",
  ls_bbar_actions : [ { "itemId": "insert", "menu_item_text": "Neu", "must_save": true, "tooltip": "Neuen Datensatz erstellen", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-new", "overflowText": "Neu", "auto_save": true }, { "itemId": "duplicate", "menu_item_text": "Duplizieren", "must_save": true, "tooltip": "Duplizieren", "panel_btn_handler": Lino.row_action_handler('duplicate','GET',null), "iconCls": "x-tbar-duplicate", "overflowText": "Duplizieren", "auto_save": true }, { "itemId": "detail", "menu_item_text": "Detail", "tooltip": "Detail-Fenster auf diesem Datensatz \u00f6ffnen", "panel_btn_handler": Lino.show_detail, "iconCls": "x-tbar-detail", "overflowText": "Detail", "auto_save": true }, { "itemId": null, "menu_item_text": "L\u00f6schen", "tooltip": "Diesen Datensatz l\u00f6schen", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "L\u00f6schen", "auto_save": false }, { "itemId": "do_print", "menu_item_text": "Drucken", "must_save": true, "tooltip": "Drucken", "panel_btn_handler": Lino.row_action_handler('do_print','GET',null), "iconCls": "x-tbar-print", "overflowText": "Drucken", "auto_save": true }, { "itemId": "do_clear_cache", "menu_item_text": "Cache l\u00f6schen", "must_save": true, "tooltip": "Cache l\u00f6schen", "panel_btn_handler": Lino.row_action_handler('do_clear_cache','GET',null), "iconCls": "x-tbar-clearcache", "overflowText": "Cache l\u00f6schen", "auto_save": true }, { "itemId": "create_mail", "menu_item_text": "per E-Mail", "must_save": true, "tooltip": "Create an email from this", "panel_btn_handler": Lino.row_action_handler('create_mail','GET',null), "iconCls": "x-tbar-email_add", "overflowText": "per E-Mail", "auto_save": true } ],
  title : "Meine Termine",
  page_length : 20,
  params_panel_hidden : true,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "name": "when_text" }, { "name": "summary" }, { "name": "workflow_buttons" }, { "name": "project" }, 'projectHidden', { "type": "int", "name": "id" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 5,
  ls_grid_configs : [  ],
  content_type : 35,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 7,
  initComponent : function() {
    this.ls_detail_handler = Lino.cal.MyEvents.detail;
    this.ls_insert_handler = Lino.cal.MyEvents.insert;
    var ww = this.containing_window;
    var when_text_disp4121 = new Ext.form.DisplayField({ "disabled": true, "value": "<br/>", "always_enabled": true });
    var summary4122 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var workflow_buttons_disp4123 = new Ext.form.DisplayField({ "disabled": true, "value": "<br/>", "always_enabled": true });
    var project4124 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "preferred_width": 20, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/MyEvents/project", "method": "GET" }) }), "pageSize": 20, "emptyText": "Klient ausw\u00e4hlen..." });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ { "width": Lino.chars2width(31), "colIndex": 0, "sortable": false, "dataIndex": "when_text", "header": "Wann", "editable": false, "tooltip": "(cal.MyEvents.when_text) " }, { "colIndex": 1, "sortable": true, "header": "Kurzbeschreibung", "editable": true, "tooltip": "(cal.MyEvents.summary) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "summary", "editor": summary4122 }, { "width": Lino.chars2width(31), "colIndex": 2, "sortable": false, "dataIndex": "workflow_buttons", "header": "Arbeitsablauf", "editable": false, "tooltip": "(cal.MyEvents.workflow_buttons) " }, { "colIndex": 3, "sortable": true, "header": "Klient", "editable": true, "tooltip": "(cal.MyEvents.project) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('projectHidden','Lino.pcsw.Clients.detail'), "editor": project4124, "dataIndex": "project" } ];
    Lino.cal.MyEvents.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.cal.MyEvents.put = function(rp,pk) { 
  Lino.run_row_action(rp,"/cal/MyEvents","GET",pk,"put",null);
};
Lino.cal.MyEvents.post = function(rp,pk) { 
  Lino.run_row_action(rp,"/cal/MyEvents","GET",pk,"post",null);
};

Lino.cal.MyEvents.insertPanel = Ext.extend(Lino.cal.OneEvent.InsertFormPanel,{
  empty_title: "Neu Meine Termine",
  hide_navigator: true,
  params_panel_hidden: true,
  ls_bbar_actions: [ { "itemId": "post", "menu_item_text": "Erstellen", "tooltip": "Datensatz erstellen und dann im Detail-Fenster \u00f6ffnen", "panel_btn_handler": function(panel){panel.save(null,true,'post')}, "text": "Erstellen", "overflowText": "Erstellen", "auto_save": false }, { "itemId": "poststay", "menu_item_text": "Erstellen ohne Detail", "tooltip": "Nach Erstellen des Datensatzes kein Detail-Fenster \u00f6ffnen", "panel_btn_handler": function(panel){panel.save(null,false,'poststay')}, "text": "Erstellen ohne Detail", "overflowText": "Erstellen ohne Detail", "auto_save": false } ],
  ls_url: "/cal/MyEvents",
  action_name: "insert",
  initComponent : function() {
    this.ls_detail_handler = Lino.cal.MyEvents.detail;
    this.ls_insert_handler = Lino.cal.MyEvents.insert;
    Lino.cal.MyEvents.insertPanel.superclass.initComponent.call(this);
  }
});

Lino.cal.MyEvents.insert = new Lino.WindowAction({ "draggable": true, "width": Lino.chars2width(60), "autoHeight": true, "maximizable": true, "modal": true, "maximized": false },function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.cal.MyEvents.insertPanel(p);
});
Lino.cal.MyEvents.wf1 = function(rp,pk) { 
  Lino.run_row_action(rp,"/cal/MyEvents","GET",pk,"wf1",null);
};
Lino.cal.MyEvents.poststay = function(rp,pk) { 
  Lino.run_row_action(rp,"/cal/MyEvents","GET",pk,"poststay",null);
};
Lino.cal.MyEvents.duplicate = function(rp,pk) { 
  Lino.run_row_action(rp,"/cal/MyEvents","GET",pk,"duplicate",null);
};
Lino.cal.MyEvents.wf2 = function(rp,pk) { 
  Lino.run_row_action(rp,"/cal/MyEvents","GET",pk,"wf2",null);
};
Lino.cal.MyEvents.wf3 = function(rp,pk) { 
  Lino.run_row_action(rp,"/cal/MyEvents","GET",pk,"wf3",null);
};
Lino.cal.MyEvents.wf4 = function(rp,pk) { 
  Lino.run_row_action(rp,"/cal/MyEvents","GET",pk,"wf4",null);
};

Lino.cal.MyEvents.detailPanel = Ext.extend(Lino.cal.OneEvent.DetailFormPanel,{
  empty_title: "Detail Meine Termine",
  params_panel_hidden: true,
  ls_bbar_actions: [ { "itemId": "put", "menu_item_text": "Speichern", "tooltip": "\u00c4nderungen in diesem Formular speichern", "panel_btn_handler": function(panel){panel.save(null,false,'put')}, "iconCls": "x-tbar-save", "overflowText": "Speichern", "auto_save": false }, { "itemId": "insert", "menu_item_text": "Neu", "must_save": true, "tooltip": "Neuen Datensatz erstellen", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-new", "overflowText": "Neu", "auto_save": true }, { "itemId": "duplicate", "menu_item_text": "Duplizieren", "must_save": true, "tooltip": "Duplizieren", "panel_btn_handler": Lino.row_action_handler('duplicate','GET',null), "iconCls": "x-tbar-duplicate", "overflowText": "Duplizieren", "auto_save": true }, { "itemId": null, "menu_item_text": "L\u00f6schen", "tooltip": "Diesen Datensatz l\u00f6schen", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "L\u00f6schen", "auto_save": false }, { "itemId": "do_print", "menu_item_text": "Drucken", "must_save": true, "tooltip": "Drucken", "panel_btn_handler": Lino.row_action_handler('do_print','GET',null), "iconCls": "x-tbar-print", "overflowText": "Drucken", "auto_save": true }, { "itemId": "do_clear_cache", "menu_item_text": "Cache l\u00f6schen", "must_save": true, "tooltip": "Cache l\u00f6schen", "panel_btn_handler": Lino.row_action_handler('do_clear_cache','GET',null), "iconCls": "x-tbar-clearcache", "overflowText": "Cache l\u00f6schen", "auto_save": true }, { "itemId": "create_mail", "menu_item_text": "per E-Mail", "must_save": true, "tooltip": "Create an email from this", "panel_btn_handler": Lino.row_action_handler('create_mail','GET',null), "iconCls": "x-tbar-email_add", "overflowText": "per E-Mail", "auto_save": true } ],
  ls_url: "/cal/MyEvents",
  action_name: "detail",
  initComponent : function() {
    this.ls_detail_handler = Lino.cal.MyEvents.detail;
    this.ls_insert_handler = Lino.cal.MyEvents.insert;
    Lino.cal.MyEvents.detailPanel.superclass.initComponent.call(this);
  }
});

Lino.cal.MyEvents.detail = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.cal.MyEvents.detailPanel(p);
});
Lino.cal.MyEvents.do_print = function(rp,pk) { 
  Lino.run_row_action(rp,"/cal/MyEvents","GET",pk,"do_print",null);
};
Lino.cal.MyEvents.do_clear_cache = function(rp,pk) { 
  Lino.run_row_action(rp,"/cal/MyEvents","GET",pk,"do_clear_cache",null);
};
Lino.cal.MyEvents.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  p.params_panel = new Lino.cal.OneEvent.ParamsPanel({});
  return new Lino.cal.MyEvents.GridPanel(p);
});
Lino.cal.MyEvents.take = function(rp,pk) { 
  Lino.run_row_action(rp,"/cal/MyEvents","GET",pk,"take",null);
};
Lino.cal.MyEvents.create_mail = function(rp,pk) { 
  Lino.run_row_action(rp,"/cal/MyEvents","GET",pk,"create_mail",null);
};

// js_render_GridPanel_class cal.MyAssignedEvents
Lino.cal.MyAssignedEvents.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "Keine Daten anzuzeigen." },
  ls_url : "/cal/MyAssignedEvents",
  ls_bbar_actions : [ { "itemId": "insert", "menu_item_text": "Neu", "must_save": true, "tooltip": "Neuen Datensatz erstellen", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-new", "overflowText": "Neu", "auto_save": true }, { "itemId": "duplicate", "menu_item_text": "Duplizieren", "must_save": true, "tooltip": "Duplizieren", "panel_btn_handler": Lino.row_action_handler('duplicate','GET',null), "iconCls": "x-tbar-duplicate", "overflowText": "Duplizieren", "auto_save": true }, { "itemId": "detail", "menu_item_text": "Detail", "tooltip": "Detail-Fenster auf diesem Datensatz \u00f6ffnen", "panel_btn_handler": Lino.show_detail, "iconCls": "x-tbar-detail", "overflowText": "Detail", "auto_save": true }, { "itemId": null, "menu_item_text": "L\u00f6schen", "tooltip": "Diesen Datensatz l\u00f6schen", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "L\u00f6schen", "auto_save": false }, { "itemId": "do_print", "menu_item_text": "Drucken", "must_save": true, "tooltip": "Drucken", "panel_btn_handler": Lino.row_action_handler('do_print','GET',null), "iconCls": "x-tbar-print", "overflowText": "Drucken", "auto_save": true }, { "itemId": "do_clear_cache", "menu_item_text": "Cache l\u00f6schen", "must_save": true, "tooltip": "Cache l\u00f6schen", "panel_btn_handler": Lino.row_action_handler('do_clear_cache','GET',null), "iconCls": "x-tbar-clearcache", "overflowText": "Cache l\u00f6schen", "auto_save": true }, { "itemId": "create_mail", "menu_item_text": "per E-Mail", "must_save": true, "tooltip": "Create an email from this", "panel_btn_handler": Lino.row_action_handler('create_mail','GET',null), "iconCls": "x-tbar-email_add", "overflowText": "per E-Mail", "auto_save": true } ],
  title : "Events assigned to me",
  page_length : 20,
  params_panel_hidden : true,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "name": "when_text" }, { "name": "summary" }, { "name": "workflow_buttons" }, { "name": "project" }, 'projectHidden', { "type": "int", "name": "id" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 5,
  ls_grid_configs : [  ],
  content_type : 35,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 7,
  initComponent : function() {
    this.ls_detail_handler = Lino.cal.MyAssignedEvents.detail;
    this.ls_insert_handler = Lino.cal.MyAssignedEvents.insert;
    var ww = this.containing_window;
    var when_text_disp4126 = new Ext.form.DisplayField({ "disabled": true, "value": "<br/>", "always_enabled": true });
    var summary4127 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var workflow_buttons_disp4128 = new Ext.form.DisplayField({ "disabled": true, "value": "<br/>", "always_enabled": true });
    var project4129 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "preferred_width": 20, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/MyAssignedEvents/project", "method": "GET" }) }), "pageSize": 20, "emptyText": "Klient ausw\u00e4hlen..." });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ { "width": Lino.chars2width(31), "colIndex": 0, "sortable": false, "dataIndex": "when_text", "header": "Wann", "editable": false, "tooltip": "(cal.MyAssignedEvents.when_text) " }, { "colIndex": 1, "sortable": true, "header": "Kurzbeschreibung", "editable": true, "tooltip": "(cal.MyAssignedEvents.summary) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "summary", "editor": summary4127 }, { "width": Lino.chars2width(31), "colIndex": 2, "sortable": false, "dataIndex": "workflow_buttons", "header": "Arbeitsablauf", "editable": false, "tooltip": "(cal.MyAssignedEvents.workflow_buttons) " }, { "colIndex": 3, "sortable": true, "header": "Klient", "editable": true, "tooltip": "(cal.MyAssignedEvents.project) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('projectHidden','Lino.pcsw.Clients.detail'), "editor": project4129, "dataIndex": "project" } ];
    Lino.cal.MyAssignedEvents.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.cal.MyAssignedEvents.put = function(rp,pk) { 
  Lino.run_row_action(rp,"/cal/MyAssignedEvents","GET",pk,"put",null);
};
Lino.cal.MyAssignedEvents.post = function(rp,pk) { 
  Lino.run_row_action(rp,"/cal/MyAssignedEvents","GET",pk,"post",null);
};

Lino.cal.MyAssignedEvents.insertPanel = Ext.extend(Lino.cal.OneEvent.InsertFormPanel,{
  empty_title: "Neu Events assigned to me",
  hide_navigator: true,
  params_panel_hidden: true,
  ls_bbar_actions: [ { "itemId": "post", "menu_item_text": "Erstellen", "tooltip": "Datensatz erstellen und dann im Detail-Fenster \u00f6ffnen", "panel_btn_handler": function(panel){panel.save(null,true,'post')}, "text": "Erstellen", "overflowText": "Erstellen", "auto_save": false }, { "itemId": "poststay", "menu_item_text": "Erstellen ohne Detail", "tooltip": "Nach Erstellen des Datensatzes kein Detail-Fenster \u00f6ffnen", "panel_btn_handler": function(panel){panel.save(null,false,'poststay')}, "text": "Erstellen ohne Detail", "overflowText": "Erstellen ohne Detail", "auto_save": false } ],
  ls_url: "/cal/MyAssignedEvents",
  action_name: "insert",
  initComponent : function() {
    this.ls_detail_handler = Lino.cal.MyAssignedEvents.detail;
    this.ls_insert_handler = Lino.cal.MyAssignedEvents.insert;
    Lino.cal.MyAssignedEvents.insertPanel.superclass.initComponent.call(this);
  }
});

Lino.cal.MyAssignedEvents.insert = new Lino.WindowAction({ "draggable": true, "width": Lino.chars2width(60), "autoHeight": true, "maximizable": true, "modal": true, "maximized": false },function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.cal.MyAssignedEvents.insertPanel(p);
});
Lino.cal.MyAssignedEvents.wf1 = function(rp,pk) { 
  Lino.run_row_action(rp,"/cal/MyAssignedEvents","GET",pk,"wf1",null);
};
Lino.cal.MyAssignedEvents.poststay = function(rp,pk) { 
  Lino.run_row_action(rp,"/cal/MyAssignedEvents","GET",pk,"poststay",null);
};
Lino.cal.MyAssignedEvents.duplicate = function(rp,pk) { 
  Lino.run_row_action(rp,"/cal/MyAssignedEvents","GET",pk,"duplicate",null);
};
Lino.cal.MyAssignedEvents.wf2 = function(rp,pk) { 
  Lino.run_row_action(rp,"/cal/MyAssignedEvents","GET",pk,"wf2",null);
};
Lino.cal.MyAssignedEvents.wf3 = function(rp,pk) { 
  Lino.run_row_action(rp,"/cal/MyAssignedEvents","GET",pk,"wf3",null);
};
Lino.cal.MyAssignedEvents.wf4 = function(rp,pk) { 
  Lino.run_row_action(rp,"/cal/MyAssignedEvents","GET",pk,"wf4",null);
};

Lino.cal.MyAssignedEvents.detailPanel = Ext.extend(Lino.cal.OneEvent.DetailFormPanel,{
  empty_title: "Detail Events assigned to me",
  params_panel_hidden: true,
  ls_bbar_actions: [ { "itemId": "put", "menu_item_text": "Speichern", "tooltip": "\u00c4nderungen in diesem Formular speichern", "panel_btn_handler": function(panel){panel.save(null,false,'put')}, "iconCls": "x-tbar-save", "overflowText": "Speichern", "auto_save": false }, { "itemId": "insert", "menu_item_text": "Neu", "must_save": true, "tooltip": "Neuen Datensatz erstellen", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-new", "overflowText": "Neu", "auto_save": true }, { "itemId": "duplicate", "menu_item_text": "Duplizieren", "must_save": true, "tooltip": "Duplizieren", "panel_btn_handler": Lino.row_action_handler('duplicate','GET',null), "iconCls": "x-tbar-duplicate", "overflowText": "Duplizieren", "auto_save": true }, { "itemId": null, "menu_item_text": "L\u00f6schen", "tooltip": "Diesen Datensatz l\u00f6schen", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "L\u00f6schen", "auto_save": false }, { "itemId": "do_print", "menu_item_text": "Drucken", "must_save": true, "tooltip": "Drucken", "panel_btn_handler": Lino.row_action_handler('do_print','GET',null), "iconCls": "x-tbar-print", "overflowText": "Drucken", "auto_save": true }, { "itemId": "do_clear_cache", "menu_item_text": "Cache l\u00f6schen", "must_save": true, "tooltip": "Cache l\u00f6schen", "panel_btn_handler": Lino.row_action_handler('do_clear_cache','GET',null), "iconCls": "x-tbar-clearcache", "overflowText": "Cache l\u00f6schen", "auto_save": true }, { "itemId": "create_mail", "menu_item_text": "per E-Mail", "must_save": true, "tooltip": "Create an email from this", "panel_btn_handler": Lino.row_action_handler('create_mail','GET',null), "iconCls": "x-tbar-email_add", "overflowText": "per E-Mail", "auto_save": true } ],
  ls_url: "/cal/MyAssignedEvents",
  action_name: "detail",
  initComponent : function() {
    this.ls_detail_handler = Lino.cal.MyAssignedEvents.detail;
    this.ls_insert_handler = Lino.cal.MyAssignedEvents.insert;
    Lino.cal.MyAssignedEvents.detailPanel.superclass.initComponent.call(this);
  }
});

Lino.cal.MyAssignedEvents.detail = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.cal.MyAssignedEvents.detailPanel(p);
});
Lino.cal.MyAssignedEvents.do_print = function(rp,pk) { 
  Lino.run_row_action(rp,"/cal/MyAssignedEvents","GET",pk,"do_print",null);
};
Lino.cal.MyAssignedEvents.do_clear_cache = function(rp,pk) { 
  Lino.run_row_action(rp,"/cal/MyAssignedEvents","GET",pk,"do_clear_cache",null);
};
Lino.cal.MyAssignedEvents.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  p.params_panel = new Lino.cal.OneEvent.ParamsPanel({});
  return new Lino.cal.MyAssignedEvents.GridPanel(p);
});
Lino.cal.MyAssignedEvents.create_mail = function(rp,pk) { 
  Lino.run_row_action(rp,"/cal/MyAssignedEvents","GET",pk,"create_mail",null);
};
Lino.cal.MyAssignedEvents.take = function(rp,pk) { 
  Lino.run_row_action(rp,"/cal/MyAssignedEvents","GET",pk,"take",null);
};

// js_render_GridPanel_class cal.MyTasks
Lino.cal.MyTasks.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "Keine Daten anzuzeigen." },
  ls_url : "/cal/MyTasks",
  ls_bbar_actions : [ { "itemId": "insert", "menu_item_text": "Neu", "must_save": true, "tooltip": "Neuen Datensatz erstellen", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-new", "overflowText": "Neu", "auto_save": true }, { "itemId": "detail", "menu_item_text": "Detail", "tooltip": "Detail-Fenster auf diesem Datensatz \u00f6ffnen", "panel_btn_handler": Lino.show_detail, "iconCls": "x-tbar-detail", "overflowText": "Detail", "auto_save": true }, { "itemId": null, "menu_item_text": "L\u00f6schen", "tooltip": "Diesen Datensatz l\u00f6schen", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "L\u00f6schen", "auto_save": false } ],
  title : "Meine Aufgaben",
  page_length : 20,
  params_panel_hidden : true,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "type": "date", "name": "start_date", "dateFormat": "d.m.Y" }, { "name": "summary" }, { "name": "workflow_buttons" }, { "name": "project" }, 'projectHidden', { "type": "int", "name": "id" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 5,
  ls_grid_configs : [  ],
  content_type : 29,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 7,
  initComponent : function() {
    this.ls_detail_handler = Lino.cal.MyTasks.detail;
    this.ls_insert_handler = Lino.cal.MyTasks.insert;
    var ww = this.containing_window;
    var start_date4154 = new Lino.DateField({ "selectOnFocus": true });
    var summary4155 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var workflow_buttons_disp4156 = new Ext.form.DisplayField({ "disabled": true, "value": "<br/>", "always_enabled": true });
    var project4157 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "preferred_width": 20, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/MyTasks/project", "method": "GET" }) }), "pageSize": 20, "emptyText": "Klient ausw\u00e4hlen..." });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ { "colIndex": 0, "sortable": true, "xtype": "datecolumn", "format": "d.m.Y", "editable": true, "tooltip": "(cal.MyTasks.start_date) ", "filter": { "type": "date", "dateFormat": "d.m.Y" }, "header": "Beginnt am", "dataIndex": "start_date", "width": Lino.chars2width(9), "editor": start_date4154 }, { "colIndex": 1, "sortable": true, "header": "Kurzbeschreibung", "editable": true, "tooltip": "(cal.MyTasks.summary) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "summary", "editor": summary4155 }, { "width": Lino.chars2width(31), "colIndex": 2, "sortable": false, "dataIndex": "workflow_buttons", "header": "Arbeitsablauf", "editable": false, "tooltip": "(cal.MyTasks.workflow_buttons) " }, { "colIndex": 3, "sortable": true, "header": "Klient", "editable": true, "tooltip": "(cal.MyTasks.project) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('projectHidden','Lino.pcsw.Clients.detail'), "editor": project4157, "dataIndex": "project" } ];
    Lino.cal.MyTasks.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.cal.MyTasks.put = function(rp,pk) { 
  Lino.run_row_action(rp,"/cal/MyTasks","GET",pk,"put",null);
};
Lino.cal.MyTasks.post = function(rp,pk) { 
  Lino.run_row_action(rp,"/cal/MyTasks","GET",pk,"post",null);
};

Lino.cal.MyTasks.insertPanel = Ext.extend(Lino.cal.MyTasks.InsertFormPanel,{
  empty_title: "Neu Meine Aufgaben",
  hide_navigator: true,
  params_panel_hidden: true,
  ls_bbar_actions: [ { "itemId": "post", "menu_item_text": "Erstellen", "tooltip": "Datensatz erstellen und dann im Detail-Fenster \u00f6ffnen", "panel_btn_handler": function(panel){panel.save(null,true,'post')}, "text": "Erstellen", "overflowText": "Erstellen", "auto_save": false }, { "itemId": "poststay", "menu_item_text": "Erstellen ohne Detail", "tooltip": "Nach Erstellen des Datensatzes kein Detail-Fenster \u00f6ffnen", "panel_btn_handler": function(panel){panel.save(null,false,'poststay')}, "text": "Erstellen ohne Detail", "overflowText": "Erstellen ohne Detail", "auto_save": false } ],
  ls_url: "/cal/MyTasks",
  action_name: "insert",
  initComponent : function() {
    this.ls_detail_handler = Lino.cal.MyTasks.detail;
    this.ls_insert_handler = Lino.cal.MyTasks.insert;
    Lino.cal.MyTasks.insertPanel.superclass.initComponent.call(this);
  }
});

Lino.cal.MyTasks.insert = new Lino.WindowAction({ "draggable": true, "width": Lino.chars2width(50), "autoHeight": true, "maximizable": true, "modal": true, "maximized": false },function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.cal.MyTasks.insertPanel(p);
});
Lino.cal.MyTasks.wf1 = function(rp,pk) { 
  Lino.run_row_action(rp,"/cal/MyTasks","GET",pk,"wf1",null);
};
Lino.cal.MyTasks.poststay = function(rp,pk) { 
  Lino.run_row_action(rp,"/cal/MyTasks","GET",pk,"poststay",null);
};
Lino.cal.MyTasks.wf2 = function(rp,pk) { 
  Lino.run_row_action(rp,"/cal/MyTasks","GET",pk,"wf2",null);
};
Lino.cal.MyTasks.wf3 = function(rp,pk) { 
  Lino.run_row_action(rp,"/cal/MyTasks","GET",pk,"wf3",null);
};

Lino.cal.MyTasks.detailPanel = Ext.extend(Lino.cal.MyTasks.DetailFormPanel,{
  empty_title: "Detail Meine Aufgaben",
  params_panel_hidden: true,
  ls_bbar_actions: [ { "itemId": "put", "menu_item_text": "Speichern", "tooltip": "\u00c4nderungen in diesem Formular speichern", "panel_btn_handler": function(panel){panel.save(null,false,'put')}, "iconCls": "x-tbar-save", "overflowText": "Speichern", "auto_save": false }, { "itemId": "insert", "menu_item_text": "Neu", "must_save": true, "tooltip": "Neuen Datensatz erstellen", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-new", "overflowText": "Neu", "auto_save": true }, { "itemId": null, "menu_item_text": "L\u00f6schen", "tooltip": "Diesen Datensatz l\u00f6schen", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "L\u00f6schen", "auto_save": false } ],
  ls_url: "/cal/MyTasks",
  action_name: "detail",
  initComponent : function() {
    this.ls_detail_handler = Lino.cal.MyTasks.detail;
    this.ls_insert_handler = Lino.cal.MyTasks.insert;
    Lino.cal.MyTasks.detailPanel.superclass.initComponent.call(this);
  }
});

Lino.cal.MyTasks.detail = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.cal.MyTasks.detailPanel(p);
});
Lino.cal.MyTasks.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  p.params_panel = new Lino.cal.MyTasks.ParamsPanel({});
  return new Lino.cal.MyTasks.GridPanel(p);
});

// js_render_GridPanel_class cal.MyPresences
Lino.cal.MyPresences.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "Keine Daten anzuzeigen." },
  ls_url : "/cal/MyPresences",
  ls_bbar_actions : [ { "itemId": "insert", "menu_item_text": "Neu", "must_save": true, "tooltip": "Neuen Datensatz erstellen", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-new", "overflowText": "Neu", "auto_save": true }, { "itemId": "duplicate", "menu_item_text": "Duplizieren", "must_save": true, "tooltip": "Duplizieren", "panel_btn_handler": Lino.row_action_handler('duplicate','GET',null), "iconCls": "x-tbar-duplicate", "overflowText": "Duplizieren", "auto_save": true }, { "itemId": "detail", "menu_item_text": "Detail", "tooltip": "Detail-Fenster auf diesem Datensatz \u00f6ffnen", "panel_btn_handler": Lino.show_detail, "iconCls": "x-tbar-detail", "overflowText": "Detail", "auto_save": true }, { "itemId": null, "menu_item_text": "L\u00f6schen", "tooltip": "Diesen Datensatz l\u00f6schen", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "L\u00f6schen", "auto_save": false }, { "itemId": "do_print", "menu_item_text": "Drucken", "must_save": true, "tooltip": "Drucken", "panel_btn_handler": Lino.row_action_handler('do_print','GET',null), "iconCls": "x-tbar-print", "overflowText": "Drucken", "auto_save": true }, { "itemId": "do_clear_cache", "menu_item_text": "Cache l\u00f6schen", "must_save": true, "tooltip": "Cache l\u00f6schen", "panel_btn_handler": Lino.row_action_handler('do_clear_cache','GET',null), "iconCls": "x-tbar-clearcache", "overflowText": "Cache l\u00f6schen", "auto_save": true }, { "itemId": "create_mail", "menu_item_text": "per E-Mail", "must_save": true, "tooltip": "Create an email from this", "panel_btn_handler": Lino.row_action_handler('create_mail','GET',null), "iconCls": "x-tbar-email_add", "overflowText": "per E-Mail", "auto_save": true } ],
  title : "Meine Anwesenheiten",
  page_length : 20,
  params_panel_hidden : true,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "type": "date", "name": "event__start_date", "dateFormat": "d.m.Y" }, { "name": "event__start_time" }, { "name": "event_summary" }, { "name": "role" }, 'roleHidden', { "name": "workflow_buttons" }, { "name": "remark" }, { "type": "int", "name": "id" }, { "name": "build_time" }, { "name": "event" }, 'eventHidden', { "name": "partner" }, 'partnerHidden', { "name": "state" }, 'stateHidden', { "name": "waiting_since" }, { "name": "waiting_until" }, { "name": "present_until" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 7,
  ls_grid_configs : [  ],
  content_type : 36,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 19,
  initComponent : function() {
    this.ls_detail_handler = Lino.cal.MyPresences.detail;
    this.ls_insert_handler = Lino.cal.MyPresences.insert;
    var ww = this.containing_window;
    var event__start_date4181 = new Lino.DateField({ "disabled": true });
    var event__start_time4182 = new Lino.TimeField({ "disabled": true });
    var event_summary_disp4183 = new Ext.form.DisplayField({ "disabled": true, "value": "<br/>", "always_enabled": true });
    var role4184 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/MyPresences/role", "method": "GET" }) }), "pageSize": 20, "emptyText": "Gastrolle ausw\u00e4hlen..." });
    var workflow_buttons_disp4185 = new Ext.form.DisplayField({ "disabled": true, "value": "<br/>", "always_enabled": true });
    var remark4186 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var id4187 = new Ext.form.NumberField({ "selectOnFocus": true });
    var build_time4188 = new Ext.form.DisplayField({ "disabled": true, "value": "<br>" });
    var event4189 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/MyPresences/event", "method": "GET" }) }), "allowBlank": false, "pageSize": 20, "emptyText": "Termin ausw\u00e4hlen..." });
    var partner4190 = new Lino.RemoteComboFieldElement({ "preferred_width": 20, "allowBlank": false, "pageSize": 20, "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/MyPresences/partner", "method": "GET" }) }), "emptyText": "Partner ausw\u00e4hlen..." });
    var state4191 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "forceSelection": true, "allowBlank": false, "store": Lino.cal.GuestStates });
    var waiting_since4192 = new Ext.form.DisplayField({ "disabled": true, "value": "<br>" });
    var waiting_until4193 = new Ext.form.DisplayField({ "disabled": true, "value": "<br>" });
    var present_until4194 = new Ext.form.DisplayField({ "disabled": true, "value": "<br>" });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ { "colIndex": 0, "sortable": true, "xtype": "datecolumn", "format": "d.m.Y", "editable": false, "tooltip": "(cal.MyPresences.event__start_date) ", "filter": { "type": "date", "dateFormat": "d.m.Y" }, "header": "Beginnt am", "dataIndex": "event__start_date", "width": Lino.chars2width(9) }, { "width": Lino.chars2width(9), "colIndex": 1, "sortable": true, "dataIndex": "event__start_time", "header": "Beginnt um", "editable": false, "tooltip": "(cal.MyPresences.event__start_time) " }, { "width": Lino.chars2width(31), "colIndex": 2, "sortable": false, "dataIndex": "event_summary", "header": "Termin", "editable": false, "tooltip": "(cal.MyPresences.event_summary) " }, { "colIndex": 3, "sortable": true, "header": "Rolle", "editable": true, "tooltip": "(cal.MyPresences.role) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "role", "editor": role4184 }, { "width": Lino.chars2width(31), "colIndex": 4, "sortable": false, "dataIndex": "workflow_buttons", "header": "Arbeitsablauf", "editable": false, "tooltip": "(cal.MyPresences.workflow_buttons) " }, { "colIndex": 5, "sortable": true, "header": "Bemerkung", "editable": true, "tooltip": "(cal.MyPresences.remark) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "remark", "editor": remark4186 }, new Lino.NullNumberColumn({ "colIndex": 6, "sortable": true, "format": "0", "editable": true, "tooltip": "(cal.MyPresences.id) ", "filter": { "type": "numeric" }, "header": "ID", "renderer": Lino.id_renderer, "editor": id4187, "width": Lino.chars2width(6), "dataIndex": "id" }), { "width": Lino.chars2width(17), "colIndex": 7, "sortable": true, "dataIndex": "build_time", "header": "Druckdatum", "editable": false, "tooltip": "(cal.MyPresences.build_time) " }, { "colIndex": 8, "sortable": true, "header": "Termin", "editable": true, "tooltip": "(cal.MyPresences.event) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('eventHidden','Lino.cal.OneEvent.detail'), "editor": event4189, "dataIndex": "event" }, { "colIndex": 9, "sortable": true, "header": "Partner", "editable": true, "tooltip": "(cal.MyPresences.partner) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('partnerHidden','Lino.contacts.Partners.detail'), "editor": partner4190, "dataIndex": "partner" }, { "colIndex": 10, "sortable": true, "header": "Zustand", "editable": true, "tooltip": "(cal.MyPresences.state) ", "filter": { "type": "string" }, "width": Lino.chars2width(12), "dataIndex": "state", "editor": state4191 }, { "width": Lino.chars2width(17), "colIndex": 11, "sortable": true, "dataIndex": "waiting_since", "header": "Wartet seit", "editable": false, "tooltip": "(cal.MyPresences.waiting_since) Time when the visitor arrived (checked in)." }, { "width": Lino.chars2width(17), "colIndex": 12, "sortable": true, "dataIndex": "waiting_until", "header": "Hat gewartet bis", "editable": false, "tooltip": "(cal.MyPresences.waiting_until) Time when the visitor was received by agent." }, { "width": Lino.chars2width(17), "colIndex": 13, "sortable": true, "dataIndex": "present_until", "header": "Present until", "editable": false, "tooltip": "(cal.MyPresences.present_until) Time when the visitor left (checked out)." } ];
    Lino.cal.MyPresences.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.cal.MyPresences.put = function(rp,pk) { 
  Lino.run_row_action(rp,"/cal/MyPresences","GET",pk,"put",null);
};
Lino.cal.MyPresences.post = function(rp,pk) { 
  Lino.run_row_action(rp,"/cal/MyPresences","GET",pk,"post",null);
};

Lino.cal.MyPresences.insertPanel = Ext.extend(Lino.cal.MyPresences.InsertFormPanel,{
  empty_title: "Neu Meine Anwesenheiten",
  hide_navigator: true,
  params_panel_hidden: true,
  ls_bbar_actions: [ { "itemId": "post", "menu_item_text": "Erstellen", "tooltip": "Datensatz erstellen und dann im Detail-Fenster \u00f6ffnen", "panel_btn_handler": function(panel){panel.save(null,true,'post')}, "text": "Erstellen", "overflowText": "Erstellen", "auto_save": false }, { "itemId": "poststay", "menu_item_text": "Erstellen ohne Detail", "tooltip": "Nach Erstellen des Datensatzes kein Detail-Fenster \u00f6ffnen", "panel_btn_handler": function(panel){panel.save(null,false,'poststay')}, "text": "Erstellen ohne Detail", "overflowText": "Erstellen ohne Detail", "auto_save": false } ],
  ls_url: "/cal/MyPresences",
  action_name: "insert",
  initComponent : function() {
    this.ls_detail_handler = Lino.cal.MyPresences.detail;
    this.ls_insert_handler = Lino.cal.MyPresences.insert;
    Lino.cal.MyPresences.insertPanel.superclass.initComponent.call(this);
  }
});

Lino.cal.MyPresences.insert = new Lino.WindowAction({ "draggable": true, "width": Lino.chars2width(60), "autoHeight": true, "maximizable": true, "modal": true, "maximized": false },function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.cal.MyPresences.insertPanel(p);
});
Lino.cal.MyPresences.poststay = function(rp,pk) { 
  Lino.run_row_action(rp,"/cal/MyPresences","GET",pk,"poststay",null);
};
Lino.cal.MyPresences.duplicate = function(rp,pk) { 
  Lino.run_row_action(rp,"/cal/MyPresences","GET",pk,"duplicate",null);
};
Lino.cal.MyPresences.wf3 = function(rp,pk) { 
  Lino.run_row_action(rp,"/cal/MyPresences","GET",pk,"wf3",null);
};
Lino.cal.MyPresences.wf4 = function(rp,pk) { 
  Lino.run_row_action(rp,"/cal/MyPresences","GET",pk,"wf4",null);
};

Lino.cal.MyPresences.detailPanel = Ext.extend(Lino.cal.MyPresences.DetailFormPanel,{
  empty_title: "Detail Meine Anwesenheiten",
  params_panel_hidden: true,
  ls_bbar_actions: [ { "itemId": "put", "menu_item_text": "Speichern", "tooltip": "\u00c4nderungen in diesem Formular speichern", "panel_btn_handler": function(panel){panel.save(null,false,'put')}, "iconCls": "x-tbar-save", "overflowText": "Speichern", "auto_save": false }, { "itemId": "insert", "menu_item_text": "Neu", "must_save": true, "tooltip": "Neuen Datensatz erstellen", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-new", "overflowText": "Neu", "auto_save": true }, { "itemId": "duplicate", "menu_item_text": "Duplizieren", "must_save": true, "tooltip": "Duplizieren", "panel_btn_handler": Lino.row_action_handler('duplicate','GET',null), "iconCls": "x-tbar-duplicate", "overflowText": "Duplizieren", "auto_save": true }, { "itemId": null, "menu_item_text": "L\u00f6schen", "tooltip": "Diesen Datensatz l\u00f6schen", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "L\u00f6schen", "auto_save": false }, { "itemId": "do_print", "menu_item_text": "Drucken", "must_save": true, "tooltip": "Drucken", "panel_btn_handler": Lino.row_action_handler('do_print','GET',null), "iconCls": "x-tbar-print", "overflowText": "Drucken", "auto_save": true }, { "itemId": "do_clear_cache", "menu_item_text": "Cache l\u00f6schen", "must_save": true, "tooltip": "Cache l\u00f6schen", "panel_btn_handler": Lino.row_action_handler('do_clear_cache','GET',null), "iconCls": "x-tbar-clearcache", "overflowText": "Cache l\u00f6schen", "auto_save": true }, { "itemId": "create_mail", "menu_item_text": "per E-Mail", "must_save": true, "tooltip": "Create an email from this", "panel_btn_handler": Lino.row_action_handler('create_mail','GET',null), "iconCls": "x-tbar-email_add", "overflowText": "per E-Mail", "auto_save": true } ],
  ls_url: "/cal/MyPresences",
  action_name: "detail",
  initComponent : function() {
    this.ls_detail_handler = Lino.cal.MyPresences.detail;
    this.ls_insert_handler = Lino.cal.MyPresences.insert;
    Lino.cal.MyPresences.detailPanel.superclass.initComponent.call(this);
  }
});

Lino.cal.MyPresences.detail = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.cal.MyPresences.detailPanel(p);
});
Lino.cal.MyPresences.do_print = function(rp,pk) { 
  Lino.run_row_action(rp,"/cal/MyPresences","GET",pk,"do_print",null);
};
Lino.cal.MyPresences.do_clear_cache = function(rp,pk) { 
  Lino.run_row_action(rp,"/cal/MyPresences","GET",pk,"do_clear_cache",null);
};
Lino.cal.MyPresences.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  p.params_panel = new Lino.cal.MyPresences.ParamsPanel({});
  return new Lino.cal.MyPresences.GridPanel(p);
});
Lino.cal.MyPresences.create_mail = function(rp,pk) { 
  Lino.run_row_action(rp,"/cal/MyPresences","GET",pk,"create_mail",null);
};
Lino.cal.MyPresences.receive = function(rp,pk) { 
  Lino.run_row_action(rp,"/cal/MyPresences","GET",pk,"receive",null);
};
Lino.cal.MyPresences.checkout = function(rp,pk) { 
  Lino.run_row_action(rp,"/cal/MyPresences","GET",pk,"checkout",null);
};

// js_render_GridPanel_class cal.MyPendingPresences
Lino.cal.MyPendingPresences.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "Keine Daten anzuzeigen." },
  ls_url : "/cal/MyPendingPresences",
  ls_bbar_actions : [ { "itemId": "insert", "menu_item_text": "Neu", "must_save": true, "tooltip": "Neuen Datensatz erstellen", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-new", "overflowText": "Neu", "auto_save": true }, { "itemId": "duplicate", "menu_item_text": "Duplizieren", "must_save": true, "tooltip": "Duplizieren", "panel_btn_handler": Lino.row_action_handler('duplicate','GET',null), "iconCls": "x-tbar-duplicate", "overflowText": "Duplizieren", "auto_save": true }, { "itemId": "detail", "menu_item_text": "Detail", "tooltip": "Detail-Fenster auf diesem Datensatz \u00f6ffnen", "panel_btn_handler": Lino.show_detail, "iconCls": "x-tbar-detail", "overflowText": "Detail", "auto_save": true }, { "itemId": null, "menu_item_text": "L\u00f6schen", "tooltip": "Diesen Datensatz l\u00f6schen", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "L\u00f6schen", "auto_save": false }, { "itemId": "do_print", "menu_item_text": "Drucken", "must_save": true, "tooltip": "Drucken", "panel_btn_handler": Lino.row_action_handler('do_print','GET',null), "iconCls": "x-tbar-print", "overflowText": "Drucken", "auto_save": true }, { "itemId": "do_clear_cache", "menu_item_text": "Cache l\u00f6schen", "must_save": true, "tooltip": "Cache l\u00f6schen", "panel_btn_handler": Lino.row_action_handler('do_clear_cache','GET',null), "iconCls": "x-tbar-clearcache", "overflowText": "Cache l\u00f6schen", "auto_save": true }, { "itemId": "create_mail", "menu_item_text": "per E-Mail", "must_save": true, "tooltip": "Create an email from this", "panel_btn_handler": Lino.row_action_handler('create_mail','GET',null), "iconCls": "x-tbar-email_add", "overflowText": "per E-Mail", "auto_save": true } ],
  title : "My pending presences",
  page_length : 20,
  params_panel_hidden : true,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "name": "event__when_text" }, { "name": "role" }, 'roleHidden', { "name": "workflow_buttons" }, { "name": "remark" }, { "type": "int", "name": "id" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 5,
  ls_grid_configs : [  ],
  content_type : 36,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 7,
  initComponent : function() {
    this.ls_detail_handler = Lino.cal.MyPendingPresences.detail;
    this.ls_insert_handler = Lino.cal.MyPendingPresences.insert;
    var ww = this.containing_window;
    var event__when_text_disp4196 = new Ext.form.DisplayField({ "disabled": true, "value": "<br/>", "always_enabled": true });
    var role4197 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/MyPendingPresences/role", "method": "GET" }) }), "pageSize": 20, "emptyText": "Gastrolle ausw\u00e4hlen..." });
    var workflow_buttons_disp4198 = new Ext.form.DisplayField({ "disabled": true, "value": "<br/>", "always_enabled": true });
    var remark4199 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ { "width": Lino.chars2width(31), "colIndex": 0, "sortable": false, "dataIndex": "event__when_text", "header": "Wann", "editable": false, "tooltip": "(cal.MyPendingPresences.event__when_text) " }, { "colIndex": 1, "sortable": true, "header": "Rolle", "editable": true, "tooltip": "(cal.MyPendingPresences.role) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "role", "editor": role4197 }, { "width": Lino.chars2width(31), "colIndex": 2, "sortable": false, "dataIndex": "workflow_buttons", "header": "Arbeitsablauf", "editable": false, "tooltip": "(cal.MyPendingPresences.workflow_buttons) " }, { "colIndex": 3, "sortable": true, "header": "Bemerkung", "editable": true, "tooltip": "(cal.MyPendingPresences.remark) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "remark", "editor": remark4199 } ];
    Lino.cal.MyPendingPresences.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.cal.MyPendingPresences.put = function(rp,pk) { 
  Lino.run_row_action(rp,"/cal/MyPendingPresences","GET",pk,"put",null);
};
Lino.cal.MyPendingPresences.post = function(rp,pk) { 
  Lino.run_row_action(rp,"/cal/MyPendingPresences","GET",pk,"post",null);
};

Lino.cal.MyPendingPresences.insertPanel = Ext.extend(Lino.cal.MyPresences.InsertFormPanel,{
  empty_title: "Neu My pending presences",
  hide_navigator: true,
  params_panel_hidden: true,
  ls_bbar_actions: [ { "itemId": "post", "menu_item_text": "Erstellen", "tooltip": "Datensatz erstellen und dann im Detail-Fenster \u00f6ffnen", "panel_btn_handler": function(panel){panel.save(null,true,'post')}, "text": "Erstellen", "overflowText": "Erstellen", "auto_save": false }, { "itemId": "poststay", "menu_item_text": "Erstellen ohne Detail", "tooltip": "Nach Erstellen des Datensatzes kein Detail-Fenster \u00f6ffnen", "panel_btn_handler": function(panel){panel.save(null,false,'poststay')}, "text": "Erstellen ohne Detail", "overflowText": "Erstellen ohne Detail", "auto_save": false } ],
  ls_url: "/cal/MyPendingPresences",
  action_name: "insert",
  initComponent : function() {
    this.ls_detail_handler = Lino.cal.MyPendingPresences.detail;
    this.ls_insert_handler = Lino.cal.MyPendingPresences.insert;
    Lino.cal.MyPendingPresences.insertPanel.superclass.initComponent.call(this);
  }
});

Lino.cal.MyPendingPresences.insert = new Lino.WindowAction({ "draggable": true, "width": Lino.chars2width(60), "autoHeight": true, "maximizable": true, "modal": true, "maximized": false },function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.cal.MyPendingPresences.insertPanel(p);
});
Lino.cal.MyPendingPresences.poststay = function(rp,pk) { 
  Lino.run_row_action(rp,"/cal/MyPendingPresences","GET",pk,"poststay",null);
};
Lino.cal.MyPendingPresences.duplicate = function(rp,pk) { 
  Lino.run_row_action(rp,"/cal/MyPendingPresences","GET",pk,"duplicate",null);
};
Lino.cal.MyPendingPresences.wf3 = function(rp,pk) { 
  Lino.run_row_action(rp,"/cal/MyPendingPresences","GET",pk,"wf3",null);
};
Lino.cal.MyPendingPresences.wf4 = function(rp,pk) { 
  Lino.run_row_action(rp,"/cal/MyPendingPresences","GET",pk,"wf4",null);
};

Lino.cal.MyPendingPresences.detailPanel = Ext.extend(Lino.cal.MyPresences.DetailFormPanel,{
  empty_title: "Detail My pending presences",
  params_panel_hidden: true,
  ls_bbar_actions: [ { "itemId": "put", "menu_item_text": "Speichern", "tooltip": "\u00c4nderungen in diesem Formular speichern", "panel_btn_handler": function(panel){panel.save(null,false,'put')}, "iconCls": "x-tbar-save", "overflowText": "Speichern", "auto_save": false }, { "itemId": "insert", "menu_item_text": "Neu", "must_save": true, "tooltip": "Neuen Datensatz erstellen", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-new", "overflowText": "Neu", "auto_save": true }, { "itemId": "duplicate", "menu_item_text": "Duplizieren", "must_save": true, "tooltip": "Duplizieren", "panel_btn_handler": Lino.row_action_handler('duplicate','GET',null), "iconCls": "x-tbar-duplicate", "overflowText": "Duplizieren", "auto_save": true }, { "itemId": null, "menu_item_text": "L\u00f6schen", "tooltip": "Diesen Datensatz l\u00f6schen", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "L\u00f6schen", "auto_save": false }, { "itemId": "do_print", "menu_item_text": "Drucken", "must_save": true, "tooltip": "Drucken", "panel_btn_handler": Lino.row_action_handler('do_print','GET',null), "iconCls": "x-tbar-print", "overflowText": "Drucken", "auto_save": true }, { "itemId": "do_clear_cache", "menu_item_text": "Cache l\u00f6schen", "must_save": true, "tooltip": "Cache l\u00f6schen", "panel_btn_handler": Lino.row_action_handler('do_clear_cache','GET',null), "iconCls": "x-tbar-clearcache", "overflowText": "Cache l\u00f6schen", "auto_save": true }, { "itemId": "create_mail", "menu_item_text": "per E-Mail", "must_save": true, "tooltip": "Create an email from this", "panel_btn_handler": Lino.row_action_handler('create_mail','GET',null), "iconCls": "x-tbar-email_add", "overflowText": "per E-Mail", "auto_save": true } ],
  ls_url: "/cal/MyPendingPresences",
  action_name: "detail",
  initComponent : function() {
    this.ls_detail_handler = Lino.cal.MyPendingPresences.detail;
    this.ls_insert_handler = Lino.cal.MyPendingPresences.insert;
    Lino.cal.MyPendingPresences.detailPanel.superclass.initComponent.call(this);
  }
});

Lino.cal.MyPendingPresences.detail = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.cal.MyPendingPresences.detailPanel(p);
});
Lino.cal.MyPendingPresences.do_print = function(rp,pk) { 
  Lino.run_row_action(rp,"/cal/MyPendingPresences","GET",pk,"do_print",null);
};
Lino.cal.MyPendingPresences.do_clear_cache = function(rp,pk) { 
  Lino.run_row_action(rp,"/cal/MyPendingPresences","GET",pk,"do_clear_cache",null);
};
Lino.cal.MyPendingPresences.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  p.params_panel = new Lino.cal.MyPresences.ParamsPanel({});
  return new Lino.cal.MyPendingPresences.GridPanel(p);
});
Lino.cal.MyPendingPresences.create_mail = function(rp,pk) { 
  Lino.run_row_action(rp,"/cal/MyPendingPresences","GET",pk,"create_mail",null);
};
Lino.cal.MyPendingPresences.receive = function(rp,pk) { 
  Lino.run_row_action(rp,"/cal/MyPendingPresences","GET",pk,"receive",null);
};
Lino.cal.MyPendingPresences.checkout = function(rp,pk) { 
  Lino.run_row_action(rp,"/cal/MyPendingPresences","GET",pk,"checkout",null);
};

// js_render_GridPanel_class cal.MyGuests
Lino.cal.MyGuests.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "Keine Daten anzuzeigen." },
  ls_url : "/cal/MyGuests",
  ls_bbar_actions : [ { "itemId": "insert", "menu_item_text": "Neu", "must_save": true, "tooltip": "Neuen Datensatz erstellen", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-new", "overflowText": "Neu", "auto_save": true }, { "itemId": "duplicate", "menu_item_text": "Duplizieren", "must_save": true, "tooltip": "Duplizieren", "panel_btn_handler": Lino.row_action_handler('duplicate','GET',null), "iconCls": "x-tbar-duplicate", "overflowText": "Duplizieren", "auto_save": true }, { "itemId": "detail", "menu_item_text": "Detail", "tooltip": "Detail-Fenster auf diesem Datensatz \u00f6ffnen", "panel_btn_handler": Lino.show_detail, "iconCls": "x-tbar-detail", "overflowText": "Detail", "auto_save": true }, { "itemId": null, "menu_item_text": "L\u00f6schen", "tooltip": "Diesen Datensatz l\u00f6schen", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "L\u00f6schen", "auto_save": false }, { "itemId": "do_print", "menu_item_text": "Drucken", "must_save": true, "tooltip": "Drucken", "panel_btn_handler": Lino.row_action_handler('do_print','GET',null), "iconCls": "x-tbar-print", "overflowText": "Drucken", "auto_save": true }, { "itemId": "do_clear_cache", "menu_item_text": "Cache l\u00f6schen", "must_save": true, "tooltip": "Cache l\u00f6schen", "panel_btn_handler": Lino.row_action_handler('do_clear_cache','GET',null), "iconCls": "x-tbar-clearcache", "overflowText": "Cache l\u00f6schen", "auto_save": true }, { "itemId": "create_mail", "menu_item_text": "per E-Mail", "must_save": true, "tooltip": "Create an email from this", "panel_btn_handler": Lino.row_action_handler('create_mail','GET',null), "iconCls": "x-tbar-email_add", "overflowText": "per E-Mail", "auto_save": true } ],
  title : "Meine G\u00e4ste",
  page_length : 20,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "type": "date", "name": "event__start_date", "dateFormat": "d.m.Y" }, { "name": "event__start_time" }, { "name": "event_summary" }, { "name": "role" }, 'roleHidden', { "name": "workflow_buttons" }, { "name": "remark" }, { "type": "int", "name": "id" }, { "name": "build_time" }, { "name": "event" }, 'eventHidden', { "name": "partner" }, 'partnerHidden', { "name": "state" }, 'stateHidden', { "name": "waiting_since" }, { "name": "waiting_until" }, { "name": "present_until" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 7,
  ls_grid_configs : [  ],
  content_type : 36,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 19,
  initComponent : function() {
    this.ls_detail_handler = Lino.cal.MyGuests.detail;
    this.ls_insert_handler = Lino.cal.MyGuests.insert;
    var ww = this.containing_window;
    var event__start_date4201 = new Lino.DateField({ "disabled": true });
    var event__start_time4202 = new Lino.TimeField({ "disabled": true });
    var event_summary_disp4203 = new Ext.form.DisplayField({ "disabled": true, "value": "<br/>", "always_enabled": true });
    var role4204 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/MyGuests/role", "method": "GET" }) }), "pageSize": 20, "emptyText": "Gastrolle ausw\u00e4hlen..." });
    var workflow_buttons_disp4205 = new Ext.form.DisplayField({ "disabled": true, "value": "<br/>", "always_enabled": true });
    var remark4206 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var id4207 = new Ext.form.NumberField({ "selectOnFocus": true });
    var build_time4208 = new Ext.form.DisplayField({ "disabled": true, "value": "<br>" });
    var event4209 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/MyGuests/event", "method": "GET" }) }), "allowBlank": false, "pageSize": 20, "emptyText": "Termin ausw\u00e4hlen..." });
    var partner4210 = new Lino.RemoteComboFieldElement({ "preferred_width": 20, "allowBlank": false, "pageSize": 20, "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/MyGuests/partner", "method": "GET" }) }), "emptyText": "Partner ausw\u00e4hlen..." });
    var state4211 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "forceSelection": true, "allowBlank": false, "store": Lino.cal.GuestStates });
    var waiting_since4212 = new Ext.form.DisplayField({ "disabled": true, "value": "<br>" });
    var waiting_until4213 = new Ext.form.DisplayField({ "disabled": true, "value": "<br>" });
    var present_until4214 = new Ext.form.DisplayField({ "disabled": true, "value": "<br>" });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ { "colIndex": 0, "sortable": true, "xtype": "datecolumn", "format": "d.m.Y", "editable": false, "tooltip": "(cal.MyGuests.event__start_date) ", "filter": { "type": "date", "dateFormat": "d.m.Y" }, "header": "Beginnt am", "dataIndex": "event__start_date", "width": Lino.chars2width(9) }, { "width": Lino.chars2width(9), "colIndex": 1, "sortable": true, "dataIndex": "event__start_time", "header": "Beginnt um", "editable": false, "tooltip": "(cal.MyGuests.event__start_time) " }, { "width": Lino.chars2width(31), "colIndex": 2, "sortable": false, "dataIndex": "event_summary", "header": "Termin", "editable": false, "tooltip": "(cal.MyGuests.event_summary) " }, { "colIndex": 3, "sortable": true, "header": "Rolle", "editable": true, "tooltip": "(cal.MyGuests.role) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "role", "editor": role4204 }, { "width": Lino.chars2width(31), "colIndex": 4, "sortable": false, "dataIndex": "workflow_buttons", "header": "Arbeitsablauf", "editable": false, "tooltip": "(cal.MyGuests.workflow_buttons) " }, { "colIndex": 5, "sortable": true, "header": "Bemerkung", "editable": true, "tooltip": "(cal.MyGuests.remark) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "remark", "editor": remark4206 }, new Lino.NullNumberColumn({ "colIndex": 6, "sortable": true, "format": "0", "editable": true, "tooltip": "(cal.MyGuests.id) ", "filter": { "type": "numeric" }, "header": "ID", "renderer": Lino.id_renderer, "editor": id4207, "width": Lino.chars2width(6), "dataIndex": "id" }), { "width": Lino.chars2width(17), "colIndex": 7, "sortable": true, "dataIndex": "build_time", "header": "Druckdatum", "editable": false, "tooltip": "(cal.MyGuests.build_time) " }, { "colIndex": 8, "sortable": true, "header": "Termin", "editable": true, "tooltip": "(cal.MyGuests.event) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('eventHidden','Lino.cal.OneEvent.detail'), "editor": event4209, "dataIndex": "event" }, { "colIndex": 9, "sortable": true, "header": "Partner", "editable": true, "tooltip": "(cal.MyGuests.partner) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('partnerHidden','Lino.contacts.Partners.detail'), "editor": partner4210, "dataIndex": "partner" }, { "colIndex": 10, "sortable": true, "header": "Zustand", "editable": true, "tooltip": "(cal.MyGuests.state) ", "filter": { "type": "string" }, "width": Lino.chars2width(12), "dataIndex": "state", "editor": state4211 }, { "width": Lino.chars2width(17), "colIndex": 11, "sortable": true, "dataIndex": "waiting_since", "header": "Wartet seit", "editable": false, "tooltip": "(cal.MyGuests.waiting_since) Time when the visitor arrived (checked in)." }, { "width": Lino.chars2width(17), "colIndex": 12, "sortable": true, "dataIndex": "waiting_until", "header": "Hat gewartet bis", "editable": false, "tooltip": "(cal.MyGuests.waiting_until) Time when the visitor was received by agent." }, { "width": Lino.chars2width(17), "colIndex": 13, "sortable": true, "dataIndex": "present_until", "header": "Present until", "editable": false, "tooltip": "(cal.MyGuests.present_until) Time when the visitor left (checked out)." } ];
    Lino.cal.MyGuests.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.cal.MyGuests.put = function(rp,pk) { 
  Lino.run_row_action(rp,"/cal/MyGuests","GET",pk,"put",null);
};
Lino.cal.MyGuests.post = function(rp,pk) { 
  Lino.run_row_action(rp,"/cal/MyGuests","GET",pk,"post",null);
};

Lino.cal.MyGuests.insertPanel = Ext.extend(Lino.cal.MyPresences.InsertFormPanel,{
  empty_title: "Neu Meine G\u00e4ste",
  hide_navigator: true,
  ls_bbar_actions: [ { "itemId": "post", "menu_item_text": "Erstellen", "tooltip": "Datensatz erstellen und dann im Detail-Fenster \u00f6ffnen", "panel_btn_handler": function(panel){panel.save(null,true,'post')}, "text": "Erstellen", "overflowText": "Erstellen", "auto_save": false }, { "itemId": "poststay", "menu_item_text": "Erstellen ohne Detail", "tooltip": "Nach Erstellen des Datensatzes kein Detail-Fenster \u00f6ffnen", "panel_btn_handler": function(panel){panel.save(null,false,'poststay')}, "text": "Erstellen ohne Detail", "overflowText": "Erstellen ohne Detail", "auto_save": false } ],
  ls_url: "/cal/MyGuests",
  action_name: "insert",
  initComponent : function() {
    this.ls_detail_handler = Lino.cal.MyGuests.detail;
    this.ls_insert_handler = Lino.cal.MyGuests.insert;
    Lino.cal.MyGuests.insertPanel.superclass.initComponent.call(this);
  }
});

Lino.cal.MyGuests.insert = new Lino.WindowAction({ "draggable": true, "width": Lino.chars2width(60), "autoHeight": true, "maximizable": true, "modal": true, "maximized": false },function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.cal.MyGuests.insertPanel(p);
});
Lino.cal.MyGuests.poststay = function(rp,pk) { 
  Lino.run_row_action(rp,"/cal/MyGuests","GET",pk,"poststay",null);
};
Lino.cal.MyGuests.duplicate = function(rp,pk) { 
  Lino.run_row_action(rp,"/cal/MyGuests","GET",pk,"duplicate",null);
};
Lino.cal.MyGuests.wf3 = function(rp,pk) { 
  Lino.run_row_action(rp,"/cal/MyGuests","GET",pk,"wf3",null);
};
Lino.cal.MyGuests.wf4 = function(rp,pk) { 
  Lino.run_row_action(rp,"/cal/MyGuests","GET",pk,"wf4",null);
};

Lino.cal.MyGuests.detailPanel = Ext.extend(Lino.cal.MyPresences.DetailFormPanel,{
  empty_title: "Detail Meine G\u00e4ste",
  ls_bbar_actions: [ { "itemId": "put", "menu_item_text": "Speichern", "tooltip": "\u00c4nderungen in diesem Formular speichern", "panel_btn_handler": function(panel){panel.save(null,false,'put')}, "iconCls": "x-tbar-save", "overflowText": "Speichern", "auto_save": false }, { "itemId": "insert", "menu_item_text": "Neu", "must_save": true, "tooltip": "Neuen Datensatz erstellen", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-new", "overflowText": "Neu", "auto_save": true }, { "itemId": "duplicate", "menu_item_text": "Duplizieren", "must_save": true, "tooltip": "Duplizieren", "panel_btn_handler": Lino.row_action_handler('duplicate','GET',null), "iconCls": "x-tbar-duplicate", "overflowText": "Duplizieren", "auto_save": true }, { "itemId": null, "menu_item_text": "L\u00f6schen", "tooltip": "Diesen Datensatz l\u00f6schen", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "L\u00f6schen", "auto_save": false }, { "itemId": "do_print", "menu_item_text": "Drucken", "must_save": true, "tooltip": "Drucken", "panel_btn_handler": Lino.row_action_handler('do_print','GET',null), "iconCls": "x-tbar-print", "overflowText": "Drucken", "auto_save": true }, { "itemId": "do_clear_cache", "menu_item_text": "Cache l\u00f6schen", "must_save": true, "tooltip": "Cache l\u00f6schen", "panel_btn_handler": Lino.row_action_handler('do_clear_cache','GET',null), "iconCls": "x-tbar-clearcache", "overflowText": "Cache l\u00f6schen", "auto_save": true }, { "itemId": "create_mail", "menu_item_text": "per E-Mail", "must_save": true, "tooltip": "Create an email from this", "panel_btn_handler": Lino.row_action_handler('create_mail','GET',null), "iconCls": "x-tbar-email_add", "overflowText": "per E-Mail", "auto_save": true } ],
  ls_url: "/cal/MyGuests",
  action_name: "detail",
  initComponent : function() {
    this.ls_detail_handler = Lino.cal.MyGuests.detail;
    this.ls_insert_handler = Lino.cal.MyGuests.insert;
    Lino.cal.MyGuests.detailPanel.superclass.initComponent.call(this);
  }
});

Lino.cal.MyGuests.detail = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.cal.MyGuests.detailPanel(p);
});
Lino.cal.MyGuests.do_print = function(rp,pk) { 
  Lino.run_row_action(rp,"/cal/MyGuests","GET",pk,"do_print",null);
};
Lino.cal.MyGuests.do_clear_cache = function(rp,pk) { 
  Lino.run_row_action(rp,"/cal/MyGuests","GET",pk,"do_clear_cache",null);
};
Lino.cal.MyGuests.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  p.params_panel = new Lino.cal.MyPresences.ParamsPanel({});
  return new Lino.cal.MyGuests.GridPanel(p);
});
Lino.cal.MyGuests.create_mail = function(rp,pk) { 
  Lino.run_row_action(rp,"/cal/MyGuests","GET",pk,"create_mail",null);
};
Lino.cal.MyGuests.receive = function(rp,pk) { 
  Lino.run_row_action(rp,"/cal/MyGuests","GET",pk,"receive",null);
};
Lino.cal.MyGuests.checkout = function(rp,pk) { 
  Lino.run_row_action(rp,"/cal/MyGuests","GET",pk,"checkout",null);
};

// js_render_GridPanel_class cal.PanelCalendars
Lino.cal.PanelCalendars.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "Keine Daten anzuzeigen." },
  ls_url : "/cal/PanelCalendars",
  ls_bbar_actions : [ { "itemId": "insert", "menu_item_text": "Neu", "must_save": true, "tooltip": "Neuen Datensatz erstellen", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-new", "overflowText": "Neu", "auto_save": true }, { "itemId": "duplicate", "menu_item_text": "Duplizieren", "must_save": true, "tooltip": "Duplizieren", "panel_btn_handler": Lino.row_action_handler('duplicate','GET',null), "iconCls": "x-tbar-duplicate", "overflowText": "Duplizieren", "auto_save": true }, { "itemId": "detail", "menu_item_text": "Detail", "tooltip": "Detail-Fenster auf diesem Datensatz \u00f6ffnen", "panel_btn_handler": Lino.show_detail, "iconCls": "x-tbar-detail", "overflowText": "Detail", "auto_save": true }, { "itemId": null, "menu_item_text": "L\u00f6schen", "tooltip": "Diesen Datensatz l\u00f6schen", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "L\u00f6schen", "auto_save": false }, { "itemId": "move_up", "menu_item_text": "Rauf", "must_save": true, "tooltip": "Move this row one row upwards", "panel_btn_handler": Lino.row_action_handler('move_up','GET',null), "iconCls": "x-tbar-moveup", "overflowText": "Rauf", "auto_save": true }, { "itemId": "move_down", "menu_item_text": "Down", "must_save": true, "tooltip": "Move this row one row downwards", "panel_btn_handler": Lino.row_action_handler('move_down','GET',null), "iconCls": "x-tbar-movedown", "overflowText": "Down", "auto_save": true } ],
  title : "Kalenderliste",
  page_length : 20,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "type": "int", "name": "id" }, { "name": "babel_name" }, { "name": "description" }, { "type": "int", "name": "color" }, { "type": "boolean", "name": "is_hidden" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 0,
  ls_grid_configs : [  ],
  content_type : 33,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 6,
  initComponent : function() {
    this.ls_detail_handler = Lino.cal.PanelCalendars.detail;
    this.ls_insert_handler = Lino.cal.PanelCalendars.insert;
    var ww = this.containing_window;
    var id4216 = new Ext.form.NumberField({ "selectOnFocus": true });
    var babel_name_disp4217 = new Ext.form.DisplayField({ "disabled": true, "value": "<br/>", "always_enabled": true });
    var description4218 = new Lino.RichTextPanel({ "selectOnFocus": true, "containing_panel": this, "title": "Beschreibung" });
    var color4219 = new Ext.form.NumberField({ "selectOnFocus": true, "allowBlank": false, "value": 1 });
    var is_hidden_disp4220 = new Ext.form.DisplayField({ "disabled": true, "value": "<br/>", "always_enabled": true });
    this.before_row_edit = function(record) {
      description4218.refresh();
    };
    this.ls_columns = [ new Lino.NullNumberColumn({ "colIndex": 0, "sortable": true, "format": "0", "editable": true, "tooltip": "(cal.PanelCalendars.id) ", "filter": { "type": "numeric" }, "header": "ID", "renderer": Lino.id_renderer, "editor": id4216, "width": Lino.chars2width(6), "dataIndex": "id" }), { "width": Lino.chars2width(31), "colIndex": 1, "sortable": false, "dataIndex": "babel_name", "header": "babel_name", "editable": false, "tooltip": "(cal.PanelCalendars.babel_name) " }, { "colIndex": 2, "sortable": false, "header": "description", "editable": true, "tooltip": "(cal.PanelCalendars.description) ", "filter": { "type": "string" }, "width": Lino.chars2width(61), "renderer": Lino.text_renderer, "editor": description4218, "dataIndex": "description" }, new Lino.NullNumberColumn({ "colIndex": 3, "sortable": true, "format": "0", "editable": true, "tooltip": "(cal.PanelCalendars.color) ", "filter": { "type": "numeric" }, "header": "Farbe", "dataIndex": "color", "width": Lino.chars2width(6), "editor": color4219 }), { "width": Lino.chars2width(31), "colIndex": 4, "sortable": false, "dataIndex": "is_hidden", "header": "versteckt", "editable": false, "tooltip": "(cal.PanelCalendars.is_hidden) " } ];
    Lino.cal.PanelCalendars.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.cal.PanelCalendars.put = function(rp,pk) { 
  Lino.run_row_action(rp,"/cal/PanelCalendars","GET",pk,"put",null);
};
Lino.cal.PanelCalendars.post = function(rp,pk) { 
  Lino.run_row_action(rp,"/cal/PanelCalendars","GET",pk,"post",null);
};

Lino.cal.PanelCalendars.insertPanel = Ext.extend(Lino.cal.PanelCalendars.InsertFormPanel,{
  empty_title: "Neu Kalenderliste",
  hide_navigator: true,
  ls_bbar_actions: [ { "itemId": "post", "menu_item_text": "Erstellen", "tooltip": "Datensatz erstellen und dann im Detail-Fenster \u00f6ffnen", "panel_btn_handler": function(panel){panel.save(null,true,'post')}, "text": "Erstellen", "overflowText": "Erstellen", "auto_save": false }, { "itemId": "poststay", "menu_item_text": "Erstellen ohne Detail", "tooltip": "Nach Erstellen des Datensatzes kein Detail-Fenster \u00f6ffnen", "panel_btn_handler": function(panel){panel.save(null,false,'poststay')}, "text": "Erstellen ohne Detail", "overflowText": "Erstellen ohne Detail", "auto_save": false } ],
  ls_url: "/cal/PanelCalendars",
  action_name: "insert",
  initComponent : function() {
    this.ls_detail_handler = Lino.cal.PanelCalendars.detail;
    this.ls_insert_handler = Lino.cal.PanelCalendars.insert;
    Lino.cal.PanelCalendars.insertPanel.superclass.initComponent.call(this);
  }
});

Lino.cal.PanelCalendars.insert = new Lino.WindowAction({ "draggable": true, "width": Lino.chars2width(60), "autoHeight": true, "maximizable": true, "modal": true, "maximized": false },function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.cal.PanelCalendars.insertPanel(p);
});
Lino.cal.PanelCalendars.poststay = function(rp,pk) { 
  Lino.run_row_action(rp,"/cal/PanelCalendars","GET",pk,"poststay",null);
};
Lino.cal.PanelCalendars.duplicate = function(rp,pk) { 
  Lino.run_row_action(rp,"/cal/PanelCalendars","GET",pk,"duplicate",null);
};

Lino.cal.PanelCalendars.detailPanel = Ext.extend(Lino.cal.PanelCalendars.DetailFormPanel,{
  empty_title: "Detail Kalenderliste",
  ls_bbar_actions: [ { "itemId": "put", "menu_item_text": "Speichern", "tooltip": "\u00c4nderungen in diesem Formular speichern", "panel_btn_handler": function(panel){panel.save(null,false,'put')}, "iconCls": "x-tbar-save", "overflowText": "Speichern", "auto_save": false }, { "itemId": "insert", "menu_item_text": "Neu", "must_save": true, "tooltip": "Neuen Datensatz erstellen", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-new", "overflowText": "Neu", "auto_save": true }, { "itemId": "duplicate", "menu_item_text": "Duplizieren", "must_save": true, "tooltip": "Duplizieren", "panel_btn_handler": Lino.row_action_handler('duplicate','GET',null), "iconCls": "x-tbar-duplicate", "overflowText": "Duplizieren", "auto_save": true }, { "itemId": null, "menu_item_text": "L\u00f6schen", "tooltip": "Diesen Datensatz l\u00f6schen", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "L\u00f6schen", "auto_save": false }, { "itemId": "move_up", "menu_item_text": "Rauf", "must_save": true, "tooltip": "Move this row one row upwards", "panel_btn_handler": Lino.row_action_handler('move_up','GET',null), "iconCls": "x-tbar-moveup", "overflowText": "Rauf", "auto_save": true }, { "itemId": "move_down", "menu_item_text": "Down", "must_save": true, "tooltip": "Move this row one row downwards", "panel_btn_handler": Lino.row_action_handler('move_down','GET',null), "iconCls": "x-tbar-movedown", "overflowText": "Down", "auto_save": true } ],
  ls_url: "/cal/PanelCalendars",
  action_name: "detail",
  initComponent : function() {
    this.ls_detail_handler = Lino.cal.PanelCalendars.detail;
    this.ls_insert_handler = Lino.cal.PanelCalendars.insert;
    Lino.cal.PanelCalendars.detailPanel.superclass.initComponent.call(this);
  }
});

Lino.cal.PanelCalendars.detail = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.cal.PanelCalendars.detailPanel(p);
});
Lino.cal.PanelCalendars.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.cal.PanelCalendars.GridPanel(p);
});
Lino.cal.PanelCalendars.move_up = function(rp,pk) { 
  Lino.run_row_action(rp,"/cal/PanelCalendars","GET",pk,"move_up",null);
};
Lino.cal.PanelCalendars.move_down = function(rp,pk) { 
  Lino.run_row_action(rp,"/cal/PanelCalendars","GET",pk,"move_down",null);
};

// js_render_GridPanel_class cal.PanelEvents
Lino.cal.PanelEvents.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "Keine Daten anzuzeigen." },
  ls_url : "/cal/PanelEvents",
  ls_bbar_actions : [ { "itemId": "insert", "menu_item_text": "Neu", "must_save": true, "tooltip": "Neuen Datensatz erstellen", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-new", "overflowText": "Neu", "auto_save": true }, { "itemId": "duplicate", "menu_item_text": "Duplizieren", "must_save": true, "tooltip": "Duplizieren", "panel_btn_handler": Lino.row_action_handler('duplicate','GET',null), "iconCls": "x-tbar-duplicate", "overflowText": "Duplizieren", "auto_save": true }, { "itemId": "detail", "menu_item_text": "Detail", "tooltip": "Detail-Fenster auf diesem Datensatz \u00f6ffnen", "panel_btn_handler": Lino.show_detail, "iconCls": "x-tbar-detail", "overflowText": "Detail", "auto_save": true }, { "itemId": null, "menu_item_text": "L\u00f6schen", "tooltip": "Diesen Datensatz l\u00f6schen", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "L\u00f6schen", "auto_save": false }, { "itemId": "do_print", "menu_item_text": "Drucken", "must_save": true, "tooltip": "Drucken", "panel_btn_handler": Lino.row_action_handler('do_print','GET',null), "iconCls": "x-tbar-print", "overflowText": "Drucken", "auto_save": true }, { "itemId": "do_clear_cache", "menu_item_text": "Cache l\u00f6schen", "must_save": true, "tooltip": "Cache l\u00f6schen", "panel_btn_handler": Lino.row_action_handler('do_clear_cache','GET',null), "iconCls": "x-tbar-clearcache", "overflowText": "Cache l\u00f6schen", "auto_save": true }, { "itemId": "create_mail", "menu_item_text": "per E-Mail", "must_save": true, "tooltip": "Create an email from this", "panel_btn_handler": Lino.row_action_handler('create_mail','GET',null), "iconCls": "x-tbar-email_add", "overflowText": "per E-Mail", "auto_save": true } ],
  title : "Termine",
  page_length : 20,
  params_panel_hidden : true,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "type": "int", "name": "id" }, { "name": "start_dt" }, { "name": "end_dt" }, { "name": "summary" }, { "name": "description" }, { "name": "user" }, 'userHidden', { "name": "room" }, 'roomHidden', { "name": "calendar" }, 'calendarHidden', { "name": "url" }, { "type": "boolean", "name": "all_day" }, { "name": "reminder" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 0,
  ls_grid_configs : [  ],
  content_type : 35,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 15,
  initComponent : function() {
    this.ls_detail_handler = Lino.cal.PanelEvents.detail;
    this.ls_insert_handler = Lino.cal.PanelEvents.insert;
    var ww = this.containing_window;
    var id4222 = new Ext.form.NumberField({ "selectOnFocus": true });
    var start_dt4223 = new Ext.form.DisplayField({ "disabled": true, "value": "<br>" });
    var end_dt4224 = new Ext.form.DisplayField({ "disabled": true, "value": "<br>" });
    var summary4225 = new Ext.form.TextField({ "disabled": true, "maxLength": null });
    var description4226 = new Lino.RichTextPanel({ "selectOnFocus": true, "containing_panel": this, "title": "Beschreibung" });
    var user4227 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "preferred_width": 15, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/PanelEvents/user", "method": "GET" }) }), "pageSize": 20, "emptyText": "Benutzer ausw\u00e4hlen..." });
    var room4228 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/PanelEvents/room", "method": "GET" }) }), "pageSize": 20, "emptyText": "Raum ausw\u00e4hlen..." });
    var calendar4229 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/PanelEvents/calendar", "method": "GET" }) }), "pageSize": 20, "emptyText": "Kalender ausw\u00e4hlen..." });
    var url_disp4230 = new Ext.form.DisplayField({ "disabled": true, "value": "<br/>", "always_enabled": true });
    var all_day4231 = new Ext.form.Checkbox({ "disabled": true });
    var reminder_disp4232 = new Ext.form.DisplayField({ "disabled": true, "value": "<br/>", "always_enabled": true });
    this.before_row_edit = function(record) {
      description4226.refresh();
    };
    this.ls_columns = [ new Lino.NullNumberColumn({ "colIndex": 0, "sortable": true, "format": "0", "editable": true, "tooltip": "(cal.PanelEvents.id) ", "filter": { "type": "numeric" }, "header": "ID", "renderer": Lino.id_renderer, "editor": id4222, "width": Lino.chars2width(6), "dataIndex": "id" }), { "width": Lino.chars2width(17), "colIndex": 1, "sortable": false, "dataIndex": "start_dt", "header": "Beginn", "editable": false, "tooltip": "(cal.PanelEvents.start_dt) " }, { "width": Lino.chars2width(17), "colIndex": 2, "sortable": false, "dataIndex": "end_dt", "header": "Ende", "editable": false, "tooltip": "(cal.PanelEvents.end_dt) " }, { "width": Lino.chars2width(5), "colIndex": 3, "sortable": false, "dataIndex": "summary", "header": "Kurzbeschreibung", "editable": false, "tooltip": "(cal.PanelEvents.summary) " }, { "colIndex": 4, "sortable": false, "width": Lino.chars2width(61), "editable": true, "tooltip": "(cal.PanelEvents.description) ", "filter": { "type": "string" }, "header": "description", "renderer": Lino.text_renderer, "hidden": true, "editor": description4226, "dataIndex": "description" }, { "colIndex": 5, "sortable": true, "header": "Verantwortlicher", "editable": true, "tooltip": "(cal.PanelEvents.user) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "user", "editor": user4227 }, { "colIndex": 6, "sortable": true, "header": "Raum", "editable": true, "tooltip": "(cal.PanelEvents.room) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "room", "editor": room4228 }, { "colIndex": 7, "sortable": true, "header": "Kalender", "editable": true, "tooltip": "(cal.PanelEvents.calendar) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "calendar", "editor": calendar4229 }, { "width": Lino.chars2width(31), "colIndex": 8, "sortable": false, "dataIndex": "url", "header": "Link URL", "editable": false, "tooltip": "(cal.PanelEvents.url) " }, { "colIndex": 9, "sortable": false, "xtype": "checkcolumn", "width": Lino.chars2width(11), "editable": false, "tooltip": "(cal.PanelEvents.all_day) ", "header": "ganztags", "dataIndex": "all_day" }, { "width": Lino.chars2width(31), "colIndex": 10, "sortable": false, "dataIndex": "reminder", "header": "Erinnerung", "editable": false, "tooltip": "(cal.PanelEvents.reminder) " } ];
    Lino.cal.PanelEvents.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.cal.PanelEvents.put = function(rp,pk) { 
  Lino.run_row_action(rp,"/cal/PanelEvents","GET",pk,"put",null);
};
Lino.cal.PanelEvents.post = function(rp,pk) { 
  Lino.run_row_action(rp,"/cal/PanelEvents","GET",pk,"post",null);
};

Lino.cal.PanelEvents.insertPanel = Ext.extend(Lino.cal.OneEvent.InsertFormPanel,{
  empty_title: "Neu Termine",
  hide_navigator: true,
  params_panel_hidden: true,
  ls_bbar_actions: [ { "itemId": "post", "menu_item_text": "Erstellen", "tooltip": "Datensatz erstellen und dann im Detail-Fenster \u00f6ffnen", "panel_btn_handler": function(panel){panel.save(null,true,'post')}, "text": "Erstellen", "overflowText": "Erstellen", "auto_save": false }, { "itemId": "poststay", "menu_item_text": "Erstellen ohne Detail", "tooltip": "Nach Erstellen des Datensatzes kein Detail-Fenster \u00f6ffnen", "panel_btn_handler": function(panel){panel.save(null,false,'poststay')}, "text": "Erstellen ohne Detail", "overflowText": "Erstellen ohne Detail", "auto_save": false } ],
  ls_url: "/cal/PanelEvents",
  action_name: "insert",
  initComponent : function() {
    this.ls_detail_handler = Lino.cal.PanelEvents.detail;
    this.ls_insert_handler = Lino.cal.PanelEvents.insert;
    Lino.cal.PanelEvents.insertPanel.superclass.initComponent.call(this);
  }
});

Lino.cal.PanelEvents.insert = new Lino.WindowAction({ "draggable": true, "width": Lino.chars2width(60), "autoHeight": true, "maximizable": true, "modal": true, "maximized": false },function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.cal.PanelEvents.insertPanel(p);
});
Lino.cal.PanelEvents.wf1 = function(rp,pk) { 
  Lino.run_row_action(rp,"/cal/PanelEvents","GET",pk,"wf1",null);
};
Lino.cal.PanelEvents.poststay = function(rp,pk) { 
  Lino.run_row_action(rp,"/cal/PanelEvents","GET",pk,"poststay",null);
};
Lino.cal.PanelEvents.duplicate = function(rp,pk) { 
  Lino.run_row_action(rp,"/cal/PanelEvents","GET",pk,"duplicate",null);
};
Lino.cal.PanelEvents.wf2 = function(rp,pk) { 
  Lino.run_row_action(rp,"/cal/PanelEvents","GET",pk,"wf2",null);
};
Lino.cal.PanelEvents.wf3 = function(rp,pk) { 
  Lino.run_row_action(rp,"/cal/PanelEvents","GET",pk,"wf3",null);
};
Lino.cal.PanelEvents.wf4 = function(rp,pk) { 
  Lino.run_row_action(rp,"/cal/PanelEvents","GET",pk,"wf4",null);
};

Lino.cal.PanelEvents.detailPanel = Ext.extend(Lino.cal.OneEvent.DetailFormPanel,{
  empty_title: "Detail Termine",
  params_panel_hidden: true,
  ls_bbar_actions: [ { "itemId": "put", "menu_item_text": "Speichern", "tooltip": "\u00c4nderungen in diesem Formular speichern", "panel_btn_handler": function(panel){panel.save(null,false,'put')}, "iconCls": "x-tbar-save", "overflowText": "Speichern", "auto_save": false }, { "itemId": "insert", "menu_item_text": "Neu", "must_save": true, "tooltip": "Neuen Datensatz erstellen", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-new", "overflowText": "Neu", "auto_save": true }, { "itemId": "duplicate", "menu_item_text": "Duplizieren", "must_save": true, "tooltip": "Duplizieren", "panel_btn_handler": Lino.row_action_handler('duplicate','GET',null), "iconCls": "x-tbar-duplicate", "overflowText": "Duplizieren", "auto_save": true }, { "itemId": null, "menu_item_text": "L\u00f6schen", "tooltip": "Diesen Datensatz l\u00f6schen", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "L\u00f6schen", "auto_save": false }, { "itemId": "do_print", "menu_item_text": "Drucken", "must_save": true, "tooltip": "Drucken", "panel_btn_handler": Lino.row_action_handler('do_print','GET',null), "iconCls": "x-tbar-print", "overflowText": "Drucken", "auto_save": true }, { "itemId": "do_clear_cache", "menu_item_text": "Cache l\u00f6schen", "must_save": true, "tooltip": "Cache l\u00f6schen", "panel_btn_handler": Lino.row_action_handler('do_clear_cache','GET',null), "iconCls": "x-tbar-clearcache", "overflowText": "Cache l\u00f6schen", "auto_save": true }, { "itemId": "create_mail", "menu_item_text": "per E-Mail", "must_save": true, "tooltip": "Create an email from this", "panel_btn_handler": Lino.row_action_handler('create_mail','GET',null), "iconCls": "x-tbar-email_add", "overflowText": "per E-Mail", "auto_save": true } ],
  ls_url: "/cal/PanelEvents",
  action_name: "detail",
  initComponent : function() {
    this.ls_detail_handler = Lino.cal.PanelEvents.detail;
    this.ls_insert_handler = Lino.cal.PanelEvents.insert;
    Lino.cal.PanelEvents.detailPanel.superclass.initComponent.call(this);
  }
});

Lino.cal.PanelEvents.detail = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.cal.PanelEvents.detailPanel(p);
});
Lino.cal.PanelEvents.do_print = function(rp,pk) { 
  Lino.run_row_action(rp,"/cal/PanelEvents","GET",pk,"do_print",null);
};
Lino.cal.PanelEvents.do_clear_cache = function(rp,pk) { 
  Lino.run_row_action(rp,"/cal/PanelEvents","GET",pk,"do_clear_cache",null);
};
Lino.cal.PanelEvents.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  p.params_panel = new Lino.cal.OneEvent.ParamsPanel({});
  return new Lino.cal.PanelEvents.GridPanel(p);
});
Lino.cal.PanelEvents.take = function(rp,pk) { 
  Lino.run_row_action(rp,"/cal/PanelEvents","GET",pk,"take",null);
};
Lino.cal.PanelEvents.create_mail = function(rp,pk) { 
  Lino.run_row_action(rp,"/cal/PanelEvents","GET",pk,"create_mail",null);
};

// js_render_GridPanel_class households.Households
Lino.households.Households.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "Keine Daten anzuzeigen." },
  ls_url : "/households/Households",
  ls_bbar_actions : [ { "itemId": "insert", "menu_item_text": "Neu", "must_save": true, "tooltip": "Neuen Datensatz erstellen", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-new", "overflowText": "Neu", "auto_save": true }, { "itemId": "detail", "menu_item_text": "Detail", "tooltip": "Detail-Fenster auf diesem Datensatz \u00f6ffnen", "panel_btn_handler": Lino.show_detail, "iconCls": "x-tbar-detail", "overflowText": "Detail", "auto_save": true }, { "itemId": null, "menu_item_text": "L\u00f6schen", "tooltip": "Diesen Datensatz l\u00f6schen", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "L\u00f6schen", "auto_save": false } ],
  title : "Haushalte",
  page_length : 20,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "name": "name" }, { "name": "email" }, { "name": "created" }, { "name": "modified" }, { "name": "country" }, 'countryHidden', { "name": "city" }, 'cityHidden', { "name": "region" }, 'regionHidden', { "name": "zip_code" }, { "name": "addr1" }, { "name": "street_prefix" }, { "name": "street" }, { "name": "street_no" }, { "name": "street_box" }, { "name": "addr2" }, { "name": "language" }, 'languageHidden', { "name": "url" }, { "name": "phone" }, { "name": "gsm" }, { "name": "fax" }, { "name": "remarks" }, { "type": "boolean", "name": "is_obsolete" }, { "name": "activity" }, 'activityHidden', { "name": "bank_account1" }, { "name": "bank_account2" }, { "name": "prefix" }, { "name": "type" }, 'typeHidden', { "type": "int", "name": "id" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 32,
  ls_grid_configs : [  ],
  content_type : 39,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 34,
  initComponent : function() {
    this.ls_detail_handler = Lino.households.Households.detail;
    this.ls_insert_handler = Lino.households.Households.insert;
    var ww = this.containing_window;
    var name4256 = new Ext.form.TextField({ "selectOnFocus": true, "allowBlank": false, "maxLength": 200 });
    var email4257 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 75 });
    var created4258 = new Ext.form.DisplayField({ "disabled": true, "value": "<br>" });
    var modified4259 = new Ext.form.DisplayField({ "disabled": true, "value": "<br>" });
    var country4260 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/households/Households/country", "method": "GET" }) }), "pageSize": 20, "emptyText": "Land ausw\u00e4hlen..." });
    var city4261 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "forceSelection": false, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/households/Households/city", "method": "GET" }) }), "pageSize": 20, "emptyText": "Ort ausw\u00e4hlen..." });
    var region4262 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/households/Households/region", "method": "GET" }) }), "pageSize": 20, "emptyText": "Ort ausw\u00e4hlen..." });
    var zip_code4263 = new Ext.form.TextField({ "selectOnFocus": true, "boxMinWidth": Lino.chars2width(10), "maxLength": 10 });
    var addr14264 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var street_prefix4265 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var street4266 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var street_no4267 = new Ext.form.TextField({ "selectOnFocus": true, "boxMinWidth": Lino.chars2width(10), "maxLength": 10 });
    var street_box4268 = new Ext.form.TextField({ "selectOnFocus": true, "boxMinWidth": Lino.chars2width(10), "maxLength": 10 });
    var addr24269 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var language4270 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "allowBlank": false, "store": [ [ "en", "Englisch" ], [ "fr", "Franz\u00f6sisch" ], [ "de", "Deutsch" ], [ "nl", "Niederl\u00e4ndisch" ] ] });
    var url4271 = new Lino.URLField({ "selectOnFocus": true, "maxLength": 200 });
    var phone4272 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var gsm4273 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var fax4274 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var remarks4275 = new Ext.form.TextArea({ "selectOnFocus": true, "growMax": 2000 });
    var is_obsolete4276 = new Ext.form.Checkbox({ "selectOnFocus": true, "checked": false });
    var activity4277 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/households/Households/activity", "method": "GET" }) }), "pageSize": 20, "emptyText": "Beruf ausw\u00e4hlen..." });
    var bank_account14278 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 40 });
    var bank_account24279 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 40 });
    var prefix4280 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var type4281 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/households/Households/type", "method": "GET" }) }), "pageSize": 20, "emptyText": "Haushaltsart ausw\u00e4hlen..." });
    var id4282 = new Ext.form.NumberField({ "selectOnFocus": true });
    this.before_row_edit = function(record) {
      city4261.setContextValue('country',record ? record.data['countryHidden'] : undefined);
      city4261.setContextValue('region',record ? record.data['regionHidden'] : undefined);
      region4262.setContextValue('country',record ? record.data['countryHidden'] : undefined);
    };
    this.onRender = function(ct, position) {
      country4260.on('change',Lino.chooser_handler(city4261,'country'));
      region4262.on('change',Lino.chooser_handler(city4261,'region'));
      country4260.on('change',Lino.chooser_handler(region4262,'country'));
      Lino.households.Households.GridPanel.superclass.onRender.call(this, ct, position);
    }
    this.ls_columns = [ { "colIndex": 0, "sortable": true, "header": "Name", "editable": true, "tooltip": "(households.Households.name) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "name", "editor": name4256 }, { "colIndex": 1, "sortable": true, "header": "E-Mail", "editable": true, "tooltip": "(households.Households.email) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "email", "editor": email4257 }, { "colIndex": 2, "sortable": true, "header": "Erstellt", "editable": false, "tooltip": "(households.Households.created) ", "width": Lino.chars2width(17), "dataIndex": "created", "hidden": true }, { "colIndex": 3, "sortable": true, "header": "Bearbeitet", "editable": false, "tooltip": "(households.Households.modified) ", "width": Lino.chars2width(17), "dataIndex": "modified", "hidden": true }, { "colIndex": 4, "sortable": true, "header": "Land", "editable": true, "tooltip": "(households.Households.country) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('countryHidden','Lino.countries.Countries.detail'), "editor": country4260, "dataIndex": "country" }, { "colIndex": 5, "sortable": true, "header": "Ort", "editable": true, "tooltip": "(households.Households.city) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "city", "editor": city4261 }, { "colIndex": 6, "sortable": true, "header": "Region", "editable": true, "tooltip": "(households.Households.region) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "region", "editor": region4262 }, { "colIndex": 7, "sortable": true, "header": "Postleitzahl", "editable": true, "tooltip": "(households.Households.zip_code) ", "filter": { "type": "string" }, "width": Lino.chars2width(12), "dataIndex": "zip_code", "editor": zip_code4263 }, { "colIndex": 8, "sortable": true, "header": "Adresszeile vor Stra\u00dfe", "editable": true, "tooltip": "(households.Households.addr1) Address line before street", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "addr1", "editor": addr14264 }, { "colIndex": 9, "sortable": true, "header": "Pr\u00e4fix Stra\u00dfe", "editable": true, "tooltip": "(households.Households.street_prefix) Text to print before name of street, but to ignore for sorting.", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "street_prefix", "editor": street_prefix4265 }, { "colIndex": 10, "sortable": true, "header": "Stra\u00dfe", "editable": true, "tooltip": "(households.Households.street) Name of street. Without house number.", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "street", "editor": street4266 }, { "colIndex": 11, "sortable": true, "header": "Nr.", "editable": true, "tooltip": "(households.Households.street_no) House number", "filter": { "type": "string" }, "width": Lino.chars2width(12), "dataIndex": "street_no", "editor": street_no4267 }, { "colIndex": 12, "sortable": true, "header": "Box", "editable": true, "tooltip": "(households.Households.street_box) Text to print after :attr:`steet_no` on the same line", "filter": { "type": "string" }, "width": Lino.chars2width(12), "dataIndex": "street_box", "editor": street_box4268 }, { "colIndex": 13, "sortable": true, "header": "Adresszeile nach Stra\u00dfe", "editable": true, "tooltip": "(households.Households.addr2) Address line to print below street line", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "addr2", "editor": addr24269 }, { "colIndex": 14, "sortable": true, "header": "Sprache", "editable": true, "tooltip": "(households.Households.language) Die Sprache, in der Dokumente ausgestellt werden sollen.", "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "language", "editor": language4270 }, { "colIndex": 15, "sortable": true, "header": "URL", "editable": true, "tooltip": "(households.Households.url) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "url", "editor": url4271 }, { "colIndex": 16, "sortable": true, "header": "Telefon", "editable": true, "tooltip": "(households.Households.phone) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "phone", "editor": phone4272 }, { "colIndex": 17, "sortable": true, "header": "GSM", "editable": true, "tooltip": "(households.Households.gsm) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "gsm", "editor": gsm4273 }, { "colIndex": 18, "sortable": true, "header": "Fax", "editable": true, "tooltip": "(households.Households.fax) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "fax", "editor": fax4274 }, { "colIndex": 19, "sortable": false, "header": "Bemerkungen", "editable": true, "tooltip": "(households.Households.remarks) ", "filter": { "type": "string" }, "width": Lino.chars2width(61), "renderer": Lino.text_renderer, "editor": remarks4275, "dataIndex": "remarks" }, { "colIndex": 20, "sortable": false, "xtype": "checkcolumn", "header": "veraltet", "editable": true, "tooltip": "(households.Households.is_obsolete) Altf\u00e4lle sind Partner, deren Stammdaten nicht mehr gepflegt werden und \nf\u00fcr neue Operationen nicht benutzt werden k\u00f6nnen.", "filter": { "type": "boolean" }, "width": Lino.chars2width(11), "dataIndex": "is_obsolete" }, { "colIndex": 21, "sortable": true, "header": "Beruf", "editable": true, "tooltip": "(households.Households.activity) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "activity", "hidden": true, "editor": activity4277 }, { "colIndex": 22, "sortable": true, "header": "Bankkonto 1", "editable": true, "tooltip": "(households.Households.bank_account1) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "bank_account1", "hidden": true, "editor": bank_account14278 }, { "colIndex": 23, "sortable": true, "header": "Bankkonto 2", "editable": true, "tooltip": "(households.Households.bank_account2) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "bank_account2", "hidden": true, "editor": bank_account24279 }, { "colIndex": 24, "sortable": true, "header": "prefix", "editable": true, "tooltip": "(households.Households.prefix) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "prefix", "editor": prefix4280 }, { "colIndex": 25, "sortable": true, "header": "Haushaltsart", "editable": true, "tooltip": "(households.Households.type) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "type", "editor": type4281 }, new Lino.NullNumberColumn({ "colIndex": 26, "sortable": true, "format": "0", "editable": true, "tooltip": "(households.Households.id) ", "filter": { "type": "numeric" }, "header": "ID", "renderer": Lino.id_renderer, "editor": id4282, "width": Lino.chars2width(6), "dataIndex": "id" }) ];
    Lino.households.Households.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.households.Households.put = function(rp,pk) { 
  Lino.run_row_action(rp,"/households/Households","GET",pk,"put",null);
};
Lino.households.Households.post = function(rp,pk) { 
  Lino.run_row_action(rp,"/households/Households","GET",pk,"post",null);
};

Lino.households.Households.insertPanel = Ext.extend(Lino.contacts.Partners.InsertFormPanel,{
  empty_title: "Neu Haushalte",
  hide_navigator: true,
  ls_bbar_actions: [ { "itemId": "post", "menu_item_text": "Erstellen", "tooltip": "Datensatz erstellen und dann im Detail-Fenster \u00f6ffnen", "panel_btn_handler": function(panel){panel.save(null,true,'post')}, "text": "Erstellen", "overflowText": "Erstellen", "auto_save": false }, { "itemId": "poststay", "menu_item_text": "Erstellen ohne Detail", "tooltip": "Nach Erstellen des Datensatzes kein Detail-Fenster \u00f6ffnen", "panel_btn_handler": function(panel){panel.save(null,false,'poststay')}, "text": "Erstellen ohne Detail", "overflowText": "Erstellen ohne Detail", "auto_save": false } ],
  ls_url: "/households/Households",
  action_name: "insert",
  initComponent : function() {
    this.ls_detail_handler = Lino.households.Households.detail;
    this.ls_insert_handler = Lino.households.Households.insert;
    Lino.households.Households.insertPanel.superclass.initComponent.call(this);
  }
});

Lino.households.Households.insert = new Lino.WindowAction({ "draggable": true, "width": Lino.chars2width(40), "autoHeight": true, "maximizable": true, "modal": true, "maximized": false },function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.households.Households.insertPanel(p);
});
Lino.households.Households.poststay = function(rp,pk) { 
  Lino.run_row_action(rp,"/households/Households","GET",pk,"poststay",null);
};

Lino.households.Households.detailPanel = Ext.extend(Lino.households.Households.DetailFormPanel,{
  empty_title: "Detail Haushalte",
  ls_bbar_actions: [ { "itemId": "put", "menu_item_text": "Speichern", "tooltip": "\u00c4nderungen in diesem Formular speichern", "panel_btn_handler": function(panel){panel.save(null,false,'put')}, "iconCls": "x-tbar-save", "overflowText": "Speichern", "auto_save": false }, { "itemId": "insert", "menu_item_text": "Neu", "must_save": true, "tooltip": "Neuen Datensatz erstellen", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-new", "overflowText": "Neu", "auto_save": true }, { "itemId": null, "menu_item_text": "L\u00f6schen", "tooltip": "Diesen Datensatz l\u00f6schen", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "L\u00f6schen", "auto_save": false } ],
  ls_url: "/households/Households",
  action_name: "detail",
  initComponent : function() {
    this.ls_detail_handler = Lino.households.Households.detail;
    this.ls_insert_handler = Lino.households.Households.insert;
    Lino.households.Households.detailPanel.superclass.initComponent.call(this);
  }
});

Lino.households.Households.detail = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.households.Households.detailPanel(p);
});
Lino.households.Households.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.households.Households.GridPanel(p);
});

// js_render_GridPanel_class reception.MyWaitingGuests
Lino.reception.MyWaitingGuests.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "forceFit": true, "emptyText": "Keine Daten anzuzeigen." },
  ls_url : "/reception/MyWaitingGuests",
  ls_bbar_actions : [ { "itemId": "insert", "menu_item_text": "Neu", "must_save": true, "tooltip": "Neuen Datensatz erstellen", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-new", "overflowText": "Neu", "auto_save": true }, { "itemId": "duplicate", "menu_item_text": "Duplizieren", "must_save": true, "tooltip": "Duplizieren", "panel_btn_handler": Lino.row_action_handler('duplicate','GET',null), "iconCls": "x-tbar-duplicate", "overflowText": "Duplizieren", "auto_save": true }, { "itemId": "detail", "menu_item_text": "Detail", "tooltip": "Detail-Fenster auf diesem Datensatz \u00f6ffnen", "panel_btn_handler": Lino.show_detail, "iconCls": "x-tbar-detail", "overflowText": "Detail", "auto_save": true }, { "itemId": null, "menu_item_text": "L\u00f6schen", "tooltip": "Diesen Datensatz l\u00f6schen", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "L\u00f6schen", "auto_save": false }, { "itemId": "do_print", "menu_item_text": "Drucken", "must_save": true, "tooltip": "Drucken", "panel_btn_handler": Lino.row_action_handler('do_print','GET',null), "iconCls": "x-tbar-print", "overflowText": "Drucken", "auto_save": true }, { "itemId": "do_clear_cache", "menu_item_text": "Cache l\u00f6schen", "must_save": true, "tooltip": "Cache l\u00f6schen", "panel_btn_handler": Lino.row_action_handler('do_clear_cache','GET',null), "iconCls": "x-tbar-clearcache", "overflowText": "Cache l\u00f6schen", "auto_save": true }, { "itemId": "create_mail", "menu_item_text": "per E-Mail", "must_save": true, "tooltip": "Create an email from this", "panel_btn_handler": Lino.row_action_handler('create_mail','GET',null), "iconCls": "x-tbar-email_add", "overflowText": "per E-Mail", "auto_save": true } ],
  title : "Wartende Besucher",
  page_length : 20,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "name": "since" }, { "name": "client" }, 'clientHidden', { "name": "event__summary" }, { "name": "workflow_buttons" }, { "type": "int", "name": "id" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 5,
  ls_grid_configs : [  ],
  content_type : 36,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 7,
  initComponent : function() {
    this.ls_detail_handler = Lino.reception.MyWaitingGuests.detail;
    this.ls_insert_handler = Lino.reception.MyWaitingGuests.insert;
    var ww = this.containing_window;
    var since_disp4311 = new Ext.form.DisplayField({ "disabled": true, "value": "<br/>", "always_enabled": true });
    var client4312 = new Lino.RemoteComboFieldElement({ "disabled": true, "preferred_width": 20, "store": new Lino.ComplexRemoteComboStore({  }), "pageSize": 20, "emptyText": "Klient ausw\u00e4hlen..." });
    var event__summary4313 = new Ext.form.TextField({ "disabled": true, "maxLength": 200 });
    var workflow_buttons_disp4314 = new Ext.form.DisplayField({ "disabled": true, "value": "<br/>", "always_enabled": true });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ { "width": Lino.chars2width(31), "colIndex": 0, "sortable": false, "dataIndex": "since", "header": "Seit", "editable": false, "tooltip": "(reception.MyWaitingGuests.since) " }, { "colIndex": 1, "sortable": false, "header": "Klient", "editable": false, "tooltip": "(reception.MyWaitingGuests.client) ", "width": Lino.chars2width(21), "dataIndex": "client", "renderer": Lino.fk_renderer('clientHidden','Lino.pcsw.Clients.detail') }, { "colIndex": 2, "sortable": true, "header": "Kurzbeschreibung", "editable": false, "tooltip": "(reception.MyWaitingGuests.event__summary) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "event__summary" }, { "width": Lino.chars2width(31), "colIndex": 3, "sortable": false, "dataIndex": "workflow_buttons", "header": "Arbeitsablauf", "editable": false, "tooltip": "(reception.MyWaitingGuests.workflow_buttons) " } ];
    Lino.reception.MyWaitingGuests.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.reception.MyWaitingGuests.put = function(rp,pk) { 
  Lino.run_row_action(rp,"/reception/MyWaitingGuests","GET",pk,"put",null);
};
Lino.reception.MyWaitingGuests.post = function(rp,pk) { 
  Lino.run_row_action(rp,"/reception/MyWaitingGuests","GET",pk,"post",null);
};

Lino.reception.MyWaitingGuests.insertPanel = Ext.extend(Lino.cal.MyPresences.InsertFormPanel,{
  empty_title: "Neu Wartende Besucher",
  hide_navigator: true,
  ls_bbar_actions: [ { "itemId": "post", "menu_item_text": "Erstellen", "tooltip": "Datensatz erstellen und dann im Detail-Fenster \u00f6ffnen", "panel_btn_handler": function(panel){panel.save(null,true,'post')}, "text": "Erstellen", "overflowText": "Erstellen", "auto_save": false }, { "itemId": "poststay", "menu_item_text": "Erstellen ohne Detail", "tooltip": "Nach Erstellen des Datensatzes kein Detail-Fenster \u00f6ffnen", "panel_btn_handler": function(panel){panel.save(null,false,'poststay')}, "text": "Erstellen ohne Detail", "overflowText": "Erstellen ohne Detail", "auto_save": false } ],
  ls_url: "/reception/MyWaitingGuests",
  action_name: "insert",
  initComponent : function() {
    this.ls_detail_handler = Lino.reception.MyWaitingGuests.detail;
    this.ls_insert_handler = Lino.reception.MyWaitingGuests.insert;
    Lino.reception.MyWaitingGuests.insertPanel.superclass.initComponent.call(this);
  }
});

Lino.reception.MyWaitingGuests.insert = new Lino.WindowAction({ "draggable": true, "width": Lino.chars2width(60), "autoHeight": true, "maximizable": true, "modal": true, "maximized": false },function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.reception.MyWaitingGuests.insertPanel(p);
});
Lino.reception.MyWaitingGuests.poststay = function(rp,pk) { 
  Lino.run_row_action(rp,"/reception/MyWaitingGuests","GET",pk,"poststay",null);
};
Lino.reception.MyWaitingGuests.duplicate = function(rp,pk) { 
  Lino.run_row_action(rp,"/reception/MyWaitingGuests","GET",pk,"duplicate",null);
};
Lino.reception.MyWaitingGuests.wf3 = function(rp,pk) { 
  Lino.run_row_action(rp,"/reception/MyWaitingGuests","GET",pk,"wf3",null);
};
Lino.reception.MyWaitingGuests.wf4 = function(rp,pk) { 
  Lino.run_row_action(rp,"/reception/MyWaitingGuests","GET",pk,"wf4",null);
};

Lino.reception.MyWaitingGuests.detailPanel = Ext.extend(Lino.cal.MyPresences.DetailFormPanel,{
  empty_title: "Detail Wartende Besucher",
  ls_bbar_actions: [ { "itemId": "put", "menu_item_text": "Speichern", "tooltip": "\u00c4nderungen in diesem Formular speichern", "panel_btn_handler": function(panel){panel.save(null,false,'put')}, "iconCls": "x-tbar-save", "overflowText": "Speichern", "auto_save": false }, { "itemId": "insert", "menu_item_text": "Neu", "must_save": true, "tooltip": "Neuen Datensatz erstellen", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-new", "overflowText": "Neu", "auto_save": true }, { "itemId": "duplicate", "menu_item_text": "Duplizieren", "must_save": true, "tooltip": "Duplizieren", "panel_btn_handler": Lino.row_action_handler('duplicate','GET',null), "iconCls": "x-tbar-duplicate", "overflowText": "Duplizieren", "auto_save": true }, { "itemId": null, "menu_item_text": "L\u00f6schen", "tooltip": "Diesen Datensatz l\u00f6schen", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "L\u00f6schen", "auto_save": false }, { "itemId": "do_print", "menu_item_text": "Drucken", "must_save": true, "tooltip": "Drucken", "panel_btn_handler": Lino.row_action_handler('do_print','GET',null), "iconCls": "x-tbar-print", "overflowText": "Drucken", "auto_save": true }, { "itemId": "do_clear_cache", "menu_item_text": "Cache l\u00f6schen", "must_save": true, "tooltip": "Cache l\u00f6schen", "panel_btn_handler": Lino.row_action_handler('do_clear_cache','GET',null), "iconCls": "x-tbar-clearcache", "overflowText": "Cache l\u00f6schen", "auto_save": true }, { "itemId": "create_mail", "menu_item_text": "per E-Mail", "must_save": true, "tooltip": "Create an email from this", "panel_btn_handler": Lino.row_action_handler('create_mail','GET',null), "iconCls": "x-tbar-email_add", "overflowText": "per E-Mail", "auto_save": true } ],
  ls_url: "/reception/MyWaitingGuests",
  action_name: "detail",
  initComponent : function() {
    this.ls_detail_handler = Lino.reception.MyWaitingGuests.detail;
    this.ls_insert_handler = Lino.reception.MyWaitingGuests.insert;
    Lino.reception.MyWaitingGuests.detailPanel.superclass.initComponent.call(this);
  }
});

Lino.reception.MyWaitingGuests.detail = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.reception.MyWaitingGuests.detailPanel(p);
});
Lino.reception.MyWaitingGuests.do_print = function(rp,pk) { 
  Lino.run_row_action(rp,"/reception/MyWaitingGuests","GET",pk,"do_print",null);
};
Lino.reception.MyWaitingGuests.do_clear_cache = function(rp,pk) { 
  Lino.run_row_action(rp,"/reception/MyWaitingGuests","GET",pk,"do_clear_cache",null);
};
Lino.reception.MyWaitingGuests.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  p.params_panel = new Lino.cal.MyPresences.ParamsPanel({});
  return new Lino.reception.MyWaitingGuests.GridPanel(p);
});
Lino.reception.MyWaitingGuests.create_mail = function(rp,pk) { 
  Lino.run_row_action(rp,"/reception/MyWaitingGuests","GET",pk,"create_mail",null);
};
Lino.reception.MyWaitingGuests.receive = function(rp,pk) { 
  Lino.run_row_action(rp,"/reception/MyWaitingGuests","GET",pk,"receive",null);
};
Lino.reception.MyWaitingGuests.checkout = function(rp,pk) { 
  Lino.run_row_action(rp,"/reception/MyWaitingGuests","GET",pk,"checkout",null);
};

// js_render_GridPanel_class pcsw.Clients
Lino.pcsw.Clients.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "Keine Daten anzuzeigen." },
  ls_url : "/pcsw/Clients",
  ls_bbar_actions : [ { "itemId": "insert", "menu_item_text": "Neu", "must_save": true, "tooltip": "Neuen Datensatz erstellen", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-new", "overflowText": "Neu", "auto_save": true }, { "itemId": "detail", "menu_item_text": "Detail", "tooltip": "Detail-Fenster auf diesem Datensatz \u00f6ffnen", "panel_btn_handler": Lino.show_detail, "iconCls": "x-tbar-detail", "overflowText": "Detail", "auto_save": true }, { "itemId": null, "menu_item_text": "L\u00f6schen", "tooltip": "Diesen Datensatz l\u00f6schen", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "L\u00f6schen", "auto_save": false }, { "itemId": "print_eid_content", "menu_item_text": "eID-Inhalt", "must_save": true, "tooltip": "eID-Inhalt", "panel_btn_handler": Lino.row_action_handler('print_eid_content','GET',null), "iconCls": "x-tbar-vcard", "overflowText": "eID-Inhalt", "auto_save": true } ],
  title : "Klienten",
  page_length : 20,
  params_panel_hidden : true,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "name": "name_column" }, { "name": "client_state" }, 'client_stateHidden', { "name": "national_id" }, { "name": "gsm" }, { "name": "address_column" }, { "name": "age" }, { "name": "email" }, { "name": "phone" }, { "type": "int", "name": "id" }, { "name": "bank_account1" }, { "name": "aid_type" }, 'aid_typeHidden', { "name": "language" }, 'languageHidden', { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" }, { "name": "row_class" } ],
  pk_index : 9,
  ls_grid_configs : [  ],
  content_type : 52,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 16,
  initComponent : function() {
    this.ls_detail_handler = Lino.pcsw.Clients.detail;
    this.ls_insert_handler = Lino.pcsw.Clients.insert;
    var ww = this.containing_window;
    var name_column_disp4685 = new Ext.form.DisplayField({ "disabled": true, "value": "<br/>", "always_enabled": true });
    var client_state4686 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "forceSelection": true, "allowBlank": false, "store": Lino.pcsw.ClientStates });
    var national_id4687 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var gsm4688 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var address_column_disp4689 = new Ext.form.DisplayField({ "disabled": true, "value": "<br/>", "always_enabled": true });
    var age_disp4690 = new Ext.form.DisplayField({ "disabled": true, "value": "<br/>", "always_enabled": true });
    var email4691 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 75 });
    var phone4692 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var id4693 = new Ext.form.NumberField({ "selectOnFocus": true });
    var bank_account14694 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 40 });
    var aid_type4695 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/pcsw/Clients/aid_type", "method": "GET" }) }), "pageSize": 20, "emptyText": "Sozialhilfeart ausw\u00e4hlen..." });
    var language4696 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "allowBlank": false, "store": [ [ "en", "Englisch" ], [ "fr", "Franz\u00f6sisch" ], [ "de", "Deutsch" ], [ "nl", "Niederl\u00e4ndisch" ] ] });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ { "width": Lino.chars2width(21), "colIndex": 0, "sortable": false, "dataIndex": "name_column", "header": "Name", "editable": false, "tooltip": "(pcsw.Clients.name_column) " }, { "colIndex": 1, "sortable": true, "header": "Zustand", "editable": true, "tooltip": "(pcsw.Clients.client_state) ", "filter": { "type": "string" }, "width": Lino.chars2width(12), "dataIndex": "client_state", "editor": client_state4686 }, { "colIndex": 2, "sortable": true, "header": "NR-Nummer", "editable": true, "tooltip": "(pcsw.Clients.national_id) ", "filter": { "type": "string" }, "width": Lino.chars2width(11), "dataIndex": "national_id", "editor": national_id4687 }, { "colIndex": 3, "sortable": true, "header": "GSM", "editable": true, "tooltip": "(pcsw.Clients.gsm) ", "filter": { "type": "string" }, "width": Lino.chars2width(11), "dataIndex": "gsm", "editor": gsm4688 }, { "width": Lino.chars2width(31), "colIndex": 4, "sortable": false, "dataIndex": "address_column", "header": "Adresse", "editable": false, "tooltip": "(pcsw.Clients.address_column) " }, { "width": Lino.chars2width(11), "colIndex": 5, "sortable": false, "dataIndex": "age", "header": "Alter", "editable": false, "tooltip": "(pcsw.Clients.age) " }, { "colIndex": 6, "sortable": true, "header": "E-Mail", "editable": true, "tooltip": "(pcsw.Clients.email) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "email", "editor": email4691 }, { "colIndex": 7, "sortable": true, "header": "Telefon", "editable": true, "tooltip": "(pcsw.Clients.phone) ", "filter": { "type": "string" }, "width": Lino.chars2width(11), "dataIndex": "phone", "editor": phone4692 }, new Lino.NullNumberColumn({ "colIndex": 8, "sortable": true, "format": "0", "editable": true, "tooltip": "(pcsw.Clients.id) ", "filter": { "type": "numeric" }, "header": "ID", "renderer": Lino.id_renderer, "editor": id4693, "width": Lino.chars2width(6), "dataIndex": "id" }), { "colIndex": 9, "sortable": true, "header": "Bankkonto 1", "editable": true, "tooltip": "(pcsw.Clients.bank_account1) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "bank_account1", "hidden": true, "editor": bank_account14694 }, { "colIndex": 10, "sortable": true, "header": "Sozialhilfeart", "editable": true, "tooltip": "(pcsw.Clients.aid_type) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "aid_type", "editor": aid_type4695 }, { "colIndex": 11, "sortable": true, "header": "Sprache", "editable": true, "tooltip": "(pcsw.Clients.language) Die Sprache, in der Dokumente ausgestellt werden sollen.", "filter": { "type": "string" }, "width": Lino.chars2width(11), "dataIndex": "language", "editor": language4696 } ];
    Lino.pcsw.Clients.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.pcsw.Clients.put = function(rp,pk) { 
  Lino.run_row_action(rp,"/pcsw/Clients","GET",pk,"put",null);
};
Lino.pcsw.Clients.post = function(rp,pk) { 
  Lino.run_row_action(rp,"/pcsw/Clients","GET",pk,"post",null);
};

Lino.pcsw.Clients.insertPanel = Ext.extend(Lino.pcsw.Clients.InsertFormPanel,{
  empty_title: "Neu Klienten",
  hide_navigator: true,
  params_panel_hidden: true,
  ls_bbar_actions: [ { "itemId": "post", "menu_item_text": "Erstellen", "tooltip": "Datensatz erstellen und dann im Detail-Fenster \u00f6ffnen", "panel_btn_handler": function(panel){panel.save(null,true,'post')}, "text": "Erstellen", "overflowText": "Erstellen", "auto_save": false }, { "itemId": "poststay", "menu_item_text": "Erstellen ohne Detail", "tooltip": "Nach Erstellen des Datensatzes kein Detail-Fenster \u00f6ffnen", "panel_btn_handler": function(panel){panel.save(null,false,'poststay')}, "text": "Erstellen ohne Detail", "overflowText": "Erstellen ohne Detail", "auto_save": false } ],
  ls_url: "/pcsw/Clients",
  action_name: "insert",
  initComponent : function() {
    this.ls_detail_handler = Lino.pcsw.Clients.detail;
    this.ls_insert_handler = Lino.pcsw.Clients.insert;
    Lino.pcsw.Clients.insertPanel.superclass.initComponent.call(this);
  }
});

Lino.pcsw.Clients.insert = new Lino.WindowAction({ "draggable": true, "width": Lino.chars2width(60), "autoHeight": true, "maximizable": true, "modal": true, "maximized": false },function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.pcsw.Clients.insertPanel(p);
});
Lino.pcsw.Clients.wf1 = function(rp,pk) { 
  Lino.run_row_action(rp,"/pcsw/Clients","GET",pk,"wf1",null);
};
Lino.pcsw.Clients.poststay = function(rp,pk) { 
  Lino.run_row_action(rp,"/pcsw/Clients","GET",pk,"poststay",null);
};
Lino.pcsw.Clients.wf3 = function(rp,pk) { 
  Lino.run_row_action(rp,"/pcsw/Clients","GET",pk,"wf3",null);
};

Lino.pcsw.Clients.detailPanel = Ext.extend(Lino.pcsw.Clients.DetailFormPanel,{
  empty_title: "Detail Klienten",
  params_panel_hidden: true,
  ls_bbar_actions: [ { "itemId": "put", "menu_item_text": "Speichern", "tooltip": "\u00c4nderungen in diesem Formular speichern", "panel_btn_handler": function(panel){panel.save(null,false,'put')}, "iconCls": "x-tbar-save", "overflowText": "Speichern", "auto_save": false }, { "itemId": "insert", "menu_item_text": "Neu", "must_save": true, "tooltip": "Neuen Datensatz erstellen", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-new", "overflowText": "Neu", "auto_save": true }, { "itemId": null, "menu_item_text": "L\u00f6schen", "tooltip": "Diesen Datensatz l\u00f6schen", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "L\u00f6schen", "auto_save": false }, { "itemId": "print_eid_content", "menu_item_text": "eID-Inhalt", "must_save": true, "tooltip": "eID-Inhalt", "panel_btn_handler": Lino.row_action_handler('print_eid_content','GET',null), "iconCls": "x-tbar-vcard", "overflowText": "eID-Inhalt", "auto_save": true } ],
  ls_url: "/pcsw/Clients",
  action_name: "detail",
  initComponent : function() {
    this.ls_detail_handler = Lino.pcsw.Clients.detail;
    this.ls_insert_handler = Lino.pcsw.Clients.insert;
    Lino.pcsw.Clients.detailPanel.superclass.initComponent.call(this);
  }
});

Lino.pcsw.Clients.detail = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.pcsw.Clients.detailPanel(p);
});
Lino.pcsw.Clients.print_eid_content = function(rp,pk) { 
  Lino.run_row_action(rp,"/pcsw/Clients","GET",pk,"print_eid_content",null);
};
Lino.pcsw.Clients.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  p.params_panel = new Lino.pcsw.Clients.ParamsPanel({});
  return new Lino.pcsw.Clients.GridPanel(p);
});
Lino.pcsw.Clients.read_beid = function(rp,pk) { 
  Lino.run_row_action(rp,"/pcsw/Clients","POST",pk,"read_beid",Lino.beid_read_card_processor);
};

// js_render_GridPanel_class languages.Languages
Lino.languages.Languages.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "Keine Daten anzuzeigen." },
  ls_url : "/languages/Languages",
  ls_bbar_actions : [ { "itemId": "insert", "menu_item_text": "Neu", "must_save": true, "tooltip": "Neuen Datensatz erstellen", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-new", "overflowText": "Neu", "auto_save": true }, { "itemId": "detail", "menu_item_text": "Detail", "tooltip": "Detail-Fenster auf diesem Datensatz \u00f6ffnen", "panel_btn_handler": Lino.show_detail, "iconCls": "x-tbar-detail", "overflowText": "Detail", "auto_save": true }, { "itemId": null, "menu_item_text": "L\u00f6schen", "tooltip": "Diesen Datensatz l\u00f6schen", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "L\u00f6schen", "auto_save": false } ],
  title : "Sprachen",
  page_length : 20,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "name": "name" }, { "name": "name_fr" }, { "name": "name_de" }, { "name": "name_nl" }, { "name": "id" }, { "name": "iso2" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 4,
  ls_grid_configs : [  ],
  content_type : 41,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 7,
  initComponent : function() {
    this.ls_detail_handler = Lino.languages.Languages.detail;
    this.ls_insert_handler = Lino.languages.Languages.insert;
    var ww = this.containing_window;
    var name4800 = new Ext.form.TextField({ "selectOnFocus": true, "allowBlank": false, "maxLength": 200 });
    var name_fr4801 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var name_de4802 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var name_nl4803 = new Ext.form.TextField({ "selectOnFocus": true, "hidden": true, "maxLength": 200 });
    var id4804 = new Ext.form.TextField({ "selectOnFocus": true, "boxMinWidth": Lino.chars2width(3), "allowBlank": false, "maxLength": 3 });
    var iso24805 = new Ext.form.TextField({ "selectOnFocus": true, "boxMinWidth": Lino.chars2width(2), "maxLength": 2 });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ { "colIndex": 0, "sortable": true, "header": "Bezeichnung", "editable": true, "tooltip": "(languages.Languages.name) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "name", "editor": name4800 }, { "colIndex": 1, "sortable": true, "header": "Bezeichnung (fr)", "editable": true, "tooltip": "(languages.Languages.name_fr) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "name_fr", "editor": name_fr4801 }, { "colIndex": 2, "sortable": true, "header": "Bezeichnung (de)", "editable": true, "tooltip": "(languages.Languages.name_de) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "name_de", "editor": name_de4802 }, { "colIndex": 3, "sortable": true, "header": "Bezeichnung (nl)", "editable": true, "tooltip": "(languages.Languages.name_nl) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "name_nl", "hidden": true, "editor": name_nl4803 }, { "colIndex": 4, "sortable": true, "header": "id", "editable": true, "tooltip": "(languages.Languages.id) ", "filter": { "type": "string" }, "width": Lino.chars2width(5), "dataIndex": "id", "editor": id4804 }, { "colIndex": 5, "sortable": true, "header": "iso2", "editable": true, "tooltip": "(languages.Languages.iso2) ", "filter": { "type": "string" }, "width": Lino.chars2width(5), "dataIndex": "iso2", "editor": iso24805 } ];
    Lino.languages.Languages.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.languages.Languages.put = function(rp,pk) { 
  Lino.run_row_action(rp,"/languages/Languages","GET",pk,"put",null);
};
Lino.languages.Languages.post = function(rp,pk) { 
  Lino.run_row_action(rp,"/languages/Languages","GET",pk,"post",null);
};

Lino.languages.Languages.insertPanel = Ext.extend(Lino.languages.Languages.DetailFormPanel,{
  empty_title: "Neu Sprachen",
  hide_navigator: true,
  ls_bbar_actions: [ { "itemId": "post", "menu_item_text": "Erstellen", "tooltip": "Datensatz erstellen und dann im Detail-Fenster \u00f6ffnen", "panel_btn_handler": function(panel){panel.save(null,true,'post')}, "text": "Erstellen", "overflowText": "Erstellen", "auto_save": false }, { "itemId": "poststay", "menu_item_text": "Erstellen ohne Detail", "tooltip": "Nach Erstellen des Datensatzes kein Detail-Fenster \u00f6ffnen", "panel_btn_handler": function(panel){panel.save(null,false,'poststay')}, "text": "Erstellen ohne Detail", "overflowText": "Erstellen ohne Detail", "auto_save": false } ],
  ls_url: "/languages/Languages",
  action_name: "insert",
  initComponent : function() {
    this.ls_detail_handler = Lino.languages.Languages.detail;
    this.ls_insert_handler = Lino.languages.Languages.insert;
    Lino.languages.Languages.insertPanel.superclass.initComponent.call(this);
  }
});

Lino.languages.Languages.insert = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.languages.Languages.insertPanel(p);
});
Lino.languages.Languages.poststay = function(rp,pk) { 
  Lino.run_row_action(rp,"/languages/Languages","GET",pk,"poststay",null);
};

Lino.languages.Languages.detailPanel = Ext.extend(Lino.languages.Languages.DetailFormPanel,{
  empty_title: "Detail Sprachen",
  ls_bbar_actions: [ { "itemId": "put", "menu_item_text": "Speichern", "tooltip": "\u00c4nderungen in diesem Formular speichern", "panel_btn_handler": function(panel){panel.save(null,false,'put')}, "iconCls": "x-tbar-save", "overflowText": "Speichern", "auto_save": false }, { "itemId": "insert", "menu_item_text": "Neu", "must_save": true, "tooltip": "Neuen Datensatz erstellen", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-new", "overflowText": "Neu", "auto_save": true }, { "itemId": null, "menu_item_text": "L\u00f6schen", "tooltip": "Diesen Datensatz l\u00f6schen", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "L\u00f6schen", "auto_save": false } ],
  ls_url: "/languages/Languages",
  action_name: "detail",
  initComponent : function() {
    this.ls_detail_handler = Lino.languages.Languages.detail;
    this.ls_insert_handler = Lino.languages.Languages.insert;
    Lino.languages.Languages.detailPanel.superclass.initComponent.call(this);
  }
});

Lino.languages.Languages.detail = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.languages.Languages.detailPanel(p);
});
Lino.languages.Languages.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.languages.Languages.GridPanel(p);
});

// js_render_GridPanel_class integ.CompaniesAndContracts
Lino.integ.CompaniesAndContracts.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "Keine Daten anzuzeigen." },
  ls_url : "/integ/CompaniesAndContracts",
  ls_bbar_actions : [ { "itemId": "insert", "menu_item_text": "Neu", "must_save": true, "tooltip": "Neuen Datensatz erstellen", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-new", "overflowText": "Neu", "auto_save": true }, { "itemId": "detail", "menu_item_text": "Detail", "tooltip": "Detail-Fenster auf diesem Datensatz \u00f6ffnen", "panel_btn_handler": Lino.show_detail, "iconCls": "x-tbar-detail", "overflowText": "Detail", "auto_save": true }, { "itemId": null, "menu_item_text": "L\u00f6schen", "tooltip": "Diesen Datensatz l\u00f6schen", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "L\u00f6schen", "auto_save": false } ],
  title : "Organisations externes et contrats",
  page_length : 20,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "name": "description" }, 'descriptionHidden', { "name": "vc0" }, { "name": "vc1" }, { "name": "vc2" }, { "name": "vc3" }, { "name": "vc4" }, { "name": "vc5" }, { "name": "partner_ptr" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 8,
  ls_grid_configs : [  ],
  content_type : 19,
  ls_id_property : "partner_ptr",
  gc_name : 0,
  disabled_actions_index : 10,
  initComponent : function() {
    this.ls_detail_handler = Lino.integ.CompaniesAndContracts.detail;
    this.ls_insert_handler = Lino.integ.CompaniesAndContracts.insert;
    var ww = this.containing_window;
    var description4978 = new Lino.RemoteComboFieldElement({ "disabled": true, "preferred_width": 20, "store": new Lino.ComplexRemoteComboStore({  }), "pageSize": 20, "emptyText": "Organisation ausw\u00e4hlen..." });
    var vc04979 = new Ext.form.NumberField({ "disabled": true });
    var vc14980 = new Ext.form.NumberField({ "disabled": true });
    var vc24981 = new Ext.form.NumberField({ "disabled": true });
    var vc34982 = new Ext.form.NumberField({ "disabled": true });
    var vc44983 = new Ext.form.NumberField({ "disabled": true });
    var vc54984 = new Ext.form.NumberField({ "disabled": true });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ { "colIndex": 0, "sortable": false, "header": "Organisation", "editable": false, "tooltip": "(integ.CompaniesAndContracts.description) ", "width": Lino.chars2width(21), "dataIndex": "description", "renderer": Lino.fk_renderer('descriptionHidden','Lino.contacts.Companies.detail') }, new Lino.NullNumberColumn({ "colIndex": 1, "sortable": false, "format": "0", "editable": false, "tooltip": "(integ.CompaniesAndContracts.vc0) ", "header": "VSE Ausbildung", "dataIndex": "vc0", "width": Lino.chars2width(6) }), new Lino.NullNumberColumn({ "colIndex": 2, "sortable": false, "format": "0", "editable": false, "tooltip": "(integ.CompaniesAndContracts.vc1) ", "header": "VSE Arbeitssuche", "dataIndex": "vc1", "width": Lino.chars2width(6) }), new Lino.NullNumberColumn({ "colIndex": 3, "sortable": false, "format": "0", "editable": false, "tooltip": "(integ.CompaniesAndContracts.vc2) ", "header": "VSE Lehre", "dataIndex": "vc2", "width": Lino.chars2width(6) }), new Lino.NullNumberColumn({ "colIndex": 4, "sortable": false, "format": "0", "editable": false, "tooltip": "(integ.CompaniesAndContracts.vc3) ", "header": "VSE Vollzeitstudium", "dataIndex": "vc3", "width": Lino.chars2width(6) }), new Lino.NullNumberColumn({ "colIndex": 5, "sortable": false, "format": "0", "editable": false, "tooltip": "(integ.CompaniesAndContracts.vc4) ", "header": "VSE Sprachkurs", "dataIndex": "vc4", "width": Lino.chars2width(6) }), new Lino.NullNumberColumn({ "colIndex": 6, "sortable": false, "format": "0", "editable": false, "tooltip": "(integ.CompaniesAndContracts.vc5) ", "header": "Total", "dataIndex": "vc5", "width": Lino.chars2width(6) }) ];
    Lino.integ.CompaniesAndContracts.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.integ.CompaniesAndContracts.put = function(rp,pk) { 
  Lino.run_row_action(rp,"/integ/CompaniesAndContracts","GET",pk,"put",null);
};
Lino.integ.CompaniesAndContracts.post = function(rp,pk) { 
  Lino.run_row_action(rp,"/integ/CompaniesAndContracts","GET",pk,"post",null);
};

Lino.integ.CompaniesAndContracts.insertPanel = Ext.extend(Lino.contacts.Companies.InsertFormPanel,{
  empty_title: "Neu Organisations externes et contrats",
  hide_navigator: true,
  ls_bbar_actions: [ { "itemId": "post", "menu_item_text": "Erstellen", "tooltip": "Datensatz erstellen und dann im Detail-Fenster \u00f6ffnen", "panel_btn_handler": function(panel){panel.save(null,true,'post')}, "text": "Erstellen", "overflowText": "Erstellen", "auto_save": false }, { "itemId": "poststay", "menu_item_text": "Erstellen ohne Detail", "tooltip": "Nach Erstellen des Datensatzes kein Detail-Fenster \u00f6ffnen", "panel_btn_handler": function(panel){panel.save(null,false,'poststay')}, "text": "Erstellen ohne Detail", "overflowText": "Erstellen ohne Detail", "auto_save": false } ],
  ls_url: "/integ/CompaniesAndContracts",
  action_name: "insert",
  initComponent : function() {
    this.ls_detail_handler = Lino.integ.CompaniesAndContracts.detail;
    this.ls_insert_handler = Lino.integ.CompaniesAndContracts.insert;
    Lino.integ.CompaniesAndContracts.insertPanel.superclass.initComponent.call(this);
  }
});

Lino.integ.CompaniesAndContracts.insert = new Lino.WindowAction({ "draggable": true, "width": Lino.chars2width(60), "autoHeight": true, "maximizable": true, "modal": true, "maximized": false },function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.integ.CompaniesAndContracts.insertPanel(p);
});
Lino.integ.CompaniesAndContracts.poststay = function(rp,pk) { 
  Lino.run_row_action(rp,"/integ/CompaniesAndContracts","GET",pk,"poststay",null);
};

Lino.integ.CompaniesAndContracts.detailPanel = Ext.extend(Lino.contacts.Companies.DetailFormPanel,{
  empty_title: "Detail Organisations externes et contrats",
  ls_bbar_actions: [ { "itemId": "put", "menu_item_text": "Speichern", "tooltip": "\u00c4nderungen in diesem Formular speichern", "panel_btn_handler": function(panel){panel.save(null,false,'put')}, "iconCls": "x-tbar-save", "overflowText": "Speichern", "auto_save": false }, { "itemId": "insert", "menu_item_text": "Neu", "must_save": true, "tooltip": "Neuen Datensatz erstellen", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-new", "overflowText": "Neu", "auto_save": true }, { "itemId": null, "menu_item_text": "L\u00f6schen", "tooltip": "Diesen Datensatz l\u00f6schen", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "L\u00f6schen", "auto_save": false } ],
  ls_url: "/integ/CompaniesAndContracts",
  action_name: "detail",
  initComponent : function() {
    this.ls_detail_handler = Lino.integ.CompaniesAndContracts.detail;
    this.ls_insert_handler = Lino.integ.CompaniesAndContracts.insert;
    Lino.integ.CompaniesAndContracts.detailPanel.superclass.initComponent.call(this);
  }
});

Lino.integ.CompaniesAndContracts.detail = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.integ.CompaniesAndContracts.detailPanel(p);
});
Lino.integ.CompaniesAndContracts.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.integ.CompaniesAndContracts.GridPanel(p);
});

// js_render_GridPanel_class integ.JobProvidersAndContracts
Lino.integ.JobProvidersAndContracts.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "Keine Daten anzuzeigen." },
  ls_url : "/integ/JobProvidersAndContracts",
  ls_bbar_actions : [ { "itemId": "insert", "menu_item_text": "Neu", "must_save": true, "tooltip": "Neuen Datensatz erstellen", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-new", "overflowText": "Neu", "auto_save": true }, { "itemId": "detail", "menu_item_text": "Detail", "tooltip": "Detail-Fenster auf diesem Datensatz \u00f6ffnen", "panel_btn_handler": Lino.show_detail, "iconCls": "x-tbar-detail", "overflowText": "Detail", "auto_save": true }, { "itemId": null, "menu_item_text": "L\u00f6schen", "tooltip": "Diesen Datensatz l\u00f6schen", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "L\u00f6schen", "auto_save": false } ],
  title : "Employants et contrats Art 60\u00a77",
  page_length : 20,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "name": "description" }, 'descriptionHidden', { "name": "vc0" }, { "name": "vc1" }, { "name": "vc2" }, { "name": "vc3" }, { "name": "vc4" }, { "name": "vc5" }, { "name": "partner_ptr" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 8,
  ls_grid_configs : [  ],
  content_type : 19,
  ls_id_property : "partner_ptr",
  gc_name : 0,
  disabled_actions_index : 10,
  initComponent : function() {
    this.ls_detail_handler = Lino.integ.JobProvidersAndContracts.detail;
    this.ls_insert_handler = Lino.integ.JobProvidersAndContracts.insert;
    var ww = this.containing_window;
    var description4986 = new Lino.RemoteComboFieldElement({ "disabled": true, "preferred_width": 20, "store": new Lino.ComplexRemoteComboStore({  }), "pageSize": 20, "emptyText": "Organisation ausw\u00e4hlen..." });
    var vc04987 = new Ext.form.NumberField({ "disabled": true });
    var vc14988 = new Ext.form.NumberField({ "disabled": true });
    var vc24989 = new Ext.form.NumberField({ "disabled": true });
    var vc34990 = new Ext.form.NumberField({ "disabled": true });
    var vc44991 = new Ext.form.NumberField({ "disabled": true });
    var vc54992 = new Ext.form.NumberField({ "disabled": true });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ { "colIndex": 0, "sortable": false, "header": "Organisation", "editable": false, "tooltip": "(integ.JobProvidersAndContracts.description) ", "width": Lino.chars2width(21), "dataIndex": "description", "renderer": Lino.fk_renderer('descriptionHidden','Lino.contacts.Companies.detail') }, new Lino.NullNumberColumn({ "colIndex": 1, "sortable": false, "format": "0", "editable": false, "tooltip": "(integ.JobProvidersAndContracts.vc0) ", "header": "social economy", "dataIndex": "vc0", "width": Lino.chars2width(6) }), new Lino.NullNumberColumn({ "colIndex": 2, "sortable": false, "format": "0", "editable": false, "tooltip": "(integ.JobProvidersAndContracts.vc1) ", "header": "social economy - increased", "dataIndex": "vc1", "width": Lino.chars2width(6) }), new Lino.NullNumberColumn({ "colIndex": 3, "sortable": false, "format": "0", "editable": false, "tooltip": "(integ.JobProvidersAndContracts.vc2) ", "header": "social economy with refund", "dataIndex": "vc2", "width": Lino.chars2width(6) }), new Lino.NullNumberColumn({ "colIndex": 4, "sortable": false, "format": "0", "editable": false, "tooltip": "(integ.JobProvidersAndContracts.vc3) ", "header": "social economy school", "dataIndex": "vc3", "width": Lino.chars2width(6) }), new Lino.NullNumberColumn({ "colIndex": 5, "sortable": false, "format": "0", "editable": false, "tooltip": "(integ.JobProvidersAndContracts.vc4) ", "header": "town", "dataIndex": "vc4", "width": Lino.chars2width(6) }), new Lino.NullNumberColumn({ "colIndex": 6, "sortable": false, "format": "0", "editable": false, "tooltip": "(integ.JobProvidersAndContracts.vc5) ", "header": "Total", "dataIndex": "vc5", "width": Lino.chars2width(6) }) ];
    Lino.integ.JobProvidersAndContracts.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.integ.JobProvidersAndContracts.put = function(rp,pk) { 
  Lino.run_row_action(rp,"/integ/JobProvidersAndContracts","GET",pk,"put",null);
};
Lino.integ.JobProvidersAndContracts.post = function(rp,pk) { 
  Lino.run_row_action(rp,"/integ/JobProvidersAndContracts","GET",pk,"post",null);
};

Lino.integ.JobProvidersAndContracts.insertPanel = Ext.extend(Lino.contacts.Companies.InsertFormPanel,{
  empty_title: "Neu Employants et contrats Art 60\u00a77",
  hide_navigator: true,
  ls_bbar_actions: [ { "itemId": "post", "menu_item_text": "Erstellen", "tooltip": "Datensatz erstellen und dann im Detail-Fenster \u00f6ffnen", "panel_btn_handler": function(panel){panel.save(null,true,'post')}, "text": "Erstellen", "overflowText": "Erstellen", "auto_save": false }, { "itemId": "poststay", "menu_item_text": "Erstellen ohne Detail", "tooltip": "Nach Erstellen des Datensatzes kein Detail-Fenster \u00f6ffnen", "panel_btn_handler": function(panel){panel.save(null,false,'poststay')}, "text": "Erstellen ohne Detail", "overflowText": "Erstellen ohne Detail", "auto_save": false } ],
  ls_url: "/integ/JobProvidersAndContracts",
  action_name: "insert",
  initComponent : function() {
    this.ls_detail_handler = Lino.integ.JobProvidersAndContracts.detail;
    this.ls_insert_handler = Lino.integ.JobProvidersAndContracts.insert;
    Lino.integ.JobProvidersAndContracts.insertPanel.superclass.initComponent.call(this);
  }
});

Lino.integ.JobProvidersAndContracts.insert = new Lino.WindowAction({ "draggable": true, "width": Lino.chars2width(60), "autoHeight": true, "maximizable": true, "modal": true, "maximized": false },function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.integ.JobProvidersAndContracts.insertPanel(p);
});
Lino.integ.JobProvidersAndContracts.poststay = function(rp,pk) { 
  Lino.run_row_action(rp,"/integ/JobProvidersAndContracts","GET",pk,"poststay",null);
};

Lino.integ.JobProvidersAndContracts.detailPanel = Ext.extend(Lino.contacts.Companies.DetailFormPanel,{
  empty_title: "Detail Employants et contrats Art 60\u00a77",
  ls_bbar_actions: [ { "itemId": "put", "menu_item_text": "Speichern", "tooltip": "\u00c4nderungen in diesem Formular speichern", "panel_btn_handler": function(panel){panel.save(null,false,'put')}, "iconCls": "x-tbar-save", "overflowText": "Speichern", "auto_save": false }, { "itemId": "insert", "menu_item_text": "Neu", "must_save": true, "tooltip": "Neuen Datensatz erstellen", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-new", "overflowText": "Neu", "auto_save": true }, { "itemId": null, "menu_item_text": "L\u00f6schen", "tooltip": "Diesen Datensatz l\u00f6schen", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "L\u00f6schen", "auto_save": false } ],
  ls_url: "/integ/JobProvidersAndContracts",
  action_name: "detail",
  initComponent : function() {
    this.ls_detail_handler = Lino.integ.JobProvidersAndContracts.detail;
    this.ls_insert_handler = Lino.integ.JobProvidersAndContracts.insert;
    Lino.integ.JobProvidersAndContracts.detailPanel.superclass.initComponent.call(this);
  }
});

Lino.integ.JobProvidersAndContracts.detail = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.integ.JobProvidersAndContracts.detailPanel(p);
});
Lino.integ.JobProvidersAndContracts.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.integ.JobProvidersAndContracts.GridPanel(p);
});

// js_render_GridPanel_class newcomers.NewClients
Lino.newcomers.NewClients.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "Keine Daten anzuzeigen." },
  ls_url : "/newcomers/NewClients",
  ls_bbar_actions : [ { "itemId": "insert", "menu_item_text": "Neu", "must_save": true, "tooltip": "Neuen Datensatz erstellen", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-new", "overflowText": "Neu", "auto_save": true }, { "itemId": "detail", "menu_item_text": "Detail", "tooltip": "Detail-Fenster auf diesem Datensatz \u00f6ffnen", "panel_btn_handler": Lino.show_detail, "iconCls": "x-tbar-detail", "overflowText": "Detail", "auto_save": true }, { "itemId": null, "menu_item_text": "L\u00f6schen", "tooltip": "Diesen Datensatz l\u00f6schen", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "L\u00f6schen", "auto_save": false }, { "itemId": "print_eid_content", "menu_item_text": "eID-Inhalt", "must_save": true, "tooltip": "eID-Inhalt", "panel_btn_handler": Lino.row_action_handler('print_eid_content','GET',null), "iconCls": "x-tbar-vcard", "overflowText": "eID-Inhalt", "auto_save": true } ],
  title : "Neue Klienten",
  page_length : 20,
  params_panel_hidden : true,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "name": "name_column" }, { "name": "client_state" }, 'client_stateHidden', { "name": "broker" }, 'brokerHidden', { "name": "faculty" }, 'facultyHidden', { "name": "national_id" }, { "name": "gsm" }, { "name": "address_column" }, { "name": "age" }, { "name": "email" }, { "name": "phone" }, { "type": "int", "name": "id" }, { "name": "bank_account1" }, { "name": "aid_type" }, 'aid_typeHidden', { "name": "language" }, 'languageHidden', { "name": "created" }, { "name": "modified" }, { "name": "country" }, 'countryHidden', { "name": "city" }, 'cityHidden', { "name": "region" }, 'regionHidden', { "name": "zip_code" }, { "name": "name" }, { "name": "addr1" }, { "name": "street_prefix" }, { "name": "street" }, { "name": "street_no" }, { "name": "street_box" }, { "name": "addr2" }, { "name": "url" }, { "name": "fax" }, { "name": "remarks" }, { "type": "boolean", "name": "is_obsolete" }, { "name": "activity" }, 'activityHidden', { "name": "bank_account2" }, { "name": "first_name" }, { "name": "last_name" }, { "name": "gender" }, 'genderHidden', { "name": "birth_date" }, { "name": "title" }, { "name": "nationality" }, 'nationalityHidden', { "name": "card_number" }, { "type": "date", "name": "card_valid_from", "dateFormat": "d.m.Y" }, { "type": "date", "name": "card_valid_until", "dateFormat": "d.m.Y" }, { "name": "card_type" }, 'card_typeHidden', { "name": "card_issuer" }, { "name": "noble_condition" }, { "name": "remarks2" }, { "name": "gesdos_id" }, { "type": "boolean", "name": "is_cpas" }, { "type": "boolean", "name": "is_senior" }, { "name": "group" }, 'groupHidden', { "name": "birth_place" }, { "name": "birth_country" }, 'birth_countryHidden', { "name": "civil_state" }, 'civil_stateHidden', { "name": "health_insurance" }, 'health_insuranceHidden', { "name": "pharmacy" }, 'pharmacyHidden', { "name": "residence_type" }, 'residence_typeHidden', { "type": "date", "name": "in_belgium_since", "dateFormat": "d.m.Y" }, { "type": "date", "name": "unemployed_since", "dateFormat": "d.m.Y" }, { "type": "boolean", "name": "needs_residence_permit" }, { "type": "boolean", "name": "needs_work_permit" }, { "type": "date", "name": "work_permit_suspended_until", "dateFormat": "d.m.Y" }, { "type": "boolean", "name": "income_ag" }, { "type": "boolean", "name": "income_wg" }, { "type": "boolean", "name": "income_kg" }, { "type": "boolean", "name": "income_rente" }, { "type": "boolean", "name": "income_misc" }, { "type": "boolean", "name": "is_seeking" }, { "type": "date", "name": "unavailable_until", "dateFormat": "d.m.Y" }, { "name": "unavailable_why" }, { "name": "obstacles" }, { "name": "skills" }, { "name": "job_agents" }, { "name": "job_office_contact" }, 'job_office_contactHidden', { "name": "refusal_reason" }, 'refusal_reasonHidden', { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" }, { "name": "row_class" } ],
  pk_index : 13,
  ls_grid_configs : [  ],
  content_type : 52,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 95,
  initComponent : function() {
    this.ls_detail_handler = Lino.newcomers.NewClients.detail;
    this.ls_insert_handler = Lino.newcomers.NewClients.insert;
    var ww = this.containing_window;
    var name_column_disp5010 = new Ext.form.DisplayField({ "disabled": true, "value": "<br/>", "always_enabled": true });
    var client_state5011 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "forceSelection": true, "allowBlank": false, "store": Lino.pcsw.ClientStates });
    var broker5012 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/newcomers/NewClients/broker", "method": "GET" }) }), "pageSize": 20, "emptyText": "Vermittler ausw\u00e4hlen..." });
    var faculty5013 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/newcomers/NewClients/faculty", "method": "GET" }) }), "pageSize": 20, "emptyText": "Fachbereich ausw\u00e4hlen..." });
    var national_id5014 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var gsm5015 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var address_column_disp5016 = new Ext.form.DisplayField({ "disabled": true, "value": "<br/>", "always_enabled": true });
    var age_disp5017 = new Ext.form.DisplayField({ "disabled": true, "value": "<br/>", "always_enabled": true });
    var email5018 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 75 });
    var phone5019 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var id5020 = new Ext.form.NumberField({ "selectOnFocus": true });
    var bank_account15021 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 40 });
    var aid_type5022 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/newcomers/NewClients/aid_type", "method": "GET" }) }), "pageSize": 20, "emptyText": "Sozialhilfeart ausw\u00e4hlen..." });
    var language5023 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "allowBlank": false, "store": [ [ "en", "Englisch" ], [ "fr", "Franz\u00f6sisch" ], [ "de", "Deutsch" ], [ "nl", "Niederl\u00e4ndisch" ] ] });
    var created5024 = new Ext.form.DisplayField({ "disabled": true, "value": "<br>" });
    var modified5025 = new Ext.form.DisplayField({ "disabled": true, "value": "<br>" });
    var country5026 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/newcomers/NewClients/country", "method": "GET" }) }), "pageSize": 20, "emptyText": "Land ausw\u00e4hlen..." });
    var city5027 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "forceSelection": false, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/newcomers/NewClients/city", "method": "GET" }) }), "pageSize": 20, "emptyText": "Ort ausw\u00e4hlen..." });
    var region5028 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/newcomers/NewClients/region", "method": "GET" }) }), "pageSize": 20, "emptyText": "Ort ausw\u00e4hlen..." });
    var zip_code5029 = new Ext.form.TextField({ "selectOnFocus": true, "boxMinWidth": Lino.chars2width(10), "maxLength": 10 });
    var name5030 = new Ext.form.TextField({ "selectOnFocus": true, "allowBlank": false, "maxLength": 200 });
    var addr15031 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var street_prefix5032 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var street5033 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var street_no5034 = new Ext.form.TextField({ "selectOnFocus": true, "boxMinWidth": Lino.chars2width(10), "maxLength": 10 });
    var street_box5035 = new Ext.form.TextField({ "selectOnFocus": true, "boxMinWidth": Lino.chars2width(10), "maxLength": 10 });
    var addr25036 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var url5037 = new Lino.URLField({ "selectOnFocus": true, "maxLength": 200 });
    var fax5038 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var remarks5039 = new Ext.form.TextArea({ "selectOnFocus": true, "growMax": 2000 });
    var is_obsolete5040 = new Ext.form.Checkbox({ "selectOnFocus": true, "checked": false });
    var activity5041 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/newcomers/NewClients/activity", "method": "GET" }) }), "pageSize": 20, "emptyText": "Beruf ausw\u00e4hlen..." });
    var bank_account25042 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 40 });
    var first_name5043 = new Ext.form.TextField({ "selectOnFocus": true, "allowBlank": false, "maxLength": 200 });
    var last_name5044 = new Ext.form.TextField({ "selectOnFocus": true, "allowBlank": false, "maxLength": 200 });
    var gender5045 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "forceSelection": true, "store": [['','<br>']].concat(Lino.lino.Genders) });
    var birth_date5046 = new Lino.IncompleteDateField({ "selectOnFocus": true });
    var title5047 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var nationality5048 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/newcomers/NewClients/nationality", "method": "GET" }) }), "pageSize": 20, "emptyText": "Land ausw\u00e4hlen..." });
    var card_number5049 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 20 });
    var card_valid_from5050 = new Lino.DateField({ "selectOnFocus": true });
    var card_valid_until5051 = new Lino.DateField({ "selectOnFocus": true });
    var card_type5052 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "forceSelection": true, "store": [['','<br>']].concat(Lino.lino.BeIdCardTypes) });
    var card_issuer5053 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 50 });
    var noble_condition5054 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 50 });
    var remarks25055 = new Ext.form.TextArea({ "selectOnFocus": true, "growMax": 2000 });
    var gesdos_id5056 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 40 });
    var is_cpas5057 = new Ext.form.Checkbox({ "selectOnFocus": true, "checked": false });
    var is_senior5058 = new Ext.form.Checkbox({ "selectOnFocus": true, "checked": false });
    var group5059 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/newcomers/NewClients/group", "method": "GET" }) }), "pageSize": 20, "emptyText": "Integrationsphase ausw\u00e4hlen..." });
    var birth_place5060 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var birth_country5061 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/newcomers/NewClients/birth_country", "method": "GET" }) }), "pageSize": 20, "emptyText": "Land ausw\u00e4hlen..." });
    var civil_state5062 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "forceSelection": true, "store": [['','<br>']].concat(Lino.pcsw.CivilState) });
    var health_insurance5063 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "preferred_width": 20, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/newcomers/NewClients/health_insurance", "method": "GET" }) }), "pageSize": 20, "emptyText": "Organisation ausw\u00e4hlen..." });
    var pharmacy5064 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "preferred_width": 20, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/newcomers/NewClients/pharmacy", "method": "GET" }) }), "pageSize": 20, "emptyText": "Organisation ausw\u00e4hlen..." });
    var residence_type5065 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "forceSelection": true, "store": [['','<br>']].concat(Lino.pcsw.ResidenceType) });
    var in_belgium_since5066 = new Lino.DateField({ "selectOnFocus": true });
    var unemployed_since5067 = new Lino.DateField({ "selectOnFocus": true });
    var needs_residence_permit5068 = new Ext.form.Checkbox({ "selectOnFocus": true, "checked": false });
    var needs_work_permit5069 = new Ext.form.Checkbox({ "selectOnFocus": true, "checked": false });
    var work_permit_suspended_until5070 = new Lino.DateField({ "selectOnFocus": true });
    var income_ag5071 = new Ext.form.Checkbox({ "selectOnFocus": true, "checked": false });
    var income_wg5072 = new Ext.form.Checkbox({ "selectOnFocus": true, "checked": false });
    var income_kg5073 = new Ext.form.Checkbox({ "selectOnFocus": true, "checked": false });
    var income_rente5074 = new Ext.form.Checkbox({ "selectOnFocus": true, "checked": false });
    var income_misc5075 = new Ext.form.Checkbox({ "selectOnFocus": true, "checked": false });
    var is_seeking5076 = new Ext.form.Checkbox({ "selectOnFocus": true, "checked": false });
    var unavailable_until5077 = new Lino.DateField({ "selectOnFocus": true });
    var unavailable_why5078 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 100 });
    var obstacles5079 = new Ext.form.TextArea({ "selectOnFocus": true, "growMax": 2000 });
    var skills5080 = new Ext.form.TextArea({ "selectOnFocus": true, "growMax": 2000 });
    var job_agents5081 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 100 });
    var job_office_contact5082 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/newcomers/NewClients/job_office_contact", "method": "GET" }) }), "pageSize": 20, "emptyText": "Kontaktperson ausw\u00e4hlen..." });
    var refusal_reason5083 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "forceSelection": true, "store": [['','<br>']].concat(Lino.pcsw.RefusalReasons) });
    this.before_row_edit = function(record) {
      city5027.setContextValue('country',record ? record.data['countryHidden'] : undefined);
      city5027.setContextValue('region',record ? record.data['regionHidden'] : undefined);
      region5028.setContextValue('country',record ? record.data['countryHidden'] : undefined);
    };
    this.onRender = function(ct, position) {
      country5026.on('change',Lino.chooser_handler(city5027,'country'));
      region5028.on('change',Lino.chooser_handler(city5027,'region'));
      country5026.on('change',Lino.chooser_handler(region5028,'country'));
      Lino.newcomers.NewClients.GridPanel.superclass.onRender.call(this, ct, position);
    }
    this.ls_columns = [ { "width": Lino.chars2width(21), "colIndex": 0, "sortable": false, "dataIndex": "name_column", "header": "Name", "editable": false, "tooltip": "(newcomers.NewClients.name_column) " }, { "colIndex": 1, "sortable": true, "header": "Zustand", "editable": true, "tooltip": "(newcomers.NewClients.client_state) ", "filter": { "type": "string" }, "width": Lino.chars2width(12), "dataIndex": "client_state", "editor": client_state5011 }, { "colIndex": 2, "sortable": true, "header": "Vermittler", "editable": true, "tooltip": "(newcomers.NewClients.broker) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "broker", "editor": broker5012 }, { "colIndex": 3, "sortable": true, "header": "Fachbereich", "editable": true, "tooltip": "(newcomers.NewClients.faculty) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "faculty", "editor": faculty5013 }, { "colIndex": 4, "sortable": true, "header": "NR-Nummer", "editable": true, "tooltip": "(newcomers.NewClients.national_id) ", "filter": { "type": "string" }, "width": Lino.chars2width(11), "dataIndex": "national_id", "editor": national_id5014 }, { "colIndex": 5, "sortable": true, "header": "GSM", "editable": true, "tooltip": "(newcomers.NewClients.gsm) ", "filter": { "type": "string" }, "width": Lino.chars2width(11), "dataIndex": "gsm", "editor": gsm5015 }, { "width": Lino.chars2width(31), "colIndex": 6, "sortable": false, "dataIndex": "address_column", "header": "Adresse", "editable": false, "tooltip": "(newcomers.NewClients.address_column) " }, { "width": Lino.chars2width(11), "colIndex": 7, "sortable": false, "dataIndex": "age", "header": "Alter", "editable": false, "tooltip": "(newcomers.NewClients.age) " }, { "colIndex": 8, "sortable": true, "header": "E-Mail", "editable": true, "tooltip": "(newcomers.NewClients.email) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "email", "editor": email5018 }, { "colIndex": 9, "sortable": true, "header": "Telefon", "editable": true, "tooltip": "(newcomers.NewClients.phone) ", "filter": { "type": "string" }, "width": Lino.chars2width(11), "dataIndex": "phone", "editor": phone5019 }, new Lino.NullNumberColumn({ "colIndex": 10, "sortable": true, "format": "0", "editable": true, "tooltip": "(newcomers.NewClients.id) ", "filter": { "type": "numeric" }, "header": "ID", "renderer": Lino.id_renderer, "editor": id5020, "width": Lino.chars2width(6), "dataIndex": "id" }), { "colIndex": 11, "sortable": true, "header": "Bankkonto 1", "editable": true, "tooltip": "(newcomers.NewClients.bank_account1) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "bank_account1", "hidden": true, "editor": bank_account15021 }, { "colIndex": 12, "sortable": true, "header": "Sozialhilfeart", "editable": true, "tooltip": "(newcomers.NewClients.aid_type) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "aid_type", "editor": aid_type5022 }, { "colIndex": 13, "sortable": true, "header": "Sprache", "editable": true, "tooltip": "(newcomers.NewClients.language) Die Sprache, in der Dokumente ausgestellt werden sollen.", "filter": { "type": "string" }, "width": Lino.chars2width(11), "dataIndex": "language", "editor": language5023 }, { "colIndex": 14, "sortable": true, "header": "Erstellt", "editable": false, "tooltip": "(newcomers.NewClients.created) ", "width": Lino.chars2width(17), "dataIndex": "created", "hidden": true }, { "colIndex": 15, "sortable": true, "header": "Bearbeitet", "editable": false, "tooltip": "(newcomers.NewClients.modified) ", "width": Lino.chars2width(17), "dataIndex": "modified", "hidden": true }, { "colIndex": 16, "sortable": true, "header": "Land", "editable": true, "tooltip": "(newcomers.NewClients.country) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('countryHidden','Lino.countries.Countries.detail'), "editor": country5026, "dataIndex": "country" }, { "colIndex": 17, "sortable": true, "header": "Ort", "editable": true, "tooltip": "(newcomers.NewClients.city) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "city", "editor": city5027 }, { "colIndex": 18, "sortable": true, "header": "Region", "editable": true, "tooltip": "(newcomers.NewClients.region) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "region", "editor": region5028 }, { "colIndex": 19, "sortable": true, "header": "Postleitzahl", "editable": true, "tooltip": "(newcomers.NewClients.zip_code) ", "filter": { "type": "string" }, "width": Lino.chars2width(12), "dataIndex": "zip_code", "editor": zip_code5029 }, { "colIndex": 20, "sortable": true, "header": "Name", "editable": true, "tooltip": "(newcomers.NewClients.name) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "name", "editor": name5030 }, { "colIndex": 21, "sortable": true, "header": "Adresszeile vor Stra\u00dfe", "editable": true, "tooltip": "(newcomers.NewClients.addr1) Address line before street", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "addr1", "editor": addr15031 }, { "colIndex": 22, "sortable": true, "header": "Pr\u00e4fix Stra\u00dfe", "editable": true, "tooltip": "(newcomers.NewClients.street_prefix) Text to print before name of street, but to ignore for sorting.", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "street_prefix", "editor": street_prefix5032 }, { "colIndex": 23, "sortable": true, "header": "Stra\u00dfe", "editable": true, "tooltip": "(newcomers.NewClients.street) Name of street. Without house number.", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "street", "editor": street5033 }, { "colIndex": 24, "sortable": true, "header": "Nr.", "editable": true, "tooltip": "(newcomers.NewClients.street_no) House number", "filter": { "type": "string" }, "width": Lino.chars2width(12), "dataIndex": "street_no", "editor": street_no5034 }, { "colIndex": 25, "sortable": true, "header": "Box", "editable": true, "tooltip": "(newcomers.NewClients.street_box) Text to print after :attr:`steet_no` on the same line", "filter": { "type": "string" }, "width": Lino.chars2width(12), "dataIndex": "street_box", "editor": street_box5035 }, { "colIndex": 26, "sortable": true, "header": "Adresszeile nach Stra\u00dfe", "editable": true, "tooltip": "(newcomers.NewClients.addr2) Address line to print below street line", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "addr2", "editor": addr25036 }, { "colIndex": 27, "sortable": true, "header": "URL", "editable": true, "tooltip": "(newcomers.NewClients.url) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "url", "editor": url5037 }, { "colIndex": 28, "sortable": true, "header": "Fax", "editable": true, "tooltip": "(newcomers.NewClients.fax) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "fax", "editor": fax5038 }, { "colIndex": 29, "sortable": false, "header": "Bemerkungen", "editable": true, "tooltip": "(newcomers.NewClients.remarks) ", "filter": { "type": "string" }, "width": Lino.chars2width(61), "renderer": Lino.text_renderer, "editor": remarks5039, "dataIndex": "remarks" }, { "colIndex": 30, "sortable": false, "xtype": "checkcolumn", "header": "veraltet", "editable": true, "tooltip": "(newcomers.NewClients.is_obsolete) Altf\u00e4lle sind Partner, deren Stammdaten nicht mehr gepflegt werden und \nf\u00fcr neue Operationen nicht benutzt werden k\u00f6nnen.", "filter": { "type": "boolean" }, "width": Lino.chars2width(11), "dataIndex": "is_obsolete" }, { "colIndex": 31, "sortable": true, "header": "Beruf", "editable": true, "tooltip": "(newcomers.NewClients.activity) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "activity", "hidden": true, "editor": activity5041 }, { "colIndex": 32, "sortable": true, "header": "Bankkonto 2", "editable": true, "tooltip": "(newcomers.NewClients.bank_account2) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "bank_account2", "hidden": true, "editor": bank_account25042 }, { "colIndex": 33, "sortable": true, "header": "Vorname", "editable": true, "tooltip": "(newcomers.NewClients.first_name) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "first_name", "editor": first_name5043 }, { "colIndex": 34, "sortable": true, "header": "Familienname", "editable": true, "tooltip": "(newcomers.NewClients.last_name) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "last_name", "editor": last_name5044 }, { "colIndex": 35, "sortable": true, "header": "Geschlecht", "editable": true, "tooltip": "(newcomers.NewClients.gender) ", "filter": { "type": "string" }, "width": Lino.chars2width(10), "dataIndex": "gender", "editor": gender5045 }, { "colIndex": 36, "sortable": true, "header": "Geburtsdatum", "editable": true, "tooltip": "(newcomers.NewClients.birth_date) Uncomplete dates are allowed, e.g. \n\"00.00.1980\" means \"some day in 1980\", \n\"00.07.1980\" means \"in July 1980\"\nor \"23.07.0000\" means \"on a 23th of July\".", "filter": { "type": "string" }, "width": Lino.chars2width(13), "dataIndex": "birth_date", "editor": birth_date5046 }, { "colIndex": 37, "sortable": true, "header": "Anrede", "editable": true, "tooltip": "(newcomers.NewClients.title) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "title", "editor": title5047 }, { "colIndex": 38, "sortable": true, "header": "Staatsangeh\u00f6rigkeit", "editable": true, "tooltip": "(newcomers.NewClients.nationality) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('nationalityHidden','Lino.countries.Countries.detail'), "editor": nationality5048, "dataIndex": "nationality" }, { "colIndex": 39, "sortable": true, "header": "eID-Kartennummer", "editable": true, "tooltip": "(newcomers.NewClients.card_number) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "card_number", "editor": card_number5049 }, { "colIndex": 40, "sortable": true, "xtype": "datecolumn", "format": "d.m.Y", "editable": true, "tooltip": "(newcomers.NewClients.card_valid_from) ", "filter": { "type": "date", "dateFormat": "d.m.Y" }, "header": "ID-Karte g\u00fcltig von", "dataIndex": "card_valid_from", "width": Lino.chars2width(9), "editor": card_valid_from5050 }, { "colIndex": 41, "sortable": true, "xtype": "datecolumn", "format": "d.m.Y", "editable": true, "tooltip": "(newcomers.NewClients.card_valid_until) ", "filter": { "type": "date", "dateFormat": "d.m.Y" }, "header": "bis", "dataIndex": "card_valid_until", "width": Lino.chars2width(9), "editor": card_valid_until5051 }, { "colIndex": 42, "sortable": true, "header": "eID-Kartenart", "editable": true, "tooltip": "(newcomers.NewClients.card_type) ", "filter": { "type": "string" }, "width": Lino.chars2width(25), "dataIndex": "card_type", "editor": card_type5052 }, { "colIndex": 43, "sortable": true, "header": "eID-Karte ausgestellt durch", "editable": true, "tooltip": "(newcomers.NewClients.card_issuer) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "card_issuer", "editor": card_issuer5053 }, { "colIndex": 44, "sortable": true, "header": "Adelstitel", "editable": true, "tooltip": "(newcomers.NewClients.noble_condition) The eventual noble condition of this person. Imported from TIM.", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "noble_condition", "editor": noble_condition5054 }, { "colIndex": 45, "sortable": false, "header": "Bemerkungen (Sozialsekretariat)", "editable": true, "tooltip": "(newcomers.NewClients.remarks2) ", "filter": { "type": "string" }, "width": Lino.chars2width(61), "renderer": Lino.text_renderer, "editor": remarks25055, "dataIndex": "remarks2" }, { "colIndex": 46, "sortable": true, "header": "Gesdos-Nr", "editable": true, "tooltip": "(newcomers.NewClients.gesdos_id) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "gesdos_id", "editor": gesdos_id5056 }, { "colIndex": 47, "sortable": false, "xtype": "checkcolumn", "header": "Sozialhilfeempf\u00e4nger", "editable": true, "tooltip": "(newcomers.NewClients.is_cpas) ", "filter": { "type": "boolean" }, "width": Lino.chars2width(11), "dataIndex": "is_cpas" }, { "colIndex": 48, "sortable": false, "xtype": "checkcolumn", "header": "Altenheim", "editable": true, "tooltip": "(newcomers.NewClients.is_senior) ", "filter": { "type": "boolean" }, "width": Lino.chars2width(11), "dataIndex": "is_senior" }, { "colIndex": 49, "sortable": true, "header": "Integrationsphase", "editable": true, "tooltip": "(newcomers.NewClients.group) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "group", "editor": group5059 }, { "colIndex": 50, "sortable": true, "header": "Geburtsort", "editable": true, "tooltip": "(newcomers.NewClients.birth_place) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "birth_place", "editor": birth_place5060 }, { "colIndex": 51, "sortable": true, "header": "Geburtsland", "editable": true, "tooltip": "(newcomers.NewClients.birth_country) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('birth_countryHidden','Lino.countries.Countries.detail'), "editor": birth_country5061, "dataIndex": "birth_country" }, { "colIndex": 52, "sortable": true, "header": "Zivilstand", "editable": true, "tooltip": "(newcomers.NewClients.civil_state) ", "filter": { "type": "string" }, "width": Lino.chars2width(41), "dataIndex": "civil_state", "editor": civil_state5062 }, { "colIndex": 53, "sortable": true, "header": "Krankenkasse", "editable": true, "tooltip": "(newcomers.NewClients.health_insurance) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('health_insuranceHidden','Lino.contacts.Companies.detail'), "editor": health_insurance5063, "dataIndex": "health_insurance" }, { "colIndex": 54, "sortable": true, "header": "Apotheke", "editable": true, "tooltip": "(newcomers.NewClients.pharmacy) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('pharmacyHidden','Lino.contacts.Companies.detail'), "editor": pharmacy5064, "dataIndex": "pharmacy" }, { "colIndex": 55, "sortable": true, "header": "Register", "editable": true, "tooltip": "(newcomers.NewClients.residence_type) ", "filter": { "type": "string" }, "width": Lino.chars2width(26), "dataIndex": "residence_type", "editor": residence_type5065 }, { "colIndex": 56, "sortable": true, "xtype": "datecolumn", "format": "d.m.Y", "editable": true, "tooltip": "(newcomers.NewClients.in_belgium_since) ", "filter": { "type": "date", "dateFormat": "d.m.Y" }, "header": "Lebt in Belgien seit", "dataIndex": "in_belgium_since", "width": Lino.chars2width(9), "editor": in_belgium_since5066 }, { "colIndex": 57, "sortable": true, "xtype": "datecolumn", "format": "d.m.Y", "editable": true, "tooltip": "(newcomers.NewClients.unemployed_since) ", "filter": { "type": "date", "dateFormat": "d.m.Y" }, "header": "eingetragen seit", "dataIndex": "unemployed_since", "width": Lino.chars2width(9), "editor": unemployed_since5067 }, { "colIndex": 58, "sortable": false, "xtype": "checkcolumn", "header": "Braucht Aufenthaltserlaubnis", "editable": true, "tooltip": "(newcomers.NewClients.needs_residence_permit) ", "filter": { "type": "boolean" }, "width": Lino.chars2width(11), "dataIndex": "needs_residence_permit" }, { "colIndex": 59, "sortable": false, "xtype": "checkcolumn", "header": "Braucht Arb.Erl.", "editable": true, "tooltip": "(newcomers.NewClients.needs_work_permit) ", "filter": { "type": "boolean" }, "width": Lino.chars2width(11), "dataIndex": "needs_work_permit" }, { "colIndex": 60, "sortable": true, "xtype": "datecolumn", "format": "d.m.Y", "editable": true, "tooltip": "(newcomers.NewClients.work_permit_suspended_until) ", "filter": { "type": "date", "dateFormat": "d.m.Y" }, "header": "Wartezeit bis", "dataIndex": "work_permit_suspended_until", "width": Lino.chars2width(9), "editor": work_permit_suspended_until5070 }, { "colIndex": 61, "sortable": false, "xtype": "checkcolumn", "header": "Arbeitslosengeld", "editable": true, "tooltip": "(newcomers.NewClients.income_ag) ", "filter": { "type": "boolean" }, "width": Lino.chars2width(11), "dataIndex": "income_ag" }, { "colIndex": 62, "sortable": false, "xtype": "checkcolumn", "header": "Wartegeld", "editable": true, "tooltip": "(newcomers.NewClients.income_wg) ", "filter": { "type": "boolean" }, "width": Lino.chars2width(11), "dataIndex": "income_wg" }, { "colIndex": 63, "sortable": false, "xtype": "checkcolumn", "header": "Krankengeld", "editable": true, "tooltip": "(newcomers.NewClients.income_kg) ", "filter": { "type": "boolean" }, "width": Lino.chars2width(11), "dataIndex": "income_kg" }, { "colIndex": 64, "sortable": false, "xtype": "checkcolumn", "header": "Rente", "editable": true, "tooltip": "(newcomers.NewClients.income_rente) ", "filter": { "type": "boolean" }, "width": Lino.chars2width(11), "dataIndex": "income_rente" }, { "colIndex": 65, "sortable": false, "xtype": "checkcolumn", "header": "andere Einkommen", "editable": true, "tooltip": "(newcomers.NewClients.income_misc) ", "filter": { "type": "boolean" }, "width": Lino.chars2width(11), "dataIndex": "income_misc" }, { "colIndex": 66, "sortable": false, "xtype": "checkcolumn", "header": "Arbeit suchend", "editable": true, "tooltip": "(newcomers.NewClients.is_seeking) ", "filter": { "type": "boolean" }, "width": Lino.chars2width(11), "dataIndex": "is_seeking" }, { "colIndex": 67, "sortable": true, "xtype": "datecolumn", "format": "d.m.Y", "editable": true, "tooltip": "(newcomers.NewClients.unavailable_until) ", "filter": { "type": "date", "dateFormat": "d.m.Y" }, "header": "Nicht verf\u00fcgbar bis", "dataIndex": "unavailable_until", "width": Lino.chars2width(9), "editor": unavailable_until5077 }, { "colIndex": 68, "sortable": true, "header": "Grund", "editable": true, "tooltip": "(newcomers.NewClients.unavailable_why) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "unavailable_why", "editor": unavailable_why5078 }, { "colIndex": 69, "sortable": false, "header": "Hindernisse", "editable": true, "tooltip": "(newcomers.NewClients.obstacles) ", "filter": { "type": "string" }, "width": Lino.chars2width(61), "renderer": Lino.text_renderer, "editor": obstacles5079, "dataIndex": "obstacles" }, { "colIndex": 70, "sortable": false, "header": "Sonstige F\u00e4higkeiten", "editable": true, "tooltip": "(newcomers.NewClients.skills) ", "filter": { "type": "string" }, "width": Lino.chars2width(61), "renderer": Lino.text_renderer, "editor": skills5080, "dataIndex": "skills" }, { "colIndex": 71, "sortable": true, "header": "Interim-Agenturen", "editable": true, "tooltip": "(newcomers.NewClients.job_agents) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "job_agents", "editor": job_agents5081 }, { "colIndex": 72, "sortable": true, "header": "Kontaktperson ADG", "editable": true, "tooltip": "(newcomers.NewClients.job_office_contact) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "job_office_contact", "editor": job_office_contact5082 }, { "colIndex": 73, "sortable": true, "header": "refusal reason", "editable": true, "tooltip": "(newcomers.NewClients.refusal_reason) ", "filter": { "type": "string" }, "width": Lino.chars2width(44), "dataIndex": "refusal_reason", "editor": refusal_reason5083 } ];
    Lino.newcomers.NewClients.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.newcomers.NewClients.put = function(rp,pk) { 
  Lino.run_row_action(rp,"/newcomers/NewClients","GET",pk,"put",null);
};
Lino.newcomers.NewClients.post = function(rp,pk) { 
  Lino.run_row_action(rp,"/newcomers/NewClients","GET",pk,"post",null);
};

Lino.newcomers.NewClients.insertPanel = Ext.extend(Lino.pcsw.Clients.InsertFormPanel,{
  empty_title: "Neu Neue Klienten",
  hide_navigator: true,
  params_panel_hidden: true,
  ls_bbar_actions: [ { "itemId": "post", "menu_item_text": "Erstellen", "tooltip": "Datensatz erstellen und dann im Detail-Fenster \u00f6ffnen", "panel_btn_handler": function(panel){panel.save(null,true,'post')}, "text": "Erstellen", "overflowText": "Erstellen", "auto_save": false }, { "itemId": "poststay", "menu_item_text": "Erstellen ohne Detail", "tooltip": "Nach Erstellen des Datensatzes kein Detail-Fenster \u00f6ffnen", "panel_btn_handler": function(panel){panel.save(null,false,'poststay')}, "text": "Erstellen ohne Detail", "overflowText": "Erstellen ohne Detail", "auto_save": false } ],
  ls_url: "/newcomers/NewClients",
  action_name: "insert",
  initComponent : function() {
    this.ls_detail_handler = Lino.newcomers.NewClients.detail;
    this.ls_insert_handler = Lino.newcomers.NewClients.insert;
    Lino.newcomers.NewClients.insertPanel.superclass.initComponent.call(this);
  }
});

Lino.newcomers.NewClients.insert = new Lino.WindowAction({ "draggable": true, "width": Lino.chars2width(60), "autoHeight": true, "maximizable": true, "modal": true, "maximized": false },function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.newcomers.NewClients.insertPanel(p);
});
Lino.newcomers.NewClients.wf1 = function(rp,pk) { 
  Lino.run_row_action(rp,"/newcomers/NewClients","GET",pk,"wf1",null);
};
Lino.newcomers.NewClients.poststay = function(rp,pk) { 
  Lino.run_row_action(rp,"/newcomers/NewClients","GET",pk,"poststay",null);
};
Lino.newcomers.NewClients.wf3 = function(rp,pk) { 
  Lino.run_row_action(rp,"/newcomers/NewClients","GET",pk,"wf3",null);
};

Lino.newcomers.NewClients.detailPanel = Ext.extend(Lino.pcsw.Clients.DetailFormPanel,{
  empty_title: "Detail Neue Klienten",
  params_panel_hidden: true,
  ls_bbar_actions: [ { "itemId": "put", "menu_item_text": "Speichern", "tooltip": "\u00c4nderungen in diesem Formular speichern", "panel_btn_handler": function(panel){panel.save(null,false,'put')}, "iconCls": "x-tbar-save", "overflowText": "Speichern", "auto_save": false }, { "itemId": "insert", "menu_item_text": "Neu", "must_save": true, "tooltip": "Neuen Datensatz erstellen", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-new", "overflowText": "Neu", "auto_save": true }, { "itemId": null, "menu_item_text": "L\u00f6schen", "tooltip": "Diesen Datensatz l\u00f6schen", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "L\u00f6schen", "auto_save": false }, { "itemId": "print_eid_content", "menu_item_text": "eID-Inhalt", "must_save": true, "tooltip": "eID-Inhalt", "panel_btn_handler": Lino.row_action_handler('print_eid_content','GET',null), "iconCls": "x-tbar-vcard", "overflowText": "eID-Inhalt", "auto_save": true } ],
  ls_url: "/newcomers/NewClients",
  action_name: "detail",
  initComponent : function() {
    this.ls_detail_handler = Lino.newcomers.NewClients.detail;
    this.ls_insert_handler = Lino.newcomers.NewClients.insert;
    Lino.newcomers.NewClients.detailPanel.superclass.initComponent.call(this);
  }
});

Lino.newcomers.NewClients.detail = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.newcomers.NewClients.detailPanel(p);
});
Lino.newcomers.NewClients.print_eid_content = function(rp,pk) { 
  Lino.run_row_action(rp,"/newcomers/NewClients","GET",pk,"print_eid_content",null);
};
Lino.newcomers.NewClients.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  p.params_panel = new Lino.newcomers.NewClients.ParamsPanel({});
  return new Lino.newcomers.NewClients.GridPanel(p);
});
Lino.newcomers.NewClients.read_beid = function(rp,pk) { 
  Lino.run_row_action(rp,"/newcomers/NewClients","POST",pk,"read_beid",Lino.beid_read_card_processor);
};

// js_render_GridPanel_class newcomers.AvailableCoaches
Lino.newcomers.AvailableCoaches.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "forceFit": true, "emptyText": "Keine Daten anzuzeigen." },
  ls_url : "/newcomers/AvailableCoaches",
  ls_bbar_actions : [ { "itemId": "detail", "menu_item_text": "Detail", "tooltip": "Detail-Fenster auf diesem Datensatz \u00f6ffnen", "panel_btn_handler": Lino.show_detail, "iconCls": "x-tbar-detail", "overflowText": "Detail", "auto_save": true }, { "itemId": "update_reminders", "menu_item_text": "Erinnerungen aktualisieren", "must_save": true, "panel_btn_handler": Lino.row_action_handler('update_reminders','GET',null), "text": "Erinnerungen aktualisieren", "overflowText": "Erinnerungen aktualisieren", "auto_save": true } ],
  title : "Verf\u00fcgbare Begleiter",
  page_length : 20,
  stripeRows : true,
  disable_editing : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "name": "name_column" }, { "name": "workflow_buttons" }, { "name": "primary_clients" }, { "name": "new_clients" }, { "type": "int", "name": "newcomer_quota" }, { "name": "current_weight" }, { "name": "added_weight" }, { "name": "score" }, { "type": "int", "name": "id" }, { "name": "disabled_fields" }, { "name": "disabled_actions" } ],
  pk_index : 8,
  ls_grid_configs : [  ],
  content_type : 7,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 10,
  initComponent : function() {
    this.ls_detail_handler = Lino.newcomers.AvailableCoaches.detail;
    this.ls_insert_handler = Lino.users.Users.insert;
    var ww = this.containing_window;
    var name_column_disp5085 = new Ext.form.DisplayField({ "disabled": true, "value": "<br/>", "always_enabled": true });
    var workflow_buttons_disp5086 = new Ext.form.DisplayField({ "disabled": true, "value": "<br/>", "always_enabled": true });
    var primary_clients5087 = new Ext.form.NumberField({ "disabled": true });
    var new_clients5088 = new Ext.form.NumberField({ "disabled": true });
    var newcomer_quota5089 = new Ext.form.NumberField({ "selectOnFocus": true, "allowBlank": false, "value": 0 });
    var current_weight5090 = new Ext.form.NumberField({ "disabled": true, "allowDecimals": false });
    var added_weight5091 = new Ext.form.NumberField({ "disabled": true, "allowDecimals": false });
    var score5092 = new Ext.form.NumberField({ "disabled": true, "decimalPrecision": 2, "decimalSeparator": "," });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ { "width": Lino.chars2width(16), "colIndex": 0, "sortable": false, "dataIndex": "name_column", "header": "Name", "editable": false, "tooltip": "(newcomers.AvailableCoaches.name_column) " }, { "width": Lino.chars2width(11), "colIndex": 1, "sortable": false, "dataIndex": "workflow_buttons", "header": "Arbeitsablauf", "editable": false, "tooltip": "(newcomers.AvailableCoaches.workflow_buttons) " }, new Lino.NullNumberColumn({ "colIndex": 2, "sortable": false, "format": "0", "editable": false, "tooltip": "(newcomers.AvailableCoaches.primary_clients) ", "header": "Komplette Akten", "dataIndex": "primary_clients", "width": Lino.chars2width(6) }), new Lino.NullNumberColumn({ "colIndex": 3, "sortable": false, "format": "0", "editable": false, "tooltip": "(newcomers.AvailableCoaches.new_clients) ", "header": "Neue Klienten", "dataIndex": "new_clients", "width": Lino.chars2width(6) }), new Lino.NullNumberColumn({ "colIndex": 4, "sortable": true, "format": "0", "editable": true, "tooltip": "(newcomers.AvailableCoaches.newcomer_quota) Wieviel Arbeitszeit dieser Benutzer f\u00fcr Neuantr\u00e4ge zur Verf\u00fcgung steht\n(100 = ganztags, 50 = halbtags, 0 = gar nicht).\nWenn zwei Benutzer die gleiche Belastungspunktzahl haben, \naber einer davon sich nur zu 50% um Neuantr\u00e4ge k\u00fcmmert, \ngilt er als doppelt so belastet wie sein Kollege.\n", "filter": { "type": "numeric" }, "header": "Quote NZ", "dataIndex": "newcomer_quota", "width": Lino.chars2width(6), "editor": newcomer_quota5089 }), new Lino.NullNumberColumn({ "colIndex": 5, "sortable": false, "format": "0/i", "editable": false, "tooltip": "(newcomers.AvailableCoaches.current_weight) Momentane Gesamtbelastung dieses Benutzers durch neue Klienten. \nSumme der Belastungspunkte pro neuem Klient.", "header": "Belastung", "dataIndex": "current_weight", "width": Lino.chars2width(9) }), new Lino.NullNumberColumn({ "colIndex": 6, "sortable": false, "format": "0/i", "editable": false, "tooltip": "(newcomers.AvailableCoaches.added_weight) Mehrbelastung, die dieser Neuantrag im Falle einer Zuweisung diesem Benutzer verursachen w\u00fcrde.", "header": "Mehrbelastung", "dataIndex": "added_weight", "width": Lino.chars2width(9) }), new Lino.NullNumberColumn({ "width": Lino.chars2width(11), "colIndex": 7, "sortable": false, "dataIndex": "score", "header": "Mehrbelastung (%)", "editable": false, "tooltip": "(newcomers.AvailableCoaches.score) Mehrbelastung im Verh\u00e4ltnis zur Gesamtbelastung." }) ];
    Lino.newcomers.AvailableCoaches.GridPanel.superclass.initComponent.call(this);
  }
});


Lino.newcomers.AvailableCoaches.detailPanel = Ext.extend(Lino.users.MySettings.DetailFormPanel,{
  empty_title: "Detail Verf\u00fcgbare Begleiter",
  ls_bbar_actions: [ { "itemId": "update_reminders", "menu_item_text": "Erinnerungen aktualisieren", "must_save": true, "panel_btn_handler": Lino.row_action_handler('update_reminders','GET',null), "text": "Erinnerungen aktualisieren", "overflowText": "Erinnerungen aktualisieren", "auto_save": true } ],
  ls_url: "/newcomers/AvailableCoaches",
  action_name: "detail",
  initComponent : function() {
    this.ls_detail_handler = Lino.newcomers.AvailableCoaches.detail;
    this.ls_insert_handler = Lino.users.Users.insert;
    Lino.newcomers.AvailableCoaches.detailPanel.superclass.initComponent.call(this);
  }
});

Lino.newcomers.AvailableCoaches.detail = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.newcomers.AvailableCoaches.detailPanel(p);
});
Lino.newcomers.AvailableCoaches.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  p.params_panel = new Lino.newcomers.AvailableCoaches.ParamsPanel({});
  return new Lino.newcomers.AvailableCoaches.GridPanel(p);
});
Lino.newcomers.AvailableCoaches.update_reminders = function(rp,pk) { 
  Lino.run_row_action(rp,"/newcomers/AvailableCoaches","GET",pk,"update_reminders",null);
};

// js_render_GridPanel_class cbss.IdentifyPersonRequests
Lino.cbss.IdentifyPersonRequests.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "Keine Daten anzuzeigen." },
  ls_url : "/cbss/IdentifyPersonRequests",
  ls_bbar_actions : [ { "itemId": "insert", "menu_item_text": "Neu", "must_save": true, "tooltip": "Neuen Datensatz erstellen", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-new", "overflowText": "Neu", "auto_save": true }, { "itemId": "duplicate", "menu_item_text": "Duplizieren", "must_save": true, "tooltip": "Duplizieren", "panel_btn_handler": Lino.row_action_handler('duplicate','GET',null), "iconCls": "x-tbar-duplicate", "overflowText": "Duplizieren", "auto_save": true }, { "itemId": "detail", "menu_item_text": "Detail", "tooltip": "Detail-Fenster auf diesem Datensatz \u00f6ffnen", "panel_btn_handler": Lino.show_detail, "iconCls": "x-tbar-detail", "overflowText": "Detail", "auto_save": true }, { "itemId": null, "menu_item_text": "L\u00f6schen", "tooltip": "Diesen Datensatz l\u00f6schen", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "L\u00f6schen", "auto_save": false }, { "itemId": "do_print", "menu_item_text": "Drucken", "must_save": true, "tooltip": "Drucken", "panel_btn_handler": Lino.row_action_handler('do_print','GET',null), "iconCls": "x-tbar-print", "overflowText": "Drucken", "auto_save": true } ],
  title : "IdentifyPerson-Anfragen",
  page_length : 20,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "type": "int", "name": "id" }, { "name": "user" }, 'userHidden', { "name": "person" }, 'personHidden', { "name": "sent" }, { "name": "status" }, 'statusHidden', { "name": "environment" }, { "name": "ticket" }, { "name": "request_xml" }, { "name": "response_xml" }, { "name": "debug_messages" }, { "name": "info_messages" }, { "name": "national_id" }, { "name": "birth_date" }, { "name": "sis_card_no" }, { "name": "id_card_no" }, { "name": "first_name" }, { "name": "last_name" }, { "name": "middle_name" }, { "name": "gender" }, 'genderHidden', { "type": "int", "name": "tolerance" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 0,
  ls_grid_configs : [  ],
  content_type : 92,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 25,
  initComponent : function() {
    this.ls_detail_handler = Lino.cbss.IdentifyPersonRequests.detail;
    this.ls_insert_handler = Lino.cbss.IdentifyPersonRequests.insert;
    var ww = this.containing_window;
    var id5167 = new Ext.form.NumberField({ "selectOnFocus": true });
    var user5168 = new Lino.RemoteComboFieldElement({ "preferred_width": 15, "allowBlank": false, "pageSize": 20, "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cbss/IdentifyPersonRequests/user", "method": "GET" }) }), "emptyText": "Benutzer ausw\u00e4hlen..." });
    var person5169 = new Lino.RemoteComboFieldElement({ "preferred_width": 20, "allowBlank": false, "pageSize": 20, "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cbss/IdentifyPersonRequests/person", "method": "GET" }) }), "emptyText": "Klient ausw\u00e4hlen..." });
    var sent5170 = new Ext.form.DisplayField({ "disabled": true, "value": "<br>" });
    var status5171 = new Lino.ChoicesFieldElement({ "disabled": true, "forceSelection": true, "store": [['','<br>']].concat(Lino.cbss.RequestStates) });
    var environment5172 = new Ext.form.TextField({ "disabled": true, "boxMinWidth": Lino.chars2width(4), "maxLength": 4 });
    var ticket5173 = new Ext.form.TextField({ "disabled": true, "maxLength": 36 });
    var request_xml5174 = new Ext.form.TextArea({ "disabled": true, "growMax": 2000 });
    var response_xml5175 = new Ext.form.TextArea({ "disabled": true, "growMax": 2000 });
    var debug_messages5176 = new Ext.form.TextArea({ "disabled": true, "growMax": 2000 });
    var info_messages5177 = new Ext.form.TextArea({ "disabled": true, "growMax": 2000 });
    var national_id5178 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var birth_date5179 = new Lino.IncompleteDateField({ "selectOnFocus": true, "allowBlank": false });
    var sis_card_no5180 = new Ext.form.TextField({ "selectOnFocus": true, "boxMinWidth": Lino.chars2width(10), "maxLength": 10 });
    var id_card_no5181 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 20 });
    var first_name5182 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var last_name5183 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var middle_name5184 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var gender5185 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "forceSelection": true, "store": [['','<br>']].concat(Lino.lino.Genders) });
    var tolerance5186 = new Ext.form.NumberField({ "selectOnFocus": true, "allowBlank": false, "value": 0 });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ new Lino.NullNumberColumn({ "colIndex": 0, "sortable": true, "format": "0", "editable": true, "tooltip": "(cbss.IdentifyPersonRequests.id) ", "filter": { "type": "numeric" }, "header": "ID", "renderer": Lino.id_renderer, "editor": id5167, "width": Lino.chars2width(6), "dataIndex": "id" }), { "colIndex": 1, "sortable": true, "header": "Autor", "editable": true, "tooltip": "(cbss.IdentifyPersonRequests.user) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "user", "editor": user5168 }, { "colIndex": 2, "sortable": true, "header": "Klient", "editable": true, "tooltip": "(cbss.IdentifyPersonRequests.person) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('personHidden','Lino.pcsw.Clients.detail'), "editor": person5169, "dataIndex": "person" }, { "width": Lino.chars2width(17), "colIndex": 3, "sortable": true, "dataIndex": "sent", "header": "Versendet", "editable": false, "tooltip": "(cbss.IdentifyPersonRequests.sent) The date and time when this request has been executed. \nThis is empty for requests than haven't been sent.\nRead-only." }, { "colIndex": 4, "sortable": true, "header": "Zustand", "editable": false, "tooltip": "(cbss.IdentifyPersonRequests.status) ", "filter": { "type": "string" }, "width": Lino.chars2width(13), "dataIndex": "status" }, { "colIndex": 5, "sortable": true, "header": "T/A/B", "editable": false, "tooltip": "(cbss.IdentifyPersonRequests.environment) ", "filter": { "type": "string" }, "width": Lino.chars2width(6), "dataIndex": "environment" }, { "colIndex": 6, "sortable": true, "header": "Ticket", "editable": false, "tooltip": "(cbss.IdentifyPersonRequests.ticket) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "ticket" }, { "colIndex": 7, "sortable": false, "header": "Abfrage", "editable": false, "tooltip": "(cbss.IdentifyPersonRequests.request_xml) The raw XML string that has (or would have) been sent.", "filter": { "type": "string" }, "width": Lino.chars2width(61), "dataIndex": "request_xml", "renderer": Lino.text_renderer }, { "colIndex": 8, "sortable": false, "header": "Antwort", "editable": false, "tooltip": "(cbss.IdentifyPersonRequests.response_xml) The raw XML response received. \n", "filter": { "type": "string" }, "width": Lino.chars2width(61), "dataIndex": "response_xml", "renderer": Lino.text_renderer }, { "colIndex": 9, "sortable": false, "header": "Debug-Meldungen", "editable": false, "tooltip": "(cbss.IdentifyPersonRequests.debug_messages) ", "filter": { "type": "string" }, "width": Lino.chars2width(61), "dataIndex": "debug_messages", "renderer": Lino.text_renderer }, { "colIndex": 10, "sortable": false, "header": "Info-Meldungen", "editable": false, "tooltip": "(cbss.IdentifyPersonRequests.info_messages) ", "filter": { "type": "string" }, "width": Lino.chars2width(61), "dataIndex": "info_messages", "renderer": Lino.text_renderer }, { "colIndex": 11, "sortable": true, "header": "NR-Nummer", "editable": true, "tooltip": "(cbss.IdentifyPersonRequests.national_id) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "national_id", "editor": national_id5178 }, { "colIndex": 12, "sortable": true, "header": "Geburtsdatum", "editable": true, "tooltip": "(cbss.IdentifyPersonRequests.birth_date) Uncomplete dates are allowed, e.g. \n\"00.00.1980\" means \"some day in 1980\", \n\"00.07.1980\" means \"in July 1980\"\nor \"23.07.0000\" means \"on a 23th of July\".", "filter": { "type": "string" }, "width": Lino.chars2width(13), "dataIndex": "birth_date", "editor": birth_date5179 }, { "colIndex": 13, "sortable": true, "header": "SIS-Karten-Nr", "editable": true, "tooltip": "(cbss.IdentifyPersonRequests.sis_card_no) The number of the SIS card used to authenticate the person.", "filter": { "type": "string" }, "width": Lino.chars2width(12), "dataIndex": "sis_card_no", "editor": sis_card_no5180 }, { "colIndex": 14, "sortable": true, "header": "ID-Karten-Nr", "editable": true, "tooltip": "(cbss.IdentifyPersonRequests.id_card_no) The number of the ID card used to authenticate the person.", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "id_card_no", "editor": id_card_no5181 }, { "colIndex": 15, "sortable": true, "header": "Vorname", "editable": true, "tooltip": "(cbss.IdentifyPersonRequests.first_name) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "first_name", "editor": first_name5182 }, { "colIndex": 16, "sortable": true, "header": "Familienname", "editable": true, "tooltip": "(cbss.IdentifyPersonRequests.last_name) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "last_name", "editor": last_name5183 }, { "colIndex": 17, "sortable": true, "header": "Mittelnamen", "editable": true, "tooltip": "(cbss.IdentifyPersonRequests.middle_name) Whatever this means...", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "middle_name", "editor": middle_name5184 }, { "colIndex": 18, "sortable": true, "header": "Geschlecht", "editable": true, "tooltip": "(cbss.IdentifyPersonRequests.gender) ", "filter": { "type": "string" }, "width": Lino.chars2width(10), "dataIndex": "gender", "editor": gender5185 }, new Lino.NullNumberColumn({ "colIndex": 19, "sortable": true, "format": "0", "editable": true, "tooltip": "(cbss.IdentifyPersonRequests.tolerance) \n      Falls Monat oder Tag des Geburtsdatums unbekannt sind, \n      um wieviel Monate bzw. Tage die Suche nach unten/oben ausgeweitet wird.\n      G\u00fcltige Werte: 0 bis 10.\n      ", "filter": { "type": "numeric" }, "header": "Toleranz", "dataIndex": "tolerance", "width": Lino.chars2width(6), "editor": tolerance5186 }) ];
    Lino.cbss.IdentifyPersonRequests.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.cbss.IdentifyPersonRequests.put = function(rp,pk) { 
  Lino.run_row_action(rp,"/cbss/IdentifyPersonRequests","GET",pk,"put",null);
};
Lino.cbss.IdentifyPersonRequests.post = function(rp,pk) { 
  Lino.run_row_action(rp,"/cbss/IdentifyPersonRequests","GET",pk,"post",null);
};

Lino.cbss.IdentifyPersonRequests.insertPanel = Ext.extend(Lino.cbss.IdentifyPersonRequests.InsertFormPanel,{
  empty_title: "Neu IdentifyPerson-Anfragen",
  hide_navigator: true,
  ls_bbar_actions: [ { "itemId": "post", "menu_item_text": "Erstellen", "tooltip": "Datensatz erstellen und dann im Detail-Fenster \u00f6ffnen", "panel_btn_handler": function(panel){panel.save(null,true,'post')}, "text": "Erstellen", "overflowText": "Erstellen", "auto_save": false }, { "itemId": "poststay", "menu_item_text": "Erstellen ohne Detail", "tooltip": "Nach Erstellen des Datensatzes kein Detail-Fenster \u00f6ffnen", "panel_btn_handler": function(panel){panel.save(null,false,'poststay')}, "text": "Erstellen ohne Detail", "overflowText": "Erstellen ohne Detail", "auto_save": false } ],
  ls_url: "/cbss/IdentifyPersonRequests",
  action_name: "insert",
  initComponent : function() {
    this.ls_detail_handler = Lino.cbss.IdentifyPersonRequests.detail;
    this.ls_insert_handler = Lino.cbss.IdentifyPersonRequests.insert;
    Lino.cbss.IdentifyPersonRequests.insertPanel.superclass.initComponent.call(this);
  }
});

Lino.cbss.IdentifyPersonRequests.insert = new Lino.WindowAction({ "draggable": true, "width": Lino.chars2width(60), "autoHeight": true, "maximizable": true, "modal": true, "maximized": false },function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.cbss.IdentifyPersonRequests.insertPanel(p);
});
Lino.cbss.IdentifyPersonRequests.poststay = function(rp,pk) { 
  Lino.run_row_action(rp,"/cbss/IdentifyPersonRequests","GET",pk,"poststay",null);
};
Lino.cbss.IdentifyPersonRequests.duplicate = function(rp,pk) { 
  Lino.run_row_action(rp,"/cbss/IdentifyPersonRequests","GET",pk,"duplicate",null);
};

Lino.cbss.IdentifyPersonRequests.detailPanel = Ext.extend(Lino.cbss.IdentifyPersonRequests.DetailFormPanel,{
  empty_title: "Detail IdentifyPerson-Anfragen",
  ls_bbar_actions: [ { "itemId": "put", "menu_item_text": "Speichern", "tooltip": "\u00c4nderungen in diesem Formular speichern", "panel_btn_handler": function(panel){panel.save(null,false,'put')}, "iconCls": "x-tbar-save", "overflowText": "Speichern", "auto_save": false }, { "itemId": "insert", "menu_item_text": "Neu", "must_save": true, "tooltip": "Neuen Datensatz erstellen", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-new", "overflowText": "Neu", "auto_save": true }, { "itemId": "duplicate", "menu_item_text": "Duplizieren", "must_save": true, "tooltip": "Duplizieren", "panel_btn_handler": Lino.row_action_handler('duplicate','GET',null), "iconCls": "x-tbar-duplicate", "overflowText": "Duplizieren", "auto_save": true }, { "itemId": null, "menu_item_text": "L\u00f6schen", "tooltip": "Diesen Datensatz l\u00f6schen", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "L\u00f6schen", "auto_save": false }, { "itemId": "do_print", "menu_item_text": "Drucken", "must_save": true, "tooltip": "Drucken", "panel_btn_handler": Lino.row_action_handler('do_print','GET',null), "iconCls": "x-tbar-print", "overflowText": "Drucken", "auto_save": true } ],
  ls_url: "/cbss/IdentifyPersonRequests",
  action_name: "detail",
  initComponent : function() {
    this.ls_detail_handler = Lino.cbss.IdentifyPersonRequests.detail;
    this.ls_insert_handler = Lino.cbss.IdentifyPersonRequests.insert;
    Lino.cbss.IdentifyPersonRequests.detailPanel.superclass.initComponent.call(this);
  }
});

Lino.cbss.IdentifyPersonRequests.detail = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.cbss.IdentifyPersonRequests.detailPanel(p);
});
Lino.cbss.IdentifyPersonRequests.do_print = function(rp,pk) { 
  Lino.run_row_action(rp,"/cbss/IdentifyPersonRequests","GET",pk,"do_print",null);
};
Lino.cbss.IdentifyPersonRequests.edit_template = function(rp,pk) { 
  Lino.run_row_action(rp,"/cbss/IdentifyPersonRequests","GET",pk,"edit_template",null);
};
Lino.cbss.IdentifyPersonRequests.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.cbss.IdentifyPersonRequests.GridPanel(p);
});

// js_render_GridPanel_class cbss.ManageAccessRequests
Lino.cbss.ManageAccessRequests.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "Keine Daten anzuzeigen." },
  ls_url : "/cbss/ManageAccessRequests",
  ls_bbar_actions : [ { "itemId": "insert", "menu_item_text": "Neu", "must_save": true, "tooltip": "Neuen Datensatz erstellen", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-new", "overflowText": "Neu", "auto_save": true }, { "itemId": "duplicate", "menu_item_text": "Duplizieren", "must_save": true, "tooltip": "Duplizieren", "panel_btn_handler": Lino.row_action_handler('duplicate','GET',null), "iconCls": "x-tbar-duplicate", "overflowText": "Duplizieren", "auto_save": true }, { "itemId": "detail", "menu_item_text": "Detail", "tooltip": "Detail-Fenster auf diesem Datensatz \u00f6ffnen", "panel_btn_handler": Lino.show_detail, "iconCls": "x-tbar-detail", "overflowText": "Detail", "auto_save": true }, { "itemId": null, "menu_item_text": "L\u00f6schen", "tooltip": "Diesen Datensatz l\u00f6schen", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "L\u00f6schen", "auto_save": false }, { "itemId": "do_print", "menu_item_text": "Drucken", "must_save": true, "tooltip": "Drucken", "panel_btn_handler": Lino.row_action_handler('do_print','GET',null), "iconCls": "x-tbar-print", "overflowText": "Drucken", "auto_save": true } ],
  title : "ManageAccess-Anfragen",
  page_length : 20,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "type": "int", "name": "id" }, { "name": "user" }, 'userHidden', { "name": "person" }, 'personHidden', { "name": "sent" }, { "name": "status" }, 'statusHidden', { "name": "environment" }, { "name": "ticket" }, { "name": "request_xml" }, { "name": "response_xml" }, { "name": "debug_messages" }, { "name": "info_messages" }, { "name": "national_id" }, { "name": "birth_date" }, { "name": "sis_card_no" }, { "name": "id_card_no" }, { "name": "first_name" }, { "name": "last_name" }, { "name": "sector" }, 'sectorHidden', { "name": "purpose" }, 'purposeHidden', { "type": "date", "name": "start_date", "dateFormat": "d.m.Y" }, { "type": "date", "name": "end_date", "dateFormat": "d.m.Y" }, { "name": "action" }, 'actionHidden', { "name": "query_register" }, 'query_registerHidden', { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 0,
  ls_grid_configs : [  ],
  content_type : 90,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 31,
  initComponent : function() {
    this.ls_detail_handler = Lino.cbss.ManageAccessRequests.detail;
    this.ls_insert_handler = Lino.cbss.ManageAccessRequests.insert;
    var ww = this.containing_window;
    var id5188 = new Ext.form.NumberField({ "selectOnFocus": true });
    var user5189 = new Lino.RemoteComboFieldElement({ "preferred_width": 15, "allowBlank": false, "pageSize": 20, "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cbss/ManageAccessRequests/user", "method": "GET" }) }), "emptyText": "Benutzer ausw\u00e4hlen..." });
    var person5190 = new Lino.RemoteComboFieldElement({ "preferred_width": 20, "allowBlank": false, "pageSize": 20, "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cbss/ManageAccessRequests/person", "method": "GET" }) }), "emptyText": "Klient ausw\u00e4hlen..." });
    var sent5191 = new Ext.form.DisplayField({ "disabled": true, "value": "<br>" });
    var status5192 = new Lino.ChoicesFieldElement({ "disabled": true, "forceSelection": true, "store": [['','<br>']].concat(Lino.cbss.RequestStates) });
    var environment5193 = new Ext.form.TextField({ "disabled": true, "boxMinWidth": Lino.chars2width(4), "maxLength": 4 });
    var ticket5194 = new Ext.form.TextField({ "disabled": true, "maxLength": 36 });
    var request_xml5195 = new Ext.form.TextArea({ "disabled": true, "growMax": 2000 });
    var response_xml5196 = new Ext.form.TextArea({ "disabled": true, "growMax": 2000 });
    var debug_messages5197 = new Ext.form.TextArea({ "disabled": true, "growMax": 2000 });
    var info_messages5198 = new Ext.form.TextArea({ "disabled": true, "growMax": 2000 });
    var national_id5199 = new Ext.form.TextField({ "selectOnFocus": true, "allowBlank": false, "maxLength": 200 });
    var birth_date5200 = new Lino.IncompleteDateField({ "selectOnFocus": true });
    var sis_card_no5201 = new Ext.form.TextField({ "selectOnFocus": true, "boxMinWidth": Lino.chars2width(10), "maxLength": 10 });
    var id_card_no5202 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 20 });
    var first_name5203 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var last_name5204 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var sector5205 = new Lino.RemoteComboFieldElement({ "disabled": true, "store": new Lino.ComplexRemoteComboStore({  }), "pageSize": 20, "emptyText": "Sektor ausw\u00e4hlen..." });
    var purpose5206 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cbss/ManageAccessRequests/purpose", "method": "GET" }) }), "allowBlank": false, "pageSize": 20, "emptyText": "Eigenschafts-Code ausw\u00e4hlen..." });
    var start_date5207 = new Lino.DateField({ "selectOnFocus": true, "allowBlank": false });
    var end_date5208 = new Lino.DateField({ "selectOnFocus": true, "allowBlank": false });
    var action5209 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "forceSelection": true, "allowBlank": false, "store": Lino.cbss.ManageAction });
    var query_register5210 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "forceSelection": true, "allowBlank": false, "store": Lino.cbss.QueryRegister });
    this.before_row_edit = function(record) {
      purpose5206.setContextValue('sector',record ? record.data['sectorHidden'] : undefined);
    };
    this.onRender = function(ct, position) {
      sector5205.on('change',Lino.chooser_handler(purpose5206,'sector'));
      Lino.cbss.ManageAccessRequests.GridPanel.superclass.onRender.call(this, ct, position);
    }
    this.ls_columns = [ new Lino.NullNumberColumn({ "colIndex": 0, "sortable": true, "format": "0", "editable": true, "tooltip": "(cbss.ManageAccessRequests.id) ", "filter": { "type": "numeric" }, "header": "ID", "renderer": Lino.id_renderer, "editor": id5188, "width": Lino.chars2width(6), "dataIndex": "id" }), { "colIndex": 1, "sortable": true, "header": "Autor", "editable": true, "tooltip": "(cbss.ManageAccessRequests.user) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "user", "editor": user5189 }, { "colIndex": 2, "sortable": true, "header": "Klient", "editable": true, "tooltip": "(cbss.ManageAccessRequests.person) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('personHidden','Lino.pcsw.Clients.detail'), "editor": person5190, "dataIndex": "person" }, { "width": Lino.chars2width(17), "colIndex": 3, "sortable": true, "dataIndex": "sent", "header": "Versendet", "editable": false, "tooltip": "(cbss.ManageAccessRequests.sent) The date and time when this request has been executed. \nThis is empty for requests than haven't been sent.\nRead-only." }, { "colIndex": 4, "sortable": true, "header": "Zustand", "editable": false, "tooltip": "(cbss.ManageAccessRequests.status) ", "filter": { "type": "string" }, "width": Lino.chars2width(13), "dataIndex": "status" }, { "colIndex": 5, "sortable": true, "header": "T/A/B", "editable": false, "tooltip": "(cbss.ManageAccessRequests.environment) ", "filter": { "type": "string" }, "width": Lino.chars2width(6), "dataIndex": "environment" }, { "colIndex": 6, "sortable": true, "header": "Ticket", "editable": false, "tooltip": "(cbss.ManageAccessRequests.ticket) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "ticket" }, { "colIndex": 7, "sortable": false, "header": "Abfrage", "editable": false, "tooltip": "(cbss.ManageAccessRequests.request_xml) The raw XML string that has (or would have) been sent.", "filter": { "type": "string" }, "width": Lino.chars2width(61), "dataIndex": "request_xml", "renderer": Lino.text_renderer }, { "colIndex": 8, "sortable": false, "header": "Antwort", "editable": false, "tooltip": "(cbss.ManageAccessRequests.response_xml) The raw XML response received. \n", "filter": { "type": "string" }, "width": Lino.chars2width(61), "dataIndex": "response_xml", "renderer": Lino.text_renderer }, { "colIndex": 9, "sortable": false, "header": "Debug-Meldungen", "editable": false, "tooltip": "(cbss.ManageAccessRequests.debug_messages) ", "filter": { "type": "string" }, "width": Lino.chars2width(61), "dataIndex": "debug_messages", "renderer": Lino.text_renderer }, { "colIndex": 10, "sortable": false, "header": "Info-Meldungen", "editable": false, "tooltip": "(cbss.ManageAccessRequests.info_messages) ", "filter": { "type": "string" }, "width": Lino.chars2width(61), "dataIndex": "info_messages", "renderer": Lino.text_renderer }, { "colIndex": 11, "sortable": true, "header": "NR-Nummer", "editable": true, "tooltip": "(cbss.ManageAccessRequests.national_id) The SSIN of the person to register/unregister/list.\n", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "national_id", "editor": national_id5199 }, { "colIndex": 12, "sortable": true, "header": "Geburtsdatum", "editable": true, "tooltip": "(cbss.ManageAccessRequests.birth_date) Uncomplete dates are allowed, e.g. \n\"00.00.1980\" means \"some day in 1980\", \n\"00.07.1980\" means \"in July 1980\"\nor \"23.07.0000\" means \"on a 23th of July\".", "filter": { "type": "string" }, "width": Lino.chars2width(13), "dataIndex": "birth_date", "editor": birth_date5200 }, { "colIndex": 13, "sortable": true, "header": "SIS-Karten-Nr", "editable": true, "tooltip": "(cbss.ManageAccessRequests.sis_card_no) The number of the SIS card used to authenticate the person.", "filter": { "type": "string" }, "width": Lino.chars2width(12), "dataIndex": "sis_card_no", "editor": sis_card_no5201 }, { "colIndex": 14, "sortable": true, "header": "ID-Karten-Nr", "editable": true, "tooltip": "(cbss.ManageAccessRequests.id_card_no) The number of the ID card used to authenticate the person.", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "id_card_no", "editor": id_card_no5202 }, { "colIndex": 15, "sortable": true, "header": "Vorname", "editable": true, "tooltip": "(cbss.ManageAccessRequests.first_name) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "first_name", "editor": first_name5203 }, { "colIndex": 16, "sortable": true, "header": "Familienname", "editable": true, "tooltip": "(cbss.ManageAccessRequests.last_name) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "last_name", "editor": last_name5204 }, { "colIndex": 17, "sortable": true, "header": "Sektor", "editable": false, "tooltip": "(cbss.ManageAccessRequests.sector) For register and unregister this element is ignored. \nIt can be used for list, \nwhen information about sectors is required.", "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "sector" }, { "colIndex": 18, "sortable": true, "header": "Eigenschafts-Code", "editable": true, "tooltip": "(cbss.ManageAccessRequests.purpose) The purpose for which the inscription needs to be \nregistered/unregistered or listed. \nFor listing this field is optional, \nfor register/unregister it is mandatory.", "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "purpose", "editor": purpose5206 }, { "colIndex": 19, "sortable": true, "xtype": "datecolumn", "format": "d.m.Y", "editable": true, "tooltip": "(cbss.ManageAccessRequests.start_date) ", "filter": { "type": "date", "dateFormat": "d.m.Y" }, "header": "Periode vom", "dataIndex": "start_date", "width": Lino.chars2width(9), "editor": start_date5207 }, { "colIndex": 20, "sortable": true, "xtype": "datecolumn", "format": "d.m.Y", "editable": true, "tooltip": "(cbss.ManageAccessRequests.end_date) ", "filter": { "type": "date", "dateFormat": "d.m.Y" }, "header": "Periode bis", "dataIndex": "end_date", "width": Lino.chars2width(9), "editor": end_date5208 }, { "colIndex": 21, "sortable": true, "header": "Aktion", "editable": true, "tooltip": "(cbss.ManageAccessRequests.action) ", "filter": { "type": "string" }, "width": Lino.chars2width(14), "dataIndex": "action", "editor": action5209 }, { "colIndex": 22, "sortable": true, "header": "Abfrageregister", "editable": true, "tooltip": "(cbss.ManageAccessRequests.query_register) ", "filter": { "type": "string" }, "width": Lino.chars2width(13), "dataIndex": "query_register", "editor": query_register5210 } ];
    Lino.cbss.ManageAccessRequests.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.cbss.ManageAccessRequests.put = function(rp,pk) { 
  Lino.run_row_action(rp,"/cbss/ManageAccessRequests","GET",pk,"put",null);
};
Lino.cbss.ManageAccessRequests.post = function(rp,pk) { 
  Lino.run_row_action(rp,"/cbss/ManageAccessRequests","GET",pk,"post",null);
};

Lino.cbss.ManageAccessRequests.insertPanel = Ext.extend(Lino.cbss.ManageAccessRequests.InsertFormPanel,{
  empty_title: "Neu ManageAccess-Anfragen",
  hide_navigator: true,
  ls_bbar_actions: [ { "itemId": "post", "menu_item_text": "Erstellen", "tooltip": "Datensatz erstellen und dann im Detail-Fenster \u00f6ffnen", "panel_btn_handler": function(panel){panel.save(null,true,'post')}, "text": "Erstellen", "overflowText": "Erstellen", "auto_save": false }, { "itemId": "poststay", "menu_item_text": "Erstellen ohne Detail", "tooltip": "Nach Erstellen des Datensatzes kein Detail-Fenster \u00f6ffnen", "panel_btn_handler": function(panel){panel.save(null,false,'poststay')}, "text": "Erstellen ohne Detail", "overflowText": "Erstellen ohne Detail", "auto_save": false } ],
  ls_url: "/cbss/ManageAccessRequests",
  action_name: "insert",
  initComponent : function() {
    this.ls_detail_handler = Lino.cbss.ManageAccessRequests.detail;
    this.ls_insert_handler = Lino.cbss.ManageAccessRequests.insert;
    Lino.cbss.ManageAccessRequests.insertPanel.superclass.initComponent.call(this);
  }
});

Lino.cbss.ManageAccessRequests.insert = new Lino.WindowAction({ "draggable": true, "width": Lino.chars2width(60), "autoHeight": true, "maximizable": true, "modal": true, "maximized": false },function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.cbss.ManageAccessRequests.insertPanel(p);
});
Lino.cbss.ManageAccessRequests.poststay = function(rp,pk) { 
  Lino.run_row_action(rp,"/cbss/ManageAccessRequests","GET",pk,"poststay",null);
};
Lino.cbss.ManageAccessRequests.duplicate = function(rp,pk) { 
  Lino.run_row_action(rp,"/cbss/ManageAccessRequests","GET",pk,"duplicate",null);
};

Lino.cbss.ManageAccessRequests.detailPanel = Ext.extend(Lino.cbss.ManageAccessRequests.DetailFormPanel,{
  empty_title: "Detail ManageAccess-Anfragen",
  ls_bbar_actions: [ { "itemId": "put", "menu_item_text": "Speichern", "tooltip": "\u00c4nderungen in diesem Formular speichern", "panel_btn_handler": function(panel){panel.save(null,false,'put')}, "iconCls": "x-tbar-save", "overflowText": "Speichern", "auto_save": false }, { "itemId": "insert", "menu_item_text": "Neu", "must_save": true, "tooltip": "Neuen Datensatz erstellen", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-new", "overflowText": "Neu", "auto_save": true }, { "itemId": "duplicate", "menu_item_text": "Duplizieren", "must_save": true, "tooltip": "Duplizieren", "panel_btn_handler": Lino.row_action_handler('duplicate','GET',null), "iconCls": "x-tbar-duplicate", "overflowText": "Duplizieren", "auto_save": true }, { "itemId": null, "menu_item_text": "L\u00f6schen", "tooltip": "Diesen Datensatz l\u00f6schen", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "L\u00f6schen", "auto_save": false }, { "itemId": "do_print", "menu_item_text": "Drucken", "must_save": true, "tooltip": "Drucken", "panel_btn_handler": Lino.row_action_handler('do_print','GET',null), "iconCls": "x-tbar-print", "overflowText": "Drucken", "auto_save": true } ],
  ls_url: "/cbss/ManageAccessRequests",
  action_name: "detail",
  initComponent : function() {
    this.ls_detail_handler = Lino.cbss.ManageAccessRequests.detail;
    this.ls_insert_handler = Lino.cbss.ManageAccessRequests.insert;
    Lino.cbss.ManageAccessRequests.detailPanel.superclass.initComponent.call(this);
  }
});

Lino.cbss.ManageAccessRequests.detail = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.cbss.ManageAccessRequests.detailPanel(p);
});
Lino.cbss.ManageAccessRequests.do_print = function(rp,pk) { 
  Lino.run_row_action(rp,"/cbss/ManageAccessRequests","GET",pk,"do_print",null);
};
Lino.cbss.ManageAccessRequests.edit_template = function(rp,pk) { 
  Lino.run_row_action(rp,"/cbss/ManageAccessRequests","GET",pk,"edit_template",null);
};
Lino.cbss.ManageAccessRequests.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.cbss.ManageAccessRequests.GridPanel(p);
});

// js_render_GridPanel_class cbss.RetrieveTIGroupsRequests
Lino.cbss.RetrieveTIGroupsRequests.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "Keine Daten anzuzeigen." },
  ls_url : "/cbss/RetrieveTIGroupsRequests",
  ls_bbar_actions : [ { "itemId": "insert", "menu_item_text": "Neu", "must_save": true, "tooltip": "Neuen Datensatz erstellen", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-new", "overflowText": "Neu", "auto_save": true }, { "itemId": "duplicate", "menu_item_text": "Duplizieren", "must_save": true, "tooltip": "Duplizieren", "panel_btn_handler": Lino.row_action_handler('duplicate','GET',null), "iconCls": "x-tbar-duplicate", "overflowText": "Duplizieren", "auto_save": true }, { "itemId": "detail", "menu_item_text": "Detail", "tooltip": "Detail-Fenster auf diesem Datensatz \u00f6ffnen", "panel_btn_handler": Lino.show_detail, "iconCls": "x-tbar-detail", "overflowText": "Detail", "auto_save": true }, { "itemId": null, "menu_item_text": "L\u00f6schen", "tooltip": "Diesen Datensatz l\u00f6schen", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "L\u00f6schen", "auto_save": false }, { "itemId": "do_print", "menu_item_text": "Drucken", "must_save": true, "tooltip": "Drucken", "panel_btn_handler": Lino.row_action_handler('do_print','GET',null), "iconCls": "x-tbar-print", "overflowText": "Drucken", "auto_save": true } ],
  title : "Tx25-Anfragen",
  page_length : 20,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "type": "int", "name": "id" }, { "name": "user" }, 'userHidden', { "name": "person" }, 'personHidden', { "name": "national_id" }, { "name": "language" }, 'languageHidden', { "type": "boolean", "name": "history" }, { "name": "status" }, 'statusHidden', { "name": "ticket" }, { "name": "sent" }, { "name": "environment" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 0,
  ls_grid_configs : [  ],
  content_type : 89,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 15,
  initComponent : function() {
    this.ls_detail_handler = Lino.cbss.RetrieveTIGroupsRequests.detail;
    this.ls_insert_handler = Lino.cbss.RetrieveTIGroupsRequests.insert;
    var ww = this.containing_window;
    var id5212 = new Ext.form.NumberField({ "selectOnFocus": true });
    var user5213 = new Lino.RemoteComboFieldElement({ "preferred_width": 15, "allowBlank": false, "pageSize": 20, "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cbss/RetrieveTIGroupsRequests/user", "method": "GET" }) }), "emptyText": "Benutzer ausw\u00e4hlen..." });
    var person5214 = new Lino.RemoteComboFieldElement({ "preferred_width": 20, "allowBlank": false, "pageSize": 20, "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cbss/RetrieveTIGroupsRequests/person", "method": "GET" }) }), "emptyText": "Klient ausw\u00e4hlen..." });
    var national_id5215 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var language5216 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "forceSelection": true, "store": [['','<br>']].concat(Lino.cbss.RequestLanguages) });
    var history5217 = new Ext.form.Checkbox({ "selectOnFocus": true, "checked": true });
    var status5218 = new Lino.ChoicesFieldElement({ "disabled": true, "forceSelection": true, "store": [['','<br>']].concat(Lino.cbss.RequestStates) });
    var ticket5219 = new Ext.form.TextField({ "disabled": true, "maxLength": 36 });
    var sent5220 = new Ext.form.DisplayField({ "disabled": true, "value": "<br>" });
    var environment5221 = new Ext.form.TextField({ "disabled": true, "boxMinWidth": Lino.chars2width(4), "maxLength": 4 });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ new Lino.NullNumberColumn({ "colIndex": 0, "sortable": true, "format": "0", "editable": true, "tooltip": "(cbss.RetrieveTIGroupsRequests.id) ", "filter": { "type": "numeric" }, "header": "ID", "renderer": Lino.id_renderer, "editor": id5212, "width": Lino.chars2width(6), "dataIndex": "id" }), { "colIndex": 1, "sortable": true, "header": "Autor", "editable": true, "tooltip": "(cbss.RetrieveTIGroupsRequests.user) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "user", "editor": user5213 }, { "colIndex": 2, "sortable": true, "header": "Klient", "editable": true, "tooltip": "(cbss.RetrieveTIGroupsRequests.person) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('personHidden','Lino.pcsw.Clients.detail'), "editor": person5214, "dataIndex": "person" }, { "colIndex": 3, "sortable": true, "header": "NR-Nummer", "editable": true, "tooltip": "(cbss.RetrieveTIGroupsRequests.national_id) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "national_id", "editor": national_id5215 }, { "colIndex": 4, "sortable": true, "header": "Sprache", "editable": true, "tooltip": "(cbss.RetrieveTIGroupsRequests.language) ", "filter": { "type": "string" }, "width": Lino.chars2width(10), "dataIndex": "language", "editor": language5216 }, { "colIndex": 5, "sortable": false, "xtype": "checkcolumn", "header": "Historie", "editable": true, "tooltip": "(cbss.RetrieveTIGroupsRequests.history) Whatever this means.", "filter": { "type": "boolean" }, "width": Lino.chars2width(11), "dataIndex": "history" }, { "colIndex": 6, "sortable": true, "header": "Zustand", "editable": false, "tooltip": "(cbss.RetrieveTIGroupsRequests.status) ", "filter": { "type": "string" }, "width": Lino.chars2width(13), "dataIndex": "status" }, { "colIndex": 7, "sortable": true, "header": "Ticket", "editable": false, "tooltip": "(cbss.RetrieveTIGroupsRequests.ticket) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "ticket" }, { "width": Lino.chars2width(17), "colIndex": 8, "sortable": true, "dataIndex": "sent", "header": "Versendet", "editable": false, "tooltip": "(cbss.RetrieveTIGroupsRequests.sent) The date and time when this request has been executed. \nThis is empty for requests than haven't been sent.\nRead-only." }, { "colIndex": 9, "sortable": true, "header": "T/A/B", "editable": false, "tooltip": "(cbss.RetrieveTIGroupsRequests.environment) ", "filter": { "type": "string" }, "width": Lino.chars2width(6), "dataIndex": "environment" } ];
    Lino.cbss.RetrieveTIGroupsRequests.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.cbss.RetrieveTIGroupsRequests.put = function(rp,pk) { 
  Lino.run_row_action(rp,"/cbss/RetrieveTIGroupsRequests","GET",pk,"put",null);
};
Lino.cbss.RetrieveTIGroupsRequests.post = function(rp,pk) { 
  Lino.run_row_action(rp,"/cbss/RetrieveTIGroupsRequests","GET",pk,"post",null);
};

Lino.cbss.RetrieveTIGroupsRequests.insertPanel = Ext.extend(Lino.cbss.RetrieveTIGroupsRequests.InsertFormPanel,{
  empty_title: "Neu Tx25-Anfragen",
  hide_navigator: true,
  ls_bbar_actions: [ { "itemId": "post", "menu_item_text": "Erstellen", "tooltip": "Datensatz erstellen und dann im Detail-Fenster \u00f6ffnen", "panel_btn_handler": function(panel){panel.save(null,true,'post')}, "text": "Erstellen", "overflowText": "Erstellen", "auto_save": false }, { "itemId": "poststay", "menu_item_text": "Erstellen ohne Detail", "tooltip": "Nach Erstellen des Datensatzes kein Detail-Fenster \u00f6ffnen", "panel_btn_handler": function(panel){panel.save(null,false,'poststay')}, "text": "Erstellen ohne Detail", "overflowText": "Erstellen ohne Detail", "auto_save": false } ],
  ls_url: "/cbss/RetrieveTIGroupsRequests",
  action_name: "insert",
  initComponent : function() {
    this.ls_detail_handler = Lino.cbss.RetrieveTIGroupsRequests.detail;
    this.ls_insert_handler = Lino.cbss.RetrieveTIGroupsRequests.insert;
    Lino.cbss.RetrieveTIGroupsRequests.insertPanel.superclass.initComponent.call(this);
  }
});

Lino.cbss.RetrieveTIGroupsRequests.insert = new Lino.WindowAction({ "draggable": true, "width": Lino.chars2width(40), "autoHeight": true, "maximizable": true, "modal": true, "maximized": false },function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.cbss.RetrieveTIGroupsRequests.insertPanel(p);
});
Lino.cbss.RetrieveTIGroupsRequests.poststay = function(rp,pk) { 
  Lino.run_row_action(rp,"/cbss/RetrieveTIGroupsRequests","GET",pk,"poststay",null);
};
Lino.cbss.RetrieveTIGroupsRequests.duplicate = function(rp,pk) { 
  Lino.run_row_action(rp,"/cbss/RetrieveTIGroupsRequests","GET",pk,"duplicate",null);
};

Lino.cbss.RetrieveTIGroupsRequests.detailPanel = Ext.extend(Lino.cbss.RetrieveTIGroupsRequests.DetailFormPanel,{
  empty_title: "Detail Tx25-Anfragen",
  ls_bbar_actions: [ { "itemId": "put", "menu_item_text": "Speichern", "tooltip": "\u00c4nderungen in diesem Formular speichern", "panel_btn_handler": function(panel){panel.save(null,false,'put')}, "iconCls": "x-tbar-save", "overflowText": "Speichern", "auto_save": false }, { "itemId": "insert", "menu_item_text": "Neu", "must_save": true, "tooltip": "Neuen Datensatz erstellen", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-new", "overflowText": "Neu", "auto_save": true }, { "itemId": "duplicate", "menu_item_text": "Duplizieren", "must_save": true, "tooltip": "Duplizieren", "panel_btn_handler": Lino.row_action_handler('duplicate','GET',null), "iconCls": "x-tbar-duplicate", "overflowText": "Duplizieren", "auto_save": true }, { "itemId": null, "menu_item_text": "L\u00f6schen", "tooltip": "Diesen Datensatz l\u00f6schen", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "L\u00f6schen", "auto_save": false }, { "itemId": "do_print", "menu_item_text": "Drucken", "must_save": true, "tooltip": "Drucken", "panel_btn_handler": Lino.row_action_handler('do_print','GET',null), "iconCls": "x-tbar-print", "overflowText": "Drucken", "auto_save": true } ],
  ls_url: "/cbss/RetrieveTIGroupsRequests",
  action_name: "detail",
  initComponent : function() {
    this.ls_detail_handler = Lino.cbss.RetrieveTIGroupsRequests.detail;
    this.ls_insert_handler = Lino.cbss.RetrieveTIGroupsRequests.insert;
    Lino.cbss.RetrieveTIGroupsRequests.detailPanel.superclass.initComponent.call(this);
  }
});

Lino.cbss.RetrieveTIGroupsRequests.detail = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.cbss.RetrieveTIGroupsRequests.detailPanel(p);
});
Lino.cbss.RetrieveTIGroupsRequests.do_print = function(rp,pk) { 
  Lino.run_row_action(rp,"/cbss/RetrieveTIGroupsRequests","GET",pk,"do_print",null);
};
Lino.cbss.RetrieveTIGroupsRequests.edit_template = function(rp,pk) { 
  Lino.run_row_action(rp,"/cbss/RetrieveTIGroupsRequests","GET",pk,"edit_template",null);
};
Lino.cbss.RetrieveTIGroupsRequests.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.cbss.RetrieveTIGroupsRequests.GridPanel(p);
});

// js_render_GridPanel_class sessions.SessionTable
Lino.sessions.SessionTable.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "Keine Daten anzuzeigen." },
  ls_url : "/sessions/SessionTable",
  ls_bbar_actions : [ { "itemId": null, "menu_item_text": "L\u00f6schen", "tooltip": "Diesen Datensatz l\u00f6schen", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "L\u00f6schen", "auto_save": false } ],
  title : "Sitzungen",
  page_length : 20,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "name": "session_key" }, { "name": "session_data" }, { "name": "expire_date" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 0,
  ls_grid_configs : [  ],
  content_type : 1,
  ls_id_property : "session_key",
  gc_name : 0,
  disabled_actions_index : 4,
  initComponent : function() {
    var ww = this.containing_window;
    var session_key5223 = new Ext.form.TextField({ "selectOnFocus": true, "allowBlank": false, "maxLength": 40 });
    var session_data5224 = new Ext.form.TextArea({ "selectOnFocus": true, "allowBlank": false, "growMax": 2000 });
    var expire_date5225 = new Ext.form.DisplayField({ "selectOnFocus": true, "allowBlank": false, "value": "<br>" });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ { "colIndex": 0, "sortable": true, "header": "Sitzungs-ID", "editable": true, "tooltip": "(sessions.SessionTable.session_key) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "session_key", "editor": session_key5223 }, { "colIndex": 1, "sortable": false, "header": "Sitzungsdaten", "editable": true, "tooltip": "(sessions.SessionTable.session_data) ", "filter": { "type": "string" }, "width": Lino.chars2width(61), "renderer": Lino.text_renderer, "editor": session_data5224, "dataIndex": "session_data" }, { "colIndex": 2, "sortable": true, "header": "Verfallsdatum", "editable": true, "tooltip": "(sessions.SessionTable.expire_date) ", "width": Lino.chars2width(17), "dataIndex": "expire_date", "editor": expire_date5225 } ];
    Lino.sessions.SessionTable.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.sessions.SessionTable.put = function(rp,pk) { 
  Lino.run_row_action(rp,"/sessions/SessionTable","GET",pk,"put",null);
};
Lino.sessions.SessionTable.post = function(rp,pk) { 
  Lino.run_row_action(rp,"/sessions/SessionTable","GET",pk,"post",null);
};
Lino.sessions.SessionTable.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.sessions.SessionTable.GridPanel(p);
});

// js_render_GridPanel_class system.MyTextFieldTemplates
Lino.system.MyTextFieldTemplates.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "Keine Daten anzuzeigen." },
  ls_url : "/system/MyTextFieldTemplates",
  ls_bbar_actions : [ { "itemId": "insert", "menu_item_text": "Neu", "must_save": true, "tooltip": "Neuen Datensatz erstellen", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-new", "overflowText": "Neu", "auto_save": true }, { "itemId": "detail", "menu_item_text": "Detail", "tooltip": "Detail-Fenster auf diesem Datensatz \u00f6ffnen", "panel_btn_handler": Lino.show_detail, "iconCls": "x-tbar-detail", "overflowText": "Detail", "auto_save": true }, { "itemId": null, "menu_item_text": "L\u00f6schen", "tooltip": "Diesen Datensatz l\u00f6schen", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "L\u00f6schen", "auto_save": false } ],
  title : "Meine Einf\u00fcgetexte",
  page_length : 20,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "type": "int", "name": "id" }, { "name": "name" }, { "name": "description" }, { "name": "team" }, 'teamHidden', { "name": "text" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 0,
  ls_grid_configs : [  ],
  content_type : 2,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 7,
  initComponent : function() {
    this.ls_detail_handler = Lino.system.MyTextFieldTemplates.detail;
    this.ls_insert_handler = Lino.system.MyTextFieldTemplates.insert;
    var ww = this.containing_window;
    var id5227 = new Ext.form.NumberField({ "selectOnFocus": true });
    var name5228 = new Ext.form.TextField({ "selectOnFocus": true, "allowBlank": false, "maxLength": 200 });
    var description5229 = new Ext.form.TextArea({ "selectOnFocus": true, "growMax": 2000 });
    var team5230 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/system/MyTextFieldTemplates/team", "method": "GET" }) }), "pageSize": 20, "emptyText": "Team ausw\u00e4hlen..." });
    var text5231 = new Lino.RichTextPanel({ "selectOnFocus": true, "containing_panel": this, "title": "Vorlagentext" });
    this.before_row_edit = function(record) {
      text5231.refresh();
    };
    this.ls_columns = [ new Lino.NullNumberColumn({ "colIndex": 0, "sortable": true, "format": "0", "editable": true, "tooltip": "(system.MyTextFieldTemplates.id) ", "filter": { "type": "numeric" }, "header": "ID", "renderer": Lino.id_renderer, "editor": id5227, "width": Lino.chars2width(6), "dataIndex": "id" }), { "colIndex": 1, "sortable": true, "header": "Bezeichnung", "editable": true, "tooltip": "(system.MyTextFieldTemplates.name) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "name", "editor": name5228 }, { "colIndex": 2, "sortable": false, "header": "Beschreibung", "editable": true, "tooltip": "(system.MyTextFieldTemplates.description) ", "filter": { "type": "string" }, "width": Lino.chars2width(61), "renderer": Lino.text_renderer, "editor": description5229, "dataIndex": "description" }, { "colIndex": 3, "sortable": true, "header": "Team", "editable": true, "tooltip": "(system.MyTextFieldTemplates.team) If not empty, then this template is reserved to members of this team.", "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "team", "editor": team5230 }, { "colIndex": 4, "sortable": false, "header": "text", "editable": true, "tooltip": "(system.MyTextFieldTemplates.text) ", "filter": { "type": "string" }, "width": Lino.chars2width(61), "renderer": Lino.text_renderer, "editor": text5231, "dataIndex": "text" } ];
    Lino.system.MyTextFieldTemplates.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.system.MyTextFieldTemplates.put = function(rp,pk) { 
  Lino.run_row_action(rp,"/system/MyTextFieldTemplates","GET",pk,"put",null);
};
Lino.system.MyTextFieldTemplates.post = function(rp,pk) { 
  Lino.run_row_action(rp,"/system/MyTextFieldTemplates","GET",pk,"post",null);
};

Lino.system.MyTextFieldTemplates.insertPanel = Ext.extend(Lino.system.MyTextFieldTemplates.InsertFormPanel,{
  empty_title: "Neu Meine Einf\u00fcgetexte",
  hide_navigator: true,
  ls_bbar_actions: [ { "itemId": "post", "menu_item_text": "Erstellen", "tooltip": "Datensatz erstellen und dann im Detail-Fenster \u00f6ffnen", "panel_btn_handler": function(panel){panel.save(null,true,'post')}, "text": "Erstellen", "overflowText": "Erstellen", "auto_save": false }, { "itemId": "poststay", "menu_item_text": "Erstellen ohne Detail", "tooltip": "Nach Erstellen des Datensatzes kein Detail-Fenster \u00f6ffnen", "panel_btn_handler": function(panel){panel.save(null,false,'poststay')}, "text": "Erstellen ohne Detail", "overflowText": "Erstellen ohne Detail", "auto_save": false } ],
  ls_url: "/system/MyTextFieldTemplates",
  action_name: "insert",
  initComponent : function() {
    this.ls_detail_handler = Lino.system.MyTextFieldTemplates.detail;
    this.ls_insert_handler = Lino.system.MyTextFieldTemplates.insert;
    Lino.system.MyTextFieldTemplates.insertPanel.superclass.initComponent.call(this);
  }
});

Lino.system.MyTextFieldTemplates.insert = new Lino.WindowAction({ "draggable": true, "width": Lino.chars2width(60), "autoHeight": true, "maximizable": true, "modal": true, "maximized": false },function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.system.MyTextFieldTemplates.insertPanel(p);
});
Lino.system.MyTextFieldTemplates.poststay = function(rp,pk) { 
  Lino.run_row_action(rp,"/system/MyTextFieldTemplates","GET",pk,"poststay",null);
};

Lino.system.MyTextFieldTemplates.detailPanel = Ext.extend(Lino.system.MyTextFieldTemplates.DetailFormPanel,{
  empty_title: "Detail Meine Einf\u00fcgetexte",
  ls_bbar_actions: [ { "itemId": "put", "menu_item_text": "Speichern", "tooltip": "\u00c4nderungen in diesem Formular speichern", "panel_btn_handler": function(panel){panel.save(null,false,'put')}, "iconCls": "x-tbar-save", "overflowText": "Speichern", "auto_save": false }, { "itemId": "insert", "menu_item_text": "Neu", "must_save": true, "tooltip": "Neuen Datensatz erstellen", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-new", "overflowText": "Neu", "auto_save": true }, { "itemId": null, "menu_item_text": "L\u00f6schen", "tooltip": "Diesen Datensatz l\u00f6schen", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "L\u00f6schen", "auto_save": false } ],
  ls_url: "/system/MyTextFieldTemplates",
  action_name: "detail",
  initComponent : function() {
    this.ls_detail_handler = Lino.system.MyTextFieldTemplates.detail;
    this.ls_insert_handler = Lino.system.MyTextFieldTemplates.insert;
    Lino.system.MyTextFieldTemplates.detailPanel.superclass.initComponent.call(this);
  }
});

Lino.system.MyTextFieldTemplates.detail = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.system.MyTextFieldTemplates.detailPanel(p);
});
Lino.system.MyTextFieldTemplates.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.system.MyTextFieldTemplates.GridPanel(p);
});

// js_render_GridPanel_class users.AuthoritiesGiven
Lino.users.AuthoritiesGiven.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "forceFit": true, "emptyText": "Keine Daten anzuzeigen." },
  ls_url : "/users/AuthoritiesGiven",
  ls_bbar_actions : [ { "itemId": null, "menu_item_text": "L\u00f6schen", "tooltip": "Diesen Datensatz l\u00f6schen", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "L\u00f6schen", "auto_save": false } ],
  title : "Erteilte Vollmachten",
  page_length : 20,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "name": "authorized" }, 'authorizedHidden', { "type": "int", "name": "id" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 2,
  ls_grid_configs : [  ],
  content_type : 8,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 4,
  initComponent : function() {
    var ww = this.containing_window;
    var authorized269 = new Lino.RemoteComboFieldElement({ "preferred_width": 15, "allowBlank": false, "pageSize": 20, "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/users/AuthoritiesGiven/authorized", "method": "GET" }) }), "emptyText": "Benutzer ausw\u00e4hlen..." });
    this.before_row_edit = function(record) {
      var bp = this.get_base_params();
      authorized269.setContextValue('mk',bp['mk']);
      authorized269.setContextValue('mt',bp['mt']);
    };
    this.ls_columns = [ { "colIndex": 0, "sortable": true, "header": "Benutzer", "editable": true, "tooltip": "(users.AuthoritiesGiven.authorized) The user who gets authority to act in your name.", "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "authorized", "editor": authorized269 } ];
    Lino.users.AuthoritiesGiven.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.users.AuthoritiesGiven.put = function(rp,pk) { 
  Lino.run_row_action(rp,"/users/AuthoritiesGiven","GET",pk,"put",null);
};
Lino.users.AuthoritiesGiven.post = function(rp,pk) { 
  Lino.run_row_action(rp,"/users/AuthoritiesGiven","GET",pk,"post",null);
};
Lino.users.AuthoritiesGiven.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.users.AuthoritiesGiven.GridPanel(p);
});

// js_render_GridPanel_class users.AuthoritiesTaken
Lino.users.AuthoritiesTaken.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "forceFit": true, "emptyText": "Keine Daten anzuzeigen." },
  ls_url : "/users/AuthoritiesTaken",
  ls_bbar_actions : [ { "itemId": null, "menu_item_text": "L\u00f6schen", "tooltip": "Diesen Datensatz l\u00f6schen", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "L\u00f6schen", "auto_save": false } ],
  title : "Erhaltene Vollmachten",
  page_length : 20,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "name": "user" }, 'userHidden', { "type": "int", "name": "id" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 2,
  ls_grid_configs : [  ],
  content_type : 8,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 4,
  initComponent : function() {
    var ww = this.containing_window;
    var user5233 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "preferred_width": 15, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/users/AuthoritiesTaken/user", "method": "GET" }) }), "pageSize": 20, "emptyText": "Benutzer ausw\u00e4hlen..." });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ { "colIndex": 0, "sortable": true, "header": "Autor", "editable": true, "tooltip": "(users.AuthoritiesTaken.user) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "user", "editor": user5233 } ];
    Lino.users.AuthoritiesTaken.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.users.AuthoritiesTaken.put = function(rp,pk) { 
  Lino.run_row_action(rp,"/users/AuthoritiesTaken","GET",pk,"put",null);
};
Lino.users.AuthoritiesTaken.post = function(rp,pk) { 
  Lino.run_row_action(rp,"/users/AuthoritiesTaken","GET",pk,"post",null);
};
Lino.users.AuthoritiesTaken.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.users.AuthoritiesTaken.GridPanel(p);
});

// js_render_GridPanel_class countries.CitiesByCity
Lino.countries.CitiesByCity.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "Keine Daten anzuzeigen." },
  ls_url : "/countries/CitiesByCity",
  ls_bbar_actions : [ { "itemId": "insert", "menu_item_text": "Neu", "must_save": true, "tooltip": "Neuen Datensatz erstellen", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-new", "overflowText": "Neu", "auto_save": true }, { "itemId": "detail", "menu_item_text": "Detail", "tooltip": "Detail-Fenster auf diesem Datensatz \u00f6ffnen", "panel_btn_handler": Lino.show_detail, "iconCls": "x-tbar-detail", "overflowText": "Detail", "auto_save": true }, { "itemId": null, "menu_item_text": "L\u00f6schen", "tooltip": "Diesen Datensatz l\u00f6schen", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "L\u00f6schen", "auto_save": false } ],
  title : "Unterteilungen",
  page_length : 20,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "name": "name" }, { "name": "name_fr" }, { "name": "name_de" }, { "name": "name_nl" }, { "name": "type" }, 'typeHidden', { "name": "zip_code" }, { "type": "int", "name": "id" }, { "name": "country" }, 'countryHidden', { "name": "inscode" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 7,
  ls_grid_configs : [  ],
  content_type : 12,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 12,
  initComponent : function() {
    this.ls_detail_handler = Lino.countries.CitiesByCity.detail;
    this.ls_insert_handler = Lino.countries.CitiesByCity.insert;
    var ww = this.containing_window;
    var name480 = new Ext.form.TextField({ "selectOnFocus": true, "allowBlank": false, "maxLength": 200 });
    var name_fr481 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var name_de482 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var name_nl483 = new Ext.form.TextField({ "selectOnFocus": true, "hidden": true, "maxLength": 200 });
    var type484 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/countries/CitiesByCity/type", "method": "GET" }) }) });
    var zip_code485 = new Ext.form.TextField({ "selectOnFocus": true, "boxMinWidth": Lino.chars2width(8), "maxLength": 8 });
    var id486 = new Ext.form.NumberField({ "selectOnFocus": true });
    var country487 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/countries/CitiesByCity/country", "method": "GET" }) }), "allowBlank": false, "pageSize": 20, "emptyText": "Land ausw\u00e4hlen..." });
    var inscode488 = new Ext.form.TextField({ "selectOnFocus": true, "boxMinWidth": Lino.chars2width(5), "maxLength": 5 });
    this.before_row_edit = function(record) {
      type484.setContextValue('country',record ? record.data['countryHidden'] : undefined);
    };
    this.onRender = function(ct, position) {
      country487.on('change',Lino.chooser_handler(type484,'country'));
      Lino.countries.CitiesByCity.GridPanel.superclass.onRender.call(this, ct, position);
    }
    this.ls_columns = [ { "colIndex": 0, "sortable": true, "header": "Bezeichnung", "editable": true, "tooltip": "(countries.CitiesByCity.name) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "name", "editor": name480 }, { "colIndex": 1, "sortable": true, "header": "Bezeichnung (fr)", "editable": true, "tooltip": "(countries.CitiesByCity.name_fr) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "name_fr", "editor": name_fr481 }, { "colIndex": 2, "sortable": true, "header": "Bezeichnung (de)", "editable": true, "tooltip": "(countries.CitiesByCity.name_de) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "name_de", "editor": name_de482 }, { "colIndex": 3, "sortable": true, "header": "Bezeichnung (nl)", "editable": true, "tooltip": "(countries.CitiesByCity.name_nl) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "name_nl", "hidden": true, "editor": name_nl483 }, { "colIndex": 4, "sortable": true, "header": "Ortsart", "editable": true, "tooltip": "(countries.CitiesByCity.type) ", "filter": { "type": "string" }, "width": Lino.chars2width(11), "dataIndex": "type", "editor": type484 }, { "colIndex": 5, "sortable": true, "header": "zip code", "editable": true, "tooltip": "(countries.CitiesByCity.zip_code) ", "filter": { "type": "string" }, "width": Lino.chars2width(10), "dataIndex": "zip_code", "editor": zip_code485 }, new Lino.NullNumberColumn({ "colIndex": 6, "sortable": true, "format": "0", "editable": true, "tooltip": "(countries.CitiesByCity.id) ", "filter": { "type": "numeric" }, "header": "ID", "renderer": Lino.id_renderer, "editor": id486, "width": Lino.chars2width(6), "dataIndex": "id" }), { "colIndex": 7, "sortable": true, "header": "Land", "editable": true, "tooltip": "(countries.CitiesByCity.country) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('countryHidden','Lino.countries.Countries.detail'), "editor": country487, "dataIndex": "country" }, { "colIndex": 8, "sortable": true, "header": "INS-Code", "editable": true, "tooltip": "(countries.CitiesByCity.inscode) The official code for this place used by statbel.fgov.be", "filter": { "type": "string" }, "width": Lino.chars2width(7), "dataIndex": "inscode", "editor": inscode488 } ];
    Lino.countries.CitiesByCity.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.countries.CitiesByCity.put = function(rp,pk) { 
  Lino.run_row_action(rp,"/countries/CitiesByCity","GET",pk,"put",null);
};
Lino.countries.CitiesByCity.post = function(rp,pk) { 
  Lino.run_row_action(rp,"/countries/CitiesByCity","GET",pk,"post",null);
};

Lino.countries.CitiesByCity.insertPanel = Ext.extend(Lino.countries.CitiesByCity.DetailFormPanel,{
  empty_title: "Neu Unterteilungen",
  hide_navigator: true,
  ls_bbar_actions: [ { "itemId": "post", "menu_item_text": "Erstellen", "tooltip": "Datensatz erstellen und dann im Detail-Fenster \u00f6ffnen", "panel_btn_handler": function(panel){panel.save(null,true,'post')}, "text": "Erstellen", "overflowText": "Erstellen", "auto_save": false }, { "itemId": "poststay", "menu_item_text": "Erstellen ohne Detail", "tooltip": "Nach Erstellen des Datensatzes kein Detail-Fenster \u00f6ffnen", "panel_btn_handler": function(panel){panel.save(null,false,'poststay')}, "text": "Erstellen ohne Detail", "overflowText": "Erstellen ohne Detail", "auto_save": false } ],
  ls_url: "/countries/CitiesByCity",
  action_name: "insert",
  initComponent : function() {
    this.ls_detail_handler = Lino.countries.CitiesByCity.detail;
    this.ls_insert_handler = Lino.countries.CitiesByCity.insert;
    Lino.countries.CitiesByCity.insertPanel.superclass.initComponent.call(this);
  }
});

Lino.countries.CitiesByCity.insert = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.countries.CitiesByCity.insertPanel(p);
});
Lino.countries.CitiesByCity.poststay = function(rp,pk) { 
  Lino.run_row_action(rp,"/countries/CitiesByCity","GET",pk,"poststay",null);
};

Lino.countries.CitiesByCity.detailPanel = Ext.extend(Lino.countries.CitiesByCity.DetailFormPanel,{
  empty_title: "Detail Unterteilungen",
  ls_bbar_actions: [ { "itemId": "put", "menu_item_text": "Speichern", "tooltip": "\u00c4nderungen in diesem Formular speichern", "panel_btn_handler": function(panel){panel.save(null,false,'put')}, "iconCls": "x-tbar-save", "overflowText": "Speichern", "auto_save": false }, { "itemId": "insert", "menu_item_text": "Neu", "must_save": true, "tooltip": "Neuen Datensatz erstellen", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-new", "overflowText": "Neu", "auto_save": true }, { "itemId": null, "menu_item_text": "L\u00f6schen", "tooltip": "Diesen Datensatz l\u00f6schen", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "L\u00f6schen", "auto_save": false } ],
  ls_url: "/countries/CitiesByCity",
  action_name: "detail",
  initComponent : function() {
    this.ls_detail_handler = Lino.countries.CitiesByCity.detail;
    this.ls_insert_handler = Lino.countries.CitiesByCity.insert;
    Lino.countries.CitiesByCity.detailPanel.superclass.initComponent.call(this);
  }
});

Lino.countries.CitiesByCity.detail = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.countries.CitiesByCity.detailPanel(p);
});
Lino.countries.CitiesByCity.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.countries.CitiesByCity.GridPanel(p);
});

// js_render_GridPanel_class countries.CitiesByCountry
Lino.countries.CitiesByCountry.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "Keine Daten anzuzeigen." },
  ls_url : "/countries/CitiesByCountry",
  ls_bbar_actions : [ { "itemId": "insert", "menu_item_text": "Neu", "must_save": true, "tooltip": "Neuen Datensatz erstellen", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-new", "overflowText": "Neu", "auto_save": true }, { "itemId": "detail", "menu_item_text": "Detail", "tooltip": "Detail-Fenster auf diesem Datensatz \u00f6ffnen", "panel_btn_handler": Lino.show_detail, "iconCls": "x-tbar-detail", "overflowText": "Detail", "auto_save": true }, { "itemId": null, "menu_item_text": "L\u00f6schen", "tooltip": "Diesen Datensatz l\u00f6schen", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "L\u00f6schen", "auto_save": false } ],
  title : "Orte",
  page_length : 20,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "name": "name" }, { "name": "name_fr" }, { "name": "name_de" }, { "name": "name_nl" }, { "name": "type" }, 'typeHidden', { "name": "zip_code" }, { "type": "int", "name": "id" }, { "name": "parent" }, 'parentHidden', { "name": "inscode" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 7,
  ls_grid_configs : [  ],
  content_type : 12,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 12,
  initComponent : function() {
    this.ls_detail_handler = Lino.countries.CitiesByCountry.detail;
    this.ls_insert_handler = Lino.countries.CitiesByCountry.insert;
    var ww = this.containing_window;
    var name448 = new Ext.form.TextField({ "selectOnFocus": true, "allowBlank": false, "maxLength": 200 });
    var name_fr449 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var name_de450 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var name_nl451 = new Ext.form.TextField({ "selectOnFocus": true, "hidden": true, "maxLength": 200 });
    var type452 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/countries/CitiesByCountry/type", "method": "GET" }) }) });
    var zip_code453 = new Ext.form.TextField({ "selectOnFocus": true, "boxMinWidth": Lino.chars2width(8), "maxLength": 8 });
    var id454 = new Ext.form.NumberField({ "selectOnFocus": true });
    var parent455 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/countries/CitiesByCountry/parent", "method": "GET" }) }), "pageSize": 20, "emptyText": "Ort ausw\u00e4hlen..." });
    var inscode456 = new Ext.form.TextField({ "selectOnFocus": true, "boxMinWidth": Lino.chars2width(5), "maxLength": 5 });
    this.before_row_edit = function(record) {
      var bp = this.get_base_params();
      type452.setContextValue('mk',bp['mk']);
      type452.setContextValue('mt',bp['mt']);
    };
    this.ls_columns = [ { "colIndex": 0, "sortable": true, "header": "Bezeichnung", "editable": true, "tooltip": "(countries.CitiesByCountry.name) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "name", "editor": name448 }, { "colIndex": 1, "sortable": true, "header": "Bezeichnung (fr)", "editable": true, "tooltip": "(countries.CitiesByCountry.name_fr) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "name_fr", "editor": name_fr449 }, { "colIndex": 2, "sortable": true, "header": "Bezeichnung (de)", "editable": true, "tooltip": "(countries.CitiesByCountry.name_de) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "name_de", "editor": name_de450 }, { "colIndex": 3, "sortable": true, "header": "Bezeichnung (nl)", "editable": true, "tooltip": "(countries.CitiesByCountry.name_nl) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "name_nl", "hidden": true, "editor": name_nl451 }, { "colIndex": 4, "sortable": true, "header": "Ortsart", "editable": true, "tooltip": "(countries.CitiesByCountry.type) ", "filter": { "type": "string" }, "width": Lino.chars2width(11), "dataIndex": "type", "editor": type452 }, { "colIndex": 5, "sortable": true, "header": "zip code", "editable": true, "tooltip": "(countries.CitiesByCountry.zip_code) ", "filter": { "type": "string" }, "width": Lino.chars2width(10), "dataIndex": "zip_code", "editor": zip_code453 }, new Lino.NullNumberColumn({ "colIndex": 6, "sortable": true, "format": "0", "editable": true, "tooltip": "(countries.CitiesByCountry.id) ", "filter": { "type": "numeric" }, "header": "ID", "renderer": Lino.id_renderer, "editor": id454, "width": Lino.chars2width(6), "dataIndex": "id" }), { "colIndex": 7, "sortable": true, "header": "Teil von", "editable": true, "tooltip": "(countries.CitiesByCountry.parent) The superordinate geographic place of which this place is a part.", "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "parent", "editor": parent455 }, { "colIndex": 8, "sortable": true, "header": "INS-Code", "editable": true, "tooltip": "(countries.CitiesByCountry.inscode) The official code for this place used by statbel.fgov.be", "filter": { "type": "string" }, "width": Lino.chars2width(7), "dataIndex": "inscode", "editor": inscode456 } ];
    Lino.countries.CitiesByCountry.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.countries.CitiesByCountry.put = function(rp,pk) { 
  Lino.run_row_action(rp,"/countries/CitiesByCountry","GET",pk,"put",null);
};
Lino.countries.CitiesByCountry.post = function(rp,pk) { 
  Lino.run_row_action(rp,"/countries/CitiesByCountry","GET",pk,"post",null);
};

Lino.countries.CitiesByCountry.insertPanel = Ext.extend(Lino.countries.CitiesByCity.DetailFormPanel,{
  empty_title: "Neu Orte",
  hide_navigator: true,
  ls_bbar_actions: [ { "itemId": "post", "menu_item_text": "Erstellen", "tooltip": "Datensatz erstellen und dann im Detail-Fenster \u00f6ffnen", "panel_btn_handler": function(panel){panel.save(null,true,'post')}, "text": "Erstellen", "overflowText": "Erstellen", "auto_save": false }, { "itemId": "poststay", "menu_item_text": "Erstellen ohne Detail", "tooltip": "Nach Erstellen des Datensatzes kein Detail-Fenster \u00f6ffnen", "panel_btn_handler": function(panel){panel.save(null,false,'poststay')}, "text": "Erstellen ohne Detail", "overflowText": "Erstellen ohne Detail", "auto_save": false } ],
  ls_url: "/countries/CitiesByCountry",
  action_name: "insert",
  initComponent : function() {
    this.ls_detail_handler = Lino.countries.CitiesByCountry.detail;
    this.ls_insert_handler = Lino.countries.CitiesByCountry.insert;
    Lino.countries.CitiesByCountry.insertPanel.superclass.initComponent.call(this);
  }
});

Lino.countries.CitiesByCountry.insert = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.countries.CitiesByCountry.insertPanel(p);
});
Lino.countries.CitiesByCountry.poststay = function(rp,pk) { 
  Lino.run_row_action(rp,"/countries/CitiesByCountry","GET",pk,"poststay",null);
};

Lino.countries.CitiesByCountry.detailPanel = Ext.extend(Lino.countries.CitiesByCity.DetailFormPanel,{
  empty_title: "Detail Orte",
  ls_bbar_actions: [ { "itemId": "put", "menu_item_text": "Speichern", "tooltip": "\u00c4nderungen in diesem Formular speichern", "panel_btn_handler": function(panel){panel.save(null,false,'put')}, "iconCls": "x-tbar-save", "overflowText": "Speichern", "auto_save": false }, { "itemId": "insert", "menu_item_text": "Neu", "must_save": true, "tooltip": "Neuen Datensatz erstellen", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-new", "overflowText": "Neu", "auto_save": true }, { "itemId": null, "menu_item_text": "L\u00f6schen", "tooltip": "Diesen Datensatz l\u00f6schen", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "L\u00f6schen", "auto_save": false } ],
  ls_url: "/countries/CitiesByCountry",
  action_name: "detail",
  initComponent : function() {
    this.ls_detail_handler = Lino.countries.CitiesByCountry.detail;
    this.ls_insert_handler = Lino.countries.CitiesByCountry.insert;
    Lino.countries.CitiesByCountry.detailPanel.superclass.initComponent.call(this);
  }
});

Lino.countries.CitiesByCountry.detail = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.countries.CitiesByCountry.detailPanel(p);
});
Lino.countries.CitiesByCountry.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.countries.CitiesByCountry.GridPanel(p);
});

// js_render_GridPanel_class properties.ChoicesByType
Lino.properties.ChoicesByType.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "Keine Daten anzuzeigen." },
  ls_url : "/properties/ChoicesByType",
  ls_bbar_actions : [ { "itemId": null, "menu_item_text": "L\u00f6schen", "tooltip": "Diesen Datensatz l\u00f6schen", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "L\u00f6schen", "auto_save": false } ],
  title : "Auswahlm\u00f6glichkeiten",
  page_length : 20,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "name": "value" }, { "name": "text" }, { "name": "text_fr" }, { "name": "text_de" }, { "name": "text_nl" }, { "type": "int", "name": "id" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 5,
  ls_grid_configs : [  ],
  content_type : 16,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 7,
  initComponent : function() {
    var ww = this.containing_window;
    var value808 = new Ext.form.TextField({ "selectOnFocus": true, "allowBlank": false, "maxLength": 200 });
    var text809 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var text_fr810 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var text_de811 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var text_nl812 = new Ext.form.TextField({ "selectOnFocus": true, "hidden": true, "maxLength": 200 });
    var id813 = new Ext.form.NumberField({ "selectOnFocus": true });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ { "colIndex": 0, "sortable": true, "header": "Wert", "editable": true, "tooltip": "(properties.ChoicesByType.value) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "value", "editor": value808 }, { "colIndex": 1, "sortable": true, "header": "Bezeichnung", "editable": true, "tooltip": "(properties.ChoicesByType.text) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "text", "editor": text809 }, { "colIndex": 2, "sortable": true, "header": "Bezeichnung (fr)", "editable": true, "tooltip": "(properties.ChoicesByType.text_fr) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "text_fr", "editor": text_fr810 }, { "colIndex": 3, "sortable": true, "header": "Bezeichnung (de)", "editable": true, "tooltip": "(properties.ChoicesByType.text_de) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "text_de", "editor": text_de811 }, { "colIndex": 4, "sortable": true, "header": "Bezeichnung (nl)", "editable": true, "tooltip": "(properties.ChoicesByType.text_nl) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "text_nl", "hidden": true, "editor": text_nl812 }, new Lino.NullNumberColumn({ "colIndex": 5, "sortable": true, "format": "0", "editable": true, "tooltip": "(properties.ChoicesByType.id) ", "filter": { "type": "numeric" }, "header": "ID", "renderer": Lino.id_renderer, "editor": id813, "width": Lino.chars2width(6), "dataIndex": "id" }) ];
    Lino.properties.ChoicesByType.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.properties.ChoicesByType.put = function(rp,pk) { 
  Lino.run_row_action(rp,"/properties/ChoicesByType","GET",pk,"put",null);
};
Lino.properties.ChoicesByType.post = function(rp,pk) { 
  Lino.run_row_action(rp,"/properties/ChoicesByType","GET",pk,"post",null);
};
Lino.properties.ChoicesByType.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.properties.ChoicesByType.GridPanel(p);
});

// js_render_GridPanel_class contacts.PartnersByCity
Lino.contacts.PartnersByCity.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "Keine Daten anzuzeigen." },
  ls_url : "/contacts/PartnersByCity",
  ls_bbar_actions : [ { "itemId": "insert", "menu_item_text": "Neu", "must_save": true, "tooltip": "Neuen Datensatz erstellen", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-new", "overflowText": "Neu", "auto_save": true }, { "itemId": "detail", "menu_item_text": "Detail", "tooltip": "Detail-Fenster auf diesem Datensatz \u00f6ffnen", "panel_btn_handler": Lino.show_detail, "iconCls": "x-tbar-detail", "overflowText": "Detail", "auto_save": true }, { "itemId": null, "menu_item_text": "L\u00f6schen", "tooltip": "Diesen Datensatz l\u00f6schen", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "L\u00f6schen", "auto_save": false } ],
  title : "Partner",
  page_length : 20,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "name": "street" }, { "name": "street_no" }, { "name": "street_box" }, { "name": "addr2" }, { "name": "name" }, { "name": "language" }, 'languageHidden', { "type": "int", "name": "id" }, { "name": "created" }, { "name": "modified" }, { "name": "country" }, 'countryHidden', { "name": "region" }, 'regionHidden', { "name": "zip_code" }, { "name": "addr1" }, { "name": "street_prefix" }, { "name": "email" }, { "name": "url" }, { "name": "phone" }, { "name": "gsm" }, { "name": "fax" }, { "name": "remarks" }, { "type": "boolean", "name": "is_obsolete" }, { "name": "activity" }, 'activityHidden', { "name": "bank_account1" }, { "name": "bank_account2" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 7,
  ls_grid_configs : [  ],
  content_type : 22,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 29,
  initComponent : function() {
    this.ls_detail_handler = Lino.contacts.PartnersByCity.detail;
    this.ls_insert_handler = Lino.contacts.PartnersByCity.insert;
    var ww = this.containing_window;
    var street513 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var street_no514 = new Ext.form.TextField({ "selectOnFocus": true, "boxMinWidth": Lino.chars2width(10), "maxLength": 10 });
    var street_box515 = new Ext.form.TextField({ "selectOnFocus": true, "boxMinWidth": Lino.chars2width(10), "maxLength": 10 });
    var addr2516 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var name517 = new Ext.form.TextField({ "selectOnFocus": true, "allowBlank": false, "maxLength": 200 });
    var language518 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "allowBlank": false, "store": [ [ "en", "Englisch" ], [ "fr", "Franz\u00f6sisch" ], [ "de", "Deutsch" ], [ "nl", "Niederl\u00e4ndisch" ] ] });
    var id519 = new Ext.form.NumberField({ "selectOnFocus": true });
    var created520 = new Ext.form.DisplayField({ "disabled": true, "value": "<br>" });
    var modified521 = new Ext.form.DisplayField({ "disabled": true, "value": "<br>" });
    var country522 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/contacts/PartnersByCity/country", "method": "GET" }) }), "pageSize": 20, "emptyText": "Land ausw\u00e4hlen..." });
    var region523 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/contacts/PartnersByCity/region", "method": "GET" }) }), "pageSize": 20, "emptyText": "Ort ausw\u00e4hlen..." });
    var zip_code524 = new Ext.form.TextField({ "selectOnFocus": true, "boxMinWidth": Lino.chars2width(10), "maxLength": 10 });
    var addr1525 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var street_prefix526 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var email527 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 75 });
    var url528 = new Lino.URLField({ "selectOnFocus": true, "maxLength": 200 });
    var phone529 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var gsm530 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var fax531 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var remarks532 = new Ext.form.TextArea({ "selectOnFocus": true, "growMax": 2000 });
    var is_obsolete533 = new Ext.form.Checkbox({ "selectOnFocus": true, "checked": false });
    var activity534 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/contacts/PartnersByCity/activity", "method": "GET" }) }), "pageSize": 20, "emptyText": "Beruf ausw\u00e4hlen..." });
    var bank_account1535 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 40 });
    var bank_account2536 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 40 });
    this.before_row_edit = function(record) {
      region523.setContextValue('country',record ? record.data['countryHidden'] : undefined);
    };
    this.onRender = function(ct, position) {
      country522.on('change',Lino.chooser_handler(region523,'country'));
      Lino.contacts.PartnersByCity.GridPanel.superclass.onRender.call(this, ct, position);
    }
    this.ls_columns = [ { "colIndex": 0, "sortable": true, "header": "Stra\u00dfe", "editable": true, "tooltip": "(contacts.PartnersByCity.street) Name of street. Without house number.", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "street", "editor": street513 }, { "colIndex": 1, "sortable": true, "header": "Nr.", "editable": true, "tooltip": "(contacts.PartnersByCity.street_no) House number", "filter": { "type": "string" }, "width": Lino.chars2width(12), "dataIndex": "street_no", "editor": street_no514 }, { "colIndex": 2, "sortable": true, "header": "Box", "editable": true, "tooltip": "(contacts.PartnersByCity.street_box) Text to print after :attr:`steet_no` on the same line", "filter": { "type": "string" }, "width": Lino.chars2width(12), "dataIndex": "street_box", "editor": street_box515 }, { "colIndex": 3, "sortable": true, "header": "Adresszeile nach Stra\u00dfe", "editable": true, "tooltip": "(contacts.PartnersByCity.addr2) Address line to print below street line", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "addr2", "editor": addr2516 }, { "colIndex": 4, "sortable": true, "header": "Name", "editable": true, "tooltip": "(contacts.PartnersByCity.name) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "name", "editor": name517 }, { "colIndex": 5, "sortable": true, "header": "Sprache", "editable": true, "tooltip": "(contacts.PartnersByCity.language) Die Sprache, in der Dokumente ausgestellt werden sollen.", "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "language", "editor": language518 }, new Lino.NullNumberColumn({ "colIndex": 6, "sortable": true, "format": "0", "editable": true, "tooltip": "(contacts.PartnersByCity.id) ", "filter": { "type": "numeric" }, "header": "ID", "renderer": Lino.id_renderer, "editor": id519, "width": Lino.chars2width(6), "dataIndex": "id" }), { "colIndex": 7, "sortable": true, "header": "Erstellt", "editable": false, "tooltip": "(contacts.PartnersByCity.created) ", "width": Lino.chars2width(17), "dataIndex": "created", "hidden": true }, { "colIndex": 8, "sortable": true, "header": "Bearbeitet", "editable": false, "tooltip": "(contacts.PartnersByCity.modified) ", "width": Lino.chars2width(17), "dataIndex": "modified", "hidden": true }, { "colIndex": 9, "sortable": true, "header": "Land", "editable": true, "tooltip": "(contacts.PartnersByCity.country) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('countryHidden','Lino.countries.Countries.detail'), "editor": country522, "dataIndex": "country" }, { "colIndex": 10, "sortable": true, "header": "Region", "editable": true, "tooltip": "(contacts.PartnersByCity.region) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "region", "editor": region523 }, { "colIndex": 11, "sortable": true, "header": "Postleitzahl", "editable": true, "tooltip": "(contacts.PartnersByCity.zip_code) ", "filter": { "type": "string" }, "width": Lino.chars2width(12), "dataIndex": "zip_code", "editor": zip_code524 }, { "colIndex": 12, "sortable": true, "header": "Adresszeile vor Stra\u00dfe", "editable": true, "tooltip": "(contacts.PartnersByCity.addr1) Address line before street", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "addr1", "editor": addr1525 }, { "colIndex": 13, "sortable": true, "header": "Pr\u00e4fix Stra\u00dfe", "editable": true, "tooltip": "(contacts.PartnersByCity.street_prefix) Text to print before name of street, but to ignore for sorting.", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "street_prefix", "editor": street_prefix526 }, { "colIndex": 14, "sortable": true, "header": "E-Mail", "editable": true, "tooltip": "(contacts.PartnersByCity.email) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "email", "editor": email527 }, { "colIndex": 15, "sortable": true, "header": "URL", "editable": true, "tooltip": "(contacts.PartnersByCity.url) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "url", "editor": url528 }, { "colIndex": 16, "sortable": true, "header": "Telefon", "editable": true, "tooltip": "(contacts.PartnersByCity.phone) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "phone", "editor": phone529 }, { "colIndex": 17, "sortable": true, "header": "GSM", "editable": true, "tooltip": "(contacts.PartnersByCity.gsm) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "gsm", "editor": gsm530 }, { "colIndex": 18, "sortable": true, "header": "Fax", "editable": true, "tooltip": "(contacts.PartnersByCity.fax) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "fax", "editor": fax531 }, { "colIndex": 19, "sortable": false, "header": "Bemerkungen", "editable": true, "tooltip": "(contacts.PartnersByCity.remarks) ", "filter": { "type": "string" }, "width": Lino.chars2width(61), "renderer": Lino.text_renderer, "editor": remarks532, "dataIndex": "remarks" }, { "colIndex": 20, "sortable": false, "xtype": "checkcolumn", "header": "veraltet", "editable": true, "tooltip": "(contacts.PartnersByCity.is_obsolete) Altf\u00e4lle sind Partner, deren Stammdaten nicht mehr gepflegt werden und \nf\u00fcr neue Operationen nicht benutzt werden k\u00f6nnen.", "filter": { "type": "boolean" }, "width": Lino.chars2width(11), "dataIndex": "is_obsolete" }, { "colIndex": 21, "sortable": true, "header": "Beruf", "editable": true, "tooltip": "(contacts.PartnersByCity.activity) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "activity", "hidden": true, "editor": activity534 }, { "colIndex": 22, "sortable": true, "header": "Bankkonto 1", "editable": true, "tooltip": "(contacts.PartnersByCity.bank_account1) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "bank_account1", "hidden": true, "editor": bank_account1535 }, { "colIndex": 23, "sortable": true, "header": "Bankkonto 2", "editable": true, "tooltip": "(contacts.PartnersByCity.bank_account2) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "bank_account2", "hidden": true, "editor": bank_account2536 } ];
    Lino.contacts.PartnersByCity.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.contacts.PartnersByCity.put = function(rp,pk) { 
  Lino.run_row_action(rp,"/contacts/PartnersByCity","GET",pk,"put",null);
};
Lino.contacts.PartnersByCity.post = function(rp,pk) { 
  Lino.run_row_action(rp,"/contacts/PartnersByCity","GET",pk,"post",null);
};

Lino.contacts.PartnersByCity.insertPanel = Ext.extend(Lino.contacts.Partners.InsertFormPanel,{
  empty_title: "Neu Partner",
  hide_navigator: true,
  ls_bbar_actions: [ { "itemId": "post", "menu_item_text": "Erstellen", "tooltip": "Datensatz erstellen und dann im Detail-Fenster \u00f6ffnen", "panel_btn_handler": function(panel){panel.save(null,true,'post')}, "text": "Erstellen", "overflowText": "Erstellen", "auto_save": false }, { "itemId": "poststay", "menu_item_text": "Erstellen ohne Detail", "tooltip": "Nach Erstellen des Datensatzes kein Detail-Fenster \u00f6ffnen", "panel_btn_handler": function(panel){panel.save(null,false,'poststay')}, "text": "Erstellen ohne Detail", "overflowText": "Erstellen ohne Detail", "auto_save": false } ],
  ls_url: "/contacts/PartnersByCity",
  action_name: "insert",
  initComponent : function() {
    this.ls_detail_handler = Lino.contacts.PartnersByCity.detail;
    this.ls_insert_handler = Lino.contacts.PartnersByCity.insert;
    Lino.contacts.PartnersByCity.insertPanel.superclass.initComponent.call(this);
  }
});

Lino.contacts.PartnersByCity.insert = new Lino.WindowAction({ "draggable": true, "width": Lino.chars2width(40), "autoHeight": true, "maximizable": true, "modal": true, "maximized": false },function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.contacts.PartnersByCity.insertPanel(p);
});
Lino.contacts.PartnersByCity.poststay = function(rp,pk) { 
  Lino.run_row_action(rp,"/contacts/PartnersByCity","GET",pk,"poststay",null);
};

Lino.contacts.PartnersByCity.detailPanel = Ext.extend(Lino.contacts.Partners.DetailFormPanel,{
  empty_title: "Detail Partner",
  ls_bbar_actions: [ { "itemId": "put", "menu_item_text": "Speichern", "tooltip": "\u00c4nderungen in diesem Formular speichern", "panel_btn_handler": function(panel){panel.save(null,false,'put')}, "iconCls": "x-tbar-save", "overflowText": "Speichern", "auto_save": false }, { "itemId": "insert", "menu_item_text": "Neu", "must_save": true, "tooltip": "Neuen Datensatz erstellen", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-new", "overflowText": "Neu", "auto_save": true }, { "itemId": null, "menu_item_text": "L\u00f6schen", "tooltip": "Diesen Datensatz l\u00f6schen", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "L\u00f6schen", "auto_save": false } ],
  ls_url: "/contacts/PartnersByCity",
  action_name: "detail",
  initComponent : function() {
    this.ls_detail_handler = Lino.contacts.PartnersByCity.detail;
    this.ls_insert_handler = Lino.contacts.PartnersByCity.insert;
    Lino.contacts.PartnersByCity.detailPanel.superclass.initComponent.call(this);
  }
});

Lino.contacts.PartnersByCity.detail = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.contacts.PartnersByCity.detailPanel(p);
});
Lino.contacts.PartnersByCity.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.contacts.PartnersByCity.GridPanel(p);
});

// js_render_GridPanel_class contacts.PartnersByCountry
Lino.contacts.PartnersByCountry.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "Keine Daten anzuzeigen." },
  ls_url : "/contacts/PartnersByCountry",
  ls_bbar_actions : [ { "itemId": "insert", "menu_item_text": "Neu", "must_save": true, "tooltip": "Neuen Datensatz erstellen", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-new", "overflowText": "Neu", "auto_save": true }, { "itemId": "detail", "menu_item_text": "Detail", "tooltip": "Detail-Fenster auf diesem Datensatz \u00f6ffnen", "panel_btn_handler": Lino.show_detail, "iconCls": "x-tbar-detail", "overflowText": "Detail", "auto_save": true }, { "itemId": null, "menu_item_text": "L\u00f6schen", "tooltip": "Diesen Datensatz l\u00f6schen", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "L\u00f6schen", "auto_save": false } ],
  title : "Partner",
  page_length : 20,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "name": "city" }, 'cityHidden', { "name": "street" }, { "name": "street_no" }, { "name": "name" }, { "name": "language" }, 'languageHidden', { "type": "int", "name": "id" }, { "name": "created" }, { "name": "modified" }, { "name": "region" }, 'regionHidden', { "name": "zip_code" }, { "name": "addr1" }, { "name": "street_prefix" }, { "name": "street_box" }, { "name": "addr2" }, { "name": "email" }, { "name": "url" }, { "name": "phone" }, { "name": "gsm" }, { "name": "fax" }, { "name": "remarks" }, { "type": "boolean", "name": "is_obsolete" }, { "name": "activity" }, 'activityHidden', { "name": "bank_account1" }, { "name": "bank_account2" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 7,
  ls_grid_configs : [  ],
  content_type : 22,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 29,
  initComponent : function() {
    this.ls_detail_handler = Lino.contacts.PartnersByCountry.detail;
    this.ls_insert_handler = Lino.contacts.PartnersByCountry.insert;
    var ww = this.containing_window;
    var city5235 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "forceSelection": false, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/contacts/PartnersByCountry/city", "method": "GET" }) }), "pageSize": 20, "emptyText": "Ort ausw\u00e4hlen..." });
    var street5236 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var street_no5237 = new Ext.form.TextField({ "selectOnFocus": true, "boxMinWidth": Lino.chars2width(10), "maxLength": 10 });
    var name5238 = new Ext.form.TextField({ "selectOnFocus": true, "allowBlank": false, "maxLength": 200 });
    var language5239 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "allowBlank": false, "store": [ [ "en", "Englisch" ], [ "fr", "Franz\u00f6sisch" ], [ "de", "Deutsch" ], [ "nl", "Niederl\u00e4ndisch" ] ] });
    var id5240 = new Ext.form.NumberField({ "selectOnFocus": true });
    var created5241 = new Ext.form.DisplayField({ "disabled": true, "value": "<br>" });
    var modified5242 = new Ext.form.DisplayField({ "disabled": true, "value": "<br>" });
    var region5243 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/contacts/PartnersByCountry/region", "method": "GET" }) }), "pageSize": 20, "emptyText": "Ort ausw\u00e4hlen..." });
    var zip_code5244 = new Ext.form.TextField({ "selectOnFocus": true, "boxMinWidth": Lino.chars2width(10), "maxLength": 10 });
    var addr15245 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var street_prefix5246 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var street_box5247 = new Ext.form.TextField({ "selectOnFocus": true, "boxMinWidth": Lino.chars2width(10), "maxLength": 10 });
    var addr25248 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var email5249 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 75 });
    var url5250 = new Lino.URLField({ "selectOnFocus": true, "maxLength": 200 });
    var phone5251 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var gsm5252 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var fax5253 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var remarks5254 = new Ext.form.TextArea({ "selectOnFocus": true, "growMax": 2000 });
    var is_obsolete5255 = new Ext.form.Checkbox({ "selectOnFocus": true, "checked": false });
    var activity5256 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/contacts/PartnersByCountry/activity", "method": "GET" }) }), "pageSize": 20, "emptyText": "Beruf ausw\u00e4hlen..." });
    var bank_account15257 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 40 });
    var bank_account25258 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 40 });
    this.before_row_edit = function(record) {
      var bp = this.get_base_params();
      city5235.setContextValue('mk',bp['mk']);
      city5235.setContextValue('mt',bp['mt']);
      city5235.setContextValue('region',record ? record.data['regionHidden'] : undefined);
      var bp = this.get_base_params();
      region5243.setContextValue('mk',bp['mk']);
      region5243.setContextValue('mt',bp['mt']);
    };
    this.onRender = function(ct, position) {
      region5243.on('change',Lino.chooser_handler(city5235,'region'));
      Lino.contacts.PartnersByCountry.GridPanel.superclass.onRender.call(this, ct, position);
    }
    this.ls_columns = [ { "colIndex": 0, "sortable": true, "header": "Ort", "editable": true, "tooltip": "(contacts.PartnersByCountry.city) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "city", "editor": city5235 }, { "colIndex": 1, "sortable": true, "header": "Stra\u00dfe", "editable": true, "tooltip": "(contacts.PartnersByCountry.street) Name of street. Without house number.", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "street", "editor": street5236 }, { "colIndex": 2, "sortable": true, "header": "Nr.", "editable": true, "tooltip": "(contacts.PartnersByCountry.street_no) House number", "filter": { "type": "string" }, "width": Lino.chars2width(12), "dataIndex": "street_no", "editor": street_no5237 }, { "colIndex": 3, "sortable": true, "header": "Name", "editable": true, "tooltip": "(contacts.PartnersByCountry.name) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "name", "editor": name5238 }, { "colIndex": 4, "sortable": true, "header": "Sprache", "editable": true, "tooltip": "(contacts.PartnersByCountry.language) Die Sprache, in der Dokumente ausgestellt werden sollen.", "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "language", "editor": language5239 }, new Lino.NullNumberColumn({ "colIndex": 5, "sortable": true, "format": "0", "editable": true, "tooltip": "(contacts.PartnersByCountry.id) ", "filter": { "type": "numeric" }, "header": "ID", "renderer": Lino.id_renderer, "editor": id5240, "width": Lino.chars2width(6), "dataIndex": "id" }), { "colIndex": 6, "sortable": true, "header": "Erstellt", "editable": false, "tooltip": "(contacts.PartnersByCountry.created) ", "width": Lino.chars2width(17), "dataIndex": "created", "hidden": true }, { "colIndex": 7, "sortable": true, "header": "Bearbeitet", "editable": false, "tooltip": "(contacts.PartnersByCountry.modified) ", "width": Lino.chars2width(17), "dataIndex": "modified", "hidden": true }, { "colIndex": 8, "sortable": true, "header": "Region", "editable": true, "tooltip": "(contacts.PartnersByCountry.region) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "region", "editor": region5243 }, { "colIndex": 9, "sortable": true, "header": "Postleitzahl", "editable": true, "tooltip": "(contacts.PartnersByCountry.zip_code) ", "filter": { "type": "string" }, "width": Lino.chars2width(12), "dataIndex": "zip_code", "editor": zip_code5244 }, { "colIndex": 10, "sortable": true, "header": "Adresszeile vor Stra\u00dfe", "editable": true, "tooltip": "(contacts.PartnersByCountry.addr1) Address line before street", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "addr1", "editor": addr15245 }, { "colIndex": 11, "sortable": true, "header": "Pr\u00e4fix Stra\u00dfe", "editable": true, "tooltip": "(contacts.PartnersByCountry.street_prefix) Text to print before name of street, but to ignore for sorting.", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "street_prefix", "editor": street_prefix5246 }, { "colIndex": 12, "sortable": true, "header": "Box", "editable": true, "tooltip": "(contacts.PartnersByCountry.street_box) Text to print after :attr:`steet_no` on the same line", "filter": { "type": "string" }, "width": Lino.chars2width(12), "dataIndex": "street_box", "editor": street_box5247 }, { "colIndex": 13, "sortable": true, "header": "Adresszeile nach Stra\u00dfe", "editable": true, "tooltip": "(contacts.PartnersByCountry.addr2) Address line to print below street line", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "addr2", "editor": addr25248 }, { "colIndex": 14, "sortable": true, "header": "E-Mail", "editable": true, "tooltip": "(contacts.PartnersByCountry.email) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "email", "editor": email5249 }, { "colIndex": 15, "sortable": true, "header": "URL", "editable": true, "tooltip": "(contacts.PartnersByCountry.url) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "url", "editor": url5250 }, { "colIndex": 16, "sortable": true, "header": "Telefon", "editable": true, "tooltip": "(contacts.PartnersByCountry.phone) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "phone", "editor": phone5251 }, { "colIndex": 17, "sortable": true, "header": "GSM", "editable": true, "tooltip": "(contacts.PartnersByCountry.gsm) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "gsm", "editor": gsm5252 }, { "colIndex": 18, "sortable": true, "header": "Fax", "editable": true, "tooltip": "(contacts.PartnersByCountry.fax) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "fax", "editor": fax5253 }, { "colIndex": 19, "sortable": false, "header": "Bemerkungen", "editable": true, "tooltip": "(contacts.PartnersByCountry.remarks) ", "filter": { "type": "string" }, "width": Lino.chars2width(61), "renderer": Lino.text_renderer, "editor": remarks5254, "dataIndex": "remarks" }, { "colIndex": 20, "sortable": false, "xtype": "checkcolumn", "header": "veraltet", "editable": true, "tooltip": "(contacts.PartnersByCountry.is_obsolete) Altf\u00e4lle sind Partner, deren Stammdaten nicht mehr gepflegt werden und \nf\u00fcr neue Operationen nicht benutzt werden k\u00f6nnen.", "filter": { "type": "boolean" }, "width": Lino.chars2width(11), "dataIndex": "is_obsolete" }, { "colIndex": 21, "sortable": true, "header": "Beruf", "editable": true, "tooltip": "(contacts.PartnersByCountry.activity) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "activity", "hidden": true, "editor": activity5256 }, { "colIndex": 22, "sortable": true, "header": "Bankkonto 1", "editable": true, "tooltip": "(contacts.PartnersByCountry.bank_account1) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "bank_account1", "hidden": true, "editor": bank_account15257 }, { "colIndex": 23, "sortable": true, "header": "Bankkonto 2", "editable": true, "tooltip": "(contacts.PartnersByCountry.bank_account2) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "bank_account2", "hidden": true, "editor": bank_account25258 } ];
    Lino.contacts.PartnersByCountry.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.contacts.PartnersByCountry.put = function(rp,pk) { 
  Lino.run_row_action(rp,"/contacts/PartnersByCountry","GET",pk,"put",null);
};
Lino.contacts.PartnersByCountry.post = function(rp,pk) { 
  Lino.run_row_action(rp,"/contacts/PartnersByCountry","GET",pk,"post",null);
};

Lino.contacts.PartnersByCountry.insertPanel = Ext.extend(Lino.contacts.Partners.InsertFormPanel,{
  empty_title: "Neu Partner",
  hide_navigator: true,
  ls_bbar_actions: [ { "itemId": "post", "menu_item_text": "Erstellen", "tooltip": "Datensatz erstellen und dann im Detail-Fenster \u00f6ffnen", "panel_btn_handler": function(panel){panel.save(null,true,'post')}, "text": "Erstellen", "overflowText": "Erstellen", "auto_save": false }, { "itemId": "poststay", "menu_item_text": "Erstellen ohne Detail", "tooltip": "Nach Erstellen des Datensatzes kein Detail-Fenster \u00f6ffnen", "panel_btn_handler": function(panel){panel.save(null,false,'poststay')}, "text": "Erstellen ohne Detail", "overflowText": "Erstellen ohne Detail", "auto_save": false } ],
  ls_url: "/contacts/PartnersByCountry",
  action_name: "insert",
  initComponent : function() {
    this.ls_detail_handler = Lino.contacts.PartnersByCountry.detail;
    this.ls_insert_handler = Lino.contacts.PartnersByCountry.insert;
    Lino.contacts.PartnersByCountry.insertPanel.superclass.initComponent.call(this);
  }
});

Lino.contacts.PartnersByCountry.insert = new Lino.WindowAction({ "draggable": true, "width": Lino.chars2width(40), "autoHeight": true, "maximizable": true, "modal": true, "maximized": false },function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.contacts.PartnersByCountry.insertPanel(p);
});
Lino.contacts.PartnersByCountry.poststay = function(rp,pk) { 
  Lino.run_row_action(rp,"/contacts/PartnersByCountry","GET",pk,"poststay",null);
};

Lino.contacts.PartnersByCountry.detailPanel = Ext.extend(Lino.contacts.Partners.DetailFormPanel,{
  empty_title: "Detail Partner",
  ls_bbar_actions: [ { "itemId": "put", "menu_item_text": "Speichern", "tooltip": "\u00c4nderungen in diesem Formular speichern", "panel_btn_handler": function(panel){panel.save(null,false,'put')}, "iconCls": "x-tbar-save", "overflowText": "Speichern", "auto_save": false }, { "itemId": "insert", "menu_item_text": "Neu", "must_save": true, "tooltip": "Neuen Datensatz erstellen", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-new", "overflowText": "Neu", "auto_save": true }, { "itemId": null, "menu_item_text": "L\u00f6schen", "tooltip": "Diesen Datensatz l\u00f6schen", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "L\u00f6schen", "auto_save": false } ],
  ls_url: "/contacts/PartnersByCountry",
  action_name: "detail",
  initComponent : function() {
    this.ls_detail_handler = Lino.contacts.PartnersByCountry.detail;
    this.ls_insert_handler = Lino.contacts.PartnersByCountry.insert;
    Lino.contacts.PartnersByCountry.detailPanel.superclass.initComponent.call(this);
  }
});

Lino.contacts.PartnersByCountry.detail = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.contacts.PartnersByCountry.detailPanel(p);
});
Lino.contacts.PartnersByCountry.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.contacts.PartnersByCountry.GridPanel(p);
});

// js_render_GridPanel_class contacts.RolesByCompany
Lino.contacts.RolesByCompany.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "forceFit": true, "emptyText": "Keine Daten anzuzeigen." },
  ls_url : "/contacts/RolesByCompany",
  ls_bbar_actions : [ { "itemId": null, "menu_item_text": "L\u00f6schen", "tooltip": "Diesen Datensatz l\u00f6schen", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "L\u00f6schen", "auto_save": false } ],
  title : "Kontaktpersonen",
  page_length : 20,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "name": "person" }, 'personHidden', { "name": "type" }, 'typeHidden', { "type": "int", "name": "id" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 4,
  ls_grid_configs : [  ],
  content_type : 21,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 6,
  initComponent : function() {
    var ww = this.containing_window;
    var person891 = new Lino.RemoteComboFieldElement({ "preferred_width": 20, "allowBlank": false, "pageSize": 20, "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/contac