/*
 Copyright 2009-2014 Luc Saffre
 License: BSD (see file COPYING for details)
*/

// lino.js --- generated Fri Dec 12 05:39:53 2014 by Lino version 1.6.14.
Ext.BLANK_IMAGE_URL = 'http://extjs-public.googlecode.com/svn/tags/extjs-3.3.1/release/resources/images/default/s.gif';
LANGUAGE_CHOICES = [ [ "en", "Englisch" ], [ "fr", "Franz\u00f6sisch" ], [ "de", "Deutsch" ], [ "nl", "Niederl\u00e4ndisch" ] ];
MEDIA_URL = "/media";

// hack to add a toCamel function, inspired by
// http://jamesroberts.name/blog/2010/02/22/string-functions-for-javascript-trim-to-camel-case-to-dashed-and-to-underscore/
String.prototype.toCamel = function(){
  //~ return this.replace(/(\-[a-z])/g, function($1){return $1.toUpperCase().replace('-','');});
  //~ return this;
  return this.replace(/([A-Z])([A-Z]+)/g, function(match,p1,p2,offset,string){
      //~ console.log("20131005 got ",arguments);
      return p1 + p2.toLowerCase();});
};



/* MonthPickerPlugin: thanks to keypoint @ sencha forum
   http://www.sencha.com/forum/showthread.php?74002-3.x-Ext.ux.MonthMenu&p=356860#post356860
*/
Ext.namespace('Ext.ux'); 

Ext.ux.MonthPickerPlugin = function() { 
    var picker; 
    var oldDateDefaults; 

    this.init = function(pk) { 
        picker = pk; 
        picker.onTriggerClick = picker.onTriggerClick.createSequence(onClick); 
        picker.getValue = picker.getValue.createInterceptor(setDefaultMonthDay).createSequence(restoreDefaultMonthDay); 
        picker.beforeBlur = picker.beforeBlur.createInterceptor(setDefaultMonthDay).createSequence(restoreDefaultMonthDay); 
    }; 

    function setDefaultMonthDay() { 
        oldDateDefaults = Date.defaults.d; 
        Date.defaults.d = 1; 
        return true; 
    } 

    function restoreDefaultMonthDay(ret) { 
        Date.defaults.d = oldDateDefaults; 
        return ret; 
    } 

    function onClick(e, el, opt) { 
        var p = picker.menu.picker; 
        p.activeDate = p.activeDate.getFirstDateOfMonth(); 
        if (p.value) { 
            p.value = p.value.getFirstDateOfMonth(); 
        } 

        p.showMonthPicker(); 
         
        if (!p.disabled) { 
            p.monthPicker.stopFx(); 
            p.monthPicker.show(); 

            p.mun(p.monthPicker, 'click', p.onMonthClick, p); 
            p.mun(p.monthPicker, 'dblclick', p.onMonthDblClick, p); 
            p.onMonthClick = p.onMonthClick.createSequence(pickerClick); 
            p.onMonthDblClick = p.onMonthDblClick.createSequence(pickerDblclick); 
            p.mon(p.monthPicker, 'click', p.onMonthClick, p); 
            p.mon(p.monthPicker, 'dblclick', p.onMonthDblClick, p); 
        } 
    } 

    function pickerClick(e, t) { 
        var el = new Ext.Element(t); 
        if (el.is('button.x-date-mp-cancel')) { 
            picker.menu.hide(); 
        } else if(el.is('button.x-date-mp-ok')) { 
            var p = picker.menu.picker; 
            p.setValue(p.activeDate); 
            p.fireEvent('select', p, p.value); 
        } 
    } 

    function pickerDblclick(e, t) { 
        var el = new Ext.Element(t); 
        if (el.parent() 
            && (el.parent().is('td.x-date-mp-month') 
            || el.parent().is('td.x-date-mp-year'))) { 

            var p = picker.menu.picker; 
            p.setValue(p.activeDate); 
            p.fireEvent('select', p, p.value); 
        } 
    } 
}; 

Ext.preg('monthPickerPlugin', Ext.ux.MonthPickerPlugin);  


/**
JC Watsons solution (adapted to ExtJS 3.3.1 by LS) is elegant and simple:
`A "fix" for unchecked checkbox submission  behaviour
<http://www.sencha.com/forum/showthread.php?28449>`_

Added special handling for checkbox inputs. 
ExtJS defines disabled checkboxes `readonly`, not `disabled` as for other inputs.

*/
Ext.lib.Ajax.serializeForm = function(form) {
    //~ console.log('20120203 linolib.js serializeForm',form);
    var fElements = form.elements || (document.forms[form] || Ext.getDom(form)).elements, 
        hasSubmit = false, 
        encoder = encodeURIComponent, 
        name, 
        data = '', 
        type, 
        hasValue;

    Ext.each(fElements, function(element){
        name = element.name;
        type = element.type;

        if (!element.disabled && name && !(type == 'checkbox' && element.readonly)) {
            if (/select-(one|multiple)/i.test(type)) {
                Ext.each(element.options, function(opt){
                    if (opt.selected) {
                        hasValue = opt.hasAttribute ? opt.hasAttribute('value') : opt.getAttributeNode('value').specified;
                        data += String.format("{0}={1}&", encoder(name), encoder(hasValue ? opt.value : opt.text));
                    }
                });
            } else if (!(/file|undefined|reset|button/i.test(type))) {
                //~ if (!(/radio|checkbox/i.test(type) && !element.checked) && !(type == 'submit' && hasSubmit)) {
                if (!(type == 'submit' && hasSubmit)) {
                    if (type == 'checkbox') {
                        //~ console.log('20111001',element,'data += ',encoder(name) + '=' + (element.checked ? 'on' : 'off') + '&');
                        data += encoder(name) + '=' + (element.checked ? 'on' : 'off') + '&';
                    } else {
                        //~ console.log('20111001',element,'data += ',encoder(name) + '=' + encoder(element.value) + '&');
                        data += encoder(name) + '=' + encoder(element.value) + '&';
                    }
                    hasSubmit = /submit/i.test(type);
                }
            }
        //~ } else {
            //~ console.log(name,type,element.readonly);
        }
    });
    return data.substr(0, data.length - 1);
};



/*
Set a long timeout of fifteen minutes. 
See /blog/2012/0307
*/
Ext.Ajax.timeout = 15 * 60 * 1000; 

/*
 * Thanks to 
 * `huuze <http://stackoverflow.com/users/10040/huuuze>`_ for the question
 * and to 
 * `chrisv <http://stackoverflow.com/users/683808/chrisv>`_
 * for the answer on
 * http://stackoverflow.com/questions/3764589/how-do-i-include-django-1-2s-csrf-token-in-a-javascript-generated-html-form/5485616#5485616
 * 
 * */
 
Ext.Ajax.on('beforerequest', function (conn, options) {
   if (!(/^http:.*/.test(options.url) || /^https:.*/.test(options.url))) {
     if (typeof(options.headers) == "undefined") {
       options.headers = {'X-CSRFToken': Ext.util.Cookies.get('csrftoken')};
     } else {
       options.headers.extend({'X-CSRFToken': Ext.util.Cookies.get('csrftoken')});
     }                        
   }
}, this);


/*
My fix for the "Cannot set QuickTips dismissDelay to 0" bug,
see http://www.sencha.com/forum/showthread.php?183515 
*/
Ext.override(Ext.QuickTip,{
  showAt : function(xy){
        var t = this.activeTarget;
        //~ console.log("20120224 QuickTip.showAt",this.title,this.dismissDelay,t.dismissDelay);
        if(t){
            if(!this.rendered){
                this.render(Ext.getBody());
                this.activeTarget = t;
            }
            if(t.width){
                this.setWidth(t.width);
                this.body.setWidth(this.adjustBodyWidth(t.width - this.getFrameWidth()));
                this.measureWidth = false;
            } else{
                this.measureWidth = true;
            }
            this.setTitle(t.title || '');
            this.body.update(t.text);
            this.autoHide = t.autoHide;
            // bugfix by Luc 20120226
            if (t.dismissDelay != undefined) this.dismissDelay = t.dismissDelay;
            //~ this.dismissDelay = t.dismissDelay || this.dismissDelay;
            if(this.lastCls){
                this.el.removeClass(this.lastCls);
                delete this.lastCls;
            }
            if(t.cls){
                this.el.addClass(t.cls);
                this.lastCls = t.cls;
            }
            if(this.anchor){
                this.constrainPosition = false;
            }else if(t.align){ 
                xy = this.el.getAlignToXY(t.el, t.align);
                this.constrainPosition = false;
            }else{
                this.constrainPosition = true;
            }
        }
        Ext.QuickTip.superclass.showAt.call(this, xy);
    }
});

/*
Another hack. See /docs/blog/2012/0228
*/
Ext.Element.addMethods(
    function() {
        var VISIBILITY      = "visibility",
            DISPLAY         = "display",
            HIDDEN          = "hidden",
            NONE            = "none",
            XMASKED         = "x-masked",
            XMASKEDRELATIVE = "x-masked-relative",
            data            = Ext.Element.data;

        return {
            
            mask : function(msg, msgCls) {
                var me  = this,
                    dom = me.dom,
                    dh  = Ext.DomHelper,
                    EXTELMASKMSG = "ext-el-mask-msg",
                    el,
                    mask;
                // removed the following lines. See /docs/blog/2012/0228
                //~ if (!(/^body/i.test(dom.tagName) && me.getStyle('position') == 'static')) {
                    //~ console.log(20120228,dom.tagName,me);
                    //~ me.addClass(XMASKEDRELATIVE); 
                //~ }
                if (el = data(dom, 'maskMsg')) {
                    el.remove();
                }
                if (el = data(dom, 'mask')) {
                    el.remove();
                }

                mask = dh.append(dom, {cls : "ext-el-mask"}, true);
                data(dom, 'mask', mask);

                me.addClass(XMASKED);
                mask.setDisplayed(true);
                
                if (typeof msg == 'string') {
                    var mm = dh.append(dom, {cls : EXTELMASKMSG, cn:{tag:'div'}}, true);
                    data(dom, 'maskMsg', mm);
                    mm.dom.className = msgCls ? EXTELMASKMSG + " " + msgCls : EXTELMASKMSG;
                    mm.dom.firstChild.innerHTML = msg;
                    mm.setDisplayed(true);
                    mm.center(me);
                }
                
                
                if (Ext.isIE && !(Ext.isIE7 && Ext.isStrict) && me.getStyle('height') == 'auto') {
                    mask.setSize(undefined, me.getHeight());
                }
                
                return mask;
            }

            
        };
    }()
);



Ext.namespace('Lino');
    
    

//~ Lino.subst_user_field = new Ext.form.ComboBox({});
//~ Lino.subst_user = null;
Lino.insert_subst_user = function(p){
    //~ console.log('20120714 insert_subst_user',Lino.subst_user,p);
    //~ if (Lino.subst_user_field.getValue()) {
    if (p.su) return;
    if (Lino.subst_user) {
        //~ p.su = Lino.subst_user_field.getValue();
        p.su = Lino.subst_user;
    //~ } else {
        //~ delete p.su;
    }
    //~ console.log('20120714 insert_subst_user -->',Lino.subst_user,p);
}

Lino.login_window = null;

Lino.autorefresh = function() {
  if (Lino.current_window == null) {
      Lino.viewport.refresh();
      Lino.autorefresh.defer(10000);
  }
}

Lino.show_login_window = function(on_login) {
  //~ console.log('20121103 show_login_window',arguments);
  //~ var current_window = Lino.current_window;
  if (Lino.login_window == null) {
    
      function do_login() { 
            Lino.viewport.loadMask.show()
            login_panel.getForm().submit({ 
                method:'POST', 
                waitTitle:'Connecting', 
                waitMsg:'Sending data...',
                success:function(){ 
                  Lino.login_window.hide();
                  Lino.handle_home_button();
                  Lino.viewport.loadMask.hide();
                  if (typeof on_login == 'string') {
                      Lino.load_url(on_login);
                  } 
                },
                failure: function(form,action) { 
                  Lino.on_submit_failure(form, action);
                  Lino.viewport.loadMask.hide()
                }
            }); 
      };
    
      var login_button = new Ext.Button({ 
        text:"Anmelden",
        formBind: true,	 
        // Function that fires when user clicks the button 
        handler: do_login});
    
      var login_panel = new Ext.FormPanel({ 
        //~ inspired by http://www.sencha.com/learn/a-basic-login/
        autoHeight:true,
        labelWidth:90,
        url:'/auth', 
        frame:true, 
        defaultType:'textfield',
        monitorValid:true,
        items:[{ 
            fieldLabel:"Benutzername", 
            id: 'username',
            name:'username', 
            autoHeight:true,
            allowBlank:false 
        },{ 
            fieldLabel:"Passwort", 
            name:'password', 
            inputType:'password', 
            autoHeight:true,
            allowBlank:false 
        }],        
        buttons:[ login_button ]});
        
      Lino.login_window = new Ext.Window({
          layout:'fit',
          defaultButton: 'username',
          width:300,
          title:"Anmelden", 
          autoHeight:true,
          modal: true,
          closeAction: "hide",
          keys: {
            key: Ext.EventObject.ENTER,
            fn: function() { do_login()}
          },
          items: [login_panel] });
  };
  Lino.login_window.show();
};

Lino.logout = function(id,name) {
    Lino.call_ajax_action(
        Lino.viewport, 'GET', 
        '/auth',
        {}, 'logout', undefined, undefined,
        function(){Lino.reload();})
}

Lino.set_subst_user = function(id, name) {
    //~ console.log(20130723,'Lino.set_subst_user',id,name,Lino.current_window,Lino.viewport);
    Lino.subst_user = id;
    if (Lino.current_window) 
        Lino.current_window.main_item.set_base_param("su",id);
    if (Lino.viewport) 
        Lino.permalink_handler(Lino.current_window)();
}



//~ Lino.select_subst_user = function(cmp,rec,value){
    //~ Lino.subst_user=value;
    //~ console.log(20120713,rec);
//~ }
    
Lino.current_window = null;
Lino.window_history = Array();
    
Lino.chars2width = function(cols) {  return cols * 9; }
Lino.rows2height = function(cols) {  return cols * 20; }



Lino.MainPanel = {
  is_home_page : false,
  setting_param_values : false,
  config_containing_window : function(wincfg) { }
  ,init_containing_window : function(win) { }
  ,is_loading : function() { 
      if (!this.rendered) return true;
      //~ return (Ext.select('.x-loading-msg').elements.length > 0);
      return true; 
    } 
  ,do_when_clean : function(auto_save,todo) { todo() }
  ,get_master_params : function() {
    var p = {}
    p['mt'] = this.content_type; 
    rec = this.get_current_record()
    if (rec) {
      if (rec.phantom) {
          p['mk'] = undefined; 
      }else{
          p['mk'] = rec.id; 
      }
    } else {
      p['mk'] = undefined;
    }
    //~ console.log('get_master_params returns',p,'using record',rec);
    return p;
  }
  ,get_permalink : function() {
    var p = Ext.apply({}, this.get_base_params());
    delete p.fmt;
    Ext.apply(p, this.get_permalink_params());
    
    if (this.toggle_params_panel_btn) {
        p.sp = this.toggle_params_panel_btn.pressed;
        //~ if (this.toggle_params_panel_btn.pressed == this.params_panel_hidden) {
          //~ p.sp = true;
        //~ }
    }
    
    //~ Lino.insert_subst_user(p);
     //~ p.fmt = 'html';
    //~ console.log('get_permalink',p,this.get_permalink_params());
    if (this.is_home_page)
        //~ var url = '';
        var url = '/';
    else 
        var url = this.get_permalink_url();
    if (p.su == null) 
        delete p.su;
    if (Ext.urlEncode(p)) url = url + "?" + Ext.urlEncode(p);
    return url;
  }
  ,get_record_url : function(record_id) {
      var url = '/api' + this.ls_url
      //~ var url = this.containing_window.config.url_data; // ls_url;
      url += '/' + (record_id === undefined ? '-99999' : String(record_id));
      //~ if (record_id !== undefined) url += '/' + String(record_id);
      //~ url += '/' + String(record_id);
      return url;
  }
  ,get_permalink_url : function() {
      return '/api' + this.ls_url;
  }
  ,get_permalink_params : function() {
      //~ return {an:'grid'};
      var p = {};
      if (this.action_name)
          p.an = this.action_name;
      this.add_param_values(p,false)
      return p;
  }
  /*

  Lino.MainPanel.set_status() : the status can have the following keys:

  - field_values
  - param_values
  - base_params
  - record_id
  - active_tab
  - data_record
  - show_params_panel
  - current_page

   */
  ,set_status : function(status, requesting_panel) {}
  ,get_status : function() { return {}}
  ,refresh : function() {}
  ,get_base_params : function() {  // Lino.MainPanel
    var p = {};
    Lino.insert_subst_user(p);
    return p;
  }
  ,add_params_panel : function (tbar) {
      if (this.params_panel) {
        //~  20130923b
        //~ this.params_panel.autoHeight = true; // 20130924
        var t = this;
        var update = function() {
            var p = t.params_panel;
            //~ console.log("update", p.getSize().height,p.forceLayout,p.autoHeight);
            var w = t.get_containing_window();
            Lino.do_when_visible(w, function() {
                //~ p.doLayout(true); // doLayout(shallow, force)
                w.doLayout(true); // doLayout(shallow, force)
                //~ t.params_panel.on('afterlayout',update,t,{single:true});
            });
        };
        Lino.do_when_visible(this.params_panel, update);
        this.params_panel.on('show',update);
        this.params_panel.on('hide',update);
        //~ this.params_panel.on('bodyresize',update);
        this.params_panel.on('afterlayout',update);
        //~ this.params_panel.on('afterlayout',update,this,{single:true});
        //~ this.params_panel.on('bodyresize',update,this,{single:true});
        //~ this.params_panel.on('resize',update,this,{single:true});
        //~ this.params_panel.on('render',update,this,{single:true});
        
        // this.params_panel.on('render',
        //~ this.params_panel.on('afterlayout',update,this,{single:true,delay:200});
        //~ this.params_panel.on('bodyresize',update,this,{single:true,delay:200});
        this.toggle_params_panel_btn = new Ext.Button({ scope:this, 
          //~ text: "$_("[parameters]")", // gear
          iconCls: 'x-tbar-parameters',
          tooltip:"Parameter-Panel ein- bzw. ausblenden",
          enableToggle: true,
          //~ pressed: ! this.params_panel.hidden,
          pressed: ! this.params_panel_hidden,
          toggleHandler: function(btn,state) { 
            //~ console.log("20120210 add_params_panel",state,this.params_panel);
            if (state) {
                this.params_panel.show();
            } else {
                this.params_panel.hide();
            }
            //~ this.params_panel.on('afterlayout',update,this,{single:true});
            //~ t.get_containing_window().doLayout();
            //~ this.params_panel.on('afterlayout',function() {
                //~ console.log("20130918 afterlayout");
                //~ t.get_containing_window().doLayout(); // doLayout(shallow, force)
            //~ },this,{single:true});
          }
        }); 
        tbar = tbar.concat([this.toggle_params_panel_btn]);
        var refresh = function() {
            if (!t.setting_param_values) {
                t._force_dirty = true; 
                t.refresh();
            }
        }
        Ext.each(this.params_panel.fields,function(f) {
          //~ f.on('valid',function() {t.refresh()});
          if (f instanceof Ext.form.Checkbox) {
              f.on('check',refresh);
          } else if (f instanceof Ext.DatePicker) {
              f.on('select',refresh);
          } else if (f instanceof Ext.form.TriggerField) {
              f.on('select',refresh);
              //~ f.on('change',refresh);
              //~ f.on('valid',refresh);
          } else {
              if (! f.on) 
                  console.log("20121010 no method 'on'",f);
              else
                  f.on('change',refresh);
            }
          });
      }
      return tbar;
  }
  ,add_param_values : function (p,force_dirty) {
    if (this.params_panel) {
      /* 
      * 20120918 add param_values to the request string 
      * *only if the params_form is dirty*.
      * Otherwise Actor.default_params() would never be used.
      *
      * 20121023 But IntegClients.params_default has non-empty default values. 
      * Users must have the possibility to make them empty.
      * 
      * 20130605 : added `force_dirty` parameter because Checkbox fields don't 
      * mark their form as dirty when check is fired.
      * 
      * 20130721 : `force_dirty` not as a parameter but as 
      * `this._force_dirty` because
      * 
      * 20130915 : both _force_dirty and force_dirty parameter are needed.
      * 
      */
      if (force_dirty || this._force_dirty || this.params_panel.form.isDirty()) {
      //~ if (this._force_dirty || this.params_panel.form.isDirty()) {
        p.pv = this.get_param_values();
        //~ console.log("20130923 form is dirty (",force_dirty,this._force_dirty,this.params_panel.form.isDirty(),")");
        //~ console.log("20130923 form is dirty",p);
      }else{
        //~ console.log("20130923 form not dirty:",this.params_panel.form);
        if (this.status_param_values) 
          p.pv = Lino.fields2array(
            this.params_panel.fields,this.status_param_values);
      }
      //~ if (!this.params_panel.form.isDirty()) return;
      //~ p.pv = this.get_param_values();
      //~ console.log("20120203 add_param_values added pv",p.pv,"to",p);
    }
  },
  get_param_values : function() { // similar to get_field_values()
      return Lino.fields2array(this.params_panel.fields);
  },
  set_param_values : function(pv) {
    if (this.params_panel) {
      //~ console.log('20120203 MainPanel.set_param_values', pv);
      this.status_param_values = pv;
      //~ this.params_panel.form.suspendEvents(false);
      this.setting_param_values = true;
      if (pv) { 
          this.params_panel.form.my_loadRecord(pv);
      } else { 
        this.params_panel.form.reset(); 
      }
      this.setting_param_values = false;
      this._force_dirty = false; 
      //~ this.params_panel.form.resumeEvents();
    }
  }
};




Lino.Viewport = Ext.extend(Ext.Viewport, Lino.MainPanel);
Lino.Viewport = Ext.extend(Lino.Viewport, {
  layout : "fit"
  ,is_home_page : true
  ,initComponent : function(){
    Lino.Viewport.superclass.initComponent.call(this);
    this.on('render',function(){
      this.loadMask = new Ext.LoadMask(this.el,{msg:"Bitte warten..."});
      //~ console.log("20121118 Lino.viewport.loadMask",this.loadMask);
    },this);
  }
  ,refresh : function() {
      var caller = this;
      // console.log("20140829 Lino.Viewport.refresh()");
      if (caller.loadMask) caller.loadMask.show();
      var success = function(response) {
        if (caller.loadMask) caller.loadMask.hide();
        if (response.responseText) {
          var result = Ext.decode(response.responseText);
          //~ console.log('Lino.do_action()',action.name,'result is',result);
          if (result.html) {
              var cmp = Ext.getCmp('dashboard');
              // cmp.removeAll(true);  // 20140829
              cmp.update(result.html, true);
          }
          if (result.message) {
              if (result.alert) {
                  //~ Ext.MessageBox.alert('Alert',result.alert_msg);
                  Ext.MessageBox.alert('Alert',result.message);
              } else {
                  Lino.notify(result.message);
              }
          }
          
          if (result.notify_msg) Lino.notify(result.notify_msg);
          if (result.js_code) { 
            var jsr = result.js_code(caller);
            //~ console.log('Lino.do_action()',action,'returned from js_code in',result);
          };
        }
      };
      var action = {
        url : '/api/main_html',
        waitMsg: "Bitte warten...",
        failure: Lino.ajax_error_handler(caller),
        success: success,
        method: 'GET',
        params: {}
      };
      Lino.insert_subst_user(action.params);
      Ext.Ajax.request(action);
    
  }
});




Lino.open_window = function(win, st, requesting_panel) {
  // console.log("20140831 Lino.open_window()", win, win.el.getBox());
  var cw = Lino.current_window;
  if (cw) {
    // console.log("20140829 Lino.open_window() save current status",
    //             cw.main_item.get_status());
    Lino.window_history.push({
      window:cw,
      status:cw.main_item.get_status()
    });
  }
  Lino.current_window = win;
  //~ if (st.su) 
      //~ Lino.subst_user_field.setValue(st.su);
  win.main_item.set_status(st, requesting_panel);
  // win.toFront();
  win.show();
};

Lino.load_url = function(url) {
    //~ foo.bar.baz = 2; 
    //~ console.log("20121120 Lino.load_url()");
    //~ Lino.body_loadMask.show();
    Lino.viewport.loadMask.show();
    //~ location.replace(url);
    document.location = url;
}

Lino.close_window = function(status_update, norestore) {
  // norestore is used when called by handle_action_result() who 
  // will call set_status itself later
  var cw = Lino.current_window;
  var ww = Lino.window_history.pop();
  var retval = cw.main_item.requesting_panel;
  // console.log(
  //     "20140917 Lino.close_window() going to close", cw.title,
  //     "previous is", ww, 
  //     "norestore is", norestore,
  //     "retval is", retval);
  if (ww) {
    //~ if (status_update) Ext.apply(ww.status,status_update);
    if(!norestore) {
        if (status_update) status_update(ww);
        ww.window.main_item.set_status(ww.status);
    }
    Lino.current_window = ww.window;
  } else {
      Lino.current_window = null;
      // new since 20140829:
      if(!norestore) { Lino.viewport.refresh(); }
  }
  if (cw) cw.hide_really();
  return retval;
};

Lino.kill_current_window = function() {
  // console.log("20140418 Lino.kill_current_window()");
  var cw = Lino.current_window;
  Lino.current_window = null;
  if (cw) cw.hide_really();
};

Lino.reload = function() {
    // First close all windows to ensure all changes are saved
    Lino.close_all_windows();

    // Then reload current view
    var url =  "/"

    var p = {};
    Lino.insert_subst_user(p)
    if (Ext.urlEncode(p))
        url = url + "?" + Ext.urlEncode(p);

    Lino.load_url(url);
}

Lino.handle_home_button = function() {
  if (Lino.window_history.length == 0)
      Lino.reload();
  else
      Lino.close_all_windows();
}

Lino.close_all_windows = function() {
    while (Lino.window_history.length > 0) {
        Lino.close_window();
    }
}

Lino.calling_window = function() {
    if (Lino.window_history.length) 
        return Lino.window_history[Lino.window_history.length-1];
}

//~ Lino.WindowAction = function(mainItemClass,windowConfig,mainConfig,ppf) {
Lino.WindowAction = function(windowConfig,main_item_fn) {
    //~ if(!mainConfig) mainConfig = {};
    //~ mainConfig.is_main_window = true;
    this.windowConfig = windowConfig;
    this.main_item_fn = main_item_fn;
    //~ if (ppf) mainConfig.params_panel.fields = ppf;
    //~ this.mainConfig = mainConfig;
    //~ this.mainItemClass = mainItemClass;
};

Lino.WindowAction = Ext.extend(Lino.WindowAction,{
    window : null,
    //~ mainItemClass: null,
    get_window : function() {
      //~ if(mainConfig) Ext.apply(this.mainConfig,mainConfig);
      // if (this.window == null || this.window.isDestroyed)  { // 20140829
      // if (this.window == null || this.window.getBox().width == 0)  { // 20140829
      if (this.window == null)  {
      // if (true)  {
          //~ this.windowConfig.main_item = new this.mainItemClass(this.mainConfig);
          this.windowConfig.main_item = this.main_item_fn();
          this.window = new Lino.Window(this.windowConfig);
      }
      return this.window;
    },
    run : function(requesting_panel, status) {
      // console.log('20140829 window_action.run()', this)
      Lino.open_window(this.get_window(), status, requesting_panel);
    }
  
});


Lino.PanelMixin = {
  get_containing_window : function (){
      if (this.containing_window) return this.containing_window;
      return this.containing_panel.get_containing_window();
  }
  ,set_window_title : function(title) {
    //~ this.setTitle(title);
    var cw = this.get_containing_window();

    //~ if (cw) {
    //~ if (cw && cw.closable) {
    if (cw && !cw.main_item.hide_window_title) {
      //~ console.log('20111202 set_window_title(',title,') for',this.containing_window);
      //~ if (! this.containing_window.rendered) console.log("WARNING: not rendered!");
      cw.setTitle(title);
    //~ } else {
      //~ document.title = title;
    }
    //~ else console.log('20111202 not set_window_title(',title,') for',this);
  }
  
};


// Lino.status_bar = new Ext.ux.StatusBar({defaultText:'Lino version 1.6.14.'});




Lino.edit_tinymce_text = function(panel, options) {
  // `panel` is the RichTextPanel
  //~ console.log(20111220,panel);
  //~ var rec = panel.get_current_record();
  var rec = panel.containing_panel.get_current_record();
  var value = rec ? rec.data[panel.editor.name] : '';
  var saving = false;
  var todo_after_save = false;
  var discard_changes = false;
  
  
  function save() {
    //~ if (todo_after_save) {alert('tried to save again'); return; }
    if (saving) {alert('tried to save again'); return; }
    //~ var url = panel.containing_window.main_item.get_record_url(rec.id);
    var url = panel.containing_panel.get_record_url(rec.id);
    var params = Ext.apply({}, panel.containing_panel.get_base_params());
    params[panel.editor.name] = editor.getValue();
    //~ params.su = Lino.subst_user;
    //~ Lino.insert_subst_user(params);
    var a = { 
      params: params, 
      method: 'PUT',
      url: url,
      failure: function() {
          //~ if (editor.ed.getContainer()) 
          editor.ed.setProgressState(0);
          todo_after_save = false;
          saving = false;
          console.log('tinymce.save() failed. sorry.',arguments);
        },
      success: function() {
        saving = false;
        //~ if (editor.ed.getContainer()) 
        editor.ed.setProgressState(0);
        rec.data[panel.editor.name] = editor.getValue();
        if(todo_after_save) {
            var fn = todo_after_save;
            todo_after_save = false;
            fn();
        }
        //~ panel.containing_window.set_current_record(rec);
        panel.refresh();
      }
    };
    //~ if (editor.ed.getContainer()) 
    editor.ed.setProgressState(1); // Show progress
    saving = true;
    //~ console.log(a);
    Ext.Ajax.request(a);
  };
  function save_callback() {
      save();
      //~ save(function(){editor.ed.setDirty(false);})
      /* return true have the save button disabled.  
      That's not perfect because the PUT is asynchronous 
      and the response is not yet known.
      */
      return true;
  }
  //~ var actions = [
    //~ {text:"Save",handler:save}
  //~ ]; 
  //~ console.log(20110610,panel.editor.disabled);
  var settings = {};
  Ext.apply(settings,{
        readonly: panel.editor.disabled,
        //~ language: "de",
        plugins : "save,emotions,spellchecker,advhr,insertdatetime,preview,table,searchreplace,template", 
        // Theme options - button# indicated the row# only
        theme_advanced_buttons1 : "save,cancel,|,bold,italic,underline,|,justifyleft,justifycenter,justifyright,fontselect,fontsizeselect,formatselect,|,search,replace",
        theme_advanced_buttons2 : "cut,copy,paste,template,|,bullist,numlist,|,outdent,indent,|,undo,redo,|,link,unlink,anchor,image,|,code,preview,|,forecolor,backcolor",
        theme_advanced_buttons3 : "insertdate,inserttime,|,spellchecker,advhr,,removeformat,|,sub,sup,|,charmap,emotions,|,tablecontrols",      
        theme_advanced_resizing : false,
        convert_urls : false,
        save_onsavecallback : save_callback,
        save_enablewhendirty : true
        //~ save_oncancelcallback: on_cancel
  });
  Ext.apply(settings,options);
  var editor = new Ext.ux.TinyMCE({
      value : value,
      tinymceSettings: settings
    });
  var win = new Ext.Window({
    title: rec.title, 
    //~ bbar: actions,
    layout: 'fit',
    items: editor,
    width: 600, 
    height:500,
    minWidth: 100,
		minHeight: 100,
    modal: true,
    resizable: true,
    maximizable: true,
    //~ maximized: true,
    //~ closeAction: "close"
    closeAction: "hide"
    //~ hideMode: "offsets",
    //~ constrainHeader: true,
    //~ bodyStyle: 'padding: 10px'
  });

  //~ win.on('beforeclose',function() {
  win.on('beforehide',function() {
    if (todo_after_save) return false;
    if (discard_changes) return true;
    if (editor.isDirty()) {
        //~ var ok = false;
        //~ var allowClose = true;
        var config = {title:"Bestätigung"};
        config.buttons = Ext.MessageBox.YESNOCANCEL;
        config.msg = "Änderungen im Text speichern?";
        config.modal = true;
        config.fn = function(buttonId,text,opt) {
          //~ console.log('do_when_clean',buttonId)
          if (buttonId == "yes") {
              /* we cancel this close, but save()'s onSuccess will call again.*/
              //~ allowClose = false;
              todo_after_save = function(){win.hide();}
              editor.ed.execCommand('mceSave');
              //~ editor.ed.save(function(){win.close();});
          } else if (buttonId == "no") { 
              discard_changes = true;
              win.hide()
          //~ } else if (buttonId == "cancel") { 
            //~ ok = true;
              //~ allowClose = false;
          //~ } else { 
            //~ console.log('unknwon buttonId:',buttonId);
          }
        }
        Ext.MessageBox.show(config);
        return false;
        //~ return allowClose;
    }
  });
  win.show();
}







/* 
  Originally copied from Ext JS Library 3.3.1
  Modifications by Luc Saffre : 
  - rendering of phantom records
  - fire afteredit event
  - react on dblclcik, not on single click

 */
Lino.CheckColumn = Ext.extend(Ext.grid.Column, {

    processEvent : function(name, e, grid, rowIndex, colIndex){
        //~ console.log('20110713 Lino.CheckColumn.processEvent',name)
        if (name == 'click') {
        //~ if (name == 'mousedown') {
        //~ if (name == 'dblclick') {
            return this.toggleValue(grid, rowIndex, colIndex);
        } else {
            return Ext.grid.ActionColumn.superclass.processEvent.apply(this, arguments);
        }
    },
    
    toggleValue : function (grid,rowIndex,colIndex) {
        var record = grid.store.getAt(rowIndex);
        var dataIndex = grid.colModel.getDataIndex(colIndex);
        // 20120514
        //~ if(record.data.disabled_fields && record.data.disabled_fields[dataIndex]) {
          //~ Lino.notify("Dieses Feld ist deaktiviert");
          //~ return false;
        //~ }
      
        //~ if (dataIndex in record.data['disabled_fields']) {
            //~ Lino.notify("This field is disabled.");
            //~ return false;
        //~ }
        var startValue = record.data[dataIndex];
        var value = !startValue;
        //~ record.set(this.dataIndex, value);
        var e = {
            grid: grid,
            record: record,
            field: dataIndex,
            originalValue: startValue,
            value: value,
            row: rowIndex,
            column: colIndex,
            cancel: false
        };
        if(grid.fireEvent("beforeedit", e) !== false && !e.cancel){
        //~ if(grid.fireEvent("validateedit", e) !== false && !e.cancel){
            record.set(dataIndex, value);
            delete e.cancel;
            grid.fireEvent("afteredit", e);
        }
        return false; // Cancel event propagation
    },

    renderer : function(v, p, record){
        if (record.phantom) return '';
        p.css += ' x-grid3-check-col-td'; 
        return String.format('<div class="x-grid3-check-col{0}">&#160;</div>', v ? '-on' : '');
    }

    // Deprecate use as a plugin. Remove in 4.0
    // init: Ext.emptyFn
});

// register ptype. Deprecate. Remove in 4.0
// Ext.preg('checkcolumn', Lino.CheckColumn);

// backwards compat. Remove in 4.0
// Ext.grid.CheckColumn = Lino.CheckColumn;

// register Column xtype
Ext.grid.Column.types.checkcolumn = Lino.CheckColumn;


/* 20110725 : 
Lino.on_tab_activate is necessary 
in contacts.Person.2.dtl 
(but don't ask me why...)
*/
Lino.on_tab_activate = function(item) {
  //~ console.log('activate',item); 
  if (item.rendered && item.doLayout) item.doLayout();
  //~ if (item.rendered) item.doLayout();
}

Lino.TimeField = Ext.extend(Ext.form.TimeField,{
  format: 'H:i',
  increment: 15
  });
Lino.DateField = Ext.extend(Ext.form.DateField,{
  //~ boxMinWidth: Lino.chars2width(15), // 20131005 changed from 11 to 15
  format: 'd.m.Y',
  altFormats: 'd/m/Y|Y-m-d'
  });
Lino.DatePickerField = Ext.extend(Ext.DatePicker,{
  //~ boxMinWidth: Lino.chars2width(11),
  format: 'd.m.Y',
  //~ altFormats: 'd/m/Y|Y-m-d'
  formatDate : function(date){
      //~ console.log("20121203 formatDate",this.name,date);
      return Ext.isDate(date) ? date.dateFormat(this.format) : date;
  }
  });
Lino.DateTimeField = Ext.extend(Ext.ux.form.DateTime,{
  dateFormat: 'd.m.Y',
  timeFormat: 'H:i'
  //~ ,hiddenFormat: 'd.m.Y H:i'
  });
Lino.URLField = Ext.extend(Ext.form.TriggerField,{
  triggerClass : 'x-form-search-trigger',
  //~ triggerClass : 'x-form-world-trigger',
  vtype: 'url',
  onTriggerClick : function() {
    //~ console.log('Lino.URLField.onTriggerClick',this.value)
    //~ document.location = this.value;
    window.open(this.getValue(),'_blank');
  }
});
Lino.IncompleteDateField = Ext.extend(Ext.form.TextField,{
  //~ regex: /^-?\d+-[01]\d-[0123]\d$/,
  //~ regex: /^[0123]\d\.[01]\d\.-?\d+$/,
  maxLength: 10,
  boxMinWidth: Lino.chars2width(10),
  regex: /^[0123]?\d\.[01]?\d\.-?\d+$/,
  regexText: 'Datum im Format JJJJ-MM-TT eingeben (Nullen für unbekannte Teile)'
  });


//~ Lino.make_dropzone = function(cmp) {
    //~ cmp.on('render', function(ct, position){
      //~ ct.el.on({
        //~ dragenter:function(event){
          //~ event.browserEvent.dataTransfer.dropEffect = 'move';
          //~ return true;
        //~ }
        //~ ,dragover:function(event){
          //~ event.browserEvent.dataTransfer.dropEffect = 'move';
          //~ event.stopEvent();
          //~ return true;
        //~ }
        //~ ,drop:{
          //~ scope:this
          //~ ,fn:function(event){
            //~ event.stopEvent();
            //~ console.log(20110516);
            //~ var files = event.browserEvent.dataTransfer.files;
            //~ if(files === undefined){
              //~ return true;
            //~ }
            //~ var len = files.length;
            //~ while(--len >= 0){
              //~ console.log(files[len]);
              //~ // this.processDragAndDropFileUpload(files[len]);
            //~ }
          //~ }
        //~ }
      //~ });
    //~ });
//~ };

//~ Lino.FileUploadField = Ext.ux.form.FileUploadField;

Lino.FileUploadField = Ext.extend(Ext.ux.form.FileUploadField,{
    unused_onRender : function(ct, position){
      Lino.FileUploadField.superclass.onRender.call(this, ct, position);
      this.el.on({
        dragenter:function(event){
          event.browserEvent.dataTransfer.dropEffect = 'move';
          return true;
        }
        ,dragover:function(event){
          event.browserEvent.dataTransfer.dropEffect = 'move';
          event.stopEvent();
          return true;
        }
        ,drop:{
          scope:this
          ,fn:function(event){
            event.stopEvent();
            //~ console.log(20110516);
            var files = event.browserEvent.dataTransfer.files;
            if(files === undefined){
              return true;
            }
            var len = files.length;
            while(--len >= 0){
              console.log(files[len]);
              //~ this.processDragAndDropFileUpload(files[len]);
            }
          }
        }
      });
    }
});

Lino.FileField = Ext.extend(Ext.form.TriggerField,{
  triggerClass : 'x-form-search-trigger',
  editable: false,
  onTriggerClick : function() {
    //~ console.log('Lino.URLField.onTriggerClick',this.value)
    //~ document.location = this.value;
    if (this.getValue()) window.open(MEDIA_URL + '/'+this.getValue(),'_blank');
  }
});

Lino.file_field_handler = function(panel,config) {
  if (panel.action_name == 'insert') {
      panel.has_file_upload = true;


      // config.value = '<br/><br/>';

      var f = new Lino.FileUploadField(config);
      //~ Lino.make_dropzone(f);
      return f;
      //~ return new Ext.ux.form.FileUploadField(config);
      //~ return new Lino.FileField(config);
      
  } else {
      //~ return new Lino.URLField(config);
      return new Lino.FileField(config);
  }
}

Lino.VBorderPanel = Ext.extend(Ext.Panel,{
    constructor : function(config) {
      config.layout = 'border';
      delete config.layoutConfig;
      Lino.VBorderPanel.superclass.constructor.call(this,config);
      for(var i=0; i < this.items.length;i++) {
        var item = this.items.get(i);
        if (this.isVertical(item) && item.collapsible) {
          item.on('collapse',this.onBodyResize,this);
          item.on('expand',this.onBodyResize,this);
        }
      }
    },
    isVertical : function(item) {
       return (item.region == 'north' || item.region == 'south' || item.region == 'center');
    },
    onBodyResize: function(w, h){
        //~ console.log('VBorderPanel.onBodyResize',this.title)
      if (this.isVisible()) { // to avoid "Uncaught TypeError: Cannot call method 'getHeight' of undefined."
        var sumflex = 0;
        var availableHeight = this.getInnerHeight();
        var me = this;
        this.items.each(function(item){
          if (me.isVertical(item)) {
              if (item.collapsed || item.flex == 0 || item.flex === undefined) {
                  if (item.rendered) availableHeight -= item.getHeight();
              } else {
                  sumflex += item.flex;
              }
          } 
          
        });
        //~ for(var i=0; i < this.items.length;i++) {
          //~ var item = this.items.get(i);
          //~ // if (this.isVertical(item) && item.getResizeEl()) {
          //~ if (this.isVertical(item)) {
              //~ if (item.collapsed || item.flex == 0 || item.flex === undefined) {
                  //~ // item.syncSize()
                  //~ // item.doLayout()
                  //~ // if (item.region == "north") console.log('region north',item.getHeight(),item.id, item);
                  //~ // if (item.getHeight() == 0) console.log(20100921,'both flex and getHeight() are 0!');
                  //~ availableHeight -= item.getHeight();
              //~ } else {
                  //~ sumflex += item.flex;
                  //~ // console.log(item.flex);
              //~ }
          //~ } 
          //~ // else console.log('non-vertical item in VBoderPanel:',item)
        //~ }
        var hunit = availableHeight / sumflex;
        //~ console.log('sumflex=',sumflex,'hunit=',hunit, 'availableHeight=',availableHeight);
        for(var i=0; i < this.items.length;i++) {
          var item = this.items.get(i);
          if (this.isVertical(item)) {
              if (item.flex != 0 && ! item.collapsed) {
                  item.setHeight(hunit * item.flex);
                  //~ console.log(item.region,' : height set to',item.getHeight());
              }
          }
          //~ else console.log('non-vertical item in VBoderPanel:',item)
        }
      }
      Lino.VBorderPanel.superclass.onBodyResize.call(this, w, h);
    }
});


/*
  modifications to the standard behaviour of a CellSelectionModel:
  
*/
Ext.override(Ext.grid.CellSelectionModel, {
//~ var dummy = {

    handleKeyDown : function(e){
        /* removed because F2 wouldn't pass
        if(!e.isNavKeyPress()){
            return;
        }
        */
        //~ console.log('handleKeyDown',e)
        var k = e.getKey(),
            g = this.grid,
            s = this.selection,
            sm = this,
            walk = function(row, col, step){
                return g.walkCells(
                    row,
                    col,
                    step,
                    g.isEditor && g.editing ? sm.acceptsNav : sm.isSelectable, 
                    sm
                );
            },
            cell, newCell, r, c, ae;

        switch(k){
            case e.ESC:
            case e.PAGE_UP:
            case e.PAGE_DOWN:
                break;
            default:
                // e.stopEvent(); // removed because Browser keys like Alt-Home, Ctrl-R wouldn't work
                break;
        }

        if(!s){
            cell = walk(0, 0, 1); 
            if(cell){
                this.select(cell[0], cell[1]);
            }
            return;
        }

        cell = s.cell;  
        r = cell[0];    
        c = cell[1];    
        
        switch(k){
            case e.TAB:
                if(e.shiftKey){
                    newCell = walk(r, c - 1, -1);
                }else{
                    newCell = walk(r, c + 1, 1);
                }
                break;
            case e.HOME:
                if (! (g.isEditor && g.editing)) {
                  if (!e.hasModifier()){
                      newCell = [r, 0];
                      //~ console.log('home',newCell);
                      break;
                  }else if(e.ctrlKey){
                      var t = g.getTopToolbar();
                      var activePage = Math.ceil((t.cursor + t.pageSize) / t.pageSize);
                      if (activePage > 1) {
                          e.stopEvent();
                          t.moveFirst();
                          return;
                      }
                      newCell = [0, c];
                      break;
                  }
                }
            case e.END:
                if (! (g.isEditor && g.editing)) {
                  c = g.colModel.getColumnCount()-1;
                  if (!e.hasModifier()) {
                      newCell = [r, c];
                      //~ console.log('end',newCell);
                      break;
                  }else if(e.ctrlKey){
                      var t = g.getTopToolbar();
                      var d = t.getPageData();
                      if (d.activePage < d.pages) {
                          e.stopEvent();
                          var self = this;
                          t.on('change',function(tb,pageData) {
                              var r = g.store.getCount()-2;
                              self.select(r, c);
                              //~ console.log('change',r,c);
                          },this,{single:true});
                          t.moveLast();
                          return;
                      } else {
                          newCell = [g.store.getCount()-1, c];
                          //~ console.log('ctrl-end',newCell);
                          break;
                      }
                  }
                }
            case e.DOWN:
                newCell = walk(r + 1, c, 1);
                break;
            case e.UP:
                newCell = walk(r - 1, c, -1);
                break;
            case e.RIGHT:
                newCell = walk(r, c + 1, 1);
                break;
            case e.LEFT:
                newCell = walk(r, c - 1, -1);
                break;
            case e.F2:
                if (!e.hasModifier()) {
                    if (g.isEditor && !g.editing) {
                        g.startEditing(r, c);
                        e.stopEvent();
                        return;
                    }
                    break;
                }
            case e.INSERT:
                if (!e.hasModifier()) {
                    if (g.ls_insert_handler && !g.editing) {
                        e.stopEvent();
                        Lino.show_insert(g);
                        return;
                    }
                    break;
                }
            // case e.DELETE:
            //     if (!e.hasModifier()) {
            //         if (!g.editing) {
            //             e.stopEvent();
            //             Lino.delete_selected(g);
            //             return;
            //         }
            //         break;
            //     }

            case e.ENTER:
                e.stopEvent();
                g.onCellDblClick(r,c);
                break;

            default:
                g.handle_key_event(e);
                
        }
        

        if(newCell){
          e.stopEvent();
          r = newCell[0];
          c = newCell[1];
          this.select(r, c); 
          if(g.isEditor && g.editing){ 
            ae = g.activeEditor;
            if(ae && ae.field.triggerBlur){
                ae.field.triggerBlur();
            }
            g.startEditing(r, c);
          }
        //~ } else if (g.isEditor && !g.editing && e.charCode) {
        //~ // } else if (!e.isSpecialKey() && g.isEditor && !g.editing) {
            //~ g.set_start_value(String.fromCharCode(e.charCode));
            //~ // g.set_start_value(String.fromCharCode(k));
            //~ // g.set_start_value(e.charCode);
            //~ g.startEditing(r, c);
            //~ // e.stopEvent();
            //~ return;
        // } else {
          // console.log('20120513',e,g);
        }
        
    }


//~ };
});

 

function PseudoConsole() {
    this.log = function() {};
};
if (typeof(console) == 'undefined') console = new PseudoConsole();

Lino.notify = function(msg) {
  if (msg == undefined) msg = ''; else console.log(msg);
  
    if (msg == undefined) return;
    // Lino.alert(msg);
  
};

Lino.alert = function(msg) {
  Ext.MessageBox.alert('Notify',msg);
};


//~ Lino.show_about = function() {
  //~ new Ext.Window({
    //~ width: 400, height: 400,
    //~ title: "About",
    //~ html: '<a href="http://www.extjs.com" target="_blank">ExtJS</a> version ' + Ext.version
  //~ }).show();
//~ };

function obj2str(o) {
  if (typeof o != 'object') return String(o);
  var s = '';
  for (var p in o) {
    s += p + ': ' + obj2str(o[p]) + '\n';
  }
  return s;
}

Lino.on_store_exception = function (store,type,action,options,response,arg) {
  //~ throw response;
  console.log("on_store_exception: store=",store,
    "type=",type,
    "action=",action,
    "options=",options,
    "response=",response,
    "arg=",arg);
  if (arg) { console.log(arg.stack)};
};

//~ Lino.on_submit_success = function(form, action) {
   //~ Lino.notify(action.result.message);
   //~ this.close();
//~ };

Lino.on_submit_failure = function(form, action) {
    //~ Lino.notify();
  // action may be undefined
    switch (action.failureType) {
        case Ext.form.Action.CLIENT_INVALID:
            Ext.Msg.alert('Client-side failure', 'Form fields may not be submitted with invalid values');
            break;
        case Ext.form.Action.CONNECT_FAILURE:
            Ext.Msg.alert('Connection failure', 'Ajax communication failed');
            break;
        case Ext.form.Action.SERVER_INVALID:
            Ext.Msg.alert('Server-side failure', action.result.message);
   }
};



/*
Lino.save_wc_handler = function(ww) {
  return function(event,toolEl,panel,tc) {
    var pos = panel.getPosition();
    var size = panel.getSize();
    wc = ww.get_window_config();
    Ext.applyIf(wc,{ 
      x:pos[0],y:pos[1],height:size.height,width:size.width,
      maximized:panel.maximized});
    Lino.do_action(ww,{url:'/window_configs/'+ww.config.permalink_name,params:wc,method:'POST'});
  }
};

*/

Lino.show_in_own_window_button = function(handler) {
  return {
    qtip: "Dieses Panel in eigenem Fenster öffnen", 
    id: "up",
    handler: function(event,toolEl,panel, tc) {
      //~ console.log('20111206 report_window_button',panel,handler);
      handler.run(null,{base_params:panel.containing_panel.get_master_params()});
    }
  }
}

Lino.action_handler = function (panel, on_success, on_confirm) {
  return function (response) {
      if (!panel) { 
          if (Lino.current_window) 
              panel = Lino.current_window.main_item;
          else panel = Lino.viewport;
      }
      
    if (panel.loadMask) panel.loadMask.hide(); // 20120211
    if (!response.responseText) return ;
    var result = Ext.decode(response.responseText);
    Lino.handle_action_result(panel, result, on_success, on_confirm);
  }
};

Lino.handle_action_result = function (panel, result, on_success, on_confirm) {

    // console.log('20141127 Lino.handle_action_result()', result);
    
    // if (panel instanceof Lino.GridPanel) {
    //     gridmode = true;
    // } else {
    //     gridmode = false;
    // }

    //~ if (result.goto_record) {
        //~ var js = "Lino." + result.goto_record[0] + '.detail.run';
        //~ var h = eval(js);
        //~ h(panel,{record_id:result.goto_record[1]});
    //~ }
    
    if (result.xcallback) {
        //~ var config = {title:"Bestätigung"};
        var config = {title:result.xcallback.title};
        //~ config.buttons = Ext.MessageBox.YESNOCANCEL;
        //~ config.buttons = Ext.MessageBox.YESNO;
        var p = {};
        Lino.insert_subst_user(p);
        config.buttons = result.xcallback.buttons;
        config.msg = result.message;
        config.fn = function(buttonId, text, opt) {
          panel.loadMask.show(); 
          //~ Lino.insert_subst_user(p);
          Ext.Ajax.request({
            method: 'GET',
            url: '/callbacks/'
                  + result.xcallback.id + '/' + buttonId,
            params: p,
            success: Lino.action_handler(panel, on_success, on_confirm)
          });
        }
        Ext.MessageBox.show(config);
        return;
    }

    // `record_id` and/or `data_record` both mean "display the detail
    // of this record". 
    
    if(result.detail_handler_name) {
        // TODO: make sure that result.detail_handler_name is secure
        var detail_handler = eval("Lino." + result.detail_handler_name);
    }
    var ns = {};  // new status
    if (result.close_window) {
        
        if(result.record_id || result.data_record) {
            var ww = Lino.calling_window();
            if (ww && ww.window.main_item instanceof Lino.FormPanel) {
                if (ww.window.main_item.ls_detail_handler == detail_handler) {
                    ns.record_id = result.record_id;
                    ns.data_record = result.data_record;
                    console.log("20140630 use new status.");
                }
            }
        }

        // Subsequent processing expects that `panel` is "the current
        // panel". Since we close the window, `panel` should now point
        // to the previous window. Note the case of an insert window
        // that has been invoked by double-clicking on the phantom row
        // of a slave table in a detail window. In that case we want
        // `panel` to become the grid panel of the slave table who
        // called the insert window, not the master's detail form
        // panel.  When the insert window has been called by an action
        // link (e.g. generated using ar.insert_button), then
        // Lino.close_window can return `undefined`.

        panel = Lino.close_window(function(st) {Ext.apply(st, ns)}); 
        if (!panel) 
            panel = Lino.current_window.main_item;

    }

    if(result.record_id || result.data_record) {
        if (! (ns.record_id || ns.data_record)) {
          if (panel instanceof Lino.FormPanel 
              && panel.ls_detail_handler == detail_handler) 
            {
              // console.log("20140630 use panel.set_status().");
              panel.set_status({
                  record_id: result.record_id,
                  data_record: result.data_record});
          } else {
              // console.log("20140630 run detail_handler.");
              detail_handler.run(null, {
                  record_id: result.record_id,
                  data_record: result.data_record,
                  base_params: panel.get_base_params()});
          }

          // if (panel instanceof Lino.FormPanel 
          //     && panel.ls_url == result.actor_url) {
          //     // console.log("20140506 case 2 it's a FormPanel:", panel);
          //     panel.set_status({
          //         record_id: result.record_id,
          //         data_record: result.data_record});
          // } else if (panel.ls_detail_handler 
          //            && panel.ls_url == result.actor_url) {
          //     // console.log("20140506 case 4");
          //     panel.ls_detail_handler.run(null, {
          //         record_id: result.record_id,
          //         data_record: result.data_record,
          //         base_params: panel.get_base_params()});
          // } else {
          //     result.refresh_all = true;
          //     console.log("20140604 case 6", result.actor_url);
          // }
        }
    }

    // `eval_js` must get handled after `close_window` because it
    // might ask to open a new window (and we don't want to close that
    // new window).  It must execute *before* any MessageBox,
    // otherwise the box would get hidden by a window that opens
    // afterwards.

    if (result.eval_js) {
        //~ console.log(20120618,result.eval_js);
        eval(result.eval_js);
    }
    
    if (on_success && result.success) {
        // console.log("20140430 handle_action_result calls on_success", 
        //             on_success);
        on_success(result);
    }
    
    if (result.info_message) {
        console.log(result.info_message);
    }
    
    if (result.warning_message) {
        if (!result.alert) result.alert = "Warnung";
        Ext.MessageBox.alert(result.alert, result.warning_message);
    }
    
    if (result.message) {
        //~ if (result.alert && ! gridmode) {
        if (result.alert) { // 20120628b 
            //~ Ext.MessageBox.alert('Alert',result.alert_msg);
            if (result.alert === true) result.alert = "Alarm";
            Ext.MessageBox.alert(result.alert, result.message);
        } else {
            Lino.notify(result.message);
        }
    }

    if(result.record_deleted && panel.ls_detail_handler == detail_handler) {
        panel.after_delete();
    }
    
    if (result.refresh_all) {
        var cw = Lino.current_window;
        // var cw = panel.get_containing_window();
        if (cw) {
            // console.log("20140917 refresh_all calls refresh on", cw.main_item);
            cw.main_item.refresh();
        }
        // else console.log("20140917 cannot refresh_all because ",
        //                  "there is no current_window");
    } else {
        if (result.refresh) {
            // console.log("20140917 Gonna call panel.refresh()", panel);
            panel.refresh();
        }
    }if (result.open_davlink_url) {
       Lino.davlink_open(result.open_davlink_url);
    }if (result.open_url) {
        //~ console.log(20111126,result.open_url);
        //~ if (!result.message)
            //~ Lino.notify('Open new window <a href="'+result.open_url+'" target="_blank">'+result.open_url+'</a>');
        window.open(result.open_url,'foo',"");
        //~ document.location = result.open_url;
    }
};

// obsolete but still used for deleting records.
Lino.do_action = function(caller,action) { 
  action.success = function(response) {
    if (caller.loadMask) caller.loadMask.hide();
    //~ console.log('Lino.do_action()',action,'action success',response);
    if (action.after_success) {
        //~ console.log('Lino.do_action() calling after_success');
        action.after_success();
    }
    if (response.responseText) {
      var result = Ext.decode(response.responseText);
      //~ console.log('Lino.do_action()',action.name,'result is',result);
      if (result.message) {
          if (result.alert) {
              //~ Ext.MessageBox.alert('Alert',result.alert_msg);
              Ext.MessageBox.alert('Alert',result.message);
          } else {
              Lino.notify(result.message);
          }
      }
      
      //~ if (result.alert_msg) Ext.MessageBox.alert('Alert',result.alert_msg);
      //~ if (result.message) Lino.notify(result.message);
      if (result.notify_msg) Lino.notify(result.notify_msg);
      if (result.js_code) { 
        //~ console.log('Lino.do_action()',action,'gonna call js_code in',result);
        var jsr = result.js_code(caller);
        //~ console.log('Lino.do_action()',action,'returned from js_code in',result);
        if (action.after_js_code) {
          //~ console.log('Lino.do_action()',action,'gonna call after_js_code');
          action.after_js_code(jsr);
          //~ console.log('Lino.do_action()',action,'returned from after_js_code');
        //~ } else {
          //~ console.log('Lino.do_action()',action,' : after_js_code is false');
        }
      };
    }
  };
  Ext.applyIf(action,{
    waitMsg: "Bitte warten...",
    failure: Lino.ajax_error_handler(caller),
    params: {}
  });
  //~ action.params.su = Lino.subst_user;
  Lino.insert_subst_user(action.params);
  
  Ext.Ajax.request(action);
};

//~ Lino.gup = function( name )
//~ {
  //~ // Thanks to http://www.netlobo.com/url_query_string_javascript.html
  //~ name = name.replace(/[\[]/,"\\\[").replace(/[\]]/,"\\\]");
  //~ var regexS = "[\\?&]"+name+"=([^&#]*)";
  //~ var regex = new RegExp( regexS );
  //~ var results = regex.exec( window.location.href );
  //~ if( results == null )
    //~ return "";
  //~ else
    //~ return results[1];
//~ };

//~ Lino.refresh_handler = function (ww) {
  //~ return function() { 
      //~ console.log('refresh',ww);
      //~ ww.main_item.doLayout(false,true);
      //~ ww.main_item.syncSize();
  //~ }
//~ };

//~ Lino.tools_close_handler = function (ww) {
  //~ return function() { 
      //~ ww.close();
  //~ }
//~ };
Lino.permalink_handler = function (ww) {
  return function() { 
    //~ document.location = ww.main_item.get_permalink();
    //~ console.log('20130723 Lino.permalink_handler',ww);
    
    /* Uncaught TypeError: Cannot read property 'main_item' of null  */
    if (ww) {
        var url = ww.main_item.get_permalink();
    } else {
        var url = Lino.viewport.get_permalink();
    }
    Lino.load_url(url);
  }
};
//~ Lino.run_permalink = function() {
  //~ var plink = Lino.gup('permalink');
  //~ if(plink) { eval('Lino.'+plink); }
//~ }


Lino.ajax_error_handler = function(panel) {
  return function(response,options) {
    console.log('Ajax failure:', response, options);
    if (panel.loadMask) panel.loadMask.hide();
    if (response.responseText) {
      var lines = response.responseText.split('\n');
      if (lines.length > 10) {
          line = lines.splice(5, lines.length-10, "(...)");
      }
      //~ console.log(20131005, response.statusText.toCamel());
      Ext.MessageBox.alert(
        response.statusText.toCamel(),
        lines.join('<br/>')
        //~ response.responseText.replace(/\n/g,'<br/>'))
      )
    } else {
      Ext.MessageBox.alert('Action failed',
        'Lino server did not respond to Ajax request');
    }
  }
}
// Ext.Ajax.on('requestexception',Lino.ajax_error_handler)
 


Ext.QuickTips.init();

/* setting QuickTips dismissDelay to 0 */
// Apply a set of config properties to the singleton
//~ Ext.apply(Ext.QuickTips.getQuickTip(), {
//~ Ext.apply(Ext.ToolTip, {
    //~ dismissDelay: 0
    //~ autoHide: false,
    //~ closable: true,
    //~ maxWidth: 200,
    //~ minWidth: 100,
    //~ showDelay: 50      // Show 50ms after entering target
    //~ ,trackMouse: true
//~ });


//~ Ext.apply(Ext.QuickTip, {
    //~ dismissDelay: 0,
//~ });
  
Lino.quicktip_renderer = function(title,body) {
  return function(c) {
    //~ if (c instanceof Ext.Panel) var t = c.bwrap; else // 20130129
    if (c instanceof Ext.Panel) var t = c.header; else // 20130129
    var t = c.getEl();
    //~ console.log(20130129,t,title,body);
    //~ t.dismissDelay = 0;
    Ext.QuickTips.register({
      target: t,
      //~ cls: 'lino-quicktip-classical',
      dismissDelay: 0,
      //~ autoHide: false,
      showDelay: 50,      // Show 50ms after entering target
      //~ title: title,
      text: body
    });
  }
};


  
Lino.help_text_editor = function() {
  //~ var bp = {
      //~ mk:this.content_type,
      //~ mt:1
    //~ };
    //~ console.log(20120202,bp);
  //~ Lino.lino.ContentTypes.detail({},{base_params:bp});
  //~ Lino.lino.ContentTypes.detail.run(null,{record_id:this.content_type});
  Lino.lino.ContentTypes.detail.run(null,{record_id:this.content_type});
}

// Path to the blank image should point to a valid location on your server
//~ Ext.BLANK_IMAGE_URL = MEDIA_URL + '/extjs/resources/images/default/s.gif'; 


// used as Ext.grid.Column.renderer for id columns in order to hide the special id value -99999
Lino.id_renderer = function(value, metaData, record, rowIndex, colIndex, store) {
  //~ if (record.phantom) return '';
  return value;
}

Lino.raw_renderer = function(value, metaData, record, rowIndex, colIndex, store) {
  return value;
}

Lino.text_renderer = function(value, metaData, record, rowIndex, colIndex, store) {
  //~ return "not implemented"; 
  return value;
}

Lino.NullNumberColumn = Ext.extend(Ext.grid.Column, {
    align : 'right', 
    format : '0,00/i', 
    renderer : function(value, metaData, record, rowIndex, colIndex, store) {
        //~ console.log(20130128,"NullNumberColumn.renderer",value);
        if (value === null) return '';
        return Ext.util.Format.number(value, this.format);
    }
});


Lino.link_button = function(url) {
    // return '<a href="' + url + '"><img src="/media/lino/extjs/images/xsite/link.png" alt="link_button"></a>'
    return '<a href="' + url + '" style="text-decoration:none;">&#10138;</a>'
}

Lino.fk_renderer = function(fkname,handlername) {
  //~ console.log('Lino.fk_renderer handler=',handler);
  return function(value, metaData, record, rowIndex, colIndex, store) {
    //~ console.log('Lino.fk_renderer',fkname,rowIndex,colIndex,record,metaData,store);
    //~ if (record.phantom) return '';
    if (value) {
        return Lino.link_button('javascript:'+handlername + '.run(null,{record_id:\'' + String(record.data[fkname]) + '\'})")') + value;
        // until 20140822 (clickable foreign keys):
        // var s = '<a href="javascript:' ;
        // s += handlername + '.run(null,{record_id:\'' + String(record.data[fkname]) + '\'})">';
        // s += value + '</a>';
        // return s
    }
    return '';
  }
};

Lino.lfk_renderer = function(panel,fkname) {
  //~ console.log('Lino.fk_renderer handler=',handler);
  var handlername = 'console.log';
  return function(value, metaData, record, rowIndex, colIndex, store) {
    //~ console.log('Lino.fk_renderer',fkname,rowIndex,colIndex,record,metaData,store);
    if (record.phantom) return '';
    if (value) {
        var s = '<a href="javascript:' ;
        s += handlername + '({},{record_id:\'' + String(record.data[fkname]) + '\'})">';
        s += value + '</a>';
        //~ console.log('Lino.fk_renderer',value,'-->',s);
        return s
    }
    return '';
  }
};

//~ Lino.gfk_renderer = function() {
  //~ return function(value, metaData, record, rowIndex, colIndex, store) {
    //~ if (record.phantom) return '';
    //~ console.log('Lino.gfk_renderer',value,colIndex,record,metaData,store);
    //~ return value;
  //~ }
//~ };


Lino.build_buttons = function(panel,actions) {
  //~ console.log("20121006 Lino.build_buttons",actions);
  if (actions) {
    var buttons = Array(actions.length);
    var cmenu = Array(actions.length);
    var keyhandlers = {};
    for (var i=0; i < actions.length; i++) { 
      var a = actions[i];
      if (a.menu) a.menu = Lino.build_buttons(panel,a.menu).bbar;
      buttons[i] = a;
      cmenu[i] = {
            text : a.menu_item_text,
            iconCls : a.iconCls,
            menu : a.menu
          };
      if (a.panel_btn_handler) {
          var h = a.panel_btn_handler.createCallback(panel);
          if (a.auto_save == true) {
              h = panel.do_when_clean.createDelegate(panel,[true,h]);
          } else if (a.auto_save == null) {
              h = panel.do_when_clean.createDelegate(panel,[false,h]);
          } else if (a.auto_save == false) {
              // h = h;
          } else {
              console.log("20120703 unhandled auto_save value",a)
          }
          buttons[i].handler = h;
          cmenu[i].handler = h;
          if (a.keycode) {
              keyhandlers[a.keycode] = h;
          }
          //~ if (buttons[i].xtype == 'splitbutton') {
              //~ cmenu[i].menu = a.menu;
          //~ } else {
              //~ cmenu[i].handler = h;
          //~ }
      } else {
          console.log("action without panel_btn_handler",a)
          // cmenu[i].handler = a.handler;
      }
    }
    return {
        bbar:buttons, 
        cmenu:new Ext.menu.Menu(cmenu),
        keyhandlers: keyhandlers
    };
  }
}

Lino.do_when_visible = function(cmp,todo) {
  //~ if (cmp.el && cmp.el.dom) 
  if (cmp.isVisible()) { 
    // 'visible' means 'rendered and not hidden'
    //~ console.log(cmp.title,'-> cmp is visible now');
    todo(); 
  //~ } else {
      //~ cmp.on('resize',todo,cmp,{single:true});
  //~ }
  //~ if (false) { // 20120213
  } else { 
    //~ console.log('Lino.do_when_visible() must defer because not isVisible()',todo,cmp);
    if (cmp.rendered) {
      //~ console.log(cmp,'-> cmp is rendered but not visible: and now?');
      //~ console.log(cmp.title,'-> cmp is rendered but not visible: try again in a moment...');
      //~ var fn = function() {Lino.do_when_visible(cmp,todo)};
      //~ fn.defer(100);
      
      Lino.do_when_visible.defer(50,this,[cmp,todo]);
      //~ Lino.do_when_visible.defer(100,this,[cmp,todo]);
      
    } else {
      //~ console.log(cmp.title,'-> after render');
      cmp.on('afterrender',todo,cmp,{single:true});
    }
  }
  
};    

/*
*/
Lino.do_on_current_record = function(panel, fn, phantom_fn) {
  // console.log('20140930 do_on_current_record', arguments);
  var rec = panel.get_current_record();
  if (rec == undefined) {
    Lino.notify("There's no selected record.");
    return;
  }
  // 20120307 A VirtualTable with a Detail (lino.Models) has only "phantom" records.
  if (rec.phantom) {
    //~ if (!panel.editable) { console.log("20120312 not editable:",panel)}
    if (phantom_fn) {
      phantom_fn(panel);
    } else {
      Lino.notify("Aktion nicht verfügbar auf dem Phantom-Record.");
    }
    return;
  }
  return fn(rec);
};


Lino.call_ajax_action = function(
    panel, method, url, p, actionName, step, on_confirm, on_success) {
  p.an = actionName;
  if (!panel || !panel.isVisible()) {
  //~ if (true) { // 20131026 : workflow_actions of a newly created record detail executed but did't refresh the screen because their requesting panel was the insert (not the detail) formpanel.
      if (Lino.current_window) 
          panel = Lino.current_window.main_item;
      else panel = Lino.viewport;
  }
  Ext.apply(p, panel.get_base_params());

  if (panel.get_selected) {
      var selected_recs = panel.get_selected();
      //~ console.log("20130831",selected_recs);
      var rs = Array(selected_recs.length);
      for(var i=0; i < selected_recs.length;i++) {
          rs[i] = selected_recs[i].data.id;
      };
      p.sr = rs;
  }
  
  // console.log("20140516 Lino.call_ajax_action", p, actionName, step);
  
  if (panel.loadMask) panel.loadMask.show(); 
    
  Ext.Ajax.request({
    method: method
    ,url: url
    ,params: p
    ,success: Lino.action_handler(panel, on_success, on_confirm)
    ,failure: Lino.ajax_error_handler(panel)
  });
};




Lino.row_action_handler = function(actionName, hm, pp) {
  var p = {};
  var fn = function(panel, btn, step) {
      // console.log('20140930 row_action_handler');
      if (pp) { p = pp(panel); if (! p) return; }
      
      if (!panel || panel.get_current_record == undefined) { // AFTER_20130725
        // console.log('20140930 row_action_handler 2', panel);
        panel = Ext.getCmp(panel);
        if (panel == undefined) {
          Lino.notify("Invalid panel spec.");
          return;
        }
      }
      
      Lino.do_on_current_record(panel, function(rec) {
          //~ console.log(panel);
          panel.add_param_values(p, true);
          Lino.call_ajax_action(
              panel, hm, panel.get_record_url(rec.id), 
              p, actionName, step, fn);
      });
  };
  return fn;
};

Lino.list_action_handler = function(ls_url,actionName,hm,pp) {
  var p = {};
  var url = '/api' + ls_url
  var fn = function(panel,btn,step) {
      //~ console.log("20121210 Lino.list_action_handler",arguments);
      if (pp) { p = pp(panel);  if (! p) return; }
      if (panel)  // may be undefined when called e.g. from quicklink
          panel.add_param_values(p,true);
      Lino.call_ajax_action(panel, hm,url, p, actionName, step, fn);
  };
  return fn;
};

Lino.param_action_handler = function(window_action) { // 20121012
  var fn = function(panel,btn,step) {
    Lino.do_on_current_record(panel,function(rec) {
      window_action.run(panel.getId(),{}); 
    });
  };
  return fn;
};


Lino.run_row_action = function(
    requesting_panel, url, meth, pk, actionName, params, preprocessor) {
  //~ var panel = action.get_window().main_item;
    console.log("20140930 Lino.run_row_action", params);
  url = '/api' + url  + '/' + pk;
  var panel = Ext.getCmp(requesting_panel);
  if (!params) params = {};
  if (preprocessor) {
      var p = preprocessor(); 
      Ext.apply(params, p);
  }
  var fn = function(panel, btn, step) {
    Lino.call_ajax_action(panel, meth, url, params, actionName, step, fn);
  }
  fn(panel, null, null);
}

Lino.put = function(requesting_panel, pk, data) {
    var panel = Ext.getCmp(requesting_panel);
    //~ var panel = null; // 20131026
    var p = {};
    p.an = 'put'; // SubmitDetail.action_name

    Ext.apply(p,data);
    var req = {
        params:p
        ,waitMsg: 'Saving your data...'
        ,scope: panel
        ,success: Lino.action_handler( panel, function(result) { 
            panel.refresh();
        })
        ,failure: Lino.ajax_error_handler(panel)
    };
    req.method = 'PUT';
    req.url = '/api' + panel.ls_url + '/' + pk;
    if (panel.loadMask) panel.loadMask.show(); 
    Ext.Ajax.request(req);
}



Lino.show_detail = function(panel, btn) {
  Lino.do_on_current_record(panel, 
    function(rec) {
      //~ panel.loadMask.show();
      Lino.run_detail_handler(panel, rec.id);
    },
    Lino.show_insert
  );
};

Lino.run_detail_handler = function(panel,pk) {
  var bp = panel.get_base_params();
  panel.add_param_values(bp); // 20120918
  var status = {
    record_id:pk,
    base_params:bp
  }
  //~ console.log("20120918 Lino.show_detail",status);
  panel.ls_detail_handler.run(null,status);
}

Lino.show_fk_detail = function(combo,detail_action,insert_action) {
    //~ console.log("Lino.show_fk_detail",combo,handler);
    pk = combo.getValue();
    if (pk) {
        detail_action.run(null,{record_id: pk})
      } else {
        insert_action.run(null,{record_id:-99999});
        //~ Lino.notify("Cannot show detail for empty foreign key.");
      }
};

Lino.show_insert = function(panel,btn) {
  var bp = panel.get_base_params();
  //~ console.log('20120125 Lino.show_insert',bp)
  //~ panel.ls_insert_handler.run(null,{record_id:-99999,base_params:bp});
  panel.ls_insert_handler.run(panel.getId(),{record_id:-99999,base_params:bp});
};



if (Ext.ux.grid !== undefined) {
    Lino.GridFilters = Ext.extend(Ext.ux.grid.GridFilters,{
      encode:true,
      local:false
    });
} else {
    Lino.GridFilters = function() {}; // dummy
    Ext.override(Lino.GridFilters,{
      init : function() {}
    });
};



Lino.FieldBoxMixin = {
  before_init : function(config,params) {
    if (params) Ext.apply(config,params);
    var actions = Lino.build_buttons(this, config.ls_bbar_actions);
    if (actions) config.bbar = actions.bbar;
  },
  //~ constructor : function(ww,config,params){
    //~ this.containing_window = ww;
    //~ if (params) Ext.apply(config,params);
    //~ var actions = Lino.build_buttons(this,config.ls_bbar_actions);
    //~ if (actions) config.bbar = actions.bbar;
    //~ Lino.FieldBoxMixin.superclass.constructor.call(this, config);
  //~ },
  do_when_clean : function(auto_save,todo) { todo() },
  //~ format_data : function(html) { return '<div class="htmlText">' + html + '</div>' },
  format_data : function(html) { return html },
  get_base_params : function() {
    // needed for insert action
    var p = Ext.apply({}, this.base_params);
    Lino.insert_subst_user(p);
    return p;
  },
  set_base_params : function(p) {
    this.base_params = Ext.apply({},p);
    //~ if (p.param_values) this.set_param_values(p.param_values);  
  },
  clear_base_params : function() {
      this.base_params = {};
      Lino.insert_subst_user(this.base_params);
  },
  set_base_param : function(k,v) {
    this.base_params[k] = v;
  }
};



Lino.HtmlBoxPanel = Ext.extend(Ext.Panel, Lino.PanelMixin);
Lino.HtmlBoxPanel = Ext.extend(Lino.HtmlBoxPanel, Lino.FieldBoxMixin);
Lino.HtmlBoxPanel = Ext.extend(Lino.HtmlBoxPanel, {
  disabled_in_insert_window : true,
  constructor : function(config,params) {
    this.before_init(config,params);
    Lino.HtmlBoxPanel.superclass.constructor.call(this, config);
  },
  //~ constructor : function(ww,config,params){
    //~ this.ww = ww;
    //~ if (params) Ext.apply(config,params);
    //~ var actions = Lino.build_buttons(this,config.ls_bbar_actions);
    //~ if (actions) config.bbar = actions.bbar;
    //~ Lino.FieldBoxMixin.constructor.call(this, ww,config,params);
  //~ },
  //~ constructor : function(ww,config,params){
    //~ this.ww = ww;
    //~ if (params) Ext.apply(config,params);
    //~ var actions = Lino.build_buttons(this,config.ls_bbar_actions);
    //~ if (actions) config.bbar = actions.bbar;
    //~ Lino.FieldBoxMixin.superclass.constructor.call(this, config);
  //~ },
  //~ disable : function() { var tb = this.getBottomToolbar(); if(tb) tb.disable()},
  //~ enable : function() { var tb = this.getBottomToolbar(); if(tb) tb.enable()},
  onRender : function(ct, position){
    Lino.HtmlBoxPanel.superclass.onRender.call(this, ct, position);
    //~ console.log(20111125,this.containing_window);
    if (this.containing_panel) {
      this.containing_panel.on('enable',this.enable,this);
      this.containing_panel.on('disable',this.disable,this);
    }
    this.el.on({
      dragenter:function(event){
        event.browserEvent.dataTransfer.dropEffect = 'move';
        return true;
      }
      ,dragover:function(event){
        event.browserEvent.dataTransfer.dropEffect = 'move';
        event.stopEvent();
        return true;
      }
      ,drop:{
        scope:this
        ,fn:function(event){
          event.stopEvent();
          //~ console.log(20110516);
          var files = event.browserEvent.dataTransfer.files;
          if(files === undefined){
            return true;
          }
          var len = files.length;
          while(--len >= 0){
            console.log(files[len]);
            //~ this.processDragAndDropFileUpload(files[len]);
          }
          Lino.show_insert(this);
        }
      }
    });
  },
  refresh : function(unused) { 
      // this.containing_panel.refresh();
      this.refresh_with_after();
  },
  /* HtmlBoxPanel */
  refresh_with_after : function(after) {
      // var todo = this.containing_panel.refresh();
      var box = this.items.get(0);
      var todo = function() {
        if (this.disabled) { return; }
        this.set_base_params(this.containing_panel.get_master_params());

        var el = box.getEl();
        if (el) {
            var record = this.containing_panel.get_current_record();
            var newcontent = record ? 
                this.format_data(record.data[this.name]) : '';
            // console.log('20140917 HtmlBox.refresh()',
            //             this.name, record.data.LinksByHuman);
            el.update(newcontent, true);
        // } else {
        //     console.log('20140502 cannot HtmlBox.refresh()',this.name);
        }
      };

      Lino.do_when_visible(box, todo.createDelegate(this));
  }
});
//~ Ext.override(Lino.HtmlBoxPanel,Lino.FieldBoxMixin);



Lino.RichTextPanel = Ext.extend(Ext.Panel,Lino.PanelMixin);
Lino.RichTextPanel = Ext.extend(Lino.RichTextPanel,Lino.FieldBoxMixin);
Lino.RichTextPanel = Ext.extend(Lino.RichTextPanel,{
    
  //~ initComponent : function(){
    //~ Lino.RichTextPanel.superclass.initComponent.call(this);
  //~ },
  constructor : function(config,params) {
    //~ console.log('Lino.RichTextPanel.initComponent',this);
    //~ var url = TEMPLATES_URL + config.ls_url + "/" + String(rec.id) + "/" + config.name;
    //~ var url = TEMPLATES_URL + config.ls_url + "/" + config.name;
    var t = this;
    var tinymce_options = {
        theme : "advanced",
        content_css: '/media/lino/extjs/lino.css',
        language: 'en',
        //~ template_external_list_url : url,
        theme_advanced_toolbar_location : "top",
        theme_advanced_toolbar_align : "left",
        theme_advanced_statusbar_location : "bottom",
        template_popup_width : 700,
        template_popup_height : 500,
        template_replace_values : { 
            data_field : function(element){ 
                //~ console.log(20110722,fieldName,t.containing_window.get_current_record()); 
                var fieldName = element.innerHTML;
                element.innerHTML = t.containing_panel.get_current_record().data[fieldName];
            } 
        }
      };
      
    var editorConfig = {
      tinymceSettings: {
        plugins : "noneditable,template", 
        // Theme options - button# indicated the row# only
        theme_advanced_buttons1 : "bold,italic,underline,|,justifyleft,justifycenter,justifyright,|,bullist,numlist,|,outdent,indent,|,undo,redo,|,removeformat,template",
        theme_advanced_buttons2 : "",
        theme_advanced_buttons3 : "", // ,|,sub,sup,|,charmap",      
        theme_advanced_resizing : false
        //~ save_onsavecallback : save_callback,
        //~ save_enablewhendirty : true
        //~ save_oncancelcallback: on_cancel
        
    }};
    Ext.apply(editorConfig.tinymceSettings,tinymce_options);
    //~ editorConfig.name = config.action_name;
    editorConfig.name = config.name;
    delete config.name;
    //~ config.title = config.label;
    //~ delete config.label;
    this.before_init(config,params);
    
    this.editor = new Ext.ux.TinyMCE(editorConfig);
    var t = this;
    config.tools = [{
                      qtip: "Text in eigenem Fenster bearbeiten", 
                      id: "up",
                      handler: function(){
                        if(t.editor.isDirty()) {
                            var record = t.containing_panel.get_current_record();
                            record.data[t.editor.name] = t.editor.getValue();
                        }
                        Lino.edit_tinymce_text(t, tinymce_options)
                      }
                    }];
    
    config.items = this.editor;
    config.layout = "fit";
    Lino.RichTextPanel.superclass.constructor.call(this, config);
  },
  refresh : function(unused) { 
      this.refresh_with_after();
  },
  /* RichTextPanel */
  refresh_with_after : function(after) {
    var record = this.containing_panel.get_current_record();
    // console.log('20140504 RichTextPanel.refresh()',
    //             this.title,record.title, record);
    var todo = function() {
      if (record) {
        var url = '/templates' 
              + this.containing_panel.ls_url + "/" 
              + String(record.id) + "/" + this.editor.name;
        //~ console.log('RichTextPanel.refresh()',url);
        if (this.editor.ed) this.editor.ed.settings.template_external_list_url = url;
        this.set_base_params(this.containing_panel.get_master_params());
        //~ var v = record ? this.format_data(record.data[this.editor.name]) : ''
        var v = this.format_data(record.data[this.editor.name])
        this.editor.setValue(v);
      } else {
        this.editor.setValue('(no data)');
      }
    };
    Lino.do_when_visible(this,todo.createDelegate(this));
  }
});
//~ Ext.override(Lino.RichTextPanel,Lino.FieldBoxMixin);



Lino.ActionFormPanel = Ext.extend(Ext.form.FormPanel,Lino.MainPanel);
Lino.ActionFormPanel = Ext.extend(Lino.ActionFormPanel, Lino.PanelMixin);
Lino.ActionFormPanel = Ext.extend(Lino.ActionFormPanel, Lino.FieldBoxMixin);
Lino.ActionFormPanel = Ext.extend(Lino.ActionFormPanel, {
  //~ layout:'fit'
  //~ ,autoHeight: true
  //~ ,frame: true
  window_title : "Action Parameters",
  constructor : function(config){
    config.bbar = [
        {text: 'OK', handler: this.on_ok, scope: this},
        {text: 'Cancel', handler: this.on_cancel, scope: this}
    ];
    Lino.ActionFormPanel.superclass.constructor.call(this, config);
  }
  //~ ,initComponent : function(){
    //~ Lino.ActionFormPanel.superclass.initComponent.call(this);
  //~ }
  ,on_cancel : function() { 
    this.get_containing_window().close();
  }
  ,on_ok : function() { 
    var panel = this.requesting_panel;
    // var panel = this.get_containing_window().main_item;
    // console.log("20131004 on_ok",this,panel,arguments);
    var actionName = this.action_name;
    var pk = this.record_id;
    if (pk == undefined && this.base_params) { pk = this.base_params.mk; }
    if (pk == undefined && panel) {
        pk = panel.get_current_record().id;
    }
    if (pk == undefined) {
        Lino.alert("Sorry, dialog action without base_params.mk");
        return;
    }
    var self = this;
    // function on_success() { self.get_containing_window().close(); };
    // see 20131004 and 20140430
    var url = '/api';
    if (panel) 
        url += panel.ls_url;
    else 
        url += this.ls_url;
    url += '/' + pk;
    // prepare possible recursive call
    var fn = function(panel, btn, step) {
      var p = {};
      self.add_field_values(p)
      Lino.call_ajax_action(
          panel, 'GET', url, p, actionName, step, fn); //  , on_success);
    }
    fn(panel, null, null);
    
    
  }
  /* ActionFormPanel*/
  ,set_status : function(status, rp){
    this.requesting_panel = Ext.getCmp(rp);
    //~ console.log('20120918 ActionFormPanel.set_status()',status,rp,this.requesting_panel);
    this.clear_base_params();
    if (status == undefined) status = {};
    //~ if (status.param_values) 
    this.set_field_values(status.field_values);
    if (status.base_params) this.set_base_params(status.base_params);
    this.record_id = status.record_id;
  }
  
  ,before_row_edit : function(record) {}
  ,add_field_values : function (p) { // similar to add_param_values()
      //~ 20121023 
      if (this.form.isDirty()) {
        p.fv = this.get_field_values();
      }else{
        if (this.status_field_values) 
          p.fv = Lino.fields2array(this.fields,this.status_field_values);
      }
      //~ if (!this.form.isDirty()) return;
      //~ p.$ext_requests.URL_PARAM_FIELD_VALUES = this.get_field_values();
      //~ console.log("20120203 add_param_values added pv",pv,"to",p);
  }
  ,get_field_values : function() {
      return Lino.fields2array(this.fields);
  }
  ,set_field_values : function(pv) {
      //~ console.log('20120203 MainPanel.set_param_values', pv);
      this.status_field_values = pv;
      if (pv) {
          this.form.my_loadRecord(pv);
          var record = { data: pv };
          this.before_row_edit(record);
      } else {
          this.form.reset(); 
          this.before_row_edit();
      }
  }
  ,config_containing_window : function(wincfg) { 
      wincfg.title = this.window_title;
      wincfg.keys = [
        { key: Ext.EventObject.ENTER, fn: this.on_ok }
      ]
      
      if (!wincfg.defaultButton) this.getForm().items.each(function(f){
          if(f.isFormField){ 
              wincfg.defaultButton = f;
              return false;
          }
      });

  }
});

    
Lino.fields2array = function(fields,values) {
    //~ console.log('20130605 fields2array gonna loop on', fields,values);
    var pv = Array(fields.length);
    for(var i=0; i < fields.length;i++) {
        var f = fields[i]
        if (values) 
          var v = values[f.name];
        else 
          var v = f.getValue();
        if (f.formatDate) {
            pv[i] = f.formatDate(v); 
        } else {
            pv[i] = v; // f.getValue(); 
        }
    }
    return pv;
}


Lino.FormPanel = Ext.extend(Ext.form.FormPanel,Lino.MainPanel);
Lino.FormPanel = Ext.extend(Lino.FormPanel,Lino.PanelMixin);
Lino.FormPanel = Ext.extend(Lino.FormPanel,{
  params_panel_hidden : false,
  save_action_name : null, 
  //~ base_params : {},
  //~ trackResetOnLoad : true,
  //~ query_params : {},
  //~ 20110119b quick_search_text : '',
  constructor : function(config,params){
    if (params) Ext.apply(config,params);
    this.base_params = {};
    //~ ww.config.base_params.query = ''; // 20111018
    //~ console.log(config);
    //~ console.log('FormPanel.constructor() 1',config)
    //~ Ext.applyIf(config,{base_params:{}});
    //~ console.log('FormPanel.constructor() 2',config)
      
    config.trackResetOnLoad = true;
    
    Lino.FormPanel.superclass.constructor.call(this, config);
      
    //~ this.set_base_param('$URL_PARAM_FILTER',null); // 20111018
    //~ this.set_base_param('$URL_PARAM_FILTER',''); // 20111018
      
  },
  initComponent : function(){
    
    this.containing_panel = this;

    //~ console.log("20111201 containing_window",this.containing_window,this);


    var actions = Lino.build_buttons(this,this.ls_bbar_actions);
    if (actions) {
        this.bbar = actions.bbar;
    //~ } else {
        //~ this.bbar = [];
    }
    //~ Ext.apply(config,Lino.build_buttons(this,config.ls_bbar_actions));
    //~ config.bbar = Lino.build_buttons(this,config.ls_bbar_actions);
    //~ var config = this;
    
    //~ if (this.containing_window instanceof Lino.DetailWrapper) {
    
    //~ console.log('20120121 initComponent', this.action_name);
    //~ if (this.action_name == 'detail' | this.action_name == 'show') {
    //~ if (this.action_name != 'insert') {
    if (! this.hide_top_toolbar) {
      this.tbar = [];
      // 20111015    
      if (! this.hide_navigator) {
        this.record_selector = new Lino.RemoteComboFieldElement({
          store: new Lino.ComplexRemoteComboStore({
            //~ baseParams: this.containing_window.config.base_params,
            baseParams: this.get_base_params(),
            //~ value: this.containing_window.config.base_params.query,
            proxy: new Ext.data.HttpProxy({
              url: '/choices' + this.ls_url,
              method:'GET'
            })
          }),
          pageSize:25,
          listeners: { 
            scope:this, 
            select:function(combo,record,index) {
              //~ console.log('jumpto_select',arguments);
              this.goto_record_id(record.id);
            }
          },
          emptyText: "Gehe zu Datensatz"
        })
        this.tbar = this.tbar.concat([this.record_selector]);
        
        this.tbar = this.tbar.concat([
          this.first = new Ext.Toolbar.Button({
              tooltip:"Erster",disabled:true,
              handler:this.moveFirst,scope:this,iconCls:'x-tbar-page-first'}),
          this.prev = new Ext.Toolbar.Button({
              tooltip:"Voriger",disabled:true,
              handler:this.movePrev,scope:this,iconCls:'x-tbar-page-prev'}),
          this.next = new Ext.Toolbar.Button({
              tooltip:"Nächster",disabled:true,
              handler:this.moveNext,scope:this,iconCls:'x-tbar-page-next'}),
          this.last = new Ext.Toolbar.Button({
              tooltip:"Letzter",disabled:true,
              handler:this.moveLast,scope:this,iconCls:'x-tbar-page-last'})
        ]);
      }
      this.tbar = this.add_params_panel(this.tbar);
      
      //~ console.log(20101117,this.containing_window.refresh);
      this.tbar = this.tbar.concat([
        {
          //~ text:'Refresh',
          handler:function(){ this.do_when_clean(false,this.refresh.createDelegate(this)) },
          iconCls: 'x-tbar-loading',
          tooltip:"Datensatz neu laden",
          scope:this}
      ]);
          
      if (this.bbar) { // since 20121016
        if (this.tbar) {
            this.tbar = this.tbar.concat(['-']) ;
        } else {
          this.tbar = [];
        }
        this.tbar = this.tbar.concat(this.bbar) ;
        this.bbar = undefined;
      }
    
      this.tbar = this.tbar.concat([
          '->',
          this.displayItem = new Ext.Toolbar.TextItem({})
      ]);
          
    }
    //~ if (this.content_type && this.action_name != 'insert') {
      //~ this.bbar = this.bbar.concat([
        //~ '->',
        //~ { text: "[$_('Help Text Editor')]",
          //~ handler: Lino.help_text_editor,
          //~ qtip: "$_('Edit help texts for fields on this model.')",
          //~ scope: this}
      //~ ])
    //~ }
    //~ this.before_row_edit = config.before_row_edit.createDelegate(this);
      
    //~ if (this.master_panel) {
        //~ this.set_base_params(this.master_panel.get_master_params());
    //~ }
      
    Lino.FormPanel.superclass.initComponent.call(this);

    // this.on('show',
    //         function(){ this.init_focus();}, 
    //         this);
    
    this.on('render',function(){
      this.loadMask = new Ext.LoadMask(this.bwrap,{msg:"Bitte warten..."});
    },this);
    
    
    if (this.action_name == 'insert') {
      this.cascade(function(cmp){
        // console.log('20110613 cascade',cmp);
        if (cmp.disabled_in_insert_window) {
            //~ cmp.disable();
            cmp.hide();
        }
      });
      
    }
    
  },
  
  unused_init_focus : function(){ 
    // set focus to the first field
    console.log("20140205 Lino.FormPanel.init_focus");
    // Lino.FormPanel.superclass.focus.call(this);
    this.getForm().items.each(function(f){
        if(f.isFormField && f.rendered){ 
            f.focus();
            console.log("20140205 focus", f);
            return false;
        }
    });
  },

  /* FormPanel */
  get_status : function(){
      var st = {
        base_params: this.get_base_params(),
        // data_record : this.get_current_record()
        }
      st.record_id = this.get_current_record().id;
      // 20140917 : get_status must not store the whole data_record
      // because that would prevent the form to actually reload
      // when set_status is called after a child window closed.
      
      var tp = this.items.get(0);
      if (tp instanceof Ext.TabPanel) {
        st.active_tab = tp.getActiveTab();
      }
      st.param_values = this.status_param_values;
      return st;
  },

  /* FormPanel */
  set_status : function(status, rp){
    this.requesting_panel = Ext.getCmp(rp);
    // console.log('20140917 FormPanel.set_status()', status);
    this.clear_base_params();
    if (status == undefined) status = {};
    //~ if (status.param_values) 
    this.set_param_values(status.param_values);
    if (status.base_params) this.set_base_params(status.base_params);
    var tp = this.items.get(0);
    if (tp instanceof Ext.TabPanel) {
      if (status.active_tab) {
        //~ console.log('20111201 active_tab',this.active_tab,this.items.get(0));
        //~ tp.activeTab = status.active_tab;
        tp.setActiveTab(status.active_tab);
        //~ this.main_item.items.get(0).activate(status.active_tab);
      } else {
        if (! status.data_record) {  // 20141206
            tp.setActiveTab(0);
        }
      }
    }
    
    if (status.data_record) {
      /* defer because set_window_title() didn't work otherwise */
      // 20140421 removed defer for bughunting to simplify side effects
      // this.set_current_record.createDelegate(
      //     this, [status.data_record]).defer(100);
      this.set_current_record(status.data_record);
      //~ return;
    } else if (status.record_id != undefined) { 
      /* possible values include 0 and null, 0 being a valid record id, 
      null the equivalent of undefined
      */
      this.load_record_id(status.record_id);
    } else {
      this.set_current_record(undefined);
    }
    // this.init_focus()
  }
  ,get_base_params : function() {  /* FormPanel */
    // needed for insert_action
    var p = Ext.apply({}, this.base_params);
    Lino.insert_subst_user(p);
    return p;
  }
  ,set_base_params : function(p) {
    //~ this.base_params = Ext.apply({},this.base_params); // make sure it is an instance variable
    delete p['query'] // 20120725
    Ext.apply(this.base_params,p);
    if (this.record_selector) {
        var store = this.record_selector.getStore();
        for (k in p) store.setBaseParam(k,p[k]);
        delete this.record_selector.lastQuery;
        //~ console.log("20120725 record_selector.setBaseParam",p)
    }
  }
  ,clear_base_params : function() {
      this.base_params = {};
      Lino.insert_subst_user(this.base_params);
  }
  ,set_base_param : function(k,v) {
    this.base_params[k] = v;
  }
  ,after_delete : function() {
    if (this.current_record.navinfo.next)
      this.moveNext();
    else if (this.current_record.navinfo.prev)
      this.movePrev();
    else 
      this.abandon();
  }
  ,moveFirst : function() {this.goto_record_id(
      this.current_record.navinfo.first)}
  ,movePrev : function() {this.goto_record_id(
      this.current_record.navinfo.prev)}
  ,moveNext : function() {this.goto_record_id(
      this.current_record.navinfo.next)}
  ,moveLast : function() {this.goto_record_id(
      this.current_record.navinfo.last)}
  
  ,refresh : function(unused) { 
      this.refresh_with_after();
  }
  /* FormPanel */
  ,refresh_with_after : function(after) { 
    // console.log('20140917 Lino.FormPanel.refresh_with_after()',this);
    if (this.current_record) {
        this.load_record_id(this.current_record.id, after);
    } else {
        this.set_current_record(undefined, after);
    }
  }
  
  ,do_when_clean : function(auto_save, todo) {
    var this_ = this;
    if (this.form.isDirty()) {
        // console.log('20140421 do_when_clean : form is dirty')
        if (auto_save) {
            this_.save(todo);
        } else {
          //~ console.log('20111217 do_when_clean() form is dirty',this.form);
          var config = {title:"Bestätigung"};
          config.buttons = Ext.MessageBox.YESNOCANCEL;
          config.msg = "Änderungen in diesem Datensatz speichern?";
          config.fn = function(buttonId,text,opt) {
            //~ console.log('do_when_clean',buttonId)
            if (buttonId == "yes") {
                //~ Lino.submit_detail(this_,undefined,todo);
                //~ this_.containing_window.save(todo);
                this_.save(todo);
            } else if (buttonId == "no") { 
              todo();
            }
          }
        }
        Ext.MessageBox.show(config);
    }else{
      // console.log('20140421 do_when_clean : now!')
      todo();
    }
  }
  
  ,goto_record_id : function(record_id) {
    // console.log('20140917 Lino.FormPanel.goto_record_id()',record_id);
    //~ var this_ = this;
    //~ this.do_when_clean(function() { this_.load_record_id(record_id) }
    this.do_when_clean(
        true, this.load_record_id.createDelegate(this, [record_id]));
  }
  
  ,load_record_id : function(record_id, after) {
    var this_ = this;
    var p = Ext.apply({}, this.get_base_params());
    if (this.action_name)
        p.an = this.action_name;
    p.rp = this.getId();
    p.fmt = 'json';
    this.add_param_values(p);
    if (this.loadMask) this.loadMask.show();
    Ext.Ajax.request({ 
      waitMsg: 'Loading record...',
      method: 'GET',
      params: p,
      scope: this,
      url: this.get_record_url(record_id),
      success: function(response) {   
        // todo: convert to Lino.action_handler.... but result 
        if (this.loadMask) this.loadMask.hide();
        if (response.responseText) {
          var rec = Ext.decode(response.responseText);
          // console.log('20140917 load_record_id success', rec);
          this.set_param_values(rec.param_values);
          this.set_current_record(rec, after);
        }
      },
      failure: Lino.ajax_error_handler(this)
    });
  }

  ,abandon : function () {
    Ext.MessageBox.alert('Note',
      "Keine weiteren Datensätze zu sehen. Detail-Fenster wird geschlossen.");
    Lino.close_window();
  }
  
  ,set_current_record : function(record, after) {
    if (this.record_selector) {
        this.record_selector.clearValue();
        // e.g. InsertWrapper FormPanel doesn't have a record_selector
    }
    this.current_record = record;
    if (record) {
      this.enable();
      this.form.my_loadRecord(record.data);
      this.set_window_title(record.title);
      //~ this.getBottomToolbar().enable();
      var da = record.data.disabled_actions;
      if (da) {
          //~ console.log('20120528 disabled_actions =',da,this.getBottomToolbar());
          //~ 20121016 this.getBottomToolbar().items.each(function(item,index,length){
          var tb = this.getTopToolbar();
          if (tb) tb.items.each(function(item,index,length){
              //~ console.log('20120528 ',item.itemId,'-->',da[item.itemId]);
              if (da[item.itemId]) item.disable(); else item.enable();
          });
      };
      if (this.disable_editing | record.data.disable_editing) {
          //~ console.log("20120202 disable_editing",record.title);
          this.form.items.each(function(cmp){
            if (!cmp.always_enabled) cmp.disable();
          },this);
      } else {
          this.form.items.each(function(cmp){
            //~ console.log("20120202",cmp);
            if (record.data.disabled_fields[cmp.name]) cmp.disable();
            else cmp.enable();
          },this);
        
          //~ if (record.data.disabled_fields) {
              //~ for (i = 0; i < record.data.disabled_fields.length; i++) {
                  //~ var flds = this.find('name',record.data.disabled_fields[i]);
                  //~ if (flds.length == 1) { 
                    //~ flds[0].disable(); 
                  //~ }
              //~ }
          //~ }
      };
      if (this.first) {
        if (record.navinfo  && ! this.hide_navigator) {
          this.first.setDisabled(!record.navinfo.first);
          this.prev.setDisabled(!record.navinfo.prev);
          this.next.setDisabled(!record.navinfo.next);
          this.last.setDisabled(!record.navinfo.last);
          this.displayItem.setText(record.navinfo.message);
        } else {
          this.first.setDisabled(true);
          this.prev.setDisabled(true);
          this.next.setDisabled(true);
          this.last.setDisabled(true);
        }
      }
    } else {
      if (this.form.rendered) 
        this.form.reset(); /* FileUploadField would fail when resetting a non-rendered form */
      //~ this.disable();
      //~ this.getBottomToolbar().disable();
      this.form.items.each(function(cmp){
        cmp.disable();
      },this);
      this.set_window_title(this.empty_title);
      //~ this.containing_window.window.setTitle(this.empty_title);
      if (!this.hide_navigator) {
        this.first.disable();
        this.prev.disable();
        this.next.disable();
        this.last.disable();
      }
    }
    // console.log('20140917 gonna call before_row_edit', record);
    this.before_row_edit(record);
    // console.log('20140917 gonna call after', after);
    if (after) after();
  },
  
  /* FormPanel */
  before_row_edit : function(record) {},
  search_change : function(field,oldValue,newValue) {
    //~ console.log('search_change',field.getValue(),oldValue,newValue)
    this.set_base_param('query',field.getValue()); 
    this.refresh();
  },
  
  get_selected : function() { return [ this.current_record ] },
  get_current_record : function() {  
    //~ console.log(20100714,this.current_record);
    return this.current_record 
  },
  
  get_permalink_url : function() {
      var rec = this.get_current_record();
      if (rec && ! rec.phantom && rec.id != -99998)
          return '/api' 
              + this.ls_url + '/' + rec.id;
      return '/api' + this.ls_url;
    
  },
  add_param_tab : function(p) {
    var main = this.items.get(0);
    if (main.activeTab) {
      var tab = main.items.indexOf(main.activeTab);
      //~ console.log('main.activeTab',tab,main.activeTab);
      if (tab) p.tab = tab;
    }
  },
  get_permalink_params : function() {
    var p = {};
    //~ var p = {an:'detail'};
    if (this.action_name)
        p.an = this.action_name;
    this.add_param_tab(p)
    this.add_param_values(p)
    return p;
  }
  
  ,validate_form : function() {  // not used. see actions.ValidateForm
      // var ov = {};
      // this.form.items.each(function(f){
      //     ov[f.name] = f.originalValue
      // });

      // console.log('20140509 FormPanel.validate_form', ov);
      // var after = function() { 
      //     this.form.items.each(function(f){
      //         f.originalValue = ov[f.name];
      //     });
      // }
      // this.save2(null, 'validate', after);
      this.save2(null, 'validate');
  }

  /* Lino.FormPanel */
  ,save : function(after) {
    var action_name = this.save_action_name;
    if (!action_name) 
        action_name = this.action_name;
    // console.log('20140503 FormPanel.save', action_name);
    this.save2(after, action_name);
  }

  ,save2 : function(after, action_name) {
    var rec = this.get_current_record();
    if (!rec) { 
        Lino.notify("Sorry, no current record."); 
        return; 
    }
    var panel = this;
    if (this.has_file_upload) this.form.fileUpload = true;
    //~ console.log('FormPanel.save()',rec);
    this.loadMask.show();
    var p = {};
    Ext.apply(p, this.get_base_params());
    p.rp = this.getId();
    p.an = action_name;
    this.add_param_tab(p)
    var submit_config = {
        params: p, 
        scope: this,
        success: function(form, action) {
          this.loadMask.hide();
          Lino.notify(action.result.message);
          Lino.handle_action_result(this, action.result, after);
        },
        failure: function(form,action) { 
          this.loadMask.hide();
          Lino.on_submit_failure(form, action);
        },
        clientValidation: true
    };
    if (rec.phantom) {  // it's a new record
      Ext.apply(submit_config, {
        url: '/api' + this.ls_url,
        method: 'POST'
      });
    } else {  // submit on existing row
      Ext.apply(submit_config, {
        url: '/api' 
              + this.ls_url + '/' + rec.id,
        method: 'PUT'
      })
    }
    this.form.submit(submit_config);
  }
  
  ,on_cancel : function() { 
    this.get_containing_window().close();
  }
  ,on_ok : function() { 
      // console.log("20140424");
      // this.save(null, true, this.save_action_name);
      this.save();
  }
  ,config_containing_window : function(wincfg) { 

      // Note that defaultButton means: which component should receive
      // focus when Window is focussed.  If no defaultButton set,
      // specify the first form field.

      if (!wincfg.defaultButton) this.getForm().items.each(function(f){
          if(f.isFormField){ 
              wincfg.defaultButton = f;
              // console.log("20140205 defaultButton", f);
              return false;
          }
      });

      wincfg.keys = [
          {
              key: Ext.EventObject.ENTER,
              scope:this,
              fn: function(k, e) {
                  if(e.target.type === 'textarea' && !e.ctrlKey) {
                      return true;
                  }
                  this.on_ok();
              }
          },
          { key: Ext.EventObject.ESCAPE, fn: this.on_cancel, scope:this }
          // ,{ key: 's', ctrl: true, 
          //    stopEvent: true,
          //    fn: this.on_ctrl_s, scope:this }
      ]
  }
  
});



Lino.getRowClass = function(record, rowIndex, rowParams, store) {
    //~ console.log(20130816,record);
    //~ return 'x-grid3-row-green';
    //~ return record.data.row_class + ' auto-height';
    return record.data.row_class;
  //~ if (true) {
      //~ return 'x-grid3-row-red';
  //~ }
  //~ if (record.phantom) {
    //~ console.log(20101009,record);
    //~ rowParams.bodyStyle = "color:red;background-color:blue";
    //~ return 'lino-phantom-row';
    //~ }
  //~ console.log('20101009 not a phantom:',record);
  //~ return '';
}

//~ FOO = 0;



Lino.GridStore = Ext.extend(Ext.data.ArrayStore,{ 
  autoLoad: false
  ,load: function(options) {
    //~ foo.bar = baz; // 20120213
    if (!options) options = {};
    if (!options.params) options.params = {};
    options.params.fmt = 'json';
    options.params.rp = this.grid_panel.getId();
    Lino.insert_subst_user(options.params); // since 20121016
      
    var start = this.grid_panel.start_at_bottom ? -1 : 0;
    if (this.grid_panel.hide_top_toolbar) {
        //~ console.log("20120206 GridStore.load() toolbar is hidden");
        options.params.start = start;
        if (this.grid_panel.preview_limit) {
          options.params.limit = this.grid_panel.preview_limit;
        }
    } else {
        var ps = this.grid_panel.calculatePageSize();
        if (!ps) {
          // console.log("GridStore.load() failed to calculate pagesize");
          return false;
        } 
        options.params.limit = ps;
      
        this.grid_panel.getTopToolbar().pageSize =  ps;
        if (options.params.start == undefined)
            // if (start != -1) 
            //     start = this.grid_panel.getTopToolbar().cursor
            options.params.start = start;
      
        // console.log("20141108 GridStore.load() ", options.params);
    }
      
    this.grid_panel.add_param_values(options.params);
    //~ Lino.insert_subst_user(options.params);
    //~ console.log("20120814 GridStore.load()",options.params,this.baseParams);
    return Lino.GridStore.superclass.load.call(this, options);
  }
  // ,insert : function(index, records) {
  //   return Ext.data.Store.prototype.insert.call(this, index, records)
    // return Lino.GridStore.superclass.insert.call(this, index, records);
  // }
});

Lino.get_current_grid_config = function(panel) {
    return panel.get_current_grid_config();
}


// Like the default value for GridView.cellTpl but adds a class "lino-auto-height"
Lino.auto_height_cell_template = new Ext.Template(
'<td class="x-grid3-col x-grid3-cell x-grid3-td-{id} {css}" style="{style}" tabIndex="0" {cellAttr}>',
    '<div class="lino-auto-height x-grid3-cell-inner x-grid3-col-{id}" unselectable="on" {attr}>{value}</div>',
'</td>'
);

Lino.GridPanel = Ext.extend(Ext.grid.EditorGridPanel, Lino.MainPanel);
Lino.GridPanel = Ext.extend(Lino.GridPanel, Lino.PanelMixin);
Lino.GridPanel = Ext.extend(Lino.GridPanel, {
  quick_search_text : '',
  start_at_bottom : false,
  is_searching : false,
  disabled_in_insert_window : true,
  clicksToEdit:2,
  enableColLock: false,
  autoHeight: false,
  params_panel_hidden : false,
  preview_limit : undefined, 
  //~ loadMask: true,
  //~ viewConfig: {
          //~ getRowClass: Lino.getRowClass,
          //~ emptyText:"$_('No data to display.')"
        //~ },
        
        
  loadMask: {msg:"Bitte warten..."},
  
  constructor : function(config){

    config.plugins = [new Lino.GridFilters()];
    
    
    Lino.GridPanel.superclass.constructor.call(this,config);
    
    //~ if (this.containing_window) {
        //~ console.log("20111206 install refresh");
        //~ this.containing_window.on('show',this.refresh,this);
    //~ }
    
  },
  
  init_containing_window : function(win) { 
    //~ console.log("20111206 install refresh");
    //~ win.on('show',this.refresh,this);
  }

  ,handle_key_event : function(e) { 
    // console.log("20140514 handle_key_event", e, this.keyhandlers);
    var h = this.keyhandlers[e.keyCode];
    if (h) {
      h(this);
      e.stopEvent();
    }
  }
  
  ,initComponent : function(){
    
    /* 
    Problem 20111206:
    When a GridPanel is the main item of the window, then it doesn't 
    have it's own header but uses the window's header bar.
    We must do this in initComponent because e.g. in beforerender 
    it's already to late: a header element has been created because 
    there was a title.
    But Lino.Window adds itself as `this.containing_window` 
    only after the GridPanel has been initialized.
    Workaround is to generate a line "params.containing_window = true;" 
    in the handler function.
    */ 
    if (this.is_main_window) {
        //~ console.log(20111206, 'delete title',this.title,'from',this);
        this.tools = undefined;  
        this.title = undefined;  /* simply deleting it 
          isn't enough because that would only 
          unhide the title defined in some base class. */
    } 
    //~ else console.log(20111206, 'dont delete title',this.title,'from',this);
    
    /* e.g. when slave gridwindow called from a permalink */
    //~ if (this.base_params) Ext.apply(bp,this.base_params);  
    
    var proxy = new Ext.data.HttpProxy({ 
      // 20120814 
      url: '/api' + this.ls_url
      ,method: "GET"
      //~ ,url: ADMIN_URL + '/restful' + this.ls_url
      //~ ,restful: true 
      //~ ,listeners: {load:on_proxy_load} 
      //~ ,listeners: {write:on_proxy_write} 
    });
    //~ config.store = new Ext.data.JsonStore({ 
    //~ this.store = new Ext.data.ArrayStore({ 
    this.store = new Lino.GridStore({ 
      grid_panel: this
      ,listeners: { exception: Lino.on_store_exception }
      ,remoteSort: true
      ,totalProperty: "count"
      ,root: "rows"
      //~ ,id: "id" 
      ,proxy: proxy
      //~ autoLoad: this.containing_window ? true : false
      ,idIndex: this.pk_index
      //~ ,baseParams: bp
      ,fields: this.ls_store_fields
      ,idProperty: this.ls_id_property 
      // 20120814
      //~ ,writer : new Ext.data.JsonWriter({
        //~ writeAllFields: false
        //~ ,listful: true
      //~ })
      //~ ,restful : true
    });
      
    //~ console.log('config.pk_index',config.pk_index,config.store),
    delete this.ls_store_fields;
      
    var this_ = this;
    //~ var grid = this;
    this.store.on('load', function() {
        //~ console.log('20120814 GridStore.on(load)',this_.store);
        this_.set_param_values(this_.store.reader.arrayData.param_values);
        //~ this_.set_status(this_.store.reader.arrayData.status);
        //~ 20120918
        this.getView().getRowClass = Lino.getRowClass;
        
        if (this_.store.reader.arrayData.no_data_text) {
            //~ this.viewConfig.emptyText = this_.store.reader.arrayData.no_data_text;
            this.getView().emptyText = this_.store.reader.arrayData.no_data_text;
            this.getView().refresh();
        }
        if (this_.containing_window)
            this_.set_window_title(this_.store.reader.arrayData.title);
            //~ this_.containing_window.setTitle(this_.store.reader.arrayData.title);
        if (!this.is_searching) { // disabled 20121025: quick_search_field may not lose focus
          this.is_searching = false;
          if (this_.selModel.getSelectedCell){
              if (this_.getStore().getCount()) // there may be no data
                  this_.selModel.select(0,0); 
          } else {
              this_.selModel.selectFirstRow();
              this_.getView().focusEl.focus();
          }
        } 
        //~ else console.log("is_searching -> no focussing");
        //~ var t = this.getTopToolbar();
        //~ var activePage = Math.ceil((t.cursor + t.pageSize) / t.pageSize);
        //~ this.quick_search_field.focus(); // 20121024
      }, this
    );
    var actions = Lino.build_buttons(this, this.ls_bbar_actions);
    //~ Ext.apply(config,Lino.build_buttons(this,config.ls_bbar_actions));
    //~ config.bbar, this.cmenu = Lino.build_buttons(this,config.ls_bbar_actions);
    //~ this.cmenu = new Ext.menu.Menu({items: config.bbar});
    delete this.ls_bbar_actions
    if (actions) {
        this.cmenu = actions.cmenu;
        this.keyhandlers = actions.keyhandlers;
    }
    
    if (!this.hide_top_toolbar) {  
      var tbar = [ 
        this.quick_search_field = new Ext.form.TextField({ 
          //~ fieldLabel: "Search"
          listeners: { 
            scope:this_
            //~ ,change:this_.search_change
            
            ,render: Lino.quicktip_renderer("Schnellsuche","Hier Text eingeben für Schnellsuche.")
            
            //~ ,keypress: this.search_keypress 
            ,blur: function() { this.is_searching = false}
          }
          ,validator:function(value) { return this_.search_validate(value) }
          //~ ,tooltip: "Enter a quick search text, then press TAB"
          //~ value: text
          //~ scope:this, 
          //~ ,enableKeyEvents: true
          //~ listeners: { keypress: this.search_keypress }, 
          //~ id: "seachString" 
      })];
      tbar = this.add_params_panel(tbar);
      var menu = [];
      var set_gc = function(index) {
        return function() {
          //~ console.log('set_gc() 20100812');
          this.getColumnModel().setConfig(
              this.apply_grid_config(index,this.ls_grid_configs,this.ls_columns));
        }
      }
      for (var i = 0; i < this.ls_grid_configs.length;i++) {
        var gc = this.ls_grid_configs[i];
        menu.push({text:gc.label,handler:set_gc(i),scope:this})
      }
      if(menu.length > 1) {
        tbar = tbar.concat([
          { text:"Ansicht",
            menu: menu,
            tooltip:"Andere Ansicht auswählen"
          }
        ]);
      }
      
      if (actions) {
        tbar = tbar.concat(actions.bbar);
          //~ this.bbar = actions.bbar;
      }
      
      this.tbar = new Ext.PagingToolbar({ 
        store: this.store, 
        prependButtons: true, 
        //~ pageSize: this.page_length, 
        pageSize: 1, 
        displayInfo: true, 
        beforePageText: "Seite",
        afterPageText: "von {0}",
        displayMsg: "Zeilen {0} bis {1} von {2}",
        firstText: "Erste Seite",
        lastText: "Letzte Seite",
        prevText: "Vorige Seite",
        nextText: "Nächste Seite",
        items: tbar
      });
    }
      
    if (this.cell_edit) {
      this.selModel = new Ext.grid.CellSelectionModel()
      this.get_selected = function() {
        //~ console.log(this.getSelectionModel().selection);
        if (this.selModel.selection)
            return [ this.selModel.selection.record ];
        return [this.store.getAt(0)];
      };
      this.get_current_record = function() { 
        if (this.getSelectionModel().selection) 
          return this.selModel.selection.record;
        return this.store.getAt(0);
      };
    } else { 
      this.selModel = new Ext.grid.RowSelectionModel() 
      this.get_selected = function() {
        var sels = this.selModel.getSelections();
        if (sels.length == 0) sels = [this.store.getAt(0)];
        return sels
      };
      this.get_current_record = function() { 
        var rec = this.selModel.getSelected();
        if (rec == undefined) rec = this.store.getAt(0);
        return rec
      };
    };
    this.columns  = this.apply_grid_config(this.gc_name,this.ls_grid_configs,this.ls_columns);
    
    Lino.GridPanel.superclass.initComponent.call(this);
    
    this.on('resize', function(){
      //~ console.log("20120213 resize",arguments)
      this.refresh();
      },this);
    this.on('viewready', function(){
      //~ console.log("20120213 resize",arguments);
      this.view_is_ready = true;
      this.refresh(); // removed 20130911
      },this);
    this.on('afteredit', this.on_afteredit); // 20120814
    this.on('beforeedit', this.on_beforeedit);
    this.on('beforeedit',function(e) { this.before_row_edit(e.record)},this);
    if (this.cell_edit) {
        this.on('cellcontextmenu', Lino.cell_context_menu, this);
    } else {
        this.on('rowcontextmenu', Lino.row_context_menu, this);
    }
    //~ this.on('contextmenu', Lino.grid_context_menu, this);
    
    delete this.cell_edit;
    
  },
  
  //~ onResize : function(){
      //~ console.log("20120206 GridPanel.onResize",arguments);
      //~ Lino.GridPanel.superclass.onResize.apply(this, arguments);
      //~ this.refresh();
  //~ },
  
  
  get_status : function(){
    var st = { base_params : this.get_base_params()};
    if (!this.hide_top_toolbar) {
        st.current_page = this.getTopToolbar().current;
    }
    st.param_values = this.status_param_values;
    //~ console.log("20120213 GridPanel.get_status",st);
    return st;
  },
  
  /* 
  Lino.GridPanel.set_status() 
  */
  set_status : function(status, rp){
    this.requesting_panel = Ext.getCmp(rp);
    // console.log("20140527 GridPanel.set_status", status);
    this.clear_base_params();
    if (status == undefined) status = {base_params:{}};
    this.set_param_values(status.param_values);
    if (status.base_params) { 
      this.set_base_params(status.base_params);
    }
    if (status.show_params_panel != undefined) {
        if (this.toggle_params_panel_btn) {
            //~ this.toggle_params_panel_btn.toggle(status.show_params_panel=='true');
            this.toggle_params_panel_btn.toggle(status.show_params_panel);
        }
    }
    if (!this.hide_top_toolbar) {
      //~ console.log("20120213 GridPanel.getTopToolbar().changePage",
          //~ status.current_page || 1);
      this.getTopToolbar().changePage(status.current_page || 1);
    }
    //~ this.fireEvent('resize');
    //~ this.refresh.defer(100,this); 
    //~ this.onResize.defer(100,this); 
    //~ this.refresh(); 
    //~ this.doLayout(); 
    //~ this.onResize(); 
    //~ this.store.load();
  },
  
  refresh : function(unused) { 
    this.refresh_with_after();
  },
  /* GridPanel */
  refresh_with_after : function(after) { 
    // console.log('20140504 Lino.GridPanel.refresh '+ this.store.proxy.url);
    //~ var bp = { fmt:'json' }
    if (! this.view_is_ready) return;
    
    if (this.containing_panel) {
        //~ Ext.apply(p,this.master_panel.get_master_params());
        //~ Ext.apply(options.params,this.containing_panel.get_master_params());
        this.set_base_params(this.containing_panel.get_master_params());
        // 20130911
        if (!this.store.baseParams.mk) {  
            return;
        }
    }
    
    //~ console.log('20130911 Lino.GridPanel.refresh_with_after',this.containing_panel.get_master_params());
    
    var options = {};
    if (after) {
        options.callback = function(r,options,success) {if(success) after()}
    }
      
    //~ if (!this.rendered) {
        //~ console.log("20120206 GridPanel.refresh() must wait until rendered",options);
        //~ this.grid_panel.on('render',this.load.createDelegate(this,options))
        //~ return;
    //~ }
    
    this.store.load(options);
  },
  
  /* pageSize depends on grid height (Trying to remove scrollbar)
  Thanks to 
  - Christophe Badoit on http://www.sencha.com/forum/showthread.php?82647
  - http://www.sencha.com/forum/archive/index.php/t-37231.html
  */
  calculatePageSize : function(second_attempt) {
    //~ if (!this.rendered) { 
    if (!this.view_is_ready) { 
      //~ console.log('Cannot calculatePageSize() : not rendered');
      return false; }
    //~ if (!this.isVisible()) { 
      //~ console.log('calculatePageSize : not visible');
      //~ return false; }
      
    //~ console.log('getFrameHeight() is',this.getFrameHeight());
    //~ console.log('getView().scroller.getHeight() is',this.getView().scroller.getHeight());
    //~ console.log('mainBody.getHeight() is',this.getView().mainBody.getHeight());
    //~ console.log('getInnerHeight() is',this.getInnerHeight());
    //~ console.log('getHeight() is',this.getHeight());
    //~ console.log('el.getHeight() is',this.getEl().getHeight());
    //~ console.log('getGridEl().getHeight() is',this.getGridEl().getHeight());
    //~ console.log('getOuterSize().height is',this.getOuterSize().height);
    //~ console.log('getBox().height is',this.getBox().height);
    //~ console.log('getResizeEl.getHeight() is',this.getResizeEl().getHeight());
    //~ console.log('getLayoutTarget().getHeight() is',this.getLayoutTarget().getHeight());
      
    //~ var rowHeight = 52; // experimental value
    var row = this.view.getRow(0);
    if (row) {
      //~ console.log('20120213 yes');
      var rowHeight = Ext.get(row).getHeight();
    } else {
        //~ var rowHeight = this.getFrameHeight();
        //~ var rowHeight = 10; // reasonably smallest approximative value
        //~ There is no data yet. Construct a fake row and get its height
        var Element = Ext.Element;
        var gv = this.view;
        var fakeBody = new Element(Element.fly(gv.scroller).child('div.x-grid3-body'));
        var rowTemplate = gv.templates.row;
        var cellTemplate = gv.templates.cell;
        var tstyle  = 'width:' + gv.getGridInnerWidth() + 'px;';
        var cells = cellTemplate.apply({value:'&#160;'});
        var markup = rowTemplate.apply({
                tstyle: tstyle,
                cols  : 1,
                cells : cells,
                alt   : ''
            });        
        fakeBody.dom.innerHTML = gv.templates.body.apply({rows: markup});
        var row = fakeBody.dom.childNodes[0];
        var rowHeight = Ext.get(row).getHeight();
    }
    //~ console.log('rowHeight is ',rowHeight,this,caller);
    //~ this.getView().syncScroll();
    //~ this.getView().initTemplates();
    var height = this.getView().scroller.getHeight();
    //~ console.log('getView().scroller.getHeight() is',this.getView().scroller.getHeight());
    //~ console.log('getInnerHeight() - getFrameHeight() is',
      //~ this.getInnerHeight(), '-',
      //~ this.getFrameHeight(), '=',
      //~ this.getInnerHeight() - this.getFrameHeight());
    //~ var height = this.getView().mainBody.getHeight();
    //~ var height = this.getView().mainWrap.getHeight();
    //~ var height = this.getView().resizeMarker.getHeight();
    //~ this.syncSize();
    //~ var height = this.getInnerHeight() - this.getFrameHeight();
    //~ var height = this.getHeight() - this.getFrameHeight();
    height -= Ext.getScrollBarWidth(); // leave room for a possible horizontal scrollbar... 
    //~ height -= this.getView().scrollOffset;
    var ps = Math.floor(height / rowHeight);
    //~ console.log('20130816 calculatePageSize():',height,'/',rowHeight,'->',ps);
    ps -= 1; // leave room for a possible phantom row
    //~ return (ps > 1 ? ps : false);
    if (ps > 1) return ps;
    //~ console.log('calculatePageSize() found less than 1 row:',height,'/',rowHeight,'->',ps);
    //~ foo.bar = baz; // 20120213
    return 5; // preview_limit
    //~ if (second_attempt) {
        //~ console.log('calculatePageSize() abandons after second attempt:',
          //~ height,'/',rowHeight,'->',ps);
      //~ return 5;
    //~ }
    //~ return this.calculatePageSize.defer(500,this,[true]);
  },
  
  onCellDblClick : function(grid, row, col){
      //~ console.log("20120307 onCellDblClick",this,grid, row, col);
      if (this.ls_detail_handler) {
          //~ Lino.notify('show detail');
          Lino.show_detail(this);
          return false;
      }else{
        //~ console.log('startEditing');
        this.startEditing(row,col);
      }
  }
  ,get_base_params : function() {  /* Lino.GridPanel */
    var p = Ext.apply({}, this.store.baseParams);
    Lino.insert_subst_user(p);
    return p;
  },
  set_base_params : function(p) {
    //~ console.log('20130911 GridPanel.set_base_params',p)
    for (k in p) this.store.setBaseParam(k,p[k]);
    //~ this.store.baseParams = p;
    if (this.quick_search_field)
      this.quick_search_field.setValue(p.query || "");
    //~ if (p.param_values) 
        //~ this.set_param_values(p.param_values);  
  },
  clear_base_params : function() {
      this.store.baseParams = {};
      Lino.insert_subst_user(this.store.baseParams);
  },
  set_base_param : function(k,v) {
    this.store.setBaseParam(k,v);
  },
  
  //~ get_permalink_params : function() {
    //~ var p = {};
    //~ return p;
  //~ },
  
  before_row_edit : function(record) {},
    
  //~ search_keypress : function(){
    //~ console.log("2012124 search_keypress",arguments);
  //~ },
  search_validate : function(value) {
    if (value == this.quick_search_text) return true;
    this.is_searching = true;
    //~ console.log('search_validate',value)
    this.quick_search_text = value;
    this.set_base_param('query',value); 
    //~ this.getTopToolbar().changePage(1);
    this.getTopToolbar().moveFirst();
    //~ this.refresh();
    return true;
  },
  
  search_change : function(field,oldValue,newValue) {
    //~ console.log('search_change',field.getValue(),oldValue,newValue)
    this.set_base_param('query',field.getValue()); 
    this.getTopToolbar().moveFirst();
    //~ this.refresh();
  },
  
  apply_grid_config : function(index,grid_configs,rpt_columns) {
    //~ var rpt_columns = this.ls_columns;
    var gc = grid_configs[index];    
    //~ console.log('apply_grid_config() 20100812',name,gc);
    this.gc_name = index;
    if (gc == undefined) {
      return rpt_columns;
      //~ config.columns = config.ls_columns;
      //~ return;
    } 
    //~ delete config.ls_filters
    
    //~ console.log(20100805,config.ls_columns);
    var columns = Array(gc.columns.length);
    for (var j = 0; j < rpt_columns.length;j++) {
      var col = rpt_columns[j];
      for (var i = 0; i < gc.columns.length; i++) {
        if (col.dataIndex == gc.ci[i]) {
          col.width = gc.cw[i];
          col.hidden = gc.ch[i];
          columns[i] = col;
          break;
        }
      }
    }
    
    //~ var columns = Array(rpt_columns.length);
    //~ for (var i = 0; i < rpt_columns.length; i++) {
      //~ columns[i] = rpt_columns[gc.columns[i]];
      //~ columns[i].width = gc.widths[i];
    //~ }
    
    //~ if (gc.hidden_cols) {
      //~ for (var i = 0; i < gc.hidden_cols.length; i++) {
        //~ var hc = gc.hidden_cols[i];
        //~ for (var j = 0; j < columns.length;j++) {
          //~ var col = columns[j];
          //~ if (col.dataIndex == hc) {
            //~ col.hidden = true;
            //~ break
          //~ }
        //~ }
      //~ }
    //~ }
    if (gc.filters) {
      //~ console.log(20100811,'config.ls_filters',config.ls_filters);
      //~ console.log(20100811,'config.ls_grid_config.filters',config.ls_grid_config.filters);
      for (var i = 0; i < gc.filters.length; i++) {
        var fv = gc.filters[i];
        for (var j = 0; j < columns.length;j++) {
          var col = columns[j];
          if (col.dataIndex == fv.field) {
            //~ console.log(20100811, f,' == ',fv);
            if (fv.type == 'string') {
              col.filter.value = fv.value;
              //~ if (fv.comparison !== undefined) f.comparison = fv.comparison;
            } else {
              //~ console.log(20100811, fv);
              col.filter.value = {};
              col.filter.value[fv.comparison] = fv.value;
            }
            break;
          }
        };
      }
    }
    
    return columns;
    //~ config.columns = cols;
    //~ delete config.ls_columns
  },
  
  get_current_grid_config : function () {
    var cm = this.getColumnModel();
    var widths = Array(cm.config.length);
    var hiddens = Array(cm.config.length);
    //~ var hiddens = Array(cm.config.length);
    var columns = Array(cm.config.length);
    //~ var columns = Array(cm.config.length);
    //~ var hidden_cols = [];
    //~ var filters = this.filters.getFilterValues();
    var p = this.filters.buildQuery(this.filters.getFilterData())
    for (var i = 0; i < cm.config.length; i++) {
      var col = cm.config[i];
      columns[i] = col.dataIndex;
      //~ hiddens[i] = col.hidden;
      widths[i] = col.width;
      hiddens[i] = col.hidden;
      //~ if (col.hidden) hidden_cols.push(col.dataIndex);
    }
    //~ p['hidden_cols'] = hidden_cols;
    p.cw = widths;
    p.ch = hiddens;
    p.ci = columns;
    //~ p['widths'] = widths;
    //~ p['hiddens'] = hiddens;
    //~ p['columns'] = columns;
    p['name'] = this.gc_name;
    //~ var gc = this.ls_grid_configs[this.gc_name];
    //~ if (gc !== undefined) 
        //~ p['label'] = gc.label
    //~ console.log('20100810 save_grid_config',p);
    return p;
  },
  
  unused_manage_grid_configs : function() {
    var data = [];
    for (k in this.ls_grid_configs) {
      var v = this.ls_grid_configs[k];
      var i = [k,String(v.columns),String(v.hidden_cols),String(v.filters)];
      data.push(i)
    }
    if (this.ls_grid_configs[this.gc_name] == undefined) {
      var v = this.get_current_grid_config();
      var i = [k,String(v.columns),String(v.hidden_cols),String(v.filters)];
      data.push(i);
    }
    //~ console.log(20100811, data);
    var main = new Ext.grid.GridPanel({
      store: new Ext.data.ArrayStore({
        idIndex:0,
        fields:['name','columns','hidden_cols','filters'],
        autoDestroy:true,
        data: data}),
      //~ autoHeight:true,
      selModel: new Ext.grid.RowSelectionModel(),
      listeners: { 
        rowdblclick: function(grid,rowIndex,e) {
          console.log('row doubleclicked',grid, rowIndex,e);
        },
        rowclick: function(grid,rowIndex,e) {
          console.log('row clicked',grid, rowIndex,e);
        }
      },
      columns: [ 
        {dataIndex:'name',header:'Name'}, 
        {dataIndex:'columns',header:'columns'}, 
        {dataIndex:'hidden_cols',header:'hidden columns'}, 
        {dataIndex:'filters',header:'filters'} 
      ]
    });
    var win = new Ext.Window({title:'GridConfigs Manager',layout:'fit',items:main,height:200});
    win.show();
  },
  
  unused_edit_grid_config : function(name) {
    gc = this.ls_grid_configs[name];
    var win = new Ext.Window({
      title:'Edit Grid Config',layout:'vbox', 
      //~ layoutConfig:'stretch'
      items:[
        {xtype:'text', value: gc.name},
        {xtype:'text', value: gc.columns},
        {xtype:'text', value: gc.hidden_cols},
        {xtype:'text', value: gc.filters}
      ]
    });
    win.show();
  },
  
  unused_save_grid_config : function () {
    //~ console.log('TODO: save_grid_config',this);
    //~ p.column_widths = Ext.pluck(this.colModel.columns,'width');
    var a = { 
      params:this.get_current_grid_config(), 
      method:'PUT',
      url:'/grid_config' + this.ls_url,
      success: Lino.action_handler(this),
      scope: this,
      failure: Lino.ajax_error_handler(this)
    };
    this.loadMask.show(); // 20120211
    Ext.Ajax.request(a);
    //~ Lino.do_action(this,a);
  },
  
  on_beforeedit : function(e) {
    //~ console.log('20130128 GridPanel.on_beforeedit()',e,e.record.data.disable_editing);
    if(this.disable_editing | e.record.data.disable_editing) {
      e.cancel = true;
      Lino.notify("Dieser Datensatz ist deaktiviert");
      return;
    }
    if(e.record.data.disabled_fields && e.record.data.disabled_fields[e.field]) {
      e.cancel = true;
      Lino.notify("Dieses Feld ist deaktiviert");
      return;
    }
    //~ if (e.record.data.disabled_fields) {
      //~ for (i in e.record.data.disabled_fields) {
        //~ if(e.record.data.disabled_fields[i] == e.field) {
          //~ e.cancel = true;
          //~ Lino.notify(String.format('Field "{0}" is disabled for this record',e.field));
          //~ return
        //~ }
      //~ }
    //~ }
  },
  save_grid_data : function() {
      //~ console.log("20120814 save_grid_data");
      this.getStore().commitChanges();
  },
  on_afteredit : function(e) {
    /*
    e.grid - The grid that fired the event
    e.record - The record being edited
    e.field - The field name being edited
    e.value - The value being set
    e.originalValue - The original value for the field, before the edit.
    e.row - The grid row index
    e.column - The grid column index
    */
    var p = {};
    // console.log('20140403 afteredit: ',e.record);
    //~ console.log('20101130 value: ',e.value);
    //~ var p = e.record.getChanges();
    //~ console.log('20101130 getChanges: ',e.record.getChanges());
    //~ this.before_row_edit(e.record);

    for(k in e.record.getChanges()) {
        var v = e.record.get(k);
    //~ for(k in e.record.modified) {
        //~ console.log('20101130',k,'=',v);
        //~ var cm = e.grid.getColumnModel();
        //~ var di = cm.getDataIndex(k);
        var f = e.record.fields.get(k);
        //~ console.log('20101130 f = ',f);
        //~ var v = e.record.get(di);
        if (f.type.type == 'date') {
            p[k] = Ext.util.Format.date(v, f.dateFormat);
        }else{
            p[k] = v;
            var v = e.record.get(k+'Hidden');
            if (v !== undefined) {
              p[k+'Hidden'] = v;
            }
        }
    }
    // add value used by ForeignKeyStoreField CHOICES_HIDDEN_SUFFIX
    // not sure whether this is still needed:
    p[e.field+'Hidden'] = e.value;
    //~ p.su = Lino.subst_user;
    Lino.insert_subst_user(p);
    // this one is needed so that this field can serve as choice context:
    e.record.data[e.field+'Hidden'] = e.value;
    // p[pk] = e.record.data[pk];
    // console.log("grid_afteredit:",e.field,'=',e.value);
    Ext.apply(p, this.get_base_params()); // needed for POST, ignored for PUT
    //~ Ext.apply(p,this.containing_window.config.base_params);
    //~ 20121109 p['$ext_requests.URL_PARAM_ACTION_NAME'] = 'grid';
    var self = this;
    var req = {
        params:p,
        waitMsg: 'Saving your data...',
        success: Lino.action_handler( this, function(result) {
          // console.log("20140728 afteredit.success got ", result);
          //~ if (result.data_record) {
          if (result.refresh_all) {
              var cw = self.get_containing_window();
              if (cw) {
                  cw.main_item.refresh();
              }
              else console.log("20120123 cannot refresh_all",self);
          } else if (result.rows) {
              //~ self.getStore().loadData(result,true);
              var r = self.getStore().reader.readRecords(result);
              if (e.record.phantom) {
                  // console.log("20140728 gonna call Store.insert()", self.getStore(), e.row, r.records);
                  self.getStore().insert(e.row, r.records);
              }else{
                  // console.log("20140728 afteredit.success doUpdate", r.records[0]);
                  self.getStore().doUpdate(r.records[0]);
              }
              self.getStore().rejectChanges(); 
              /* 
              get rid of the red triangles without saving the record again
              */
              //~ self.getStore().commitChanges(); // get rid of the red triangles
          } else {
              self.getStore().commitChanges(); // get rid of the red triangles
              self.getStore().reload();        // reload our datastore.
          }
          }),
        scope: this,
        failure: Lino.ajax_error_handler(this)
    };
    if (e.record.phantom) {
      req.params.an = 'grid_post'; // CreateRow.action_name
      Ext.apply(req,{
        method: 'POST',
        url: '/api' + this.ls_url
      });
    } else {
      req.params.an = 'grid_put'; // SaveRow.action_name
      Ext.apply(req,{
        method: 'PUT',
        url: '/api' + this.ls_url + '/' + e.record.id
      });
    }
    //~ console.log('20110406 on_afteredit',req);
    this.loadMask.show(); // 20120211
    Ext.Ajax.request(req);
  },

  afterRender : function() {
    Lino.GridPanel.superclass.afterRender.call(this);
    // this.getView().mainBody.focus();
    // console.log(20100114,this.getView().getRows());
    // if (this.getView().getRows().length > 0) {
    //  this.getView().focusRow(1);
    // }
    //~ this.my_load_mask = new Ext.LoadMask(this.getEl(), {
        //~ msg:'$_("Please wait...")',
        //~ store:this.store});
      
    var tbar = this.getTopToolbar();
    // tbar.on('change',function() {this.getView().focusRow(1);},this);
    // tbar.on('change',function() {this.getSelectionModel().selectFirstRow();this.getView().mainBody.focus();},this);
    // tbar.on('change',function() {this.getView().mainBody.focus();},this);
    // tbar.on('change',function() {this.getView().focusRow(1);},this);
    this.nav = new Ext.KeyNav(this.getEl(),{
      pageUp: function() {tbar.movePrevious(); },
      pageDown: function() {tbar.moveNext(); },
      home: function() {tbar.moveFirst(); },
      end: function() {tbar.moveLast(); },
      scope: this
    });

  },
  after_delete : function() {
    //~ console.log('Lino.GridPanel.after_delete');
    this.refresh();
  },
  add_row_listener : function(fn,scope) {
    this.getSelectionModel().addListener('rowselect',fn,scope);
  },
  postEditValue : function(value, originalValue, r, field){
    value = Lino.GridPanel.superclass.postEditValue.call(this,value,originalValue,r,field);
    //~ console.log('GridPanel.postEdit()',value, originalValue, r, field);
    return value;
  },
  
  set_start_value : function(v) {
      this.start_value = v;
  },
  preEditValue : function(r, field){
      if (this.start_value) {
        var v = this.start_value;
        delete this.start_value;
        this.activeEditor.selectOnFocus = false;
        return v;
      }
      var value = r.data[field];
      return this.autoEncode && Ext.isString(value) ? Ext.util.Format.htmlDecode(value) : value;
  },
  
  on_master_changed : function() {
    //~ if (! this.enabled) return;
    //~ cmp = this;
    //~ console.log('20130911 Lino.GridPanel.on_master_changed()',this.title,this.rendered);
    if (! this.rendered) return; // 20120213
    var todo = function() {
      if (this.disabled) return;
      //~ if (this.disabled) return;
      //~ if (this.enabled) {
          //~ var src = caller.config.url_data + "/" + record.id + ".jpg"
          //~ console.log(20111125, this.containing_window);
          //~ for (k in p) this.getStore().setBaseParam(k,p[k]);
          //~ console.log('Lino.GridPanel.on_master_changed()',this.title,p);
          this.refresh();
          //~ this.set_base_params(this.master_panel.get_master_params());
          //~ this.getStore().load(); 
      //~ }
    };
    Lino.do_when_visible(this,todo.createDelegate(this));
  },
  load_record_id : function(record_id,after) {
      Lino.run_detail_handler(this,record_id)
  }
  
});
  

//~ Lino.MainPanelMixin = {
  //~ tbar_items : function() {
      //~ return ;
  //~ }
//~ };

//~ Ext.override(Lino.GridPanel,Lino.MainPanelMixin);
//~ Ext.override(Lino.FormPanel,Lino.MainPanelMixin);

//~ Lino.grid_context_menu = function(e) {
  //~ console.log('contextmenu',arguments);
//~ }

Lino.row_context_menu = function(grid,row,col,e) {
  console.log('20130927 rowcontextmenu',grid,row,col,e,grid.store.reader.arrayData.rows[row]);
}

Lino.cell_context_menu = function(grid,row,col,e) {
  //~ console.log('20120531 cellcontextmenu',grid,row,col,e,grid.store.reader.arrayData.rows[row]);
  e.stopEvent();
  //~ grid.getView().focusCell(row,col);
  grid.getSelectionModel().select(row,col);
  //~ console.log(grid.store.getAt(row));
  //~ grid.getView().focusRow(row);
  //~ return;
  if(!grid.cmenu.el){grid.cmenu.render(); }
  //~ if(e.record.data.disabled_fields) {
  
  var da = grid.store.reader.arrayData.rows[row][grid.disabled_actions_index];
  if (da) {
      this.cmenu.cascade(function(item){ 
        //~ console.log(20120531, item.itemId, da[item.itemId]);
        if (da[item.itemId]) item.disable(); else item.enable();
      });
  };
  
  var xy = e.getXY();
  xy[1] -= grid.cmenu.el.getHeight();
  grid.cmenu.showAt(xy);
}


Lino.chooser_handler = function(combo,name) {
  return function(cmp,newValue,oldValue) {
    //~ console.log('Lino.chooser_handler()',cmp,oldValue,newValue);
    combo.setContextValue(name,newValue);
  }
};



Lino.ComboBox = Ext.extend(Ext.form.ComboBox,{
  forceSelection: "yes but select on tab",
  // forceSelection: true,
  triggerAction: 'all',
  minListWidth:280, // 20131022
  autoSelect: false,
  selectOnFocus: true, // select any existing text in the field immediately on focus.
  submitValue: true,
  displayField: 'text', // 'text', 
  valueField: 'value', // 'value',
  
  //~ initComponent : Ext.form.ComboBox.prototype.initComponent.createSequence(function() {
  initComponent : function(){
      this.contextParams = {};
      //~ Ext.form.ComboBox.initComponent(this);
      Lino.ComboBox.superclass.initComponent.call(this);
  },
  setValue : function(v,record_data){
      /*
      Based on feature request developed in http://extjs.net/forum/showthread.php?t=75751
      */
      /* `record_data` is used to get the text corresponding to this value */
      //~ if(this.name == 'city') 
      //~ console.log('20120203', this.name,'.setValue(', v ,') this=', this,'record_data=',record_data);
      var text = v;
      if(this.valueField){
        if(v == null || v == '') { 
            //~ if (this.name == 'birth_country') 
                //~ console.log(this.name,'.setValue',v,'no lookup needed, value is empty');
            //~ v = undefined;
            v = '';
            //~ text = '';
        } else if (Ext.isDefined(record_data)) {
          text = record_data[this.name];
          //~ if (this.name == 'birth_country') 
            //~ console.log(this.name,'.setValue',v,'got text ',text,' from record ',record);
        } else {
          // if(this.mode == 'remote' && !Ext.isDefined(this.store.totalLength)){
          if(this.mode == 'remote' && ( this.lastQuery === null || (!Ext.isDefined(this.store.totalLength)))){
              //~ if (this.name == 'birth_country') console.log(this.name,'.setValue',v,'store not yet loaded');
              this.store.on('load', this.setValue.createDelegate(this, arguments), null, {single: true});
              if(this.store.lastOptions === null || this.lastQuery === null){
                  var params;
                  if(this.valueParam){
                      params = {};
                      params[this.valueParam] = v;
                  }else{
                      var q = this.allQuery;
                      this.lastQuery = q;
                      this.store.setBaseParam(this.queryParam, q);
                      params = this.getParams(q);
                  }
                  //~ if (this.name == 'birth_country') 
                    //~ console.log(this.name,'.setValue',v,' : call load() with params ',params);
                  this.store.load({params: params});
              //~ }else{
                  //~ if (this.name == 'birth_country') 
                    //~ console.log(this.name,'.setValue',v,' : but store is loading',this.store.lastOptions);
              }
              return;
          //~ }else{
              //~ if (this.name == 'birth_country') 
                //~ console.log(this.name,'.setValue',v,' : store is loaded, lastQuery is "',this.lastQuery,'"');
          }
          var r = this.findRecord(this.valueField, v);
          if(r){
              text = r.data[this.displayField];
          }else if(this.valueNotFoundText !== undefined){
              text = this.valueNotFoundText;
          }
        }
      }
      this.lastSelectionText = text;
      //~ this.lastSelectionText = v;
      if(this.hiddenField){
          //~ this.hiddenField.originalValue = v;
          this.hiddenField.value = v;
      }
      Ext.form.ComboBox.superclass.setValue.call(this, text);
      this.value = v; // needed for grid.afteredit
  },
  
  getParams : function(q){
    // p = Ext.form.ComboBox.superclass.getParams.call(this, q);
    // causes "Ext.form.ComboBox.superclass.getParams is undefined"
    var p = {};
    if(this.pageSize){
        p['start'] = 0;
        p['limit'] = this.pageSize;
    }
    // now my code:
    if(this.contextParams) Ext.apply(p, this.contextParams);
    return p;
  },
  setContextValue : function(name,value) {
    //~ console.log('setContextValue',this,this.name,':',name,'=',value);
    //~ if (this.contextValues === undefined) {
        //~ this.contextValues = Array(); // this.contextParams.length);
    //~ }
    if (this.contextParams[name] != value) {
      //~ console.log('setContextValue 1',this.contextParams);
      this.contextParams[name] = value;
      this.lastQuery = null;
      //~ console.log('setContextValue 2',this.contextParams);
    }
  }
});

Lino.ChoicesFieldElement = Ext.extend(Lino.ComboBox,{
  mode: 'local'
});


Lino.SimpleRemoteComboStore = Ext.extend(Ext.data.JsonStore,{
  // forceSelection: true,  20140206 why was this here?
  constructor: function(config){
      Lino.SimpleRemoteComboStore.superclass.constructor.call(this, Ext.apply(config, {
          totalProperty: 'count',
          root: 'rows',
          id: 'value', // ext_requests.CHOICES_VALUE_FIELD
          fields: ['value' ], // ext_requests.CHOICES_VALUE_FIELD, // ext_requests.CHOICES_TEXT_FIELD
          listeners: { exception: Lino.on_store_exception }
      }));
  }
});

Lino.ComplexRemoteComboStore = Ext.extend(Ext.data.JsonStore,{
  constructor: function(config){
      Lino.ComplexRemoteComboStore.superclass.constructor.call(this, Ext.apply(config, {
          totalProperty: 'count',
          root: 'rows',
          id: 'value', // ext_requests.CHOICES_VALUE_FIELD
          fields: ['value','text'], // ext_requests.CHOICES_VALUE_FIELD, // ext_requests.CHOICES_TEXT_FIELD
          listeners: { exception: Lino.on_store_exception }
      }));
  }
});

Lino.RemoteComboFieldElement = Ext.extend(Lino.ComboBox,{
  mode: 'remote',
  //~ forceSelection:false,
  minChars: 2, // default 4 is too much
  queryDelay: 300, // default 500 is maybe slow
  queryParam: 'query', 
  //~ typeAhead: true,
  //~ selectOnFocus: true, // select any existing text in the field immediately on focus.
  resizable: true
  ,initList : function() {
      Lino.RemoteComboFieldElement.superclass.initList.call(this);
      if (this.pageTb) {
          
          var me = this;
          this.pageTb.on("beforechange", function(toolbar, o){
              if(me.contextParams)
                  Ext.apply(o, me.contextParams);
          });
          
          //~ 
          //~ var btn = ls_buttons
          //~ this.pageTb.items = this.pageTb.items.concat([btn]);
          //~ console.log("20131022 pageTb.items is", this.pageTb.items)
      }
  }
});

/*
Thanks to Animal for posting the basic idea:
http://www.sencha.com/forum/showthread.php?15842-2.0-SOLVED-Combobox-twintrigger-clear&p=76130&viewfull=1#post76130

*/
Lino.TwinCombo = Ext.extend(Lino.RemoteComboFieldElement,{
    trigger2Class : 'x-form-search-trigger',
    //~ trigger2Class : 'x-tbar-detail',
    initComponent : function() {
        //~ Lino.TwinCombo.superclass.initComponent.call(this);
        Lino.ComboBox.prototype.initComponent.call(this);
        Ext.form.TwinTriggerField.prototype.initComponent.call(this);
    },
    onTrigger2Click : function() {
        //~ console.log('onTrigger2Click',this,arguments);
    }
  });
//~ Lino.TwinCombo.prototype.initComponent = Ext.form.TwinTriggerField.prototype.initComponent;
Lino.TwinCombo.prototype.getTrigger = Ext.form.TwinTriggerField.prototype.getTrigger;
Lino.TwinCombo.prototype.getOuterSize = Ext.form.TwinTriggerField.prototype.getOuterSize;
Lino.TwinCombo.prototype.initTrigger = Ext.form.TwinTriggerField.prototype.initTrigger;
Lino.TwinCombo.prototype.onTrigger1Click = Ext.form.ComboBox.prototype.onTriggerClick;
//~ Lino.TwinCombo.prototype.onTrigger2Click = function() {
    //~ console.log('onTrigger2Click',arguments);
//~ };



Lino.SimpleRemoteComboFieldElement = Ext.extend(Lino.RemoteComboFieldElement,{
  displayField: 'value', 
  valueField: null,
  forceSelection: false
});




Lino.Window = Ext.extend(Ext.Window,{
  //~ layout: "fit", 
  closeAction : 'hide',
  renderTo: 'main_area', 
  constrain: true,
  maximized: true,
  draggable: false,
  width: 700,
  height: 500,
  maximizable: false,
  constructor : function (config) {
    if (config.main_item.params_panel) {
        config.layout = 'border';
        config.main_item.region = 'center';
        config.main_item.params_panel.region = 'north';
        //~ config.main_item.params_panel.autoHeight = false; // 20130924
        config.main_item.params_panel.hidden = config.main_item.params_panel_hidden;
        config.items = [config.main_item.params_panel, config.main_item];
        //~ 20130923b
    } else {
        config.layout = 'fit';
        config.items = config.main_item;
    }
    this.main_item = config.main_item; 
    
    delete config.main_item;
    //~ delete config.params_item;
    
    //~ this.main_item = config.items.get(0);
    this.main_item.containing_window = this;
    
    //~ console.log('20120110 Lino.Window.constructor() 1');
    //~ if (Lino.current_window) { // all windows except the top are closable
    if (this.main_item.hide_window_title) { 
      config.closable = false;
      config.frame = false;
      config.shadow = false;
      //~ config.border = true;
      //~ config.title = undefined;
      //~ config.tools = null;
      delete config.title;
      delete config.tools;
    } else {
      config.title = this.main_item.empty_title;
      config.closable = true;
      config.tools = [ 
        { qtip: 'permalink', handler: Lino.permalink_handler(this), id: "pin" }
      ];
      if (this.main_item.content_type && this.main_item.action_name != 'insert') {
        config.tools = [ {
          handler: Lino.help_text_editor,
          qtip: "Hilfetexte der Eingabefelder dieser Tabelle bearbeiten",
          scope: this.main_item,
          id: "gear"
        }].concat(config.tools);
      }
        
    //~ { qtip: '', handler: Lino.save_wc_handler(this), id: "save" }, 
    //~ { qtip: this.config.qtip, handler: Lino.save_wc_handler(this), id: "save" }, 
    //~ { qtip: 'Call doLayout() on main Container.', handler: Lino.refresh_handler(this), id: "refresh" },
    //~ if (this.main_item.params_panel) {
        //~ config.tools = config.tools.concat([ 
          //~ { qtip: 'Show/hide parameter panel', handler: this.toggle_params_panel, id: "gear", scope:this } 
        //~ ]);
    //~ }
    //~ if (config.closable !== false) {
      // if undefined, will take default behaviour
      //~ config.tools = config.tools.concat([ 
        //~ { qtip: 'close', handler: this.hide, id: "close", scope:this } 
      //~ ]);
    }
    
    this.main_item.config_containing_window(config);
    
    //~ console.log('20120110 Lino.Window.constructor() 2');
    Lino.Window.superclass.constructor.call(this,config);
    
    //~ console.log('20120110 Lino.Window.constructor() 3');
    
  },
  initComponent : function() {
    this.main_item.init_containing_window(this);
    Lino.Window.superclass.initComponent.call(this);
  
  },
  hide : function() { 
      this.main_item.do_when_clean(false,function() { 
        Lino.close_window(); });
  },
  hide_really : function() { 
    Lino.Window.superclass.hide.call(this);
  },
  onRender : function(ct, position){
    // console.log('20140829 Lino.Window.onRender() 1');
    Lino.Window.superclass.onRender.call(this, ct, position);
    var main_area = Ext.getCmp('main_area')
    //~ console.log('20120110 Lino.Window.onRender() 2');
  
    this.on('show', function(win) {
        // console.log('20140829 Lino.Window.on(show) : add resize handler');
        main_area.on('resize', win.onWindowResize, win);
    });
    this.on('hide', function(win) {
        // console.log('20140829 Lino.Window.on(hide) : remove resize handler');
        main_area.un('resize', win.onWindowResize, win);
    });
    // console.log('20140829 Lino.Window.onRender() 3');
  }
});


Ext.override(Ext.form.BasicForm,{
    my_loadRecord : function(values){
    //~ loadRecord : function(record){
        /* Same as ExtJS's loadRecord() (setValues()), except that we 
        forward also the record to field.setValue() so that Lino.Combobox 
        can use it. 
        */
        //~ console.log('20120918 my_loadRecord',values)
        if(Ext.isArray(values)){ 
            for(var i = 0, len = values.length; i < len; i++){
                var v = values[i];
                var f = this.findField(v.id);
                if(f){
                    f.setValue(v.value,values);
                    if(this.trackResetOnLoad){
                        f.originalValue = f.getValue();
                    }
                }
            }
        }else{ 
            var field, id;
            for(id in values){
                if(!Ext.isFunction(values[id]) && (field = this.findField(id))){
                    field.setValue(values[id],values);
                    if(this.trackResetOnLoad){
                        field.originalValue = field.getValue();
                        //~ if (field.hiddenField) {
                          //~ field.hiddenField.originalValue = field.hiddenField.value;
                        //~ }
                    }
                }
            }
        }
        return this;
    }
});




function initializeFooBarDropZone(cmp) {
    //~ console.log('initializeFooBarDropZone',cmp);
    cmp.dropTarget = new Ext.dd.DropTarget(cmp.bwrap, {
      //~ ddGroup     : 'gridDDGroup',
      notifyEnter : function(ddSource, e, data) {
        console.log('notifyEnter',ddSource,e,data);
        //Add some flare to invite drop.
        cmp.body.stopFx();
        cmp.body.highlight();
      },
      notifyDrop  : function(ddSource, e, data){
        console.log('notifyDrop',ddSource,e,data);
        // Reference the record (single selection) for readability
        //~ var selectedRecord = ddSource.dragData.selections[0];


        // Load the record into the form
        //~ formPanel.getForm().my_loadRecord(selectedRecord);


        // Delete record from the grid.  not really required.
        //~ ddSource.grid.store.remove(selectedRecord);

        return(true);
      }
    })
}



Lino.show_mti_child = function(fieldname,detail_handler) {
  //~ console.log('show_mti_child',this);
  //~ console.log('show_mti_child',panel.find("main_area"));
  rec = Lino.current_window.main_item.get_current_record();
  //~ rec = panel.get_current_record();
  if (rec) {
    //~ console.log('show_mti_child',Lino.current_window,rec);
    if (rec.phantom) {
      Lino.notify('Not allowed on phantom record.');
    }else if (rec.data[fieldname]) {
      //~ console.log('show_mti_child',rec.id);
      //~ detail_handler(Lino.current_window.main_item,{},{record_id:rec.id});
      detail_handler.run(null,{record_id:rec.id});
      //~ window.open(urlroot + '/' + rec.id);
      //~ document.location = urlroot + '/' + rec.id;
      //~ window.open(urlroot + '/' + rec.id,'_blank');
    } else {
      Lino.alert("Kann MTI-Kind nicht anzeigen wenn Checkbox abgeschlatet ist.");
    }
  } else {
    Lino.notify('No current record.');
  }
};


/*
captureEvents utility by Aaron Conran
<http://www.sencha.com/learn/grid-faq/>

Ext.onReady(function(){
    var grid = new Ext.grid.GridPanel({
        ... 
    });
    captureEvents(grid);
});
*/
function captureEvents(observable) {
    Ext.util.Observable.capture(
        observable,
        function(eventName) {
            console.info(eventName);
        },
        this
    );		
}

// settings.SITE.get_plugin_snippets()




// from lino.modlib.extensible (media_name=extensible, media_base_url=http://ext.ensible.com/deploy/1.0.2/):snippets/extensible.js

/*
  This is the `extensible.js` snippet. 
  Used in lino.modlib.extensible.App.site_js_snippets
*/

/*
Mappings towards lino.modlib.extensible.models.PanelCalendars
*/
// Sset SS = Ssite.modules.extensible.PanelCalendars.get_handle(Sui).store
Ext.ensible.cal.CalendarMappings = {
    CalendarId:   {name:'ID',       mapping: 'id', type: 'int'},
    Title:        {name:'CalTitle', mapping: 'summary', type: 'string'},
    Description:  {name:'Desc',     mapping: 'description', type: 'string'},
    ColorId:      {name:'Color',    mapping: 'color', type: 'int'},
    IsHidden:     {name:'Hidden',   mapping: 'is_hidden', type: 'boolean'},    
};
Ext.ensible.cal.CalendarRecord.reconfigure();  


/*
Mappings towards lino.modlib.extensible.models.PanelEvents 
*/
// Sset SS = Ssite.modules.extensible.PanelEvents.get_handle(Sui).store
Ext.ensible.cal.EventMappings = {
    EventId:     {name: 'ID',        mapping: 'id', type:'int'},
    CalendarId:  {name: 'CalID',     mapping: 'calendarHidden', type: 'int'},
    Title:       {name: 'EvtTitle',  mapping: 'summary'},
    StartDate:   {name: 'StartDt',   mapping: 'start_dt', 
      type: 'date', 
      dateFormat: "Y-m-d\TH:i:s" },
    EndDate:     {name: 'EndDt',     mapping: 'end_dt', 
      type: 'date', 
      dateFormat: "Y-m-d\TH:i:s"},
    RRule:       {name: 'RecurRule', mapping: 'rsetHidden'},
    Location:    {name: 'Location',  mapping: 'placeHidden'},
    Notes:       {name: 'Desc',      mapping: 'description'},
    Url:         {name: 'LinkUrl',   mapping: 'url'},
    IsAllDay:    {name: 'AllDay',    mapping: 'all_day', type: 'boolean'},
    Reminder:    {name: 'Reminder',  mapping: 'reminder'}
    
};
Ext.ensible.cal.EventRecord.reconfigure();


//~ Lino.on_eventclick = 
    
Lino.on_editdetails = 

Lino.format_time = function(dt) {
    return dt.getHours() + ':' + dt.getMinutes();
}
    
Lino.on_eventdelete = function() {
  //~ console.log("Lino.on_eventdelete",arguments);
};

Lino.on_eventadd  = function(cp,rec,el) {
  //~ console.log("Lino.on_eventadd ",arguments);
  return false;
}
    
Lino.on_eventresize  = function(cp,rec,el) {
  //~ console.log("Lino.on_eventresize ",arguments);
  //~ Lino.cal.Events.insert(cp);
  //~ return false;
}
    
Lino.on_eventupdate  = function(cp,rec,el) {
  //~ console.log("Lino.on_eventupdate",arguments);
  //~ Lino.cal.Events.insert(cp);
  //~ return false;
}
    

//~ Lino.eventStore = new Ext.ensible.cal.EventStore({ 
//~ Lino.eventStore = new Ext.data.ArrayStore({ 
Lino.unused_eventStore = new Ext.data.JsonStore({ 
  listeners: { exception: Lino.on_store_exception }
  ,url: '/restful/extensible/PanelEvents'
  ,restful : true
  ,proxy: new Ext.data.HttpProxy({ 
      url: '/restful/extensible/PanelEvents', 
      disableCaching: false // no need for cache busting when loading via Ajax
      //~ disableCaching:true,
  })
  ,fields: Ext.ensible.cal.EventRecord.prototype.fields.getRange()
  ,totalProperty: "count"
  ,root: "rows"
  ,idProperty: Ext.ensible.cal.EventMappings.EventId.mapping
  ,writer : new Ext.data.JsonWriter({
    writeAllFields: false
  })
  ,load: function(options) {
    //~ foo.bar = baz; // 20120213
      if (!options) options = {};
      if (!options.params) options.params = {};
      //~ options.params.$ext_requests.URL_PARAM_TEAM_VIEW = Lino.calendar_app.team_view_button.pressed;
      
      var view = this.cal_panel.getActiveView();
      var bounds = view.getViewBounds();
      //~ var p = {sd:'05.02.2012',ed:'11.02.2012'};
      //~ var p = {};
      options.params[view.dateParamStart] = bounds.start.format(view.dateParamFormat);
      options.params[view.dateParamEnd] = bounds.end.format(view.dateParamFormat);
      Lino.insert_subst_user(options.params);
      //~ Ext.apply(options.params,p)
      //~ console.log('20120710 eventStore.load()',this.baseParams,options);
    
    return Ext.data.JsonStore.prototype.load.call(this,options);
  }
});


Lino.CalendarCfg = {
    dateParamFormat: 'd.m.Y',
    dateParamStart:'sd',
    dateParamEnd:'ed'
};
//~ 20120704 Lino.CalendarPanel = Ext.extend(Ext.ensible.cal.CalendarPanel,Lino.MainPanel);
//~ Lino.CalendarPanel = Ext.extend(Lino.CalendarPanel,{
Ext.override(Ext.ensible.cal.CalendarPanel,Lino.MainPanel);
Ext.override(Ext.ensible.cal.CalendarPanel,{
  //~ empty_title : "\$ui.get_actor('cal.Panel').report.label",
  empty_title : "Kalender"
  ,activeItem: 1 // 0: day, 1: week
  ,ls_url: '/extensible/CalendarPanel'
  //~ ,disableCaching:true
  //~ ,eventStore: Lino.eventStore
  //~ ,calendarStore: Lino.calendarStore
  //~ ,initComponent : function(){
    //~ Ext.ensible.cal.CalendarPanel.superclass.initComponent.call(this);
    //~ this.eventStore.on('load',function(){
      //~ console.log("20130808",Lino.eventStore);
      //~ if (this.eventStore.reader.jsonData) {
        //~ console.log("20130808 b",this.eventStore.reader.jsonData.title);
        //~ this.set_window_title(this.eventStore.reader.jsonData.title);
      //~ }
    //~ },this);
  //~ }
  ,listeners: { 
    editdetails: function(cp,rec,el) {
      //~ console.log("Lino.on_editdetails",arguments);
      if (rec.data.ID)
          Lino.extensible.PanelEvents.detail.run(null,{
              record_id:rec.data.ID,
              base_params:this.app_instance.event_store.baseParams});
      return false;
    }
    ,eventclick: function(cp,rec,el) {
      //~ console.log("Lino.on_eventclick",arguments);
      //~ Lino.cal.Events.detail_action.run({record_id:rec.data.ID});
      Lino.extensible.PanelEvents.detail.run(null,{
            record_id:rec.data.ID,
                base_params:this.app_instance.event_store.baseParams});
      return false;
    }
    //~ ,eventadd: Lino.on_eventadd
    //~ ,eventdelete: Lino.on_eventdelete
    //~ ,eventresize: Lino.on_eventresize
    ,afterrender : function(config) {
      // console.log("20140402 CalendarPanel.afterrender");
      this.app_instance.calendar_store.cal_panel = this;
      // 20140402 this.app_instance.calendar_store.load();
      //~ console.log("20120704 afterrender calls eventStore.load()",p);
      this.app_instance.event_store.cal_panel = this;
      //~ Lino.eventStore.load({params:p});
      //~ 20130905 removed: this.app_instance.event_store.load();
      //~ Lino.CalendarPanel.superclass.constructor.call(this, config);
      //~ console.log(20120118, config,this);
    }
    }
  ,enableEditDetails: false
  //~ ,monthViewCfg: Lino.CalendarCfg
  //~ ,weekViewCfg: Lino.CalendarCfg
  //~ ,multiDayViewCfg: Lino.CalendarCfg
  //~ ,multiWeekViewCfg: Lino.CalendarCfg
  //~ ,dayViewCfg: Lino.CalendarCfg
  //~ ,initComponent : function() {
    //~ // this.on('eventadd',Lino.on_eventadd);
    //~ Lino.CalendarPanel.superclass.initComponent.call(this);
  //~ }
});




Lino.CalendarAppPanel = Ext.extend(Ext.Panel,Lino.MainPanel);
Lino.CalendarAppPanel = Ext.extend(Lino.CalendarAppPanel,Lino.PanelMixin);
Lino.CalendarAppPanel = Ext.extend(Lino.CalendarAppPanel,{
  app_instance : null
  //~ empty_title : "\$ui.get_actor('cal.Panel').report.label",
  ,empty_title : "Kalender"
  ,ls_url: '/extensible/CalendarPanel'
  ,set_status : function(status,rp) { 
      // console.log('20140402 CalendarAppPanel.set_status()', status);
      this.requesting_panel = Ext.getCmp(rp);
      this.clear_base_params();
      if (status == undefined) status = {};
      //~ if (status.param_values) 
      //~ this.set_field_values(status.field_values);
      if (status.base_params) this.set_base_params(status.base_params);
      this.refresh();
      }
  ,refresh : function() {
      //~ this.app_instance.event_store.reload(); 20130905
      this.app_instance.calendar_store.load();  // added 20140402
      this.app_instance.event_store.load();
  }
  ,layout: 'fit'
  ,get_base_params : function() {
    // console.log('20140402 getbase_params has', this.base_params);
    var p = Ext.apply({}, this.base_params);
    Lino.insert_subst_user(p);
    // console.log('20140402 getbase_params returns', p);
    return p;
  }
  ,set_base_params : function(p) {
    this.base_params = Ext.apply(this.app_instance.event_store.baseParams,p);
    this.app_instance.event_store.baseParams = this.base_params;
    // console.log('20140402 this.base_params is', this.base_params);
  }
  ,clear_base_params : function() {
      this.base_params = {};
      Lino.insert_subst_user(this.base_params);
  }
  ,set_base_param : function(k,v) {
      if (!this.base_params) this.base_params = {};
      this.base_params[k] = v;
  }
});

Lino.CalendarApp = function() { return {
  team_view_button : null 
  ,get_main_panel : function() {
      var cap = null;
      this.event_store = new Ext.data.JsonStore({ 
          listeners: { exception: Lino.on_store_exception }
          ,url: '/restful/extensible/PanelEvents'
          ,restful : true
          ,proxy: new Ext.data.HttpProxy({ 
              url: '/restful/extensible/PanelEvents', 
              disableCaching: false // no need for cache busting when loading via Ajax
              //~ disableCaching:true,
          })
          ,fields: Ext.ensible.cal.EventRecord.prototype.fields.getRange()
          ,totalProperty: "count"
          ,root: "rows"
          ,idProperty: Ext.ensible.cal.EventMappings.EventId.mapping
          ,writer : new Ext.data.JsonWriter({
            writeAllFields: false
          })
          ,load: function(options) {
            //~ foo.bar = baz; // 20120213
              if (!options) options = {};
              if (!options.params) options.params = {};
              //~ options.params.$ext_requests.URL_PARAM_TEAM_VIEW = Lino.calendar_app.team_view_button.pressed;
              
              var view = this.cal_panel.getActiveView();
              var bounds = view.getViewBounds();
              //~ var p = {sd:'05.02.2012',ed:'11.02.2012'};
              //~ var p = {};
              options.params[view.dateParamStart] = bounds.start.format(view.dateParamFormat);
              options.params[view.dateParamEnd] = bounds.end.format(view.dateParamFormat);
              Lino.insert_subst_user(options.params);
              Ext.apply(options.params, cap.get_base_params());
              //~ this.cal_panel.base_params.su.toString();
              //~ if (this.cal_panel) {
                  // Ext.apply(options.params,this.cal_panel.base_params);
              //~ }
              //~ Ext.apply(options.params,p)
              //~ console.log('20130905 eventStore.load()',this.cal_panel,this.baseParams,options.params);
            
            return Ext.data.JsonStore.prototype.load.call(this,options);
          }
      });

      //~ Lino.calendarStore
      this.calendar_store = new Ext.data.JsonStore({ 
          listeners: { exception: Lino.on_store_exception }
          ,restful : true
          ,proxy: new Ext.data.HttpProxy({ 
              url: '/restful/extensible/PanelCalendars?fmt=json', 
              disableCaching: false // no need for cache busting when loading via Ajax
              //~ restful : true
              //~ method: "GET"
          })
          //~ ,autoLoad: true
          //~ ,remoteSort: true
          //~ ,baseParams: bp
          ,totalProperty: "count"
          ,root: "rows"
          ,fields: Ext.ensible.cal.CalendarRecord.prototype.fields.getRange()
          ,idProperty: Ext.ensible.cal.CalendarMappings.CalendarId.mapping
          //~ ,idIndex: Ext.ensible.cal.CalendarMappings.CalendarId.mapping
          ,load: function(options) {
              // new since 20140402 add substitute user when calling
              // calendars
              if (!options) options = {};
              if (!options.params) options.params = {};
              // Lino.insert_subst_user(options.params);
              Ext.apply(options.params, cap.get_base_params());
              // console.log("20140402 calendar_store.load", options.params, 
              //             this.cal_panel, cap.get_base_params());
            return Ext.data.JsonStore.prototype.load.call(this,options);
          }
      });
      
      cap = new Lino.CalendarAppPanel({ 
          app_instance: this, 
          items : 
        //~ [{
          //~ id: 'app-header',
          //~ region: 'north',
          //~ height: 35,
          //~ border: false,
          // contentEl: 'app-header-content'
        //~ },
      {
          id: 'app-center',
          title: '...', // will be updated to the current view's date range
          region: 'center',
          layout: 'border',
          listeners: {
              'afterrender': function(){
                  Ext.getCmp('app-center').header.addClass('app-center-header');
              }
          },
          items: [{
              id:'app-west',
              region: 'west',
              width: 176,
              border: false,
              items: [{
                  xtype: 'datepicker',
                  id: 'app-nav-picker',
                  cls: 'ext-cal-nav-picker',
                  listeners: {
                      'select': {
                          fn: function(dp, dt){
                              // console.log("20131017",dp);
                              //~ Lino.calendarPanel.setStartDate(dt);
                              //~ cap.setStartDate(dt);
                              Ext.getCmp('app-calendar').setStartDate(dt);
                          },
                          //~ scope: this
                      }
                  }
              //~ },{ 
                //~ layout:'fit',
                //~ items: [
                  //~ new Ext.form.Checkbox({
                    //~ boxLabel:"$_('Team view')",
                    //~ hideLabel:true
                    //~ listeners: { click: }
                  //~ })
                //~ ]
              //~ },{ 
                //~ layout:'form',
                //~ items: [
                  //~ this.team_view_button = new Ext.Button({
                    //~ text:"Team view",
                    //~ enableToggle:true,
                    //~ pressed:false,
                    //~ toggleHandler: function(btn,state) { 
                      //~ // console.log('20120716 teamView.toggle()');
                      //~ this.event_store.setBaseParam('tv',state);
                      //~ this.event_store.load();
                      //~ // Lino.eventStore.load({params:{$ext_requests.URL_PARAM_TEAM_VIEW:state}});
                      //~ // console.log("team view",state);
                    //~ }
                  //~ })
                //~ ]
              },{
                  xtype: 'extensible.calendarlist',
                  store: this.calendar_store,
                  border: false,
                  width: 175
              }]
          },{
              xtype: 'extensible.calendarpanel', // Ext.ensible.cal.CalendarPanel
              eventStore: this.event_store,
              app_instance: this,
              calendarStore: this.calendar_store,
              border: false,
              id:'app-calendar',
              region: 'center',
              //~ activeItem: 3, // month view
              
              // Any generic view options that should be applied to all sub views:
              viewConfig: {
                  // Lino.CalendarCfg
                  dateParamFormat: 'd.m.Y',
                  dateParamStart:'sd',
                  dateParamEnd:'ed',
                
                  //enableFx: false,
                  //ddIncrement: 10, //only applies to DayView and subclasses, but convenient to put it here
                  viewStartHour: 8, // 8
                  viewEndHour: 18 // 18
                  //minEventDisplayMinutes: 15
              },
              
              // View options specific to a certain view (if the same options exist in viewConfig
              // they will be overridden by the view-specific config):
              monthViewCfg: {
                  showHeader: true,
                  showWeekLinks: true,
                  showWeekNumbers: true,
                  eventBodyMarkup: ['{Title}',
                    //~ '<tpl if="url">',
                        //~ '<a href="{url}">XX</a>',
                    //~ '</tpl>',
                    '<tpl if="_isReminder">',
                        '<i class="ext-cal-ic ext-cal-ic-rem">&#160;</i>',
                    '</tpl>',
                    '<tpl if="_isRecurring">',
                        '<i class="ext-cal-ic ext-cal-ic-rcr">&#160;</i>',
                    '</tpl>',
                    '<tpl if="spanLeft">',
                        '<i class="ext-cal-spl">&#160;</i>',
                    '</tpl>',
                    '<tpl if="spanRight">',
                        '<i class="ext-cal-spr">&#160;</i>',
                    '</tpl>'
                ].join('')
              },
              
              multiWeekViewCfg: {
                  //weekCount: 3
              },
              
              // Some optional CalendarPanel configs to experiment with:
              //readOnly: true,
              //showDayView: false,
              //showMultiDayView: true,
              //showWeekView: false,
              //showMultiWeekView: false,
              //showMonthView: false,
              //showNavBar: false,
              //showTodayText: false,
              //showTime: false,
              //editModal: true,
              //enableEditDetails: false,
              //title: 'My Calendar', // the header of the calendar, could be a subtitle for the app
              
              // Once this component inits it will set a reference to itself as an application
              // member property for easy reference in other functions within App.
              //~ initComponent: function() {
                  //~ Lino.calendarPanel = this;
                  //~ this.constructor.prototype.initComponent.apply(this, arguments);
              //~ },
              
              listeners: {
                  //~ 'eventclick': {
                      //~ fn: function(vw, rec, el){
                          //~ this.clearMsg();
                      //~ },
                      //~ scope: this
                  //~ },
                  'eventover': function(vw, rec, el){
                      //console.log('Entered evt rec='+rec.data[Ext.ensible.cal.EventMappings.Title.name]', view='+ vw.id +', el='+el.id);
                  },
                  'eventout': function(vw, rec, el){
                      //console.log('Leaving evt rec='+rec.data[Ext.ensible.cal.EventMappings.Title.name]+', view='+ vw.id +', el='+el.id);
                  },
                  'eventadd': {
                      fn: function(cp, rec){
                          this.showMsg('Event '+ rec.data[Ext.ensible.cal.EventMappings.Title.name] +' was added');
                      },
                      scope: this
                  },
                  'eventupdate': {
                      fn: function(cp, rec){
                          this.showMsg('Event '+ rec.data[Ext.ensible.cal.EventMappings.Title.name] +' was updated');
                      },
                      scope: this
                  },
                  'eventdelete': {
                      fn: function(cp, rec){
                          //this.eventStore.remove(rec);
                          this.showMsg('Event '+ rec.data[Ext.ensible.cal.EventMappings.Title.name] +' was deleted');
                      },
                      scope: this
                  },
                  'eventcancel': {
                      fn: function(cp, rec){
                          // edit canceled
                      },
                      scope: this
                  },
                  'viewchange': {
                      fn: function(p, vw, dateInfo){
                          if(this.editWin){
                              this.editWin.hide();
                          };
                          if(dateInfo !== null){
                              // will be null when switching to the event edit form so ignore
                              Ext.getCmp('app-nav-picker').setValue(dateInfo.activeDate);
                              this.updateTitle(dateInfo.viewStart, dateInfo.viewEnd);
                          }
                          
                      },
                      scope: this
                  },
                  'dayclick': {
                      fn: function(vw, dt, ad, el){
                          this.clearMsg();
                      },
                      scope: this
                  },
                  'rangeselect': {
                      fn: function(vw, dates, onComplete){
                          this.clearMsg();
                      },
                      scope: this
                  },
                  'eventmove': {
                      fn: function(vw, rec){
                          rec.commit();
                          var time = rec.data[Ext.ensible.cal.EventMappings.IsAllDay.name] ? '' : ' \\a\\t g:i a';
                          this.showMsg('Event '+ rec.data[Ext.ensible.cal.EventMappings.Title.name] +' was moved to '+
                              rec.data[Ext.ensible.cal.EventMappings.StartDate.name].format('F jS'+time));
                      },
                      scope: this
                  },
                  'eventresize': {
                      fn: function(vw, rec){
                          rec.commit();
                          this.showMsg('Event '+ rec.data[Ext.ensible.cal.EventMappings.Title.name] +' was updated');
                      },
                      scope: this
                  },
                  'eventdelete': {
                      fn: function(win, rec){
                          this.event_store.remove(rec);
                          this.showMsg('Event '+ rec.data[Ext.ensible.cal.EventMappings.Title.name] +' was deleted');
                      },
                      scope: this
                  },
                  'initdrag': {
                      fn: function(vw){
                          if(this.editWin && this.editWin.isVisible()){
                              this.editWin.hide();
                          }
                      },
                      scope: this
                  }
              }
          }]
        }
        //~ ]
        
      });
      
      this.event_store.on('load',function(){
        //~ console.log("20130905 on event_store load",this.event_store.reader.jsonData);
        if (this.event_store.reader.jsonData) {
          //~ console.log("20130808 b",this.event_store.reader.jsonData.title);
          //~ console.log("20130808 c",this);
          cap.set_window_title(this.event_store.reader.jsonData.title);
        }
      },this);
      
      //~ cap.app_instance = this;
      return cap;
      
  }
  ,updateTitle: function(startDt, endDt){
      var p = Ext.getCmp('app-center');
      
      if(startDt.clearTime().getTime() == endDt.clearTime().getTime()){
          p.setTitle(startDt.format('F j, Y'));
      }
      else if(startDt.getFullYear() == endDt.getFullYear()){
          if(startDt.getMonth() == endDt.getMonth()){
              p.setTitle(startDt.format('F j') + ' - ' + endDt.format('j, Y'));
          }
          else{
              p.setTitle(startDt.format('F j') + ' - ' + endDt.format('F j, Y'));
          }
      }
      else{
          p.setTitle(startDt.format('F j, Y') + ' - ' + endDt.format('F j, Y'));
      }
  }
  // This is an application-specific way to communicate CalendarPanel event messages back to the user.
  // This could be replaced with a function to do "toast" style messages, growl messages, etc. This will
  // vary based on application requirements, which is why it's not baked into the CalendarPanel.
  ,showMsg: function(msg){
      Lino.notify(msg);
      //~ Ext.fly('app-msg').update(msg).removeClass('x-hidden');
  }
  
  ,clearMsg: function(){
      Lino.notify('');
      //~ Ext.fly('app-msg').update('').addClass('x-hidden');
  }
}
};


// from lino.modlib.iban:iban/uppercasetextfield.js

Lino.UppercaseTextField = Ext.extend(Ext.form.TextField,{
  style: 'text-transform:uppercase;',
  listeners:{
    change: function(field, newValue, oldValue){
      // console.log("20140403 UppercaseTextField",newValue, newValue.toUpperCase());
      field.setRawValue(newValue.toUpperCase());
    }
  }
});


Lino.iban_renderer = function(
    value, metaData, record, rowIndex, colIndex, store) 
{
    var reg = new RegExp(".{4}", "g");
    if(value) {
        return value.replace(reg, function (a) { return a + ' '; });
    }
    return value;
}




// from lino.modlib.beid (media_name=eidreader):beid/eidreader.js


Lino.beid_read_card_processor = function() {
    var card = document.applets.EIDReader.readCard();
    // if (!card) {
    //     Lino.alert("Could not find any card on your reader.");
    //     return null;
    // } 
    // console.log(20140301, card);
    return { card_data: card };
}


// from lino.modlib.davlink (media_name=davlink):davlink/davlink.js

/*
 Copyright 2009-2014 Luc Saffre
 License: BSD (see file COPYING for details)
*/

Lino.davlink_open = function(webdavURL) {
  /* Calls lino.applets.davlink.DavLink.open()
  */
  //~ console.log('Going to call document.applets.DavLink.open(',webdavURL,')');
  var rv = document.applets.DavLink.open(webdavURL);
  if (rv) window.alert(rv);
}

Lino.davlink_reset = function() {
  var rv = document.applets.DavLink.generate_default_prefs();
  if (rv) window.alert(rv);
}

Lino.main_menu = [ { "menu": { "items": [ { "text": "Personen", "handler": function() {Lino.contacts.Persons.grid.run(null)} }, { "text": " \u25b6 Klienten", "handler": function() {Lino.pcsw.Clients.grid.run(null)} }, { "text": "Organisationen", "handler": function() {Lino.contacts.Companies.grid.run(null)} }, "-", { "text": "Partner (alle)", "handler": function() {Lino.contacts.Partners.grid.run(null)} }, { "text": "Haushalte", "handler": function() {Lino.households.Households.grid.run(null)} } ] }, "text": "Kontakte" }, { "menu": { "items": [ { "text": "Meine Uploads", "handler": function() {Lino.uploads.MyUploads.grid.run(null)} }, { "text": "Mein E-Mail-Ausgang", "handler": function() {Lino.outbox.MyOutbox.grid.run(null)} }, { "text": "Meine Ausz\u00fcge", "handler": function() {Lino.excerpts.MyExcerpts.grid.run(null)} }, { "text": "Meine Ereignisse/Notizen", "handler": function() {Lino.notes.MyNotes.grid.run(null)} } ] }, "text": "B\u00fcro" }, { "menu": { "items": [ { "text": "Kalender", "iconCls": "x-tbar-calendar", "handler": function() {Lino.extensible.CalendarPanel.grid.run(null)}, "listeners": { "render": Lino.quicktip_renderer("Foo","Displays your events in a \"calendar view\"     with the possibility to switch between daily, weekly, monthly view.") } }, { "text": "Meine Termine", "listeners": { "render": Lino.quicktip_renderer("Foo","Alle meine Termine") }, "handler": function() {Lino.cal.MyEvents.grid.run(null)} }, { "text": "Meine Aufgaben", "listeners": { "render": Lino.quicktip_renderer("Foo","Alle meine Aufgaben") }, "handler": function() {Lino.cal.MyTasks.grid.run(null)} }, { "text": "Meine G\u00e4ste", "handler": function() {Lino.cal.MyGuests.grid.run(null)} }, { "text": "Meine Anwesenheiten", "listeners": { "render": Lino.quicktip_renderer("Foo","Shows all my presences in calendar events, independently of their state.") }, "handler": function() {Lino.cal.MyPresences.grid.run(null)} } ] }, "text": "Kalender" }, { "menu": { "items": [ { "text": "Klienten", "handler": function() {Lino.reception.Clients.grid.run(null)} }, { "text": "Termine heute", "handler": function() {Lino.cal.EventsByDay.grid.run(null)} }, { "text": "Wartende Besucher", "listeners": { "render": Lino.quicktip_renderer("Foo","Shows the visitors in the waiting room.") }, "handler": function() {Lino.reception.WaitingVisitors.grid.run(null)} }, { "text": "Besch\u00e4ftigte Besucher", "listeners": { "render": Lino.quicktip_renderer("Foo","Shows the visitors who are busy with some agent.") }, "handler": function() {Lino.reception.BusyVisitors.grid.run(null)} }, { "text": "Gegangene Besucher", "listeners": { "render": Lino.quicktip_renderer("Foo","Shows the visitors who have gone.") }, "handler": function() {Lino.reception.GoneVisitors.grid.run(null)} }, { "text": "Meine Warteschlange", "handler": function() {Lino.reception.MyWaitingVisitors.grid.run(null)} } ] }, "text": "Empfang" }, { "menu": { "items": [ { "text": "Meine Begleitungen", "handler": function() {Lino.pcsw.MyCoachings.grid.run(null)} }, { "text": "Zu unterschreibende Hilfebeschl\u00fcsse", "handler": function() {Lino.aids.MyPendingGrantings.grid.run(null)} } ] }, "text": "\u00d6SHZ" }, { "menu": { "items": [ { "text": "Klienten", "listeners": { "render": Lino.quicktip_renderer("Foo","Wie Kontakte --> Klienten, aber mit     DSBE-spezifischen Kolonnen und Filterparametern.") }, "handler": function() {Lino.integ.Clients.grid.run(null)} }, { "text": "VSEs", "handler": function() {Lino.isip.MyContracts.grid.run(null)} }, { "text": "Art.60\u00a77-Konventionen", "handler": function() {Lino.jobs.MyContracts.grid.run(null)} }, { "text": "Stellenanbieter", "handler": function() {Lino.jobs.JobProviders.grid.run(null)} }, { "text": "Stellen", "listeners": { "render": Lino.quicktip_renderer("Foo","\n    Eine Stelle ist ein Arbeitsplatz bei einem Stellenabieter.\n    ") }, "handler": function() {Lino.jobs.Jobs.grid.run(null)} }, { "text": "Stellenangebote", "handler": function() {Lino.jobs.Offers.grid.run(null)} } ] }, "text": "DSBE" }, { "menu": { "items": [ { "text": "Kursanbieter", "handler": function() {Lino.courses.CourseProviders.grid.run(null)} }, { "text": "Kursangebote", "handler": function() {Lino.courses.CourseOffers.grid.run(null)} }, { "text": "Offene Kursanfragen", "handler": function() {Lino.courses.PendingCourseRequests.grid.run(null)} } ] }, "text": "Kurse" }, { "menu": { "items": [ { "text": "Neue Klienten", "listeners": { "render": Lino.quicktip_renderer("Foo","Liste der neuen Klienten zwecks Zuweisung \neines Begleiters oder Ablehnen des Hilfeantrags.") }, "handler": function() {Lino.newcomers.NewClients.grid.run(null)} }, { "text": "Verf\u00fcgbare Begleiter", "listeners": { "render": Lino.quicktip_renderer("Foo","List of users available for new coachings") }, "handler": function() {Lino.newcomers.AvailableCoaches.grid.run(null)} } ] }, "text": "Neuantr\u00e4ge" }, { "menu": { "items": [ { "text": "Klienten", "listeners": { "render": Lino.quicktip_renderer("Foo","Wie Kontakte --> Klienten, aber mit Kolonnen und Filterparametern f\u00fcr Schuldnerberatung.") }, "handler": function() {Lino.debts.Clients.grid.run(null)} }, { "text": "Meine Budgets", "handler": function() {Lino.debts.MyBudgets.grid.run(null)} } ] }, "text": "Schuldnerberatung" }, { "menu": { "items": [ { "text": "Meine Polls", "handler": function() {Lino.polls.MyPolls.grid.run(null)} }, { "text": "Meine Responses", "handler": function() {Lino.polls.MyResponses.grid.run(null)} } ] }, "text": "Polls" }, { "menu": { "items": [ { "menu": { "items": [ { "text": "Stale Controllables", "handler": function() {Lino.contenttypes.StaleControllables.grid.run(null)} } ] }, "text": "System" }, { "menu": { "items": [ { "text": "Datenkontrolle Klienten", "listeners": { "render": Lino.quicktip_renderer("Foo","Table of Clients whose data seems unlogical or inconsistent.") }, "handler": function() {Lino.pcsw.ClientsTest.grid.run(null)} } ] }, "text": "\u00d6SHZ" }, { "menu": { "items": [ { "text": "Benutzer und ihre Klienten", "handler": function() {Lino.integ.UsersWithClients.grid.run(null)} }, { "text": "\u00dcbersicht Art.60\u00a77-Konventionen", "listeners": { "render": Lino.quicktip_renderer("Foo","Detail-Fenster auf diesem Datensatz \u00f6ffnen") }, "handler": function() {Lino.jobs.JobsOverview.show.run(null,{ "record_id": -99998 })} }, { "text": "T\u00e4tigkeitsbericht", "listeners": { "render": Lino.quicktip_renderer("Foo","Detail-Fenster auf diesem Datensatz \u00f6ffnen") }, "handler": function() {Lino.integ.ActivityReport.show.run(null,{ "record_id": -99998 })} } ] }, "text": "DSBE" } ] }, "text": "Listings" }, { "menu": { "items": [ { "menu": { "items": [ { "text": "Meine Einf\u00fcgetexte", "handler": function() {Lino.system.MyTextFieldTemplates.grid.run(null)} }, { "text": "Upload-Arten", "handler": function() {Lino.uploads.UploadTypes.grid.run(null)} }, { "text": "Auszugsarten", "handler": function() {Lino.excerpts.ExcerptTypes.grid.run(null)} }, { "text": "Notizarten", "handler": function() {Lino.notes.NoteTypes.grid.run(null)} }, { "text": "Ereignisarten", "handler": function() {Lino.notes.EventTypes.grid.run(null)} } ] }, "text": "B\u00fcro" }, { "menu": { "items": [ { "text": "Site-Parameter", "iconCls": "x-tbar-application_form", "handler": function() {Lino.system.SiteConfigs.detail.run(null,{ "record_id": 1 })} }, { "text": "Benutzer", "listeners": { "render": Lino.quicktip_renderer("Foo","Shows the list of all users on this site.") }, "handler": function() {Lino.users.Users.grid.run(null)} }, { "text": "Hilfetexte", "handler": function() {Lino.contenttypes.HelpTexts.grid.run(null)} } ] }, "text": "System" }, { "menu": { "items": [ { "text": "L\u00e4nder", "listeners": { "render": Lino.quicktip_renderer("Foo","\n    A country is a geographic entity considered a \"nation\".\n    ") }, "handler": function() {Lino.countries.Countries.grid.run(null)} }, { "text": "Orte", "listeners": { "render": Lino.quicktip_renderer("Foo","\n    The table of known geographical places.\n    A geographical place can be a city, a town, a suburb,\n    a province, a lake... any named geographic entity,\n    except for countries because these have their own table.\n    ") }, "handler": function() {Lino.countries.Places.grid.run(null)} } ] }, "text": "Orte" }, { "menu": { "items": [ { "text": "Eigenschaftsgruppen", "handler": function() {Lino.properties.PropGroups.grid.run(null)} }, { "text": "Eigenschafts-Datentypen", "handler": function() {Lino.properties.PropTypes.grid.run(null)} }, { "text": "Fachkompetenzen", "handler": function() {Lino.properties.PropsByGroup.grid.run(null,{ "base_params": { "mt": 12, "mk": 1 } })} }, { "text": "Sozialkompetenzen", "handler": function() {Lino.properties.PropsByGroup.grid.run(null,{ "base_params": { "mt": 12, "mk": 2 } })} }, { "text": "Hindernisse", "handler": function() {Lino.properties.PropsByGroup.grid.run(null,{ "base_params": { "mt": 12, "mk": 3 } })} } ] }, "text": "Eigenschaften" }, { "menu": { "items": [ { "text": "Organisationsarten", "handler": function() {Lino.contacts.CompanyTypes.grid.run(null)} }, { "text": "Funktionen", "handler": function() {Lino.contacts.RoleTypes.grid.run(null)} }, { "text": "Sprachen", "handler": function() {Lino.languages.Languages.grid.run(null)} }, { "text": "Gremien", "handler": function() {Lino.boards.Boards.grid.run(null)} }, { "text": "Haushaltsarten", "handler": function() {Lino.households.Types.grid.run(null)} } ] }, "text": "Kontakte" }, { "menu": { "items": [ { "text": "Kalenderliste", "handler": function() {Lino.cal.Calendars.grid.run(null)} }, { "text": "R\u00e4ume", "listeners": { "render": Lino.quicktip_renderer("Foo","List of rooms where calendar events can happen.") }, "handler": function() {Lino.cal.Rooms.grid.run(null)} }, { "text": "Priorit\u00e4ten", "listeners": { "render": Lino.quicktip_renderer("Foo","List of possible priorities of calendar events.") }, "handler": function() {Lino.cal.Priorities.grid.run(null)} }, { "text": "Periodische Termine", "handler": function() {Lino.cal.RecurrentEvents.grid.run(null)} }, { "text": "Gastrollen", "listeners": { "render": Lino.quicktip_renderer("Foo","The role of a guest expresses what the partner is going to do there.") }, "handler": function() {Lino.cal.GuestRoles.grid.run(null)} }, { "text": "Ereignisarten", "listeners": { "render": Lino.quicktip_renderer("Foo","The list of Event Types defined on this system.\n    An EventType is a list of events which have certain things in common,\n    especially they are displayed in the same colour in the calendar panel") }, "handler": function() {Lino.cal.EventTypes.grid.run(null)} }, { "text": "Externe Kalender", "handler": function() {Lino.cal.RemoteCalendars.grid.run(null)} } ] }, "text": "Kalender" }, { "menu": { "items": [ { "text": "Kontenpl\u00e4ne", "handler": function() {Lino.accounts.Charts.grid.run(null)} }, { "text": "Kontengruppen", "handler": function() {Lino.accounts.Groups.grid.run(null)} }, { "text": "Konten", "handler": function() {Lino.accounts.Accounts.grid.run(null)} } ] }, "text": "Buchhaltung" }, { "menu": { "items": [ { "text": "Badges", "handler": function() {Lino.badges.Badges.grid.run(null)} } ] }, "text": "Badges" }, { "menu": { "items": [ { "text": "Integrationsphasen", "listeners": { "render": Lino.quicktip_renderer("Foo","Liste der m\u00f6glichen Integrationsphasen.") }, "handler": function() {Lino.pcsw.PersonGroups.grid.run(null)} }, { "text": "Berufe", "listeners": { "render": Lino.quicktip_renderer("Foo","Liste des \"activit\u00e9s\" ou \"codes profession\".") }, "handler": function() {Lino.pcsw.Activities.grid.run(null)} }, { "text": "AG-Sperrgr\u00fcnde", "listeners": { "render": Lino.quicktip_renderer("Foo","Liste des raisons possibles d'arr\u00eater temporairement \n    le paiement d'une aide financi\u00e8re pr\u00e9vue.") }, "handler": function() {Lino.pcsw.ExclusionTypes.grid.run(null)} }, { "text": "Dienste", "handler": function() {Lino.pcsw.CoachingTypes.grid.run(null)} }, { "text": "Begleitungsbeendigungsgr\u00fcnde", "listeners": { "render": Lino.quicktip_renderer("Foo","A list of reasons expressing why a coaching was ended") }, "handler": function() {Lino.pcsw.CoachingEndings.grid.run(null)} }, { "text": "Dispenzgr\u00fcnde", "listeners": { "render": Lino.quicktip_renderer("Foo","A list of reasons for being dispensed") }, "handler": function() {Lino.pcsw.DispenseReasons.grid.run(null)} }, { "text": "Klientenkontaktarten", "listeners": { "render": Lino.quicktip_renderer("Foo","Liste der Arten von Klientenkontakten.") }, "handler": function() {Lino.pcsw.ClientContactTypes.grid.run(null)} }, { "text": "Hilfearten", "handler": function() {Lino.aids.AidTypes.grid.run(null)} }, { "text": "Kategorien", "handler": function() {Lino.aids.Categories.grid.run(null)} } ] }, "text": "\u00d6SHZ" }, { "menu": { "items": [ { "text": "Lehrenarten", "handler": function() {Lino.cv.TrainingTypes.grid.run(null)} }, { "text": "Studienarten", "handler": function() {Lino.cv.StudyTypes.grid.run(null)} }, { "text": "Akademische Grade", "handler": function() {Lino.cv.EducationLevels.grid.run(null)} }, { "text": "Sektoren", "handler": function() {Lino.cv.Sectors.grid.run(null)} }, { "text": "Funktionen", "handler": function() {Lino.cv.Functions.grid.run(null)} }, { "text": "Arbeitsregimes", "handler": function() {Lino.cv.Regimes.grid.run(null)} }, { "text": "Statuus", "handler": function() {Lino.cv.Statuses.grid.run(null)} }, { "text": "Vertragsdauern", "handler": function() {Lino.cv.Durations.grid.run(null)} } ] }, "text": "Lebenslauf" }, { "menu": { "items": [ { "text": "VSE-Arten", "handler": function() {Lino.isip.ContractTypes.grid.run(null)} }, { "text": "Vertragsbeendigungsgr\u00fcnde", "handler": function() {Lino.isip.ContractEndings.grid.run(null)} }, { "text": "Auswertungsstrategien", "handler": function() {Lino.isip.ExamPolicies.grid.run(null)} }, { "text": "Art.60\u00a77-Konventionsarten", "handler": function() {Lino.jobs.ContractTypes.grid.run(null)} }, { "text": "Stellenarten", "handler": function() {Lino.jobs.JobTypes.grid.run(null)} }, { "text": "Stundenpl\u00e4ne", "handler": function() {Lino.jobs.Schedules.grid.run(null)} } ] }, "text": "DSBE" }, { "menu": { "items": [ { "text": "Kursinhalte", "handler": function() {Lino.courses.CourseContents.grid.run(null)} } ] }, "text": "Kurse" }, { "menu": { "items": [ { "text": "Vermittler", "handler": function() {Lino.newcomers.Brokers.grid.run(null)} }, { "text": "Fachbereiche", "handler": function() {Lino.newcomers.Faculties.grid.run(null)} } ] }, "text": "Neuantr\u00e4ge" }, { "menu": { "items": [ { "text": "Sektoren", "handler": function() {Lino.cbss.Sectors.grid.run(null)} }, { "text": "Eigenschafts-Codes", "handler": function() {Lino.cbss.Purposes.grid.run(null)} } ] }, "text": "ZDSS" }, { "menu": { "items": [ { "text": "Budget-Kopiervorlage", "iconCls": "x-tbar-application_form", "handler": function() {Lino.debts.MyBudgets.detail.run(null,{ "record_id": 1 })} } ] }, "text": "Schuldnerberatung" }, { "menu": { "items": [ { "text": "Client project types", "handler": function() {Lino.projects.ProjectTypes.grid.run(null)} } ] }, "text": "Client projects" }, { "menu": { "items": [ { "text": "Choice Sets", "handler": function() {Lino.polls.ChoiceSets.grid.run(null)} } ] }, "text": "Polls" } ] }, "text": "Konfigurierung" }, { "menu": { "items": [ { "menu": { "items": [ { "text": "Einf\u00fcgetexte", "handler": function() {Lino.system.TextFieldTemplates.grid.run(null)} }, { "text": "Uploads", "handler": function() {Lino.uploads.Uploads.grid.run(null)} }, { "text": "Upload-Bereiche", "handler": function() {Lino.uploads.UploadAreas.grid.run(null)} }, { "text": "E-Mail-Ausg\u00e4nge", "handler": function() {Lino.outbox.Mails.grid.run(null)} }, { "text": "Anh\u00e4nge", "handler": function() {Lino.outbox.Attachments.grid.run(null)} }, { "text": "Ausz\u00fcge", "handler": function() {Lino.excerpts.Excerpts.grid.run(null)} }, { "text": "Ereignisse/Notizen", "handler": function() {Lino.notes.Notes.grid.run(null)} } ] }, "text": "B\u00fcro" }, { "menu": { "items": [ { "text": "Vollmachten", "handler": function() {Lino.users.Authorities.grid.run(null)} }, { "text": "Benutzergruppen", "handler": function() {Lino.users.UserGroups.grid.run(null)} }, { "text": "Benutzer-Levels", "handler": function() {Lino.users.UserLevels.grid.run(null)} }, { "text": "Benutzerprofile", "handler": function() {Lino.users.UserProfiles.grid.run(null)} }, { "text": "Datenbankmodelle", "handler": function() {Lino.contenttypes.ContentTypes.grid.run(null)} }, { "text": "\u00c4nderungen", "handler": function() {Lino.changes.Changes.grid.run(null)} } ] }, "text": "System" }, { "menu": { "items": [ { "text": "Eigenschaften", "handler": function() {Lino.properties.Properties.grid.run(null)} } ] }, "text": "Eigenschaften" }, { "menu": { "items": [ { "text": "Kontaktpersonen", "handler": function() {Lino.contacts.Roles.grid.run(null)} }, { "text": "Adressenarten", "handler": function() {Lino.addresses.AddressTypes.grid.run(null)} }, { "text": "Adressen", "handler": function() {Lino.addresses.Addresses.grid.run(null)} }, { "text": "Gremienmitglieder", "handler": function() {Lino.boards.Members.grid.run(null)} }, { "text": "Rollen", "handler": function() {Lino.households.MemberRoles.grid.run(null)} }, { "text": "Mitglieder", "handler": function() {Lino.households.Members.grid.run(null)} }, { "text": "Verwandtschaftsbeziehungen", "handler": function() {Lino.humanlinks.Links.grid.run(null)} }, { "text": "Verwandschaftsarten", "handler": function() {Lino.humanlinks.LinkTypes.grid.run(null)} } ] }, "text": "Kontakte" }, { "menu": { "items": [ { "text": "Aufgaben", "listeners": { "render": Lino.quicktip_renderer("Foo","A calendar task is something you need to do.\n    ") }, "handler": function() {Lino.cal.Tasks.grid.run(null)} }, { "text": "Teilnehmer", "listeners": { "render": Lino.quicktip_renderer("Foo","A guest is a partner invited to an event. ") }, "handler": function() {Lino.cal.Guests.grid.run(null)} }, { "text": "Abonnements", "handler": function() {Lino.cal.Subscriptions.grid.run(null)} }, { "text": "Termin-Zust\u00e4nde", "listeners": { "render": Lino.quicktip_renderer("Foo","The possible states of a calendar event.") }, "handler": function() {Lino.cal.EventStates.grid.run(null)} }, { "text": "Gast-Zust\u00e4nde", "handler": function() {Lino.cal.GuestStates.grid.run(null)} }, { "text": "Aufgaben-Zust\u00e4nde", "handler": function() {Lino.cal.TaskStates.grid.run(null)} } ] }, "text": "Kalender" }, { "menu": { "items": [ { "text": "Badge Awards", "handler": function() {Lino.badges.Awards.grid.run(null)} } ] }, "text": "Badges" }, { "menu": { "items": [ { "text": "Konten", "handler": function() {Lino.sepa.Accounts.grid.run(null)} } ] }, "text": "SEPA" }, { "menu": { "items": [ { "text": "Begleitungen", "listeners": { "render": Lino.quicktip_renderer("Foo","Liste der Begleitungen") }, "handler": function() {Lino.pcsw.Coachings.grid.run(null)} }, { "text": "Klientenkontakte", "listeners": { "render": Lino.quicktip_renderer("Foo","Liste der Klientenkontakte") }, "handler": function() {Lino.pcsw.ClientContacts.grid.run(null)} }, { "text": "AG-Sperren", "listeners": { "render": Lino.quicktip_renderer("Foo","Liste der Arbeitslosengeld-Sperren") }, "handler": function() {Lino.pcsw.Exclusions.grid.run(null)} }, { "text": "Vorstrafen", "handler": function() {Lino.pcsw.Convictions.grid.run(null)} }, { "text": "Klienten", "handler": function() {Lino.pcsw.AllClients.grid.run(null)} }, { "text": "Zivilst\u00e4nde", "handler": function() {Lino.pcsw.CivilState.grid.run(null)} }, { "text": "Bearbeitungszust\u00e4nde Klienten", "handler": function() {Lino.pcsw.ClientStates.grid.run(null)} }, { "text": "eID-Kartenarten", "handler": function() {Lino.beid.BeIdCardTypes.grid.run(null)} }, { "text": "Hilfebeschl\u00fcsse", "handler": function() {Lino.aids.Grantings.grid.run(null)} }, { "text": "Einkommensbescheinigungen", "handler": function() {Lino.aids.IncomeConfirmations.grid.run(null)} }, { "text": "Kosten\u00fcbernahmescheine", "handler": function() {Lino.aids.RefundConfirmations.grid.run(null)} }, { "text": "Einfache Bescheinigungen", "handler": function() {Lino.aids.SimpleConfirmations.grid.run(null)} } ] }, "text": "\u00d6SHZ" }, { "menu": { "items": [ { "text": "Sprachkenntnisse", "handler": function() {Lino.cv.LanguageKnowledges.grid.run(null)} }, { "text": "Lehren", "handler": function() {Lino.cv.Trainings.grid.run(null)} }, { "text": "Ausbildungen und Studien", "handler": function() {Lino.cv.Studies.grid.run(null)} }, { "text": "Berufserfahrungen", "handler": function() {Lino.cv.Experiences.grid.run(null)} } ] }, "text": "Lebenslauf" }, { "menu": { "items": [ { "text": "VSEs", "handler": function() {Lino.isip.Contracts.grid.run(null)} }, { "text": "Art.60\u00a77-Konventionen", "handler": function() {Lino.jobs.Contracts.grid.run(null)} }, { "text": "Stellenanfragen", "handler": function() {Lino.jobs.Candidatures.grid.run(null)} }, { "text": "Vertragspartner", "handler": function() {Lino.isip.ContractPartners.grid.run(null)} } ] }, "text": "DSBE" }, { "menu": { "items": [ { "text": "Kurse", "handler": function() {Lino.courses.Courses.grid.run(null)} }, { "text": "Kursanfragen", "handler": function() {Lino.courses.CourseRequests.grid.run(null)} } ] }, "text": "Kurse" }, { "text": "Kompetenzen", "handler": function() {Lino.newcomers.Competences.grid.run(null)} }, { "menu": { "items": [ { "text": "IdentifyPerson-Anfragen", "handler": function() {Lino.cbss.IdentifyPersonRequests.grid.run(null)} }, { "text": "ManageAccess-Anfragen", "handler": function() {Lino.cbss.ManageAccessRequests.grid.run(null)} }, { "text": "Tx25-Anfragen", "handler": function() {Lino.cbss.RetrieveTIGroupsRequests.grid.run(null)} } ] }, "text": "ZDSS" }, { "menu": { "items": [ { "text": "Budgets", "handler": function() {Lino.debts.Budgets.grid.run(null)} }, { "text": "Eintr\u00e4ge", "handler": function() {Lino.debts.Entries.grid.run(null)} } ] }, "text": "Schuldnerberatung" }, { "menu": { "items": [ { "text": "Client Projects", "handler": function() {Lino.projects.Projects.grid.run(null)} } ] }, "text": "Client projects" }, { "menu": { "items": [ { "text": "Polls", "handler": function() {Lino.polls.Polls.grid.run(null)} }, { "text": "Questions", "handler": function() {Lino.polls.Questions.grid.run(null)} }, { "text": "Choices", "handler": function() {Lino.polls.Choices.grid.run(null)} }, { "text": "Responses", "handler": function() {Lino.polls.Responses.grid.run(null)} }, { "text": "Answer Choices", "handler": function() {Lino.polls.AnswerChoices.grid.run(null)} }, { "text": "AnswerRemarks", "handler": function() {Lino.polls.AnswerRemarks.grid.run(null)} } ] }, "text": "Polls" } ] }, "text": "Explorer" }, { "menu": { "items": [ { "text": "Info", "listeners": { "render": Lino.quicktip_renderer("Foo","Zeigt Informationen \u00fcber diese Site an.") }, "handler": function() {Lino.about.About.show.run(null,{ "record_id": -99998 })} } ] }, "text": "Site" }, { "text": "Startseite", "handler": function() {Lino.handle_home_button()} } ];
Ext.namespace('Lino.system.TextFieldTemplates')
Ext.namespace('Lino.system.SiteConfigs')
Ext.namespace('Lino.contenttypes.ContentTypes')
Ext.namespace('Lino.contenttypes.HelpTexts')
Ext.namespace('Lino.users.Users')
Ext.namespace('Lino.users.MySettings')
Ext.namespace('Lino.users.UsersOverview')
Ext.namespace('Lino.users.Authorities')
Ext.namespace('Lino.cal.RemoteCalendars')
Ext.namespace('Lino.cal.Rooms')
Ext.namespace('Lino.cal.Priorities')
Ext.namespace('Lino.cal.Calendars')
Ext.namespace('Lino.cal.Subscriptions')
Ext.namespace('Lino.cal.Tasks')
Ext.namespace('Lino.cal.MyTasks')
Ext.namespace('Lino.cal.GuestRoles')
Ext.namespace('Lino.cal.Guests')
Ext.namespace('Lino.cal.MyPresences')
Ext.namespace('Lino.cal.MyPendingPresences')
Ext.namespace('Lino.cal.MyGuests')
Ext.namespace('Lino.outbox.Recipients')
Ext.namespace('Lino.outbox.Mails')
Ext.namespace('Lino.outbox.Attachments')
Ext.namespace('Lino.cal.EventTypes')
Ext.namespace('Lino.cal.RecurrentEvents')
Ext.namespace('Lino.cal.Events')
Ext.namespace('Lino.cal.EventsByDay')
Ext.namespace('Lino.cal.OneEvent')
Ext.namespace('Lino.cal.MyEvents')
Ext.namespace('Lino.cal.MyAssignedEvents')
Ext.namespace('Lino.changes.Changes')
Ext.namespace('Lino.countries.Countries')
Ext.namespace('Lino.countries.Places')
Ext.namespace('Lino.properties.PropGroups')
Ext.namespace('Lino.properties.PropTypes')
Ext.namespace('Lino.properties.Properties')
Ext.namespace('Lino.properties.PropChoices')
Ext.namespace('Lino.contacts.CompanyTypes')
Ext.namespace('Lino.contacts.Partners')
Ext.namespace('Lino.contacts.RoleTypes')
Ext.namespace('Lino.contacts.Roles')
Ext.namespace('Lino.addresses.Addresses')
Ext.namespace('Lino.contacts.Persons')
Ext.namespace('Lino.contacts.Companies')
Ext.namespace('Lino.uploads.AreaUploads')
Ext.namespace('Lino.uploads.UploadTypes')
Ext.namespace('Lino.uploads.Uploads')
Ext.namespace('Lino.extensible.PanelCalendars')
Ext.namespace('Lino.extensible.PanelEvents')
Ext.namespace('Lino.reception.ExpectedGuests')
Ext.namespace('Lino.reception.BusyVisitors')
Ext.namespace('Lino.reception.WaitingVisitors')
Ext.namespace('Lino.reception.GoneVisitors')
Ext.namespace('Lino.reception.MyWaitingVisitors')
Ext.namespace('Lino.reception.MyBusyVisitors')
Ext.namespace('Lino.reception.MyGoneVisitors')
Ext.namespace('Lino.households.Types')
Ext.namespace('Lino.households.Members')
Ext.namespace('Lino.households.Households')
Ext.namespace('Lino.cv.LanguageKnowledges')
Ext.namespace('Lino.cv.TrainingTypes')
Ext.namespace('Lino.cv.Trainings')
Ext.namespace('Lino.cv.EducationLevels')
Ext.namespace('Lino.cv.StudyTypes')
Ext.namespace('Lino.cv.Studies')
Ext.namespace('Lino.cv.Statuses')
Ext.namespace('Lino.cv.Regimes')
Ext.namespace('Lino.cv.Durations')
Ext.namespace('Lino.cv.Sectors')
Ext.namespace('Lino.cv.Functions')
Ext.namespace('Lino.cv.Experiences')
Ext.namespace('Lino.cv.PersonProperties')
Ext.namespace('Lino.notes.NoteTypes')
Ext.namespace('Lino.notes.EventTypes')
Ext.namespace('Lino.notes.Notes')
Ext.namespace('Lino.notes.NotesByX')
Ext.namespace('Lino.isip.ContractTypes')
Ext.namespace('Lino.isip.ExamPolicies')
Ext.namespace('Lino.isip.ContractEndings')
Ext.namespace('Lino.isip.ContractPartners')
Ext.namespace('Lino.isip.Contracts')
Ext.namespace('Lino.isip.MyContracts')
Ext.namespace('Lino.jobs.Schedules')
Ext.namespace('Lino.jobs.JobProviders')
Ext.namespace('Lino.jobs.ContractTypes')
Ext.namespace('Lino.jobs.Contracts')
Ext.namespace('Lino.jobs.MyContracts')
Ext.namespace('Lino.jobs.Offers')
Ext.namespace('Lino.jobs.Candidatures')
Ext.namespace('Lino.jobs.Jobs')
Ext.namespace('Lino.jobs.JobTypes')
Ext.namespace('Lino.jobs.ContractsSearch')
Ext.namespace('Lino.pcsw.CoachingTypes')
Ext.namespace('Lino.pcsw.CoachingEndings')
Ext.namespace('Lino.pcsw.Coachings')
Ext.namespace('Lino.pcsw.Clients')
Ext.namespace('Lino.pcsw.AllClients')
Ext.namespace('Lino.pcsw.ClientsTest')
Ext.namespace('Lino.pcsw.PersonGroups')
Ext.namespace('Lino.pcsw.Activities')
Ext.namespace('Lino.pcsw.DispenseReasons')
Ext.namespace('Lino.pcsw.Dispenses')
Ext.namespace('Lino.pcsw.ExclusionTypes')
Ext.namespace('Lino.pcsw.Exclusions')
Ext.namespace('Lino.pcsw.Convictions')
Ext.namespace('Lino.pcsw.AidTypes')
Ext.namespace('Lino.pcsw.ClientContactTypes')
Ext.namespace('Lino.pcsw.ClientContacts')
Ext.namespace('Lino.reception.Clients')
Ext.namespace('Lino.languages.Languages')
Ext.namespace('Lino.accounts.Charts')
Ext.namespace('Lino.accounts.Groups')
Ext.namespace('Lino.accounts.Accounts')
Ext.namespace('Lino.badges.Badges')
Ext.namespace('Lino.badges.Awards')
Ext.namespace('Lino.sepa.Accounts')
Ext.namespace('Lino.excerpts.ExcerptTypes')
Ext.namespace('Lino.excerpts.Excerpts')
Ext.namespace('Lino.excerpts.ExcerptsByX')
Ext.namespace('Lino.boards.Boards')
Ext.namespace('Lino.boards.Members')
Ext.namespace('Lino.courses.CourseProviders')
Ext.namespace('Lino.courses.CourseContents')
Ext.namespace('Lino.courses.CourseOffers')
Ext.namespace('Lino.courses.Courses')
Ext.namespace('Lino.courses.CourseRequests')
Ext.namespace('Lino.courses.PendingCourseRequests')
Ext.namespace('Lino.integ.Clients')
Ext.namespace('Lino.integ.CoachingEndingsByUser')
Ext.namespace('Lino.integ.CoachingEndingsByType')
Ext.namespace('Lino.integ.ContractEndingsByType')
Ext.namespace('Lino.integ.JobsContractEndingsByType')
Ext.namespace('Lino.integ.ContractsPerUserAndContractType')
Ext.namespace('Lino.integ.JobsContractsPerUserAndContractType')
Ext.namespace('Lino.integ.StudyTypesAndContracts')
Ext.namespace('Lino.integ.CompaniesAndContracts')
Ext.namespace('Lino.integ.JobProvidersAndContracts')
Ext.namespace('Lino.newcomers.Brokers')
Ext.namespace('Lino.newcomers.Faculties')
Ext.namespace('Lino.newcomers.Competences')
Ext.namespace('Lino.newcomers.NewClients')
Ext.namespace('Lino.newcomers.AvailableCoaches')
Ext.namespace('Lino.cbss.Sectors')
Ext.namespace('Lino.cbss.Purposes')
Ext.namespace('Lino.cbss.IdentifyPersonRequests')
Ext.namespace('Lino.cbss.ManageAccessRequests')
Ext.namespace('Lino.cbss.RetrieveTIGroupsRequests')
Ext.namespace('Lino.humanlinks.Links')
Ext.namespace('Lino.debts.Clients')
Ext.namespace('Lino.debts.Budgets')
Ext.namespace('Lino.debts.Actors')
Ext.namespace('Lino.debts.Entries')
Ext.namespace('Lino.debts.EntriesByType')
Ext.namespace('Lino.aids.Categories')
Ext.namespace('Lino.aids.AidTypes')
Ext.namespace('Lino.aids.Grantings')
Ext.namespace('Lino.aids.MyPendingGrantings')
Ext.namespace('Lino.aids.GrantingsByX')
Ext.namespace('Lino.aids.SimpleConfirmations')
Ext.namespace('Lino.aids.IncomeConfirmations')
Ext.namespace('Lino.aids.RefundConfirmations')
Ext.namespace('Lino.projects.ProjectTypes')
Ext.namespace('Lino.projects.Projects')
Ext.namespace('Lino.polls.ChoiceSets')
Ext.namespace('Lino.polls.Choices')
Ext.namespace('Lino.polls.Polls')
Ext.namespace('Lino.polls.Questions')
Ext.namespace('Lino.polls.Responses')
Ext.namespace('Lino.polls.AnswerChoices')
Ext.namespace('Lino.polls.AnswerRemarkTable')
Ext.namespace('Lino.system.MyTextFieldTemplates')
Ext.namespace('Lino.users.AuthoritiesGiven')
Ext.namespace('Lino.users.AuthoritiesTaken')
Ext.namespace('Lino.cal.SubscriptionsByUser')
Ext.namespace('Lino.cal.SubscriptionsByCalendar')
Ext.namespace('Lino.cal.TasksByUser')
Ext.namespace('Lino.cal.TasksByProject')
Ext.namespace('Lino.cal.GuestsByEvent')
Ext.namespace('Lino.cal.GuestsByRole')
Ext.namespace('Lino.cal.GuestsByPartner')
Ext.namespace('Lino.outbox.RecipientsByMail')
Ext.namespace('Lino.outbox.MyOutbox')
Ext.namespace('Lino.outbox.MailsByUser')
Ext.namespace('Lino.outbox.MailsByProject')
Ext.namespace('Lino.outbox.SentByPartner')
Ext.namespace('Lino.outbox.AttachmentsByMail')
Ext.namespace('Lino.cal.EventsByType')
Ext.namespace('Lino.cal.EventsByRoom')
Ext.namespace('Lino.cal.EventsByProject')
Ext.namespace('Lino.cal.EventsByClient')
Ext.namespace('Lino.cal.TasksByClient')
Ext.namespace('Lino.countries.PlacesByPlace')
Ext.namespace('Lino.countries.PlacesByCountry')
Ext.namespace('Lino.properties.PropsByGroup')
Ext.namespace('Lino.properties.PropsByType')
Ext.namespace('Lino.properties.ChoicesByType')
Ext.namespace('Lino.contacts.PartnersByCity')
Ext.namespace('Lino.contacts.PartnersByCountry')
Ext.namespace('Lino.contacts.RolesByCompany')
Ext.namespace('Lino.contacts.RolesByPerson')
Ext.namespace('Lino.addresses.AddressesByPartner')
Ext.namespace('Lino.contacts.PartnersByClientContactType')
Ext.namespace('Lino.uploads.UploadsByType')
Ext.namespace('Lino.uploads.MyUploads')
Ext.namespace('Lino.uploads.UploadsByClient')
Ext.namespace('Lino.reception.AppointmentsByPartner')
Ext.namespace('Lino.households.HouseholdsByType')
Ext.namespace('Lino.households.MembersByHousehold')
Ext.namespace('Lino.households.MembersByPerson')
Ext.namespace('Lino.households.SiblingsByPerson')
Ext.namespace('Lino.households.RefundsByPerson')
Ext.namespace('Lino.cv.LanguageKnowledgesByPerson')
Ext.namespace('Lino.cv.KnowledgesByLanguage')
Ext.namespace('Lino.cv.TrainingsByCountry')
Ext.namespace('Lino.cv.TrainingsByType')
Ext.namespace('Lino.cv.TrainingsByPerson')
Ext.namespace('Lino.cv.StudyTypesByLevel')
Ext.namespace('Lino.cv.StudiesByCountry')
Ext.namespace('Lino.cv.StudiesByLevel')
Ext.namespace('Lino.cv.StudiesByPlace')
Ext.namespace('Lino.cv.StudiesByType')
Ext.namespace('Lino.cv.StudiesByPerson')
Ext.namespace('Lino.cv.FunctionsBySector')
Ext.namespace('Lino.cv.ExperiencesBySector')
Ext.namespace('Lino.cv.ExperiencesByFunction')
Ext.namespace('Lino.cv.ExperiencesByPerson')
Ext.namespace('Lino.cv.ExperiencesByStatus')
Ext.namespace('Lino.cv.ExperiencesByRegime')
Ext.namespace('Lino.cv.ExperiencesByDuration')
Ext.namespace('Lino.cv.PropsByPerson')
Ext.namespace('Lino.cv.PersonPropsByProp')
Ext.namespace('Lino.cv.ConfiguredPropsByPerson')
Ext.namespace('Lino.cv.SkillsByPerson')
Ext.namespace('Lino.cv.SoftSkillsByPerson')
Ext.namespace('Lino.cv.ObstaclesByPerson')
Ext.namespace('Lino.notes.MyNotes')
Ext.namespace('Lino.notes.NotesByType')
Ext.namespace('Lino.notes.NotesByEventType')
Ext.namespace('Lino.notes.NotesByPerson')
Ext.namespace('Lino.notes.NotesByProject')
Ext.namespace('Lino.notes.NotesByCompany')
Ext.namespace('Lino.isip.PartnersByContract')
Ext.namespace('Lino.isip.ContractsByPerson')
Ext.namespace('Lino.isip.ContractsByPolicy')
Ext.namespace('Lino.isip.ContractsByType')
Ext.namespace('Lino.isip.ContractsByEnding')
Ext.namespace('Lino.isip.ContractsByStudyType')
Ext.namespace('Lino.jobs.ContractsByPerson')
Ext.namespace('Lino.jobs.ContractsByProvider')
Ext.namespace('Lino.jobs.ContractsByPolicy')
Ext.namespace('Lino.jobs.ContractsByType')
Ext.namespace('Lino.jobs.ContractsByEnding')
Ext.namespace('Lino.jobs.ContractsByJob')
Ext.namespace('Lino.jobs.ContractsByRegime')
Ext.namespace('Lino.jobs.ContractsBySchedule')
Ext.namespace('Lino.jobs.CandidaturesByPerson')
Ext.namespace('Lino.jobs.CandidaturesBySector')
Ext.namespace('Lino.jobs.CandidaturesByFunction')
Ext.namespace('Lino.jobs.CandidaturesByJob')
Ext.namespace('Lino.jobs.CandidaturesByOffer')
Ext.namespace('Lino.jobs.ExperiencesByOffer')
Ext.namespace('Lino.jobs.JobsByProvider')
Ext.namespace('Lino.jobs.JobsByType')
Ext.namespace('Lino.jobs.JobsOverviewByType')
Ext.namespace('Lino.pcsw.CoachingsByClient')
Ext.namespace('Lino.pcsw.CoachingsByUser')
Ext.namespace('Lino.pcsw.CoachingsByEnding')
Ext.namespace('Lino.pcsw.MyCoachings')
Ext.namespace('Lino.pcsw.ClientsByNationality')
Ext.namespace('Lino.pcsw.DispensesByClient')
Ext.namespace('Lino.pcsw.ExclusionsByClient')
Ext.namespace('Lino.pcsw.ConvictionsByClient')
Ext.namespace('Lino.pcsw.ContactsByClient')
Ext.namespace('Lino.pcsw.ClientContactsByType')
Ext.namespace('Lino.reception.CoachingsByClient')
Ext.namespace('Lino.accounts.GroupsByChart')
Ext.namespace('Lino.accounts.AccountsByGroup')
Ext.namespace('Lino.badges.AwardsByHolder')
Ext.namespace('Lino.badges.AwardsByBadge')
Ext.namespace('Lino.sepa.AccountsByPartner')
Ext.namespace('Lino.sepa.AccountsByClient')
Ext.namespace('Lino.excerpts.MyExcerpts')
Ext.namespace('Lino.excerpts.ExcerptsByType')
Ext.namespace('Lino.excerpts.ExcerptsByProject')
Ext.namespace('Lino.boards.MembersByBoard')
Ext.namespace('Lino.courses.CourseOffersByProvider')
Ext.namespace('Lino.courses.CourseOffersByContent')
Ext.namespace('Lino.courses.CoursesByOffer')
Ext.namespace('Lino.courses.CourseRequestsByPerson')
Ext.namespace('Lino.courses.CourseRequestsByContent')
Ext.namespace('Lino.courses.RequestsByCourse')
Ext.namespace('Lino.courses.ParticipantsByCourse')
Ext.namespace('Lino.courses.CandidatesByCourse')
Ext.namespace('Lino.newcomers.CompetencesByUser')
Ext.namespace('Lino.newcomers.CompetencesByFaculty')
Ext.namespace('Lino.newcomers.MyCompetences')
Ext.namespace('Lino.newcomers.ClientsByFaculty')
Ext.namespace('Lino.newcomers.AvailableCoachesByClient')
Ext.namespace('Lino.cbss.MyIdentifyPersonRequests')
Ext.namespace('Lino.cbss.IdentifyRequestsByPerson')
Ext.namespace('Lino.cbss.ManageAccessRequestsByPerson')
Ext.namespace('Lino.cbss.MyManageAccessRequests')
Ext.namespace('Lino.cbss.RetrieveTIGroupsRequestsByPerson')
Ext.namespace('Lino.cbss.MyRetrieveTIGroupsRequests')
Ext.namespace('Lino.humanlinks.LinksByHuman')
Ext.namespace('Lino.debts.MyBudgets')
Ext.namespace('Lino.debts.BudgetsByPartner')
Ext.namespace('Lino.debts.ActorsByBudget')
Ext.namespace('Lino.debts.ActorsByPartner')
Ext.namespace('Lino.debts.EntriesByAccount')
Ext.namespace('Lino.debts.EntriesByBudget')
Ext.namespace('Lino.debts.ExpensesByBudget')
Ext.namespace('Lino.debts.IncomesByBudget')
Ext.namespace('Lino.debts.LiabilitiesByBudget')
Ext.namespace('Lino.debts.AssetsByBudget')
Ext.namespace('Lino.debts.DistByBudget')
Ext.namespace('Lino.aids.GrantingsByClient')
Ext.namespace('Lino.aids.GrantingsByType')
Ext.namespace('Lino.aids.SimpleConfirmationsByGranting')
Ext.namespace('Lino.aids.IncomeConfirmationsByGranting')
Ext.namespace('Lino.aids.IncomeConfirmationsByCategory')
Ext.namespace('Lino.aids.RefundConfirmationsByGranting')
Ext.namespace('Lino.projects.ProjectsByClient')
Ext.namespace('Lino.projects.ProjectsByType')
Ext.namespace('Lino.polls.ChoicesBySet')
Ext.namespace('Lino.polls.MyPolls')
Ext.namespace('Lino.polls.QuestionsByPoll')
Ext.namespace('Lino.polls.MyResponses')
Ext.namespace('Lino.polls.ResponsesByPoll')
Ext.namespace('Lino.polls.ResponsesByPartner')
Ext.namespace('Lino.polls.PollResult')
Ext.namespace('Lino.isip.DelegatedTasksByContract')
Ext.namespace('Lino.isip.EventsByContract')
Ext.namespace('Lino.contenttypes.HelpTextsByModel')
Ext.namespace('Lino.changes.ChangesByObject')
Ext.namespace('Lino.notes.NotesByOwner')
Ext.namespace('Lino.uploads.UploadsByController')
Ext.namespace('Lino.cal.TasksByController')
Ext.namespace('Lino.outbox.MailsByController')
Ext.namespace('Lino.changes.ChangesByMaster')
Ext.namespace('Lino.outbox.AttachmentsByController')
Ext.namespace('Lino.cal.EventsByController')
Ext.namespace('Lino.excerpts.ExcerptsByOwner')
Ext.namespace('Lino.about.Models')
Ext.namespace('Lino.about.FieldsByModel')
Ext.namespace('Lino.about.Inspector')
Ext.namespace('Lino.about.SourceFiles')
Ext.namespace('Lino.contenttypes.StaleControllables')
Ext.namespace('Lino.contenttypes.StaleControllablesByModel')
Ext.namespace('Lino.dedupe.SimilarPersons')
Ext.namespace('Lino.reception.ButtonsTable')
Ext.namespace('Lino.reception.CreateEventActionsByClient')
Ext.namespace('Lino.integ.UsersWithClients')
Ext.namespace('Lino.integ.CompareRequestsTable')
Ext.namespace('Lino.integ.PeriodicNumbers')
Ext.namespace('Lino.cbss.IdentifyPersonResult')
Ext.namespace('Lino.cbss.RetrieveTIGroupsResult')
Ext.namespace('Lino.debts.PrintEntriesByBudget')
Ext.namespace('Lino.debts.PrintIncomesByBudget')
Ext.namespace('Lino.debts.PrintExpensesByBudget')
Ext.namespace('Lino.debts.PrintLiabilitiesByBudget')
Ext.namespace('Lino.debts.PrintAssetsByBudget')
Ext.namespace('Lino.debts.SummaryTable')
Ext.namespace('Lino.debts.ResultByBudget')
Ext.namespace('Lino.debts.DebtsByBudget')
Ext.namespace('Lino.debts.BailiffDebtsByBudget')
Ext.namespace('Lino.aids.ConfirmationsByGranting')
Ext.namespace('Lino.polls.AnswersByResponse')
Ext.namespace('Lino.lino.Report')
Ext.namespace('Lino.about.About')
Ext.namespace('Lino.extensible.CalendarPanel')
Ext.namespace('Lino.jobs.OldJobsOverview')
Ext.namespace('Lino.jobs.JobsOverview')
Ext.namespace('Lino.integ.ActivityReport')
Ext.namespace('Lino.courses.CourseRequestStates')
Ext.namespace('Lino.sepa.AccountTypes')
Ext.namespace('Lino.cal.DurationUnits')
Ext.namespace('Lino.uploads.UploadAreas')
Ext.namespace('Lino.cal.TaskStates')
Ext.namespace('Lino.addresses.DataSources')
Ext.namespace('Lino.users.UserLevels')
Ext.namespace('Lino.cal.Weekdays')
Ext.namespace('Lino.households.MemberDependencies')
Ext.namespace('Lino.outbox.RecipientTypes')
Ext.namespace('Lino.excerpts.Shortcuts')
Ext.namespace('Lino.beid.BeIdCardTypes')
Ext.namespace('Lino.polls.PollStates')
Ext.namespace('Lino.polls.ResponseStates')
Ext.namespace('Lino.lino.YesNo')
Ext.namespace('Lino.cal.EventStates')
Ext.namespace('Lino.accounts.AccountTypes')
Ext.namespace('Lino.cal.Recurrencies')
Ext.namespace('Lino.properties.HowWell')
Ext.namespace('Lino.pcsw.ClientStates')
Ext.namespace('Lino.cv.CefLevel')
Ext.namespace('Lino.jobs.CandidatureStates')
Ext.namespace('Lino.lino.BuildMethods')
Ext.namespace('Lino.cal.EventEvents')
Ext.namespace('Lino.aids.ConfirmationTypes')
Ext.namespace('Lino.pcsw.CivilState')
Ext.namespace('Lino.households.MemberRoles')
Ext.namespace('Lino.cal.GuestStates')
Ext.namespace('Lino.properties.DoYouLike')
Ext.namespace('Lino.cbss.RequestLanguages')
Ext.namespace('Lino.addresses.AddressTypes')
Ext.namespace('Lino.aids.AidRegimes')
Ext.namespace('Lino.pcsw.RefusalReasons')
Ext.namespace('Lino.users.UserGroups')
Ext.namespace('Lino.cv.SchoolingStates')
Ext.namespace('Lino.cbss.RequestStates')
Ext.namespace('Lino.lino.ChangeTypes')
Ext.namespace('Lino.humanlinks.LinkTypes')
Ext.namespace('Lino.cal.AccessClasses')
Ext.namespace('Lino.cbss.QueryRegister')
Ext.namespace('Lino.users.UserProfiles')
Ext.namespace('Lino.lino.Genders')
Ext.namespace('Lino.pcsw.ClientEvents')
Ext.namespace('Lino.isip.ContractEvents')
Ext.namespace('Lino.cbss.ManageAction')
Ext.namespace('Lino.cv.HowWell')
Ext.namespace('Lino.countries.PlaceTypes')
Ext.namespace('Lino.pcsw.ResidenceType')
Ext.namespace('Lino.aids.ConfirmationStates')
Ext.namespace('Lino.lino.PeriodEvents')

// ChoiceLists: 
Lino.courses.CourseRequestStates = [ [ "10", "Offen" ], [ "20", "Eingetragen" ], [ "30", "Bestanden" ], [ "40", "Gut bestanden" ], [ "50", "Nicht bestanden" ], [ "60", "Abgebrochen" ], [ "70", "Inaktiv" ] ];
Lino.sepa.AccountTypes = [ [ "01", "Giro" ], [ "02", "Sparkonto" ], [ "03", "Deposits" ], [ "04", "Sonstige" ] ];
Lino.cal.DurationUnits = [ [ "s", "Sekunden" ], [ "m", "Minuten" ], [ "h", "Stunden" ], [ "D", "Tage" ], [ "W", "Wochen" ], [ "M", "Monate" ], [ "Y", "Jahre" ] ];
Lino.uploads.UploadAreas = [ [ "90", "Uploads" ] ];
Lino.cal.TaskStates = [ [ "10", "Zu tun" ], [ "20", "Begonnen" ], [ "30", "Erledigt" ], [ "50", "Storniert" ] ];
Lino.addresses.DataSources = [ [ "01", "Manuell eingegeben" ], [ "02", "Eingelesen von eID-Karte" ] ];
Lino.users.UserLevels = [ [ "10", "Gast" ], [ "30", "Benutzer" ], [ "40", "Manager" ], [ "50", "Verwalter" ] ];
Lino.cal.Weekdays = [ [ "1", "Montag" ], [ "2", "Dienstag" ], [ "3", "Mittwoch" ], [ "4", "Donnerstag" ], [ "5", "Freitag" ], [ "6", "Samstag" ], [ "7", "Sonntag" ] ];
Lino.households.MemberDependencies = [ [ "01", "Zu Lasten" ], [ "02", "Nicht zu Lasten" ], [ "03", "Lasten geteilt" ] ];
Lino.outbox.RecipientTypes = [ [ "to", "Empf\u00e4nger" ], [ "cc", "Kopie an" ], [ "bcc", "Blindkopie an" ] ];
Lino.excerpts.Shortcuts = [ [ "pcsw.Client.cvs_emitted", "Erstellte Lebensl\u00e4ufe" ] ];
Lino.beid.BeIdCardTypes = [ [ "1", "Belgischer Staatsb\u00fcrger" ], [ "6", "Kind unter 12 Jahren" ], [ "11", "A (Bescheinigung der Eintragung im Ausl\u00e4nderregister - Vor\u00fcbergehender Aufenthalt)" ], [ "12", "B (Bescheinigung der Eintragung im Ausl\u00e4nderregister)" ], [ "13", "C (Personalausweis f\u00fcr Ausl\u00e4nder)" ], [ "14", "D (Daueraufenthalt - EG)" ], [ "15", "E (Anmeldebescheinigung)" ], [ "16", "E+" ], [ "17", "F (Aufenthaltskarte f\u00fcr Familienangeh\u00f6rige eines Unionsb\u00fcrgers)" ], [ "18", "F+" ] ];
Lino.polls.PollStates = [ [ "10", "Entwurf" ], [ "20", "Ver\u00f6ffentlicht" ], [ "30", "Closed" ] ];
Lino.polls.ResponseStates = [ [ "10", "Entwurf" ], [ "20", "Registriert" ] ];
Lino.lino.YesNo = [ [ "y", "Ja" ], [ "n", "Nein" ] ];
Lino.cal.EventStates = [ [ "10", "Vorgeschlagen" ], [ "20", "Entwurf" ], [ "50", "Stattgefunden" ], [ "70", "Storniert" ], [ "75", "Omitted" ], [ "40", "Notified" ] ];
Lino.accounts.AccountTypes = [ [ "A", "Verm\u00f6gen" ], [ "L", "Verpflichtungen" ], [ "I", "Eink\u00fcnfte" ], [ "E", "Ausgaben" ], [ "C", "Kapital" ], [ "B", "Bankkonten" ] ];
Lino.cal.Recurrencies = [ [ "O", "einmalig" ], [ "D", "t\u00e4glich" ], [ "W", "w\u00f6chentlich" ], [ "M", "monatlich" ], [ "Y", "j\u00e4hrlich" ], [ "P", "pro Wochentag" ] ];
Lino.properties.HowWell = [ [ "0", "gar nicht" ], [ "1", "ein bisschen" ], [ "2", "mittelm\u00e4\u00dfig" ], [ "3", "gut" ], [ "4", "sehr gut" ] ];
Lino.pcsw.ClientStates = [ [ "10", "Neuantrag" ], [ "20", "Abgelehnt" ], [ "30", "Begleitet" ], [ "50", "Ehemalig" ] ];
Lino.cv.CefLevel = [ [ "A1", "A1 (Elementare Sprachverwendung)" ], [ "A2", "A2 (Elementare Sprachverwendung)" ], [ "A2+", "A2+ (Elementare Sprachverwendung)" ], [ "B1", "B1 (Selbstst\u00e4ndige Sprachverwendung)" ], [ "B2", "B2 (Selbstst\u00e4ndige Sprachverwendung)" ], [ "B2+", "B2+ (Selbstst\u00e4ndige Sprachverwendung)" ], [ "C1", "C1 (Exzellente Sprachverwendung)" ], [ "C2", "C2 (Exzellente Sprachverwendung)" ], [ "C2+", "C2+ (Exzellente Sprachverwendung)" ] ];
Lino.jobs.CandidatureStates = [ [ "10", "Aktiv" ], [ "20", "Probezeit" ], [ "25", "Probezeit ohne Erfolg" ], [ "27", "Arbeitet" ], [ "30", "Inaktiv" ] ];
Lino.lino.BuildMethods = [ [ "appyodt", "AppyOdtBuildMethod" ], [ "appydoc", "AppyDocBuildMethod" ], [ "appypdf", "AppyPdfBuildMethod" ], [ "appyrtf", "AppyRtfBuildMethod" ], [ "latex", "LatexBuildMethod" ], [ "pisa", "PisaBuildMethod" ], [ "rtf", "RtfBuildMethod" ] ];
Lino.cal.EventEvents = [ [ "10", "Okay" ], [ "20", "Pending" ] ];
Lino.aids.ConfirmationTypes = [ [ "aids.SimpleConfirmation", "Simple confirmation (aids.SimpleConfirmation)" ], [ "aids.IncomeConfirmation", "Income confirmation (aids.IncomeConfirmation)" ], [ "aids.RefundConfirmation", "Refund confirmation (aids.RefundConfirmation)" ] ];
Lino.pcsw.CivilState = [ [ "10", "Ledig" ], [ "13", "Ledig zusammenwohnend" ], [ "18", "Ledig mit Kind" ], [ "20", "Ehepartner" ], [ "21", "Verheirated (allein lebend)" ], [ "22", "Verheirated (mit anderem Partner lebend)" ], [ "30", "Verwitwet" ], [ "33", "Verwitwet (zusammenwohnend)" ], [ "40", "Geschieden" ], [ "50", "Getrennt von Tisch und Bett" ] ];
Lino.households.MemberRoles = [ [ "01", "Vorstand" ], [ "02", "Ehepartner" ], [ "03", "Partner" ], [ "04", "Mitbewohner" ], [ "05", "Kind" ], [ "07", "Adoptivkind" ], [ "06", "Verwandt" ] ];
Lino.cal.GuestStates = [ [ "10", "Eingeladen" ], [ "20", "Zugesagt" ], [ "30", "Abgesagt" ], [ "40", "Anwesend" ], [ "50", "Abwesend" ], [ "60", "Entschuldigt" ], [ "44", "Wartet" ], [ "45", "Besch\u00e4ftigt" ], [ "46", "Gegangen" ] ];
Lino.properties.DoYouLike = [ [ "0", "blo\u00df nicht" ], [ "1", "eher nicht" ], [ "2", "normal" ], [ "3", "gerne" ], [ "4", "sehr gerne" ] ];
Lino.cbss.RequestLanguages = [ [ "nl", "Niederl\u00e4ndisch" ], [ "fr", "Franz\u00f6sisch" ], [ "de", "Deutsch" ] ];
Lino.addresses.AddressTypes = [ [ "01", "Offizielle Adresse" ], [ "02", "Ungepr\u00fcfte Adresse" ], [ "03", "Deklarierte Addresse" ], [ "04", "Referenzadresse" ] ];
Lino.aids.AidRegimes = [ [ "10", "Finanzielle Hilfen" ], [ "20", "Gesundheitshilfen" ], [ "30", "Sonstige Hilfen" ] ];
Lino.pcsw.RefusalReasons = [ [ "10", "Information (keine Begleitung erforderlich)" ], [ "20", "\u00d6SHZ ist nicht zust\u00e4ndig" ], [ "30", "Antragsteller ist nicht zur\u00fcck gekommen" ] ];
Lino.users.UserGroups = [ [ "office", "office (B\u00fcro)" ], [ "reception", "reception (Empfang)" ], [ "beid", "beid (Beid)" ], [ "coaching", "coaching (Begleitung)" ], [ "accounts", "accounts (Buchhaltung)" ], [ "courses", "courses (Kurse)" ], [ "integ", "integ (DSBE)" ], [ "newcomers", "newcomers (Neuantr\u00e4ge)" ], [ "cbss", "cbss (ZDSS)" ], [ "debts", "debts (Schuldnerberatung)" ], [ "polls", "polls (Polls)" ] ];
Lino.cv.SchoolingStates = [ [ "0", "Erfolgreich abgeschlossen" ], [ "1", "Abbruch" ], [ "2", "in Gang" ] ];
Lino.cbss.RequestStates = [ [ "10", "Versendet" ], [ "20", "Fehlgeschlagen" ], [ "25", "Validiert" ], [ "30", "OK" ], [ "40", "Warnungen" ], [ "50", "Fehlermeldungen" ] ];
Lino.lino.ChangeTypes = [ [ "C", "Erstellen" ], [ "U", "Aktualisierung" ], [ "D", "L\u00f6schen" ], [ "R", "Remove child" ], [ "A", "Add child" ], [ "M", "Fusionieren" ] ];
Lino.humanlinks.LinkTypes = [ [ "01", "Sohn (Tochter)" ], [ "02", "Adoptivsohn (Adoptivtochter)" ], [ "03", "Enkel (Enkelin)" ], [ "05", "Ehemann (Ehefrau)" ], [ "06", "Freund (Freundin)" ], [ "07", "Partner (Partnerin)" ], [ "08", "Stiefsohn (Stieftochter)" ], [ "10", "Bruder (Schwester)" ], [ "11", "Vetter (Kusine)" ], [ "12", "Neffe (Nichte)" ], [ "80", "Verwandter (Verwandte)" ], [ "90", "Sonstiger (Sonstige)" ] ];
Lino.cal.AccessClasses = [ [ "10", "Privat" ], [ "20", "halb \u00f6ffentlich (\"Besch\u00e4ftigt\")" ], [ "30", "\u00d6ffentlich" ] ];
Lino.cbss.QueryRegister = [ [ "1", "Prim\u00e4r" ], [ "2", "Sekund\u00e4r" ], [ "3", "Alle" ] ];
Lino.users.UserProfiles = [ [ "000", "000 (Anonym)" ], [ "100", "100 (Begleiter im DSBE)" ], [ "110", "110 (Integrations-Assistent (Manager))" ], [ "200", "200 (Berater Neuantr\u00e4ge)" ], [ "210", "210 (Empfangsschalter)" ], [ "300", "300 (Schuldenberater)" ], [ "400", "400 (Sozi)" ], [ "410", "410 (Social agent (Manager))" ], [ "900", "900 (Verwalter)" ] ];
Lino.lino.Genders = [ [ "M", "M\u00e4nnlich" ], [ "F", "Weiblich" ] ];
Lino.pcsw.ClientEvents = [ [ "10", "Aktiv" ], [ "20", "VSE" ], [ "21", "Art.60\u00a77-Konvention" ], [ "22", "Dispenz" ], [ "30", "AG-Sperre" ], [ "31", "AG-Sperre" ], [ "40", "Notiz" ], [ "50", "Erstellt" ], [ "60", "Bearbeitet" ] ];
Lino.isip.ContractEvents = [ [ "10", "Begonnen" ], [ "20", "Aktiv" ], [ "30", "Beendet" ], [ "40", "Unterschrieben" ] ];
Lino.cbss.ManageAction = [ [ "1", "Registrieren" ], [ "2", "Austragen" ], [ "3", "Auflisten" ] ];
Lino.cv.HowWell = [ [ "0", "gar nicht" ], [ "1", "ein bisschen" ], [ "2", "mittelm\u00e4\u00dfig" ], [ "3", "gut" ], [ "4", "sehr gut" ] ];
Lino.countries.PlaceTypes = [ [ "10", "Bundesland" ], [ "11", "Division" ], [ "12", "Region" ], [ "13", "Gemeinschaft" ], [ "14", "Territorium" ], [ "20", "Regierungsbezirk" ], [ "21", "Provinz" ], [ "22", "Grafschaft" ], [ "23", "Unterregion" ], [ "24", "Departement" ], [ "25", "Arrondissement" ], [ "26", "Pr\u00e4fektur" ], [ "27", "Distrikt" ], [ "28", "Sektor" ], [ "50", "Stadt" ], [ "51", "Kleinstadt" ], [ "52", "Gemeinde" ], [ "54", "Pfarre" ], [ "55", "Stadtteil" ], [ "56", "Viertel" ], [ "61", "Ortschaft" ], [ "62", "Kleine Ortschaft" ], [ "70", "Dorf" ] ];
Lino.pcsw.ResidenceType = [ [ "1", "Bev\u00f6lkerungsregister" ], [ "2", "Fremdenregister" ], [ "3", "Warteregister" ] ];
Lino.aids.ConfirmationStates = [ [ "01", "Unbest\u00e4tigt" ], [ "02", "Best\u00e4tigt" ] ];
Lino.lino.PeriodEvents = [ [ "10", "Begonnen" ], [ "20", "Aktiv" ], [ "30", "Beendet" ] ];

Lino.jobs.JobsOverviewByType.ParamsPanel = Ext.extend(Ext.form.FormPanel,{
  autoHeight: true,
  frame: true,
  layoutConfig: { "align": "stretchmax" },
  hideCheckBoxLabels: true,
  autoScroll: false,
  labelWidth: 216,
  border: false,
  bodyBorder: false,
  labelAlign: "top",
  layout: 'hbox',
  autoHeight: true,
  initComponent : function() {
    var contract_type4998 = new Lino.TwinCombo({ "preferred_width": 20, "autoHeight": true, "fieldLabel": "Art.60\u00a77-Konventionsart", "name": "contract_type", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.jobs.ContractTypes.detail,Lino.jobs.ContractTypes.insert)}, "hiddenName": "contract_typeHidden", "selectOnFocus": true, "emptyText": "Art.60\u00a77-Konventionsart ausw\u00e4hlen...", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/jobs/JobsOverviewByType/contract_type", "method": "GET" }) }) });
    var date4999 = new Lino.DateField({ "selectOnFocus": true, "autoHeight": true, "fieldLabel": "Datum", "anchor": "-20", "name": "date" });
    this.items = [ { "flex": 60, "autoHeight": true, "layout": "form", "xtype": "panel", "items": contract_type4998, "labelAlign": "top" }, { "flex": 39, "autoHeight": true, "layout": "form", "xtype": "panel", "items": date4999, "labelAlign": "top" } ];
    this.fields = [ contract_type4998, date4999 ];
    Lino.jobs.JobsOverviewByType.ParamsPanel.superclass.initComponent.call(this);
  }
});


Lino.cal.Tasks.ParamsPanel = Ext.extend(Ext.form.FormPanel,{
  autoScroll: false,
  border: false,
  hideCheckBoxLabels: true,
  frame: true,
  bodyBorder: false,
  labelAlign: "top",
  layout: 'form',
  autoHeight: true,
  initComponent : function() {
    var start_date536 = new Lino.DateField({ "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Periode vom</span>", "name": "start_date", "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Periode vom","Start date of observed period") }, "value": null, "anchor": "-20" });
    var end_date537 = new Lino.DateField({ "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">bis</span>", "name": "end_date", "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("bis","End date of observed period") }, "value": null, "anchor": "-20" });
    var user538 = new Lino.TwinCombo({ "preferred_width": 15, "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Verwaltet durch</span>", "name": "user", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.users.Users.detail,Lino.users.Users.insert)}, "hiddenName": "userHidden", "listeners": { "render": Lino.quicktip_renderer("Verwaltet durch","Only rows managed by this user.") }, "selectOnFocus": true, "emptyText": "Benutzer ausw\u00e4hlen...", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/Tasks/user", "method": "GET" }) }) });
    var state539 = new Lino.ChoicesFieldElement({ "autoHeight": true, "forceSelection": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Zustand</span>", "name": "state", "hiddenName": "stateHidden", "listeners": { "render": Lino.quicktip_renderer("Zustand","Only rows having this state.") }, "selectOnFocus": true, "anchor": "-20", "store": [['','<br>']].concat(Lino.cal.TaskStates) });
    var project540 = new Lino.TwinCombo({ "preferred_width": 20, "autoHeight": true, "fieldLabel": "Klient", "name": "project", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.pcsw.Clients.detail,Lino.pcsw.Clients.insert)}, "hiddenName": "projectHidden", "selectOnFocus": true, "emptyText": "Klient ausw\u00e4hlen...", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/Tasks/project", "method": "GET" }) }) });
    var main_1_panel541 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 144, "hideCheckBoxLabels": true, "items": [ { "flex": 16, "autoHeight": true, "layout": "form", "xtype": "panel", "items": start_date536, "labelAlign": "top" }, { "flex": 16, "autoHeight": true, "layout": "form", "xtype": "panel", "items": end_date537, "labelAlign": "top" }, { "flex": 25, "autoHeight": true, "layout": "form", "xtype": "panel", "items": user538, "labelAlign": "top" }, { "flex": 15, "autoHeight": true, "layout": "form", "xtype": "panel", "items": state539, "labelAlign": "top" }, { "flex": 25, "autoHeight": true, "layout": "form", "xtype": "panel", "items": project540, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    this.items = [ main_1_panel541 ];
    this.fields = [ start_date536, end_date537, user538, state539, project540 ];
    Lino.cal.Tasks.ParamsPanel.superclass.initComponent.call(this);
  }
});


Lino.excerpts.Excerpts.ParamsPanel = Ext.extend(Ext.form.FormPanel,{
  autoScroll: false,
  autoHeight: true,
  border: false,
  hideCheckBoxLabels: true,
  frame: true,
  bodyBorder: false,
  labelAlign: "top",
  layout: 'form',
  autoHeight: true,
  initComponent : function() {
    var start_date4046 = new Lino.DateField({ "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Periode vom</span>", "name": "start_date", "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Periode vom","Start date of observed period") }, "value": null, "anchor": "-20" });
    var end_date4047 = new Lino.DateField({ "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">bis</span>", "name": "end_date", "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("bis","End date of observed period") }, "value": null, "anchor": "-20" });
    var pcertifying4048 = new Lino.ChoicesFieldElement({ "autoHeight": true, "forceSelection": true, "fieldLabel": "Certifying excerpts", "name": "pcertifying", "hiddenName": "pcertifyingHidden", "selectOnFocus": true, "anchor": "-20", "store": [['','<br>']].concat(Lino.lino.YesNo) });
    var main_1_panel4049 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 39, "autoHeight": true, "layout": "form", "xtype": "panel", "items": start_date4046, "labelAlign": "top" }, { "flex": 39, "autoHeight": true, "layout": "form", "xtype": "panel", "items": end_date4047, "labelAlign": "top" }, { "flex": 21, "autoHeight": true, "layout": "form", "xtype": "panel", "items": pcertifying4048, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 180, "border": false, "anchor": "-20", "labelAlign": "top" });
    var puser4053 = new Lino.TwinCombo({ "preferred_width": 15, "autoHeight": true, "fieldLabel": "Benutzer", "name": "puser", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.users.Users.detail,Lino.users.Users.insert)}, "hiddenName": "puserHidden", "selectOnFocus": true, "emptyText": "Benutzer ausw\u00e4hlen...", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/excerpts/Excerpts/puser", "method": "GET" }) }) });
    var pexcerpt_type4054 = new Lino.TwinCombo({ "autoHeight": true, "fieldLabel": "Auszugsart", "name": "pexcerpt_type", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.excerpts.ExcerptTypes.detail,Lino.excerpts.ExcerptTypes.insert)}, "emptyText": "Auszugsart ausw\u00e4hlen...", "selectOnFocus": true, "hiddenName": "pexcerpt_typeHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/excerpts/Excerpts/pexcerpt_type", "method": "GET" }) }) });
    var main_2_panel4055 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": puser4053, "labelAlign": "top" }, { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": pexcerpt_type4054, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 99, "border": false, "anchor": "-20", "labelAlign": "top" });
    this.items = [ main_1_panel4049, main_2_panel4055 ];
    this.fields = [ start_date4046, end_date4047, pcertifying4048, puser4053, pexcerpt_type4054 ];
    Lino.excerpts.Excerpts.ParamsPanel.superclass.initComponent.call(this);
  }
});


Lino.aids.SimpleConfirmations.ParamsPanel = Ext.extend(Ext.form.FormPanel,{
  autoHeight: true,
  frame: true,
  layoutConfig: { "align": "stretchmax" },
  hideCheckBoxLabels: true,
  autoScroll: false,
  labelWidth: 135,
  border: false,
  bodyBorder: false,
  labelAlign: "top",
  layout: 'hbox',
  autoHeight: true,
  initComponent : function() {
    var board4781 = new Lino.TwinCombo({ "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Gremium</span>", "name": "board", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.boards.Boards.detail,Lino.boards.Boards.insert)}, "emptyText": "Gremium ausw\u00e4hlen...", "listeners": { "render": Lino.quicktip_renderer("Gremium","Only rows decided by this board.") }, "selectOnFocus": true, "hiddenName": "boardHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/aids/SimpleConfirmations/board", "method": "GET" }) }) });
    var signer4782 = new Lino.TwinCombo({ "preferred_width": 15, "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Unterschreiber</span>", "name": "signer", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.users.Users.detail,Lino.users.Users.insert)}, "hiddenName": "signerHidden", "listeners": { "render": Lino.quicktip_renderer("Unterschreiber","Only rows confirmed (or to be confirmed) by this user.") }, "selectOnFocus": true, "emptyText": "Benutzer ausw\u00e4hlen...", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/aids/SimpleConfirmations/signer", "method": "GET" }) }) });
    var user4783 = new Lino.TwinCombo({ "preferred_width": 15, "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Autor</span>", "name": "user", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.users.Users.detail,Lino.users.Users.insert)}, "hiddenName": "userHidden", "listeners": { "render": Lino.quicktip_renderer("Autor","Only rows created by this user.") }, "selectOnFocus": true, "emptyText": "Benutzer ausw\u00e4hlen...", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/aids/SimpleConfirmations/user", "method": "GET" }) }) });
    var aid_type4784 = new Lino.TwinCombo({ "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Hilfeart</span>", "name": "aid_type", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.aids.AidTypes.detail,Lino.aids.AidTypes.insert)}, "emptyText": "Hilfeart ausw\u00e4hlen...", "listeners": { "render": Lino.quicktip_renderer("Hilfeart","Only confirmations about this aid type.") }, "selectOnFocus": true, "hiddenName": "aid_typeHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/aids/SimpleConfirmations/aid_type", "method": "GET" }) }) });
    var state4785 = new Lino.ChoicesFieldElement({ "autoHeight": true, "forceSelection": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Zustand</span>", "name": "state", "hiddenName": "stateHidden", "listeners": { "render": Lino.quicktip_renderer("Zustand","Only rows having this state.") }, "selectOnFocus": true, "anchor": "-20", "store": [['','<br>']].concat(Lino.aids.ConfirmationStates) });
    this.items = [ { "flex": 21, "autoHeight": true, "layout": "form", "xtype": "panel", "items": board4781, "labelAlign": "top" }, { "flex": 21, "autoHeight": true, "layout": "form", "xtype": "panel", "items": signer4782, "labelAlign": "top" }, { "flex": 21, "autoHeight": true, "layout": "form", "xtype": "panel", "items": user4783, "labelAlign": "top" }, { "flex": 21, "autoHeight": true, "layout": "form", "xtype": "panel", "items": aid_type4784, "labelAlign": "top" }, { "flex": 14, "autoHeight": true, "layout": "form", "xtype": "panel", "items": state4785, "labelAlign": "top" } ];
    this.fields = [ board4781, signer4782, user4783, aid_type4784, state4785 ];
    Lino.aids.SimpleConfirmations.ParamsPanel.superclass.initComponent.call(this);
  }
});


Lino.integ.ActivityReport.ParamsPanel = Ext.extend(Ext.form.FormPanel,{
  autoHeight: true,
  frame: true,
  layoutConfig: { "align": "stretchmax" },
  hideCheckBoxLabels: true,
  autoScroll: false,
  labelWidth: 108,
  border: false,
  bodyBorder: false,
  labelAlign: "top",
  layout: 'hbox',
  autoHeight: true,
  initComponent : function() {
    var start_date5112 = new Lino.DateField({ "autoHeight": true, "fieldLabel": "Periode vom", "name": "start_date", "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var end_date5113 = new Lino.DateField({ "autoHeight": true, "fieldLabel": "bis", "name": "end_date", "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var include_jobs5114 = new Ext.form.Checkbox({ "boxLabel": "Art.60\u00a77", "autoHeight": true, "hideLabel": true, "name": "include_jobs", "selectOnFocus": true, "anchor": "-20" });
    var include_isip5115 = new Ext.form.Checkbox({ "boxLabel": "VSE", "autoHeight": true, "hideLabel": true, "name": "include_isip", "selectOnFocus": true, "anchor": "-20" });
    this.items = [ { "flex": 28, "autoHeight": true, "layout": "form", "xtype": "panel", "items": start_date5112, "labelAlign": "top" }, { "flex": 28, "autoHeight": true, "layout": "form", "xtype": "panel", "items": end_date5113, "labelAlign": "top" }, { "flex": 21, "autoHeight": true, "layout": "form", "xtype": "panel", "items": include_jobs5114, "labelAlign": "top" }, { "flex": 21, "autoHeight": true, "layout": "form", "xtype": "panel", "items": include_isip5115, "labelAlign": "top" } ];
    this.fields = [ start_date5112, end_date5113, include_jobs5114, include_isip5115 ];
    Lino.integ.ActivityReport.ParamsPanel.superclass.initComponent.call(this);
  }
});


Lino.cal.Events.ParamsPanel = Ext.extend(Ext.form.FormPanel,{
  autoScroll: false,
  autoHeight: true,
  border: false,
  hideCheckBoxLabels: true,
  frame: true,
  bodyBorder: false,
  labelAlign: "top",
  layout: 'form',
  autoHeight: true,
  initComponent : function() {
    var start_date928 = new Lino.DateField({ "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Periode vom</span>", "name": "start_date", "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Periode vom","Start date of observed period") }, "value": null, "anchor": "-20" });
    var end_date929 = new Lino.DateField({ "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">bis</span>", "name": "end_date", "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("bis","End date of observed period") }, "value": null, "anchor": "-20" });
    var observed_event930 = new Lino.ChoicesFieldElement({ "autoHeight": true, "forceSelection": true, "fieldLabel": "Beobachtungskriterium", "name": "observed_event", "hiddenName": "observed_eventHidden", "selectOnFocus": true, "anchor": "-20", "store": [['','<br>']].concat(Lino.cal.EventEvents) });
    var state931 = new Lino.ChoicesFieldElement({ "autoHeight": true, "forceSelection": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Zustand</span>", "name": "state", "hiddenName": "stateHidden", "listeners": { "render": Lino.quicktip_renderer("Zustand","Only rows having this state.") }, "selectOnFocus": true, "anchor": "-20", "store": [['','<br>']].concat(Lino.cal.EventStates) });
    var main_1_panel932 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 26, "autoHeight": true, "layout": "form", "xtype": "panel", "items": start_date928, "labelAlign": "top" }, { "flex": 26, "autoHeight": true, "layout": "form", "xtype": "panel", "items": end_date929, "labelAlign": "top" }, { "flex": 20, "autoHeight": true, "layout": "form", "xtype": "panel", "items": observed_event930, "labelAlign": "top" }, { "flex": 26, "autoHeight": true, "layout": "form", "xtype": "panel", "items": state931, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 198, "border": false, "anchor": "-20", "labelAlign": "top" });
    var user937 = new Lino.TwinCombo({ "preferred_width": 15, "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Verwaltet durch</span>", "name": "user", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.users.Users.detail,Lino.users.Users.insert)}, "hiddenName": "userHidden", "listeners": { "render": Lino.quicktip_renderer("Verwaltet durch","Only rows managed by this user.") }, "selectOnFocus": true, "emptyText": "Benutzer ausw\u00e4hlen...", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/Events/user", "method": "GET" }) }) });
    var assigned_to938 = new Lino.TwinCombo({ "preferred_width": 15, "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Zugewiesen zu</span>", "name": "assigned_to", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.users.Users.detail,Lino.users.Users.insert)}, "hiddenName": "assigned_toHidden", "listeners": { "render": Lino.quicktip_renderer("Zugewiesen zu","Only events assigned to this user.") }, "selectOnFocus": true, "emptyText": "Benutzer ausw\u00e4hlen...", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/Events/assigned_to", "method": "GET" }) }) });
    var project939 = new Lino.TwinCombo({ "preferred_width": 20, "autoHeight": true, "fieldLabel": "Klient", "name": "project", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.pcsw.Clients.detail,Lino.pcsw.Clients.insert)}, "hiddenName": "projectHidden", "selectOnFocus": true, "emptyText": "Klient ausw\u00e4hlen...", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/Events/project", "method": "GET" }) }) });
    var event_type940 = new Lino.TwinCombo({ "autoHeight": true, "fieldLabel": "Ereignisart", "name": "event_type", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.cal.EventTypes.detail,Lino.cal.EventTypes.insert)}, "emptyText": "Ereignisart ausw\u00e4hlen...", "selectOnFocus": true, "hiddenName": "event_typeHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/Events/event_type", "method": "GET" }) }) });
    var room941 = new Lino.TwinCombo({ "autoHeight": true, "fieldLabel": "Raum", "name": "room", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.cal.Rooms.detail,Lino.cal.Rooms.insert)}, "emptyText": "Raum ausw\u00e4hlen...", "selectOnFocus": true, "hiddenName": "roomHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/Events/room", "method": "GET" }) }) });
    var show_appointments942 = new Lino.ChoicesFieldElement({ "autoHeight": true, "forceSelection": true, "fieldLabel": "Termine", "name": "show_appointments", "hiddenName": "show_appointmentsHidden", "selectOnFocus": true, "anchor": "-20", "store": [['','<br>']].concat(Lino.lino.YesNo) });
    var main_2_panel943 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 18, "autoHeight": true, "layout": "form", "xtype": "panel", "items": user937, "labelAlign": "top" }, { "flex": 18, "autoHeight": true, "layout": "form", "xtype": "panel", "items": assigned_to938, "labelAlign": "top" }, { "flex": 18, "autoHeight": true, "layout": "form", "xtype": "panel", "items": project939, "labelAlign": "top" }, { "flex": 18, "autoHeight": true, "layout": "form", "xtype": "panel", "items": event_type940, "labelAlign": "top" }, { "flex": 18, "autoHeight": true, "layout": "form", "xtype": "panel", "items": room941, "labelAlign": "top" }, { "flex": 6, "autoHeight": true, "layout": "form", "xtype": "panel", "items": show_appointments942, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 144, "border": false, "anchor": "-20", "labelAlign": "top" });
    this.items = [ main_1_panel932, main_2_panel943 ];
    this.fields = [ start_date928, end_date929, observed_event930, state931, user937, assigned_to938, project939, event_type940, room941, show_appointments942 ];
    Lino.cal.Events.ParamsPanel.superclass.initComponent.call(this);
  }
});


Lino.contacts.Persons.ParamsPanel = Ext.extend(Ext.form.FormPanel,{
  autoScroll: false,
  border: false,
  hideCheckBoxLabels: true,
  frame: true,
  bodyBorder: false,
  labelAlign: "top",
  layout: 'form',
  autoHeight: true,
  initComponent : function() {
    var gender1809 = new Lino.ChoicesFieldElement({ "autoHeight": true, "forceSelection": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Geschlecht</span>", "name": "gender", "hiddenName": "genderHidden", "listeners": { "render": Lino.quicktip_renderer("Geschlecht","Show only persons with the given gender.") }, "selectOnFocus": true, "anchor": "-20", "store": [['','<br>']].concat(Lino.lino.Genders) });
    var also_obsolete1810 = new Ext.form.Checkbox({ "autoHeight": true, "hideLabel": true, "checked": false, "name": "also_obsolete", "listeners": { "render": Lino.quicktip_renderer("Auch veraltete Daten","Show also obsolete records.") }, "boxLabel": "Auch veraltete Daten", "selectOnFocus": true, "anchor": "-20" });
    var main_1_panel1811 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 189, "hideCheckBoxLabels": true, "items": [ { "flex": 47, "autoHeight": true, "layout": "form", "xtype": "panel", "items": gender1809, "labelAlign": "top" }, { "flex": 52, "autoHeight": true, "layout": "form", "xtype": "panel", "items": also_obsolete1810, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    this.items = [ main_1_panel1811 ];
    this.fields = [ gender1809, also_obsolete1810 ];
    Lino.contacts.Persons.ParamsPanel.superclass.initComponent.call(this);
  }
});


Lino.pcsw.Clients.ParamsPanel = Ext.extend(Ext.form.FormPanel,{
  autoScroll: false,
  autoHeight: true,
  border: false,
  hideCheckBoxLabels: true,
  frame: true,
  bodyBorder: false,
  labelAlign: "top",
  layout: 'form',
  autoHeight: true,
  initComponent : function() {
    var aged_from3733 = new Ext.form.NumberField({ "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Alter von</span>", "name": "aged_from", "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Alter von","Nur Klienten, die mindestens so alt sind.") }, "anchor": "-20" });
    var aged_to3734 = new Ext.form.NumberField({ "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Alter bis</span>", "name": "aged_to", "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Alter bis","Nur Klienten, die h\u00f6chstens so alt sind.") }, "anchor": "-20" });
    var gender3735 = new Lino.ChoicesFieldElement({ "autoHeight": true, "forceSelection": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Geschlecht</span>", "name": "gender", "hiddenName": "genderHidden", "listeners": { "render": Lino.quicktip_renderer("Geschlecht","Show only persons with the given gender.") }, "selectOnFocus": true, "anchor": "-20", "store": [['','<br>']].concat(Lino.lino.Genders) });
    var nationality3736 = new Lino.TwinCombo({ "autoHeight": true, "fieldLabel": "Staatsangeh\u00f6rigkeit", "name": "nationality", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.countries.Countries.detail,Lino.countries.Countries.insert)}, "emptyText": "Land ausw\u00e4hlen...", "selectOnFocus": true, "hiddenName": "nationalityHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/pcsw/Clients/nationality", "method": "GET" }) }) });
    var also_obsolete3737 = new Ext.form.Checkbox({ "autoHeight": true, "hideLabel": true, "checked": false, "name": "also_obsolete", "listeners": { "render": Lino.quicktip_renderer("Auch veraltete Daten","Show also obsolete records.") }, "boxLabel": "Auch veraltete Daten", "selectOnFocus": true, "anchor": "-20" });
    var main_1_panel3738 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 10, "autoHeight": true, "layout": "form", "xtype": "panel", "items": aged_from3733, "labelAlign": "top" }, { "flex": 10, "autoHeight": true, "layout": "form", "xtype": "panel", "items": aged_to3734, "labelAlign": "top" }, { "flex": 18, "autoHeight": true, "layout": "form", "xtype": "panel", "items": gender3735, "labelAlign": "top" }, { "flex": 40, "autoHeight": true, "layout": "form", "xtype": "panel", "items": nationality3736, "labelAlign": "top" }, { "flex": 20, "autoHeight": true, "layout": "form", "xtype": "panel", "items": also_obsolete3737, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 189, "border": false, "anchor": "-20", "labelAlign": "top" });
    var client_state3744 = new Lino.ChoicesFieldElement({ "autoHeight": true, "forceSelection": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Zustand</span>", "name": "client_state", "hiddenName": "client_stateHidden", "listeners": { "render": Lino.quicktip_renderer("Zustand","Nur Klienten mit diesem Status (Aktenzustand).") }, "selectOnFocus": true, "anchor": "-20", "store": [['','<br>']].concat(Lino.pcsw.ClientStates) });
    var coached_by3745 = new Lino.TwinCombo({ "preferred_width": 15, "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Begleitet durch</span>", "name": "coached_by", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.users.Users.detail,Lino.users.Users.insert)}, "hiddenName": "coached_byHidden", "listeners": { "render": Lino.quicktip_renderer("Begleitet durch","Nur Klienten, die eine Begleitung mit diesem Benutzer haben.") }, "selectOnFocus": true, "emptyText": "Benutzer ausw\u00e4hlen...", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/pcsw/Clients/coached_by", "method": "GET" }) }) });
    var and_coached_by3746 = new Lino.TwinCombo({ "preferred_width": 15, "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">und durch</span>", "name": "and_coached_by", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.users.Users.detail,Lino.users.Users.insert)}, "hiddenName": "and_coached_byHidden", "listeners": { "render": Lino.quicktip_renderer("und durch","Nur Klienten, die auch mit diesem Benutzer eine Begleitung haben.") }, "selectOnFocus": true, "emptyText": "Benutzer ausw\u00e4hlen...", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/pcsw/Clients/and_coached_by", "method": "GET" }) }) });
    var start_date3747 = new Lino.DateField({ "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Periode vom</span>", "name": "start_date", "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Periode vom","Start date of observed period") }, "value": null, "anchor": "-20" });
    var end_date3748 = new Lino.DateField({ "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">bis</span>", "name": "end_date", "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("bis","End date of observed period") }, "value": null, "anchor": "-20" });
    var observed_event3749 = new Lino.ChoicesFieldElement({ "autoHeight": true, "forceSelection": true, "fieldLabel": "Beobachtungskriterium", "name": "observed_event", "hiddenName": "observed_eventHidden", "selectOnFocus": true, "anchor": "-20", "store": [['','<br>']].concat(Lino.pcsw.ClientEvents) });
    var only_primary3750 = new Ext.form.Checkbox({ "autoHeight": true, "hideLabel": true, "checked": false, "name": "only_primary", "listeners": { "render": Lino.quicktip_renderer("Nur prim\u00e4re Begleitungen","Nur Klienten, die eine effektive <b>prim\u00e4re</b> Begleitung haben.") }, "boxLabel": "Nur prim\u00e4re Begleitungen", "selectOnFocus": true, "anchor": "-20" });
    var main_2_panel3751 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 10, "autoHeight": true, "layout": "form", "xtype": "panel", "items": client_state3744, "labelAlign": "top" }, { "flex": 18, "autoHeight": true, "layout": "form", "xtype": "panel", "items": coached_by3745, "labelAlign": "top" }, { "flex": 18, "autoHeight": true, "layout": "form", "xtype": "panel", "items": and_coached_by3746, "labelAlign": "top" }, { "flex": 12, "autoHeight": true, "layout": "form", "xtype": "panel", "items": start_date3747, "labelAlign": "top" }, { "flex": 12, "autoHeight": true, "layout": "form", "xtype": "panel", "items": end_date3748, "labelAlign": "top" }, { "flex": 18, "autoHeight": true, "layout": "form", "xtype": "panel", "items": observed_event3749, "labelAlign": "top" }, { "flex": 9, "autoHeight": true, "layout": "form", "xtype": "panel", "items": only_primary3750, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 225, "border": false, "anchor": "-20", "labelAlign": "top" });
    this.items = [ main_1_panel3738, main_2_panel3751 ];
    this.fields = [ aged_from3733, aged_to3734, gender3735, nationality3736, also_obsolete3737, client_state3744, coached_by3745, and_coached_by3746, start_date3747, end_date3748, observed_event3749, only_primary3750 ];
    Lino.pcsw.Clients.ParamsPanel.superclass.initComponent.call(this);
  }
});


Lino.aids.RefundConfirmations.ParamsPanel = Ext.extend(Ext.form.FormPanel,{
  autoHeight: true,
  frame: true,
  layoutConfig: { "align": "stretchmax" },
  hideCheckBoxLabels: true,
  autoScroll: false,
  labelWidth: 135,
  border: false,
  bodyBorder: false,
  labelAlign: "top",
  layout: 'hbox',
  autoHeight: true,
  initComponent : function() {
    var board4826 = new Lino.TwinCombo({ "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Gremium</span>", "name": "board", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.boards.Boards.detail,Lino.boards.Boards.insert)}, "emptyText": "Gremium ausw\u00e4hlen...", "listeners": { "render": Lino.quicktip_renderer("Gremium","Only rows decided by this board.") }, "selectOnFocus": true, "hiddenName": "boardHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/aids/RefundConfirmations/board", "method": "GET" }) }) });
    var signer4827 = new Lino.TwinCombo({ "preferred_width": 15, "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Unterschreiber</span>", "name": "signer", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.users.Users.detail,Lino.users.Users.insert)}, "hiddenName": "signerHidden", "listeners": { "render": Lino.quicktip_renderer("Unterschreiber","Only rows confirmed (or to be confirmed) by this user.") }, "selectOnFocus": true, "emptyText": "Benutzer ausw\u00e4hlen...", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/aids/RefundConfirmations/signer", "method": "GET" }) }) });
    var user4828 = new Lino.TwinCombo({ "preferred_width": 15, "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Autor</span>", "name": "user", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.users.Users.detail,Lino.users.Users.insert)}, "hiddenName": "userHidden", "listeners": { "render": Lino.quicktip_renderer("Autor","Only rows created by this user.") }, "selectOnFocus": true, "emptyText": "Benutzer ausw\u00e4hlen...", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/aids/RefundConfirmations/user", "method": "GET" }) }) });
    var aid_type4829 = new Lino.TwinCombo({ "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Hilfeart</span>", "name": "aid_type", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.aids.AidTypes.detail,Lino.aids.AidTypes.insert)}, "emptyText": "Hilfeart ausw\u00e4hlen...", "listeners": { "render": Lino.quicktip_renderer("Hilfeart","Only confirmations about this aid type.") }, "selectOnFocus": true, "hiddenName": "aid_typeHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/aids/RefundConfirmations/aid_type", "method": "GET" }) }) });
    var state4830 = new Lino.ChoicesFieldElement({ "autoHeight": true, "forceSelection": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Zustand</span>", "name": "state", "hiddenName": "stateHidden", "listeners": { "render": Lino.quicktip_renderer("Zustand","Only rows having this state.") }, "selectOnFocus": true, "anchor": "-20", "store": [['','<br>']].concat(Lino.aids.ConfirmationStates) });
    this.items = [ { "flex": 21, "autoHeight": true, "layout": "form", "xtype": "panel", "items": board4826, "labelAlign": "top" }, { "flex": 21, "autoHeight": true, "layout": "form", "xtype": "panel", "items": signer4827, "labelAlign": "top" }, { "flex": 21, "autoHeight": true, "layout": "form", "xtype": "panel", "items": user4828, "labelAlign": "top" }, { "flex": 21, "autoHeight": true, "layout": "form", "xtype": "panel", "items": aid_type4829, "labelAlign": "top" }, { "flex": 14, "autoHeight": true, "layout": "form", "xtype": "panel", "items": state4830, "labelAlign": "top" } ];
    this.fields = [ board4826, signer4827, user4828, aid_type4829, state4830 ];
    Lino.aids.RefundConfirmations.ParamsPanel.superclass.initComponent.call(this);
  }
});


Lino.jobs.JobsOverview.ParamsPanel = Ext.extend(Ext.form.FormPanel,{
  autoHeight: true,
  frame: true,
  layoutConfig: { "align": "stretchmax" },
  hideCheckBoxLabels: true,
  autoScroll: false,
  labelWidth: 99,
  border: false,
  bodyBorder: false,
  labelAlign: "top",
  layout: 'hbox',
  autoHeight: true,
  initComponent : function() {
    var job_type5107 = new Lino.TwinCombo({ "autoHeight": true, "fieldLabel": "Stellenart", "name": "job_type", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.jobs.JobTypes.detail,Lino.jobs.JobTypes.insert)}, "emptyText": "Stellenart ausw\u00e4hlen...", "selectOnFocus": true, "hiddenName": "job_typeHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/jobs/JobsOverview/job_type", "method": "GET" }) }) });
    var today5108 = new Lino.DateField({ "selectOnFocus": true, "autoHeight": true, "fieldLabel": "Datum", "anchor": "-20", "name": "today" });
    this.items = [ { "flex": 60, "autoHeight": true, "layout": "form", "xtype": "panel", "items": job_type5107, "labelAlign": "top" }, { "flex": 39, "autoHeight": true, "layout": "form", "xtype": "panel", "items": today5108, "labelAlign": "top" } ];
    this.fields = [ job_type5107, today5108 ];
    Lino.jobs.JobsOverview.ParamsPanel.superclass.initComponent.call(this);
  }
});


Lino.cal.Guests.ParamsPanel = Ext.extend(Ext.form.FormPanel,{
  autoScroll: false,
  autoHeight: true,
  border: false,
  hideCheckBoxLabels: true,
  frame: true,
  bodyBorder: false,
  labelAlign: "top",
  layout: 'form',
  autoHeight: true,
  initComponent : function() {
    var start_date992 = new Lino.DateField({ "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Periode vom</span>", "name": "start_date", "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Periode vom","Start date of observed period") }, "value": null, "anchor": "-20" });
    var end_date993 = new Lino.DateField({ "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">bis</span>", "name": "end_date", "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("bis","End date of observed period") }, "value": null, "anchor": "-20" });
    var user994 = new Lino.TwinCombo({ "preferred_width": 15, "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Verantwortlicher</span>", "name": "user", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.users.Users.detail,Lino.users.Users.insert)}, "hiddenName": "userHidden", "listeners": { "render": Lino.quicktip_renderer("Verantwortlicher","Only rows managed by this user.") }, "selectOnFocus": true, "emptyText": "Benutzer ausw\u00e4hlen...", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/Guests/user", "method": "GET" }) }) });
    var event_state995 = new Lino.ChoicesFieldElement({ "autoHeight": true, "forceSelection": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Zustand Termin</span>", "name": "event_state", "hiddenName": "event_stateHidden", "listeners": { "render": Lino.quicktip_renderer("Zustand Termin","Only rows having this event state.") }, "selectOnFocus": true, "anchor": "-20", "store": [['','<br>']].concat(Lino.cal.EventStates) });
    var guest_state996 = new Lino.ChoicesFieldElement({ "autoHeight": true, "forceSelection": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Zustand Gast</span>", "name": "guest_state", "hiddenName": "guest_stateHidden", "listeners": { "render": Lino.quicktip_renderer("Zustand Gast","Only rows having this guest state.") }, "selectOnFocus": true, "anchor": "-20", "store": [['','<br>']].concat(Lino.cal.GuestStates) });
    var main_1_panel997 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 18, "autoHeight": true, "layout": "form", "xtype": "panel", "items": start_date992, "labelAlign": "top" }, { "flex": 18, "autoHeight": true, "layout": "form", "xtype": "panel", "items": end_date993, "labelAlign": "top" }, { "flex": 28, "autoHeight": true, "layout": "form", "xtype": "panel", "items": user994, "labelAlign": "top" }, { "flex": 18, "autoHeight": true, "layout": "form", "xtype": "panel", "items": event_state995, "labelAlign": "top" }, { "flex": 15, "autoHeight": true, "layout": "form", "xtype": "panel", "items": guest_state996, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 153, "border": false, "anchor": "-20", "labelAlign": "top" });
    var project1003 = new Lino.TwinCombo({ "preferred_width": 20, "autoHeight": true, "fieldLabel": "Klient", "name": "project", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.pcsw.Clients.detail,Lino.pcsw.Clients.insert)}, "hiddenName": "projectHidden", "selectOnFocus": true, "emptyText": "Klient ausw\u00e4hlen...", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/Guests/project", "method": "GET" }) }) });
    var partner1004 = new Lino.TwinCombo({ "preferred_width": 20, "autoHeight": true, "fieldLabel": "Partner", "name": "partner", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.contacts.Partners.detail,Lino.contacts.Partners.insert)}, "hiddenName": "partnerHidden", "selectOnFocus": true, "emptyText": "Partner ausw\u00e4hlen...", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/Guests/partner", "method": "GET" }) }) });
    var main_2_panel1005 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": project1003, "labelAlign": "top" }, { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": partner1004, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 72, "border": false, "anchor": "-20", "labelAlign": "top" });
    this.items = [ main_1_panel997, main_2_panel1005 ];
    this.fields = [ start_date992, end_date993, user994, event_state995, guest_state996, project1003, partner1004 ];
    Lino.cal.Guests.ParamsPanel.superclass.initComponent.call(this);
  }
});


Lino.changes.Changes.ParamsPanel = Ext.extend(Ext.form.FormPanel,{
  autoScroll: false,
  border: false,
  hideCheckBoxLabels: true,
  frame: true,
  bodyBorder: false,
  labelAlign: "top",
  layout: 'form',
  autoHeight: true,
  initComponent : function() {
    var date1321 = new Lino.DateField({ "selectOnFocus": true, "autoHeight": true, "fieldLabel": "Only changes from", "anchor": "-20", "name": "date" });
    var user1322 = new Lino.TwinCombo({ "preferred_width": 15, "autoHeight": true, "fieldLabel": "Benutzer", "name": "user", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.users.Users.detail,Lino.users.Users.insert)}, "hiddenName": "userHidden", "selectOnFocus": true, "emptyText": "Benutzer ausw\u00e4hlen...", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/changes/Changes/user", "method": "GET" }) }) });
    var change_type1323 = new Lino.ChoicesFieldElement({ "autoHeight": true, "forceSelection": false, "fieldLabel": "\u00c4nderungsart", "name": "change_type", "hiddenName": "change_typeHidden", "selectOnFocus": true, "anchor": "-20", "store": [['','<br>']].concat(Lino.lino.ChangeTypes) });
    var object_type1324 = new Lino.TwinCombo({ "autoHeight": true, "fieldLabel": "Object type", "name": "object_type", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.contenttypes.ContentTypes.detail,Lino.contenttypes.ContentTypes.insert)}, "emptyText": "Datenbankmodell ausw\u00e4hlen...", "selectOnFocus": true, "hiddenName": "object_typeHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/changes/Changes/object_type", "method": "GET" }) }) });
    var object_id1325 = new Lino.RemoteComboFieldElement({ "autoHeight": true, "fieldLabel": "Object ID", "name": "object_id", "selectOnFocus": true, "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/changes/Changes/object_id", "method": "GET" }) }), "hiddenName": "object_idHidden" });
    var main_1_panel1326 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 162, "hideCheckBoxLabels": true, "items": [ { "flex": 16, "autoHeight": true, "layout": "form", "xtype": "panel", "items": date1321, "labelAlign": "top" }, { "flex": 25, "autoHeight": true, "layout": "form", "xtype": "panel", "items": user1322, "labelAlign": "top" }, { "flex": 19, "autoHeight": true, "layout": "form", "xtype": "panel", "items": change_type1323, "labelAlign": "top" }, { "flex": 25, "autoHeight": true, "layout": "form", "xtype": "panel", "items": object_type1324, "labelAlign": "top" }, { "flex": 12, "autoHeight": true, "layout": "form", "xtype": "panel", "items": object_id1325, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    this.items = [ main_1_panel1326 ];
    this.fields = [ date1321, user1322, change_type1323, object_type1324, object_id1325 ];
    Lino.changes.Changes.ParamsPanel.superclass.initComponent.call(this);
  }
});


Lino.jobs.Contracts.ParamsPanel = Ext.extend(Ext.form.FormPanel,{
  autoScroll: false,
  autoHeight: true,
  border: false,
  hideCheckBoxLabels: true,
  frame: true,
  bodyBorder: false,
  labelAlign: "top",
  layout: 'form',
  autoHeight: true,
  initComponent : function() {
    var user2574 = new Lino.TwinCombo({ "preferred_width": 15, "autoHeight": true, "fieldLabel": "Benutzer", "name": "user", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.users.Users.detail,Lino.users.Users.insert)}, "hiddenName": "userHidden", "selectOnFocus": true, "emptyText": "Benutzer ausw\u00e4hlen...", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/jobs/Contracts/user", "method": "GET" }) }) });
    var type2575 = new Lino.TwinCombo({ "preferred_width": 20, "autoHeight": true, "fieldLabel": "Vertragsart", "name": "type", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.jobs.ContractTypes.detail,Lino.jobs.ContractTypes.insert)}, "hiddenName": "typeHidden", "selectOnFocus": true, "emptyText": "Art.60\u00a77-Konventionsart ausw\u00e4hlen...", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/jobs/Contracts/type", "method": "GET" }) }) });
    var start_date2576 = new Lino.DateField({ "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Periode vom</span>", "name": "start_date", "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Periode vom","Start date of observed period") }, "value": null, "anchor": "-20" });
    var end_date2577 = new Lino.DateField({ "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">bis</span>", "name": "end_date", "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("bis","End date of observed period") }, "value": null, "anchor": "-20" });
    var observed_event2578 = new Lino.ChoicesFieldElement({ "autoHeight": true, "forceSelection": true, "fieldLabel": "Beobachtungskriterium", "name": "observed_event", "hiddenName": "observed_eventHidden", "selectOnFocus": true, "anchor": "-20", "store": [['','<br>']].concat(Lino.isip.ContractEvents) });
    var main_1_panel2579 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 26, "autoHeight": true, "layout": "form", "xtype": "panel", "items": user2574, "labelAlign": "top" }, { "flex": 26, "autoHeight": true, "layout": "form", "xtype": "panel", "items": type2575, "labelAlign": "top" }, { "flex": 17, "autoHeight": true, "layout": "form", "xtype": "panel", "items": start_date2576, "labelAlign": "top" }, { "flex": 17, "autoHeight": true, "layout": "form", "xtype": "panel", "items": end_date2577, "labelAlign": "top" }, { "flex": 13, "autoHeight": true, "layout": "form", "xtype": "panel", "items": observed_event2578, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 198, "border": false, "anchor": "-20", "labelAlign": "top" });
    var company2585 = new Lino.TwinCombo({ "preferred_width": 20, "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Organisation</span>", "name": "company", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.contacts.Companies.detail,Lino.contacts.Companies.insert)}, "hiddenName": "companyHidden", "listeners": { "render": Lino.quicktip_renderer("Organisation","Only contracts with this company as partner.") }, "selectOnFocus": true, "emptyText": "Organisation ausw\u00e4hlen...", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/jobs/Contracts/company", "method": "GET" }) }) });
    var ending_success2586 = new Lino.ChoicesFieldElement({ "autoHeight": true, "forceSelection": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Erfolgreich abgeschlossen</span>", "name": "ending_success", "hiddenName": "ending_successHidden", "listeners": { "render": Lino.quicktip_renderer("Erfolgreich abgeschlossen","Contrats termin\u00e9s avec succ\u00e8s.") }, "selectOnFocus": true, "anchor": "-20", "store": [['','<br>']].concat(Lino.lino.YesNo) });
    var ending2587 = new Lino.TwinCombo({ "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Beendigungsgrund</span>", "name": "ending", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.isip.ContractEndings.detail,Lino.isip.ContractEndings.insert)}, "emptyText": "Beendigungsgrund ausw\u00e4hlen...", "listeners": { "render": Lino.quicktip_renderer("Beendigungsgrund","Nur Konventionen mit diesem Beendigungsgrund.") }, "selectOnFocus": true, "hiddenName": "endingHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/jobs/Contracts/ending", "method": "GET" }) }) });
    var main_2_panel2588 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 42, "autoHeight": true, "layout": "form", "xtype": "panel", "items": company2585, "labelAlign": "top" }, { "flex": 14, "autoHeight": true, "layout": "form", "xtype": "panel", "items": ending_success2586, "labelAlign": "top" }, { "flex": 42, "autoHeight": true, "layout": "form", "xtype": "panel", "items": ending2587, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 234, "border": false, "anchor": "-20", "labelAlign": "top" });
    this.items = [ main_1_panel2579, main_2_panel2588 ];
    this.fields = [ user2574, type2575, start_date2576, end_date2577, observed_event2578, company2585, ending_success2586, ending2587 ];
    Lino.jobs.Contracts.ParamsPanel.superclass.initComponent.call(this);
  }
});


Lino.newcomers.NewClients.ParamsPanel = Ext.extend(Ext.form.FormPanel,{
  autoHeight: true,
  frame: true,
  layoutConfig: { "align": "stretchmax" },
  hideCheckBoxLabels: true,
  autoScroll: false,
  labelWidth: 225,
  border: false,
  bodyBorder: false,
  labelAlign: "top",
  layout: 'hbox',
  autoHeight: true,
  initComponent : function() {
    var new_since4402 = new Lino.DateField({ "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Neue Klienten seit</span>", "name": "new_since", "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Neue Klienten seit","Auch Klienten, die erst seit Kurzem begleitet sind.") }, "anchor": "-20" });
    var also_refused4403 = new Ext.form.Checkbox({ "boxLabel": "Auch abgelehnte Klienten", "autoHeight": true, "hideLabel": true, "checked": false, "name": "also_refused", "selectOnFocus": true, "anchor": "-20" });
    var also_obsolete4404 = new Ext.form.Checkbox({ "boxLabel": "Auch veraltete Daten", "autoHeight": true, "hideLabel": true, "checked": false, "name": "also_obsolete", "selectOnFocus": true, "anchor": "-20" });
    var coached_by4405 = new Lino.TwinCombo({ "preferred_width": 15, "autoHeight": true, "fieldLabel": "Begleitet durch", "name": "coached_by", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.users.Users.detail,Lino.users.Users.insert)}, "hiddenName": "coached_byHidden", "selectOnFocus": true, "emptyText": "Benutzer ausw\u00e4hlen...", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/newcomers/NewClients/coached_by", "method": "GET" }) }) });
    this.items = [ { "flex": 24, "autoHeight": true, "layout": "form", "xtype": "panel", "items": new_since4402, "labelAlign": "top" }, { "flex": 18, "autoHeight": true, "layout": "form", "xtype": "panel", "items": also_refused4403, "labelAlign": "top" }, { "flex": 18, "autoHeight": true, "layout": "form", "xtype": "panel", "items": also_obsolete4404, "labelAlign": "top" }, { "flex": 37, "autoHeight": true, "layout": "form", "xtype": "panel", "items": coached_by4405, "labelAlign": "top" } ];
    this.fields = [ new_since4402, also_refused4403, also_obsolete4404, coached_by4405 ];
    Lino.newcomers.NewClients.ParamsPanel.superclass.initComponent.call(this);
  }
});


Lino.isip.Contracts.ParamsPanel = Ext.extend(Ext.form.FormPanel,{
  autoScroll: false,
  autoHeight: true,
  border: false,
  hideCheckBoxLabels: true,
  frame: true,
  bodyBorder: false,
  labelAlign: "top",
  layout: 'form',
  autoHeight: true,
  initComponent : function() {
    var user2334 = new Lino.TwinCombo({ "preferred_width": 15, "autoHeight": true, "fieldLabel": "Benutzer", "name": "user", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.users.Users.detail,Lino.users.Users.insert)}, "hiddenName": "userHidden", "selectOnFocus": true, "emptyText": "Benutzer ausw\u00e4hlen...", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/isip/Contracts/user", "method": "GET" }) }) });
    var type2335 = new Lino.TwinCombo({ "preferred_width": 20, "autoHeight": true, "fieldLabel": "VSE-Art", "name": "type", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.isip.ContractTypes.detail,Lino.isip.ContractTypes.insert)}, "hiddenName": "typeHidden", "selectOnFocus": true, "emptyText": "VSE-Art ausw\u00e4hlen...", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/isip/Contracts/type", "method": "GET" }) }) });
    var start_date2336 = new Lino.DateField({ "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Periode vom</span>", "name": "start_date", "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Periode vom","Start date of observed period") }, "value": null, "anchor": "-20" });
    var end_date2337 = new Lino.DateField({ "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">bis</span>", "name": "end_date", "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("bis","End date of observed period") }, "value": null, "anchor": "-20" });
    var observed_event2338 = new Lino.ChoicesFieldElement({ "autoHeight": true, "forceSelection": true, "fieldLabel": "Beobachtungskriterium", "name": "observed_event", "hiddenName": "observed_eventHidden", "selectOnFocus": true, "anchor": "-20", "store": [['','<br>']].concat(Lino.isip.ContractEvents) });
    var main_1_panel2339 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 26, "autoHeight": true, "layout": "form", "xtype": "panel", "items": user2334, "labelAlign": "top" }, { "flex": 26, "autoHeight": true, "layout": "form", "xtype": "panel", "items": type2335, "labelAlign": "top" }, { "flex": 17, "autoHeight": true, "layout": "form", "xtype": "panel", "items": start_date2336, "labelAlign": "top" }, { "flex": 17, "autoHeight": true, "layout": "form", "xtype": "panel", "items": end_date2337, "labelAlign": "top" }, { "flex": 13, "autoHeight": true, "layout": "form", "xtype": "panel", "items": observed_event2338, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 198, "border": false, "anchor": "-20", "labelAlign": "top" });
    var company2345 = new Lino.TwinCombo({ "preferred_width": 20, "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Organisation</span>", "name": "company", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.contacts.Companies.detail,Lino.contacts.Companies.insert)}, "hiddenName": "companyHidden", "listeners": { "render": Lino.quicktip_renderer("Organisation","Only contracts with this company as partner.") }, "selectOnFocus": true, "emptyText": "Organisation ausw\u00e4hlen...", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/isip/Contracts/company", "method": "GET" }) }) });
    var study_type2346 = new Lino.TwinCombo({ "autoHeight": true, "fieldLabel": "Studienart", "name": "study_type", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.cv.StudyTypes.detail,Lino.cv.StudyTypes.insert)}, "emptyText": "Studienart ausw\u00e4hlen...", "selectOnFocus": true, "hiddenName": "study_typeHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/isip/Contracts/study_type", "method": "GET" }) }) });
    var ending_success2347 = new Lino.ChoicesFieldElement({ "autoHeight": true, "forceSelection": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Erfolgreich abgeschlossen</span>", "name": "ending_success", "hiddenName": "ending_successHidden", "listeners": { "render": Lino.quicktip_renderer("Erfolgreich abgeschlossen","Contrats termin\u00e9s avec succ\u00e8s.") }, "selectOnFocus": true, "anchor": "-20", "store": [['','<br>']].concat(Lino.lino.YesNo) });
    var ending2348 = new Lino.TwinCombo({ "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Beendigungsgrund</span>", "name": "ending", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.isip.ContractEndings.detail,Lino.isip.ContractEndings.insert)}, "emptyText": "Beendigungsgrund ausw\u00e4hlen...", "listeners": { "render": Lino.quicktip_renderer("Beendigungsgrund","Nur Konventionen mit diesem Beendigungsgrund.") }, "selectOnFocus": true, "hiddenName": "endingHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/isip/Contracts/ending", "method": "GET" }) }) });
    var main_2_panel2349 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 26, "autoHeight": true, "layout": "form", "xtype": "panel", "items": company2345, "labelAlign": "top" }, { "flex": 20, "autoHeight": true, "layout": "form", "xtype": "panel", "items": study_type2346, "labelAlign": "top" }, { "flex": 26, "autoHeight": true, "layout": "form", "xtype": "panel", "items": ending_success2347, "labelAlign": "top" }, { "flex": 26, "autoHeight": true, "layout": "form", "xtype": "panel", "items": ending2348, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 234, "border": false, "anchor": "-20", "labelAlign": "top" });
    this.items = [ main_1_panel2339, main_2_panel2349 ];
    this.fields = [ user2334, type2335, start_date2336, end_date2337, observed_event2338, company2345, study_type2346, ending_success2347, ending2348 ];
    Lino.isip.Contracts.ParamsPanel.superclass.initComponent.call(this);
  }
});


Lino.pcsw.ClientsTest.ParamsPanel = Ext.extend(Ext.form.FormPanel,{
  autoScroll: false,
  autoHeight: true,
  border: false,
  hideCheckBoxLabels: true,
  frame: true,
  bodyBorder: false,
  labelAlign: "top",
  layout: 'form',
  autoHeight: true,
  initComponent : function() {
    var aged_from3760 = new Ext.form.NumberField({ "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Alter von</span>", "name": "aged_from", "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Alter von","Nur Klienten, die mindestens so alt sind.") }, "anchor": "-20" });
    var aged_to3761 = new Ext.form.NumberField({ "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Alter bis</span>", "name": "aged_to", "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Alter bis","Nur Klienten, die h\u00f6chstens so alt sind.") }, "anchor": "-20" });
    var gender3762 = new Lino.ChoicesFieldElement({ "autoHeight": true, "forceSelection": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Geschlecht</span>", "name": "gender", "hiddenName": "genderHidden", "listeners": { "render": Lino.quicktip_renderer("Geschlecht","Show only persons with the given gender.") }, "selectOnFocus": true, "anchor": "-20", "store": [['','<br>']].concat(Lino.lino.Genders) });
    var also_obsolete3763 = new Ext.form.Checkbox({ "autoHeight": true, "hideLabel": true, "checked": false, "name": "also_obsolete", "listeners": { "render": Lino.quicktip_renderer("Auch veraltete Daten","Show also obsolete records.") }, "boxLabel": "Auch veraltete Daten", "selectOnFocus": true, "anchor": "-20" });
    var main_1_panel3764 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 17, "autoHeight": true, "layout": "form", "xtype": "panel", "items": aged_from3760, "labelAlign": "top" }, { "flex": 17, "autoHeight": true, "layout": "form", "xtype": "panel", "items": aged_to3761, "labelAlign": "top" }, { "flex": 31, "autoHeight": true, "layout": "form", "xtype": "panel", "items": gender3762, "labelAlign": "top" }, { "flex": 34, "autoHeight": true, "layout": "form", "xtype": "panel", "items": also_obsolete3763, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 189, "border": false, "anchor": "-20", "labelAlign": "top" });
    var client_state3769 = new Lino.ChoicesFieldElement({ "autoHeight": true, "forceSelection": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Zustand</span>", "name": "client_state", "hiddenName": "client_stateHidden", "listeners": { "render": Lino.quicktip_renderer("Zustand","Nur Klienten mit diesem Status (Aktenzustand).") }, "selectOnFocus": true, "anchor": "-20", "store": [['','<br>']].concat(Lino.pcsw.ClientStates) });
    var coached_by3770 = new Lino.TwinCombo({ "preferred_width": 15, "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Begleitet durch</span>", "name": "coached_by", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.users.Users.detail,Lino.users.Users.insert)}, "hiddenName": "coached_byHidden", "listeners": { "render": Lino.quicktip_renderer("Begleitet durch","Nur Klienten, die eine Begleitung mit diesem Benutzer haben.") }, "selectOnFocus": true, "emptyText": "Benutzer ausw\u00e4hlen...", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/pcsw/ClientsTest/coached_by", "method": "GET" }) }) });
    var and_coached_by3771 = new Lino.TwinCombo({ "preferred_width": 15, "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">und durch</span>", "name": "and_coached_by", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.users.Users.detail,Lino.users.Users.insert)}, "hiddenName": "and_coached_byHidden", "listeners": { "render": Lino.quicktip_renderer("und durch","Nur Klienten, die auch mit diesem Benutzer eine Begleitung haben.") }, "selectOnFocus": true, "emptyText": "Benutzer ausw\u00e4hlen...", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/pcsw/ClientsTest/and_coached_by", "method": "GET" }) }) });
    var start_date3772 = new Lino.DateField({ "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Periode vom</span>", "name": "start_date", "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Periode vom","Start date of observed period") }, "value": null, "anchor": "-20" });
    var end_date3773 = new Lino.DateField({ "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">bis</span>", "name": "end_date", "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("bis","End date of observed period") }, "value": null, "anchor": "-20" });
    var observed_event3774 = new Lino.ChoicesFieldElement({ "autoHeight": true, "forceSelection": true, "fieldLabel": "Beobachtungskriterium", "name": "observed_event", "hiddenName": "observed_eventHidden", "selectOnFocus": true, "anchor": "-20", "store": [['','<br>']].concat(Lino.pcsw.ClientEvents) });
    var main_2_panel3775 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 11, "autoHeight": true, "layout": "form", "xtype": "panel", "items": client_state3769, "labelAlign": "top" }, { "flex": 20, "autoHeight": true, "layout": "form", "xtype": "panel", "items": coached_by3770, "labelAlign": "top" }, { "flex": 20, "autoHeight": true, "layout": "form", "xtype": "panel", "items": and_coached_by3771, "labelAlign": "top" }, { "flex": 13, "autoHeight": true, "layout": "form", "xtype": "panel", "items": start_date3772, "labelAlign": "top" }, { "flex": 13, "autoHeight": true, "layout": "form", "xtype": "panel", "items": end_date3773, "labelAlign": "top" }, { "flex": 20, "autoHeight": true, "layout": "form", "xtype": "panel", "items": observed_event3774, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 198, "border": false, "anchor": "-20", "labelAlign": "top" });
    var invalid_niss3782 = new Ext.form.Checkbox({ "boxLabel": "auf g\u00fcltige NISS pr\u00fcfen", "autoHeight": true, "hideLabel": true, "checked": true, "name": "invalid_niss", "selectOnFocus": true, "anchor": "-20" });
    var overlapping_contracts3783 = new Ext.form.Checkbox({ "boxLabel": "auf Vertrags\u00fcberschneidungen pr\u00fcfen", "autoHeight": true, "hideLabel": true, "checked": true, "name": "overlapping_contracts", "selectOnFocus": true, "anchor": "-20" });
    var only_primary3784 = new Ext.form.Checkbox({ "autoHeight": true, "hideLabel": true, "checked": false, "name": "only_primary", "listeners": { "render": Lino.quicktip_renderer("Nur prim\u00e4re Begleitungen","Nur Klienten, die eine effektive <b>prim\u00e4re</b> Begleitung haben.") }, "boxLabel": "Nur prim\u00e4re Begleitungen", "selectOnFocus": true, "anchor": "-20" });
    var nationality3785 = new Lino.TwinCombo({ "autoHeight": true, "fieldLabel": "Staatsangeh\u00f6rigkeit", "name": "nationality", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.countries.Countries.detail,Lino.countries.Countries.insert)}, "emptyText": "Land ausw\u00e4hlen...", "selectOnFocus": true, "hiddenName": "nationalityHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/pcsw/ClientsTest/nationality", "method": "GET" }) }) });
    var main_3_panel3786 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 20, "autoHeight": true, "layout": "form", "xtype": "panel", "items": invalid_niss3782, "labelAlign": "top" }, { "flex": 20, "autoHeight": true, "layout": "form", "xtype": "panel", "items": overlapping_contracts3783, "labelAlign": "top" }, { "flex": 20, "autoHeight": true, "layout": "form", "xtype": "panel", "items": only_primary3784, "labelAlign": "top" }, { "flex": 40, "autoHeight": true, "layout": "form", "xtype": "panel", "items": nationality3785, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 324, "border": false, "anchor": "-20", "labelAlign": "top" });
    this.items = [ main_1_panel3764, main_2_panel3775, main_3_panel3786 ];
    this.fields = [ aged_from3760, aged_to3761, gender3762, also_obsolete3763, client_state3769, coached_by3770, and_coached_by3771, start_date3772, end_date3773, observed_event3774, invalid_niss3782, overlapping_contracts3783, only_primary3784, nationality3785 ];
    Lino.pcsw.ClientsTest.ParamsPanel.superclass.initComponent.call(this);
  }
});


Lino.courses.PendingCourseRequests.ParamsPanel = Ext.extend(Ext.form.FormPanel,{
  autoScroll: false,
  autoHeight: true,
  border: false,
  hideCheckBoxLabels: true,
  frame: true,
  bodyBorder: false,
  labelAlign: "top",
  layout: 'form',
  autoHeight: true,
  initComponent : function() {
    var aged_from168 = new Ext.form.NumberField({ "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Alter von</span>", "name": "aged_from", "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Alter von","Nur Klienten, die mindestens so alt sind.") }, "anchor": "-20" });
    var aged_to169 = new Ext.form.NumberField({ "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Alter bis</span>", "name": "aged_to", "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Alter bis","Nur Klienten, die h\u00f6chstens so alt sind.") }, "anchor": "-20" });
    var gender170 = new Lino.ChoicesFieldElement({ "autoHeight": true, "forceSelection": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Geschlecht</span>", "name": "gender", "hiddenName": "genderHidden", "listeners": { "render": Lino.quicktip_renderer("Geschlecht","Show only persons with the given gender.") }, "selectOnFocus": true, "anchor": "-20", "store": [['','<br>']].concat(Lino.lino.Genders) });
    var nationality171 = new Lino.TwinCombo({ "autoHeight": true, "fieldLabel": "Staatsangeh\u00f6rigkeit", "name": "nationality", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.countries.Countries.detail,Lino.countries.Countries.insert)}, "emptyText": "Land ausw\u00e4hlen...", "selectOnFocus": true, "hiddenName": "nationalityHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/courses/PendingCourseRequests/nationality", "method": "GET" }) }) });
    var also_obsolete172 = new Ext.form.Checkbox({ "autoHeight": true, "hideLabel": true, "checked": false, "name": "also_obsolete", "listeners": { "render": Lino.quicktip_renderer("Auch veraltete Daten","Show also obsolete records.") }, "boxLabel": "Auch veraltete Daten", "selectOnFocus": true, "anchor": "-20" });
    var main_1_panel173 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 10, "autoHeight": true, "layout": "form", "xtype": "panel", "items": aged_from168, "labelAlign": "top" }, { "flex": 10, "autoHeight": true, "layout": "form", "xtype": "panel", "items": aged_to169, "labelAlign": "top" }, { "flex": 18, "autoHeight": true, "layout": "form", "xtype": "panel", "items": gender170, "labelAlign": "top" }, { "flex": 40, "autoHeight": true, "layout": "form", "xtype": "panel", "items": nationality171, "labelAlign": "top" }, { "flex": 20, "autoHeight": true, "layout": "form", "xtype": "panel", "items": also_obsolete172, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 189, "border": false, "anchor": "-20", "labelAlign": "top" });
    var client_state179 = new Lino.ChoicesFieldElement({ "autoHeight": true, "forceSelection": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Zustand</span>", "name": "client_state", "hiddenName": "client_stateHidden", "listeners": { "render": Lino.quicktip_renderer("Zustand","Nur Klienten mit diesem Status (Aktenzustand).") }, "selectOnFocus": true, "anchor": "-20", "store": [['','<br>']].concat(Lino.pcsw.ClientStates) });
    var coached_by180 = new Lino.TwinCombo({ "preferred_width": 15, "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Begleitet durch</span>", "name": "coached_by", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.users.Users.detail,Lino.users.Users.insert)}, "hiddenName": "coached_byHidden", "listeners": { "render": Lino.quicktip_renderer("Begleitet durch","Nur Klienten, die eine Begleitung mit diesem Benutzer haben.") }, "selectOnFocus": true, "emptyText": "Benutzer ausw\u00e4hlen...", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/courses/PendingCourseRequests/coached_by", "method": "GET" }) }) });
    var and_coached_by181 = new Lino.TwinCombo({ "preferred_width": 15, "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">und durch</span>", "name": "and_coached_by", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.users.Users.detail,Lino.users.Users.insert)}, "hiddenName": "and_coached_byHidden", "listeners": { "render": Lino.quicktip_renderer("und durch","Nur Klienten, die auch mit diesem Benutzer eine Begleitung haben.") }, "selectOnFocus": true, "emptyText": "Benutzer ausw\u00e4hlen...", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/courses/PendingCourseRequests/and_coached_by", "method": "GET" }) }) });
    var start_date182 = new Lino.DateField({ "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Periode vom</span>", "name": "start_date", "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Periode vom","Start date of observed period") }, "value": null, "anchor": "-20" });
    var end_date183 = new Lino.DateField({ "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">bis</span>", "name": "end_date", "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("bis","End date of observed period") }, "value": null, "anchor": "-20" });
    var observed_event184 = new Lino.ChoicesFieldElement({ "autoHeight": true, "forceSelection": true, "fieldLabel": "Beobachtungskriterium", "name": "observed_event", "hiddenName": "observed_eventHidden", "selectOnFocus": true, "anchor": "-20", "store": [['','<br>']].concat(Lino.pcsw.ClientEvents) });
    var only_primary185 = new Ext.form.Checkbox({ "autoHeight": true, "hideLabel": true, "checked": false, "name": "only_primary", "listeners": { "render": Lino.quicktip_renderer("Nur prim\u00e4re Begleitungen","Nur Klienten, die eine effektive <b>prim\u00e4re</b> Begleitung haben.") }, "boxLabel": "Nur prim\u00e4re Begleitungen", "selectOnFocus": true, "anchor": "-20" });
    var main_2_panel186 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 10, "autoHeight": true, "layout": "form", "xtype": "panel", "items": client_state179, "labelAlign": "top" }, { "flex": 18, "autoHeight": true, "layout": "form", "xtype": "panel", "items": coached_by180, "labelAlign": "top" }, { "flex": 18, "autoHeight": true, "layout": "form", "xtype": "panel", "items": and_coached_by181, "labelAlign": "top" }, { "flex": 12, "autoHeight": true, "layout": "form", "xtype": "panel", "items": start_date182, "labelAlign": "top" }, { "flex": 12, "autoHeight": true, "layout": "form", "xtype": "panel", "items": end_date183, "labelAlign": "top" }, { "flex": 18, "autoHeight": true, "layout": "form", "xtype": "panel", "items": observed_event184, "labelAlign": "top" }, { "flex": 9, "autoHeight": true, "layout": "form", "xtype": "panel", "items": only_primary185, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 225, "border": false, "anchor": "-20", "labelAlign": "top" });
    var request_state194 = new Lino.ChoicesFieldElement({ "autoHeight": true, "forceSelection": true, "fieldLabel": "Zustand", "name": "request_state", "hiddenName": "request_stateHidden", "selectOnFocus": true, "anchor": "-20", "store": [['','<br>']].concat(Lino.courses.CourseRequestStates) });
    var course_content195 = new Lino.TwinCombo({ "autoHeight": true, "fieldLabel": "Kursinhalt", "name": "course_content", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.courses.CourseContents.detail,Lino.courses.CourseContents.insert)}, "emptyText": "Kursinhalt ausw\u00e4hlen...", "selectOnFocus": true, "hiddenName": "course_contentHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/courses/PendingCourseRequests/course_content", "method": "GET" }) }) });
    var course_provider196 = new Lino.TwinCombo({ "preferred_width": 20, "autoHeight": true, "fieldLabel": "Kursanbieter", "name": "course_provider", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.courses.CourseProviders.detail,Lino.courses.CourseProviders.insert)}, "hiddenName": "course_providerHidden", "selectOnFocus": true, "emptyText": "Kursanbieter ausw\u00e4hlen...", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/courses/PendingCourseRequests/course_provider", "method": "GET" }) }) });
    var course_offer197 = new Lino.TwinCombo({ "autoHeight": true, "fieldLabel": "Kursangebot", "name": "course_offer", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.courses.CourseOffers.detail,Lino.courses.CourseOffers.insert)}, "emptyText": "Kursangebot ausw\u00e4hlen...", "selectOnFocus": true, "hiddenName": "course_offerHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/courses/PendingCourseRequests/course_offer", "method": "GET" }) }) });
    var main_3_panel198 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 17, "autoHeight": true, "layout": "form", "xtype": "panel", "items": request_state194, "labelAlign": "top" }, { "flex": 27, "autoHeight": true, "layout": "form", "xtype": "panel", "items": course_content195, "labelAlign": "top" }, { "flex": 27, "autoHeight": true, "layout": "form", "xtype": "panel", "items": course_provider196, "labelAlign": "top" }, { "flex": 27, "autoHeight": true, "layout": "form", "xtype": "panel", "items": course_offer197, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 117, "border": false, "anchor": "-20", "labelAlign": "top" });
    this.items = [ main_1_panel173, main_2_panel186, main_3_panel198 ];
    this.fields = [ aged_from168, aged_to169, gender170, nationality171, also_obsolete172, client_state179, coached_by180, and_coached_by181, start_date182, end_date183, observed_event184, only_primary185, request_state194, course_content195, course_provider196, course_offer197 ];
    Lino.courses.PendingCourseRequests.ParamsPanel.superclass.initComponent.call(this);
  }
});


Lino.about.Inspector.ParamsPanel = Ext.extend(Ext.form.FormPanel,{
  autoHeight: true,
  frame: true,
  layoutConfig: { "align": "stretchmax" },
  hideCheckBoxLabels: true,
  autoScroll: false,
  labelWidth: 153,
  border: false,
  bodyBorder: false,
  labelAlign: "top",
  layout: 'hbox',
  autoHeight: true,
  initComponent : function() {
    var inspected5085 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Inspected object", "name": "inspected", "maxLength": 100, "selectOnFocus": true, "anchor": "-20" });
    var show_callables5086 = new Ext.form.Checkbox({ "boxLabel": "show callables", "autoHeight": true, "hideLabel": true, "checked": false, "name": "show_callables", "selectOnFocus": true, "anchor": "-20" });
    this.items = [ { "flex": 67, "autoHeight": true, "layout": "form", "xtype": "panel", "items": inspected5085, "labelAlign": "top" }, { "flex": 32, "autoHeight": true, "layout": "form", "xtype": "panel", "items": show_callables5086, "labelAlign": "top" } ];
    this.fields = [ inspected5085, show_callables5086 ];
    Lino.about.Inspector.ParamsPanel.superclass.initComponent.call(this);
  }
});


Lino.pcsw.Coachings.ParamsPanel = Ext.extend(Ext.form.FormPanel,{
  autoScroll: false,
  autoHeight: true,
  border: false,
  hideCheckBoxLabels: true,
  frame: true,
  bodyBorder: false,
  labelAlign: "top",
  layout: 'form',
  autoHeight: true,
  initComponent : function() {
    var start_date852 = new Lino.DateField({ "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Periode vom</span>", "name": "start_date", "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Periode vom","Start date of observed period") }, "value": null, "anchor": "-20" });
    var end_date853 = new Lino.DateField({ "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">bis</span>", "name": "end_date", "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("bis","End date of observed period") }, "value": null, "anchor": "-20" });
    var observed_event854 = new Lino.ChoicesFieldElement({ "autoHeight": true, "forceSelection": true, "fieldLabel": "Beobachtungskriterium", "name": "observed_event", "hiddenName": "observed_eventHidden", "selectOnFocus": true, "anchor": "-20", "store": [['','<br>']].concat(Lino.lino.PeriodEvents) });
    var coached_by855 = new Lino.TwinCombo({ "preferred_width": 15, "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Begleitet durch</span>", "name": "coached_by", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.users.Users.detail,Lino.users.Users.insert)}, "hiddenName": "coached_byHidden", "listeners": { "render": Lino.quicktip_renderer("Begleitet durch","Nur Begleitungen dieses Benutzers.") }, "selectOnFocus": true, "emptyText": "Benutzer ausw\u00e4hlen...", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/pcsw/Coachings/coached_by", "method": "GET" }) }) });
    var and_coached_by856 = new Lino.TwinCombo({ "preferred_width": 15, "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">und durch</span>", "name": "and_coached_by", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.users.Users.detail,Lino.users.Users.insert)}, "hiddenName": "and_coached_byHidden", "listeners": { "render": Lino.quicktip_renderer("und durch","... und auch Begleitungen dieses Benutzers.") }, "selectOnFocus": true, "emptyText": "Benutzer ausw\u00e4hlen...", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/pcsw/Coachings/and_coached_by", "method": "GET" }) }) });
    var main_1_panel857 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 17, "autoHeight": true, "layout": "form", "xtype": "panel", "items": start_date852, "labelAlign": "top" }, { "flex": 17, "autoHeight": true, "layout": "form", "xtype": "panel", "items": end_date853, "labelAlign": "top" }, { "flex": 13, "autoHeight": true, "layout": "form", "xtype": "panel", "items": observed_event854, "labelAlign": "top" }, { "flex": 26, "autoHeight": true, "layout": "form", "xtype": "panel", "items": coached_by855, "labelAlign": "top" }, { "flex": 26, "autoHeight": true, "layout": "form", "xtype": "panel", "items": and_coached_by856, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 198, "border": false, "anchor": "-20", "labelAlign": "top" });
    var primary_coachings863 = new Lino.ChoicesFieldElement({ "autoHeight": true, "forceSelection": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Prim\u00e4re Begleitungen</span>", "name": "primary_coachings", "hiddenName": "primary_coachingsHidden", "listeners": { "render": Lino.quicktip_renderer("Prim\u00e4re Begleitungen","Accompagnements primaires.") }, "selectOnFocus": true, "anchor": "-20", "store": [['','<br>']].concat(Lino.lino.YesNo) });
    var coaching_type864 = new Lino.RemoteComboFieldElement({ "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Dienst</span>", "name": "coaching_type", "pageSize": 20, "emptyText": "Dienst ausw\u00e4hlen...", "listeners": { "render": Lino.quicktip_renderer("Dienst","Nur Begleitungen dieses Dienstes.") }, "selectOnFocus": true, "hiddenName": "coaching_typeHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/pcsw/Coachings/coaching_type", "method": "GET" }) }) });
    var ending865 = new Lino.TwinCombo({ "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Beendigungsgrund</span>", "name": "ending", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.pcsw.CoachingEndings.detail,Lino.pcsw.CoachingEndings.insert)}, "emptyText": "Beendigungsgrund ausw\u00e4hlen...", "listeners": { "render": Lino.quicktip_renderer("Beendigungsgrund","Nur Begleitungen mit diesem Beendigungsgrund.") }, "selectOnFocus": true, "hiddenName": "endingHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/pcsw/Coachings/ending", "method": "GET" }) }) });
    var main_2_panel866 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 14, "autoHeight": true, "layout": "form", "xtype": "panel", "items": primary_coachings863, "labelAlign": "top" }, { "flex": 42, "autoHeight": true, "layout": "form", "xtype": "panel", "items": coaching_type864, "labelAlign": "top" }, { "flex": 42, "autoHeight": true, "layout": "form", "xtype": "panel", "items": ending865, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 189, "border": false, "anchor": "-20", "labelAlign": "top" });
    this.items = [ main_1_panel857, main_2_panel866 ];
    this.fields = [ start_date852, end_date853, observed_event854, coached_by855, and_coached_by856, primary_coachings863, coaching_type864, ending865 ];
    Lino.pcsw.Coachings.ParamsPanel.superclass.initComponent.call(this);
  }
});


Lino.aids.Grantings.ParamsPanel = Ext.extend(Ext.form.FormPanel,{
  autoHeight: true,
  frame: true,
  layoutConfig: { "align": "stretchmax" },
  hideCheckBoxLabels: true,
  autoScroll: false,
  labelWidth: 135,
  border: false,
  bodyBorder: false,
  labelAlign: "top",
  layout: 'hbox',
  autoHeight: true,
  initComponent : function() {
    var board3411 = new Lino.TwinCombo({ "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Gremium</span>", "name": "board", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.boards.Boards.detail,Lino.boards.Boards.insert)}, "emptyText": "Gremium ausw\u00e4hlen...", "listeners": { "render": Lino.quicktip_renderer("Gremium","Only rows decided by this board.") }, "selectOnFocus": true, "hiddenName": "boardHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/aids/Grantings/board", "method": "GET" }) }) });
    var aid_type3412 = new Lino.TwinCombo({ "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Hilfeart</span>", "name": "aid_type", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.aids.AidTypes.detail,Lino.aids.AidTypes.insert)}, "emptyText": "Hilfeart ausw\u00e4hlen...", "listeners": { "render": Lino.quicktip_renderer("Hilfeart","Only confirmations about this aid type.") }, "selectOnFocus": true, "hiddenName": "aid_typeHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/aids/Grantings/aid_type", "method": "GET" }) }) });
    var user3413 = new Lino.TwinCombo({ "preferred_width": 15, "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Autor</span>", "name": "user", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.users.Users.detail,Lino.users.Users.insert)}, "hiddenName": "userHidden", "listeners": { "render": Lino.quicktip_renderer("Autor","Only rows created by this user.") }, "selectOnFocus": true, "emptyText": "Benutzer ausw\u00e4hlen...", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/aids/Grantings/user", "method": "GET" }) }) });
    var signer3414 = new Lino.TwinCombo({ "preferred_width": 15, "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Unterschreiber</span>", "name": "signer", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.users.Users.detail,Lino.users.Users.insert)}, "hiddenName": "signerHidden", "listeners": { "render": Lino.quicktip_renderer("Unterschreiber","Only rows confirmed (or to be confirmed) by this user.") }, "selectOnFocus": true, "emptyText": "Benutzer ausw\u00e4hlen...", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/aids/Grantings/signer", "method": "GET" }) }) });
    var state3415 = new Lino.ChoicesFieldElement({ "autoHeight": true, "forceSelection": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Zustand</span>", "name": "state", "hiddenName": "stateHidden", "listeners": { "render": Lino.quicktip_renderer("Zustand","Only rows having this state.") }, "selectOnFocus": true, "anchor": "-20", "store": [['','<br>']].concat(Lino.aids.ConfirmationStates) });
    this.items = [ { "flex": 21, "autoHeight": true, "layout": "form", "xtype": "panel", "items": board3411, "labelAlign": "top" }, { "flex": 21, "autoHeight": true, "layout": "form", "xtype": "panel", "items": aid_type3412, "labelAlign": "top" }, { "flex": 21, "autoHeight": true, "layout": "form", "xtype": "panel", "items": user3413, "labelAlign": "top" }, { "flex": 21, "autoHeight": true, "layout": "form", "xtype": "panel", "items": signer3414, "labelAlign": "top" }, { "flex": 14, "autoHeight": true, "layout": "form", "xtype": "panel", "items": state3415, "labelAlign": "top" } ];
    this.fields = [ board3411, aid_type3412, user3413, signer3414, state3415 ];
    Lino.aids.Grantings.ParamsPanel.superclass.initComponent.call(this);
  }
});


Lino.aids.IncomeConfirmations.ParamsPanel = Ext.extend(Ext.form.FormPanel,{
  autoHeight: true,
  frame: true,
  layoutConfig: { "align": "stretchmax" },
  hideCheckBoxLabels: true,
  autoScroll: false,
  labelWidth: 135,
  border: false,
  bodyBorder: false,
  labelAlign: "top",
  layout: 'hbox',
  autoHeight: true,
  initComponent : function() {
    var board4607 = new Lino.TwinCombo({ "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Gremium</span>", "name": "board", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.boards.Boards.detail,Lino.boards.Boards.insert)}, "emptyText": "Gremium ausw\u00e4hlen...", "listeners": { "render": Lino.quicktip_renderer("Gremium","Only rows decided by this board.") }, "selectOnFocus": true, "hiddenName": "boardHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/aids/IncomeConfirmations/board", "method": "GET" }) }) });
    var signer4608 = new Lino.TwinCombo({ "preferred_width": 15, "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Unterschreiber</span>", "name": "signer", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.users.Users.detail,Lino.users.Users.insert)}, "hiddenName": "signerHidden", "listeners": { "render": Lino.quicktip_renderer("Unterschreiber","Only rows confirmed (or to be confirmed) by this user.") }, "selectOnFocus": true, "emptyText": "Benutzer ausw\u00e4hlen...", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/aids/IncomeConfirmations/signer", "method": "GET" }) }) });
    var user4609 = new Lino.TwinCombo({ "preferred_width": 15, "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Autor</span>", "name": "user", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.users.Users.detail,Lino.users.Users.insert)}, "hiddenName": "userHidden", "listeners": { "render": Lino.quicktip_renderer("Autor","Only rows created by this user.") }, "selectOnFocus": true, "emptyText": "Benutzer ausw\u00e4hlen...", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/aids/IncomeConfirmations/user", "method": "GET" }) }) });
    var aid_type4610 = new Lino.TwinCombo({ "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Hilfeart</span>", "name": "aid_type", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.aids.AidTypes.detail,Lino.aids.AidTypes.insert)}, "emptyText": "Hilfeart ausw\u00e4hlen...", "listeners": { "render": Lino.quicktip_renderer("Hilfeart","Only confirmations about this aid type.") }, "selectOnFocus": true, "hiddenName": "aid_typeHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/aids/IncomeConfirmations/aid_type", "method": "GET" }) }) });
    var state4611 = new Lino.ChoicesFieldElement({ "autoHeight": true, "forceSelection": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Zustand</span>", "name": "state", "hiddenName": "stateHidden", "listeners": { "render": Lino.quicktip_renderer("Zustand","Only rows having this state.") }, "selectOnFocus": true, "anchor": "-20", "store": [['','<br>']].concat(Lino.aids.ConfirmationStates) });
    this.items = [ { "flex": 21, "autoHeight": true, "layout": "form", "xtype": "panel", "items": board4607, "labelAlign": "top" }, { "flex": 21, "autoHeight": true, "layout": "form", "xtype": "panel", "items": signer4608, "labelAlign": "top" }, { "flex": 21, "autoHeight": true, "layout": "form", "xtype": "panel", "items": user4609, "labelAlign": "top" }, { "flex": 21, "autoHeight": true, "layout": "form", "xtype": "panel", "items": aid_type4610, "labelAlign": "top" }, { "flex": 14, "autoHeight": true, "layout": "form", "xtype": "panel", "items": state4611, "labelAlign": "top" } ];
    this.fields = [ board4607, signer4608, user4609, aid_type4610, state4611 ];
    Lino.aids.IncomeConfirmations.ParamsPanel.superclass.initComponent.call(this);
  }
});


Lino.integ.Clients.ParamsPanel = Ext.extend(Ext.form.FormPanel,{
  autoScroll: false,
  autoHeight: true,
  border: false,
  hideCheckBoxLabels: true,
  frame: true,
  bodyBorder: false,
  labelAlign: "top",
  layout: 'form',
  autoHeight: true,
  initComponent : function() {
    var client_state4268 = new Lino.ChoicesFieldElement({ "autoHeight": true, "forceSelection": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Zustand</span>", "name": "client_state", "hiddenName": "client_stateHidden", "listeners": { "render": Lino.quicktip_renderer("Zustand","Nur Klienten mit diesem Status (Aktenzustand).") }, "selectOnFocus": true, "anchor": "-20", "store": [['','<br>']].concat(Lino.pcsw.ClientStates) });
    var coached_by4269 = new Lino.TwinCombo({ "preferred_width": 15, "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Begleitet durch</span>", "name": "coached_by", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.users.Users.detail,Lino.users.Users.insert)}, "hiddenName": "coached_byHidden", "listeners": { "render": Lino.quicktip_renderer("Begleitet durch","Nur Klienten, die eine Begleitung mit diesem Benutzer haben.") }, "selectOnFocus": true, "emptyText": "Benutzer ausw\u00e4hlen...", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/integ/Clients/coached_by", "method": "GET" }) }) });
    var and_coached_by4270 = new Lino.TwinCombo({ "preferred_width": 15, "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">und durch</span>", "name": "and_coached_by", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.users.Users.detail,Lino.users.Users.insert)}, "hiddenName": "and_coached_byHidden", "listeners": { "render": Lino.quicktip_renderer("und durch","Nur Klienten, die auch mit diesem Benutzer eine Begleitung haben.") }, "selectOnFocus": true, "emptyText": "Benutzer ausw\u00e4hlen...", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/integ/Clients/and_coached_by", "method": "GET" }) }) });
    var start_date4271 = new Lino.DateField({ "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Periode vom</span>", "name": "start_date", "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Periode vom","Start date of observed period") }, "value": null, "anchor": "-20" });
    var end_date4272 = new Lino.DateField({ "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">bis</span>", "name": "end_date", "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("bis","End date of observed period") }, "value": null, "anchor": "-20" });
    var observed_event4273 = new Lino.ChoicesFieldElement({ "autoHeight": true, "forceSelection": true, "fieldLabel": "Beobachtungskriterium", "name": "observed_event", "hiddenName": "observed_eventHidden", "selectOnFocus": true, "anchor": "-20", "store": [['','<br>']].concat(Lino.pcsw.ClientEvents) });
    var main_1_panel4274 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 11, "autoHeight": true, "layout": "form", "xtype": "panel", "items": client_state4268, "labelAlign": "top" }, { "flex": 20, "autoHeight": true, "layout": "form", "xtype": "panel", "items": coached_by4269, "labelAlign": "top" }, { "flex": 20, "autoHeight": true, "layout": "form", "xtype": "panel", "items": and_coached_by4270, "labelAlign": "top" }, { "flex": 13, "autoHeight": true, "layout": "form", "xtype": "panel", "items": start_date4271, "labelAlign": "top" }, { "flex": 13, "autoHeight": true, "layout": "form", "xtype": "panel", "items": end_date4272, "labelAlign": "top" }, { "flex": 20, "autoHeight": true, "layout": "form", "xtype": "panel", "items": observed_event4273, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 198, "border": false, "anchor": "-20", "labelAlign": "top" });
    var aged_from4281 = new Ext.form.NumberField({ "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Alter von</span>", "name": "aged_from", "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Alter von","Nur Klienten, die mindestens so alt sind.") }, "anchor": "-20" });
    var aged_to4282 = new Ext.form.NumberField({ "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Alter bis</span>", "name": "aged_to", "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Alter bis","Nur Klienten, die h\u00f6chstens so alt sind.") }, "anchor": "-20" });
    var gender4283 = new Lino.ChoicesFieldElement({ "autoHeight": true, "forceSelection": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Geschlecht</span>", "name": "gender", "hiddenName": "genderHidden", "listeners": { "render": Lino.quicktip_renderer("Geschlecht","Show only persons with the given gender.") }, "selectOnFocus": true, "anchor": "-20", "store": [['','<br>']].concat(Lino.lino.Genders) });
    var nationality4284 = new Lino.TwinCombo({ "autoHeight": true, "fieldLabel": "Staatsangeh\u00f6rigkeit", "name": "nationality", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.countries.Countries.detail,Lino.countries.Countries.insert)}, "emptyText": "Land ausw\u00e4hlen...", "selectOnFocus": true, "hiddenName": "nationalityHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/integ/Clients/nationality", "method": "GET" }) }) });
    var also_obsolete4285 = new Ext.form.Checkbox({ "autoHeight": true, "hideLabel": true, "checked": false, "name": "also_obsolete", "listeners": { "render": Lino.quicktip_renderer("Auch veraltete Daten","Show also obsolete records.") }, "boxLabel": "Auch veraltete Daten", "selectOnFocus": true, "anchor": "-20" });
    var main_2_panel4286 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 10, "autoHeight": true, "layout": "form", "xtype": "panel", "items": aged_from4281, "labelAlign": "top" }, { "flex": 10, "autoHeight": true, "layout": "form", "xtype": "panel", "items": aged_to4282, "labelAlign": "top" }, { "flex": 18, "autoHeight": true, "layout": "form", "xtype": "panel", "items": gender4283, "labelAlign": "top" }, { "flex": 40, "autoHeight": true, "layout": "form", "xtype": "panel", "items": nationality4284, "labelAlign": "top" }, { "flex": 20, "autoHeight": true, "layout": "form", "xtype": "panel", "items": also_obsolete4285, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 189, "border": false, "anchor": "-20", "labelAlign": "top" });
    var language4292 = new Lino.TwinCombo({ "autoHeight": true, "fieldLabel": "Sprachkenntnis", "name": "language", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.languages.Languages.detail,Lino.languages.Languages.insert)}, "emptyText": "Sprache ausw\u00e4hlen...", "selectOnFocus": true, "hiddenName": "languageHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/integ/Clients/language", "method": "GET" }) }) });
    var wanted_property4293 = new Lino.TwinCombo({ "autoHeight": true, "fieldLabel": "Erw\u00fcnschte Eigenschaft", "name": "wanted_property", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.properties.Properties.detail,Lino.properties.Properties.insert)}, "emptyText": "Eigenschaft ausw\u00e4hlen...", "selectOnFocus": true, "hiddenName": "wanted_propertyHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/integ/Clients/wanted_property", "method": "GET" }) }) });
    var group4294 = new Lino.RemoteComboFieldElement({ "autoHeight": true, "fieldLabel": "Integrationsphase", "name": "group", "pageSize": 20, "emptyText": "Integrationsphase ausw\u00e4hlen...", "selectOnFocus": true, "hiddenName": "groupHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/integ/Clients/group", "method": "GET" }) }) });
    var only_active4295 = new Ext.form.Checkbox({ "autoHeight": true, "hideLabel": true, "checked": false, "name": "only_active", "listeners": { "render": Lino.quicktip_renderer("Nur aktive Klienten","Show only clients in 'active' integration phases") }, "boxLabel": "Nur aktive Klienten", "selectOnFocus": true, "anchor": "-20" });
    var only_primary4296 = new Ext.form.Checkbox({ "autoHeight": true, "hideLabel": true, "checked": false, "name": "only_primary", "listeners": { "render": Lino.quicktip_renderer("Nur prim\u00e4re Begleitungen","Nur Klienten, die eine effektive <b>prim\u00e4re</b> Begleitung haben.") }, "boxLabel": "Nur prim\u00e4re Begleitungen", "selectOnFocus": true, "anchor": "-20" });
    var main_3_panel4297 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 25, "autoHeight": true, "layout": "form", "xtype": "panel", "items": language4292, "labelAlign": "top" }, { "flex": 25, "autoHeight": true, "layout": "form", "xtype": "panel", "items": wanted_property4293, "labelAlign": "top" }, { "flex": 25, "autoHeight": true, "layout": "form", "xtype": "panel", "items": group4294, "labelAlign": "top" }, { "flex": 12, "autoHeight": true, "layout": "form", "xtype": "panel", "items": only_active4295, "labelAlign": "top" }, { "flex": 12, "autoHeight": true, "layout": "form", "xtype": "panel", "items": only_primary4296, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 225, "border": false, "anchor": "-20", "labelAlign": "top" });
    this.items = [ main_1_panel4274, main_2_panel4286, main_3_panel4297 ];
    this.fields = [ client_state4268, coached_by4269, and_coached_by4270, start_date4271, end_date4272, observed_event4273, aged_from4281, aged_to4282, gender4283, nationality4284, also_obsolete4285, language4292, wanted_property4293, group4294, only_active4295, only_primary4296 ];
    Lino.integ.Clients.ParamsPanel.superclass.initComponent.call(this);
  }
});


Lino.newcomers.AvailableCoaches.ParamsPanel = Ext.extend(Ext.form.FormPanel,{
  autoHeight: true,
  frame: true,
  layoutConfig: { "align": "stretchmax" },
  hideCheckBoxLabels: true,
  autoScroll: false,
  labelWidth: 189,
  border: false,
  bodyBorder: false,
  labelAlign: "top",
  layout: 'hbox',
  autoHeight: true,
  initComponent : function() {
    var for_client3357 = new Lino.TwinCombo({ "preferred_width": 20, "autoHeight": true, "fieldLabel": "Zeige Vorschl\u00e4ge f\u00fcr", "name": "for_client", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.pcsw.Clients.detail,Lino.pcsw.Clients.insert)}, "hiddenName": "for_clientHidden", "selectOnFocus": true, "emptyText": "Klient ausw\u00e4hlen...", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/newcomers/AvailableCoaches/for_client", "method": "GET" }) }) });
    var since3358 = new Lino.DateField({ "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Neue Klienten seit</span>", "name": "since", "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Neue Klienten seit","Neue Klienten sind die, deren Begleitung nach diesem Datum beginnt") }, "anchor": "-20" });
    this.items = [ { "flex": 60, "autoHeight": true, "layout": "form", "xtype": "panel", "items": for_client3357, "labelAlign": "top" }, { "flex": 39, "autoHeight": true, "layout": "form", "xtype": "panel", "items": since3358, "labelAlign": "top" } ];
    this.fields = [ for_client3357, since3358 ];
    Lino.newcomers.AvailableCoaches.ParamsPanel.superclass.initComponent.call(this);
  }
});


Lino.jobs.OldJobsOverview.ParamsPanel = Ext.extend(Ext.form.FormPanel,{
  autoHeight: true,
  frame: true,
  layoutConfig: { "align": "stretchmax" },
  hideCheckBoxLabels: true,
  autoScroll: false,
  labelWidth: 216,
  border: false,
  bodyBorder: false,
  labelAlign: "top",
  layout: 'hbox',
  autoHeight: true,
  initComponent : function() {
    var contract_type5098 = new Lino.TwinCombo({ "preferred_width": 20, "autoHeight": true, "fieldLabel": "Art.60\u00a77-Konventionsart", "name": "contract_type", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.jobs.ContractTypes.detail,Lino.jobs.ContractTypes.insert)}, "hiddenName": "contract_typeHidden", "selectOnFocus": true, "emptyText": "Art.60\u00a77-Konventionsart ausw\u00e4hlen...", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/jobs/OldJobsOverview/contract_type", "method": "GET" }) }) });
    var date5099 = new Lino.DateField({ "selectOnFocus": true, "autoHeight": true, "fieldLabel": "Datum", "anchor": "-20", "name": "date" });
    var job_type5100 = new Lino.TwinCombo({ "autoHeight": true, "fieldLabel": "Stellenart", "name": "job_type", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.jobs.JobTypes.detail,Lino.jobs.JobTypes.insert)}, "emptyText": "Stellenart ausw\u00e4hlen...", "selectOnFocus": true, "hiddenName": "job_typeHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/jobs/OldJobsOverview/job_type", "method": "GET" }) }) });
    this.items = [ { "flex": 37, "autoHeight": true, "layout": "form", "xtype": "panel", "items": contract_type5098, "labelAlign": "top" }, { "flex": 24, "autoHeight": true, "layout": "form", "xtype": "panel", "items": date5099, "labelAlign": "top" }, { "flex": 37, "autoHeight": true, "layout": "form", "xtype": "panel", "items": job_type5100, "labelAlign": "top" } ];
    this.fields = [ contract_type5098, date5099, job_type5100 ];
    Lino.jobs.OldJobsOverview.ParamsPanel.superclass.initComponent.call(this);
  }
});


Lino.cal.Guests.wf2_ActionFormPanel = Ext.extend(Lino.ActionFormPanel,{
  autoScroll: false,
  border: false,
  layout: "vbox",
  labelWidth: 270,
  hideCheckBoxLabels: true,
  frame: true,
  layoutConfig: { "align": "stretch" },
  bodyBorder: false,
  labelAlign: "top",
  action_name: 'wf2',
  ls_url: "/cal/Guests",
  window_title: "Absagen",
  before_row_edit : function(record) {
  },
  initComponent : function() {
    this.notify_subject15 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Kurzbeschreibung", "name": "notify_subject", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    this.notify_body16 = new Ext.form.TextArea({ "selectOnFocus": true, "fieldLabel": "Beschreibung", "anchor": "-20 -10", "growMax": 2000, "name": "notify_body" });
    this.notify_silent17 = new Ext.form.Checkbox({ "boxLabel": "Keine Benachrichtigung per E-Mail schicken", "autoHeight": true, "hideLabel": true, "checked": false, "name": "notify_silent", "selectOnFocus": true, "anchor": "-20" });
    this.items = [ { "items": this.notify_subject15, "autoHeight": true, "layout": "form", "xtype": "panel", "labelAlign": "top" }, { "items": this.notify_body16, "labelAlign": "top", "layout": "form", "xtype": "panel", "flex": 71 }, { "items": this.notify_silent17, "autoHeight": true, "layout": "form", "xtype": "panel", "labelAlign": "top" } ];
    this.fields = [ this.notify_subject15, this.notify_body16, this.notify_silent17 ];
    Lino.cal.Guests.wf2_ActionFormPanel.superclass.initComponent.call(this);
  }
});


Lino.contacts.Persons.create_household_ActionFormPanel = Ext.extend(Lino.ActionFormPanel,{
  autoScroll: false,
  autoHeight: true,
  border: false,
  layout: "form",
  labelWidth: 162,
  hideCheckBoxLabels: true,
  frame: true,
  bodyBorder: false,
  labelAlign: "top",
  action_name: 'create_household',
  ls_url: "/contacts/Persons",
  window_title: "Haushalt erstellen",
  before_row_edit : function(record) {
  },
  autoHeight: true,
  initComponent : function() {
    this.partner29 = new Lino.TwinCombo({ "preferred_width": 20, "autoHeight": true, "fieldLabel": "Partner", "name": "partner", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.contacts.Persons.detail,Lino.contacts.Persons.insert)}, "hiddenName": "partnerHidden", "selectOnFocus": true, "emptyText": "Person ausw\u00e4hlen...", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/apchoices/contacts/Persons/create_household/partner", "method": "GET" }) }) });
    this.type30 = new Lino.TwinCombo({ "autoHeight": true, "fieldLabel": "Haushaltsart", "allowBlank": false, "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.households.Types.detail,Lino.households.Types.insert)}, "emptyText": "Haushaltsart ausw\u00e4hlen...", "selectOnFocus": true, "hiddenName": "typeHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/apchoices/contacts/Persons/create_household/type", "method": "GET" }) }), "name": "type" });
    this.head31 = new Lino.TwinCombo({ "preferred_width": 20, "autoHeight": true, "fieldLabel": "Vorstand", "allowBlank": false, "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.contacts.Persons.detail,Lino.contacts.Persons.insert)}, "emptyText": "Person ausw\u00e4hlen...", "selectOnFocus": true, "hiddenName": "headHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/apchoices/contacts/Persons/create_household/head", "method": "GET" }) }), "name": "head" });
    this.items = [ { "autoHeight": true, "layout": "form", "xtype": "panel", "items": this.partner29, "anchor": "-20", "labelAlign": "top" }, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": this.type30, "anchor": "-20", "labelAlign": "top" }, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": this.head31, "anchor": "-20", "labelAlign": "top" } ];
    this.fields = [ this.partner29, this.type30, this.head31 ];
    Lino.contacts.Persons.create_household_ActionFormPanel.superclass.initComponent.call(this);
  }
});


Lino.contacts.Companies.merge_row_ActionFormPanel = Ext.extend(Lino.ActionFormPanel,{
  autoScroll: false,
  autoHeight: true,
  border: false,
  layout: "form",
  labelWidth: 72,
  hideCheckBoxLabels: true,
  frame: true,
  bodyBorder: false,
  labelAlign: "top",
  action_name: 'merge_row',
  ls_url: "/contacts/Companies",
  window_title: "Merge",
  before_row_edit : function(record) {
  },
  autoHeight: true,
  initComponent : function() {
    this.merge_to36 = new Lino.TwinCombo({ "preferred_width": 20, "autoHeight": true, "fieldLabel": "into...", "allowBlank": false, "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.contacts.Companies.detail,Lino.contacts.Companies.insert)}, "emptyText": "Organisation ausw\u00e4hlen...", "selectOnFocus": true, "hiddenName": "merge_toHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/apchoices/contacts/Companies/merge_row/merge_to", "method": "GET" }) }), "name": "merge_to" });
    this.reason37 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Reason", "name": "reason", "maxLength": 100, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    this.items = [ { "autoHeight": true, "layout": "form", "xtype": "panel", "items": this.merge_to36, "anchor": "-20", "labelAlign": "top" }, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": this.reason37, "anchor": "-20", "labelAlign": "top" } ];
    this.fields = [ this.merge_to36, this.reason37 ];
    Lino.contacts.Companies.merge_row_ActionFormPanel.superclass.initComponent.call(this);
  }
});


Lino.reception.Clients.create_visit_ActionFormPanel = Ext.extend(Lino.ActionFormPanel,{
  autoScroll: false,
  autoHeight: true,
  border: false,
  layout: "form",
  labelWidth: 63,
  hideCheckBoxLabels: true,
  frame: true,
  bodyBorder: false,
  labelAlign: "top",
  action_name: 'create_visit',
  ls_url: "/reception/Clients",
  window_title: "Visite erstellen",
  before_row_edit : function(record) {
  },
  autoHeight: true,
  initComponent : function() {
    this.user74 = new Lino.TwinCombo({ "preferred_width": 15, "autoHeight": true, "fieldLabel": "Benutzer", "allowBlank": false, "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.users.Users.detail,Lino.users.Users.insert)}, "emptyText": "Benutzer ausw\u00e4hlen...", "selectOnFocus": true, "hiddenName": "userHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/apchoices/reception/Clients/create_visit/user", "method": "GET" }) }), "name": "user" });
    this.summary75 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Begr\u00fcndung", "name": "summary", "maxLength": null, "selectOnFocus": true, "anchor": "-20" });
    this.items = [ { "autoHeight": true, "layout": "form", "xtype": "panel", "items": this.user74, "anchor": "-20", "labelAlign": "top" }, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": this.summary75, "anchor": "-20", "labelAlign": "top" } ];
    this.fields = [ this.user74, this.summary75 ];
    Lino.reception.Clients.create_visit_ActionFormPanel.superclass.initComponent.call(this);
  }
});


Lino.pcsw.Clients.wf1_ActionFormPanel = Ext.extend(Lino.ActionFormPanel,{
  autoScroll: false,
  border: false,
  layout: "vbox",
  labelWidth: 63,
  hideCheckBoxLabels: true,
  frame: true,
  layoutConfig: { "align": "stretch" },
  bodyBorder: false,
  labelAlign: "top",
  action_name: 'wf1',
  ls_url: "/pcsw/Clients",
  window_title: "Ablehnen",
  before_row_edit : function(record) {
  },
  initComponent : function() {
    this.reason46 = new Lino.ChoicesFieldElement({ "autoHeight": true, "forceSelection": true, "fieldLabel": "reason", "allowBlank": false, "hiddenName": "reasonHidden", "selectOnFocus": true, "anchor": "-20", "store": Lino.pcsw.RefusalReasons, "name": "reason" });
    this.remark47 = new Ext.form.TextArea({ "selectOnFocus": true, "fieldLabel": "Bemerkung", "anchor": "-20 -10", "growMax": 2000, "name": "remark" });
    this.items = [ { "items": this.reason46, "autoHeight": true, "layout": "form", "xtype": "panel", "labelAlign": "top" }, { "items": this.remark47, "labelAlign": "top", "layout": "form", "xtype": "panel", "flex": 83 } ];
    this.fields = [ this.reason46, this.remark47 ];
    Lino.pcsw.Clients.wf1_ActionFormPanel.superclass.initComponent.call(this);
  }
});


Lino.newcomers.AvailableCoachesByClient.assign_coach_ActionFormPanel = Ext.extend(Lino.ActionFormPanel,{
  autoScroll: false,
  border: false,
  layout: "vbox",
  labelWidth: 270,
  hideCheckBoxLabels: true,
  frame: true,
  layoutConfig: { "align": "stretch" },
  bodyBorder: false,
  labelAlign: "top",
  action_name: 'assign_coach',
  ls_url: "/newcomers/AvailableCoachesByClient",
  window_title: "Zuweisen",
  before_row_edit : function(record) {
  },
  initComponent : function() {
    this.notify_subject79 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Kurzbeschreibung", "name": "notify_subject", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    this.notify_body80 = new Ext.form.TextArea({ "selectOnFocus": true, "fieldLabel": "Beschreibung", "anchor": "-20 -10", "growMax": 2000, "name": "notify_body" });
    this.notify_silent81 = new Ext.form.Checkbox({ "boxLabel": "Keine Benachrichtigung per E-Mail schicken", "autoHeight": true, "hideLabel": true, "checked": false, "name": "notify_silent", "selectOnFocus": true, "anchor": "-20" });
    this.items = [ { "items": this.notify_subject79, "autoHeight": true, "layout": "form", "xtype": "panel", "labelAlign": "top" }, { "items": this.notify_body80, "labelAlign": "top", "layout": "form", "xtype": "panel", "flex": 71 }, { "items": this.notify_silent81, "autoHeight": true, "layout": "form", "xtype": "panel", "labelAlign": "top" } ];
    this.fields = [ this.notify_subject79, this.notify_body80, this.notify_silent81 ];
    Lino.newcomers.AvailableCoachesByClient.assign_coach_ActionFormPanel.superclass.initComponent.call(this);
  }
});


Lino.pcsw.Coachings.create_visit_ActionFormPanel = Ext.extend(Lino.ActionFormPanel,{
  autoScroll: false,
  autoHeight: true,
  border: false,
  layout: "form",
  labelWidth: 63,
  hideCheckBoxLabels: true,
  frame: true,
  bodyBorder: false,
  labelAlign: "top",
  action_name: 'create_visit',
  ls_url: "/pcsw/Coachings",
  window_title: "Visite erstellen",
  before_row_edit : function(record) {
  },
  autoHeight: true,
  initComponent : function() {
    this.user41 = new Lino.TwinCombo({ "preferred_width": 15, "autoHeight": true, "fieldLabel": "Benutzer", "allowBlank": false, "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.users.Users.detail,Lino.users.Users.insert)}, "emptyText": "Benutzer ausw\u00e4hlen...", "selectOnFocus": true, "hiddenName": "userHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/apchoices/pcsw/Coachings/create_visit/user", "method": "GET" }) }), "name": "user" });
    this.summary42 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Begr\u00fcndung", "name": "summary", "maxLength": null, "selectOnFocus": true, "anchor": "-20" });
    this.items = [ { "autoHeight": true, "layout": "form", "xtype": "panel", "items": this.user41, "anchor": "-20", "labelAlign": "top" }, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": this.summary42, "anchor": "-20", "labelAlign": "top" } ];
    this.fields = [ this.user41, this.summary42 ];
    Lino.pcsw.Coachings.create_visit_ActionFormPanel.superclass.initComponent.call(this);
  }
});


Lino.cal.Guests.wf1_ActionFormPanel = Ext.extend(Lino.ActionFormPanel,{
  autoScroll: false,
  border: false,
  layout: "vbox",
  labelWidth: 270,
  hideCheckBoxLabels: true,
  frame: true,
  layoutConfig: { "align": "stretch" },
  bodyBorder: false,
  labelAlign: "top",
  action_name: 'wf1',
  ls_url: "/cal/Guests",
  window_title: "Zusagen",
  before_row_edit : function(record) {
  },
  initComponent : function() {
    this.notify_subject8 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Kurzbeschreibung", "name": "notify_subject", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    this.notify_body9 = new Ext.form.TextArea({ "selectOnFocus": true, "fieldLabel": "Beschreibung", "anchor": "-20 -10", "growMax": 2000, "name": "notify_body" });
    this.notify_silent10 = new Ext.form.Checkbox({ "boxLabel": "Keine Benachrichtigung per E-Mail schicken", "autoHeight": true, "hideLabel": true, "checked": false, "name": "notify_silent", "selectOnFocus": true, "anchor": "-20" });
    this.items = [ { "items": this.notify_subject8, "autoHeight": true, "layout": "form", "xtype": "panel", "labelAlign": "top" }, { "items": this.notify_body9, "labelAlign": "top", "layout": "form", "xtype": "panel", "flex": 71 }, { "items": this.notify_silent10, "autoHeight": true, "layout": "form", "xtype": "panel", "labelAlign": "top" } ];
    this.fields = [ this.notify_subject8, this.notify_body9, this.notify_silent10 ];
    Lino.cal.Guests.wf1_ActionFormPanel.superclass.initComponent.call(this);
  }
});


Lino.pcsw.Clients.merge_row_ActionFormPanel = Ext.extend(Lino.ActionFormPanel,{
  autoScroll: false,
  autoHeight: true,
  border: false,
  layout: "form",
  labelWidth: 72,
  hideCheckBoxLabels: true,
  frame: true,
  bodyBorder: false,
  labelAlign: "top",
  action_name: 'merge_row',
  ls_url: "/pcsw/Clients",
  window_title: "Merge",
  before_row_edit : function(record) {
  },
  autoHeight: true,
  initComponent : function() {
    this.merge_to51 = new Lino.TwinCombo({ "preferred_width": 20, "autoHeight": true, "fieldLabel": "into...", "allowBlank": false, "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.pcsw.Clients.detail,Lino.pcsw.Clients.insert)}, "emptyText": "Klient ausw\u00e4hlen...", "selectOnFocus": true, "hiddenName": "merge_toHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/apchoices/pcsw/Clients/merge_row/merge_to", "method": "GET" }) }), "name": "merge_to" });
    this.aids_SimpleConfirmation52 = new Ext.form.Checkbox({ "boxLabel": "Einfache Bescheinigungen", "autoHeight": true, "hideLabel": true, "checked": false, "name": "aids_SimpleConfirmation", "selectOnFocus": true, "anchor": "-20" });
    this.aids_IncomeConfirmation53 = new Ext.form.Checkbox({ "boxLabel": "Einkommensbescheinigungen", "autoHeight": true, "hideLabel": true, "checked": false, "name": "aids_IncomeConfirmation", "selectOnFocus": true, "anchor": "-20" });
    var keep_volatiles_1_panel54 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": this.aids_SimpleConfirmation52, "labelAlign": "top" }, { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": this.aids_IncomeConfirmation53, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 189, "border": false, "anchor": "-20", "labelAlign": "top" });
    this.aids_RefundConfirmation57 = new Ext.form.Checkbox({ "boxLabel": "Kosten\u00fcbernahmescheine", "autoHeight": true, "hideLabel": true, "checked": false, "name": "aids_RefundConfirmation", "selectOnFocus": true, "anchor": "-20" });
    this.cv_LanguageKnowledge58 = new Ext.form.Checkbox({ "boxLabel": "Sprachkenntnisse", "autoHeight": true, "hideLabel": true, "checked": false, "name": "cv_LanguageKnowledge", "selectOnFocus": true, "anchor": "-20" });
    var keep_volatiles_2_panel59 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": this.aids_RefundConfirmation57, "labelAlign": "top" }, { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": this.cv_LanguageKnowledge58, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 189, "border": false, "anchor": "-20", "labelAlign": "top" });
    this.pcsw_Coaching62 = new Ext.form.Checkbox({ "boxLabel": "Begleitungen", "autoHeight": true, "hideLabel": true, "checked": false, "name": "pcsw_Coaching", "selectOnFocus": true, "anchor": "-20" });
    this.pcsw_Dispense63 = new Ext.form.Checkbox({ "boxLabel": "Dispenzen", "autoHeight": true, "hideLabel": true, "checked": false, "name": "pcsw_Dispense", "selectOnFocus": true, "anchor": "-20" });
    var keep_volatiles_3_panel64 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": this.pcsw_Coaching62, "labelAlign": "top" }, { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": this.pcsw_Dispense63, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 90, "border": false, "anchor": "-20", "labelAlign": "top" });
    this.properties_PersonProperty67 = new Ext.form.Checkbox({ "boxLabel": "Eigenschaften", "autoHeight": true, "hideLabel": true, "checked": false, "name": "properties_PersonProperty", "selectOnFocus": true, "anchor": "-20" });
    var keep_volatiles_panel68 = new Ext.form.FieldSet({ "autoHeight": true, "layout": "form", "title": "Also reassign volatile related objects", "items": [ keep_volatiles_1_panel54, keep_volatiles_2_panel59, keep_volatiles_3_panel64, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": this.properties_PersonProperty67, "anchor": "-20", "labelAlign": "top" } ], "frame": true, "bodyBorder": false, "autoScroll": false, "hideCheckBoxLabels": true, "labelWidth": 99, "border": false, "anchor": "-20", "labelAlign": "top" });
    this.reason70 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Reason", "name": "reason", "maxLength": 100, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    this.items = [ { "autoHeight": true, "layout": "form", "xtype": "panel", "items": this.merge_to51, "anchor": "-20", "labelAlign": "top" }, keep_volatiles_panel68, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": this.reason70, "anchor": "-20", "labelAlign": "top" } ];
    this.fields = [ this.merge_to51, this.aids_SimpleConfirmation52, this.aids_IncomeConfirmation53, this.aids_RefundConfirmation57, this.cv_LanguageKnowledge58, this.pcsw_Coaching62, this.pcsw_Dispense63, this.properties_PersonProperty67, this.reason70 ];
    Lino.pcsw.Clients.merge_row_ActionFormPanel.superclass.initComponent.call(this);
  }
});


Lino.polls.Responses.toggle_choice_ActionFormPanel = Ext.extend(Lino.ActionFormPanel,{
  autoScroll: false,
  autoHeight: true,
  border: false,
  layout: "form",
  labelWidth: 81,
  hideCheckBoxLabels: true,
  frame: true,
  bodyBorder: false,
  labelAlign: "top",
  action_name: 'toggle_choice',
  ls_url: "/polls/Responses",
  window_title: "toggle_choice",
  before_row_edit : function(record) {
  },
  autoHeight: true,
  initComponent : function() {
    this.question86 = new Lino.RemoteComboFieldElement({ "autoHeight": true, "fieldLabel": "Question", "allowBlank": false, "pageSize": 20, "emptyText": "Question ausw\u00e4hlen...", "selectOnFocus": true, "hiddenName": "questionHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/apchoices/polls/Responses/toggle_choice/question", "method": "GET" }) }), "name": "question" });
    this.choice87 = new Lino.RemoteComboFieldElement({ "autoHeight": true, "fieldLabel": "Choice", "allowBlank": false, "pageSize": 20, "emptyText": "Choice ausw\u00e4hlen...", "selectOnFocus": true, "hiddenName": "choiceHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/apchoices/polls/Responses/toggle_choice/choice", "method": "GET" }) }), "name": "choice" });
    this.items = [ { "autoHeight": true, "layout": "form", "xtype": "panel", "items": this.question86, "anchor": "-20", "labelAlign": "top" }, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": this.choice87, "anchor": "-20", "labelAlign": "top" } ];
    this.fields = [ this.question86, this.choice87 ];
    Lino.polls.Responses.toggle_choice_ActionFormPanel.superclass.initComponent.call(this);
  }
});


Lino.users.Users.change_password_ActionFormPanel = Ext.extend(Lino.ActionFormPanel,{
  autoScroll: false,
  autoHeight: true,
  border: false,
  layout: "form",
  labelWidth: 171,
  hideCheckBoxLabels: true,
  frame: true,
  bodyBorder: false,
  labelAlign: "top",
  action_name: 'change_password',
  ls_url: "/users/Users",
  window_title: "Passwort \u00e4ndern",
  before_row_edit : function(record) {
  },
  autoHeight: true,
  initComponent : function() {
    this.current1 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Current password", "name": "current", "maxLength": null, "selectOnFocus": true, "anchor": "-20", "inputType": "password" });
    this.new12 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "New password", "name": "new1", "maxLength": null, "selectOnFocus": true, "anchor": "-20", "inputType": "password" });
    this.new23 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "New password again", "name": "new2", "maxLength": null, "selectOnFocus": true, "anchor": "-20", "inputType": "password" });
    this.items = [ { "autoHeight": true, "layout": "form", "xtype": "panel", "items": this.current1, "anchor": "-20", "labelAlign": "top" }, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": this.new12, "anchor": "-20", "labelAlign": "top" }, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": this.new23, "anchor": "-20", "labelAlign": "top" } ];
    this.fields = [ this.current1, this.new12, this.new23 ];
    Lino.users.Users.change_password_ActionFormPanel.superclass.initComponent.call(this);
  }
});


Lino.cal.Guests.checkin_ActionFormPanel = Ext.extend(Lino.ActionFormPanel,{
  autoScroll: false,
  border: false,
  layout: "vbox",
  labelWidth: 270,
  hideCheckBoxLabels: true,
  frame: true,
  layoutConfig: { "align": "stretch" },
  bodyBorder: false,
  labelAlign: "top",
  action_name: 'checkin',
  ls_url: "/cal/Guests",
  window_title: "Einchecken",
  before_row_edit : function(record) {
  },
  initComponent : function() {
    this.notify_subject22 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Kurzbeschreibung", "name": "notify_subject", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    this.notify_body23 = new Ext.form.TextArea({ "selectOnFocus": true, "fieldLabel": "Beschreibung", "anchor": "-20 -10", "growMax": 2000, "name": "notify_body" });
    this.notify_silent24 = new Ext.form.Checkbox({ "boxLabel": "Keine Benachrichtigung per E-Mail schicken", "autoHeight": true, "hideLabel": true, "checked": false, "name": "notify_silent", "selectOnFocus": true, "anchor": "-20" });
    this.items = [ { "items": this.notify_subject22, "autoHeight": true, "layout": "form", "xtype": "panel", "labelAlign": "top" }, { "items": this.notify_body23, "labelAlign": "top", "layout": "form", "xtype": "panel", "flex": 71 }, { "items": this.notify_silent24, "autoHeight": true, "layout": "form", "xtype": "panel", "labelAlign": "top" } ];
    this.fields = [ this.notify_subject22, this.notify_body23, this.notify_silent24 ];
    Lino.cal.Guests.checkin_ActionFormPanel.superclass.initComponent.call(this);
  }
});


Lino.users.Users.InsertFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  autoHeight: true,
  content_type: 6,
  initComponent : function() {
    var username874 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Benutzername</span>", "name": "username", "listeners": { "render": Lino.quicktip_renderer("Benutzername","Required. Must be unique.") }, "maxLength": 30, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var email875 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "e-mail address", "name": "email", "maxLength": 75, "selectOnFocus": true, "anchor": "-20" });
    var main_1_panel876 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": username874, "labelAlign": "top" }, { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": email875, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 135, "border": false, "anchor": "-20", "labelAlign": "top" });
    var first_name879 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Vorname", "name": "first_name", "maxLength": 30, "selectOnFocus": true, "anchor": "-20" });
    var last_name880 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Familienname", "name": "last_name", "maxLength": 30, "selectOnFocus": true, "anchor": "-20" });
    var main_2_panel881 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": first_name879, "labelAlign": "top" }, { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": last_name880, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 117, "border": false, "anchor": "-20", "labelAlign": "top" });
    var partner884 = new Lino.TwinCombo({ "preferred_width": 20, "autoHeight": true, "fieldLabel": "Partner", "name": "partner", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.contacts.Partners.detail,Lino.contacts.Partners.insert)}, "hiddenName": "partnerHidden", "selectOnFocus": true, "emptyText": "Partner ausw\u00e4hlen...", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/users/Users/partner", "method": "GET" }) }) });
    var language885 = new Lino.ChoicesFieldElement({ "autoHeight": true, "fieldLabel": "Sprache", "name": "language", "selectOnFocus": true, "anchor": "-20", "store": [ [ "en", "Englisch" ], [ "fr", "Franz\u00f6sisch" ], [ "de", "Deutsch" ], [ "nl", "Niederl\u00e4ndisch" ] ], "hiddenName": "languageHidden" });
    var profile886 = new Lino.ChoicesFieldElement({ "autoHeight": true, "forceSelection": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Benutzerprofil</span>", "name": "profile", "hiddenName": "profileHidden", "listeners": { "render": Lino.quicktip_renderer("Benutzerprofil","Users with an empty `profile` field are considered inactive and cannot log in.") }, "selectOnFocus": true, "anchor": "-20", "store": [['','<br>']].concat(Lino.users.UserProfiles) });
    var main_4_panel887 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 35, "autoHeight": true, "layout": "form", "xtype": "panel", "items": language885, "labelAlign": "top" }, { "flex": 64, "autoHeight": true, "layout": "form", "xtype": "panel", "items": profile886, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 135, "border": false, "anchor": "-20", "labelAlign": "top" });
    var main_panel890 = new Ext.Panel({ "hideCheckBoxLabels": true, "autoHeight": true, "border": false, "layout": "form", "labelWidth": 72, "autoScroll": false, "items": [ main_1_panel876, main_2_panel881, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": partner884, "anchor": "-20", "labelAlign": "top" }, main_4_panel887 ], "frame": true, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel890;
    this.before_row_edit = function(record) {
    }
    Lino.users.Users.InsertFormPanel.superclass.initComponent.call(this);
  }
});


Lino.outbox.Mails.InsertFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 25,
  initComponent : function() {
    var project521 = new Lino.TwinCombo({ "preferred_width": 20, "autoHeight": true, "fieldLabel": "Klient", "name": "project", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.pcsw.Clients.detail,Lino.pcsw.Clients.insert)}, "hiddenName": "projectHidden", "selectOnFocus": true, "emptyText": "Klient ausw\u00e4hlen...", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/outbox/Mails/project", "method": "GET" }) }) });
    var subject522 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Betreff", "name": "subject", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var body523 = new Lino.RichTextPanel({ "selectOnFocus": true, "flex": 71, "containing_panel": this, "name": "body", "title": "Inhalt" });
    var main_panel524 = new Ext.Panel({ "autoScroll": false, "border": false, "layout": "vbox", "labelWidth": 72, "hideCheckBoxLabels": true, "items": [ { "items": project521, "autoHeight": true, "layout": "form", "xtype": "panel", "labelAlign": "top" }, { "items": subject522, "autoHeight": true, "layout": "form", "xtype": "panel", "labelAlign": "top" }, body523 ], "frame": true, "layoutConfig": { "align": "stretch" }, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel524;
    this.before_row_edit = function(record) {
      body523.refresh();
    }
    Lino.outbox.Mails.InsertFormPanel.superclass.initComponent.call(this);
  }
});


Lino.cal.Calendars.InsertFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  autoHeight: true,
  content_type: 36,
  initComponent : function() {
    var name1097 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Bezeichnung", "name": "name", "maxLength": 200, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var name_fr1098 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Bezeichnung (fr)", "name": "name_fr", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var name_de1099 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Bezeichnung (de)", "name": "name_de", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var name_nl1100 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Bezeichnung (nl)", "name": "name_nl", "maxLength": 200, "selectOnFocus": true, "hidden": true, "anchor": "-20" });
    var main_1_panel1101 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 25, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name1097, "labelAlign": "top" }, { "flex": 25, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_fr1098, "labelAlign": "top" }, { "flex": 25, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_de1099, "labelAlign": "top" }, { "flex": 25, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_nl1100, "hidden": true, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 153, "border": false, "anchor": "-20", "labelAlign": "top" });
    var color1106 = new Ext.form.NumberField({ "autoHeight": true, "fieldLabel": "Farbe", "name": "color", "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var main_panel1107 = new Ext.Panel({ "hideCheckBoxLabels": true, "autoHeight": true, "border": false, "layout": "form", "labelWidth": 54, "autoScroll": false, "items": [ main_1_panel1101, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": color1106, "anchor": "-20", "labelAlign": "top" } ], "frame": true, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel1107;
    this.before_row_edit = function(record) {
    }
    Lino.cal.Calendars.InsertFormPanel.superclass.initComponent.call(this);
  }
});


Lino.courses.CourseContents.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 92,
  initComponent : function() {
    var id4245 = new Ext.form.NumberField({ "selectOnFocus": true, "autoHeight": true, "fieldLabel": "ID", "anchor": "-20", "name": "id" });
    var name4246 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Name", "name": "name", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var main_1_panel4247 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 19, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id4245, "labelAlign": "top" }, { "flex": 80, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name4246, "labelAlign": "top" } ], "region": "north", "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "split": true, "autoScroll": false, "labelWidth": 45, "border": false, "frame": false, "labelAlign": "top" });
    var courses_CourseOffersByContent_grid4255 = new Lino.courses.CourseOffersByContent.GridPanel({ "flex": 5, "hide_top_toolbar": true, "containing_panel": this, "region": "center", "preview_limit": 15, "master_panel": this, "split": true, "tools": [ Lino.show_in_own_window_button(Lino.courses.CourseOffersByContent.grid) ] });
    var courses_CourseRequestsByContent_grid4266 = new Lino.courses.CourseRequestsByContent.GridPanel({ "flex": 5, "hide_top_toolbar": true, "containing_panel": this, "region": "south", "preview_limit": 15, "master_panel": this, "split": true, "tools": [ Lino.show_in_own_window_button(Lino.courses.CourseRequestsByContent.grid) ] });
    var main_panel4267 = new Lino.VBorderPanel({ "autoScroll": false, "border": false, "hideCheckBoxLabels": true, "items": [ main_1_panel4247, courses_CourseOffersByContent_grid4255, courses_CourseRequestsByContent_grid4266 ], "frame": true, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel4267;
    this.before_row_edit = function(record) {
      courses_CourseOffersByContent_grid4255.on_master_changed();
      courses_CourseRequestsByContent_grid4266.on_master_changed();
    }
    Lino.courses.CourseContents.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.cbss.RetrieveTIGroupsRequests.InsertFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  autoHeight: true,
  content_type: 98,
  initComponent : function() {
    var person139 = new Lino.TwinCombo({ "preferred_width": 20, "autoHeight": true, "fieldLabel": "Klient", "allowBlank": false, "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.pcsw.Clients.detail,Lino.pcsw.Clients.insert)}, "emptyText": "Klient ausw\u00e4hlen...", "selectOnFocus": true, "hiddenName": "personHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cbss/RetrieveTIGroupsRequests/person", "method": "GET" }) }), "name": "person" });
    var national_id140 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "NR-Nummer", "name": "national_id", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var language141 = new Lino.ChoicesFieldElement({ "autoHeight": true, "forceSelection": true, "fieldLabel": "Sprache", "name": "language", "hiddenName": "languageHidden", "selectOnFocus": true, "anchor": "-20", "store": [['','<br>']].concat(Lino.cbss.RequestLanguages) });
    var main_2_panel142 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 70, "autoHeight": true, "layout": "form", "xtype": "panel", "items": national_id140, "labelAlign": "top" }, { "flex": 30, "autoHeight": true, "layout": "form", "xtype": "panel", "items": language141, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 90, "border": false, "anchor": "-20", "labelAlign": "top" });
    var history145 = new Ext.form.Checkbox({ "autoHeight": true, "hideLabel": true, "checked": true, "name": "history", "listeners": { "render": Lino.quicktip_renderer("Historie","Whatever this means.") }, "boxLabel": "Historie", "selectOnFocus": true, "anchor": "-20" });
    var main_panel146 = new Ext.Panel({ "hideCheckBoxLabels": true, "autoHeight": true, "border": false, "layout": "form", "labelWidth": 81, "autoScroll": false, "items": [ { "autoHeight": true, "layout": "form", "xtype": "panel", "items": person139, "anchor": "-20", "labelAlign": "top" }, main_2_panel142, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": history145, "anchor": "-20", "labelAlign": "top" } ], "frame": true, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel146;
    this.before_row_edit = function(record) {
    }
    Lino.cbss.RetrieveTIGroupsRequests.InsertFormPanel.superclass.initComponent.call(this);
  }
});


Lino.countries.Countries.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 9,
  initComponent : function() {
    var isocode1333 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">ISO-Code</span>", "name": "isocode", "boxMinWidth": Lino.chars2width(4), "listeners": { "render": Lino.quicktip_renderer("ISO-Code","        The two-letter code for this country as defined by ISO 3166-1.\n        For countries that no longer exist it may be a 4-letter code.") }, "maxLength": 4, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var name1334 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Bezeichnung", "name": "name", "maxLength": 200, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var name_fr1335 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Bezeichnung (fr)", "name": "name_fr", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var name_de1336 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Bezeichnung (de)", "name": "name_de", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var name_nl1337 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Bezeichnung (nl)", "name": "name_nl", "maxLength": 200, "selectOnFocus": true, "hidden": true, "anchor": "-20" });
    var short_code1338 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Short code</span>", "name": "short_code", "boxMinWidth": Lino.chars2width(4), "listeners": { "render": Lino.quicktip_renderer("Short code","A short abbreviation for regional usage. Obsolete.") }, "maxLength": 4, "selectOnFocus": true, "anchor": "-20" });
    var inscode1339 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">INS code</span>", "name": "inscode", "boxMinWidth": Lino.chars2width(3), "listeners": { "render": Lino.quicktip_renderer("INS code","The official code for this country                     used by statbel.fgov.be") }, "maxLength": 3, "selectOnFocus": true, "anchor": "-20" });
    var main_1_panel1340 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 153, "hideCheckBoxLabels": true, "items": [ { "flex": 5, "autoHeight": true, "layout": "form", "xtype": "panel", "items": isocode1333, "labelAlign": "top" }, { "flex": 21, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name1334, "labelAlign": "top" }, { "flex": 21, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_fr1335, "labelAlign": "top" }, { "flex": 21, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_de1336, "labelAlign": "top" }, { "flex": 21, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_nl1337, "hidden": true, "labelAlign": "top" }, { "flex": 5, "autoHeight": true, "layout": "form", "xtype": "panel", "items": short_code1338, "labelAlign": "top" }, { "flex": 4, "autoHeight": true, "layout": "form", "xtype": "panel", "items": inscode1339, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var countries_PlacesByCountry_grid1601 = new Lino.countries.PlacesByCountry.GridPanel({ "flex": 50, "hide_top_toolbar": true, "containing_panel": this, "tools": [ Lino.show_in_own_window_button(Lino.countries.PlacesByCountry.grid) ], "preview_limit": 15, "master_panel": this });
    var cv_StudiesByCountry_grid1617 = new Lino.cv.StudiesByCountry.GridPanel({ "flex": 50, "hide_top_toolbar": true, "containing_panel": this, "tools": [ Lino.show_in_own_window_button(Lino.cv.StudiesByCountry.grid) ], "preview_limit": 15, "master_panel": this });
    var main_2_panel1618 = new Ext.Panel({ "flex": 83, "border": false, "layout": "hbox", "hideCheckBoxLabels": true, "items": [ countries_PlacesByCountry_grid1601, cv_StudiesByCountry_grid1617 ], "autoScroll": false, "layoutConfig": { "align": "stretch" }, "frame": false, "labelAlign": "top" });
    var main_panel1619 = new Ext.Panel({ "autoScroll": false, "border": false, "layout": "vbox", "hideCheckBoxLabels": true, "items": [ main_1_panel1340, main_2_panel1618 ], "frame": true, "layoutConfig": { "align": "stretch" }, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel1619;
    this.before_row_edit = function(record) {
      countries_PlacesByCountry_grid1601.on_master_changed();
      cv_StudiesByCountry_grid1617.on_master_changed();
    }
    Lino.countries.Countries.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.newcomers.Faculties.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 96,
  initComponent : function() {
    var id4304 = new Ext.form.NumberField({ "selectOnFocus": true, "autoHeight": true, "fieldLabel": "ID", "anchor": "-20", "name": "id" });
    var name4305 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Bezeichnung", "name": "name", "maxLength": 200, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var name_fr4306 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Bezeichnung (fr)", "name": "name_fr", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var name_de4307 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Bezeichnung (de)", "name": "name_de", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var name_nl4308 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Bezeichnung (nl)", "name": "name_nl", "maxLength": 200, "selectOnFocus": true, "hidden": true, "anchor": "-20" });
    var weight4309 = new Ext.form.NumberField({ "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Aufwand</span>", "name": "weight", "value": 10, "listeners": { "render": Lino.quicktip_renderer("Aufwand","Wieviel Aufwand ein Neuantrag in diesem Fachbereich allgemein verursacht\n(0 = gar kein Aufwand, 10 = maximaler Aufwand).") }, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var main_1_panel4310 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 5, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id4304, "labelAlign": "top" }, { "flex": 22, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name4305, "labelAlign": "top" }, { "flex": 22, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_fr4306, "labelAlign": "top" }, { "flex": 22, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_de4307, "labelAlign": "top" }, { "flex": 22, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_nl4308, "hidden": true, "labelAlign": "top" }, { "flex": 5, "autoHeight": true, "layout": "form", "xtype": "panel", "items": weight4309, "labelAlign": "top" } ], "region": "north", "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "split": true, "autoScroll": false, "labelWidth": 153, "border": false, "frame": false, "labelAlign": "top" });
    var CompetencesByFaculty_grid4322 = new Lino.newcomers.CompetencesByFaculty.GridPanel({ "flex": 5, "hide_top_toolbar": true, "containing_panel": this, "region": "center", "preview_limit": 15, "master_panel": this, "split": true, "tools": [ Lino.show_in_own_window_button(Lino.newcomers.CompetencesByFaculty.grid) ] });
    var ClientsByFaculty_grid4388 = new Lino.newcomers.ClientsByFaculty.GridPanel({ "flex": 5, "hide_top_toolbar": true, "containing_panel": this, "region": "south", "params_panel_hidden": true, "master_panel": this, "preview_limit": 15, "split": true, "tools": [ Lino.show_in_own_window_button(Lino.newcomers.ClientsByFaculty.grid) ] });
    var main_panel4389 = new Lino.VBorderPanel({ "autoScroll": false, "border": false, "hideCheckBoxLabels": true, "items": [ main_1_panel4310, CompetencesByFaculty_grid4322, ClientsByFaculty_grid4388 ], "frame": true, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel4389;
    this.before_row_edit = function(record) {
      CompetencesByFaculty_grid4322.on_master_changed();
      ClientsByFaculty_grid4388.on_master_changed();
    }
    Lino.newcomers.Faculties.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.reception.BusyVisitors.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 33,
  disable_editing: true,
  initComponent : function() {
    var event2064 = new Lino.TwinCombo({ "autoHeight": true, "fieldLabel": "Termin", "allowBlank": false, "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.cal.OneEvent.detail,Lino.cal.OneEvent.insert)}, "emptyText": "Termin ausw\u00e4hlen...", "selectOnFocus": true, "hiddenName": "eventHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/reception/BusyVisitors/event", "method": "GET" }) }), "name": "event" });
    var client2065 = new Lino.TwinCombo({ "preferred_width": 20, "autoHeight": true, "fieldLabel": "Klient", "name": "client", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.pcsw.Clients.detail,Lino.pcsw.Clients.insert)}, "hiddenName": "clientHidden", "disabled": true, "emptyText": "Klient ausw\u00e4hlen...", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({  }) });
    var role2066 = new Lino.TwinCombo({ "autoHeight": true, "fieldLabel": "Rolle", "name": "role", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.cal.GuestRoles.detail,Lino.cal.GuestRoles.insert)}, "emptyText": "Gastrolle ausw\u00e4hlen...", "selectOnFocus": true, "hiddenName": "roleHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/reception/BusyVisitors/role", "method": "GET" }) }) });
    var main_1_panel2067 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": event2064, "labelAlign": "top" }, { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": client2065, "labelAlign": "top" }, { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": role2066, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 63, "border": false, "anchor": "-20", "labelAlign": "top" });
    var state2071 = new Lino.ChoicesFieldElement({ "autoHeight": true, "forceSelection": true, "fieldLabel": "Zustand", "allowBlank": false, "hiddenName": "stateHidden", "selectOnFocus": true, "anchor": "-20", "store": Lino.cal.GuestStates, "name": "state" });
    var remark2072 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Bemerkung", "name": "remark", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var workflow_buttons_disp2073 = new Ext.form.DisplayField({ "disabled": true, "autoHeight": true, "fieldLabel": "Arbeitsablauf", "name": "workflow_buttons", "anchor": "-20", "value": "<br/>", "always_enabled": true });
    var main_2_panel2074 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 17, "autoHeight": true, "layout": "form", "xtype": "panel", "items": state2071, "labelAlign": "top" }, { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": remark2072, "labelAlign": "top" }, { "flex": 48, "autoHeight": true, "layout": "form", "xtype": "panel", "items": workflow_buttons_disp2073, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 126, "border": false, "anchor": "-20", "labelAlign": "top" });
    var main_panel2078 = new Ext.Panel({ "hideCheckBoxLabels": true, "autoHeight": true, "border": false, "layout": "form", "autoScroll": false, "items": [ main_1_panel2067, main_2_panel2074 ], "frame": true, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel2078;
    this.before_row_edit = function(record) {
    }
    Lino.reception.BusyVisitors.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.courses.CourseProviders.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 91,
  initComponent : function() {
    var overview_disp4150 = new Ext.form.DisplayField({ "disabled": true, "flex": 28, "name": "overview", "value": "<br/>", "always_enabled": true });
    var prefix4151 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Name prefix", "name": "prefix", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var name4152 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Name", "name": "name", "maxLength": 200, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var general2_1_panel4153 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": prefix4151, "labelAlign": "top" }, { "flex": 66, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name4152, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 108, "border": false, "anchor": "-20", "labelAlign": "top" });
    var type4156 = new Lino.RemoteComboFieldElement({ "autoHeight": true, "fieldLabel": "Organisationsart", "name": "type", "pageSize": 20, "emptyText": "Organisationsart ausw\u00e4hlen...", "selectOnFocus": true, "hiddenName": "typeHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/courses/CourseProviders/type", "method": "GET" }) }) });
    var vat_id4157 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "MWSt.-Nr.", "name": "vat_id", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var general2_2_panel4158 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 48, "autoHeight": true, "layout": "form", "xtype": "panel", "items": type4156, "labelAlign": "top" }, { "flex": 51, "autoHeight": true, "layout": "form", "xtype": "panel", "items": vat_id4157, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 153, "border": false, "anchor": "-20", "labelAlign": "top" });
    var client_contact_type4161 = new Lino.TwinCombo({ "autoHeight": true, "fieldLabel": "Klientenkontaktart", "name": "client_contact_type", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.pcsw.ClientContactTypes.detail,Lino.pcsw.ClientContactTypes.insert)}, "emptyText": "Klientenkontaktart ausw\u00e4hlen...", "selectOnFocus": true, "hiddenName": "client_contact_typeHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/courses/CourseProviders/client_contact_type", "method": "GET" }) }) });
    var url4162 = new Lino.URLField({ "autoHeight": true, "fieldLabel": "URL", "name": "url", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var general2_panel4163 = new Ext.Panel({ "flex": 42, "autoHeight": true, "layout": "form", "items": [ general2_1_panel4153, general2_2_panel4158, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": client_contact_type4161, "anchor": "-20", "labelAlign": "top" }, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": url4162, "anchor": "-20", "labelAlign": "top" } ], "frame": true, "bodyBorder": false, "autoScroll": false, "hideCheckBoxLabels": true, "labelWidth": 171, "border": false, "labelAlign": "top" });
    var email4166 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "E-Mail", "name": "email", "maxLength": 75, "selectOnFocus": true, "anchor": "-20" });
    var phone4167 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Telefon", "name": "phone", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var gsm4168 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "GSM", "name": "gsm", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var fax4169 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Fax", "name": "fax", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var general3_panel4170 = new Ext.Panel({ "flex": 28, "autoHeight": true, "layout": "form", "items": [ { "autoHeight": true, "layout": "form", "xtype": "panel", "items": email4166, "anchor": "-20", "labelAlign": "top" }, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": phone4167, "anchor": "-20", "labelAlign": "top" }, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": gsm4168, "anchor": "-20", "labelAlign": "top" }, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": fax4169, "anchor": "-20", "labelAlign": "top" } ], "frame": true, "bodyBorder": false, "autoScroll": false, "hideCheckBoxLabels": true, "labelWidth": 72, "border": false, "labelAlign": "top" });
    var general_1_panel4175 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 0, "hideCheckBoxLabels": true, "items": [ overview_disp4150, general2_panel4163, general3_panel4170 ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var contacts_RolesByCompany_grid4176 = new Lino.contacts.RolesByCompany.GridPanel({ "flex": 55, "hide_top_toolbar": true, "containing_panel": this, "tools": [ Lino.show_in_own_window_button(Lino.contacts.RolesByCompany.grid) ], "preview_limit": 15, "master_panel": this });
    var general_panel4177 = new Ext.Panel({ "layout": "vbox", "title": "Allgemein", "items": [ general_1_panel4175, contacts_RolesByCompany_grid4176 ], "frame": true, "layoutConfig": { "align": "stretch" }, "hideCheckBoxLabels": true, "listeners": { "activate": Lino.on_tab_activate }, "autoScroll": false, "border": false, "bodyBorder": false, "labelAlign": "top" });
    var notes_NotesByCompany_grid4178 = new Lino.notes.NotesByCompany.GridPanel({ "listeners": { "activate": Lino.on_tab_activate }, "hide_top_toolbar": true, "containing_panel": this, "title": "Ereignisse/Notizen", "tools": [ Lino.show_in_own_window_button(Lino.notes.NotesByCompany.grid) ], "preview_limit": 15, "master_panel": this });
    var CourseOffersByProvider_grid4243 = new Lino.courses.CourseOffersByProvider.GridPanel({ "listeners": { "activate": Lino.on_tab_activate }, "hide_top_toolbar": true, "containing_panel": this, "title": "Kursangebote", "tools": [ Lino.show_in_own_window_button(Lino.courses.CourseOffersByProvider.grid) ], "preview_limit": 15, "master_panel": this });
    var main_panel4244 = new Ext.TabPanel({ "hideCheckBoxLabels": true, "border": false, "split": true, "autoScroll": false, "items": [ general_panel4177, notes_NotesByCompany_grid4178, CourseOffersByProvider_grid4243 ], "activeTab": 0, "bodyBorder": false, "frame": true, "labelAlign": "top" });
    this.items = main_panel4244;
    this.before_row_edit = function(record) {
      contacts_RolesByCompany_grid4176.on_master_changed();
      notes_NotesByCompany_grid4178.on_master_changed();
      CourseOffersByProvider_grid4243.on_master_changed();
    }
    Lino.courses.CourseProviders.DetailFormPanel.superclass.initComponent.call(this);
    // active_fields:
  }
});


Lino.aids.IncomeConfirmationsByGranting.InsertFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 114,
  initComponent : function() {
    var start_date5017 = new Lino.DateField({ "selectOnFocus": true, "autoHeight": true, "fieldLabel": "Periode vom", "anchor": "-20", "name": "start_date" });
    var end_date5018 = new Lino.DateField({ "selectOnFocus": true, "autoHeight": true, "fieldLabel": "bis", "anchor": "-20", "name": "end_date" });
    var main_2_panel5019 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 108, "hideCheckBoxLabels": true, "items": [ { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": start_date5017, "labelAlign": "top" }, { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": end_date5018, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var category5022 = new Lino.TwinCombo({ "autoHeight": true, "fieldLabel": "Kategorie", "name": "category", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.aids.Categories.detail,Lino.aids.Categories.insert)}, "emptyText": "Kategorie ausw\u00e4hlen...", "selectOnFocus": true, "hiddenName": "categoryHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/aids/IncomeConfirmationsByGranting/category", "method": "GET" }) }) });
    var amount5023 = new Ext.form.NumberField({ "autoHeight": true, "decimalPrecision": 2, "fieldLabel": "Betrag", "name": "amount", "decimalSeparator": ",", "selectOnFocus": true, "anchor": "-20", "allowBlank": true });
    var main_3_panel5024 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 90, "hideCheckBoxLabels": true, "items": [ { "flex": 62, "autoHeight": true, "layout": "form", "xtype": "panel", "items": category5022, "labelAlign": "top" }, { "flex": 37, "autoHeight": true, "layout": "form", "xtype": "panel", "items": amount5023, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var company5027 = new Lino.TwinCombo({ "preferred_width": 20, "autoHeight": true, "fieldLabel": "Empf\u00e4nger (Organisation)", "name": "company", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.contacts.Companies.detail,Lino.contacts.Companies.insert)}, "hiddenName": "companyHidden", "selectOnFocus": true, "emptyText": "Organisation ausw\u00e4hlen...", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/aids/IncomeConfirmationsByGranting/company", "method": "GET" }) }) });
    var contact_person5028 = new Lino.TwinCombo({ "preferred_width": 20, "autoHeight": true, "fieldLabel": "Empf\u00e4nger (Person)", "name": "contact_person", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.contacts.Persons.detail,Lino.contacts.Persons.insert)}, "hiddenName": "contact_personHidden", "selectOnFocus": true, "emptyText": "Person ausw\u00e4hlen...", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/aids/IncomeConfirmationsByGranting/contact_person", "method": "GET" }) }) });
    var main_4_panel5029 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 225, "hideCheckBoxLabels": true, "items": [ { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": company5027, "labelAlign": "top" }, { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": contact_person5028, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var remark5032 = new Lino.RichTextPanel({ "selectOnFocus": true, "flex": 62, "containing_panel": this, "name": "remark", "title": "Bemerkung" });
    var main_panel5033 = new Ext.Panel({ "autoScroll": false, "border": false, "layout": "vbox", "labelWidth": 0, "hideCheckBoxLabels": true, "items": [ main_2_panel5019, main_3_panel5024, main_4_panel5029, remark5032 ], "frame": true, "layoutConfig": { "align": "stretch" }, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel5033;
    this.before_row_edit = function(record) {
      contact_person5028.setContextValue('company', record ? record.data['companyHidden'] : undefined);
      remark5032.refresh();
    }
    this.onRender = function(ct, position) {
      company5027.on('change',Lino.chooser_handler(contact_person5028,'company'));
      Lino.aids.IncomeConfirmationsByGranting.InsertFormPanel.superclass.onRender.call(this, ct, position);
    }
    Lino.aids.IncomeConfirmationsByGranting.InsertFormPanel.superclass.initComponent.call(this);
  }
});


Lino.notes.Notes.InsertFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  autoHeight: true,
  content_type: 109,
  initComponent : function() {
    var event_type593 = new Lino.TwinCombo({ "autoHeight": true, "fieldLabel": "Ereignisart (Form)", "name": "event_type", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.notes.EventTypes.detail,Lino.notes.EventTypes.insert)}, "emptyText": "Event Type ausw\u00e4hlen...", "selectOnFocus": true, "hiddenName": "event_typeHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/notes/Notes/event_type", "method": "GET" }) }) });
    var type594 = new Lino.TwinCombo({ "autoHeight": true, "fieldLabel": "Notizart (Inhalt)", "name": "type", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.notes.NoteTypes.detail,Lino.notes.NoteTypes.insert)}, "emptyText": "Notizart ausw\u00e4hlen...", "selectOnFocus": true, "hiddenName": "typeHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/notes/Notes/type", "method": "GET" }) }) });
    var main_1_panel595 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": event_type593, "labelAlign": "top" }, { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": type594, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 171, "border": false, "anchor": "-20", "labelAlign": "top" });
    var subject598 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Betreff", "name": "subject", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var project599 = new Lino.TwinCombo({ "preferred_width": 20, "autoHeight": true, "fieldLabel": "Klient", "name": "project", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.pcsw.Clients.detail,Lino.pcsw.Clients.insert)}, "hiddenName": "projectHidden", "selectOnFocus": true, "emptyText": "Klient ausw\u00e4hlen...", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/notes/Notes/project", "method": "GET" }) }) });
    var main_panel600 = new Ext.Panel({ "hideCheckBoxLabels": true, "autoHeight": true, "border": false, "layout": "form", "labelWidth": 72, "autoScroll": false, "items": [ main_1_panel595, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": subject598, "anchor": "-20", "labelAlign": "top" }, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": project599, "anchor": "-20", "labelAlign": "top" } ], "frame": true, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel600;
    this.before_row_edit = function(record) {
    }
    Lino.notes.Notes.InsertFormPanel.superclass.initComponent.call(this);
  }
});


Lino.cal.TasksByController.InsertFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  autoHeight: true,
  content_type: 28,
  initComponent : function() {
    var summary576 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Kurzbeschreibung", "name": "summary", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var start_date577 = new Lino.DateField({ "selectOnFocus": true, "autoHeight": true, "fieldLabel": "Beginnt am", "anchor": "-20", "name": "start_date" });
    var due_date578 = new Lino.DateField({ "selectOnFocus": true, "autoHeight": true, "fieldLabel": "Zahlungsziel", "anchor": "-20", "name": "due_date" });
    var main_2_panel579 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": start_date577, "labelAlign": "top" }, { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": due_date578, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 117, "border": false, "anchor": "-20", "labelAlign": "top" });
    var user582 = new Lino.TwinCombo({ "preferred_width": 15, "autoHeight": true, "fieldLabel": "Autor", "name": "user", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.users.Users.detail,Lino.users.Users.insert)}, "hiddenName": "userHidden", "selectOnFocus": true, "emptyText": "Benutzer ausw\u00e4hlen...", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/TasksByController/user", "method": "GET" }) }) });
    var delegated583 = new Ext.form.Checkbox({ "boxLabel": "Delegated to client", "autoHeight": true, "hideLabel": true, "checked": false, "name": "delegated", "selectOnFocus": true, "anchor": "-20" });
    var main_3_panel584 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 66, "autoHeight": true, "layout": "form", "xtype": "panel", "items": user582, "labelAlign": "top" }, { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": delegated583, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 180, "border": false, "anchor": "-20", "labelAlign": "top" });
    var main_panel587 = new Ext.Panel({ "hideCheckBoxLabels": true, "autoHeight": true, "border": false, "layout": "form", "labelWidth": 153, "autoScroll": false, "items": [ { "autoHeight": true, "layout": "form", "xtype": "panel", "items": summary576, "anchor": "-20", "labelAlign": "top" }, main_2_panel579, main_3_panel584 ], "frame": true, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel587;
    this.before_row_edit = function(record) {
    }
    Lino.cal.TasksByController.InsertFormPanel.superclass.initComponent.call(this);
  }
});


Lino.notes.Notes.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 109,
  initComponent : function() {
    var date451 = new Lino.DateField({ "autoHeight": true, "fieldLabel": "Datum", "name": "date", "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var time452 = new Lino.TimeField({ "selectOnFocus": true, "autoHeight": true, "fieldLabel": "Zeit", "anchor": "-20", "name": "time" });
    var event_type453 = new Lino.TwinCombo({ "autoHeight": true, "fieldLabel": "Ereignisart (Form)", "name": "event_type", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.notes.EventTypes.detail,Lino.notes.EventTypes.insert)}, "emptyText": "Event Type ausw\u00e4hlen...", "selectOnFocus": true, "hiddenName": "event_typeHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/notes/Notes/event_type", "method": "GET" }) }) });
    var type454 = new Lino.TwinCombo({ "autoHeight": true, "fieldLabel": "Notizart (Inhalt)", "name": "type", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.notes.NoteTypes.detail,Lino.notes.NoteTypes.insert)}, "emptyText": "Notizart ausw\u00e4hlen...", "selectOnFocus": true, "hiddenName": "typeHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/notes/Notes/type", "method": "GET" }) }) });
    var left_1_panel455 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 171, "hideCheckBoxLabels": true, "items": [ { "flex": 14, "autoHeight": true, "layout": "form", "xtype": "panel", "items": date451, "labelAlign": "top" }, { "flex": 11, "autoHeight": true, "layout": "form", "xtype": "panel", "items": time452, "labelAlign": "top" }, { "flex": 36, "autoHeight": true, "layout": "form", "xtype": "panel", "items": event_type453, "labelAlign": "top" }, { "flex": 36, "autoHeight": true, "layout": "form", "xtype": "panel", "items": type454, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var project460 = new Lino.TwinCombo({ "preferred_width": 20, "autoHeight": true, "fieldLabel": "Klient", "name": "project", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.pcsw.Clients.detail,Lino.pcsw.Clients.insert)}, "hiddenName": "projectHidden", "selectOnFocus": true, "emptyText": "Klient ausw\u00e4hlen...", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/notes/Notes/project", "method": "GET" }) }) });
    var subject461 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Betreff", "name": "subject", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var left_2_panel462 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 72, "hideCheckBoxLabels": true, "items": [ { "flex": 48, "autoHeight": true, "layout": "form", "xtype": "panel", "items": project460, "labelAlign": "top" }, { "flex": 51, "autoHeight": true, "layout": "form", "xtype": "panel", "items": subject461, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var company465 = new Lino.TwinCombo({ "preferred_width": 20, "autoHeight": true, "fieldLabel": "Empf\u00e4nger (Organisation)", "name": "company", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.contacts.Companies.detail,Lino.contacts.Companies.insert)}, "hiddenName": "companyHidden", "selectOnFocus": true, "emptyText": "Organisation ausw\u00e4hlen...", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/notes/Notes/company", "method": "GET" }) }) });
    var contact_person466 = new Lino.TwinCombo({ "preferred_width": 20, "autoHeight": true, "fieldLabel": "Empf\u00e4nger (Person)", "name": "contact_person", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.contacts.Persons.detail,Lino.contacts.Persons.insert)}, "hiddenName": "contact_personHidden", "selectOnFocus": true, "emptyText": "Person ausw\u00e4hlen...", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/notes/Notes/contact_person", "method": "GET" }) }) });
    var left_3_panel467 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 225, "hideCheckBoxLabels": true, "items": [ { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": company465, "labelAlign": "top" }, { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": contact_person466, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var user470 = new Lino.TwinCombo({ "preferred_width": 15, "autoHeight": true, "fieldLabel": "Autor", "name": "user", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.users.Users.detail,Lino.users.Users.insert)}, "hiddenName": "userHidden", "selectOnFocus": true, "emptyText": "Benutzer ausw\u00e4hlen...", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/notes/Notes/user", "method": "GET" }) }) });
    var language471 = new Lino.ChoicesFieldElement({ "autoHeight": true, "fieldLabel": "Sprache", "allowBlank": false, "hiddenName": "languageHidden", "selectOnFocus": true, "anchor": "-20", "store": [ [ "en", "Englisch" ], [ "fr", "Franz\u00f6sisch" ], [ "de", "Deutsch" ], [ "nl", "Niederl\u00e4ndisch" ] ], "name": "language" });
    var build_time472 = new Ext.form.DisplayField({ "disabled": true, "autoHeight": true, "fieldLabel": "Druckdatum", "name": "build_time", "anchor": "-20", "value": "<br>" });
    var id473 = new Ext.form.NumberField({ "selectOnFocus": true, "autoHeight": true, "fieldLabel": "ID", "anchor": "-20", "name": "id" });
    var left_4_panel474 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 99, "hideCheckBoxLabels": true, "items": [ { "flex": 25, "autoHeight": true, "layout": "form", "xtype": "panel", "items": user470, "labelAlign": "top" }, { "flex": 20, "autoHeight": true, "layout": "form", "xtype": "panel", "items": language471, "labelAlign": "top" }, { "flex": 41, "autoHeight": true, "layout": "form", "xtype": "panel", "items": build_time472, "labelAlign": "top" }, { "flex": 12, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id473, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var body479 = new Lino.RichTextPanel({ "selectOnFocus": true, "flex": 55, "containing_panel": this, "name": "body", "title": "Inhalt" });
    var left_panel480 = new Ext.Panel({ "flex": 66, "layout": "vbox", "items": [ left_1_panel455, left_2_panel462, left_3_panel467, left_4_panel474, body479 ], "frame": true, "layoutConfig": { "align": "stretch" }, "autoScroll": false, "hideCheckBoxLabels": true, "labelWidth": 0, "border": false, "bodyBorder": false, "labelAlign": "top" });
    var UploadsByController_htmlbox481 = new Lino.HtmlBoxPanel({ "flex": 3, "layout": "fit", "name": "UploadsByController", "containing_panel": this, "items": new Ext.BoxComponent({autoScroll:true}), "region": "north", "title": "Uploads", "master_panel": this, "value": "<br/>", "always_enabled": true, "bodyStyle": "overflow-x:hidden;", "split": true, "tools": [ Lino.show_in_own_window_button(Lino.uploads.UploadsByController.grid) ] });
    var outbox_MailsByController_grid527 = new Lino.outbox.MailsByController.GridPanel({ "flex": 5, "hide_top_toolbar": true, "containing_panel": this, "region": "center", "preview_limit": 15, "master_panel": this, "split": true, "tools": [ Lino.show_in_own_window_button(Lino.outbox.MailsByController.grid) ] });
    var cal_TasksByController_grid589 = new Lino.cal.TasksByController.GridPanel({ "flex": 5, "hide_top_toolbar": true, "containing_panel": this, "region": "south", "params_panel_hidden": true, "master_panel": this, "preview_limit": 15, "split": true, "tools": [ Lino.show_in_own_window_button(Lino.cal.TasksByController.grid) ] });
    var right_panel590 = new Lino.VBorderPanel({ "flex": 33, "border": false, "labelWidth": 72, "hideCheckBoxLabels": true, "items": [ UploadsByController_htmlbox481, outbox_MailsByController_grid527, cal_TasksByController_grid589 ], "frame": true, "autoScroll": false, "bodyBorder": false, "labelAlign": "top" });
    var main_1_panel591 = new Ext.Panel({ "autoScroll": false, "border": false, "layout": "hbox", "hideCheckBoxLabels": true, "items": [ left_panel480, right_panel590 ], "frame": false, "layoutConfig": { "align": "stretch" }, "labelAlign": "top" });
    var main_panel592 = new Ext.Panel({ "autoScroll": false, "border": false, "layout": "fit", "hideCheckBoxLabels": true, "items": [ main_1_panel591 ], "frame": true, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel592;
    this.before_row_edit = function(record) {
      contact_person466.setContextValue('company', record ? record.data['companyHidden'] : undefined);
      body479.refresh();
      UploadsByController_htmlbox481.refresh();
      outbox_MailsByController_grid527.on_master_changed();
      cal_TasksByController_grid589.on_master_changed();
    }
    this.onRender = function(ct, position) {
      company465.on('change',Lino.chooser_handler(contact_person466,'company'));
      Lino.notes.Notes.DetailFormPanel.superclass.onRender.call(this, ct, position);
    }
    Lino.notes.Notes.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.accounts.Charts.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 42,
  initComponent : function() {
    var id3861 = new Ext.form.NumberField({ "selectOnFocus": true, "autoHeight": true, "fieldLabel": "ID", "anchor": "-20", "name": "id" });
    var name3862 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Bezeichnung", "name": "name", "maxLength": 200, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var name_fr3863 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Bezeichnung (fr)", "name": "name_fr", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var name_de3864 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Bezeichnung (de)", "name": "name_de", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var name_nl3865 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Bezeichnung (nl)", "name": "name_nl", "maxLength": 200, "selectOnFocus": true, "hidden": true, "anchor": "-20" });
    var main_1_panel3866 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 153, "hideCheckBoxLabels": true, "items": [ { "flex": 5, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id3861, "labelAlign": "top" }, { "flex": 23, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name3862, "labelAlign": "top" }, { "flex": 23, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_fr3863, "labelAlign": "top" }, { "flex": 23, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_de3864, "labelAlign": "top" }, { "flex": 23, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_nl3865, "hidden": true, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var GroupsByChart_grid3984 = new Lino.accounts.GroupsByChart.GridPanel({ "flex": 83, "hide_top_toolbar": true, "containing_panel": this, "tools": [ Lino.show_in_own_window_button(Lino.accounts.GroupsByChart.grid) ], "preview_limit": 15, "master_panel": this });
    var main_panel3985 = new Ext.Panel({ "autoScroll": false, "border": false, "layout": "vbox", "hideCheckBoxLabels": true, "items": [ main_1_panel3866, GroupsByChart_grid3984 ], "frame": true, "layoutConfig": { "align": "stretch" }, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel3985;
    this.before_row_edit = function(record) {
      GroupsByChart_grid3984.on_master_changed();
    }
    Lino.accounts.Charts.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.aids.RefundConfirmations.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 116,
  initComponent : function() {
    var id4792 = new Ext.form.NumberField({ "selectOnFocus": true, "autoHeight": true, "fieldLabel": "ID", "anchor": "-20", "name": "id" });
    var client4793 = new Lino.TwinCombo({ "preferred_width": 20, "autoHeight": true, "fieldLabel": "Klient", "allowBlank": false, "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.pcsw.Clients.detail,Lino.pcsw.Clients.insert)}, "emptyText": "Klient ausw\u00e4hlen...", "selectOnFocus": true, "hiddenName": "clientHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/aids/RefundConfirmations/client", "method": "GET" }) }), "name": "client" });
    var user4794 = new Lino.TwinCombo({ "preferred_width": 15, "autoHeight": true, "fieldLabel": "Autor", "name": "user", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.users.Users.detail,Lino.users.Users.insert)}, "hiddenName": "userHidden", "selectOnFocus": true, "emptyText": "Benutzer ausw\u00e4hlen...", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/aids/RefundConfirmations/user", "method": "GET" }) }) });
    var signer4795 = new Lino.TwinCombo({ "preferred_width": 15, "autoHeight": true, "fieldLabel": "Best\u00e4tiger", "name": "signer", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.users.Users.detail,Lino.users.Users.insert)}, "hiddenName": "signerHidden", "selectOnFocus": true, "emptyText": "Benutzer ausw\u00e4hlen...", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/aids/RefundConfirmations/signer", "method": "GET" }) }) });
    var workflow_buttons_disp4796 = new Ext.form.DisplayField({ "disabled": true, "autoHeight": true, "fieldLabel": "Arbeitsablauf", "name": "workflow_buttons", "anchor": "-20", "value": "<br/>", "always_enabled": true });
    var main_1_panel4797 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 126, "hideCheckBoxLabels": true, "items": [ { "flex": 5, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id4792, "labelAlign": "top" }, { "flex": 21, "autoHeight": true, "layout": "form", "xtype": "panel", "items": client4793, "labelAlign": "top" }, { "flex": 21, "autoHeight": true, "layout": "form", "xtype": "panel", "items": user4794, "labelAlign": "top" }, { "flex": 21, "autoHeight": true, "layout": "form", "xtype": "panel", "items": signer4795, "labelAlign": "top" }, { "flex": 31, "autoHeight": true, "layout": "form", "xtype": "panel", "items": workflow_buttons_disp4796, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var granting4803 = new Lino.TwinCombo({ "autoHeight": true, "fieldLabel": "Hilfebeschluss", "name": "granting", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.aids.GrantingsByX.detail,Lino.aids.GrantingsByX.insert)}, "emptyText": "Hilfebeschluss ausw\u00e4hlen...", "selectOnFocus": true, "hiddenName": "grantingHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/aids/RefundConfirmations/granting", "method": "GET" }) }) });
    var start_date4804 = new Lino.DateField({ "selectOnFocus": true, "autoHeight": true, "fieldLabel": "Periode vom", "anchor": "-20", "name": "start_date" });
    var end_date4805 = new Lino.DateField({ "selectOnFocus": true, "autoHeight": true, "fieldLabel": "bis", "anchor": "-20", "name": "end_date" });
    var main_2_panel4806 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 135, "hideCheckBoxLabels": true, "items": [ { "flex": 49, "autoHeight": true, "layout": "form", "xtype": "panel", "items": granting4803, "labelAlign": "top" }, { "flex": 25, "autoHeight": true, "layout": "form", "xtype": "panel", "items": start_date4804, "labelAlign": "top" }, { "flex": 25, "autoHeight": true, "layout": "form", "xtype": "panel", "items": end_date4805, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var doctor_type4810 = new Lino.TwinCombo({ "autoHeight": true, "fieldLabel": "Art des Arztes", "allowBlank": false, "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.pcsw.ClientContactTypes.detail,Lino.pcsw.ClientContactTypes.insert)}, "emptyText": "Klientenkontaktart ausw\u00e4hlen...", "selectOnFocus": true, "hiddenName": "doctor_typeHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/aids/RefundConfirmations/doctor_type", "method": "GET" }) }), "name": "doctor_type" });
    var doctor4811 = new Lino.TwinCombo({ "preferred_width": 20, "autoHeight": true, "forceSelection": false, "fieldLabel": "Arzt", "name": "doctor", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.contacts.Persons.detail,Lino.contacts.Persons.insert)}, "hiddenName": "doctorHidden", "selectOnFocus": true, "emptyText": "Person ausw\u00e4hlen...", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/aids/RefundConfirmations/doctor", "method": "GET" }) }) });
    var pharmacy4812 = new Lino.TwinCombo({ "preferred_width": 20, "autoHeight": true, "fieldLabel": "Apotheke", "name": "pharmacy", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.contacts.Companies.detail,Lino.contacts.Companies.insert)}, "hiddenName": "pharmacyHidden", "selectOnFocus": true, "emptyText": "Organisation ausw\u00e4hlen...", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/aids/RefundConfirmations/pharmacy", "method": "GET" }) }) });
    var main_3_panel4813 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 135, "hideCheckBoxLabels": true, "items": [ { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": doctor_type4810, "labelAlign": "top" }, { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": doctor4811, "labelAlign": "top" }, { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": pharmacy4812, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var company4817 = new Lino.TwinCombo({ "preferred_width": 20, "autoHeight": true, "fieldLabel": "Empf\u00e4nger (Organisation)", "name": "company", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.contacts.Companies.detail,Lino.contacts.Companies.insert)}, "hiddenName": "companyHidden", "selectOnFocus": true, "emptyText": "Organisation ausw\u00e4hlen...", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/aids/RefundConfirmations/company", "method": "GET" }) }) });
    var contact_person4818 = new Lino.TwinCombo({ "preferred_width": 20, "autoHeight": true, "fieldLabel": "Empf\u00e4nger (Person)", "name": "contact_person", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.contacts.Persons.detail,Lino.contacts.Persons.insert)}, "hiddenName": "contact_personHidden", "selectOnFocus": true, "emptyText": "Person ausw\u00e4hlen...", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/aids/RefundConfirmations/contact_person", "method": "GET" }) }) });
    var printed_disp4819 = new Ext.form.DisplayField({ "disabled": true, "autoHeight": true, "fieldLabel": "Ausgedruckt", "name": "printed", "anchor": "-20", "value": "<br/>", "always_enabled": true });
    var main_4_panel4820 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 225, "hideCheckBoxLabels": true, "items": [ { "flex": 28, "autoHeight": true, "layout": "form", "xtype": "panel", "items": company4817, "labelAlign": "top" }, { "flex": 28, "autoHeight": true, "layout": "form", "xtype": "panel", "items": contact_person4818, "labelAlign": "top" }, { "flex": 42, "autoHeight": true, "layout": "form", "xtype": "panel", "items": printed_disp4819, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var remark4824 = new Lino.RichTextPanel({ "selectOnFocus": true, "flex": 38, "containing_panel": this, "name": "remark", "title": "Bemerkung" });
    var main_panel4825 = new Ext.Panel({ "autoScroll": false, "border": false, "layout": "vbox", "labelWidth": 0, "hideCheckBoxLabels": true, "items": [ main_1_panel4797, main_2_panel4806, main_3_panel4813, main_4_panel4820, remark4824 ], "frame": true, "layoutConfig": { "align": "stretch" }, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel4825;
    this.before_row_edit = function(record) {
      doctor4811.setContextValue('doctor_type', record ? record.data['doctor_typeHidden'] : undefined);
      pharmacy4812.setContextValue('granting', record ? record.data['grantingHidden'] : undefined);
      contact_person4818.setContextValue('company', record ? record.data['companyHidden'] : undefined);
      remark4824.refresh();
    }
    this.onRender = function(ct, position) {
      doctor_type4810.on('change',Lino.chooser_handler(doctor4811,'doctor_type'));
      granting4803.on('change',Lino.chooser_handler(pharmacy4812,'granting'));
      company4817.on('change',Lino.chooser_handler(contact_person4818,'company'));
      Lino.aids.RefundConfirmations.DetailFormPanel.superclass.onRender.call(this, ct, position);
    }
    Lino.aids.RefundConfirmations.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.languages.Languages.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 39,
  initComponent : function() {
    var id3840 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "id", "name": "id", "boxMinWidth": Lino.chars2width(3), "maxLength": 3, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var iso23841 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "iso2", "name": "iso2", "maxLength": 2, "selectOnFocus": true, "boxMinWidth": Lino.chars2width(2), "anchor": "-20" });
    var name3842 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Bezeichnung", "name": "name", "maxLength": 200, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var name_fr3843 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Bezeichnung (fr)", "name": "name_fr", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var name_de3844 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Bezeichnung (de)", "name": "name_de", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var name_nl3845 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Bezeichnung (nl)", "name": "name_nl", "maxLength": 200, "selectOnFocus": true, "hidden": true, "anchor": "-20" });
    var main_1_panel3846 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 153, "hideCheckBoxLabels": true, "items": [ { "flex": 4, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id3840, "labelAlign": "top" }, { "flex": 4, "autoHeight": true, "layout": "form", "xtype": "panel", "items": iso23841, "labelAlign": "top" }, { "flex": 22, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name3842, "labelAlign": "top" }, { "flex": 22, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_fr3843, "labelAlign": "top" }, { "flex": 22, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_de3844, "labelAlign": "top" }, { "flex": 22, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_nl3845, "hidden": true, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var cv_KnowledgesByLanguage_grid3859 = new Lino.cv.KnowledgesByLanguage.GridPanel({ "flex": 83, "hide_top_toolbar": true, "containing_panel": this, "tools": [ Lino.show_in_own_window_button(Lino.cv.KnowledgesByLanguage.grid) ], "preview_limit": 15, "master_panel": this });
    var main_panel3860 = new Ext.Panel({ "autoScroll": false, "border": false, "layout": "vbox", "hideCheckBoxLabels": true, "items": [ main_1_panel3846, cv_KnowledgesByLanguage_grid3859 ], "frame": true, "layoutConfig": { "align": "stretch" }, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel3860;
    this.before_row_edit = function(record) {
      cv_KnowledgesByLanguage_grid3859.on_master_changed();
    }
    Lino.languages.Languages.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.aids.SimpleConfirmationsByGranting.InsertFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 115,
  initComponent : function() {
    var start_date5003 = new Lino.DateField({ "selectOnFocus": true, "autoHeight": true, "fieldLabel": "Periode vom", "anchor": "-20", "name": "start_date" });
    var end_date5004 = new Lino.DateField({ "selectOnFocus": true, "autoHeight": true, "fieldLabel": "bis", "anchor": "-20", "name": "end_date" });
    var main_1_panel5005 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 108, "hideCheckBoxLabels": true, "items": [ { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": start_date5003, "labelAlign": "top" }, { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": end_date5004, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var company5008 = new Lino.TwinCombo({ "preferred_width": 20, "autoHeight": true, "fieldLabel": "Empf\u00e4nger (Organisation)", "name": "company", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.contacts.Companies.detail,Lino.contacts.Companies.insert)}, "hiddenName": "companyHidden", "selectOnFocus": true, "emptyText": "Organisation ausw\u00e4hlen...", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/aids/SimpleConfirmationsByGranting/company", "method": "GET" }) }) });
    var contact_person5009 = new Lino.TwinCombo({ "preferred_width": 20, "autoHeight": true, "fieldLabel": "Empf\u00e4nger (Person)", "name": "contact_person", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.contacts.Persons.detail,Lino.contacts.Persons.insert)}, "hiddenName": "contact_personHidden", "selectOnFocus": true, "emptyText": "Person ausw\u00e4hlen...", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/aids/SimpleConfirmationsByGranting/contact_person", "method": "GET" }) }) });
    var main_2_panel5010 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 225, "hideCheckBoxLabels": true, "items": [ { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": company5008, "labelAlign": "top" }, { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": contact_person5009, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var remark5013 = new Lino.RichTextPanel({ "selectOnFocus": true, "flex": 71, "containing_panel": this, "name": "remark", "title": "Bemerkung" });
    var main_panel5014 = new Ext.Panel({ "autoScroll": false, "border": false, "layout": "vbox", "labelWidth": 0, "hideCheckBoxLabels": true, "items": [ main_1_panel5005, main_2_panel5010, remark5013 ], "frame": true, "layoutConfig": { "align": "stretch" }, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel5014;
    this.before_row_edit = function(record) {
      contact_person5009.setContextValue('company', record ? record.data['companyHidden'] : undefined);
      remark5013.refresh();
    }
    this.onRender = function(ct, position) {
      company5008.on('change',Lino.chooser_handler(contact_person5009,'company'));
      Lino.aids.SimpleConfirmationsByGranting.InsertFormPanel.superclass.onRender.call(this, ct, position);
    }
    Lino.aids.SimpleConfirmationsByGranting.InsertFormPanel.superclass.initComponent.call(this);
  }
});


Lino.excerpts.ExcerptTypes.InsertFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  autoHeight: true,
  content_type: 46,
  initComponent : function() {
    var name4100 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Bezeichnung", "name": "name", "maxLength": 200, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var name_fr4101 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Bezeichnung (fr)", "name": "name_fr", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var name_de4102 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Bezeichnung (de)", "name": "name_de", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var name_nl4103 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Bezeichnung (nl)", "name": "name_nl", "maxLength": 200, "selectOnFocus": true, "hidden": true, "anchor": "-20" });
    var main_1_panel4104 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 25, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name4100, "labelAlign": "top" }, { "flex": 25, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_fr4101, "labelAlign": "top" }, { "flex": 25, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_de4102, "labelAlign": "top" }, { "flex": 25, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_nl4103, "hidden": true, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 153, "border": false, "anchor": "-20", "labelAlign": "top" });
    var content_type4109 = new Lino.TwinCombo({ "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Modell</span>", "allowBlank": false, "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.contenttypes.ContentTypes.detail,Lino.contenttypes.ContentTypes.insert)}, "emptyText": "Datenbankmodell ausw\u00e4hlen...", "listeners": { "render": Lino.quicktip_renderer("Modell","The model that can issue printouts of this type.") }, "selectOnFocus": true, "hiddenName": "content_typeHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/excerpts/ExcerptTypes/content_type", "method": "GET" }) }), "name": "content_type" });
    var primary4110 = new Ext.form.Checkbox({ "autoHeight": true, "hideLabel": true, "checked": false, "name": "primary", "listeners": { "render": Lino.quicktip_renderer("Prim\u00e4r","There's at most one primary type per model.         Enabling this field will automatically make the other         types non-primary.") }, "boxLabel": "Prim\u00e4r", "selectOnFocus": true, "anchor": "-20" });
    var certifying4111 = new Ext.form.Checkbox({ "autoHeight": true, "hideLabel": true, "checked": false, "name": "certifying", "listeners": { "render": Lino.quicktip_renderer("Bescheinigend","Ob Ausz\u00fcge dieser Art als einmalige Ausdrucke behandelt werden sollen.") }, "boxLabel": "Bescheinigend", "selectOnFocus": true, "anchor": "-20" });
    var main_2_panel4112 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": content_type4109, "labelAlign": "top" }, { "flex": 25, "autoHeight": true, "layout": "form", "xtype": "panel", "items": primary4110, "labelAlign": "top" }, { "flex": 25, "autoHeight": true, "layout": "form", "xtype": "panel", "items": certifying4111, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 126, "border": false, "anchor": "-20", "labelAlign": "top" });
    var build_method4116 = new Lino.ChoicesFieldElement({ "autoHeight": true, "forceSelection": true, "fieldLabel": "Konstruktionsmethode", "name": "build_method", "hiddenName": "build_methodHidden", "selectOnFocus": true, "anchor": "-20", "store": [['','<br>']].concat(Lino.lino.BuildMethods) });
    var template4117 = new Lino.SimpleRemoteComboFieldElement({ "autoHeight": true, "fieldLabel": "Vorlage", "name": "template", "selectOnFocus": true, "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/excerpts/ExcerptTypes/template", "method": "GET" }) }) });
    var body_template4118 = new Lino.SimpleRemoteComboFieldElement({ "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Textk\u00f6rper-Vorlage</span>", "name": "body_template", "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Textk\u00f6rper-Vorlage","The body template to be used when         rendering a printable of this type. This is a list of files         with extension `.body.html`.") }, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/excerpts/ExcerptTypes/body_template", "method": "GET" }) }), "anchor": "-20" });
    var main_3_panel4119 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 51, "autoHeight": true, "layout": "form", "xtype": "panel", "items": build_method4116, "labelAlign": "top" }, { "flex": 24, "autoHeight": true, "layout": "form", "xtype": "panel", "items": template4117, "labelAlign": "top" }, { "flex": 24, "autoHeight": true, "layout": "form", "xtype": "panel", "items": body_template4118, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 189, "border": false, "anchor": "-20", "labelAlign": "top" });
    var main_panel4123 = new Ext.Panel({ "hideCheckBoxLabels": true, "autoHeight": true, "border": false, "layout": "form", "autoScroll": false, "items": [ main_1_panel4104, main_2_panel4112, main_3_panel4119 ], "frame": true, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel4123;
    this.before_row_edit = function(record) {
      template4117.setContextValue('build_method', record ? record.data['build_methodHidden'] : undefined);
      template4117.setContextValue('content_type', record ? record.data['content_typeHidden'] : undefined);
      body_template4118.setContextValue('content_type', record ? record.data['content_typeHidden'] : undefined);
    }
    this.onRender = function(ct, position) {
      build_method4116.on('change',Lino.chooser_handler(template4117,'build_method'));
      content_type4109.on('change',Lino.chooser_handler(template4117,'content_type'));
      content_type4109.on('change',Lino.chooser_handler(body_template4118,'content_type'));
      Lino.excerpts.ExcerptTypes.InsertFormPanel.superclass.onRender.call(this, ct, position);
    }
    Lino.excerpts.ExcerptTypes.InsertFormPanel.superclass.initComponent.call(this);
  }
});


Lino.aids.RefundConfirmationsByGranting.InsertFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 116,
  initComponent : function() {
    var start_date5034 = new Lino.DateField({ "selectOnFocus": true, "autoHeight": true, "fieldLabel": "Periode vom", "anchor": "-20", "name": "start_date" });
    var end_date5035 = new Lino.DateField({ "selectOnFocus": true, "autoHeight": true, "fieldLabel": "bis", "anchor": "-20", "name": "end_date" });
    var main_1_panel5036 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 108, "hideCheckBoxLabels": true, "items": [ { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": start_date5034, "labelAlign": "top" }, { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": end_date5035, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var doctor_type5039 = new Lino.TwinCombo({ "autoHeight": true, "fieldLabel": "Art des Arztes", "allowBlank": false, "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.pcsw.ClientContactTypes.detail,Lino.pcsw.ClientContactTypes.insert)}, "emptyText": "Klientenkontaktart ausw\u00e4hlen...", "selectOnFocus": true, "hiddenName": "doctor_typeHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/aids/RefundConfirmationsByGranting/doctor_type", "method": "GET" }) }), "name": "doctor_type" });
    var doctor5040 = new Lino.TwinCombo({ "preferred_width": 20, "autoHeight": true, "forceSelection": false, "fieldLabel": "Arzt", "name": "doctor", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.contacts.Persons.detail,Lino.contacts.Persons.insert)}, "hiddenName": "doctorHidden", "selectOnFocus": true, "emptyText": "Person ausw\u00e4hlen...", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/aids/RefundConfirmationsByGranting/doctor", "method": "GET" }) }) });
    var pharmacy5041 = new Lino.TwinCombo({ "preferred_width": 20, "autoHeight": true, "fieldLabel": "Apotheke", "name": "pharmacy", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.contacts.Companies.detail,Lino.contacts.Companies.insert)}, "hiddenName": "pharmacyHidden", "selectOnFocus": true, "emptyText": "Organisation ausw\u00e4hlen...", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/aids/RefundConfirmationsByGranting/pharmacy", "method": "GET" }) }) });
    var main_2_panel5042 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 135, "hideCheckBoxLabels": true, "items": [ { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": doctor_type5039, "labelAlign": "top" }, { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": doctor5040, "labelAlign": "top" }, { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": pharmacy5041, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var company5046 = new Lino.TwinCombo({ "preferred_width": 20, "autoHeight": true, "fieldLabel": "Empf\u00e4nger (Organisation)", "name": "company", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.contacts.Companies.detail,Lino.contacts.Companies.insert)}, "hiddenName": "companyHidden", "selectOnFocus": true, "emptyText": "Organisation ausw\u00e4hlen...", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/aids/RefundConfirmationsByGranting/company", "method": "GET" }) }) });
    var contact_person5047 = new Lino.TwinCombo({ "preferred_width": 20, "autoHeight": true, "fieldLabel": "Empf\u00e4nger (Person)", "name": "contact_person", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.contacts.Persons.detail,Lino.contacts.Persons.insert)}, "hiddenName": "contact_personHidden", "selectOnFocus": true, "emptyText": "Person ausw\u00e4hlen...", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/aids/RefundConfirmationsByGranting/contact_person", "method": "GET" }) }) });
    var printed_disp5048 = new Ext.form.DisplayField({ "disabled": true, "autoHeight": true, "fieldLabel": "Ausgedruckt", "name": "printed", "anchor": "-20", "value": "<br/>", "always_enabled": true });
    var main_3_panel5049 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 225, "hideCheckBoxLabels": true, "items": [ { "flex": 28, "autoHeight": true, "layout": "form", "xtype": "panel", "items": company5046, "labelAlign": "top" }, { "flex": 28, "autoHeight": true, "layout": "form", "xtype": "panel", "items": contact_person5047, "labelAlign": "top" }, { "flex": 42, "autoHeight": true, "layout": "form", "xtype": "panel", "items": printed_disp5048, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var remark5053 = new Lino.RichTextPanel({ "selectOnFocus": true, "flex": 50, "containing_panel": this, "name": "remark", "title": "Bemerkung" });
    var main_panel5054 = new Ext.Panel({ "autoScroll": false, "border": false, "layout": "vbox", "labelWidth": 0, "hideCheckBoxLabels": true, "items": [ main_1_panel5036, main_2_panel5042, main_3_panel5049, remark5053 ], "frame": true, "layoutConfig": { "align": "stretch" }, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel5054;
    this.before_row_edit = function(record) {
      doctor5040.setContextValue('doctor_type', record ? record.data['doctor_typeHidden'] : undefined);
      var bp = this.get_base_params();
      pharmacy5041.setContextValue('mk',bp['mk']);
      pharmacy5041.setContextValue('mt',bp['mt']);
      contact_person5047.setContextValue('company', record ? record.data['companyHidden'] : undefined);
      remark5053.refresh();
    }
    this.onRender = function(ct, position) {
      doctor_type5039.on('change',Lino.chooser_handler(doctor5040,'doctor_type'));
      company5046.on('change',Lino.chooser_handler(contact_person5047,'company'));
      Lino.aids.RefundConfirmationsByGranting.InsertFormPanel.superclass.onRender.call(this, ct, position);
    }
    Lino.aids.RefundConfirmationsByGranting.InsertFormPanel.superclass.initComponent.call(this);
  }
});


Lino.courses.CourseRequests.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 89,
  initComponent : function() {
    var date_submitted204 = new Lino.DateField({ "autoHeight": true, "allowBlank": false, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Anfragedatum</span>", "name": "date_submitted", "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Anfragedatum","Datum, an dem die Anfrage erstellt wurde.") }, "anchor": "-20" });
    var person205 = new Lino.TwinCombo({ "preferred_width": 20, "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Klient</span>", "allowBlank": false, "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.pcsw.Clients.detail,Lino.pcsw.Clients.insert)}, "emptyText": "Klient ausw\u00e4hlen...", "listeners": { "render": Lino.quicktip_renderer("Klient","Le client qui d\u00e9sire suivre un cours.") }, "selectOnFocus": true, "hiddenName": "personHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/courses/CourseRequests/person", "method": "GET" }) }), "name": "person" });
    var content206 = new Lino.TwinCombo({ "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Kursinhalt</span>", "allowBlank": false, "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.courses.CourseContents.detail,Lino.courses.CourseContents.insert)}, "emptyText": "Kursinhalt ausw\u00e4hlen...", "listeners": { "render": Lino.quicktip_renderer("Kursinhalt","Der gew\u00fcnschte Kursinhalt.)") }, "selectOnFocus": true, "hiddenName": "contentHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/courses/CourseRequests/content", "method": "GET" }) }), "name": "content" });
    var offer207 = new Lino.TwinCombo({ "autoHeight": true, "fieldLabel": "Kursangebot", "name": "offer", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.courses.CourseOffers.detail,Lino.courses.CourseOffers.insert)}, "emptyText": "Kursangebot ausw\u00e4hlen...", "selectOnFocus": true, "hiddenName": "offerHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/courses/CourseRequests/offer", "method": "GET" }) }) });
    var urgent208 = new Ext.form.Checkbox({ "autoHeight": true, "hideLabel": true, "checked": false, "name": "urgent", "listeners": { "render": Lino.quicktip_renderer("professionelle Eingliederung","Ankreuzen, wenn der Kurs f\u00fcr die Arbeitssuche ben\u00f6tigt wird.") }, "boxLabel": "professionelle Eingliederung", "selectOnFocus": true, "anchor": "-20" });
    var main_1_panel209 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 261, "hideCheckBoxLabels": true, "items": [ { "flex": 15, "autoHeight": true, "layout": "form", "xtype": "panel", "items": date_submitted204, "labelAlign": "top" }, { "flex": 24, "autoHeight": true, "layout": "form", "xtype": "panel", "items": person205, "labelAlign": "top" }, { "flex": 24, "autoHeight": true, "layout": "form", "xtype": "panel", "items": content206, "labelAlign": "top" }, { "flex": 24, "autoHeight": true, "layout": "form", "xtype": "panel", "items": offer207, "labelAlign": "top" }, { "flex": 12, "autoHeight": true, "layout": "form", "xtype": "panel", "items": urgent208, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var course215 = new Lino.TwinCombo({ "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Kurs gefunden</span>", "name": "course", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.courses.Courses.detail,Lino.courses.Courses.insert)}, "emptyText": "Kurs ausw\u00e4hlen...", "listeners": { "render": Lino.quicktip_renderer("Kurs gefunden","The course which satisfies this request. Leave blank on open requests.") }, "selectOnFocus": true, "hiddenName": "courseHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/courses/CourseRequests/course", "method": "GET" }) }) });
    var state216 = new Lino.ChoicesFieldElement({ "autoHeight": true, "forceSelection": true, "fieldLabel": "Zustand", "allowBlank": false, "hiddenName": "stateHidden", "selectOnFocus": true, "anchor": "-20", "store": Lino.courses.CourseRequestStates, "name": "state" });
    var date_ended217 = new Lino.DateField({ "selectOnFocus": true, "autoHeight": true, "fieldLabel": "Enddatum", "anchor": "-20", "name": "date_ended" });
    var id218 = new Ext.form.NumberField({ "selectOnFocus": true, "autoHeight": true, "fieldLabel": "ID", "anchor": "-20", "name": "id" });
    var main_2_panel219 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 126, "hideCheckBoxLabels": true, "items": [ { "flex": 37, "autoHeight": true, "layout": "form", "xtype": "panel", "items": course215, "labelAlign": "top" }, { "flex": 24, "autoHeight": true, "layout": "form", "xtype": "panel", "items": state216, "labelAlign": "top" }, { "flex": 24, "autoHeight": true, "layout": "form", "xtype": "panel", "items": date_ended217, "labelAlign": "top" }, { "flex": 14, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id218, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var remark224 = new Ext.form.TextArea({ "selectOnFocus": true, "fieldLabel": "Bemerkung", "anchor": "-20 -10", "growMax": 2000, "name": "remark" });
    var UploadsByController_htmlbox225 = new Lino.HtmlBoxPanel({ "flex": 33, "layout": "fit", "name": "UploadsByController", "containing_panel": this, "items": new Ext.BoxComponent({autoScroll:true}), "title": "Uploads", "master_panel": this, "value": "<br/>", "always_enabled": true, "bodyStyle": "overflow-x:hidden;", "tools": [ Lino.show_in_own_window_button(Lino.uploads.UploadsByController.grid) ] });
    var main_3_panel226 = new Ext.Panel({ "flex": 71, "border": false, "layout": "hbox", "labelWidth": 90, "hideCheckBoxLabels": true, "items": [ { "items": remark224, "labelAlign": "top", "layout": "form", "xtype": "panel", "flex": 66 }, UploadsByController_htmlbox225 ], "autoScroll": false, "layoutConfig": { "align": "stretch" }, "frame": false, "labelAlign": "top" });
    var main_panel228 = new Ext.Panel({ "autoScroll": false, "border": false, "layout": "vbox", "hideCheckBoxLabels": true, "items": [ main_1_panel209, main_2_panel219, main_3_panel226 ], "frame": true, "layoutConfig": { "align": "stretch" }, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel228;
    this.before_row_edit = function(record) {
      offer207.setContextValue('content', record ? record.data['contentHidden'] : undefined);
      UploadsByController_htmlbox225.refresh();
    }
    this.onRender = function(ct, position) {
      content206.on('change',Lino.chooser_handler(offer207,'content'));
      Lino.courses.CourseRequests.DetailFormPanel.superclass.onRender.call(this, ct, position);
    }
    Lino.courses.CourseRequests.DetailFormPanel.superclass.initComponent.call(this);
    // active_fields:
    offer207.on("change", function(){ this.save() }, this);
  }
});


Lino.users.Users.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 6,
  initComponent : function() {
    var username755 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Benutzername</span>", "name": "username", "listeners": { "render": Lino.quicktip_renderer("Benutzername","Required. Must be unique.") }, "maxLength": 30, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var profile756 = new Lino.ChoicesFieldElement({ "autoHeight": true, "forceSelection": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Benutzerprofil</span>", "name": "profile", "hiddenName": "profileHidden", "listeners": { "render": Lino.quicktip_renderer("Benutzerprofil","Users with an empty `profile` field are considered inactive and cannot log in.") }, "selectOnFocus": true, "anchor": "-20", "store": [['','<br>']].concat(Lino.users.UserProfiles) });
    var partner757 = new Lino.TwinCombo({ "preferred_width": 20, "autoHeight": true, "fieldLabel": "Partner", "name": "partner", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.contacts.Partners.detail,Lino.contacts.Partners.insert)}, "hiddenName": "partnerHidden", "selectOnFocus": true, "emptyText": "Partner ausw\u00e4hlen...", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/users/Users/partner", "method": "GET" }) }) });
    var box1_1_panel758 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 34, "autoHeight": true, "layout": "form", "xtype": "panel", "items": username755, "labelAlign": "top" }, { "flex": 32, "autoHeight": true, "layout": "form", "xtype": "panel", "items": profile756, "labelAlign": "top" }, { "flex": 32, "autoHeight": true, "layout": "form", "xtype": "panel", "items": partner757, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 135, "border": false, "anchor": "-20", "labelAlign": "top" });
    var first_name762 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Vorname", "name": "first_name", "maxLength": 30, "selectOnFocus": true, "anchor": "-20" });
    var last_name763 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Familienname", "name": "last_name", "maxLength": 30, "selectOnFocus": true, "anchor": "-20" });
    var initials764 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Initialien", "name": "initials", "maxLength": 10, "selectOnFocus": true, "boxMinWidth": Lino.chars2width(10), "anchor": "-20" });
    var box1_2_panel765 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 39, "autoHeight": true, "layout": "form", "xtype": "panel", "items": first_name762, "labelAlign": "top" }, { "flex": 39, "autoHeight": true, "layout": "form", "xtype": "panel", "items": last_name763, "labelAlign": "top" }, { "flex": 20, "autoHeight": true, "layout": "form", "xtype": "panel", "items": initials764, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 117, "border": false, "anchor": "-20", "labelAlign": "top" });
    var email769 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "e-mail address", "name": "email", "maxLength": 75, "selectOnFocus": true, "anchor": "-20" });
    var language770 = new Lino.ChoicesFieldElement({ "autoHeight": true, "fieldLabel": "Sprache", "name": "language", "selectOnFocus": true, "anchor": "-20", "store": [ [ "en", "Englisch" ], [ "fr", "Franz\u00f6sisch" ], [ "de", "Deutsch" ], [ "nl", "Niederl\u00e4ndisch" ] ], "hiddenName": "languageHidden" });
    var box1_3_panel771 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 51, "autoHeight": true, "layout": "form", "xtype": "panel", "items": email769, "labelAlign": "top" }, { "flex": 48, "autoHeight": true, "layout": "form", "xtype": "panel", "items": language770, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 135, "border": false, "anchor": "-20", "labelAlign": "top" });
    var id774 = new Ext.form.NumberField({ "selectOnFocus": true, "autoHeight": true, "fieldLabel": "ID", "anchor": "-20", "name": "id" });
    var created775 = new Ext.form.DisplayField({ "disabled": true, "autoHeight": true, "fieldLabel": "Erstellt", "name": "created", "anchor": "-20", "value": "<br>" });
    var modified776 = new Ext.form.DisplayField({ "disabled": true, "autoHeight": true, "fieldLabel": "Bearbeitet", "name": "modified", "anchor": "-20", "value": "<br>" });
    var box1_4_panel777 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 13, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id774, "labelAlign": "top" }, { "flex": 43, "autoHeight": true, "layout": "form", "xtype": "panel", "items": created775, "labelAlign": "top" }, { "flex": 43, "autoHeight": true, "layout": "form", "xtype": "panel", "items": modified776, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 99, "border": false, "anchor": "-20", "labelAlign": "top" });
    var box1_panel781 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "form", "hideCheckBoxLabels": true, "items": [ box1_1_panel758, box1_2_panel765, box1_3_panel771, box1_4_panel777 ], "frame": true, "bodyBorder": false, "labelAlign": "top" });
    var remarks782 = new Ext.form.TextArea({ "selectOnFocus": true, "fieldLabel": "Bemerkungen", "anchor": "-20 -10", "growMax": 2000, "name": "remarks" });
    var AuthoritiesGiven_grid785 = new Lino.users.AuthoritiesGiven.GridPanel({ "flex": 33, "hide_top_toolbar": true, "containing_panel": this, "master_panel": this, "tools": [ Lino.show_in_own_window_button(Lino.users.AuthoritiesGiven.grid) ], "hideHeaders": true, "preview_limit": 15 });
    var general_2_panel786 = new Ext.Panel({ "flex": 55, "border": false, "layout": "hbox", "labelWidth": 108, "hideCheckBoxLabels": true, "items": [ { "items": remarks782, "labelAlign": "top", "layout": "form", "xtype": "panel", "flex": 66 }, AuthoritiesGiven_grid785 ], "autoScroll": false, "layoutConfig": { "align": "stretch" }, "frame": false, "labelAlign": "top" });
    var general_panel788 = new Ext.Panel({ "layout": "vbox", "title": "Allgemein", "items": [ box1_panel781, general_2_panel786 ], "frame": true, "layoutConfig": { "align": "stretch" }, "hideCheckBoxLabels": true, "listeners": { "activate": Lino.on_tab_activate }, "autoScroll": false, "border": false, "bodyBorder": false, "labelAlign": "top" });
    var event_type789 = new Lino.TwinCombo({ "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Default Event Type</span>", "name": "event_type", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.cal.EventTypes.detail,Lino.cal.EventTypes.insert)}, "emptyText": "Ereignisart ausw\u00e4hlen...", "listeners": { "render": Lino.quicktip_renderer("Default Event Type","The default event type for your calendar events.") }, "selectOnFocus": true, "hiddenName": "event_typeHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/users/Users/event_type", "method": "GET" }) }) });
    var access_class790 = new Lino.ChoicesFieldElement({ "autoHeight": true, "forceSelection": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Standardm\u00e4\u00dfige Zugriffsklasse</span>", "allowBlank": false, "hiddenName": "access_classHidden", "listeners": { "render": Lino.quicktip_renderer("Standardm\u00e4\u00dfige Zugriffsklasse","Die standardm\u00e4\u00dfige Zugriffsklasse f\u00fcr Ihre Termine und Aufgaben") }, "selectOnFocus": true, "anchor": "-20", "store": Lino.cal.AccessClasses, "name": "access_class" });
    var cal_left_1_panel791 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 270, "hideCheckBoxLabels": true, "items": [ { "flex": 62, "autoHeight": true, "layout": "form", "xtype": "panel", "items": event_type789, "labelAlign": "top" }, { "flex": 37, "autoHeight": true, "layout": "form", "xtype": "panel", "items": access_class790, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var calendar794 = new Lino.TwinCombo({ "autoHeight": true, "fieldLabel": "Calendar where your events are published.", "name": "calendar", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.cal.Calendars.detail,Lino.cal.Calendars.insert)}, "emptyText": "Kalender ausw\u00e4hlen...", "selectOnFocus": true, "hiddenName": "calendarHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/users/Users/calendar", "method": "GET" }) }) });
    var cal_SubscriptionsByUser_grid799 = new Lino.cal.SubscriptionsByUser.GridPanel({ "flex": 71, "hide_top_toolbar": true, "containing_panel": this, "tools": [ Lino.show_in_own_window_button(Lino.cal.SubscriptionsByUser.grid) ], "preview_limit": 15, "master_panel": this });
    var cal_left_panel800 = new Ext.Panel({ "flex": 33, "layout": "vbox", "items": [ cal_left_1_panel791, { "items": calendar794, "autoHeight": true, "layout": "form", "xtype": "panel", "labelAlign": "top" }, cal_SubscriptionsByUser_grid799 ], "frame": true, "layoutConfig": { "align": "stretch" }, "autoScroll": false, "hideCheckBoxLabels": true, "labelWidth": 378, "border": false, "bodyBorder": false, "labelAlign": "top" });
    var cal_TasksByUser_grid830 = new Lino.cal.TasksByUser.GridPanel({ "flex": 66, "hide_top_toolbar": true, "containing_panel": this, "params_panel_hidden": true, "tools": [ Lino.show_in_own_window_button(Lino.cal.TasksByUser.grid) ], "preview_limit": 15, "master_panel": this });
    var cal_1_panel831 = new Ext.Panel({ "autoScroll": false, "listeners": { "activate": Lino.on_tab_activate }, "border": false, "layout": "hbox", "title": "Kalender", "hideCheckBoxLabels": true, "items": [ cal_left_panel800, cal_TasksByUser_grid830 ], "frame": false, "layoutConfig": { "align": "stretch" }, "labelAlign": "top" });
    var newcomer_quota832 = new Ext.form.NumberField({ "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Quote NZ</span>", "name": "newcomer_quota", "value": 0, "listeners": { "render": Lino.quicktip_renderer("Quote NZ","Wieviel Arbeitszeit dieser Benutzer f\u00fcr Neuantr\u00e4ge zur Verf\u00fcgung steht\n(100 = ganztags, 50 = halbtags, 0 = gar nicht).\nWenn zwei Benutzer die gleiche Belastungspunktzahl haben, \naber einer davon sich nur zu 50% um Neuantr\u00e4ge k\u00fcmmert, \ngilt er als doppelt so belastet wie sein Kollege.\n") }, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var coaching_type833 = new Lino.RemoteComboFieldElement({ "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Dienst</span>", "name": "coaching_type", "pageSize": 20, "emptyText": "Dienst ausw\u00e4hlen...", "listeners": { "render": Lino.quicktip_renderer("Dienst","The default CoachingType used when creating Coachings.") }, "selectOnFocus": true, "hiddenName": "coaching_typeHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/users/Users/coaching_type", "method": "GET" }) }) });
    var coaching_supervisor834 = new Ext.form.Checkbox({ "autoHeight": true, "hideLabel": true, "checked": false, "name": "coaching_supervisor", "listeners": { "render": Lino.quicktip_renderer("Benachrichtigung wenn ein Begleiter zugewiesen wird","Wenn ein Neuantrag einem Begleiter zugewiesen         wurde, wird au\u00dfer dem Begleiter auch dieser Benutzer         benachrichtigt.") }, "boxLabel": "Benachrichtigung wenn ein Begleiter zugewiesen wird", "selectOnFocus": true, "anchor": "-20" });
    var newcomers_CompetencesByUser_grid840 = new Lino.newcomers.CompetencesByUser.GridPanel({ "flex": 62, "hide_top_toolbar": true, "containing_panel": this, "tools": [ Lino.show_in_own_window_button(Lino.newcomers.CompetencesByUser.grid) ], "preview_limit": 15, "master_panel": this });
    var coaching_a_panel841 = new Ext.Panel({ "flex": 33, "layout": "vbox", "items": [ { "items": newcomer_quota832, "autoHeight": true, "layout": "form", "xtype": "panel", "labelAlign": "top" }, { "items": coaching_type833, "autoHeight": true, "layout": "form", "xtype": "panel", "labelAlign": "top" }, { "items": coaching_supervisor834, "autoHeight": true, "layout": "form", "xtype": "panel", "labelAlign": "top" }, newcomers_CompetencesByUser_grid840 ], "frame": true, "layoutConfig": { "align": "stretch" }, "autoScroll": false, "hideCheckBoxLabels": true, "labelWidth": 468, "border": false, "bodyBorder": false, "labelAlign": "top" });
    var pcsw_CoachingsByUser_grid871 = new Lino.pcsw.CoachingsByUser.GridPanel({ "flex": 66, "hide_top_toolbar": true, "containing_panel": this, "params_panel_hidden": true, "tools": [ Lino.show_in_own_window_button(Lino.pcsw.CoachingsByUser.grid) ], "preview_limit": 15, "master_panel": this });
    var coaching_1_panel872 = new Ext.Panel({ "autoScroll": false, "listeners": { "activate": Lino.on_tab_activate }, "border": false, "layout": "hbox", "title": "Begleitung", "hideCheckBoxLabels": true, "items": [ coaching_a_panel841, pcsw_CoachingsByUser_grid871 ], "frame": false, "layoutConfig": { "align": "stretch" }, "labelAlign": "top" });
    var main_panel873 = new Ext.TabPanel({ "hideCheckBoxLabels": true, "border": false, "split": true, "autoScroll": false, "items": [ general_panel788, cal_1_panel831, coaching_1_panel872 ], "activeTab": 0, "bodyBorder": false, "frame": true, "labelAlign": "top" });
    this.items = main_panel873;
    this.before_row_edit = function(record) {
      AuthoritiesGiven_grid785.on_master_changed();
      cal_SubscriptionsByUser_grid799.on_master_changed();
      cal_TasksByUser_grid830.on_master_changed();
      newcomers_CompetencesByUser_grid840.on_master_changed();
      pcsw_CoachingsByUser_grid871.on_master_changed();
    }
    Lino.users.Users.DetailFormPanel.superclass.initComponent.call(this);
    // active_fields:
    partner757.on("change", function(){ this.save() }, this);
  }
});


Lino.newcomers.Faculties.InsertFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  autoHeight: true,
  content_type: 96,
  initComponent : function() {
    var name4390 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Bezeichnung", "name": "name", "maxLength": 200, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var name_fr4391 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Bezeichnung (fr)", "name": "name_fr", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var name_de4392 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Bezeichnung (de)", "name": "name_de", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var name_nl4393 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Bezeichnung (nl)", "name": "name_nl", "maxLength": 200, "selectOnFocus": true, "hidden": true, "anchor": "-20" });
    var main_1_panel4394 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 25, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name4390, "labelAlign": "top" }, { "flex": 25, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_fr4391, "labelAlign": "top" }, { "flex": 25, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_de4392, "labelAlign": "top" }, { "flex": 25, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_nl4393, "hidden": true, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 153, "border": false, "anchor": "-20", "labelAlign": "top" });
    var weight4399 = new Ext.form.NumberField({ "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Aufwand</span>", "name": "weight", "value": 10, "listeners": { "render": Lino.quicktip_renderer("Aufwand","Wieviel Aufwand ein Neuantrag in diesem Fachbereich allgemein verursacht\n(0 = gar kein Aufwand, 10 = maximaler Aufwand).") }, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var main_panel4400 = new Ext.Panel({ "hideCheckBoxLabels": true, "autoHeight": true, "border": false, "layout": "form", "labelWidth": 72, "autoScroll": false, "items": [ main_1_panel4394, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": weight4399, "anchor": "-20", "labelAlign": "top" } ], "frame": true, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel4400;
    this.before_row_edit = function(record) {
    }
    Lino.newcomers.Faculties.InsertFormPanel.superclass.initComponent.call(this);
  }
});


Lino.cal.Events.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 37,
  initComponent : function() {
    var event_type951 = new Lino.TwinCombo({ "autoHeight": true, "fieldLabel": "Ereignisart", "name": "event_type", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.cal.EventTypes.detail,Lino.cal.EventTypes.insert)}, "emptyText": "Ereignisart ausw\u00e4hlen...", "selectOnFocus": true, "hiddenName": "event_typeHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/Events/event_type", "method": "GET" }) }) });
    var summary952 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Kurzbeschreibung", "name": "summary", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var project953 = new Lino.TwinCombo({ "preferred_width": 20, "autoHeight": true, "fieldLabel": "Klient", "name": "project", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.pcsw.Clients.detail,Lino.pcsw.Clients.insert)}, "hiddenName": "projectHidden", "selectOnFocus": true, "emptyText": "Klient ausw\u00e4hlen...", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/Events/project", "method": "GET" }) }) });
    var general_1_panel954 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 153, "hideCheckBoxLabels": true, "items": [ { "flex": 32, "autoHeight": true, "layout": "form", "xtype": "panel", "items": event_type951, "labelAlign": "top" }, { "flex": 34, "autoHeight": true, "layout": "form", "xtype": "panel", "items": summary952, "labelAlign": "top" }, { "flex": 32, "autoHeight": true, "layout": "form", "xtype": "panel", "items": project953, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var start_date958 = new Lino.DateField({ "selectOnFocus": true, "autoHeight": true, "fieldLabel": "Beginnt am", "anchor": "-20", "name": "start_date" });
    var start_time959 = new Lino.TimeField({ "selectOnFocus": true, "autoHeight": true, "fieldLabel": "Beginnt um", "anchor": "-20", "name": "start_time" });
    var start_panel960 = new Ext.Panel({ "flex": 25, "autoHeight": true, "layout": "hbox", "items": [ { "flex": 61, "autoHeight": true, "layout": "form", "xtype": "panel", "items": start_date958, "labelAlign": "top" }, { "flex": 38, "autoHeight": true, "layout": "form", "xtype": "panel", "items": start_time959, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "autoScroll": false, "hideCheckBoxLabels": true, "labelWidth": 99, "border": false, "labelAlign": "top" });
    var end_date963 = new Lino.DateField({ "selectOnFocus": true, "autoHeight": true, "fieldLabel": "Endet am", "anchor": "-20", "name": "end_date" });
    var end_time964 = new Lino.TimeField({ "selectOnFocus": true, "autoHeight": true, "fieldLabel": "Endet um", "anchor": "-20", "name": "end_time" });
    var end_panel965 = new Ext.Panel({ "flex": 25, "autoHeight": true, "layout": "hbox", "items": [ { "flex": 61, "autoHeight": true, "layout": "form", "xtype": "panel", "items": end_date963, "labelAlign": "top" }, { "flex": 38, "autoHeight": true, "layout": "form", "xtype": "panel", "items": end_time964, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "autoScroll": false, "hideCheckBoxLabels": true, "labelWidth": 81, "border": false, "labelAlign": "top" });
    var user968 = new Lino.TwinCombo({ "preferred_width": 15, "autoHeight": true, "fieldLabel": "Verwaltet durch", "name": "user", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.users.Users.detail,Lino.users.Users.insert)}, "hiddenName": "userHidden", "selectOnFocus": true, "emptyText": "Benutzer ausw\u00e4hlen...", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/Events/user", "method": "GET" }) }) });
    var assigned_to969 = new Lino.TwinCombo({ "preferred_width": 15, "autoHeight": true, "fieldLabel": "Zugewiesen zu", "name": "assigned_to", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.users.Users.detail,Lino.users.Users.insert)}, "hiddenName": "assigned_toHidden", "selectOnFocus": true, "emptyText": "Benutzer ausw\u00e4hlen...", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/Events/assigned_to", "method": "GET" }) }) });
    var general_2_panel970 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 144, "hideCheckBoxLabels": true, "items": [ start_panel960, end_panel965, { "flex": 24, "autoHeight": true, "layout": "form", "xtype": "panel", "items": user968, "labelAlign": "top" }, { "flex": 24, "autoHeight": true, "layout": "form", "xtype": "panel", "items": assigned_to969, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var room973 = new Lino.TwinCombo({ "autoHeight": true, "fieldLabel": "Raum", "name": "room", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.cal.Rooms.detail,Lino.cal.Rooms.insert)}, "emptyText": "Raum ausw\u00e4hlen...", "selectOnFocus": true, "hiddenName": "roomHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/Events/room", "method": "GET" }) }) });
    var priority974 = new Lino.RemoteComboFieldElement({ "autoHeight": true, "fieldLabel": "Priorit\u00e4t", "name": "priority", "pageSize": 20, "emptyText": "Priorit\u00e4t ausw\u00e4hlen...", "selectOnFocus": true, "hiddenName": "priorityHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/Events/priority", "method": "GET" }) }) });
    var access_class975 = new Lino.ChoicesFieldElement({ "autoHeight": true, "forceSelection": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Zugriffsklasse</span>", "name": "access_class", "hiddenName": "access_classHidden", "listeners": { "render": Lino.quicktip_renderer("Zugriffsklasse","Ob dieser Termin  privat, \u00f6ffentlich oder halb \u00f6ffentlich ist") }, "selectOnFocus": true, "anchor": "-20", "store": [['','<br>']].concat(Lino.cal.AccessClasses) });
    var transparent976 = new Ext.form.Checkbox({ "autoHeight": true, "hideLabel": true, "checked": false, "name": "transparent", "listeners": { "render": Lino.quicktip_renderer("nicht blockierend","Dieser Termin l\u00e4sst auch andere Termine zur gleichen Zeit zu.") }, "boxLabel": "nicht blockierend", "selectOnFocus": true, "anchor": "-20" });
    var general_3_panel977 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 162, "hideCheckBoxLabels": true, "items": [ { "flex": 32, "autoHeight": true, "layout": "form", "xtype": "panel", "items": room973, "labelAlign": "top" }, { "flex": 32, "autoHeight": true, "layout": "form", "xtype": "panel", "items": priority974, "labelAlign": "top" }, { "flex": 19, "autoHeight": true, "layout": "form", "xtype": "panel", "items": access_class975, "labelAlign": "top" }, { "flex": 16, "autoHeight": true, "layout": "form", "xtype": "panel", "items": transparent976, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var owner_disp982 = new Ext.form.DisplayField({ "disabled": true, "autoHeight": true, "fieldLabel": "Verkn\u00fcpft mit", "anchor": "-20", "name": "owner" });
    var workflow_buttons_disp983 = new Ext.form.DisplayField({ "disabled": true, "autoHeight": true, "fieldLabel": "Arbeitsablauf", "name": "workflow_buttons", "anchor": "-20", "value": "<br/>", "always_enabled": true });
    var general_4_panel984 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 126, "hideCheckBoxLabels": true, "items": [ { "flex": 25, "autoHeight": true, "layout": "form", "xtype": "panel", "items": owner_disp982, "labelAlign": "top" }, { "flex": 75, "autoHeight": true, "layout": "form", "xtype": "panel", "items": workflow_buttons_disp983, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var description987 = new Ext.form.TextArea({ "selectOnFocus": true, "fieldLabel": "Beschreibung", "anchor": "-20 -10", "growMax": 2000, "name": "description" });
    var GuestsByEvent_grid1039 = new Lino.cal.GuestsByEvent.GridPanel({ "flex": 53, "hide_top_toolbar": true, "containing_panel": this, "tools": [ Lino.show_in_own_window_button(Lino.cal.GuestsByEvent.grid) ], "preview_limit": 15, "master_panel": this });
    var general_5_panel1040 = new Ext.Panel({ "flex": 45, "border": false, "layout": "hbox", "labelWidth": 117, "hideCheckBoxLabels": true, "items": [ { "items": description987, "labelAlign": "top", "layout": "form", "xtype": "panel", "flex": 46 }, GuestsByEvent_grid1039 ], "autoScroll": false, "layoutConfig": { "align": "stretch" }, "frame": false, "labelAlign": "top" });
    var general_panel1042 = new Ext.Panel({ "layout": "vbox", "title": "Allgemein", "items": [ general_1_panel954, general_2_panel970, general_3_panel977, general_4_panel984, general_5_panel1040 ], "frame": true, "layoutConfig": { "align": "stretch" }, "hideCheckBoxLabels": true, "listeners": { "activate": Lino.on_tab_activate }, "autoScroll": false, "border": false, "bodyBorder": false, "labelAlign": "top" });
    var id1043 = new Ext.form.NumberField({ "selectOnFocus": true, "autoHeight": true, "fieldLabel": "ID", "anchor": "-20", "name": "id" });
    var created1044 = new Ext.form.DisplayField({ "disabled": true, "autoHeight": true, "fieldLabel": "Erstellt", "name": "created", "anchor": "-20", "value": "<br>" });
    var modified1045 = new Ext.form.DisplayField({ "disabled": true, "autoHeight": true, "fieldLabel": "Bearbeitet", "name": "modified", "anchor": "-20", "value": "<br>" });
    var state1046 = new Lino.ChoicesFieldElement({ "autoHeight": true, "forceSelection": true, "fieldLabel": "Zustand", "allowBlank": false, "hiddenName": "stateHidden", "selectOnFocus": true, "anchor": "-20", "store": Lino.cal.EventStates, "name": "state" });
    var more_1_panel1047 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 99, "hideCheckBoxLabels": true, "items": [ { "flex": 8, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id1043, "labelAlign": "top" }, { "flex": 34, "autoHeight": true, "layout": "form", "xtype": "panel", "items": created1044, "labelAlign": "top" }, { "flex": 34, "autoHeight": true, "layout": "form", "xtype": "panel", "items": modified1045, "labelAlign": "top" }, { "flex": 22, "autoHeight": true, "layout": "form", "xtype": "panel", "items": state1046, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var outbox_MailsByController_grid1052 = new Lino.outbox.MailsByController.GridPanel({ "flex": 83, "hide_top_toolbar": true, "containing_panel": this, "tools": [ Lino.show_in_own_window_button(Lino.outbox.MailsByController.grid) ], "preview_limit": 15, "master_panel": this });
    var more_panel1053 = new Ext.Panel({ "layout": "vbox", "title": "Mehr", "items": [ more_1_panel1047, outbox_MailsByController_grid1052 ], "frame": true, "layoutConfig": { "align": "stretch" }, "hideCheckBoxLabels": true, "listeners": { "activate": Lino.on_tab_activate }, "autoScroll": false, "border": false, "bodyBorder": false, "labelAlign": "top" });
    var main_panel1054 = new Ext.TabPanel({ "hideCheckBoxLabels": true, "border": false, "split": true, "autoScroll": false, "items": [ general_panel1042, more_panel1053 ], "activeTab": 0, "bodyBorder": false, "frame": true, "labelAlign": "top" });
    this.items = main_panel1054;
    this.before_row_edit = function(record) {
      GuestsByEvent_grid1039.on_master_changed();
      outbox_MailsByController_grid1052.on_master_changed();
    }
    Lino.cal.Events.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.cal.Events.InsertFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  autoHeight: true,
  content_type: 37,
  initComponent : function() {
    var summary1055 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Kurzbeschreibung", "name": "summary", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var start_date1056 = new Lino.DateField({ "selectOnFocus": true, "autoHeight": true, "fieldLabel": "Beginnt am", "anchor": "-20", "name": "start_date" });
    var start_time1057 = new Lino.TimeField({ "selectOnFocus": true, "autoHeight": true, "fieldLabel": "Beginnt um", "anchor": "-20", "name": "start_time" });
    var start_panel1058 = new Ext.Panel({ "flex": 50, "autoHeight": true, "layout": "hbox", "items": [ { "flex": 61, "autoHeight": true, "layout": "form", "xtype": "panel", "items": start_date1056, "labelAlign": "top" }, { "flex": 38, "autoHeight": true, "layout": "form", "xtype": "panel", "items": start_time1057, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "autoScroll": false, "hideCheckBoxLabels": true, "labelWidth": 99, "border": false, "labelAlign": "top" });
    var end_date1061 = new Lino.DateField({ "selectOnFocus": true, "autoHeight": true, "fieldLabel": "Endet am", "anchor": "-20", "name": "end_date" });
    var end_time1062 = new Lino.TimeField({ "selectOnFocus": true, "autoHeight": true, "fieldLabel": "Endet um", "anchor": "-20", "name": "end_time" });
    var end_panel1063 = new Ext.Panel({ "flex": 50, "autoHeight": true, "layout": "hbox", "items": [ { "flex": 61, "autoHeight": true, "layout": "form", "xtype": "panel", "items": end_date1061, "labelAlign": "top" }, { "flex": 38, "autoHeight": true, "layout": "form", "xtype": "panel", "items": end_time1062, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "autoScroll": false, "hideCheckBoxLabels": true, "labelWidth": 81, "border": false, "labelAlign": "top" });
    var main_2_panel1066 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "hideCheckBoxLabels": true, "items": [ start_panel1058, end_panel1063 ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "anchor": "-20", "labelAlign": "top" });
    var event_type1067 = new Lino.TwinCombo({ "autoHeight": true, "fieldLabel": "Ereignisart", "name": "event_type", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.cal.EventTypes.detail,Lino.cal.EventTypes.insert)}, "emptyText": "Ereignisart ausw\u00e4hlen...", "selectOnFocus": true, "hiddenName": "event_typeHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/Events/event_type", "method": "GET" }) }) });
    var project1068 = new Lino.TwinCombo({ "preferred_width": 20, "autoHeight": true, "fieldLabel": "Klient", "name": "project", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.pcsw.Clients.detail,Lino.pcsw.Clients.insert)}, "hiddenName": "projectHidden", "selectOnFocus": true, "emptyText": "Klient ausw\u00e4hlen...", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/Events/project", "method": "GET" }) }) });
    var main_3_panel1069 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": event_type1067, "labelAlign": "top" }, { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": project1068, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 108, "border": false, "anchor": "-20", "labelAlign": "top" });
    var main_panel1072 = new Ext.Panel({ "hideCheckBoxLabels": true, "autoHeight": true, "border": false, "layout": "form", "labelWidth": 153, "autoScroll": false, "items": [ { "autoHeight": true, "layout": "form", "xtype": "panel", "items": summary1055, "anchor": "-20", "labelAlign": "top" }, main_2_panel1066, main_3_panel1069 ], "frame": true, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel1072;
    this.before_row_edit = function(record) {
    }
    Lino.cal.Events.InsertFormPanel.superclass.initComponent.call(this);
  }
});


Lino.cal.Guests.InsertFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  autoHeight: true,
  content_type: 33,
  initComponent : function() {
    var event1032 = new Lino.TwinCombo({ "autoHeight": true, "fieldLabel": "Termin", "allowBlank": false, "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.cal.OneEvent.detail,Lino.cal.OneEvent.insert)}, "emptyText": "Termin ausw\u00e4hlen...", "selectOnFocus": true, "hiddenName": "eventHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/Guests/event", "method": "GET" }) }), "name": "event" });
    var partner1033 = new Lino.TwinCombo({ "preferred_width": 20, "autoHeight": true, "fieldLabel": "Partner", "allowBlank": false, "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.contacts.Partners.detail,Lino.contacts.Partners.insert)}, "emptyText": "Partner ausw\u00e4hlen...", "selectOnFocus": true, "hiddenName": "partnerHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/Guests/partner", "method": "GET" }) }), "name": "partner" });
    var role1034 = new Lino.TwinCombo({ "autoHeight": true, "fieldLabel": "Rolle", "name": "role", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.cal.GuestRoles.detail,Lino.cal.GuestRoles.insert)}, "emptyText": "Gastrolle ausw\u00e4hlen...", "selectOnFocus": true, "hiddenName": "roleHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/Guests/role", "method": "GET" }) }) });
    var main_panel1035 = new Ext.Panel({ "hideCheckBoxLabels": true, "autoHeight": true, "border": false, "layout": "form", "labelWidth": 72, "autoScroll": false, "items": [ { "autoHeight": true, "layout": "form", "xtype": "panel", "items": event1032, "anchor": "-20", "labelAlign": "top" }, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": partner1033, "anchor": "-20", "labelAlign": "top" }, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": role1034, "anchor": "-20", "labelAlign": "top" } ], "frame": true, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel1035;
    this.before_row_edit = function(record) {
    }
    Lino.cal.Guests.InsertFormPanel.superclass.initComponent.call(this);
  }
});


Lino.jobs.JobProviders.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 87,
  initComponent : function() {
    var overview_disp3028 = new Ext.form.DisplayField({ "disabled": true, "flex": 28, "name": "overview", "value": "<br/>", "always_enabled": true });
    var prefix3029 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Name prefix", "name": "prefix", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var name3030 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Name", "name": "name", "maxLength": 200, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var general2_1_panel3031 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": prefix3029, "labelAlign": "top" }, { "flex": 66, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name3030, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 108, "border": false, "anchor": "-20", "labelAlign": "top" });
    var type3034 = new Lino.RemoteComboFieldElement({ "autoHeight": true, "fieldLabel": "Organisationsart", "name": "type", "pageSize": 20, "emptyText": "Organisationsart ausw\u00e4hlen...", "selectOnFocus": true, "hiddenName": "typeHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/jobs/JobProviders/type", "method": "GET" }) }) });
    var vat_id3035 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "MWSt.-Nr.", "name": "vat_id", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var general2_2_panel3036 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 48, "autoHeight": true, "layout": "form", "xtype": "panel", "items": type3034, "labelAlign": "top" }, { "flex": 51, "autoHeight": true, "layout": "form", "xtype": "panel", "items": vat_id3035, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 153, "border": false, "anchor": "-20", "labelAlign": "top" });
    var client_contact_type3039 = new Lino.TwinCombo({ "autoHeight": true, "fieldLabel": "Klientenkontaktart", "name": "client_contact_type", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.pcsw.ClientContactTypes.detail,Lino.pcsw.ClientContactTypes.insert)}, "emptyText": "Klientenkontaktart ausw\u00e4hlen...", "selectOnFocus": true, "hiddenName": "client_contact_typeHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/jobs/JobProviders/client_contact_type", "method": "GET" }) }) });
    var url3040 = new Lino.URLField({ "autoHeight": true, "fieldLabel": "URL", "name": "url", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var general2_panel3041 = new Ext.Panel({ "flex": 42, "autoHeight": true, "layout": "form", "items": [ general2_1_panel3031, general2_2_panel3036, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": client_contact_type3039, "anchor": "-20", "labelAlign": "top" }, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": url3040, "anchor": "-20", "labelAlign": "top" } ], "frame": true, "bodyBorder": false, "autoScroll": false, "hideCheckBoxLabels": true, "labelWidth": 171, "border": false, "labelAlign": "top" });
    var email3044 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "E-Mail", "name": "email", "maxLength": 75, "selectOnFocus": true, "anchor": "-20" });
    var phone3045 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Telefon", "name": "phone", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var gsm3046 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "GSM", "name": "gsm", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var fax3047 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Fax", "name": "fax", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var general3_panel3048 = new Ext.Panel({ "flex": 28, "autoHeight": true, "layout": "form", "items": [ { "autoHeight": true, "layout": "form", "xtype": "panel", "items": email3044, "anchor": "-20", "labelAlign": "top" }, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": phone3045, "anchor": "-20", "labelAlign": "top" }, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": gsm3046, "anchor": "-20", "labelAlign": "top" }, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": fax3047, "anchor": "-20", "labelAlign": "top" } ], "frame": true, "bodyBorder": false, "autoScroll": false, "hideCheckBoxLabels": true, "labelWidth": 72, "border": false, "labelAlign": "top" });
    var general_1_panel3053 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 0, "hideCheckBoxLabels": true, "items": [ overview_disp3028, general2_panel3041, general3_panel3048 ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var contacts_RolesByCompany_grid3054 = new Lino.contacts.RolesByCompany.GridPanel({ "flex": 55, "hide_top_toolbar": true, "containing_panel": this, "tools": [ Lino.show_in_own_window_button(Lino.contacts.RolesByCompany.grid) ], "preview_limit": 15, "master_panel": this });
    var general_panel3055 = new Ext.Panel({ "layout": "vbox", "title": "Allgemein", "items": [ general_1_panel3053, contacts_RolesByCompany_grid3054 ], "frame": true, "layoutConfig": { "align": "stretch" }, "hideCheckBoxLabels": true, "listeners": { "activate": Lino.on_tab_activate }, "autoScroll": false, "border": false, "bodyBorder": false, "labelAlign": "top" });
    var notes_NotesByCompany_grid3056 = new Lino.notes.NotesByCompany.GridPanel({ "listeners": { "activate": Lino.on_tab_activate }, "hide_top_toolbar": true, "containing_panel": this, "title": "Ereignisse/Notizen", "tools": [ Lino.show_in_own_window_button(Lino.notes.NotesByCompany.grid) ], "preview_limit": 15, "master_panel": this });
    var JobsByProvider_grid3129 = new Lino.jobs.JobsByProvider.GridPanel({ "flex": 5, "hide_top_toolbar": true, "containing_panel": this, "region": "north", "preview_limit": 15, "master_panel": this, "split": true, "tools": [ Lino.show_in_own_window_button(Lino.jobs.JobsByProvider.grid) ] });
    var ContractsByProvider_grid3157 = new Lino.jobs.ContractsByProvider.GridPanel({ "flex": 5, "hide_top_toolbar": true, "containing_panel": this, "region": "center", "params_panel_hidden": true, "master_panel": this, "preview_limit": 15, "split": true, "tools": [ Lino.show_in_own_window_button(Lino.jobs.ContractsByProvider.grid) ] });
    var jobs_panel3158 = new Lino.VBorderPanel({ "autoScroll": false, "listeners": { "activate": Lino.on_tab_activate }, "border": false, "title": "Stellen", "hideCheckBoxLabels": true, "items": [ JobsByProvider_grid3129, ContractsByProvider_grid3157 ], "frame": true, "bodyBorder": false, "labelAlign": "top" });
    var main_panel3159 = new Ext.TabPanel({ "hideCheckBoxLabels": true, "border": false, "split": true, "autoScroll": false, "items": [ general_panel3055, notes_NotesByCompany_grid3056, jobs_panel3158 ], "activeTab": 0, "bodyBorder": false, "frame": true, "labelAlign": "top" });
    this.items = main_panel3159;
    this.before_row_edit = function(record) {
      contacts_RolesByCompany_grid3054.on_master_changed();
      notes_NotesByCompany_grid3056.on_master_changed();
      JobsByProvider_grid3129.on_master_changed();
      ContractsByProvider_grid3157.on_master_changed();
    }
    Lino.jobs.JobProviders.DetailFormPanel.superclass.initComponent.call(this);
    // active_fields:
  }
});


Lino.polls.Polls.InsertFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 124,
  initComponent : function() {
    var title4954 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Anrede", "name": "title", "maxLength": 200, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var default_choiceset4955 = new Lino.TwinCombo({ "autoHeight": true, "fieldLabel": "Default Choiceset", "name": "default_choiceset", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.polls.ChoiceSets.detail,Lino.polls.ChoiceSets.insert)}, "emptyText": "Choice Set ausw\u00e4hlen...", "selectOnFocus": true, "hiddenName": "default_choicesetHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/polls/Polls/default_choiceset", "method": "GET" }) }) });
    var default_multiple_choices4956 = new Ext.form.Checkbox({ "boxLabel": "Allow multiple choices", "autoHeight": true, "hideLabel": true, "checked": false, "name": "default_multiple_choices", "selectOnFocus": true, "anchor": "-20" });
    var main_2_panel4957 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 207, "hideCheckBoxLabels": true, "items": [ { "flex": 66, "autoHeight": true, "layout": "form", "xtype": "panel", "items": default_choiceset4955, "labelAlign": "top" }, { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": default_multiple_choices4956, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var questions_to_add4960 = new Ext.form.TextArea({ "listeners": { "render": Lino.quicktip_renderer("Questions to add","Paste text for questions to add. Every non-empty line will create one question.") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Questions to add</span>", "name": "questions_to_add", "growMax": 2000, "selectOnFocus": true, "anchor": "-20 -10" });
    var main_panel4961 = new Ext.Panel({ "autoScroll": false, "border": false, "layout": "vbox", "labelWidth": 153, "hideCheckBoxLabels": true, "items": [ { "items": title4954, "autoHeight": true, "layout": "form", "xtype": "panel", "labelAlign": "top" }, main_2_panel4957, { "items": questions_to_add4960, "labelAlign": "top", "layout": "form", "xtype": "panel", "flex": 71 } ], "frame": true, "layoutConfig": { "align": "stretch" }, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel4961;
    this.before_row_edit = function(record) {
    }
    Lino.polls.Polls.InsertFormPanel.superclass.initComponent.call(this);
  }
});


Lino.cal.Tasks.InsertFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  autoHeight: true,
  content_type: 28,
  initComponent : function() {
    var summary822 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Kurzbeschreibung", "name": "summary", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var user823 = new Lino.TwinCombo({ "preferred_width": 15, "autoHeight": true, "fieldLabel": "Autor", "name": "user", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.users.Users.detail,Lino.users.Users.insert)}, "hiddenName": "userHidden", "selectOnFocus": true, "emptyText": "Benutzer ausw\u00e4hlen...", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/Tasks/user", "method": "GET" }) }) });
    var project824 = new Lino.TwinCombo({ "preferred_width": 20, "autoHeight": true, "fieldLabel": "Klient", "name": "project", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.pcsw.Clients.detail,Lino.pcsw.Clients.insert)}, "hiddenName": "projectHidden", "selectOnFocus": true, "emptyText": "Klient ausw\u00e4hlen...", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/Tasks/project", "method": "GET" }) }) });
    var main_2_panel825 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": user823, "labelAlign": "top" }, { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": project824, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 63, "border": false, "anchor": "-20", "labelAlign": "top" });
    var main_panel828 = new Ext.Panel({ "hideCheckBoxLabels": true, "autoHeight": true, "border": false, "layout": "form", "labelWidth": 153, "autoScroll": false, "items": [ { "autoHeight": true, "layout": "form", "xtype": "panel", "items": summary822, "anchor": "-20", "labelAlign": "top" }, main_2_panel825 ], "frame": true, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel828;
    this.before_row_edit = function(record) {
    }
    Lino.cal.Tasks.InsertFormPanel.superclass.initComponent.call(this);
  }
});


Lino.aids.IncomeConfirmations.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 114,
  initComponent : function() {
    var client4618 = new Lino.TwinCombo({ "preferred_width": 20, "autoHeight": true, "fieldLabel": "Klient", "allowBlank": false, "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.pcsw.Clients.detail,Lino.pcsw.Clients.insert)}, "emptyText": "Klient ausw\u00e4hlen...", "selectOnFocus": true, "hiddenName": "clientHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/aids/IncomeConfirmations/client", "method": "GET" }) }), "name": "client" });
    var user4619 = new Lino.TwinCombo({ "preferred_width": 15, "autoHeight": true, "fieldLabel": "Autor", "name": "user", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.users.Users.detail,Lino.users.Users.insert)}, "hiddenName": "userHidden", "selectOnFocus": true, "emptyText": "Benutzer ausw\u00e4hlen...", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/aids/IncomeConfirmations/user", "method": "GET" }) }) });
    var signer4620 = new Lino.TwinCombo({ "preferred_width": 15, "autoHeight": true, "fieldLabel": "Best\u00e4tiger", "name": "signer", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.users.Users.detail,Lino.users.Users.insert)}, "hiddenName": "signerHidden", "selectOnFocus": true, "emptyText": "Benutzer ausw\u00e4hlen...", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/aids/IncomeConfirmations/signer", "method": "GET" }) }) });
    var workflow_buttons_disp4621 = new Ext.form.DisplayField({ "disabled": true, "autoHeight": true, "fieldLabel": "Arbeitsablauf", "name": "workflow_buttons", "anchor": "-20", "value": "<br/>", "always_enabled": true });
    var printed_disp4622 = new Ext.form.DisplayField({ "disabled": true, "autoHeight": true, "fieldLabel": "Ausgedruckt", "name": "printed", "anchor": "-20", "value": "<br/>", "always_enabled": true });
    var main_1_panel4623 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 126, "hideCheckBoxLabels": true, "items": [ { "flex": 16, "autoHeight": true, "layout": "form", "xtype": "panel", "items": client4618, "labelAlign": "top" }, { "flex": 16, "autoHeight": true, "layout": "form", "xtype": "panel", "items": user4619, "labelAlign": "top" }, { "flex": 16, "autoHeight": true, "layout": "form", "xtype": "panel", "items": signer4620, "labelAlign": "top" }, { "flex": 25, "autoHeight": true, "layout": "form", "xtype": "panel", "items": workflow_buttons_disp4621, "labelAlign": "top" }, { "flex": 25, "autoHeight": true, "layout": "form", "xtype": "panel", "items": printed_disp4622, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var company4629 = new Lino.TwinCombo({ "preferred_width": 20, "autoHeight": true, "fieldLabel": "Empf\u00e4nger (Organisation)", "name": "company", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.contacts.Companies.detail,Lino.contacts.Companies.insert)}, "hiddenName": "companyHidden", "selectOnFocus": true, "emptyText": "Organisation ausw\u00e4hlen...", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/aids/IncomeConfirmations/company", "method": "GET" }) }) });
    var contact_person4630 = new Lino.TwinCombo({ "preferred_width": 20, "autoHeight": true, "fieldLabel": "Empf\u00e4nger (Person)", "name": "contact_person", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.contacts.Persons.detail,Lino.contacts.Persons.insert)}, "hiddenName": "contact_personHidden", "selectOnFocus": true, "emptyText": "Person ausw\u00e4hlen...", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/aids/IncomeConfirmations/contact_person", "method": "GET" }) }) });
    var main_2_panel4631 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 225, "hideCheckBoxLabels": true, "items": [ { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": company4629, "labelAlign": "top" }, { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": contact_person4630, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var granting4634 = new Lino.TwinCombo({ "autoHeight": true, "fieldLabel": "Hilfebeschluss", "name": "granting", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.aids.GrantingsByX.detail,Lino.aids.GrantingsByX.insert)}, "emptyText": "Hilfebeschluss ausw\u00e4hlen...", "selectOnFocus": true, "hiddenName": "grantingHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/aids/IncomeConfirmations/granting", "method": "GET" }) }) });
    var start_date4635 = new Lino.DateField({ "selectOnFocus": true, "autoHeight": true, "fieldLabel": "Periode vom", "anchor": "-20", "name": "start_date" });
    var end_date4636 = new Lino.DateField({ "selectOnFocus": true, "autoHeight": true, "fieldLabel": "bis", "anchor": "-20", "name": "end_date" });
    var main_3_panel4637 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 135, "hideCheckBoxLabels": true, "items": [ { "flex": 49, "autoHeight": true, "layout": "form", "xtype": "panel", "items": granting4634, "labelAlign": "top" }, { "flex": 25, "autoHeight": true, "layout": "form", "xtype": "panel", "items": start_date4635, "labelAlign": "top" }, { "flex": 25, "autoHeight": true, "layout": "form", "xtype": "panel", "items": end_date4636, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var category4641 = new Lino.TwinCombo({ "autoHeight": true, "fieldLabel": "Kategorie", "name": "category", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.aids.Categories.detail,Lino.aids.Categories.insert)}, "emptyText": "Kategorie ausw\u00e4hlen...", "selectOnFocus": true, "hiddenName": "categoryHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/aids/IncomeConfirmations/category", "method": "GET" }) }) });
    var amount4642 = new Ext.form.NumberField({ "autoHeight": true, "decimalPrecision": 2, "fieldLabel": "Betrag", "name": "amount", "decimalSeparator": ",", "selectOnFocus": true, "anchor": "-20", "allowBlank": true });
    var id4643 = new Ext.form.NumberField({ "selectOnFocus": true, "autoHeight": true, "fieldLabel": "ID", "anchor": "-20", "name": "id" });
    var main_4_panel4644 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 90, "hideCheckBoxLabels": true, "items": [ { "flex": 54, "autoHeight": true, "layout": "form", "xtype": "panel", "items": category4641, "labelAlign": "top" }, { "flex": 32, "autoHeight": true, "layout": "form", "xtype": "panel", "items": amount4642, "labelAlign": "top" }, { "flex": 13, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id4643, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var remark4648 = new Lino.RichTextPanel({ "selectOnFocus": true, "flex": 45, "containing_panel": this, "name": "remark", "title": "Bemerkung" });
    var main_panel4649 = new Ext.Panel({ "autoScroll": false, "border": false, "layout": "vbox", "labelWidth": 0, "hideCheckBoxLabels": true, "items": [ main_1_panel4623, main_2_panel4631, main_3_panel4637, main_4_panel4644, remark4648 ], "frame": true, "layoutConfig": { "align": "stretch" }, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel4649;
    this.before_row_edit = function(record) {
      contact_person4630.setContextValue('company', record ? record.data['companyHidden'] : undefined);
      remark4648.refresh();
    }
    this.onRender = function(ct, position) {
      company4629.on('change',Lino.chooser_handler(contact_person4630,'company'));
      Lino.aids.IncomeConfirmations.DetailFormPanel.superclass.onRender.call(this, ct, position);
    }
    Lino.aids.IncomeConfirmations.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.polls.Responses.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 125,
  initComponent : function() {
    var user4920 = new Lino.TwinCombo({ "preferred_width": 15, "autoHeight": true, "fieldLabel": "Autor", "name": "user", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.users.Users.detail,Lino.users.Users.insert)}, "hiddenName": "userHidden", "selectOnFocus": true, "emptyText": "Benutzer ausw\u00e4hlen...", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/polls/Responses/user", "method": "GET" }) }) });
    var poll4921 = new Lino.TwinCombo({ "autoHeight": true, "fieldLabel": "Poll", "allowBlank": false, "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.polls.Polls.detail,Lino.polls.Polls.insert)}, "emptyText": "Poll ausw\u00e4hlen...", "selectOnFocus": true, "hiddenName": "pollHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/polls/Responses/poll", "method": "GET" }) }), "name": "poll" });
    var state4922 = new Lino.ChoicesFieldElement({ "autoHeight": true, "forceSelection": true, "fieldLabel": "Zustand", "allowBlank": false, "hiddenName": "stateHidden", "selectOnFocus": true, "anchor": "-20", "store": Lino.polls.ResponseStates, "name": "state" });
    var created4923 = new Ext.form.DisplayField({ "disabled": true, "autoHeight": true, "fieldLabel": "Erstellt", "name": "created", "anchor": "-20", "value": "<br>" });
    var modified4924 = new Ext.form.DisplayField({ "disabled": true, "autoHeight": true, "fieldLabel": "Bearbeitet", "name": "modified", "anchor": "-20", "value": "<br>" });
    var main_1_panel4925 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 23, "autoHeight": true, "layout": "form", "xtype": "panel", "items": user4920, "labelAlign": "top" }, { "flex": 23, "autoHeight": true, "layout": "form", "xtype": "panel", "items": poll4921, "labelAlign": "top" }, { "flex": 15, "autoHeight": true, "layout": "form", "xtype": "panel", "items": state4922, "labelAlign": "top" }, { "flex": 18, "autoHeight": true, "layout": "form", "xtype": "panel", "items": created4923, "labelAlign": "top" }, { "flex": 18, "autoHeight": true, "layout": "form", "xtype": "panel", "items": modified4924, "labelAlign": "top" } ], "region": "north", "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "split": true, "autoScroll": false, "labelWidth": 99, "border": false, "frame": false, "labelAlign": "top" });
    var polls_AnswersByResponse_grid4936 = new Lino.polls.AnswersByResponse.GridPanel({ "flex": 5, "hide_top_toolbar": true, "containing_panel": this, "region": "center", "preview_limit": 15, "master_panel": this, "split": true, "tools": [ Lino.show_in_own_window_button(Lino.polls.AnswersByResponse.grid) ] });
    var remark4937 = new Ext.form.TextArea({ "selectOnFocus": true, "fieldLabel": "My general remark", "anchor": "-20 -10", "growMax": 2000, "name": "remark" });
    var main_panel4938 = new Lino.VBorderPanel({ "autoScroll": false, "border": false, "labelWidth": 162, "hideCheckBoxLabels": true, "items": [ main_1_panel4925, polls_AnswersByResponse_grid4936, { "flex": 5, "layout": "form", "xtype": "panel", "items": remark4937, "region": "south", "labelAlign": "top", "split": true } ], "frame": true, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel4938;
    this.before_row_edit = function(record) {
      polls_AnswersByResponse_grid4936.on_master_changed();
    }
    Lino.polls.Responses.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.contacts.Companies.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 17,
  initComponent : function() {
    var overview_disp1815 = new Ext.form.DisplayField({ "disabled": true, "flex": 28, "name": "overview", "value": "<br/>", "always_enabled": true });
    var prefix1816 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Name prefix", "name": "prefix", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var name1817 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Name", "name": "name", "maxLength": 200, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var general2_1_panel1818 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": prefix1816, "labelAlign": "top" }, { "flex": 66, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name1817, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 108, "border": false, "anchor": "-20", "labelAlign": "top" });
    var type1821 = new Lino.RemoteComboFieldElement({ "autoHeight": true, "fieldLabel": "Organisationsart", "name": "type", "pageSize": 20, "emptyText": "Organisationsart ausw\u00e4hlen...", "selectOnFocus": true, "hiddenName": "typeHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/contacts/Companies/type", "method": "GET" }) }) });
    var vat_id1822 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "MWSt.-Nr.", "name": "vat_id", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var general2_2_panel1823 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 48, "autoHeight": true, "layout": "form", "xtype": "panel", "items": type1821, "labelAlign": "top" }, { "flex": 51, "autoHeight": true, "layout": "form", "xtype": "panel", "items": vat_id1822, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 153, "border": false, "anchor": "-20", "labelAlign": "top" });
    var client_contact_type1826 = new Lino.TwinCombo({ "autoHeight": true, "fieldLabel": "Klientenkontaktart", "name": "client_contact_type", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.pcsw.ClientContactTypes.detail,Lino.pcsw.ClientContactTypes.insert)}, "emptyText": "Klientenkontaktart ausw\u00e4hlen...", "selectOnFocus": true, "hiddenName": "client_contact_typeHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/contacts/Companies/client_contact_type", "method": "GET" }) }) });
    var url1827 = new Lino.URLField({ "autoHeight": true, "fieldLabel": "URL", "name": "url", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var general2_panel1828 = new Ext.Panel({ "flex": 42, "autoHeight": true, "layout": "form", "items": [ general2_1_panel1818, general2_2_panel1823, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": client_contact_type1826, "anchor": "-20", "labelAlign": "top" }, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": url1827, "anchor": "-20", "labelAlign": "top" } ], "frame": true, "bodyBorder": false, "autoScroll": false, "hideCheckBoxLabels": true, "labelWidth": 171, "border": false, "labelAlign": "top" });
    var email1831 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "E-Mail", "name": "email", "maxLength": 75, "selectOnFocus": true, "anchor": "-20" });
    var phone1832 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Telefon", "name": "phone", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var gsm1833 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "GSM", "name": "gsm", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var fax1834 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Fax", "name": "fax", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var general3_panel1835 = new Ext.Panel({ "flex": 28, "autoHeight": true, "layout": "form", "items": [ { "autoHeight": true, "layout": "form", "xtype": "panel", "items": email1831, "anchor": "-20", "labelAlign": "top" }, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": phone1832, "anchor": "-20", "labelAlign": "top" }, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": gsm1833, "anchor": "-20", "labelAlign": "top" }, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": fax1834, "anchor": "-20", "labelAlign": "top" } ], "frame": true, "bodyBorder": false, "autoScroll": false, "hideCheckBoxLabels": true, "labelWidth": 72, "border": false, "labelAlign": "top" });
    var general_1_panel1840 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 0, "hideCheckBoxLabels": true, "items": [ overview_disp1815, general2_panel1828, general3_panel1835 ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var contacts_RolesByCompany_grid1845 = new Lino.contacts.RolesByCompany.GridPanel({ "flex": 55, "hide_top_toolbar": true, "containing_panel": this, "tools": [ Lino.show_in_own_window_button(Lino.contacts.RolesByCompany.grid) ], "preview_limit": 15, "master_panel": this });
    var general_panel1846 = new Ext.Panel({ "layout": "vbox", "title": "Allgemein", "items": [ general_1_panel1840, contacts_RolesByCompany_grid1845 ], "frame": true, "layoutConfig": { "align": "stretch" }, "hideCheckBoxLabels": true, "listeners": { "activate": Lino.on_tab_activate }, "autoScroll": false, "border": false, "bodyBorder": false, "labelAlign": "top" });
    var addresses_AddressesByPartner_grid1852 = new Lino.addresses.AddressesByPartner.GridPanel({ "flex": 5, "hide_top_toolbar": true, "containing_panel": this, "region": "north", "preview_limit": 15, "master_panel": this, "split": true, "tools": [ Lino.show_in_own_window_button(Lino.addresses.AddressesByPartner.grid) ] });
    var remarks1853 = new Ext.form.TextArea({ "selectOnFocus": true, "fieldLabel": "Bemerkungen", "anchor": "-20 -10", "growMax": 2000, "name": "remarks" });
    var sepa_AccountsByPartner_grid1854 = new Lino.sepa.AccountsByPartner.GridPanel({ "flex": 64, "hide_top_toolbar": true, "containing_panel": this, "tools": [ Lino.show_in_own_window_button(Lino.sepa.AccountsByPartner.grid) ], "preview_limit": 15, "master_panel": this });
    var contact_2_panel1855 = new Ext.Panel({ "flex": 5, "layout": "hbox", "items": [ { "items": remarks1853, "labelAlign": "top", "layout": "form", "xtype": "panel", "flex": 35 }, sepa_AccountsByPartner_grid1854 ], "region": "center", "layoutConfig": { "align": "stretch" }, "hideCheckBoxLabels": true, "split": true, "autoScroll": false, "labelWidth": 108, "border": false, "frame": false, "labelAlign": "top" });
    var contact_panel1857 = new Lino.VBorderPanel({ "autoScroll": false, "listeners": { "activate": Lino.on_tab_activate }, "border": false, "title": "Kontakt", "hideCheckBoxLabels": true, "items": [ addresses_AddressesByPartner_grid1852, contact_2_panel1855 ], "frame": true, "bodyBorder": false, "labelAlign": "top" });
    var notes_NotesByCompany_grid1875 = new Lino.notes.NotesByCompany.GridPanel({ "listeners": { "activate": Lino.on_tab_activate }, "hide_top_toolbar": true, "containing_panel": this, "title": "Ereignisse/Notizen", "tools": [ Lino.show_in_own_window_button(Lino.notes.NotesByCompany.grid) ], "preview_limit": 15, "master_panel": this });
    var id1876 = new Ext.form.NumberField({ "selectOnFocus": true, "autoHeight": true, "fieldLabel": "ID", "anchor": "-20", "name": "id" });
    var language1877 = new Lino.ChoicesFieldElement({ "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Sprache</span>", "allowBlank": false, "hiddenName": "languageHidden", "listeners": { "render": Lino.quicktip_renderer("Sprache","Die Sprache, in der Dokumente ausgestellt werden sollen.") }, "selectOnFocus": true, "anchor": "-20", "store": [ [ "en", "Englisch" ], [ "fr", "Franz\u00f6sisch" ], [ "de", "Deutsch" ], [ "nl", "Niederl\u00e4ndisch" ] ], "name": "language" });
    var activity1878 = new Lino.RemoteComboFieldElement({ "autoHeight": true, "fieldLabel": "Beruf", "name": "activity", "pageSize": 20, "emptyText": "Beruf ausw\u00e4hlen...", "selectOnFocus": true, "hiddenName": "activityHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/contacts/Companies/activity", "method": "GET" }) }) });
    var misc_1_panel1879 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 72, "hideCheckBoxLabels": true, "items": [ { "flex": 11, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id1876, "labelAlign": "top" }, { "flex": 44, "autoHeight": true, "layout": "form", "xtype": "panel", "items": language1877, "labelAlign": "top" }, { "flex": 44, "autoHeight": true, "layout": "form", "xtype": "panel", "items": activity1878, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var is_courseprovider1883 = new Ext.form.Checkbox({ "boxLabel": "ist Kursanbieter (<a href=\"javascript:Lino.show_mti_child('is_courseprovider',Lino.courses.CourseProviders.detail)\">zeigen</a>)", "autoHeight": true, "hideLabel": true, "name": "is_courseprovider", "selectOnFocus": true, "anchor": "-20" });
    var is_jobprovider1884 = new Ext.form.Checkbox({ "boxLabel": "Stellenanbieter (<a href=\"javascript:Lino.show_mti_child('is_jobprovider',Lino.jobs.JobProviders.detail)\">zeigen</a>)", "autoHeight": true, "hideLabel": true, "name": "is_jobprovider", "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Stellenanbieter","Whether this Company is also a Job Provider.") }, "anchor": "-20" });
    var is_obsolete1885 = new Ext.form.Checkbox({ "autoHeight": true, "hideLabel": true, "checked": false, "name": "is_obsolete", "listeners": { "render": Lino.quicktip_renderer("veraltet","Altf\u00e4lle sind Partner, deren Stammdaten nicht mehr gepflegt werden und \nf\u00fcr neue Operationen nicht benutzt werden k\u00f6nnen.") }, "boxLabel": "veraltet", "selectOnFocus": true, "anchor": "-20" });
    var misc_2_panel1886 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 153, "hideCheckBoxLabels": true, "items": [ { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": is_courseprovider1883, "labelAlign": "top" }, { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": is_jobprovider1884, "labelAlign": "top" }, { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": is_obsolete1885, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var created1890 = new Ext.form.DisplayField({ "disabled": true, "autoHeight": true, "fieldLabel": "Erstellt", "name": "created", "anchor": "-20", "value": "<br>" });
    var modified1891 = new Ext.form.DisplayField({ "disabled": true, "autoHeight": true, "fieldLabel": "Bearbeitet", "name": "modified", "anchor": "-20", "value": "<br>" });
    var misc_3_panel1892 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 99, "hideCheckBoxLabels": true, "items": [ { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": created1890, "labelAlign": "top" }, { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": modified1891, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var reception_AppointmentsByPartner_grid1895 = new Lino.reception.AppointmentsByPartner.GridPanel({ "flex": 62, "hide_top_toolbar": true, "containing_panel": this, "tools": [ Lino.show_in_own_window_button(Lino.reception.AppointmentsByPartner.grid) ], "preview_limit": 15, "master_panel": this });
    var misc_panel1896 = new Ext.Panel({ "layout": "vbox", "title": "Sonstiges", "items": [ misc_1_panel1879, misc_2_panel1886, misc_3_panel1892, reception_AppointmentsByPartner_grid1895 ], "frame": true, "layoutConfig": { "align": "stretch" }, "hideCheckBoxLabels": true, "listeners": { "activate": Lino.on_tab_activate }, "autoScroll": false, "border": false, "bodyBorder": false, "labelAlign": "top" });
    var main_panel1897 = new Ext.TabPanel({ "hideCheckBoxLabels": true, "border": false, "split": true, "autoScroll": false, "items": [ general_panel1846, contact_panel1857, notes_NotesByCompany_grid1875, misc_panel1896 ], "activeTab": 0, "bodyBorder": false, "frame": true, "labelAlign": "top" });
    this.items = main_panel1897;
    this.before_row_edit = function(record) {
      contacts_RolesByCompany_grid1845.on_master_changed();
      addresses_AddressesByPartner_grid1852.on_master_changed();
      sepa_AccountsByPartner_grid1854.on_master_changed();
      notes_NotesByCompany_grid1875.on_master_changed();
      reception_AppointmentsByPartner_grid1895.on_master_changed();
    }
    Lino.contacts.Companies.DetailFormPanel.superclass.initComponent.call(this);
    // active_fields:
  }
});


Lino.contacts.Partners.InsertFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  autoHeight: true,
  content_type: 20,
  initComponent : function() {
    var name1543 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Name", "name": "name", "maxLength": 200, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var language1544 = new Lino.ChoicesFieldElement({ "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Sprache</span>", "allowBlank": false, "hiddenName": "languageHidden", "listeners": { "render": Lino.quicktip_renderer("Sprache","Die Sprache, in der Dokumente ausgestellt werden sollen.") }, "selectOnFocus": true, "anchor": "-20", "store": [ [ "en", "Englisch" ], [ "fr", "Franz\u00f6sisch" ], [ "de", "Deutsch" ], [ "nl", "Niederl\u00e4ndisch" ] ], "name": "language" });
    var email1545 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "E-Mail", "name": "email", "maxLength": 75, "selectOnFocus": true, "anchor": "-20" });
    var main_2_panel1546 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 48, "autoHeight": true, "layout": "form", "xtype": "panel", "items": language1544, "labelAlign": "top" }, { "flex": 51, "autoHeight": true, "layout": "form", "xtype": "panel", "items": email1545, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 72, "border": false, "anchor": "-20", "labelAlign": "top" });
    var main_panel1549 = new Ext.Panel({ "hideCheckBoxLabels": true, "autoHeight": true, "border": false, "layout": "form", "labelWidth": 45, "autoScroll": false, "items": [ { "autoHeight": true, "layout": "form", "xtype": "panel", "items": name1543, "anchor": "-20", "labelAlign": "top" }, main_2_panel1546 ], "frame": true, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel1549;
    this.before_row_edit = function(record) {
    }
    Lino.contacts.Partners.InsertFormPanel.superclass.initComponent.call(this);
  }
});


Lino.properties.Properties.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 11,
  initComponent : function() {
    var id625 = new Ext.form.NumberField({ "selectOnFocus": true, "autoHeight": true, "fieldLabel": "ID", "anchor": "-20", "name": "id" });
    var group626 = new Lino.TwinCombo({ "autoHeight": true, "fieldLabel": "Eigenschaftsgruppe", "allowBlank": false, "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.properties.PropGroups.detail,Lino.properties.PropGroups.insert)}, "emptyText": "Eigenschaftsgruppe ausw\u00e4hlen...", "selectOnFocus": true, "hiddenName": "groupHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/properties/Properties/group", "method": "GET" }) }), "name": "group" });
    var type627 = new Lino.TwinCombo({ "autoHeight": true, "fieldLabel": "Eigenschafts-Datentyp", "allowBlank": false, "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.properties.PropTypes.detail,Lino.properties.PropTypes.insert)}, "emptyText": "Eigenschafts-Datentyp ausw\u00e4hlen...", "selectOnFocus": true, "hiddenName": "typeHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/properties/Properties/type", "method": "GET" }) }), "name": "type" });
    var main_1_panel628 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 198, "hideCheckBoxLabels": true, "items": [ { "flex": 11, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id625, "labelAlign": "top" }, { "flex": 44, "autoHeight": true, "layout": "form", "xtype": "panel", "items": group626, "labelAlign": "top" }, { "flex": 44, "autoHeight": true, "layout": "form", "xtype": "panel", "items": type627, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var name632 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Bezeichnung", "name": "name", "maxLength": 200, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var name_fr633 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Bezeichnung (fr)", "name": "name_fr", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var name_de634 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Bezeichnung (de)", "name": "name_de", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var name_nl635 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Bezeichnung (nl)", "name": "name_nl", "maxLength": 200, "selectOnFocus": true, "hidden": true, "anchor": "-20" });
    var main_2_panel636 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 153, "hideCheckBoxLabels": true, "items": [ { "flex": 25, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name632, "labelAlign": "top" }, { "flex": 25, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_fr633, "labelAlign": "top" }, { "flex": 25, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_de634, "labelAlign": "top" }, { "flex": 25, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_nl635, "hidden": true, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var cv_PersonPropsByProp_grid647 = new Lino.cv.PersonPropsByProp.GridPanel({ "flex": 71, "hide_top_toolbar": true, "containing_panel": this, "tools": [ Lino.show_in_own_window_button(Lino.cv.PersonPropsByProp.grid) ], "preview_limit": 15, "master_panel": this });
    var main_panel648 = new Ext.Panel({ "autoScroll": false, "border": false, "layout": "vbox", "hideCheckBoxLabels": true, "items": [ main_1_panel628, main_2_panel636, cv_PersonPropsByProp_grid647 ], "frame": true, "layoutConfig": { "align": "stretch" }, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel648;
    this.before_row_edit = function(record) {
      cv_PersonPropsByProp_grid647.on_master_changed();
    }
    Lino.properties.Properties.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.outbox.Mails.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 25,
  initComponent : function() {
    var subject493 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Betreff", "name": "subject", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var project494 = new Lino.TwinCombo({ "preferred_width": 20, "autoHeight": true, "fieldLabel": "Klient", "name": "project", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.pcsw.Clients.detail,Lino.pcsw.Clients.insert)}, "hiddenName": "projectHidden", "selectOnFocus": true, "emptyText": "Klient ausw\u00e4hlen...", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/outbox/Mails/project", "method": "GET" }) }) });
    var date495 = new Lino.DateField({ "autoHeight": true, "allowBlank": false, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Datum</span>", "name": "date", "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Datum","\n        The official date to be printed on the document.\n        ") }, "anchor": "-20" });
    var main_1_panel496 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 72, "hideCheckBoxLabels": true, "items": [ { "flex": 38, "autoHeight": true, "layout": "form", "xtype": "panel", "items": subject493, "labelAlign": "top" }, { "flex": 37, "autoHeight": true, "layout": "form", "xtype": "panel", "items": project494, "labelAlign": "top" }, { "flex": 24, "autoHeight": true, "layout": "form", "xtype": "panel", "items": date495, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var user500 = new Lino.TwinCombo({ "preferred_width": 15, "autoHeight": true, "fieldLabel": "Absender", "name": "user", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.users.Users.detail,Lino.users.Users.insert)}, "hiddenName": "userHidden", "selectOnFocus": true, "emptyText": "Benutzer ausw\u00e4hlen...", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/outbox/Mails/user", "method": "GET" }) }) });
    var sent501 = new Ext.form.DisplayField({ "disabled": true, "autoHeight": true, "fieldLabel": "sent", "name": "sent", "anchor": "-20", "value": "<br>" });
    var id502 = new Ext.form.NumberField({ "selectOnFocus": true, "autoHeight": true, "fieldLabel": "ID", "anchor": "-20", "name": "id" });
    var owner_disp503 = new Ext.form.DisplayField({ "disabled": true, "autoHeight": true, "fieldLabel": "Verkn\u00fcpft mit", "anchor": "-20", "name": "owner" });
    var main_2_panel504 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 126, "hideCheckBoxLabels": true, "items": [ { "flex": 39, "autoHeight": true, "layout": "form", "xtype": "panel", "items": user500, "labelAlign": "top" }, { "flex": 31, "autoHeight": true, "layout": "form", "xtype": "panel", "items": sent501, "labelAlign": "top" }, { "flex": 9, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id502, "labelAlign": "top" }, { "flex": 19, "autoHeight": true, "layout": "form", "xtype": "panel", "items": owner_disp503, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var RecipientsByMail_grid515 = new Lino.outbox.RecipientsByMail.GridPanel({ "flex": 55, "hide_top_toolbar": true, "containing_panel": this, "tools": [ Lino.show_in_own_window_button(Lino.outbox.RecipientsByMail.grid) ], "preview_limit": 15, "master_panel": this });
    var AttachmentsByMail_htmlbox516 = new Lino.HtmlBoxPanel({ "flex": 22, "layout": "fit", "name": "AttachmentsByMail", "containing_panel": this, "items": new Ext.BoxComponent({autoScroll:true}), "title": "Anh\u00e4nge", "master_panel": this, "value": "<br/>", "always_enabled": true, "bodyStyle": "overflow-x:hidden;", "tools": [ Lino.show_in_own_window_button(Lino.outbox.AttachmentsByMail.grid) ] });
    var UploadsByController_htmlbox517 = new Lino.HtmlBoxPanel({ "flex": 22, "layout": "fit", "name": "UploadsByController", "containing_panel": this, "items": new Ext.BoxComponent({autoScroll:true}), "title": "Uploads", "master_panel": this, "value": "<br/>", "always_enabled": true, "bodyStyle": "overflow-x:hidden;", "tools": [ Lino.show_in_own_window_button(Lino.uploads.UploadsByController.grid) ] });
    var main_3_panel518 = new Ext.Panel({ "flex": 29, "border": false, "layout": "hbox", "labelWidth": 72, "hideCheckBoxLabels": true, "items": [ RecipientsByMail_grid515, AttachmentsByMail_htmlbox516, UploadsByController_htmlbox517 ], "autoScroll": false, "layoutConfig": { "align": "stretch" }, "frame": false, "labelAlign": "top" });
    var body519 = new Lino.RichTextPanel({ "selectOnFocus": true, "flex": 58, "containing_panel": this, "name": "body", "title": "Inhalt" });
    var main_panel520 = new Ext.Panel({ "autoScroll": false, "border": false, "layout": "vbox", "labelWidth": 0, "hideCheckBoxLabels": true, "items": [ main_1_panel496, main_2_panel504, main_3_panel518, body519 ], "frame": true, "layoutConfig": { "align": "stretch" }, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel520;
    this.before_row_edit = function(record) {
      RecipientsByMail_grid515.on_master_changed();
      AttachmentsByMail_htmlbox516.refresh();
      UploadsByController_htmlbox517.refresh();
      body519.refresh();
    }
    Lino.outbox.Mails.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.aids.Categories.InsertFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  autoHeight: true,
  content_type: 112,
  initComponent : function() {
    var id4652 = new Ext.form.NumberField({ "selectOnFocus": true, "autoHeight": true, "fieldLabel": "ID", "anchor": "-20", "name": "id" });
    var name4653 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Bezeichnung", "name": "name", "maxLength": 200, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var name_fr4654 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Bezeichnung (fr)", "name": "name_fr", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var name_de4655 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Bezeichnung (de)", "name": "name_de", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var name_nl4656 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Bezeichnung (nl)", "name": "name_nl", "maxLength": 200, "selectOnFocus": true, "hidden": true, "anchor": "-20" });
    var main_1_panel4657 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 153, "hideCheckBoxLabels": true, "items": [ { "flex": 5, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id4652, "labelAlign": "top" }, { "flex": 23, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name4653, "labelAlign": "top" }, { "flex": 23, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_fr4654, "labelAlign": "top" }, { "flex": 23, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_de4655, "labelAlign": "top" }, { "flex": 23, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_nl4656, "hidden": true, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var main_panel4663 = new Ext.Panel({ "autoScroll": false, "border": false, "layout": "fit", "hideCheckBoxLabels": true, "items": [ main_1_panel4657 ], "frame": true, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel4663;
    this.before_row_edit = function(record) {
    }
    Lino.aids.Categories.InsertFormPanel.superclass.initComponent.call(this);
  }
});


Lino.uploads.Uploads.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 24,
  initComponent : function() {
    var user2018 = new Lino.TwinCombo({ "preferred_width": 15, "autoHeight": true, "fieldLabel": "Autor", "name": "user", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.users.Users.detail,Lino.users.Users.insert)}, "hiddenName": "userHidden", "selectOnFocus": true, "emptyText": "Benutzer ausw\u00e4hlen...", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/uploads/Uploads/user", "method": "GET" }) }) });
    var project2019 = new Lino.TwinCombo({ "preferred_width": 20, "autoHeight": true, "fieldLabel": "Klient", "name": "project", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.pcsw.Clients.detail,Lino.pcsw.Clients.insert)}, "hiddenName": "projectHidden", "selectOnFocus": true, "emptyText": "Klient ausw\u00e4hlen...", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/uploads/Uploads/project", "method": "GET" }) }) });
    var id2020 = new Ext.form.NumberField({ "selectOnFocus": true, "autoHeight": true, "fieldLabel": "ID", "anchor": "-20", "name": "id" });
    var main_1_panel2021 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 63, "hideCheckBoxLabels": true, "items": [ { "flex": 44, "autoHeight": true, "layout": "form", "xtype": "panel", "items": user2018, "labelAlign": "top" }, { "flex": 44, "autoHeight": true, "layout": "form", "xtype": "panel", "items": project2019, "labelAlign": "top" }, { "flex": 11, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id2020, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var type2025 = new Lino.TwinCombo({ "autoHeight": true, "fieldLabel": "Upload-Art", "name": "type", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.uploads.UploadTypes.detail,Lino.uploads.UploadTypes.insert)}, "emptyText": "Upload-Art ausw\u00e4hlen...", "selectOnFocus": true, "hiddenName": "typeHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/uploads/Uploads/type", "method": "GET" }) }) });
    var description2026 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Beschreibung", "name": "description", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var valid_from2027 = new Lino.DateField({ "selectOnFocus": true, "autoHeight": true, "fieldLabel": "G\u00fcltig von", "anchor": "-20", "name": "valid_from" });
    var valid_until2028 = new Lino.DateField({ "selectOnFocus": true, "autoHeight": true, "fieldLabel": "G\u00fcltig bis", "anchor": "-20", "name": "valid_until" });
    var main_2_panel2029 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 117, "hideCheckBoxLabels": true, "items": [ { "flex": 29, "autoHeight": true, "layout": "form", "xtype": "panel", "items": type2025, "labelAlign": "top" }, { "flex": 31, "autoHeight": true, "layout": "form", "xtype": "panel", "items": description2026, "labelAlign": "top" }, { "flex": 19, "autoHeight": true, "layout": "form", "xtype": "panel", "items": valid_from2027, "labelAlign": "top" }, { "flex": 19, "autoHeight": true, "layout": "form", "xtype": "panel", "items": valid_until2028, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var company2034 = new Lino.TwinCombo({ "preferred_width": 20, "autoHeight": true, "fieldLabel": "Issued by (Organization)", "name": "company", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.contacts.Companies.detail,Lino.contacts.Companies.insert)}, "hiddenName": "companyHidden", "selectOnFocus": true, "emptyText": "Organisation ausw\u00e4hlen...", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/uploads/Uploads/company", "method": "GET" }) }) });
    var contact_person2035 = new Lino.TwinCombo({ "preferred_width": 20, "autoHeight": true, "fieldLabel": "Issued by (Person)", "name": "contact_person", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.contacts.Persons.detail,Lino.contacts.Persons.insert)}, "hiddenName": "contact_personHidden", "selectOnFocus": true, "emptyText": "Person ausw\u00e4hlen...", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/uploads/Uploads/contact_person", "method": "GET" }) }) });
    var contact_role2036 = new Lino.RemoteComboFieldElement({ "autoHeight": true, "fieldLabel": "in seiner Eigenschaft als", "name": "contact_role", "pageSize": 20, "emptyText": "Funktion ausw\u00e4hlen...", "selectOnFocus": true, "hiddenName": "contact_roleHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/uploads/Uploads/contact_role", "method": "GET" }) }) });
    var main_3_panel2037 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 234, "hideCheckBoxLabels": true, "items": [ { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": company2034, "labelAlign": "top" }, { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": contact_person2035, "labelAlign": "top" }, { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": contact_role2036, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var file2041 = Lino.file_field_handler(this,{ "autoHeight": true, "fieldLabel": "File", "name": "file", "maxLength": 100, "selectOnFocus": true, "anchor": "-20" });
    var owner_disp2042 = new Ext.form.DisplayField({ "disabled": true, "autoHeight": true, "fieldLabel": "Verkn\u00fcpft mit", "anchor": "-20", "name": "owner" });
    var main_4_panel2043 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 126, "hideCheckBoxLabels": true, "items": [ { "flex": 67, "autoHeight": true, "layout": "form", "xtype": "panel", "items": file2041, "labelAlign": "top" }, { "flex": 32, "autoHeight": true, "layout": "form", "xtype": "panel", "items": owner_disp2042, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var remark2046 = new Ext.form.TextArea({ "selectOnFocus": true, "fieldLabel": "Bemerkung", "anchor": "-20 -10", "growMax": 2000, "name": "remark" });
    var cal_TasksByController_grid2047 = new Lino.cal.TasksByController.GridPanel({ "flex": 65, "hide_top_toolbar": true, "containing_panel": this, "params_panel_hidden": true, "tools": [ Lino.show_in_own_window_button(Lino.cal.TasksByController.grid) ], "master_panel": this, "preview_limit": 15 });
    var main_5_panel2048 = new Ext.Panel({ "flex": 55, "border": false, "layout": "hbox", "labelWidth": 90, "hideCheckBoxLabels": true, "items": [ { "items": remark2046, "labelAlign": "top", "layout": "form", "xtype": "panel", "flex": 34 }, cal_TasksByController_grid2047 ], "autoScroll": false, "layoutConfig": { "align": "stretch" }, "frame": false, "labelAlign": "top" });
    var main_panel2050 = new Ext.Panel({ "autoScroll": false, "border": false, "layout": "vbox", "hideCheckBoxLabels": true, "items": [ main_1_panel2021, main_2_panel2029, main_3_panel2037, main_4_panel2043, main_5_panel2048 ], "frame": true, "layoutConfig": { "align": "stretch" }, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel2050;
    this.before_row_edit = function(record) {
      type2025.setContextValue('upload_area', record ? record.data['upload_areaHidden'] : undefined);
      contact_person2035.setContextValue('company', record ? record.data['companyHidden'] : undefined);
      cal_TasksByController_grid2047.on_master_changed();
    }
    this.onRender = function(ct, position) {
      company2034.on('change',Lino.chooser_handler(contact_person2035,'company'));
      Lino.uploads.Uploads.DetailFormPanel.superclass.onRender.call(this, ct, position);
    }
    Lino.uploads.Uploads.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.addresses.Addresses.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  autoHeight: true,
  content_type: 22,
  initComponent : function() {
    var country1665 = new Lino.TwinCombo({ "autoHeight": true, "fieldLabel": "Land", "name": "country", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.countries.Countries.detail,Lino.countries.Countries.insert)}, "emptyText": "Land ausw\u00e4hlen...", "selectOnFocus": true, "hiddenName": "countryHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/addresses/Addresses/country", "method": "GET" }) }) });
    var city1666 = new Lino.TwinCombo({ "autoHeight": true, "forceSelection": false, "fieldLabel": "Stadt", "name": "city", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.countries.Places.detail,Lino.countries.Places.insert)}, "emptyText": "Ort ausw\u00e4hlen...", "selectOnFocus": true, "hiddenName": "cityHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/addresses/Addresses/city", "method": "GET" }) }) });
    var zip_code1667 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Postleitzahl", "name": "zip_code", "maxLength": 10, "selectOnFocus": true, "boxMinWidth": Lino.chars2width(10), "anchor": "-20" });
    var main_1_panel1668 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 39, "autoHeight": true, "layout": "form", "xtype": "panel", "items": country1665, "labelAlign": "top" }, { "flex": 39, "autoHeight": true, "layout": "form", "xtype": "panel", "items": city1666, "labelAlign": "top" }, { "flex": 21, "autoHeight": true, "layout": "form", "xtype": "panel", "items": zip_code1667, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 117, "border": false, "anchor": "-20", "labelAlign": "top" });
    var addr11672 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Adresszeile vor Stra\u00dfe</span>", "name": "addr1", "maxLength": 200, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Adresszeile vor Stra\u00dfe","Adresszeile vor Stra\u00dfe") }, "anchor": "-20" });
    var street1673 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Stra\u00dfe</span>", "name": "street", "maxLength": 200, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Stra\u00dfe","Name der Stra\u00dfe, ohne Hausnummer") }, "anchor": "-20" });
    var street_no1674 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Nr.</span>", "name": "street_no", "boxMinWidth": Lino.chars2width(10), "listeners": { "render": Lino.quicktip_renderer("Nr.","Hausnummer") }, "maxLength": 10, "selectOnFocus": true, "anchor": "-20" });
    var street_box1675 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Box</span>", "name": "street_box", "boxMinWidth": Lino.chars2width(10), "listeners": { "render": Lino.quicktip_renderer("Box","Text to print after street nuber on the same line.") }, "maxLength": 10, "selectOnFocus": true, "anchor": "-20" });
    var main_3_panel1676 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 48, "autoHeight": true, "layout": "form", "xtype": "panel", "items": street1673, "labelAlign": "top" }, { "flex": 25, "autoHeight": true, "layout": "form", "xtype": "panel", "items": street_no1674, "labelAlign": "top" }, { "flex": 25, "autoHeight": true, "layout": "form", "xtype": "panel", "items": street_box1675, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 63, "border": false, "anchor": "-20", "labelAlign": "top" });
    var addr21680 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Adresszeile nach Stra\u00dfe</span>", "name": "addr2", "maxLength": 200, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Adresszeile nach Stra\u00dfe","Adresszeile nach Stra\u00dfe") }, "anchor": "-20" });
    var address_type1681 = new Lino.ChoicesFieldElement({ "autoHeight": true, "forceSelection": true, "fieldLabel": "Adressenart", "name": "address_type", "hiddenName": "address_typeHidden", "selectOnFocus": true, "anchor": "-20", "store": [['','<br>']].concat(Lino.addresses.AddressTypes) });
    var remark1682 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Bemerkung", "name": "remark", "maxLength": 50, "selectOnFocus": true, "anchor": "-20" });
    var main_5_panel1683 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": address_type1681, "labelAlign": "top" }, { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": remark1682, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 108, "border": false, "anchor": "-20", "labelAlign": "top" });
    var data_source1686 = new Lino.ChoicesFieldElement({ "autoHeight": true, "forceSelection": true, "fieldLabel": "Datenquelle", "name": "data_source", "hiddenName": "data_sourceHidden", "disabled": true, "anchor": "-20", "store": Lino.addresses.DataSources });
    var partner1687 = new Lino.TwinCombo({ "preferred_width": 20, "autoHeight": true, "fieldLabel": "Partner", "allowBlank": false, "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.contacts.Partners.detail,Lino.contacts.Partners.insert)}, "emptyText": "Partner ausw\u00e4hlen...", "selectOnFocus": true, "hiddenName": "partnerHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/addresses/Addresses/partner", "method": "GET" }) }), "name": "partner" });
    var main_6_panel1688 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 48, "autoHeight": true, "layout": "form", "xtype": "panel", "items": data_source1686, "labelAlign": "top" }, { "flex": 51, "autoHeight": true, "layout": "form", "xtype": "panel", "items": partner1687, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 108, "border": false, "anchor": "-20", "labelAlign": "top" });
    var main_panel1691 = new Ext.Panel({ "hideCheckBoxLabels": true, "autoHeight": true, "border": false, "layout": "form", "labelWidth": 216, "autoScroll": false, "items": [ main_1_panel1668, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": addr11672, "anchor": "-20", "labelAlign": "top" }, main_3_panel1676, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": addr21680, "anchor": "-20", "labelAlign": "top" }, main_5_panel1683, main_6_panel1688 ], "frame": true, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel1691;
    this.before_row_edit = function(record) {
      city1666.setContextValue('country', record ? record.data['countryHidden'] : undefined);
      city1666.setContextValue('region', record ? record.data['regionHidden'] : undefined);
    }
    this.onRender = function(ct, position) {
      country1665.on('change',Lino.chooser_handler(city1666,'country'));
      Lino.addresses.Addresses.DetailFormPanel.superclass.onRender.call(this, ct, position);
    }
    Lino.addresses.Addresses.DetailFormPanel.superclass.initComponent.call(this);
    // active_fields:
    city1666.on("change", function(){ this.save() }, this);
    zip_code1667.on("change", function(){ this.save() }, this);
  }
});


Lino.system.TextFieldTemplates.InsertFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  autoHeight: true,
  content_type: 3,
  initComponent : function() {
    var name660 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Bezeichnung", "name": "name", "maxLength": 200, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var user661 = new Lino.TwinCombo({ "preferred_width": 15, "autoHeight": true, "fieldLabel": "Autor", "name": "user", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.users.Users.detail,Lino.users.Users.insert)}, "hiddenName": "userHidden", "selectOnFocus": true, "emptyText": "Benutzer ausw\u00e4hlen...", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/system/TextFieldTemplates/user", "method": "GET" }) }) });
    var main_panel662 = new Ext.Panel({ "hideCheckBoxLabels": true, "autoHeight": true, "border": false, "layout": "form", "labelWidth": 108, "autoScroll": false, "items": [ { "autoHeight": true, "layout": "form", "xtype": "panel", "items": name660, "anchor": "-20", "labelAlign": "top" }, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": user661, "anchor": "-20", "labelAlign": "top" } ], "frame": true, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel662;
    this.before_row_edit = function(record) {
    }
    Lino.system.TextFieldTemplates.InsertFormPanel.superclass.initComponent.call(this);
  }
});


Lino.cal.Guests.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 33,
  initComponent : function() {
    var event1009 = new Lino.TwinCombo({ "autoHeight": true, "fieldLabel": "Termin", "allowBlank": false, "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.cal.OneEvent.detail,Lino.cal.OneEvent.insert)}, "emptyText": "Termin ausw\u00e4hlen...", "selectOnFocus": true, "hiddenName": "eventHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/Guests/event", "method": "GET" }) }), "name": "event" });
    var partner1010 = new Lino.TwinCombo({ "preferred_width": 20, "autoHeight": true, "fieldLabel": "Partner", "allowBlank": false, "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.contacts.Partners.detail,Lino.contacts.Partners.insert)}, "emptyText": "Partner ausw\u00e4hlen...", "selectOnFocus": true, "hiddenName": "partnerHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/Guests/partner", "method": "GET" }) }), "name": "partner" });
    var role1011 = new Lino.TwinCombo({ "autoHeight": true, "fieldLabel": "Rolle", "name": "role", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.cal.GuestRoles.detail,Lino.cal.GuestRoles.insert)}, "emptyText": "Gastrolle ausw\u00e4hlen...", "selectOnFocus": true, "hiddenName": "roleHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/Guests/role", "method": "GET" }) }) });
    var main_1_panel1012 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 72, "hideCheckBoxLabels": true, "items": [ { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": event1009, "labelAlign": "top" }, { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": partner1010, "labelAlign": "top" }, { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": role1011, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var state1016 = new Lino.ChoicesFieldElement({ "autoHeight": true, "forceSelection": true, "fieldLabel": "Zustand", "allowBlank": false, "hiddenName": "stateHidden", "selectOnFocus": true, "anchor": "-20", "store": Lino.cal.GuestStates, "name": "state" });
    var remark1017 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Bemerkung", "name": "remark", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var workflow_buttons_disp1018 = new Ext.form.DisplayField({ "disabled": true, "autoHeight": true, "fieldLabel": "Arbeitsablauf", "name": "workflow_buttons", "anchor": "-20", "value": "<br/>", "always_enabled": true });
    var main_2_panel1019 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 126, "hideCheckBoxLabels": true, "items": [ { "flex": 17, "autoHeight": true, "layout": "form", "xtype": "panel", "items": state1016, "labelAlign": "top" }, { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": remark1017, "labelAlign": "top" }, { "flex": 48, "autoHeight": true, "layout": "form", "xtype": "panel", "items": workflow_buttons_disp1018, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var waiting_since1023 = new Ext.form.DisplayField({ "disabled": true, "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Wartet seit</span>", "name": "waiting_since", "listeners": { "render": Lino.quicktip_renderer("Wartet seit","Time when the visitor arrived (checked in).") }, "value": "<br>", "anchor": "-20" });
    var busy_since1024 = new Ext.form.DisplayField({ "disabled": true, "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Hat gewartet bis</span>", "name": "busy_since", "listeners": { "render": Lino.quicktip_renderer("Hat gewartet bis","Time when the visitor was received by agent.") }, "value": "<br>", "anchor": "-20" });
    var gone_since1025 = new Ext.form.DisplayField({ "disabled": true, "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Anwesend bis</span>", "name": "gone_since", "listeners": { "render": Lino.quicktip_renderer("Anwesend bis","Time when the visitor left (checked out).") }, "value": "<br>", "anchor": "-20" });
    var main_3_panel1026 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 153, "hideCheckBoxLabels": true, "items": [ { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": waiting_since1023, "labelAlign": "top" }, { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": busy_since1024, "labelAlign": "top" }, { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": gone_since1025, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var outbox_MailsByController_grid1030 = new Lino.outbox.MailsByController.GridPanel({ "flex": 50, "hide_top_toolbar": true, "containing_panel": this, "tools": [ Lino.show_in_own_window_button(Lino.outbox.MailsByController.grid) ], "preview_limit": 15, "master_panel": this });
    var main_panel1031 = new Ext.Panel({ "autoScroll": false, "border": false, "layout": "vbox", "hideCheckBoxLabels": true, "items": [ main_1_panel1012, main_2_panel1019, main_3_panel1026, outbox_MailsByController_grid1030 ], "frame": true, "layoutConfig": { "align": "stretch" }, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel1031;
    this.before_row_edit = function(record) {
      outbox_MailsByController_grid1030.on_master_changed();
    }
    Lino.cal.Guests.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.polls.Polls.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 124,
  initComponent : function() {
    var title4888 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Anrede", "name": "title", "maxLength": 200, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var state4889 = new Lino.ChoicesFieldElement({ "autoHeight": true, "forceSelection": true, "fieldLabel": "Zustand", "allowBlank": false, "hiddenName": "stateHidden", "selectOnFocus": true, "anchor": "-20", "store": Lino.polls.PollStates, "name": "state" });
    var general_1_panel4890 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 72, "hideCheckBoxLabels": true, "items": [ { "flex": 63, "autoHeight": true, "layout": "form", "xtype": "panel", "items": title4888, "labelAlign": "top" }, { "flex": 36, "autoHeight": true, "layout": "form", "xtype": "panel", "items": state4889, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var details4893 = new Ext.form.TextArea({ "selectOnFocus": true, "fieldLabel": "Details", "anchor": "-20 -10", "growMax": 2000, "name": "details" });
    var user4894 = new Lino.TwinCombo({ "preferred_width": 15, "autoHeight": true, "fieldLabel": "Autor", "name": "user", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.users.Users.detail,Lino.users.Users.insert)}, "hiddenName": "userHidden", "selectOnFocus": true, "emptyText": "Benutzer ausw\u00e4hlen...", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/polls/Polls/user", "method": "GET" }) }) });
    var created4895 = new Ext.form.DisplayField({ "disabled": true, "autoHeight": true, "fieldLabel": "Erstellt", "name": "created", "anchor": "-20", "value": "<br>" });
    var modified4896 = new Ext.form.DisplayField({ "disabled": true, "autoHeight": true, "fieldLabel": "Bearbeitet", "name": "modified", "anchor": "-20", "value": "<br>" });
    var default_choiceset4897 = new Lino.TwinCombo({ "autoHeight": true, "fieldLabel": "Default Choiceset", "name": "default_choiceset", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.polls.ChoiceSets.detail,Lino.polls.ChoiceSets.insert)}, "emptyText": "Choice Set ausw\u00e4hlen...", "selectOnFocus": true, "hiddenName": "default_choicesetHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/polls/Polls/default_choiceset", "method": "GET" }) }) });
    var default_multiple_choices4898 = new Ext.form.Checkbox({ "boxLabel": "Allow multiple choices", "autoHeight": true, "hideLabel": true, "checked": false, "name": "default_multiple_choices", "selectOnFocus": true, "anchor": "-20" });
    var general_3_panel4899 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 207, "hideCheckBoxLabels": true, "items": [ { "flex": 24, "autoHeight": true, "layout": "form", "xtype": "panel", "items": user4894, "labelAlign": "top" }, { "flex": 19, "autoHeight": true, "layout": "form", "xtype": "panel", "items": created4895, "labelAlign": "top" }, { "flex": 19, "autoHeight": true, "layout": "form", "xtype": "panel", "items": modified4896, "labelAlign": "top" }, { "flex": 24, "autoHeight": true, "layout": "form", "xtype": "panel", "items": default_choiceset4897, "labelAlign": "top" }, { "flex": 12, "autoHeight": true, "layout": "form", "xtype": "panel", "items": default_multiple_choices4898, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var polls_QuestionsByPoll_grid4909 = new Lino.polls.QuestionsByPoll.GridPanel({ "flex": 41, "hide_top_toolbar": true, "containing_panel": this, "tools": [ Lino.show_in_own_window_button(Lino.polls.QuestionsByPoll.grid) ], "preview_limit": 15, "master_panel": this });
    var general_panel4910 = new Ext.Panel({ "layout": "vbox", "title": "Allgemein", "items": [ general_1_panel4890, { "items": details4893, "labelAlign": "top", "layout": "form", "xtype": "panel", "flex": 41 }, general_3_panel4899, polls_QuestionsByPoll_grid4909 ], "frame": true, "layoutConfig": { "align": "stretch" }, "hideCheckBoxLabels": true, "listeners": { "activate": Lino.on_tab_activate }, "autoScroll": false, "labelWidth": 72, "border": false, "bodyBorder": false, "labelAlign": "top" });
    var polls_ResponsesByPoll_grid4945 = new Lino.polls.ResponsesByPoll.GridPanel({ "flex": 5, "hide_top_toolbar": true, "containing_panel": this, "region": "north", "preview_limit": 15, "master_panel": this, "split": true, "tools": [ Lino.show_in_own_window_button(Lino.polls.ResponsesByPoll.grid) ] });
    var PollResult_grid4951 = new Lino.polls.PollResult.GridPanel({ "flex": 5, "hide_top_toolbar": true, "containing_panel": this, "region": "center", "preview_limit": 15, "master_panel": this, "split": true, "tools": [ Lino.show_in_own_window_button(Lino.polls.PollResult.grid) ] });
    var results_panel4952 = new Lino.VBorderPanel({ "autoScroll": false, "listeners": { "activate": Lino.on_tab_activate }, "border": false, "title": "Resultate", "hideCheckBoxLabels": true, "items": [ polls_ResponsesByPoll_grid4945, PollResult_grid4951 ], "frame": true, "bodyBorder": false, "labelAlign": "top" });
    var main_panel4953 = new Ext.TabPanel({ "hideCheckBoxLabels": true, "border": false, "split": true, "autoScroll": false, "items": [ general_panel4910, results_panel4952 ], "activeTab": 0, "bodyBorder": false, "frame": true, "labelAlign": "top" });
    this.items = main_panel4953;
    this.before_row_edit = function(record) {
      polls_QuestionsByPoll_grid4909.on_master_changed();
      polls_ResponsesByPoll_grid4945.on_master_changed();
      PollResult_grid4951.on_master_changed();
    }
    Lino.polls.Polls.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.cal.Tasks.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 28,
  initComponent : function() {
    var start_date548 = new Lino.DateField({ "selectOnFocus": true, "autoHeight": true, "fieldLabel": "Beginnt am", "anchor": "-20", "name": "start_date" });
    var due_date549 = new Lino.DateField({ "selectOnFocus": true, "autoHeight": true, "fieldLabel": "Zahlungsziel", "anchor": "-20", "name": "due_date" });
    var id550 = new Ext.form.NumberField({ "selectOnFocus": true, "autoHeight": true, "fieldLabel": "ID", "anchor": "-20", "name": "id" });
    var workflow_buttons_disp551 = new Ext.form.DisplayField({ "disabled": true, "autoHeight": true, "fieldLabel": "Arbeitsablauf", "name": "workflow_buttons", "anchor": "-20", "value": "<br/>", "always_enabled": true });
    var main_1_panel552 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 126, "hideCheckBoxLabels": true, "items": [ { "flex": 21, "autoHeight": true, "layout": "form", "xtype": "panel", "items": start_date548, "labelAlign": "top" }, { "flex": 21, "autoHeight": true, "layout": "form", "xtype": "panel", "items": due_date549, "labelAlign": "top" }, { "flex": 8, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id550, "labelAlign": "top" }, { "flex": 49, "autoHeight": true, "layout": "form", "xtype": "panel", "items": workflow_buttons_disp551, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var summary557 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Kurzbeschreibung", "name": "summary", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var project558 = new Lino.TwinCombo({ "preferred_width": 20, "autoHeight": true, "fieldLabel": "Klient", "name": "project", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.pcsw.Clients.detail,Lino.pcsw.Clients.insert)}, "hiddenName": "projectHidden", "selectOnFocus": true, "emptyText": "Klient ausw\u00e4hlen...", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/Tasks/project", "method": "GET" }) }) });
    var user559 = new Lino.TwinCombo({ "preferred_width": 15, "autoHeight": true, "fieldLabel": "Autor", "name": "user", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.users.Users.detail,Lino.users.Users.insert)}, "hiddenName": "userHidden", "selectOnFocus": true, "emptyText": "Benutzer ausw\u00e4hlen...", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/Tasks/user", "method": "GET" }) }) });
    var delegated560 = new Ext.form.Checkbox({ "boxLabel": "Delegated to client", "autoHeight": true, "hideLabel": true, "checked": false, "name": "delegated", "selectOnFocus": true, "anchor": "-20" });
    var main_3_panel561 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 180, "hideCheckBoxLabels": true, "items": [ { "flex": 40, "autoHeight": true, "layout": "form", "xtype": "panel", "items": project558, "labelAlign": "top" }, { "flex": 40, "autoHeight": true, "layout": "form", "xtype": "panel", "items": user559, "labelAlign": "top" }, { "flex": 20, "autoHeight": true, "layout": "form", "xtype": "panel", "items": delegated560, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var owner_disp565 = new Ext.form.DisplayField({ "disabled": true, "autoHeight": true, "fieldLabel": "Verkn\u00fcpft mit", "anchor": "-20", "name": "owner" });
    var created566 = new Ext.form.DisplayField({ "disabled": true, "autoHeight": true, "fieldLabel": "Erstellt", "name": "created", "anchor": "-20", "value": "<br>" });
    var modified567 = new Ext.form.DisplayField({ "disabled": true, "autoHeight": true, "fieldLabel": "Bearbeitet", "name": "modified", "anchor": "-20", "value": "<br>" });
    var main_4_panel568 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 126, "hideCheckBoxLabels": true, "items": [ { "flex": 20, "autoHeight": true, "layout": "form", "xtype": "panel", "items": owner_disp565, "labelAlign": "top" }, { "flex": 40, "autoHeight": true, "layout": "form", "xtype": "panel", "items": created566, "labelAlign": "top" }, { "flex": 40, "autoHeight": true, "layout": "form", "xtype": "panel", "items": modified567, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var description572 = new Ext.form.TextArea({ "selectOnFocus": true, "fieldLabel": "Beschreibung", "anchor": "-20 -10", "growMax": 2000, "name": "description" });
    var main_panel573 = new Ext.Panel({ "autoScroll": false, "border": false, "layout": "vbox", "labelWidth": 153, "hideCheckBoxLabels": true, "items": [ main_1_panel552, { "items": summary557, "autoHeight": true, "layout": "form", "xtype": "panel", "labelAlign": "top" }, main_3_panel561, main_4_panel568, { "items": description572, "labelAlign": "top", "layout": "form", "xtype": "panel", "flex": 45 } ], "frame": true, "layoutConfig": { "align": "stretch" }, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel573;
    this.before_row_edit = function(record) {
    }
    Lino.cal.Tasks.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.cbss.IdentifyPersonRequests.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 101,
  initComponent : function() {
    var id4411 = new Ext.form.NumberField({ "selectOnFocus": true, "autoHeight": true, "fieldLabel": "ID", "anchor": "-20", "name": "id" });
    var person4412 = new Lino.TwinCombo({ "preferred_width": 20, "autoHeight": true, "fieldLabel": "Klient", "allowBlank": false, "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.pcsw.Clients.detail,Lino.pcsw.Clients.insert)}, "emptyText": "Klient ausw\u00e4hlen...", "selectOnFocus": true, "hiddenName": "personHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cbss/IdentifyPersonRequests/person", "method": "GET" }) }), "name": "person" });
    var user4413 = new Lino.TwinCombo({ "preferred_width": 15, "autoHeight": true, "fieldLabel": "Autor", "allowBlank": false, "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.users.Users.detail,Lino.users.Users.insert)}, "emptyText": "Benutzer ausw\u00e4hlen...", "selectOnFocus": true, "hiddenName": "userHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cbss/IdentifyPersonRequests/user", "method": "GET" }) }), "name": "user" });
    var environment4414 = new Ext.form.TextField({ "disabled": true, "autoHeight": true, "fieldLabel": "T/A/B", "name": "environment", "maxLength": 4, "boxMinWidth": Lino.chars2width(4), "anchor": "-20" });
    var sent4415 = new Ext.form.DisplayField({ "disabled": true, "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Versendet</span>", "name": "sent", "listeners": { "render": Lino.quicktip_renderer("Versendet","The date and time when this request has been executed. \nThis is empty for requests than haven't been sent.\nRead-only.") }, "value": "<br>", "anchor": "-20" });
    var status4416 = new Lino.ChoicesFieldElement({ "autoHeight": true, "forceSelection": true, "fieldLabel": "Zustand", "name": "status", "hiddenName": "statusHidden", "disabled": true, "anchor": "-20", "store": [['','<br>']].concat(Lino.cbss.RequestStates) });
    var ticket4417 = new Ext.form.TextField({ "disabled": true, "autoHeight": true, "fieldLabel": "Ticket", "name": "ticket", "maxLength": 36, "anchor": "-20" });
    var info_1_panel4418 = new Ext.form.FieldSet({ "autoHeight": true, "layout": "hbox", "title": "Info zur Anfrage", "layoutConfig": { "align": "stretchmax" }, "frame": false, "bodyBorder": true, "autoScroll": false, "items": [ { "flex": 5, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id4411, "labelAlign": "top" }, { "flex": 20, "autoHeight": true, "layout": "form", "xtype": "panel", "items": person4412, "labelAlign": "top" }, { "flex": 20, "autoHeight": true, "layout": "form", "xtype": "panel", "items": user4413, "labelAlign": "top" }, { "flex": 5, "autoHeight": true, "layout": "form", "xtype": "panel", "items": environment4414, "labelAlign": "top" }, { "flex": 16, "autoHeight": true, "layout": "form", "xtype": "panel", "items": sent4415, "labelAlign": "top" }, { "flex": 12, "autoHeight": true, "layout": "form", "xtype": "panel", "items": status4416, "labelAlign": "top" }, { "flex": 21, "autoHeight": true, "layout": "form", "xtype": "panel", "items": ticket4417, "labelAlign": "top" } ], "hideCheckBoxLabels": true, "labelWidth": 90, "border": false, "labelAlign": "top" });
    var national_id4426 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "NR-Nummer", "name": "national_id", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var p1_panel4428 = new Ext.form.FieldSet({ "flex": 25, "layout": "vbox", "title": "Suche per NISS", "layoutConfig": { "align": "stretch" }, "frame": true, "bodyBorder": false, "autoScroll": false, "items": [ { "items": national_id4426, "autoHeight": true, "layout": "form", "xtype": "panel", "labelAlign": "top" }, { "flex": 50, "html": "<br/>", "xtype": "label" } ], "hideCheckBoxLabels": true, "labelWidth": 90, "border": false, "labelAlign": "top" });
    var first_name4430 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Vorname", "name": "first_name", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var middle_name4431 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Zwischenname</span>", "name": "middle_name", "maxLength": 200, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Zwischenname","Whatever this means...") }, "anchor": "-20" });
    var last_name4432 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Familienname", "name": "last_name", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var p2_1_panel4433 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": first_name4430, "labelAlign": "top" }, { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": middle_name4431, "labelAlign": "top" }, { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": last_name4432, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 117, "border": false, "anchor": "-20", "labelAlign": "top" });
    var birth_date4437 = new Lino.IncompleteDateField({ "autoHeight": true, "allowBlank": false, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Geburtsdatum</span>", "name": "birth_date", "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Geburtsdatum","Uncomplete dates are allowed, e.g. \n\"00.00.1980\" means \"some day in 1980\", \n\"00.07.1980\" means \"in July 1980\"\nor \"23.07.0000\" means \"on a 23th of July\".") }, "anchor": "-20" });
    var tolerance4438 = new Ext.form.NumberField({ "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Toleranz</span>", "name": "tolerance", "value": 0, "listeners": { "render": Lino.quicktip_renderer("Toleranz","\n      Falls Monat oder Tag des Geburtsdatums unbekannt sind, \n      um wieviel Monate bzw. Tage die Suche nach unten/oben ausgeweitet wird.\n      G\u00fcltige Werte: 0 bis 10.\n      ") }, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var gender4439 = new Lino.ChoicesFieldElement({ "autoHeight": true, "forceSelection": true, "fieldLabel": "Geschlecht", "name": "gender", "hiddenName": "genderHidden", "selectOnFocus": true, "anchor": "-20", "store": [['','<br>']].concat(Lino.lino.Genders) });
    var p2_2_panel4440 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 46, "autoHeight": true, "layout": "form", "xtype": "panel", "items": birth_date4437, "labelAlign": "top" }, { "flex": 19, "autoHeight": true, "layout": "form", "xtype": "panel", "items": tolerance4438, "labelAlign": "top" }, { "flex": 34, "autoHeight": true, "layout": "form", "xtype": "panel", "items": gender4439, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 117, "border": false, "anchor": "-20", "labelAlign": "top" });
    var p2_panel4444 = new Ext.form.FieldSet({ "flex": 75, "autoHeight": true, "layout": "form", "title": "Phonetische Suche", "items": [ p2_1_panel4433, p2_2_panel4440 ], "frame": true, "bodyBorder": false, "autoScroll": false, "hideCheckBoxLabels": true, "border": false, "labelAlign": "top" });
    var parameters_panel4445 = new Ext.form.FieldSet({ "autoHeight": true, "layout": "hbox", "title": "Parameter", "layoutConfig": { "align": "stretchmax" }, "frame": false, "bodyBorder": true, "autoScroll": false, "items": [ p1_panel4428, p2_panel4444 ], "hideCheckBoxLabels": true, "border": false, "labelAlign": "top" });
    var IdentifyPersonResult_grid4456 = new Lino.cbss.IdentifyPersonResult.GridPanel({ "flex": 62, "hide_top_toolbar": true, "containing_panel": this, "tools": [ Lino.show_in_own_window_button(Lino.cbss.IdentifyPersonResult.grid) ], "preview_limit": 15, "master_panel": this });
    var request_panel4457 = new Ext.Panel({ "layout": "vbox", "title": "Abfrage", "items": [ info_1_panel4418, parameters_panel4445, IdentifyPersonResult_grid4456 ], "frame": true, "layoutConfig": { "align": "stretch" }, "hideCheckBoxLabels": true, "listeners": { "activate": Lino.on_tab_activate }, "autoScroll": false, "border": false, "bodyBorder": false, "labelAlign": "top" });
    var response_xml4458 = new Ext.form.TextArea({ "disabled": true, "listeners": { "render": Lino.quicktip_renderer("Antwort","The raw XML response received. \n") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Antwort</span>", "name": "response_xml", "growMax": 2000, "anchor": "-20 -10" });
    var info_messages4459 = new Ext.form.TextArea({ "disabled": true, "fieldLabel": "Info-Meldungen", "anchor": "-20 -10", "growMax": 2000, "name": "info_messages" });
    var debug_messages4460 = new Ext.form.TextArea({ "disabled": true, "fieldLabel": "Debug-Meldungen", "anchor": "-20 -10", "growMax": 2000, "name": "debug_messages" });
    var technical_panel4461 = new Lino.VBorderPanel({ "autoScroll": false, "listeners": { "activate": Lino.on_tab_activate }, "border": false, "labelWidth": 144, "title": "Technisch", "hideCheckBoxLabels": true, "items": [ { "flex": 5, "layout": "form", "xtype": "panel", "items": response_xml4458, "region": "north", "labelAlign": "top", "split": true }, { "flex": 5, "layout": "form", "xtype": "panel", "items": info_messages4459, "region": "center", "labelAlign": "top", "split": true }, { "flex": 5, "layout": "form", "xtype": "panel", "items": debug_messages4460, "region": "south", "labelAlign": "top", "split": true } ], "frame": true, "bodyBorder": false, "labelAlign": "top" });
    var main_panel4465 = new Ext.TabPanel({ "hideCheckBoxLabels": true, "border": false, "split": true, "autoScroll": false, "items": [ request_panel4457, technical_panel4461 ], "activeTab": 0, "bodyBorder": false, "frame": true, "labelAlign": "top" });
    this.items = main_panel4465;
    this.before_row_edit = function(record) {
      IdentifyPersonResult_grid4456.on_master_changed();
    }
    Lino.cbss.IdentifyPersonRequests.DetailFormPanel.superclass.initComponent.call(this);
    // active_fields:
    person4412.on("change", function(){ this.save() }, this);
  }
});


Lino.cal.GuestRoles.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 35,
  initComponent : function() {
    var id1109 = new Ext.form.NumberField({ "selectOnFocus": true, "autoHeight": true, "fieldLabel": "ID", "anchor": "-20", "name": "id" });
    var name1110 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Bezeichnung", "name": "name", "maxLength": 200, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var name_fr1111 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Bezeichnung (fr)", "name": "name_fr", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var name_de1112 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Bezeichnung (de)", "name": "name_de", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var name_nl1113 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Bezeichnung (nl)", "name": "name_nl", "maxLength": 200, "selectOnFocus": true, "hidden": true, "anchor": "-20" });
    var main_1_panel1114 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 153, "hideCheckBoxLabels": true, "items": [ { "flex": 5, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id1109, "labelAlign": "top" }, { "flex": 23, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name1110, "labelAlign": "top" }, { "flex": 23, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_fr1111, "labelAlign": "top" }, { "flex": 23, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_de1112, "labelAlign": "top" }, { "flex": 23, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_nl1113, "hidden": true, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var cal_GuestsByRole_grid1131 = new Lino.cal.GuestsByRole.GridPanel({ "flex": 83, "hide_top_toolbar": true, "containing_panel": this, "tools": [ Lino.show_in_own_window_button(Lino.cal.GuestsByRole.grid) ], "preview_limit": 15, "master_panel": this });
    var main_panel1132 = new Ext.Panel({ "autoScroll": false, "border": false, "layout": "vbox", "hideCheckBoxLabels": true, "items": [ main_1_panel1114, cal_GuestsByRole_grid1131 ], "frame": true, "layoutConfig": { "align": "stretch" }, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel1132;
    this.before_row_edit = function(record) {
      cal_GuestsByRole_grid1131.on_master_changed();
    }
    Lino.cal.GuestRoles.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.pcsw.CoachingEndings.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 50,
  initComponent : function() {
    var id3254 = new Ext.form.NumberField({ "selectOnFocus": true, "autoHeight": true, "fieldLabel": "ID", "anchor": "-20", "name": "id" });
    var name3255 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Bezeichnung", "name": "name", "maxLength": 200, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var name_fr3256 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Bezeichnung (fr)", "name": "name_fr", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var name_de3257 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Bezeichnung (de)", "name": "name_de", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var name_nl3258 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Bezeichnung (nl)", "name": "name_nl", "maxLength": 200, "selectOnFocus": true, "hidden": true, "anchor": "-20" });
    var seqno3259 = new Ext.form.NumberField({ "selectOnFocus": true, "autoHeight": true, "fieldLabel": "Seq.-Nr.", "anchor": "-20", "name": "seqno" });
    var main_1_panel3260 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 153, "hideCheckBoxLabels": true, "items": [ { "flex": 5, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id3254, "labelAlign": "top" }, { "flex": 22, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name3255, "labelAlign": "top" }, { "flex": 22, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_fr3256, "labelAlign": "top" }, { "flex": 22, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_de3257, "labelAlign": "top" }, { "flex": 22, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_nl3258, "hidden": true, "labelAlign": "top" }, { "flex": 5, "autoHeight": true, "layout": "form", "xtype": "panel", "items": seqno3259, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var CoachingsByEnding_grid3275 = new Lino.pcsw.CoachingsByEnding.GridPanel({ "flex": 83, "hide_top_toolbar": true, "containing_panel": this, "params_panel_hidden": true, "tools": [ Lino.show_in_own_window_button(Lino.pcsw.CoachingsByEnding.grid) ], "master_panel": this, "preview_limit": 15 });
    var main_panel3276 = new Ext.Panel({ "autoScroll": false, "border": false, "layout": "vbox", "hideCheckBoxLabels": true, "items": [ main_1_panel3260, CoachingsByEnding_grid3275 ], "frame": true, "layoutConfig": { "align": "stretch" }, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel3276;
    this.before_row_edit = function(record) {
      CoachingsByEnding_grid3275.on_master_changed();
    }
    Lino.pcsw.CoachingEndings.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.cbss.IdentifyPersonRequests.InsertFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  autoHeight: true,
  content_type: 101,
  initComponent : function() {
    var person4466 = new Lino.TwinCombo({ "preferred_width": 20, "autoHeight": true, "fieldLabel": "Klient", "allowBlank": false, "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.pcsw.Clients.detail,Lino.pcsw.Clients.insert)}, "emptyText": "Klient ausw\u00e4hlen...", "selectOnFocus": true, "hiddenName": "personHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cbss/IdentifyPersonRequests/person", "method": "GET" }) }), "name": "person" });
    var national_id4467 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "NR-Nummer", "name": "national_id", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var main_1_panel4468 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 48, "autoHeight": true, "layout": "form", "xtype": "panel", "items": person4466, "labelAlign": "top" }, { "flex": 51, "autoHeight": true, "layout": "form", "xtype": "panel", "items": national_id4467, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 90, "border": false, "anchor": "-20", "labelAlign": "top" });
    var first_name4471 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Vorname", "name": "first_name", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var middle_name4472 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Zwischenname</span>", "name": "middle_name", "maxLength": 200, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Zwischenname","Whatever this means...") }, "anchor": "-20" });
    var last_name4473 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Familienname", "name": "last_name", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var p2_1_panel4474 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": first_name4471, "labelAlign": "top" }, { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": middle_name4472, "labelAlign": "top" }, { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": last_name4473, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 117, "border": false, "anchor": "-20", "labelAlign": "top" });
    var birth_date4478 = new Lino.IncompleteDateField({ "autoHeight": true, "allowBlank": false, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Geburtsdatum</span>", "name": "birth_date", "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Geburtsdatum","Uncomplete dates are allowed, e.g. \n\"00.00.1980\" means \"some day in 1980\", \n\"00.07.1980\" means \"in July 1980\"\nor \"23.07.0000\" means \"on a 23th of July\".") }, "anchor": "-20" });
    var tolerance4479 = new Ext.form.NumberField({ "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Toleranz</span>", "name": "tolerance", "value": 0, "listeners": { "render": Lino.quicktip_renderer("Toleranz","\n      Falls Monat oder Tag des Geburtsdatums unbekannt sind, \n      um wieviel Monate bzw. Tage die Suche nach unten/oben ausgeweitet wird.\n      G\u00fcltige Werte: 0 bis 10.\n      ") }, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var gender4480 = new Lino.ChoicesFieldElement({ "autoHeight": true, "forceSelection": true, "fieldLabel": "Geschlecht", "name": "gender", "hiddenName": "genderHidden", "selectOnFocus": true, "anchor": "-20", "store": [['','<br>']].concat(Lino.lino.Genders) });
    var p2_2_panel4481 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 46, "autoHeight": true, "layout": "form", "xtype": "panel", "items": birth_date4478, "labelAlign": "top" }, { "flex": 19, "autoHeight": true, "layout": "form", "xtype": "panel", "items": tolerance4479, "labelAlign": "top" }, { "flex": 34, "autoHeight": true, "layout": "form", "xtype": "panel", "items": gender4480, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 117, "border": false, "anchor": "-20", "labelAlign": "top" });
    var p2_panel4485 = new Ext.form.FieldSet({ "autoHeight": true, "layout": "form", "title": "Phonetische Suche", "items": [ p2_1_panel4474, p2_2_panel4481 ], "frame": true, "bodyBorder": false, "autoScroll": false, "hideCheckBoxLabels": true, "border": false, "anchor": "-20", "labelAlign": "top" });
    var main_panel4486 = new Ext.Panel({ "hideCheckBoxLabels": true, "autoHeight": true, "border": false, "layout": "form", "autoScroll": false, "items": [ main_1_panel4468, p2_panel4485 ], "frame": true, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel4486;
    this.before_row_edit = function(record) {
    }
    Lino.cbss.IdentifyPersonRequests.InsertFormPanel.superclass.initComponent.call(this);
  }
});


Lino.cal.RecurrentEvents.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 30,
  initComponent : function() {
    var name1209 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Bezeichnung", "name": "name", "maxLength": 200, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var name_fr1210 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Bezeichnung (fr)", "name": "name_fr", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var name_de1211 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Bezeichnung (de)", "name": "name_de", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var name_nl1212 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Bezeichnung (nl)", "name": "name_nl", "maxLength": 200, "selectOnFocus": true, "hidden": true, "anchor": "-20" });
    var main_1_panel1213 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 153, "hideCheckBoxLabels": true, "items": [ { "flex": 25, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name1209, "labelAlign": "top" }, { "flex": 25, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_fr1210, "labelAlign": "top" }, { "flex": 25, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_de1211, "labelAlign": "top" }, { "flex": 25, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_nl1212, "hidden": true, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var id1218 = new Ext.form.NumberField({ "selectOnFocus": true, "autoHeight": true, "fieldLabel": "ID", "anchor": "-20", "name": "id" });
    var user1219 = new Lino.TwinCombo({ "preferred_width": 15, "autoHeight": true, "fieldLabel": "Autor", "name": "user", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.users.Users.detail,Lino.users.Users.insert)}, "hiddenName": "userHidden", "selectOnFocus": true, "emptyText": "Benutzer ausw\u00e4hlen...", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/RecurrentEvents/user", "method": "GET" }) }) });
    var event_type1220 = new Lino.TwinCombo({ "autoHeight": true, "fieldLabel": "Ereignisart", "name": "event_type", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.cal.EventTypes.detail,Lino.cal.EventTypes.insert)}, "emptyText": "Ereignisart ausw\u00e4hlen...", "selectOnFocus": true, "hiddenName": "event_typeHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/RecurrentEvents/event_type", "method": "GET" }) }) });
    var main_2_panel1221 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 108, "hideCheckBoxLabels": true, "items": [ { "flex": 11, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id1218, "labelAlign": "top" }, { "flex": 44, "autoHeight": true, "layout": "form", "xtype": "panel", "items": user1219, "labelAlign": "top" }, { "flex": 44, "autoHeight": true, "layout": "form", "xtype": "panel", "items": event_type1220, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var start_date1225 = new Lino.DateField({ "selectOnFocus": true, "autoHeight": true, "fieldLabel": "Beginnt am", "anchor": "-20", "name": "start_date" });
    var start_time1226 = new Lino.TimeField({ "selectOnFocus": true, "autoHeight": true, "fieldLabel": "Beginnt um", "anchor": "-20", "name": "start_time" });
    var end_date1227 = new Lino.DateField({ "selectOnFocus": true, "autoHeight": true, "fieldLabel": "Endet am", "anchor": "-20", "name": "end_date" });
    var end_time1228 = new Lino.TimeField({ "selectOnFocus": true, "autoHeight": true, "fieldLabel": "Endet um", "anchor": "-20", "name": "end_time" });
    var main_3_panel1229 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 99, "hideCheckBoxLabels": true, "items": [ { "flex": 30, "autoHeight": true, "layout": "form", "xtype": "panel", "items": start_date1225, "labelAlign": "top" }, { "flex": 19, "autoHeight": true, "layout": "form", "xtype": "panel", "items": start_time1226, "labelAlign": "top" }, { "flex": 30, "autoHeight": true, "layout": "form", "xtype": "panel", "items": end_date1227, "labelAlign": "top" }, { "flex": 19, "autoHeight": true, "layout": "form", "xtype": "panel", "items": end_time1228, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var every_unit1234 = new Lino.ChoicesFieldElement({ "autoHeight": true, "forceSelection": true, "fieldLabel": "Wiederholung", "allowBlank": false, "hiddenName": "every_unitHidden", "selectOnFocus": true, "anchor": "-20", "store": Lino.cal.Recurrencies, "name": "every_unit" });
    var every1235 = new Ext.form.NumberField({ "autoHeight": true, "fieldLabel": "... alle", "name": "every", "selectOnFocus": true, "anchor": "-20", "value": 0, "allowBlank": false });
    var max_events1236 = new Ext.form.NumberField({ "selectOnFocus": true, "autoHeight": true, "fieldLabel": "Anzahl Termine", "anchor": "-20", "name": "max_events" });
    var main_4_panel1237 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 135, "hideCheckBoxLabels": true, "items": [ { "flex": 58, "autoHeight": true, "layout": "form", "xtype": "panel", "items": every_unit1234, "labelAlign": "top" }, { "flex": 20, "autoHeight": true, "layout": "form", "xtype": "panel", "items": every1235, "labelAlign": "top" }, { "flex": 20, "autoHeight": true, "layout": "form", "xtype": "panel", "items": max_events1236, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var monday1241 = new Ext.form.Checkbox({ "boxLabel": "Montag", "autoHeight": true, "hideLabel": true, "checked": false, "name": "monday", "selectOnFocus": true, "anchor": "-20" });
    var tuesday1242 = new Ext.form.Checkbox({ "boxLabel": "Dienstag", "autoHeight": true, "hideLabel": true, "checked": false, "name": "tuesday", "selectOnFocus": true, "anchor": "-20" });
    var wednesday1243 = new Ext.form.Checkbox({ "boxLabel": "Mittwoch", "autoHeight": true, "hideLabel": true, "checked": false, "name": "wednesday", "selectOnFocus": true, "anchor": "-20" });
    var thursday1244 = new Ext.form.Checkbox({ "boxLabel": "Donnerstag", "autoHeight": true, "hideLabel": true, "checked": false, "name": "thursday", "selectOnFocus": true, "anchor": "-20" });
    var friday1245 = new Ext.form.Checkbox({ "boxLabel": "Freitag", "autoHeight": true, "hideLabel": true, "checked": false, "name": "friday", "selectOnFocus": true, "anchor": "-20" });
    var saturday1246 = new Ext.form.Checkbox({ "boxLabel": "Samstag", "autoHeight": true, "hideLabel": true, "checked": false, "name": "saturday", "selectOnFocus": true, "anchor": "-20" });
    var sunday1247 = new Ext.form.Checkbox({ "boxLabel": "Sonntag", "autoHeight": true, "hideLabel": true, "checked": false, "name": "sunday", "selectOnFocus": true, "anchor": "-20" });
    var main_5_panel1248 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 99, "hideCheckBoxLabels": true, "items": [ { "flex": 14, "autoHeight": true, "layout": "form", "xtype": "panel", "items": monday1241, "labelAlign": "top" }, { "flex": 14, "autoHeight": true, "layout": "form", "xtype": "panel", "items": tuesday1242, "labelAlign": "top" }, { "flex": 14, "autoHeight": true, "layout": "form", "xtype": "panel", "items": wednesday1243, "labelAlign": "top" }, { "flex": 14, "autoHeight": true, "layout": "form", "xtype": "panel", "items": thursday1244, "labelAlign": "top" }, { "flex": 14, "autoHeight": true, "layout": "form", "xtype": "panel", "items": friday1245, "labelAlign": "top" }, { "flex": 14, "autoHeight": true, "layout": "form", "xtype": "panel", "items": saturday1246, "labelAlign": "top" }, { "flex": 14, "autoHeight": true, "layout": "form", "xtype": "panel", "items": sunday1247, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var description1256 = new Lino.RichTextPanel({ "selectOnFocus": true, "flex": 33, "containing_panel": this, "name": "description", "title": "Beschreibung" });
    var cal_EventsByController_grid1283 = new Lino.cal.EventsByController.GridPanel({ "flex": 66, "hide_top_toolbar": true, "containing_panel": this, "params_panel_hidden": true, "tools": [ Lino.show_in_own_window_button(Lino.cal.EventsByController.grid) ], "master_panel": this, "preview_limit": 15 });
    var main_6_panel1284 = new Ext.Panel({ "flex": 50, "border": false, "layout": "hbox", "labelWidth": 0, "hideCheckBoxLabels": true, "items": [ description1256, cal_EventsByController_grid1283 ], "autoScroll": false, "layoutConfig": { "align": "stretch" }, "frame": false, "labelAlign": "top" });
    var main_panel1285 = new Ext.Panel({ "autoScroll": false, "border": false, "layout": "vbox", "hideCheckBoxLabels": true, "items": [ main_1_panel1213, main_2_panel1221, main_3_panel1229, main_4_panel1237, main_5_panel1248, main_6_panel1284 ], "frame": true, "layoutConfig": { "align": "stretch" }, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel1285;
    this.before_row_edit = function(record) {
      description1256.refresh();
      cal_EventsByController_grid1283.on_master_changed();
    }
    Lino.cal.RecurrentEvents.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.households.HouseholdsByType.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 103,
  initComponent : function() {
    var type2161 = new Lino.TwinCombo({ "autoHeight": true, "fieldLabel": "Haushaltsart", "name": "type", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.households.Types.detail,Lino.households.Types.insert)}, "emptyText": "Haushaltsart ausw\u00e4hlen...", "selectOnFocus": true, "hiddenName": "typeHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/households/HouseholdsByType/type", "method": "GET" }) }) });
    var name2162 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Name", "name": "name", "maxLength": 200, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var language2163 = new Lino.ChoicesFieldElement({ "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Sprache</span>", "allowBlank": false, "hiddenName": "languageHidden", "listeners": { "render": Lino.quicktip_renderer("Sprache","Die Sprache, in der Dokumente ausgestellt werden sollen.") }, "selectOnFocus": true, "anchor": "-20", "store": [ [ "en", "Englisch" ], [ "fr", "Franz\u00f6sisch" ], [ "de", "Deutsch" ], [ "nl", "Niederl\u00e4ndisch" ] ], "name": "language" });
    var id2164 = new Ext.form.NumberField({ "selectOnFocus": true, "autoHeight": true, "fieldLabel": "ID", "anchor": "-20", "name": "id" });
    var main_1_panel2165 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 117, "hideCheckBoxLabels": true, "items": [ { "flex": 35, "autoHeight": true, "layout": "form", "xtype": "panel", "items": type2161, "labelAlign": "top" }, { "flex": 37, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name2162, "labelAlign": "top" }, { "flex": 17, "autoHeight": true, "layout": "form", "xtype": "panel", "items": language2163, "labelAlign": "top" }, { "flex": 8, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id2164, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var country2170 = new Lino.TwinCombo({ "autoHeight": true, "fieldLabel": "Land", "name": "country", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.countries.Countries.detail,Lino.countries.Countries.insert)}, "emptyText": "Land ausw\u00e4hlen...", "selectOnFocus": true, "hiddenName": "countryHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/households/HouseholdsByType/country", "method": "GET" }) }) });
    var region2171 = new Lino.TwinCombo({ "autoHeight": true, "fieldLabel": "Regierungsbezirk", "name": "region", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.countries.Places.detail,Lino.countries.Places.insert)}, "emptyText": "Ort ausw\u00e4hlen...", "selectOnFocus": true, "hiddenName": "regionHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/households/HouseholdsByType/region", "method": "GET" }) }) });
    var box3_1_panel2172 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": country2170, "labelAlign": "top" }, { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": region2171, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 153, "border": false, "anchor": "-20", "labelAlign": "top" });
    var city2175 = new Lino.TwinCombo({ "autoHeight": true, "forceSelection": false, "fieldLabel": "Stadt", "name": "city", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.countries.Places.detail,Lino.countries.Places.insert)}, "emptyText": "Ort ausw\u00e4hlen...", "selectOnFocus": true, "hiddenName": "cityHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/households/HouseholdsByType/city", "method": "GET" }) }) });
    var zip_code2176 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Postleitzahl", "name": "zip_code", "maxLength": 10, "selectOnFocus": true, "boxMinWidth": Lino.chars2width(10), "anchor": "-20" });
    var box3_2_panel2177 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 66, "autoHeight": true, "layout": "form", "xtype": "panel", "items": city2175, "labelAlign": "top" }, { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": zip_code2176, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 117, "border": false, "anchor": "-20", "labelAlign": "top" });
    var street_prefix2180 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Pr\u00e4fix Stra\u00dfe</span>", "name": "street_prefix", "maxLength": 200, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Pr\u00e4fix Stra\u00dfe","Text to print before name of street, but to ignore for sorting.") }, "anchor": "-20" });
    var street2181 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Stra\u00dfe</span>", "name": "street", "maxLength": 200, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Stra\u00dfe","Name der Stra\u00dfe, ohne Hausnummer") }, "anchor": "-20" });
    var street_no2182 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Nr.</span>", "name": "street_no", "boxMinWidth": Lino.chars2width(10), "listeners": { "render": Lino.quicktip_renderer("Nr.","Hausnummer") }, "maxLength": 10, "selectOnFocus": true, "anchor": "-20" });
    var street_box2183 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Box</span>", "name": "street_box", "boxMinWidth": Lino.chars2width(10), "listeners": { "render": Lino.quicktip_renderer("Box","Text to print after street nuber on the same line.") }, "maxLength": 10, "selectOnFocus": true, "anchor": "-20" });
    var box3_3_panel2184 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 30, "autoHeight": true, "layout": "form", "xtype": "panel", "items": street_prefix2180, "labelAlign": "top" }, { "flex": 36, "autoHeight": true, "layout": "form", "xtype": "panel", "items": street2181, "labelAlign": "top" }, { "flex": 16, "autoHeight": true, "layout": "form", "xtype": "panel", "items": street_no2182, "labelAlign": "top" }, { "flex": 16, "autoHeight": true, "layout": "form", "xtype": "panel", "items": street_box2183, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 126, "border": false, "anchor": "-20", "labelAlign": "top" });
    var addr22189 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Adresszeile nach Stra\u00dfe</span>", "name": "addr2", "maxLength": 200, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Adresszeile nach Stra\u00dfe","Adresszeile nach Stra\u00dfe") }, "anchor": "-20" });
    var box3_panel2190 = new Ext.Panel({ "flex": 62, "autoHeight": true, "layout": "form", "items": [ box3_1_panel2172, box3_2_panel2177, box3_3_panel2184, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": addr22189, "anchor": "-20", "labelAlign": "top" } ], "frame": true, "bodyBorder": false, "autoScroll": false, "hideCheckBoxLabels": true, "labelWidth": 216, "border": false, "labelAlign": "top" });
    var phone2192 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Telefon", "name": "phone", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var gsm2193 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "GSM", "name": "gsm", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var email2194 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "E-Mail", "name": "email", "maxLength": 75, "selectOnFocus": true, "anchor": "-20" });
    var url2195 = new Lino.URLField({ "autoHeight": true, "fieldLabel": "URL", "name": "url", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var box4_panel2196 = new Ext.Panel({ "flex": 37, "autoHeight": true, "layout": "form", "items": [ { "autoHeight": true, "layout": "form", "xtype": "panel", "items": phone2192, "anchor": "-20", "labelAlign": "top" }, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": gsm2193, "anchor": "-20", "labelAlign": "top" }, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": email2194, "anchor": "-20", "labelAlign": "top" }, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": url2195, "anchor": "-20", "labelAlign": "top" } ], "frame": true, "bodyBorder": false, "autoScroll": false, "hideCheckBoxLabels": true, "labelWidth": 72, "border": false, "labelAlign": "top" });
    var address_box_panel2201 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "hideCheckBoxLabels": true, "items": [ box3_panel2190, box4_panel2196 ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var remarks2202 = new Ext.form.TextArea({ "selectOnFocus": true, "fieldLabel": "Bemerkungen", "anchor": "-20 -10", "growMax": 2000, "name": "remarks" });
    var households_MembersByHousehold_grid2217 = new Lino.households.MembersByHousehold.GridPanel({ "flex": 66, "hide_top_toolbar": true, "containing_panel": this, "tools": [ Lino.show_in_own_window_button(Lino.households.MembersByHousehold.grid) ], "preview_limit": 15, "master_panel": this });
    var bottom_box_panel2218 = new Ext.Panel({ "flex": 50, "border": false, "layout": "hbox", "labelWidth": 108, "hideCheckBoxLabels": true, "items": [ { "items": remarks2202, "labelAlign": "top", "layout": "form", "xtype": "panel", "flex": 33 }, households_MembersByHousehold_grid2217 ], "autoScroll": false, "layoutConfig": { "align": "stretch" }, "frame": false, "labelAlign": "top" });
    var main_panel2220 = new Ext.Panel({ "autoScroll": false, "border": false, "layout": "vbox", "hideCheckBoxLabels": true, "items": [ main_1_panel2165, address_box_panel2201, bottom_box_panel2218 ], "frame": true, "layoutConfig": { "align": "stretch" }, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel2220;
    this.before_row_edit = function(record) {
      region2171.setContextValue('country', record ? record.data['countryHidden'] : undefined);
      city2175.setContextValue('country', record ? record.data['countryHidden'] : undefined);
      city2175.setContextValue('region', record ? record.data['regionHidden'] : undefined);
      households_MembersByHousehold_grid2217.on_master_changed();
    }
    this.onRender = function(ct, position) {
      country2170.on('change',Lino.chooser_handler(region2171,'country'));
      country2170.on('change',Lino.chooser_handler(city2175,'country'));
      region2171.on('change',Lino.chooser_handler(city2175,'region'));
      Lino.households.HouseholdsByType.DetailFormPanel.superclass.onRender.call(this, ct, position);
    }
    Lino.households.HouseholdsByType.DetailFormPanel.superclass.initComponent.call(this);
    // active_fields:
    city2175.on("change", function(){ this.save() }, this);
    zip_code2176.on("change", function(){ this.save() }, this);
  }
});


Lino.notes.NoteTypes.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 111,
  initComponent : function() {
    var id413 = new Ext.form.NumberField({ "selectOnFocus": true, "autoHeight": true, "fieldLabel": "ID", "anchor": "-20", "name": "id" });
    var name414 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Bezeichnung", "name": "name", "maxLength": 200, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var name_fr415 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Bezeichnung (fr)", "name": "name_fr", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var name_de416 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Bezeichnung (de)", "name": "name_de", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var name_nl417 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Bezeichnung (nl)", "name": "name_nl", "maxLength": 200, "selectOnFocus": true, "hidden": true, "anchor": "-20" });
    var main_1_panel418 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 153, "hideCheckBoxLabels": true, "items": [ { "flex": 5, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id413, "labelAlign": "top" }, { "flex": 23, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name414, "labelAlign": "top" }, { "flex": 23, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_fr415, "labelAlign": "top" }, { "flex": 23, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_de416, "labelAlign": "top" }, { "flex": 23, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_nl417, "hidden": true, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var build_method424 = new Lino.ChoicesFieldElement({ "autoHeight": true, "forceSelection": true, "fieldLabel": "Konstruktionsmethode", "name": "build_method", "hiddenName": "build_methodHidden", "selectOnFocus": true, "anchor": "-20", "store": [['','<br>']].concat(Lino.lino.BuildMethods) });
    var template425 = new Lino.SimpleRemoteComboFieldElement({ "autoHeight": true, "fieldLabel": "Vorlage", "name": "template", "selectOnFocus": true, "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/notes/NoteTypes/template", "method": "GET" }) }) });
    var email_template426 = new Lino.SimpleRemoteComboFieldElement({ "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">E-Mail-Vorlage</span>", "name": "email_template", "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("E-Mail-Vorlage","The name of the file to be used as template when creating an email from a mailable of this type.") }, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/notes/NoteTypes/email_template", "method": "GET" }) }), "anchor": "-20" });
    var attach_to_email427 = new Ext.form.Checkbox({ "autoHeight": true, "hideLabel": true, "checked": false, "name": "attach_to_email", "listeners": { "render": Lino.quicktip_renderer("als Anhang per E-Mail","Whether the printable file should be attached to the email\nwhen creating an email from a mailable of this type.\n") }, "boxLabel": "als Anhang per E-Mail", "selectOnFocus": true, "anchor": "-20" });
    var main_2_panel428 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 198, "hideCheckBoxLabels": true, "items": [ { "flex": 41, "autoHeight": true, "layout": "form", "xtype": "panel", "items": build_method424, "labelAlign": "top" }, { "flex": 19, "autoHeight": true, "layout": "form", "xtype": "panel", "items": template425, "labelAlign": "top" }, { "flex": 19, "autoHeight": true, "layout": "form", "xtype": "panel", "items": email_template426, "labelAlign": "top" }, { "flex": 19, "autoHeight": true, "layout": "form", "xtype": "panel", "items": attach_to_email427, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var remark433 = new Ext.form.TextArea({ "selectOnFocus": true, "fieldLabel": "Bemerkung", "anchor": "-20 -10", "growMax": 2000, "name": "remark" });
    var notes_NotesByType_grid603 = new Lino.notes.NotesByType.GridPanel({ "flex": 41, "hide_top_toolbar": true, "containing_panel": this, "tools": [ Lino.show_in_own_window_button(Lino.notes.NotesByType.grid) ], "preview_limit": 15, "master_panel": this });
    var main_panel604 = new Ext.Panel({ "autoScroll": false, "border": false, "layout": "vbox", "labelWidth": 90, "hideCheckBoxLabels": true, "items": [ main_1_panel418, main_2_panel428, { "items": remark433, "labelAlign": "top", "layout": "form", "xtype": "panel", "flex": 41 }, notes_NotesByType_grid603 ], "frame": true, "layoutConfig": { "align": "stretch" }, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel604;
    this.before_row_edit = function(record) {
      template425.setContextValue('build_method', record ? record.data['build_methodHidden'] : undefined);
      notes_NotesByType_grid603.on_master_changed();
    }
    this.onRender = function(ct, position) {
      build_method424.on('change',Lino.chooser_handler(template425,'build_method'));
      Lino.notes.NoteTypes.DetailFormPanel.superclass.onRender.call(this, ct, position);
    }
    Lino.notes.NoteTypes.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.cal.EventTypes.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 31,
  initComponent : function() {
    var name1133 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Bezeichnung", "name": "name", "maxLength": 200, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var name_fr1134 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Bezeichnung (fr)", "name": "name_fr", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var name_de1135 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Bezeichnung (de)", "name": "name_de", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var name_nl1136 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Bezeichnung (nl)", "name": "name_nl", "maxLength": 200, "selectOnFocus": true, "hidden": true, "anchor": "-20" });
    var main_1_panel1137 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 153, "hideCheckBoxLabels": true, "items": [ { "flex": 25, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name1133, "labelAlign": "top" }, { "flex": 25, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_fr1134, "labelAlign": "top" }, { "flex": 25, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_de1135, "labelAlign": "top" }, { "flex": 25, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_nl1136, "hidden": true, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var event_label1142 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Bezeichnung Termin", "name": "event_label", "maxLength": 200, "selectOnFocus": true, "anchor": "-20", "value": "Termin" });
    var event_label_fr1143 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Bezeichnung Termin (fr)", "name": "event_label_fr", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var event_label_de1144 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Bezeichnung Termin (de)", "name": "event_label_de", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var event_label_nl1145 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Bezeichnung Termin (nl)", "name": "event_label_nl", "maxLength": 200, "selectOnFocus": true, "hidden": true, "anchor": "-20" });
    var main_2_panel1146 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 216, "hideCheckBoxLabels": true, "items": [ { "flex": 25, "autoHeight": true, "layout": "form", "xtype": "panel", "items": event_label1142, "labelAlign": "top" }, { "flex": 25, "autoHeight": true, "layout": "form", "xtype": "panel", "items": event_label_fr1143, "labelAlign": "top" }, { "flex": 25, "autoHeight": true, "layout": "form", "xtype": "panel", "items": event_label_de1144, "labelAlign": "top" }, { "flex": 25, "autoHeight": true, "layout": "form", "xtype": "panel", "items": event_label_nl1145, "hidden": true, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var max_conflicting1151 = new Ext.form.NumberField({ "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Simultaneous events</span>", "name": "max_conflicting", "value": 1, "listeners": { "render": Lino.quicktip_renderer("Simultaneous events","How many conflicting events should be tolerated.") }, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var all_rooms1152 = new Ext.form.Checkbox({ "boxLabel": "Locks all rooms", "autoHeight": true, "hideLabel": true, "checked": false, "name": "all_rooms", "selectOnFocus": true, "anchor": "-20" });
    var locks_user1153 = new Ext.form.Checkbox({ "autoHeight": true, "hideLabel": true, "checked": false, "name": "locks_user", "listeners": { "render": Lino.quicktip_renderer("Locks the user","Whether events of this type make the user unavailable for other locking events at the same time.") }, "boxLabel": "Locks the user", "selectOnFocus": true, "anchor": "-20" });
    var main_3_panel1154 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 180, "hideCheckBoxLabels": true, "items": [ { "flex": 20, "autoHeight": true, "layout": "form", "xtype": "panel", "items": max_conflicting1151, "labelAlign": "top" }, { "flex": 40, "autoHeight": true, "layout": "form", "xtype": "panel", "items": all_rooms1152, "labelAlign": "top" }, { "flex": 40, "autoHeight": true, "layout": "form", "xtype": "panel", "items": locks_user1153, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var id1158 = new Ext.form.NumberField({ "selectOnFocus": true, "autoHeight": true, "fieldLabel": "ID", "anchor": "-20", "name": "id" });
    var invite_client1159 = new Ext.form.Checkbox({ "boxLabel": "Klient einladen", "autoHeight": true, "hideLabel": true, "checked": false, "name": "invite_client", "selectOnFocus": true, "anchor": "-20" });
    var is_appointment1160 = new Ext.form.Checkbox({ "boxLabel": "Event is an appointment", "autoHeight": true, "hideLabel": true, "checked": true, "name": "is_appointment", "selectOnFocus": true, "anchor": "-20" });
    var email_template1161 = new Lino.SimpleRemoteComboFieldElement({ "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">E-Mail-Vorlage</span>", "name": "email_template", "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("E-Mail-Vorlage","The name of the file to be used as template when creating an email from a mailable of this type.") }, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/EventTypes/email_template", "method": "GET" }) }), "anchor": "-20" });
    var attach_to_email1162 = new Ext.form.Checkbox({ "autoHeight": true, "hideLabel": true, "checked": false, "name": "attach_to_email", "listeners": { "render": Lino.quicktip_renderer("als Anhang per E-Mail","Whether the printable file should be attached to the email\nwhen creating an email from a mailable of this type.\n") }, "boxLabel": "als Anhang per E-Mail", "selectOnFocus": true, "anchor": "-20" });
    var main_4_panel1163 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 216, "hideCheckBoxLabels": true, "items": [ { "flex": 11, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id1158, "labelAlign": "top" }, { "flex": 22, "autoHeight": true, "layout": "form", "xtype": "panel", "items": invite_client1159, "labelAlign": "top" }, { "flex": 22, "autoHeight": true, "layout": "form", "xtype": "panel", "items": is_appointment1160, "labelAlign": "top" }, { "flex": 22, "autoHeight": true, "layout": "form", "xtype": "panel", "items": email_template1161, "labelAlign": "top" }, { "flex": 22, "autoHeight": true, "layout": "form", "xtype": "panel", "items": attach_to_email1162, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var EventsByType_grid1195 = new Lino.cal.EventsByType.GridPanel({ "flex": 55, "hide_top_toolbar": true, "containing_panel": this, "params_panel_hidden": true, "tools": [ Lino.show_in_own_window_button(Lino.cal.EventsByType.grid) ], "master_panel": this, "preview_limit": 15 });
    var main_panel1196 = new Ext.Panel({ "autoScroll": false, "border": false, "layout": "vbox", "hideCheckBoxLabels": true, "items": [ main_1_panel1137, main_2_panel1146, main_3_panel1154, main_4_panel1163, EventsByType_grid1195 ], "frame": true, "layoutConfig": { "align": "stretch" }, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel1196;
    this.before_row_edit = function(record) {
      EventsByType_grid1195.on_master_changed();
    }
    Lino.cal.EventTypes.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.households.Households.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 103,
  initComponent : function() {
    var type2223 = new Lino.TwinCombo({ "autoHeight": true, "fieldLabel": "Haushaltsart", "name": "type", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.households.Types.detail,Lino.households.Types.insert)}, "emptyText": "Haushaltsart ausw\u00e4hlen...", "selectOnFocus": true, "hiddenName": "typeHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/households/Households/type", "method": "GET" }) }) });
    var prefix2224 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "prefix", "name": "prefix", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var name2225 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Name", "name": "name", "maxLength": 200, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var id2226 = new Ext.form.NumberField({ "selectOnFocus": true, "autoHeight": true, "fieldLabel": "ID", "anchor": "-20", "name": "id" });
    var general_1_panel2227 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 117, "hideCheckBoxLabels": true, "items": [ { "flex": 29, "autoHeight": true, "layout": "form", "xtype": "panel", "items": type2223, "labelAlign": "top" }, { "flex": 31, "autoHeight": true, "layout": "form", "xtype": "panel", "items": prefix2224, "labelAlign": "top" }, { "flex": 31, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name2225, "labelAlign": "top" }, { "flex": 7, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id2226, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var households_MembersByHousehold_grid2232 = new Lino.households.MembersByHousehold.GridPanel({ "flex": 83, "hide_top_toolbar": true, "containing_panel": this, "tools": [ Lino.show_in_own_window_button(Lino.households.MembersByHousehold.grid) ], "preview_limit": 15, "master_panel": this });
    var general_panel2233 = new Ext.Panel({ "layout": "vbox", "title": "Allgemein", "items": [ general_1_panel2227, households_MembersByHousehold_grid2232 ], "frame": true, "layoutConfig": { "align": "stretch" }, "hideCheckBoxLabels": true, "listeners": { "activate": Lino.on_tab_activate }, "autoScroll": false, "border": false, "bodyBorder": false, "labelAlign": "top" });
    var debts_BudgetsByPartner_grid2234 = new Lino.debts.BudgetsByPartner.GridPanel({ "flex": 5, "hide_top_toolbar": true, "containing_panel": this, "region": "north", "preview_limit": 15, "master_panel": this, "split": true, "tools": [ Lino.show_in_own_window_button(Lino.debts.BudgetsByPartner.grid) ] });
    var debts_ActorsByPartner_grid2235 = new Lino.debts.ActorsByPartner.GridPanel({ "flex": 5, "hide_top_toolbar": true, "containing_panel": this, "region": "center", "preview_limit": 15, "master_panel": this, "split": true, "tools": [ Lino.show_in_own_window_button(Lino.debts.ActorsByPartner.grid) ] });
    var debts_panel2236 = new Lino.VBorderPanel({ "autoScroll": false, "listeners": { "activate": Lino.on_tab_activate }, "border": false, "title": "Schuldnerberatung", "hideCheckBoxLabels": true, "items": [ debts_BudgetsByPartner_grid2234, debts_ActorsByPartner_grid2235 ], "frame": true, "bodyBorder": false, "labelAlign": "top" });
    var main_panel2237 = new Ext.TabPanel({ "hideCheckBoxLabels": true, "border": false, "split": true, "autoScroll": false, "items": [ general_panel2233, debts_panel2236 ], "activeTab": 0, "bodyBorder": false, "frame": true, "labelAlign": "top" });
    this.items = main_panel2237;
    this.before_row_edit = function(record) {
      households_MembersByHousehold_grid2232.on_master_changed();
      debts_BudgetsByPartner_grid2234.on_master_changed();
      debts_ActorsByPartner_grid2235.on_master_changed();
    }
    Lino.households.Households.DetailFormPanel.superclass.initComponent.call(this);
    // active_fields:
  }
});


Lino.contenttypes.ContentTypes.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 5,
  initComponent : function() {
    var id732 = new Ext.form.NumberField({ "selectOnFocus": true, "autoHeight": true, "fieldLabel": "ID", "anchor": "-20", "name": "id" });
    var name733 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "name", "name": "name", "maxLength": 100, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var app_label734 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "app label", "name": "app_label", "maxLength": 100, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var model735 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "python model class name", "name": "model", "maxLength": 100, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var base_classes_disp736 = new Ext.form.DisplayField({ "disabled": true, "autoHeight": true, "fieldLabel": "Base classes", "name": "base_classes", "anchor": "-20", "value": "<br/>", "always_enabled": true });
    var main_1_panel737 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 5, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id732, "labelAlign": "top" }, { "flex": 21, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name733, "labelAlign": "top" }, { "flex": 21, "autoHeight": true, "layout": "form", "xtype": "panel", "items": app_label734, "labelAlign": "top" }, { "flex": 21, "autoHeight": true, "layout": "form", "xtype": "panel", "items": model735, "labelAlign": "top" }, { "flex": 30, "autoHeight": true, "layout": "form", "xtype": "panel", "items": base_classes_disp736, "labelAlign": "top" } ], "region": "north", "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "split": true, "autoScroll": false, "labelWidth": 216, "border": false, "frame": false, "labelAlign": "top" });
    var HelpTextsByModel_grid749 = new Lino.contenttypes.HelpTextsByModel.GridPanel({ "flex": 5, "hide_top_toolbar": true, "containing_panel": this, "region": "center", "preview_limit": 15, "master_panel": this, "split": true, "tools": [ Lino.show_in_own_window_button(Lino.contenttypes.HelpTextsByModel.grid) ] });
    var StaleControllablesByModel_grid753 = new Lino.contenttypes.StaleControllablesByModel.GridPanel({ "flex": 5, "hide_top_toolbar": true, "containing_panel": this, "region": "south", "preview_limit": 15, "master_panel": this, "split": true, "tools": [ Lino.show_in_own_window_button(Lino.contenttypes.StaleControllablesByModel.grid) ] });
    var main_panel754 = new Lino.VBorderPanel({ "autoScroll": false, "border": false, "hideCheckBoxLabels": true, "items": [ main_1_panel737, HelpTextsByModel_grid749, StaleControllablesByModel_grid753 ], "frame": true, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel754;
    this.before_row_edit = function(record) {
      HelpTextsByModel_grid749.on_master_changed();
      StaleControllablesByModel_grid753.on_master_changed();
    }
    Lino.contenttypes.ContentTypes.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.countries.Places.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 10,
  initComponent : function() {
    var name1358 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Bezeichnung", "name": "name", "maxLength": 200, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var name_fr1359 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Bezeichnung (fr)", "name": "name_fr", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var name_de1360 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Bezeichnung (de)", "name": "name_de", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var name_nl1361 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Bezeichnung (nl)", "name": "name_nl", "maxLength": 200, "selectOnFocus": true, "hidden": true, "anchor": "-20" });
    var country1362 = new Lino.TwinCombo({ "autoHeight": true, "fieldLabel": "Land", "allowBlank": false, "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.countries.Countries.detail,Lino.countries.Countries.insert)}, "emptyText": "Land ausw\u00e4hlen...", "selectOnFocus": true, "hiddenName": "countryHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/countries/Places/country", "method": "GET" }) }), "name": "country" });
    var inscode1363 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">INS code</span>", "name": "inscode", "boxMinWidth": Lino.chars2width(5), "listeners": { "render": Lino.quicktip_renderer("INS code","The official code for this place                     used by statbel.fgov.be") }, "maxLength": 5, "selectOnFocus": true, "anchor": "-20" });
    var zip_code1364 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "zip code", "name": "zip_code", "maxLength": 8, "selectOnFocus": true, "boxMinWidth": Lino.chars2width(8), "anchor": "-20" });
    var main_1_panel1365 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 153, "hideCheckBoxLabels": true, "items": [ { "flex": 17, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name1358, "labelAlign": "top" }, { "flex": 17, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_fr1359, "labelAlign": "top" }, { "flex": 17, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_de1360, "labelAlign": "top" }, { "flex": 17, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_nl1361, "hidden": true, "labelAlign": "top" }, { "flex": 16, "autoHeight": true, "layout": "form", "xtype": "panel", "items": country1362, "labelAlign": "top" }, { "flex": 5, "autoHeight": true, "layout": "form", "xtype": "panel", "items": inscode1363, "labelAlign": "top" }, { "flex": 7, "autoHeight": true, "layout": "form", "xtype": "panel", "items": zip_code1364, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var parent1373 = new Lino.TwinCombo({ "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Teil von</span>", "name": "parent", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.countries.Places.detail,Lino.countries.Places.insert)}, "emptyText": "Ort ausw\u00e4hlen...", "listeners": { "render": Lino.quicktip_renderer("Teil von","The superordinate geographic place         of which this place is a part.") }, "selectOnFocus": true, "hiddenName": "parentHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/countries/Places/parent", "method": "GET" }) }) });
    var type1374 = new Lino.RemoteComboFieldElement({ "autoHeight": true, "fieldLabel": "Ortsart", "name": "type", "selectOnFocus": true, "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/countries/Places/type", "method": "GET" }) }), "hiddenName": "typeHidden" });
    var id1375 = new Ext.form.NumberField({ "selectOnFocus": true, "autoHeight": true, "fieldLabel": "ID", "anchor": "-20", "name": "id" });
    var main_2_panel1376 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 81, "hideCheckBoxLabels": true, "items": [ { "flex": 57, "autoHeight": true, "layout": "form", "xtype": "panel", "items": parent1373, "labelAlign": "top" }, { "flex": 28, "autoHeight": true, "layout": "form", "xtype": "panel", "items": type1374, "labelAlign": "top" }, { "flex": 14, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id1375, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var PlacesByPlace_grid1596 = new Lino.countries.PlacesByPlace.GridPanel({ "flex": 41, "hide_top_toolbar": true, "containing_panel": this, "tools": [ Lino.show_in_own_window_button(Lino.countries.PlacesByPlace.grid) ], "preview_limit": 15, "master_panel": this });
    var contacts_PartnersByCity_grid1597 = new Lino.contacts.PartnersByCity.GridPanel({ "flex": 50, "hide_top_toolbar": true, "containing_panel": this, "tools": [ Lino.show_in_own_window_button(Lino.contacts.PartnersByCity.grid) ], "preview_limit": 15, "master_panel": this });
    var cv_StudiesByPlace_grid1598 = new Lino.cv.StudiesByPlace.GridPanel({ "flex": 50, "hide_top_toolbar": true, "containing_panel": this, "tools": [ Lino.show_in_own_window_button(Lino.cv.StudiesByPlace.grid) ], "preview_limit": 15, "master_panel": this });
    var main_4_panel1599 = new Ext.Panel({ "flex": 41, "border": false, "layout": "hbox", "hideCheckBoxLabels": true, "items": [ contacts_PartnersByCity_grid1597, cv_StudiesByPlace_grid1598 ], "autoScroll": false, "layoutConfig": { "align": "stretch" }, "frame": false, "labelAlign": "top" });
    var main_panel1600 = new Ext.Panel({ "autoScroll": false, "border": false, "layout": "vbox", "hideCheckBoxLabels": true, "items": [ main_1_panel1365, main_2_panel1376, PlacesByPlace_grid1596, main_4_panel1599 ], "frame": true, "layoutConfig": { "align": "stretch" }, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel1600;
    this.before_row_edit = function(record) {
      type1374.setContextValue('country', record ? record.data['countryHidden'] : undefined);
      PlacesByPlace_grid1596.on_master_changed();
      contacts_PartnersByCity_grid1597.on_master_changed();
      cv_StudiesByPlace_grid1598.on_master_changed();
    }
    this.onRender = function(ct, position) {
      country1362.on('change',Lino.chooser_handler(type1374,'country'));
      Lino.countries.Places.DetailFormPanel.superclass.onRender.call(this, ct, position);
    }
    Lino.countries.Places.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.pcsw.ClientContactTypes.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 55,
  initComponent : function() {
    var id3792 = new Ext.form.NumberField({ "selectOnFocus": true, "autoHeight": true, "fieldLabel": "ID", "anchor": "-20", "name": "id" });
    var name3793 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Bezeichnung", "name": "name", "maxLength": 200, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var name_fr3794 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Bezeichnung (fr)", "name": "name_fr", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var name_de3795 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Bezeichnung (de)", "name": "name_de", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var name_nl3796 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Bezeichnung (nl)", "name": "name_nl", "maxLength": 200, "selectOnFocus": true, "hidden": true, "anchor": "-20" });
    var main_1_panel3797 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 5, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id3792, "labelAlign": "top" }, { "flex": 23, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name3793, "labelAlign": "top" }, { "flex": 23, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_fr3794, "labelAlign": "top" }, { "flex": 23, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_de3795, "labelAlign": "top" }, { "flex": 23, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_nl3796, "hidden": true, "labelAlign": "top" } ], "region": "north", "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "split": true, "autoScroll": false, "labelWidth": 153, "border": false, "frame": false, "labelAlign": "top" });
    var contacts_PartnersByClientContactType_grid3830 = new Lino.contacts.PartnersByClientContactType.GridPanel({ "flex": 5, "hide_top_toolbar": true, "containing_panel": this, "region": "center", "preview_limit": 15, "master_panel": this, "split": true, "tools": [ Lino.show_in_own_window_button(Lino.contacts.PartnersByClientContactType.grid) ] });
    var pcsw_ClientContactsByType_grid3838 = new Lino.pcsw.ClientContactsByType.GridPanel({ "flex": 5, "hide_top_toolbar": true, "containing_panel": this, "region": "south", "preview_limit": 15, "master_panel": this, "split": true, "tools": [ Lino.show_in_own_window_button(Lino.pcsw.ClientContactsByType.grid) ] });
    var main_panel3839 = new Lino.VBorderPanel({ "autoScroll": false, "border": false, "hideCheckBoxLabels": true, "items": [ main_1_panel3797, contacts_PartnersByClientContactType_grid3830, pcsw_ClientContactsByType_grid3838 ], "frame": true, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel3839;
    this.before_row_edit = function(record) {
      contacts_PartnersByClientContactType_grid3830.on_master_changed();
      pcsw_ClientContactsByType_grid3838.on_master_changed();
    }
    Lino.pcsw.ClientContactTypes.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.changes.Changes.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 8,
  disable_editing: true,
  initComponent : function() {
    var time1305 = new Ext.form.DisplayField({ "autoHeight": true, "fieldLabel": "time", "name": "time", "selectOnFocus": true, "anchor": "-20", "value": "<br>", "allowBlank": false });
    var user1306 = new Lino.TwinCombo({ "preferred_width": 15, "autoHeight": true, "fieldLabel": "Benutzer", "allowBlank": false, "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.users.Users.detail,Lino.users.Users.insert)}, "emptyText": "Benutzer ausw\u00e4hlen...", "selectOnFocus": true, "hiddenName": "userHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/changes/Changes/user", "method": "GET" }) }), "name": "user" });
    var type1307 = new Lino.ChoicesFieldElement({ "autoHeight": true, "forceSelection": true, "fieldLabel": "\u00c4nderungsart", "allowBlank": false, "hiddenName": "typeHidden", "selectOnFocus": true, "anchor": "-20", "store": Lino.lino.ChangeTypes, "name": "type" });
    var master_disp1308 = new Ext.form.DisplayField({ "disabled": true, "autoHeight": true, "fieldLabel": "Stammdaten", "anchor": "-20", "name": "master" });
    var object_disp1309 = new Ext.form.DisplayField({ "disabled": true, "autoHeight": true, "fieldLabel": "Object", "anchor": "-20", "name": "object" });
    var id1310 = new Ext.form.NumberField({ "selectOnFocus": true, "autoHeight": true, "fieldLabel": "ID", "anchor": "-20", "name": "id" });
    var main_1_panel1311 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 117, "hideCheckBoxLabels": true, "items": [ { "flex": 21, "autoHeight": true, "layout": "form", "xtype": "panel", "items": time1305, "labelAlign": "top" }, { "flex": 26, "autoHeight": true, "layout": "form", "xtype": "panel", "items": user1306, "labelAlign": "top" }, { "flex": 19, "autoHeight": true, "layout": "form", "xtype": "panel", "items": type1307, "labelAlign": "top" }, { "flex": 13, "autoHeight": true, "layout": "form", "xtype": "panel", "items": master_disp1308, "labelAlign": "top" }, { "flex": 13, "autoHeight": true, "layout": "form", "xtype": "panel", "items": object_disp1309, "labelAlign": "top" }, { "flex": 6, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id1310, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var diff1318 = new Ext.form.TextArea({ "selectOnFocus": true, "fieldLabel": "\u00c4nderungen", "anchor": "-20 -10", "growMax": 2000, "name": "diff" });
    var main_panel1319 = new Ext.Panel({ "autoScroll": false, "border": false, "layout": "vbox", "labelWidth": 99, "hideCheckBoxLabels": true, "items": [ main_1_panel1311, { "items": diff1318, "labelAlign": "top", "layout": "form", "xtype": "panel", "flex": 83 } ], "frame": true, "layoutConfig": { "align": "stretch" }, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel1319;
    this.before_row_edit = function(record) {
    }
    Lino.changes.Changes.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.cal.Rooms.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 29,
  initComponent : function() {
    var id892 = new Ext.form.NumberField({ "selectOnFocus": true, "autoHeight": true, "fieldLabel": "ID", "anchor": "-20", "name": "id" });
    var name893 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Bezeichnung", "name": "name", "maxLength": 200, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var name_fr894 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Bezeichnung (fr)", "name": "name_fr", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var name_de895 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Bezeichnung (de)", "name": "name_de", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var name_nl896 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Bezeichnung (nl)", "name": "name_nl", "maxLength": 200, "selectOnFocus": true, "hidden": true, "anchor": "-20" });
    var main_1_panel897 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 153, "hideCheckBoxLabels": true, "items": [ { "flex": 5, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id892, "labelAlign": "top" }, { "flex": 23, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name893, "labelAlign": "top" }, { "flex": 23, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_fr894, "labelAlign": "top" }, { "flex": 23, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_de895, "labelAlign": "top" }, { "flex": 23, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_nl896, "hidden": true, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var cal_EventsByRoom_grid1074 = new Lino.cal.EventsByRoom.GridPanel({ "flex": 83, "hide_top_toolbar": true, "containing_panel": this, "params_panel_hidden": true, "tools": [ Lino.show_in_own_window_button(Lino.cal.EventsByRoom.grid) ], "master_panel": this, "preview_limit": 15 });
    var main_panel1075 = new Ext.Panel({ "autoScroll": false, "border": false, "layout": "vbox", "hideCheckBoxLabels": true, "items": [ main_1_panel897, cal_EventsByRoom_grid1074 ], "frame": true, "layoutConfig": { "align": "stretch" }, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel1075;
    this.before_row_edit = function(record) {
      cal_EventsByRoom_grid1074.on_master_changed();
    }
    Lino.cal.Rooms.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.properties.PropTypes.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 13,
  initComponent : function() {
    var id1633 = new Ext.form.NumberField({ "selectOnFocus": true, "autoHeight": true, "fieldLabel": "ID", "anchor": "-20", "name": "id" });
    var name1634 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Bezeichnung", "name": "name", "maxLength": 200, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var name_fr1635 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Bezeichnung (fr)", "name": "name_fr", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var name_de1636 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Bezeichnung (de)", "name": "name_de", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var name_nl1637 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Bezeichnung (nl)", "name": "name_nl", "maxLength": 200, "selectOnFocus": true, "hidden": true, "anchor": "-20" });
    var choicelist1638 = new Lino.ChoicesFieldElement({ "autoHeight": true, "fieldLabel": "Auswahliste", "name": "choicelist", "selectOnFocus": true, "anchor": "-20", "store": [ [ "cal.AccessClasses", "AccessClasses" ], [ "cal.DurationUnits", "DurationUnits" ], [ "cal.EventEvents", "Beobachtungskriterium" ], [ "cal.EventStates", "Termin-Zust\u00e4nde" ], [ "cal.GuestStates", "Gast-Zust\u00e4nde" ], [ "cal.Recurrencies", "Recurrencies" ], [ "cal.TaskStates", "Aufgaben-Zust\u00e4nde" ], [ "cal.Weekdays", "Weekdays" ], [ "countries.PlaceTypes", "PlaceTypes" ], [ "lino.BuildMethods", "BuildMethods" ], [ "lino.ChangeTypes", "\u00c4nderungsarten" ], [ "lino.Genders", "Genders" ], [ "lino.PeriodEvents", "Beobachtungskriterium" ], [ "lino.YesNo", "Ja oder Nein" ], [ "outbox.RecipientTypes", "RecipientTypes" ], [ "properties.DoYouLike", "DoYouLike" ], [ "properties.HowWell", "HowWell" ], [ "users.UserGroups", "Benutzergruppen" ], [ "users.UserLevels", "Benutzer-Levels" ], [ "users.UserProfiles", "Benutzerprofile" ] ], "hiddenName": "choicelistHidden" });
    var default_value1639 = new Lino.RemoteComboFieldElement({ "autoHeight": true, "fieldLabel": "Standardwert", "name": "default_value", "selectOnFocus": true, "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/properties/PropTypes/default_value", "method": "GET" }) }), "hiddenName": "default_valueHidden" });
    var main_1_panel1640 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 4, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id1633, "labelAlign": "top" }, { "flex": 17, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name1634, "labelAlign": "top" }, { "flex": 17, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_fr1635, "labelAlign": "top" }, { "flex": 17, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_de1636, "labelAlign": "top" }, { "flex": 17, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_nl1637, "hidden": true, "labelAlign": "top" }, { "flex": 16, "autoHeight": true, "layout": "form", "xtype": "panel", "items": choicelist1638, "labelAlign": "top" }, { "flex": 8, "autoHeight": true, "layout": "form", "xtype": "panel", "items": default_value1639, "labelAlign": "top" } ], "region": "north", "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "split": true, "autoScroll": false, "labelWidth": 153, "border": false, "frame": false, "labelAlign": "top" });
    var ChoicesByType_grid1655 = new Lino.properties.ChoicesByType.GridPanel({ "flex": 5, "hide_top_toolbar": true, "containing_panel": this, "region": "center", "preview_limit": 15, "master_panel": this, "split": true, "tools": [ Lino.show_in_own_window_button(Lino.properties.ChoicesByType.grid) ] });
    var PropsByType_grid1663 = new Lino.properties.PropsByType.GridPanel({ "flex": 5, "hide_top_toolbar": true, "containing_panel": this, "region": "south", "preview_limit": 15, "master_panel": this, "split": true, "tools": [ Lino.show_in_own_window_button(Lino.properties.PropsByType.grid) ] });
    var main_panel1664 = new Lino.VBorderPanel({ "autoScroll": false, "border": false, "hideCheckBoxLabels": true, "items": [ main_1_panel1640, ChoicesByType_grid1655, PropsByType_grid1663 ], "frame": true, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel1664;
    this.before_row_edit = function(record) {
      default_value1639.setContextValue('choicelist', record ? record.data['choicelistHidden'] : undefined);
      ChoicesByType_grid1655.on_master_changed();
      PropsByType_grid1663.on_master_changed();
    }
    this.onRender = function(ct, position) {
      choicelist1638.on('change',Lino.chooser_handler(default_value1639,'choicelist'));
      Lino.properties.PropTypes.DetailFormPanel.superclass.onRender.call(this, ct, position);
    }
    Lino.properties.PropTypes.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.contacts.Persons.InsertFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  autoHeight: true,
  content_type: 18,
  initComponent : function() {
    var first_name1798 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Vorname</span>", "name": "first_name", "listeners": { "render": Lino.quicktip_renderer("Vorname","First or given name.") }, "maxLength": 200, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var last_name1799 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Familienname</span>", "name": "last_name", "listeners": { "render": Lino.quicktip_renderer("Familienname","Last name (family name).") }, "maxLength": 200, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var main_1_panel1800 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": first_name1798, "labelAlign": "top" }, { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": last_name1799, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 117, "border": false, "anchor": "-20", "labelAlign": "top" });
    var gender1803 = new Lino.ChoicesFieldElement({ "autoHeight": true, "forceSelection": true, "fieldLabel": "Geschlecht", "name": "gender", "hiddenName": "genderHidden", "selectOnFocus": true, "anchor": "-20", "store": [['','<br>']].concat(Lino.lino.Genders) });
    var language1804 = new Lino.ChoicesFieldElement({ "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Sprache</span>", "allowBlank": false, "hiddenName": "languageHidden", "listeners": { "render": Lino.quicktip_renderer("Sprache","Die Sprache, in der Dokumente ausgestellt werden sollen.") }, "selectOnFocus": true, "anchor": "-20", "store": [ [ "en", "Englisch" ], [ "fr", "Franz\u00f6sisch" ], [ "de", "Deutsch" ], [ "nl", "Niederl\u00e4ndisch" ] ], "name": "language" });
    var main_2_panel1805 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 31, "autoHeight": true, "layout": "form", "xtype": "panel", "items": gender1803, "labelAlign": "top" }, { "flex": 68, "autoHeight": true, "layout": "form", "xtype": "panel", "items": language1804, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 99, "border": false, "anchor": "-20", "labelAlign": "top" });
    var main_panel1808 = new Ext.Panel({ "hideCheckBoxLabels": true, "autoHeight": true, "border": false, "layout": "form", "autoScroll": false, "items": [ main_1_panel1800, main_2_panel1805 ], "frame": true, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel1808;
    this.before_row_edit = function(record) {
    }
    Lino.contacts.Persons.InsertFormPanel.superclass.initComponent.call(this);
  }
});


Lino.uploads.UploadsByType.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 24,
  initComponent : function() {
    var file1975 = Lino.file_field_handler(this,{ "autoHeight": true, "fieldLabel": "File", "name": "file", "maxLength": 100, "selectOnFocus": true, "anchor": "-20" });
    var user1976 = new Lino.TwinCombo({ "preferred_width": 15, "autoHeight": true, "fieldLabel": "Autor", "name": "user", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.users.Users.detail,Lino.users.Users.insert)}, "hiddenName": "userHidden", "selectOnFocus": true, "emptyText": "Benutzer ausw\u00e4hlen...", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/uploads/UploadsByType/user", "method": "GET" }) }) });
    var main_1_panel1977 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 51, "autoHeight": true, "layout": "form", "xtype": "panel", "items": file1975, "labelAlign": "top" }, { "flex": 48, "autoHeight": true, "layout": "form", "xtype": "panel", "items": user1976, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 54, "border": false, "anchor": "-20", "labelAlign": "top" });
    var upload_area1980 = new Lino.ChoicesFieldElement({ "autoHeight": true, "forceSelection": true, "fieldLabel": "Upload-Bereich", "allowBlank": false, "hiddenName": "upload_areaHidden", "selectOnFocus": true, "anchor": "-20", "store": Lino.uploads.UploadAreas, "name": "upload_area" });
    var type1981 = new Lino.TwinCombo({ "autoHeight": true, "fieldLabel": "Upload-Art", "name": "type", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.uploads.UploadTypes.detail,Lino.uploads.UploadTypes.insert)}, "emptyText": "Upload-Art ausw\u00e4hlen...", "selectOnFocus": true, "hiddenName": "typeHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/uploads/UploadsByType/type", "method": "GET" }) }) });
    var description1982 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Beschreibung", "name": "description", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var main_2_panel1983 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 19, "autoHeight": true, "layout": "form", "xtype": "panel", "items": upload_area1980, "labelAlign": "top" }, { "flex": 39, "autoHeight": true, "layout": "form", "xtype": "panel", "items": type1981, "labelAlign": "top" }, { "flex": 41, "autoHeight": true, "layout": "form", "xtype": "panel", "items": description1982, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 135, "border": false, "anchor": "-20", "labelAlign": "top" });
    var owner_disp1987 = new Ext.form.DisplayField({ "disabled": true, "autoHeight": true, "fieldLabel": "Verkn\u00fcpft mit", "anchor": "-20", "name": "owner" });
    var main_panel1988 = new Ext.Panel({ "hideCheckBoxLabels": true, "autoHeight": true, "border": false, "layout": "form", "labelWidth": 126, "autoScroll": false, "items": [ main_1_panel1977, main_2_panel1983, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": owner_disp1987, "anchor": "-20", "labelAlign": "top" } ], "frame": true, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel1988;
    this.before_row_edit = function(record) {
      type1981.setContextValue('upload_area', record ? record.data['upload_areaHidden'] : undefined);
    }
    this.onRender = function(ct, position) {
      upload_area1980.on('change',Lino.chooser_handler(type1981,'upload_area'));
      Lino.uploads.UploadsByType.DetailFormPanel.superclass.onRender.call(this, ct, position);
    }
    Lino.uploads.UploadsByType.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.accounts.Groups.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 41,
  initComponent : function() {
    var ref3880 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "ref", "name": "ref", "maxLength": 5, "selectOnFocus": true, "boxMinWidth": Lino.chars2width(5), "anchor": "-20" });
    var name3881 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Bezeichnung", "name": "name", "maxLength": 200, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var name_fr3882 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Bezeichnung (fr)", "name": "name_fr", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var name_de3883 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Bezeichnung (de)", "name": "name_de", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var name_nl3884 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Bezeichnung (nl)", "name": "name_nl", "maxLength": 200, "selectOnFocus": true, "hidden": true, "anchor": "-20" });
    var main_1_panel3885 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 153, "hideCheckBoxLabels": true, "items": [ { "flex": 6, "autoHeight": true, "layout": "form", "xtype": "panel", "items": ref3880, "labelAlign": "top" }, { "flex": 23, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name3881, "labelAlign": "top" }, { "flex": 23, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_fr3882, "labelAlign": "top" }, { "flex": 23, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_de3883, "labelAlign": "top" }, { "flex": 23, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_nl3884, "hidden": true, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var account_type3891 = new Lino.ChoicesFieldElement({ "autoHeight": true, "forceSelection": true, "fieldLabel": "Kontenart", "name": "account_type", "hiddenName": "account_typeHidden", "selectOnFocus": true, "anchor": "-20", "store": [['','<br>']].concat(Lino.accounts.AccountTypes) });
    var id3892 = new Ext.form.NumberField({ "selectOnFocus": true, "autoHeight": true, "fieldLabel": "ID", "anchor": "-20", "name": "id" });
    var main_2_panel3893 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 90, "hideCheckBoxLabels": true, "items": [ { "flex": 76, "autoHeight": true, "layout": "form", "xtype": "panel", "items": account_type3891, "labelAlign": "top" }, { "flex": 23, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id3892, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var AccountsByGroup_grid3967 = new Lino.accounts.AccountsByGroup.GridPanel({ "flex": 71, "hide_top_toolbar": true, "containing_panel": this, "tools": [ Lino.show_in_own_window_button(Lino.accounts.AccountsByGroup.grid) ], "preview_limit": 15, "master_panel": this });
    var main_panel3968 = new Ext.Panel({ "autoScroll": false, "border": false, "layout": "vbox", "hideCheckBoxLabels": true, "items": [ main_1_panel3885, main_2_panel3893, AccountsByGroup_grid3967 ], "frame": true, "layoutConfig": { "align": "stretch" }, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel3968;
    this.before_row_edit = function(record) {
      AccountsByGroup_grid3967.on_master_changed();
    }
    Lino.accounts.Groups.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.properties.PropGroups.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 12,
  initComponent : function() {
    var id1620 = new Ext.form.NumberField({ "selectOnFocus": true, "autoHeight": true, "fieldLabel": "ID", "anchor": "-20", "name": "id" });
    var name1621 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Bezeichnung", "name": "name", "maxLength": 200, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var name_fr1622 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Bezeichnung (fr)", "name": "name_fr", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var name_de1623 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Bezeichnung (de)", "name": "name_de", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var name_nl1624 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Bezeichnung (nl)", "name": "name_nl", "maxLength": 200, "selectOnFocus": true, "hidden": true, "anchor": "-20" });
    var main_1_panel1625 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 153, "hideCheckBoxLabels": true, "items": [ { "flex": 5, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id1620, "labelAlign": "top" }, { "flex": 23, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name1621, "labelAlign": "top" }, { "flex": 23, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_fr1622, "labelAlign": "top" }, { "flex": 23, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_de1623, "labelAlign": "top" }, { "flex": 23, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_nl1624, "hidden": true, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var PropsByGroup_grid1631 = new Lino.properties.PropsByGroup.GridPanel({ "flex": 83, "hide_top_toolbar": true, "containing_panel": this, "tools": [ Lino.show_in_own_window_button(Lino.properties.PropsByGroup.grid) ], "preview_limit": 15, "master_panel": this });
    var main_panel1632 = new Ext.Panel({ "autoScroll": false, "border": false, "layout": "vbox", "hideCheckBoxLabels": true, "items": [ main_1_panel1625, PropsByGroup_grid1631 ], "frame": true, "layoutConfig": { "align": "stretch" }, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel1632;
    this.before_row_edit = function(record) {
      PropsByGroup_grid1631.on_master_changed();
    }
    Lino.properties.PropGroups.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.system.TextFieldTemplates.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 3,
  initComponent : function() {
    var id649 = new Ext.form.NumberField({ "selectOnFocus": true, "autoHeight": true, "fieldLabel": "ID", "anchor": "-20", "name": "id" });
    var name650 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Bezeichnung", "name": "name", "maxLength": 200, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var user651 = new Lino.TwinCombo({ "preferred_width": 15, "autoHeight": true, "fieldLabel": "Autor", "name": "user", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.users.Users.detail,Lino.users.Users.insert)}, "hiddenName": "userHidden", "selectOnFocus": true, "emptyText": "Benutzer ausw\u00e4hlen...", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/system/TextFieldTemplates/user", "method": "GET" }) }) });
    var main_1_panel652 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 10, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id649, "labelAlign": "top" }, { "flex": 45, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name650, "labelAlign": "top" }, { "flex": 43, "autoHeight": true, "layout": "form", "xtype": "panel", "items": user651, "labelAlign": "top" } ], "region": "north", "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "split": true, "autoScroll": false, "labelWidth": 108, "border": false, "frame": false, "labelAlign": "top" });
    var description656 = new Ext.form.TextArea({ "selectOnFocus": true, "fieldLabel": "Beschreibung", "anchor": "-20 -10", "growMax": 2000, "name": "description" });
    var text657 = new Lino.RichTextPanel({ "flex": 5, "split": true, "containing_panel": this, "selectOnFocus": true, "region": "south", "title": "Vorlagentext", "name": "text" });
    var main_panel658 = new Lino.VBorderPanel({ "autoScroll": false, "border": false, "labelWidth": 117, "hideCheckBoxLabels": true, "items": [ main_1_panel652, { "flex": 5, "layout": "form", "xtype": "panel", "items": description656, "region": "center", "labelAlign": "top", "split": true }, text657 ], "frame": true, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel658;
    this.before_row_edit = function(record) {
      text657.refresh();
    }
    Lino.system.TextFieldTemplates.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.excerpts.Excerpts.InsertFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  autoHeight: true,
  content_type: 47,
  initComponent : function() {
    var excerpt_type4087 = new Lino.TwinCombo({ "autoHeight": true, "fieldLabel": "Auszugsart", "allowBlank": false, "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.excerpts.ExcerptTypes.detail,Lino.excerpts.ExcerptTypes.insert)}, "emptyText": "Auszugsart ausw\u00e4hlen...", "selectOnFocus": true, "hiddenName": "excerpt_typeHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/excerpts/Excerpts/excerpt_type", "method": "GET" }) }), "name": "excerpt_type" });
    var project4088 = new Lino.TwinCombo({ "preferred_width": 20, "autoHeight": true, "fieldLabel": "Klient", "name": "project", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.pcsw.Clients.detail,Lino.pcsw.Clients.insert)}, "hiddenName": "projectHidden", "selectOnFocus": true, "emptyText": "Klient ausw\u00e4hlen...", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/excerpts/Excerpts/project", "method": "GET" }) }) });
    var main_1_panel4089 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": excerpt_type4087, "labelAlign": "top" }, { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": project4088, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 99, "border": false, "anchor": "-20", "labelAlign": "top" });
    var company4092 = new Lino.TwinCombo({ "preferred_width": 20, "autoHeight": true, "fieldLabel": "Empf\u00e4nger (Organisation)", "name": "company", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.contacts.Companies.detail,Lino.contacts.Companies.insert)}, "hiddenName": "companyHidden", "selectOnFocus": true, "emptyText": "Organisation ausw\u00e4hlen...", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/excerpts/Excerpts/company", "method": "GET" }) }) });
    var contact_person4093 = new Lino.TwinCombo({ "preferred_width": 20, "autoHeight": true, "fieldLabel": "Empf\u00e4nger (Person)", "name": "contact_person", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.contacts.Persons.detail,Lino.contacts.Persons.insert)}, "hiddenName": "contact_personHidden", "selectOnFocus": true, "emptyText": "Person ausw\u00e4hlen...", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/excerpts/Excerpts/contact_person", "method": "GET" }) }) });
    var main_2_panel4094 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": company4092, "labelAlign": "top" }, { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": contact_person4093, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 225, "border": false, "anchor": "-20", "labelAlign": "top" });
    var main_panel4097 = new Ext.Panel({ "hideCheckBoxLabels": true, "autoHeight": true, "border": false, "layout": "form", "autoScroll": false, "items": [ main_1_panel4089, main_2_panel4094 ], "frame": true, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel4097;
    this.before_row_edit = function(record) {
      excerpt_type4087.setContextValue('owner', record ? record.data['owner'] : undefined);
      contact_person4093.setContextValue('company', record ? record.data['companyHidden'] : undefined);
    }
    this.onRender = function(ct, position) {
      company4092.on('change',Lino.chooser_handler(contact_person4093,'company'));
      Lino.excerpts.Excerpts.InsertFormPanel.superclass.onRender.call(this, ct, position);
    }
    Lino.excerpts.Excerpts.InsertFormPanel.superclass.initComponent.call(this);
  }
});


Lino.accounts.Groups.InsertFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  autoHeight: true,
  content_type: 41,
  initComponent : function() {
    var name3969 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Bezeichnung", "name": "name", "maxLength": 200, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var name_fr3970 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Bezeichnung (fr)", "name": "name_fr", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var name_de3971 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Bezeichnung (de)", "name": "name_de", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var name_nl3972 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Bezeichnung (nl)", "name": "name_nl", "maxLength": 200, "selectOnFocus": true, "hidden": true, "anchor": "-20" });
    var main_1_panel3973 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 25, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name3969, "labelAlign": "top" }, { "flex": 25, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_fr3970, "labelAlign": "top" }, { "flex": 25, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_de3971, "labelAlign": "top" }, { "flex": 25, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_nl3972, "hidden": true, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 153, "border": false, "anchor": "-20", "labelAlign": "top" });
    var account_type3978 = new Lino.ChoicesFieldElement({ "autoHeight": true, "forceSelection": true, "fieldLabel": "Kontenart", "name": "account_type", "hiddenName": "account_typeHidden", "selectOnFocus": true, "anchor": "-20", "store": [['','<br>']].concat(Lino.accounts.AccountTypes) });
    var ref3979 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "ref", "name": "ref", "maxLength": 5, "selectOnFocus": true, "boxMinWidth": Lino.chars2width(5), "anchor": "-20" });
    var main_2_panel3980 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 72, "autoHeight": true, "layout": "form", "xtype": "panel", "items": account_type3978, "labelAlign": "top" }, { "flex": 27, "autoHeight": true, "layout": "form", "xtype": "panel", "items": ref3979, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 90, "border": false, "anchor": "-20", "labelAlign": "top" });
    var main_panel3983 = new Ext.Panel({ "hideCheckBoxLabels": true, "autoHeight": true, "border": false, "layout": "form", "autoScroll": false, "items": [ main_1_panel3973, main_2_panel3980 ], "frame": true, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel3983;
    this.before_row_edit = function(record) {
    }
    Lino.accounts.Groups.InsertFormPanel.superclass.initComponent.call(this);
  }
});


Lino.jobs.Schedules.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 83,
  initComponent : function() {
    var id2988 = new Ext.form.NumberField({ "selectOnFocus": true, "autoHeight": true, "fieldLabel": "ID", "anchor": "-20", "name": "id" });
    var name2989 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Bezeichnung", "name": "name", "maxLength": 200, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var name_fr2990 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Bezeichnung (fr)", "name": "name_fr", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var name_de2991 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Bezeichnung (de)", "name": "name_de", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var name_nl2992 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Bezeichnung (nl)", "name": "name_nl", "maxLength": 200, "selectOnFocus": true, "hidden": true, "anchor": "-20" });
    var main_1_panel2993 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 153, "hideCheckBoxLabels": true, "items": [ { "flex": 5, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id2988, "labelAlign": "top" }, { "flex": 23, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name2989, "labelAlign": "top" }, { "flex": 23, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_fr2990, "labelAlign": "top" }, { "flex": 23, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_de2991, "labelAlign": "top" }, { "flex": 23, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_nl2992, "hidden": true, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var ContractsBySchedule_grid3026 = new Lino.jobs.ContractsBySchedule.GridPanel({ "flex": 83, "hide_top_toolbar": true, "containing_panel": this, "params_panel_hidden": true, "tools": [ Lino.show_in_own_window_button(Lino.jobs.ContractsBySchedule.grid) ], "master_panel": this, "preview_limit": 15 });
    var main_panel3027 = new Ext.Panel({ "autoScroll": false, "border": false, "layout": "vbox", "hideCheckBoxLabels": true, "items": [ main_1_panel2993, ContractsBySchedule_grid3026 ], "frame": true, "layoutConfig": { "align": "stretch" }, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel3027;
    this.before_row_edit = function(record) {
      ContractsBySchedule_grid3026.on_master_changed();
    }
    Lino.jobs.Schedules.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.accounts.Charts.InsertFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  autoHeight: true,
  content_type: 42,
  initComponent : function() {
    var name3986 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Bezeichnung", "name": "name", "maxLength": 200, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var name_fr3987 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Bezeichnung (fr)", "name": "name_fr", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var name_de3988 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Bezeichnung (de)", "name": "name_de", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var name_nl3989 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Bezeichnung (nl)", "name": "name_nl", "maxLength": 200, "selectOnFocus": true, "hidden": true, "anchor": "-20" });
    var main_1_panel3990 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 153, "hideCheckBoxLabels": true, "items": [ { "flex": 25, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name3986, "labelAlign": "top" }, { "flex": 25, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_fr3987, "labelAlign": "top" }, { "flex": 25, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_de3988, "labelAlign": "top" }, { "flex": 25, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_nl3989, "hidden": true, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var main_panel3995 = new Ext.Panel({ "autoScroll": false, "border": false, "layout": "fit", "hideCheckBoxLabels": true, "items": [ main_1_panel3990 ], "frame": true, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel3995;
    this.before_row_edit = function(record) {
    }
    Lino.accounts.Charts.InsertFormPanel.superclass.initComponent.call(this);
  }
});


Lino.uploads.UploadsByType.InsertFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  autoHeight: true,
  content_type: 24,
  initComponent : function() {
    var type1990 = new Lino.TwinCombo({ "autoHeight": true, "fieldLabel": "Upload-Art", "name": "type", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.uploads.UploadTypes.detail,Lino.uploads.UploadTypes.insert)}, "emptyText": "Upload-Art ausw\u00e4hlen...", "selectOnFocus": true, "hiddenName": "typeHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/uploads/UploadsByType/type", "method": "GET" }) }) });
    var description1991 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Beschreibung", "name": "description", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var file1992 = Lino.file_field_handler(this,{ "autoHeight": true, "fieldLabel": "File", "name": "file", "maxLength": 100, "selectOnFocus": true, "anchor": "-20" });
    var user1993 = new Lino.TwinCombo({ "preferred_width": 15, "autoHeight": true, "fieldLabel": "Autor", "name": "user", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.users.Users.detail,Lino.users.Users.insert)}, "hiddenName": "userHidden", "selectOnFocus": true, "emptyText": "Benutzer ausw\u00e4hlen...", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/uploads/UploadsByType/user", "method": "GET" }) }) });
    var main_panel1994 = new Ext.Panel({ "hideCheckBoxLabels": true, "autoHeight": true, "border": false, "layout": "form", "labelWidth": 117, "autoScroll": false, "items": [ { "autoHeight": true, "layout": "form", "xtype": "panel", "items": type1990, "anchor": "-20", "labelAlign": "top" }, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": description1991, "anchor": "-20", "labelAlign": "top" }, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": file1992, "anchor": "-20", "labelAlign": "top" }, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": user1993, "anchor": "-20", "labelAlign": "top" } ], "frame": true, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel1994;
    this.before_row_edit = function(record) {
      type1990.setContextValue('upload_area', record ? record.data['upload_areaHidden'] : undefined);
    }
    Lino.uploads.UploadsByType.InsertFormPanel.superclass.initComponent.call(this);
  }
});


Lino.uploads.UploadTypes.InsertFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  autoHeight: true,
  content_type: 23,
  initComponent : function() {
    var upload_area2001 = new Lino.ChoicesFieldElement({ "autoHeight": true, "forceSelection": true, "fieldLabel": "Upload-Bereich", "allowBlank": false, "hiddenName": "upload_areaHidden", "selectOnFocus": true, "anchor": "-20", "store": Lino.uploads.UploadAreas, "name": "upload_area" });
    var name2002 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Bezeichnung", "name": "name", "maxLength": 200, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var name_fr2003 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Bezeichnung (fr)", "name": "name_fr", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var name_de2004 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Bezeichnung (de)", "name": "name_de", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var name_nl2005 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Bezeichnung (nl)", "name": "name_nl", "maxLength": 200, "selectOnFocus": true, "hidden": true, "anchor": "-20" });
    var main_2_panel2006 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 25, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name2002, "labelAlign": "top" }, { "flex": 25, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_fr2003, "labelAlign": "top" }, { "flex": 25, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_de2004, "labelAlign": "top" }, { "flex": 25, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_nl2005, "hidden": true, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 153, "border": false, "anchor": "-20", "labelAlign": "top" });
    var warn_expiry_value2011 = new Ext.form.NumberField({ "autoHeight": true, "fieldLabel": "Expiry warning (value)", "name": "warn_expiry_value", "selectOnFocus": true, "anchor": "-20", "value": 2, "allowBlank": false });
    var warn_expiry_unit2012 = new Lino.ChoicesFieldElement({ "autoHeight": true, "forceSelection": true, "fieldLabel": "Expiry warning (unit)", "name": "warn_expiry_unit", "hiddenName": "warn_expiry_unitHidden", "selectOnFocus": true, "anchor": "-20", "store": [['','<br>']].concat(Lino.cal.Recurrencies) });
    var main_3_panel2013 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 26, "autoHeight": true, "layout": "form", "xtype": "panel", "items": warn_expiry_value2011, "labelAlign": "top" }, { "flex": 73, "autoHeight": true, "layout": "form", "xtype": "panel", "items": warn_expiry_unit2012, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 207, "border": false, "anchor": "-20", "labelAlign": "top" });
    var main_panel2016 = new Ext.Panel({ "hideCheckBoxLabels": true, "autoHeight": true, "border": false, "layout": "form", "labelWidth": 135, "autoScroll": false, "items": [ { "autoHeight": true, "layout": "form", "xtype": "panel", "items": upload_area2001, "anchor": "-20", "labelAlign": "top" }, main_2_panel2006, main_3_panel2013 ], "frame": true, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel2016;
    this.before_row_edit = function(record) {
    }
    Lino.uploads.UploadTypes.InsertFormPanel.superclass.initComponent.call(this);
  }
});


Lino.addresses.Addresses.InsertFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  autoHeight: true,
  content_type: 22,
  initComponent : function() {
    var country1694 = new Lino.TwinCombo({ "autoHeight": true, "fieldLabel": "Land", "name": "country", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.countries.Countries.detail,Lino.countries.Countries.insert)}, "emptyText": "Land ausw\u00e4hlen...", "selectOnFocus": true, "hiddenName": "countryHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/addresses/Addresses/country", "method": "GET" }) }) });
    var city1695 = new Lino.TwinCombo({ "autoHeight": true, "forceSelection": false, "fieldLabel": "Stadt", "name": "city", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.countries.Places.detail,Lino.countries.Places.insert)}, "emptyText": "Ort ausw\u00e4hlen...", "selectOnFocus": true, "hiddenName": "cityHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/addresses/Addresses/city", "method": "GET" }) }) });
    var main_1_panel1696 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": country1694, "labelAlign": "top" }, { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": city1695, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 54, "border": false, "anchor": "-20", "labelAlign": "top" });
    var street1699 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Stra\u00dfe</span>", "name": "street", "maxLength": 200, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Stra\u00dfe","Name der Stra\u00dfe, ohne Hausnummer") }, "anchor": "-20" });
    var street_no1700 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Nr.</span>", "name": "street_no", "boxMinWidth": Lino.chars2width(10), "listeners": { "render": Lino.quicktip_renderer("Nr.","Hausnummer") }, "maxLength": 10, "selectOnFocus": true, "anchor": "-20" });
    var street_box1701 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Box</span>", "name": "street_box", "boxMinWidth": Lino.chars2width(10), "listeners": { "render": Lino.quicktip_renderer("Box","Text to print after street nuber on the same line.") }, "maxLength": 10, "selectOnFocus": true, "anchor": "-20" });
    var main_2_panel1702 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 48, "autoHeight": true, "layout": "form", "xtype": "panel", "items": street1699, "labelAlign": "top" }, { "flex": 25, "autoHeight": true, "layout": "form", "xtype": "panel", "items": street_no1700, "labelAlign": "top" }, { "flex": 25, "autoHeight": true, "layout": "form", "xtype": "panel", "items": street_box1701, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 63, "border": false, "anchor": "-20", "labelAlign": "top" });
    var address_type1706 = new Lino.ChoicesFieldElement({ "autoHeight": true, "forceSelection": true, "fieldLabel": "Adressenart", "name": "address_type", "hiddenName": "address_typeHidden", "selectOnFocus": true, "anchor": "-20", "store": [['','<br>']].concat(Lino.addresses.AddressTypes) });
    var remark1707 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Bemerkung", "name": "remark", "maxLength": 50, "selectOnFocus": true, "anchor": "-20" });
    var main_3_panel1708 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": address_type1706, "labelAlign": "top" }, { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": remark1707, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 108, "border": false, "anchor": "-20", "labelAlign": "top" });
    var main_panel1711 = new Ext.Panel({ "hideCheckBoxLabels": true, "autoHeight": true, "border": false, "layout": "form", "autoScroll": false, "items": [ main_1_panel1696, main_2_panel1702, main_3_panel1708 ], "frame": true, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel1711;
    this.before_row_edit = function(record) {
      city1695.setContextValue('country', record ? record.data['countryHidden'] : undefined);
      city1695.setContextValue('region', record ? record.data['regionHidden'] : undefined);
    }
    this.onRender = function(ct, position) {
      country1694.on('change',Lino.chooser_handler(city1695,'country'));
      Lino.addresses.Addresses.InsertFormPanel.superclass.onRender.call(this, ct, position);
    }
    Lino.addresses.Addresses.InsertFormPanel.superclass.initComponent.call(this);
  }
});


Lino.accounts.Accounts.InsertFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  autoHeight: true,
  content_type: 40,
  initComponent : function() {
    var ref3950 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "ref", "name": "ref", "maxLength": 5, "selectOnFocus": true, "boxMinWidth": Lino.chars2width(5), "anchor": "-20" });
    var group3951 = new Lino.TwinCombo({ "autoHeight": true, "fieldLabel": "Kontengruppe", "allowBlank": false, "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.accounts.Groups.detail,Lino.accounts.Groups.insert)}, "emptyText": "Kontengruppe ausw\u00e4hlen...", "selectOnFocus": true, "hiddenName": "groupHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/accounts/Accounts/group", "method": "GET" }) }), "name": "group" });
    var type3952 = new Lino.ChoicesFieldElement({ "autoHeight": true, "forceSelection": true, "fieldLabel": "Kontenart", "allowBlank": false, "hiddenName": "typeHidden", "selectOnFocus": true, "anchor": "-20", "store": Lino.accounts.AccountTypes, "name": "type" });
    var main_1_panel3953 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 14, "autoHeight": true, "layout": "form", "xtype": "panel", "items": ref3950, "labelAlign": "top" }, { "flex": 47, "autoHeight": true, "layout": "form", "xtype": "panel", "items": group3951, "labelAlign": "top" }, { "flex": 38, "autoHeight": true, "layout": "form", "xtype": "panel", "items": type3952, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 117, "border": false, "anchor": "-20", "labelAlign": "top" });
    var name3957 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Bezeichnung", "name": "name", "maxLength": 200, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var name_fr3958 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Bezeichnung (fr)", "name": "name_fr", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var name_de3959 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Bezeichnung (de)", "name": "name_de", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var name_nl3960 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Bezeichnung (nl)", "name": "name_nl", "maxLength": 200, "selectOnFocus": true, "hidden": true, "anchor": "-20" });
    var main_2_panel3961 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 25, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name3957, "labelAlign": "top" }, { "flex": 25, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_fr3958, "labelAlign": "top" }, { "flex": 25, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_de3959, "labelAlign": "top" }, { "flex": 25, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_nl3960, "hidden": true, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 153, "border": false, "anchor": "-20", "labelAlign": "top" });
    var main_panel3966 = new Ext.Panel({ "hideCheckBoxLabels": true, "autoHeight": true, "border": false, "layout": "form", "autoScroll": false, "items": [ main_1_panel3953, main_2_panel3961 ], "frame": true, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel3966;
    this.before_row_edit = function(record) {
    }
    Lino.accounts.Accounts.InsertFormPanel.superclass.initComponent.call(this);
  }
});


Lino.accounts.Accounts.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 40,
  initComponent : function() {
    var ref3907 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "ref", "name": "ref", "maxLength": 5, "selectOnFocus": true, "boxMinWidth": Lino.chars2width(5), "anchor": "-20" });
    var name3908 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Bezeichnung", "name": "name", "maxLength": 200, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var name_fr3909 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Bezeichnung (fr)", "name": "name_fr", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var name_de3910 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Bezeichnung (de)", "name": "name_de", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var name_nl3911 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Bezeichnung (nl)", "name": "name_nl", "maxLength": 200, "selectOnFocus": true, "hidden": true, "anchor": "-20" });
    var main_1_panel3912 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 153, "hideCheckBoxLabels": true, "items": [ { "flex": 6, "autoHeight": true, "layout": "form", "xtype": "panel", "items": ref3907, "labelAlign": "top" }, { "flex": 23, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name3908, "labelAlign": "top" }, { "flex": 23, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_fr3909, "labelAlign": "top" }, { "flex": 23, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_de3910, "labelAlign": "top" }, { "flex": 23, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_nl3911, "hidden": true, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var group3918 = new Lino.TwinCombo({ "autoHeight": true, "fieldLabel": "Kontengruppe", "allowBlank": false, "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.accounts.Groups.detail,Lino.accounts.Groups.insert)}, "emptyText": "Kontengruppe ausw\u00e4hlen...", "selectOnFocus": true, "hiddenName": "groupHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/accounts/Accounts/group", "method": "GET" }) }), "name": "group" });
    var type3919 = new Lino.ChoicesFieldElement({ "autoHeight": true, "forceSelection": true, "fieldLabel": "Kontenart", "allowBlank": false, "hiddenName": "typeHidden", "selectOnFocus": true, "anchor": "-20", "store": Lino.accounts.AccountTypes, "name": "type" });
    var main_2_panel3920 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 117, "hideCheckBoxLabels": true, "items": [ { "flex": 55, "autoHeight": true, "layout": "form", "xtype": "panel", "items": group3918, "labelAlign": "top" }, { "flex": 44, "autoHeight": true, "layout": "form", "xtype": "panel", "items": type3919, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var required_for_household3923 = new Ext.form.Checkbox({ "boxLabel": "verpflichtend f\u00fcr Haushalte", "autoHeight": true, "hideLabel": true, "checked": false, "name": "required_for_household", "selectOnFocus": true, "anchor": "-20" });
    var required_for_person3924 = new Ext.form.Checkbox({ "boxLabel": "verpflichtend f\u00fcr Personen", "autoHeight": true, "hideLabel": true, "checked": false, "name": "required_for_person", "selectOnFocus": true, "anchor": "-20" });
    var periods3925 = new Ext.form.NumberField({ "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Perioden</span>", "name": "periods", "allowDecimals": false, "value": 1, "listeners": { "render": Lino.quicktip_renderer("Perioden","For how many months the entered amount counts. \nFor example 1 means a monthly amount, 12 a yearly amount.") }, "selectOnFocus": true, "anchor": "-20", "allowBlank": true });
    var default_amount3926 = new Ext.form.NumberField({ "autoHeight": true, "decimalPrecision": 2, "fieldLabel": "Standard-Betrag", "name": "default_amount", "decimalSeparator": ",", "selectOnFocus": true, "anchor": "-20", "allowBlank": true });
    var main_3_panel3927 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 252, "hideCheckBoxLabels": true, "items": [ { "flex": 27, "autoHeight": true, "layout": "form", "xtype": "panel", "items": required_for_household3923, "labelAlign": "top" }, { "flex": 27, "autoHeight": true, "layout": "form", "xtype": "panel", "items": required_for_person3924, "labelAlign": "top" }, { "flex": 13, "autoHeight": true, "layout": "form", "xtype": "panel", "items": periods3925, "labelAlign": "top" }, { "flex": 32, "autoHeight": true, "layout": "form", "xtype": "panel", "items": default_amount3926, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var debts_EntriesByAccount_grid3948 = new Lino.debts.EntriesByAccount.GridPanel({ "flex": 62, "hide_top_toolbar": true, "containing_panel": this, "tools": [ Lino.show_in_own_window_button(Lino.debts.EntriesByAccount.grid) ], "preview_limit": 15, "master_panel": this });
    var main_panel3949 = new Ext.Panel({ "autoScroll": false, "border": false, "layout": "vbox", "hideCheckBoxLabels": true, "items": [ main_1_panel3912, main_2_panel3920, main_3_panel3927, debts_EntriesByAccount_grid3948 ], "frame": true, "layoutConfig": { "align": "stretch" }, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel3949;
    this.before_row_edit = function(record) {
      debts_EntriesByAccount_grid3948.on_master_changed();
    }
    Lino.accounts.Accounts.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.aids.SimpleConfirmations.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 115,
  initComponent : function() {
    var id4754 = new Ext.form.NumberField({ "selectOnFocus": true, "autoHeight": true, "fieldLabel": "ID", "anchor": "-20", "name": "id" });
    var client4755 = new Lino.TwinCombo({ "preferred_width": 20, "autoHeight": true, "fieldLabel": "Klient", "allowBlank": false, "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.pcsw.Clients.detail,Lino.pcsw.Clients.insert)}, "emptyText": "Klient ausw\u00e4hlen...", "selectOnFocus": true, "hiddenName": "clientHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/aids/SimpleConfirmations/client", "method": "GET" }) }), "name": "client" });
    var user4756 = new Lino.TwinCombo({ "preferred_width": 15, "autoHeight": true, "fieldLabel": "Autor", "name": "user", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.users.Users.detail,Lino.users.Users.insert)}, "hiddenName": "userHidden", "selectOnFocus": true, "emptyText": "Benutzer ausw\u00e4hlen...", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/aids/SimpleConfirmations/user", "method": "GET" }) }) });
    var signer4757 = new Lino.TwinCombo({ "preferred_width": 15, "autoHeight": true, "fieldLabel": "Best\u00e4tiger", "name": "signer", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.users.Users.detail,Lino.users.Users.insert)}, "hiddenName": "signerHidden", "selectOnFocus": true, "emptyText": "Benutzer ausw\u00e4hlen...", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/aids/SimpleConfirmations/signer", "method": "GET" }) }) });
    var workflow_buttons_disp4758 = new Ext.form.DisplayField({ "disabled": true, "autoHeight": true, "fieldLabel": "Arbeitsablauf", "name": "workflow_buttons", "anchor": "-20", "value": "<br/>", "always_enabled": true });
    var main_1_panel4759 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 126, "hideCheckBoxLabels": true, "items": [ { "flex": 5, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id4754, "labelAlign": "top" }, { "flex": 21, "autoHeight": true, "layout": "form", "xtype": "panel", "items": client4755, "labelAlign": "top" }, { "flex": 21, "autoHeight": true, "layout": "form", "xtype": "panel", "items": user4756, "labelAlign": "top" }, { "flex": 21, "autoHeight": true, "layout": "form", "xtype": "panel", "items": signer4757, "labelAlign": "top" }, { "flex": 31, "autoHeight": true, "layout": "form", "xtype": "panel", "items": workflow_buttons_disp4758, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var granting4765 = new Lino.TwinCombo({ "autoHeight": true, "fieldLabel": "Hilfebeschluss", "name": "granting", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.aids.GrantingsByX.detail,Lino.aids.GrantingsByX.insert)}, "emptyText": "Hilfebeschluss ausw\u00e4hlen...", "selectOnFocus": true, "hiddenName": "grantingHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/aids/SimpleConfirmations/granting", "method": "GET" }) }) });
    var start_date4766 = new Lino.DateField({ "selectOnFocus": true, "autoHeight": true, "fieldLabel": "Periode vom", "anchor": "-20", "name": "start_date" });
    var end_date4767 = new Lino.DateField({ "selectOnFocus": true, "autoHeight": true, "fieldLabel": "bis", "anchor": "-20", "name": "end_date" });
    var main_2_panel4768 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 135, "hideCheckBoxLabels": true, "items": [ { "flex": 43, "autoHeight": true, "layout": "form", "xtype": "panel", "items": granting4765, "labelAlign": "top" }, { "flex": 28, "autoHeight": true, "layout": "form", "xtype": "panel", "items": start_date4766, "labelAlign": "top" }, { "flex": 28, "autoHeight": true, "layout": "form", "xtype": "panel", "items": end_date4767, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var company4772 = new Lino.TwinCombo({ "preferred_width": 20, "autoHeight": true, "fieldLabel": "Empf\u00e4nger (Organisation)", "name": "company", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.contacts.Companies.detail,Lino.contacts.Companies.insert)}, "hiddenName": "companyHidden", "selectOnFocus": true, "emptyText": "Organisation ausw\u00e4hlen...", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/aids/SimpleConfirmations/company", "method": "GET" }) }) });
    var contact_person4773 = new Lino.TwinCombo({ "preferred_width": 20, "autoHeight": true, "fieldLabel": "Empf\u00e4nger (Person)", "name": "contact_person", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.contacts.Persons.detail,Lino.contacts.Persons.insert)}, "hiddenName": "contact_personHidden", "selectOnFocus": true, "emptyText": "Person ausw\u00e4hlen...", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/aids/SimpleConfirmations/contact_person", "method": "GET" }) }) });
    var printed_disp4774 = new Ext.form.DisplayField({ "disabled": true, "autoHeight": true, "fieldLabel": "Ausgedruckt", "name": "printed", "anchor": "-20", "value": "<br/>", "always_enabled": true });
    var main_3_panel4775 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 225, "hideCheckBoxLabels": true, "items": [ { "flex": 28, "autoHeight": true, "layout": "form", "xtype": "panel", "items": company4772, "labelAlign": "top" }, { "flex": 28, "autoHeight": true, "layout": "form", "xtype": "panel", "items": contact_person4773, "labelAlign": "top" }, { "flex": 42, "autoHeight": true, "layout": "form", "xtype": "panel", "items": printed_disp4774, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var remark4779 = new Lino.RichTextPanel({ "selectOnFocus": true, "flex": 41, "containing_panel": this, "name": "remark", "title": "Bemerkung" });
    var main_panel4780 = new Ext.Panel({ "autoScroll": false, "border": false, "layout": "vbox", "labelWidth": 0, "hideCheckBoxLabels": true, "items": [ main_1_panel4759, main_2_panel4768, main_3_panel4775, remark4779 ], "frame": true, "layoutConfig": { "align": "stretch" }, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel4780;
    this.before_row_edit = function(record) {
      contact_person4773.setContextValue('company', record ? record.data['companyHidden'] : undefined);
      remark4779.refresh();
    }
    this.onRender = function(ct, position) {
      company4772.on('change',Lino.chooser_handler(contact_person4773,'company'));
      Lino.aids.SimpleConfirmations.DetailFormPanel.superclass.onRender.call(this, ct, position);
    }
    Lino.aids.SimpleConfirmations.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.uploads.UploadsByController.InsertFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  autoHeight: true,
  content_type: 24,
  initComponent : function() {
    var file5063 = Lino.file_field_handler(this,{ "autoHeight": true, "fieldLabel": "File", "name": "file", "maxLength": 100, "selectOnFocus": true, "anchor": "-20" });
    var type5064 = new Lino.TwinCombo({ "autoHeight": true, "fieldLabel": "Upload-Art", "name": "type", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.uploads.UploadTypes.detail,Lino.uploads.UploadTypes.insert)}, "emptyText": "Upload-Art ausw\u00e4hlen...", "selectOnFocus": true, "hiddenName": "typeHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/uploads/UploadsByController/type", "method": "GET" }) }) });
    var description5065 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Beschreibung", "name": "description", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var main_panel5066 = new Ext.Panel({ "hideCheckBoxLabels": true, "autoHeight": true, "border": false, "layout": "form", "labelWidth": 117, "autoScroll": false, "items": [ { "autoHeight": true, "layout": "form", "xtype": "panel", "items": file5063, "anchor": "-20", "labelAlign": "top" }, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": type5064, "anchor": "-20", "labelAlign": "top" }, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": description5065, "anchor": "-20", "labelAlign": "top" } ], "frame": true, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel5066;
    this.before_row_edit = function(record) {
      type5064.setContextValue('upload_area', record ? record.data['upload_areaHidden'] : undefined);
    }
    Lino.uploads.UploadsByController.InsertFormPanel.superclass.initComponent.call(this);
  }
});


Lino.uploads.UploadTypes.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 23,
  initComponent : function() {
    var id1935 = new Ext.form.NumberField({ "selectOnFocus": true, "autoHeight": true, "fieldLabel": "ID", "anchor": "-20", "name": "id" });
    var upload_area1936 = new Lino.ChoicesFieldElement({ "autoHeight": true, "forceSelection": true, "fieldLabel": "Upload-Bereich", "allowBlank": false, "hiddenName": "upload_areaHidden", "selectOnFocus": true, "anchor": "-20", "store": Lino.uploads.UploadAreas, "name": "upload_area" });
    var main_1_panel1937 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 135, "hideCheckBoxLabels": true, "items": [ { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id1935, "labelAlign": "top" }, { "flex": 66, "autoHeight": true, "layout": "form", "xtype": "panel", "items": upload_area1936, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var name1940 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Bezeichnung", "name": "name", "maxLength": 200, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var name_fr1941 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Bezeichnung (fr)", "name": "name_fr", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var name_de1942 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Bezeichnung (de)", "name": "name_de", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var name_nl1943 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Bezeichnung (nl)", "name": "name_nl", "maxLength": 200, "selectOnFocus": true, "hidden": true, "anchor": "-20" });
    var main_2_panel1944 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 153, "hideCheckBoxLabels": true, "items": [ { "flex": 25, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name1940, "labelAlign": "top" }, { "flex": 25, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_fr1941, "labelAlign": "top" }, { "flex": 25, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_de1942, "labelAlign": "top" }, { "flex": 25, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_nl1943, "hidden": true, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var warn_expiry_value1949 = new Ext.form.NumberField({ "autoHeight": true, "fieldLabel": "Expiry warning (value)", "name": "warn_expiry_value", "selectOnFocus": true, "anchor": "-20", "value": 2, "allowBlank": false });
    var warn_expiry_unit1950 = new Lino.ChoicesFieldElement({ "autoHeight": true, "forceSelection": true, "fieldLabel": "Expiry warning (unit)", "name": "warn_expiry_unit", "hiddenName": "warn_expiry_unitHidden", "selectOnFocus": true, "anchor": "-20", "store": [['','<br>']].concat(Lino.cal.Recurrencies) });
    var wanted1951 = new Ext.form.Checkbox({ "autoHeight": true, "hideLabel": true, "checked": false, "name": "wanted", "listeners": { "render": Lino.quicktip_renderer("Wanted","Add a (+) button when there is no upload of this type.") }, "boxLabel": "Wanted", "selectOnFocus": true, "anchor": "-20" });
    var max_number1952 = new Ext.form.NumberField({ "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Max. number</span>", "name": "max_number", "value": -1, "listeners": { "render": Lino.quicktip_renderer("Max. number","No need to upload more uploads than N of this type.\n-1 means no limit.") }, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var main_3_panel1953 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 207, "hideCheckBoxLabels": true, "items": [ { "flex": 14, "autoHeight": true, "layout": "form", "xtype": "panel", "items": warn_expiry_value1949, "labelAlign": "top" }, { "flex": 41, "autoHeight": true, "layout": "form", "xtype": "panel", "items": warn_expiry_unit1950, "labelAlign": "top" }, { "flex": 29, "autoHeight": true, "layout": "form", "xtype": "panel", "items": wanted1951, "labelAlign": "top" }, { "flex": 14, "autoHeight": true, "layout": "form", "xtype": "panel", "items": max_number1952, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var uploads_UploadsByType_grid1999 = new Lino.uploads.UploadsByType.GridPanel({ "flex": 62, "hide_top_toolbar": true, "containing_panel": this, "tools": [ Lino.show_in_own_window_button(Lino.uploads.UploadsByType.grid) ], "preview_limit": 15, "master_panel": this });
    var main_panel2000 = new Ext.Panel({ "autoScroll": false, "border": false, "layout": "vbox", "hideCheckBoxLabels": true, "items": [ main_1_panel1937, main_2_panel1944, main_3_panel1953, uploads_UploadsByType_grid1999 ], "frame": true, "layoutConfig": { "align": "stretch" }, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel2000;
    this.before_row_edit = function(record) {
      uploads_UploadsByType_grid1999.on_master_changed();
    }
    Lino.uploads.UploadTypes.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.uploads.MyUploads.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 24,
  initComponent : function() {
    var file4964 = Lino.file_field_handler(this,{ "autoHeight": true, "fieldLabel": "File", "name": "file", "maxLength": 100, "selectOnFocus": true, "anchor": "-20" });
    var user4965 = new Lino.TwinCombo({ "preferred_width": 15, "autoHeight": true, "fieldLabel": "Autor", "name": "user", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.users.Users.detail,Lino.users.Users.insert)}, "hiddenName": "userHidden", "selectOnFocus": true, "emptyText": "Benutzer ausw\u00e4hlen...", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/uploads/MyUploads/user", "method": "GET" }) }) });
    var main_1_panel4966 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 51, "autoHeight": true, "layout": "form", "xtype": "panel", "items": file4964, "labelAlign": "top" }, { "flex": 48, "autoHeight": true, "layout": "form", "xtype": "panel", "items": user4965, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 54, "border": false, "anchor": "-20", "labelAlign": "top" });
    var upload_area4969 = new Lino.ChoicesFieldElement({ "autoHeight": true, "forceSelection": true, "fieldLabel": "Upload-Bereich", "allowBlank": false, "hiddenName": "upload_areaHidden", "selectOnFocus": true, "anchor": "-20", "store": Lino.uploads.UploadAreas, "name": "upload_area" });
    var type4970 = new Lino.TwinCombo({ "autoHeight": true, "fieldLabel": "Upload-Art", "name": "type", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.uploads.UploadTypes.detail,Lino.uploads.UploadTypes.insert)}, "emptyText": "Upload-Art ausw\u00e4hlen...", "selectOnFocus": true, "hiddenName": "typeHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/uploads/MyUploads/type", "method": "GET" }) }) });
    var description4971 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Beschreibung", "name": "description", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var main_2_panel4972 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 19, "autoHeight": true, "layout": "form", "xtype": "panel", "items": upload_area4969, "labelAlign": "top" }, { "flex": 39, "autoHeight": true, "layout": "form", "xtype": "panel", "items": type4970, "labelAlign": "top" }, { "flex": 41, "autoHeight": true, "layout": "form", "xtype": "panel", "items": description4971, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 135, "border": false, "anchor": "-20", "labelAlign": "top" });
    var owner_disp4976 = new Ext.form.DisplayField({ "disabled": true, "autoHeight": true, "fieldLabel": "Verkn\u00fcpft mit", "anchor": "-20", "name": "owner" });
    var main_panel4977 = new Ext.Panel({ "hideCheckBoxLabels": true, "autoHeight": true, "border": false, "layout": "form", "labelWidth": 126, "autoScroll": false, "items": [ main_1_panel4966, main_2_panel4972, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": owner_disp4976, "anchor": "-20", "labelAlign": "top" } ], "frame": true, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel4977;
    this.before_row_edit = function(record) {
      type4970.setContextValue('upload_area', record ? record.data['upload_areaHidden'] : undefined);
    }
    this.onRender = function(ct, position) {
      upload_area4969.on('change',Lino.chooser_handler(type4970,'upload_area'));
      Lino.uploads.MyUploads.DetailFormPanel.superclass.onRender.call(this, ct, position);
    }
    Lino.uploads.MyUploads.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.courses.Courses.InsertFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  autoHeight: true,
  content_type: 90,
  initComponent : function() {
    var start_date4226 = new Lino.DateField({ "autoHeight": true, "fieldLabel": "Beginndatum", "name": "start_date", "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var offer4227 = new Lino.TwinCombo({ "autoHeight": true, "fieldLabel": "Kursangebot", "allowBlank": false, "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.courses.CourseOffers.detail,Lino.courses.CourseOffers.insert)}, "emptyText": "Kursangebot ausw\u00e4hlen...", "selectOnFocus": true, "hiddenName": "offerHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/courses/Courses/offer", "method": "GET" }) }), "name": "offer" });
    var main_1_panel4228 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 39, "autoHeight": true, "layout": "form", "xtype": "panel", "items": start_date4226, "labelAlign": "top" }, { "flex": 60, "autoHeight": true, "layout": "form", "xtype": "panel", "items": offer4227, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 108, "border": false, "anchor": "-20", "labelAlign": "top" });
    var title4231 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Name", "name": "title", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var main_panel4232 = new Ext.Panel({ "hideCheckBoxLabels": true, "autoHeight": true, "border": false, "layout": "form", "labelWidth": 45, "autoScroll": false, "items": [ main_1_panel4228, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": title4231, "anchor": "-20", "labelAlign": "top" } ], "frame": true, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel4232;
    this.before_row_edit = function(record) {
    }
    Lino.courses.Courses.InsertFormPanel.superclass.initComponent.call(this);
  }
});


Lino.uploads.AreaUploads.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 24,
  initComponent : function() {
    var file1911 = Lino.file_field_handler(this,{ "autoHeight": true, "fieldLabel": "File", "name": "file", "maxLength": 100, "selectOnFocus": true, "anchor": "-20" });
    var user1912 = new Lino.TwinCombo({ "preferred_width": 15, "autoHeight": true, "fieldLabel": "Autor", "name": "user", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.users.Users.detail,Lino.users.Users.insert)}, "hiddenName": "userHidden", "selectOnFocus": true, "emptyText": "Benutzer ausw\u00e4hlen...", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/uploads/AreaUploads/user", "method": "GET" }) }) });
    var main_1_panel1913 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 51, "autoHeight": true, "layout": "form", "xtype": "panel", "items": file1911, "labelAlign": "top" }, { "flex": 48, "autoHeight": true, "layout": "form", "xtype": "panel", "items": user1912, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 54, "border": false, "anchor": "-20", "labelAlign": "top" });
    var upload_area1916 = new Lino.ChoicesFieldElement({ "autoHeight": true, "forceSelection": true, "fieldLabel": "Upload-Bereich", "allowBlank": false, "hiddenName": "upload_areaHidden", "selectOnFocus": true, "anchor": "-20", "store": Lino.uploads.UploadAreas, "name": "upload_area" });
    var type1917 = new Lino.TwinCombo({ "autoHeight": true, "fieldLabel": "Upload-Art", "name": "type", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.uploads.UploadTypes.detail,Lino.uploads.UploadTypes.insert)}, "emptyText": "Upload-Art ausw\u00e4hlen...", "selectOnFocus": true, "hiddenName": "typeHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/uploads/AreaUploads/type", "method": "GET" }) }) });
    var description1918 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Beschreibung", "name": "description", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var main_2_panel1919 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 19, "autoHeight": true, "layout": "form", "xtype": "panel", "items": upload_area1916, "labelAlign": "top" }, { "flex": 39, "autoHeight": true, "layout": "form", "xtype": "panel", "items": type1917, "labelAlign": "top" }, { "flex": 41, "autoHeight": true, "layout": "form", "xtype": "panel", "items": description1918, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 135, "border": false, "anchor": "-20", "labelAlign": "top" });
    var owner_disp1923 = new Ext.form.DisplayField({ "disabled": true, "autoHeight": true, "fieldLabel": "Verkn\u00fcpft mit", "anchor": "-20", "name": "owner" });
    var main_panel1924 = new Ext.Panel({ "hideCheckBoxLabels": true, "autoHeight": true, "border": false, "layout": "form", "labelWidth": 126, "autoScroll": false, "items": [ main_1_panel1913, main_2_panel1919, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": owner_disp1923, "anchor": "-20", "labelAlign": "top" } ], "frame": true, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel1924;
    this.before_row_edit = function(record) {
      type1917.setContextValue('upload_area', record ? record.data['upload_areaHidden'] : undefined);
    }
    this.onRender = function(ct, position) {
      upload_area1916.on('change',Lino.chooser_handler(type1917,'upload_area'));
      Lino.uploads.AreaUploads.DetailFormPanel.superclass.onRender.call(this, ct, position);
    }
    Lino.uploads.AreaUploads.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.uploads.AreaUploads.InsertFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  autoHeight: true,
  content_type: 24,
  initComponent : function() {
    var type1926 = new Lino.TwinCombo({ "autoHeight": true, "fieldLabel": "Upload-Art", "name": "type", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.uploads.UploadTypes.detail,Lino.uploads.UploadTypes.insert)}, "emptyText": "Upload-Art ausw\u00e4hlen...", "selectOnFocus": true, "hiddenName": "typeHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/uploads/AreaUploads/type", "method": "GET" }) }) });
    var description1927 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Beschreibung", "name": "description", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var file1928 = Lino.file_field_handler(this,{ "autoHeight": true, "fieldLabel": "File", "name": "file", "maxLength": 100, "selectOnFocus": true, "anchor": "-20" });
    var user1929 = new Lino.TwinCombo({ "preferred_width": 15, "autoHeight": true, "fieldLabel": "Autor", "name": "user", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.users.Users.detail,Lino.users.Users.insert)}, "hiddenName": "userHidden", "selectOnFocus": true, "emptyText": "Benutzer ausw\u00e4hlen...", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/uploads/AreaUploads/user", "method": "GET" }) }) });
    var main_panel1930 = new Ext.Panel({ "hideCheckBoxLabels": true, "autoHeight": true, "border": false, "layout": "form", "labelWidth": 117, "autoScroll": false, "items": [ { "autoHeight": true, "layout": "form", "xtype": "panel", "items": type1926, "anchor": "-20", "labelAlign": "top" }, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": description1927, "anchor": "-20", "labelAlign": "top" }, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": file1928, "anchor": "-20", "labelAlign": "top" }, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": user1929, "anchor": "-20", "labelAlign": "top" } ], "frame": true, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel1930;
    this.before_row_edit = function(record) {
      type1926.setContextValue('upload_area', record ? record.data['upload_areaHidden'] : undefined);
    }
    Lino.uploads.AreaUploads.InsertFormPanel.superclass.initComponent.call(this);
  }
});


Lino.reception.GoneVisitors.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 33,
  disable_editing: true,
  initComponent : function() {
    var event2094 = new Lino.TwinCombo({ "autoHeight": true, "fieldLabel": "Termin", "allowBlank": false, "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.cal.OneEvent.detail,Lino.cal.OneEvent.insert)}, "emptyText": "Termin ausw\u00e4hlen...", "selectOnFocus": true, "hiddenName": "eventHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/reception/GoneVisitors/event", "method": "GET" }) }), "name": "event" });
    var client2095 = new Lino.TwinCombo({ "preferred_width": 20, "autoHeight": true, "fieldLabel": "Klient", "name": "client", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.pcsw.Clients.detail,Lino.pcsw.Clients.insert)}, "hiddenName": "clientHidden", "disabled": true, "emptyText": "Klient ausw\u00e4hlen...", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({  }) });
    var role2096 = new Lino.TwinCombo({ "autoHeight": true, "fieldLabel": "Rolle", "name": "role", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.cal.GuestRoles.detail,Lino.cal.GuestRoles.insert)}, "emptyText": "Gastrolle ausw\u00e4hlen...", "selectOnFocus": true, "hiddenName": "roleHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/reception/GoneVisitors/role", "method": "GET" }) }) });
    var main_1_panel2097 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": event2094, "labelAlign": "top" }, { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": client2095, "labelAlign": "top" }, { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": role2096, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 63, "border": false, "anchor": "-20", "labelAlign": "top" });
    var state2101 = new Lino.ChoicesFieldElement({ "autoHeight": true, "forceSelection": true, "fieldLabel": "Zustand", "allowBlank": false, "hiddenName": "stateHidden", "selectOnFocus": true, "anchor": "-20", "store": Lino.cal.GuestStates, "name": "state" });
    var remark2102 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Bemerkung", "name": "remark", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var workflow_buttons_disp2103 = new Ext.form.DisplayField({ "disabled": true, "autoHeight": true, "fieldLabel": "Arbeitsablauf", "name": "workflow_buttons", "anchor": "-20", "value": "<br/>", "always_enabled": true });
    var main_2_panel2104 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 17, "autoHeight": true, "layout": "form", "xtype": "panel", "items": state2101, "labelAlign": "top" }, { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": remark2102, "labelAlign": "top" }, { "flex": 48, "autoHeight": true, "layout": "form", "xtype": "panel", "items": workflow_buttons_disp2103, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 126, "border": false, "anchor": "-20", "labelAlign": "top" });
    var main_panel2108 = new Ext.Panel({ "hideCheckBoxLabels": true, "autoHeight": true, "border": false, "layout": "form", "autoScroll": false, "items": [ main_1_panel2097, main_2_panel2104 ], "frame": true, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel2108;
    this.before_row_edit = function(record) {
    }
    Lino.reception.GoneVisitors.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.system.SiteConfigs.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 2,
  initComponent : function() {
    var site_company665 = new Lino.TwinCombo({ "preferred_width": 20, "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Site-Besitzer</span>", "name": "site_company", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.contacts.Companies.detail,Lino.contacts.Companies.insert)}, "hiddenName": "site_companyHidden", "listeners": { "render": Lino.quicktip_renderer("Site-Besitzer","The organisation who runs this site.\n        This is used e.g. as sender in documents.\n        Or, newly created partners inherit the country of the site owner.\n        ") }, "selectOnFocus": true, "emptyText": "Organisation ausw\u00e4hlen...", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/system/SiteConfigs/site_company", "method": "GET" }) }) });
    var next_partner_id666 = new Ext.form.NumberField({ "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">N\u00e4chste Partnernummer</span>", "name": "next_partner_id", "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("N\u00e4chste Partnernummer","N\u00e4chste Partnernummer") }, "value": 100, "anchor": "-20" });
    var general_1_panel667 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 66, "autoHeight": true, "layout": "form", "xtype": "panel", "items": site_company665, "labelAlign": "top" }, { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": next_partner_id666, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 198, "border": false, "anchor": "-20", "labelAlign": "top" });
    var job_office670 = new Lino.TwinCombo({ "preferred_width": 20, "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Lokales Arbeitsamt</span>", "name": "job_office", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.contacts.Companies.detail,Lino.contacts.Companies.insert)}, "hiddenName": "job_officeHidden", "listeners": { "render": Lino.quicktip_renderer("Lokales Arbeitsamt","The Company whose contact persons \n            will be choices for `Person.job_office_contact`.") }, "selectOnFocus": true, "emptyText": "Organisation ausw\u00e4hlen...", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/system/SiteConfigs/job_office", "method": "GET" }) }) });
    var master_budget671 = new Lino.TwinCombo({ "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Budget-Kopiervorlage</span>", "name": "master_budget", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.debts.Budgets.detail,Lino.debts.Budgets.insert)}, "emptyText": "Budget ausw\u00e4hlen...", "listeners": { "render": Lino.quicktip_renderer("Budget-Kopiervorlage","The budget whose content is to be         copied into new budgets.") }, "selectOnFocus": true, "hiddenName": "master_budgetHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/system/SiteConfigs/master_budget", "method": "GET" }) }) });
    var general_2_panel672 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": job_office670, "labelAlign": "top" }, { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": master_budget671, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 189, "border": false, "anchor": "-20", "labelAlign": "top" });
    var signer1675 = new Lino.TwinCombo({ "preferred_width": 20, "autoHeight": true, "fieldLabel": "Sekret\u00e4r", "name": "signer1", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.contacts.Persons.detail,Lino.contacts.Persons.insert)}, "hiddenName": "signer1Hidden", "selectOnFocus": true, "emptyText": "Person ausw\u00e4hlen...", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/system/SiteConfigs/signer1", "method": "GET" }) }) });
    var signer2676 = new Lino.TwinCombo({ "preferred_width": 20, "autoHeight": true, "fieldLabel": "Pr\u00e4sident", "name": "signer2", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.contacts.Persons.detail,Lino.contacts.Persons.insert)}, "hiddenName": "signer2Hidden", "selectOnFocus": true, "emptyText": "Person ausw\u00e4hlen...", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/system/SiteConfigs/signer2", "method": "GET" }) }) });
    var general_3_panel677 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": signer1675, "labelAlign": "top" }, { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": signer2676, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 90, "border": false, "anchor": "-20", "labelAlign": "top" });
    var signer1_function680 = new Lino.RemoteComboFieldElement({ "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Funktion des ersten Unterzeichners</span>", "name": "signer1_function", "pageSize": 20, "emptyText": "Funktion ausw\u00e4hlen...", "listeners": { "render": Lino.quicktip_renderer("Funktion des ersten Unterzeichners","Kontaktfunktion \"Sekret\u00e4r\"") }, "selectOnFocus": true, "hiddenName": "signer1_functionHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/system/SiteConfigs/signer1_function", "method": "GET" }) }) });
    var signer2_function681 = new Lino.RemoteComboFieldElement({ "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Funktion des zweiten Unterzeichners</span>", "name": "signer2_function", "pageSize": 20, "emptyText": "Funktion ausw\u00e4hlen...", "listeners": { "render": Lino.quicktip_renderer("Funktion des zweiten Unterzeichners","Kontaktfunktion \"Pr\u00e4sident\"") }, "selectOnFocus": true, "hiddenName": "signer2_functionHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/system/SiteConfigs/signer2_function", "method": "GET" }) }) });
    var general_4_panel682 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": signer1_function680, "labelAlign": "top" }, { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": signer2_function681, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 324, "border": false, "anchor": "-20", "labelAlign": "top" });
    var general_panel685 = new Ext.Panel({ "autoHeight": true, "layout": "form", "title": "Allgemein", "items": [ general_1_panel667, general_2_panel672, general_3_panel677, general_4_panel682 ], "frame": true, "bodyBorder": false, "hideCheckBoxLabels": true, "listeners": { "activate": Lino.on_tab_activate }, "autoScroll": false, "border": false, "labelAlign": "top" });
    var system_note_type686 = new Lino.TwinCombo({ "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Default system note type</span>", "name": "system_note_type", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.notes.EventTypes.detail,Lino.notes.EventTypes.insert)}, "emptyText": "Event Type ausw\u00e4hlen...", "listeners": { "render": Lino.quicktip_renderer("Default system note type","Note Type used by system notes.\nIf this is empty, then system notes won't create any entry to the Notes table.") }, "selectOnFocus": true, "hiddenName": "system_note_typeHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/system/SiteConfigs/system_note_type", "method": "GET" }) }) });
    var default_build_method687 = new Lino.ChoicesFieldElement({ "autoHeight": true, "forceSelection": true, "fieldLabel": "Standard-Konstruktionsmethode", "name": "default_build_method", "hiddenName": "default_build_methodHidden", "selectOnFocus": true, "anchor": "-20", "store": [['','<br>']].concat(Lino.lino.BuildMethods) });
    var constants_1_panel688 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 48, "autoHeight": true, "layout": "form", "xtype": "panel", "items": system_note_type686, "labelAlign": "top" }, { "flex": 51, "autoHeight": true, "layout": "form", "xtype": "panel", "items": default_build_method687, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 270, "border": false, "anchor": "-20", "labelAlign": "top" });
    var propgroup_skills691 = new Lino.TwinCombo({ "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Eigenschaftsgruppe F\u00e4higkeiten</span>", "name": "propgroup_skills", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.properties.PropGroups.detail,Lino.properties.PropGroups.insert)}, "emptyText": "Eigenschaftsgruppe ausw\u00e4hlen...", "listeners": { "render": Lino.quicktip_renderer("Eigenschaftsgruppe F\u00e4higkeiten","The property group to be used as master for the SkillsByPerson table.") }, "selectOnFocus": true, "hiddenName": "propgroup_skillsHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/system/SiteConfigs/propgroup_skills", "method": "GET" }) }) });
    var propgroup_softskills692 = new Lino.TwinCombo({ "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Eigenschaftsgruppe Sozialkompetenzen</span>", "name": "propgroup_softskills", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.properties.PropGroups.detail,Lino.properties.PropGroups.insert)}, "emptyText": "Eigenschaftsgruppe ausw\u00e4hlen...", "listeners": { "render": Lino.quicktip_renderer("Eigenschaftsgruppe Sozialkompetenzen","The property group to be used as master for the SoftSkillsByPerson table.") }, "selectOnFocus": true, "hiddenName": "propgroup_softskillsHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/system/SiteConfigs/propgroup_softskills", "method": "GET" }) }) });
    var propgroup_obstacles693 = new Lino.TwinCombo({ "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Eigenschaftsgruppe Hindernisse</span>", "name": "propgroup_obstacles", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.properties.PropGroups.detail,Lino.properties.PropGroups.insert)}, "emptyText": "Eigenschaftsgruppe ausw\u00e4hlen...", "listeners": { "render": Lino.quicktip_renderer("Eigenschaftsgruppe Hindernisse","The property group to be used as master for the ObstaclesByPerson table.") }, "selectOnFocus": true, "hiddenName": "propgroup_obstaclesHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/system/SiteConfigs/propgroup_obstacles", "method": "GET" }) }) });
    var constants_2_panel694 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": propgroup_skills691, "labelAlign": "top" }, { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": propgroup_softskills692, "labelAlign": "top" }, { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": propgroup_obstacles693, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 333, "border": false, "anchor": "-20", "labelAlign": "top" });
    var residence_permit_upload_type698 = new Lino.TwinCombo({ "autoHeight": true, "fieldLabel": "Upload-Art Aufenthaltserlaubnis", "name": "residence_permit_upload_type", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.uploads.UploadTypes.detail,Lino.uploads.UploadTypes.insert)}, "emptyText": "Upload-Art ausw\u00e4hlen...", "selectOnFocus": true, "hiddenName": "residence_permit_upload_typeHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/system/SiteConfigs/residence_permit_upload_type", "method": "GET" }) }) });
    var work_permit_upload_type699 = new Lino.TwinCombo({ "autoHeight": true, "fieldLabel": "Upload-Art Arbeitserlaubnis", "name": "work_permit_upload_type", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.uploads.UploadTypes.detail,Lino.uploads.UploadTypes.insert)}, "emptyText": "Upload-Art ausw\u00e4hlen...", "selectOnFocus": true, "hiddenName": "work_permit_upload_typeHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/system/SiteConfigs/work_permit_upload_type", "method": "GET" }) }) });
    var driving_licence_upload_type700 = new Lino.TwinCombo({ "autoHeight": true, "fieldLabel": "Upload-Art F\u00fchrerschein", "name": "driving_licence_upload_type", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.uploads.UploadTypes.detail,Lino.uploads.UploadTypes.insert)}, "emptyText": "Upload-Art ausw\u00e4hlen...", "selectOnFocus": true, "hiddenName": "driving_licence_upload_typeHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/system/SiteConfigs/driving_licence_upload_type", "method": "GET" }) }) });
    var constants_3_panel701 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": residence_permit_upload_type698, "labelAlign": "top" }, { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": work_permit_upload_type699, "labelAlign": "top" }, { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": driving_licence_upload_type700, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 288, "border": false, "anchor": "-20", "labelAlign": "top" });
    var default_event_type705 = new Lino.TwinCombo({ "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Default Event Type</span>", "name": "default_event_type", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.cal.EventTypes.detail,Lino.cal.EventTypes.insert)}, "emptyText": "Ereignisart ausw\u00e4hlen...", "listeners": { "render": Lino.quicktip_renderer("Default Event Type","The default type of events on this site.") }, "selectOnFocus": true, "hiddenName": "default_event_typeHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/system/SiteConfigs/default_event_type", "method": "GET" }) }) });
    var prompt_calendar706 = new Lino.TwinCombo({ "autoHeight": true, "fieldLabel": "Default type for prompt events", "name": "prompt_calendar", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.cal.EventTypes.detail,Lino.cal.EventTypes.insert)}, "emptyText": "Ereignisart ausw\u00e4hlen...", "selectOnFocus": true, "hiddenName": "prompt_calendarHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/system/SiteConfigs/prompt_calendar", "method": "GET" }) }) });
    var constants_4_panel707 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": default_event_type705, "labelAlign": "top" }, { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": prompt_calendar706, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 279, "border": false, "anchor": "-20", "labelAlign": "top" });
    var client_guestrole710 = new Lino.TwinCombo({ "autoHeight": true, "fieldLabel": "Rolle des Klienten in Terminen", "name": "client_guestrole", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.cal.GuestRoles.detail,Lino.cal.GuestRoles.insert)}, "emptyText": "Gastrolle ausw\u00e4hlen...", "selectOnFocus": true, "hiddenName": "client_guestroleHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/system/SiteConfigs/client_guestrole", "method": "GET" }) }) });
    var team_guestrole711 = new Lino.TwinCombo({ "autoHeight": true, "fieldLabel": "Rolle der anderen bei Gruppenterminen", "name": "team_guestrole", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.cal.GuestRoles.detail,Lino.cal.GuestRoles.insert)}, "emptyText": "Gastrolle ausw\u00e4hlen...", "selectOnFocus": true, "hiddenName": "team_guestroleHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/system/SiteConfigs/team_guestrole", "method": "GET" }) }) });
    var constants_5_panel712 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": client_guestrole710, "labelAlign": "top" }, { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": team_guestrole711, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 342, "border": false, "anchor": "-20", "labelAlign": "top" });
    var constants_panel715 = new Ext.Panel({ "autoHeight": true, "layout": "form", "title": "Constants", "items": [ constants_1_panel688, constants_2_panel694, constants_3_panel701, constants_4_panel707, constants_5_panel712 ], "frame": true, "bodyBorder": false, "hideCheckBoxLabels": true, "listeners": { "activate": Lino.on_tab_activate }, "autoScroll": false, "border": false, "labelAlign": "top" });
    var cbss_org_unit716 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Anfragende Organisation</span>", "name": "cbss_org_unit", "maxLength": 50, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Anfragende Organisation","In CBSS requests, identifies the requesting organization.\nFor PCSWs this is the enterprise number \n(CBE, KBO) and should have 10 digits and no formatting characters.\n\nUsed in SSDN requests as text of the `AuthorizedUser\\OrgUnit` element . \nUsed in new style requests as text of the `CustomerIdentification\\cbeNumber` element . \n") }, "anchor": "-20" });
    var sector717 = new Lino.RemoteComboFieldElement({ "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Sektor</span>", "name": "sector", "pageSize": 20, "emptyText": "Sektor ausw\u00e4hlen...", "listeners": { "render": Lino.quicktip_renderer("Sektor","The CBSS sector/subsector of the requesting organization.        \nFor PCSWs this is always 17.1.\nUsed in SSDN requests as text of the `MatrixID` and `MatrixSubID` \nelements of `AuthorizedUser`. \nUsed in ManageAccess requests as default value \nfor the non-editable field `sector` \n(which defines the choices of the `purpose` field).\n") }, "selectOnFocus": true, "hiddenName": "sectorHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/system/SiteConfigs/sector", "method": "GET" }) }) });
    var ssdn_user_id718 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">SSDN User Id</span>", "name": "ssdn_user_id", "maxLength": 50, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("SSDN User Id","Used in SSDN requests as text of the `AuthorizedUser\\UserID` element.\n") }, "anchor": "-20" });
    var ssdn_email719 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">SSDN email address</span>", "name": "ssdn_email", "maxLength": 75, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("SSDN email address","Used in SSDN requests as text of the `AuthorizedUser\\Email` element.\n") }, "anchor": "-20" });
    var cbss_1_panel720 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 25, "autoHeight": true, "layout": "form", "xtype": "panel", "items": cbss_org_unit716, "labelAlign": "top" }, { "flex": 24, "autoHeight": true, "layout": "form", "xtype": "panel", "items": sector717, "labelAlign": "top" }, { "flex": 25, "autoHeight": true, "layout": "form", "xtype": "panel", "items": ssdn_user_id718, "labelAlign": "top" }, { "flex": 25, "autoHeight": true, "layout": "form", "xtype": "panel", "items": ssdn_email719, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 216, "border": false, "anchor": "-20", "labelAlign": "top" });
    var cbss_http_username725 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">HTTP username</span>", "name": "cbss_http_username", "maxLength": 50, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("HTTP username","Used in the http header of new-style requests.\n") }, "anchor": "-20" });
    var cbss_http_password726 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">HTTP password</span>", "name": "cbss_http_password", "maxLength": 50, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("HTTP password","Used in the http header of new-style requests.\n") }, "anchor": "-20" });
    var cbss_2_panel727 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": cbss_http_username725, "labelAlign": "top" }, { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": cbss_http_password726, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 126, "border": false, "anchor": "-20", "labelAlign": "top" });
    var cbss_panel730 = new Ext.Panel({ "autoHeight": true, "layout": "form", "title": "ZDSS", "items": [ cbss_1_panel720, cbss_2_panel727 ], "frame": true, "bodyBorder": false, "hideCheckBoxLabels": true, "listeners": { "activate": Lino.on_tab_activate }, "autoScroll": false, "border": false, "labelAlign": "top" });
    var main_panel731 = new Ext.TabPanel({ "hideCheckBoxLabels": true, "border": false, "split": true, "autoScroll": false, "items": [ general_panel685, constants_panel715, cbss_panel730 ], "activeTab": 0, "bodyBorder": false, "frame": true, "labelAlign": "top" });
    this.items = main_panel731;
    this.before_row_edit = function(record) {
    }
    Lino.system.SiteConfigs.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.uploads.Uploads.InsertFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  autoHeight: true,
  content_type: 24,
  initComponent : function() {
    var type2051 = new Lino.TwinCombo({ "autoHeight": true, "fieldLabel": "Upload-Art", "name": "type", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.uploads.UploadTypes.detail,Lino.uploads.UploadTypes.insert)}, "emptyText": "Upload-Art ausw\u00e4hlen...", "selectOnFocus": true, "hiddenName": "typeHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/uploads/Uploads/type", "method": "GET" }) }) });
    var file2052 = Lino.file_field_handler(this,{ "autoHeight": true, "fieldLabel": "File", "name": "file", "maxLength": 100, "selectOnFocus": true, "anchor": "-20" });
    var main_1_panel2053 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 48, "autoHeight": true, "layout": "form", "xtype": "panel", "items": type2051, "labelAlign": "top" }, { "flex": 51, "autoHeight": true, "layout": "form", "xtype": "panel", "items": file2052, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 99, "border": false, "anchor": "-20", "labelAlign": "top" });
    var valid_from2056 = new Lino.DateField({ "selectOnFocus": true, "autoHeight": true, "fieldLabel": "G\u00fcltig von", "anchor": "-20", "name": "valid_from" });
    var valid_until2057 = new Lino.DateField({ "selectOnFocus": true, "autoHeight": true, "fieldLabel": "G\u00fcltig bis", "anchor": "-20", "name": "valid_until" });
    var main_2_panel2058 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": valid_from2056, "labelAlign": "top" }, { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": valid_until2057, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 99, "border": false, "anchor": "-20", "labelAlign": "top" });
    var description2061 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Beschreibung", "name": "description", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var main_panel2062 = new Ext.Panel({ "hideCheckBoxLabels": true, "autoHeight": true, "border": false, "layout": "form", "labelWidth": 117, "autoScroll": false, "items": [ main_1_panel2053, main_2_panel2058, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": description2061, "anchor": "-20", "labelAlign": "top" } ], "frame": true, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel2062;
    this.before_row_edit = function(record) {
      type2051.setContextValue('upload_area', record ? record.data['upload_areaHidden'] : undefined);
    }
    Lino.uploads.Uploads.InsertFormPanel.superclass.initComponent.call(this);
  }
});


Lino.uploads.UploadsByClient.InsertFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  autoHeight: true,
  content_type: 24,
  initComponent : function() {
    var type4988 = new Lino.TwinCombo({ "autoHeight": true, "fieldLabel": "Upload-Art", "name": "type", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.uploads.UploadTypes.detail,Lino.uploads.UploadTypes.insert)}, "emptyText": "Upload-Art ausw\u00e4hlen...", "selectOnFocus": true, "hiddenName": "typeHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/uploads/UploadsByClient/type", "method": "GET" }) }) });
    var valid_until4989 = new Lino.DateField({ "selectOnFocus": true, "autoHeight": true, "fieldLabel": "G\u00fcltig bis", "anchor": "-20", "name": "valid_until" });
    var main_1_panel4990 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 60, "autoHeight": true, "layout": "form", "xtype": "panel", "items": type4988, "labelAlign": "top" }, { "flex": 39, "autoHeight": true, "layout": "form", "xtype": "panel", "items": valid_until4989, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 99, "border": false, "anchor": "-20", "labelAlign": "top" });
    var file4993 = Lino.file_field_handler(this,{ "autoHeight": true, "fieldLabel": "File", "name": "file", "maxLength": 100, "selectOnFocus": true, "anchor": "-20" });
    var description4994 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Beschreibung", "name": "description", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var main_panel4995 = new Ext.Panel({ "hideCheckBoxLabels": true, "autoHeight": true, "border": false, "layout": "form", "labelWidth": 117, "autoScroll": false, "items": [ main_1_panel4990, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": file4993, "anchor": "-20", "labelAlign": "top" }, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": description4994, "anchor": "-20", "labelAlign": "top" } ], "frame": true, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel4995;
    this.before_row_edit = function(record) {
      type4988.setContextValue('upload_area', record ? record.data['upload_areaHidden'] : undefined);
    }
    Lino.uploads.UploadsByClient.InsertFormPanel.superclass.initComponent.call(this);
  }
});


Lino.cal.EventTypes.InsertFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  autoHeight: true,
  content_type: 31,
  initComponent : function() {
    var name1197 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Bezeichnung", "name": "name", "maxLength": 200, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var name_fr1198 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Bezeichnung (fr)", "name": "name_fr", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var name_de1199 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Bezeichnung (de)", "name": "name_de", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var name_nl1200 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Bezeichnung (nl)", "name": "name_nl", "maxLength": 200, "selectOnFocus": true, "hidden": true, "anchor": "-20" });
    var main_1_panel1201 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 25, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name1197, "labelAlign": "top" }, { "flex": 25, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_fr1198, "labelAlign": "top" }, { "flex": 25, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_de1199, "labelAlign": "top" }, { "flex": 25, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_nl1200, "hidden": true, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 153, "border": false, "anchor": "-20", "labelAlign": "top" });
    var invite_client1206 = new Ext.form.Checkbox({ "boxLabel": "Klient einladen", "autoHeight": true, "hideLabel": true, "checked": false, "name": "invite_client", "selectOnFocus": true, "anchor": "-20" });
    var main_panel1207 = new Ext.Panel({ "hideCheckBoxLabels": true, "autoHeight": true, "border": false, "layout": "form", "labelWidth": 144, "autoScroll": false, "items": [ main_1_panel1201, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": invite_client1206, "anchor": "-20", "labelAlign": "top" } ], "frame": true, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel1207;
    this.before_row_edit = function(record) {
    }
    Lino.cal.EventTypes.InsertFormPanel.superclass.initComponent.call(this);
  }
});


Lino.courses.CourseOffers.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 93,
  initComponent : function() {
    var id4184 = new Ext.form.NumberField({ "selectOnFocus": true, "autoHeight": true, "fieldLabel": "ID", "anchor": "-20", "name": "id" });
    var title4185 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Name", "name": "title", "maxLength": 200, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var content4186 = new Lino.TwinCombo({ "autoHeight": true, "fieldLabel": "Kursinhalt", "allowBlank": false, "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.courses.CourseContents.detail,Lino.courses.CourseContents.insert)}, "emptyText": "Kursinhalt ausw\u00e4hlen...", "selectOnFocus": true, "hiddenName": "contentHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/courses/CourseOffers/content", "method": "GET" }) }), "name": "content" });
    var provider4187 = new Lino.TwinCombo({ "preferred_width": 20, "autoHeight": true, "fieldLabel": "Kursanbieter", "allowBlank": false, "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.courses.CourseProviders.detail,Lino.courses.CourseProviders.insert)}, "emptyText": "Kursanbieter ausw\u00e4hlen...", "selectOnFocus": true, "hiddenName": "providerHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/courses/CourseOffers/provider", "method": "GET" }) }), "name": "provider" });
    var guest_role4188 = new Lino.TwinCombo({ "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Gastrolle</span>", "name": "guest_role", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.cal.GuestRoles.detail,Lino.cal.GuestRoles.insert)}, "emptyText": "Gastrolle ausw\u00e4hlen...", "listeners": { "render": Lino.quicktip_renderer("Gastrolle","Default guest role for particpants of events.") }, "selectOnFocus": true, "hiddenName": "guest_roleHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/courses/CourseOffers/guest_role", "method": "GET" }) }) });
    var main_1_panel4189 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 8, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id4184, "labelAlign": "top" }, { "flex": 23, "autoHeight": true, "layout": "form", "xtype": "panel", "items": title4185, "labelAlign": "top" }, { "flex": 22, "autoHeight": true, "layout": "form", "xtype": "panel", "items": content4186, "labelAlign": "top" }, { "flex": 22, "autoHeight": true, "layout": "form", "xtype": "panel", "items": provider4187, "labelAlign": "top" }, { "flex": 22, "autoHeight": true, "layout": "form", "xtype": "panel", "items": guest_role4188, "labelAlign": "top" } ], "region": "north", "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "split": true, "autoScroll": false, "labelWidth": 117, "border": false, "frame": false, "labelAlign": "top" });
    var description4195 = new Lino.RichTextPanel({ "flex": 5, "split": true, "containing_panel": this, "selectOnFocus": true, "region": "center", "title": "Beschreibung", "name": "description" });
    var CoursesByOffer_grid4234 = new Lino.courses.CoursesByOffer.GridPanel({ "flex": 5, "hide_top_toolbar": true, "containing_panel": this, "region": "south", "preview_limit": 15, "master_panel": this, "split": true, "tools": [ Lino.show_in_own_window_button(Lino.courses.CoursesByOffer.grid) ] });
    var main_panel4235 = new Lino.VBorderPanel({ "autoScroll": false, "border": false, "labelWidth": 0, "hideCheckBoxLabels": true, "items": [ main_1_panel4189, description4195, CoursesByOffer_grid4234 ], "frame": true, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel4235;
    this.before_row_edit = function(record) {
      description4195.refresh();
      CoursesByOffer_grid4234.on_master_changed();
    }
    Lino.courses.CourseOffers.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.reception.MyWaitingVisitors.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 33,
  disable_editing: true,
  initComponent : function() {
    var event2109 = new Lino.TwinCombo({ "autoHeight": true, "fieldLabel": "Termin", "allowBlank": false, "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.cal.OneEvent.detail,Lino.cal.OneEvent.insert)}, "emptyText": "Termin ausw\u00e4hlen...", "selectOnFocus": true, "hiddenName": "eventHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/reception/MyWaitingVisitors/event", "method": "GET" }) }), "name": "event" });
    var client2110 = new Lino.TwinCombo({ "preferred_width": 20, "autoHeight": true, "fieldLabel": "Klient", "name": "client", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.pcsw.Clients.detail,Lino.pcsw.Clients.insert)}, "hiddenName": "clientHidden", "disabled": true, "emptyText": "Klient ausw\u00e4hlen...", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({  }) });
    var role2111 = new Lino.TwinCombo({ "autoHeight": true, "fieldLabel": "Rolle", "name": "role", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.cal.GuestRoles.detail,Lino.cal.GuestRoles.insert)}, "emptyText": "Gastrolle ausw\u00e4hlen...", "selectOnFocus": true, "hiddenName": "roleHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/reception/MyWaitingVisitors/role", "method": "GET" }) }) });
    var main_1_panel2112 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": event2109, "labelAlign": "top" }, { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": client2110, "labelAlign": "top" }, { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": role2111, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 63, "border": false, "anchor": "-20", "labelAlign": "top" });
    var state2116 = new Lino.ChoicesFieldElement({ "autoHeight": true, "forceSelection": true, "fieldLabel": "Zustand", "allowBlank": false, "hiddenName": "stateHidden", "selectOnFocus": true, "anchor": "-20", "store": Lino.cal.GuestStates, "name": "state" });
    var remark2117 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Bemerkung", "name": "remark", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var workflow_buttons_disp2118 = new Ext.form.DisplayField({ "disabled": true, "autoHeight": true, "fieldLabel": "Arbeitsablauf", "name": "workflow_buttons", "anchor": "-20", "value": "<br/>", "always_enabled": true });
    var main_2_panel2119 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 17, "autoHeight": true, "layout": "form", "xtype": "panel", "items": state2116, "labelAlign": "top" }, { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": remark2117, "labelAlign": "top" }, { "flex": 48, "autoHeight": true, "layout": "form", "xtype": "panel", "items": workflow_buttons_disp2118, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 126, "border": false, "anchor": "-20", "labelAlign": "top" });
    var main_panel2123 = new Ext.Panel({ "hideCheckBoxLabels": true, "autoHeight": true, "border": false, "layout": "form", "autoScroll": false, "items": [ main_1_panel2112, main_2_panel2119 ], "frame": true, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel2123;
    this.before_row_edit = function(record) {
    }
    Lino.reception.MyWaitingVisitors.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.households.Types.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 104,
  initComponent : function() {
    var name2124 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Bezeichnung", "name": "name", "maxLength": 200, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var name_fr2125 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Bezeichnung (fr)", "name": "name_fr", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var name_de2126 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Bezeichnung (de)", "name": "name_de", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var name_nl2127 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Bezeichnung (nl)", "name": "name_nl", "maxLength": 200, "selectOnFocus": true, "hidden": true, "anchor": "-20" });
    var main_1_panel2128 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 153, "hideCheckBoxLabels": true, "items": [ { "flex": 25, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name2124, "labelAlign": "top" }, { "flex": 25, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_fr2125, "labelAlign": "top" }, { "flex": 25, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_de2126, "labelAlign": "top" }, { "flex": 25, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_nl2127, "hidden": true, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var HouseholdsByType_grid2221 = new Lino.households.HouseholdsByType.GridPanel({ "flex": 83, "hide_top_toolbar": true, "containing_panel": this, "tools": [ Lino.show_in_own_window_button(Lino.households.HouseholdsByType.grid) ], "preview_limit": 15, "master_panel": this });
    var main_panel2222 = new Ext.Panel({ "autoScroll": false, "border": false, "layout": "vbox", "hideCheckBoxLabels": true, "items": [ main_1_panel2128, HouseholdsByType_grid2221 ], "frame": true, "layoutConfig": { "align": "stretch" }, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel2222;
    this.before_row_edit = function(record) {
      HouseholdsByType_grid2221.on_master_changed();
    }
    Lino.households.Types.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.cv.TrainingTypes.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 67,
  initComponent : function() {
    var name2238 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Bezeichnung", "name": "name", "maxLength": 200, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var name_fr2239 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Bezeichnung (fr)", "name": "name_fr", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var name_de2240 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Bezeichnung (de)", "name": "name_de", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var name_nl2241 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Bezeichnung (nl)", "name": "name_nl", "maxLength": 200, "selectOnFocus": true, "hidden": true, "anchor": "-20" });
    var id2242 = new Ext.form.NumberField({ "selectOnFocus": true, "autoHeight": true, "fieldLabel": "ID", "anchor": "-20", "name": "id" });
    var main_1_panel2243 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 153, "hideCheckBoxLabels": true, "items": [ { "flex": 23, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name2238, "labelAlign": "top" }, { "flex": 23, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_fr2239, "labelAlign": "top" }, { "flex": 23, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_de2240, "labelAlign": "top" }, { "flex": 23, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_nl2241, "hidden": true, "labelAlign": "top" }, { "flex": 5, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id2242, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var cv_TrainingsByType_grid2287 = new Lino.cv.TrainingsByType.GridPanel({ "flex": 83, "hide_top_toolbar": true, "containing_panel": this, "tools": [ Lino.show_in_own_window_button(Lino.cv.TrainingsByType.grid) ], "preview_limit": 15, "master_panel": this });
    var main_panel2288 = new Ext.Panel({ "autoScroll": false, "border": false, "layout": "vbox", "hideCheckBoxLabels": true, "items": [ main_1_panel2243, cv_TrainingsByType_grid2287 ], "frame": true, "layoutConfig": { "align": "stretch" }, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel2288;
    this.before_row_edit = function(record) {
      cv_TrainingsByType_grid2287.on_master_changed();
    }
    Lino.cv.TrainingTypes.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.excerpts.Excerpts.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 47,
  initComponent : function() {
    var id4059 = new Ext.form.NumberField({ "selectOnFocus": true, "autoHeight": true, "fieldLabel": "ID", "anchor": "-20", "name": "id" });
    var excerpt_type4060 = new Lino.TwinCombo({ "autoHeight": true, "fieldLabel": "Auszugsart", "allowBlank": false, "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.excerpts.ExcerptTypes.detail,Lino.excerpts.ExcerptTypes.insert)}, "emptyText": "Auszugsart ausw\u00e4hlen...", "selectOnFocus": true, "hiddenName": "excerpt_typeHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/excerpts/Excerpts/excerpt_type", "method": "GET" }) }), "name": "excerpt_type" });
    var project4061 = new Lino.TwinCombo({ "preferred_width": 20, "autoHeight": true, "fieldLabel": "Klient", "name": "project", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.pcsw.Clients.detail,Lino.pcsw.Clients.insert)}, "hiddenName": "projectHidden", "selectOnFocus": true, "emptyText": "Klient ausw\u00e4hlen...", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/excerpts/Excerpts/project", "method": "GET" }) }) });
    var general_1_panel4062 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 99, "hideCheckBoxLabels": true, "items": [ { "flex": 10, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id4059, "labelAlign": "top" }, { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": excerpt_type4060, "labelAlign": "top" }, { "flex": 40, "autoHeight": true, "layout": "form", "xtype": "panel", "items": project4061, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var user4066 = new Lino.TwinCombo({ "preferred_width": 15, "autoHeight": true, "fieldLabel": "Autor", "name": "user", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.users.Users.detail,Lino.users.Users.insert)}, "hiddenName": "userHidden", "selectOnFocus": true, "emptyText": "Benutzer ausw\u00e4hlen...", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/excerpts/Excerpts/user", "method": "GET" }) }) });
    var build_method4067 = new Lino.ChoicesFieldElement({ "autoHeight": true, "forceSelection": true, "fieldLabel": "Konstruktionsmethode", "allowBlank": false, "hiddenName": "build_methodHidden", "selectOnFocus": true, "anchor": "-20", "store": Lino.lino.BuildMethods, "name": "build_method" });
    var general_2_panel4068 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 189, "hideCheckBoxLabels": true, "items": [ { "flex": 32, "autoHeight": true, "layout": "form", "xtype": "panel", "items": user4066, "labelAlign": "top" }, { "flex": 67, "autoHeight": true, "layout": "form", "xtype": "panel", "items": build_method4067, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var company4071 = new Lino.TwinCombo({ "preferred_width": 20, "autoHeight": true, "fieldLabel": "Empf\u00e4nger (Organisation)", "name": "company", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.contacts.Companies.detail,Lino.contacts.Companies.insert)}, "hiddenName": "companyHidden", "selectOnFocus": true, "emptyText": "Organisation ausw\u00e4hlen...", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/excerpts/Excerpts/company", "method": "GET" }) }) });
    var contact_person4072 = new Lino.TwinCombo({ "preferred_width": 20, "autoHeight": true, "fieldLabel": "Empf\u00e4nger (Person)", "name": "contact_person", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.contacts.Persons.detail,Lino.contacts.Persons.insert)}, "hiddenName": "contact_personHidden", "selectOnFocus": true, "emptyText": "Person ausw\u00e4hlen...", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/excerpts/Excerpts/contact_person", "method": "GET" }) }) });
    var language4073 = new Lino.ChoicesFieldElement({ "autoHeight": true, "fieldLabel": "Sprache", "allowBlank": false, "hiddenName": "languageHidden", "selectOnFocus": true, "anchor": "-20", "store": [ [ "en", "Englisch" ], [ "fr", "Franz\u00f6sisch" ], [ "de", "Deutsch" ], [ "nl", "Niederl\u00e4ndisch" ] ], "name": "language" });
    var general_3_panel4074 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 225, "hideCheckBoxLabels": true, "items": [ { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": company4071, "labelAlign": "top" }, { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": contact_person4072, "labelAlign": "top" }, { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": language4073, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var owner_disp4078 = new Ext.form.DisplayField({ "disabled": true, "autoHeight": true, "fieldLabel": "Verkn\u00fcpft mit", "anchor": "-20", "name": "owner" });
    var build_time4079 = new Ext.form.DisplayField({ "disabled": true, "autoHeight": true, "fieldLabel": "Druckdatum", "name": "build_time", "anchor": "-20", "value": "<br>" });
    var general_4_panel4080 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 126, "hideCheckBoxLabels": true, "items": [ { "flex": 38, "autoHeight": true, "layout": "form", "xtype": "panel", "items": owner_disp4078, "labelAlign": "top" }, { "flex": 61, "autoHeight": true, "layout": "form", "xtype": "panel", "items": build_time4079, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var outbox_MailsByController_grid4083 = new Lino.outbox.MailsByController.GridPanel({ "flex": 55, "hide_top_toolbar": true, "containing_panel": this, "tools": [ Lino.show_in_own_window_button(Lino.outbox.MailsByController.grid) ], "preview_limit": 15, "master_panel": this });
    var general_panel4084 = new Ext.Panel({ "layout": "vbox", "title": "Allgemein", "items": [ general_1_panel4062, general_2_panel4068, general_3_panel4074, general_4_panel4080, outbox_MailsByController_grid4083 ], "frame": true, "layoutConfig": { "align": "stretch" }, "hideCheckBoxLabels": true, "listeners": { "activate": Lino.on_tab_activate }, "autoScroll": false, "border": false, "bodyBorder": false, "labelAlign": "top" });
    var body_template_content4085 = new Ext.form.TextArea({ "listeners": { "activate": Lino.on_tab_activate }, "fieldLabel": "Konfigurierung", "name": "body_template_content", "growMax": 2000, "title": "Konfigurierung", "selectOnFocus": true, "allowBlank": false });
    var main_panel4086 = new Ext.TabPanel({ "hideCheckBoxLabels": true, "border": false, "split": true, "autoScroll": false, "items": [ general_panel4084, body_template_content4085 ], "activeTab": 0, "bodyBorder": false, "frame": true, "labelAlign": "top" });
    this.items = main_panel4086;
    this.before_row_edit = function(record) {
      excerpt_type4060.setContextValue('owner', record ? record.data['owner'] : undefined);
      contact_person4072.setContextValue('company', record ? record.data['companyHidden'] : undefined);
      outbox_MailsByController_grid4083.on_master_changed();
    }
    this.onRender = function(ct, position) {
      owner_disp4078.on('change',Lino.chooser_handler(excerpt_type4060,'owner'));
      company4071.on('change',Lino.chooser_handler(contact_person4072,'company'));
      Lino.excerpts.Excerpts.DetailFormPanel.superclass.onRender.call(this, ct, position);
    }
    Lino.excerpts.Excerpts.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.cv.StudyTypes.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 74,
  initComponent : function() {
    var name2304 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Bezeichnung", "name": "name", "maxLength": 200, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var name_fr2305 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Bezeichnung (fr)", "name": "name_fr", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var name_de2306 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Bezeichnung (de)", "name": "name_de", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var name_nl2307 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Bezeichnung (nl)", "name": "name_nl", "maxLength": 200, "selectOnFocus": true, "hidden": true, "anchor": "-20" });
    var education_level2308 = new Lino.TwinCombo({ "autoHeight": true, "fieldLabel": "Akademischer Grad", "name": "education_level", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.cv.EducationLevels.detail,Lino.cv.EducationLevels.insert)}, "emptyText": "Akademischer Grad ausw\u00e4hlen...", "selectOnFocus": true, "hiddenName": "education_levelHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cv/StudyTypes/education_level", "method": "GET" }) }) });
    var id2309 = new Ext.form.NumberField({ "selectOnFocus": true, "autoHeight": true, "fieldLabel": "ID", "anchor": "-20", "name": "id" });
    var main_1_panel2310 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 19, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name2304, "labelAlign": "top" }, { "flex": 19, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_fr2305, "labelAlign": "top" }, { "flex": 19, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_de2306, "labelAlign": "top" }, { "flex": 19, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_nl2307, "hidden": true, "labelAlign": "top" }, { "flex": 18, "autoHeight": true, "layout": "form", "xtype": "panel", "items": education_level2308, "labelAlign": "top" }, { "flex": 4, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id2309, "labelAlign": "top" } ], "region": "north", "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "split": true, "autoScroll": false, "labelWidth": 162, "border": false, "frame": false, "labelAlign": "top" });
    var isip_ContractsByStudyType_grid2421 = new Lino.isip.ContractsByStudyType.GridPanel({ "flex": 5, "hide_top_toolbar": true, "containing_panel": this, "region": "center", "params_panel_hidden": true, "master_panel": this, "preview_limit": 15, "split": true, "tools": [ Lino.show_in_own_window_button(Lino.isip.ContractsByStudyType.grid) ] });
    var cv_StudiesByType_grid2437 = new Lino.cv.StudiesByType.GridPanel({ "flex": 5, "hide_top_toolbar": true, "containing_panel": this, "region": "south", "preview_limit": 15, "master_panel": this, "split": true, "tools": [ Lino.show_in_own_window_button(Lino.cv.StudiesByType.grid) ] });
    var main_panel2438 = new Lino.VBorderPanel({ "autoScroll": false, "border": false, "hideCheckBoxLabels": true, "items": [ main_1_panel2310, isip_ContractsByStudyType_grid2421, cv_StudiesByType_grid2437 ], "frame": true, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel2438;
    this.before_row_edit = function(record) {
      isip_ContractsByStudyType_grid2421.on_master_changed();
      cv_StudiesByType_grid2437.on_master_changed();
    }
    Lino.cv.StudyTypes.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.cv.Trainings.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 66,
  initComponent : function() {
    var person2263 = new Lino.TwinCombo({ "preferred_width": 20, "autoHeight": true, "fieldLabel": "Klient", "allowBlank": false, "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.pcsw.Clients.detail,Lino.pcsw.Clients.insert)}, "emptyText": "Klient ausw\u00e4hlen...", "selectOnFocus": true, "hiddenName": "personHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cv/Trainings/person", "method": "GET" }) }), "name": "person" });
    var start_date2264 = new Lino.DateField({ "selectOnFocus": true, "autoHeight": true, "fieldLabel": "Beginnt am", "anchor": "-20", "name": "start_date" });
    var end_date2265 = new Lino.DateField({ "selectOnFocus": true, "autoHeight": true, "fieldLabel": "Enddatum", "anchor": "-20", "name": "end_date" });
    var main_1_panel2266 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 99, "hideCheckBoxLabels": true, "items": [ { "flex": 43, "autoHeight": true, "layout": "form", "xtype": "panel", "items": person2263, "labelAlign": "top" }, { "flex": 28, "autoHeight": true, "layout": "form", "xtype": "panel", "items": start_date2264, "labelAlign": "top" }, { "flex": 28, "autoHeight": true, "layout": "form", "xtype": "panel", "items": end_date2265, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var type2270 = new Lino.TwinCombo({ "autoHeight": true, "fieldLabel": "Lehrenart", "allowBlank": false, "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.cv.TrainingTypes.detail,Lino.cv.TrainingTypes.insert)}, "emptyText": "Lehrenart ausw\u00e4hlen...", "selectOnFocus": true, "hiddenName": "typeHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cv/Trainings/type", "method": "GET" }) }), "name": "type" });
    var state2271 = new Lino.ChoicesFieldElement({ "autoHeight": true, "forceSelection": true, "fieldLabel": "Zustand", "name": "state", "hiddenName": "stateHidden", "selectOnFocus": true, "anchor": "-20", "store": [['','<br>']].concat(Lino.cv.SchoolingStates) });
    var certificates2272 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Diplome", "name": "certificates", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var main_2_panel2273 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 90, "hideCheckBoxLabels": true, "items": [ { "flex": 39, "autoHeight": true, "layout": "form", "xtype": "panel", "items": type2270, "labelAlign": "top" }, { "flex": 19, "autoHeight": true, "layout": "form", "xtype": "panel", "items": state2271, "labelAlign": "top" }, { "flex": 41, "autoHeight": true, "layout": "form", "xtype": "panel", "items": certificates2272, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var school2277 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Einrichtung", "name": "school", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var country2278 = new Lino.TwinCombo({ "autoHeight": true, "fieldLabel": "Land", "name": "country", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.countries.Countries.detail,Lino.countries.Countries.insert)}, "emptyText": "Land ausw\u00e4hlen...", "selectOnFocus": true, "hiddenName": "countryHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cv/Trainings/country", "method": "GET" }) }) });
    var city2279 = new Lino.TwinCombo({ "autoHeight": true, "forceSelection": false, "fieldLabel": "Stadt", "name": "city", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.countries.Places.detail,Lino.countries.Places.insert)}, "emptyText": "Ort ausw\u00e4hlen...", "selectOnFocus": true, "hiddenName": "cityHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cv/Trainings/city", "method": "GET" }) }) });
    var main_3_panel2280 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 108, "hideCheckBoxLabels": true, "items": [ { "flex": 34, "autoHeight": true, "layout": "form", "xtype": "panel", "items": school2277, "labelAlign": "top" }, { "flex": 32, "autoHeight": true, "layout": "form", "xtype": "panel", "items": country2278, "labelAlign": "top" }, { "flex": 32, "autoHeight": true, "layout": "form", "xtype": "panel", "items": city2279, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var remarks2284 = new Ext.form.TextArea({ "selectOnFocus": true, "fieldLabel": "Bemerkungen", "anchor": "-20 -10", "growMax": 2000, "name": "remarks" });
    var main_panel2285 = new Ext.Panel({ "autoScroll": false, "border": false, "layout": "vbox", "labelWidth": 108, "hideCheckBoxLabels": true, "items": [ main_1_panel2266, main_2_panel2273, main_3_panel2280, { "items": remarks2284, "labelAlign": "top", "layout": "form", "xtype": "panel", "flex": 62 } ], "frame": true, "layoutConfig": { "align": "stretch" }, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel2285;
    this.before_row_edit = function(record) {
      city2279.setContextValue('country', record ? record.data['countryHidden'] : undefined);
    }
    this.onRender = function(ct, position) {
      country2278.on('change',Lino.chooser_handler(city2279,'country'));
      Lino.cv.Trainings.DetailFormPanel.superclass.onRender.call(this, ct, position);
    }
    Lino.cv.Trainings.DetailFormPanel.superclass.initComponent.call(this);
    // active_fields:
    city2279.on("change", function(){ this.save() }, this);
  }
});


Lino.cv.Sectors.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 65,
  initComponent : function() {
    var id2683 = new Ext.form.NumberField({ "selectOnFocus": true, "autoHeight": true, "fieldLabel": "ID", "anchor": "-20", "name": "id" });
    var name2684 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Bezeichnung", "name": "name", "maxLength": 200, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var name_fr2685 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Bezeichnung (fr)", "name": "name_fr", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var name_de2686 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Bezeichnung (de)", "name": "name_de", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var name_nl2687 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Bezeichnung (nl)", "name": "name_nl", "maxLength": 200, "selectOnFocus": true, "hidden": true, "anchor": "-20" });
    var main_1_panel2688 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 153, "hideCheckBoxLabels": true, "items": [ { "flex": 5, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id2683, "labelAlign": "top" }, { "flex": 23, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name2684, "labelAlign": "top" }, { "flex": 23, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_fr2685, "labelAlign": "top" }, { "flex": 23, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_de2686, "labelAlign": "top" }, { "flex": 23, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_nl2687, "hidden": true, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var remark2694 = new Ext.form.TextArea({ "selectOnFocus": true, "fieldLabel": "Bemerkung", "anchor": "-20 -10", "growMax": 2000, "name": "remark" });
    var FunctionsBySector_grid2746 = new Lino.cv.FunctionsBySector.GridPanel({ "flex": 66, "hide_top_toolbar": true, "containing_panel": this, "tools": [ Lino.show_in_own_window_button(Lino.cv.FunctionsBySector.grid) ], "preview_limit": 15, "master_panel": this });
    var main_2_panel2747 = new Ext.Panel({ "flex": 31, "border": false, "layout": "hbox", "labelWidth": 90, "hideCheckBoxLabels": true, "items": [ { "items": remark2694, "labelAlign": "top", "layout": "form", "xtype": "panel", "flex": 33 }, FunctionsBySector_grid2746 ], "autoScroll": false, "layoutConfig": { "align": "stretch" }, "frame": false, "labelAlign": "top" });
    var cv_ExperiencesBySector_grid2766 = new Lino.cv.ExperiencesBySector.GridPanel({ "flex": 31, "hide_top_toolbar": true, "containing_panel": this, "tools": [ Lino.show_in_own_window_button(Lino.cv.ExperiencesBySector.grid) ], "preview_limit": 15, "master_panel": this });
    var jobs_CandidaturesBySector_grid2775 = new Lino.jobs.CandidaturesBySector.GridPanel({ "flex": 31, "hide_top_toolbar": true, "containing_panel": this, "tools": [ Lino.show_in_own_window_button(Lino.jobs.CandidaturesBySector.grid) ], "preview_limit": 15, "master_panel": this });
    var main_panel2776 = new Ext.Panel({ "autoScroll": false, "border": false, "layout": "vbox", "hideCheckBoxLabels": true, "items": [ main_1_panel2688, main_2_panel2747, cv_ExperiencesBySector_grid2766, jobs_CandidaturesBySector_grid2775 ], "frame": true, "layoutConfig": { "align": "stretch" }, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel2776;
    this.before_row_edit = function(record) {
      FunctionsBySector_grid2746.on_master_changed();
      cv_ExperiencesBySector_grid2766.on_master_changed();
      jobs_CandidaturesBySector_grid2775.on_master_changed();
    }
    Lino.cv.Sectors.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.isip.Contracts.InsertFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  autoHeight: true,
  content_type: 79,
  initComponent : function() {
    var client2416 = new Lino.TwinCombo({ "preferred_width": 20, "autoHeight": true, "fieldLabel": "Klient", "allowBlank": false, "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.pcsw.Clients.detail,Lino.pcsw.Clients.insert)}, "emptyText": "Klient ausw\u00e4hlen...", "selectOnFocus": true, "hiddenName": "clientHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/isip/Contracts/client", "method": "GET" }) }), "name": "client" });
    var type2417 = new Lino.TwinCombo({ "preferred_width": 20, "autoHeight": true, "fieldLabel": "Vertragsart", "name": "type", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.isip.ContractTypes.detail,Lino.isip.ContractTypes.insert)}, "hiddenName": "typeHidden", "selectOnFocus": true, "emptyText": "VSE-Art ausw\u00e4hlen...", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/isip/Contracts/type", "method": "GET" }) }) });
    var main_panel2418 = new Ext.Panel({ "hideCheckBoxLabels": true, "autoHeight": true, "border": false, "layout": "form", "labelWidth": 108, "autoScroll": false, "items": [ { "autoHeight": true, "layout": "form", "xtype": "panel", "items": client2416, "anchor": "-20", "labelAlign": "top" }, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": type2417, "anchor": "-20", "labelAlign": "top" } ], "frame": true, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel2418;
    this.before_row_edit = function(record) {
    }
    Lino.isip.Contracts.InsertFormPanel.superclass.initComponent.call(this);
  }
});


Lino.courses.Courses.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 90,
  initComponent : function() {
    var id4201 = new Ext.form.NumberField({ "selectOnFocus": true, "autoHeight": true, "fieldLabel": "ID", "anchor": "-20", "name": "id" });
    var start_date4202 = new Lino.DateField({ "autoHeight": true, "fieldLabel": "Beginndatum", "name": "start_date", "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var offer4203 = new Lino.TwinCombo({ "autoHeight": true, "fieldLabel": "Kursangebot", "allowBlank": false, "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.courses.CourseOffers.detail,Lino.courses.CourseOffers.insert)}, "emptyText": "Kursangebot ausw\u00e4hlen...", "selectOnFocus": true, "hiddenName": "offerHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/courses/Courses/offer", "method": "GET" }) }), "name": "offer" });
    var title4204 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Name", "name": "title", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var main_1_panel4205 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 108, "hideCheckBoxLabels": true, "items": [ { "flex": 12, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id4201, "labelAlign": "top" }, { "flex": 20, "autoHeight": true, "layout": "form", "xtype": "panel", "items": start_date4202, "labelAlign": "top" }, { "flex": 32, "autoHeight": true, "layout": "form", "xtype": "panel", "items": offer4203, "labelAlign": "top" }, { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": title4204, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var remark4210 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Bemerkung", "name": "remark", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var courses_ParticipantsByCourse_grid4216 = new Lino.courses.ParticipantsByCourse.GridPanel({ "flex": 41, "hide_top_toolbar": true, "containing_panel": this, "tools": [ Lino.show_in_own_window_button(Lino.courses.ParticipantsByCourse.grid) ], "preview_limit": 15, "master_panel": this });
    var courses_CandidatesByCourse_grid4223 = new Lino.courses.CandidatesByCourse.GridPanel({ "flex": 41, "hide_top_toolbar": true, "containing_panel": this, "tools": [ Lino.show_in_own_window_button(Lino.courses.CandidatesByCourse.grid) ], "preview_limit": 15, "master_panel": this });
    var main_panel4224 = new Ext.Panel({ "autoScroll": false, "border": false, "layout": "vbox", "labelWidth": 90, "hideCheckBoxLabels": true, "items": [ main_1_panel4205, { "items": remark4210, "autoHeight": true, "layout": "form", "xtype": "panel", "labelAlign": "top" }, courses_ParticipantsByCourse_grid4216, courses_CandidatesByCourse_grid4223 ], "frame": true, "layoutConfig": { "align": "stretch" }, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel4224;
    this.before_row_edit = function(record) {
      courses_ParticipantsByCourse_grid4216.on_master_changed();
      courses_CandidatesByCourse_grid4223.on_master_changed();
    }
    Lino.courses.Courses.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.cv.EducationLevels.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 70,
  initComponent : function() {
    var name2289 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Bezeichnung", "name": "name", "maxLength": 200, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var name_fr2290 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Bezeichnung (fr)", "name": "name_fr", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var name_de2291 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Bezeichnung (de)", "name": "name_de", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var name_nl2292 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Bezeichnung (nl)", "name": "name_nl", "maxLength": 200, "selectOnFocus": true, "hidden": true, "anchor": "-20" });
    var main_1_panel2293 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 25, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name2289, "labelAlign": "top" }, { "flex": 25, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_fr2290, "labelAlign": "top" }, { "flex": 25, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_de2291, "labelAlign": "top" }, { "flex": 25, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_nl2292, "hidden": true, "labelAlign": "top" } ], "region": "north", "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "split": true, "autoScroll": false, "labelWidth": 153, "border": false, "frame": false, "labelAlign": "top" });
    var StudyTypesByLevel_grid2451 = new Lino.cv.StudyTypesByLevel.GridPanel({ "flex": 5, "hide_top_toolbar": true, "containing_panel": this, "region": "center", "preview_limit": 15, "master_panel": this, "split": true, "tools": [ Lino.show_in_own_window_button(Lino.cv.StudyTypesByLevel.grid) ] });
    var StudiesByLevel_grid2467 = new Lino.cv.StudiesByLevel.GridPanel({ "flex": 5, "hide_top_toolbar": true, "containing_panel": this, "region": "south", "preview_limit": 15, "master_panel": this, "split": true, "tools": [ Lino.show_in_own_window_button(Lino.cv.StudiesByLevel.grid) ] });
    var main_panel2468 = new Lino.VBorderPanel({ "autoScroll": false, "border": false, "hideCheckBoxLabels": true, "items": [ main_1_panel2293, StudyTypesByLevel_grid2451, StudiesByLevel_grid2467 ], "frame": true, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel2468;
    this.before_row_edit = function(record) {
      StudyTypesByLevel_grid2451.on_master_changed();
      StudiesByLevel_grid2467.on_master_changed();
    }
    Lino.cv.EducationLevels.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.aids.Categories.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 112,
  initComponent : function() {
    var id4579 = new Ext.form.NumberField({ "selectOnFocus": true, "autoHeight": true, "fieldLabel": "ID", "anchor": "-20", "name": "id" });
    var name4580 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Bezeichnung", "name": "name", "maxLength": 200, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var name_fr4581 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Bezeichnung (fr)", "name": "name_fr", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var name_de4582 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Bezeichnung (de)", "name": "name_de", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var name_nl4583 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Bezeichnung (nl)", "name": "name_nl", "maxLength": 200, "selectOnFocus": true, "hidden": true, "anchor": "-20" });
    var main_1_panel4584 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 153, "hideCheckBoxLabels": true, "items": [ { "flex": 5, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id4579, "labelAlign": "top" }, { "flex": 23, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name4580, "labelAlign": "top" }, { "flex": 23, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_fr4581, "labelAlign": "top" }, { "flex": 23, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_de4582, "labelAlign": "top" }, { "flex": 23, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_nl4583, "hidden": true, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var aids_IncomeConfirmationsByCategory_grid4650 = new Lino.aids.IncomeConfirmationsByCategory.GridPanel({ "flex": 83, "hide_top_toolbar": true, "containing_panel": this, "tools": [ Lino.show_in_own_window_button(Lino.aids.IncomeConfirmationsByCategory.grid) ], "preview_limit": 15, "master_panel": this });
    var main_panel4651 = new Ext.Panel({ "autoScroll": false, "border": false, "layout": "vbox", "hideCheckBoxLabels": true, "items": [ main_1_panel4584, aids_IncomeConfirmationsByCategory_grid4650 ], "frame": true, "layoutConfig": { "align": "stretch" }, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel4651;
    this.before_row_edit = function(record) {
      aids_IncomeConfirmationsByCategory_grid4650.on_master_changed();
    }
    Lino.aids.Categories.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.courses.CourseOffers.InsertFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  autoHeight: true,
  content_type: 93,
  initComponent : function() {
    var provider4236 = new Lino.TwinCombo({ "preferred_width": 20, "autoHeight": true, "fieldLabel": "Kursanbieter", "allowBlank": false, "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.courses.CourseProviders.detail,Lino.courses.CourseProviders.insert)}, "emptyText": "Kursanbieter ausw\u00e4hlen...", "selectOnFocus": true, "hiddenName": "providerHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/courses/CourseOffers/provider", "method": "GET" }) }), "name": "provider" });
    var content4237 = new Lino.TwinCombo({ "autoHeight": true, "fieldLabel": "Kursinhalt", "allowBlank": false, "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.courses.CourseContents.detail,Lino.courses.CourseContents.insert)}, "emptyText": "Kursinhalt ausw\u00e4hlen...", "selectOnFocus": true, "hiddenName": "contentHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/courses/CourseOffers/content", "method": "GET" }) }), "name": "content" });
    var title4238 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Name", "name": "title", "maxLength": 200, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var main_panel4239 = new Ext.Panel({ "hideCheckBoxLabels": true, "autoHeight": true, "border": false, "layout": "form", "labelWidth": 117, "autoScroll": false, "items": [ { "autoHeight": true, "layout": "form", "xtype": "panel", "items": provider4236, "anchor": "-20", "labelAlign": "top" }, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": content4237, "anchor": "-20", "labelAlign": "top" }, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": title4238, "anchor": "-20", "labelAlign": "top" } ], "frame": true, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel4239;
    this.before_row_edit = function(record) {
    }
    Lino.courses.CourseOffers.InsertFormPanel.superclass.initComponent.call(this);
  }
});


Lino.cv.StudyTypes.InsertFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  autoHeight: true,
  content_type: 74,
  initComponent : function() {
    var name2439 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Bezeichnung", "name": "name", "maxLength": 200, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var name_fr2440 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Bezeichnung (fr)", "name": "name_fr", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var name_de2441 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Bezeichnung (de)", "name": "name_de", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var name_nl2442 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Bezeichnung (nl)", "name": "name_nl", "maxLength": 200, "selectOnFocus": true, "hidden": true, "anchor": "-20" });
    var main_1_panel2443 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 25, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name2439, "labelAlign": "top" }, { "flex": 25, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_fr2440, "labelAlign": "top" }, { "flex": 25, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_de2441, "labelAlign": "top" }, { "flex": 25, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_nl2442, "hidden": true, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 153, "border": false, "anchor": "-20", "labelAlign": "top" });
    var education_level2448 = new Lino.TwinCombo({ "autoHeight": true, "fieldLabel": "Akademischer Grad", "name": "education_level", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.cv.EducationLevels.detail,Lino.cv.EducationLevels.insert)}, "emptyText": "Akademischer Grad ausw\u00e4hlen...", "selectOnFocus": true, "hiddenName": "education_levelHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cv/StudyTypes/education_level", "method": "GET" }) }) });
    var main_panel2449 = new Ext.Panel({ "hideCheckBoxLabels": true, "autoHeight": true, "border": false, "layout": "form", "labelWidth": 162, "autoScroll": false, "items": [ main_1_panel2443, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": education_level2448, "anchor": "-20", "labelAlign": "top" } ], "frame": true, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel2449;
    this.before_row_edit = function(record) {
    }
    Lino.cv.StudyTypes.InsertFormPanel.superclass.initComponent.call(this);
  }
});


Lino.cv.Studies.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 69,
  initComponent : function() {
    var person1567 = new Lino.TwinCombo({ "preferred_width": 20, "autoHeight": true, "fieldLabel": "Klient", "allowBlank": false, "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.pcsw.Clients.detail,Lino.pcsw.Clients.insert)}, "emptyText": "Klient ausw\u00e4hlen...", "selectOnFocus": true, "hiddenName": "personHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cv/Studies/person", "method": "GET" }) }), "name": "person" });
    var start_date1568 = new Lino.DateField({ "selectOnFocus": true, "autoHeight": true, "fieldLabel": "Beginnt am", "anchor": "-20", "name": "start_date" });
    var end_date1569 = new Lino.DateField({ "selectOnFocus": true, "autoHeight": true, "fieldLabel": "Enddatum", "anchor": "-20", "name": "end_date" });
    var main_1_panel1570 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 99, "hideCheckBoxLabels": true, "items": [ { "flex": 43, "autoHeight": true, "layout": "form", "xtype": "panel", "items": person1567, "labelAlign": "top" }, { "flex": 28, "autoHeight": true, "layout": "form", "xtype": "panel", "items": start_date1568, "labelAlign": "top" }, { "flex": 28, "autoHeight": true, "layout": "form", "xtype": "panel", "items": end_date1569, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var type1574 = new Lino.TwinCombo({ "autoHeight": true, "fieldLabel": "Studienart", "allowBlank": false, "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.cv.StudyTypes.detail,Lino.cv.StudyTypes.insert)}, "emptyText": "Studienart ausw\u00e4hlen...", "selectOnFocus": true, "hiddenName": "typeHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cv/Studies/type", "method": "GET" }) }), "name": "type" });
    var content1575 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Ausbildungsinhalt", "name": "content", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var education_level1576 = new Lino.TwinCombo({ "autoHeight": true, "fieldLabel": "Akademischer Grad", "name": "education_level", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.cv.EducationLevels.detail,Lino.cv.EducationLevels.insert)}, "emptyText": "Akademischer Grad ausw\u00e4hlen...", "selectOnFocus": true, "hiddenName": "education_levelHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cv/Studies/education_level", "method": "GET" }) }) });
    var state1577 = new Lino.ChoicesFieldElement({ "autoHeight": true, "forceSelection": true, "fieldLabel": "Zustand", "name": "state", "hiddenName": "stateHidden", "selectOnFocus": true, "anchor": "-20", "store": [['','<br>']].concat(Lino.cv.SchoolingStates) });
    var main_2_panel1578 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 162, "hideCheckBoxLabels": true, "items": [ { "flex": 28, "autoHeight": true, "layout": "form", "xtype": "panel", "items": type1574, "labelAlign": "top" }, { "flex": 29, "autoHeight": true, "layout": "form", "xtype": "panel", "items": content1575, "labelAlign": "top" }, { "flex": 28, "autoHeight": true, "layout": "form", "xtype": "panel", "items": education_level1576, "labelAlign": "top" }, { "flex": 14, "autoHeight": true, "layout": "form", "xtype": "panel", "items": state1577, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var school1583 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Einrichtung", "name": "school", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var country1584 = new Lino.TwinCombo({ "autoHeight": true, "fieldLabel": "Land", "name": "country", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.countries.Countries.detail,Lino.countries.Countries.insert)}, "emptyText": "Land ausw\u00e4hlen...", "selectOnFocus": true, "hiddenName": "countryHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cv/Studies/country", "method": "GET" }) }) });
    var city1585 = new Lino.TwinCombo({ "autoHeight": true, "forceSelection": false, "fieldLabel": "Stadt", "name": "city", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.countries.Places.detail,Lino.countries.Places.insert)}, "emptyText": "Ort ausw\u00e4hlen...", "selectOnFocus": true, "hiddenName": "cityHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cv/Studies/city", "method": "GET" }) }) });
    var main_3_panel1586 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 108, "hideCheckBoxLabels": true, "items": [ { "flex": 34, "autoHeight": true, "layout": "form", "xtype": "panel", "items": school1583, "labelAlign": "top" }, { "flex": 32, "autoHeight": true, "layout": "form", "xtype": "panel", "items": country1584, "labelAlign": "top" }, { "flex": 32, "autoHeight": true, "layout": "form", "xtype": "panel", "items": city1585, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var remarks1590 = new Ext.form.TextArea({ "selectOnFocus": true, "fieldLabel": "Bemerkungen", "anchor": "-20 -10", "growMax": 2000, "name": "remarks" });
    var main_panel1591 = new Ext.Panel({ "autoScroll": false, "border": false, "layout": "vbox", "labelWidth": 108, "hideCheckBoxLabels": true, "items": [ main_1_panel1570, main_2_panel1578, main_3_panel1586, { "items": remarks1590, "labelAlign": "top", "layout": "form", "xtype": "panel", "flex": 62 } ], "frame": true, "layoutConfig": { "align": "stretch" }, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel1591;
    this.before_row_edit = function(record) {
      city1585.setContextValue('country', record ? record.data['countryHidden'] : undefined);
    }
    this.onRender = function(ct, position) {
      country1584.on('change',Lino.chooser_handler(city1585,'country'));
      Lino.cv.Studies.DetailFormPanel.superclass.onRender.call(this, ct, position);
    }
    Lino.cv.Studies.DetailFormPanel.superclass.initComponent.call(this);
    // active_fields:
    city1585.on("change", function(){ this.save() }, this);
  }
});


Lino.contacts.Persons.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 18,
  initComponent : function() {
    var overview_disp1712 = new Ext.form.DisplayField({ "disabled": true, "flex": 28, "name": "overview", "value": "<br/>", "always_enabled": true });
    var title1713 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Anrede</span>", "name": "title", "maxLength": 200, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Anrede","Text to print before allocation and name as part of the first address line.") }, "anchor": "-20" });
    var first_name1714 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Vorname</span>", "name": "first_name", "listeners": { "render": Lino.quicktip_renderer("Vorname","First or given name.") }, "maxLength": 200, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var middle_name1715 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Zwischenname</span>", "name": "middle_name", "maxLength": 200, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Zwischenname","Space-separated list of all middle names.") }, "anchor": "-20" });
    var general2_1_panel1716 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 41, "autoHeight": true, "layout": "form", "xtype": "panel", "items": title1713, "labelAlign": "top" }, { "flex": 29, "autoHeight": true, "layout": "form", "xtype": "panel", "items": first_name1714, "labelAlign": "top" }, { "flex": 29, "autoHeight": true, "layout": "form", "xtype": "panel", "items": middle_name1715, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 117, "border": false, "anchor": "-20", "labelAlign": "top" });
    var last_name1720 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Familienname</span>", "name": "last_name", "listeners": { "render": Lino.quicktip_renderer("Familienname","Last name (family name).") }, "maxLength": 200, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var gender1721 = new Lino.ChoicesFieldElement({ "autoHeight": true, "forceSelection": true, "fieldLabel": "Geschlecht", "name": "gender", "hiddenName": "genderHidden", "selectOnFocus": true, "anchor": "-20", "store": [['','<br>']].concat(Lino.lino.Genders) });
    var birth_date1722 = new Lino.IncompleteDateField({ "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Geburtsdatum</span>", "name": "birth_date", "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Geburtsdatum","Uncomplete dates are allowed, e.g. \n\"00.00.1980\" means \"some day in 1980\", \n\"00.07.1980\" means \"in July 1980\"\nor \"23.07.0000\" means \"on a 23th of July\".") }, "anchor": "-20" });
    var age_disp1723 = new Ext.form.DisplayField({ "disabled": true, "autoHeight": true, "fieldLabel": "Alter", "name": "age", "anchor": "-20", "value": "<br/>", "always_enabled": true });
    var general2_3_panel1724 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 31, "autoHeight": true, "layout": "form", "xtype": "panel", "items": gender1721, "labelAlign": "top" }, { "flex": 37, "autoHeight": true, "layout": "form", "xtype": "panel", "items": birth_date1722, "labelAlign": "top" }, { "flex": 31, "autoHeight": true, "layout": "form", "xtype": "panel", "items": age_disp1723, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 117, "border": false, "anchor": "-20", "labelAlign": "top" });
    var id1728 = new Ext.form.NumberField({ "selectOnFocus": true, "autoHeight": true, "fieldLabel": "ID", "anchor": "-20", "name": "id" });
    var language1729 = new Lino.ChoicesFieldElement({ "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Sprache</span>", "allowBlank": false, "hiddenName": "languageHidden", "listeners": { "render": Lino.quicktip_renderer("Sprache","Die Sprache, in der Dokumente ausgestellt werden sollen.") }, "selectOnFocus": true, "anchor": "-20", "store": [ [ "en", "Englisch" ], [ "fr", "Franz\u00f6sisch" ], [ "de", "Deutsch" ], [ "nl", "Niederl\u00e4ndisch" ] ], "name": "language" });
    var general2_4_panel1730 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 20, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id1728, "labelAlign": "top" }, { "flex": 80, "autoHeight": true, "layout": "form", "xtype": "panel", "items": language1729, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 72, "border": false, "anchor": "-20", "labelAlign": "top" });
    var general2_panel1733 = new Ext.Panel({ "flex": 42, "autoHeight": true, "layout": "form", "items": [ general2_1_panel1716, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": last_name1720, "anchor": "-20", "labelAlign": "top" }, general2_3_panel1724, general2_4_panel1730 ], "frame": true, "bodyBorder": false, "autoScroll": false, "hideCheckBoxLabels": true, "labelWidth": 117, "border": false, "labelAlign": "top" });
    var email1735 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "E-Mail", "name": "email", "maxLength": 75, "selectOnFocus": true, "anchor": "-20" });
    var phone1736 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Telefon", "name": "phone", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var gsm1737 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "GSM", "name": "gsm", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var fax1738 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Fax", "name": "fax", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var general3_panel1739 = new Ext.Panel({ "flex": 28, "autoHeight": true, "layout": "form", "items": [ { "autoHeight": true, "layout": "form", "xtype": "panel", "items": email1735, "anchor": "-20", "labelAlign": "top" }, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": phone1736, "anchor": "-20", "labelAlign": "top" }, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": gsm1737, "anchor": "-20", "labelAlign": "top" }, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": fax1738, "anchor": "-20", "labelAlign": "top" } ], "frame": true, "bodyBorder": false, "autoScroll": false, "hideCheckBoxLabels": true, "labelWidth": 72, "border": false, "labelAlign": "top" });
    var general_1_panel1744 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 0, "hideCheckBoxLabels": true, "items": [ overview_disp1712, general2_panel1733, general3_panel1739 ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var contacts_RolesByPerson_grid1749 = new Lino.contacts.RolesByPerson.GridPanel({ "flex": 45, "hide_top_toolbar": true, "containing_panel": this, "tools": [ Lino.show_in_own_window_button(Lino.contacts.RolesByPerson.grid) ], "preview_limit": 15, "master_panel": this });
    var general_panel1750 = new Ext.Panel({ "layout": "vbox", "title": "Allgemein", "items": [ general_1_panel1744, contacts_RolesByPerson_grid1749 ], "frame": true, "layoutConfig": { "align": "stretch" }, "hideCheckBoxLabels": true, "listeners": { "activate": Lino.on_tab_activate }, "autoScroll": false, "border": false, "bodyBorder": false, "labelAlign": "top" });
    var MembersByPerson_htmlbox1751 = new Lino.HtmlBoxPanel({ "flex": 25, "layout": "fit", "name": "MembersByPerson", "containing_panel": this, "items": new Ext.BoxComponent({autoScroll:true}), "title": "Mitgliedschaft in Haushalten", "master_panel": this, "value": "<br/>", "always_enabled": true, "bodyStyle": "overflow-x:hidden;", "tools": [ Lino.show_in_own_window_button(Lino.households.MembersByPerson.grid) ] });
    var households_SiblingsByPerson_grid1767 = new Lino.households.SiblingsByPerson.GridPanel({ "flex": 75, "hide_top_toolbar": true, "containing_panel": this, "tools": [ Lino.show_in_own_window_button(Lino.households.SiblingsByPerson.grid) ], "preview_limit": 15, "master_panel": this });
    var contact_1_panel1768 = new Ext.Panel({ "flex": 5, "layout": "hbox", "items": [ MembersByPerson_htmlbox1751, households_SiblingsByPerson_grid1767 ], "region": "north", "layoutConfig": { "align": "stretch" }, "hideCheckBoxLabels": true, "split": true, "autoScroll": false, "labelWidth": 261, "border": false, "frame": false, "labelAlign": "top" });
    var LinksByHuman_htmlbox1769 = new Lino.HtmlBoxPanel({ "flex": 3, "layout": "fit", "name": "LinksByHuman", "containing_panel": this, "items": new Ext.BoxComponent({autoScroll:true}), "region": "center", "title": "Beziehungen", "master_panel": this, "value": "<br/>", "always_enabled": true, "bodyStyle": "overflow-x:hidden;", "split": true, "tools": [ Lino.show_in_own_window_button(Lino.humanlinks.LinksByHuman.grid) ] });
    var remarks1770 = new Ext.form.TextArea({ "selectOnFocus": true, "fieldLabel": "Bemerkungen", "anchor": "-20 -10", "growMax": 2000, "name": "remarks" });
    var sepa_AccountsByPartner_grid1771 = new Lino.sepa.AccountsByPartner.GridPanel({ "flex": 64, "hide_top_toolbar": true, "containing_panel": this, "tools": [ Lino.show_in_own_window_button(Lino.sepa.AccountsByPartner.grid) ], "preview_limit": 15, "master_panel": this });
    var contact_3_panel1772 = new Ext.Panel({ "flex": 5, "layout": "hbox", "items": [ { "items": remarks1770, "labelAlign": "top", "layout": "form", "xtype": "panel", "flex": 35 }, sepa_AccountsByPartner_grid1771 ], "region": "south", "layoutConfig": { "align": "stretch" }, "hideCheckBoxLabels": true, "split": true, "autoScroll": false, "labelWidth": 108, "border": false, "frame": false, "labelAlign": "top" });
    var contact_panel1774 = new Lino.VBorderPanel({ "autoScroll": false, "listeners": { "activate": Lino.on_tab_activate }, "border": false, "labelWidth": 108, "title": "Kontakt", "hideCheckBoxLabels": true, "items": [ contact_1_panel1768, LinksByHuman_htmlbox1769, contact_3_panel1772 ], "frame": true, "bodyBorder": false, "labelAlign": "top" });
    var activity1775 = new Lino.RemoteComboFieldElement({ "autoHeight": true, "fieldLabel": "Beruf", "name": "activity", "pageSize": 20, "emptyText": "Beruf ausw\u00e4hlen...", "selectOnFocus": true, "hiddenName": "activityHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/contacts/Persons/activity", "method": "GET" }) }) });
    var url1776 = new Lino.URLField({ "autoHeight": true, "fieldLabel": "URL", "name": "url", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var client_contact_type1777 = new Lino.TwinCombo({ "autoHeight": true, "fieldLabel": "Klientenkontaktart", "name": "client_contact_type", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.pcsw.ClientContactTypes.detail,Lino.pcsw.ClientContactTypes.insert)}, "emptyText": "Klientenkontaktart ausw\u00e4hlen...", "selectOnFocus": true, "hiddenName": "client_contact_typeHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/contacts/Persons/client_contact_type", "method": "GET" }) }) });
    var misc_1_panel1778 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 171, "hideCheckBoxLabels": true, "items": [ { "flex": 32, "autoHeight": true, "layout": "form", "xtype": "panel", "items": activity1775, "labelAlign": "top" }, { "flex": 34, "autoHeight": true, "layout": "form", "xtype": "panel", "items": url1776, "labelAlign": "top" }, { "flex": 32, "autoHeight": true, "layout": "form", "xtype": "panel", "items": client_contact_type1777, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var is_obsolete1782 = new Ext.form.Checkbox({ "autoHeight": true, "hideLabel": true, "checked": false, "name": "is_obsolete", "listeners": { "render": Lino.quicktip_renderer("veraltet","Altf\u00e4lle sind Partner, deren Stammdaten nicht mehr gepflegt werden und \nf\u00fcr neue Operationen nicht benutzt werden k\u00f6nnen.") }, "boxLabel": "veraltet", "selectOnFocus": true, "anchor": "-20" });
    var is_client1783 = new Ext.form.Checkbox({ "boxLabel": "ist Klient (<a href=\"javascript:Lino.show_mti_child('is_client',Lino.pcsw.Clients.detail)\">zeigen</a>)", "autoHeight": true, "hideLabel": true, "name": "is_client", "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("ist Klient","Ob diese Person ein Klient ist") }, "anchor": "-20" });
    var misc_2_panel1784 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 99, "hideCheckBoxLabels": true, "items": [ { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": is_obsolete1782, "labelAlign": "top" }, { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": is_client1783, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var created1787 = new Ext.form.DisplayField({ "disabled": true, "autoHeight": true, "fieldLabel": "Erstellt", "name": "created", "anchor": "-20", "value": "<br>" });
    var modified1788 = new Ext.form.DisplayField({ "disabled": true, "autoHeight": true, "fieldLabel": "Bearbeitet", "name": "modified", "anchor": "-20", "value": "<br>" });
    var misc_3_panel1789 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 99, "hideCheckBoxLabels": true, "items": [ { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": created1787, "labelAlign": "top" }, { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": modified1788, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var reception_AppointmentsByPartner_grid1792 = new Lino.reception.AppointmentsByPartner.GridPanel({ "flex": 62, "hide_top_toolbar": true, "containing_panel": this, "tools": [ Lino.show_in_own_window_button(Lino.reception.AppointmentsByPartner.grid) ], "preview_limit": 15, "master_panel": this });
    var misc_panel1793 = new Ext.Panel({ "layout": "vbox", "title": "Sonstiges", "items": [ misc_1_panel1778, misc_2_panel1784, misc_3_panel1789, reception_AppointmentsByPartner_grid1792 ], "frame": true, "layoutConfig": { "align": "stretch" }, "hideCheckBoxLabels": true, "listeners": { "activate": Lino.on_tab_activate }, "autoScroll": false, "border": false, "bodyBorder": false, "labelAlign": "top" });
    var debts_BudgetsByPartner_grid1794 = new Lino.debts.BudgetsByPartner.GridPanel({ "flex": 5, "hide_top_toolbar": true, "containing_panel": this, "region": "north", "preview_limit": 15, "master_panel": this, "split": true, "tools": [ Lino.show_in_own_window_button(Lino.debts.BudgetsByPartner.grid) ] });
    var debts_ActorsByPartner_grid1795 = new Lino.debts.ActorsByPartner.GridPanel({ "flex": 5, "hide_top_toolbar": true, "containing_panel": this, "region": "center", "preview_limit": 15, "master_panel": this, "split": true, "tools": [ Lino.show_in_own_window_button(Lino.debts.ActorsByPartner.grid) ] });
    var debts_panel1796 = new Lino.VBorderPanel({ "autoScroll": false, "listeners": { "activate": Lino.on_tab_activate }, "border": false, "title": "Schuldnerberatung", "hideCheckBoxLabels": true, "items": [ debts_BudgetsByPartner_grid1794, debts_ActorsByPartner_grid1795 ], "frame": true, "bodyBorder": false, "labelAlign": "top" });
    var main_panel1797 = new Ext.TabPanel({ "hideCheckBoxLabels": true, "border": false, "split": true, "autoScroll": false, "items": [ general_panel1750, contact_panel1774, misc_panel1793, debts_panel1796 ], "activeTab": 0, "bodyBorder": false, "frame": true, "labelAlign": "top" });
    this.items = main_panel1797;
    this.before_row_edit = function(record) {
      contacts_RolesByPerson_grid1749.on_master_changed();
      MembersByPerson_htmlbox1751.refresh();
      households_SiblingsByPerson_grid1767.on_master_changed();
      LinksByHuman_htmlbox1769.refresh();
      sepa_AccountsByPartner_grid1771.on_master_changed();
      reception_AppointmentsByPartner_grid1792.on_master_changed();
      debts_BudgetsByPartner_grid1794.on_master_changed();
      debts_ActorsByPartner_grid1795.on_master_changed();
    }
    Lino.contacts.Persons.DetailFormPanel.superclass.initComponent.call(this);
    // active_fields:
  }
});


Lino.jobs.Offers.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 82,
  initComponent : function() {
    var name3202 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Name", "name": "name", "maxLength": 100, "selectOnFocus": true, "anchor": "-20" });
    var provider3203 = new Lino.TwinCombo({ "preferred_width": 20, "autoHeight": true, "fieldLabel": "Stellenanbieter", "name": "provider", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.jobs.JobProviders.detail,Lino.jobs.JobProviders.insert)}, "hiddenName": "providerHidden", "selectOnFocus": true, "emptyText": "Stellenanbieter ausw\u00e4hlen...", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/jobs/Offers/provider", "method": "GET" }) }) });
    var sector3204 = new Lino.TwinCombo({ "autoHeight": true, "fieldLabel": "Sektor", "name": "sector", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.cv.Sectors.detail,Lino.cv.Sectors.insert)}, "emptyText": "Sektor ausw\u00e4hlen...", "selectOnFocus": true, "hiddenName": "sectorHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/jobs/Offers/sector", "method": "GET" }) }) });
    var function3205 = new Lino.TwinCombo({ "autoHeight": true, "fieldLabel": "Funktion", "name": "function", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.cv.Functions.detail,Lino.cv.Functions.insert)}, "emptyText": "Funktion ausw\u00e4hlen...", "selectOnFocus": true, "hiddenName": "functionHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/jobs/Offers/function", "method": "GET" }) }) });
    var main_1_panel3206 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 144, "hideCheckBoxLabels": true, "items": [ { "flex": 25, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name3202, "labelAlign": "top" }, { "flex": 24, "autoHeight": true, "layout": "form", "xtype": "panel", "items": provider3203, "labelAlign": "top" }, { "flex": 24, "autoHeight": true, "layout": "form", "xtype": "panel", "items": sector3204, "labelAlign": "top" }, { "flex": 24, "autoHeight": true, "layout": "form", "xtype": "panel", "items": function3205, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var selection_from3211 = new Lino.DateField({ "selectOnFocus": true, "autoHeight": true, "fieldLabel": "Beginn Auswahl", "anchor": "-20", "name": "selection_from" });
    var selection_until3212 = new Lino.DateField({ "selectOnFocus": true, "autoHeight": true, "fieldLabel": "Ende Auswahl", "anchor": "-20", "name": "selection_until" });
    var start_date3213 = new Lino.DateField({ "selectOnFocus": true, "autoHeight": true, "fieldLabel": "Beginndatum", "anchor": "-20", "name": "start_date" });
    var main_2_panel3214 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 135, "hideCheckBoxLabels": true, "items": [ { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": selection_from3211, "labelAlign": "top" }, { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": selection_until3212, "labelAlign": "top" }, { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": start_date3213, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var remark3218 = new Ext.form.TextArea({ "selectOnFocus": true, "fieldLabel": "Bemerkung", "anchor": "-20 -10", "growMax": 2000, "name": "remark" });
    var ExperiencesByOffer_grid3225 = new Lino.jobs.ExperiencesByOffer.GridPanel({ "flex": 54, "hide_top_toolbar": true, "containing_panel": this, "tools": [ Lino.show_in_own_window_button(Lino.jobs.ExperiencesByOffer.grid) ], "preview_limit": 15, "master_panel": this });
    var CandidaturesByOffer_grid3231 = new Lino.jobs.CandidaturesByOffer.GridPanel({ "flex": 45, "hide_top_toolbar": true, "containing_panel": this, "tools": [ Lino.show_in_own_window_button(Lino.jobs.CandidaturesByOffer.grid) ], "preview_limit": 15, "master_panel": this });
    var main_4_panel3232 = new Ext.Panel({ "flex": 41, "border": false, "layout": "hbox", "hideCheckBoxLabels": true, "items": [ ExperiencesByOffer_grid3225, CandidaturesByOffer_grid3231 ], "autoScroll": false, "layoutConfig": { "align": "stretch" }, "frame": false, "labelAlign": "top" });
    var main_panel3233 = new Ext.Panel({ "autoScroll": false, "border": false, "layout": "vbox", "labelWidth": 90, "hideCheckBoxLabels": true, "items": [ main_1_panel3206, main_2_panel3214, { "items": remark3218, "labelAlign": "top", "layout": "form", "xtype": "panel", "flex": 41 }, main_4_panel3232 ], "frame": true, "layoutConfig": { "align": "stretch" }, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel3233;
    this.before_row_edit = function(record) {
      function3205.setContextValue('sector', record ? record.data['sectorHidden'] : undefined);
      ExperiencesByOffer_grid3225.on_master_changed();
      CandidaturesByOffer_grid3231.on_master_changed();
    }
    this.onRender = function(ct, position) {
      sector3204.on('change',Lino.chooser_handler(function3205,'sector'));
      Lino.jobs.Offers.DetailFormPanel.superclass.onRender.call(this, ct, position);
    }
    Lino.jobs.Offers.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.projects.ProjectsByClient.InsertFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  autoHeight: true,
  content_type: 118,
  initComponent : function() {
    var project_type5055 = new Lino.RemoteComboFieldElement({ "autoHeight": true, "fieldLabel": "Client project type", "allowBlank": false, "pageSize": 20, "emptyText": "Client project type ausw\u00e4hlen...", "selectOnFocus": true, "hiddenName": "project_typeHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/projects/ProjectsByClient/project_type", "method": "GET" }) }), "name": "project_type" });
    var start_date5056 = new Lino.DateField({ "selectOnFocus": true, "autoHeight": true, "fieldLabel": "Beginnt am", "anchor": "-20", "name": "start_date" });
    var end_date5057 = new Lino.DateField({ "selectOnFocus": true, "autoHeight": true, "fieldLabel": "Enddatum", "anchor": "-20", "name": "end_date" });
    var main_2_panel5058 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": start_date5056, "labelAlign": "top" }, { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": end_date5057, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 99, "border": false, "anchor": "-20", "labelAlign": "top" });
    var main_panel5061 = new Ext.Panel({ "hideCheckBoxLabels": true, "autoHeight": true, "border": false, "layout": "form", "labelWidth": 180, "autoScroll": false, "items": [ { "autoHeight": true, "layout": "form", "xtype": "panel", "items": project_type5055, "anchor": "-20", "labelAlign": "top" }, main_2_panel5058 ], "frame": true, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel5061;
    this.before_row_edit = function(record) {
    }
    Lino.projects.ProjectsByClient.InsertFormPanel.superclass.initComponent.call(this);
  }
});


Lino.cv.Statuses.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 64,
  initComponent : function() {
    var id2469 = new Ext.form.NumberField({ "selectOnFocus": true, "autoHeight": true, "fieldLabel": "ID", "anchor": "-20", "name": "id" });
    var name2470 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Bezeichnung", "name": "name", "maxLength": 200, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var name_fr2471 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Bezeichnung (fr)", "name": "name_fr", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var name_de2472 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Bezeichnung (de)", "name": "name_de", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var name_nl2473 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Bezeichnung (nl)", "name": "name_nl", "maxLength": 200, "selectOnFocus": true, "hidden": true, "anchor": "-20" });
    var main_1_panel2474 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 153, "hideCheckBoxLabels": true, "items": [ { "flex": 5, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id2469, "labelAlign": "top" }, { "flex": 23, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name2470, "labelAlign": "top" }, { "flex": 23, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_fr2471, "labelAlign": "top" }, { "flex": 23, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_de2472, "labelAlign": "top" }, { "flex": 23, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_nl2473, "hidden": true, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var ExperiencesByStatus_grid2524 = new Lino.cv.ExperiencesByStatus.GridPanel({ "flex": 83, "hide_top_toolbar": true, "containing_panel": this, "tools": [ Lino.show_in_own_window_button(Lino.cv.ExperiencesByStatus.grid) ], "preview_limit": 15, "master_panel": this });
    var main_panel2525 = new Ext.Panel({ "autoScroll": false, "border": false, "layout": "vbox", "hideCheckBoxLabels": true, "items": [ main_1_panel2474, ExperiencesByStatus_grid2524 ], "frame": true, "layoutConfig": { "align": "stretch" }, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel2525;
    this.before_row_edit = function(record) {
      ExperiencesByStatus_grid2524.on_master_changed();
    }
    Lino.cv.Statuses.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.cv.Durations.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 72,
  initComponent : function() {
    var id2661 = new Ext.form.NumberField({ "selectOnFocus": true, "autoHeight": true, "fieldLabel": "ID", "anchor": "-20", "name": "id" });
    var name2662 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Bezeichnung", "name": "name", "maxLength": 200, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var name_fr2663 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Bezeichnung (fr)", "name": "name_fr", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var name_de2664 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Bezeichnung (de)", "name": "name_de", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var name_nl2665 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Bezeichnung (nl)", "name": "name_nl", "maxLength": 200, "selectOnFocus": true, "hidden": true, "anchor": "-20" });
    var main_1_panel2666 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 153, "hideCheckBoxLabels": true, "items": [ { "flex": 5, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id2661, "labelAlign": "top" }, { "flex": 23, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name2662, "labelAlign": "top" }, { "flex": 23, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_fr2663, "labelAlign": "top" }, { "flex": 23, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_de2664, "labelAlign": "top" }, { "flex": 23, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_nl2665, "hidden": true, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var ExperiencesByDuration_grid2681 = new Lino.cv.ExperiencesByDuration.GridPanel({ "flex": 83, "hide_top_toolbar": true, "containing_panel": this, "tools": [ Lino.show_in_own_window_button(Lino.cv.ExperiencesByDuration.grid) ], "preview_limit": 15, "master_panel": this });
    var main_panel2682 = new Ext.Panel({ "autoScroll": false, "border": false, "layout": "vbox", "hideCheckBoxLabels": true, "items": [ main_1_panel2666, ExperiencesByDuration_grid2681 ], "frame": true, "layoutConfig": { "align": "stretch" }, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel2682;
    this.before_row_edit = function(record) {
      ExperiencesByDuration_grid2681.on_master_changed();
    }
    Lino.cv.Durations.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.cv.Regimes.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 75,
  initComponent : function() {
    var id2526 = new Ext.form.NumberField({ "selectOnFocus": true, "autoHeight": true, "fieldLabel": "ID", "anchor": "-20", "name": "id" });
    var name2527 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Bezeichnung", "name": "name", "maxLength": 200, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var name_fr2528 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Bezeichnung (fr)", "name": "name_fr", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var name_de2529 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Bezeichnung (de)", "name": "name_de", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var name_nl2530 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Bezeichnung (nl)", "name": "name_nl", "maxLength": 200, "selectOnFocus": true, "hidden": true, "anchor": "-20" });
    var main_1_panel2531 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 5, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id2526, "labelAlign": "top" }, { "flex": 23, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name2527, "labelAlign": "top" }, { "flex": 23, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_fr2528, "labelAlign": "top" }, { "flex": 23, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_de2529, "labelAlign": "top" }, { "flex": 23, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_nl2530, "hidden": true, "labelAlign": "top" } ], "region": "north", "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "split": true, "autoScroll": false, "labelWidth": 153, "border": false, "frame": false, "labelAlign": "top" });
    var cv_ExperiencesByRegime_grid2546 = new Lino.cv.ExperiencesByRegime.GridPanel({ "flex": 5, "hide_top_toolbar": true, "containing_panel": this, "region": "center", "preview_limit": 15, "master_panel": this, "split": true, "tools": [ Lino.show_in_own_window_button(Lino.cv.ExperiencesByRegime.grid) ] });
    var jobs_ContractsByRegime_grid2659 = new Lino.jobs.ContractsByRegime.GridPanel({ "flex": 5, "hide_top_toolbar": true, "containing_panel": this, "region": "south", "params_panel_hidden": true, "master_panel": this, "preview_limit": 15, "split": true, "tools": [ Lino.show_in_own_window_button(Lino.jobs.ContractsByRegime.grid) ] });
    var main_panel2660 = new Lino.VBorderPanel({ "autoScroll": false, "border": false, "hideCheckBoxLabels": true, "items": [ main_1_panel2531, cv_ExperiencesByRegime_grid2546, jobs_ContractsByRegime_grid2659 ], "frame": true, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel2660;
    this.before_row_edit = function(record) {
      cv_ExperiencesByRegime_grid2546.on_master_changed();
      jobs_ContractsByRegime_grid2659.on_master_changed();
    }
    Lino.cv.Regimes.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.cv.Functions.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 68,
  initComponent : function() {
    var id2703 = new Ext.form.NumberField({ "selectOnFocus": true, "autoHeight": true, "fieldLabel": "ID", "anchor": "-20", "name": "id" });
    var name2704 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Bezeichnung", "name": "name", "maxLength": 200, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var name_fr2705 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Bezeichnung (fr)", "name": "name_fr", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var name_de2706 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Bezeichnung (de)", "name": "name_de", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var name_nl2707 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Bezeichnung (nl)", "name": "name_nl", "maxLength": 200, "selectOnFocus": true, "hidden": true, "anchor": "-20" });
    var sector2708 = new Lino.TwinCombo({ "autoHeight": true, "fieldLabel": "Sektor", "allowBlank": false, "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.cv.Sectors.detail,Lino.cv.Sectors.insert)}, "emptyText": "Sektor ausw\u00e4hlen...", "selectOnFocus": true, "hiddenName": "sectorHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cv/Functions/sector", "method": "GET" }) }), "name": "sector" });
    var main_1_panel2709 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 153, "hideCheckBoxLabels": true, "items": [ { "flex": 4, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id2703, "labelAlign": "top" }, { "flex": 19, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name2704, "labelAlign": "top" }, { "flex": 19, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_fr2705, "labelAlign": "top" }, { "flex": 19, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_de2706, "labelAlign": "top" }, { "flex": 19, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_nl2707, "hidden": true, "labelAlign": "top" }, { "flex": 18, "autoHeight": true, "layout": "form", "xtype": "panel", "items": sector2708, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var remark2716 = new Ext.form.TextArea({ "selectOnFocus": true, "fieldLabel": "Bemerkung", "anchor": "-20 -10", "growMax": 2000, "name": "remark" });
    var jobs_CandidaturesByFunction_grid2725 = new Lino.jobs.CandidaturesByFunction.GridPanel({ "flex": 31, "hide_top_toolbar": true, "containing_panel": this, "tools": [ Lino.show_in_own_window_button(Lino.jobs.CandidaturesByFunction.grid) ], "preview_limit": 15, "master_panel": this });
    var cv_ExperiencesByFunction_grid2743 = new Lino.cv.ExperiencesByFunction.GridPanel({ "flex": 31, "hide_top_toolbar": true, "containing_panel": this, "tools": [ Lino.show_in_own_window_button(Lino.cv.ExperiencesByFunction.grid) ], "preview_limit": 15, "master_panel": this });
    var main_panel2744 = new Ext.Panel({ "autoScroll": false, "border": false, "layout": "vbox", "labelWidth": 90, "hideCheckBoxLabels": true, "items": [ main_1_panel2709, { "items": remark2716, "labelAlign": "top", "layout": "form", "xtype": "panel", "flex": 31 }, jobs_CandidaturesByFunction_grid2725, cv_ExperiencesByFunction_grid2743 ], "frame": true, "layoutConfig": { "align": "stretch" }, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel2744;
    this.before_row_edit = function(record) {
      jobs_CandidaturesByFunction_grid2725.on_master_changed();
      cv_ExperiencesByFunction_grid2743.on_master_changed();
    }
    Lino.cv.Functions.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.uploads.MyUploads.InsertFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  autoHeight: true,
  content_type: 24,
  initComponent : function() {
    var type4979 = new Lino.TwinCombo({ "autoHeight": true, "fieldLabel": "Upload-Art", "name": "type", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.uploads.UploadTypes.detail,Lino.uploads.UploadTypes.insert)}, "emptyText": "Upload-Art ausw\u00e4hlen...", "selectOnFocus": true, "hiddenName": "typeHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/uploads/MyUploads/type", "method": "GET" }) }) });
    var description4980 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Beschreibung", "name": "description", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var file4981 = Lino.file_field_handler(this,{ "autoHeight": true, "fieldLabel": "File", "name": "file", "maxLength": 100, "selectOnFocus": true, "anchor": "-20" });
    var user4982 = new Lino.TwinCombo({ "preferred_width": 15, "autoHeight": true, "fieldLabel": "Autor", "name": "user", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.users.Users.detail,Lino.users.Users.insert)}, "hiddenName": "userHidden", "selectOnFocus": true, "emptyText": "Benutzer ausw\u00e4hlen...", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/uploads/MyUploads/user", "method": "GET" }) }) });
    var main_panel4983 = new Ext.Panel({ "hideCheckBoxLabels": true, "autoHeight": true, "border": false, "layout": "form", "labelWidth": 117, "autoScroll": false, "items": [ { "autoHeight": true, "layout": "form", "xtype": "panel", "items": type4979, "anchor": "-20", "labelAlign": "top" }, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": description4980, "anchor": "-20", "labelAlign": "top" }, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": file4981, "anchor": "-20", "labelAlign": "top" }, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": user4982, "anchor": "-20", "labelAlign": "top" } ], "frame": true, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel4983;
    this.before_row_edit = function(record) {
      type4979.setContextValue('upload_area', record ? record.data['upload_areaHidden'] : undefined);
    }
    Lino.uploads.MyUploads.InsertFormPanel.superclass.initComponent.call(this);
  }
});


Lino.jobs.ContractTypes.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 86,
  initComponent : function() {
    var id3160 = new Ext.form.NumberField({ "selectOnFocus": true, "autoHeight": true, "fieldLabel": "ID", "anchor": "-20", "name": "id" });
    var name3161 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Bezeichnung", "name": "name", "maxLength": 200, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var name_fr3162 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Bezeichnung (fr)", "name": "name_fr", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var name_de3163 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Bezeichnung (de)", "name": "name_de", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var name_nl3164 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Bezeichnung (nl)", "name": "name_nl", "maxLength": 200, "selectOnFocus": true, "hidden": true, "anchor": "-20" });
    var ref3165 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Referenz", "name": "ref", "maxLength": 20, "selectOnFocus": true, "anchor": "-20" });
    var main_1_panel3166 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 153, "hideCheckBoxLabels": true, "items": [ { "flex": 4, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id3160, "labelAlign": "top" }, { "flex": 19, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name3161, "labelAlign": "top" }, { "flex": 19, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_fr3162, "labelAlign": "top" }, { "flex": 19, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_de3163, "labelAlign": "top" }, { "flex": 19, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_nl3164, "hidden": true, "labelAlign": "top" }, { "flex": 19, "autoHeight": true, "layout": "form", "xtype": "panel", "items": ref3165, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var ContractsByType_grid3200 = new Lino.jobs.ContractsByType.GridPanel({ "flex": 83, "hide_top_toolbar": true, "containing_panel": this, "params_panel_hidden": true, "tools": [ Lino.show_in_own_window_button(Lino.jobs.ContractsByType.grid) ], "master_panel": this, "preview_limit": 15 });
    var main_panel3201 = new Ext.Panel({ "autoScroll": false, "border": false, "layout": "vbox", "hideCheckBoxLabels": true, "items": [ main_1_panel3166, ContractsByType_grid3200 ], "frame": true, "layoutConfig": { "align": "stretch" }, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel3201;
    this.before_row_edit = function(record) {
      ContractsByType_grid3200.on_master_changed();
    }
    Lino.jobs.ContractTypes.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.isip.Contracts.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 79,
  initComponent : function() {
    var id2355 = new Ext.form.NumberField({ "selectOnFocus": true, "autoHeight": true, "fieldLabel": "ID", "anchor": "-20", "name": "id" });
    var client2356 = new Lino.TwinCombo({ "preferred_width": 20, "autoHeight": true, "fieldLabel": "Klient", "allowBlank": false, "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.pcsw.Clients.detail,Lino.pcsw.Clients.insert)}, "emptyText": "Klient ausw\u00e4hlen...", "selectOnFocus": true, "hiddenName": "clientHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/isip/Contracts/client", "method": "GET" }) }), "name": "client" });
    var type2357 = new Lino.TwinCombo({ "preferred_width": 20, "autoHeight": true, "fieldLabel": "Vertragsart", "name": "type", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.isip.ContractTypes.detail,Lino.isip.ContractTypes.insert)}, "hiddenName": "typeHidden", "selectOnFocus": true, "emptyText": "VSE-Art ausw\u00e4hlen...", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/isip/Contracts/type", "method": "GET" }) }) });
    var user2358 = new Lino.TwinCombo({ "preferred_width": 15, "autoHeight": true, "fieldLabel": "Begleiter im DSBE", "name": "user", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.users.Users.detail,Lino.users.Users.insert)}, "hiddenName": "userHidden", "selectOnFocus": true, "emptyText": "Benutzer ausw\u00e4hlen...", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/isip/Contracts/user", "method": "GET" }) }) });
    var user_asd2359 = new Lino.TwinCombo({ "preferred_width": 15, "autoHeight": true, "fieldLabel": "Verantwortlicher (ASD)", "name": "user_asd", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.users.Users.detail,Lino.users.Users.insert)}, "hiddenName": "user_asdHidden", "selectOnFocus": true, "emptyText": "Benutzer ausw\u00e4hlen...", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/isip/Contracts/user_asd", "method": "GET" }) }) });
    var general_1_panel2360 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 207, "hideCheckBoxLabels": true, "items": [ { "flex": 9, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id2355, "labelAlign": "top" }, { "flex": 30, "autoHeight": true, "layout": "form", "xtype": "panel", "items": client2356, "labelAlign": "top" }, { "flex": 24, "autoHeight": true, "layout": "form", "xtype": "panel", "items": type2357, "labelAlign": "top" }, { "flex": 18, "autoHeight": true, "layout": "form", "xtype": "panel", "items": user2358, "labelAlign": "top" }, { "flex": 18, "autoHeight": true, "layout": "form", "xtype": "panel", "items": user_asd2359, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var study_type2366 = new Lino.TwinCombo({ "autoHeight": true, "fieldLabel": "Studienart", "name": "study_type", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.cv.StudyTypes.detail,Lino.cv.StudyTypes.insert)}, "emptyText": "Studienart ausw\u00e4hlen...", "selectOnFocus": true, "hiddenName": "study_typeHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/isip/Contracts/study_type", "method": "GET" }) }) });
    var applies_from2367 = new Lino.DateField({ "selectOnFocus": true, "autoHeight": true, "fieldLabel": "Laufzeit von", "anchor": "-20", "name": "applies_from" });
    var applies_until2368 = new Lino.DateField({ "selectOnFocus": true, "autoHeight": true, "fieldLabel": "Laufzeit bis", "anchor": "-20", "name": "applies_until" });
    var exam_policy2369 = new Lino.TwinCombo({ "autoHeight": true, "fieldLabel": "Auswertungsstrategie", "name": "exam_policy", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.isip.ExamPolicies.detail,Lino.isip.ExamPolicies.insert)}, "emptyText": "Auswertungsstrategie ausw\u00e4hlen...", "selectOnFocus": true, "hiddenName": "exam_policyHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/isip/Contracts/exam_policy", "method": "GET" }) }) });
    var language2370 = new Lino.ChoicesFieldElement({ "autoHeight": true, "fieldLabel": "Sprache", "allowBlank": false, "hiddenName": "languageHidden", "selectOnFocus": true, "anchor": "-20", "store": [ [ "en", "Englisch" ], [ "fr", "Franz\u00f6sisch" ], [ "de", "Deutsch" ], [ "nl", "Niederl\u00e4ndisch" ] ], "name": "language" });
    var general_2_panel2371 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 189, "hideCheckBoxLabels": true, "items": [ { "flex": 27, "autoHeight": true, "layout": "form", "xtype": "panel", "items": study_type2366, "labelAlign": "top" }, { "flex": 17, "autoHeight": true, "layout": "form", "xtype": "panel", "items": applies_from2367, "labelAlign": "top" }, { "flex": 17, "autoHeight": true, "layout": "form", "xtype": "panel", "items": applies_until2368, "labelAlign": "top" }, { "flex": 27, "autoHeight": true, "layout": "form", "xtype": "panel", "items": exam_policy2369, "labelAlign": "top" }, { "flex": 10, "autoHeight": true, "layout": "form", "xtype": "panel", "items": language2370, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var date_decided2377 = new Lino.DateField({ "selectOnFocus": true, "autoHeight": true, "fieldLabel": "Beschlossen am", "anchor": "-20", "name": "date_decided" });
    var date_issued2378 = new Lino.DateField({ "selectOnFocus": true, "autoHeight": true, "fieldLabel": "Ausgestellt am", "anchor": "-20", "name": "date_issued" });
    var printed_disp2379 = new Ext.form.DisplayField({ "disabled": true, "autoHeight": true, "fieldLabel": "Ausgedruckt", "name": "printed", "anchor": "-20", "value": "<br/>", "always_enabled": true });
    var date_ended2380 = new Lino.DateField({ "selectOnFocus": true, "autoHeight": true, "fieldLabel": "Enddatum", "anchor": "-20", "name": "date_ended" });
    var ending2381 = new Lino.TwinCombo({ "autoHeight": true, "fieldLabel": "Beendigungsgrund", "name": "ending", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.isip.ContractEndings.detail,Lino.isip.ContractEndings.insert)}, "emptyText": "Beendigungsgrund ausw\u00e4hlen...", "selectOnFocus": true, "hiddenName": "endingHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/isip/Contracts/ending", "method": "GET" }) }) });
    var general_3_panel2382 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 153, "hideCheckBoxLabels": true, "items": [ { "flex": 14, "autoHeight": true, "layout": "form", "xtype": "panel", "items": date_decided2377, "labelAlign": "top" }, { "flex": 14, "autoHeight": true, "layout": "form", "xtype": "panel", "items": date_issued2378, "labelAlign": "top" }, { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": printed_disp2379, "labelAlign": "top" }, { "flex": 14, "autoHeight": true, "layout": "form", "xtype": "panel", "items": date_ended2380, "labelAlign": "top" }, { "flex": 22, "autoHeight": true, "layout": "form", "xtype": "panel", "items": ending2381, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var PartnersByContract_grid2402 = new Lino.isip.PartnersByContract.GridPanel({ "flex": 33, "hide_top_toolbar": true, "containing_panel": this, "tools": [ Lino.show_in_own_window_button(Lino.isip.PartnersByContract.grid) ], "preview_limit": 15, "master_panel": this });
    var cal_TasksByController_grid2403 = new Lino.cal.TasksByController.GridPanel({ "flex": 48, "hide_top_toolbar": true, "containing_panel": this, "params_panel_hidden": true, "tools": [ Lino.show_in_own_window_button(Lino.cal.TasksByController.grid) ], "master_panel": this, "preview_limit": 15 });
    var cal_EventsByController_grid2404 = new Lino.cal.EventsByController.GridPanel({ "flex": 51, "hide_top_toolbar": true, "containing_panel": this, "params_panel_hidden": true, "tools": [ Lino.show_in_own_window_button(Lino.cal.EventsByController.grid) ], "master_panel": this, "preview_limit": 15 });
    var general_5_panel2405 = new Ext.Panel({ "flex": 33, "border": false, "layout": "hbox", "hideCheckBoxLabels": true, "items": [ cal_TasksByController_grid2403, cal_EventsByController_grid2404 ], "autoScroll": false, "layoutConfig": { "align": "stretch" }, "frame": false, "labelAlign": "top" });
    var general_panel2406 = new Ext.Panel({ "layout": "vbox", "title": "Allgemein", "items": [ general_1_panel2360, general_2_panel2371, general_3_panel2382, PartnersByContract_grid2402, general_5_panel2405 ], "frame": true, "layoutConfig": { "align": "stretch" }, "hideCheckBoxLabels": true, "listeners": { "activate": Lino.on_tab_activate }, "autoScroll": false, "border": false, "bodyBorder": false, "labelAlign": "top" });
    var stages2407 = new Lino.RichTextPanel({ "selectOnFocus": true, "flex": 50, "containing_panel": this, "name": "stages", "title": "Etappen" });
    var goals2408 = new Lino.RichTextPanel({ "selectOnFocus": true, "flex": 50, "containing_panel": this, "name": "goals", "title": "Zielsetzungen" });
    var isip_1_panel2409 = new Ext.Panel({ "flex": 5, "layout": "hbox", "items": [ stages2407, goals2408 ], "region": "north", "layoutConfig": { "align": "stretch" }, "hideCheckBoxLabels": true, "split": true, "autoScroll": false, "labelWidth": 0, "border": false, "frame": false, "labelAlign": "top" });
    var duties_asd2410 = new Lino.RichTextPanel({ "selectOnFocus": true, "flex": 33, "containing_panel": this, "name": "duties_asd", "title": "Verpflichtungen ASD" });
    var duties_dsbe2411 = new Lino.RichTextPanel({ "selectOnFocus": true, "flex": 33, "containing_panel": this, "name": "duties_dsbe", "title": "Verpflichtungen DSBE" });
    var duties_person2412 = new Lino.RichTextPanel({ "selectOnFocus": true, "flex": 33, "containing_panel": this, "name": "duties_person", "title": "Verpflichtungen Person" });
    var isip_2_panel2413 = new Ext.Panel({ "flex": 5, "layout": "hbox", "items": [ duties_asd2410, duties_dsbe2411, duties_person2412 ], "region": "center", "layoutConfig": { "align": "stretch" }, "hideCheckBoxLabels": true, "split": true, "autoScroll": false, "labelWidth": 0, "border": false, "frame": false, "labelAlign": "top" });
    var isip_panel2414 = new Lino.VBorderPanel({ "autoScroll": false, "listeners": { "activate": Lino.on_tab_activate }, "border": false, "title": "VSE", "hideCheckBoxLabels": true, "items": [ isip_1_panel2409, isip_2_panel2413 ], "frame": true, "bodyBorder": false, "labelAlign": "top" });
    var main_panel2415 = new Ext.TabPanel({ "hideCheckBoxLabels": true, "border": false, "split": true, "autoScroll": false, "items": [ general_panel2406, isip_panel2414 ], "activeTab": 0, "bodyBorder": false, "frame": true, "labelAlign": "top" });
    this.items = main_panel2415;
    this.before_row_edit = function(record) {
      PartnersByContract_grid2402.on_master_changed();
      cal_TasksByController_grid2403.on_master_changed();
      cal_EventsByController_grid2404.on_master_changed();
      stages2407.refresh();
      goals2408.refresh();
      duties_asd2410.refresh();
      duties_dsbe2411.refresh();
      duties_person2412.refresh();
    }
    Lino.isip.Contracts.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.about.About.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  disable_editing: true,
  initComponent : function() {
    var server_status_disp5093 = new Ext.form.DisplayField({ "disabled": true, "autoHeight": true, "fieldLabel": "Server-Status", "name": "server_status", "anchor": "-20", "value": "<br/>", "always_enabled": true });
    var main_panel5094 = new Ext.Panel({ "autoScroll": false, "border": false, "layout": "vbox", "labelWidth": 126, "hideCheckBoxLabels": true, "items": [ { "flex": 25, "html": "<div class=\"htmlText\"><span>Dies ist <a href=\"http://welfare.lino-framework.org\" target=\"_blank\">Lino Welfare</a> 1.1.19 unter <a href=\"http://www.lino-framework.org\" target=\"_blank\">Lino</a> 1.6.14, <a href=\"http://www.djangoproject.com\" target=\"_blank\">Django</a> 1.6.7, <a href=\"http://www.python.org/\" target=\"_blank\">Python</a> 2.7.4, <a href=\"http://babel.edgewall.org/\" target=\"_blank\">Babel</a> 1.3, <a href=\"http://jinja.pocoo.org/\" target=\"_blank\">Jinja</a> 2.7.2, <a href=\"http://sphinx-doc.org/\" target=\"_blank\">Sphinx</a> 1.3a0, <a href=\"http://labix.org/python-dateutil\" target=\"_blank\">python-dateutil</a> 2.1, <a href=\"http://pypi.python.org/pypi/odfpy\" target=\"_blank\">OdfPy</a> ODFPY/0.9.6, <a href=\"http://docutils.sourceforge.net/\" target=\"_blank\">docutils</a> 0.11, <a href=\"https://fedorahosted.org/suds/\" target=\"_blank\">suds</a> 0.4, <a href=\"http://pyyaml.org/\" target=\"_blank\">PyYaml</a> 3.10, <a href=\"http://appyframework.org/pod.html\" target=\"_blank\">Appy</a> 0.9.0 (2014/06/23 22:15), <a href=\"http://www.sencha.com\" target=\"_blank\">ExtJS</a> <a href=\"#\" onclick=\"alert('ExtJS client version is ' + Ext.version);\" title=\"Click to see ExtJS client version\">(version)</a>, <a href=\"http://www.famfamfam.com/lab/icons/silk/\" target=\"_blank\">Silk Icons</a> 1.3, <a href=\"http://getbootstrap.com\" target=\"_blank\">Bootstrap</a> 3.x, <a href=\"http://ext.ensible.com/products/calendar/\" target=\"_blank\">Ext.ensible adapter</a> <a href=\"#\" onclick=\"alert('Extensible Calendar version is '             + Ext.ensible.version);\" title=\"Click to see Extensible Calendar version\">(version)</a></span><p>Server l&#228;uft seit : <b>Freitag, 12. Dezember 2014 um 05:39:37.286335</b></p><p>Source timestamps:</p><ul><li>lino_welfare : <b>Freitag, 12. Dezember 2014 um 04:23:44.660455</b></li><li>lino : <b>Donnerstag, 11. Dezember 2014 um 10:11:55.423808</b></li><li>atelier : <b>Dienstag, 9. Dezember 2014 um 21:48:28.430902</b></li><li>django : <b>Montag, 27. Oktober 2014 um 16:34:33.459643</b></li></ul></div>", "xtype": "label" }, { "items": server_status_disp5093, "autoHeight": true, "layout": "form", "xtype": "panel", "labelAlign": "top" } ], "frame": true, "layoutConfig": { "align": "stretch" }, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel5094;
    this.before_row_edit = function(record) {
    }
    Lino.about.About.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.cv.Experiences.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 71,
  initComponent : function() {
    var person2489 = new Lino.TwinCombo({ "preferred_width": 20, "autoHeight": true, "fieldLabel": "Klient", "allowBlank": false, "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.pcsw.Clients.detail,Lino.pcsw.Clients.insert)}, "emptyText": "Klient ausw\u00e4hlen...", "selectOnFocus": true, "hiddenName": "personHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cv/Experiences/person", "method": "GET" }) }), "name": "person" });
    var start_date2490 = new Lino.DateField({ "selectOnFocus": true, "autoHeight": true, "fieldLabel": "Beginnt am", "anchor": "-20", "name": "start_date" });
    var end_date2491 = new Lino.DateField({ "selectOnFocus": true, "autoHeight": true, "fieldLabel": "Enddatum", "anchor": "-20", "name": "end_date" });
    var termination_reason2492 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Beendigungsgrund", "name": "termination_reason", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var main_1_panel2493 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 153, "hideCheckBoxLabels": true, "items": [ { "flex": 29, "autoHeight": true, "layout": "form", "xtype": "panel", "items": person2489, "labelAlign": "top" }, { "flex": 19, "autoHeight": true, "layout": "form", "xtype": "panel", "items": start_date2490, "labelAlign": "top" }, { "flex": 19, "autoHeight": true, "layout": "form", "xtype": "panel", "items": end_date2491, "labelAlign": "top" }, { "flex": 31, "autoHeight": true, "layout": "form", "xtype": "panel", "items": termination_reason2492, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var company2498 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Firma", "name": "company", "maxLength": 200, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var country2499 = new Lino.TwinCombo({ "autoHeight": true, "fieldLabel": "Land", "name": "country", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.countries.Countries.detail,Lino.countries.Countries.insert)}, "emptyText": "Land ausw\u00e4hlen...", "selectOnFocus": true, "hiddenName": "countryHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cv/Experiences/country", "method": "GET" }) }) });
    var city2500 = new Lino.TwinCombo({ "autoHeight": true, "forceSelection": false, "fieldLabel": "Stadt", "name": "city", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.countries.Places.detail,Lino.countries.Places.insert)}, "emptyText": "Ort ausw\u00e4hlen...", "selectOnFocus": true, "hiddenName": "cityHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cv/Experiences/city", "method": "GET" }) }) });
    var main_2_panel2501 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 54, "hideCheckBoxLabels": true, "items": [ { "flex": 34, "autoHeight": true, "layout": "form", "xtype": "panel", "items": company2498, "labelAlign": "top" }, { "flex": 32, "autoHeight": true, "layout": "form", "xtype": "panel", "items": country2499, "labelAlign": "top" }, { "flex": 32, "autoHeight": true, "layout": "form", "xtype": "panel", "items": city2500, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var sector2505 = new Lino.TwinCombo({ "autoHeight": true, "fieldLabel": "Sektor", "name": "sector", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.cv.Sectors.detail,Lino.cv.Sectors.insert)}, "emptyText": "Sektor ausw\u00e4hlen...", "selectOnFocus": true, "hiddenName": "sectorHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cv/Experiences/sector", "method": "GET" }) }) });
    var function2506 = new Lino.TwinCombo({ "autoHeight": true, "fieldLabel": "Funktion", "name": "function", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.cv.Functions.detail,Lino.cv.Functions.insert)}, "emptyText": "Funktion ausw\u00e4hlen...", "selectOnFocus": true, "hiddenName": "functionHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cv/Experiences/function", "method": "GET" }) }) });
    var title2507 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Bezeichnung", "name": "title", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var main_3_panel2508 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 108, "hideCheckBoxLabels": true, "items": [ { "flex": 32, "autoHeight": true, "layout": "form", "xtype": "panel", "items": sector2505, "labelAlign": "top" }, { "flex": 32, "autoHeight": true, "layout": "form", "xtype": "panel", "items": function2506, "labelAlign": "top" }, { "flex": 34, "autoHeight": true, "layout": "form", "xtype": "panel", "items": title2507, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var status2512 = new Lino.TwinCombo({ "autoHeight": true, "fieldLabel": "Zustand", "name": "status", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.cv.Statuses.detail,Lino.cv.Statuses.insert)}, "emptyText": "Zustand ausw\u00e4hlen...", "selectOnFocus": true, "hiddenName": "statusHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cv/Experiences/status", "method": "GET" }) }) });
    var duration2513 = new Lino.TwinCombo({ "autoHeight": true, "fieldLabel": "Vertragsdauer", "name": "duration", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.cv.Durations.detail,Lino.cv.Durations.insert)}, "emptyText": "Vertragsdauer ausw\u00e4hlen...", "selectOnFocus": true, "hiddenName": "durationHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cv/Experiences/duration", "method": "GET" }) }) });
    var regime2514 = new Lino.TwinCombo({ "autoHeight": true, "fieldLabel": "Work Regime", "name": "regime", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.cv.Regimes.detail,Lino.cv.Regimes.insert)}, "emptyText": "Work Regime ausw\u00e4hlen...", "selectOnFocus": true, "hiddenName": "regimeHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cv/Experiences/regime", "method": "GET" }) }) });
    var is_training2515 = new Ext.form.Checkbox({ "boxLabel": "Ausbildung", "autoHeight": true, "hideLabel": true, "checked": false, "name": "is_training", "selectOnFocus": true, "anchor": "-20" });
    var main_4_panel2516 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 126, "hideCheckBoxLabels": true, "items": [ { "flex": 28, "autoHeight": true, "layout": "form", "xtype": "panel", "items": status2512, "labelAlign": "top" }, { "flex": 28, "autoHeight": true, "layout": "form", "xtype": "panel", "items": duration2513, "labelAlign": "top" }, { "flex": 28, "autoHeight": true, "layout": "form", "xtype": "panel", "items": regime2514, "labelAlign": "top" }, { "flex": 14, "autoHeight": true, "layout": "form", "xtype": "panel", "items": is_training2515, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var remarks2521 = new Ext.form.TextArea({ "selectOnFocus": true, "fieldLabel": "Bemerkungen", "anchor": "-20 -10", "growMax": 2000, "name": "remarks" });
    var main_panel2522 = new Ext.Panel({ "autoScroll": false, "border": false, "layout": "vbox", "labelWidth": 108, "hideCheckBoxLabels": true, "items": [ main_1_panel2493, main_2_panel2501, main_3_panel2508, main_4_panel2516, { "items": remarks2521, "labelAlign": "top", "layout": "form", "xtype": "panel", "flex": 55 } ], "frame": true, "layoutConfig": { "align": "stretch" }, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel2522;
    this.before_row_edit = function(record) {
      city2500.setContextValue('country', record ? record.data['countryHidden'] : undefined);
      function2506.setContextValue('sector', record ? record.data['sectorHidden'] : undefined);
    }
    this.onRender = function(ct, position) {
      country2499.on('change',Lino.chooser_handler(city2500,'country'));
      sector2505.on('change',Lino.chooser_handler(function2506,'sector'));
      Lino.cv.Experiences.DetailFormPanel.superclass.onRender.call(this, ct, position);
    }
    Lino.cv.Experiences.DetailFormPanel.superclass.initComponent.call(this);
    // active_fields:
    city2500.on("change", function(){ this.save() }, this);
  }
});


Lino.notes.NoteTypes.InsertFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  autoHeight: true,
  content_type: 111,
  initComponent : function() {
    var name606 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Bezeichnung", "name": "name", "maxLength": 200, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var name_fr607 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Bezeichnung (fr)", "name": "name_fr", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var name_de608 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Bezeichnung (de)", "name": "name_de", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var name_nl609 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Bezeichnung (nl)", "name": "name_nl", "maxLength": 200, "selectOnFocus": true, "hidden": true, "anchor": "-20" });
    var main_1_panel610 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 25, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name606, "labelAlign": "top" }, { "flex": 25, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_fr607, "labelAlign": "top" }, { "flex": 25, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_de608, "labelAlign": "top" }, { "flex": 25, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_nl609, "hidden": true, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 153, "border": false, "anchor": "-20", "labelAlign": "top" });
    var build_method615 = new Lino.ChoicesFieldElement({ "autoHeight": true, "forceSelection": true, "fieldLabel": "Konstruktionsmethode", "name": "build_method", "hiddenName": "build_methodHidden", "selectOnFocus": true, "anchor": "-20", "store": [['','<br>']].concat(Lino.lino.BuildMethods) });
    var main_panel616 = new Ext.Panel({ "hideCheckBoxLabels": true, "autoHeight": true, "border": false, "layout": "form", "labelWidth": 189, "autoScroll": false, "items": [ main_1_panel610, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": build_method615, "anchor": "-20", "labelAlign": "top" } ], "frame": true, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel616;
    this.before_row_edit = function(record) {
    }
    Lino.notes.NoteTypes.InsertFormPanel.superclass.initComponent.call(this);
  }
});


Lino.aids.AidTypes.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 117,
  initComponent : function() {
    var id4664 = new Ext.form.NumberField({ "selectOnFocus": true, "autoHeight": true, "fieldLabel": "ID", "anchor": "-20", "name": "id" });
    var short_name4665 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "short name", "name": "short_name", "maxLength": 50, "selectOnFocus": true, "anchor": "-20" });
    var confirmation_type4666 = new Lino.ChoicesFieldElement({ "autoHeight": true, "forceSelection": true, "fieldLabel": "Hilfebescheinigungsart", "name": "confirmation_type", "hiddenName": "confirmation_typeHidden", "selectOnFocus": true, "anchor": "-20", "store": [['','<br>']].concat(Lino.aids.ConfirmationTypes) });
    var main_1_panel4667 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 207, "hideCheckBoxLabels": true, "items": [ { "flex": 6, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id4664, "labelAlign": "top" }, { "flex": 28, "autoHeight": true, "layout": "form", "xtype": "panel", "items": short_name4665, "labelAlign": "top" }, { "flex": 64, "autoHeight": true, "layout": "form", "xtype": "panel", "items": confirmation_type4666, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var name4671 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Bezeichnung", "name": "name", "maxLength": 200, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var name_fr4672 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Bezeichnung (fr)", "name": "name_fr", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var name_de4673 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Bezeichnung (de)", "name": "name_de", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var name_nl4674 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Bezeichnung (nl)", "name": "name_nl", "maxLength": 200, "selectOnFocus": true, "hidden": true, "anchor": "-20" });
    var main_2_panel4675 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 153, "hideCheckBoxLabels": true, "items": [ { "flex": 25, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name4671, "labelAlign": "top" }, { "flex": 25, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_fr4672, "labelAlign": "top" }, { "flex": 25, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_de4673, "labelAlign": "top" }, { "flex": 25, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_nl4674, "hidden": true, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var excerpt_title4680 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Auszugstitel</span>", "name": "excerpt_title", "maxLength": 200, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Auszugstitel","The title to be used when printing confirmation excerpts.") }, "anchor": "-20" });
    var excerpt_title_fr4681 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Auszugstitel (fr)", "name": "excerpt_title_fr", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var excerpt_title_de4682 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Auszugstitel (de)", "name": "excerpt_title_de", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var excerpt_title_nl4683 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Auszugstitel (nl)", "name": "excerpt_title_nl", "maxLength": 200, "selectOnFocus": true, "hidden": true, "anchor": "-20" });
    var main_3_panel4684 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 162, "hideCheckBoxLabels": true, "items": [ { "flex": 25, "autoHeight": true, "layout": "form", "xtype": "panel", "items": excerpt_title4680, "labelAlign": "top" }, { "flex": 25, "autoHeight": true, "layout": "form", "xtype": "panel", "items": excerpt_title_fr4681, "labelAlign": "top" }, { "flex": 25, "autoHeight": true, "layout": "form", "xtype": "panel", "items": excerpt_title_de4682, "labelAlign": "top" }, { "flex": 25, "autoHeight": true, "layout": "form", "xtype": "panel", "items": excerpt_title_nl4683, "hidden": true, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var print_directly4689 = new Ext.form.Checkbox({ "boxLabel": "Direkt drucken", "autoHeight": true, "hideLabel": true, "checked": true, "name": "print_directly", "selectOnFocus": true, "anchor": "-20" });
    var is_integ_duty4690 = new Ext.form.Checkbox({ "autoHeight": true, "hideLabel": true, "checked": false, "name": "is_integ_duty", "listeners": { "render": Lino.quicktip_renderer("Verpflichtung DSBE","Whether aid grantings of this type are considered as duty for integration contract.") }, "boxLabel": "Verpflichtung DSBE", "selectOnFocus": true, "anchor": "-20" });
    var is_urgent4691 = new Ext.form.Checkbox({ "autoHeight": true, "hideLabel": true, "checked": false, "name": "is_urgent", "listeners": { "render": Lino.quicktip_renderer("Urgent","Whether aid grantings of this type are considered as urgent.") }, "boxLabel": "Urgent", "selectOnFocus": true, "anchor": "-20" });
    var confirmed_by_primary_coach4692 = new Ext.form.Checkbox({ "boxLabel": "Prim\u00e4rbegleiter best\u00e4tigt", "autoHeight": true, "hideLabel": true, "checked": true, "name": "confirmed_by_primary_coach", "selectOnFocus": true, "anchor": "-20" });
    var board4693 = new Lino.TwinCombo({ "autoHeight": true, "fieldLabel": "Gremium", "name": "board", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.boards.Boards.detail,Lino.boards.Boards.insert)}, "emptyText": "Gremium ausw\u00e4hlen...", "selectOnFocus": true, "hiddenName": "boardHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/aids/AidTypes/board", "method": "GET" }) }) });
    var body_template4694 = new Lino.SimpleRemoteComboFieldElement({ "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Textk\u00f6rper-Vorlage</span>", "name": "body_template", "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Textk\u00f6rper-Vorlage","The body template to use instead of the default body template as defined for the excerpt type.") }, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/aids/AidTypes/body_template", "method": "GET" }) }), "anchor": "-20" });
    var main_4_panel4695 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 234, "hideCheckBoxLabels": true, "items": [ { "flex": 14, "autoHeight": true, "layout": "form", "xtype": "panel", "items": print_directly4689, "labelAlign": "top" }, { "flex": 14, "autoHeight": true, "layout": "form", "xtype": "panel", "items": is_integ_duty4690, "labelAlign": "top" }, { "flex": 14, "autoHeight": true, "layout": "form", "xtype": "panel", "items": is_urgent4691, "labelAlign": "top" }, { "flex": 14, "autoHeight": true, "layout": "form", "xtype": "panel", "items": confirmed_by_primary_coach4692, "labelAlign": "top" }, { "flex": 28, "autoHeight": true, "layout": "form", "xtype": "panel", "items": board4693, "labelAlign": "top" }, { "flex": 14, "autoHeight": true, "layout": "form", "xtype": "panel", "items": body_template4694, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var company4702 = new Lino.TwinCombo({ "preferred_width": 20, "autoHeight": true, "fieldLabel": "Organisation", "name": "company", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.contacts.Companies.detail,Lino.contacts.Companies.insert)}, "hiddenName": "companyHidden", "selectOnFocus": true, "emptyText": "Organisation ausw\u00e4hlen...", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/aids/AidTypes/company", "method": "GET" }) }) });
    var contact_person4703 = new Lino.TwinCombo({ "preferred_width": 20, "autoHeight": true, "fieldLabel": "Vertreten durch", "name": "contact_person", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.contacts.Persons.detail,Lino.contacts.Persons.insert)}, "hiddenName": "contact_personHidden", "selectOnFocus": true, "emptyText": "Person ausw\u00e4hlen...", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/aids/AidTypes/contact_person", "method": "GET" }) }) });
    var contact_role4704 = new Lino.RemoteComboFieldElement({ "autoHeight": true, "fieldLabel": "in seiner Eigenschaft als", "name": "contact_role", "pageSize": 20, "emptyText": "Funktion ausw\u00e4hlen...", "selectOnFocus": true, "hiddenName": "contact_roleHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/aids/AidTypes/contact_role", "method": "GET" }) }) });
    var pharmacy_type4705 = new Lino.TwinCombo({ "autoHeight": true, "fieldLabel": "Klientenkontaktart", "name": "pharmacy_type", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.pcsw.ClientContactTypes.detail,Lino.pcsw.ClientContactTypes.insert)}, "emptyText": "Klientenkontaktart ausw\u00e4hlen...", "selectOnFocus": true, "hiddenName": "pharmacy_typeHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/aids/AidTypes/pharmacy_type", "method": "GET" }) }) });
    var main_5_panel4706 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 234, "hideCheckBoxLabels": true, "items": [ { "flex": 25, "autoHeight": true, "layout": "form", "xtype": "panel", "items": company4702, "labelAlign": "top" }, { "flex": 25, "autoHeight": true, "layout": "form", "xtype": "panel", "items": contact_person4703, "labelAlign": "top" }, { "flex": 25, "autoHeight": true, "layout": "form", "xtype": "panel", "items": contact_role4704, "labelAlign": "top" }, { "flex": 25, "autoHeight": true, "layout": "form", "xtype": "panel", "items": pharmacy_type4705, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var aids_GrantingsByType_grid4740 = new Lino.aids.GrantingsByType.GridPanel({ "flex": 50, "hide_top_toolbar": true, "containing_panel": this, "tools": [ Lino.show_in_own_window_button(Lino.aids.GrantingsByType.grid) ], "preview_limit": 15, "master_panel": this });
    var main_panel4741 = new Ext.Panel({ "autoScroll": false, "border": false, "layout": "vbox", "hideCheckBoxLabels": true, "items": [ main_1_panel4667, main_2_panel4675, main_3_panel4684, main_4_panel4695, main_5_panel4706, aids_GrantingsByType_grid4740 ], "frame": true, "layoutConfig": { "align": "stretch" }, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel4741;
    this.before_row_edit = function(record) {
      body_template4694.setContextValue('confirmation_type', record ? record.data['confirmation_typeHidden'] : undefined);
      contact_person4703.setContextValue('company', record ? record.data['companyHidden'] : undefined);
      aids_GrantingsByType_grid4740.on_master_changed();
    }
    this.onRender = function(ct, position) {
      confirmation_type4666.on('change',Lino.chooser_handler(body_template4694,'confirmation_type'));
      company4702.on('change',Lino.chooser_handler(contact_person4703,'company'));
      Lino.aids.AidTypes.DetailFormPanel.superclass.onRender.call(this, ct, position);
    }
    Lino.aids.AidTypes.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.debts.Budgets.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 107,
  initComponent : function() {
    var date300 = new Lino.DateField({ "selectOnFocus": true, "autoHeight": true, "fieldLabel": "Datum", "anchor": "-20", "name": "date" });
    var partner301 = new Lino.TwinCombo({ "preferred_width": 20, "autoHeight": true, "fieldLabel": "Partner", "allowBlank": false, "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.contacts.Partners.detail,Lino.contacts.Partners.insert)}, "emptyText": "Partner ausw\u00e4hlen...", "selectOnFocus": true, "hiddenName": "partnerHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/debts/Budgets/partner", "method": "GET" }) }), "name": "partner" });
    var id302 = new Ext.form.NumberField({ "selectOnFocus": true, "autoHeight": true, "fieldLabel": "ID", "anchor": "-20", "name": "id" });
    var user303 = new Lino.TwinCombo({ "preferred_width": 15, "autoHeight": true, "fieldLabel": "Autor", "name": "user", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.users.Users.detail,Lino.users.Users.insert)}, "hiddenName": "userHidden", "selectOnFocus": true, "emptyText": "Benutzer ausw\u00e4hlen...", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/debts/Budgets/user", "method": "GET" }) }) });
    var general_1_panel304 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 22, "autoHeight": true, "layout": "form", "xtype": "panel", "items": date300, "labelAlign": "top" }, { "flex": 34, "autoHeight": true, "layout": "form", "xtype": "panel", "items": partner301, "labelAlign": "top" }, { "flex": 8, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id302, "labelAlign": "top" }, { "flex": 34, "autoHeight": true, "layout": "form", "xtype": "panel", "items": user303, "labelAlign": "top" } ], "region": "north", "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "split": true, "autoScroll": false, "labelWidth": 72, "border": false, "frame": false, "labelAlign": "top" });
    var intro309 = new Lino.RichTextPanel({ "flex": 5, "split": true, "containing_panel": this, "selectOnFocus": true, "region": "center", "title": "Einleitung", "name": "intro" });
    var ActorsByBudget_grid316 = new Lino.debts.ActorsByBudget.GridPanel({ "flex": 5, "hide_top_toolbar": true, "containing_panel": this, "region": "south", "preview_limit": 15, "master_panel": this, "listeners": { "render": Lino.quicktip_renderer("Budget-Akteure","To be filled if there is more than one person involved.") }, "split": true, "tools": [ Lino.show_in_own_window_button(Lino.debts.ActorsByBudget.grid) ] });
    var general_panel317 = new Lino.VBorderPanel({ "autoScroll": false, "listeners": { "activate": Lino.on_tab_activate }, "border": false, "labelWidth": 0, "title": "Allgemein", "hideCheckBoxLabels": true, "items": [ general_1_panel304, intro309, ActorsByBudget_grid316 ], "frame": true, "bodyBorder": false, "labelAlign": "top" });
    var ExpensesByBudget_grid318 = new Lino.debts.ExpensesByBudget.GridPanel({ "flex": 5, "hide_top_toolbar": true, "containing_panel": this, "region": "north", "preview_limit": 15, "master_panel": this, "split": true, "tools": [ Lino.show_in_own_window_button(Lino.debts.ExpensesByBudget.grid) ] });
    var IncomesByBudget_grid330 = new Lino.debts.IncomesByBudget.GridPanel({ "flex": 5, "hide_top_toolbar": true, "containing_panel": this, "region": "center", "preview_limit": 15, "master_panel": this, "split": true, "tools": [ Lino.show_in_own_window_button(Lino.debts.IncomesByBudget.grid) ] });
    var entries1_panel331 = new Lino.VBorderPanel({ "autoScroll": false, "listeners": { "activate": Lino.on_tab_activate }, "border": false, "title": "Ausgaben und Eink\u00fcnfte", "hideCheckBoxLabels": true, "items": [ ExpensesByBudget_grid318, IncomesByBudget_grid330 ], "frame": true, "bodyBorder": false, "labelAlign": "top" });
    var LiabilitiesByBudget_grid345 = new Lino.debts.LiabilitiesByBudget.GridPanel({ "flex": 5, "hide_top_toolbar": true, "containing_panel": this, "region": "north", "preview_limit": 15, "master_panel": this, "split": true, "tools": [ Lino.show_in_own_window_button(Lino.debts.LiabilitiesByBudget.grid) ] });
    var AssetsByBudget_grid355 = new Lino.debts.AssetsByBudget.GridPanel({ "flex": 5, "hide_top_toolbar": true, "containing_panel": this, "region": "center", "preview_limit": 15, "master_panel": this, "split": true, "tools": [ Lino.show_in_own_window_button(Lino.debts.AssetsByBudget.grid) ] });
    var entries2_panel356 = new Lino.VBorderPanel({ "autoScroll": false, "listeners": { "activate": Lino.on_tab_activate }, "border": false, "title": "Verpflichtungen & Verm\u00f6gen", "hideCheckBoxLabels": true, "items": [ LiabilitiesByBudget_grid345, AssetsByBudget_grid355 ], "frame": true, "bodyBorder": false, "labelAlign": "top" });
    var ResultByBudget_htmlbox357 = new Lino.HtmlBoxPanel({ "flex": 3, "layout": "fit", "name": "ResultByBudget", "containing_panel": this, "items": new Ext.BoxComponent({autoScroll:true}), "region": "north", "title": "Einnahmen & Ausgaben", "master_panel": this, "value": "<br/>", "always_enabled": true, "listeners": { "render": Lino.quicktip_renderer("Einnahmen & Ausgaben","Shows the Incomes & Expenses for this budget.") }, "bodyStyle": "overflow-x:hidden;", "split": true, "tools": [ Lino.show_in_own_window_button(Lino.debts.ResultByBudget.grid) ] });
    var DebtsByBudget_htmlbox358 = new Lino.HtmlBoxPanel({ "flex": 3, "layout": "fit", "name": "DebtsByBudget", "containing_panel": this, "items": new Ext.BoxComponent({autoScroll:true}), "region": "center", "title": "Schulden", "master_panel": this, "value": "<br/>", "always_enabled": true, "bodyStyle": "overflow-x:hidden;", "split": true, "tools": [ Lino.show_in_own_window_button(Lino.debts.DebtsByBudget.grid) ] });
    var BailiffDebtsByBudget_htmlbox359 = new Lino.HtmlBoxPanel({ "flex": 3, "layout": "fit", "name": "BailiffDebtsByBudget", "containing_panel": this, "items": new Ext.BoxComponent({autoScroll:true}), "region": "south", "title": "Schulden (Gerichtsvollzieher)", "master_panel": this, "value": "<br/>", "always_enabled": true, "bodyStyle": "overflow-x:hidden;", "split": true, "tools": [ Lino.show_in_own_window_button(Lino.debts.BailiffDebtsByBudget.grid) ] });
    var summary1_panel360 = new Lino.VBorderPanel({ "flex": 42, "border": false, "labelWidth": 270, "hideCheckBoxLabels": true, "items": [ ResultByBudget_htmlbox357, DebtsByBudget_htmlbox358, BailiffDebtsByBudget_htmlbox359 ], "frame": true, "autoScroll": false, "bodyBorder": false, "labelAlign": "top" });
    var conclusion361 = new Lino.RichTextPanel({ "selectOnFocus": true, "flex": 55, "containing_panel": this, "name": "conclusion", "title": "Schlussfolgerung" });
    var dist_amount362 = new Ext.form.NumberField({ "autoHeight": true, "decimalPrecision": 2, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Verteilbarer Betrag</span>", "name": "dist_amount", "decimalSeparator": ",", "value": 120, "listeners": { "render": Lino.quicktip_renderer("Verteilbarer Betrag","Der monatlich verf\u00fcgbare Gesamtbetrag f\u00fcr Tabelle Schuldenverteilung.") }, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var printed_disp363 = new Ext.form.DisplayField({ "disabled": true, "autoHeight": true, "fieldLabel": "Ausgedruckt", "name": "printed", "anchor": "-20", "value": "<br/>", "always_enabled": true });
    var total_debt364 = new Ext.form.NumberField({ "disabled": true, "autoHeight": true, "decimalPrecision": 2, "fieldLabel": "Gesamtschuld", "name": "total_debt", "decimalSeparator": ",", "anchor": "-20" });
    var summary2_2_panel365 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 180, "hideCheckBoxLabels": true, "items": [ { "flex": 22, "autoHeight": true, "layout": "form", "xtype": "panel", "items": dist_amount362, "labelAlign": "top" }, { "flex": 55, "autoHeight": true, "layout": "form", "xtype": "panel", "items": printed_disp363, "labelAlign": "top" }, { "flex": 22, "autoHeight": true, "layout": "form", "xtype": "panel", "items": total_debt364, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var include_yearly_incomes369 = new Ext.form.Checkbox({ "autoHeight": true, "hideLabel": true, "checked": false, "name": "include_yearly_incomes", "listeners": { "render": Lino.quicktip_renderer("J\u00e4hrliche Einkommen ber\u00fccksichtigen","Check this to include yearly incomes in the Debts Overview table of this Budget.") }, "boxLabel": "J\u00e4hrliche Einkommen ber\u00fccksichtigen", "selectOnFocus": true, "anchor": "-20" });
    var print_empty_rows370 = new Ext.form.Checkbox({ "autoHeight": true, "hideLabel": true, "checked": false, "name": "print_empty_rows", "listeners": { "render": Lino.quicktip_renderer("Auch leere Eintr\u00e4ge drucken","Check this to print also empty rows for later completion.") }, "boxLabel": "Auch leere Eintr\u00e4ge drucken", "selectOnFocus": true, "anchor": "-20" });
    var print_todos371 = new Ext.form.Checkbox({ "autoHeight": true, "hideLabel": true, "checked": false, "name": "print_todos", "listeners": { "render": Lino.quicktip_renderer("To-do-Liste drucken","Eintr\u00e4ge im Feld \"To-do\" werden nur ausgedruckt, \nwenn die Option \"To-dos drucken\" des Budgets angekreuzt ist. \nDiese Option wird aber momentan noch ignoriert \n(d.h. To-do-Liste wird gar nicht ausgedruckt), \nweil wir noch \u00fcberlegen m\u00fcssen, *wie* sie ausgedruckt werden sollen. \nVielleicht mit Fu\u00dfnoten?") }, "boxLabel": "To-do-Liste drucken", "selectOnFocus": true, "anchor": "-20" });
    var summary2_3_panel372 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 324, "hideCheckBoxLabels": true, "items": [ { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": include_yearly_incomes369, "labelAlign": "top" }, { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": print_empty_rows370, "labelAlign": "top" }, { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": print_todos371, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var summary2_panel376 = new Ext.Panel({ "flex": 57, "layout": "vbox", "items": [ conclusion361, summary2_2_panel365, summary2_3_panel372 ], "frame": true, "layoutConfig": { "align": "stretch" }, "autoScroll": false, "hideCheckBoxLabels": true, "labelWidth": 0, "border": false, "bodyBorder": false, "labelAlign": "top" });
    var summary_tab_1_panel377 = new Ext.Panel({ "flex": 9, "layout": "hbox", "items": [ summary1_panel360, summary2_panel376 ], "region": "north", "layoutConfig": { "align": "stretch" }, "hideCheckBoxLabels": true, "split": true, "autoScroll": false, "border": false, "frame": false, "labelAlign": "top" });
    var DistByBudget_htmlbox378 = new Lino.HtmlBoxPanel({ "flex": 3, "layout": "fit", "name": "DistByBudget", "containing_panel": this, "items": new Ext.BoxComponent({autoScroll:true}), "region": "center", "title": "Schuldenverteilung", "master_panel": this, "value": "<br/>", "always_enabled": true, "listeners": { "render": Lino.quicktip_renderer("Schuldenverteilung","R\u00e9partition au marc-le-franc.\nA table with one row per entry in Liabilities which has \"distribute\" checked,\nproportionally distributing the `Distributable amount` among the debtors.\n") }, "bodyStyle": "overflow-x:hidden;", "split": true, "tools": [ Lino.show_in_own_window_button(Lino.debts.DistByBudget.grid) ] });
    var summary_tab_panel379 = new Lino.VBorderPanel({ "autoScroll": false, "listeners": { "activate": Lino.on_tab_activate }, "border": false, "labelWidth": 171, "title": "Zusammenfassung", "hideCheckBoxLabels": true, "items": [ summary_tab_1_panel377, DistByBudget_htmlbox378 ], "frame": true, "bodyBorder": false, "labelAlign": "top" });
    var data_box_htmlbox380 = new Lino.HtmlBoxPanel({ "flex": 3, "layout": "fit", "name": "data_box", "containing_panel": this, "items": new Ext.BoxComponent({autoScroll:true}), "region": "north", "title": "Erfasste Daten", "value": "<br/>", "always_enabled": true, "bodyStyle": "overflow-x:hidden;", "split": true });
    var summary_box_htmlbox381 = new Lino.HtmlBoxPanel({ "flex": 3, "layout": "fit", "name": "summary_box", "containing_panel": this, "items": new Ext.BoxComponent({autoScroll:true}), "region": "center", "title": "Zusammenfassung", "value": "<br/>", "always_enabled": true, "bodyStyle": "overflow-x:hidden;", "split": true });
    var preview_tab_panel382 = new Lino.VBorderPanel({ "autoScroll": false, "listeners": { "activate": Lino.on_tab_activate }, "border": false, "labelWidth": 144, "title": "Vorschau", "hideCheckBoxLabels": true, "items": [ data_box_htmlbox380, summary_box_htmlbox381 ], "frame": true, "bodyBorder": false, "labelAlign": "top" });
    var main_panel383 = new Ext.TabPanel({ "hideCheckBoxLabels": true, "border": false, "split": true, "autoScroll": false, "items": [ general_panel317, entries1_panel331, entries2_panel356, summary_tab_panel379, preview_tab_panel382 ], "activeTab": 0, "bodyBorder": false, "frame": true, "labelAlign": "top" });
    this.items = main_panel383;
    this.before_row_edit = function(record) {
      intro309.refresh();
      ActorsByBudget_grid316.on_master_changed();
      ExpensesByBudget_grid318.on_master_changed();
      IncomesByBudget_grid330.on_master_changed();
      LiabilitiesByBudget_grid345.on_master_changed();
      AssetsByBudget_grid355.on_master_changed();
      ResultByBudget_htmlbox357.refresh();
      DebtsByBudget_htmlbox358.refresh();
      BailiffDebtsByBudget_htmlbox359.refresh();
      conclusion361.refresh();
      DistByBudget_htmlbox378.refresh();
      data_box_htmlbox380.refresh();
      summary_box_htmlbox381.refresh();
    }
    Lino.debts.Budgets.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.aids.Grantings.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 113,
  initComponent : function() {
    var id3422 = new Ext.form.NumberField({ "selectOnFocus": true, "autoHeight": true, "fieldLabel": "ID", "anchor": "-20", "name": "id" });
    var client3423 = new Lino.TwinCombo({ "preferred_width": 20, "autoHeight": true, "fieldLabel": "Klient", "allowBlank": false, "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.pcsw.Clients.detail,Lino.pcsw.Clients.insert)}, "emptyText": "Klient ausw\u00e4hlen...", "selectOnFocus": true, "hiddenName": "clientHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/aids/Grantings/client", "method": "GET" }) }), "name": "client" });
    var user3424 = new Lino.TwinCombo({ "preferred_width": 15, "autoHeight": true, "fieldLabel": "Autor", "name": "user", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.users.Users.detail,Lino.users.Users.insert)}, "hiddenName": "userHidden", "selectOnFocus": true, "emptyText": "Benutzer ausw\u00e4hlen...", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/aids/Grantings/user", "method": "GET" }) }) });
    var signer3425 = new Lino.TwinCombo({ "preferred_width": 15, "autoHeight": true, "fieldLabel": "Best\u00e4tiger", "name": "signer", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.users.Users.detail,Lino.users.Users.insert)}, "hiddenName": "signerHidden", "selectOnFocus": true, "emptyText": "Benutzer ausw\u00e4hlen...", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/aids/Grantings/signer", "method": "GET" }) }) });
    var workflow_buttons_disp3426 = new Ext.form.DisplayField({ "disabled": true, "autoHeight": true, "fieldLabel": "Arbeitsablauf", "name": "workflow_buttons", "anchor": "-20", "value": "<br/>", "always_enabled": true });
    var main_1_panel3427 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 126, "hideCheckBoxLabels": true, "items": [ { "flex": 5, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id3422, "labelAlign": "top" }, { "flex": 21, "autoHeight": true, "layout": "form", "xtype": "panel", "items": client3423, "labelAlign": "top" }, { "flex": 21, "autoHeight": true, "layout": "form", "xtype": "panel", "items": user3424, "labelAlign": "top" }, { "flex": 21, "autoHeight": true, "layout": "form", "xtype": "panel", "items": signer3425, "labelAlign": "top" }, { "flex": 31, "autoHeight": true, "layout": "form", "xtype": "panel", "items": workflow_buttons_disp3426, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var board3433 = new Lino.TwinCombo({ "autoHeight": true, "fieldLabel": "Gremium", "name": "board", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.boards.Boards.detail,Lino.boards.Boards.insert)}, "emptyText": "Gremium ausw\u00e4hlen...", "selectOnFocus": true, "hiddenName": "boardHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/aids/Grantings/board", "method": "GET" }) }) });
    var decision_date3434 = new Lino.DateField({ "selectOnFocus": true, "autoHeight": true, "fieldLabel": "Beschlossen", "anchor": "-20", "name": "decision_date" });
    var main_2_panel3435 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 108, "hideCheckBoxLabels": true, "items": [ { "flex": 60, "autoHeight": true, "layout": "form", "xtype": "panel", "items": board3433, "labelAlign": "top" }, { "flex": 39, "autoHeight": true, "layout": "form", "xtype": "panel", "items": decision_date3434, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var aid_type3438 = new Lino.TwinCombo({ "autoHeight": true, "fieldLabel": "Hilfeart", "allowBlank": false, "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.aids.AidTypes.detail,Lino.aids.AidTypes.insert)}, "emptyText": "Hilfeart ausw\u00e4hlen...", "selectOnFocus": true, "hiddenName": "aid_typeHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/aids/Grantings/aid_type", "method": "GET" }) }), "name": "aid_type" });
    var start_date3439 = new Lino.DateField({ "autoHeight": true, "fieldLabel": "Laufzeit von", "name": "start_date", "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var end_date3440 = new Lino.DateField({ "selectOnFocus": true, "autoHeight": true, "fieldLabel": "bis", "anchor": "-20", "name": "end_date" });
    var custom_actions_disp3441 = new Ext.form.DisplayField({ "disabled": true, "autoHeight": true, "fieldLabel": "Aktionen", "name": "custom_actions", "anchor": "-20", "value": "<br/>", "always_enabled": true });
    var main_3_panel3442 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 117, "hideCheckBoxLabels": true, "items": [ { "flex": 26, "autoHeight": true, "layout": "form", "xtype": "panel", "items": aid_type3438, "labelAlign": "top" }, { "flex": 17, "autoHeight": true, "layout": "form", "xtype": "panel", "items": start_date3439, "labelAlign": "top" }, { "flex": 17, "autoHeight": true, "layout": "form", "xtype": "panel", "items": end_date3440, "labelAlign": "top" }, { "flex": 39, "autoHeight": true, "layout": "form", "xtype": "panel", "items": custom_actions_disp3441, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var aids_ConfirmationsByGranting_grid3455 = new Lino.aids.ConfirmationsByGranting.GridPanel({ "flex": 41, "hide_top_toolbar": true, "containing_panel": this, "tools": [ Lino.show_in_own_window_button(Lino.aids.ConfirmationsByGranting.grid) ], "preview_limit": 15, "master_panel": this });
    var main_panel3456 = new Ext.Panel({ "autoScroll": false, "border": false, "layout": "vbox", "hideCheckBoxLabels": true, "items": [ main_1_panel3427, main_2_panel3435, main_3_panel3442, aids_ConfirmationsByGranting_grid3455 ], "frame": true, "layoutConfig": { "align": "stretch" }, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel3456;
    this.before_row_edit = function(record) {
      board3433.setContextValue('decision_date', record ? record.data['decision_date'] : undefined);
      aids_ConfirmationsByGranting_grid3455.on_master_changed();
    }
    this.onRender = function(ct, position) {
      decision_date3434.on('change',Lino.chooser_handler(board3433,'decision_date'));
      Lino.aids.Grantings.DetailFormPanel.superclass.onRender.call(this, ct, position);
    }
    Lino.aids.Grantings.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.jobs.Contracts.InsertFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  autoHeight: true,
  content_type: 84,
  initComponent : function() {
    var client2654 = new Lino.TwinCombo({ "preferred_width": 20, "autoHeight": true, "fieldLabel": "Klient", "allowBlank": false, "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.pcsw.Clients.detail,Lino.pcsw.Clients.insert)}, "emptyText": "Klient ausw\u00e4hlen...", "selectOnFocus": true, "hiddenName": "clientHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/jobs/Contracts/client", "method": "GET" }) }), "name": "client" });
    var job2655 = new Lino.TwinCombo({ "preferred_width": 20, "autoHeight": true, "fieldLabel": "Stelle", "allowBlank": false, "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.jobs.Jobs.detail,Lino.jobs.Jobs.insert)}, "emptyText": "Stelle ausw\u00e4hlen...", "selectOnFocus": true, "hiddenName": "jobHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/jobs/Contracts/job", "method": "GET" }) }), "name": "job" });
    var main_panel2656 = new Ext.Panel({ "hideCheckBoxLabels": true, "autoHeight": true, "border": false, "layout": "form", "labelWidth": 63, "autoScroll": false, "items": [ { "autoHeight": true, "layout": "form", "xtype": "panel", "items": client2654, "anchor": "-20", "labelAlign": "top" }, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": job2655, "anchor": "-20", "labelAlign": "top" } ], "frame": true, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel2656;
    this.before_row_edit = function(record) {
    }
    Lino.jobs.Contracts.InsertFormPanel.superclass.initComponent.call(this);
  }
});


Lino.notes.EventTypes.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 110,
  initComponent : function() {
    var id2777 = new Ext.form.NumberField({ "selectOnFocus": true, "autoHeight": true, "fieldLabel": "ID", "anchor": "-20", "name": "id" });
    var name2778 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Bezeichnung", "name": "name", "maxLength": 200, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var name_fr2779 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Bezeichnung (fr)", "name": "name_fr", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var name_de2780 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Bezeichnung (de)", "name": "name_de", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var name_nl2781 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Bezeichnung (nl)", "name": "name_nl", "maxLength": 200, "selectOnFocus": true, "hidden": true, "anchor": "-20" });
    var main_1_panel2782 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 5, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id2777, "labelAlign": "top" }, { "flex": 23, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name2778, "labelAlign": "top" }, { "flex": 23, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_fr2779, "labelAlign": "top" }, { "flex": 23, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_de2780, "labelAlign": "top" }, { "flex": 23, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_nl2781, "hidden": true, "labelAlign": "top" } ], "region": "north", "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "split": true, "autoScroll": false, "labelWidth": 153, "border": false, "frame": false, "labelAlign": "top" });
    var remark2788 = new Ext.form.TextArea({ "selectOnFocus": true, "fieldLabel": "Bemerkung", "anchor": "-20 -10", "growMax": 2000, "name": "remark" });
    var notes_NotesByEventType_grid2806 = new Lino.notes.NotesByEventType.GridPanel({ "flex": 6, "hide_top_toolbar": true, "containing_panel": this, "region": "south", "preview_limit": 15, "master_panel": this, "split": true, "tools": [ Lino.show_in_own_window_button(Lino.notes.NotesByEventType.grid) ] });
    var main_panel2807 = new Lino.VBorderPanel({ "autoScroll": false, "border": false, "labelWidth": 90, "hideCheckBoxLabels": true, "items": [ main_1_panel2782, { "flex": 3, "layout": "form", "xtype": "panel", "items": remark2788, "region": "center", "labelAlign": "top", "split": true }, notes_NotesByEventType_grid2806 ], "frame": true, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel2807;
    this.before_row_edit = function(record) {
      notes_NotesByEventType_grid2806.on_master_changed();
    }
    Lino.notes.EventTypes.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.aids.Grantings.InsertFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  autoHeight: true,
  content_type: 113,
  initComponent : function() {
    var client4722 = new Lino.TwinCombo({ "preferred_width": 20, "autoHeight": true, "fieldLabel": "Klient", "allowBlank": false, "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.pcsw.Clients.detail,Lino.pcsw.Clients.insert)}, "emptyText": "Klient ausw\u00e4hlen...", "selectOnFocus": true, "hiddenName": "clientHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/aids/Grantings/client", "method": "GET" }) }), "name": "client" });
    var aid_type4723 = new Lino.TwinCombo({ "autoHeight": true, "fieldLabel": "Hilfeart", "allowBlank": false, "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.aids.AidTypes.detail,Lino.aids.AidTypes.insert)}, "emptyText": "Hilfeart ausw\u00e4hlen...", "selectOnFocus": true, "hiddenName": "aid_typeHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/aids/Grantings/aid_type", "method": "GET" }) }), "name": "aid_type" });
    var signer4724 = new Lino.TwinCombo({ "preferred_width": 15, "autoHeight": true, "fieldLabel": "Best\u00e4tiger", "name": "signer", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.users.Users.detail,Lino.users.Users.insert)}, "hiddenName": "signerHidden", "selectOnFocus": true, "emptyText": "Benutzer ausw\u00e4hlen...", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/aids/Grantings/signer", "method": "GET" }) }) });
    var main_2_panel4725 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": aid_type4723, "labelAlign": "top" }, { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": signer4724, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 99, "border": false, "anchor": "-20", "labelAlign": "top" });
    var board4728 = new Lino.TwinCombo({ "autoHeight": true, "fieldLabel": "Gremium", "name": "board", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.boards.Boards.detail,Lino.boards.Boards.insert)}, "emptyText": "Gremium ausw\u00e4hlen...", "selectOnFocus": true, "hiddenName": "boardHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/aids/Grantings/board", "method": "GET" }) }) });
    var decision_date4729 = new Lino.DateField({ "selectOnFocus": true, "autoHeight": true, "fieldLabel": "Beschlossen", "anchor": "-20", "name": "decision_date" });
    var main_3_panel4730 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 60, "autoHeight": true, "layout": "form", "xtype": "panel", "items": board4728, "labelAlign": "top" }, { "flex": 39, "autoHeight": true, "layout": "form", "xtype": "panel", "items": decision_date4729, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 108, "border": false, "anchor": "-20", "labelAlign": "top" });
    var start_date4733 = new Lino.DateField({ "autoHeight": true, "fieldLabel": "Laufzeit von", "name": "start_date", "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var end_date4734 = new Lino.DateField({ "selectOnFocus": true, "autoHeight": true, "fieldLabel": "bis", "anchor": "-20", "name": "end_date" });
    var main_4_panel4735 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": start_date4733, "labelAlign": "top" }, { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": end_date4734, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 117, "border": false, "anchor": "-20", "labelAlign": "top" });
    var main_panel4738 = new Ext.Panel({ "hideCheckBoxLabels": true, "autoHeight": true, "border": false, "layout": "form", "labelWidth": 63, "autoScroll": false, "items": [ { "autoHeight": true, "layout": "form", "xtype": "panel", "items": client4722, "anchor": "-20", "labelAlign": "top" }, main_2_panel4725, main_3_panel4730, main_4_panel4735 ], "frame": true, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel4738;
    this.before_row_edit = function(record) {
      board4728.setContextValue('decision_date', record ? record.data['decision_date'] : undefined);
    }
    this.onRender = function(ct, position) {
      decision_date4729.on('change',Lino.chooser_handler(board4728,'decision_date'));
      Lino.aids.Grantings.InsertFormPanel.superclass.onRender.call(this, ct, position);
    }
    Lino.aids.Grantings.InsertFormPanel.superclass.initComponent.call(this);
  }
});


Lino.isip.ContractTypes.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 76,
  initComponent : function() {
    var id2809 = new Ext.form.NumberField({ "selectOnFocus": true, "autoHeight": true, "fieldLabel": "ID", "anchor": "-20", "name": "id" });
    var ref2810 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Referenz", "name": "ref", "maxLength": 20, "selectOnFocus": true, "anchor": "-20" });
    var exam_policy2811 = new Lino.TwinCombo({ "autoHeight": true, "fieldLabel": "Auswertungsstrategie", "name": "exam_policy", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.isip.ExamPolicies.detail,Lino.isip.ExamPolicies.insert)}, "emptyText": "Auswertungsstrategie ausw\u00e4hlen...", "selectOnFocus": true, "hiddenName": "exam_policyHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/isip/ContractTypes/exam_policy", "method": "GET" }) }) });
    var needs_study_type2812 = new Ext.form.Checkbox({ "boxLabel": "erfordert Ausbildungsart ", "autoHeight": true, "hideLabel": true, "checked": false, "name": "needs_study_type", "selectOnFocus": true, "anchor": "-20" });
    var main_1_panel2813 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 234, "hideCheckBoxLabels": true, "items": [ { "flex": 8, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id2809, "labelAlign": "top" }, { "flex": 37, "autoHeight": true, "layout": "form", "xtype": "panel", "items": ref2810, "labelAlign": "top" }, { "flex": 35, "autoHeight": true, "layout": "form", "xtype": "panel", "items": exam_policy2811, "labelAlign": "top" }, { "flex": 17, "autoHeight": true, "layout": "form", "xtype": "panel", "items": needs_study_type2812, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var name2818 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Bezeichnung", "name": "name", "maxLength": 200, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var name_fr2819 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Bezeichnung (fr)", "name": "name_fr", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var name_de2820 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Bezeichnung (de)", "name": "name_de", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var name_nl2821 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Bezeichnung (nl)", "name": "name_nl", "maxLength": 200, "selectOnFocus": true, "hidden": true, "anchor": "-20" });
    var main_2_panel2822 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 153, "hideCheckBoxLabels": true, "items": [ { "flex": 25, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name2818, "labelAlign": "top" }, { "flex": 25, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_fr2819, "labelAlign": "top" }, { "flex": 25, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_de2820, "labelAlign": "top" }, { "flex": 25, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_nl2821, "hidden": true, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var full_name2827 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Full name", "name": "full_name", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var ContractsByType_grid2845 = new Lino.isip.ContractsByType.GridPanel({ "flex": 62, "hide_top_toolbar": true, "containing_panel": this, "params_panel_hidden": true, "tools": [ Lino.show_in_own_window_button(Lino.isip.ContractsByType.grid) ], "master_panel": this, "preview_limit": 15 });
    var main_panel2846 = new Ext.Panel({ "autoScroll": false, "border": false, "layout": "vbox", "labelWidth": 90, "hideCheckBoxLabels": true, "items": [ main_1_panel2813, main_2_panel2822, { "items": full_name2827, "autoHeight": true, "layout": "form", "xtype": "panel", "labelAlign": "top" }, ContractsByType_grid2845 ], "frame": true, "layoutConfig": { "align": "stretch" }, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel2846;
    this.before_row_edit = function(record) {
      ContractsByType_grid2845.on_master_changed();
    }
    Lino.isip.ContractTypes.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.excerpts.ExcerptTypes.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 46,
  initComponent : function() {
    var id3996 = new Ext.form.NumberField({ "selectOnFocus": true, "autoHeight": true, "fieldLabel": "ID", "anchor": "-20", "name": "id" });
    var name3997 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Bezeichnung", "name": "name", "maxLength": 200, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var name_fr3998 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Bezeichnung (fr)", "name": "name_fr", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var name_de3999 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Bezeichnung (de)", "name": "name_de", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var name_nl4000 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Bezeichnung (nl)", "name": "name_nl", "maxLength": 200, "selectOnFocus": true, "hidden": true, "anchor": "-20" });
    var main_1_panel4001 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 153, "hideCheckBoxLabels": true, "items": [ { "flex": 5, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id3996, "labelAlign": "top" }, { "flex": 23, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name3997, "labelAlign": "top" }, { "flex": 23, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_fr3998, "labelAlign": "top" }, { "flex": 23, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_de3999, "labelAlign": "top" }, { "flex": 23, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_nl4000, "hidden": true, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var content_type4007 = new Lino.TwinCombo({ "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Modell</span>", "allowBlank": false, "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.contenttypes.ContentTypes.detail,Lino.contenttypes.ContentTypes.insert)}, "emptyText": "Datenbankmodell ausw\u00e4hlen...", "listeners": { "render": Lino.quicktip_renderer("Modell","The model that can issue printouts of this type.") }, "selectOnFocus": true, "hiddenName": "content_typeHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/excerpts/ExcerptTypes/content_type", "method": "GET" }) }), "name": "content_type" });
    var build_method4008 = new Lino.ChoicesFieldElement({ "autoHeight": true, "forceSelection": true, "fieldLabel": "Konstruktionsmethode", "name": "build_method", "hiddenName": "build_methodHidden", "selectOnFocus": true, "anchor": "-20", "store": [['','<br>']].concat(Lino.lino.BuildMethods) });
    var template4009 = new Lino.SimpleRemoteComboFieldElement({ "autoHeight": true, "fieldLabel": "Vorlage", "name": "template", "selectOnFocus": true, "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/excerpts/ExcerptTypes/template", "method": "GET" }) }) });
    var body_template4010 = new Lino.SimpleRemoteComboFieldElement({ "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Textk\u00f6rper-Vorlage</span>", "name": "body_template", "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Textk\u00f6rper-Vorlage","The body template to be used when         rendering a printable of this type. This is a list of files         with extension `.body.html`.") }, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/excerpts/ExcerptTypes/body_template", "method": "GET" }) }), "anchor": "-20" });
    var email_template4011 = new Lino.SimpleRemoteComboFieldElement({ "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">E-Mail-Vorlage</span>", "name": "email_template", "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("E-Mail-Vorlage","The name of the file to be used as template when creating an email from a mailable of this type.") }, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/excerpts/ExcerptTypes/email_template", "method": "GET" }) }), "anchor": "-20" });
    var shortcut4012 = new Lino.ChoicesFieldElement({ "autoHeight": true, "forceSelection": true, "fieldLabel": "Excerpt shortcut", "name": "shortcut", "hiddenName": "shortcutHidden", "selectOnFocus": true, "anchor": "-20", "store": [['','<br>']].concat(Lino.excerpts.Shortcuts) });
    var main_2_panel4013 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 189, "hideCheckBoxLabels": true, "items": [ { "flex": 16, "autoHeight": true, "layout": "form", "xtype": "panel", "items": content_type4007, "labelAlign": "top" }, { "flex": 16, "autoHeight": true, "layout": "form", "xtype": "panel", "items": build_method4008, "labelAlign": "top" }, { "flex": 16, "autoHeight": true, "layout": "form", "xtype": "panel", "items": template4009, "labelAlign": "top" }, { "flex": 16, "autoHeight": true, "layout": "form", "xtype": "panel", "items": body_template4010, "labelAlign": "top" }, { "flex": 16, "autoHeight": true, "layout": "form", "xtype": "panel", "items": email_template4011, "labelAlign": "top" }, { "flex": 15, "autoHeight": true, "layout": "form", "xtype": "panel", "items": shortcut4012, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var primary4020 = new Ext.form.Checkbox({ "autoHeight": true, "hideLabel": true, "checked": false, "name": "primary", "listeners": { "render": Lino.quicktip_renderer("Prim\u00e4r","There's at most one primary type per model.         Enabling this field will automatically make the other         types non-primary.") }, "boxLabel": "Prim\u00e4r", "selectOnFocus": true, "anchor": "-20" });
    var print_directly4021 = new Ext.form.Checkbox({ "boxLabel": "Direkt drucken", "autoHeight": true, "hideLabel": true, "checked": true, "name": "print_directly", "selectOnFocus": true, "anchor": "-20" });
    var certifying4022 = new Ext.form.Checkbox({ "autoHeight": true, "hideLabel": true, "checked": false, "name": "certifying", "listeners": { "render": Lino.quicktip_renderer("Bescheinigend","Ob Ausz\u00fcge dieser Art als einmalige Ausdrucke behandelt werden sollen.") }, "boxLabel": "Bescheinigend", "selectOnFocus": true, "anchor": "-20" });
    var print_recipient4023 = new Ext.form.Checkbox({ "autoHeight": true, "hideLabel": true, "checked": true, "name": "print_recipient", "listeners": { "render": Lino.quicktip_renderer("Empf\u00e4nger drucken","Whether to print a recipient field in document.") }, "boxLabel": "Empf\u00e4nger drucken", "selectOnFocus": true, "anchor": "-20" });
    var backward_compat4024 = new Ext.form.Checkbox({ "autoHeight": true, "hideLabel": true, "checked": false, "name": "backward_compat", "listeners": { "render": Lino.quicktip_renderer("Backward compatible","Check this to have `this` in template context point to owner instead of excerpt.") }, "boxLabel": "Backward compatible", "selectOnFocus": true, "anchor": "-20" });
    var attach_to_email4025 = new Ext.form.Checkbox({ "autoHeight": true, "hideLabel": true, "checked": false, "name": "attach_to_email", "listeners": { "render": Lino.quicktip_renderer("als Anhang per E-Mail","Whether the printable file should be attached to the email\nwhen creating an email from a mailable of this type.\n") }, "boxLabel": "als Anhang per E-Mail", "selectOnFocus": true, "anchor": "-20" });
    var main_3_panel4026 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 198, "hideCheckBoxLabels": true, "items": [ { "flex": 16, "autoHeight": true, "layout": "form", "xtype": "panel", "items": primary4020, "labelAlign": "top" }, { "flex": 16, "autoHeight": true, "layout": "form", "xtype": "panel", "items": print_directly4021, "labelAlign": "top" }, { "flex": 16, "autoHeight": true, "layout": "form", "xtype": "panel", "items": certifying4022, "labelAlign": "top" }, { "flex": 16, "autoHeight": true, "layout": "form", "xtype": "panel", "items": print_recipient4023, "labelAlign": "top" }, { "flex": 16, "autoHeight": true, "layout": "form", "xtype": "panel", "items": backward_compat4024, "labelAlign": "top" }, { "flex": 16, "autoHeight": true, "layout": "form", "xtype": "panel", "items": attach_to_email4025, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var excerpts_ExcerptsByType_grid4098 = new Lino.excerpts.ExcerptsByType.GridPanel({ "flex": 62, "hide_top_toolbar": true, "containing_panel": this, "tools": [ Lino.show_in_own_window_button(Lino.excerpts.ExcerptsByType.grid) ], "preview_limit": 15, "master_panel": this });
    var main_panel4099 = new Ext.Panel({ "autoScroll": false, "border": false, "layout": "vbox", "hideCheckBoxLabels": true, "items": [ main_1_panel4001, main_2_panel4013, main_3_panel4026, excerpts_ExcerptsByType_grid4098 ], "frame": true, "layoutConfig": { "align": "stretch" }, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel4099;
    this.before_row_edit = function(record) {
      template4009.setContextValue('build_method', record ? record.data['build_methodHidden'] : undefined);
      template4009.setContextValue('content_type', record ? record.data['content_typeHidden'] : undefined);
      body_template4010.setContextValue('content_type', record ? record.data['content_typeHidden'] : undefined);
      email_template4011.setContextValue('content_type', record ? record.data['content_typeHidden'] : undefined);
      excerpts_ExcerptsByType_grid4098.on_master_changed();
    }
    this.onRender = function(ct, position) {
      build_method4008.on('change',Lino.chooser_handler(template4009,'build_method'));
      content_type4007.on('change',Lino.chooser_handler(template4009,'content_type'));
      content_type4007.on('change',Lino.chooser_handler(body_template4010,'content_type'));
      content_type4007.on('change',Lino.chooser_handler(email_template4011,'content_type'));
      Lino.excerpts.ExcerptTypes.DetailFormPanel.superclass.onRender.call(this, ct, position);
    }
    Lino.excerpts.ExcerptTypes.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.isip.ExamPolicies.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 78,
  initComponent : function() {
    var id2848 = new Ext.form.NumberField({ "selectOnFocus": true, "autoHeight": true, "fieldLabel": "ID", "anchor": "-20", "name": "id" });
    var name2849 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Bezeichnung", "name": "name", "maxLength": 200, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var name_fr2850 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Bezeichnung (fr)", "name": "name_fr", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var name_de2851 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Bezeichnung (de)", "name": "name_de", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var name_nl2852 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Bezeichnung (nl)", "name": "name_nl", "maxLength": 200, "selectOnFocus": true, "hidden": true, "anchor": "-20" });
    var main_1_panel2853 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 153, "hideCheckBoxLabels": true, "items": [ { "flex": 5, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id2848, "labelAlign": "top" }, { "flex": 23, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name2849, "labelAlign": "top" }, { "flex": 23, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_fr2850, "labelAlign": "top" }, { "flex": 23, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_de2851, "labelAlign": "top" }, { "flex": 23, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_nl2852, "hidden": true, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var max_events2859 = new Ext.form.NumberField({ "selectOnFocus": true, "autoHeight": true, "fieldLabel": "Anzahl Termine", "anchor": "-20", "name": "max_events" });
    var every2860 = new Ext.form.NumberField({ "autoHeight": true, "fieldLabel": "... alle", "name": "every", "selectOnFocus": true, "anchor": "-20", "value": 0, "allowBlank": false });
    var every_unit2861 = new Lino.ChoicesFieldElement({ "autoHeight": true, "forceSelection": true, "fieldLabel": "Wiederholung", "name": "every_unit", "hiddenName": "every_unitHidden", "selectOnFocus": true, "anchor": "-20", "store": [['','<br>']].concat(Lino.cal.Recurrencies) });
    var event_type2862 = new Lino.TwinCombo({ "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Ereignisart</span>", "name": "event_type", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.cal.EventTypes.detail,Lino.cal.EventTypes.insert)}, "emptyText": "Ereignisart ausw\u00e4hlen...", "listeners": { "render": Lino.quicktip_renderer("Ereignisart","Generated events will receive this type.") }, "selectOnFocus": true, "hiddenName": "event_typeHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/isip/ExamPolicies/event_type", "method": "GET" }) }) });
    var main_2_panel2863 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 135, "hideCheckBoxLabels": true, "items": [ { "flex": 11, "autoHeight": true, "layout": "form", "xtype": "panel", "items": max_events2859, "labelAlign": "top" }, { "flex": 11, "autoHeight": true, "layout": "form", "xtype": "panel", "items": every2860, "labelAlign": "top" }, { "flex": 31, "autoHeight": true, "layout": "form", "xtype": "panel", "items": every_unit2861, "labelAlign": "top" }, { "flex": 45, "autoHeight": true, "layout": "form", "xtype": "panel", "items": event_type2862, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var monday2868 = new Ext.form.Checkbox({ "boxLabel": "Montag", "autoHeight": true, "hideLabel": true, "checked": false, "name": "monday", "selectOnFocus": true, "anchor": "-20" });
    var tuesday2869 = new Ext.form.Checkbox({ "boxLabel": "Dienstag", "autoHeight": true, "hideLabel": true, "checked": false, "name": "tuesday", "selectOnFocus": true, "anchor": "-20" });
    var wednesday2870 = new Ext.form.Checkbox({ "boxLabel": "Mittwoch", "autoHeight": true, "hideLabel": true, "checked": false, "name": "wednesday", "selectOnFocus": true, "anchor": "-20" });
    var thursday2871 = new Ext.form.Checkbox({ "boxLabel": "Donnerstag", "autoHeight": true, "hideLabel": true, "checked": false, "name": "thursday", "selectOnFocus": true, "anchor": "-20" });
    var friday2872 = new Ext.form.Checkbox({ "boxLabel": "Freitag", "autoHeight": true, "hideLabel": true, "checked": false, "name": "friday", "selectOnFocus": true, "anchor": "-20" });
    var saturday2873 = new Ext.form.Checkbox({ "boxLabel": "Samstag", "autoHeight": true, "hideLabel": true, "checked": false, "name": "saturday", "selectOnFocus": true, "anchor": "-20" });
    var sunday2874 = new Ext.form.Checkbox({ "boxLabel": "Sonntag", "autoHeight": true, "hideLabel": true, "checked": false, "name": "sunday", "selectOnFocus": true, "anchor": "-20" });
    var main_3_panel2875 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 99, "hideCheckBoxLabels": true, "items": [ { "flex": 14, "autoHeight": true, "layout": "form", "xtype": "panel", "items": monday2868, "labelAlign": "top" }, { "flex": 14, "autoHeight": true, "layout": "form", "xtype": "panel", "items": tuesday2869, "labelAlign": "top" }, { "flex": 14, "autoHeight": true, "layout": "form", "xtype": "panel", "items": wednesday2870, "labelAlign": "top" }, { "flex": 14, "autoHeight": true, "layout": "form", "xtype": "panel", "items": thursday2871, "labelAlign": "top" }, { "flex": 14, "autoHeight": true, "layout": "form", "xtype": "panel", "items": friday2872, "labelAlign": "top" }, { "flex": 14, "autoHeight": true, "layout": "form", "xtype": "panel", "items": saturday2873, "labelAlign": "top" }, { "flex": 14, "autoHeight": true, "layout": "form", "xtype": "panel", "items": sunday2874, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var isip_ContractsByPolicy_grid2900 = new Lino.isip.ContractsByPolicy.GridPanel({ "flex": 38, "hide_top_toolbar": true, "containing_panel": this, "params_panel_hidden": true, "tools": [ Lino.show_in_own_window_button(Lino.isip.ContractsByPolicy.grid) ], "master_panel": this, "preview_limit": 15 });
    var jobs_ContractsByPolicy_grid2928 = new Lino.jobs.ContractsByPolicy.GridPanel({ "flex": 38, "hide_top_toolbar": true, "containing_panel": this, "params_panel_hidden": true, "tools": [ Lino.show_in_own_window_button(Lino.jobs.ContractsByPolicy.grid) ], "master_panel": this, "preview_limit": 15 });
    var main_panel2929 = new Ext.Panel({ "autoScroll": false, "border": false, "layout": "vbox", "hideCheckBoxLabels": true, "items": [ main_1_panel2853, main_2_panel2863, main_3_panel2875, isip_ContractsByPolicy_grid2900, jobs_ContractsByPolicy_grid2928 ], "frame": true, "layoutConfig": { "align": "stretch" }, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel2929;
    this.before_row_edit = function(record) {
      isip_ContractsByPolicy_grid2900.on_master_changed();
      jobs_ContractsByPolicy_grid2928.on_master_changed();
    }
    Lino.isip.ExamPolicies.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.aids.AidTypes.InsertFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  autoHeight: true,
  content_type: 117,
  initComponent : function() {
    var name4742 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Bezeichnung", "name": "name", "maxLength": 200, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var name_fr4743 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Bezeichnung (fr)", "name": "name_fr", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var name_de4744 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Bezeichnung (de)", "name": "name_de", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var name_nl4745 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Bezeichnung (nl)", "name": "name_nl", "maxLength": 200, "selectOnFocus": true, "hidden": true, "anchor": "-20" });
    var main_1_panel4746 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 25, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name4742, "labelAlign": "top" }, { "flex": 25, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_fr4743, "labelAlign": "top" }, { "flex": 25, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_de4744, "labelAlign": "top" }, { "flex": 25, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_nl4745, "hidden": true, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 153, "border": false, "anchor": "-20", "labelAlign": "top" });
    var confirmation_type4751 = new Lino.ChoicesFieldElement({ "autoHeight": true, "forceSelection": true, "fieldLabel": "Hilfebescheinigungsart", "name": "confirmation_type", "hiddenName": "confirmation_typeHidden", "selectOnFocus": true, "anchor": "-20", "store": [['','<br>']].concat(Lino.aids.ConfirmationTypes) });
    var main_panel4752 = new Ext.Panel({ "hideCheckBoxLabels": true, "autoHeight": true, "border": false, "layout": "form", "labelWidth": 207, "autoScroll": false, "items": [ main_1_panel4746, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": confirmation_type4751, "anchor": "-20", "labelAlign": "top" } ], "frame": true, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel4752;
    this.before_row_edit = function(record) {
    }
    Lino.aids.AidTypes.InsertFormPanel.superclass.initComponent.call(this);
  }
});


Lino.aids.GrantingsByClient.InsertFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  autoHeight: true,
  content_type: 113,
  initComponent : function() {
    var aid_type3457 = new Lino.TwinCombo({ "autoHeight": true, "fieldLabel": "Hilfeart", "allowBlank": false, "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.aids.AidTypes.detail,Lino.aids.AidTypes.insert)}, "emptyText": "Hilfeart ausw\u00e4hlen...", "selectOnFocus": true, "hiddenName": "aid_typeHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/aids/GrantingsByClient/aid_type", "method": "GET" }) }), "name": "aid_type" });
    var board3458 = new Lino.TwinCombo({ "autoHeight": true, "fieldLabel": "Gremium", "name": "board", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.boards.Boards.detail,Lino.boards.Boards.insert)}, "emptyText": "Gremium ausw\u00e4hlen...", "selectOnFocus": true, "hiddenName": "boardHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/aids/GrantingsByClient/board", "method": "GET" }) }) });
    var decision_date3459 = new Lino.DateField({ "selectOnFocus": true, "autoHeight": true, "fieldLabel": "Beschlossen", "anchor": "-20", "name": "decision_date" });
    var main_2_panel3460 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 60, "autoHeight": true, "layout": "form", "xtype": "panel", "items": board3458, "labelAlign": "top" }, { "flex": 39, "autoHeight": true, "layout": "form", "xtype": "panel", "items": decision_date3459, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 108, "border": false, "anchor": "-20", "labelAlign": "top" });
    var start_date3463 = new Lino.DateField({ "autoHeight": true, "fieldLabel": "Laufzeit von", "name": "start_date", "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var end_date3464 = new Lino.DateField({ "selectOnFocus": true, "autoHeight": true, "fieldLabel": "bis", "anchor": "-20", "name": "end_date" });
    var main_3_panel3465 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": start_date3463, "labelAlign": "top" }, { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": end_date3464, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 117, "border": false, "anchor": "-20", "labelAlign": "top" });
    var main_panel3468 = new Ext.Panel({ "hideCheckBoxLabels": true, "autoHeight": true, "border": false, "layout": "form", "labelWidth": 81, "autoScroll": false, "items": [ { "autoHeight": true, "layout": "form", "xtype": "panel", "items": aid_type3457, "anchor": "-20", "labelAlign": "top" }, main_2_panel3460, main_3_panel3465 ], "frame": true, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel3468;
    this.before_row_edit = function(record) {
      board3458.setContextValue('decision_date', record ? record.data['decision_date'] : undefined);
    }
    this.onRender = function(ct, position) {
      decision_date3459.on('change',Lino.chooser_handler(board3458,'decision_date'));
      Lino.aids.GrantingsByClient.InsertFormPanel.superclass.onRender.call(this, ct, position);
    }
    Lino.aids.GrantingsByClient.InsertFormPanel.superclass.initComponent.call(this);
  }
});


Lino.isip.ContractEndings.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 80,
  initComponent : function() {
    var name2930 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Bezeichnung", "name": "name", "maxLength": 200, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var use_in_isip2931 = new Ext.form.Checkbox({ "boxLabel": "VSE", "autoHeight": true, "hideLabel": true, "checked": true, "name": "use_in_isip", "selectOnFocus": true, "anchor": "-20" });
    var use_in_jobs2932 = new Ext.form.Checkbox({ "boxLabel": "Art.60\u00a77", "autoHeight": true, "hideLabel": true, "checked": true, "name": "use_in_jobs", "selectOnFocus": true, "anchor": "-20" });
    var is_success2933 = new Ext.form.Checkbox({ "boxLabel": "Erfolgreich abgeschlossen", "autoHeight": true, "hideLabel": true, "checked": false, "name": "is_success", "selectOnFocus": true, "anchor": "-20" });
    var needs_date_ended2934 = new Ext.form.Checkbox({ "boxLabel": "erfordert Enddatum", "autoHeight": true, "hideLabel": true, "checked": false, "name": "needs_date_ended", "selectOnFocus": true, "anchor": "-20" });
    var main_2_panel2935 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 234, "hideCheckBoxLabels": true, "items": [ { "flex": 25, "autoHeight": true, "layout": "form", "xtype": "panel", "items": use_in_isip2931, "labelAlign": "top" }, { "flex": 25, "autoHeight": true, "layout": "form", "xtype": "panel", "items": use_in_jobs2932, "labelAlign": "top" }, { "flex": 25, "autoHeight": true, "layout": "form", "xtype": "panel", "items": is_success2933, "labelAlign": "top" }, { "flex": 25, "autoHeight": true, "layout": "form", "xtype": "panel", "items": needs_date_ended2934, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var isip_ContractsByEnding_grid2957 = new Lino.isip.ContractsByEnding.GridPanel({ "flex": 41, "hide_top_toolbar": true, "containing_panel": this, "params_panel_hidden": true, "tools": [ Lino.show_in_own_window_button(Lino.isip.ContractsByEnding.grid) ], "master_panel": this, "preview_limit": 15 });
    var jobs_ContractsByEnding_grid2985 = new Lino.jobs.ContractsByEnding.GridPanel({ "flex": 41, "hide_top_toolbar": true, "containing_panel": this, "params_panel_hidden": true, "tools": [ Lino.show_in_own_window_button(Lino.jobs.ContractsByEnding.grid) ], "master_panel": this, "preview_limit": 15 });
    var main_panel2986 = new Ext.Panel({ "autoScroll": false, "border": false, "layout": "vbox", "labelWidth": 108, "hideCheckBoxLabels": true, "items": [ { "items": name2930, "autoHeight": true, "layout": "form", "xtype": "panel", "labelAlign": "top" }, main_2_panel2935, isip_ContractsByEnding_grid2957, jobs_ContractsByEnding_grid2985 ], "frame": true, "layoutConfig": { "align": "stretch" }, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel2986;
    this.before_row_edit = function(record) {
      isip_ContractsByEnding_grid2957.on_master_changed();
      jobs_ContractsByEnding_grid2985.on_master_changed();
    }
    Lino.isip.ContractEndings.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.isip.ContractPartners.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 77,
  initComponent : function() {
    var company2393 = new Lino.TwinCombo({ "preferred_width": 20, "autoHeight": true, "fieldLabel": "Organisation", "name": "company", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.contacts.Companies.detail,Lino.contacts.Companies.insert)}, "hiddenName": "companyHidden", "selectOnFocus": true, "emptyText": "Organisation ausw\u00e4hlen...", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/isip/ContractPartners/company", "method": "GET" }) }) });
    var contact_person2394 = new Lino.TwinCombo({ "preferred_width": 20, "autoHeight": true, "fieldLabel": "Vertreten durch", "name": "contact_person", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.contacts.Persons.detail,Lino.contacts.Persons.insert)}, "hiddenName": "contact_personHidden", "selectOnFocus": true, "emptyText": "Person ausw\u00e4hlen...", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/isip/ContractPartners/contact_person", "method": "GET" }) }) });
    var contact_role2395 = new Lino.RemoteComboFieldElement({ "autoHeight": true, "fieldLabel": "in seiner Eigenschaft als", "name": "contact_role", "pageSize": 20, "emptyText": "Funktion ausw\u00e4hlen...", "selectOnFocus": true, "hiddenName": "contact_roleHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/isip/ContractPartners/contact_role", "method": "GET" }) }) });
    var main_1_panel2396 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 234, "hideCheckBoxLabels": true, "items": [ { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": company2393, "labelAlign": "top" }, { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": contact_person2394, "labelAlign": "top" }, { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": contact_role2395, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var duties_company2400 = new Lino.RichTextPanel({ "selectOnFocus": true, "flex": 83, "containing_panel": this, "name": "duties_company", "title": "Verpflichtungen Firma" });
    var main_panel2401 = new Ext.Panel({ "autoScroll": false, "border": false, "layout": "vbox", "labelWidth": 0, "hideCheckBoxLabels": true, "items": [ main_1_panel2396, duties_company2400 ], "frame": true, "layoutConfig": { "align": "stretch" }, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel2401;
    this.before_row_edit = function(record) {
      contact_person2394.setContextValue('company', record ? record.data['companyHidden'] : undefined);
      duties_company2400.refresh();
    }
    this.onRender = function(ct, position) {
      company2393.on('change',Lino.chooser_handler(contact_person2394,'company'));
      Lino.isip.ContractPartners.DetailFormPanel.superclass.onRender.call(this, ct, position);
    }
    Lino.isip.ContractPartners.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.boards.Boards.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 49,
  initComponent : function() {
    var id4124 = new Ext.form.NumberField({ "selectOnFocus": true, "autoHeight": true, "fieldLabel": "ID", "anchor": "-20", "name": "id" });
    var name4125 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Bezeichnung", "name": "name", "maxLength": 200, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var name_fr4126 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Bezeichnung (fr)", "name": "name_fr", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var name_de4127 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Bezeichnung (de)", "name": "name_de", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var name_nl4128 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Bezeichnung (nl)", "name": "name_nl", "maxLength": 200, "selectOnFocus": true, "hidden": true, "anchor": "-20" });
    var main_1_panel4129 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 153, "hideCheckBoxLabels": true, "items": [ { "flex": 5, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id4124, "labelAlign": "top" }, { "flex": 23, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name4125, "labelAlign": "top" }, { "flex": 23, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_fr4126, "labelAlign": "top" }, { "flex": 23, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_de4127, "labelAlign": "top" }, { "flex": 23, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_nl4128, "hidden": true, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var boards_MembersByBoard_grid4138 = new Lino.boards.MembersByBoard.GridPanel({ "flex": 83, "hide_top_toolbar": true, "containing_panel": this, "tools": [ Lino.show_in_own_window_button(Lino.boards.MembersByBoard.grid) ], "preview_limit": 15, "master_panel": this });
    var main_panel4139 = new Ext.Panel({ "autoScroll": false, "border": false, "layout": "vbox", "hideCheckBoxLabels": true, "items": [ main_1_panel4129, boards_MembersByBoard_grid4138 ], "frame": true, "layoutConfig": { "align": "stretch" }, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel4139;
    this.before_row_edit = function(record) {
      boards_MembersByBoard_grid4138.on_master_changed();
    }
    Lino.boards.Boards.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.contacts.Companies.InsertFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  autoHeight: true,
  content_type: 17,
  initComponent : function() {
    var name1898 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Name", "name": "name", "maxLength": 200, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var language1899 = new Lino.ChoicesFieldElement({ "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Sprache</span>", "allowBlank": false, "hiddenName": "languageHidden", "listeners": { "render": Lino.quicktip_renderer("Sprache","Die Sprache, in der Dokumente ausgestellt werden sollen.") }, "selectOnFocus": true, "anchor": "-20", "store": [ [ "en", "Englisch" ], [ "fr", "Franz\u00f6sisch" ], [ "de", "Deutsch" ], [ "nl", "Niederl\u00e4ndisch" ] ], "name": "language" });
    var email1900 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "E-Mail", "name": "email", "maxLength": 75, "selectOnFocus": true, "anchor": "-20" });
    var main_2_panel1901 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": language1899, "labelAlign": "top" }, { "flex": 66, "autoHeight": true, "layout": "form", "xtype": "panel", "items": email1900, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 72, "border": false, "anchor": "-20", "labelAlign": "top" });
    var type1904 = new Lino.RemoteComboFieldElement({ "autoHeight": true, "fieldLabel": "Organisationsart", "name": "type", "pageSize": 20, "emptyText": "Organisationsart ausw\u00e4hlen...", "selectOnFocus": true, "hiddenName": "typeHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/contacts/Companies/type", "method": "GET" }) }) });
    var id1905 = new Ext.form.NumberField({ "selectOnFocus": true, "autoHeight": true, "fieldLabel": "ID", "anchor": "-20", "name": "id" });
    var main_3_panel1906 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 80, "autoHeight": true, "layout": "form", "xtype": "panel", "items": type1904, "labelAlign": "top" }, { "flex": 20, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id1905, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 153, "border": false, "anchor": "-20", "labelAlign": "top" });
    var main_panel1909 = new Ext.Panel({ "hideCheckBoxLabels": true, "autoHeight": true, "border": false, "layout": "form", "labelWidth": 45, "autoScroll": false, "items": [ { "autoHeight": true, "layout": "form", "xtype": "panel", "items": name1898, "anchor": "-20", "labelAlign": "top" }, main_2_panel1901, main_3_panel1906 ], "frame": true, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel1909;
    this.before_row_edit = function(record) {
    }
    Lino.contacts.Companies.InsertFormPanel.superclass.initComponent.call(this);
  }
});


Lino.humanlinks.Links.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  autoHeight: true,
  content_type: 105,
  initComponent : function() {
    var parent4572 = new Lino.TwinCombo({ "preferred_width": 20, "autoHeight": true, "fieldLabel": "Vater/Mutter", "allowBlank": false, "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.contacts.Persons.detail,Lino.contacts.Persons.insert)}, "emptyText": "Person ausw\u00e4hlen...", "selectOnFocus": true, "hiddenName": "parentHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/humanlinks/Links/parent", "method": "GET" }) }), "name": "parent" });
    var child4573 = new Lino.TwinCombo({ "preferred_width": 20, "autoHeight": true, "fieldLabel": "Kind", "name": "child", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.contacts.Persons.detail,Lino.contacts.Persons.insert)}, "hiddenName": "childHidden", "selectOnFocus": true, "emptyText": "Person ausw\u00e4hlen...", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/humanlinks/Links/child", "method": "GET" }) }) });
    var type4574 = new Lino.ChoicesFieldElement({ "autoHeight": true, "forceSelection": true, "fieldLabel": "Verwandschaftsart", "allowBlank": false, "hiddenName": "typeHidden", "selectOnFocus": true, "anchor": "-20", "store": Lino.humanlinks.LinkTypes, "name": "type" });
    var main_panel4575 = new Ext.Panel({ "hideCheckBoxLabels": true, "autoHeight": true, "border": false, "layout": "form", "labelWidth": 162, "autoScroll": false, "items": [ { "autoHeight": true, "layout": "form", "xtype": "panel", "items": parent4572, "anchor": "-20", "labelAlign": "top" }, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": child4573, "anchor": "-20", "labelAlign": "top" }, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": type4574, "anchor": "-20", "labelAlign": "top" } ], "frame": true, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel4575;
    this.before_row_edit = function(record) {
    }
    Lino.humanlinks.Links.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.projects.Projects.DetailFormPanel =