/*
 Copyright 2009-2014 Luc Saffre
 License: BSD (see file COPYING for details)
*/

// lino.js --- generated Sat Dec 20 11:09:46 2014 by Lino version 1.6.16.
Ext.BLANK_IMAGE_URL = 'http://extjs-public.googlecode.com/svn/tags/extjs-3.3.1/release/resources/images/default/s.gif';
LANGUAGE_CHOICES = [ [ "de", "Deutsch" ], [ "fr", "Franz\u00f6sisch" ], [ "nl", "Niederl\u00e4ndisch" ] ];
MEDIA_URL = "/media";

// hack to add a toCamel function, inspired by
// http://jamesroberts.name/blog/2010/02/22/string-functions-for-javascript-trim-to-camel-case-to-dashed-and-to-underscore/
String.prototype.toCamel = function(){
  //~ return this.replace(/(\-[a-z])/g, function($1){return $1.toUpperCase().replace('-','');});
  //~ return this;
  return this.replace(/([A-Z])([A-Z]+)/g, function(match,p1,p2,offset,string){
      //~ console.log("20131005 got ",arguments);
      return p1 + p2.toLowerCase();});
};



/* MonthPickerPlugin: thanks to keypoint @ sencha forum
   http://www.sencha.com/forum/showthread.php?74002-3.x-Ext.ux.MonthMenu&p=356860#post356860
*/
Ext.namespace('Ext.ux'); 

Ext.ux.MonthPickerPlugin = function() { 
    var picker; 
    var oldDateDefaults; 

    this.init = function(pk) { 
        picker = pk; 
        picker.onTriggerClick = picker.onTriggerClick.createSequence(onClick); 
        picker.getValue = picker.getValue.createInterceptor(setDefaultMonthDay).createSequence(restoreDefaultMonthDay); 
        picker.beforeBlur = picker.beforeBlur.createInterceptor(setDefaultMonthDay).createSequence(restoreDefaultMonthDay); 
    }; 

    function setDefaultMonthDay() { 
        oldDateDefaults = Date.defaults.d; 
        Date.defaults.d = 1; 
        return true; 
    } 

    function restoreDefaultMonthDay(ret) { 
        Date.defaults.d = oldDateDefaults; 
        return ret; 
    } 

    function onClick(e, el, opt) { 
        var p = picker.menu.picker; 
        p.activeDate = p.activeDate.getFirstDateOfMonth(); 
        if (p.value) { 
            p.value = p.value.getFirstDateOfMonth(); 
        } 

        p.showMonthPicker(); 
         
        if (!p.disabled) { 
            p.monthPicker.stopFx(); 
            p.monthPicker.show(); 

            p.mun(p.monthPicker, 'click', p.onMonthClick, p); 
            p.mun(p.monthPicker, 'dblclick', p.onMonthDblClick, p); 
            p.onMonthClick = p.onMonthClick.createSequence(pickerClick); 
            p.onMonthDblClick = p.onMonthDblClick.createSequence(pickerDblclick); 
            p.mon(p.monthPicker, 'click', p.onMonthClick, p); 
            p.mon(p.monthPicker, 'dblclick', p.onMonthDblClick, p); 
        } 
    } 

    function pickerClick(e, t) { 
        var el = new Ext.Element(t); 
        if (el.is('button.x-date-mp-cancel')) { 
            picker.menu.hide(); 
        } else if(el.is('button.x-date-mp-ok')) { 
            var p = picker.menu.picker; 
            p.setValue(p.activeDate); 
            p.fireEvent('select', p, p.value); 
        } 
    } 

    function pickerDblclick(e, t) { 
        var el = new Ext.Element(t); 
        if (el.parent() 
            && (el.parent().is('td.x-date-mp-month') 
            || el.parent().is('td.x-date-mp-year'))) { 

            var p = picker.menu.picker; 
            p.setValue(p.activeDate); 
            p.fireEvent('select', p, p.value); 
        } 
    } 
}; 

Ext.preg('monthPickerPlugin', Ext.ux.MonthPickerPlugin);  


/**
JC Watsons solution (adapted to ExtJS 3.3.1 by LS) is elegant and simple:
`A "fix" for unchecked checkbox submission  behaviour
<http://www.sencha.com/forum/showthread.php?28449>`_

Added special handling for checkbox inputs. 
ExtJS defines disabled checkboxes `readonly`, not `disabled` as for other inputs.

*/
Ext.lib.Ajax.serializeForm = function(form) {
    //~ console.log('20120203 linolib.js serializeForm',form);
    var fElements = form.elements || (document.forms[form] || Ext.getDom(form)).elements, 
        hasSubmit = false, 
        encoder = encodeURIComponent, 
        name, 
        data = '', 
        type, 
        hasValue;

    Ext.each(fElements, function(element){
        name = element.name;
        type = element.type;

        if (!element.disabled && name && !(type == 'checkbox' && element.readonly)) {
            if (/select-(one|multiple)/i.test(type)) {
                Ext.each(element.options, function(opt){
                    if (opt.selected) {
                        hasValue = opt.hasAttribute ? opt.hasAttribute('value') : opt.getAttributeNode('value').specified;
                        data += String.format("{0}={1}&", encoder(name), encoder(hasValue ? opt.value : opt.text));
                    }
                });
            } else if (!(/file|undefined|reset|button/i.test(type))) {
                //~ if (!(/radio|checkbox/i.test(type) && !element.checked) && !(type == 'submit' && hasSubmit)) {
                if (!(type == 'submit' && hasSubmit)) {
                    if (type == 'checkbox') {
                        //~ console.log('20111001',element,'data += ',encoder(name) + '=' + (element.checked ? 'on' : 'off') + '&');
                        data += encoder(name) + '=' + (element.checked ? 'on' : 'off') + '&';
                    } else {
                        //~ console.log('20111001',element,'data += ',encoder(name) + '=' + encoder(element.value) + '&');
                        data += encoder(name) + '=' + encoder(element.value) + '&';
                    }
                    hasSubmit = /submit/i.test(type);
                }
            }
        //~ } else {
            //~ console.log(name,type,element.readonly);
        }
    });
    return data.substr(0, data.length - 1);
};



/*
Set a long timeout of fifteen minutes. 
See /blog/2012/0307
*/
Ext.Ajax.timeout = 15 * 60 * 1000; 

/*
 * Thanks to 
 * `huuze <http://stackoverflow.com/users/10040/huuuze>`_ for the question
 * and to 
 * `chrisv <http://stackoverflow.com/users/683808/chrisv>`_
 * for the answer on
 * http://stackoverflow.com/questions/3764589/how-do-i-include-django-1-2s-csrf-token-in-a-javascript-generated-html-form/5485616#5485616
 * 
 * */
 
Ext.Ajax.on('beforerequest', function (conn, options) {
   if (!(/^http:.*/.test(options.url) || /^https:.*/.test(options.url))) {
     if (typeof(options.headers) == "undefined") {
       options.headers = {'X-CSRFToken': Ext.util.Cookies.get('csrftoken')};
     } else {
       options.headers.extend({'X-CSRFToken': Ext.util.Cookies.get('csrftoken')});
     }                        
   }
}, this);


/*
My fix for the "Cannot set QuickTips dismissDelay to 0" bug,
see http://www.sencha.com/forum/showthread.php?183515 
*/
Ext.override(Ext.QuickTip,{
  showAt : function(xy){
        var t = this.activeTarget;
        //~ console.log("20120224 QuickTip.showAt",this.title,this.dismissDelay,t.dismissDelay);
        if(t){
            if(!this.rendered){
                this.render(Ext.getBody());
                this.activeTarget = t;
            }
            if(t.width){
                this.setWidth(t.width);
                this.body.setWidth(this.adjustBodyWidth(t.width - this.getFrameWidth()));
                this.measureWidth = false;
            } else{
                this.measureWidth = true;
            }
            this.setTitle(t.title || '');
            this.body.update(t.text);
            this.autoHide = t.autoHide;
            // bugfix by Luc 20120226
            if (t.dismissDelay != undefined) this.dismissDelay = t.dismissDelay;
            //~ this.dismissDelay = t.dismissDelay || this.dismissDelay;
            if(this.lastCls){
                this.el.removeClass(this.lastCls);
                delete this.lastCls;
            }
            if(t.cls){
                this.el.addClass(t.cls);
                this.lastCls = t.cls;
            }
            if(this.anchor){
                this.constrainPosition = false;
            }else if(t.align){ 
                xy = this.el.getAlignToXY(t.el, t.align);
                this.constrainPosition = false;
            }else{
                this.constrainPosition = true;
            }
        }
        Ext.QuickTip.superclass.showAt.call(this, xy);
    }
});

/*
Another hack. See /docs/blog/2012/0228
*/
Ext.Element.addMethods(
    function() {
        var VISIBILITY      = "visibility",
            DISPLAY         = "display",
            HIDDEN          = "hidden",
            NONE            = "none",
            XMASKED         = "x-masked",
            XMASKEDRELATIVE = "x-masked-relative",
            data            = Ext.Element.data;

        return {
            
            mask : function(msg, msgCls) {
                var me  = this,
                    dom = me.dom,
                    dh  = Ext.DomHelper,
                    EXTELMASKMSG = "ext-el-mask-msg",
                    el,
                    mask;
                // removed the following lines. See /docs/blog/2012/0228
                //~ if (!(/^body/i.test(dom.tagName) && me.getStyle('position') == 'static')) {
                    //~ console.log(20120228,dom.tagName,me);
                    //~ me.addClass(XMASKEDRELATIVE); 
                //~ }
                if (el = data(dom, 'maskMsg')) {
                    el.remove();
                }
                if (el = data(dom, 'mask')) {
                    el.remove();
                }

                mask = dh.append(dom, {cls : "ext-el-mask"}, true);
                data(dom, 'mask', mask);

                me.addClass(XMASKED);
                mask.setDisplayed(true);
                
                if (typeof msg == 'string') {
                    var mm = dh.append(dom, {cls : EXTELMASKMSG, cn:{tag:'div'}}, true);
                    data(dom, 'maskMsg', mm);
                    mm.dom.className = msgCls ? EXTELMASKMSG + " " + msgCls : EXTELMASKMSG;
                    mm.dom.firstChild.innerHTML = msg;
                    mm.setDisplayed(true);
                    mm.center(me);
                }
                
                
                if (Ext.isIE && !(Ext.isIE7 && Ext.isStrict) && me.getStyle('height') == 'auto') {
                    mask.setSize(undefined, me.getHeight());
                }
                
                return mask;
            }

            
        };
    }()
);



Ext.namespace('Lino');
    
    

//~ Lino.subst_user_field = new Ext.form.ComboBox({});
//~ Lino.subst_user = null;
Lino.insert_subst_user = function(p){
    //~ console.log('20120714 insert_subst_user',Lino.subst_user,p);
    //~ if (Lino.subst_user_field.getValue()) {
    if (p.su) return;
    if (Lino.subst_user) {
        //~ p.su = Lino.subst_user_field.getValue();
        p.su = Lino.subst_user;
    //~ } else {
        //~ delete p.su;
    }
    //~ console.log('20120714 insert_subst_user -->',Lino.subst_user,p);
}

Lino.login_window = null;

Lino.autorefresh = function() {
  if (Lino.current_window == null) {
      Lino.viewport.refresh();
      Lino.autorefresh.defer(10000);
  }
}

Lino.show_login_window = function(on_login) {
  //~ console.log('20121103 show_login_window',arguments);
  //~ var current_window = Lino.current_window;
  if (Lino.login_window == null) {
    
      function do_login() { 
            Lino.viewport.loadMask.show()
            login_panel.getForm().submit({ 
                method:'POST', 
                waitTitle:'Connecting', 
                waitMsg:'Sending data...',
                success:function(){ 
                  Lino.login_window.hide();
                  Lino.handle_home_button();
                  Lino.viewport.loadMask.hide();
                  if (typeof on_login == 'string') {
                      Lino.load_url(on_login);
                  } 
                },
                failure: function(form,action) { 
                  Lino.on_submit_failure(form, action);
                  Lino.viewport.loadMask.hide()
                }
            }); 
      };
    
      var login_button = new Ext.Button({ 
        text:"Anmelden",
        formBind: true,	 
        // Function that fires when user clicks the button 
        handler: do_login});
    
      var login_panel = new Ext.FormPanel({ 
        //~ inspired by http://www.sencha.com/learn/a-basic-login/
        autoHeight:true,
        labelWidth:90,
        url:'/auth', 
        frame:true, 
        defaultType:'textfield',
        monitorValid:true,
        items:[{ 
            fieldLabel:"Benutzername", 
            id: 'username',
            name:'username', 
            autoHeight:true,
            allowBlank:false 
        },{ 
            fieldLabel:"Passwort", 
            name:'password', 
            inputType:'password', 
            autoHeight:true,
            allowBlank:false 
        }],        
        buttons:[ login_button ]});
        
      Lino.login_window = new Ext.Window({
          layout:'fit',
          defaultButton: 'username',
          width:300,
          title:"Anmelden", 
          autoHeight:true,
          modal: true,
          closeAction: "hide",
          keys: {
            key: Ext.EventObject.ENTER,
            fn: function() { do_login()}
          },
          items: [login_panel] });
  };
  Lino.login_window.show();
};

Lino.logout = function(id,name) {
    Lino.call_ajax_action(
        Lino.viewport, 'GET', 
        '/auth',
        {}, 'logout', undefined, undefined,
        function(){Lino.reload();})
}

Lino.set_subst_user = function(id, name) {
    //~ console.log(20130723,'Lino.set_subst_user',id,name,Lino.current_window,Lino.viewport);
    Lino.subst_user = id;
    if (Lino.current_window) 
        Lino.current_window.main_item.set_base_param("su",id);
    if (Lino.viewport) 
        Lino.permalink_handler(Lino.current_window)();
}



//~ Lino.select_subst_user = function(cmp,rec,value){
    //~ Lino.subst_user=value;
    //~ console.log(20120713,rec);
//~ }
    
Lino.current_window = null;
Lino.window_history = Array();
    
Lino.chars2width = function(cols) {  return cols * 9; }
Lino.rows2height = function(cols) {  return cols * 20; }



Lino.MainPanel = {
  is_home_page : false,
  setting_param_values : false,
  config_containing_window : function(wincfg) { }
  ,init_containing_window : function(win) { }
  ,is_loading : function() { 
      if (!this.rendered) return true;
      //~ return (Ext.select('.x-loading-msg').elements.length > 0);
      return true; 
    } 
  ,do_when_clean : function(auto_save,todo) { todo() }
  ,get_master_params : function() {
    var p = {}
    p['mt'] = this.content_type; 
    rec = this.get_current_record()
    if (rec) {
      if (rec.phantom) {
          p['mk'] = undefined; 
      }else{
          p['mk'] = rec.id; 
      }
    } else {
      p['mk'] = undefined;
    }
    //~ console.log('get_master_params returns',p,'using record',rec);
    return p;
  }
  ,get_permalink : function() {
    var p = Ext.apply({}, this.get_base_params());
    delete p.fmt;
    Ext.apply(p, this.get_permalink_params());
    
    if (this.toggle_params_panel_btn) {
        p.sp = this.toggle_params_panel_btn.pressed;
        //~ if (this.toggle_params_panel_btn.pressed == this.params_panel_hidden) {
          //~ p.sp = true;
        //~ }
    }
    
    //~ Lino.insert_subst_user(p);
     //~ p.fmt = 'html';
    //~ console.log('get_permalink',p,this.get_permalink_params());
    if (this.is_home_page)
        //~ var url = '';
        var url = '/';
    else 
        var url = this.get_permalink_url();
    if (p.su == null) 
        delete p.su;
    if (Ext.urlEncode(p)) url = url + "?" + Ext.urlEncode(p);
    return url;
  }
  ,get_record_url : function(record_id) {
      var url = '/api' + this.ls_url
      //~ var url = this.containing_window.config.url_data; // ls_url;
      url += '/' + (record_id === undefined ? '-99999' : String(record_id));
      //~ if (record_id !== undefined) url += '/' + String(record_id);
      //~ url += '/' + String(record_id);
      return url;
  }
  ,get_permalink_url : function() {
      return '/api' + this.ls_url;
  }
  ,get_permalink_params : function() {
      //~ return {an:'grid'};
      var p = {};
      if (this.action_name)
          p.an = this.action_name;
      this.add_param_values(p,false)
      return p;
  }
  /*

  Lino.MainPanel.set_status() : the status can have the following keys:

  - field_values
  - param_values
  - base_params
  - record_id
  - active_tab
  - data_record
  - show_params_panel
  - current_page

   */
  ,set_status : function(status, requesting_panel) {}
  ,get_status : function() { return {}}
  ,refresh : function() {}
  ,get_base_params : function() {  // Lino.MainPanel
    var p = {};
    Lino.insert_subst_user(p);
    return p;
  }
  ,add_params_panel : function (tbar) {
      if (this.params_panel) {
        //~  20130923b
        //~ this.params_panel.autoHeight = true; // 20130924
        var t = this;
        var update = function() {
            var p = t.params_panel;
            //~ console.log("update", p.getSize().height,p.forceLayout,p.autoHeight);
            var w = t.get_containing_window();
            Lino.do_when_visible(w, function() {
                //~ p.doLayout(true); // doLayout(shallow, force)
                w.doLayout(true); // doLayout(shallow, force)
                //~ t.params_panel.on('afterlayout',update,t,{single:true});
            });
        };
        Lino.do_when_visible(this.params_panel, update);
        this.params_panel.on('show',update);
        this.params_panel.on('hide',update);
        //~ this.params_panel.on('bodyresize',update);
        this.params_panel.on('afterlayout',update);
        //~ this.params_panel.on('afterlayout',update,this,{single:true});
        //~ this.params_panel.on('bodyresize',update,this,{single:true});
        //~ this.params_panel.on('resize',update,this,{single:true});
        //~ this.params_panel.on('render',update,this,{single:true});
        
        // this.params_panel.on('render',
        //~ this.params_panel.on('afterlayout',update,this,{single:true,delay:200});
        //~ this.params_panel.on('bodyresize',update,this,{single:true,delay:200});
        this.toggle_params_panel_btn = new Ext.Button({ scope:this, 
          //~ text: "$_("[parameters]")", // gear
          iconCls: 'x-tbar-parameters',
          tooltip:"Parameter-Panel ein- bzw. ausblenden",
          enableToggle: true,
          //~ pressed: ! this.params_panel.hidden,
          pressed: ! this.params_panel_hidden,
          toggleHandler: function(btn,state) { 
            //~ console.log("20120210 add_params_panel",state,this.params_panel);
            if (state) {
                this.params_panel.show();
            } else {
                this.params_panel.hide();
            }
            //~ this.params_panel.on('afterlayout',update,this,{single:true});
            //~ t.get_containing_window().doLayout();
            //~ this.params_panel.on('afterlayout',function() {
                //~ console.log("20130918 afterlayout");
                //~ t.get_containing_window().doLayout(); // doLayout(shallow, force)
            //~ },this,{single:true});
          }
        }); 
        tbar = tbar.concat([this.toggle_params_panel_btn]);
        var refresh = function() {
            if (!t.setting_param_values) {
                t._force_dirty = true; 
                t.refresh();
            }
        }
        Ext.each(this.params_panel.fields,function(f) {
          //~ f.on('valid',function() {t.refresh()});
          if (f instanceof Ext.form.Checkbox) {
              f.on('check',refresh);
          } else if (f instanceof Ext.DatePicker) {
              f.on('select',refresh);
          } else if (f instanceof Ext.form.TriggerField) {
              f.on('select',refresh);
              //~ f.on('change',refresh);
              //~ f.on('valid',refresh);
          } else {
              if (! f.on) 
                  console.log("20121010 no method 'on'",f);
              else
                  f.on('change',refresh);
            }
          });
      }
      return tbar;
  }
  ,add_param_values : function (p,force_dirty) {
    if (this.params_panel) {
      /* 
      * 20120918 add param_values to the request string 
      * *only if the params_form is dirty*.
      * Otherwise Actor.default_params() would never be used.
      *
      * 20121023 But IntegClients.params_default has non-empty default values. 
      * Users must have the possibility to make them empty.
      * 
      * 20130605 : added `force_dirty` parameter because Checkbox fields don't 
      * mark their form as dirty when check is fired.
      * 
      * 20130721 : `force_dirty` not as a parameter but as 
      * `this._force_dirty` because
      * 
      * 20130915 : both _force_dirty and force_dirty parameter are needed.
      * 
      */
      if (force_dirty || this._force_dirty || this.params_panel.form.isDirty()) {
      //~ if (this._force_dirty || this.params_panel.form.isDirty()) {
        p.pv = this.get_param_values();
        //~ console.log("20130923 form is dirty (",force_dirty,this._force_dirty,this.params_panel.form.isDirty(),")");
        //~ console.log("20130923 form is dirty",p);
      }else{
        //~ console.log("20130923 form not dirty:",this.params_panel.form);
        if (this.status_param_values) 
          p.pv = Lino.fields2array(
            this.params_panel.fields,this.status_param_values);
      }
      //~ if (!this.params_panel.form.isDirty()) return;
      //~ p.pv = this.get_param_values();
      //~ console.log("20120203 add_param_values added pv",p.pv,"to",p);
    }
  },
  get_param_values : function() { // similar to get_field_values()
      return Lino.fields2array(this.params_panel.fields);
  },
  set_param_values : function(pv) {
    if (this.params_panel) {
      //~ console.log('20120203 MainPanel.set_param_values', pv);
      this.status_param_values = pv;
      //~ this.params_panel.form.suspendEvents(false);
      this.setting_param_values = true;
      if (pv) { 
          this.params_panel.form.my_loadRecord(pv);
      } else { 
        this.params_panel.form.reset(); 
      }
      this.setting_param_values = false;
      this._force_dirty = false; 
      //~ this.params_panel.form.resumeEvents();
    }
  }
};




Lino.Viewport = Ext.extend(Ext.Viewport, Lino.MainPanel);
Lino.Viewport = Ext.extend(Lino.Viewport, {
  layout : "fit"
  ,is_home_page : true
  ,initComponent : function(){
    Lino.Viewport.superclass.initComponent.call(this);
    this.on('render',function(){
      this.loadMask = new Ext.LoadMask(this.el,{msg:"Bitte warten..."});
      //~ console.log("20121118 Lino.viewport.loadMask",this.loadMask);
    },this);
  }
  ,refresh : function() {
      var caller = this;
      // console.log("20140829 Lino.Viewport.refresh()");
      if (caller.loadMask) caller.loadMask.show();
      var success = function(response) {
        if (caller.loadMask) caller.loadMask.hide();
        if (response.responseText) {
          var result = Ext.decode(response.responseText);
          //~ console.log('Lino.do_action()',action.name,'result is',result);
          if (result.html) {
              var cmp = Ext.getCmp('dashboard');
              // cmp.removeAll(true);  // 20140829
              cmp.update(result.html, true);
          }
          if (result.message) {
              if (result.alert) {
                  //~ Ext.MessageBox.alert('Alert',result.alert_msg);
                  Ext.MessageBox.alert('Alert',result.message);
              } else {
                  Lino.notify(result.message);
              }
          }
          
          if (result.notify_msg) Lino.notify(result.notify_msg);
          if (result.js_code) { 
            var jsr = result.js_code(caller);
            //~ console.log('Lino.do_action()',action,'returned from js_code in',result);
          };
        }
      };
      var action = {
        url : '/api/main_html',
        waitMsg: "Bitte warten...",
        failure: Lino.ajax_error_handler(caller),
        success: success,
        method: 'GET',
        params: {}
      };
      Lino.insert_subst_user(action.params);
      Ext.Ajax.request(action);
    
  }
});




Lino.open_window = function(win, st, requesting_panel) {
  // console.log("20140831 Lino.open_window()", win, win.el.getBox());
  var cw = Lino.current_window;
  if (cw) {
    // console.log("20140829 Lino.open_window() save current status",
    //             cw.main_item.get_status());
    Lino.window_history.push({
      window:cw,
      status:cw.main_item.get_status()
    });
  }
  Lino.current_window = win;
  //~ if (st.su) 
      //~ Lino.subst_user_field.setValue(st.su);
  win.main_item.set_status(st, requesting_panel);
  // win.toFront();
  win.show();
};

Lino.load_url = function(url) {
    //~ foo.bar.baz = 2; 
    //~ console.log("20121120 Lino.load_url()");
    //~ Lino.body_loadMask.show();
    Lino.viewport.loadMask.show();
    //~ location.replace(url);
    document.location = url;
}

Lino.close_window = function(status_update, norestore) {
  // norestore is used when called by handle_action_result() who 
  // will call set_status itself later
  var cw = Lino.current_window;
  var ww = Lino.window_history.pop();
  var retval = cw.main_item.requesting_panel;
  // console.log(
  //     "20140917 Lino.close_window() going to close", cw.title,
  //     "previous is", ww, 
  //     "norestore is", norestore,
  //     "retval is", retval);
  if (ww) {
    //~ if (status_update) Ext.apply(ww.status,status_update);
    if(!norestore) {
        if (status_update) status_update(ww);
        ww.window.main_item.set_status(ww.status);
    }
    Lino.current_window = ww.window;
  } else {
      Lino.current_window = null;
      // new since 20140829:
      if(!norestore) { Lino.viewport.refresh(); }
  }
  if (cw) cw.hide_really();
  return retval;
};

Lino.kill_current_window = function() {
  // console.log("20140418 Lino.kill_current_window()");
  var cw = Lino.current_window;
  Lino.current_window = null;
  if (cw) cw.hide_really();
};

Lino.reload = function() {
    // First close all windows to ensure all changes are saved
    Lino.close_all_windows();

    // Then reload current view
    var url =  "/"

    var p = {};
    Lino.insert_subst_user(p)
    if (Ext.urlEncode(p))
        url = url + "?" + Ext.urlEncode(p);

    Lino.load_url(url);
}

Lino.handle_home_button = function() {
  if (Lino.window_history.length == 0)
      Lino.reload();
  else
      Lino.close_all_windows();
}

Lino.close_all_windows = function() {
    while (Lino.window_history.length > 0) {
        Lino.close_window();
    }
}

Lino.calling_window = function() {
    if (Lino.window_history.length) 
        return Lino.window_history[Lino.window_history.length-1];
}

//~ Lino.WindowAction = function(mainItemClass,windowConfig,mainConfig,ppf) {
Lino.WindowAction = function(windowConfig,main_item_fn) {
    //~ if(!mainConfig) mainConfig = {};
    //~ mainConfig.is_main_window = true;
    this.windowConfig = windowConfig;
    this.main_item_fn = main_item_fn;
    //~ if (ppf) mainConfig.params_panel.fields = ppf;
    //~ this.mainConfig = mainConfig;
    //~ this.mainItemClass = mainItemClass;
};

Lino.WindowAction = Ext.extend(Lino.WindowAction,{
    window : null,
    //~ mainItemClass: null,
    get_window : function() {
      //~ if(mainConfig) Ext.apply(this.mainConfig,mainConfig);
      // if (this.window == null || this.window.isDestroyed)  { // 20140829
      // if (this.window == null || this.window.getBox().width == 0)  { // 20140829
      if (this.window == null)  {
      // if (true)  {
          //~ this.windowConfig.main_item = new this.mainItemClass(this.mainConfig);
          this.windowConfig.main_item = this.main_item_fn();
          this.window = new Lino.Window(this.windowConfig);
      }
      return this.window;
    },
    run : function(requesting_panel, status) {
      // console.log('20140829 window_action.run()', this)
      Lino.open_window(this.get_window(), status, requesting_panel);
    }
  
});


Lino.PanelMixin = {
  get_containing_window : function (){
      if (this.containing_window) return this.containing_window;
      return this.containing_panel.get_containing_window();
  }
  ,set_window_title : function(title) {
    //~ this.setTitle(title);
    var cw = this.get_containing_window();

    //~ if (cw) {
    //~ if (cw && cw.closable) {
    if (cw && !cw.main_item.hide_window_title) {
      //~ console.log('20111202 set_window_title(',title,') for',this.containing_window);
      //~ if (! this.containing_window.rendered) console.log("WARNING: not rendered!");
      cw.setTitle(title);
    //~ } else {
      //~ document.title = title;
    }
    //~ else console.log('20111202 not set_window_title(',title,') for',this);
  }
  
};


// Lino.status_bar = new Ext.ux.StatusBar({defaultText:'Lino version 1.6.16.'});




Lino.edit_tinymce_text = function(panel, options) {
  // `panel` is the RichTextPanel
  //~ console.log(20111220,panel);
  //~ var rec = panel.get_current_record();
  var rec = panel.containing_panel.get_current_record();
  var value = rec ? rec.data[panel.editor.name] : '';
  var saving = false;
  var todo_after_save = false;
  var discard_changes = false;
  
  
  function save() {
    //~ if (todo_after_save) {alert('tried to save again'); return; }
    if (saving) {alert('tried to save again'); return; }
    //~ var url = panel.containing_window.main_item.get_record_url(rec.id);
    var url = panel.containing_panel.get_record_url(rec.id);
    var params = Ext.apply({}, panel.containing_panel.get_base_params());
    params[panel.editor.name] = editor.getValue();
    //~ params.su = Lino.subst_user;
    //~ Lino.insert_subst_user(params);
    var a = { 
      params: params, 
      method: 'PUT',
      url: url,
      failure: function() {
          //~ if (editor.ed.getContainer()) 
          editor.ed.setProgressState(0);
          todo_after_save = false;
          saving = false;
          console.log('tinymce.save() failed. sorry.',arguments);
        },
      success: function() {
        saving = false;
        //~ if (editor.ed.getContainer()) 
        editor.ed.setProgressState(0);
        rec.data[panel.editor.name] = editor.getValue();
        if(todo_after_save) {
            var fn = todo_after_save;
            todo_after_save = false;
            fn();
        }
        //~ panel.containing_window.set_current_record(rec);
        panel.refresh();
      }
    };
    //~ if (editor.ed.getContainer()) 
    editor.ed.setProgressState(1); // Show progress
    saving = true;
    //~ console.log(a);
    Ext.Ajax.request(a);
  };
  function save_callback() {
      save();
      //~ save(function(){editor.ed.setDirty(false);})
      /* return true have the save button disabled.  
      That's not perfect because the PUT is asynchronous 
      and the response is not yet known.
      */
      return true;
  }
  //~ var actions = [
    //~ {text:"Save",handler:save}
  //~ ]; 
  //~ console.log(20110610,panel.editor.disabled);
  var settings = {};
  Ext.apply(settings,{
        readonly: panel.editor.disabled,
        //~ language: "de",
        plugins : "save,emotions,spellchecker,advhr,insertdatetime,preview,table,searchreplace,template", 
        // Theme options - button# indicated the row# only
        theme_advanced_buttons1 : "save,cancel,|,bold,italic,underline,|,justifyleft,justifycenter,justifyright,fontselect,fontsizeselect,formatselect,|,search,replace",
        theme_advanced_buttons2 : "cut,copy,paste,template,|,bullist,numlist,|,outdent,indent,|,undo,redo,|,link,unlink,anchor,image,|,code,preview,|,forecolor,backcolor",
        theme_advanced_buttons3 : "insertdate,inserttime,|,spellchecker,advhr,,removeformat,|,sub,sup,|,charmap,emotions,|,tablecontrols",      
        theme_advanced_resizing : false,
        convert_urls : false,
        save_onsavecallback : save_callback,
        save_enablewhendirty : true
        //~ save_oncancelcallback: on_cancel
  });
  Ext.apply(settings,options);
  var editor = new Ext.ux.TinyMCE({
      value : value,
      tinymceSettings: settings
    });
  var win = new Ext.Window({
    title: rec.title, 
    //~ bbar: actions,
    layout: 'fit',
    items: editor,
    width: 600, 
    height:500,
    minWidth: 100,
		minHeight: 100,
    modal: true,
    resizable: true,
    maximizable: true,
    //~ maximized: true,
    //~ closeAction: "close"
    closeAction: "hide"
    //~ hideMode: "offsets",
    //~ constrainHeader: true,
    //~ bodyStyle: 'padding: 10px'
  });

  //~ win.on('beforeclose',function() {
  win.on('beforehide',function() {
    if (todo_after_save) return false;
    if (discard_changes) return true;
    if (editor.isDirty()) {
        //~ var ok = false;
        //~ var allowClose = true;
        var config = {title:"Bestätigung"};
        config.buttons = Ext.MessageBox.YESNOCANCEL;
        config.msg = "Änderungen im Text speichern?";
        config.modal = true;
        config.fn = function(buttonId,text,opt) {
          //~ console.log('do_when_clean',buttonId)
          if (buttonId == "yes") {
              /* we cancel this close, but save()'s onSuccess will call again.*/
              //~ allowClose = false;
              todo_after_save = function(){win.hide();}
              editor.ed.execCommand('mceSave');
              //~ editor.ed.save(function(){win.close();});
          } else if (buttonId == "no") { 
              discard_changes = true;
              win.hide()
          //~ } else if (buttonId == "cancel") { 
            //~ ok = true;
              //~ allowClose = false;
          //~ } else { 
            //~ console.log('unknwon buttonId:',buttonId);
          }
        }
        Ext.MessageBox.show(config);
        return false;
        //~ return allowClose;
    }
  });
  win.show();
}







/* 
  Originally copied from Ext JS Library 3.3.1
  Modifications by Luc Saffre : 
  - rendering of phantom records
  - fire afteredit event
  - react on dblclcik, not on single click

 */
Lino.CheckColumn = Ext.extend(Ext.grid.Column, {

    processEvent : function(name, e, grid, rowIndex, colIndex){
        //~ console.log('20110713 Lino.CheckColumn.processEvent',name)
        if (name == 'click') {
        //~ if (name == 'mousedown') {
        //~ if (name == 'dblclick') {
            return this.toggleValue(grid, rowIndex, colIndex);
        } else {
            return Ext.grid.ActionColumn.superclass.processEvent.apply(this, arguments);
        }
    },
    
    toggleValue : function (grid,rowIndex,colIndex) {
        var record = grid.store.getAt(rowIndex);
        var dataIndex = grid.colModel.getDataIndex(colIndex);
        // 20120514
        //~ if(record.data.disabled_fields && record.data.disabled_fields[dataIndex]) {
          //~ Lino.notify("Dieses Feld ist deaktiviert");
          //~ return false;
        //~ }
      
        //~ if (dataIndex in record.data['disabled_fields']) {
            //~ Lino.notify("This field is disabled.");
            //~ return false;
        //~ }
        var startValue = record.data[dataIndex];
        var value = !startValue;
        //~ record.set(this.dataIndex, value);
        var e = {
            grid: grid,
            record: record,
            field: dataIndex,
            originalValue: startValue,
            value: value,
            row: rowIndex,
            column: colIndex,
            cancel: false
        };
        if(grid.fireEvent("beforeedit", e) !== false && !e.cancel){
        //~ if(grid.fireEvent("validateedit", e) !== false && !e.cancel){
            record.set(dataIndex, value);
            delete e.cancel;
            grid.fireEvent("afteredit", e);
        }
        return false; // Cancel event propagation
    },

    renderer : function(v, p, record){
        if (record.phantom) return '';
        p.css += ' x-grid3-check-col-td'; 
        return String.format('<div class="x-grid3-check-col{0}">&#160;</div>', v ? '-on' : '');
    }

    // Deprecate use as a plugin. Remove in 4.0
    // init: Ext.emptyFn
});

// register ptype. Deprecate. Remove in 4.0
// Ext.preg('checkcolumn', Lino.CheckColumn);

// backwards compat. Remove in 4.0
// Ext.grid.CheckColumn = Lino.CheckColumn;

// register Column xtype
Ext.grid.Column.types.checkcolumn = Lino.CheckColumn;


/* 20110725 : 
Lino.on_tab_activate is necessary 
in contacts.Person.2.dtl 
(but don't ask me why...)
*/
Lino.on_tab_activate = function(item) {
  //~ console.log('activate',item); 
  if (item.rendered && item.doLayout) item.doLayout();
  //~ if (item.rendered) item.doLayout();
}

Lino.TimeField = Ext.extend(Ext.form.TimeField,{
  format: 'H:i',
  increment: 15
  });
Lino.DateField = Ext.extend(Ext.form.DateField,{
  //~ boxMinWidth: Lino.chars2width(15), // 20131005 changed from 11 to 15
  format: 'd.m.Y',
  altFormats: 'd/m/Y|Y-m-d'
  });
Lino.DatePickerField = Ext.extend(Ext.DatePicker,{
  //~ boxMinWidth: Lino.chars2width(11),
  format: 'd.m.Y',
  //~ altFormats: 'd/m/Y|Y-m-d'
  formatDate : function(date){
      //~ console.log("20121203 formatDate",this.name,date);
      return Ext.isDate(date) ? date.dateFormat(this.format) : date;
  }
  });
Lino.DateTimeField = Ext.extend(Ext.ux.form.DateTime,{
  dateFormat: 'd.m.Y',
  timeFormat: 'H:i'
  //~ ,hiddenFormat: 'd.m.Y H:i'
  });
Lino.URLField = Ext.extend(Ext.form.TriggerField,{
  triggerClass : 'x-form-search-trigger',
  //~ triggerClass : 'x-form-world-trigger',
  vtype: 'url',
  onTriggerClick : function() {
    //~ console.log('Lino.URLField.onTriggerClick',this.value)
    //~ document.location = this.value;
    window.open(this.getValue(),'_blank');
  }
});
Lino.IncompleteDateField = Ext.extend(Ext.form.TextField,{
  //~ regex: /^-?\d+-[01]\d-[0123]\d$/,
  //~ regex: /^[0123]\d\.[01]\d\.-?\d+$/,
  maxLength: 10,
  boxMinWidth: Lino.chars2width(10),
  regex: /^[0123]?\d\.[01]?\d\.-?\d+$/,
  regexText: 'Datum im Format JJJJ-MM-TT eingeben (Nullen für unbekannte Teile)'
  });


//~ Lino.make_dropzone = function(cmp) {
    //~ cmp.on('render', function(ct, position){
      //~ ct.el.on({
        //~ dragenter:function(event){
          //~ event.browserEvent.dataTransfer.dropEffect = 'move';
          //~ return true;
        //~ }
        //~ ,dragover:function(event){
          //~ event.browserEvent.dataTransfer.dropEffect = 'move';
          //~ event.stopEvent();
          //~ return true;
        //~ }
        //~ ,drop:{
          //~ scope:this
          //~ ,fn:function(event){
            //~ event.stopEvent();
            //~ console.log(20110516);
            //~ var files = event.browserEvent.dataTransfer.files;
            //~ if(files === undefined){
              //~ return true;
            //~ }
            //~ var len = files.length;
            //~ while(--len >= 0){
              //~ console.log(files[len]);
              //~ // this.processDragAndDropFileUpload(files[len]);
            //~ }
          //~ }
        //~ }
      //~ });
    //~ });
//~ };

//~ Lino.FileUploadField = Ext.ux.form.FileUploadField;

Lino.FileUploadField = Ext.extend(Ext.ux.form.FileUploadField,{
    unused_onRender : function(ct, position){
      Lino.FileUploadField.superclass.onRender.call(this, ct, position);
      this.el.on({
        dragenter:function(event){
          event.browserEvent.dataTransfer.dropEffect = 'move';
          return true;
        }
        ,dragover:function(event){
          event.browserEvent.dataTransfer.dropEffect = 'move';
          event.stopEvent();
          return true;
        }
        ,drop:{
          scope:this
          ,fn:function(event){
            event.stopEvent();
            //~ console.log(20110516);
            var files = event.browserEvent.dataTransfer.files;
            if(files === undefined){
              return true;
            }
            var len = files.length;
            while(--len >= 0){
              console.log(files[len]);
              //~ this.processDragAndDropFileUpload(files[len]);
            }
          }
        }
      });
    }
});

Lino.FileField = Ext.extend(Ext.form.TriggerField,{
  triggerClass : 'x-form-search-trigger',
  editable: false,
  onTriggerClick : function() {
    //~ console.log('Lino.URLField.onTriggerClick',this.value)
    //~ document.location = this.value;
    if (this.getValue()) window.open(MEDIA_URL + '/'+this.getValue(),'_blank');
  }
});

Lino.file_field_handler = function(panel,config) {
  if (panel.action_name == 'insert') {
      panel.has_file_upload = true;


      // config.value = '<br/><br/>';

      var f = new Lino.FileUploadField(config);
      //~ Lino.make_dropzone(f);
      return f;
      //~ return new Ext.ux.form.FileUploadField(config);
      //~ return new Lino.FileField(config);
      
  } else {
      //~ return new Lino.URLField(config);
      return new Lino.FileField(config);
  }
}

Lino.VBorderPanel = Ext.extend(Ext.Panel,{
    constructor : function(config) {
      config.layout = 'border';
      delete config.layoutConfig;
      Lino.VBorderPanel.superclass.constructor.call(this,config);
      for(var i=0; i < this.items.length;i++) {
        var item = this.items.get(i);
        if (this.isVertical(item) && item.collapsible) {
          item.on('collapse',this.onBodyResize,this);
          item.on('expand',this.onBodyResize,this);
        }
      }
    },
    isVertical : function(item) {
       return (item.region == 'north' || item.region == 'south' || item.region == 'center');
    },
    onBodyResize: function(w, h){
        //~ console.log('VBorderPanel.onBodyResize',this.title)
      if (this.isVisible()) { // to avoid "Uncaught TypeError: Cannot call method 'getHeight' of undefined."
        var sumflex = 0;
        var availableHeight = this.getInnerHeight();
        var me = this;
        this.items.each(function(item){
          if (me.isVertical(item)) {
              if (item.collapsed || item.flex == 0 || item.flex === undefined) {
                  if (item.rendered) availableHeight -= item.getHeight();
              } else {
                  sumflex += item.flex;
              }
          } 
          
        });
        //~ for(var i=0; i < this.items.length;i++) {
          //~ var item = this.items.get(i);
          //~ // if (this.isVertical(item) && item.getResizeEl()) {
          //~ if (this.isVertical(item)) {
              //~ if (item.collapsed || item.flex == 0 || item.flex === undefined) {
                  //~ // item.syncSize()
                  //~ // item.doLayout()
                  //~ // if (item.region == "north") console.log('region north',item.getHeight(),item.id, item);
                  //~ // if (item.getHeight() == 0) console.log(20100921,'both flex and getHeight() are 0!');
                  //~ availableHeight -= item.getHeight();
              //~ } else {
                  //~ sumflex += item.flex;
                  //~ // console.log(item.flex);
              //~ }
          //~ } 
          //~ // else console.log('non-vertical item in VBoderPanel:',item)
        //~ }
        var hunit = availableHeight / sumflex;
        //~ console.log('sumflex=',sumflex,'hunit=',hunit, 'availableHeight=',availableHeight);
        for(var i=0; i < this.items.length;i++) {
          var item = this.items.get(i);
          if (this.isVertical(item)) {
              if (item.flex != 0 && ! item.collapsed) {
                  item.setHeight(hunit * item.flex);
                  //~ console.log(item.region,' : height set to',item.getHeight());
              }
          }
          //~ else console.log('non-vertical item in VBoderPanel:',item)
        }
      }
      Lino.VBorderPanel.superclass.onBodyResize.call(this, w, h);
    }
});


/*
  modifications to the standard behaviour of a CellSelectionModel:
  
*/
Ext.override(Ext.grid.CellSelectionModel, {
//~ var dummy = {

    handleKeyDown : function(e){
        /* removed because F2 wouldn't pass
        if(!e.isNavKeyPress()){
            return;
        }
        */
        //~ console.log('handleKeyDown',e)
        var k = e.getKey(),
            g = this.grid,
            s = this.selection,
            sm = this,
            walk = function(row, col, step){
                return g.walkCells(
                    row,
                    col,
                    step,
                    g.isEditor && g.editing ? sm.acceptsNav : sm.isSelectable, 
                    sm
                );
            },
            cell, newCell, r, c, ae;

        switch(k){
            case e.ESC:
            case e.PAGE_UP:
            case e.PAGE_DOWN:
                break;
            default:
                // e.stopEvent(); // removed because Browser keys like Alt-Home, Ctrl-R wouldn't work
                break;
        }

        if(!s){
            cell = walk(0, 0, 1); 
            if(cell){
                this.select(cell[0], cell[1]);
            }
            return;
        }

        cell = s.cell;  
        r = cell[0];    
        c = cell[1];    
        
        switch(k){
            case e.TAB:
                if(e.shiftKey){
                    newCell = walk(r, c - 1, -1);
                }else{
                    newCell = walk(r, c + 1, 1);
                }
                break;
            case e.HOME:
                if (! (g.isEditor && g.editing)) {
                  if (!e.hasModifier()){
                      newCell = [r, 0];
                      //~ console.log('home',newCell);
                      break;
                  }else if(e.ctrlKey){
                      var t = g.getTopToolbar();
                      var activePage = Math.ceil((t.cursor + t.pageSize) / t.pageSize);
                      if (activePage > 1) {
                          e.stopEvent();
                          t.moveFirst();
                          return;
                      }
                      newCell = [0, c];
                      break;
                  }
                }
            case e.END:
                if (! (g.isEditor && g.editing)) {
                  c = g.colModel.getColumnCount()-1;
                  if (!e.hasModifier()) {
                      newCell = [r, c];
                      //~ console.log('end',newCell);
                      break;
                  }else if(e.ctrlKey){
                      var t = g.getTopToolbar();
                      var d = t.getPageData();
                      if (d.activePage < d.pages) {
                          e.stopEvent();
                          var self = this;
                          t.on('change',function(tb,pageData) {
                              var r = g.store.getCount()-2;
                              self.select(r, c);
                              //~ console.log('change',r,c);
                          },this,{single:true});
                          t.moveLast();
                          return;
                      } else {
                          newCell = [g.store.getCount()-1, c];
                          //~ console.log('ctrl-end',newCell);
                          break;
                      }
                  }
                }
            case e.DOWN:
                newCell = walk(r + 1, c, 1);
                break;
            case e.UP:
                newCell = walk(r - 1, c, -1);
                break;
            case e.RIGHT:
                newCell = walk(r, c + 1, 1);
                break;
            case e.LEFT:
                newCell = walk(r, c - 1, -1);
                break;
            case e.F2:
                if (!e.hasModifier()) {
                    if (g.isEditor && !g.editing) {
                        g.startEditing(r, c);
                        e.stopEvent();
                        return;
                    }
                    break;
                }
            case e.INSERT:
                if (!e.hasModifier()) {
                    if (g.ls_insert_handler && !g.editing) {
                        e.stopEvent();
                        Lino.show_insert(g);
                        return;
                    }
                    break;
                }
            // case e.DELETE:
            //     if (!e.hasModifier()) {
            //         if (!g.editing) {
            //             e.stopEvent();
            //             Lino.delete_selected(g);
            //             return;
            //         }
            //         break;
            //     }

            case e.ENTER:
                e.stopEvent();
                g.onCellDblClick(r,c);
                break;

            default:
                g.handle_key_event(e);
                
        }
        

        if(newCell){
          e.stopEvent();
          r = newCell[0];
          c = newCell[1];
          this.select(r, c); 
          if(g.isEditor && g.editing){ 
            ae = g.activeEditor;
            if(ae && ae.field.triggerBlur){
                ae.field.triggerBlur();
            }
            g.startEditing(r, c);
          }
        //~ } else if (g.isEditor && !g.editing && e.charCode) {
        //~ // } else if (!e.isSpecialKey() && g.isEditor && !g.editing) {
            //~ g.set_start_value(String.fromCharCode(e.charCode));
            //~ // g.set_start_value(String.fromCharCode(k));
            //~ // g.set_start_value(e.charCode);
            //~ g.startEditing(r, c);
            //~ // e.stopEvent();
            //~ return;
        // } else {
          // console.log('20120513',e,g);
        }
        
    }


//~ };
});

 

function PseudoConsole() {
    this.log = function() {};
};
if (typeof(console) == 'undefined') console = new PseudoConsole();

Lino.notify = function(msg) {
  if (msg == undefined) msg = ''; else console.log(msg);
  
    if (msg == undefined) return;
    // Lino.alert(msg);
  
};

Lino.alert = function(msg) {
  Ext.MessageBox.alert('Notify',msg);
};


//~ Lino.show_about = function() {
  //~ new Ext.Window({
    //~ width: 400, height: 400,
    //~ title: "About",
    //~ html: '<a href="http://www.extjs.com" target="_blank">ExtJS</a> version ' + Ext.version
  //~ }).show();
//~ };

function obj2str(o) {
  if (typeof o != 'object') return String(o);
  var s = '';
  for (var p in o) {
    s += p + ': ' + obj2str(o[p]) + '\n';
  }
  return s;
}

Lino.on_store_exception = function (store,type,action,options,response,arg) {
  //~ throw response;
  console.log("on_store_exception: store=",store,
    "type=",type,
    "action=",action,
    "options=",options,
    "response=",response,
    "arg=",arg);
  if (arg) { console.log(arg.stack)};
};

//~ Lino.on_submit_success = function(form, action) {
   //~ Lino.notify(action.result.message);
   //~ this.close();
//~ };

Lino.on_submit_failure = function(form, action) {
    //~ Lino.notify();
  // action may be undefined
    switch (action.failureType) {
        case Ext.form.Action.CLIENT_INVALID:
            Ext.Msg.alert('Client-side failure', 'Form fields may not be submitted with invalid values');
            break;
        case Ext.form.Action.CONNECT_FAILURE:
            Ext.Msg.alert('Connection failure', 'Ajax communication failed');
            break;
        case Ext.form.Action.SERVER_INVALID:
            Ext.Msg.alert('Server-side failure', action.result.message);
   }
};



/*
Lino.save_wc_handler = function(ww) {
  return function(event,toolEl,panel,tc) {
    var pos = panel.getPosition();
    var size = panel.getSize();
    wc = ww.get_window_config();
    Ext.applyIf(wc,{ 
      x:pos[0],y:pos[1],height:size.height,width:size.width,
      maximized:panel.maximized});
    Lino.do_action(ww,{url:'/window_configs/'+ww.config.permalink_name,params:wc,method:'POST'});
  }
};

*/

Lino.show_in_own_window_button = function(handler) {
  return {
    qtip: "Dieses Panel in eigenem Fenster öffnen", 
    id: "up",
    handler: function(event,toolEl,panel, tc) {
      //~ console.log('20111206 report_window_button',panel,handler);
      handler.run(null,{base_params:panel.containing_panel.get_master_params()});
    }
  }
}

Lino.action_handler = function (panel, on_success, on_confirm) {
  return function (response) {
      if (!panel) { 
          if (Lino.current_window) 
              panel = Lino.current_window.main_item;
          else panel = Lino.viewport;
      }
      
    if (panel.loadMask) panel.loadMask.hide(); // 20120211
    if (!response.responseText) return ;
    var result = Ext.decode(response.responseText);
    Lino.handle_action_result(panel, result, on_success, on_confirm);
  }
};

Lino.handle_action_result = function (panel, result, on_success, on_confirm) {

    // console.log('20141127 Lino.handle_action_result()', result);
    
    // if (panel instanceof Lino.GridPanel) {
    //     gridmode = true;
    // } else {
    //     gridmode = false;
    // }

    //~ if (result.goto_record) {
        //~ var js = "Lino." + result.goto_record[0] + '.detail.run';
        //~ var h = eval(js);
        //~ h(panel,{record_id:result.goto_record[1]});
    //~ }
    
    if (result.xcallback) {
        //~ var config = {title:"Bestätigung"};
        var config = {title:result.xcallback.title};
        //~ config.buttons = Ext.MessageBox.YESNOCANCEL;
        //~ config.buttons = Ext.MessageBox.YESNO;
        var p = {};
        Lino.insert_subst_user(p);
        config.buttons = result.xcallback.buttons;
        config.msg = result.message;
        config.fn = function(buttonId, text, opt) {
          panel.loadMask.show(); 
          //~ Lino.insert_subst_user(p);
          Ext.Ajax.request({
            method: 'GET',
            url: '/callbacks/'
                  + result.xcallback.id + '/' + buttonId,
            params: p,
            success: Lino.action_handler(panel, on_success, on_confirm)
          });
        }
        Ext.MessageBox.show(config);
        return;
    }

    // `record_id` and/or `data_record` both mean "display the detail
    // of this record". 
    
    if(result.detail_handler_name) {
        // TODO: make sure that result.detail_handler_name is secure
        var detail_handler = eval("Lino." + result.detail_handler_name);
    }
    var ns = {};  // new status
    if (result.close_window) {
        
        if(result.record_id || result.data_record) {
            var ww = Lino.calling_window();
            if (ww && ww.window.main_item instanceof Lino.FormPanel) {
                if (ww.window.main_item.ls_detail_handler == detail_handler) {
                    ns.record_id = result.record_id;
                    ns.data_record = result.data_record;
                    console.log("20140630 use new status.");
                }
            }
        }

        // Subsequent processing expects that `panel` is "the current
        // panel". Since we close the window, `panel` should now point
        // to the previous window. Note the case of an insert window
        // that has been invoked by double-clicking on the phantom row
        // of a slave table in a detail window. In that case we want
        // `panel` to become the grid panel of the slave table who
        // called the insert window, not the master's detail form
        // panel.  When the insert window has been called by an action
        // link (e.g. generated using ar.insert_button), then
        // Lino.close_window can return `undefined`.

        panel = Lino.close_window(function(st) {Ext.apply(st, ns)}); 
        if (!panel) 
            panel = Lino.current_window.main_item;

    }

    if(result.record_id || result.data_record) {
        if (! (ns.record_id || ns.data_record)) {
          if (panel instanceof Lino.FormPanel 
              && panel.ls_detail_handler == detail_handler) 
            {
              // console.log("20140630 use panel.set_status().");
              panel.set_status({
                  record_id: result.record_id,
                  data_record: result.data_record});
          } else {
              // console.log("20140630 run detail_handler.");
              detail_handler.run(null, {
                  record_id: result.record_id,
                  data_record: result.data_record,
                  base_params: panel.get_base_params()});
          }

          // if (panel instanceof Lino.FormPanel 
          //     && panel.ls_url == result.actor_url) {
          //     // console.log("20140506 case 2 it's a FormPanel:", panel);
          //     panel.set_status({
          //         record_id: result.record_id,
          //         data_record: result.data_record});
          // } else if (panel.ls_detail_handler 
          //            && panel.ls_url == result.actor_url) {
          //     // console.log("20140506 case 4");
          //     panel.ls_detail_handler.run(null, {
          //         record_id: result.record_id,
          //         data_record: result.data_record,
          //         base_params: panel.get_base_params()});
          // } else {
          //     result.refresh_all = true;
          //     console.log("20140604 case 6", result.actor_url);
          // }
        }
    }

    // `eval_js` must get handled after `close_window` because it
    // might ask to open a new window (and we don't want to close that
    // new window).  It must execute *before* any MessageBox,
    // otherwise the box would get hidden by a window that opens
    // afterwards.

    if (result.eval_js) {
        //~ console.log(20120618,result.eval_js);
        eval(result.eval_js);
    }
    
    if (on_success && result.success) {
        // console.log("20140430 handle_action_result calls on_success", 
        //             on_success);
        on_success(result);
    }
    
    if (result.info_message) {
        console.log(result.info_message);
    }
    
    if (result.warning_message) {
        if (!result.alert) result.alert = "Warnung";
        Ext.MessageBox.alert(result.alert, result.warning_message);
    }
    
    if (result.message) {
        //~ if (result.alert && ! gridmode) {
        if (result.alert) { // 20120628b 
            //~ Ext.MessageBox.alert('Alert',result.alert_msg);
            if (result.alert === true) result.alert = "Alarm";
            Ext.MessageBox.alert(result.alert, result.message);
        } else {
            Lino.notify(result.message);
        }
    }

    if(result.record_deleted && panel.ls_detail_handler == detail_handler) {
        panel.after_delete();
    }
    
    if (result.refresh_all) {
        var cw = Lino.current_window;
        // var cw = panel.get_containing_window();
        if (cw) {
            // console.log("20140917 refresh_all calls refresh on", cw.main_item);
            cw.main_item.refresh();
        }
        // else console.log("20140917 cannot refresh_all because ",
        //                  "there is no current_window");
    } else {
        if (result.refresh) {
            // console.log("20140917 Gonna call panel.refresh()", panel);
            panel.refresh();
        }
    }if (result.open_davlink_url) {
       Lino.davlink_open(result.open_davlink_url);
    }if (result.open_url) {
        //~ console.log(20111126,result.open_url);
        //~ if (!result.message)
            //~ Lino.notify('Open new window <a href="'+result.open_url+'" target="_blank">'+result.open_url+'</a>');
        window.open(result.open_url,'foo',"");
        //~ document.location = result.open_url;
    }
};

// obsolete but still used for deleting records.
Lino.do_action = function(caller,action) { 
  action.success = function(response) {
    if (caller.loadMask) caller.loadMask.hide();
    //~ console.log('Lino.do_action()',action,'action success',response);
    if (action.after_success) {
        //~ console.log('Lino.do_action() calling after_success');
        action.after_success();
    }
    if (response.responseText) {
      var result = Ext.decode(response.responseText);
      //~ console.log('Lino.do_action()',action.name,'result is',result);
      if (result.message) {
          if (result.alert) {
              //~ Ext.MessageBox.alert('Alert',result.alert_msg);
              Ext.MessageBox.alert('Alert',result.message);
          } else {
              Lino.notify(result.message);
          }
      }
      
      //~ if (result.alert_msg) Ext.MessageBox.alert('Alert',result.alert_msg);
      //~ if (result.message) Lino.notify(result.message);
      if (result.notify_msg) Lino.notify(result.notify_msg);
      if (result.js_code) { 
        //~ console.log('Lino.do_action()',action,'gonna call js_code in',result);
        var jsr = result.js_code(caller);
        //~ console.log('Lino.do_action()',action,'returned from js_code in',result);
        if (action.after_js_code) {
          //~ console.log('Lino.do_action()',action,'gonna call after_js_code');
          action.after_js_code(jsr);
          //~ console.log('Lino.do_action()',action,'returned from after_js_code');
        //~ } else {
          //~ console.log('Lino.do_action()',action,' : after_js_code is false');
        }
      };
    }
  };
  Ext.applyIf(action,{
    waitMsg: "Bitte warten...",
    failure: Lino.ajax_error_handler(caller),
    params: {}
  });
  //~ action.params.su = Lino.subst_user;
  Lino.insert_subst_user(action.params);
  
  Ext.Ajax.request(action);
};

//~ Lino.gup = function( name )
//~ {
  //~ // Thanks to http://www.netlobo.com/url_query_string_javascript.html
  //~ name = name.replace(/[\[]/,"\\\[").replace(/[\]]/,"\\\]");
  //~ var regexS = "[\\?&]"+name+"=([^&#]*)";
  //~ var regex = new RegExp( regexS );
  //~ var results = regex.exec( window.location.href );
  //~ if( results == null )
    //~ return "";
  //~ else
    //~ return results[1];
//~ };

//~ Lino.refresh_handler = function (ww) {
  //~ return function() { 
      //~ console.log('refresh',ww);
      //~ ww.main_item.doLayout(false,true);
      //~ ww.main_item.syncSize();
  //~ }
//~ };

//~ Lino.tools_close_handler = function (ww) {
  //~ return function() { 
      //~ ww.close();
  //~ }
//~ };
Lino.permalink_handler = function (ww) {
  return function() { 
    //~ document.location = ww.main_item.get_permalink();
    //~ console.log('20130723 Lino.permalink_handler',ww);
    
    /* Uncaught TypeError: Cannot read property 'main_item' of null  */
    if (ww) {
        var url = ww.main_item.get_permalink();
    } else {
        var url = Lino.viewport.get_permalink();
    }
    Lino.load_url(url);
  }
};
//~ Lino.run_permalink = function() {
  //~ var plink = Lino.gup('permalink');
  //~ if(plink) { eval('Lino.'+plink); }
//~ }


Lino.ajax_error_handler = function(panel) {
  return function(response,options) {
    console.log('Ajax failure:', response, options);
    if (panel.loadMask) panel.loadMask.hide();
    if (response.responseText) {
      var lines = response.responseText.split('\n');
      if (lines.length > 10) {
          line = lines.splice(5, lines.length-10, "(...)");
      }
      //~ console.log(20131005, response.statusText.toCamel());
      Ext.MessageBox.alert(
        response.statusText.toCamel(),
        lines.join('<br/>')
        //~ response.responseText.replace(/\n/g,'<br/>'))
      )
    } else {
      Ext.MessageBox.alert('Action failed',
        'Lino server did not respond to Ajax request');
    }
  }
}
// Ext.Ajax.on('requestexception',Lino.ajax_error_handler)
 


Ext.QuickTips.init();

/* setting QuickTips dismissDelay to 0 */
// Apply a set of config properties to the singleton
//~ Ext.apply(Ext.QuickTips.getQuickTip(), {
//~ Ext.apply(Ext.ToolTip, {
    //~ dismissDelay: 0
    //~ autoHide: false,
    //~ closable: true,
    //~ maxWidth: 200,
    //~ minWidth: 100,
    //~ showDelay: 50      // Show 50ms after entering target
    //~ ,trackMouse: true
//~ });


//~ Ext.apply(Ext.QuickTip, {
    //~ dismissDelay: 0,
//~ });
  
Lino.quicktip_renderer = function(title,body) {
  return function(c) {
    //~ if (c instanceof Ext.Panel) var t = c.bwrap; else // 20130129
    if (c instanceof Ext.Panel) var t = c.header; else // 20130129
    var t = c.getEl();
    //~ console.log(20130129,t,title,body);
    //~ t.dismissDelay = 0;
    Ext.QuickTips.register({
      target: t,
      //~ cls: 'lino-quicktip-classical',
      dismissDelay: 0,
      //~ autoHide: false,
      showDelay: 50,      // Show 50ms after entering target
      //~ title: title,
      text: body
    });
  }
};


  
Lino.help_text_editor = function() {
  //~ var bp = {
      //~ mk:this.content_type,
      //~ mt:1
    //~ };
    //~ console.log(20120202,bp);
  //~ Lino.lino.ContentTypes.detail({},{base_params:bp});
  //~ Lino.lino.ContentTypes.detail.run(null,{record_id:this.content_type});
  Lino.lino.ContentTypes.detail.run(null,{record_id:this.content_type});
}

// Path to the blank image should point to a valid location on your server
//~ Ext.BLANK_IMAGE_URL = MEDIA_URL + '/extjs/resources/images/default/s.gif'; 


// used as Ext.grid.Column.renderer for id columns in order to hide the special id value -99999
Lino.id_renderer = function(value, metaData, record, rowIndex, colIndex, store) {
  //~ if (record.phantom) return '';
  return value;
}

Lino.raw_renderer = function(value, metaData, record, rowIndex, colIndex, store) {
  return value;
}

Lino.text_renderer = function(value, metaData, record, rowIndex, colIndex, store) {
  //~ return "not implemented"; 
  return value;
}

Lino.NullNumberColumn = Ext.extend(Ext.grid.Column, {
    align : 'right', 
    format : '0,00/i', 
    renderer : function(value, metaData, record, rowIndex, colIndex, store) {
        //~ console.log(20130128,"NullNumberColumn.renderer",value);
        if (value === null) return '';
        return Ext.util.Format.number(value, this.format);
    }
});


Lino.link_button = function(url) {
    // return '<a href="' + url + '"><img src="/media/lino/extjs/images/xsite/link.png" alt="link_button"></a>'
    return '<a href="' + url + '" style="text-decoration:none;">&#10138;</a>'
}

Lino.fk_renderer = function(fkname,handlername) {
  //~ console.log('Lino.fk_renderer handler=',handler);
  return function(value, metaData, record, rowIndex, colIndex, store) {
    //~ console.log('Lino.fk_renderer',fkname,rowIndex,colIndex,record,metaData,store);
    //~ if (record.phantom) return '';
    if (value) {
        return Lino.link_button('javascript:'+handlername + '.run(null,{record_id:\'' + String(record.data[fkname]) + '\'})")') + value;
        // until 20140822 (clickable foreign keys):
        // var s = '<a href="javascript:' ;
        // s += handlername + '.run(null,{record_id:\'' + String(record.data[fkname]) + '\'})">';
        // s += value + '</a>';
        // return s
    }
    return '';
  }
};

Lino.lfk_renderer = function(panel,fkname) {
  //~ console.log('Lino.fk_renderer handler=',handler);
  var handlername = 'console.log';
  return function(value, metaData, record, rowIndex, colIndex, store) {
    //~ console.log('Lino.fk_renderer',fkname,rowIndex,colIndex,record,metaData,store);
    if (record.phantom) return '';
    if (value) {
        var s = '<a href="javascript:' ;
        s += handlername + '({},{record_id:\'' + String(record.data[fkname]) + '\'})">';
        s += value + '</a>';
        //~ console.log('Lino.fk_renderer',value,'-->',s);
        return s
    }
    return '';
  }
};

//~ Lino.gfk_renderer = function() {
  //~ return function(value, metaData, record, rowIndex, colIndex, store) {
    //~ if (record.phantom) return '';
    //~ console.log('Lino.gfk_renderer',value,colIndex,record,metaData,store);
    //~ return value;
  //~ }
//~ };


Lino.build_buttons = function(panel,actions) {
  //~ console.log("20121006 Lino.build_buttons",actions);
  if (actions) {
    var buttons = Array(actions.length);
    var cmenu = Array(actions.length);
    var keyhandlers = {};
    for (var i=0; i < actions.length; i++) { 
      var a = actions[i];
      if (a.menu) a.menu = Lino.build_buttons(panel,a.menu).bbar;
      buttons[i] = a;
      cmenu[i] = {
            text : a.menu_item_text,
            iconCls : a.iconCls,
            menu : a.menu
          };
      if (a.panel_btn_handler) {
          var h = a.panel_btn_handler.createCallback(panel);
          if (a.auto_save == true) {
              h = panel.do_when_clean.createDelegate(panel,[true,h]);
          } else if (a.auto_save == null) {
              h = panel.do_when_clean.createDelegate(panel,[false,h]);
          } else if (a.auto_save == false) {
              // h = h;
          } else {
              console.log("20120703 unhandled auto_save value",a)
          }
          buttons[i].handler = h;
          cmenu[i].handler = h;
          if (a.keycode) {
              keyhandlers[a.keycode] = h;
          }
          //~ if (buttons[i].xtype == 'splitbutton') {
              //~ cmenu[i].menu = a.menu;
          //~ } else {
              //~ cmenu[i].handler = h;
          //~ }
      } else {
          console.log("action without panel_btn_handler",a)
          // cmenu[i].handler = a.handler;
      }
    }
    return {
        bbar:buttons, 
        cmenu:new Ext.menu.Menu(cmenu),
        keyhandlers: keyhandlers
    };
  }
}

Lino.do_when_visible = function(cmp,todo) {
  //~ if (cmp.el && cmp.el.dom) 
  if (cmp.isVisible()) { 
    // 'visible' means 'rendered and not hidden'
    //~ console.log(cmp.title,'-> cmp is visible now');
    todo(); 
  //~ } else {
      //~ cmp.on('resize',todo,cmp,{single:true});
  //~ }
  //~ if (false) { // 20120213
  } else { 
    //~ console.log('Lino.do_when_visible() must defer because not isVisible()',todo,cmp);
    if (cmp.rendered) {
      //~ console.log(cmp,'-> cmp is rendered but not visible: and now?');
      //~ console.log(cmp.title,'-> cmp is rendered but not visible: try again in a moment...');
      //~ var fn = function() {Lino.do_when_visible(cmp,todo)};
      //~ fn.defer(100);
      
      Lino.do_when_visible.defer(50,this,[cmp,todo]);
      //~ Lino.do_when_visible.defer(100,this,[cmp,todo]);
      
    } else {
      //~ console.log(cmp.title,'-> after render');
      cmp.on('afterrender',todo,cmp,{single:true});
    }
  }
  
};    

/*
*/
Lino.do_on_current_record = function(panel, fn, phantom_fn) {
  // console.log('20140930 do_on_current_record', arguments);
  var rec = panel.get_current_record();
  if (rec == undefined) {
    Lino.notify("There's no selected record.");
    return;
  }
  // 20120307 A VirtualTable with a Detail (lino.Models) has only "phantom" records.
  if (rec.phantom) {
    //~ if (!panel.editable) { console.log("20120312 not editable:",panel)}
    if (phantom_fn) {
      phantom_fn(panel);
    } else {
      Lino.notify("Aktion nicht verfügbar auf dem Phantom-Record.");
    }
    return;
  }
  return fn(rec);
};


Lino.call_ajax_action = function(
    panel, method, url, p, actionName, step, on_confirm, on_success) {
  p.an = actionName;
  if (!panel || !panel.isVisible()) {
  //~ if (true) { // 20131026 : workflow_actions of a newly created record detail executed but did't refresh the screen because their requesting panel was the insert (not the detail) formpanel.
      if (Lino.current_window) 
          panel = Lino.current_window.main_item;
      else panel = Lino.viewport;
  }
  Ext.apply(p, panel.get_base_params());

  if (panel.get_selected) {
      var selected_recs = panel.get_selected();
      //~ console.log("20130831",selected_recs);
      var rs = Array(selected_recs.length);
      for(var i=0; i < selected_recs.length;i++) {
          rs[i] = selected_recs[i].data.id;
      };
      p.sr = rs;
  }
  
  // console.log("20140516 Lino.call_ajax_action", p, actionName, step);
  
  if (panel.loadMask) panel.loadMask.show(); 
    
  Ext.Ajax.request({
    method: method
    ,url: url
    ,params: p
    ,success: Lino.action_handler(panel, on_success, on_confirm)
    ,failure: Lino.ajax_error_handler(panel)
  });
};




Lino.row_action_handler = function(actionName, hm, pp) {
  var p = {};
  var fn = function(panel, btn, step) {
      // console.log('20140930 row_action_handler');
      if (pp) { p = pp(panel); if (! p) return; }
      
      if (!panel || panel.get_current_record == undefined) { // AFTER_20130725
        // console.log('20140930 row_action_handler 2', panel);
        panel = Ext.getCmp(panel);
        if (panel == undefined) {
          Lino.notify("Invalid panel spec.");
          return;
        }
      }
      
      Lino.do_on_current_record(panel, function(rec) {
          //~ console.log(panel);
          panel.add_param_values(p, true);
          Lino.call_ajax_action(
              panel, hm, panel.get_record_url(rec.id), 
              p, actionName, step, fn);
      });
  };
  return fn;
};

Lino.list_action_handler = function(ls_url,actionName,hm,pp) {
  var p = {};
  var url = '/api' + ls_url
  var fn = function(panel,btn,step) {
      //~ console.log("20121210 Lino.list_action_handler",arguments);
      if (pp) { p = pp(panel);  if (! p) return; }
      if (panel)  // may be undefined when called e.g. from quicklink
          panel.add_param_values(p,true);
      Lino.call_ajax_action(panel, hm,url, p, actionName, step, fn);
  };
  return fn;
};

Lino.param_action_handler = function(window_action) { // 20121012
  var fn = function(panel,btn,step) {
    Lino.do_on_current_record(panel,function(rec) {
      window_action.run(panel.getId(),{}); 
    });
  };
  return fn;
};


Lino.run_row_action = function(
    requesting_panel, url, meth, pk, actionName, params, preprocessor) {
  //~ var panel = action.get_window().main_item;
    console.log("20140930 Lino.run_row_action", params);
  url = '/api' + url  + '/' + pk;
  var panel = Ext.getCmp(requesting_panel);
  if (!params) params = {};
  if (preprocessor) {
      var p = preprocessor(); 
      Ext.apply(params, p);
  }
  var fn = function(panel, btn, step) {
    Lino.call_ajax_action(panel, meth, url, params, actionName, step, fn);
  }
  fn(panel, null, null);
}

Lino.put = function(requesting_panel, pk, data) {
    var panel = Ext.getCmp(requesting_panel);
    //~ var panel = null; // 20131026
    var p = {};
    p.an = 'put'; // SubmitDetail.action_name

    Ext.apply(p,data);
    var req = {
        params:p
        ,waitMsg: 'Saving your data...'
        ,scope: panel
        ,success: Lino.action_handler( panel, function(result) { 
            panel.refresh();
        })
        ,failure: Lino.ajax_error_handler(panel)
    };
    req.method = 'PUT';
    req.url = '/api' + panel.ls_url + '/' + pk;
    if (panel.loadMask) panel.loadMask.show(); 
    Ext.Ajax.request(req);
}



Lino.show_detail = function(panel, btn) {
  Lino.do_on_current_record(panel, 
    function(rec) {
      //~ panel.loadMask.show();
      Lino.run_detail_handler(panel, rec.id);
    },
    Lino.show_insert
  );
};

Lino.run_detail_handler = function(panel,pk) {
  var bp = panel.get_base_params();
  panel.add_param_values(bp); // 20120918
  var status = {
    record_id:pk,
    base_params:bp
  }
  //~ console.log("20120918 Lino.show_detail",status);
  panel.ls_detail_handler.run(null,status);
}

Lino.show_fk_detail = function(combo,detail_action,insert_action) {
    //~ console.log("Lino.show_fk_detail",combo,handler);
    pk = combo.getValue();
    if (pk) {
        detail_action.run(null,{record_id: pk})
      } else {
        insert_action.run(null,{record_id:-99999});
        //~ Lino.notify("Cannot show detail for empty foreign key.");
      }
};

Lino.show_insert = function(panel,btn) {
  var bp = panel.get_base_params();
  //~ console.log('20120125 Lino.show_insert',bp)
  //~ panel.ls_insert_handler.run(null,{record_id:-99999,base_params:bp});
  panel.ls_insert_handler.run(panel.getId(),{record_id:-99999,base_params:bp});
};



if (Ext.ux.grid !== undefined) {
    Lino.GridFilters = Ext.extend(Ext.ux.grid.GridFilters,{
      encode:true,
      local:false
    });
} else {
    Lino.GridFilters = function() {}; // dummy
    Ext.override(Lino.GridFilters,{
      init : function() {}
    });
};



Lino.FieldBoxMixin = {
  before_init : function(config,params) {
    if (params) Ext.apply(config,params);
    var actions = Lino.build_buttons(this, config.ls_bbar_actions);
    if (actions) config.bbar = actions.bbar;
  },
  //~ constructor : function(ww,config,params){
    //~ this.containing_window = ww;
    //~ if (params) Ext.apply(config,params);
    //~ var actions = Lino.build_buttons(this,config.ls_bbar_actions);
    //~ if (actions) config.bbar = actions.bbar;
    //~ Lino.FieldBoxMixin.superclass.constructor.call(this, config);
  //~ },
  do_when_clean : function(auto_save,todo) { todo() },
  //~ format_data : function(html) { return '<div class="htmlText">' + html + '</div>' },
  format_data : function(html) { return html },
  get_base_params : function() {
    // needed for insert action
    var p = Ext.apply({}, this.base_params);
    Lino.insert_subst_user(p);
    return p;
  },
  set_base_params : function(p) {
    this.base_params = Ext.apply({},p);
    //~ if (p.param_values) this.set_param_values(p.param_values);  
  },
  clear_base_params : function() {
      this.base_params = {};
      Lino.insert_subst_user(this.base_params);
  },
  set_base_param : function(k,v) {
    this.base_params[k] = v;
  }
};



Lino.HtmlBoxPanel = Ext.extend(Ext.Panel, Lino.PanelMixin);
Lino.HtmlBoxPanel = Ext.extend(Lino.HtmlBoxPanel, Lino.FieldBoxMixin);
Lino.HtmlBoxPanel = Ext.extend(Lino.HtmlBoxPanel, {
  disabled_in_insert_window : true,
  constructor : function(config,params) {
    this.before_init(config,params);
    Lino.HtmlBoxPanel.superclass.constructor.call(this, config);
  },
  //~ constructor : function(ww,config,params){
    //~ this.ww = ww;
    //~ if (params) Ext.apply(config,params);
    //~ var actions = Lino.build_buttons(this,config.ls_bbar_actions);
    //~ if (actions) config.bbar = actions.bbar;
    //~ Lino.FieldBoxMixin.constructor.call(this, ww,config,params);
  //~ },
  //~ constructor : function(ww,config,params){
    //~ this.ww = ww;
    //~ if (params) Ext.apply(config,params);
    //~ var actions = Lino.build_buttons(this,config.ls_bbar_actions);
    //~ if (actions) config.bbar = actions.bbar;
    //~ Lino.FieldBoxMixin.superclass.constructor.call(this, config);
  //~ },
  //~ disable : function() { var tb = this.getBottomToolbar(); if(tb) tb.disable()},
  //~ enable : function() { var tb = this.getBottomToolbar(); if(tb) tb.enable()},
  onRender : function(ct, position){
    Lino.HtmlBoxPanel.superclass.onRender.call(this, ct, position);
    //~ console.log(20111125,this.containing_window);
    if (this.containing_panel) {
      this.containing_panel.on('enable',this.enable,this);
      this.containing_panel.on('disable',this.disable,this);
    }
    this.el.on({
      dragenter:function(event){
        event.browserEvent.dataTransfer.dropEffect = 'move';
        return true;
      }
      ,dragover:function(event){
        event.browserEvent.dataTransfer.dropEffect = 'move';
        event.stopEvent();
        return true;
      }
      ,drop:{
        scope:this
        ,fn:function(event){
          event.stopEvent();
          //~ console.log(20110516);
          var files = event.browserEvent.dataTransfer.files;
          if(files === undefined){
            return true;
          }
          var len = files.length;
          while(--len >= 0){
            console.log(files[len]);
            //~ this.processDragAndDropFileUpload(files[len]);
          }
          Lino.show_insert(this);
        }
      }
    });
  },
  refresh : function(unused) { 
      // this.containing_panel.refresh();
      this.refresh_with_after();
  },
  /* HtmlBoxPanel */
  refresh_with_after : function(after) {
      // var todo = this.containing_panel.refresh();
      var box = this.items.get(0);
      var todo = function() {
        if (this.disabled) { return; }
        this.set_base_params(this.containing_panel.get_master_params());

        var el = box.getEl();
        if (el) {
            var record = this.containing_panel.get_current_record();
            var newcontent = record ? 
                this.format_data(record.data[this.name]) : '';
            // console.log('20140917 HtmlBox.refresh()',
            //             this.name, record.data.LinksByHuman);
            el.update(newcontent, true);
        // } else {
        //     console.log('20140502 cannot HtmlBox.refresh()',this.name);
        }
      };

      Lino.do_when_visible(box, todo.createDelegate(this));
  }
});
//~ Ext.override(Lino.HtmlBoxPanel,Lino.FieldBoxMixin);



Lino.RichTextPanel = Ext.extend(Ext.Panel,Lino.PanelMixin);
Lino.RichTextPanel = Ext.extend(Lino.RichTextPanel,Lino.FieldBoxMixin);
Lino.RichTextPanel = Ext.extend(Lino.RichTextPanel,{
    
  //~ initComponent : function(){
    //~ Lino.RichTextPanel.superclass.initComponent.call(this);
  //~ },
  constructor : function(config,params) {
    //~ console.log('Lino.RichTextPanel.initComponent',this);
    //~ var url = TEMPLATES_URL + config.ls_url + "/" + String(rec.id) + "/" + config.name;
    //~ var url = TEMPLATES_URL + config.ls_url + "/" + config.name;
    var t = this;
    var tinymce_options = {
        theme : "advanced",
        content_css: '/media/lino/extjs/lino.css',
        language: 'de',
        //~ template_external_list_url : url,
        theme_advanced_toolbar_location : "top",
        theme_advanced_toolbar_align : "left",
        theme_advanced_statusbar_location : "bottom",
        template_popup_width : 700,
        template_popup_height : 500,
        template_replace_values : { 
            data_field : function(element){ 
                //~ console.log(20110722,fieldName,t.containing_window.get_current_record()); 
                var fieldName = element.innerHTML;
                element.innerHTML = t.containing_panel.get_current_record().data[fieldName];
            } 
        }
      };
      
    var editorConfig = {
      tinymceSettings: {
        plugins : "noneditable,template", 
        // Theme options - button# indicated the row# only
        theme_advanced_buttons1 : "bold,italic,underline,|,justifyleft,justifycenter,justifyright,|,bullist,numlist,|,outdent,indent,|,undo,redo,|,removeformat,template",
        theme_advanced_buttons2 : "",
        theme_advanced_buttons3 : "", // ,|,sub,sup,|,charmap",      
        theme_advanced_resizing : false
        //~ save_onsavecallback : save_callback,
        //~ save_enablewhendirty : true
        //~ save_oncancelcallback: on_cancel
        
    }};
    Ext.apply(editorConfig.tinymceSettings,tinymce_options);
    //~ editorConfig.name = config.action_name;
    editorConfig.name = config.name;
    delete config.name;
    //~ config.title = config.label;
    //~ delete config.label;
    this.before_init(config,params);
    
    this.editor = new Ext.ux.TinyMCE(editorConfig);
    var t = this;
    config.tools = [{
                      qtip: "Text in eigenem Fenster bearbeiten", 
                      id: "up",
                      handler: function(){
                        if(t.editor.isDirty()) {
                            var record = t.containing_panel.get_current_record();
                            record.data[t.editor.name] = t.editor.getValue();
                        }
                        Lino.edit_tinymce_text(t, tinymce_options)
                      }
                    }];
    
    config.items = this.editor;
    config.layout = "fit";
    Lino.RichTextPanel.superclass.constructor.call(this, config);
  },
  refresh : function(unused) { 
      this.refresh_with_after();
  },
  /* RichTextPanel */
  refresh_with_after : function(after) {
    var record = this.containing_panel.get_current_record();
    // console.log('20140504 RichTextPanel.refresh()',
    //             this.title,record.title, record);
    var todo = function() {
      if (record) {
        var url = '/templates' 
              + this.containing_panel.ls_url + "/" 
              + String(record.id) + "/" + this.editor.name;
        //~ console.log('RichTextPanel.refresh()',url);
        if (this.editor.ed) this.editor.ed.settings.template_external_list_url = url;
        this.set_base_params(this.containing_panel.get_master_params());
        //~ var v = record ? this.format_data(record.data[this.editor.name]) : ''
        var v = this.format_data(record.data[this.editor.name])
        this.editor.setValue(v);
      } else {
        this.editor.setValue('(no data)');
      }
    };
    Lino.do_when_visible(this,todo.createDelegate(this));
  }
});
//~ Ext.override(Lino.RichTextPanel,Lino.FieldBoxMixin);



Lino.ActionFormPanel = Ext.extend(Ext.form.FormPanel,Lino.MainPanel);
Lino.ActionFormPanel = Ext.extend(Lino.ActionFormPanel, Lino.PanelMixin);
Lino.ActionFormPanel = Ext.extend(Lino.ActionFormPanel, Lino.FieldBoxMixin);
Lino.ActionFormPanel = Ext.extend(Lino.ActionFormPanel, {
  //~ layout:'fit'
  //~ ,autoHeight: true
  //~ ,frame: true
  window_title : "Action Parameters",
  constructor : function(config){
    config.bbar = [
        {text: 'OK', handler: this.on_ok, scope: this},
        {text: 'Cancel', handler: this.on_cancel, scope: this}
    ];
    Lino.ActionFormPanel.superclass.constructor.call(this, config);
  }
  //~ ,initComponent : function(){
    //~ Lino.ActionFormPanel.superclass.initComponent.call(this);
  //~ }
  ,on_cancel : function() { 
    this.get_containing_window().close();
  }
  ,on_ok : function() { 
    var panel = this.requesting_panel;
    // var panel = this.get_containing_window().main_item;
    // console.log("20131004 on_ok",this,panel,arguments);
    var actionName = this.action_name;
    var pk = this.record_id;
    if (pk == undefined && this.base_params) { pk = this.base_params.mk; }
    if (pk == undefined && panel) {
        pk = panel.get_current_record().id;
    }
    if (pk == undefined) {
        Lino.alert("Sorry, dialog action without base_params.mk");
        return;
    }
    var self = this;
    // function on_success() { self.get_containing_window().close(); };
    // see 20131004 and 20140430
    var url = '/api';
    if (panel) 
        url += panel.ls_url;
    else 
        url += this.ls_url;
    url += '/' + pk;
    // prepare possible recursive call
    var fn = function(panel, btn, step) {
      var p = {};
      self.add_field_values(p)
      Lino.call_ajax_action(
          panel, 'GET', url, p, actionName, step, fn); //  , on_success);
    }
    fn(panel, null, null);
    
    
  }
  /* ActionFormPanel*/
  ,set_status : function(status, rp){
    this.requesting_panel = Ext.getCmp(rp);
    //~ console.log('20120918 ActionFormPanel.set_status()',status,rp,this.requesting_panel);
    this.clear_base_params();
    if (status == undefined) status = {};
    //~ if (status.param_values) 
    this.set_field_values(status.field_values);
    if (status.base_params) this.set_base_params(status.base_params);
    this.record_id = status.record_id;
  }
  
  ,before_row_edit : function(record) {}
  ,add_field_values : function (p) { // similar to add_param_values()
      //~ 20121023 
      if (this.form.isDirty()) {
        p.fv = this.get_field_values();
      }else{
        if (this.status_field_values) 
          p.fv = Lino.fields2array(this.fields,this.status_field_values);
      }
      //~ if (!this.form.isDirty()) return;
      //~ p.$ext_requests.URL_PARAM_FIELD_VALUES = this.get_field_values();
      //~ console.log("20120203 add_param_values added pv",pv,"to",p);
  }
  ,get_field_values : function() {
      return Lino.fields2array(this.fields);
  }
  ,set_field_values : function(pv) {
      //~ console.log('20120203 MainPanel.set_param_values', pv);
      this.status_field_values = pv;
      if (pv) {
          this.form.my_loadRecord(pv);
          var record = { data: pv };
          this.before_row_edit(record);
      } else {
          this.form.reset(); 
          this.before_row_edit();
      }
  }
  ,config_containing_window : function(wincfg) { 
      wincfg.title = this.window_title;
      wincfg.keys = [
        { key: Ext.EventObject.ENTER, fn: this.on_ok }
      ]
      
      if (!wincfg.defaultButton) this.getForm().items.each(function(f){
          if(f.isFormField){ 
              wincfg.defaultButton = f;
              return false;
          }
      });

  }
});

    
Lino.fields2array = function(fields,values) {
    //~ console.log('20130605 fields2array gonna loop on', fields,values);
    var pv = Array(fields.length);
    for(var i=0; i < fields.length;i++) {
        var f = fields[i]
        if (values) 
          var v = values[f.name];
        else 
          var v = f.getValue();
        if (f.formatDate) {
            pv[i] = f.formatDate(v); 
        } else {
            pv[i] = v; // f.getValue(); 
        }
    }
    return pv;
}


Lino.FormPanel = Ext.extend(Ext.form.FormPanel,Lino.MainPanel);
Lino.FormPanel = Ext.extend(Lino.FormPanel,Lino.PanelMixin);
Lino.FormPanel = Ext.extend(Lino.FormPanel,{
  params_panel_hidden : false,
  save_action_name : null, 
  //~ base_params : {},
  //~ trackResetOnLoad : true,
  //~ query_params : {},
  //~ 20110119b quick_search_text : '',
  constructor : function(config,params){
    if (params) Ext.apply(config,params);
    this.base_params = {};
    //~ ww.config.base_params.query = ''; // 20111018
    //~ console.log(config);
    //~ console.log('FormPanel.constructor() 1',config)
    //~ Ext.applyIf(config,{base_params:{}});
    //~ console.log('FormPanel.constructor() 2',config)
      
    config.trackResetOnLoad = true;
    
    Lino.FormPanel.superclass.constructor.call(this, config);
      
    //~ this.set_base_param('$URL_PARAM_FILTER',null); // 20111018
    //~ this.set_base_param('$URL_PARAM_FILTER',''); // 20111018
      
  },
  initComponent : function(){
    
    this.containing_panel = this;

    //~ console.log("20111201 containing_window",this.containing_window,this);


    var actions = Lino.build_buttons(this,this.ls_bbar_actions);
    if (actions) {
        this.bbar = actions.bbar;
    //~ } else {
        //~ this.bbar = [];
    }
    //~ Ext.apply(config,Lino.build_buttons(this,config.ls_bbar_actions));
    //~ config.bbar = Lino.build_buttons(this,config.ls_bbar_actions);
    //~ var config = this;
    
    //~ if (this.containing_window instanceof Lino.DetailWrapper) {
    
    //~ console.log('20120121 initComponent', this.action_name);
    //~ if (this.action_name == 'detail' | this.action_name == 'show') {
    //~ if (this.action_name != 'insert') {
    if (! this.hide_top_toolbar) {
      this.tbar = [];
      // 20111015    
      if (! this.hide_navigator) {
        this.record_selector = new Lino.RemoteComboFieldElement({
          store: new Lino.ComplexRemoteComboStore({
            //~ baseParams: this.containing_window.config.base_params,
            baseParams: this.get_base_params(),
            //~ value: this.containing_window.config.base_params.query,
            proxy: new Ext.data.HttpProxy({
              url: '/choices' + this.ls_url,
              method:'GET'
            })
          }),
          pageSize:25,
          listeners: { 
            scope:this, 
            select:function(combo,record,index) {
              //~ console.log('jumpto_select',arguments);
              this.goto_record_id(record.id);
            }
          },
          emptyText: "Gehe zu Datensatz"
        })
        this.tbar = this.tbar.concat([this.record_selector]);
        
        this.tbar = this.tbar.concat([
          this.first = new Ext.Toolbar.Button({
              tooltip:"Erster",disabled:true,
              handler:this.moveFirst,scope:this,iconCls:'x-tbar-page-first'}),
          this.prev = new Ext.Toolbar.Button({
              tooltip:"Voriger",disabled:true,
              handler:this.movePrev,scope:this,iconCls:'x-tbar-page-prev'}),
          this.next = new Ext.Toolbar.Button({
              tooltip:"Nächster",disabled:true,
              handler:this.moveNext,scope:this,iconCls:'x-tbar-page-next'}),
          this.last = new Ext.Toolbar.Button({
              tooltip:"Letzter",disabled:true,
              handler:this.moveLast,scope:this,iconCls:'x-tbar-page-last'})
        ]);
      }
      this.tbar = this.add_params_panel(this.tbar);
      
      //~ console.log(20101117,this.containing_window.refresh);
      this.tbar = this.tbar.concat([
        {
          //~ text:'Refresh',
          handler:function(){ this.do_when_clean(false,this.refresh.createDelegate(this)) },
          iconCls: 'x-tbar-loading',
          tooltip:"Datensatz neu laden",
          scope:this}
      ]);
          
      if (this.bbar) { // since 20121016
        if (this.tbar) {
            this.tbar = this.tbar.concat(['-']) ;
        } else {
          this.tbar = [];
        }
        this.tbar = this.tbar.concat(this.bbar) ;
        this.bbar = undefined;
      }
    
      this.tbar = this.tbar.concat([
          '->',
          this.displayItem = new Ext.Toolbar.TextItem({})
      ]);
          
    }
    //~ if (this.content_type && this.action_name != 'insert') {
      //~ this.bbar = this.bbar.concat([
        //~ '->',
        //~ { text: "[$_('Help Text Editor')]",
          //~ handler: Lino.help_text_editor,
          //~ qtip: "$_('Edit help texts for fields on this model.')",
          //~ scope: this}
      //~ ])
    //~ }
    //~ this.before_row_edit = config.before_row_edit.createDelegate(this);
      
    //~ if (this.master_panel) {
        //~ this.set_base_params(this.master_panel.get_master_params());
    //~ }
      
    Lino.FormPanel.superclass.initComponent.call(this);

    // this.on('show',
    //         function(){ this.init_focus();}, 
    //         this);
    
    this.on('render',function(){
      this.loadMask = new Ext.LoadMask(this.bwrap,{msg:"Bitte warten..."});
    },this);
    
    
    if (this.action_name == 'insert') {
      this.cascade(function(cmp){
        // console.log('20110613 cascade',cmp);
        if (cmp.disabled_in_insert_window) {
            //~ cmp.disable();
            cmp.hide();
        }
      });
      
    }
    
  },
  
  unused_init_focus : function(){ 
    // set focus to the first field
    console.log("20140205 Lino.FormPanel.init_focus");
    // Lino.FormPanel.superclass.focus.call(this);
    this.getForm().items.each(function(f){
        if(f.isFormField && f.rendered){ 
            f.focus();
            console.log("20140205 focus", f);
            return false;
        }
    });
  },

  /* FormPanel */
  get_status : function(){
      var st = {
        base_params: this.get_base_params(),
        // data_record : this.get_current_record()
        }
      st.record_id = this.get_current_record().id;
      // 20140917 : get_status must not store the whole data_record
      // because that would prevent the form to actually reload
      // when set_status is called after a child window closed.
      
      var tp = this.items.get(0);
      if (tp instanceof Ext.TabPanel) {
        st.active_tab = tp.getActiveTab();
      }
      st.param_values = this.status_param_values;
      return st;
  },

  /* FormPanel */
  set_status : function(status, rp){
    this.requesting_panel = Ext.getCmp(rp);
    // console.log('20140917 FormPanel.set_status()', status);
    this.clear_base_params();
    if (status == undefined) status = {};
    //~ if (status.param_values) 
    this.set_param_values(status.param_values);
    if (status.base_params) this.set_base_params(status.base_params);
    var tp = this.items.get(0);
    if (tp instanceof Ext.TabPanel) {
      if (status.active_tab) {
        //~ console.log('20111201 active_tab',this.active_tab,this.items.get(0));
        //~ tp.activeTab = status.active_tab;
        tp.setActiveTab(status.active_tab);
        //~ this.main_item.items.get(0).activate(status.active_tab);
      } else {
        if (! status.data_record) {  // 20141206
            tp.setActiveTab(0);
        }
      }
    }
    
    if (status.data_record) {
      /* defer because set_window_title() didn't work otherwise */
      // 20140421 removed defer for bughunting to simplify side effects
      // this.set_current_record.createDelegate(
      //     this, [status.data_record]).defer(100);
      this.set_current_record(status.data_record);
      //~ return;
    } else if (status.record_id != undefined) { 
      /* possible values include 0 and null, 0 being a valid record id, 
      null the equivalent of undefined
      */
      this.load_record_id(status.record_id);
    } else {
      this.set_current_record(undefined);
    }
    // this.init_focus()
  }
  ,get_base_params : function() {  /* FormPanel */
    // needed for insert_action
    var p = Ext.apply({}, this.base_params);
    Lino.insert_subst_user(p);
    return p;
  }
  ,set_base_params : function(p) {
    //~ this.base_params = Ext.apply({},this.base_params); // make sure it is an instance variable
    delete p['query'] // 20120725
    Ext.apply(this.base_params,p);
    if (this.record_selector) {
        var store = this.record_selector.getStore();
        for (k in p) store.setBaseParam(k,p[k]);
        delete this.record_selector.lastQuery;
        //~ console.log("20120725 record_selector.setBaseParam",p)
    }
  }
  ,clear_base_params : function() {
      this.base_params = {};
      Lino.insert_subst_user(this.base_params);
  }
  ,set_base_param : function(k,v) {
    this.base_params[k] = v;
  }
  ,after_delete : function() {
    if (this.current_record.navinfo.next)
      this.moveNext();
    else if (this.current_record.navinfo.prev)
      this.movePrev();
    else 
      this.abandon();
  }
  ,moveFirst : function() {this.goto_record_id(
      this.current_record.navinfo.first)}
  ,movePrev : function() {this.goto_record_id(
      this.current_record.navinfo.prev)}
  ,moveNext : function() {this.goto_record_id(
      this.current_record.navinfo.next)}
  ,moveLast : function() {this.goto_record_id(
      this.current_record.navinfo.last)}
  
  ,refresh : function(unused) { 
      this.refresh_with_after();
  }
  /* FormPanel */
  ,refresh_with_after : function(after) { 
    // console.log('20140917 Lino.FormPanel.refresh_with_after()',this);
    if (this.current_record) {
        this.load_record_id(this.current_record.id, after);
    } else {
        this.set_current_record(undefined, after);
    }
  }
  
  ,do_when_clean : function(auto_save, todo) {
    var this_ = this;
    if (this.form.isDirty()) {
        // console.log('20140421 do_when_clean : form is dirty')
        if (auto_save) {
            this_.save(todo);
        } else {
          //~ console.log('20111217 do_when_clean() form is dirty',this.form);
          var config = {title:"Bestätigung"};
          config.buttons = Ext.MessageBox.YESNOCANCEL;
          config.msg = "Änderungen in diesem Datensatz speichern?";
          config.fn = function(buttonId,text,opt) {
            //~ console.log('do_when_clean',buttonId)
            if (buttonId == "yes") {
                //~ Lino.submit_detail(this_,undefined,todo);
                //~ this_.containing_window.save(todo);
                this_.save(todo);
            } else if (buttonId == "no") { 
              todo();
            }
          }
        }
        Ext.MessageBox.show(config);
    }else{
      // console.log('20140421 do_when_clean : now!')
      todo();
    }
  }
  
  ,goto_record_id : function(record_id) {
    // console.log('20140917 Lino.FormPanel.goto_record_id()',record_id);
    //~ var this_ = this;
    //~ this.do_when_clean(function() { this_.load_record_id(record_id) }
    this.do_when_clean(
        true, this.load_record_id.createDelegate(this, [record_id]));
  }
  
  ,load_record_id : function(record_id, after) {
    var this_ = this;
    var p = Ext.apply({}, this.get_base_params());
    if (this.action_name)
        p.an = this.action_name;
    p.rp = this.getId();
    p.fmt = 'json';
    this.add_param_values(p);
    if (this.loadMask) this.loadMask.show();
    Ext.Ajax.request({ 
      waitMsg: 'Loading record...',
      method: 'GET',
      params: p,
      scope: this,
      url: this.get_record_url(record_id),
      success: function(response) {   
        // todo: convert to Lino.action_handler.... but result 
        if (this.loadMask) this.loadMask.hide();
        if (response.responseText) {
          var rec = Ext.decode(response.responseText);
          // console.log('20140917 load_record_id success', rec);
          this.set_param_values(rec.param_values);
          this.set_current_record(rec, after);
        }
      },
      failure: Lino.ajax_error_handler(this)
    });
  }

  ,abandon : function () {
    Ext.MessageBox.alert('Note',
      "Keine weiteren Datensätze zu sehen. Detail-Fenster wird geschlossen.");
    Lino.close_window();
  }
  
  ,set_current_record : function(record, after) {
    if (this.record_selector) {
        this.record_selector.clearValue();
        // e.g. InsertWrapper FormPanel doesn't have a record_selector
    }
    this.current_record = record;
    if (record) {
      this.enable();
      this.form.my_loadRecord(record.data);
      this.set_window_title(record.title);
      //~ this.getBottomToolbar().enable();
      var da = record.data.disabled_actions;
      if (da) {
          //~ console.log('20120528 disabled_actions =',da,this.getBottomToolbar());
          //~ 20121016 this.getBottomToolbar().items.each(function(item,index,length){
          var tb = this.getTopToolbar();
          if (tb) tb.items.each(function(item,index,length){
              //~ console.log('20120528 ',item.itemId,'-->',da[item.itemId]);
              if (da[item.itemId]) item.disable(); else item.enable();
          });
      };
      if (this.disable_editing | record.data.disable_editing) {
          //~ console.log("20120202 disable_editing",record.title);
          this.form.items.each(function(cmp){
            if (!cmp.always_enabled) cmp.disable();
          },this);
      } else {
          this.form.items.each(function(cmp){
            //~ console.log("20120202",cmp);
            if (record.data.disabled_fields[cmp.name]) cmp.disable();
            else cmp.enable();
          },this);
        
          //~ if (record.data.disabled_fields) {
              //~ for (i = 0; i < record.data.disabled_fields.length; i++) {
                  //~ var flds = this.find('name',record.data.disabled_fields[i]);
                  //~ if (flds.length == 1) { 
                    //~ flds[0].disable(); 
                  //~ }
              //~ }
          //~ }
      };
      if (this.first) {
        if (record.navinfo  && ! this.hide_navigator) {
          this.first.setDisabled(!record.navinfo.first);
          this.prev.setDisabled(!record.navinfo.prev);
          this.next.setDisabled(!record.navinfo.next);
          this.last.setDisabled(!record.navinfo.last);
          this.displayItem.setText(record.navinfo.message);
        } else {
          this.first.setDisabled(true);
          this.prev.setDisabled(true);
          this.next.setDisabled(true);
          this.last.setDisabled(true);
        }
      }
    } else {
      if (this.form.rendered) 
        this.form.reset(); /* FileUploadField would fail when resetting a non-rendered form */
      //~ this.disable();
      //~ this.getBottomToolbar().disable();
      this.form.items.each(function(cmp){
        cmp.disable();
      },this);
      this.set_window_title(this.empty_title);
      //~ this.containing_window.window.setTitle(this.empty_title);
      if (!this.hide_navigator) {
        this.first.disable();
        this.prev.disable();
        this.next.disable();
        this.last.disable();
      }
    }
    // console.log('20140917 gonna call before_row_edit', record);
    this.before_row_edit(record);
    // console.log('20140917 gonna call after', after);
    if (after) after();
  },
  
  /* FormPanel */
  before_row_edit : function(record) {},
  search_change : function(field,oldValue,newValue) {
    //~ console.log('search_change',field.getValue(),oldValue,newValue)
    this.set_base_param('query',field.getValue()); 
    this.refresh();
  },
  
  get_selected : function() { return [ this.current_record ] },
  get_current_record : function() {  
    //~ console.log(20100714,this.current_record);
    return this.current_record 
  },
  
  get_permalink_url : function() {
      var rec = this.get_current_record();
      if (rec && ! rec.phantom && rec.id != -99998)
          return '/api' 
              + this.ls_url + '/' + rec.id;
      return '/api' + this.ls_url;
    
  },
  add_param_tab : function(p) {
    var main = this.items.get(0);
    if (main.activeTab) {
      var tab = main.items.indexOf(main.activeTab);
      //~ console.log('main.activeTab',tab,main.activeTab);
      if (tab) p.tab = tab;
    }
  },
  get_permalink_params : function() {
    var p = {};
    //~ var p = {an:'detail'};
    if (this.action_name)
        p.an = this.action_name;
    this.add_param_tab(p)
    this.add_param_values(p)
    return p;
  }
  
  ,validate_form : function() {  // not used. see actions.ValidateForm
      // var ov = {};
      // this.form.items.each(function(f){
      //     ov[f.name] = f.originalValue
      // });

      // console.log('20140509 FormPanel.validate_form', ov);
      // var after = function() { 
      //     this.form.items.each(function(f){
      //         f.originalValue = ov[f.name];
      //     });
      // }
      // this.save2(null, 'validate', after);
      this.save2(null, 'validate');
  }

  /* Lino.FormPanel */
  ,save : function(after) {
    var action_name = this.save_action_name;
    if (!action_name) 
        action_name = this.action_name;
    // console.log('20140503 FormPanel.save', action_name);
    this.save2(after, action_name);
  }

  ,save2 : function(after, action_name) {
    var rec = this.get_current_record();
    if (!rec) { 
        Lino.notify("Sorry, no current record."); 
        return; 
    }
    var panel = this;
    if (this.has_file_upload) this.form.fileUpload = true;
    //~ console.log('FormPanel.save()',rec);
    this.loadMask.show();
    var p = {};
    Ext.apply(p, this.get_base_params());
    p.rp = this.getId();
    p.an = action_name;
    this.add_param_tab(p)
    var submit_config = {
        params: p, 
        scope: this,
        success: function(form, action) {
          this.loadMask.hide();
          Lino.notify(action.result.message);
          Lino.handle_action_result(this, action.result, after);
        },
        failure: function(form,action) { 
          this.loadMask.hide();
          Lino.on_submit_failure(form, action);
        },
        clientValidation: true
    };
    if (rec.phantom) {  // it's a new record
      Ext.apply(submit_config, {
        url: '/api' + this.ls_url,
        method: 'POST'
      });
    } else {  // submit on existing row
      Ext.apply(submit_config, {
        url: '/api' 
              + this.ls_url + '/' + rec.id,
        method: 'PUT'
      })
    }
    this.form.submit(submit_config);
  }
  
  ,on_cancel : function() { 
    this.get_containing_window().close();
  }
  ,on_ok : function() { 
      // console.log("20140424");
      // this.save(null, true, this.save_action_name);
      this.save();
  }
  ,config_containing_window : function(wincfg) { 

      // Note that defaultButton means: which component should receive
      // focus when Window is focussed.  If no defaultButton set,
      // specify the first form field.

      if (!wincfg.defaultButton) this.getForm().items.each(function(f){
          if(f.isFormField){ 
              wincfg.defaultButton = f;
              // console.log("20140205 defaultButton", f);
              return false;
          }
      });

      wincfg.keys = [
          {
              key: Ext.EventObject.ENTER,
              scope:this,
              fn: function(k, e) {
                  if(e.target.type === 'textarea' && !e.ctrlKey) {
                      return true;
                  }
                  this.on_ok();
              }
          },
          { key: Ext.EventObject.ESCAPE, fn: this.on_cancel, scope:this }
          // ,{ key: 's', ctrl: true, 
          //    stopEvent: true,
          //    fn: this.on_ctrl_s, scope:this }
      ]
  }
  
});



Lino.getRowClass = function(record, rowIndex, rowParams, store) {
    //~ console.log(20130816,record);
    //~ return 'x-grid3-row-green';
    //~ return record.data.row_class + ' auto-height';
    return record.data.row_class;
  //~ if (true) {
      //~ return 'x-grid3-row-red';
  //~ }
  //~ if (record.phantom) {
    //~ console.log(20101009,record);
    //~ rowParams.bodyStyle = "color:red;background-color:blue";
    //~ return 'lino-phantom-row';
    //~ }
  //~ console.log('20101009 not a phantom:',record);
  //~ return '';
}

//~ FOO = 0;



Lino.GridStore = Ext.extend(Ext.data.ArrayStore,{ 
  autoLoad: false
  ,load: function(options) {
    //~ foo.bar = baz; // 20120213
    if (!options) options = {};
    if (!options.params) options.params = {};
    options.params.fmt = 'json';
    options.params.rp = this.grid_panel.getId();
    Lino.insert_subst_user(options.params); // since 20121016
      
    var start = this.grid_panel.start_at_bottom ? -1 : 0;
    if (this.grid_panel.hide_top_toolbar) {
        //~ console.log("20120206 GridStore.load() toolbar is hidden");
        options.params.start = start;
        if (this.grid_panel.preview_limit) {
          options.params.limit = this.grid_panel.preview_limit;
        }
    } else {
        var ps = this.grid_panel.calculatePageSize();
        if (!ps) {
          // console.log("GridStore.load() failed to calculate pagesize");
          return false;
        } 
        options.params.limit = ps;
      
        this.grid_panel.getTopToolbar().pageSize =  ps;
        if (options.params.start == undefined)
            // if (start != -1) 
            //     start = this.grid_panel.getTopToolbar().cursor
            options.params.start = start;
      
        // console.log("20141108 GridStore.load() ", options.params);
    }
      
    this.grid_panel.add_param_values(options.params);
    //~ Lino.insert_subst_user(options.params);
    //~ console.log("20120814 GridStore.load()",options.params,this.baseParams);
    return Lino.GridStore.superclass.load.call(this, options);
  }
  // ,insert : function(index, records) {
  //   return Ext.data.Store.prototype.insert.call(this, index, records)
    // return Lino.GridStore.superclass.insert.call(this, index, records);
  // }
});

Lino.get_current_grid_config = function(panel) {
    return panel.get_current_grid_config();
}


// Like the default value for GridView.cellTpl but adds a class "lino-auto-height"
Lino.auto_height_cell_template = new Ext.Template(
'<td class="x-grid3-col x-grid3-cell x-grid3-td-{id} {css}" style="{style}" tabIndex="0" {cellAttr}>',
    '<div class="lino-auto-height x-grid3-cell-inner x-grid3-col-{id}" unselectable="on" {attr}>{value}</div>',
'</td>'
);

Lino.GridPanel = Ext.extend(Ext.grid.EditorGridPanel, Lino.MainPanel);
Lino.GridPanel = Ext.extend(Lino.GridPanel, Lino.PanelMixin);
Lino.GridPanel = Ext.extend(Lino.GridPanel, {
  quick_search_text : '',
  start_at_bottom : false,
  is_searching : false,
  disabled_in_insert_window : true,
  clicksToEdit:2,
  enableColLock: false,
  autoHeight: false,
  params_panel_hidden : false,
  preview_limit : undefined, 
  //~ loadMask: true,
  //~ viewConfig: {
          //~ getRowClass: Lino.getRowClass,
          //~ emptyText:"$_('No data to display.')"
        //~ },
        
        
  loadMask: {msg:"Bitte warten..."},
  
  constructor : function(config){

    config.plugins = [new Lino.GridFilters()];
    
    
    Lino.GridPanel.superclass.constructor.call(this,config);
    
    //~ if (this.containing_window) {
        //~ console.log("20111206 install refresh");
        //~ this.containing_window.on('show',this.refresh,this);
    //~ }
    
  },
  
  init_containing_window : function(win) { 
    //~ console.log("20111206 install refresh");
    //~ win.on('show',this.refresh,this);
  }

  ,handle_key_event : function(e) { 
    // console.log("20140514 handle_key_event", e, this.keyhandlers);
    var h = this.keyhandlers[e.keyCode];
    if (h) {
      h(this);
      e.stopEvent();
    }
  }
  
  ,initComponent : function(){
    
    /* 
    Problem 20111206:
    When a GridPanel is the main item of the window, then it doesn't 
    have it's own header but uses the window's header bar.
    We must do this in initComponent because e.g. in beforerender 
    it's already to late: a header element has been created because 
    there was a title.
    But Lino.Window adds itself as `this.containing_window` 
    only after the GridPanel has been initialized.
    Workaround is to generate a line "params.containing_window = true;" 
    in the handler function.
    */ 
    if (this.is_main_window) {
        //~ console.log(20111206, 'delete title',this.title,'from',this);
        this.tools = undefined;  
        this.title = undefined;  /* simply deleting it 
          isn't enough because that would only 
          unhide the title defined in some base class. */
    } 
    //~ else console.log(20111206, 'dont delete title',this.title,'from',this);
    
    /* e.g. when slave gridwindow called from a permalink */
    //~ if (this.base_params) Ext.apply(bp,this.base_params);  
    
    var proxy = new Ext.data.HttpProxy({ 
      // 20120814 
      url: '/api' + this.ls_url
      ,method: "GET"
      //~ ,url: ADMIN_URL + '/restful' + this.ls_url
      //~ ,restful: true 
      //~ ,listeners: {load:on_proxy_load} 
      //~ ,listeners: {write:on_proxy_write} 
    });
    //~ config.store = new Ext.data.JsonStore({ 
    //~ this.store = new Ext.data.ArrayStore({ 
    this.store = new Lino.GridStore({ 
      grid_panel: this
      ,listeners: { exception: Lino.on_store_exception }
      ,remoteSort: true
      ,totalProperty: "count"
      ,root: "rows"
      //~ ,id: "id" 
      ,proxy: proxy
      //~ autoLoad: this.containing_window ? true : false
      ,idIndex: this.pk_index
      //~ ,baseParams: bp
      ,fields: this.ls_store_fields
      ,idProperty: this.ls_id_property 
      // 20120814
      //~ ,writer : new Ext.data.JsonWriter({
        //~ writeAllFields: false
        //~ ,listful: true
      //~ })
      //~ ,restful : true
    });
      
    //~ console.log('config.pk_index',config.pk_index,config.store),
    delete this.ls_store_fields;
      
    var this_ = this;
    //~ var grid = this;
    this.store.on('load', function() {
        //~ console.log('20120814 GridStore.on(load)',this_.store);
        this_.set_param_values(this_.store.reader.arrayData.param_values);
        //~ this_.set_status(this_.store.reader.arrayData.status);
        //~ 20120918
        this.getView().getRowClass = Lino.getRowClass;
        
        if (this_.store.reader.arrayData.no_data_text) {
            //~ this.viewConfig.emptyText = this_.store.reader.arrayData.no_data_text;
            this.getView().emptyText = this_.store.reader.arrayData.no_data_text;
            this.getView().refresh();
        }
        if (this_.containing_window)
            this_.set_window_title(this_.store.reader.arrayData.title);
            //~ this_.containing_window.setTitle(this_.store.reader.arrayData.title);
        if (!this.is_searching) { // disabled 20121025: quick_search_field may not lose focus
          this.is_searching = false;
          if (this_.selModel.getSelectedCell){
              if (this_.getStore().getCount()) // there may be no data
                  this_.selModel.select(0,0); 
          } else {
              this_.selModel.selectFirstRow();
              this_.getView().focusEl.focus();
          }
        } 
        //~ else console.log("is_searching -> no focussing");
        //~ var t = this.getTopToolbar();
        //~ var activePage = Math.ceil((t.cursor + t.pageSize) / t.pageSize);
        //~ this.quick_search_field.focus(); // 20121024
      }, this
    );
    var actions = Lino.build_buttons(this, this.ls_bbar_actions);
    //~ Ext.apply(config,Lino.build_buttons(this,config.ls_bbar_actions));
    //~ config.bbar, this.cmenu = Lino.build_buttons(this,config.ls_bbar_actions);
    //~ this.cmenu = new Ext.menu.Menu({items: config.bbar});
    delete this.ls_bbar_actions
    if (actions) {
        this.cmenu = actions.cmenu;
        this.keyhandlers = actions.keyhandlers;
    }
    
    if (!this.hide_top_toolbar) {  
      var tbar = [ 
        this.quick_search_field = new Ext.form.TextField({ 
          //~ fieldLabel: "Search"
          listeners: { 
            scope:this_
            //~ ,change:this_.search_change
            
            ,render: Lino.quicktip_renderer("Schnellsuche","Hier Text eingeben für Schnellsuche.")
            
            //~ ,keypress: this.search_keypress 
            ,blur: function() { this.is_searching = false}
          }
          ,validator:function(value) { return this_.search_validate(value) }
          //~ ,tooltip: "Enter a quick search text, then press TAB"
          //~ value: text
          //~ scope:this, 
          //~ ,enableKeyEvents: true
          //~ listeners: { keypress: this.search_keypress }, 
          //~ id: "seachString" 
      })];
      tbar = this.add_params_panel(tbar);
      var menu = [];
      var set_gc = function(index) {
        return function() {
          //~ console.log('set_gc() 20100812');
          this.getColumnModel().setConfig(
              this.apply_grid_config(index,this.ls_grid_configs,this.ls_columns));
        }
      }
      for (var i = 0; i < this.ls_grid_configs.length;i++) {
        var gc = this.ls_grid_configs[i];
        menu.push({text:gc.label,handler:set_gc(i),scope:this})
      }
      if(menu.length > 1) {
        tbar = tbar.concat([
          { text:"Ansicht",
            menu: menu,
            tooltip:"Andere Ansicht auswählen"
          }
        ]);
      }
      
      if (actions) {
        tbar = tbar.concat(actions.bbar);
          //~ this.bbar = actions.bbar;
      }
      
      this.tbar = new Ext.PagingToolbar({ 
        store: this.store, 
        prependButtons: true, 
        //~ pageSize: this.page_length, 
        pageSize: 1, 
        displayInfo: true, 
        beforePageText: "Seite",
        afterPageText: "von {0}",
        displayMsg: "Zeilen {0} bis {1} von {2}",
        firstText: "Erste Seite",
        lastText: "Letzte Seite",
        prevText: "Vorige Seite",
        nextText: "Nächste Seite",
        items: tbar
      });
    }
      
    if (this.cell_edit) {
      this.selModel = new Ext.grid.CellSelectionModel()
      this.get_selected = function() {
        //~ console.log(this.getSelectionModel().selection);
        if (this.selModel.selection)
            return [ this.selModel.selection.record ];
        return [this.store.getAt(0)];
      };
      this.get_current_record = function() { 
        if (this.getSelectionModel().selection) 
          return this.selModel.selection.record;
        return this.store.getAt(0);
      };
    } else { 
      this.selModel = new Ext.grid.RowSelectionModel() 
      this.get_selected = function() {
        var sels = this.selModel.getSelections();
        if (sels.length == 0) sels = [this.store.getAt(0)];
        return sels
      };
      this.get_current_record = function() { 
        var rec = this.selModel.getSelected();
        if (rec == undefined) rec = this.store.getAt(0);
        return rec
      };
    };
    this.columns  = this.apply_grid_config(this.gc_name,this.ls_grid_configs,this.ls_columns);
    
    Lino.GridPanel.superclass.initComponent.call(this);
    
    this.on('resize', function(){
      //~ console.log("20120213 resize",arguments)
      this.refresh();
      },this);
    this.on('viewready', function(){
      //~ console.log("20120213 resize",arguments);
      this.view_is_ready = true;
      this.refresh(); // removed 20130911
      },this);
    this.on('afteredit', this.on_afteredit); // 20120814
    this.on('beforeedit', this.on_beforeedit);
    this.on('beforeedit',function(e) { this.before_row_edit(e.record)},this);
    if (this.cell_edit) {
        this.on('cellcontextmenu', Lino.cell_context_menu, this);
    } else {
        this.on('rowcontextmenu', Lino.row_context_menu, this);
    }
    //~ this.on('contextmenu', Lino.grid_context_menu, this);
    
    delete this.cell_edit;
    
  },
  
  //~ onResize : function(){
      //~ console.log("20120206 GridPanel.onResize",arguments);
      //~ Lino.GridPanel.superclass.onResize.apply(this, arguments);
      //~ this.refresh();
  //~ },
  
  
  get_status : function(){
    var st = { base_params : this.get_base_params()};
    if (!this.hide_top_toolbar) {
        st.current_page = this.getTopToolbar().current;
    }
    st.param_values = this.status_param_values;
    //~ console.log("20120213 GridPanel.get_status",st);
    return st;
  },
  
  /* 
  Lino.GridPanel.set_status() 
  */
  set_status : function(status, rp){
    this.requesting_panel = Ext.getCmp(rp);
    // console.log("20140527 GridPanel.set_status", status);
    this.clear_base_params();
    if (status == undefined) status = {base_params:{}};
    this.set_param_values(status.param_values);
    if (status.base_params) { 
      this.set_base_params(status.base_params);
    }
    if (status.show_params_panel != undefined) {
        if (this.toggle_params_panel_btn) {
            //~ this.toggle_params_panel_btn.toggle(status.show_params_panel=='true');
            this.toggle_params_panel_btn.toggle(status.show_params_panel);
        }
    }
    if (!this.hide_top_toolbar) {
      //~ console.log("20120213 GridPanel.getTopToolbar().changePage",
          //~ status.current_page || 1);
      this.getTopToolbar().changePage(status.current_page || 1);
    }
    //~ this.fireEvent('resize');
    //~ this.refresh.defer(100,this); 
    //~ this.onResize.defer(100,this); 
    //~ this.refresh(); 
    //~ this.doLayout(); 
    //~ this.onResize(); 
    //~ this.store.load();
  },
  
  refresh : function(unused) { 
    this.refresh_with_after();
  },
  /* GridPanel */
  refresh_with_after : function(after) { 
    // console.log('20140504 Lino.GridPanel.refresh '+ this.store.proxy.url);
    //~ var bp = { fmt:'json' }
    if (! this.view_is_ready) return;
    
    if (this.containing_panel) {
        //~ Ext.apply(p,this.master_panel.get_master_params());
        //~ Ext.apply(options.params,this.containing_panel.get_master_params());
        this.set_base_params(this.containing_panel.get_master_params());
        // 20130911
        if (!this.store.baseParams.mk) {  
            return;
        }
    }
    
    //~ console.log('20130911 Lino.GridPanel.refresh_with_after',this.containing_panel.get_master_params());
    
    var options = {};
    if (after) {
        options.callback = function(r,options,success) {if(success) after()}
    }
      
    //~ if (!this.rendered) {
        //~ console.log("20120206 GridPanel.refresh() must wait until rendered",options);
        //~ this.grid_panel.on('render',this.load.createDelegate(this,options))
        //~ return;
    //~ }
    
    this.store.load(options);
  },
  
  /* pageSize depends on grid height (Trying to remove scrollbar)
  Thanks to 
  - Christophe Badoit on http://www.sencha.com/forum/showthread.php?82647
  - http://www.sencha.com/forum/archive/index.php/t-37231.html
  */
  calculatePageSize : function(second_attempt) {
    //~ if (!this.rendered) { 
    if (!this.view_is_ready) { 
      //~ console.log('Cannot calculatePageSize() : not rendered');
      return false; }
    //~ if (!this.isVisible()) { 
      //~ console.log('calculatePageSize : not visible');
      //~ return false; }
      
    //~ console.log('getFrameHeight() is',this.getFrameHeight());
    //~ console.log('getView().scroller.getHeight() is',this.getView().scroller.getHeight());
    //~ console.log('mainBody.getHeight() is',this.getView().mainBody.getHeight());
    //~ console.log('getInnerHeight() is',this.getInnerHeight());
    //~ console.log('getHeight() is',this.getHeight());
    //~ console.log('el.getHeight() is',this.getEl().getHeight());
    //~ console.log('getGridEl().getHeight() is',this.getGridEl().getHeight());
    //~ console.log('getOuterSize().height is',this.getOuterSize().height);
    //~ console.log('getBox().height is',this.getBox().height);
    //~ console.log('getResizeEl.getHeight() is',this.getResizeEl().getHeight());
    //~ console.log('getLayoutTarget().getHeight() is',this.getLayoutTarget().getHeight());
      
    //~ var rowHeight = 52; // experimental value
    var row = this.view.getRow(0);
    if (row) {
      //~ console.log('20120213 yes');
      var rowHeight = Ext.get(row).getHeight();
    } else {
        //~ var rowHeight = this.getFrameHeight();
        //~ var rowHeight = 10; // reasonably smallest approximative value
        //~ There is no data yet. Construct a fake row and get its height
        var Element = Ext.Element;
        var gv = this.view;
        var fakeBody = new Element(Element.fly(gv.scroller).child('div.x-grid3-body'));
        var rowTemplate = gv.templates.row;
        var cellTemplate = gv.templates.cell;
        var tstyle  = 'width:' + gv.getGridInnerWidth() + 'px;';
        var cells = cellTemplate.apply({value:'&#160;'});
        var markup = rowTemplate.apply({
                tstyle: tstyle,
                cols  : 1,
                cells : cells,
                alt   : ''
            });        
        fakeBody.dom.innerHTML = gv.templates.body.apply({rows: markup});
        var row = fakeBody.dom.childNodes[0];
        var rowHeight = Ext.get(row).getHeight();
    }
    //~ console.log('rowHeight is ',rowHeight,this,caller);
    //~ this.getView().syncScroll();
    //~ this.getView().initTemplates();
    var height = this.getView().scroller.getHeight();
    //~ console.log('getView().scroller.getHeight() is',this.getView().scroller.getHeight());
    //~ console.log('getInnerHeight() - getFrameHeight() is',
      //~ this.getInnerHeight(), '-',
      //~ this.getFrameHeight(), '=',
      //~ this.getInnerHeight() - this.getFrameHeight());
    //~ var height = this.getView().mainBody.getHeight();
    //~ var height = this.getView().mainWrap.getHeight();
    //~ var height = this.getView().resizeMarker.getHeight();
    //~ this.syncSize();
    //~ var height = this.getInnerHeight() - this.getFrameHeight();
    //~ var height = this.getHeight() - this.getFrameHeight();
    height -= Ext.getScrollBarWidth(); // leave room for a possible horizontal scrollbar... 
    //~ height -= this.getView().scrollOffset;
    var ps = Math.floor(height / rowHeight);
    //~ console.log('20130816 calculatePageSize():',height,'/',rowHeight,'->',ps);
    ps -= 1; // leave room for a possible phantom row
    //~ return (ps > 1 ? ps : false);
    if (ps > 1) return ps;
    //~ console.log('calculatePageSize() found less than 1 row:',height,'/',rowHeight,'->',ps);
    //~ foo.bar = baz; // 20120213
    return 5; // preview_limit
    //~ if (second_attempt) {
        //~ console.log('calculatePageSize() abandons after second attempt:',
          //~ height,'/',rowHeight,'->',ps);
      //~ return 5;
    //~ }
    //~ return this.calculatePageSize.defer(500,this,[true]);
  },
  
  onCellDblClick : function(grid, row, col){
      //~ console.log("20120307 onCellDblClick",this,grid, row, col);
      if (this.ls_detail_handler) {
          //~ Lino.notify('show detail');
          Lino.show_detail(this);
          return false;
      }else{
        //~ console.log('startEditing');
        this.startEditing(row,col);
      }
  }
  ,get_base_params : function() {  /* Lino.GridPanel */
    var p = Ext.apply({}, this.store.baseParams);
    Lino.insert_subst_user(p);
    return p;
  },
  set_base_params : function(p) {
    //~ console.log('20130911 GridPanel.set_base_params',p)
    for (k in p) this.store.setBaseParam(k,p[k]);
    //~ this.store.baseParams = p;
    if (this.quick_search_field)
      this.quick_search_field.setValue(p.query || "");
    //~ if (p.param_values) 
        //~ this.set_param_values(p.param_values);  
  },
  clear_base_params : function() {
      this.store.baseParams = {};
      Lino.insert_subst_user(this.store.baseParams);
  },
  set_base_param : function(k,v) {
    this.store.setBaseParam(k,v);
  },
  
  //~ get_permalink_params : function() {
    //~ var p = {};
    //~ return p;
  //~ },
  
  before_row_edit : function(record) {},
    
  //~ search_keypress : function(){
    //~ console.log("2012124 search_keypress",arguments);
  //~ },
  search_validate : function(value) {
    if (value == this.quick_search_text) return true;
    this.is_searching = true;
    //~ console.log('search_validate',value)
    this.quick_search_text = value;
    this.set_base_param('query',value); 
    //~ this.getTopToolbar().changePage(1);
    this.getTopToolbar().moveFirst();
    //~ this.refresh();
    return true;
  },
  
  search_change : function(field,oldValue,newValue) {
    //~ console.log('search_change',field.getValue(),oldValue,newValue)
    this.set_base_param('query',field.getValue()); 
    this.getTopToolbar().moveFirst();
    //~ this.refresh();
  },
  
  apply_grid_config : function(index,grid_configs,rpt_columns) {
    //~ var rpt_columns = this.ls_columns;
    var gc = grid_configs[index];    
    //~ console.log('apply_grid_config() 20100812',name,gc);
    this.gc_name = index;
    if (gc == undefined) {
      return rpt_columns;
      //~ config.columns = config.ls_columns;
      //~ return;
    } 
    //~ delete config.ls_filters
    
    //~ console.log(20100805,config.ls_columns);
    var columns = Array(gc.columns.length);
    for (var j = 0; j < rpt_columns.length;j++) {
      var col = rpt_columns[j];
      for (var i = 0; i < gc.columns.length; i++) {
        if (col.dataIndex == gc.ci[i]) {
          col.width = gc.cw[i];
          col.hidden = gc.ch[i];
          columns[i] = col;
          break;
        }
      }
    }
    
    //~ var columns = Array(rpt_columns.length);
    //~ for (var i = 0; i < rpt_columns.length; i++) {
      //~ columns[i] = rpt_columns[gc.columns[i]];
      //~ columns[i].width = gc.widths[i];
    //~ }
    
    //~ if (gc.hidden_cols) {
      //~ for (var i = 0; i < gc.hidden_cols.length; i++) {
        //~ var hc = gc.hidden_cols[i];
        //~ for (var j = 0; j < columns.length;j++) {
          //~ var col = columns[j];
          //~ if (col.dataIndex == hc) {
            //~ col.hidden = true;
            //~ break
          //~ }
        //~ }
      //~ }
    //~ }
    if (gc.filters) {
      //~ console.log(20100811,'config.ls_filters',config.ls_filters);
      //~ console.log(20100811,'config.ls_grid_config.filters',config.ls_grid_config.filters);
      for (var i = 0; i < gc.filters.length; i++) {
        var fv = gc.filters[i];
        for (var j = 0; j < columns.length;j++) {
          var col = columns[j];
          if (col.dataIndex == fv.field) {
            //~ console.log(20100811, f,' == ',fv);
            if (fv.type == 'string') {
              col.filter.value = fv.value;
              //~ if (fv.comparison !== undefined) f.comparison = fv.comparison;
            } else {
              //~ console.log(20100811, fv);
              col.filter.value = {};
              col.filter.value[fv.comparison] = fv.value;
            }
            break;
          }
        };
      }
    }
    
    return columns;
    //~ config.columns = cols;
    //~ delete config.ls_columns
  },
  
  get_current_grid_config : function () {
    var cm = this.getColumnModel();
    var widths = Array(cm.config.length);
    var hiddens = Array(cm.config.length);
    //~ var hiddens = Array(cm.config.length);
    var columns = Array(cm.config.length);
    //~ var columns = Array(cm.config.length);
    //~ var hidden_cols = [];
    //~ var filters = this.filters.getFilterValues();
    var p = this.filters.buildQuery(this.filters.getFilterData())
    for (var i = 0; i < cm.config.length; i++) {
      var col = cm.config[i];
      columns[i] = col.dataIndex;
      //~ hiddens[i] = col.hidden;
      widths[i] = col.width;
      hiddens[i] = col.hidden;
      //~ if (col.hidden) hidden_cols.push(col.dataIndex);
    }
    //~ p['hidden_cols'] = hidden_cols;
    p.cw = widths;
    p.ch = hiddens;
    p.ci = columns;
    //~ p['widths'] = widths;
    //~ p['hiddens'] = hiddens;
    //~ p['columns'] = columns;
    p['name'] = this.gc_name;
    //~ var gc = this.ls_grid_configs[this.gc_name];
    //~ if (gc !== undefined) 
        //~ p['label'] = gc.label
    //~ console.log('20100810 save_grid_config',p);
    return p;
  },
  
  unused_manage_grid_configs : function() {
    var data = [];
    for (k in this.ls_grid_configs) {
      var v = this.ls_grid_configs[k];
      var i = [k,String(v.columns),String(v.hidden_cols),String(v.filters)];
      data.push(i)
    }
    if (this.ls_grid_configs[this.gc_name] == undefined) {
      var v = this.get_current_grid_config();
      var i = [k,String(v.columns),String(v.hidden_cols),String(v.filters)];
      data.push(i);
    }
    //~ console.log(20100811, data);
    var main = new Ext.grid.GridPanel({
      store: new Ext.data.ArrayStore({
        idIndex:0,
        fields:['name','columns','hidden_cols','filters'],
        autoDestroy:true,
        data: data}),
      //~ autoHeight:true,
      selModel: new Ext.grid.RowSelectionModel(),
      listeners: { 
        rowdblclick: function(grid,rowIndex,e) {
          console.log('row doubleclicked',grid, rowIndex,e);
        },
        rowclick: function(grid,rowIndex,e) {
          console.log('row clicked',grid, rowIndex,e);
        }
      },
      columns: [ 
        {dataIndex:'name',header:'Name'}, 
        {dataIndex:'columns',header:'columns'}, 
        {dataIndex:'hidden_cols',header:'hidden columns'}, 
        {dataIndex:'filters',header:'filters'} 
      ]
    });
    var win = new Ext.Window({title:'GridConfigs Manager',layout:'fit',items:main,height:200});
    win.show();
  },
  
  unused_edit_grid_config : function(name) {
    gc = this.ls_grid_configs[name];
    var win = new Ext.Window({
      title:'Edit Grid Config',layout:'vbox', 
      //~ layoutConfig:'stretch'
      items:[
        {xtype:'text', value: gc.name},
        {xtype:'text', value: gc.columns},
        {xtype:'text', value: gc.hidden_cols},
        {xtype:'text', value: gc.filters}
      ]
    });
    win.show();
  },
  
  unused_save_grid_config : function () {
    //~ console.log('TODO: save_grid_config',this);
    //~ p.column_widths = Ext.pluck(this.colModel.columns,'width');
    var a = { 
      params:this.get_current_grid_config(), 
      method:'PUT',
      url:'/grid_config' + this.ls_url,
      success: Lino.action_handler(this),
      scope: this,
      failure: Lino.ajax_error_handler(this)
    };
    this.loadMask.show(); // 20120211
    Ext.Ajax.request(a);
    //~ Lino.do_action(this,a);
  },
  
  on_beforeedit : function(e) {
    //~ console.log('20130128 GridPanel.on_beforeedit()',e,e.record.data.disable_editing);
    if(this.disable_editing | e.record.data.disable_editing) {
      e.cancel = true;
      Lino.notify("Dieser Datensatz ist deaktiviert");
      return;
    }
    if(e.record.data.disabled_fields && e.record.data.disabled_fields[e.field]) {
      e.cancel = true;
      Lino.notify("Dieses Feld ist deaktiviert");
      return;
    }
    //~ if (e.record.data.disabled_fields) {
      //~ for (i in e.record.data.disabled_fields) {
        //~ if(e.record.data.disabled_fields[i] == e.field) {
          //~ e.cancel = true;
          //~ Lino.notify(String.format('Field "{0}" is disabled for this record',e.field));
          //~ return
        //~ }
      //~ }
    //~ }
  },
  save_grid_data : function() {
      //~ console.log("20120814 save_grid_data");
      this.getStore().commitChanges();
  },
  on_afteredit : function(e) {
    /*
    e.grid - The grid that fired the event
    e.record - The record being edited
    e.field - The field name being edited
    e.value - The value being set
    e.originalValue - The original value for the field, before the edit.
    e.row - The grid row index
    e.column - The grid column index
    */
    var p = {};
    // console.log('20140403 afteredit: ',e.record);
    //~ console.log('20101130 value: ',e.value);
    //~ var p = e.record.getChanges();
    //~ console.log('20101130 getChanges: ',e.record.getChanges());
    //~ this.before_row_edit(e.record);

    for(k in e.record.getChanges()) {
        var v = e.record.get(k);
    //~ for(k in e.record.modified) {
        //~ console.log('20101130',k,'=',v);
        //~ var cm = e.grid.getColumnModel();
        //~ var di = cm.getDataIndex(k);
        var f = e.record.fields.get(k);
        //~ console.log('20101130 f = ',f);
        //~ var v = e.record.get(di);
        if (f.type.type == 'date') {
            p[k] = Ext.util.Format.date(v, f.dateFormat);
        }else{
            p[k] = v;
            var v = e.record.get(k+'Hidden');
            if (v !== undefined) {
              p[k+'Hidden'] = v;
            }
        }
    }
    // add value used by ForeignKeyStoreField CHOICES_HIDDEN_SUFFIX
    // not sure whether this is still needed:
    p[e.field+'Hidden'] = e.value;
    //~ p.su = Lino.subst_user;
    Lino.insert_subst_user(p);
    // this one is needed so that this field can serve as choice context:
    e.record.data[e.field+'Hidden'] = e.value;
    // p[pk] = e.record.data[pk];
    // console.log("grid_afteredit:",e.field,'=',e.value);
    Ext.apply(p, this.get_base_params()); // needed for POST, ignored for PUT
    //~ Ext.apply(p,this.containing_window.config.base_params);
    //~ 20121109 p['$ext_requests.URL_PARAM_ACTION_NAME'] = 'grid';
    var self = this;
    var req = {
        params:p,
        waitMsg: 'Saving your data...',
        success: Lino.action_handler( this, function(result) {
          // console.log("20140728 afteredit.success got ", result);
          //~ if (result.data_record) {
          if (result.refresh_all) {
              var cw = self.get_containing_window();
              if (cw) {
                  cw.main_item.refresh();
              }
              else console.log("20120123 cannot refresh_all",self);
          } else if (result.rows) {
              //~ self.getStore().loadData(result,true);
              var r = self.getStore().reader.readRecords(result);
              if (e.record.phantom) {
                  // console.log("20140728 gonna call Store.insert()", self.getStore(), e.row, r.records);
                  self.getStore().insert(e.row, r.records);
              }else{
                  // console.log("20140728 afteredit.success doUpdate", r.records[0]);
                  self.getStore().doUpdate(r.records[0]);
              }
              self.getStore().rejectChanges(); 
              /* 
              get rid of the red triangles without saving the record again
              */
              //~ self.getStore().commitChanges(); // get rid of the red triangles
          } else {
              self.getStore().commitChanges(); // get rid of the red triangles
              self.getStore().reload();        // reload our datastore.
          }
          }),
        scope: this,
        failure: Lino.ajax_error_handler(this)
    };
    if (e.record.phantom) {
      req.params.an = 'grid_post'; // CreateRow.action_name
      Ext.apply(req,{
        method: 'POST',
        url: '/api' + this.ls_url
      });
    } else {
      req.params.an = 'grid_put'; // SaveRow.action_name
      Ext.apply(req,{
        method: 'PUT',
        url: '/api' + this.ls_url + '/' + e.record.id
      });
    }
    //~ console.log('20110406 on_afteredit',req);
    this.loadMask.show(); // 20120211
    Ext.Ajax.request(req);
  },

  afterRender : function() {
    Lino.GridPanel.superclass.afterRender.call(this);
    // this.getView().mainBody.focus();
    // console.log(20100114,this.getView().getRows());
    // if (this.getView().getRows().length > 0) {
    //  this.getView().focusRow(1);
    // }
    //~ this.my_load_mask = new Ext.LoadMask(this.getEl(), {
        //~ msg:'$_("Please wait...")',
        //~ store:this.store});
      
    var tbar = this.getTopToolbar();
    // tbar.on('change',function() {this.getView().focusRow(1);},this);
    // tbar.on('change',function() {this.getSelectionModel().selectFirstRow();this.getView().mainBody.focus();},this);
    // tbar.on('change',function() {this.getView().mainBody.focus();},this);
    // tbar.on('change',function() {this.getView().focusRow(1);},this);
    this.nav = new Ext.KeyNav(this.getEl(),{
      pageUp: function() {tbar.movePrevious(); },
      pageDown: function() {tbar.moveNext(); },
      home: function() {tbar.moveFirst(); },
      end: function() {tbar.moveLast(); },
      scope: this
    });

  },
  after_delete : function() {
    //~ console.log('Lino.GridPanel.after_delete');
    this.refresh();
  },
  add_row_listener : function(fn,scope) {
    this.getSelectionModel().addListener('rowselect',fn,scope);
  },
  postEditValue : function(value, originalValue, r, field){
    value = Lino.GridPanel.superclass.postEditValue.call(this,value,originalValue,r,field);
    //~ console.log('GridPanel.postEdit()',value, originalValue, r, field);
    return value;
  },
  
  set_start_value : function(v) {
      this.start_value = v;
  },
  preEditValue : function(r, field){
      if (this.start_value) {
        var v = this.start_value;
        delete this.start_value;
        this.activeEditor.selectOnFocus = false;
        return v;
      }
      var value = r.data[field];
      return this.autoEncode && Ext.isString(value) ? Ext.util.Format.htmlDecode(value) : value;
  },
  
  on_master_changed : function() {
    //~ if (! this.enabled) return;
    //~ cmp = this;
    //~ console.log('20130911 Lino.GridPanel.on_master_changed()',this.title,this.rendered);
    if (! this.rendered) return; // 20120213
    var todo = function() {
      if (this.disabled) return;
      //~ if (this.disabled) return;
      //~ if (this.enabled) {
          //~ var src = caller.config.url_data + "/" + record.id + ".jpg"
          //~ console.log(20111125, this.containing_window);
          //~ for (k in p) this.getStore().setBaseParam(k,p[k]);
          //~ console.log('Lino.GridPanel.on_master_changed()',this.title,p);
          this.refresh();
          //~ this.set_base_params(this.master_panel.get_master_params());
          //~ this.getStore().load(); 
      //~ }
    };
    Lino.do_when_visible(this,todo.createDelegate(this));
  },
  load_record_id : function(record_id,after) {
      Lino.run_detail_handler(this,record_id)
  }
  
});
  

//~ Lino.MainPanelMixin = {
  //~ tbar_items : function() {
      //~ return ;
  //~ }
//~ };

//~ Ext.override(Lino.GridPanel,Lino.MainPanelMixin);
//~ Ext.override(Lino.FormPanel,Lino.MainPanelMixin);

//~ Lino.grid_context_menu = function(e) {
  //~ console.log('contextmenu',arguments);
//~ }

Lino.row_context_menu = function(grid,row,col,e) {
  console.log('20130927 rowcontextmenu',grid,row,col,e,grid.store.reader.arrayData.rows[row]);
}

Lino.cell_context_menu = function(grid,row,col,e) {
  //~ console.log('20120531 cellcontextmenu',grid,row,col,e,grid.store.reader.arrayData.rows[row]);
  e.stopEvent();
  //~ grid.getView().focusCell(row,col);
  grid.getSelectionModel().select(row,col);
  //~ console.log(grid.store.getAt(row));
  //~ grid.getView().focusRow(row);
  //~ return;
  if(!grid.cmenu.el){grid.cmenu.render(); }
  //~ if(e.record.data.disabled_fields) {
  
  var da = grid.store.reader.arrayData.rows[row][grid.disabled_actions_index];
  if (da) {
      this.cmenu.cascade(function(item){ 
        //~ console.log(20120531, item.itemId, da[item.itemId]);
        if (da[item.itemId]) item.disable(); else item.enable();
      });
  };
  
  var xy = e.getXY();
  xy[1] -= grid.cmenu.el.getHeight();
  grid.cmenu.showAt(xy);
}


Lino.chooser_handler = function(combo,name) {
  return function(cmp,newValue,oldValue) {
    //~ console.log('Lino.chooser_handler()',cmp,oldValue,newValue);
    combo.setContextValue(name,newValue);
  }
};



Lino.ComboBox = Ext.extend(Ext.form.ComboBox,{
  forceSelection: "yes but select on tab",
  // forceSelection: true,
  triggerAction: 'all',
  minListWidth:280, // 20131022
  autoSelect: false,
  selectOnFocus: true, // select any existing text in the field immediately on focus.
  submitValue: true,
  displayField: 'text', // 'text', 
  valueField: 'value', // 'value',
  
  //~ initComponent : Ext.form.ComboBox.prototype.initComponent.createSequence(function() {
  initComponent : function(){
      this.contextParams = {};
      //~ Ext.form.ComboBox.initComponent(this);
      Lino.ComboBox.superclass.initComponent.call(this);
  },
  setValue : function(v,record_data){
      /*
      Based on feature request developed in http://extjs.net/forum/showthread.php?t=75751
      */
      /* `record_data` is used to get the text corresponding to this value */
      //~ if(this.name == 'city') 
      //~ console.log('20120203', this.name,'.setValue(', v ,') this=', this,'record_data=',record_data);
      var text = v;
      if(this.valueField){
        if(v == null || v == '') { 
            //~ if (this.name == 'birth_country') 
                //~ console.log(this.name,'.setValue',v,'no lookup needed, value is empty');
            //~ v = undefined;
            v = '';
            //~ text = '';
        } else if (Ext.isDefined(record_data)) {
          text = record_data[this.name];
          //~ if (this.name == 'birth_country') 
            //~ console.log(this.name,'.setValue',v,'got text ',text,' from record ',record);
        } else {
          // if(this.mode == 'remote' && !Ext.isDefined(this.store.totalLength)){
          if(this.mode == 'remote' && ( this.lastQuery === null || (!Ext.isDefined(this.store.totalLength)))){
              //~ if (this.name == 'birth_country') console.log(this.name,'.setValue',v,'store not yet loaded');
              this.store.on('load', this.setValue.createDelegate(this, arguments), null, {single: true});
              if(this.store.lastOptions === null || this.lastQuery === null){
                  var params;
                  if(this.valueParam){
                      params = {};
                      params[this.valueParam] = v;
                  }else{
                      var q = this.allQuery;
                      this.lastQuery = q;
                      this.store.setBaseParam(this.queryParam, q);
                      params = this.getParams(q);
                  }
                  //~ if (this.name == 'birth_country') 
                    //~ console.log(this.name,'.setValue',v,' : call load() with params ',params);
                  this.store.load({params: params});
              //~ }else{
                  //~ if (this.name == 'birth_country') 
                    //~ console.log(this.name,'.setValue',v,' : but store is loading',this.store.lastOptions);
              }
              return;
          //~ }else{
              //~ if (this.name == 'birth_country') 
                //~ console.log(this.name,'.setValue',v,' : store is loaded, lastQuery is "',this.lastQuery,'"');
          }
          var r = this.findRecord(this.valueField, v);
          if(r){
              text = r.data[this.displayField];
          }else if(this.valueNotFoundText !== undefined){
              text = this.valueNotFoundText;
          }
        }
      }
      this.lastSelectionText = text;
      //~ this.lastSelectionText = v;
      if(this.hiddenField){
          //~ this.hiddenField.originalValue = v;
          this.hiddenField.value = v;
      }
      Ext.form.ComboBox.superclass.setValue.call(this, text);
      this.value = v; // needed for grid.afteredit
  },
  
  getParams : function(q){
    // p = Ext.form.ComboBox.superclass.getParams.call(this, q);
    // causes "Ext.form.ComboBox.superclass.getParams is undefined"
    var p = {};
    if(this.pageSize){
        p['start'] = 0;
        p['limit'] = this.pageSize;
    }
    // now my code:
    if(this.contextParams) Ext.apply(p, this.contextParams);
    return p;
  },
  setContextValue : function(name,value) {
    //~ console.log('setContextValue',this,this.name,':',name,'=',value);
    //~ if (this.contextValues === undefined) {
        //~ this.contextValues = Array(); // this.contextParams.length);
    //~ }
    if (this.contextParams[name] != value) {
      //~ console.log('setContextValue 1',this.contextParams);
      this.contextParams[name] = value;
      this.lastQuery = null;
      //~ console.log('setContextValue 2',this.contextParams);
    }
  }
});

Lino.ChoicesFieldElement = Ext.extend(Lino.ComboBox,{
  mode: 'local'
});


Lino.SimpleRemoteComboStore = Ext.extend(Ext.data.JsonStore,{
  // forceSelection: true,  20140206 why was this here?
  constructor: function(config){
      Lino.SimpleRemoteComboStore.superclass.constructor.call(this, Ext.apply(config, {
          totalProperty: 'count',
          root: 'rows',
          id: 'value', // ext_requests.CHOICES_VALUE_FIELD
          fields: ['value' ], // ext_requests.CHOICES_VALUE_FIELD, // ext_requests.CHOICES_TEXT_FIELD
          listeners: { exception: Lino.on_store_exception }
      }));
  }
});

Lino.ComplexRemoteComboStore = Ext.extend(Ext.data.JsonStore,{
  constructor: function(config){
      Lino.ComplexRemoteComboStore.superclass.constructor.call(this, Ext.apply(config, {
          totalProperty: 'count',
          root: 'rows',
          id: 'value', // ext_requests.CHOICES_VALUE_FIELD
          fields: ['value','text'], // ext_requests.CHOICES_VALUE_FIELD, // ext_requests.CHOICES_TEXT_FIELD
          listeners: { exception: Lino.on_store_exception }
      }));
  }
});

Lino.RemoteComboFieldElement = Ext.extend(Lino.ComboBox,{
  mode: 'remote',
  //~ forceSelection:false,
  minChars: 2, // default 4 is too much
  queryDelay: 300, // default 500 is maybe slow
  queryParam: 'query', 
  //~ typeAhead: true,
  //~ selectOnFocus: true, // select any existing text in the field immediately on focus.
  resizable: true
  ,initList : function() {
      Lino.RemoteComboFieldElement.superclass.initList.call(this);
      if (this.pageTb) {
          
          var me = this;
          this.pageTb.on("beforechange", function(toolbar, o){
              if(me.contextParams)
                  Ext.apply(o, me.contextParams);
          });
          
          //~ 
          //~ var btn = ls_buttons
          //~ this.pageTb.items = this.pageTb.items.concat([btn]);
          //~ console.log("20131022 pageTb.items is", this.pageTb.items)
      }
  }
});

/*
Thanks to Animal for posting the basic idea:
http://www.sencha.com/forum/showthread.php?15842-2.0-SOLVED-Combobox-twintrigger-clear&p=76130&viewfull=1#post76130

*/
Lino.TwinCombo = Ext.extend(Lino.RemoteComboFieldElement,{
    trigger2Class : 'x-form-search-trigger',
    //~ trigger2Class : 'x-tbar-detail',
    initComponent : function() {
        //~ Lino.TwinCombo.superclass.initComponent.call(this);
        Lino.ComboBox.prototype.initComponent.call(this);
        Ext.form.TwinTriggerField.prototype.initComponent.call(this);
    },
    onTrigger2Click : function() {
        //~ console.log('onTrigger2Click',this,arguments);
    }
  });
//~ Lino.TwinCombo.prototype.initComponent = Ext.form.TwinTriggerField.prototype.initComponent;
Lino.TwinCombo.prototype.getTrigger = Ext.form.TwinTriggerField.prototype.getTrigger;
Lino.TwinCombo.prototype.getOuterSize = Ext.form.TwinTriggerField.prototype.getOuterSize;
Lino.TwinCombo.prototype.initTrigger = Ext.form.TwinTriggerField.prototype.initTrigger;
Lino.TwinCombo.prototype.onTrigger1Click = Ext.form.ComboBox.prototype.onTriggerClick;
//~ Lino.TwinCombo.prototype.onTrigger2Click = function() {
    //~ console.log('onTrigger2Click',arguments);
//~ };



Lino.SimpleRemoteComboFieldElement = Ext.extend(Lino.RemoteComboFieldElement,{
  displayField: 'value', 
  valueField: null,
  forceSelection: false
});




Lino.Window = Ext.extend(Ext.Window,{
  //~ layout: "fit", 
  closeAction : 'hide',
  renderTo: 'main_area', 
  constrain: true,
  maximized: true,
  draggable: false,
  width: 700,
  height: 500,
  maximizable: false,
  constructor : function (config) {
    if (config.main_item.params_panel) {
        config.layout = 'border';
        config.main_item.region = 'center';
        config.main_item.params_panel.region = 'north';
        //~ config.main_item.params_panel.autoHeight = false; // 20130924
        config.main_item.params_panel.hidden = config.main_item.params_panel_hidden;
        config.items = [config.main_item.params_panel, config.main_item];
        //~ 20130923b
    } else {
        config.layout = 'fit';
        config.items = config.main_item;
    }
    this.main_item = config.main_item; 
    
    delete config.main_item;
    //~ delete config.params_item;
    
    //~ this.main_item = config.items.get(0);
    this.main_item.containing_window = this;
    
    //~ console.log('20120110 Lino.Window.constructor() 1');
    //~ if (Lino.current_window) { // all windows except the top are closable
    if (this.main_item.hide_window_title) { 
      config.closable = false;
      config.frame = false;
      config.shadow = false;
      //~ config.border = true;
      //~ config.title = undefined;
      //~ config.tools = null;
      delete config.title;
      delete config.tools;
    } else {
      config.title = this.main_item.empty_title;
      config.closable = true;
      config.tools = [ 
        { qtip: 'permalink', handler: Lino.permalink_handler(this), id: "pin" }
      ];
      if (this.main_item.content_type && this.main_item.action_name != 'insert') {
        config.tools = [ {
          handler: Lino.help_text_editor,
          qtip: "Hilfetexte der Eingabefelder dieser Tabelle bearbeiten",
          scope: this.main_item,
          id: "gear"
        }].concat(config.tools);
      }
        
    //~ { qtip: '', handler: Lino.save_wc_handler(this), id: "save" }, 
    //~ { qtip: this.config.qtip, handler: Lino.save_wc_handler(this), id: "save" }, 
    //~ { qtip: 'Call doLayout() on main Container.', handler: Lino.refresh_handler(this), id: "refresh" },
    //~ if (this.main_item.params_panel) {
        //~ config.tools = config.tools.concat([ 
          //~ { qtip: 'Show/hide parameter panel', handler: this.toggle_params_panel, id: "gear", scope:this } 
        //~ ]);
    //~ }
    //~ if (config.closable !== false) {
      // if undefined, will take default behaviour
      //~ config.tools = config.tools.concat([ 
        //~ { qtip: 'close', handler: this.hide, id: "close", scope:this } 
      //~ ]);
    }
    
    this.main_item.config_containing_window(config);
    
    //~ console.log('20120110 Lino.Window.constructor() 2');
    Lino.Window.superclass.constructor.call(this,config);
    
    //~ console.log('20120110 Lino.Window.constructor() 3');
    
  },
  initComponent : function() {
    this.main_item.init_containing_window(this);
    Lino.Window.superclass.initComponent.call(this);
  
  },
  hide : function() { 
      this.main_item.do_when_clean(false,function() { 
        Lino.close_window(); });
  },
  hide_really : function() { 
    Lino.Window.superclass.hide.call(this);
  },
  onRender : function(ct, position){
    // console.log('20140829 Lino.Window.onRender() 1');
    Lino.Window.superclass.onRender.call(this, ct, position);
    var main_area = Ext.getCmp('main_area')
    //~ console.log('20120110 Lino.Window.onRender() 2');
  
    this.on('show', function(win) {
        // console.log('20140829 Lino.Window.on(show) : add resize handler');
        main_area.on('resize', win.onWindowResize, win);
    });
    this.on('hide', function(win) {
        // console.log('20140829 Lino.Window.on(hide) : remove resize handler');
        main_area.un('resize', win.onWindowResize, win);
    });
    // console.log('20140829 Lino.Window.onRender() 3');
  }
});


Ext.override(Ext.form.BasicForm,{
    my_loadRecord : function(values){
    //~ loadRecord : function(record){
        /* Same as ExtJS's loadRecord() (setValues()), except that we 
        forward also the record to field.setValue() so that Lino.Combobox 
        can use it. 
        */
        //~ console.log('20120918 my_loadRecord',values)
        if(Ext.isArray(values)){ 
            for(var i = 0, len = values.length; i < len; i++){
                var v = values[i];
                var f = this.findField(v.id);
                if(f){
                    f.setValue(v.value,values);
                    if(this.trackResetOnLoad){
                        f.originalValue = f.getValue();
                    }
                }
            }
        }else{ 
            var field, id;
            for(id in values){
                if(!Ext.isFunction(values[id]) && (field = this.findField(id))){
                    field.setValue(values[id],values);
                    if(this.trackResetOnLoad){
                        field.originalValue = field.getValue();
                        //~ if (field.hiddenField) {
                          //~ field.hiddenField.originalValue = field.hiddenField.value;
                        //~ }
                    }
                }
            }
        }
        return this;
    }
});




function initializeFooBarDropZone(cmp) {
    //~ console.log('initializeFooBarDropZone',cmp);
    cmp.dropTarget = new Ext.dd.DropTarget(cmp.bwrap, {
      //~ ddGroup     : 'gridDDGroup',
      notifyEnter : function(ddSource, e, data) {
        console.log('notifyEnter',ddSource,e,data);
        //Add some flare to invite drop.
        cmp.body.stopFx();
        cmp.body.highlight();
      },
      notifyDrop  : function(ddSource, e, data){
        console.log('notifyDrop',ddSource,e,data);
        // Reference the record (single selection) for readability
        //~ var selectedRecord = ddSource.dragData.selections[0];


        // Load the record into the form
        //~ formPanel.getForm().my_loadRecord(selectedRecord);


        // Delete record from the grid.  not really required.
        //~ ddSource.grid.store.remove(selectedRecord);

        return(true);
      }
    })
}



Lino.show_mti_child = function(fieldname,detail_handler) {
  //~ console.log('show_mti_child',this);
  //~ console.log('show_mti_child',panel.find("main_area"));
  rec = Lino.current_window.main_item.get_current_record();
  //~ rec = panel.get_current_record();
  if (rec) {
    //~ console.log('show_mti_child',Lino.current_window,rec);
    if (rec.phantom) {
      Lino.notify('Not allowed on phantom record.');
    }else if (rec.data[fieldname]) {
      //~ console.log('show_mti_child',rec.id);
      //~ detail_handler(Lino.current_window.main_item,{},{record_id:rec.id});
      detail_handler.run(null,{record_id:rec.id});
      //~ window.open(urlroot + '/' + rec.id);
      //~ document.location = urlroot + '/' + rec.id;
      //~ window.open(urlroot + '/' + rec.id,'_blank');
    } else {
      Lino.alert("Kann MTI-Kind nicht anzeigen wenn Checkbox abgeschlatet ist.");
    }
  } else {
    Lino.notify('No current record.');
  }
};


/*
captureEvents utility by Aaron Conran
<http://www.sencha.com/learn/grid-faq/>

Ext.onReady(function(){
    var grid = new Ext.grid.GridPanel({
        ... 
    });
    captureEvents(grid);
});
*/
function captureEvents(observable) {
    Ext.util.Observable.capture(
        observable,
        function(eventName) {
            console.info(eventName);
        },
        this
    );		
}

// settings.SITE.get_plugin_snippets()




// from lino.modlib.extensible (media_name=extensible, media_base_url=http://ext.ensible.com/deploy/1.0.2/):snippets/extensible.js

/*
  This is the `extensible.js` snippet. 
  Used in lino.modlib.extensible.App.site_js_snippets
*/

/*
Mappings towards lino.modlib.extensible.models.PanelCalendars
*/
// Sset SS = Ssite.modules.extensible.PanelCalendars.get_handle(Sui).store
Ext.ensible.cal.CalendarMappings = {
    CalendarId:   {name:'ID',       mapping: 'id', type: 'int'},
    Title:        {name:'CalTitle', mapping: 'summary', type: 'string'},
    Description:  {name:'Desc',     mapping: 'description', type: 'string'},
    ColorId:      {name:'Color',    mapping: 'color', type: 'int'},
    IsHidden:     {name:'Hidden',   mapping: 'is_hidden', type: 'boolean'},    
};
Ext.ensible.cal.CalendarRecord.reconfigure();  


/*
Mappings towards lino.modlib.extensible.models.PanelEvents 
*/
// Sset SS = Ssite.modules.extensible.PanelEvents.get_handle(Sui).store
Ext.ensible.cal.EventMappings = {
    EventId:     {name: 'ID',        mapping: 'id', type:'int'},
    CalendarId:  {name: 'CalID',     mapping: 'calendarHidden', type: 'int'},
    Title:       {name: 'EvtTitle',  mapping: 'summary'},
    StartDate:   {name: 'StartDt',   mapping: 'start_dt', 
      type: 'date', 
      dateFormat: "Y-m-d\TH:i:s" },
    EndDate:     {name: 'EndDt',     mapping: 'end_dt', 
      type: 'date', 
      dateFormat: "Y-m-d\TH:i:s"},
    RRule:       {name: 'RecurRule', mapping: 'rsetHidden'},
    Location:    {name: 'Location',  mapping: 'placeHidden'},
    Notes:       {name: 'Desc',      mapping: 'description'},
    Url:         {name: 'LinkUrl',   mapping: 'url'},
    IsAllDay:    {name: 'AllDay',    mapping: 'all_day', type: 'boolean'},
    Reminder:    {name: 'Reminder',  mapping: 'reminder'}
    
};
Ext.ensible.cal.EventRecord.reconfigure();


//~ Lino.on_eventclick = 
    
Lino.on_editdetails = 

Lino.format_time = function(dt) {
    return dt.getHours() + ':' + dt.getMinutes();
}
    
Lino.on_eventdelete = function() {
  //~ console.log("Lino.on_eventdelete",arguments);
};

Lino.on_eventadd  = function(cp,rec,el) {
  //~ console.log("Lino.on_eventadd ",arguments);
  return false;
}
    
Lino.on_eventresize  = function(cp,rec,el) {
  //~ console.log("Lino.on_eventresize ",arguments);
  //~ Lino.cal.Events.insert(cp);
  //~ return false;
}
    
Lino.on_eventupdate  = function(cp,rec,el) {
  //~ console.log("Lino.on_eventupdate",arguments);
  //~ Lino.cal.Events.insert(cp);
  //~ return false;
}
    

//~ Lino.eventStore = new Ext.ensible.cal.EventStore({ 
//~ Lino.eventStore = new Ext.data.ArrayStore({ 
Lino.unused_eventStore = new Ext.data.JsonStore({ 
  listeners: { exception: Lino.on_store_exception }
  ,url: '/restful/extensible/PanelEvents'
  ,restful : true
  ,proxy: new Ext.data.HttpProxy({ 
      url: '/restful/extensible/PanelEvents', 
      disableCaching: false // no need for cache busting when loading via Ajax
      //~ disableCaching:true,
  })
  ,fields: Ext.ensible.cal.EventRecord.prototype.fields.getRange()
  ,totalProperty: "count"
  ,root: "rows"
  ,idProperty: Ext.ensible.cal.EventMappings.EventId.mapping
  ,writer : new Ext.data.JsonWriter({
    writeAllFields: false
  })
  ,load: function(options) {
    //~ foo.bar = baz; // 20120213
      if (!options) options = {};
      if (!options.params) options.params = {};
      //~ options.params.$ext_requests.URL_PARAM_TEAM_VIEW = Lino.calendar_app.team_view_button.pressed;
      
      var view = this.cal_panel.getActiveView();
      var bounds = view.getViewBounds();
      //~ var p = {sd:'05.02.2012',ed:'11.02.2012'};
      //~ var p = {};
      options.params[view.dateParamStart] = bounds.start.format(view.dateParamFormat);
      options.params[view.dateParamEnd] = bounds.end.format(view.dateParamFormat);
      Lino.insert_subst_user(options.params);
      //~ Ext.apply(options.params,p)
      //~ console.log('20120710 eventStore.load()',this.baseParams,options);
    
    return Ext.data.JsonStore.prototype.load.call(this,options);
  }
});


Lino.CalendarCfg = {
    dateParamFormat: 'd.m.Y',
    dateParamStart:'sd',
    dateParamEnd:'ed'
};
//~ 20120704 Lino.CalendarPanel = Ext.extend(Ext.ensible.cal.CalendarPanel,Lino.MainPanel);
//~ Lino.CalendarPanel = Ext.extend(Lino.CalendarPanel,{
Ext.override(Ext.ensible.cal.CalendarPanel,Lino.MainPanel);
Ext.override(Ext.ensible.cal.CalendarPanel,{
  //~ empty_title : "\$ui.get_actor('cal.Panel').report.label",
  empty_title : "Kalender"
  ,activeItem: 1 // 0: day, 1: week
  ,ls_url: '/extensible/CalendarPanel'
  //~ ,disableCaching:true
  //~ ,eventStore: Lino.eventStore
  //~ ,calendarStore: Lino.calendarStore
  //~ ,initComponent : function(){
    //~ Ext.ensible.cal.CalendarPanel.superclass.initComponent.call(this);
    //~ this.eventStore.on('load',function(){
      //~ console.log("20130808",Lino.eventStore);
      //~ if (this.eventStore.reader.jsonData) {
        //~ console.log("20130808 b",this.eventStore.reader.jsonData.title);
        //~ this.set_window_title(this.eventStore.reader.jsonData.title);
      //~ }
    //~ },this);
  //~ }
  ,listeners: { 
    editdetails: function(cp,rec,el) {
      //~ console.log("Lino.on_editdetails",arguments);
      if (rec.data.ID)
          Lino.extensible.PanelEvents.detail.run(null,{
              record_id:rec.data.ID,
              base_params:this.app_instance.event_store.baseParams});
      return false;
    }
    ,eventclick: function(cp,rec,el) {
      //~ console.log("Lino.on_eventclick",arguments);
      //~ Lino.cal.Events.detail_action.run({record_id:rec.data.ID});
      Lino.extensible.PanelEvents.detail.run(null,{
            record_id:rec.data.ID,
                base_params:this.app_instance.event_store.baseParams});
      return false;
    }
    //~ ,eventadd: Lino.on_eventadd
    //~ ,eventdelete: Lino.on_eventdelete
    //~ ,eventresize: Lino.on_eventresize
    ,afterrender : function(config) {
      // console.log("20140402 CalendarPanel.afterrender");
      this.app_instance.calendar_store.cal_panel = this;
      // 20140402 this.app_instance.calendar_store.load();
      //~ console.log("20120704 afterrender calls eventStore.load()",p);
      this.app_instance.event_store.cal_panel = this;
      //~ Lino.eventStore.load({params:p});
      //~ 20130905 removed: this.app_instance.event_store.load();
      //~ Lino.CalendarPanel.superclass.constructor.call(this, config);
      //~ console.log(20120118, config,this);
    }
    }
  ,enableEditDetails: false
  //~ ,monthViewCfg: Lino.CalendarCfg
  //~ ,weekViewCfg: Lino.CalendarCfg
  //~ ,multiDayViewCfg: Lino.CalendarCfg
  //~ ,multiWeekViewCfg: Lino.CalendarCfg
  //~ ,dayViewCfg: Lino.CalendarCfg
  //~ ,initComponent : function() {
    //~ // this.on('eventadd',Lino.on_eventadd);
    //~ Lino.CalendarPanel.superclass.initComponent.call(this);
  //~ }
});




Lino.CalendarAppPanel = Ext.extend(Ext.Panel,Lino.MainPanel);
Lino.CalendarAppPanel = Ext.extend(Lino.CalendarAppPanel,Lino.PanelMixin);
Lino.CalendarAppPanel = Ext.extend(Lino.CalendarAppPanel,{
  app_instance : null
  //~ empty_title : "\$ui.get_actor('cal.Panel').report.label",
  ,empty_title : "Kalender"
  ,ls_url: '/extensible/CalendarPanel'
  ,set_status : function(status,rp) { 
      // console.log('20140402 CalendarAppPanel.set_status()', status);
      this.requesting_panel = Ext.getCmp(rp);
      this.clear_base_params();
      if (status == undefined) status = {};
      //~ if (status.param_values) 
      //~ this.set_field_values(status.field_values);
      if (status.base_params) this.set_base_params(status.base_params);
      this.refresh();
      }
  ,refresh : function() {
      //~ this.app_instance.event_store.reload(); 20130905
      this.app_instance.calendar_store.load();  // added 20140402
      this.app_instance.event_store.load();
  }
  ,layout: 'fit'
  ,get_base_params : function() {
    // console.log('20140402 getbase_params has', this.base_params);
    var p = Ext.apply({}, this.base_params);
    Lino.insert_subst_user(p);
    // console.log('20140402 getbase_params returns', p);
    return p;
  }
  ,set_base_params : function(p) {
    this.base_params = Ext.apply(this.app_instance.event_store.baseParams,p);
    this.app_instance.event_store.baseParams = this.base_params;
    // console.log('20140402 this.base_params is', this.base_params);
  }
  ,clear_base_params : function() {
      this.base_params = {};
      Lino.insert_subst_user(this.base_params);
  }
  ,set_base_param : function(k,v) {
      if (!this.base_params) this.base_params = {};
      this.base_params[k] = v;
  }
});

Lino.CalendarApp = function() { return {
  team_view_button : null 
  ,get_main_panel : function() {
      var cap = null;
      this.event_store = new Ext.data.JsonStore({ 
          listeners: { exception: Lino.on_store_exception }
          ,url: '/restful/extensible/PanelEvents'
          ,restful : true
          ,proxy: new Ext.data.HttpProxy({ 
              url: '/restful/extensible/PanelEvents', 
              disableCaching: false // no need for cache busting when loading via Ajax
              //~ disableCaching:true,
          })
          ,fields: Ext.ensible.cal.EventRecord.prototype.fields.getRange()
          ,totalProperty: "count"
          ,root: "rows"
          ,idProperty: Ext.ensible.cal.EventMappings.EventId.mapping
          ,writer : new Ext.data.JsonWriter({
            writeAllFields: false
          })
          ,load: function(options) {
            //~ foo.bar = baz; // 20120213
              if (!options) options = {};
              if (!options.params) options.params = {};
              //~ options.params.$ext_requests.URL_PARAM_TEAM_VIEW = Lino.calendar_app.team_view_button.pressed;
              
              var view = this.cal_panel.getActiveView();
              var bounds = view.getViewBounds();
              //~ var p = {sd:'05.02.2012',ed:'11.02.2012'};
              //~ var p = {};
              options.params[view.dateParamStart] = bounds.start.format(view.dateParamFormat);
              options.params[view.dateParamEnd] = bounds.end.format(view.dateParamFormat);
              Lino.insert_subst_user(options.params);
              Ext.apply(options.params, cap.get_base_params());
              //~ this.cal_panel.base_params.su.toString();
              //~ if (this.cal_panel) {
                  // Ext.apply(options.params,this.cal_panel.base_params);
              //~ }
              //~ Ext.apply(options.params,p)
              //~ console.log('20130905 eventStore.load()',this.cal_panel,this.baseParams,options.params);
            
            return Ext.data.JsonStore.prototype.load.call(this,options);
          }
      });

      //~ Lino.calendarStore
      this.calendar_store = new Ext.data.JsonStore({ 
          listeners: { exception: Lino.on_store_exception }
          ,restful : true
          ,proxy: new Ext.data.HttpProxy({ 
              url: '/restful/extensible/PanelCalendars?fmt=json', 
              disableCaching: false // no need for cache busting when loading via Ajax
              //~ restful : true
              //~ method: "GET"
          })
          //~ ,autoLoad: true
          //~ ,remoteSort: true
          //~ ,baseParams: bp
          ,totalProperty: "count"
          ,root: "rows"
          ,fields: Ext.ensible.cal.CalendarRecord.prototype.fields.getRange()
          ,idProperty: Ext.ensible.cal.CalendarMappings.CalendarId.mapping
          //~ ,idIndex: Ext.ensible.cal.CalendarMappings.CalendarId.mapping
          ,load: function(options) {
              // new since 20140402 add substitute user when calling
              // calendars
              if (!options) options = {};
              if (!options.params) options.params = {};
              // Lino.insert_subst_user(options.params);
              Ext.apply(options.params, cap.get_base_params());
              // console.log("20140402 calendar_store.load", options.params, 
              //             this.cal_panel, cap.get_base_params());
            return Ext.data.JsonStore.prototype.load.call(this,options);
          }
      });
      
      cap = new Lino.CalendarAppPanel({ 
          app_instance: this, 
          items : 
        //~ [{
          //~ id: 'app-header',
          //~ region: 'north',
          //~ height: 35,
          //~ border: false,
          // contentEl: 'app-header-content'
        //~ },
      {
          id: 'app-center',
          title: '...', // will be updated to the current view's date range
          region: 'center',
          layout: 'border',
          listeners: {
              'afterrender': function(){
                  Ext.getCmp('app-center').header.addClass('app-center-header');
              }
          },
          items: [{
              id:'app-west',
              region: 'west',
              width: 176,
              border: false,
              items: [{
                  xtype: 'datepicker',
                  id: 'app-nav-picker',
                  cls: 'ext-cal-nav-picker',
                  listeners: {
                      'select': {
                          fn: function(dp, dt){
                              // console.log("20131017",dp);
                              //~ Lino.calendarPanel.setStartDate(dt);
                              //~ cap.setStartDate(dt);
                              Ext.getCmp('app-calendar').setStartDate(dt);
                          },
                          //~ scope: this
                      }
                  }
              //~ },{ 
                //~ layout:'fit',
                //~ items: [
                  //~ new Ext.form.Checkbox({
                    //~ boxLabel:"$_('Team view')",
                    //~ hideLabel:true
                    //~ listeners: { click: }
                  //~ })
                //~ ]
              //~ },{ 
                //~ layout:'form',
                //~ items: [
                  //~ this.team_view_button = new Ext.Button({
                    //~ text:"Team view",
                    //~ enableToggle:true,
                    //~ pressed:false,
                    //~ toggleHandler: function(btn,state) { 
                      //~ // console.log('20120716 teamView.toggle()');
                      //~ this.event_store.setBaseParam('tv',state);
                      //~ this.event_store.load();
                      //~ // Lino.eventStore.load({params:{$ext_requests.URL_PARAM_TEAM_VIEW:state}});
                      //~ // console.log("team view",state);
                    //~ }
                  //~ })
                //~ ]
              },{
                  xtype: 'extensible.calendarlist',
                  store: this.calendar_store,
                  border: false,
                  width: 175
              }]
          },{
              xtype: 'extensible.calendarpanel', // Ext.ensible.cal.CalendarPanel
              eventStore: this.event_store,
              app_instance: this,
              calendarStore: this.calendar_store,
              border: false,
              id:'app-calendar',
              region: 'center',
              //~ activeItem: 3, // month view
              
              // Any generic view options that should be applied to all sub views:
              viewConfig: {
                  // Lino.CalendarCfg
                  dateParamFormat: 'd.m.Y',
                  dateParamStart:'sd',
                  dateParamEnd:'ed',
                
                  //enableFx: false,
                  //ddIncrement: 10, //only applies to DayView and subclasses, but convenient to put it here
                  viewStartHour: 8, // 8
                  viewEndHour: 18 // 18
                  //minEventDisplayMinutes: 15
              },
              
              // View options specific to a certain view (if the same options exist in viewConfig
              // they will be overridden by the view-specific config):
              monthViewCfg: {
                  showHeader: true,
                  showWeekLinks: true,
                  showWeekNumbers: true,
                  eventBodyMarkup: ['{Title}',
                    //~ '<tpl if="url">',
                        //~ '<a href="{url}">XX</a>',
                    //~ '</tpl>',
                    '<tpl if="_isReminder">',
                        '<i class="ext-cal-ic ext-cal-ic-rem">&#160;</i>',
                    '</tpl>',
                    '<tpl if="_isRecurring">',
                        '<i class="ext-cal-ic ext-cal-ic-rcr">&#160;</i>',
                    '</tpl>',
                    '<tpl if="spanLeft">',
                        '<i class="ext-cal-spl">&#160;</i>',
                    '</tpl>',
                    '<tpl if="spanRight">',
                        '<i class="ext-cal-spr">&#160;</i>',
                    '</tpl>'
                ].join('')
              },
              
              multiWeekViewCfg: {
                  //weekCount: 3
              },
              
              // Some optional CalendarPanel configs to experiment with:
              //readOnly: true,
              //showDayView: false,
              //showMultiDayView: true,
              //showWeekView: false,
              //showMultiWeekView: false,
              //showMonthView: false,
              //showNavBar: false,
              //showTodayText: false,
              //showTime: false,
              //editModal: true,
              //enableEditDetails: false,
              //title: 'My Calendar', // the header of the calendar, could be a subtitle for the app
              
              // Once this component inits it will set a reference to itself as an application
              // member property for easy reference in other functions within App.
              //~ initComponent: function() {
                  //~ Lino.calendarPanel = this;
                  //~ this.constructor.prototype.initComponent.apply(this, arguments);
              //~ },
              
              listeners: {
                  //~ 'eventclick': {
                      //~ fn: function(vw, rec, el){
                          //~ this.clearMsg();
                      //~ },
                      //~ scope: this
                  //~ },
                  'eventover': function(vw, rec, el){
                      //console.log('Entered evt rec='+rec.data[Ext.ensible.cal.EventMappings.Title.name]', view='+ vw.id +', el='+el.id);
                  },
                  'eventout': function(vw, rec, el){
                      //console.log('Leaving evt rec='+rec.data[Ext.ensible.cal.EventMappings.Title.name]+', view='+ vw.id +', el='+el.id);
                  },
                  'eventadd': {
                      fn: function(cp, rec){
                          this.showMsg('Event '+ rec.data[Ext.ensible.cal.EventMappings.Title.name] +' was added');
                      },
                      scope: this
                  },
                  'eventupdate': {
                      fn: function(cp, rec){
                          this.showMsg('Event '+ rec.data[Ext.ensible.cal.EventMappings.Title.name] +' was updated');
                      },
                      scope: this
                  },
                  'eventdelete': {
                      fn: function(cp, rec){
                          //this.eventStore.remove(rec);
                          this.showMsg('Event '+ rec.data[Ext.ensible.cal.EventMappings.Title.name] +' was deleted');
                      },
                      scope: this
                  },
                  'eventcancel': {
                      fn: function(cp, rec){
                          // edit canceled
                      },
                      scope: this
                  },
                  'viewchange': {
                      fn: function(p, vw, dateInfo){
                          if(this.editWin){
                              this.editWin.hide();
                          };
                          if(dateInfo !== null){
                              // will be null when switching to the event edit form so ignore
                              Ext.getCmp('app-nav-picker').setValue(dateInfo.activeDate);
                              this.updateTitle(dateInfo.viewStart, dateInfo.viewEnd);
                          }
                          
                      },
                      scope: this
                  },
                  'dayclick': {
                      fn: function(vw, dt, ad, el){
                          this.clearMsg();
                      },
                      scope: this
                  },
                  'rangeselect': {
                      fn: function(vw, dates, onComplete){
                          this.clearMsg();
                      },
                      scope: this
                  },
                  'eventmove': {
                      fn: function(vw, rec){
                          rec.commit();
                          var time = rec.data[Ext.ensible.cal.EventMappings.IsAllDay.name] ? '' : ' \\a\\t g:i a';
                          this.showMsg('Event '+ rec.data[Ext.ensible.cal.EventMappings.Title.name] +' was moved to '+
                              rec.data[Ext.ensible.cal.EventMappings.StartDate.name].format('F jS'+time));
                      },
                      scope: this
                  },
                  'eventresize': {
                      fn: function(vw, rec){
                          rec.commit();
                          this.showMsg('Event '+ rec.data[Ext.ensible.cal.EventMappings.Title.name] +' was updated');
                      },
                      scope: this
                  },
                  'eventdelete': {
                      fn: function(win, rec){
                          this.event_store.remove(rec);
                          this.showMsg('Event '+ rec.data[Ext.ensible.cal.EventMappings.Title.name] +' was deleted');
                      },
                      scope: this
                  },
                  'initdrag': {
                      fn: function(vw){
                          if(this.editWin && this.editWin.isVisible()){
                              this.editWin.hide();
                          }
                      },
                      scope: this
                  }
              }
          }]
        }
        //~ ]
        
      });
      
      this.event_store.on('load',function(){
        //~ console.log("20130905 on event_store load",this.event_store.reader.jsonData);
        if (this.event_store.reader.jsonData) {
          //~ console.log("20130808 b",this.event_store.reader.jsonData.title);
          //~ console.log("20130808 c",this);
          cap.set_window_title(this.event_store.reader.jsonData.title);
        }
      },this);
      
      //~ cap.app_instance = this;
      return cap;
      
  }
  ,updateTitle: function(startDt, endDt){
      var p = Ext.getCmp('app-center');
      
      if(startDt.clearTime().getTime() == endDt.clearTime().getTime()){
          p.setTitle(startDt.format('F j, Y'));
      }
      else if(startDt.getFullYear() == endDt.getFullYear()){
          if(startDt.getMonth() == endDt.getMonth()){
              p.setTitle(startDt.format('F j') + ' - ' + endDt.format('j, Y'));
          }
          else{
              p.setTitle(startDt.format('F j') + ' - ' + endDt.format('F j, Y'));
          }
      }
      else{
          p.setTitle(startDt.format('F j, Y') + ' - ' + endDt.format('F j, Y'));
      }
  }
  // This is an application-specific way to communicate CalendarPanel event messages back to the user.
  // This could be replaced with a function to do "toast" style messages, growl messages, etc. This will
  // vary based on application requirements, which is why it's not baked into the CalendarPanel.
  ,showMsg: function(msg){
      Lino.notify(msg);
      //~ Ext.fly('app-msg').update(msg).removeClass('x-hidden');
  }
  
  ,clearMsg: function(){
      Lino.notify('');
      //~ Ext.fly('app-msg').update('').addClass('x-hidden');
  }
}
};


// from lino.modlib.iban:iban/uppercasetextfield.js

Lino.UppercaseTextField = Ext.extend(Ext.form.TextField,{
  style: 'text-transform:uppercase;',
  listeners:{
    change: function(field, newValue, oldValue){
      // console.log("20140403 UppercaseTextField",newValue, newValue.toUpperCase());
      field.setRawValue(newValue.toUpperCase());
    }
  }
});


Lino.iban_renderer = function(
    value, metaData, record, rowIndex, colIndex, store) 
{
    var reg = new RegExp(".{4}", "g");
    if(value) {
        return value.replace(reg, function (a) { return a + ' '; });
    }
    return value;
}




// from lino.modlib.beid (media_name=eidreader):beid/eidreader.js


Lino.beid_read_card_processor = function() {
    var card = document.applets.EIDReader.readCard();
    // if (!card) {
    //     Lino.alert("Could not find any card on your reader.");
    //     return null;
    // } 
    // console.log(20140301, card);
    return { card_data: card };
}


// from lino.modlib.davlink (media_name=davlink):davlink/davlink.js

/*
 Copyright 2009-2014 Luc Saffre
 License: BSD (see file COPYING for details)
*/

Lino.davlink_open = function(webdavURL) {
  /* Calls lino.applets.davlink.DavLink.open()
  */
  //~ console.log('Going to call document.applets.DavLink.open(',webdavURL,')');
  var rv = document.applets.DavLink.open(webdavURL);
  if (rv) window.alert(rv);
}

Lino.davlink_reset = function() {
  var rv = document.applets.DavLink.generate_default_prefs();
  if (rv) window.alert(rv);
}

Lino.main_menu = [ { "menu": { "items": [ { "text": "Personen", "handler": function() {Lino.contacts.Persons.grid.run(null)} }, { "text": " \u25b6 Klienten", "handler": function() {Lino.pcsw.Clients.grid.run(null)} }, { "text": "Organisationen", "handler": function() {Lino.contacts.Companies.grid.run(null)} }, "-", { "text": "Partner (alle)", "handler": function() {Lino.contacts.Partners.grid.run(null)} }, { "text": "Haushalte", "handler": function() {Lino.households.Households.grid.run(null)} } ] }, "text": "Kontakte" }, { "menu": { "items": [ { "text": "Meine Uploads", "handler": function() {Lino.uploads.MyUploads.grid.run(null)} }, { "text": "Mein E-Mail-Ausgang", "handler": function() {Lino.outbox.MyOutbox.grid.run(null)} }, { "text": "Meine Ausz\u00fcge", "handler": function() {Lino.excerpts.MyExcerpts.grid.run(null)} }, { "text": "Meine Ereignisse/Notizen", "handler": function() {Lino.notes.MyNotes.grid.run(null)} } ] }, "text": "B\u00fcro" }, { "menu": { "items": [ { "text": "Kalender", "iconCls": "x-tbar-calendar", "handler": function() {Lino.extensible.CalendarPanel.grid.run(null)}, "listeners": { "render": Lino.quicktip_renderer("Foo","Displays your events in a \"calendar view\"     with the possibility to switch between daily, weekly, monthly view.") } }, { "text": "Meine Termine", "listeners": { "render": Lino.quicktip_renderer("Foo","Alle meine Termine") }, "handler": function() {Lino.cal.MyEvents.grid.run(null)} }, { "text": "Meine Aufgaben", "listeners": { "render": Lino.quicktip_renderer("Foo","Alle meine Aufgaben") }, "handler": function() {Lino.cal.MyTasks.grid.run(null)} }, { "text": "Meine G\u00e4ste", "handler": function() {Lino.cal.MyGuests.grid.run(null)} }, { "text": "Meine Anwesenheiten", "listeners": { "render": Lino.quicktip_renderer("Foo","Shows all my presences in calendar events, independently of their state.") }, "handler": function() {Lino.cal.MyPresences.grid.run(null)} } ] }, "text": "Kalender" }, { "menu": { "items": [ { "text": "Klienten", "handler": function() {Lino.reception.Clients.grid.run(null)} }, { "text": "Termine heute", "handler": function() {Lino.cal.EventsByDay.grid.run(null)} } ] }, "text": "Empfang" }, { "menu": { "items": [ { "text": "Meine Begleitungen", "handler": function() {Lino.pcsw.MyCoachings.grid.run(null)} } ] }, "text": "\u00d6SHZ" }, { "menu": { "items": [ { "menu": { "items": [ { "text": "Stale Controllables", "handler": function() {Lino.contenttypes.StaleControllables.grid.run(null)} } ] }, "text": "System" } ] }, "text": "Listings" }, { "menu": { "items": [ { "menu": { "items": [ { "text": "Meine Einf\u00fcgetexte", "handler": function() {Lino.system.MyTextFieldTemplates.grid.run(null)} } ] }, "text": "B\u00fcro" }, { "menu": { "items": [ { "text": "L\u00e4nder", "listeners": { "render": Lino.quicktip_renderer("Foo","\n    A country is a geographic entity considered a \"nation\".\n    ") }, "handler": function() {Lino.countries.Countries.grid.run(null)} } ] }, "text": "Orte" }, { "menu": { "items": [ { "text": "Sprachen", "handler": function() {Lino.languages.Languages.grid.run(null)} } ] }, "text": "Kontakte" } ] }, "text": "Konfigurierung" }, { "menu": { "items": [ { "menu": { "items": [ { "text": "Upload-Bereiche", "handler": function() {Lino.uploads.UploadAreas.grid.run(null)} } ] }, "text": "B\u00fcro" }, { "menu": { "items": [ { "text": "Adressenarten", "handler": function() {Lino.addresses.AddressTypes.grid.run(null)} }, { "text": "Rollen", "handler": function() {Lino.households.MemberRoles.grid.run(null)} } ] }, "text": "Kontakte" }, { "menu": { "items": [ { "text": "Konten", "handler": function() {Lino.sepa.Accounts.grid.run(null)} } ] }, "text": "SEPA" }, { "menu": { "items": [ { "text": "Einkommensbescheinigungen", "handler": function() {Lino.aids.IncomeConfirmations.grid.run(null)} }, { "text": "Kosten\u00fcbernahmescheine", "handler": function() {Lino.aids.RefundConfirmations.grid.run(null)} }, { "text": "Einfache Bescheinigungen", "handler": function() {Lino.aids.SimpleConfirmations.grid.run(null)} } ] }, "text": "\u00d6SHZ" }, { "menu": { "items": [ { "text": "Vertragspartner", "handler": function() {Lino.isip.ContractPartners.grid.run(null)} } ] }, "text": "DSBE" } ] }, "text": "Explorer" }, { "menu": { "items": [ { "text": "Info", "listeners": { "render": Lino.quicktip_renderer("Foo","Zeigt Informationen \u00fcber diese Site an.") }, "handler": function() {Lino.about.About.show.run(null,{ "record_id": -99998 })} } ] }, "text": "Site" }, { "text": "Startseite", "handler": function() {Lino.handle_home_button()} } ];
Ext.namespace('Lino.system.TextFieldTemplates')
Ext.namespace('Lino.system.SiteConfigs')
Ext.namespace('Lino.contenttypes.ContentTypes')
Ext.namespace('Lino.contenttypes.HelpTexts')
Ext.namespace('Lino.users.Users')
Ext.namespace('Lino.users.MySettings')
Ext.namespace('Lino.users.UsersOverview')
Ext.namespace('Lino.users.Authorities')
Ext.namespace('Lino.cal.RemoteCalendars')
Ext.namespace('Lino.cal.Rooms')
Ext.namespace('Lino.cal.Priorities')
Ext.namespace('Lino.cal.Calendars')
Ext.namespace('Lino.cal.Subscriptions')
Ext.namespace('Lino.cal.Tasks')
Ext.namespace('Lino.cal.MyTasks')
Ext.namespace('Lino.cal.GuestRoles')
Ext.namespace('Lino.cal.Guests')
Ext.namespace('Lino.cal.MyPresences')
Ext.namespace('Lino.cal.MyPendingPresences')
Ext.namespace('Lino.cal.MyGuests')
Ext.namespace('Lino.outbox.Recipients')
Ext.namespace('Lino.outbox.Mails')
Ext.namespace('Lino.outbox.Attachments')
Ext.namespace('Lino.cal.EventTypes')
Ext.namespace('Lino.cal.RecurrentEvents')
Ext.namespace('Lino.cal.Events')
Ext.namespace('Lino.cal.EventsByDay')
Ext.namespace('Lino.cal.OneEvent')
Ext.namespace('Lino.cal.MyEvents')
Ext.namespace('Lino.cal.MyAssignedEvents')
Ext.namespace('Lino.changes.Changes')
Ext.namespace('Lino.countries.Countries')
Ext.namespace('Lino.countries.Places')
Ext.namespace('Lino.properties.PropGroups')
Ext.namespace('Lino.properties.PropTypes')
Ext.namespace('Lino.properties.Properties')
Ext.namespace('Lino.properties.PropChoices')
Ext.namespace('Lino.contacts.CompanyTypes')
Ext.namespace('Lino.contacts.Partners')
Ext.namespace('Lino.contacts.RoleTypes')
Ext.namespace('Lino.contacts.Roles')
Ext.namespace('Lino.addresses.Addresses')
Ext.namespace('Lino.contacts.Persons')
Ext.namespace('Lino.contacts.Companies')
Ext.namespace('Lino.uploads.AreaUploads')
Ext.namespace('Lino.uploads.UploadTypes')
Ext.namespace('Lino.uploads.Uploads')
Ext.namespace('Lino.extensible.PanelCalendars')
Ext.namespace('Lino.extensible.PanelEvents')
Ext.namespace('Lino.reception.ExpectedGuests')
Ext.namespace('Lino.reception.BusyVisitors')
Ext.namespace('Lino.reception.WaitingVisitors')
Ext.namespace('Lino.reception.GoneVisitors')
Ext.namespace('Lino.reception.MyWaitingVisitors')
Ext.namespace('Lino.reception.MyBusyVisitors')
Ext.namespace('Lino.reception.MyGoneVisitors')
Ext.namespace('Lino.households.Types')
Ext.namespace('Lino.households.Members')
Ext.namespace('Lino.households.Households')
Ext.namespace('Lino.cv.LanguageKnowledges')
Ext.namespace('Lino.cv.TrainingTypes')
Ext.namespace('Lino.cv.Trainings')
Ext.namespace('Lino.cv.EducationLevels')
Ext.namespace('Lino.cv.StudyTypes')
Ext.namespace('Lino.cv.Studies')
Ext.namespace('Lino.cv.Statuses')
Ext.namespace('Lino.cv.Regimes')
Ext.namespace('Lino.cv.Durations')
Ext.namespace('Lino.cv.Sectors')
Ext.namespace('Lino.cv.Functions')
Ext.namespace('Lino.cv.Experiences')
Ext.namespace('Lino.cv.PersonProperties')
Ext.namespace('Lino.notes.NoteTypes')
Ext.namespace('Lino.notes.EventTypes')
Ext.namespace('Lino.notes.Notes')
Ext.namespace('Lino.notes.AllNotes')
Ext.namespace('Lino.isip.ContractTypes')
Ext.namespace('Lino.isip.ExamPolicies')
Ext.namespace('Lino.isip.ContractEndings')
Ext.namespace('Lino.isip.ContractPartners')
Ext.namespace('Lino.isip.Contracts')
Ext.namespace('Lino.isip.MyContracts')
Ext.namespace('Lino.jobs.Schedules')
Ext.namespace('Lino.jobs.JobProviders')
Ext.namespace('Lino.jobs.ContractTypes')
Ext.namespace('Lino.jobs.Contracts')
Ext.namespace('Lino.jobs.MyContracts')
Ext.namespace('Lino.jobs.Offers')
Ext.namespace('Lino.jobs.Candidatures')
Ext.namespace('Lino.jobs.Jobs')
Ext.namespace('Lino.jobs.JobTypes')
Ext.namespace('Lino.jobs.ContractsSearch')
Ext.namespace('Lino.pcsw.CoachingTypes')
Ext.namespace('Lino.pcsw.CoachingEndings')
Ext.namespace('Lino.pcsw.Coachings')
Ext.namespace('Lino.pcsw.Clients')
Ext.namespace('Lino.pcsw.AllClients')
Ext.namespace('Lino.pcsw.ClientsTest')
Ext.namespace('Lino.pcsw.PersonGroups')
Ext.namespace('Lino.pcsw.Activities')
Ext.namespace('Lino.pcsw.DispenseReasons')
Ext.namespace('Lino.pcsw.Dispenses')
Ext.namespace('Lino.pcsw.ExclusionTypes')
Ext.namespace('Lino.pcsw.Exclusions')
Ext.namespace('Lino.pcsw.Convictions')
Ext.namespace('Lino.pcsw.AidTypes')
Ext.namespace('Lino.pcsw.ClientContactTypes')
Ext.namespace('Lino.pcsw.ClientContacts')
Ext.namespace('Lino.reception.Clients')
Ext.namespace('Lino.languages.Languages')
Ext.namespace('Lino.accounts.Charts')
Ext.namespace('Lino.accounts.Groups')
Ext.namespace('Lino.accounts.Accounts')
Ext.namespace('Lino.sepa.Accounts')
Ext.namespace('Lino.excerpts.ExcerptTypes')
Ext.namespace('Lino.excerpts.Excerpts')
Ext.namespace('Lino.excerpts.ExcerptsByX')
Ext.namespace('Lino.boards.Boards')
Ext.namespace('Lino.boards.Members')
Ext.namespace('Lino.courses.CourseProviders')
Ext.namespace('Lino.courses.CourseContents')
Ext.namespace('Lino.courses.CourseOffers')
Ext.namespace('Lino.courses.Courses')
Ext.namespace('Lino.courses.CourseRequests')
Ext.namespace('Lino.courses.PendingCourseRequests')
Ext.namespace('Lino.integ.Clients')
Ext.namespace('Lino.integ.CoachingEndingsByUser')
Ext.namespace('Lino.integ.CoachingEndingsByType')
Ext.namespace('Lino.integ.ContractEndingsByType')
Ext.namespace('Lino.integ.JobsContractEndingsByType')
Ext.namespace('Lino.integ.ContractsPerUserAndContractType')
Ext.namespace('Lino.integ.JobsContractsPerUserAndContractType')
Ext.namespace('Lino.integ.StudyTypesAndContracts')
Ext.namespace('Lino.integ.CompaniesAndContracts')
Ext.namespace('Lino.integ.JobProvidersAndContracts')
Ext.namespace('Lino.newcomers.Brokers')
Ext.namespace('Lino.newcomers.Faculties')
Ext.namespace('Lino.newcomers.Competences')
Ext.namespace('Lino.newcomers.NewClients')
Ext.namespace('Lino.newcomers.AvailableCoaches')
Ext.namespace('Lino.cbss.Sectors')
Ext.namespace('Lino.cbss.Purposes')
Ext.namespace('Lino.cbss.IdentifyPersonRequests')
Ext.namespace('Lino.cbss.ManageAccessRequests')
Ext.namespace('Lino.cbss.RetrieveTIGroupsRequests')
Ext.namespace('Lino.humanlinks.Links')
Ext.namespace('Lino.debts.Clients')
Ext.namespace('Lino.debts.Budgets')
Ext.namespace('Lino.debts.Actors')
Ext.namespace('Lino.debts.Entries')
Ext.namespace('Lino.debts.EntriesByType')
Ext.namespace('Lino.aids.Categories')
Ext.namespace('Lino.aids.AidTypes')
Ext.namespace('Lino.aids.Grantings')
Ext.namespace('Lino.aids.MyPendingGrantings')
Ext.namespace('Lino.aids.GrantingsByX')
Ext.namespace('Lino.aids.SimpleConfirmations')
Ext.namespace('Lino.aids.IncomeConfirmations')
Ext.namespace('Lino.aids.RefundConfirmations')
Ext.namespace('Lino.system.MyTextFieldTemplates')
Ext.namespace('Lino.users.AuthoritiesGiven')
Ext.namespace('Lino.users.AuthoritiesTaken')
Ext.namespace('Lino.cal.SubscriptionsByUser')
Ext.namespace('Lino.cal.SubscriptionsByCalendar')
Ext.namespace('Lino.cal.TasksByUser')
Ext.namespace('Lino.cal.TasksByProject')
Ext.namespace('Lino.cal.GuestsByEvent')
Ext.namespace('Lino.cal.GuestsByRole')
Ext.namespace('Lino.cal.GuestsByPartner')
Ext.namespace('Lino.outbox.RecipientsByMail')
Ext.namespace('Lino.outbox.MyOutbox')
Ext.namespace('Lino.outbox.MailsByUser')
Ext.namespace('Lino.outbox.MailsByProject')
Ext.namespace('Lino.outbox.SentByPartner')
Ext.namespace('Lino.outbox.AttachmentsByMail')
Ext.namespace('Lino.cal.EventsByType')
Ext.namespace('Lino.cal.EventsByRoom')
Ext.namespace('Lino.cal.EventsByProject')
Ext.namespace('Lino.cal.EventsByClient')
Ext.namespace('Lino.cal.TasksByClient')
Ext.namespace('Lino.countries.PlacesByPlace')
Ext.namespace('Lino.countries.PlacesByCountry')
Ext.namespace('Lino.properties.PropsByGroup')
Ext.namespace('Lino.properties.PropsByType')
Ext.namespace('Lino.properties.ChoicesByType')
Ext.namespace('Lino.contacts.PartnersByCity')
Ext.namespace('Lino.contacts.PartnersByCountry')
Ext.namespace('Lino.contacts.RolesByCompany')
Ext.namespace('Lino.contacts.RolesByPerson')
Ext.namespace('Lino.addresses.AddressesByPartner')
Ext.namespace('Lino.contacts.PartnersByClientContactType')
Ext.namespace('Lino.uploads.UploadsByType')
Ext.namespace('Lino.uploads.MyUploads')
Ext.namespace('Lino.uploads.UploadsByClient')
Ext.namespace('Lino.reception.AppointmentsByPartner')
Ext.namespace('Lino.households.HouseholdsByType')
Ext.namespace('Lino.households.MembersByHousehold')
Ext.namespace('Lino.households.MembersByPerson')
Ext.namespace('Lino.households.SiblingsByPerson')
Ext.namespace('Lino.households.RefundsByPerson')
Ext.namespace('Lino.cv.LanguageKnowledgesByPerson')
Ext.namespace('Lino.cv.KnowledgesByLanguage')
Ext.namespace('Lino.cv.TrainingsByCountry')
Ext.namespace('Lino.cv.TrainingsByType')
Ext.namespace('Lino.cv.TrainingsByPerson')
Ext.namespace('Lino.cv.StudyTypesByLevel')
Ext.namespace('Lino.cv.StudiesByCountry')
Ext.namespace('Lino.cv.StudiesByLevel')
Ext.namespace('Lino.cv.StudiesByPlace')
Ext.namespace('Lino.cv.StudiesByType')
Ext.namespace('Lino.cv.StudiesByPerson')
Ext.namespace('Lino.cv.FunctionsBySector')
Ext.namespace('Lino.cv.ExperiencesBySector')
Ext.namespace('Lino.cv.ExperiencesByFunction')
Ext.namespace('Lino.cv.ExperiencesByPerson')
Ext.namespace('Lino.cv.ExperiencesByStatus')
Ext.namespace('Lino.cv.ExperiencesByRegime')
Ext.namespace('Lino.cv.ExperiencesByDuration')
Ext.namespace('Lino.cv.PropsByPerson')
Ext.namespace('Lino.cv.PersonPropsByProp')
Ext.namespace('Lino.cv.ConfiguredPropsByPerson')
Ext.namespace('Lino.cv.SkillsByPerson')
Ext.namespace('Lino.cv.SoftSkillsByPerson')
Ext.namespace('Lino.cv.ObstaclesByPerson')
Ext.namespace('Lino.notes.MyNotes')
Ext.namespace('Lino.notes.NotesByType')
Ext.namespace('Lino.notes.NotesByEventType')
Ext.namespace('Lino.notes.NotesByPerson')
Ext.namespace('Lino.notes.NotesByProject')
Ext.namespace('Lino.notes.NotesByCompany')
Ext.namespace('Lino.isip.PartnersByContract')
Ext.namespace('Lino.isip.ContractsByPerson')
Ext.namespace('Lino.isip.ContractsByPolicy')
Ext.namespace('Lino.isip.ContractsByType')
Ext.namespace('Lino.isip.ContractsByEnding')
Ext.namespace('Lino.isip.ContractsByStudyType')
Ext.namespace('Lino.jobs.ContractsByPerson')
Ext.namespace('Lino.jobs.ContractsByProvider')
Ext.namespace('Lino.jobs.ContractsByPolicy')
Ext.namespace('Lino.jobs.ContractsByType')
Ext.namespace('Lino.jobs.ContractsByEnding')
Ext.namespace('Lino.jobs.ContractsByJob')
Ext.namespace('Lino.jobs.ContractsByRegime')
Ext.namespace('Lino.jobs.ContractsBySchedule')
Ext.namespace('Lino.jobs.CandidaturesByPerson')
Ext.namespace('Lino.jobs.CandidaturesBySector')
Ext.namespace('Lino.jobs.CandidaturesByFunction')
Ext.namespace('Lino.jobs.CandidaturesByJob')
Ext.namespace('Lino.jobs.CandidaturesByOffer')
Ext.namespace('Lino.jobs.ExperiencesByOffer')
Ext.namespace('Lino.jobs.JobsByProvider')
Ext.namespace('Lino.jobs.JobsByType')
Ext.namespace('Lino.jobs.JobsOverviewByType')
Ext.namespace('Lino.pcsw.CoachingsByClient')
Ext.namespace('Lino.pcsw.CoachingsByUser')
Ext.namespace('Lino.pcsw.CoachingsByEnding')
Ext.namespace('Lino.pcsw.MyCoachings')
Ext.namespace('Lino.pcsw.ClientsByNationality')
Ext.namespace('Lino.pcsw.DispensesByClient')
Ext.namespace('Lino.pcsw.ExclusionsByClient')
Ext.namespace('Lino.pcsw.ConvictionsByClient')
Ext.namespace('Lino.pcsw.ContactsByClient')
Ext.namespace('Lino.pcsw.ClientContactsByType')
Ext.namespace('Lino.reception.CoachingsByClient')
Ext.namespace('Lino.accounts.GroupsByChart')
Ext.namespace('Lino.accounts.AccountsByGroup')
Ext.namespace('Lino.sepa.AccountsByPartner')
Ext.namespace('Lino.sepa.AccountsByClient')
Ext.namespace('Lino.excerpts.MyExcerpts')
Ext.namespace('Lino.excerpts.ExcerptsByType')
Ext.namespace('Lino.excerpts.ExcerptsByProject')
Ext.namespace('Lino.boards.MembersByBoard')
Ext.namespace('Lino.courses.CourseOffersByProvider')
Ext.namespace('Lino.courses.CourseOffersByContent')
Ext.namespace('Lino.courses.CoursesByOffer')
Ext.namespace('Lino.courses.CourseRequestsByPerson')
Ext.namespace('Lino.courses.CourseRequestsByContent')
Ext.namespace('Lino.courses.RequestsByCourse')
Ext.namespace('Lino.courses.ParticipantsByCourse')
Ext.namespace('Lino.courses.CandidatesByCourse')
Ext.namespace('Lino.newcomers.CompetencesByUser')
Ext.namespace('Lino.newcomers.CompetencesByFaculty')
Ext.namespace('Lino.newcomers.MyCompetences')
Ext.namespace('Lino.newcomers.ClientsByFaculty')
Ext.namespace('Lino.newcomers.AvailableCoachesByClient')
Ext.namespace('Lino.cbss.MyIdentifyPersonRequests')
Ext.namespace('Lino.cbss.IdentifyRequestsByPerson')
Ext.namespace('Lino.cbss.ManageAccessRequestsByPerson')
Ext.namespace('Lino.cbss.MyManageAccessRequests')
Ext.namespace('Lino.cbss.RetrieveTIGroupsRequestsByPerson')
Ext.namespace('Lino.cbss.MyRetrieveTIGroupsRequests')
Ext.namespace('Lino.humanlinks.LinksByHuman')
Ext.namespace('Lino.debts.MyBudgets')
Ext.namespace('Lino.debts.BudgetsByPartner')
Ext.namespace('Lino.debts.ActorsByBudget')
Ext.namespace('Lino.debts.ActorsByPartner')
Ext.namespace('Lino.debts.EntriesByAccount')
Ext.namespace('Lino.debts.EntriesByBudget')
Ext.namespace('Lino.debts.ExpensesByBudget')
Ext.namespace('Lino.debts.IncomesByBudget')
Ext.namespace('Lino.debts.LiabilitiesByBudget')
Ext.namespace('Lino.debts.AssetsByBudget')
Ext.namespace('Lino.debts.DistByBudget')
Ext.namespace('Lino.aids.GrantingsByClient')
Ext.namespace('Lino.aids.GrantingsByType')
Ext.namespace('Lino.aids.SimpleConfirmationsByGranting')
Ext.namespace('Lino.aids.IncomeConfirmationsByGranting')
Ext.namespace('Lino.aids.IncomeConfirmationsByCategory')
Ext.namespace('Lino.aids.RefundConfirmationsByGranting')
Ext.namespace('Lino.isip.DelegatedTasksByContract')
Ext.namespace('Lino.isip.EventsByContract')
Ext.namespace('Lino.contenttypes.HelpTextsByModel')
Ext.namespace('Lino.changes.ChangesByObject')
Ext.namespace('Lino.notes.NotesByOwner')
Ext.namespace('Lino.uploads.UploadsByController')
Ext.namespace('Lino.cal.TasksByController')
Ext.namespace('Lino.outbox.MailsByController')
Ext.namespace('Lino.changes.ChangesByMaster')
Ext.namespace('Lino.outbox.AttachmentsByController')
Ext.namespace('Lino.cal.EventsByController')
Ext.namespace('Lino.excerpts.ExcerptsByOwner')
Ext.namespace('Lino.about.Models')
Ext.namespace('Lino.about.FieldsByModel')
Ext.namespace('Lino.about.Inspector')
Ext.namespace('Lino.about.DetailLayouts')
Ext.namespace('Lino.about.SourceFiles')
Ext.namespace('Lino.contenttypes.StaleControllables')
Ext.namespace('Lino.contenttypes.StaleControllablesByModel')
Ext.namespace('Lino.dedupe.SimilarPersons')
Ext.namespace('Lino.reception.ButtonsTable')
Ext.namespace('Lino.reception.CreateEventActionsByClient')
Ext.namespace('Lino.integ.UsersWithClients')
Ext.namespace('Lino.integ.CompareRequestsTable')
Ext.namespace('Lino.integ.PeriodicNumbers')
Ext.namespace('Lino.cbss.IdentifyPersonResult')
Ext.namespace('Lino.cbss.RetrieveTIGroupsResult')
Ext.namespace('Lino.debts.PrintEntriesByBudget')
Ext.namespace('Lino.debts.PrintIncomesByBudget')
Ext.namespace('Lino.debts.PrintExpensesByBudget')
Ext.namespace('Lino.debts.PrintLiabilitiesByBudget')
Ext.namespace('Lino.debts.PrintAssetsByBudget')
Ext.namespace('Lino.debts.SummaryTable')
Ext.namespace('Lino.debts.ResultByBudget')
Ext.namespace('Lino.debts.DebtsByBudget')
Ext.namespace('Lino.debts.BailiffDebtsByBudget')
Ext.namespace('Lino.aids.ConfirmationsByGranting')
Ext.namespace('Lino.about.About')
Ext.namespace('Lino.extensible.CalendarPanel')
Ext.namespace('Lino.jobs.OldJobsOverview')
Ext.namespace('Lino.jobs.JobsOverview')
Ext.namespace('Lino.integ.ActivityReport')
Ext.namespace('Lino.courses.CourseRequestStates')
Ext.namespace('Lino.sepa.AccountTypes')
Ext.namespace('Lino.cal.DurationUnits')
Ext.namespace('Lino.uploads.UploadAreas')
Ext.namespace('Lino.cal.TaskStates')
Ext.namespace('Lino.addresses.DataSources')
Ext.namespace('Lino.users.UserLevels')
Ext.namespace('Lino.cal.Weekdays')
Ext.namespace('Lino.households.MemberDependencies')
Ext.namespace('Lino.outbox.RecipientTypes')
Ext.namespace('Lino.excerpts.Shortcuts')
Ext.namespace('Lino.beid.BeIdCardTypes')
Ext.namespace('Lino.system.PeriodEvents')
Ext.namespace('Lino.cal.EventStates')
Ext.namespace('Lino.accounts.AccountTypes')
Ext.namespace('Lino.cal.Recurrencies')
Ext.namespace('Lino.system.Genders')
Ext.namespace('Lino.pcsw.ClientStates')
Ext.namespace('Lino.cv.CefLevel')
Ext.namespace('Lino.jobs.CandidatureStates')
Ext.namespace('Lino.properties.HowWell')
Ext.namespace('Lino.lino.BuildMethods')
Ext.namespace('Lino.cal.EventEvents')
Ext.namespace('Lino.aids.ConfirmationTypes')
Ext.namespace('Lino.pcsw.CivilState')
Ext.namespace('Lino.households.MemberRoles')
Ext.namespace('Lino.cal.GuestStates')
Ext.namespace('Lino.properties.DoYouLike')
Ext.namespace('Lino.cbss.RequestLanguages')
Ext.namespace('Lino.addresses.AddressTypes')
Ext.namespace('Lino.aids.AidRegimes')
Ext.namespace('Lino.pcsw.RefusalReasons')
Ext.namespace('Lino.users.UserGroups')
Ext.namespace('Lino.cv.SchoolingStates')
Ext.namespace('Lino.cbss.RequestStates')
Ext.namespace('Lino.lino.ChangeTypes')
Ext.namespace('Lino.humanlinks.LinkTypes')
Ext.namespace('Lino.cal.AccessClasses')
Ext.namespace('Lino.cbss.QueryRegister')
Ext.namespace('Lino.users.UserProfiles')
Ext.namespace('Lino.system.YesNo')
Ext.namespace('Lino.pcsw.ClientEvents')
Ext.namespace('Lino.isip.ContractEvents')
Ext.namespace('Lino.cbss.ManageAction')
Ext.namespace('Lino.cv.HowWell')
Ext.namespace('Lino.countries.PlaceTypes')
Ext.namespace('Lino.pcsw.ResidenceType')
Ext.namespace('Lino.aids.ConfirmationStates')

// ChoiceLists: 
Lino.courses.CourseRequestStates = [ [ "10", "Offen" ], [ "20", "Eingetragen" ], [ "30", "Bestanden" ], [ "40", "Gut bestanden" ], [ "50", "Nicht bestanden" ], [ "60", "Abgebrochen" ], [ "70", "Inaktiv" ] ];
Lino.sepa.AccountTypes = [ [ "01", "Giro" ], [ "02", "Sparkonto" ], [ "03", "Deposits" ], [ "04", "Sonstige" ] ];
Lino.cal.DurationUnits = [ [ "s", "Sekunden" ], [ "m", "Minuten" ], [ "h", "Stunden" ], [ "D", "Tage" ], [ "W", "Wochen" ], [ "M", "Monate" ], [ "Y", "Jahre" ] ];
Lino.uploads.UploadAreas = [ [ "90", "Uploads" ] ];
Lino.cal.TaskStates = [ [ "10", "Zu tun" ], [ "20", "Begonnen" ], [ "30", "Erledigt" ], [ "50", "Storniert" ] ];
Lino.addresses.DataSources = [ [ "01", "Manuell eingegeben" ], [ "02", "Eingelesen von eID-Karte" ] ];
Lino.users.UserLevels = [ [ "10", "Gast" ], [ "30", "Benutzer" ], [ "40", "Manager" ], [ "50", "Verwalter" ] ];
Lino.cal.Weekdays = [ [ "1", "Montag" ], [ "2", "Dienstag" ], [ "3", "Mittwoch" ], [ "4", "Donnerstag" ], [ "5", "Freitag" ], [ "6", "Samstag" ], [ "7", "Sonntag" ] ];
Lino.households.MemberDependencies = [ [ "01", "Zu Lasten" ], [ "02", "Nicht zu Lasten" ], [ "03", "Lasten geteilt" ] ];
Lino.outbox.RecipientTypes = [ [ "to", "Empf\u00e4nger" ], [ "cc", "Kopie an" ], [ "bcc", "Blindkopie an" ] ];
Lino.excerpts.Shortcuts = [ [ "pcsw.Client.cvs_emitted", "Erstellte Lebensl\u00e4ufe" ] ];
Lino.beid.BeIdCardTypes = [ [ "1", "Belgischer Staatsb\u00fcrger" ], [ "6", "Kind unter 12 Jahren" ], [ "11", "A (Bescheinigung der Eintragung im Ausl\u00e4nderregister - Vor\u00fcbergehender Aufenthalt)" ], [ "12", "B (Bescheinigung der Eintragung im Ausl\u00e4nderregister)" ], [ "13", "C (Personalausweis f\u00fcr Ausl\u00e4nder)" ], [ "14", "D (Daueraufenthalt - EG)" ], [ "15", "E (Anmeldebescheinigung)" ], [ "16", "E+" ], [ "17", "F (Aufenthaltskarte f\u00fcr Familienangeh\u00f6rige eines Unionsb\u00fcrgers)" ], [ "18", "F+" ] ];
Lino.system.PeriodEvents = [ [ "10", "Begonnen" ], [ "20", "Aktiv" ], [ "30", "Beendet" ] ];
Lino.cal.EventStates = [ [ "10", "Vorgeschlagen" ], [ "20", "Entwurf" ], [ "50", "Stattgefunden" ], [ "70", "Storniert" ], [ "75", "Omitted" ], [ "40", "Notified" ] ];
Lino.accounts.AccountTypes = [ [ "A", "Verm\u00f6gen" ], [ "L", "Verpflichtungen" ], [ "I", "Eink\u00fcnfte" ], [ "E", "Ausgaben" ], [ "C", "Kapital" ], [ "B", "Bankkonten" ] ];
Lino.cal.Recurrencies = [ [ "O", "einmalig" ], [ "D", "t\u00e4glich" ], [ "W", "w\u00f6chentlich" ], [ "M", "monatlich" ], [ "Y", "j\u00e4hrlich" ], [ "P", "pro Wochentag" ] ];
Lino.system.Genders = [ [ "M", "M\u00e4nnlich" ], [ "F", "Weiblich" ] ];
Lino.pcsw.ClientStates = [ [ "10", "Neuantrag" ], [ "20", "Abgelehnt" ], [ "30", "Begleitet" ], [ "50", "Ehemalig" ] ];
Lino.cv.CefLevel = [ [ "A1", "A1 (Elementare Sprachverwendung)" ], [ "A2", "A2 (Elementare Sprachverwendung)" ], [ "A2+", "A2+ (Elementare Sprachverwendung)" ], [ "B1", "B1 (Selbstst\u00e4ndige Sprachverwendung)" ], [ "B2", "B2 (Selbstst\u00e4ndige Sprachverwendung)" ], [ "B2+", "B2+ (Selbstst\u00e4ndige Sprachverwendung)" ], [ "C1", "C1 (Exzellente Sprachverwendung)" ], [ "C2", "C2 (Exzellente Sprachverwendung)" ], [ "C2+", "C2+ (Exzellente Sprachverwendung)" ] ];
Lino.jobs.CandidatureStates = [ [ "10", "Aktiv" ], [ "20", "Probezeit" ], [ "25", "Probezeit ohne Erfolg" ], [ "27", "Arbeitet" ], [ "30", "Inaktiv" ] ];
Lino.properties.HowWell = [ [ "0", "gar nicht" ], [ "1", "ein bisschen" ], [ "2", "mittelm\u00e4\u00dfig" ], [ "3", "gut" ], [ "4", "sehr gut" ] ];
Lino.lino.BuildMethods = [ [ "appyodt", "AppyOdtBuildMethod" ], [ "appydoc", "AppyDocBuildMethod" ], [ "appypdf", "AppyPdfBuildMethod" ], [ "appyrtf", "AppyRtfBuildMethod" ], [ "latex", "LatexBuildMethod" ], [ "pisa", "PisaBuildMethod" ], [ "rtf", "RtfBuildMethod" ] ];
Lino.cal.EventEvents = [ [ "10", "Okay" ], [ "20", "Pending" ] ];
Lino.aids.ConfirmationTypes = [ [ "aids.SimpleConfirmation", "Einfache Bescheinigung (aids.SimpleConfirmation)" ], [ "aids.IncomeConfirmation", "Einkommensbescheinigung (aids.IncomeConfirmation)" ], [ "aids.RefundConfirmation", "Kosten\u00fcbernahmeschein (aids.RefundConfirmation)" ] ];
Lino.pcsw.CivilState = [ [ "10", "Ledig" ], [ "13", "Ledig zusammenwohnend" ], [ "18", "Ledig mit Kind" ], [ "20", "Ehepartner" ], [ "21", "Verheirated (allein lebend)" ], [ "22", "Verheirated (mit anderem Partner lebend)" ], [ "30", "Verwitwet" ], [ "33", "Verwitwet (zusammenwohnend)" ], [ "40", "Geschieden" ], [ "50", "Getrennt von Tisch und Bett" ] ];
Lino.households.MemberRoles = [ [ "01", "Vorstand" ], [ "02", "Ehepartner" ], [ "03", "Partner" ], [ "04", "Mitbewohner" ], [ "05", "Kind" ], [ "07", "Adoptivkind" ], [ "06", "Verwandt" ] ];
Lino.cal.GuestStates = [ [ "10", "Eingeladen" ], [ "20", "Zugesagt" ], [ "30", "Abgesagt" ], [ "40", "Anwesend" ], [ "50", "Abwesend" ], [ "60", "Entschuldigt" ], [ "44", "Wartet" ], [ "45", "Besch\u00e4ftigt" ], [ "46", "Gegangen" ] ];
Lino.properties.DoYouLike = [ [ "0", "blo\u00df nicht" ], [ "1", "eher nicht" ], [ "2", "normal" ], [ "3", "gerne" ], [ "4", "sehr gerne" ] ];
Lino.cbss.RequestLanguages = [ [ "nl", "Niederl\u00e4ndisch" ], [ "fr", "Franz\u00f6sisch" ], [ "de", "Deutsch" ] ];
Lino.addresses.AddressTypes = [ [ "01", "Offizielle Adresse" ], [ "02", "Ungepr\u00fcfte Adresse" ], [ "03", "Deklarierte Addresse" ], [ "04", "Referenzadresse" ] ];
Lino.aids.AidRegimes = [ [ "10", "Finanzielle Hilfen" ], [ "20", "Gesundheitshilfen" ], [ "30", "Sonstige Hilfen" ] ];
Lino.pcsw.RefusalReasons = [ [ "10", "Information (keine Begleitung erforderlich)" ], [ "20", "\u00d6SHZ ist nicht zust\u00e4ndig" ], [ "30", "Antragsteller ist nicht zur\u00fcck gekommen" ] ];
Lino.users.UserGroups = [ [ "office", "office (B\u00fcro)" ], [ "reception", "reception (Empfang)" ], [ "beid", "beid (Beid)" ], [ "coaching", "coaching (Begleitung)" ], [ "accounts", "accounts (Buchhaltung)" ], [ "courses", "courses (Kurse)" ], [ "integ", "integ (DSBE)" ], [ "newcomers", "newcomers (Neuantr\u00e4ge)" ], [ "cbss", "cbss (ZDSS)" ], [ "debts", "debts (Schuldnerberatung)" ] ];
Lino.cv.SchoolingStates = [ [ "0", "Erfolgreich abgeschlossen" ], [ "1", "Abbruch" ], [ "2", "in Gang" ] ];
Lino.cbss.RequestStates = [ [ "10", "Versendet" ], [ "20", "Fehlgeschlagen" ], [ "25", "Validiert" ], [ "30", "OK" ], [ "40", "Warnungen" ], [ "50", "Fehlermeldungen" ] ];
Lino.lino.ChangeTypes = [ [ "C", "Erstellen" ], [ "U", "Aktualisierung" ], [ "D", "L\u00f6schen" ], [ "R", "Remove child" ], [ "A", "Add child" ], [ "M", "Fusionieren" ] ];
Lino.humanlinks.LinkTypes = [ [ "01", "Sohn (Tochter)" ], [ "02", "Adoptivsohn (Adoptivtochter)" ], [ "03", "Enkel (Enkelin)" ], [ "05", "Ehemann (Ehefrau)" ], [ "06", "Freund (Freundin)" ], [ "07", "Partner (Partnerin)" ], [ "08", "Stiefsohn (Stieftochter)" ], [ "10", "Bruder (Schwester)" ], [ "11", "Vetter (Kusine)" ], [ "12", "Neffe (Nichte)" ], [ "80", "Verwandter (Verwandte)" ], [ "90", "Sonstiger (Sonstige)" ] ];
Lino.cal.AccessClasses = [ [ "10", "Privat" ], [ "20", "halb \u00f6ffentlich (\"Besch\u00e4ftigt\")" ], [ "30", "\u00d6ffentlich" ] ];
Lino.cbss.QueryRegister = [ [ "1", "Prim\u00e4r" ], [ "2", "Sekund\u00e4r" ], [ "3", "Alle" ] ];
Lino.users.UserProfiles = [ [ "000", "000 (Anonym)" ], [ "100", "100 (Begleiter im DSBE)" ], [ "110", "110 (Integrations-Assistent (Manager))" ], [ "200", "200 (Berater Neuantr\u00e4ge)" ], [ "210", "210 (Empfangsschalter)" ], [ "300", "300 (Schuldenberater)" ], [ "400", "400 (Sozi)" ], [ "410", "410 (Social agent (Manager))" ], [ "900", "900 (Verwalter)" ] ];
Lino.system.YesNo = [ [ "y", "Ja" ], [ "n", "Nein" ] ];
Lino.pcsw.ClientEvents = [ [ "10", "Aktiv" ], [ "20", "VSE" ], [ "21", "Art.60\u00a77-Konvention" ], [ "22", "Dispenz" ], [ "30", "AG-Sperre" ], [ "31", "AG-Sperre" ], [ "40", "Notiz" ], [ "50", "Erstellt" ], [ "60", "Bearbeitet" ] ];
Lino.isip.ContractEvents = [ [ "10", "Begonnen" ], [ "20", "Aktiv" ], [ "30", "Beendet" ], [ "40", "Unterschrieben" ] ];
Lino.cbss.ManageAction = [ [ "1", "Registrieren" ], [ "2", "Austragen" ], [ "3", "Auflisten" ] ];
Lino.cv.HowWell = [ [ "0", "gar nicht" ], [ "1", "ein bisschen" ], [ "2", "mittelm\u00e4\u00dfig" ], [ "3", "gut" ], [ "4", "sehr gut" ] ];
Lino.countries.PlaceTypes = [ [ "10", "Bundesland" ], [ "11", "Division" ], [ "12", "Region" ], [ "13", "Gemeinschaft" ], [ "14", "Territorium" ], [ "20", "Regierungsbezirk" ], [ "21", "Provinz" ], [ "22", "Grafschaft" ], [ "23", "Unterregion" ], [ "24", "Departement" ], [ "25", "Arrondissement" ], [ "26", "Pr\u00e4fektur" ], [ "27", "Distrikt" ], [ "28", "Sektor" ], [ "50", "Stadt" ], [ "51", "Kleinstadt" ], [ "52", "Gemeinde" ], [ "54", "Pfarre" ], [ "55", "Stadtteil" ], [ "56", "Viertel" ], [ "61", "Ortschaft" ], [ "62", "Kleine Ortschaft" ], [ "70", "Dorf" ] ];
Lino.pcsw.ResidenceType = [ [ "1", "Bev\u00f6lkerungsregister" ], [ "2", "Fremdenregister" ], [ "3", "Warteregister" ] ];
Lino.aids.ConfirmationStates = [ [ "01", "Unbest\u00e4tigt" ], [ "02", "Best\u00e4tigt" ] ];

Lino.pcsw.Clients.ParamsPanel = Ext.extend(Ext.form.FormPanel,{
  autoScroll: false,
  autoHeight: true,
  border: false,
  hideCheckBoxLabels: true,
  frame: true,
  bodyBorder: false,
  labelAlign: "top",
  layout: 'form',
  autoHeight: true,
  initComponent : function() {
    var aged_from2291 = new Ext.form.NumberField({ "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Alter von</span>", "name": "aged_from", "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Alter von","Nur Klienten, die mindestens so alt sind.") }, "anchor": "-20" });
    var aged_to2292 = new Ext.form.NumberField({ "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Alter bis</span>", "name": "aged_to", "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Alter bis","Nur Klienten, die h\u00f6chstens so alt sind.") }, "anchor": "-20" });
    var gender2293 = new Lino.ChoicesFieldElement({ "autoHeight": true, "forceSelection": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Geschlecht</span>", "name": "gender", "hiddenName": "genderHidden", "listeners": { "render": Lino.quicktip_renderer("Geschlecht","Show only persons with the given gender.") }, "selectOnFocus": true, "anchor": "-20", "store": [['','<br>']].concat(Lino.system.Genders) });
    var nationality2294 = new Lino.TwinCombo({ "autoHeight": true, "fieldLabel": "Staatsangeh\u00f6rigkeit", "name": "nationality", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.countries.Countries.detail,Lino.countries.Countries.insert)}, "emptyText": "Land ausw\u00e4hlen...", "selectOnFocus": true, "hiddenName": "nationalityHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/pcsw/Clients/nationality", "method": "GET" }) }) });
    var also_obsolete2295 = new Ext.form.Checkbox({ "autoHeight": true, "hideLabel": true, "checked": false, "name": "also_obsolete", "listeners": { "render": Lino.quicktip_renderer("Auch veraltete Daten","Show also obsolete records.") }, "boxLabel": "Auch veraltete Daten", "selectOnFocus": true, "anchor": "-20" });
    var main_1_panel2296 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 9, "autoHeight": true, "layout": "form", "xtype": "panel", "items": aged_from2291, "labelAlign": "top" }, { "flex": 9, "autoHeight": true, "layout": "form", "xtype": "panel", "items": aged_to2292, "labelAlign": "top" }, { "flex": 21, "autoHeight": true, "layout": "form", "xtype": "panel", "items": gender2293, "labelAlign": "top" }, { "flex": 39, "autoHeight": true, "layout": "form", "xtype": "panel", "items": nationality2294, "labelAlign": "top" }, { "flex": 19, "autoHeight": true, "layout": "form", "xtype": "panel", "items": also_obsolete2295, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 189, "border": false, "anchor": "-20", "labelAlign": "top" });
    var client_state2302 = new Lino.ChoicesFieldElement({ "autoHeight": true, "forceSelection": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Zustand</span>", "name": "client_state", "hiddenName": "client_stateHidden", "listeners": { "render": Lino.quicktip_renderer("Zustand","Nur Klienten mit diesem Status (Aktenzustand).") }, "selectOnFocus": true, "anchor": "-20", "store": [['','<br>']].concat(Lino.pcsw.ClientStates) });
    var coached_by2303 = new Lino.TwinCombo({ "preferred_width": 15, "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Begleitet durch</span>", "name": "coached_by", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.users.Users.detail,Lino.users.Users.insert)}, "hiddenName": "coached_byHidden", "listeners": { "render": Lino.quicktip_renderer("Begleitet durch","Nur Klienten, die eine Begleitung mit diesem Benutzer haben.") }, "selectOnFocus": true, "emptyText": "Benutzer ausw\u00e4hlen...", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/pcsw/Clients/coached_by", "method": "GET" }) }) });
    var and_coached_by2304 = new Lino.TwinCombo({ "preferred_width": 15, "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">und durch</span>", "name": "and_coached_by", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.users.Users.detail,Lino.users.Users.insert)}, "hiddenName": "and_coached_byHidden", "listeners": { "render": Lino.quicktip_renderer("und durch","Nur Klienten, die auch mit diesem Benutzer eine Begleitung haben.") }, "selectOnFocus": true, "emptyText": "Benutzer ausw\u00e4hlen...", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/pcsw/Clients/and_coached_by", "method": "GET" }) }) });
    var start_date2305 = new Lino.DateField({ "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Periode vom</span>", "name": "start_date", "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Periode vom","Start date of observed period") }, "value": null, "anchor": "-20" });
    var end_date2306 = new Lino.DateField({ "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">bis</span>", "name": "end_date", "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("bis","End date of observed period") }, "value": null, "anchor": "-20" });
    var observed_event2307 = new Lino.ChoicesFieldElement({ "autoHeight": true, "forceSelection": true, "fieldLabel": "Beobachtungskriterium", "name": "observed_event", "hiddenName": "observed_eventHidden", "selectOnFocus": true, "anchor": "-20", "store": [['','<br>']].concat(Lino.pcsw.ClientEvents) });
    var only_primary2308 = new Ext.form.Checkbox({ "autoHeight": true, "hideLabel": true, "checked": false, "name": "only_primary", "listeners": { "render": Lino.quicktip_renderer("Nur prim\u00e4re Begleitungen","Nur Klienten, die eine effektive <b>prim\u00e4re</b> Begleitung haben.") }, "boxLabel": "Nur prim\u00e4re Begleitungen", "selectOnFocus": true, "anchor": "-20" });
    var main_2_panel2309 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 10, "autoHeight": true, "layout": "form", "xtype": "panel", "items": client_state2302, "labelAlign": "top" }, { "flex": 18, "autoHeight": true, "layout": "form", "xtype": "panel", "items": coached_by2303, "labelAlign": "top" }, { "flex": 18, "autoHeight": true, "layout": "form", "xtype": "panel", "items": and_coached_by2304, "labelAlign": "top" }, { "flex": 11, "autoHeight": true, "layout": "form", "xtype": "panel", "items": start_date2305, "labelAlign": "top" }, { "flex": 11, "autoHeight": true, "layout": "form", "xtype": "panel", "items": end_date2306, "labelAlign": "top" }, { "flex": 20, "autoHeight": true, "layout": "form", "xtype": "panel", "items": observed_event2307, "labelAlign": "top" }, { "flex": 9, "autoHeight": true, "layout": "form", "xtype": "panel", "items": only_primary2308, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 225, "border": false, "anchor": "-20", "labelAlign": "top" });
    this.items = [ main_1_panel2296, main_2_panel2309 ];
    this.fields = [ aged_from2291, aged_to2292, gender2293, nationality2294, also_obsolete2295, client_state2302, coached_by2303, and_coached_by2304, start_date2305, end_date2306, observed_event2307, only_primary2308 ];
    Lino.pcsw.Clients.ParamsPanel.superclass.initComponent.call(this);
  }
});


Lino.cal.MyTasks.ParamsPanel = Ext.extend(Ext.form.FormPanel,{
  autoScroll: false,
  border: false,
  hideCheckBoxLabels: true,
  frame: true,
  bodyBorder: false,
  labelAlign: "top",
  layout: 'form',
  autoHeight: true,
  initComponent : function() {
    var start_date640 = new Lino.DateField({ "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Periode vom</span>", "name": "start_date", "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Periode vom","Start date of observed period") }, "value": null, "anchor": "-20" });
    var end_date641 = new Lino.DateField({ "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">bis</span>", "name": "end_date", "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("bis","End date of observed period") }, "value": null, "anchor": "-20" });
    var user642 = new Lino.TwinCombo({ "preferred_width": 15, "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Verwaltet durch</span>", "name": "user", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.users.Users.detail,Lino.users.Users.insert)}, "hiddenName": "userHidden", "listeners": { "render": Lino.quicktip_renderer("Verwaltet durch","Only rows managed by this user.") }, "selectOnFocus": true, "emptyText": "Benutzer ausw\u00e4hlen...", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/Tasks/user", "method": "GET" }) }) });
    var state643 = new Lino.ChoicesFieldElement({ "autoHeight": true, "forceSelection": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Zustand</span>", "name": "state", "hiddenName": "stateHidden", "listeners": { "render": Lino.quicktip_renderer("Zustand","Only rows having this state.") }, "selectOnFocus": true, "anchor": "-20", "store": [['','<br>']].concat(Lino.cal.TaskStates) });
    var project644 = new Lino.TwinCombo({ "preferred_width": 20, "autoHeight": true, "fieldLabel": "Klient", "name": "project", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.pcsw.Clients.detail,Lino.pcsw.Clients.insert)}, "hiddenName": "projectHidden", "selectOnFocus": true, "emptyText": "Klient ausw\u00e4hlen...", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/Tasks/project", "method": "GET" }) }) });
    var main_1_panel645 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 144, "hideCheckBoxLabels": true, "items": [ { "flex": 16, "autoHeight": true, "layout": "form", "xtype": "panel", "items": start_date640, "labelAlign": "top" }, { "flex": 16, "autoHeight": true, "layout": "form", "xtype": "panel", "items": end_date641, "labelAlign": "top" }, { "flex": 25, "autoHeight": true, "layout": "form", "xtype": "panel", "items": user642, "labelAlign": "top" }, { "flex": 15, "autoHeight": true, "layout": "form", "xtype": "panel", "items": state643, "labelAlign": "top" }, { "flex": 25, "autoHeight": true, "layout": "form", "xtype": "panel", "items": project644, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    this.items = [ main_1_panel645 ];
    this.fields = [ start_date640, end_date641, user642, state643, project644 ];
    Lino.cal.MyTasks.ParamsPanel.superclass.initComponent.call(this);
  }
});


Lino.cal.MyPresences.ParamsPanel = Ext.extend(Ext.form.FormPanel,{
  autoScroll: false,
  autoHeight: true,
  border: false,
  hideCheckBoxLabels: true,
  frame: true,
  bodyBorder: false,
  labelAlign: "top",
  layout: 'form',
  autoHeight: true,
  initComponent : function() {
    var start_date335 = new Lino.DateField({ "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Periode vom</span>", "name": "start_date", "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Periode vom","Start date of observed period") }, "value": null, "anchor": "-20" });
    var end_date336 = new Lino.DateField({ "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">bis</span>", "name": "end_date", "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("bis","End date of observed period") }, "value": null, "anchor": "-20" });
    var user337 = new Lino.TwinCombo({ "preferred_width": 15, "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Verantwortlicher</span>", "name": "user", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.users.Users.detail,Lino.users.Users.insert)}, "hiddenName": "userHidden", "listeners": { "render": Lino.quicktip_renderer("Verantwortlicher","Only rows managed by this user.") }, "selectOnFocus": true, "emptyText": "Benutzer ausw\u00e4hlen...", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/Guests/user", "method": "GET" }) }) });
    var event_state338 = new Lino.ChoicesFieldElement({ "autoHeight": true, "forceSelection": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Zustand Termin</span>", "name": "event_state", "hiddenName": "event_stateHidden", "listeners": { "render": Lino.quicktip_renderer("Zustand Termin","Only rows having this event state.") }, "selectOnFocus": true, "anchor": "-20", "store": [['','<br>']].concat(Lino.cal.EventStates) });
    var guest_state339 = new Lino.ChoicesFieldElement({ "autoHeight": true, "forceSelection": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Zustand Gast</span>", "name": "guest_state", "hiddenName": "guest_stateHidden", "listeners": { "render": Lino.quicktip_renderer("Zustand Gast","Only rows having this guest state.") }, "selectOnFocus": true, "anchor": "-20", "store": [['','<br>']].concat(Lino.cal.GuestStates) });
    var main_1_panel340 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 16, "autoHeight": true, "layout": "form", "xtype": "panel", "items": start_date335, "labelAlign": "top" }, { "flex": 16, "autoHeight": true, "layout": "form", "xtype": "panel", "items": end_date336, "labelAlign": "top" }, { "flex": 25, "autoHeight": true, "layout": "form", "xtype": "panel", "items": user337, "labelAlign": "top" }, { "flex": 21, "autoHeight": true, "layout": "form", "xtype": "panel", "items": event_state338, "labelAlign": "top" }, { "flex": 19, "autoHeight": true, "layout": "form", "xtype": "panel", "items": guest_state339, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 153, "border": false, "anchor": "-20", "labelAlign": "top" });
    var project346 = new Lino.TwinCombo({ "preferred_width": 20, "autoHeight": true, "fieldLabel": "Klient", "name": "project", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.pcsw.Clients.detail,Lino.pcsw.Clients.insert)}, "hiddenName": "projectHidden", "selectOnFocus": true, "emptyText": "Klient ausw\u00e4hlen...", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/Guests/project", "method": "GET" }) }) });
    var partner347 = new Lino.TwinCombo({ "preferred_width": 20, "autoHeight": true, "fieldLabel": "Partner", "name": "partner", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.contacts.Partners.detail,Lino.contacts.Partners.insert)}, "hiddenName": "partnerHidden", "selectOnFocus": true, "emptyText": "Partner ausw\u00e4hlen...", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/Guests/partner", "method": "GET" }) }) });
    var main_2_panel348 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": project346, "labelAlign": "top" }, { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": partner347, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 72, "border": false, "anchor": "-20", "labelAlign": "top" });
    this.items = [ main_1_panel340, main_2_panel348 ];
    this.fields = [ start_date335, end_date336, user337, event_state338, guest_state339, project346, partner347 ];
    Lino.cal.MyPresences.ParamsPanel.superclass.initComponent.call(this);
  }
});


Lino.excerpts.ExcerptsByX.ParamsPanel = Ext.extend(Ext.form.FormPanel,{
  autoScroll: false,
  autoHeight: true,
  border: false,
  hideCheckBoxLabels: true,
  frame: true,
  bodyBorder: false,
  labelAlign: "top",
  layout: 'form',
  autoHeight: true,
  initComponent : function() {
    var start_date2376 = new Lino.DateField({ "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Periode vom</span>", "name": "start_date", "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Periode vom","Start date of observed period") }, "value": null, "anchor": "-20" });
    var end_date2377 = new Lino.DateField({ "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">bis</span>", "name": "end_date", "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("bis","End date of observed period") }, "value": null, "anchor": "-20" });
    var pcertifying2378 = new Lino.ChoicesFieldElement({ "autoHeight": true, "forceSelection": true, "fieldLabel": "Certifying excerpts", "name": "pcertifying", "hiddenName": "pcertifyingHidden", "selectOnFocus": true, "anchor": "-20", "store": [['','<br>']].concat(Lino.system.YesNo) });
    var main_1_panel2379 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 39, "autoHeight": true, "layout": "form", "xtype": "panel", "items": start_date2376, "labelAlign": "top" }, { "flex": 39, "autoHeight": true, "layout": "form", "xtype": "panel", "items": end_date2377, "labelAlign": "top" }, { "flex": 21, "autoHeight": true, "layout": "form", "xtype": "panel", "items": pcertifying2378, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 180, "border": false, "anchor": "-20", "labelAlign": "top" });
    var puser2383 = new Lino.TwinCombo({ "preferred_width": 15, "autoHeight": true, "fieldLabel": "Benutzer", "name": "puser", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.users.Users.detail,Lino.users.Users.insert)}, "hiddenName": "puserHidden", "selectOnFocus": true, "emptyText": "Benutzer ausw\u00e4hlen...", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/excerpts/Excerpts/puser", "method": "GET" }) }) });
    var pexcerpt_type2384 = new Lino.TwinCombo({ "autoHeight": true, "fieldLabel": "Auszugsart", "name": "pexcerpt_type", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.excerpts.ExcerptTypes.detail,Lino.excerpts.ExcerptTypes.insert)}, "emptyText": "Auszugsart ausw\u00e4hlen...", "selectOnFocus": true, "hiddenName": "pexcerpt_typeHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/excerpts/Excerpts/pexcerpt_type", "method": "GET" }) }) });
    var main_2_panel2385 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": puser2383, "labelAlign": "top" }, { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": pexcerpt_type2384, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 99, "border": false, "anchor": "-20", "labelAlign": "top" });
    this.items = [ main_1_panel2379, main_2_panel2385 ];
    this.fields = [ start_date2376, end_date2377, pcertifying2378, puser2383, pexcerpt_type2384 ];
    Lino.excerpts.ExcerptsByX.ParamsPanel.superclass.initComponent.call(this);
  }
});


Lino.aids.GrantingsByX.ParamsPanel = Ext.extend(Ext.form.FormPanel,{
  autoHeight: true,
  frame: true,
  layoutConfig: { "align": "stretchmax" },
  hideCheckBoxLabels: true,
  autoScroll: false,
  labelWidth: 135,
  border: false,
  bodyBorder: false,
  labelAlign: "top",
  layout: 'hbox',
  autoHeight: true,
  initComponent : function() {
    var board162 = new Lino.TwinCombo({ "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Gremium</span>", "name": "board", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.boards.Boards.detail,Lino.boards.Boards.insert)}, "emptyText": "Gremium ausw\u00e4hlen...", "listeners": { "render": Lino.quicktip_renderer("Gremium","Only rows decided by this board.") }, "selectOnFocus": true, "hiddenName": "boardHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/aids/Grantings/board", "method": "GET" }) }) });
    var aid_type163 = new Lino.TwinCombo({ "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Hilfeart</span>", "name": "aid_type", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.aids.AidTypes.detail,Lino.aids.AidTypes.insert)}, "emptyText": "Hilfeart ausw\u00e4hlen...", "listeners": { "render": Lino.quicktip_renderer("Hilfeart","Only confirmations about this aid type.") }, "selectOnFocus": true, "hiddenName": "aid_typeHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/aids/Grantings/aid_type", "method": "GET" }) }) });
    var user164 = new Lino.TwinCombo({ "preferred_width": 15, "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Autor</span>", "name": "user", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.users.Users.detail,Lino.users.Users.insert)}, "hiddenName": "userHidden", "listeners": { "render": Lino.quicktip_renderer("Autor","Only rows created by this user.") }, "selectOnFocus": true, "emptyText": "Benutzer ausw\u00e4hlen...", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/aids/Grantings/user", "method": "GET" }) }) });
    var signer165 = new Lino.TwinCombo({ "preferred_width": 15, "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Unterschreiber</span>", "name": "signer", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.users.Users.detail,Lino.users.Users.insert)}, "hiddenName": "signerHidden", "listeners": { "render": Lino.quicktip_renderer("Unterschreiber","Only rows confirmed (or to be confirmed) by this user.") }, "selectOnFocus": true, "emptyText": "Benutzer ausw\u00e4hlen...", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/aids/Grantings/signer", "method": "GET" }) }) });
    var state166 = new Lino.ChoicesFieldElement({ "autoHeight": true, "forceSelection": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Zustand</span>", "name": "state", "hiddenName": "stateHidden", "listeners": { "render": Lino.quicktip_renderer("Zustand","Only rows having this state.") }, "selectOnFocus": true, "anchor": "-20", "store": [['','<br>']].concat(Lino.aids.ConfirmationStates) });
    this.items = [ { "flex": 21, "autoHeight": true, "layout": "form", "xtype": "panel", "items": board162, "labelAlign": "top" }, { "flex": 21, "autoHeight": true, "layout": "form", "xtype": "panel", "items": aid_type163, "labelAlign": "top" }, { "flex": 21, "autoHeight": true, "layout": "form", "xtype": "panel", "items": user164, "labelAlign": "top" }, { "flex": 21, "autoHeight": true, "layout": "form", "xtype": "panel", "items": signer165, "labelAlign": "top" }, { "flex": 14, "autoHeight": true, "layout": "form", "xtype": "panel", "items": state166, "labelAlign": "top" } ];
    this.fields = [ board162, aid_type163, user164, signer165, state166 ];
    Lino.aids.GrantingsByX.ParamsPanel.superclass.initComponent.call(this);
  }
});


Lino.aids.RefundConfirmations.ParamsPanel = Ext.extend(Ext.form.FormPanel,{
  autoHeight: true,
  frame: true,
  layoutConfig: { "align": "stretchmax" },
  hideCheckBoxLabels: true,
  autoScroll: false,
  labelWidth: 135,
  border: false,
  bodyBorder: false,
  labelAlign: "top",
  layout: 'hbox',
  autoHeight: true,
  initComponent : function() {
    var board2508 = new Lino.TwinCombo({ "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Gremium</span>", "name": "board", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.boards.Boards.detail,Lino.boards.Boards.insert)}, "emptyText": "Gremium ausw\u00e4hlen...", "listeners": { "render": Lino.quicktip_renderer("Gremium","Only rows decided by this board.") }, "selectOnFocus": true, "hiddenName": "boardHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/aids/RefundConfirmations/board", "method": "GET" }) }) });
    var signer2509 = new Lino.TwinCombo({ "preferred_width": 15, "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Unterschreiber</span>", "name": "signer", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.users.Users.detail,Lino.users.Users.insert)}, "hiddenName": "signerHidden", "listeners": { "render": Lino.quicktip_renderer("Unterschreiber","Only rows confirmed (or to be confirmed) by this user.") }, "selectOnFocus": true, "emptyText": "Benutzer ausw\u00e4hlen...", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/aids/RefundConfirmations/signer", "method": "GET" }) }) });
    var user2510 = new Lino.TwinCombo({ "preferred_width": 15, "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Autor</span>", "name": "user", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.users.Users.detail,Lino.users.Users.insert)}, "hiddenName": "userHidden", "listeners": { "render": Lino.quicktip_renderer("Autor","Only rows created by this user.") }, "selectOnFocus": true, "emptyText": "Benutzer ausw\u00e4hlen...", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/aids/RefundConfirmations/user", "method": "GET" }) }) });
    var aid_type2511 = new Lino.TwinCombo({ "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Hilfeart</span>", "name": "aid_type", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.aids.AidTypes.detail,Lino.aids.AidTypes.insert)}, "emptyText": "Hilfeart ausw\u00e4hlen...", "listeners": { "render": Lino.quicktip_renderer("Hilfeart","Only confirmations about this aid type.") }, "selectOnFocus": true, "hiddenName": "aid_typeHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/aids/RefundConfirmations/aid_type", "method": "GET" }) }) });
    var state2512 = new Lino.ChoicesFieldElement({ "autoHeight": true, "forceSelection": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Zustand</span>", "name": "state", "hiddenName": "stateHidden", "listeners": { "render": Lino.quicktip_renderer("Zustand","Only rows having this state.") }, "selectOnFocus": true, "anchor": "-20", "store": [['','<br>']].concat(Lino.aids.ConfirmationStates) });
    this.items = [ { "flex": 21, "autoHeight": true, "layout": "form", "xtype": "panel", "items": board2508, "labelAlign": "top" }, { "flex": 21, "autoHeight": true, "layout": "form", "xtype": "panel", "items": signer2509, "labelAlign": "top" }, { "flex": 21, "autoHeight": true, "layout": "form", "xtype": "panel", "items": user2510, "labelAlign": "top" }, { "flex": 21, "autoHeight": true, "layout": "form", "xtype": "panel", "items": aid_type2511, "labelAlign": "top" }, { "flex": 14, "autoHeight": true, "layout": "form", "xtype": "panel", "items": state2512, "labelAlign": "top" } ];
    this.fields = [ board2508, signer2509, user2510, aid_type2511, state2512 ];
    Lino.aids.RefundConfirmations.ParamsPanel.superclass.initComponent.call(this);
  }
});


Lino.contacts.Persons.ParamsPanel = Ext.extend(Ext.form.FormPanel,{
  autoScroll: false,
  border: false,
  hideCheckBoxLabels: true,
  frame: true,
  bodyBorder: false,
  labelAlign: "top",
  layout: 'form',
  autoHeight: true,
  initComponent : function() {
    var gender1255 = new Lino.ChoicesFieldElement({ "autoHeight": true, "forceSelection": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Geschlecht</span>", "name": "gender", "hiddenName": "genderHidden", "listeners": { "render": Lino.quicktip_renderer("Geschlecht","Show only persons with the given gender.") }, "selectOnFocus": true, "anchor": "-20", "store": [['','<br>']].concat(Lino.system.Genders) });
    var also_obsolete1256 = new Ext.form.Checkbox({ "autoHeight": true, "hideLabel": true, "checked": false, "name": "also_obsolete", "listeners": { "render": Lino.quicktip_renderer("Auch veraltete Daten","Show also obsolete records.") }, "boxLabel": "Auch veraltete Daten", "selectOnFocus": true, "anchor": "-20" });
    var main_1_panel1257 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 189, "hideCheckBoxLabels": true, "items": [ { "flex": 52, "autoHeight": true, "layout": "form", "xtype": "panel", "items": gender1255, "labelAlign": "top" }, { "flex": 47, "autoHeight": true, "layout": "form", "xtype": "panel", "items": also_obsolete1256, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    this.items = [ main_1_panel1257 ];
    this.fields = [ gender1255, also_obsolete1256 ];
    Lino.contacts.Persons.ParamsPanel.superclass.initComponent.call(this);
  }
});


Lino.cal.EventsByDay.ParamsPanel = Ext.extend(Ext.form.FormPanel,{
  autoScroll: false,
  autoHeight: true,
  border: false,
  hideCheckBoxLabels: true,
  frame: true,
  bodyBorder: false,
  labelAlign: "top",
  layout: 'form',
  autoHeight: true,
  initComponent : function() {
    var start_date271 = new Lino.DateField({ "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Periode vom</span>", "name": "start_date", "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Periode vom","Start date of observed period") }, "value": null, "anchor": "-20" });
    var end_date272 = new Lino.DateField({ "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">bis</span>", "name": "end_date", "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("bis","End date of observed period") }, "value": null, "anchor": "-20" });
    var observed_event273 = new Lino.ChoicesFieldElement({ "autoHeight": true, "forceSelection": true, "fieldLabel": "Beobachtungskriterium", "name": "observed_event", "hiddenName": "observed_eventHidden", "selectOnFocus": true, "anchor": "-20", "store": [['','<br>']].concat(Lino.cal.EventEvents) });
    var state274 = new Lino.ChoicesFieldElement({ "autoHeight": true, "forceSelection": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Zustand</span>", "name": "state", "hiddenName": "stateHidden", "listeners": { "render": Lino.quicktip_renderer("Zustand","Only rows having this state.") }, "selectOnFocus": true, "anchor": "-20", "store": [['','<br>']].concat(Lino.cal.EventStates) });
    var main_1_panel275 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 24, "autoHeight": true, "layout": "form", "xtype": "panel", "items": start_date271, "labelAlign": "top" }, { "flex": 24, "autoHeight": true, "layout": "form", "xtype": "panel", "items": end_date272, "labelAlign": "top" }, { "flex": 18, "autoHeight": true, "layout": "form", "xtype": "panel", "items": observed_event273, "labelAlign": "top" }, { "flex": 32, "autoHeight": true, "layout": "form", "xtype": "panel", "items": state274, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 198, "border": false, "anchor": "-20", "labelAlign": "top" });
    var user280 = new Lino.TwinCombo({ "preferred_width": 15, "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Verwaltet durch</span>", "name": "user", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.users.Users.detail,Lino.users.Users.insert)}, "hiddenName": "userHidden", "listeners": { "render": Lino.quicktip_renderer("Verwaltet durch","Only rows managed by this user.") }, "selectOnFocus": true, "emptyText": "Benutzer ausw\u00e4hlen...", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/Events/user", "method": "GET" }) }) });
    var assigned_to281 = new Lino.TwinCombo({ "preferred_width": 15, "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Zugewiesen zu</span>", "name": "assigned_to", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.users.Users.detail,Lino.users.Users.insert)}, "hiddenName": "assigned_toHidden", "listeners": { "render": Lino.quicktip_renderer("Zugewiesen zu","Only events assigned to this user.") }, "selectOnFocus": true, "emptyText": "Benutzer ausw\u00e4hlen...", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/Events/assigned_to", "method": "GET" }) }) });
    var project282 = new Lino.TwinCombo({ "preferred_width": 20, "autoHeight": true, "fieldLabel": "Klient", "name": "project", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.pcsw.Clients.detail,Lino.pcsw.Clients.insert)}, "hiddenName": "projectHidden", "selectOnFocus": true, "emptyText": "Klient ausw\u00e4hlen...", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/Events/project", "method": "GET" }) }) });
    var event_type283 = new Lino.TwinCombo({ "autoHeight": true, "fieldLabel": "Ereignisart", "name": "event_type", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.cal.EventTypes.detail,Lino.cal.EventTypes.insert)}, "emptyText": "Ereignisart ausw\u00e4hlen...", "selectOnFocus": true, "hiddenName": "event_typeHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/Events/event_type", "method": "GET" }) }) });
    var room284 = new Lino.TwinCombo({ "autoHeight": true, "fieldLabel": "Raum", "name": "room", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.cal.Rooms.detail,Lino.cal.Rooms.insert)}, "emptyText": "Raum ausw\u00e4hlen...", "selectOnFocus": true, "hiddenName": "roomHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/Events/room", "method": "GET" }) }) });
    var show_appointments285 = new Lino.ChoicesFieldElement({ "autoHeight": true, "forceSelection": true, "fieldLabel": "Termine", "name": "show_appointments", "hiddenName": "show_appointmentsHidden", "selectOnFocus": true, "anchor": "-20", "store": [['','<br>']].concat(Lino.system.YesNo) });
    var main_2_panel286 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 18, "autoHeight": true, "layout": "form", "xtype": "panel", "items": user280, "labelAlign": "top" }, { "flex": 18, "autoHeight": true, "layout": "form", "xtype": "panel", "items": assigned_to281, "labelAlign": "top" }, { "flex": 18, "autoHeight": true, "layout": "form", "xtype": "panel", "items": project282, "labelAlign": "top" }, { "flex": 18, "autoHeight": true, "layout": "form", "xtype": "panel", "items": event_type283, "labelAlign": "top" }, { "flex": 18, "autoHeight": true, "layout": "form", "xtype": "panel", "items": room284, "labelAlign": "top" }, { "flex": 6, "autoHeight": true, "layout": "form", "xtype": "panel", "items": show_appointments285, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 144, "border": false, "anchor": "-20", "labelAlign": "top" });
    this.items = [ main_1_panel275, main_2_panel286 ];
    this.fields = [ start_date271, end_date272, observed_event273, state274, user280, assigned_to281, project282, event_type283, room284, show_appointments285 ];
    Lino.cal.EventsByDay.ParamsPanel.superclass.initComponent.call(this);
  }
});


Lino.aids.SimpleConfirmations.ParamsPanel = Ext.extend(Ext.form.FormPanel,{
  autoHeight: true,
  frame: true,
  layoutConfig: { "align": "stretchmax" },
  hideCheckBoxLabels: true,
  autoScroll: false,
  labelWidth: 135,
  border: false,
  bodyBorder: false,
  labelAlign: "top",
  layout: 'hbox',
  autoHeight: true,
  initComponent : function() {
    var board2463 = new Lino.TwinCombo({ "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Gremium</span>", "name": "board", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.boards.Boards.detail,Lino.boards.Boards.insert)}, "emptyText": "Gremium ausw\u00e4hlen...", "listeners": { "render": Lino.quicktip_renderer("Gremium","Only rows decided by this board.") }, "selectOnFocus": true, "hiddenName": "boardHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/aids/SimpleConfirmations/board", "method": "GET" }) }) });
    var signer2464 = new Lino.TwinCombo({ "preferred_width": 15, "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Unterschreiber</span>", "name": "signer", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.users.Users.detail,Lino.users.Users.insert)}, "hiddenName": "signerHidden", "listeners": { "render": Lino.quicktip_renderer("Unterschreiber","Only rows confirmed (or to be confirmed) by this user.") }, "selectOnFocus": true, "emptyText": "Benutzer ausw\u00e4hlen...", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/aids/SimpleConfirmations/signer", "method": "GET" }) }) });
    var user2465 = new Lino.TwinCombo({ "preferred_width": 15, "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Autor</span>", "name": "user", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.users.Users.detail,Lino.users.Users.insert)}, "hiddenName": "userHidden", "listeners": { "render": Lino.quicktip_renderer("Autor","Only rows created by this user.") }, "selectOnFocus": true, "emptyText": "Benutzer ausw\u00e4hlen...", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/aids/SimpleConfirmations/user", "method": "GET" }) }) });
    var aid_type2466 = new Lino.TwinCombo({ "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Hilfeart</span>", "name": "aid_type", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.aids.AidTypes.detail,Lino.aids.AidTypes.insert)}, "emptyText": "Hilfeart ausw\u00e4hlen...", "listeners": { "render": Lino.quicktip_renderer("Hilfeart","Only confirmations about this aid type.") }, "selectOnFocus": true, "hiddenName": "aid_typeHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/aids/SimpleConfirmations/aid_type", "method": "GET" }) }) });
    var state2467 = new Lino.ChoicesFieldElement({ "autoHeight": true, "forceSelection": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Zustand</span>", "name": "state", "hiddenName": "stateHidden", "listeners": { "render": Lino.quicktip_renderer("Zustand","Only rows having this state.") }, "selectOnFocus": true, "anchor": "-20", "store": [['','<br>']].concat(Lino.aids.ConfirmationStates) });
    this.items = [ { "flex": 21, "autoHeight": true, "layout": "form", "xtype": "panel", "items": board2463, "labelAlign": "top" }, { "flex": 21, "autoHeight": true, "layout": "form", "xtype": "panel", "items": signer2464, "labelAlign": "top" }, { "flex": 21, "autoHeight": true, "layout": "form", "xtype": "panel", "items": user2465, "labelAlign": "top" }, { "flex": 21, "autoHeight": true, "layout": "form", "xtype": "panel", "items": aid_type2466, "labelAlign": "top" }, { "flex": 14, "autoHeight": true, "layout": "form", "xtype": "panel", "items": state2467, "labelAlign": "top" } ];
    this.fields = [ board2463, signer2464, user2465, aid_type2466, state2467 ];
    Lino.aids.SimpleConfirmations.ParamsPanel.superclass.initComponent.call(this);
  }
});


Lino.aids.IncomeConfirmations.ParamsPanel = Ext.extend(Ext.form.FormPanel,{
  autoHeight: true,
  frame: true,
  layoutConfig: { "align": "stretchmax" },
  hideCheckBoxLabels: true,
  autoScroll: false,
  labelWidth: 135,
  border: false,
  bodyBorder: false,
  labelAlign: "top",
  layout: 'hbox',
  autoHeight: true,
  initComponent : function() {
    var board511 = new Lino.TwinCombo({ "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Gremium</span>", "name": "board", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.boards.Boards.detail,Lino.boards.Boards.insert)}, "emptyText": "Gremium ausw\u00e4hlen...", "listeners": { "render": Lino.quicktip_renderer("Gremium","Only rows decided by this board.") }, "selectOnFocus": true, "hiddenName": "boardHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/aids/IncomeConfirmations/board", "method": "GET" }) }) });
    var signer512 = new Lino.TwinCombo({ "preferred_width": 15, "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Unterschreiber</span>", "name": "signer", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.users.Users.detail,Lino.users.Users.insert)}, "hiddenName": "signerHidden", "listeners": { "render": Lino.quicktip_renderer("Unterschreiber","Only rows confirmed (or to be confirmed) by this user.") }, "selectOnFocus": true, "emptyText": "Benutzer ausw\u00e4hlen...", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/aids/IncomeConfirmations/signer", "method": "GET" }) }) });
    var user513 = new Lino.TwinCombo({ "preferred_width": 15, "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Autor</span>", "name": "user", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.users.Users.detail,Lino.users.Users.insert)}, "hiddenName": "userHidden", "listeners": { "render": Lino.quicktip_renderer("Autor","Only rows created by this user.") }, "selectOnFocus": true, "emptyText": "Benutzer ausw\u00e4hlen...", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/aids/IncomeConfirmations/user", "method": "GET" }) }) });
    var aid_type514 = new Lino.TwinCombo({ "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Hilfeart</span>", "name": "aid_type", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.aids.AidTypes.detail,Lino.aids.AidTypes.insert)}, "emptyText": "Hilfeart ausw\u00e4hlen...", "listeners": { "render": Lino.quicktip_renderer("Hilfeart","Only confirmations about this aid type.") }, "selectOnFocus": true, "hiddenName": "aid_typeHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/aids/IncomeConfirmations/aid_type", "method": "GET" }) }) });
    var state515 = new Lino.ChoicesFieldElement({ "autoHeight": true, "forceSelection": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Zustand</span>", "name": "state", "hiddenName": "stateHidden", "listeners": { "render": Lino.quicktip_renderer("Zustand","Only rows having this state.") }, "selectOnFocus": true, "anchor": "-20", "store": [['','<br>']].concat(Lino.aids.ConfirmationStates) });
    this.items = [ { "flex": 21, "autoHeight": true, "layout": "form", "xtype": "panel", "items": board511, "labelAlign": "top" }, { "flex": 21, "autoHeight": true, "layout": "form", "xtype": "panel", "items": signer512, "labelAlign": "top" }, { "flex": 21, "autoHeight": true, "layout": "form", "xtype": "panel", "items": user513, "labelAlign": "top" }, { "flex": 21, "autoHeight": true, "layout": "form", "xtype": "panel", "items": aid_type514, "labelAlign": "top" }, { "flex": 14, "autoHeight": true, "layout": "form", "xtype": "panel", "items": state515, "labelAlign": "top" } ];
    this.fields = [ board511, signer512, user513, aid_type514, state515 ];
    Lino.aids.IncomeConfirmations.ParamsPanel.superclass.initComponent.call(this);
  }
});


Lino.pcsw.CoachingsByClient.ParamsPanel = Ext.extend(Ext.form.FormPanel,{
  autoScroll: false,
  autoHeight: true,
  border: false,
  hideCheckBoxLabels: true,
  frame: true,
  bodyBorder: false,
  labelAlign: "top",
  layout: 'form',
  autoHeight: true,
  initComponent : function() {
    var start_date710 = new Lino.DateField({ "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Periode vom</span>", "name": "start_date", "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Periode vom","Start date of observed period") }, "value": null, "anchor": "-20" });
    var end_date711 = new Lino.DateField({ "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">bis</span>", "name": "end_date", "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("bis","End date of observed period") }, "value": null, "anchor": "-20" });
    var observed_event712 = new Lino.ChoicesFieldElement({ "autoHeight": true, "forceSelection": true, "fieldLabel": "Beobachtungskriterium", "name": "observed_event", "hiddenName": "observed_eventHidden", "selectOnFocus": true, "anchor": "-20", "store": [['','<br>']].concat(Lino.system.PeriodEvents) });
    var coached_by713 = new Lino.TwinCombo({ "preferred_width": 15, "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Begleitet durch</span>", "name": "coached_by", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.users.Users.detail,Lino.users.Users.insert)}, "hiddenName": "coached_byHidden", "listeners": { "render": Lino.quicktip_renderer("Begleitet durch","Nur Begleitungen dieses Benutzers.") }, "selectOnFocus": true, "emptyText": "Benutzer ausw\u00e4hlen...", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/pcsw/Coachings/coached_by", "method": "GET" }) }) });
    var and_coached_by714 = new Lino.TwinCombo({ "preferred_width": 15, "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">und durch</span>", "name": "and_coached_by", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.users.Users.detail,Lino.users.Users.insert)}, "hiddenName": "and_coached_byHidden", "listeners": { "render": Lino.quicktip_renderer("und durch","... und auch Begleitungen dieses Benutzers.") }, "selectOnFocus": true, "emptyText": "Benutzer ausw\u00e4hlen...", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/pcsw/Coachings/and_coached_by", "method": "GET" }) }) });
    var main_1_panel715 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 16, "autoHeight": true, "layout": "form", "xtype": "panel", "items": start_date710, "labelAlign": "top" }, { "flex": 16, "autoHeight": true, "layout": "form", "xtype": "panel", "items": end_date711, "labelAlign": "top" }, { "flex": 14, "autoHeight": true, "layout": "form", "xtype": "panel", "items": observed_event712, "labelAlign": "top" }, { "flex": 25, "autoHeight": true, "layout": "form", "xtype": "panel", "items": coached_by713, "labelAlign": "top" }, { "flex": 25, "autoHeight": true, "layout": "form", "xtype": "panel", "items": and_coached_by714, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 198, "border": false, "anchor": "-20", "labelAlign": "top" });
    var primary_coachings721 = new Lino.ChoicesFieldElement({ "autoHeight": true, "forceSelection": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Prim\u00e4re Begleitungen</span>", "name": "primary_coachings", "hiddenName": "primary_coachingsHidden", "listeners": { "render": Lino.quicktip_renderer("Prim\u00e4re Begleitungen","Accompagnements primaires.") }, "selectOnFocus": true, "anchor": "-20", "store": [['','<br>']].concat(Lino.system.YesNo) });
    var coaching_type722 = new Lino.RemoteComboFieldElement({ "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Dienst</span>", "name": "coaching_type", "pageSize": 20, "emptyText": "Dienst ausw\u00e4hlen...", "listeners": { "render": Lino.quicktip_renderer("Dienst","Nur Begleitungen dieses Dienstes.") }, "selectOnFocus": true, "hiddenName": "coaching_typeHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/pcsw/Coachings/coaching_type", "method": "GET" }) }) });
    var ending723 = new Lino.TwinCombo({ "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Beendigungsgrund</span>", "name": "ending", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.pcsw.CoachingEndings.detail,Lino.pcsw.CoachingEndings.insert)}, "emptyText": "Beendigungsgrund ausw\u00e4hlen...", "listeners": { "render": Lino.quicktip_renderer("Beendigungsgrund","Nur Begleitungen mit diesem Beendigungsgrund.") }, "selectOnFocus": true, "hiddenName": "endingHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/pcsw/Coachings/ending", "method": "GET" }) }) });
    var main_2_panel724 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 14, "autoHeight": true, "layout": "form", "xtype": "panel", "items": primary_coachings721, "labelAlign": "top" }, { "flex": 42, "autoHeight": true, "layout": "form", "xtype": "panel", "items": coaching_type722, "labelAlign": "top" }, { "flex": 42, "autoHeight": true, "layout": "form", "xtype": "panel", "items": ending723, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 189, "border": false, "anchor": "-20", "labelAlign": "top" });
    this.items = [ main_1_panel715, main_2_panel724 ];
    this.fields = [ start_date710, end_date711, observed_event712, coached_by713, and_coached_by714, primary_coachings721, coaching_type722, ending723 ];
    Lino.pcsw.CoachingsByClient.ParamsPanel.superclass.initComponent.call(this);
  }
});


Lino.changes.ChangesByObject.ParamsPanel = Ext.extend(Ext.form.FormPanel,{
  autoScroll: false,
  border: false,
  hideCheckBoxLabels: true,
  frame: true,
  bodyBorder: false,
  labelAlign: "top",
  layout: 'form',
  autoHeight: true,
  initComponent : function() {
    var date930 = new Lino.DateField({ "selectOnFocus": true, "autoHeight": true, "fieldLabel": "Only changes from", "anchor": "-20", "name": "date" });
    var user931 = new Lino.TwinCombo({ "preferred_width": 15, "autoHeight": true, "fieldLabel": "Benutzer", "name": "user", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.users.Users.detail,Lino.users.Users.insert)}, "hiddenName": "userHidden", "selectOnFocus": true, "emptyText": "Benutzer ausw\u00e4hlen...", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/changes/Changes/user", "method": "GET" }) }) });
    var change_type932 = new Lino.ChoicesFieldElement({ "autoHeight": true, "forceSelection": false, "fieldLabel": "\u00c4nderungsart", "name": "change_type", "hiddenName": "change_typeHidden", "selectOnFocus": true, "anchor": "-20", "store": [['','<br>']].concat(Lino.lino.ChangeTypes) });
    var object_type933 = new Lino.TwinCombo({ "autoHeight": true, "fieldLabel": "Object type", "name": "object_type", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.contenttypes.ContentTypes.detail,Lino.contenttypes.ContentTypes.insert)}, "emptyText": "Datenbankmodell ausw\u00e4hlen...", "selectOnFocus": true, "hiddenName": "object_typeHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/changes/Changes/object_type", "method": "GET" }) }) });
    var object_id934 = new Lino.RemoteComboFieldElement({ "autoHeight": true, "fieldLabel": "Object ID", "name": "object_id", "selectOnFocus": true, "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/changes/Changes/object_id", "method": "GET" }) }), "hiddenName": "object_idHidden" });
    var main_1_panel935 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 162, "hideCheckBoxLabels": true, "items": [ { "flex": 16, "autoHeight": true, "layout": "form", "xtype": "panel", "items": date930, "labelAlign": "top" }, { "flex": 25, "autoHeight": true, "layout": "form", "xtype": "panel", "items": user931, "labelAlign": "top" }, { "flex": 21, "autoHeight": true, "layout": "form", "xtype": "panel", "items": change_type932, "labelAlign": "top" }, { "flex": 25, "autoHeight": true, "layout": "form", "xtype": "panel", "items": object_type933, "labelAlign": "top" }, { "flex": 12, "autoHeight": true, "layout": "form", "xtype": "panel", "items": object_id934, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    this.items = [ main_1_panel935 ];
    this.fields = [ date930, user931, change_type932, object_type933, object_id934 ];
    Lino.changes.ChangesByObject.ParamsPanel.superclass.initComponent.call(this);
  }
});


Lino.pcsw.CoachingsByClient.create_visit_ActionFormPanel = Ext.extend(Lino.ActionFormPanel,{
  autoScroll: false,
  autoHeight: true,
  border: false,
  layout: "form",
  labelWidth: 99,
  hideCheckBoxLabels: true,
  frame: true,
  bodyBorder: false,
  labelAlign: "top",
  action_name: 'create_visit',
  ls_url: "/pcsw/CoachingsByClient",
  window_title: "Visite erstellen",
  before_row_edit : function(record) {
  },
  autoHeight: true,
  initComponent : function() {
    this.user41 = new Lino.TwinCombo({ "preferred_width": 15, "autoHeight": true, "fieldLabel": "Benutzer", "allowBlank": false, "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.users.Users.detail,Lino.users.Users.insert)}, "emptyText": "Benutzer ausw\u00e4hlen...", "selectOnFocus": true, "hiddenName": "userHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/apchoices/pcsw/Coachings/create_visit/user", "method": "GET" }) }), "name": "user" });
    this.summary42 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Begr\u00fcndung", "name": "summary", "maxLength": null, "selectOnFocus": true, "anchor": "-20" });
    this.items = [ { "autoHeight": true, "layout": "form", "xtype": "panel", "items": this.user41, "anchor": "-20", "labelAlign": "top" }, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": this.summary42, "anchor": "-20", "labelAlign": "top" } ];
    this.fields = [ this.user41, this.summary42 ];
    Lino.pcsw.CoachingsByClient.create_visit_ActionFormPanel.superclass.initComponent.call(this);
  }
});


Lino.cal.MyPresences.checkin_ActionFormPanel = Ext.extend(Lino.ActionFormPanel,{
  autoScroll: false,
  border: false,
  layout: "vbox",
  labelWidth: 387,
  hideCheckBoxLabels: true,
  frame: true,
  layoutConfig: { "align": "stretch" },
  bodyBorder: false,
  labelAlign: "top",
  action_name: 'checkin',
  ls_url: "/cal/MyPresences",
  window_title: "Einchecken",
  before_row_edit : function(record) {
  },
  initComponent : function() {
    this.notify_subject22 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Kurzbeschreibung", "name": "notify_subject", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    this.notify_body23 = new Ext.form.TextArea({ "selectOnFocus": true, "fieldLabel": "Beschreibung", "anchor": "-20 -10", "growMax": 2000, "name": "notify_body" });
    this.notify_silent24 = new Ext.form.Checkbox({ "boxLabel": "Keine Benachrichtigung per E-Mail schicken", "autoHeight": true, "hideLabel": true, "checked": false, "name": "notify_silent", "selectOnFocus": true, "anchor": "-20" });
    this.items = [ { "items": this.notify_subject22, "autoHeight": true, "layout": "form", "xtype": "panel", "labelAlign": "top" }, { "items": this.notify_body23, "labelAlign": "top", "layout": "form", "xtype": "panel", "flex": 71 }, { "items": this.notify_silent24, "autoHeight": true, "layout": "form", "xtype": "panel", "labelAlign": "top" } ];
    this.fields = [ this.notify_subject22, this.notify_body23, this.notify_silent24 ];
    Lino.cal.MyPresences.checkin_ActionFormPanel.superclass.initComponent.call(this);
  }
});


Lino.reception.Clients.create_visit_ActionFormPanel = Ext.extend(Lino.ActionFormPanel,{
  autoScroll: false,
  autoHeight: true,
  border: false,
  layout: "form",
  labelWidth: 99,
  hideCheckBoxLabels: true,
  frame: true,
  bodyBorder: false,
  labelAlign: "top",
  action_name: 'create_visit',
  ls_url: "/reception/Clients",
  window_title: "Visite erstellen",
  before_row_edit : function(record) {
  },
  autoHeight: true,
  initComponent : function() {
    this.user74 = new Lino.TwinCombo({ "preferred_width": 15, "autoHeight": true, "fieldLabel": "Benutzer", "allowBlank": false, "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.users.Users.detail,Lino.users.Users.insert)}, "emptyText": "Benutzer ausw\u00e4hlen...", "selectOnFocus": true, "hiddenName": "userHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/apchoices/reception/Clients/create_visit/user", "method": "GET" }) }), "name": "user" });
    this.summary75 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Begr\u00fcndung", "name": "summary", "maxLength": null, "selectOnFocus": true, "anchor": "-20" });
    this.items = [ { "autoHeight": true, "layout": "form", "xtype": "panel", "items": this.user74, "anchor": "-20", "labelAlign": "top" }, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": this.summary75, "anchor": "-20", "labelAlign": "top" } ];
    this.fields = [ this.user74, this.summary75 ];
    Lino.reception.Clients.create_visit_ActionFormPanel.superclass.initComponent.call(this);
  }
});


Lino.contacts.Persons.create_household_ActionFormPanel = Ext.extend(Lino.ActionFormPanel,{
  autoScroll: false,
  autoHeight: true,
  border: false,
  layout: "form",
  labelWidth: 117,
  hideCheckBoxLabels: true,
  frame: true,
  bodyBorder: false,
  labelAlign: "top",
  action_name: 'create_household',
  ls_url: "/contacts/Persons",
  window_title: "Haushalt erstellen",
  before_row_edit : function(record) {
  },
  autoHeight: true,
  initComponent : function() {
    this.partner29 = new Lino.TwinCombo({ "preferred_width": 20, "autoHeight": true, "fieldLabel": "Partner", "name": "partner", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.contacts.Persons.detail,Lino.contacts.Persons.insert)}, "hiddenName": "partnerHidden", "selectOnFocus": true, "emptyText": "Person ausw\u00e4hlen...", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/apchoices/contacts/Persons/create_household/partner", "method": "GET" }) }) });
    this.type30 = new Lino.TwinCombo({ "autoHeight": true, "fieldLabel": "Haushaltsart", "allowBlank": false, "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.households.Types.detail,Lino.households.Types.insert)}, "emptyText": "Haushaltsart ausw\u00e4hlen...", "selectOnFocus": true, "hiddenName": "typeHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/apchoices/contacts/Persons/create_household/type", "method": "GET" }) }), "name": "type" });
    this.head31 = new Lino.TwinCombo({ "preferred_width": 20, "autoHeight": true, "fieldLabel": "Vorstand", "allowBlank": false, "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.contacts.Persons.detail,Lino.contacts.Persons.insert)}, "emptyText": "Person ausw\u00e4hlen...", "selectOnFocus": true, "hiddenName": "headHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/apchoices/contacts/Persons/create_household/head", "method": "GET" }) }), "name": "head" });
    this.items = [ { "autoHeight": true, "layout": "form", "xtype": "panel", "items": this.partner29, "anchor": "-20", "labelAlign": "top" }, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": this.type30, "anchor": "-20", "labelAlign": "top" }, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": this.head31, "anchor": "-20", "labelAlign": "top" } ];
    this.fields = [ this.partner29, this.type30, this.head31 ];
    Lino.contacts.Persons.create_household_ActionFormPanel.superclass.initComponent.call(this);
  }
});


Lino.pcsw.Clients.wf1_ActionFormPanel = Ext.extend(Lino.ActionFormPanel,{
  autoScroll: false,
  border: false,
  layout: "vbox",
  labelWidth: 90,
  hideCheckBoxLabels: true,
  frame: true,
  layoutConfig: { "align": "stretch" },
  bodyBorder: false,
  labelAlign: "top",
  action_name: 'wf1',
  ls_url: "/pcsw/Clients",
  window_title: "Ablehnen",
  before_row_edit : function(record) {
  },
  initComponent : function() {
    this.reason46 = new Lino.ChoicesFieldElement({ "autoHeight": true, "forceSelection": true, "fieldLabel": "reason", "allowBlank": false, "hiddenName": "reasonHidden", "selectOnFocus": true, "anchor": "-20", "store": Lino.pcsw.RefusalReasons, "name": "reason" });
    this.remark47 = new Ext.form.TextArea({ "selectOnFocus": true, "fieldLabel": "Bemerkung", "anchor": "-20 -10", "growMax": 2000, "name": "remark" });
    this.items = [ { "items": this.reason46, "autoHeight": true, "layout": "form", "xtype": "panel", "labelAlign": "top" }, { "items": this.remark47, "labelAlign": "top", "layout": "form", "xtype": "panel", "flex": 83 } ];
    this.fields = [ this.reason46, this.remark47 ];
    Lino.pcsw.Clients.wf1_ActionFormPanel.superclass.initComponent.call(this);
  }
});


Lino.users.MySettings.change_password_ActionFormPanel = Ext.extend(Lino.ActionFormPanel,{
  autoScroll: false,
  autoHeight: true,
  border: false,
  layout: "form",
  labelWidth: 171,
  hideCheckBoxLabels: true,
  frame: true,
  bodyBorder: false,
  labelAlign: "top",
  action_name: 'change_password',
  ls_url: "/users/MySettings",
  window_title: "Passwort \u00e4ndern",
  before_row_edit : function(record) {
  },
  autoHeight: true,
  initComponent : function() {
    this.current1 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Current password", "name": "current", "maxLength": null, "selectOnFocus": true, "anchor": "-20", "inputType": "password" });
    this.new12 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "New password", "name": "new1", "maxLength": null, "selectOnFocus": true, "anchor": "-20", "inputType": "password" });
    this.new23 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "New password again", "name": "new2", "maxLength": null, "selectOnFocus": true, "anchor": "-20", "inputType": "password" });
    this.items = [ { "autoHeight": true, "layout": "form", "xtype": "panel", "items": this.current1, "anchor": "-20", "labelAlign": "top" }, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": this.new12, "anchor": "-20", "labelAlign": "top" }, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": this.new23, "anchor": "-20", "labelAlign": "top" } ];
    this.fields = [ this.current1, this.new12, this.new23 ];
    Lino.users.MySettings.change_password_ActionFormPanel.superclass.initComponent.call(this);
  }
});


Lino.cal.MyPresences.wf2_ActionFormPanel = Ext.extend(Lino.ActionFormPanel,{
  autoScroll: false,
  border: false,
  layout: "vbox",
  labelWidth: 387,
  hideCheckBoxLabels: true,
  frame: true,
  layoutConfig: { "align": "stretch" },
  bodyBorder: false,
  labelAlign: "top",
  action_name: 'wf2',
  ls_url: "/cal/MyPresences",
  window_title: "Absagen",
  before_row_edit : function(record) {
  },
  initComponent : function() {
    this.notify_subject15 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Kurzbeschreibung", "name": "notify_subject", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    this.notify_body16 = new Ext.form.TextArea({ "selectOnFocus": true, "fieldLabel": "Beschreibung", "anchor": "-20 -10", "growMax": 2000, "name": "notify_body" });
    this.notify_silent17 = new Ext.form.Checkbox({ "boxLabel": "Keine Benachrichtigung per E-Mail schicken", "autoHeight": true, "hideLabel": true, "checked": false, "name": "notify_silent", "selectOnFocus": true, "anchor": "-20" });
    this.items = [ { "items": this.notify_subject15, "autoHeight": true, "layout": "form", "xtype": "panel", "labelAlign": "top" }, { "items": this.notify_body16, "labelAlign": "top", "layout": "form", "xtype": "panel", "flex": 71 }, { "items": this.notify_silent17, "autoHeight": true, "layout": "form", "xtype": "panel", "labelAlign": "top" } ];
    this.fields = [ this.notify_subject15, this.notify_body16, this.notify_silent17 ];
    Lino.cal.MyPresences.wf2_ActionFormPanel.superclass.initComponent.call(this);
  }
});


Lino.cal.MyPresences.wf1_ActionFormPanel = Ext.extend(Lino.ActionFormPanel,{
  autoScroll: false,
  border: false,
  layout: "vbox",
  labelWidth: 387,
  hideCheckBoxLabels: true,
  frame: true,
  layoutConfig: { "align": "stretch" },
  bodyBorder: false,
  labelAlign: "top",
  action_name: 'wf1',
  ls_url: "/cal/MyPresences",
  window_title: "Zusagen",
  before_row_edit : function(record) {
  },
  initComponent : function() {
    this.notify_subject8 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Kurzbeschreibung", "name": "notify_subject", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    this.notify_body9 = new Ext.form.TextArea({ "selectOnFocus": true, "fieldLabel": "Beschreibung", "anchor": "-20 -10", "growMax": 2000, "name": "notify_body" });
    this.notify_silent10 = new Ext.form.Checkbox({ "boxLabel": "Keine Benachrichtigung per E-Mail schicken", "autoHeight": true, "hideLabel": true, "checked": false, "name": "notify_silent", "selectOnFocus": true, "anchor": "-20" });
    this.items = [ { "items": this.notify_subject8, "autoHeight": true, "layout": "form", "xtype": "panel", "labelAlign": "top" }, { "items": this.notify_body9, "labelAlign": "top", "layout": "form", "xtype": "panel", "flex": 71 }, { "items": this.notify_silent10, "autoHeight": true, "layout": "form", "xtype": "panel", "labelAlign": "top" } ];
    this.fields = [ this.notify_subject8, this.notify_body9, this.notify_silent10 ];
    Lino.cal.MyPresences.wf1_ActionFormPanel.superclass.initComponent.call(this);
  }
});


Lino.pcsw.Clients.merge_row_ActionFormPanel = Ext.extend(Lino.ActionFormPanel,{
  autoScroll: false,
  autoHeight: true,
  border: false,
  layout: "form",
  labelWidth: 99,
  hideCheckBoxLabels: true,
  frame: true,
  bodyBorder: false,
  labelAlign: "top",
  action_name: 'merge_row',
  ls_url: "/pcsw/Clients",
  window_title: "Fusionieren",
  before_row_edit : function(record) {
  },
  autoHeight: true,
  initComponent : function() {
    this.merge_to51 = new Lino.TwinCombo({ "preferred_width": 20, "autoHeight": true, "fieldLabel": "nach...", "allowBlank": false, "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.pcsw.Clients.detail,Lino.pcsw.Clients.insert)}, "emptyText": "Klient ausw\u00e4hlen...", "selectOnFocus": true, "hiddenName": "merge_toHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/apchoices/pcsw/Clients/merge_row/merge_to", "method": "GET" }) }), "name": "merge_to" });
    this.aids_SimpleConfirmation52 = new Ext.form.Checkbox({ "boxLabel": "Einfache Bescheinigungen", "autoHeight": true, "hideLabel": true, "checked": false, "name": "aids_SimpleConfirmation", "selectOnFocus": true, "anchor": "-20" });
    this.aids_IncomeConfirmation53 = new Ext.form.Checkbox({ "boxLabel": "Einkommensbescheinigungen", "autoHeight": true, "hideLabel": true, "checked": false, "name": "aids_IncomeConfirmation", "selectOnFocus": true, "anchor": "-20" });
    var keep_volatiles_1_panel54 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": this.aids_SimpleConfirmation52, "labelAlign": "top" }, { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": this.aids_IncomeConfirmation53, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 234, "border": false, "anchor": "-20", "labelAlign": "top" });
    this.aids_RefundConfirmation57 = new Ext.form.Checkbox({ "boxLabel": "Kosten\u00fcbernahmescheine", "autoHeight": true, "hideLabel": true, "checked": false, "name": "aids_RefundConfirmation", "selectOnFocus": true, "anchor": "-20" });
    this.cv_LanguageKnowledge58 = new Ext.form.Checkbox({ "boxLabel": "Sprachkenntnisse", "autoHeight": true, "hideLabel": true, "checked": false, "name": "cv_LanguageKnowledge", "selectOnFocus": true, "anchor": "-20" });
    var keep_volatiles_2_panel59 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": this.aids_RefundConfirmation57, "labelAlign": "top" }, { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": this.cv_LanguageKnowledge58, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 207, "border": false, "anchor": "-20", "labelAlign": "top" });
    this.pcsw_Coaching62 = new Ext.form.Checkbox({ "boxLabel": "Begleitungen", "autoHeight": true, "hideLabel": true, "checked": false, "name": "pcsw_Coaching", "selectOnFocus": true, "anchor": "-20" });
    this.pcsw_Dispense63 = new Ext.form.Checkbox({ "boxLabel": "Dispenzen", "autoHeight": true, "hideLabel": true, "checked": false, "name": "pcsw_Dispense", "selectOnFocus": true, "anchor": "-20" });
    var keep_volatiles_3_panel64 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": this.pcsw_Coaching62, "labelAlign": "top" }, { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": this.pcsw_Dispense63, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 117, "border": false, "anchor": "-20", "labelAlign": "top" });
    this.properties_PersonProperty67 = new Ext.form.Checkbox({ "boxLabel": "Eigenschaften", "autoHeight": true, "hideLabel": true, "checked": false, "name": "properties_PersonProperty", "selectOnFocus": true, "anchor": "-20" });
    var keep_volatiles_panel68 = new Ext.form.FieldSet({ "autoHeight": true, "layout": "form", "title": "Auch verg\u00e4ngliche verkn\u00fcpfte Objekte \u00fcberweisen", "items": [ keep_volatiles_1_panel54, keep_volatiles_2_panel59, keep_volatiles_3_panel64, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": this.properties_PersonProperty67, "anchor": "-20", "labelAlign": "top" } ], "frame": true, "bodyBorder": false, "autoScroll": false, "hideCheckBoxLabels": true, "labelWidth": 126, "border": false, "anchor": "-20", "labelAlign": "top" });
    this.reason70 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Begr\u00fcndung", "name": "reason", "maxLength": 100, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    this.items = [ { "autoHeight": true, "layout": "form", "xtype": "panel", "items": this.merge_to51, "anchor": "-20", "labelAlign": "top" }, keep_volatiles_panel68, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": this.reason70, "anchor": "-20", "labelAlign": "top" } ];
    this.fields = [ this.merge_to51, this.aids_SimpleConfirmation52, this.aids_IncomeConfirmation53, this.aids_RefundConfirmation57, this.cv_LanguageKnowledge58, this.pcsw_Coaching62, this.pcsw_Dispense63, this.properties_PersonProperty67, this.reason70 ];
    Lino.pcsw.Clients.merge_row_ActionFormPanel.superclass.initComponent.call(this);
  }
});


Lino.contacts.Companies.merge_row_ActionFormPanel = Ext.extend(Lino.ActionFormPanel,{
  autoScroll: false,
  autoHeight: true,
  border: false,
  layout: "form",
  labelWidth: 99,
  hideCheckBoxLabels: true,
  frame: true,
  bodyBorder: false,
  labelAlign: "top",
  action_name: 'merge_row',
  ls_url: "/contacts/Companies",
  window_title: "Fusionieren",
  before_row_edit : function(record) {
  },
  autoHeight: true,
  initComponent : function() {
    this.items = [  ];
    this.fields = [  ];
    Lino.contacts.Companies.merge_row_ActionFormPanel.superclass.initComponent.call(this);
  }
});


Lino.aids.SimpleConfirmations.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 113,
  initComponent : function() {
    var id2436 = new Ext.form.NumberField({ "selectOnFocus": true, "autoHeight": true, "fieldLabel": "ID", "anchor": "-20", "name": "id" });
    var client2437 = new Lino.TwinCombo({ "preferred_width": 20, "autoHeight": true, "fieldLabel": "Klient", "allowBlank": false, "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.pcsw.Clients.detail,Lino.pcsw.Clients.insert)}, "emptyText": "Klient ausw\u00e4hlen...", "selectOnFocus": true, "hiddenName": "clientHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/aids/SimpleConfirmations/client", "method": "GET" }) }), "name": "client" });
    var user2438 = new Lino.TwinCombo({ "preferred_width": 15, "autoHeight": true, "fieldLabel": "Autor", "name": "user", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.users.Users.detail,Lino.users.Users.insert)}, "hiddenName": "userHidden", "selectOnFocus": true, "emptyText": "Benutzer ausw\u00e4hlen...", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/aids/SimpleConfirmations/user", "method": "GET" }) }) });
    var signer2439 = new Lino.TwinCombo({ "preferred_width": 15, "autoHeight": true, "fieldLabel": "Best\u00e4tiger", "name": "signer", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.users.Users.detail,Lino.users.Users.insert)}, "hiddenName": "signerHidden", "selectOnFocus": true, "emptyText": "Benutzer ausw\u00e4hlen...", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/aids/SimpleConfirmations/signer", "method": "GET" }) }) });
    var workflow_buttons_disp2440 = new Ext.form.DisplayField({ "disabled": true, "autoHeight": true, "fieldLabel": "Arbeitsablauf", "name": "workflow_buttons", "anchor": "-20", "value": "<br/>", "always_enabled": true });
    var main_1_panel2441 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 126, "hideCheckBoxLabels": true, "items": [ { "flex": 5, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id2436, "labelAlign": "top" }, { "flex": 21, "autoHeight": true, "layout": "form", "xtype": "panel", "items": client2437, "labelAlign": "top" }, { "flex": 21, "autoHeight": true, "layout": "form", "xtype": "panel", "items": user2438, "labelAlign": "top" }, { "flex": 21, "autoHeight": true, "layout": "form", "xtype": "panel", "items": signer2439, "labelAlign": "top" }, { "flex": 31, "autoHeight": true, "layout": "form", "xtype": "panel", "items": workflow_buttons_disp2440, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var granting2447 = new Lino.TwinCombo({ "autoHeight": true, "fieldLabel": "Hilfebeschluss", "name": "granting", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.aids.GrantingsByX.detail,Lino.aids.GrantingsByX.insert)}, "emptyText": "Hilfebeschluss ausw\u00e4hlen...", "selectOnFocus": true, "hiddenName": "grantingHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/aids/SimpleConfirmations/granting", "method": "GET" }) }) });
    var start_date2448 = new Lino.DateField({ "selectOnFocus": true, "autoHeight": true, "fieldLabel": "Periode vom", "anchor": "-20", "name": "start_date" });
    var end_date2449 = new Lino.DateField({ "selectOnFocus": true, "autoHeight": true, "fieldLabel": "bis", "anchor": "-20", "name": "end_date" });
    var main_2_panel2450 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 135, "hideCheckBoxLabels": true, "items": [ { "flex": 43, "autoHeight": true, "layout": "form", "xtype": "panel", "items": granting2447, "labelAlign": "top" }, { "flex": 28, "autoHeight": true, "layout": "form", "xtype": "panel", "items": start_date2448, "labelAlign": "top" }, { "flex": 28, "autoHeight": true, "layout": "form", "xtype": "panel", "items": end_date2449, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var company2454 = new Lino.TwinCombo({ "preferred_width": 20, "autoHeight": true, "fieldLabel": "Empf\u00e4nger (Organisation)", "name": "company", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.contacts.Companies.detail,Lino.contacts.Companies.insert)}, "hiddenName": "companyHidden", "selectOnFocus": true, "emptyText": "Organisation ausw\u00e4hlen...", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/aids/SimpleConfirmations/company", "method": "GET" }) }) });
    var contact_person2455 = new Lino.TwinCombo({ "preferred_width": 20, "autoHeight": true, "fieldLabel": "Empf\u00e4nger (Person)", "name": "contact_person", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.contacts.Persons.detail,Lino.contacts.Persons.insert)}, "hiddenName": "contact_personHidden", "selectOnFocus": true, "emptyText": "Person ausw\u00e4hlen...", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/aids/SimpleConfirmations/contact_person", "method": "GET" }) }) });
    var printed_disp2456 = new Ext.form.DisplayField({ "disabled": true, "autoHeight": true, "fieldLabel": "Ausgedruckt", "name": "printed", "anchor": "-20", "value": "<br/>", "always_enabled": true });
    var main_3_panel2457 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 225, "hideCheckBoxLabels": true, "items": [ { "flex": 28, "autoHeight": true, "layout": "form", "xtype": "panel", "items": company2454, "labelAlign": "top" }, { "flex": 28, "autoHeight": true, "layout": "form", "xtype": "panel", "items": contact_person2455, "labelAlign": "top" }, { "flex": 42, "autoHeight": true, "layout": "form", "xtype": "panel", "items": printed_disp2456, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var remark2461 = new Lino.RichTextPanel({ "selectOnFocus": true, "flex": 41, "containing_panel": this, "name": "remark", "title": "Bemerkung" });
    var main_panel2462 = new Ext.Panel({ "autoScroll": false, "border": false, "layout": "vbox", "labelWidth": 0, "hideCheckBoxLabels": true, "items": [ main_1_panel2441, main_2_panel2450, main_3_panel2457, remark2461 ], "frame": true, "layoutConfig": { "align": "stretch" }, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel2462;
    this.before_row_edit = function(record) {
      contact_person2455.setContextValue('company', record ? record.data['companyHidden'] : undefined);
      remark2461.refresh();
    }
    this.onRender = function(ct, position) {
      company2454.on('change',Lino.chooser_handler(contact_person2455,'company'));
      Lino.aids.SimpleConfirmations.DetailFormPanel.superclass.onRender.call(this, ct, position);
    }
    Lino.aids.SimpleConfirmations.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.about.About.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  disable_editing: true,
  initComponent : function() {
    var server_status_disp2734 = new Ext.form.DisplayField({ "disabled": true, "autoHeight": true, "fieldLabel": "Server-Status", "name": "server_status", "anchor": "-20", "value": "<br/>", "always_enabled": true });
    var main_panel2735 = new Ext.Panel({ "autoScroll": false, "border": false, "layout": "vbox", "labelWidth": 126, "hideCheckBoxLabels": true, "items": [ { "flex": 25, "html": "<div class=\"htmlText\"><span>Dies ist <a href=\"http://welfare.lino-framework.org\" target=\"_blank\">Lino Welfare</a> 1.1.19 unter <a href=\"http://www.lino-framework.org\" target=\"_blank\">Lino</a> 1.6.16, <a href=\"http://www.djangoproject.com\" target=\"_blank\">Django</a> 1.6.7, <a href=\"http://www.python.org/\" target=\"_blank\">Python</a> 2.7.4, <a href=\"http://babel.edgewall.org/\" target=\"_blank\">Babel</a> 1.3, <a href=\"http://jinja.pocoo.org/\" target=\"_blank\">Jinja</a> 2.7.2, <a href=\"http://sphinx-doc.org/\" target=\"_blank\">Sphinx</a> 1.3a0, <a href=\"http://labix.org/python-dateutil\" target=\"_blank\">python-dateutil</a> 2.1, <a href=\"http://pypi.python.org/pypi/odfpy\" target=\"_blank\">OdfPy</a> ODFPY/0.9.6, <a href=\"http://docutils.sourceforge.net/\" target=\"_blank\">docutils</a> 0.11, <a href=\"https://fedorahosted.org/suds/\" target=\"_blank\">suds</a> 0.4, <a href=\"http://pyyaml.org/\" target=\"_blank\">PyYaml</a> 3.10, <a href=\"http://appyframework.org/pod.html\" target=\"_blank\">Appy</a> 0.9.0 (2014/06/23 22:15), <a href=\"http://www.sencha.com\" target=\"_blank\">ExtJS</a> <a href=\"#\" onclick=\"alert('ExtJS client version is ' + Ext.version);\" title=\"Click to see ExtJS client version\">(version)</a>, <a href=\"http://www.famfamfam.com/lab/icons/silk/\" target=\"_blank\">Silk Icons</a> 1.3, <a href=\"http://getbootstrap.com\" target=\"_blank\">Bootstrap</a> 3.x, <a href=\"http://ext.ensible.com/products/calendar/\" target=\"_blank\">Ext.ensible adapter</a> <a href=\"#\" onclick=\"alert('Extensible Calendar version is '             + Ext.ensible.version);\" title=\"Click to see Extensible Calendar version\">(version)</a></span><p>Server l&#228;uft seit : <b>Samstag, 20. Dezember 2014 um 11:09:44.659613</b></p><p>Source timestamps:</p><ul><li>lino : <b>Samstag, 20. Dezember 2014 um 06:12:06.934732</b></li><li>lino_welfare : <b>Freitag, 19. Dezember 2014 um 06:12:57.762790</b></li><li>atelier : <b>Dienstag, 16. Dezember 2014 um 10:51:28.722053</b></li><li>django : <b>Montag, 27. Oktober 2014 um 16:34:33.459643</b></li></ul></div>", "xtype": "label" }, { "items": server_status_disp2734, "autoHeight": true, "layout": "form", "xtype": "panel", "labelAlign": "top" } ], "frame": true, "layoutConfig": { "align": "stretch" }, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel2735;
    this.before_row_edit = function(record) {
    }
    Lino.about.About.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.pcsw.Clients.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 55,
  initComponent : function() {
    var overview_disp1562 = new Ext.form.DisplayField({ "disabled": true, "flex": 28, "name": "overview", "value": "<br/>", "always_enabled": true });
    var gender1563 = new Lino.ChoicesFieldElement({ "autoHeight": true, "forceSelection": true, "fieldLabel": "Geschlecht", "name": "gender", "hiddenName": "genderHidden", "selectOnFocus": true, "anchor": "-20", "store": [['','<br>']].concat(Lino.system.Genders) });
    var id1564 = new Ext.form.NumberField({ "selectOnFocus": true, "autoHeight": true, "fieldLabel": "ID", "anchor": "-20", "name": "id" });
    var general2_1_panel1565 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": gender1563, "labelAlign": "top" }, { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id1564, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 99, "border": false, "anchor": "-20", "labelAlign": "top" });
    var first_name1568 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Vorname</span>", "name": "first_name", "listeners": { "render": Lino.quicktip_renderer("Vorname","First or given name.") }, "maxLength": 200, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var middle_name1569 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Zwischenname</span>", "name": "middle_name", "maxLength": 200, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Zwischenname","Space-separated list of all middle names.") }, "anchor": "-20" });
    var last_name1570 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Familienname</span>", "name": "last_name", "listeners": { "render": Lino.quicktip_renderer("Familienname","Last name (family name).") }, "maxLength": 200, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var general2_2_panel1571 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": first_name1568, "labelAlign": "top" }, { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": middle_name1569, "labelAlign": "top" }, { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": last_name1570, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 117, "border": false, "anchor": "-20", "labelAlign": "top" });
    var birth_date1575 = new Lino.IncompleteDateField({ "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Geburtsdatum</span>", "name": "birth_date", "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Geburtsdatum","Unkomplette Datumsangaben sind erlaubt, z.B. \"00.00.1980\" hei\u00dft \"irgendwann im Jahr 1980\", \"00.07.1980\" hei\u00dft \"im Juli 1980\"oder \"23.07.0000\" hei\u00dft \"an einem 23. Juli\".") }, "anchor": "-20" });
    var age_disp1576 = new Ext.form.DisplayField({ "disabled": true, "autoHeight": true, "fieldLabel": "Alter", "name": "age", "anchor": "-20", "value": "<br/>", "always_enabled": true });
    var national_id1577 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "NR-Nummer", "name": "national_id", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var general2_3_panel1578 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 32, "autoHeight": true, "layout": "form", "xtype": "panel", "items": birth_date1575, "labelAlign": "top" }, { "flex": 27, "autoHeight": true, "layout": "form", "xtype": "panel", "items": age_disp1576, "labelAlign": "top" }, { "flex": 40, "autoHeight": true, "layout": "form", "xtype": "panel", "items": national_id1577, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 117, "border": false, "anchor": "-20", "labelAlign": "top" });
    var nationality1582 = new Lino.TwinCombo({ "autoHeight": true, "fieldLabel": "Staatsangeh\u00f6rigkeit", "name": "nationality", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.countries.Countries.detail,Lino.countries.Countries.insert)}, "emptyText": "Land ausw\u00e4hlen...", "selectOnFocus": true, "hiddenName": "nationalityHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/pcsw/Clients/nationality", "method": "GET" }) }) });
    var declared_name1583 = new Ext.form.Checkbox({ "boxLabel": "Deklarierter Name", "autoHeight": true, "hideLabel": true, "checked": false, "name": "declared_name", "selectOnFocus": true, "anchor": "-20" });
    var general2_4_panel1584 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 60, "autoHeight": true, "layout": "form", "xtype": "panel", "items": nationality1582, "labelAlign": "top" }, { "flex": 40, "autoHeight": true, "layout": "form", "xtype": "panel", "items": declared_name1583, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 180, "border": false, "anchor": "-20", "labelAlign": "top" });
    var civil_state1587 = new Lino.ChoicesFieldElement({ "autoHeight": true, "forceSelection": true, "fieldLabel": "Zivilstand", "name": "civil_state", "hiddenName": "civil_stateHidden", "selectOnFocus": true, "anchor": "-20", "store": [['','<br>']].concat(Lino.pcsw.CivilState) });
    var birth_country1588 = new Lino.TwinCombo({ "autoHeight": true, "fieldLabel": "Geburtsland", "name": "birth_country", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.countries.Countries.detail,Lino.countries.Countries.insert)}, "emptyText": "Land ausw\u00e4hlen...", "selectOnFocus": true, "hiddenName": "birth_countryHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/pcsw/Clients/birth_country", "method": "GET" }) }) });
    var birth_place1589 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Geburtsort", "name": "birth_place", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var general2_5_panel1590 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 51, "autoHeight": true, "layout": "form", "xtype": "panel", "items": civil_state1587, "labelAlign": "top" }, { "flex": 23, "autoHeight": true, "layout": "form", "xtype": "panel", "items": birth_country1588, "labelAlign": "top" }, { "flex": 25, "autoHeight": true, "layout": "form", "xtype": "panel", "items": birth_place1589, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 108, "border": false, "anchor": "-20", "labelAlign": "top" });
    var general2_panel1594 = new Ext.Panel({ "flex": 38, "autoHeight": true, "border": false, "layout": "form", "hideCheckBoxLabels": true, "items": [ general2_1_panel1565, general2_2_panel1571, general2_3_panel1578, general2_4_panel1584, general2_5_panel1590 ], "frame": true, "autoScroll": false, "bodyBorder": false, "labelAlign": "top" });
    var language1595 = new Lino.ChoicesFieldElement({ "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Sprache</span>", "allowBlank": false, "hiddenName": "languageHidden", "listeners": { "render": Lino.quicktip_renderer("Sprache","Die Sprache, in der Dokumente ausgestellt werden sollen.") }, "selectOnFocus": true, "anchor": "-20", "store": [ [ "de", "Deutsch" ], [ "fr", "Franz\u00f6sisch" ], [ "nl", "Niederl\u00e4ndisch" ] ], "name": "language" });
    var email1596 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "E-Mail", "name": "email", "maxLength": 75, "selectOnFocus": true, "anchor": "-20" });
    var phone1597 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Telefon", "name": "phone", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var fax1598 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Fax", "name": "fax", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var gsm1599 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "GSM", "name": "gsm", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var general3_panel1600 = new Ext.Panel({ "flex": 19, "autoHeight": true, "layout": "form", "items": [ { "autoHeight": true, "layout": "form", "xtype": "panel", "items": language1595, "anchor": "-20", "labelAlign": "top" }, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": email1596, "anchor": "-20", "labelAlign": "top" }, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": phone1597, "anchor": "-20", "labelAlign": "top" }, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": fax1598, "anchor": "-20", "labelAlign": "top" }, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": gsm1599, "anchor": "-20", "labelAlign": "top" } ], "frame": true, "bodyBorder": false, "autoScroll": false, "hideCheckBoxLabels": true, "labelWidth": 72, "border": false, "labelAlign": "top" });
    var image_htmlbox1606 = new Lino.HtmlBoxPanel({ "flex": 14, "layout": "fit", "name": "image", "containing_panel": this, "items": new Ext.BoxComponent({autoScroll:true}), "value": "<br/>", "always_enabled": true, "bodyStyle": "overflow-x:hidden;" });
    var general_1_panel1607 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 0, "hideCheckBoxLabels": true, "items": [ overview_disp1562, general2_panel1594, general3_panel1600, image_htmlbox1606 ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var reception_AppointmentsByPartner_grid1608 = new Lino.reception.AppointmentsByPartner.GridPanel({ "flex": 53, "hide_top_toolbar": true, "containing_panel": this, "tools": [ Lino.show_in_own_window_button(Lino.reception.AppointmentsByPartner.grid) ], "preview_limit": 15, "master_panel": this });
    var reception_CoachingsByClient_grid1613 = new Lino.reception.CoachingsByClient.GridPanel({ "flex": 46, "hide_top_toolbar": true, "containing_panel": this, "params_panel_hidden": true, "tools": [ Lino.show_in_own_window_button(Lino.reception.CoachingsByClient.grid) ], "master_panel": this, "preview_limit": 15 });
    var general_2_panel1614 = new Ext.Panel({ "flex": 41, "border": false, "layout": "hbox", "hideCheckBoxLabels": true, "items": [ reception_AppointmentsByPartner_grid1608, reception_CoachingsByClient_grid1613 ], "autoScroll": false, "layoutConfig": { "align": "stretch" }, "frame": false, "labelAlign": "top" });
    var general_panel1615 = new Ext.Panel({ "layout": "vbox", "title": "Person", "items": [ general_1_panel1607, general_2_panel1614 ], "frame": true, "layoutConfig": { "align": "stretch" }, "hideCheckBoxLabels": true, "listeners": { "activate": Lino.on_tab_activate }, "autoScroll": false, "border": false, "bodyBorder": false, "labelAlign": "top" });
    var SimilarPersons_htmlbox1616 = new Lino.HtmlBoxPanel({ "flex": 14, "layout": "fit", "name": "SimilarPersons", "containing_panel": this, "items": new Ext.BoxComponent({autoScroll:true}), "title": "\u00c4hnliche Personen", "master_panel": this, "value": "<br/>", "always_enabled": true, "bodyStyle": "overflow-x:hidden;", "tools": [ Lino.show_in_own_window_button(Lino.dedupe.SimilarPersons.grid) ] });
    var LinksByHuman_htmlbox1617 = new Lino.HtmlBoxPanel({ "flex": 42, "layout": "fit", "name": "LinksByHuman", "containing_panel": this, "items": new Ext.BoxComponent({autoScroll:true}), "title": "Beziehungen", "master_panel": this, "value": "<br/>", "always_enabled": true, "bodyStyle": "overflow-x:hidden;", "tools": [ Lino.show_in_own_window_button(Lino.humanlinks.LinksByHuman.grid) ] });
    var cbss_relations_htmlbox1618 = new Lino.HtmlBoxPanel({ "flex": 42, "layout": "fit", "name": "cbss_relations", "containing_panel": this, "items": new Ext.BoxComponent({autoScroll:true}), "title": "ZDSS", "value": "<br/>", "always_enabled": true, "bodyStyle": "overflow-x:hidden;" });
    var contact_1_panel1619 = new Ext.Panel({ "flex": 3, "layout": "hbox", "items": [ SimilarPersons_htmlbox1616, LinksByHuman_htmlbox1617, cbss_relations_htmlbox1618 ], "region": "north", "layoutConfig": { "align": "stretch" }, "hideCheckBoxLabels": true, "split": true, "autoScroll": false, "labelWidth": 162, "border": false, "frame": false, "labelAlign": "top" });
    var MembersByPerson_htmlbox1620 = new Lino.HtmlBoxPanel({ "flex": 28, "layout": "fit", "name": "MembersByPerson", "containing_panel": this, "items": new Ext.BoxComponent({autoScroll:true}), "title": "Mitgliedschaft in Haushalten", "master_panel": this, "value": "<br/>", "always_enabled": true, "bodyStyle": "overflow-x:hidden;", "tools": [ Lino.show_in_own_window_button(Lino.households.MembersByPerson.grid) ] });
    var households_SiblingsByPerson_grid1621 = new Lino.households.SiblingsByPerson.GridPanel({ "flex": 71, "hide_top_toolbar": true, "containing_panel": this, "tools": [ Lino.show_in_own_window_button(Lino.households.SiblingsByPerson.grid) ], "preview_limit": 15, "master_panel": this });
    var contact_2_panel1622 = new Ext.Panel({ "flex": 5, "layout": "hbox", "items": [ MembersByPerson_htmlbox1620, households_SiblingsByPerson_grid1621 ], "region": "center", "layoutConfig": { "align": "stretch" }, "hideCheckBoxLabels": true, "split": true, "autoScroll": false, "labelWidth": 261, "border": false, "frame": false, "labelAlign": "top" });
    var contact_panel1623 = new Lino.VBorderPanel({ "autoScroll": false, "listeners": { "activate": Lino.on_tab_activate }, "border": false, "title": "Beziehungen", "hideCheckBoxLabels": true, "items": [ contact_1_panel1619, contact_2_panel1622 ], "frame": true, "bodyBorder": false, "labelAlign": "top" });
    var workflow_buttons_disp1624 = new Ext.form.DisplayField({ "disabled": true, "autoHeight": true, "fieldLabel": "Arbeitsablauf", "name": "workflow_buttons", "anchor": "-20", "value": "<br/>", "always_enabled": true });
    var broker1625 = new Lino.RemoteComboFieldElement({ "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Vermittler</span>", "name": "broker", "pageSize": 20, "emptyText": "Vermittler ausw\u00e4hlen...", "listeners": { "render": Lino.quicktip_renderer("Vermittler","The Broker who sent this Newcomer.") }, "selectOnFocus": true, "hiddenName": "brokerHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/pcsw/Clients/broker", "method": "GET" }) }) });
    var faculty1626 = new Lino.TwinCombo({ "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Fachbereich</span>", "name": "faculty", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.newcomers.Faculties.detail,Lino.newcomers.Faculties.insert)}, "emptyText": "Fachbereich ausw\u00e4hlen...", "listeners": { "render": Lino.quicktip_renderer("Fachbereich","The Faculty this client has been attributed to.") }, "selectOnFocus": true, "hiddenName": "facultyHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/pcsw/Clients/faculty", "method": "GET" }) }) });
    var refusal_reason1627 = new Lino.ChoicesFieldElement({ "autoHeight": true, "forceSelection": true, "fieldLabel": "refusal reason", "name": "refusal_reason", "hiddenName": "refusal_reasonHidden", "selectOnFocus": true, "anchor": "-20", "store": [['','<br>']].concat(Lino.pcsw.RefusalReasons) });
    var newcomers_left_panel1628 = new Ext.Panel({ "flex": 33, "autoHeight": true, "layout": "form", "items": [ { "autoHeight": true, "layout": "form", "xtype": "panel", "items": workflow_buttons_disp1624, "anchor": "-20", "labelAlign": "top" }, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": broker1625, "anchor": "-20", "labelAlign": "top" }, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": faculty1626, "anchor": "-20", "labelAlign": "top" }, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": refusal_reason1627, "anchor": "-20", "labelAlign": "top" } ], "frame": true, "bodyBorder": false, "autoScroll": false, "hideCheckBoxLabels": true, "labelWidth": 135, "border": false, "labelAlign": "top" });
    var coaching_1_panel1648 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "hideCheckBoxLabels": true, "items": [ newcomers_left_panel1628 ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var pcsw_ContactsByClient_grid1656 = new Lino.pcsw.ContactsByClient.GridPanel({ "flex": 33, "hide_top_toolbar": true, "containing_panel": this, "tools": [ Lino.show_in_own_window_button(Lino.pcsw.ContactsByClient.grid) ], "preview_limit": 15, "master_panel": this });
    var pcsw_CoachingsByClient_grid1665 = new Lino.pcsw.CoachingsByClient.GridPanel({ "flex": 66, "hide_top_toolbar": true, "containing_panel": this, "params_panel_hidden": true, "tools": [ Lino.show_in_own_window_button(Lino.pcsw.CoachingsByClient.grid) ], "preview_limit": 15, "master_panel": this });
    var coaching_2_panel1666 = new Ext.Panel({ "flex": 45, "border": false, "layout": "hbox", "hideCheckBoxLabels": true, "items": [ pcsw_ContactsByClient_grid1656, pcsw_CoachingsByClient_grid1665 ], "autoScroll": false, "layoutConfig": { "align": "stretch" }, "frame": false, "labelAlign": "top" });
    var coaching_panel1667 = new Ext.Panel({ "layout": "vbox", "title": "Begleitung", "items": [ coaching_1_panel1648, coaching_2_panel1666 ], "frame": true, "layoutConfig": { "align": "stretch" }, "hideCheckBoxLabels": true, "listeners": { "activate": Lino.on_tab_activate }, "autoScroll": false, "border": false, "bodyBorder": false, "labelAlign": "top" });
    var in_belgium_since1668 = new Lino.DateField({ "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Lebt in Belgien seit</span>", "name": "in_belgium_since", "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Lebt in Belgien seit","Since when this person in Belgium lives.\n<b>Important:</b> help_text can be formatted.") }, "anchor": "-20" });
    var residence_type1669 = new Lino.ChoicesFieldElement({ "autoHeight": true, "forceSelection": true, "fieldLabel": "Register", "name": "residence_type", "hiddenName": "residence_typeHidden", "selectOnFocus": true, "anchor": "-20", "store": [['','<br>']].concat(Lino.pcsw.ResidenceType) });
    var gesdos_id1670 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Gesdos-Nr", "name": "gesdos_id", "maxLength": 40, "selectOnFocus": true, "anchor": "-20" });
    var status_1_panel1671 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 25, "autoHeight": true, "layout": "form", "xtype": "panel", "items": in_belgium_since1668, "labelAlign": "top" }, { "flex": 38, "autoHeight": true, "layout": "form", "xtype": "panel", "items": residence_type1669, "labelAlign": "top" }, { "flex": 35, "autoHeight": true, "layout": "form", "xtype": "panel", "items": gesdos_id1670, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 189, "border": false, "anchor": "-20", "labelAlign": "top" });
    var job_agents1675 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Interim-Agenturen", "name": "job_agents", "maxLength": 100, "selectOnFocus": true, "anchor": "-20" });
    var group1676 = new Lino.RemoteComboFieldElement({ "autoHeight": true, "fieldLabel": "Integrationsphase", "name": "group", "pageSize": 20, "emptyText": "Integrationsphase ausw\u00e4hlen...", "selectOnFocus": true, "hiddenName": "groupHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/pcsw/Clients/group", "method": "GET" }) }) });
    var aid_type1677 = new Lino.RemoteComboFieldElement({ "autoHeight": true, "fieldLabel": "Sozialhilfeart", "name": "aid_type", "pageSize": 20, "emptyText": "Sozialhilfeart ausw\u00e4hlen...", "selectOnFocus": true, "hiddenName": "aid_typeHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/pcsw/Clients/aid_type", "method": "GET" }) }) });
    var status_2_panel1678 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 36, "autoHeight": true, "layout": "form", "xtype": "panel", "items": job_agents1675, "labelAlign": "top" }, { "flex": 28, "autoHeight": true, "layout": "form", "xtype": "panel", "items": group1676, "labelAlign": "top" }, { "flex": 35, "autoHeight": true, "layout": "form", "xtype": "panel", "items": aid_type1677, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 162, "border": false, "anchor": "-20", "labelAlign": "top" });
    var status_panel1682 = new Ext.Panel({ "flex": 68, "autoHeight": true, "border": false, "layout": "form", "hideCheckBoxLabels": true, "items": [ status_1_panel1671, status_2_panel1678 ], "frame": true, "autoScroll": false, "bodyBorder": false, "labelAlign": "top" });
    var income_ag1683 = new Ext.form.Checkbox({ "boxLabel": "Arbeitslosengeld", "autoHeight": true, "hideLabel": true, "checked": false, "name": "income_ag", "selectOnFocus": true, "anchor": "-20" });
    var income_wg1684 = new Ext.form.Checkbox({ "boxLabel": "Wartegeld", "autoHeight": true, "hideLabel": true, "checked": false, "name": "income_wg", "selectOnFocus": true, "anchor": "-20" });
    var income_1_panel1685 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": income_ag1683, "labelAlign": "top" }, { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": income_wg1684, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 153, "border": false, "anchor": "-20", "labelAlign": "top" });
    var income_kg1688 = new Ext.form.Checkbox({ "boxLabel": "Krankengeld", "autoHeight": true, "hideLabel": true, "checked": false, "name": "income_kg", "selectOnFocus": true, "anchor": "-20" });
    var income_rente1689 = new Ext.form.Checkbox({ "boxLabel": "Rente", "autoHeight": true, "hideLabel": true, "checked": false, "name": "income_rente", "selectOnFocus": true, "anchor": "-20" });
    var income_2_panel1690 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": income_kg1688, "labelAlign": "top" }, { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": income_rente1689, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 108, "border": false, "anchor": "-20", "labelAlign": "top" });
    var income_misc1693 = new Ext.form.Checkbox({ "boxLabel": "andere Einkommen", "autoHeight": true, "hideLabel": true, "checked": false, "name": "income_misc", "selectOnFocus": true, "anchor": "-20" });
    var income_panel1694 = new Ext.Panel({ "flex": 31, "autoHeight": true, "layout": "form", "items": [ income_1_panel1685, income_2_panel1690, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": income_misc1693, "anchor": "-20", "labelAlign": "top" } ], "frame": true, "bodyBorder": false, "autoScroll": false, "hideCheckBoxLabels": true, "labelWidth": 153, "border": false, "labelAlign": "top" });
    var aids_tab_1_panel1696 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ status_panel1682, income_panel1694 ], "region": "north", "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "split": true, "autoScroll": false, "border": false, "frame": false, "labelAlign": "top" });
    var sepa_AccountsByClient_grid1703 = new Lino.sepa.AccountsByClient.GridPanel({ "flex": 5, "hide_top_toolbar": true, "containing_panel": this, "region": "center", "preview_limit": 15, "master_panel": this, "split": true, "tools": [ Lino.show_in_own_window_button(Lino.sepa.AccountsByClient.grid) ] });
    var aids_GrantingsByClient_grid1730 = new Lino.aids.GrantingsByClient.GridPanel({ "flex": 5, "hide_top_toolbar": true, "containing_panel": this, "region": "south", "preview_limit": 15, "master_panel": this, "split": true, "tools": [ Lino.show_in_own_window_button(Lino.aids.GrantingsByClient.grid) ] });
    var aids_tab_panel1731 = new Lino.VBorderPanel({ "autoScroll": false, "listeners": { "activate": Lino.on_tab_activate }, "border": false, "title": "Hilfen", "hideCheckBoxLabels": true, "items": [ aids_tab_1_panel1696, sepa_AccountsByClient_grid1703, aids_GrantingsByClient_grid1730 ], "frame": true, "bodyBorder": false, "labelAlign": "top" });
    var is_seeking1745 = new Ext.form.Checkbox({ "boxLabel": "Arbeit suchend", "autoHeight": true, "hideLabel": true, "checked": false, "name": "is_seeking", "selectOnFocus": true, "anchor": "-20" });
    var unemployed_since1746 = new Lino.DateField({ "selectOnFocus": true, "autoHeight": true, "fieldLabel": "eingetragen seit", "anchor": "-20", "name": "unemployed_since" });
    var work_permit_suspended_until1747 = new Lino.DateField({ "selectOnFocus": true, "autoHeight": true, "fieldLabel": "Wartezeit bis", "anchor": "-20", "name": "work_permit_suspended_until" });
    var papers_1_panel1748 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 153, "hideCheckBoxLabels": true, "items": [ { "flex": 27, "autoHeight": true, "layout": "form", "xtype": "panel", "items": is_seeking1745, "labelAlign": "top" }, { "flex": 36, "autoHeight": true, "layout": "form", "xtype": "panel", "items": unemployed_since1746, "labelAlign": "top" }, { "flex": 36, "autoHeight": true, "layout": "form", "xtype": "panel", "items": work_permit_suspended_until1747, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var needs_residence_permit1752 = new Ext.form.Checkbox({ "boxLabel": "Braucht Aufenthaltserlaubnis", "autoHeight": true, "hideLabel": true, "checked": false, "name": "needs_residence_permit", "selectOnFocus": true, "anchor": "-20" });
    var needs_work_permit1753 = new Ext.form.Checkbox({ "boxLabel": "Braucht Arb.Erl.", "autoHeight": true, "hideLabel": true, "checked": false, "name": "needs_work_permit", "selectOnFocus": true, "anchor": "-20" });
    var papers_2_panel1754 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 261, "hideCheckBoxLabels": true, "items": [ { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": needs_residence_permit1752, "labelAlign": "top" }, { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": needs_work_permit1753, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var UploadsByClient_htmlbox1757 = new Lino.HtmlBoxPanel({ "flex": 60, "layout": "fit", "name": "UploadsByClient", "containing_panel": this, "items": new Ext.BoxComponent({autoScroll:true}), "title": "Uploads", "master_panel": this, "value": "<br/>", "always_enabled": true, "bodyStyle": "overflow-x:hidden;", "tools": [ Lino.show_in_own_window_button(Lino.uploads.UploadsByClient.grid) ] });
    var papers_panel1758 = new Ext.Panel({ "flex": 50, "layout": "vbox", "items": [ papers_1_panel1748, papers_2_panel1754, UploadsByClient_htmlbox1757 ], "frame": true, "layoutConfig": { "align": "stretch" }, "autoScroll": false, "hideCheckBoxLabels": true, "labelWidth": 72, "border": false, "bodyBorder": false, "labelAlign": "top" });
    var work_tab_1_panel1759 = new Ext.Panel({ "autoScroll": false, "listeners": { "activate": Lino.on_tab_activate }, "border": false, "layout": "hbox", "title": "Arbeitssuche", "hideCheckBoxLabels": true, "items": [ papers_panel1758 ], "frame": false, "layoutConfig": { "align": "stretch" }, "labelAlign": "top" });
    var cvs_emitted_disp1760 = new Ext.form.DisplayField({ "disabled": true, "autoHeight": true, "fieldLabel": "Erstellte Lebensl\u00e4ufe", "name": "cvs_emitted", "anchor": "-20", "value": "<br/>", "always_enabled": true });
    var career_panel1868 = new Ext.Panel({ "layout": "vbox", "title": "Lebenslauf", "items": [ { "items": cvs_emitted_disp1760, "autoHeight": true, "layout": "form", "xtype": "panel", "labelAlign": "top" } ], "frame": true, "layoutConfig": { "align": "stretch" }, "hideCheckBoxLabels": true, "listeners": { "activate": Lino.on_tab_activate }, "autoScroll": false, "labelWidth": 198, "border": false, "bodyBorder": false, "labelAlign": "top" });
    var skills1928 = new Ext.form.TextArea({ "selectOnFocus": true, "fieldLabel": "Sonstige F\u00e4higkeiten", "anchor": "-20 -10", "growMax": 2000, "name": "skills" });
    var competences_1_panel1929 = new Ext.Panel({ "flex": 5, "layout": "hbox", "items": [ { "items": skills1928, "labelAlign": "top", "layout": "form", "xtype": "panel", "flex": 28 } ], "region": "north", "layoutConfig": { "align": "stretch" }, "hideCheckBoxLabels": true, "split": true, "autoScroll": false, "labelWidth": 189, "border": false, "frame": false, "labelAlign": "top" });
    var obstacles1938 = new Ext.form.TextArea({ "selectOnFocus": true, "fieldLabel": "Sonstige Hindernisse", "anchor": "-20 -10", "growMax": 2000, "name": "obstacles" });
    var competences_2_panel1939 = new Ext.Panel({ "flex": 5, "layout": "hbox", "items": [ { "items": obstacles1938, "labelAlign": "top", "layout": "form", "xtype": "panel", "flex": 44 } ], "region": "center", "layoutConfig": { "align": "stretch" }, "hideCheckBoxLabels": true, "split": true, "autoScroll": false, "labelWidth": 189, "border": false, "frame": false, "labelAlign": "top" });
    var competences_panel1941 = new Lino.VBorderPanel({ "autoScroll": false, "listeners": { "activate": Lino.on_tab_activate }, "border": false, "title": "Kompetenzen", "hideCheckBoxLabels": true, "items": [ competences_1_panel1929, competences_2_panel1939 ], "frame": true, "bodyBorder": false, "labelAlign": "top" });
    var notes_NotesByProject_grid2204 = new Lino.notes.NotesByProject.GridPanel({ "flex": 5, "hide_top_toolbar": true, "containing_panel": this, "region": "north", "preview_limit": 15, "master_panel": this, "split": true, "tools": [ Lino.show_in_own_window_button(Lino.notes.NotesByProject.grid) ] });
    var ExcerptsByProject_htmlbox2205 = new Lino.HtmlBoxPanel({ "flex": 3, "layout": "fit", "name": "ExcerptsByProject", "containing_panel": this, "items": new Ext.BoxComponent({autoScroll:true}), "region": "center", "title": "Bestehende Ausz\u00fcge", "master_panel": this, "value": "<br/>", "always_enabled": true, "bodyStyle": "overflow-x:hidden;", "split": true, "tools": [ Lino.show_in_own_window_button(Lino.excerpts.ExcerptsByProject.grid) ] });
    var history_panel2206 = new Lino.VBorderPanel({ "autoScroll": false, "listeners": { "activate": Lino.on_tab_activate }, "border": false, "labelWidth": 171, "title": "Historie", "hideCheckBoxLabels": true, "items": [ notes_NotesByProject_grid2204, ExcerptsByProject_htmlbox2205 ], "frame": true, "bodyBorder": false, "labelAlign": "top" });
    var cal_EventsByClient_grid2212 = new Lino.cal.EventsByClient.GridPanel({ "flex": 5, "hide_top_toolbar": true, "containing_panel": this, "region": "north", "params_panel_hidden": true, "master_panel": this, "preview_limit": 15, "split": true, "tools": [ Lino.show_in_own_window_button(Lino.cal.EventsByClient.grid) ] });
    var cal_TasksByProject_grid2233 = new Lino.cal.TasksByProject.GridPanel({ "flex": 5, "hide_top_toolbar": true, "containing_panel": this, "region": "center", "params_panel_hidden": true, "master_panel": this, "preview_limit": 15, "split": true, "tools": [ Lino.show_in_own_window_button(Lino.cal.TasksByProject.grid) ] });
    var calendar_panel2234 = new Lino.VBorderPanel({ "autoScroll": false, "listeners": { "activate": Lino.on_tab_activate }, "border": false, "title": "Kalender", "hideCheckBoxLabels": true, "items": [ cal_EventsByClient_grid2212, cal_TasksByProject_grid2233 ], "frame": true, "bodyBorder": false, "labelAlign": "top" });
    var activity2235 = new Lino.RemoteComboFieldElement({ "autoHeight": true, "fieldLabel": "Beruf", "name": "activity", "pageSize": 20, "emptyText": "Beruf ausw\u00e4hlen...", "selectOnFocus": true, "hiddenName": "activityHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/pcsw/Clients/activity", "method": "GET" }) }) });
    var client_state2236 = new Lino.ChoicesFieldElement({ "autoHeight": true, "forceSelection": true, "fieldLabel": "Zustand", "allowBlank": false, "hiddenName": "client_stateHidden", "selectOnFocus": true, "anchor": "-20", "store": Lino.pcsw.ClientStates, "name": "client_state" });
    var noble_condition2237 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Adelstitel</span>", "name": "noble_condition", "maxLength": 50, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Adelstitel","The eventual noble condition of this person. Imported from TIM.") }, "anchor": "-20" });
    var unavailable_until2238 = new Lino.DateField({ "selectOnFocus": true, "autoHeight": true, "fieldLabel": "Nicht verf\u00fcgbar bis", "anchor": "-20", "name": "unavailable_until" });
    var unavailable_why2239 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Grund", "name": "unavailable_why", "maxLength": 100, "selectOnFocus": true, "anchor": "-20" });
    var misc_1_panel2240 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 180, "hideCheckBoxLabels": true, "items": [ { "flex": 20, "autoHeight": true, "layout": "form", "xtype": "panel", "items": activity2235, "labelAlign": "top" }, { "flex": 12, "autoHeight": true, "layout": "form", "xtype": "panel", "items": client_state2236, "labelAlign": "top" }, { "flex": 21, "autoHeight": true, "layout": "form", "xtype": "panel", "items": noble_condition2237, "labelAlign": "top" }, { "flex": 15, "autoHeight": true, "layout": "form", "xtype": "panel", "items": unavailable_until2238, "labelAlign": "top" }, { "flex": 30, "autoHeight": true, "layout": "form", "xtype": "panel", "items": unavailable_why2239, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var is_cpas2246 = new Ext.form.Checkbox({ "boxLabel": "Sozialhilfeempf\u00e4nger", "autoHeight": true, "hideLabel": true, "checked": false, "name": "is_cpas", "selectOnFocus": true, "anchor": "-20" });
    var is_senior2247 = new Ext.form.Checkbox({ "boxLabel": "Altenheim", "autoHeight": true, "hideLabel": true, "checked": false, "name": "is_senior", "selectOnFocus": true, "anchor": "-20" });
    var is_obsolete2248 = new Ext.form.Checkbox({ "autoHeight": true, "hideLabel": true, "checked": false, "name": "is_obsolete", "listeners": { "render": Lino.quicktip_renderer("veraltet","Altf\u00e4lle sind Partner, deren Stammdaten nicht mehr gepflegt werden und \nf\u00fcr neue Operationen nicht benutzt werden k\u00f6nnen.") }, "boxLabel": "veraltet", "selectOnFocus": true, "anchor": "-20" });
    var misc_2_panel2249 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 189, "hideCheckBoxLabels": true, "items": [ { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": is_cpas2246, "labelAlign": "top" }, { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": is_senior2247, "labelAlign": "top" }, { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": is_obsolete2248, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var created2253 = new Ext.form.DisplayField({ "disabled": true, "autoHeight": true, "fieldLabel": "Erstellt", "name": "created", "anchor": "-20", "value": "<br>" });
    var modified2254 = new Ext.form.DisplayField({ "disabled": true, "autoHeight": true, "fieldLabel": "Bearbeitet", "name": "modified", "anchor": "-20", "value": "<br>" });
    var misc_3_panel2255 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 99, "hideCheckBoxLabels": true, "items": [ { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": created2253, "labelAlign": "top" }, { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": modified2254, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var remarks2258 = new Ext.form.TextArea({ "selectOnFocus": true, "fieldLabel": "Bemerkungen", "anchor": "-20 -10", "growMax": 2000, "name": "remarks" });
    var remarks22259 = new Ext.form.TextArea({ "selectOnFocus": true, "fieldLabel": "Bemerkungen (Sozialsekretariat)", "anchor": "-20 -10", "growMax": 2000, "name": "remarks2" });
    var misc_4_panel2260 = new Ext.Panel({ "flex": 38, "border": false, "layout": "hbox", "labelWidth": 288, "hideCheckBoxLabels": true, "items": [ { "items": remarks2258, "labelAlign": "top", "layout": "form", "xtype": "panel", "flex": 50 }, { "items": remarks22259, "labelAlign": "top", "layout": "form", "xtype": "panel", "flex": 50 } ], "autoScroll": false, "layoutConfig": { "align": "stretch" }, "frame": false, "labelAlign": "top" });
    var contacts_RolesByPerson_grid2263 = new Lino.contacts.RolesByPerson.GridPanel({ "flex": 38, "hide_top_toolbar": true, "containing_panel": this, "tools": [ Lino.show_in_own_window_button(Lino.contacts.RolesByPerson.grid) ], "preview_limit": 15, "master_panel": this });
    var misc_panel2264 = new Ext.Panel({ "layout": "vbox", "title": "Sonstiges", "items": [ misc_1_panel2240, misc_2_panel2249, misc_3_panel2255, misc_4_panel2260, contacts_RolesByPerson_grid2263 ], "frame": true, "layoutConfig": { "align": "stretch" }, "hideCheckBoxLabels": true, "listeners": { "activate": Lino.on_tab_activate }, "autoScroll": false, "border": false, "bodyBorder": false, "labelAlign": "top" });
    var cbss_identify_person_disp2265 = new Ext.form.DisplayField({ "disabled": true, "autoHeight": true, "fieldLabel": "IdentifyPerson-Anfragen", "name": "cbss_identify_person", "anchor": "-20", "value": "<br/>", "always_enabled": true });
    var cbss_manage_access_disp2266 = new Ext.form.DisplayField({ "disabled": true, "autoHeight": true, "fieldLabel": "ManageAccess-Anfragen", "name": "cbss_manage_access", "anchor": "-20", "value": "<br/>", "always_enabled": true });
    var cbss_retrieve_ti_groups_disp2267 = new Ext.form.DisplayField({ "disabled": true, "autoHeight": true, "fieldLabel": "Tx25-Anfragen", "name": "cbss_retrieve_ti_groups", "anchor": "-20", "value": "<br/>", "always_enabled": true });
    var cbss_1_panel2268 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 216, "hideCheckBoxLabels": true, "items": [ { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": cbss_identify_person_disp2265, "labelAlign": "top" }, { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": cbss_manage_access_disp2266, "labelAlign": "top" }, { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": cbss_retrieve_ti_groups_disp2267, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var cbss_summary_htmlbox2272 = new Lino.HtmlBoxPanel({ "flex": 50, "layout": "fit", "name": "cbss_summary", "containing_panel": this, "items": new Ext.BoxComponent({autoScroll:true}), "title": "Zusammenfassung ZDSS", "value": "<br/>", "always_enabled": true, "bodyStyle": "overflow-x:hidden;" });
    var cbss_panel2273 = new Ext.Panel({ "layout": "vbox", "title": "ZDSS", "items": [ cbss_1_panel2268, cbss_summary_htmlbox2272 ], "frame": true, "layoutConfig": { "align": "stretch" }, "hideCheckBoxLabels": true, "listeners": { "activate": Lino.on_tab_activate }, "autoScroll": false, "labelWidth": 189, "border": false, "bodyBorder": false, "labelAlign": "top" });
    var main_panel2277 = new Ext.TabPanel({ "hideCheckBoxLabels": true, "border": false, "split": true, "autoScroll": false, "items": [ general_panel1615, contact_panel1623, coaching_panel1667, aids_tab_panel1731, work_tab_1_panel1759, career_panel1868, competences_panel1941, history_panel2206, calendar_panel2234, misc_panel2264, cbss_panel2273 ], "activeTab": 0, "bodyBorder": false, "frame": true, "labelAlign": "top" });
    this.items = main_panel2277;
    this.before_row_edit = function(record) {
      image_htmlbox1606.refresh();
      reception_AppointmentsByPartner_grid1608.on_master_changed();
      reception_CoachingsByClient_grid1613.on_master_changed();
      SimilarPersons_htmlbox1616.refresh();
      LinksByHuman_htmlbox1617.refresh();
      cbss_relations_htmlbox1618.refresh();
      MembersByPerson_htmlbox1620.refresh();
      households_SiblingsByPerson_grid1621.on_master_changed();
      pcsw_ContactsByClient_grid1656.on_master_changed();
      pcsw_CoachingsByClient_grid1665.on_master_changed();
      sepa_AccountsByClient_grid1703.on_master_changed();
      aids_GrantingsByClient_grid1730.on_master_changed();
      UploadsByClient_htmlbox1757.refresh();
      notes_NotesByProject_grid2204.on_master_changed();
      ExcerptsByProject_htmlbox2205.refresh();
      cal_EventsByClient_grid2212.on_master_changed();
      cal_TasksByProject_grid2233.on_master_changed();
      contacts_RolesByPerson_grid2263.on_master_changed();
      cbss_summary_htmlbox2272.refresh();
    }
    Lino.pcsw.Clients.DetailFormPanel.superclass.initComponent.call(this);
    // active_fields:
  }
});


Lino.about.Models.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  disable_editing: true,
  initComponent : function() {
    var app_disp2718 = new Ext.form.DisplayField({ "disabled": true, "autoHeight": true, "fieldLabel": "app_label", "name": "app", "anchor": "-20", "value": "<br/>", "always_enabled": true });
    var name_disp2719 = new Ext.form.DisplayField({ "disabled": true, "autoHeight": true, "fieldLabel": "name", "name": "name", "anchor": "-20", "value": "<br/>", "always_enabled": true });
    var docstring_disp2720 = new Ext.form.DisplayField({ "disabled": true, "autoHeight": true, "fieldLabel": "docstring", "name": "docstring", "anchor": "-20", "value": "<br/>", "always_enabled": true });
    var rows2721 = new Ext.form.NumberField({ "disabled": true, "autoHeight": true, "fieldLabel": "Zeilen", "anchor": "-20", "name": "rows" });
    var main_1_panel2722 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 90, "hideCheckBoxLabels": true, "items": [ { "flex": 31, "autoHeight": true, "layout": "form", "xtype": "panel", "items": app_disp2718, "labelAlign": "top" }, { "flex": 31, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_disp2719, "labelAlign": "top" }, { "flex": 31, "autoHeight": true, "layout": "form", "xtype": "panel", "items": docstring_disp2720, "labelAlign": "top" }, { "flex": 5, "autoHeight": true, "layout": "form", "xtype": "panel", "items": rows2721, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var about_FieldsByModel_grid2731 = new Lino.about.FieldsByModel.GridPanel({ "flex": 62, "hide_top_toolbar": true, "containing_panel": this, "tools": [ Lino.show_in_own_window_button(Lino.about.FieldsByModel.grid) ], "preview_limit": 15, "master_panel": this });
    var main_panel2732 = new Ext.Panel({ "autoScroll": false, "border": false, "layout": "vbox", "hideCheckBoxLabels": true, "items": [ main_1_panel2722, about_FieldsByModel_grid2731 ], "frame": true, "layoutConfig": { "align": "stretch" }, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel2732;
    this.before_row_edit = function(record) {
      about_FieldsByModel_grid2731.on_master_changed();
    }
    Lino.about.Models.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.notes.Notes.InsertFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  autoHeight: true,
  content_type: 107,
  initComponent : function() {
    var event_type1425 = new Lino.TwinCombo({ "autoHeight": true, "fieldLabel": "Ereignisart (Form)", "name": "event_type", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.notes.EventTypes.detail,Lino.notes.EventTypes.insert)}, "emptyText": "Event Type ausw\u00e4hlen...", "selectOnFocus": true, "hiddenName": "event_typeHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/notes/Notes/event_type", "method": "GET" }) }) });
    var type1426 = new Lino.TwinCombo({ "autoHeight": true, "fieldLabel": "Notizart (Inhalt)", "name": "type", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.notes.NoteTypes.detail,Lino.notes.NoteTypes.insert)}, "emptyText": "Notizart ausw\u00e4hlen...", "selectOnFocus": true, "hiddenName": "typeHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/notes/Notes/type", "method": "GET" }) }) });
    var main_1_panel1427 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": event_type1425, "labelAlign": "top" }, { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": type1426, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 171, "border": false, "anchor": "-20", "labelAlign": "top" });
    var subject1430 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Betreff", "name": "subject", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var project1431 = new Lino.TwinCombo({ "preferred_width": 20, "autoHeight": true, "fieldLabel": "Klient", "name": "project", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.pcsw.Clients.detail,Lino.pcsw.Clients.insert)}, "hiddenName": "projectHidden", "selectOnFocus": true, "emptyText": "Klient ausw\u00e4hlen...", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/notes/Notes/project", "method": "GET" }) }) });
    var main_panel1432 = new Ext.Panel({ "hideCheckBoxLabels": true, "autoHeight": true, "border": false, "layout": "form", "labelWidth": 72, "autoScroll": false, "items": [ main_1_panel1427, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": subject1430, "anchor": "-20", "labelAlign": "top" }, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": project1431, "anchor": "-20", "labelAlign": "top" } ], "frame": true, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel1432;
    this.before_row_edit = function(record) {
    }
    Lino.notes.Notes.InsertFormPanel.superclass.initComponent.call(this);
  }
});


Lino.cal.EventsByDay.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 37,
  initComponent : function() {
    var event_type294 = new Lino.TwinCombo({ "autoHeight": true, "fieldLabel": "Ereignisart", "name": "event_type", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.cal.EventTypes.detail,Lino.cal.EventTypes.insert)}, "emptyText": "Ereignisart ausw\u00e4hlen...", "selectOnFocus": true, "hiddenName": "event_typeHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/Events/event_type", "method": "GET" }) }) });
    var summary295 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Kurzbeschreibung", "name": "summary", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var project296 = new Lino.TwinCombo({ "preferred_width": 20, "autoHeight": true, "fieldLabel": "Klient", "name": "project", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.pcsw.Clients.detail,Lino.pcsw.Clients.insert)}, "hiddenName": "projectHidden", "selectOnFocus": true, "emptyText": "Klient ausw\u00e4hlen...", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/Events/project", "method": "GET" }) }) });
    var general_1_panel297 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 153, "hideCheckBoxLabels": true, "items": [ { "flex": 32, "autoHeight": true, "layout": "form", "xtype": "panel", "items": event_type294, "labelAlign": "top" }, { "flex": 34, "autoHeight": true, "layout": "form", "xtype": "panel", "items": summary295, "labelAlign": "top" }, { "flex": 32, "autoHeight": true, "layout": "form", "xtype": "panel", "items": project296, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var start_date301 = new Lino.DateField({ "selectOnFocus": true, "autoHeight": true, "fieldLabel": "Beginnt am", "anchor": "-20", "name": "start_date" });
    var start_time302 = new Lino.TimeField({ "selectOnFocus": true, "autoHeight": true, "fieldLabel": "Beginnt um", "anchor": "-20", "name": "start_time" });
    var start_panel303 = new Ext.Panel({ "flex": 25, "autoHeight": true, "layout": "hbox", "items": [ { "flex": 61, "autoHeight": true, "layout": "form", "xtype": "panel", "items": start_date301, "labelAlign": "top" }, { "flex": 38, "autoHeight": true, "layout": "form", "xtype": "panel", "items": start_time302, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "autoScroll": false, "hideCheckBoxLabels": true, "labelWidth": 99, "border": false, "labelAlign": "top" });
    var end_date306 = new Lino.DateField({ "selectOnFocus": true, "autoHeight": true, "fieldLabel": "Endet am", "anchor": "-20", "name": "end_date" });
    var end_time307 = new Lino.TimeField({ "selectOnFocus": true, "autoHeight": true, "fieldLabel": "Endet um", "anchor": "-20", "name": "end_time" });
    var end_panel308 = new Ext.Panel({ "flex": 25, "autoHeight": true, "layout": "hbox", "items": [ { "flex": 61, "autoHeight": true, "layout": "form", "xtype": "panel", "items": end_date306, "labelAlign": "top" }, { "flex": 38, "autoHeight": true, "layout": "form", "xtype": "panel", "items": end_time307, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "autoScroll": false, "hideCheckBoxLabels": true, "labelWidth": 81, "border": false, "labelAlign": "top" });
    var user311 = new Lino.TwinCombo({ "preferred_width": 15, "autoHeight": true, "fieldLabel": "Verwaltet durch", "name": "user", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.users.Users.detail,Lino.users.Users.insert)}, "hiddenName": "userHidden", "selectOnFocus": true, "emptyText": "Benutzer ausw\u00e4hlen...", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/Events/user", "method": "GET" }) }) });
    var assigned_to312 = new Lino.TwinCombo({ "preferred_width": 15, "autoHeight": true, "fieldLabel": "Zugewiesen zu", "name": "assigned_to", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.users.Users.detail,Lino.users.Users.insert)}, "hiddenName": "assigned_toHidden", "selectOnFocus": true, "emptyText": "Benutzer ausw\u00e4hlen...", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/Events/assigned_to", "method": "GET" }) }) });
    var general_2_panel313 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 144, "hideCheckBoxLabels": true, "items": [ start_panel303, end_panel308, { "flex": 24, "autoHeight": true, "layout": "form", "xtype": "panel", "items": user311, "labelAlign": "top" }, { "flex": 24, "autoHeight": true, "layout": "form", "xtype": "panel", "items": assigned_to312, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var room316 = new Lino.TwinCombo({ "autoHeight": true, "fieldLabel": "Raum", "name": "room", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.cal.Rooms.detail,Lino.cal.Rooms.insert)}, "emptyText": "Raum ausw\u00e4hlen...", "selectOnFocus": true, "hiddenName": "roomHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/Events/room", "method": "GET" }) }) });
    var priority317 = new Lino.RemoteComboFieldElement({ "autoHeight": true, "fieldLabel": "Priorit\u00e4t", "name": "priority", "pageSize": 20, "emptyText": "Priorit\u00e4t ausw\u00e4hlen...", "selectOnFocus": true, "hiddenName": "priorityHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/Events/priority", "method": "GET" }) }) });
    var access_class318 = new Lino.ChoicesFieldElement({ "autoHeight": true, "forceSelection": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Zugriffsklasse</span>", "name": "access_class", "hiddenName": "access_classHidden", "listeners": { "render": Lino.quicktip_renderer("Zugriffsklasse","Ob dieser Termin  privat, \u00f6ffentlich oder halb \u00f6ffentlich ist") }, "selectOnFocus": true, "anchor": "-20", "store": [['','<br>']].concat(Lino.cal.AccessClasses) });
    var transparent319 = new Ext.form.Checkbox({ "autoHeight": true, "hideLabel": true, "checked": false, "name": "transparent", "listeners": { "render": Lino.quicktip_renderer("nicht blockierend","Dieser Termin l\u00e4sst auch andere Termine zur gleichen Zeit zu.") }, "boxLabel": "nicht blockierend", "selectOnFocus": true, "anchor": "-20" });
    var general_3_panel320 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 162, "hideCheckBoxLabels": true, "items": [ { "flex": 23, "autoHeight": true, "layout": "form", "xtype": "panel", "items": room316, "labelAlign": "top" }, { "flex": 23, "autoHeight": true, "layout": "form", "xtype": "panel", "items": priority317, "labelAlign": "top" }, { "flex": 40, "autoHeight": true, "layout": "form", "xtype": "panel", "items": access_class318, "labelAlign": "top" }, { "flex": 11, "autoHeight": true, "layout": "form", "xtype": "panel", "items": transparent319, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var owner_disp325 = new Ext.form.DisplayField({ "disabled": true, "autoHeight": true, "fieldLabel": "Verkn\u00fcpft mit", "anchor": "-20", "name": "owner" });
    var workflow_buttons_disp326 = new Ext.form.DisplayField({ "disabled": true, "autoHeight": true, "fieldLabel": "Arbeitsablauf", "name": "workflow_buttons", "anchor": "-20", "value": "<br/>", "always_enabled": true });
    var general_4_panel327 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 126, "hideCheckBoxLabels": true, "items": [ { "flex": 25, "autoHeight": true, "layout": "form", "xtype": "panel", "items": owner_disp325, "labelAlign": "top" }, { "flex": 75, "autoHeight": true, "layout": "form", "xtype": "panel", "items": workflow_buttons_disp326, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var description330 = new Ext.form.TextArea({ "selectOnFocus": true, "fieldLabel": "Beschreibung", "anchor": "-20 -10", "growMax": 2000, "name": "description" });
    var GuestsByEvent_grid427 = new Lino.cal.GuestsByEvent.GridPanel({ "flex": 53, "hide_top_toolbar": true, "containing_panel": this, "tools": [ Lino.show_in_own_window_button(Lino.cal.GuestsByEvent.grid) ], "preview_limit": 15, "master_panel": this });
    var general_5_panel428 = new Ext.Panel({ "flex": 45, "border": false, "layout": "hbox", "labelWidth": 117, "hideCheckBoxLabels": true, "items": [ { "items": description330, "labelAlign": "top", "layout": "form", "xtype": "panel", "flex": 46 }, GuestsByEvent_grid427 ], "autoScroll": false, "layoutConfig": { "align": "stretch" }, "frame": false, "labelAlign": "top" });
    var general_panel430 = new Ext.Panel({ "layout": "vbox", "title": "Allgemein", "items": [ general_1_panel297, general_2_panel313, general_3_panel320, general_4_panel327, general_5_panel428 ], "frame": true, "layoutConfig": { "align": "stretch" }, "hideCheckBoxLabels": true, "listeners": { "activate": Lino.on_tab_activate }, "autoScroll": false, "border": false, "bodyBorder": false, "labelAlign": "top" });
    var id431 = new Ext.form.NumberField({ "selectOnFocus": true, "autoHeight": true, "fieldLabel": "ID", "anchor": "-20", "name": "id" });
    var created432 = new Ext.form.DisplayField({ "disabled": true, "autoHeight": true, "fieldLabel": "Erstellt", "name": "created", "anchor": "-20", "value": "<br>" });
    var modified433 = new Ext.form.DisplayField({ "disabled": true, "autoHeight": true, "fieldLabel": "Bearbeitet", "name": "modified", "anchor": "-20", "value": "<br>" });
    var state434 = new Lino.ChoicesFieldElement({ "autoHeight": true, "forceSelection": true, "fieldLabel": "Zustand", "allowBlank": false, "hiddenName": "stateHidden", "selectOnFocus": true, "anchor": "-20", "store": Lino.cal.EventStates, "name": "state" });
    var more_1_panel435 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 99, "hideCheckBoxLabels": true, "items": [ { "flex": 8, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id431, "labelAlign": "top" }, { "flex": 32, "autoHeight": true, "layout": "form", "xtype": "panel", "items": created432, "labelAlign": "top" }, { "flex": 32, "autoHeight": true, "layout": "form", "xtype": "panel", "items": modified433, "labelAlign": "top" }, { "flex": 27, "autoHeight": true, "layout": "form", "xtype": "panel", "items": state434, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var outbox_MailsByController_grid440 = new Lino.outbox.MailsByController.GridPanel({ "flex": 83, "hide_top_toolbar": true, "containing_panel": this, "tools": [ Lino.show_in_own_window_button(Lino.outbox.MailsByController.grid) ], "preview_limit": 15, "master_panel": this });
    var more_panel441 = new Ext.Panel({ "layout": "vbox", "title": "Mehr", "items": [ more_1_panel435, outbox_MailsByController_grid440 ], "frame": true, "layoutConfig": { "align": "stretch" }, "hideCheckBoxLabels": true, "listeners": { "activate": Lino.on_tab_activate }, "autoScroll": false, "border": false, "bodyBorder": false, "labelAlign": "top" });
    var main_panel442 = new Ext.TabPanel({ "hideCheckBoxLabels": true, "border": false, "split": true, "autoScroll": false, "items": [ general_panel430, more_panel441 ], "activeTab": 0, "bodyBorder": false, "frame": true, "labelAlign": "top" });
    this.items = main_panel442;
    this.before_row_edit = function(record) {
      GuestsByEvent_grid427.on_master_changed();
      outbox_MailsByController_grid440.on_master_changed();
    }
    Lino.cal.EventsByDay.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.cal.EventsByDay.InsertFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  autoHeight: true,
  content_type: 37,
  initComponent : function() {
    var summary443 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Kurzbeschreibung", "name": "summary", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var start_date444 = new Lino.DateField({ "selectOnFocus": true, "autoHeight": true, "fieldLabel": "Beginnt am", "anchor": "-20", "name": "start_date" });
    var start_time445 = new Lino.TimeField({ "selectOnFocus": true, "autoHeight": true, "fieldLabel": "Beginnt um", "anchor": "-20", "name": "start_time" });
    var start_panel446 = new Ext.Panel({ "flex": 50, "autoHeight": true, "layout": "hbox", "items": [ { "flex": 61, "autoHeight": true, "layout": "form", "xtype": "panel", "items": start_date444, "labelAlign": "top" }, { "flex": 38, "autoHeight": true, "layout": "form", "xtype": "panel", "items": start_time445, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "autoScroll": false, "hideCheckBoxLabels": true, "labelWidth": 99, "border": false, "labelAlign": "top" });
    var end_date449 = new Lino.DateField({ "selectOnFocus": true, "autoHeight": true, "fieldLabel": "Endet am", "anchor": "-20", "name": "end_date" });
    var end_time450 = new Lino.TimeField({ "selectOnFocus": true, "autoHeight": true, "fieldLabel": "Endet um", "anchor": "-20", "name": "end_time" });
    var end_panel451 = new Ext.Panel({ "flex": 50, "autoHeight": true, "layout": "hbox", "items": [ { "flex": 61, "autoHeight": true, "layout": "form", "xtype": "panel", "items": end_date449, "labelAlign": "top" }, { "flex": 38, "autoHeight": true, "layout": "form", "xtype": "panel", "items": end_time450, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "autoScroll": false, "hideCheckBoxLabels": true, "labelWidth": 81, "border": false, "labelAlign": "top" });
    var main_2_panel454 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "hideCheckBoxLabels": true, "items": [ start_panel446, end_panel451 ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "anchor": "-20", "labelAlign": "top" });
    var event_type455 = new Lino.TwinCombo({ "autoHeight": true, "fieldLabel": "Ereignisart", "name": "event_type", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.cal.EventTypes.detail,Lino.cal.EventTypes.insert)}, "emptyText": "Ereignisart ausw\u00e4hlen...", "selectOnFocus": true, "hiddenName": "event_typeHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/Events/event_type", "method": "GET" }) }) });
    var project456 = new Lino.TwinCombo({ "preferred_width": 20, "autoHeight": true, "fieldLabel": "Klient", "name": "project", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.pcsw.Clients.detail,Lino.pcsw.Clients.insert)}, "hiddenName": "projectHidden", "selectOnFocus": true, "emptyText": "Klient ausw\u00e4hlen...", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/Events/project", "method": "GET" }) }) });
    var main_3_panel457 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": event_type455, "labelAlign": "top" }, { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": project456, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 108, "border": false, "anchor": "-20", "labelAlign": "top" });
    var main_panel460 = new Ext.Panel({ "hideCheckBoxLabels": true, "autoHeight": true, "border": false, "layout": "form", "labelWidth": 153, "autoScroll": false, "items": [ { "autoHeight": true, "layout": "form", "xtype": "panel", "items": summary443, "anchor": "-20", "labelAlign": "top" }, main_2_panel454, main_3_panel457 ], "frame": true, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel460;
    this.before_row_edit = function(record) {
    }
    Lino.cal.EventsByDay.InsertFormPanel.superclass.initComponent.call(this);
  }
});


Lino.aids.GrantingsByClient.InsertFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  autoHeight: true,
  content_type: 111,
  initComponent : function() {
    var aid_type1717 = new Lino.TwinCombo({ "autoHeight": true, "fieldLabel": "Hilfeart", "allowBlank": false, "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.aids.AidTypes.detail,Lino.aids.AidTypes.insert)}, "emptyText": "Hilfeart ausw\u00e4hlen...", "selectOnFocus": true, "hiddenName": "aid_typeHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/aids/GrantingsByClient/aid_type", "method": "GET" }) }), "name": "aid_type" });
    var board1718 = new Lino.TwinCombo({ "autoHeight": true, "fieldLabel": "Gremium", "name": "board", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.boards.Boards.detail,Lino.boards.Boards.insert)}, "emptyText": "Gremium ausw\u00e4hlen...", "selectOnFocus": true, "hiddenName": "boardHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/aids/GrantingsByClient/board", "method": "GET" }) }) });
    var decision_date1719 = new Lino.DateField({ "selectOnFocus": true, "autoHeight": true, "fieldLabel": "Beschlossen", "anchor": "-20", "name": "decision_date" });
    var main_2_panel1720 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 60, "autoHeight": true, "layout": "form", "xtype": "panel", "items": board1718, "labelAlign": "top" }, { "flex": 39, "autoHeight": true, "layout": "form", "xtype": "panel", "items": decision_date1719, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 108, "border": false, "anchor": "-20", "labelAlign": "top" });
    var start_date1723 = new Lino.DateField({ "autoHeight": true, "fieldLabel": "Laufzeit von", "name": "start_date", "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var end_date1724 = new Lino.DateField({ "selectOnFocus": true, "autoHeight": true, "fieldLabel": "bis", "anchor": "-20", "name": "end_date" });
    var main_3_panel1725 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": start_date1723, "labelAlign": "top" }, { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": end_date1724, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 117, "border": false, "anchor": "-20", "labelAlign": "top" });
    var main_panel1728 = new Ext.Panel({ "hideCheckBoxLabels": true, "autoHeight": true, "border": false, "layout": "form", "labelWidth": 81, "autoScroll": false, "items": [ { "autoHeight": true, "layout": "form", "xtype": "panel", "items": aid_type1717, "anchor": "-20", "labelAlign": "top" }, main_2_panel1720, main_3_panel1725 ], "frame": true, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel1728;
    this.before_row_edit = function(record) {
      board1718.setContextValue('decision_date', record ? record.data['decision_date'] : undefined);
    }
    this.onRender = function(ct, position) {
      decision_date1719.on('change',Lino.chooser_handler(board1718,'decision_date'));
      Lino.aids.GrantingsByClient.InsertFormPanel.superclass.onRender.call(this, ct, position);
    }
    Lino.aids.GrantingsByClient.InsertFormPanel.superclass.initComponent.call(this);
  }
});


Lino.extensible.PanelCalendars.InsertFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  autoHeight: true,
  content_type: 36,
  initComponent : function() {
    var name1514 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Bezeichnung", "name": "name", "maxLength": 200, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var name_fr1515 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Bezeichnung (fr)", "name": "name_fr", "maxLength": 200, "selectOnFocus": true, "hidden": true, "anchor": "-20" });
    var name_nl1516 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Bezeichnung (nl)", "name": "name_nl", "maxLength": 200, "selectOnFocus": true, "hidden": true, "anchor": "-20" });
    var main_1_panel1517 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name1514, "labelAlign": "top" }, { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_fr1515, "hidden": true, "labelAlign": "top" }, { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_nl1516, "hidden": true, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 153, "border": false, "anchor": "-20", "labelAlign": "top" });
    var color1521 = new Ext.form.NumberField({ "autoHeight": true, "fieldLabel": "Farbe", "name": "color", "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var main_panel1522 = new Ext.Panel({ "hideCheckBoxLabels": true, "autoHeight": true, "border": false, "layout": "form", "labelWidth": 54, "autoScroll": false, "items": [ main_1_panel1517, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": color1521, "anchor": "-20", "labelAlign": "top" } ], "frame": true, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel1522;
    this.before_row_edit = function(record) {
    }
    Lino.extensible.PanelCalendars.InsertFormPanel.superclass.initComponent.call(this);
  }
});


Lino.countries.Countries.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 9,
  initComponent : function() {
    var isocode750 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">ISO-Code</span>", "name": "isocode", "boxMinWidth": Lino.chars2width(4), "listeners": { "render": Lino.quicktip_renderer("ISO-Code","        The two-letter code for this country as defined by ISO 3166-1.\n        For countries that no longer exist it may be a 4-letter code.") }, "maxLength": 4, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var name751 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Bezeichnung", "name": "name", "maxLength": 200, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var name_fr752 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Bezeichnung (fr)", "name": "name_fr", "maxLength": 200, "selectOnFocus": true, "hidden": true, "anchor": "-20" });
    var name_nl753 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Bezeichnung (nl)", "name": "name_nl", "maxLength": 200, "selectOnFocus": true, "hidden": true, "anchor": "-20" });
    var short_code754 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Short code</span>", "name": "short_code", "boxMinWidth": Lino.chars2width(4), "listeners": { "render": Lino.quicktip_renderer("Short code","A short abbreviation for regional usage. Obsolete.") }, "maxLength": 4, "selectOnFocus": true, "anchor": "-20" });
    var inscode755 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">INS code</span>", "name": "inscode", "boxMinWidth": Lino.chars2width(3), "listeners": { "render": Lino.quicktip_renderer("INS code","The official code for this country                     used by statbel.fgov.be") }, "maxLength": 3, "selectOnFocus": true, "anchor": "-20" });
    var main_1_panel756 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 153, "hideCheckBoxLabels": true, "items": [ { "flex": 6, "autoHeight": true, "layout": "form", "xtype": "panel", "items": isocode750, "labelAlign": "top" }, { "flex": 27, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name751, "labelAlign": "top" }, { "flex": 27, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_fr752, "hidden": true, "labelAlign": "top" }, { "flex": 27, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_nl753, "hidden": true, "labelAlign": "top" }, { "flex": 6, "autoHeight": true, "layout": "form", "xtype": "panel", "items": short_code754, "labelAlign": "top" }, { "flex": 5, "autoHeight": true, "layout": "form", "xtype": "panel", "items": inscode755, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var countries_PlacesByCountry_grid1140 = new Lino.countries.PlacesByCountry.GridPanel({ "flex": 48, "hide_top_toolbar": true, "containing_panel": this, "tools": [ Lino.show_in_own_window_button(Lino.countries.PlacesByCountry.grid) ], "preview_limit": 15, "master_panel": this });
    var main_2_panel1156 = new Ext.Panel({ "flex": 83, "border": false, "layout": "hbox", "hideCheckBoxLabels": true, "items": [ countries_PlacesByCountry_grid1140 ], "autoScroll": false, "layoutConfig": { "align": "stretch" }, "frame": false, "labelAlign": "top" });
    var main_panel1157 = new Ext.Panel({ "autoScroll": false, "border": false, "layout": "vbox", "hideCheckBoxLabels": true, "items": [ main_1_panel756, main_2_panel1156 ], "frame": true, "layoutConfig": { "align": "stretch" }, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel1157;
    this.before_row_edit = function(record) {
      countries_PlacesByCountry_grid1140.on_master_changed();
    }
    Lino.countries.Countries.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.contacts.Partners.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 20,
  initComponent : function() {
    var overview_disp848 = new Ext.form.DisplayField({ "disabled": true, "flex": 31, "name": "overview", "value": "<br/>", "always_enabled": true });
    var id849 = new Ext.form.NumberField({ "selectOnFocus": true, "autoHeight": true, "fieldLabel": "ID", "anchor": "-20", "name": "id" });
    var language850 = new Lino.ChoicesFieldElement({ "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Sprache</span>", "allowBlank": false, "hiddenName": "languageHidden", "listeners": { "render": Lino.quicktip_renderer("Sprache","Die Sprache, in der Dokumente ausgestellt werden sollen.") }, "selectOnFocus": true, "anchor": "-20", "store": [ [ "de", "Deutsch" ], [ "fr", "Franz\u00f6sisch" ], [ "nl", "Niederl\u00e4ndisch" ] ], "name": "language" });
    var general2_1_panel851 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 20, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id849, "labelAlign": "top" }, { "flex": 80, "autoHeight": true, "layout": "form", "xtype": "panel", "items": language850, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 72, "border": false, "anchor": "-20", "labelAlign": "top" });
    var activity854 = new Lino.RemoteComboFieldElement({ "autoHeight": true, "fieldLabel": "Beruf", "name": "activity", "pageSize": 20, "emptyText": "Beruf ausw\u00e4hlen...", "selectOnFocus": true, "hiddenName": "activityHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/contacts/Partners/activity", "method": "GET" }) }) });
    var client_contact_type855 = new Lino.TwinCombo({ "autoHeight": true, "fieldLabel": "Klientenkontaktart", "name": "client_contact_type", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.pcsw.ClientContactTypes.detail,Lino.pcsw.ClientContactTypes.insert)}, "emptyText": "Klientenkontaktart ausw\u00e4hlen...", "selectOnFocus": true, "hiddenName": "client_contact_typeHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/contacts/Partners/client_contact_type", "method": "GET" }) }) });
    var url856 = new Lino.URLField({ "autoHeight": true, "fieldLabel": "URL", "name": "url", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var general2_panel857 = new Ext.Panel({ "flex": 47, "autoHeight": true, "layout": "form", "items": [ general2_1_panel851, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": activity854, "anchor": "-20", "labelAlign": "top" }, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": client_contact_type855, "anchor": "-20", "labelAlign": "top" }, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": url856, "anchor": "-20", "labelAlign": "top" } ], "frame": true, "bodyBorder": false, "autoScroll": false, "hideCheckBoxLabels": true, "labelWidth": 171, "border": false, "labelAlign": "top" });
    var email861 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "E-Mail", "name": "email", "maxLength": 75, "selectOnFocus": true, "anchor": "-20" });
    var phone862 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Telefon", "name": "phone", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var gsm863 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "GSM", "name": "gsm", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var fax864 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Fax", "name": "fax", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var general3_panel865 = new Ext.Panel({ "flex": 21, "autoHeight": true, "layout": "form", "items": [ { "autoHeight": true, "layout": "form", "xtype": "panel", "items": email861, "anchor": "-20", "labelAlign": "top" }, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": phone862, "anchor": "-20", "labelAlign": "top" }, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": gsm863, "anchor": "-20", "labelAlign": "top" }, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": fax864, "anchor": "-20", "labelAlign": "top" } ], "frame": true, "bodyBorder": false, "autoScroll": false, "hideCheckBoxLabels": true, "labelWidth": 72, "border": false, "labelAlign": "top" });
    var general_1_panel870 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 0, "hideCheckBoxLabels": true, "items": [ overview_disp848, general2_panel857, general3_panel865 ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var reception_AppointmentsByPartner_grid875 = new Lino.reception.AppointmentsByPartner.GridPanel({ "flex": 55, "hide_top_toolbar": true, "containing_panel": this, "tools": [ Lino.show_in_own_window_button(Lino.reception.AppointmentsByPartner.grid) ], "preview_limit": 15, "master_panel": this });
    var general_panel876 = new Ext.Panel({ "layout": "vbox", "title": "Allgemein", "items": [ general_1_panel870, reception_AppointmentsByPartner_grid875 ], "frame": true, "layoutConfig": { "align": "stretch" }, "hideCheckBoxLabels": true, "listeners": { "activate": Lino.on_tab_activate }, "autoScroll": false, "border": false, "bodyBorder": false, "labelAlign": "top" });
    var country877 = new Lino.TwinCombo({ "autoHeight": true, "fieldLabel": "Land", "name": "country", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.countries.Countries.detail,Lino.countries.Countries.insert)}, "emptyText": "Land ausw\u00e4hlen...", "selectOnFocus": true, "hiddenName": "countryHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/contacts/Partners/country", "method": "GET" }) }) });
    var region878 = new Lino.TwinCombo({ "autoHeight": true, "fieldLabel": "Regierungsbezirk", "name": "region", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.countries.Places.detail,Lino.countries.Places.insert)}, "emptyText": "Ort ausw\u00e4hlen...", "selectOnFocus": true, "hiddenName": "regionHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/contacts/Partners/region", "method": "GET" }) }) });
    var city879 = new Lino.TwinCombo({ "autoHeight": true, "forceSelection": false, "fieldLabel": "Stadt", "name": "city", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.countries.Places.detail,Lino.countries.Places.insert)}, "emptyText": "Ort ausw\u00e4hlen...", "selectOnFocus": true, "hiddenName": "cityHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/contacts/Partners/city", "method": "GET" }) }) });
    var zip_code880 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Postleitzahl", "name": "zip_code", "maxLength": 10, "selectOnFocus": true, "boxMinWidth": Lino.chars2width(10), "anchor": "-20" });
    var address_box_1_panel881 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 28, "autoHeight": true, "layout": "form", "xtype": "panel", "items": country877, "labelAlign": "top" }, { "flex": 28, "autoHeight": true, "layout": "form", "xtype": "panel", "items": region878, "labelAlign": "top" }, { "flex": 28, "autoHeight": true, "layout": "form", "xtype": "panel", "items": city879, "labelAlign": "top" }, { "flex": 14, "autoHeight": true, "layout": "form", "xtype": "panel", "items": zip_code880, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 153, "border": false, "anchor": "-20", "labelAlign": "top" });
    var addr1886 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Adresszeile vor Stra\u00dfe</span>", "name": "addr1", "maxLength": 200, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Adresszeile vor Stra\u00dfe","Adresszeile vor Stra\u00dfe") }, "anchor": "-20" });
    var street_prefix887 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Pr\u00e4fix Stra\u00dfe</span>", "name": "street_prefix", "maxLength": 200, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Pr\u00e4fix Stra\u00dfe","Text to print before name of street, but to ignore for sorting.") }, "anchor": "-20" });
    var street888 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Stra\u00dfe</span>", "name": "street", "maxLength": 200, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Stra\u00dfe","Name der Stra\u00dfe, ohne Hausnummer") }, "anchor": "-20" });
    var street_no889 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Nr.</span>", "name": "street_no", "boxMinWidth": Lino.chars2width(10), "listeners": { "render": Lino.quicktip_renderer("Nr.","Hausnummer") }, "maxLength": 10, "selectOnFocus": true, "anchor": "-20" });
    var street_box890 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Box</span>", "name": "street_box", "boxMinWidth": Lino.chars2width(10), "listeners": { "render": Lino.quicktip_renderer("Box","Text to print after street nuber on the same line.") }, "maxLength": 10, "selectOnFocus": true, "anchor": "-20" });
    var address_box_3_panel891 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 30, "autoHeight": true, "layout": "form", "xtype": "panel", "items": street_prefix887, "labelAlign": "top" }, { "flex": 36, "autoHeight": true, "layout": "form", "xtype": "panel", "items": street888, "labelAlign": "top" }, { "flex": 16, "autoHeight": true, "layout": "form", "xtype": "panel", "items": street_no889, "labelAlign": "top" }, { "flex": 16, "autoHeight": true, "layout": "form", "xtype": "panel", "items": street_box890, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 126, "border": false, "anchor": "-20", "labelAlign": "top" });
    var addr2896 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Adresszeile nach Stra\u00dfe</span>", "name": "addr2", "maxLength": 200, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Adresszeile nach Stra\u00dfe","Adresszeile nach Stra\u00dfe") }, "anchor": "-20" });
    var address_box_panel897 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "form", "labelWidth": 216, "hideCheckBoxLabels": true, "items": [ address_box_1_panel881, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": addr1886, "anchor": "-20", "labelAlign": "top" }, address_box_3_panel891, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": addr2896, "anchor": "-20", "labelAlign": "top" } ], "frame": true, "bodyBorder": false, "labelAlign": "top" });
    var remarks900 = new Ext.form.TextArea({ "selectOnFocus": true, "fieldLabel": "Bemerkungen", "anchor": "-20 -10", "growMax": 2000, "name": "remarks" });
    var sepa_AccountsByPartner_grid905 = new Lino.sepa.AccountsByPartner.GridPanel({ "flex": 64, "hide_top_toolbar": true, "containing_panel": this, "tools": [ Lino.show_in_own_window_button(Lino.sepa.AccountsByPartner.grid) ], "preview_limit": 15, "master_panel": this });
    var contact_2_panel906 = new Ext.Panel({ "flex": 55, "border": false, "layout": "hbox", "labelWidth": 108, "hideCheckBoxLabels": true, "items": [ { "items": remarks900, "labelAlign": "top", "layout": "form", "xtype": "panel", "flex": 35 }, sepa_AccountsByPartner_grid905 ], "autoScroll": false, "layoutConfig": { "align": "stretch" }, "frame": false, "labelAlign": "top" });
    var contact_panel908 = new Ext.Panel({ "layout": "vbox", "title": "Kontakt", "items": [ address_box_panel897, contact_2_panel906 ], "frame": true, "layoutConfig": { "align": "stretch" }, "hideCheckBoxLabels": true, "listeners": { "activate": Lino.on_tab_activate }, "autoScroll": false, "border": false, "bodyBorder": false, "labelAlign": "top" });
    var is_obsolete909 = new Ext.form.Checkbox({ "autoHeight": true, "hideLabel": true, "checked": false, "name": "is_obsolete", "listeners": { "render": Lino.quicktip_renderer("veraltet","Altf\u00e4lle sind Partner, deren Stammdaten nicht mehr gepflegt werden und \nf\u00fcr neue Operationen nicht benutzt werden k\u00f6nnen.") }, "boxLabel": "veraltet", "selectOnFocus": true, "anchor": "-20" });
    var is_person910 = new Ext.form.Checkbox({ "boxLabel": "ist eine Person (<a href=\"javascript:Lino.show_mti_child('is_person',Lino.contacts.Persons.detail)\">zeigen</a>)", "autoHeight": true, "hideLabel": true, "name": "is_person", "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("ist eine Person","Ob dieser Partner auch eine Person ist.") }, "anchor": "-20" });
    var is_company911 = new Ext.form.Checkbox({ "boxLabel": "ist eine Organisation (<a href=\"javascript:Lino.show_mti_child('is_company',Lino.contacts.Companies.detail)\">zeigen</a>)", "autoHeight": true, "hideLabel": true, "name": "is_company", "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("ist eine Organisation","Ob dieser Partner auch eine Organisation ist.") }, "anchor": "-20" });
    var is_household912 = new Ext.form.Checkbox({ "boxLabel": "ist ein Haushalt (<a href=\"javascript:Lino.show_mti_child('is_household',Lino.households.Households.detail)\">zeigen</a>)", "autoHeight": true, "hideLabel": true, "name": "is_household", "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("ist ein Haushalt","Whether this Partner is a Household.") }, "anchor": "-20" });
    var created913 = new Ext.form.DisplayField({ "disabled": true, "autoHeight": true, "fieldLabel": "Erstellt", "name": "created", "anchor": "-20", "value": "<br>" });
    var modified914 = new Ext.form.DisplayField({ "disabled": true, "autoHeight": true, "fieldLabel": "Bearbeitet", "name": "modified", "anchor": "-20", "value": "<br>" });
    var misc_1_panel915 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 198, "hideCheckBoxLabels": true, "items": [ { "flex": 13, "autoHeight": true, "layout": "form", "xtype": "panel", "items": is_obsolete909, "labelAlign": "top" }, { "flex": 13, "autoHeight": true, "layout": "form", "xtype": "panel", "items": is_person910, "labelAlign": "top" }, { "flex": 13, "autoHeight": true, "layout": "form", "xtype": "panel", "items": is_company911, "labelAlign": "top" }, { "flex": 13, "autoHeight": true, "layout": "form", "xtype": "panel", "items": is_household912, "labelAlign": "top" }, { "flex": 22, "autoHeight": true, "layout": "form", "xtype": "panel", "items": created913, "labelAlign": "top" }, { "flex": 22, "autoHeight": true, "layout": "form", "xtype": "panel", "items": modified914, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var changes_ChangesByMaster_grid958 = new Lino.changes.ChangesByMaster.GridPanel({ "flex": 83, "hide_top_toolbar": true, "containing_panel": this, "tools": [ Lino.show_in_own_window_button(Lino.changes.ChangesByMaster.grid) ], "preview_limit": 15, "master_panel": this });
    var misc_panel959 = new Ext.Panel({ "layout": "vbox", "title": "Sonstiges", "items": [ misc_1_panel915, changes_ChangesByMaster_grid958 ], "frame": true, "layoutConfig": { "align": "stretch" }, "hideCheckBoxLabels": true, "listeners": { "activate": Lino.on_tab_activate }, "autoScroll": false, "border": false, "bodyBorder": false, "labelAlign": "top" });
    var main_panel1082 = new Ext.TabPanel({ "hideCheckBoxLabels": true, "border": false, "split": true, "autoScroll": false, "items": [ general_panel876, contact_panel908, misc_panel959 ], "activeTab": 0, "bodyBorder": false, "frame": true, "labelAlign": "top" });
    this.items = main_panel1082;
    this.before_row_edit = function(record) {
      reception_AppointmentsByPartner_grid875.on_master_changed();
      region878.setContextValue('country', record ? record.data['countryHidden'] : undefined);
      city879.setContextValue('country', record ? record.data['countryHidden'] : undefined);
      city879.setContextValue('region', record ? record.data['regionHidden'] : undefined);
      sepa_AccountsByPartner_grid905.on_master_changed();
      changes_ChangesByMaster_grid958.on_master_changed();
    }
    this.onRender = function(ct, position) {
      country877.on('change',Lino.chooser_handler(region878,'country'));
      country877.on('change',Lino.chooser_handler(city879,'country'));
      region878.on('change',Lino.chooser_handler(city879,'region'));
      Lino.contacts.Partners.DetailFormPanel.superclass.onRender.call(this, ct, position);
    }
    Lino.contacts.Partners.DetailFormPanel.superclass.initComponent.call(this);
    // active_fields:
    city879.on("change", function(){ this.save() }, this);
    zip_code880.on("change", function(){ this.save() }, this);
  }
});


Lino.households.Households.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 101,
  initComponent : function() {
    var type1524 = new Lino.TwinCombo({ "autoHeight": true, "fieldLabel": "Haushaltsart", "name": "type", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.households.Types.detail,Lino.households.Types.insert)}, "emptyText": "Haushaltsart ausw\u00e4hlen...", "selectOnFocus": true, "hiddenName": "typeHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/households/Households/type", "method": "GET" }) }) });
    var prefix1525 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "prefix", "name": "prefix", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var name1526 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Name", "name": "name", "maxLength": 200, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var id1527 = new Ext.form.NumberField({ "selectOnFocus": true, "autoHeight": true, "fieldLabel": "ID", "anchor": "-20", "name": "id" });
    var general_1_panel1528 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 117, "hideCheckBoxLabels": true, "items": [ { "flex": 29, "autoHeight": true, "layout": "form", "xtype": "panel", "items": type1524, "labelAlign": "top" }, { "flex": 31, "autoHeight": true, "layout": "form", "xtype": "panel", "items": prefix1525, "labelAlign": "top" }, { "flex": 31, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name1526, "labelAlign": "top" }, { "flex": 7, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id1527, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var households_MembersByHousehold_grid1547 = new Lino.households.MembersByHousehold.GridPanel({ "flex": 83, "hide_top_toolbar": true, "containing_panel": this, "tools": [ Lino.show_in_own_window_button(Lino.households.MembersByHousehold.grid) ], "preview_limit": 15, "master_panel": this });
    var general_panel1548 = new Ext.Panel({ "layout": "vbox", "title": "Allgemein", "items": [ general_1_panel1528, households_MembersByHousehold_grid1547 ], "frame": true, "layoutConfig": { "align": "stretch" }, "hideCheckBoxLabels": true, "listeners": { "activate": Lino.on_tab_activate }, "autoScroll": false, "border": false, "bodyBorder": false, "labelAlign": "top" });
    var main_panel1552 = new Ext.TabPanel({ "hideCheckBoxLabels": true, "border": false, "split": true, "autoScroll": false, "items": [ general_panel1548 ], "activeTab": 0, "bodyBorder": false, "frame": true, "labelAlign": "top" });
    this.items = main_panel1552;
    this.before_row_edit = function(record) {
      households_MembersByHousehold_grid1547.on_master_changed();
    }
    Lino.households.Households.DetailFormPanel.superclass.initComponent.call(this);
    // active_fields:
  }
});


Lino.outbox.MyOutbox.InsertFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 25,
  initComponent : function() {
    var project412 = new Lino.TwinCombo({ "preferred_width": 20, "autoHeight": true, "fieldLabel": "Klient", "name": "project", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.pcsw.Clients.detail,Lino.pcsw.Clients.insert)}, "hiddenName": "projectHidden", "selectOnFocus": true, "emptyText": "Klient ausw\u00e4hlen...", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/outbox/Mails/project", "method": "GET" }) }) });
    var subject413 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Betreff", "name": "subject", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var body414 = new Lino.RichTextPanel({ "selectOnFocus": true, "flex": 71, "containing_panel": this, "name": "body", "title": "Inhalt" });
    var main_panel415 = new Ext.Panel({ "autoScroll": false, "border": false, "layout": "vbox", "labelWidth": 72, "hideCheckBoxLabels": true, "items": [ { "items": project412, "autoHeight": true, "layout": "form", "xtype": "panel", "labelAlign": "top" }, { "items": subject413, "autoHeight": true, "layout": "form", "xtype": "panel", "labelAlign": "top" }, body414 ], "frame": true, "layoutConfig": { "align": "stretch" }, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel415;
    this.before_row_edit = function(record) {
      body414.refresh();
    }
    Lino.outbox.MyOutbox.InsertFormPanel.superclass.initComponent.call(this);
  }
});


Lino.addresses.AddressesByPartner.InsertFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  autoHeight: true,
  content_type: 22,
  initComponent : function() {
    var country1327 = new Lino.TwinCombo({ "autoHeight": true, "fieldLabel": "Land", "name": "country", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.countries.Countries.detail,Lino.countries.Countries.insert)}, "emptyText": "Land ausw\u00e4hlen...", "selectOnFocus": true, "hiddenName": "countryHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/addresses/Addresses/country", "method": "GET" }) }) });
    var city1328 = new Lino.TwinCombo({ "autoHeight": true, "forceSelection": false, "fieldLabel": "Stadt", "name": "city", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.countries.Places.detail,Lino.countries.Places.insert)}, "emptyText": "Ort ausw\u00e4hlen...", "selectOnFocus": true, "hiddenName": "cityHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/addresses/Addresses/city", "method": "GET" }) }) });
    var main_1_panel1329 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": country1327, "labelAlign": "top" }, { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": city1328, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 54, "border": false, "anchor": "-20", "labelAlign": "top" });
    var street1332 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Stra\u00dfe</span>", "name": "street", "maxLength": 200, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Stra\u00dfe","Name der Stra\u00dfe, ohne Hausnummer") }, "anchor": "-20" });
    var street_no1333 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Nr.</span>", "name": "street_no", "boxMinWidth": Lino.chars2width(10), "listeners": { "render": Lino.quicktip_renderer("Nr.","Hausnummer") }, "maxLength": 10, "selectOnFocus": true, "anchor": "-20" });
    var street_box1334 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Box</span>", "name": "street_box", "boxMinWidth": Lino.chars2width(10), "listeners": { "render": Lino.quicktip_renderer("Box","Text to print after street nuber on the same line.") }, "maxLength": 10, "selectOnFocus": true, "anchor": "-20" });
    var main_2_panel1335 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 48, "autoHeight": true, "layout": "form", "xtype": "panel", "items": street1332, "labelAlign": "top" }, { "flex": 25, "autoHeight": true, "layout": "form", "xtype": "panel", "items": street_no1333, "labelAlign": "top" }, { "flex": 25, "autoHeight": true, "layout": "form", "xtype": "panel", "items": street_box1334, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 63, "border": false, "anchor": "-20", "labelAlign": "top" });
    var address_type1339 = new Lino.ChoicesFieldElement({ "autoHeight": true, "forceSelection": true, "fieldLabel": "Adressenart", "name": "address_type", "hiddenName": "address_typeHidden", "selectOnFocus": true, "anchor": "-20", "store": [['','<br>']].concat(Lino.addresses.AddressTypes) });
    var remark1340 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Bemerkung", "name": "remark", "maxLength": 50, "selectOnFocus": true, "anchor": "-20" });
    var main_3_panel1341 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 52, "autoHeight": true, "layout": "form", "xtype": "panel", "items": address_type1339, "labelAlign": "top" }, { "flex": 47, "autoHeight": true, "layout": "form", "xtype": "panel", "items": remark1340, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 108, "border": false, "anchor": "-20", "labelAlign": "top" });
    var main_panel1344 = new Ext.Panel({ "hideCheckBoxLabels": true, "autoHeight": true, "border": false, "layout": "form", "autoScroll": false, "items": [ main_1_panel1329, main_2_panel1335, main_3_panel1341 ], "frame": true, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel1344;
    this.before_row_edit = function(record) {
      city1328.setContextValue('country', record ? record.data['countryHidden'] : undefined);
      city1328.setContextValue('region', record ? record.data['regionHidden'] : undefined);
    }
    this.onRender = function(ct, position) {
      country1327.on('change',Lino.chooser_handler(city1328,'country'));
      Lino.addresses.AddressesByPartner.InsertFormPanel.superclass.onRender.call(this, ct, position);
    }
    Lino.addresses.AddressesByPartner.InsertFormPanel.superclass.initComponent.call(this);
  }
});


Lino.aids.RefundConfirmationsByGranting.InsertFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 114,
  initComponent : function() {
    var start_date2690 = new Lino.DateField({ "selectOnFocus": true, "autoHeight": true, "fieldLabel": "Periode vom", "anchor": "-20", "name": "start_date" });
    var end_date2691 = new Lino.DateField({ "selectOnFocus": true, "autoHeight": true, "fieldLabel": "bis", "anchor": "-20", "name": "end_date" });
    var main_1_panel2692 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 108, "hideCheckBoxLabels": true, "items": [ { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": start_date2690, "labelAlign": "top" }, { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": end_date2691, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var doctor_type2695 = new Lino.TwinCombo({ "autoHeight": true, "fieldLabel": "Art des Arztes", "allowBlank": false, "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.pcsw.ClientContactTypes.detail,Lino.pcsw.ClientContactTypes.insert)}, "emptyText": "Klientenkontaktart ausw\u00e4hlen...", "selectOnFocus": true, "hiddenName": "doctor_typeHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/aids/RefundConfirmationsByGranting/doctor_type", "method": "GET" }) }), "name": "doctor_type" });
    var doctor2696 = new Lino.TwinCombo({ "preferred_width": 20, "autoHeight": true, "forceSelection": false, "fieldLabel": "Arzt", "name": "doctor", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.contacts.Persons.detail,Lino.contacts.Persons.insert)}, "hiddenName": "doctorHidden", "selectOnFocus": true, "emptyText": "Person ausw\u00e4hlen...", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/aids/RefundConfirmationsByGranting/doctor", "method": "GET" }) }) });
    var pharmacy2697 = new Lino.TwinCombo({ "preferred_width": 20, "autoHeight": true, "fieldLabel": "Apotheke", "name": "pharmacy", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.contacts.Companies.detail,Lino.contacts.Companies.insert)}, "hiddenName": "pharmacyHidden", "selectOnFocus": true, "emptyText": "Organisation ausw\u00e4hlen...", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/aids/RefundConfirmationsByGranting/pharmacy", "method": "GET" }) }) });
    var main_2_panel2698 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 135, "hideCheckBoxLabels": true, "items": [ { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": doctor_type2695, "labelAlign": "top" }, { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": doctor2696, "labelAlign": "top" }, { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": pharmacy2697, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var company2702 = new Lino.TwinCombo({ "preferred_width": 20, "autoHeight": true, "fieldLabel": "Empf\u00e4nger (Organisation)", "name": "company", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.contacts.Companies.detail,Lino.contacts.Companies.insert)}, "hiddenName": "companyHidden", "selectOnFocus": true, "emptyText": "Organisation ausw\u00e4hlen...", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/aids/RefundConfirmationsByGranting/company", "method": "GET" }) }) });
    var contact_person2703 = new Lino.TwinCombo({ "preferred_width": 20, "autoHeight": true, "fieldLabel": "Empf\u00e4nger (Person)", "name": "contact_person", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.contacts.Persons.detail,Lino.contacts.Persons.insert)}, "hiddenName": "contact_personHidden", "selectOnFocus": true, "emptyText": "Person ausw\u00e4hlen...", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/aids/RefundConfirmationsByGranting/contact_person", "method": "GET" }) }) });
    var printed_disp2704 = new Ext.form.DisplayField({ "disabled": true, "autoHeight": true, "fieldLabel": "Ausgedruckt", "name": "printed", "anchor": "-20", "value": "<br/>", "always_enabled": true });
    var main_3_panel2705 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 225, "hideCheckBoxLabels": true, "items": [ { "flex": 28, "autoHeight": true, "layout": "form", "xtype": "panel", "items": company2702, "labelAlign": "top" }, { "flex": 28, "autoHeight": true, "layout": "form", "xtype": "panel", "items": contact_person2703, "labelAlign": "top" }, { "flex": 42, "autoHeight": true, "layout": "form", "xtype": "panel", "items": printed_disp2704, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var remark2709 = new Lino.RichTextPanel({ "selectOnFocus": true, "flex": 50, "containing_panel": this, "name": "remark", "title": "Bemerkung" });
    var main_panel2710 = new Ext.Panel({ "autoScroll": false, "border": false, "layout": "vbox", "labelWidth": 0, "hideCheckBoxLabels": true, "items": [ main_1_panel2692, main_2_panel2698, main_3_panel2705, remark2709 ], "frame": true, "layoutConfig": { "align": "stretch" }, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel2710;
    this.before_row_edit = function(record) {
      doctor2696.setContextValue('doctor_type', record ? record.data['doctor_typeHidden'] : undefined);
      var bp = this.get_base_params();
      pharmacy2697.setContextValue('mk',bp['mk']);
      pharmacy2697.setContextValue('mt',bp['mt']);
      contact_person2703.setContextValue('company', record ? record.data['companyHidden'] : undefined);
      remark2709.refresh();
    }
    this.onRender = function(ct, position) {
      doctor_type2695.on('change',Lino.chooser_handler(doctor2696,'doctor_type'));
      company2702.on('change',Lino.chooser_handler(contact_person2703,'company'));
      Lino.aids.RefundConfirmationsByGranting.InsertFormPanel.superclass.onRender.call(this, ct, position);
    }
    Lino.aids.RefundConfirmationsByGranting.InsertFormPanel.superclass.initComponent.call(this);
  }
});


Lino.aids.GrantingsByX.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 111,
  initComponent : function() {
    var id173 = new Ext.form.NumberField({ "selectOnFocus": true, "autoHeight": true, "fieldLabel": "ID", "anchor": "-20", "name": "id" });
    var client174 = new Lino.TwinCombo({ "preferred_width": 20, "autoHeight": true, "fieldLabel": "Klient", "allowBlank": false, "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.pcsw.Clients.detail,Lino.pcsw.Clients.insert)}, "emptyText": "Klient ausw\u00e4hlen...", "selectOnFocus": true, "hiddenName": "clientHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/aids/Grantings/client", "method": "GET" }) }), "name": "client" });
    var user175 = new Lino.TwinCombo({ "preferred_width": 15, "autoHeight": true, "fieldLabel": "Autor", "name": "user", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.users.Users.detail,Lino.users.Users.insert)}, "hiddenName": "userHidden", "selectOnFocus": true, "emptyText": "Benutzer ausw\u00e4hlen...", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/aids/Grantings/user", "method": "GET" }) }) });
    var signer176 = new Lino.TwinCombo({ "preferred_width": 15, "autoHeight": true, "fieldLabel": "Best\u00e4tiger", "name": "signer", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.users.Users.detail,Lino.users.Users.insert)}, "hiddenName": "signerHidden", "selectOnFocus": true, "emptyText": "Benutzer ausw\u00e4hlen...", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/aids/Grantings/signer", "method": "GET" }) }) });
    var workflow_buttons_disp177 = new Ext.form.DisplayField({ "disabled": true, "autoHeight": true, "fieldLabel": "Arbeitsablauf", "name": "workflow_buttons", "anchor": "-20", "value": "<br/>", "always_enabled": true });
    var main_1_panel178 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 126, "hideCheckBoxLabels": true, "items": [ { "flex": 5, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id173, "labelAlign": "top" }, { "flex": 21, "autoHeight": true, "layout": "form", "xtype": "panel", "items": client174, "labelAlign": "top" }, { "flex": 21, "autoHeight": true, "layout": "form", "xtype": "panel", "items": user175, "labelAlign": "top" }, { "flex": 21, "autoHeight": true, "layout": "form", "xtype": "panel", "items": signer176, "labelAlign": "top" }, { "flex": 31, "autoHeight": true, "layout": "form", "xtype": "panel", "items": workflow_buttons_disp177, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var board184 = new Lino.TwinCombo({ "autoHeight": true, "fieldLabel": "Gremium", "name": "board", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.boards.Boards.detail,Lino.boards.Boards.insert)}, "emptyText": "Gremium ausw\u00e4hlen...", "selectOnFocus": true, "hiddenName": "boardHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/aids/Grantings/board", "method": "GET" }) }) });
    var decision_date185 = new Lino.DateField({ "selectOnFocus": true, "autoHeight": true, "fieldLabel": "Beschlossen", "anchor": "-20", "name": "decision_date" });
    var main_2_panel186 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 108, "hideCheckBoxLabels": true, "items": [ { "flex": 60, "autoHeight": true, "layout": "form", "xtype": "panel", "items": board184, "labelAlign": "top" }, { "flex": 39, "autoHeight": true, "layout": "form", "xtype": "panel", "items": decision_date185, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var aid_type189 = new Lino.TwinCombo({ "autoHeight": true, "fieldLabel": "Hilfeart", "allowBlank": false, "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.aids.AidTypes.detail,Lino.aids.AidTypes.insert)}, "emptyText": "Hilfeart ausw\u00e4hlen...", "selectOnFocus": true, "hiddenName": "aid_typeHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/aids/Grantings/aid_type", "method": "GET" }) }), "name": "aid_type" });
    var start_date190 = new Lino.DateField({ "autoHeight": true, "fieldLabel": "Laufzeit von", "name": "start_date", "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var end_date191 = new Lino.DateField({ "selectOnFocus": true, "autoHeight": true, "fieldLabel": "bis", "anchor": "-20", "name": "end_date" });
    var custom_actions_disp192 = new Ext.form.DisplayField({ "disabled": true, "autoHeight": true, "fieldLabel": "Aktionen", "name": "custom_actions", "anchor": "-20", "value": "<br/>", "always_enabled": true });
    var main_3_panel193 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 117, "hideCheckBoxLabels": true, "items": [ { "flex": 26, "autoHeight": true, "layout": "form", "xtype": "panel", "items": aid_type189, "labelAlign": "top" }, { "flex": 17, "autoHeight": true, "layout": "form", "xtype": "panel", "items": start_date190, "labelAlign": "top" }, { "flex": 17, "autoHeight": true, "layout": "form", "xtype": "panel", "items": end_date191, "labelAlign": "top" }, { "flex": 39, "autoHeight": true, "layout": "form", "xtype": "panel", "items": custom_actions_disp192, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var aids_ConfirmationsByGranting_grid206 = new Lino.aids.ConfirmationsByGranting.GridPanel({ "flex": 41, "hide_top_toolbar": true, "containing_panel": this, "tools": [ Lino.show_in_own_window_button(Lino.aids.ConfirmationsByGranting.grid) ], "preview_limit": 15, "master_panel": this });
    var main_panel207 = new Ext.Panel({ "autoScroll": false, "border": false, "layout": "vbox", "hideCheckBoxLabels": true, "items": [ main_1_panel178, main_2_panel186, main_3_panel193, aids_ConfirmationsByGranting_grid206 ], "frame": true, "layoutConfig": { "align": "stretch" }, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel207;
    this.before_row_edit = function(record) {
      board184.setContextValue('decision_date', record ? record.data['decision_date'] : undefined);
      aids_ConfirmationsByGranting_grid206.on_master_changed();
    }
    this.onRender = function(ct, position) {
      decision_date185.on('change',Lino.chooser_handler(board184,'decision_date'));
      Lino.aids.GrantingsByX.DetailFormPanel.superclass.onRender.call(this, ct, position);
    }
    Lino.aids.GrantingsByX.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.aids.GrantingsByX.InsertFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  autoHeight: true,
  content_type: 111,
  initComponent : function() {
    var client208 = new Lino.TwinCombo({ "preferred_width": 20, "autoHeight": true, "fieldLabel": "Klient", "allowBlank": false, "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.pcsw.Clients.detail,Lino.pcsw.Clients.insert)}, "emptyText": "Klient ausw\u00e4hlen...", "selectOnFocus": true, "hiddenName": "clientHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/aids/Grantings/client", "method": "GET" }) }), "name": "client" });
    var aid_type209 = new Lino.TwinCombo({ "autoHeight": true, "fieldLabel": "Hilfeart", "allowBlank": false, "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.aids.AidTypes.detail,Lino.aids.AidTypes.insert)}, "emptyText": "Hilfeart ausw\u00e4hlen...", "selectOnFocus": true, "hiddenName": "aid_typeHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/aids/Grantings/aid_type", "method": "GET" }) }), "name": "aid_type" });
    var signer210 = new Lino.TwinCombo({ "preferred_width": 15, "autoHeight": true, "fieldLabel": "Best\u00e4tiger", "name": "signer", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.users.Users.detail,Lino.users.Users.insert)}, "hiddenName": "signerHidden", "selectOnFocus": true, "emptyText": "Benutzer ausw\u00e4hlen...", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/aids/Grantings/signer", "method": "GET" }) }) });
    var main_2_panel211 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": aid_type209, "labelAlign": "top" }, { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": signer210, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 99, "border": false, "anchor": "-20", "labelAlign": "top" });
    var board214 = new Lino.TwinCombo({ "autoHeight": true, "fieldLabel": "Gremium", "name": "board", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.boards.Boards.detail,Lino.boards.Boards.insert)}, "emptyText": "Gremium ausw\u00e4hlen...", "selectOnFocus": true, "hiddenName": "boardHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/aids/Grantings/board", "method": "GET" }) }) });
    var decision_date215 = new Lino.DateField({ "selectOnFocus": true, "autoHeight": true, "fieldLabel": "Beschlossen", "anchor": "-20", "name": "decision_date" });
    var main_3_panel216 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 60, "autoHeight": true, "layout": "form", "xtype": "panel", "items": board214, "labelAlign": "top" }, { "flex": 39, "autoHeight": true, "layout": "form", "xtype": "panel", "items": decision_date215, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 108, "border": false, "anchor": "-20", "labelAlign": "top" });
    var start_date219 = new Lino.DateField({ "autoHeight": true, "fieldLabel": "Laufzeit von", "name": "start_date", "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var end_date220 = new Lino.DateField({ "selectOnFocus": true, "autoHeight": true, "fieldLabel": "bis", "anchor": "-20", "name": "end_date" });
    var main_4_panel221 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": start_date219, "labelAlign": "top" }, { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": end_date220, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 117, "border": false, "anchor": "-20", "labelAlign": "top" });
    var main_panel224 = new Ext.Panel({ "hideCheckBoxLabels": true, "autoHeight": true, "border": false, "layout": "form", "labelWidth": 63, "autoScroll": false, "items": [ { "autoHeight": true, "layout": "form", "xtype": "panel", "items": client208, "anchor": "-20", "labelAlign": "top" }, main_2_panel211, main_3_panel216, main_4_panel221 ], "frame": true, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel224;
    this.before_row_edit = function(record) {
      board214.setContextValue('decision_date', record ? record.data['decision_date'] : undefined);
    }
    this.onRender = function(ct, position) {
      decision_date215.on('change',Lino.chooser_handler(board214,'decision_date'));
      Lino.aids.GrantingsByX.InsertFormPanel.superclass.onRender.call(this, ct, position);
    }
    Lino.aids.GrantingsByX.InsertFormPanel.superclass.initComponent.call(this);
  }
});


Lino.uploads.UploadsByController.InsertFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  autoHeight: true,
  content_type: 24,
  initComponent : function() {
    var file2711 = Lino.file_field_handler(this,{ "autoHeight": true, "fieldLabel": "Datei", "name": "file", "maxLength": 100, "selectOnFocus": true, "anchor": "-20" });
    var type2712 = new Lino.TwinCombo({ "autoHeight": true, "fieldLabel": "Upload-Art", "name": "type", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.uploads.UploadTypes.detail,Lino.uploads.UploadTypes.insert)}, "emptyText": "Upload-Art ausw\u00e4hlen...", "selectOnFocus": true, "hiddenName": "typeHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/uploads/UploadsByController/type", "method": "GET" }) }) });
    var description2713 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Beschreibung", "name": "description", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var main_panel2714 = new Ext.Panel({ "hideCheckBoxLabels": true, "autoHeight": true, "border": false, "layout": "form", "labelWidth": 117, "autoScroll": false, "items": [ { "autoHeight": true, "layout": "form", "xtype": "panel", "items": file2711, "anchor": "-20", "labelAlign": "top" }, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": type2712, "anchor": "-20", "labelAlign": "top" }, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": description2713, "anchor": "-20", "labelAlign": "top" } ], "frame": true, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel2714;
    this.before_row_edit = function(record) {
      type2712.setContextValue('upload_area', record ? record.data['upload_areaHidden'] : undefined);
    }
    Lino.uploads.UploadsByController.InsertFormPanel.superclass.initComponent.call(this);
  }
});


Lino.excerpts.ExcerptsByX.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 45,
  initComponent : function() {
    var id2337 = new Ext.form.NumberField({ "selectOnFocus": true, "autoHeight": true, "fieldLabel": "ID", "anchor": "-20", "name": "id" });
    var excerpt_type2338 = new Lino.TwinCombo({ "autoHeight": true, "fieldLabel": "Auszugsart", "allowBlank": false, "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.excerpts.ExcerptTypes.detail,Lino.excerpts.ExcerptTypes.insert)}, "emptyText": "Auszugsart ausw\u00e4hlen...", "selectOnFocus": true, "hiddenName": "excerpt_typeHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/excerpts/Excerpts/excerpt_type", "method": "GET" }) }), "name": "excerpt_type" });
    var project2339 = new Lino.TwinCombo({ "preferred_width": 20, "autoHeight": true, "fieldLabel": "Klient", "name": "project", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.pcsw.Clients.detail,Lino.pcsw.Clients.insert)}, "hiddenName": "projectHidden", "selectOnFocus": true, "emptyText": "Klient ausw\u00e4hlen...", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/excerpts/Excerpts/project", "method": "GET" }) }) });
    var general_1_panel2340 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 99, "hideCheckBoxLabels": true, "items": [ { "flex": 10, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id2337, "labelAlign": "top" }, { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": excerpt_type2338, "labelAlign": "top" }, { "flex": 40, "autoHeight": true, "layout": "form", "xtype": "panel", "items": project2339, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var user2344 = new Lino.TwinCombo({ "preferred_width": 15, "autoHeight": true, "fieldLabel": "Autor", "name": "user", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.users.Users.detail,Lino.users.Users.insert)}, "hiddenName": "userHidden", "selectOnFocus": true, "emptyText": "Benutzer ausw\u00e4hlen...", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/excerpts/Excerpts/user", "method": "GET" }) }) });
    var build_method2345 = new Lino.ChoicesFieldElement({ "autoHeight": true, "forceSelection": true, "fieldLabel": "Konstruktionsmethode", "allowBlank": false, "hiddenName": "build_methodHidden", "selectOnFocus": true, "anchor": "-20", "store": Lino.lino.BuildMethods, "name": "build_method" });
    var general_2_panel2346 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 189, "hideCheckBoxLabels": true, "items": [ { "flex": 32, "autoHeight": true, "layout": "form", "xtype": "panel", "items": user2344, "labelAlign": "top" }, { "flex": 67, "autoHeight": true, "layout": "form", "xtype": "panel", "items": build_method2345, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var company2349 = new Lino.TwinCombo({ "preferred_width": 20, "autoHeight": true, "fieldLabel": "Empf\u00e4nger (Organisation)", "name": "company", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.contacts.Companies.detail,Lino.contacts.Companies.insert)}, "hiddenName": "companyHidden", "selectOnFocus": true, "emptyText": "Organisation ausw\u00e4hlen...", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/excerpts/Excerpts/company", "method": "GET" }) }) });
    var contact_person2350 = new Lino.TwinCombo({ "preferred_width": 20, "autoHeight": true, "fieldLabel": "Empf\u00e4nger (Person)", "name": "contact_person", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.contacts.Persons.detail,Lino.contacts.Persons.insert)}, "hiddenName": "contact_personHidden", "selectOnFocus": true, "emptyText": "Person ausw\u00e4hlen...", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/excerpts/Excerpts/contact_person", "method": "GET" }) }) });
    var language2351 = new Lino.ChoicesFieldElement({ "autoHeight": true, "fieldLabel": "Sprache", "allowBlank": false, "hiddenName": "languageHidden", "selectOnFocus": true, "anchor": "-20", "store": [ [ "de", "Deutsch" ], [ "fr", "Franz\u00f6sisch" ], [ "nl", "Niederl\u00e4ndisch" ] ], "name": "language" });
    var general_3_panel2352 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 225, "hideCheckBoxLabels": true, "items": [ { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": company2349, "labelAlign": "top" }, { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": contact_person2350, "labelAlign": "top" }, { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": language2351, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var owner_disp2356 = new Ext.form.DisplayField({ "disabled": true, "autoHeight": true, "fieldLabel": "Verkn\u00fcpft mit", "anchor": "-20", "name": "owner" });
    var build_time2357 = new Ext.form.DisplayField({ "disabled": true, "autoHeight": true, "fieldLabel": "Druckdatum", "name": "build_time", "anchor": "-20", "value": "<br>" });
    var general_4_panel2358 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 126, "hideCheckBoxLabels": true, "items": [ { "flex": 38, "autoHeight": true, "layout": "form", "xtype": "panel", "items": owner_disp2356, "labelAlign": "top" }, { "flex": 61, "autoHeight": true, "layout": "form", "xtype": "panel", "items": build_time2357, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var outbox_MailsByController_grid2361 = new Lino.outbox.MailsByController.GridPanel({ "flex": 55, "hide_top_toolbar": true, "containing_panel": this, "tools": [ Lino.show_in_own_window_button(Lino.outbox.MailsByController.grid) ], "preview_limit": 15, "master_panel": this });
    var general_panel2362 = new Ext.Panel({ "layout": "vbox", "title": "Allgemein", "items": [ general_1_panel2340, general_2_panel2346, general_3_panel2352, general_4_panel2358, outbox_MailsByController_grid2361 ], "frame": true, "layoutConfig": { "align": "stretch" }, "hideCheckBoxLabels": true, "listeners": { "activate": Lino.on_tab_activate }, "autoScroll": false, "border": false, "bodyBorder": false, "labelAlign": "top" });
    var body_template_content2363 = new Ext.form.TextArea({ "disabled": true, "listeners": { "activate": Lino.on_tab_activate }, "fieldLabel": "Konfigurierung", "name": "body_template_content", "growMax": 2000, "title": "Konfigurierung" });
    var main_panel2364 = new Ext.TabPanel({ "hideCheckBoxLabels": true, "border": false, "split": true, "autoScroll": false, "items": [ general_panel2362, body_template_content2363 ], "activeTab": 0, "bodyBorder": false, "frame": true, "labelAlign": "top" });
    this.items = main_panel2364;
    this.before_row_edit = function(record) {
      excerpt_type2338.setContextValue('owner', record ? record.data['owner'] : undefined);
      contact_person2350.setContextValue('company', record ? record.data['companyHidden'] : undefined);
      outbox_MailsByController_grid2361.on_master_changed();
    }
    this.onRender = function(ct, position) {
      owner_disp2356.on('change',Lino.chooser_handler(excerpt_type2338,'owner'));
      company2349.on('change',Lino.chooser_handler(contact_person2350,'company'));
      Lino.excerpts.ExcerptsByX.DetailFormPanel.superclass.onRender.call(this, ct, position);
    }
    Lino.excerpts.ExcerptsByX.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.uploads.MyUploads.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 24,
  initComponent : function() {
    var file2535 = Lino.file_field_handler(this,{ "autoHeight": true, "fieldLabel": "Datei", "name": "file", "maxLength": 100, "selectOnFocus": true, "anchor": "-20" });
    var user2536 = new Lino.TwinCombo({ "preferred_width": 15, "autoHeight": true, "fieldLabel": "Autor", "name": "user", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.users.Users.detail,Lino.users.Users.insert)}, "hiddenName": "userHidden", "selectOnFocus": true, "emptyText": "Benutzer ausw\u00e4hlen...", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/uploads/MyUploads/user", "method": "GET" }) }) });
    var main_1_panel2537 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 51, "autoHeight": true, "layout": "form", "xtype": "panel", "items": file2535, "labelAlign": "top" }, { "flex": 48, "autoHeight": true, "layout": "form", "xtype": "panel", "items": user2536, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 54, "border": false, "anchor": "-20", "labelAlign": "top" });
    var upload_area2540 = new Lino.ChoicesFieldElement({ "autoHeight": true, "forceSelection": true, "fieldLabel": "Upload-Bereich", "allowBlank": false, "hiddenName": "upload_areaHidden", "selectOnFocus": true, "anchor": "-20", "store": Lino.uploads.UploadAreas, "name": "upload_area" });
    var type2541 = new Lino.TwinCombo({ "autoHeight": true, "fieldLabel": "Upload-Art", "name": "type", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.uploads.UploadTypes.detail,Lino.uploads.UploadTypes.insert)}, "emptyText": "Upload-Art ausw\u00e4hlen...", "selectOnFocus": true, "hiddenName": "typeHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/uploads/MyUploads/type", "method": "GET" }) }) });
    var description2542 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Beschreibung", "name": "description", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var main_2_panel2543 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 19, "autoHeight": true, "layout": "form", "xtype": "panel", "items": upload_area2540, "labelAlign": "top" }, { "flex": 39, "autoHeight": true, "layout": "form", "xtype": "panel", "items": type2541, "labelAlign": "top" }, { "flex": 41, "autoHeight": true, "layout": "form", "xtype": "panel", "items": description2542, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 135, "border": false, "anchor": "-20", "labelAlign": "top" });
    var owner_disp2547 = new Ext.form.DisplayField({ "disabled": true, "autoHeight": true, "fieldLabel": "Verkn\u00fcpft mit", "anchor": "-20", "name": "owner" });
    var main_panel2548 = new Ext.Panel({ "hideCheckBoxLabels": true, "autoHeight": true, "border": false, "layout": "form", "labelWidth": 126, "autoScroll": false, "items": [ main_1_panel2537, main_2_panel2543, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": owner_disp2547, "anchor": "-20", "labelAlign": "top" } ], "frame": true, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel2548;
    this.before_row_edit = function(record) {
      type2541.setContextValue('upload_area', record ? record.data['upload_areaHidden'] : undefined);
    }
    this.onRender = function(ct, position) {
      upload_area2540.on('change',Lino.chooser_handler(type2541,'upload_area'));
      Lino.uploads.MyUploads.DetailFormPanel.superclass.onRender.call(this, ct, position);
    }
    Lino.uploads.MyUploads.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.users.MySettings.InsertFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  autoHeight: true,
  content_type: 6,
  initComponent : function() {
    var username732 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Benutzername</span>", "name": "username", "listeners": { "render": Lino.quicktip_renderer("Benutzername","Required. Must be unique.") }, "maxLength": 30, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var email733 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "e-mail address", "name": "email", "maxLength": 75, "selectOnFocus": true, "anchor": "-20" });
    var main_1_panel734 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": username732, "labelAlign": "top" }, { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": email733, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 135, "border": false, "anchor": "-20", "labelAlign": "top" });
    var first_name737 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Vorname", "name": "first_name", "maxLength": 30, "selectOnFocus": true, "anchor": "-20" });
    var last_name738 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Familienname", "name": "last_name", "maxLength": 30, "selectOnFocus": true, "anchor": "-20" });
    var main_2_panel739 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": first_name737, "labelAlign": "top" }, { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": last_name738, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 117, "border": false, "anchor": "-20", "labelAlign": "top" });
    var partner742 = new Lino.TwinCombo({ "preferred_width": 20, "autoHeight": true, "fieldLabel": "Partner", "name": "partner", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.contacts.Partners.detail,Lino.contacts.Partners.insert)}, "hiddenName": "partnerHidden", "selectOnFocus": true, "emptyText": "Partner ausw\u00e4hlen...", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/users/Users/partner", "method": "GET" }) }) });
    var language743 = new Lino.ChoicesFieldElement({ "autoHeight": true, "fieldLabel": "Sprache", "name": "language", "selectOnFocus": true, "anchor": "-20", "store": [ [ "de", "Deutsch" ], [ "fr", "Franz\u00f6sisch" ], [ "nl", "Niederl\u00e4ndisch" ] ], "hiddenName": "languageHidden" });
    var profile744 = new Lino.ChoicesFieldElement({ "autoHeight": true, "forceSelection": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Benutzerprofil</span>", "name": "profile", "hiddenName": "profileHidden", "listeners": { "render": Lino.quicktip_renderer("Benutzerprofil","Users with an empty `profile` field are considered inactive and cannot log in.") }, "selectOnFocus": true, "anchor": "-20", "store": [['','<br>']].concat(Lino.users.UserProfiles) });
    var main_4_panel745 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 32, "autoHeight": true, "layout": "form", "xtype": "panel", "items": language743, "labelAlign": "top" }, { "flex": 67, "autoHeight": true, "layout": "form", "xtype": "panel", "items": profile744, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 135, "border": false, "anchor": "-20", "labelAlign": "top" });
    var main_panel748 = new Ext.Panel({ "hideCheckBoxLabels": true, "autoHeight": true, "border": false, "layout": "form", "labelWidth": 72, "autoScroll": false, "items": [ main_1_panel734, main_2_panel739, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": partner742, "anchor": "-20", "labelAlign": "top" }, main_4_panel745 ], "frame": true, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel748;
    this.before_row_edit = function(record) {
    }
    Lino.users.MySettings.InsertFormPanel.superclass.initComponent.call(this);
  }
});


Lino.uploads.MyUploads.InsertFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  autoHeight: true,
  content_type: 24,
  initComponent : function() {
    var type2550 = new Lino.TwinCombo({ "autoHeight": true, "fieldLabel": "Upload-Art", "name": "type", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.uploads.UploadTypes.detail,Lino.uploads.UploadTypes.insert)}, "emptyText": "Upload-Art ausw\u00e4hlen...", "selectOnFocus": true, "hiddenName": "typeHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/uploads/MyUploads/type", "method": "GET" }) }) });
    var description2551 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Beschreibung", "name": "description", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var file2552 = Lino.file_field_handler(this,{ "autoHeight": true, "fieldLabel": "Datei", "name": "file", "maxLength": 100, "selectOnFocus": true, "anchor": "-20" });
    var user2553 = new Lino.TwinCombo({ "preferred_width": 15, "autoHeight": true, "fieldLabel": "Autor", "name": "user", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.users.Users.detail,Lino.users.Users.insert)}, "hiddenName": "userHidden", "selectOnFocus": true, "emptyText": "Benutzer ausw\u00e4hlen...", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/uploads/MyUploads/user", "method": "GET" }) }) });
    var main_panel2554 = new Ext.Panel({ "hideCheckBoxLabels": true, "autoHeight": true, "border": false, "layout": "form", "labelWidth": 117, "autoScroll": false, "items": [ { "autoHeight": true, "layout": "form", "xtype": "panel", "items": type2550, "anchor": "-20", "labelAlign": "top" }, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": description2551, "anchor": "-20", "labelAlign": "top" }, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": file2552, "anchor": "-20", "labelAlign": "top" }, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": user2553, "anchor": "-20", "labelAlign": "top" } ], "frame": true, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel2554;
    this.before_row_edit = function(record) {
      type2550.setContextValue('upload_area', record ? record.data['upload_areaHidden'] : undefined);
    }
    Lino.uploads.MyUploads.InsertFormPanel.superclass.initComponent.call(this);
  }
});


Lino.extensible.PanelCalendars.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 36,
  initComponent : function() {
    var name1495 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Bezeichnung", "name": "name", "maxLength": 200, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var name_fr1496 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Bezeichnung (fr)", "name": "name_fr", "maxLength": 200, "selectOnFocus": true, "hidden": true, "anchor": "-20" });
    var name_nl1497 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Bezeichnung (nl)", "name": "name_nl", "maxLength": 200, "selectOnFocus": true, "hidden": true, "anchor": "-20" });
    var color1498 = new Ext.form.NumberField({ "autoHeight": true, "fieldLabel": "Farbe", "name": "color", "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var id1499 = new Ext.form.NumberField({ "selectOnFocus": true, "autoHeight": true, "fieldLabel": "ID", "anchor": "-20", "name": "id" });
    var main_1_panel1500 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 153, "hideCheckBoxLabels": true, "items": [ { "flex": 28, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name1495, "labelAlign": "top" }, { "flex": 28, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_fr1496, "hidden": true, "labelAlign": "top" }, { "flex": 28, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_nl1497, "hidden": true, "labelAlign": "top" }, { "flex": 6, "autoHeight": true, "layout": "form", "xtype": "panel", "items": color1498, "labelAlign": "top" }, { "flex": 6, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id1499, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var description1506 = new Lino.RichTextPanel({ "selectOnFocus": true, "flex": 63, "containing_panel": this, "name": "description", "title": "Beschreibung" });
    var SubscriptionsByCalendar_grid1511 = new Lino.cal.SubscriptionsByCalendar.GridPanel({ "flex": 36, "hide_top_toolbar": true, "containing_panel": this, "tools": [ Lino.show_in_own_window_button(Lino.cal.SubscriptionsByCalendar.grid) ], "preview_limit": 15, "master_panel": this });
    var main_2_panel1512 = new Ext.Panel({ "flex": 83, "border": false, "layout": "hbox", "labelWidth": 0, "hideCheckBoxLabels": true, "items": [ description1506, SubscriptionsByCalendar_grid1511 ], "autoScroll": false, "layoutConfig": { "align": "stretch" }, "frame": false, "labelAlign": "top" });
    var main_panel1513 = new Ext.Panel({ "autoScroll": false, "border": false, "layout": "vbox", "hideCheckBoxLabels": true, "items": [ main_1_panel1500, main_2_panel1512 ], "frame": true, "layoutConfig": { "align": "stretch" }, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel1513;
    this.before_row_edit = function(record) {
      description1506.refresh();
      SubscriptionsByCalendar_grid1511.on_master_changed();
    }
    Lino.extensible.PanelCalendars.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.uploads.AreaUploads.InsertFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  autoHeight: true,
  content_type: 24,
  initComponent : function() {
    var type1486 = new Lino.TwinCombo({ "autoHeight": true, "fieldLabel": "Upload-Art", "name": "type", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.uploads.UploadTypes.detail,Lino.uploads.UploadTypes.insert)}, "emptyText": "Upload-Art ausw\u00e4hlen...", "selectOnFocus": true, "hiddenName": "typeHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/uploads/AreaUploads/type", "method": "GET" }) }) });
    var description1487 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Beschreibung", "name": "description", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var file1488 = Lino.file_field_handler(this,{ "autoHeight": true, "fieldLabel": "Datei", "name": "file", "maxLength": 100, "selectOnFocus": true, "anchor": "-20" });
    var user1489 = new Lino.TwinCombo({ "preferred_width": 15, "autoHeight": true, "fieldLabel": "Autor", "name": "user", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.users.Users.detail,Lino.users.Users.insert)}, "hiddenName": "userHidden", "selectOnFocus": true, "emptyText": "Benutzer ausw\u00e4hlen...", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/uploads/AreaUploads/user", "method": "GET" }) }) });
    var main_panel1490 = new Ext.Panel({ "hideCheckBoxLabels": true, "autoHeight": true, "border": false, "layout": "form", "labelWidth": 117, "autoScroll": false, "items": [ { "autoHeight": true, "layout": "form", "xtype": "panel", "items": type1486, "anchor": "-20", "labelAlign": "top" }, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": description1487, "anchor": "-20", "labelAlign": "top" }, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": file1488, "anchor": "-20", "labelAlign": "top" }, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": user1489, "anchor": "-20", "labelAlign": "top" } ], "frame": true, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel1490;
    this.before_row_edit = function(record) {
      type1486.setContextValue('upload_area', record ? record.data['upload_areaHidden'] : undefined);
    }
    Lino.uploads.AreaUploads.InsertFormPanel.superclass.initComponent.call(this);
  }
});


Lino.aids.IncomeConfirmations.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 112,
  initComponent : function() {
    var client522 = new Lino.TwinCombo({ "preferred_width": 20, "autoHeight": true, "fieldLabel": "Klient", "allowBlank": false, "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.pcsw.Clients.detail,Lino.pcsw.Clients.insert)}, "emptyText": "Klient ausw\u00e4hlen...", "selectOnFocus": true, "hiddenName": "clientHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/aids/IncomeConfirmations/client", "method": "GET" }) }), "name": "client" });
    var user523 = new Lino.TwinCombo({ "preferred_width": 15, "autoHeight": true, "fieldLabel": "Autor", "name": "user", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.users.Users.detail,Lino.users.Users.insert)}, "hiddenName": "userHidden", "selectOnFocus": true, "emptyText": "Benutzer ausw\u00e4hlen...", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/aids/IncomeConfirmations/user", "method": "GET" }) }) });
    var signer524 = new Lino.TwinCombo({ "preferred_width": 15, "autoHeight": true, "fieldLabel": "Best\u00e4tiger", "name": "signer", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.users.Users.detail,Lino.users.Users.insert)}, "hiddenName": "signerHidden", "selectOnFocus": true, "emptyText": "Benutzer ausw\u00e4hlen...", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/aids/IncomeConfirmations/signer", "method": "GET" }) }) });
    var workflow_buttons_disp525 = new Ext.form.DisplayField({ "disabled": true, "autoHeight": true, "fieldLabel": "Arbeitsablauf", "name": "workflow_buttons", "anchor": "-20", "value": "<br/>", "always_enabled": true });
    var printed_disp526 = new Ext.form.DisplayField({ "disabled": true, "autoHeight": true, "fieldLabel": "Ausgedruckt", "name": "printed", "anchor": "-20", "value": "<br/>", "always_enabled": true });
    var main_1_panel527 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 126, "hideCheckBoxLabels": true, "items": [ { "flex": 16, "autoHeight": true, "layout": "form", "xtype": "panel", "items": client522, "labelAlign": "top" }, { "flex": 16, "autoHeight": true, "layout": "form", "xtype": "panel", "items": user523, "labelAlign": "top" }, { "flex": 16, "autoHeight": true, "layout": "form", "xtype": "panel", "items": signer524, "labelAlign": "top" }, { "flex": 25, "autoHeight": true, "layout": "form", "xtype": "panel", "items": workflow_buttons_disp525, "labelAlign": "top" }, { "flex": 25, "autoHeight": true, "layout": "form", "xtype": "panel", "items": printed_disp526, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var company533 = new Lino.TwinCombo({ "preferred_width": 20, "autoHeight": true, "fieldLabel": "Empf\u00e4nger (Organisation)", "name": "company", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.contacts.Companies.detail,Lino.contacts.Companies.insert)}, "hiddenName": "companyHidden", "selectOnFocus": true, "emptyText": "Organisation ausw\u00e4hlen...", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/aids/IncomeConfirmations/company", "method": "GET" }) }) });
    var contact_person534 = new Lino.TwinCombo({ "preferred_width": 20, "autoHeight": true, "fieldLabel": "Empf\u00e4nger (Person)", "name": "contact_person", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.contacts.Persons.detail,Lino.contacts.Persons.insert)}, "hiddenName": "contact_personHidden", "selectOnFocus": true, "emptyText": "Person ausw\u00e4hlen...", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/aids/IncomeConfirmations/contact_person", "method": "GET" }) }) });
    var main_2_panel535 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 225, "hideCheckBoxLabels": true, "items": [ { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": company533, "labelAlign": "top" }, { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": contact_person534, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var granting538 = new Lino.TwinCombo({ "autoHeight": true, "fieldLabel": "Hilfebeschluss", "name": "granting", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.aids.GrantingsByX.detail,Lino.aids.GrantingsByX.insert)}, "emptyText": "Hilfebeschluss ausw\u00e4hlen...", "selectOnFocus": true, "hiddenName": "grantingHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/aids/IncomeConfirmations/granting", "method": "GET" }) }) });
    var start_date539 = new Lino.DateField({ "selectOnFocus": true, "autoHeight": true, "fieldLabel": "Periode vom", "anchor": "-20", "name": "start_date" });
    var end_date540 = new Lino.DateField({ "selectOnFocus": true, "autoHeight": true, "fieldLabel": "bis", "anchor": "-20", "name": "end_date" });
    var main_3_panel541 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 135, "hideCheckBoxLabels": true, "items": [ { "flex": 49, "autoHeight": true, "layout": "form", "xtype": "panel", "items": granting538, "labelAlign": "top" }, { "flex": 25, "autoHeight": true, "layout": "form", "xtype": "panel", "items": start_date539, "labelAlign": "top" }, { "flex": 25, "autoHeight": true, "layout": "form", "xtype": "panel", "items": end_date540, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var category545 = new Lino.TwinCombo({ "autoHeight": true, "fieldLabel": "Kategorie", "name": "category", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.aids.Categories.detail,Lino.aids.Categories.insert)}, "emptyText": "Kategorie ausw\u00e4hlen...", "selectOnFocus": true, "hiddenName": "categoryHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/aids/IncomeConfirmations/category", "method": "GET" }) }) });
    var amount546 = new Ext.form.NumberField({ "autoHeight": true, "decimalPrecision": 2, "fieldLabel": "Betrag", "name": "amount", "decimalSeparator": ",", "selectOnFocus": true, "anchor": "-20", "allowBlank": true });
    var id547 = new Ext.form.NumberField({ "selectOnFocus": true, "autoHeight": true, "fieldLabel": "ID", "anchor": "-20", "name": "id" });
    var main_4_panel548 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 90, "hideCheckBoxLabels": true, "items": [ { "flex": 54, "autoHeight": true, "layout": "form", "xtype": "panel", "items": category545, "labelAlign": "top" }, { "flex": 32, "autoHeight": true, "layout": "form", "xtype": "panel", "items": amount546, "labelAlign": "top" }, { "flex": 13, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id547, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var remark552 = new Lino.RichTextPanel({ "selectOnFocus": true, "flex": 45, "containing_panel": this, "name": "remark", "title": "Bemerkung" });
    var main_panel553 = new Ext.Panel({ "autoScroll": false, "border": false, "layout": "vbox", "labelWidth": 0, "hideCheckBoxLabels": true, "items": [ main_1_panel527, main_2_panel535, main_3_panel541, main_4_panel548, remark552 ], "frame": true, "layoutConfig": { "align": "stretch" }, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel553;
    this.before_row_edit = function(record) {
      contact_person534.setContextValue('company', record ? record.data['companyHidden'] : undefined);
      remark552.refresh();
    }
    this.onRender = function(ct, position) {
      company533.on('change',Lino.chooser_handler(contact_person534,'company'));
      Lino.aids.IncomeConfirmations.DetailFormPanel.superclass.onRender.call(this, ct, position);
    }
    Lino.aids.IncomeConfirmations.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.accounts.AccountsByGroup.InsertFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  autoHeight: true,
  content_type: 40,
  initComponent : function() {
    var ref2656 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "ref", "name": "ref", "maxLength": 5, "selectOnFocus": true, "boxMinWidth": Lino.chars2width(5), "anchor": "-20" });
    var group2657 = new Lino.TwinCombo({ "autoHeight": true, "fieldLabel": "Kontengruppe", "allowBlank": false, "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.accounts.Groups.detail,Lino.accounts.Groups.insert)}, "emptyText": "Kontengruppe ausw\u00e4hlen...", "selectOnFocus": true, "hiddenName": "groupHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/accounts/Accounts/group", "method": "GET" }) }), "name": "group" });
    var type2658 = new Lino.ChoicesFieldElement({ "autoHeight": true, "forceSelection": true, "fieldLabel": "Kontenart", "allowBlank": false, "hiddenName": "typeHidden", "selectOnFocus": true, "anchor": "-20", "store": Lino.accounts.AccountTypes, "name": "type" });
    var main_1_panel2659 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 13, "autoHeight": true, "layout": "form", "xtype": "panel", "items": ref2656, "labelAlign": "top" }, { "flex": 45, "autoHeight": true, "layout": "form", "xtype": "panel", "items": group2657, "labelAlign": "top" }, { "flex": 40, "autoHeight": true, "layout": "form", "xtype": "panel", "items": type2658, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 117, "border": false, "anchor": "-20", "labelAlign": "top" });
    var name2663 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Bezeichnung", "name": "name", "maxLength": 200, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var name_fr2664 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Bezeichnung (fr)", "name": "name_fr", "maxLength": 200, "selectOnFocus": true, "hidden": true, "anchor": "-20" });
    var name_nl2665 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Bezeichnung (nl)", "name": "name_nl", "maxLength": 200, "selectOnFocus": true, "hidden": true, "anchor": "-20" });
    var main_2_panel2666 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name2663, "labelAlign": "top" }, { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_fr2664, "hidden": true, "labelAlign": "top" }, { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_nl2665, "hidden": true, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 153, "border": false, "anchor": "-20", "labelAlign": "top" });
    var main_panel2670 = new Ext.Panel({ "hideCheckBoxLabels": true, "autoHeight": true, "border": false, "layout": "form", "autoScroll": false, "items": [ main_1_panel2659, main_2_panel2666 ], "frame": true, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel2670;
    this.before_row_edit = function(record) {
    }
    Lino.accounts.AccountsByGroup.InsertFormPanel.superclass.initComponent.call(this);
  }
});


Lino.uploads.AreaUploads.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 24,
  initComponent : function() {
    var file1471 = Lino.file_field_handler(this,{ "autoHeight": true, "fieldLabel": "Datei", "name": "file", "maxLength": 100, "selectOnFocus": true, "anchor": "-20" });
    var user1472 = new Lino.TwinCombo({ "preferred_width": 15, "autoHeight": true, "fieldLabel": "Autor", "name": "user", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.users.Users.detail,Lino.users.Users.insert)}, "hiddenName": "userHidden", "selectOnFocus": true, "emptyText": "Benutzer ausw\u00e4hlen...", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/uploads/AreaUploads/user", "method": "GET" }) }) });
    var main_1_panel1473 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 51, "autoHeight": true, "layout": "form", "xtype": "panel", "items": file1471, "labelAlign": "top" }, { "flex": 48, "autoHeight": true, "layout": "form", "xtype": "panel", "items": user1472, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 54, "border": false, "anchor": "-20", "labelAlign": "top" });
    var upload_area1476 = new Lino.ChoicesFieldElement({ "autoHeight": true, "forceSelection": true, "fieldLabel": "Upload-Bereich", "allowBlank": false, "hiddenName": "upload_areaHidden", "selectOnFocus": true, "anchor": "-20", "store": Lino.uploads.UploadAreas, "name": "upload_area" });
    var type1477 = new Lino.TwinCombo({ "autoHeight": true, "fieldLabel": "Upload-Art", "name": "type", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.uploads.UploadTypes.detail,Lino.uploads.UploadTypes.insert)}, "emptyText": "Upload-Art ausw\u00e4hlen...", "selectOnFocus": true, "hiddenName": "typeHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/uploads/AreaUploads/type", "method": "GET" }) }) });
    var description1478 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Beschreibung", "name": "description", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var main_2_panel1479 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 19, "autoHeight": true, "layout": "form", "xtype": "panel", "items": upload_area1476, "labelAlign": "top" }, { "flex": 39, "autoHeight": true, "layout": "form", "xtype": "panel", "items": type1477, "labelAlign": "top" }, { "flex": 41, "autoHeight": true, "layout": "form", "xtype": "panel", "items": description1478, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 135, "border": false, "anchor": "-20", "labelAlign": "top" });
    var owner_disp1483 = new Ext.form.DisplayField({ "disabled": true, "autoHeight": true, "fieldLabel": "Verkn\u00fcpft mit", "anchor": "-20", "name": "owner" });
    var main_panel1484 = new Ext.Panel({ "hideCheckBoxLabels": true, "autoHeight": true, "border": false, "layout": "form", "labelWidth": 126, "autoScroll": false, "items": [ main_1_panel1473, main_2_panel1479, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": owner_disp1483, "anchor": "-20", "labelAlign": "top" } ], "frame": true, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel1484;
    this.before_row_edit = function(record) {
      type1477.setContextValue('upload_area', record ? record.data['upload_areaHidden'] : undefined);
    }
    this.onRender = function(ct, position) {
      upload_area1476.on('change',Lino.chooser_handler(type1477,'upload_area'));
      Lino.uploads.AreaUploads.DetailFormPanel.superclass.onRender.call(this, ct, position);
    }
    Lino.uploads.AreaUploads.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.system.MyTextFieldTemplates.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 3,
  initComponent : function() {
    var id2519 = new Ext.form.NumberField({ "selectOnFocus": true, "autoHeight": true, "fieldLabel": "ID", "anchor": "-20", "name": "id" });
    var name2520 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Bezeichnung", "name": "name", "maxLength": 200, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var user2521 = new Lino.TwinCombo({ "preferred_width": 15, "autoHeight": true, "fieldLabel": "Autor", "name": "user", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.users.Users.detail,Lino.users.Users.insert)}, "hiddenName": "userHidden", "selectOnFocus": true, "emptyText": "Benutzer ausw\u00e4hlen...", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/system/TextFieldTemplates/user", "method": "GET" }) }) });
    var main_1_panel2522 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 10, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id2519, "labelAlign": "top" }, { "flex": 45, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name2520, "labelAlign": "top" }, { "flex": 43, "autoHeight": true, "layout": "form", "xtype": "panel", "items": user2521, "labelAlign": "top" } ], "region": "north", "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "split": true, "autoScroll": false, "labelWidth": 108, "border": false, "frame": false, "labelAlign": "top" });
    var description2526 = new Ext.form.TextArea({ "selectOnFocus": true, "fieldLabel": "Beschreibung", "anchor": "-20 -10", "growMax": 2000, "name": "description" });
    var text2527 = new Lino.RichTextPanel({ "flex": 5, "split": true, "containing_panel": this, "selectOnFocus": true, "region": "south", "title": "Vorlagentext", "name": "text" });
    var main_panel2528 = new Lino.VBorderPanel({ "autoScroll": false, "border": false, "labelWidth": 117, "hideCheckBoxLabels": true, "items": [ main_1_panel2522, { "flex": 5, "layout": "form", "xtype": "panel", "items": description2526, "region": "center", "labelAlign": "top", "split": true }, text2527 ], "frame": true, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel2528;
    this.before_row_edit = function(record) {
      text2527.refresh();
    }
    Lino.system.MyTextFieldTemplates.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.contacts.Persons.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 18,
  initComponent : function() {
    var overview_disp1158 = new Ext.form.DisplayField({ "disabled": true, "flex": 28, "name": "overview", "value": "<br/>", "always_enabled": true });
    var title1159 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Anrede</span>", "name": "title", "maxLength": 200, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Anrede","Text to print before allocation and name as part of the first address line.") }, "anchor": "-20" });
    var first_name1160 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Vorname</span>", "name": "first_name", "listeners": { "render": Lino.quicktip_renderer("Vorname","First or given name.") }, "maxLength": 200, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var middle_name1161 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Zwischenname</span>", "name": "middle_name", "maxLength": 200, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Zwischenname","Space-separated list of all middle names.") }, "anchor": "-20" });
    var general2_1_panel1162 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 41, "autoHeight": true, "layout": "form", "xtype": "panel", "items": title1159, "labelAlign": "top" }, { "flex": 29, "autoHeight": true, "layout": "form", "xtype": "panel", "items": first_name1160, "labelAlign": "top" }, { "flex": 29, "autoHeight": true, "layout": "form", "xtype": "panel", "items": middle_name1161, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 117, "border": false, "anchor": "-20", "labelAlign": "top" });
    var last_name1166 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Familienname</span>", "name": "last_name", "listeners": { "render": Lino.quicktip_renderer("Familienname","Last name (family name).") }, "maxLength": 200, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var gender1167 = new Lino.ChoicesFieldElement({ "autoHeight": true, "forceSelection": true, "fieldLabel": "Geschlecht", "name": "gender", "hiddenName": "genderHidden", "selectOnFocus": true, "anchor": "-20", "store": [['','<br>']].concat(Lino.system.Genders) });
    var birth_date1168 = new Lino.IncompleteDateField({ "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Geburtsdatum</span>", "name": "birth_date", "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Geburtsdatum","Unkomplette Datumsangaben sind erlaubt, z.B. \"00.00.1980\" hei\u00dft \"irgendwann im Jahr 1980\", \"00.07.1980\" hei\u00dft \"im Juli 1980\"oder \"23.07.0000\" hei\u00dft \"an einem 23. Juli\".") }, "anchor": "-20" });
    var age_disp1169 = new Ext.form.DisplayField({ "disabled": true, "autoHeight": true, "fieldLabel": "Alter", "name": "age", "anchor": "-20", "value": "<br/>", "always_enabled": true });
    var general2_3_panel1170 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 31, "autoHeight": true, "layout": "form", "xtype": "panel", "items": gender1167, "labelAlign": "top" }, { "flex": 37, "autoHeight": true, "layout": "form", "xtype": "panel", "items": birth_date1168, "labelAlign": "top" }, { "flex": 31, "autoHeight": true, "layout": "form", "xtype": "panel", "items": age_disp1169, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 117, "border": false, "anchor": "-20", "labelAlign": "top" });
    var id1174 = new Ext.form.NumberField({ "selectOnFocus": true, "autoHeight": true, "fieldLabel": "ID", "anchor": "-20", "name": "id" });
    var language1175 = new Lino.ChoicesFieldElement({ "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Sprache</span>", "allowBlank": false, "hiddenName": "languageHidden", "listeners": { "render": Lino.quicktip_renderer("Sprache","Die Sprache, in der Dokumente ausgestellt werden sollen.") }, "selectOnFocus": true, "anchor": "-20", "store": [ [ "de", "Deutsch" ], [ "fr", "Franz\u00f6sisch" ], [ "nl", "Niederl\u00e4ndisch" ] ], "name": "language" });
    var general2_4_panel1176 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 20, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id1174, "labelAlign": "top" }, { "flex": 80, "autoHeight": true, "layout": "form", "xtype": "panel", "items": language1175, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 72, "border": false, "anchor": "-20", "labelAlign": "top" });
    var general2_panel1179 = new Ext.Panel({ "flex": 42, "autoHeight": true, "layout": "form", "items": [ general2_1_panel1162, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": last_name1166, "anchor": "-20", "labelAlign": "top" }, general2_3_panel1170, general2_4_panel1176 ], "frame": true, "bodyBorder": false, "autoScroll": false, "hideCheckBoxLabels": true, "labelWidth": 117, "border": false, "labelAlign": "top" });
    var email1181 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "E-Mail", "name": "email", "maxLength": 75, "selectOnFocus": true, "anchor": "-20" });
    var phone1182 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Telefon", "name": "phone", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var gsm1183 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "GSM", "name": "gsm", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var fax1184 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Fax", "name": "fax", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var general3_panel1185 = new Ext.Panel({ "flex": 28, "autoHeight": true, "layout": "form", "items": [ { "autoHeight": true, "layout": "form", "xtype": "panel", "items": email1181, "anchor": "-20", "labelAlign": "top" }, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": phone1182, "anchor": "-20", "labelAlign": "top" }, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": gsm1183, "anchor": "-20", "labelAlign": "top" }, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": fax1184, "anchor": "-20", "labelAlign": "top" } ], "frame": true, "bodyBorder": false, "autoScroll": false, "hideCheckBoxLabels": true, "labelWidth": 72, "border": false, "labelAlign": "top" });
    var general_1_panel1190 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 0, "hideCheckBoxLabels": true, "items": [ overview_disp1158, general2_panel1179, general3_panel1185 ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var contacts_RolesByPerson_grid1195 = new Lino.contacts.RolesByPerson.GridPanel({ "flex": 45, "hide_top_toolbar": true, "containing_panel": this, "tools": [ Lino.show_in_own_window_button(Lino.contacts.RolesByPerson.grid) ], "preview_limit": 15, "master_panel": this });
    var general_panel1196 = new Ext.Panel({ "layout": "vbox", "title": "Allgemein", "items": [ general_1_panel1190, contacts_RolesByPerson_grid1195 ], "frame": true, "layoutConfig": { "align": "stretch" }, "hideCheckBoxLabels": true, "listeners": { "activate": Lino.on_tab_activate }, "autoScroll": false, "border": false, "bodyBorder": false, "labelAlign": "top" });
    var MembersByPerson_htmlbox1197 = new Lino.HtmlBoxPanel({ "flex": 25, "layout": "fit", "name": "MembersByPerson", "containing_panel": this, "items": new Ext.BoxComponent({autoScroll:true}), "title": "Mitgliedschaft in Haushalten", "master_panel": this, "value": "<br/>", "always_enabled": true, "bodyStyle": "overflow-x:hidden;", "tools": [ Lino.show_in_own_window_button(Lino.households.MembersByPerson.grid) ] });
    var households_SiblingsByPerson_grid1213 = new Lino.households.SiblingsByPerson.GridPanel({ "flex": 75, "hide_top_toolbar": true, "containing_panel": this, "tools": [ Lino.show_in_own_window_button(Lino.households.SiblingsByPerson.grid) ], "preview_limit": 15, "master_panel": this });
    var contact_1_panel1214 = new Ext.Panel({ "flex": 5, "layout": "hbox", "items": [ MembersByPerson_htmlbox1197, households_SiblingsByPerson_grid1213 ], "region": "north", "layoutConfig": { "align": "stretch" }, "hideCheckBoxLabels": true, "split": true, "autoScroll": false, "labelWidth": 261, "border": false, "frame": false, "labelAlign": "top" });
    var LinksByHuman_htmlbox1215 = new Lino.HtmlBoxPanel({ "flex": 3, "layout": "fit", "name": "LinksByHuman", "containing_panel": this, "items": new Ext.BoxComponent({autoScroll:true}), "region": "center", "title": "Beziehungen", "master_panel": this, "value": "<br/>", "always_enabled": true, "bodyStyle": "overflow-x:hidden;", "split": true, "tools": [ Lino.show_in_own_window_button(Lino.humanlinks.LinksByHuman.grid) ] });
    var remarks1216 = new Ext.form.TextArea({ "selectOnFocus": true, "fieldLabel": "Bemerkungen", "anchor": "-20 -10", "growMax": 2000, "name": "remarks" });
    var sepa_AccountsByPartner_grid1217 = new Lino.sepa.AccountsByPartner.GridPanel({ "flex": 64, "hide_top_toolbar": true, "containing_panel": this, "tools": [ Lino.show_in_own_window_button(Lino.sepa.AccountsByPartner.grid) ], "preview_limit": 15, "master_panel": this });
    var contact_3_panel1218 = new Ext.Panel({ "flex": 5, "layout": "hbox", "items": [ { "items": remarks1216, "labelAlign": "top", "layout": "form", "xtype": "panel", "flex": 35 }, sepa_AccountsByPartner_grid1217 ], "region": "south", "layoutConfig": { "align": "stretch" }, "hideCheckBoxLabels": true, "split": true, "autoScroll": false, "labelWidth": 108, "border": false, "frame": false, "labelAlign": "top" });
    var contact_panel1220 = new Lino.VBorderPanel({ "autoScroll": false, "listeners": { "activate": Lino.on_tab_activate }, "border": false, "labelWidth": 108, "title": "Kontakt", "hideCheckBoxLabels": true, "items": [ contact_1_panel1214, LinksByHuman_htmlbox1215, contact_3_panel1218 ], "frame": true, "bodyBorder": false, "labelAlign": "top" });
    var activity1221 = new Lino.RemoteComboFieldElement({ "autoHeight": true, "fieldLabel": "Beruf", "name": "activity", "pageSize": 20, "emptyText": "Beruf ausw\u00e4hlen...", "selectOnFocus": true, "hiddenName": "activityHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/contacts/Persons/activity", "method": "GET" }) }) });
    var url1222 = new Lino.URLField({ "autoHeight": true, "fieldLabel": "URL", "name": "url", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var client_contact_type1223 = new Lino.TwinCombo({ "autoHeight": true, "fieldLabel": "Klientenkontaktart", "name": "client_contact_type", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.pcsw.ClientContactTypes.detail,Lino.pcsw.ClientContactTypes.insert)}, "emptyText": "Klientenkontaktart ausw\u00e4hlen...", "selectOnFocus": true, "hiddenName": "client_contact_typeHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/contacts/Persons/client_contact_type", "method": "GET" }) }) });
    var misc_1_panel1224 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 171, "hideCheckBoxLabels": true, "items": [ { "flex": 32, "autoHeight": true, "layout": "form", "xtype": "panel", "items": activity1221, "labelAlign": "top" }, { "flex": 34, "autoHeight": true, "layout": "form", "xtype": "panel", "items": url1222, "labelAlign": "top" }, { "flex": 32, "autoHeight": true, "layout": "form", "xtype": "panel", "items": client_contact_type1223, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var is_obsolete1228 = new Ext.form.Checkbox({ "autoHeight": true, "hideLabel": true, "checked": false, "name": "is_obsolete", "listeners": { "render": Lino.quicktip_renderer("veraltet","Altf\u00e4lle sind Partner, deren Stammdaten nicht mehr gepflegt werden und \nf\u00fcr neue Operationen nicht benutzt werden k\u00f6nnen.") }, "boxLabel": "veraltet", "selectOnFocus": true, "anchor": "-20" });
    var is_client1229 = new Ext.form.Checkbox({ "boxLabel": "ist Klient (<a href=\"javascript:Lino.show_mti_child('is_client',Lino.pcsw.Clients.detail)\">zeigen</a>)", "autoHeight": true, "hideLabel": true, "name": "is_client", "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("ist Klient","Ob diese Person ein Klient ist") }, "anchor": "-20" });
    var misc_2_panel1230 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 99, "hideCheckBoxLabels": true, "items": [ { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": is_obsolete1228, "labelAlign": "top" }, { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": is_client1229, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var created1233 = new Ext.form.DisplayField({ "disabled": true, "autoHeight": true, "fieldLabel": "Erstellt", "name": "created", "anchor": "-20", "value": "<br>" });
    var modified1234 = new Ext.form.DisplayField({ "disabled": true, "autoHeight": true, "fieldLabel": "Bearbeitet", "name": "modified", "anchor": "-20", "value": "<br>" });
    var misc_3_panel1235 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 99, "hideCheckBoxLabels": true, "items": [ { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": created1233, "labelAlign": "top" }, { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": modified1234, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var reception_AppointmentsByPartner_grid1238 = new Lino.reception.AppointmentsByPartner.GridPanel({ "flex": 62, "hide_top_toolbar": true, "containing_panel": this, "tools": [ Lino.show_in_own_window_button(Lino.reception.AppointmentsByPartner.grid) ], "preview_limit": 15, "master_panel": this });
    var misc_panel1239 = new Ext.Panel({ "layout": "vbox", "title": "Sonstiges", "items": [ misc_1_panel1224, misc_2_panel1230, misc_3_panel1235, reception_AppointmentsByPartner_grid1238 ], "frame": true, "layoutConfig": { "align": "stretch" }, "hideCheckBoxLabels": true, "listeners": { "activate": Lino.on_tab_activate }, "autoScroll": false, "border": false, "bodyBorder": false, "labelAlign": "top" });
    var main_panel1243 = new Ext.TabPanel({ "hideCheckBoxLabels": true, "border": false, "split": true, "autoScroll": false, "items": [ general_panel1196, contact_panel1220, misc_panel1239 ], "activeTab": 0, "bodyBorder": false, "frame": true, "labelAlign": "top" });
    this.items = main_panel1243;
    this.before_row_edit = function(record) {
      contacts_RolesByPerson_grid1195.on_master_changed();
      MembersByPerson_htmlbox1197.refresh();
      households_SiblingsByPerson_grid1213.on_master_changed();
      LinksByHuman_htmlbox1215.refresh();
      sepa_AccountsByPartner_grid1217.on_master_changed();
      reception_AppointmentsByPartner_grid1238.on_master_changed();
    }
    Lino.contacts.Persons.DetailFormPanel.superclass.initComponent.call(this);
    // active_fields:
  }
});


Lino.uploads.UploadsByClient.InsertFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  autoHeight: true,
  content_type: 24,
  initComponent : function() {
    var type2559 = new Lino.TwinCombo({ "autoHeight": true, "fieldLabel": "Upload-Art", "name": "type", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.uploads.UploadTypes.detail,Lino.uploads.UploadTypes.insert)}, "emptyText": "Upload-Art ausw\u00e4hlen...", "selectOnFocus": true, "hiddenName": "typeHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/uploads/UploadsByClient/type", "method": "GET" }) }) });
    var valid_until2560 = new Lino.DateField({ "selectOnFocus": true, "autoHeight": true, "fieldLabel": "G\u00fcltig bis", "anchor": "-20", "name": "valid_until" });
    var main_1_panel2561 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 60, "autoHeight": true, "layout": "form", "xtype": "panel", "items": type2559, "labelAlign": "top" }, { "flex": 39, "autoHeight": true, "layout": "form", "xtype": "panel", "items": valid_until2560, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 99, "border": false, "anchor": "-20", "labelAlign": "top" });
    var file2564 = Lino.file_field_handler(this,{ "autoHeight": true, "fieldLabel": "Datei", "name": "file", "maxLength": 100, "selectOnFocus": true, "anchor": "-20" });
    var description2565 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Beschreibung", "name": "description", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var main_panel2566 = new Ext.Panel({ "hideCheckBoxLabels": true, "autoHeight": true, "border": false, "layout": "form", "labelWidth": 117, "autoScroll": false, "items": [ main_1_panel2561, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": file2564, "anchor": "-20", "labelAlign": "top" }, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": description2565, "anchor": "-20", "labelAlign": "top" } ], "frame": true, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel2566;
    this.before_row_edit = function(record) {
      type2559.setContextValue('upload_area', record ? record.data['upload_areaHidden'] : undefined);
    }
    Lino.uploads.UploadsByClient.InsertFormPanel.superclass.initComponent.call(this);
  }
});


Lino.cal.TasksByController.InsertFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  autoHeight: true,
  content_type: 28,
  initComponent : function() {
    var summary1408 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Kurzbeschreibung", "name": "summary", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var start_date1409 = new Lino.DateField({ "selectOnFocus": true, "autoHeight": true, "fieldLabel": "Beginnt am", "anchor": "-20", "name": "start_date" });
    var due_date1410 = new Lino.DateField({ "selectOnFocus": true, "autoHeight": true, "fieldLabel": "Zahlungsziel", "anchor": "-20", "name": "due_date" });
    var main_2_panel1411 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": start_date1409, "labelAlign": "top" }, { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": due_date1410, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 117, "border": false, "anchor": "-20", "labelAlign": "top" });
    var user1414 = new Lino.TwinCombo({ "preferred_width": 15, "autoHeight": true, "fieldLabel": "Autor", "name": "user", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.users.Users.detail,Lino.users.Users.insert)}, "hiddenName": "userHidden", "selectOnFocus": true, "emptyText": "Benutzer ausw\u00e4hlen...", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/TasksByController/user", "method": "GET" }) }) });
    var delegated1415 = new Ext.form.Checkbox({ "boxLabel": "Delegated to client", "autoHeight": true, "hideLabel": true, "checked": false, "name": "delegated", "selectOnFocus": true, "anchor": "-20" });
    var main_3_panel1416 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 66, "autoHeight": true, "layout": "form", "xtype": "panel", "items": user1414, "labelAlign": "top" }, { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": delegated1415, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 180, "border": false, "anchor": "-20", "labelAlign": "top" });
    var main_panel1419 = new Ext.Panel({ "hideCheckBoxLabels": true, "autoHeight": true, "border": false, "layout": "form", "labelWidth": 153, "autoScroll": false, "items": [ { "autoHeight": true, "layout": "form", "xtype": "panel", "items": summary1408, "anchor": "-20", "labelAlign": "top" }, main_2_panel1411, main_3_panel1416 ], "frame": true, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel1419;
    this.before_row_edit = function(record) {
    }
    Lino.cal.TasksByController.InsertFormPanel.superclass.initComponent.call(this);
  }
});


Lino.cal.MyTasks.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 28,
  initComponent : function() {
    var start_date652 = new Lino.DateField({ "selectOnFocus": true, "autoHeight": true, "fieldLabel": "Beginnt am", "anchor": "-20", "name": "start_date" });
    var due_date653 = new Lino.DateField({ "selectOnFocus": true, "autoHeight": true, "fieldLabel": "Zahlungsziel", "anchor": "-20", "name": "due_date" });
    var id654 = new Ext.form.NumberField({ "selectOnFocus": true, "autoHeight": true, "fieldLabel": "ID", "anchor": "-20", "name": "id" });
    var workflow_buttons_disp655 = new Ext.form.DisplayField({ "disabled": true, "autoHeight": true, "fieldLabel": "Arbeitsablauf", "name": "workflow_buttons", "anchor": "-20", "value": "<br/>", "always_enabled": true });
    var main_1_panel656 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 126, "hideCheckBoxLabels": true, "items": [ { "flex": 21, "autoHeight": true, "layout": "form", "xtype": "panel", "items": start_date652, "labelAlign": "top" }, { "flex": 21, "autoHeight": true, "layout": "form", "xtype": "panel", "items": due_date653, "labelAlign": "top" }, { "flex": 8, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id654, "labelAlign": "top" }, { "flex": 49, "autoHeight": true, "layout": "form", "xtype": "panel", "items": workflow_buttons_disp655, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var summary661 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Kurzbeschreibung", "name": "summary", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var project662 = new Lino.TwinCombo({ "preferred_width": 20, "autoHeight": true, "fieldLabel": "Klient", "name": "project", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.pcsw.Clients.detail,Lino.pcsw.Clients.insert)}, "hiddenName": "projectHidden", "selectOnFocus": true, "emptyText": "Klient ausw\u00e4hlen...", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/Tasks/project", "method": "GET" }) }) });
    var user663 = new Lino.TwinCombo({ "preferred_width": 15, "autoHeight": true, "fieldLabel": "Autor", "name": "user", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.users.Users.detail,Lino.users.Users.insert)}, "hiddenName": "userHidden", "selectOnFocus": true, "emptyText": "Benutzer ausw\u00e4hlen...", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/Tasks/user", "method": "GET" }) }) });
    var delegated664 = new Ext.form.Checkbox({ "boxLabel": "Delegated to client", "autoHeight": true, "hideLabel": true, "checked": false, "name": "delegated", "selectOnFocus": true, "anchor": "-20" });
    var main_3_panel665 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 180, "hideCheckBoxLabels": true, "items": [ { "flex": 40, "autoHeight": true, "layout": "form", "xtype": "panel", "items": project662, "labelAlign": "top" }, { "flex": 40, "autoHeight": true, "layout": "form", "xtype": "panel", "items": user663, "labelAlign": "top" }, { "flex": 20, "autoHeight": true, "layout": "form", "xtype": "panel", "items": delegated664, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var owner_disp669 = new Ext.form.DisplayField({ "disabled": true, "autoHeight": true, "fieldLabel": "Verkn\u00fcpft mit", "anchor": "-20", "name": "owner" });
    var created670 = new Ext.form.DisplayField({ "disabled": true, "autoHeight": true, "fieldLabel": "Erstellt", "name": "created", "anchor": "-20", "value": "<br>" });
    var modified671 = new Ext.form.DisplayField({ "disabled": true, "autoHeight": true, "fieldLabel": "Bearbeitet", "name": "modified", "anchor": "-20", "value": "<br>" });
    var main_4_panel672 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 126, "hideCheckBoxLabels": true, "items": [ { "flex": 20, "autoHeight": true, "layout": "form", "xtype": "panel", "items": owner_disp669, "labelAlign": "top" }, { "flex": 40, "autoHeight": true, "layout": "form", "xtype": "panel", "items": created670, "labelAlign": "top" }, { "flex": 40, "autoHeight": true, "layout": "form", "xtype": "panel", "items": modified671, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var description676 = new Ext.form.TextArea({ "selectOnFocus": true, "fieldLabel": "Beschreibung", "anchor": "-20 -10", "growMax": 2000, "name": "description" });
    var main_panel677 = new Ext.Panel({ "autoScroll": false, "border": false, "layout": "vbox", "labelWidth": 153, "hideCheckBoxLabels": true, "items": [ main_1_panel656, { "items": summary661, "autoHeight": true, "layout": "form", "xtype": "panel", "labelAlign": "top" }, main_3_panel665, main_4_panel672, { "items": description676, "labelAlign": "top", "layout": "form", "xtype": "panel", "flex": 45 } ], "frame": true, "layoutConfig": { "align": "stretch" }, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel677;
    this.before_row_edit = function(record) {
    }
    Lino.cal.MyTasks.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.excerpts.ExcerptsByX.InsertFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  autoHeight: true,
  content_type: 45,
  initComponent : function() {
    var excerpt_type2365 = new Lino.TwinCombo({ "autoHeight": true, "fieldLabel": "Auszugsart", "allowBlank": false, "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.excerpts.ExcerptTypes.detail,Lino.excerpts.ExcerptTypes.insert)}, "emptyText": "Auszugsart ausw\u00e4hlen...", "selectOnFocus": true, "hiddenName": "excerpt_typeHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/excerpts/Excerpts/excerpt_type", "method": "GET" }) }), "name": "excerpt_type" });
    var project2366 = new Lino.TwinCombo({ "preferred_width": 20, "autoHeight": true, "fieldLabel": "Klient", "name": "project", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.pcsw.Clients.detail,Lino.pcsw.Clients.insert)}, "hiddenName": "projectHidden", "selectOnFocus": true, "emptyText": "Klient ausw\u00e4hlen...", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/excerpts/Excerpts/project", "method": "GET" }) }) });
    var main_1_panel2367 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": excerpt_type2365, "labelAlign": "top" }, { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": project2366, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 99, "border": false, "anchor": "-20", "labelAlign": "top" });
    var company2370 = new Lino.TwinCombo({ "preferred_width": 20, "autoHeight": true, "fieldLabel": "Empf\u00e4nger (Organisation)", "name": "company", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.contacts.Companies.detail,Lino.contacts.Companies.insert)}, "hiddenName": "companyHidden", "selectOnFocus": true, "emptyText": "Organisation ausw\u00e4hlen...", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/excerpts/Excerpts/company", "method": "GET" }) }) });
    var contact_person2371 = new Lino.TwinCombo({ "preferred_width": 20, "autoHeight": true, "fieldLabel": "Empf\u00e4nger (Person)", "name": "contact_person", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.contacts.Persons.detail,Lino.contacts.Persons.insert)}, "hiddenName": "contact_personHidden", "selectOnFocus": true, "emptyText": "Person ausw\u00e4hlen...", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/excerpts/Excerpts/contact_person", "method": "GET" }) }) });
    var main_2_panel2372 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": company2370, "labelAlign": "top" }, { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": contact_person2371, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 225, "border": false, "anchor": "-20", "labelAlign": "top" });
    var main_panel2375 = new Ext.Panel({ "hideCheckBoxLabels": true, "autoHeight": true, "border": false, "layout": "form", "autoScroll": false, "items": [ main_1_panel2367, main_2_panel2372 ], "frame": true, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel2375;
    this.before_row_edit = function(record) {
      excerpt_type2365.setContextValue('owner', record ? record.data['owner'] : undefined);
      contact_person2371.setContextValue('company', record ? record.data['companyHidden'] : undefined);
    }
    this.onRender = function(ct, position) {
      company2370.on('change',Lino.chooser_handler(contact_person2371,'company'));
      Lino.excerpts.ExcerptsByX.InsertFormPanel.superclass.onRender.call(this, ct, position);
    }
    Lino.excerpts.ExcerptsByX.InsertFormPanel.superclass.initComponent.call(this);
  }
});


Lino.cbss.RetrieveTIGroupsRequests.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 96,
  initComponent : function() {
    var id2389 = new Ext.form.NumberField({ "selectOnFocus": true, "autoHeight": true, "fieldLabel": "ID", "anchor": "-20", "name": "id" });
    var person2390 = new Lino.TwinCombo({ "preferred_width": 20, "autoHeight": true, "fieldLabel": "Klient", "allowBlank": false, "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.pcsw.Clients.detail,Lino.pcsw.Clients.insert)}, "emptyText": "Klient ausw\u00e4hlen...", "selectOnFocus": true, "hiddenName": "personHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cbss/RetrieveTIGroupsRequests/person", "method": "GET" }) }), "name": "person" });
    var user2391 = new Lino.TwinCombo({ "preferred_width": 15, "autoHeight": true, "fieldLabel": "Autor", "allowBlank": false, "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.users.Users.detail,Lino.users.Users.insert)}, "emptyText": "Benutzer ausw\u00e4hlen...", "selectOnFocus": true, "hiddenName": "userHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cbss/RetrieveTIGroupsRequests/user", "method": "GET" }) }), "name": "user" });
    var environment2392 = new Ext.form.TextField({ "disabled": true, "autoHeight": true, "fieldLabel": "T/A/B", "name": "environment", "maxLength": 4, "boxMinWidth": Lino.chars2width(4), "anchor": "-20" });
    var sent2393 = new Ext.form.DisplayField({ "disabled": true, "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Versendet</span>", "name": "sent", "listeners": { "render": Lino.quicktip_renderer("Versendet","The date and time when this request has been executed. \nThis is empty for requests than haven't been sent.\nRead-only.") }, "value": "<br>", "anchor": "-20" });
    var status2394 = new Lino.ChoicesFieldElement({ "autoHeight": true, "forceSelection": true, "fieldLabel": "Zustand", "name": "status", "hiddenName": "statusHidden", "disabled": true, "anchor": "-20", "store": [['','<br>']].concat(Lino.cbss.RequestStates) });
    var ticket2395 = new Ext.form.TextField({ "disabled": true, "autoHeight": true, "fieldLabel": "Ticket", "name": "ticket", "maxLength": 36, "anchor": "-20" });
    var info_1_panel2396 = new Ext.form.FieldSet({ "autoHeight": true, "layout": "hbox", "title": "Info zur Anfrage", "layoutConfig": { "align": "stretchmax" }, "frame": false, "bodyBorder": true, "autoScroll": false, "items": [ { "flex": 4, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id2389, "labelAlign": "top" }, { "flex": 19, "autoHeight": true, "layout": "form", "xtype": "panel", "items": person2390, "labelAlign": "top" }, { "flex": 19, "autoHeight": true, "layout": "form", "xtype": "panel", "items": user2391, "labelAlign": "top" }, { "flex": 4, "autoHeight": true, "layout": "form", "xtype": "panel", "items": environment2392, "labelAlign": "top" }, { "flex": 15, "autoHeight": true, "layout": "form", "xtype": "panel", "items": sent2393, "labelAlign": "top" }, { "flex": 17, "autoHeight": true, "layout": "form", "xtype": "panel", "items": status2394, "labelAlign": "top" }, { "flex": 20, "autoHeight": true, "layout": "form", "xtype": "panel", "items": ticket2395, "labelAlign": "top" } ], "hideCheckBoxLabels": true, "labelWidth": 90, "border": false, "labelAlign": "top" });
    var national_id2404 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "NR-Nummer", "name": "national_id", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var language2405 = new Lino.ChoicesFieldElement({ "autoHeight": true, "forceSelection": true, "fieldLabel": "Sprache", "name": "language", "hiddenName": "languageHidden", "selectOnFocus": true, "anchor": "-20", "store": [['','<br>']].concat(Lino.cbss.RequestLanguages) });
    var history2406 = new Ext.form.Checkbox({ "autoHeight": true, "hideLabel": true, "checked": true, "name": "history", "listeners": { "render": Lino.quicktip_renderer("Historie","Whatever this means.") }, "boxLabel": "Historie", "selectOnFocus": true, "anchor": "-20" });
    var parameters_panel2407 = new Ext.form.FieldSet({ "autoHeight": true, "layout": "hbox", "title": "Parameter", "layoutConfig": { "align": "stretchmax" }, "frame": false, "bodyBorder": true, "autoScroll": false, "items": [ { "flex": 43, "autoHeight": true, "layout": "form", "xtype": "panel", "items": national_id2404, "labelAlign": "top" }, { "flex": 35, "autoHeight": true, "layout": "form", "xtype": "panel", "items": language2405, "labelAlign": "top" }, { "flex": 20, "autoHeight": true, "layout": "form", "xtype": "panel", "items": history2406, "labelAlign": "top" } ], "hideCheckBoxLabels": true, "labelWidth": 90, "border": false, "labelAlign": "top" });
    var cbss_RetrieveTIGroupsResult_grid2416 = new Lino.cbss.RetrieveTIGroupsResult.GridPanel({ "flex": 71, "hide_top_toolbar": true, "containing_panel": this, "tools": [ Lino.show_in_own_window_button(Lino.cbss.RetrieveTIGroupsResult.grid) ], "preview_limit": 15, "master_panel": this });
    var request_panel2417 = new Ext.Panel({ "layout": "vbox", "title": "Abfrage", "items": [ info_1_panel2396, parameters_panel2407, cbss_RetrieveTIGroupsResult_grid2416 ], "frame": true, "layoutConfig": { "align": "stretch" }, "hideCheckBoxLabels": true, "listeners": { "activate": Lino.on_tab_activate }, "autoScroll": false, "border": false, "bodyBorder": false, "labelAlign": "top" });
    var response_xml2418 = new Ext.form.TextArea({ "disabled": true, "listeners": { "render": Lino.quicktip_renderer("Antwort","The raw XML response received. \n") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Antwort</span>", "name": "response_xml", "growMax": 2000, "anchor": "-20 -10" });
    var info_messages2419 = new Ext.form.TextArea({ "disabled": true, "fieldLabel": "Info-Meldungen", "anchor": "-20 -10", "growMax": 2000, "name": "info_messages" });
    var debug_messages2420 = new Ext.form.TextArea({ "disabled": true, "fieldLabel": "Debug-Meldungen", "anchor": "-20 -10", "growMax": 2000, "name": "debug_messages" });
    var technical_panel2421 = new Lino.VBorderPanel({ "autoScroll": false, "listeners": { "activate": Lino.on_tab_activate }, "border": false, "labelWidth": 144, "title": "Technisch", "hideCheckBoxLabels": true, "items": [ { "flex": 5, "layout": "form", "xtype": "panel", "items": response_xml2418, "region": "north", "labelAlign": "top", "split": true }, { "flex": 5, "layout": "form", "xtype": "panel", "items": info_messages2419, "region": "center", "labelAlign": "top", "split": true }, { "flex": 5, "layout": "form", "xtype": "panel", "items": debug_messages2420, "region": "south", "labelAlign": "top", "split": true } ], "frame": true, "bodyBorder": false, "labelAlign": "top" });
    var main_panel2425 = new Ext.TabPanel({ "hideCheckBoxLabels": true, "border": false, "split": true, "autoScroll": false, "items": [ request_panel2417, technical_panel2421 ], "activeTab": 0, "bodyBorder": false, "frame": true, "labelAlign": "top" });
    this.items = main_panel2425;
    this.before_row_edit = function(record) {
      cbss_RetrieveTIGroupsResult_grid2416.on_master_changed();
    }
    Lino.cbss.RetrieveTIGroupsRequests.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.cal.MyPresences.InsertFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  autoHeight: true,
  content_type: 33,
  initComponent : function() {
    var event420 = new Lino.TwinCombo({ "autoHeight": true, "fieldLabel": "Termin", "allowBlank": false, "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.cal.OneEvent.detail,Lino.cal.OneEvent.insert)}, "emptyText": "Termin ausw\u00e4hlen...", "selectOnFocus": true, "hiddenName": "eventHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/Guests/event", "method": "GET" }) }), "name": "event" });
    var partner421 = new Lino.TwinCombo({ "preferred_width": 20, "autoHeight": true, "fieldLabel": "Partner", "allowBlank": false, "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.contacts.Partners.detail,Lino.contacts.Partners.insert)}, "emptyText": "Partner ausw\u00e4hlen...", "selectOnFocus": true, "hiddenName": "partnerHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/Guests/partner", "method": "GET" }) }), "name": "partner" });
    var role422 = new Lino.TwinCombo({ "autoHeight": true, "fieldLabel": "Rolle", "name": "role", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.cal.GuestRoles.detail,Lino.cal.GuestRoles.insert)}, "emptyText": "Gastrolle ausw\u00e4hlen...", "selectOnFocus": true, "hiddenName": "roleHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/Guests/role", "method": "GET" }) }) });
    var main_panel423 = new Ext.Panel({ "hideCheckBoxLabels": true, "autoHeight": true, "border": false, "layout": "form", "labelWidth": 72, "autoScroll": false, "items": [ { "autoHeight": true, "layout": "form", "xtype": "panel", "items": event420, "anchor": "-20", "labelAlign": "top" }, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": partner421, "anchor": "-20", "labelAlign": "top" }, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": role422, "anchor": "-20", "labelAlign": "top" } ], "frame": true, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel423;
    this.before_row_edit = function(record) {
    }
    Lino.cal.MyPresences.InsertFormPanel.superclass.initComponent.call(this);
  }
});


Lino.aids.RefundConfirmations.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 114,
  initComponent : function() {
    var id2474 = new Ext.form.NumberField({ "selectOnFocus": true, "autoHeight": true, "fieldLabel": "ID", "anchor": "-20", "name": "id" });
    var client2475 = new Lino.TwinCombo({ "preferred_width": 20, "autoHeight": true, "fieldLabel": "Klient", "allowBlank": false, "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.pcsw.Clients.detail,Lino.pcsw.Clients.insert)}, "emptyText": "Klient ausw\u00e4hlen...", "selectOnFocus": true, "hiddenName": "clientHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/aids/RefundConfirmations/client", "method": "GET" }) }), "name": "client" });
    var user2476 = new Lino.TwinCombo({ "preferred_width": 15, "autoHeight": true, "fieldLabel": "Autor", "name": "user", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.users.Users.detail,Lino.users.Users.insert)}, "hiddenName": "userHidden", "selectOnFocus": true, "emptyText": "Benutzer ausw\u00e4hlen...", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/aids/RefundConfirmations/user", "method": "GET" }) }) });
    var signer2477 = new Lino.TwinCombo({ "preferred_width": 15, "autoHeight": true, "fieldLabel": "Best\u00e4tiger", "name": "signer", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.users.Users.detail,Lino.users.Users.insert)}, "hiddenName": "signerHidden", "selectOnFocus": true, "emptyText": "Benutzer ausw\u00e4hlen...", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/aids/RefundConfirmations/signer", "method": "GET" }) }) });
    var workflow_buttons_disp2478 = new Ext.form.DisplayField({ "disabled": true, "autoHeight": true, "fieldLabel": "Arbeitsablauf", "name": "workflow_buttons", "anchor": "-20", "value": "<br/>", "always_enabled": true });
    var main_1_panel2479 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 126, "hideCheckBoxLabels": true, "items": [ { "flex": 5, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id2474, "labelAlign": "top" }, { "flex": 21, "autoHeight": true, "layout": "form", "xtype": "panel", "items": client2475, "labelAlign": "top" }, { "flex": 21, "autoHeight": true, "layout": "form", "xtype": "panel", "items": user2476, "labelAlign": "top" }, { "flex": 21, "autoHeight": true, "layout": "form", "xtype": "panel", "items": signer2477, "labelAlign": "top" }, { "flex": 31, "autoHeight": true, "layout": "form", "xtype": "panel", "items": workflow_buttons_disp2478, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var granting2485 = new Lino.TwinCombo({ "autoHeight": true, "fieldLabel": "Hilfebeschluss", "name": "granting", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.aids.GrantingsByX.detail,Lino.aids.GrantingsByX.insert)}, "emptyText": "Hilfebeschluss ausw\u00e4hlen...", "selectOnFocus": true, "hiddenName": "grantingHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/aids/RefundConfirmations/granting", "method": "GET" }) }) });
    var start_date2486 = new Lino.DateField({ "selectOnFocus": true, "autoHeight": true, "fieldLabel": "Periode vom", "anchor": "-20", "name": "start_date" });
    var end_date2487 = new Lino.DateField({ "selectOnFocus": true, "autoHeight": true, "fieldLabel": "bis", "anchor": "-20", "name": "end_date" });
    var main_2_panel2488 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 135, "hideCheckBoxLabels": true, "items": [ { "flex": 49, "autoHeight": true, "layout": "form", "xtype": "panel", "items": granting2485, "labelAlign": "top" }, { "flex": 25, "autoHeight": true, "layout": "form", "xtype": "panel", "items": start_date2486, "labelAlign": "top" }, { "flex": 25, "autoHeight": true, "layout": "form", "xtype": "panel", "items": end_date2487, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var doctor_type2492 = new Lino.TwinCombo({ "autoHeight": true, "fieldLabel": "Art des Arztes", "allowBlank": false, "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.pcsw.ClientContactTypes.detail,Lino.pcsw.ClientContactTypes.insert)}, "emptyText": "Klientenkontaktart ausw\u00e4hlen...", "selectOnFocus": true, "hiddenName": "doctor_typeHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/aids/RefundConfirmations/doctor_type", "method": "GET" }) }), "name": "doctor_type" });
    var doctor2493 = new Lino.TwinCombo({ "preferred_width": 20, "autoHeight": true, "forceSelection": false, "fieldLabel": "Arzt", "name": "doctor", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.contacts.Persons.detail,Lino.contacts.Persons.insert)}, "hiddenName": "doctorHidden", "selectOnFocus": true, "emptyText": "Person ausw\u00e4hlen...", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/aids/RefundConfirmations/doctor", "method": "GET" }) }) });
    var pharmacy2494 = new Lino.TwinCombo({ "preferred_width": 20, "autoHeight": true, "fieldLabel": "Apotheke", "name": "pharmacy", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.contacts.Companies.detail,Lino.contacts.Companies.insert)}, "hiddenName": "pharmacyHidden", "selectOnFocus": true, "emptyText": "Organisation ausw\u00e4hlen...", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/aids/RefundConfirmations/pharmacy", "method": "GET" }) }) });
    var main_3_panel2495 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 135, "hideCheckBoxLabels": true, "items": [ { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": doctor_type2492, "labelAlign": "top" }, { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": doctor2493, "labelAlign": "top" }, { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": pharmacy2494, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var company2499 = new Lino.TwinCombo({ "preferred_width": 20, "autoHeight": true, "fieldLabel": "Empf\u00e4nger (Organisation)", "name": "company", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.contacts.Companies.detail,Lino.contacts.Companies.insert)}, "hiddenName": "companyHidden", "selectOnFocus": true, "emptyText": "Organisation ausw\u00e4hlen...", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/aids/RefundConfirmations/company", "method": "GET" }) }) });
    var contact_person2500 = new Lino.TwinCombo({ "preferred_width": 20, "autoHeight": true, "fieldLabel": "Empf\u00e4nger (Person)", "name": "contact_person", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.contacts.Persons.detail,Lino.contacts.Persons.insert)}, "hiddenName": "contact_personHidden", "selectOnFocus": true, "emptyText": "Person ausw\u00e4hlen...", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/aids/RefundConfirmations/contact_person", "method": "GET" }) }) });
    var printed_disp2501 = new Ext.form.DisplayField({ "disabled": true, "autoHeight": true, "fieldLabel": "Ausgedruckt", "name": "printed", "anchor": "-20", "value": "<br/>", "always_enabled": true });
    var main_4_panel2502 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 225, "hideCheckBoxLabels": true, "items": [ { "flex": 28, "autoHeight": true, "layout": "form", "xtype": "panel", "items": company2499, "labelAlign": "top" }, { "flex": 28, "autoHeight": true, "layout": "form", "xtype": "panel", "items": contact_person2500, "labelAlign": "top" }, { "flex": 42, "autoHeight": true, "layout": "form", "xtype": "panel", "items": printed_disp2501, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var remark2506 = new Lino.RichTextPanel({ "selectOnFocus": true, "flex": 38, "containing_panel": this, "name": "remark", "title": "Bemerkung" });
    var main_panel2507 = new Ext.Panel({ "autoScroll": false, "border": false, "layout": "vbox", "labelWidth": 0, "hideCheckBoxLabels": true, "items": [ main_1_panel2479, main_2_panel2488, main_3_panel2495, main_4_panel2502, remark2506 ], "frame": true, "layoutConfig": { "align": "stretch" }, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel2507;
    this.before_row_edit = function(record) {
      doctor2493.setContextValue('doctor_type', record ? record.data['doctor_typeHidden'] : undefined);
      pharmacy2494.setContextValue('granting', record ? record.data['grantingHidden'] : undefined);
      contact_person2500.setContextValue('company', record ? record.data['companyHidden'] : undefined);
      remark2506.refresh();
    }
    this.onRender = function(ct, position) {
      doctor_type2492.on('change',Lino.chooser_handler(doctor2493,'doctor_type'));
      granting2485.on('change',Lino.chooser_handler(pharmacy2494,'granting'));
      company2499.on('change',Lino.chooser_handler(contact_person2500,'company'));
      Lino.aids.RefundConfirmations.DetailFormPanel.superclass.onRender.call(this, ct, position);
    }
    Lino.aids.RefundConfirmations.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.aids.IncomeConfirmationsByGranting.InsertFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 112,
  initComponent : function() {
    var start_date556 = new Lino.DateField({ "selectOnFocus": true, "autoHeight": true, "fieldLabel": "Periode vom", "anchor": "-20", "name": "start_date" });
    var end_date557 = new Lino.DateField({ "selectOnFocus": true, "autoHeight": true, "fieldLabel": "bis", "anchor": "-20", "name": "end_date" });
    var main_2_panel558 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 108, "hideCheckBoxLabels": true, "items": [ { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": start_date556, "labelAlign": "top" }, { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": end_date557, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var category561 = new Lino.TwinCombo({ "autoHeight": true, "fieldLabel": "Kategorie", "name": "category", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.aids.Categories.detail,Lino.aids.Categories.insert)}, "emptyText": "Kategorie ausw\u00e4hlen...", "selectOnFocus": true, "hiddenName": "categoryHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/aids/IncomeConfirmationsByGranting/category", "method": "GET" }) }) });
    var amount562 = new Ext.form.NumberField({ "autoHeight": true, "decimalPrecision": 2, "fieldLabel": "Betrag", "name": "amount", "decimalSeparator": ",", "selectOnFocus": true, "anchor": "-20", "allowBlank": true });
    var main_3_panel563 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 90, "hideCheckBoxLabels": true, "items": [ { "flex": 62, "autoHeight": true, "layout": "form", "xtype": "panel", "items": category561, "labelAlign": "top" }, { "flex": 37, "autoHeight": true, "layout": "form", "xtype": "panel", "items": amount562, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var company566 = new Lino.TwinCombo({ "preferred_width": 20, "autoHeight": true, "fieldLabel": "Empf\u00e4nger (Organisation)", "name": "company", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.contacts.Companies.detail,Lino.contacts.Companies.insert)}, "hiddenName": "companyHidden", "selectOnFocus": true, "emptyText": "Organisation ausw\u00e4hlen...", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/aids/IncomeConfirmationsByGranting/company", "method": "GET" }) }) });
    var contact_person567 = new Lino.TwinCombo({ "preferred_width": 20, "autoHeight": true, "fieldLabel": "Empf\u00e4nger (Person)", "name": "contact_person", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.contacts.Persons.detail,Lino.contacts.Persons.insert)}, "hiddenName": "contact_personHidden", "selectOnFocus": true, "emptyText": "Person ausw\u00e4hlen...", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/aids/IncomeConfirmationsByGranting/contact_person", "method": "GET" }) }) });
    var main_4_panel568 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 225, "hideCheckBoxLabels": true, "items": [ { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": company566, "labelAlign": "top" }, { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": contact_person567, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var remark571 = new Lino.RichTextPanel({ "selectOnFocus": true, "flex": 62, "containing_panel": this, "name": "remark", "title": "Bemerkung" });
    var main_panel572 = new Ext.Panel({ "autoScroll": false, "border": false, "layout": "vbox", "labelWidth": 0, "hideCheckBoxLabels": true, "items": [ main_2_panel558, main_3_panel563, main_4_panel568, remark571 ], "frame": true, "layoutConfig": { "align": "stretch" }, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel572;
    this.before_row_edit = function(record) {
      contact_person567.setContextValue('company', record ? record.data['companyHidden'] : undefined);
      remark571.refresh();
    }
    this.onRender = function(ct, position) {
      company566.on('change',Lino.chooser_handler(contact_person567,'company'));
      Lino.aids.IncomeConfirmationsByGranting.InsertFormPanel.superclass.onRender.call(this, ct, position);
    }
    Lino.aids.IncomeConfirmationsByGranting.InsertFormPanel.superclass.initComponent.call(this);
  }
});


Lino.contacts.Persons.InsertFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  autoHeight: true,
  content_type: 18,
  initComponent : function() {
    var first_name1244 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Vorname</span>", "name": "first_name", "listeners": { "render": Lino.quicktip_renderer("Vorname","First or given name.") }, "maxLength": 200, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var last_name1245 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Familienname</span>", "name": "last_name", "listeners": { "render": Lino.quicktip_renderer("Familienname","Last name (family name).") }, "maxLength": 200, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var main_1_panel1246 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": first_name1244, "labelAlign": "top" }, { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": last_name1245, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 117, "border": false, "anchor": "-20", "labelAlign": "top" });
    var gender1249 = new Lino.ChoicesFieldElement({ "autoHeight": true, "forceSelection": true, "fieldLabel": "Geschlecht", "name": "gender", "hiddenName": "genderHidden", "selectOnFocus": true, "anchor": "-20", "store": [['','<br>']].concat(Lino.system.Genders) });
    var language1250 = new Lino.ChoicesFieldElement({ "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Sprache</span>", "allowBlank": false, "hiddenName": "languageHidden", "listeners": { "render": Lino.quicktip_renderer("Sprache","Die Sprache, in der Dokumente ausgestellt werden sollen.") }, "selectOnFocus": true, "anchor": "-20", "store": [ [ "de", "Deutsch" ], [ "fr", "Franz\u00f6sisch" ], [ "nl", "Niederl\u00e4ndisch" ] ], "name": "language" });
    var main_2_panel1251 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 35, "autoHeight": true, "layout": "form", "xtype": "panel", "items": gender1249, "labelAlign": "top" }, { "flex": 64, "autoHeight": true, "layout": "form", "xtype": "panel", "items": language1250, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 99, "border": false, "anchor": "-20", "labelAlign": "top" });
    var main_panel1254 = new Ext.Panel({ "hideCheckBoxLabels": true, "autoHeight": true, "border": false, "layout": "form", "autoScroll": false, "items": [ main_1_panel1246, main_2_panel1251 ], "frame": true, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel1254;
    this.before_row_edit = function(record) {
    }
    Lino.contacts.Persons.InsertFormPanel.superclass.initComponent.call(this);
  }
});


Lino.cal.MyPresences.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 33,
  initComponent : function() {
    var event352 = new Lino.TwinCombo({ "autoHeight": true, "fieldLabel": "Termin", "allowBlank": false, "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.cal.OneEvent.detail,Lino.cal.OneEvent.insert)}, "emptyText": "Termin ausw\u00e4hlen...", "selectOnFocus": true, "hiddenName": "eventHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/Guests/event", "method": "GET" }) }), "name": "event" });
    var partner353 = new Lino.TwinCombo({ "preferred_width": 20, "autoHeight": true, "fieldLabel": "Partner", "allowBlank": false, "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.contacts.Partners.detail,Lino.contacts.Partners.insert)}, "emptyText": "Partner ausw\u00e4hlen...", "selectOnFocus": true, "hiddenName": "partnerHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/Guests/partner", "method": "GET" }) }), "name": "partner" });
    var role354 = new Lino.TwinCombo({ "autoHeight": true, "fieldLabel": "Rolle", "name": "role", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.cal.GuestRoles.detail,Lino.cal.GuestRoles.insert)}, "emptyText": "Gastrolle ausw\u00e4hlen...", "selectOnFocus": true, "hiddenName": "roleHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/Guests/role", "method": "GET" }) }) });
    var main_1_panel355 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 72, "hideCheckBoxLabels": true, "items": [ { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": event352, "labelAlign": "top" }, { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": partner353, "labelAlign": "top" }, { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": role354, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var state359 = new Lino.ChoicesFieldElement({ "autoHeight": true, "forceSelection": true, "fieldLabel": "Zustand", "allowBlank": false, "hiddenName": "stateHidden", "selectOnFocus": true, "anchor": "-20", "store": Lino.cal.GuestStates, "name": "state" });
    var remark360 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Bemerkung", "name": "remark", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var workflow_buttons_disp361 = new Ext.form.DisplayField({ "disabled": true, "autoHeight": true, "fieldLabel": "Arbeitsablauf", "name": "workflow_buttons", "anchor": "-20", "value": "<br/>", "always_enabled": true });
    var main_2_panel362 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 126, "hideCheckBoxLabels": true, "items": [ { "flex": 22, "autoHeight": true, "layout": "form", "xtype": "panel", "items": state359, "labelAlign": "top" }, { "flex": 31, "autoHeight": true, "layout": "form", "xtype": "panel", "items": remark360, "labelAlign": "top" }, { "flex": 45, "autoHeight": true, "layout": "form", "xtype": "panel", "items": workflow_buttons_disp361, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var waiting_since366 = new Ext.form.DisplayField({ "disabled": true, "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Wartet seit</span>", "name": "waiting_since", "listeners": { "render": Lino.quicktip_renderer("Wartet seit","Time when the visitor arrived (checked in).") }, "value": "<br>", "anchor": "-20" });
    var busy_since367 = new Ext.form.DisplayField({ "disabled": true, "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Hat gewartet bis</span>", "name": "busy_since", "listeners": { "render": Lino.quicktip_renderer("Hat gewartet bis","Time when the visitor was received by agent.") }, "value": "<br>", "anchor": "-20" });
    var gone_since368 = new Ext.form.DisplayField({ "disabled": true, "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Anwesend bis</span>", "name": "gone_since", "listeners": { "render": Lino.quicktip_renderer("Anwesend bis","Time when the visitor left (checked out).") }, "value": "<br>", "anchor": "-20" });
    var main_3_panel369 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 153, "hideCheckBoxLabels": true, "items": [ { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": waiting_since366, "labelAlign": "top" }, { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": busy_since367, "labelAlign": "top" }, { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": gone_since368, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var outbox_MailsByController_grid418 = new Lino.outbox.MailsByController.GridPanel({ "flex": 50, "hide_top_toolbar": true, "containing_panel": this, "tools": [ Lino.show_in_own_window_button(Lino.outbox.MailsByController.grid) ], "preview_limit": 15, "master_panel": this });
    var main_panel419 = new Ext.Panel({ "autoScroll": false, "border": false, "layout": "vbox", "hideCheckBoxLabels": true, "items": [ main_1_panel355, main_2_panel362, main_3_panel369, outbox_MailsByController_grid418 ], "frame": true, "layoutConfig": { "align": "stretch" }, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel419;
    this.before_row_edit = function(record) {
      outbox_MailsByController_grid418.on_master_changed();
    }
    Lino.cal.MyPresences.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.cbss.RetrieveTIGroupsRequests.InsertFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  autoHeight: true,
  content_type: 96,
  initComponent : function() {
    var person2426 = new Lino.TwinCombo({ "preferred_width": 20, "autoHeight": true, "fieldLabel": "Klient", "allowBlank": false, "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.pcsw.Clients.detail,Lino.pcsw.Clients.insert)}, "emptyText": "Klient ausw\u00e4hlen...", "selectOnFocus": true, "hiddenName": "personHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cbss/RetrieveTIGroupsRequests/person", "method": "GET" }) }), "name": "person" });
    var national_id2427 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "NR-Nummer", "name": "national_id", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var language2428 = new Lino.ChoicesFieldElement({ "autoHeight": true, "forceSelection": true, "fieldLabel": "Sprache", "name": "language", "hiddenName": "languageHidden", "selectOnFocus": true, "anchor": "-20", "store": [['','<br>']].concat(Lino.cbss.RequestLanguages) });
    var main_2_panel2429 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 55, "autoHeight": true, "layout": "form", "xtype": "panel", "items": national_id2427, "labelAlign": "top" }, { "flex": 44, "autoHeight": true, "layout": "form", "xtype": "panel", "items": language2428, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 90, "border": false, "anchor": "-20", "labelAlign": "top" });
    var history2432 = new Ext.form.Checkbox({ "autoHeight": true, "hideLabel": true, "checked": true, "name": "history", "listeners": { "render": Lino.quicktip_renderer("Historie","Whatever this means.") }, "boxLabel": "Historie", "selectOnFocus": true, "anchor": "-20" });
    var main_panel2433 = new Ext.Panel({ "hideCheckBoxLabels": true, "autoHeight": true, "border": false, "layout": "form", "labelWidth": 81, "autoScroll": false, "items": [ { "autoHeight": true, "layout": "form", "xtype": "panel", "items": person2426, "anchor": "-20", "labelAlign": "top" }, main_2_panel2429, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": history2432, "anchor": "-20", "labelAlign": "top" } ], "frame": true, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel2433;
    this.before_row_edit = function(record) {
    }
    Lino.cbss.RetrieveTIGroupsRequests.InsertFormPanel.superclass.initComponent.call(this);
  }
});


Lino.aids.SimpleConfirmationsByGranting.InsertFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 113,
  initComponent : function() {
    var start_date2678 = new Lino.DateField({ "selectOnFocus": true, "autoHeight": true, "fieldLabel": "Periode vom", "anchor": "-20", "name": "start_date" });
    var end_date2679 = new Lino.DateField({ "selectOnFocus": true, "autoHeight": true, "fieldLabel": "bis", "anchor": "-20", "name": "end_date" });
    var main_1_panel2680 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 108, "hideCheckBoxLabels": true, "items": [ { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": start_date2678, "labelAlign": "top" }, { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": end_date2679, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var company2683 = new Lino.TwinCombo({ "preferred_width": 20, "autoHeight": true, "fieldLabel": "Empf\u00e4nger (Organisation)", "name": "company", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.contacts.Companies.detail,Lino.contacts.Companies.insert)}, "hiddenName": "companyHidden", "selectOnFocus": true, "emptyText": "Organisation ausw\u00e4hlen...", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/aids/SimpleConfirmationsByGranting/company", "method": "GET" }) }) });
    var contact_person2684 = new Lino.TwinCombo({ "preferred_width": 20, "autoHeight": true, "fieldLabel": "Empf\u00e4nger (Person)", "name": "contact_person", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.contacts.Persons.detail,Lino.contacts.Persons.insert)}, "hiddenName": "contact_personHidden", "selectOnFocus": true, "emptyText": "Person ausw\u00e4hlen...", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/aids/SimpleConfirmationsByGranting/contact_person", "method": "GET" }) }) });
    var main_2_panel2685 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 225, "hideCheckBoxLabels": true, "items": [ { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": company2683, "labelAlign": "top" }, { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": contact_person2684, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var remark2688 = new Lino.RichTextPanel({ "selectOnFocus": true, "flex": 71, "containing_panel": this, "name": "remark", "title": "Bemerkung" });
    var main_panel2689 = new Ext.Panel({ "autoScroll": false, "border": false, "layout": "vbox", "labelWidth": 0, "hideCheckBoxLabels": true, "items": [ main_1_panel2680, main_2_panel2685, remark2688 ], "frame": true, "layoutConfig": { "align": "stretch" }, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel2689;
    this.before_row_edit = function(record) {
      contact_person2684.setContextValue('company', record ? record.data['companyHidden'] : undefined);
      remark2688.refresh();
    }
    this.onRender = function(ct, position) {
      company2683.on('change',Lino.chooser_handler(contact_person2684,'company'));
      Lino.aids.SimpleConfirmationsByGranting.InsertFormPanel.superclass.onRender.call(this, ct, position);
    }
    Lino.aids.SimpleConfirmationsByGranting.InsertFormPanel.superclass.initComponent.call(this);
  }
});


Lino.accounts.AccountsByGroup.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 40,
  initComponent : function() {
    var ref2615 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "ref", "name": "ref", "maxLength": 5, "selectOnFocus": true, "boxMinWidth": Lino.chars2width(5), "anchor": "-20" });
    var name2616 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Bezeichnung", "name": "name", "maxLength": 200, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var name_fr2617 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Bezeichnung (fr)", "name": "name_fr", "maxLength": 200, "selectOnFocus": true, "hidden": true, "anchor": "-20" });
    var name_nl2618 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Bezeichnung (nl)", "name": "name_nl", "maxLength": 200, "selectOnFocus": true, "hidden": true, "anchor": "-20" });
    var main_1_panel2619 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 153, "hideCheckBoxLabels": true, "items": [ { "flex": 8, "autoHeight": true, "layout": "form", "xtype": "panel", "items": ref2615, "labelAlign": "top" }, { "flex": 30, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name2616, "labelAlign": "top" }, { "flex": 30, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_fr2617, "hidden": true, "labelAlign": "top" }, { "flex": 30, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_nl2618, "hidden": true, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var group2624 = new Lino.TwinCombo({ "autoHeight": true, "fieldLabel": "Kontengruppe", "allowBlank": false, "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.accounts.Groups.detail,Lino.accounts.Groups.insert)}, "emptyText": "Kontengruppe ausw\u00e4hlen...", "selectOnFocus": true, "hiddenName": "groupHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/accounts/Accounts/group", "method": "GET" }) }), "name": "group" });
    var type2625 = new Lino.ChoicesFieldElement({ "autoHeight": true, "forceSelection": true, "fieldLabel": "Kontenart", "allowBlank": false, "hiddenName": "typeHidden", "selectOnFocus": true, "anchor": "-20", "store": Lino.accounts.AccountTypes, "name": "type" });
    var main_2_panel2626 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 117, "hideCheckBoxLabels": true, "items": [ { "flex": 52, "autoHeight": true, "layout": "form", "xtype": "panel", "items": group2624, "labelAlign": "top" }, { "flex": 47, "autoHeight": true, "layout": "form", "xtype": "panel", "items": type2625, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var required_for_household2629 = new Ext.form.Checkbox({ "boxLabel": "verpflichtend f\u00fcr Haushalte", "autoHeight": true, "hideLabel": true, "checked": false, "name": "required_for_household", "selectOnFocus": true, "anchor": "-20" });
    var required_for_person2630 = new Ext.form.Checkbox({ "boxLabel": "verpflichtend f\u00fcr Personen", "autoHeight": true, "hideLabel": true, "checked": false, "name": "required_for_person", "selectOnFocus": true, "anchor": "-20" });
    var periods2631 = new Ext.form.NumberField({ "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Perioden</span>", "name": "periods", "allowDecimals": false, "value": 1, "listeners": { "render": Lino.quicktip_renderer("Perioden","For how many months the entered amount counts. \nFor example 1 means a monthly amount, 12 a yearly amount.") }, "selectOnFocus": true, "anchor": "-20", "allowBlank": true });
    var default_amount2632 = new Ext.form.NumberField({ "autoHeight": true, "decimalPrecision": 2, "fieldLabel": "Standard-Betrag", "name": "default_amount", "decimalSeparator": ",", "selectOnFocus": true, "anchor": "-20", "allowBlank": true });
    var main_3_panel2633 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 252, "hideCheckBoxLabels": true, "items": [ { "flex": 27, "autoHeight": true, "layout": "form", "xtype": "panel", "items": required_for_household2629, "labelAlign": "top" }, { "flex": 27, "autoHeight": true, "layout": "form", "xtype": "panel", "items": required_for_person2630, "labelAlign": "top" }, { "flex": 13, "autoHeight": true, "layout": "form", "xtype": "panel", "items": periods2631, "labelAlign": "top" }, { "flex": 32, "autoHeight": true, "layout": "form", "xtype": "panel", "items": default_amount2632, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var main_panel2655 = new Ext.Panel({ "autoScroll": false, "border": false, "layout": "vbox", "hideCheckBoxLabels": true, "items": [ main_1_panel2619, main_2_panel2626, main_3_panel2633 ], "frame": true, "layoutConfig": { "align": "stretch" }, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel2655;
    this.before_row_edit = function(record) {
    }
    Lino.accounts.AccountsByGroup.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.system.MyTextFieldTemplates.InsertFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  autoHeight: true,
  content_type: 3,
  initComponent : function() {
    var name2530 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Bezeichnung", "name": "name", "maxLength": 200, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var user2531 = new Lino.TwinCombo({ "preferred_width": 15, "autoHeight": true, "fieldLabel": "Autor", "name": "user", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.users.Users.detail,Lino.users.Users.insert)}, "hiddenName": "userHidden", "selectOnFocus": true, "emptyText": "Benutzer ausw\u00e4hlen...", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/system/TextFieldTemplates/user", "method": "GET" }) }) });
    var main_panel2532 = new Ext.Panel({ "hideCheckBoxLabels": true, "autoHeight": true, "border": false, "layout": "form", "labelWidth": 108, "autoScroll": false, "items": [ { "autoHeight": true, "layout": "form", "xtype": "panel", "items": name2530, "anchor": "-20", "labelAlign": "top" }, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": user2531, "anchor": "-20", "labelAlign": "top" } ], "frame": true, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel2532;
    this.before_row_edit = function(record) {
    }
    Lino.system.MyTextFieldTemplates.InsertFormPanel.superclass.initComponent.call(this);
  }
});


Lino.humanlinks.LinksByHuman.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  autoHeight: true,
  content_type: 103,
  initComponent : function() {
    var parent2671 = new Lino.TwinCombo({ "preferred_width": 20, "autoHeight": true, "fieldLabel": "Vater/Mutter", "allowBlank": false, "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.contacts.Persons.detail,Lino.contacts.Persons.insert)}, "emptyText": "Person ausw\u00e4hlen...", "selectOnFocus": true, "hiddenName": "parentHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/humanlinks/Links/parent", "method": "GET" }) }), "name": "parent" });
    var child2672 = new Lino.TwinCombo({ "preferred_width": 20, "autoHeight": true, "fieldLabel": "Kind", "name": "child", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.contacts.Persons.detail,Lino.contacts.Persons.insert)}, "hiddenName": "childHidden", "selectOnFocus": true, "emptyText": "Person ausw\u00e4hlen...", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/humanlinks/Links/child", "method": "GET" }) }) });
    var type2673 = new Lino.ChoicesFieldElement({ "autoHeight": true, "forceSelection": true, "fieldLabel": "Verwandschaftsart", "allowBlank": false, "hiddenName": "typeHidden", "selectOnFocus": true, "anchor": "-20", "store": Lino.humanlinks.LinkTypes, "name": "type" });
    var main_panel2674 = new Ext.Panel({ "hideCheckBoxLabels": true, "autoHeight": true, "border": false, "layout": "form", "labelWidth": 162, "autoScroll": false, "items": [ { "autoHeight": true, "layout": "form", "xtype": "panel", "items": parent2671, "anchor": "-20", "labelAlign": "top" }, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": child2672, "anchor": "-20", "labelAlign": "top" }, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": type2673, "anchor": "-20", "labelAlign": "top" } ], "frame": true, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel2674;
    this.before_row_edit = function(record) {
    }
    Lino.humanlinks.LinksByHuman.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.pcsw.Clients.InsertFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  autoHeight: true,
  content_type: 55,
  initComponent : function() {
    var first_name2278 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Vorname</span>", "name": "first_name", "listeners": { "render": Lino.quicktip_renderer("Vorname","First or given name.") }, "maxLength": 200, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var last_name2279 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Familienname</span>", "name": "last_name", "listeners": { "render": Lino.quicktip_renderer("Familienname","Last name (family name).") }, "maxLength": 200, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var main_1_panel2280 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": first_name2278, "labelAlign": "top" }, { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": last_name2279, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 117, "border": false, "anchor": "-20", "labelAlign": "top" });
    var national_id2283 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "NR-Nummer", "name": "national_id", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var gender2284 = new Lino.ChoicesFieldElement({ "autoHeight": true, "forceSelection": true, "fieldLabel": "Geschlecht", "name": "gender", "hiddenName": "genderHidden", "selectOnFocus": true, "anchor": "-20", "store": [['','<br>']].concat(Lino.system.Genders) });
    var language2285 = new Lino.ChoicesFieldElement({ "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Sprache</span>", "allowBlank": false, "hiddenName": "languageHidden", "listeners": { "render": Lino.quicktip_renderer("Sprache","Die Sprache, in der Dokumente ausgestellt werden sollen.") }, "selectOnFocus": true, "anchor": "-20", "store": [ [ "de", "Deutsch" ], [ "fr", "Franz\u00f6sisch" ], [ "nl", "Niederl\u00e4ndisch" ] ], "name": "language" });
    var main_3_panel2286 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 35, "autoHeight": true, "layout": "form", "xtype": "panel", "items": gender2284, "labelAlign": "top" }, { "flex": 64, "autoHeight": true, "layout": "form", "xtype": "panel", "items": language2285, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 99, "border": false, "anchor": "-20", "labelAlign": "top" });
    var main_panel2289 = new Ext.Panel({ "hideCheckBoxLabels": true, "autoHeight": true, "border": false, "layout": "form", "labelWidth": 90, "autoScroll": false, "items": [ main_1_panel2280, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": national_id2283, "anchor": "-20", "labelAlign": "top" }, main_3_panel2286 ], "frame": true, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel2289;
    this.before_row_edit = function(record) {
    }
    Lino.pcsw.Clients.InsertFormPanel.superclass.initComponent.call(this);
  }
});


Lino.addresses.AddressesByPartner.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  autoHeight: true,
  content_type: 22,
  initComponent : function() {
    var country1298 = new Lino.TwinCombo({ "autoHeight": true, "fieldLabel": "Land", "name": "country", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.countries.Countries.detail,Lino.countries.Countries.insert)}, "emptyText": "Land ausw\u00e4hlen...", "selectOnFocus": true, "hiddenName": "countryHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/addresses/Addresses/country", "method": "GET" }) }) });
    var city1299 = new Lino.TwinCombo({ "autoHeight": true, "forceSelection": false, "fieldLabel": "Stadt", "name": "city", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.countries.Places.detail,Lino.countries.Places.insert)}, "emptyText": "Ort ausw\u00e4hlen...", "selectOnFocus": true, "hiddenName": "cityHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/addresses/Addresses/city", "method": "GET" }) }) });
    var zip_code1300 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Postleitzahl", "name": "zip_code", "maxLength": 10, "selectOnFocus": true, "boxMinWidth": Lino.chars2width(10), "anchor": "-20" });
    var main_1_panel1301 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 39, "autoHeight": true, "layout": "form", "xtype": "panel", "items": country1298, "labelAlign": "top" }, { "flex": 39, "autoHeight": true, "layout": "form", "xtype": "panel", "items": city1299, "labelAlign": "top" }, { "flex": 21, "autoHeight": true, "layout": "form", "xtype": "panel", "items": zip_code1300, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 117, "border": false, "anchor": "-20", "labelAlign": "top" });
    var addr11305 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Adresszeile vor Stra\u00dfe</span>", "name": "addr1", "maxLength": 200, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Adresszeile vor Stra\u00dfe","Adresszeile vor Stra\u00dfe") }, "anchor": "-20" });
    var street1306 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Stra\u00dfe</span>", "name": "street", "maxLength": 200, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Stra\u00dfe","Name der Stra\u00dfe, ohne Hausnummer") }, "anchor": "-20" });
    var street_no1307 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Nr.</span>", "name": "street_no", "boxMinWidth": Lino.chars2width(10), "listeners": { "render": Lino.quicktip_renderer("Nr.","Hausnummer") }, "maxLength": 10, "selectOnFocus": true, "anchor": "-20" });
    var street_box1308 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Box</span>", "name": "street_box", "boxMinWidth": Lino.chars2width(10), "listeners": { "render": Lino.quicktip_renderer("Box","Text to print after street nuber on the same line.") }, "maxLength": 10, "selectOnFocus": true, "anchor": "-20" });
    var main_3_panel1309 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 48, "autoHeight": true, "layout": "form", "xtype": "panel", "items": street1306, "labelAlign": "top" }, { "flex": 25, "autoHeight": true, "layout": "form", "xtype": "panel", "items": street_no1307, "labelAlign": "top" }, { "flex": 25, "autoHeight": true, "layout": "form", "xtype": "panel", "items": street_box1308, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 63, "border": false, "anchor": "-20", "labelAlign": "top" });
    var addr21313 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Adresszeile nach Stra\u00dfe</span>", "name": "addr2", "maxLength": 200, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Adresszeile nach Stra\u00dfe","Adresszeile nach Stra\u00dfe") }, "anchor": "-20" });
    var address_type1314 = new Lino.ChoicesFieldElement({ "autoHeight": true, "forceSelection": true, "fieldLabel": "Adressenart", "name": "address_type", "hiddenName": "address_typeHidden", "selectOnFocus": true, "anchor": "-20", "store": [['','<br>']].concat(Lino.addresses.AddressTypes) });
    var remark1315 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Bemerkung", "name": "remark", "maxLength": 50, "selectOnFocus": true, "anchor": "-20" });
    var main_5_panel1316 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 52, "autoHeight": true, "layout": "form", "xtype": "panel", "items": address_type1314, "labelAlign": "top" }, { "flex": 47, "autoHeight": true, "layout": "form", "xtype": "panel", "items": remark1315, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 108, "border": false, "anchor": "-20", "labelAlign": "top" });
    var data_source1319 = new Lino.ChoicesFieldElement({ "autoHeight": true, "forceSelection": true, "fieldLabel": "Datenquelle", "name": "data_source", "hiddenName": "data_sourceHidden", "disabled": true, "anchor": "-20", "store": Lino.addresses.DataSources });
    var partner1320 = new Lino.TwinCombo({ "preferred_width": 20, "autoHeight": true, "fieldLabel": "Partner", "allowBlank": false, "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.contacts.Partners.detail,Lino.contacts.Partners.insert)}, "emptyText": "Partner ausw\u00e4hlen...", "selectOnFocus": true, "hiddenName": "partnerHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/addresses/Addresses/partner", "method": "GET" }) }), "name": "partner" });
    var main_6_panel1321 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 57, "autoHeight": true, "layout": "form", "xtype": "panel", "items": data_source1319, "labelAlign": "top" }, { "flex": 42, "autoHeight": true, "layout": "form", "xtype": "panel", "items": partner1320, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 108, "border": false, "anchor": "-20", "labelAlign": "top" });
    var main_panel1324 = new Ext.Panel({ "hideCheckBoxLabels": true, "autoHeight": true, "border": false, "layout": "form", "labelWidth": 216, "autoScroll": false, "items": [ main_1_panel1301, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": addr11305, "anchor": "-20", "labelAlign": "top" }, main_3_panel1309, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": addr21313, "anchor": "-20", "labelAlign": "top" }, main_5_panel1316, main_6_panel1321 ], "frame": true, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel1324;
    this.before_row_edit = function(record) {
      city1299.setContextValue('country', record ? record.data['countryHidden'] : undefined);
      city1299.setContextValue('region', record ? record.data['regionHidden'] : undefined);
    }
    this.onRender = function(ct, position) {
      country1298.on('change',Lino.chooser_handler(city1299,'country'));
      Lino.addresses.AddressesByPartner.DetailFormPanel.superclass.onRender.call(this, ct, position);
    }
    Lino.addresses.AddressesByPartner.DetailFormPanel.superclass.initComponent.call(this);
    // active_fields:
    city1299.on("change", function(){ this.save() }, this);
    zip_code1300.on("change", function(){ this.save() }, this);
  }
});


Lino.outbox.MyOutbox.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 25,
  initComponent : function() {
    var subject384 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Betreff", "name": "subject", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var project385 = new Lino.TwinCombo({ "preferred_width": 20, "autoHeight": true, "fieldLabel": "Klient", "name": "project", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.pcsw.Clients.detail,Lino.pcsw.Clients.insert)}, "hiddenName": "projectHidden", "selectOnFocus": true, "emptyText": "Klient ausw\u00e4hlen...", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/outbox/Mails/project", "method": "GET" }) }) });
    var date386 = new Lino.DateField({ "autoHeight": true, "allowBlank": false, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Datum</span>", "name": "date", "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Datum","\n        The official date to be printed on the document.\n        ") }, "anchor": "-20" });
    var main_1_panel387 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 72, "hideCheckBoxLabels": true, "items": [ { "flex": 38, "autoHeight": true, "layout": "form", "xtype": "panel", "items": subject384, "labelAlign": "top" }, { "flex": 37, "autoHeight": true, "layout": "form", "xtype": "panel", "items": project385, "labelAlign": "top" }, { "flex": 24, "autoHeight": true, "layout": "form", "xtype": "panel", "items": date386, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var user391 = new Lino.TwinCombo({ "preferred_width": 15, "autoHeight": true, "fieldLabel": "Absender", "name": "user", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.users.Users.detail,Lino.users.Users.insert)}, "hiddenName": "userHidden", "selectOnFocus": true, "emptyText": "Benutzer ausw\u00e4hlen...", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/outbox/Mails/user", "method": "GET" }) }) });
    var sent392 = new Ext.form.DisplayField({ "disabled": true, "autoHeight": true, "fieldLabel": "sent", "name": "sent", "anchor": "-20", "value": "<br>" });
    var id393 = new Ext.form.NumberField({ "selectOnFocus": true, "autoHeight": true, "fieldLabel": "ID", "anchor": "-20", "name": "id" });
    var owner_disp394 = new Ext.form.DisplayField({ "disabled": true, "autoHeight": true, "fieldLabel": "Verkn\u00fcpft mit", "anchor": "-20", "name": "owner" });
    var main_2_panel395 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 126, "hideCheckBoxLabels": true, "items": [ { "flex": 39, "autoHeight": true, "layout": "form", "xtype": "panel", "items": user391, "labelAlign": "top" }, { "flex": 31, "autoHeight": true, "layout": "form", "xtype": "panel", "items": sent392, "labelAlign": "top" }, { "flex": 9, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id393, "labelAlign": "top" }, { "flex": 19, "autoHeight": true, "layout": "form", "xtype": "panel", "items": owner_disp394, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var RecipientsByMail_grid406 = new Lino.outbox.RecipientsByMail.GridPanel({ "flex": 55, "hide_top_toolbar": true, "containing_panel": this, "tools": [ Lino.show_in_own_window_button(Lino.outbox.RecipientsByMail.grid) ], "preview_limit": 15, "master_panel": this });
    var AttachmentsByMail_htmlbox407 = new Lino.HtmlBoxPanel({ "flex": 22, "layout": "fit", "name": "AttachmentsByMail", "containing_panel": this, "items": new Ext.BoxComponent({autoScroll:true}), "title": "Anh\u00e4nge", "master_panel": this, "value": "<br/>", "always_enabled": true, "bodyStyle": "overflow-x:hidden;", "tools": [ Lino.show_in_own_window_button(Lino.outbox.AttachmentsByMail.grid) ] });
    var UploadsByController_htmlbox408 = new Lino.HtmlBoxPanel({ "flex": 22, "layout": "fit", "name": "UploadsByController", "containing_panel": this, "items": new Ext.BoxComponent({autoScroll:true}), "title": "Uploads", "master_panel": this, "value": "<br/>", "always_enabled": true, "bodyStyle": "overflow-x:hidden;", "tools": [ Lino.show_in_own_window_button(Lino.uploads.UploadsByController.grid) ] });
    var main_3_panel409 = new Ext.Panel({ "flex": 29, "border": false, "layout": "hbox", "labelWidth": 72, "hideCheckBoxLabels": true, "items": [ RecipientsByMail_grid406, AttachmentsByMail_htmlbox407, UploadsByController_htmlbox408 ], "autoScroll": false, "layoutConfig": { "align": "stretch" }, "frame": false, "labelAlign": "top" });
    var body410 = new Lino.RichTextPanel({ "selectOnFocus": true, "flex": 58, "containing_panel": this, "name": "body", "title": "Inhalt" });
    var main_panel411 = new Ext.Panel({ "autoScroll": false, "border": false, "layout": "vbox", "labelWidth": 0, "hideCheckBoxLabels": true, "items": [ main_1_panel387, main_2_panel395, main_3_panel409, body410 ], "frame": true, "layoutConfig": { "align": "stretch" }, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel411;
    this.before_row_edit = function(record) {
      RecipientsByMail_grid406.on_master_changed();
      AttachmentsByMail_htmlbox407.refresh();
      UploadsByController_htmlbox408.refresh();
      body410.refresh();
    }
    Lino.outbox.MyOutbox.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.contacts.Partners.InsertFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  autoHeight: true,
  content_type: 20,
  initComponent : function() {
    var name1083 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Name", "name": "name", "maxLength": 200, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var language1084 = new Lino.ChoicesFieldElement({ "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Sprache</span>", "allowBlank": false, "hiddenName": "languageHidden", "listeners": { "render": Lino.quicktip_renderer("Sprache","Die Sprache, in der Dokumente ausgestellt werden sollen.") }, "selectOnFocus": true, "anchor": "-20", "store": [ [ "de", "Deutsch" ], [ "fr", "Franz\u00f6sisch" ], [ "nl", "Niederl\u00e4ndisch" ] ], "name": "language" });
    var email1085 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "E-Mail", "name": "email", "maxLength": 75, "selectOnFocus": true, "anchor": "-20" });
    var main_2_panel1086 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 48, "autoHeight": true, "layout": "form", "xtype": "panel", "items": language1084, "labelAlign": "top" }, { "flex": 51, "autoHeight": true, "layout": "form", "xtype": "panel", "items": email1085, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 72, "border": false, "anchor": "-20", "labelAlign": "top" });
    var main_panel1089 = new Ext.Panel({ "hideCheckBoxLabels": true, "autoHeight": true, "border": false, "layout": "form", "labelWidth": 45, "autoScroll": false, "items": [ { "autoHeight": true, "layout": "form", "xtype": "panel", "items": name1083, "anchor": "-20", "labelAlign": "top" }, main_2_panel1086 ], "frame": true, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel1089;
    this.before_row_edit = function(record) {
    }
    Lino.contacts.Partners.InsertFormPanel.superclass.initComponent.call(this);
  }
});


Lino.cal.MyTasks.InsertFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  autoHeight: true,
  content_type: 28,
  initComponent : function() {
    var summary680 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Kurzbeschreibung", "name": "summary", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var user681 = new Lino.TwinCombo({ "preferred_width": 15, "autoHeight": true, "fieldLabel": "Autor", "name": "user", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.users.Users.detail,Lino.users.Users.insert)}, "hiddenName": "userHidden", "selectOnFocus": true, "emptyText": "Benutzer ausw\u00e4hlen...", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/Tasks/user", "method": "GET" }) }) });
    var project682 = new Lino.TwinCombo({ "preferred_width": 20, "autoHeight": true, "fieldLabel": "Klient", "name": "project", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.pcsw.Clients.detail,Lino.pcsw.Clients.insert)}, "hiddenName": "projectHidden", "selectOnFocus": true, "emptyText": "Klient ausw\u00e4hlen...", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/Tasks/project", "method": "GET" }) }) });
    var main_2_panel683 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": user681, "labelAlign": "top" }, { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": project682, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 63, "border": false, "anchor": "-20", "labelAlign": "top" });
    var main_panel686 = new Ext.Panel({ "hideCheckBoxLabels": true, "autoHeight": true, "border": false, "layout": "form", "labelWidth": 153, "autoScroll": false, "items": [ { "autoHeight": true, "layout": "form", "xtype": "panel", "items": summary680, "anchor": "-20", "labelAlign": "top" }, main_2_panel683 ], "frame": true, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel686;
    this.before_row_edit = function(record) {
    }
    Lino.cal.MyTasks.InsertFormPanel.superclass.initComponent.call(this);
  }
});


Lino.contacts.Companies.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 17,
  initComponent : function() {
    var overview_disp1261 = new Ext.form.DisplayField({ "disabled": true, "flex": 28, "name": "overview", "value": "<br/>", "always_enabled": true });
    var prefix1262 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Name prefix", "name": "prefix", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var name1263 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Name", "name": "name", "maxLength": 200, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var general2_1_panel1264 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": prefix1262, "labelAlign": "top" }, { "flex": 66, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name1263, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 108, "border": false, "anchor": "-20", "labelAlign": "top" });
    var type1267 = new Lino.RemoteComboFieldElement({ "autoHeight": true, "fieldLabel": "Organisationsart", "name": "type", "pageSize": 20, "emptyText": "Organisationsart ausw\u00e4hlen...", "selectOnFocus": true, "hiddenName": "typeHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/contacts/Companies/type", "method": "GET" }) }) });
    var vat_id1268 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "MWSt.-Nr.", "name": "vat_id", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var general2_2_panel1269 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 48, "autoHeight": true, "layout": "form", "xtype": "panel", "items": type1267, "labelAlign": "top" }, { "flex": 51, "autoHeight": true, "layout": "form", "xtype": "panel", "items": vat_id1268, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 153, "border": false, "anchor": "-20", "labelAlign": "top" });
    var client_contact_type1272 = new Lino.TwinCombo({ "autoHeight": true, "fieldLabel": "Klientenkontaktart", "name": "client_contact_type", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.pcsw.ClientContactTypes.detail,Lino.pcsw.ClientContactTypes.insert)}, "emptyText": "Klientenkontaktart ausw\u00e4hlen...", "selectOnFocus": true, "hiddenName": "client_contact_typeHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/contacts/Companies/client_contact_type", "method": "GET" }) }) });
    var url1273 = new Lino.URLField({ "autoHeight": true, "fieldLabel": "URL", "name": "url", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var general2_panel1274 = new Ext.Panel({ "flex": 42, "autoHeight": true, "layout": "form", "items": [ general2_1_panel1264, general2_2_panel1269, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": client_contact_type1272, "anchor": "-20", "labelAlign": "top" }, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": url1273, "anchor": "-20", "labelAlign": "top" } ], "frame": true, "bodyBorder": false, "autoScroll": false, "hideCheckBoxLabels": true, "labelWidth": 171, "border": false, "labelAlign": "top" });
    var email1277 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "E-Mail", "name": "email", "maxLength": 75, "selectOnFocus": true, "anchor": "-20" });
    var phone1278 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Telefon", "name": "phone", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var gsm1279 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "GSM", "name": "gsm", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var fax1280 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Fax", "name": "fax", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var general3_panel1281 = new Ext.Panel({ "flex": 28, "autoHeight": true, "layout": "form", "items": [ { "autoHeight": true, "layout": "form", "xtype": "panel", "items": email1277, "anchor": "-20", "labelAlign": "top" }, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": phone1278, "anchor": "-20", "labelAlign": "top" }, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": gsm1279, "anchor": "-20", "labelAlign": "top" }, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": fax1280, "anchor": "-20", "labelAlign": "top" } ], "frame": true, "bodyBorder": false, "autoScroll": false, "hideCheckBoxLabels": true, "labelWidth": 72, "border": false, "labelAlign": "top" });
    var general_1_panel1286 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 0, "hideCheckBoxLabels": true, "items": [ overview_disp1261, general2_panel1274, general3_panel1281 ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var contacts_RolesByCompany_grid1291 = new Lino.contacts.RolesByCompany.GridPanel({ "flex": 55, "hide_top_toolbar": true, "containing_panel": this, "tools": [ Lino.show_in_own_window_button(Lino.contacts.RolesByCompany.grid) ], "preview_limit": 15, "master_panel": this });
    var general_panel1292 = new Ext.Panel({ "layout": "vbox", "title": "Allgemein", "items": [ general_1_panel1286, contacts_RolesByCompany_grid1291 ], "frame": true, "layoutConfig": { "align": "stretch" }, "hideCheckBoxLabels": true, "listeners": { "activate": Lino.on_tab_activate }, "autoScroll": false, "border": false, "bodyBorder": false, "labelAlign": "top" });
    var addresses_AddressesByPartner_grid1345 = new Lino.addresses.AddressesByPartner.GridPanel({ "flex": 5, "hide_top_toolbar": true, "containing_panel": this, "region": "north", "preview_limit": 15, "master_panel": this, "split": true, "tools": [ Lino.show_in_own_window_button(Lino.addresses.AddressesByPartner.grid) ] });
    var remarks1346 = new Ext.form.TextArea({ "selectOnFocus": true, "fieldLabel": "Bemerkungen", "anchor": "-20 -10", "growMax": 2000, "name": "remarks" });
    var sepa_AccountsByPartner_grid1347 = new Lino.sepa.AccountsByPartner.GridPanel({ "flex": 64, "hide_top_toolbar": true, "containing_panel": this, "tools": [ Lino.show_in_own_window_button(Lino.sepa.AccountsByPartner.grid) ], "preview_limit": 15, "master_panel": this });
    var contact_2_panel1348 = new Ext.Panel({ "flex": 5, "layout": "hbox", "items": [ { "items": remarks1346, "labelAlign": "top", "layout": "form", "xtype": "panel", "flex": 35 }, sepa_AccountsByPartner_grid1347 ], "region": "center", "layoutConfig": { "align": "stretch" }, "hideCheckBoxLabels": true, "split": true, "autoScroll": false, "labelWidth": 108, "border": false, "frame": false, "labelAlign": "top" });
    var contact_panel1350 = new Lino.VBorderPanel({ "autoScroll": false, "listeners": { "activate": Lino.on_tab_activate }, "border": false, "title": "Kontakt", "hideCheckBoxLabels": true, "items": [ addresses_AddressesByPartner_grid1345, contact_2_panel1348 ], "frame": true, "bodyBorder": false, "labelAlign": "top" });
    var notes_NotesByCompany_grid1435 = new Lino.notes.NotesByCompany.GridPanel({ "listeners": { "activate": Lino.on_tab_activate }, "hide_top_toolbar": true, "containing_panel": this, "title": "Ereignisse/Notizen", "tools": [ Lino.show_in_own_window_button(Lino.notes.NotesByCompany.grid) ], "preview_limit": 15, "master_panel": this });
    var id1436 = new Ext.form.NumberField({ "selectOnFocus": true, "autoHeight": true, "fieldLabel": "ID", "anchor": "-20", "name": "id" });
    var language1437 = new Lino.ChoicesFieldElement({ "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Sprache</span>", "allowBlank": false, "hiddenName": "languageHidden", "listeners": { "render": Lino.quicktip_renderer("Sprache","Die Sprache, in der Dokumente ausgestellt werden sollen.") }, "selectOnFocus": true, "anchor": "-20", "store": [ [ "de", "Deutsch" ], [ "fr", "Franz\u00f6sisch" ], [ "nl", "Niederl\u00e4ndisch" ] ], "name": "language" });
    var activity1438 = new Lino.RemoteComboFieldElement({ "autoHeight": true, "fieldLabel": "Beruf", "name": "activity", "pageSize": 20, "emptyText": "Beruf ausw\u00e4hlen...", "selectOnFocus": true, "hiddenName": "activityHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/contacts/Companies/activity", "method": "GET" }) }) });
    var misc_1_panel1439 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 72, "hideCheckBoxLabels": true, "items": [ { "flex": 11, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id1436, "labelAlign": "top" }, { "flex": 44, "autoHeight": true, "layout": "form", "xtype": "panel", "items": language1437, "labelAlign": "top" }, { "flex": 44, "autoHeight": true, "layout": "form", "xtype": "panel", "items": activity1438, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var is_courseprovider1443 = new Ext.form.Checkbox({ "boxLabel": "ist Kursanbieter (<a href=\"javascript:Lino.show_mti_child('is_courseprovider',Lino.courses.CourseProviders.detail)\">zeigen</a>)", "autoHeight": true, "hideLabel": true, "name": "is_courseprovider", "selectOnFocus": true, "anchor": "-20" });
    var is_jobprovider1444 = new Ext.form.Checkbox({ "boxLabel": "Stellenanbieter (<a href=\"javascript:Lino.show_mti_child('is_jobprovider',Lino.jobs.JobProviders.detail)\">zeigen</a>)", "autoHeight": true, "hideLabel": true, "name": "is_jobprovider", "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Stellenanbieter","Whether this Company is also a Job Provider.") }, "anchor": "-20" });
    var is_obsolete1445 = new Ext.form.Checkbox({ "autoHeight": true, "hideLabel": true, "checked": false, "name": "is_obsolete", "listeners": { "render": Lino.quicktip_renderer("veraltet","Altf\u00e4lle sind Partner, deren Stammdaten nicht mehr gepflegt werden und \nf\u00fcr neue Operationen nicht benutzt werden k\u00f6nnen.") }, "boxLabel": "veraltet", "selectOnFocus": true, "anchor": "-20" });
    var misc_2_panel1446 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 153, "hideCheckBoxLabels": true, "items": [ { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": is_courseprovider1443, "labelAlign": "top" }, { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": is_jobprovider1444, "labelAlign": "top" }, { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": is_obsolete1445, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var created1450 = new Ext.form.DisplayField({ "disabled": true, "autoHeight": true, "fieldLabel": "Erstellt", "name": "created", "anchor": "-20", "value": "<br>" });
    var modified1451 = new Ext.form.DisplayField({ "disabled": true, "autoHeight": true, "fieldLabel": "Bearbeitet", "name": "modified", "anchor": "-20", "value": "<br>" });
    var misc_3_panel1452 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 99, "hideCheckBoxLabels": true, "items": [ { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": created1450, "labelAlign": "top" }, { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": modified1451, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var reception_AppointmentsByPartner_grid1455 = new Lino.reception.AppointmentsByPartner.GridPanel({ "flex": 62, "hide_top_toolbar": true, "containing_panel": this, "tools": [ Lino.show_in_own_window_button(Lino.reception.AppointmentsByPartner.grid) ], "preview_limit": 15, "master_panel": this });
    var misc_panel1456 = new Ext.Panel({ "layout": "vbox", "title": "Sonstiges", "items": [ misc_1_panel1439, misc_2_panel1446, misc_3_panel1452, reception_AppointmentsByPartner_grid1455 ], "frame": true, "layoutConfig": { "align": "stretch" }, "hideCheckBoxLabels": true, "listeners": { "activate": Lino.on_tab_activate }, "autoScroll": false, "border": false, "bodyBorder": false, "labelAlign": "top" });
    var main_panel1457 = new Ext.TabPanel({ "hideCheckBoxLabels": true, "border": false, "split": true, "autoScroll": false, "items": [ general_panel1292, contact_panel1350, notes_NotesByCompany_grid1435, misc_panel1456 ], "activeTab": 0, "bodyBorder": false, "frame": true, "labelAlign": "top" });
    this.items = main_panel1457;
    this.before_row_edit = function(record) {
      contacts_RolesByCompany_grid1291.on_master_changed();
      addresses_AddressesByPartner_grid1345.on_master_changed();
      sepa_AccountsByPartner_grid1347.on_master_changed();
      notes_NotesByCompany_grid1435.on_master_changed();
      reception_AppointmentsByPartner_grid1455.on_master_changed();
    }
    Lino.contacts.Companies.DetailFormPanel.superclass.initComponent.call(this);
    // active_fields:
  }
});


Lino.countries.PlacesByCountry.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 10,
  initComponent : function() {
    var name772 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Bezeichnung", "name": "name", "maxLength": 200, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var name_fr773 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Bezeichnung (fr)", "name": "name_fr", "maxLength": 200, "selectOnFocus": true, "hidden": true, "anchor": "-20" });
    var name_nl774 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Bezeichnung (nl)", "name": "name_nl", "maxLength": 200, "selectOnFocus": true, "hidden": true, "anchor": "-20" });
    var country775 = new Lino.TwinCombo({ "autoHeight": true, "fieldLabel": "Land", "allowBlank": false, "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.countries.Countries.detail,Lino.countries.Countries.insert)}, "emptyText": "Land ausw\u00e4hlen...", "selectOnFocus": true, "hiddenName": "countryHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/countries/Places/country", "method": "GET" }) }), "name": "country" });
    var inscode776 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">INS code</span>", "name": "inscode", "boxMinWidth": Lino.chars2width(5), "listeners": { "render": Lino.quicktip_renderer("INS code","The official code for this place                     used by statbel.fgov.be") }, "maxLength": 5, "selectOnFocus": true, "anchor": "-20" });
    var zip_code777 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "zip code", "name": "zip_code", "maxLength": 8, "selectOnFocus": true, "boxMinWidth": Lino.chars2width(8), "anchor": "-20" });
    var main_1_panel778 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 153, "hideCheckBoxLabels": true, "items": [ { "flex": 21, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name772, "labelAlign": "top" }, { "flex": 21, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_fr773, "hidden": true, "labelAlign": "top" }, { "flex": 21, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_nl774, "hidden": true, "labelAlign": "top" }, { "flex": 20, "autoHeight": true, "layout": "form", "xtype": "panel", "items": country775, "labelAlign": "top" }, { "flex": 6, "autoHeight": true, "layout": "form", "xtype": "panel", "items": inscode776, "labelAlign": "top" }, { "flex": 9, "autoHeight": true, "layout": "form", "xtype": "panel", "items": zip_code777, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var parent785 = new Lino.TwinCombo({ "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Teil von</span>", "name": "parent", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.countries.Places.detail,Lino.countries.Places.insert)}, "emptyText": "Ort ausw\u00e4hlen...", "listeners": { "render": Lino.quicktip_renderer("Teil von","The superordinate geographic place         of which this place is a part.") }, "selectOnFocus": true, "hiddenName": "parentHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/countries/Places/parent", "method": "GET" }) }) });
    var type786 = new Lino.RemoteComboFieldElement({ "autoHeight": true, "fieldLabel": "Ortsart", "name": "type", "selectOnFocus": true, "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/countries/Places/type", "method": "GET" }) }), "hiddenName": "typeHidden" });
    var id787 = new Ext.form.NumberField({ "selectOnFocus": true, "autoHeight": true, "fieldLabel": "ID", "anchor": "-20", "name": "id" });
    var main_2_panel788 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 81, "hideCheckBoxLabels": true, "items": [ { "flex": 57, "autoHeight": true, "layout": "form", "xtype": "panel", "items": parent785, "labelAlign": "top" }, { "flex": 28, "autoHeight": true, "layout": "form", "xtype": "panel", "items": type786, "labelAlign": "top" }, { "flex": 14, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id787, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var contacts_PartnersByCity_grid1136 = new Lino.contacts.PartnersByCity.GridPanel({ "flex": 50, "hide_top_toolbar": true, "containing_panel": this, "tools": [ Lino.show_in_own_window_button(Lino.contacts.PartnersByCity.grid) ], "preview_limit": 15, "master_panel": this });
    var main_4_panel1138 = new Ext.Panel({ "flex": 41, "border": false, "layout": "hbox", "hideCheckBoxLabels": true, "items": [ contacts_PartnersByCity_grid1136 ], "autoScroll": false, "layoutConfig": { "align": "stretch" }, "frame": false, "labelAlign": "top" });
    var main_panel1139 = new Ext.Panel({ "autoScroll": false, "border": false, "layout": "vbox", "hideCheckBoxLabels": true, "items": [ main_1_panel778, main_2_panel788, main_4_panel1138 ], "frame": true, "layoutConfig": { "align": "stretch" }, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel1139;
    this.before_row_edit = function(record) {
      type786.setContextValue('country', record ? record.data['countryHidden'] : undefined);
      contacts_PartnersByCity_grid1136.on_master_changed();
    }
    this.onRender = function(ct, position) {
      country775.on('change',Lino.chooser_handler(type786,'country'));
      Lino.countries.PlacesByCountry.DetailFormPanel.superclass.onRender.call(this, ct, position);
    }
    Lino.countries.PlacesByCountry.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.contacts.Companies.InsertFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  autoHeight: true,
  content_type: 17,
  initComponent : function() {
    var name1458 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Name", "name": "name", "maxLength": 200, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var language1459 = new Lino.ChoicesFieldElement({ "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Sprache</span>", "allowBlank": false, "hiddenName": "languageHidden", "listeners": { "render": Lino.quicktip_renderer("Sprache","Die Sprache, in der Dokumente ausgestellt werden sollen.") }, "selectOnFocus": true, "anchor": "-20", "store": [ [ "de", "Deutsch" ], [ "fr", "Franz\u00f6sisch" ], [ "nl", "Niederl\u00e4ndisch" ] ], "name": "language" });
    var email1460 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "E-Mail", "name": "email", "maxLength": 75, "selectOnFocus": true, "anchor": "-20" });
    var main_2_panel1461 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": language1459, "labelAlign": "top" }, { "flex": 66, "autoHeight": true, "layout": "form", "xtype": "panel", "items": email1460, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 72, "border": false, "anchor": "-20", "labelAlign": "top" });
    var type1464 = new Lino.RemoteComboFieldElement({ "autoHeight": true, "fieldLabel": "Organisationsart", "name": "type", "pageSize": 20, "emptyText": "Organisationsart ausw\u00e4hlen...", "selectOnFocus": true, "hiddenName": "typeHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/contacts/Companies/type", "method": "GET" }) }) });
    var id1465 = new Ext.form.NumberField({ "selectOnFocus": true, "autoHeight": true, "fieldLabel": "ID", "anchor": "-20", "name": "id" });
    var main_3_panel1466 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 80, "autoHeight": true, "layout": "form", "xtype": "panel", "items": type1464, "labelAlign": "top" }, { "flex": 20, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id1465, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 153, "border": false, "anchor": "-20", "labelAlign": "top" });
    var main_panel1469 = new Ext.Panel({ "hideCheckBoxLabels": true, "autoHeight": true, "border": false, "layout": "form", "labelWidth": 45, "autoScroll": false, "items": [ { "autoHeight": true, "layout": "form", "xtype": "panel", "items": name1458, "anchor": "-20", "labelAlign": "top" }, main_2_panel1461, main_3_panel1466 ], "frame": true, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel1469;
    this.before_row_edit = function(record) {
    }
    Lino.contacts.Companies.InsertFormPanel.superclass.initComponent.call(this);
  }
});


Lino.languages.Languages.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 39,
  initComponent : function() {
    var id2318 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "id", "name": "id", "boxMinWidth": Lino.chars2width(3), "maxLength": 3, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var iso22319 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "iso2", "name": "iso2", "maxLength": 2, "selectOnFocus": true, "boxMinWidth": Lino.chars2width(2), "anchor": "-20" });
    var name2320 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Bezeichnung", "name": "name", "maxLength": 200, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var name_fr2321 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Bezeichnung (fr)", "name": "name_fr", "maxLength": 200, "selectOnFocus": true, "hidden": true, "anchor": "-20" });
    var name_nl2322 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Bezeichnung (nl)", "name": "name_nl", "maxLength": 200, "selectOnFocus": true, "hidden": true, "anchor": "-20" });
    var main_1_panel2323 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 153, "hideCheckBoxLabels": true, "items": [ { "flex": 5, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id2318, "labelAlign": "top" }, { "flex": 5, "autoHeight": true, "layout": "form", "xtype": "panel", "items": iso22319, "labelAlign": "top" }, { "flex": 29, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name2320, "labelAlign": "top" }, { "flex": 29, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_fr2321, "hidden": true, "labelAlign": "top" }, { "flex": 29, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_nl2322, "hidden": true, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var main_panel2336 = new Ext.Panel({ "autoScroll": false, "border": false, "layout": "vbox", "hideCheckBoxLabels": true, "items": [ main_1_panel2323 ], "frame": true, "layoutConfig": { "align": "stretch" }, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel2336;
    this.before_row_edit = function(record) {
    }
    Lino.languages.Languages.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.households.HouseholdsByType.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 101,
  initComponent : function() {
    var type2569 = new Lino.TwinCombo({ "autoHeight": true, "fieldLabel": "Haushaltsart", "name": "type", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.households.Types.detail,Lino.households.Types.insert)}, "emptyText": "Haushaltsart ausw\u00e4hlen...", "selectOnFocus": true, "hiddenName": "typeHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/households/HouseholdsByType/type", "method": "GET" }) }) });
    var name2570 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Name", "name": "name", "maxLength": 200, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var language2571 = new Lino.ChoicesFieldElement({ "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Sprache</span>", "allowBlank": false, "hiddenName": "languageHidden", "listeners": { "render": Lino.quicktip_renderer("Sprache","Die Sprache, in der Dokumente ausgestellt werden sollen.") }, "selectOnFocus": true, "anchor": "-20", "store": [ [ "de", "Deutsch" ], [ "fr", "Franz\u00f6sisch" ], [ "nl", "Niederl\u00e4ndisch" ] ], "name": "language" });
    var id2572 = new Ext.form.NumberField({ "selectOnFocus": true, "autoHeight": true, "fieldLabel": "ID", "anchor": "-20", "name": "id" });
    var main_1_panel2573 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 117, "hideCheckBoxLabels": true, "items": [ { "flex": 35, "autoHeight": true, "layout": "form", "xtype": "panel", "items": type2569, "labelAlign": "top" }, { "flex": 37, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name2570, "labelAlign": "top" }, { "flex": 17, "autoHeight": true, "layout": "form", "xtype": "panel", "items": language2571, "labelAlign": "top" }, { "flex": 8, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id2572, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var country2578 = new Lino.TwinCombo({ "autoHeight": true, "fieldLabel": "Land", "name": "country", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.countries.Countries.detail,Lino.countries.Countries.insert)}, "emptyText": "Land ausw\u00e4hlen...", "selectOnFocus": true, "hiddenName": "countryHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/households/HouseholdsByType/country", "method": "GET" }) }) });
    var region2579 = new Lino.TwinCombo({ "autoHeight": true, "fieldLabel": "Regierungsbezirk", "name": "region", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.countries.Places.detail,Lino.countries.Places.insert)}, "emptyText": "Ort ausw\u00e4hlen...", "selectOnFocus": true, "hiddenName": "regionHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/households/HouseholdsByType/region", "method": "GET" }) }) });
    var box3_1_panel2580 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": country2578, "labelAlign": "top" }, { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": region2579, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 153, "border": false, "anchor": "-20", "labelAlign": "top" });
    var city2583 = new Lino.TwinCombo({ "autoHeight": true, "forceSelection": false, "fieldLabel": "Stadt", "name": "city", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.countries.Places.detail,Lino.countries.Places.insert)}, "emptyText": "Ort ausw\u00e4hlen...", "selectOnFocus": true, "hiddenName": "cityHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/households/HouseholdsByType/city", "method": "GET" }) }) });
    var zip_code2584 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Postleitzahl", "name": "zip_code", "maxLength": 10, "selectOnFocus": true, "boxMinWidth": Lino.chars2width(10), "anchor": "-20" });
    var box3_2_panel2585 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 66, "autoHeight": true, "layout": "form", "xtype": "panel", "items": city2583, "labelAlign": "top" }, { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": zip_code2584, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 117, "border": false, "anchor": "-20", "labelAlign": "top" });
    var street_prefix2588 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Pr\u00e4fix Stra\u00dfe</span>", "name": "street_prefix", "maxLength": 200, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Pr\u00e4fix Stra\u00dfe","Text to print before name of street, but to ignore for sorting.") }, "anchor": "-20" });
    var street2589 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Stra\u00dfe</span>", "name": "street", "maxLength": 200, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Stra\u00dfe","Name der Stra\u00dfe, ohne Hausnummer") }, "anchor": "-20" });
    var street_no2590 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Nr.</span>", "name": "street_no", "boxMinWidth": Lino.chars2width(10), "listeners": { "render": Lino.quicktip_renderer("Nr.","Hausnummer") }, "maxLength": 10, "selectOnFocus": true, "anchor": "-20" });
    var street_box2591 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Box</span>", "name": "street_box", "boxMinWidth": Lino.chars2width(10), "listeners": { "render": Lino.quicktip_renderer("Box","Text to print after street nuber on the same line.") }, "maxLength": 10, "selectOnFocus": true, "anchor": "-20" });
    var box3_3_panel2592 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 30, "autoHeight": true, "layout": "form", "xtype": "panel", "items": street_prefix2588, "labelAlign": "top" }, { "flex": 36, "autoHeight": true, "layout": "form", "xtype": "panel", "items": street2589, "labelAlign": "top" }, { "flex": 16, "autoHeight": true, "layout": "form", "xtype": "panel", "items": street_no2590, "labelAlign": "top" }, { "flex": 16, "autoHeight": true, "layout": "form", "xtype": "panel", "items": street_box2591, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 126, "border": false, "anchor": "-20", "labelAlign": "top" });
    var addr22597 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Adresszeile nach Stra\u00dfe</span>", "name": "addr2", "maxLength": 200, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Adresszeile nach Stra\u00dfe","Adresszeile nach Stra\u00dfe") }, "anchor": "-20" });
    var box3_panel2598 = new Ext.Panel({ "flex": 62, "autoHeight": true, "layout": "form", "items": [ box3_1_panel2580, box3_2_panel2585, box3_3_panel2592, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": addr22597, "anchor": "-20", "labelAlign": "top" } ], "frame": true, "bodyBorder": false, "autoScroll": false, "hideCheckBoxLabels": true, "labelWidth": 216, "border": false, "labelAlign": "top" });
    var phone2600 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Telefon", "name": "phone", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var gsm2601 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "GSM", "name": "gsm", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var email2602 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "E-Mail", "name": "email", "maxLength": 75, "selectOnFocus": true, "anchor": "-20" });
    var url2603 = new Lino.URLField({ "autoHeight": true, "fieldLabel": "URL", "name": "url", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var box4_panel2604 = new Ext.Panel({ "flex": 37, "autoHeight": true, "layout": "form", "items": [ { "autoHeight": true, "layout": "form", "xtype": "panel", "items": phone2600, "anchor": "-20", "labelAlign": "top" }, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": gsm2601, "anchor": "-20", "labelAlign": "top" }, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": email2602, "anchor": "-20", "labelAlign": "top" }, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": url2603, "anchor": "-20", "labelAlign": "top" } ], "frame": true, "bodyBorder": false, "autoScroll": false, "hideCheckBoxLabels": true, "labelWidth": 72, "border": false, "labelAlign": "top" });
    var address_box_panel2609 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "hideCheckBoxLabels": true, "items": [ box3_panel2598, box4_panel2604 ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var remarks2610 = new Ext.form.TextArea({ "selectOnFocus": true, "fieldLabel": "Bemerkungen", "anchor": "-20 -10", "growMax": 2000, "name": "remarks" });
    var households_MembersByHousehold_grid2611 = new Lino.households.MembersByHousehold.GridPanel({ "flex": 66, "hide_top_toolbar": true, "containing_panel": this, "tools": [ Lino.show_in_own_window_button(Lino.households.MembersByHousehold.grid) ], "preview_limit": 15, "master_panel": this });
    var bottom_box_panel2612 = new Ext.Panel({ "flex": 50, "border": false, "layout": "hbox", "labelWidth": 108, "hideCheckBoxLabels": true, "items": [ { "items": remarks2610, "labelAlign": "top", "layout": "form", "xtype": "panel", "flex": 33 }, households_MembersByHousehold_grid2611 ], "autoScroll": false, "layoutConfig": { "align": "stretch" }, "frame": false, "labelAlign": "top" });
    var main_panel2614 = new Ext.Panel({ "autoScroll": false, "border": false, "layout": "vbox", "hideCheckBoxLabels": true, "items": [ main_1_panel2573, address_box_panel2609, bottom_box_panel2612 ], "frame": true, "layoutConfig": { "align": "stretch" }, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel2614;
    this.before_row_edit = function(record) {
      region2579.setContextValue('country', record ? record.data['countryHidden'] : undefined);
      city2583.setContextValue('country', record ? record.data['countryHidden'] : undefined);
      city2583.setContextValue('region', record ? record.data['regionHidden'] : undefined);
      households_MembersByHousehold_grid2611.on_master_changed();
    }
    this.onRender = function(ct, position) {
      country2578.on('change',Lino.chooser_handler(region2579,'country'));
      country2578.on('change',Lino.chooser_handler(city2583,'country'));
      region2579.on('change',Lino.chooser_handler(city2583,'region'));
      Lino.households.HouseholdsByType.DetailFormPanel.superclass.onRender.call(this, ct, position);
    }
    Lino.households.HouseholdsByType.DetailFormPanel.superclass.initComponent.call(this);
    // active_fields:
    city2583.on("change", function(){ this.save() }, this);
    zip_code2584.on("change", function(){ this.save() }, this);
  }
});


Lino.isip.ContractPartners.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 75,
  initComponent : function() {
    var company1553 = new Lino.TwinCombo({ "preferred_width": 20, "autoHeight": true, "fieldLabel": "Organisation", "name": "company", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.contacts.Companies.detail,Lino.contacts.Companies.insert)}, "hiddenName": "companyHidden", "selectOnFocus": true, "emptyText": "Organisation ausw\u00e4hlen...", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/isip/ContractPartners/company", "method": "GET" }) }) });
    var contact_person1554 = new Lino.TwinCombo({ "preferred_width": 20, "autoHeight": true, "fieldLabel": "Vertreten durch", "name": "contact_person", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.contacts.Persons.detail,Lino.contacts.Persons.insert)}, "hiddenName": "contact_personHidden", "selectOnFocus": true, "emptyText": "Person ausw\u00e4hlen...", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/isip/ContractPartners/contact_person", "method": "GET" }) }) });
    var contact_role1555 = new Lino.RemoteComboFieldElement({ "autoHeight": true, "fieldLabel": "in seiner Eigenschaft als", "name": "contact_role", "pageSize": 20, "emptyText": "Funktion ausw\u00e4hlen...", "selectOnFocus": true, "hiddenName": "contact_roleHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/isip/ContractPartners/contact_role", "method": "GET" }) }) });
    var main_1_panel1556 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 234, "hideCheckBoxLabels": true, "items": [ { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": company1553, "labelAlign": "top" }, { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": contact_person1554, "labelAlign": "top" }, { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": contact_role1555, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var duties_company1560 = new Lino.RichTextPanel({ "selectOnFocus": true, "flex": 83, "containing_panel": this, "name": "duties_company", "title": "Verpflichtungen Firma" });
    var main_panel1561 = new Ext.Panel({ "autoScroll": false, "border": false, "layout": "vbox", "labelWidth": 0, "hideCheckBoxLabels": true, "items": [ main_1_panel1556, duties_company1560 ], "frame": true, "layoutConfig": { "align": "stretch" }, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel1561;
    this.before_row_edit = function(record) {
      contact_person1554.setContextValue('company', record ? record.data['companyHidden'] : undefined);
      duties_company1560.refresh();
    }
    this.onRender = function(ct, position) {
      company1553.on('change',Lino.chooser_handler(contact_person1554,'company'));
      Lino.isip.ContractPartners.DetailFormPanel.superclass.onRender.call(this, ct, position);
    }
    Lino.isip.ContractPartners.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.changes.ChangesByObject.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 8,
  disable_editing: true,
  initComponent : function() {
    var time942 = new Ext.form.DisplayField({ "autoHeight": true, "fieldLabel": "time", "name": "time", "selectOnFocus": true, "anchor": "-20", "value": "<br>", "allowBlank": false });
    var user943 = new Lino.TwinCombo({ "preferred_width": 15, "autoHeight": true, "fieldLabel": "Benutzer", "allowBlank": false, "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.users.Users.detail,Lino.users.Users.insert)}, "emptyText": "Benutzer ausw\u00e4hlen...", "selectOnFocus": true, "hiddenName": "userHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/changes/Changes/user", "method": "GET" }) }), "name": "user" });
    var type944 = new Lino.ChoicesFieldElement({ "autoHeight": true, "forceSelection": true, "fieldLabel": "\u00c4nderungsart", "allowBlank": false, "hiddenName": "typeHidden", "selectOnFocus": true, "anchor": "-20", "store": Lino.lino.ChangeTypes, "name": "type" });
    var master_disp945 = new Ext.form.DisplayField({ "disabled": true, "autoHeight": true, "fieldLabel": "Stammdaten", "anchor": "-20", "name": "master" });
    var object_disp946 = new Ext.form.DisplayField({ "disabled": true, "autoHeight": true, "fieldLabel": "Object", "anchor": "-20", "name": "object" });
    var id947 = new Ext.form.NumberField({ "selectOnFocus": true, "autoHeight": true, "fieldLabel": "ID", "anchor": "-20", "name": "id" });
    var main_1_panel948 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 117, "hideCheckBoxLabels": true, "items": [ { "flex": 20, "autoHeight": true, "layout": "form", "xtype": "panel", "items": time942, "labelAlign": "top" }, { "flex": 25, "autoHeight": true, "layout": "form", "xtype": "panel", "items": user943, "labelAlign": "top" }, { "flex": 21, "autoHeight": true, "layout": "form", "xtype": "panel", "items": type944, "labelAlign": "top" }, { "flex": 12, "autoHeight": true, "layout": "form", "xtype": "panel", "items": master_disp945, "labelAlign": "top" }, { "flex": 12, "autoHeight": true, "layout": "form", "xtype": "panel", "items": object_disp946, "labelAlign": "top" }, { "flex": 6, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id947, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var diff955 = new Ext.form.TextArea({ "selectOnFocus": true, "fieldLabel": "\u00c4nderungen", "anchor": "-20 -10", "growMax": 2000, "name": "diff" });
    var main_panel956 = new Ext.Panel({ "autoScroll": false, "border": false, "layout": "vbox", "labelWidth": 99, "hideCheckBoxLabels": true, "items": [ main_1_panel948, { "items": diff955, "labelAlign": "top", "layout": "form", "xtype": "panel", "flex": 83 } ], "frame": true, "layoutConfig": { "align": "stretch" }, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel956;
    this.before_row_edit = function(record) {
    }
    Lino.changes.ChangesByObject.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.notes.Notes.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 107,
  initComponent : function() {
    var date1368 = new Lino.DateField({ "autoHeight": true, "fieldLabel": "Datum", "name": "date", "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var time1369 = new Lino.TimeField({ "selectOnFocus": true, "autoHeight": true, "fieldLabel": "Zeit", "anchor": "-20", "name": "time" });
    var event_type1370 = new Lino.TwinCombo({ "autoHeight": true, "fieldLabel": "Ereignisart (Form)", "name": "event_type", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.notes.EventTypes.detail,Lino.notes.EventTypes.insert)}, "emptyText": "Event Type ausw\u00e4hlen...", "selectOnFocus": true, "hiddenName": "event_typeHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/notes/Notes/event_type", "method": "GET" }) }) });
    var type1371 = new Lino.TwinCombo({ "autoHeight": true, "fieldLabel": "Notizart (Inhalt)", "name": "type", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.notes.NoteTypes.detail,Lino.notes.NoteTypes.insert)}, "emptyText": "Notizart ausw\u00e4hlen...", "selectOnFocus": true, "hiddenName": "typeHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/notes/Notes/type", "method": "GET" }) }) });
    var left_1_panel1372 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 171, "hideCheckBoxLabels": true, "items": [ { "flex": 14, "autoHeight": true, "layout": "form", "xtype": "panel", "items": date1368, "labelAlign": "top" }, { "flex": 11, "autoHeight": true, "layout": "form", "xtype": "panel", "items": time1369, "labelAlign": "top" }, { "flex": 36, "autoHeight": true, "layout": "form", "xtype": "panel", "items": event_type1370, "labelAlign": "top" }, { "flex": 36, "autoHeight": true, "layout": "form", "xtype": "panel", "items": type1371, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var project1377 = new Lino.TwinCombo({ "preferred_width": 20, "autoHeight": true, "fieldLabel": "Klient", "name": "project", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.pcsw.Clients.detail,Lino.pcsw.Clients.insert)}, "hiddenName": "projectHidden", "selectOnFocus": true, "emptyText": "Klient ausw\u00e4hlen...", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/notes/Notes/project", "method": "GET" }) }) });
    var subject1378 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Betreff", "name": "subject", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var left_2_panel1379 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 72, "hideCheckBoxLabels": true, "items": [ { "flex": 48, "autoHeight": true, "layout": "form", "xtype": "panel", "items": project1377, "labelAlign": "top" }, { "flex": 51, "autoHeight": true, "layout": "form", "xtype": "panel", "items": subject1378, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var company1382 = new Lino.TwinCombo({ "preferred_width": 20, "autoHeight": true, "fieldLabel": "Empf\u00e4nger (Organisation)", "name": "company", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.contacts.Companies.detail,Lino.contacts.Companies.insert)}, "hiddenName": "companyHidden", "selectOnFocus": true, "emptyText": "Organisation ausw\u00e4hlen...", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/notes/Notes/company", "method": "GET" }) }) });
    var contact_person1383 = new Lino.TwinCombo({ "preferred_width": 20, "autoHeight": true, "fieldLabel": "Empf\u00e4nger (Person)", "name": "contact_person", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.contacts.Persons.detail,Lino.contacts.Persons.insert)}, "hiddenName": "contact_personHidden", "selectOnFocus": true, "emptyText": "Person ausw\u00e4hlen...", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/notes/Notes/contact_person", "method": "GET" }) }) });
    var left_3_panel1384 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 225, "hideCheckBoxLabels": true, "items": [ { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": company1382, "labelAlign": "top" }, { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": contact_person1383, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var user1387 = new Lino.TwinCombo({ "preferred_width": 15, "autoHeight": true, "fieldLabel": "Autor", "name": "user", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.users.Users.detail,Lino.users.Users.insert)}, "hiddenName": "userHidden", "selectOnFocus": true, "emptyText": "Benutzer ausw\u00e4hlen...", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/notes/Notes/user", "method": "GET" }) }) });
    var language1388 = new Lino.ChoicesFieldElement({ "autoHeight": true, "fieldLabel": "Sprache", "allowBlank": false, "hiddenName": "languageHidden", "selectOnFocus": true, "anchor": "-20", "store": [ [ "de", "Deutsch" ], [ "fr", "Franz\u00f6sisch" ], [ "nl", "Niederl\u00e4ndisch" ] ], "name": "language" });
    var build_time1389 = new Ext.form.DisplayField({ "disabled": true, "autoHeight": true, "fieldLabel": "Druckdatum", "name": "build_time", "anchor": "-20", "value": "<br>" });
    var id1390 = new Ext.form.NumberField({ "selectOnFocus": true, "autoHeight": true, "fieldLabel": "ID", "anchor": "-20", "name": "id" });
    var left_4_panel1391 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 99, "hideCheckBoxLabels": true, "items": [ { "flex": 25, "autoHeight": true, "layout": "form", "xtype": "panel", "items": user1387, "labelAlign": "top" }, { "flex": 20, "autoHeight": true, "layout": "form", "xtype": "panel", "items": language1388, "labelAlign": "top" }, { "flex": 41, "autoHeight": true, "layout": "form", "xtype": "panel", "items": build_time1389, "labelAlign": "top" }, { "flex": 12, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id1390, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var body1396 = new Lino.RichTextPanel({ "selectOnFocus": true, "flex": 55, "containing_panel": this, "name": "body", "title": "Inhalt" });
    var left_panel1397 = new Ext.Panel({ "flex": 66, "layout": "vbox", "items": [ left_1_panel1372, left_2_panel1379, left_3_panel1384, left_4_panel1391, body1396 ], "frame": true, "layoutConfig": { "align": "stretch" }, "autoScroll": false, "hideCheckBoxLabels": true, "labelWidth": 0, "border": false, "bodyBorder": false, "labelAlign": "top" });
    var UploadsByController_htmlbox1398 = new Lino.HtmlBoxPanel({ "flex": 3, "layout": "fit", "name": "UploadsByController", "containing_panel": this, "items": new Ext.BoxComponent({autoScroll:true}), "region": "north", "title": "Uploads", "master_panel": this, "value": "<br/>", "always_enabled": true, "bodyStyle": "overflow-x:hidden;", "split": true, "tools": [ Lino.show_in_own_window_button(Lino.uploads.UploadsByController.grid) ] });
    var outbox_MailsByController_grid1399 = new Lino.outbox.MailsByController.GridPanel({ "flex": 5, "hide_top_toolbar": true, "containing_panel": this, "region": "center", "preview_limit": 15, "master_panel": this, "split": true, "tools": [ Lino.show_in_own_window_button(Lino.outbox.MailsByController.grid) ] });
    var cal_TasksByController_grid1421 = new Lino.cal.TasksByController.GridPanel({ "flex": 5, "hide_top_toolbar": true, "containing_panel": this, "region": "south", "params_panel_hidden": true, "master_panel": this, "preview_limit": 15, "split": true, "tools": [ Lino.show_in_own_window_button(Lino.cal.TasksByController.grid) ] });
    var right_panel1422 = new Lino.VBorderPanel({ "flex": 33, "border": false, "labelWidth": 72, "hideCheckBoxLabels": true, "items": [ UploadsByController_htmlbox1398, outbox_MailsByController_grid1399, cal_TasksByController_grid1421 ], "frame": true, "autoScroll": false, "bodyBorder": false, "labelAlign": "top" });
    var main_1_panel1423 = new Ext.Panel({ "autoScroll": false, "border": false, "layout": "hbox", "hideCheckBoxLabels": true, "items": [ left_panel1397, right_panel1422 ], "frame": false, "layoutConfig": { "align": "stretch" }, "labelAlign": "top" });
    var main_panel1424 = new Ext.Panel({ "autoScroll": false, "border": false, "layout": "fit", "hideCheckBoxLabels": true, "items": [ main_1_panel1423 ], "frame": true, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel1424;
    this.before_row_edit = function(record) {
      contact_person1383.setContextValue('company', record ? record.data['companyHidden'] : undefined);
      body1396.refresh();
      UploadsByController_htmlbox1398.refresh();
      outbox_MailsByController_grid1399.on_master_changed();
      cal_TasksByController_grid1421.on_master_changed();
    }
    this.onRender = function(ct, position) {
      company1382.on('change',Lino.chooser_handler(contact_person1383,'company'));
      Lino.notes.Notes.DetailFormPanel.superclass.onRender.call(this, ct, position);
    }
    Lino.notes.Notes.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.users.MySettings.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 6,
  initComponent : function() {
    var username573 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Benutzername</span>", "name": "username", "listeners": { "render": Lino.quicktip_renderer("Benutzername","Required. Must be unique.") }, "maxLength": 30, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var profile574 = new Lino.ChoicesFieldElement({ "autoHeight": true, "forceSelection": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Benutzerprofil</span>", "name": "profile", "hiddenName": "profileHidden", "listeners": { "render": Lino.quicktip_renderer("Benutzerprofil","Users with an empty `profile` field are considered inactive and cannot log in.") }, "selectOnFocus": true, "anchor": "-20", "store": [['','<br>']].concat(Lino.users.UserProfiles) });
    var partner575 = new Lino.TwinCombo({ "preferred_width": 20, "autoHeight": true, "fieldLabel": "Partner", "name": "partner", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.contacts.Partners.detail,Lino.contacts.Partners.insert)}, "hiddenName": "partnerHidden", "selectOnFocus": true, "emptyText": "Partner ausw\u00e4hlen...", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/users/Users/partner", "method": "GET" }) }) });
    var box1_1_panel576 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 34, "autoHeight": true, "layout": "form", "xtype": "panel", "items": username573, "labelAlign": "top" }, { "flex": 32, "autoHeight": true, "layout": "form", "xtype": "panel", "items": profile574, "labelAlign": "top" }, { "flex": 32, "autoHeight": true, "layout": "form", "xtype": "panel", "items": partner575, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 135, "border": false, "anchor": "-20", "labelAlign": "top" });
    var first_name580 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Vorname", "name": "first_name", "maxLength": 30, "selectOnFocus": true, "anchor": "-20" });
    var last_name581 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Familienname", "name": "last_name", "maxLength": 30, "selectOnFocus": true, "anchor": "-20" });
    var initials582 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Initialien", "name": "initials", "maxLength": 10, "selectOnFocus": true, "boxMinWidth": Lino.chars2width(10), "anchor": "-20" });
    var box1_2_panel583 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 39, "autoHeight": true, "layout": "form", "xtype": "panel", "items": first_name580, "labelAlign": "top" }, { "flex": 39, "autoHeight": true, "layout": "form", "xtype": "panel", "items": last_name581, "labelAlign": "top" }, { "flex": 20, "autoHeight": true, "layout": "form", "xtype": "panel", "items": initials582, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 117, "border": false, "anchor": "-20", "labelAlign": "top" });
    var email587 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "e-mail address", "name": "email", "maxLength": 75, "selectOnFocus": true, "anchor": "-20" });
    var language588 = new Lino.ChoicesFieldElement({ "autoHeight": true, "fieldLabel": "Sprache", "name": "language", "selectOnFocus": true, "anchor": "-20", "store": [ [ "de", "Deutsch" ], [ "fr", "Franz\u00f6sisch" ], [ "nl", "Niederl\u00e4ndisch" ] ], "hiddenName": "languageHidden" });
    var box1_3_panel589 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 51, "autoHeight": true, "layout": "form", "xtype": "panel", "items": email587, "labelAlign": "top" }, { "flex": 48, "autoHeight": true, "layout": "form", "xtype": "panel", "items": language588, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 135, "border": false, "anchor": "-20", "labelAlign": "top" });
    var id592 = new Ext.form.NumberField({ "selectOnFocus": true, "autoHeight": true, "fieldLabel": "ID", "anchor": "-20", "name": "id" });
    var created593 = new Ext.form.DisplayField({ "disabled": true, "autoHeight": true, "fieldLabel": "Erstellt", "name": "created", "anchor": "-20", "value": "<br>" });
    var modified594 = new Ext.form.DisplayField({ "disabled": true, "autoHeight": true, "fieldLabel": "Bearbeitet", "name": "modified", "anchor": "-20", "value": "<br>" });
    var box1_4_panel595 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 13, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id592, "labelAlign": "top" }, { "flex": 43, "autoHeight": true, "layout": "form", "xtype": "panel", "items": created593, "labelAlign": "top" }, { "flex": 43, "autoHeight": true, "layout": "form", "xtype": "panel", "items": modified594, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 99, "border": false, "anchor": "-20", "labelAlign": "top" });
    var box1_panel599 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "form", "hideCheckBoxLabels": true, "items": [ box1_1_panel576, box1_2_panel583, box1_3_panel589, box1_4_panel595 ], "frame": true, "bodyBorder": false, "labelAlign": "top" });
    var remarks600 = new Ext.form.TextArea({ "selectOnFocus": true, "fieldLabel": "Bemerkungen", "anchor": "-20 -10", "growMax": 2000, "name": "remarks" });
    var AuthoritiesGiven_grid603 = new Lino.users.AuthoritiesGiven.GridPanel({ "flex": 33, "hide_top_toolbar": true, "containing_panel": this, "master_panel": this, "tools": [ Lino.show_in_own_window_button(Lino.users.AuthoritiesGiven.grid) ], "hideHeaders": true, "preview_limit": 15 });
    var general_2_panel604 = new Ext.Panel({ "flex": 55, "border": false, "layout": "hbox", "labelWidth": 108, "hideCheckBoxLabels": true, "items": [ { "items": remarks600, "labelAlign": "top", "layout": "form", "xtype": "panel", "flex": 66 }, AuthoritiesGiven_grid603 ], "autoScroll": false, "layoutConfig": { "align": "stretch" }, "frame": false, "labelAlign": "top" });
    var general_panel606 = new Ext.Panel({ "layout": "vbox", "title": "Allgemein", "items": [ box1_panel599, general_2_panel604 ], "frame": true, "layoutConfig": { "align": "stretch" }, "hideCheckBoxLabels": true, "listeners": { "activate": Lino.on_tab_activate }, "autoScroll": false, "border": false, "bodyBorder": false, "labelAlign": "top" });
    var event_type607 = new Lino.TwinCombo({ "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Default Event Type</span>", "name": "event_type", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.cal.EventTypes.detail,Lino.cal.EventTypes.insert)}, "emptyText": "Ereignisart ausw\u00e4hlen...", "listeners": { "render": Lino.quicktip_renderer("Default Event Type","The default event type for your calendar events.") }, "selectOnFocus": true, "hiddenName": "event_typeHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/users/Users/event_type", "method": "GET" }) }) });
    var access_class608 = new Lino.ChoicesFieldElement({ "autoHeight": true, "forceSelection": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Standardm\u00e4\u00dfige Zugriffsklasse</span>", "allowBlank": false, "hiddenName": "access_classHidden", "listeners": { "render": Lino.quicktip_renderer("Standardm\u00e4\u00dfige Zugriffsklasse","Die standardm\u00e4\u00dfige Zugriffsklasse f\u00fcr Ihre Termine und Aufgaben") }, "selectOnFocus": true, "anchor": "-20", "store": Lino.cal.AccessClasses, "name": "access_class" });
    var cal_left_1_panel609 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 270, "hideCheckBoxLabels": true, "items": [ { "flex": 37, "autoHeight": true, "layout": "form", "xtype": "panel", "items": event_type607, "labelAlign": "top" }, { "flex": 62, "autoHeight": true, "layout": "form", "xtype": "panel", "items": access_class608, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var calendar612 = new Lino.TwinCombo({ "autoHeight": true, "fieldLabel": "Calendar where your events are published.", "name": "calendar", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.cal.Calendars.detail,Lino.cal.Calendars.insert)}, "emptyText": "Kalender ausw\u00e4hlen...", "selectOnFocus": true, "hiddenName": "calendarHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/users/Users/calendar", "method": "GET" }) }) });
    var cal_SubscriptionsByUser_grid617 = new Lino.cal.SubscriptionsByUser.GridPanel({ "flex": 71, "hide_top_toolbar": true, "containing_panel": this, "tools": [ Lino.show_in_own_window_button(Lino.cal.SubscriptionsByUser.grid) ], "preview_limit": 15, "master_panel": this });
    var cal_left_panel618 = new Ext.Panel({ "flex": 33, "layout": "vbox", "items": [ cal_left_1_panel609, { "items": calendar612, "autoHeight": true, "layout": "form", "xtype": "panel", "labelAlign": "top" }, cal_SubscriptionsByUser_grid617 ], "frame": true, "layoutConfig": { "align": "stretch" }, "autoScroll": false, "hideCheckBoxLabels": true, "labelWidth": 378, "border": false, "bodyBorder": false, "labelAlign": "top" });
    var cal_TasksByUser_grid688 = new Lino.cal.TasksByUser.GridPanel({ "flex": 66, "hide_top_toolbar": true, "containing_panel": this, "params_panel_hidden": true, "tools": [ Lino.show_in_own_window_button(Lino.cal.TasksByUser.grid) ], "preview_limit": 15, "master_panel": this });
    var cal_1_panel689 = new Ext.Panel({ "autoScroll": false, "listeners": { "activate": Lino.on_tab_activate }, "border": false, "layout": "hbox", "title": "Kalender", "hideCheckBoxLabels": true, "items": [ cal_left_panel618, cal_TasksByUser_grid688 ], "frame": false, "layoutConfig": { "align": "stretch" }, "labelAlign": "top" });
    var newcomer_quota690 = new Ext.form.NumberField({ "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Quote NZ</span>", "name": "newcomer_quota", "value": 0, "listeners": { "render": Lino.quicktip_renderer("Quote NZ","Wieviel Arbeitszeit dieser Benutzer f\u00fcr Neuantr\u00e4ge zur Verf\u00fcgung steht\n(100 = ganztags, 50 = halbtags, 0 = gar nicht).\nWenn zwei Benutzer die gleiche Belastungspunktzahl haben, \naber einer davon sich nur zu 50% um Neuantr\u00e4ge k\u00fcmmert, \ngilt er als doppelt so belastet wie sein Kollege.\n") }, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var coaching_type691 = new Lino.RemoteComboFieldElement({ "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Dienst</span>", "name": "coaching_type", "pageSize": 20, "emptyText": "Dienst ausw\u00e4hlen...", "listeners": { "render": Lino.quicktip_renderer("Dienst","The default CoachingType used when creating Coachings.") }, "selectOnFocus": true, "hiddenName": "coaching_typeHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/users/Users/coaching_type", "method": "GET" }) }) });
    var coaching_supervisor692 = new Ext.form.Checkbox({ "autoHeight": true, "hideLabel": true, "checked": false, "name": "coaching_supervisor", "listeners": { "render": Lino.quicktip_renderer("Benachrichtigung wenn ein Begleiter zugewiesen wird","Wenn ein Neuantrag einem Begleiter zugewiesen         wurde, wird au\u00dfer dem Begleiter auch dieser Benutzer         benachrichtigt.") }, "boxLabel": "Benachrichtigung wenn ein Begleiter zugewiesen wird", "selectOnFocus": true, "anchor": "-20" });
    var newcomers_CompetencesByUser_grid698 = new Lino.newcomers.CompetencesByUser.GridPanel({ "flex": 62, "hide_top_toolbar": true, "containing_panel": this, "tools": [ Lino.show_in_own_window_button(Lino.newcomers.CompetencesByUser.grid) ], "preview_limit": 15, "master_panel": this });
    var coaching_a_panel699 = new Ext.Panel({ "flex": 33, "layout": "vbox", "items": [ { "items": newcomer_quota690, "autoHeight": true, "layout": "form", "xtype": "panel", "labelAlign": "top" }, { "items": coaching_type691, "autoHeight": true, "layout": "form", "xtype": "panel", "labelAlign": "top" }, { "items": coaching_supervisor692, "autoHeight": true, "layout": "form", "xtype": "panel", "labelAlign": "top" }, newcomers_CompetencesByUser_grid698 ], "frame": true, "layoutConfig": { "align": "stretch" }, "autoScroll": false, "hideCheckBoxLabels": true, "labelWidth": 468, "border": false, "bodyBorder": false, "labelAlign": "top" });
    var pcsw_CoachingsByUser_grid729 = new Lino.pcsw.CoachingsByUser.GridPanel({ "flex": 66, "hide_top_toolbar": true, "containing_panel": this, "params_panel_hidden": true, "tools": [ Lino.show_in_own_window_button(Lino.pcsw.CoachingsByUser.grid) ], "preview_limit": 15, "master_panel": this });
    var coaching_1_panel730 = new Ext.Panel({ "autoScroll": false, "listeners": { "activate": Lino.on_tab_activate }, "border": false, "layout": "hbox", "title": "Begleitung", "hideCheckBoxLabels": true, "items": [ coaching_a_panel699, pcsw_CoachingsByUser_grid729 ], "frame": false, "layoutConfig": { "align": "stretch" }, "labelAlign": "top" });
    var main_panel731 = new Ext.TabPanel({ "hideCheckBoxLabels": true, "border": false, "split": true, "autoScroll": false, "items": [ general_panel606, cal_1_panel689, coaching_1_panel730 ], "activeTab": 0, "bodyBorder": false, "frame": true, "labelAlign": "top" });
    this.items = main_panel731;
    this.before_row_edit = function(record) {
      AuthoritiesGiven_grid603.on_master_changed();
      cal_SubscriptionsByUser_grid617.on_master_changed();
      cal_TasksByUser_grid688.on_master_changed();
      newcomers_CompetencesByUser_grid698.on_master_changed();
      pcsw_CoachingsByUser_grid729.on_master_changed();
    }
    Lino.users.MySettings.DetailFormPanel.superclass.initComponent.call(this);
    // active_fields:
    partner575.on("change", function(){ this.save() }, this);
  }
});

Lino.users.Users.change_password = new Lino.WindowAction({ "draggable": true, "width": Lino.chars2width(50), "autoHeight": true, "maximizable": true, "modal": true, "maximized": false }, function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.users.MySettings.change_password_ActionFormPanel({});
});
Lino.cal.GuestStates.wf1 = new Lino.WindowAction({ "draggable": true, "width": Lino.chars2width(50), "maximizable": true, "modal": true, "maximized": false, "height": Lino.rows2height(15) }, function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.cal.MyPresences.wf1_ActionFormPanel({});
});
Lino.cal.GuestStates.wf2 = new Lino.WindowAction({ "draggable": true, "width": Lino.chars2width(50), "maximizable": true, "modal": true, "maximized": false, "height": Lino.rows2height(15) }, function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.cal.MyPresences.wf2_ActionFormPanel({});
});
Lino.cal.Guests.checkin = new Lino.WindowAction({ "draggable": true, "width": Lino.chars2width(50), "maximizable": true, "modal": true, "maximized": false, "height": Lino.rows2height(15) }, function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.cal.MyPresences.checkin_ActionFormPanel({});
});
Lino.contacts.Persons.create_household = new Lino.WindowAction({ "draggable": true, "width": Lino.chars2width(50), "autoHeight": true, "maximizable": true, "modal": true, "maximized": false }, function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.contacts.Persons.create_household_ActionFormPanel({});
});
Lino.contacts.Companies.merge_row = new Lino.WindowAction({ "draggable": true, "width": Lino.chars2width(50), "autoHeight": true, "maximizable": true, "modal": true, "maximized": false }, function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.contacts.Companies.merge_row_ActionFormPanel({});
});
Lino.pcsw.ClientStates.wf1 = new Lino.WindowAction({ "draggable": true, "width": Lino.chars2width(50), "maximizable": true, "modal": true, "maximized": false, "height": Lino.rows2height(15) }, function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.pcsw.Clients.wf1_ActionFormPanel({});
});
Lino.pcsw.Clients.merge_row = new Lino.WindowAction({ "draggable": true, "width": Lino.chars2width(70), "autoHeight": true, "maximizable": true, "modal": true, "maximized": false }, function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.pcsw.Clients.merge_row_ActionFormPanel({});
});
Lino.reception.Clients.create_visit = new Lino.WindowAction({ "draggable": true, "width": Lino.chars2width(50), "autoHeight": true, "maximizable": true, "modal": true, "maximized": false }, function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.reception.Clients.create_visit_ActionFormPanel({});
});
Lino.pcsw.Coachings.create_visit = new Lino.WindowAction({ "draggable": true, "width": Lino.chars2width(50), "autoHeight": true, "maximizable": true, "modal": true, "maximized": false }, function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.pcsw.CoachingsByClient.create_visit_ActionFormPanel({});
});

// js_render_GridPanel_class users.MySettings
Lino.users.MySettings.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "Keine Daten anzuzeigen." },
  ls_url : "/users/MySettings",
  ls_bbar_actions : [ { "itemId": "submit_detail", "menu_item_text": "Speichern", "tooltip": "\u00c4nderungen in diesem Formular speichern", "panel_btn_handler": function(panel){panel.save()}, "iconCls": "x-tbar-disk", "overflowText": "Speichern", "auto_save": false }, { "itemId": "update_reminders", "menu_item_text": "Termine aktualisieren", "tooltip": "Termine aktualisieren", "panel_btn_handler": Lino.row_action_handler('update_reminders','GET',null), "iconCls": "x-tbar-lightning", "overflowText": "Termine aktualisieren", "auto_save": true }, { "itemId": "change_password", "menu_item_text": "Passwort \u00e4ndern", "panel_btn_handler": Lino.param_action_handler(Lino.users.Users.change_password), "text": "Passwort \u00e4ndern", "overflowText": "Passwort \u00e4ndern", "auto_save": true } ],
  cell_edit : true,
  title : "Benutzer",
  page_length : 20,
  stripeRows : true,
  disabled_actions_index : 27,
  ls_store_fields : [ { "name": "username" }, { "name": "profile" }, 'profileHidden', { "name": "first_name" }, { "name": "last_name" }, { "type": "int", "name": "id" }, { "name": "modified" }, { "name": "created" }, { "name": "password" }, { "name": "initials" }, { "name": "email" }, { "name": "remarks" }, { "name": "language" }, 'languageHidden', { "name": "partner" }, 'partnerHidden', { "name": "access_class" }, 'access_classHidden', { "name": "event_type" }, 'event_typeHidden', { "name": "calendar" }, 'calendarHidden', { "name": "coaching_type" }, 'coaching_typeHidden', { "type": "boolean", "name": "coaching_supervisor" }, { "type": "int", "name": "newcomer_quota" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 5,
  ls_grid_configs : [  ],
  content_type : 6,
  ls_id_property : "id",
  gc_name : 0,
  initComponent : function() {
    this.ls_detail_handler = Lino.users.MySettings.detail;
    this.ls_insert_handler = Lino.users.Users.insert;
    var ww = this.containing_window;
    var username2737 = new Ext.form.TextField({ "selectOnFocus": true, "allowBlank": false, "maxLength": 30 });
    var profile2738 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "forceSelection": true, "store": [['','<br>']].concat(Lino.users.UserProfiles) });
    var first_name2739 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 30 });
    var last_name2740 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 30 });
    var id2741 = new Ext.form.NumberField({ "selectOnFocus": true });
    var modified2742 = new Ext.form.DisplayField({ "disabled": true, "value": "<br>" });
    var created2743 = new Ext.form.DisplayField({ "disabled": true, "value": "<br>" });
    var password2744 = new Ext.form.TextField({ "selectOnFocus": true, "allowBlank": false, "maxLength": 128 });
    var initials2745 = new Ext.form.TextField({ "selectOnFocus": true, "boxMinWidth": Lino.chars2width(10), "maxLength": 10 });
    var email2746 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 75 });
    var remarks2747 = new Ext.form.TextArea({ "selectOnFocus": true, "growMax": 2000 });
    var language2748 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "store": [ [ "de", "Deutsch" ], [ "fr", "Franz\u00f6sisch" ], [ "nl", "Niederl\u00e4ndisch" ] ] });
    var partner2749 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "preferred_width": 20, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/users/MySettings/partner", "method": "GET" }) }), "pageSize": 20, "emptyText": "Partner ausw\u00e4hlen..." });
    var access_class2750 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "forceSelection": true, "allowBlank": false, "store": Lino.cal.AccessClasses });
    var event_type2751 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/users/MySettings/event_type", "method": "GET" }) }), "pageSize": 20, "emptyText": "Ereignisart ausw\u00e4hlen..." });
    var calendar2752 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/users/MySettings/calendar", "method": "GET" }) }), "pageSize": 20, "emptyText": "Kalender ausw\u00e4hlen..." });
    var coaching_type2753 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/users/MySettings/coaching_type", "method": "GET" }) }), "pageSize": 20, "emptyText": "Dienst ausw\u00e4hlen..." });
    var coaching_supervisor2754 = new Ext.form.Checkbox({ "selectOnFocus": true, "checked": false });
    var newcomer_quota2755 = new Ext.form.NumberField({ "selectOnFocus": true, "allowBlank": false, "value": 0 });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ { "colIndex": 0, "sortable": true, "header": "Benutzername", "editable": true, "tooltip": "Required. Must be unique.", "filter": { "type": "string" }, "width": Lino.chars2width(22), "editor": username2737, "dataIndex": "username" }, { "colIndex": 1, "sortable": true, "header": "Benutzerprofil", "editable": true, "tooltip": "Users with an empty `profile` field are considered inactive and cannot log in.", "filter": { "type": "string" }, "width": Lino.chars2width(42), "editor": profile2738, "dataIndex": "profile" }, { "colIndex": 2, "sortable": true, "width": Lino.chars2width(22), "editable": true, "filter": { "type": "string" }, "header": "Vorname", "editor": first_name2739, "dataIndex": "first_name" }, { "colIndex": 3, "sortable": true, "width": Lino.chars2width(22), "editable": true, "filter": { "type": "string" }, "header": "Familienname", "editor": last_name2740, "dataIndex": "last_name" }, new Lino.NullNumberColumn({ "colIndex": 4, "sortable": true, "format": "0", "editable": true, "filter": { "type": "numeric" }, "header": "ID", "editor": id2741, "hidden": true, "width": Lino.chars2width(6), "dataIndex": "id" }), { "header": "Bearbeitet", "colIndex": 5, "sortable": true, "dataIndex": "modified", "width": Lino.chars2width(17), "hidden": true, "editable": false }, { "header": "Erstellt", "colIndex": 6, "sortable": true, "dataIndex": "created", "width": Lino.chars2width(17), "hidden": true, "editable": false }, { "colIndex": 7, "sortable": true, "header": "Passwort", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "editor": password2744, "hidden": true, "dataIndex": "password" }, { "colIndex": 8, "sortable": true, "header": "Initialien", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(12), "editor": initials2745, "hidden": true, "dataIndex": "initials" }, { "colIndex": 9, "sortable": true, "header": "e-mail address", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "editor": email2746, "hidden": true, "dataIndex": "email" }, { "colIndex": 10, "sortable": false, "header": "Bemerkungen", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(61), "editor": remarks2747, "hidden": true, "dataIndex": "remarks" }, { "colIndex": 11, "sortable": true, "header": "Sprache", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "editor": language2748, "hidden": true, "dataIndex": "language" }, { "colIndex": 12, "sortable": true, "header": "Partner", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('partnerHidden','Lino.contacts.Partners.detail'), "dataIndex": "partner", "hidden": true, "editor": partner2749 }, { "colIndex": 13, "sortable": true, "header": "Standardm\u00e4\u00dfige Zugriffsklasse", "editable": true, "tooltip": "Die standardm\u00e4\u00dfige Zugriffsklasse f\u00fcr Ihre Termine und Aufgaben", "filter": { "type": "string" }, "width": Lino.chars2width(35), "editor": access_class2750, "hidden": true, "dataIndex": "access_class" }, { "colIndex": 14, "sortable": true, "header": "Default Event Type", "editable": true, "tooltip": "The default event type for your calendar events.", "filter": { "type": "string" }, "width": Lino.chars2width(21), "editor": event_type2751, "hidden": true, "dataIndex": "event_type" }, { "colIndex": 15, "sortable": true, "header": "Calendar where your events are published.", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "editor": calendar2752, "hidden": true, "dataIndex": "calendar" }, { "colIndex": 16, "sortable": true, "header": "Dienst", "editable": true, "tooltip": "The default CoachingType used when creating Coachings.", "filter": { "type": "string" }, "width": Lino.chars2width(21), "editor": coaching_type2753, "hidden": true, "dataIndex": "coaching_type" }, { "colIndex": 17, "sortable": false, "xtype": "checkcolumn", "width": Lino.chars2width(11), "editable": true, "tooltip": "Wenn ein Neuantrag einem Begleiter zugewiesen         wurde, wird au\u00dfer dem Begleiter auch dieser Benutzer         benachrichtigt.", "filter": { "type": "boolean" }, "header": "Benachrichtigung wenn ein Begleiter zugewiesen wird", "dataIndex": "coaching_supervisor", "hidden": true }, new Lino.NullNumberColumn({ "colIndex": 18, "sortable": true, "format": "0", "editable": true, "tooltip": "Wieviel Arbeitszeit dieser Benutzer f\u00fcr Neuantr\u00e4ge zur Verf\u00fcgung steht\n(100 = ganztags, 50 = halbtags, 0 = gar nicht).\nWenn zwei Benutzer die gleiche Belastungspunktzahl haben, \naber einer davon sich nur zu 50% um Neuantr\u00e4ge k\u00fcmmert, \ngilt er als doppelt so belastet wie sein Kollege.\n", "filter": { "type": "numeric" }, "header": "Quote NZ", "editor": newcomer_quota2755, "hidden": true, "width": Lino.chars2width(6), "dataIndex": "newcomer_quota" }) ];
    Lino.users.MySettings.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.users.MySettings.show_as_html = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/users/MySettings", "GET", pk, "show_as_html", params, Lino.get_current_grid_config);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.users.MySettings.as_pdf = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/users/MySettings", "GET", pk, "as_pdf", params, Lino.get_current_grid_config);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.users.MySettings.as_pdf_p = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/users/MySettings", "GET", pk, "as_pdf_p", params, Lino.get_current_grid_config);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.users.MySettings.export_excel = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/users/MySettings", "GET", pk, "export_excel", params, Lino.get_current_grid_config);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.users.MySettings.submit_detail = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/users/MySettings", "GET", pk, "submit_detail", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.users.MySettings.grid_put = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/users/MySettings", "GET", pk, "grid_put", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.users.MySettings.grid_post = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/users/MySettings", "GET", pk, "grid_post", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.users.MySettings.submit_insert = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/users/MySettings", "GET", pk, "submit_insert", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};

Lino.users.MySettings.detailPanel = Ext.extend(Lino.users.MySettings.DetailFormPanel,{
  empty_title: "Benutzer",
  save_action_name: "submit_detail",
  ls_bbar_actions: [ { "itemId": "submit_detail", "menu_item_text": "Speichern", "tooltip": "\u00c4nderungen in diesem Formular speichern", "panel_btn_handler": function(panel){panel.save()}, "iconCls": "x-tbar-disk", "overflowText": "Speichern", "auto_save": false }, { "itemId": "update_reminders", "menu_item_text": "Termine aktualisieren", "tooltip": "Termine aktualisieren", "panel_btn_handler": Lino.row_action_handler('update_reminders','GET',null), "iconCls": "x-tbar-lightning", "overflowText": "Termine aktualisieren", "auto_save": true }, { "itemId": "change_password", "menu_item_text": "Passwort \u00e4ndern", "panel_btn_handler": Lino.param_action_handler(Lino.users.Users.change_password), "text": "Passwort \u00e4ndern", "overflowText": "Passwort \u00e4ndern", "auto_save": true } ],
  ls_url: "/users/MySettings",
  initComponent : function() {
    this.ls_detail_handler = Lino.users.MySettings.detail;
    this.ls_insert_handler = Lino.users.Users.insert;
    Lino.users.MySettings.detailPanel.superclass.initComponent.call(this);
  }
});

Lino.users.MySettings.detail = new Lino.WindowAction({  }, function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.users.MySettings.detailPanel(p);
});

Lino.users.MySettings.detailPanel = Ext.extend(Lino.users.MySettings.DetailFormPanel,{
  empty_title: "Benutzer",
  save_action_name: "submit_detail",
  ls_bbar_actions: [ { "itemId": "submit_detail", "menu_item_text": "Speichern", "tooltip": "\u00c4nderungen in diesem Formular speichern", "panel_btn_handler": function(panel){panel.save()}, "iconCls": "x-tbar-disk", "overflowText": "Speichern", "auto_save": false }, { "itemId": "update_reminders", "menu_item_text": "Termine aktualisieren", "tooltip": "Termine aktualisieren", "panel_btn_handler": Lino.row_action_handler('update_reminders','GET',null), "iconCls": "x-tbar-lightning", "overflowText": "Termine aktualisieren", "auto_save": true }, { "itemId": "change_password", "menu_item_text": "Passwort \u00e4ndern", "panel_btn_handler": Lino.param_action_handler(Lino.users.Users.change_password), "text": "Passwort \u00e4ndern", "overflowText": "Passwort \u00e4ndern", "auto_save": true } ],
  ls_url: "/users/MySettings",
  initComponent : function() {
    this.ls_detail_handler = Lino.users.MySettings.detail;
    this.ls_insert_handler = Lino.users.Users.insert;
    Lino.users.MySettings.detailPanel.superclass.initComponent.call(this);
  }
});

Lino.users.MySettings.detail = new Lino.WindowAction({  }, function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.users.MySettings.detailPanel(p);
});
Lino.users.MySettings.validate = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/users/MySettings", "GET", pk, "validate", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.users.MySettings.update_reminders = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/users/MySettings", "GET", pk, "update_reminders", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};

// js_render_GridPanel_class cal.MyTasks
Lino.cal.MyTasks.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "Keine Daten anzuzeigen." },
  ls_url : "/cal/MyTasks",
  ls_bbar_actions : [ { "itemId": "show_as_html", "menu_item_text": "HTML", "tooltip": "Show this table in Bootstrap3 interface", "panel_btn_handler": Lino.list_action_handler('/cal/MyTasks','show_as_html','GET',Lino.get_current_grid_config), "iconCls": "x-tbar-html", "overflowText": "HTML", "auto_save": true }, { "panel_btn_handler": Lino.list_action_handler('/cal/MyTasks','as_pdf','GET',Lino.get_current_grid_config), "xtype": "splitbutton", "text": null, "menu": [ { "itemId": "as_pdf", "menu_item_text": "Tabelle (Querformat)", "tooltip": "Diese Tabelle in eine .pdf-Datei exportieren", "panel_btn_handler": Lino.list_action_handler('/cal/MyTasks','as_pdf','GET',Lino.get_current_grid_config), "text": "Tabelle (Querformat)", "overflowText": "Tabelle (Querformat)", "auto_save": true }, { "itemId": "as_pdf_p", "menu_item_text": "Tabelle (Hochformat)", "tooltip": "Diese Tabelle in eine .pdf-Datei exportieren", "panel_btn_handler": Lino.list_action_handler('/cal/MyTasks','as_pdf_p','GET',Lino.get_current_grid_config), "text": "Tabelle (Hochformat)", "overflowText": "Tabelle (Hochformat)", "auto_save": true } ], "iconCls": "x-tbar-pdf", "menu_item_text": "Tabelle (Querformat)" }, { "itemId": "export_excel", "menu_item_text": "Export to .xls", "tooltip": "Export this table as an .xls document", "panel_btn_handler": Lino.list_action_handler('/cal/MyTasks','export_excel','GET',Lino.get_current_grid_config), "iconCls": "x-tbar-csv", "overflowText": "Export to .xls", "auto_save": true }, { "itemId": "insert", "menu_item_text": "Neu", "tooltip": "Neuen Datensatz erstellen", "panel_btn_handler": Lino.show_insert, "iconCls": "x-tbar-add", "overflowText": "Neu", "keycode": 44, "auto_save": true }, { "itemId": "detail", "menu_item_text": "Detail", "tooltip": "Detail-Fenster auf diesem Datensatz \u00f6ffnen", "panel_btn_handler": Lino.show_detail, "iconCls": "x-tbar-application_form", "overflowText": "Detail", "auto_save": true }, { "itemId": "delete_selected", "menu_item_text": "L\u00f6schen", "tooltip": "Diesen Datensatz l\u00f6schen", "panel_btn_handler": Lino.row_action_handler('delete_selected','GET',null), "iconCls": "x-tbar-delete", "overflowText": "L\u00f6schen", "keycode": 46, "auto_save": false } ],
  cell_edit : true,
  title : "Meine Aufgaben",
  page_length : 20,
  params_panel_hidden : true,
  stripeRows : true,
  disabled_actions_index : 7,
  ls_store_fields : [ { "type": "date", "name": "start_date", "dateFormat": "d.m.Y" }, { "name": "summary" }, { "name": "workflow_buttons" }, { "name": "project" }, 'projectHidden', { "type": "int", "name": "id" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 5,
  ls_grid_configs : [  ],
  content_type : 28,
  ls_id_property : "id",
  gc_name : 0,
  initComponent : function() {
    this.ls_detail_handler = Lino.cal.MyTasks.detail;
    this.ls_insert_handler = Lino.cal.MyTasks.insert;
    var ww = this.containing_window;
    var start_date2757 = new Lino.DateField({ "selectOnFocus": true });
    var summary2758 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var workflow_buttons_disp2759 = new Ext.form.DisplayField({ "disabled": true, "value": "<br/>", "always_enabled": true });
    var project2760 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "preferred_width": 20, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/MyTasks/project", "method": "GET" }) }), "pageSize": 20, "emptyText": "Klient ausw\u00e4hlen..." });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ { "colIndex": 0, "sortable": true, "xtype": "datecolumn", "format": "d.m.Y", "editable": true, "filter": { "type": "date", "dateFormat": "d.m.Y" }, "header": "Beginnt am", "editor": start_date2757, "width": Lino.chars2width(14), "dataIndex": "start_date" }, { "colIndex": 1, "sortable": true, "width": Lino.chars2width(22), "editable": true, "filter": { "type": "string" }, "header": "Kurzbeschreibung", "editor": summary2758, "dataIndex": "summary" }, { "header": "Arbeitsablauf", "colIndex": 2, "sortable": false, "dataIndex": "workflow_buttons", "width": Lino.chars2width(31), "editable": false }, { "colIndex": 3, "sortable": true, "header": "Klient", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('projectHidden','Lino.pcsw.Clients.detail'), "dataIndex": "project", "editor": project2760 } ];
    Lino.cal.MyTasks.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.cal.MyTasks.show_as_html = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/cal/MyTasks", "GET", pk, "show_as_html", params, Lino.get_current_grid_config);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.cal.MyTasks.as_pdf = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/cal/MyTasks", "GET", pk, "as_pdf", params, Lino.get_current_grid_config);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.cal.MyTasks.as_pdf_p = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/cal/MyTasks", "GET", pk, "as_pdf_p", params, Lino.get_current_grid_config);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.cal.MyTasks.export_excel = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/cal/MyTasks", "GET", pk, "export_excel", params, Lino.get_current_grid_config);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.cal.MyTasks.submit_detail = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/cal/MyTasks", "GET", pk, "submit_detail", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};

Lino.cal.MyTasks.insertPanel = Ext.extend(Lino.cal.MyTasks.InsertFormPanel,{
  empty_title: "Neu",
  hide_navigator: true,
  params_panel_hidden: true,
  save_action_name: "submit_insert",
  ls_bbar_actions: [ { "itemId": "submit_insert", "menu_item_text": "Erstellen", "tooltip": "Datensatz erstellen und dann im Detail-Fenster \u00f6ffnen", "panel_btn_handler": function(panel){panel.save()}, "text": "Erstellen", "overflowText": "Erstellen", "auto_save": false } ],
  ls_url: "/cal/MyTasks",
  action_name: "insert",
  initComponent : function() {
    this.ls_detail_handler = Lino.cal.MyTasks.detail;
    this.ls_insert_handler = Lino.cal.MyTasks.insert;
    Lino.cal.MyTasks.insertPanel.superclass.initComponent.call(this);
  }
});

Lino.cal.MyTasks.insert = new Lino.WindowAction({ "draggable": true, "width": Lino.chars2width(50), "autoHeight": true, "maximizable": true, "modal": true, "maximized": false }, function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.cal.MyTasks.insertPanel(p);
});
Lino.cal.MyTasks.grid_put = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/cal/MyTasks", "GET", pk, "grid_put", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.cal.MyTasks.grid_post = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/cal/MyTasks", "GET", pk, "grid_post", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.cal.MyTasks.submit_insert = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/cal/MyTasks", "GET", pk, "submit_insert", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.cal.MyTasks.wf1 = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/cal/MyTasks", "GET", pk, "wf1", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.cal.MyTasks.wf2 = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/cal/MyTasks", "GET", pk, "wf2", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.cal.MyTasks.wf3 = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/cal/MyTasks", "GET", pk, "wf3", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};

Lino.cal.MyTasks.detailPanel = Ext.extend(Lino.cal.MyTasks.DetailFormPanel,{
  empty_title: "Detail",
  params_panel_hidden: true,
  save_action_name: "submit_detail",
  ls_bbar_actions: [ { "itemId": "submit_detail", "menu_item_text": "Speichern", "tooltip": "\u00c4nderungen in diesem Formular speichern", "panel_btn_handler": function(panel){panel.save()}, "iconCls": "x-tbar-disk", "overflowText": "Speichern", "auto_save": false }, { "itemId": "insert", "menu_item_text": "Neu", "tooltip": "Neuen Datensatz erstellen", "panel_btn_handler": Lino.show_insert, "iconCls": "x-tbar-add", "overflowText": "Neu", "keycode": 44, "auto_save": true }, { "itemId": "delete_selected", "menu_item_text": "L\u00f6schen", "tooltip": "Diesen Datensatz l\u00f6schen", "panel_btn_handler": Lino.row_action_handler('delete_selected','GET',null), "iconCls": "x-tbar-delete", "overflowText": "L\u00f6schen", "keycode": 46, "auto_save": false } ],
  ls_url: "/cal/MyTasks",
  action_name: "detail",
  initComponent : function() {
    this.ls_detail_handler = Lino.cal.MyTasks.detail;
    this.ls_insert_handler = Lino.cal.MyTasks.insert;
    Lino.cal.MyTasks.detailPanel.superclass.initComponent.call(this);
  }
});

Lino.cal.MyTasks.detail = new Lino.WindowAction({  }, function(){
  var p = { "is_main_window": true };
  return new Lino.cal.MyTasks.detailPanel(p);
});
Lino.cal.MyTasks.delete_selected = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/cal/MyTasks", "GET", pk, "delete_selected", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.cal.MyTasks.grid = new Lino.WindowAction({  }, function(){
  var p = { "is_main_window": true };
  p.params_panel = new Lino.cal.MyTasks.ParamsPanel({});
  return new Lino.cal.MyTasks.GridPanel(p);
});
Lino.cal.MyTasks.validate = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/cal/MyTasks", "GET", pk, "validate", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};

// js_render_GridPanel_class cal.MyPresences
Lino.cal.MyPresences.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "Keine Daten anzuzeigen." },
  ls_url : "/cal/MyPresences",
  ls_bbar_actions : [ { "itemId": "show_as_html", "menu_item_text": "HTML", "tooltip": "Show this table in Bootstrap3 interface", "panel_btn_handler": Lino.list_action_handler('/cal/MyPresences','show_as_html','GET',Lino.get_current_grid_config), "iconCls": "x-tbar-html", "overflowText": "HTML", "auto_save": true }, { "panel_btn_handler": Lino.list_action_handler('/cal/MyPresences','as_pdf','GET',Lino.get_current_grid_config), "xtype": "splitbutton", "text": null, "menu": [ { "itemId": "as_pdf", "menu_item_text": "Tabelle (Querformat)", "tooltip": "Diese Tabelle in eine .pdf-Datei exportieren", "panel_btn_handler": Lino.list_action_handler('/cal/MyPresences','as_pdf','GET',Lino.get_current_grid_config), "text": "Tabelle (Querformat)", "overflowText": "Tabelle (Querformat)", "auto_save": true }, { "itemId": "as_pdf_p", "menu_item_text": "Tabelle (Hochformat)", "tooltip": "Diese Tabelle in eine .pdf-Datei exportieren", "panel_btn_handler": Lino.list_action_handler('/cal/MyPresences','as_pdf_p','GET',Lino.get_current_grid_config), "text": "Tabelle (Hochformat)", "overflowText": "Tabelle (Hochformat)", "auto_save": true } ], "iconCls": "x-tbar-pdf", "menu_item_text": "Tabelle (Querformat)" }, { "itemId": "export_excel", "menu_item_text": "Export to .xls", "tooltip": "Export this table as an .xls document", "panel_btn_handler": Lino.list_action_handler('/cal/MyPresences','export_excel','GET',Lino.get_current_grid_config), "iconCls": "x-tbar-csv", "overflowText": "Export to .xls", "auto_save": true }, { "itemId": "insert", "menu_item_text": "Neu", "tooltip": "Neuen Datensatz erstellen", "panel_btn_handler": Lino.show_insert, "iconCls": "x-tbar-add", "overflowText": "Neu", "keycode": 44, "auto_save": true }, { "itemId": "detail", "menu_item_text": "Detail", "tooltip": "Detail-Fenster auf diesem Datensatz \u00f6ffnen", "panel_btn_handler": Lino.show_detail, "iconCls": "x-tbar-application_form", "overflowText": "Detail", "auto_save": true }, { "itemId": "delete_selected", "menu_item_text": "L\u00f6schen", "tooltip": "Diesen Datensatz l\u00f6schen", "panel_btn_handler": Lino.row_action_handler('delete_selected','GET',null), "iconCls": "x-tbar-delete", "overflowText": "L\u00f6schen", "keycode": 46, "auto_save": false }, { "itemId": "do_print", "menu_item_text": "Anwesenheitsbescheinigung", "tooltip": "Auszug von diesem Datensatz erstellen zwecks Ausdruck.", "panel_btn_handler": Lino.row_action_handler('do_print','GET',null), "iconCls": "x-tbar-printer", "overflowText": "Anwesenheitsbescheinigung", "auto_save": true }, { "itemId": "checkin", "menu_item_text": "Einchecken", "tooltip": "Mark this visitor as arrived", "panel_btn_handler": Lino.param_action_handler(Lino.cal.Guests.checkin), "text": "Einchecken", "overflowText": "Einchecken", "auto_save": true }, { "itemId": "receive", "menu_item_text": "Empfangen", "tooltip": "Visitor was received by agent", "panel_btn_handler": Lino.row_action_handler('receive','GET',null), "text": "Empfangen", "overflowText": "Empfangen", "auto_save": true }, { "itemId": "checkout", "menu_item_text": "Auschecken", "tooltip": "Visitor left the centre", "panel_btn_handler": Lino.row_action_handler('checkout','GET',null), "text": "Auschecken", "overflowText": "Auschecken", "auto_save": true } ],
  cell_edit : true,
  title : "Meine Anwesenheiten",
  page_length : 20,
  params_panel_hidden : true,
  stripeRows : true,
  disabled_actions_index : 18,
  ls_store_fields : [ { "type": "date", "name": "event__start_date", "dateFormat": "d.m.Y" }, { "name": "event__start_time" }, { "name": "event_summary" }, { "name": "role" }, 'roleHidden', { "name": "workflow_buttons" }, { "name": "remark" }, { "type": "int", "name": "id" }, { "name": "event" }, 'eventHidden', { "name": "partner" }, 'partnerHidden', { "name": "state" }, 'stateHidden', { "name": "waiting_since" }, { "name": "busy_since" }, { "name": "gone_since" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 7,
  ls_grid_configs : [  ],
  content_type : 33,
  ls_id_property : "id",
  gc_name : 0,
  initComponent : function() {
    this.ls_detail_handler = Lino.cal.MyPresences.detail;
    this.ls_insert_handler = Lino.cal.MyPresences.insert;
    var ww = this.containing_window;
    var event__start_date2762 = new Lino.DateField({ "disabled": true });
    var event__start_time2763 = new Lino.TimeField({ "disabled": true });
    var event_summary_disp2764 = new Ext.form.DisplayField({ "disabled": true, "value": "<br/>", "always_enabled": true });
    var role2765 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/MyPresences/role", "method": "GET" }) }), "pageSize": 20, "emptyText": "Gastrolle ausw\u00e4hlen..." });
    var workflow_buttons_disp2766 = new Ext.form.DisplayField({ "disabled": true, "value": "<br/>", "always_enabled": true });
    var remark2767 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var id2768 = new Ext.form.NumberField({ "selectOnFocus": true });
    var event2769 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/MyPresences/event", "method": "GET" }) }), "allowBlank": false, "pageSize": 20, "emptyText": "Termin ausw\u00e4hlen..." });
    var partner2770 = new Lino.RemoteComboFieldElement({ "preferred_width": 20, "allowBlank": false, "pageSize": 20, "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/MyPresences/partner", "method": "GET" }) }), "emptyText": "Partner ausw\u00e4hlen..." });
    var state2771 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "forceSelection": true, "allowBlank": false, "store": Lino.cal.GuestStates });
    var waiting_since2772 = new Ext.form.DisplayField({ "disabled": true, "value": "<br>" });
    var busy_since2773 = new Ext.form.DisplayField({ "disabled": true, "value": "<br>" });
    var gone_since2774 = new Ext.form.DisplayField({ "disabled": true, "value": "<br>" });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ { "colIndex": 0, "sortable": true, "xtype": "datecolumn", "format": "d.m.Y", "editable": false, "filter": { "type": "date", "dateFormat": "d.m.Y" }, "header": "Beginnt am", "dataIndex": "event__start_date", "width": Lino.chars2width(14) }, { "width": Lino.chars2width(9), "colIndex": 1, "sortable": true, "dataIndex": "event__start_time", "header": "Beginnt um", "editable": false }, { "header": "Termin", "colIndex": 2, "sortable": false, "dataIndex": "event_summary", "width": Lino.chars2width(31), "editable": false }, { "colIndex": 3, "sortable": true, "width": Lino.chars2width(21), "editable": true, "filter": { "type": "string" }, "header": "Rolle", "editor": role2765, "dataIndex": "role" }, { "header": "Arbeitsablauf", "colIndex": 4, "sortable": false, "dataIndex": "workflow_buttons", "width": Lino.chars2width(31), "editable": false }, { "colIndex": 5, "sortable": true, "width": Lino.chars2width(22), "editable": true, "filter": { "type": "string" }, "header": "Bemerkung", "editor": remark2767, "dataIndex": "remark" }, new Lino.NullNumberColumn({ "colIndex": 6, "sortable": true, "format": "0", "editable": true, "filter": { "type": "numeric" }, "header": "ID", "editor": id2768, "hidden": true, "width": Lino.chars2width(6), "dataIndex": "id" }), { "colIndex": 7, "sortable": true, "header": "Termin", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('eventHidden','Lino.cal.OneEvent.detail'), "dataIndex": "event", "hidden": true, "editor": event2769 }, { "colIndex": 8, "sortable": true, "header": "Partner", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('partnerHidden','Lino.contacts.Partners.detail'), "dataIndex": "partner", "hidden": true, "editor": partner2770 }, { "colIndex": 9, "sortable": true, "header": "Zustand", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(16), "editor": state2771, "hidden": true, "dataIndex": "state" }, { "colIndex": 10, "sortable": true, "width": Lino.chars2width(17), "editable": false, "tooltip": "Time when the visitor arrived (checked in).", "header": "Wartet seit", "dataIndex": "waiting_since", "hidden": true }, { "colIndex": 11, "sortable": true, "width": Lino.chars2width(17), "editable": false, "tooltip": "Time when the visitor was received by agent.", "header": "Hat gewartet bis", "dataIndex": "busy_since", "hidden": true }, { "colIndex": 12, "sortable": true, "width": Lino.chars2width(17), "editable": false, "tooltip": "Time when the visitor left (checked out).", "header": "Anwesend bis", "dataIndex": "gone_since", "hidden": true } ];
    Lino.cal.MyPresences.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.cal.MyPresences.show_as_html = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/cal/MyPresences", "GET", pk, "show_as_html", params, Lino.get_current_grid_config);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.cal.MyPresences.as_pdf = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/cal/MyPresences", "GET", pk, "as_pdf", params, Lino.get_current_grid_config);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.cal.MyPresences.as_pdf_p = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/cal/MyPresences", "GET", pk, "as_pdf_p", params, Lino.get_current_grid_config);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.cal.MyPresences.export_excel = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/cal/MyPresences", "GET", pk, "export_excel", params, Lino.get_current_grid_config);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.cal.MyPresences.submit_detail = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/cal/MyPresences", "GET", pk, "submit_detail", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};

Lino.cal.MyPresences.insertPanel = Ext.extend(Lino.cal.MyPresences.InsertFormPanel,{
  empty_title: "Neu",
  hide_navigator: true,
  params_panel_hidden: true,
  save_action_name: "submit_insert",
  ls_bbar_actions: [ { "itemId": "submit_insert", "menu_item_text": "Erstellen", "tooltip": "Datensatz erstellen und dann im Detail-Fenster \u00f6ffnen", "panel_btn_handler": function(panel){panel.save()}, "text": "Erstellen", "overflowText": "Erstellen", "auto_save": false } ],
  ls_url: "/cal/MyPresences",
  action_name: "insert",
  initComponent : function() {
    this.ls_detail_handler = Lino.cal.MyPresences.detail;
    this.ls_insert_handler = Lino.cal.MyPresences.insert;
    Lino.cal.MyPresences.insertPanel.superclass.initComponent.call(this);
  }
});

Lino.cal.MyPresences.insert = new Lino.WindowAction({ "draggable": true, "width": Lino.chars2width(60), "autoHeight": true, "maximizable": true, "modal": true, "maximized": false }, function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.cal.MyPresences.insertPanel(p);
});
Lino.cal.MyPresences.grid_put = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/cal/MyPresences", "GET", pk, "grid_put", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.cal.MyPresences.grid_post = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/cal/MyPresences", "GET", pk, "grid_post", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.cal.MyPresences.submit_insert = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/cal/MyPresences", "GET", pk, "submit_insert", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.cal.MyPresences.wf3 = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/cal/MyPresences", "GET", pk, "wf3", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.cal.MyPresences.wf4 = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/cal/MyPresences", "GET", pk, "wf4", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.cal.MyPresences.wf5 = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/cal/MyPresences", "GET", pk, "wf5", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.cal.MyPresences.wf6 = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/cal/MyPresences", "GET", pk, "wf6", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};

Lino.cal.MyPresences.detailPanel = Ext.extend(Lino.cal.MyPresences.DetailFormPanel,{
  empty_title: "Detail",
  params_panel_hidden: true,
  save_action_name: "submit_detail",
  ls_bbar_actions: [ { "itemId": "submit_detail", "menu_item_text": "Speichern", "tooltip": "\u00c4nderungen in diesem Formular speichern", "panel_btn_handler": function(panel){panel.save()}, "iconCls": "x-tbar-disk", "overflowText": "Speichern", "auto_save": false }, { "itemId": "insert", "menu_item_text": "Neu", "tooltip": "Neuen Datensatz erstellen", "panel_btn_handler": Lino.show_insert, "iconCls": "x-tbar-add", "overflowText": "Neu", "keycode": 44, "auto_save": true }, { "itemId": "delete_selected", "menu_item_text": "L\u00f6schen", "tooltip": "Diesen Datensatz l\u00f6schen", "panel_btn_handler": Lino.row_action_handler('delete_selected','GET',null), "iconCls": "x-tbar-delete", "overflowText": "L\u00f6schen", "keycode": 46, "auto_save": false }, { "itemId": "do_print", "menu_item_text": "Anwesenheitsbescheinigung", "tooltip": "Auszug von diesem Datensatz erstellen zwecks Ausdruck.", "panel_btn_handler": Lino.row_action_handler('do_print','GET',null), "iconCls": "x-tbar-printer", "overflowText": "Anwesenheitsbescheinigung", "auto_save": true }, { "itemId": "checkin", "menu_item_text": "Einchecken", "tooltip": "Mark this visitor as arrived", "panel_btn_handler": Lino.param_action_handler(Lino.cal.Guests.checkin), "text": "Einchecken", "overflowText": "Einchecken", "auto_save": true }, { "itemId": "receive", "menu_item_text": "Empfangen", "tooltip": "Visitor was received by agent", "panel_btn_handler": Lino.row_action_handler('receive','GET',null), "text": "Empfangen", "overflowText": "Empfangen", "auto_save": true }, { "itemId": "checkout", "menu_item_text": "Auschecken", "tooltip": "Visitor left the centre", "panel_btn_handler": Lino.row_action_handler('checkout','GET',null), "text": "Auschecken", "overflowText": "Auschecken", "auto_save": true } ],
  ls_url: "/cal/MyPresences",
  action_name: "detail",
  initComponent : function() {
    this.ls_detail_handler = Lino.cal.MyPresences.detail;
    this.ls_insert_handler = Lino.cal.MyPresences.insert;
    Lino.cal.MyPresences.detailPanel.superclass.initComponent.call(this);
  }
});

Lino.cal.MyPresences.detail = new Lino.WindowAction({  }, function(){
  var p = { "is_main_window": true };
  return new Lino.cal.MyPresences.detailPanel(p);
});
Lino.cal.MyPresences.delete_selected = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/cal/MyPresences", "GET", pk, "delete_selected", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.cal.MyPresences.do_print = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/cal/MyPresences", "GET", pk, "do_print", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.cal.MyPresences.grid = new Lino.WindowAction({  }, function(){
  var p = { "is_main_window": true };
  p.params_panel = new Lino.cal.MyPresences.ParamsPanel({});
  return new Lino.cal.MyPresences.GridPanel(p);
});
Lino.cal.MyPresences.validate = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/cal/MyPresences", "GET", pk, "validate", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.cal.MyPresences.receive = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/cal/MyPresences", "GET", pk, "receive", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.cal.MyPresences.checkout = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/cal/MyPresences", "GET", pk, "checkout", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};

// js_render_GridPanel_class cal.MyPendingPresences
Lino.cal.MyPendingPresences.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "Keine Daten anzuzeigen." },
  ls_url : "/cal/MyPendingPresences",
  ls_bbar_actions : [ { "itemId": "show_as_html", "menu_item_text": "HTML", "tooltip": "Show this table in Bootstrap3 interface", "panel_btn_handler": Lino.list_action_handler('/cal/MyPendingPresences','show_as_html','GET',Lino.get_current_grid_config), "iconCls": "x-tbar-html", "overflowText": "HTML", "auto_save": true }, { "panel_btn_handler": Lino.list_action_handler('/cal/MyPendingPresences','as_pdf','GET',Lino.get_current_grid_config), "xtype": "splitbutton", "text": null, "menu": [ { "itemId": "as_pdf", "menu_item_text": "Tabelle (Querformat)", "tooltip": "Diese Tabelle in eine .pdf-Datei exportieren", "panel_btn_handler": Lino.list_action_handler('/cal/MyPendingPresences','as_pdf','GET',Lino.get_current_grid_config), "text": "Tabelle (Querformat)", "overflowText": "Tabelle (Querformat)", "auto_save": true }, { "itemId": "as_pdf_p", "menu_item_text": "Tabelle (Hochformat)", "tooltip": "Diese Tabelle in eine .pdf-Datei exportieren", "panel_btn_handler": Lino.list_action_handler('/cal/MyPendingPresences','as_pdf_p','GET',Lino.get_current_grid_config), "text": "Tabelle (Hochformat)", "overflowText": "Tabelle (Hochformat)", "auto_save": true } ], "iconCls": "x-tbar-pdf", "menu_item_text": "Tabelle (Querformat)" }, { "itemId": "export_excel", "menu_item_text": "Export to .xls", "tooltip": "Export this table as an .xls document", "panel_btn_handler": Lino.list_action_handler('/cal/MyPendingPresences','export_excel','GET',Lino.get_current_grid_config), "iconCls": "x-tbar-csv", "overflowText": "Export to .xls", "auto_save": true }, { "itemId": "insert", "menu_item_text": "Neu", "tooltip": "Neuen Datensatz erstellen", "panel_btn_handler": Lino.show_insert, "iconCls": "x-tbar-add", "overflowText": "Neu", "keycode": 44, "auto_save": true }, { "itemId": "detail", "menu_item_text": "Detail", "tooltip": "Detail-Fenster auf diesem Datensatz \u00f6ffnen", "panel_btn_handler": Lino.show_detail, "iconCls": "x-tbar-application_form", "overflowText": "Detail", "auto_save": true }, { "itemId": "delete_selected", "menu_item_text": "L\u00f6schen", "tooltip": "Diesen Datensatz l\u00f6schen", "panel_btn_handler": Lino.row_action_handler('delete_selected','GET',null), "iconCls": "x-tbar-delete", "overflowText": "L\u00f6schen", "keycode": 46, "auto_save": false }, { "itemId": "do_print", "menu_item_text": "Anwesenheitsbescheinigung", "tooltip": "Auszug von diesem Datensatz erstellen zwecks Ausdruck.", "panel_btn_handler": Lino.row_action_handler('do_print','GET',null), "iconCls": "x-tbar-printer", "overflowText": "Anwesenheitsbescheinigung", "auto_save": true }, { "itemId": "checkin", "menu_item_text": "Einchecken", "tooltip": "Mark this visitor as arrived", "panel_btn_handler": Lino.param_action_handler(Lino.cal.Guests.checkin), "text": "Einchecken", "overflowText": "Einchecken", "auto_save": true }, { "itemId": "receive", "menu_item_text": "Empfangen", "tooltip": "Visitor was received by agent", "panel_btn_handler": Lino.row_action_handler('receive','GET',null), "text": "Empfangen", "overflowText": "Empfangen", "auto_save": true }, { "itemId": "checkout", "menu_item_text": "Auschecken", "tooltip": "Visitor left the centre", "panel_btn_handler": Lino.row_action_handler('checkout','GET',null), "text": "Auschecken", "overflowText": "Auschecken", "auto_save": true } ],
  cell_edit : true,
  title : "My pending invitations",
  page_length : 20,
  params_panel_hidden : true,
  stripeRows : true,
  disabled_actions_index : 7,
  ls_store_fields : [ { "name": "event__when_text" }, { "name": "role" }, 'roleHidden', { "name": "workflow_buttons" }, { "name": "remark" }, { "type": "int", "name": "id" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 5,
  ls_grid_configs : [  ],
  content_type : 33,
  ls_id_property : "id",
  gc_name : 0,
  initComponent : function() {
    this.ls_detail_handler = Lino.cal.MyPendingPresences.detail;
    this.ls_insert_handler = Lino.cal.MyPendingPresences.insert;
    var ww = this.containing_window;
    var event__when_text_disp2776 = new Ext.form.DisplayField({ "disabled": true, "value": "<br/>", "always_enabled": true });
    var role2777 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/MyPendingPresences/role", "method": "GET" }) }), "pageSize": 20, "emptyText": "Gastrolle ausw\u00e4hlen..." });
    var workflow_buttons_disp2778 = new Ext.form.DisplayField({ "disabled": true, "value": "<br/>", "always_enabled": true });
    var remark2779 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ { "header": "Wann", "colIndex": 0, "sortable": false, "dataIndex": "event__when_text", "width": Lino.chars2width(31), "editable": false }, { "colIndex": 1, "sortable": true, "width": Lino.chars2width(21), "editable": true, "filter": { "type": "string" }, "header": "Rolle", "editor": role2777, "dataIndex": "role" }, { "header": "Arbeitsablauf", "colIndex": 2, "sortable": false, "dataIndex": "workflow_buttons", "width": Lino.chars2width(31), "editable": false }, { "colIndex": 3, "sortable": true, "width": Lino.chars2width(22), "editable": true, "filter": { "type": "string" }, "header": "Bemerkung", "editor": remark2779, "dataIndex": "remark" } ];
    Lino.cal.MyPendingPresences.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.cal.MyPendingPresences.show_as_html = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/cal/MyPendingPresences", "GET", pk, "show_as_html", params, Lino.get_current_grid_config);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.cal.MyPendingPresences.as_pdf = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/cal/MyPendingPresences", "GET", pk, "as_pdf", params, Lino.get_current_grid_config);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.cal.MyPendingPresences.as_pdf_p = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/cal/MyPendingPresences", "GET", pk, "as_pdf_p", params, Lino.get_current_grid_config);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.cal.MyPendingPresences.export_excel = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/cal/MyPendingPresences", "GET", pk, "export_excel", params, Lino.get_current_grid_config);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.cal.MyPendingPresences.submit_detail = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/cal/MyPendingPresences", "GET", pk, "submit_detail", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};

Lino.cal.MyPendingPresences.insertPanel = Ext.extend(Lino.cal.MyPresences.InsertFormPanel,{
  empty_title: "Neu",
  hide_navigator: true,
  params_panel_hidden: true,
  save_action_name: "submit_insert",
  ls_bbar_actions: [ { "itemId": "submit_insert", "menu_item_text": "Erstellen", "tooltip": "Datensatz erstellen und dann im Detail-Fenster \u00f6ffnen", "panel_btn_handler": function(panel){panel.save()}, "text": "Erstellen", "overflowText": "Erstellen", "auto_save": false } ],
  ls_url: "/cal/MyPendingPresences",
  action_name: "insert",
  initComponent : function() {
    this.ls_detail_handler = Lino.cal.MyPendingPresences.detail;
    this.ls_insert_handler = Lino.cal.MyPendingPresences.insert;
    Lino.cal.MyPendingPresences.insertPanel.superclass.initComponent.call(this);
  }
});

Lino.cal.MyPendingPresences.insert = new Lino.WindowAction({ "draggable": true, "width": Lino.chars2width(60), "autoHeight": true, "maximizable": true, "modal": true, "maximized": false }, function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.cal.MyPendingPresences.insertPanel(p);
});
Lino.cal.MyPendingPresences.grid_put = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/cal/MyPendingPresences", "GET", pk, "grid_put", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.cal.MyPendingPresences.grid_post = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/cal/MyPendingPresences", "GET", pk, "grid_post", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.cal.MyPendingPresences.submit_insert = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/cal/MyPendingPresences", "GET", pk, "submit_insert", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.cal.MyPendingPresences.wf3 = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/cal/MyPendingPresences", "GET", pk, "wf3", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.cal.MyPendingPresences.wf4 = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/cal/MyPendingPresences", "GET", pk, "wf4", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.cal.MyPendingPresences.wf5 = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/cal/MyPendingPresences", "GET", pk, "wf5", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.cal.MyPendingPresences.wf6 = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/cal/MyPendingPresences", "GET", pk, "wf6", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};

Lino.cal.MyPendingPresences.detailPanel = Ext.extend(Lino.cal.MyPresences.DetailFormPanel,{
  empty_title: "Detail",
  params_panel_hidden: true,
  save_action_name: "submit_detail",
  ls_bbar_actions: [ { "itemId": "submit_detail", "menu_item_text": "Speichern", "tooltip": "\u00c4nderungen in diesem Formular speichern", "panel_btn_handler": function(panel){panel.save()}, "iconCls": "x-tbar-disk", "overflowText": "Speichern", "auto_save": false }, { "itemId": "insert", "menu_item_text": "Neu", "tooltip": "Neuen Datensatz erstellen", "panel_btn_handler": Lino.show_insert, "iconCls": "x-tbar-add", "overflowText": "Neu", "keycode": 44, "auto_save": true }, { "itemId": "delete_selected", "menu_item_text": "L\u00f6schen", "tooltip": "Diesen Datensatz l\u00f6schen", "panel_btn_handler": Lino.row_action_handler('delete_selected','GET',null), "iconCls": "x-tbar-delete", "overflowText": "L\u00f6schen", "keycode": 46, "auto_save": false }, { "itemId": "do_print", "menu_item_text": "Anwesenheitsbescheinigung", "tooltip": "Auszug von diesem Datensatz erstellen zwecks Ausdruck.", "panel_btn_handler": Lino.row_action_handler('do_print','GET',null), "iconCls": "x-tbar-printer", "overflowText": "Anwesenheitsbescheinigung", "auto_save": true }, { "itemId": "checkin", "menu_item_text": "Einchecken", "tooltip": "Mark this visitor as arrived", "panel_btn_handler": Lino.param_action_handler(Lino.cal.Guests.checkin), "text": "Einchecken", "overflowText": "Einchecken", "auto_save": true }, { "itemId": "receive", "menu_item_text": "Empfangen", "tooltip": "Visitor was received by agent", "panel_btn_handler": Lino.row_action_handler('receive','GET',null), "text": "Empfangen", "overflowText": "Empfangen", "auto_save": true }, { "itemId": "checkout", "menu_item_text": "Auschecken", "tooltip": "Visitor left the centre", "panel_btn_handler": Lino.row_action_handler('checkout','GET',null), "text": "Auschecken", "overflowText": "Auschecken", "auto_save": true } ],
  ls_url: "/cal/MyPendingPresences",
  action_name: "detail",
  initComponent : function() {
    this.ls_detail_handler = Lino.cal.MyPendingPresences.detail;
    this.ls_insert_handler = Lino.cal.MyPendingPresences.insert;
    Lino.cal.MyPendingPresences.detailPanel.superclass.initComponent.call(this);
  }
});

Lino.cal.MyPendingPresences.detail = new Lino.WindowAction({  }, function(){
  var p = { "is_main_window": true };
  return new Lino.cal.MyPendingPresences.detailPanel(p);
});
Lino.cal.MyPendingPresences.delete_selected = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/cal/MyPendingPresences", "GET", pk, "delete_selected", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.cal.MyPendingPresences.do_print = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/cal/MyPendingPresences", "GET", pk, "do_print", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.cal.MyPendingPresences.grid = new Lino.WindowAction({  }, function(){
  var p = { "is_main_window": true };
  p.params_panel = new Lino.cal.MyPresences.ParamsPanel({});
  return new Lino.cal.MyPendingPresences.GridPanel(p);
});
Lino.cal.MyPendingPresences.validate = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/cal/MyPendingPresences", "GET", pk, "validate", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.cal.MyPendingPresences.receive = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/cal/MyPendingPresences", "GET", pk, "receive", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.cal.MyPendingPresences.checkout = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/cal/MyPendingPresences", "GET", pk, "checkout", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};

// js_render_GridPanel_class cal.MyGuests
Lino.cal.MyGuests.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "Keine Daten anzuzeigen." },
  ls_url : "/cal/MyGuests",
  ls_bbar_actions : [ { "itemId": "show_as_html", "menu_item_text": "HTML", "tooltip": "Show this table in Bootstrap3 interface", "panel_btn_handler": Lino.list_action_handler('/cal/MyGuests','show_as_html','GET',Lino.get_current_grid_config), "iconCls": "x-tbar-html", "overflowText": "HTML", "auto_save": true }, { "panel_btn_handler": Lino.list_action_handler('/cal/MyGuests','as_pdf','GET',Lino.get_current_grid_config), "xtype": "splitbutton", "text": null, "menu": [ { "itemId": "as_pdf", "menu_item_text": "Tabelle (Querformat)", "tooltip": "Diese Tabelle in eine .pdf-Datei exportieren", "panel_btn_handler": Lino.list_action_handler('/cal/MyGuests','as_pdf','GET',Lino.get_current_grid_config), "text": "Tabelle (Querformat)", "overflowText": "Tabelle (Querformat)", "auto_save": true }, { "itemId": "as_pdf_p", "menu_item_text": "Tabelle (Hochformat)", "tooltip": "Diese Tabelle in eine .pdf-Datei exportieren", "panel_btn_handler": Lino.list_action_handler('/cal/MyGuests','as_pdf_p','GET',Lino.get_current_grid_config), "text": "Tabelle (Hochformat)", "overflowText": "Tabelle (Hochformat)", "auto_save": true } ], "iconCls": "x-tbar-pdf", "menu_item_text": "Tabelle (Querformat)" }, { "itemId": "export_excel", "menu_item_text": "Export to .xls", "tooltip": "Export this table as an .xls document", "panel_btn_handler": Lino.list_action_handler('/cal/MyGuests','export_excel','GET',Lino.get_current_grid_config), "iconCls": "x-tbar-csv", "overflowText": "Export to .xls", "auto_save": true }, { "itemId": "insert", "menu_item_text": "Neu", "tooltip": "Neuen Datensatz erstellen", "panel_btn_handler": Lino.show_insert, "iconCls": "x-tbar-add", "overflowText": "Neu", "keycode": 44, "auto_save": true }, { "itemId": "detail", "menu_item_text": "Detail", "tooltip": "Detail-Fenster auf diesem Datensatz \u00f6ffnen", "panel_btn_handler": Lino.show_detail, "iconCls": "x-tbar-application_form", "overflowText": "Detail", "auto_save": true }, { "itemId": "delete_selected", "menu_item_text": "L\u00f6schen", "tooltip": "Diesen Datensatz l\u00f6schen", "panel_btn_handler": Lino.row_action_handler('delete_selected','GET',null), "iconCls": "x-tbar-delete", "overflowText": "L\u00f6schen", "keycode": 46, "auto_save": false }, { "itemId": "do_print", "menu_item_text": "Anwesenheitsbescheinigung", "tooltip": "Auszug von diesem Datensatz erstellen zwecks Ausdruck.", "panel_btn_handler": Lino.row_action_handler('do_print','GET',null), "iconCls": "x-tbar-printer", "overflowText": "Anwesenheitsbescheinigung", "auto_save": true }, { "itemId": "checkin", "menu_item_text": "Einchecken", "tooltip": "Mark this visitor as arrived", "panel_btn_handler": Lino.param_action_handler(Lino.cal.Guests.checkin), "text": "Einchecken", "overflowText": "Einchecken", "auto_save": true }, { "itemId": "receive", "menu_item_text": "Empfangen", "tooltip": "Visitor was received by agent", "panel_btn_handler": Lino.row_action_handler('receive','GET',null), "text": "Empfangen", "overflowText": "Empfangen", "auto_save": true }, { "itemId": "checkout", "menu_item_text": "Auschecken", "tooltip": "Visitor left the centre", "panel_btn_handler": Lino.row_action_handler('checkout','GET',null), "text": "Auschecken", "overflowText": "Auschecken", "auto_save": true } ],
  cell_edit : true,
  title : "Meine G\u00e4ste",
  page_length : 20,
  stripeRows : true,
  disabled_actions_index : 18,
  ls_store_fields : [ { "type": "date", "name": "event__start_date", "dateFormat": "d.m.Y" }, { "name": "event__start_time" }, { "name": "event_summary" }, { "name": "role" }, 'roleHidden', { "name": "workflow_buttons" }, { "name": "remark" }, { "type": "int", "name": "id" }, { "name": "event" }, 'eventHidden', { "name": "partner" }, 'partnerHidden', { "name": "state" }, 'stateHidden', { "name": "waiting_since" }, { "name": "busy_since" }, { "name": "gone_since" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 7,
  ls_grid_configs : [  ],
  content_type : 33,
  ls_id_property : "id",
  gc_name : 0,
  initComponent : function() {
    this.ls_detail_handler = Lino.cal.MyGuests.detail;
    this.ls_insert_handler = Lino.cal.MyGuests.insert;
    var ww = this.containing_window;
    var event__start_date2781 = new Lino.DateField({ "disabled": true });
    var event__start_time2782 = new Lino.TimeField({ "disabled": true });
    var event_summary_disp2783 = new Ext.form.DisplayField({ "disabled": true, "value": "<br/>", "always_enabled": true });
    var role2784 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/MyGuests/role", "method": "GET" }) }), "pageSize": 20, "emptyText": "Gastrolle ausw\u00e4hlen..." });
    var workflow_buttons_disp2785 = new Ext.form.DisplayField({ "disabled": true, "value": "<br/>", "always_enabled": true });
    var remark2786 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var id2787 = new Ext.form.NumberField({ "selectOnFocus": true });
    var event2788 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/MyGuests/event", "method": "GET" }) }), "allowBlank": false, "pageSize": 20, "emptyText": "Termin ausw\u00e4hlen..." });
    var partner2789 = new Lino.RemoteComboFieldElement({ "preferred_width": 20, "allowBlank": false, "pageSize": 20, "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/MyGuests/partner", "method": "GET" }) }), "emptyText": "Partner ausw\u00e4hlen..." });
    var state2790 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "forceSelection": true, "allowBlank": false, "store": Lino.cal.GuestStates });
    var waiting_since2791 = new Ext.form.DisplayField({ "disabled": true, "value": "<br>" });
    var busy_since2792 = new Ext.form.DisplayField({ "disabled": true, "value": "<br>" });
    var gone_since2793 = new Ext.form.DisplayField({ "disabled": true, "value": "<br>" });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ { "colIndex": 0, "sortable": true, "xtype": "datecolumn", "format": "d.m.Y", "editable": false, "filter": { "type": "date", "dateFormat": "d.m.Y" }, "header": "Beginnt am", "dataIndex": "event__start_date", "width": Lino.chars2width(14) }, { "width": Lino.chars2width(9), "colIndex": 1, "sortable": true, "dataIndex": "event__start_time", "header": "Beginnt um", "editable": false }, { "header": "Termin", "colIndex": 2, "sortable": false, "dataIndex": "event_summary", "width": Lino.chars2width(31), "editable": false }, { "colIndex": 3, "sortable": true, "width": Lino.chars2width(21), "editable": true, "filter": { "type": "string" }, "header": "Rolle", "editor": role2784, "dataIndex": "role" }, { "header": "Arbeitsablauf", "colIndex": 4, "sortable": false, "dataIndex": "workflow_buttons", "width": Lino.chars2width(31), "editable": false }, { "colIndex": 5, "sortable": true, "width": Lino.chars2width(22), "editable": true, "filter": { "type": "string" }, "header": "Bemerkung", "editor": remark2786, "dataIndex": "remark" }, new Lino.NullNumberColumn({ "colIndex": 6, "sortable": true, "format": "0", "editable": true, "filter": { "type": "numeric" }, "header": "ID", "editor": id2787, "hidden": true, "width": Lino.chars2width(6), "dataIndex": "id" }), { "colIndex": 7, "sortable": true, "header": "Termin", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('eventHidden','Lino.cal.OneEvent.detail'), "dataIndex": "event", "hidden": true, "editor": event2788 }, { "colIndex": 8, "sortable": true, "header": "Partner", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('partnerHidden','Lino.contacts.Partners.detail'), "dataIndex": "partner", "hidden": true, "editor": partner2789 }, { "colIndex": 9, "sortable": true, "header": "Zustand", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(16), "editor": state2790, "hidden": true, "dataIndex": "state" }, { "colIndex": 10, "sortable": true, "width": Lino.chars2width(17), "editable": false, "tooltip": "Time when the visitor arrived (checked in).", "header": "Wartet seit", "dataIndex": "waiting_since", "hidden": true }, { "colIndex": 11, "sortable": true, "width": Lino.chars2width(17), "editable": false, "tooltip": "Time when the visitor was received by agent.", "header": "Hat gewartet bis", "dataIndex": "busy_since", "hidden": true }, { "colIndex": 12, "sortable": true, "width": Lino.chars2width(17), "editable": false, "tooltip": "Time when the visitor left (checked out).", "header": "Anwesend bis", "dataIndex": "gone_since", "hidden": true } ];
    Lino.cal.MyGuests.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.cal.MyGuests.show_as_html = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/cal/MyGuests", "GET", pk, "show_as_html", params, Lino.get_current_grid_config);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.cal.MyGuests.as_pdf = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/cal/MyGuests", "GET", pk, "as_pdf", params, Lino.get_current_grid_config);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.cal.MyGuests.as_pdf_p = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/cal/MyGuests", "GET", pk, "as_pdf_p", params, Lino.get_current_grid_config);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.cal.MyGuests.export_excel = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/cal/MyGuests", "GET", pk, "export_excel", params, Lino.get_current_grid_config);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.cal.MyGuests.submit_detail = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/cal/MyGuests", "GET", pk, "submit_detail", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};

Lino.cal.MyGuests.insertPanel = Ext.extend(Lino.cal.MyPresences.InsertFormPanel,{
  empty_title: "Neu",
  hide_navigator: true,
  save_action_name: "submit_insert",
  ls_bbar_actions: [ { "itemId": "submit_insert", "menu_item_text": "Erstellen", "tooltip": "Datensatz erstellen und dann im Detail-Fenster \u00f6ffnen", "panel_btn_handler": function(panel){panel.save()}, "text": "Erstellen", "overflowText": "Erstellen", "auto_save": false } ],
  ls_url: "/cal/MyGuests",
  action_name: "insert",
  initComponent : function() {
    this.ls_detail_handler = Lino.cal.MyGuests.detail;
    this.ls_insert_handler = Lino.cal.MyGuests.insert;
    Lino.cal.MyGuests.insertPanel.superclass.initComponent.call(this);
  }
});

Lino.cal.MyGuests.insert = new Lino.WindowAction({ "draggable": true, "width": Lino.chars2width(60), "autoHeight": true, "maximizable": true, "modal": true, "maximized": false }, function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.cal.MyGuests.insertPanel(p);
});
Lino.cal.MyGuests.grid_put = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/cal/MyGuests", "GET", pk, "grid_put", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.cal.MyGuests.grid_post = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/cal/MyGuests", "GET", pk, "grid_post", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.cal.MyGuests.submit_insert = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/cal/MyGuests", "GET", pk, "submit_insert", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.cal.MyGuests.wf3 = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/cal/MyGuests", "GET", pk, "wf3", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.cal.MyGuests.wf4 = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/cal/MyGuests", "GET", pk, "wf4", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.cal.MyGuests.wf5 = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/cal/MyGuests", "GET", pk, "wf5", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.cal.MyGuests.wf6 = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/cal/MyGuests", "GET", pk, "wf6", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};

Lino.cal.MyGuests.detailPanel = Ext.extend(Lino.cal.MyPresences.DetailFormPanel,{
  empty_title: "Detail",
  save_action_name: "submit_detail",
  ls_bbar_actions: [ { "itemId": "submit_detail", "menu_item_text": "Speichern", "tooltip": "\u00c4nderungen in diesem Formular speichern", "panel_btn_handler": function(panel){panel.save()}, "iconCls": "x-tbar-disk", "overflowText": "Speichern", "auto_save": false }, { "itemId": "insert", "menu_item_text": "Neu", "tooltip": "Neuen Datensatz erstellen", "panel_btn_handler": Lino.show_insert, "iconCls": "x-tbar-add", "overflowText": "Neu", "keycode": 44, "auto_save": true }, { "itemId": "delete_selected", "menu_item_text": "L\u00f6schen", "tooltip": "Diesen Datensatz l\u00f6schen", "panel_btn_handler": Lino.row_action_handler('delete_selected','GET',null), "iconCls": "x-tbar-delete", "overflowText": "L\u00f6schen", "keycode": 46, "auto_save": false }, { "itemId": "do_print", "menu_item_text": "Anwesenheitsbescheinigung", "tooltip": "Auszug von diesem Datensatz erstellen zwecks Ausdruck.", "panel_btn_handler": Lino.row_action_handler('do_print','GET',null), "iconCls": "x-tbar-printer", "overflowText": "Anwesenheitsbescheinigung", "auto_save": true }, { "itemId": "checkin", "menu_item_text": "Einchecken", "tooltip": "Mark this visitor as arrived", "panel_btn_handler": Lino.param_action_handler(Lino.cal.Guests.checkin), "text": "Einchecken", "overflowText": "Einchecken", "auto_save": true }, { "itemId": "receive", "menu_item_text": "Empfangen", "tooltip": "Visitor was received by agent", "panel_btn_handler": Lino.row_action_handler('receive','GET',null), "text": "Empfangen", "overflowText": "Empfangen", "auto_save": true }, { "itemId": "checkout", "menu_item_text": "Auschecken", "tooltip": "Visitor left the centre", "panel_btn_handler": Lino.row_action_handler('checkout','GET',null), "text": "Auschecken", "overflowText": "Auschecken", "auto_save": true } ],
  ls_url: "/cal/MyGuests",
  action_name: "detail",
  initComponent : function() {
    this.ls_detail_handler = Lino.cal.MyGuests.detail;
    this.ls_insert_handler = Lino.cal.MyGuests.insert;
    Lino.cal.MyGuests.detailPanel.superclass.initComponent.call(this);
  }
});

Lino.cal.MyGuests.detail = new Lino.WindowAction({  }, function(){
  var p = { "is_main_window": true };
  return new Lino.cal.MyGuests.detailPanel(p);
});
Lino.cal.MyGuests.delete_selected = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/cal/MyGuests", "GET", pk, "delete_selected", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.cal.MyGuests.do_print = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/cal/MyGuests", "GET", pk, "do_print", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.cal.MyGuests.grid = new Lino.WindowAction({  }, function(){
  var p = { "is_main_window": true };
  p.params_panel = new Lino.cal.MyPresences.ParamsPanel({});
  return new Lino.cal.MyGuests.GridPanel(p);
});
Lino.cal.MyGuests.validate = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/cal/MyGuests", "GET", pk, "validate", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.cal.MyGuests.receive = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/cal/MyGuests", "GET", pk, "receive", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.cal.MyGuests.checkout = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/cal/MyGuests", "GET", pk, "checkout", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};

// js_render_GridPanel_class cal.EventsByDay
Lino.cal.EventsByDay.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "forceFit": true, "emptyText": "Keine Daten anzuzeigen." },
  ls_url : "/cal/EventsByDay",
  ls_bbar_actions : [ { "itemId": "show_as_html", "menu_item_text": "HTML", "tooltip": "Show this table in Bootstrap3 interface", "panel_btn_handler": Lino.list_action_handler('/cal/EventsByDay','show_as_html','GET',Lino.get_current_grid_config), "iconCls": "x-tbar-html", "overflowText": "HTML", "auto_save": true }, { "panel_btn_handler": Lino.list_action_handler('/cal/EventsByDay','as_pdf','GET',Lino.get_current_grid_config), "xtype": "splitbutton", "text": null, "menu": [ { "itemId": "as_pdf", "menu_item_text": "Tabelle (Querformat)", "tooltip": "Diese Tabelle in eine .pdf-Datei exportieren", "panel_btn_handler": Lino.list_action_handler('/cal/EventsByDay','as_pdf','GET',Lino.get_current_grid_config), "text": "Tabelle (Querformat)", "overflowText": "Tabelle (Querformat)", "auto_save": true }, { "itemId": "as_pdf_p", "menu_item_text": "Tabelle (Hochformat)", "tooltip": "Diese Tabelle in eine .pdf-Datei exportieren", "panel_btn_handler": Lino.list_action_handler('/cal/EventsByDay','as_pdf_p','GET',Lino.get_current_grid_config), "text": "Tabelle (Hochformat)", "overflowText": "Tabelle (Hochformat)", "auto_save": true } ], "iconCls": "x-tbar-pdf", "menu_item_text": "Tabelle (Querformat)" }, { "itemId": "export_excel", "menu_item_text": "Export to .xls", "tooltip": "Export this table as an .xls document", "panel_btn_handler": Lino.list_action_handler('/cal/EventsByDay','export_excel','GET',Lino.get_current_grid_config), "iconCls": "x-tbar-csv", "overflowText": "Export to .xls", "auto_save": true }, { "itemId": "insert", "menu_item_text": "Neu", "tooltip": "Neuen Datensatz erstellen", "panel_btn_handler": Lino.show_insert, "iconCls": "x-tbar-add", "overflowText": "Neu", "keycode": 44, "auto_save": true }, { "itemId": "duplicate", "menu_item_text": "Duplizieren", "tooltip": "Duplizieren", "panel_btn_handler": Lino.row_action_handler('duplicate','GET',null), "iconCls": "x-tbar-arrow_divide", "overflowText": "Duplizieren", "auto_save": true }, { "itemId": "detail", "menu_item_text": "Detail", "tooltip": "Detail-Fenster auf diesem Datensatz \u00f6ffnen", "panel_btn_handler": Lino.show_detail, "iconCls": "x-tbar-application_form", "overflowText": "Detail", "auto_save": true }, { "itemId": "delete_selected", "menu_item_text": "L\u00f6schen", "tooltip": "Diesen Datensatz l\u00f6schen", "panel_btn_handler": Lino.row_action_handler('delete_selected','GET',null), "iconCls": "x-tbar-delete", "overflowText": "L\u00f6schen", "keycode": 46, "auto_save": false }, { "itemId": "do_print", "menu_item_text": "Drucken", "tooltip": "Drucken", "panel_btn_handler": Lino.row_action_handler('do_print','POST',null), "iconCls": "x-tbar-printer", "overflowText": "Drucken", "auto_save": true }, { "itemId": "do_clear_cache", "menu_item_text": "Cache l\u00f6schen", "tooltip": "Cache l\u00f6schen", "panel_btn_handler": Lino.row_action_handler('do_clear_cache','GET',null), "iconCls": "x-tbar-printer_delete", "overflowText": "Cache l\u00f6schen", "auto_save": true }, { "itemId": "show_today", "menu_item_text": "Heute", "tooltip": "Show all calendar events of the same day.", "panel_btn_handler": Lino.row_action_handler('show_today','GET',null), "iconCls": "x-tbar-calendar", "overflowText": "Heute", "auto_save": true }, { "itemId": "create_postings", "menu_item_text": "per Post", "tooltip": "Create classical mail postings from this", "panel_btn_handler": Lino.row_action_handler('create_postings','GET',null), "iconCls": "x-tbar-script_add", "overflowText": "per Post", "auto_save": true }, { "itemId": "do_update_guests", "menu_item_text": "Update Guests", "tooltip": "Update Guests", "panel_btn_handler": Lino.row_action_handler('do_update_guests','GET',null), "iconCls": "x-tbar-lightning", "overflowText": "Update Guests", "auto_save": true }, { "itemId": "take", "menu_item_text": "Annehmen", "tooltip": "Verantwortung f\u00fcr diesen Termin \u00fcbernehmen.", "panel_btn_handler": Lino.row_action_handler('take','GET',null), "iconCls": "x-tbar-flag_green", "overflowText": "Annehmen", "auto_save": true }, { "itemId": "move_next", "menu_item_text": "Nach unten", "tooltip": "Nach unten", "panel_btn_handler": Lino.row_action_handler('move_next','GET',null), "iconCls": "x-tbar-date_next", "overflowText": "Nach unten", "auto_save": true }, { "itemId": "create_mail", "menu_item_text": "per E-Mail", "tooltip": "Create an email from this", "panel_btn_handler": Lino.row_action_handler('create_mail','GET',null), "iconCls": "x-tbar-email_add", "overflowText": "per E-Mail", "auto_save": true } ],
  cell_edit : true,
  title : "Termine heute",
  page_length : 20,
  stripeRows : true,
  disabled_actions_index : 37,
  ls_store_fields : [ { "name": "start_time" }, { "name": "project" }, 'projectHidden', { "name": "summary" }, { "name": "user" }, 'userHidden', { "name": "assigned_to" }, 'assigned_toHidden', { "name": "room" }, 'roomHidden', { "name": "workflow_buttons" }, { "type": "int", "name": "id" }, { "name": "modified" }, { "name": "created" }, { "name": "build_time" }, { "name": "build_method" }, 'build_methodHidden', { "name": "owner_type" }, 'owner_typeHidden', { "name": "owner_id" }, 'owner_idHidden', { "type": "date", "name": "start_date", "dateFormat": "d.m.Y" }, { "type": "date", "name": "end_date", "dateFormat": "d.m.Y" }, { "name": "end_time" }, { "name": "access_class" }, 'access_classHidden', { "type": "int", "name": "sequence" }, { "type": "int", "name": "auto_type" }, { "name": "event_type" }, 'event_typeHidden', { "type": "boolean", "name": "transparent" }, { "name": "priority" }, 'priorityHidden', { "name": "state" }, 'stateHidden', { "name": "owner" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 11,
  ls_grid_configs : [  ],
  content_type : 37,
  ls_id_property : "id",
  gc_name : 0,
  initComponent : function() {
    this.ls_detail_handler = Lino.cal.EventsByDay.detail;
    this.ls_insert_handler = Lino.cal.EventsByDay.insert;
    var ww = this.containing_window;
    var start_time2795 = new Lino.TimeField({ "selectOnFocus": true });
    var project2796 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "preferred_width": 20, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/EventsByDay/project", "method": "GET" }) }), "pageSize": 20, "emptyText": "Klient ausw\u00e4hlen..." });
    var summary2797 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var user2798 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "preferred_width": 15, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/EventsByDay/user", "method": "GET" }) }), "pageSize": 20, "emptyText": "Benutzer ausw\u00e4hlen..." });
    var assigned_to2799 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "preferred_width": 15, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/EventsByDay/assigned_to", "method": "GET" }) }), "pageSize": 20, "emptyText": "Benutzer ausw\u00e4hlen..." });
    var room2800 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/EventsByDay/room", "method": "GET" }) }), "pageSize": 20, "emptyText": "Raum ausw\u00e4hlen..." });
    var workflow_buttons_disp2801 = new Ext.form.DisplayField({ "disabled": true, "value": "<br/>", "always_enabled": true });
    var id2802 = new Ext.form.NumberField({ "selectOnFocus": true });
    var modified2803 = new Ext.form.DisplayField({ "disabled": true, "value": "<br>" });
    var created2804 = new Ext.form.DisplayField({ "disabled": true, "value": "<br>" });
    var build_time2805 = new Ext.form.DisplayField({ "disabled": true, "value": "<br>" });
    var build_method2806 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "forceSelection": true, "allowBlank": false, "store": Lino.lino.BuildMethods });
    var owner_type2807 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/EventsByDay/owner_type", "method": "GET" }) }), "pageSize": 20, "emptyText": "Datenbankmodell ausw\u00e4hlen..." });
    var owner_id2808 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/EventsByDay/owner_id", "method": "GET" }) }) });
    var start_date2809 = new Lino.DateField({ "selectOnFocus": true });
    var end_date2810 = new Lino.DateField({ "selectOnFocus": true });
    var end_time2811 = new Lino.TimeField({ "selectOnFocus": true });
    var access_class2812 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "forceSelection": true, "store": [['','<br>']].concat(Lino.cal.AccessClasses) });
    var sequence2813 = new Ext.form.NumberField({ "selectOnFocus": true, "allowBlank": false, "value": 0 });
    var auto_type2814 = new Ext.form.NumberField({ "disabled": true });
    var event_type2815 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/EventsByDay/event_type", "method": "GET" }) }), "pageSize": 20, "emptyText": "Ereignisart ausw\u00e4hlen..." });
    var transparent2816 = new Ext.form.Checkbox({ "selectOnFocus": true, "checked": false });
    var priority2817 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/EventsByDay/priority", "method": "GET" }) }), "pageSize": 20, "emptyText": "Priorit\u00e4t ausw\u00e4hlen..." });
    var state2818 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "forceSelection": true, "allowBlank": false, "store": Lino.cal.EventStates });
    var owner_disp2819 = new Ext.form.DisplayField({ "disabled": true });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ { "width": Lino.chars2width(9), "colIndex": 0, "sortable": true, "editor": start_time2795, "header": "Beginnt um", "editable": true, "dataIndex": "start_time" }, { "colIndex": 1, "sortable": true, "header": "Klient", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('projectHidden','Lino.pcsw.Clients.detail'), "dataIndex": "project", "editor": project2796 }, { "colIndex": 2, "sortable": true, "width": Lino.chars2width(22), "editable": true, "filter": { "type": "string" }, "header": "Kurzbeschreibung", "editor": summary2797, "dataIndex": "summary" }, { "colIndex": 3, "sortable": true, "width": Lino.chars2width(21), "editable": true, "filter": { "type": "string" }, "header": "Verwaltet durch", "editor": user2798, "dataIndex": "user" }, { "colIndex": 4, "sortable": true, "width": Lino.chars2width(21), "editable": true, "filter": { "type": "string" }, "header": "Zugewiesen zu", "editor": assigned_to2799, "dataIndex": "assigned_to" }, { "colIndex": 5, "sortable": true, "width": Lino.chars2width(21), "editable": true, "filter": { "type": "string" }, "header": "Raum", "editor": room2800, "dataIndex": "room" }, { "header": "Arbeitsablauf", "colIndex": 6, "sortable": false, "dataIndex": "workflow_buttons", "width": Lino.chars2width(31), "editable": false }, new Lino.NullNumberColumn({ "colIndex": 7, "sortable": true, "format": "0", "editable": true, "filter": { "type": "numeric" }, "header": "ID", "editor": id2802, "hidden": true, "width": Lino.chars2width(6), "dataIndex": "id" }), { "header": "Bearbeitet", "colIndex": 8, "sortable": true, "dataIndex": "modified", "width": Lino.chars2width(17), "hidden": true, "editable": false }, { "header": "Erstellt", "colIndex": 9, "sortable": true, "dataIndex": "created", "width": Lino.chars2width(17), "hidden": true, "editable": false }, { "header": "Druckdatum", "colIndex": 10, "sortable": true, "dataIndex": "build_time", "width": Lino.chars2width(17), "hidden": true, "editable": false }, { "colIndex": 11, "sortable": true, "header": "Konstruktionsmethode", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "editor": build_method2806, "hidden": true, "dataIndex": "build_method" }, { "colIndex": 12, "sortable": true, "header": "Verkn\u00fcpft mit (Modell)", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "editor": owner_type2807, "hidden": true, "dataIndex": "owner_type" }, { "colIndex": 13, "sortable": true, "header": "Verkn\u00fcpft mit (Objekt)", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(11), "editor": owner_id2808, "hidden": true, "dataIndex": "owner_id" }, { "colIndex": 14, "sortable": true, "xtype": "datecolumn", "format": "d.m.Y", "editable": true, "filter": { "type": "date", "dateFormat": "d.m.Y" }, "header": "Beginnt am", "editor": start_date2809, "hidden": true, "width": Lino.chars2width(14), "dataIndex": "start_date" }, { "colIndex": 15, "sortable": true, "xtype": "datecolumn", "format": "d.m.Y", "editable": true, "filter": { "type": "date", "dateFormat": "d.m.Y" }, "header": "Endet am", "editor": end_date2810, "hidden": true, "width": Lino.chars2width(14), "dataIndex": "end_date" }, { "colIndex": 16, "sortable": true, "width": Lino.chars2width(9), "editable": true, "header": "Endet um", "editor": end_time2811, "hidden": true, "dataIndex": "end_time" }, { "colIndex": 17, "sortable": true, "header": "Zugriffsklasse", "editable": true, "tooltip": "Ob dieser Termin  privat, \u00f6ffentlich oder halb \u00f6ffentlich ist", "filter": { "type": "string" }, "width": Lino.chars2width(35), "editor": access_class2812, "hidden": true, "dataIndex": "access_class" }, new Lino.NullNumberColumn({ "colIndex": 18, "sortable": true, "format": "0", "editable": true, "filter": { "type": "numeric" }, "header": "Revisionsnummer", "editor": sequence2813, "hidden": true, "width": Lino.chars2width(6), "dataIndex": "sequence" }), new Lino.NullNumberColumn({ "colIndex": 19, "sortable": true, "format": "0", "editable": false, "filter": { "type": "numeric" }, "header": "auto type", "dataIndex": "auto_type", "hidden": true, "width": Lino.chars2width(6) }), { "colIndex": 20, "sortable": true, "header": "Ereignisart", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "editor": event_type2815, "hidden": true, "dataIndex": "event_type" }, { "colIndex": 21, "sortable": false, "xtype": "checkcolumn", "width": Lino.chars2width(11), "editable": true, "tooltip": "Dieser Termin l\u00e4sst auch andere Termine zur gleichen Zeit zu.", "filter": { "type": "boolean" }, "header": "nicht blockierend", "dataIndex": "transparent", "hidden": true }, { "colIndex": 22, "sortable": true, "header": "Priorit\u00e4t", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "editor": priority2817, "hidden": true, "dataIndex": "priority" }, { "colIndex": 23, "sortable": true, "header": "Zustand", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(18), "editor": state2818, "hidden": true, "dataIndex": "state" }, { "header": "Verkn\u00fcpft mit", "colIndex": 24, "sortable": false, "dataIndex": "owner", "width": Lino.chars2width(11), "hidden": true, "editable": false } ];
    Lino.cal.EventsByDay.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.cal.EventsByDay.show_as_html = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/cal/EventsByDay", "GET", pk, "show_as_html", params, Lino.get_current_grid_config);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.cal.EventsByDay.as_pdf = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/cal/EventsByDay", "GET", pk, "as_pdf", params, Lino.get_current_grid_config);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.cal.EventsByDay.as_pdf_p = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/cal/EventsByDay", "GET", pk, "as_pdf_p", params, Lino.get_current_grid_config);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.cal.EventsByDay.export_excel = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/cal/EventsByDay", "GET", pk, "export_excel", params, Lino.get_current_grid_config);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.cal.EventsByDay.submit_detail = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/cal/EventsByDay", "GET", pk, "submit_detail", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};

Lino.cal.EventsByDay.insertPanel = Ext.extend(Lino.cal.EventsByDay.InsertFormPanel,{
  empty_title: "Neu",
  hide_navigator: true,
  save_action_name: "submit_insert",
  ls_bbar_actions: [ { "itemId": "submit_insert", "menu_item_text": "Erstellen", "tooltip": "Datensatz erstellen und dann im Detail-Fenster \u00f6ffnen", "panel_btn_handler": function(panel){panel.save()}, "text": "Erstellen", "overflowText": "Erstellen", "auto_save": false } ],
  ls_url: "/cal/EventsByDay",
  action_name: "insert",
  initComponent : function() {
    this.ls_detail_handler = Lino.cal.EventsByDay.detail;
    this.ls_insert_handler = Lino.cal.EventsByDay.insert;
    Lino.cal.EventsByDay.insertPanel.superclass.initComponent.call(this);
  }
});

Lino.cal.EventsByDay.insert = new Lino.WindowAction({ "draggable": true, "width": Lino.chars2width(60), "autoHeight": true, "maximizable": true, "modal": true, "maximized": false }, function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.cal.EventsByDay.insertPanel(p);
});
Lino.cal.EventsByDay.grid_put = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/cal/EventsByDay", "GET", pk, "grid_put", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.cal.EventsByDay.grid_post = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/cal/EventsByDay", "GET", pk, "grid_post", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.cal.EventsByDay.submit_insert = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/cal/EventsByDay", "GET", pk, "submit_insert", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.cal.EventsByDay.wf1 = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/cal/EventsByDay", "GET", pk, "wf1", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.cal.EventsByDay.duplicate = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/cal/EventsByDay", "GET", pk, "duplicate", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.cal.EventsByDay.wf2 = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/cal/EventsByDay", "GET", pk, "wf2", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.cal.EventsByDay.wf3 = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/cal/EventsByDay", "GET", pk, "wf3", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.cal.EventsByDay.wf4 = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/cal/EventsByDay", "GET", pk, "wf4", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};

Lino.cal.EventsByDay.detailPanel = Ext.extend(Lino.cal.EventsByDay.DetailFormPanel,{
  empty_title: "Detail",
  save_action_name: "submit_detail",
  ls_bbar_actions: [ { "itemId": "submit_detail", "menu_item_text": "Speichern", "tooltip": "\u00c4nderungen in diesem Formular speichern", "panel_btn_handler": function(panel){panel.save()}, "iconCls": "x-tbar-disk", "overflowText": "Speichern", "auto_save": false }, { "itemId": "insert", "menu_item_text": "Neu", "tooltip": "Neuen Datensatz erstellen", "panel_btn_handler": Lino.show_insert, "iconCls": "x-tbar-add", "overflowText": "Neu", "keycode": 44, "auto_save": true }, { "itemId": "duplicate", "menu_item_text": "Duplizieren", "tooltip": "Duplizieren", "panel_btn_handler": Lino.row_action_handler('duplicate','GET',null), "iconCls": "x-tbar-arrow_divide", "overflowText": "Duplizieren", "auto_save": true }, { "itemId": "delete_selected", "menu_item_text": "L\u00f6schen", "tooltip": "Diesen Datensatz l\u00f6schen", "panel_btn_handler": Lino.row_action_handler('delete_selected','GET',null), "iconCls": "x-tbar-delete", "overflowText": "L\u00f6schen", "keycode": 46, "auto_save": false }, { "itemId": "do_print", "menu_item_text": "Drucken", "tooltip": "Drucken", "panel_btn_handler": Lino.row_action_handler('do_print','POST',null), "iconCls": "x-tbar-printer", "overflowText": "Drucken", "auto_save": true }, { "itemId": "do_clear_cache", "menu_item_text": "Cache l\u00f6schen", "tooltip": "Cache l\u00f6schen", "panel_btn_handler": Lino.row_action_handler('do_clear_cache','GET',null), "iconCls": "x-tbar-printer_delete", "overflowText": "Cache l\u00f6schen", "auto_save": true }, { "itemId": "show_today", "menu_item_text": "Heute", "tooltip": "Show all calendar events of the same day.", "panel_btn_handler": Lino.row_action_handler('show_today','GET',null), "iconCls": "x-tbar-calendar", "overflowText": "Heute", "auto_save": true }, { "itemId": "create_postings", "menu_item_text": "per Post", "tooltip": "Create classical mail postings from this", "panel_btn_handler": Lino.row_action_handler('create_postings','GET',null), "iconCls": "x-tbar-script_add", "overflowText": "per Post", "auto_save": true }, { "itemId": "do_update_guests", "menu_item_text": "Update Guests", "tooltip": "Update Guests", "panel_btn_handler": Lino.row_action_handler('do_update_guests','GET',null), "iconCls": "x-tbar-lightning", "overflowText": "Update Guests", "auto_save": true }, { "itemId": "take", "menu_item_text": "Annehmen", "tooltip": "Verantwortung f\u00fcr diesen Termin \u00fcbernehmen.", "panel_btn_handler": Lino.row_action_handler('take','GET',null), "iconCls": "x-tbar-flag_green", "overflowText": "Annehmen", "auto_save": true }, { "itemId": "move_next", "menu_item_text": "Nach unten", "tooltip": "Nach unten", "panel_btn_handler": Lino.row_action_handler('move_next','GET',null), "iconCls": "x-tbar-date_next", "overflowText": "Nach unten", "auto_save": true }, { "itemId": "create_mail", "menu_item_text": "per E-Mail", "tooltip": "Create an email from this", "panel_btn_handler": Lino.row_action_handler('create_mail','GET',null), "iconCls": "x-tbar-email_add", "overflowText": "per E-Mail", "auto_save": true } ],
  ls_url: "/cal/EventsByDay",
  action_name: "detail",
  initComponent : function() {
    this.ls_detail_handler = Lino.cal.EventsByDay.detail;
    this.ls_insert_handler = Lino.cal.EventsByDay.insert;
    Lino.cal.EventsByDay.detailPanel.superclass.initComponent.call(this);
  }
});

Lino.cal.EventsByDay.detail = new Lino.WindowAction({  }, function(){
  var p = { "is_main_window": true };
  return new Lino.cal.EventsByDay.detailPanel(p);
});
Lino.cal.EventsByDay.delete_selected = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/cal/EventsByDay", "GET", pk, "delete_selected", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.cal.EventsByDay.do_print = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/cal/EventsByDay", "POST", pk, "do_print", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.cal.EventsByDay.do_clear_cache = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/cal/EventsByDay", "GET", pk, "do_clear_cache", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.cal.EventsByDay.edit_template = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/cal/EventsByDay", "GET", pk, "edit_template", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.cal.EventsByDay.show_today = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/cal/EventsByDay", "GET", pk, "show_today", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.cal.EventsByDay.grid = new Lino.WindowAction({  }, function(){
  var p = { "is_main_window": true };
  p.params_panel = new Lino.cal.EventsByDay.ParamsPanel({});
  return new Lino.cal.EventsByDay.GridPanel(p);
});
Lino.cal.EventsByDay.validate = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/cal/EventsByDay", "GET", pk, "validate", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.cal.EventsByDay.create_postings = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/cal/EventsByDay", "GET", pk, "create_postings", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.cal.EventsByDay.do_update_guests = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/cal/EventsByDay", "GET", pk, "do_update_guests", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.cal.EventsByDay.take = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/cal/EventsByDay", "GET", pk, "take", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.cal.EventsByDay.move_next = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/cal/EventsByDay", "GET", pk, "move_next", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.cal.EventsByDay.create_mail = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/cal/EventsByDay", "GET", pk, "create_mail", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};

// js_render_GridPanel_class cal.OneEvent
Lino.cal.OneEvent.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "Keine Daten anzuzeigen." },
  ls_url : "/cal/OneEvent",
  ls_bbar_actions : [ { "itemId": "show_as_html", "menu_item_text": "HTML", "tooltip": "Show this table in Bootstrap3 interface", "panel_btn_handler": Lino.list_action_handler('/cal/OneEvent','show_as_html','GET',Lino.get_current_grid_config), "iconCls": "x-tbar-html", "overflowText": "HTML", "auto_save": true }, { "panel_btn_handler": Lino.list_action_handler('/cal/OneEvent','as_pdf','GET',Lino.get_current_grid_config), "xtype": "splitbutton", "text": null, "menu": [ { "itemId": "as_pdf", "menu_item_text": "Tabelle (Querformat)", "tooltip": "Diese Tabelle in eine .pdf-Datei exportieren", "panel_btn_handler": Lino.list_action_handler('/cal/OneEvent','as_pdf','GET',Lino.get_current_grid_config), "text": "Tabelle (Querformat)", "overflowText": "Tabelle (Querformat)", "auto_save": true }, { "itemId": "as_pdf_p", "menu_item_text": "Tabelle (Hochformat)", "tooltip": "Diese Tabelle in eine .pdf-Datei exportieren", "panel_btn_handler": Lino.list_action_handler('/cal/OneEvent','as_pdf_p','GET',Lino.get_current_grid_config), "text": "Tabelle (Hochformat)", "overflowText": "Tabelle (Hochformat)", "auto_save": true } ], "iconCls": "x-tbar-pdf", "menu_item_text": "Tabelle (Querformat)" }, { "itemId": "export_excel", "menu_item_text": "Export to .xls", "tooltip": "Export this table as an .xls document", "panel_btn_handler": Lino.list_action_handler('/cal/OneEvent','export_excel','GET',Lino.get_current_grid_config), "iconCls": "x-tbar-csv", "overflowText": "Export to .xls", "auto_save": true }, { "itemId": "insert", "menu_item_text": "Neu", "tooltip": "Neuen Datensatz erstellen", "panel_btn_handler": Lino.show_insert, "iconCls": "x-tbar-add", "overflowText": "Neu", "keycode": 44, "auto_save": true }, { "itemId": "duplicate", "menu_item_text": "Duplizieren", "tooltip": "Duplizieren", "panel_btn_handler": Lino.row_action_handler('duplicate','GET',null), "iconCls": "x-tbar-arrow_divide", "overflowText": "Duplizieren", "auto_save": true }, { "itemId": "detail", "menu_item_text": "Detail", "tooltip": "Detail-Fenster auf diesem Datensatz \u00f6ffnen", "panel_btn_handler": Lino.show_detail, "iconCls": "x-tbar-application_form", "overflowText": "Detail", "auto_save": true }, { "itemId": "delete_selected", "menu_item_text": "L\u00f6schen", "tooltip": "Diesen Datensatz l\u00f6schen", "panel_btn_handler": Lino.row_action_handler('delete_selected','GET',null), "iconCls": "x-tbar-delete", "overflowText": "L\u00f6schen", "keycode": 46, "auto_save": false }, { "itemId": "do_print", "menu_item_text": "Drucken", "tooltip": "Drucken", "panel_btn_handler": Lino.row_action_handler('do_print','POST',null), "iconCls": "x-tbar-printer", "overflowText": "Drucken", "auto_save": true }, { "itemId": "do_clear_cache", "menu_item_text": "Cache l\u00f6schen", "tooltip": "Cache l\u00f6schen", "panel_btn_handler": Lino.row_action_handler('do_clear_cache','GET',null), "iconCls": "x-tbar-printer_delete", "overflowText": "Cache l\u00f6schen", "auto_save": true }, { "itemId": "show_today", "menu_item_text": "Heute", "tooltip": "Show all calendar events of the same day.", "panel_btn_handler": Lino.row_action_handler('show_today','GET',null), "iconCls": "x-tbar-calendar", "overflowText": "Heute", "auto_save": true }, { "itemId": "move_next", "menu_item_text": "Nach unten", "tooltip": "Nach unten", "panel_btn_handler": Lino.row_action_handler('move_next','GET',null), "iconCls": "x-tbar-date_next", "overflowText": "Nach unten", "auto_save": true }, { "itemId": "create_mail", "menu_item_text": "per E-Mail", "tooltip": "Create an email from this", "panel_btn_handler": Lino.row_action_handler('create_mail','GET',null), "iconCls": "x-tbar-email_add", "overflowText": "per E-Mail", "auto_save": true }, { "itemId": "create_postings", "menu_item_text": "per Post", "tooltip": "Create classical mail postings from this", "panel_btn_handler": Lino.row_action_handler('create_postings','GET',null), "iconCls": "x-tbar-script_add", "overflowText": "per Post", "auto_save": true }, { "itemId": "do_update_guests", "menu_item_text": "Update Guests", "tooltip": "Update Guests", "panel_btn_handler": Lino.row_action_handler('do_update_guests','GET',null), "iconCls": "x-tbar-lightning", "overflowText": "Update Guests", "auto_save": true }, { "itemId": "take", "menu_item_text": "Annehmen", "tooltip": "Verantwortung f\u00fcr diesen Termin \u00fcbernehmen.", "panel_btn_handler": Lino.row_action_handler('take','GET',null), "iconCls": "x-tbar-flag_green", "overflowText": "Annehmen", "auto_save": true } ],
  cell_edit : true,
  title : "Termine",
  page_length : 20,
  params_panel_hidden : true,
  stripeRows : true,
  disabled_actions_index : 37,
  ls_store_fields : [ { "name": "when_text" }, { "name": "user" }, 'userHidden', { "name": "summary" }, { "name": "event_type" }, 'event_typeHidden', { "type": "int", "name": "id" }, { "name": "modified" }, { "name": "created" }, { "name": "project" }, 'projectHidden', { "name": "build_time" }, { "name": "build_method" }, 'build_methodHidden', { "name": "owner_type" }, 'owner_typeHidden', { "name": "owner_id" }, 'owner_idHidden', { "type": "date", "name": "start_date", "dateFormat": "d.m.Y" }, { "name": "start_time" }, { "type": "date", "name": "end_date", "dateFormat": "d.m.Y" }, { "name": "end_time" }, { "name": "access_class" }, 'access_classHidden', { "type": "int", "name": "sequence" }, { "type": "int", "name": "auto_type" }, { "type": "boolean", "name": "transparent" }, { "name": "room" }, 'roomHidden', { "name": "priority" }, 'priorityHidden', { "name": "state" }, 'stateHidden', { "name": "assigned_to" }, 'assigned_toHidden', { "name": "owner" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 6,
  ls_grid_configs : [  ],
  content_type : 37,
  ls_id_property : "id",
  gc_name : 0,
  initComponent : function() {
    this.ls_detail_handler = Lino.cal.OneEvent.detail;
    this.ls_insert_handler = Lino.cal.OneEvent.insert;
    var ww = this.containing_window;
    var when_text_disp2821 = new Ext.form.DisplayField({ "disabled": true, "value": "<br/>", "always_enabled": true });
    var user2822 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "preferred_width": 15, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/OneEvent/user", "method": "GET" }) }), "pageSize": 20, "emptyText": "Benutzer ausw\u00e4hlen..." });
    var summary2823 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var event_type2824 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/OneEvent/event_type", "method": "GET" }) }), "pageSize": 20, "emptyText": "Ereignisart ausw\u00e4hlen..." });
    var id2825 = new Ext.form.NumberField({ "selectOnFocus": true });
    var modified2826 = new Ext.form.DisplayField({ "disabled": true, "value": "<br>" });
    var created2827 = new Ext.form.DisplayField({ "disabled": true, "value": "<br>" });
    var project2828 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "preferred_width": 20, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/OneEvent/project", "method": "GET" }) }), "pageSize": 20, "emptyText": "Klient ausw\u00e4hlen..." });
    var build_time2829 = new Ext.form.DisplayField({ "disabled": true, "value": "<br>" });
    var build_method2830 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "forceSelection": true, "allowBlank": false, "store": Lino.lino.BuildMethods });
    var owner_type2831 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/OneEvent/owner_type", "method": "GET" }) }), "pageSize": 20, "emptyText": "Datenbankmodell ausw\u00e4hlen..." });
    var owner_id2832 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/OneEvent/owner_id", "method": "GET" }) }) });
    var start_date2833 = new Lino.DateField({ "selectOnFocus": true });
    var start_time2834 = new Lino.TimeField({ "selectOnFocus": true });
    var end_date2835 = new Lino.DateField({ "selectOnFocus": true });
    var end_time2836 = new Lino.TimeField({ "selectOnFocus": true });
    var access_class2837 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "forceSelection": true, "store": [['','<br>']].concat(Lino.cal.AccessClasses) });
    var sequence2838 = new Ext.form.NumberField({ "selectOnFocus": true, "allowBlank": false, "value": 0 });
    var auto_type2839 = new Ext.form.NumberField({ "disabled": true });
    var transparent2840 = new Ext.form.Checkbox({ "selectOnFocus": true, "checked": false });
    var room2841 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/OneEvent/room", "method": "GET" }) }), "pageSize": 20, "emptyText": "Raum ausw\u00e4hlen..." });
    var priority2842 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/OneEvent/priority", "method": "GET" }) }), "pageSize": 20, "emptyText": "Priorit\u00e4t ausw\u00e4hlen..." });
    var state2843 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "forceSelection": true, "allowBlank": false, "store": Lino.cal.EventStates });
    var assigned_to2844 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "preferred_width": 15, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/OneEvent/assigned_to", "method": "GET" }) }), "pageSize": 20, "emptyText": "Benutzer ausw\u00e4hlen..." });
    var owner_disp2845 = new Ext.form.DisplayField({ "disabled": true });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ { "header": "Wann", "colIndex": 0, "sortable": false, "dataIndex": "when_text", "width": Lino.chars2width(21), "editable": false }, { "colIndex": 1, "sortable": true, "width": Lino.chars2width(21), "editable": true, "filter": { "type": "string" }, "header": "Verwaltet durch", "editor": user2822, "dataIndex": "user" }, { "colIndex": 2, "sortable": true, "width": Lino.chars2width(22), "editable": true, "filter": { "type": "string" }, "header": "Kurzbeschreibung", "editor": summary2823, "dataIndex": "summary" }, { "colIndex": 3, "sortable": true, "width": Lino.chars2width(21), "editable": true, "filter": { "type": "string" }, "header": "Ereignisart", "editor": event_type2824, "dataIndex": "event_type" }, new Lino.NullNumberColumn({ "colIndex": 4, "sortable": true, "format": "0", "editable": true, "filter": { "type": "numeric" }, "header": "ID", "editor": id2825, "hidden": true, "width": Lino.chars2width(6), "dataIndex": "id" }), { "header": "Bearbeitet", "colIndex": 5, "sortable": true, "dataIndex": "modified", "width": Lino.chars2width(17), "hidden": true, "editable": false }, { "header": "Erstellt", "colIndex": 6, "sortable": true, "dataIndex": "created", "width": Lino.chars2width(17), "hidden": true, "editable": false }, { "colIndex": 7, "sortable": true, "header": "Klient", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('projectHidden','Lino.pcsw.Clients.detail'), "dataIndex": "project", "hidden": true, "editor": project2828 }, { "header": "Druckdatum", "colIndex": 8, "sortable": true, "dataIndex": "build_time", "width": Lino.chars2width(17), "hidden": true, "editable": false }, { "colIndex": 9, "sortable": true, "header": "Konstruktionsmethode", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "editor": build_method2830, "hidden": true, "dataIndex": "build_method" }, { "colIndex": 10, "sortable": true, "header": "Verkn\u00fcpft mit (Modell)", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "editor": owner_type2831, "hidden": true, "dataIndex": "owner_type" }, { "colIndex": 11, "sortable": true, "header": "Verkn\u00fcpft mit (Objekt)", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(11), "editor": owner_id2832, "hidden": true, "dataIndex": "owner_id" }, { "colIndex": 12, "sortable": true, "xtype": "datecolumn", "format": "d.m.Y", "editable": true, "filter": { "type": "date", "dateFormat": "d.m.Y" }, "header": "Beginnt am", "editor": start_date2833, "hidden": true, "width": Lino.chars2width(14), "dataIndex": "start_date" }, { "colIndex": 13, "sortable": true, "width": Lino.chars2width(9), "editable": true, "header": "Beginnt um", "editor": start_time2834, "hidden": true, "dataIndex": "start_time" }, { "colIndex": 14, "sortable": true, "xtype": "datecolumn", "format": "d.m.Y", "editable": true, "filter": { "type": "date", "dateFormat": "d.m.Y" }, "header": "Endet am", "editor": end_date2835, "hidden": true, "width": Lino.chars2width(14), "dataIndex": "end_date" }, { "colIndex": 15, "sortable": true, "width": Lino.chars2width(9), "editable": true, "header": "Endet um", "editor": end_time2836, "hidden": true, "dataIndex": "end_time" }, { "colIndex": 16, "sortable": true, "header": "Zugriffsklasse", "editable": true, "tooltip": "Ob dieser Termin  privat, \u00f6ffentlich oder halb \u00f6ffentlich ist", "filter": { "type": "string" }, "width": Lino.chars2width(35), "editor": access_class2837, "hidden": true, "dataIndex": "access_class" }, new Lino.NullNumberColumn({ "colIndex": 17, "sortable": true, "format": "0", "editable": true, "filter": { "type": "numeric" }, "header": "Revisionsnummer", "editor": sequence2838, "hidden": true, "width": Lino.chars2width(6), "dataIndex": "sequence" }), new Lino.NullNumberColumn({ "colIndex": 18, "sortable": true, "format": "0", "editable": false, "filter": { "type": "numeric" }, "header": "auto type", "dataIndex": "auto_type", "hidden": true, "width": Lino.chars2width(6) }), { "colIndex": 19, "sortable": false, "xtype": "checkcolumn", "width": Lino.chars2width(11), "editable": true, "tooltip": "Dieser Termin l\u00e4sst auch andere Termine zur gleichen Zeit zu.", "filter": { "type": "boolean" }, "header": "nicht blockierend", "dataIndex": "transparent", "hidden": true }, { "colIndex": 20, "sortable": true, "header": "Raum", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "editor": room2841, "hidden": true, "dataIndex": "room" }, { "colIndex": 21, "sortable": true, "header": "Priorit\u00e4t", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "editor": priority2842, "hidden": true, "dataIndex": "priority" }, { "colIndex": 22, "sortable": true, "header": "Zustand", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(18), "editor": state2843, "hidden": true, "dataIndex": "state" }, { "colIndex": 23, "sortable": true, "header": "Zugewiesen zu", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "editor": assigned_to2844, "hidden": true, "dataIndex": "assigned_to" }, { "header": "Verkn\u00fcpft mit", "colIndex": 24, "sortable": false, "dataIndex": "owner", "width": Lino.chars2width(11), "hidden": true, "editable": false } ];
    Lino.cal.OneEvent.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.cal.OneEvent.show_as_html = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/cal/OneEvent", "GET", pk, "show_as_html", params, Lino.get_current_grid_config);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.cal.OneEvent.as_pdf = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/cal/OneEvent", "GET", pk, "as_pdf", params, Lino.get_current_grid_config);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.cal.OneEvent.as_pdf_p = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/cal/OneEvent", "GET", pk, "as_pdf_p", params, Lino.get_current_grid_config);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.cal.OneEvent.export_excel = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/cal/OneEvent", "GET", pk, "export_excel", params, Lino.get_current_grid_config);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.cal.OneEvent.submit_detail = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/cal/OneEvent", "GET", pk, "submit_detail", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};

Lino.cal.OneEvent.insertPanel = Ext.extend(Lino.cal.EventsByDay.InsertFormPanel,{
  empty_title: "Neu",
  hide_navigator: true,
  params_panel_hidden: true,
  save_action_name: "submit_insert",
  ls_bbar_actions: [ { "itemId": "submit_insert", "menu_item_text": "Erstellen", "tooltip": "Datensatz erstellen und dann im Detail-Fenster \u00f6ffnen", "panel_btn_handler": function(panel){panel.save()}, "text": "Erstellen", "overflowText": "Erstellen", "auto_save": false } ],
  ls_url: "/cal/OneEvent",
  action_name: "insert",
  initComponent : function() {
    this.ls_detail_handler = Lino.cal.OneEvent.detail;
    this.ls_insert_handler = Lino.cal.OneEvent.insert;
    Lino.cal.OneEvent.insertPanel.superclass.initComponent.call(this);
  }
});

Lino.cal.OneEvent.insert = new Lino.WindowAction({ "draggable": true, "width": Lino.chars2width(60), "autoHeight": true, "maximizable": true, "modal": true, "maximized": false }, function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.cal.OneEvent.insertPanel(p);
});
Lino.cal.OneEvent.grid_put = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/cal/OneEvent", "GET", pk, "grid_put", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.cal.OneEvent.grid_post = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/cal/OneEvent", "GET", pk, "grid_post", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.cal.OneEvent.wf1 = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/cal/OneEvent", "GET", pk, "wf1", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.cal.OneEvent.submit_insert = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/cal/OneEvent", "GET", pk, "submit_insert", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.cal.OneEvent.duplicate = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/cal/OneEvent", "GET", pk, "duplicate", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.cal.OneEvent.wf2 = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/cal/OneEvent", "GET", pk, "wf2", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.cal.OneEvent.wf3 = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/cal/OneEvent", "GET", pk, "wf3", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.cal.OneEvent.wf4 = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/cal/OneEvent", "GET", pk, "wf4", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};

Lino.cal.OneEvent.detailPanel = Ext.extend(Lino.cal.EventsByDay.DetailFormPanel,{
  empty_title: "Detail",
  params_panel_hidden: true,
  save_action_name: "submit_detail",
  ls_bbar_actions: [ { "itemId": "submit_detail", "menu_item_text": "Speichern", "tooltip": "\u00c4nderungen in diesem Formular speichern", "panel_btn_handler": function(panel){panel.save()}, "iconCls": "x-tbar-disk", "overflowText": "Speichern", "auto_save": false }, { "itemId": "insert", "menu_item_text": "Neu", "tooltip": "Neuen Datensatz erstellen", "panel_btn_handler": Lino.show_insert, "iconCls": "x-tbar-add", "overflowText": "Neu", "keycode": 44, "auto_save": true }, { "itemId": "duplicate", "menu_item_text": "Duplizieren", "tooltip": "Duplizieren", "panel_btn_handler": Lino.row_action_handler('duplicate','GET',null), "iconCls": "x-tbar-arrow_divide", "overflowText": "Duplizieren", "auto_save": true }, { "itemId": "delete_selected", "menu_item_text": "L\u00f6schen", "tooltip": "Diesen Datensatz l\u00f6schen", "panel_btn_handler": Lino.row_action_handler('delete_selected','GET',null), "iconCls": "x-tbar-delete", "overflowText": "L\u00f6schen", "keycode": 46, "auto_save": false }, { "itemId": "do_print", "menu_item_text": "Drucken", "tooltip": "Drucken", "panel_btn_handler": Lino.row_action_handler('do_print','POST',null), "iconCls": "x-tbar-printer", "overflowText": "Drucken", "auto_save": true }, { "itemId": "do_clear_cache", "menu_item_text": "Cache l\u00f6schen", "tooltip": "Cache l\u00f6schen", "panel_btn_handler": Lino.row_action_handler('do_clear_cache','GET',null), "iconCls": "x-tbar-printer_delete", "overflowText": "Cache l\u00f6schen", "auto_save": true }, { "itemId": "show_today", "menu_item_text": "Heute", "tooltip": "Show all calendar events of the same day.", "panel_btn_handler": Lino.row_action_handler('show_today','GET',null), "iconCls": "x-tbar-calendar", "overflowText": "Heute", "auto_save": true }, { "itemId": "move_next", "menu_item_text": "Nach unten", "tooltip": "Nach unten", "panel_btn_handler": Lino.row_action_handler('move_next','GET',null), "iconCls": "x-tbar-date_next", "overflowText": "Nach unten", "auto_save": true }, { "itemId": "create_mail", "menu_item_text": "per E-Mail", "tooltip": "Create an email from this", "panel_btn_handler": Lino.row_action_handler('create_mail','GET',null), "iconCls": "x-tbar-email_add", "overflowText": "per E-Mail", "auto_save": true }, { "itemId": "create_postings", "menu_item_text": "per Post", "tooltip": "Create classical mail postings from this", "panel_btn_handler": Lino.row_action_handler('create_postings','GET',null), "iconCls": "x-tbar-script_add", "overflowText": "per Post", "auto_save": true }, { "itemId": "do_update_guests", "menu_item_text": "Update Guests", "tooltip": "Update Guests", "panel_btn_handler": Lino.row_action_handler('do_update_guests','GET',null), "iconCls": "x-tbar-lightning", "overflowText": "Update Guests", "auto_save": true }, { "itemId": "take", "menu_item_text": "Annehmen", "tooltip": "Verantwortung f\u00fcr diesen Termin \u00fcbernehmen.", "panel_btn_handler": Lino.row_action_handler('take','GET',null), "iconCls": "x-tbar-flag_green", "overflowText": "Annehmen", "auto_save": true } ],
  ls_url: "/cal/OneEvent",
  action_name: "detail",
  initComponent : function() {
    this.ls_detail_handler = Lino.cal.OneEvent.detail;
    this.ls_insert_handler = Lino.cal.OneEvent.insert;
    Lino.cal.OneEvent.detailPanel.superclass.initComponent.call(this);
  }
});

Lino.cal.OneEvent.detail = new Lino.WindowAction({  }, function(){
  var p = { "is_main_window": true };
  return new Lino.cal.OneEvent.detailPanel(p);
});
Lino.cal.OneEvent.delete_selected = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/cal/OneEvent", "GET", pk, "delete_selected", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.cal.OneEvent.do_print = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/cal/OneEvent", "POST", pk, "do_print", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.cal.OneEvent.do_clear_cache = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/cal/OneEvent", "GET", pk, "do_clear_cache", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.cal.OneEvent.edit_template = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/cal/OneEvent", "GET", pk, "edit_template", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.cal.OneEvent.show_today = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/cal/OneEvent", "GET", pk, "show_today", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.cal.OneEvent.grid = new Lino.WindowAction({  }, function(){
  var p = { "is_main_window": true };
  p.params_panel = new Lino.cal.EventsByDay.ParamsPanel({});
  return new Lino.cal.OneEvent.GridPanel(p);
});
Lino.cal.OneEvent.validate = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/cal/OneEvent", "GET", pk, "validate", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.cal.OneEvent.move_next = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/cal/OneEvent", "GET", pk, "move_next", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.cal.OneEvent.create_mail = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/cal/OneEvent", "GET", pk, "create_mail", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.cal.OneEvent.create_postings = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/cal/OneEvent", "GET", pk, "create_postings", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.cal.OneEvent.do_update_guests = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/cal/OneEvent", "GET", pk, "do_update_guests", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.cal.OneEvent.take = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/cal/OneEvent", "GET", pk, "take", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};

// js_render_GridPanel_class cal.MyEvents
Lino.cal.MyEvents.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "forceFit": true, "emptyText": "Keine Daten anzuzeigen." },
  ls_url : "/cal/MyEvents",
  ls_bbar_actions : [ { "itemId": "show_as_html", "menu_item_text": "HTML", "tooltip": "Show this table in Bootstrap3 interface", "panel_btn_handler": Lino.list_action_handler('/cal/MyEvents','show_as_html','GET',Lino.get_current_grid_config), "iconCls": "x-tbar-html", "overflowText": "HTML", "auto_save": true }, { "panel_btn_handler": Lino.list_action_handler('/cal/MyEvents','as_pdf','GET',Lino.get_current_grid_config), "xtype": "splitbutton", "text": null, "menu": [ { "itemId": "as_pdf", "menu_item_text": "Tabelle (Querformat)", "tooltip": "Diese Tabelle in eine .pdf-Datei exportieren", "panel_btn_handler": Lino.list_action_handler('/cal/MyEvents','as_pdf','GET',Lino.get_current_grid_config), "text": "Tabelle (Querformat)", "overflowText": "Tabelle (Querformat)", "auto_save": true }, { "itemId": "as_pdf_p", "menu_item_text": "Tabelle (Hochformat)", "tooltip": "Diese Tabelle in eine .pdf-Datei exportieren", "panel_btn_handler": Lino.list_action_handler('/cal/MyEvents','as_pdf_p','GET',Lino.get_current_grid_config), "text": "Tabelle (Hochformat)", "overflowText": "Tabelle (Hochformat)", "auto_save": true } ], "iconCls": "x-tbar-pdf", "menu_item_text": "Tabelle (Querformat)" }, { "itemId": "export_excel", "menu_item_text": "Export to .xls", "tooltip": "Export this table as an .xls document", "panel_btn_handler": Lino.list_action_handler('/cal/MyEvents','export_excel','GET',Lino.get_current_grid_config), "iconCls": "x-tbar-csv", "overflowText": "Export to .xls", "auto_save": true }, { "itemId": "insert", "menu_item_text": "Neu", "tooltip": "Neuen Datensatz erstellen", "panel_btn_handler": Lino.show_insert, "iconCls": "x-tbar-add", "overflowText": "Neu", "keycode": 44, "auto_save": true }, { "itemId": "duplicate", "menu_item_text": "Duplizieren", "tooltip": "Duplizieren", "panel_btn_handler": Lino.row_action_handler('duplicate','GET',null), "iconCls": "x-tbar-arrow_divide", "overflowText": "Duplizieren", "auto_save": true }, { "itemId": "detail", "menu_item_text": "Detail", "tooltip": "Detail-Fenster auf diesem Datensatz \u00f6ffnen", "panel_btn_handler": Lino.show_detail, "iconCls": "x-tbar-application_form", "overflowText": "Detail", "auto_save": true }, { "itemId": "delete_selected", "menu_item_text": "L\u00f6schen", "tooltip": "Diesen Datensatz l\u00f6schen", "panel_btn_handler": Lino.row_action_handler('delete_selected','GET',null), "iconCls": "x-tbar-delete", "overflowText": "L\u00f6schen", "keycode": 46, "auto_save": false }, { "itemId": "do_print", "menu_item_text": "Drucken", "tooltip": "Drucken", "panel_btn_handler": Lino.row_action_handler('do_print','POST',null), "iconCls": "x-tbar-printer", "overflowText": "Drucken", "auto_save": true }, { "itemId": "do_clear_cache", "menu_item_text": "Cache l\u00f6schen", "tooltip": "Cache l\u00f6schen", "panel_btn_handler": Lino.row_action_handler('do_clear_cache','GET',null), "iconCls": "x-tbar-printer_delete", "overflowText": "Cache l\u00f6schen", "auto_save": true }, { "itemId": "show_today", "menu_item_text": "Heute", "tooltip": "Show all calendar events of the same day.", "panel_btn_handler": Lino.row_action_handler('show_today','GET',null), "iconCls": "x-tbar-calendar", "overflowText": "Heute", "auto_save": true }, { "itemId": "create_postings", "menu_item_text": "per Post", "tooltip": "Create classical mail postings from this", "panel_btn_handler": Lino.row_action_handler('create_postings','GET',null), "iconCls": "x-tbar-script_add", "overflowText": "per Post", "auto_save": true }, { "itemId": "do_update_guests", "menu_item_text": "Update Guests", "tooltip": "Update Guests", "panel_btn_handler": Lino.row_action_handler('do_update_guests','GET',null), "iconCls": "x-tbar-lightning", "overflowText": "Update Guests", "auto_save": true }, { "itemId": "take", "menu_item_text": "Annehmen", "tooltip": "Verantwortung f\u00fcr diesen Termin \u00fcbernehmen.", "panel_btn_handler": Lino.row_action_handler('take','GET',null), "iconCls": "x-tbar-flag_green", "overflowText": "Annehmen", "auto_save": true }, { "itemId": "move_next", "menu_item_text": "Nach unten", "tooltip": "Nach unten", "panel_btn_handler": Lino.row_action_handler('move_next','GET',null), "iconCls": "x-tbar-date_next", "overflowText": "Nach unten", "auto_save": true }, { "itemId": "create_mail", "menu_item_text": "per E-Mail", "tooltip": "Create an email from this", "panel_btn_handler": Lino.row_action_handler('create_mail','GET',null), "iconCls": "x-tbar-email_add", "overflowText": "per E-Mail", "auto_save": true } ],
  cell_edit : true,
  title : "Meine Termine",
  page_length : 20,
  params_panel_hidden : true,
  stripeRows : true,
  disabled_actions_index : 38,
  ls_store_fields : [ { "name": "when_text" }, { "name": "project" }, 'projectHidden', { "name": "summary" }, { "name": "workflow_buttons" }, { "type": "int", "name": "id" }, { "name": "user" }, 'userHidden', { "name": "modified" }, { "name": "created" }, { "name": "build_time" }, { "name": "build_method" }, 'build_methodHidden', { "name": "owner_type" }, 'owner_typeHidden', { "name": "owner_id" }, 'owner_idHidden', { "type": "date", "name": "start_date", "dateFormat": "d.m.Y" }, { "name": "start_time" }, { "type": "date", "name": "end_date", "dateFormat": "d.m.Y" }, { "name": "end_time" }, { "name": "access_class" }, 'access_classHidden', { "type": "int", "name": "sequence" }, { "type": "int", "name": "auto_type" }, { "name": "event_type" }, 'event_typeHidden', { "type": "boolean", "name": "transparent" }, { "name": "room" }, 'roomHidden', { "name": "priority" }, 'priorityHidden', { "name": "state" }, 'stateHidden', { "name": "assigned_to" }, 'assigned_toHidden', { "name": "owner" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 5,
  ls_grid_configs : [  ],
  content_type : 37,
  ls_id_property : "id",
  gc_name : 0,
  initComponent : function() {
    this.ls_detail_handler = Lino.cal.MyEvents.detail;
    this.ls_insert_handler = Lino.cal.MyEvents.insert;
    var ww = this.containing_window;
    var when_text_disp2847 = new Ext.form.DisplayField({ "disabled": true, "value": "<br/>", "always_enabled": true });
    var project2848 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "preferred_width": 20, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/MyEvents/project", "method": "GET" }) }), "pageSize": 20, "emptyText": "Klient ausw\u00e4hlen..." });
    var summary2849 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var workflow_buttons_disp2850 = new Ext.form.DisplayField({ "disabled": true, "value": "<br/>", "always_enabled": true });
    var id2851 = new Ext.form.NumberField({ "selectOnFocus": true });
    var user2852 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "preferred_width": 15, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/MyEvents/user", "method": "GET" }) }), "pageSize": 20, "emptyText": "Benutzer ausw\u00e4hlen..." });
    var modified2853 = new Ext.form.DisplayField({ "disabled": true, "value": "<br>" });
    var created2854 = new Ext.form.DisplayField({ "disabled": true, "value": "<br>" });
    var build_time2855 = new Ext.form.DisplayField({ "disabled": true, "value": "<br>" });
    var build_method2856 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "forceSelection": true, "allowBlank": false, "store": Lino.lino.BuildMethods });
    var owner_type2857 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/MyEvents/owner_type", "method": "GET" }) }), "pageSize": 20, "emptyText": "Datenbankmodell ausw\u00e4hlen..." });
    var owner_id2858 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/MyEvents/owner_id", "method": "GET" }) }) });
    var start_date2859 = new Lino.DateField({ "selectOnFocus": true });
    var start_time2860 = new Lino.TimeField({ "selectOnFocus": true });
    var end_date2861 = new Lino.DateField({ "selectOnFocus": true });
    var end_time2862 = new Lino.TimeField({ "selectOnFocus": true });
    var access_class2863 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "forceSelection": true, "store": [['','<br>']].concat(Lino.cal.AccessClasses) });
    var sequence2864 = new Ext.form.NumberField({ "selectOnFocus": true, "allowBlank": false, "value": 0 });
    var auto_type2865 = new Ext.form.NumberField({ "disabled": true });
    var event_type2866 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/MyEvents/event_type", "method": "GET" }) }), "pageSize": 20, "emptyText": "Ereignisart ausw\u00e4hlen..." });
    var transparent2867 = new Ext.form.Checkbox({ "selectOnFocus": true, "checked": false });
    var room2868 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/MyEvents/room", "method": "GET" }) }), "pageSize": 20, "emptyText": "Raum ausw\u00e4hlen..." });
    var priority2869 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/MyEvents/priority", "method": "GET" }) }), "pageSize": 20, "emptyText": "Priorit\u00e4t ausw\u00e4hlen..." });
    var state2870 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "forceSelection": true, "allowBlank": false, "store": Lino.cal.EventStates });
    var assigned_to2871 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "preferred_width": 15, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/MyEvents/assigned_to", "method": "GET" }) }), "pageSize": 20, "emptyText": "Benutzer ausw\u00e4hlen..." });
    var owner_disp2872 = new Ext.form.DisplayField({ "disabled": true });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ { "header": "Wann", "colIndex": 0, "sortable": false, "dataIndex": "when_text", "width": Lino.chars2width(31), "editable": false }, { "colIndex": 1, "sortable": true, "header": "Klient", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('projectHidden','Lino.pcsw.Clients.detail'), "dataIndex": "project", "editor": project2848 }, { "colIndex": 2, "sortable": true, "width": Lino.chars2width(22), "editable": true, "filter": { "type": "string" }, "header": "Kurzbeschreibung", "editor": summary2849, "dataIndex": "summary" }, { "header": "Arbeitsablauf", "colIndex": 3, "sortable": false, "dataIndex": "workflow_buttons", "width": Lino.chars2width(31), "editable": false }, new Lino.NullNumberColumn({ "colIndex": 4, "sortable": true, "format": "0", "editable": true, "filter": { "type": "numeric" }, "header": "ID", "editor": id2851, "hidden": true, "width": Lino.chars2width(6), "dataIndex": "id" }), { "colIndex": 5, "sortable": true, "header": "Verwaltet durch", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "editor": user2852, "hidden": true, "dataIndex": "user" }, { "header": "Bearbeitet", "colIndex": 6, "sortable": true, "dataIndex": "modified", "width": Lino.chars2width(17), "hidden": true, "editable": false }, { "header": "Erstellt", "colIndex": 7, "sortable": true, "dataIndex": "created", "width": Lino.chars2width(17), "hidden": true, "editable": false }, { "header": "Druckdatum", "colIndex": 8, "sortable": true, "dataIndex": "build_time", "width": Lino.chars2width(17), "hidden": true, "editable": false }, { "colIndex": 9, "sortable": true, "header": "Konstruktionsmethode", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "editor": build_method2856, "hidden": true, "dataIndex": "build_method" }, { "colIndex": 10, "sortable": true, "header": "Verkn\u00fcpft mit (Modell)", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "editor": owner_type2857, "hidden": true, "dataIndex": "owner_type" }, { "colIndex": 11, "sortable": true, "header": "Verkn\u00fcpft mit (Objekt)", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(11), "editor": owner_id2858, "hidden": true, "dataIndex": "owner_id" }, { "colIndex": 12, "sortable": true, "xtype": "datecolumn", "format": "d.m.Y", "editable": true, "filter": { "type": "date", "dateFormat": "d.m.Y" }, "header": "Beginnt am", "editor": start_date2859, "hidden": true, "width": Lino.chars2width(14), "dataIndex": "start_date" }, { "colIndex": 13, "sortable": true, "width": Lino.chars2width(9), "editable": true, "header": "Beginnt um", "editor": start_time2860, "hidden": true, "dataIndex": "start_time" }, { "colIndex": 14, "sortable": true, "xtype": "datecolumn", "format": "d.m.Y", "editable": true, "filter": { "type": "date", "dateFormat": "d.m.Y" }, "header": "Endet am", "editor": end_date2861, "hidden": true, "width": Lino.chars2width(14), "dataIndex": "end_date" }, { "colIndex": 15, "sortable": true, "width": Lino.chars2width(9), "editable": true, "header": "Endet um", "editor": end_time2862, "hidden": true, "dataIndex": "end_time" }, { "colIndex": 16, "sortable": true, "header": "Zugriffsklasse", "editable": true, "tooltip": "Ob dieser Termin  privat, \u00f6ffentlich oder halb \u00f6ffentlich ist", "filter": { "type": "string" }, "width": Lino.chars2width(35), "editor": access_class2863, "hidden": true, "dataIndex": "access_class" }, new Lino.NullNumberColumn({ "colIndex": 17, "sortable": true, "format": "0", "editable": true, "filter": { "type": "numeric" }, "header": "Revisionsnummer", "editor": sequence2864, "hidden": true, "width": Lino.chars2width(6), "dataIndex": "sequence" }), new Lino.NullNumberColumn({ "colIndex": 18, "sortable": true, "format": "0", "editable": false, "filter": { "type": "numeric" }, "header": "auto type", "dataIndex": "auto_type", "hidden": true, "width": Lino.chars2width(6) }), { "colIndex": 19, "sortable": true, "header": "Ereignisart", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "editor": event_type2866, "hidden": true, "dataIndex": "event_type" }, { "colIndex": 20, "sortable": false, "xtype": "checkcolumn", "width": Lino.chars2width(11), "editable": true, "tooltip": "Dieser Termin l\u00e4sst auch andere Termine zur gleichen Zeit zu.", "filter": { "type": "boolean" }, "header": "nicht blockierend", "dataIndex": "transparent", "hidden": true }, { "colIndex": 21, "sortable": true, "header": "Raum", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "editor": room2868, "hidden": true, "dataIndex": "room" }, { "colIndex": 22, "sortable": true, "header": "Priorit\u00e4t", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "editor": priority2869, "hidden": true, "dataIndex": "priority" }, { "colIndex": 23, "sortable": true, "header": "Zustand", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(18), "editor": state2870, "hidden": true, "dataIndex": "state" }, { "colIndex": 24, "sortable": true, "header": "Zugewiesen zu", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "editor": assigned_to2871, "hidden": true, "dataIndex": "assigned_to" }, { "header": "Verkn\u00fcpft mit", "colIndex": 25, "sortable": false, "dataIndex": "owner", "width": Lino.chars2width(11), "hidden": true, "editable": false } ];
    Lino.cal.MyEvents.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.cal.MyEvents.show_as_html = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/cal/MyEvents", "GET", pk, "show_as_html", params, Lino.get_current_grid_config);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.cal.MyEvents.as_pdf = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/cal/MyEvents", "GET", pk, "as_pdf", params, Lino.get_current_grid_config);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.cal.MyEvents.as_pdf_p = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/cal/MyEvents", "GET", pk, "as_pdf_p", params, Lino.get_current_grid_config);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.cal.MyEvents.export_excel = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/cal/MyEvents", "GET", pk, "export_excel", params, Lino.get_current_grid_config);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.cal.MyEvents.submit_detail = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/cal/MyEvents", "GET", pk, "submit_detail", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};

Lino.cal.MyEvents.insertPanel = Ext.extend(Lino.cal.EventsByDay.InsertFormPanel,{
  empty_title: "Neu",
  hide_navigator: true,
  params_panel_hidden: true,
  save_action_name: "submit_insert",
  ls_bbar_actions: [ { "itemId": "submit_insert", "menu_item_text": "Erstellen", "tooltip": "Datensatz erstellen und dann im Detail-Fenster \u00f6ffnen", "panel_btn_handler": function(panel){panel.save()}, "text": "Erstellen", "overflowText": "Erstellen", "auto_save": false } ],
  ls_url: "/cal/MyEvents",
  action_name: "insert",
  initComponent : function() {
    this.ls_detail_handler = Lino.cal.MyEvents.detail;
    this.ls_insert_handler = Lino.cal.MyEvents.insert;
    Lino.cal.MyEvents.insertPanel.superclass.initComponent.call(this);
  }
});

Lino.cal.MyEvents.insert = new Lino.WindowAction({ "draggable": true, "width": Lino.chars2width(60), "autoHeight": true, "maximizable": true, "modal": true, "maximized": false }, function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.cal.MyEvents.insertPanel(p);
});
Lino.cal.MyEvents.grid_put = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/cal/MyEvents", "GET", pk, "grid_put", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.cal.MyEvents.grid_post = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/cal/MyEvents", "GET", pk, "grid_post", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.cal.MyEvents.submit_insert = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/cal/MyEvents", "GET", pk, "submit_insert", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.cal.MyEvents.wf1 = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/cal/MyEvents", "GET", pk, "wf1", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.cal.MyEvents.duplicate = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/cal/MyEvents", "GET", pk, "duplicate", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.cal.MyEvents.wf2 = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/cal/MyEvents", "GET", pk, "wf2", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.cal.MyEvents.wf3 = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/cal/MyEvents", "GET", pk, "wf3", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.cal.MyEvents.wf4 = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/cal/MyEvents", "GET", pk, "wf4", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};

Lino.cal.MyEvents.detailPanel = Ext.extend(Lino.cal.EventsByDay.DetailFormPanel,{
  empty_title: "Detail",
  params_panel_hidden: true,
  save_action_name: "submit_detail",
  ls_bbar_actions: [ { "itemId": "submit_detail", "menu_item_text": "Speichern", "tooltip": "\u00c4nderungen in diesem Formular speichern", "panel_btn_handler": function(panel){panel.save()}, "iconCls": "x-tbar-disk", "overflowText": "Speichern", "auto_save": false }, { "itemId": "insert", "menu_item_text": "Neu", "tooltip": "Neuen Datensatz erstellen", "panel_btn_handler": Lino.show_insert, "iconCls": "x-tbar-add", "overflowText": "Neu", "keycode": 44, "auto_save": true }, { "itemId": "duplicate", "menu_item_text": "Duplizieren", "tooltip": "Duplizieren", "panel_btn_handler": Lino.row_action_handler('duplicate','GET',null), "iconCls": "x-tbar-arrow_divide", "overflowText": "Duplizieren", "auto_save": true }, { "itemId": "delete_selected", "menu_item_text": "L\u00f6schen", "tooltip": "Diesen Datensatz l\u00f6schen", "panel_btn_handler": Lino.row_action_handler('delete_selected','GET',null), "iconCls": "x-tbar-delete", "overflowText": "L\u00f6schen", "keycode": 46, "auto_save": false }, { "itemId": "do_print", "menu_item_text": "Drucken", "tooltip": "Drucken", "panel_btn_handler": Lino.row_action_handler('do_print','POST',null), "iconCls": "x-tbar-printer", "overflowText": "Drucken", "auto_save": true }, { "itemId": "do_clear_cache", "menu_item_text": "Cache l\u00f6schen", "tooltip": "Cache l\u00f6schen", "panel_btn_handler": Lino.row_action_handler('do_clear_cache','GET',null), "iconCls": "x-tbar-printer_delete", "overflowText": "Cache l\u00f6schen", "auto_save": true }, { "itemId": "show_today", "menu_item_text": "Heute", "tooltip": "Show all calendar events of the same day.", "panel_btn_handler": Lino.row_action_handler('show_today','GET',null), "iconCls": "x-tbar-calendar", "overflowText": "Heute", "auto_save": true }, { "itemId": "create_postings", "menu_item_text": "per Post", "tooltip": "Create classical mail postings from this", "panel_btn_handler": Lino.row_action_handler('create_postings','GET',null), "iconCls": "x-tbar-script_add", "overflowText": "per Post", "auto_save": true }, { "itemId": "do_update_guests", "menu_item_text": "Update Guests", "tooltip": "Update Guests", "panel_btn_handler": Lino.row_action_handler('do_update_guests','GET',null), "iconCls": "x-tbar-lightning", "overflowText": "Update Guests", "auto_save": true }, { "itemId": "take", "menu_item_text": "Annehmen", "tooltip": "Verantwortung f\u00fcr diesen Termin \u00fcbernehmen.", "panel_btn_handler": Lino.row_action_handler('take','GET',null), "iconCls": "x-tbar-flag_green", "overflowText": "Annehmen", "auto_save": true }, { "itemId": "move_next", "menu_item_text": "Nach unten", "tooltip": "Nach unten", "panel_btn_handler": Lino.row_action_handler('move_next','GET',null), "iconCls": "x-tbar-date_next", "overflowText": "Nach unten", "auto_save": true }, { "itemId": "create_mail", "menu_item_text": "per E-Mail", "tooltip": "Create an email from this", "panel_btn_handler": Lino.row_action_handler('create_mail','GET',null), "iconCls": "x-tbar-email_add", "overflowText": "per E-Mail", "auto_save": true } ],
  ls_url: "/cal/MyEvents",
  action_name: "detail",
  initComponent : function() {
    this.ls_detail_handler = Lino.cal.MyEvents.detail;
    this.ls_insert_handler = Lino.cal.MyEvents.insert;
    Lino.cal.MyEvents.detailPanel.superclass.initComponent.call(this);
  }
});

Lino.cal.MyEvents.detail = new Lino.WindowAction({  }, function(){
  var p = { "is_main_window": true };
  return new Lino.cal.MyEvents.detailPanel(p);
});
Lino.cal.MyEvents.delete_selected = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/cal/MyEvents", "GET", pk, "delete_selected", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.cal.MyEvents.do_print = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/cal/MyEvents", "POST", pk, "do_print", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.cal.MyEvents.do_clear_cache = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/cal/MyEvents", "GET", pk, "do_clear_cache", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.cal.MyEvents.edit_template = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/cal/MyEvents", "GET", pk, "edit_template", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.cal.MyEvents.show_today = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/cal/MyEvents", "GET", pk, "show_today", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.cal.MyEvents.grid = new Lino.WindowAction({  }, function(){
  var p = { "is_main_window": true };
  p.params_panel = new Lino.cal.EventsByDay.ParamsPanel({});
  return new Lino.cal.MyEvents.GridPanel(p);
});
Lino.cal.MyEvents.validate = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/cal/MyEvents", "GET", pk, "validate", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.cal.MyEvents.create_postings = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/cal/MyEvents", "GET", pk, "create_postings", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.cal.MyEvents.do_update_guests = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/cal/MyEvents", "GET", pk, "do_update_guests", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.cal.MyEvents.take = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/cal/MyEvents", "GET", pk, "take", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.cal.MyEvents.move_next = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/cal/MyEvents", "GET", pk, "move_next", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.cal.MyEvents.create_mail = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/cal/MyEvents", "GET", pk, "create_mail", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};

// js_render_GridPanel_class cal.MyAssignedEvents
Lino.cal.MyAssignedEvents.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "forceFit": true, "emptyText": "Keine Daten anzuzeigen." },
  ls_url : "/cal/MyAssignedEvents",
  ls_bbar_actions : [ { "itemId": "show_as_html", "menu_item_text": "HTML", "tooltip": "Show this table in Bootstrap3 interface", "panel_btn_handler": Lino.list_action_handler('/cal/MyAssignedEvents','show_as_html','GET',Lino.get_current_grid_config), "iconCls": "x-tbar-html", "overflowText": "HTML", "auto_save": true }, { "panel_btn_handler": Lino.list_action_handler('/cal/MyAssignedEvents','as_pdf','GET',Lino.get_current_grid_config), "xtype": "splitbutton", "text": null, "menu": [ { "itemId": "as_pdf", "menu_item_text": "Tabelle (Querformat)", "tooltip": "Diese Tabelle in eine .pdf-Datei exportieren", "panel_btn_handler": Lino.list_action_handler('/cal/MyAssignedEvents','as_pdf','GET',Lino.get_current_grid_config), "text": "Tabelle (Querformat)", "overflowText": "Tabelle (Querformat)", "auto_save": true }, { "itemId": "as_pdf_p", "menu_item_text": "Tabelle (Hochformat)", "tooltip": "Diese Tabelle in eine .pdf-Datei exportieren", "panel_btn_handler": Lino.list_action_handler('/cal/MyAssignedEvents','as_pdf_p','GET',Lino.get_current_grid_config), "text": "Tabelle (Hochformat)", "overflowText": "Tabelle (Hochformat)", "auto_save": true } ], "iconCls": "x-tbar-pdf", "menu_item_text": "Tabelle (Querformat)" }, { "itemId": "export_excel", "menu_item_text": "Export to .xls", "tooltip": "Export this table as an .xls document", "panel_btn_handler": Lino.list_action_handler('/cal/MyAssignedEvents','export_excel','GET',Lino.get_current_grid_config), "iconCls": "x-tbar-csv", "overflowText": "Export to .xls", "auto_save": true }, { "itemId": "insert", "menu_item_text": "Neu", "tooltip": "Neuen Datensatz erstellen", "panel_btn_handler": Lino.show_insert, "iconCls": "x-tbar-add", "overflowText": "Neu", "keycode": 44, "auto_save": true }, { "itemId": "duplicate", "menu_item_text": "Duplizieren", "tooltip": "Duplizieren", "panel_btn_handler": Lino.row_action_handler('duplicate','GET',null), "iconCls": "x-tbar-arrow_divide", "overflowText": "Duplizieren", "auto_save": true }, { "itemId": "detail", "menu_item_text": "Detail", "tooltip": "Detail-Fenster auf diesem Datensatz \u00f6ffnen", "panel_btn_handler": Lino.show_detail, "iconCls": "x-tbar-application_form", "overflowText": "Detail", "auto_save": true }, { "itemId": "delete_selected", "menu_item_text": "L\u00f6schen", "tooltip": "Diesen Datensatz l\u00f6schen", "panel_btn_handler": Lino.row_action_handler('delete_selected','GET',null), "iconCls": "x-tbar-delete", "overflowText": "L\u00f6schen", "keycode": 46, "auto_save": false }, { "itemId": "do_print", "menu_item_text": "Drucken", "tooltip": "Drucken", "panel_btn_handler": Lino.row_action_handler('do_print','POST',null), "iconCls": "x-tbar-printer", "overflowText": "Drucken", "auto_save": true }, { "itemId": "do_clear_cache", "menu_item_text": "Cache l\u00f6schen", "tooltip": "Cache l\u00f6schen", "panel_btn_handler": Lino.row_action_handler('do_clear_cache','GET',null), "iconCls": "x-tbar-printer_delete", "overflowText": "Cache l\u00f6schen", "auto_save": true }, { "itemId": "show_today", "menu_item_text": "Heute", "tooltip": "Show all calendar events of the same day.", "panel_btn_handler": Lino.row_action_handler('show_today','GET',null), "iconCls": "x-tbar-calendar", "overflowText": "Heute", "auto_save": true }, { "itemId": "create_postings", "menu_item_text": "per Post", "tooltip": "Create classical mail postings from this", "panel_btn_handler": Lino.row_action_handler('create_postings','GET',null), "iconCls": "x-tbar-script_add", "overflowText": "per Post", "auto_save": true }, { "itemId": "do_update_guests", "menu_item_text": "Update Guests", "tooltip": "Update Guests", "panel_btn_handler": Lino.row_action_handler('do_update_guests','GET',null), "iconCls": "x-tbar-lightning", "overflowText": "Update Guests", "auto_save": true }, { "itemId": "take", "menu_item_text": "Annehmen", "tooltip": "Verantwortung f\u00fcr diesen Termin \u00fcbernehmen.", "panel_btn_handler": Lino.row_action_handler('take','GET',null), "iconCls": "x-tbar-flag_green", "overflowText": "Annehmen", "auto_save": true }, { "itemId": "move_next", "menu_item_text": "Nach unten", "tooltip": "Nach unten", "panel_btn_handler": Lino.row_action_handler('move_next','GET',null), "iconCls": "x-tbar-date_next", "overflowText": "Nach unten", "auto_save": true }, { "itemId": "create_mail", "menu_item_text": "per E-Mail", "tooltip": "Create an email from this", "panel_btn_handler": Lino.row_action_handler('create_mail','GET',null), "iconCls": "x-tbar-email_add", "overflowText": "per E-Mail", "auto_save": true } ],
  cell_edit : true,
  title : "Events assigned to me",
  page_length : 20,
  params_panel_hidden : true,
  stripeRows : true,
  disabled_actions_index : 38,
  ls_store_fields : [ { "name": "when_text" }, { "name": "project" }, 'projectHidden', { "name": "summary" }, { "name": "workflow_buttons" }, { "type": "int", "name": "id" }, { "name": "user" }, 'userHidden', { "name": "modified" }, { "name": "created" }, { "name": "build_time" }, { "name": "build_method" }, 'build_methodHidden', { "name": "owner_type" }, 'owner_typeHidden', { "name": "owner_id" }, 'owner_idHidden', { "type": "date", "name": "start_date", "dateFormat": "d.m.Y" }, { "name": "start_time" }, { "type": "date", "name": "end_date", "dateFormat": "d.m.Y" }, { "name": "end_time" }, { "name": "access_class" }, 'access_classHidden', { "type": "int", "name": "sequence" }, { "type": "int", "name": "auto_type" }, { "name": "event_type" }, 'event_typeHidden', { "type": "boolean", "name": "transparent" }, { "name": "room" }, 'roomHidden', { "name": "priority" }, 'priorityHidden', { "name": "state" }, 'stateHidden', { "name": "assigned_to" }, 'assigned_toHidden', { "name": "owner" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 5,
  ls_grid_configs : [  ],
  content_type : 37,
  ls_id_property : "id",
  gc_name : 0,
  initComponent : function() {
    this.ls_detail_handler = Lino.cal.MyAssignedEvents.detail;
    this.ls_insert_handler = Lino.cal.MyAssignedEvents.insert;
    var ww = this.containing_window;
    var when_text_disp244 = new Ext.form.DisplayField({ "disabled": true, "value": "<br/>", "always_enabled": true });
    var project245 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "preferred_width": 20, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/MyAssignedEvents/project", "method": "GET" }) }), "pageSize": 20, "emptyText": "Klient ausw\u00e4hlen..." });
    var summary246 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var workflow_buttons_disp247 = new Ext.form.DisplayField({ "disabled": true, "value": "<br/>", "always_enabled": true });
    var id248 = new Ext.form.NumberField({ "selectOnFocus": true });
    var user249 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "preferred_width": 15, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/MyAssignedEvents/user", "method": "GET" }) }), "pageSize": 20, "emptyText": "Benutzer ausw\u00e4hlen..." });
    var modified250 = new Ext.form.DisplayField({ "disabled": true, "value": "<br>" });
    var created251 = new Ext.form.DisplayField({ "disabled": true, "value": "<br>" });
    var build_time252 = new Ext.form.DisplayField({ "disabled": true, "value": "<br>" });
    var build_method253 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "forceSelection": true, "allowBlank": false, "store": Lino.lino.BuildMethods });
    var owner_type254 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/MyAssignedEvents/owner_type", "method": "GET" }) }), "pageSize": 20, "emptyText": "Datenbankmodell ausw\u00e4hlen..." });
    var owner_id255 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/MyAssignedEvents/owner_id", "method": "GET" }) }) });
    var start_date256 = new Lino.DateField({ "selectOnFocus": true });
    var start_time257 = new Lino.TimeField({ "selectOnFocus": true });
    var end_date258 = new Lino.DateField({ "selectOnFocus": true });
    var end_time259 = new Lino.TimeField({ "selectOnFocus": true });
    var access_class260 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "forceSelection": true, "store": [['','<br>']].concat(Lino.cal.AccessClasses) });
    var sequence261 = new Ext.form.NumberField({ "selectOnFocus": true, "allowBlank": false, "value": 0 });
    var auto_type262 = new Ext.form.NumberField({ "disabled": true });
    var event_type263 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/MyAssignedEvents/event_type", "method": "GET" }) }), "pageSize": 20, "emptyText": "Ereignisart ausw\u00e4hlen..." });
    var transparent264 = new Ext.form.Checkbox({ "selectOnFocus": true, "checked": false });
    var room265 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/MyAssignedEvents/room", "method": "GET" }) }), "pageSize": 20, "emptyText": "Raum ausw\u00e4hlen..." });
    var priority266 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/MyAssignedEvents/priority", "method": "GET" }) }), "pageSize": 20, "emptyText": "Priorit\u00e4t ausw\u00e4hlen..." });
    var state267 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "forceSelection": true, "allowBlank": false, "store": Lino.cal.EventStates });
    var assigned_to268 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "preferred_width": 15, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/MyAssignedEvents/assigned_to", "method": "GET" }) }), "pageSize": 20, "emptyText": "Benutzer ausw\u00e4hlen..." });
    var owner_disp269 = new Ext.form.DisplayField({ "disabled": true });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ { "header": "Wann", "colIndex": 0, "sortable": false, "dataIndex": "when_text", "width": Lino.chars2width(31), "editable": false }, { "colIndex": 1, "sortable": true, "header": "Klient", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('projectHidden','Lino.pcsw.Clients.detail'), "dataIndex": "project", "editor": project245 }, { "colIndex": 2, "sortable": true, "width": Lino.chars2width(22), "editable": true, "filter": { "type": "string" }, "header": "Kurzbeschreibung", "editor": summary246, "dataIndex": "summary" }, { "header": "Arbeitsablauf", "colIndex": 3, "sortable": false, "dataIndex": "workflow_buttons", "width": Lino.chars2width(31), "editable": false }, new Lino.NullNumberColumn({ "colIndex": 4, "sortable": true, "format": "0", "editable": true, "filter": { "type": "numeric" }, "header": "ID", "editor": id248, "hidden": true, "width": Lino.chars2width(6), "dataIndex": "id" }), { "colIndex": 5, "sortable": true, "header": "Verwaltet durch", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "editor": user249, "hidden": true, "dataIndex": "user" }, { "header": "Bearbeitet", "colIndex": 6, "sortable": true, "dataIndex": "modified", "width": Lino.chars2width(17), "hidden": true, "editable": false }, { "header": "Erstellt", "colIndex": 7, "sortable": true, "dataIndex": "created", "width": Lino.chars2width(17), "hidden": true, "editable": false }, { "header": "Druckdatum", "colIndex": 8, "sortable": true, "dataIndex": "build_time", "width": Lino.chars2width(17), "hidden": true, "editable": false }, { "colIndex": 9, "sortable": true, "header": "Konstruktionsmethode", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "editor": build_method253, "hidden": true, "dataIndex": "build_method" }, { "colIndex": 10, "sortable": true, "header": "Verkn\u00fcpft mit (Modell)", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "editor": owner_type254, "hidden": true, "dataIndex": "owner_type" }, { "colIndex": 11, "sortable": true, "header": "Verkn\u00fcpft mit (Objekt)", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(11), "editor": owner_id255, "hidden": true, "dataIndex": "owner_id" }, { "colIndex": 12, "sortable": true, "xtype": "datecolumn", "format": "d.m.Y", "editable": true, "filter": { "type": "date", "dateFormat": "d.m.Y" }, "header": "Beginnt am", "editor": start_date256, "hidden": true, "width": Lino.chars2width(14), "dataIndex": "start_date" }, { "colIndex": 13, "sortable": true, "width": Lino.chars2width(9), "editable": true, "header": "Beginnt um", "editor": start_time257, "hidden": true, "dataIndex": "start_time" }, { "colIndex": 14, "sortable": true, "xtype": "datecolumn", "format": "d.m.Y", "editable": true, "filter": { "type": "date", "dateFormat": "d.m.Y" }, "header": "Endet am", "editor": end_date258, "hidden": true, "width": Lino.chars2width(14), "dataIndex": "end_date" }, { "colIndex": 15, "sortable": true, "width": Lino.chars2width(9), "editable": true, "header": "Endet um", "editor": end_time259, "hidden": true, "dataIndex": "end_time" }, { "colIndex": 16, "sortable": true, "header": "Zugriffsklasse", "editable": true, "tooltip": "Ob dieser Termin  privat, \u00f6ffentlich oder halb \u00f6ffentlich ist", "filter": { "type": "string" }, "width": Lino.chars2width(35), "editor": access_class260, "hidden": true, "dataIndex": "access_class" }, new Lino.NullNumberColumn({ "colIndex": 17, "sortable": true, "format": "0", "editable": true, "filter": { "type": "numeric" }, "header": "Revisionsnummer", "editor": sequence261, "hidden": true, "width": Lino.chars2width(6), "dataIndex": "sequence" }), new Lino.NullNumberColumn({ "colIndex": 18, "sortable": true, "format": "0", "editable": false, "filter": { "type": "numeric" }, "header": "auto type", "dataIndex": "auto_type", "hidden": true, "width": Lino.chars2width(6) }), { "colIndex": 19, "sortable": true, "header": "Ereignisart", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "editor": event_type263, "hidden": true, "dataIndex": "event_type" }, { "colIndex": 20, "sortable": false, "xtype": "checkcolumn", "width": Lino.chars2width(11), "editable": true, "tooltip": "Dieser Termin l\u00e4sst auch andere Termine zur gleichen Zeit zu.", "filter": { "type": "boolean" }, "header": "nicht blockierend", "dataIndex": "transparent", "hidden": true }, { "colIndex": 21, "sortable": true, "header": "Raum", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "editor": room265, "hidden": true, "dataIndex": "room" }, { "colIndex": 22, "sortable": true, "header": "Priorit\u00e4t", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "editor": priority266, "hidden": true, "dataIndex": "priority" }, { "colIndex": 23, "sortable": true, "header": "Zustand", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(18), "editor": state267, "hidden": true, "dataIndex": "state" }, { "colIndex": 24, "sortable": true, "header": "Zugewiesen zu", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "editor": assigned_to268, "hidden": true, "dataIndex": "assigned_to" }, { "header": "Verkn\u00fcpft mit", "colIndex": 25, "sortable": false, "dataIndex": "owner", "width": Lino.chars2width(11), "hidden": true, "editable": false } ];
    Lino.cal.MyAssignedEvents.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.cal.MyAssignedEvents.show_as_html = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/cal/MyAssignedEvents", "GET", pk, "show_as_html", params, Lino.get_current_grid_config);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.cal.MyAssignedEvents.as_pdf = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/cal/MyAssignedEvents", "GET", pk, "as_pdf", params, Lino.get_current_grid_config);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.cal.MyAssignedEvents.as_pdf_p = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/cal/MyAssignedEvents", "GET", pk, "as_pdf_p", params, Lino.get_current_grid_config);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.cal.MyAssignedEvents.export_excel = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/cal/MyAssignedEvents", "GET", pk, "export_excel", params, Lino.get_current_grid_config);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.cal.MyAssignedEvents.submit_detail = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/cal/MyAssignedEvents", "GET", pk, "submit_detail", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};

Lino.cal.MyAssignedEvents.insertPanel = Ext.extend(Lino.cal.EventsByDay.InsertFormPanel,{
  empty_title: "Neu",
  hide_navigator: true,
  params_panel_hidden: true,
  save_action_name: "submit_insert",
  ls_bbar_actions: [ { "itemId": "submit_insert", "menu_item_text": "Erstellen", "tooltip": "Datensatz erstellen und dann im Detail-Fenster \u00f6ffnen", "panel_btn_handler": function(panel){panel.save()}, "text": "Erstellen", "overflowText": "Erstellen", "auto_save": false } ],
  ls_url: "/cal/MyAssignedEvents",
  action_name: "insert",
  initComponent : function() {
    this.ls_detail_handler = Lino.cal.MyAssignedEvents.detail;
    this.ls_insert_handler = Lino.cal.MyAssignedEvents.insert;
    Lino.cal.MyAssignedEvents.insertPanel.superclass.initComponent.call(this);
  }
});

Lino.cal.MyAssignedEvents.insert = new Lino.WindowAction({ "draggable": true, "width": Lino.chars2width(60), "autoHeight": true, "maximizable": true, "modal": true, "maximized": false }, function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.cal.MyAssignedEvents.insertPanel(p);
});
Lino.cal.MyAssignedEvents.grid_put = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/cal/MyAssignedEvents", "GET", pk, "grid_put", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.cal.MyAssignedEvents.grid_post = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/cal/MyAssignedEvents", "GET", pk, "grid_post", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.cal.MyAssignedEvents.submit_insert = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/cal/MyAssignedEvents", "GET", pk, "submit_insert", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.cal.MyAssignedEvents.wf1 = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/cal/MyAssignedEvents", "GET", pk, "wf1", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.cal.MyAssignedEvents.duplicate = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/cal/MyAssignedEvents", "GET", pk, "duplicate", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.cal.MyAssignedEvents.wf2 = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/cal/MyAssignedEvents", "GET", pk, "wf2", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.cal.MyAssignedEvents.wf3 = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/cal/MyAssignedEvents", "GET", pk, "wf3", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.cal.MyAssignedEvents.wf4 = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/cal/MyAssignedEvents", "GET", pk, "wf4", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};

Lino.cal.MyAssignedEvents.detailPanel = Ext.extend(Lino.cal.EventsByDay.DetailFormPanel,{
  empty_title: "Detail",
  params_panel_hidden: true,
  save_action_name: "submit_detail",
  ls_bbar_actions: [ { "itemId": "submit_detail", "menu_item_text": "Speichern", "tooltip": "\u00c4nderungen in diesem Formular speichern", "panel_btn_handler": function(panel){panel.save()}, "iconCls": "x-tbar-disk", "overflowText": "Speichern", "auto_save": false }, { "itemId": "insert", "menu_item_text": "Neu", "tooltip": "Neuen Datensatz erstellen", "panel_btn_handler": Lino.show_insert, "iconCls": "x-tbar-add", "overflowText": "Neu", "keycode": 44, "auto_save": true }, { "itemId": "duplicate", "menu_item_text": "Duplizieren", "tooltip": "Duplizieren", "panel_btn_handler": Lino.row_action_handler('duplicate','GET',null), "iconCls": "x-tbar-arrow_divide", "overflowText": "Duplizieren", "auto_save": true }, { "itemId": "delete_selected", "menu_item_text": "L\u00f6schen", "tooltip": "Diesen Datensatz l\u00f6schen", "panel_btn_handler": Lino.row_action_handler('delete_selected','GET',null), "iconCls": "x-tbar-delete", "overflowText": "L\u00f6schen", "keycode": 46, "auto_save": false }, { "itemId": "do_print", "menu_item_text": "Drucken", "tooltip": "Drucken", "panel_btn_handler": Lino.row_action_handler('do_print','POST',null), "iconCls": "x-tbar-printer", "overflowText": "Drucken", "auto_save": true }, { "itemId": "do_clear_cache", "menu_item_text": "Cache l\u00f6schen", "tooltip": "Cache l\u00f6schen", "panel_btn_handler": Lino.row_action_handler('do_clear_cache','GET',null), "iconCls": "x-tbar-printer_delete", "overflowText": "Cache l\u00f6schen", "auto_save": true }, { "itemId": "show_today", "menu_item_text": "Heute", "tooltip": "Show all calendar events of the same day.", "panel_btn_handler": Lino.row_action_handler('show_today','GET',null), "iconCls": "x-tbar-calendar", "overflowText": "Heute", "auto_save": true }, { "itemId": "create_postings", "menu_item_text": "per Post", "tooltip": "Create classical mail postings from this", "panel_btn_handler": Lino.row_action_handler('create_postings','GET',null), "iconCls": "x-tbar-script_add", "overflowText": "per Post", "auto_save": true }, { "itemId": "do_update_guests", "menu_item_text": "Update Guests", "tooltip": "Update Guests", "panel_btn_handler": Lino.row_action_handler('do_update_guests','GET',null), "iconCls": "x-tbar-lightning", "overflowText": "Update Guests", "auto_save": true }, { "itemId": "take", "menu_item_text": "Annehmen", "tooltip": "Verantwortung f\u00fcr diesen Termin \u00fcbernehmen.", "panel_btn_handler": Lino.row_action_handler('take','GET',null), "iconCls": "x-tbar-flag_green", "overflowText": "Annehmen", "auto_save": true }, { "itemId": "move_next", "menu_item_text": "Nach unten", "tooltip": "Nach unten", "panel_btn_handler": Lino.row_action_handler('move_next','GET',null), "iconCls": "x-tbar-date_next", "overflowText": "Nach unten", "auto_save": true }, { "itemId": "create_mail", "menu_item_text": "per E-Mail", "tooltip": "Create an email from this", "panel_btn_handler": Lino.row_action_handler('create_mail','GET',null), "iconCls": "x-tbar-email_add", "overflowText": "per E-Mail", "auto_save": true } ],
  ls_url: "/cal/MyAssignedEvents",
  action_name: "detail",
  initComponent : function() {
    this.ls_detail_handler = Lino.cal.MyAssignedEvents.detail;
    this.ls_insert_handler = Lino.cal.MyAssignedEvents.insert;
    Lino.cal.MyAssignedEvents.detailPanel.superclass.initComponent.call(this);
  }
});

Lino.cal.MyAssignedEvents.detail = new Lino.WindowAction({  }, function(){
  var p = { "is_main_window": true };
  return new Lino.cal.MyAssignedEvents.detailPanel(p);
});
Lino.cal.MyAssignedEvents.delete_selected = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/cal/MyAssignedEvents", "GET", pk, "delete_selected", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.cal.MyAssignedEvents.do_print = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/cal/MyAssignedEvents", "POST", pk, "do_print", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.cal.MyAssignedEvents.do_clear_cache = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/cal/MyAssignedEvents", "GET", pk, "do_clear_cache", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.cal.MyAssignedEvents.edit_template = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/cal/MyAssignedEvents", "GET", pk, "edit_template", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.cal.MyAssignedEvents.show_today = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/cal/MyAssignedEvents", "GET", pk, "show_today", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.cal.MyAssignedEvents.grid = new Lino.WindowAction({  }, function(){
  var p = { "is_main_window": true };
  p.params_panel = new Lino.cal.EventsByDay.ParamsPanel({});
  return new Lino.cal.MyAssignedEvents.GridPanel(p);
});
Lino.cal.MyAssignedEvents.validate = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/cal/MyAssignedEvents", "GET", pk, "validate", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.cal.MyAssignedEvents.create_postings = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/cal/MyAssignedEvents", "GET", pk, "create_postings", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.cal.MyAssignedEvents.do_update_guests = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/cal/MyAssignedEvents", "GET", pk, "do_update_guests", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.cal.MyAssignedEvents.take = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/cal/MyAssignedEvents", "GET", pk, "take", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.cal.MyAssignedEvents.move_next = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/cal/MyAssignedEvents", "GET", pk, "move_next", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.cal.MyAssignedEvents.create_mail = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/cal/MyAssignedEvents", "GET", pk, "create_mail", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};

// js_render_GridPanel_class countries.Countries
Lino.countries.Countries.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "Keine Daten anzuzeigen." },
  ls_url : "/countries/Countries",
  ls_bbar_actions : [ { "itemId": "show_as_html", "menu_item_text": "HTML", "tooltip": "Show this table in Bootstrap3 interface", "panel_btn_handler": Lino.list_action_handler('/countries/Countries','show_as_html','GET',Lino.get_current_grid_config), "iconCls": "x-tbar-html", "overflowText": "HTML", "auto_save": true }, { "panel_btn_handler": Lino.list_action_handler('/countries/Countries','as_pdf','GET',Lino.get_current_grid_config), "xtype": "splitbutton", "text": null, "menu": [ { "itemId": "as_pdf", "menu_item_text": "Tabelle (Querformat)", "tooltip": "Diese Tabelle in eine .pdf-Datei exportieren", "panel_btn_handler": Lino.list_action_handler('/countries/Countries','as_pdf','GET',Lino.get_current_grid_config), "text": "Tabelle (Querformat)", "overflowText": "Tabelle (Querformat)", "auto_save": true }, { "itemId": "as_pdf_p", "menu_item_text": "Tabelle (Hochformat)", "tooltip": "Diese Tabelle in eine .pdf-Datei exportieren", "panel_btn_handler": Lino.list_action_handler('/countries/Countries','as_pdf_p','GET',Lino.get_current_grid_config), "text": "Tabelle (Hochformat)", "overflowText": "Tabelle (Hochformat)", "auto_save": true } ], "iconCls": "x-tbar-pdf", "menu_item_text": "Tabelle (Querformat)" }, { "itemId": "export_excel", "menu_item_text": "Export to .xls", "tooltip": "Export this table as an .xls document", "panel_btn_handler": Lino.list_action_handler('/countries/Countries','export_excel','GET',Lino.get_current_grid_config), "iconCls": "x-tbar-csv", "overflowText": "Export to .xls", "auto_save": true }, { "itemId": "insert", "menu_item_text": "Neu", "tooltip": "Neuen Datensatz erstellen", "panel_btn_handler": Lino.show_insert, "iconCls": "x-tbar-add", "overflowText": "Neu", "keycode": 44, "auto_save": true }, { "itemId": "detail", "menu_item_text": "Detail", "tooltip": "Detail-Fenster auf diesem Datensatz \u00f6ffnen", "panel_btn_handler": Lino.show_detail, "iconCls": "x-tbar-application_form", "overflowText": "Detail", "auto_save": true }, { "itemId": "delete_selected", "menu_item_text": "L\u00f6schen", "tooltip": "Diesen Datensatz l\u00f6schen", "panel_btn_handler": Lino.row_action_handler('delete_selected','GET',null), "iconCls": "x-tbar-delete", "overflowText": "L\u00f6schen", "keycode": 46, "auto_save": false } ],
  cell_edit : true,
  title : "L\u00e4nder",
  page_length : 20,
  stripeRows : true,
  disabled_actions_index : 8,
  ls_store_fields : [ { "name": "name" }, { "name": "name_fr" }, { "name": "name_nl" }, { "name": "isocode" }, { "name": "short_code" }, { "name": "iso3" }, { "name": "inscode" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 3,
  ls_grid_configs : [  ],
  content_type : 9,
  ls_id_property : "isocode",
  gc_name : 0,
  initComponent : function() {
    this.ls_detail_handler = Lino.countries.Countries.detail;
    this.ls_insert_handler = Lino.countries.Countries.insert;
    var ww = this.containing_window;
    var name2874 = new Ext.form.TextField({ "selectOnFocus": true, "allowBlank": false, "maxLength": 200 });
    var name_fr2875 = new Ext.form.TextField({ "selectOnFocus": true, "hidden": true, "maxLength": 200 });
    var name_nl2876 = new Ext.form.TextField({ "selectOnFocus": true, "hidden": true, "maxLength": 200 });
    var isocode2877 = new Ext.form.TextField({ "selectOnFocus": true, "boxMinWidth": Lino.chars2width(4), "allowBlank": false, "maxLength": 4 });
    var short_code2878 = new Ext.form.TextField({ "selectOnFocus": true, "boxMinWidth": Lino.chars2width(4), "maxLength": 4 });
    var iso32879 = new Ext.form.TextField({ "selectOnFocus": true, "boxMinWidth": Lino.chars2width(3), "maxLength": 3 });
    var inscode2880 = new Ext.form.TextField({ "selectOnFocus": true, "boxMinWidth": Lino.chars2width(3), "maxLength": 3 });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ { "colIndex": 0, "sortable": true, "width": Lino.chars2width(22), "editable": true, "filter": { "type": "string" }, "header": "Bezeichnung", "editor": name2874, "dataIndex": "name" }, { "colIndex": 1, "sortable": true, "width": Lino.chars2width(22), "editable": true, "filter": { "type": "string" }, "header": "Bezeichnung (fr)", "editor": name_fr2875, "hidden": true, "dataIndex": "name_fr" }, { "colIndex": 2, "sortable": true, "width": Lino.chars2width(22), "editable": true, "filter": { "type": "string" }, "header": "Bezeichnung (nl)", "editor": name_nl2876, "hidden": true, "dataIndex": "name_nl" }, { "colIndex": 3, "sortable": true, "header": "ISO-Code", "editable": true, "tooltip": "        The two-letter code for this country as defined by ISO 3166-1.\n        For countries that no longer exist it may be a 4-letter code.", "filter": { "type": "string" }, "width": Lino.chars2width(6), "editor": isocode2877, "dataIndex": "isocode" }, { "colIndex": 4, "sortable": true, "header": "Short code", "editable": true, "tooltip": "A short abbreviation for regional usage. Obsolete.", "filter": { "type": "string" }, "width": Lino.chars2width(6), "editor": short_code2878, "hidden": true, "dataIndex": "short_code" }, { "colIndex": 5, "sortable": true, "header": "ISO3-Code", "editable": true, "tooltip": "The three-letter code for this country as defined by ISO 3166-1.", "filter": { "type": "string" }, "width": Lino.chars2width(5), "editor": iso32879, "hidden": true, "dataIndex": "iso3" }, { "colIndex": 6, "sortable": true, "header": "INS code", "editable": true, "tooltip": "The official code for this country                     used by statbel.fgov.be", "filter": { "type": "string" }, "width": Lino.chars2width(5), "editor": inscode2880, "hidden": true, "dataIndex": "inscode" } ];
    Lino.countries.Countries.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.countries.Countries.show_as_html = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/countries/Countries", "GET", pk, "show_as_html", params, Lino.get_current_grid_config);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.countries.Countries.as_pdf = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/countries/Countries", "GET", pk, "as_pdf", params, Lino.get_current_grid_config);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.countries.Countries.as_pdf_p = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/countries/Countries", "GET", pk, "as_pdf_p", params, Lino.get_current_grid_config);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.countries.Countries.export_excel = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/countries/Countries", "GET", pk, "export_excel", params, Lino.get_current_grid_config);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.countries.Countries.submit_detail = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/countries/Countries", "GET", pk, "submit_detail", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};

Lino.countries.Countries.insertPanel = Ext.extend(Lino.countries.Countries.DetailFormPanel,{
  empty_title: "Neu",
  hide_navigator: true,
  save_action_name: "submit_insert",
  ls_bbar_actions: [ { "itemId": "submit_insert", "menu_item_text": "Erstellen", "tooltip": "Datensatz erstellen und dann im Detail-Fenster \u00f6ffnen", "panel_btn_handler": function(panel){panel.save()}, "text": "Erstellen", "overflowText": "Erstellen", "auto_save": false } ],
  ls_url: "/countries/Countries",
  action_name: "insert",
  initComponent : function() {
    this.ls_detail_handler = Lino.countries.Countries.detail;
    this.ls_insert_handler = Lino.countries.Countries.insert;
    Lino.countries.Countries.insertPanel.superclass.initComponent.call(this);
  }
});

Lino.countries.Countries.insert = new Lino.WindowAction({  }, function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.countries.Countries.insertPanel(p);
});
Lino.countries.Countries.grid_put = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/countries/Countries", "GET", pk, "grid_put", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.countries.Countries.grid_post = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/countries/Countries", "GET", pk, "grid_post", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.countries.Countries.submit_insert = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/countries/Countries", "GET", pk, "submit_insert", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};

Lino.countries.Countries.detailPanel = Ext.extend(Lino.countries.Countries.DetailFormPanel,{
  empty_title: "Detail",
  save_action_name: "submit_detail",
  ls_bbar_actions: [ { "itemId": "submit_detail", "menu_item_text": "Speichern", "tooltip": "\u00c4nderungen in diesem Formular speichern", "panel_btn_handler": function(panel){panel.save()}, "iconCls": "x-tbar-disk", "overflowText": "Speichern", "auto_save": false }, { "itemId": "insert", "menu_item_text": "Neu", "tooltip": "Neuen Datensatz erstellen", "panel_btn_handler": Lino.show_insert, "iconCls": "x-tbar-add", "overflowText": "Neu", "keycode": 44, "auto_save": true }, { "itemId": "delete_selected", "menu_item_text": "L\u00f6schen", "tooltip": "Diesen Datensatz l\u00f6schen", "panel_btn_handler": Lino.row_action_handler('delete_selected','GET',null), "iconCls": "x-tbar-delete", "overflowText": "L\u00f6schen", "keycode": 46, "auto_save": false } ],
  ls_url: "/countries/Countries",
  action_name: "detail",
  initComponent : function() {
    this.ls_detail_handler = Lino.countries.Countries.detail;
    this.ls_insert_handler = Lino.countries.Countries.insert;
    Lino.countries.Countries.detailPanel.superclass.initComponent.call(this);
  }
});

Lino.countries.Countries.detail = new Lino.WindowAction({  }, function(){
  var p = { "is_main_window": true };
  return new Lino.countries.Countries.detailPanel(p);
});
Lino.countries.Countries.delete_selected = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/countries/Countries", "GET", pk, "delete_selected", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.countries.Countries.grid = new Lino.WindowAction({  }, function(){
  var p = { "is_main_window": true };
  return new Lino.countries.Countries.GridPanel(p);
});
Lino.countries.Countries.validate = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/countries/Countries", "GET", pk, "validate", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};

// js_render_GridPanel_class properties.PropChoices
Lino.properties.PropChoices.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "Keine Daten anzuzeigen." },
  ls_url : "/properties/PropChoices",
  ls_bbar_actions : [ { "itemId": "show_as_html", "menu_item_text": "HTML", "tooltip": "Show this table in Bootstrap3 interface", "panel_btn_handler": Lino.list_action_handler('/properties/PropChoices','show_as_html','GET',Lino.get_current_grid_config), "iconCls": "x-tbar-html", "overflowText": "HTML", "auto_save": true }, { "panel_btn_handler": Lino.list_action_handler('/properties/PropChoices','as_pdf','GET',Lino.get_current_grid_config), "xtype": "splitbutton", "text": null, "menu": [ { "itemId": "as_pdf", "menu_item_text": "Tabelle (Querformat)", "tooltip": "Diese Tabelle in eine .pdf-Datei exportieren", "panel_btn_handler": Lino.list_action_handler('/properties/PropChoices','as_pdf','GET',Lino.get_current_grid_config), "text": "Tabelle (Querformat)", "overflowText": "Tabelle (Querformat)", "auto_save": true }, { "itemId": "as_pdf_p", "menu_item_text": "Tabelle (Hochformat)", "tooltip": "Diese Tabelle in eine .pdf-Datei exportieren", "panel_btn_handler": Lino.list_action_handler('/properties/PropChoices','as_pdf_p','GET',Lino.get_current_grid_config), "text": "Tabelle (Hochformat)", "overflowText": "Tabelle (Hochformat)", "auto_save": true } ], "iconCls": "x-tbar-pdf", "menu_item_text": "Tabelle (Querformat)" }, { "itemId": "export_excel", "menu_item_text": "Export to .xls", "tooltip": "Export this table as an .xls document", "panel_btn_handler": Lino.list_action_handler('/properties/PropChoices','export_excel','GET',Lino.get_current_grid_config), "iconCls": "x-tbar-csv", "overflowText": "Export to .xls", "auto_save": true }, { "itemId": "delete_selected", "menu_item_text": "L\u00f6schen", "tooltip": "Diesen Datensatz l\u00f6schen", "panel_btn_handler": Lino.row_action_handler('delete_selected','GET',null), "iconCls": "x-tbar-delete", "overflowText": "L\u00f6schen", "keycode": 46, "auto_save": false } ],
  cell_edit : true,
  title : "Auswahlm\u00f6glichkeiten",
  page_length : 20,
  stripeRows : true,
  disabled_actions_index : 8,
  ls_store_fields : [ { "type": "int", "name": "id" }, { "name": "type" }, 'typeHidden', { "name": "value" }, { "name": "text" }, { "name": "text_fr" }, { "name": "text_nl" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 0,
  ls_grid_configs : [  ],
  content_type : 14,
  ls_id_property : "id",
  gc_name : 0,
  initComponent : function() {
    var ww = this.containing_window;
    var id2882 = new Ext.form.NumberField({ "selectOnFocus": true });
    var type2883 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/properties/PropChoices/type", "method": "GET" }) }), "allowBlank": false, "pageSize": 20, "emptyText": "Eigenschafts-Datentyp ausw\u00e4hlen..." });
    var value2884 = new Ext.form.TextField({ "selectOnFocus": true, "allowBlank": false, "maxLength": 200 });
    var text2885 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var text_fr2886 = new Ext.form.TextField({ "selectOnFocus": true, "hidden": true, "maxLength": 200 });
    var text_nl2887 = new Ext.form.TextField({ "selectOnFocus": true, "hidden": true, "maxLength": 200 });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ new Lino.NullNumberColumn({ "colIndex": 0, "sortable": true, "format": "0", "editable": true, "filter": { "type": "numeric" }, "header": "ID", "editor": id2882, "width": Lino.chars2width(6), "dataIndex": "id" }), { "colIndex": 1, "sortable": true, "width": Lino.chars2width(21), "editable": true, "filter": { "type": "string" }, "header": "Eigenschafts-Datentyp", "editor": type2883, "dataIndex": "type" }, { "colIndex": 2, "sortable": true, "width": Lino.chars2width(22), "editable": true, "filter": { "type": "string" }, "header": "Wert", "editor": value2884, "dataIndex": "value" }, { "colIndex": 3, "sortable": true, "width": Lino.chars2width(22), "editable": true, "filter": { "type": "string" }, "header": "Bezeichnung", "editor": text2885, "dataIndex": "text" }, { "colIndex": 4, "sortable": true, "width": Lino.chars2width(22), "editable": true, "filter": { "type": "string" }, "header": "Bezeichnung (fr)", "editor": text_fr2886, "hidden": true, "dataIndex": "text_fr" }, { "colIndex": 5, "sortable": true, "width": Lino.chars2width(22), "editable": true, "filter": { "type": "string" }, "header": "Bezeichnung (nl)", "editor": text_nl2887, "hidden": true, "dataIndex": "text_nl" } ];
    Lino.properties.PropChoices.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.properties.PropChoices.show_as_html = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/properties/PropChoices", "GET", pk, "show_as_html", params, Lino.get_current_grid_config);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.properties.PropChoices.as_pdf = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/properties/PropChoices", "GET", pk, "as_pdf", params, Lino.get_current_grid_config);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.properties.PropChoices.as_pdf_p = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/properties/PropChoices", "GET", pk, "as_pdf_p", params, Lino.get_current_grid_config);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.properties.PropChoices.export_excel = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/properties/PropChoices", "GET", pk, "export_excel", params, Lino.get_current_grid_config);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.properties.PropChoices.grid_put = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/properties/PropChoices", "GET", pk, "grid_put", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.properties.PropChoices.grid_post = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/properties/PropChoices", "GET", pk, "grid_post", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.properties.PropChoices.submit_insert = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/properties/PropChoices", "GET", pk, "submit_insert", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.properties.PropChoices.delete_selected = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/properties/PropChoices", "GET", pk, "delete_selected", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.properties.PropChoices.grid = new Lino.WindowAction({  }, function(){
  var p = { "is_main_window": true };
  return new Lino.properties.PropChoices.GridPanel(p);
});

// js_render_GridPanel_class contacts.Partners
Lino.contacts.Partners.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "Keine Daten anzuzeigen." },
  ls_url : "/contacts/Partners",
  ls_bbar_actions : [ { "itemId": "show_as_html", "menu_item_text": "HTML", "tooltip": "Show this table in Bootstrap3 interface", "panel_btn_handler": Lino.list_action_handler('/contacts/Partners','show_as_html','GET',Lino.get_current_grid_config), "iconCls": "x-tbar-html", "overflowText": "HTML", "auto_save": true }, { "panel_btn_handler": Lino.list_action_handler('/contacts/Partners','as_pdf','GET',Lino.get_current_grid_config), "xtype": "splitbutton", "text": null, "menu": [ { "itemId": "as_pdf", "menu_item_text": "Tabelle (Querformat)", "tooltip": "Diese Tabelle in eine .pdf-Datei exportieren", "panel_btn_handler": Lino.list_action_handler('/contacts/Partners','as_pdf','GET',Lino.get_current_grid_config), "text": "Tabelle (Querformat)", "overflowText": "Tabelle (Querformat)", "auto_save": true }, { "itemId": "as_pdf_p", "menu_item_text": "Tabelle (Hochformat)", "tooltip": "Diese Tabelle in eine .pdf-Datei exportieren", "panel_btn_handler": Lino.list_action_handler('/contacts/Partners','as_pdf_p','GET',Lino.get_current_grid_config), "text": "Tabelle (Hochformat)", "overflowText": "Tabelle (Hochformat)", "auto_save": true }, { "itemId": "print_labels", "menu_item_text": "Etiketten", "tooltip": "Generate mailing labels for these recipients", "panel_btn_handler": Lino.list_action_handler('/contacts/Partners','print_labels','GET',Lino.get_current_grid_config), "text": "Etiketten", "overflowText": "Etiketten", "auto_save": true } ], "iconCls": "x-tbar-pdf", "menu_item_text": "Tabelle (Querformat)" }, { "itemId": "export_excel", "menu_item_text": "Export to .xls", "tooltip": "Export this table as an .xls document", "panel_btn_handler": Lino.list_action_handler('/contacts/Partners','export_excel','GET',Lino.get_current_grid_config), "iconCls": "x-tbar-csv", "overflowText": "Export to .xls", "auto_save": true }, { "itemId": "insert", "menu_item_text": "Neu", "tooltip": "Neuen Datensatz erstellen", "panel_btn_handler": Lino.show_insert, "iconCls": "x-tbar-add", "overflowText": "Neu", "keycode": 44, "auto_save": true }, { "itemId": "detail", "menu_item_text": "Detail", "tooltip": "Detail-Fenster auf diesem Datensatz \u00f6ffnen", "panel_btn_handler": Lino.show_detail, "iconCls": "x-tbar-application_form", "overflowText": "Detail", "auto_save": true }, { "itemId": "delete_selected", "menu_item_text": "L\u00f6schen", "tooltip": "Diesen Datensatz l\u00f6schen", "panel_btn_handler": Lino.row_action_handler('delete_selected','GET',null), "iconCls": "x-tbar-delete", "overflowText": "L\u00f6schen", "keycode": 46, "auto_save": false } ],
  cell_edit : true,
  title : "Partner",
  page_length : 20,
  stripeRows : true,
  disabled_actions_index : 33,
  ls_store_fields : [ { "name": "name" }, { "name": "email" }, { "name": "modified" }, { "name": "created" }, { "name": "country" }, 'countryHidden', { "name": "city" }, 'cityHidden', { "name": "zip_code" }, { "name": "region" }, 'regionHidden', { "name": "addr1" }, { "name": "street_prefix" }, { "name": "street" }, { "name": "street_no" }, { "name": "street_box" }, { "name": "addr2" }, { "name": "language" }, 'languageHidden', { "name": "url" }, { "name": "phone" }, { "name": "gsm" }, { "name": "fax" }, { "name": "remarks" }, { "type": "boolean", "name": "is_obsolete" }, { "name": "activity" }, 'activityHidden', { "name": "client_contact_type" }, 'client_contact_typeHidden', { "name": "iban" }, { "name": "bic" }, { "type": "int", "name": "id" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 31,
  ls_grid_configs : [  ],
  content_type : 20,
  ls_id_property : "id",
  gc_name : 0,
  initComponent : function() {
    this.ls_detail_handler = Lino.contacts.Partners.detail;
    this.ls_insert_handler = Lino.contacts.Partners.insert;
    var ww = this.containing_window;
    var name2889 = new Ext.form.TextField({ "selectOnFocus": true, "allowBlank": false, "maxLength": 200 });
    var email2890 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 75 });
    var modified2891 = new Ext.form.DisplayField({ "disabled": true, "value": "<br>" });
    var created2892 = new Ext.form.DisplayField({ "disabled": true, "value": "<br>" });
    var country2893 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/contacts/Partners/country", "method": "GET" }) }), "pageSize": 20, "emptyText": "Land ausw\u00e4hlen..." });
    var city2894 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "forceSelection": false, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/contacts/Partners/city", "method": "GET" }) }), "pageSize": 20, "emptyText": "Ort ausw\u00e4hlen..." });
    var zip_code2895 = new Ext.form.TextField({ "selectOnFocus": true, "boxMinWidth": Lino.chars2width(10), "maxLength": 10 });
    var region2896 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/contacts/Partners/region", "method": "GET" }) }), "pageSize": 20, "emptyText": "Ort ausw\u00e4hlen..." });
    var addr12897 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var street_prefix2898 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var street2899 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var street_no2900 = new Ext.form.TextField({ "selectOnFocus": true, "boxMinWidth": Lino.chars2width(10), "maxLength": 10 });
    var street_box2901 = new Ext.form.TextField({ "selectOnFocus": true, "boxMinWidth": Lino.chars2width(10), "maxLength": 10 });
    var addr22902 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var language2903 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "allowBlank": false, "store": [ [ "de", "Deutsch" ], [ "fr", "Franz\u00f6sisch" ], [ "nl", "Niederl\u00e4ndisch" ] ] });
    var url2904 = new Lino.URLField({ "selectOnFocus": true, "maxLength": 200 });
    var phone2905 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var gsm2906 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var fax2907 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var remarks2908 = new Ext.form.TextArea({ "selectOnFocus": true, "growMax": 2000 });
    var is_obsolete2909 = new Ext.form.Checkbox({ "selectOnFocus": true, "checked": false });
    var activity2910 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/contacts/Partners/activity", "method": "GET" }) }), "pageSize": 20, "emptyText": "Beruf ausw\u00e4hlen..." });
    var client_contact_type2911 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/contacts/Partners/client_contact_type", "method": "GET" }) }), "pageSize": 20, "emptyText": "Klientenkontaktart ausw\u00e4hlen..." });
    var iban2912 = new Lino.UppercaseTextField({ "selectOnFocus": true, "maxLength": 34 });
    var bic2913 = new Lino.UppercaseTextField({ "selectOnFocus": true, "maxLength": 11 });
    var id2914 = new Ext.form.NumberField({ "selectOnFocus": true });
    this.before_row_edit = function(record) {
      city2894.setContextValue('country', record ? record.data['countryHidden'] : undefined);
      city2894.setContextValue('region', record ? record.data['regionHidden'] : undefined);
      region2896.setContextValue('country', record ? record.data['countryHidden'] : undefined);
    };
    this.onRender = function(ct, position) {
      country2893.on('change',Lino.chooser_handler(city2894,'country'));
      region2896.on('change',Lino.chooser_handler(city2894,'region'));
      country2893.on('change',Lino.chooser_handler(region2896,'country'));
      Lino.contacts.Partners.GridPanel.superclass.onRender.call(this, ct, position);
    }
    this.ls_columns = [ { "colIndex": 0, "sortable": true, "width": Lino.chars2width(22), "editable": true, "filter": { "type": "string" }, "header": "Name", "editor": name2889, "dataIndex": "name" }, { "colIndex": 1, "sortable": true, "width": Lino.chars2width(22), "editable": true, "filter": { "type": "string" }, "header": "E-Mail", "editor": email2890, "dataIndex": "email" }, { "header": "Bearbeitet", "colIndex": 2, "sortable": true, "dataIndex": "modified", "width": Lino.chars2width(17), "hidden": true, "editable": false }, { "header": "Erstellt", "colIndex": 3, "sortable": true, "dataIndex": "created", "width": Lino.chars2width(17), "hidden": true, "editable": false }, { "colIndex": 4, "sortable": true, "header": "Land", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('countryHidden','Lino.countries.Countries.detail'), "dataIndex": "country", "hidden": true, "editor": country2893 }, { "colIndex": 5, "sortable": true, "header": "Stadt", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "editor": city2894, "hidden": true, "dataIndex": "city" }, { "colIndex": 6, "sortable": true, "header": "Postleitzahl", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(12), "editor": zip_code2895, "hidden": true, "dataIndex": "zip_code" }, { "colIndex": 7, "sortable": true, "header": "Regierungsbezirk", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "editor": region2896, "hidden": true, "dataIndex": "region" }, { "colIndex": 8, "sortable": true, "header": "Adresszeile vor Stra\u00dfe", "editable": true, "tooltip": "Adresszeile vor Stra\u00dfe", "filter": { "type": "string" }, "width": Lino.chars2width(22), "editor": addr12897, "hidden": true, "dataIndex": "addr1" }, { "colIndex": 9, "sortable": true, "header": "Pr\u00e4fix Stra\u00dfe", "editable": true, "tooltip": "Text to print before name of street, but to ignore for sorting.", "filter": { "type": "string" }, "width": Lino.chars2width(22), "editor": street_prefix2898, "hidden": true, "dataIndex": "street_prefix" }, { "colIndex": 10, "sortable": true, "header": "Stra\u00dfe", "editable": true, "tooltip": "Name der Stra\u00dfe, ohne Hausnummer", "filter": { "type": "string" }, "width": Lino.chars2width(22), "editor": street2899, "hidden": true, "dataIndex": "street" }, { "colIndex": 11, "sortable": true, "header": "Nr.", "editable": true, "tooltip": "Hausnummer", "filter": { "type": "string" }, "width": Lino.chars2width(12), "editor": street_no2900, "hidden": true, "dataIndex": "street_no" }, { "colIndex": 12, "sortable": true, "header": "Box", "editable": true, "tooltip": "Text to print after street nuber on the same line.", "filter": { "type": "string" }, "width": Lino.chars2width(12), "editor": street_box2901, "hidden": true, "dataIndex": "street_box" }, { "colIndex": 13, "sortable": true, "header": "Adresszeile nach Stra\u00dfe", "editable": true, "tooltip": "Adresszeile nach Stra\u00dfe", "filter": { "type": "string" }, "width": Lino.chars2width(22), "editor": addr22902, "hidden": true, "dataIndex": "addr2" }, { "colIndex": 14, "sortable": true, "header": "Sprache", "editable": true, "tooltip": "Die Sprache, in der Dokumente ausgestellt werden sollen.", "filter": { "type": "string" }, "width": Lino.chars2width(21), "editor": language2903, "hidden": true, "dataIndex": "language" }, { "colIndex": 15, "sortable": true, "header": "URL", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "editor": url2904, "hidden": true, "dataIndex": "url" }, { "colIndex": 16, "sortable": true, "header": "Telefon", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "editor": phone2905, "hidden": true, "dataIndex": "phone" }, { "colIndex": 17, "sortable": true, "header": "GSM", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "editor": gsm2906, "hidden": true, "dataIndex": "gsm" }, { "colIndex": 18, "sortable": true, "header": "Fax", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "editor": fax2907, "hidden": true, "dataIndex": "fax" }, { "colIndex": 19, "sortable": false, "header": "Bemerkungen", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(61), "editor": remarks2908, "hidden": true, "dataIndex": "remarks" }, { "colIndex": 20, "sortable": false, "xtype": "checkcolumn", "width": Lino.chars2width(11), "editable": true, "tooltip": "Altf\u00e4lle sind Partner, deren Stammdaten nicht mehr gepflegt werden und \nf\u00fcr neue Operationen nicht benutzt werden k\u00f6nnen.", "filter": { "type": "boolean" }, "header": "veraltet", "dataIndex": "is_obsolete", "hidden": true }, { "colIndex": 21, "sortable": true, "header": "Beruf", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "editor": activity2910, "hidden": true, "dataIndex": "activity" }, { "colIndex": 22, "sortable": true, "header": "Klientenkontaktart", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "editor": client_contact_type2911, "hidden": true, "dataIndex": "client_contact_type" }, { "colIndex": 23, "sortable": true, "header": "IBAN", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "renderer": Lino.iban_renderer, "hidden": true, "editor": iban2912, "dataIndex": "iban" }, { "colIndex": 24, "sortable": true, "header": "BIC", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(13), "editor": bic2913, "hidden": true, "dataIndex": "bic" }, new Lino.NullNumberColumn({ "colIndex": 25, "sortable": true, "format": "0", "editable": true, "filter": { "type": "numeric" }, "header": "ID", "editor": id2914, "width": Lino.chars2width(6), "dataIndex": "id" }) ];
    Lino.contacts.Partners.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.contacts.Partners.show_as_html = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/contacts/Partners", "GET", pk, "show_as_html", params, Lino.get_current_grid_config);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.contacts.Partners.as_pdf = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/contacts/Partners", "GET", pk, "as_pdf", params, Lino.get_current_grid_config);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.contacts.Partners.as_pdf_p = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/contacts/Partners", "GET", pk, "as_pdf_p", params, Lino.get_current_grid_config);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.contacts.Partners.print_labels = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/contacts/Partners", "GET", pk, "print_labels", params, Lino.get_current_grid_config);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.contacts.Partners.export_excel = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/contacts/Partners", "GET", pk, "export_excel", params, Lino.get_current_grid_config);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.contacts.Partners.submit_detail = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/contacts/Partners", "GET", pk, "submit_detail", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};

Lino.contacts.Partners.insertPanel = Ext.extend(Lino.contacts.Partners.InsertFormPanel,{
  empty_title: "Neu",
  hide_navigator: true,
  save_action_name: "submit_insert",
  ls_bbar_actions: [ { "itemId": "submit_insert", "menu_item_text": "Erstellen", "tooltip": "Datensatz erstellen und dann im Detail-Fenster \u00f6ffnen", "panel_btn_handler": function(panel){panel.save()}, "text": "Erstellen", "overflowText": "Erstellen", "auto_save": false } ],
  ls_url: "/contacts/Partners",
  action_name: "insert",
  initComponent : function() {
    this.ls_detail_handler = Lino.contacts.Partners.detail;
    this.ls_insert_handler = Lino.contacts.Partners.insert;
    Lino.contacts.Partners.insertPanel.superclass.initComponent.call(this);
  }
});

Lino.contacts.Partners.insert = new Lino.WindowAction({ "draggable": true, "width": Lino.chars2width(40), "autoHeight": true, "maximizable": true, "modal": true, "maximized": false }, function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.contacts.Partners.insertPanel(p);
});
Lino.contacts.Partners.grid_put = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/contacts/Partners", "GET", pk, "grid_put", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.contacts.Partners.grid_post = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/contacts/Partners", "GET", pk, "grid_post", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.contacts.Partners.submit_insert = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/contacts/Partners", "GET", pk, "submit_insert", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};

Lino.contacts.Partners.detailPanel = Ext.extend(Lino.contacts.Partners.DetailFormPanel,{
  empty_title: "Detail",
  save_action_name: "submit_detail",
  ls_bbar_actions: [ { "itemId": "submit_detail", "menu_item_text": "Speichern", "tooltip": "\u00c4nderungen in diesem Formular speichern", "panel_btn_handler": function(panel){panel.save()}, "iconCls": "x-tbar-disk", "overflowText": "Speichern", "auto_save": false }, { "itemId": "insert", "menu_item_text": "Neu", "tooltip": "Neuen Datensatz erstellen", "panel_btn_handler": Lino.show_insert, "iconCls": "x-tbar-add", "overflowText": "Neu", "keycode": 44, "auto_save": true }, { "itemId": "delete_selected", "menu_item_text": "L\u00f6schen", "tooltip": "Diesen Datensatz l\u00f6schen", "panel_btn_handler": Lino.row_action_handler('delete_selected','GET',null), "iconCls": "x-tbar-delete", "overflowText": "L\u00f6schen", "keycode": 46, "auto_save": false } ],
  ls_url: "/contacts/Partners",
  action_name: "detail",
  initComponent : function() {
    this.ls_detail_handler = Lino.contacts.Partners.detail;
    this.ls_insert_handler = Lino.contacts.Partners.insert;
    Lino.contacts.Partners.detailPanel.superclass.initComponent.call(this);
  }
});

Lino.contacts.Partners.detail = new Lino.WindowAction({  }, function(){
  var p = { "is_main_window": true };
  return new Lino.contacts.Partners.detailPanel(p);
});
Lino.contacts.Partners.delete_selected = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/contacts/Partners", "GET", pk, "delete_selected", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.contacts.Partners.grid = new Lino.WindowAction({  }, function(){
  var p = { "is_main_window": true };
  return new Lino.contacts.Partners.GridPanel(p);
});
Lino.contacts.Partners.validate = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/contacts/Partners", "GET", pk, "validate", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};

// js_render_GridPanel_class contacts.Persons
Lino.contacts.Persons.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "Keine Daten anzuzeigen." },
  ls_url : "/contacts/Persons",
  ls_bbar_actions : [ { "itemId": "show_as_html", "menu_item_text": "HTML", "tooltip": "Show this table in Bootstrap3 interface", "panel_btn_handler": Lino.list_action_handler('/contacts/Persons','show_as_html','GET',Lino.get_current_grid_config), "iconCls": "x-tbar-html", "overflowText": "HTML", "auto_save": true }, { "panel_btn_handler": Lino.list_action_handler('/contacts/Persons','as_pdf','GET',Lino.get_current_grid_config), "xtype": "splitbutton", "text": null, "menu": [ { "itemId": "as_pdf", "menu_item_text": "Tabelle (Querformat)", "tooltip": "Diese Tabelle in eine .pdf-Datei exportieren", "panel_btn_handler": Lino.list_action_handler('/contacts/Persons','as_pdf','GET',Lino.get_current_grid_config), "text": "Tabelle (Querformat)", "overflowText": "Tabelle (Querformat)", "auto_save": true }, { "itemId": "as_pdf_p", "menu_item_text": "Tabelle (Hochformat)", "tooltip": "Diese Tabelle in eine .pdf-Datei exportieren", "panel_btn_handler": Lino.list_action_handler('/contacts/Persons','as_pdf_p','GET',Lino.get_current_grid_config), "text": "Tabelle (Hochformat)", "overflowText": "Tabelle (Hochformat)", "auto_save": true }, { "itemId": "print_labels", "menu_item_text": "Etiketten", "tooltip": "Generate mailing labels for these recipients", "panel_btn_handler": Lino.list_action_handler('/contacts/Persons','print_labels','GET',Lino.get_current_grid_config), "text": "Etiketten", "overflowText": "Etiketten", "auto_save": true } ], "iconCls": "x-tbar-pdf", "menu_item_text": "Tabelle (Querformat)" }, { "itemId": "export_excel", "menu_item_text": "Export to .xls", "tooltip": "Export this table as an .xls document", "panel_btn_handler": Lino.list_action_handler('/contacts/Persons','export_excel','GET',Lino.get_current_grid_config), "iconCls": "x-tbar-csv", "overflowText": "Export to .xls", "auto_save": true }, { "itemId": "insert", "menu_item_text": "Neu", "tooltip": "Neuen Datensatz erstellen", "panel_btn_handler": Lino.show_insert, "iconCls": "x-tbar-add", "overflowText": "Neu", "keycode": 44, "auto_save": true }, { "itemId": "detail", "menu_item_text": "Detail", "tooltip": "Detail-Fenster auf diesem Datensatz \u00f6ffnen", "panel_btn_handler": Lino.show_detail, "iconCls": "x-tbar-application_form", "overflowText": "Detail", "auto_save": true }, { "itemId": "delete_selected", "menu_item_text": "L\u00f6schen", "tooltip": "Diesen Datensatz l\u00f6schen", "panel_btn_handler": Lino.row_action_handler('delete_selected','GET',null), "iconCls": "x-tbar-delete", "overflowText": "L\u00f6schen", "keycode": 46, "auto_save": false } ],
  cell_edit : true,
  title : "Personen",
  page_length : 20,
  params_panel_hidden : true,
  stripeRows : true,
  disabled_actions_index : 42,
  ls_store_fields : [ { "name": "name_column" }, { "name": "address_column" }, { "name": "email" }, { "name": "phone" }, { "name": "gsm" }, { "type": "int", "name": "id" }, { "name": "language" }, 'languageHidden', { "name": "modified" }, { "name": "created" }, { "name": "country" }, 'countryHidden', { "name": "city" }, 'cityHidden', { "name": "zip_code" }, { "name": "region" }, 'regionHidden', { "name": "addr1" }, { "name": "street_prefix" }, { "name": "street" }, { "name": "street_no" }, { "name": "street_box" }, { "name": "addr2" }, { "name": "name" }, { "name": "url" }, { "name": "fax" }, { "name": "remarks" }, { "type": "boolean", "name": "is_obsolete" }, { "name": "activity" }, 'activityHidden', { "name": "client_contact_type" }, 'client_contact_typeHidden', { "name": "iban" }, { "name": "bic" }, { "name": "first_name" }, { "name": "middle_name" }, { "name": "last_name" }, { "name": "gender" }, 'genderHidden', { "name": "birth_date" }, { "name": "title" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 5,
  ls_grid_configs : [  ],
  content_type : 20,
  ls_id_property : "id",
  gc_name : 0,
  initComponent : function() {
    this.ls_detail_handler = Lino.contacts.Persons.detail;
    this.ls_insert_handler = Lino.contacts.Persons.insert;
    var ww = this.containing_window;
    var name_column_disp2916 = new Ext.form.DisplayField({ "disabled": true, "value": "<br/>", "always_enabled": true });
    var address_column_disp2917 = new Ext.form.DisplayField({ "disabled": true, "value": "<br/>", "always_enabled": true });
    var email2918 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 75 });
    var phone2919 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var gsm2920 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var id2921 = new Ext.form.NumberField({ "selectOnFocus": true });
    var language2922 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "allowBlank": false, "store": [ [ "de", "Deutsch" ], [ "fr", "Franz\u00f6sisch" ], [ "nl", "Niederl\u00e4ndisch" ] ] });
    var modified2923 = new Ext.form.DisplayField({ "disabled": true, "value": "<br>" });
    var created2924 = new Ext.form.DisplayField({ "disabled": true, "value": "<br>" });
    var country2925 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/contacts/Persons/country", "method": "GET" }) }), "pageSize": 20, "emptyText": "Land ausw\u00e4hlen..." });
    var city2926 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "forceSelection": false, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/contacts/Persons/city", "method": "GET" }) }), "pageSize": 20, "emptyText": "Ort ausw\u00e4hlen..." });
    var zip_code2927 = new Ext.form.TextField({ "selectOnFocus": true, "boxMinWidth": Lino.chars2width(10), "maxLength": 10 });
    var region2928 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/contacts/Persons/region", "method": "GET" }) }), "pageSize": 20, "emptyText": "Ort ausw\u00e4hlen..." });
    var addr12929 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var street_prefix2930 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var street2931 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var street_no2932 = new Ext.form.TextField({ "selectOnFocus": true, "boxMinWidth": Lino.chars2width(10), "maxLength": 10 });
    var street_box2933 = new Ext.form.TextField({ "selectOnFocus": true, "boxMinWidth": Lino.chars2width(10), "maxLength": 10 });
    var addr22934 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var name2935 = new Ext.form.TextField({ "selectOnFocus": true, "allowBlank": false, "maxLength": 200 });
    var url2936 = new Lino.URLField({ "selectOnFocus": true, "maxLength": 200 });
    var fax2937 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var remarks2938 = new Ext.form.TextArea({ "selectOnFocus": true, "growMax": 2000 });
    var is_obsolete2939 = new Ext.form.Checkbox({ "selectOnFocus": true, "checked": false });
    var activity2940 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/contacts/Persons/activity", "method": "GET" }) }), "pageSize": 20, "emptyText": "Beruf ausw\u00e4hlen..." });
    var client_contact_type2941 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/contacts/Persons/client_contact_type", "method": "GET" }) }), "pageSize": 20, "emptyText": "Klientenkontaktart ausw\u00e4hlen..." });
    var iban2942 = new Lino.UppercaseTextField({ "selectOnFocus": true, "maxLength": 34 });
    var bic2943 = new Lino.UppercaseTextField({ "selectOnFocus": true, "maxLength": 11 });
    var first_name2944 = new Ext.form.TextField({ "selectOnFocus": true, "allowBlank": false, "maxLength": 200 });
    var middle_name2945 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var last_name2946 = new Ext.form.TextField({ "selectOnFocus": true, "allowBlank": false, "maxLength": 200 });
    var gender2947 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "forceSelection": true, "store": [['','<br>']].concat(Lino.system.Genders) });
    var birth_date2948 = new Lino.IncompleteDateField({ "selectOnFocus": true });
    var title2949 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    this.before_row_edit = function(record) {
      city2926.setContextValue('country', record ? record.data['countryHidden'] : undefined);
      city2926.setContextValue('region', record ? record.data['regionHidden'] : undefined);
      region2928.setContextValue('country', record ? record.data['countryHidden'] : undefined);
    };
    this.onRender = function(ct, position) {
      country2925.on('change',Lino.chooser_handler(city2926,'country'));
      region2928.on('change',Lino.chooser_handler(city2926,'region'));
      country2925.on('change',Lino.chooser_handler(region2928,'country'));
      Lino.contacts.Persons.GridPanel.superclass.onRender.call(this, ct, position);
    }
    this.ls_columns = [ { "header": "Name", "colIndex": 0, "sortable": false, "dataIndex": "name_column", "width": Lino.chars2width(21), "editable": false }, { "header": "Adresse", "colIndex": 1, "sortable": false, "dataIndex": "address_column", "width": Lino.chars2width(31), "editable": false }, { "colIndex": 2, "sortable": true, "width": Lino.chars2width(22), "editable": true, "filter": { "type": "string" }, "header": "E-Mail", "editor": email2918, "dataIndex": "email" }, { "colIndex": 3, "sortable": true, "width": Lino.chars2width(11), "editable": true, "filter": { "type": "string" }, "header": "Telefon", "editor": phone2919, "dataIndex": "phone" }, { "colIndex": 4, "sortable": true, "width": Lino.chars2width(11), "editable": true, "filter": { "type": "string" }, "header": "GSM", "editor": gsm2920, "dataIndex": "gsm" }, new Lino.NullNumberColumn({ "colIndex": 5, "sortable": true, "format": "0", "editable": true, "filter": { "type": "numeric" }, "header": "ID", "editor": id2921, "width": Lino.chars2width(6), "dataIndex": "id" }), { "colIndex": 6, "sortable": true, "header": "Sprache", "editable": true, "tooltip": "Die Sprache, in der Dokumente ausgestellt werden sollen.", "filter": { "type": "string" }, "width": Lino.chars2width(11), "editor": language2922, "dataIndex": "language" }, { "header": "Bearbeitet", "colIndex": 7, "sortable": true, "dataIndex": "modified", "width": Lino.chars2width(17), "hidden": true, "editable": false }, { "header": "Erstellt", "colIndex": 8, "sortable": true, "dataIndex": "created", "width": Lino.chars2width(17), "hidden": true, "editable": false }, { "colIndex": 9, "sortable": true, "header": "Land", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('countryHidden','Lino.countries.Countries.detail'), "dataIndex": "country", "hidden": true, "editor": country2925 }, { "colIndex": 10, "sortable": true, "header": "Stadt", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "editor": city2926, "hidden": true, "dataIndex": "city" }, { "colIndex": 11, "sortable": true, "header": "Postleitzahl", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(12), "editor": zip_code2927, "hidden": true, "dataIndex": "zip_code" }, { "colIndex": 12, "sortable": true, "header": "Regierungsbezirk", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "editor": region2928, "hidden": true, "dataIndex": "region" }, { "colIndex": 13, "sortable": true, "header": "Adresszeile vor Stra\u00dfe", "editable": true, "tooltip": "Adresszeile vor Stra\u00dfe", "filter": { "type": "string" }, "width": Lino.chars2width(22), "editor": addr12929, "hidden": true, "dataIndex": "addr1" }, { "colIndex": 14, "sortable": true, "header": "Pr\u00e4fix Stra\u00dfe", "editable": true, "tooltip": "Text to print before name of street, but to ignore for sorting.", "filter": { "type": "string" }, "width": Lino.chars2width(22), "editor": street_prefix2930, "hidden": true, "dataIndex": "street_prefix" }, { "colIndex": 15, "sortable": true, "header": "Stra\u00dfe", "editable": true, "tooltip": "Name der Stra\u00dfe, ohne Hausnummer", "filter": { "type": "string" }, "width": Lino.chars2width(22), "editor": street2931, "hidden": true, "dataIndex": "street" }, { "colIndex": 16, "sortable": true, "header": "Nr.", "editable": true, "tooltip": "Hausnummer", "filter": { "type": "string" }, "width": Lino.chars2width(12), "editor": street_no2932, "hidden": true, "dataIndex": "street_no" }, { "colIndex": 17, "sortable": true, "header": "Box", "editable": true, "tooltip": "Text to print after street nuber on the same line.", "filter": { "type": "string" }, "width": Lino.chars2width(12), "editor": street_box2933, "hidden": true, "dataIndex": "street_box" }, { "colIndex": 18, "sortable": true, "header": "Adresszeile nach Stra\u00dfe", "editable": true, "tooltip": "Adresszeile nach Stra\u00dfe", "filter": { "type": "string" }, "width": Lino.chars2width(22), "editor": addr22934, "hidden": true, "dataIndex": "addr2" }, { "colIndex": 19, "sortable": true, "header": "Name", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "editor": name2935, "hidden": true, "dataIndex": "name" }, { "colIndex": 20, "sortable": true, "header": "URL", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "editor": url2936, "hidden": true, "dataIndex": "url" }, { "colIndex": 21, "sortable": true, "header": "Fax", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "editor": fax2937, "hidden": true, "dataIndex": "fax" }, { "colIndex": 22, "sortable": false, "header": "Bemerkungen", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(61), "editor": remarks2938, "hidden": true, "dataIndex": "remarks" }, { "colIndex": 23, "sortable": false, "xtype": "checkcolumn", "width": Lino.chars2width(11), "editable": true, "tooltip": "Altf\u00e4lle sind Partner, deren Stammdaten nicht mehr gepflegt werden und \nf\u00fcr neue Operationen nicht benutzt werden k\u00f6nnen.", "filter": { "type": "boolean" }, "header": "veraltet", "dataIndex": "is_obsolete", "hidden": true }, { "colIndex": 24, "sortable": true, "header": "Beruf", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "editor": activity2940, "hidden": true, "dataIndex": "activity" }, { "colIndex": 25, "sortable": true, "header": "Klientenkontaktart", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "editor": client_contact_type2941, "hidden": true, "dataIndex": "client_contact_type" }, { "colIndex": 26, "sortable": true, "header": "IBAN", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "renderer": Lino.iban_renderer, "hidden": true, "editor": iban2942, "dataIndex": "iban" }, { "colIndex": 27, "sortable": true, "header": "BIC", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(13), "editor": bic2943, "hidden": true, "dataIndex": "bic" }, { "colIndex": 28, "sortable": true, "header": "Vorname", "editable": true, "tooltip": "First or given name.", "filter": { "type": "string" }, "width": Lino.chars2width(22), "editor": first_name2944, "hidden": true, "dataIndex": "first_name" }, { "colIndex": 29, "sortable": true, "header": "Zwischenname", "editable": true, "tooltip": "Space-separated list of all middle names.", "filter": { "type": "string" }, "width": Lino.chars2width(22), "editor": middle_name2945, "hidden": true, "dataIndex": "middle_name" }, { "colIndex": 30, "sortable": true, "header": "Familienname", "editable": true, "tooltip": "Last name (family name).", "filter": { "type": "string" }, "width": Lino.chars2width(22), "editor": last_name2946, "hidden": true, "dataIndex": "last_name" }, { "colIndex": 31, "sortable": true, "header": "Geschlecht", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(12), "editor": gender2947, "hidden": true, "dataIndex": "gender" }, { "colIndex": 32, "sortable": true, "header": "Geburtsdatum", "editable": true, "tooltip": "Unkomplette Datumsangaben sind erlaubt, z.B. \"00.00.1980\" hei\u00dft \"irgendwann im Jahr 1980\", \"00.07.1980\" hei\u00dft \"im Juli 1980\"oder \"23.07.0000\" hei\u00dft \"an einem 23. Juli\".", "filter": { "type": "string" }, "width": Lino.chars2width(13), "editor": birth_date2948, "hidden": true, "dataIndex": "birth_date" }, { "colIndex": 33, "sortable": true, "header": "Anrede", "editable": true, "tooltip": "Text to print before allocation and name as part of the first address line.", "filter": { "type": "string" }, "width": Lino.chars2width(22), "editor": title2949, "hidden": true, "dataIndex": "title" } ];
    Lino.contacts.Persons.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.contacts.Persons.show_as_html = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/contacts/Persons", "GET", pk, "show_as_html", params, Lino.get_current_grid_config);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.contacts.Persons.as_pdf = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/contacts/Persons", "GET", pk, "as_pdf", params, Lino.get_current_grid_config);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.contacts.Persons.as_pdf_p = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/contacts/Persons", "GET", pk, "as_pdf_p", params, Lino.get_current_grid_config);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.contacts.Persons.print_labels = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/contacts/Persons", "GET", pk, "print_labels", params, Lino.get_current_grid_config);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.contacts.Persons.export_excel = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/contacts/Persons", "GET", pk, "export_excel", params, Lino.get_current_grid_config);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.contacts.Persons.submit_detail = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/contacts/Persons", "GET", pk, "submit_detail", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};

Lino.contacts.Persons.insertPanel = Ext.extend(Lino.contacts.Persons.InsertFormPanel,{
  empty_title: "Neu",
  hide_navigator: true,
  params_panel_hidden: true,
  save_action_name: "submit_insert",
  ls_bbar_actions: [ { "itemId": "submit_insert", "menu_item_text": "Erstellen", "tooltip": "Datensatz erstellen und dann im Detail-Fenster \u00f6ffnen", "panel_btn_handler": function(panel){panel.save()}, "text": "Erstellen", "overflowText": "Erstellen", "auto_save": false } ],
  ls_url: "/contacts/Persons",
  action_name: "insert",
  initComponent : function() {
    this.ls_detail_handler = Lino.contacts.Persons.detail;
    this.ls_insert_handler = Lino.contacts.Persons.insert;
    Lino.contacts.Persons.insertPanel.superclass.initComponent.call(this);
  }
});

Lino.contacts.Persons.insert = new Lino.WindowAction({ "draggable": true, "width": Lino.chars2width(60), "autoHeight": true, "maximizable": true, "modal": true, "maximized": false }, function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.contacts.Persons.insertPanel(p);
});
Lino.contacts.Persons.grid_put = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/contacts/Persons", "GET", pk, "grid_put", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.contacts.Persons.grid_post = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/contacts/Persons", "GET", pk, "grid_post", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.contacts.Persons.submit_insert = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/contacts/Persons", "GET", pk, "submit_insert", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};

Lino.contacts.Persons.detailPanel = Ext.extend(Lino.contacts.Persons.DetailFormPanel,{
  empty_title: "Detail",
  params_panel_hidden: true,
  save_action_name: "submit_detail",
  ls_bbar_actions: [ { "itemId": "submit_detail", "menu_item_text": "Speichern", "tooltip": "\u00c4nderungen in diesem Formular speichern", "panel_btn_handler": function(panel){panel.save()}, "iconCls": "x-tbar-disk", "overflowText": "Speichern", "auto_save": false }, { "itemId": "insert", "menu_item_text": "Neu", "tooltip": "Neuen Datensatz erstellen", "panel_btn_handler": Lino.show_insert, "iconCls": "x-tbar-add", "overflowText": "Neu", "keycode": 44, "auto_save": true }, { "itemId": "delete_selected", "menu_item_text": "L\u00f6schen", "tooltip": "Diesen Datensatz l\u00f6schen", "panel_btn_handler": Lino.row_action_handler('delete_selected','GET',null), "iconCls": "x-tbar-delete", "overflowText": "L\u00f6schen", "keycode": 46, "auto_save": false } ],
  ls_url: "/contacts/Persons",
  action_name: "detail",
  initComponent : function() {
    this.ls_detail_handler = Lino.contacts.Persons.detail;
    this.ls_insert_handler = Lino.contacts.Persons.insert;
    Lino.contacts.Persons.detailPanel.superclass.initComponent.call(this);
  }
});

Lino.contacts.Persons.detail = new Lino.WindowAction({  }, function(){
  var p = { "is_main_window": true };
  return new Lino.contacts.Persons.detailPanel(p);
});
Lino.contacts.Persons.delete_selected = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/contacts/Persons", "GET", pk, "delete_selected", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.contacts.Persons.grid = new Lino.WindowAction({  }, function(){
  var p = { "is_main_window": true };
  p.params_panel = new Lino.contacts.Persons.ParamsPanel({});
  return new Lino.contacts.Persons.GridPanel(p);
});
Lino.contacts.Persons.validate = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/contacts/Persons", "GET", pk, "validate", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};

// js_render_GridPanel_class contacts.Companies
Lino.contacts.Companies.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "Keine Daten anzuzeigen." },
  ls_url : "/contacts/Companies",
  ls_bbar_actions : [ { "itemId": "show_as_html", "menu_item_text": "HTML", "tooltip": "Show this table in Bootstrap3 interface", "panel_btn_handler": Lino.list_action_handler('/contacts/Companies','show_as_html','GET',Lino.get_current_grid_config), "iconCls": "x-tbar-html", "overflowText": "HTML", "auto_save": true }, { "panel_btn_handler": Lino.list_action_handler('/contacts/Companies','as_pdf','GET',Lino.get_current_grid_config), "xtype": "splitbutton", "text": null, "menu": [ { "itemId": "as_pdf", "menu_item_text": "Tabelle (Querformat)", "tooltip": "Diese Tabelle in eine .pdf-Datei exportieren", "panel_btn_handler": Lino.list_action_handler('/contacts/Companies','as_pdf','GET',Lino.get_current_grid_config), "text": "Tabelle (Querformat)", "overflowText": "Tabelle (Querformat)", "auto_save": true }, { "itemId": "as_pdf_p", "menu_item_text": "Tabelle (Hochformat)", "tooltip": "Diese Tabelle in eine .pdf-Datei exportieren", "panel_btn_handler": Lino.list_action_handler('/contacts/Companies','as_pdf_p','GET',Lino.get_current_grid_config), "text": "Tabelle (Hochformat)", "overflowText": "Tabelle (Hochformat)", "auto_save": true }, { "itemId": "print_labels", "menu_item_text": "Etiketten", "tooltip": "Generate mailing labels for these recipients", "panel_btn_handler": Lino.list_action_handler('/contacts/Companies','print_labels','GET',Lino.get_current_grid_config), "text": "Etiketten", "overflowText": "Etiketten", "auto_save": true } ], "iconCls": "x-tbar-pdf", "menu_item_text": "Tabelle (Querformat)" }, { "itemId": "export_excel", "menu_item_text": "Export to .xls", "tooltip": "Export this table as an .xls document", "panel_btn_handler": Lino.list_action_handler('/contacts/Companies','export_excel','GET',Lino.get_current_grid_config), "iconCls": "x-tbar-csv", "overflowText": "Export to .xls", "auto_save": true }, { "itemId": "insert", "menu_item_text": "Neu", "tooltip": "Neuen Datensatz erstellen", "panel_btn_handler": Lino.show_insert, "iconCls": "x-tbar-add", "overflowText": "Neu", "keycode": 44, "auto_save": true }, { "itemId": "detail", "menu_item_text": "Detail", "tooltip": "Detail-Fenster auf diesem Datensatz \u00f6ffnen", "panel_btn_handler": Lino.show_detail, "iconCls": "x-tbar-application_form", "overflowText": "Detail", "auto_save": true }, { "itemId": "delete_selected", "menu_item_text": "L\u00f6schen", "tooltip": "Diesen Datensatz l\u00f6schen", "panel_btn_handler": Lino.row_action_handler('delete_selected','GET',null), "iconCls": "x-tbar-delete", "overflowText": "L\u00f6schen", "keycode": 46, "auto_save": false } ],
  cell_edit : true,
  title : "Organisationen",
  page_length : 20,
  stripeRows : true,
  disabled_actions_index : 39,
  ls_store_fields : [ { "name": "name_column" }, { "name": "address_column" }, { "name": "email" }, { "name": "phone" }, { "name": "gsm" }, { "type": "int", "name": "id" }, { "name": "language" }, 'languageHidden', { "name": "modified" }, { "name": "created" }, { "name": "country" }, 'countryHidden', { "name": "city" }, 'cityHidden', { "name": "zip_code" }, { "name": "region" }, 'regionHidden', { "name": "addr1" }, { "name": "street_prefix" }, { "name": "street" }, { "name": "street_no" }, { "name": "street_box" }, { "name": "addr2" }, { "name": "name" }, { "name": "url" }, { "name": "fax" }, { "name": "remarks" }, { "type": "boolean", "name": "is_obsolete" }, { "name": "activity" }, 'activityHidden', { "name": "client_contact_type" }, 'client_contact_typeHidden', { "name": "iban" }, { "name": "bic" }, { "name": "prefix" }, { "name": "type" }, 'typeHidden', { "name": "vat_id" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 5,
  ls_grid_configs : [  ],
  content_type : 20,
  ls_id_property : "id",
  gc_name : 0,
  initComponent : function() {
    this.ls_detail_handler = Lino.contacts.Companies.detail;
    this.ls_insert_handler = Lino.contacts.Companies.insert;
    var ww = this.containing_window;
    var name_column_disp2951 = new Ext.form.DisplayField({ "disabled": true, "value": "<br/>", "always_enabled": true });
    var address_column_disp2952 = new Ext.form.DisplayField({ "disabled": true, "value": "<br/>", "always_enabled": true });
    var email2953 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 75 });
    var phone2954 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var gsm2955 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var id2956 = new Ext.form.NumberField({ "selectOnFocus": true });
    var language2957 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "allowBlank": false, "store": [ [ "de", "Deutsch" ], [ "fr", "Franz\u00f6sisch" ], [ "nl", "Niederl\u00e4ndisch" ] ] });
    var modified2958 = new Ext.form.DisplayField({ "disabled": true, "value": "<br>" });
    var created2959 = new Ext.form.DisplayField({ "disabled": true, "value": "<br>" });
    var country2960 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/contacts/Companies/country", "method": "GET" }) }), "pageSize": 20, "emptyText": "Land ausw\u00e4hlen..." });
    var city2961 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "forceSelection": false, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/contacts/Companies/city", "method": "GET" }) }), "pageSize": 20, "emptyText": "Ort ausw\u00e4hlen..." });
    var zip_code2962 = new Ext.form.TextField({ "selectOnFocus": true, "boxMinWidth": Lino.chars2width(10), "maxLength": 10 });
    var region2963 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/contacts/Companies/region", "method": "GET" }) }), "pageSize": 20, "emptyText": "Ort ausw\u00e4hlen..." });
    var addr12964 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var street_prefix2965 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var street2966 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var street_no2967 = new Ext.form.TextField({ "selectOnFocus": true, "boxMinWidth": Lino.chars2width(10), "maxLength": 10 });
    var street_box2968 = new Ext.form.TextField({ "selectOnFocus": true, "boxMinWidth": Lino.chars2width(10), "maxLength": 10 });
    var addr22969 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var name2970 = new Ext.form.TextField({ "selectOnFocus": true, "allowBlank": false, "maxLength": 200 });
    var url2971 = new Lino.URLField({ "selectOnFocus": true, "maxLength": 200 });
    var fax2972 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var remarks2973 = new Ext.form.TextArea({ "selectOnFocus": true, "growMax": 2000 });
    var is_obsolete2974 = new Ext.form.Checkbox({ "selectOnFocus": true, "checked": false });
    var activity2975 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/contacts/Companies/activity", "method": "GET" }) }), "pageSize": 20, "emptyText": "Beruf ausw\u00e4hlen..." });
    var client_contact_type2976 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/contacts/Companies/client_contact_type", "method": "GET" }) }), "pageSize": 20, "emptyText": "Klientenkontaktart ausw\u00e4hlen..." });
    var iban2977 = new Lino.UppercaseTextField({ "selectOnFocus": true, "maxLength": 34 });
    var bic2978 = new Lino.UppercaseTextField({ "selectOnFocus": true, "maxLength": 11 });
    var prefix2979 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var type2980 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/contacts/Companies/type", "method": "GET" }) }), "pageSize": 20, "emptyText": "Organisationsart ausw\u00e4hlen..." });
    var vat_id2981 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    this.before_row_edit = function(record) {
      city2961.setContextValue('country', record ? record.data['countryHidden'] : undefined);
      city2961.setContextValue('region', record ? record.data['regionHidden'] : undefined);
      region2963.setContextValue('country', record ? record.data['countryHidden'] : undefined);
    };
    this.onRender = function(ct, position) {
      country2960.on('change',Lino.chooser_handler(city2961,'country'));
      region2963.on('change',Lino.chooser_handler(city2961,'region'));
      country2960.on('change',Lino.chooser_handler(region2963,'country'));
      Lino.contacts.Companies.GridPanel.superclass.onRender.call(this, ct, position);
    }
    this.ls_columns = [ { "header": "Name", "colIndex": 0, "sortable": false, "dataIndex": "name_column", "width": Lino.chars2width(21), "editable": false }, { "header": "Adresse", "colIndex": 1, "sortable": false, "dataIndex": "address_column", "width": Lino.chars2width(31), "editable": false }, { "colIndex": 2, "sortable": true, "width": Lino.chars2width(22), "editable": true, "filter": { "type": "string" }, "header": "E-Mail", "editor": email2953, "dataIndex": "email" }, { "colIndex": 3, "sortable": true, "width": Lino.chars2width(11), "editable": true, "filter": { "type": "string" }, "header": "Telefon", "editor": phone2954, "dataIndex": "phone" }, { "colIndex": 4, "sortable": true, "width": Lino.chars2width(11), "editable": true, "filter": { "type": "string" }, "header": "GSM", "editor": gsm2955, "dataIndex": "gsm" }, new Lino.NullNumberColumn({ "colIndex": 5, "sortable": true, "format": "0", "editable": true, "filter": { "type": "numeric" }, "header": "ID", "editor": id2956, "width": Lino.chars2width(6), "dataIndex": "id" }), { "colIndex": 6, "sortable": true, "header": "Sprache", "editable": true, "tooltip": "Die Sprache, in der Dokumente ausgestellt werden sollen.", "filter": { "type": "string" }, "width": Lino.chars2width(11), "editor": language2957, "dataIndex": "language" }, { "header": "Bearbeitet", "colIndex": 7, "sortable": true, "dataIndex": "modified", "width": Lino.chars2width(17), "hidden": true, "editable": false }, { "header": "Erstellt", "colIndex": 8, "sortable": true, "dataIndex": "created", "width": Lino.chars2width(17), "hidden": true, "editable": false }, { "colIndex": 9, "sortable": true, "header": "Land", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('countryHidden','Lino.countries.Countries.detail'), "dataIndex": "country", "hidden": true, "editor": country2960 }, { "colIndex": 10, "sortable": true, "header": "Stadt", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "editor": city2961, "hidden": true, "dataIndex": "city" }, { "colIndex": 11, "sortable": true, "header": "Postleitzahl", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(12), "editor": zip_code2962, "hidden": true, "dataIndex": "zip_code" }, { "colIndex": 12, "sortable": true, "header": "Regierungsbezirk", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "editor": region2963, "hidden": true, "dataIndex": "region" }, { "colIndex": 13, "sortable": true, "header": "Adresszeile vor Stra\u00dfe", "editable": true, "tooltip": "Adresszeile vor Stra\u00dfe", "filter": { "type": "string" }, "width": Lino.chars2width(22), "editor": addr12964, "hidden": true, "dataIndex": "addr1" }, { "colIndex": 14, "sortable": true, "header": "Pr\u00e4fix Stra\u00dfe", "editable": true, "tooltip": "Text to print before name of street, but to ignore for sorting.", "filter": { "type": "string" }, "width": Lino.chars2width(22), "editor": street_prefix2965, "hidden": true, "dataIndex": "street_prefix" }, { "colIndex": 15, "sortable": true, "header": "Stra\u00dfe", "editable": true, "tooltip": "Name der Stra\u00dfe, ohne Hausnummer", "filter": { "type": "string" }, "width": Lino.chars2width(22), "editor": street2966, "hidden": true, "dataIndex": "street" }, { "colIndex": 16, "sortable": true, "header": "Nr.", "editable": true, "tooltip": "Hausnummer", "filter": { "type": "string" }, "width": Lino.chars2width(12), "editor": street_no2967, "hidden": true, "dataIndex": "street_no" }, { "colIndex": 17, "sortable": true, "header": "Box", "editable": true, "tooltip": "Text to print after street nuber on the same line.", "filter": { "type": "string" }, "width": Lino.chars2width(12), "editor": street_box2968, "hidden": true, "dataIndex": "street_box" }, { "colIndex": 18, "sortable": true, "header": "Adresszeile nach Stra\u00dfe", "editable": true, "tooltip": "Adresszeile nach Stra\u00dfe", "filter": { "type": "string" }, "width": Lino.chars2width(22), "editor": addr22969, "hidden": true, "dataIndex": "addr2" }, { "colIndex": 19, "sortable": true, "header": "Name", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "editor": name2970, "hidden": true, "dataIndex": "name" }, { "colIndex": 20, "sortable": true, "header": "URL", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "editor": url2971, "hidden": true, "dataIndex": "url" }, { "colIndex": 21, "sortable": true, "header": "Fax", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "editor": fax2972, "hidden": true, "dataIndex": "fax" }, { "colIndex": 22, "sortable": false, "header": "Bemerkungen", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(61), "editor": remarks2973, "hidden": true, "dataIndex": "remarks" }, { "colIndex": 23, "sortable": false, "xtype": "checkcolumn", "width": Lino.chars2width(11), "editable": true, "tooltip": "Altf\u00e4lle sind Partner, deren Stammdaten nicht mehr gepflegt werden und \nf\u00fcr neue Operationen nicht benutzt werden k\u00f6nnen.", "filter": { "type": "boolean" }, "header": "veraltet", "dataIndex": "is_obsolete", "hidden": true }, { "colIndex": 24, "sortable": true, "header": "Beruf", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "editor": activity2975, "hidden": true, "dataIndex": "activity" }, { "colIndex": 25, "sortable": true, "header": "Klientenkontaktart", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "editor": client_contact_type2976, "hidden": true, "dataIndex": "client_contact_type" }, { "colIndex": 26, "sortable": true, "header": "IBAN", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "renderer": Lino.iban_renderer, "hidden": true, "editor": iban2977, "dataIndex": "iban" }, { "colIndex": 27, "sortable": true, "header": "BIC", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(13), "editor": bic2978, "hidden": true, "dataIndex": "bic" }, { "colIndex": 28, "sortable": true, "header": "Name prefix", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "editor": prefix2979, "hidden": true, "dataIndex": "prefix" }, { "colIndex": 29, "sortable": true, "header": "Organisationsart", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "editor": type2980, "hidden": true, "dataIndex": "type" }, { "colIndex": 30, "sortable": true, "header": "MWSt.-Nr.", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "editor": vat_id2981, "hidden": true, "dataIndex": "vat_id" } ];
    Lino.contacts.Companies.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.contacts.Companies.show_as_html = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/contacts/Companies", "GET", pk, "show_as_html", params, Lino.get_current_grid_config);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.contacts.Companies.as_pdf = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/contacts/Companies", "GET", pk, "as_pdf", params, Lino.get_current_grid_config);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.contacts.Companies.as_pdf_p = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/contacts/Companies", "GET", pk, "as_pdf_p", params, Lino.get_current_grid_config);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.contacts.Companies.print_labels = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/contacts/Companies", "GET", pk, "print_labels", params, Lino.get_current_grid_config);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.contacts.Companies.export_excel = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/contacts/Companies", "GET", pk, "export_excel", params, Lino.get_current_grid_config);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.contacts.Companies.submit_detail = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/contacts/Companies", "GET", pk, "submit_detail", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};

Lino.contacts.Companies.insertPanel = Ext.extend(Lino.contacts.Companies.InsertFormPanel,{
  empty_title: "Neu",
  hide_navigator: true,
  save_action_name: "submit_insert",
  ls_bbar_actions: [ { "itemId": "submit_insert", "menu_item_text": "Erstellen", "tooltip": "Datensatz erstellen und dann im Detail-Fenster \u00f6ffnen", "panel_btn_handler": function(panel){panel.save()}, "text": "Erstellen", "overflowText": "Erstellen", "auto_save": false } ],
  ls_url: "/contacts/Companies",
  action_name: "insert",
  initComponent : function() {
    this.ls_detail_handler = Lino.contacts.Companies.detail;
    this.ls_insert_handler = Lino.contacts.Companies.insert;
    Lino.contacts.Companies.insertPanel.superclass.initComponent.call(this);
  }
});

Lino.contacts.Companies.insert = new Lino.WindowAction({ "draggable": true, "width": Lino.chars2width(60), "autoHeight": true, "maximizable": true, "modal": true, "maximized": false }, function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.contacts.Companies.insertPanel(p);
});
Lino.contacts.Companies.grid_put = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/contacts/Companies", "GET", pk, "grid_put", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.contacts.Companies.grid_post = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/contacts/Companies", "GET", pk, "grid_post", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.contacts.Companies.submit_insert = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/contacts/Companies", "GET", pk, "submit_insert", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};

Lino.contacts.Companies.detailPanel = Ext.extend(Lino.contacts.Companies.DetailFormPanel,{
  empty_title: "Detail",
  save_action_name: "submit_detail",
  ls_bbar_actions: [ { "itemId": "submit_detail", "menu_item_text": "Speichern", "tooltip": "\u00c4nderungen in diesem Formular speichern", "panel_btn_handler": function(panel){panel.save()}, "iconCls": "x-tbar-disk", "overflowText": "Speichern", "auto_save": false }, { "itemId": "insert", "menu_item_text": "Neu", "tooltip": "Neuen Datensatz erstellen", "panel_btn_handler": Lino.show_insert, "iconCls": "x-tbar-add", "overflowText": "Neu", "keycode": 44, "auto_save": true }, { "itemId": "delete_selected", "menu_item_text": "L\u00f6schen", "tooltip": "Diesen Datensatz l\u00f6schen", "panel_btn_handler": Lino.row_action_handler('delete_selected','GET',null), "iconCls": "x-tbar-delete", "overflowText": "L\u00f6schen", "keycode": 46, "auto_save": false } ],
  ls_url: "/contacts/Companies",
  action_name: "detail",
  initComponent : function() {
    this.ls_detail_handler = Lino.contacts.Companies.detail;
    this.ls_insert_handler = Lino.contacts.Companies.insert;
    Lino.contacts.Companies.detailPanel.superclass.initComponent.call(this);
  }
});

Lino.contacts.Companies.detail = new Lino.WindowAction({  }, function(){
  var p = { "is_main_window": true };
  return new Lino.contacts.Companies.detailPanel(p);
});
Lino.contacts.Companies.delete_selected = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/contacts/Companies", "GET", pk, "delete_selected", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.contacts.Companies.grid = new Lino.WindowAction({  }, function(){
  var p = { "is_main_window": true };
  return new Lino.contacts.Companies.GridPanel(p);
});
Lino.contacts.Companies.validate = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/contacts/Companies", "GET", pk, "validate", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};

// js_render_GridPanel_class uploads.AreaUploads
Lino.uploads.AreaUploads.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "Keine Daten anzuzeigen." },
  ls_url : "/uploads/AreaUploads",
  ls_bbar_actions : [ { "itemId": "show_as_html", "menu_item_text": "HTML", "tooltip": "Show this table in Bootstrap3 interface", "panel_btn_handler": Lino.list_action_handler('/uploads/AreaUploads','show_as_html','GET',Lino.get_current_grid_config), "iconCls": "x-tbar-html", "overflowText": "HTML", "auto_save": true }, { "panel_btn_handler": Lino.list_action_handler('/uploads/AreaUploads','as_pdf','GET',Lino.get_current_grid_config), "xtype": "splitbutton", "text": null, "menu": [ { "itemId": "as_pdf", "menu_item_text": "Tabelle (Querformat)", "tooltip": "Diese Tabelle in eine .pdf-Datei exportieren", "panel_btn_handler": Lino.list_action_handler('/uploads/AreaUploads','as_pdf','GET',Lino.get_current_grid_config), "text": "Tabelle (Querformat)", "overflowText": "Tabelle (Querformat)", "auto_save": true }, { "itemId": "as_pdf_p", "menu_item_text": "Tabelle (Hochformat)", "tooltip": "Diese Tabelle in eine .pdf-Datei exportieren", "panel_btn_handler": Lino.list_action_handler('/uploads/AreaUploads','as_pdf_p','GET',Lino.get_current_grid_config), "text": "Tabelle (Hochformat)", "overflowText": "Tabelle (Hochformat)", "auto_save": true } ], "iconCls": "x-tbar-pdf", "menu_item_text": "Tabelle (Querformat)" }, { "itemId": "export_excel", "menu_item_text": "Export to .xls", "tooltip": "Export this table as an .xls document", "panel_btn_handler": Lino.list_action_handler('/uploads/AreaUploads','export_excel','GET',Lino.get_current_grid_config), "iconCls": "x-tbar-csv", "overflowText": "Export to .xls", "auto_save": true }, { "itemId": "insert", "menu_item_text": "Neu", "tooltip": "Neuen Datensatz erstellen", "panel_btn_handler": Lino.show_insert, "iconCls": "x-tbar-add", "overflowText": "Neu", "keycode": 44, "auto_save": true }, { "itemId": "detail", "menu_item_text": "Detail", "tooltip": "Detail-Fenster auf diesem Datensatz \u00f6ffnen", "panel_btn_handler": Lino.show_detail, "iconCls": "x-tbar-application_form", "overflowText": "Detail", "auto_save": true }, { "itemId": "delete_selected", "menu_item_text": "L\u00f6schen", "tooltip": "Diesen Datensatz l\u00f6schen", "panel_btn_handler": Lino.row_action_handler('delete_selected','GET',null), "iconCls": "x-tbar-delete", "overflowText": "L\u00f6schen", "keycode": 46, "auto_save": false } ],
  cell_edit : true,
  title : "Uploads",
  page_length : 20,
  stripeRows : true,
  disabled_actions_index : 27,
  ls_store_fields : [ { "name": "file" }, { "name": "type" }, 'typeHidden', { "name": "user" }, 'userHidden', { "name": "owner" }, { "name": "description" }, { "type": "int", "name": "id" }, { "name": "project" }, 'projectHidden', { "name": "mimetype" }, { "name": "owner_type" }, 'owner_typeHidden', { "name": "owner_id" }, 'owner_idHidden', { "name": "company" }, 'companyHidden', { "name": "contact_person" }, 'contact_personHidden', { "name": "contact_role" }, 'contact_roleHidden', { "name": "upload_area" }, 'upload_areaHidden', { "type": "date", "name": "valid_from", "dateFormat": "d.m.Y" }, { "type": "date", "name": "valid_until", "dateFormat": "d.m.Y" }, { "name": "remark" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 7,
  ls_grid_configs : [  ],
  content_type : 24,
  ls_id_property : "id",
  gc_name : 0,
  initComponent : function() {
    this.ls_detail_handler = Lino.uploads.AreaUploads.detail;
    this.ls_insert_handler = Lino.uploads.AreaUploads.insert;
    var ww = this.containing_window;
    var file2983 = Lino.file_field_handler(this,{ "selectOnFocus": true, "maxLength": 100 });
    var type2984 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/uploads/AreaUploads/type", "method": "GET" }) }), "pageSize": 20, "emptyText": "Upload-Art ausw\u00e4hlen..." });
    var user2985 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "preferred_width": 15, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/uploads/AreaUploads/user", "method": "GET" }) }), "pageSize": 20, "emptyText": "Benutzer ausw\u00e4hlen..." });
    var owner_disp2986 = new Ext.form.DisplayField({ "disabled": true });
    var description2987 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var id2988 = new Ext.form.NumberField({ "selectOnFocus": true });
    var project2989 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "preferred_width": 20, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/uploads/AreaUploads/project", "method": "GET" }) }), "pageSize": 20, "emptyText": "Klient ausw\u00e4hlen..." });
    var mimetype2990 = new Ext.form.TextField({ "disabled": true, "maxLength": 64 });
    var owner_type2991 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/uploads/AreaUploads/owner_type", "method": "GET" }) }), "pageSize": 20, "emptyText": "Datenbankmodell ausw\u00e4hlen..." });
    var owner_id2992 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/uploads/AreaUploads/owner_id", "method": "GET" }) }) });
    var company2993 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "preferred_width": 20, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/uploads/AreaUploads/company", "method": "GET" }) }), "pageSize": 20, "emptyText": "Organisation ausw\u00e4hlen..." });
    var contact_person2994 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "preferred_width": 20, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/uploads/AreaUploads/contact_person", "method": "GET" }) }), "pageSize": 20, "emptyText": "Person ausw\u00e4hlen..." });
    var contact_role2995 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/uploads/AreaUploads/contact_role", "method": "GET" }) }), "pageSize": 20, "emptyText": "Funktion ausw\u00e4hlen..." });
    var upload_area2996 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "forceSelection": true, "allowBlank": false, "store": Lino.uploads.UploadAreas });
    var valid_from2997 = new Lino.DateField({ "selectOnFocus": true });
    var valid_until2998 = new Lino.DateField({ "selectOnFocus": true });
    var remark2999 = new Ext.form.TextArea({ "selectOnFocus": true, "growMax": 2000 });
    this.before_row_edit = function(record) {
      type2984.setContextValue('upload_area', record ? record.data['upload_areaHidden'] : undefined);
      contact_person2994.setContextValue('company', record ? record.data['companyHidden'] : undefined);
    };
    this.onRender = function(ct, position) {
      upload_area2996.on('change',Lino.chooser_handler(type2984,'upload_area'));
      company2993.on('change',Lino.chooser_handler(contact_person2994,'company'));
      Lino.uploads.AreaUploads.GridPanel.superclass.onRender.call(this, ct, position);
    }
    this.ls_columns = [ { "colIndex": 0, "sortable": true, "width": Lino.chars2width(22), "editable": true, "filter": { "type": "string" }, "header": "Datei", "editor": file2983, "dataIndex": "file" }, { "colIndex": 1, "sortable": true, "width": Lino.chars2width(21), "editable": true, "filter": { "type": "string" }, "header": "Upload-Art", "editor": type2984, "dataIndex": "type" }, { "colIndex": 2, "sortable": true, "width": Lino.chars2width(21), "editable": true, "filter": { "type": "string" }, "header": "Autor", "editor": user2985, "dataIndex": "user" }, { "header": "Verkn\u00fcpft mit", "colIndex": 3, "sortable": false, "dataIndex": "owner", "width": Lino.chars2width(11), "editable": false }, { "colIndex": 4, "sortable": true, "width": Lino.chars2width(22), "editable": true, "filter": { "type": "string" }, "header": "Beschreibung", "editor": description2987, "dataIndex": "description" }, new Lino.NullNumberColumn({ "colIndex": 5, "sortable": true, "format": "0", "editable": true, "filter": { "type": "numeric" }, "header": "ID", "editor": id2988, "hidden": true, "width": Lino.chars2width(6), "dataIndex": "id" }), { "colIndex": 6, "sortable": true, "header": "Klient", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('projectHidden','Lino.pcsw.Clients.detail'), "dataIndex": "project", "hidden": true, "editor": project2989 }, { "colIndex": 7, "sortable": true, "width": Lino.chars2width(22), "editable": false, "filter": { "type": "string" }, "header": "MIME-Art", "dataIndex": "mimetype", "hidden": true }, { "colIndex": 8, "sortable": true, "header": "Verkn\u00fcpft mit (Modell)", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "editor": owner_type2991, "hidden": true, "dataIndex": "owner_type" }, { "colIndex": 9, "sortable": true, "header": "Verkn\u00fcpft mit (Objekt)", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(11), "editor": owner_id2992, "hidden": true, "dataIndex": "owner_id" }, { "colIndex": 10, "sortable": true, "header": "Issued by (Organization)", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('companyHidden','Lino.contacts.Companies.detail'), "dataIndex": "company", "hidden": true, "editor": company2993 }, { "colIndex": 11, "sortable": true, "header": "Issued by (Person)", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('contact_personHidden','Lino.contacts.Persons.detail'), "dataIndex": "contact_person", "hidden": true, "editor": contact_person2994 }, { "colIndex": 12, "sortable": true, "header": "in seiner Eigenschaft als", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "editor": contact_role2995, "hidden": true, "dataIndex": "contact_role" }, { "colIndex": 13, "sortable": true, "header": "Upload-Bereich", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(11), "editor": upload_area2996, "hidden": true, "dataIndex": "upload_area" }, { "colIndex": 14, "sortable": true, "xtype": "datecolumn", "format": "d.m.Y", "editable": true, "filter": { "type": "date", "dateFormat": "d.m.Y" }, "header": "G\u00fcltig von", "editor": valid_from2997, "hidden": true, "width": Lino.chars2width(14), "dataIndex": "valid_from" }, { "colIndex": 15, "sortable": true, "xtype": "datecolumn", "format": "d.m.Y", "editable": true, "filter": { "type": "date", "dateFormat": "d.m.Y" }, "header": "G\u00fcltig bis", "editor": valid_until2998, "hidden": true, "width": Lino.chars2width(14), "dataIndex": "valid_until" }, { "colIndex": 16, "sortable": false, "header": "Bemerkung", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(61), "editor": remark2999, "hidden": true, "dataIndex": "remark" } ];
    Lino.uploads.AreaUploads.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.uploads.AreaUploads.show_as_html = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/uploads/AreaUploads", "GET", pk, "show_as_html", params, Lino.get_current_grid_config);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.uploads.AreaUploads.as_pdf = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/uploads/AreaUploads", "GET", pk, "as_pdf", params, Lino.get_current_grid_config);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.uploads.AreaUploads.as_pdf_p = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/uploads/AreaUploads", "GET", pk, "as_pdf_p", params, Lino.get_current_grid_config);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.uploads.AreaUploads.export_excel = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/uploads/AreaUploads", "GET", pk, "export_excel", params, Lino.get_current_grid_config);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.uploads.AreaUploads.submit_detail = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/uploads/AreaUploads", "GET", pk, "submit_detail", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};

Lino.uploads.AreaUploads.insertPanel = Ext.extend(Lino.uploads.AreaUploads.InsertFormPanel,{
  empty_title: "Neu",
  hide_navigator: true,
  save_action_name: "submit_insert",
  ls_bbar_actions: [ { "itemId": "submit_insert", "menu_item_text": "Erstellen", "tooltip": "Datensatz erstellen und dann im Detail-Fenster \u00f6ffnen", "panel_btn_handler": function(panel){panel.save()}, "text": "Erstellen", "overflowText": "Erstellen", "auto_save": false } ],
  ls_url: "/uploads/AreaUploads",
  action_name: "insert",
  initComponent : function() {
    this.ls_detail_handler = Lino.uploads.AreaUploads.detail;
    this.ls_insert_handler = Lino.uploads.AreaUploads.insert;
    Lino.uploads.AreaUploads.insertPanel.superclass.initComponent.call(this);
  }
});

Lino.uploads.AreaUploads.insert = new Lino.WindowAction({ "draggable": true, "width": Lino.chars2width(60), "autoHeight": true, "maximizable": true, "modal": true, "maximized": false }, function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.uploads.AreaUploads.insertPanel(p);
});
Lino.uploads.AreaUploads.grid_put = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/uploads/AreaUploads", "GET", pk, "grid_put", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.uploads.AreaUploads.grid_post = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/uploads/AreaUploads", "GET", pk, "grid_post", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.uploads.AreaUploads.submit_insert = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/uploads/AreaUploads", "GET", pk, "submit_insert", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};

Lino.uploads.AreaUploads.detailPanel = Ext.extend(Lino.uploads.AreaUploads.DetailFormPanel,{
  empty_title: "Detail",
  save_action_name: "submit_detail",
  ls_bbar_actions: [ { "itemId": "submit_detail", "menu_item_text": "Speichern", "tooltip": "\u00c4nderungen in diesem Formular speichern", "panel_btn_handler": function(panel){panel.save()}, "iconCls": "x-tbar-disk", "overflowText": "Speichern", "auto_save": false }, { "itemId": "insert", "menu_item_text": "Neu", "tooltip": "Neuen Datensatz erstellen", "panel_btn_handler": Lino.show_insert, "iconCls": "x-tbar-add", "overflowText": "Neu", "keycode": 44, "auto_save": true }, { "itemId": "delete_selected", "menu_item_text": "L\u00f6schen", "tooltip": "Diesen Datensatz l\u00f6schen", "panel_btn_handler": Lino.row_action_handler('delete_selected','GET',null), "iconCls": "x-tbar-delete", "overflowText": "L\u00f6schen", "keycode": 46, "auto_save": false } ],
  ls_url: "/uploads/AreaUploads",
  action_name: "detail",
  initComponent : function() {
    this.ls_detail_handler = Lino.uploads.AreaUploads.detail;
    this.ls_insert_handler = Lino.uploads.AreaUploads.insert;
    Lino.uploads.AreaUploads.detailPanel.superclass.initComponent.call(this);
  }
});

Lino.uploads.AreaUploads.detail = new Lino.WindowAction({  }, function(){
  var p = { "is_main_window": true };
  return new Lino.uploads.AreaUploads.detailPanel(p);
});
Lino.uploads.AreaUploads.delete_selected = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/uploads/AreaUploads", "GET", pk, "delete_selected", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.uploads.AreaUploads.grid = new Lino.WindowAction({  }, function(){
  var p = { "is_main_window": true };
  return new Lino.uploads.AreaUploads.GridPanel(p);
});
Lino.uploads.AreaUploads.validate = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/uploads/AreaUploads", "GET", pk, "validate", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};

// js_render_GridPanel_class extensible.PanelCalendars
Lino.extensible.PanelCalendars.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "Keine Daten anzuzeigen." },
  ls_url : "/extensible/PanelCalendars",
  ls_bbar_actions : [ { "itemId": "show_as_html", "menu_item_text": "HTML", "tooltip": "Show this table in Bootstrap3 interface", "panel_btn_handler": Lino.list_action_handler('/extensible/PanelCalendars','show_as_html','GET',Lino.get_current_grid_config), "iconCls": "x-tbar-html", "overflowText": "HTML", "auto_save": true }, { "panel_btn_handler": Lino.list_action_handler('/extensible/PanelCalendars','as_pdf','GET',Lino.get_current_grid_config), "xtype": "splitbutton", "text": null, "menu": [ { "itemId": "as_pdf", "menu_item_text": "Tabelle (Querformat)", "tooltip": "Diese Tabelle in eine .pdf-Datei exportieren", "panel_btn_handler": Lino.list_action_handler('/extensible/PanelCalendars','as_pdf','GET',Lino.get_current_grid_config), "text": "Tabelle (Querformat)", "overflowText": "Tabelle (Querformat)", "auto_save": true }, { "itemId": "as_pdf_p", "menu_item_text": "Tabelle (Hochformat)", "tooltip": "Diese Tabelle in eine .pdf-Datei exportieren", "panel_btn_handler": Lino.list_action_handler('/extensible/PanelCalendars','as_pdf_p','GET',Lino.get_current_grid_config), "text": "Tabelle (Hochformat)", "overflowText": "Tabelle (Hochformat)", "auto_save": true } ], "iconCls": "x-tbar-pdf", "menu_item_text": "Tabelle (Querformat)" }, { "itemId": "export_excel", "menu_item_text": "Export to .xls", "tooltip": "Export this table as an .xls document", "panel_btn_handler": Lino.list_action_handler('/extensible/PanelCalendars','export_excel','GET',Lino.get_current_grid_config), "iconCls": "x-tbar-csv", "overflowText": "Export to .xls", "auto_save": true }, { "itemId": "insert", "menu_item_text": "Neu", "tooltip": "Neuen Datensatz erstellen", "panel_btn_handler": Lino.show_insert, "iconCls": "x-tbar-add", "overflowText": "Neu", "keycode": 44, "auto_save": true }, { "itemId": "detail", "menu_item_text": "Detail", "tooltip": "Detail-Fenster auf diesem Datensatz \u00f6ffnen", "panel_btn_handler": Lino.show_detail, "iconCls": "x-tbar-application_form", "overflowText": "Detail", "auto_save": true }, { "itemId": "delete_selected", "menu_item_text": "L\u00f6schen", "tooltip": "Diesen Datensatz l\u00f6schen", "panel_btn_handler": Lino.row_action_handler('delete_selected','GET',null), "iconCls": "x-tbar-delete", "overflowText": "L\u00f6schen", "keycode": 46, "auto_save": false } ],
  cell_edit : true,
  title : "Kalenderliste",
  page_length : 20,
  stripeRows : true,
  disabled_actions_index : 6,
  ls_store_fields : [ { "type": "int", "name": "id" }, { "name": "summary" }, { "name": "description" }, { "type": "int", "name": "color" }, { "type": "boolean", "name": "is_hidden" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 0,
  ls_grid_configs : [  ],
  content_type : 36,
  ls_id_property : "id",
  gc_name : 0,
  initComponent : function() {
    this.ls_detail_handler = Lino.extensible.PanelCalendars.detail;
    this.ls_insert_handler = Lino.extensible.PanelCalendars.insert;
    var ww = this.containing_window;
    var id3001 = new Ext.form.NumberField({ "selectOnFocus": true });
    var summary_disp3002 = new Ext.form.DisplayField({ "disabled": true, "value": "<br/>", "always_enabled": true });
    var description3003 = new Lino.RichTextPanel({ "selectOnFocus": true, "containing_panel": this, "title": "Beschreibung" });
    var color3004 = new Ext.form.NumberField({ "selectOnFocus": true, "allowBlank": false });
    var is_hidden_disp3005 = new Ext.form.DisplayField({ "disabled": true });
    this.before_row_edit = function(record) {
      description3003.refresh();
    };
    this.ls_columns = [ new Lino.NullNumberColumn({ "colIndex": 0, "sortable": true, "format": "0", "editable": true, "filter": { "type": "numeric" }, "header": "ID", "editor": id3001, "width": Lino.chars2width(6), "dataIndex": "id" }), { "header": "summary", "colIndex": 1, "sortable": false, "dataIndex": "summary", "width": Lino.chars2width(31), "editable": false }, { "colIndex": 2, "sortable": false, "width": Lino.chars2width(61), "editable": true, "filter": { "type": "string" }, "header": "description", "editor": description3003, "dataIndex": "description" }, new Lino.NullNumberColumn({ "colIndex": 3, "sortable": true, "format": "0", "editable": true, "filter": { "type": "numeric" }, "header": "Farbe", "editor": color3004, "width": Lino.chars2width(6), "dataIndex": "color" }), { "header": "Versteckt", "colIndex": 4, "sortable": false, "dataIndex": "is_hidden", "width": Lino.chars2width(21), "editable": false } ];
    Lino.extensible.PanelCalendars.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.extensible.PanelCalendars.show_as_html = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/extensible/PanelCalendars", "GET", pk, "show_as_html", params, Lino.get_current_grid_config);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.extensible.PanelCalendars.as_pdf = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/extensible/PanelCalendars", "GET", pk, "as_pdf", params, Lino.get_current_grid_config);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.extensible.PanelCalendars.as_pdf_p = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/extensible/PanelCalendars", "GET", pk, "as_pdf_p", params, Lino.get_current_grid_config);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.extensible.PanelCalendars.export_excel = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/extensible/PanelCalendars", "GET", pk, "export_excel", params, Lino.get_current_grid_config);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.extensible.PanelCalendars.submit_detail = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/extensible/PanelCalendars", "GET", pk, "submit_detail", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};

Lino.extensible.PanelCalendars.insertPanel = Ext.extend(Lino.extensible.PanelCalendars.InsertFormPanel,{
  empty_title: "Neu",
  hide_navigator: true,
  save_action_name: "submit_insert",
  ls_bbar_actions: [ { "itemId": "submit_insert", "menu_item_text": "Erstellen", "tooltip": "Datensatz erstellen und dann im Detail-Fenster \u00f6ffnen", "panel_btn_handler": function(panel){panel.save()}, "text": "Erstellen", "overflowText": "Erstellen", "auto_save": false } ],
  ls_url: "/extensible/PanelCalendars",
  action_name: "insert",
  initComponent : function() {
    this.ls_detail_handler = Lino.extensible.PanelCalendars.detail;
    this.ls_insert_handler = Lino.extensible.PanelCalendars.insert;
    Lino.extensible.PanelCalendars.insertPanel.superclass.initComponent.call(this);
  }
});

Lino.extensible.PanelCalendars.insert = new Lino.WindowAction({ "draggable": true, "width": Lino.chars2width(60), "autoHeight": true, "maximizable": true, "modal": true, "maximized": false }, function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.extensible.PanelCalendars.insertPanel(p);
});
Lino.extensible.PanelCalendars.grid_put = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/extensible/PanelCalendars", "GET", pk, "grid_put", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.extensible.PanelCalendars.grid_post = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/extensible/PanelCalendars", "GET", pk, "grid_post", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.extensible.PanelCalendars.submit_insert = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/extensible/PanelCalendars", "GET", pk, "submit_insert", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};

Lino.extensible.PanelCalendars.detailPanel = Ext.extend(Lino.extensible.PanelCalendars.DetailFormPanel,{
  empty_title: "Detail",
  save_action_name: "submit_detail",
  ls_bbar_actions: [ { "itemId": "submit_detail", "menu_item_text": "Speichern", "tooltip": "\u00c4nderungen in diesem Formular speichern", "panel_btn_handler": function(panel){panel.save()}, "iconCls": "x-tbar-disk", "overflowText": "Speichern", "auto_save": false }, { "itemId": "insert", "menu_item_text": "Neu", "tooltip": "Neuen Datensatz erstellen", "panel_btn_handler": Lino.show_insert, "iconCls": "x-tbar-add", "overflowText": "Neu", "keycode": 44, "auto_save": true }, { "itemId": "delete_selected", "menu_item_text": "L\u00f6schen", "tooltip": "Diesen Datensatz l\u00f6schen", "panel_btn_handler": Lino.row_action_handler('delete_selected','GET',null), "iconCls": "x-tbar-delete", "overflowText": "L\u00f6schen", "keycode": 46, "auto_save": false } ],
  ls_url: "/extensible/PanelCalendars",
  action_name: "detail",
  initComponent : function() {
    this.ls_detail_handler = Lino.extensible.PanelCalendars.detail;
    this.ls_insert_handler = Lino.extensible.PanelCalendars.insert;
    Lino.extensible.PanelCalendars.detailPanel.superclass.initComponent.call(this);
  }
});

Lino.extensible.PanelCalendars.detail = new Lino.WindowAction({  }, function(){
  var p = { "is_main_window": true };
  return new Lino.extensible.PanelCalendars.detailPanel(p);
});
Lino.extensible.PanelCalendars.delete_selected = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/extensible/PanelCalendars", "GET", pk, "delete_selected", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.extensible.PanelCalendars.grid = new Lino.WindowAction({  }, function(){
  var p = { "is_main_window": true };
  return new Lino.extensible.PanelCalendars.GridPanel(p);
});
Lino.extensible.PanelCalendars.validate = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/extensible/PanelCalendars", "GET", pk, "validate", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};

// js_render_GridPanel_class extensible.PanelEvents
Lino.extensible.PanelEvents.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "Keine Daten anzuzeigen." },
  ls_url : "/extensible/PanelEvents",
  ls_bbar_actions : [ { "itemId": "show_as_html", "menu_item_text": "HTML", "tooltip": "Show this table in Bootstrap3 interface", "panel_btn_handler": Lino.list_action_handler('/extensible/PanelEvents','show_as_html','GET',Lino.get_current_grid_config), "iconCls": "x-tbar-html", "overflowText": "HTML", "auto_save": true }, { "panel_btn_handler": Lino.list_action_handler('/extensible/PanelEvents','as_pdf','GET',Lino.get_current_grid_config), "xtype": "splitbutton", "text": null, "menu": [ { "itemId": "as_pdf", "menu_item_text": "Tabelle (Querformat)", "tooltip": "Diese Tabelle in eine .pdf-Datei exportieren", "panel_btn_handler": Lino.list_action_handler('/extensible/PanelEvents','as_pdf','GET',Lino.get_current_grid_config), "text": "Tabelle (Querformat)", "overflowText": "Tabelle (Querformat)", "auto_save": true }, { "itemId": "as_pdf_p", "menu_item_text": "Tabelle (Hochformat)", "tooltip": "Diese Tabelle in eine .pdf-Datei exportieren", "panel_btn_handler": Lino.list_action_handler('/extensible/PanelEvents','as_pdf_p','GET',Lino.get_current_grid_config), "text": "Tabelle (Hochformat)", "overflowText": "Tabelle (Hochformat)", "auto_save": true } ], "iconCls": "x-tbar-pdf", "menu_item_text": "Tabelle (Querformat)" }, { "itemId": "export_excel", "menu_item_text": "Export to .xls", "tooltip": "Export this table as an .xls document", "panel_btn_handler": Lino.list_action_handler('/extensible/PanelEvents','export_excel','GET',Lino.get_current_grid_config), "iconCls": "x-tbar-csv", "overflowText": "Export to .xls", "auto_save": true }, { "itemId": "insert", "menu_item_text": "Neu", "tooltip": "Neuen Datensatz erstellen", "panel_btn_handler": Lino.show_insert, "iconCls": "x-tbar-add", "overflowText": "Neu", "keycode": 44, "auto_save": true }, { "itemId": "duplicate", "menu_item_text": "Duplizieren", "tooltip": "Duplizieren", "panel_btn_handler": Lino.row_action_handler('duplicate','GET',null), "iconCls": "x-tbar-arrow_divide", "overflowText": "Duplizieren", "auto_save": true }, { "itemId": "detail", "menu_item_text": "Detail", "tooltip": "Detail-Fenster auf diesem Datensatz \u00f6ffnen", "panel_btn_handler": Lino.show_detail, "iconCls": "x-tbar-application_form", "overflowText": "Detail", "auto_save": true }, { "itemId": "delete_selected", "menu_item_text": "L\u00f6schen", "tooltip": "Diesen Datensatz l\u00f6schen", "panel_btn_handler": Lino.row_action_handler('delete_selected','GET',null), "iconCls": "x-tbar-delete", "overflowText": "L\u00f6schen", "keycode": 46, "auto_save": false }, { "itemId": "do_print", "menu_item_text": "Drucken", "tooltip": "Drucken", "panel_btn_handler": Lino.row_action_handler('do_print','POST',null), "iconCls": "x-tbar-printer", "overflowText": "Drucken", "auto_save": true }, { "itemId": "do_clear_cache", "menu_item_text": "Cache l\u00f6schen", "tooltip": "Cache l\u00f6schen", "panel_btn_handler": Lino.row_action_handler('do_clear_cache','GET',null), "iconCls": "x-tbar-printer_delete", "overflowText": "Cache l\u00f6schen", "auto_save": true }, { "itemId": "show_today", "menu_item_text": "Heute", "tooltip": "Show all calendar events of the same day.", "panel_btn_handler": Lino.row_action_handler('show_today','GET',null), "iconCls": "x-tbar-calendar", "overflowText": "Heute", "auto_save": true }, { "itemId": "create_postings", "menu_item_text": "per Post", "tooltip": "Create classical mail postings from this", "panel_btn_handler": Lino.row_action_handler('create_postings','GET',null), "iconCls": "x-tbar-script_add", "overflowText": "per Post", "auto_save": true }, { "itemId": "do_update_guests", "menu_item_text": "Update Guests", "tooltip": "Update Guests", "panel_btn_handler": Lino.row_action_handler('do_update_guests','GET',null), "iconCls": "x-tbar-lightning", "overflowText": "Update Guests", "auto_save": true }, { "itemId": "take", "menu_item_text": "Annehmen", "tooltip": "Verantwortung f\u00fcr diesen Termin \u00fcbernehmen.", "panel_btn_handler": Lino.row_action_handler('take','GET',null), "iconCls": "x-tbar-flag_green", "overflowText": "Annehmen", "auto_save": true }, { "itemId": "move_next", "menu_item_text": "Nach unten", "tooltip": "Nach unten", "panel_btn_handler": Lino.row_action_handler('move_next','GET',null), "iconCls": "x-tbar-date_next", "overflowText": "Nach unten", "auto_save": true }, { "itemId": "create_mail", "menu_item_text": "per E-Mail", "tooltip": "Create an email from this", "panel_btn_handler": Lino.row_action_handler('create_mail','GET',null), "iconCls": "x-tbar-email_add", "overflowText": "per E-Mail", "auto_save": true } ],
  cell_edit : true,
  title : "Termine",
  page_length : 20,
  params_panel_hidden : true,
  stripeRows : true,
  disabled_actions_index : 15,
  ls_store_fields : [ { "type": "int", "name": "id" }, { "name": "start_dt" }, { "name": "end_dt" }, { "name": "summary" }, { "name": "description" }, { "name": "user" }, 'userHidden', { "name": "room" }, 'roomHidden', { "name": "calendar" }, 'calendarHidden', { "name": "url" }, { "type": "boolean", "name": "all_day" }, { "name": "reminder" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 0,
  ls_grid_configs : [  ],
  content_type : 37,
  ls_id_property : "id",
  gc_name : 0,
  initComponent : function() {
    this.ls_detail_handler = Lino.extensible.PanelEvents.detail;
    this.ls_insert_handler = Lino.extensible.PanelEvents.insert;
    var ww = this.containing_window;
    var id3007 = new Ext.form.NumberField({ "selectOnFocus": true });
    var start_dt3008 = new Ext.form.DisplayField({ "selectOnFocus": true, "allowBlank": false, "value": "<br>" });
    var end_dt3009 = new Ext.form.DisplayField({ "selectOnFocus": true, "allowBlank": false, "value": "<br>" });
    var summary3010 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var description3011 = new Ext.form.TextArea({ "selectOnFocus": true, "growMax": 2000 });
    var user3012 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "preferred_width": 15, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/extensible/PanelEvents/user", "method": "GET" }) }), "pageSize": 20, "emptyText": "Benutzer ausw\u00e4hlen..." });
    var room3013 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/extensible/PanelEvents/room", "method": "GET" }) }), "pageSize": 20, "emptyText": "Raum ausw\u00e4hlen..." });
    var calendar3014 = new Lino.RemoteComboFieldElement({ "disabled": true, "store": new Lino.ComplexRemoteComboStore({  }), "pageSize": 20, "emptyText": "Kalender ausw\u00e4hlen..." });
    var url_disp3015 = new Ext.form.DisplayField({ "disabled": true, "value": "<br/>", "always_enabled": true });
    var all_day3016 = new Ext.form.Checkbox({ "selectOnFocus": true });
    var reminder_disp3017 = new Ext.form.DisplayField({ "disabled": true, "value": "<br/>", "always_enabled": true });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ new Lino.NullNumberColumn({ "colIndex": 0, "sortable": true, "format": "0", "editable": true, "filter": { "type": "numeric" }, "header": "ID", "editor": id3007, "width": Lino.chars2width(6), "dataIndex": "id" }), { "width": Lino.chars2width(17), "colIndex": 1, "sortable": false, "editor": start_dt3008, "header": "Beginn", "editable": true, "dataIndex": "start_dt" }, { "width": Lino.chars2width(17), "colIndex": 2, "sortable": false, "editor": end_dt3009, "header": "Ende", "editable": true, "dataIndex": "end_dt" }, { "colIndex": 3, "sortable": true, "width": Lino.chars2width(22), "editable": true, "filter": { "type": "string" }, "header": "Kurzbeschreibung", "editor": summary3010, "dataIndex": "summary" }, { "colIndex": 4, "sortable": false, "width": Lino.chars2width(61), "editable": true, "filter": { "type": "string" }, "header": "Beschreibung", "editor": description3011, "dataIndex": "description" }, { "colIndex": 5, "sortable": true, "width": Lino.chars2width(21), "editable": true, "filter": { "type": "string" }, "header": "Verwaltet durch", "editor": user3012, "dataIndex": "user" }, { "colIndex": 6, "sortable": true, "width": Lino.chars2width(21), "editable": true, "filter": { "type": "string" }, "header": "Raum", "editor": room3013, "dataIndex": "room" }, { "width": Lino.chars2width(21), "colIndex": 7, "sortable": false, "dataIndex": "calendar", "header": "Kalender", "editable": false }, { "header": "Link URL", "colIndex": 8, "sortable": false, "dataIndex": "url", "width": Lino.chars2width(31), "editable": false }, { "header": "ganztags", "colIndex": 9, "sortable": false, "xtype": "checkcolumn", "width": Lino.chars2width(11), "editable": true, "dataIndex": "all_day" }, { "header": "Erinnerung", "colIndex": 10, "sortable": false, "dataIndex": "reminder", "width": Lino.chars2width(31), "editable": false } ];
    Lino.extensible.PanelEvents.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.extensible.PanelEvents.show_as_html = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/extensible/PanelEvents", "GET", pk, "show_as_html", params, Lino.get_current_grid_config);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.extensible.PanelEvents.as_pdf = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/extensible/PanelEvents", "GET", pk, "as_pdf", params, Lino.get_current_grid_config);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.extensible.PanelEvents.as_pdf_p = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/extensible/PanelEvents", "GET", pk, "as_pdf_p", params, Lino.get_current_grid_config);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.extensible.PanelEvents.export_excel = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/extensible/PanelEvents", "GET", pk, "export_excel", params, Lino.get_current_grid_config);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.extensible.PanelEvents.submit_detail = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/extensible/PanelEvents", "GET", pk, "submit_detail", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};

Lino.extensible.PanelEvents.insertPanel = Ext.extend(Lino.cal.EventsByDay.InsertFormPanel,{
  empty_title: "Neu",
  hide_navigator: true,
  params_panel_hidden: true,
  save_action_name: "submit_insert",
  ls_bbar_actions: [ { "itemId": "submit_insert", "menu_item_text": "Erstellen", "tooltip": "Datensatz erstellen und dann im Detail-Fenster \u00f6ffnen", "panel_btn_handler": function(panel){panel.save()}, "text": "Erstellen", "overflowText": "Erstellen", "auto_save": false } ],
  ls_url: "/extensible/PanelEvents",
  action_name: "insert",
  initComponent : function() {
    this.ls_detail_handler = Lino.extensible.PanelEvents.detail;
    this.ls_insert_handler = Lino.extensible.PanelEvents.insert;
    Lino.extensible.PanelEvents.insertPanel.superclass.initComponent.call(this);
  }
});

Lino.extensible.PanelEvents.insert = new Lino.WindowAction({ "draggable": true, "width": Lino.chars2width(60), "autoHeight": true, "maximizable": true, "modal": true, "maximized": false }, function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.extensible.PanelEvents.insertPanel(p);
});
Lino.extensible.PanelEvents.grid_put = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/extensible/PanelEvents", "GET", pk, "grid_put", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.extensible.PanelEvents.grid_post = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/extensible/PanelEvents", "GET", pk, "grid_post", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.extensible.PanelEvents.submit_insert = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/extensible/PanelEvents", "GET", pk, "submit_insert", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.extensible.PanelEvents.wf1 = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/extensible/PanelEvents", "GET", pk, "wf1", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.extensible.PanelEvents.duplicate = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/extensible/PanelEvents", "GET", pk, "duplicate", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.extensible.PanelEvents.wf2 = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/extensible/PanelEvents", "GET", pk, "wf2", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.extensible.PanelEvents.wf3 = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/extensible/PanelEvents", "GET", pk, "wf3", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.extensible.PanelEvents.wf4 = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/extensible/PanelEvents", "GET", pk, "wf4", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};

Lino.extensible.PanelEvents.detailPanel = Ext.extend(Lino.cal.EventsByDay.DetailFormPanel,{
  empty_title: "Detail",
  params_panel_hidden: true,
  save_action_name: "submit_detail",
  ls_bbar_actions: [ { "itemId": "submit_detail", "menu_item_text": "Speichern", "tooltip": "\u00c4nderungen in diesem Formular speichern", "panel_btn_handler": function(panel){panel.save()}, "iconCls": "x-tbar-disk", "overflowText": "Speichern", "auto_save": false }, { "itemId": "insert", "menu_item_text": "Neu", "tooltip": "Neuen Datensatz erstellen", "panel_btn_handler": Lino.show_insert, "iconCls": "x-tbar-add", "overflowText": "Neu", "keycode": 44, "auto_save": true }, { "itemId": "duplicate", "menu_item_text": "Duplizieren", "tooltip": "Duplizieren", "panel_btn_handler": Lino.row_action_handler('duplicate','GET',null), "iconCls": "x-tbar-arrow_divide", "overflowText": "Duplizieren", "auto_save": true }, { "itemId": "delete_selected", "menu_item_text": "L\u00f6schen", "tooltip": "Diesen Datensatz l\u00f6schen", "panel_btn_handler": Lino.row_action_handler('delete_selected','GET',null), "iconCls": "x-tbar-delete", "overflowText": "L\u00f6schen", "keycode": 46, "auto_save": false }, { "itemId": "do_print", "menu_item_text": "Drucken", "tooltip": "Drucken", "panel_btn_handler": Lino.row_action_handler('do_print','POST',null), "iconCls": "x-tbar-printer", "overflowText": "Drucken", "auto_save": true }, { "itemId": "do_clear_cache", "menu_item_text": "Cache l\u00f6schen", "tooltip": "Cache l\u00f6schen", "panel_btn_handler": Lino.row_action_handler('do_clear_cache','GET',null), "iconCls": "x-tbar-printer_delete", "overflowText": "Cache l\u00f6schen", "auto_save": true }, { "itemId": "show_today", "menu_item_text": "Heute", "tooltip": "Show all calendar events of the same day.", "panel_btn_handler": Lino.row_action_handler('show_today','GET',null), "iconCls": "x-tbar-calendar", "overflowText": "Heute", "auto_save": true }, { "itemId": "create_postings", "menu_item_text": "per Post", "tooltip": "Create classical mail postings from this", "panel_btn_handler": Lino.row_action_handler('create_postings','GET',null), "iconCls": "x-tbar-script_add", "overflowText": "per Post", "auto_save": true }, { "itemId": "do_update_guests", "menu_item_text": "Update Guests", "tooltip": "Update Guests", "panel_btn_handler": Lino.row_action_handler('do_update_guests','GET',null), "iconCls": "x-tbar-lightning", "overflowText": "Update Guests", "auto_save": true }, { "itemId": "take", "menu_item_text": "Annehmen", "tooltip": "Verantwortung f\u00fcr diesen Termin \u00fcbernehmen.", "panel_btn_handler": Lino.row_action_handler('take','GET',null), "iconCls": "x-tbar-flag_green", "overflowText": "Annehmen", "auto_save": true }, { "itemId": "move_next", "menu_item_text": "Nach unten", "tooltip": "Nach unten", "panel_btn_handler": Lino.row_action_handler('move_next','GET',null), "iconCls": "x-tbar-date_next", "overflowText": "Nach unten", "auto_save": true }, { "itemId": "create_mail", "menu_item_text": "per E-Mail", "tooltip": "Create an email from this", "panel_btn_handler": Lino.row_action_handler('create_mail','GET',null), "iconCls": "x-tbar-email_add", "overflowText": "per E-Mail", "auto_save": true } ],
  ls_url: "/extensible/PanelEvents",
  action_name: "detail",
  initComponent : function() {
    this.ls_detail_handler = Lino.extensible.PanelEvents.detail;
    this.ls_insert_handler = Lino.extensible.PanelEvents.insert;
    Lino.extensible.PanelEvents.detailPanel.superclass.initComponent.call(this);
  }
});

Lino.extensible.PanelEvents.detail = new Lino.WindowAction({  }, function(){
  var p = { "is_main_window": true };
  return new Lino.extensible.PanelEvents.detailPanel(p);
});
Lino.extensible.PanelEvents.delete_selected = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/extensible/PanelEvents", "GET", pk, "delete_selected", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.extensible.PanelEvents.do_print = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/extensible/PanelEvents", "POST", pk, "do_print", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.extensible.PanelEvents.do_clear_cache = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/extensible/PanelEvents", "GET", pk, "do_clear_cache", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.extensible.PanelEvents.edit_template = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/extensible/PanelEvents", "GET", pk, "edit_template", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.extensible.PanelEvents.show_today = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/extensible/PanelEvents", "GET", pk, "show_today", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.extensible.PanelEvents.grid = new Lino.WindowAction({  }, function(){
  var p = { "is_main_window": true };
  p.params_panel = new Lino.cal.EventsByDay.ParamsPanel({});
  return new Lino.extensible.PanelEvents.GridPanel(p);
});
Lino.extensible.PanelEvents.validate = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/extensible/PanelEvents", "GET", pk, "validate", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.extensible.PanelEvents.create_postings = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/extensible/PanelEvents", "GET", pk, "create_postings", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.extensible.PanelEvents.do_update_guests = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/extensible/PanelEvents", "GET", pk, "do_update_guests", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.extensible.PanelEvents.take = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/extensible/PanelEvents", "GET", pk, "take", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.extensible.PanelEvents.move_next = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/extensible/PanelEvents", "GET", pk, "move_next", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.extensible.PanelEvents.create_mail = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/extensible/PanelEvents", "GET", pk, "create_mail", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};

// js_render_GridPanel_class reception.ExpectedGuests
Lino.reception.ExpectedGuests.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "Keine Daten anzuzeigen." },
  ls_url : "/reception/ExpectedGuests",
  ls_bbar_actions : [ { "itemId": "show_as_html", "menu_item_text": "HTML", "tooltip": "Show this table in Bootstrap3 interface", "panel_btn_handler": Lino.list_action_handler('/reception/ExpectedGuests','show_as_html','GET',Lino.get_current_grid_config), "iconCls": "x-tbar-html", "overflowText": "HTML", "auto_save": true }, { "panel_btn_handler": Lino.list_action_handler('/reception/ExpectedGuests','as_pdf','GET',Lino.get_current_grid_config), "xtype": "splitbutton", "text": null, "menu": [ { "itemId": "as_pdf", "menu_item_text": "Tabelle (Querformat)", "tooltip": "Diese Tabelle in eine .pdf-Datei exportieren", "panel_btn_handler": Lino.list_action_handler('/reception/ExpectedGuests','as_pdf','GET',Lino.get_current_grid_config), "text": "Tabelle (Querformat)", "overflowText": "Tabelle (Querformat)", "auto_save": true }, { "itemId": "as_pdf_p", "menu_item_text": "Tabelle (Hochformat)", "tooltip": "Diese Tabelle in eine .pdf-Datei exportieren", "panel_btn_handler": Lino.list_action_handler('/reception/ExpectedGuests','as_pdf_p','GET',Lino.get_current_grid_config), "text": "Tabelle (Hochformat)", "overflowText": "Tabelle (Hochformat)", "auto_save": true } ], "iconCls": "x-tbar-pdf", "menu_item_text": "Tabelle (Querformat)" }, { "itemId": "export_excel", "menu_item_text": "Export to .xls", "tooltip": "Export this table as an .xls document", "panel_btn_handler": Lino.list_action_handler('/reception/ExpectedGuests','export_excel','GET',Lino.get_current_grid_config), "iconCls": "x-tbar-csv", "overflowText": "Export to .xls", "auto_save": true }, { "itemId": "insert", "menu_item_text": "Neu", "tooltip": "Neuen Datensatz erstellen", "panel_btn_handler": Lino.show_insert, "iconCls": "x-tbar-add", "overflowText": "Neu", "keycode": 44, "auto_save": true }, { "itemId": "detail", "menu_item_text": "Detail", "tooltip": "Detail-Fenster auf diesem Datensatz \u00f6ffnen", "panel_btn_handler": Lino.show_detail, "iconCls": "x-tbar-application_form", "overflowText": "Detail", "auto_save": true }, { "itemId": "delete_selected", "menu_item_text": "L\u00f6schen", "tooltip": "Diesen Datensatz l\u00f6schen", "panel_btn_handler": Lino.row_action_handler('delete_selected','GET',null), "iconCls": "x-tbar-delete", "overflowText": "L\u00f6schen", "keycode": 46, "auto_save": false }, { "itemId": "do_print", "menu_item_text": "Anwesenheitsbescheinigung", "tooltip": "Auszug von diesem Datensatz erstellen zwecks Ausdruck.", "panel_btn_handler": Lino.row_action_handler('do_print','GET',null), "iconCls": "x-tbar-printer", "overflowText": "Anwesenheitsbescheinigung", "auto_save": true }, { "itemId": "checkin", "menu_item_text": "Einchecken", "tooltip": "Mark this visitor as arrived", "panel_btn_handler": Lino.param_action_handler(Lino.cal.Guests.checkin), "text": "Einchecken", "overflowText": "Einchecken", "auto_save": true }, { "itemId": "receive", "menu_item_text": "Empfangen", "tooltip": "Visitor was received by agent", "panel_btn_handler": Lino.row_action_handler('receive','GET',null), "text": "Empfangen", "overflowText": "Empfangen", "auto_save": true }, { "itemId": "checkout", "menu_item_text": "Auschecken", "tooltip": "Visitor left the centre", "panel_btn_handler": Lino.row_action_handler('checkout','GET',null), "text": "Auschecken", "overflowText": "Auschecken", "auto_save": true } ],
  cell_edit : true,
  title : "Erwartete Besucher",
  page_length : 20,
  stripeRows : true,
  disabled_actions_index : 10,
  ls_store_fields : [ { "name": "partner" }, 'partnerHidden', { "name": "event__user" }, 'event__userHidden', { "name": "event__summary" }, { "name": "workflow_buttons" }, { "name": "waiting_since" }, { "name": "busy_since" }, { "type": "int", "name": "id" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 8,
  ls_grid_configs : [  ],
  content_type : 33,
  ls_id_property : "id",
  gc_name : 0,
  initComponent : function() {
    this.ls_detail_handler = Lino.reception.ExpectedGuests.detail;
    this.ls_insert_handler = Lino.reception.ExpectedGuests.insert;
    var ww = this.containing_window;
    var partner3019 = new Lino.RemoteComboFieldElement({ "preferred_width": 20, "allowBlank": false, "pageSize": 20, "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/reception/ExpectedGuests/partner", "method": "GET" }) }), "emptyText": "Partner ausw\u00e4hlen..." });
    var event__user3020 = new Lino.RemoteComboFieldElement({ "disabled": true, "preferred_width": 15, "store": new Lino.ComplexRemoteComboStore({  }), "pageSize": 20, "emptyText": "Benutzer ausw\u00e4hlen..." });
    var event__summary3021 = new Ext.form.TextField({ "disabled": true, "maxLength": 200 });
    var workflow_buttons_disp3022 = new Ext.form.DisplayField({ "disabled": true, "value": "<br/>", "always_enabled": true });
    var waiting_since3023 = new Ext.form.DisplayField({ "disabled": true, "value": "<br>" });
    var busy_since3024 = new Ext.form.DisplayField({ "disabled": true, "value": "<br>" });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ { "colIndex": 0, "sortable": true, "header": "Partner", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('partnerHidden','Lino.contacts.Partners.detail'), "dataIndex": "partner", "editor": partner3019 }, { "filter": { "type": "string" }, "header": "Verwaltet durch", "colIndex": 1, "sortable": true, "dataIndex": "event__user", "width": Lino.chars2width(21), "editable": false }, { "filter": { "type": "string" }, "header": "Kurzbeschreibung", "colIndex": 2, "sortable": true, "dataIndex": "event__summary", "width": Lino.chars2width(22), "editable": false }, { "header": "Arbeitsablauf", "colIndex": 3, "sortable": false, "dataIndex": "workflow_buttons", "width": Lino.chars2width(31), "editable": false }, { "colIndex": 4, "sortable": true, "width": Lino.chars2width(17), "editable": false, "tooltip": "Time when the visitor arrived (checked in).", "header": "Wartet seit", "dataIndex": "waiting_since", "hidden": true }, { "colIndex": 5, "sortable": true, "width": Lino.chars2width(17), "editable": false, "tooltip": "Time when the visitor was received by agent.", "header": "Hat gewartet bis", "dataIndex": "busy_since", "hidden": true } ];
    Lino.reception.ExpectedGuests.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.reception.ExpectedGuests.show_as_html = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/reception/ExpectedGuests", "GET", pk, "show_as_html", params, Lino.get_current_grid_config);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.reception.ExpectedGuests.as_pdf = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/reception/ExpectedGuests", "GET", pk, "as_pdf", params, Lino.get_current_grid_config);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.reception.ExpectedGuests.as_pdf_p = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/reception/ExpectedGuests", "GET", pk, "as_pdf_p", params, Lino.get_current_grid_config);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.reception.ExpectedGuests.export_excel = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/reception/ExpectedGuests", "GET", pk, "export_excel", params, Lino.get_current_grid_config);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.reception.ExpectedGuests.submit_detail = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/reception/ExpectedGuests", "GET", pk, "submit_detail", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};

Lino.reception.ExpectedGuests.insertPanel = Ext.extend(Lino.cal.MyPresences.InsertFormPanel,{
  empty_title: "Neu",
  hide_navigator: true,
  save_action_name: "submit_insert",
  ls_bbar_actions: [ { "itemId": "submit_insert", "menu_item_text": "Erstellen", "tooltip": "Datensatz erstellen und dann im Detail-Fenster \u00f6ffnen", "panel_btn_handler": function(panel){panel.save()}, "text": "Erstellen", "overflowText": "Erstellen", "auto_save": false } ],
  ls_url: "/reception/ExpectedGuests",
  action_name: "insert",
  initComponent : function() {
    this.ls_detail_handler = Lino.reception.ExpectedGuests.detail;
    this.ls_insert_handler = Lino.reception.ExpectedGuests.insert;
    Lino.reception.ExpectedGuests.insertPanel.superclass.initComponent.call(this);
  }
});

Lino.reception.ExpectedGuests.insert = new Lino.WindowAction({ "draggable": true, "width": Lino.chars2width(60), "autoHeight": true, "maximizable": true, "modal": true, "maximized": false }, function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.reception.ExpectedGuests.insertPanel(p);
});
Lino.reception.ExpectedGuests.grid_put = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/reception/ExpectedGuests", "GET", pk, "grid_put", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.reception.ExpectedGuests.grid_post = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/reception/ExpectedGuests", "GET", pk, "grid_post", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.reception.ExpectedGuests.submit_insert = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/reception/ExpectedGuests", "GET", pk, "submit_insert", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.reception.ExpectedGuests.wf3 = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/reception/ExpectedGuests", "GET", pk, "wf3", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.reception.ExpectedGuests.wf4 = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/reception/ExpectedGuests", "GET", pk, "wf4", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.reception.ExpectedGuests.wf5 = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/reception/ExpectedGuests", "GET", pk, "wf5", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.reception.ExpectedGuests.wf6 = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/reception/ExpectedGuests", "GET", pk, "wf6", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};

Lino.reception.ExpectedGuests.detailPanel = Ext.extend(Lino.cal.MyPresences.DetailFormPanel,{
  empty_title: "Detail",
  save_action_name: "submit_detail",
  ls_bbar_actions: [ { "itemId": "submit_detail", "menu_item_text": "Speichern", "tooltip": "\u00c4nderungen in diesem Formular speichern", "panel_btn_handler": function(panel){panel.save()}, "iconCls": "x-tbar-disk", "overflowText": "Speichern", "auto_save": false }, { "itemId": "insert", "menu_item_text": "Neu", "tooltip": "Neuen Datensatz erstellen", "panel_btn_handler": Lino.show_insert, "iconCls": "x-tbar-add", "overflowText": "Neu", "keycode": 44, "auto_save": true }, { "itemId": "delete_selected", "menu_item_text": "L\u00f6schen", "tooltip": "Diesen Datensatz l\u00f6schen", "panel_btn_handler": Lino.row_action_handler('delete_selected','GET',null), "iconCls": "x-tbar-delete", "overflowText": "L\u00f6schen", "keycode": 46, "auto_save": false }, { "itemId": "do_print", "menu_item_text": "Anwesenheitsbescheinigung", "tooltip": "Auszug von diesem Datensatz erstellen zwecks Ausdruck.", "panel_btn_handler": Lino.row_action_handler('do_print','GET',null), "iconCls": "x-tbar-printer", "overflowText": "Anwesenheitsbescheinigung", "auto_save": true }, { "itemId": "checkin", "menu_item_text": "Einchecken", "tooltip": "Mark this visitor as arrived", "panel_btn_handler": Lino.param_action_handler(Lino.cal.Guests.checkin), "text": "Einchecken", "overflowText": "Einchecken", "auto_save": true }, { "itemId": "receive", "menu_item_text": "Empfangen", "tooltip": "Visitor was received by agent", "panel_btn_handler": Lino.row_action_handler('receive','GET',null), "text": "Empfangen", "overflowText": "Empfangen", "auto_save": true }, { "itemId": "checkout", "menu_item_text": "Auschecken", "tooltip": "Visitor left the centre", "panel_btn_handler": Lino.row_action_handler('checkout','GET',null), "text": "Auschecken", "overflowText": "Auschecken", "auto_save": true } ],
  ls_url: "/reception/ExpectedGuests",
  action_name: "detail",
  initComponent : function() {
    this.ls_detail_handler = Lino.reception.ExpectedGuests.detail;
    this.ls_insert_handler = Lino.reception.ExpectedGuests.insert;
    Lino.reception.ExpectedGuests.detailPanel.superclass.initComponent.call(this);
  }
});

Lino.reception.ExpectedGuests.detail = new Lino.WindowAction({  }, function(){
  var p = { "is_main_window": true };
  return new Lino.reception.ExpectedGuests.detailPanel(p);
});
Lino.reception.ExpectedGuests.delete_selected = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/reception/ExpectedGuests", "GET", pk, "delete_selected", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.reception.ExpectedGuests.do_print = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/reception/ExpectedGuests", "GET", pk, "do_print", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.reception.ExpectedGuests.grid = new Lino.WindowAction({  }, function(){
  var p = { "is_main_window": true };
  p.params_panel = new Lino.cal.MyPresences.ParamsPanel({});
  return new Lino.reception.ExpectedGuests.GridPanel(p);
});
Lino.reception.ExpectedGuests.validate = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/reception/ExpectedGuests", "GET", pk, "validate", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.reception.ExpectedGuests.receive = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/reception/ExpectedGuests", "GET", pk, "receive", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.reception.ExpectedGuests.checkout = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/reception/ExpectedGuests", "GET", pk, "checkout", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};

// js_render_GridPanel_class households.Households
Lino.households.Households.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "Keine Daten anzuzeigen." },
  ls_url : "/households/Households",
  ls_bbar_actions : [ { "itemId": "show_as_html", "menu_item_text": "HTML", "tooltip": "Show this table in Bootstrap3 interface", "panel_btn_handler": Lino.list_action_handler('/households/Households','show_as_html','GET',Lino.get_current_grid_config), "iconCls": "x-tbar-html", "overflowText": "HTML", "auto_save": true }, { "panel_btn_handler": Lino.list_action_handler('/households/Households','as_pdf','GET',Lino.get_current_grid_config), "xtype": "splitbutton", "text": null, "menu": [ { "itemId": "as_pdf", "menu_item_text": "Tabelle (Querformat)", "tooltip": "Diese Tabelle in eine .pdf-Datei exportieren", "panel_btn_handler": Lino.list_action_handler('/households/Households','as_pdf','GET',Lino.get_current_grid_config), "text": "Tabelle (Querformat)", "overflowText": "Tabelle (Querformat)", "auto_save": true }, { "itemId": "as_pdf_p", "menu_item_text": "Tabelle (Hochformat)", "tooltip": "Diese Tabelle in eine .pdf-Datei exportieren", "panel_btn_handler": Lino.list_action_handler('/households/Households','as_pdf_p','GET',Lino.get_current_grid_config), "text": "Tabelle (Hochformat)", "overflowText": "Tabelle (Hochformat)", "auto_save": true }, { "itemId": "print_labels", "menu_item_text": "Etiketten", "tooltip": "Generate mailing labels for these recipients", "panel_btn_handler": Lino.list_action_handler('/households/Households','print_labels','GET',Lino.get_current_grid_config), "text": "Etiketten", "overflowText": "Etiketten", "auto_save": true } ], "iconCls": "x-tbar-pdf", "menu_item_text": "Tabelle (Querformat)" }, { "itemId": "export_excel", "menu_item_text": "Export to .xls", "tooltip": "Export this table as an .xls document", "panel_btn_handler": Lino.list_action_handler('/households/Households','export_excel','GET',Lino.get_current_grid_config), "iconCls": "x-tbar-csv", "overflowText": "Export to .xls", "auto_save": true }, { "itemId": "insert", "menu_item_text": "Neu", "tooltip": "Neuen Datensatz erstellen", "panel_btn_handler": Lino.show_insert, "iconCls": "x-tbar-add", "overflowText": "Neu", "keycode": 44, "auto_save": true }, { "itemId": "detail", "menu_item_text": "Detail", "tooltip": "Detail-Fenster auf diesem Datensatz \u00f6ffnen", "panel_btn_handler": Lino.show_detail, "iconCls": "x-tbar-application_form", "overflowText": "Detail", "auto_save": true }, { "itemId": "delete_selected", "menu_item_text": "L\u00f6schen", "tooltip": "Diesen Datensatz l\u00f6schen", "panel_btn_handler": Lino.row_action_handler('delete_selected','GET',null), "iconCls": "x-tbar-delete", "overflowText": "L\u00f6schen", "keycode": 46, "auto_save": false }, { "itemId": "populate_members", "menu_item_text": "Populate", "tooltip": "Populate", "panel_btn_handler": Lino.row_action_handler('populate_members','GET',null), "iconCls": "x-tbar-lightning", "overflowText": "Populate", "auto_save": true } ],
  cell_edit : true,
  title : "Haushalte",
  page_length : 20,
  stripeRows : true,
  disabled_actions_index : 36,
  ls_store_fields : [ { "name": "name" }, { "name": "email" }, { "name": "modified" }, { "name": "created" }, { "name": "country" }, 'countryHidden', { "name": "city" }, 'cityHidden', { "name": "zip_code" }, { "name": "region" }, 'regionHidden', { "name": "addr1" }, { "name": "street_prefix" }, { "name": "street" }, { "name": "street_no" }, { "name": "street_box" }, { "name": "addr2" }, { "name": "language" }, 'languageHidden', { "name": "url" }, { "name": "phone" }, { "name": "gsm" }, { "name": "fax" }, { "name": "remarks" }, { "type": "boolean", "name": "is_obsolete" }, { "name": "activity" }, 'activityHidden', { "name": "client_contact_type" }, 'client_contact_typeHidden', { "name": "iban" }, { "name": "bic" }, { "name": "prefix" }, { "name": "type" }, 'typeHidden', { "type": "int", "name": "id" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 34,
  ls_grid_configs : [  ],
  content_type : 20,
  ls_id_property : "id",
  gc_name : 0,
  initComponent : function() {
    this.ls_detail_handler = Lino.households.Households.detail;
    this.ls_insert_handler = Lino.households.Households.insert;
    var ww = this.containing_window;
    var name3026 = new Ext.form.TextField({ "selectOnFocus": true, "allowBlank": false, "maxLength": 200 });
    var email3027 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 75 });
    var modified3028 = new Ext.form.DisplayField({ "disabled": true, "value": "<br>" });
    var created3029 = new Ext.form.DisplayField({ "disabled": true, "value": "<br>" });
    var country3030 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/households/Households/country", "method": "GET" }) }), "pageSize": 20, "emptyText": "Land ausw\u00e4hlen..." });
    var city3031 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "forceSelection": false, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/households/Households/city", "method": "GET" }) }), "pageSize": 20, "emptyText": "Ort ausw\u00e4hlen..." });
    var zip_code3032 = new Ext.form.TextField({ "selectOnFocus": true, "boxMinWidth": Lino.chars2width(10), "maxLength": 10 });
    var region3033 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/households/Households/region", "method": "GET" }) }), "pageSize": 20, "emptyText": "Ort ausw\u00e4hlen..." });
    var addr13034 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var street_prefix3035 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var street3036 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var street_no3037 = new Ext.form.TextField({ "selectOnFocus": true, "boxMinWidth": Lino.chars2width(10), "maxLength": 10 });
    var street_box3038 = new Ext.form.TextField({ "selectOnFocus": true, "boxMinWidth": Lino.chars2width(10), "maxLength": 10 });
    var addr23039 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var language3040 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "allowBlank": false, "store": [ [ "de", "Deutsch" ], [ "fr", "Franz\u00f6sisch" ], [ "nl", "Niederl\u00e4ndisch" ] ] });
    var url3041 = new Lino.URLField({ "selectOnFocus": true, "maxLength": 200 });
    var phone3042 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var gsm3043 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var fax3044 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var remarks3045 = new Ext.form.TextArea({ "selectOnFocus": true, "growMax": 2000 });
    var is_obsolete3046 = new Ext.form.Checkbox({ "selectOnFocus": true, "checked": false });
    var activity3047 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/households/Households/activity", "method": "GET" }) }), "pageSize": 20, "emptyText": "Beruf ausw\u00e4hlen..." });
    var client_contact_type3048 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/households/Households/client_contact_type", "method": "GET" }) }), "pageSize": 20, "emptyText": "Klientenkontaktart ausw\u00e4hlen..." });
    var iban3049 = new Lino.UppercaseTextField({ "selectOnFocus": true, "maxLength": 34 });
    var bic3050 = new Lino.UppercaseTextField({ "selectOnFocus": true, "maxLength": 11 });
    var prefix3051 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var type3052 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/households/Households/type", "method": "GET" }) }), "pageSize": 20, "emptyText": "Haushaltsart ausw\u00e4hlen..." });
    var id3053 = new Ext.form.NumberField({ "selectOnFocus": true });
    this.before_row_edit = function(record) {
      city3031.setContextValue('country', record ? record.data['countryHidden'] : undefined);
      city3031.setContextValue('region', record ? record.data['regionHidden'] : undefined);
      region3033.setContextValue('country', record ? record.data['countryHidden'] : undefined);
    };
    this.onRender = function(ct, position) {
      country3030.on('change',Lino.chooser_handler(city3031,'country'));
      region3033.on('change',Lino.chooser_handler(city3031,'region'));
      country3030.on('change',Lino.chooser_handler(region3033,'country'));
      Lino.households.Households.GridPanel.superclass.onRender.call(this, ct, position);
    }
    this.ls_columns = [ { "colIndex": 0, "sortable": true, "width": Lino.chars2width(22), "editable": true, "filter": { "type": "string" }, "header": "Name", "editor": name3026, "dataIndex": "name" }, { "colIndex": 1, "sortable": true, "width": Lino.chars2width(22), "editable": true, "filter": { "type": "string" }, "header": "E-Mail", "editor": email3027, "dataIndex": "email" }, { "header": "Bearbeitet", "colIndex": 2, "sortable": true, "dataIndex": "modified", "width": Lino.chars2width(17), "hidden": true, "editable": false }, { "header": "Erstellt", "colIndex": 3, "sortable": true, "dataIndex": "created", "width": Lino.chars2width(17), "hidden": true, "editable": false }, { "colIndex": 4, "sortable": true, "header": "Land", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('countryHidden','Lino.countries.Countries.detail'), "dataIndex": "country", "hidden": true, "editor": country3030 }, { "colIndex": 5, "sortable": true, "header": "Stadt", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "editor": city3031, "hidden": true, "dataIndex": "city" }, { "colIndex": 6, "sortable": true, "header": "Postleitzahl", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(12), "editor": zip_code3032, "hidden": true, "dataIndex": "zip_code" }, { "colIndex": 7, "sortable": true, "header": "Regierungsbezirk", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "editor": region3033, "hidden": true, "dataIndex": "region" }, { "colIndex": 8, "sortable": true, "header": "Adresszeile vor Stra\u00dfe", "editable": true, "tooltip": "Adresszeile vor Stra\u00dfe", "filter": { "type": "string" }, "width": Lino.chars2width(22), "editor": addr13034, "hidden": true, "dataIndex": "addr1" }, { "colIndex": 9, "sortable": true, "header": "Pr\u00e4fix Stra\u00dfe", "editable": true, "tooltip": "Text to print before name of street, but to ignore for sorting.", "filter": { "type": "string" }, "width": Lino.chars2width(22), "editor": street_prefix3035, "hidden": true, "dataIndex": "street_prefix" }, { "colIndex": 10, "sortable": true, "header": "Stra\u00dfe", "editable": true, "tooltip": "Name der Stra\u00dfe, ohne Hausnummer", "filter": { "type": "string" }, "width": Lino.chars2width(22), "editor": street3036, "hidden": true, "dataIndex": "street" }, { "colIndex": 11, "sortable": true, "header": "Nr.", "editable": true, "tooltip": "Hausnummer", "filter": { "type": "string" }, "width": Lino.chars2width(12), "editor": street_no3037, "hidden": true, "dataIndex": "street_no" }, { "colIndex": 12, "sortable": true, "header": "Box", "editable": true, "tooltip": "Text to print after street nuber on the same line.", "filter": { "type": "string" }, "width": Lino.chars2width(12), "editor": street_box3038, "hidden": true, "dataIndex": "street_box" }, { "colIndex": 13, "sortable": true, "header": "Adresszeile nach Stra\u00dfe", "editable": true, "tooltip": "Adresszeile nach Stra\u00dfe", "filter": { "type": "string" }, "width": Lino.chars2width(22), "editor": addr23039, "hidden": true, "dataIndex": "addr2" }, { "colIndex": 14, "sortable": true, "header": "Sprache", "editable": true, "tooltip": "Die Sprache, in der Dokumente ausgestellt werden sollen.", "filter": { "type": "string" }, "width": Lino.chars2width(21), "editor": language3040, "hidden": true, "dataIndex": "language" }, { "colIndex": 15, "sortable": true, "header": "URL", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "editor": url3041, "hidden": true, "dataIndex": "url" }, { "colIndex": 16, "sortable": true, "header": "Telefon", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "editor": phone3042, "hidden": true, "dataIndex": "phone" }, { "colIndex": 17, "sortable": true, "header": "GSM", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "editor": gsm3043, "hidden": true, "dataIndex": "gsm" }, { "colIndex": 18, "sortable": true, "header": "Fax", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "editor": fax3044, "hidden": true, "dataIndex": "fax" }, { "colIndex": 19, "sortable": false, "header": "Bemerkungen", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(61), "editor": remarks3045, "hidden": true, "dataIndex": "remarks" }, { "colIndex": 20, "sortable": false, "xtype": "checkcolumn", "width": Lino.chars2width(11), "editable": true, "tooltip": "Altf\u00e4lle sind Partner, deren Stammdaten nicht mehr gepflegt werden und \nf\u00fcr neue Operationen nicht benutzt werden k\u00f6nnen.", "filter": { "type": "boolean" }, "header": "veraltet", "dataIndex": "is_obsolete", "hidden": true }, { "colIndex": 21, "sortable": true, "header": "Beruf", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "editor": activity3047, "hidden": true, "dataIndex": "activity" }, { "colIndex": 22, "sortable": true, "header": "Klientenkontaktart", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "editor": client_contact_type3048, "hidden": true, "dataIndex": "client_contact_type" }, { "colIndex": 23, "sortable": true, "header": "IBAN", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "renderer": Lino.iban_renderer, "hidden": true, "editor": iban3049, "dataIndex": "iban" }, { "colIndex": 24, "sortable": true, "header": "BIC", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(13), "editor": bic3050, "hidden": true, "dataIndex": "bic" }, { "colIndex": 25, "sortable": true, "header": "prefix", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "editor": prefix3051, "hidden": true, "dataIndex": "prefix" }, { "colIndex": 26, "sortable": true, "header": "Haushaltsart", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "editor": type3052, "hidden": true, "dataIndex": "type" }, new Lino.NullNumberColumn({ "colIndex": 27, "sortable": true, "format": "0", "editable": true, "filter": { "type": "numeric" }, "header": "ID", "editor": id3053, "width": Lino.chars2width(6), "dataIndex": "id" }) ];
    Lino.households.Households.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.households.Households.show_as_html = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/households/Households", "GET", pk, "show_as_html", params, Lino.get_current_grid_config);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.households.Households.as_pdf = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/households/Households", "GET", pk, "as_pdf", params, Lino.get_current_grid_config);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.households.Households.as_pdf_p = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/households/Households", "GET", pk, "as_pdf_p", params, Lino.get_current_grid_config);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.households.Households.print_labels = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/households/Households", "GET", pk, "print_labels", params, Lino.get_current_grid_config);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.households.Households.export_excel = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/households/Households", "GET", pk, "export_excel", params, Lino.get_current_grid_config);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.households.Households.submit_detail = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/households/Households", "GET", pk, "submit_detail", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};

Lino.households.Households.insertPanel = Ext.extend(Lino.contacts.Partners.InsertFormPanel,{
  empty_title: "Neu",
  hide_navigator: true,
  save_action_name: "submit_insert",
  ls_bbar_actions: [ { "itemId": "submit_insert", "menu_item_text": "Erstellen", "tooltip": "Datensatz erstellen und dann im Detail-Fenster \u00f6ffnen", "panel_btn_handler": function(panel){panel.save()}, "text": "Erstellen", "overflowText": "Erstellen", "auto_save": false } ],
  ls_url: "/households/Households",
  action_name: "insert",
  initComponent : function() {
    this.ls_detail_handler = Lino.households.Households.detail;
    this.ls_insert_handler = Lino.households.Households.insert;
    Lino.households.Households.insertPanel.superclass.initComponent.call(this);
  }
});

Lino.households.Households.insert = new Lino.WindowAction({ "draggable": true, "width": Lino.chars2width(40), "autoHeight": true, "maximizable": true, "modal": true, "maximized": false }, function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.households.Households.insertPanel(p);
});
Lino.households.Households.grid_put = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/households/Households", "GET", pk, "grid_put", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.households.Households.grid_post = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/households/Households", "GET", pk, "grid_post", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.households.Households.submit_insert = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/households/Households", "GET", pk, "submit_insert", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};

Lino.households.Households.detailPanel = Ext.extend(Lino.households.Households.DetailFormPanel,{
  empty_title: "Detail",
  save_action_name: "submit_detail",
  ls_bbar_actions: [ { "itemId": "submit_detail", "menu_item_text": "Speichern", "tooltip": "\u00c4nderungen in diesem Formular speichern", "panel_btn_handler": function(panel){panel.save()}, "iconCls": "x-tbar-disk", "overflowText": "Speichern", "auto_save": false }, { "itemId": "insert", "menu_item_text": "Neu", "tooltip": "Neuen Datensatz erstellen", "panel_btn_handler": Lino.show_insert, "iconCls": "x-tbar-add", "overflowText": "Neu", "keycode": 44, "auto_save": true }, { "itemId": "delete_selected", "menu_item_text": "L\u00f6schen", "tooltip": "Diesen Datensatz l\u00f6schen", "panel_btn_handler": Lino.row_action_handler('delete_selected','GET',null), "iconCls": "x-tbar-delete", "overflowText": "L\u00f6schen", "keycode": 46, "auto_save": false }, { "itemId": "populate_members", "menu_item_text": "Populate", "tooltip": "Populate", "panel_btn_handler": Lino.row_action_handler('populate_members','GET',null), "iconCls": "x-tbar-lightning", "overflowText": "Populate", "auto_save": true } ],
  ls_url: "/households/Households",
  action_name: "detail",
  initComponent : function() {
    this.ls_detail_handler = Lino.households.Households.detail;
    this.ls_insert_handler = Lino.households.Households.insert;
    Lino.households.Households.detailPanel.superclass.initComponent.call(this);
  }
});

Lino.households.Households.detail = new Lino.WindowAction({  }, function(){
  var p = { "is_main_window": true };
  return new Lino.households.Households.detailPanel(p);
});
Lino.households.Households.delete_selected = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/households/Households", "GET", pk, "delete_selected", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.households.Households.grid = new Lino.WindowAction({  }, function(){
  var p = { "is_main_window": true };
  return new Lino.households.Households.GridPanel(p);
});
Lino.households.Households.validate = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/households/Households", "GET", pk, "validate", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.households.Households.populate_members = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/households/Households", "GET", pk, "populate_members", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};

// js_render_GridPanel_class notes.Notes
Lino.notes.Notes.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "Keine Daten anzuzeigen." },
  ls_url : "/notes/Notes",
  ls_bbar_actions : [ { "itemId": "show_as_html", "menu_item_text": "HTML", "tooltip": "Show this table in Bootstrap3 interface", "panel_btn_handler": Lino.list_action_handler('/notes/Notes','show_as_html','GET',Lino.get_current_grid_config), "iconCls": "x-tbar-html", "overflowText": "HTML", "auto_save": true }, { "panel_btn_handler": Lino.list_action_handler('/notes/Notes','as_pdf','GET',Lino.get_current_grid_config), "xtype": "splitbutton", "text": null, "menu": [ { "itemId": "as_pdf", "menu_item_text": "Tabelle (Querformat)", "tooltip": "Diese Tabelle in eine .pdf-Datei exportieren", "panel_btn_handler": Lino.list_action_handler('/notes/Notes','as_pdf','GET',Lino.get_current_grid_config), "text": "Tabelle (Querformat)", "overflowText": "Tabelle (Querformat)", "auto_save": true }, { "itemId": "as_pdf_p", "menu_item_text": "Tabelle (Hochformat)", "tooltip": "Diese Tabelle in eine .pdf-Datei exportieren", "panel_btn_handler": Lino.list_action_handler('/notes/Notes','as_pdf_p','GET',Lino.get_current_grid_config), "text": "Tabelle (Hochformat)", "overflowText": "Tabelle (Hochformat)", "auto_save": true } ], "iconCls": "x-tbar-pdf", "menu_item_text": "Tabelle (Querformat)" }, { "itemId": "export_excel", "menu_item_text": "Export to .xls", "tooltip": "Export this table as an .xls document", "panel_btn_handler": Lino.list_action_handler('/notes/Notes','export_excel','GET',Lino.get_current_grid_config), "iconCls": "x-tbar-csv", "overflowText": "Export to .xls", "auto_save": true }, { "itemId": "insert", "menu_item_text": "Neu", "tooltip": "Neuen Datensatz erstellen", "panel_btn_handler": Lino.show_insert, "iconCls": "x-tbar-add", "overflowText": "Neu", "keycode": 44, "auto_save": true }, { "itemId": "duplicate", "menu_item_text": "Duplizieren", "tooltip": "Duplizieren", "panel_btn_handler": Lino.row_action_handler('duplicate','GET',null), "iconCls": "x-tbar-arrow_divide", "overflowText": "Duplizieren", "auto_save": true }, { "itemId": "detail", "menu_item_text": "Detail", "tooltip": "Detail-Fenster auf diesem Datensatz \u00f6ffnen", "panel_btn_handler": Lino.show_detail, "iconCls": "x-tbar-application_form", "overflowText": "Detail", "auto_save": true }, { "itemId": "delete_selected", "menu_item_text": "L\u00f6schen", "tooltip": "Diesen Datensatz l\u00f6schen", "panel_btn_handler": Lino.row_action_handler('delete_selected','GET',null), "iconCls": "x-tbar-delete", "overflowText": "L\u00f6schen", "keycode": 46, "auto_save": false }, { "itemId": "do_print", "menu_item_text": "Drucken", "tooltip": "Drucken", "panel_btn_handler": Lino.row_action_handler('do_print','POST',null), "iconCls": "x-tbar-printer", "overflowText": "Drucken", "auto_save": true }, { "itemId": "do_clear_cache", "menu_item_text": "Cache l\u00f6schen", "tooltip": "Cache l\u00f6schen", "panel_btn_handler": Lino.row_action_handler('do_clear_cache','GET',null), "iconCls": "x-tbar-printer_delete", "overflowText": "Cache l\u00f6schen", "auto_save": true }, { "itemId": "create_postings", "menu_item_text": "per Post", "tooltip": "Create classical mail postings from this", "panel_btn_handler": Lino.row_action_handler('create_postings','GET',null), "iconCls": "x-tbar-script_add", "overflowText": "per Post", "auto_save": true }, { "itemId": "create_mail", "menu_item_text": "per E-Mail", "tooltip": "Create an email from this", "panel_btn_handler": Lino.row_action_handler('create_mail','GET',null), "iconCls": "x-tbar-email_add", "overflowText": "per E-Mail", "auto_save": true } ],
  cell_edit : true,
  title : "Ereignisse/Notizen",
  page_length : 20,
  stripeRows : true,
  disabled_actions_index : 30,
  ls_store_fields : [ { "type": "date", "name": "date", "dateFormat": "d.m.Y" }, { "name": "time" }, { "type": "int", "name": "id" }, { "name": "user" }, 'userHidden', { "name": "event_type" }, 'event_typeHidden', { "name": "type" }, 'typeHidden', { "name": "project" }, 'projectHidden', { "name": "subject" }, { "name": "build_time" }, { "name": "build_method" }, 'build_methodHidden', { "name": "owner_type" }, 'owner_typeHidden', { "name": "owner_id" }, 'owner_idHidden', { "name": "company" }, 'companyHidden', { "name": "contact_person" }, 'contact_personHidden', { "name": "contact_role" }, 'contact_roleHidden', { "name": "language" }, 'languageHidden', { "name": "owner" }, { "name": "body" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 2,
  ls_grid_configs : [  ],
  content_type : 107,
  ls_id_property : "id",
  gc_name : 0,
  initComponent : function() {
    this.ls_detail_handler = Lino.notes.Notes.detail;
    this.ls_insert_handler = Lino.notes.Notes.insert;
    var ww = this.containing_window;
    var date3055 = new Lino.DateField({ "selectOnFocus": true, "allowBlank": false });
    var time3056 = new Lino.TimeField({ "selectOnFocus": true });
    var id3057 = new Ext.form.NumberField({ "selectOnFocus": true });
    var user3058 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "preferred_width": 15, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/notes/Notes/user", "method": "GET" }) }), "pageSize": 20, "emptyText": "Benutzer ausw\u00e4hlen..." });
    var event_type3059 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/notes/Notes/event_type", "method": "GET" }) }), "pageSize": 20, "emptyText": "Event Type ausw\u00e4hlen..." });
    var type3060 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/notes/Notes/type", "method": "GET" }) }), "pageSize": 20, "emptyText": "Notizart ausw\u00e4hlen..." });
    var project3061 = new Lino.RemoteComboFieldElement({ "selectOnF