/*
 Copyright 2009-2013 Luc Saffre
 This file is part of the Lino project.
 Lino is free software; you can redistribute it and/or modify 
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 3 of the License, or
 (at your option) any later version.
 Lino is distributed in the hope that it will be useful, 
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the 
 GNU General Public License for more details.
 You should have received a copy of the GNU General Public License
 along with Lino; if not, see <http://www.gnu.org/licenses/>.
*/

// lino.js --- generated Thu May  9 16:22:09 2013 by Lino version 1.6.7.
Ext.BLANK_IMAGE_URL = '/media/extjs/resources/images/default/s.gif';
LANGUAGE_CHOICES = [ [ "de", "Deutsch" ], [ "fr", "Franz\u00f6sisch" ], [ "nl", "Niederl\u00e4ndisch" ] ];
MEDIA_URL = "/media";

/* MonthPickerPlugin: thanks to keypoint @ sencha forum
   http://www.sencha.com/forum/showthread.php?74002-3.x-Ext.ux.MonthMenu&p=356860#post356860
*/
Ext.namespace('Ext.ux'); 

Ext.ux.MonthPickerPlugin = function() { 
    var picker; 
    var oldDateDefaults; 

    this.init = function(pk) { 
        picker = pk; 
        picker.onTriggerClick = picker.onTriggerClick.createSequence(onClick); 
        picker.getValue = picker.getValue.createInterceptor(setDefaultMonthDay).createSequence(restoreDefaultMonthDay); 
        picker.beforeBlur = picker.beforeBlur.createInterceptor(setDefaultMonthDay).createSequence(restoreDefaultMonthDay); 
    }; 

    function setDefaultMonthDay() { 
        oldDateDefaults = Date.defaults.d; 
        Date.defaults.d = 1; 
        return true; 
    } 

    function restoreDefaultMonthDay(ret) { 
        Date.defaults.d = oldDateDefaults; 
        return ret; 
    } 

    function onClick(e, el, opt) { 
        var p = picker.menu.picker; 
        p.activeDate = p.activeDate.getFirstDateOfMonth(); 
        if (p.value) { 
            p.value = p.value.getFirstDateOfMonth(); 
        } 

        p.showMonthPicker(); 
         
        if (!p.disabled) { 
            p.monthPicker.stopFx(); 
            p.monthPicker.show(); 

            p.mun(p.monthPicker, 'click', p.onMonthClick, p); 
            p.mun(p.monthPicker, 'dblclick', p.onMonthDblClick, p); 
            p.onMonthClick = p.onMonthClick.createSequence(pickerClick); 
            p.onMonthDblClick = p.onMonthDblClick.createSequence(pickerDblclick); 
            p.mon(p.monthPicker, 'click', p.onMonthClick, p); 
            p.mon(p.monthPicker, 'dblclick', p.onMonthDblClick, p); 
        } 
    } 

    function pickerClick(e, t) { 
        var el = new Ext.Element(t); 
        if (el.is('button.x-date-mp-cancel')) { 
            picker.menu.hide(); 
        } else if(el.is('button.x-date-mp-ok')) { 
            var p = picker.menu.picker; 
            p.setValue(p.activeDate); 
            p.fireEvent('select', p, p.value); 
        } 
    } 

    function pickerDblclick(e, t) { 
        var el = new Ext.Element(t); 
        if (el.parent() 
            && (el.parent().is('td.x-date-mp-month') 
            || el.parent().is('td.x-date-mp-year'))) { 

            var p = picker.menu.picker; 
            p.setValue(p.activeDate); 
            p.fireEvent('select', p, p.value); 
        } 
    } 
}; 

Ext.preg('monthPickerPlugin', Ext.ux.MonthPickerPlugin);  

//~ /* 
  //~ http://www.diloc.de/blog/2008/03/05/how-to-submit-ext-forms-the-right-way/
//~ */
//~ /**
 //~ * This submit action is basically the same as the normal submit action,
 //~ * only that it uses the fields getSubmitValue() to compose the values to submit,
 //~ * instead of looping over the input-tags in the form-tag of the form.
 //~ *
 //~ * To use it, just use the OOSubmit-plugin on either a FormPanel or a BasicForm,
 //~ * or explicitly call form.doAction('oosubmit');
 //~ *
 //~ * @param {Object} form
 //~ * @param {Object} options
 //~ */
//~ Ext.ux.OOSubmitAction = function(form, options){
    //~ Ext.ux.OOSubmitAction.superclass.constructor.call(this, form, options);
//~ };

//~ Ext.extend(Ext.ux.OOSubmitAction, Ext.form.Action.Submit, {
    //~ /**
    //~ * @cfg {boolean} clientValidation Determines whether a Form's fields are validated
    //~ * in a final call to {@link Ext.form.BasicForm#isValid isValid} prior to submission.
    //~ * Pass <tt>false</tt> in the Form's submit options to prevent this. If not defined, pre-submission field validation
    //~ * is performed.
    //~ */
    //~ type : 'oosubmit',

    //~ // private
    //~ /**
     //~ * This is nearly a copy of the original submit action run method
     //~ */
    //~ run : function(){
        //~ var o = this.options;
        //~ var method = this.getMethod();
        //~ var isPost = method == 'POST';

        //~ var params = this.options.params || {};
        //~ if (isPost) Ext.applyIf(params, this.form.baseParams);

        //~ //now add the form parameters
        //~ this.form.items.each(function(field)
        //~ {
            //~ if (!field.disabled)
            //~ {
                //~ //check if the form item provides a specialized getSubmitValue() and use that if available
                //~ if (typeof field.getSubmitValue == "function")
                    //~ params[field.getName()] = field.getSubmitValue();
                //~ else
                    //~ params[field.getName()] = field.getValue();
            //~ }
        //~ });

        //~ //convert params to get style if we are not post
        //~ if (!isPost) params=Ext.urlEncode(params);

        //~ if(o.clientValidation === false || this.form.isValid()){
            //~ Ext.Ajax.request(Ext.apply(this.createCallback(o), {
                //~ url:this.getUrl(!isPost),
                //~ method: method,
                //~ params:params, //add our values
                //~ isUpload: this.form.fileUpload
            //~ }));

        //~ }else if (o.clientValidation !== false){ // client validation failed
            //~ this.failureType = Ext.form.Action.CLIENT_INVALID;
            //~ this.form.afterAction(this, false);
        //~ }
    //~ },

//~ });
//~ //add our action to the registry of known actions
//~ Ext.form.Action.ACTION_TYPES['oosubmit'] = Ext.ux.OOSubmitAction;




/**
JC Watsons solution (adapted to ExtJS 3.3.1 by LS) is elegant and simple:
`A "fix" for unchecked checkbox submission  behaviour
<http://www.sencha.com/forum/showthread.php?28449>`_

Added special handling for checkbox inputs. 
ExtJS defines disabled checkboxes `readonly`, not `disabled` as for other inputs.

*/
Ext.lib.Ajax.serializeForm = function(form) {
    //~ console.log('20120203 linolib.js serializeForm',form);
    var fElements = form.elements || (document.forms[form] || Ext.getDom(form)).elements, 
        hasSubmit = false, 
        encoder = encodeURIComponent, 
        name, 
        data = '', 
        type, 
        hasValue;

    Ext.each(fElements, function(element){
        name = element.name;
        type = element.type;

        if (!element.disabled && name && !(type == 'checkbox' && element.readonly)) {
            if (/select-(one|multiple)/i.test(type)) {
                Ext.each(element.options, function(opt){
                    if (opt.selected) {
                        hasValue = opt.hasAttribute ? opt.hasAttribute('value') : opt.getAttributeNode('value').specified;
                        data += String.format("{0}={1}&", encoder(name), encoder(hasValue ? opt.value : opt.text));
                    }
                });
            } else if (!(/file|undefined|reset|button/i.test(type))) {
                //~ if (!(/radio|checkbox/i.test(type) && !element.checked) && !(type == 'submit' && hasSubmit)) {
                if (!(type == 'submit' && hasSubmit)) {
                    if (type == 'checkbox') {
                        //~ console.log('20111001',element,'data += ',encoder(name) + '=' + (element.checked ? 'on' : 'off') + '&');
                        data += encoder(name) + '=' + (element.checked ? 'on' : 'off') + '&';
                    } else {
                        //~ console.log('20111001',element,'data += ',encoder(name) + '=' + encoder(element.value) + '&');
                        data += encoder(name) + '=' + encoder(element.value) + '&';
                    }
                    hasSubmit = /submit/i.test(type);
                }
            }
        //~ } else {
            //~ console.log(name,type,element.readonly);
        }
    });
    return data.substr(0, data.length - 1);
};



/*
Set a long timeout of fifteen minutes. 
See /blog/2012/0307
*/
Ext.Ajax.timeout = 15 * 60 * 1000; 


/*
My fix for the "Cannot set QuickTips dismissDelay to 0" bug,
see http://www.sencha.com/forum/showthread.php?183515 
*/
Ext.override(Ext.QuickTip,{
  showAt : function(xy){
        var t = this.activeTarget;
        //~ console.log("20120224 QuickTip.showAt",this.title,this.dismissDelay,t.dismissDelay);
        if(t){
            if(!this.rendered){
                this.render(Ext.getBody());
                this.activeTarget = t;
            }
            if(t.width){
                this.setWidth(t.width);
                this.body.setWidth(this.adjustBodyWidth(t.width - this.getFrameWidth()));
                this.measureWidth = false;
            } else{
                this.measureWidth = true;
            }
            this.setTitle(t.title || '');
            this.body.update(t.text);
            this.autoHide = t.autoHide;
            // bugfix by Luc 20120226
            if (t.dismissDelay != undefined) this.dismissDelay = t.dismissDelay;
            //~ this.dismissDelay = t.dismissDelay || this.dismissDelay;
            if(this.lastCls){
                this.el.removeClass(this.lastCls);
                delete this.lastCls;
            }
            if(t.cls){
                this.el.addClass(t.cls);
                this.lastCls = t.cls;
            }
            if(this.anchor){
                this.constrainPosition = false;
            }else if(t.align){ 
                xy = this.el.getAlignToXY(t.el, t.align);
                this.constrainPosition = false;
            }else{
                this.constrainPosition = true;
            }
        }
        Ext.QuickTip.superclass.showAt.call(this, xy);
    }
});

/*
Another hack. See /docs/blog/2012/0228
*/
Ext.Element.addMethods(
    function() {
        var VISIBILITY      = "visibility",
            DISPLAY         = "display",
            HIDDEN          = "hidden",
            NONE            = "none",
            XMASKED         = "x-masked",
            XMASKEDRELATIVE = "x-masked-relative",
            data            = Ext.Element.data;

        return {
            
            mask : function(msg, msgCls) {
                var me  = this,
                    dom = me.dom,
                    dh  = Ext.DomHelper,
                    EXTELMASKMSG = "ext-el-mask-msg",
                    el,
                    mask;
                // removed the following lines. See /docs/blog/2012/0228
                //~ if (!(/^body/i.test(dom.tagName) && me.getStyle('position') == 'static')) {
                    //~ console.log(20120228,dom.tagName,me);
                    //~ me.addClass(XMASKEDRELATIVE); 
                //~ }
                if (el = data(dom, 'maskMsg')) {
                    el.remove();
                }
                if (el = data(dom, 'mask')) {
                    el.remove();
                }

                mask = dh.append(dom, {cls : "ext-el-mask"}, true);
                data(dom, 'mask', mask);

                me.addClass(XMASKED);
                mask.setDisplayed(true);
                
                if (typeof msg == 'string') {
                    var mm = dh.append(dom, {cls : EXTELMASKMSG, cn:{tag:'div'}}, true);
                    data(dom, 'maskMsg', mm);
                    mm.dom.className = msgCls ? EXTELMASKMSG + " " + msgCls : EXTELMASKMSG;
                    mm.dom.firstChild.innerHTML = msg;
                    mm.setDisplayed(true);
                    mm.center(me);
                }
                
                
                if (Ext.isIE && !(Ext.isIE7 && Ext.isStrict) && me.getStyle('height') == 'auto') {
                    mask.setSize(undefined, me.getHeight());
                }
                
                return mask;
            }

            
        };
    }()
);



Ext.namespace('Lino');
    
    

//~ Lino.subst_user_field = new Ext.form.ComboBox({});
//~ Lino.subst_user = null;
Lino.insert_subst_user = function(p){
    //~ console.log('20120714 insert_subst_user',Lino.subst_user,p);
    //~ if (Lino.subst_user_field.getValue()) {
    if (p.su) return;
    if (Lino.subst_user) {
        //~ p.su = Lino.subst_user_field.getValue();
        p.su = Lino.subst_user;
    //~ } else {
        //~ delete p.su;
    }
    //~ console.log('20120714 insert_subst_user -->',Lino.subst_user,p);
}

Lino.login_window = null;


Lino.show_login_window = function() {
  //~ console.log('20121103 show_login_window',arguments);
  //~ var current_window = Lino.current_window;
  if (Lino.login_window == null) {
    
      function do_login() { 
            Lino.viewport.loadMask.show()
            //~ Lino.body_loadMask.show()
            login_panel.getForm().submit({ 
                method:'POST', 
                waitTitle:'Connecting', 
                waitMsg:'Sending data...',
                success:function(){ 
                  //~ console.log('20121104 logged in',arguments);
                  Lino.login_window.hide();
                  Lino.close_all_windows();
                  Lino.viewport.loadMask.hide()
                  //~ Lino.body_loadMask.hide()
                },
                failure: function(form,action) { 
                  //~ this.loadMask.hide();
                  Lino.on_submit_failure(form,action);
                  Lino.viewport.loadMask.hide()
                  //~ Lino.body_loadMask.hide()
                  //~ if (Lino.current_window) Lino.current_window.main_item.loadMask.hide()
                }
                //~ failure:function(form, action){ 
                    //~ alert_msg
                    //~ if(action.failureType == 'server'){ 
                        //~ obj = Ext.util.JSON.decode(action.response.responseText); 
                        //~ Ext.Msg.alert('Login Failed!', obj.errors.reason); 
                    //~ }else{ 
                        //~ Ext.Msg.alert('Warning!', 'Authentication server is unreachable : ' + action.response.responseText); 
                    //~ } 
                    //~ Lino.login_panel.getForm().reset(); 
                //~ } 
            }); 
      };
    
      var login_button = new Ext.Button({ 
        text:"Anmelden",
        formBind: true,	 
        // Function that fires when user clicks the button 
        handler: do_login});
    
      var login_panel = new Ext.FormPanel({ 
        //~ inspired by http://www.sencha.com/learn/a-basic-login/
        autoHeight:true,
        labelWidth:90,
        url:'/auth', 
        frame:true, 
        defaultType:'textfield',
        monitorValid:true,
        items:[{ 
            fieldLabel:"Benutzername", 
            id: 'username',
            name:'username', 
            autoHeight:true,
            allowBlank:false 
        },{ 
            fieldLabel:"Passwort", 
            name:'password', 
            inputType:'password', 
            autoHeight:true,
            allowBlank:false 
        }],        
        buttons:[ login_button ]});
        
      Lino.login_window = new Ext.Window({
          layout:'fit',
          defaultButton: 'username',
          width:300,
          title:"Anmelden", 
          autoHeight:true,
          modal: true,
          closeAction: "hide",
          keys: {
            key: Ext.EventObject.ENTER,
            fn: function() { do_login()}
          },
          //~ defaultButton: login_button,
          //~ height:'auto',
          //~ closable: false,
          //~ resizable: false,
          //~ plain: true,
          //~ border: false,
          items: [login_panel] });
  };
  Lino.login_window.show();
};

Lino.logout = function(id,name) {
    //~ console.log('20121104 gonna log out',arguments);
    //~ Lino.do_action
    Lino.call_ajax_action(Lino.viewport,'GET','/auth',{},'logout',undefined,undefined,function(){
        //~ console.log('20121104 logged out',arguments);
        //~ Lino.login_window.hide();
        Lino.close_all_windows();
    })
}

Lino.set_subst_user = function(id,name) {
    //~ console.log(20120714,'Lino.set_subst_user',id,name);
    Lino.subst_user = id;

    if(id) {
        Lino.eventStore.setBaseParam("su",id);
    } else {
      delete Lino.eventStore.baseParams['su'];
    }

    if (Lino.current_window) 
        Lino.current_window.main_item.set_base_param("su",id);
    if (Lino.viewport) Lino.permalink_handler(Lino.current_window)();
}



//~ Lino.select_subst_user = function(cmp,rec,value){
    //~ Lino.subst_user=value;
    //~ console.log(20120713,rec);
//~ }
    
Lino.current_window = null;
Lino.window_history = Array();
    
Lino.chars2width = function(cols) {  return cols * 9; }
Lino.rows2height = function(cols) {  return cols * 20; }



Lino.Viewport = Ext.extend(Ext.Viewport,{
  layout:"fit"
  ,initComponent : function(){
    Lino.Viewport.superclass.initComponent.call(this);
    this.on('render',function(){
      this.loadMask = new Ext.LoadMask(this.el,{msg:"Bitte warten..."});
      //~ console.log("20121118 Lino.viewport.loadMask",this.loadMask);
    },this);
  }
  ,get_base_params : function() { 
    var p = {};
    Lino.insert_subst_user(p);
    return p;
  }
  ,refresh : function() {
      var caller = this;
      console.log("20121120 Lino.Viewport.refresh()");
      if (caller.loadMask) caller.loadMask.show();
      var success = function(response) {
        if (caller.loadMask) caller.loadMask.hide();
        if (response.responseText) {
          var result = Ext.decode(response.responseText);
          //~ console.log('Lino.do_action()',action.name,'result is',result);
          if (result.html) {
              Ext.getCmp('main_area').update(result.html);
          }
          if (result.message) {
              if (result.alert) {
                  //~ Ext.MessageBox.alert('Alert',result.alert_msg);
                  Ext.MessageBox.alert('Alert',result.message);
              } else {
                  Lino.notify(result.message);
              }
          }
          
          if (result.notify_msg) Lino.notify(result.notify_msg);
          if (result.js_code) { 
            var jsr = result.js_code(caller);
            //~ console.log('Lino.do_action()',action,'returned from js_code in',result);
          };
        }
      };
      var action = {
        url : '/api/main_html',
        waitMsg: "Bitte warten...",
        failure: Lino.ajax_error_handler(caller),
        success: success,
        method: 'GET',
        params: {}
      };
      Lino.insert_subst_user(action.params);
      Ext.Ajax.request(action);
    
  }
});


Lino.open_window = function(win,st,requesting_panel) {
  //~ console.log("20120918 Lino.open_window()",win,st);
  var cw = Lino.current_window;
  if (cw) {
    //~ console.log("20120918 Lino.open_window() save current status",cw.main_item.get_status());
    Lino.window_history.push({
      window:cw,
      status:cw.main_item.get_status()
    });
  }
  Lino.current_window = win;
  //~ if (st.su) 
      //~ Lino.subst_user_field.setValue(st.su);
  win.main_item.set_status(st,requesting_panel);
  win.show();
};

Lino.load_url = function(url) {
    //~ foo.bar.baz = 2; 
    //~ console.log("20121120 Lino.load_url()");
    //~ Lino.body_loadMask.show();
    Lino.viewport.loadMask.show();
    //~ location.replace(url);
    document.location = url;
}

Lino.close_window = function(status_update) {
  var cw = Lino.current_window;
  var ww = Lino.window_history.pop();
  if (ww) {
    //~ if (status_update) Ext.apply(ww.status,status_update);
    if (status_update) status_update(ww);
    ww.window.main_item.set_status(ww.status);
    Lino.current_window = ww.window;
  } else {
    Lino.current_window = null;
  }
  if (cw) cw.hide_really();
};

Lino.close_all_windows = function() {
  if (Lino.window_history.length == 0) {
      //~ Lino.viewport.refresh();
      var url =  "/"
      //~ console.log("20121120 Lino.close_all_windows() : no window_history");
      //~ if (ADMIN_URL) 
      var p = {};
      Lino.insert_subst_user(p)
      if (Ext.urlEncode(p)) url = url + "?" + Ext.urlEncode(p);
      Lino.load_url(url);
  } else {
    //~ console.log("20121120 Lino.close_all_windows() with window_history");
    while (Lino.window_history.length > 0) {
      Lino.close_window();
      //~ Lino.window_history.pop().hide_really();
    }
  }
  //~ Lino.current_window = null;
  //~ Lino.close_window();
  //~ var ww = 
}

Lino.kill_current_window = function() {
  var cw = Lino.current_window;
  Lino.current_window = null;
  if (cw) cw.hide_really();
};

Lino.calling_window = function() {
    if (Lino.window_history.length) return Lino.window_history[Lino.window_history.length-1];
}

//~ Lino.WindowAction = function(mainItemClass,windowConfig,mainConfig,ppf) {
Lino.WindowAction = function(windowConfig,main_item_fn) {
    //~ if(!mainConfig) mainConfig = {};
    //~ mainConfig.is_main_window = true;
    this.windowConfig = windowConfig;
    this.main_item_fn = main_item_fn;
    //~ if (ppf) mainConfig.params_panel.fields = ppf;
    //~ this.mainConfig = mainConfig;
    //~ this.mainItemClass = mainItemClass;
};

Lino.WindowAction = Ext.extend(Lino.WindowAction,{
    window : null,
    //~ mainItemClass: null,
    get_window : function() {
      //~ if(mainConfig) Ext.apply(this.mainConfig,mainConfig);
      if (this.window == null)  {
          //~ this.windowConfig.main_item = new this.mainItemClass(this.mainConfig);
          this.windowConfig.main_item = this.main_item_fn();
          this.window = new Lino.Window(this.windowConfig);
      }
      return this.window;
    },
    run : function(requesting_panel,status) {
      //~ console.log('20120625 window_action.run()',this)
      Lino.open_window(this.get_window(),status,requesting_panel);
    }
  
});


Lino.PanelMixin = {
  get_containing_window : function (){
      if (this.containing_window) return this.containing_window;
      return this.containing_panel.get_containing_window();
  }
  ,set_window_title : function(title) {
    //~ this.setTitle(title);
    var cw = this.get_containing_window();

    //~ if (cw) {
    //~ if (cw && cw.closable) {
    if (cw && !cw.main_item.hide_window_title) {
      //~ console.log('20111202 set_window_title(',title,') for',this.containing_window);
      //~ if (! this.containing_window.rendered) console.log("WARNING: not rendered!");
      cw.setTitle(title);
    //~ } else {
      //~ document.title = title;
    }
    //~ else console.log('20111202 not set_window_title(',title,') for',this);
  }
  
};


Lino.status_bar = new Ext.ux.StatusBar({defaultText:'Lino version 1.6.7.'});



Lino.edit_tinymce_text = function(panel,options) {
  // `panel` is the RichTextPanel
  //~ console.log(20111220,panel);
  //~ var rec = panel.get_current_record();
  var rec = panel.containing_panel.get_current_record();
  var value = rec ? rec.data[panel.editor.name] : '';
  var saving = false;
  var todo_after_save = false;
  var discard_changes = false;
  
  
  function save() {
    //~ if (todo_after_save) {alert('tried to save again'); return; }
    if (saving) {alert('tried to save again'); return; }
    //~ var url = panel.containing_window.main_item.get_record_url(rec.id);
    var url = panel.containing_panel.get_record_url(rec.id);
    var params = Ext.apply({},panel.containing_panel.get_base_params());
    params[panel.editor.name] = editor.getValue();
    //~ params.su = Lino.subst_user;
    //~ Lino.insert_subst_user(params);
    var a = { 
      params: params, 
      method: 'PUT',
      url: url,
      failure: function() {
          //~ if (editor.ed.getContainer()) 
          editor.ed.setProgressState(0);
          todo_after_save = false;
          saving = false;
          console.log('tinymce.save() failed. sorry.',arguments);
        },
      success: function() {
        saving = false;
        //~ if (editor.ed.getContainer()) 
        editor.ed.setProgressState(0);
        rec.data[panel.editor.name] = editor.getValue();
        if(todo_after_save) {
            var fn = todo_after_save;
            todo_after_save = false;
            fn();
        }
        //~ panel.containing_window.set_current_record(rec);
        panel.refresh();
      }
    };
    //~ if (editor.ed.getContainer()) 
    editor.ed.setProgressState(1); // Show progress
    saving = true;
    //~ console.log(a);
    Ext.Ajax.request(a);
  };
  function save_callback() {
      save();
      //~ save(function(){editor.ed.setDirty(false);})
      /* return true have the save button disabled.  
      That's not perfect because the PUT is asynchronous 
      and the response is not yet known.
      */
      return true;
  }
  //~ var actions = [
    //~ {text:"Save",handler:save}
  //~ ]; 
  //~ console.log(20110610,panel.editor.disabled);
  var settings = {};
  Ext.apply(settings,{
        readonly: panel.editor.disabled,
        //~ language: "de",
        plugins : "save,emotions,spellchecker,advhr,insertdatetime,preview,table,searchreplace,template", 
        // Theme options - button# indicated the row# only
        theme_advanced_buttons1 : "save,cancel,|,bold,italic,underline,|,justifyleft,justifycenter,justifyright,fontselect,fontsizeselect,formatselect,|,search,replace",
        theme_advanced_buttons2 : "cut,copy,paste,template,|,bullist,numlist,|,outdent,indent,|,undo,redo,|,link,unlink,anchor,image,|,code,preview,|,forecolor,backcolor",
        theme_advanced_buttons3 : "insertdate,inserttime,|,spellchecker,advhr,,removeformat,|,sub,sup,|,charmap,emotions,|,tablecontrols",      
        theme_advanced_resizing : false,
        convert_urls : false,
        save_onsavecallback : save_callback,
        save_enablewhendirty : true
        //~ save_oncancelcallback: on_cancel
  });
  Ext.apply(settings,options);
  var editor = new Ext.ux.TinyMCE({
      value : value,
      tinymceSettings: settings
    });
  var win = new Ext.Window({
    title: rec.title, 
    //~ bbar: actions,
    layout: 'fit',
    items: editor,
    width: 600, 
    height:500,
    minWidth: 100,
		minHeight: 100,
    modal: true,
    resizable: true,
    maximizable: true,
    //~ maximized: true,
    //~ closeAction: "close"
    closeAction: "hide"
    //~ hideMode: "offsets",
    //~ constrainHeader: true,
    //~ bodyStyle: 'padding: 10px'
  });

  //~ win.on('beforeclose',function() {
  win.on('beforehide',function() {
    if (todo_after_save) return false;
    if (discard_changes) return true;
    if (editor.isDirty()) {
        //~ var ok = false;
        //~ var allowClose = true;
        var config = {title:"Bestätigung"};
        config.buttons = Ext.MessageBox.YESNOCANCEL;
        config.msg = "Änderungen im Text speichern?";
        config.modal = true;
        config.fn = function(buttonId,text,opt) {
          //~ console.log('do_when_clean',buttonId)
          if (buttonId == "yes") {
              /* we cancel this close, but save()'s onSuccess will call again.*/
              //~ allowClose = false;
              todo_after_save = function(){win.hide();}
              editor.ed.execCommand('mceSave');
              //~ editor.ed.save(function(){win.close();});
          } else if (buttonId == "no") { 
              discard_changes = true;
              win.hide()
          //~ } else if (buttonId == "cancel") { 
            //~ ok = true;
              //~ allowClose = false;
          //~ } else { 
            //~ console.log('unknwon buttonId:',buttonId);
          }
        }
        Ext.MessageBox.show(config);
        return false;
        //~ return allowClose;
    }
  });
  win.show();
}







/* 
  Originally copied from Ext JS Library 3.3.1
  Modifications by Luc Saffre : 
  - rendering of phantom records
  - fire afteredit event
  - react on dblclcik, not on single click

 */
Lino.CheckColumn = Ext.extend(Ext.grid.Column, {

    processEvent : function(name, e, grid, rowIndex, colIndex){
        //~ console.log('20110713 Lino.CheckColumn.processEvent',name)
        if (name == 'click') {
        //~ if (name == 'mousedown') {
        //~ if (name == 'dblclick') {
            return this.toggleValue(grid, rowIndex, colIndex);
        } else {
            return Ext.grid.ActionColumn.superclass.processEvent.apply(this, arguments);
        }
    },
    
    toggleValue : function (grid,rowIndex,colIndex) {
        var record = grid.store.getAt(rowIndex);
        var dataIndex = grid.colModel.getDataIndex(colIndex);
        // 20120514
        //~ if(record.data.disabled_fields && record.data.disabled_fields[dataIndex]) {
          //~ Lino.notify("Dieses Feld ist deaktiviert");
          //~ return false;
        //~ }
      
        //~ if (dataIndex in record.data['disabled_fields']) {
            //~ Lino.notify("This field is disabled.");
            //~ return false;
        //~ }
        var startValue = record.data[dataIndex];
        var value = !startValue;
        //~ record.set(this.dataIndex, value);
        var e = {
            grid: grid,
            record: record,
            field: dataIndex,
            originalValue: startValue,
            value: value,
            row: rowIndex,
            column: colIndex,
            cancel: false
        };
        if(grid.fireEvent("beforeedit", e) !== false && !e.cancel){
        //~ if(grid.fireEvent("validateedit", e) !== false && !e.cancel){
            record.set(dataIndex, value);
            delete e.cancel;
            grid.fireEvent("afteredit", e);
        }
        return false; // Cancel event propagation
    },

    renderer : function(v, p, record){
        if (record.phantom) return '';
        p.css += ' x-grid3-check-col-td'; 
        return String.format('<div class="x-grid3-check-col{0}">&#160;</div>', v ? '-on' : '');
    }

    // Deprecate use as a plugin. Remove in 4.0
    // init: Ext.emptyFn
});

// register ptype. Deprecate. Remove in 4.0
// Ext.preg('checkcolumn', Lino.CheckColumn);

// backwards compat. Remove in 4.0
// Ext.grid.CheckColumn = Lino.CheckColumn;

// register Column xtype
Ext.grid.Column.types.checkcolumn = Lino.CheckColumn;


/* 20110725 : 
Lino.on_tab_activate is necessary 
in contacts.Person.2.dtl 
(but don't ask me why...)
*/
Lino.on_tab_activate = function(item) {
  //~ console.log('activate',item); 
  if (item.rendered && item.doLayout) item.doLayout();
  //~ if (item.rendered) item.doLayout();
}

Lino.TimeField = Ext.extend(Ext.form.TimeField,{
  format: 'H:i',
  increment: 15
  });
Lino.DateField = Ext.extend(Ext.form.DateField,{
  boxMinWidth: Lino.chars2width(11),
  format: 'd.m.Y',
  altFormats: 'd/m/Y|Y-m-d'
  });
Lino.DatePickerField = Ext.extend(Ext.DatePicker,{
  //~ boxMinWidth: Lino.chars2width(11),
  format: 'd.m.Y',
  //~ altFormats: 'd/m/Y|Y-m-d'
  formatDate : function(date){
      console.log("20121203 formatDate",this.name,date);
      return Ext.isDate(date) ? date.dateFormat(this.format) : date;
  }
  });
Lino.DateTimeField = Ext.extend(Ext.ux.form.DateTime,{
  dateFormat: 'd.m.Y',
  timeFormat: 'H:i',
  //~ hiddenFormat: 'd.m.Y H:i'
  });
Lino.URLField = Ext.extend(Ext.form.TriggerField,{
  triggerClass : 'x-form-search-trigger',
  //~ triggerClass : 'x-form-world-trigger',
  vtype: 'url',
  onTriggerClick : function() {
    //~ console.log('Lino.URLField.onTriggerClick',this.value)
    //~ document.location = this.value;
    window.open(this.getValue(),'_blank');
  }
});
Lino.IncompleteDateField = Ext.extend(Ext.form.TextField,{
  //~ regex: /^-?\d+-[01]\d-[0123]\d$/,
  //~ regex: /^[0123]\d\.[01]\d\.-?\d+$/,
  maxLength: 10,
  boxMinWidth: Lino.chars2width(10),
  regex: /^[0123]?\d\.[01]?\d\.-?\d+$/,
  regexText: 'Datum im Format JJJJ-MM-TT eingeben (Nullen für unbekannte Teile)'
  });


//~ Lino.make_dropzone = function(cmp) {
    //~ cmp.on('render', function(ct, position){
      //~ ct.el.on({
        //~ dragenter:function(event){
          //~ event.browserEvent.dataTransfer.dropEffect = 'move';
          //~ return true;
        //~ }
        //~ ,dragover:function(event){
          //~ event.browserEvent.dataTransfer.dropEffect = 'move';
          //~ event.stopEvent();
          //~ return true;
        //~ }
        //~ ,drop:{
          //~ scope:this
          //~ ,fn:function(event){
            //~ event.stopEvent();
            //~ console.log(20110516);
            //~ var files = event.browserEvent.dataTransfer.files;
            //~ if(files === undefined){
              //~ return true;
            //~ }
            //~ var len = files.length;
            //~ while(--len >= 0){
              //~ console.log(files[len]);
              //~ // this.processDragAndDropFileUpload(files[len]);
            //~ }
          //~ }
        //~ }
      //~ });
    //~ });
//~ };

//~ Lino.FileUploadField = Ext.ux.form.FileUploadField;

Lino.FileUploadField = Ext.extend(Ext.ux.form.FileUploadField,{
    onRender : function(ct, position){
      Lino.FileUploadField.superclass.onRender.call(this, ct, position);
      this.el.on({
        dragenter:function(event){
          event.browserEvent.dataTransfer.dropEffect = 'move';
          return true;
        }
        ,dragover:function(event){
          event.browserEvent.dataTransfer.dropEffect = 'move';
          event.stopEvent();
          return true;
        }
        ,drop:{
          scope:this
          ,fn:function(event){
            event.stopEvent();
            //~ console.log(20110516);
            var files = event.browserEvent.dataTransfer.files;
            if(files === undefined){
              return true;
            }
            var len = files.length;
            while(--len >= 0){
              console.log(files[len]);
              //~ this.processDragAndDropFileUpload(files[len]);
            }
          }
        }
      });
    }
});

Lino.FileField = Ext.extend(Ext.form.TriggerField,{
  triggerClass : 'x-form-search-trigger',
  editable: false,
  onTriggerClick : function() {
    //~ console.log('Lino.URLField.onTriggerClick',this.value)
    //~ document.location = this.value;
    if (this.getValue()) window.open(MEDIA_URL + '/'+this.getValue(),'_blank');
  }
});

Lino.file_field_handler = function(panel,config) {
  //~ if (instanceof Lino.DetailWrapper) {
  if (panel.action_name == 'insert') {
  //~ if (panel.get_current_record().phantom) {
      panel.has_file_upload = true;

      var f = new Lino.FileUploadField(config);
      //~ Lino.make_dropzone(f);
      return f;
      //~ return new Ext.ux.form.FileUploadField(config);
      //~ return new Lino.FileField(config);
      
  } else {
      //~ return new Lino.URLField(config);
      return new Lino.FileField(config);
  }
}

Lino.VBorderPanel = Ext.extend(Ext.Panel,{
    constructor : function(config) {
      config.layout = 'border';
      delete config.layoutConfig;
      Lino.VBorderPanel.superclass.constructor.call(this,config);
      for(var i=0; i < this.items.length;i++) {
        var item = this.items.get(i);
        if (this.isVertical(item) && item.collapsible) {
          item.on('collapse',this.onBodyResize,this);
          item.on('expand',this.onBodyResize,this);
        }
      }
    },
    isVertical : function(item) {
       return (item.region == 'north' || item.region == 'south' || item.region == 'center');
    },
    onBodyResize: function(w, h){
        //~ console.log('VBorderPanel.onBodyResize',this.title)
      if (this.isVisible()) { // to avoid "Uncaught TypeError: Cannot call method 'getHeight' of undefined."
        var sumflex = 0;
        var availableHeight = this.getInnerHeight();
        var me = this;
        this.items.each(function(item){
          if (me.isVertical(item)) {
              if (item.collapsed || item.flex == 0 || item.flex === undefined) {
                  if (item.rendered) availableHeight -= item.getHeight();
              } else {
                  sumflex += item.flex;
              }
          } 
          
        });
        //~ for(var i=0; i < this.items.length;i++) {
          //~ var item = this.items.get(i);
          //~ // if (this.isVertical(item) && item.getResizeEl()) {
          //~ if (this.isVertical(item)) {
              //~ if (item.collapsed || item.flex == 0 || item.flex === undefined) {
                  //~ // item.syncSize()
                  //~ // item.doLayout()
                  //~ // if (item.region == "north") console.log('region north',item.getHeight(),item.id, item);
                  //~ // if (item.getHeight() == 0) console.log(20100921,'both flex and getHeight() are 0!');
                  //~ availableHeight -= item.getHeight();
              //~ } else {
                  //~ sumflex += item.flex;
                  //~ // console.log(item.flex);
              //~ }
          //~ } 
          //~ // else console.log('non-vertical item in VBoderPanel:',item)
        //~ }
        var hunit = availableHeight / sumflex;
        //~ console.log('sumflex=',sumflex,'hunit=',hunit, 'availableHeight=',availableHeight);
        for(var i=0; i < this.items.length;i++) {
          var item = this.items.get(i);
          if (this.isVertical(item)) {
              if (item.flex != 0 && ! item.collapsed) {
                  item.setHeight(hunit * item.flex);
                  //~ console.log(item.region,' : height set to',item.getHeight());
              }
          }
          //~ else console.log('non-vertical item in VBoderPanel:',item)
        }
      }
      Lino.VBorderPanel.superclass.onBodyResize.call(this, w, h);
    }
});


/*
  modifications to the standard behaviour of a CellSelectionModel:
  
*/
Ext.override(Ext.grid.CellSelectionModel, {
//~ var dummy = {

    handleKeyDown : function(e){
        /* removed because F2 wouldn't pass
        if(!e.isNavKeyPress()){
            return;
        }
        */
        //~ console.log('handleKeyDown',e)
        var k = e.getKey(),
            g = this.grid,
            s = this.selection,
            sm = this,
            walk = function(row, col, step){
                return g.walkCells(
                    row,
                    col,
                    step,
                    g.isEditor && g.editing ? sm.acceptsNav : sm.isSelectable, 
                    sm
                );
            },
            cell, newCell, r, c, ae;

        switch(k){
            case e.ESC:
            case e.PAGE_UP:
            case e.PAGE_DOWN:
                break;
            default:
                // e.stopEvent(); // removed because Browser keys like Alt-Home, Ctrl-R wouldn't work
                break;
        }

        if(!s){
            cell = walk(0, 0, 1); 
            if(cell){
                this.select(cell[0], cell[1]);
            }
            return;
        }

        cell = s.cell;  
        r = cell[0];    
        c = cell[1];    
        
        switch(k){
            case e.TAB:
                if(e.shiftKey){
                    newCell = walk(r, c - 1, -1);
                }else{
                    newCell = walk(r, c + 1, 1);
                }
                break;
            case e.HOME:
                if (! (g.isEditor && g.editing)) {
                  if (!e.hasModifier()){
                      newCell = [r, 0];
                      //~ console.log('home',newCell);
                      break;
                  }else if(e.ctrlKey){
                      var t = g.getTopToolbar();
                      var activePage = Math.ceil((t.cursor + t.pageSize) / t.pageSize);
                      if (activePage > 1) {
                          e.stopEvent();
                          t.moveFirst();
                          return;
                      }
                      newCell = [0, c];
                      break;
                  }
                }
            case e.END:
                if (! (g.isEditor && g.editing)) {
                  c = g.colModel.getColumnCount()-1;
                  if (!e.hasModifier()) {
                      newCell = [r, c];
                      //~ console.log('end',newCell);
                      break;
                  }else if(e.ctrlKey){
                      var t = g.getTopToolbar();
                      var d = t.getPageData();
                      if (d.activePage < d.pages) {
                          e.stopEvent();
                          var self = this;
                          t.on('change',function(tb,pageData) {
                              var r = g.store.getCount()-2;
                              self.select(r, c);
                              //~ console.log('change',r,c);
                          },this,{single:true});
                          t.moveLast();
                          return;
                      } else {
                          newCell = [g.store.getCount()-1, c];
                          //~ console.log('ctrl-end',newCell);
                          break;
                      }
                  }
                }
            case e.DOWN:
                newCell = walk(r + 1, c, 1);
                break;
            case e.UP:
                newCell = walk(r - 1, c, -1);
                break;
            case e.RIGHT:
                newCell = walk(r, c + 1, 1);
                break;
            case e.LEFT:
                newCell = walk(r, c - 1, -1);
                break;
            case e.F2:
                if (!e.hasModifier()) {
                    if (g.isEditor && !g.editing) {
                        g.startEditing(r, c);
                        e.stopEvent();
                        return;
                    }
                    break;
                }
            case e.INSERT:
                if (!e.hasModifier()) {
                    if (g.ls_insert_handler && !g.editing) {
                        e.stopEvent();
                        Lino.show_insert(g);
                        return;
                    }
                    break;
                }
            case e.DELETE:
                if (!e.hasModifier()) {
                    if (!g.editing) {
                        e.stopEvent();
                        Lino.delete_selected(g);
                        return;
                    }
                    break;
                }
            case e.ENTER:
                e.stopEvent();
                g.onCellDblClick(r,c);
                break;
                
        }
        

        if(newCell){
          e.stopEvent();
          r = newCell[0];
          c = newCell[1];
          this.select(r, c); 
          if(g.isEditor && g.editing){ 
            ae = g.activeEditor;
            if(ae && ae.field.triggerBlur){
                ae.field.triggerBlur();
            }
            g.startEditing(r, c);
          }
        //~ } else if (g.isEditor && !g.editing && e.charCode) {
        //~ // } else if (!e.isSpecialKey() && g.isEditor && !g.editing) {
            //~ g.set_start_value(String.fromCharCode(e.charCode));
            //~ // g.set_start_value(String.fromCharCode(k));
            //~ // g.set_start_value(e.charCode);
            //~ g.startEditing(r, c);
            //~ // e.stopEvent();
            //~ return;
        // } else {
          // console.log('20120513',e,g);
        }
        
    }


//~ };
});

 

function PseudoConsole() {
    this.log = function() {};
};
if (typeof(console) == 'undefined') console = new PseudoConsole();

Lino.notify = function(msg) {
  if (msg == undefined) msg = ''; else console.log(msg);
  //~ Ext.getCmp('konsole').update(msg);
  Lino.status_bar.setStatus({
    text: msg,
    iconCls: 'ok-icon',
    clear: true // auto-clear after a set interval
  });
  //~ Ext.getCmp('konsole').setTitle(msg.replace(/\n/g,'<br/>'));
  //~ Ext.getCmp('konsole').update(msg.replace(/\n/g,'<br/>'));
};
Lino.alert = function(msg) {
  //~ if (msg == undefined) msg = ''; else console.log(msg);
  Ext.MessageBox.alert('Notify',msg);
};


//~ Lino.show_about = function() {
  //~ new Ext.Window({
    //~ width: 400, height: 400,
    //~ title: "About",
    //~ html: '<a href="http://www.extjs.com" target="_blank">ExtJS</a> version ' + Ext.version
  //~ }).show();
//~ };

function obj2str(o) {
  if (typeof o != 'object') return String(o);
  var s = '';
  for (var p in o) {
    s += p + ': ' + obj2str(o[p]) + '\n';
  }
  return s;
}

Lino.on_store_exception = function (store,type,action,options,response,arg) {
  //~ throw response;
  console.log("on_store_exception: store=",store,
    "type=",type,
    "action=",action,
    "options=",options,
    "response=",response,
    "arg=",arg);
  if (arg) { console.log(arg.stack)};
};

//~ Lino.on_submit_success = function(form, action) {
   //~ Lino.notify(action.result.message);
   //~ this.close();
//~ };

Lino.on_submit_failure = function(form, action) {
    //~ Lino.notify();
  // action may be undefined
    switch (action.failureType) {
        case Ext.form.Action.CLIENT_INVALID:
            Ext.Msg.alert('Client-side failure', 'Form fields may not be submitted with invalid values');
            break;
        case Ext.form.Action.CONNECT_FAILURE:
            Ext.Msg.alert('Connection failure', 'Ajax communication failed');
            break;
        case Ext.form.Action.SERVER_INVALID:
            Ext.Msg.alert('Server-side failure', action.result.message);
   }
};



/*
Lino.save_wc_handler = function(ww) {
  return function(event,toolEl,panel,tc) {
    var pos = panel.getPosition();
    var size = panel.getSize();
    wc = ww.get_window_config();
    Ext.applyIf(wc,{ 
      x:pos[0],y:pos[1],height:size.height,width:size.width,
      maximized:panel.maximized});
    Lino.do_action(ww,{url:'/window_configs/'+ww.config.permalink_name,params:wc,method:'POST'});
  }
};

*/

Lino.show_in_own_window_button = function(handler) {
  return {
    qtip: "Dieses Panel in eigenem Fenster öffnen", 
    id: "up",
    handler: function(event,toolEl,panel, tc) {
      //~ console.log('20111206 report_window_button',panel,handler);
      //~ var bp = ww.get_master_params();
      //~ panel.containing_window = ww; // for HtmlBox. see blog/2010/1022
      //~ handler(panel,{base_params:bp});
      //~ handler(panel,{base_params:panel.get_master_params()});
      handler.run(null,{base_params:panel.containing_panel.get_master_params()});
      //~ handler(panel,{master_panel:panel.containing_window.main_item});
    }
  }
}




Lino.delete_selected = function(panel) {
  //~ console.log("Lino.delete_selected",panel);
  var recs1 = panel.get_selected();
  var recs = [];
  for ( var i=0; i < recs1.length; i++ ) { if (! recs1[i].phantom) recs.push(recs1[i]); }
  if (recs.length == 0) {
    Lino.notify("Please select at least one record.");
    return;
  };
  if (recs.length == 1) {
      if (recs[0].disable_delete) {
        Lino.alert(recs[0].disable_delete);
        return;
      }
  };
  //~ console.log(recs);
  Ext.MessageBox.show({
    title: "Bestätigung",
    msg: String.format("Es werden {0} Datensätze gelöscht. Sind Sie sicher?",String(recs.length)),
    //~ msg: "Delete " + String(recs.length) + " rows. Are you sure?",
    //~ buttons: Ext.MessageBox.YESNOCANCEL,
    buttons: Ext.MessageBox.YESNO,
    fn: function(btn) {
      if (btn == 'yes') {
        for ( var i=0; i < recs.length; i++ ) {
          Lino.do_action(panel,{
              method:'DELETE',
              url:  '/api' + panel.ls_url + '/' + recs[i].id,
              after_success: panel.after_delete.createDelegate(panel)
          })
        }
        //~ caller.after_delete();
      }
      else Lino.notify("Dann eben nicht.");
    }
  });
};

Lino.action_handler = function (panel,on_success,on_confirm) {
  return function (response) {
    //~ console.log(20120608,panel);
    if (panel instanceof Lino.GridPanel) {
        //~ gridmode = false;
        gridmode = true;
        //~ console.log('20120608 yes');
    } else {
        gridmode = false;
        //~ console.log('20120608 no');
    }
    panel.loadMask.hide(); // 20120211
    if (!response.responseText) return ;
    var result = Ext.decode(response.responseText);
    //~ console.log('Lino.action_handler()','result is',result,'on_confirm is',on_confirm);
    
    if (result.eval_js) {
        //~ console.log(20120618,result.eval_js);
        eval(result.eval_js);
    }
    
    if (result.xcallback) {
        //~ var config = {title:"Bestätigung"};
        var config = {title:result.xcallback.title};
        //~ config.buttons = Ext.MessageBox.YESNOCANCEL;
        //~ config.buttons = Ext.MessageBox.YESNO;
        config.buttons = result.xcallback.buttons;
        config.msg = result.message;
        config.fn = function(buttonId,text,opt) {
          panel.loadMask.show(); 
          //~ Lino.insert_subst_user(p);
          Ext.Ajax.request({
            method: 'GET',
            url: '/callbacks/'+result.xcallback.id + '/' + buttonId,
            //~ params: {bi: buttonId},
            success: Lino.action_handler(panel,on_success,on_confirm)
          });
          //~ Lino.call_ajax_action(panel,'GET',)
        }
        Ext.MessageBox.show(config);
        return;
    }
    
    if (on_success && result.success) on_success(result);
    
    //~ if (on_confirm && result.confirm_message) {
        //~ var config = {title:"Bestätigung"};
        //~ // config.buttons = Ext.MessageBox.YESNOCANCEL;
        //~ config.buttons = Ext.MessageBox.YESNO;
        //~ config.msg = result.confirm_message;
        //~ config.fn = function(buttonId,text,opt) {
          //~ if (buttonId == "yes") {
              //~ on_confirm(panel,undefined,result.step);
          //~ }
        //~ }
        //~ Ext.MessageBox.show(config);
        //~ return;
    //~ }
    //~ if (result.dialog_fn) {
        //~ console.log('20120928 TODO',result.dialog_fn);
    //~ }
    if (result.message) {
        //~ if (result.alert && ! gridmode) {
        if (result.alert) { // 20120628b 
            //~ Ext.MessageBox.alert('Alert',result.alert_msg);
            if (result.alert === true) result.alert = "Alarm";
            Ext.MessageBox.alert(result.alert,result.message);
        } else {
            Lino.notify(result.message);
        }
    }
    // 
    if (result.data_record && ! gridmode) {
        //~ not used
        panel.set_status({data_record:result.data_record});
    }
    else if (result.new_status && ! gridmode) {
        //~ not used
        //~ console.log('20120607 new_status');
        panel.set_status(result.new_status);
    }
    else if (result.goto_record_id != undefined && ! gridmode) {
        //~ console.log('20120607 new_status');
        panel.load_record_id(result.goto_record_id);
    }
    else if (result.refresh_all) {
        var cw = panel.get_containing_window();
        //~ console.log("20120123 refresh_all");
        if (cw) {
          cw.main_item.refresh();
        }
        else console.log("20120123 cannot refresh_all",panel);
    } else {
        //~ console.log("20121212 b gonna refresh",panel);
        if (result.refresh) panel.refresh();
    }
    
    if (result.open_url) {
        //~ console.log(20111126,result.open_url);
        //~ if (!result.message)
            //~ Lino.notify('Open new window <a href="'+result.open_url+'" target="_blank">'+result.open_url+'</a>');
        window.open(result.open_url,'foo',"");
        //~ document.location = result.open_url;
    }
  }
};

Lino.do_action = function(caller,action) {
  action.success = function(response) {
    if (caller.loadMask) caller.loadMask.hide();
    //~ console.log('Lino.do_action()',action,'action success',response);
    if (action.after_success) {
        //~ console.log('Lino.do_action() calling after_success');
        action.after_success();
    }
    if (response.responseText) {
      var result = Ext.decode(response.responseText);
      //~ console.log('Lino.do_action()',action.name,'result is',result);
      if (result.message) {
          if (result.alert) {
              //~ Ext.MessageBox.alert('Alert',result.alert_msg);
              Ext.MessageBox.alert('Alert',result.message);
          } else {
              Lino.notify(result.message);
          }
      }
      
      //~ if (result.alert_msg) Ext.MessageBox.alert('Alert',result.alert_msg);
      //~ if (result.message) Lino.notify(result.message);
      if (result.notify_msg) Lino.notify(result.notify_msg);
      if (result.js_code) { 
        //~ console.log('Lino.do_action()',action,'gonna call js_code in',result);
        var jsr = result.js_code(caller);
        //~ console.log('Lino.do_action()',action,'returned from js_code in',result);
        if (action.after_js_code) {
          //~ console.log('Lino.do_action()',action,'gonna call after_js_code');
          action.after_js_code(jsr);
          //~ console.log('Lino.do_action()',action,'returned from after_js_code');
        //~ } else {
          //~ console.log('Lino.do_action()',action,' : after_js_code is false');
        }
      };
    }
  };
  Ext.applyIf(action,{
    waitMsg: "Bitte warten...",
    failure: Lino.ajax_error_handler(caller),
    params: {}
  });
  //~ action.params.su = Lino.subst_user;
  Lino.insert_subst_user(action.params);
  
  Ext.Ajax.request(action);
};

//~ Lino.gup = function( name )
//~ {
  //~ // Thanks to http://www.netlobo.com/url_query_string_javascript.html
  //~ name = name.replace(/[\[]/,"\\\[").replace(/[\]]/,"\\\]");
  //~ var regexS = "[\\?&]"+name+"=([^&#]*)";
  //~ var regex = new RegExp( regexS );
  //~ var results = regex.exec( window.location.href );
  //~ if( results == null )
    //~ return "";
  //~ else
    //~ return results[1];
//~ };

//~ Lino.refresh_handler = function (ww) {
  //~ return function() { 
      //~ console.log('refresh',ww);
      //~ ww.main_item.doLayout(false,true);
      //~ ww.main_item.syncSize();
  //~ }
//~ };

//~ Lino.tools_close_handler = function (ww) {
  //~ return function() { 
      //~ ww.close();
  //~ }
//~ };
Lino.permalink_handler = function (ww) {
  return function() { 
    //~ console.log(20100923,ww.get_permalink());
    //~ document.location = ww.main_item.get_permalink();
    Lino.load_url(ww.main_item.get_permalink());
    //~ console.log(20120715, ww.main_item.get_permalink());
    //~ document.location = "?permalink=" + ww.get_permalink();
    //~ document.location = "?permalink=" + ww.config.permalink_name +'()';
  }
};
//~ Lino.run_permalink = function() {
  //~ var plink = Lino.gup('permalink');
  //~ if(plink) { eval('Lino.'+plink); }
//~ }

Lino.MainPanel = {
  is_home_page : false,
  setting_param_values : false,
  config_containing_window : function(wincfg) { }
  ,init_containing_window : function(win) { }
  ,is_loading : function() { return true; } // overridden by subclasses
  ,do_when_clean : function(auto_save,todo) { todo() }
  ,get_master_params : function() {
    var p = {}
    p['mt'] = this.content_type; 
    rec = this.get_current_record()
    if (rec) {
      if (rec.phantom) {
          p['mk'] = undefined; 
      }else{
          p['mk'] = rec.id; 
      }
    } else {
      p['mk'] = undefined;
    }
    //~ console.log('get_master_params returns',p,'using record',rec);
    return p;
  }
  ,get_permalink : function() {
    //~ var p = this.main_item.get_base_params() || {};
    var p = Ext.apply({},this.get_base_params());
    delete p.fmt;
    //~ if (p.fmt) delete p.fmt;
    Ext.apply(p,this.get_permalink_params());
    //~ Lino.insert_subst_user(p);
     //~ p.fmt = 'html';
    //~ console.log('get_permalink',p,this.get_permalink_params());
    if (this.is_home_page)
        //~ var url = '';
        var url = '/';
    else 
        var url = this.get_permalink_url();
    if (p.su == null) 
        delete p.su;
    if (Ext.urlEncode(p)) url = url + "?" + Ext.urlEncode(p);
    return url;
  }
  ,get_record_url : function(record_id) {
      var url = '/api' + this.ls_url
      //~ var url = this.containing_window.config.url_data; // ls_url;
      url += '/' + (record_id === undefined ? '-99999' : String(record_id));
      //~ if (record_id !== undefined) url += '/' + String(record_id);
      //~ url += '/' + String(record_id);
      return url;
  }
  ,get_permalink_url : function() {
      return '/api' + this.ls_url;
  }
  ,get_permalink_params : function() {
      //~ return {an:'grid'};
      var p = {};
      if (this.action_name)
          p.an = this.action_name;
      this.add_param_values(p)
      return p;
  }
  ,set_status : function(status) {}
  ,get_status : function() { return {}}
  ,refresh : function() {}
  ,get_base_params : function() { 
    var p = {};
    Lino.insert_subst_user(p);
    return p;
  }
  ,add_params_panel : function (tbar) {
      if (this.params_panel) {
        tbar = tbar.concat([{ scope:this, 
          //~ text: "$_("[parameters]")", // gear
          iconCls: 'x-tbar-parameters',
          tooltip:"Parameter-Panel ein- bzw. ausblenden",
          enableToggle: true,
          //~ pressed: ! this.params_panel.hidden,
          pressed: ! this.params_panel_hidden,
          toggleHandler: function(btn,state) { 
            //~ if (this.params_panel.isVisible()) 
                //~ this.params_panel.hide();
            //~ else
                //~ this.params_panel.show();
            //~ console.log("20120210 add_params_panel",state,this.params_panel);
            if (state) {
              this.params_panel.show();
              this.params_panel.doLayout();
            } else this.params_panel.hide();
            this.get_containing_window().doLayout();
          }
        }]);
        var t = this;
        var refresh = function() {if (!t.setting_param_values) t.refresh();}
        Ext.each(this.params_panel.fields,function(f) {
          //~ f.on('valid',function() {t.refresh()});
          if (f instanceof Ext.form.Checkbox) {
              f.on('check',refresh);
          } else if (f instanceof Ext.DatePicker) {
              f.on('select',refresh);
          } else if (f instanceof Ext.form.TriggerField) {
              f.on('select',refresh);
              //~ f.on('change',refresh);
              //~ f.on('valid',refresh);
          } else {
              if (! f.on) 
                  console.log("20121010 no method 'on'",f);
              else
                  f.on('change',refresh);
            }
          });
      }
      return tbar;
  }
  ,add_param_values : function (p) {
    if (this.params_panel) {
      /* 
      20120918 add param_values to the request string 
      *only if the params_form is dirty*.
      Otherwise Actor.default_params() would never be used.
      
      20121023 But IntegClients.params_default has non-empty default values. 
      Users must have the possibility to make them empty.
      */
      if (this.params_panel.form.isDirty()) {
        p.pv = this.get_param_values();
      }else{
        if (this.status_param_values) 
          p.pv = Lino.fields2array(
            this.params_panel.fields,this.status_param_values);
      }
      //~ if (!this.params_panel.form.isDirty()) return;
      //~ p.pv = this.get_param_values();
      //~ console.log("20120203 add_param_values added pv",pv,"to",p);
    }
  },
  get_param_values : function() { // similar to get_field_values()
      return Lino.fields2array(this.params_panel.fields);
  },
  set_param_values : function(pv) {
    if (this.params_panel) {
      //~ console.log('20120203 MainPanel.set_param_values', pv);
      this.status_param_values = pv;
      //~ this.params_panel.form.suspendEvents(false);
      this.setting_param_values = true;
      if (pv) { 
          this.params_panel.form.my_loadRecord(pv);
      } else { 
        this.params_panel.form.reset(); 
      }
      this.setting_param_values = false;
      //~ this.params_panel.form.resumeEvents();
    }
  }
};


Lino.ajax_error_handler = function(panel) {
  return function(response,options) {
    console.log('Ajax failure:',response,options);
    if (panel.loadMask) panel.loadMask.hide();
    if (response.responseText) {
      var lines = response.responseText.split('\n');
      if (lines.length > 10) {
          line = lines.splice(5,lines.length-10,"(...)");
      }
      Ext.MessageBox.alert(
        response.statusText,
        lines.join('<br/>')
        //~ response.responseText.replace(/\n/g,'<br/>'))
      )
    } else {
      Ext.MessageBox.alert('Action failed',
        'Lino server did not respond to Ajax request');
    }
  }
}
// Ext.Ajax.on('requestexception',Lino.ajax_error_handler)
 


Ext.QuickTips.init();

/* setting QuickTips dismissDelay to 0 */
// Apply a set of config properties to the singleton
//~ Ext.apply(Ext.QuickTips.getQuickTip(), {
//~ Ext.apply(Ext.ToolTip, {
    //~ dismissDelay: 0
    //~ autoHide: false,
    //~ closable: true,
    //~ maxWidth: 200,
    //~ minWidth: 100,
    //~ showDelay: 50      // Show 50ms after entering target
    //~ ,trackMouse: true
//~ });


//~ Ext.apply(Ext.QuickTip, {
    //~ dismissDelay: 0,
//~ });
  
Lino.quicktip_renderer = function(title,body) {
  return function(c) {
    //~ if (c instanceof Ext.Panel) var t = c.bwrap; else // 20130129
    if (c instanceof Ext.Panel) var t = c.header; else // 20130129
    var t = c.getEl();
    //~ console.log(20130129,t,title,body);
    //~ t.dismissDelay = 0;
    Ext.QuickTips.register({
      target: t,
      //~ cls: 'lino-quicktip-classical',
      dismissDelay: 0,
      //~ autoHide: false,
      showDelay: 50,      // Show 50ms after entering target
      //~ title: title,
      text: body
    });
  }
};


  
Lino.help_text_editor = function() {
  //~ var bp = {
      //~ mk:this.content_type,
      //~ mt:1
    //~ };
    //~ console.log(20120202,bp);
  //~ Lino.lino.ContentTypes.detail({},{base_params:bp});
  //~ Lino.lino.ContentTypes.detail.run(null,{record_id:this.content_type});
  Lino.lino.ContentTypes.detail.run(null,{record_id:this.content_type});
}

// Path to the blank image should point to a valid location on your server
//~ Ext.BLANK_IMAGE_URL = MEDIA_URL + '/extjs/resources/images/default/s.gif'; 


// used as Ext.grid.Column.renderer for id columns in order to hide the special id value -99999
Lino.id_renderer = function(value, metaData, record, rowIndex, colIndex, store) {
  //~ if (record.phantom) return '';
  return value;
}

Lino.raw_renderer = function(value, metaData, record, rowIndex, colIndex, store) {
  return value;
}

Lino.text_renderer = function(value, metaData, record, rowIndex, colIndex, store) {
  //~ return "not implemented"; 
  return value;
}

Lino.NullNumberColumn = Ext.extend(Ext.grid.Column, {
    align : 'right', 
    format : '0,00/i', 
    renderer : function(value, metaData, record, rowIndex, colIndex, store) {
        //~ console.log(20130128,"NullNumberColumn.renderer",value);
        if (value === null) return '';
        return Ext.util.Format.number(value, this.format);
    }
});

//~ Lino.NullNumberColumn = Ext.extend(Ext.grid.NumberColumn, {
    //~ align : 'right', 
    //~ constructor: function(cfg){
        //~ Ext.grid.NumberColumn.superclass.constructor.call(this, cfg);
        //~ var t = this;
        //~ this.renderer = function(value, metaData, record, rowIndex, colIndex, store) {
          //~ console.log(20130128,"NullNumberColumn.renderer",value);
          //~ if (value === null) return '';
          //~ return Ext.util.Format.number(value, t.format);
      //~ };
    //~ }
//~ });




//~ Lino.cell_button_renderer = function(value, metaData, record, rowIndex, colIndex, store) {
  //~ return '<input type="button" onclick="alert(value)" value=" ? ">' ;
//~ }


//~ Lino.default_renderer = function(value, metaData, record, rowIndex, colIndex, store) {
  //~ if (record.phantom) return '';
  //~ return value;
//~ }

Lino.fk_renderer = function(fkname,handlername) {
  //~ console.log('Lino.fk_renderer handler=',handler);
  return function(value, metaData, record, rowIndex, colIndex, store) {
    //~ console.log('Lino.fk_renderer',fkname,rowIndex,colIndex,record,metaData,store);
    //~ if (record.phantom) return '';
    if (value) {
        var s = '<a href="javascript:' ;
        s += handlername + '.run(null,{record_id:\'' + String(record.data[fkname]) + '\'})">';
        s += value + '</a>';
        //~ console.log('Lino.fk_renderer',value,'-->',s);
        return s
    }
    return '';
  }
};

Lino.lfk_renderer = function(panel,fkname) {
  //~ console.log('Lino.fk_renderer handler=',handler);
  var handlername = 'console.log';
  return function(value, metaData, record, rowIndex, colIndex, store) {
    //~ console.log('Lino.fk_renderer',fkname,rowIndex,colIndex,record,metaData,store);
    if (record.phantom) return '';
    if (value) {
        var s = '<a href="javascript:' ;
        s += handlername + '({},{record_id:\'' + String(record.data[fkname]) + '\'})">';
        s += value + '</a>';
        //~ console.log('Lino.fk_renderer',value,'-->',s);
        return s
    }
    return '';
  }
};

//~ Lino.gfk_renderer = function() {
  //~ return function(value, metaData, record, rowIndex, colIndex, store) {
    //~ if (record.phantom) return '';
    //~ console.log('Lino.gfk_renderer',value,colIndex,record,metaData,store);
    //~ return value;
  //~ }
//~ };


Lino.build_buttons = function(panel,actions) {
  //~ console.log("20121006 Lino.build_buttons",actions);
  if (actions) {
    var buttons = Array(actions.length);
    var cmenu = Array(actions.length);
    for (var i=0; i < actions.length; i++) { 
      buttons[i] = new Ext.Toolbar.Button(actions[i]);
      cmenu[i] = actions[i]
      cmenu[i].text = actions[i].menu_item_text;
      if (actions[i].panel_btn_handler) {
          var h = actions[i].panel_btn_handler.createCallback(panel,buttons[i]);
          //~ if (actions[i].must_save) {
          if (actions[i].auto_save == true) {
              buttons[i].on('click',panel.do_when_clean.createDelegate(panel,[true,h]));
          } else if (actions[i].auto_save == null) {
              buttons[i].on('click',panel.do_when_clean.createDelegate(panel,[false,h]));
          } else if (actions[i].auto_save == false) {
              buttons[i].on('click',h);
          } else {
              console.log("20120703 unhandled auto_save value",actions[i])
          }
          cmenu[i].handler = actions[i].panel_btn_handler.createCallback(panel,cmenu[i]);
      }
    }
    return {bbar:buttons, cmenu:new Ext.menu.Menu(cmenu)};
  }
}

Lino.do_when_visible = function(cmp,todo) {
  //~ if (cmp.el && cmp.el.dom) 
  if (cmp.isVisible()) { 
    // 'visible' means 'rendered and not hidden'
    //~ console.log(cmp.title,'-> cmp is visible now');
    todo(); 
  //~ } else {
      //~ cmp.on('resize',todo,cmp,{single:true});
  //~ }
  //~ if (false) { // 20120213
  } else { 
    //~ console.log('Lino.do_when_visible() must defer because not isVisible()',todo,cmp);
    if (cmp.rendered) {
      //~ console.log(cmp,'-> cmp is rendered but not visible: and now?');
      //~ console.log(cmp.title,'-> cmp is rendered but not visible: try again in a moment...');
      //~ var fn = function() {Lino.do_when_visible(cmp,todo)};
      //~ fn.defer(100);
      
      Lino.do_when_visible.defer(50,this,[cmp,todo]);
      //~ Lino.do_when_visible.defer(100,this,[cmp,todo]);
      
    } else {
      //~ console.log(cmp.title,'-> after render');
      cmp.on('afterrender',todo,cmp,{single:true});
    }
  }
  
};    

/*
*/
Lino.do_on_current_record = function(panel,fn,phantom_fn) {
  var rec = panel.get_current_record();
  if (rec == undefined) {
    Lino.notify("There's no selected record.");
    return;
  }
  // 20120307 A VirtualTable with a Detail (lino.Models) has only "phantom" records.
  if (rec.phantom) {
    //~ if (!panel.editable) { console.log("20120312 not editable:",panel)}
    if (phantom_fn) {
      phantom_fn(panel);
    } else {
      Lino.notify("Aktion nicht verfügbar auf dem Phantom-Record.");
    }
    return;
  }
  return fn(rec);
};






Lino.call_ajax_action = function(panel,method,url,p,actionName,step,on_confirm,on_success) {
  p.an = actionName;
  if (!panel) panel = Lino.viewport;
  Ext.apply(p,panel.get_base_params());
  //~ console.log("20121212 Lino.call_ajax_action",panel);
  panel.loadMask.show(); 
  //~ p.$ext_requests.URL_PARAM_SUBST_USER = Lino.subst_user;
  //~ Lino.insert_subst_user(p);
    
  //~ if (step) p['$ext_requests.URL_PARAM_ACTION_STEP'] = step;
  //~ if (pp) pp(p); // "parameter processor" : first used for read beid card
  Ext.Ajax.request({
    method: method,
    url: url,
    params: p,
    success: Lino.action_handler(panel,on_success,on_confirm)
  });
};

Lino.row_action_handler = function(actionName,hm,pp) {
  var p = {};
  var fn = function(panel,btn,step) {
      if (pp) { p = pp(); if (! p) return; }
      Lino.do_on_current_record(panel,function(rec) {
          //~ console.log(panel);
          //~ 20120723 Lino.call_ajax_action(panel,rec.id,actionName,step,fn);
          Lino.call_ajax_action(panel,hm,panel.get_record_url(rec.id),p,actionName,step,fn);
      });
  };
  return fn;
};

Lino.list_action_handler = function(ls_url,actionName,hm,pp) {
  var p = {};
  var url = '/api' + ls_url
  var fn = function(panel,btn,step) {
      //~ console.log("20121210 Lino.list_action_handler",arguments);
      //~ var url = ADMIN_URL + '/api' + panel.ls_url
      if (pp) { p = pp();  if (! p) return; }
      Lino.call_ajax_action(panel,hm,url,p,actionName,step,fn);
  };
  return fn;
};

Lino.param_action_handler = function(window_action) { // 20121012
  var fn = function(panel,btn,step) {
    Lino.do_on_current_record(panel,function(rec) {
      //~ console.log(panel);
      //~ 20120723 Lino.call_ajax_action(panel,rec.id,actionName,step,fn);
      window_action.run(panel.getId(),{}); 
    });
  };
  return fn;
};


Lino.run_row_action = function(requesting_panel,url,pk,actionName,pp) {
  //~ var panel = action.get_window().main_item;
  url = '/api' + url  + '/' + pk;
  var panel = Ext.getCmp(requesting_panel);
  if (pp) var p = pp(); else var p = {};
  var fn = function(panel,btn,step) {
    //~ 20120723 Lino.call_ajax_action(panel,pk,actionName,step,fn);
    Lino.call_ajax_action(panel,'GET',url,p,actionName,step,fn);
  }
  fn(panel,null,null);
}



Lino.show_detail = function(panel,btn) {
  Lino.do_on_current_record(panel, 
    function(rec) {
      //~ panel.loadMask.show();
      var bp = panel.get_base_params();
      //~ var bp = {};
      panel.add_param_values(bp); // 20120918
      var status = {
        record_id:rec.id,
        base_params:bp
        //~ param_values: pv.$ext_requests.URL_PARAM_PARAM_VALUES
      }
      //~ console.log("20120918 Lino.show_detail",status);
      panel.ls_detail_handler.run(null,status);
      //~ panel.loadMask.hide();
      //~ panel.containing_window.window.hideMask();
      //~ panel.el.unmask();
    },
    Lino.show_insert
  );
};

Lino.show_fk_detail = function(combo,detail_action) {
    //~ console.log("Lino.show_fk_detail",combo,handler);
    pk = combo.getValue();
    if (pk) {
        detail_action.run(null,{record_id: pk})
      } else {
        Lino.notify("Cannot show detail for empty foreign key.");
      }
};

Lino.show_insert = function(panel,btn) {
  var bp = panel.get_base_params();
  //~ console.log('20120125 Lino.show_insert',bp)
  //~ panel.ls_insert_handler.run(null,{record_id:-99999,base_params:bp});
  panel.ls_insert_handler.run(panel.getId(),{record_id:-99999,base_params:bp});
};

Lino.show_insert_duplicate = function(panel,btn) {
  Lino.do_on_current_record(panel,
    function(rec) {
      var newRec = {};
      Ext.apply(newRec,rec);
      newRec.id = -99999;
      panel.ls_insert_handler.run(null,{data_record:rec});
    });
};

//~ Lino.update_row_handler = function(action_name) {
  //~ return function(panel,btn) {
    //~ Lino.notify("Sorry, " + action_name + " is not implemented.");
  //~ }
//~ };




if (Ext.ux.grid !== undefined) {
    Lino.GridFilters = Ext.extend(Ext.ux.grid.GridFilters,{
      encode:true,
      local:false
    });
} else {
    Lino.GridFilters = function() {}; // dummy
    Ext.override(Lino.GridFilters,{
      init : function() {}
    });
};



//~ Lino.ButtonField = Ext.extend(Ext.form.TextField,{
//~ Lino.ButtonField = Ext.extend(Ext.form.Field,{
    //~ editable : false,
    //~ constructor : function(ww,config,params){
      //~ this.containing_window = ww;
      //~ if (params) Ext.apply(config,params);
      //~ Lino.ButtonField.superclass.constructor.call(this, config);
    //~ },
    //~ setButtons : function(buttons){
      //~ console.log('setButtons',buttons);
    //~ },
    //~ onRender : function(ct, position){
        //~ if(!this.el){
            //~ this.panel = new Ext.Container({items:[
              //~ {xtype:'button',text:'upload'},
              //~ {xtype:'button',text:'show'},
              //~ {xtype:'button',text:'edit'}
            //~ ]});
            //~ this.panel.ownerCt = this;
            //~ this.el = this.panel.getEl();

        //~ }
        //~ Lino.ButtonField.superclass.onRender.call(this, ct, position);
    //~ },

  
//~ });

Lino.FieldBoxMixin = {
  before_init : function(config,params) {
    if (params) Ext.apply(config,params);
    var actions = Lino.build_buttons(this,config.ls_bbar_actions);
    if (actions) config.bbar = actions.bbar;
  },
  //~ constructor : function(ww,config,params){
    //~ this.containing_window = ww;
    //~ if (params) Ext.apply(config,params);
    //~ var actions = Lino.build_buttons(this,config.ls_bbar_actions);
    //~ if (actions) config.bbar = actions.bbar;
    //~ Lino.FieldBoxMixin.superclass.constructor.call(this, config);
  //~ },
  do_when_clean : function(auto_save,todo) { todo() },
  //~ format_data : function(html) { return '<div class="htmlText">' + html + '</div>' },
  format_data : function(html) { return html },
  get_base_params : function() {
    // needed for insert action
    var p = Ext.apply({},this.base_params);
    Lino.insert_subst_user(p);
    return p;
  },
  set_base_params : function(p) {
    this.base_params = Ext.apply({},p);
    //~ if (p.param_values) this.set_param_values(p.param_values);  
  },
  clear_base_params : function() {
      this.base_params = {};
      Lino.insert_subst_user(this.base_params);
  },
  set_base_param : function(k,v) {
    this.base_params[k] = v;
  }
};



Lino.HtmlBoxPanel = Ext.extend(Ext.Panel,Lino.PanelMixin);
Lino.HtmlBoxPanel = Ext.extend(Lino.HtmlBoxPanel,Lino.FieldBoxMixin);
Lino.HtmlBoxPanel = Ext.extend(Lino.HtmlBoxPanel,{
  disabled_in_insert_window : true,
  constructor : function(config,params) {
    this.before_init(config,params);
    Lino.HtmlBoxPanel.superclass.constructor.call(this, config);
  },
  //~ constructor : function(ww,config,params){
    //~ this.ww = ww;
    //~ if (params) Ext.apply(config,params);
    //~ var actions = Lino.build_buttons(this,config.ls_bbar_actions);
    //~ if (actions) config.bbar = actions.bbar;
    //~ Lino.FieldBoxMixin.constructor.call(this, ww,config,params);
  //~ },
  //~ constructor : function(ww,config,params){
    //~ this.ww = ww;
    //~ if (params) Ext.apply(config,params);
    //~ var actions = Lino.build_buttons(this,config.ls_bbar_actions);
    //~ if (actions) config.bbar = actions.bbar;
    //~ Lino.FieldBoxMixin.superclass.constructor.call(this, config);
  //~ },
  //~ disable : function() { var tb = this.getBottomToolbar(); if(tb) tb.disable()},
  //~ enable : function() { var tb = this.getBottomToolbar(); if(tb) tb.enable()},
  onRender : function(ct, position){
    Lino.HtmlBoxPanel.superclass.onRender.call(this, ct, position);
    //~ console.log(20111125,this.containing_window);
    if (this.containing_panel) {
      this.containing_panel.on('enable',this.enable,this);
      this.containing_panel.on('disable',this.disable,this);
    }
    this.el.on({
      dragenter:function(event){
        event.browserEvent.dataTransfer.dropEffect = 'move';
        return true;
      }
      ,dragover:function(event){
        event.browserEvent.dataTransfer.dropEffect = 'move';
        event.stopEvent();
        return true;
      }
      ,drop:{
        scope:this
        ,fn:function(event){
          event.stopEvent();
          //~ console.log(20110516);
          var files = event.browserEvent.dataTransfer.files;
          if(files === undefined){
            return true;
          }
          var len = files.length;
          while(--len >= 0){
            console.log(files[len]);
            //~ this.processDragAndDropFileUpload(files[len]);
          }
          Lino.show_insert(this);
        }
      }
    });
  },
  refresh : function(unused) { 
      this.refresh_with_after();
  },
  refresh_with_after : function(after) {
    //~ if (this.master_panel) {
      var record = this.containing_panel.get_current_record();
      //~ console.log('HtmlBox.refresh()',this.title,record,record.title);
      var box = this.items.get(0);
      var todo = function() {
        if (this.disabled) return;
        //~ this.set_base_params(this.containing_window.get_base_params());
        this.set_base_params(this.containing_panel.get_master_params());
        var el = box.getEl();
        if (el) {
          el.update(record ? this.format_data(record.data[this.name]) : '');
          //~ console.log('HtmlBox.refresh()',this.name);
        //~ } else {
          //~ console.log('HtmlBox.refresh() failed for',this.name);
        }
      };
      Lino.do_when_visible(box,todo.createDelegate(this));
    //~ }
  }
});
//~ Ext.override(Lino.HtmlBoxPanel,Lino.FieldBoxMixin);



Lino.RichTextPanel = Ext.extend(Ext.Panel,Lino.PanelMixin);
Lino.RichTextPanel = Ext.extend(Lino.RichTextPanel,Lino.FieldBoxMixin);
Lino.RichTextPanel = Ext.extend(Lino.RichTextPanel,{
    
  //~ initComponent : function(){
    //~ Lino.RichTextPanel.superclass.initComponent.call(this);
  //~ },
  constructor : function(config,params) {
    //~ console.log('Lino.RichTextPanel.initComponent',this);
    //~ var url = TEMPLATES_URL + config.ls_url + "/" + String(rec.id) + "/" + config.name;
    //~ var url = TEMPLATES_URL + config.ls_url + "/" + config.name;
    var t = this;
    var tinymce_options = {
        theme : "advanced",
        content_css: '/media/lino/extjs/lino.css',
        language: 'de',
        //~ template_external_list_url : url,
        theme_advanced_toolbar_location : "top",
        theme_advanced_toolbar_align : "left",
        theme_advanced_statusbar_location : "bottom",
        template_popup_width : 700,
        template_popup_height : 500,
        template_replace_values : { 
            data_field : function(element){ 
                //~ console.log(20110722,fieldName,t.containing_window.get_current_record()); 
                var fieldName = element.innerHTML;
                element.innerHTML = t.containing_panel.get_current_record().data[fieldName];
            } 
        }
      };
      
    var editorConfig = {
      tinymceSettings: {
        plugins : "noneditable,template", 
        // Theme options - button# indicated the row# only
        theme_advanced_buttons1 : "bold,italic,underline,|,justifyleft,justifycenter,justifyright,|,bullist,numlist,|,outdent,indent,|,undo,redo,|,removeformat,template",
        theme_advanced_buttons2 : "",
        theme_advanced_buttons3 : "", // ,|,sub,sup,|,charmap",      
        theme_advanced_resizing : false
        //~ save_onsavecallback : save_callback,
        //~ save_enablewhendirty : true
        //~ save_oncancelcallback: on_cancel
        
    }};
    Ext.apply(editorConfig.tinymceSettings,tinymce_options);
    //~ editorConfig.name = config.action_name;
    editorConfig.name = config.name;
    delete config.name;
    //~ config.title = config.label;
    //~ delete config.label;
    this.before_init(config,params);
    
    this.editor = new Ext.ux.TinyMCE(editorConfig);
    var t = this;
    config.tools = [{
                      qtip: "Edit text in own window", 
                      id: "up",
                      handler: function(){
                        if(t.editor.isDirty()) {
                            var record = t.containing_panel.get_current_record();
                            record.data[t.editor.name] = t.editor.getValue();
                        }
                        Lino.edit_tinymce_text(t,tinymce_options)
                      }
                    }];
    
    config.items = this.editor;
    config.layout = "fit";
    Lino.RichTextPanel.superclass.constructor.call(this, config);
  },
  refresh : function(unused) { 
      this.refresh_with_after();
  },
  refresh_with_after : function(after) {
    var record = this.containing_panel.get_current_record();
    //~ console.log('RichTextPanel.refresh()',this.title,record.title,record);
    var todo = function() {
      //~ this.set_base_params(this.containing_window.get_base_params());
      if (record) {
        var url = '/templates' + this.containing_panel.ls_url + "/" 
            + String(record.id) + "/" + this.editor.name;
        //~ console.log('RichTextPanel.refresh()',url);
        if (this.editor.ed) this.editor.ed.settings.template_external_list_url = url;
        this.set_base_params(this.containing_panel.get_master_params());
        //~ var v = record ? this.format_data(record.data[this.editor.name]) : ''
        var v = this.format_data(record.data[this.editor.name])
        this.editor.setValue(v);
      } else {
        this.editor.setValue('(no data)');
      }
    };
    Lino.do_when_visible(this,todo.createDelegate(this));
  }
});
//~ Ext.override(Lino.RichTextPanel,Lino.FieldBoxMixin);



Lino.ActionFormPanel = Ext.extend(Ext.form.FormPanel,Lino.MainPanel);
Lino.ActionFormPanel = Ext.extend(Lino.ActionFormPanel,Lino.PanelMixin);
Lino.ActionFormPanel = Ext.extend(Lino.ActionFormPanel,Lino.FieldBoxMixin);
Lino.ActionFormPanel = Ext.extend(Lino.ActionFormPanel,{
  //~ layout:'fit'
  //~ ,autoHeight: true
  //~ ,frame: true
  window_title: "Action Parameters",
  constructor : function(config){
    config.bbar = [
        {text:'OK',handler:this.on_ok,scope:this},
        {text:'Cancel',handler:this.on_cancel,scope:this}
    ];
    //~ config.items = config.params_panel;
    Lino.ActionFormPanel.superclass.constructor.call(this, config);
  }
  //~ ,initComponent : function(){
    //~ Lino.ActionFormPanel.superclass.initComponent.call(this);
  //~ }
  ,on_cancel : function() { 
    this.get_containing_window().close();
  }
  ,on_ok : function() { 
    //~ var rp = this.requesting_panel;
    //~ console.log("on_ok",this.requesting_panel,arguments);
    //~ Lino.row_action_handler()
    var panel = this.requesting_panel;
    var actionName = this.action_name;
    var rec = panel.get_current_record();
    var self = this;
    function on_success() { self.get_containing_window().close(); };
    var fn = function(panel,btn,step) {
      var p = {};
      self.add_field_values(p)
      Lino.call_ajax_action(panel,'GET',panel.get_record_url(rec.id),p,actionName,step,fn,on_success);
    }
    fn(panel,null,null);
    
    
  }
  ,set_status : function(status,rp){
    this.requesting_panel = Ext.getCmp(rp);
    //~ console.log('20120918 ActionFormPanel.set_status()',status,rp,this.requesting_panel);
    this.clear_base_params();
    if (status == undefined) status = {};
    //~ if (status.param_values) 
    this.set_field_values(status.field_values);
    if (status.base_params) this.set_base_params(status.base_params);
  }
  
  ,add_field_values : function (p) { // similar to add_param_values()
      //~ 20121023 
      if (this.form.isDirty()) {
        p.fv = this.get_field_values();
      }else{
        if (this.status_field_values) 
          p.fv = Lino.fields2array(this.fields,this.status_field_values);
      }
      //~ if (!this.form.isDirty()) return;
      //~ p.$ext_requests.URL_PARAM_FIELD_VALUES = this.get_field_values();
      //~ console.log("20120203 add_param_values added pv",pv,"to",p);
  }
  ,get_field_values : function() {
      return Lino.fields2array(this.fields);
  }
  ,set_field_values : function(pv) {
      //~ console.log('20120203 MainPanel.set_param_values', pv);
      this.status_field_values = pv;
      if (pv) this.form.my_loadRecord(pv);
      else this.form.reset(); 
  }
  ,config_containing_window : function(wincfg) { 
      wincfg.title = this.window_title;
      wincfg.keys = [
        { key: Ext.EventObject.ENTER, fn: this.on_ok }
      ]
  }
});

Lino.fields2array = function(fields,values) {
    //~ console.log('20120116 gonna loop on', fields);
    var pv = Array(fields.length);
    for(var i=0; i < fields.length;i++) {
        var f = fields[i]
        if (values) 
          var v = values[f.name];
        else 
          var v = f.getValue();
        if (f.formatDate) {
            pv[i] = f.formatDate(v); 
        } else {
            pv[i] = v; // f.getValue(); 
        }
    }
    return pv;
}


Lino.FormPanel = Ext.extend(Ext.form.FormPanel,Lino.MainPanel);
Lino.FormPanel = Ext.extend(Lino.FormPanel,Lino.PanelMixin);
Lino.FormPanel = Ext.extend(Lino.FormPanel,{
  params_panel_hidden : false,
  //~ base_params : {},
  //~ trackResetOnLoad : true,
  //~ query_params : {},
  //~ 20110119b quick_search_text : '',
  constructor : function(config,params){
    if (params) Ext.apply(config,params);
    this.base_params = {};
    //~ ww.config.base_params.query = ''; // 20111018
    //~ console.log(config);
    //~ console.log('FormPanel.constructor() 1',config)
    //~ Ext.applyIf(config,{base_params:{}});
    //~ console.log('FormPanel.constructor() 2',config)
      
    config.trackResetOnLoad = true;
    
    Lino.FormPanel.superclass.constructor.call(this, config);
      
    //~ this.set_base_param('$URL_PARAM_FILTER',null); // 20111018
    //~ this.set_base_param('$URL_PARAM_FILTER',''); // 20111018
      
  },
  initComponent : function(){
    
    //~ console.log("20111201 containing_window",this.containing_window,this);
    
    var actions = Lino.build_buttons(this,this.ls_bbar_actions);
    if (actions) {
        this.bbar = actions.bbar;
    //~ } else {
        //~ this.bbar = [];
    }
    //~ Ext.apply(config,Lino.build_buttons(this,config.ls_bbar_actions));
    //~ config.bbar = Lino.build_buttons(this,config.ls_bbar_actions);
    //~ var config = this;
    
    //~ if (this.containing_window instanceof Lino.DetailWrapper) {
    
    //~ console.log('20120121 initComponent', this.action_name);
    //~ if (this.action_name == 'detail' | this.action_name == 'show') {
    //~ if (this.action_name != 'insert') {
    if (! this.hide_top_toolbar) {
      this.tbar = [];
      // 20111015    
      if (! this.hide_navigator) {
        this.record_selector = new Lino.RemoteComboFieldElement({
          store: new Lino.ComplexRemoteComboStore({
            //~ baseParams: this.containing_window.config.base_params,
            baseParams: this.get_base_params(),
            //~ value: this.containing_window.config.base_params.query,
            proxy: new Ext.data.HttpProxy({
              url: '/choices' + this.ls_url,
              method:'GET'
            })
          }),
          pageSize:25,
          listeners: { 
            scope:this, 
            select:function(combo,record,index) {
              //~ console.log('jumpto_select',arguments);
              this.goto_record_id(record.id);
            }
          },
          emptyText: "Gehe zu Datensatz"
        })
        this.tbar = this.tbar.concat([this.record_selector]);
        
        this.tbar = this.tbar.concat([
          this.first = new Ext.Toolbar.Button({
            tooltip:"Erster",disabled:true,handler:this.moveFirst,scope:this,iconCls:'x-tbar-page-first'}),
          this.prev = new Ext.Toolbar.Button({
            tooltip:"Voriger",disabled:true,handler:this.movePrev,scope:this,iconCls:'x-tbar-page-prev'}),
          this.next = new Ext.Toolbar.Button({
            tooltip:"Nächster",disabled:true,handler:this.moveNext,scope:this,iconCls:'x-tbar-page-next'}),
          this.last = new Ext.Toolbar.Button({
            tooltip:"Letzter",disabled:true,handler:this.moveLast,scope:this,iconCls:'x-tbar-page-last'})
        ]);
      }
      this.tbar = this.add_params_panel(this.tbar);
      
      //~ console.log(20101117,this.containing_window.refresh);
      this.tbar = this.tbar.concat([
        {
          //~ text:'Refresh',
          handler:function(){ this.do_when_clean(true,this.refresh.createDelegate(this)) },
          iconCls: 'x-tbar-loading',
          tooltip:"Datensatz neu laden",
          scope:this}
      ]);
          
      if (this.bbar) { // since 20121016
        if (this.tbar) {
            this.tbar = this.tbar.concat(['-']) ;
        } else {
          this.tbar = [];
        }
        this.tbar = this.tbar.concat(this.bbar) ;
        this.bbar = undefined;
      }
    
      this.tbar = this.tbar.concat([
          '->',
          this.displayItem = new Ext.Toolbar.TextItem({})
      ]);
          
    }
    //~ if (this.content_type && this.action_name != 'insert') {
      //~ this.bbar = this.bbar.concat([
        //~ '->',
        //~ { text: "[$_('Help Text Editor')]",
          //~ handler: Lino.help_text_editor,
          //~ qtip: "$_('Edit help texts for fields on this model.')",
          //~ scope: this}
      //~ ])
    //~ }
    //~ this.before_row_edit = config.before_row_edit.createDelegate(this);
      
    //~ if (this.master_panel) {
        //~ this.set_base_params(this.master_panel.get_master_params());
    //~ }
      
    Lino.FormPanel.superclass.initComponent.call(this);
    
    this.on('render',function(){
      this.loadMask = new Ext.LoadMask(this.bwrap,{msg:"Bitte warten..."});
    },this);
    
    
    //~ var this_ = this;
    //~ this.cascade(function(cmp){
      //~ // var active_field = false;
      //~ for (i = 0; i < this_.active_fields.length; i++) {
        //~ if (cmp.name == this_.active_fields[i]) {
            //~ // active_field = true; break;
            //~ cmp.on("change",function() {this_.save()});
        //~ }
      //~ };
      //~ if (active_field) {
      // if (cmp instanceof Lino.GridPanel) {
          //~ cmp.on("change",function() {this_.save()});
      //~ }
    //~ });
    
    if (this.action_name == 'insert') {
      this.cascade(function(cmp){
        // console.log('20110613 cascade',cmp);
        if (cmp.disabled_in_insert_window) {
            //~ cmp.disable();
            cmp.hide();
        }
      });
      
    }
    
  },
  
  is_loading : function() { 
    if (this.current_record == null) return true; 
    var loading = false;
    this.cascade(function(cmp){
        if (cmp instanceof Lino.GridPanel && cmp.is_loading()) {
            //~ console.log(cmp.title,'is loading');
            loading = true;
            return false;
        }
      });
    return loading;
    //~ var a = this.findByType(Lino.GridPanel);
    //~ for (i=0;i<a.length;i++) {
        //~ if (a[i].is_loading()) return true;
    //~ }
    //~ return false;
  },
  
  get_status : function(){
      var st = {
        base_params: this.get_base_params(),
        data_record : this.get_current_record()
        }
      var tp = this.items.get(0);
      if (tp instanceof Ext.TabPanel) {
        st.active_tab = tp.getActiveTab();
      }
      st.param_values = this.status_param_values;
      return st;
  },
  set_status : function(status,rp){
    this.requesting_panel = Ext.getCmp(rp);
    //~ console.log('20120918 FormPanel.set_status()',status);
    this.clear_base_params();
    if (status == undefined) status = {};
    //~ if (status.param_values) 
    this.set_param_values(status.param_values);
    if (status.base_params) this.set_base_params(status.base_params);
    var tp = this.items.get(0);
    if (tp instanceof Ext.TabPanel) {
      if (status.active_tab) {
        //~ console.log('20111201 active_tab',this.active_tab,this.items.get(0));
        //~ tp.activeTab = status.active_tab;
        tp.setActiveTab(status.active_tab);
        //~ this.main_item.items.get(0).activate(status.active_tab);
      } else {
        tp.setActiveTab(0);
      }
      }
    
    if (status.data_record) {
      //~ console.log('20111201 Lino.FormPanel with data_record',this.data_record.title,this.containing_window);
      //~ this.main_item.on_master_changed.defer(2000,this.main_item,[status.data_record]);
      //~ Lino.do_when_visible(this.main_item,function(){this.on_master_changed(status.data_record)});
      //~ this.main_item.on('afterrender',function(){
      //~   this.main_item.on_master_changed(status.data_record)},this,{single:true});
      /* must defer because because set_window_title() didn't work otherwise */
      this.set_current_record.createDelegate(this,[status.data_record]).defer(100);
      //~ this.set_current_record(this.data_record);
      //~ return;
    } else if (status.record_id != undefined) { 
      /* possible values include 0 and null, 0 being a valid record id, 
      null the equivalent of undefined
      */
      //~ this.main_item.goto_record_id(this.status.record_id);
      this.load_record_id(status.record_id);
    } else {
      this.set_current_record(undefined);
    }
  },
    
  get_base_params : function() {
    // needed for insert_action
    var p = Ext.apply({},this.base_params);
    Lino.insert_subst_user(p);
    return p;
    //~ return this.base_params;
  },
  set_base_params : function(p) {
    //~ this.base_params = Ext.apply({},this.base_params); // make sure it is an instance variable
    delete p['query'] // 20120725
    Ext.apply(this.base_params,p);
    if (this.record_selector) {
        var store = this.record_selector.getStore();
        for (k in p) store.setBaseParam(k,p[k]);
        delete this.record_selector.lastQuery;
        //~ console.log("20120725 record_selector.setBaseParam",p)
    }
  },
  clear_base_params : function() {
      this.base_params = {};
      Lino.insert_subst_user(this.base_params);
        
      //~ if (this.record_selector) {
          //~ var store = this.record_selector.getStore();
          //~ for (k in store.baseParams) store.setBaseParam(k,undefined);
          //~ delete this.record_selector.lastQuery;
          //~ console.log("20120725 record_selector.getBaseParams() -->",store.baseParams)
      //~ }
  },
  set_base_param : function(k,v) {
    //~ this.base_params = Ext.apply({},this.base_params); // make sure it is an instance variable
    this.base_params[k] = v;
    //~ if (this.record_selector) {
        //~ this.record_selector.getStore().setBaseParam(k,v);
        //~ delete this.record_selector.lastQuery;
    //~ }
  },
  
  after_delete : function() {
    if (this.current_record.navinfo.next)
      this.moveNext();
    else if (this.current_record.navinfo.prev)
      this.movePrev();
    else 
      this.abandon();
  },
  moveFirst : function() {this.goto_record_id(this.current_record.navinfo.first)},
  movePrev : function() {this.goto_record_id(this.current_record.navinfo.prev)},
  moveNext : function() {this.goto_record_id(this.current_record.navinfo.next)},
  moveLast : function() {this.goto_record_id(this.current_record.navinfo.last)},
  
  
  refresh : function(unused) { 
      this.refresh_with_after();
  },
  refresh_with_after : function(after) { 
    //~ console.log('20120121 Lino.FormPanel.refresh()',this);
    if (this.current_record) {
        this.load_record_id(this.current_record.id,after);
    } else {
        this.set_current_record(undefined,after);
    }
  },
  
  do_when_clean : function(auto_save,todo) {
    var this_ = this;
    if (this.form.isDirty()) {
        if (auto_save) {
            this_.save(todo);
        } else {
          //~ console.log('20111217 do_when_clean() form is dirty',this.form);
          var config = {title:"Bestätigung"};
          config.buttons = Ext.MessageBox.YESNOCANCEL;
          config.msg = "Änderungen in diesem Datensatz speichern?";
          config.fn = function(buttonId,text,opt) {
            //~ console.log('do_when_clean',buttonId)
            if (buttonId == "yes") {
                //~ Lino.submit_detail(this_,undefined,todo);
                //~ this_.containing_window.save(todo);
                this_.save(todo);
            } else if (buttonId == "no") { 
              todo();
            }
          }
        }
        Ext.MessageBox.show(config);
    }else{
      //~ console.log('do_when_clean : now!')
      todo();
    }
  },
  
  goto_record_id : function(record_id) {
    //~ console.log('20110701 Lino.FormPanel.goto_record_id()',record_id);
    //~ var this_ = this;
    //~ this.do_when_clean(function() { this_.load_record_id(record_id) }
    this.do_when_clean(true,this.load_record_id.createDelegate(this,[record_id]));
  },
  
  load_record_id : function(record_id,after) {
    var this_ = this;
    //~ var p = { fmt: this.containing_window.config.action_name};
    //~ var p = Ext.apply({},this.containing_window.config.base_params);
    var p = Ext.apply({},this.get_base_params());
    //~ Lino.insert_subst_user(p);
    //~ console.log('20110713 action_name=',this.containing_window.config.action_name,
      //~ 'base_params=',this.containing_window.config.base_params);
    if (this.action_name)
        p.an = this.action_name;
    //~ p.an = this.action_name;
    //~ p.an = this.containing_window.config.action_name;
    //~ p.fmt = 'json';
    //~ p.fmt = '$ext_requests.URL_FORMAT_JSON';
    p.rp = this.getId();
    //~ p.$ext_requests.URL_PARAM_SUBST_USER = Lino.subst_user;
    p.fmt = 'json';
    //~ 20110119b p['$URL_PARAM_FILTER'] = this.quick_search_text;
    //~ Ext.apply(p,this.query_params);
    this.add_param_values(p);
    //~ console.log('20121120 FormPanel.load_record_id',record_id,p);
    if (this.loadMask) this.loadMask.show();
    Ext.Ajax.request({ 
      waitMsg: 'Loading record...',
      method: 'GET',
      params: p,
      scope: this,
      url: this.get_record_url(record_id),
      success: function(response) {   
        // todo: convert to Lino.action_handler.... but result 
        if (this.loadMask) this.loadMask.hide();
        if (response.responseText) {
          var rec = Ext.decode(response.responseText);
          //~ console.log('20120918 goto_record_id success',rec);
          this.set_param_values(rec.param_values);
          this.set_current_record(rec,after);
        }
      },
      failure: Lino.ajax_error_handler(this)
    });
  },

  abandon : function () {
    Ext.MessageBox.alert('Note',
      "Keine weiteren Datensätze zu sehen. Detail-Fenster wird geschlossen.");
    Lino.close_window();
    //~ if (this.containing_window) {
        //~ this.containing_window.hide();
    //~ }
  },
  
  set_current_record : function(record,after) {
    //~ console.log('20120722 Lino.FormPanel.set_current_record',record.title,record);
    if (this.record_selector) {
        this.record_selector.clearValue();
        // e.g. InsertWrapper FormPanel doesn't have a record_selector
    }
    this.current_record = record;
    //~ if (record) 
        //~ console.log('Lino.FormPanel.set_current_record',record.title,record);
    //~ else
        //~ console.log('Lino.FormPanel.set_current_record',record);
    //~ this.config.main_panel.form.load(record);    
    if (record) {
      this.enable();
      this.form.my_loadRecord(record.data);
      this.set_window_title(record.title);
      //~ this.getBottomToolbar().enable();
      var da = record.data.disabled_actions;
      if (da) {
          //~ console.log('20120528 disabled_actions =',da,this.getBottomToolbar());
          //~ 20121016 this.getBottomToolbar().items.each(function(item,index,length){
          var tb = this.getTopToolbar();
          if (tb) tb.items.each(function(item,index,length){
              //~ console.log('20120528 ',item.itemId,'-->',da[item.itemId]);
              if (da[item.itemId]) item.disable(); else item.enable();
          });
      };
      if (this.disable_editing | record.data.disable_editing) {
          //~ console.log("20120202 disable_editing",record.title);
          this.form.items.each(function(cmp){
            if (!cmp.always_enabled) cmp.disable();
          },this);
      } else {
          this.form.items.each(function(cmp){
            //~ console.log("20120202",cmp);
            if (record.data.disabled_fields[cmp.name]) cmp.disable();
            else cmp.enable();
          },this);
        
          //~ if (record.data.disabled_fields) {
              //~ for (i = 0; i < record.data.disabled_fields.length; i++) {
                  //~ var flds = this.find('name',record.data.disabled_fields[i]);
                  //~ if (flds.length == 1) { 
                    //~ flds[0].disable(); 
                  //~ }
              //~ }
          //~ }
      };
      
      if (record.navinfo && ! this.hide_top_toolbar && ! this.hide_navigator) {
        //~ if (record.navinfo.recno == 0) {
            //~ this.first.setDisabled(true);
            //~ this.prev.setDisabled(true);
            //~ this.next.setDisabled(true);
            //~ this.last.setDisabled(true);
        //~ } else {
            this.first.setDisabled(!record.navinfo.first);
            this.prev.setDisabled(!record.navinfo.prev);
            this.next.setDisabled(!record.navinfo.next);
            this.last.setDisabled(!record.navinfo.last);
        //~ }
        this.displayItem.setText(record.navinfo.message);
      }
    } else {
      if (this.form.rendered) 
        this.form.reset(); /* FileUploadField would fail when resetting a non-rendered form */
      //~ this.disable();
      //~ this.getBottomToolbar().disable();
      this.form.items.each(function(cmp){
        cmp.disable();
      },this);
      this.set_window_title(this.empty_title);
      //~ this.containing_window.window.setTitle(this.empty_title);
      if (!this.hide_navigator) {
        this.first.disable();
        this.prev.disable();
        this.next.disable();
        this.last.disable();
      }
    }
    //~ console.log('20100531 Lino.DetailMixin.on_load_master_record',this.main_form);
    this.before_row_edit(record);
    if (after) after();
  },
  
  before_row_edit : function(record) {},
  search_change : function(field,oldValue,newValue) {
    //~ console.log('search_change',field.getValue(),oldValue,newValue)
    this.set_base_param('query',field.getValue()); 
    this.refresh();
  },
  
  get_selected : function() { return [ this.current_record ] },
  get_current_record : function() {  
    //~ console.log(20100714,this.current_record);
    return this.current_record 
  },
  
  get_permalink_url : function() {
      var rec = this.get_current_record();
      if (rec && ! rec.phantom && rec.id != -99998)
          return '/api' + this.ls_url + '/' + rec.id;
      return '/api' + this.ls_url;
    
  },
  get_permalink_params : function() {
    var p = {};
    //~ var p = {an:'detail'};
    if (this.action_name)
        p.an = this.action_name;
    //~ var p = {an:this.action_name};
    var main = this.items.get(0);
    if (main.activeTab) {
      var tab = main.items.indexOf(main.activeTab);
      //~ console.log('main.activeTab',tab,main.activeTab);
      if (tab) p.tab = tab;
    }
    this.add_param_values(p)
    return p;
  },
  
  /* 
  Lino.FormPanel.save() 
  */
  save : function(after,switch_to_detail,action_name) {
    //~ var panel = this;
    //~ console.log('20121120 FormPanel.save');
    this.loadMask.show();
    var rec = this.get_current_record();
    if (this.has_file_upload) this.form.fileUpload = true;
    //~ console.log('FormPanel.save()',rec);
    if (!action_name) action_name = this.action_name;
    if (rec) {
      var p = {};
      Ext.apply(p,this.get_base_params());
      p.rp = this.getId();
      //~ if (this.action_name) 
          //~ p.$ext_requests.URL_PARAM_ACTION_NAME = this.action_name;
      p.an = action_name;
      if (rec.phantom) {
        //~ if (this.action_name != 'insert') 
            //~ console.log("Warning: phantom record, but action_name is",this.action_name)
        this.form.submit({
          url: '/api' + this.ls_url,
          method: 'POST',
          params: p, 
          scope: this,
          success: function(form, action) {
            this.loadMask.hide();
            Lino.notify(action.result.message);
            /***
            Close this window, but update the status of the 
            calling window.
            If the calling window is a detail on the same table,
            then it should skip to the new record. But only then.
            A successful response usually has a data_record,
            except if it is a fileupload form where some mysterious 
            decoding problems (20120209) force us to return a record_id 
            which will lead to an additional GET.
            ***/
            var url = this.ls_url;
            var ww = Lino.calling_window();
            if (ww && ww.window.main_item instanceof Lino.FormPanel 
                   && ww.window.main_item.ls_url == this.ls_url) {
                //~ console.log("20120217 case 1");
                ww.status.record_id = action.result.record_id;
                ww.status.data_record = action.result.data_record;
                Lino.close_window();
            } else if (this.ls_detail_handler && switch_to_detail) {
                //~ console.log("20120217 case 2");
                Lino.kill_current_window();
                this.ls_detail_handler.run(null,{
                    record_id:action.result.record_id,
                    data_record: action.result.data_record,
                    base_params:this.get_base_params()
                });
            } else {
                //~ console.log("20120217 case 3");
                Lino.close_window();
            }
            //~ Lino.close_window(function(ww){
                //~ if (ww.window.main_item instanceof Lino.FormPanel 
                    //~ && ww.window.main_item.ls_url == url) {
                  //~ ww.status.record_id = action.result.record_id,
                  //~ ww.status.data_record = action.result.data_record
                //~ }
            //~ });
          },
          failure: function(form,action) { 
            this.loadMask.hide();
            Lino.on_submit_failure(form,action);
          },
          clientValidation: true
        })
      } else {
        //~ if (this.action_name != 'detail') 
            //~ console.log("Warning: non-phantom record, but action_name is",this.action_name)
        this.form.submit({
          url: '/api' + this.ls_url + '/' + rec.id,
          method: 'PUT',
          //~ headers: { 'HTTP_X_REQUESTED_WITH' : 'XMLHttpRequest'},
          scope: this,
          params: p, 
          success: function(form, action) {
            //~ panel.form.setValues(rec.data);
            //~ 20110701 panel.form.my_loadRecord(rec);
            this.loadMask.hide();
            Lino.notify(action.result.message);
            if (action.result.data_record)
                this.set_current_record(action.result.data_record,after);
            else
                console.log("Warning: no data_record in response to FormPanel.PUT")
            //~ this.refresh_with_after(after);
            //~ if (after) after(); else panel.refresh();
          },
          failure: function(form,action) { 
            this.loadMask.hide();
            Lino.on_submit_failure(form,action)},
          clientValidation: true
        })
      }
    } else Lino.notify("Sorry, no current record.");
  }
  
  ,on_cancel : function() { 
    this.get_containing_window().close();
  }
  ,on_ok : function() { 
      this.save(null,true);
      //~ var rec = this.get_current_record();
      //~ if (rec && rec.phantom)
          //~ this.do_when_clean(true,function() { Lino.close_window(); });
  }
  ,config_containing_window : function(wincfg) { 
      wincfg.keys = [
        { key: Ext.EventObject.ENTER, fn: this.on_ok, scope:this }
        ,{ key: Ext.EventObject.ESCAPE, fn: this.on_cancel, scope:this }
      ]
  }
  
  
  /* not used (no longer possible without .dtl files)
  , edit_detail_config : function () {
    var active_tab = {};
    var main = this.items.get(0);
    if (main.getActiveTab !== undefined) {
      var tabitem = main.getActiveTab();
      Ext.apply(active_tab,{$ext_requests.URL_PARAM_TAB : main.items.indexOf(tabitem)});
    }
    var editor = new Ext.form.TextArea();
    var close = function() { win.close(); }
    var _this = this;
    var save = function() { 
      //~ console.log(20110609,arguments); 
      var params = {desc: editor.getValue()};
      Ext.apply(params,active_tab);
      var a = { 
        params: params, 
        method: 'PUT',
        url: ADMIN_URL + '/detail_config' + _this.ls_url,
        failure : Lino.ajax_error_handler(this),
        success: Lino.action_handler( _this, function(result) {
          //~ console.log('detail_config/save success',result);
          win.close();
          document.location = _this.get_permalink();
        })
      };
      //~ console.log('detail_config/save sent',a);
      _this.loadMask.show(); // 20120211
      Ext.Ajax.request(a);
    }
    var save_btn = new Ext.Button({text:'Save',handler:save,disabled:true});
    var win = new Ext.Window({title:'Detail Layout',
      items:editor, layout:'fit',
      width:500,height:500,
      bbar:[{text:'Cancel',handler:close},save_btn]});
    var a = { 
      params:active_tab, 
      method:'GET',
      url:ADMIN_URL+'/detail_config'+_this.ls_url,
      success : function(response) {
        if (response.responseText) {
          var result = Ext.decode(response.responseText);
          if (result.success) {
            editor.setValue(result.desc);
            save_btn.enable();
          }
        }
      }
    };
    Ext.Ajax.request(a);
    win.show();
  }
  */
});


Lino.getRowClass = function(record, rowIndex, rowParams, store) {
  if (record.phantom) {
    //~ console.log(20101009,record);
    //~ rowParams.bodyStyle = "color:red;background-color:blue";
    return 'lino-phantom-row';
    }
  //~ console.log('20101009 not a phantom:',record);
  return '';
}

//~ FOO = 0;



Lino.GridStore = Ext.extend(Ext.data.ArrayStore,{ 
  autoLoad: false
  ,load: function(options) {
    //~ foo.bar = baz; // 20120213
    if (!options) options = {};
    if (!options.params) options.params = {};
    options.params.fmt = 'json';
    options.params.rp = this.grid_panel.getId();
    Lino.insert_subst_user(options.params); // since 20121016
      
    
    if (this.grid_panel.hide_top_toolbar) {
        //~ console.log("20120206 GridStore.load() toolbar is hidden");
        options.params.start = 0;
        if (this.grid_panel.preview_limit) {
          options.params.limit = this.grid_panel.preview_limit;
        }
    } else {
        var ps = this.grid_panel.calculatePageSize();
        if (!ps) {
            //~ this.gridpanel.on('render',this.load())
          //~ console.log("20120814 GridStore.load() failed to calculate pagesize");
          return false;
            //~ params.$URL_PARAM_LIMIT = 1;
            //~ this.grid_panel.on('render',this.load.createDelegate(this,options))
            //~ return;
        } 
        options.params.limit = ps;
      
        //~ options.params.start = this.grid_panel.getTopToolbar().cursor;
        //~ if (this.grid_panel.getTopToolbar().pageSize !=  ps) {
          //~ console.log("20120206 abort load because toolbar says pagesize",
            //~ this.grid_panel.getTopToolbar().pageSize,
            //~ "while actual pagesize is",ps);
            //~ return;
        //~ }
        
        this.grid_panel.getTopToolbar().pageSize =  ps;
        if (options.params.start == undefined)
            options.params.start = this.grid_panel.getTopToolbar().cursor;
      
    }
      
    this.grid_panel.add_param_values(options.params);
    //~ Lino.insert_subst_user(options.params);
    //~ console.log("20120814 GridStore.load()",options.params,this.baseParams);
    //~ if (FOO > 0) {
        //~ foo.bar = baz;
    //~ } else FOO += 1;
    return Lino.GridStore.superclass.load.call(this,options);
  }
});

    
Lino.GridPanel = Ext.extend(Ext.grid.EditorGridPanel,Lino.MainPanel);
Lino.GridPanel = Ext.extend(Lino.GridPanel,Lino.PanelMixin);
Lino.GridPanel = Ext.extend(Lino.GridPanel,{
  quick_search_text : '',
  is_searching : false,
  disabled_in_insert_window : true,
  clicksToEdit:2,
  enableColLock: false,
  autoHeight: false,
  params_panel_hidden : false,
  preview_limit : undefined, 
  //~ loadMask: true,
  //~ viewConfig: {
          //~ getRowClass: Lino.getRowClass,
          //~ emptyText:"$_('No data to display.')"
        //~ },
  loadMask: {msg:"Bitte warten..."},
  
  constructor : function(config){

    config.plugins = [new Lino.GridFilters()];
    
    
    Lino.GridPanel.superclass.constructor.call(this,config);
    
    //~ if (this.containing_window) {
        //~ console.log("20111206 install refresh");
        //~ this.containing_window.on('show',this.refresh,this);
    //~ }
    
  },
  
  is_loading : function() { 
    //~ return this.store.getCount() > 0; 
    return !this.loadMask.disabled; 
  },
  
  unused_config_containing_window : function(wincfg) { 
      //~ temporarily remove save_grid_config button (see /blog(2012/1107)
      if (wincfg.tools != undefined) 
        wincfg.tools = [
          //~ {handler:this.save_grid_data,
            //~ qtip:"$_("Save Grid Data")",
            //~ scope:this, id:"save_data"}, // 20120814
          {handler:this.save_grid_config,
            qtip:"Tabellenkonfiguration speichern",
            scope:this, id:"save"}
        ].concat(wincfg.tools);
      //~ wincfg.listeners = { show: ... };
  },
  init_containing_window : function(win) { 
    //~ console.log("20111206 install refresh");
    //~ win.on('show',this.refresh,this);
  },
  
  initComponent : function(){
    
    /* 
    Problem 20111206:
    When a GridPanel is the main item of the window, then it doesn't 
    have it's own header but uses the window's header bar.
    We must do this in initComponent because e.g. in beforerender 
    it's already to late: a header element has been created because 
    there was a title.
    But Lino.Window adds itself as `this.containing_window` 
    only after the GridPanel has been initialized.
    Workaround is to generate a line "params.containing_window = true;" 
    in the handler function.
    */ 
    //~ if (this.containing_window) {
    if (this.is_main_window) {
        //~ console.log(20111206, 'delete title',this.title,'from',this);
        //~ delete this.title;
        this.tools = undefined;  
        this.title = undefined;  /* simply deleting it 
          isn't enough because that would only 
          unhide the title defined in some base class. */
    } 
    //~ else console.log(20111206, 'dont delete title',this.title,'from',this);
    
    /* e.g. when slave gridwindow called from a permalink */
    //~ if (this.base_params) Ext.apply(bp,this.base_params);  
    //~ bp['fmt'] = 'json';
    
    //~ function on_proxy_write( proxy, action,data, response,rs,options) {
      //~ console.log('20120814 on_proxy_write',action,data,response)
      //~ this.getStore().doUpdate();
      //~ this.getStore().loadData(data);
    //~ }
    //~ function on_proxy_load( proxy, transactionObject, callbackOptions ) {
      //~ console.log('on_proxy_load',transactionObject)
    //~ }
    var proxy = new Ext.data.HttpProxy({ 
      // 20120814 
      url: '/api' + this.ls_url
      ,method: "GET"
      //~ ,url: ADMIN_URL + '/restful' + this.ls_url
      //~ ,restful: true 
      //~ ,listeners: {load:on_proxy_load} 
      //~ ,listeners: {write:on_proxy_write} 
    });
    //~ config.store = new Ext.data.JsonStore({ 
    //~ this.store = new Ext.data.ArrayStore({ 
    this.store = new Lino.GridStore({ 
      grid_panel: this
      ,listeners: { exception: Lino.on_store_exception }
      ,remoteSort: true
      ,totalProperty: "count"
      ,root: "rows"
      //~ ,id: "id" 
      ,proxy: proxy
      //~ autoLoad: this.containing_window ? true : false
      ,idIndex: this.pk_index
      //~ ,baseParams: bp
      ,fields: this.ls_store_fields
      ,idProperty: this.ls_id_property 
      // 20120814
      //~ ,writer : new Ext.data.JsonWriter({
        //~ writeAllFields: false
        //~ ,listful: true
      //~ })
      //~ ,restful : true
    });
      
    //~ console.log('config.pk_index',config.pk_index,config.store),
    delete this.ls_store_fields;
      
    var this_ = this;
    //~ var grid = this;
    this.store.on('load', function() {
        //~ console.log('20120814 GridStore.on(load)',this_.store);
        //~ var da = this_.store.reader.arrayData.disabled_actions;
        //~ if (da) {
            //~ this.cmenu.cascade(function(item){ 
              //~ console.log(20120531, item.itemId, da[item.itemId]);
              //~ if (da[item.itemId]) item.disable(); else item.enable();
            //~ });
        //~ };
        this_.set_param_values(this_.store.reader.arrayData.param_values);
        //~ this_.set_status(this_.store.reader.arrayData.status);
        //~ 20120918
        if (this_.store.reader.arrayData.no_data_text) {
            //~ this.viewConfig.emptyText = this_.store.reader.arrayData.no_data_text;
            this.getView().emptyText = this_.store.reader.arrayData.no_data_text;
            this.getView().refresh();
        }
        if (this_.containing_window)
            this_.set_window_title(this_.store.reader.arrayData.title);
            //~ this_.containing_window.setTitle(this_.store.reader.arrayData.title);
        if (!this.is_searching) { // disabled 20121025: quick_search_field may not lose focus
          this.is_searching = false;
          if (this_.selModel.getSelectedCell){
              if (this_.getStore().getCount()) // there may be no data
                  this_.selModel.select(0,0); 
          } else {
              this_.selModel.selectFirstRow();
              this_.getView().focusEl.focus();
          }
        } 
        //~ else console.log("is_searching -> no focussing");
        //~ var t = this.getTopToolbar();
        //~ var activePage = Math.ceil((t.cursor + t.pageSize) / t.pageSize);
        //~ this.quick_search_field.focus(); // 20121024
      }, this
    );
    var actions = Lino.build_buttons(this,this.ls_bbar_actions);
    //~ Ext.apply(config,Lino.build_buttons(this,config.ls_bbar_actions));
    //~ config.bbar, this.cmenu = Lino.build_buttons(this,config.ls_bbar_actions);
    //~ this.cmenu = new Ext.menu.Menu({items: config.bbar});
    delete this.ls_bbar_actions
    if (actions) {
        this.cmenu = actions.cmenu;
    }
    
    if (!this.hide_top_toolbar) {  
      var tbar = [ 
        this.quick_search_field = new Ext.form.TextField({ 
          //~ fieldLabel: "Search"
          listeners: { 
            scope:this_
            //~ ,change:this_.search_change
            
            ,render: Lino.quicktip_renderer("Schnellsuche","Hier Text eingeben für Schnellsuche.")
            
            //~ ,keypress: this.search_keypress 
            ,blur: function() { this.is_searching = false}
          }
          ,validator:function(value) { return this_.search_validate(value) }
          //~ ,tooltip: "Enter a quick search text, then press TAB"
          //~ value: text
          //~ scope:this, 
          //~ ,enableKeyEvents: true
          //~ listeners: { keypress: this.search_keypress }, 
          //~ id: "seachString" 
      })];
      tbar = this.add_params_panel(tbar);
      tbar = tbar.concat([
        { scope:this, 
          //~ text: "[csv]", 
          tooltip: "Diese Tabelle in eine .csv-Datei exportieren", 
          iconCls: 'x-tbar-csv',
          handler: function() { 
            //~ 20130116 var p = Ext.apply({},this.get_base_params());
            //~ 20130116 p.fmt = 'csv';
            //~ url += "?" + Ext.urlEncode(p);
            var p = this.get_current_grid_config();
            Ext.apply(p,this.get_base_params());
            p.fmt = "csv";
            this.add_param_values(p);
            
            window.open('/api'+this.ls_url + "?" + Ext.urlEncode(p)) 
          } },
        //~ { scope:this, 
          //~ text: "[html]", 
          //~ handler: function() { 
            //~ var p = this.get_current_grid_config();
            //~ Ext.apply(p,this.get_base_params());
            //~ p.$ext_requests.URL_PARAM_FORMAT = "$ext_requests.URL_FORMAT_PRINTER";
            //~ this.add_param_values(p);
            //~ window.open(ADMIN_URL+'/api'+this.ls_url + "?" + Ext.urlEncode(p)) 
          //~ } },
        { scope:this, 
          //~ text: "[html]", 
          tooltip: "Tabelle als HTML anzeigen", 
          iconCls: 'x-tbar-html',
          handler: function() { 
            var p = this.get_current_grid_config();
            Ext.apply(p,this.get_base_params());
            //~ since 20121226 p.$ext_requests.URL_PARAM_FORMAT = "$ext_requests.URL_FORMAT_PLAIN";
            this.add_param_values(p);
            //~ since 20121226 window.open(ADMIN_URL+'/api'+this.ls_url + "?" + Ext.urlEncode(p)) 
            window.open('/plain'+this.ls_url + "?" + Ext.urlEncode(p)) 
          } },
        { scope:this, 
          //~ text: "[pdf]", 
          tooltip: "Diese Tabelle in eine .pdf-Datei exportieren", 
          iconCls: 'x-tbar-pdf',
          handler: function() { 
            var p = this.get_current_grid_config();
            Ext.apply(p,this.get_base_params());
            p.fmt = "pdf";
            this.add_param_values(p);
            window.open('/api'+this.ls_url + "?" + Ext.urlEncode(p)) 
          } }
      ]);
    
    
      var menu = [];
      var set_gc = function(index) {
        return function() {
          //~ console.log('set_gc() 20100812');
          this.getColumnModel().setConfig(
              this.apply_grid_config(index,this.ls_grid_configs,this.ls_columns));
        }
      }
      for (var i = 0; i < this.ls_grid_configs.length;i++) {
        var gc = this.ls_grid_configs[i];
        menu.push({text:gc.label,handler:set_gc(i),scope:this})
      }
      if(menu.length > 1) {
        tbar = tbar.concat([
          { text:"Ansicht",
            menu: menu,
            tooltip:"Andere Ansicht auswählen"
          }
        ]);
      }
      
      if (actions) {
        tbar = tbar.concat(actions.bbar);
          //~ this.bbar = actions.bbar;
      }
      
      this.tbar = new Ext.PagingToolbar({ 
        store: this.store, 
        prependButtons: true, 
        //~ pageSize: this.page_length, 
        pageSize: 1, 
        displayInfo: true, 
        beforePageText: "Seite",
        afterPageText: "von {0}",
        displayMsg: "Zeilen {0} bis {1} von {2}",
        firstText: "Erste Seite",
        lastText: "Letzte Seite",
        prevText: "Vorige Seite",
        nextText: "Nächste Seite",
        items: tbar
      });
      //~ this.on('resize', function(cmp,aw,ah,rw,rh) {
          //~ var ps = this.calculatePageSize();
          //~ if (ps && ps != this.getTopToolbar().pageSize) {
              //~ // console.log('20120203 resize : pageSize',this.getTopToolbar().pageSize,'->',ps);
              //~ // this.getTopToolbar().pageSize =  ps;
              //~ cmp.refresh();
              //~ // this.getTopToolbar().doRefresh();
          //~ }
        //~ }, this);
      //~ this.on('resize', function(cmp,aw,ah,rw,rh) {
          //~ cmp.getTopToolbar().pageSize = this.calculatePageSize(aw,ah,rw,rh) || 10;
          //~ cmp.refresh();
        //~ }, this, {delay:500});
    }
    
    //~ delete this.page_length
    
    
      
    if (this.ls_quick_edit) {
      this.selModel = new Ext.grid.CellSelectionModel()
      this.get_selected = function() {
        //~ console.log(this.getSelectionModel().selection);
        if (this.selModel.selection)
            return [ this.selModel.selection.record ];
        return [this.store.getAt(0)];
      };
      this.get_current_record = function() { 
        if (this.getSelectionModel().selection) 
          return this.selModel.selection.record;
        return this.store.getAt(0);
      };
    } else { 
      this.selModel = new Ext.grid.RowSelectionModel() 
      this.get_selected = function() {
        var sels = this.selModel.getSelections();
        if (sels.length == 0) sels = [this.store.getAt(0)];
        return sels
        //~ var sels = this.getSelectionModel().getSelections();
        //~ return Ext.pluck(sels,'id');
      };
      this.get_current_record = function() { 
        var rec = this.selModel.getSelected();
        if (rec == undefined) rec = this.store.getAt(0);
        return rec
      };
    };
    delete this.ls_quick_edit;
    
    this.columns  = this.apply_grid_config(this.gc_name,this.ls_grid_configs,this.ls_columns);
    
    //~ var grid = this;
    //~ this.colModel = new Ext.grid.ColumnModel({
      //~ columns: this.apply_grid_config(this.gc_name,this.ls_grid_configs,this.ls_columns),
      //~ isCellEditable: function(col, row) {
        //~ var record = grid.store.getAt(row);
        //~ console.log('20120514',col,record); // dataIndex
        //~ var dataIndex = grid.colModel.getDataIndex(col);
        //~ if (dataIndex in record.data['disabled_fields']) {
            //~ Lino.notify("$_("This field is disabled")");
            //~ return false;
        //~ }
        //~ return Ext.grid.ColumnModel.prototype.isCellEditable.call(this, col, row);
      //~ }
    //~ });    
    
    
    Lino.GridPanel.superclass.initComponent.call(this);
    
    //~ if (this.containing_window) 
        //~ this.on('afterlayout', this.refresh, this);
        //~ this.on('afterrender', this.refresh,this);
    //~ else
        //~ this.on('show', this.refresh,this);
    //~ this.on('afterlayout', function() {
      //~ if (this.id == "ext-comp-1157") 
        //~ console.log("20120213 afterlayout",this); 
      //~ // this.refresh();
      //~ },this);
    //~ this.on('afterrender', this.refresh);
    //~ this.on('resize', this.refresh,this,{delay:500});
    //~ this.on('resize', function(){console.log("20120213 resize",arguments)},this);
    this.on('resize', function(){
      //~ console.log("20120213 resize",arguments)
      this.refresh();
      },this);
    this.on('viewready', function(){
      //~ console.log("20120213 resize",arguments);
      this.view_is_ready = true;
      this.refresh();
      },this);
    this.on('afteredit', this.on_afteredit); // 20120814
    //~ this.on('afteredit', this.new_on_afteredit);
    this.on('beforeedit', this.on_beforeedit);
    this.on('beforeedit',function(e) { this.before_row_edit(e.record)},this);
    this.on('cellcontextmenu', Lino.cell_context_menu, this);
    //~ this.on('contextmenu', Lino.grid_context_menu, this);
    
    
    //~ if (this.id == "ext-comp-1157") captureEvents(this);    
    
  },
  
  //~ onResize : function(){
      //~ console.log("20120206 GridPanel.onResize",arguments);
      //~ Lino.GridPanel.superclass.onResize.apply(this, arguments);
      //~ this.refresh();
  //~ },
  
  
  get_status : function(){
    var st = { base_params : this.get_base_params()};
    if (!this.hide_top_toolbar) {
        st.current_page = this.getTopToolbar().current;
    }
    st.param_values = this.status_param_values;
    //~ console.log("20120213 GridPanel.get_status",st);
    return st;
  },
  
  /* 
  Lino.GridPanel.set_status() 
  */
  set_status : function(status){
    //~ console.log("20120918 GridPanel.set_status",status);
    this.clear_base_params();
    if (status == undefined) status = {};
    this.set_param_values(status.param_values);
    if (status.base_params) { 
      this.set_base_params(status.base_params);
    }
    if (!this.hide_top_toolbar) {
      //~ console.log("20120213 GridPanel.getTopToolbar().changePage",
          //~ status.current_page || 1);
      this.getTopToolbar().changePage(status.current_page || 1);
    }
    //~ this.fireEvent('resize');
    //~ this.refresh.defer(100,this); 
    //~ this.onResize.defer(100,this); 
    //~ this.refresh(); 
    //~ this.doLayout(); 
    //~ this.onResize(); 
    //~ this.store.load();
  },
  
  refresh : function(unused) { 
    this.refresh_with_after();
  },
  refresh_with_after : function(after) { 
    //~ Lino.notify('20120204 Lino.GridPanel.refresh');
    //~ Lino.notify('Lino.GridPanel.refresh '+this.store.proxy.url);
    //~ var bp = { fmt:'json' }
    if (this.containing_panel) {
        //~ Ext.apply(p,this.master_panel.get_master_params());
        //~ Ext.apply(options.params,this.containing_panel.get_master_params());
        this.set_base_params(this.containing_panel.get_master_params());
    }
    
    if (! this.view_is_ready) return;
    
    var options = {};
    if (after) {
        options.callback = function(r,options,success) {if(success) after()}
    }
      
    //~ if (!this.rendered) {
        //~ console.log("20120206 GridPanel.refresh() must wait until rendered",options);
        //~ this.grid_panel.on('render',this.load.createDelegate(this,options))
        //~ return;
    //~ }
    
    this.store.load(options);
  },
  
  /* pageSize depends on grid height (Trying to remove scrollbar)
  Thanks to 
  - Christophe Badoit on http://www.sencha.com/forum/showthread.php?82647
  - http://www.sencha.com/forum/archive/index.php/t-37231.html
  */
  calculatePageSize : function(second_attempt) {
    //~ if (!this.rendered) { 
    if (!this.view_is_ready) { 
      //~ console.log('Cannot calculatePageSize() : not rendered');
      return false; }
    //~ if (!this.isVisible()) { 
      //~ console.log('calculatePageSize : not visible');
      //~ return false; }
      
    //~ console.log('getFrameHeight() is',this.getFrameHeight());
    //~ console.log('getView().scroller.getHeight() is',this.getView().scroller.getHeight());
    //~ console.log('mainBody.getHeight() is',this.getView().mainBody.getHeight());
    //~ console.log('getInnerHeight() is',this.getInnerHeight());
    //~ console.log('getHeight() is',this.getHeight());
    //~ console.log('el.getHeight() is',this.getEl().getHeight());
    //~ console.log('getGridEl().getHeight() is',this.getGridEl().getHeight());
    //~ console.log('getOuterSize().height is',this.getOuterSize().height);
    //~ console.log('getBox().height is',this.getBox().height);
    //~ console.log('getResizeEl.getHeight() is',this.getResizeEl().getHeight());
    //~ console.log('getLayoutTarget().getHeight() is',this.getLayoutTarget().getHeight());
      
    var rowHeight = this.getFrameHeight();
    //~ var rowHeight = 52; // experimental value
    var row = this.view.getRow(0);
    if (row) {
      //~ console.log('20120213 yes');
      rowHeight = Ext.get(row).getHeight();
    }
    //~ console.log('rowHeight is ',rowHeight,this,caller);
    //~ this.getView().syncScroll();
    //~ this.getView().initTemplates();
    var height = this.getView().scroller.getHeight();
    //~ console.log('getView().scroller.getHeight() is',this.getView().scroller.getHeight());
    //~ console.log('getInnerHeight() - getFrameHeight() is',
      //~ this.getInnerHeight(), '-',
      //~ this.getFrameHeight(), '=',
      //~ this.getInnerHeight() - this.getFrameHeight());
    //~ var height = this.getView().mainBody.getHeight();
    //~ var height = this.getView().mainWrap.getHeight();
    //~ var height = this.getView().resizeMarker.getHeight();
    //~ this.syncSize();
    //~ var height = this.getInnerHeight() - this.getFrameHeight();
    //~ var height = this.getHeight() - this.getFrameHeight();
    height -= Ext.getScrollBarWidth(); // leave room for a possible horizontal scrollbar... 
    //~ height -= this.getView().scrollOffset;
    var ps = Math.floor(height / rowHeight);
    //~ console.log('20120203 calculatePageSize():',height,'/',rowHeight,'->',ps);
    ps -= 1; // leave room for a possible phantom row
    //~ return (ps > 1 ? ps : false);
    if (ps > 1) return ps;
    //~ console.log('calculatePageSize() found less than 1 row:',height,'/',rowHeight,'->',ps);
    //~ foo.bar = baz; // 20120213
    return 5; // preview_limit
    //~ if (second_attempt) {
        //~ console.log('calculatePageSize() abandons after second attempt:',
          //~ height,'/',rowHeight,'->',ps);
      //~ return 5;
    //~ }
    //~ return this.calculatePageSize.defer(500,this,[true]);
  },
  
  onCellDblClick : function(grid, row, col){
      //~ console.log("20120307 onCellDblClick",this,grid, row, col);
      if (this.ls_detail_handler) {
          //~ Lino.notify('show detail');
          Lino.show_detail(this);
          return false;
      }else{
        //~ console.log('startEditing');
        this.startEditing(row,col);
      }
  },
  
  get_base_params : function() {
    //~ return this.containing_window.config.base_params;
    //~ console.log(20120717,this.store.baseParams);
    var p = Ext.apply({},this.store.baseParams);
    Lino.insert_subst_user(p);
    //~ console.log("20120717 GRidPanel.get_base_params() returns",p);
    return p;
    //~ return this.store.baseParams;
  },
  set_base_params : function(p) {
    //~ console.log('GridPanel.set_base_params',p)
    for (k in p) this.store.setBaseParam(k,p[k]);
    //~ this.store.baseParams = p;
    if (p.query) 
        this.quick_search_field.setValue(p.query);
    //~ if (p.param_values) 
        //~ this.set_param_values(p.param_values);  
  },
  clear_base_params : function() {
      this.store.baseParams = {};
      Lino.insert_subst_user(this.store.baseParams);
  },
  set_base_param : function(k,v) {
    this.store.setBaseParam(k,v);
  },
  
  //~ get_permalink_params : function() {
    //~ var p = {};
    //~ return p;
  //~ },
  
  before_row_edit : function(record) {},
    
  //~ search_keypress : function(){
    //~ console.log("2012124 search_keypress",arguments);
  //~ },
  search_validate : function(value) {
    if (value == this.quick_search_text) return true;
    this.is_searching = true;
    //~ console.log('search_validate',value)
    this.quick_search_text = value;
    this.set_base_param('query',value); 
    //~ this.getTopToolbar().changePage(1);
    this.getTopToolbar().moveFirst();
    //~ this.refresh();
    return true;
  },
  
  search_change : function(field,oldValue,newValue) {
    //~ console.log('search_change',field.getValue(),oldValue,newValue)
    this.set_base_param('query',field.getValue()); 
    this.getTopToolbar().moveFirst();
    //~ this.refresh();
  },
  
  apply_grid_config : function(index,grid_configs,rpt_columns) {
    //~ var rpt_columns = this.ls_columns;
    var gc = grid_configs[index];    
    //~ console.log('apply_grid_config() 20100812',name,gc);
    this.gc_name = index;
    if (gc == undefined) {
      return rpt_columns;
      //~ config.columns = config.ls_columns;
      //~ return;
    } 
    //~ delete config.ls_filters
    
    //~ console.log(20100805,config.ls_columns);
    var columns = Array(gc.columns.length);
    for (var j = 0; j < rpt_columns.length;j++) {
      var col = rpt_columns[j];
      for (var i = 0; i < gc.columns.length; i++) {
        if (col.dataIndex == gc.ci[i]) {
          col.width = gc.cw[i];
          col.hidden = gc.ch[i];
          columns[i] = col;
          break;
        }
      }
    }
    
    //~ var columns = Array(rpt_columns.length);
    //~ for (var i = 0; i < rpt_columns.length; i++) {
      //~ columns[i] = rpt_columns[gc.columns[i]];
      //~ columns[i].width = gc.widths[i];
    //~ }
    
    //~ if (gc.hidden_cols) {
      //~ for (var i = 0; i < gc.hidden_cols.length; i++) {
        //~ var hc = gc.hidden_cols[i];
        //~ for (var j = 0; j < columns.length;j++) {
          //~ var col = columns[j];
          //~ if (col.dataIndex == hc) {
            //~ col.hidden = true;
            //~ break
          //~ }
        //~ }
      //~ }
    //~ }
    if (gc.filters) {
      //~ console.log(20100811,'config.ls_filters',config.ls_filters);
      //~ console.log(20100811,'config.ls_grid_config.filters',config.ls_grid_config.filters);
      for (var i = 0; i < gc.filters.length; i++) {
        var fv = gc.filters[i];
        for (var j = 0; j < columns.length;j++) {
          var col = columns[j];
          if (col.dataIndex == fv.field) {
            //~ console.log(20100811, f,' == ',fv);
            if (fv.type == 'string') {
              col.filter.value = fv.value;
              //~ if (fv.comparison !== undefined) f.comparison = fv.comparison;
            } else {
              //~ console.log(20100811, fv);
              col.filter.value = {};
              col.filter.value[fv.comparison] = fv.value;
            }
            break;
          }
        };
      }
    }
    
    return columns;
    //~ config.columns = cols;
    //~ delete config.ls_columns
  },
  
  get_current_grid_config : function () {
    var cm = this.getColumnModel();
    var widths = Array(cm.config.length);
    var hiddens = Array(cm.config.length);
    //~ var hiddens = Array(cm.config.length);
    var columns = Array(cm.config.length);
    //~ var columns = Array(cm.config.length);
    //~ var hidden_cols = [];
    //~ var filters = this.filters.getFilterValues();
    var p = this.filters.buildQuery(this.filters.getFilterData())
    for (var i = 0; i < cm.config.length; i++) {
      var col = cm.config[i];
      columns[i] = col.dataIndex;
      //~ hiddens[i] = col.hidden;
      widths[i] = col.width;
      hiddens[i] = col.hidden;
      //~ if (col.hidden) hidden_cols.push(col.dataIndex);
    }
    //~ p['hidden_cols'] = hidden_cols;
    p.cw = widths;
    p.ch = hiddens;
    p.ci = columns;
    //~ p['widths'] = widths;
    //~ p['hiddens'] = hiddens;
    //~ p['columns'] = columns;
    p['name'] = this.gc_name;
    //~ var gc = this.ls_grid_configs[this.gc_name];
    //~ if (gc !== undefined) 
        //~ p['label'] = gc.label
    //~ console.log('20100810 save_grid_config',p);
    return p;
  },
  
  unused_manage_grid_configs : function() {
    var data = [];
    for (k in this.ls_grid_configs) {
      var v = this.ls_grid_configs[k];
      var i = [k,String(v.columns),String(v.hidden_cols),String(v.filters)];
      data.push(i)
    }
    if (this.ls_grid_configs[this.gc_name] == undefined) {
      var v = this.get_current_grid_config();
      var i = [k,String(v.columns),String(v.hidden_cols),String(v.filters)];
      data.push(i);
    }
    //~ console.log(20100811, data);
    var main = new Ext.grid.GridPanel({
      store: new Ext.data.ArrayStore({
        idIndex:0,
        fields:['name','columns','hidden_cols','filters'],
        autoDestroy:true,
        data: data}),
      //~ autoHeight:true,
      selModel: new Ext.grid.RowSelectionModel(),
      listeners: { 
        rowdblclick: function(grid,rowIndex,e) {
          console.log('row doubleclicked',grid, rowIndex,e);
        },
        rowclick: function(grid,rowIndex,e) {
          console.log('row clicked',grid, rowIndex,e);
        }
      },
      columns: [ 
        {dataIndex:'name',header:'Name'}, 
        {dataIndex:'columns',header:'columns'}, 
        {dataIndex:'hidden_cols',header:'hidden columns'}, 
        {dataIndex:'filters',header:'filters'} 
      ]
    });
    var win = new Ext.Window({title:'GridConfigs Manager',layout:'fit',items:main,height:200});
    win.show();
  },
  
  unused_edit_grid_config : function(name) {
    gc = this.ls_grid_configs[name];
    var win = new Ext.Window({
      title:'Edit Grid Config',layout:'vbox', 
      //~ layoutConfig:'stretch'
      items:[
        {xtype:'text', value: gc.name},
        {xtype:'text', value: gc.columns},
        {xtype:'text', value: gc.hidden_cols},
        {xtype:'text', value: gc.filters}
      ]
    });
    win.show();
  },
  
  save_grid_config : function () {
    //~ console.log('TODO: save_grid_config',this);
    //~ p.column_widths = Ext.pluck(this.colModel.columns,'width');
    var a = { 
      params:this.get_current_grid_config(), 
      method:'PUT',
      url:'/grid_config' + this.ls_url,
      success: Lino.action_handler(this),
      scope: this,
      failure: Lino.ajax_error_handler(this)
    };
    this.loadMask.show(); // 20120211
    Ext.Ajax.request(a);
    //~ Lino.do_action(this,a);
  },
  
  on_beforeedit : function(e) {
    //~ console.log('20130128 GridPanel.on_beforeedit()',e,e.record.data.disable_editing);
    if(this.disable_editing | e.record.data.disable_editing) {
      e.cancel = true;
      Lino.notify("Dieser Datensatz ist deaktiviert");
      return;
    }
    if(e.record.data.disabled_fields && e.record.data.disabled_fields[e.field]) {
      e.cancel = true;
      Lino.notify("Dieses Feld ist deaktiviert");
      return;
    }
    //~ if (e.record.data.disabled_fields) {
      //~ for (i in e.record.data.disabled_fields) {
        //~ if(e.record.data.disabled_fields[i] == e.field) {
          //~ e.cancel = true;
          //~ Lino.notify(String.format('Field "{0}" is disabled for this record',e.field));
          //~ return
        //~ }
      //~ }
    //~ }
  },
  save_grid_data : function() {
      //~ console.log("20120814 save_grid_data");
      this.getStore().commitChanges();
  },
  new_on_afteredit : function(e) {
      //~ this.getStore().commitChanges();
      //~ this.getStore().doUpdate();
      //~ this.getStore().loadData(data);
      console.log("20120814 new_on_afteredit",e);
  },
  on_afteredit : function(e) {
    /*
    e.grid - The grid that fired the event
    e.record - The record being edited
    e.field - The field name being edited
    e.value - The value being set
    e.originalValue - The original value for the field, before the edit.
    e.row - The grid row index
    e.column - The grid column index
    */
    var p = {};
    //~ console.log('20101130 modified: ',e.record.modified);
    //~ console.log('20101130 value: ',e.value);
    //~ var p = e.record.getChanges();
    //~ console.log('20101130 getChanges: ',e.record.getChanges());
    //~ this.before_row_edit(e.record);
    for(k in e.record.getChanges()) {
        var v = e.record.get(k);
    //~ for(k in e.record.modified) {
        //~ console.log('20101130',k,'=',v);
        //~ var cm = e.grid.getColumnModel();
        //~ var di = cm.getDataIndex(k);
        var f = e.record.fields.get(k);
        //~ console.log('20101130 f = ',f);
        //~ var v = e.record.get(di);
        if (f.type.type == 'date') {
            p[k] = Ext.util.Format.date(v, f.dateFormat);
        }else{
            p[k] = v;
            var v = e.record.get(k+'Hidden');
            if (v !== undefined) {
              p[k+'Hidden'] = v;
            }
        }
        //~ var i = cm.findColumnIndex(k);
        //~ var r = cm.getRenderer(i);
        //~ var editor = cm.getCellEditor(i,e.row);
        //~ var col = e.grid.getColumnModel().getColumnById(k);
        //~ console.log('20101130 r = ',r(v));
        //~ var f = e.record.fields[k];
        //~ console.log('20101130 f = ',f);
        //~ console.log('20101130 editor = ',editor);
        //~ p[k] = f.getValue();
        //~ p[k] = r(v);
    }
    //~ console.log('20101130 p:',p);
    //~ var cm = e.grid.getColumnModel();
    //~ var di = cm.getDataIndex(e.column);
    //~ var f = e.record.fields.get(di);
    //~ console.log('20101130 f = ',f);
    //~ if (f.type.type == 'date') e.record.set(di,Ext.util.Format.date(e.value, f.dateFormat));
    
    
    //~ var p = e.record.data;
    
    // var p = {};
    //~ p['grid_afteredit_colname'] = e.field;
    //~ p[e.field] = e.value;
    //~ console.log('20100723 GridPanel.on_afteredit()',e);
    // add value used by ForeignKeyStoreField CHOICES_HIDDEN_SUFFIX
    // not sure whether this is still needed:
    p[e.field+'Hidden'] = e.value;
    //~ p.su = Lino.subst_user;
    Lino.insert_subst_user(p);
    // this one is needed so that this field can serve as choice context:
    e.record.data[e.field+'Hidden'] = e.value;
    // p[pk] = e.record.data[pk];
    // console.log("grid_afteredit:",e.field,'=',e.value);
    Ext.apply(p,this.get_base_params()); // needed for POST, ignored for PUT
    //~ Ext.apply(p,this.containing_window.config.base_params);
    //~ 20121109 p['$ext_requests.URL_PARAM_ACTION_NAME'] = 'grid';
    var self = this;
    var req = {
        params:p,
        waitMsg: 'Saving your data...',
        success: Lino.action_handler( this, function(result) {
          //~ if (result.data_record) {
          if (result.refresh_all) {
              var cw = self.get_containing_window();
              if (cw) {
                  cw.main_item.refresh();
              }
              else console.log("20120123 cannot refresh_all",self);
          } else if (result.rows) {
              //~ self.getStore().loadData(result,true);
              var r = self.getStore().reader.readRecords(result);
              if (e.record.phantom) {
                  //~ console.log("20120816 afteredit.success POST",r);
                  self.getStore().insert(e.row,r.records);
              }else{
                  //~ console.log("20120816 afteredit.success PUT",r);
                  self.getStore().doUpdate(r.records[0]);
              }
              self.getStore().rejectChanges(); /* 
              get rid of the red triangles without saving the record again
              */
              //~ self.getStore().commitChanges(); // get rid of the red triangles
          } else {
              self.getStore().commitChanges(); // get rid of the red triangles
              self.getStore().reload();        // reload our datastore.
          }
          }),
        scope: this,
        failure: Lino.ajax_error_handler(this)
    };
    if (e.record.phantom) {
      req.params.an = 'post'; // SubmitInsert.action_name
      Ext.apply(req,{
        method: 'POST',
        url: '/api' + this.ls_url
      });
    } else {
      req.params.an = 'put'; // SubmitDetail.action_name
      Ext.apply(req,{
        method: 'PUT',
        url: '/api' + this.ls_url + '/' + e.record.id
      });
    }
    //~ console.log('20110406 on_afteredit',req);
    this.loadMask.show(); // 20120211
    Ext.Ajax.request(req);
  },

  afterRender : function() {
    Lino.GridPanel.superclass.afterRender.call(this);
    // this.getView().mainBody.focus();
    // console.log(20100114,this.getView().getRows());
    // if (this.getView().getRows().length > 0) {
    //  this.getView().focusRow(1);
    // }
    //~ this.my_load_mask = new Ext.LoadMask(this.getEl(), {
        //~ msg:'$_("Please wait...")',
        //~ store:this.store});
      
    var tbar = this.getTopToolbar();
    // tbar.on('change',function() {this.getView().focusRow(1);},this);
    // tbar.on('change',function() {this.getSelectionModel().selectFirstRow();this.getView().mainBody.focus();},this);
    // tbar.on('change',function() {this.getView().mainBody.focus();},this);
    // tbar.on('change',function() {this.getView().focusRow(1);},this);
    this.nav = new Ext.KeyNav(this.getEl(),{
      pageUp: function() {tbar.movePrevious(); },
      pageDown: function() {tbar.moveNext(); },
      home: function() {tbar.moveFirst(); },
      end: function() {tbar.moveLast(); },
      scope: this
    });
  },
  after_delete : function() {
    //~ console.log('Lino.GridPanel.after_delete');
    this.refresh();
  },
  add_row_listener : function(fn,scope) {
    this.getSelectionModel().addListener('rowselect',fn,scope);
  },
  postEditValue : function(value, originalValue, r, field){
    value = Lino.GridPanel.superclass.postEditValue.call(this,value,originalValue,r,field);
    //~ console.log('GridPanel.postEdit()',value, originalValue, r, field);
    return value;
  },
  
  set_start_value : function(v) {
      this.start_value = v;
  },
  preEditValue : function(r, field){
      if (this.start_value) {
        var v = this.start_value;
        delete this.start_value;
        this.activeEditor.selectOnFocus = false;
        return v;
      }
      var value = r.data[field];
      return this.autoEncode && Ext.isString(value) ? Ext.util.Format.htmlDecode(value) : value;
  },
  
  on_master_changed : function() {
    //~ if (! this.enabled) return;
    //~ cmp = this;
    //~ console.log('Lino.GridPanel.on_master_changed()',this.title);
    if (! this.rendered) return; // 20120213
    var todo = function() {
      if (this.disabled) return;
      //~ if (this.disabled) return;
      //~ if (this.enabled) {
          //~ var src = caller.config.url_data + "/" + record.id + ".jpg"
          //~ console.log(20111125, this.containing_window);
          //~ for (k in p) this.getStore().setBaseParam(k,p[k]);
          //~ console.log('Lino.GridPanel.on_master_changed()',this.title,p);
          this.refresh();
          //~ this.set_base_params(this.master_panel.get_master_params());
          //~ this.getStore().load(); 
      //~ }
    };
    Lino.do_when_visible(this,todo.createDelegate(this));
  }
});
  

//~ Lino.MainPanelMixin = {
  //~ tbar_items : function() {
      //~ return ;
  //~ }
//~ };

//~ Ext.override(Lino.GridPanel,Lino.MainPanelMixin);
//~ Ext.override(Lino.FormPanel,Lino.MainPanelMixin);

//~ Lino.grid_context_menu = function(e) {
  //~ console.log('contextmenu',arguments);
//~ }

Lino.cell_context_menu = function(grid,row,col,e) {
  //~ console.log('20120531 cellcontextmenu',grid,row,col,e,grid.store.reader.arrayData.rows[row]);
  e.stopEvent();
  //~ grid.getView().focusCell(row,col);
  grid.getSelectionModel().select(row,col);
  //~ console.log(grid.store.getAt(row));
  //~ grid.getView().focusRow(row);
  //~ return;
  if(!grid.cmenu.el){grid.cmenu.render(); }
  //~ if(e.record.data.disabled_fields) {
  
  var da = grid.store.reader.arrayData.rows[row][grid.disabled_actions_index];
  if (da) {
      this.cmenu.cascade(function(item){ 
        //~ console.log(20120531, item.itemId, da[item.itemId]);
        if (da[item.itemId]) item.disable(); else item.enable();
      });
  };
  
  var xy = e.getXY();
  xy[1] -= grid.cmenu.el.getHeight();
  grid.cmenu.showAt(xy);
}


//~ Lino.load_main_menu = function() {
  //~ Ext.Ajax.request({
    //~ waitMsg: 'Loading main menu...',
    //~ method: 'GET',
    //~ url: '/menu',
    //~ success: Lino.on_load_menu,
    //~ failure: Lino.ajax_error_handler
  //~ });
//~ };



//~ Lino.SlavePlugin = function(caller) {
  //~ this.caller = caller;
//~ };

Lino.chooser_handler = function(combo,name) {
  return function(cmp,newValue,oldValue) {
    //~ console.log('Lino.chooser_handler()',cmp,oldValue,newValue);
    combo.setContextValue(name,newValue);
  }
};



Lino.ComboBox = Ext.extend(Ext.form.ComboBox,{
  forceSelection: true,
  triggerAction: 'all',
  minListWidth:230,
  autoSelect: false,
  selectOnFocus: true, // select any existing text in the field immediately on focus.
  submitValue: true,
  displayField: 'text', // 'text', 
  valueField: 'value', // 'value',
  
  //~ initComponent : Ext.form.ComboBox.prototype.initComponent.createSequence(function() {
  initComponent : function(){
      this.contextParams = {};
      //~ Ext.form.ComboBox.initComponent(this);
      Lino.ComboBox.superclass.initComponent.call(this);
  },
  setValue : function(v,record_data){
      /*
      Based on feature request developed in http://extjs.net/forum/showthread.php?t=75751
      */
      /* `record_data` is used to get the text corresponding to this value */
      //~ if(this.name == 'city') 
      //~ console.log('20120203', this.name,'.setValue(', v ,') this=', this,'record_data=',record_data);
      var text = v;
      if(this.valueField){
        if(v == null || v == '') { 
            //~ if (this.name == 'birth_country') 
                //~ console.log(this.name,'.setValue',v,'no lookup needed, value is empty');
            //~ v = undefined;
            v = '';
            //~ text = '';
        } else if (Ext.isDefined(record_data)) {
          text = record_data[this.name];
          //~ if (this.name == 'birth_country') 
            //~ console.log(this.name,'.setValue',v,'got text ',text,' from record ',record);
        } else {
          // if(this.mode == 'remote' && !Ext.isDefined(this.store.totalLength)){
          if(this.mode == 'remote' && ( this.lastQuery === null || (!Ext.isDefined(this.store.totalLength)))){
              //~ if (this.name == 'birth_country') console.log(this.name,'.setValue',v,'store not yet loaded');
              this.store.on('load', this.setValue.createDelegate(this, arguments), null, {single: true});
              if(this.store.lastOptions === null || this.lastQuery === null){
                  var params;
                  if(this.valueParam){
                      params = {};
                      params[this.valueParam] = v;
                  }else{
                      var q = this.allQuery;
                      this.lastQuery = q;
                      this.store.setBaseParam(this.queryParam, q);
                      params = this.getParams(q);
                  }
                  //~ if (this.name == 'birth_country') 
                    //~ console.log(this.name,'.setValue',v,' : call load() with params ',params);
                  this.store.load({params: params});
              //~ }else{
                  //~ if (this.name == 'birth_country') 
                    //~ console.log(this.name,'.setValue',v,' : but store is loading',this.store.lastOptions);
              }
              return;
          //~ }else{
              //~ if (this.name == 'birth_country') 
                //~ console.log(this.name,'.setValue',v,' : store is loaded, lastQuery is "',this.lastQuery,'"');
          }
          var r = this.findRecord(this.valueField, v);
          if(r){
              text = r.data[this.displayField];
          }else if(this.valueNotFoundText !== undefined){
              text = this.valueNotFoundText;
          }
        }
      }
      this.lastSelectionText = text;
      //~ this.lastSelectionText = v;
      if(this.hiddenField){
          //~ this.hiddenField.originalValue = v;
          this.hiddenField.value = v;
      }
      Ext.form.ComboBox.superclass.setValue.call(this, text);
      this.value = v; // needed for grid.afteredit
  },
  
  getParams : function(q){
    // p = Ext.form.ComboBox.superclass.getParams.call(this, q);
    // causes "Ext.form.ComboBox.superclass.getParams is undefined"
    var p = {};
    //p[this.queryParam] = q;
    if(this.pageSize){
        //~ p.start = 0;
        //~ p.limit = this.pageSize;
        p['start'] = 0;
        p['limit'] = this.pageSize;
    }
    // now my code:
    if(this.contextParams) Ext.apply(p,this.contextParams);
    //~ if(this.contextParams && this.contextValues) {
      //~ for(i = 0; i <= this.contextParams.length; i++)
        //~ p[this.contextParams[i]] = this.contextValues[i];
    //~ }
    return p;
  },
  setContextValue : function(name,value) {
    //~ console.log('setContextValue',this,this.name,':',name,'=',value);
    //~ if (this.contextValues === undefined) {
        //~ this.contextValues = Array(); // this.contextParams.length);
    //~ }
    if (this.contextParams[name] != value) {
      //~ console.log('setContextValue 1',this.contextParams);
      this.contextParams[name] = value;
      this.lastQuery = null;
      //~ console.log('setContextValue 2',this.contextParams);
    }
  }
});

Lino.ChoicesFieldElement = Ext.extend(Lino.ComboBox,{
  mode: 'local'
});


Lino.SimpleRemoteComboStore = Ext.extend(Ext.data.JsonStore,{
  forceSelection: true,
  constructor: function(config){
      Lino.SimpleRemoteComboStore.superclass.constructor.call(this, Ext.apply(config, {
          totalProperty: 'count',
          root: 'rows',
          id: 'value', // ext_requests.CHOICES_VALUE_FIELD
          fields: ['value' ], // ext_requests.CHOICES_VALUE_FIELD, // ext_requests.CHOICES_TEXT_FIELD
          listeners: { exception: Lino.on_store_exception }
      }));
  }
});

Lino.ComplexRemoteComboStore = Ext.extend(Ext.data.JsonStore,{
  constructor: function(config){
      Lino.ComplexRemoteComboStore.superclass.constructor.call(this, Ext.apply(config, {
          totalProperty: 'count',
          root: 'rows',
          id: 'value', // ext_requests.CHOICES_VALUE_FIELD
          fields: ['value','text'], // ext_requests.CHOICES_VALUE_FIELD, // ext_requests.CHOICES_TEXT_FIELD
          listeners: { exception: Lino.on_store_exception }
      }));
  }
});

Lino.RemoteComboFieldElement = Ext.extend(Lino.ComboBox,{
  mode: 'remote',
  //~ forceSelection:false,
  minChars: 2, // default 4 is too much
  queryDelay: 300, // default 500 is maybe slow
  queryParam: 'query', 
  //~ typeAhead: true,
  //~ selectOnFocus: true, // select any existing text in the field immediately on focus.
  resizable: true
});

/*
Thanks to Animal for posting the basic idea:
http://www.sencha.com/forum/showthread.php?15842-2.0-SOLVED-Combobox-twintrigger-clear&p=76130&viewfull=1#post76130

*/
Lino.TwinCombo = Ext.extend(Lino.RemoteComboFieldElement,{
    trigger2Class : 'x-form-search-trigger',
    //~ trigger2Class : 'x-tbar-detail',
    initComponent : function() {
        //~ Lino.TwinCombo.superclass.initComponent.call(this);
        Lino.ComboBox.prototype.initComponent.call(this);
        Ext.form.TwinTriggerField.prototype.initComponent.call(this);
    },
    onTrigger2Click : function() {
        //~ console.log('onTrigger2Click',this,arguments);
    }
  });
//~ Lino.TwinCombo.prototype.initComponent = Ext.form.TwinTriggerField.prototype.initComponent;
Lino.TwinCombo.prototype.getTrigger = Ext.form.TwinTriggerField.prototype.getTrigger;
Lino.TwinCombo.prototype.getOuterSize = Ext.form.TwinTriggerField.prototype.getOuterSize;
Lino.TwinCombo.prototype.initTrigger = Ext.form.TwinTriggerField.prototype.initTrigger;
Lino.TwinCombo.prototype.onTrigger1Click = Ext.form.ComboBox.prototype.onTriggerClick;
//~ Lino.TwinCombo.prototype.onTrigger2Click = function() {
    //~ console.log('onTrigger2Click',arguments);
//~ };



Lino.SimpleRemoteComboFieldElement = Ext.extend(Lino.RemoteComboFieldElement,{
  displayField: 'value', 
  valueField: null,
  forceSelection: false
});




Lino.Window = Ext.extend(Ext.Window,{
  //~ layout: "fit", 
  closeAction : 'hide',
  renderTo: 'main_area', 
  constrain: true,
  maximized: true,
  draggable: false,
  width: 700,
  height: 500,
  maximizable: false,
  constructor : function (config) {
    if (config.main_item.params_panel) {
        config.layout = 'border';
        config.main_item.region = 'center';
        config.main_item.params_panel.region = 'north';
        config.main_item.params_panel.hidden = config.main_item.params_panel_hidden;
        config.items = [config.main_item.params_panel, config.main_item];
    } else {
        config.layout = 'fit';
        config.items = config.main_item;
    }
    this.main_item = config.main_item; 
    
    delete config.main_item;
    //~ delete config.params_item;
    
    //~ this.main_item = config.items.get(0);
    this.main_item.containing_window = this;
    
    //~ console.log('20120110 Lino.Window.constructor() 1');
    //~ if (Lino.current_window) { // all windows except the top are closable
    if (this.main_item.hide_window_title) { 
      config.closable = false;
      config.frame = false;
      config.shadow = false;
      //~ config.border = true;
      //~ config.title = undefined;
      //~ config.tools = null;
      delete config.title;
      delete config.tools;
    } else {
      config.title = this.main_item.empty_title;
      config.closable = true;
      config.tools = [ 
        { qtip: 'permalink', handler: Lino.permalink_handler(this), id: "pin" }
      ];
      if (this.main_item.content_type && this.main_item.action_name != 'insert') {
        config.tools = [ {
          handler: Lino.help_text_editor,
          qtip: "Hilfetexte der Eingabefelder dieser Tabelle bearbeiten",
          scope: this.main_item,
          id: "gear"
        }].concat(config.tools);
      }
        
    //~ { qtip: '', handler: Lino.save_wc_handler(this), id: "save" }, 
    //~ { qtip: this.config.qtip, handler: Lino.save_wc_handler(this), id: "save" }, 
    //~ { qtip: 'Call doLayout() on main Container.', handler: Lino.refresh_handler(this), id: "refresh" },
    //~ if (this.main_item.params_panel) {
        //~ config.tools = config.tools.concat([ 
          //~ { qtip: 'Show/hide parameter panel', handler: this.toggle_params_panel, id: "gear", scope:this } 
        //~ ]);
    //~ }
    //~ if (config.closable !== false) {
      // if undefined, will take default behaviour
      //~ config.tools = config.tools.concat([ 
        //~ { qtip: 'close', handler: this.hide, id: "close", scope:this } 
      //~ ]);
    }
    
    this.main_item.config_containing_window(config);
    
    //~ console.log('20120110 Lino.Window.constructor() 2');
    Lino.Window.superclass.constructor.call(this,config);
    
    //~ console.log('20120110 Lino.Window.constructor() 3');
    
  },
  initComponent : function() {
    this.main_item.init_containing_window(this);
    Lino.Window.superclass.initComponent.call(this);
  
  },
  hide : function() { 
      this.main_item.do_when_clean(false,function() { 
        Lino.close_window(); });
  },
  hide_really : function() { 
    Lino.Window.superclass.hide.call(this);
  },
  onRender : function(ct, position){
    //~ console.log('20120110 Lino.Window.onRender() 1');
    Lino.Window.superclass.onRender.call(this, ct, position);
    var main_area = Ext.getCmp('main_area')
    //~ console.log('20120110 Lino.Window.onRender() 2');
  
    this.on('show', function(win) {
        //~ console.log('20120110 Lino.Window.on show 1');
        main_area.on('resize', win.onWindowResize, win);
    });
    this.on('hide', function(win) {
        main_area.un('resize', win.onWindowResize, win);
    });
    //~ console.log('20120110 Lino.Window.onRender() 3');
  }
});


Lino.unused_ParamWindow = Ext.extend(Lino.Window,{
  //~ layout: "border", 
  constructor : function (config) {
    Lino.ParamWindow.superclass.constructor.call(this,config);
    this.main_item = config.items; // `items` must be a single component
    config.layout = 'border';
    this.main_item.region = 'center';
    config.params.region = 'north';
    config.items = [config.params, config.items];
    //~ delete config.params;
  }
});




(function(){
    var ns = Ext.ns('Ext.ux.plugins');

    /**
     * @class Ext.ux.plugins.DefaultButton
     * @extends Object
     *
     * Plugin for Button that will click() the button if the user presses ENTER while
     * a component in the button's form has focus.
     *
     * @author Stephen Friedrich
     * @date 09-DEC-2009
     * @version 0.1
     *
     */
    ns.DefaultButton =  Ext.extend(Object, {
        init: function(button) {
            button.on('afterRender', setupKeyListener, button);
        }
    });

    function setupKeyListener() {
        var formPanel = this.findParentByType('form');
        new Ext.KeyMap(formPanel.el, {
            key: Ext.EventObject.ENTER,
            shift: false,
            alt: false,
            fn: function(keyCode, e){
                if(e.target.type === 'textarea' && !e.ctrlKey) {
                    return true;
                }

                this.el.select('button').item(0).dom.click();
                return false;
            },
            scope: this
        });
    }

    Ext.ComponentMgr.registerPlugin('defaultButton', ns.DefaultButton);

})(); 

Ext.override(Ext.form.BasicForm,{
    my_loadRecord : function(values){
    //~ loadRecord : function(record){
        /* Same as ExtJS's loadRecord() (setValues()), except that we 
        forward also the record to field.setValue() so that Lino.Combobox 
        can use it. 
        */
        //~ console.log('20120918 my_loadRecord',values)
        if(Ext.isArray(values)){ 
            for(var i = 0, len = values.length; i < len; i++){
                var v = values[i];
                var f = this.findField(v.id);
                if(f){
                    f.setValue(v.value,values);
                    if(this.trackResetOnLoad){
                        f.originalValue = f.getValue();
                    }
                }
            }
        }else{ 
            var field, id;
            for(id in values){
                if(!Ext.isFunction(values[id]) && (field = this.findField(id))){
                    field.setValue(values[id],values);
                    if(this.trackResetOnLoad){
                        field.originalValue = field.getValue();
                        //~ if (field.hiddenField) {
                          //~ field.hiddenField.originalValue = field.hiddenField.value;
                        //~ }
                    }
                }
            }
        }
        return this;
    }
});




function initializeFooBarDropZone(cmp) {
    //~ console.log('initializeFooBarDropZone',cmp);
    cmp.dropTarget = new Ext.dd.DropTarget(cmp.bwrap, {
      //~ ddGroup     : 'gridDDGroup',
      notifyEnter : function(ddSource, e, data) {
        console.log('notifyEnter',ddSource,e,data);
        //Add some flare to invite drop.
        cmp.body.stopFx();
        cmp.body.highlight();
      },
      notifyDrop  : function(ddSource, e, data){
        console.log('notifyDrop',ddSource,e,data);
        // Reference the record (single selection) for readability
        //~ var selectedRecord = ddSource.dragData.selections[0];


        // Load the record into the form
        //~ formPanel.getForm().my_loadRecord(selectedRecord);


        // Delete record from the grid.  not really required.
        //~ ddSource.grid.store.remove(selectedRecord);

        return(true);
      }
    })
}



Lino.show_mti_child = function(fieldname,detail_handler) {
  //~ console.log('show_mti_child',this);
  //~ console.log('show_mti_child',panel.find("main_area"));
  rec = Lino.current_window.main_item.get_current_record();
  //~ rec = panel.get_current_record();
  if (rec) {
    //~ console.log('show_mti_child',Lino.current_window,rec);
    if (rec.phantom) {
      Lino.notify('Not allowed on phantom record.');
    }else if (rec.data[fieldname]) {
      //~ console.log('show_mti_child',rec.id);
      //~ detail_handler(Lino.current_window.main_item,{},{record_id:rec.id});
      detail_handler.run(null,{record_id:rec.id});
      //~ window.open(urlroot + '/' + rec.id);
      //~ document.location = urlroot + '/' + rec.id;
      //~ window.open(urlroot + '/' + rec.id,'_blank');
    } else {
      Lino.alert("Kann MTI-Kind nicht anzeigen wenn Checkbox abgeschlatet ist.");
    }
  } else {
    Lino.notify('No current record.');
  }
};






/*
Mappings towards lino.modlib.cal.models.PanelCalendars
*/
// Sset SS = Ssite.modules.cal.PanelCalendars.get_handle(Sui).store
Ext.ensible.cal.CalendarMappings = {
    CalendarId:   {name:'ID',       mapping: 'id', type: 'int'},
    Title:        {name:'CalTitle', mapping: 'babel_name', type: 'string'},
    Description:  {name:'Desc',     mapping: 'description', type: 'string'},
    ColorId:      {name:'Color',    mapping: 'color', type: 'int'},
    IsHidden:     {name:'Hidden',   mapping: 'is_hidden', type: 'boolean'},    
};
Ext.ensible.cal.CalendarRecord.reconfigure();  


/*
Mappings towards lino.modlib.cal.models.PanelEvents 
*/
// Sset SS = Ssite.modules.cal.PanelEvents.get_handle(Sui).store
Ext.ensible.cal.EventMappings = {
    EventId:     {name: 'ID',        mapping: 'id', type:'int'},
    CalendarId:  {name: 'CalID',     mapping: 'calendarHidden', type: 'int'},
    Title:       {name: 'EvtTitle',  mapping: 'summary'},
    StartDate:   {name: 'StartDt',   mapping: 'start_dt', 
      type: 'date', 
      dateFormat: "Y-m-d\TH:i:s" },
    EndDate:     {name: 'EndDt',     mapping: 'end_dt', 
      type: 'date', 
      dateFormat: "Y-m-d\TH:i:s"},
    RRule:       {name: 'RecurRule', mapping: 'rsetHidden'},
    Location:    {name: 'Location',  mapping: 'placeHidden'},
    Notes:       {name: 'Desc',      mapping: 'description'},
    Url:         {name: 'LinkUrl',   mapping: 'url'},
    IsAllDay:    {name: 'AllDay',    mapping: 'all_day', type: 'boolean'},
    Reminder:    {name: 'Reminder',  mapping: 'reminder'}
    
};
Ext.ensible.cal.EventRecord.reconfigure();


Lino.on_eventclick = function(cp,rec,el) {
  //~ console.log("Lino.on_eventclick",arguments);
  //~ Lino.cal.Events.detail_action.run({record_id:rec.data.ID});
  Lino.cal.PanelEvents.detail.run(null,{record_id:rec.data.ID,base_params:Lino.eventStore.baseParams});
  return false;
}
    
Lino.on_editdetails = function(cp,rec,el) {
  //~ console.log("Lino.on_editdetails",arguments);
  if (rec.data.ID)
      //~ Lino.cal.Events.detail_action.run({record_id:rec.data.ID});
      Lino.cal.PanelEvents.detail.run(null,{record_id:rec.data.ID,base_params:Lino.eventStore.baseParams});
  return false;
}

Lino.format_time = function(dt) {
    return dt.getHours() + ':' + dt.getMinutes();
}
    
Lino.on_eventdelete = function() {
  //~ console.log("Lino.on_eventdelete",arguments);
};

Lino.on_eventadd  = function(cp,rec,el) {
  //~ console.log("Lino.on_eventadd ",arguments);
  return false;
}
    
Lino.on_eventresize  = function(cp,rec,el) {
  //~ console.log("Lino.on_eventresize ",arguments);
  //~ Lino.cal.Events.insert(cp);
  //~ return false;
}
    
Lino.on_eventupdate  = function(cp,rec,el) {
  //~ console.log("Lino.on_eventupdate",arguments);
  //~ Lino.cal.Events.insert(cp);
  //~ return false;
}
    

//~ Lino.eventStore = new Ext.ensible.cal.EventStore({ 
//~ Lino.eventStore = new Ext.data.ArrayStore({ 
Lino.eventStore = new Ext.data.JsonStore({ 
  listeners: { exception: Lino.on_store_exception }
  ,url: '/restful/cal/PanelEvents'
  ,restful : true
  ,proxy: new Ext.data.HttpProxy({ 
      url: '/restful/cal/PanelEvents', 
      disableCaching: false // no need for cache busting when loading via Ajax
      //~ disableCaching:true,
  })
  ,fields: Ext.ensible.cal.EventRecord.prototype.fields.getRange()
  ,totalProperty: "count"
  ,root: "rows"
  ,idProperty: Ext.ensible.cal.EventMappings.EventId.mapping
  ,writer : new Ext.data.JsonWriter({
    writeAllFields: false
  })
  ,load: function(options) {
    //~ foo.bar = baz; // 20120213
      if (!options) options = {};
      if (!options.params) options.params = {};
      //~ options.params.$ext_requests.URL_PARAM_TEAM_VIEW = Lino.calendar_app.team_view_button.pressed;
      
      var view = this.cal_panel.getActiveView();
      var bounds = view.getViewBounds();
      //~ var p = {sd:'05.02.2012',ed:'11.02.2012'};
      //~ var p = {};
      options.params[view.dateParamStart] = bounds.start.format(view.dateParamFormat);
      options.params[view.dateParamEnd] = bounds.end.format(view.dateParamFormat);
      Lino.insert_subst_user(options.params);
      //~ Ext.apply(options.params,p)
      //~ console.log('20120710 eventStore.load()',this.baseParams,options);
    
    return Ext.data.JsonStore.prototype.load.call(this,options);
  }
});

//~ Lino.calendarStore = new Ext.data.ArrayStore({ 
Lino.calendarStore = new Ext.data.JsonStore({ 
      listeners: { exception: Lino.on_store_exception }
      ,restful : true
      ,proxy: new Ext.data.HttpProxy({ 
          url: '/restful/cal/PanelCalendars?fmt=json', 
          disableCaching: false // no need for cache busting when loading via Ajax
          //~ restful : true
          //~ method: "GET"
      })
      //~ ,autoLoad: true
      //~ ,remoteSort: true
      //~ ,baseParams: bp
      ,totalProperty: "count"
      ,root: "rows"
      ,fields: Ext.ensible.cal.CalendarRecord.prototype.fields.getRange()
      ,idProperty: Ext.ensible.cal.CalendarMappings.CalendarId.mapping
      //~ ,idIndex: Ext.ensible.cal.CalendarMappings.CalendarId.mapping
    });


Lino.CalendarCfg = {
    dateParamFormat: 'd.m.Y',
    dateParamStart:'sd',
    dateParamEnd:'ed'
};
//~ 20120704 Lino.CalendarPanel = Ext.extend(Ext.ensible.cal.CalendarPanel,Lino.MainPanel);
//~ Lino.CalendarPanel = Ext.extend(Lino.CalendarPanel,{
Ext.override(Ext.ensible.cal.CalendarPanel,Lino.MainPanel);
Ext.override(Ext.ensible.cal.CalendarPanel,{
  //~ empty_title : "\$ui.get_actor('cal.Panel').report.label",
  empty_title : "Kalender"
  ,activeItem: 1 // 0: day, 1: week
  ,ls_url: '/cal/CalendarPanel'
  //~ ,disableCaching:true
  ,eventStore: Lino.eventStore
  ,calendarStore: Lino.calendarStore
  ,listeners: { 
    editdetails: Lino.on_editdetails
    ,eventclick: Lino.on_eventclick
    //~ ,eventadd: Lino.on_eventadd
    //~ ,eventdelete: Lino.on_eventdelete
    //~ ,eventresize: Lino.on_eventresize
    ,afterrender : function(config) {
      //~ console.log("20120704 afterrender");
      Lino.calendarStore.load();
      //~ console.log("20120704 afterrender calls eventStore.load()",p);
      Lino.eventStore.cal_panel = this;
      //~ Lino.eventStore.load({params:p});
      Lino.eventStore.load();
      //~ Lino.CalendarPanel.superclass.constructor.call(this, config);
      //~ console.log(20120118, config,this);
    }
    }
  ,enableEditDetails: false
  //~ ,monthViewCfg: Lino.CalendarCfg
  //~ ,weekViewCfg: Lino.CalendarCfg
  //~ ,multiDayViewCfg: Lino.CalendarCfg
  //~ ,multiWeekViewCfg: Lino.CalendarCfg
  //~ ,dayViewCfg: Lino.CalendarCfg
  //~ ,initComponent : function() {
    //~ // this.on('eventadd',Lino.on_eventadd);
    //~ Lino.CalendarPanel.superclass.initComponent.call(this);
  //~ }
});




Lino.CalendarAppPanel = Ext.extend(Ext.Panel,Lino.MainPanel);
Lino.CalendarAppPanel = Ext.extend(Lino.CalendarAppPanel,{
  //~ empty_title : "\$ui.get_actor('cal.Panel').report.label",
  empty_title : "Kalender"
  ,ls_url: '/cal/CalendarPanel'
  ,set_status : function(status) { this.refresh();}
  ,refresh : function() {Lino.eventStore.reload();}
  ,layout: 'fit'
  ,is_loading : function() { 
      var loading = Lino.calendarStore.getCount() == 0 | Lino.eventStore.getCount() == 0
      //~ console.log("CalendarPanel loading:",loading);
      return loading; 
  }
  ,get_base_params : function() {
    var p = Ext.apply({},this.base_params);
    Lino.insert_subst_user(p);
    return p;
  }
  ,set_base_params : function(p) {
    this.base_params = Ext.apply({},p);
  }
  ,clear_base_params : function() {
      this.base_params = {};
      Lino.insert_subst_user(this.base_params);
  }
  ,set_base_param : function(k,v) {
      if (!this.base_params) this.base_params = {};
      this.base_params[k] = v;
  }
});

Lino.calendar_app = function() { return {
  get_main_panel : function() {
      return new Lino.CalendarAppPanel({ items : 
        //~ [{
          //~ id: 'app-header',
          //~ region: 'north',
          //~ height: 35,
          //~ border: false,
          // contentEl: 'app-header-content'
        //~ },
      {
          id: 'app-center',
          title: '...', // will be updated to the current view's date range
          region: 'center',
          layout: 'border',
          listeners: {
              'afterrender': function(){
                  Ext.getCmp('app-center').header.addClass('app-center-header');
              }
          },
          items: [{
              id:'app-west',
              region: 'west',
              width: 176,
              border: false,
              items: [{
                  xtype: 'datepicker',
                  id: 'app-nav-picker',
                  cls: 'ext-cal-nav-picker',
                  listeners: {
                      'select': {
                          fn: function(dp, dt){
                              Lino.calendarPanel.setStartDate(dt);
                          },
                          scope: this
                      }
                  }
              //~ },{ 
                //~ layout:'fit',
                //~ items: [
                  //~ new Ext.form.Checkbox({
                    //~ boxLabel:"$_('Team view')",
                    //~ hideLabel:true
                    //~ listeners: { click: }
                  //~ })
                //~ ]
              },{ 
                layout:'form',
                items: [
                  this.team_view_button = new Ext.Button({
                    text:"Team-Ansicht",
                    enableToggle:true,
                    pressed:false,
                    toggleHandler: function(btn,state) { 
                      //~ console.log('20120716 teamView.toggle()');
                      Lino.eventStore.setBaseParam('tv',state);
                      Lino.eventStore.load();
                      //~ Lino.eventStore.load({params:{$ext_requests.URL_PARAM_TEAM_VIEW:state}});
                      //~ console.log("team view",state);
                    }
                  })
                ]
              },{
                  xtype: 'extensible.calendarlist',
                  store: Lino.calendarStore,
                  border: false,
                  width: 175
              }]
          },{
              xtype: 'extensible.calendarpanel',
              eventStore: Lino.eventStore,
              calendarStore: Lino.calendarStore,
              border: false,
              id:'app-calendar',
              region: 'center',
              //~ activeItem: 3, // month view
              
              // Any generic view options that should be applied to all sub views:
              viewConfig: {
                  // Lino.CalendarCfg
                  dateParamFormat: 'd.m.Y',
                  dateParamStart:'sd',
                  dateParamEnd:'ed',
                
                  //enableFx: false,
                  //ddIncrement: 10, //only applies to DayView and subclasses, but convenient to put it here
                  viewStartHour: 8,
                  viewEndHour: 18
                  //minEventDisplayMinutes: 15
              },
              
              // View options specific to a certain view (if the same options exist in viewConfig
              // they will be overridden by the view-specific config):
              monthViewCfg: {
                  showHeader: true,
                  showWeekLinks: true,
                  showWeekNumbers: true,
                  eventBodyMarkup: ['{Title}',
                    //~ '<tpl if="url">',
                        //~ '<a href="{url}">XX</a>',
                    //~ '</tpl>',
                    '<tpl if="_isReminder">',
                        '<i class="ext-cal-ic ext-cal-ic-rem">&#160;</i>',
                    '</tpl>',
                    '<tpl if="_isRecurring">',
                        '<i class="ext-cal-ic ext-cal-ic-rcr">&#160;</i>',
                    '</tpl>',
                    '<tpl if="spanLeft">',
                        '<i class="ext-cal-spl">&#160;</i>',
                    '</tpl>',
                    '<tpl if="spanRight">',
                        '<i class="ext-cal-spr">&#160;</i>',
                    '</tpl>'
                ].join('')
              },
              
              multiWeekViewCfg: {
                  //weekCount: 3
              },
              
              // Some optional CalendarPanel configs to experiment with:
              //readOnly: true,
              //showDayView: false,
              //showMultiDayView: true,
              //showWeekView: false,
              //showMultiWeekView: false,
              //showMonthView: false,
              //showNavBar: false,
              //showTodayText: false,
              //showTime: false,
              //editModal: true,
              //enableEditDetails: false,
              //title: 'My Calendar', // the header of the calendar, could be a subtitle for the app
              
              // Once this component inits it will set a reference to itself as an application
              // member property for easy reference in other functions within App.
              initComponent: function() {
                  Lino.calendarPanel = this;
                  this.constructor.prototype.initComponent.apply(this, arguments);
              },
              
              listeners: {
                  //~ 'eventclick': {
                      //~ fn: function(vw, rec, el){
                          //~ this.clearMsg();
                      //~ },
                      //~ scope: this
                  //~ },
                  'eventover': function(vw, rec, el){
                      //console.log('Entered evt rec='+rec.data[Ext.ensible.cal.EventMappings.Title.name]', view='+ vw.id +', el='+el.id);
                  },
                  'eventout': function(vw, rec, el){
                      //console.log('Leaving evt rec='+rec.data[Ext.ensible.cal.EventMappings.Title.name]+', view='+ vw.id +', el='+el.id);
                  },
                  'eventadd': {
                      fn: function(cp, rec){
                          this.showMsg('Event '+ rec.data[Ext.ensible.cal.EventMappings.Title.name] +' was added');
                      },
                      scope: this
                  },
                  'eventupdate': {
                      fn: function(cp, rec){
                          this.showMsg('Event '+ rec.data[Ext.ensible.cal.EventMappings.Title.name] +' was updated');
                      },
                      scope: this
                  },
                  'eventdelete': {
                      fn: function(cp, rec){
                          //this.eventStore.remove(rec);
                          this.showMsg('Event '+ rec.data[Ext.ensible.cal.EventMappings.Title.name] +' was deleted');
                      },
                      scope: this
                  },
                  'eventcancel': {
                      fn: function(cp, rec){
                          // edit canceled
                      },
                      scope: this
                  },
                  'viewchange': {
                      fn: function(p, vw, dateInfo){
                          if(this.editWin){
                              this.editWin.hide();
                          };
                          if(dateInfo !== null){
                              // will be null when switching to the event edit form so ignore
                              Ext.getCmp('app-nav-picker').setValue(dateInfo.activeDate);
                              this.updateTitle(dateInfo.viewStart, dateInfo.viewEnd);
                          }
                      },
                      scope: this
                  },
                  'dayclick': {
                      fn: function(vw, dt, ad, el){
                          this.clearMsg();
                      },
                      scope: this
                  },
                  'rangeselect': {
                      fn: function(vw, dates, onComplete){
                          this.clearMsg();
                      },
                      scope: this
                  },
                  'eventmove': {
                      fn: function(vw, rec){
                          rec.commit();
                          var time = rec.data[Ext.ensible.cal.EventMappings.IsAllDay.name] ? '' : ' \\a\\t g:i a';
                          this.showMsg('Event '+ rec.data[Ext.ensible.cal.EventMappings.Title.name] +' was moved to '+
                              rec.data[Ext.ensible.cal.EventMappings.StartDate.name].format('F jS'+time));
                      },
                      scope: this
                  },
                  'eventresize': {
                      fn: function(vw, rec){
                          rec.commit();
                          this.showMsg('Event '+ rec.data[Ext.ensible.cal.EventMappings.Title.name] +' was updated');
                      },
                      scope: this
                  },
                  'eventdelete': {
                      fn: function(win, rec){
                          Lino.eventStore.remove(rec);
                          this.showMsg('Event '+ rec.data[Ext.ensible.cal.EventMappings.Title.name] +' was deleted');
                      },
                      scope: this
                  },
                  'initdrag': {
                      fn: function(vw){
                          if(this.editWin && this.editWin.isVisible()){
                              this.editWin.hide();
                          }
                      },
                      scope: this
                  }
              }
          }]
        }
        //~ ]
        
      });
      
  }
  ,updateTitle: function(startDt, endDt){
      var p = Ext.getCmp('app-center');
      
      if(startDt.clearTime().getTime() == endDt.clearTime().getTime()){
          p.setTitle(startDt.format('F j, Y'));
      }
      else if(startDt.getFullYear() == endDt.getFullYear()){
          if(startDt.getMonth() == endDt.getMonth()){
              p.setTitle(startDt.format('F j') + ' - ' + endDt.format('j, Y'));
          }
          else{
              p.setTitle(startDt.format('F j') + ' - ' + endDt.format('F j, Y'));
          }
      }
      else{
          p.setTitle(startDt.format('F j, Y') + ' - ' + endDt.format('F j, Y'));
      }
  }
  // This is an application-specific way to communicate CalendarPanel event messages back to the user.
  // This could be replaced with a function to do "toast" style messages, growl messages, etc. This will
  // vary based on application requirements, which is why it's not baked into the CalendarPanel.
  ,showMsg: function(msg){
      Lino.notify(msg);
      //~ Ext.fly('app-msg').update(msg).removeClass('x-hidden');
  }
  
  ,clearMsg: function(){
      Lino.notify('');
      //~ Ext.fly('app-msg').update('').addClass('x-hidden');
  }
}
}();




/*
captureEvents utility by Aaron Conran
<http://www.sencha.com/learn/grid-faq/>

Ext.onReady(function(){
    var grid = new Ext.grid.GridPanel({
        ... 
    });
    captureEvents(grid);
});
*/
function captureEvents(observable) {
    Ext.util.Observable.capture(
        observable,
        function(eventName) {
            console.info(eventName);
        },
        this
    );		
}
 






Lino.main_menu = [ { "menu": { "items": [ { "text": "Personen", "handler": function() {Lino.contacts.Persons.grid.run(null)} }, { "text": " \u25b6 Klienten", "handler": function() {Lino.pcsw.Clients.grid.run(null)} }, { "text": "Organisationen", "handler": function() {Lino.contacts.Companies.grid.run(null)} }, { "text": "Haushalte", "handler": function() {Lino.households.Households.grid.run(null)} }, "-", { "text": "Partner (alle)", "handler": function() {Lino.contacts.Partners.grid.run(null)} } ] }, "text": "Kontakte" }, { "menu": { "items": [ { "text": "Mein E-Mail-Ausgang", "handler": function() {Lino.outbox.MyOutbox.grid.run(null)} }, { "menu": { "items": [ { "text": "Meine Postsendungen", "handler": function() {Lino.postings.MyPostings.grid.run(null)} }, { "text": "Bereit f\u00fcr Ausdruck", "handler": function() {Lino.postings.PostingsReady.grid.run(null)} }, { "text": "Gedruckte Postsendungen", "handler": function() {Lino.postings.PostingsPrinted.grid.run(null)} }, { "text": "Ausgegangene Postsendungen", "handler": function() {Lino.postings.PostingsSent.grid.run(null)} } ] }, "text": "Postsendungen" }, { "text": "Meine Notizen", "handler": function() {Lino.notes.MyNotes.grid.run(null)} } ] }, "text": "Office" }, { "menu": { "items": [ { "text": "Kalender", "iconCls": "x-tbar-calendar", "handler": function() {Lino.cal.CalendarPanel.grid.run(null)} }, { "text": "Termine", "listeners": { "render": Lino.quicktip_renderer("Foo","Alle meine Termine") }, "handler": function() {Lino.cal.MyEvents.grid.run(null)} }, "-", { "text": "Meine Aufgaben", "listeners": { "render": Lino.quicktip_renderer("Foo","Alle meine Aufgaben") }, "handler": function() {Lino.cal.MyTasks.grid.run(null)} }, { "text": "To-Do-Liste", "listeners": { "render": Lino.quicktip_renderer("Foo","Meine zu erledigenden Aufgaben.") }, "handler": function() {Lino.cal.MyTasksToDo.grid.run(null)} }, "-", { "text": "Meine Anwesenheiten", "listeners": { "render": Lino.quicktip_renderer("Foo","Shows all my presences in calendar events, independently of their state.") }, "handler": function() {Lino.cal.MyPresences.grid.run(null)} }, { "text": "Meine erhaltenen Einladungen", "listeners": { "render": Lino.quicktip_renderer("Foo","Shows received invitations which I must accept or reject.") }, "handler": function() {Lino.cal.MyPendingInvitations.grid.run(null)} } ] }, "text": "Kalender" }, { "menu": { "items": [ { "text": "Klienten", "listeners": { "render": Lino.quicktip_renderer("Foo","Wie Kontakte \u25b8 Klienten, aber mit Kolonnen und Filterparametern f\u00fcr Schuldnerberatung.") }, "handler": function() {Lino.pcsw.DebtsClients.grid.run(null)} }, { "text": "Meine Budgets", "handler": function() {Lino.debts.MyBudgets.grid.run(null)} } ] }, "text": "Schuldnerberatung" }, { "menu": { "items": [ { "menu": { "items": [ { "text": "Meine Einf\u00fcgetexte", "handler": function() {Lino.ui.MyTextFieldTemplates.grid.run(null)} }, { "text": "Upload-Arten", "handler": function() {Lino.uploads.UploadTypes.grid.run(null)} }, { "text": "Notizarten", "handler": function() {Lino.notes.NoteTypes.grid.run(null)} }, { "text": "Ereignisarten", "handler": function() {Lino.notes.EventTypes.grid.run(null)} } ] }, "text": "Office" }, { "menu": { "items": [ { "text": "Site-Parameter", "handler": function() {Lino.ui.SiteConfigs.detail.run(null,{ "record_id": 1 })} }, { "text": "Inhaltstypen", "handler": function() {Lino.ui.ContentTypes.grid.run(null)} }, { "text": "Hilfetexte", "handler": function() {Lino.ui.HelpTexts.grid.run(null)} } ] }, "text": "System" }, { "menu": { "items": [ { "text": "L\u00e4nder", "listeners": { "render": Lino.quicktip_renderer("Foo","\n    A country is a geographic entity considered a \"nation\".\n    ") }, "handler": function() {Lino.countries.Countries.grid.run(null)} }, { "text": "Sprachen", "handler": function() {Lino.countries.Languages.grid.run(null)} } ] }, "text": "Kontakte" }, { "menu": { "items": [ { "text": "Orte", "listeners": { "render": Lino.quicktip_renderer("Foo","List of places where calendar events can happen.") }, "handler": function() {Lino.cal.Places.grid.run(null)} }, { "text": "Priorit\u00e4ten", "listeners": { "render": Lino.quicktip_renderer("Foo","List of possible priorities of calendar events.") }, "handler": function() {Lino.cal.Priorities.grid.run(null)} }, { "text": "Gastrollen", "listeners": { "render": Lino.quicktip_renderer("Foo","The role of a guest expresses what the \n    partner is going to do there.") }, "handler": function() {Lino.cal.GuestRoles.grid.run(null)} } ] }, "text": "Kalender" }, { "menu": { "items": [ { "text": "Rollen in Haushalt", "handler": function() {Lino.households.Roles.grid.run(null)} }, { "text": "Haushaltsarten", "handler": function() {Lino.households.Types.grid.run(null)} } ] }, "text": "Haushalte" }, { "menu": { "items": [ { "text": "Kontenpl\u00e4ne", "handler": function() {Lino.accounts.Charts.grid.run(null)} }, { "text": "Kontengruppen", "handler": function() {Lino.accounts.Groups.grid.run(null)} }, { "text": "Konten", "handler": function() {Lino.accounts.Accounts.grid.run(null)} } ] }, "text": "Buchhaltung" }, { "menu": { "items": [ { "text": "Klientenkontaktarten", "listeners": { "render": Lino.quicktip_renderer("Foo","Liste der Arten von Klientenkontakten.") }, "handler": function() {Lino.pcsw.ClientContactTypes.grid.run(null)} } ] }, "text": "\u00d6SHZ" }, { "menu": { "items": [ { "text": "Kursinhalte", "handler": function() {Lino.courses.CourseContents.grid.run(null)} } ] }, "text": "Kurse" }, { "menu": { "items": [ { "text": "Budget-Kopiervorlage", "handler": function() {Lino.debts.Budgets.detail.run(null,{ "record_id": 1 })} } ] }, "text": "Schuldnerberatung" } ] }, "text": "Konfigurierung" }, { "menu": { "items": [ { "menu": { "items": [ { "text": "Einf\u00fcgetexte", "handler": function() {Lino.ui.TextFieldTemplates.grid.run(null)} }, { "text": "Uploads", "handler": function() {Lino.uploads.Uploads.grid.run(null)} }, { "text": "Anh\u00e4nge", "handler": function() {Lino.outbox.Attachments.grid.run(null)} } ] }, "text": "Office" }, { "menu": { "items": [ { "text": "User Groups", "handler": function() {Lino.lino.UserGroups.grid.run(null)} }, { "text": "Benutzer-Levels", "handler": function() {Lino.lino.UserLevels.grid.run(null)} }, { "text": "Benutzerprofile", "handler": function() {Lino.lino.UserProfiles.grid.run(null)} }, { "text": "\u00c4nderungen", "handler": function() {Lino.changes.Changes.grid.run(null)} } ] }, "text": "System" }, { "menu": { "items": [ { "text": "Aufgaben", "listeners": { "render": Lino.quicktip_renderer("Foo","A calendar task is something you need to do.\n    ") }, "handler": function() {Lino.cal.Tasks.grid.run(null)} }, { "text": "G\u00e4ste", "listeners": { "render": Lino.quicktip_renderer("Foo","A guest is a partner invited to an event.\n    ") }, "handler": function() {Lino.cal.Guests.grid.run(null)} }, { "text": "Zust\u00e4nde", "listeners": { "render": Lino.quicktip_renderer("Foo","List of the possible states of a calendar event.") }, "handler": function() {Lino.cal.EventStates.grid.run(null)} }, { "text": "Zust\u00e4nde", "handler": function() {Lino.cal.GuestStates.grid.run(null)} }, { "text": "Zust\u00e4nde", "handler": function() {Lino.cal.TaskStates.grid.run(null)} } ] }, "text": "Kalender" }, { "menu": { "items": [ { "text": "Mitglieder", "handler": function() {Lino.households.Members.grid.run(null)} } ] }, "text": "Haushalte" }, { "menu": { "items": [ { "text": "AccountTypes", "handler": function() {Lino.accounts.AccountTypes.grid.run(null)} } ] }, "text": "Buchhaltung" }, { "menu": { "items": [ { "text": "Begleitungen", "listeners": { "render": Lino.quicktip_renderer("Foo","Liste der Begleitungen") }, "handler": function() {Lino.pcsw.Coachings.grid.run(null)} }, { "text": "Klientenkontakte", "listeners": { "render": Lino.quicktip_renderer("Foo","Liste der Klientenkontakte") }, "handler": function() {Lino.pcsw.ClientContacts.grid.run(null)} }, { "text": "Zivilst\u00e4nde", "handler": function() {Lino.pcsw.CivilState.grid.run(null)} }, { "text": "Bearbeitungszust\u00e4nde Klienten", "handler": function() {Lino.pcsw.ClientStates.grid.run(null)} }, { "text": "eID-Kartenarten", "handler": function() {Lino.pcsw.BeIdCardTypes.grid.run(null)} } ] }, "text": "\u00d6SHZ" }, { "menu": { "items": [ { "text": "Kurse", "handler": function() {Lino.courses.Courses.grid.run(null)} } ] }, "text": "Kurse" }, { "menu": { "items": [ { "text": "Budgets", "handler": function() {Lino.debts.Budgets.grid.run(null)} } ] }, "text": "Schuldnerberatung" }, { "text": "Ereignisse/Notizen", "handler": function() {Lino.notes.Notes.grid.run(null)} } ] }, "text": "Explorer" }, { "menu": { "items": [ { "text": "Info", "listeners": { "render": Lino.quicktip_renderer("Foo","Zeigt Informationen \u00fcber diese Site an.") }, "handler": function() {Lino.about.About.show.run(null,{ "record_id": -99998 })} } ] }, "text": "Site" }, { "text": "Startseite", "handler": function() {Lino.close_all_windows()} } ];
Ext.namespace('Lino.ui.SiteConfigs')
Ext.namespace('Lino.ui.ContentTypes')
Ext.namespace('Lino.ui.HelpTexts')
Ext.namespace('Lino.ui.TextFieldTemplates')
Ext.namespace('Lino.users.Users')
Ext.namespace('Lino.users.MySettings')
Ext.namespace('Lino.users.UsersOverview')
Ext.namespace('Lino.users.Teams')
Ext.namespace('Lino.users.Memberships')
Ext.namespace('Lino.users.Authorities')
Ext.namespace('Lino.changes.Changes')
Ext.namespace('Lino.countries.Languages')
Ext.namespace('Lino.countries.Countries')
Ext.namespace('Lino.countries.Cities')
Ext.namespace('Lino.properties.PropGroups')
Ext.namespace('Lino.properties.PropTypes')
Ext.namespace('Lino.properties.Properties')
Ext.namespace('Lino.properties.PropChoices')
Ext.namespace('Lino.contacts.CompanyTypes')
Ext.namespace('Lino.contacts.Partners')
Ext.namespace('Lino.contacts.Companies')
Ext.namespace('Lino.contacts.RoleTypes')
Ext.namespace('Lino.contacts.Roles')
Ext.namespace('Lino.postings.Postings')
Ext.namespace('Lino.postings.PostingsByState')
Ext.namespace('Lino.postings.PostingsReady')
Ext.namespace('Lino.postings.PostingsPrinted')
Ext.namespace('Lino.postings.PostingsSent')
Ext.namespace('Lino.outbox.Recipients')
Ext.namespace('Lino.outbox.Mails')
Ext.namespace('Lino.outbox.Attachments')
Ext.namespace('Lino.cal.Calendars')
Ext.namespace('Lino.cal.Subscriptions')
Ext.namespace('Lino.cal.Places')
Ext.namespace('Lino.cal.Priorities')
Ext.namespace('Lino.cal.Events')
Ext.namespace('Lino.cal.MyEvents')
Ext.namespace('Lino.cal.MyUnclearEvents')
Ext.namespace('Lino.cal.EventsAssignedToMe')
Ext.namespace('Lino.cal.MyEventsToday')
Ext.namespace('Lino.cal.Tasks')
Ext.namespace('Lino.cal.GuestRoles')
Ext.namespace('Lino.cal.Guests')
Ext.namespace('Lino.cal.PanelCalendars')
Ext.namespace('Lino.cal.PanelEvents')
Ext.namespace('Lino.uploads.UploadTypes')
Ext.namespace('Lino.uploads.Uploads')
Ext.namespace('Lino.households.Types')
Ext.namespace('Lino.households.Households')
Ext.namespace('Lino.households.Roles')
Ext.namespace('Lino.households.Members')
Ext.namespace('Lino.accounts.Charts')
Ext.namespace('Lino.accounts.Groups')
Ext.namespace('Lino.accounts.Accounts')
Ext.namespace('Lino.notes.NoteTypes')
Ext.namespace('Lino.notes.EventTypes')
Ext.namespace('Lino.notes.Notes')
Ext.namespace('Lino.cv.LanguageKnowledges')
Ext.namespace('Lino.cv.PersonProperties')
Ext.namespace('Lino.contacts.Persons')
Ext.namespace('Lino.pcsw.Clients')
Ext.namespace('Lino.pcsw.DebtsClients')
Ext.namespace('Lino.pcsw.IntegClients')
Ext.namespace('Lino.pcsw.ClientsTest')
Ext.namespace('Lino.pcsw.PersonGroups')
Ext.namespace('Lino.pcsw.Activities')
Ext.namespace('Lino.pcsw.ExclusionTypes')
Ext.namespace('Lino.pcsw.Exclusions')
Ext.namespace('Lino.pcsw.AidTypes')
Ext.namespace('Lino.pcsw.OverlappingContracts')
Ext.namespace('Lino.pcsw.ClientContactTypes')
Ext.namespace('Lino.pcsw.ClientContacts')
Ext.namespace('Lino.pcsw.CoachingTypes')
Ext.namespace('Lino.pcsw.Coachings')
Ext.namespace('Lino.isip.ContractTypes')
Ext.namespace('Lino.isip.ExamPolicies')
Ext.namespace('Lino.isip.ContractEndings')
Ext.namespace('Lino.isip.Contracts')
Ext.namespace('Lino.isip.MyContracts')
Ext.namespace('Lino.jobs.Schedules')
Ext.namespace('Lino.jobs.Regimes')
Ext.namespace('Lino.jobs.JobProviders')
Ext.namespace('Lino.jobs.ContractTypes')
Ext.namespace('Lino.jobs.Sectors')
Ext.namespace('Lino.jobs.Functions')
Ext.namespace('Lino.jobs.Contracts')
Ext.namespace('Lino.jobs.MyContracts')
Ext.namespace('Lino.jobs.Offers')
Ext.namespace('Lino.jobs.StudyTypes')
Ext.namespace('Lino.jobs.Studies')
Ext.namespace('Lino.jobs.Experiences')
Ext.namespace('Lino.jobs.Candidatures')
Ext.namespace('Lino.jobs.Jobs')
Ext.namespace('Lino.jobs.JobTypes')
Ext.namespace('Lino.jobs.ContractsSearch')
Ext.namespace('Lino.courses.CourseProviders')
Ext.namespace('Lino.courses.CourseContents')
Ext.namespace('Lino.courses.Courses')
Ext.namespace('Lino.courses.CourseOffers')
Ext.namespace('Lino.courses.CourseRequests')
Ext.namespace('Lino.courses.PendingCourseRequests')
Ext.namespace('Lino.newcomers.Brokers')
Ext.namespace('Lino.newcomers.Faculties')
Ext.namespace('Lino.newcomers.Competences')
Ext.namespace('Lino.newcomers.NewClients')
Ext.namespace('Lino.newcomers.AvailableCoaches')
Ext.namespace('Lino.debts.Budgets')
Ext.namespace('Lino.debts.Actors')
Ext.namespace('Lino.debts.Entries')
Ext.namespace('Lino.debts.EntriesByType')
Ext.namespace('Lino.cbss.Sectors')
Ext.namespace('Lino.cbss.Purposes')
Ext.namespace('Lino.cbss.IdentifyPersonRequests')
Ext.namespace('Lino.cbss.ManageAccessRequests')
Ext.namespace('Lino.cbss.RetrieveTIGroupsRequests')
Ext.namespace('Lino.sessions.SessionTable')
Ext.namespace('Lino.ui.MyTextFieldTemplates')
Ext.namespace('Lino.users.MembershipsByUser')
Ext.namespace('Lino.users.AuthoritiesGiven')
Ext.namespace('Lino.users.AuthoritiesTaken')
Ext.namespace('Lino.countries.CitiesByCity')
Ext.namespace('Lino.countries.CitiesByCountry')
Ext.namespace('Lino.properties.PropsByGroup')
Ext.namespace('Lino.properties.PropsByType')
Ext.namespace('Lino.properties.ChoicesByType')
Ext.namespace('Lino.contacts.PartnersByCity')
Ext.namespace('Lino.contacts.PartnersByCountry')
Ext.namespace('Lino.contacts.RolesByCompany')
Ext.namespace('Lino.contacts.RolesByPerson')
Ext.namespace('Lino.postings.MyPostings')
Ext.namespace('Lino.postings.PostingsByPartner')
Ext.namespace('Lino.postings.PostingsByProject')
Ext.namespace('Lino.outbox.RecipientsByMail')
Ext.namespace('Lino.outbox.MyOutbox')
Ext.namespace('Lino.outbox.MailsByUser')
Ext.namespace('Lino.outbox.MailsByProject')
Ext.namespace('Lino.outbox.SentByPartner')
Ext.namespace('Lino.outbox.AttachmentsByMail')
Ext.namespace('Lino.cal.SubscriptionsByCalendar')
Ext.namespace('Lino.cal.SubscriptionsByUser')
Ext.namespace('Lino.cal.EventsByCalendar')
Ext.namespace('Lino.cal.EventsByPlace')
Ext.namespace('Lino.cal.EventsByProject')
Ext.namespace('Lino.cal.TasksByUser')
Ext.namespace('Lino.cal.MyTasks')
Ext.namespace('Lino.cal.MyTasksToDo')
Ext.namespace('Lino.cal.TasksByProject')
Ext.namespace('Lino.cal.GuestsByEvent')
Ext.namespace('Lino.cal.GuestsByRole')
Ext.namespace('Lino.cal.GuestsByPartner')
Ext.namespace('Lino.cal.MyPresences')
Ext.namespace('Lino.cal.MyPendingInvitations')
Ext.namespace('Lino.uploads.MyUploads')
Ext.namespace('Lino.households.HouseholdsByType')
Ext.namespace('Lino.households.MembersByHousehold')
Ext.namespace('Lino.households.MembersByPerson')
Ext.namespace('Lino.households.MembersByRole')
Ext.namespace('Lino.accounts.GroupsByChart')
Ext.namespace('Lino.accounts.AccountsByGroup')
Ext.namespace('Lino.notes.MyNotes')
Ext.namespace('Lino.notes.NotesByType')
Ext.namespace('Lino.notes.NotesByEventType')
Ext.namespace('Lino.notes.NotesByProject')
Ext.namespace('Lino.cv.LanguageKnowledgesByPerson')
Ext.namespace('Lino.cv.KnowledgesByLanguage')
Ext.namespace('Lino.cv.PropsByPerson')
Ext.namespace('Lino.cv.PersonPropsByProp')
Ext.namespace('Lino.cv.ConfiguredPropsByPerson')
Ext.namespace('Lino.cv.SkillsByPerson')
Ext.namespace('Lino.cv.SoftSkillsByPerson')
Ext.namespace('Lino.cv.ObstaclesByPerson')
Ext.namespace('Lino.pcsw.ClientsByNationality')
Ext.namespace('Lino.pcsw.ExclusionsByPerson')
Ext.namespace('Lino.pcsw.ContactsByClient')
Ext.namespace('Lino.pcsw.CoachingsByClient')
Ext.namespace('Lino.pcsw.CoachingsByUser')
Ext.namespace('Lino.pcsw.NotesByPerson')
Ext.namespace('Lino.pcsw.NotesByCompany')
Ext.namespace('Lino.isip.ContractsByPerson')
Ext.namespace('Lino.isip.ContractsByPolicy')
Ext.namespace('Lino.isip.ContractsByType')
Ext.namespace('Lino.jobs.FunctionsBySector')
Ext.namespace('Lino.jobs.ContractsByPerson')
Ext.namespace('Lino.jobs.ContractsByProvider')
Ext.namespace('Lino.jobs.ContractsByPolicy')
Ext.namespace('Lino.jobs.ContractsByJob')
Ext.namespace('Lino.jobs.ContractsByRegime')
Ext.namespace('Lino.jobs.ContractsBySchedule')
Ext.namespace('Lino.jobs.StudiesByCountry')
Ext.namespace('Lino.jobs.StudiesByCity')
Ext.namespace('Lino.jobs.StudiesByPerson')
Ext.namespace('Lino.jobs.ExperiencesByFunction')
Ext.namespace('Lino.jobs.ExperiencesByPerson')
Ext.namespace('Lino.jobs.CandidaturesByPerson')
Ext.namespace('Lino.jobs.CandidaturesBySector')
Ext.namespace('Lino.jobs.CandidaturesByFunction')
Ext.namespace('Lino.jobs.CandidaturesByJob')
Ext.namespace('Lino.jobs.CandidaturesByOffer')
Ext.namespace('Lino.jobs.ExperiencesByOffer')
Ext.namespace('Lino.jobs.JobsByProvider')
Ext.namespace('Lino.jobs.JobsByType')
Ext.namespace('Lino.jobs.ContractsByType')
Ext.namespace('Lino.jobs.JobsOverviewByType')
Ext.namespace('Lino.courses.CoursesByOffer')
Ext.namespace('Lino.courses.CourseOffersByProvider')
Ext.namespace('Lino.courses.CourseOffersByContent')
Ext.namespace('Lino.courses.CourseRequestsByPerson')
Ext.namespace('Lino.courses.CourseRequestsByContent')
Ext.namespace('Lino.courses.RequestsByCourse')
Ext.namespace('Lino.courses.ParticipantsByCourse')
Ext.namespace('Lino.courses.CandidatesByCourse')
Ext.namespace('Lino.newcomers.CompetencesByUser')
Ext.namespace('Lino.newcomers.CompetencesByFaculty')
Ext.namespace('Lino.newcomers.MyCompetences')
Ext.namespace('Lino.newcomers.ClientsByFaculty')
Ext.namespace('Lino.newcomers.AvailableCoachesByClient')
Ext.namespace('Lino.debts.MyBudgets')
Ext.namespace('Lino.debts.BudgetsByPartner')
Ext.namespace('Lino.debts.ActorsByBudget')
Ext.namespace('Lino.debts.ActorsByPartner')
Ext.namespace('Lino.debts.EntriesByBudget')
Ext.namespace('Lino.debts.ExpensesByBudget')
Ext.namespace('Lino.debts.IncomesByBudget')
Ext.namespace('Lino.debts.LiabilitiesByBudget')
Ext.namespace('Lino.debts.AssetsByBudget')
Ext.namespace('Lino.debts.DistByBudget')
Ext.namespace('Lino.cbss.MyIdentifyPersonRequests')
Ext.namespace('Lino.cbss.IdentifyRequestsByPerson')
Ext.namespace('Lino.cbss.ManageAccessRequestsByPerson')
Ext.namespace('Lino.cbss.MyManageAccessRequests')
Ext.namespace('Lino.cbss.RetrieveTIGroupsRequestsByPerson')
Ext.namespace('Lino.cbss.MyRetrieveTIGroupsRequests')
Ext.namespace('Lino.uploads.UploadsByController')
Ext.namespace('Lino.postings.PostingsByController')
Ext.namespace('Lino.cal.TasksByController')
Ext.namespace('Lino.outbox.MailsByController')
Ext.namespace('Lino.changes.ChangesByMaster')
Ext.namespace('Lino.ui.HelpTextsByModel')
Ext.namespace('Lino.outbox.AttachmentsByController')
Ext.namespace('Lino.cal.EventsByController')
Ext.namespace('Lino.about.Models')
Ext.namespace('Lino.about.FieldsByModel')
Ext.namespace('Lino.about.Inspector')
Ext.namespace('Lino.about.SourceFiles')
Ext.namespace('Lino.pcsw.UsersWithClients')
Ext.namespace('Lino.debts.PrintEntriesByBudget')
Ext.namespace('Lino.debts.PrintExpensesByBudget')
Ext.namespace('Lino.debts.PrintIncomesByBudget')
Ext.namespace('Lino.debts.PrintLiabilitiesByBudget')
Ext.namespace('Lino.debts.PrintAssetsByBudget')
Ext.namespace('Lino.debts.SummaryTable')
Ext.namespace('Lino.debts.ResultByBudget')
Ext.namespace('Lino.debts.DebtsByBudget')
Ext.namespace('Lino.debts.BailiffDebtsByBudget')
Ext.namespace('Lino.cbss.IdentifyPersonResult')
Ext.namespace('Lino.cbss.RetrieveTIGroupsResult')
Ext.namespace('Lino.ui.Home')
Ext.namespace('Lino.about.About')
Ext.namespace('Lino.cal.CalendarPanel')
Ext.namespace('Lino.lino.Home')
Ext.namespace('Lino.jobs.JobsOverview')
Ext.namespace('Lino.jobs.NewJobsOverview')
Ext.namespace('Lino.courses.CourseRequestStates')
Ext.namespace('Lino.postings.PostingStates')
Ext.namespace('Lino.cal.DurationUnits')
Ext.namespace('Lino.cal.TaskStates')
Ext.namespace('Lino.cal.Weekdays')
Ext.namespace('Lino.lino.UserLevels')
Ext.namespace('Lino.lino.UserProfiles')
Ext.namespace('Lino.cal.EventStates')
Ext.namespace('Lino.accounts.AccountTypes')
Ext.namespace('Lino.cv.CefLevel')
Ext.namespace('Lino.properties.HowWell')
Ext.namespace('Lino.jobs.CandidatureStates')
Ext.namespace('Lino.outbox.RecipientType')
Ext.namespace('Lino.countries.CityTypes')
Ext.namespace('Lino.pcsw.BeIdCardTypes')
Ext.namespace('Lino.pcsw.CivilState')
Ext.namespace('Lino.pcsw.ClientStates')
Ext.namespace('Lino.cal.GuestStates')
Ext.namespace('Lino.properties.DoYouLike')
Ext.namespace('Lino.cbss.RequestLanguages')
Ext.namespace('Lino.cbss.ManageAction')
Ext.namespace('Lino.pcsw.RefusalReasons')
Ext.namespace('Lino.lino.UserGroups')
Ext.namespace('Lino.cbss.RequestStates')
Ext.namespace('Lino.lino.ChangeTypes')
Ext.namespace('Lino.cal.AccessClasses')
Ext.namespace('Lino.cbss.QueryRegister')
Ext.namespace('Lino.lino.Genders')
Ext.namespace('Lino.pcsw.ResidenceType')

// ChoiceLists: 
Lino.courses.CourseRequestStates = [ [ "10", "Offen" ], [ "20", "Eingetragen" ], [ "30", "Bestanden" ], [ "40", "Gut bestanden" ], [ "50", "Nicht bestanden" ], [ "60", "Abgebrochen" ], [ "70", "Inaktiv" ] ];
Lino.postings.PostingStates = [ [ "10", "In Bearbeitung" ], [ "20", "Bereit f\u00fcr Ausdruck" ], [ "30", "Ausgedruckt" ], [ "40", "Versendet" ], [ "50", "Retour" ] ];
Lino.cal.DurationUnits = [ [ "s", "Sekunden" ], [ "m", "Minuten" ], [ "h", "Stunden" ], [ "D", "Tage" ], [ "W", "Wochen" ], [ "M", "Monate" ], [ "Y", "Jahre" ] ];
Lino.cal.TaskStates = [ [ "10", "Zu tun" ], [ "20", "Begonnen" ], [ "30", "Erledigt" ], [ "50", "Storniert" ] ];
Lino.cal.Weekdays = [ [ "1", "Montag" ], [ "2", "Dienstag" ], [ "3", "Mittwoch" ], [ "4", "Donnerstag" ], [ "5", "Freitag" ], [ "6", "Samstag" ], [ "7", "Sonntag" ] ];
Lino.lino.UserLevels = [ [ "10", "Gast" ], [ "20", "Sekret\u00e4r" ], [ "30", "Benutzer" ], [ "40", "Manager" ], [ "50", "Verwalter" ], [ "90", "Experte" ] ];
Lino.lino.UserProfiles = [ [ "000", "000 (Anonym)" ], [ "100", "100 (Begleiter im DSBE)" ], [ "110", "110 (Integrations-Assistent (Dienstleiter))" ], [ "200", "200 (Berater Neuantr\u00e4ge)" ], [ "300", "300 (Schuldenberater)" ], [ "500", "500 (nur ZDSS)" ], [ "900", "900 (Verwalter)" ] ];
Lino.cal.EventStates = [ [ "10", "Vorgeschlagen" ], [ "20", "Draft" ], [ "30", "Mitgeteilt" ], [ "40", "Geplant" ], [ "50", "Stattgefunden" ], [ "60", "Verschoben" ], [ "70", "Storniert" ], [ "80", "Abwesend" ] ];
Lino.accounts.AccountTypes = [ [ "A", "Verm\u00f6gen" ], [ "L", "Verpflichtungen" ], [ "I", "Eink\u00fcnfte" ], [ "E", "Ausgaben" ], [ "C", "Kapital" ], [ "B", "Bankkonten" ] ];
Lino.cv.CefLevel = [ [ "A1", "A1 (Elementare Sprachverwendung)" ], [ "A2", "A2 (Elementare Sprachverwendung)" ], [ "A2+", "A2+ (Elementare Sprachverwendung)" ], [ "B1", "B1 (Selbstst\u00e4ndige Sprachverwendung)" ], [ "B2", "B2 (Selbstst\u00e4ndige Sprachverwendung)" ], [ "B2+", "B2+ (Selbstst\u00e4ndige Sprachverwendung)" ], [ "C1", "C1 (Exzellente Sprachverwendung)" ], [ "C2", "C2 (Exzellente Sprachverwendung)" ], [ "C2+", "C2+ (Exzellente Sprachverwendung)" ] ];
Lino.properties.HowWell = [ [ "0", "gar nicht" ], [ "1", "ein bisschen" ], [ "2", "mittelm\u00e4\u00dfig" ], [ "3", "gut" ], [ "4", "sehr gut" ] ];
Lino.jobs.CandidatureStates = [ [ "10", "Aktiv" ], [ "20", "Probezeit" ], [ "25", "Probezeit ohne Erfolg" ], [ "27", "Arbeitet" ], [ "30", "Inaktiv" ] ];
Lino.outbox.RecipientType = [ [ "to", "Empf\u00e4nger" ], [ "cc", "Kopie an" ], [ "bcc", "Blindkopie an" ] ];
Lino.countries.CityTypes = [ [ "10", "Bundesland" ], [ "11", "Division" ], [ "12", "Region" ], [ "13", "Gemeinschaft" ], [ "14", "Territorium" ], [ "20", "Regierungsbezirk" ], [ "21", "Provinz" ], [ "22", "Grafschaft" ], [ "23", "Unterregion" ], [ "24", "Departement" ], [ "25", "Arrondissement" ], [ "26", "Pr\u00e4fektur" ], [ "27", "Distrikt" ], [ "28", "Sektor" ], [ "50", "Stadt" ], [ "51", "Kleinstadt" ], [ "52", "Gemeinde" ], [ "54", "Pfarre" ], [ "55", "Stadtteil" ], [ "56", "Viertel" ], [ "61", "Ortschaft" ], [ "62", "Kleine Ortschaft" ], [ "70", "Dorf" ] ];
Lino.pcsw.BeIdCardTypes = [ [ "1", "Belgischer Staatsb\u00fcrger" ], [ "6", "Kind unter 12 Jahren" ], [ "11", "A (Bescheinigung der Eintragung im Ausl\u00e4nderregister - Vor\u00fcbergehender Aufenthalt)" ], [ "12", "B (Bescheinigung der Eintragung im Ausl\u00e4nderregister)" ], [ "13", "C (Personalausweis f\u00fcr Ausl\u00e4nder)" ], [ "14", "D (Daueraufenthalt - EG)" ], [ "15", "E (Anmeldebescheinigung)" ], [ "16", "E+" ], [ "17", "F (Aufenthaltskarte f\u00fcr Familienangeh\u00f6rige eines Unionsb\u00fcrgers)" ], [ "18", "F+" ] ];
Lino.pcsw.CivilState = [ [ "10", "Ledig" ], [ "13", "Ledig zusammenwohnend" ], [ "18", "Ledig mit Kind" ], [ "20", "Verheiratet" ], [ "21", "Verheirated (allein lebend)" ], [ "22", "Verheirated (mit anderem Partner lebend)" ], [ "30", "Verwitwet" ], [ "33", "Verwitwet (zusammenwohnend)" ], [ "40", "Geschieden" ], [ "50", "Getrennt von Tisch und Bett" ] ];
Lino.pcsw.ClientStates = [ [ "10", "Neuantrag" ], [ "20", "Abgelehnt" ], [ "30", "Begleitet" ], [ "50", "Ehemalig" ] ];
Lino.cal.GuestStates = [ [ "10", "Eingeladen" ], [ "20", "Zugesagt" ], [ "30", "Abgesagt" ], [ "40", "Anwesend" ], [ "50", "Abwesend" ] ];
Lino.properties.DoYouLike = [ [ "0", "blo\u00df nicht" ], [ "1", "eher nicht" ], [ "2", "normal" ], [ "3", "gerne" ], [ "4", "sehr gerne" ] ];
Lino.cbss.RequestLanguages = [ [ "nl", "Niederl\u00e4ndisch" ], [ "fr", "Franz\u00f6sisch" ], [ "de", "Deutsch" ] ];
Lino.cbss.ManageAction = [ [ "1", "Registrieren" ], [ "2", "Austragen" ], [ "3", "Auflisten" ] ];
Lino.pcsw.RefusalReasons = [ [ "10", "Information (keine Begleitung erforderlich)" ], [ "20", "\u00d6SHZ ist nicht zust\u00e4ndig" ], [ "30", "Antragsteller ist nicht zur\u00fcck gekommen" ] ];
Lino.lino.UserGroups = [ [ "office", "office (Office)" ], [ "accounting", "accounting (Buchhaltung)" ], [ "integ", "integ (DSBE)" ], [ "newcomers", "newcomers (Neuantr\u00e4ge)" ], [ "debts", "debts (Schuldnerberatung)" ], [ "cbss", "cbss (ZDSS)" ] ];
Lino.cbss.RequestStates = [ [ "10", "Versendet" ], [ "20", "Fehlgeschlagen" ], [ "25", "Validiert" ], [ "30", "OK" ], [ "40", "Warnungen" ], [ "50", "Fehlermeldungen" ] ];
Lino.lino.ChangeTypes = [ [ "C", "Erstellen" ], [ "U", "Aktualisierung" ], [ "D", "L\u00f6schen" ], [ "R", "Remove child" ], [ "A", "Add child" ], [ "M", "Fusionieren" ] ];
Lino.cal.AccessClasses = [ [ "10", "Privat" ], [ "20", "halb \u00f6ffentlich (\"Besch\u00e4ftigt\")" ], [ "30", "\u00d6ffentlich" ] ];
Lino.cbss.QueryRegister = [ [ "1", "Prim\u00e4r" ], [ "2", "Sekund\u00e4r" ], [ "3", "Alle" ] ];
Lino.lino.Genders = [ [ "M", "M\u00e4nnlich" ], [ "F", "Weiblich" ] ];
Lino.pcsw.ResidenceType = [ [ "1", "Bev\u00f6lkerungsregister" ], [ "2", "Fremdenregister" ], [ "3", "Warteregister" ] ];

Lino.cal.MyEvents.ParamsPanel = Ext.extend(Ext.form.FormPanel,{
  autoScroll: false,
  border: false,
  layout: "fit",
  hideCheckBoxLabels: true,
  frame: true,
  bodyBorder: false,
  labelAlign: "top",
  initComponent : function() {
    var containing_panel = this;
    var dates_from830 = new Lino.DateField({ "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Datum von","Nur Termine ab diesem Datum.") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Datum von</span>", "anchor": "-20", "name": "dates_from" });
    var dates_to831 = new Lino.DateField({ "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("bis","Nur Termine bis zu diesem Datum.") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">bis</span>", "anchor": "-20", "name": "dates_to" });
    var user832 = new Lino.TwinCombo({ "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Verantwortlicher</span>", "name": "user", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.users.Users.detail)}, "emptyText": "Benutzer ausw\u00e4hlen...", "listeners": { "render": Lino.quicktip_renderer("Verantwortlicher","Nur Termine dieses Benutzers.") }, "selectOnFocus": true, "hiddenName": "userHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/Events/user", "method": "GET" }) }) });
    var assigned_to833 = new Lino.TwinCombo({ "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Zugewiesen zu</span>", "name": "assigned_to", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.users.Users.detail)}, "emptyText": "Benutzer ausw\u00e4hlen...", "listeners": { "render": Lino.quicktip_renderer("Zugewiesen zu","Nur Termine, die diesem Benutzer zugewiesen sind.") }, "selectOnFocus": true, "hiddenName": "assigned_toHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/Events/assigned_to", "method": "GET" }) }) });
    var state834 = new Lino.ChoicesFieldElement({ "forceSelection": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Zustand</span>", "name": "state", "hiddenName": "stateHidden", "listeners": { "render": Lino.quicktip_renderer("Zustand","Nur Termine in diesem Bearbeitungszustand.") }, "selectOnFocus": true, "anchor": "-20", "store": Lino.cal.EventStates });
    var unclear835 = new Ext.form.Checkbox({ "boxLabel": "Unklare Termine", "hideLabel": true, "checked": false, "name": "unclear", "selectOnFocus": true, "anchor": "-20" });
    var main_1_panel836 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 153, "hideCheckBoxLabels": true, "items": [ { "flex": 11, "autoHeight": true, "layout": "form", "xtype": "panel", "items": dates_from830, "labelAlign": "top" }, { "flex": 11, "autoHeight": true, "layout": "form", "xtype": "panel", "items": dates_to831, "labelAlign": "top" }, { "flex": 20, "autoHeight": true, "layout": "form", "xtype": "panel", "items": user832, "labelAlign": "top" }, { "flex": 20, "autoHeight": true, "layout": "form", "xtype": "panel", "items": assigned_to833, "labelAlign": "top" }, { "flex": 22, "autoHeight": true, "layout": "form", "xtype": "panel", "items": state834, "labelAlign": "top" }, { "flex": 13, "autoHeight": true, "layout": "form", "xtype": "panel", "items": unclear835, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    this.items = [ main_1_panel836 ];
    this.fields = [ dates_from830, dates_to831, user832, assigned_to833, state834, unclear835 ];
    Lino.cal.MyEvents.ParamsPanel.superclass.initComponent.call(this);
  }
});


Lino.pcsw.Clients.ParamsPanel = Ext.extend(Ext.form.FormPanel,{
  autoScroll: false,
  autoHeight: true,
  border: false,
  layout: "form",
  hideCheckBoxLabels: true,
  frame: true,
  bodyBorder: false,
  labelAlign: "top",
  initComponent : function() {
    var containing_panel = this;
    var aged_from2054 = new Ext.form.NumberField({ "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Alter von","Nur Klienten, die mindestens so alt sind.") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Alter von</span>", "anchor": "-20", "name": "aged_from" });
    var aged_to2055 = new Ext.form.NumberField({ "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Alter bis","Nur Klienten, die h\u00f6chstens so alt sind.") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Alter bis</span>", "anchor": "-20", "name": "aged_to" });
    var gender2056 = new Lino.ChoicesFieldElement({ "forceSelection": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Geschlecht</span>", "name": "gender", "hiddenName": "genderHidden", "listeners": { "render": Lino.quicktip_renderer("Geschlecht","Nur Personen, deren Feld \"Geschlecht\" ausgef\u00fcllt ist und dem angegebenen Wert entspricht.") }, "selectOnFocus": true, "anchor": "-20", "store": Lino.lino.Genders });
    var also_obsolete2057 = new Ext.form.Checkbox({ "boxLabel": "Auch veraltete Daten", "listeners": { "render": Lino.quicktip_renderer("Auch veraltete Daten","Auch Datens\u00e4tze anzeigen, die als veraltet markiert sind.") }, "hideLabel": true, "checked": false, "name": "also_obsolete", "selectOnFocus": true, "anchor": "-20" });
    var main_1_panel2058 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 16, "autoHeight": true, "layout": "form", "xtype": "panel", "items": aged_from2054, "labelAlign": "top" }, { "flex": 16, "autoHeight": true, "layout": "form", "xtype": "panel", "items": aged_to2055, "labelAlign": "top" }, { "flex": 35, "autoHeight": true, "layout": "form", "xtype": "panel", "items": gender2056, "labelAlign": "top" }, { "flex": 32, "autoHeight": true, "layout": "form", "xtype": "panel", "items": also_obsolete2057, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 189, "border": false, "anchor": "-20", "labelAlign": "top" });
    var client_state2063 = new Lino.ChoicesFieldElement({ "forceSelection": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Zustand</span>", "name": "client_state", "hiddenName": "client_stateHidden", "listeners": { "render": Lino.quicktip_renderer("Zustand","Nur Klienten mit diesem Status (Aktenzustand).") }, "selectOnFocus": true, "anchor": "-20", "store": Lino.pcsw.ClientStates });
    var coached_by2064 = new Lino.TwinCombo({ "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Begleitet durch</span>", "name": "coached_by", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.users.Users.detail)}, "emptyText": "Benutzer ausw\u00e4hlen...", "listeners": { "render": Lino.quicktip_renderer("Begleitet durch","Nur Klienten, die eine Begleitung mit diesem Benutzer haben.") }, "selectOnFocus": true, "hiddenName": "coached_byHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/pcsw/Clients/coached_by", "method": "GET" }) }) });
    var and_coached_by2065 = new Lino.TwinCombo({ "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">und durch</span>", "name": "and_coached_by", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.users.Users.detail)}, "emptyText": "Benutzer ausw\u00e4hlen...", "listeners": { "render": Lino.quicktip_renderer("und durch","Nur Klienten, die auch mit diesem Benutzer eine Begleitung haben.") }, "selectOnFocus": true, "hiddenName": "and_coached_byHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/pcsw/Clients/and_coached_by", "method": "GET" }) }) });
    var coached_on2066 = new Lino.DateField({ "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Begleitet am","Nur Klienten, die zu diesem Datum effektiv begleitet waren \n(d.h. die mindestens eine aktive Begleitung an diesem Datum haben)") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Begleitet am</span>", "anchor": "-20", "name": "coached_on" });
    var only_primary2067 = new Ext.form.Checkbox({ "boxLabel": "Nur prim\u00e4re Begleitungen", "listeners": { "render": Lino.quicktip_renderer("Nur prim\u00e4re Begleitungen","Nur Klienten, die eine effektive <b>prim\u00e4re</b> Begleitung haben.") }, "hideLabel": true, "checked": false, "name": "only_primary", "selectOnFocus": true, "anchor": "-20" });
    var nationality2068 = new Lino.TwinCombo({ "fieldLabel": "Staatsangeh\u00f6rigkeit", "name": "nationality", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.countries.Countries.detail)}, "emptyText": "Land ausw\u00e4hlen...", "selectOnFocus": true, "hiddenName": "nationalityHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/pcsw/Clients/nationality", "method": "GET" }) }) });
    var main_2_panel2069 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 15, "autoHeight": true, "layout": "form", "xtype": "panel", "items": client_state2063, "labelAlign": "top" }, { "flex": 18, "autoHeight": true, "layout": "form", "xtype": "panel", "items": coached_by2064, "labelAlign": "top" }, { "flex": 18, "autoHeight": true, "layout": "form", "xtype": "panel", "items": and_coached_by2065, "labelAlign": "top" }, { "flex": 10, "autoHeight": true, "layout": "form", "xtype": "panel", "items": coached_on2066, "labelAlign": "top" }, { "flex": 12, "autoHeight": true, "layout": "form", "xtype": "panel", "items": only_primary2067, "labelAlign": "top" }, { "flex": 25, "autoHeight": true, "layout": "form", "xtype": "panel", "items": nationality2068, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 225, "border": false, "anchor": "-20", "labelAlign": "top" });
    this.items = [ main_1_panel2058, main_2_panel2069 ];
    this.fields = [ aged_from2054, aged_to2055, gender2056, also_obsolete2057, client_state2063, coached_by2064, and_coached_by2065, coached_on2066, only_primary2067, nationality2068 ];
    Lino.pcsw.Clients.ParamsPanel.superclass.initComponent.call(this);
  }
});


Lino.contacts.Persons.ParamsPanel = Ext.extend(Ext.form.FormPanel,{
  autoScroll: false,
  border: false,
  layout: "fit",
  hideCheckBoxLabels: true,
  frame: true,
  bodyBorder: false,
  labelAlign: "top",
  initComponent : function() {
    var containing_panel = this;
    var gender1399 = new Lino.ChoicesFieldElement({ "forceSelection": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Geschlecht</span>", "name": "gender", "hiddenName": "genderHidden", "listeners": { "render": Lino.quicktip_renderer("Geschlecht","Nur Personen, deren Feld \"Geschlecht\" ausgef\u00fcllt ist und dem angegebenen Wert entspricht.") }, "selectOnFocus": true, "anchor": "-20", "store": Lino.lino.Genders });
    var also_obsolete1400 = new Ext.form.Checkbox({ "boxLabel": "Auch veraltete Daten", "listeners": { "render": Lino.quicktip_renderer("Auch veraltete Daten","Auch Datens\u00e4tze anzeigen, die als veraltet markiert sind.") }, "hideLabel": true, "checked": false, "name": "also_obsolete", "selectOnFocus": true, "anchor": "-20" });
    var main_1_panel1401 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 189, "hideCheckBoxLabels": true, "items": [ { "flex": 52, "autoHeight": true, "layout": "form", "xtype": "panel", "items": gender1399, "labelAlign": "top" }, { "flex": 47, "autoHeight": true, "layout": "form", "xtype": "panel", "items": also_obsolete1400, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    this.items = [ main_1_panel1401 ];
    this.fields = [ gender1399, also_obsolete1400 ];
    Lino.contacts.Persons.ParamsPanel.superclass.initComponent.call(this);
  }
});


Lino.pcsw.Clients.wf2_ActionFormPanel = Ext.extend(Lino.ActionFormPanel,{
  autoScroll: false,
  border: false,
  layout: "vbox",
  labelWidth: 90,
  hideCheckBoxLabels: true,
  frame: true,
  layoutConfig: { "align": "stretch" },
  bodyBorder: false,
  labelAlign: "top",
  action_name: 'wf2',
  window_title: "Ablehnen",
  initComponent : function() {
    var containing_panel = this;
    var reason13 = new Lino.ChoicesFieldElement({ "forceSelection": true, "fieldLabel": "reason", "allowBlank": false, "hiddenName": "reasonHidden", "selectOnFocus": true, "anchor": "-20", "store": Lino.pcsw.RefusalReasons, "name": "reason" });
    var remark14 = new Ext.form.TextArea({ "selectOnFocus": true, "fieldLabel": "Bemerkung", "anchor": "-20 -10", "growMax": 2000, "name": "remark" });
    this.items = [ { "items": reason13, "autoHeight": true, "layout": "form", "xtype": "panel", "labelAlign": "top" }, { "items": remark14, "labelAlign": "top", "layout": "form", "xtype": "panel", "flex": 83 } ];
    this.fields = [ reason13, remark14 ];
    Lino.pcsw.Clients.wf2_ActionFormPanel.superclass.initComponent.call(this);
  }
});


Lino.cal.Guests.wf2_ActionFormPanel = Ext.extend(Lino.ActionFormPanel,{
  autoScroll: false,
  border: false,
  layout: "vbox",
  labelWidth: 387,
  hideCheckBoxLabels: true,
  frame: true,
  layoutConfig: { "align": "stretch" },
  bodyBorder: false,
  labelAlign: "top",
  action_name: 'wf2',
  window_title: "Absagen",
  initComponent : function() {
    var containing_panel = this;
    var notify_subject6 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200, "fieldLabel": "Kurzbeschreibung", "anchor": "-20", "name": "notify_subject" });
    var notify_body7 = new Ext.form.TextArea({ "selectOnFocus": true, "fieldLabel": "Beschreibung", "anchor": "-20 -10", "growMax": 2000, "name": "notify_body" });
    var notify_silent8 = new Ext.form.Checkbox({ "boxLabel": "Keine Benachrichtigung per E-Mail schicken", "hideLabel": true, "checked": false, "name": "notify_silent", "selectOnFocus": true, "anchor": "-20" });
    this.items = [ { "items": notify_subject6, "autoHeight": true, "layout": "form", "xtype": "panel", "labelAlign": "top" }, { "items": notify_body7, "labelAlign": "top", "layout": "form", "xtype": "panel", "flex": 71 }, { "items": notify_silent8, "autoHeight": true, "layout": "form", "xtype": "panel", "labelAlign": "top" } ];
    this.fields = [ notify_subject6, notify_body7, notify_silent8 ];
    Lino.cal.Guests.wf2_ActionFormPanel.superclass.initComponent.call(this);
  }
});


Lino.pcsw.Clients.merge_row_ActionFormPanel = Ext.extend(Lino.ActionFormPanel,{
  autoScroll: false,
  autoHeight: true,
  border: false,
  layout: "form",
  labelWidth: 99,
  hideCheckBoxLabels: true,
  frame: true,
  bodyBorder: false,
  labelAlign: "top",
  action_name: 'merge_row',
  window_title: "Fusionieren",
  autoHeight: true,
  initComponent : function() {
    var containing_panel = this;
    var merge_to18 = new Lino.TwinCombo({ "fieldLabel": "nach...", "allowBlank": false, "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.pcsw.Clients.detail)}, "emptyText": "Klient ausw\u00e4hlen...", "selectOnFocus": true, "hiddenName": "merge_toHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/apchoices/pcsw/Clients/merge_row/merge_to", "method": "GET" }) }), "name": "merge_to" });
    var pcsw_Coaching19 = new Ext.form.Checkbox({ "boxLabel": "Begleitungen", "hideLabel": true, "checked": false, "name": "pcsw_Coaching", "selectOnFocus": true, "anchor": "-20" });
    var cv_LanguageKnowledge20 = new Ext.form.Checkbox({ "boxLabel": "Sprachkenntnisse", "hideLabel": true, "checked": false, "name": "cv_LanguageKnowledge", "selectOnFocus": true, "anchor": "-20" });
    var keep_volatiles_1_panel21 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": pcsw_Coaching19, "labelAlign": "top" }, { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": cv_LanguageKnowledge20, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 153, "border": false, "anchor": "-20", "labelAlign": "top" });
    var properties_PersonProperty24 = new Ext.form.Checkbox({ "boxLabel": "Eigenschaften", "hideLabel": true, "checked": false, "name": "properties_PersonProperty", "selectOnFocus": true, "anchor": "-20" });
    var keep_volatiles_panel25 = new Ext.form.FieldSet({ "autoHeight": true, "layout": "form", "title": "Auch verg\u00e4ngliche verkn\u00fcpfte Objekte \u00fcberweisen", "items": [ keep_volatiles_1_panel21, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": properties_PersonProperty24, "anchor": "-20", "labelAlign": "top" } ], "frame": true, "bodyBorder": false, "autoScroll": false, "hideCheckBoxLabels": true, "labelWidth": 126, "border": false, "anchor": "-20", "labelAlign": "top" });
    var reason27 = new Ext.form.TextField({ "fieldLabel": "Begr\u00fcndung", "name": "reason", "maxLength": 100, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    this.items = [ { "autoHeight": true, "layout": "form", "xtype": "panel", "items": merge_to18, "anchor": "-20", "labelAlign": "top" }, keep_volatiles_panel25, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": reason27, "anchor": "-20", "labelAlign": "top" } ];
    this.fields = [ merge_to18, pcsw_Coaching19, cv_LanguageKnowledge20, properties_PersonProperty24, reason27 ];
    Lino.pcsw.Clients.merge_row_ActionFormPanel.superclass.initComponent.call(this);
  }
});


Lino.contacts.Companies.merge_row_ActionFormPanel = Ext.extend(Lino.ActionFormPanel,{
  autoScroll: false,
  autoHeight: true,
  border: false,
  layout: "form",
  labelWidth: 99,
  hideCheckBoxLabels: true,
  frame: true,
  bodyBorder: false,
  labelAlign: "top",
  action_name: 'merge_row',
  window_title: "Fusionieren",
  autoHeight: true,
  initComponent : function() {
    var containing_panel = this;
    this.items = [  ];
    this.fields = [  ];
    Lino.contacts.Companies.merge_row_ActionFormPanel.superclass.initComponent.call(this);
  }
});


Lino.about.Models.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  disable_editing: true,
  initComponent : function() {
    var containing_panel = this;
    var app_disp2258 = new Ext.form.DisplayField({ "disabled": true, "fieldLabel": "app_label", "name": "app", "anchor": "-20", "value": "<br/>", "always_enabled": true });
    var name_disp2259 = new Ext.form.DisplayField({ "disabled": true, "fieldLabel": "name", "name": "name", "anchor": "-20", "value": "<br/>", "always_enabled": true });
    var docstring_disp2260 = new Ext.form.DisplayField({ "disabled": true, "fieldLabel": "docstring", "name": "docstring", "anchor": "-20", "value": "<br/>", "always_enabled": true });
    var rows2261 = new Ext.form.NumberField({ "disabled": true, "fieldLabel": "Rows", "anchor": "-20", "name": "rows" });
    var main_1_panel2262 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 90, "hideCheckBoxLabels": true, "items": [ { "flex": 31, "autoHeight": true, "layout": "form", "xtype": "panel", "items": app_disp2258, "labelAlign": "top" }, { "flex": 31, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_disp2259, "labelAlign": "top" }, { "flex": 31, "autoHeight": true, "layout": "form", "xtype": "panel", "items": docstring_disp2260, "labelAlign": "top" }, { "flex": 5, "autoHeight": true, "layout": "form", "xtype": "panel", "items": rows2261, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var about_FieldsByModel_grid2271 = new Lino.about.FieldsByModel.GridPanel({ "tools": [ Lino.show_in_own_window_button(Lino.about.FieldsByModel.grid) ], "containing_panel": this, "hide_top_toolbar": true, "master_panel": this, "flex": 62 });
    var main_panel2272 = new Ext.Panel({ "autoScroll": false, "border": false, "layout": "vbox", "hideCheckBoxLabels": true, "items": [ main_1_panel2262, about_FieldsByModel_grid2271 ], "frame": true, "layoutConfig": { "align": "stretch" }, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel2272;
    this.before_row_edit = function(record) {
      about_FieldsByModel_grid2271.on_master_changed();
    }
    Lino.about.Models.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.cal.Tasks.InsertFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  autoHeight: true,
  content_type: 30,
  initComponent : function() {
    var containing_panel = this;
    var summary174 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200, "fieldLabel": "Kurzbeschreibung", "anchor": "-20", "name": "summary" });
    var user175 = new Lino.TwinCombo({ "fieldLabel": "Autor", "name": "user", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.users.Users.detail)}, "emptyText": "Benutzer ausw\u00e4hlen...", "selectOnFocus": true, "hiddenName": "userHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/Tasks/user", "method": "GET" }) }) });
    var project176 = new Lino.TwinCombo({ "fieldLabel": "Klient", "name": "project", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.pcsw.Clients.detail)}, "emptyText": "Klient ausw\u00e4hlen...", "selectOnFocus": true, "hiddenName": "projectHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/Tasks/project", "method": "GET" }) }) });
    var main_2_panel177 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 42, "autoHeight": true, "layout": "form", "xtype": "panel", "items": user175, "labelAlign": "top" }, { "flex": 57, "autoHeight": true, "layout": "form", "xtype": "panel", "items": project176, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 63, "border": false, "anchor": "-20", "labelAlign": "top" });
    var main_panel180 = new Ext.Panel({ "hideCheckBoxLabels": true, "autoHeight": true, "border": false, "layout": "form", "labelWidth": 153, "autoScroll": false, "items": [ { "autoHeight": true, "layout": "form", "xtype": "panel", "items": summary174, "anchor": "-20", "labelAlign": "top" }, main_2_panel177 ], "frame": true, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel180;
    this.before_row_edit = function(record) {
    }
    Lino.cal.Tasks.InsertFormPanel.superclass.initComponent.call(this);
  }
});


Lino.cal.PanelCalendars.InsertFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  autoHeight: true,
  content_type: 35,
  initComponent : function() {
    var containing_panel = this;
    var name1025 = new Ext.form.TextField({ "fieldLabel": "Bezeichnung", "name": "name", "maxLength": 200, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var name_fr1026 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200, "fieldLabel": "Bezeichnung (fr)", "anchor": "-20", "name": "name_fr" });
    var name_nl1027 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200, "fieldLabel": "Bezeichnung (nl)", "anchor": "-20", "name": "name_nl" });
    var main_1_panel1028 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name1025, "labelAlign": "top" }, { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_fr1026, "labelAlign": "top" }, { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_nl1027, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 153, "border": false, "anchor": "-20", "labelAlign": "top" });
    var type1032 = new Lino.ChoicesFieldElement({ "fieldLabel": "Art", "allowBlank": false, "value": "local", "hiddenName": "typeHidden", "selectOnFocus": true, "anchor": "-20", "store": [ [ "local", "Local Calendar" ], [ "google", "Google Calendar" ] ], "name": "type" });
    var invite_team_members1033 = new Lino.RemoteComboFieldElement({ "fieldLabel": "Team", "name": "invite_team_members", "pageSize": 20, "emptyText": "Team ausw\u00e4hlen...", "selectOnFocus": true, "hiddenName": "invite_team_membersHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/Calendars/invite_team_members", "method": "GET" }) }) });
    var color1034 = new Ext.form.NumberField({ "fieldLabel": "Farbe", "name": "color", "selectOnFocus": true, "anchor": "-20", "value": 1, "allowBlank": false });
    var main_2_panel1035 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 44, "autoHeight": true, "layout": "form", "xtype": "panel", "items": type1032, "labelAlign": "top" }, { "flex": 44, "autoHeight": true, "layout": "form", "xtype": "panel", "items": invite_team_members1033, "labelAlign": "top" }, { "flex": 11, "autoHeight": true, "layout": "form", "xtype": "panel", "items": color1034, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 54, "border": false, "anchor": "-20", "labelAlign": "top" });
    var main_panel1039 = new Ext.Panel({ "hideCheckBoxLabels": true, "autoHeight": true, "border": false, "layout": "form", "autoScroll": false, "items": [ main_1_panel1028, main_2_panel1035 ], "frame": true, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel1039;
    this.before_row_edit = function(record) {
    }
    Lino.cal.PanelCalendars.InsertFormPanel.superclass.initComponent.call(this);
  }
});


Lino.households.Households.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 41,
  initComponent : function() {
    var containing_panel = this;
    var type1108 = new Lino.TwinCombo({ "fieldLabel": "Haushaltsart", "name": "type", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.households.Types.detail)}, "emptyText": "Haushaltsart ausw\u00e4hlen...", "selectOnFocus": true, "hiddenName": "typeHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/households/Households/type", "method": "GET" }) }) });
    var name1109 = new Ext.form.TextField({ "fieldLabel": "Name", "name": "name", "maxLength": 200, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var language1110 = new Lino.ChoicesFieldElement({ "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Sprache</span>", "allowBlank": false, "value": "de", "hiddenName": "languageHidden", "listeners": { "render": Lino.quicktip_renderer("Sprache","Die Sprache, in der Dokumente ausgestellt werden sollen.") }, "selectOnFocus": true, "anchor": "-20", "store": [ [ "de", "Deutsch" ], [ "fr", "Franz\u00f6sisch" ], [ "nl", "Niederl\u00e4ndisch" ] ], "name": "language" });
    var id1111 = new Ext.form.NumberField({ "selectOnFocus": true, "fieldLabel": "ID", "anchor": "-20", "name": "id" });
    var intro_box_1_panel1112 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 117, "hideCheckBoxLabels": true, "items": [ { "flex": 35, "autoHeight": true, "layout": "form", "xtype": "panel", "items": type1108, "labelAlign": "top" }, { "flex": 37, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name1109, "labelAlign": "top" }, { "flex": 17, "autoHeight": true, "layout": "form", "xtype": "panel", "items": language1110, "labelAlign": "top" }, { "flex": 8, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id1111, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var country1117 = new Lino.TwinCombo({ "fieldLabel": "Land", "name": "country", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.countries.Countries.detail)}, "emptyText": "Land ausw\u00e4hlen...", "selectOnFocus": true, "hiddenName": "countryHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/households/Households/country", "method": "GET" }) }) });
    var region1118 = new Lino.TwinCombo({ "fieldLabel": "Region", "name": "region", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.countries.Cities.detail)}, "emptyText": "Ort ausw\u00e4hlen...", "selectOnFocus": true, "hiddenName": "regionHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/households/Households/region", "method": "GET" }) }) });
    var box3_1_panel1119 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": country1117, "labelAlign": "top" }, { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": region1118, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 63, "border": false, "anchor": "-20", "labelAlign": "top" });
    var city1122 = new Lino.TwinCombo({ "forceSelection": false, "fieldLabel": "Ort", "name": "city", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.countries.Cities.detail)}, "emptyText": "Ort ausw\u00e4hlen...", "selectOnFocus": true, "hiddenName": "cityHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/households/Households/city", "method": "GET" }) }) });
    var zip_code1123 = new Ext.form.TextField({ "fieldLabel": "Postleitzahl", "name": "zip_code", "maxLength": 10, "selectOnFocus": true, "boxMinWidth": Lino.chars2width(10), "anchor": "-20" });
    var box3_2_panel1124 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 66, "autoHeight": true, "layout": "form", "xtype": "panel", "items": city1122, "labelAlign": "top" }, { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": zip_code1123, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 117, "border": false, "anchor": "-20", "labelAlign": "top" });
    var street_prefix1127 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Pr\u00e4fix Stra\u00dfe","Text to print before name of street, but to ignore for sorting.") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Pr\u00e4fix Stra\u00dfe</span>", "name": "street_prefix", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var street1128 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Stra\u00dfe","Name of street. Without house number.") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Stra\u00dfe</span>", "name": "street", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var street_no1129 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Nr.","House number") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Nr.</span>", "name": "street_no", "maxLength": 10, "selectOnFocus": true, "boxMinWidth": Lino.chars2width(10), "anchor": "-20" });
    var street_box1130 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Box","Text to print after :attr:`steet_no` on the same line") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Box</span>", "name": "street_box", "maxLength": 10, "selectOnFocus": true, "boxMinWidth": Lino.chars2width(10), "anchor": "-20" });
    var box3_3_panel1131 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 30, "autoHeight": true, "layout": "form", "xtype": "panel", "items": street_prefix1127, "labelAlign": "top" }, { "flex": 36, "autoHeight": true, "layout": "form", "xtype": "panel", "items": street1128, "labelAlign": "top" }, { "flex": 16, "autoHeight": true, "layout": "form", "xtype": "panel", "items": street_no1129, "labelAlign": "top" }, { "flex": 16, "autoHeight": true, "layout": "form", "xtype": "panel", "items": street_box1130, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 126, "border": false, "anchor": "-20", "labelAlign": "top" });
    var addr21136 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Adresszeile nach Stra\u00dfe","Address line to print below street line") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Adresszeile nach Stra\u00dfe</span>", "name": "addr2", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var activity1137 = new Lino.RemoteComboFieldElement({ "fieldLabel": "Beruf", "name": "activity", "pageSize": 20, "emptyText": "Beruf ausw\u00e4hlen...", "selectOnFocus": true, "hiddenName": "activityHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/households/Households/activity", "method": "GET" }) }) });
    var bank_account11138 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 40, "fieldLabel": "Bankkonto 1", "anchor": "-20", "name": "bank_account1" });
    var bank_account21139 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 40, "fieldLabel": "Bankkonto 2", "anchor": "-20", "name": "bank_account2" });
    var box3_5_panel1140 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 45, "autoHeight": true, "layout": "form", "xtype": "panel", "items": activity1137, "labelAlign": "top" }, { "flex": 27, "autoHeight": true, "layout": "form", "xtype": "panel", "items": bank_account11138, "labelAlign": "top" }, { "flex": 27, "autoHeight": true, "layout": "form", "xtype": "panel", "items": bank_account21139, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 108, "border": false, "anchor": "-20", "labelAlign": "top" });
    var box3_panel1144 = new Ext.Panel({ "flex": 62, "autoHeight": true, "layout": "form", "items": [ box3_1_panel1119, box3_2_panel1124, box3_3_panel1131, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": addr21136, "anchor": "-20", "labelAlign": "top" }, box3_5_panel1140 ], "frame": true, "bodyBorder": false, "autoScroll": false, "hideCheckBoxLabels": true, "labelWidth": 216, "border": false, "labelAlign": "top" });
    var email1146 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 75, "fieldLabel": "E-Mail", "anchor": "-20", "name": "email" });
    var url1147 = new Lino.URLField({ "selectOnFocus": true, "maxLength": 200, "fieldLabel": "URL", "anchor": "-20", "name": "url" });
    var phone1148 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200, "fieldLabel": "Telefon", "anchor": "-20", "name": "phone" });
    var gsm1149 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200, "fieldLabel": "GSM", "anchor": "-20", "name": "gsm" });
    var box4_panel1150 = new Ext.Panel({ "flex": 37, "autoHeight": true, "layout": "form", "items": [ { "autoHeight": true, "layout": "form", "xtype": "panel", "items": email1146, "anchor": "-20", "labelAlign": "top" }, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": url1147, "anchor": "-20", "labelAlign": "top" }, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": phone1148, "anchor": "-20", "labelAlign": "top" }, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": gsm1149, "anchor": "-20", "labelAlign": "top" } ], "frame": true, "bodyBorder": false, "autoScroll": false, "hideCheckBoxLabels": true, "labelWidth": 72, "border": false, "labelAlign": "top" });
    var address_box_panel1155 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "hideCheckBoxLabels": true, "items": [ box3_panel1144, box4_panel1150 ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var remarks1156 = new Ext.form.TextArea({ "selectOnFocus": true, "fieldLabel": "Bemerkungen", "anchor": "-20 -10", "growMax": 2000, "name": "remarks" });
    var households_MembersByHousehold_grid1163 = new Lino.households.MembersByHousehold.GridPanel({ "tools": [ Lino.show_in_own_window_button(Lino.households.MembersByHousehold.grid) ], "containing_panel": this, "hide_top_toolbar": true, "master_panel": this, "flex": 50 });
    var bottom_box_panel1164 = new Ext.Panel({ "flex": 45, "border": false, "layout": "hbox", "labelWidth": 108, "hideCheckBoxLabels": true, "items": [ { "items": remarks1156, "labelAlign": "top", "layout": "form", "xtype": "panel", "flex": 49 }, households_MembersByHousehold_grid1163 ], "autoScroll": false, "layoutConfig": { "align": "stretch" }, "frame": false, "labelAlign": "top" });
    var general_panel1166 = new Ext.Panel({ "layout": "vbox", "title": "Allgemein", "items": [ intro_box_1_panel1112, address_box_panel1155, bottom_box_panel1164 ], "frame": true, "layoutConfig": { "align": "stretch" }, "hideCheckBoxLabels": true, "listeners": { "activate": Lino.on_tab_activate }, "autoScroll": false, "border": false, "bodyBorder": false, "labelAlign": "top" });
    var debts_BudgetsByPartner_grid1167 = new Lino.debts.BudgetsByPartner.GridPanel({ "flex": 5, "hide_top_toolbar": true, "split": true, "containing_panel": this, "region": "north", "tools": [ Lino.show_in_own_window_button(Lino.debts.BudgetsByPartner.grid) ], "master_panel": this });
    var debts_ActorsByPartner_grid1168 = new Lino.debts.ActorsByPartner.GridPanel({ "flex": 5, "hide_top_toolbar": true, "split": true, "containing_panel": this, "region": "center", "tools": [ Lino.show_in_own_window_button(Lino.debts.ActorsByPartner.grid) ], "master_panel": this });
    var debts_panel1169 = new Lino.VBorderPanel({ "autoScroll": false, "listeners": { "activate": Lino.on_tab_activate }, "border": false, "title": "Schuldnerberatung", "hideCheckBoxLabels": true, "items": [ debts_BudgetsByPartner_grid1167, debts_ActorsByPartner_grid1168 ], "frame": true, "bodyBorder": false, "labelAlign": "top" });
    var main_panel1170 = new Ext.TabPanel({ "hideCheckBoxLabels": true, "border": false, "split": true, "autoScroll": false, "items": [ general_panel1166, debts_panel1169 ], "activeTab": 0, "bodyBorder": false, "frame": true, "labelAlign": "top" });
    this.items = main_panel1170;
    this.before_row_edit = function(record) {
      region1118.setContextValue('country',record ? record.data['countryHidden'] : undefined);
      city1122.setContextValue('country',record ? record.data['countryHidden'] : undefined);
      city1122.setContextValue('region',record ? record.data['regionHidden'] : undefined);
      households_MembersByHousehold_grid1163.on_master_changed();
      debts_BudgetsByPartner_grid1167.on_master_changed();
      debts_ActorsByPartner_grid1168.on_master_changed();
    }
    this.onRender = function(ct, position) {
      country1117.on('change',Lino.chooser_handler(region1118,'country'));
      country1117.on('change',Lino.chooser_handler(city1122,'country'));
      region1118.on('change',Lino.chooser_handler(city1122,'region'));
      Lino.households.Households.DetailFormPanel.superclass.onRender.call(this, ct, position);
    }
    Lino.households.Households.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.notes.NoteTypes.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 93,
  initComponent : function() {
    var containing_panel = this;
    var id1236 = new Ext.form.NumberField({ "selectOnFocus": true, "fieldLabel": "ID", "anchor": "-20", "name": "id" });
    var name1237 = new Ext.form.TextField({ "fieldLabel": "Bezeichnung", "name": "name", "maxLength": 200, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var name_fr1238 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200, "fieldLabel": "Bezeichnung (fr)", "anchor": "-20", "name": "name_fr" });
    var name_nl1239 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200, "fieldLabel": "Bezeichnung (nl)", "anchor": "-20", "name": "name_nl" });
    var main_1_panel1240 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 153, "hideCheckBoxLabels": true, "items": [ { "flex": 7, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id1236, "labelAlign": "top" }, { "flex": 30, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name1237, "labelAlign": "top" }, { "flex": 30, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_fr1238, "labelAlign": "top" }, { "flex": 30, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_nl1239, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var build_method1245 = new Lino.ChoicesFieldElement({ "fieldLabel": "Konstruktionsmethode", "name": "build_method", "selectOnFocus": true, "anchor": "-20", "store": [ [ "appyodt", "AppyOdtBuildMethod" ], [ "appypdf", "AppyPdfBuildMethod" ], [ "appyrtf", "AppyRtfBuildMethod" ], [ "latex", "LatexBuildMethod" ], [ "pisa", "PisaBuildMethod" ], [ "rtf", "RtfBuildMethod" ] ], "hiddenName": "build_methodHidden" });
    var template1246 = new Lino.SimpleRemoteComboFieldElement({ "selectOnFocus": true, "fieldLabel": "Vorlage", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/notes/NoteTypes/template", "method": "GET" }) }), "name": "template" });
    var email_template1247 = new Lino.SimpleRemoteComboFieldElement({ "listeners": { "render": Lino.quicktip_renderer("E-Mail-Vorlage","The name of the file to be used as template \nwhen creating an email from a mailable of this type.\n") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">E-Mail-Vorlage</span>", "name": "email_template", "selectOnFocus": true, "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/notes/NoteTypes/email_template", "method": "GET" }) }) });
    var attach_to_email1248 = new Ext.form.Checkbox({ "boxLabel": "als Anhang per E-Mail", "listeners": { "render": Lino.quicktip_renderer("als Anhang per E-Mail","Whether the printable file should be attached to the email\nwhen creating an email from a mailable of this type.\n") }, "hideLabel": true, "checked": false, "name": "attach_to_email", "selectOnFocus": true, "anchor": "-20" });
    var main_2_panel1249 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 198, "hideCheckBoxLabels": true, "items": [ { "flex": 40, "autoHeight": true, "layout": "form", "xtype": "panel", "items": build_method1245, "labelAlign": "top" }, { "flex": 20, "autoHeight": true, "layout": "form", "xtype": "panel", "items": template1246, "labelAlign": "top" }, { "flex": 20, "autoHeight": true, "layout": "form", "xtype": "panel", "items": email_template1247, "labelAlign": "top" }, { "flex": 20, "autoHeight": true, "layout": "form", "xtype": "panel", "items": attach_to_email1248, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var remark1254 = new Ext.form.TextArea({ "selectOnFocus": true, "fieldLabel": "Bemerkung", "anchor": "-20 -10", "growMax": 2000, "name": "remark" });
    var notes_NotesByType_grid1269 = new Lino.notes.NotesByType.GridPanel({ "tools": [ Lino.show_in_own_window_button(Lino.notes.NotesByType.grid) ], "containing_panel": this, "hide_top_toolbar": true, "master_panel": this, "flex": 41 });
    var main_panel1270 = new Ext.Panel({ "autoScroll": false, "border": false, "layout": "vbox", "labelWidth": 90, "hideCheckBoxLabels": true, "items": [ main_1_panel1240, main_2_panel1249, { "items": remark1254, "labelAlign": "top", "layout": "form", "xtype": "panel", "flex": 41 }, notes_NotesByType_grid1269 ], "frame": true, "layoutConfig": { "align": "stretch" }, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel1270;
    this.before_row_edit = function(record) {
      template1246.setContextValue('build_method',record ? record.data['build_methodHidden'] : undefined);
      notes_NotesByType_grid1269.on_master_changed();
    }
    this.onRender = function(ct, position) {
      build_method1245.on('change',Lino.chooser_handler(template1246,'build_method'));
      Lino.notes.NoteTypes.DetailFormPanel.superclass.onRender.call(this, ct, position);
    }
    Lino.notes.NoteTypes.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.cal.Tasks.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 30,
  initComponent : function() {
    var containing_panel = this;
    var start_date147 = new Lino.DateField({ "selectOnFocus": true, "fieldLabel": "Beginnt am", "anchor": "-20", "name": "start_date" });
    var due_date148 = new Lino.DateField({ "selectOnFocus": true, "fieldLabel": "Zahlungsziel", "anchor": "-20", "name": "due_date" });
    var id149 = new Ext.form.NumberField({ "selectOnFocus": true, "fieldLabel": "ID", "anchor": "-20", "name": "id" });
    var workflow_buttons_disp150 = new Ext.form.DisplayField({ "disabled": true, "fieldLabel": "Arbeitsablauf", "name": "workflow_buttons", "anchor": "-20", "value": "<br/>", "always_enabled": true });
    var main_1_panel151 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 126, "hideCheckBoxLabels": true, "items": [ { "flex": 15, "autoHeight": true, "layout": "form", "xtype": "panel", "items": start_date147, "labelAlign": "top" }, { "flex": 15, "autoHeight": true, "layout": "form", "xtype": "panel", "items": due_date148, "labelAlign": "top" }, { "flex": 9, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id149, "labelAlign": "top" }, { "flex": 58, "autoHeight": true, "layout": "form", "xtype": "panel", "items": workflow_buttons_disp150, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var summary156 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200, "fieldLabel": "Kurzbeschreibung", "anchor": "-20", "name": "summary" });
    var user157 = new Lino.TwinCombo({ "fieldLabel": "Autor", "name": "user", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.users.Users.detail)}, "emptyText": "Benutzer ausw\u00e4hlen...", "selectOnFocus": true, "hiddenName": "userHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/Tasks/user", "method": "GET" }) }) });
    var project158 = new Lino.TwinCombo({ "fieldLabel": "Klient", "name": "project", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.pcsw.Clients.detail)}, "emptyText": "Klient ausw\u00e4hlen...", "selectOnFocus": true, "hiddenName": "projectHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/Tasks/project", "method": "GET" }) }) });
    var main_3_panel159 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 63, "hideCheckBoxLabels": true, "items": [ { "flex": 42, "autoHeight": true, "layout": "form", "xtype": "panel", "items": user157, "labelAlign": "top" }, { "flex": 57, "autoHeight": true, "layout": "form", "xtype": "panel", "items": project158, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var calendar162 = new Lino.TwinCombo({ "fieldLabel": "Kalender", "name": "calendar", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.cal.Calendars.detail)}, "emptyText": "Kalender ausw\u00e4hlen...", "selectOnFocus": true, "hiddenName": "calendarHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/Tasks/calendar", "method": "GET" }) }) });
    var owner_disp163 = new Ext.form.DisplayField({ "disabled": true, "fieldLabel": "Verkn\u00fcpft mit", "anchor": "-20", "name": "owner" });
    var created164 = new Ext.form.DisplayField({ "disabled": true, "fieldLabel": "Erstellt", "anchor": "-20", "value": "<br>", "name": "created" });
    var modified165 = new Ext.form.DisplayField({ "disabled": true, "fieldLabel": "Bearbeitet", "anchor": "-20", "value": "<br>", "name": "modified" });
    var main_4_panel166 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 126, "hideCheckBoxLabels": true, "items": [ { "flex": 28, "autoHeight": true, "layout": "form", "xtype": "panel", "items": calendar162, "labelAlign": "top" }, { "flex": 14, "autoHeight": true, "layout": "form", "xtype": "panel", "items": owner_disp163, "labelAlign": "top" }, { "flex": 28, "autoHeight": true, "layout": "form", "xtype": "panel", "items": created164, "labelAlign": "top" }, { "flex": 28, "autoHeight": true, "layout": "form", "xtype": "panel", "items": modified165, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var description171 = new Lino.RichTextPanel({ "selectOnFocus": true, "flex": 45, "containing_panel": this, "name": "description", "title": "Beschreibung" });
    var main_panel172 = new Ext.Panel({ "autoScroll": false, "border": false, "layout": "vbox", "labelWidth": 153, "hideCheckBoxLabels": true, "items": [ main_1_panel151, { "items": summary156, "autoHeight": true, "layout": "form", "xtype": "panel", "labelAlign": "top" }, main_3_panel159, main_4_panel166, description171 ], "frame": true, "layoutConfig": { "align": "stretch" }, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel172;
    this.before_row_edit = function(record) {
      description171.refresh();
    }
    Lino.cal.Tasks.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.contacts.Partners.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 23,
  initComponent : function() {
    var containing_panel = this;
    var name353 = new Ext.form.TextField({ "fieldLabel": "Name", "name": "name", "maxLength": 200, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var country354 = new Lino.TwinCombo({ "fieldLabel": "Land", "name": "country", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.countries.Countries.detail)}, "emptyText": "Land ausw\u00e4hlen...", "selectOnFocus": true, "hiddenName": "countryHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/contacts/Partners/country", "method": "GET" }) }) });
    var region355 = new Lino.TwinCombo({ "fieldLabel": "Region", "name": "region", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.countries.Cities.detail)}, "emptyText": "Ort ausw\u00e4hlen...", "selectOnFocus": true, "hiddenName": "regionHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/contacts/Partners/region", "method": "GET" }) }) });
    var city356 = new Lino.TwinCombo({ "forceSelection": false, "fieldLabel": "Ort", "name": "city", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.countries.Cities.detail)}, "emptyText": "Ort ausw\u00e4hlen...", "selectOnFocus": true, "hiddenName": "cityHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/contacts/Partners/city", "method": "GET" }) }) });
    var zip_code357 = new Ext.form.TextField({ "fieldLabel": "Postleitzahl", "name": "zip_code", "maxLength": 10, "selectOnFocus": true, "boxMinWidth": Lino.chars2width(10), "anchor": "-20" });
    var address_box_2_panel358 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 28, "autoHeight": true, "layout": "form", "xtype": "panel", "items": country354, "labelAlign": "top" }, { "flex": 28, "autoHeight": true, "layout": "form", "xtype": "panel", "items": region355, "labelAlign": "top" }, { "flex": 28, "autoHeight": true, "layout": "form", "xtype": "panel", "items": city356, "labelAlign": "top" }, { "flex": 14, "autoHeight": true, "layout": "form", "xtype": "panel", "items": zip_code357, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 117, "border": false, "anchor": "-20", "labelAlign": "top" });
    var addr1363 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Adresszeile vor Stra\u00dfe","Address line before street") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Adresszeile vor Stra\u00dfe</span>", "name": "addr1", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var street_prefix364 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Pr\u00e4fix Stra\u00dfe","Text to print before name of street, but to ignore for sorting.") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Pr\u00e4fix Stra\u00dfe</span>", "name": "street_prefix", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var street365 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Stra\u00dfe","Name of street. Without house number.") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Stra\u00dfe</span>", "name": "street", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var street_no366 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Nr.","House number") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Nr.</span>", "name": "street_no", "maxLength": 10, "selectOnFocus": true, "boxMinWidth": Lino.chars2width(10), "anchor": "-20" });
    var street_box367 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Box","Text to print after :attr:`steet_no` on the same line") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Box</span>", "name": "street_box", "maxLength": 10, "selectOnFocus": true, "boxMinWidth": Lino.chars2width(10), "anchor": "-20" });
    var address_box_4_panel368 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 30, "autoHeight": true, "layout": "form", "xtype": "panel", "items": street_prefix364, "labelAlign": "top" }, { "flex": 36, "autoHeight": true, "layout": "form", "xtype": "panel", "items": street365, "labelAlign": "top" }, { "flex": 16, "autoHeight": true, "layout": "form", "xtype": "panel", "items": street_no366, "labelAlign": "top" }, { "flex": 16, "autoHeight": true, "layout": "form", "xtype": "panel", "items": street_box367, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 126, "border": false, "anchor": "-20", "labelAlign": "top" });
    var addr2373 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Adresszeile nach Stra\u00dfe","Address line to print below street line") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Adresszeile nach Stra\u00dfe</span>", "name": "addr2", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var address_box_panel374 = new Ext.form.FieldSet({ "flex": 66, "autoHeight": true, "layout": "form", "title": "Adresse", "items": [ { "autoHeight": true, "layout": "form", "xtype": "panel", "items": name353, "anchor": "-20", "labelAlign": "top" }, address_box_2_panel358, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": addr1363, "anchor": "-20", "labelAlign": "top" }, address_box_4_panel368, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": addr2373, "anchor": "-20", "labelAlign": "top" } ], "frame": true, "bodyBorder": false, "autoScroll": false, "hideCheckBoxLabels": true, "labelWidth": 216, "border": false, "labelAlign": "top" });
    var id378 = new Ext.form.NumberField({ "selectOnFocus": true, "fieldLabel": "ID", "anchor": "-20", "name": "id" });
    var language379 = new Lino.ChoicesFieldElement({ "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Sprache</span>", "allowBlank": false, "value": "de", "hiddenName": "languageHidden", "listeners": { "render": Lino.quicktip_renderer("Sprache","Die Sprache, in der Dokumente ausgestellt werden sollen.") }, "selectOnFocus": true, "anchor": "-20", "store": [ [ "de", "Deutsch" ], [ "fr", "Franz\u00f6sisch" ], [ "nl", "Niederl\u00e4ndisch" ] ], "name": "language" });
    var info_box_panel380 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 20, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id378, "labelAlign": "top" }, { "flex": 80, "autoHeight": true, "layout": "form", "xtype": "panel", "items": language379, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 72, "border": false, "anchor": "-20", "labelAlign": "top" });
    var email383 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 75, "fieldLabel": "E-Mail", "anchor": "-20", "name": "email" });
    var url384 = new Lino.URLField({ "selectOnFocus": true, "maxLength": 200, "fieldLabel": "URL", "anchor": "-20", "name": "url" });
    var phone385 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200, "fieldLabel": "Telefon", "anchor": "-20", "name": "phone" });
    var gsm386 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200, "fieldLabel": "GSM", "anchor": "-20", "name": "gsm" });
    var fax387 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200, "fieldLabel": "Fax", "anchor": "-20", "name": "fax" });
    var contact_box_5_panel388 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": gsm386, "labelAlign": "top" }, { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": fax387, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 36, "border": false, "anchor": "-20", "labelAlign": "top" });
    var contact_box_panel391 = new Ext.form.FieldSet({ "flex": 33, "autoHeight": true, "layout": "form", "title": "Kontakt", "items": [ info_box_panel380, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": email383, "anchor": "-20", "labelAlign": "top" }, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": url384, "anchor": "-20", "labelAlign": "top" }, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": phone385, "anchor": "-20", "labelAlign": "top" }, contact_box_5_panel388 ], "frame": true, "bodyBorder": false, "autoScroll": false, "hideCheckBoxLabels": true, "labelWidth": 72, "border": false, "labelAlign": "top" });
    var general_1_panel395 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "hideCheckBoxLabels": true, "items": [ address_box_panel374, contact_box_panel391 ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var remarks396 = new Ext.form.TextArea({ "selectOnFocus": true, "fieldLabel": "Bemerkungen", "anchor": "-20 -10", "growMax": 2000, "name": "remarks" });
    var activity397 = new Lino.RemoteComboFieldElement({ "fieldLabel": "Beruf", "name": "activity", "pageSize": 20, "emptyText": "Beruf ausw\u00e4hlen...", "selectOnFocus": true, "hiddenName": "activityHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/contacts/Partners/activity", "method": "GET" }) }) });
    var bank_account1398 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 40, "fieldLabel": "Bankkonto 1", "anchor": "-20", "name": "bank_account1" });
    var bank_account2399 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 40, "fieldLabel": "Bankkonto 2", "anchor": "-20", "name": "bank_account2" });
    var is_obsolete400 = new Ext.form.Checkbox({ "boxLabel": "veraltet", "listeners": { "render": Lino.quicktip_renderer("veraltet","Altf\u00e4lle sind Partner, deren Stammdaten nicht mehr gepflegt werden und \nf\u00fcr neue Operationen nicht benutzt werden k\u00f6nnen.") }, "hideLabel": true, "checked": false, "name": "is_obsolete", "selectOnFocus": true, "anchor": "-20" });
    var bottom_box_2_panel401 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 108, "hideCheckBoxLabels": true, "items": [ { "flex": 27, "autoHeight": true, "layout": "form", "xtype": "panel", "items": activity397, "labelAlign": "top" }, { "flex": 29, "autoHeight": true, "layout": "form", "xtype": "panel", "items": bank_account1398, "labelAlign": "top" }, { "flex": 29, "autoHeight": true, "layout": "form", "xtype": "panel", "items": bank_account2399, "labelAlign": "top" }, { "flex": 13, "autoHeight": true, "layout": "form", "xtype": "panel", "items": is_obsolete400, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var is_person406 = new Ext.form.Checkbox({ "boxLabel": "ist eine Person (<a href=\"javascript:Lino.show_mti_child('is_person',Lino.contacts.Persons.detail)\">zeigen</a>)", "listeners": { "render": Lino.quicktip_renderer("ist eine Person","Ob dieser Partner auch eine Person ist.") }, "hideLabel": true, "name": "is_person", "selectOnFocus": true, "anchor": "-20" });
    var is_company407 = new Ext.form.Checkbox({ "boxLabel": "ist eine Organisation (<a href=\"javascript:Lino.show_mti_child('is_company',Lino.contacts.Companies.detail)\">zeigen</a>)", "listeners": { "render": Lino.quicktip_renderer("ist eine Organisation","Ob dieser Partner auch eine Organisation ist.") }, "hideLabel": true, "name": "is_company", "selectOnFocus": true, "anchor": "-20" });
    var is_household408 = new Ext.form.Checkbox({ "selectOnFocus": true, "boxLabel": "ist ein Haushalt (<a href=\"javascript:Lino.show_mti_child('is_household',Lino.households.Households.detail)\">zeigen</a>)", "hideLabel": true, "anchor": "-20", "name": "is_household" });
    var created409 = new Ext.form.DisplayField({ "disabled": true, "fieldLabel": "Erstellt", "anchor": "-20", "value": "<br>", "name": "created" });
    var modified410 = new Ext.form.DisplayField({ "disabled": true, "fieldLabel": "Bearbeitet", "anchor": "-20", "value": "<br>", "name": "modified" });
    var bottom_box_3_panel411 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 198, "hideCheckBoxLabels": true, "items": [ { "flex": 16, "autoHeight": true, "layout": "form", "xtype": "panel", "items": is_person406, "labelAlign": "top" }, { "flex": 16, "autoHeight": true, "layout": "form", "xtype": "panel", "items": is_company407, "labelAlign": "top" }, { "flex": 16, "autoHeight": true, "layout": "form", "xtype": "panel", "items": is_household408, "labelAlign": "top" }, { "flex": 25, "autoHeight": true, "layout": "form", "xtype": "panel", "items": created409, "labelAlign": "top" }, { "flex": 25, "autoHeight": true, "layout": "form", "xtype": "panel", "items": modified410, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var bottom_box_panel417 = new Ext.Panel({ "flex": 58, "layout": "vbox", "items": [ { "items": remarks396, "labelAlign": "top", "layout": "form", "xtype": "panel", "flex": 71 }, bottom_box_2_panel401, bottom_box_3_panel411 ], "frame": true, "layoutConfig": { "align": "stretch" }, "autoScroll": false, "hideCheckBoxLabels": true, "labelWidth": 108, "border": false, "bodyBorder": false, "labelAlign": "top" });
    var general_panel419 = new Ext.Panel({ "layout": "vbox", "title": "Allgemein", "items": [ general_1_panel395, bottom_box_panel417 ], "frame": true, "layoutConfig": { "align": "stretch" }, "hideCheckBoxLabels": true, "listeners": { "activate": Lino.on_tab_activate }, "autoScroll": false, "border": false, "bodyBorder": false, "labelAlign": "top" });
    var changes_ChangesByMaster_grid428 = new Lino.changes.ChangesByMaster.GridPanel({ "listeners": { "activate": Lino.on_tab_activate }, "hide_top_toolbar": true, "title": "\u00c4nderungen", "containing_panel": this, "tools": [ Lino.show_in_own_window_button(Lino.changes.ChangesByMaster.grid) ], "master_panel": this });
    var debts_BudgetsByPartner_grid533 = new Lino.debts.BudgetsByPartner.GridPanel({ "flex": 5, "hide_top_toolbar": true, "split": true, "containing_panel": this, "region": "north", "tools": [ Lino.show_in_own_window_button(Lino.debts.BudgetsByPartner.grid) ], "master_panel": this });
    var debts_ActorsByPartner_grid541 = new Lino.debts.ActorsByPartner.GridPanel({ "flex": 5, "hide_top_toolbar": true, "split": true, "containing_panel": this, "region": "center", "tools": [ Lino.show_in_own_window_button(Lino.debts.ActorsByPartner.grid) ], "master_panel": this });
    var debts_panel542 = new Lino.VBorderPanel({ "autoScroll": false, "listeners": { "activate": Lino.on_tab_activate }, "border": false, "title": "Schuldnerberatung", "hideCheckBoxLabels": true, "items": [ debts_BudgetsByPartner_grid533, debts_ActorsByPartner_grid541 ], "frame": true, "bodyBorder": false, "labelAlign": "top" });
    var main_panel543 = new Ext.TabPanel({ "hideCheckBoxLabels": true, "border": false, "split": true, "autoScroll": false, "items": [ general_panel419, changes_ChangesByMaster_grid428, debts_panel542 ], "activeTab": 0, "bodyBorder": false, "frame": true, "labelAlign": "top" });
    this.items = main_panel543;
    this.before_row_edit = function(record) {
      region355.setContextValue('country',record ? record.data['countryHidden'] : undefined);
      city356.setContextValue('country',record ? record.data['countryHidden'] : undefined);
      city356.setContextValue('region',record ? record.data['regionHidden'] : undefined);
      changes_ChangesByMaster_grid428.on_master_changed();
      debts_BudgetsByPartner_grid533.on_master_changed();
      debts_ActorsByPartner_grid541.on_master_changed();
    }
    this.onRender = function(ct, position) {
      country354.on('change',Lino.chooser_handler(region355,'country'));
      country354.on('change',Lino.chooser_handler(city356,'country'));
      region355.on('change',Lino.chooser_handler(city356,'region'));
      Lino.contacts.Partners.DetailFormPanel.superclass.onRender.call(this, ct, position);
    }
    Lino.contacts.Partners.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.countries.CitiesByCity.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 13,
  initComponent : function() {
    var containing_panel = this;
    var name282 = new Ext.form.TextField({ "fieldLabel": "Bezeichnung", "name": "name", "maxLength": 200, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var name_fr283 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200, "fieldLabel": "Bezeichnung (fr)", "anchor": "-20", "name": "name_fr" });
    var name_nl284 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200, "fieldLabel": "Bezeichnung (nl)", "anchor": "-20", "name": "name_nl" });
    var country285 = new Lino.TwinCombo({ "fieldLabel": "Land", "allowBlank": false, "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.countries.Countries.detail)}, "emptyText": "Land ausw\u00e4hlen...", "selectOnFocus": true, "hiddenName": "countryHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/countries/Cities/country", "method": "GET" }) }), "name": "country" });
    var inscode286 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("INS-Code","The official code for this place used by statbel.fgov.be") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">INS-Code</span>", "name": "inscode", "maxLength": 5, "selectOnFocus": true, "boxMinWidth": Lino.chars2width(5), "anchor": "-20" });
    var main_1_panel287 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 153, "hideCheckBoxLabels": true, "items": [ { "flex": 23, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name282, "labelAlign": "top" }, { "flex": 23, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_fr283, "labelAlign": "top" }, { "flex": 23, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_nl284, "labelAlign": "top" }, { "flex": 22, "autoHeight": true, "layout": "form", "xtype": "panel", "items": country285, "labelAlign": "top" }, { "flex": 6, "autoHeight": true, "layout": "form", "xtype": "panel", "items": inscode286, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var parent293 = new Lino.TwinCombo({ "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Teil von</span>", "name": "parent", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.countries.Cities.detail)}, "emptyText": "Ort ausw\u00e4hlen...", "listeners": { "render": Lino.quicktip_renderer("Teil von","The superordinate geographic place of which this place is a part.") }, "selectOnFocus": true, "hiddenName": "parentHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/countries/Cities/parent", "method": "GET" }) }) });
    var type294 = new Lino.RemoteComboFieldElement({ "fieldLabel": "Ortsart", "name": "type", "selectOnFocus": true, "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/countries/Cities/type", "method": "GET" }) }), "hiddenName": "typeHidden" });
    var id295 = new Ext.form.NumberField({ "selectOnFocus": true, "fieldLabel": "ID", "anchor": "-20", "name": "id" });
    var main_2_panel296 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 81, "hideCheckBoxLabels": true, "items": [ { "flex": 57, "autoHeight": true, "layout": "form", "xtype": "panel", "items": parent293, "labelAlign": "top" }, { "flex": 28, "autoHeight": true, "layout": "form", "xtype": "panel", "items": type294, "labelAlign": "top" }, { "flex": 14, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id295, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var CitiesByCity_grid568 = new Lino.countries.CitiesByCity.GridPanel({ "tools": [ Lino.show_in_own_window_button(Lino.countries.CitiesByCity.grid) ], "containing_panel": this, "hide_top_toolbar": true, "master_panel": this, "flex": 41 });
    var contacts_PartnersByCity_grid569 = new Lino.contacts.PartnersByCity.GridPanel({ "tools": [ Lino.show_in_own_window_button(Lino.contacts.PartnersByCity.grid) ], "containing_panel": this, "hide_top_toolbar": true, "master_panel": this, "flex": 50 });
    var main_4_panel571 = new Ext.Panel({ "flex": 41, "border": false, "layout": "hbox", "hideCheckBoxLabels": true, "items": [ contacts_PartnersByCity_grid569 ], "autoScroll": false, "layoutConfig": { "align": "stretch" }, "frame": false, "labelAlign": "top" });
    var main_panel572 = new Ext.Panel({ "autoScroll": false, "border": false, "layout": "vbox", "hideCheckBoxLabels": true, "items": [ main_1_panel287, main_2_panel296, CitiesByCity_grid568, main_4_panel571 ], "frame": true, "layoutConfig": { "align": "stretch" }, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel572;
    this.before_row_edit = function(record) {
      type294.setContextValue('country',record ? record.data['countryHidden'] : undefined);
      CitiesByCity_grid568.on_master_changed();
      contacts_PartnersByCity_grid569.on_master_changed();
    }
    this.onRender = function(ct, position) {
      country285.on('change',Lino.chooser_handler(type294,'country'));
      Lino.countries.CitiesByCity.DetailFormPanel.superclass.onRender.call(this, ct, position);
    }
    Lino.countries.CitiesByCity.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.cal.MyEvents.InsertFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  autoHeight: true,
  content_type: 36,
  initComponent : function() {
    var containing_panel = this;
    var summary905 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200, "fieldLabel": "Kurzbeschreibung", "anchor": "-20", "name": "summary" });
    var start_date906 = new Lino.DateField({ "selectOnFocus": true, "fieldLabel": "Beginnt am", "anchor": "-20", "name": "start_date" });
    var start_time907 = new Lino.TimeField({ "selectOnFocus": true, "fieldLabel": "Beginnt um", "anchor": "-20", "name": "start_time" });
    var start_panel908 = new Ext.Panel({ "flex": 50, "autoHeight": true, "layout": "hbox", "items": [ { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": start_date906, "labelAlign": "top" }, { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": start_time907, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "autoScroll": false, "hideCheckBoxLabels": true, "labelWidth": 99, "border": false, "labelAlign": "top" });
    var end_date911 = new Lino.DateField({ "selectOnFocus": true, "fieldLabel": "Endet am", "anchor": "-20", "name": "end_date" });
    var end_time912 = new Lino.TimeField({ "selectOnFocus": true, "fieldLabel": "Endet um", "anchor": "-20", "name": "end_time" });
    var end_panel913 = new Ext.Panel({ "flex": 50, "autoHeight": true, "layout": "hbox", "items": [ { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": end_date911, "labelAlign": "top" }, { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": end_time912, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "autoScroll": false, "hideCheckBoxLabels": true, "labelWidth": 81, "border": false, "labelAlign": "top" });
    var main_2_panel916 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "hideCheckBoxLabels": true, "items": [ start_panel908, end_panel913 ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "anchor": "-20", "labelAlign": "top" });
    var calendar917 = new Lino.TwinCombo({ "fieldLabel": "Kalender", "name": "calendar", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.cal.Calendars.detail)}, "emptyText": "Kalender ausw\u00e4hlen...", "selectOnFocus": true, "hiddenName": "calendarHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/Events/calendar", "method": "GET" }) }) });
    var project918 = new Lino.TwinCombo({ "fieldLabel": "Klient", "name": "project", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.pcsw.Clients.detail)}, "emptyText": "Klient ausw\u00e4hlen...", "selectOnFocus": true, "hiddenName": "projectHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/Events/project", "method": "GET" }) }) });
    var main_3_panel919 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": calendar917, "labelAlign": "top" }, { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": project918, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 81, "border": false, "anchor": "-20", "labelAlign": "top" });
    var main_panel922 = new Ext.Panel({ "hideCheckBoxLabels": true, "autoHeight": true, "border": false, "layout": "form", "labelWidth": 153, "autoScroll": false, "items": [ { "autoHeight": true, "layout": "form", "xtype": "panel", "items": summary905, "anchor": "-20", "labelAlign": "top" }, main_2_panel916, main_3_panel919 ], "frame": true, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel922;
    this.before_row_edit = function(record) {
    }
    Lino.cal.MyEvents.InsertFormPanel.superclass.initComponent.call(this);
  }
});


Lino.contacts.Companies.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 20,
  initComponent : function() {
    var containing_panel = this;
    var prefix589 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200, "fieldLabel": "prefix", "anchor": "-20", "name": "prefix" });
    var name590 = new Ext.form.TextField({ "fieldLabel": "Name", "name": "name", "maxLength": 200, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var id591 = new Ext.form.NumberField({ "selectOnFocus": true, "fieldLabel": "ID", "anchor": "-20", "name": "id" });
    var language592 = new Lino.ChoicesFieldElement({ "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Sprache</span>", "allowBlank": false, "value": "de", "hiddenName": "languageHidden", "listeners": { "render": Lino.quicktip_renderer("Sprache","Die Sprache, in der Dokumente ausgestellt werden sollen.") }, "selectOnFocus": true, "anchor": "-20", "store": [ [ "de", "Deutsch" ], [ "fr", "Franz\u00f6sisch" ], [ "nl", "Niederl\u00e4ndisch" ] ], "name": "language" });
    var intro_box_1_panel593 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 31, "autoHeight": true, "layout": "form", "xtype": "panel", "items": prefix589, "labelAlign": "top" }, { "flex": 31, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name590, "labelAlign": "top" }, { "flex": 7, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id591, "labelAlign": "top" }, { "flex": 29, "autoHeight": true, "layout": "form", "xtype": "panel", "items": language592, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 72, "border": false, "anchor": "-20", "labelAlign": "top" });
    var vat_id598 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200, "fieldLabel": "MWSt.-Nr.", "anchor": "-20", "name": "vat_id" });
    var activity599 = new Lino.RemoteComboFieldElement({ "fieldLabel": "Beruf", "name": "activity", "pageSize": 20, "emptyText": "Beruf ausw\u00e4hlen...", "selectOnFocus": true, "hiddenName": "activityHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/contacts/Companies/activity", "method": "GET" }) }) });
    var type600 = new Lino.RemoteComboFieldElement({ "fieldLabel": "Organisationsart", "name": "type", "pageSize": 20, "emptyText": "Organisationsart ausw\u00e4hlen...", "selectOnFocus": true, "hiddenName": "typeHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/contacts/Companies/type", "method": "GET" }) }) });
    var intro_box_2_panel601 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 23, "autoHeight": true, "layout": "form", "xtype": "panel", "items": vat_id598, "labelAlign": "top" }, { "flex": 38, "autoHeight": true, "layout": "form", "xtype": "panel", "items": activity599, "labelAlign": "top" }, { "flex": 38, "autoHeight": true, "layout": "form", "xtype": "panel", "items": type600, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 153, "border": false, "anchor": "-20", "labelAlign": "top" });
    var bank_account1605 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 40, "fieldLabel": "Bankkonto 1", "anchor": "-20", "name": "bank_account1" });
    var bank_account2606 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 40, "fieldLabel": "Bankkonto 2", "anchor": "-20", "name": "bank_account2" });
    var is_obsolete607 = new Ext.form.Checkbox({ "boxLabel": "veraltet", "listeners": { "render": Lino.quicktip_renderer("veraltet","Altf\u00e4lle sind Partner, deren Stammdaten nicht mehr gepflegt werden und \nf\u00fcr neue Operationen nicht benutzt werden k\u00f6nnen.") }, "hideLabel": true, "checked": false, "name": "is_obsolete", "selectOnFocus": true, "anchor": "-20" });
    var intro_box_3_panel608 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 40, "autoHeight": true, "layout": "form", "xtype": "panel", "items": bank_account1605, "labelAlign": "top" }, { "flex": 40, "autoHeight": true, "layout": "form", "xtype": "panel", "items": bank_account2606, "labelAlign": "top" }, { "flex": 19, "autoHeight": true, "layout": "form", "xtype": "panel", "items": is_obsolete607, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 108, "border": false, "anchor": "-20", "labelAlign": "top" });
    var intro_box_panel612 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "form", "hideCheckBoxLabels": true, "items": [ intro_box_1_panel593, intro_box_2_panel601, intro_box_3_panel608 ], "frame": true, "bodyBorder": false, "labelAlign": "top" });
    var country613 = new Lino.TwinCombo({ "fieldLabel": "Land", "name": "country", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.countries.Countries.detail)}, "emptyText": "Land ausw\u00e4hlen...", "selectOnFocus": true, "hiddenName": "countryHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/contacts/Companies/country", "method": "GET" }) }) });
    var region614 = new Lino.TwinCombo({ "fieldLabel": "Region", "name": "region", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.countries.Cities.detail)}, "emptyText": "Ort ausw\u00e4hlen...", "selectOnFocus": true, "hiddenName": "regionHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/contacts/Companies/region", "method": "GET" }) }) });
    var box3_1_panel615 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": country613, "labelAlign": "top" }, { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": region614, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 63, "border": false, "anchor": "-20", "labelAlign": "top" });
    var city618 = new Lino.TwinCombo({ "forceSelection": false, "fieldLabel": "Ort", "name": "city", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.countries.Cities.detail)}, "emptyText": "Ort ausw\u00e4hlen...", "selectOnFocus": true, "hiddenName": "cityHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/contacts/Companies/city", "method": "GET" }) }) });
    var zip_code619 = new Ext.form.TextField({ "fieldLabel": "Postleitzahl", "name": "zip_code", "maxLength": 10, "selectOnFocus": true, "boxMinWidth": Lino.chars2width(10), "anchor": "-20" });
    var box3_2_panel620 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 66, "autoHeight": true, "layout": "form", "xtype": "panel", "items": city618, "labelAlign": "top" }, { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": zip_code619, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 117, "border": false, "anchor": "-20", "labelAlign": "top" });
    var street_prefix623 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Pr\u00e4fix Stra\u00dfe","Text to print before name of street, but to ignore for sorting.") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Pr\u00e4fix Stra\u00dfe</span>", "name": "street_prefix", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var street624 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Stra\u00dfe","Name of street. Without house number.") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Stra\u00dfe</span>", "name": "street", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var street_no625 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Nr.","House number") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Nr.</span>", "name": "street_no", "maxLength": 10, "selectOnFocus": true, "boxMinWidth": Lino.chars2width(10), "anchor": "-20" });
    var street_box626 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Box","Text to print after :attr:`steet_no` on the same line") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Box</span>", "name": "street_box", "maxLength": 10, "selectOnFocus": true, "boxMinWidth": Lino.chars2width(10), "anchor": "-20" });
    var box3_3_panel627 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 30, "autoHeight": true, "layout": "form", "xtype": "panel", "items": street_prefix623, "labelAlign": "top" }, { "flex": 36, "autoHeight": true, "layout": "form", "xtype": "panel", "items": street624, "labelAlign": "top" }, { "flex": 16, "autoHeight": true, "layout": "form", "xtype": "panel", "items": street_no625, "labelAlign": "top" }, { "flex": 16, "autoHeight": true, "layout": "form", "xtype": "panel", "items": street_box626, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 126, "border": false, "anchor": "-20", "labelAlign": "top" });
    var addr2632 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Adresszeile nach Stra\u00dfe","Address line to print below street line") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Adresszeile nach Stra\u00dfe</span>", "name": "addr2", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var box3_panel633 = new Ext.Panel({ "flex": 62, "autoHeight": true, "layout": "form", "items": [ box3_1_panel615, box3_2_panel620, box3_3_panel627, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": addr2632, "anchor": "-20", "labelAlign": "top" } ], "frame": true, "bodyBorder": false, "autoScroll": false, "hideCheckBoxLabels": true, "labelWidth": 216, "border": false, "labelAlign": "top" });
    var email635 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 75, "fieldLabel": "E-Mail", "anchor": "-20", "name": "email" });
    var url636 = new Lino.URLField({ "selectOnFocus": true, "maxLength": 200, "fieldLabel": "URL", "anchor": "-20", "name": "url" });
    var phone637 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200, "fieldLabel": "Telefon", "anchor": "-20", "name": "phone" });
    var gsm638 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200, "fieldLabel": "GSM", "anchor": "-20", "name": "gsm" });
    var box4_panel639 = new Ext.Panel({ "flex": 37, "autoHeight": true, "layout": "form", "items": [ { "autoHeight": true, "layout": "form", "xtype": "panel", "items": email635, "anchor": "-20", "labelAlign": "top" }, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": url636, "anchor": "-20", "labelAlign": "top" }, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": phone637, "anchor": "-20", "labelAlign": "top" }, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": gsm638, "anchor": "-20", "labelAlign": "top" } ], "frame": true, "bodyBorder": false, "autoScroll": false, "hideCheckBoxLabels": true, "labelWidth": 72, "border": false, "labelAlign": "top" });
    var address_box_panel644 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "hideCheckBoxLabels": true, "items": [ box3_panel633, box4_panel639 ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var remarks645 = new Ext.form.TextArea({ "selectOnFocus": true, "fieldLabel": "Bemerkungen", "anchor": "-20 -10", "growMax": 2000, "name": "remarks" });
    var is_courseprovider646 = new Ext.form.Checkbox({ "selectOnFocus": true, "boxLabel": "ist Kursanbieter (<a href=\"javascript:Lino.show_mti_child('is_courseprovider',Lino.courses.CourseProviders.detail)\">zeigen</a>)", "hideLabel": true, "anchor": "-20", "name": "is_courseprovider" });
    var is_jobprovider647 = new Ext.form.Checkbox({ "selectOnFocus": true, "boxLabel": "Stellenanbieter (<a href=\"javascript:Lino.show_mti_child('is_jobprovider',Lino.jobs.JobProviders.detail)\">zeigen</a>)", "hideLabel": true, "anchor": "-20", "name": "is_jobprovider" });
    var client_contact_type648 = new Lino.RemoteComboFieldElement({ "fieldLabel": "Klientenkontaktart", "name": "client_contact_type", "pageSize": 20, "emptyText": "Klientenkontaktart ausw\u00e4hlen...", "selectOnFocus": true, "hiddenName": "client_contact_typeHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/contacts/Companies/client_contact_type", "method": "GET" }) }) });
    var box5_2_panel649 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 171, "hideCheckBoxLabels": true, "items": [ { "flex": 25, "autoHeight": true, "layout": "form", "xtype": "panel", "items": is_courseprovider646, "labelAlign": "top" }, { "flex": 25, "autoHeight": true, "layout": "form", "xtype": "panel", "items": is_jobprovider647, "labelAlign": "top" }, { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": client_contact_type648, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var box5_panel653 = new Ext.Panel({ "flex": 57, "layout": "vbox", "items": [ { "items": remarks645, "labelAlign": "top", "layout": "form", "xtype": "panel", "flex": 83 }, box5_2_panel649 ], "frame": true, "layoutConfig": { "align": "stretch" }, "autoScroll": false, "hideCheckBoxLabels": true, "labelWidth": 108, "border": false, "bodyBorder": false, "labelAlign": "top" });
    var contacts_RolesByCompany_grid659 = new Lino.contacts.RolesByCompany.GridPanel({ "tools": [ Lino.show_in_own_window_button(Lino.contacts.RolesByCompany.grid) ], "containing_panel": this, "hide_top_toolbar": true, "master_panel": this, "flex": 42 });
    var bottom_box_panel660 = new Ext.Panel({ "flex": 46, "border": false, "layout": "hbox", "hideCheckBoxLabels": true, "items": [ box5_panel653, contacts_RolesByCompany_grid659 ], "autoScroll": false, "layoutConfig": { "align": "stretch" }, "frame": false, "labelAlign": "top" });
    var general_panel661 = new Ext.Panel({ "layout": "vbox", "title": "Allgemein", "items": [ intro_box_panel612, address_box_panel644, bottom_box_panel660 ], "frame": true, "layoutConfig": { "align": "stretch" }, "hideCheckBoxLabels": true, "listeners": { "activate": Lino.on_tab_activate }, "autoScroll": false, "border": false, "bodyBorder": false, "labelAlign": "top" });
    var pcsw_NotesByCompany_grid781 = new Lino.pcsw.NotesByCompany.GridPanel({ "listeners": { "activate": Lino.on_tab_activate }, "hide_top_toolbar": true, "title": "Ereignisse/Notizen", "containing_panel": this, "tools": [ Lino.show_in_own_window_button(Lino.pcsw.NotesByCompany.grid) ], "master_panel": this });
    var main_panel782 = new Ext.TabPanel({ "hideCheckBoxLabels": true, "border": false, "split": true, "autoScroll": false, "items": [ general_panel661, pcsw_NotesByCompany_grid781 ], "activeTab": 0, "bodyBorder": false, "frame": true, "labelAlign": "top" });
    this.items = main_panel782;
    this.before_row_edit = function(record) {
      region614.setContextValue('country',record ? record.data['countryHidden'] : undefined);
      city618.setContextValue('country',record ? record.data['countryHidden'] : undefined);
      city618.setContextValue('region',record ? record.data['regionHidden'] : undefined);
      contacts_RolesByCompany_grid659.on_master_changed();
      pcsw_NotesByCompany_grid781.on_master_changed();
    }
    this.onRender = function(ct, position) {
      country613.on('change',Lino.chooser_handler(region614,'country'));
      country613.on('change',Lino.chooser_handler(city618,'country'));
      region614.on('change',Lino.chooser_handler(city618,'region'));
      Lino.contacts.Companies.DetailFormPanel.superclass.onRender.call(this, ct, position);
    }
    Lino.contacts.Companies.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.contacts.Partners.InsertFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  autoHeight: true,
  content_type: 23,
  initComponent : function() {
    var containing_panel = this;
    var name544 = new Ext.form.TextField({ "fieldLabel": "Name", "name": "name", "maxLength": 200, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var language545 = new Lino.ChoicesFieldElement({ "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Sprache</span>", "allowBlank": false, "value": "de", "hiddenName": "languageHidden", "listeners": { "render": Lino.quicktip_renderer("Sprache","Die Sprache, in der Dokumente ausgestellt werden sollen.") }, "selectOnFocus": true, "anchor": "-20", "store": [ [ "de", "Deutsch" ], [ "fr", "Franz\u00f6sisch" ], [ "nl", "Niederl\u00e4ndisch" ] ], "name": "language" });
    var email546 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 75, "fieldLabel": "E-Mail", "anchor": "-20", "name": "email" });
    var main_2_panel547 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 48, "autoHeight": true, "layout": "form", "xtype": "panel", "items": language545, "labelAlign": "top" }, { "flex": 51, "autoHeight": true, "layout": "form", "xtype": "panel", "items": email546, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 72, "border": false, "anchor": "-20", "labelAlign": "top" });
    var main_panel550 = new Ext.Panel({ "hideCheckBoxLabels": true, "autoHeight": true, "border": false, "layout": "form", "labelWidth": 45, "autoScroll": false, "items": [ { "autoHeight": true, "layout": "form", "xtype": "panel", "items": name544, "anchor": "-20", "labelAlign": "top" }, main_2_panel547 ], "frame": true, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel550;
    this.before_row_edit = function(record) {
    }
    Lino.contacts.Partners.InsertFormPanel.superclass.initComponent.call(this);
  }
});


Lino.contacts.Persons.InsertFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  autoHeight: true,
  content_type: 21,
  initComponent : function() {
    var containing_panel = this;
    var title1386 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200, "fieldLabel": "Anrede", "anchor": "-20", "name": "title" });
    var first_name1387 = new Ext.form.TextField({ "fieldLabel": "Vorname", "name": "first_name", "maxLength": 200, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var last_name1388 = new Ext.form.TextField({ "fieldLabel": "Familienname", "name": "last_name", "maxLength": 200, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var main_1_panel1389 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": title1386, "labelAlign": "top" }, { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": first_name1387, "labelAlign": "top" }, { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": last_name1388, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 117, "border": false, "anchor": "-20", "labelAlign": "top" });
    var gender1393 = new Lino.ChoicesFieldElement({ "forceSelection": true, "fieldLabel": "Geschlecht", "name": "gender", "selectOnFocus": true, "anchor": "-20", "store": Lino.lino.Genders, "hiddenName": "genderHidden" });
    var language1394 = new Lino.ChoicesFieldElement({ "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Sprache</span>", "allowBlank": false, "value": "de", "hiddenName": "languageHidden", "listeners": { "render": Lino.quicktip_renderer("Sprache","Die Sprache, in der Dokumente ausgestellt werden sollen.") }, "selectOnFocus": true, "anchor": "-20", "store": [ [ "de", "Deutsch" ], [ "fr", "Franz\u00f6sisch" ], [ "nl", "Niederl\u00e4ndisch" ] ], "name": "language" });
    var main_2_panel1395 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 35, "autoHeight": true, "layout": "form", "xtype": "panel", "items": gender1393, "labelAlign": "top" }, { "flex": 64, "autoHeight": true, "layout": "form", "xtype": "panel", "items": language1394, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 99, "border": false, "anchor": "-20", "labelAlign": "top" });
    var main_panel1398 = new Ext.Panel({ "hideCheckBoxLabels": true, "autoHeight": true, "border": false, "layout": "form", "autoScroll": false, "items": [ main_1_panel1389, main_2_panel1395 ], "frame": true, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel1398;
    this.before_row_edit = function(record) {
    }
    Lino.contacts.Persons.InsertFormPanel.superclass.initComponent.call(this);
  }
});


Lino.ui.TextFieldTemplates.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 1,
  initComponent : function() {
    var containing_panel = this;
    var id57 = new Ext.form.NumberField({ "selectOnFocus": true, "fieldLabel": "ID", "anchor": "-20", "name": "id" });
    var name58 = new Ext.form.TextField({ "fieldLabel": "Bezeichnung", "name": "name", "maxLength": 200, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var user59 = new Lino.TwinCombo({ "fieldLabel": "Autor", "name": "user", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.users.Users.detail)}, "emptyText": "Benutzer ausw\u00e4hlen...", "selectOnFocus": true, "hiddenName": "userHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/ui/TextFieldTemplates/user", "method": "GET" }) }) });
    var team60 = new Lino.RemoteComboFieldElement({ "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Team</span>", "name": "team", "pageSize": 20, "emptyText": "Team ausw\u00e4hlen...", "listeners": { "render": Lino.quicktip_renderer("Team","If not empty, then this template is reserved to members of this team.") }, "selectOnFocus": true, "hiddenName": "teamHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/ui/TextFieldTemplates/team", "method": "GET" }) }) });
    var main_1_panel61 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 8, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id57, "labelAlign": "top" }, { "flex": 34, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name58, "labelAlign": "top" }, { "flex": 24, "autoHeight": true, "layout": "form", "xtype": "panel", "items": user59, "labelAlign": "top" }, { "flex": 32, "autoHeight": true, "layout": "form", "xtype": "panel", "items": team60, "labelAlign": "top" } ], "region": "north", "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "split": true, "autoScroll": false, "labelWidth": 108, "border": false, "frame": false, "labelAlign": "top" });
    var description66 = new Ext.form.TextArea({ "selectOnFocus": true, "fieldLabel": "Beschreibung", "anchor": "-20 -10", "growMax": 2000, "name": "description" });
    var text67 = new Lino.RichTextPanel({ "flex": 5, "split": true, "containing_panel": this, "selectOnFocus": true, "region": "south", "title": "Vorlagentext", "name": "text" });
    var main_panel68 = new Lino.VBorderPanel({ "autoScroll": false, "border": false, "labelWidth": 117, "hideCheckBoxLabels": true, "items": [ main_1_panel61, { "flex": 5, "layout": "form", "xtype": "panel", "items": description66, "region": "center", "labelAlign": "top", "split": true }, text67 ], "frame": true, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel68;
    this.before_row_edit = function(record) {
      text67.refresh();
    }
    Lino.ui.TextFieldTemplates.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.courses.Courses.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 76,
  initComponent : function() {
    var containing_panel = this;
    var id2159 = new Ext.form.NumberField({ "selectOnFocus": true, "fieldLabel": "ID", "anchor": "-20", "name": "id" });
    var start_date2160 = new Lino.DateField({ "selectOnFocus": true, "allowBlank": false, "fieldLabel": "Beginndatum", "anchor": "-20", "name": "start_date" });
    var offer2161 = new Lino.TwinCombo({ "fieldLabel": "Kursangebot", "allowBlank": false, "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.courses.CourseOffers.detail)}, "emptyText": "Kursangebot ausw\u00e4hlen...", "selectOnFocus": true, "hiddenName": "offerHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/courses/Courses/offer", "method": "GET" }) }), "name": "offer" });
    var title2162 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200, "fieldLabel": "Name", "anchor": "-20", "name": "title" });
    var main_1_panel2163 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 108, "hideCheckBoxLabels": true, "items": [ { "flex": 14, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id2159, "labelAlign": "top" }, { "flex": 14, "autoHeight": true, "layout": "form", "xtype": "panel", "items": start_date2160, "labelAlign": "top" }, { "flex": 35, "autoHeight": true, "layout": "form", "xtype": "panel", "items": offer2161, "labelAlign": "top" }, { "flex": 36, "autoHeight": true, "layout": "form", "xtype": "panel", "items": title2162, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var remark2168 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200, "fieldLabel": "Bemerkung", "anchor": "-20", "name": "remark" });
    var main_panel2182 = new Ext.Panel({ "autoScroll": false, "border": false, "layout": "vbox", "labelWidth": 90, "hideCheckBoxLabels": true, "items": [ main_1_panel2163, { "items": remark2168, "autoHeight": true, "layout": "form", "xtype": "panel", "labelAlign": "top" } ], "frame": true, "layoutConfig": { "align": "stretch" }, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel2182;
    this.before_row_edit = function(record) {
    }
    Lino.courses.Courses.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.cal.Places.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 33,
  initComponent : function() {
    var containing_panel = this;
    var id796 = new Ext.form.NumberField({ "selectOnFocus": true, "fieldLabel": "ID", "anchor": "-20", "name": "id" });
    var name797 = new Ext.form.TextField({ "fieldLabel": "Bezeichnung", "name": "name", "maxLength": 200, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var name_fr798 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200, "fieldLabel": "Bezeichnung (fr)", "anchor": "-20", "name": "name_fr" });
    var name_nl799 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200, "fieldLabel": "Bezeichnung (nl)", "anchor": "-20", "name": "name_nl" });
    var main_1_panel800 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 153, "hideCheckBoxLabels": true, "items": [ { "flex": 7, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id796, "labelAlign": "top" }, { "flex": 30, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name797, "labelAlign": "top" }, { "flex": 30, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_fr798, "labelAlign": "top" }, { "flex": 30, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_nl799, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var main_panel925 = new Ext.Panel({ "autoScroll": false, "border": false, "layout": "vbox", "hideCheckBoxLabels": true, "items": [ main_1_panel800 ], "frame": true, "layoutConfig": { "align": "stretch" }, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel925;
    this.before_row_edit = function(record) {
    }
    Lino.cal.Places.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.ui.Home.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  disable_editing: true,
  initComponent : function() {
    var containing_panel = this;
    var quick_links_htmlbox2273 = new Lino.HtmlBoxPanel({ "flex": 1, "layout": "fit", "name": "quick_links", "containing_panel": this, "items": new Ext.BoxComponent({autoScroll:true}), "region": "north", "master_panel": this, "value": "<br/>", "always_enabled": true, "bodyStyle": "overflow-x:hidden", "split": true });
    var welcome_htmlbox2274 = new Lino.HtmlBoxPanel({ "flex": 3, "layout": "fit", "name": "welcome", "containing_panel": this, "items": new Ext.BoxComponent({autoScroll:true}), "region": "center", "title": "Willkommen", "master_panel": this, "value": "<br/>", "always_enabled": true, "bodyStyle": "overflow-x:hidden", "split": true });
    var main_panel2275 = new Lino.VBorderPanel({ "autoScroll": false, "border": false, "labelWidth": 99, "hideCheckBoxLabels": true, "items": [ quick_links_htmlbox2273, welcome_htmlbox2274 ], "frame": true, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel2275;
    this.before_row_edit = function(record) {
      quick_links_htmlbox2273.refresh();
      welcome_htmlbox2274.refresh();
    }
    Lino.ui.Home.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.accounts.Charts.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 45,
  initComponent : function() {
    var containing_panel = this;
    var id1190 = new Ext.form.NumberField({ "selectOnFocus": true, "fieldLabel": "ID", "anchor": "-20", "name": "id" });
    var name1191 = new Ext.form.TextField({ "fieldLabel": "Bezeichnung", "name": "name", "maxLength": 200, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var name_fr1192 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200, "fieldLabel": "Bezeichnung (fr)", "anchor": "-20", "name": "name_fr" });
    var name_nl1193 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200, "fieldLabel": "Bezeichnung (nl)", "anchor": "-20", "name": "name_nl" });
    var main_1_panel1194 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 153, "hideCheckBoxLabels": true, "items": [ { "flex": 7, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id1190, "labelAlign": "top" }, { "flex": 30, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name1191, "labelAlign": "top" }, { "flex": 30, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_fr1192, "labelAlign": "top" }, { "flex": 30, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_nl1193, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var GroupsByChart_grid1234 = new Lino.accounts.GroupsByChart.GridPanel({ "tools": [ Lino.show_in_own_window_button(Lino.accounts.GroupsByChart.grid) ], "containing_panel": this, "hide_top_toolbar": true, "master_panel": this, "flex": 83 });
    var main_panel1235 = new Ext.Panel({ "autoScroll": false, "border": false, "layout": "vbox", "hideCheckBoxLabels": true, "items": [ main_1_panel1194, GroupsByChart_grid1234 ], "frame": true, "layoutConfig": { "align": "stretch" }, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel1235;
    this.before_row_edit = function(record) {
      GroupsByChart_grid1234.on_master_changed();
    }
    Lino.accounts.Charts.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.cal.PanelCalendars.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 35,
  initComponent : function() {
    var containing_panel = this;
    var type955 = new Lino.ChoicesFieldElement({ "fieldLabel": "Art", "allowBlank": false, "value": "local", "hiddenName": "typeHidden", "selectOnFocus": true, "anchor": "-20", "store": [ [ "local", "Local Calendar" ], [ "google", "Google Calendar" ] ], "name": "type" });
    var name956 = new Ext.form.TextField({ "fieldLabel": "Bezeichnung", "name": "name", "maxLength": 200, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var name_fr957 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200, "fieldLabel": "Bezeichnung (fr)", "anchor": "-20", "name": "name_fr" });
    var name_nl958 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200, "fieldLabel": "Bezeichnung (nl)", "anchor": "-20", "name": "name_nl" });
    var id959 = new Ext.form.NumberField({ "selectOnFocus": true, "fieldLabel": "ID", "anchor": "-20", "name": "id" });
    var main_1_panel960 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 153, "hideCheckBoxLabels": true, "items": [ { "flex": 22, "autoHeight": true, "layout": "form", "xtype": "panel", "items": type955, "labelAlign": "top" }, { "flex": 23, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name956, "labelAlign": "top" }, { "flex": 23, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_fr957, "labelAlign": "top" }, { "flex": 23, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_nl958, "labelAlign": "top" }, { "flex": 5, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id959, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var url_template966 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200, "fieldLabel": "URL-Vorlage", "anchor": "-20", "name": "url_template" });
    var username967 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200, "fieldLabel": "Benutzername", "anchor": "-20", "name": "username" });
    var password968 = new Ext.form.TextField({ "fieldLabel": "Passwort", "name": "password", "maxLength": 200, "selectOnFocus": true, "anchor": "-20", "inputType": "password" });
    var main_2_panel969 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 117, "hideCheckBoxLabels": true, "items": [ { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": url_template966, "labelAlign": "top" }, { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": username967, "labelAlign": "top" }, { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": password968, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var readonly973 = new Ext.form.Checkbox({ "boxLabel": "schreibgesch\u00fctzt", "hideLabel": true, "checked": false, "name": "readonly", "selectOnFocus": true, "anchor": "-20" });
    var invite_team_members974 = new Lino.RemoteComboFieldElement({ "fieldLabel": "Team", "name": "invite_team_members", "pageSize": 20, "emptyText": "Team ausw\u00e4hlen...", "selectOnFocus": true, "hiddenName": "invite_team_membersHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/Calendars/invite_team_members", "method": "GET" }) }) });
    var color975 = new Ext.form.NumberField({ "fieldLabel": "Farbe", "name": "color", "selectOnFocus": true, "anchor": "-20", "value": 1, "allowBlank": false });
    var start_date976 = new Lino.DateField({ "selectOnFocus": true, "fieldLabel": "Beginnt am", "anchor": "-20", "name": "start_date" });
    var main_3_panel977 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 153, "hideCheckBoxLabels": true, "items": [ { "flex": 23, "autoHeight": true, "layout": "form", "xtype": "panel", "items": readonly973, "labelAlign": "top" }, { "flex": 46, "autoHeight": true, "layout": "form", "xtype": "panel", "items": invite_team_members974, "labelAlign": "top" }, { "flex": 11, "autoHeight": true, "layout": "form", "xtype": "panel", "items": color975, "labelAlign": "top" }, { "flex": 18, "autoHeight": true, "layout": "form", "xtype": "panel", "items": start_date976, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var build_method982 = new Lino.ChoicesFieldElement({ "fieldLabel": "Konstruktionsmethode", "name": "build_method", "selectOnFocus": true, "anchor": "-20", "store": [ [ "appyodt", "AppyOdtBuildMethod" ], [ "appypdf", "AppyPdfBuildMethod" ], [ "appyrtf", "AppyRtfBuildMethod" ], [ "latex", "LatexBuildMethod" ], [ "pisa", "PisaBuildMethod" ], [ "rtf", "RtfBuildMethod" ] ], "hiddenName": "build_methodHidden" });
    var template983 = new Lino.SimpleRemoteComboFieldElement({ "selectOnFocus": true, "fieldLabel": "Vorlage", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/Calendars/template", "method": "GET" }) }), "name": "template" });
    var email_template984 = new Lino.SimpleRemoteComboFieldElement({ "listeners": { "render": Lino.quicktip_renderer("E-Mail-Vorlage","The name of the file to be used as template \nwhen creating an email from a mailable of this type.\n") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">E-Mail-Vorlage</span>", "name": "email_template", "selectOnFocus": true, "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/Calendars/email_template", "method": "GET" }) }) });
    var attach_to_email985 = new Ext.form.Checkbox({ "boxLabel": "als Anhang per E-Mail", "listeners": { "render": Lino.quicktip_renderer("als Anhang per E-Mail","Whether the printable file should be attached to the email\nwhen creating an email from a mailable of this type.\n") }, "hideLabel": true, "checked": false, "name": "attach_to_email", "selectOnFocus": true, "anchor": "-20" });
    var main_4_panel986 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 198, "hideCheckBoxLabels": true, "items": [ { "flex": 40, "autoHeight": true, "layout": "form", "xtype": "panel", "items": build_method982, "labelAlign": "top" }, { "flex": 20, "autoHeight": true, "layout": "form", "xtype": "panel", "items": template983, "labelAlign": "top" }, { "flex": 20, "autoHeight": true, "layout": "form", "xtype": "panel", "items": email_template984, "labelAlign": "top" }, { "flex": 20, "autoHeight": true, "layout": "form", "xtype": "panel", "items": attach_to_email985, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var main_panel1024 = new Ext.Panel({ "autoScroll": false, "border": false, "layout": "vbox", "hideCheckBoxLabels": true, "items": [ main_1_panel960, main_2_panel969, main_3_panel977, main_4_panel986 ], "frame": true, "layoutConfig": { "align": "stretch" }, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel1024;
    this.before_row_edit = function(record) {
      template983.setContextValue('build_method',record ? record.data['build_methodHidden'] : undefined);
    }
    this.onRender = function(ct, position) {
      build_method982.on('change',Lino.chooser_handler(template983,'build_method'));
      Lino.cal.PanelCalendars.DetailFormPanel.superclass.onRender.call(this, ct, position);
    }
    Lino.cal.PanelCalendars.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.cal.GuestRoles.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 34,
  initComponent : function() {
    var containing_panel = this;
    var id926 = new Ext.form.NumberField({ "selectOnFocus": true, "fieldLabel": "ID", "anchor": "-20", "name": "id" });
    var name927 = new Ext.form.TextField({ "fieldLabel": "Bezeichnung", "name": "name", "maxLength": 200, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var name_fr928 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200, "fieldLabel": "Bezeichnung (fr)", "anchor": "-20", "name": "name_fr" });
    var name_nl929 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200, "fieldLabel": "Bezeichnung (nl)", "anchor": "-20", "name": "name_nl" });
    var main_1_panel930 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 153, "hideCheckBoxLabels": true, "items": [ { "flex": 7, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id926, "labelAlign": "top" }, { "flex": 30, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name927, "labelAlign": "top" }, { "flex": 30, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_fr928, "labelAlign": "top" }, { "flex": 30, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_nl929, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var build_method935 = new Lino.ChoicesFieldElement({ "fieldLabel": "Konstruktionsmethode", "name": "build_method", "selectOnFocus": true, "anchor": "-20", "store": [ [ "appyodt", "AppyOdtBuildMethod" ], [ "appypdf", "AppyPdfBuildMethod" ], [ "appyrtf", "AppyRtfBuildMethod" ], [ "latex", "LatexBuildMethod" ], [ "pisa", "PisaBuildMethod" ], [ "rtf", "RtfBuildMethod" ] ], "hiddenName": "build_methodHidden" });
    var template936 = new Lino.SimpleRemoteComboFieldElement({ "selectOnFocus": true, "fieldLabel": "Vorlage", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/GuestRoles/template", "method": "GET" }) }), "name": "template" });
    var email_template937 = new Lino.SimpleRemoteComboFieldElement({ "listeners": { "render": Lino.quicktip_renderer("E-Mail-Vorlage","The name of the file to be used as template \nwhen creating an email from a mailable of this type.\n") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">E-Mail-Vorlage</span>", "name": "email_template", "selectOnFocus": true, "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/GuestRoles/email_template", "method": "GET" }) }) });
    var attach_to_email938 = new Ext.form.Checkbox({ "boxLabel": "als Anhang per E-Mail", "listeners": { "render": Lino.quicktip_renderer("als Anhang per E-Mail","Whether the printable file should be attached to the email\nwhen creating an email from a mailable of this type.\n") }, "hideLabel": true, "checked": false, "name": "attach_to_email", "selectOnFocus": true, "anchor": "-20" });
    var main_2_panel939 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 198, "hideCheckBoxLabels": true, "items": [ { "flex": 40, "autoHeight": true, "layout": "form", "xtype": "panel", "items": build_method935, "labelAlign": "top" }, { "flex": 20, "autoHeight": true, "layout": "form", "xtype": "panel", "items": template936, "labelAlign": "top" }, { "flex": 20, "autoHeight": true, "layout": "form", "xtype": "panel", "items": email_template937, "labelAlign": "top" }, { "flex": 20, "autoHeight": true, "layout": "form", "xtype": "panel", "items": attach_to_email938, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var cal_GuestsByRole_grid953 = new Lino.cal.GuestsByRole.GridPanel({ "tools": [ Lino.show_in_own_window_button(Lino.cal.GuestsByRole.grid) ], "containing_panel": this, "hide_top_toolbar": true, "master_panel": this, "flex": 71 });
    var main_panel954 = new Ext.Panel({ "autoScroll": false, "border": false, "layout": "vbox", "hideCheckBoxLabels": true, "items": [ main_1_panel930, main_2_panel939, cal_GuestsByRole_grid953 ], "frame": true, "layoutConfig": { "align": "stretch" }, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel954;
    this.before_row_edit = function(record) {
      template936.setContextValue('build_method',record ? record.data['build_methodHidden'] : undefined);
      cal_GuestsByRole_grid953.on_master_changed();
    }
    this.onRender = function(ct, position) {
      build_method935.on('change',Lino.chooser_handler(template936,'build_method'));
      Lino.cal.GuestRoles.DetailFormPanel.superclass.onRender.call(this, ct, position);
    }
    Lino.cal.GuestRoles.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.courses.CourseOffers.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 79,
  initComponent : function() {
    var containing_panel = this;
    var id2144 = new Ext.form.NumberField({ "selectOnFocus": true, "fieldLabel": "ID", "anchor": "-20", "name": "id" });
    var title2145 = new Ext.form.TextField({ "fieldLabel": "Name", "name": "title", "maxLength": 200, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var content2146 = new Lino.TwinCombo({ "fieldLabel": "Kursinhalt", "allowBlank": false, "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.courses.CourseContents.detail)}, "emptyText": "Kursinhalt ausw\u00e4hlen...", "selectOnFocus": true, "hiddenName": "contentHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/courses/CourseOffers/content", "method": "GET" }) }), "name": "content" });
    var provider2147 = new Lino.TwinCombo({ "fieldLabel": "Kursanbieter", "allowBlank": false, "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.courses.CourseProviders.detail)}, "emptyText": "Kursanbieter ausw\u00e4hlen...", "selectOnFocus": true, "hiddenName": "providerHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/courses/CourseOffers/provider", "method": "GET" }) }), "name": "provider" });
    var main_1_panel2148 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 11, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id2144, "labelAlign": "top" }, { "flex": 30, "autoHeight": true, "layout": "form", "xtype": "panel", "items": title2145, "labelAlign": "top" }, { "flex": 28, "autoHeight": true, "layout": "form", "xtype": "panel", "items": content2146, "labelAlign": "top" }, { "flex": 28, "autoHeight": true, "layout": "form", "xtype": "panel", "items": provider2147, "labelAlign": "top" } ], "region": "north", "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "split": true, "autoScroll": false, "labelWidth": 117, "border": false, "frame": false, "labelAlign": "top" });
    var description2153 = new Lino.RichTextPanel({ "flex": 5, "split": true, "containing_panel": this, "selectOnFocus": true, "region": "center", "title": "Beschreibung", "name": "description" });
    var CoursesByOffer_grid2184 = new Lino.courses.CoursesByOffer.GridPanel({ "flex": 5, "hide_top_toolbar": true, "split": true, "containing_panel": this, "region": "south", "tools": [ Lino.show_in_own_window_button(Lino.courses.CoursesByOffer.grid) ], "master_panel": this });
    var main_panel2185 = new Lino.VBorderPanel({ "autoScroll": false, "border": false, "labelWidth": 0, "hideCheckBoxLabels": true, "items": [ main_1_panel2148, description2153, CoursesByOffer_grid2184 ], "frame": true, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel2185;
    this.before_row_edit = function(record) {
      description2153.refresh();
      CoursesByOffer_grid2184.on_master_changed();
    }
    Lino.courses.CourseOffers.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.uploads.Uploads.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 26,
  initComponent : function() {
    var containing_panel = this;
    var file1040 = Lino.file_field_handler(this,{ "fieldLabel": "Datei", "name": "file", "maxLength": 100, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var user1041 = new Lino.TwinCombo({ "fieldLabel": "Autor", "name": "user", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.users.Users.detail)}, "emptyText": "Benutzer ausw\u00e4hlen...", "selectOnFocus": true, "hiddenName": "userHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/uploads/Uploads/user", "method": "GET" }) }) });
    var main_1_panel1042 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 54, "hideCheckBoxLabels": true, "items": [ { "flex": 58, "autoHeight": true, "layout": "form", "xtype": "panel", "items": file1040, "labelAlign": "top" }, { "flex": 41, "autoHeight": true, "layout": "form", "xtype": "panel", "items": user1041, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var type1045 = new Lino.RemoteComboFieldElement({ "fieldLabel": "Upload-Art", "name": "type", "pageSize": 20, "emptyText": "Upload-Art ausw\u00e4hlen...", "selectOnFocus": true, "hiddenName": "typeHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/uploads/Uploads/type", "method": "GET" }) }) });
    var description1046 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200, "fieldLabel": "Beschreibung", "anchor": "-20", "name": "description" });
    var valid_until1047 = new Lino.DateField({ "selectOnFocus": true, "fieldLabel": "g\u00fcltig bis", "anchor": "-20", "name": "valid_until" });
    var main_2_panel1048 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 117, "hideCheckBoxLabels": true, "items": [ { "flex": 40, "autoHeight": true, "layout": "form", "xtype": "panel", "items": type1045, "labelAlign": "top" }, { "flex": 42, "autoHeight": true, "layout": "form", "xtype": "panel", "items": description1046, "labelAlign": "top" }, { "flex": 16, "autoHeight": true, "layout": "form", "xtype": "panel", "items": valid_until1047, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var modified1052 = new Ext.form.DisplayField({ "disabled": true, "fieldLabel": "Bearbeitet", "anchor": "-20", "value": "<br>", "name": "modified" });
    var created1053 = new Ext.form.DisplayField({ "disabled": true, "fieldLabel": "Erstellt", "anchor": "-20", "value": "<br>", "name": "created" });
    var owner_disp1054 = new Ext.form.DisplayField({ "disabled": true, "fieldLabel": "Verkn\u00fcpft mit", "anchor": "-20", "name": "owner" });
    var main_3_panel1055 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 126, "hideCheckBoxLabels": true, "items": [ { "flex": 38, "autoHeight": true, "layout": "form", "xtype": "panel", "items": modified1052, "labelAlign": "top" }, { "flex": 38, "autoHeight": true, "layout": "form", "xtype": "panel", "items": created1053, "labelAlign": "top" }, { "flex": 23, "autoHeight": true, "layout": "form", "xtype": "panel", "items": owner_disp1054, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var cal_TasksByController_grid1059 = new Lino.cal.TasksByController.GridPanel({ "tools": [ Lino.show_in_own_window_button(Lino.cal.TasksByController.grid) ], "containing_panel": this, "hide_top_toolbar": true, "master_panel": this, "flex": 62 });
    var main_panel1060 = new Ext.Panel({ "autoScroll": false, "border": false, "layout": "vbox", "hideCheckBoxLabels": true, "items": [ main_1_panel1042, main_2_panel1048, main_3_panel1055, cal_TasksByController_grid1059 ], "frame": true, "layoutConfig": { "align": "stretch" }, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel1060;
    this.before_row_edit = function(record) {
      cal_TasksByController_grid1059.on_master_changed();
    }
    Lino.uploads.Uploads.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.uploads.Uploads.InsertFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  autoHeight: true,
  content_type: 26,
  initComponent : function() {
    var containing_panel = this;
    var file1061 = Lino.file_field_handler(this,{ "fieldLabel": "Datei", "name": "file", "maxLength": 100, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var user1062 = new Lino.TwinCombo({ "fieldLabel": "Autor", "name": "user", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.users.Users.detail)}, "emptyText": "Benutzer ausw\u00e4hlen...", "selectOnFocus": true, "hiddenName": "userHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/uploads/Uploads/user", "method": "GET" }) }) });
    var main_1_panel1063 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 58, "autoHeight": true, "layout": "form", "xtype": "panel", "items": file1061, "labelAlign": "top" }, { "flex": 41, "autoHeight": true, "layout": "form", "xtype": "panel", "items": user1062, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 54, "border": false, "anchor": "-20", "labelAlign": "top" });
    var type1066 = new Lino.RemoteComboFieldElement({ "fieldLabel": "Upload-Art", "name": "type", "pageSize": 20, "emptyText": "Upload-Art ausw\u00e4hlen...", "selectOnFocus": true, "hiddenName": "typeHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/uploads/Uploads/type", "method": "GET" }) }) });
    var valid_until1067 = new Lino.DateField({ "selectOnFocus": true, "fieldLabel": "g\u00fcltig bis", "anchor": "-20", "name": "valid_until" });
    var main_2_panel1068 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 71, "autoHeight": true, "layout": "form", "xtype": "panel", "items": type1066, "labelAlign": "top" }, { "flex": 28, "autoHeight": true, "layout": "form", "xtype": "panel", "items": valid_until1067, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 99, "border": false, "anchor": "-20", "labelAlign": "top" });
    var description1071 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200, "fieldLabel": "Beschreibung", "anchor": "-20", "name": "description" });
    var main_panel1072 = new Ext.Panel({ "hideCheckBoxLabels": true, "autoHeight": true, "border": false, "layout": "form", "labelWidth": 117, "autoScroll": false, "items": [ main_1_panel1063, main_2_panel1068, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": description1071, "anchor": "-20", "labelAlign": "top" } ], "frame": true, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel1072;
    this.before_row_edit = function(record) {
    }
    Lino.uploads.Uploads.InsertFormPanel.superclass.initComponent.call(this);
  }
});


Lino.pcsw.Clients.InsertFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  autoHeight: true,
  content_type: 50,
  initComponent : function() {
    var containing_panel = this;
    var first_name2041 = new Ext.form.TextField({ "fieldLabel": "Vorname", "name": "first_name", "maxLength": 200, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var last_name2042 = new Ext.form.TextField({ "fieldLabel": "Familienname", "name": "last_name", "maxLength": 200, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var main_1_panel2043 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": first_name2041, "labelAlign": "top" }, { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": last_name2042, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 117, "border": false, "anchor": "-20", "labelAlign": "top" });
    var national_id2046 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200, "fieldLabel": "NR-Nummer", "anchor": "-20", "name": "national_id" });
    var gender2047 = new Lino.ChoicesFieldElement({ "forceSelection": true, "fieldLabel": "Geschlecht", "name": "gender", "selectOnFocus": true, "anchor": "-20", "store": Lino.lino.Genders, "hiddenName": "genderHidden" });
    var language2048 = new Lino.ChoicesFieldElement({ "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Sprache</span>", "allowBlank": false, "value": "de", "hiddenName": "languageHidden", "listeners": { "render": Lino.quicktip_renderer("Sprache","Die Sprache, in der Dokumente ausgestellt werden sollen.") }, "selectOnFocus": true, "anchor": "-20", "store": [ [ "de", "Deutsch" ], [ "fr", "Franz\u00f6sisch" ], [ "nl", "Niederl\u00e4ndisch" ] ], "name": "language" });
    var main_3_panel2049 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 35, "autoHeight": true, "layout": "form", "xtype": "panel", "items": gender2047, "labelAlign": "top" }, { "flex": 64, "autoHeight": true, "layout": "form", "xtype": "panel", "items": language2048, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 99, "border": false, "anchor": "-20", "labelAlign": "top" });
    var main_panel2052 = new Ext.Panel({ "hideCheckBoxLabels": true, "autoHeight": true, "border": false, "layout": "form", "labelWidth": 90, "autoScroll": false, "items": [ main_1_panel2043, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": national_id2046, "anchor": "-20", "labelAlign": "top" }, main_3_panel2049 ], "frame": true, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel2052;
    this.before_row_edit = function(record) {
    }
    Lino.pcsw.Clients.InsertFormPanel.superclass.initComponent.call(this);
  }
});


Lino.lino.Home.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  disable_editing: true,
  initComponent : function() {
    var containing_panel = this;
    var quick_links_htmlbox2278 = new Lino.HtmlBoxPanel({ "flex": 3, "layout": "fit", "name": "quick_links", "containing_panel": this, "items": new Ext.BoxComponent({autoScroll:true}), "master_panel": this, "value": "<br/>", "always_enabled": true, "bodyStyle": "overflow-x:hidden" });
    var welcome_htmlbox2279 = new Lino.HtmlBoxPanel({ "flex": 10, "layout": "fit", "name": "welcome", "containing_panel": this, "items": new Ext.BoxComponent({autoScroll:true}), "title": "Willkommen", "master_panel": this, "value": "<br/>", "always_enabled": true, "bodyStyle": "overflow-x:hidden" });
    var coming_reminders_htmlbox2281 = new Lino.HtmlBoxPanel({ "flex": 50, "layout": "fit", "name": "coming_reminders", "containing_panel": this, "items": new Ext.BoxComponent({autoScroll:true}), "title": "Ausblick", "master_panel": this, "value": "<br/>", "always_enabled": true, "bodyStyle": "overflow-x:hidden" });
    var missed_reminders_htmlbox2282 = new Lino.HtmlBoxPanel({ "flex": 50, "layout": "fit", "name": "missed_reminders", "containing_panel": this, "items": new Ext.BoxComponent({autoScroll:true}), "title": "Verpasste Erinnerungen", "master_panel": this, "value": "<br/>", "always_enabled": true, "bodyStyle": "overflow-x:hidden" });
    var main_4_panel2283 = new Ext.Panel({ "flex": 57, "border": false, "layout": "hbox", "labelWidth": 207, "hideCheckBoxLabels": true, "items": [ coming_reminders_htmlbox2281, missed_reminders_htmlbox2282 ], "autoScroll": false, "layoutConfig": { "align": "stretch" }, "frame": false, "labelAlign": "top" });
    var main_panel2284 = new Ext.Panel({ "autoScroll": false, "border": false, "layout": "vbox", "labelWidth": 243, "hideCheckBoxLabels": true, "items": [ quick_links_htmlbox2278, welcome_htmlbox2279, main_4_panel2283 ], "frame": true, "layoutConfig": { "align": "stretch" }, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel2284;
    this.before_row_edit = function(record) {
      quick_links_htmlbox2278.refresh();
      welcome_htmlbox2279.refresh();
      coming_reminders_htmlbox2281.refresh();
      missed_reminders_htmlbox2282.refresh();
    }
    Lino.lino.Home.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.debts.Budgets.InsertFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  autoHeight: true,
  content_type: 84,
  initComponent : function() {
    var containing_panel = this;
    var partner525 = new Lino.TwinCombo({ "fieldLabel": "Partner", "allowBlank": false, "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.contacts.Partners.detail)}, "emptyText": "Partner ausw\u00e4hlen...", "selectOnFocus": true, "hiddenName": "partnerHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/debts/Budgets/partner", "method": "GET" }) }), "name": "partner" });
    var date526 = new Lino.DateField({ "selectOnFocus": true, "fieldLabel": "Datum", "anchor": "-20", "name": "date" });
    var user527 = new Lino.TwinCombo({ "fieldLabel": "Autor", "name": "user", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.users.Users.detail)}, "emptyText": "Benutzer ausw\u00e4hlen...", "selectOnFocus": true, "hiddenName": "userHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/debts/Budgets/user", "method": "GET" }) }) });
    var main_2_panel528 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 34, "autoHeight": true, "layout": "form", "xtype": "panel", "items": date526, "labelAlign": "top" }, { "flex": 65, "autoHeight": true, "layout": "form", "xtype": "panel", "items": user527, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 54, "border": false, "anchor": "-20", "labelAlign": "top" });
    var main_panel531 = new Ext.Panel({ "hideCheckBoxLabels": true, "autoHeight": true, "border": false, "layout": "form", "labelWidth": 72, "autoScroll": false, "items": [ { "autoHeight": true, "layout": "form", "xtype": "panel", "items": partner525, "anchor": "-20", "labelAlign": "top" }, main_2_panel528 ], "frame": true, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel531;
    this.before_row_edit = function(record) {
    }
    Lino.debts.Budgets.InsertFormPanel.superclass.initComponent.call(this);
  }
});


Lino.ui.TextFieldTemplates.InsertFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  autoHeight: true,
  content_type: 1,
  initComponent : function() {
    var containing_panel = this;
    var name70 = new Ext.form.TextField({ "fieldLabel": "Bezeichnung", "name": "name", "maxLength": 200, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var user71 = new Lino.TwinCombo({ "fieldLabel": "Autor", "name": "user", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.users.Users.detail)}, "emptyText": "Benutzer ausw\u00e4hlen...", "selectOnFocus": true, "hiddenName": "userHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/ui/TextFieldTemplates/user", "method": "GET" }) }) });
    var team72 = new Lino.RemoteComboFieldElement({ "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Team</span>", "name": "team", "pageSize": 20, "emptyText": "Team ausw\u00e4hlen...", "listeners": { "render": Lino.quicktip_renderer("Team","If not empty, then this template is reserved to members of this team.") }, "selectOnFocus": true, "hiddenName": "teamHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/ui/TextFieldTemplates/team", "method": "GET" }) }) });
    var main_2_panel73 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 42, "autoHeight": true, "layout": "form", "xtype": "panel", "items": user71, "labelAlign": "top" }, { "flex": 57, "autoHeight": true, "layout": "form", "xtype": "panel", "items": team72, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 54, "border": false, "anchor": "-20", "labelAlign": "top" });
    var main_panel76 = new Ext.Panel({ "hideCheckBoxLabels": true, "autoHeight": true, "border": false, "layout": "form", "labelWidth": 108, "autoScroll": false, "items": [ { "autoHeight": true, "layout": "form", "xtype": "panel", "items": name70, "anchor": "-20", "labelAlign": "top" }, main_2_panel73 ], "frame": true, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel76;
    this.before_row_edit = function(record) {
    }
    Lino.ui.TextFieldTemplates.InsertFormPanel.superclass.initComponent.call(this);
  }
});


Lino.about.About.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  disable_editing: true,
  initComponent : function() {
    var containing_panel = this;
    var main_panel2277 = new Ext.Panel({ "autoScroll": false, "border": false, "layout": "fit", "hideCheckBoxLabels": true, "items": [ { "html": "<div class=\"htmlText\"><span>This is <a href=\"http://welfare.lino-framework.org\" target=\"_blank\">Lino Welfare</a> 1.1.4 using <a href=\"http://site.lino-framework.org\" target=\"_blank\">djangosite</a> 0.1.4, <a href=\"http://www.python.org/\" target=\"_blank\">Python</a> 2.7.3, <a href=\"http://www.djangoproject.com\" target=\"_blank\">Django</a> 1.5.1, <a href=\"http://babel.edgewall.org/\" target=\"_blank\">Babel</a> 1.0dev-r661, <a href=\"http://www.lino-framework.org\" target=\"_blank\">Lino</a> 1.6.7, <a href=\"http://jinja.pocoo.org/\" target=\"_blank\">Jinja</a> 2.6, <a href=\"http://sphinx-doc.org/\" target=\"_blank\">Sphinx</a> 1.2b1, <a href=\"http://labix.org/python-dateutil\" target=\"_blank\">python-dateutil</a> 2.1, <a href=\"http://pypi.python.org/pypi/odfpy\" target=\"_blank\">OdfPy</a> ODFPY/0.9.6, <a href=\"http://docutils.sourceforge.net/\" target=\"_blank\">docutils</a> 0.10, <a href=\"https://fedorahosted.org/suds/\" target=\"_blank\">suds</a> 0.4, <a href=\"http://pyyaml.org/\" target=\"_blank\">PyYaml</a> 3.10, <a href=\"http://appyframework.org/pod.html\" target=\"_blank\">Appy</a> 0.8.3 (2013/02/22 15:29)</span><p>Server l&#228;uft seit : <b>Donnerstag, 9. Mai 2013 um 16:22:05.477886</b></p><p>Source timestamps:</p><ul><li>lino : <b>Donnerstag, 9. Mai 2013 um 16:21:57.672733</b></li><li>lino_welfare : <b>Donnerstag, 9. Mai 2013 um 16:16:24.376741</b></li><li>django : <b>Mittwoch, 8. Mai 2013 um 10:18:59.384324</b></li><li>djangosite : <b>Mittwoch, 8. Mai 2013 um 09:47:36.552380</b></li><li>north : <b>Sonntag, 5. Mai 2013 um 22:52:00.438131</b></li><li>atelier : <b>Donnerstag, 25. April 2013 um 11:30:28.335334</b></li></ul></div>", "xtype": "label" } ], "frame": true, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel2277;
    this.before_row_edit = function(record) {
    }
    Lino.about.About.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.cbss.RetrieveTIGroupsRequests.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 87,
  initComponent : function() {
    var containing_panel = this;
    var id2211 = new Ext.form.NumberField({ "selectOnFocus": true, "fieldLabel": "ID", "anchor": "-20", "name": "id" });
    var person2212 = new Lino.TwinCombo({ "fieldLabel": "Klient", "allowBlank": false, "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.pcsw.Clients.detail)}, "emptyText": "Klient ausw\u00e4hlen...", "selectOnFocus": true, "hiddenName": "personHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cbss/RetrieveTIGroupsRequests/person", "method": "GET" }) }), "name": "person" });
    var user2213 = new Lino.TwinCombo({ "fieldLabel": "Autor", "allowBlank": false, "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.users.Users.detail)}, "emptyText": "Benutzer ausw\u00e4hlen...", "selectOnFocus": true, "hiddenName": "userHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cbss/RetrieveTIGroupsRequests/user", "method": "GET" }) }), "name": "user" });
    var environment2214 = new Ext.form.TextField({ "disabled": true, "fieldLabel": "T/A/B", "name": "environment", "maxLength": 4, "boxMinWidth": Lino.chars2width(4), "anchor": "-20" });
    var sent2215 = new Ext.form.DisplayField({ "disabled": true, "listeners": { "render": Lino.quicktip_renderer("Versendet","The date and time when this request has been executed. \nThis is empty for requests than haven't been sent.\nRead-only.") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Versendet</span>", "name": "sent", "anchor": "-20", "value": "<br>" });
    var status2216 = new Lino.ChoicesFieldElement({ "disabled": true, "forceSelection": true, "fieldLabel": "Zustand", "name": "status", "anchor": "-20", "store": Lino.cbss.RequestStates, "hiddenName": "statusHidden" });
    var ticket2217 = new Ext.form.TextField({ "disabled": true, "maxLength": 36, "fieldLabel": "Ticket", "anchor": "-20", "name": "ticket" });
    var info_1_panel2218 = new Ext.form.FieldSet({ "autoHeight": true, "layout": "hbox", "title": "Info zur Anfrage", "layoutConfig": { "align": "stretchmax" }, "frame": false, "bodyBorder": true, "autoScroll": false, "items": [ { "flex": 5, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id2211, "labelAlign": "top" }, { "flex": 20, "autoHeight": true, "layout": "form", "xtype": "panel", "items": person2212, "labelAlign": "top" }, { "flex": 15, "autoHeight": true, "layout": "form", "xtype": "panel", "items": user2213, "labelAlign": "top" }, { "flex": 5, "autoHeight": true, "layout": "form", "xtype": "panel", "items": environment2214, "labelAlign": "top" }, { "flex": 16, "autoHeight": true, "layout": "form", "xtype": "panel", "items": sent2215, "labelAlign": "top" }, { "flex": 18, "autoHeight": true, "layout": "form", "xtype": "panel", "items": status2216, "labelAlign": "top" }, { "flex": 21, "autoHeight": true, "layout": "form", "xtype": "panel", "items": ticket2217, "labelAlign": "top" } ], "hideCheckBoxLabels": true, "labelWidth": 90, "border": false, "labelAlign": "top" });
    var national_id2226 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200, "fieldLabel": "NR-Nummer", "anchor": "-20", "name": "national_id" });
    var language2227 = new Lino.ChoicesFieldElement({ "forceSelection": true, "fieldLabel": "Sprache", "name": "language", "selectOnFocus": true, "anchor": "-20", "store": Lino.cbss.RequestLanguages, "hiddenName": "languageHidden" });
    var history2228 = new Ext.form.Checkbox({ "boxLabel": "Historie", "listeners": { "render": Lino.quicktip_renderer("Historie","Whatever this means.") }, "hideLabel": true, "checked": true, "name": "history", "selectOnFocus": true, "anchor": "-20" });
    var parameters_panel2229 = new Ext.form.FieldSet({ "autoHeight": true, "layout": "hbox", "title": "Parameter", "layoutConfig": { "align": "stretchmax" }, "frame": false, "bodyBorder": true, "autoScroll": false, "items": [ { "flex": 43, "autoHeight": true, "layout": "form", "xtype": "panel", "items": national_id2226, "labelAlign": "top" }, { "flex": 35, "autoHeight": true, "layout": "form", "xtype": "panel", "items": language2227, "labelAlign": "top" }, { "flex": 20, "autoHeight": true, "layout": "form", "xtype": "panel", "items": history2228, "labelAlign": "top" } ], "hideCheckBoxLabels": true, "labelWidth": 90, "border": false, "labelAlign": "top" });
    var cbss_RetrieveTIGroupsResult_grid2238 = new Lino.cbss.RetrieveTIGroupsResult.GridPanel({ "tools": [ Lino.show_in_own_window_button(Lino.cbss.RetrieveTIGroupsResult.grid) ], "containing_panel": this, "hide_top_toolbar": true, "master_panel": this, "flex": 71 });
    var request_panel2239 = new Ext.Panel({ "layout": "vbox", "title": "Abfrage", "items": [ info_1_panel2218, parameters_panel2229, cbss_RetrieveTIGroupsResult_grid2238 ], "frame": true, "layoutConfig": { "align": "stretch" }, "hideCheckBoxLabels": true, "listeners": { "activate": Lino.on_tab_activate }, "autoScroll": false, "border": false, "bodyBorder": false, "labelAlign": "top" });
    var response_xml2240 = new Ext.form.TextArea({ "disabled": true, "listeners": { "render": Lino.quicktip_renderer("Antwort","The raw XML response received. \n") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Antwort</span>", "name": "response_xml", "growMax": 2000, "anchor": "-20 -10" });
    var info_messages2241 = new Ext.form.TextArea({ "disabled": true, "fieldLabel": "Info-Meldungen", "anchor": "-20 -10", "growMax": 2000, "name": "info_messages" });
    var debug_messages2242 = new Ext.form.TextArea({ "disabled": true, "fieldLabel": "Debug-Meldungen", "anchor": "-20 -10", "growMax": 2000, "name": "debug_messages" });
    var technical_panel2243 = new Lino.VBorderPanel({ "autoScroll": false, "listeners": { "activate": Lino.on_tab_activate }, "border": false, "labelWidth": 144, "title": "Technisch", "hideCheckBoxLabels": true, "items": [ { "flex": 5, "layout": "form", "xtype": "panel", "items": response_xml2240, "region": "north", "labelAlign": "top", "split": true }, { "flex": 5, "layout": "form", "xtype": "panel", "items": info_messages2241, "region": "center", "labelAlign": "top", "split": true }, { "flex": 5, "layout": "form", "xtype": "panel", "items": debug_messages2242, "region": "south", "labelAlign": "top", "split": true } ], "frame": true, "bodyBorder": false, "labelAlign": "top" });
    var main_panel2247 = new Ext.TabPanel({ "hideCheckBoxLabels": true, "border": false, "split": true, "autoScroll": false, "items": [ request_panel2239, technical_panel2243 ], "activeTab": 0, "bodyBorder": false, "frame": true, "labelAlign": "top" });
    this.items = main_panel2247;
    this.before_row_edit = function(record) {
      cbss_RetrieveTIGroupsResult_grid2238.on_master_changed();
    }
    Lino.cbss.RetrieveTIGroupsRequests.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.countries.Languages.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 12,
  initComponent : function() {
    var containing_panel = this;
    var id241 = new Ext.form.TextField({ "fieldLabel": "id", "name": "id", "maxLength": 3, "selectOnFocus": true, "boxMinWidth": Lino.chars2width(3), "anchor": "-20", "allowBlank": false });
    var iso2242 = new Ext.form.TextField({ "fieldLabel": "iso2", "name": "iso2", "maxLength": 2, "selectOnFocus": true, "boxMinWidth": Lino.chars2width(2), "anchor": "-20" });
    var name243 = new Ext.form.TextField({ "fieldLabel": "Bezeichnung", "name": "name", "maxLength": 200, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var name_fr244 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200, "fieldLabel": "Bezeichnung (fr)", "anchor": "-20", "name": "name_fr" });
    var name_nl245 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200, "fieldLabel": "Bezeichnung (nl)", "anchor": "-20", "name": "name_nl" });
    var main_1_panel246 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 153, "hideCheckBoxLabels": true, "items": [ { "flex": 5, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id241, "labelAlign": "top" }, { "flex": 5, "autoHeight": true, "layout": "form", "xtype": "panel", "items": iso2242, "labelAlign": "top" }, { "flex": 29, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name243, "labelAlign": "top" }, { "flex": 29, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_fr244, "labelAlign": "top" }, { "flex": 29, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_nl245, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var main_panel259 = new Ext.Panel({ "autoScroll": false, "border": false, "layout": "vbox", "hideCheckBoxLabels": true, "items": [ main_1_panel246 ], "frame": true, "layoutConfig": { "align": "stretch" }, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel259;
    this.before_row_edit = function(record) {
    }
    Lino.countries.Languages.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.pcsw.Clients.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 50,
  initComponent : function() {
    var containing_panel = this;
    var last_name1405 = new Ext.form.TextField({ "fieldLabel": "Familienname", "name": "last_name", "maxLength": 200, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var first_name1406 = new Ext.form.TextField({ "fieldLabel": "Vorname", "name": "first_name", "maxLength": 200, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var title1407 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200, "fieldLabel": "Anrede", "anchor": "-20", "name": "title" });
    var box1_1_panel1408 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 45, "autoHeight": true, "layout": "form", "xtype": "panel", "items": last_name1405, "labelAlign": "top" }, { "flex": 32, "autoHeight": true, "layout": "form", "xtype": "panel", "items": first_name1406, "labelAlign": "top" }, { "flex": 21, "autoHeight": true, "layout": "form", "xtype": "panel", "items": title1407, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 117, "border": false, "anchor": "-20", "labelAlign": "top" });
    var country1412 = new Lino.TwinCombo({ "fieldLabel": "Land", "name": "country", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.countries.Countries.detail)}, "emptyText": "Land ausw\u00e4hlen...", "selectOnFocus": true, "hiddenName": "countryHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/pcsw/Clients/country", "method": "GET" }) }) });
    var city1413 = new Lino.TwinCombo({ "forceSelection": false, "fieldLabel": "Ort", "name": "city", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.countries.Cities.detail)}, "emptyText": "Ort ausw\u00e4hlen...", "selectOnFocus": true, "hiddenName": "cityHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/pcsw/Clients/city", "method": "GET" }) }) });
    var zip_code1414 = new Ext.form.TextField({ "fieldLabel": "Postleitzahl", "name": "zip_code", "maxLength": 10, "selectOnFocus": true, "boxMinWidth": Lino.chars2width(10), "anchor": "-20" });
    var box1_2_panel1415 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 40, "autoHeight": true, "layout": "form", "xtype": "panel", "items": country1412, "labelAlign": "top" }, { "flex": 40, "autoHeight": true, "layout": "form", "xtype": "panel", "items": city1413, "labelAlign": "top" }, { "flex": 20, "autoHeight": true, "layout": "form", "xtype": "panel", "items": zip_code1414, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 117, "border": false, "anchor": "-20", "labelAlign": "top" });
    var street_prefix1419 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Pr\u00e4fix Stra\u00dfe","Text to print before name of street, but to ignore for sorting.") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Pr\u00e4fix Stra\u00dfe</span>", "name": "street_prefix", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var street1420 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Stra\u00dfe","Name of street. Without house number.") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Stra\u00dfe</span>", "name": "street", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var street_no1421 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Nr.","House number") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Nr.</span>", "name": "street_no", "maxLength": 10, "selectOnFocus": true, "boxMinWidth": Lino.chars2width(10), "anchor": "-20" });
    var street_box1422 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Box","Text to print after :attr:`steet_no` on the same line") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Box</span>", "name": "street_box", "maxLength": 10, "selectOnFocus": true, "boxMinWidth": Lino.chars2width(10), "anchor": "-20" });
    var box1_3_panel1423 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 30, "autoHeight": true, "layout": "form", "xtype": "panel", "items": street_prefix1419, "labelAlign": "top" }, { "flex": 36, "autoHeight": true, "layout": "form", "xtype": "panel", "items": street1420, "labelAlign": "top" }, { "flex": 16, "autoHeight": true, "layout": "form", "xtype": "panel", "items": street_no1421, "labelAlign": "top" }, { "flex": 16, "autoHeight": true, "layout": "form", "xtype": "panel", "items": street_box1422, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 126, "border": false, "anchor": "-20", "labelAlign": "top" });
    var addr21428 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Adresszeile nach Stra\u00dfe","Address line to print below street line") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Adresszeile nach Stra\u00dfe</span>", "name": "addr2", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var box1_panel1429 = new Ext.form.FieldSet({ "flex": 61, "autoHeight": true, "layout": "form", "title": "Adresse", "items": [ box1_1_panel1408, box1_2_panel1415, box1_3_panel1423, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": addr21428, "anchor": "-20", "labelAlign": "top" } ], "frame": true, "bodyBorder": false, "autoScroll": false, "hideCheckBoxLabels": true, "labelWidth": 216, "border": false, "labelAlign": "top" });
    var id1431 = new Ext.form.NumberField({ "selectOnFocus": true, "fieldLabel": "ID", "anchor": "-20", "name": "id" });
    var language1432 = new Lino.ChoicesFieldElement({ "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Sprache</span>", "allowBlank": false, "value": "de", "hiddenName": "languageHidden", "listeners": { "render": Lino.quicktip_renderer("Sprache","Die Sprache, in der Dokumente ausgestellt werden sollen.") }, "selectOnFocus": true, "anchor": "-20", "store": [ [ "de", "Deutsch" ], [ "fr", "Franz\u00f6sisch" ], [ "nl", "Niederl\u00e4ndisch" ] ], "name": "language" });
    var box2_1_panel1433 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 37, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id1431, "labelAlign": "top" }, { "flex": 62, "autoHeight": true, "layout": "form", "xtype": "panel", "items": language1432, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 72, "border": false, "anchor": "-20", "labelAlign": "top" });
    var email1436 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 75, "fieldLabel": "E-Mail", "anchor": "-20", "name": "email" });
    var phone1437 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200, "fieldLabel": "Telefon", "anchor": "-20", "name": "phone" });
    var fax1438 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200, "fieldLabel": "Fax", "anchor": "-20", "name": "fax" });
    var box2_3_panel1439 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": phone1437, "labelAlign": "top" }, { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": fax1438, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 72, "border": false, "anchor": "-20", "labelAlign": "top" });
    var gsm1442 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200, "fieldLabel": "GSM", "anchor": "-20", "name": "gsm" });
    var box2_panel1443 = new Ext.form.FieldSet({ "flex": 38, "autoHeight": true, "layout": "form", "title": "Kontakt", "items": [ box2_1_panel1433, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": email1436, "anchor": "-20", "labelAlign": "top" }, box2_3_panel1439, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": gsm1442, "anchor": "-20", "labelAlign": "top" } ], "frame": true, "bodyBorder": false, "autoScroll": false, "hideCheckBoxLabels": true, "labelWidth": 63, "border": false, "labelAlign": "top" });
    var general_1_panel1446 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "hideCheckBoxLabels": true, "items": [ box1_panel1429, box2_panel1443 ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "anchor": "-20", "labelAlign": "top" });
    var gender1447 = new Lino.ChoicesFieldElement({ "forceSelection": true, "fieldLabel": "Geschlecht", "name": "gender", "selectOnFocus": true, "anchor": "-20", "store": Lino.lino.Genders, "hiddenName": "genderHidden" });
    var birth_date1448 = new Lino.IncompleteDateField({ "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Geburtsdatum","Unkomplette Datumsangaben sind erlaubt, z.B. \"00.00.1980\" hei\u00dft \"irgendwann im Jahr 1980\", \"00.07.1980\" hei\u00dft \"im Juli 1980\"oder \"23.07.0000\" hei\u00dft \"an einem 23. Juli\".") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Geburtsdatum</span>", "anchor": "-20", "name": "birth_date" });
    var age_disp1449 = new Ext.form.DisplayField({ "disabled": true, "fieldLabel": "Alter", "name": "age", "anchor": "-20", "value": "<br/>", "always_enabled": true });
    var civil_state1450 = new Lino.ChoicesFieldElement({ "forceSelection": true, "fieldLabel": "Zivilstand", "name": "civil_state", "selectOnFocus": true, "anchor": "-20", "store": Lino.pcsw.CivilState, "hiddenName": "civil_stateHidden" });
    var noble_condition1451 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Adelstitel","The eventual noble condition of this person. Imported from TIM.") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Adelstitel</span>", "name": "noble_condition", "maxLength": 50, "selectOnFocus": true, "anchor": "-20" });
    var box3_1_panel1452 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 14, "autoHeight": true, "layout": "form", "xtype": "panel", "items": gender1447, "labelAlign": "top" }, { "flex": 17, "autoHeight": true, "layout": "form", "xtype": "panel", "items": birth_date1448, "labelAlign": "top" }, { "flex": 14, "autoHeight": true, "layout": "form", "xtype": "panel", "items": age_disp1449, "labelAlign": "top" }, { "flex": 22, "autoHeight": true, "layout": "form", "xtype": "panel", "items": civil_state1450, "labelAlign": "top" }, { "flex": 30, "autoHeight": true, "layout": "form", "xtype": "panel", "items": noble_condition1451, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 117, "border": false, "anchor": "-20", "labelAlign": "top" });
    var birth_country1458 = new Lino.TwinCombo({ "fieldLabel": "Geburtsland", "name": "birth_country", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.countries.Countries.detail)}, "emptyText": "Land ausw\u00e4hlen...", "selectOnFocus": true, "hiddenName": "birth_countryHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/pcsw/Clients/birth_country", "method": "GET" }) }) });
    var birth_place1459 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200, "fieldLabel": "Geburtsort", "anchor": "-20", "name": "birth_place" });
    var nationality1460 = new Lino.TwinCombo({ "fieldLabel": "Staatsangeh\u00f6rigkeit", "name": "nationality", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.countries.Countries.detail)}, "emptyText": "Land ausw\u00e4hlen...", "selectOnFocus": true, "hiddenName": "nationalityHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/pcsw/Clients/nationality", "method": "GET" }) }) });
    var national_id1461 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200, "fieldLabel": "NR-Nummer", "anchor": "-20", "name": "national_id" });
    var box3_2_panel1462 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 28, "autoHeight": true, "layout": "form", "xtype": "panel", "items": birth_country1458, "labelAlign": "top" }, { "flex": 29, "autoHeight": true, "layout": "form", "xtype": "panel", "items": birth_place1459, "labelAlign": "top" }, { "flex": 21, "autoHeight": true, "layout": "form", "xtype": "panel", "items": nationality1460, "labelAlign": "top" }, { "flex": 21, "autoHeight": true, "layout": "form", "xtype": "panel", "items": national_id1461, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 180, "border": false, "anchor": "-20", "labelAlign": "top" });
    var box3_panel1467 = new Ext.form.FieldSet({ "autoHeight": true, "layout": "form", "title": "Geburtsangaben", "items": [ box3_1_panel1452, box3_2_panel1462 ], "frame": true, "bodyBorder": false, "autoScroll": false, "hideCheckBoxLabels": true, "border": false, "anchor": "-20", "labelAlign": "top" });
    var card_number1468 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 20, "fieldLabel": "Nummer", "anchor": "-20", "name": "card_number" });
    var card_valid_from1469 = new Lino.DateField({ "selectOnFocus": true, "fieldLabel": "G\u00fcltig von", "anchor": "-20", "name": "card_valid_from" });
    var card_valid_until1470 = new Lino.DateField({ "selectOnFocus": true, "fieldLabel": "g\u00fcltig bis", "anchor": "-20", "name": "card_valid_until" });
    var card_issuer1471 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 50, "fieldLabel": "Ausgestellt durch", "anchor": "-20", "name": "card_issuer" });
    var card_type1472 = new Lino.ChoicesFieldElement({ "forceSelection": true, "fieldLabel": "eID-Kartenart", "name": "card_type", "selectOnFocus": true, "anchor": "-20", "store": Lino.pcsw.BeIdCardTypes, "hiddenName": "card_typeHidden" });
    var eid_panel_1_panel1473 = new Ext.form.FieldSet({ "autoHeight": true, "layout": "hbox", "title": "eID-Karte", "bodyBorder": true, "frame": false, "layoutConfig": { "align": "stretchmax" }, "autoScroll": false, "items": [ { "flex": 20, "autoHeight": true, "layout": "form", "xtype": "panel", "items": card_number1468, "labelAlign": "top" }, { "flex": 20, "autoHeight": true, "layout": "form", "xtype": "panel", "items": card_valid_from1469, "labelAlign": "top" }, { "flex": 20, "autoHeight": true, "layout": "form", "xtype": "panel", "items": card_valid_until1470, "labelAlign": "top" }, { "flex": 17, "autoHeight": true, "layout": "form", "xtype": "panel", "items": card_issuer1471, "labelAlign": "top" }, { "flex": 20, "autoHeight": true, "layout": "form", "xtype": "panel", "items": card_type1472, "labelAlign": "top" } ], "hideCheckBoxLabels": true, "labelWidth": 252, "border": false, "anchor": "-20", "labelAlign": "top" });
    var created1479 = new Ext.form.DisplayField({ "disabled": true, "fieldLabel": "Erstellt", "anchor": "-20", "value": "<br>", "name": "created" });
    var modified1480 = new Ext.form.DisplayField({ "disabled": true, "fieldLabel": "Bearbeitet", "anchor": "-20", "value": "<br>", "name": "modified" });
    var box4_3_panel1481 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": created1479, "labelAlign": "top" }, { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": modified1480, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 99, "border": false, "anchor": "-20", "labelAlign": "top" });
    var box4_panel1484 = new Ext.Panel({ "flex": 82, "autoHeight": true, "border": false, "layout": "form", "hideCheckBoxLabels": true, "items": [ box3_panel1467, eid_panel_1_panel1473, box4_3_panel1481 ], "frame": true, "autoScroll": false, "bodyBorder": false, "labelAlign": "top" });
    var image_htmlbox1485 = new Lino.HtmlBoxPanel({ "flex": 17, "layout": "fit", "name": "image", "containing_panel": this, "items": new Ext.BoxComponent({autoScroll:true}), "master_panel": this, "value": "<br/>", "always_enabled": true, "bodyStyle": "overflow-x:hidden" });
    var general_2_panel1486 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ box4_panel1484, image_htmlbox1485 ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 0, "border": false, "anchor": "-20", "labelAlign": "top" });
    var general_panel1487 = new Ext.Panel({ "autoHeight": true, "layout": "form", "title": "Person", "items": [ general_1_panel1446, general_2_panel1486 ], "frame": true, "bodyBorder": false, "hideCheckBoxLabels": true, "listeners": { "activate": Lino.on_tab_activate }, "autoScroll": false, "border": false, "labelAlign": "top" });
    var in_belgium_since1488 = new Lino.DateField({ "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Lebt in Belgien seit","Since when this person in Belgium lives.\n<b>Important:</b> help_text can be formatted.") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Lebt in Belgien seit</span>", "anchor": "-20", "name": "in_belgium_since" });
    var residence_type1489 = new Lino.ChoicesFieldElement({ "forceSelection": true, "fieldLabel": "Register", "name": "residence_type", "selectOnFocus": true, "anchor": "-20", "store": Lino.pcsw.ResidenceType, "hiddenName": "residence_typeHidden" });
    var gesdos_id1490 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 40, "fieldLabel": "Gesdos-Nr", "anchor": "-20", "name": "gesdos_id" });
    var status_1_panel1491 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 25, "autoHeight": true, "layout": "form", "xtype": "panel", "items": in_belgium_since1488, "labelAlign": "top" }, { "flex": 38, "autoHeight": true, "layout": "form", "xtype": "panel", "items": residence_type1489, "labelAlign": "top" }, { "flex": 35, "autoHeight": true, "layout": "form", "xtype": "panel", "items": gesdos_id1490, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 189, "border": false, "anchor": "-20", "labelAlign": "top" });
    var bank_account11495 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 40, "fieldLabel": "Bankkonto 1", "anchor": "-20", "name": "bank_account1" });
    var bank_account21496 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 40, "fieldLabel": "Bankkonto 2", "anchor": "-20", "name": "bank_account2" });
    var status_2_panel1497 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": bank_account11495, "labelAlign": "top" }, { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": bank_account21496, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 108, "border": false, "anchor": "-20", "labelAlign": "top" });
    var job_agents1500 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 100, "fieldLabel": "Interim-Agenturen", "anchor": "-20", "name": "job_agents" });
    var group1501 = new Lino.RemoteComboFieldElement({ "fieldLabel": "Integrationsphase", "name": "group", "pageSize": 20, "emptyText": "Integrationsphase ausw\u00e4hlen...", "selectOnFocus": true, "hiddenName": "groupHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/pcsw/Clients/group", "method": "GET" }) }) });
    var status_3_panel1502 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 56, "autoHeight": true, "layout": "form", "xtype": "panel", "items": job_agents1500, "labelAlign": "top" }, { "flex": 43, "autoHeight": true, "layout": "form", "xtype": "panel", "items": group1501, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 162, "border": false, "anchor": "-20", "labelAlign": "top" });
    var status_panel1505 = new Ext.Panel({ "flex": 68, "autoHeight": true, "border": false, "layout": "form", "hideCheckBoxLabels": true, "items": [ status_1_panel1491, status_2_panel1497, status_3_panel1502 ], "frame": true, "autoScroll": false, "bodyBorder": false, "labelAlign": "top" });
    var aid_type1506 = new Lino.RemoteComboFieldElement({ "fieldLabel": "Sozialhilfeart", "name": "aid_type", "pageSize": 20, "emptyText": "Sozialhilfeart ausw\u00e4hlen...", "selectOnFocus": true, "hiddenName": "aid_typeHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/pcsw/Clients/aid_type", "method": "GET" }) }) });
    var income_ag1507 = new Ext.form.Checkbox({ "boxLabel": "Arbeitslosengeld", "hideLabel": true, "checked": false, "name": "income_ag", "selectOnFocus": true, "anchor": "-20" });
    var income_wg1508 = new Ext.form.Checkbox({ "boxLabel": "Wartegeld", "hideLabel": true, "checked": false, "name": "income_wg", "selectOnFocus": true, "anchor": "-20" });
    var income_2_panel1509 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": income_ag1507, "labelAlign": "top" }, { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": income_wg1508, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 153, "border": false, "anchor": "-20", "labelAlign": "top" });
    var income_kg1512 = new Ext.form.Checkbox({ "boxLabel": "Krankengeld", "hideLabel": true, "checked": false, "name": "income_kg", "selectOnFocus": true, "anchor": "-20" });
    var income_rente1513 = new Ext.form.Checkbox({ "boxLabel": "Rente", "hideLabel": true, "checked": false, "name": "income_rente", "selectOnFocus": true, "anchor": "-20" });
    var income_3_panel1514 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": income_kg1512, "labelAlign": "top" }, { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": income_rente1513, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 108, "border": false, "anchor": "-20", "labelAlign": "top" });
    var income_misc1517 = new Ext.form.Checkbox({ "boxLabel": "andere Einkommen", "hideLabel": true, "checked": false, "name": "income_misc", "selectOnFocus": true, "anchor": "-20" });
    var income_panel1518 = new Ext.Panel({ "flex": 31, "autoHeight": true, "layout": "form", "items": [ { "autoHeight": true, "layout": "form", "xtype": "panel", "items": aid_type1506, "anchor": "-20", "labelAlign": "top" }, income_2_panel1509, income_3_panel1514, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": income_misc1517, "anchor": "-20", "labelAlign": "top" } ], "frame": true, "bodyBorder": false, "autoScroll": false, "hideCheckBoxLabels": true, "labelWidth": 153, "border": false, "labelAlign": "top" });
    var status_tab_1_panel1521 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "hideCheckBoxLabels": true, "items": [ status_panel1505, income_panel1518 ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var is_seeking1522 = new Ext.form.Checkbox({ "boxLabel": "Arbeit suchend", "hideLabel": true, "checked": false, "name": "is_seeking", "selectOnFocus": true, "anchor": "-20" });
    var unemployed_since1523 = new Lino.DateField({ "selectOnFocus": true, "fieldLabel": "eingetragen seit", "anchor": "-20", "name": "unemployed_since" });
    var work_permit_suspended_until1524 = new Lino.DateField({ "selectOnFocus": true, "fieldLabel": "Wartezeit bis", "anchor": "-20", "name": "work_permit_suspended_until" });
    var suche_1_panel1525 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 153, "hideCheckBoxLabels": true, "items": [ { "flex": 38, "autoHeight": true, "layout": "form", "xtype": "panel", "items": is_seeking1522, "labelAlign": "top" }, { "flex": 30, "autoHeight": true, "layout": "form", "xtype": "panel", "items": unemployed_since1523, "labelAlign": "top" }, { "flex": 30, "autoHeight": true, "layout": "form", "xtype": "panel", "items": work_permit_suspended_until1524, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var unavailable_until1529 = new Lino.DateField({ "selectOnFocus": true, "fieldLabel": "Nicht verf\u00fcgbar bis", "anchor": "-20", "name": "unavailable_until" });
    var unavailable_why1530 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 100, "fieldLabel": "Grund", "anchor": "-20", "name": "unavailable_why" });
    var suche_2_panel1531 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 180, "hideCheckBoxLabels": true, "items": [ { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": unavailable_until1529, "labelAlign": "top" }, { "flex": 66, "autoHeight": true, "layout": "form", "xtype": "panel", "items": unavailable_why1530, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var suche_panel1540 = new Ext.form.FieldSet({ "flex": 50, "layout": "vbox", "title": "Arbeitssuche", "layoutConfig": { "align": "stretch" }, "frame": true, "bodyBorder": false, "autoScroll": false, "items": [ suche_1_panel1525, suche_2_panel1531 ], "hideCheckBoxLabels": true, "border": false, "labelAlign": "top" });
    var needs_residence_permit1541 = new Ext.form.Checkbox({ "boxLabel": "Braucht Aufenthaltserlaubnis", "hideLabel": true, "checked": false, "name": "needs_residence_permit", "selectOnFocus": true, "anchor": "-20" });
    var needs_work_permit1542 = new Ext.form.Checkbox({ "boxLabel": "Braucht Arb.Erl.", "hideLabel": true, "checked": false, "name": "needs_work_permit", "selectOnFocus": true, "anchor": "-20" });
    var papers_1_panel1543 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 261, "hideCheckBoxLabels": true, "items": [ { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": needs_residence_permit1541, "labelAlign": "top" }, { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": needs_work_permit1542, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var residence_permit_disp1546 = new Ext.form.DisplayField({ "disabled": true, "fieldLabel": "Aufenthaltserlaubnis", "name": "residence_permit", "anchor": "-20", "value": "<br/>", "always_enabled": true });
    var work_permit_disp1547 = new Ext.form.DisplayField({ "disabled": true, "fieldLabel": "Arbeitserlaubnis", "name": "work_permit", "anchor": "-20", "value": "<br/>", "always_enabled": true });
    var driving_licence_disp1548 = new Ext.form.DisplayField({ "disabled": true, "fieldLabel": "F\u00fchrerschein", "name": "driving_licence", "anchor": "-20", "value": "<br/>", "always_enabled": true });
    var papers_2_panel1549 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 189, "hideCheckBoxLabels": true, "items": [ { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": residence_permit_disp1546, "labelAlign": "top" }, { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": work_permit_disp1547, "labelAlign": "top" }, { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": driving_licence_disp1548, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var UploadsByController_htmlbox1553 = new Lino.HtmlBoxPanel({ "flex": 42, "ls_bbar_actions": [ { "itemId": "insert", "menu_item_text": "Neu", "must_save": true, "tooltip": "Neuen Datensatz erstellen", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-new", "overflowText": "Neu", "auto_save": true } ], "name": "UploadsByController", "containing_panel": this, "items": new Ext.BoxComponent({autoScroll:true}), "title": "Uploads", "master_panel": this, "value": "<br/>", "always_enabled": true, "bodyStyle": "overflow-x:hidden", "ls_insert_handler": Lino.uploads.UploadsByController.insert, "layout": "fit", "tools": [ Lino.show_in_own_window_button(Lino.uploads.UploadsByController.grid) ] });
    var papers_panel1554 = new Ext.form.FieldSet({ "flex": 50, "layout": "vbox", "title": "Papiere", "layoutConfig": { "align": "stretch" }, "frame": true, "bodyBorder": false, "autoScroll": false, "items": [ papers_1_panel1543, papers_2_panel1549, UploadsByController_htmlbox1553 ], "hideCheckBoxLabels": true, "labelWidth": 72, "border": false, "labelAlign": "top" });
    var status_tab_2_panel1555 = new Ext.Panel({ "flex": 63, "border": false, "layout": "hbox", "hideCheckBoxLabels": true, "items": [ suche_panel1540, papers_panel1554 ], "autoScroll": false, "layoutConfig": { "align": "stretch" }, "frame": false, "labelAlign": "top" });
    var status_tab_panel1556 = new Ext.Panel({ "layout": "vbox", "title": "Status", "items": [ status_tab_1_panel1521, status_tab_2_panel1555 ], "frame": true, "layoutConfig": { "align": "stretch" }, "hideCheckBoxLabels": true, "listeners": { "activate": Lino.on_tab_activate }, "autoScroll": false, "border": false, "bodyBorder": false, "labelAlign": "top" });
    var workflow_buttons_disp1557 = new Ext.form.DisplayField({ "disabled": true, "fieldLabel": "Arbeitsablauf", "name": "workflow_buttons", "anchor": "-20", "value": "<br/>", "always_enabled": true });
    var broker1558 = new Lino.RemoteComboFieldElement({ "fieldLabel": "Vermittler", "name": "broker", "pageSize": 20, "emptyText": "Vermittler ausw\u00e4hlen...", "selectOnFocus": true, "hiddenName": "brokerHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/pcsw/Clients/broker", "method": "GET" }) }) });
    var faculty1559 = new Lino.TwinCombo({ "fieldLabel": "Fachbereich", "name": "faculty", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.newcomers.Faculties.detail)}, "emptyText": "Fachbereich ausw\u00e4hlen...", "selectOnFocus": true, "hiddenName": "facultyHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/pcsw/Clients/faculty", "method": "GET" }) }) });
    var newcomers_left_panel1560 = new Ext.Panel({ "flex": 33, "autoHeight": true, "layout": "form", "items": [ { "autoHeight": true, "layout": "form", "xtype": "panel", "items": workflow_buttons_disp1557, "anchor": "-20", "labelAlign": "top" }, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": broker1558, "anchor": "-20", "labelAlign": "top" }, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": faculty1559, "anchor": "-20", "labelAlign": "top" } ], "frame": true, "bodyBorder": false, "autoScroll": false, "hideCheckBoxLabels": true, "labelWidth": 126, "border": false, "labelAlign": "top" });
    var coaching_1_panel1579 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "hideCheckBoxLabels": true, "items": [ newcomers_left_panel1560 ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var pcsw_ContactsByClient_grid1587 = new Lino.pcsw.ContactsByClient.GridPanel({ "tools": [ Lino.show_in_own_window_button(Lino.pcsw.ContactsByClient.grid) ], "containing_panel": this, "hide_top_toolbar": true, "master_panel": this, "flex": 50 });
    var pcsw_CoachingsByClient_grid1595 = new Lino.pcsw.CoachingsByClient.GridPanel({ "tools": [ Lino.show_in_own_window_button(Lino.pcsw.CoachingsByClient.grid) ], "containing_panel": this, "hide_top_toolbar": true, "master_panel": this, "flex": 50 });
    var coaching_2_panel1596 = new Ext.Panel({ "flex": 50, "border": false, "layout": "hbox", "hideCheckBoxLabels": true, "items": [ pcsw_ContactsByClient_grid1587, pcsw_CoachingsByClient_grid1595 ], "autoScroll": false, "layoutConfig": { "align": "stretch" }, "frame": false, "labelAlign": "top" });
    var coaching_panel1597 = new Ext.Panel({ "layout": "vbox", "title": "Begleitung", "items": [ coaching_1_panel1579, coaching_2_panel1596 ], "frame": true, "layoutConfig": { "align": "stretch" }, "hideCheckBoxLabels": true, "listeners": { "activate": Lino.on_tab_activate }, "autoScroll": false, "border": false, "bodyBorder": false, "labelAlign": "top" });
    var skills1680 = new Ext.form.TextArea({ "selectOnFocus": true, "fieldLabel": "Sonstige F\u00e4higkeiten", "anchor": "-20 -10", "growMax": 2000, "name": "skills" });
    var competences_1_panel1681 = new Ext.Panel({ "flex": 5, "layout": "hbox", "items": [ { "items": skills1680, "labelAlign": "top", "layout": "form", "xtype": "panel", "flex": 28 } ], "region": "north", "layoutConfig": { "align": "stretch" }, "hideCheckBoxLabels": true, "split": true, "autoScroll": false, "labelWidth": 189, "border": false, "frame": false, "labelAlign": "top" });
    var obstacles1690 = new Ext.form.TextArea({ "selectOnFocus": true, "fieldLabel": "Hindernisse", "anchor": "-20 -10", "growMax": 2000, "name": "obstacles" });
    var competences_2_panel1691 = new Ext.Panel({ "flex": 5, "layout": "hbox", "items": [ { "items": obstacles1690, "labelAlign": "top", "layout": "form", "xtype": "panel", "flex": 44 } ], "region": "center", "layoutConfig": { "align": "stretch" }, "hideCheckBoxLabels": true, "split": true, "autoScroll": false, "labelWidth": 108, "border": false, "frame": false, "labelAlign": "top" });
    var competences_panel1693 = new Lino.VBorderPanel({ "autoScroll": false, "listeners": { "activate": Lino.on_tab_activate }, "border": false, "title": "Kompetenzen", "hideCheckBoxLabels": true, "items": [ competences_1_panel1681, competences_2_panel1691 ], "frame": true, "bodyBorder": false, "labelAlign": "top" });
    var pcsw_NotesByPerson_grid1930 = new Lino.pcsw.NotesByPerson.GridPanel({ "listeners": { "activate": Lino.on_tab_activate }, "hide_top_toolbar": true, "title": "Historie", "containing_panel": this, "tools": [ Lino.show_in_own_window_button(Lino.pcsw.NotesByPerson.grid) ], "master_panel": this });
    var cal_EventsByProject_grid1956 = new Lino.cal.EventsByProject.GridPanel({ "flex": 5, "hide_top_toolbar": true, "containing_panel": this, "region": "north", "params_panel_hidden": true, "master_panel": this, "split": true, "tools": [ Lino.show_in_own_window_button(Lino.cal.EventsByProject.grid) ] });
    var cal_TasksByProject_grid1979 = new Lino.cal.TasksByProject.GridPanel({ "flex": 5, "hide_top_toolbar": true, "split": true, "containing_panel": this, "region": "center", "tools": [ Lino.show_in_own_window_button(Lino.cal.TasksByProject.grid) ], "master_panel": this });
    var calendar_panel1980 = new Lino.VBorderPanel({ "autoScroll": false, "listeners": { "activate": Lino.on_tab_activate }, "border": false, "title": "Kalender", "hideCheckBoxLabels": true, "items": [ cal_EventsByProject_grid1956, cal_TasksByProject_grid1979 ], "frame": true, "bodyBorder": false, "labelAlign": "top" });
    var outbox_MailsByProject_grid1992 = new Lino.outbox.MailsByProject.GridPanel({ "flex": 5, "hide_top_toolbar": true, "split": true, "containing_panel": this, "region": "north", "tools": [ Lino.show_in_own_window_button(Lino.outbox.MailsByProject.grid) ], "master_panel": this });
    var postings_PostingsByProject_grid2003 = new Lino.postings.PostingsByProject.GridPanel({ "flex": 5, "hide_top_toolbar": true, "split": true, "containing_panel": this, "region": "center", "tools": [ Lino.show_in_own_window_button(Lino.postings.PostingsByProject.grid) ], "master_panel": this });
    var outbox_panel2004 = new Lino.VBorderPanel({ "autoScroll": false, "listeners": { "activate": Lino.on_tab_activate }, "border": false, "title": "Korrespondenz", "hideCheckBoxLabels": true, "items": [ outbox_MailsByProject_grid1992, postings_PostingsByProject_grid2003 ], "frame": true, "bodyBorder": false, "labelAlign": "top" });
    var activity2005 = new Lino.RemoteComboFieldElement({ "fieldLabel": "Beruf", "name": "activity", "pageSize": 20, "emptyText": "Beruf ausw\u00e4hlen...", "selectOnFocus": true, "hiddenName": "activityHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/pcsw/Clients/activity", "method": "GET" }) }) });
    var client_state2006 = new Lino.ChoicesFieldElement({ "forceSelection": true, "fieldLabel": "Zustand", "allowBlank": false, "hiddenName": "client_stateHidden", "selectOnFocus": true, "anchor": "-20", "store": Lino.pcsw.ClientStates, "name": "client_state" });
    var refusal_reason2007 = new Lino.ChoicesFieldElement({ "forceSelection": true, "fieldLabel": "refusal reason", "name": "refusal_reason", "selectOnFocus": true, "anchor": "-20", "store": Lino.pcsw.RefusalReasons, "hiddenName": "refusal_reasonHidden" });
    var misc_1_panel2008 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 135, "hideCheckBoxLabels": true, "items": [ { "flex": 25, "autoHeight": true, "layout": "form", "xtype": "panel", "items": activity2005, "labelAlign": "top" }, { "flex": 15, "autoHeight": true, "layout": "form", "xtype": "panel", "items": client_state2006, "labelAlign": "top" }, { "flex": 58, "autoHeight": true, "layout": "form", "xtype": "panel", "items": refusal_reason2007, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var is_cpas2012 = new Ext.form.Checkbox({ "boxLabel": "Sozialhilfeempf\u00e4nger", "hideLabel": true, "checked": false, "name": "is_cpas", "selectOnFocus": true, "anchor": "-20" });
    var is_senior2013 = new Ext.form.Checkbox({ "boxLabel": "Altenheim", "hideLabel": true, "checked": false, "name": "is_senior", "selectOnFocus": true, "anchor": "-20" });
    var is_obsolete2014 = new Ext.form.Checkbox({ "boxLabel": "veraltet", "listeners": { "render": Lino.quicktip_renderer("veraltet","Altf\u00e4lle sind Partner, deren Stammdaten nicht mehr gepflegt werden und \nf\u00fcr neue Operationen nicht benutzt werden k\u00f6nnen.") }, "hideLabel": true, "checked": false, "name": "is_obsolete", "selectOnFocus": true, "anchor": "-20" });
    var misc_2_panel2015 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 189, "hideCheckBoxLabels": true, "items": [ { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": is_cpas2012, "labelAlign": "top" }, { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": is_senior2013, "labelAlign": "top" }, { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": is_obsolete2014, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var remarks2019 = new Ext.form.TextArea({ "selectOnFocus": true, "fieldLabel": "Bemerkungen", "anchor": "-20 -10", "growMax": 2000, "name": "remarks" });
    var remarks22020 = new Ext.form.TextArea({ "selectOnFocus": true, "fieldLabel": "Bemerkungen (Sozialsekretariat)", "anchor": "-20 -10", "growMax": 2000, "name": "remarks2" });
    var misc_3_panel2021 = new Ext.Panel({ "flex": 41, "border": false, "layout": "hbox", "labelWidth": 288, "hideCheckBoxLabels": true, "items": [ { "items": remarks2019, "labelAlign": "top", "layout": "form", "xtype": "panel", "flex": 50 }, { "items": remarks22020, "labelAlign": "top", "layout": "form", "xtype": "panel", "flex": 50 } ], "autoScroll": false, "layoutConfig": { "align": "stretch" }, "frame": false, "labelAlign": "top" });
    var contacts_RolesByPerson_grid2024 = new Lino.contacts.RolesByPerson.GridPanel({ "tools": [ Lino.show_in_own_window_button(Lino.contacts.RolesByPerson.grid) ], "containing_panel": this, "hide_top_toolbar": true, "master_panel": this, "flex": 33 });
    var households_MembersByPerson_grid2025 = new Lino.households.MembersByPerson.GridPanel({ "tools": [ Lino.show_in_own_window_button(Lino.households.MembersByPerson.grid) ], "containing_panel": this, "hide_top_toolbar": true, "master_panel": this, "flex": 66 });
    var misc_4_panel2026 = new Ext.Panel({ "flex": 41, "border": false, "layout": "hbox", "hideCheckBoxLabels": true, "items": [ contacts_RolesByPerson_grid2024, households_MembersByPerson_grid2025 ], "autoScroll": false, "layoutConfig": { "align": "stretch" }, "frame": false, "labelAlign": "top" });
    var misc_panel2027 = new Ext.Panel({ "layout": "vbox", "title": "Sonstiges", "items": [ misc_1_panel2008, misc_2_panel2015, misc_3_panel2021, misc_4_panel2026 ], "frame": true, "layoutConfig": { "align": "stretch" }, "hideCheckBoxLabels": true, "listeners": { "activate": Lino.on_tab_activate }, "autoScroll": false, "border": false, "bodyBorder": false, "labelAlign": "top" });
    var cbss_identify_person_disp2028 = new Ext.form.DisplayField({ "disabled": true, "fieldLabel": "IdentifyPerson-Anfragen", "name": "cbss_identify_person", "anchor": "-20", "value": "<br/>", "always_enabled": true });
    var cbss_manage_access_disp2029 = new Ext.form.DisplayField({ "disabled": true, "fieldLabel": "ManageAccess-Anfragen", "name": "cbss_manage_access", "anchor": "-20", "value": "<br/>", "always_enabled": true });
    var cbss_retrieve_ti_groups_disp2030 = new Ext.form.DisplayField({ "disabled": true, "fieldLabel": "Tx25-Anfragen", "name": "cbss_retrieve_ti_groups", "anchor": "-20", "value": "<br/>", "always_enabled": true });
    var cbss_1_panel2031 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 216, "hideCheckBoxLabels": true, "items": [ { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": cbss_identify_person_disp2028, "labelAlign": "top" }, { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": cbss_manage_access_disp2029, "labelAlign": "top" }, { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": cbss_retrieve_ti_groups_disp2030, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var cbss_summary_htmlbox2035 = new Lino.HtmlBoxPanel({ "flex": 50, "layout": "fit", "name": "cbss_summary", "containing_panel": this, "items": new Ext.BoxComponent({autoScroll:true}), "title": "Zusammenfassung ZDSS", "master_panel": this, "value": "<br/>", "always_enabled": true, "bodyStyle": "overflow-x:hidden" });
    var cbss_panel2036 = new Ext.Panel({ "layout": "vbox", "title": "ZDSS", "items": [ cbss_1_panel2031, cbss_summary_htmlbox2035 ], "frame": true, "layoutConfig": { "align": "stretch" }, "hideCheckBoxLabels": true, "listeners": { "activate": Lino.on_tab_activate }, "autoScroll": false, "labelWidth": 189, "border": false, "bodyBorder": false, "labelAlign": "top" });
    var debts_BudgetsByPartner_grid2037 = new Lino.debts.BudgetsByPartner.GridPanel({ "flex": 5, "hide_top_toolbar": true, "split": true, "containing_panel": this, "region": "north", "tools": [ Lino.show_in_own_window_button(Lino.debts.BudgetsByPartner.grid) ], "master_panel": this });
    var debts_ActorsByPartner_grid2038 = new Lino.debts.ActorsByPartner.GridPanel({ "flex": 5, "hide_top_toolbar": true, "split": true, "containing_panel": this, "region": "center", "tools": [ Lino.show_in_own_window_button(Lino.debts.ActorsByPartner.grid) ], "master_panel": this });
    var debts_panel2039 = new Lino.VBorderPanel({ "autoScroll": false, "listeners": { "activate": Lino.on_tab_activate }, "border": false, "title": "Schuldnerberatung", "hideCheckBoxLabels": true, "items": [ debts_BudgetsByPartner_grid2037, debts_ActorsByPartner_grid2038 ], "frame": true, "bodyBorder": false, "labelAlign": "top" });
    var main_panel2040 = new Ext.TabPanel({ "hideCheckBoxLabels": true, "border": false, "split": true, "autoScroll": false, "items": [ general_panel1487, status_tab_panel1556, coaching_panel1597, competences_panel1693, pcsw_NotesByPerson_grid1930, calendar_panel1980, outbox_panel2004, misc_panel2027, cbss_panel2036, debts_panel2039 ], "activeTab": 0, "bodyBorder": false, "frame": true, "labelAlign": "top" });
    this.items = main_panel2040;
    this.before_row_edit = function(record) {
      city1413.setContextValue('country',record ? record.data['countryHidden'] : undefined);
      city1413.setContextValue('region',record ? record.data['regionHidden'] : undefined);
      image_htmlbox1485.refresh();
      UploadsByController_htmlbox1553.refresh();
      pcsw_ContactsByClient_grid1587.on_master_changed();
      pcsw_CoachingsByClient_grid1595.on_master_changed();
      pcsw_NotesByPerson_grid1930.on_master_changed();
      cal_EventsByProject_grid1956.on_master_changed();
      cal_TasksByProject_grid1979.on_master_changed();
      outbox_MailsByProject_grid1992.on_master_changed();
      postings_PostingsByProject_grid2003.on_master_changed();
      contacts_RolesByPerson_grid2024.on_master_changed();
      households_MembersByPerson_grid2025.on_master_changed();
      cbss_summary_htmlbox2035.refresh();
      debts_BudgetsByPartner_grid2037.on_master_changed();
      debts_ActorsByPartner_grid2038.on_master_changed();
    }
    this.onRender = function(ct, position) {
      country1412.on('change',Lino.chooser_handler(city1413,'country'));
      Lino.pcsw.Clients.DetailFormPanel.superclass.onRender.call(this, ct, position);
    }
    Lino.pcsw.Clients.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.countries.Countries.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 11,
  initComponent : function() {
    var containing_panel = this;
    var isocode260 = new Ext.form.TextField({ "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">ISO-Code</span>", "name": "isocode", "boxMinWidth": Lino.chars2width(4), "listeners": { "render": Lino.quicktip_renderer("ISO-Code","        The two-letter code for this country as defined by ISO 3166-1. \n        For countries that no longer exist it may be a 4-letter code.") }, "maxLength": 4, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var name261 = new Ext.form.TextField({ "fieldLabel": "Bezeichnung", "name": "name", "maxLength": 200, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var name_fr262 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200, "fieldLabel": "Bezeichnung (fr)", "anchor": "-20", "name": "name_fr" });
    var name_nl263 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200, "fieldLabel": "Bezeichnung (nl)", "anchor": "-20", "name": "name_nl" });
    var short_code264 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Short code","A short abbreviation for regional usage. Obsolete.") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Short code</span>", "name": "short_code", "maxLength": 4, "selectOnFocus": true, "boxMinWidth": Lino.chars2width(4), "anchor": "-20" });
    var inscode265 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("INS-Code","The official code for this country used by statbel.fgov.be") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">INS-Code</span>", "name": "inscode", "maxLength": 3, "selectOnFocus": true, "boxMinWidth": Lino.chars2width(3), "anchor": "-20" });
    var main_1_panel266 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 153, "hideCheckBoxLabels": true, "items": [ { "flex": 6, "autoHeight": true, "layout": "form", "xtype": "panel", "items": isocode260, "labelAlign": "top" }, { "flex": 27, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name261, "labelAlign": "top" }, { "flex": 27, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_fr262, "labelAlign": "top" }, { "flex": 27, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_nl263, "labelAlign": "top" }, { "flex": 6, "autoHeight": true, "layout": "form", "xtype": "panel", "items": short_code264, "labelAlign": "top" }, { "flex": 5, "autoHeight": true, "layout": "form", "xtype": "panel", "items": inscode265, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var countries_CitiesByCountry_grid573 = new Lino.countries.CitiesByCountry.GridPanel({ "tools": [ Lino.show_in_own_window_button(Lino.countries.CitiesByCountry.grid) ], "containing_panel": this, "hide_top_toolbar": true, "master_panel": this, "flex": 48 });
    var main_2_panel587 = new Ext.Panel({ "flex": 83, "border": false, "layout": "hbox", "hideCheckBoxLabels": true, "items": [ countries_CitiesByCountry_grid573 ], "autoScroll": false, "layoutConfig": { "align": "stretch" }, "frame": false, "labelAlign": "top" });
    var main_panel588 = new Ext.Panel({ "autoScroll": false, "border": false, "layout": "vbox", "hideCheckBoxLabels": true, "items": [ main_1_panel266, main_2_panel587 ], "frame": true, "layoutConfig": { "align": "stretch" }, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel588;
    this.before_row_edit = function(record) {
      countries_CitiesByCountry_grid573.on_master_changed();
    }
    Lino.countries.Countries.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.cbss.RetrieveTIGroupsRequests.InsertFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  autoHeight: true,
  content_type: 87,
  initComponent : function() {
    var containing_panel = this;
    var person2248 = new Lino.TwinCombo({ "fieldLabel": "Klient", "allowBlank": false, "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.pcsw.Clients.detail)}, "emptyText": "Klient ausw\u00e4hlen...", "selectOnFocus": true, "hiddenName": "personHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cbss/RetrieveTIGroupsRequests/person", "method": "GET" }) }), "name": "person" });
    var national_id2249 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200, "fieldLabel": "NR-Nummer", "anchor": "-20", "name": "national_id" });
    var language2250 = new Lino.ChoicesFieldElement({ "forceSelection": true, "fieldLabel": "Sprache", "name": "language", "selectOnFocus": true, "anchor": "-20", "store": Lino.cbss.RequestLanguages, "hiddenName": "languageHidden" });
    var main_2_panel2251 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 55, "autoHeight": true, "layout": "form", "xtype": "panel", "items": national_id2249, "labelAlign": "top" }, { "flex": 44, "autoHeight": true, "layout": "form", "xtype": "panel", "items": language2250, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 90, "border": false, "anchor": "-20", "labelAlign": "top" });
    var history2254 = new Ext.form.Checkbox({ "boxLabel": "Historie", "listeners": { "render": Lino.quicktip_renderer("Historie","Whatever this means.") }, "hideLabel": true, "checked": true, "name": "history", "selectOnFocus": true, "anchor": "-20" });
    var main_panel2255 = new Ext.Panel({ "hideCheckBoxLabels": true, "autoHeight": true, "border": false, "layout": "form", "labelWidth": 81, "autoScroll": false, "items": [ { "autoHeight": true, "layout": "form", "xtype": "panel", "items": person2248, "anchor": "-20", "labelAlign": "top" }, main_2_panel2251, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": history2254, "anchor": "-20", "labelAlign": "top" } ], "frame": true, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel2255;
    this.before_row_edit = function(record) {
    }
    Lino.cbss.RetrieveTIGroupsRequests.InsertFormPanel.superclass.initComponent.call(this);
  }
});


Lino.users.MySettings.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 7,
  initComponent : function() {
    var containing_panel = this;
    var username78 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Benutzername","\n        Required. Must be unique. \n        ") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Benutzername</span>", "name": "username", "maxLength": 30, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var id79 = new Ext.form.NumberField({ "selectOnFocus": true, "fieldLabel": "ID", "anchor": "-20", "name": "id" });
    var profile80 = new Lino.ChoicesFieldElement({ "forceSelection": true, "fieldLabel": "Benutzerprofil", "name": "profile", "selectOnFocus": true, "anchor": "-20", "store": Lino.lino.UserProfiles, "hiddenName": "profileHidden" });
    var box1_1_panel81 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 29, "autoHeight": true, "layout": "form", "xtype": "panel", "items": username78, "labelAlign": "top" }, { "flex": 6, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id79, "labelAlign": "top" }, { "flex": 63, "autoHeight": true, "layout": "form", "xtype": "panel", "items": profile80, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 135, "border": false, "anchor": "-20", "labelAlign": "top" });
    var first_name85 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 30, "fieldLabel": "Vorname", "anchor": "-20", "name": "first_name" });
    var last_name86 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 30, "fieldLabel": "Familienname", "anchor": "-20", "name": "last_name" });
    var partner87 = new Lino.TwinCombo({ "fieldLabel": "Partner", "name": "partner", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.contacts.Partners.detail)}, "emptyText": "Partner ausw\u00e4hlen...", "selectOnFocus": true, "hiddenName": "partnerHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/users/Users/partner", "method": "GET" }) }) });
    var box1_2_panel88 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": first_name85, "labelAlign": "top" }, { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": last_name86, "labelAlign": "top" }, { "flex": 32, "autoHeight": true, "layout": "form", "xtype": "panel", "items": partner87, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 117, "border": false, "anchor": "-20", "labelAlign": "top" });
    var email92 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 75, "fieldLabel": "e-mail address", "anchor": "-20", "name": "email" });
    var language93 = new Lino.ChoicesFieldElement({ "fieldLabel": "Sprache", "allowBlank": false, "selectOnFocus": true, "hiddenName": "languageHidden", "anchor": "-20", "store": [ [ "de", "Deutsch" ], [ "fr", "Franz\u00f6sisch" ], [ "nl", "Niederl\u00e4ndisch" ] ], "name": "language" });
    var box1_3_panel94 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 51, "autoHeight": true, "layout": "form", "xtype": "panel", "items": email92, "labelAlign": "top" }, { "flex": 48, "autoHeight": true, "layout": "form", "xtype": "panel", "items": language93, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 135, "border": false, "anchor": "-20", "labelAlign": "top" });
    var created97 = new Ext.form.DisplayField({ "disabled": true, "fieldLabel": "Erstellt", "anchor": "-20", "value": "<br>", "name": "created" });
    var modified98 = new Ext.form.DisplayField({ "disabled": true, "fieldLabel": "Bearbeitet", "anchor": "-20", "value": "<br>", "name": "modified" });
    var box1_4_panel99 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": created97, "labelAlign": "top" }, { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": modified98, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 99, "border": false, "anchor": "-20", "labelAlign": "top" });
    var box1_panel102 = new Ext.Panel({ "flex": 66, "autoHeight": true, "border": false, "layout": "form", "hideCheckBoxLabels": true, "items": [ box1_1_panel81, box1_2_panel88, box1_3_panel94, box1_4_panel99 ], "frame": true, "autoScroll": false, "bodyBorder": false, "labelAlign": "top" });
    var general_1_panel106 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "hideCheckBoxLabels": true, "items": [ box1_panel102 ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var remarks107 = new Ext.form.TextArea({ "selectOnFocus": true, "fieldLabel": "Bemerkungen", "anchor": "-20 -10", "growMax": 2000, "name": "remarks" });
    var AuthoritiesGiven_grid110 = new Lino.users.AuthoritiesGiven.GridPanel({ "tools": [ Lino.show_in_own_window_button(Lino.users.AuthoritiesGiven.grid) ], "containing_panel": this, "hide_top_toolbar": true, "master_panel": this, "flex": 33 });
    var general_2_panel111 = new Ext.Panel({ "flex": 50, "border": false, "layout": "hbox", "labelWidth": 108, "hideCheckBoxLabels": true, "items": [ { "items": remarks107, "labelAlign": "top", "layout": "form", "xtype": "panel", "flex": 66 }, AuthoritiesGiven_grid110 ], "autoScroll": false, "layoutConfig": { "align": "stretch" }, "frame": false, "labelAlign": "top" });
    var general_panel113 = new Ext.Panel({ "layout": "vbox", "title": "Allgemein", "items": [ general_1_panel106, general_2_panel111 ], "frame": true, "layoutConfig": { "align": "stretch" }, "hideCheckBoxLabels": true, "listeners": { "activate": Lino.on_tab_activate }, "autoScroll": false, "border": false, "bodyBorder": false, "labelAlign": "top" });
    var calendar114 = new Lino.TwinCombo({ "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Standard-Kalender</span>", "name": "calendar", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.cal.Calendars.detail)}, "emptyText": "Kalender ausw\u00e4hlen...", "listeners": { "render": Lino.quicktip_renderer("Standard-Kalender","The default calendar for your events and tasks.") }, "selectOnFocus": true, "hiddenName": "calendarHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/users/Users/calendar", "method": "GET" }) }) });
    var access_class115 = new Lino.ChoicesFieldElement({ "forceSelection": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Standardm\u00e4\u00dfige Zugriffsklasse</span>", "allowBlank": false, "hiddenName": "access_classHidden", "listeners": { "render": Lino.quicktip_renderer("Standardm\u00e4\u00dfige Zugriffsklasse","Die standardm\u00e4\u00dfige Zugriffsklasse f\u00fcr Ihre Termine und Aufgaben") }, "selectOnFocus": true, "anchor": "-20", "store": Lino.cal.AccessClasses, "name": "access_class" });
    var cal_left_1_panel116 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 270, "hideCheckBoxLabels": true, "items": [ { "flex": 37, "autoHeight": true, "layout": "form", "xtype": "panel", "items": calendar114, "labelAlign": "top" }, { "flex": 62, "autoHeight": true, "layout": "form", "xtype": "panel", "items": access_class115, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var cal_SubscriptionsByUser_grid123 = new Lino.cal.SubscriptionsByUser.GridPanel({ "tools": [ Lino.show_in_own_window_button(Lino.cal.SubscriptionsByUser.grid) ], "containing_panel": this, "hide_top_toolbar": true, "master_panel": this, "flex": 83 });
    var cal_left_panel124 = new Ext.Panel({ "flex": 33, "border": false, "layout": "vbox", "bodyBorder": false, "hideCheckBoxLabels": true, "items": [ cal_left_1_panel116, cal_SubscriptionsByUser_grid123 ], "autoScroll": false, "layoutConfig": { "align": "stretch" }, "frame": true, "labelAlign": "top" });
    var cal_TasksByUser_grid182 = new Lino.cal.TasksByUser.GridPanel({ "tools": [ Lino.show_in_own_window_button(Lino.cal.TasksByUser.grid) ], "containing_panel": this, "hide_top_toolbar": true, "master_panel": this, "flex": 66 });
    var cal_1_panel183 = new Ext.Panel({ "autoScroll": false, "listeners": { "activate": Lino.on_tab_activate }, "border": false, "layout": "hbox", "title": "Kalender", "hideCheckBoxLabels": true, "items": [ cal_left_panel124, cal_TasksByUser_grid182 ], "frame": false, "layoutConfig": { "align": "stretch" }, "labelAlign": "top" });
    var newcomer_quota184 = new Ext.form.NumberField({ "listeners": { "render": Lino.quicktip_renderer("Quote NZ","Wieviel Arbeitszeit dieser Benutzer f\u00fcr Neuantr\u00e4ge zur Verf\u00fcgung steht\n(100 = ganztags, 50 = halbtags, 0 = gar nicht).\nWenn zwei Benutzer die gleiche Belastungspunktzahl haben, \naber einer davon sich nur zu 50% um Neuantr\u00e4ge k\u00fcmmert, \ngilt er als doppelt so belastet wie sein Kollege.\n") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Quote NZ</span>", "name": "newcomer_quota", "selectOnFocus": true, "anchor": "-20", "value": 0, "allowBlank": false });
    var coaching_type185 = new Lino.RemoteComboFieldElement({ "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Dienst</span>", "name": "coaching_type", "pageSize": 20, "emptyText": "Dienst ausw\u00e4hlen...", "listeners": { "render": Lino.quicktip_renderer("Dienst","The default CoachingType used when creating Coachings.") }, "selectOnFocus": true, "hiddenName": "coaching_typeHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/users/Users/coaching_type", "method": "GET" }) }) });
    var coaching_supervisor186 = new Ext.form.Checkbox({ "boxLabel": "Benachrichtigung wenn ein Begleiter zugewiesen wird", "listeners": { "render": Lino.quicktip_renderer("Benachrichtigung wenn ein Begleiter zugewiesen wird","Wenn ein Neuantrag einem Begleiter zugewiesen wurde, wird au\u00dfer dem Begleiter auch dieser Benutzer benachrichtigt.") }, "hideLabel": true, "checked": false, "name": "coaching_supervisor", "selectOnFocus": true, "anchor": "-20" });
    var newcomers_CompetencesByUser_grid192 = new Lino.newcomers.CompetencesByUser.GridPanel({ "tools": [ Lino.show_in_own_window_button(Lino.newcomers.CompetencesByUser.grid) ], "containing_panel": this, "hide_top_toolbar": true, "master_panel": this, "flex": 62 });
    var coaching_a_panel193 = new Ext.Panel({ "flex": 33, "layout": "vbox", "items": [ { "items": newcomer_quota184, "autoHeight": true, "layout": "form", "xtype": "panel", "labelAlign": "top" }, { "items": coaching_type185, "autoHeight": true, "layout": "form", "xtype": "panel", "labelAlign": "top" }, { "items": coaching_supervisor186, "autoHeight": true, "layout": "form", "xtype": "panel", "labelAlign": "top" }, newcomers_CompetencesByUser_grid192 ], "frame": true, "layoutConfig": { "align": "stretch" }, "autoScroll": false, "hideCheckBoxLabels": true, "labelWidth": 468, "border": false, "bodyBorder": false, "labelAlign": "top" });
    var pcsw_CoachingsByUser_grid204 = new Lino.pcsw.CoachingsByUser.GridPanel({ "tools": [ Lino.show_in_own_window_button(Lino.pcsw.CoachingsByUser.grid) ], "containing_panel": this, "hide_top_toolbar": true, "master_panel": this, "flex": 66 });
    var coaching_1_panel205 = new Ext.Panel({ "autoScroll": false, "listeners": { "activate": Lino.on_tab_activate }, "border": false, "layout": "hbox", "title": "Begleitung", "hideCheckBoxLabels": true, "items": [ coaching_a_panel193, pcsw_CoachingsByUser_grid204 ], "frame": false, "layoutConfig": { "align": "stretch" }, "labelAlign": "top" });
    var main_panel206 = new Ext.TabPanel({ "hideCheckBoxLabels": true, "border": false, "split": true, "autoScroll": false, "items": [ general_panel113, cal_1_panel183, coaching_1_panel205 ], "activeTab": 0, "bodyBorder": false, "frame": true, "labelAlign": "top" });
    this.items = main_panel206;
    this.before_row_edit = function(record) {
      AuthoritiesGiven_grid110.on_master_changed();
      cal_SubscriptionsByUser_grid123.on_master_changed();
      cal_TasksByUser_grid182.on_master_changed();
      newcomers_CompetencesByUser_grid192.on_master_changed();
      pcsw_CoachingsByUser_grid204.on_master_changed();
    }
    Lino.users.MySettings.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.courses.CourseProviders.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 77,
  initComponent : function() {
    var containing_panel = this;
    var prefix2077 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200, "fieldLabel": "prefix", "anchor": "-20", "name": "prefix" });
    var name2078 = new Ext.form.TextField({ "fieldLabel": "Name", "name": "name", "maxLength": 200, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var id2079 = new Ext.form.NumberField({ "selectOnFocus": true, "fieldLabel": "ID", "anchor": "-20", "name": "id" });
    var language2080 = new Lino.ChoicesFieldElement({ "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Sprache</span>", "allowBlank": false, "value": "de", "hiddenName": "languageHidden", "listeners": { "render": Lino.quicktip_renderer("Sprache","Die Sprache, in der Dokumente ausgestellt werden sollen.") }, "selectOnFocus": true, "anchor": "-20", "store": [ [ "de", "Deutsch" ], [ "fr", "Franz\u00f6sisch" ], [ "nl", "Niederl\u00e4ndisch" ] ], "name": "language" });
    var intro_box_1_panel2081 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 31, "autoHeight": true, "layout": "form", "xtype": "panel", "items": prefix2077, "labelAlign": "top" }, { "flex": 31, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name2078, "labelAlign": "top" }, { "flex": 7, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id2079, "labelAlign": "top" }, { "flex": 29, "autoHeight": true, "layout": "form", "xtype": "panel", "items": language2080, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 72, "border": false, "anchor": "-20", "labelAlign": "top" });
    var vat_id2086 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200, "fieldLabel": "MWSt.-Nr.", "anchor": "-20", "name": "vat_id" });
    var activity2087 = new Lino.RemoteComboFieldElement({ "fieldLabel": "Beruf", "name": "activity", "pageSize": 20, "emptyText": "Beruf ausw\u00e4hlen...", "selectOnFocus": true, "hiddenName": "activityHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/courses/CourseProviders/activity", "method": "GET" }) }) });
    var type2088 = new Lino.RemoteComboFieldElement({ "fieldLabel": "Organisationsart", "name": "type", "pageSize": 20, "emptyText": "Organisationsart ausw\u00e4hlen...", "selectOnFocus": true, "hiddenName": "typeHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/courses/CourseProviders/type", "method": "GET" }) }) });
    var intro_box_2_panel2089 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 23, "autoHeight": true, "layout": "form", "xtype": "panel", "items": vat_id2086, "labelAlign": "top" }, { "flex": 38, "autoHeight": true, "layout": "form", "xtype": "panel", "items": activity2087, "labelAlign": "top" }, { "flex": 38, "autoHeight": true, "layout": "form", "xtype": "panel", "items": type2088, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 153, "border": false, "anchor": "-20", "labelAlign": "top" });
    var bank_account12093 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 40, "fieldLabel": "Bankkonto 1", "anchor": "-20", "name": "bank_account1" });
    var bank_account22094 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 40, "fieldLabel": "Bankkonto 2", "anchor": "-20", "name": "bank_account2" });
    var is_obsolete2095 = new Ext.form.Checkbox({ "boxLabel": "veraltet", "listeners": { "render": Lino.quicktip_renderer("veraltet","Altf\u00e4lle sind Partner, deren Stammdaten nicht mehr gepflegt werden und \nf\u00fcr neue Operationen nicht benutzt werden k\u00f6nnen.") }, "hideLabel": true, "checked": false, "name": "is_obsolete", "selectOnFocus": true, "anchor": "-20" });
    var intro_box_3_panel2096 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 40, "autoHeight": true, "layout": "form", "xtype": "panel", "items": bank_account12093, "labelAlign": "top" }, { "flex": 40, "autoHeight": true, "layout": "form", "xtype": "panel", "items": bank_account22094, "labelAlign": "top" }, { "flex": 19, "autoHeight": true, "layout": "form", "xtype": "panel", "items": is_obsolete2095, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 108, "border": false, "anchor": "-20", "labelAlign": "top" });
    var intro_box_panel2100 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "form", "hideCheckBoxLabels": true, "items": [ intro_box_1_panel2081, intro_box_2_panel2089, intro_box_3_panel2096 ], "frame": true, "bodyBorder": false, "labelAlign": "top" });
    var country2101 = new Lino.TwinCombo({ "fieldLabel": "Land", "name": "country", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.countries.Countries.detail)}, "emptyText": "Land ausw\u00e4hlen...", "selectOnFocus": true, "hiddenName": "countryHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/courses/CourseProviders/country", "method": "GET" }) }) });
    var region2102 = new Lino.TwinCombo({ "fieldLabel": "Region", "name": "region", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.countries.Cities.detail)}, "emptyText": "Ort ausw\u00e4hlen...", "selectOnFocus": true, "hiddenName": "regionHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/courses/CourseProviders/region", "method": "GET" }) }) });
    var box3_1_panel2103 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": country2101, "labelAlign": "top" }, { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": region2102, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 63, "border": false, "anchor": "-20", "labelAlign": "top" });
    var city2106 = new Lino.TwinCombo({ "forceSelection": false, "fieldLabel": "Ort", "name": "city", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.countries.Cities.detail)}, "emptyText": "Ort ausw\u00e4hlen...", "selectOnFocus": true, "hiddenName": "cityHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/courses/CourseProviders/city", "method": "GET" }) }) });
    var zip_code2107 = new Ext.form.TextField({ "fieldLabel": "Postleitzahl", "name": "zip_code", "maxLength": 10, "selectOnFocus": true, "boxMinWidth": Lino.chars2width(10), "anchor": "-20" });
    var box3_2_panel2108 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 66, "autoHeight": true, "layout": "form", "xtype": "panel", "items": city2106, "labelAlign": "top" }, { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": zip_code2107, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 117, "border": false, "anchor": "-20", "labelAlign": "top" });
    var street_prefix2111 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Pr\u00e4fix Stra\u00dfe","Text to print before name of street, but to ignore for sorting.") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Pr\u00e4fix Stra\u00dfe</span>", "name": "street_prefix", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var street2112 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Stra\u00dfe","Name of street. Without house number.") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Stra\u00dfe</span>", "name": "street", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var street_no2113 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Nr.","House number") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Nr.</span>", "name": "street_no", "maxLength": 10, "selectOnFocus": true, "boxMinWidth": Lino.chars2width(10), "anchor": "-20" });
    var street_box2114 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Box","Text to print after :attr:`steet_no` on the same line") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Box</span>", "name": "street_box", "maxLength": 10, "selectOnFocus": true, "boxMinWidth": Lino.chars2width(10), "anchor": "-20" });
    var box3_3_panel2115 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 30, "autoHeight": true, "layout": "form", "xtype": "panel", "items": street_prefix2111, "labelAlign": "top" }, { "flex": 36, "autoHeight": true, "layout": "form", "xtype": "panel", "items": street2112, "labelAlign": "top" }, { "flex": 16, "autoHeight": true, "layout": "form", "xtype": "panel", "items": street_no2113, "labelAlign": "top" }, { "flex": 16, "autoHeight": true, "layout": "form", "xtype": "panel", "items": street_box2114, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 126, "border": false, "anchor": "-20", "labelAlign": "top" });
    var addr22120 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Adresszeile nach Stra\u00dfe","Address line to print below street line") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Adresszeile nach Stra\u00dfe</span>", "name": "addr2", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var box3_panel2121 = new Ext.Panel({ "flex": 62, "autoHeight": true, "layout": "form", "items": [ box3_1_panel2103, box3_2_panel2108, box3_3_panel2115, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": addr22120, "anchor": "-20", "labelAlign": "top" } ], "frame": true, "bodyBorder": false, "autoScroll": false, "hideCheckBoxLabels": true, "labelWidth": 216, "border": false, "labelAlign": "top" });
    var email2123 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 75, "fieldLabel": "E-Mail", "anchor": "-20", "name": "email" });
    var url2124 = new Lino.URLField({ "selectOnFocus": true, "maxLength": 200, "fieldLabel": "URL", "anchor": "-20", "name": "url" });
    var phone2125 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200, "fieldLabel": "Telefon", "anchor": "-20", "name": "phone" });
    var gsm2126 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200, "fieldLabel": "GSM", "anchor": "-20", "name": "gsm" });
    var box4_panel2127 = new Ext.Panel({ "flex": 37, "autoHeight": true, "layout": "form", "items": [ { "autoHeight": true, "layout": "form", "xtype": "panel", "items": email2123, "anchor": "-20", "labelAlign": "top" }, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": url2124, "anchor": "-20", "labelAlign": "top" }, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": phone2125, "anchor": "-20", "labelAlign": "top" }, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": gsm2126, "anchor": "-20", "labelAlign": "top" } ], "frame": true, "bodyBorder": false, "autoScroll": false, "hideCheckBoxLabels": true, "labelWidth": 72, "border": false, "labelAlign": "top" });
    var address_box_panel2132 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "hideCheckBoxLabels": true, "items": [ box3_panel2121, box4_panel2127 ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var remarks2133 = new Ext.form.TextArea({ "selectOnFocus": true, "fieldLabel": "Bemerkungen", "anchor": "-20 -10", "growMax": 2000, "name": "remarks" });
    var contacts_RolesByCompany_grid2134 = new Lino.contacts.RolesByCompany.GridPanel({ "tools": [ Lino.show_in_own_window_button(Lino.contacts.RolesByCompany.grid) ], "containing_panel": this, "hide_top_toolbar": true, "master_panel": this, "flex": 42 });
    var bottom_box_panel2135 = new Ext.Panel({ "flex": 41, "border": false, "layout": "hbox", "labelWidth": 108, "hideCheckBoxLabels": true, "items": [ { "items": remarks2133, "labelAlign": "top", "layout": "form", "xtype": "panel", "flex": 57 }, contacts_RolesByCompany_grid2134 ], "autoScroll": false, "layoutConfig": { "align": "stretch" }, "frame": false, "labelAlign": "top" });
    var general_panel2137 = new Ext.Panel({ "layout": "vbox", "title": "Allgemein", "items": [ intro_box_panel2100, address_box_panel2132, bottom_box_panel2135 ], "frame": true, "layoutConfig": { "align": "stretch" }, "hideCheckBoxLabels": true, "listeners": { "activate": Lino.on_tab_activate }, "autoScroll": false, "border": false, "bodyBorder": false, "labelAlign": "top" });
    var pcsw_NotesByCompany_grid2138 = new Lino.pcsw.NotesByCompany.GridPanel({ "listeners": { "activate": Lino.on_tab_activate }, "hide_top_toolbar": true, "title": "Ereignisse/Notizen", "containing_panel": this, "tools": [ Lino.show_in_own_window_button(Lino.pcsw.NotesByCompany.grid) ], "master_panel": this });
    var CourseOffersByProvider_grid2186 = new Lino.courses.CourseOffersByProvider.GridPanel({ "listeners": { "activate": Lino.on_tab_activate }, "hide_top_toolbar": true, "title": "Kursangebote", "containing_panel": this, "tools": [ Lino.show_in_own_window_button(Lino.courses.CourseOffersByProvider.grid) ], "master_panel": this });
    var main_panel2187 = new Ext.TabPanel({ "hideCheckBoxLabels": true, "border": false, "split": true, "autoScroll": false, "items": [ general_panel2137, pcsw_NotesByCompany_grid2138, CourseOffersByProvider_grid2186 ], "activeTab": 0, "bodyBorder": false, "frame": true, "labelAlign": "top" });
    this.items = main_panel2187;
    this.before_row_edit = function(record) {
      region2102.setContextValue('country',record ? record.data['countryHidden'] : undefined);
      city2106.setContextValue('country',record ? record.data['countryHidden'] : undefined);
      city2106.setContextValue('region',record ? record.data['regionHidden'] : undefined);
      contacts_RolesByCompany_grid2134.on_master_changed();
      pcsw_NotesByCompany_grid2138.on_master_changed();
      CourseOffersByProvider_grid2186.on_master_changed();
    }
    this.onRender = function(ct, position) {
      country2101.on('change',Lino.chooser_handler(region2102,'country'));
      country2101.on('change',Lino.chooser_handler(city2106,'country'));
      region2102.on('change',Lino.chooser_handler(city2106,'region'));
      Lino.courses.CourseProviders.DetailFormPanel.superclass.onRender.call(this, ct, position);
    }
    Lino.courses.CourseProviders.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.accounts.Groups.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 44,
  initComponent : function() {
    var containing_panel = this;
    var ref1207 = new Ext.form.TextField({ "fieldLabel": "ref", "name": "ref", "maxLength": 5, "selectOnFocus": true, "boxMinWidth": Lino.chars2width(5), "anchor": "-20" });
    var name1208 = new Ext.form.TextField({ "fieldLabel": "Bezeichnung", "name": "name", "maxLength": 200, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var name_fr1209 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200, "fieldLabel": "Bezeichnung (fr)", "anchor": "-20", "name": "name_fr" });
    var name_nl1210 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200, "fieldLabel": "Bezeichnung (nl)", "anchor": "-20", "name": "name_nl" });
    var main_1_panel1211 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 153, "hideCheckBoxLabels": true, "items": [ { "flex": 8, "autoHeight": true, "layout": "form", "xtype": "panel", "items": ref1207, "labelAlign": "top" }, { "flex": 30, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name1208, "labelAlign": "top" }, { "flex": 30, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_fr1209, "labelAlign": "top" }, { "flex": 30, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_nl1210, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var account_type1216 = new Lino.ChoicesFieldElement({ "forceSelection": true, "fieldLabel": "Kontenart", "name": "account_type", "selectOnFocus": true, "anchor": "-20", "store": Lino.accounts.AccountTypes, "hiddenName": "account_typeHidden" });
    var id1217 = new Ext.form.NumberField({ "selectOnFocus": true, "fieldLabel": "ID", "anchor": "-20", "name": "id" });
    var main_2_panel1218 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 90, "hideCheckBoxLabels": true, "items": [ { "flex": 78, "autoHeight": true, "layout": "form", "xtype": "panel", "items": account_type1216, "labelAlign": "top" }, { "flex": 21, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id1217, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var help_text1221 = new Lino.RichTextPanel({ "selectOnFocus": true, "flex": 41, "containing_panel": this, "name": "help_text", "title": "Einleitung" });
    var AccountsByGroup_grid1232 = new Lino.accounts.AccountsByGroup.GridPanel({ "tools": [ Lino.show_in_own_window_button(Lino.accounts.AccountsByGroup.grid) ], "containing_panel": this, "hide_top_toolbar": true, "master_panel": this, "flex": 41 });
    var main_panel1233 = new Ext.Panel({ "autoScroll": false, "border": false, "layout": "vbox", "labelWidth": 0, "hideCheckBoxLabels": true, "items": [ main_1_panel1211, main_2_panel1218, help_text1221, AccountsByGroup_grid1232 ], "frame": true, "layoutConfig": { "align": "stretch" }, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel1233;
    this.before_row_edit = function(record) {
      help_text1221.refresh();
      AccountsByGroup_grid1232.on_master_changed();
    }
    Lino.accounts.Groups.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.changes.Changes.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 10,
  disable_editing: true,
  initComponent : function() {
    var containing_panel = this;
    var time225 = new Ext.form.DisplayField({ "fieldLabel": "time", "name": "time", "selectOnFocus": true, "anchor": "-20", "value": "<br>", "allowBlank": false });
    var user226 = new Lino.TwinCombo({ "fieldLabel": "Benutzer", "allowBlank": false, "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.users.Users.detail)}, "emptyText": "Benutzer ausw\u00e4hlen...", "selectOnFocus": true, "hiddenName": "userHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/changes/Changes/user", "method": "GET" }) }), "name": "user" });
    var type227 = new Lino.ChoicesFieldElement({ "forceSelection": true, "fieldLabel": "\u00c4nderungsart", "allowBlank": false, "hiddenName": "typeHidden", "selectOnFocus": true, "anchor": "-20", "store": Lino.lino.ChangeTypes, "name": "type" });
    var master_disp228 = new Ext.form.DisplayField({ "disabled": true, "fieldLabel": "Stammdaten", "anchor": "-20", "name": "master" });
    var object_disp229 = new Ext.form.DisplayField({ "disabled": true, "fieldLabel": "Object", "anchor": "-20", "name": "object" });
    var id230 = new Ext.form.NumberField({ "selectOnFocus": true, "fieldLabel": "ID", "anchor": "-20", "name": "id" });
    var main_1_panel231 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 117, "hideCheckBoxLabels": true, "items": [ { "flex": 21, "autoHeight": true, "layout": "form", "xtype": "panel", "items": time225, "labelAlign": "top" }, { "flex": 20, "autoHeight": true, "layout": "form", "xtype": "panel", "items": user226, "labelAlign": "top" }, { "flex": 23, "autoHeight": true, "layout": "form", "xtype": "panel", "items": type227, "labelAlign": "top" }, { "flex": 13, "autoHeight": true, "layout": "form", "xtype": "panel", "items": master_disp228, "labelAlign": "top" }, { "flex": 13, "autoHeight": true, "layout": "form", "xtype": "panel", "items": object_disp229, "labelAlign": "top" }, { "flex": 6, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id230, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var diff238 = new Ext.form.TextArea({ "selectOnFocus": true, "fieldLabel": "\u00c4nderungen", "anchor": "-20 -10", "growMax": 2000, "name": "diff" });
    var main_panel239 = new Ext.Panel({ "autoScroll": false, "border": false, "layout": "vbox", "labelWidth": 99, "hideCheckBoxLabels": true, "items": [ main_1_panel231, { "items": diff238, "labelAlign": "top", "layout": "form", "xtype": "panel", "flex": 83 } ], "frame": true, "layoutConfig": { "align": "stretch" }, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel239;
    this.before_row_edit = function(record) {
    }
    Lino.changes.Changes.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.debts.Budgets.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 84,
  initComponent : function() {
    var containing_panel = this;
    var date440 = new Lino.DateField({ "selectOnFocus": true, "fieldLabel": "Datum", "anchor": "-20", "name": "date" });
    var partner441 = new Lino.TwinCombo({ "fieldLabel": "Partner", "allowBlank": false, "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.contacts.Partners.detail)}, "emptyText": "Partner ausw\u00e4hlen...", "selectOnFocus": true, "hiddenName": "partnerHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/debts/Budgets/partner", "method": "GET" }) }), "name": "partner" });
    var id442 = new Ext.form.NumberField({ "selectOnFocus": true, "fieldLabel": "ID", "anchor": "-20", "name": "id" });
    var user443 = new Lino.TwinCombo({ "fieldLabel": "Autor", "name": "user", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.users.Users.detail)}, "emptyText": "Benutzer ausw\u00e4hlen...", "selectOnFocus": true, "hiddenName": "userHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/debts/Budgets/user", "method": "GET" }) }) });
    var general_1_panel444 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 16, "autoHeight": true, "layout": "form", "xtype": "panel", "items": date440, "labelAlign": "top" }, { "flex": 41, "autoHeight": true, "layout": "form", "xtype": "panel", "items": partner441, "labelAlign": "top" }, { "flex": 10, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id442, "labelAlign": "top" }, { "flex": 31, "autoHeight": true, "layout": "form", "xtype": "panel", "items": user443, "labelAlign": "top" } ], "region": "north", "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "split": true, "autoScroll": false, "labelWidth": 72, "border": false, "frame": false, "labelAlign": "top" });
    var intro449 = new Lino.RichTextPanel({ "flex": 5, "split": true, "containing_panel": this, "selectOnFocus": true, "region": "center", "title": "Einleitung", "name": "intro" });
    var ActorsByBudget_grid456 = new Lino.debts.ActorsByBudget.GridPanel({ "flex": 5, "hide_top_toolbar": true, "containing_panel": this, "region": "south", "master_panel": this, "listeners": { "render": Lino.quicktip_renderer("Budget-Akteure","To be filled if there is more than one person involved.") }, "split": true, "tools": [ Lino.show_in_own_window_button(Lino.debts.ActorsByBudget.grid) ] });
    var general_panel457 = new Lino.VBorderPanel({ "autoScroll": false, "listeners": { "activate": Lino.on_tab_activate }, "border": false, "labelWidth": 0, "title": "Allgemein", "hideCheckBoxLabels": true, "items": [ general_1_panel444, intro449, ActorsByBudget_grid456 ], "frame": true, "bodyBorder": false, "labelAlign": "top" });
    var ExpensesByBudget_grid468 = new Lino.debts.ExpensesByBudget.GridPanel({ "flex": 5, "hide_top_toolbar": true, "split": true, "containing_panel": this, "region": "north", "tools": [ Lino.show_in_own_window_button(Lino.debts.ExpensesByBudget.grid) ], "master_panel": this });
    var IncomesByBudget_grid479 = new Lino.debts.IncomesByBudget.GridPanel({ "flex": 5, "hide_top_toolbar": true, "split": true, "containing_panel": this, "region": "center", "tools": [ Lino.show_in_own_window_button(Lino.debts.IncomesByBudget.grid) ], "master_panel": this });
    var entries1_panel480 = new Lino.VBorderPanel({ "autoScroll": false, "listeners": { "activate": Lino.on_tab_activate }, "border": false, "title": "Ausgaben und Eink\u00fcnfte", "hideCheckBoxLabels": true, "items": [ ExpensesByBudget_grid468, IncomesByBudget_grid479 ], "frame": true, "bodyBorder": false, "labelAlign": "top" });
    var LiabilitiesByBudget_grid492 = new Lino.debts.LiabilitiesByBudget.GridPanel({ "flex": 5, "hide_top_toolbar": true, "split": true, "containing_panel": this, "region": "north", "tools": [ Lino.show_in_own_window_button(Lino.debts.LiabilitiesByBudget.grid) ], "master_panel": this });
    var AssetsByBudget_grid500 = new Lino.debts.AssetsByBudget.GridPanel({ "flex": 5, "hide_top_toolbar": true, "split": true, "containing_panel": this, "region": "center", "tools": [ Lino.show_in_own_window_button(Lino.debts.AssetsByBudget.grid) ], "master_panel": this });
    var entries2_panel501 = new Lino.VBorderPanel({ "autoScroll": false, "listeners": { "activate": Lino.on_tab_activate }, "border": false, "title": "Verpflichtungen & Verm\u00f6gen", "hideCheckBoxLabels": true, "items": [ LiabilitiesByBudget_grid492, AssetsByBudget_grid500 ], "frame": true, "bodyBorder": false, "labelAlign": "top" });
    var ResultByBudget_htmlbox502 = new Lino.HtmlBoxPanel({ "flex": 3, "layout": "fit", "name": "ResultByBudget", "containing_panel": this, "items": new Ext.BoxComponent({autoScroll:true}), "region": "north", "title": "Einnahmen & Ausgaben", "master_panel": this, "value": "<br/>", "always_enabled": true, "listeners": { "render": Lino.quicktip_renderer("Einnahmen & Ausgaben","Shows the Incomes & Expenses for this budget.") }, "bodyStyle": "overflow-x:hidden", "split": true, "tools": [ Lino.show_in_own_window_button(Lino.debts.ResultByBudget.grid) ] });
    var DebtsByBudget_htmlbox503 = new Lino.HtmlBoxPanel({ "flex": 3, "layout": "fit", "name": "DebtsByBudget", "containing_panel": this, "items": new Ext.BoxComponent({autoScroll:true}), "region": "center", "title": "Schulden", "master_panel": this, "value": "<br/>", "always_enabled": true, "bodyStyle": "overflow-x:hidden", "split": true, "tools": [ Lino.show_in_own_window_button(Lino.debts.DebtsByBudget.grid) ] });
    var BailiffDebtsByBudget_htmlbox504 = new Lino.HtmlBoxPanel({ "flex": 3, "layout": "fit", "name": "BailiffDebtsByBudget", "containing_panel": this, "items": new Ext.BoxComponent({autoScroll:true}), "region": "south", "title": "Schulden (Gerichtsvollzieher)", "master_panel": this, "value": "<br/>", "always_enabled": true, "bodyStyle": "overflow-x:hidden", "split": true, "tools": [ Lino.show_in_own_window_button(Lino.debts.BailiffDebtsByBudget.grid) ] });
    var summary1_panel505 = new Lino.VBorderPanel({ "flex": 42, "border": false, "labelWidth": 270, "hideCheckBoxLabels": true, "items": [ ResultByBudget_htmlbox502, DebtsByBudget_htmlbox503, BailiffDebtsByBudget_htmlbox504 ], "frame": true, "autoScroll": false, "bodyBorder": false, "labelAlign": "top" });
    var conclusion506 = new Lino.RichTextPanel({ "selectOnFocus": true, "flex": 71, "containing_panel": this, "name": "conclusion", "title": "Schlussfolgerung" });
    var dist_amount507 = new Ext.form.NumberField({ "decimalPrecision": 2, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Verteilbarer Betrag</span>", "name": "dist_amount", "decimalSeparator": ",", "value": 120, "listeners": { "render": Lino.quicktip_renderer("Verteilbarer Betrag","Der monatlich verf\u00fcgbare Gesamtbetrag f\u00fcr Tabelle Schuldenverteilung.") }, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var build_time508 = new Ext.form.DisplayField({ "disabled": true, "fieldLabel": "Druckdatum", "anchor": "-20", "value": "<br>", "name": "build_time" });
    var summary2_2_panel509 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 180, "hideCheckBoxLabels": true, "items": [ { "flex": 42, "autoHeight": true, "layout": "form", "xtype": "panel", "items": dist_amount507, "labelAlign": "top" }, { "flex": 57, "autoHeight": true, "layout": "form", "xtype": "panel", "items": build_time508, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var include_yearly_incomes512 = new Ext.form.Checkbox({ "boxLabel": "J\u00e4hrliche Einkommen ber\u00fccksichtigen", "listeners": { "render": Lino.quicktip_renderer("J\u00e4hrliche Einkommen ber\u00fccksichtigen","Check this to include yearly incomes in the Debts Overview table of this Budget.") }, "hideLabel": true, "checked": false, "name": "include_yearly_incomes", "selectOnFocus": true, "anchor": "-20" });
    var print_empty_rows513 = new Ext.form.Checkbox({ "boxLabel": "Auch leere Eintr\u00e4ge drucken", "listeners": { "render": Lino.quicktip_renderer("Auch leere Eintr\u00e4ge drucken","Check this to print also empty rows for later completion.") }, "hideLabel": true, "checked": false, "name": "print_empty_rows", "selectOnFocus": true, "anchor": "-20" });
    var print_todos514 = new Ext.form.Checkbox({ "boxLabel": "To-do-Liste drucken", "listeners": { "render": Lino.quicktip_renderer("To-do-Liste drucken","Eintr\u00e4ge im Feld \"To-do\" werden nur ausgedruckt, \nwenn die Option \"To-dos drucken\" des Budgets angekreuzt ist. \nDiese Option wird aber momentan noch ignoriert \n(d.h. To-do-Liste wird gar nicht ausgedruckt), \nweil wir noch \u00fcberlegen m\u00fcssen, *wie* sie ausgedruckt werden sollen. \nVielleicht mit Fu\u00dfnoten?") }, "hideLabel": true, "checked": false, "name": "print_todos", "selectOnFocus": true, "anchor": "-20" });
    var summary2_3_panel515 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 324, "hideCheckBoxLabels": true, "items": [ { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": include_yearly_incomes512, "labelAlign": "top" }, { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": print_empty_rows513, "labelAlign": "top" }, { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": print_todos514, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var summary2_panel519 = new Ext.Panel({ "flex": 57, "layout": "vbox", "items": [ conclusion506, summary2_2_panel509, summary2_3_panel515 ], "frame": true, "layoutConfig": { "align": "stretch" }, "autoScroll": false, "hideCheckBoxLabels": true, "labelWidth": 0, "border": false, "bodyBorder": false, "labelAlign": "top" });
    var summary_tab_1_panel520 = new Ext.Panel({ "flex": 9, "layout": "hbox", "items": [ summary1_panel505, summary2_panel519 ], "region": "north", "layoutConfig": { "align": "stretch" }, "hideCheckBoxLabels": true, "split": true, "autoScroll": false, "border": false, "frame": false, "labelAlign": "top" });
    var DistByBudget_htmlbox521 = new Lino.HtmlBoxPanel({ "flex": 3, "layout": "fit", "name": "DistByBudget", "containing_panel": this, "items": new Ext.BoxComponent({autoScroll:true}), "region": "center", "title": "Schuldenverteilung", "master_panel": this, "value": "<br/>", "always_enabled": true, "listeners": { "render": Lino.quicktip_renderer("Schuldenverteilung","R\u00e9partition au marc-le-franc.\nTabelle mit einer Zeile pro Eintrag in \"Verpflichtungen\", dessen Option \"verteilen\" angekreuzt ist. \nDer verf\u00fcgbare Betrag wird dabei proportional zum geschuldeten Betrag aufgeteilt.\n") }, "bodyStyle": "overflow-x:hidden", "split": true, "tools": [ Lino.show_in_own_window_button(Lino.debts.DistByBudget.grid) ] });
    var summary_tab_panel522 = new Lino.VBorderPanel({ "autoScroll": false, "listeners": { "activate": Lino.on_tab_activate }, "border": false, "labelWidth": 171, "title": "Zusammenfassung", "hideCheckBoxLabels": true, "items": [ summary_tab_1_panel520, DistByBudget_htmlbox521 ], "frame": true, "bodyBorder": false, "labelAlign": "top" });
    var preview_htmlbox523 = new Lino.HtmlBoxPanel({ "layout": "fit", "name": "preview", "title": "Vorschau", "master_panel": this, "items": new Ext.BoxComponent({autoScroll:true}), "containing_panel": this, "bodyStyle": "overflow-x:hidden", "value": "<br/>", "always_enabled": true, "listeners": { "activate": Lino.on_tab_activate } });
    var main_panel524 = new Ext.TabPanel({ "hideCheckBoxLabels": true, "border": false, "split": true, "autoScroll": false, "items": [ general_panel457, entries1_panel480, entries2_panel501, summary_tab_panel522, preview_htmlbox523 ], "activeTab": 0, "bodyBorder": false, "frame": true, "labelAlign": "top" });
    this.items = main_panel524;
    this.before_row_edit = function(record) {
      intro449.refresh();
      ActorsByBudget_grid456.on_master_changed();
      ExpensesByBudget_grid468.on_master_changed();
      IncomesByBudget_grid479.on_master_changed();
      LiabilitiesByBudget_grid492.on_master_changed();
      AssetsByBudget_grid500.on_master_changed();
      ResultByBudget_htmlbox502.refresh();
      DebtsByBudget_htmlbox503.refresh();
      BailiffDebtsByBudget_htmlbox504.refresh();
      conclusion506.refresh();
      DistByBudget_htmlbox521.refresh();
      preview_htmlbox523.refresh();
    }
    Lino.debts.Budgets.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.outbox.MyOutbox.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 27,
  initComponent : function() {
    var containing_panel = this;
    var subject713 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200, "fieldLabel": "Betreff", "anchor": "-20", "name": "subject" });
    var project714 = new Lino.TwinCombo({ "fieldLabel": "Klient", "name": "project", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.pcsw.Clients.detail)}, "emptyText": "Klient ausw\u00e4hlen...", "selectOnFocus": true, "hiddenName": "projectHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/outbox/Mails/project", "method": "GET" }) }) });
    var date715 = new Lino.DateField({ "listeners": { "render": Lino.quicktip_renderer("Datum","\n        The official date to be printed on the document.\n        ") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Datum</span>", "name": "date", "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var main_1_panel716 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 72, "hideCheckBoxLabels": true, "items": [ { "flex": 42, "autoHeight": true, "layout": "form", "xtype": "panel", "items": subject713, "labelAlign": "top" }, { "flex": 40, "autoHeight": true, "layout": "form", "xtype": "panel", "items": project714, "labelAlign": "top" }, { "flex": 16, "autoHeight": true, "layout": "form", "xtype": "panel", "items": date715, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var user720 = new Lino.TwinCombo({ "fieldLabel": "Absender", "name": "user", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.users.Users.detail)}, "emptyText": "Benutzer ausw\u00e4hlen...", "selectOnFocus": true, "hiddenName": "userHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/outbox/Mails/user", "method": "GET" }) }) });
    var sent721 = new Ext.form.DisplayField({ "disabled": true, "fieldLabel": "sent", "anchor": "-20", "value": "<br>", "name": "sent" });
    var id722 = new Ext.form.NumberField({ "selectOnFocus": true, "fieldLabel": "ID", "anchor": "-20", "name": "id" });
    var owner_disp723 = new Ext.form.DisplayField({ "disabled": true, "fieldLabel": "Verkn\u00fcpft mit", "anchor": "-20", "name": "owner" });
    var main_2_panel724 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 126, "hideCheckBoxLabels": true, "items": [ { "flex": 32, "autoHeight": true, "layout": "form", "xtype": "panel", "items": user720, "labelAlign": "top" }, { "flex": 34, "autoHeight": true, "layout": "form", "xtype": "panel", "items": sent721, "labelAlign": "top" }, { "flex": 10, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id722, "labelAlign": "top" }, { "flex": 21, "autoHeight": true, "layout": "form", "xtype": "panel", "items": owner_disp723, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var RecipientsByMail_grid735 = new Lino.outbox.RecipientsByMail.GridPanel({ "tools": [ Lino.show_in_own_window_button(Lino.outbox.RecipientsByMail.grid) ], "containing_panel": this, "hide_top_toolbar": true, "master_panel": this, "flex": 55 });
    var AttachmentsByMail_htmlbox736 = new Lino.HtmlBoxPanel({ "flex": 22, "layout": "fit", "name": "AttachmentsByMail", "containing_panel": this, "items": new Ext.BoxComponent({autoScroll:true}), "title": "Anh\u00e4nge", "master_panel": this, "value": "<br/>", "always_enabled": true, "bodyStyle": "overflow-x:hidden", "tools": [ Lino.show_in_own_window_button(Lino.outbox.AttachmentsByMail.grid) ] });
    var UploadsByController_htmlbox737 = new Lino.HtmlBoxPanel({ "flex": 22, "ls_bbar_actions": [ { "itemId": "insert", "menu_item_text": "Neu", "must_save": true, "tooltip": "Neuen Datensatz erstellen", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-new", "overflowText": "Neu", "auto_save": true } ], "name": "UploadsByController", "containing_panel": this, "items": new Ext.BoxComponent({autoScroll:true}), "title": "Uploads", "master_panel": this, "value": "<br/>", "always_enabled": true, "bodyStyle": "overflow-x:hidden", "ls_insert_handler": Lino.uploads.UploadsByController.insert, "layout": "fit", "tools": [ Lino.show_in_own_window_button(Lino.uploads.UploadsByController.grid) ] });
    var main_3_panel738 = new Ext.Panel({ "flex": 29, "border": false, "layout": "hbox", "labelWidth": 72, "hideCheckBoxLabels": true, "items": [ RecipientsByMail_grid735, AttachmentsByMail_htmlbox736, UploadsByController_htmlbox737 ], "autoScroll": false, "layoutConfig": { "align": "stretch" }, "frame": false, "labelAlign": "top" });
    var body739 = new Lino.RichTextPanel({ "selectOnFocus": true, "flex": 58, "containing_panel": this, "name": "body", "title": "Inhalt" });
    var main_panel740 = new Ext.Panel({ "autoScroll": false, "border": false, "layout": "vbox", "labelWidth": 0, "hideCheckBoxLabels": true, "items": [ main_1_panel716, main_2_panel724, main_3_panel738, body739 ], "frame": true, "layoutConfig": { "align": "stretch" }, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel740;
    this.before_row_edit = function(record) {
      RecipientsByMail_grid735.on_master_changed();
      AttachmentsByMail_htmlbox736.refresh();
      UploadsByController_htmlbox737.refresh();
      body739.refresh();
    }
    Lino.outbox.MyOutbox.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.contacts.Companies.InsertFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  autoHeight: true,
  content_type: 20,
  initComponent : function() {
    var containing_panel = this;
    var name783 = new Ext.form.TextField({ "fieldLabel": "Name", "name": "name", "maxLength": 200, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var language784 = new Lino.ChoicesFieldElement({ "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Sprache</span>", "allowBlank": false, "value": "de", "hiddenName": "languageHidden", "listeners": { "render": Lino.quicktip_renderer("Sprache","Die Sprache, in der Dokumente ausgestellt werden sollen.") }, "selectOnFocus": true, "anchor": "-20", "store": [ [ "de", "Deutsch" ], [ "fr", "Franz\u00f6sisch" ], [ "nl", "Niederl\u00e4ndisch" ] ], "name": "language" });
    var email785 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 75, "fieldLabel": "E-Mail", "anchor": "-20", "name": "email" });
    var main_2_panel786 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": language784, "labelAlign": "top" }, { "flex": 66, "autoHeight": true, "layout": "form", "xtype": "panel", "items": email785, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 72, "border": false, "anchor": "-20", "labelAlign": "top" });
    var type789 = new Lino.RemoteComboFieldElement({ "fieldLabel": "Organisationsart", "name": "type", "pageSize": 20, "emptyText": "Organisationsart ausw\u00e4hlen...", "selectOnFocus": true, "hiddenName": "typeHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/contacts/Companies/type", "method": "GET" }) }) });
    var id790 = new Ext.form.NumberField({ "selectOnFocus": true, "fieldLabel": "ID", "anchor": "-20", "name": "id" });
    var main_3_panel791 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 80, "autoHeight": true, "layout": "form", "xtype": "panel", "items": type789, "labelAlign": "top" }, { "flex": 20, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id790, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 153, "border": false, "anchor": "-20", "labelAlign": "top" });
    var main_panel794 = new Ext.Panel({ "hideCheckBoxLabels": true, "autoHeight": true, "border": false, "layout": "form", "labelWidth": 45, "autoScroll": false, "items": [ { "autoHeight": true, "layout": "form", "xtype": "panel", "items": name783, "anchor": "-20", "labelAlign": "top" }, main_2_panel786, main_3_panel791 ], "frame": true, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel794;
    this.before_row_edit = function(record) {
    }
    Lino.contacts.Companies.InsertFormPanel.superclass.initComponent.call(this);
  }
});


Lino.courses.CourseContents.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 78,
  initComponent : function() {
    var containing_panel = this;
    var id2188 = new Ext.form.NumberField({ "selectOnFocus": true, "fieldLabel": "ID", "anchor": "-20", "name": "id" });
    var name2189 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200, "fieldLabel": "Name", "anchor": "-20", "name": "name" });
    var main_1_panel2190 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 19, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id2188, "labelAlign": "top" }, { "flex": 80, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name2189, "labelAlign": "top" } ], "region": "north", "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "split": true, "autoScroll": false, "labelWidth": 45, "border": false, "frame": false, "labelAlign": "top" });
    var courses_CourseOffersByContent_grid2198 = new Lino.courses.CourseOffersByContent.GridPanel({ "flex": 5, "hide_top_toolbar": true, "split": true, "containing_panel": this, "region": "center", "tools": [ Lino.show_in_own_window_button(Lino.courses.CourseOffersByContent.grid) ], "master_panel": this });
    var main_panel2210 = new Lino.VBorderPanel({ "autoScroll": false, "border": false, "hideCheckBoxLabels": true, "items": [ main_1_panel2190, courses_CourseOffersByContent_grid2198 ], "frame": true, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel2210;
    this.before_row_edit = function(record) {
      courses_CourseOffersByContent_grid2198.on_master_changed();
    }
    Lino.courses.CourseContents.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.notes.EventTypes.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 92,
  initComponent : function() {
    var containing_panel = this;
    var id1272 = new Ext.form.NumberField({ "selectOnFocus": true, "fieldLabel": "ID", "anchor": "-20", "name": "id" });
    var name1273 = new Ext.form.TextField({ "fieldLabel": "Bezeichnung", "name": "name", "maxLength": 200, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var name_fr1274 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200, "fieldLabel": "Bezeichnung (fr)", "anchor": "-20", "name": "name_fr" });
    var name_nl1275 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200, "fieldLabel": "Bezeichnung (nl)", "anchor": "-20", "name": "name_nl" });
    var main_1_panel1276 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 7, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id1272, "labelAlign": "top" }, { "flex": 30, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name1273, "labelAlign": "top" }, { "flex": 30, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_fr1274, "labelAlign": "top" }, { "flex": 30, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_nl1275, "labelAlign": "top" } ], "region": "north", "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "split": true, "autoScroll": false, "labelWidth": 153, "border": false, "frame": false, "labelAlign": "top" });
    var remark1281 = new Ext.form.TextArea({ "selectOnFocus": true, "fieldLabel": "Bemerkung", "anchor": "-20 -10", "growMax": 2000, "name": "remark" });
    var notes_NotesByEventType_grid1296 = new Lino.notes.NotesByEventType.GridPanel({ "flex": 6, "hide_top_toolbar": true, "split": true, "containing_panel": this, "region": "south", "tools": [ Lino.show_in_own_window_button(Lino.notes.NotesByEventType.grid) ], "master_panel": this });
    var main_panel1297 = new Lino.VBorderPanel({ "autoScroll": false, "border": false, "labelWidth": 90, "hideCheckBoxLabels": true, "items": [ main_1_panel1276, { "flex": 3, "layout": "form", "xtype": "panel", "items": remark1281, "region": "center", "labelAlign": "top", "split": true }, notes_NotesByEventType_grid1296 ], "frame": true, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel1297;
    this.before_row_edit = function(record) {
      notes_NotesByEventType_grid1296.on_master_changed();
    }
    Lino.notes.EventTypes.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.contacts.Persons.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 21,
  initComponent : function() {
    var containing_panel = this;
    var last_name1299 = new Ext.form.TextField({ "fieldLabel": "Familienname", "name": "last_name", "maxLength": 200, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var first_name1300 = new Ext.form.TextField({ "fieldLabel": "Vorname", "name": "first_name", "maxLength": 200, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var gender1301 = new Lino.ChoicesFieldElement({ "forceSelection": true, "fieldLabel": "Geschlecht", "name": "gender", "selectOnFocus": true, "anchor": "-20", "store": Lino.lino.Genders, "hiddenName": "genderHidden" });
    var title1302 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200, "fieldLabel": "Anrede", "anchor": "-20", "name": "title" });
    var name_box_panel1303 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 36, "autoHeight": true, "layout": "form", "xtype": "panel", "items": last_name1299, "labelAlign": "top" }, { "flex": 26, "autoHeight": true, "layout": "form", "xtype": "panel", "items": first_name1300, "labelAlign": "top" }, { "flex": 19, "autoHeight": true, "layout": "form", "xtype": "panel", "items": gender1301, "labelAlign": "top" }, { "flex": 17, "autoHeight": true, "layout": "form", "xtype": "panel", "items": title1302, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 117, "border": false, "anchor": "-20", "labelAlign": "top" });
    var country1308 = new Lino.TwinCombo({ "fieldLabel": "Land", "name": "country", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.countries.Countries.detail)}, "emptyText": "Land ausw\u00e4hlen...", "selectOnFocus": true, "hiddenName": "countryHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/contacts/Persons/country", "method": "GET" }) }) });
    var region1309 = new Lino.TwinCombo({ "fieldLabel": "Region", "name": "region", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.countries.Cities.detail)}, "emptyText": "Ort ausw\u00e4hlen...", "selectOnFocus": true, "hiddenName": "regionHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/contacts/Persons/region", "method": "GET" }) }) });
    var city1310 = new Lino.TwinCombo({ "forceSelection": false, "fieldLabel": "Ort", "name": "city", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.countries.Cities.detail)}, "emptyText": "Ort ausw\u00e4hlen...", "selectOnFocus": true, "hiddenName": "cityHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/contacts/Persons/city", "method": "GET" }) }) });
    var zip_code1311 = new Ext.form.TextField({ "fieldLabel": "Postleitzahl", "name": "zip_code", "maxLength": 10, "selectOnFocus": true, "boxMinWidth": Lino.chars2width(10), "anchor": "-20" });
    var address_box_2_panel1312 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 28, "autoHeight": true, "layout": "form", "xtype": "panel", "items": country1308, "labelAlign": "top" }, { "flex": 28, "autoHeight": true, "layout": "form", "xtype": "panel", "items": region1309, "labelAlign": "top" }, { "flex": 28, "autoHeight": true, "layout": "form", "xtype": "panel", "items": city1310, "labelAlign": "top" }, { "flex": 14, "autoHeight": true, "layout": "form", "xtype": "panel", "items": zip_code1311, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 117, "border": false, "anchor": "-20", "labelAlign": "top" });
    var addr11317 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Adresszeile vor Stra\u00dfe","Address line before street") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Adresszeile vor Stra\u00dfe</span>", "name": "addr1", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var street_prefix1318 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Pr\u00e4fix Stra\u00dfe","Text to print before name of street, but to ignore for sorting.") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Pr\u00e4fix Stra\u00dfe</span>", "name": "street_prefix", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var street1319 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Stra\u00dfe","Name of street. Without house number.") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Stra\u00dfe</span>", "name": "street", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var street_no1320 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Nr.","House number") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Nr.</span>", "name": "street_no", "maxLength": 10, "selectOnFocus": true, "boxMinWidth": Lino.chars2width(10), "anchor": "-20" });
    var street_box1321 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Box","Text to print after :attr:`steet_no` on the same line") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Box</span>", "name": "street_box", "maxLength": 10, "selectOnFocus": true, "boxMinWidth": Lino.chars2width(10), "anchor": "-20" });
    var address_box_4_panel1322 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 30, "autoHeight": true, "layout": "form", "xtype": "panel", "items": street_prefix1318, "labelAlign": "top" }, { "flex": 36, "autoHeight": true, "layout": "form", "xtype": "panel", "items": street1319, "labelAlign": "top" }, { "flex": 16, "autoHeight": true, "layout": "form", "xtype": "panel", "items": street_no1320, "labelAlign": "top" }, { "flex": 16, "autoHeight": true, "layout": "form", "xtype": "panel", "items": street_box1321, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 126, "border": false, "anchor": "-20", "labelAlign": "top" });
    var addr21327 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Adresszeile nach Stra\u00dfe","Address line to print below street line") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Adresszeile nach Stra\u00dfe</span>", "name": "addr2", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var address_box_panel1328 = new Ext.form.FieldSet({ "flex": 66, "autoHeight": true, "layout": "form", "title": "Adresse", "items": [ name_box_panel1303, address_box_2_panel1312, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": addr11317, "anchor": "-20", "labelAlign": "top" }, address_box_4_panel1322, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": addr21327, "anchor": "-20", "labelAlign": "top" } ], "frame": true, "bodyBorder": false, "autoScroll": false, "hideCheckBoxLabels": true, "labelWidth": 216, "border": false, "labelAlign": "top" });
    var id1331 = new Ext.form.NumberField({ "selectOnFocus": true, "fieldLabel": "ID", "anchor": "-20", "name": "id" });
    var language1332 = new Lino.ChoicesFieldElement({ "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Sprache</span>", "allowBlank": false, "value": "de", "hiddenName": "languageHidden", "listeners": { "render": Lino.quicktip_renderer("Sprache","Die Sprache, in der Dokumente ausgestellt werden sollen.") }, "selectOnFocus": true, "anchor": "-20", "store": [ [ "de", "Deutsch" ], [ "fr", "Franz\u00f6sisch" ], [ "nl", "Niederl\u00e4ndisch" ] ], "name": "language" });
    var info_box_panel1333 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id1331, "labelAlign": "top" }, { "flex": 66, "autoHeight": true, "layout": "form", "xtype": "panel", "items": language1332, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 72, "border": false, "anchor": "-20", "labelAlign": "top" });
    var email1336 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 75, "fieldLabel": "E-Mail", "anchor": "-20", "name": "email" });
    var url1337 = new Lino.URLField({ "selectOnFocus": true, "maxLength": 200, "fieldLabel": "URL", "anchor": "-20", "name": "url" });
    var phone1338 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200, "fieldLabel": "Telefon", "anchor": "-20", "name": "phone" });
    var gsm1339 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200, "fieldLabel": "GSM", "anchor": "-20", "name": "gsm" });
    var fax1340 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200, "fieldLabel": "Fax", "anchor": "-20", "name": "fax" });
    var contact_box_5_panel1341 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": gsm1339, "labelAlign": "top" }, { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": fax1340, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 36, "border": false, "anchor": "-20", "labelAlign": "top" });
    var contact_box_panel1344 = new Ext.form.FieldSet({ "flex": 33, "autoHeight": true, "layout": "form", "title": "Kontakt", "items": [ info_box_panel1333, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": email1336, "anchor": "-20", "labelAlign": "top" }, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": url1337, "anchor": "-20", "labelAlign": "top" }, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": phone1338, "anchor": "-20", "labelAlign": "top" }, contact_box_5_panel1341 ], "frame": true, "bodyBorder": false, "autoScroll": false, "hideCheckBoxLabels": true, "labelWidth": 72, "border": false, "labelAlign": "top" });
    var general_1_panel1348 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "hideCheckBoxLabels": true, "items": [ address_box_panel1328, contact_box_panel1344 ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var activity1349 = new Lino.RemoteComboFieldElement({ "fieldLabel": "Beruf", "name": "activity", "pageSize": 20, "emptyText": "Beruf ausw\u00e4hlen...", "selectOnFocus": true, "hiddenName": "activityHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/contacts/Persons/activity", "method": "GET" }) }) });
    var bank_account11350 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 40, "fieldLabel": "Bankkonto 1", "anchor": "-20", "name": "bank_account1" });
    var bank_account21351 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 40, "fieldLabel": "Bankkonto 2", "anchor": "-20", "name": "bank_account2" });
    var is_obsolete1352 = new Ext.form.Checkbox({ "boxLabel": "veraltet", "listeners": { "render": Lino.quicktip_renderer("veraltet","Altf\u00e4lle sind Partner, deren Stammdaten nicht mehr gepflegt werden und \nf\u00fcr neue Operationen nicht benutzt werden k\u00f6nnen.") }, "hideLabel": true, "checked": false, "name": "is_obsolete", "selectOnFocus": true, "anchor": "-20" });
    var bottom_box_1_panel1353 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 108, "hideCheckBoxLabels": true, "items": [ { "flex": 27, "autoHeight": true, "layout": "form", "xtype": "panel", "items": activity1349, "labelAlign": "top" }, { "flex": 29, "autoHeight": true, "layout": "form", "xtype": "panel", "items": bank_account11350, "labelAlign": "top" }, { "flex": 29, "autoHeight": true, "layout": "form", "xtype": "panel", "items": bank_account21351, "labelAlign": "top" }, { "flex": 13, "autoHeight": true, "layout": "form", "xtype": "panel", "items": is_obsolete1352, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var is_client1358 = new Ext.form.Checkbox({ "boxLabel": "ist Klient (<a href=\"javascript:Lino.show_mti_child('is_client',Lino.pcsw.Clients.detail)\">zeigen</a>)", "listeners": { "render": Lino.quicktip_renderer("ist Klient","Ob diese Person ein Klient ist") }, "hideLabel": true, "name": "is_client", "selectOnFocus": true, "anchor": "-20" });
    var created1359 = new Ext.form.DisplayField({ "disabled": true, "fieldLabel": "Erstellt", "anchor": "-20", "value": "<br>", "name": "created" });
    var modified1360 = new Ext.form.DisplayField({ "disabled": true, "fieldLabel": "Bearbeitet", "anchor": "-20", "value": "<br>", "name": "modified" });
    var bottom_box_2_panel1361 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 99, "hideCheckBoxLabels": true, "items": [ { "flex": 23, "autoHeight": true, "layout": "form", "xtype": "panel", "items": is_client1358, "labelAlign": "top" }, { "flex": 38, "autoHeight": true, "layout": "form", "xtype": "panel", "items": created1359, "labelAlign": "top" }, { "flex": 38, "autoHeight": true, "layout": "form", "xtype": "panel", "items": modified1360, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var remarks1365 = new Ext.form.TextArea({ "selectOnFocus": true, "fieldLabel": "Bemerkungen", "anchor": "-20 -10", "growMax": 2000, "name": "remarks" });
    var contacts_RolesByPerson_grid1370 = new Lino.contacts.RolesByPerson.GridPanel({ "tools": [ Lino.show_in_own_window_button(Lino.contacts.RolesByPerson.grid) ], "containing_panel": this, "hide_top_toolbar": true, "master_panel": this, "flex": 27 });
    var households_MembersByPerson_grid1377 = new Lino.households.MembersByPerson.GridPanel({ "tools": [ Lino.show_in_own_window_button(Lino.households.MembersByPerson.grid) ], "containing_panel": this, "hide_top_toolbar": true, "master_panel": this, "flex": 36 });
    var bottom_box_3_panel1378 = new Ext.Panel({ "flex": 71, "border": false, "layout": "hbox", "labelWidth": 108, "hideCheckBoxLabels": true, "items": [ { "items": remarks1365, "labelAlign": "top", "layout": "form", "xtype": "panel", "flex": 36 }, contacts_RolesByPerson_grid1370, households_MembersByPerson_grid1377 ], "autoScroll": false, "layoutConfig": { "align": "stretch" }, "frame": false, "labelAlign": "top" });
    var bottom_box_panel1380 = new Ext.Panel({ "flex": 58, "border": false, "layout": "vbox", "bodyBorder": false, "hideCheckBoxLabels": true, "items": [ bottom_box_1_panel1353, bottom_box_2_panel1361, bottom_box_3_panel1378 ], "autoScroll": false, "layoutConfig": { "align": "stretch" }, "frame": true, "labelAlign": "top" });
    var general_panel1381 = new Ext.Panel({ "layout": "vbox", "title": "Allgemein", "items": [ general_1_panel1348, bottom_box_panel1380 ], "frame": true, "layoutConfig": { "align": "stretch" }, "hideCheckBoxLabels": true, "listeners": { "activate": Lino.on_tab_activate }, "autoScroll": false, "border": false, "bodyBorder": false, "labelAlign": "top" });
    var debts_BudgetsByPartner_grid1382 = new Lino.debts.BudgetsByPartner.GridPanel({ "flex": 5, "hide_top_toolbar": true, "split": true, "containing_panel": this, "region": "north", "tools": [ Lino.show_in_own_window_button(Lino.debts.BudgetsByPartner.grid) ], "master_panel": this });
    var debts_ActorsByPartner_grid1383 = new Lino.debts.ActorsByPartner.GridPanel({ "flex": 5, "hide_top_toolbar": true, "split": true, "containing_panel": this, "region": "center", "tools": [ Lino.show_in_own_window_button(Lino.debts.ActorsByPartner.grid) ], "master_panel": this });
    var debts_panel1384 = new Lino.VBorderPanel({ "autoScroll": false, "listeners": { "activate": Lino.on_tab_activate }, "border": false, "title": "Schuldnerberatung", "hideCheckBoxLabels": true, "items": [ debts_BudgetsByPartner_grid1382, debts_ActorsByPartner_grid1383 ], "frame": true, "bodyBorder": false, "labelAlign": "top" });
    var main_panel1385 = new Ext.TabPanel({ "hideCheckBoxLabels": true, "border": false, "split": true, "autoScroll": false, "items": [ general_panel1381, debts_panel1384 ], "activeTab": 0, "bodyBorder": false, "frame": true, "labelAlign": "top" });
    this.items = main_panel1385;
    this.before_row_edit = function(record) {
      region1309.setContextValue('country',record ? record.data['countryHidden'] : undefined);
      city1310.setContextValue('country',record ? record.data['countryHidden'] : undefined);
      city1310.setContextValue('region',record ? record.data['regionHidden'] : undefined);
      contacts_RolesByPerson_grid1370.on_master_changed();
      households_MembersByPerson_grid1377.on_master_changed();
      debts_BudgetsByPartner_grid1382.on_master_changed();
      debts_ActorsByPartner_grid1383.on_master_changed();
    }
    this.onRender = function(ct, position) {
      country1308.on('change',Lino.chooser_handler(region1309,'country'));
      country1308.on('change',Lino.chooser_handler(city1310,'country'));
      region1309.on('change',Lino.chooser_handler(city1310,'region'));
      Lino.contacts.Persons.DetailFormPanel.superclass.onRender.call(this, ct, position);
    }
    Lino.contacts.Persons.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.notes.Notes.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 91,
  initComponent : function() {
    var containing_panel = this;
    var date676 = new Lino.DateField({ "selectOnFocus": true, "allowBlank": false, "fieldLabel": "Datum", "anchor": "-20", "name": "date" });
    var event_type677 = new Lino.TwinCombo({ "fieldLabel": "Ereignisart (Form)", "name": "event_type", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.notes.EventTypes.detail)}, "emptyText": "Event Type ausw\u00e4hlen...", "selectOnFocus": true, "hiddenName": "event_typeHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/notes/Notes/event_type", "method": "GET" }) }) });
    var type678 = new Lino.TwinCombo({ "fieldLabel": "Notizart (Inhalt)", "name": "type", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.notes.NoteTypes.detail)}, "emptyText": "Notizart ausw\u00e4hlen...", "selectOnFocus": true, "hiddenName": "typeHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/notes/Notes/type", "method": "GET" }) }) });
    var left_1_panel679 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 171, "hideCheckBoxLabels": true, "items": [ { "flex": 16, "autoHeight": true, "layout": "form", "xtype": "panel", "items": date676, "labelAlign": "top" }, { "flex": 41, "autoHeight": true, "layout": "form", "xtype": "panel", "items": event_type677, "labelAlign": "top" }, { "flex": 41, "autoHeight": true, "layout": "form", "xtype": "panel", "items": type678, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var subject683 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200, "fieldLabel": "Betreff", "anchor": "-20", "name": "subject" });
    var project684 = new Lino.TwinCombo({ "fieldLabel": "Klient", "name": "project", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.pcsw.Clients.detail)}, "emptyText": "Klient ausw\u00e4hlen...", "selectOnFocus": true, "hiddenName": "projectHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/notes/Notes/project", "method": "GET" }) }) });
    var company685 = new Lino.TwinCombo({ "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Organisation</span>", "name": "company", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.contacts.Companies.detail)}, "emptyText": "Organisation ausw\u00e4hlen...", "listeners": { "render": Lino.quicktip_renderer("Organisation","    An optional third-party Organization that is related to this Note.\n    The note will then be visible in that company's history panel.\n    ") }, "selectOnFocus": true, "hiddenName": "companyHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/notes/Notes/company", "method": "GET" }) }) });
    var left_3_panel686 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 117, "hideCheckBoxLabels": true, "items": [ { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": project684, "labelAlign": "top" }, { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": company685, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var id689 = new Ext.form.NumberField({ "selectOnFocus": true, "fieldLabel": "ID", "anchor": "-20", "name": "id" });
    var user690 = new Lino.TwinCombo({ "fieldLabel": "Autor", "name": "user", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.users.Users.detail)}, "emptyText": "Benutzer ausw\u00e4hlen...", "selectOnFocus": true, "hiddenName": "userHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/notes/Notes/user", "method": "GET" }) }) });
    var language691 = new Lino.ChoicesFieldElement({ "fieldLabel": "Sprache", "allowBlank": false, "value": "de", "hiddenName": "languageHidden", "selectOnFocus": true, "anchor": "-20", "store": [ [ "de", "Deutsch" ], [ "fr", "Franz\u00f6sisch" ], [ "nl", "Niederl\u00e4ndisch" ] ], "name": "language" });
    var build_time692 = new Ext.form.DisplayField({ "disabled": true, "fieldLabel": "Druckdatum", "anchor": "-20", "value": "<br>", "name": "build_time" });
    var left_4_panel693 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 99, "hideCheckBoxLabels": true, "items": [ { "flex": 12, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id689, "labelAlign": "top" }, { "flex": 25, "autoHeight": true, "layout": "form", "xtype": "panel", "items": user690, "labelAlign": "top" }, { "flex": 20, "autoHeight": true, "layout": "form", "xtype": "panel", "items": language691, "labelAlign": "top" }, { "flex": 41, "autoHeight": true, "layout": "form", "xtype": "panel", "items": build_time692, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var body698 = new Lino.RichTextPanel({ "selectOnFocus": true, "flex": 55, "containing_panel": this, "name": "body", "title": "Inhalt" });
    var left_panel699 = new Ext.Panel({ "flex": 66, "layout": "vbox", "items": [ left_1_panel679, { "items": subject683, "autoHeight": true, "layout": "form", "xtype": "panel", "labelAlign": "top" }, left_3_panel686, left_4_panel693, body698 ], "frame": true, "layoutConfig": { "align": "stretch" }, "autoScroll": false, "hideCheckBoxLabels": true, "labelWidth": 72, "border": false, "bodyBorder": false, "labelAlign": "top" });
    var UploadsByController_htmlbox701 = new Lino.HtmlBoxPanel({ "flex": 16, "ls_bbar_actions": [ { "itemId": "insert", "menu_item_text": "Neu", "must_save": true, "tooltip": "Neuen Datensatz erstellen", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-new", "overflowText": "Neu", "auto_save": true } ], "name": "UploadsByController", "containing_panel": this, "items": new Ext.BoxComponent({autoScroll:true}), "title": "Uploads", "master_panel": this, "value": "<br/>", "always_enabled": true, "bodyStyle": "overflow-x:hidden", "ls_insert_handler": Lino.uploads.UploadsByController.insert, "layout": "fit", "tools": [ Lino.show_in_own_window_button(Lino.uploads.UploadsByController.grid) ] });
    var outbox_MailsByController_grid747 = new Lino.outbox.MailsByController.GridPanel({ "tools": [ Lino.show_in_own_window_button(Lino.outbox.MailsByController.grid) ], "containing_panel": this, "hide_top_toolbar": true, "master_panel": this, "flex": 27 });
    var postings_PostingsByController_grid758 = new Lino.postings.PostingsByController.GridPanel({ "tools": [ Lino.show_in_own_window_button(Lino.postings.PostingsByController.grid) ], "containing_panel": this, "hide_top_toolbar": true, "master_panel": this, "flex": 27 });
    var cal_TasksByController_grid764 = new Lino.cal.TasksByController.GridPanel({ "tools": [ Lino.show_in_own_window_button(Lino.cal.TasksByController.grid) ], "containing_panel": this, "hide_top_toolbar": true, "master_panel": this, "flex": 27 });
    var right_panel765 = new Ext.Panel({ "flex": 33, "layout": "vbox", "items": [ UploadsByController_htmlbox701, outbox_MailsByController_grid747, postings_PostingsByController_grid758, cal_TasksByController_grid764 ], "frame": true, "layoutConfig": { "align": "stretch" }, "autoScroll": false, "hideCheckBoxLabels": true, "labelWidth": 72, "border": false, "bodyBorder": false, "labelAlign": "top" });
    var main_1_panel766 = new Ext.Panel({ "autoScroll": false, "border": false, "layout": "hbox", "hideCheckBoxLabels": true, "items": [ left_panel699, right_panel765 ], "frame": false, "layoutConfig": { "align": "stretch" }, "labelAlign": "top" });
    var main_panel767 = new Ext.Panel({ "autoScroll": false, "border": false, "layout": "fit", "hideCheckBoxLabels": true, "items": [ main_1_panel766 ], "frame": true, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel767;
    this.before_row_edit = function(record) {
      body698.refresh();
      UploadsByController_htmlbox701.refresh();
      outbox_MailsByController_grid747.on_master_changed();
      postings_PostingsByController_grid758.on_master_changed();
      cal_TasksByController_grid764.on_master_changed();
    }
    Lino.notes.Notes.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.users.MySettings.InsertFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  autoHeight: true,
  content_type: 7,
  initComponent : function() {
    var containing_panel = this;
    var username207 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Benutzername","\n        Required. Must be unique. \n        ") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Benutzername</span>", "name": "username", "maxLength": 30, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var email208 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 75, "fieldLabel": "e-mail address", "anchor": "-20", "name": "email" });
    var main_1_panel209 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": username207, "labelAlign": "top" }, { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": email208, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 135, "border": false, "anchor": "-20", "labelAlign": "top" });
    var first_name212 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 30, "fieldLabel": "Vorname", "anchor": "-20", "name": "first_name" });
    var last_name213 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 30, "fieldLabel": "Familienname", "anchor": "-20", "name": "last_name" });
    var main_2_panel214 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": first_name212, "labelAlign": "top" }, { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": last_name213, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 117, "border": false, "anchor": "-20", "labelAlign": "top" });
    var partner217 = new Lino.TwinCombo({ "fieldLabel": "Partner", "name": "partner", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.contacts.Partners.detail)}, "emptyText": "Partner ausw\u00e4hlen...", "selectOnFocus": true, "hiddenName": "partnerHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/users/Users/partner", "method": "GET" }) }) });
    var language218 = new Lino.ChoicesFieldElement({ "fieldLabel": "Sprache", "allowBlank": false, "selectOnFocus": true, "hiddenName": "languageHidden", "anchor": "-20", "store": [ [ "de", "Deutsch" ], [ "fr", "Franz\u00f6sisch" ], [ "nl", "Niederl\u00e4ndisch" ] ], "name": "language" });
    var profile219 = new Lino.ChoicesFieldElement({ "forceSelection": true, "fieldLabel": "Benutzerprofil", "name": "profile", "selectOnFocus": true, "anchor": "-20", "store": Lino.lino.UserProfiles, "hiddenName": "profileHidden" });
    var main_4_panel220 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 30, "autoHeight": true, "layout": "form", "xtype": "panel", "items": language218, "labelAlign": "top" }, { "flex": 69, "autoHeight": true, "layout": "form", "xtype": "panel", "items": profile219, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 135, "border": false, "anchor": "-20", "labelAlign": "top" });
    var main_panel223 = new Ext.Panel({ "hideCheckBoxLabels": true, "autoHeight": true, "border": false, "layout": "form", "labelWidth": 72, "autoScroll": false, "items": [ main_1_panel209, main_2_panel214, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": partner217, "anchor": "-20", "labelAlign": "top" }, main_4_panel220 ], "frame": true, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel223;
    this.before_row_edit = function(record) {
    }
    Lino.users.MySettings.InsertFormPanel.superclass.initComponent.call(this);
  }
});


Lino.households.Types.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 42,
  initComponent : function() {
    var containing_panel = this;
    var name1074 = new Ext.form.TextField({ "fieldLabel": "Bezeichnung", "name": "name", "maxLength": 200, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var name_fr1075 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200, "fieldLabel": "Bezeichnung (fr)", "anchor": "-20", "name": "name_fr" });
    var name_nl1076 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200, "fieldLabel": "Bezeichnung (nl)", "anchor": "-20", "name": "name_nl" });
    var main_1_panel1077 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 153, "hideCheckBoxLabels": true, "items": [ { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name1074, "labelAlign": "top" }, { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_fr1075, "labelAlign": "top" }, { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_nl1076, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var HouseholdsByType_grid1171 = new Lino.households.HouseholdsByType.GridPanel({ "tools": [ Lino.show_in_own_window_button(Lino.households.HouseholdsByType.grid) ], "containing_panel": this, "hide_top_toolbar": true, "master_panel": this, "flex": 83 });
    var main_panel1172 = new Ext.Panel({ "autoScroll": false, "border": false, "layout": "vbox", "hideCheckBoxLabels": true, "items": [ main_1_panel1077, HouseholdsByType_grid1171 ], "frame": true, "layoutConfig": { "align": "stretch" }, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel1172;
    this.before_row_edit = function(record) {
      HouseholdsByType_grid1171.on_master_changed();
    }
    Lino.households.Types.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.notes.Notes.InsertFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  autoHeight: true,
  content_type: 91,
  initComponent : function() {
    var containing_panel = this;
    var event_type768 = new Lino.TwinCombo({ "fieldLabel": "Ereignisart (Form)", "name": "event_type", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.notes.EventTypes.detail)}, "emptyText": "Event Type ausw\u00e4hlen...", "selectOnFocus": true, "hiddenName": "event_typeHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/notes/Notes/event_type", "method": "GET" }) }) });
    var type769 = new Lino.TwinCombo({ "fieldLabel": "Notizart (Inhalt)", "name": "type", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.notes.NoteTypes.detail)}, "emptyText": "Notizart ausw\u00e4hlen...", "selectOnFocus": true, "hiddenName": "typeHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/notes/Notes/type", "method": "GET" }) }) });
    var main_1_panel770 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": event_type768, "labelAlign": "top" }, { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": type769, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 171, "border": false, "anchor": "-20", "labelAlign": "top" });
    var subject773 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200, "fieldLabel": "Betreff", "anchor": "-20", "name": "subject" });
    var project774 = new Lino.TwinCombo({ "fieldLabel": "Klient", "name": "project", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.pcsw.Clients.detail)}, "emptyText": "Klient ausw\u00e4hlen...", "selectOnFocus": true, "hiddenName": "projectHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/notes/Notes/project", "method": "GET" }) }) });
    var company775 = new Lino.TwinCombo({ "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Organisation</span>", "name": "company", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.contacts.Companies.detail)}, "emptyText": "Organisation ausw\u00e4hlen...", "listeners": { "render": Lino.quicktip_renderer("Organisation","    An optional third-party Organization that is related to this Note.\n    The note will then be visible in that company's history panel.\n    ") }, "selectOnFocus": true, "hiddenName": "companyHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/notes/Notes/company", "method": "GET" }) }) });
    var main_3_panel776 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": project774, "labelAlign": "top" }, { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": company775, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 117, "border": false, "anchor": "-20", "labelAlign": "top" });
    var main_panel779 = new Ext.Panel({ "hideCheckBoxLabels": true, "autoHeight": true, "border": false, "layout": "form", "labelWidth": 72, "autoScroll": false, "items": [ main_1_panel770, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": subject773, "anchor": "-20", "labelAlign": "top" }, main_3_panel776 ], "frame": true, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel779;
    this.before_row_edit = function(record) {
    }
    Lino.notes.Notes.InsertFormPanel.superclass.initComponent.call(this);
  }
});


Lino.households.Roles.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 40,
  initComponent : function() {
    var containing_panel = this;
    var name1173 = new Ext.form.TextField({ "fieldLabel": "Bezeichnung", "name": "name", "maxLength": 200, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var name_fr1174 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200, "fieldLabel": "Bezeichnung (fr)", "anchor": "-20", "name": "name_fr" });
    var name_nl1175 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200, "fieldLabel": "Bezeichnung (nl)", "anchor": "-20", "name": "name_nl" });
    var name_giving1176 = new Ext.form.Checkbox({ "boxLabel": "namensgebend", "listeners": { "render": Lino.quicktip_renderer("namensgebend","When the `name` field of a Household is empty, \nits value is computed by joining the `Last Name` \nof all name-giving members with a dash (\"-\").\n      ") }, "hideLabel": true, "checked": false, "name": "name_giving", "selectOnFocus": true, "anchor": "-20" });
    var main_1_panel1177 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 153, "hideCheckBoxLabels": true, "items": [ { "flex": 28, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name1173, "labelAlign": "top" }, { "flex": 28, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_fr1174, "labelAlign": "top" }, { "flex": 28, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_nl1175, "labelAlign": "top" }, { "flex": 13, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_giving1176, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var MembersByRole_grid1188 = new Lino.households.MembersByRole.GridPanel({ "tools": [ Lino.show_in_own_window_button(Lino.households.MembersByRole.grid) ], "containing_panel": this, "hide_top_toolbar": true, "master_panel": this, "flex": 83 });
    var main_panel1189 = new Ext.Panel({ "autoScroll": false, "border": false, "layout": "vbox", "hideCheckBoxLabels": true, "items": [ main_1_panel1177, MembersByRole_grid1188 ], "frame": true, "layoutConfig": { "align": "stretch" }, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel1189;
    this.before_row_edit = function(record) {
      MembersByRole_grid1188.on_master_changed();
    }
    Lino.households.Roles.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.outbox.MyOutbox.InsertFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 27,
  initComponent : function() {
    var containing_panel = this;
    var project741 = new Lino.TwinCombo({ "fieldLabel": "Klient", "name": "project", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.pcsw.Clients.detail)}, "emptyText": "Klient ausw\u00e4hlen...", "selectOnFocus": true, "hiddenName": "projectHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/outbox/Mails/project", "method": "GET" }) }) });
    var subject742 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200, "fieldLabel": "Betreff", "anchor": "-20", "name": "subject" });
    var body743 = new Lino.RichTextPanel({ "selectOnFocus": true, "flex": 71, "containing_panel": this, "name": "body", "title": "Inhalt" });
    var main_panel744 = new Ext.Panel({ "autoScroll": false, "border": false, "layout": "vbox", "labelWidth": 72, "hideCheckBoxLabels": true, "items": [ { "items": project741, "autoHeight": true, "layout": "form", "xtype": "panel", "labelAlign": "top" }, { "items": subject742, "autoHeight": true, "layout": "form", "xtype": "panel", "labelAlign": "top" }, body743 ], "frame": true, "layoutConfig": { "align": "stretch" }, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel744;
    this.before_row_edit = function(record) {
      body743.refresh();
    }
    Lino.outbox.MyOutbox.InsertFormPanel.superclass.initComponent.call(this);
  }
});


Lino.ui.ContentTypes.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 5,
  initComponent : function() {
    var containing_panel = this;
    var id38 = new Ext.form.NumberField({ "selectOnFocus": true, "fieldLabel": "ID", "anchor": "-20", "name": "id" });
    var name39 = new Ext.form.TextField({ "fieldLabel": "name", "name": "name", "maxLength": 100, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var app_label40 = new Ext.form.TextField({ "fieldLabel": "app label", "name": "app_label", "maxLength": 100, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var model41 = new Ext.form.TextField({ "fieldLabel": "Python Modell-Klassenname", "name": "model", "maxLength": 100, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var base_classes_disp42 = new Ext.form.DisplayField({ "disabled": true, "fieldLabel": "Base classes", "name": "base_classes", "anchor": "-20", "value": "<br/>", "always_enabled": true });
    var main_1_panel43 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 234, "hideCheckBoxLabels": true, "items": [ { "flex": 5, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id38, "labelAlign": "top" }, { "flex": 21, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name39, "labelAlign": "top" }, { "flex": 21, "autoHeight": true, "layout": "form", "xtype": "panel", "items": app_label40, "labelAlign": "top" }, { "flex": 21, "autoHeight": true, "layout": "form", "xtype": "panel", "items": model41, "labelAlign": "top" }, { "flex": 30, "autoHeight": true, "layout": "form", "xtype": "panel", "items": base_classes_disp42, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var ui_HelpTextsByModel_grid55 = new Lino.ui.HelpTextsByModel.GridPanel({ "tools": [ Lino.show_in_own_window_button(Lino.ui.HelpTextsByModel.grid) ], "containing_panel": this, "hide_top_toolbar": true, "master_panel": this, "flex": 62 });
    var main_panel56 = new Ext.Panel({ "autoScroll": false, "border": false, "layout": "vbox", "hideCheckBoxLabels": true, "items": [ main_1_panel43, ui_HelpTextsByModel_grid55 ], "frame": true, "layoutConfig": { "align": "stretch" }, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel56;
    this.before_row_edit = function(record) {
      ui_HelpTextsByModel_grid55.on_master_changed();
    }
    Lino.ui.ContentTypes.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.cal.MyEvents.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 36,
  initComponent : function() {
    var containing_panel = this;
    var calendar844 = new Lino.TwinCombo({ "fieldLabel": "Kalender", "name": "calendar", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.cal.Calendars.detail)}, "emptyText": "Kalender ausw\u00e4hlen...", "selectOnFocus": true, "hiddenName": "calendarHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/Events/calendar", "method": "GET" }) }) });
    var summary845 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200, "fieldLabel": "Kurzbeschreibung", "anchor": "-20", "name": "summary" });
    var project846 = new Lino.TwinCombo({ "fieldLabel": "Klient", "name": "project", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.pcsw.Clients.detail)}, "emptyText": "Klient ausw\u00e4hlen...", "selectOnFocus": true, "hiddenName": "projectHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/Events/project", "method": "GET" }) }) });
    var general_1_panel847 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 153, "hideCheckBoxLabels": true, "items": [ { "flex": 32, "autoHeight": true, "layout": "form", "xtype": "panel", "items": calendar844, "labelAlign": "top" }, { "flex": 34, "autoHeight": true, "layout": "form", "xtype": "panel", "items": summary845, "labelAlign": "top" }, { "flex": 32, "autoHeight": true, "layout": "form", "xtype": "panel", "items": project846, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var start_date851 = new Lino.DateField({ "selectOnFocus": true, "fieldLabel": "Beginnt am", "anchor": "-20", "name": "start_date" });
    var start_time852 = new Lino.TimeField({ "selectOnFocus": true, "fieldLabel": "Beginnt um", "anchor": "-20", "name": "start_time" });
    var start_panel853 = new Ext.Panel({ "flex": 25, "autoHeight": true, "layout": "hbox", "items": [ { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": start_date851, "labelAlign": "top" }, { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": start_time852, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "autoScroll": false, "hideCheckBoxLabels": true, "labelWidth": 99, "border": false, "labelAlign": "top" });
    var end_date856 = new Lino.DateField({ "selectOnFocus": true, "fieldLabel": "Endet am", "anchor": "-20", "name": "end_date" });
    var end_time857 = new Lino.TimeField({ "selectOnFocus": true, "fieldLabel": "Endet um", "anchor": "-20", "name": "end_time" });
    var end_panel858 = new Ext.Panel({ "flex": 25, "autoHeight": true, "layout": "hbox", "items": [ { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": end_date856, "labelAlign": "top" }, { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": end_time857, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "autoScroll": false, "hideCheckBoxLabels": true, "labelWidth": 81, "border": false, "labelAlign": "top" });
    var user861 = new Lino.TwinCombo({ "fieldLabel": "Verantwortlicher", "name": "user", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.users.Users.detail)}, "emptyText": "Benutzer ausw\u00e4hlen...", "selectOnFocus": true, "hiddenName": "userHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/Events/user", "method": "GET" }) }) });
    var assigned_to862 = new Lino.TwinCombo({ "fieldLabel": "Zugewiesen zu", "name": "assigned_to", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.users.Users.detail)}, "emptyText": "Benutzer ausw\u00e4hlen...", "selectOnFocus": true, "hiddenName": "assigned_toHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/Events/assigned_to", "method": "GET" }) }) });
    var general_2_panel863 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 153, "hideCheckBoxLabels": true, "items": [ start_panel853, end_panel858, { "flex": 24, "autoHeight": true, "layout": "form", "xtype": "panel", "items": user861, "labelAlign": "top" }, { "flex": 24, "autoHeight": true, "layout": "form", "xtype": "panel", "items": assigned_to862, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var place866 = new Lino.TwinCombo({ "fieldLabel": "Ort", "name": "place", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.cal.Places.detail)}, "emptyText": "Ort ausw\u00e4hlen...", "selectOnFocus": true, "hiddenName": "placeHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/Events/place", "method": "GET" }) }) });
    var priority867 = new Lino.RemoteComboFieldElement({ "fieldLabel": "Priorit\u00e4t", "name": "priority", "pageSize": 20, "emptyText": "Priorit\u00e4t ausw\u00e4hlen...", "selectOnFocus": true, "hiddenName": "priorityHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/Events/priority", "method": "GET" }) }) });
    var access_class868 = new Lino.ChoicesFieldElement({ "forceSelection": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Zugriffsklasse</span>", "name": "access_class", "hiddenName": "access_classHidden", "listeners": { "render": Lino.quicktip_renderer("Zugriffsklasse","Ob dieser Termin  privat, \u00f6ffentlich oder halb \u00f6ffentlich ist") }, "selectOnFocus": true, "anchor": "-20", "store": Lino.cal.AccessClasses });
    var transparent869 = new Ext.form.Checkbox({ "boxLabel": "nicht blockierend", "listeners": { "render": Lino.quicktip_renderer("nicht blockierend","Dieser Termin l\u00e4sst auch andere Termine zur gleichen Zeit zu.") }, "hideLabel": true, "checked": false, "name": "transparent", "selectOnFocus": true, "anchor": "-20" });
    var general_3_panel870 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 162, "hideCheckBoxLabels": true, "items": [ { "flex": 23, "autoHeight": true, "layout": "form", "xtype": "panel", "items": place866, "labelAlign": "top" }, { "flex": 23, "autoHeight": true, "layout": "form", "xtype": "panel", "items": priority867, "labelAlign": "top" }, { "flex": 40, "autoHeight": true, "layout": "form", "xtype": "panel", "items": access_class868, "labelAlign": "top" }, { "flex": 11, "autoHeight": true, "layout": "form", "xtype": "panel", "items": transparent869, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var owner_disp875 = new Ext.form.DisplayField({ "disabled": true, "fieldLabel": "Verkn\u00fcpft mit", "anchor": "-20", "name": "owner" });
    var workflow_buttons_disp876 = new Ext.form.DisplayField({ "disabled": true, "fieldLabel": "Arbeitsablauf", "name": "workflow_buttons", "anchor": "-20", "value": "<br/>", "always_enabled": true });
    var general_4_panel877 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 126, "hideCheckBoxLabels": true, "items": [ { "flex": 25, "autoHeight": true, "layout": "form", "xtype": "panel", "items": owner_disp875, "labelAlign": "top" }, { "flex": 75, "autoHeight": true, "layout": "form", "xtype": "panel", "items": workflow_buttons_disp876, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var description880 = new Lino.RichTextPanel({ "selectOnFocus": true, "flex": 33, "containing_panel": this, "name": "description", "title": "Beschreibung" });
    var GuestsByEvent_grid890 = new Lino.cal.GuestsByEvent.GridPanel({ "tools": [ Lino.show_in_own_window_button(Lino.cal.GuestsByEvent.grid) ], "containing_panel": this, "hide_top_toolbar": true, "master_panel": this, "flex": 66 });
    var general_5_panel891 = new Ext.Panel({ "flex": 45, "border": false, "layout": "hbox", "labelWidth": 0, "hideCheckBoxLabels": true, "items": [ description880, GuestsByEvent_grid890 ], "autoScroll": false, "layoutConfig": { "align": "stretch" }, "frame": false, "labelAlign": "top" });
    var general_panel892 = new Ext.Panel({ "layout": "vbox", "title": "Allgemein", "items": [ general_1_panel847, general_2_panel863, general_3_panel870, general_4_panel877, general_5_panel891 ], "frame": true, "layoutConfig": { "align": "stretch" }, "hideCheckBoxLabels": true, "listeners": { "activate": Lino.on_tab_activate }, "autoScroll": false, "border": false, "bodyBorder": false, "labelAlign": "top" });
    var id893 = new Ext.form.NumberField({ "selectOnFocus": true, "fieldLabel": "ID", "anchor": "-20", "name": "id" });
    var created894 = new Ext.form.DisplayField({ "disabled": true, "fieldLabel": "Erstellt", "anchor": "-20", "value": "<br>", "name": "created" });
    var modified895 = new Ext.form.DisplayField({ "disabled": true, "fieldLabel": "Bearbeitet", "anchor": "-20", "value": "<br>", "name": "modified" });
    var more_1_panel896 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 99, "hideCheckBoxLabels": true, "items": [ { "flex": 11, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id893, "labelAlign": "top" }, { "flex": 44, "autoHeight": true, "layout": "form", "xtype": "panel", "items": created894, "labelAlign": "top" }, { "flex": 44, "autoHeight": true, "layout": "form", "xtype": "panel", "items": modified895, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var outbox_MailsByController_grid900 = new Lino.outbox.MailsByController.GridPanel({ "tools": [ Lino.show_in_own_window_button(Lino.outbox.MailsByController.grid) ], "containing_panel": this, "hide_top_toolbar": true, "master_panel": this, "flex": 50 });
    var postings_PostingsByController_grid901 = new Lino.postings.PostingsByController.GridPanel({ "tools": [ Lino.show_in_own_window_button(Lino.postings.PostingsByController.grid) ], "containing_panel": this, "hide_top_toolbar": true, "master_panel": this, "flex": 50 });
    var more_2_panel902 = new Ext.Panel({ "flex": 83, "border": false, "layout": "hbox", "hideCheckBoxLabels": true, "items": [ outbox_MailsByController_grid900, postings_PostingsByController_grid901 ], "autoScroll": false, "layoutConfig": { "align": "stretch" }, "frame": false, "labelAlign": "top" });
    var more_panel903 = new Ext.Panel({ "layout": "vbox", "title": "Mehr", "items": [ more_1_panel896, more_2_panel902 ], "frame": true, "layoutConfig": { "align": "stretch" }, "hideCheckBoxLabels": true, "listeners": { "activate": Lino.on_tab_activate }, "autoScroll": false, "border": false, "bodyBorder": false, "labelAlign": "top" });
    var main_panel904 = new Ext.TabPanel({ "hideCheckBoxLabels": true, "border": false, "split": true, "autoScroll": false, "items": [ general_panel892, more_panel903 ], "activeTab": 0, "bodyBorder": false, "frame": true, "labelAlign": "top" });
    this.items = main_panel904;
    this.before_row_edit = function(record) {
      description880.refresh();
      GuestsByEvent_grid890.on_master_changed();
      outbox_MailsByController_grid900.on_master_changed();
      postings_PostingsByController_grid901.on_master_changed();
    }
    Lino.cal.MyEvents.DetailFormPanel.superclass.initComponent.call(this);
  }
});

Lino.contacts.Companies.merge_row = new Lino.WindowAction({ "draggable": true, "width": Lino.chars2width(50), "autoHeight": true, "maximizable": true, "modal": true, "maximized": false },function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.contacts.Companies.merge_row_ActionFormPanel({});
});
Lino.cal.GuestStates.wf2 = new Lino.WindowAction({ "draggable": true, "width": Lino.chars2width(50), "maximizable": true, "modal": true, "maximized": false, "height": Lino.rows2height(15) },function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.cal.Guests.wf2_ActionFormPanel({});
});
Lino.pcsw.ClientStates.wf2 = new Lino.WindowAction({ "draggable": true, "width": Lino.chars2width(50), "maximizable": true, "modal": true, "maximized": false, "height": Lino.rows2height(15) },function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.pcsw.Clients.wf2_ActionFormPanel({});
});
Lino.pcsw.Clients.merge_row = new Lino.WindowAction({ "draggable": true, "width": Lino.chars2width(70), "autoHeight": true, "maximizable": true, "modal": true, "maximized": false },function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.pcsw.Clients.merge_row_ActionFormPanel({});
});

// js_render_GridPanel_class ui.ContentTypes
Lino.ui.ContentTypes.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "Keine Daten anzuzeigen." },
  ls_url : "/ui/ContentTypes",
  ls_bbar_actions : [ { "itemId": "insert", "menu_item_text": "Neu", "must_save": true, "tooltip": "Neuen Datensatz erstellen", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-new", "overflowText": "Neu", "auto_save": true }, { "itemId": "detail", "menu_item_text": "Detail", "tooltip": "Detail-Fenster auf diesem Datensatz \u00f6ffnen", "panel_btn_handler": Lino.show_detail, "iconCls": "x-tbar-detail", "overflowText": "Detail", "auto_save": true }, { "itemId": null, "menu_item_text": "L\u00f6schen", "tooltip": "Diesen Datensatz l\u00f6schen", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "L\u00f6schen", "auto_save": false } ],
  title : "Inhaltstypen",
  page_length : 20,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "type": "int", "name": "id" }, { "name": "name" }, { "name": "app_label" }, { "name": "model" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 0,
  ls_grid_configs : [  ],
  content_type : 5,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 5,
  initComponent : function() {
    this.ls_detail_handler = Lino.ui.ContentTypes.detail;
    this.ls_insert_handler = Lino.ui.ContentTypes.insert;
    var ww = this.containing_window;
    var id2285 = new Ext.form.NumberField({ "selectOnFocus": true });
    var name2286 = new Ext.form.TextField({ "selectOnFocus": true, "allowBlank": false, "maxLength": 100 });
    var app_label2287 = new Ext.form.TextField({ "selectOnFocus": true, "allowBlank": false, "maxLength": 100 });
    var model2288 = new Ext.form.TextField({ "selectOnFocus": true, "allowBlank": false, "maxLength": 100 });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ new Lino.NullNumberColumn({ "colIndex": 0, "sortable": true, "format": "0", "editable": true, "filter": { "type": "numeric" }, "header": "ID", "renderer": Lino.id_renderer, "editor": id2285, "width": Lino.chars2width(6), "dataIndex": "id" }), { "colIndex": 1, "sortable": true, "header": "name", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "name", "editor": name2286 }, { "colIndex": 2, "sortable": true, "header": "app label", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "app_label", "editor": app_label2287 }, { "colIndex": 3, "sortable": true, "header": "Python Modell-Klassenname", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "model", "editor": model2288 } ];
    Lino.ui.ContentTypes.GridPanel.superclass.initComponent.call(this);
  }
});


Lino.ui.ContentTypes.insertPanel = Ext.extend(Lino.ui.ContentTypes.DetailFormPanel,{
  empty_title: "Neu Inhaltstypen",
  hide_navigator: true,
  ls_bbar_actions: [ { "itemId": "post", "menu_item_text": "Erstellen", "tooltip": "Datensatz erstellen und dann im Detail-Fenster \u00f6ffnen", "panel_btn_handler": function(panel){panel.save(null,true,'post')}, "text": "Erstellen", "overflowText": "Erstellen", "auto_save": false }, { "itemId": "poststay", "menu_item_text": "Erstellen ohne Detail", "tooltip": "Nach Erstellen des Datensatzes kein Detail-Fenster \u00f6ffnen", "panel_btn_handler": function(panel){panel.save(null,false,'poststay')}, "text": "Erstellen ohne Detail", "overflowText": "Erstellen ohne Detail", "auto_save": false } ],
  ls_url: "/ui/ContentTypes",
  action_name: "insert",
  initComponent : function() {
    this.ls_detail_handler = Lino.ui.ContentTypes.detail;
    this.ls_insert_handler = Lino.ui.ContentTypes.insert;
    Lino.ui.ContentTypes.insertPanel.superclass.initComponent.call(this);
  }
});

Lino.ui.ContentTypes.insert = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.ui.ContentTypes.insertPanel(p);
});

Lino.ui.ContentTypes.detailPanel = Ext.extend(Lino.ui.ContentTypes.DetailFormPanel,{
  empty_title: "Detail Inhaltstypen",
  ls_bbar_actions: [ { "itemId": "put", "menu_item_text": "Speichern", "tooltip": "\u00c4nderungen in diesem Formular speichern", "panel_btn_handler": function(panel){panel.save(null,false,'put')}, "iconCls": "x-tbar-save", "overflowText": "Speichern", "auto_save": false }, { "itemId": "insert", "menu_item_text": "Neu", "must_save": true, "tooltip": "Neuen Datensatz erstellen", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-new", "overflowText": "Neu", "auto_save": true }, { "itemId": null, "menu_item_text": "L\u00f6schen", "tooltip": "Diesen Datensatz l\u00f6schen", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "L\u00f6schen", "auto_save": false } ],
  ls_url: "/ui/ContentTypes",
  action_name: "detail",
  initComponent : function() {
    this.ls_detail_handler = Lino.ui.ContentTypes.detail;
    this.ls_insert_handler = Lino.ui.ContentTypes.insert;
    Lino.ui.ContentTypes.detailPanel.superclass.initComponent.call(this);
  }
});

Lino.ui.ContentTypes.detail = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.ui.ContentTypes.detailPanel(p);
});
Lino.ui.ContentTypes.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.ui.ContentTypes.GridPanel(p);
});

// js_render_GridPanel_class ui.HelpTexts
Lino.ui.HelpTexts.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "Keine Daten anzuzeigen." },
  ls_url : "/ui/HelpTexts",
  ls_bbar_actions : [ { "itemId": null, "menu_item_text": "L\u00f6schen", "tooltip": "Diesen Datensatz l\u00f6schen", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "L\u00f6schen", "auto_save": false } ],
  title : "Hilfetexte",
  page_length : 20,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "name": "field" }, { "name": "verbose_name" }, { "name": "help_text" }, { "type": "int", "name": "id" }, { "name": "content_type" }, 'content_typeHidden', { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 3,
  ls_grid_configs : [  ],
  content_type : 2,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 7,
  initComponent : function() {
    var ww = this.containing_window;
    var field2290 = new Lino.SimpleRemoteComboFieldElement({ "selectOnFocus": true, "allowBlank": false, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/ui/HelpTexts/field", "method": "GET" }) }) });
    var verbose_name2291 = new Ext.form.TextField({ "disabled": true, "maxLength": 200 });
    var help_text2292 = new Ext.form.TextArea({ "selectOnFocus": true, "growMax": 2000 });
    var id2293 = new Ext.form.NumberField({ "selectOnFocus": true });
    var content_type2294 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/ui/HelpTexts/content_type", "method": "GET" }) }), "allowBlank": false, "pageSize": 20, "emptyText": "Inhaltstyp ausw\u00e4hlen..." });
    this.before_row_edit = function(record) {
      field2290.setContextValue('content_type',record ? record.data['content_typeHidden'] : undefined);
    };
    this.onRender = function(ct, position) {
      content_type2294.on('change',Lino.chooser_handler(field2290,'content_type'));
      Lino.ui.HelpTexts.GridPanel.superclass.onRender.call(this, ct, position);
    }
    this.ls_columns = [ { "colIndex": 0, "sortable": true, "header": "Feld", "editable": true, "tooltip": "The name of the field.", "filter": { "type": "string" }, "width": Lino.chars2width(11), "dataIndex": "field", "editor": field2290 }, { "width": Lino.chars2width(22), "colIndex": 1, "sortable": false, "dataIndex": "verbose_name", "header": "Feldbezeichnung", "editable": false }, { "colIndex": 2, "sortable": false, "header": "Hilfetext", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(61), "renderer": Lino.text_renderer, "editor": help_text2292, "dataIndex": "help_text" }, new Lino.NullNumberColumn({ "colIndex": 3, "sortable": true, "format": "0", "editable": true, "filter": { "type": "numeric" }, "header": "ID", "renderer": Lino.id_renderer, "editor": id2293, "width": Lino.chars2width(6), "dataIndex": "id" }), { "colIndex": 4, "sortable": true, "header": "Modell", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('content_typeHidden','Lino.ui.ContentTypes.detail'), "editor": content_type2294, "dataIndex": "content_type" } ];
    Lino.ui.HelpTexts.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.ui.HelpTexts.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.ui.HelpTexts.GridPanel(p);
});

// js_render_GridPanel_class ui.TextFieldTemplates
Lino.ui.TextFieldTemplates.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "Keine Daten anzuzeigen." },
  ls_url : "/ui/TextFieldTemplates",
  ls_bbar_actions : [ { "itemId": "insert", "menu_item_text": "Neu", "must_save": true, "tooltip": "Neuen Datensatz erstellen", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-new", "overflowText": "Neu", "auto_save": true }, { "itemId": "detail", "menu_item_text": "Detail", "tooltip": "Detail-Fenster auf diesem Datensatz \u00f6ffnen", "panel_btn_handler": Lino.show_detail, "iconCls": "x-tbar-detail", "overflowText": "Detail", "auto_save": true }, { "itemId": null, "menu_item_text": "L\u00f6schen", "tooltip": "Diesen Datensatz l\u00f6schen", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "L\u00f6schen", "auto_save": false } ],
  title : "Einf\u00fcgetexte",
  page_length : 20,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "type": "int", "name": "id" }, { "name": "user" }, 'userHidden', { "name": "name" }, { "name": "description" }, { "name": "team" }, 'teamHidden', { "name": "text" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 0,
  ls_grid_configs : [  ],
  content_type : 1,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 9,
  initComponent : function() {
    this.ls_detail_handler = Lino.ui.TextFieldTemplates.detail;
    this.ls_insert_handler = Lino.ui.TextFieldTemplates.insert;
    var ww = this.containing_window;
    var id2296 = new Ext.form.NumberField({ "selectOnFocus": true });
    var user2297 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/ui/TextFieldTemplates/user", "method": "GET" }) }), "pageSize": 20, "emptyText": "Benutzer ausw\u00e4hlen..." });
    var name2298 = new Ext.form.TextField({ "selectOnFocus": true, "allowBlank": false, "maxLength": 200 });
    var description2299 = new Ext.form.TextArea({ "selectOnFocus": true, "growMax": 2000 });
    var team2300 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/ui/TextFieldTemplates/team", "method": "GET" }) }), "pageSize": 20, "emptyText": "Team ausw\u00e4hlen..." });
    var text2301 = new Lino.RichTextPanel({ "selectOnFocus": true, "containing_panel": this, "title": "Vorlagentext" });
    this.before_row_edit = function(record) {
      text2301.refresh();
    };
    this.ls_columns = [ new Lino.NullNumberColumn({ "colIndex": 0, "sortable": true, "format": "0", "editable": true, "filter": { "type": "numeric" }, "header": "ID", "renderer": Lino.id_renderer, "editor": id2296, "width": Lino.chars2width(6), "dataIndex": "id" }), { "colIndex": 1, "sortable": true, "header": "Autor", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(16), "dataIndex": "user", "editor": user2297 }, { "colIndex": 2, "sortable": true, "header": "Bezeichnung", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "name", "editor": name2298 }, { "colIndex": 3, "sortable": false, "header": "Beschreibung", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(61), "renderer": Lino.text_renderer, "editor": description2299, "dataIndex": "description" }, { "colIndex": 4, "sortable": true, "header": "Team", "editable": true, "tooltip": "If not empty, then this template is reserved to members of this team.", "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "team", "editor": team2300 }, { "colIndex": 5, "sortable": false, "header": "text", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(61), "renderer": Lino.text_renderer, "editor": text2301, "dataIndex": "text" } ];
    Lino.ui.TextFieldTemplates.GridPanel.superclass.initComponent.call(this);
  }
});


Lino.ui.TextFieldTemplates.insertPanel = Ext.extend(Lino.ui.TextFieldTemplates.InsertFormPanel,{
  empty_title: "Neu Einf\u00fcgetexte",
  hide_navigator: true,
  ls_bbar_actions: [ { "itemId": "post", "menu_item_text": "Erstellen", "tooltip": "Datensatz erstellen und dann im Detail-Fenster \u00f6ffnen", "panel_btn_handler": function(panel){panel.save(null,true,'post')}, "text": "Erstellen", "overflowText": "Erstellen", "auto_save": false }, { "itemId": "poststay", "menu_item_text": "Erstellen ohne Detail", "tooltip": "Nach Erstellen des Datensatzes kein Detail-Fenster \u00f6ffnen", "panel_btn_handler": function(panel){panel.save(null,false,'poststay')}, "text": "Erstellen ohne Detail", "overflowText": "Erstellen ohne Detail", "auto_save": false } ],
  ls_url: "/ui/TextFieldTemplates",
  action_name: "insert",
  initComponent : function() {
    this.ls_detail_handler = Lino.ui.TextFieldTemplates.detail;
    this.ls_insert_handler = Lino.ui.TextFieldTemplates.insert;
    Lino.ui.TextFieldTemplates.insertPanel.superclass.initComponent.call(this);
  }
});

Lino.ui.TextFieldTemplates.insert = new Lino.WindowAction({ "draggable": true, "width": Lino.chars2width(60), "autoHeight": true, "maximizable": true, "modal": true, "maximized": false },function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.ui.TextFieldTemplates.insertPanel(p);
});

Lino.ui.TextFieldTemplates.detailPanel = Ext.extend(Lino.ui.TextFieldTemplates.DetailFormPanel,{
  empty_title: "Detail Einf\u00fcgetexte",
  ls_bbar_actions: [ { "itemId": "put", "menu_item_text": "Speichern", "tooltip": "\u00c4nderungen in diesem Formular speichern", "panel_btn_handler": function(panel){panel.save(null,false,'put')}, "iconCls": "x-tbar-save", "overflowText": "Speichern", "auto_save": false }, { "itemId": "insert", "menu_item_text": "Neu", "must_save": true, "tooltip": "Neuen Datensatz erstellen", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-new", "overflowText": "Neu", "auto_save": true }, { "itemId": null, "menu_item_text": "L\u00f6schen", "tooltip": "Diesen Datensatz l\u00f6schen", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "L\u00f6schen", "auto_save": false } ],
  ls_url: "/ui/TextFieldTemplates",
  action_name: "detail",
  initComponent : function() {
    this.ls_detail_handler = Lino.ui.TextFieldTemplates.detail;
    this.ls_insert_handler = Lino.ui.TextFieldTemplates.insert;
    Lino.ui.TextFieldTemplates.detailPanel.superclass.initComponent.call(this);
  }
});

Lino.ui.TextFieldTemplates.detail = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.ui.TextFieldTemplates.detailPanel(p);
});
Lino.ui.TextFieldTemplates.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.ui.TextFieldTemplates.GridPanel(p);
});

// js_render_GridPanel_class users.MySettings
Lino.users.MySettings.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "Keine Daten anzuzeigen." },
  ls_url : "/users/MySettings",
  ls_bbar_actions : [ { "itemId": "put", "menu_item_text": "Speichern", "tooltip": "\u00c4nderungen in diesem Formular speichern", "panel_btn_handler": function(panel){panel.save(null,false,'put')}, "iconCls": "x-tbar-save", "overflowText": "Speichern", "auto_save": false }, { "itemId": "update_reminders", "menu_item_text": "Erinnerungen aktualisieren", "must_save": true, "panel_btn_handler": Lino.row_action_handler('update_reminders','GET'), "text": "Erinnerungen aktualisieren", "overflowText": "Erinnerungen aktualisieren", "auto_save": true } ],
  title : "Benutzer",
  page_length : 20,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "name": "username" }, { "name": "profile" }, 'profileHidden', { "name": "first_name" }, { "name": "last_name" }, { "type": "int", "name": "id" }, { "name": "created" }, { "name": "modified" }, { "name": "password" }, { "name": "email" }, { "name": "remarks" }, { "name": "language" }, 'languageHidden', { "name": "partner" }, 'partnerHidden', { "name": "access_class" }, 'access_classHidden', { "name": "calendar" }, 'calendarHidden', { "name": "coaching_type" }, 'coaching_typeHidden', { "type": "boolean", "name": "coaching_supervisor" }, { "type": "int", "name": "newcomer_quota" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 5,
  ls_grid_configs : [  ],
  content_type : 7,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 24,
  initComponent : function() {
    this.ls_detail_handler = Lino.users.MySettings.detail;
    this.ls_insert_handler = Lino.users.Users.insert;
    var ww = this.containing_window;
    var username2303 = new Ext.form.TextField({ "selectOnFocus": true, "allowBlank": false, "maxLength": 30 });
    var profile2304 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "forceSelection": true, "store": Lino.lino.UserProfiles });
    var first_name2305 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 30 });
    var last_name2306 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 30 });
    var id2307 = new Ext.form.NumberField({ "selectOnFocus": true });
    var created2308 = new Ext.form.DisplayField({ "disabled": true, "value": "<br>" });
    var modified2309 = new Ext.form.DisplayField({ "disabled": true, "value": "<br>" });
    var password2310 = new Ext.form.TextField({ "selectOnFocus": true, "allowBlank": false, "maxLength": 128 });
    var email2311 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 75 });
    var remarks2312 = new Ext.form.TextArea({ "selectOnFocus": true, "growMax": 2000 });
    var language2313 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "allowBlank": false, "store": [ [ "de", "Deutsch" ], [ "fr", "Franz\u00f6sisch" ], [ "nl", "Niederl\u00e4ndisch" ] ] });
    var partner2314 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/users/MySettings/partner", "method": "GET" }) }), "pageSize": 20, "emptyText": "Partner ausw\u00e4hlen..." });
    var access_class2315 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "forceSelection": true, "allowBlank": false, "store": Lino.cal.AccessClasses });
    var calendar2316 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/users/MySettings/calendar", "method": "GET" }) }), "pageSize": 20, "emptyText": "Kalender ausw\u00e4hlen..." });
    var coaching_type2317 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/users/MySettings/coaching_type", "method": "GET" }) }), "pageSize": 20, "emptyText": "Dienst ausw\u00e4hlen..." });
    var coaching_supervisor2318 = new Ext.form.Checkbox({ "selectOnFocus": true, "checked": false });
    var newcomer_quota2319 = new Ext.form.NumberField({ "selectOnFocus": true, "allowBlank": false, "value": 0 });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ { "colIndex": 0, "sortable": true, "header": "Benutzername", "editable": true, "tooltip": "\n        Required. Must be unique. \n        ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "username", "editor": username2303 }, { "colIndex": 1, "sortable": true, "header": "Benutzerprofil", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(47), "dataIndex": "profile", "editor": profile2304 }, { "colIndex": 2, "sortable": true, "header": "Vorname", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "first_name", "editor": first_name2305 }, { "colIndex": 3, "sortable": true, "header": "Familienname", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "last_name", "editor": last_name2306 }, new Lino.NullNumberColumn({ "colIndex": 4, "sortable": true, "format": "0", "editable": true, "filter": { "type": "numeric" }, "header": "ID", "renderer": Lino.id_renderer, "editor": id2307, "width": Lino.chars2width(6), "dataIndex": "id" }), { "width": Lino.chars2width(17), "colIndex": 5, "sortable": true, "dataIndex": "created", "header": "Erstellt", "editable": false }, { "width": Lino.chars2width(17), "colIndex": 6, "sortable": true, "dataIndex": "modified", "header": "Bearbeitet", "editable": false }, { "colIndex": 7, "sortable": true, "header": "Passwort", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "password", "hidden": true, "editor": password2310 }, { "colIndex": 8, "sortable": true, "header": "e-mail address", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "email", "editor": email2311 }, { "colIndex": 9, "sortable": false, "header": "Bemerkungen", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(61), "renderer": Lino.text_renderer, "hidden": true, "editor": remarks2312, "dataIndex": "remarks" }, { "colIndex": 10, "sortable": true, "header": "Sprache", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "language", "editor": language2313 }, { "colIndex": 11, "sortable": true, "header": "Partner", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('partnerHidden','Lino.contacts.Partners.detail'), "editor": partner2314, "dataIndex": "partner" }, { "colIndex": 12, "sortable": true, "header": "Standardm\u00e4\u00dfige Zugriffsklasse", "editable": true, "tooltip": "Die standardm\u00e4\u00dfige Zugriffsklasse f\u00fcr Ihre Termine und Aufgaben", "filter": { "type": "string" }, "width": Lino.chars2width(35), "dataIndex": "access_class", "editor": access_class2315 }, { "colIndex": 13, "sortable": true, "header": "Standard-Kalender", "editable": true, "tooltip": "The default calendar for your events and tasks.", "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "calendar", "editor": calendar2316 }, { "colIndex": 14, "sortable": true, "header": "Dienst", "editable": true, "tooltip": "The default CoachingType used when creating Coachings.", "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "coaching_type", "editor": coaching_type2317 }, { "colIndex": 15, "sortable": false, "xtype": "checkcolumn", "header": "Benachrichtigung wenn ein Begleiter zugewiesen wird", "editable": true, "tooltip": "Wenn ein Neuantrag einem Begleiter zugewiesen wurde, wird au\u00dfer dem Begleiter auch dieser Benutzer benachrichtigt.", "filter": { "type": "boolean" }, "width": Lino.chars2width(11), "dataIndex": "coaching_supervisor" }, new Lino.NullNumberColumn({ "colIndex": 16, "sortable": true, "format": "0", "editable": true, "tooltip": "Wieviel Arbeitszeit dieser Benutzer f\u00fcr Neuantr\u00e4ge zur Verf\u00fcgung steht\n(100 = ganztags, 50 = halbtags, 0 = gar nicht).\nWenn zwei Benutzer die gleiche Belastungspunktzahl haben, \naber einer davon sich nur zu 50% um Neuantr\u00e4ge k\u00fcmmert, \ngilt er als doppelt so belastet wie sein Kollege.\n", "filter": { "type": "numeric" }, "header": "Quote NZ", "dataIndex": "newcomer_quota", "width": Lino.chars2width(6), "editor": newcomer_quota2319 }) ];
    Lino.users.MySettings.GridPanel.superclass.initComponent.call(this);
  }
});


Lino.users.MySettings.detailPanel = Ext.extend(Lino.users.MySettings.DetailFormPanel,{
  empty_title: "Benutzer",
  ls_bbar_actions: [ { "itemId": "put", "menu_item_text": "Speichern", "tooltip": "\u00c4nderungen in diesem Formular speichern", "panel_btn_handler": function(panel){panel.save(null,false,'put')}, "iconCls": "x-tbar-save", "overflowText": "Speichern", "auto_save": false }, { "itemId": "update_reminders", "menu_item_text": "Erinnerungen aktualisieren", "must_save": true, "panel_btn_handler": Lino.row_action_handler('update_reminders','GET'), "text": "Erinnerungen aktualisieren", "overflowText": "Erinnerungen aktualisieren", "auto_save": true } ],
  ls_url: "/users/MySettings",
  initComponent : function() {
    this.ls_detail_handler = Lino.users.MySettings.detail;
    this.ls_insert_handler = Lino.users.Users.insert;
    Lino.users.MySettings.detailPanel.superclass.initComponent.call(this);
  }
});

Lino.users.MySettings.detail = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.users.MySettings.detailPanel(p);
});

Lino.users.MySettings.detailPanel = Ext.extend(Lino.users.MySettings.DetailFormPanel,{
  empty_title: "Benutzer",
  ls_bbar_actions: [ { "itemId": "put", "menu_item_text": "Speichern", "tooltip": "\u00c4nderungen in diesem Formular speichern", "panel_btn_handler": function(panel){panel.save(null,false,'put')}, "iconCls": "x-tbar-save", "overflowText": "Speichern", "auto_save": false }, { "itemId": "update_reminders", "menu_item_text": "Erinnerungen aktualisieren", "must_save": true, "panel_btn_handler": Lino.row_action_handler('update_reminders','GET'), "text": "Erinnerungen aktualisieren", "overflowText": "Erinnerungen aktualisieren", "auto_save": true } ],
  ls_url: "/users/MySettings",
  initComponent : function() {
    this.ls_detail_handler = Lino.users.MySettings.detail;
    this.ls_insert_handler = Lino.users.Users.insert;
    Lino.users.MySettings.detailPanel.superclass.initComponent.call(this);
  }
});

Lino.users.MySettings.detail = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.users.MySettings.detailPanel(p);
});

// js_render_GridPanel_class changes.Changes
Lino.changes.Changes.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "emptyText": "Keine Daten anzuzeigen." },
  ls_url : "/changes/Changes",
  ls_bbar_actions : [ { "itemId": "detail", "menu_item_text": "Detail", "tooltip": "Detail-Fenster auf diesem Datensatz \u00f6ffnen", "panel_btn_handler": Lino.show_detail, "iconCls": "x-tbar-detail", "overflowText": "Detail", "auto_save": true } ],
  title : "\u00c4nderungen",
  page_length : 20,
  stripeRows : true,
  disable_editing : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "type": "int", "name": "id" }, { "name": "time" }, { "name": "type" }, 'typeHidden', { "name": "user" }, 'userHidden', { "name": "object_type" }, 'object_typeHidden', { "name": "object_id" }, 'object_idHidden', { "name": "master_type" }, 'master_typeHidden', { "name": "master_id" }, 'master_idHidden', { "name": "diff" }, { "name": "object" }, { "name": "master" }, { "name": "disabled_fields" }, { "name": "disabled_actions" } ],
  pk_index : 0,
  ls_grid_configs : [  ],
  content_type : 10,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 18,
  initComponent : function() {
    this.ls_detail_handler = Lino.changes.Changes.detail;
    var ww = this.containing_window;
    var id2321 = new Ext.form.NumberField({ "selectOnFocus": true });
    var time2322 = new Ext.form.DisplayField({ "selectOnFocus": true, "allowBlank": false, "value": "<br>" });
    var type2323 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "forceSelection": true, "allowBlank": false, "store": Lino.lino.ChangeTypes });
    var user2324 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/changes/Changes/user", "method": "GET" }) }), "allowBlank": false, "pageSize": 20, "emptyText": "Benutzer ausw\u00e4hlen..." });
    var object_type2325 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/changes/Changes/object_type", "method": "GET" }) }), "allowBlank": false, "pageSize": 20, "emptyText": "Inhaltstyp ausw\u00e4hlen..." });
    var object_id2326 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "allowBlank": false, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/changes/Changes/object_id", "method": "GET" }) }) });
    var master_type2327 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/changes/Changes/master_type", "method": "GET" }) }), "allowBlank": false, "pageSize": 20, "emptyText": "Inhaltstyp ausw\u00e4hlen..." });
    var master_id2328 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "allowBlank": false, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/changes/Changes/master_id", "method": "GET" }) }) });
    var diff2329 = new Ext.form.TextArea({ "selectOnFocus": true, "growMax": 2000 });
    var object_disp2330 = new Ext.form.DisplayField({ "disabled": true });
    var master_disp2331 = new Ext.form.DisplayField({ "disabled": true });
    this.before_row_edit = function(record) {
      object_id2326.setContextValue('object_type',record ? record.data['object_typeHidden'] : undefined);
      master_id2328.setContextValue('master_type',record ? record.data['master_typeHidden'] : undefined);
    };
    this.onRender = function(ct, position) {
      object_type2325.on('change',Lino.chooser_handler(object_id2326,'object_type'));
      master_type2327.on('change',Lino.chooser_handler(master_id2328,'master_type'));
      Lino.changes.Changes.GridPanel.superclass.onRender.call(this, ct, position);
    }
    this.ls_columns = [ new Lino.NullNumberColumn({ "colIndex": 0, "sortable": true, "format": "0", "editable": true, "filter": { "type": "numeric" }, "header": "ID", "renderer": Lino.id_renderer, "editor": id2321, "width": Lino.chars2width(6), "dataIndex": "id" }), { "width": Lino.chars2width(17), "colIndex": 1, "sortable": true, "dataIndex": "time", "header": "time", "editable": true, "editor": time2322 }, { "colIndex": 2, "sortable": true, "header": "\u00c4nderungsart", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(18), "dataIndex": "type", "editor": type2323 }, { "colIndex": 3, "sortable": true, "header": "Benutzer", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(16), "dataIndex": "user", "editor": user2324 }, { "colIndex": 4, "sortable": true, "header": "Object type", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('object_typeHidden','Lino.ui.ContentTypes.detail'), "editor": object_type2325, "dataIndex": "object_type" }, { "colIndex": 5, "sortable": true, "header": "object id", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(11), "dataIndex": "object_id", "editor": object_id2326 }, { "colIndex": 6, "sortable": true, "header": "Master type", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('master_typeHidden','Lino.ui.ContentTypes.detail'), "editor": master_type2327, "dataIndex": "master_type" }, { "colIndex": 7, "sortable": true, "header": "master id", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(11), "dataIndex": "master_id", "editor": master_id2328 }, { "colIndex": 8, "sortable": false, "header": "\u00c4nderungen", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(61), "renderer": Lino.text_renderer, "editor": diff2329, "dataIndex": "diff" }, { "width": Lino.chars2width(11), "colIndex": 9, "sortable": false, "dataIndex": "object", "header": "Object", "editable": false }, { "width": Lino.chars2width(11), "colIndex": 10, "sortable": false, "dataIndex": "master", "header": "Stammdaten", "editable": false } ];
    Lino.changes.Changes.GridPanel.superclass.initComponent.call(this);
  }
});


Lino.changes.Changes.detailPanel = Ext.extend(Lino.changes.Changes.DetailFormPanel,{
  empty_title: "Detail \u00c4nderungen",
  ls_bbar_actions: [  ],
  ls_url: "/changes/Changes",
  action_name: "detail",
  initComponent : function() {
    this.ls_detail_handler = Lino.changes.Changes.detail;
    Lino.changes.Changes.detailPanel.superclass.initComponent.call(this);
  }
});

Lino.changes.Changes.detail = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.changes.Changes.detailPanel(p);
});
Lino.changes.Changes.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.changes.Changes.GridPanel(p);
});

// js_render_GridPanel_class countries.Languages
Lino.countries.Languages.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "Keine Daten anzuzeigen." },
  ls_url : "/countries/Languages",
  ls_bbar_actions : [ { "itemId": "insert", "menu_item_text": "Neu", "must_save": true, "tooltip": "Neuen Datensatz erstellen", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-new", "overflowText": "Neu", "auto_save": true }, { "itemId": "detail", "menu_item_text": "Detail", "tooltip": "Detail-Fenster auf diesem Datensatz \u00f6ffnen", "panel_btn_handler": Lino.show_detail, "iconCls": "x-tbar-detail", "overflowText": "Detail", "auto_save": true }, { "itemId": null, "menu_item_text": "L\u00f6schen", "tooltip": "Diesen Datensatz l\u00f6schen", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "L\u00f6schen", "auto_save": false } ],
  title : "Sprachen",
  page_length : 20,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "name": "name" }, { "name": "name_fr" }, { "name": "name_nl" }, { "name": "id" }, { "name": "iso2" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 3,
  ls_grid_configs : [  ],
  content_type : 12,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 6,
  initComponent : function() {
    this.ls_detail_handler = Lino.countries.Languages.detail;
    this.ls_insert_handler = Lino.countries.Languages.insert;
    var ww = this.containing_window;
    var name2333 = new Ext.form.TextField({ "selectOnFocus": true, "allowBlank": false, "maxLength": 200 });
    var name_fr2334 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var name_nl2335 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var id2336 = new Ext.form.TextField({ "selectOnFocus": true, "boxMinWidth": Lino.chars2width(3), "allowBlank": false, "maxLength": 3 });
    var iso22337 = new Ext.form.TextField({ "selectOnFocus": true, "boxMinWidth": Lino.chars2width(2), "maxLength": 2 });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ { "colIndex": 0, "sortable": true, "header": "Bezeichnung", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "name", "editor": name2333 }, { "colIndex": 1, "sortable": true, "header": "Bezeichnung (fr)", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "name_fr", "editor": name_fr2334 }, { "colIndex": 2, "sortable": true, "header": "Bezeichnung (nl)", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "name_nl", "editor": name_nl2335 }, { "colIndex": 3, "sortable": true, "header": "id", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(5), "dataIndex": "id", "editor": id2336 }, { "colIndex": 4, "sortable": true, "header": "iso2", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(5), "dataIndex": "iso2", "editor": iso22337 } ];
    Lino.countries.Languages.GridPanel.superclass.initComponent.call(this);
  }
});


Lino.countries.Languages.insertPanel = Ext.extend(Lino.countries.Languages.DetailFormPanel,{
  empty_title: "Neu Sprachen",
  hide_navigator: true,
  ls_bbar_actions: [ { "itemId": "post", "menu_item_text": "Erstellen", "tooltip": "Datensatz erstellen und dann im Detail-Fenster \u00f6ffnen", "panel_btn_handler": function(panel){panel.save(null,true,'post')}, "text": "Erstellen", "overflowText": "Erstellen", "auto_save": false }, { "itemId": "poststay", "menu_item_text": "Erstellen ohne Detail", "tooltip": "Nach Erstellen des Datensatzes kein Detail-Fenster \u00f6ffnen", "panel_btn_handler": function(panel){panel.save(null,false,'poststay')}, "text": "Erstellen ohne Detail", "overflowText": "Erstellen ohne Detail", "auto_save": false } ],
  ls_url: "/countries/Languages",
  action_name: "insert",
  initComponent : function() {
    this.ls_detail_handler = Lino.countries.Languages.detail;
    this.ls_insert_handler = Lino.countries.Languages.insert;
    Lino.countries.Languages.insertPanel.superclass.initComponent.call(this);
  }
});

Lino.countries.Languages.insert = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.countries.Languages.insertPanel(p);
});

Lino.countries.Languages.detailPanel = Ext.extend(Lino.countries.Languages.DetailFormPanel,{
  empty_title: "Detail Sprachen",
  ls_bbar_actions: [ { "itemId": "put", "menu_item_text": "Speichern", "tooltip": "\u00c4nderungen in diesem Formular speichern", "panel_btn_handler": function(panel){panel.save(null,false,'put')}, "iconCls": "x-tbar-save", "overflowText": "Speichern", "auto_save": false }, { "itemId": "insert", "menu_item_text": "Neu", "must_save": true, "tooltip": "Neuen Datensatz erstellen", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-new", "overflowText": "Neu", "auto_save": true }, { "itemId": null, "menu_item_text": "L\u00f6schen", "tooltip": "Diesen Datensatz l\u00f6schen", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "L\u00f6schen", "auto_save": false } ],
  ls_url: "/countries/Languages",
  action_name: "detail",
  initComponent : function() {
    this.ls_detail_handler = Lino.countries.Languages.detail;
    this.ls_insert_handler = Lino.countries.Languages.insert;
    Lino.countries.Languages.detailPanel.superclass.initComponent.call(this);
  }
});

Lino.countries.Languages.detail = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.countries.Languages.detailPanel(p);
});
Lino.countries.Languages.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.countries.Languages.GridPanel(p);
});

// js_render_GridPanel_class countries.Countries
Lino.countries.Countries.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "Keine Daten anzuzeigen." },
  ls_url : "/countries/Countries",
  ls_bbar_actions : [ { "itemId": "insert", "menu_item_text": "Neu", "must_save": true, "tooltip": "Neuen Datensatz erstellen", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-new", "overflowText": "Neu", "auto_save": true }, { "itemId": "detail", "menu_item_text": "Detail", "tooltip": "Detail-Fenster auf diesem Datensatz \u00f6ffnen", "panel_btn_handler": Lino.show_detail, "iconCls": "x-tbar-detail", "overflowText": "Detail", "auto_save": true }, { "itemId": null, "menu_item_text": "L\u00f6schen", "tooltip": "Diesen Datensatz l\u00f6schen", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "L\u00f6schen", "auto_save": false } ],
  title : "L\u00e4nder",
  page_length : 20,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "name": "name" }, { "name": "name_fr" }, { "name": "name_nl" }, { "name": "isocode" }, { "name": "short_code" }, { "name": "iso3" }, { "name": "inscode" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 3,
  ls_grid_configs : [  ],
  content_type : 11,
  ls_id_property : "isocode",
  gc_name : 0,
  disabled_actions_index : 8,
  initComponent : function() {
    this.ls_detail_handler = Lino.countries.Countries.detail;
    this.ls_insert_handler = Lino.countries.Countries.insert;
    var ww = this.containing_window;
    var name2339 = new Ext.form.TextField({ "selectOnFocus": true, "allowBlank": false, "maxLength": 200 });
    var name_fr2340 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var name_nl2341 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var isocode2342 = new Ext.form.TextField({ "selectOnFocus": true, "boxMinWidth": Lino.chars2width(4), "allowBlank": false, "maxLength": 4 });
    var short_code2343 = new Ext.form.TextField({ "selectOnFocus": true, "boxMinWidth": Lino.chars2width(4), "maxLength": 4 });
    var iso32344 = new Ext.form.TextField({ "selectOnFocus": true, "boxMinWidth": Lino.chars2width(3), "maxLength": 3 });
    var inscode2345 = new Ext.form.TextField({ "selectOnFocus": true, "boxMinWidth": Lino.chars2width(3), "maxLength": 3 });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ { "colIndex": 0, "sortable": true, "header": "Bezeichnung", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "name", "editor": name2339 }, { "colIndex": 1, "sortable": true, "header": "Bezeichnung (fr)", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "name_fr", "editor": name_fr2340 }, { "colIndex": 2, "sortable": true, "header": "Bezeichnung (nl)", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "name_nl", "editor": name_nl2341 }, { "colIndex": 3, "sortable": true, "header": "ISO-Code", "editable": true, "tooltip": "        The two-letter code for this country as defined by ISO 3166-1. \n        For countries that no longer exist it may be a 4-letter code.", "filter": { "type": "string" }, "width": Lino.chars2width(6), "dataIndex": "isocode", "editor": isocode2342 }, { "colIndex": 4, "sortable": true, "header": "Short code", "editable": true, "tooltip": "A short abbreviation for regional usage. Obsolete.", "filter": { "type": "string" }, "width": Lino.chars2width(6), "dataIndex": "short_code", "editor": short_code2343 }, { "colIndex": 5, "sortable": true, "header": "ISO3-Code", "editable": true, "tooltip": "The three-letter code for this country as defined by ISO 3166-1.", "filter": { "type": "string" }, "width": Lino.chars2width(5), "dataIndex": "iso3", "editor": iso32344 }, { "colIndex": 6, "sortable": true, "header": "INS-Code", "editable": true, "tooltip": "The official code for this country used by statbel.fgov.be", "filter": { "type": "string" }, "width": Lino.chars2width(5), "dataIndex": "inscode", "editor": inscode2345 } ];
    Lino.countries.Countries.GridPanel.superclass.initComponent.call(this);
  }
});


Lino.countries.Countries.insertPanel = Ext.extend(Lino.countries.Countries.DetailFormPanel,{
  empty_title: "Neu L\u00e4nder",
  hide_navigator: true,
  ls_bbar_actions: [ { "itemId": "post", "menu_item_text": "Erstellen", "tooltip": "Datensatz erstellen und dann im Detail-Fenster \u00f6ffnen", "panel_btn_handler": function(panel){panel.save(null,true,'post')}, "text": "Erstellen", "overflowText": "Erstellen", "auto_save": false }, { "itemId": "poststay", "menu_item_text": "Erstellen ohne Detail", "tooltip": "Nach Erstellen des Datensatzes kein Detail-Fenster \u00f6ffnen", "panel_btn_handler": function(panel){panel.save(null,false,'poststay')}, "text": "Erstellen ohne Detail", "overflowText": "Erstellen ohne Detail", "auto_save": false } ],
  ls_url: "/countries/Countries",
  action_name: "insert",
  initComponent : function() {
    this.ls_detail_handler = Lino.countries.Countries.detail;
    this.ls_insert_handler = Lino.countries.Countries.insert;
    Lino.countries.Countries.insertPanel.superclass.initComponent.call(this);
  }
});

Lino.countries.Countries.insert = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.countries.Countries.insertPanel(p);
});

Lino.countries.Countries.detailPanel = Ext.extend(Lino.countries.Countries.DetailFormPanel,{
  empty_title: "Detail L\u00e4nder",
  ls_bbar_actions: [ { "itemId": "put", "menu_item_text": "Speichern", "tooltip": "\u00c4nderungen in diesem Formular speichern", "panel_btn_handler": function(panel){panel.save(null,false,'put')}, "iconCls": "x-tbar-save", "overflowText": "Speichern", "auto_save": false }, { "itemId": "insert", "menu_item_text": "Neu", "must_save": true, "tooltip": "Neuen Datensatz erstellen", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-new", "overflowText": "Neu", "auto_save": true }, { "itemId": null, "menu_item_text": "L\u00f6schen", "tooltip": "Diesen Datensatz l\u00f6schen", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "L\u00f6schen", "auto_save": false } ],
  ls_url: "/countries/Countries",
  action_name: "detail",
  initComponent : function() {
    this.ls_detail_handler = Lino.countries.Countries.detail;
    this.ls_insert_handler = Lino.countries.Countries.insert;
    Lino.countries.Countries.detailPanel.superclass.initComponent.call(this);
  }
});

Lino.countries.Countries.detail = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.countries.Countries.detailPanel(p);
});
Lino.countries.Countries.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.countries.Countries.GridPanel(p);
});

// js_render_GridPanel_class properties.PropChoices
Lino.properties.PropChoices.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "Keine Daten anzuzeigen." },
  ls_url : "/properties/PropChoices",
  ls_bbar_actions : [ { "itemId": null, "menu_item_text": "L\u00f6schen", "tooltip": "Diesen Datensatz l\u00f6schen", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "L\u00f6schen", "auto_save": false } ],
  title : "Auswahlm\u00f6glichkeiten",
  page_length : 20,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "type": "int", "name": "id" }, { "name": "type" }, 'typeHidden', { "name": "value" }, { "name": "text" }, { "name": "text_fr" }, { "name": "text_nl" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 0,
  ls_grid_configs : [  ],
  content_type : 17,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 8,
  initComponent : function() {
    var ww = this.containing_window;
    var id2347 = new Ext.form.NumberField({ "selectOnFocus": true });
    var type2348 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/properties/PropChoices/type", "method": "GET" }) }), "allowBlank": false, "pageSize": 20, "emptyText": "Eigenschafts-Datentyp ausw\u00e4hlen..." });
    var value2349 = new Ext.form.TextField({ "selectOnFocus": true, "allowBlank": false, "maxLength": 200 });
    var text2350 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var text_fr2351 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var text_nl2352 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ new Lino.NullNumberColumn({ "colIndex": 0, "sortable": true, "format": "0", "editable": true, "filter": { "type": "numeric" }, "header": "ID", "renderer": Lino.id_renderer, "editor": id2347, "width": Lino.chars2width(6), "dataIndex": "id" }), { "colIndex": 1, "sortable": true, "header": "Eigenschafts-Datentyp", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "type", "editor": type2348 }, { "colIndex": 2, "sortable": true, "header": "Wert", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "value", "editor": value2349 }, { "colIndex": 3, "sortable": true, "header": "Bezeichnung", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "text", "editor": text2350 }, { "colIndex": 4, "sortable": true, "header": "Bezeichnung (fr)", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "text_fr", "editor": text_fr2351 }, { "colIndex": 5, "sortable": true, "header": "Bezeichnung (nl)", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "text_nl", "editor": text_nl2352 } ];
    Lino.properties.PropChoices.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.properties.PropChoices.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.properties.PropChoices.GridPanel(p);
});

// js_render_GridPanel_class contacts.Partners
Lino.contacts.Partners.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "Keine Daten anzuzeigen." },
  ls_url : "/contacts/Partners",
  ls_bbar_actions : [ { "itemId": "insert", "menu_item_text": "Neu", "must_save": true, "tooltip": "Neuen Datensatz erstellen", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-new", "overflowText": "Neu", "auto_save": true }, { "itemId": "detail", "menu_item_text": "Detail", "tooltip": "Detail-Fenster auf diesem Datensatz \u00f6ffnen", "panel_btn_handler": Lino.show_detail, "iconCls": "x-tbar-detail", "overflowText": "Detail", "auto_save": true }, { "itemId": null, "menu_item_text": "L\u00f6schen", "tooltip": "Diesen Datensatz l\u00f6schen", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "L\u00f6schen", "auto_save": false } ],
  title : "Partner",
  page_length : 20,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "name": "name" }, { "name": "email" }, { "name": "created" }, { "name": "modified" }, { "name": "country" }, 'countryHidden', { "name": "city" }, 'cityHidden', { "name": "region" }, 'regionHidden', { "name": "zip_code" }, { "name": "addr1" }, { "name": "street_prefix" }, { "name": "street" }, { "name": "street_no" }, { "name": "street_box" }, { "name": "addr2" }, { "name": "language" }, 'languageHidden', { "name": "url" }, { "name": "phone" }, { "name": "gsm" }, { "name": "fax" }, { "name": "remarks" }, { "type": "boolean", "name": "is_obsolete" }, { "name": "activity" }, 'activityHidden', { "name": "bank_account1" }, { "name": "bank_account2" }, { "type": "int", "name": "id" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 29,
  ls_grid_configs : [  ],
  content_type : 23,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 31,
  initComponent : function() {
    this.ls_detail_handler = Lino.contacts.Partners.detail;
    this.ls_insert_handler = Lino.contacts.Partners.insert;
    var ww = this.containing_window;
    var name2354 = new Ext.form.TextField({ "selectOnFocus": true, "allowBlank": false, "maxLength": 200 });
    var email2355 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 75 });
    var created2356 = new Ext.form.DisplayField({ "disabled": true, "value": "<br>" });
    var modified2357 = new Ext.form.DisplayField({ "disabled": true, "value": "<br>" });
    var country2358 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/contacts/Partners/country", "method": "GET" }) }), "pageSize": 20, "emptyText": "Land ausw\u00e4hlen..." });
    var city2359 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "forceSelection": false, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/contacts/Partners/city", "method": "GET" }) }), "pageSize": 20, "emptyText": "Ort ausw\u00e4hlen..." });
    var region2360 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/contacts/Partners/region", "method": "GET" }) }), "pageSize": 20, "emptyText": "Ort ausw\u00e4hlen..." });
    var zip_code2361 = new Ext.form.TextField({ "selectOnFocus": true, "boxMinWidth": Lino.chars2width(10), "maxLength": 10 });
    var addr12362 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var street_prefix2363 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var street2364 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var street_no2365 = new Ext.form.TextField({ "selectOnFocus": true, "boxMinWidth": Lino.chars2width(10), "maxLength": 10 });
    var street_box2366 = new Ext.form.TextField({ "selectOnFocus": true, "boxMinWidth": Lino.chars2width(10), "maxLength": 10 });
    var addr22367 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var language2368 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "store": [ [ "de", "Deutsch" ], [ "fr", "Franz\u00f6sisch" ], [ "nl", "Niederl\u00e4ndisch" ] ], "allowBlank": false, "value": "de" });
    var url2369 = new Lino.URLField({ "selectOnFocus": true, "maxLength": 200 });
    var phone2370 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var gsm2371 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var fax2372 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var remarks2373 = new Ext.form.TextArea({ "selectOnFocus": true, "growMax": 2000 });
    var is_obsolete2374 = new Ext.form.Checkbox({ "selectOnFocus": true, "checked": false });
    var activity2375 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/contacts/Partners/activity", "method": "GET" }) }), "pageSize": 20, "emptyText": "Beruf ausw\u00e4hlen..." });
    var bank_account12376 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 40 });
    var bank_account22377 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 40 });
    var id2378 = new Ext.form.NumberField({ "selectOnFocus": true });
    this.before_row_edit = function(record) {
      city2359.setContextValue('country',record ? record.data['countryHidden'] : undefined);
      city2359.setContextValue('region',record ? record.data['regionHidden'] : undefined);
      region2360.setContextValue('country',record ? record.data['countryHidden'] : undefined);
    };
    this.onRender = function(ct, position) {
      country2358.on('change',Lino.chooser_handler(city2359,'country'));
      region2360.on('change',Lino.chooser_handler(city2359,'region'));
      country2358.on('change',Lino.chooser_handler(region2360,'country'));
      Lino.contacts.Partners.GridPanel.superclass.onRender.call(this, ct, position);
    }
    this.ls_columns = [ { "colIndex": 0, "sortable": true, "header": "Name", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "name", "editor": name2354 }, { "colIndex": 1, "sortable": true, "header": "E-Mail", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "email", "editor": email2355 }, { "width": Lino.chars2width(17), "colIndex": 2, "sortable": true, "dataIndex": "created", "header": "Erstellt", "hidden": true, "editable": false }, { "width": Lino.chars2width(17), "colIndex": 3, "sortable": true, "dataIndex": "modified", "header": "Bearbeitet", "hidden": true, "editable": false }, { "colIndex": 4, "sortable": true, "header": "Land", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('countryHidden','Lino.countries.Countries.detail'), "editor": country2358, "dataIndex": "country" }, { "colIndex": 5, "sortable": true, "header": "Ort", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "city", "editor": city2359 }, { "colIndex": 6, "sortable": true, "header": "Region", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "region", "editor": region2360 }, { "colIndex": 7, "sortable": true, "header": "Postleitzahl", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(12), "dataIndex": "zip_code", "editor": zip_code2361 }, { "colIndex": 8, "sortable": true, "header": "Adresszeile vor Stra\u00dfe", "editable": true, "tooltip": "Address line before street", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "addr1", "editor": addr12362 }, { "colIndex": 9, "sortable": true, "header": "Pr\u00e4fix Stra\u00dfe", "editable": true, "tooltip": "Text to print before name of street, but to ignore for sorting.", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "street_prefix", "editor": street_prefix2363 }, { "colIndex": 10, "sortable": true, "header": "Stra\u00dfe", "editable": true, "tooltip": "Name of street. Without house number.", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "street", "editor": street2364 }, { "colIndex": 11, "sortable": true, "header": "Nr.", "editable": true, "tooltip": "House number", "filter": { "type": "string" }, "width": Lino.chars2width(12), "dataIndex": "street_no", "editor": street_no2365 }, { "colIndex": 12, "sortable": true, "header": "Box", "editable": true, "tooltip": "Text to print after :attr:`steet_no` on the same line", "filter": { "type": "string" }, "width": Lino.chars2width(12), "dataIndex": "street_box", "editor": street_box2366 }, { "colIndex": 13, "sortable": true, "header": "Adresszeile nach Stra\u00dfe", "editable": true, "tooltip": "Address line to print below street line", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "addr2", "editor": addr22367 }, { "colIndex": 14, "sortable": true, "header": "Sprache", "editable": true, "tooltip": "Die Sprache, in der Dokumente ausgestellt werden sollen.", "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "language", "editor": language2368 }, { "colIndex": 15, "sortable": true, "header": "URL", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "url", "editor": url2369 }, { "colIndex": 16, "sortable": true, "header": "Telefon", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "phone", "editor": phone2370 }, { "colIndex": 17, "sortable": true, "header": "GSM", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "gsm", "editor": gsm2371 }, { "colIndex": 18, "sortable": true, "header": "Fax", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "fax", "editor": fax2372 }, { "colIndex": 19, "sortable": false, "header": "Bemerkungen", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(61), "renderer": Lino.text_renderer, "editor": remarks2373, "dataIndex": "remarks" }, { "colIndex": 20, "sortable": false, "xtype": "checkcolumn", "header": "veraltet", "editable": true, "tooltip": "Altf\u00e4lle sind Partner, deren Stammdaten nicht mehr gepflegt werden und \nf\u00fcr neue Operationen nicht benutzt werden k\u00f6nnen.", "filter": { "type": "boolean" }, "width": Lino.chars2width(11), "dataIndex": "is_obsolete" }, { "colIndex": 21, "sortable": true, "header": "Beruf", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "activity", "hidden": true, "editor": activity2375 }, { "colIndex": 22, "sortable": true, "header": "Bankkonto 1", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "bank_account1", "hidden": true, "editor": bank_account12376 }, { "colIndex": 23, "sortable": true, "header": "Bankkonto 2", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "bank_account2", "hidden": true, "editor": bank_account22377 }, new Lino.NullNumberColumn({ "colIndex": 24, "sortable": true, "format": "0", "editable": true, "filter": { "type": "numeric" }, "header": "ID", "renderer": Lino.id_renderer, "editor": id2378, "width": Lino.chars2width(6), "dataIndex": "id" }) ];
    Lino.contacts.Partners.GridPanel.superclass.initComponent.call(this);
  }
});


Lino.contacts.Partners.insertPanel = Ext.extend(Lino.contacts.Partners.InsertFormPanel,{
  empty_title: "Neu Partner",
  hide_navigator: true,
  ls_bbar_actions: [ { "itemId": "post", "menu_item_text": "Erstellen", "tooltip": "Datensatz erstellen und dann im Detail-Fenster \u00f6ffnen", "panel_btn_handler": function(panel){panel.save(null,true,'post')}, "text": "Erstellen", "overflowText": "Erstellen", "auto_save": false }, { "itemId": "poststay", "menu_item_text": "Erstellen ohne Detail", "tooltip": "Nach Erstellen des Datensatzes kein Detail-Fenster \u00f6ffnen", "panel_btn_handler": function(panel){panel.save(null,false,'poststay')}, "text": "Erstellen ohne Detail", "overflowText": "Erstellen ohne Detail", "auto_save": false } ],
  ls_url: "/contacts/Partners",
  action_name: "insert",
  initComponent : function() {
    this.ls_detail_handler = Lino.contacts.Partners.detail;
    this.ls_insert_handler = Lino.contacts.Partners.insert;
    Lino.contacts.Partners.insertPanel.superclass.initComponent.call(this);
  }
});

Lino.contacts.Partners.insert = new Lino.WindowAction({ "draggable": true, "width": Lino.chars2width(40), "autoHeight": true, "maximizable": true, "modal": true, "maximized": false },function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.contacts.Partners.insertPanel(p);
});

Lino.contacts.Partners.detailPanel = Ext.extend(Lino.contacts.Partners.DetailFormPanel,{
  empty_title: "Detail Partner",
  ls_bbar_actions: [ { "itemId": "put", "menu_item_text": "Speichern", "tooltip": "\u00c4nderungen in diesem Formular speichern", "panel_btn_handler": function(panel){panel.save(null,false,'put')}, "iconCls": "x-tbar-save", "overflowText": "Speichern", "auto_save": false }, { "itemId": "insert", "menu_item_text": "Neu", "must_save": true, "tooltip": "Neuen Datensatz erstellen", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-new", "overflowText": "Neu", "auto_save": true }, { "itemId": null, "menu_item_text": "L\u00f6schen", "tooltip": "Diesen Datensatz l\u00f6schen", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "L\u00f6schen", "auto_save": false } ],
  ls_url: "/contacts/Partners",
  action_name: "detail",
  initComponent : function() {
    this.ls_detail_handler = Lino.contacts.Partners.detail;
    this.ls_insert_handler = Lino.contacts.Partners.insert;
    Lino.contacts.Partners.detailPanel.superclass.initComponent.call(this);
  }
});

Lino.contacts.Partners.detail = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.contacts.Partners.detailPanel(p);
});
Lino.contacts.Partners.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.contacts.Partners.GridPanel(p);
});

// js_render_GridPanel_class contacts.Companies
Lino.contacts.Companies.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "Keine Daten anzuzeigen." },
  ls_url : "/contacts/Companies",
  ls_bbar_actions : [ { "itemId": "insert", "menu_item_text": "Neu", "must_save": true, "tooltip": "Neuen Datensatz erstellen", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-new", "overflowText": "Neu", "auto_save": true }, { "itemId": "detail", "menu_item_text": "Detail", "tooltip": "Detail-Fenster auf diesem Datensatz \u00f6ffnen", "panel_btn_handler": Lino.show_detail, "iconCls": "x-tbar-detail", "overflowText": "Detail", "auto_save": true }, { "itemId": null, "menu_item_text": "L\u00f6schen", "tooltip": "Diesen Datensatz l\u00f6schen", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "L\u00f6schen", "auto_save": false } ],
  title : "Organisationen",
  page_length : 20,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "name": "name" }, { "name": "email" }, { "name": "created" }, { "name": "modified" }, { "name": "country" }, 'countryHidden', { "name": "city" }, 'cityHidden', { "name": "region" }, 'regionHidden', { "name": "zip_code" }, { "name": "addr1" }, { "name": "street_prefix" }, { "name": "street" }, { "name": "street_no" }, { "name": "street_box" }, { "name": "addr2" }, { "name": "language" }, 'languageHidden', { "name": "url" }, { "name": "phone" }, { "name": "gsm" }, { "name": "fax" }, { "name": "remarks" }, { "type": "boolean", "name": "is_obsolete" }, { "name": "activity" }, 'activityHidden', { "name": "bank_account1" }, { "name": "bank_account2" }, { "name": "prefix" }, { "name": "vat_id" }, { "name": "type" }, 'typeHidden', { "name": "client_contact_type" }, 'client_contact_typeHidden', { "type": "int", "name": "id" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 35,
  ls_grid_configs : [  ],
  content_type : 20,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 37,
  initComponent : function() {
    this.ls_detail_handler = Lino.contacts.Companies.detail;
    this.ls_insert_handler = Lino.contacts.Companies.insert;
    var ww = this.containing_window;
    var name2380 = new Ext.form.TextField({ "selectOnFocus": true, "allowBlank": false, "maxLength": 200 });
    var email2381 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 75 });
    var created2382 = new Ext.form.DisplayField({ "disabled": true, "value": "<br>" });
    var modified2383 = new Ext.form.DisplayField({ "disabled": true, "value": "<br>" });
    var country2384 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/contacts/Companies/country", "method": "GET" }) }), "pageSize": 20, "emptyText": "Land ausw\u00e4hlen..." });
    var city2385 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "forceSelection": false, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/contacts/Companies/city", "method": "GET" }) }), "pageSize": 20, "emptyText": "Ort ausw\u00e4hlen..." });
    var region2386 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/contacts/Companies/region", "method": "GET" }) }), "pageSize": 20, "emptyText": "Ort ausw\u00e4hlen..." });
    var zip_code2387 = new Ext.form.TextField({ "selectOnFocus": true, "boxMinWidth": Lino.chars2width(10), "maxLength": 10 });
    var addr12388 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var street_prefix2389 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var street2390 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var street_no2391 = new Ext.form.TextField({ "selectOnFocus": true, "boxMinWidth": Lino.chars2width(10), "maxLength": 10 });
    var street_box2392 = new Ext.form.TextField({ "selectOnFocus": true, "boxMinWidth": Lino.chars2width(10), "maxLength": 10 });
    var addr22393 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var language2394 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "store": [ [ "de", "Deutsch" ], [ "fr", "Franz\u00f6sisch" ], [ "nl", "Niederl\u00e4ndisch" ] ], "allowBlank": false, "value": "de" });
    var url2395 = new Lino.URLField({ "selectOnFocus": true, "maxLength": 200 });
    var phone2396 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var gsm2397 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var fax2398 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var remarks2399 = new Ext.form.TextArea({ "selectOnFocus": true, "growMax": 2000 });
    var is_obsolete2400 = new Ext.form.Checkbox({ "selectOnFocus": true, "checked": false });
    var activity2401 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/contacts/Companies/activity", "method": "GET" }) }), "pageSize": 20, "emptyText": "Beruf ausw\u00e4hlen..." });
    var bank_account12402 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 40 });
    var bank_account22403 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 40 });
    var prefix2404 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var vat_id2405 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var type2406 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/contacts/Companies/type", "method": "GET" }) }), "pageSize": 20, "emptyText": "Organisationsart ausw\u00e4hlen..." });
    var client_contact_type2407 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/contacts/Companies/client_contact_type", "method": "GET" }) }), "pageSize": 20, "emptyText": "Klientenkontaktart ausw\u00e4hlen..." });
    var id2408 = new Ext.form.NumberField({ "selectOnFocus": true });
    this.before_row_edit = function(record) {
      city2385.setContextValue('country',record ? record.data['countryHidden'] : undefined);
      city2385.setContextValue('region',record ? record.data['regionHidden'] : undefined);
      region2386.setContextValue('country',record ? record.data['countryHidden'] : undefined);
    };
    this.onRender = function(ct, position) {
      country2384.on('change',Lino.chooser_handler(city2385,'country'));
      region2386.on('change',Lino.chooser_handler(city2385,'region'));
      country2384.on('change',Lino.chooser_handler(region2386,'country'));
      Lino.contacts.Companies.GridPanel.superclass.onRender.call(this, ct, position);
    }
    this.ls_columns = [ { "colIndex": 0, "sortable": true, "header": "Name", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "name", "editor": name2380 }, { "colIndex": 1, "sortable": true, "header": "E-Mail", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "email", "editor": email2381 }, { "width": Lino.chars2width(17), "colIndex": 2, "sortable": true, "dataIndex": "created", "header": "Erstellt", "hidden": true, "editable": false }, { "width": Lino.chars2width(17), "colIndex": 3, "sortable": true, "dataIndex": "modified", "header": "Bearbeitet", "hidden": true, "editable": false }, { "colIndex": 4, "sortable": true, "header": "Land", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('countryHidden','Lino.countries.Countries.detail'), "editor": country2384, "dataIndex": "country" }, { "colIndex": 5, "sortable": true, "header": "Ort", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "city", "editor": city2385 }, { "colIndex": 6, "sortable": true, "header": "Region", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "region", "editor": region2386 }, { "colIndex": 7, "sortable": true, "header": "Postleitzahl", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(12), "dataIndex": "zip_code", "editor": zip_code2387 }, { "colIndex": 8, "sortable": true, "header": "Adresszeile vor Stra\u00dfe", "editable": true, "tooltip": "Address line before street", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "addr1", "editor": addr12388 }, { "colIndex": 9, "sortable": true, "header": "Pr\u00e4fix Stra\u00dfe", "editable": true, "tooltip": "Text to print before name of street, but to ignore for sorting.", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "street_prefix", "editor": street_prefix2389 }, { "colIndex": 10, "sortable": true, "header": "Stra\u00dfe", "editable": true, "tooltip": "Name of street. Without house number.", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "street", "editor": street2390 }, { "colIndex": 11, "sortable": true, "header": "Nr.", "editable": true, "tooltip": "House number", "filter": { "type": "string" }, "width": Lino.chars2width(12), "dataIndex": "street_no", "editor": street_no2391 }, { "colIndex": 12, "sortable": true, "header": "Box", "editable": true, "tooltip": "Text to print after :attr:`steet_no` on the same line", "filter": { "type": "string" }, "width": Lino.chars2width(12), "dataIndex": "street_box", "editor": street_box2392 }, { "colIndex": 13, "sortable": true, "header": "Adresszeile nach Stra\u00dfe", "editable": true, "tooltip": "Address line to print below street line", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "addr2", "editor": addr22393 }, { "colIndex": 14, "sortable": true, "header": "Sprache", "editable": true, "tooltip": "Die Sprache, in der Dokumente ausgestellt werden sollen.", "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "language", "editor": language2394 }, { "colIndex": 15, "sortable": true, "header": "URL", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "url", "editor": url2395 }, { "colIndex": 16, "sortable": true, "header": "Telefon", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "phone", "editor": phone2396 }, { "colIndex": 17, "sortable": true, "header": "GSM", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "gsm", "editor": gsm2397 }, { "colIndex": 18, "sortable": true, "header": "Fax", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "fax", "editor": fax2398 }, { "colIndex": 19, "sortable": false, "header": "Bemerkungen", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(61), "renderer": Lino.text_renderer, "editor": remarks2399, "dataIndex": "remarks" }, { "colIndex": 20, "sortable": false, "xtype": "checkcolumn", "header": "veraltet", "editable": true, "tooltip": "Altf\u00e4lle sind Partner, deren Stammdaten nicht mehr gepflegt werden und \nf\u00fcr neue Operationen nicht benutzt werden k\u00f6nnen.", "filter": { "type": "boolean" }, "width": Lino.chars2width(11), "dataIndex": "is_obsolete" }, { "colIndex": 21, "sortable": true, "header": "Beruf", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "activity", "hidden": true, "editor": activity2401 }, { "colIndex": 22, "sortable": true, "header": "Bankkonto 1", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "bank_account1", "hidden": true, "editor": bank_account12402 }, { "colIndex": 23, "sortable": true, "header": "Bankkonto 2", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "bank_account2", "hidden": true, "editor": bank_account22403 }, { "colIndex": 24, "sortable": true, "header": "prefix", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "prefix", "editor": prefix2404 }, { "colIndex": 25, "sortable": true, "header": "MWSt.-Nr.", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "vat_id", "editor": vat_id2405 }, { "colIndex": 26, "sortable": true, "header": "Organisationsart", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "type", "editor": type2406 }, { "colIndex": 27, "sortable": true, "header": "Klientenkontaktart", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "client_contact_type", "editor": client_contact_type2407 }, new Lino.NullNumberColumn({ "colIndex": 28, "sortable": true, "format": "0", "editable": true, "filter": { "type": "numeric" }, "header": "ID", "renderer": Lino.id_renderer, "editor": id2408, "width": Lino.chars2width(6), "dataIndex": "id" }) ];
    Lino.contacts.Companies.GridPanel.superclass.initComponent.call(this);
  }
});


Lino.contacts.Companies.insertPanel = Ext.extend(Lino.contacts.Companies.InsertFormPanel,{
  empty_title: "Neu Organisationen",
  hide_navigator: true,
  ls_bbar_actions: [ { "itemId": "post", "menu_item_text": "Erstellen", "tooltip": "Datensatz erstellen und dann im Detail-Fenster \u00f6ffnen", "panel_btn_handler": function(panel){panel.save(null,true,'post')}, "text": "Erstellen", "overflowText": "Erstellen", "auto_save": false }, { "itemId": "poststay", "menu_item_text": "Erstellen ohne Detail", "tooltip": "Nach Erstellen des Datensatzes kein Detail-Fenster \u00f6ffnen", "panel_btn_handler": function(panel){panel.save(null,false,'poststay')}, "text": "Erstellen ohne Detail", "overflowText": "Erstellen ohne Detail", "auto_save": false } ],
  ls_url: "/contacts/Companies",
  action_name: "insert",
  initComponent : function() {
    this.ls_detail_handler = Lino.contacts.Companies.detail;
    this.ls_insert_handler = Lino.contacts.Companies.insert;
    Lino.contacts.Companies.insertPanel.superclass.initComponent.call(this);
  }
});

Lino.contacts.Companies.insert = new Lino.WindowAction({ "draggable": true, "width": Lino.chars2width(60), "autoHeight": true, "maximizable": true, "modal": true, "maximized": false },function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.contacts.Companies.insertPanel(p);
});

Lino.contacts.Companies.detailPanel = Ext.extend(Lino.contacts.Companies.DetailFormPanel,{
  empty_title: "Detail Organisationen",
  ls_bbar_actions: [ { "itemId": "put", "menu_item_text": "Speichern", "tooltip": "\u00c4nderungen in diesem Formular speichern", "panel_btn_handler": function(panel){panel.save(null,false,'put')}, "iconCls": "x-tbar-save", "overflowText": "Speichern", "auto_save": false }, { "itemId": "insert", "menu_item_text": "Neu", "must_save": true, "tooltip": "Neuen Datensatz erstellen", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-new", "overflowText": "Neu", "auto_save": true }, { "itemId": null, "menu_item_text": "L\u00f6schen", "tooltip": "Diesen Datensatz l\u00f6schen", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "L\u00f6schen", "auto_save": false } ],
  ls_url: "/contacts/Companies",
  action_name: "detail",
  initComponent : function() {
    this.ls_detail_handler = Lino.contacts.Companies.detail;
    this.ls_insert_handler = Lino.contacts.Companies.insert;
    Lino.contacts.Companies.detailPanel.superclass.initComponent.call(this);
  }
});

Lino.contacts.Companies.detail = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.contacts.Companies.detailPanel(p);
});
Lino.contacts.Companies.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.contacts.Companies.GridPanel(p);
});

// js_render_GridPanel_class postings.PostingsByState
Lino.postings.PostingsByState.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "Keine Daten anzuzeigen." },
  ls_url : "/postings/PostingsByState",
  ls_bbar_actions : [ { "itemId": null, "menu_item_text": "L\u00f6schen", "tooltip": "Diesen Datensatz l\u00f6schen", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "L\u00f6schen", "auto_save": false }, { "itemId": "print_action", "menu_item_text": "Drucken", "must_save": true, "tooltip": "Drucken", "panel_btn_handler": Lino.row_action_handler('print_action','GET'), "iconCls": "x-tbar-print", "overflowText": "Drucken", "auto_save": true } ],
  title : "Postsendungen",
  page_length : 20,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "type": "date", "name": "date", "dateFormat": "d.m.Y" }, { "name": "user" }, 'userHidden', { "name": "partner" }, 'partnerHidden', { "name": "workflow_buttons" }, { "type": "int", "name": "id" }, { "name": "owner_type" }, 'owner_typeHidden', { "name": "owner_id" }, 'owner_idHidden', { "name": "project" }, 'projectHidden', { "name": "state" }, 'stateHidden', { "name": "owner" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 6,
  ls_grid_configs : [  ],
  content_type : 38,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 17,
  initComponent : function() {
    var ww = this.containing_window;
    var date2410 = new Lino.DateField({ "selectOnFocus": true, "allowBlank": false });
    var user2411 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/postings/PostingsByState/user", "method": "GET" }) }), "pageSize": 20, "emptyText": "Benutzer ausw\u00e4hlen..." });
    var partner2412 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/postings/PostingsByState/partner", "method": "GET" }) }), "pageSize": 20, "emptyText": "Partner ausw\u00e4hlen..." });
    var workflow_buttons_disp2413 = new Ext.form.DisplayField({ "disabled": true, "value": "<br/>", "always_enabled": true });
    var id2414 = new Ext.form.NumberField({ "selectOnFocus": true });
    var owner_type2415 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/postings/PostingsByState/owner_type", "method": "GET" }) }), "pageSize": 20, "emptyText": "Inhaltstyp ausw\u00e4hlen..." });
    var owner_id2416 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/postings/PostingsByState/owner_id", "method": "GET" }) }) });
    var project2417 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/postings/PostingsByState/project", "method": "GET" }) }), "pageSize": 20, "emptyText": "Klient ausw\u00e4hlen..." });
    var state2418 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "forceSelection": true, "allowBlank": false, "store": Lino.postings.PostingStates });
    var owner_disp2419 = new Ext.form.DisplayField({ "disabled": true });
    this.before_row_edit = function(record) {
      owner_id2416.setContextValue('owner_type',record ? record.data['owner_typeHidden'] : undefined);
    };
    this.onRender = function(ct, position) {
      owner_type2415.on('change',Lino.chooser_handler(owner_id2416,'owner_type'));
      Lino.postings.PostingsByState.GridPanel.superclass.onRender.call(this, ct, position);
    }
    this.ls_columns = [ { "colIndex": 0, "sortable": true, "xtype": "datecolumn", "format": "d.m.Y", "editable": true, "filter": { "type": "date", "dateFormat": "d.m.Y" }, "header": "date", "editor": date2410, "width": Lino.chars2width(9), "dataIndex": "date" }, { "colIndex": 1, "sortable": true, "header": "Autor", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(16), "dataIndex": "user", "editor": user2411 }, { "colIndex": 2, "sortable": true, "header": "Empf\u00e4nger", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('partnerHidden','Lino.contacts.Partners.detail'), "editor": partner2412, "dataIndex": "partner" }, { "width": Lino.chars2width(31), "colIndex": 3, "sortable": false, "dataIndex": "workflow_buttons", "header": "Arbeitsablauf", "editable": false }, new Lino.NullNumberColumn({ "colIndex": 4, "sortable": true, "format": "0", "editable": true, "filter": { "type": "numeric" }, "header": "ID", "renderer": Lino.id_renderer, "editor": id2414, "width": Lino.chars2width(6), "dataIndex": "id" }), { "colIndex": 5, "sortable": true, "header": "Verkn\u00fcpft mit (Modell)", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('owner_typeHidden','Lino.ui.ContentTypes.detail'), "editor": owner_type2415, "dataIndex": "owner_type" }, { "colIndex": 6, "sortable": true, "header": "Verkn\u00fcpft mit (Objekt)", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(11), "dataIndex": "owner_id", "editor": owner_id2416 }, { "colIndex": 7, "sortable": true, "header": "Klient", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('projectHidden','Lino.pcsw.Clients.detail'), "editor": project2417, "dataIndex": "project" }, { "colIndex": 8, "sortable": true, "header": "Zustand", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(23), "dataIndex": "state", "editor": state2418 }, { "width": Lino.chars2width(11), "colIndex": 9, "sortable": false, "dataIndex": "owner", "header": "Verkn\u00fcpft mit", "editable": false } ];
    Lino.postings.PostingsByState.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.postings.PostingsByState.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.postings.PostingsByState.GridPanel(p);
});
Lino.postings.PostingsByState.print_action = function(rp,pk) { 
  Lino.run_row_action(rp,"/postings/PostingsByState",pk,"print_action");
};

// js_render_GridPanel_class postings.PostingsReady
Lino.postings.PostingsReady.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "Keine Daten anzuzeigen." },
  ls_url : "/postings/PostingsReady",
  ls_bbar_actions : [ { "itemId": null, "menu_item_text": "L\u00f6schen", "tooltip": "Diesen Datensatz l\u00f6schen", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "L\u00f6schen", "auto_save": false }, { "itemId": "print_action", "menu_item_text": "Drucken", "must_save": true, "tooltip": "Drucken", "panel_btn_handler": Lino.row_action_handler('print_action','GET'), "iconCls": "x-tbar-print", "overflowText": "Drucken", "auto_save": true } ],
  title : "Bereit f\u00fcr Ausdruck",
  page_length : 20,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "type": "date", "name": "date", "dateFormat": "d.m.Y" }, { "name": "user" }, 'userHidden', { "name": "partner" }, 'partnerHidden', { "name": "workflow_buttons" }, { "type": "int", "name": "id" }, { "name": "owner_type" }, 'owner_typeHidden', { "name": "owner_id" }, 'owner_idHidden', { "name": "project" }, 'projectHidden', { "name": "state" }, 'stateHidden', { "name": "owner" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 6,
  ls_grid_configs : [  ],
  content_type : 38,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 17,
  initComponent : function() {
    var ww = this.containing_window;
    var date2421 = new Lino.DateField({ "selectOnFocus": true, "allowBlank": false });
    var user2422 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/postings/PostingsReady/user", "method": "GET" }) }), "pageSize": 20, "emptyText": "Benutzer ausw\u00e4hlen..." });
    var partner2423 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/postings/PostingsReady/partner", "method": "GET" }) }), "pageSize": 20, "emptyText": "Partner ausw\u00e4hlen..." });
    var workflow_buttons_disp2424 = new Ext.form.DisplayField({ "disabled": true, "value": "<br/>", "always_enabled": true });
    var id2425 = new Ext.form.NumberField({ "selectOnFocus": true });
    var owner_type2426 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/postings/PostingsReady/owner_type", "method": "GET" }) }), "pageSize": 20, "emptyText": "Inhaltstyp ausw\u00e4hlen..." });
    var owner_id2427 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/postings/PostingsReady/owner_id", "method": "GET" }) }) });
    var project2428 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/postings/PostingsReady/project", "method": "GET" }) }), "pageSize": 20, "emptyText": "Klient ausw\u00e4hlen..." });
    var state2429 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "forceSelection": true, "allowBlank": false, "store": Lino.postings.PostingStates });
    var owner_disp2430 = new Ext.form.DisplayField({ "disabled": true });
    this.before_row_edit = function(record) {
      owner_id2427.setContextValue('owner_type',record ? record.data['owner_typeHidden'] : undefined);
    };
    this.onRender = function(ct, position) {
      owner_type2426.on('change',Lino.chooser_handler(owner_id2427,'owner_type'));
      Lino.postings.PostingsReady.GridPanel.superclass.onRender.call(this, ct, position);
    }
    this.ls_columns = [ { "colIndex": 0, "sortable": true, "xtype": "datecolumn", "format": "d.m.Y", "editable": true, "filter": { "type": "date", "dateFormat": "d.m.Y" }, "header": "date", "editor": date2421, "width": Lino.chars2width(9), "dataIndex": "date" }, { "colIndex": 1, "sortable": true, "header": "Autor", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(16), "dataIndex": "user", "editor": user2422 }, { "colIndex": 2, "sortable": true, "header": "Empf\u00e4nger", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('partnerHidden','Lino.contacts.Partners.detail'), "editor": partner2423, "dataIndex": "partner" }, { "width": Lino.chars2width(31), "colIndex": 3, "sortable": false, "dataIndex": "workflow_buttons", "header": "Arbeitsablauf", "editable": false }, new Lino.NullNumberColumn({ "colIndex": 4, "sortable": true, "format": "0", "editable": true, "filter": { "type": "numeric" }, "header": "ID", "renderer": Lino.id_renderer, "editor": id2425, "width": Lino.chars2width(6), "dataIndex": "id" }), { "colIndex": 5, "sortable": true, "header": "Verkn\u00fcpft mit (Modell)", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('owner_typeHidden','Lino.ui.ContentTypes.detail'), "editor": owner_type2426, "dataIndex": "owner_type" }, { "colIndex": 6, "sortable": true, "header": "Verkn\u00fcpft mit (Objekt)", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(11), "dataIndex": "owner_id", "editor": owner_id2427 }, { "colIndex": 7, "sortable": true, "header": "Klient", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('projectHidden','Lino.pcsw.Clients.detail'), "editor": project2428, "dataIndex": "project" }, { "colIndex": 8, "sortable": true, "header": "Zustand", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(23), "dataIndex": "state", "editor": state2429 }, { "width": Lino.chars2width(11), "colIndex": 9, "sortable": false, "dataIndex": "owner", "header": "Verkn\u00fcpft mit", "editable": false } ];
    Lino.postings.PostingsReady.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.postings.PostingsReady.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.postings.PostingsReady.GridPanel(p);
});
Lino.postings.PostingsReady.print_action = function(rp,pk) { 
  Lino.run_row_action(rp,"/postings/PostingsReady",pk,"print_action");
};

// js_render_GridPanel_class postings.PostingsPrinted
Lino.postings.PostingsPrinted.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "Keine Daten anzuzeigen." },
  ls_url : "/postings/PostingsPrinted",
  ls_bbar_actions : [ { "itemId": null, "menu_item_text": "L\u00f6schen", "tooltip": "Diesen Datensatz l\u00f6schen", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "L\u00f6schen", "auto_save": false }, { "itemId": "print_action", "menu_item_text": "Drucken", "must_save": true, "tooltip": "Drucken", "panel_btn_handler": Lino.row_action_handler('print_action','GET'), "iconCls": "x-tbar-print", "overflowText": "Drucken", "auto_save": true } ],
  title : "Gedruckte Postsendungen",
  page_length : 20,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "type": "date", "name": "date", "dateFormat": "d.m.Y" }, { "name": "user" }, 'userHidden', { "name": "partner" }, 'partnerHidden', { "name": "workflow_buttons" }, { "type": "int", "name": "id" }, { "name": "owner_type" }, 'owner_typeHidden', { "name": "owner_id" }, 'owner_idHidden', { "name": "project" }, 'projectHidden', { "name": "state" }, 'stateHidden', { "name": "owner" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 6,
  ls_grid_configs : [  ],
  content_type : 38,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 17,
  initComponent : function() {
    var ww = this.containing_window;
    var date2432 = new Lino.DateField({ "selectOnFocus": true, "allowBlank": false });
    var user2433 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/postings/PostingsPrinted/user", "method": "GET" }) }), "pageSize": 20, "emptyText": "Benutzer ausw\u00e4hlen..." });
    var partner2434 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/postings/PostingsPrinted/partner", "method": "GET" }) }), "pageSize": 20, "emptyText": "Partner ausw\u00e4hlen..." });
    var workflow_buttons_disp2435 = new Ext.form.DisplayField({ "disabled": true, "value": "<br/>", "always_enabled": true });
    var id2436 = new Ext.form.NumberField({ "selectOnFocus": true });
    var owner_type2437 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/postings/PostingsPrinted/owner_type", "method": "GET" }) }), "pageSize": 20, "emptyText": "Inhaltstyp ausw\u00e4hlen..." });
    var owner_id2438 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/postings/PostingsPrinted/owner_id", "method": "GET" }) }) });
    var project2439 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/postings/PostingsPrinted/project", "method": "GET" }) }), "pageSize": 20, "emptyText": "Klient ausw\u00e4hlen..." });
    var state2440 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "forceSelection": true, "allowBlank": false, "store": Lino.postings.PostingStates });
    var owner_disp2441 = new Ext.form.DisplayField({ "disabled": true });
    this.before_row_edit = function(record) {
      owner_id2438.setContextValue('owner_type',record ? record.data['owner_typeHidden'] : undefined);
    };
    this.onRender = function(ct, position) {
      owner_type2437.on('change',Lino.chooser_handler(owner_id2438,'owner_type'));
      Lino.postings.PostingsPrinted.GridPanel.superclass.onRender.call(this, ct, position);
    }
    this.ls_columns = [ { "colIndex": 0, "sortable": true, "xtype": "datecolumn", "format": "d.m.Y", "editable": true, "filter": { "type": "date", "dateFormat": "d.m.Y" }, "header": "date", "editor": date2432, "width": Lino.chars2width(9), "dataIndex": "date" }, { "colIndex": 1, "sortable": true, "header": "Autor", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(16), "dataIndex": "user", "editor": user2433 }, { "colIndex": 2, "sortable": true, "header": "Empf\u00e4nger", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('partnerHidden','Lino.contacts.Partners.detail'), "editor": partner2434, "dataIndex": "partner" }, { "width": Lino.chars2width(31), "colIndex": 3, "sortable": false, "dataIndex": "workflow_buttons", "header": "Arbeitsablauf", "editable": false }, new Lino.NullNumberColumn({ "colIndex": 4, "sortable": true, "format": "0", "editable": true, "filter": { "type": "numeric" }, "header": "ID", "renderer": Lino.id_renderer, "editor": id2436, "width": Lino.chars2width(6), "dataIndex": "id" }), { "colIndex": 5, "sortable": true, "header": "Verkn\u00fcpft mit (Modell)", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('owner_typeHidden','Lino.ui.ContentTypes.detail'), "editor": owner_type2437, "dataIndex": "owner_type" }, { "colIndex": 6, "sortable": true, "header": "Verkn\u00fcpft mit (Objekt)", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(11), "dataIndex": "owner_id", "editor": owner_id2438 }, { "colIndex": 7, "sortable": true, "header": "Klient", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('projectHidden','Lino.pcsw.Clients.detail'), "editor": project2439, "dataIndex": "project" }, { "colIndex": 8, "sortable": true, "header": "Zustand", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(23), "dataIndex": "state", "editor": state2440 }, { "width": Lino.chars2width(11), "colIndex": 9, "sortable": false, "dataIndex": "owner", "header": "Verkn\u00fcpft mit", "editable": false } ];
    Lino.postings.PostingsPrinted.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.postings.PostingsPrinted.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.postings.PostingsPrinted.GridPanel(p);
});
Lino.postings.PostingsPrinted.print_action = function(rp,pk) { 
  Lino.run_row_action(rp,"/postings/PostingsPrinted",pk,"print_action");
};

// js_render_GridPanel_class postings.PostingsSent
Lino.postings.PostingsSent.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "Keine Daten anzuzeigen." },
  ls_url : "/postings/PostingsSent",
  ls_bbar_actions : [ { "itemId": null, "menu_item_text": "L\u00f6schen", "tooltip": "Diesen Datensatz l\u00f6schen", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "L\u00f6schen", "auto_save": false }, { "itemId": "print_action", "menu_item_text": "Drucken", "must_save": true, "tooltip": "Drucken", "panel_btn_handler": Lino.row_action_handler('print_action','GET'), "iconCls": "x-tbar-print", "overflowText": "Drucken", "auto_save": true } ],
  title : "Ausgegangene Postsendungen",
  page_length : 20,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "type": "date", "name": "date", "dateFormat": "d.m.Y" }, { "name": "user" }, 'userHidden', { "name": "partner" }, 'partnerHidden', { "name": "workflow_buttons" }, { "type": "int", "name": "id" }, { "name": "owner_type" }, 'owner_typeHidden', { "name": "owner_id" }, 'owner_idHidden', { "name": "project" }, 'projectHidden', { "name": "state" }, 'stateHidden', { "name": "owner" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 6,
  ls_grid_configs : [  ],
  content_type : 38,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 17,
  initComponent : function() {
    var ww = this.containing_window;
    var date2443 = new Lino.DateField({ "selectOnFocus": true, "allowBlank": false });
    var user2444 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/postings/PostingsSent/user", "method": "GET" }) }), "pageSize": 20, "emptyText": "Benutzer ausw\u00e4hlen..." });
    var partner2445 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/postings/PostingsSent/partner", "method": "GET" }) }), "pageSize": 20, "emptyText": "Partner ausw\u00e4hlen..." });
    var workflow_buttons_disp2446 = new Ext.form.DisplayField({ "disabled": true, "value": "<br/>", "always_enabled": true });
    var id2447 = new Ext.form.NumberField({ "selectOnFocus": true });
    var owner_type2448 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/postings/PostingsSent/owner_type", "method": "GET" }) }), "pageSize": 20, "emptyText": "Inhaltstyp ausw\u00e4hlen..." });
    var owner_id2449 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/postings/PostingsSent/owner_id", "method": "GET" }) }) });
    var project2450 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/postings/PostingsSent/project", "method": "GET" }) }), "pageSize": 20, "emptyText": "Klient ausw\u00e4hlen..." });
    var state2451 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "forceSelection": true, "allowBlank": false, "store": Lino.postings.PostingStates });
    var owner_disp2452 = new Ext.form.DisplayField({ "disabled": true });
    this.before_row_edit = function(record) {
      owner_id2449.setContextValue('owner_type',record ? record.data['owner_typeHidden'] : undefined);
    };
    this.onRender = function(ct, position) {
      owner_type2448.on('change',Lino.chooser_handler(owner_id2449,'owner_type'));
      Lino.postings.PostingsSent.GridPanel.superclass.onRender.call(this, ct, position);
    }
    this.ls_columns = [ { "colIndex": 0, "sortable": true, "xtype": "datecolumn", "format": "d.m.Y", "editable": true, "filter": { "type": "date", "dateFormat": "d.m.Y" }, "header": "date", "editor": date2443, "width": Lino.chars2width(9), "dataIndex": "date" }, { "colIndex": 1, "sortable": true, "header": "Autor", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(16), "dataIndex": "user", "editor": user2444 }, { "colIndex": 2, "sortable": true, "header": "Empf\u00e4nger", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('partnerHidden','Lino.contacts.Partners.detail'), "editor": partner2445, "dataIndex": "partner" }, { "width": Lino.chars2width(31), "colIndex": 3, "sortable": false, "dataIndex": "workflow_buttons", "header": "Arbeitsablauf", "editable": false }, new Lino.NullNumberColumn({ "colIndex": 4, "sortable": true, "format": "0", "editable": true, "filter": { "type": "numeric" }, "header": "ID", "renderer": Lino.id_renderer, "editor": id2447, "width": Lino.chars2width(6), "dataIndex": "id" }), { "colIndex": 5, "sortable": true, "header": "Verkn\u00fcpft mit (Modell)", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('owner_typeHidden','Lino.ui.ContentTypes.detail'), "editor": owner_type2448, "dataIndex": "owner_type" }, { "colIndex": 6, "sortable": true, "header": "Verkn\u00fcpft mit (Objekt)", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(11), "dataIndex": "owner_id", "editor": owner_id2449 }, { "colIndex": 7, "sortable": true, "header": "Klient", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('projectHidden','Lino.pcsw.Clients.detail'), "editor": project2450, "dataIndex": "project" }, { "colIndex": 8, "sortable": true, "header": "Zustand", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(23), "dataIndex": "state", "editor": state2451 }, { "width": Lino.chars2width(11), "colIndex": 9, "sortable": false, "dataIndex": "owner", "header": "Verkn\u00fcpft mit", "editable": false } ];
    Lino.postings.PostingsSent.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.postings.PostingsSent.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.postings.PostingsSent.GridPanel(p);
});
Lino.postings.PostingsSent.print_action = function(rp,pk) { 
  Lino.run_row_action(rp,"/postings/PostingsSent",pk,"print_action");
};

// js_render_GridPanel_class outbox.Attachments
Lino.outbox.Attachments.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "Keine Daten anzuzeigen." },
  ls_url : "/outbox/Attachments",
  ls_bbar_actions : [ { "itemId": null, "menu_item_text": "L\u00f6schen", "tooltip": "Diesen Datensatz l\u00f6schen", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "L\u00f6schen", "auto_save": false } ],
  title : "Anh\u00e4nge",
  page_length : 20,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "type": "int", "name": "id" }, { "name": "owner_type" }, 'owner_typeHidden', { "name": "owner_id" }, 'owner_idHidden', { "name": "mail" }, 'mailHidden', { "name": "owner" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 0,
  ls_grid_configs : [  ],
  content_type : 29,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 9,
  initComponent : function() {
    var ww = this.containing_window;
    var id2454 = new Ext.form.NumberField({ "selectOnFocus": true });
    var owner_type2455 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/outbox/Attachments/owner_type", "method": "GET" }) }), "pageSize": 20, "emptyText": "Inhaltstyp ausw\u00e4hlen..." });
    var owner_id2456 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/outbox/Attachments/owner_id", "method": "GET" }) }) });
    var mail2457 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/outbox/Attachments/mail", "method": "GET" }) }), "allowBlank": false, "pageSize": 20, "emptyText": "E-Mail-Ausgang ausw\u00e4hlen..." });
    var owner_disp2458 = new Ext.form.DisplayField({ "disabled": true });
    this.before_row_edit = function(record) {
      owner_id2456.setContextValue('owner_type',record ? record.data['owner_typeHidden'] : undefined);
    };
    this.onRender = function(ct, position) {
      owner_type2455.on('change',Lino.chooser_handler(owner_id2456,'owner_type'));
      Lino.outbox.Attachments.GridPanel.superclass.onRender.call(this, ct, position);
    }
    this.ls_columns = [ new Lino.NullNumberColumn({ "colIndex": 0, "sortable": true, "format": "0", "editable": true, "filter": { "type": "numeric" }, "header": "ID", "renderer": Lino.id_renderer, "editor": id2454, "width": Lino.chars2width(6), "dataIndex": "id" }), { "colIndex": 1, "sortable": true, "header": "Verkn\u00fcpft mit (Modell)", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('owner_typeHidden','Lino.ui.ContentTypes.detail'), "editor": owner_type2455, "dataIndex": "owner_type" }, { "colIndex": 2, "sortable": true, "header": "Verkn\u00fcpft mit (Objekt)", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(11), "dataIndex": "owner_id", "editor": owner_id2456 }, { "colIndex": 3, "sortable": true, "header": "E-Mail-Ausgang", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "mail", "editor": mail2457 }, { "width": Lino.chars2width(11), "colIndex": 4, "sortable": false, "dataIndex": "owner", "header": "Verkn\u00fcpft mit", "editable": false } ];
    Lino.outbox.Attachments.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.outbox.Attachments.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.outbox.Attachments.GridPanel(p);
});

// js_render_GridPanel_class cal.Places
Lino.cal.Places.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "Keine Daten anzuzeigen." },
  ls_url : "/cal/Places",
  ls_bbar_actions : [ { "itemId": "insert", "menu_item_text": "Neu", "must_save": true, "tooltip": "Neuen Datensatz erstellen", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-new", "overflowText": "Neu", "auto_save": true }, { "itemId": "detail", "menu_item_text": "Detail", "tooltip": "Detail-Fenster auf diesem Datensatz \u00f6ffnen", "panel_btn_handler": Lino.show_detail, "iconCls": "x-tbar-detail", "overflowText": "Detail", "auto_save": true }, { "itemId": null, "menu_item_text": "L\u00f6schen", "tooltip": "Diesen Datensatz l\u00f6schen", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "L\u00f6schen", "auto_save": false } ],
  title : "Orte",
  page_length : 20,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "type": "int", "name": "id" }, { "name": "name" }, { "name": "name_fr" }, { "name": "name_nl" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 0,
  ls_grid_configs : [  ],
  content_type : 33,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 5,
  initComponent : function() {
    this.ls_detail_handler = Lino.cal.Places.detail;
    this.ls_insert_handler = Lino.cal.Places.insert;
    var ww = this.containing_window;
    var id2460 = new Ext.form.NumberField({ "selectOnFocus": true });
    var name2461 = new Ext.form.TextField({ "selectOnFocus": true, "allowBlank": false, "maxLength": 200 });
    var name_fr2462 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var name_nl2463 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ new Lino.NullNumberColumn({ "colIndex": 0, "sortable": true, "format": "0", "editable": true, "filter": { "type": "numeric" }, "header": "ID", "renderer": Lino.id_renderer, "editor": id2460, "width": Lino.chars2width(6), "dataIndex": "id" }), { "colIndex": 1, "sortable": true, "header": "Bezeichnung", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "name", "editor": name2461 }, { "colIndex": 2, "sortable": true, "header": "Bezeichnung (fr)", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "name_fr", "editor": name_fr2462 }, { "colIndex": 3, "sortable": true, "header": "Bezeichnung (nl)", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "name_nl", "editor": name_nl2463 } ];
    Lino.cal.Places.GridPanel.superclass.initComponent.call(this);
  }
});


Lino.cal.Places.insertPanel = Ext.extend(Lino.cal.Places.DetailFormPanel,{
  empty_title: "Neu Orte",
  hide_navigator: true,
  ls_bbar_actions: [ { "itemId": "post", "menu_item_text": "Erstellen", "tooltip": "Datensatz erstellen und dann im Detail-Fenster \u00f6ffnen", "panel_btn_handler": function(panel){panel.save(null,true,'post')}, "text": "Erstellen", "overflowText": "Erstellen", "auto_save": false }, { "itemId": "poststay", "menu_item_text": "Erstellen ohne Detail", "tooltip": "Nach Erstellen des Datensatzes kein Detail-Fenster \u00f6ffnen", "panel_btn_handler": function(panel){panel.save(null,false,'poststay')}, "text": "Erstellen ohne Detail", "overflowText": "Erstellen ohne Detail", "auto_save": false } ],
  ls_url: "/cal/Places",
  action_name: "insert",
  initComponent : function() {
    this.ls_detail_handler = Lino.cal.Places.detail;
    this.ls_insert_handler = Lino.cal.Places.insert;
    Lino.cal.Places.insertPanel.superclass.initComponent.call(this);
  }
});

Lino.cal.Places.insert = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.cal.Places.insertPanel(p);
});

Lino.cal.Places.detailPanel = Ext.extend(Lino.cal.Places.DetailFormPanel,{
  empty_title: "Detail Orte",
  ls_bbar_actions: [ { "itemId": "put", "menu_item_text": "Speichern", "tooltip": "\u00c4nderungen in diesem Formular speichern", "panel_btn_handler": function(panel){panel.save(null,false,'put')}, "iconCls": "x-tbar-save", "overflowText": "Speichern", "auto_save": false }, { "itemId": "insert", "menu_item_text": "Neu", "must_save": true, "tooltip": "Neuen Datensatz erstellen", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-new", "overflowText": "Neu", "auto_save": true }, { "itemId": null, "menu_item_text": "L\u00f6schen", "tooltip": "Diesen Datensatz l\u00f6schen", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "L\u00f6schen", "auto_save": false } ],
  ls_url: "/cal/Places",
  action_name: "detail",
  initComponent : function() {
    this.ls_detail_handler = Lino.cal.Places.detail;
    this.ls_insert_handler = Lino.cal.Places.insert;
    Lino.cal.Places.detailPanel.superclass.initComponent.call(this);
  }
});

Lino.cal.Places.detail = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.cal.Places.detailPanel(p);
});
Lino.cal.Places.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.cal.Places.GridPanel(p);
});

// js_render_GridPanel_class cal.Priorities
Lino.cal.Priorities.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "Keine Daten anzuzeigen." },
  ls_url : "/cal/Priorities",
  ls_bbar_actions : [ { "itemId": null, "menu_item_text": "L\u00f6schen", "tooltip": "Diesen Datensatz l\u00f6schen", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "L\u00f6schen", "auto_save": false } ],
  title : "Priorit\u00e4ten",
  page_length : 20,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "name": "name" }, { "name": "name_fr" }, { "name": "name_nl" }, { "type": "int", "name": "id" }, { "name": "ref" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 3,
  ls_grid_configs : [  ],
  content_type : 32,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 6,
  initComponent : function() {
    var ww = this.containing_window;
    var name2465 = new Ext.form.TextField({ "selectOnFocus": true, "allowBlank": false, "maxLength": 200 });
    var name_fr2466 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var name_nl2467 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var id2468 = new Ext.form.NumberField({ "selectOnFocus": true });
    var ref2469 = new Ext.form.TextField({ "selectOnFocus": true, "allowBlank": false, "maxLength": "1" });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ { "colIndex": 0, "sortable": true, "header": "Bezeichnung", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "name", "editor": name2465 }, { "colIndex": 1, "sortable": true, "header": "Bezeichnung (fr)", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "name_fr", "editor": name_fr2466 }, { "colIndex": 2, "sortable": true, "header": "Bezeichnung (nl)", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "name_nl", "editor": name_nl2467 }, new Lino.NullNumberColumn({ "colIndex": 3, "sortable": true, "format": "0", "editable": true, "filter": { "type": "numeric" }, "header": "ID", "renderer": Lino.id_renderer, "editor": id2468, "width": Lino.chars2width(6), "dataIndex": "id" }), { "colIndex": 4, "sortable": true, "header": "ref", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "ref", "editor": ref2469 } ];
    Lino.cal.Priorities.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.cal.Priorities.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.cal.Priorities.GridPanel(p);
});

// js_render_GridPanel_class cal.MyEvents
Lino.cal.MyEvents.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "Keine Daten anzuzeigen." },
  ls_url : "/cal/MyEvents",
  ls_bbar_actions : [ { "itemId": "insert", "menu_item_text": "Neu", "must_save": true, "tooltip": "Neuen Datensatz erstellen", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-new", "overflowText": "Neu", "auto_save": true }, { "itemId": "duplicate", "menu_item_text": "Duplizieren", "must_save": true, "tooltip": "Duplizieren", "panel_btn_handler": Lino.row_action_handler('duplicate','GET'), "iconCls": "x-tbar-duplicate", "overflowText": "Duplizieren", "auto_save": true }, { "itemId": "detail", "menu_item_text": "Detail", "tooltip": "Detail-Fenster auf diesem Datensatz \u00f6ffnen", "panel_btn_handler": Lino.show_detail, "iconCls": "x-tbar-detail", "overflowText": "Detail", "auto_save": true }, { "itemId": null, "menu_item_text": "L\u00f6schen", "tooltip": "Diesen Datensatz l\u00f6schen", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "L\u00f6schen", "auto_save": false }, { "itemId": "do_print", "menu_item_text": "Drucken", "must_save": true, "tooltip": "Drucken", "panel_btn_handler": Lino.row_action_handler('do_print','GET'), "iconCls": "x-tbar-print", "overflowText": "Drucken", "auto_save": true }, { "itemId": "do_clear_cache", "menu_item_text": "Cache l\u00f6schen", "must_save": true, "tooltip": "Cache l\u00f6schen", "panel_btn_handler": Lino.row_action_handler('do_clear_cache','GET'), "iconCls": "x-tbar-clearcache", "overflowText": "Cache l\u00f6schen", "auto_save": true }, { "itemId": "create_postings", "menu_item_text": "per Post", "must_save": true, "tooltip": "Create classical mail postings from this", "panel_btn_handler": Lino.row_action_handler('create_postings','GET'), "iconCls": "x-tbar-create-postings", "overflowText": "per Post", "auto_save": true } ],
  title : "Termine",
  page_length : 20,
  params_panel_hidden : true,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "type": "date", "name": "start_date", "dateFormat": "d.m.Y" }, { "name": "start_time" }, { "name": "calendar" }, 'calendarHidden', { "name": "project" }, 'projectHidden', { "name": "summary" }, { "type": "int", "name": "id" }, { "name": "owner_type" }, 'owner_typeHidden', { "name": "owner_id" }, 'owner_idHidden', { "name": "user" }, 'userHidden', { "name": "created" }, { "name": "modified" }, { "name": "build_time" }, { "type": "date", "name": "end_date", "dateFormat": "d.m.Y" }, { "name": "end_time" }, { "name": "description" }, { "name": "uid" }, { "name": "access_class" }, 'access_classHidden', { "type": "int", "name": "sequence" }, { "type": "int", "name": "auto_type" }, { "type": "boolean", "name": "transparent" }, { "name": "place" }, 'placeHidden', { "name": "priority" }, 'priorityHidden', { "name": "state" }, 'stateHidden', { "name": "assigned_to" }, 'assigned_toHidden', { "name": "owner" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 7,
  ls_grid_configs : [  ],
  content_type : 36,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 36,
  initComponent : function() {
    this.ls_detail_handler = Lino.cal.MyEvents.detail;
    this.ls_insert_handler = Lino.cal.MyEvents.insert;
    var ww = this.containing_window;
    var start_date2471 = new Lino.DateField({ "selectOnFocus": true });
    var start_time2472 = new Lino.TimeField({ "selectOnFocus": true });
    var calendar2473 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/MyEvents/calendar", "method": "GET" }) }), "pageSize": 20, "emptyText": "Kalender ausw\u00e4hlen..." });
    var project2474 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/MyEvents/project", "method": "GET" }) }), "pageSize": 20, "emptyText": "Klient ausw\u00e4hlen..." });
    var summary2475 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var id2476 = new Ext.form.NumberField({ "selectOnFocus": true });
    var owner_type2477 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/MyEvents/owner_type", "method": "GET" }) }), "pageSize": 20, "emptyText": "Inhaltstyp ausw\u00e4hlen..." });
    var owner_id2478 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/MyEvents/owner_id", "method": "GET" }) }) });
    var user2479 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/MyEvents/user", "method": "GET" }) }), "pageSize": 20, "emptyText": "Benutzer ausw\u00e4hlen..." });
    var created2480 = new Ext.form.DisplayField({ "disabled": true, "value": "<br>" });
    var modified2481 = new Ext.form.DisplayField({ "disabled": true, "value": "<br>" });
    var build_time2482 = new Ext.form.DisplayField({ "disabled": true, "value": "<br>" });
    var end_date2483 = new Lino.DateField({ "selectOnFocus": true });
    var end_time2484 = new Lino.TimeField({ "selectOnFocus": true });
    var description2485 = new Lino.RichTextPanel({ "selectOnFocus": true, "containing_panel": this, "title": "Beschreibung" });
    var uid2486 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var access_class2487 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "forceSelection": true, "store": Lino.cal.AccessClasses });
    var sequence2488 = new Ext.form.NumberField({ "selectOnFocus": true, "allowBlank": false, "value": 0 });
    var auto_type2489 = new Ext.form.NumberField({ "disabled": true });
    var transparent2490 = new Ext.form.Checkbox({ "selectOnFocus": true, "checked": false });
    var place2491 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/MyEvents/place", "method": "GET" }) }), "pageSize": 20, "emptyText": "Ort ausw\u00e4hlen..." });
    var priority2492 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/MyEvents/priority", "method": "GET" }) }), "pageSize": 20, "emptyText": "Priorit\u00e4t ausw\u00e4hlen..." });
    var state2493 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "forceSelection": true, "allowBlank": false, "store": Lino.cal.EventStates });
    var assigned_to2494 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/MyEvents/assigned_to", "method": "GET" }) }), "pageSize": 20, "emptyText": "Benutzer ausw\u00e4hlen..." });
    var owner_disp2495 = new Ext.form.DisplayField({ "disabled": true });
    this.before_row_edit = function(record) {
      owner_id2478.setContextValue('owner_type',record ? record.data['owner_typeHidden'] : undefined);
      description2485.refresh();
    };
    this.onRender = function(ct, position) {
      owner_type2477.on('change',Lino.chooser_handler(owner_id2478,'owner_type'));
      Lino.cal.MyEvents.GridPanel.superclass.onRender.call(this, ct, position);
    }
    this.ls_columns = [ { "colIndex": 0, "sortable": true, "xtype": "datecolumn", "format": "d.m.Y", "editable": true, "filter": { "type": "date", "dateFormat": "d.m.Y" }, "header": "Beginnt am", "editor": start_date2471, "width": Lino.chars2width(9), "dataIndex": "start_date" }, { "width": Lino.chars2width(9), "colIndex": 1, "sortable": true, "dataIndex": "start_time", "header": "Beginnt um", "editable": true, "editor": start_time2472 }, { "colIndex": 2, "sortable": true, "header": "Kalender", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "calendar", "editor": calendar2473 }, { "colIndex": 3, "sortable": true, "header": "Klient", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('projectHidden','Lino.pcsw.Clients.detail'), "editor": project2474, "dataIndex": "project" }, { "colIndex": 4, "sortable": true, "header": "Kurzbeschreibung", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "summary", "editor": summary2475 }, new Lino.NullNumberColumn({ "colIndex": 5, "sortable": true, "format": "0", "editable": true, "filter": { "type": "numeric" }, "header": "ID", "renderer": Lino.id_renderer, "editor": id2476, "width": Lino.chars2width(6), "dataIndex": "id" }), { "colIndex": 6, "sortable": true, "header": "Verkn\u00fcpft mit (Modell)", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('owner_typeHidden','Lino.ui.ContentTypes.detail'), "hidden": true, "editor": owner_type2477, "dataIndex": "owner_type" }, { "colIndex": 7, "sortable": true, "header": "Verkn\u00fcpft mit (Objekt)", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(11), "dataIndex": "owner_id", "hidden": true, "editor": owner_id2478 }, { "colIndex": 8, "sortable": true, "header": "Verantwortlicher", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(16), "dataIndex": "user", "editor": user2479 }, { "width": Lino.chars2width(17), "colIndex": 9, "sortable": true, "dataIndex": "created", "header": "Erstellt", "hidden": true, "editable": false }, { "width": Lino.chars2width(17), "colIndex": 10, "sortable": true, "dataIndex": "modified", "header": "Bearbeitet", "hidden": true, "editable": false }, { "width": Lino.chars2width(17), "colIndex": 11, "sortable": true, "dataIndex": "build_time", "header": "Druckdatum", "hidden": true, "editable": false }, { "colIndex": 12, "sortable": true, "xtype": "datecolumn", "format": "d.m.Y", "editable": true, "filter": { "type": "date", "dateFormat": "d.m.Y" }, "header": "Endet am", "dataIndex": "end_date", "hidden": true, "width": Lino.chars2width(9), "editor": end_date2483 }, { "colIndex": 13, "sortable": true, "header": "Endet um", "editable": true, "width": Lino.chars2width(9), "dataIndex": "end_time", "hidden": true, "editor": end_time2484 }, { "colIndex": 14, "sortable": false, "header": "description", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(61), "renderer": Lino.text_renderer, "hidden": true, "editor": description2485, "dataIndex": "description" }, { "colIndex": 15, "sortable": true, "header": "UID", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "uid", "hidden": true, "editor": uid2486 }, { "colIndex": 16, "sortable": true, "header": "Zugriffsklasse", "editable": true, "tooltip": "Ob dieser Termin  privat, \u00f6ffentlich oder halb \u00f6ffentlich ist", "filter": { "type": "string" }, "width": Lino.chars2width(35), "dataIndex": "access_class", "hidden": true, "editor": access_class2487 }, new Lino.NullNumberColumn({ "colIndex": 17, "sortable": true, "format": "0", "editable": true, "filter": { "type": "numeric" }, "header": "Revisionsnummer", "dataIndex": "sequence", "hidden": true, "width": Lino.chars2width(6), "editor": sequence2488 }), new Lino.NullNumberColumn({ "colIndex": 18, "sortable": true, "format": "0", "editable": false, "filter": { "type": "numeric" }, "header": "auto type", "dataIndex": "auto_type", "hidden": true, "width": Lino.chars2width(6) }), { "colIndex": 19, "sortable": false, "xtype": "checkcolumn", "header": "nicht blockierend", "editable": true, "tooltip": "Dieser Termin l\u00e4sst auch andere Termine zur gleichen Zeit zu.", "filter": { "type": "boolean" }, "width": Lino.chars2width(11), "dataIndex": "transparent", "hidden": true }, { "colIndex": 20, "sortable": true, "header": "Ort", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('placeHidden','Lino.cal.Places.detail'), "hidden": true, "editor": place2491, "dataIndex": "place" }, { "colIndex": 21, "sortable": true, "header": "Priorit\u00e4t", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "priority", "hidden": true, "editor": priority2492 }, { "colIndex": 22, "sortable": true, "header": "Zustand", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(17), "dataIndex": "state", "editor": state2493 }, { "colIndex": 23, "sortable": true, "header": "Zugewiesen zu", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(16), "dataIndex": "assigned_to", "editor": assigned_to2494 }, { "width": Lino.chars2width(11), "colIndex": 24, "sortable": false, "dataIndex": "owner", "header": "Verkn\u00fcpft mit", "hidden": true, "editable": false } ];
    Lino.cal.MyEvents.GridPanel.superclass.initComponent.call(this);
  }
});


Lino.cal.MyEvents.insertPanel = Ext.extend(Lino.cal.MyEvents.InsertFormPanel,{
  empty_title: "Neu Termine",
  hide_navigator: true,
  params_panel_hidden: true,
  ls_bbar_actions: [ { "itemId": "post", "menu_item_text": "Erstellen", "tooltip": "Datensatz erstellen und dann im Detail-Fenster \u00f6ffnen", "panel_btn_handler": function(panel){panel.save(null,true,'post')}, "text": "Erstellen", "overflowText": "Erstellen", "auto_save": false }, { "itemId": "poststay", "menu_item_text": "Erstellen ohne Detail", "tooltip": "Nach Erstellen des Datensatzes kein Detail-Fenster \u00f6ffnen", "panel_btn_handler": function(panel){panel.save(null,false,'poststay')}, "text": "Erstellen ohne Detail", "overflowText": "Erstellen ohne Detail", "auto_save": false } ],
  ls_url: "/cal/MyEvents",
  action_name: "insert",
  initComponent : function() {
    this.ls_detail_handler = Lino.cal.MyEvents.detail;
    this.ls_insert_handler = Lino.cal.MyEvents.insert;
    Lino.cal.MyEvents.insertPanel.superclass.initComponent.call(this);
  }
});

Lino.cal.MyEvents.insert = new Lino.WindowAction({ "draggable": true, "width": Lino.chars2width(60), "autoHeight": true, "maximizable": true, "modal": true, "maximized": false },function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.cal.MyEvents.insertPanel(p);
});
Lino.cal.MyEvents.wf1 = function(rp,pk) { 
  Lino.run_row_action(rp,"/cal/MyEvents",pk,"wf1");
};
Lino.cal.MyEvents.wf2 = function(rp,pk) { 
  Lino.run_row_action(rp,"/cal/MyEvents",pk,"wf2");
};
Lino.cal.MyEvents.wf3 = function(rp,pk) { 
  Lino.run_row_action(rp,"/cal/MyEvents",pk,"wf3");
};
Lino.cal.MyEvents.wf4 = function(rp,pk) { 
  Lino.run_row_action(rp,"/cal/MyEvents",pk,"wf4");
};
Lino.cal.MyEvents.wf5 = function(rp,pk) { 
  Lino.run_row_action(rp,"/cal/MyEvents",pk,"wf5");
};
Lino.cal.MyEvents.wf6 = function(rp,pk) { 
  Lino.run_row_action(rp,"/cal/MyEvents",pk,"wf6");
};
Lino.cal.MyEvents.wf7 = function(rp,pk) { 
  Lino.run_row_action(rp,"/cal/MyEvents",pk,"wf7");
};
Lino.cal.MyEvents.wf8 = function(rp,pk) { 
  Lino.run_row_action(rp,"/cal/MyEvents",pk,"wf8");
};

Lino.cal.MyEvents.detailPanel = Ext.extend(Lino.cal.MyEvents.DetailFormPanel,{
  empty_title: "Detail Termine",
  params_panel_hidden: true,
  ls_bbar_actions: [ { "itemId": "put", "menu_item_text": "Speichern", "tooltip": "\u00c4nderungen in diesem Formular speichern", "panel_btn_handler": function(panel){panel.save(null,false,'put')}, "iconCls": "x-tbar-save", "overflowText": "Speichern", "auto_save": false }, { "itemId": "insert", "menu_item_text": "Neu", "must_save": true, "tooltip": "Neuen Datensatz erstellen", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-new", "overflowText": "Neu", "auto_save": true }, { "itemId": "duplicate", "menu_item_text": "Duplizieren", "must_save": true, "tooltip": "Duplizieren", "panel_btn_handler": Lino.row_action_handler('duplicate','GET'), "iconCls": "x-tbar-duplicate", "overflowText": "Duplizieren", "auto_save": true }, { "itemId": null, "menu_item_text": "L\u00f6schen", "tooltip": "Diesen Datensatz l\u00f6schen", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "L\u00f6schen", "auto_save": false }, { "itemId": "do_print", "menu_item_text": "Drucken", "must_save": true, "tooltip": "Drucken", "panel_btn_handler": Lino.row_action_handler('do_print','GET'), "iconCls": "x-tbar-print", "overflowText": "Drucken", "auto_save": true }, { "itemId": "do_clear_cache", "menu_item_text": "Cache l\u00f6schen", "must_save": true, "tooltip": "Cache l\u00f6schen", "panel_btn_handler": Lino.row_action_handler('do_clear_cache','GET'), "iconCls": "x-tbar-clearcache", "overflowText": "Cache l\u00f6schen", "auto_save": true }, { "itemId": "create_postings", "menu_item_text": "per Post", "must_save": true, "tooltip": "Create classical mail postings from this", "panel_btn_handler": Lino.row_action_handler('create_postings','GET'), "iconCls": "x-tbar-create-postings", "overflowText": "per Post", "auto_save": true } ],
  ls_url: "/cal/MyEvents",
  action_name: "detail",
  initComponent : function() {
    this.ls_detail_handler = Lino.cal.MyEvents.detail;
    this.ls_insert_handler = Lino.cal.MyEvents.insert;
    Lino.cal.MyEvents.detailPanel.superclass.initComponent.call(this);
  }
});

Lino.cal.MyEvents.detail = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.cal.MyEvents.detailPanel(p);
});
Lino.cal.MyEvents.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  p.params_panel = new Lino.cal.MyEvents.ParamsPanel({});
  return new Lino.cal.MyEvents.GridPanel(p);
});

// js_render_GridPanel_class cal.MyUnclearEvents
Lino.cal.MyUnclearEvents.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "Keine Daten anzuzeigen." },
  ls_url : "/cal/MyUnclearEvents",
  ls_bbar_actions : [ { "itemId": "insert", "menu_item_text": "Neu", "must_save": true, "tooltip": "Neuen Datensatz erstellen", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-new", "overflowText": "Neu", "auto_save": true }, { "itemId": "duplicate", "menu_item_text": "Duplizieren", "must_save": true, "tooltip": "Duplizieren", "panel_btn_handler": Lino.row_action_handler('duplicate','GET'), "iconCls": "x-tbar-duplicate", "overflowText": "Duplizieren", "auto_save": true }, { "itemId": "detail", "menu_item_text": "Detail", "tooltip": "Detail-Fenster auf diesem Datensatz \u00f6ffnen", "panel_btn_handler": Lino.show_detail, "iconCls": "x-tbar-detail", "overflowText": "Detail", "auto_save": true }, { "itemId": null, "menu_item_text": "L\u00f6schen", "tooltip": "Diesen Datensatz l\u00f6schen", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "L\u00f6schen", "auto_save": false }, { "itemId": "do_print", "menu_item_text": "Drucken", "must_save": true, "tooltip": "Drucken", "panel_btn_handler": Lino.row_action_handler('do_print','GET'), "iconCls": "x-tbar-print", "overflowText": "Drucken", "auto_save": true }, { "itemId": "do_clear_cache", "menu_item_text": "Cache l\u00f6schen", "must_save": true, "tooltip": "Cache l\u00f6schen", "panel_btn_handler": Lino.row_action_handler('do_clear_cache','GET'), "iconCls": "x-tbar-clearcache", "overflowText": "Cache l\u00f6schen", "auto_save": true }, { "itemId": "create_postings", "menu_item_text": "per Post", "must_save": true, "tooltip": "Create classical mail postings from this", "panel_btn_handler": Lino.row_action_handler('create_postings','GET'), "iconCls": "x-tbar-create-postings", "overflowText": "per Post", "auto_save": true } ],
  title : "Meine unklaren Termine",
  page_length : 20,
  params_panel_hidden : true,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "type": "date", "name": "start_date", "dateFormat": "d.m.Y" }, { "name": "start_time" }, { "name": "project" }, 'projectHidden', { "name": "summary" }, { "name": "workflow_buttons" }, { "type": "int", "name": "id" }, { "name": "owner_type" }, 'owner_typeHidden', { "name": "owner_id" }, 'owner_idHidden', { "name": "user" }, 'userHidden', { "name": "created" }, { "name": "modified" }, { "name": "build_time" }, { "type": "date", "name": "end_date", "dateFormat": "d.m.Y" }, { "name": "end_time" }, { "name": "description" }, { "name": "uid" }, { "name": "calendar" }, 'calendarHidden', { "name": "access_class" }, 'access_classHidden', { "type": "int", "name": "sequence" }, { "type": "int", "name": "auto_type" }, { "type": "boolean", "name": "transparent" }, { "name": "place" }, 'placeHidden', { "name": "priority" }, 'priorityHidden', { "name": "state" }, 'stateHidden', { "name": "assigned_to" }, 'assigned_toHidden', { "name": "owner" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 6,
  ls_grid_configs : [  ],
  content_type : 36,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 37,
  initComponent : function() {
    this.ls_detail_handler = Lino.cal.MyUnclearEvents.detail;
    this.ls_insert_handler = Lino.cal.MyUnclearEvents.insert;
    var ww = this.containing_window;
    var start_date2497 = new Lino.DateField({ "selectOnFocus": true });
    var start_time2498 = new Lino.TimeField({ "selectOnFocus": true });
    var project2499 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/MyUnclearEvents/project", "method": "GET" }) }), "pageSize": 20, "emptyText": "Klient ausw\u00e4hlen..." });
    var summary2500 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var workflow_buttons_disp2501 = new Ext.form.DisplayField({ "disabled": true, "value": "<br/>", "always_enabled": true });
    var id2502 = new Ext.form.NumberField({ "selectOnFocus": true });
    var owner_type2503 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/MyUnclearEvents/owner_type", "method": "GET" }) }), "pageSize": 20, "emptyText": "Inhaltstyp ausw\u00e4hlen..." });
    var owner_id2504 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/MyUnclearEvents/owner_id", "method": "GET" }) }) });
    var user2505 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/MyUnclearEvents/user", "method": "GET" }) }), "pageSize": 20, "emptyText": "Benutzer ausw\u00e4hlen..." });
    var created2506 = new Ext.form.DisplayField({ "disabled": true, "value": "<br>" });
    var modified2507 = new Ext.form.DisplayField({ "disabled": true, "value": "<br>" });
    var build_time2508 = new Ext.form.DisplayField({ "disabled": true, "value": "<br>" });
    var end_date2509 = new Lino.DateField({ "selectOnFocus": true });
    var end_time2510 = new Lino.TimeField({ "selectOnFocus": true });
    var description2511 = new Lino.RichTextPanel({ "selectOnFocus": true, "containing_panel": this, "title": "Beschreibung" });
    var uid2512 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var calendar2513 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/MyUnclearEvents/calendar", "method": "GET" }) }), "pageSize": 20, "emptyText": "Kalender ausw\u00e4hlen..." });
    var access_class2514 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "forceSelection": true, "store": Lino.cal.AccessClasses });
    var sequence2515 = new Ext.form.NumberField({ "selectOnFocus": true, "allowBlank": false, "value": 0 });
    var auto_type2516 = new Ext.form.NumberField({ "disabled": true });
    var transparent2517 = new Ext.form.Checkbox({ "selectOnFocus": true, "checked": false });
    var place2518 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/MyUnclearEvents/place", "method": "GET" }) }), "pageSize": 20, "emptyText": "Ort ausw\u00e4hlen..." });
    var priority2519 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/MyUnclearEvents/priority", "method": "GET" }) }), "pageSize": 20, "emptyText": "Priorit\u00e4t ausw\u00e4hlen..." });
    var state2520 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "forceSelection": true, "allowBlank": false, "store": Lino.cal.EventStates });
    var assigned_to2521 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/MyUnclearEvents/assigned_to", "method": "GET" }) }), "pageSize": 20, "emptyText": "Benutzer ausw\u00e4hlen..." });
    var owner_disp2522 = new Ext.form.DisplayField({ "disabled": true });
    this.before_row_edit = function(record) {
      owner_id2504.setContextValue('owner_type',record ? record.data['owner_typeHidden'] : undefined);
      description2511.refresh();
    };
    this.onRender = function(ct, position) {
      owner_type2503.on('change',Lino.chooser_handler(owner_id2504,'owner_type'));
      Lino.cal.MyUnclearEvents.GridPanel.superclass.onRender.call(this, ct, position);
    }
    this.ls_columns = [ { "colIndex": 0, "sortable": true, "xtype": "datecolumn", "format": "d.m.Y", "editable": true, "filter": { "type": "date", "dateFormat": "d.m.Y" }, "header": "Beginnt am", "editor": start_date2497, "width": Lino.chars2width(9), "dataIndex": "start_date" }, { "width": Lino.chars2width(9), "colIndex": 1, "sortable": true, "dataIndex": "start_time", "header": "Beginnt um", "editable": true, "editor": start_time2498 }, { "colIndex": 2, "sortable": true, "header": "Klient", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('projectHidden','Lino.pcsw.Clients.detail'), "editor": project2499, "dataIndex": "project" }, { "colIndex": 3, "sortable": true, "header": "Kurzbeschreibung", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "summary", "editor": summary2500 }, { "width": Lino.chars2width(31), "colIndex": 4, "sortable": false, "dataIndex": "workflow_buttons", "header": "Arbeitsablauf", "editable": false }, new Lino.NullNumberColumn({ "colIndex": 5, "sortable": true, "format": "0", "editable": true, "filter": { "type": "numeric" }, "header": "ID", "renderer": Lino.id_renderer, "editor": id2502, "width": Lino.chars2width(6), "dataIndex": "id" }), { "colIndex": 6, "sortable": true, "header": "Verkn\u00fcpft mit (Modell)", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('owner_typeHidden','Lino.ui.ContentTypes.detail'), "hidden": true, "editor": owner_type2503, "dataIndex": "owner_type" }, { "colIndex": 7, "sortable": true, "header": "Verkn\u00fcpft mit (Objekt)", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(11), "dataIndex": "owner_id", "hidden": true, "editor": owner_id2504 }, { "colIndex": 8, "sortable": true, "header": "Verantwortlicher", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(16), "dataIndex": "user", "editor": user2505 }, { "width": Lino.chars2width(17), "colIndex": 9, "sortable": true, "dataIndex": "created", "header": "Erstellt", "hidden": true, "editable": false }, { "width": Lino.chars2width(17), "colIndex": 10, "sortable": true, "dataIndex": "modified", "header": "Bearbeitet", "hidden": true, "editable": false }, { "width": Lino.chars2width(17), "colIndex": 11, "sortable": true, "dataIndex": "build_time", "header": "Druckdatum", "hidden": true, "editable": false }, { "colIndex": 12, "sortable": true, "xtype": "datecolumn", "format": "d.m.Y", "editable": true, "filter": { "type": "date", "dateFormat": "d.m.Y" }, "header": "Endet am", "dataIndex": "end_date", "hidden": true, "width": Lino.chars2width(9), "editor": end_date2509 }, { "colIndex": 13, "sortable": true, "header": "Endet um", "editable": true, "width": Lino.chars2width(9), "dataIndex": "end_time", "hidden": true, "editor": end_time2510 }, { "colIndex": 14, "sortable": false, "header": "description", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(61), "renderer": Lino.text_renderer, "hidden": true, "editor": description2511, "dataIndex": "description" }, { "colIndex": 15, "sortable": true, "header": "UID", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "uid", "hidden": true, "editor": uid2512 }, { "colIndex": 16, "sortable": true, "header": "Kalender", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "calendar", "editor": calendar2513 }, { "colIndex": 17, "sortable": true, "header": "Zugriffsklasse", "editable": true, "tooltip": "Ob dieser Termin  privat, \u00f6ffentlich oder halb \u00f6ffentlich ist", "filter": { "type": "string" }, "width": Lino.chars2width(35), "dataIndex": "access_class", "hidden": true, "editor": access_class2514 }, new Lino.NullNumberColumn({ "colIndex": 18, "sortable": true, "format": "0", "editable": true, "filter": { "type": "numeric" }, "header": "Revisionsnummer", "dataIndex": "sequence", "hidden": true, "width": Lino.chars2width(6), "editor": sequence2515 }), new Lino.NullNumberColumn({ "colIndex": 19, "sortable": true, "format": "0", "editable": false, "filter": { "type": "numeric" }, "header": "auto type", "dataIndex": "auto_type", "hidden": true, "width": Lino.chars2width(6) }), { "colIndex": 20, "sortable": false, "xtype": "checkcolumn", "header": "nicht blockierend", "editable": true, "tooltip": "Dieser Termin l\u00e4sst auch andere Termine zur gleichen Zeit zu.", "filter": { "type": "boolean" }, "width": Lino.chars2width(11), "dataIndex": "transparent", "hidden": true }, { "colIndex": 21, "sortable": true, "header": "Ort", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('placeHidden','Lino.cal.Places.detail'), "hidden": true, "editor": place2518, "dataIndex": "place" }, { "colIndex": 22, "sortable": true, "header": "Priorit\u00e4t", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "priority", "hidden": true, "editor": priority2519 }, { "colIndex": 23, "sortable": true, "header": "Zustand", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(17), "dataIndex": "state", "editor": state2520 }, { "colIndex": 24, "sortable": true, "header": "Zugewiesen zu", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(16), "dataIndex": "assigned_to", "editor": assigned_to2521 }, { "width": Lino.chars2width(11), "colIndex": 25, "sortable": false, "dataIndex": "owner", "header": "Verkn\u00fcpft mit", "hidden": true, "editable": false } ];
    Lino.cal.MyUnclearEvents.GridPanel.superclass.initComponent.call(this);
  }
});


Lino.cal.MyUnclearEvents.insertPanel = Ext.extend(Lino.cal.MyEvents.InsertFormPanel,{
  empty_title: "Neu Meine unklaren Termine",
  hide_navigator: true,
  params_panel_hidden: true,
  ls_bbar_actions: [ { "itemId": "post", "menu_item_text": "Erstellen", "tooltip": "Datensatz erstellen und dann im Detail-Fenster \u00f6ffnen", "panel_btn_handler": function(panel){panel.save(null,true,'post')}, "text": "Erstellen", "overflowText": "Erstellen", "auto_save": false }, { "itemId": "poststay", "menu_item_text": "Erstellen ohne Detail", "tooltip": "Nach Erstellen des Datensatzes kein Detail-Fenster \u00f6ffnen", "panel_btn_handler": function(panel){panel.save(null,false,'poststay')}, "text": "Erstellen ohne Detail", "overflowText": "Erstellen ohne Detail", "auto_save": false } ],
  ls_url: "/cal/MyUnclearEvents",
  action_name: "insert",
  initComponent : function() {
    this.ls_detail_handler = Lino.cal.MyUnclearEvents.detail;
    this.ls_insert_handler = Lino.cal.MyUnclearEvents.insert;
    Lino.cal.MyUnclearEvents.insertPanel.superclass.initComponent.call(this);
  }
});

Lino.cal.MyUnclearEvents.insert = new Lino.WindowAction({ "draggable": true, "width": Lino.chars2width(60), "autoHeight": true, "maximizable": true, "modal": true, "maximized": false },function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.cal.MyUnclearEvents.insertPanel(p);
});
Lino.cal.MyUnclearEvents.wf1 = function(rp,pk) { 
  Lino.run_row_action(rp,"/cal/MyUnclearEvents",pk,"wf1");
};
Lino.cal.MyUnclearEvents.wf2 = function(rp,pk) { 
  Lino.run_row_action(rp,"/cal/MyUnclearEvents",pk,"wf2");
};
Lino.cal.MyUnclearEvents.wf3 = function(rp,pk) { 
  Lino.run_row_action(rp,"/cal/MyUnclearEvents",pk,"wf3");
};
Lino.cal.MyUnclearEvents.wf4 = function(rp,pk) { 
  Lino.run_row_action(rp,"/cal/MyUnclearEvents",pk,"wf4");
};
Lino.cal.MyUnclearEvents.wf5 = function(rp,pk) { 
  Lino.run_row_action(rp,"/cal/MyUnclearEvents",pk,"wf5");
};
Lino.cal.MyUnclearEvents.wf6 = function(rp,pk) { 
  Lino.run_row_action(rp,"/cal/MyUnclearEvents",pk,"wf6");
};
Lino.cal.MyUnclearEvents.wf7 = function(rp,pk) { 
  Lino.run_row_action(rp,"/cal/MyUnclearEvents",pk,"wf7");
};
Lino.cal.MyUnclearEvents.wf8 = function(rp,pk) { 
  Lino.run_row_action(rp,"/cal/MyUnclearEvents",pk,"wf8");
};

Lino.cal.MyUnclearEvents.detailPanel = Ext.extend(Lino.cal.MyEvents.DetailFormPanel,{
  empty_title: "Detail Meine unklaren Termine",
  params_panel_hidden: true,
  ls_bbar_actions: [ { "itemId": "put", "menu_item_text": "Speichern", "tooltip": "\u00c4nderungen in diesem Formular speichern", "panel_btn_handler": function(panel){panel.save(null,false,'put')}, "iconCls": "x-tbar-save", "overflowText": "Speichern", "auto_save": false }, { "itemId": "insert", "menu_item_text": "Neu", "must_save": true, "tooltip": "Neuen Datensatz erstellen", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-new", "overflowText": "Neu", "auto_save": true }, { "itemId": "duplicate", "menu_item_text": "Duplizieren", "must_save": true, "tooltip": "Duplizieren", "panel_btn_handler": Lino.row_action_handler('duplicate','GET'), "iconCls": "x-tbar-duplicate", "overflowText": "Duplizieren", "auto_save": true }, { "itemId": null, "menu_item_text": "L\u00f6schen", "tooltip": "Diesen Datensatz l\u00f6schen", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "L\u00f6schen", "auto_save": false }, { "itemId": "do_print", "menu_item_text": "Drucken", "must_save": true, "tooltip": "Drucken", "panel_btn_handler": Lino.row_action_handler('do_print','GET'), "iconCls": "x-tbar-print", "overflowText": "Drucken", "auto_save": true }, { "itemId": "do_clear_cache", "menu_item_text": "Cache l\u00f6schen", "must_save": true, "tooltip": "Cache l\u00f6schen", "panel_btn_handler": Lino.row_action_handler('do_clear_cache','GET'), "iconCls": "x-tbar-clearcache", "overflowText": "Cache l\u00f6schen", "auto_save": true }, { "itemId": "create_postings", "menu_item_text": "per Post", "must_save": true, "tooltip": "Create classical mail postings from this", "panel_btn_handler": Lino.row_action_handler('create_postings','GET'), "iconCls": "x-tbar-create-postings", "overflowText": "per Post", "auto_save": true } ],
  ls_url: "/cal/MyUnclearEvents",
  action_name: "detail",
  initComponent : function() {
    this.ls_detail_handler = Lino.cal.MyUnclearEvents.detail;
    this.ls_insert_handler = Lino.cal.MyUnclearEvents.insert;
    Lino.cal.MyUnclearEvents.detailPanel.superclass.initComponent.call(this);
  }
});

Lino.cal.MyUnclearEvents.detail = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.cal.MyUnclearEvents.detailPanel(p);
});
Lino.cal.MyUnclearEvents.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  p.params_panel = new Lino.cal.MyEvents.ParamsPanel({});
  return new Lino.cal.MyUnclearEvents.GridPanel(p);
});

// js_render_GridPanel_class cal.EventsAssignedToMe
Lino.cal.EventsAssignedToMe.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "Keine Daten anzuzeigen." },
  ls_url : "/cal/EventsAssignedToMe",
  ls_bbar_actions : [ { "itemId": "insert", "menu_item_text": "Neu", "must_save": true, "tooltip": "Neuen Datensatz erstellen", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-new", "overflowText": "Neu", "auto_save": true }, { "itemId": "duplicate", "menu_item_text": "Duplizieren", "must_save": true, "tooltip": "Duplizieren", "panel_btn_handler": Lino.row_action_handler('duplicate','GET'), "iconCls": "x-tbar-duplicate", "overflowText": "Duplizieren", "auto_save": true }, { "itemId": "detail", "menu_item_text": "Detail", "tooltip": "Detail-Fenster auf diesem Datensatz \u00f6ffnen", "panel_btn_handler": Lino.show_detail, "iconCls": "x-tbar-detail", "overflowText": "Detail", "auto_save": true }, { "itemId": null, "menu_item_text": "L\u00f6schen", "tooltip": "Diesen Datensatz l\u00f6schen", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "L\u00f6schen", "auto_save": false }, { "itemId": "do_print", "menu_item_text": "Drucken", "must_save": true, "tooltip": "Drucken", "panel_btn_handler": Lino.row_action_handler('do_print','GET'), "iconCls": "x-tbar-print", "overflowText": "Drucken", "auto_save": true }, { "itemId": "do_clear_cache", "menu_item_text": "Cache l\u00f6schen", "must_save": true, "tooltip": "Cache l\u00f6schen", "panel_btn_handler": Lino.row_action_handler('do_clear_cache','GET'), "iconCls": "x-tbar-clearcache", "overflowText": "Cache l\u00f6schen", "auto_save": true }, { "itemId": "create_postings", "menu_item_text": "per Post", "must_save": true, "tooltip": "Create classical mail postings from this", "panel_btn_handler": Lino.row_action_handler('create_postings','GET'), "iconCls": "x-tbar-create-postings", "overflowText": "per Post", "auto_save": true } ],
  title : "Termine",
  page_length : 20,
  params_panel_hidden : true,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "type": "date", "name": "start_date", "dateFormat": "d.m.Y" }, { "name": "start_time" }, { "name": "project" }, 'projectHidden', { "name": "summary" }, { "name": "workflow_buttons" }, { "type": "int", "name": "id" }, { "name": "owner_type" }, 'owner_typeHidden', { "name": "owner_id" }, 'owner_idHidden', { "name": "user" }, 'userHidden', { "name": "created" }, { "name": "modified" }, { "name": "build_time" }, { "type": "date", "name": "end_date", "dateFormat": "d.m.Y" }, { "name": "end_time" }, { "name": "description" }, { "name": "uid" }, { "name": "calendar" }, 'calendarHidden', { "name": "access_class" }, 'access_classHidden', { "type": "int", "name": "sequence" }, { "type": "int", "name": "auto_type" }, { "type": "boolean", "name": "transparent" }, { "name": "place" }, 'placeHidden', { "name": "priority" }, 'priorityHidden', { "name": "state" }, 'stateHidden', { "name": "assigned_to" }, 'assigned_toHidden', { "name": "owner" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 6,
  ls_grid_configs : [  ],
  content_type : 36,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 37,
  initComponent : function() {
    this.ls_detail_handler = Lino.cal.EventsAssignedToMe.detail;
    this.ls_insert_handler = Lino.cal.EventsAssignedToMe.insert;
    var ww = this.containing_window;
    var start_date2524 = new Lino.DateField({ "selectOnFocus": true });
    var start_time2525 = new Lino.TimeField({ "selectOnFocus": true });
    var project2526 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/EventsAssignedToMe/project", "method": "GET" }) }), "pageSize": 20, "emptyText": "Klient ausw\u00e4hlen..." });
    var summary2527 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var workflow_buttons_disp2528 = new Ext.form.DisplayField({ "disabled": true, "value": "<br/>", "always_enabled": true });
    var id2529 = new Ext.form.NumberField({ "selectOnFocus": true });
    var owner_type2530 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/EventsAssignedToMe/owner_type", "method": "GET" }) }), "pageSize": 20, "emptyText": "Inhaltstyp ausw\u00e4hlen..." });
    var owner_id2531 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/EventsAssignedToMe/owner_id", "method": "GET" }) }) });
    var user2532 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/EventsAssignedToMe/user", "method": "GET" }) }), "pageSize": 20, "emptyText": "Benutzer ausw\u00e4hlen..." });
    var created2533 = new Ext.form.DisplayField({ "disabled": true, "value": "<br>" });
    var modified2534 = new Ext.form.DisplayField({ "disabled": true, "value": "<br>" });
    var build_time2535 = new Ext.form.DisplayField({ "disabled": true, "value": "<br>" });
    var end_date2536 = new Lino.DateField({ "selectOnFocus": true });
    var end_time2537 = new Lino.TimeField({ "selectOnFocus": true });
    var description2538 = new Lino.RichTextPanel({ "selectOnFocus": true, "containing_panel": this, "title": "Beschreibung" });
    var uid2539 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var calendar2540 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/EventsAssignedToMe/calendar", "method": "GET" }) }), "pageSize": 20, "emptyText": "Kalender ausw\u00e4hlen..." });
    var access_class2541 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "forceSelection": true, "store": Lino.cal.AccessClasses });
    var sequence2542 = new Ext.form.NumberField({ "selectOnFocus": true, "allowBlank": false, "value": 0 });
    var auto_type2543 = new Ext.form.NumberField({ "disabled": true });
    var transparent2544 = new Ext.form.Checkbox({ "selectOnFocus": true, "checked": false });
    var place2545 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/EventsAssignedToMe/place", "method": "GET" }) }), "pageSize": 20, "emptyText": "Ort ausw\u00e4hlen..." });
    var priority2546 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/EventsAssignedToMe/priority", "method": "GET" }) }), "pageSize": 20, "emptyText": "Priorit\u00e4t ausw\u00e4hlen..." });
    var state2547 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "forceSelection": true, "allowBlank": false, "store": Lino.cal.EventStates });
    var assigned_to2548 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/EventsAssignedToMe/assigned_to", "method": "GET" }) }), "pageSize": 20, "emptyText": "Benutzer ausw\u00e4hlen..." });
    var owner_disp2549 = new Ext.form.DisplayField({ "disabled": true });
    this.before_row_edit = function(record) {
      owner_id2531.setContextValue('owner_type',record ? record.data['owner_typeHidden'] : undefined);
      description2538.refresh();
    };
    this.onRender = function(ct, position) {
      owner_type2530.on('change',Lino.chooser_handler(owner_id2531,'owner_type'));
      Lino.cal.EventsAssignedToMe.GridPanel.superclass.onRender.call(this, ct, position);
    }
    this.ls_columns = [ { "colIndex": 0, "sortable": true, "xtype": "datecolumn", "format": "d.m.Y", "editable": true, "filter": { "type": "date", "dateFormat": "d.m.Y" }, "header": "Beginnt am", "editor": start_date2524, "width": Lino.chars2width(9), "dataIndex": "start_date" }, { "width": Lino.chars2width(9), "colIndex": 1, "sortable": true, "dataIndex": "start_time", "header": "Beginnt um", "editable": true, "editor": start_time2525 }, { "colIndex": 2, "sortable": true, "header": "Klient", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('projectHidden','Lino.pcsw.Clients.detail'), "editor": project2526, "dataIndex": "project" }, { "colIndex": 3, "sortable": true, "header": "Kurzbeschreibung", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "summary", "editor": summary2527 }, { "width": Lino.chars2width(31), "colIndex": 4, "sortable": false, "dataIndex": "workflow_buttons", "header": "Arbeitsablauf", "editable": false }, new Lino.NullNumberColumn({ "colIndex": 5, "sortable": true, "format": "0", "editable": true, "filter": { "type": "numeric" }, "header": "ID", "renderer": Lino.id_renderer, "editor": id2529, "width": Lino.chars2width(6), "dataIndex": "id" }), { "colIndex": 6, "sortable": true, "header": "Verkn\u00fcpft mit (Modell)", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('owner_typeHidden','Lino.ui.ContentTypes.detail'), "hidden": true, "editor": owner_type2530, "dataIndex": "owner_type" }, { "colIndex": 7, "sortable": true, "header": "Verkn\u00fcpft mit (Objekt)", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(11), "dataIndex": "owner_id", "hidden": true, "editor": owner_id2531 }, { "colIndex": 8, "sortable": true, "header": "Verantwortlicher", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(16), "dataIndex": "user", "editor": user2532 }, { "width": Lino.chars2width(17), "colIndex": 9, "sortable": true, "dataIndex": "created", "header": "Erstellt", "hidden": true, "editable": false }, { "width": Lino.chars2width(17), "colIndex": 10, "sortable": true, "dataIndex": "modified", "header": "Bearbeitet", "hidden": true, "editable": false }, { "width": Lino.chars2width(17), "colIndex": 11, "sortable": true, "dataIndex": "build_time", "header": "Druckdatum", "hidden": true, "editable": false }, { "colIndex": 12, "sortable": true, "xtype": "datecolumn", "format": "d.m.Y", "editable": true, "filter": { "type": "date", "dateFormat": "d.m.Y" }, "header": "Endet am", "dataIndex": "end_date", "hidden": true, "width": Lino.chars2width(9), "editor": end_date2536 }, { "colIndex": 13, "sortable": true, "header": "Endet um", "editable": true, "width": Lino.chars2width(9), "dataIndex": "end_time", "hidden": true, "editor": end_time2537 }, { "colIndex": 14, "sortable": false, "header": "description", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(61), "renderer": Lino.text_renderer, "hidden": true, "editor": description2538, "dataIndex": "description" }, { "colIndex": 15, "sortable": true, "header": "UID", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "uid", "hidden": true, "editor": uid2539 }, { "colIndex": 16, "sortable": true, "header": "Kalender", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "calendar", "editor": calendar2540 }, { "colIndex": 17, "sortable": true, "header": "Zugriffsklasse", "editable": true, "tooltip": "Ob dieser Termin  privat, \u00f6ffentlich oder halb \u00f6ffentlich ist", "filter": { "type": "string" }, "width": Lino.chars2width(35), "dataIndex": "access_class", "hidden": true, "editor": access_class2541 }, new Lino.NullNumberColumn({ "colIndex": 18, "sortable": true, "format": "0", "editable": true, "filter": { "type": "numeric" }, "header": "Revisionsnummer", "dataIndex": "sequence", "hidden": true, "width": Lino.chars2width(6), "editor": sequence2542 }), new Lino.NullNumberColumn({ "colIndex": 19, "sortable": true, "format": "0", "editable": false, "filter": { "type": "numeric" }, "header": "auto type", "dataIndex": "auto_type", "hidden": true, "width": Lino.chars2width(6) }), { "colIndex": 20, "sortable": false, "xtype": "checkcolumn", "header": "nicht blockierend", "editable": true, "tooltip": "Dieser Termin l\u00e4sst auch andere Termine zur gleichen Zeit zu.", "filter": { "type": "boolean" }, "width": Lino.chars2width(11), "dataIndex": "transparent", "hidden": true }, { "colIndex": 21, "sortable": true, "header": "Ort", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('placeHidden','Lino.cal.Places.detail'), "hidden": true, "editor": place2545, "dataIndex": "place" }, { "colIndex": 22, "sortable": true, "header": "Priorit\u00e4t", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "priority", "hidden": true, "editor": priority2546 }, { "colIndex": 23, "sortable": true, "header": "Zustand", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(17), "dataIndex": "state", "editor": state2547 }, { "colIndex": 24, "sortable": true, "header": "Zugewiesen zu", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(16), "dataIndex": "assigned_to", "editor": assigned_to2548 }, { "width": Lino.chars2width(11), "colIndex": 25, "sortable": false, "dataIndex": "owner", "header": "Verkn\u00fcpft mit", "hidden": true, "editable": false } ];
    Lino.cal.EventsAssignedToMe.GridPanel.superclass.initComponent.call(this);
  }
});


Lino.cal.EventsAssignedToMe.insertPanel = Ext.extend(Lino.cal.MyEvents.InsertFormPanel,{
  empty_title: "Neu Termine",
  hide_navigator: true,
  params_panel_hidden: true,
  ls_bbar_actions: [ { "itemId": "post", "menu_item_text": "Erstellen", "tooltip": "Datensatz erstellen und dann im Detail-Fenster \u00f6ffnen", "panel_btn_handler": function(panel){panel.save(null,true,'post')}, "text": "Erstellen", "overflowText": "Erstellen", "auto_save": false }, { "itemId": "poststay", "menu_item_text": "Erstellen ohne Detail", "tooltip": "Nach Erstellen des Datensatzes kein Detail-Fenster \u00f6ffnen", "panel_btn_handler": function(panel){panel.save(null,false,'poststay')}, "text": "Erstellen ohne Detail", "overflowText": "Erstellen ohne Detail", "auto_save": false } ],
  ls_url: "/cal/EventsAssignedToMe",
  action_name: "insert",
  initComponent : function() {
    this.ls_detail_handler = Lino.cal.EventsAssignedToMe.detail;
    this.ls_insert_handler = Lino.cal.EventsAssignedToMe.insert;
    Lino.cal.EventsAssignedToMe.insertPanel.superclass.initComponent.call(this);
  }
});

Lino.cal.EventsAssignedToMe.insert = new Lino.WindowAction({ "draggable": true, "width": Lino.chars2width(60), "autoHeight": true, "maximizable": true, "modal": true, "maximized": false },function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.cal.EventsAssignedToMe.insertPanel(p);
});
Lino.cal.EventsAssignedToMe.wf1 = function(rp,pk) { 
  Lino.run_row_action(rp,"/cal/EventsAssignedToMe",pk,"wf1");
};
Lino.cal.EventsAssignedToMe.wf2 = function(rp,pk) { 
  Lino.run_row_action(rp,"/cal/EventsAssignedToMe",pk,"wf2");
};
Lino.cal.EventsAssignedToMe.wf3 = function(rp,pk) { 
  Lino.run_row_action(rp,"/cal/EventsAssignedToMe",pk,"wf3");
};
Lino.cal.EventsAssignedToMe.wf4 = function(rp,pk) { 
  Lino.run_row_action(rp,"/cal/EventsAssignedToMe",pk,"wf4");
};
Lino.cal.EventsAssignedToMe.wf5 = function(rp,pk) { 
  Lino.run_row_action(rp,"/cal/EventsAssignedToMe",pk,"wf5");
};
Lino.cal.EventsAssignedToMe.wf6 = function(rp,pk) { 
  Lino.run_row_action(rp,"/cal/EventsAssignedToMe",pk,"wf6");
};
Lino.cal.EventsAssignedToMe.wf7 = function(rp,pk) { 
  Lino.run_row_action(rp,"/cal/EventsAssignedToMe",pk,"wf7");
};
Lino.cal.EventsAssignedToMe.wf8 = function(rp,pk) { 
  Lino.run_row_action(rp,"/cal/EventsAssignedToMe",pk,"wf8");
};

Lino.cal.EventsAssignedToMe.detailPanel = Ext.extend(Lino.cal.MyEvents.DetailFormPanel,{
  empty_title: "Detail Termine",
  params_panel_hidden: true,
  ls_bbar_actions: [ { "itemId": "put", "menu_item_text": "Speichern", "tooltip": "\u00c4nderungen in diesem Formular speichern", "panel_btn_handler": function(panel){panel.save(null,false,'put')}, "iconCls": "x-tbar-save", "overflowText": "Speichern", "auto_save": false }, { "itemId": "insert", "menu_item_text": "Neu", "must_save": true, "tooltip": "Neuen Datensatz erstellen", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-new", "overflowText": "Neu", "auto_save": true }, { "itemId": "duplicate", "menu_item_text": "Duplizieren", "must_save": true, "tooltip": "Duplizieren", "panel_btn_handler": Lino.row_action_handler('duplicate','GET'), "iconCls": "x-tbar-duplicate", "overflowText": "Duplizieren", "auto_save": true }, { "itemId": null, "menu_item_text": "L\u00f6schen", "tooltip": "Diesen Datensatz l\u00f6schen", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "L\u00f6schen", "auto_save": false }, { "itemId": "do_print", "menu_item_text": "Drucken", "must_save": true, "tooltip": "Drucken", "panel_btn_handler": Lino.row_action_handler('do_print','GET'), "iconCls": "x-tbar-print", "overflowText": "Drucken", "auto_save": true }, { "itemId": "do_clear_cache", "menu_item_text": "Cache l\u00f6schen", "must_save": true, "tooltip": "Cache l\u00f6schen", "panel_btn_handler": Lino.row_action_handler('do_clear_cache','GET'), "iconCls": "x-tbar-clearcache", "overflowText": "Cache l\u00f6schen", "auto_save": true }, { "itemId": "create_postings", "menu_item_text": "per Post", "must_save": true, "tooltip": "Create classical mail postings from this", "panel_btn_handler": Lino.row_action_handler('create_postings','GET'), "iconCls": "x-tbar-create-postings", "overflowText": "per Post", "auto_save": true } ],
  ls_url: "/cal/EventsAssignedToMe",
  action_name: "detail",
  initComponent : function() {
    this.ls_detail_handler = Lino.cal.EventsAssignedToMe.detail;
    this.ls_insert_handler = Lino.cal.EventsAssignedToMe.insert;
    Lino.cal.EventsAssignedToMe.detailPanel.superclass.initComponent.call(this);
  }
});

Lino.cal.EventsAssignedToMe.detail = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.cal.EventsAssignedToMe.detailPanel(p);
});
Lino.cal.EventsAssignedToMe.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  p.params_panel = new Lino.cal.MyEvents.ParamsPanel({});
  return new Lino.cal.EventsAssignedToMe.GridPanel(p);
});

// js_render_GridPanel_class cal.MyEventsToday
Lino.cal.MyEventsToday.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "Keine Daten anzuzeigen." },
  ls_url : "/cal/MyEventsToday",
  ls_bbar_actions : [ { "itemId": "insert", "menu_item_text": "Neu", "must_save": true, "tooltip": "Neuen Datensatz erstellen", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-new", "overflowText": "Neu", "auto_save": true }, { "itemId": "duplicate", "menu_item_text": "Duplizieren", "must_save": true, "tooltip": "Duplizieren", "panel_btn_handler": Lino.row_action_handler('duplicate','GET'), "iconCls": "x-tbar-duplicate", "overflowText": "Duplizieren", "auto_save": true }, { "itemId": "detail", "menu_item_text": "Detail", "tooltip": "Detail-Fenster auf diesem Datensatz \u00f6ffnen", "panel_btn_handler": Lino.show_detail, "iconCls": "x-tbar-detail", "overflowText": "Detail", "auto_save": true }, { "itemId": null, "menu_item_text": "L\u00f6schen", "tooltip": "Diesen Datensatz l\u00f6schen", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "L\u00f6schen", "auto_save": false }, { "itemId": "do_print", "menu_item_text": "Drucken", "must_save": true, "tooltip": "Drucken", "panel_btn_handler": Lino.row_action_handler('do_print','GET'), "iconCls": "x-tbar-print", "overflowText": "Drucken", "auto_save": true }, { "itemId": "do_clear_cache", "menu_item_text": "Cache l\u00f6schen", "must_save": true, "tooltip": "Cache l\u00f6schen", "panel_btn_handler": Lino.row_action_handler('do_clear_cache','GET'), "iconCls": "x-tbar-clearcache", "overflowText": "Cache l\u00f6schen", "auto_save": true }, { "itemId": "create_postings", "menu_item_text": "per Post", "must_save": true, "tooltip": "Create classical mail postings from this", "panel_btn_handler": Lino.row_action_handler('create_postings','GET'), "iconCls": "x-tbar-create-postings", "overflowText": "per Post", "auto_save": true } ],
  title : "Meine Termine heute",
  page_length : 20,
  params_panel_hidden : true,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "name": "start_time" }, { "name": "summary" }, { "name": "workflow_buttons" }, { "type": "int", "name": "id" }, { "name": "owner_type" }, 'owner_typeHidden', { "name": "owner_id" }, 'owner_idHidden', { "name": "user" }, 'userHidden', { "name": "created" }, { "name": "modified" }, { "name": "project" }, 'projectHidden', { "name": "build_time" }, { "type": "date", "name": "start_date", "dateFormat": "d.m.Y" }, { "type": "date", "name": "end_date", "dateFormat": "d.m.Y" }, { "name": "end_time" }, { "name": "description" }, { "name": "uid" }, { "name": "calendar" }, 'calendarHidden', { "name": "access_class" }, 'access_classHidden', { "type": "int", "name": "sequence" }, { "type": "int", "name": "auto_type" }, { "type": "boolean", "name": "transparent" }, { "name": "place" }, 'placeHidden', { "name": "priority" }, 'priorityHidden', { "name": "state" }, 'stateHidden', { "name": "assigned_to" }, 'assigned_toHidden', { "name": "owner" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 3,
  ls_grid_configs : [  ],
  content_type : 36,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 37,
  initComponent : function() {
    this.ls_detail_handler = Lino.cal.MyEventsToday.detail;
    this.ls_insert_handler = Lino.cal.MyEventsToday.insert;
    var ww = this.containing_window;
    var start_time2551 = new Lino.TimeField({ "selectOnFocus": true });
    var summary2552 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var workflow_buttons_disp2553 = new Ext.form.DisplayField({ "disabled": true, "value": "<br/>", "always_enabled": true });
    var id2554 = new Ext.form.NumberField({ "selectOnFocus": true });
    var owner_type2555 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/MyEventsToday/owner_type", "method": "GET" }) }), "pageSize": 20, "emptyText": "Inhaltstyp ausw\u00e4hlen..." });
    var owner_id2556 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/MyEventsToday/owner_id", "method": "GET" }) }) });
    var user2557 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/MyEventsToday/user", "method": "GET" }) }), "pageSize": 20, "emptyText": "Benutzer ausw\u00e4hlen..." });
    var created2558 = new Ext.form.DisplayField({ "disabled": true, "value": "<br>" });
    var modified2559 = new Ext.form.DisplayField({ "disabled": true, "value": "<br>" });
    var project2560 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/MyEventsToday/project", "method": "GET" }) }), "pageSize": 20, "emptyText": "Klient ausw\u00e4hlen..." });
    var build_time2561 = new Ext.form.DisplayField({ "disabled": true, "value": "<br>" });
    var start_date2562 = new Lino.DateField({ "selectOnFocus": true });
    var end_date2563 = new Lino.DateField({ "selectOnFocus": true });
    var end_time2564 = new Lino.TimeField({ "selectOnFocus": true });
    var description2565 = new Lino.RichTextPanel({ "selectOnFocus": true, "containing_panel": this, "title": "Beschreibung" });
    var uid2566 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var calendar2567 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/MyEventsToday/calendar", "method": "GET" }) }), "pageSize": 20, "emptyText": "Kalender ausw\u00e4hlen..." });
    var access_class2568 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "forceSelection": true, "store": Lino.cal.AccessClasses });
    var sequence2569 = new Ext.form.NumberField({ "selectOnFocus": true, "allowBlank": false, "value": 0 });
    var auto_type2570 = new Ext.form.NumberField({ "disabled": true });
    var transparent2571 = new Ext.form.Checkbox({ "selectOnFocus": true, "checked": false });
    var place2572 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/MyEventsToday/place", "method": "GET" }) }), "pageSize": 20, "emptyText": "Ort ausw\u00e4hlen..." });
    var priority2573 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/MyEventsToday/priority", "method": "GET" }) }), "pageSize": 20, "emptyText": "Priorit\u00e4t ausw\u00e4hlen..." });
    var state2574 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "forceSelection": true, "allowBlank": false, "store": Lino.cal.EventStates });
    var assigned_to2575 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/MyEventsToday/assigned_to", "method": "GET" }) }), "pageSize": 20, "emptyText": "Benutzer ausw\u00e4hlen..." });
    var owner_disp2576 = new Ext.form.DisplayField({ "disabled": true });
    this.before_row_edit = function(record) {
      owner_id2556.setContextValue('owner_type',record ? record.data['owner_typeHidden'] : undefined);
      description2565.refresh();
    };
    this.onRender = function(ct, position) {
      owner_type2555.on('change',Lino.chooser_handler(owner_id2556,'owner_type'));
      Lino.cal.MyEventsToday.GridPanel.superclass.onRender.call(this, ct, position);
    }
    this.ls_columns = [ { "width": Lino.chars2width(9), "colIndex": 0, "sortable": true, "dataIndex": "start_time", "header": "Beginnt um", "editable": true, "editor": start_time2551 }, { "colIndex": 1, "sortable": true, "header": "Kurzbeschreibung", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "summary", "editor": summary2552 }, { "width": Lino.chars2width(31), "colIndex": 2, "sortable": false, "dataIndex": "workflow_buttons", "header": "Arbeitsablauf", "editable": false }, new Lino.NullNumberColumn({ "colIndex": 3, "sortable": true, "format": "0", "editable": true, "filter": { "type": "numeric" }, "header": "ID", "renderer": Lino.id_renderer, "editor": id2554, "width": Lino.chars2width(6), "dataIndex": "id" }), { "colIndex": 4, "sortable": true, "header": "Verkn\u00fcpft mit (Modell)", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('owner_typeHidden','Lino.ui.ContentTypes.detail'), "hidden": true, "editor": owner_type2555, "dataIndex": "owner_type" }, { "colIndex": 5, "sortable": true, "header": "Verkn\u00fcpft mit (Objekt)", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(11), "dataIndex": "owner_id", "hidden": true, "editor": owner_id2556 }, { "colIndex": 6, "sortable": true, "header": "Verantwortlicher", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(16), "dataIndex": "user", "editor": user2557 }, { "width": Lino.chars2width(17), "colIndex": 7, "sortable": true, "dataIndex": "created", "header": "Erstellt", "hidden": true, "editable": false }, { "width": Lino.chars2width(17), "colIndex": 8, "sortable": true, "dataIndex": "modified", "header": "Bearbeitet", "hidden": true, "editable": false }, { "colIndex": 9, "sortable": true, "header": "Klient", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('projectHidden','Lino.pcsw.Clients.detail'), "editor": project2560, "dataIndex": "project" }, { "width": Lino.chars2width(17), "colIndex": 10, "sortable": true, "dataIndex": "build_time", "header": "Druckdatum", "hidden": true, "editable": false }, { "colIndex": 11, "sortable": true, "xtype": "datecolumn", "format": "d.m.Y", "editable": true, "filter": { "type": "date", "dateFormat": "d.m.Y" }, "header": "Beginnt am", "editor": start_date2562, "width": Lino.chars2width(9), "dataIndex": "start_date" }, { "colIndex": 12, "sortable": true, "xtype": "datecolumn", "format": "d.m.Y", "editable": true, "filter": { "type": "date", "dateFormat": "d.m.Y" }, "header": "Endet am", "dataIndex": "end_date", "hidden": true, "width": Lino.chars2width(9), "editor": end_date2563 }, { "colIndex": 13, "sortable": true, "header": "Endet um", "editable": true, "width": Lino.chars2width(9), "dataIndex": "end_time", "hidden": true, "editor": end_time2564 }, { "colIndex": 14, "sortable": false, "header": "description", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(61), "renderer": Lino.text_renderer, "hidden": true, "editor": description2565, "dataIndex": "description" }, { "colIndex": 15, "sortable": true, "header": "UID", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "uid", "hidden": true, "editor": uid2566 }, { "colIndex": 16, "sortable": true, "header": "Kalender", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "calendar", "editor": calendar2567 }, { "colIndex": 17, "sortable": true, "header": "Zugriffsklasse", "editable": true, "tooltip": "Ob dieser Termin  privat, \u00f6ffentlich oder halb \u00f6ffentlich ist", "filter": { "type": "string" }, "width": Lino.chars2width(35), "dataIndex": "access_class", "hidden": true, "editor": access_class2568 }, new Lino.NullNumberColumn({ "colIndex": 18, "sortable": true, "format": "0", "editable": true, "filter": { "type": "numeric" }, "header": "Revisionsnummer", "dataIndex": "sequence", "hidden": true, "width": Lino.chars2width(6), "editor": sequence2569 }), new Lino.NullNumberColumn({ "colIndex": 19, "sortable": true, "format": "0", "editable": false, "filter": { "type": "numeric" }, "header": "auto type", "dataIndex": "auto_type", "hidden": true, "width": Lino.chars2width(6) }), { "colIndex": 20, "sortable": false, "xtype": "checkcolumn", "header": "nicht blockierend", "editable": true, "tooltip": "Dieser Termin l\u00e4sst auch andere Termine zur gleichen Zeit zu.", "filter": { "type": "boolean" }, "width": Lino.chars2width(11), "dataIndex": "transparent", "hidden": true }, { "colIndex": 21, "sortable": true, "header": "Ort", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('placeHidden','Lino.cal.Places.detail'), "hidden": true, "editor": place2572, "dataIndex": "place" }, { "colIndex": 22, "sortable": true, "header": "Priorit\u00e4t", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "priority", "hidden": true, "editor": priority2573 }, { "colIndex": 23, "sortable": true, "header": "Zustand", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(17), "dataIndex": "state", "editor": state2574 }, { "colIndex": 24, "sortable": true, "header": "Zugewiesen zu", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(16), "dataIndex": "assigned_to", "editor": assigned_to2575 }, { "width": Lino.chars2width(11), "colIndex": 25, "sortable": false, "dataIndex": "owner", "header": "Verkn\u00fcpft mit", "hidden": true, "editable": false } ];
    Lino.cal.MyEventsToday.GridPanel.superclass.initComponent.call(this);
  }
});


Lino.cal.MyEventsToday.insertPanel = Ext.extend(Lino.cal.MyEvents.InsertFormPanel,{
  empty_title: "Neu Meine Termine heute",
  hide_navigator: true,
  params_panel_hidden: true,
  ls_bbar_actions: [ { "itemId": "post", "menu_item_text": "Erstellen", "tooltip": "Datensatz erstellen und dann im Detail-Fenster \u00f6ffnen", "panel_btn_handler": function(panel){panel.save(null,true,'post')}, "text": "Erstellen", "overflowText": "Erstellen", "auto_save": false }, { "itemId": "poststay", "menu_item_text": "Erstellen ohne Detail", "tooltip": "Nach Erstellen des Datensatzes kein Detail-Fenster \u00f6ffnen", "panel_btn_handler": function(panel){panel.save(null,false,'poststay')}, "text": "Erstellen ohne Detail", "overflowText": "Erstellen ohne Detail", "auto_save": false } ],
  ls_url: "/cal/MyEventsToday",
  action_name: "insert",
  initComponent : function() {
    this.ls_detail_handler = Lino.cal.MyEventsToday.detail;
    this.ls_insert_handler = Lino.cal.MyEventsToday.insert;
    Lino.cal.MyEventsToday.insertPanel.superclass.initComponent.call(this);
  }
});

Lino.cal.MyEventsToday.insert = new Lino.WindowAction({ "draggable": true, "width": Lino.chars2width(60), "autoHeight": true, "maximizable": true, "modal": true, "maximized": false },function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.cal.MyEventsToday.insertPanel(p);
});
Lino.cal.MyEventsToday.wf1 = function(rp,pk) { 
  Lino.run_row_action(rp,"/cal/MyEventsToday",pk,"wf1");
};
Lino.cal.MyEventsToday.wf2 = function(rp,pk) { 
  Lino.run_row_action(rp,"/cal/MyEventsToday",pk,"wf2");
};
Lino.cal.MyEventsToday.wf3 = function(rp,pk) { 
  Lino.run_row_action(rp,"/cal/MyEventsToday",pk,"wf3");
};
Lino.cal.MyEventsToday.wf4 = function(rp,pk) { 
  Lino.run_row_action(rp,"/cal/MyEventsToday",pk,"wf4");
};
Lino.cal.MyEventsToday.wf5 = function(rp,pk) { 
  Lino.run_row_action(rp,"/cal/MyEventsToday",pk,"wf5");
};
Lino.cal.MyEventsToday.wf6 = function(rp,pk) { 
  Lino.run_row_action(rp,"/cal/MyEventsToday",pk,"wf6");
};
Lino.cal.MyEventsToday.wf7 = function(rp,pk) { 
  Lino.run_row_action(rp,"/cal/MyEventsToday",pk,"wf7");
};
Lino.cal.MyEventsToday.wf8 = function(rp,pk) { 
  Lino.run_row_action(rp,"/cal/MyEventsToday",pk,"wf8");
};

Lino.cal.MyEventsToday.detailPanel = Ext.extend(Lino.cal.MyEvents.DetailFormPanel,{
  empty_title: "Detail Meine Termine heute",
  params_panel_hidden: true,
  ls_bbar_actions: [ { "itemId": "put", "menu_item_text": "Speichern", "tooltip": "\u00c4nderungen in diesem Formular speichern", "panel_btn_handler": function(panel){panel.save(null,false,'put')}, "iconCls": "x-tbar-save", "overflowText": "Speichern", "auto_save": false }, { "itemId": "insert", "menu_item_text": "Neu", "must_save": true, "tooltip": "Neuen Datensatz erstellen", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-new", "overflowText": "Neu", "auto_save": true }, { "itemId": "duplicate", "menu_item_text": "Duplizieren", "must_save": true, "tooltip": "Duplizieren", "panel_btn_handler": Lino.row_action_handler('duplicate','GET'), "iconCls": "x-tbar-duplicate", "overflowText": "Duplizieren", "auto_save": true }, { "itemId": null, "menu_item_text": "L\u00f6schen", "tooltip": "Diesen Datensatz l\u00f6schen", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "L\u00f6schen", "auto_save": false }, { "itemId": "do_print", "menu_item_text": "Drucken", "must_save": true, "tooltip": "Drucken", "panel_btn_handler": Lino.row_action_handler('do_print','GET'), "iconCls": "x-tbar-print", "overflowText": "Drucken", "auto_save": true }, { "itemId": "do_clear_cache", "menu_item_text": "Cache l\u00f6schen", "must_save": true, "tooltip": "Cache l\u00f6schen", "panel_btn_handler": Lino.row_action_handler('do_clear_cache','GET'), "iconCls": "x-tbar-clearcache", "overflowText": "Cache l\u00f6schen", "auto_save": true }, { "itemId": "create_postings", "menu_item_text": "per Post", "must_save": true, "tooltip": "Create classical mail postings from this", "panel_btn_handler": Lino.row_action_handler('create_postings','GET'), "iconCls": "x-tbar-create-postings", "overflowText": "per Post", "auto_save": true } ],
  ls_url: "/cal/MyEventsToday",
  action_name: "detail",
  initComponent : function() {
    this.ls_detail_handler = Lino.cal.MyEventsToday.detail;
    this.ls_insert_handler = Lino.cal.MyEventsToday.insert;
    Lino.cal.MyEventsToday.detailPanel.superclass.initComponent.call(this);
  }
});

Lino.cal.MyEventsToday.detail = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.cal.MyEventsToday.detailPanel(p);
});
Lino.cal.MyEventsToday.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  p.params_panel = new Lino.cal.MyEvents.ParamsPanel({});
  return new Lino.cal.MyEventsToday.GridPanel(p);
});

// js_render_GridPanel_class cal.Tasks
Lino.cal.Tasks.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "Keine Daten anzuzeigen." },
  ls_url : "/cal/Tasks",
  ls_bbar_actions : [ { "itemId": "insert", "menu_item_text": "Neu", "must_save": true, "tooltip": "Neuen Datensatz erstellen", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-new", "overflowText": "Neu", "auto_save": true }, { "itemId": "detail", "menu_item_text": "Detail", "tooltip": "Detail-Fenster auf diesem Datensatz \u00f6ffnen", "panel_btn_handler": Lino.show_detail, "iconCls": "x-tbar-detail", "overflowText": "Detail", "auto_save": true }, { "itemId": null, "menu_item_text": "L\u00f6schen", "tooltip": "Diesen Datensatz l\u00f6schen", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "L\u00f6schen", "auto_save": false } ],
  title : "Aufgaben",
  page_length : 20,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "type": "date", "name": "start_date", "dateFormat": "d.m.Y" }, { "name": "summary" }, { "name": "workflow_buttons" }, { "type": "int", "name": "id" }, { "name": "owner_type" }, 'owner_typeHidden', { "name": "owner_id" }, 'owner_idHidden', { "name": "user" }, 'userHidden', { "name": "created" }, { "name": "modified" }, { "name": "project" }, 'projectHidden', { "name": "start_time" }, { "name": "description" }, { "name": "uid" }, { "name": "calendar" }, 'calendarHidden', { "name": "access_class" }, 'access_classHidden', { "type": "int", "name": "sequence" }, { "type": "int", "name": "auto_type" }, { "type": "date", "name": "due_date", "dateFormat": "d.m.Y" }, { "name": "due_time" }, { "type": "int", "name": "percent" }, { "name": "state" }, 'stateHidden', { "name": "owner" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 3,
  ls_grid_configs : [  ],
  content_type : 30,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 30,
  initComponent : function() {
    this.ls_detail_handler = Lino.cal.Tasks.detail;
    this.ls_insert_handler = Lino.cal.Tasks.insert;
    var ww = this.containing_window;
    var start_date2578 = new Lino.DateField({ "selectOnFocus": true });
    var summary2579 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var workflow_buttons_disp2580 = new Ext.form.DisplayField({ "disabled": true, "value": "<br/>", "always_enabled": true });
    var id2581 = new Ext.form.NumberField({ "selectOnFocus": true });
    var owner_type2582 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/Tasks/owner_type", "method": "GET" }) }), "pageSize": 20, "emptyText": "Inhaltstyp ausw\u00e4hlen..." });
    var owner_id2583 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/Tasks/owner_id", "method": "GET" }) }) });
    var user2584 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/Tasks/user", "method": "GET" }) }), "pageSize": 20, "emptyText": "Benutzer ausw\u00e4hlen..." });
    var created2585 = new Ext.form.DisplayField({ "disabled": true, "value": "<br>" });
    var modified2586 = new Ext.form.DisplayField({ "disabled": true, "value": "<br>" });
    var project2587 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/Tasks/project", "method": "GET" }) }), "pageSize": 20, "emptyText": "Klient ausw\u00e4hlen..." });
    var start_time2588 = new Lino.TimeField({ "selectOnFocus": true });
    var description2589 = new Lino.RichTextPanel({ "selectOnFocus": true, "containing_panel": this, "title": "Beschreibung" });
    var uid2590 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var calendar2591 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/Tasks/calendar", "method": "GET" }) }), "pageSize": 20, "emptyText": "Kalender ausw\u00e4hlen..." });
    var access_class2592 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "forceSelection": true, "store": Lino.cal.AccessClasses });
    var sequence2593 = new Ext.form.NumberField({ "selectOnFocus": true, "allowBlank": false, "value": 0 });
    var auto_type2594 = new Ext.form.NumberField({ "disabled": true });
    var due_date2595 = new Lino.DateField({ "selectOnFocus": true });
    var due_time2596 = new Lino.TimeField({ "selectOnFocus": true });
    var percent2597 = new Ext.form.NumberField({ "selectOnFocus": true });
    var state2598 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "forceSelection": true, "allowBlank": false, "store": Lino.cal.TaskStates });
    var owner_disp2599 = new Ext.form.DisplayField({ "disabled": true });
    this.before_row_edit = function(record) {
      owner_id2583.setContextValue('owner_type',record ? record.data['owner_typeHidden'] : undefined);
      description2589.refresh();
    };
    this.onRender = function(ct, position) {
      owner_type2582.on('change',Lino.chooser_handler(owner_id2583,'owner_type'));
      Lino.cal.Tasks.GridPanel.superclass.onRender.call(this, ct, position);
    }
    this.ls_columns = [ { "colIndex": 0, "sortable": true, "xtype": "datecolumn", "format": "d.m.Y", "editable": true, "filter": { "type": "date", "dateFormat": "d.m.Y" }, "header": "Beginnt am", "editor": start_date2578, "width": Lino.chars2width(9), "dataIndex": "start_date" }, { "colIndex": 1, "sortable": true, "header": "Kurzbeschreibung", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "summary", "editor": summary2579 }, { "width": Lino.chars2width(31), "colIndex": 2, "sortable": false, "dataIndex": "workflow_buttons", "header": "Arbeitsablauf", "editable": false }, new Lino.NullNumberColumn({ "colIndex": 3, "sortable": true, "format": "0", "editable": true, "filter": { "type": "numeric" }, "header": "ID", "renderer": Lino.id_renderer, "editor": id2581, "width": Lino.chars2width(6), "dataIndex": "id" }), { "colIndex": 4, "sortable": true, "header": "Verkn\u00fcpft mit (Modell)", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('owner_typeHidden','Lino.ui.ContentTypes.detail'), "editor": owner_type2582, "dataIndex": "owner_type" }, { "colIndex": 5, "sortable": true, "header": "Verkn\u00fcpft mit (Objekt)", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(11), "dataIndex": "owner_id", "editor": owner_id2583 }, { "colIndex": 6, "sortable": true, "header": "Autor", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(16), "dataIndex": "user", "editor": user2584 }, { "width": Lino.chars2width(17), "colIndex": 7, "sortable": true, "dataIndex": "created", "header": "Erstellt", "editable": false }, { "width": Lino.chars2width(17), "colIndex": 8, "sortable": true, "dataIndex": "modified", "header": "Bearbeitet", "editable": false }, { "colIndex": 9, "sortable": true, "header": "Klient", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('projectHidden','Lino.pcsw.Clients.detail'), "editor": project2587, "dataIndex": "project" }, { "width": Lino.chars2width(9), "colIndex": 10, "sortable": true, "dataIndex": "start_time", "header": "Beginnt um", "editable": true, "editor": start_time2588 }, { "colIndex": 11, "sortable": false, "header": "description", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(61), "renderer": Lino.text_renderer, "editor": description2589, "dataIndex": "description" }, { "colIndex": 12, "sortable": true, "header": "UID", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "uid", "editor": uid2590 }, { "colIndex": 13, "sortable": true, "header": "Kalender", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "calendar", "editor": calendar2591 }, { "colIndex": 14, "sortable": true, "header": "Zugriffsklasse", "editable": true, "tooltip": "Ob dieser Termin  privat, \u00f6ffentlich oder halb \u00f6ffentlich ist", "filter": { "type": "string" }, "width": Lino.chars2width(35), "dataIndex": "access_class", "editor": access_class2592 }, new Lino.NullNumberColumn({ "colIndex": 15, "sortable": true, "format": "0", "editable": true, "filter": { "type": "numeric" }, "header": "Revisionsnummer", "dataIndex": "sequence", "width": Lino.chars2width(6), "editor": sequence2593 }), new Lino.NullNumberColumn({ "colIndex": 16, "sortable": true, "format": "0", "editable": false, "filter": { "type": "numeric" }, "header": "auto type", "dataIndex": "auto_type", "width": Lino.chars2width(6) }), { "colIndex": 17, "sortable": true, "xtype": "datecolumn", "format": "d.m.Y", "editable": true, "filter": { "type": "date", "dateFormat": "d.m.Y" }, "header": "Zahlungsziel", "editor": due_date2595, "width": Lino.chars2width(9), "dataIndex": "due_date" }, { "width": Lino.chars2width(9), "colIndex": 18, "sortable": true, "dataIndex": "due_time", "header": "F\u00e4llig um", "editable": true, "editor": due_time2596 }, new Lino.NullNumberColumn({ "colIndex": 19, "sortable": true, "format": "0", "editable": true, "filter": { "type": "numeric" }, "header": "Dauer (Anzahl)", "dataIndex": "percent", "width": Lino.chars2width(6), "editor": percent2597 }), { "colIndex": 20, "sortable": true, "header": "Zustand", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(13), "dataIndex": "state", "editor": state2598 }, { "width": Lino.chars2width(11), "colIndex": 21, "sortable": false, "dataIndex": "owner", "header": "Verkn\u00fcpft mit", "editable": false } ];
    Lino.cal.Tasks.GridPanel.superclass.initComponent.call(this);
  }
});


Lino.cal.Tasks.insertPanel = Ext.extend(Lino.cal.Tasks.InsertFormPanel,{
  empty_title: "Neu Aufgaben",
  hide_navigator: true,
  ls_bbar_actions: [ { "itemId": "post", "menu_item_text": "Erstellen", "tooltip": "Datensatz erstellen und dann im Detail-Fenster \u00f6ffnen", "panel_btn_handler": function(panel){panel.save(null,true,'post')}, "text": "Erstellen", "overflowText": "Erstellen", "auto_save": false }, { "itemId": "poststay", "menu_item_text": "Erstellen ohne Detail", "tooltip": "Nach Erstellen des Datensatzes kein Detail-Fenster \u00f6ffnen", "panel_btn_handler": function(panel){panel.save(null,false,'poststay')}, "text": "Erstellen ohne Detail", "overflowText": "Erstellen ohne Detail", "auto_save": false } ],
  ls_url: "/cal/Tasks",
  action_name: "insert",
  initComponent : function() {
    this.ls_detail_handler = Lino.cal.Tasks.detail;
    this.ls_insert_handler = Lino.cal.Tasks.insert;
    Lino.cal.Tasks.insertPanel.superclass.initComponent.call(this);
  }
});

Lino.cal.Tasks.insert = new Lino.WindowAction({ "draggable": true, "width": Lino.chars2width(50), "autoHeight": true, "maximizable": true, "modal": true, "maximized": false },function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.cal.Tasks.insertPanel(p);
});
Lino.cal.Tasks.wf1 = function(rp,pk) { 
  Lino.run_row_action(rp,"/cal/Tasks",pk,"wf1");
};
Lino.cal.Tasks.wf2 = function(rp,pk) { 
  Lino.run_row_action(rp,"/cal/Tasks",pk,"wf2");
};
Lino.cal.Tasks.wf3 = function(rp,pk) { 
  Lino.run_row_action(rp,"/cal/Tasks",pk,"wf3");
};

Lino.cal.Tasks.detailPanel = Ext.extend(Lino.cal.Tasks.DetailFormPanel,{
  empty_title: "Detail Aufgaben",
  ls_bbar_actions: [ { "itemId": "put", "menu_item_text": "Speichern", "tooltip": "\u00c4nderungen in diesem Formular speichern", "panel_btn_handler": function(panel){panel.save(null,false,'put')}, "iconCls": "x-tbar-save", "overflowText": "Speichern", "auto_save": false }, { "itemId": "insert", "menu_item_text": "Neu", "must_save": true, "tooltip": "Neuen Datensatz erstellen", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-new", "overflowText": "Neu", "auto_save": true }, { "itemId": null, "menu_item_text": "L\u00f6schen", "tooltip": "Diesen Datensatz l\u00f6schen", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "L\u00f6schen", "auto_save": false } ],
  ls_url: "/cal/Tasks",
  action_name: "detail",
  initComponent : function() {
    this.ls_detail_handler = Lino.cal.Tasks.detail;
    this.ls_insert_handler = Lino.cal.Tasks.insert;
    Lino.cal.Tasks.detailPanel.superclass.initComponent.call(this);
  }
});

Lino.cal.Tasks.detail = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.cal.Tasks.detailPanel(p);
});
Lino.cal.Tasks.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.cal.Tasks.GridPanel(p);
});

// js_render_GridPanel_class cal.GuestRoles
Lino.cal.GuestRoles.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "Keine Daten anzuzeigen." },
  ls_url : "/cal/GuestRoles",
  ls_bbar_actions : [ { "itemId": "insert", "menu_item_text": "Neu", "must_save": true, "tooltip": "Neuen Datensatz erstellen", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-new", "overflowText": "Neu", "auto_save": true }, { "itemId": "detail", "menu_item_text": "Detail", "tooltip": "Detail-Fenster auf diesem Datensatz \u00f6ffnen", "panel_btn_handler": Lino.show_detail, "iconCls": "x-tbar-detail", "overflowText": "Detail", "auto_save": true }, { "itemId": null, "menu_item_text": "L\u00f6schen", "tooltip": "Diesen Datensatz l\u00f6schen", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "L\u00f6schen", "auto_save": false } ],
  title : "Gastrollen",
  page_length : 20,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "type": "int", "name": "id" }, { "name": "name" }, { "name": "name_fr" }, { "name": "name_nl" }, { "name": "build_method" }, 'build_methodHidden', { "name": "template" }, { "type": "boolean", "name": "attach_to_email" }, { "name": "email_template" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 0,
  ls_grid_configs : [  ],
  content_type : 34,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 10,
  initComponent : function() {
    this.ls_detail_handler = Lino.cal.GuestRoles.detail;
    this.ls_insert_handler = Lino.cal.GuestRoles.insert;
    var ww = this.containing_window;
    var id2601 = new Ext.form.NumberField({ "selectOnFocus": true });
    var name2602 = new Ext.form.TextField({ "selectOnFocus": true, "allowBlank": false, "maxLength": 200 });
    var name_fr2603 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var name_nl2604 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var build_method2605 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "store": [ [ "appyodt", "AppyOdtBuildMethod" ], [ "appypdf", "AppyPdfBuildMethod" ], [ "appyrtf", "AppyRtfBuildMethod" ], [ "latex", "LatexBuildMethod" ], [ "pisa", "PisaBuildMethod" ], [ "rtf", "RtfBuildMethod" ] ] });
    var template2606 = new Lino.SimpleRemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/GuestRoles/template", "method": "GET" }) }) });
    var attach_to_email2607 = new Ext.form.Checkbox({ "selectOnFocus": true, "checked": false });
    var email_template2608 = new Lino.SimpleRemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/GuestRoles/email_template", "method": "GET" }) }) });
    this.before_row_edit = function(record) {
      template2606.setContextValue('build_method',record ? record.data['build_methodHidden'] : undefined);
    };
    this.onRender = function(ct, position) {
      build_method2605.on('change',Lino.chooser_handler(template2606,'build_method'));
      Lino.cal.GuestRoles.GridPanel.superclass.onRender.call(this, ct, position);
    }
    this.ls_columns = [ new Lino.NullNumberColumn({ "colIndex": 0, "sortable": true, "format": "0", "editable": true, "filter": { "type": "numeric" }, "header": "ID", "renderer": Lino.id_renderer, "editor": id2601, "width": Lino.chars2width(6), "dataIndex": "id" }), { "colIndex": 1, "sortable": true, "header": "Bezeichnung", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "name", "editor": name2602 }, { "colIndex": 2, "sortable": true, "header": "Bezeichnung (fr)", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "name_fr", "editor": name_fr2603 }, { "colIndex": 3, "sortable": true, "header": "Bezeichnung (nl)", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "name_nl", "editor": name_nl2604 }, { "colIndex": 4, "sortable": true, "header": "Konstruktionsmethode", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "build_method", "editor": build_method2605 }, { "colIndex": 5, "sortable": true, "header": "Vorlage", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(11), "dataIndex": "template", "editor": template2606 }, { "colIndex": 6, "sortable": false, "xtype": "checkcolumn", "header": "als Anhang per E-Mail", "editable": true, "tooltip": "Whether the printable file should be attached to the email\nwhen creating an email from a mailable of this type.\n", "filter": { "type": "boolean" }, "width": Lino.chars2width(11), "dataIndex": "attach_to_email" }, { "colIndex": 7, "sortable": true, "header": "E-Mail-Vorlage", "editable": true, "tooltip": "The name of the file to be used as template \nwhen creating an email from a mailable of this type.\n", "filter": { "type": "string" }, "width": Lino.chars2width(11), "dataIndex": "email_template", "editor": email_template2608 } ];
    Lino.cal.GuestRoles.GridPanel.superclass.initComponent.call(this);
  }
});


Lino.cal.GuestRoles.insertPanel = Ext.extend(Lino.cal.GuestRoles.DetailFormPanel,{
  empty_title: "Neu Gastrollen",
  hide_navigator: true,
  ls_bbar_actions: [ { "itemId": "post", "menu_item_text": "Erstellen", "tooltip": "Datensatz erstellen und dann im Detail-Fenster \u00f6ffnen", "panel_btn_handler": function(panel){panel.save(null,true,'post')}, "text": "Erstellen", "overflowText": "Erstellen", "auto_save": false }, { "itemId": "poststay", "menu_item_text": "Erstellen ohne Detail", "tooltip": "Nach Erstellen des Datensatzes kein Detail-Fenster \u00f6ffnen", "panel_btn_handler": function(panel){panel.save(null,false,'poststay')}, "text": "Erstellen ohne Detail", "overflowText": "Erstellen ohne Detail", "auto_save": false } ],
  ls_url: "/cal/GuestRoles",
  action_name: "insert",
  initComponent : function() {
    this.ls_detail_handler = Lino.cal.GuestRoles.detail;
    this.ls_insert_handler = Lino.cal.GuestRoles.insert;
    Lino.cal.GuestRoles.insertPanel.superclass.initComponent.call(this);
  }
});

Lino.cal.GuestRoles.insert = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.cal.GuestRoles.insertPanel(p);
});

Lino.cal.GuestRoles.detailPanel = Ext.extend(Lino.cal.GuestRoles.DetailFormPanel,{
  empty_title: "Detail Gastrollen",
  ls_bbar_actions: [ { "itemId": "put", "menu_item_text": "Speichern", "tooltip": "\u00c4nderungen in diesem Formular speichern", "panel_btn_handler": function(panel){panel.save(null,false,'put')}, "iconCls": "x-tbar-save", "overflowText": "Speichern", "auto_save": false }, { "itemId": "insert", "menu_item_text": "Neu", "must_save": true, "tooltip": "Neuen Datensatz erstellen", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-new", "overflowText": "Neu", "auto_save": true }, { "itemId": null, "menu_item_text": "L\u00f6schen", "tooltip": "Diesen Datensatz l\u00f6schen", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "L\u00f6schen", "auto_save": false } ],
  ls_url: "/cal/GuestRoles",
  action_name: "detail",
  initComponent : function() {
    this.ls_detail_handler = Lino.cal.GuestRoles.detail;
    this.ls_insert_handler = Lino.cal.GuestRoles.insert;
    Lino.cal.GuestRoles.detailPanel.superclass.initComponent.call(this);
  }
});

Lino.cal.GuestRoles.detail = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.cal.GuestRoles.detailPanel(p);
});
Lino.cal.GuestRoles.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.cal.GuestRoles.GridPanel(p);
});

// js_render_GridPanel_class cal.Guests
Lino.cal.Guests.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "Keine Daten anzuzeigen." },
  ls_url : "/cal/Guests",
  ls_bbar_actions : [ { "itemId": "duplicate", "menu_item_text": "Duplizieren", "must_save": true, "tooltip": "Duplizieren", "panel_btn_handler": Lino.row_action_handler('duplicate','GET'), "iconCls": "x-tbar-duplicate", "overflowText": "Duplizieren", "auto_save": true }, { "itemId": null, "menu_item_text": "L\u00f6schen", "tooltip": "Diesen Datensatz l\u00f6schen", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "L\u00f6schen", "auto_save": false }, { "itemId": "do_print", "menu_item_text": "Drucken", "must_save": true, "tooltip": "Drucken", "panel_btn_handler": Lino.row_action_handler('do_print','GET'), "iconCls": "x-tbar-print", "overflowText": "Drucken", "auto_save": true }, { "itemId": "do_clear_cache", "menu_item_text": "Cache l\u00f6schen", "must_save": true, "tooltip": "Cache l\u00f6schen", "panel_btn_handler": Lino.row_action_handler('do_clear_cache','GET'), "iconCls": "x-tbar-clearcache", "overflowText": "Cache l\u00f6schen", "auto_save": true } ],
  title : "G\u00e4ste",
  page_length : 20,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "name": "partner" }, 'partnerHidden', { "name": "role" }, 'roleHidden', { "name": "workflow_buttons" }, { "name": "remark" }, { "name": "event" }, 'eventHidden', { "type": "int", "name": "id" }, { "name": "build_time" }, { "name": "state" }, 'stateHidden', { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 8,
  ls_grid_configs : [  ],
  content_type : 31,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 13,
  initComponent : function() {
    var ww = this.containing_window;
    var partner2610 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/Guests/partner", "method": "GET" }) }), "allowBlank": false, "pageSize": 20, "emptyText": "Partner ausw\u00e4hlen..." });
    var role2611 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/Guests/role", "method": "GET" }) }), "pageSize": 20, "emptyText": "Gastrolle ausw\u00e4hlen..." });
    var workflow_buttons_disp2612 = new Ext.form.DisplayField({ "disabled": true, "value": "<br/>", "always_enabled": true });
    var remark2613 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var event2614 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/Guests/event", "method": "GET" }) }), "allowBlank": false, "pageSize": 20, "emptyText": "Termin ausw\u00e4hlen..." });
    var id2615 = new Ext.form.NumberField({ "selectOnFocus": true });
    var build_time2616 = new Ext.form.DisplayField({ "disabled": true, "value": "<br>" });
    var state2617 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "forceSelection": true, "allowBlank": false, "store": Lino.cal.GuestStates });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ { "colIndex": 0, "sortable": true, "header": "Partner", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('partnerHidden','Lino.contacts.Partners.detail'), "editor": partner2610, "dataIndex": "partner" }, { "colIndex": 1, "sortable": true, "header": "Rolle", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('roleHidden','Lino.cal.GuestRoles.detail'), "editor": role2611, "dataIndex": "role" }, { "width": Lino.chars2width(31), "colIndex": 2, "sortable": false, "dataIndex": "workflow_buttons", "header": "Arbeitsablauf", "editable": false }, { "colIndex": 3, "sortable": true, "header": "Bemerkung", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "remark", "editor": remark2613 }, { "colIndex": 4, "sortable": true, "header": "Termin", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "event", "editor": event2614 }, new Lino.NullNumberColumn({ "colIndex": 5, "sortable": true, "format": "0", "editable": true, "filter": { "type": "numeric" }, "header": "ID", "renderer": Lino.id_renderer, "editor": id2615, "width": Lino.chars2width(6), "dataIndex": "id" }), { "width": Lino.chars2width(17), "colIndex": 6, "sortable": true, "dataIndex": "build_time", "header": "Druckdatum", "editable": false }, { "colIndex": 7, "sortable": true, "header": "Zustand", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(14), "dataIndex": "state", "editor": state2617 } ];
    Lino.cal.Guests.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.cal.Guests.wf1 = function(rp,pk) { 
  Lino.run_row_action(rp,"/cal/Guests",pk,"wf1");
};
Lino.cal.Guests.wf3 = function(rp,pk) { 
  Lino.run_row_action(rp,"/cal/Guests",pk,"wf3");
};
Lino.cal.Guests.wf4 = function(rp,pk) { 
  Lino.run_row_action(rp,"/cal/Guests",pk,"wf4");
};
Lino.cal.Guests.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.cal.Guests.GridPanel(p);
});

// js_render_GridPanel_class cal.PanelCalendars
Lino.cal.PanelCalendars.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "Keine Daten anzuzeigen." },
  ls_url : "/cal/PanelCalendars",
  ls_bbar_actions : [ { "itemId": "insert", "menu_item_text": "Neu", "must_save": true, "tooltip": "Neuen Datensatz erstellen", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-new", "overflowText": "Neu", "auto_save": true }, { "itemId": "detail", "menu_item_text": "Detail", "tooltip": "Detail-Fenster auf diesem Datensatz \u00f6ffnen", "panel_btn_handler": Lino.show_detail, "iconCls": "x-tbar-detail", "overflowText": "Detail", "auto_save": true }, { "itemId": null, "menu_item_text": "L\u00f6schen", "tooltip": "Diesen Datensatz l\u00f6schen", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "L\u00f6schen", "auto_save": false } ],
  title : "Kalenderliste",
  page_length : 20,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "type": "int", "name": "id" }, { "name": "babel_name" }, { "name": "description" }, { "type": "int", "name": "color" }, { "type": "boolean", "name": "is_hidden" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 0,
  ls_grid_configs : [  ],
  content_type : 35,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 6,
  initComponent : function() {
    this.ls_detail_handler = Lino.cal.PanelCalendars.detail;
    this.ls_insert_handler = Lino.cal.PanelCalendars.insert;
    var ww = this.containing_window;
    var id2619 = new Ext.form.NumberField({ "selectOnFocus": true });
    var babel_name_disp2620 = new Ext.form.DisplayField({ "disabled": true, "value": "<br/>", "always_enabled": true });
    var description2621 = new Lino.RichTextPanel({ "selectOnFocus": true, "containing_panel": this, "title": "Beschreibung" });
    var color2622 = new Ext.form.NumberField({ "selectOnFocus": true, "allowBlank": false, "value": 1 });
    var is_hidden_disp2623 = new Ext.form.DisplayField({ "disabled": true, "value": "<br/>", "always_enabled": true });
    this.before_row_edit = function(record) {
      description2621.refresh();
    };
    this.ls_columns = [ new Lino.NullNumberColumn({ "colIndex": 0, "sortable": true, "format": "0", "editable": true, "filter": { "type": "numeric" }, "header": "ID", "renderer": Lino.id_renderer, "editor": id2619, "width": Lino.chars2width(6), "dataIndex": "id" }), { "width": Lino.chars2width(31), "colIndex": 1, "sortable": false, "dataIndex": "babel_name", "header": "babel_name", "editable": false }, { "colIndex": 2, "sortable": false, "header": "description", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(61), "renderer": Lino.text_renderer, "editor": description2621, "dataIndex": "description" }, new Lino.NullNumberColumn({ "colIndex": 3, "sortable": true, "format": "0", "editable": true, "filter": { "type": "numeric" }, "header": "Farbe", "dataIndex": "color", "width": Lino.chars2width(6), "editor": color2622 }), { "width": Lino.chars2width(31), "colIndex": 4, "sortable": false, "dataIndex": "is_hidden", "header": "versteckt", "editable": false } ];
    Lino.cal.PanelCalendars.GridPanel.superclass.initComponent.call(this);
  }
});


Lino.cal.PanelCalendars.insertPanel = Ext.extend(Lino.cal.PanelCalendars.InsertFormPanel,{
  empty_title: "Neu Kalenderliste",
  hide_navigator: true,
  ls_bbar_actions: [ { "itemId": "post", "menu_item_text": "Erstellen", "tooltip": "Datensatz erstellen und dann im Detail-Fenster \u00f6ffnen", "panel_btn_handler": function(panel){panel.save(null,true,'post')}, "text": "Erstellen", "overflowText": "Erstellen", "auto_save": false }, { "itemId": "poststay", "menu_item_text": "Erstellen ohne Detail", "tooltip": "Nach Erstellen des Datensatzes kein Detail-Fenster \u00f6ffnen", "panel_btn_handler": function(panel){panel.save(null,false,'poststay')}, "text": "Erstellen ohne Detail", "overflowText": "Erstellen ohne Detail", "auto_save": false } ],
  ls_url: "/cal/PanelCalendars",
  action_name: "insert",
  initComponent : function() {
    this.ls_detail_handler = Lino.cal.PanelCalendars.detail;
    this.ls_insert_handler = Lino.cal.PanelCalendars.insert;
    Lino.cal.PanelCalendars.insertPanel.superclass.initComponent.call(this);
  }
});

Lino.cal.PanelCalendars.insert = new Lino.WindowAction({ "draggable": true, "width": Lino.chars2width(60), "autoHeight": true, "maximizable": true, "modal": true, "maximized": false },function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.cal.PanelCalendars.insertPanel(p);
});

Lino.cal.PanelCalendars.detailPanel = Ext.extend(Lino.cal.PanelCalendars.DetailFormPanel,{
  empty_title: "Detail Kalenderliste",
  ls_bbar_actions: [ { "itemId": "put", "menu_item_text": "Speichern", "tooltip": "\u00c4nderungen in diesem Formular speichern", "panel_btn_handler": function(panel){panel.save(null,false,'put')}, "iconCls": "x-tbar-save", "overflowText": "Speichern", "auto_save": false }, { "itemId": "insert", "menu_item_text": "Neu", "must_save": true, "tooltip": "Neuen Datensatz erstellen", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-new", "overflowText": "Neu", "auto_save": true }, { "itemId": null, "menu_item_text": "L\u00f6schen", "tooltip": "Diesen Datensatz l\u00f6schen", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "L\u00f6schen", "auto_save": false } ],
  ls_url: "/cal/PanelCalendars",
  action_name: "detail",
  initComponent : function() {
    this.ls_detail_handler = Lino.cal.PanelCalendars.detail;
    this.ls_insert_handler = Lino.cal.PanelCalendars.insert;
    Lino.cal.PanelCalendars.detailPanel.superclass.initComponent.call(this);
  }
});

Lino.cal.PanelCalendars.detail = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.cal.PanelCalendars.detailPanel(p);
});
Lino.cal.PanelCalendars.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.cal.PanelCalendars.GridPanel(p);
});

// js_render_GridPanel_class cal.PanelEvents
Lino.cal.PanelEvents.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "Keine Daten anzuzeigen." },
  ls_url : "/cal/PanelEvents",
  ls_bbar_actions : [ { "itemId": "insert", "menu_item_text": "Neu", "must_save": true, "tooltip": "Neuen Datensatz erstellen", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-new", "overflowText": "Neu", "auto_save": true }, { "itemId": "duplicate", "menu_item_text": "Duplizieren", "must_save": true, "tooltip": "Duplizieren", "panel_btn_handler": Lino.row_action_handler('duplicate','GET'), "iconCls": "x-tbar-duplicate", "overflowText": "Duplizieren", "auto_save": true }, { "itemId": "detail", "menu_item_text": "Detail", "tooltip": "Detail-Fenster auf diesem Datensatz \u00f6ffnen", "panel_btn_handler": Lino.show_detail, "iconCls": "x-tbar-detail", "overflowText": "Detail", "auto_save": true }, { "itemId": null, "menu_item_text": "L\u00f6schen", "tooltip": "Diesen Datensatz l\u00f6schen", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "L\u00f6schen", "auto_save": false }, { "itemId": "do_print", "menu_item_text": "Drucken", "must_save": true, "tooltip": "Drucken", "panel_btn_handler": Lino.row_action_handler('do_print','GET'), "iconCls": "x-tbar-print", "overflowText": "Drucken", "auto_save": true }, { "itemId": "do_clear_cache", "menu_item_text": "Cache l\u00f6schen", "must_save": true, "tooltip": "Cache l\u00f6schen", "panel_btn_handler": Lino.row_action_handler('do_clear_cache','GET'), "iconCls": "x-tbar-clearcache", "overflowText": "Cache l\u00f6schen", "auto_save": true }, { "itemId": "create_postings", "menu_item_text": "per Post", "must_save": true, "tooltip": "Create classical mail postings from this", "panel_btn_handler": Lino.row_action_handler('create_postings','GET'), "iconCls": "x-tbar-create-postings", "overflowText": "per Post", "auto_save": true } ],
  title : "Termine",
  page_length : 20,
  params_panel_hidden : true,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "type": "int", "name": "id" }, { "name": "start_dt" }, { "name": "end_dt" }, { "name": "summary" }, { "name": "description" }, { "name": "user" }, 'userHidden', { "name": "place" }, 'placeHidden', { "name": "calendar" }, 'calendarHidden', { "name": "url" }, { "type": "boolean", "name": "all_day" }, { "name": "reminder" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 0,
  ls_grid_configs : [  ],
  content_type : 36,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 15,
  initComponent : function() {
    this.ls_detail_handler = Lino.cal.PanelEvents.detail;
    this.ls_insert_handler = Lino.cal.PanelEvents.insert;
    var ww = this.containing_window;
    var id2625 = new Ext.form.NumberField({ "selectOnFocus": true });
    var start_dt2626 = new Ext.form.DisplayField({ "disabled": true, "value": "<br>" });
    var end_dt2627 = new Ext.form.DisplayField({ "disabled": true, "value": "<br>" });
    var summary2628 = new Ext.form.TextField({ "disabled": true, "maxLength": null });
    var description2629 = new Lino.RichTextPanel({ "selectOnFocus": true, "containing_panel": this, "title": "Beschreibung" });
    var user2630 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/PanelEvents/user", "method": "GET" }) }), "pageSize": 20, "emptyText": "Benutzer ausw\u00e4hlen..." });
    var place2631 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/PanelEvents/place", "method": "GET" }) }), "pageSize": 20, "emptyText": "Ort ausw\u00e4hlen..." });
    var calendar2632 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/PanelEvents/calendar", "method": "GET" }) }), "pageSize": 20, "emptyText": "Kalender ausw\u00e4hlen..." });
    var url_disp2633 = new Ext.form.DisplayField({ "disabled": true, "value": "<br/>", "always_enabled": true });
    var all_day2634 = new Ext.form.Checkbox({ "disabled": true });
    var reminder_disp2635 = new Ext.form.DisplayField({ "disabled": true, "value": "<br/>", "always_enabled": true });
    this.before_row_edit = function(record) {
      description2629.refresh();
    };
    this.ls_columns = [ new Lino.NullNumberColumn({ "colIndex": 0, "sortable": true, "format": "0", "editable": true, "filter": { "type": "numeric" }, "header": "ID", "renderer": Lino.id_renderer, "editor": id2625, "width": Lino.chars2width(6), "dataIndex": "id" }), { "width": Lino.chars2width(17), "colIndex": 1, "sortable": false, "dataIndex": "start_dt", "header": "Beginn", "editable": false }, { "width": Lino.chars2width(17), "colIndex": 2, "sortable": false, "dataIndex": "end_dt", "header": "Ende", "editable": false }, { "width": Lino.chars2width(5), "colIndex": 3, "sortable": false, "dataIndex": "summary", "header": "Kurzbeschreibung", "editable": false }, { "colIndex": 4, "sortable": false, "header": "description", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(61), "renderer": Lino.text_renderer, "hidden": true, "editor": description2629, "dataIndex": "description" }, { "colIndex": 5, "sortable": true, "header": "Verantwortlicher", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(16), "dataIndex": "user", "editor": user2630 }, { "colIndex": 6, "sortable": true, "header": "Ort", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('placeHidden','Lino.cal.Places.detail'), "hidden": true, "editor": place2631, "dataIndex": "place" }, { "colIndex": 7, "sortable": true, "header": "Kalender", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "calendar", "editor": calendar2632 }, { "width": Lino.chars2width(31), "colIndex": 8, "sortable": false, "dataIndex": "url", "header": "Link URL", "editable": false }, { "header": "ganztags", "colIndex": 9, "sortable": false, "xtype": "checkcolumn", "width": Lino.chars2width(11), "editable": false, "dataIndex": "all_day" }, { "width": Lino.chars2width(31), "colIndex": 10, "sortable": false, "dataIndex": "reminder", "header": "Erinnerung", "editable": false } ];
    Lino.cal.PanelEvents.GridPanel.superclass.initComponent.call(this);
  }
});


Lino.cal.PanelEvents.insertPanel = Ext.extend(Lino.cal.MyEvents.InsertFormPanel,{
  empty_title: "Neu Termine",
  hide_navigator: true,
  params_panel_hidden: true,
  ls_bbar_actions: [ { "itemId": "post", "menu_item_text": "Erstellen", "tooltip": "Datensatz erstellen und dann im Detail-Fenster \u00f6ffnen", "panel_btn_handler": function(panel){panel.save(null,true,'post')}, "text": "Erstellen", "overflowText": "Erstellen", "auto_save": false }, { "itemId": "poststay", "menu_item_text": "Erstellen ohne Detail", "tooltip": "Nach Erstellen des Datensatzes kein Detail-Fenster \u00f6ffnen", "panel_btn_handler": function(panel){panel.save(null,false,'poststay')}, "text": "Erstellen ohne Detail", "overflowText": "Erstellen ohne Detail", "auto_save": false } ],
  ls_url: "/cal/PanelEvents",
  action_name: "insert",
  initComponent : function() {
    this.ls_detail_handler = Lino.cal.PanelEvents.detail;
    this.ls_insert_handler = Lino.cal.PanelEvents.insert;
    Lino.cal.PanelEvents.insertPanel.superclass.initComponent.call(this);
  }
});

Lino.cal.PanelEvents.insert = new Lino.WindowAction({ "draggable": true, "width": Lino.chars2width(60), "autoHeight": true, "maximizable": true, "modal": true, "maximized": false },function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.cal.PanelEvents.insertPanel(p);
});
Lino.cal.PanelEvents.wf1 = function(rp,pk) { 
  Lino.run_row_action(rp,"/cal/PanelEvents",pk,"wf1");
};
Lino.cal.PanelEvents.wf2 = function(rp,pk) { 
  Lino.run_row_action(rp,"/cal/PanelEvents",pk,"wf2");
};
Lino.cal.PanelEvents.wf3 = function(rp,pk) { 
  Lino.run_row_action(rp,"/cal/PanelEvents",pk,"wf3");
};
Lino.cal.PanelEvents.wf4 = function(rp,pk) { 
  Lino.run_row_action(rp,"/cal/PanelEvents",pk,"wf4");
};
Lino.cal.PanelEvents.wf5 = function(rp,pk) { 
  Lino.run_row_action(rp,"/cal/PanelEvents",pk,"wf5");
};
Lino.cal.PanelEvents.wf6 = function(rp,pk) { 
  Lino.run_row_action(rp,"/cal/PanelEvents",pk,"wf6");
};
Lino.cal.PanelEvents.wf7 = function(rp,pk) { 
  Lino.run_row_action(rp,"/cal/PanelEvents",pk,"wf7");
};
Lino.cal.PanelEvents.wf8 = function(rp,pk) { 
  Lino.run_row_action(rp,"/cal/PanelEvents",pk,"wf8");
};

Lino.cal.PanelEvents.detailPanel = Ext.extend(Lino.cal.MyEvents.DetailFormPanel,{
  empty_title: "Detail Termine",
  params_panel_hidden: true,
  ls_bbar_actions: [ { "itemId": "put", "menu_item_text": "Speichern", "tooltip": "\u00c4nderungen in diesem Formular speichern", "panel_btn_handler": function(panel){panel.save(null,false,'put')}, "iconCls": "x-tbar-save", "overflowText": "Speichern", "auto_save": false }, { "itemId": "insert", "menu_item_text": "Neu", "must_save": true, "tooltip": "Neuen Datensatz erstellen", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-new", "overflowText": "Neu", "auto_save": true }, { "itemId": "duplicate", "menu_item_text": "Duplizieren", "must_save": true, "tooltip": "Duplizieren", "panel_btn_handler": Lino.row_action_handler('duplicate','GET'), "iconCls": "x-tbar-duplicate", "overflowText": "Duplizieren", "auto_save": true }, { "itemId": null, "menu_item_text": "L\u00f6schen", "tooltip": "Diesen Datensatz l\u00f6schen", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "L\u00f6schen", "auto_save": false }, { "itemId": "do_print", "menu_item_text": "Drucken", "must_save": true, "tooltip": "Drucken", "panel_btn_handler": Lino.row_action_handler('do_print','GET'), "iconCls": "x-tbar-print", "overflowText": "Drucken", "auto_save": true }, { "itemId": "do_clear_cache", "menu_item_text": "Cache l\u00f6schen", "must_save": true, "tooltip": "Cache l\u00f6schen", "panel_btn_handler": Lino.row_action_handler('do_clear_cache','GET'), "iconCls": "x-tbar-clearcache", "overflowText": "Cache l\u00f6schen", "auto_save": true }, { "itemId": "create_postings", "menu_item_text": "per Post", "must_save": true, "tooltip": "Create classical mail postings from this", "panel_btn_handler": Lino.row_action_handler('create_postings','GET'), "iconCls": "x-tbar-create-postings", "overflowText": "per Post", "auto_save": true } ],
  ls_url: "/cal/PanelEvents",
  action_name: "detail",
  initComponent : function() {
    this.ls_detail_handler = Lino.cal.PanelEvents.detail;
    this.ls_insert_handler = Lino.cal.PanelEvents.insert;
    Lino.cal.PanelEvents.detailPanel.superclass.initComponent.call(this);
  }
});

Lino.cal.PanelEvents.detail = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.cal.PanelEvents.detailPanel(p);
});
Lino.cal.PanelEvents.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  p.params_panel = new Lino.cal.MyEvents.ParamsPanel({});
  return new Lino.cal.PanelEvents.GridPanel(p);
});

// js_render_GridPanel_class uploads.UploadTypes
Lino.uploads.UploadTypes.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "Keine Daten anzuzeigen." },
  ls_url : "/uploads/UploadTypes",
  ls_bbar_actions : [ { "itemId": null, "menu_item_text": "L\u00f6schen", "tooltip": "Diesen Datensatz l\u00f6schen", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "L\u00f6schen", "auto_save": false } ],
  title : "Upload-Arten",
  page_length : 20,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "name": "name" }, { "type": "int", "name": "id" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 1,
  ls_grid_configs : [  ],
  content_type : 25,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 3,
  initComponent : function() {
    var ww = this.containing_window;
    var name2637 = new Ext.form.TextField({ "selectOnFocus": true, "allowBlank": false, "maxLength": 200 });
    var id2638 = new Ext.form.NumberField({ "selectOnFocus": true });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ { "colIndex": 0, "sortable": true, "header": "Name", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "name", "editor": name2637 }, new Lino.NullNumberColumn({ "colIndex": 1, "sortable": true, "format": "0", "editable": true, "filter": { "type": "numeric" }, "header": "ID", "renderer": Lino.id_renderer, "editor": id2638, "width": Lino.chars2width(6), "dataIndex": "id" }) ];
    Lino.uploads.UploadTypes.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.uploads.UploadTypes.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.uploads.UploadTypes.GridPanel(p);
});

// js_render_GridPanel_class uploads.Uploads
Lino.uploads.Uploads.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "Keine Daten anzuzeigen." },
  ls_url : "/uploads/Uploads",
  ls_bbar_actions : [ { "itemId": "insert", "menu_item_text": "Neu", "must_save": true, "tooltip": "Neuen Datensatz erstellen", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-new", "overflowText": "Neu", "auto_save": true }, { "itemId": "detail", "menu_item_text": "Detail", "tooltip": "Detail-Fenster auf diesem Datensatz \u00f6ffnen", "panel_btn_handler": Lino.show_detail, "iconCls": "x-tbar-detail", "overflowText": "Detail", "auto_save": true }, { "itemId": null, "menu_item_text": "L\u00f6schen", "tooltip": "Diesen Datensatz l\u00f6schen", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "L\u00f6schen", "auto_save": false } ],
  title : "Uploads",
  page_length : 20,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "name": "file" }, { "name": "user" }, 'userHidden', { "name": "created" }, { "name": "modified" }, { "type": "int", "name": "id" }, { "name": "owner_type" }, 'owner_typeHidden', { "name": "owner_id" }, 'owner_idHidden', { "name": "mimetype" }, { "name": "type" }, 'typeHidden', { "type": "date", "name": "valid_until", "dateFormat": "d.m.Y" }, { "name": "description" }, { "name": "owner" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 5,
  ls_grid_configs : [  ],
  content_type : 26,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 17,
  initComponent : function() {
    this.ls_detail_handler = Lino.uploads.Uploads.detail;
    this.ls_insert_handler = Lino.uploads.Uploads.insert;
    var ww = this.containing_window;
    var file2640 = Lino.file_field_handler(this,{ "selectOnFocus": true, "allowBlank": false, "maxLength": 100 });
    var user2641 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/uploads/Uploads/user", "method": "GET" }) }), "pageSize": 20, "emptyText": "Benutzer ausw\u00e4hlen..." });
    var created2642 = new Ext.form.DisplayField({ "disabled": true, "value": "<br>" });
    var modified2643 = new Ext.form.DisplayField({ "disabled": true, "value": "<br>" });
    var id2644 = new Ext.form.NumberField({ "selectOnFocus": true });
    var owner_type2645 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/uploads/Uploads/owner_type", "method": "GET" }) }), "pageSize": 20, "emptyText": "Inhaltstyp ausw\u00e4hlen..." });
    var owner_id2646 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/uploads/Uploads/owner_id", "method": "GET" }) }) });
    var mimetype2647 = new Ext.form.TextField({ "disabled": true, "maxLength": 64 });
    var type2648 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/uploads/Uploads/type", "method": "GET" }) }), "pageSize": 20, "emptyText": "Upload-Art ausw\u00e4hlen..." });
    var valid_until2649 = new Lino.DateField({ "selectOnFocus": true });
    var description2650 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var owner_disp2651 = new Ext.form.DisplayField({ "disabled": true });
    this.before_row_edit = function(record) {
      owner_id2646.setContextValue('owner_type',record ? record.data['owner_typeHidden'] : undefined);
    };
    this.onRender = function(ct, position) {
      owner_type2645.on('change',Lino.chooser_handler(owner_id2646,'owner_type'));
      Lino.uploads.Uploads.GridPanel.superclass.onRender.call(this, ct, position);
    }
    this.ls_columns = [ { "colIndex": 0, "sortable": true, "header": "Datei", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "file", "editor": file2640 }, { "colIndex": 1, "sortable": true, "header": "Autor", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(16), "dataIndex": "user", "editor": user2641 }, { "width": Lino.chars2width(17), "colIndex": 2, "sortable": true, "dataIndex": "created", "header": "Erstellt", "editable": false }, { "width": Lino.chars2width(17), "colIndex": 3, "sortable": true, "dataIndex": "modified", "header": "Bearbeitet", "editable": false }, new Lino.NullNumberColumn({ "colIndex": 4, "sortable": true, "format": "0", "editable": true, "filter": { "type": "numeric" }, "header": "ID", "renderer": Lino.id_renderer, "editor": id2644, "width": Lino.chars2width(6), "dataIndex": "id" }), { "colIndex": 5, "sortable": true, "header": "Verkn\u00fcpft mit (Modell)", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('owner_typeHidden','Lino.ui.ContentTypes.detail'), "editor": owner_type2645, "dataIndex": "owner_type" }, { "colIndex": 6, "sortable": true, "header": "Verkn\u00fcpft mit (Objekt)", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(11), "dataIndex": "owner_id", "editor": owner_id2646 }, { "filter": { "type": "string" }, "width": Lino.chars2width(22), "colIndex": 7, "sortable": true, "dataIndex": "mimetype", "header": "MIME-Art", "editable": false }, { "colIndex": 8, "sortable": true, "header": "Upload-Art", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "type", "editor": type2648 }, { "colIndex": 9, "sortable": true, "xtype": "datecolumn", "format": "d.m.Y", "editable": true, "filter": { "type": "date", "dateFormat": "d.m.Y" }, "header": "g\u00fcltig bis", "editor": valid_until2649, "width": Lino.chars2width(9), "dataIndex": "valid_until" }, { "colIndex": 10, "sortable": true, "header": "Beschreibung", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "description", "editor": description2650 }, { "width": Lino.chars2width(11), "colIndex": 11, "sortable": false, "dataIndex": "owner", "header": "Verkn\u00fcpft mit", "editable": false } ];
    Lino.uploads.Uploads.GridPanel.superclass.initComponent.call(this);
  }
});


Lino.uploads.Uploads.insertPanel = Ext.extend(Lino.uploads.Uploads.InsertFormPanel,{
  empty_title: "Neu Uploads",
  hide_navigator: true,
  ls_bbar_actions: [ { "itemId": "post", "menu_item_text": "Erstellen", "tooltip": "Datensatz erstellen und dann im Detail-Fenster \u00f6ffnen", "panel_btn_handler": function(panel){panel.save(null,true,'post')}, "text": "Erstellen", "overflowText": "Erstellen", "auto_save": false }, { "itemId": "poststay", "menu_item_text": "Erstellen ohne Detail", "tooltip": "Nach Erstellen des Datensatzes kein Detail-Fenster \u00f6ffnen", "panel_btn_handler": function(panel){panel.save(null,false,'poststay')}, "text": "Erstellen ohne Detail", "overflowText": "Erstellen ohne Detail", "auto_save": false } ],
  ls_url: "/uploads/Uploads",
  action_name: "insert",
  initComponent : function() {
    this.ls_detail_handler = Lino.uploads.Uploads.detail;
    this.ls_insert_handler = Lino.uploads.Uploads.insert;
    Lino.uploads.Uploads.insertPanel.superclass.initComponent.call(this);
  }
});

Lino.uploads.Uploads.insert = new Lino.WindowAction({ "draggable": true, "width": Lino.chars2width(60), "autoHeight": true, "maximizable": true, "modal": true, "maximized": false },function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.uploads.Uploads.insertPanel(p);
});

Lino.uploads.Uploads.detailPanel = Ext.extend(Lino.uploads.Uploads.DetailFormPanel,{
  empty_title: "Detail Uploads",
  ls_bbar_actions: [ { "itemId": "put", "menu_item_text": "Speichern", "tooltip": "\u00c4nderungen in diesem Formular speichern", "panel_btn_handler": function(panel){panel.save(null,false,'put')}, "iconCls": "x-tbar-save", "overflowText": "Speichern", "auto_save": false }, { "itemId": "insert", "menu_item_text": "Neu", "must_save": true, "tooltip": "Neuen Datensatz erstellen", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-new", "overflowText": "Neu", "auto_save": true }, { "itemId": null, "menu_item_text": "L\u00f6schen", "tooltip": "Diesen Datensatz l\u00f6schen", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "L\u00f6schen", "auto_save": false } ],
  ls_url: "/uploads/Uploads",
  action_name: "detail",
  initComponent : function() {
    this.ls_detail_handler = Lino.uploads.Uploads.detail;
    this.ls_insert_handler = Lino.uploads.Uploads.insert;
    Lino.uploads.Uploads.detailPanel.superclass.initComponent.call(this);
  }
});

Lino.uploads.Uploads.detail = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.uploads.Uploads.detailPanel(p);
});
Lino.uploads.Uploads.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.uploads.Uploads.GridPanel(p);
});

// js_render_GridPanel_class households.Types
Lino.households.Types.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "Keine Daten anzuzeigen." },
  ls_url : "/households/Types",
  ls_bbar_actions : [ { "itemId": "insert", "menu_item_text": "Neu", "must_save": true, "tooltip": "Neuen Datensatz erstellen", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-new", "overflowText": "Neu", "auto_save": true }, { "itemId": "detail", "menu_item_text": "Detail", "tooltip": "Detail-Fenster auf diesem Datensatz \u00f6ffnen", "panel_btn_handler": Lino.show_detail, "iconCls": "x-tbar-detail", "overflowText": "Detail", "auto_save": true }, { "itemId": null, "menu_item_text": "L\u00f6schen", "tooltip": "Diesen Datensatz l\u00f6schen", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "L\u00f6schen", "auto_save": false } ],
  title : "Haushaltsarten",
  page_length : 20,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "type": "int", "name": "id" }, { "name": "name" }, { "name": "name_fr" }, { "name": "name_nl" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 0,
  ls_grid_configs : [  ],
  content_type : 42,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 5,
  initComponent : function() {
    this.ls_detail_handler = Lino.households.Types.detail;
    this.ls_insert_handler = Lino.households.Types.insert;
    var ww = this.containing_window;
    var id2653 = new Ext.form.NumberField({ "selectOnFocus": true });
    var name2654 = new Ext.form.TextField({ "selectOnFocus": true, "allowBlank": false, "maxLength": 200 });
    var name_fr2655 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var name_nl2656 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ new Lino.NullNumberColumn({ "colIndex": 0, "sortable": true, "format": "0", "editable": true, "filter": { "type": "numeric" }, "header": "ID", "renderer": Lino.id_renderer, "editor": id2653, "width": Lino.chars2width(6), "dataIndex": "id" }), { "colIndex": 1, "sortable": true, "header": "Bezeichnung", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "name", "editor": name2654 }, { "colIndex": 2, "sortable": true, "header": "Bezeichnung (fr)", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "name_fr", "editor": name_fr2655 }, { "colIndex": 3, "sortable": true, "header": "Bezeichnung (nl)", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "name_nl", "editor": name_nl2656 } ];
    Lino.households.Types.GridPanel.superclass.initComponent.call(this);
  }
});


Lino.households.Types.insertPanel = Ext.extend(Lino.households.Types.DetailFormPanel,{
  empty_title: "Neu Haushaltsarten",
  hide_navigator: true,
  ls_bbar_actions: [ { "itemId": "post", "menu_item_text": "Erstellen", "tooltip": "Datensatz erstellen und dann im Detail-Fenster \u00f6ffnen", "panel_btn_handler": function(panel){panel.save(null,true,'post')}, "text": "Erstellen", "overflowText": "Erstellen", "auto_save": false }, { "itemId": "poststay", "menu_item_text": "Erstellen ohne Detail", "tooltip": "Nach Erstellen des Datensatzes kein Detail-Fenster \u00f6ffnen", "panel_btn_handler": function(panel){panel.save(null,false,'poststay')}, "text": "Erstellen ohne Detail", "overflowText": "Erstellen ohne Detail", "auto_save": false } ],
  ls_url: "/households/Types",
  action_name: "insert",
  initComponent : function() {
    this.ls_detail_handler = Lino.households.Types.detail;
    this.ls_insert_handler = Lino.households.Types.insert;
    Lino.households.Types.insertPanel.superclass.initComponent.call(this);
  }
});

Lino.households.Types.insert = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.households.Types.insertPanel(p);
});

Lino.households.Types.detailPanel = Ext.extend(Lino.households.Types.DetailFormPanel,{
  empty_title: "Detail Haushaltsarten",
  ls_bbar_actions: [ { "itemId": "put", "menu_item_text": "Speichern", "tooltip": "\u00c4nderungen in diesem Formular speichern", "panel_btn_handler": function(panel){panel.save(null,false,'put')}, "iconCls": "x-tbar-save", "overflowText": "Speichern", "auto_save": false }, { "itemId": "insert", "menu_item_text": "Neu", "must_save": true, "tooltip": "Neuen Datensatz erstellen", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-new", "overflowText": "Neu", "auto_save": true }, { "itemId": null, "menu_item_text": "L\u00f6schen", "tooltip": "Diesen Datensatz l\u00f6schen", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "L\u00f6schen", "auto_save": false } ],
  ls_url: "/households/Types",
  action_name: "detail",
  initComponent : function() {
    this.ls_detail_handler = Lino.households.Types.detail;
    this.ls_insert_handler = Lino.households.Types.insert;
    Lino.households.Types.detailPanel.superclass.initComponent.call(this);
  }
});

Lino.households.Types.detail = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.households.Types.detailPanel(p);
});
Lino.households.Types.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.households.Types.GridPanel(p);
});

// js_render_GridPanel_class households.Households
Lino.households.Households.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "Keine Daten anzuzeigen." },
  ls_url : "/households/Households",
  ls_bbar_actions : [ { "itemId": "insert", "menu_item_text": "Neu", "must_save": true, "tooltip": "Neuen Datensatz erstellen", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-new", "overflowText": "Neu", "auto_save": true }, { "itemId": "detail", "menu_item_text": "Detail", "tooltip": "Detail-Fenster auf diesem Datensatz \u00f6ffnen", "panel_btn_handler": Lino.show_detail, "iconCls": "x-tbar-detail", "overflowText": "Detail", "auto_save": true }, { "itemId": null, "menu_item_text": "L\u00f6schen", "tooltip": "Diesen Datensatz l\u00f6schen", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "L\u00f6schen", "auto_save": false } ],
  title : "Haushalte",
  page_length : 20,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "name": "name" }, { "name": "email" }, { "name": "created" }, { "name": "modified" }, { "name": "country" }, 'countryHidden', { "name": "city" }, 'cityHidden', { "name": "region" }, 'regionHidden', { "name": "zip_code" }, { "name": "addr1" }, { "name": "street_prefix" }, { "name": "street" }, { "name": "street_no" }, { "name": "street_box" }, { "name": "addr2" }, { "name": "language" }, 'languageHidden', { "name": "url" }, { "name": "phone" }, { "name": "gsm" }, { "name": "fax" }, { "name": "remarks" }, { "type": "boolean", "name": "is_obsolete" }, { "name": "activity" }, 'activityHidden', { "name": "bank_account1" }, { "name": "bank_account2" }, { "name": "prefix" }, { "name": "type" }, 'typeHidden', { "type": "int", "name": "id" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 32,
  ls_grid_configs : [  ],
  content_type : 41,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 34,
  initComponent : function() {
    this.ls_detail_handler = Lino.households.Households.detail;
    this.ls_insert_handler = Lino.households.Households.insert;
    var ww = this.containing_window;
    var name2658 = new Ext.form.TextField({ "selectOnFocus": true, "allowBlank": false, "maxLength": 200 });
    var email2659 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 75 });
    var created2660 = new Ext.form.DisplayField({ "disabled": true, "value": "<br>" });
    var modified2661 = new Ext.form.DisplayField({ "disabled": true, "value": "<br>" });
    var country2662 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/households/Households/country", "method": "GET" }) }), "pageSize": 20, "emptyText": "Land ausw\u00e4hlen..." });
    var city2663 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "forceSelection": false, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/households/Households/city", "method": "GET" }) }), "pageSize": 20, "emptyText": "Ort ausw\u00e4hlen..." });
    var region2664 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/households/Households/region", "method": "GET" }) }), "pageSize": 20, "emptyText": "Ort ausw\u00e4hlen..." });
    var zip_code2665 = new Ext.form.TextField({ "selectOnFocus": true, "boxMinWidth": Lino.chars2width(10), "maxLength": 10 });
    var addr12666 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var street_prefix2667 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var street2668 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var street_no2669 = new Ext.form.TextField({ "selectOnFocus": true, "boxMinWidth": Lino.chars2width(10), "maxLength": 10 });
    var street_box2670 = new Ext.form.TextField({ "selectOnFocus": true, "boxMinWidth": Lino.chars2width(10), "maxLength": 10 });
    var addr22671 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var language2672 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "store": [ [ "de", "Deutsch" ], [ "fr", "Franz\u00f6sisch" ], [ "nl", "Niederl\u00e4ndisch" ] ], "allowBlank": false, "value": "de" });
    var url2673 = new Lino.URLField({ "selectOnFocus": true, "maxLength": 200 });
    var phone2674 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var gsm2675 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var fax2676 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var remarks2677 = new Ext.form.TextArea({ "selectOnFocus": true, "growMax": 2000 });
    var is_obsolete2678 = new Ext.form.Checkbox({ "selectOnFocus": true, "checked": false });
    var activity2679 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/households/Households/activity", "method": "GET" }) }), "pageSize": 20, "emptyText": "Beruf ausw\u00e4hlen..." });
    var bank_account12680 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 40 });
    var bank_account22681 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 40 });
    var prefix2682 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var type2683 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/households/Households/type", "method": "GET" }) }), "pageSize": 20, "emptyText": "Haushaltsart ausw\u00e4hlen..." });
    var id2684 = new Ext.form.NumberField({ "selectOnFocus": true });
    this.before_row_edit = function(record) {
      city2663.setContextValue('country',record ? record.data['countryHidden'] : undefined);
      city2663.setContextValue('region',record ? record.data['regionHidden'] : undefined);
      region2664.setContextValue('country',record ? record.data['countryHidden'] : undefined);
    };
    this.onRender = function(ct, position) {
      country2662.on('change',Lino.chooser_handler(city2663,'country'));
      region2664.on('change',Lino.chooser_handler(city2663,'region'));
      country2662.on('change',Lino.chooser_handler(region2664,'country'));
      Lino.households.Households.GridPanel.superclass.onRender.call(this, ct, position);
    }
    this.ls_columns = [ { "colIndex": 0, "sortable": true, "header": "Name", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "name", "editor": name2658 }, { "colIndex": 1, "sortable": true, "header": "E-Mail", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "email", "editor": email2659 }, { "width": Lino.chars2width(17), "colIndex": 2, "sortable": true, "dataIndex": "created", "header": "Erstellt", "hidden": true, "editable": false }, { "width": Lino.chars2width(17), "colIndex": 3, "sortable": true, "dataIndex": "modified", "header": "Bearbeitet", "hidden": true, "editable": false }, { "colIndex": 4, "sortable": true, "header": "Land", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('countryHidden','Lino.countries.Countries.detail'), "editor": country2662, "dataIndex": "country" }, { "colIndex": 5, "sortable": true, "header": "Ort", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "city", "editor": city2663 }, { "colIndex": 6, "sortable": true, "header": "Region", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "region", "editor": region2664 }, { "colIndex": 7, "sortable": true, "header": "Postleitzahl", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(12), "dataIndex": "zip_code", "editor": zip_code2665 }, { "colIndex": 8, "sortable": true, "header": "Adresszeile vor Stra\u00dfe", "editable": true, "tooltip": "Address line before street", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "addr1", "editor": addr12666 }, { "colIndex": 9, "sortable": true, "header": "Pr\u00e4fix Stra\u00dfe", "editable": true, "tooltip": "Text to print before name of street, but to ignore for sorting.", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "street_prefix", "editor": street_prefix2667 }, { "colIndex": 10, "sortable": true, "header": "Stra\u00dfe", "editable": true, "tooltip": "Name of street. Without house number.", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "street", "editor": street2668 }, { "colIndex": 11, "sortable": true, "header": "Nr.", "editable": true, "tooltip": "House number", "filter": { "type": "string" }, "width": Lino.chars2width(12), "dataIndex": "street_no", "editor": street_no2669 }, { "colIndex": 12, "sortable": true, "header": "Box", "editable": true, "tooltip": "Text to print after :attr:`steet_no` on the same line", "filter": { "type": "string" }, "width": Lino.chars2width(12), "dataIndex": "street_box", "editor": street_box2670 }, { "colIndex": 13, "sortable": true, "header": "Adresszeile nach Stra\u00dfe", "editable": true, "tooltip": "Address line to print below street line", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "addr2", "editor": addr22671 }, { "colIndex": 14, "sortable": true, "header": "Sprache", "editable": true, "tooltip": "Die Sprache, in der Dokumente ausgestellt werden sollen.", "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "language", "editor": language2672 }, { "colIndex": 15, "sortable": true, "header": "URL", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "url", "editor": url2673 }, { "colIndex": 16, "sortable": true, "header": "Telefon", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "phone", "editor": phone2674 }, { "colIndex": 17, "sortable": true, "header": "GSM", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "gsm", "editor": gsm2675 }, { "colIndex": 18, "sortable": true, "header": "Fax", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "fax", "editor": fax2676 }, { "colIndex": 19, "sortable": false, "header": "Bemerkungen", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(61), "renderer": Lino.text_renderer, "editor": remarks2677, "dataIndex": "remarks" }, { "colIndex": 20, "sortable": false, "xtype": "checkcolumn", "header": "veraltet", "editable": true, "tooltip": "Altf\u00e4lle sind Partner, deren Stammdaten nicht mehr gepflegt werden und \nf\u00fcr neue Operationen nicht benutzt werden k\u00f6nnen.", "filter": { "type": "boolean" }, "width": Lino.chars2width(11), "dataIndex": "is_obsolete" }, { "colIndex": 21, "sortable": true, "header": "Beruf", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "activity", "hidden": true, "editor": activity2679 }, { "colIndex": 22, "sortable": true, "header": "Bankkonto 1", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "bank_account1", "hidden": true, "editor": bank_account12680 }, { "colIndex": 23, "sortable": true, "header": "Bankkonto 2", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "bank_account2", "hidden": true, "editor": bank_account22681 }, { "colIndex": 24, "sortable": true, "header": "prefix", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "prefix", "editor": prefix2682 }, { "colIndex": 25, "sortable": true, "header": "Haushaltsart", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('typeHidden','Lino.households.Types.detail'), "editor": type2683, "dataIndex": "type" }, new Lino.NullNumberColumn({ "colIndex": 26, "sortable": true, "format": "0", "editable": true, "filter": { "type": "numeric" }, "header": "ID", "renderer": Lino.id_renderer, "editor": id2684, "width": Lino.chars2width(6), "dataIndex": "id" }) ];
    Lino.households.Households.GridPanel.superclass.initComponent.call(this);
  }
});


Lino.households.Households.insertPanel = Ext.extend(Lino.contacts.Partners.InsertFormPanel,{
  empty_title: "Neu Haushalte",
  hide_navigator: true,
  ls_bbar_actions: [ { "itemId": "post", "menu_item_text": "Erstellen", "tooltip": "Datensatz erstellen und dann im Detail-Fenster \u00f6ffnen", "panel_btn_handler": function(panel){panel.save(null,true,'post')}, "text": "Erstellen", "overflowText": "Erstellen", "auto_save": false }, { "itemId": "poststay", "menu_item_text": "Erstellen ohne Detail", "tooltip": "Nach Erstellen des Datensatzes kein Detail-Fenster \u00f6ffnen", "panel_btn_handler": function(panel){panel.save(null,false,'poststay')}, "text": "Erstellen ohne Detail", "overflowText": "Erstellen ohne Detail", "auto_save": false } ],
  ls_url: "/households/Households",
  action_name: "insert",
  initComponent : function() {
    this.ls_detail_handler = Lino.households.Households.detail;
    this.ls_insert_handler = Lino.households.Households.insert;
    Lino.households.Households.insertPanel.superclass.initComponent.call(this);
  }
});

Lino.households.Households.insert = new Lino.WindowAction({ "draggable": true, "width": Lino.chars2width(40), "autoHeight": true, "maximizable": true, "modal": true, "maximized": false },function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.households.Households.insertPanel(p);
});

Lino.households.Households.detailPanel = Ext.extend(Lino.households.Households.DetailFormPanel,{
  empty_title: "Detail Haushalte",
  ls_bbar_actions: [ { "itemId": "put", "menu_item_text": "Speichern", "tooltip": "\u00c4nderungen in diesem Formular speichern", "panel_btn_handler": function(panel){panel.save(null,false,'put')}, "iconCls": "x-tbar-save", "overflowText": "Speichern", "auto_save": false }, { "itemId": "insert", "menu_item_text": "Neu", "must_save": true, "tooltip": "Neuen Datensatz erstellen", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-new", "overflowText": "Neu", "auto_save": true }, { "itemId": null, "menu_item_text": "L\u00f6schen", "tooltip": "Diesen Datensatz l\u00f6schen", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "L\u00f6schen", "auto_save": false } ],
  ls_url: "/households/Households",
  action_name: "detail",
  initComponent : function() {
    this.ls_detail_handler = Lino.households.Households.detail;
    this.ls_insert_handler = Lino.households.Households.insert;
    Lino.households.Households.detailPanel.superclass.initComponent.call(this);
  }
});

Lino.households.Households.detail = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.households.Households.detailPanel(p);
});
Lino.households.Households.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.households.Households.GridPanel(p);
});

// js_render_GridPanel_class households.Roles
Lino.households.Roles.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "Keine Daten anzuzeigen." },
  ls_url : "/households/Roles",
  ls_bbar_actions : [ { "itemId": "insert", "menu_item_text": "Neu", "must_save": true, "tooltip": "Neuen Datensatz erstellen", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-new", "overflowText": "Neu", "auto_save": true }, { "itemId": "detail", "menu_item_text": "Detail", "tooltip": "Detail-Fenster auf diesem Datensatz \u00f6ffnen", "panel_btn_handler": Lino.show_detail, "iconCls": "x-tbar-detail", "overflowText": "Detail", "auto_save": true }, { "itemId": null, "menu_item_text": "L\u00f6schen", "tooltip": "Diesen Datensatz l\u00f6schen", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "L\u00f6schen", "auto_save": false } ],
  title : "Rollen in Haushalt",
  page_length : 20,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "type": "int", "name": "id" }, { "name": "name" }, { "name": "name_fr" }, { "name": "name_nl" }, { "type": "boolean", "name": "name_giving" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 0,
  ls_grid_configs : [  ],
  content_type : 40,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 6,
  initComponent : function() {
    this.ls_detail_handler = Lino.households.Roles.detail;
    this.ls_insert_handler = Lino.households.Roles.insert;
    var ww = this.containing_window;
    var id2686 = new Ext.form.NumberField({ "selectOnFocus": true });
    var name2687 = new Ext.form.TextField({ "selectOnFocus": true, "allowBlank": false, "maxLength": 200 });
    var name_fr2688 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var name_nl2689 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var name_giving2690 = new Ext.form.Checkbox({ "selectOnFocus": true, "checked": false });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ new Lino.NullNumberColumn({ "colIndex": 0, "sortable": true, "format": "0", "editable": true, "filter": { "type": "numeric" }, "header": "ID", "renderer": Lino.id_renderer, "editor": id2686, "width": Lino.chars2width(6), "dataIndex": "id" }), { "colIndex": 1, "sortable": true, "header": "Bezeichnung", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "name", "editor": name2687 }, { "colIndex": 2, "sortable": true, "header": "Bezeichnung (fr)", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "name_fr", "editor": name_fr2688 }, { "colIndex": 3, "sortable": true, "header": "Bezeichnung (nl)", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "name_nl", "editor": name_nl2689 }, { "colIndex": 4, "sortable": false, "xtype": "checkcolumn", "header": "namensgebend", "editable": true, "tooltip": "When the `name` field of a Household is empty, \nits value is computed by joining the `Last Name` \nof all name-giving members with a dash (\"-\").\n      ", "filter": { "type": "boolean" }, "width": Lino.chars2width(11), "dataIndex": "name_giving" } ];
    Lino.households.Roles.GridPanel.superclass.initComponent.call(this);
  }
});


Lino.households.Roles.insertPanel = Ext.extend(Lino.households.Roles.DetailFormPanel,{
  empty_title: "Neu Rollen in Haushalt",
  hide_navigator: true,
  ls_bbar_actions: [ { "itemId": "post", "menu_item_text": "Erstellen", "tooltip": "Datensatz erstellen und dann im Detail-Fenster \u00f6ffnen", "panel_btn_handler": function(panel){panel.save(null,true,'post')}, "text": "Erstellen", "overflowText": "Erstellen", "auto_save": false }, { "itemId": "poststay", "menu_item_text": "Erstellen ohne Detail", "tooltip": "Nach Erstellen des Datensatzes kein Detail-Fenster \u00f6ffnen", "panel_btn_handler": function(panel){panel.save(null,false,'poststay')}, "text": "Erstellen ohne Detail", "overflowText": "Erstellen ohne Detail", "auto_save": false } ],
  ls_url: "/households/Roles",
  action_name: "insert",
  initComponent : function() {
    this.ls_detail_handler = Lino.households.Roles.detail;
    this.ls_insert_handler = Lino.households.Roles.insert;
    Lino.households.Roles.insertPanel.superclass.initComponent.call(this);
  }
});

Lino.households.Roles.insert = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.households.Roles.insertPanel(p);
});

Lino.households.Roles.detailPanel = Ext.extend(Lino.households.Roles.DetailFormPanel,{
  empty_title: "Detail Rollen in Haushalt",
  ls_bbar_actions: [ { "itemId": "put", "menu_item_text": "Speichern", "tooltip": "\u00c4nderungen in diesem Formular speichern", "panel_btn_handler": function(panel){panel.save(null,false,'put')}, "iconCls": "x-tbar-save", "overflowText": "Speichern", "auto_save": false }, { "itemId": "insert", "menu_item_text": "Neu", "must_save": true, "tooltip": "Neuen Datensatz erstellen", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-new", "overflowText": "Neu", "auto_save": true }, { "itemId": null, "menu_item_text": "L\u00f6schen", "tooltip": "Diesen Datensatz l\u00f6schen", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "L\u00f6schen", "auto_save": false } ],
  ls_url: "/households/Roles",
  action_name: "detail",
  initComponent : function() {
    this.ls_detail_handler = Lino.households.Roles.detail;
    this.ls_insert_handler = Lino.households.Roles.insert;
    Lino.households.Roles.detailPanel.superclass.initComponent.call(this);
  }
});

Lino.households.Roles.detail = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.households.Roles.detailPanel(p);
});
Lino.households.Roles.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.households.Roles.GridPanel(p);
});

// js_render_GridPanel_class households.Members
Lino.households.Members.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "Keine Daten anzuzeigen." },
  ls_url : "/households/Members",
  ls_bbar_actions : [ { "itemId": null, "menu_item_text": "L\u00f6schen", "tooltip": "Diesen Datensatz l\u00f6schen", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "L\u00f6schen", "auto_save": false } ],
  title : "Mitglieder",
  page_length : 20,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "type": "int", "name": "id" }, { "name": "role" }, 'roleHidden', { "name": "household" }, 'householdHidden', { "name": "person" }, 'personHidden', { "type": "date", "name": "start_date", "dateFormat": "d.m.Y" }, { "type": "date", "name": "end_date", "dateFormat": "d.m.Y" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 0,
  ls_grid_configs : [  ],
  content_type : 39,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 10,
  initComponent : function() {
    var ww = this.containing_window;
    var id2692 = new Ext.form.NumberField({ "selectOnFocus": true });
    var role2693 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/households/Members/role", "method": "GET" }) }), "pageSize": 20, "emptyText": "Rolle in Haushalt ausw\u00e4hlen..." });
    var household2694 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/households/Members/household", "method": "GET" }) }), "allowBlank": false, "pageSize": 20, "emptyText": "Haushalt ausw\u00e4hlen..." });
    var person2695 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/households/Members/person", "method": "GET" }) }), "allowBlank": false, "pageSize": 20, "emptyText": "Person ausw\u00e4hlen..." });
    var start_date2696 = new Lino.DateField({ "selectOnFocus": true });
    var end_date2697 = new Lino.DateField({ "selectOnFocus": true });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ new Lino.NullNumberColumn({ "colIndex": 0, "sortable": true, "format": "0", "editable": true, "filter": { "type": "numeric" }, "header": "ID", "renderer": Lino.id_renderer, "editor": id2692, "width": Lino.chars2width(6), "dataIndex": "id" }), { "colIndex": 1, "sortable": true, "header": "Rolle in Haushalt", "editable": true, "tooltip": "The Role of this Person in this Household.\nList of choices is configured in `Configure --> Households --> Roles`.\n", "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('roleHidden','Lino.households.Roles.detail'), "editor": role2693, "dataIndex": "role" }, { "colIndex": 2, "sortable": true, "header": "Haushalt", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('householdHidden','Lino.households.Households.detail'), "editor": household2694, "dataIndex": "household" }, { "colIndex": 3, "sortable": true, "header": "Person", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('personHidden','Lino.contacts.Persons.detail'), "editor": person2695, "dataIndex": "person" }, { "colIndex": 4, "sortable": true, "xtype": "datecolumn", "format": "d.m.Y", "editable": true, "filter": { "type": "date", "dateFormat": "d.m.Y" }, "header": "From", "editor": start_date2696, "width": Lino.chars2width(9), "dataIndex": "start_date" }, { "colIndex": 5, "sortable": true, "xtype": "datecolumn", "format": "d.m.Y", "editable": true, "filter": { "type": "date", "dateFormat": "d.m.Y" }, "header": "Until", "editor": end_date2697, "width": Lino.chars2width(9), "dataIndex": "end_date" } ];
    Lino.households.Members.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.households.Members.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.households.Members.GridPanel(p);
});

// js_render_GridPanel_class accounts.Charts
Lino.accounts.Charts.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "Keine Daten anzuzeigen." },
  ls_url : "/accounts/Charts",
  ls_bbar_actions : [ { "itemId": "insert", "menu_item_text": "Neu", "must_save": true, "tooltip": "Neuen Datensatz erstellen", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-new", "overflowText": "Neu", "auto_save": true }, { "itemId": "detail", "menu_item_text": "Detail", "tooltip": "Detail-Fenster auf diesem Datensatz \u00f6ffnen", "panel_btn_handler": Lino.show_detail, "iconCls": "x-tbar-detail", "overflowText": "Detail", "auto_save": true }, { "itemId": null, "menu_item_text": "L\u00f6schen", "tooltip": "Diesen Datensatz l\u00f6schen", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "L\u00f6schen", "auto_save": false } ],
  title : "Kontenpl\u00e4ne",
  page_length : 20,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "type": "int", "name": "id" }, { "name": "name" }, { "name": "name_fr" }, { "name": "name_nl" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 0,
  ls_grid_configs : [  ],
  content_type : 45,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 5,
  initComponent : function() {
    this.ls_detail_handler = Lino.accounts.Charts.detail;
    this.ls_insert_handler = Lino.accounts.Charts.insert;
    var ww = this.containing_window;
    var id2699 = new Ext.form.NumberField({ "selectOnFocus": true });
    var name2700 = new Ext.form.TextField({ "selectOnFocus": true, "allowBlank": false, "maxLength": 200 });
    var name_fr2701 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var name_nl2702 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ new Lino.NullNumberColumn({ "colIndex": 0, "sortable": true, "format": "0", "editable": true, "filter": { "type": "numeric" }, "header": "ID", "renderer": Lino.id_renderer, "editor": id2699, "width": Lino.chars2width(6), "dataIndex": "id" }), { "colIndex": 1, "sortable": true, "header": "Bezeichnung", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "name", "editor": name2700 }, { "colIndex": 2, "sortable": true, "header": "Bezeichnung (fr)", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "name_fr", "editor": name_fr2701 }, { "colIndex": 3, "sortable": true, "header": "Bezeichnung (nl)", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "name_nl", "editor": name_nl2702 } ];
    Lino.accounts.Charts.GridPanel.superclass.initComponent.call(this);
  }
});


Lino.accounts.Charts.insertPanel = Ext.extend(Lino.accounts.Charts.DetailFormPanel,{
  empty_title: "Neu Kontenpl\u00e4ne",
  hide_navigator: true,
  ls_bbar_actions: [ { "itemId": "post", "menu_item_text": "Erstellen", "tooltip": "Datensatz erstellen und dann im Detail-Fenster \u00f6ffnen", "panel_btn_handler": function(panel){panel.save(null,true,'post')}, "text": "Erstellen", "overflowText": "Erstellen", "auto_save": false }, { "itemId": "poststay", "menu_item_text": "Erstellen ohne Detail", "tooltip": "Nach Erstellen des Datensatzes kein Detail-Fenster \u00f6ffnen", "panel_btn_handler": function(panel){panel.save(null,false,'poststay')}, "text": "Erstellen ohne Detail", "overflowText": "Erstellen ohne Detail", "auto_save": false } ],
  ls_url: "/accounts/Charts",
  action_name: "insert",
  initComponent : function() {
    this.ls_detail_handler = Lino.accounts.Charts.detail;
    this.ls_insert_handler = Lino.accounts.Charts.insert;
    Lino.accounts.Charts.insertPanel.superclass.initComponent.call(this);
  }
});

Lino.accounts.Charts.insert = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.accounts.Charts.insertPanel(p);
});

Lino.accounts.Charts.detailPanel = Ext.extend(Lino.accounts.Charts.DetailFormPanel,{
  empty_title: "Detail Kontenpl\u00e4ne",
  ls_bbar_actions: [ { "itemId": "put", "menu_item_text": "Speichern", "tooltip": "\u00c4nderungen in diesem Formular speichern", "panel_btn_handler": function(panel){panel.save(null,false,'put')}, "iconCls": "x-tbar-save", "overflowText": "Speichern", "auto_save": false }, { "itemId": "insert", "menu_item_text": "Neu", "must_save": true, "tooltip": "Neuen Datensatz erstellen", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-new", "overflowText": "Neu", "auto_save": true }, { "itemId": null, "menu_item_text": "L\u00f6schen", "tooltip": "Diesen Datensatz l\u00f6schen", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "L\u00f6schen", "auto_save": false } ],
  ls_url: "/accounts/Charts",
  action_name: "detail",
  initComponent : function() {
    this.ls_detail_handler = Lino.accounts.Charts.detail;
    this.ls_insert_handler = Lino.accounts.Charts.insert;
    Lino.accounts.Charts.detailPanel.superclass.initComponent.call(this);
  }
});

Lino.accounts.Charts.detail = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.accounts.Charts.detailPanel(p);
});
Lino.accounts.Charts.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.accounts.Charts.GridPanel(p);
});

// js_render_GridPanel_class accounts.Groups
Lino.accounts.Groups.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "Keine Daten anzuzeigen." },
  ls_url : "/accounts/Groups",
  ls_bbar_actions : [ { "itemId": "insert", "menu_item_text": "Neu", "must_save": true, "tooltip": "Neuen Datensatz erstellen", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-new", "overflowText": "Neu", "auto_save": true }, { "itemId": "detail", "menu_item_text": "Detail", "tooltip": "Detail-Fenster auf diesem Datensatz \u00f6ffnen", "panel_btn_handler": Lino.show_detail, "iconCls": "x-tbar-detail", "overflowText": "Detail", "auto_save": true }, { "itemId": null, "menu_item_text": "L\u00f6schen", "tooltip": "Diesen Datensatz l\u00f6schen", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "L\u00f6schen", "auto_save": false } ],
  title : "Kontengruppen",
  page_length : 20,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "name": "chart" }, 'chartHidden', { "name": "ref" }, { "name": "name" }, { "name": "name_fr" }, { "name": "name_nl" }, { "name": "account_type" }, 'account_typeHidden', { "type": "int", "name": "id" }, { "name": "help_text" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 8,
  ls_grid_configs : [  ],
  content_type : 44,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 11,
  initComponent : function() {
    this.ls_detail_handler = Lino.accounts.Groups.detail;
    this.ls_insert_handler = Lino.accounts.Groups.insert;
    var ww = this.containing_window;
    var chart2704 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/accounts/Groups/chart", "method": "GET" }) }), "allowBlank": false, "pageSize": 20, "emptyText": "Kontenplan ausw\u00e4hlen..." });
    var ref2705 = new Ext.form.TextField({ "selectOnFocus": true, "boxMinWidth": Lino.chars2width(5), "maxLength": 5 });
    var name2706 = new Ext.form.TextField({ "selectOnFocus": true, "allowBlank": false, "maxLength": 200 });
    var name_fr2707 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var name_nl2708 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var account_type2709 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "forceSelection": true, "store": Lino.accounts.AccountTypes });
    var id2710 = new Ext.form.NumberField({ "selectOnFocus": true });
    var help_text2711 = new Lino.RichTextPanel({ "selectOnFocus": true, "containing_panel": this, "title": "Einleitung" });
    this.before_row_edit = function(record) {
      help_text2711.refresh();
    };
    this.ls_columns = [ { "colIndex": 0, "sortable": true, "header": "Kontenplan", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('chartHidden','Lino.accounts.Charts.detail'), "editor": chart2704, "dataIndex": "chart" }, { "colIndex": 1, "sortable": true, "header": "ref", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(7), "dataIndex": "ref", "editor": ref2705 }, { "colIndex": 2, "sortable": true, "header": "Bezeichnung", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "name", "editor": name2706 }, { "colIndex": 3, "sortable": true, "header": "Bezeichnung (fr)", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "name_fr", "editor": name_fr2707 }, { "colIndex": 4, "sortable": true, "header": "Bezeichnung (nl)", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "name_nl", "editor": name_nl2708 }, { "colIndex": 5, "sortable": true, "header": "Kontenart", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(19), "dataIndex": "account_type", "editor": account_type2709 }, new Lino.NullNumberColumn({ "colIndex": 6, "sortable": true, "format": "0", "editable": true, "filter": { "type": "numeric" }, "header": "ID", "renderer": Lino.id_renderer, "editor": id2710, "width": Lino.chars2width(6), "dataIndex": "id" }), { "colIndex": 7, "sortable": false, "header": "help_text", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(61), "renderer": Lino.text_renderer, "editor": help_text2711, "dataIndex": "help_text" } ];
    Lino.accounts.Groups.GridPanel.superclass.initComponent.call(this);
  }
});


Lino.accounts.Groups.insertPanel = Ext.extend(Lino.accounts.Groups.DetailFormPanel,{
  empty_title: "Neu Kontengruppen",
  hide_navigator: true,
  ls_bbar_actions: [ { "itemId": "post", "menu_item_text": "Erstellen", "tooltip": "Datensatz erstellen und dann im Detail-Fenster \u00f6ffnen", "panel_btn_handler": function(panel){panel.save(null,true,'post')}, "text": "Erstellen", "overflowText": "Erstellen", "auto_save": false }, { "itemId": "poststay", "menu_item_text": "Erstellen ohne Detail", "tooltip": "Nach Erstellen des Datensatzes kein Detail-Fenster \u00f6ffnen", "panel_btn_handler": function(panel){panel.save(null,false,'poststay')}, "text": "Erstellen ohne Detail", "overflowText": "Erstellen ohne Detail", "auto_save": false } ],
  ls_url: "/accounts/Groups",
  action_name: "insert",
  initComponent : function() {
    this.ls_detail_handler = Lino.accounts.Groups.detail;
    this.ls_insert_handler = Lino.accounts.Groups.insert;
    Lino.accounts.Groups.insertPanel.superclass.initComponent.call(this);
  }
});

Lino.accounts.Groups.insert = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.accounts.Groups.insertPanel(p);
});

Lino.accounts.Groups.detailPanel = Ext.extend(Lino.accounts.Groups.DetailFormPanel,{
  empty_title: "Detail Kontengruppen",
  ls_bbar_actions: [ { "itemId": "put", "menu_item_text": "Speichern", "tooltip": "\u00c4nderungen in diesem Formular speichern", "panel_btn_handler": function(panel){panel.save(null,false,'put')}, "iconCls": "x-tbar-save", "overflowText": "Speichern", "auto_save": false }, { "itemId": "insert", "menu_item_text": "Neu", "must_save": true, "tooltip": "Neuen Datensatz erstellen", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-new", "overflowText": "Neu", "auto_save": true }, { "itemId": null, "menu_item_text": "L\u00f6schen", "tooltip": "Diesen Datensatz l\u00f6schen", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "L\u00f6schen", "auto_save": false } ],
  ls_url: "/accounts/Groups",
  action_name: "detail",
  initComponent : function() {
    this.ls_detail_handler = Lino.accounts.Groups.detail;
    this.ls_insert_handler = Lino.accounts.Groups.insert;
    Lino.accounts.Groups.detailPanel.superclass.initComponent.call(this);
  }
});

Lino.accounts.Groups.detail = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.accounts.Groups.detailPanel(p);
});
Lino.accounts.Groups.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.accounts.Groups.GridPanel(p);
});

// js_render_GridPanel_class accounts.Accounts
Lino.accounts.Accounts.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "Keine Daten anzuzeigen." },
  ls_url : "/accounts/Accounts",
  ls_bbar_actions : [ { "itemId": "duplicate", "menu_item_text": "Duplizieren", "must_save": true, "tooltip": "Duplizieren", "panel_btn_handler": Lino.row_action_handler('duplicate','GET'), "iconCls": "x-tbar-duplicate", "overflowText": "Duplizieren", "auto_save": true }, { "itemId": null, "menu_item_text": "L\u00f6schen", "tooltip": "Diesen Datensatz l\u00f6schen", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "L\u00f6schen", "auto_save": false }, { "itemId": "move_up", "menu_item_text": "Up", "must_save": true, "panel_btn_handler": Lino.row_action_handler('move_up','GET'), "text": "Up", "overflowText": "Up", "auto_save": true }, { "itemId": "move_down", "menu_item_text": "Down", "must_save": true, "panel_btn_handler": Lino.row_action_handler('move_down','GET'), "text": "Down", "overflowText": "Down", "auto_save": true } ],
  title : "Konten",
  page_length : 20,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "name": "ref" }, { "name": "name" }, { "name": "name_fr" }, { "name": "name_nl" }, { "name": "default_amount" }, { "name": "periods" }, { "type": "boolean", "name": "required_for_household" }, { "type": "boolean", "name": "required_for_person" }, { "name": "group" }, 'groupHidden', { "type": "int", "name": "id" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 10,
  ls_grid_configs : [  ],
  content_type : 43,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 12,
  initComponent : function() {
    var ww = this.containing_window;
    var ref2713 = new Ext.form.TextField({ "selectOnFocus": true, "boxMinWidth": Lino.chars2width(5), "maxLength": 5 });
    var name2714 = new Ext.form.TextField({ "selectOnFocus": true, "allowBlank": false, "maxLength": 200 });
    var name_fr2715 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var name_nl2716 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var default_amount2717 = new Ext.form.NumberField({ "selectOnFocus": true, "decimalPrecision": 2, "allowBlank": true, "decimalSeparator": "," });
    var periods2718 = new Ext.form.NumberField({ "selectOnFocus": true, "allowBlank": true, "value": 1, "allowDecimals": false });
    var required_for_household2719 = new Ext.form.Checkbox({ "selectOnFocus": true, "checked": false });
    var required_for_person2720 = new Ext.form.Checkbox({ "selectOnFocus": true, "checked": false });
    var group2721 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/accounts/Accounts/group", "method": "GET" }) }), "allowBlank": false, "pageSize": 20, "emptyText": "Kontengruppe ausw\u00e4hlen..." });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ { "colIndex": 0, "sortable": true, "header": "ref", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(7), "dataIndex": "ref", "editor": ref2713 }, { "colIndex": 1, "sortable": true, "header": "Bezeichnung", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "name", "editor": name2714 }, { "colIndex": 2, "sortable": true, "header": "Bezeichnung (fr)", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "name_fr", "editor": name_fr2715 }, { "colIndex": 3, "sortable": true, "header": "Bezeichnung (nl)", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "name_nl", "editor": name_nl2716 }, new Lino.NullNumberColumn({ "colIndex": 4, "sortable": true, "header": "Standard-Betrag", "editable": true, "filter": { "type": "numeric" }, "width": Lino.chars2width(13), "dataIndex": "default_amount", "editor": default_amount2717 }), new Lino.NullNumberColumn({ "colIndex": 5, "sortable": true, "format": "0/i", "editable": true, "tooltip": "For how many months the entered amount counts. \nFor example 1 means a monthly amount, 12 a yearly amount.", "filter": { "type": "numeric" }, "header": "Perioden", "dataIndex": "periods", "width": Lino.chars2width(6), "editor": periods2718 }), { "colIndex": 6, "sortable": false, "xtype": "checkcolumn", "header": "verpflichtend f\u00fcr Haushalte", "editable": true, "filter": { "type": "boolean" }, "width": Lino.chars2width(11), "dataIndex": "required_for_household" }, { "colIndex": 7, "sortable": false, "xtype": "checkcolumn", "header": "verpflichtend f\u00fcr Personen", "editable": true, "filter": { "type": "boolean" }, "width": Lino.chars2width(11), "dataIndex": "required_for_person" }, { "colIndex": 8, "sortable": true, "header": "Kontengruppe", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('groupHidden','Lino.accounts.Groups.detail'), "editor": group2721, "dataIndex": "group" } ];
    Lino.accounts.Accounts.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.accounts.Accounts.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.accounts.Accounts.GridPanel(p);
});
Lino.accounts.Accounts.move_up = function(rp,pk) { 
  Lino.run_row_action(rp,"/accounts/Accounts",pk,"move_up");
};
Lino.accounts.Accounts.move_down = function(rp,pk) { 
  Lino.run_row_action(rp,"/accounts/Accounts",pk,"move_down");
};

// js_render_GridPanel_class notes.NoteTypes
Lino.notes.NoteTypes.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "Keine Daten anzuzeigen." },
  ls_url : "/notes/NoteTypes",
  ls_bbar_actions : [ { "itemId": "insert", "menu_item_text": "Neu", "must_save": true, "tooltip": "Neuen Datensatz erstellen", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-new", "overflowText": "Neu", "auto_save": true }, { "itemId": "detail", "menu_item_text": "Detail", "tooltip": "Detail-Fenster auf diesem Datensatz \u00f6ffnen", "panel_btn_handler": Lino.show_detail, "iconCls": "x-tbar-detail", "overflowText": "Detail", "auto_save": true }, { "itemId": null, "menu_item_text": "L\u00f6schen", "tooltip": "Diesen Datensatz l\u00f6schen", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "L\u00f6schen", "auto_save": false } ],
  title : "Notizarten",
  page_length : 20,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "name": "name" }, { "name": "name_fr" }, { "name": "name_nl" }, { "name": "build_method" }, 'build_methodHidden', { "name": "template" }, { "type": "int", "name": "id" }, { "type": "boolean", "name": "attach_to_email" }, { "name": "email_template" }, { "type": "boolean", "name": "important" }, { "name": "remark" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 6,
  ls_grid_configs : [  ],
  content_type : 93,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 12,
  initComponent : function() {
    this.ls_detail_handler = Lino.notes.NoteTypes.detail;
    this.ls_insert_handler = Lino.notes.NoteTypes.insert;
    var ww = this.containing_window;
    var name2723 = new Ext.form.TextField({ "selectOnFocus": true, "allowBlank": false, "maxLength": 200 });
    var name_fr2724 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var name_nl2725 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var build_method2726 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "store": [ [ "appyodt", "AppyOdtBuildMethod" ], [ "appypdf", "AppyPdfBuildMethod" ], [ "appyrtf", "AppyRtfBuildMethod" ], [ "latex", "LatexBuildMethod" ], [ "pisa", "PisaBuildMethod" ], [ "rtf", "RtfBuildMethod" ] ] });
    var template2727 = new Lino.SimpleRemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/notes/NoteTypes/template", "method": "GET" }) }) });
    var id2728 = new Ext.form.NumberField({ "selectOnFocus": true });
    var attach_to_email2729 = new Ext.form.Checkbox({ "selectOnFocus": true, "checked": false });
    var email_template2730 = new Lino.SimpleRemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/notes/NoteTypes/email_template", "method": "GET" }) }) });
    var important2731 = new Ext.form.Checkbox({ "selectOnFocus": true, "checked": false });
    var remark2732 = new Ext.form.TextArea({ "selectOnFocus": true, "growMax": 2000 });
    this.before_row_edit = function(record) {
      template2727.setContextValue('build_method',record ? record.data['build_methodHidden'] : undefined);
    };
    this.onRender = function(ct, position) {
      build_method2726.on('change',Lino.chooser_handler(template2727,'build_method'));
      Lino.notes.NoteTypes.GridPanel.superclass.onRender.call(this, ct, position);
    }
    this.ls_columns = [ { "colIndex": 0, "sortable": true, "header": "Bezeichnung", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "name", "editor": name2723 }, { "colIndex": 1, "sortable": true, "header": "Bezeichnung (fr)", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "name_fr", "editor": name_fr2724 }, { "colIndex": 2, "sortable": true, "header": "Bezeichnung (nl)", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "name_nl", "editor": name_nl2725 }, { "colIndex": 3, "sortable": true, "header": "Konstruktionsmethode", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "build_method", "editor": build_method2726 }, { "colIndex": 4, "sortable": true, "header": "Vorlage", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(11), "dataIndex": "template", "editor": template2727 }, new Lino.NullNumberColumn({ "colIndex": 5, "sortable": true, "format": "0", "editable": true, "filter": { "type": "numeric" }, "header": "ID", "renderer": Lino.id_renderer, "editor": id2728, "width": Lino.chars2width(6), "dataIndex": "id" }), { "colIndex": 6, "sortable": false, "xtype": "checkcolumn", "header": "als Anhang per E-Mail", "editable": true, "tooltip": "Whether the printable file should be attached to the email\nwhen creating an email from a mailable of this type.\n", "filter": { "type": "boolean" }, "width": Lino.chars2width(11), "dataIndex": "attach_to_email" }, { "colIndex": 7, "sortable": true, "header": "E-Mail-Vorlage", "editable": true, "tooltip": "The name of the file to be used as template \nwhen creating an email from a mailable of this type.\n", "filter": { "type": "string" }, "width": Lino.chars2width(11), "dataIndex": "email_template", "editor": email_template2730 }, { "colIndex": 8, "sortable": false, "xtype": "checkcolumn", "header": "wichtig", "editable": true, "filter": { "type": "boolean" }, "width": Lino.chars2width(11), "dataIndex": "important" }, { "colIndex": 9, "sortable": false, "header": "Bemerkung", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(61), "renderer": Lino.text_renderer, "editor": remark2732, "dataIndex": "remark" } ];
    Lino.notes.NoteTypes.GridPanel.superclass.initComponent.call(this);
  }
});


Lino.notes.NoteTypes.insertPanel = Ext.extend(Lino.notes.NoteTypes.DetailFormPanel,{
  empty_title: "Neu Notizarten",
  hide_navigator: true,
  ls_bbar_actions: [ { "itemId": "post", "menu_item_text": "Erstellen", "tooltip": "Datensatz erstellen und dann im Detail-Fenster \u00f6ffnen", "panel_btn_handler": function(panel){panel.save(null,true,'post')}, "text": "Erstellen", "overflowText": "Erstellen", "auto_save": false }, { "itemId": "poststay", "menu_item_text": "Erstellen ohne Detail", "tooltip": "Nach Erstellen des Datensatzes kein Detail-Fenster \u00f6ffnen", "panel_btn_handler": function(panel){panel.save(null,false,'poststay')}, "text": "Erstellen ohne Detail", "overflowText": "Erstellen ohne Detail", "auto_save": false } ],
  ls_url: "/notes/NoteTypes",
  action_name: "insert",
  initComponent : function() {
    this.ls_detail_handler = Lino.notes.NoteTypes.detail;
    this.ls_insert_handler = Lino.notes.NoteTypes.insert;
    Lino.notes.NoteTypes.insertPanel.superclass.initComponent.call(this);
  }
});

Lino.notes.NoteTypes.insert = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.notes.NoteTypes.insertPanel(p);
});

Lino.notes.NoteTypes.detailPanel = Ext.extend(Lino.notes.NoteTypes.DetailFormPanel,{
  empty_title: "Detail Notizarten",
  ls_bbar_actions: [ { "itemId": "put", "menu_item_text": "Speichern", "tooltip": "\u00c4nderungen in diesem Formular speichern", "panel_btn_handler": function(panel){panel.save(null,false,'put')}, "iconCls": "x-tbar-save", "overflowText": "Speichern", "auto_save": false }, { "itemId": "insert", "menu_item_text": "Neu", "must_save": true, "tooltip": "Neuen Datensatz erstellen", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-new", "overflowText": "Neu", "auto_save": true }, { "itemId": null, "menu_item_text": "L\u00f6schen", "tooltip": "Diesen Datensatz l\u00f6schen", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "L\u00f6schen", "auto_save": false } ],
  ls_url: "/notes/NoteTypes",
  action_name: "detail",
  initComponent : function() {
    this.ls_detail_handler = Lino.notes.NoteTypes.detail;
    this.ls_insert_handler = Lino.notes.NoteTypes.insert;
    Lino.notes.NoteTypes.detailPanel.superclass.initComponent.call(this);
  }
});

Lino.notes.NoteTypes.detail = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.notes.NoteTypes.detailPanel(p);
});
Lino.notes.NoteTypes.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.notes.NoteTypes.GridPanel(p);
});

// js_render_GridPanel_class notes.EventTypes
Lino.notes.EventTypes.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "Keine Daten anzuzeigen." },
  ls_url : "/notes/EventTypes",
  ls_bbar_actions : [ { "itemId": "insert", "menu_item_text": "Neu", "must_save": true, "tooltip": "Neuen Datensatz erstellen", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-new", "overflowText": "Neu", "auto_save": true }, { "itemId": "detail", "menu_item_text": "Detail", "tooltip": "Detail-Fenster auf diesem Datensatz \u00f6ffnen", "panel_btn_handler": Lino.show_detail, "iconCls": "x-tbar-detail", "overflowText": "Detail", "auto_save": true }, { "itemId": null, "menu_item_text": "L\u00f6schen", "tooltip": "Diesen Datensatz l\u00f6schen", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "L\u00f6schen", "auto_save": false } ],
  title : "Ereignisarten",
  page_length : 20,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "name": "name" }, { "name": "name_fr" }, { "name": "name_nl" }, { "type": "int", "name": "id" }, { "name": "remark" }, { "name": "body" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 3,
  ls_grid_configs : [  ],
  content_type : 92,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 7,
  initComponent : function() {
    this.ls_detail_handler = Lino.notes.EventTypes.detail;
    this.ls_insert_handler = Lino.notes.EventTypes.insert;
    var ww = this.containing_window;
    var name2734 = new Ext.form.TextField({ "selectOnFocus": true, "allowBlank": false, "maxLength": 200 });
    var name_fr2735 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var name_nl2736 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var id2737 = new Ext.form.NumberField({ "selectOnFocus": true });
    var remark2738 = new Ext.form.TextArea({ "selectOnFocus": true, "growMax": 2000 });
    var body2739 = new Lino.RichTextPanel({ "selectOnFocus": true, "containing_panel": this, "title": "Inhalt" });
    this.before_row_edit = function(record) {
      body2739.refresh();
    };
    this.ls_columns = [ { "colIndex": 0, "sortable": true, "header": "Bezeichnung", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "name", "editor": name2734 }, { "colIndex": 1, "sortable": true, "header": "Bezeichnung (fr)", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "name_fr", "editor": name_fr2735 }, { "colIndex": 2, "sortable": true, "header": "Bezeichnung (nl)", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "name_nl", "editor": name_nl2736 }, new Lino.NullNumberColumn({ "colIndex": 3, "sortable": true, "format": "0", "editable": true, "filter": { "type": "numeric" }, "header": "ID", "renderer": Lino.id_renderer, "editor": id2737, "width": Lino.chars2width(6), "dataIndex": "id" }), { "colIndex": 4, "sortable": false, "header": "Bemerkung", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(61), "renderer": Lino.text_renderer, "editor": remark2738, "dataIndex": "remark" }, { "colIndex": 5, "sortable": false, "header": "body", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(61), "renderer": Lino.text_renderer, "editor": body2739, "dataIndex": "body" } ];
    Lino.notes.EventTypes.GridPanel.superclass.initComponent.call(this);
  }
});


Lino.notes.EventTypes.insertPanel = Ext.extend(Lino.notes.EventTypes.DetailFormPanel,{
  empty_title: "Neu Ereignisarten",
  hide_navigator: true,
  ls_bbar_actions: [ { "itemId": "post", "menu_item_text": "Erstellen", "tooltip": "Datensatz erstellen und dann im Detail-Fenster \u00f6ffnen", "panel_btn_handler": function(panel){panel.save(null,true,'post')}, "text": "Erstellen", "overflowText": "Erstellen", "auto_save": false }, { "itemId": "poststay", "menu_item_text": "Erstellen ohne Detail", "tooltip": "Nach Erstellen des Datensatzes kein Detail-Fenster \u00f6ffnen", "panel_btn_handler": function(panel){panel.save(null,false,'poststay')}, "text": "Erstellen ohne Detail", "overflowText": "Erstellen ohne Detail", "auto_save": false } ],
  ls_url: "/notes/EventTypes",
  action_name: "insert",
  initComponent : function() {
    this.ls_detail_handler = Lino.notes.EventTypes.detail;
    this.ls_insert_handler = Lino.notes.EventTypes.insert;
    Lino.notes.EventTypes.insertPanel.superclass.initComponent.call(this);
  }
});

Lino.notes.EventTypes.insert = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.notes.EventTypes.insertPanel(p);
});

Lino.notes.EventTypes.detailPanel = Ext.extend(Lino.notes.EventTypes.DetailFormPanel,{
  empty_title: "Detail Ereignisarten",
  ls_bbar_actions: [ { "itemId": "put", "menu_item_text": "Speichern", "tooltip": "\u00c4nderungen in diesem Formular speichern", "panel_btn_handler": function(panel){panel.save(null,false,'put')}, "iconCls": "x-tbar-save", "overflowText": "Speichern", "auto_save": false }, { "itemId": "insert", "menu_item_text": "Neu", "must_save": true, "tooltip": "Neuen Datensatz erstellen", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-new", "overflowText": "Neu", "auto_save": true }, { "itemId": null, "menu_item_text": "L\u00f6schen", "tooltip": "Diesen Datensatz l\u00f6schen", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "L\u00f6schen", "auto_save": false } ],
  ls_url: "/notes/EventTypes",
  action_name: "detail",
  initComponent : function() {
    this.ls_detail_handler = Lino.notes.EventTypes.detail;
    this.ls_insert_handler = Lino.notes.EventTypes.insert;
    Lino.notes.EventTypes.detailPanel.superclass.initComponent.call(this);
  }
});

Lino.notes.EventTypes.detail = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.notes.EventTypes.detailPanel(p);
});
Lino.notes.EventTypes.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.notes.EventTypes.GridPanel(p);
});

// js_render_GridPanel_class notes.Notes
Lino.notes.Notes.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "Keine Daten anzuzeigen." },
  ls_url : "/notes/Notes",
  ls_bbar_actions : [ { "itemId": "insert", "menu_item_text": "Neu", "must_save": true, "tooltip": "Neuen Datensatz erstellen", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-new", "overflowText": "Neu", "auto_save": true }, { "itemId": "duplicate", "menu_item_text": "Duplizieren", "must_save": true, "tooltip": "Duplizieren", "panel_btn_handler": Lino.row_action_handler('duplicate','GET'), "iconCls": "x-tbar-duplicate", "overflowText": "Duplizieren", "auto_save": true }, { "itemId": "detail", "menu_item_text": "Detail", "tooltip": "Detail-Fenster auf diesem Datensatz \u00f6ffnen", "panel_btn_handler": Lino.show_detail, "iconCls": "x-tbar-detail", "overflowText": "Detail", "auto_save": true }, { "itemId": null, "menu_item_text": "L\u00f6schen", "tooltip": "Diesen Datensatz l\u00f6schen", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "L\u00f6schen", "auto_save": false }, { "itemId": "do_print", "menu_item_text": "Drucken", "must_save": true, "tooltip": "Drucken", "panel_btn_handler": Lino.row_action_handler('do_print','GET'), "iconCls": "x-tbar-print", "overflowText": "Drucken", "auto_save": true }, { "itemId": "do_clear_cache", "menu_item_text": "Cache l\u00f6schen", "must_save": true, "tooltip": "Cache l\u00f6schen", "panel_btn_handler": Lino.row_action_handler('do_clear_cache','GET'), "iconCls": "x-tbar-clearcache", "overflowText": "Cache l\u00f6schen", "auto_save": true }, { "itemId": "create_postings", "menu_item_text": "per Post", "must_save": true, "tooltip": "Create classical mail postings from this", "panel_btn_handler": Lino.row_action_handler('create_postings','GET'), "iconCls": "x-tbar-create-postings", "overflowText": "per Post", "auto_save": true } ],
  title : "Ereignisse/Notizen",
  page_length : 20,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "type": "int", "name": "id" }, { "type": "date", "name": "date", "dateFormat": "d.m.Y" }, { "name": "user" }, 'userHidden', { "name": "event_type" }, 'event_typeHidden', { "name": "type" }, 'typeHidden', { "name": "project" }, 'projectHidden', { "name": "subject" }, { "name": "owner_type" }, 'owner_typeHidden', { "name": "owner_id" }, 'owner_idHidden', { "name": "build_time" }, { "name": "language" }, 'languageHidden', { "name": "company" }, 'companyHidden', { "name": "owner" }, { "name": "body" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 0,
  ls_grid_configs : [  ],
  content_type : 91,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 23,
  initComponent : function() {
    this.ls_detail_handler = Lino.notes.Notes.detail;
    this.ls_insert_handler = Lino.notes.Notes.insert;
    var ww = this.containing_window;
    var id2741 = new Ext.form.NumberField({ "selectOnFocus": true });
    var date2742 = new Lino.DateField({ "selectOnFocus": true, "allowBlank": false });
    var user2743 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/notes/Notes/user", "method": "GET" }) }), "pageSize": 20, "emptyText": "Benutzer ausw\u00e4hlen..." });
    var event_type2744 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/notes/Notes/event_type", "method": "GET" }) }), "pageSize": 20, "emptyText": "Event Type ausw\u00e4hlen..." });
    var type2745 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/notes/Notes/type", "method": "GET" }) }), "pageSize": 20, "emptyText": "Notizart ausw\u00e4hlen..." });
    var project2746 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/notes/Notes/project", "method": "GET" }) }), "pageSize": 20, "emptyText": "Klient ausw\u00e4hlen..." });
    var subject2747 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var owner_type2748 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/notes/Notes/owner_type", "method": "GET" }) }), "pageSize": 20, "emptyText": "Inhaltstyp ausw\u00e4hlen..." });
    var owner_id2749 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/notes/Notes/owner_id", "method": "GET" }) }) });
    var build_time2750 = new Ext.form.DisplayField({ "disabled": true, "value": "<br>" });
    var language2751 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "store": [ [ "de", "Deutsch" ], [ "fr", "Franz\u00f6sisch" ], [ "nl", "Niederl\u00e4ndisch" ] ], "allowBlank": false, "value": "de" });
    var company2752 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/notes/Notes/company", "method": "GET" }) }), "pageSize": 20, "emptyText": "Organisation ausw\u00e4hlen..." });
    var owner_disp2753 = new Ext.form.DisplayField({ "disabled": true });
    var body2754 = new Lino.RichTextPanel({ "selectOnFocus": true, "containing_panel": this, "title": "Inhalt" });
    this.before_row_edit = function(record) {
      owner_id2749.setContextValue('owner_type',record ? record.data['owner_typeHidden'] : undefined);
      body2754.refresh();
    };
    this.onRender = function(ct, position) {
      owner_type2748.on('change',Lino.chooser_handler(owner_id2749,'owner_type'));
      Lino.notes.Notes.GridPanel.superclass.onRender.call(this, ct, position);
    }
    this.ls_columns = [ new Lino.NullNumberColumn({ "colIndex": 0, "sortable": true, "format": "0", "editable": true, "filter": { "type": "numeric" }, "header": "ID", "renderer": Lino.id_renderer, "editor": id2741, "width": Lino.chars2width(6), "dataIndex": "id" }), { "colIndex": 1, "sortable": true, "xtype": "datecolumn", "format": "d.m.Y", "editable": true, "filter": { "type": "date", "dateFormat": "d.m.Y" }, "header": "Datum", "editor": date2742, "width": Lino.chars2width(9), "dataIndex": "date" }, { "colIndex": 2, "sortable": true, "header": "Autor", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(16), "dataIndex": "user", "editor": user2743 }, { "colIndex": 3, "sortable": true, "header": "Ereignisart (Form)", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('event_typeHidden','Lino.notes.EventTypes.detail'), "editor": event_type2744, "dataIndex": "event_type" }, { "colIndex": 4, "sortable": true, "header": "Notizart (Inhalt)", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('typeHidden','Lino.notes.NoteTypes.detail'), "editor": type2745, "dataIndex": "type" }, { "colIndex": 5, "sortable": true, "header": "Klient", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('projectHidden','Lino.pcsw.Clients.detail'), "editor": project2746, "dataIndex": "project" }, { "colIndex": 6, "sortable": true, "header": "Betreff", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "subject", "editor": subject2747 }, { "colIndex": 7, "sortable": true, "header": "Verkn\u00fcpft mit (Modell)", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('owner_typeHidden','Lino.ui.ContentTypes.detail'), "editor": owner_type2748, "dataIndex": "owner_type" }, { "colIndex": 8, "sortable": true, "header": "Verkn\u00fcpft mit (Objekt)", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(11), "dataIndex": "owner_id", "editor": owner_id2749 }, { "width": Lino.chars2width(17), "colIndex": 9, "sortable": true, "dataIndex": "build_time", "header": "Druckdatum", "editable": false }, { "colIndex": 10, "sortable": true, "header": "Sprache", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "language", "editor": language2751 }, { "colIndex": 11, "sortable": true, "header": "Organisation", "editable": true, "tooltip": "    An optional third-party Organization that is related to this Note.\n    The note will then be visible in that company's history panel.\n    ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('companyHidden','Lino.contacts.Companies.detail'), "editor": company2752, "dataIndex": "company" }, { "width": Lino.chars2width(11), "colIndex": 12, "sortable": false, "dataIndex": "owner", "header": "Verkn\u00fcpft mit", "editable": false }, { "colIndex": 13, "sortable": false, "header": "body", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(61), "renderer": Lino.text_renderer, "editor": body2754, "dataIndex": "body" } ];
    Lino.notes.Notes.GridPanel.superclass.initComponent.call(this);
  }
});


Lino.notes.Notes.insertPanel = Ext.extend(Lino.notes.Notes.InsertFormPanel,{
  empty_title: "Neu Ereignisse/Notizen",
  hide_navigator: true,
  ls_bbar_actions: [ { "itemId": "post", "menu_item_text": "Erstellen", "tooltip": "Datensatz erstellen und dann im Detail-Fenster \u00f6ffnen", "panel_btn_handler": function(panel){panel.save(null,true,'post')}, "text": "Erstellen", "overflowText": "Erstellen", "auto_save": false }, { "itemId": "poststay", "menu_item_text": "Erstellen ohne Detail", "tooltip": "Nach Erstellen des Datensatzes kein Detail-Fenster \u00f6ffnen", "panel_btn_handler": function(panel){panel.save(null,false,'poststay')}, "text": "Erstellen ohne Detail", "overflowText": "Erstellen ohne Detail", "auto_save": false } ],
  ls_url: "/notes/Notes",
  action_name: "insert",
  initComponent : function() {
    this.ls_detail_handler = Lino.notes.Notes.detail;
    this.ls_insert_handler = Lino.notes.Notes.insert;
    Lino.notes.Notes.insertPanel.superclass.initComponent.call(this);
  }
});

Lino.notes.Notes.insert = new Lino.WindowAction({ "draggable": true, "width": Lino.chars2width(50), "autoHeight": true, "maximizable": true, "modal": true, "maximized": false },function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.notes.Notes.insertPanel(p);
});

Lino.notes.Notes.detailPanel = Ext.extend(Lino.notes.Notes.DetailFormPanel,{
  empty_title: "Detail Ereignisse/Notizen",
  ls_bbar_actions: [ { "itemId": "put", "menu_item_text": "Speichern", "tooltip": "\u00c4nderungen in diesem Formular speichern", "panel_btn_handler": function(panel){panel.save(null,false,'put')}, "iconCls": "x-tbar-save", "overflowText": "Speichern", "auto_save": false }, { "itemId": "insert", "menu_item_text": "Neu", "must_save": true, "tooltip": "Neuen Datensatz erstellen", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-new", "overflowText": "Neu", "auto_save": true }, { "itemId": "duplicate", "menu_item_text": "Duplizieren", "must_save": true, "tooltip": "Duplizieren", "panel_btn_handler": Lino.row_action_handler('duplicate','GET'), "iconCls": "x-tbar-duplicate", "overflowText": "Duplizieren", "auto_save": true }, { "itemId": null, "menu_item_text": "L\u00f6schen", "tooltip": "Diesen Datensatz l\u00f6schen", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "L\u00f6schen", "auto_save": false }, { "itemId": "do_print", "menu_item_text": "Drucken", "must_save": true, "tooltip": "Drucken", "panel_btn_handler": Lino.row_action_handler('do_print','GET'), "iconCls": "x-tbar-print", "overflowText": "Drucken", "auto_save": true }, { "itemId": "do_clear_cache", "menu_item_text": "Cache l\u00f6schen", "must_save": true, "tooltip": "Cache l\u00f6schen", "panel_btn_handler": Lino.row_action_handler('do_clear_cache','GET'), "iconCls": "x-tbar-clearcache", "overflowText": "Cache l\u00f6schen", "auto_save": true }, { "itemId": "create_postings", "menu_item_text": "per Post", "must_save": true, "tooltip": "Create classical mail postings from this", "panel_btn_handler": Lino.row_action_handler('create_postings','GET'), "iconCls": "x-tbar-create-postings", "overflowText": "per Post", "auto_save": true } ],
  ls_url: "/notes/Notes",
  action_name: "detail",
  initComponent : function() {
    this.ls_detail_handler = Lino.notes.Notes.detail;
    this.ls_insert_handler = Lino.notes.Notes.insert;
    Lino.notes.Notes.detailPanel.superclass.initComponent.call(this);
  }
});

Lino.notes.Notes.detail = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.notes.Notes.detailPanel(p);
});
Lino.notes.Notes.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.notes.Notes.GridPanel(p);
});

// js_render_GridPanel_class contacts.Persons
Lino.contacts.Persons.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "Keine Daten anzuzeigen." },
  ls_url : "/contacts/Persons",
  ls_bbar_actions : [ { "itemId": "insert", "menu_item_text": "Neu", "must_save": true, "tooltip": "Neuen Datensatz erstellen", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-new", "overflowText": "Neu", "auto_save": true }, { "itemId": "detail", "menu_item_text": "Detail", "tooltip": "Detail-Fenster auf diesem Datensatz \u00f6ffnen", "panel_btn_handler": Lino.show_detail, "iconCls": "x-tbar-detail", "overflowText": "Detail", "auto_save": true }, { "itemId": null, "menu_item_text": "L\u00f6schen", "tooltip": "Diesen Datensatz l\u00f6schen", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "L\u00f6schen", "auto_save": false } ],
  title : "Personen",
  page_length : 20,
  params_panel_hidden : true,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "name": "name_column" }, { "name": "address_column" }, { "name": "email" }, { "name": "phone" }, { "name": "gsm" }, { "type": "int", "name": "id" }, { "name": "language" }, 'languageHidden', { "name": "created" }, { "name": "modified" }, { "name": "country" }, 'countryHidden', { "name": "city" }, 'cityHidden', { "name": "region" }, 'regionHidden', { "name": "zip_code" }, { "name": "name" }, { "name": "addr1" }, { "name": "street_prefix" }, { "name": "street" }, { "name": "street_no" }, { "name": "street_box" }, { "name": "addr2" }, { "name": "url" }, { "name": "fax" }, { "name": "remarks" }, { "type": "boolean", "name": "is_obsolete" }, { "name": "activity" }, 'activityHidden', { "name": "bank_account1" }, { "name": "bank_account2" }, { "name": "first_name" }, { "name": "last_name" }, { "name": "gender" }, 'genderHidden', { "name": "birth_date" }, { "name": "title" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 5,
  ls_grid_configs : [  ],
  content_type : 21,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 39,
  initComponent : function() {
    this.ls_detail_handler = Lino.contacts.Persons.detail;
    this.ls_insert_handler = Lino.contacts.Persons.insert;
    var ww = this.containing_window;
    var name_column_disp2756 = new Ext.form.DisplayField({ "disabled": true, "value": "<br/>", "always_enabled": true });
    var address_column_disp2757 = new Ext.form.DisplayField({ "disabled": true, "value": "<br/>", "always_enabled": true });
    var email2758 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 75 });
    var phone2759 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var gsm2760 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var id2761 = new Ext.form.NumberField({ "selectOnFocus": true });
    var language2762 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "store": [ [ "de", "Deutsch" ], [ "fr", "Franz\u00f6sisch" ], [ "nl", "Niederl\u00e4ndisch" ] ], "allowBlank": false, "value": "de" });
    var created2763 = new Ext.form.DisplayField({ "disabled": true, "value": "<br>" });
    var modified2764 = new Ext.form.DisplayField({ "disabled": true, "value": "<br>" });
    var country2765 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/contacts/Persons/country", "method": "GET" }) }), "pageSize": 20, "emptyText": "Land ausw\u00e4hlen..." });
    var city2766 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "forceSelection": false, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/contacts/Persons/city", "method": "GET" }) }), "pageSize": 20, "emptyText": "Ort ausw\u00e4hlen..." });
    var region2767 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/contacts/Persons/region", "method": "GET" }) }), "pageSize": 20, "emptyText": "Ort ausw\u00e4hlen..." });
    var zip_code2768 = new Ext.form.TextField({ "selectOnFocus": true, "boxMinWidth": Lino.chars2width(10), "maxLength": 10 });
    var name2769 = new Ext.form.TextField({ "selectOnFocus": true, "allowBlank": false, "maxLength": 200 });
    var addr12770 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var street_prefix2771 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var street2772 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var street_no2773 = new Ext.form.TextField({ "selectOnFocus": true, "boxMinWidth": Lino.chars2width(10), "maxLength": 10 });
    var street_box2774 = new Ext.form.TextField({ "selectOnFocus": true, "boxMinWidth": Lino.chars2width(10), "maxLength": 10 });
    var addr22775 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var url2776 = new Lino.URLField({ "selectOnFocus": true, "maxLength": 200 });
    var fax2777 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var remarks2778 = new Ext.form.TextArea({ "selectOnFocus": true, "growMax": 2000 });
    var is_obsolete2779 = new Ext.form.Checkbox({ "selectOnFocus": true, "checked": false });
    var activity2780 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/contacts/Persons/activity", "method": "GET" }) }), "pageSize": 20, "emptyText": "Beruf ausw\u00e4hlen..." });
    var bank_account12781 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 40 });
    var bank_account22782 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 40 });
    var first_name2783 = new Ext.form.TextField({ "selectOnFocus": true, "allowBlank": false, "maxLength": 200 });
    var last_name2784 = new Ext.form.TextField({ "selectOnFocus": true, "allowBlank": false, "maxLength": 200 });
    var gender2785 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "forceSelection": true, "store": Lino.lino.Genders });
    var birth_date2786 = new Lino.IncompleteDateField({ "selectOnFocus": true });
    var title2787 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    this.before_row_edit = function(record) {
      city2766.setContextValue('country',record ? record.data['countryHidden'] : undefined);
      city2766.setContextValue('region',record ? record.data['regionHidden'] : undefined);
      region2767.setContextValue('country',record ? record.data['countryHidden'] : undefined);
    };
    this.onRender = function(ct, position) {
      country2765.on('change',Lino.chooser_handler(city2766,'country'));
      region2767.on('change',Lino.chooser_handler(city2766,'region'));
      country2765.on('change',Lino.chooser_handler(region2767,'country'));
      Lino.contacts.Persons.GridPanel.superclass.onRender.call(this, ct, position);
    }
    this.ls_columns = [ { "width": Lino.chars2width(21), "colIndex": 0, "sortable": false, "dataIndex": "name_column", "header": "Name", "editable": false }, { "width": Lino.chars2width(31), "colIndex": 1, "sortable": false, "dataIndex": "address_column", "header": "Adresse", "editable": false }, { "colIndex": 2, "sortable": true, "header": "E-Mail", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "email", "editor": email2758 }, { "colIndex": 3, "sortable": true, "header": "Telefon", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(11), "dataIndex": "phone", "editor": phone2759 }, { "colIndex": 4, "sortable": true, "header": "GSM", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(11), "dataIndex": "gsm", "editor": gsm2760 }, new Lino.NullNumberColumn({ "colIndex": 5, "sortable": true, "format": "0", "editable": true, "filter": { "type": "numeric" }, "header": "ID", "renderer": Lino.id_renderer, "editor": id2761, "width": Lino.chars2width(6), "dataIndex": "id" }), { "colIndex": 6, "sortable": true, "header": "Sprache", "editable": true, "tooltip": "Die Sprache, in der Dokumente ausgestellt werden sollen.", "filter": { "type": "string" }, "width": Lino.chars2width(11), "dataIndex": "language", "editor": language2762 }, { "width": Lino.chars2width(17), "colIndex": 7, "sortable": true, "dataIndex": "created", "header": "Erstellt", "hidden": true, "editable": false }, { "width": Lino.chars2width(17), "colIndex": 8, "sortable": true, "dataIndex": "modified", "header": "Bearbeitet", "hidden": true, "editable": false }, { "colIndex": 9, "sortable": true, "header": "Land", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('countryHidden','Lino.countries.Countries.detail'), "editor": country2765, "dataIndex": "country" }, { "colIndex": 10, "sortable": true, "header": "Ort", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "city", "editor": city2766 }, { "colIndex": 11, "sortable": true, "header": "Region", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "region", "editor": region2767 }, { "colIndex": 12, "sortable": true, "header": "Postleitzahl", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(12), "dataIndex": "zip_code", "editor": zip_code2768 }, { "colIndex": 13, "sortable": true, "header": "Name", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "name", "editor": name2769 }, { "colIndex": 14, "sortable": true, "header": "Adresszeile vor Stra\u00dfe", "editable": true, "tooltip": "Address line before street", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "addr1", "editor": addr12770 }, { "colIndex": 15, "sortable": true, "header": "Pr\u00e4fix Stra\u00dfe", "editable": true, "tooltip": "Text to print before name of street, but to ignore for sorting.", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "street_prefix", "editor": street_prefix2771 }, { "colIndex": 16, "sortable": true, "header": "Stra\u00dfe", "editable": true, "tooltip": "Name of street. Without house number.", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "street", "editor": street2772 }, { "colIndex": 17, "sortable": true, "header": "Nr.", "editable": true, "tooltip": "House number", "filter": { "type": "string" }, "width": Lino.chars2width(12), "dataIndex": "street_no", "editor": street_no2773 }, { "colIndex": 18, "sortable": true, "header": "Box", "editable": true, "tooltip": "Text to print after :attr:`steet_no` on the same line", "filter": { "type": "string" }, "width": Lino.chars2width(12), "dataIndex": "street_box", "editor": street_box2774 }, { "colIndex": 19, "sortable": true, "header": "Adresszeile nach Stra\u00dfe", "editable": true, "tooltip": "Address line to print below street line", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "addr2", "editor": addr22775 }, { "colIndex": 20, "sortable": true, "header": "URL", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "url", "editor": url2776 }, { "colIndex": 21, "sortable": true, "header": "Fax", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "fax", "editor": fax2777 }, { "colIndex": 22, "sortable": false, "header": "Bemerkungen", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(61), "renderer": Lino.text_renderer, "editor": remarks2778, "dataIndex": "remarks" }, { "colIndex": 23, "sortable": false, "xtype": "checkcolumn", "header": "veraltet", "editable": true, "tooltip": "Altf\u00e4lle sind Partner, deren Stammdaten nicht mehr gepflegt werden und \nf\u00fcr neue Operationen nicht benutzt werden k\u00f6nnen.", "filter": { "type": "boolean" }, "width": Lino.chars2width(11), "dataIndex": "is_obsolete" }, { "colIndex": 24, "sortable": true, "header": "Beruf", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "activity", "hidden": true, "editor": activity2780 }, { "colIndex": 25, "sortable": true, "header": "Bankkonto 1", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "bank_account1", "hidden": true, "editor": bank_account12781 }, { "colIndex": 26, "sortable": true, "header": "Bankkonto 2", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "bank_account2", "hidden": true, "editor": bank_account22782 }, { "colIndex": 27, "sortable": true, "header": "Vorname", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "first_name", "editor": first_name2783 }, { "colIndex": 28, "sortable": true, "header": "Familienname", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "last_name", "editor": last_name2784 }, { "colIndex": 29, "sortable": true, "header": "Geschlecht", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(12), "dataIndex": "gender", "editor": gender2785 }, { "colIndex": 30, "sortable": true, "header": "Geburtsdatum", "editable": true, "tooltip": "Unkomplette Datumsangaben sind erlaubt, z.B. \"00.00.1980\" hei\u00dft \"irgendwann im Jahr 1980\", \"00.07.1980\" hei\u00dft \"im Juli 1980\"oder \"23.07.0000\" hei\u00dft \"an einem 23. Juli\".", "filter": { "type": "string" }, "width": Lino.chars2width(13), "dataIndex": "birth_date", "editor": birth_date2786 }, { "colIndex": 31, "sortable": true, "header": "Anrede", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "title", "editor": title2787 } ];
    Lino.contacts.Persons.GridPanel.superclass.initComponent.call(this);
  }
});


Lino.contacts.Persons.insertPanel = Ext.extend(Lino.contacts.Persons.InsertFormPanel,{
  empty_title: "Neu Personen",
  hide_navigator: true,
  params_panel_hidden: true,
  ls_bbar_actions: [ { "itemId": "post", "menu_item_text": "Erstellen", "tooltip": "Datensatz erstellen und dann im Detail-Fenster \u00f6ffnen", "panel_btn_handler": function(panel){panel.save(null,true,'post')}, "text": "Erstellen", "overflowText": "Erstellen", "auto_save": false }, { "itemId": "poststay", "menu_item_text": "Erstellen ohne Detail", "tooltip": "Nach Erstellen des Datensatzes kein Detail-Fenster \u00f6ffnen", "panel_btn_handler": function(panel){panel.save(null,false,'poststay')}, "text": "Erstellen ohne Detail", "overflowText": "Erstellen ohne Detail", "auto_save": false } ],
  ls_url: "/contacts/Persons",
  action_name: "insert",
  initComponent : function() {
    this.ls_detail_handler = Lino.contacts.Persons.detail;
    this.ls_insert_handler = Lino.contacts.Persons.insert;
    Lino.contacts.Persons.insertPanel.superclass.initComponent.call(this);
  }
});

Lino.contacts.Persons.insert = new Lino.WindowAction({ "draggable": true, "width": Lino.chars2width(60), "autoHeight": true, "maximizable": true, "modal": true, "maximized": false },function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.contacts.Persons.insertPanel(p);
});

Lino.contacts.Persons.detailPanel = Ext.extend(Lino.contacts.Persons.DetailFormPanel,{
  empty_title: "Detail Personen",
  params_panel_hidden: true,
  ls_bbar_actions: [ { "itemId": "put", "menu_item_text": "Speichern", "tooltip": "\u00c4nderungen in diesem Formular speichern", "panel_btn_handler": function(panel){panel.save(null,false,'put')}, "iconCls": "x-tbar-save", "overflowText": "Speichern", "auto_save": false }, { "itemId": "insert", "menu_item_text": "Neu", "must_save": true, "tooltip": "Neuen Datensatz erstellen", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-new", "overflowText": "Neu", "auto_save": true }, { "itemId": null, "menu_item_text": "L\u00f6schen", "tooltip": "Diesen Datensatz l\u00f6schen", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "L\u00f6schen", "auto_save": false } ],
  ls_url: "/contacts/Persons",
  action_name: "detail",
  initComponent : function() {
    this.ls_detail_handler = Lino.contacts.Persons.detail;
    this.ls_insert_handler = Lino.contacts.Persons.insert;
    Lino.contacts.Persons.detailPanel.superclass.initComponent.call(this);
  }
});

Lino.contacts.Persons.detail = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.contacts.Persons.detailPanel(p);
});
Lino.contacts.Persons.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  p.params_panel = new Lino.contacts.Persons.ParamsPanel({});
  return new Lino.contacts.Persons.GridPanel(p);
});

// js_render_GridPanel_class pcsw.Clients
Lino.pcsw.Clients.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "Keine Daten anzuzeigen." },
  ls_url : "/pcsw/Clients",
  ls_bbar_actions : [ { "itemId": "insert", "menu_item_text": "Neu", "must_save": true, "tooltip": "Neuen Datensatz erstellen", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-new", "overflowText": "Neu", "auto_save": true }, { "itemId": "detail", "menu_item_text": "Detail", "tooltip": "Detail-Fenster auf diesem Datensatz \u00f6ffnen", "panel_btn_handler": Lino.show_detail, "iconCls": "x-tbar-detail", "overflowText": "Detail", "auto_save": true }, { "itemId": null, "menu_item_text": "L\u00f6schen", "tooltip": "Diesen Datensatz l\u00f6schen", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "L\u00f6schen", "auto_save": false }, { "itemId": "print_eid_content", "menu_item_text": "eID-Inhalt", "must_save": true, "tooltip": "eID-Inhalt", "panel_btn_handler": Lino.row_action_handler('print_eid_content','GET'), "iconCls": "x-tbar-vcard", "overflowText": "eID-Inhalt", "auto_save": true } ],
  title : "Klienten",
  page_length : 20,
  params_panel_hidden : true,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "name": "name_column" }, { "name": "client_state" }, 'client_stateHidden', { "name": "national_id" }, { "name": "gsm" }, { "name": "address_column" }, { "name": "age" }, { "name": "email" }, { "name": "phone" }, { "type": "int", "name": "id" }, { "name": "bank_account1" }, { "name": "aid_type" }, 'aid_typeHidden', { "name": "language" }, 'languageHidden', { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 9,
  ls_grid_configs : [  ],
  content_type : 50,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 16,
  initComponent : function() {
    this.ls_detail_handler = Lino.pcsw.Clients.detail;
    this.ls_insert_handler = Lino.pcsw.Clients.insert;
    var ww = this.containing_window;
    var name_column_disp2789 = new Ext.form.DisplayField({ "disabled": true, "value": "<br/>", "always_enabled": true });
    var client_state2790 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "forceSelection": true, "allowBlank": false, "store": Lino.pcsw.ClientStates });
    var national_id2791 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var gsm2792 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var address_column_disp2793 = new Ext.form.DisplayField({ "disabled": true, "value": "<br/>", "always_enabled": true });
    var age_disp2794 = new Ext.form.DisplayField({ "disabled": true, "value": "<br/>", "always_enabled": true });
    var email2795 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 75 });
    var phone2796 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var id2797 = new Ext.form.NumberField({ "selectOnFocus": true });
    var bank_account12798 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 40 });
    var aid_type2799 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/pcsw/Clients/aid_type", "method": "GET" }) }), "pageSize": 20, "emptyText": "Sozialhilfeart ausw\u00e4hlen..." });
    var language2800 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "store": [ [ "de", "Deutsch" ], [ "fr", "Franz\u00f6sisch" ], [ "nl", "Niederl\u00e4ndisch" ] ], "allowBlank": false, "value": "de" });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ { "width": Lino.chars2width(21), "colIndex": 0, "sortable": false, "dataIndex": "name_column", "header": "Name", "editable": false }, { "colIndex": 1, "sortable": true, "header": "Zustand", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(13), "dataIndex": "client_state", "editor": client_state2790 }, { "colIndex": 2, "sortable": true, "header": "NR-Nummer", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(11), "dataIndex": "national_id", "editor": national_id2791 }, { "colIndex": 3, "sortable": true, "header": "GSM", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(11), "dataIndex": "gsm", "editor": gsm2792 }, { "width": Lino.chars2width(31), "colIndex": 4, "sortable": false, "dataIndex": "address_column", "header": "Adresse", "editable": false }, { "width": Lino.chars2width(11), "colIndex": 5, "sortable": false, "dataIndex": "age", "header": "Alter", "editable": false }, { "colIndex": 6, "sortable": true, "header": "E-Mail", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "email", "editor": email2795 }, { "colIndex": 7, "sortable": true, "header": "Telefon", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(11), "dataIndex": "phone", "editor": phone2796 }, new Lino.NullNumberColumn({ "colIndex": 8, "sortable": true, "format": "0", "editable": true, "filter": { "type": "numeric" }, "header": "ID", "renderer": Lino.id_renderer, "editor": id2797, "width": Lino.chars2width(6), "dataIndex": "id" }), { "colIndex": 9, "sortable": true, "header": "Bankkonto 1", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "bank_account1", "hidden": true, "editor": bank_account12798 }, { "colIndex": 10, "sortable": true, "header": "Sozialhilfeart", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "aid_type", "editor": aid_type2799 }, { "colIndex": 11, "sortable": true, "header": "Sprache", "editable": true, "tooltip": "Die Sprache, in der Dokumente ausgestellt werden sollen.", "filter": { "type": "string" }, "width": Lino.chars2width(11), "dataIndex": "language", "editor": language2800 } ];
    Lino.pcsw.Clients.GridPanel.superclass.initComponent.call(this);
  }
});


Lino.pcsw.Clients.insertPanel = Ext.extend(Lino.pcsw.Clients.InsertFormPanel,{
  empty_title: "Neu Klienten",
  hide_navigator: true,
  params_panel_hidden: true,
  ls_bbar_actions: [ { "itemId": "post", "menu_item_text": "Erstellen", "tooltip": "Datensatz erstellen und dann im Detail-Fenster \u00f6ffnen", "panel_btn_handler": function(panel){panel.save(null,true,'post')}, "text": "Erstellen", "overflowText": "Erstellen", "auto_save": false }, { "itemId": "poststay", "menu_item_text": "Erstellen ohne Detail", "tooltip": "Nach Erstellen des Datensatzes kein Detail-Fenster \u00f6ffnen", "panel_btn_handler": function(panel){panel.save(null,false,'poststay')}, "text": "Erstellen ohne Detail", "overflowText": "Erstellen ohne Detail", "auto_save": false } ],
  ls_url: "/pcsw/Clients",
  action_name: "insert",
  initComponent : function() {
    this.ls_detail_handler = Lino.pcsw.Clients.detail;
    this.ls_insert_handler = Lino.pcsw.Clients.insert;
    Lino.pcsw.Clients.insertPanel.superclass.initComponent.call(this);
  }
});

Lino.pcsw.Clients.insert = new Lino.WindowAction({ "draggable": true, "width": Lino.chars2width(60), "autoHeight": true, "maximizable": true, "modal": true, "maximized": false },function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.pcsw.Clients.insertPanel(p);
});
Lino.pcsw.Clients.wf1 = function(rp,pk) { 
  Lino.run_row_action(rp,"/pcsw/Clients",pk,"wf1");
};
Lino.pcsw.Clients.wf3 = function(rp,pk) { 
  Lino.run_row_action(rp,"/pcsw/Clients",pk,"wf3");
};

Lino.pcsw.Clients.detailPanel = Ext.extend(Lino.pcsw.Clients.DetailFormPanel,{
  empty_title: "Detail Klienten",
  params_panel_hidden: true,
  ls_bbar_actions: [ { "itemId": "put", "menu_item_text": "Speichern", "tooltip": "\u00c4nderungen in diesem Formular speichern", "panel_btn_handler": function(panel){panel.save(null,false,'put')}, "iconCls": "x-tbar-save", "overflowText": "Speichern", "auto_save": false }, { "itemId": "insert", "menu_item_text": "Neu", "must_save": true, "tooltip": "Neuen Datensatz erstellen", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-new", "overflowText": "Neu", "auto_save": true }, { "itemId": null, "menu_item_text": "L\u00f6schen", "tooltip": "Diesen Datensatz l\u00f6schen", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "L\u00f6schen", "auto_save": false }, { "itemId": "print_eid_content", "menu_item_text": "eID-Inhalt", "must_save": true, "tooltip": "eID-Inhalt", "panel_btn_handler": Lino.row_action_handler('print_eid_content','GET'), "iconCls": "x-tbar-vcard", "overflowText": "eID-Inhalt", "auto_save": true } ],
  ls_url: "/pcsw/Clients",
  action_name: "detail",
  initComponent : function() {
    this.ls_detail_handler = Lino.pcsw.Clients.detail;
    this.ls_insert_handler = Lino.pcsw.Clients.insert;
    Lino.pcsw.Clients.detailPanel.superclass.initComponent.call(this);
  }
});

Lino.pcsw.Clients.detail = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.pcsw.Clients.detailPanel(p);
});
Lino.pcsw.Clients.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  p.params_panel = new Lino.pcsw.Clients.ParamsPanel({});
  return new Lino.pcsw.Clients.GridPanel(p);
});

// js_render_GridPanel_class pcsw.DebtsClients
Lino.pcsw.DebtsClients.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "Keine Daten anzuzeigen." },
  ls_url : "/pcsw/DebtsClients",
  ls_bbar_actions : [ { "itemId": "detail", "menu_item_text": "Detail", "tooltip": "Detail-Fenster auf diesem Datensatz \u00f6ffnen", "panel_btn_handler": Lino.show_detail, "iconCls": "x-tbar-detail", "overflowText": "Detail", "auto_save": true }, { "itemId": null, "menu_item_text": "L\u00f6schen", "tooltip": "Diesen Datensatz l\u00f6schen", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "L\u00f6schen", "auto_save": false }, { "itemId": "print_eid_content", "menu_item_text": "eID-Inhalt", "must_save": true, "tooltip": "eID-Inhalt", "panel_btn_handler": Lino.row_action_handler('print_eid_content','GET'), "iconCls": "x-tbar-vcard", "overflowText": "eID-Inhalt", "auto_save": true } ],
  title : "Klienten",
  page_length : 20,
  params_panel_hidden : true,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "name": "name_column" }, { "name": "national_id" }, { "name": "gsm" }, { "name": "address_column" }, { "name": "email" }, { "name": "phone" }, { "type": "int", "name": "id" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 6,
  ls_grid_configs : [  ],
  content_type : 50,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 8,
  initComponent : function() {
    this.ls_detail_handler = Lino.pcsw.DebtsClients.detail;
    this.ls_insert_handler = Lino.pcsw.Clients.insert;
    var ww = this.containing_window;
    var name_column_disp2802 = new Ext.form.DisplayField({ "disabled": true, "value": "<br/>", "always_enabled": true });
    var national_id2803 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var gsm2804 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var address_column_disp2805 = new Ext.form.DisplayField({ "disabled": true, "value": "<br/>", "always_enabled": true });
    var email2806 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 75 });
    var phone2807 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var id2808 = new Ext.form.NumberField({ "selectOnFocus": true });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ { "width": Lino.chars2width(21), "colIndex": 0, "sortable": false, "dataIndex": "name_column", "header": "Name", "editable": false }, { "colIndex": 1, "sortable": true, "header": "NR-Nummer", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(11), "dataIndex": "national_id", "editor": national_id2803 }, { "colIndex": 2, "sortable": true, "header": "GSM", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(11), "dataIndex": "gsm", "editor": gsm2804 }, { "width": Lino.chars2width(31), "colIndex": 3, "sortable": false, "dataIndex": "address_column", "header": "Adresse", "editable": false }, { "colIndex": 4, "sortable": true, "header": "E-Mail", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "email", "editor": email2806 }, { "colIndex": 5, "sortable": true, "header": "Telefon", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(11), "dataIndex": "phone", "editor": phone2807 }, new Lino.NullNumberColumn({ "colIndex": 6, "sortable": true, "format": "0", "editable": true, "filter": { "type": "numeric" }, "header": "ID", "renderer": Lino.id_renderer, "editor": id2808, "width": Lino.chars2width(6), "dataIndex": "id" }) ];
    Lino.pcsw.DebtsClients.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.pcsw.DebtsClients.wf1 = function(rp,pk) { 
  Lino.run_row_action(rp,"/pcsw/DebtsClients",pk,"wf1");
};
Lino.pcsw.DebtsClients.wf3 = function(rp,pk) { 
  Lino.run_row_action(rp,"/pcsw/DebtsClients",pk,"wf3");
};

Lino.pcsw.DebtsClients.detailPanel = Ext.extend(Lino.pcsw.Clients.DetailFormPanel,{
  empty_title: "Detail Klienten",
  params_panel_hidden: true,
  ls_bbar_actions: [ { "itemId": "put", "menu_item_text": "Speichern", "tooltip": "\u00c4nderungen in diesem Formular speichern", "panel_btn_handler": function(panel){panel.save(null,false,'put')}, "iconCls": "x-tbar-save", "overflowText": "Speichern", "auto_save": false }, { "itemId": null, "menu_item_text": "L\u00f6schen", "tooltip": "Diesen Datensatz l\u00f6schen", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "L\u00f6schen", "auto_save": false }, { "itemId": "print_eid_content", "menu_item_text": "eID-Inhalt", "must_save": true, "tooltip": "eID-Inhalt", "panel_btn_handler": Lino.row_action_handler('print_eid_content','GET'), "iconCls": "x-tbar-vcard", "overflowText": "eID-Inhalt", "auto_save": true } ],
  ls_url: "/pcsw/DebtsClients",
  action_name: "detail",
  initComponent : function() {
    this.ls_detail_handler = Lino.pcsw.DebtsClients.detail;
    this.ls_insert_handler = Lino.pcsw.Clients.insert;
    Lino.pcsw.DebtsClients.detailPanel.superclass.initComponent.call(this);
  }
});

Lino.pcsw.DebtsClients.detail = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.pcsw.DebtsClients.detailPanel(p);
});
Lino.pcsw.DebtsClients.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  p.params_panel = new Lino.pcsw.Clients.ParamsPanel({});
  return new Lino.pcsw.DebtsClients.GridPanel(p);
});

// js_render_GridPanel_class pcsw.ClientContactTypes
Lino.pcsw.ClientContactTypes.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "Keine Daten anzuzeigen." },
  ls_url : "/pcsw/ClientContactTypes",
  ls_bbar_actions : [ { "itemId": null, "menu_item_text": "L\u00f6schen", "tooltip": "Diesen Datensatz l\u00f6schen", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "L\u00f6schen", "auto_save": false } ],
  title : "Klientenkontaktarten",
  page_length : 20,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "type": "int", "name": "id" }, { "name": "name" }, { "name": "name_fr" }, { "name": "name_nl" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 0,
  ls_grid_configs : [  ],
  content_type : 48,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 5,
  initComponent : function() {
    var ww = this.containing_window;
    var id2810 = new Ext.form.NumberField({ "selectOnFocus": true });
    var name2811 = new Ext.form.TextField({ "selectOnFocus": true, "allowBlank": false, "maxLength": 200 });
    var name_fr2812 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var name_nl2813 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ new Lino.NullNumberColumn({ "colIndex": 0, "sortable": true, "format": "0", "editable": true, "filter": { "type": "numeric" }, "header": "ID", "renderer": Lino.id_renderer, "editor": id2810, "width": Lino.chars2width(6), "dataIndex": "id" }), { "colIndex": 1, "sortable": true, "header": "Bezeichnung", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "name", "editor": name2811 }, { "colIndex": 2, "sortable": true, "header": "Bezeichnung (fr)", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "name_fr", "editor": name_fr2812 }, { "colIndex": 3, "sortable": true, "header": "Bezeichnung (nl)", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "name_nl", "editor": name_nl2813 } ];
    Lino.pcsw.ClientContactTypes.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.pcsw.ClientContactTypes.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.pcsw.ClientContactTypes.GridPanel(p);
});

// js_render_GridPanel_class pcsw.ClientContacts
Lino.pcsw.ClientContacts.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "Keine Daten anzuzeigen." },
  ls_url : "/pcsw/ClientContacts",
  ls_bbar_actions : [ { "itemId": null, "menu_item_text": "L\u00f6schen", "tooltip": "Diesen Datensatz l\u00f6schen", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "L\u00f6schen", "auto_save": false } ],
  title : "Klientenkontakte",
  page_length : 20,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "type": "int", "name": "id" }, { "name": "company" }, 'companyHidden', { "name": "contact_person" }, 'contact_personHidden', { "name": "contact_role" }, 'contact_roleHidden', { "name": "client" }, 'clientHidden', { "name": "type" }, 'typeHidden', { "name": "remark" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 0,
  ls_grid_configs : [  ],
  content_type : 54,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 13,
  initComponent : function() {
    var ww = this.containing_window;
    var id2815 = new Ext.form.NumberField({ "selectOnFocus": true });
    var company2816 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/pcsw/ClientContacts/company", "method": "GET" }) }), "pageSize": 20, "emptyText": "Organisation ausw\u00e4hlen..." });
    var contact_person2817 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/pcsw/ClientContacts/contact_person", "method": "GET" }) }), "pageSize": 20, "emptyText": "Person ausw\u00e4hlen..." });
    var contact_role2818 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/pcsw/ClientContacts/contact_role", "method": "GET" }) }), "pageSize": 20, "emptyText": "Funktion ausw\u00e4hlen..." });
    var client2819 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/pcsw/ClientContacts/client", "method": "GET" }) }), "allowBlank": false, "pageSize": 20, "emptyText": "Klient ausw\u00e4hlen..." });
    var type2820 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/pcsw/ClientContacts/type", "method": "GET" }) }), "pageSize": 20, "emptyText": "Klientenkontaktart ausw\u00e4hlen..." });
    var remark2821 = new Ext.form.TextArea({ "selectOnFocus": true, "growMax": 2000 });
    this.before_row_edit = function(record) {
      company2816.setContextValue('type',record ? record.data['typeHidden'] : undefined);
      contact_person2817.setContextValue('company',record ? record.data['companyHidden'] : undefined);
    };
    this.onRender = function(ct, position) {
      type2820.on('change',Lino.chooser_handler(company2816,'type'));
      company2816.on('change',Lino.chooser_handler(contact_person2817,'company'));
      Lino.pcsw.ClientContacts.GridPanel.superclass.onRender.call(this, ct, position);
    }
    this.ls_columns = [ new Lino.NullNumberColumn({ "colIndex": 0, "sortable": true, "format": "0", "editable": true, "filter": { "type": "numeric" }, "header": "ID", "renderer": Lino.id_renderer, "editor": id2815, "width": Lino.chars2width(6), "dataIndex": "id" }), { "colIndex": 1, "sortable": true, "header": "Organisation", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('companyHidden','Lino.contacts.Companies.detail'), "editor": company2816, "dataIndex": "company" }, { "colIndex": 2, "sortable": true, "header": "Kontaktperson", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('contact_personHidden','Lino.contacts.Persons.detail'), "editor": contact_person2817, "dataIndex": "contact_person" }, { "colIndex": 3, "sortable": true, "header": "in seiner Eigenschaft als", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "contact_role", "editor": contact_role2818 }, { "colIndex": 4, "sortable": true, "header": "Klient", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('clientHidden','Lino.pcsw.Clients.detail'), "editor": client2819, "dataIndex": "client" }, { "colIndex": 5, "sortable": true, "header": "Klientenkontaktart", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "type", "editor": type2820 }, { "colIndex": 6, "sortable": false, "header": "Bemerkungen", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(61), "renderer": Lino.text_renderer, "editor": remark2821, "dataIndex": "remark" } ];
    Lino.pcsw.ClientContacts.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.pcsw.ClientContacts.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.pcsw.ClientContacts.GridPanel(p);
});

// js_render_GridPanel_class pcsw.Coachings
Lino.pcsw.Coachings.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "Keine Daten anzuzeigen." },
  ls_url : "/pcsw/Coachings",
  ls_bbar_actions : [ { "itemId": null, "menu_item_text": "L\u00f6schen", "tooltip": "Diesen Datensatz l\u00f6schen", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "L\u00f6schen", "auto_save": false } ],
  title : "Begleitungen",
  page_length : 20,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "type": "int", "name": "id" }, { "name": "user" }, 'userHidden', { "name": "client" }, 'clientHidden', { "type": "date", "name": "start_date", "dateFormat": "d.m.Y" }, { "type": "date", "name": "end_date", "dateFormat": "d.m.Y" }, { "name": "type" }, 'typeHidden', { "type": "boolean", "name": "primary" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 0,
  ls_grid_configs : [  ],
  content_type : 49,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 11,
  initComponent : function() {
    var ww = this.containing_window;
    var id2823 = new Ext.form.NumberField({ "selectOnFocus": true });
    var user2824 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/pcsw/Coachings/user", "method": "GET" }) }), "allowBlank": false, "pageSize": 20, "emptyText": "Benutzer ausw\u00e4hlen..." });
    var client2825 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/pcsw/Coachings/client", "method": "GET" }) }), "allowBlank": false, "pageSize": 20, "emptyText": "Klient ausw\u00e4hlen..." });
    var start_date2826 = new Lino.DateField({ "selectOnFocus": true });
    var end_date2827 = new Lino.DateField({ "selectOnFocus": true });
    var type2828 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/pcsw/Coachings/type", "method": "GET" }) }), "pageSize": 20, "emptyText": "Dienst ausw\u00e4hlen..." });
    var primary2829 = new Ext.form.Checkbox({ "selectOnFocus": true, "checked": false });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ new Lino.NullNumberColumn({ "colIndex": 0, "sortable": true, "format": "0", "editable": true, "filter": { "type": "numeric" }, "header": "ID", "renderer": Lino.id_renderer, "editor": id2823, "width": Lino.chars2width(6), "dataIndex": "id" }), { "colIndex": 1, "sortable": true, "header": "Begleiter", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(16), "dataIndex": "user", "editor": user2824 }, { "colIndex": 2, "sortable": true, "header": "Klient", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('clientHidden','Lino.pcsw.Clients.detail'), "editor": client2825, "dataIndex": "client" }, { "colIndex": 3, "sortable": true, "xtype": "datecolumn", "format": "d.m.Y", "editable": true, "filter": { "type": "date", "dateFormat": "d.m.Y" }, "header": "Begleitet seit", "editor": start_date2826, "width": Lino.chars2width(9), "dataIndex": "start_date" }, { "colIndex": 4, "sortable": true, "xtype": "datecolumn", "format": "d.m.Y", "editable": true, "filter": { "type": "date", "dateFormat": "d.m.Y" }, "header": "bis", "editor": end_date2827, "width": Lino.chars2width(9), "dataIndex": "end_date" }, { "colIndex": 5, "sortable": true, "header": "Dienst", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "type", "editor": type2828 }, { "colIndex": 6, "sortable": false, "xtype": "checkcolumn", "header": "Prim\u00e4r", "editable": true, "tooltip": "There's at most one primary coach per client. \nEnabling this field will automatically make the other coachings non-primary.", "filter": { "type": "boolean" }, "width": Lino.chars2width(11), "dataIndex": "primary" } ];
    Lino.pcsw.Coachings.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.pcsw.Coachings.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.pcsw.Coachings.GridPanel(p);
});

// js_render_GridPanel_class courses.CourseProviders
Lino.courses.CourseProviders.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "Keine Daten anzuzeigen." },
  ls_url : "/courses/CourseProviders",
  ls_bbar_actions : [ { "itemId": "insert", "menu_item_text": "Neu", "must_save": true, "tooltip": "Neuen Datensatz erstellen", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-new", "overflowText": "Neu", "auto_save": true }, { "itemId": "detail", "menu_item_text": "Detail", "tooltip": "Detail-Fenster auf diesem Datensatz \u00f6ffnen", "panel_btn_handler": Lino.show_detail, "iconCls": "x-tbar-detail", "overflowText": "Detail", "auto_save": true }, { "itemId": null, "menu_item_text": "L\u00f6schen", "tooltip": "Diesen Datensatz l\u00f6schen", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "L\u00f6schen", "auto_save": false } ],
  title : "Kursanbieter",
  page_length : 20,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "name": "name" }, { "name": "email" }, { "name": "created" }, { "name": "modified" }, { "name": "country" }, 'countryHidden', { "name": "city" }, 'cityHidden', { "name": "region" }, 'regionHidden', { "name": "zip_code" }, { "name": "addr1" }, { "name": "street_prefix" }, { "name": "street" }, { "name": "street_no" }, { "name": "street_box" }, { "name": "addr2" }, { "name": "language" }, 'languageHidden', { "name": "url" }, { "name": "phone" }, { "name": "gsm" }, { "name": "fax" }, { "name": "remarks" }, { "type": "boolean", "name": "is_obsolete" }, { "name": "activity" }, 'activityHidden', { "name": "bank_account1" }, { "name": "bank_account2" }, { "name": "prefix" }, { "name": "vat_id" }, { "name": "type" }, 'typeHidden', { "name": "client_contact_type" }, 'client_contact_typeHidden', { "type": "int", "name": "id" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 35,
  ls_grid_configs : [  ],
  content_type : 77,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 37,
  initComponent : function() {
    this.ls_detail_handler = Lino.courses.CourseProviders.detail;
    this.ls_insert_handler = Lino.courses.CourseProviders.insert;
    var ww = this.containing_window;
    var name2831 = new Ext.form.TextField({ "selectOnFocus": true, "allowBlank": false, "maxLength": 200 });
    var email2832 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 75 });
    var created2833 = new Ext.form.DisplayField({ "disabled": true, "value": "<br>" });
    var modified2834 = new Ext.form.DisplayField({ "disabled": true, "value": "<br>" });
    var country2835 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/courses/CourseProviders/country", "method": "GET" }) }), "pageSize": 20, "emptyText": "Land ausw\u00e4hlen..." });
    var city2836 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "forceSelection": false, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/courses/CourseProviders/city", "method": "GET" }) }), "pageSize": 20, "emptyText": "Ort ausw\u00e4hlen..." });
    var region2837 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/courses/CourseProviders/region", "method": "GET" }) }), "pageSize": 20, "emptyText": "Ort ausw\u00e4hlen..." });
    var zip_code2838 = new Ext.form.TextField({ "selectOnFocus": true, "boxMinWidth": Lino.chars2width(10), "maxLength": 10 });
    var addr12839 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var street_prefix2840 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var street2841 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var street_no2842 = new Ext.form.TextField({ "selectOnFocus": true, "boxMinWidth": Lino.chars2width(10), "maxLength": 10 });
    var street_box2843 = new Ext.form.TextField({ "selectOnFocus": true, "boxMinWidth": Lino.chars2width(10), "maxLength": 10 });
    var addr22844 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var language2845 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "store": [ [ "de", "Deutsch" ], [ "fr", "Franz\u00f6sisch" ], [ "nl", "Niederl\u00e4ndisch" ] ], "allowBlank": false, "value": "de" });
    var url2846 = new Lino.URLField({ "selectOnFocus": true, "maxLength": 200 });
    var phone2847 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var gsm2848 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var fax2849 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var remarks2850 = new Ext.form.TextArea({ "selectOnFocus": true, "growMax": 2000 });
    var is_obsolete2851 = new Ext.form.Checkbox({ "selectOnFocus": true, "checked": false });
    var activity2852 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/courses/CourseProviders/activity", "method": "GET" }) }), "pageSize": 20, "emptyText": "Beruf ausw\u00e4hlen..." });
    var bank_account12853 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 40 });
    var bank_account22854 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 40 });
    var prefix2855 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var vat_id2856 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var type2857 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/courses/CourseProviders/type", "method": "GET" }) }), "pageSize": 20, "emptyText": "Organisationsart ausw\u00e4hlen..." });
    var client_contact_type2858 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/courses/CourseProviders/client_contact_type", "method": "GET" }) }), "pageSize": 20, "emptyText": "Klientenkontaktart ausw\u00e4hlen..." });
    var id2859 = new Ext.form.NumberField({ "selectOnFocus": true });
    this.before_row_edit = function(record) {
      city2836.setContextValue('country',record ? record.data['countryHidden'] : undefined);
      city2836.setContextValue('region',record ? record.data['regionHidden'] : undefined);
      region2837.setContextValue('country',record ? record.data['countryHidden'] : undefined);
    };
    this.onRender = function(ct, position) {
      country2835.on('change',Lino.chooser_handler(city2836,'country'));
      region2837.on('change',Lino.chooser_handler(city2836,'region'));
      country2835.on('change',Lino.chooser_handler(region2837,'country'));
      Lino.courses.CourseProviders.GridPanel.superclass.onRender.call(this, ct, position);
    }
    this.ls_columns = [ { "colIndex": 0, "sortable": true, "header": "Name", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "name", "editor": name2831 }, { "colIndex": 1, "sortable": true, "header": "E-Mail", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "email", "editor": email2832 }, { "width": Lino.chars2width(17), "colIndex": 2, "sortable": true, "dataIndex": "created", "header": "Erstellt", "hidden": true, "editable": false }, { "width": Lino.chars2width(17), "colIndex": 3, "sortable": true, "dataIndex": "modified", "header": "Bearbeitet", "hidden": true, "editable": false }, { "colIndex": 4, "sortable": true, "header": "Land", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('countryHidden','Lino.countries.Countries.detail'), "editor": country2835, "dataIndex": "country" }, { "colIndex": 5, "sortable": true, "header": "Ort", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "city", "editor": city2836 }, { "colIndex": 6, "sortable": true, "header": "Region", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "region", "editor": region2837 }, { "colIndex": 7, "sortable": true, "header": "Postleitzahl", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(12), "dataIndex": "zip_code", "editor": zip_code2838 }, { "colIndex": 8, "sortable": true, "header": "Adresszeile vor Stra\u00dfe", "editable": true, "tooltip": "Address line before street", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "addr1", "editor": addr12839 }, { "colIndex": 9, "sortable": true, "header": "Pr\u00e4fix Stra\u00dfe", "editable": true, "tooltip": "Text to print before name of street, but to ignore for sorting.", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "street_prefix", "editor": street_prefix2840 }, { "colIndex": 10, "sortable": true, "header": "Stra\u00dfe", "editable": true, "tooltip": "Name of street. Without house number.", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "street", "editor": street2841 }, { "colIndex": 11, "sortable": true, "header": "Nr.", "editable": true, "tooltip": "House number", "filter": { "type": "string" }, "width": Lino.chars2width(12), "dataIndex": "street_no", "editor": street_no2842 }, { "colIndex": 12, "sortable": true, "header": "Box", "editable": true, "tooltip": "Text to print after :attr:`steet_no` on the same line", "filter": { "type": "string" }, "width": Lino.chars2width(12), "dataIndex": "street_box", "editor": street_box2843 }, { "colIndex": 13, "sortable": true, "header": "Adresszeile nach Stra\u00dfe", "editable": true, "tooltip": "Address line to print below street line", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "addr2", "editor": addr22844 }, { "colIndex": 14, "sortable": true, "header": "Sprache", "editable": true, "tooltip": "Die Sprache, in der Dokumente ausgestellt werden sollen.", "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "language", "editor": language2845 }, { "colIndex": 15, "sortable": true, "header": "URL", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "url", "editor": url2846 }, { "colIndex": 16, "sortable": true, "header": "Telefon", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "phone", "editor": phone2847 }, { "colIndex": 17, "sortable": true, "header": "GSM", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "gsm", "editor": gsm2848 }, { "colIndex": 18, "sortable": true, "header": "Fax", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "fax", "editor": fax2849 }, { "colIndex": 19, "sortable": false, "header": "Bemerkungen", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(61), "renderer": Lino.text_renderer, "editor": remarks2850, "dataIndex": "remarks" }, { "colIndex": 20, "sortable": false, "xtype": "checkcolumn", "header": "veraltet", "editable": true, "tooltip": "Altf\u00e4lle sind Partner, deren Stammdaten nicht mehr gepflegt werden und \nf\u00fcr neue Operationen nicht benutzt werden k\u00f6nnen.", "filter": { "type": "boolean" }, "width": Lino.chars2width(11), "dataIndex": "is_obsolete" }, { "colIndex": 21, "sortable": true, "header": "Beruf", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "activity", "hidden": true, "editor": activity2852 }, { "colIndex": 22, "sortable": true, "header": "Bankkonto 1", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "bank_account1", "hidden": true, "editor": bank_account12853 }, { "colIndex": 23, "sortable": true, "header": "Bankkonto 2", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "bank_account2", "hidden": true, "editor": bank_account22854 }, { "colIndex": 24, "sortable": true, "header": "prefix", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "prefix", "editor": prefix2855 }, { "colIndex": 25, "sortable": true, "header": "MWSt.-Nr.", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "vat_id", "editor": vat_id2856 }, { "colIndex": 26, "sortable": true, "header": "Organisationsart", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "type", "editor": type2857 }, { "colIndex": 27, "sortable": true, "header": "Klientenkontaktart", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "client_contact_type", "editor": client_contact_type2858 }, new Lino.NullNumberColumn({ "colIndex": 28, "sortable": true, "format": "0", "editable": true, "filter": { "type": "numeric" }, "header": "ID", "renderer": Lino.id_renderer, "editor": id2859, "width": Lino.chars2width(6), "dataIndex": "id" }) ];
    Lino.courses.CourseProviders.GridPanel.superclass.initComponent.call(this);
  }
});


Lino.courses.CourseProviders.insertPanel = Ext.extend(Lino.contacts.Companies.InsertFormPanel,{
  empty_title: "Neu Kursanbieter",
  hide_navigator: true,
  ls_bbar_actions: [ { "itemId": "post", "menu_item_text": "Erstellen", "tooltip": "Datensatz erstellen und dann im Detail-Fenster \u00f6ffnen", "panel_btn_handler": function(panel){panel.save(null,true,'post')}, "text": "Erstellen", "overflowText": "Erstellen", "auto_save": false }, { "itemId": "poststay", "menu_item_text": "Erstellen ohne Detail", "tooltip": "Nach Erstellen des Datensatzes kein Detail-Fenster \u00f6ffnen", "panel_btn_handler": function(panel){panel.save(null,false,'poststay')}, "text": "Erstellen ohne Detail", "overflowText": "Erstellen ohne Detail", "auto_save": false } ],
  ls_url: "/courses/CourseProviders",
  action_name: "insert",
  initComponent : function() {
    this.ls_detail_handler = Lino.courses.CourseProviders.detail;
    this.ls_insert_handler = Lino.courses.CourseProviders.insert;
    Lino.courses.CourseProviders.insertPanel.superclass.initComponent.call(this);
  }
});

Lino.courses.CourseProviders.insert = new Lino.WindowAction({ "draggable": true, "width": Lino.chars2width(60), "autoHeight": true, "maximizable": true, "modal": true, "maximized": false },function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.courses.CourseProviders.insertPanel(p);
});

Lino.courses.CourseProviders.detailPanel = Ext.extend(Lino.courses.CourseProviders.DetailFormPanel,{
  empty_title: "Detail Kursanbieter",
  ls_bbar_actions: [ { "itemId": "put", "menu_item_text": "Speichern", "tooltip": "\u00c4nderungen in diesem Formular speichern", "panel_btn_handler": function(panel){panel.save(null,false,'put')}, "iconCls": "x-tbar-save", "overflowText": "Speichern", "auto_save": false }, { "itemId": "insert", "menu_item_text": "Neu", "must_save": true, "tooltip": "Neuen Datensatz erstellen", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-new", "overflowText": "Neu", "auto_save": true }, { "itemId": null, "menu_item_text": "L\u00f6schen", "tooltip": "Diesen Datensatz l\u00f6schen", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "L\u00f6schen", "auto_save": false } ],
  ls_url: "/courses/CourseProviders",
  action_name: "detail",
  initComponent : function() {
    this.ls_detail_handler = Lino.courses.CourseProviders.detail;
    this.ls_insert_handler = Lino.courses.CourseProviders.insert;
    Lino.courses.CourseProviders.detailPanel.superclass.initComponent.call(this);
  }
});

Lino.courses.CourseProviders.detail = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.courses.CourseProviders.detailPanel(p);
});
Lino.courses.CourseProviders.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.courses.CourseProviders.GridPanel(p);
});

// js_render_GridPanel_class courses.CourseContents
Lino.courses.CourseContents.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "Keine Daten anzuzeigen." },
  ls_url : "/courses/CourseContents",
  ls_bbar_actions : [ { "itemId": "insert", "menu_item_text": "Neu", "must_save": true, "tooltip": "Neuen Datensatz erstellen", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-new", "overflowText": "Neu", "auto_save": true }, { "itemId": "detail", "menu_item_text": "Detail", "tooltip": "Detail-Fenster auf diesem Datensatz \u00f6ffnen", "panel_btn_handler": Lino.show_detail, "iconCls": "x-tbar-detail", "overflowText": "Detail", "auto_save": true }, { "itemId": null, "menu_item_text": "L\u00f6schen", "tooltip": "Diesen Datensatz l\u00f6schen", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "L\u00f6schen", "auto_save": false } ],
  title : "Kursinhalte",
  page_length : 20,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "type": "int", "name": "id" }, { "name": "name" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 0,
  ls_grid_configs : [  ],
  content_type : 78,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 3,
  initComponent : function() {
    this.ls_detail_handler = Lino.courses.CourseContents.detail;
    this.ls_insert_handler = Lino.courses.CourseContents.insert;
    var ww = this.containing_window;
    var id2861 = new Ext.form.NumberField({ "selectOnFocus": true });
    var name2862 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ new Lino.NullNumberColumn({ "colIndex": 0, "sortable": true, "format": "0", "editable": true, "filter": { "type": "numeric" }, "header": "ID", "renderer": Lino.id_renderer, "editor": id2861, "width": Lino.chars2width(6), "dataIndex": "id" }), { "colIndex": 1, "sortable": true, "header": "Name", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "name", "editor": name2862 } ];
    Lino.courses.CourseContents.GridPanel.superclass.initComponent.call(this);
  }
});


Lino.courses.CourseContents.insertPanel = Ext.extend(Lino.courses.CourseContents.DetailFormPanel,{
  empty_title: "Neu Kursinhalte",
  hide_navigator: true,
  ls_bbar_actions: [ { "itemId": "post", "menu_item_text": "Erstellen", "tooltip": "Datensatz erstellen und dann im Detail-Fenster \u00f6ffnen", "panel_btn_handler": function(panel){panel.save(null,true,'post')}, "text": "Erstellen", "overflowText": "Erstellen", "auto_save": false }, { "itemId": "poststay", "menu_item_text": "Erstellen ohne Detail", "tooltip": "Nach Erstellen des Datensatzes kein Detail-Fenster \u00f6ffnen", "panel_btn_handler": function(panel){panel.save(null,false,'poststay')}, "text": "Erstellen ohne Detail", "overflowText": "Erstellen ohne Detail", "auto_save": false } ],
  ls_url: "/courses/CourseContents",
  action_name: "insert",
  initComponent : function() {
    this.ls_detail_handler = Lino.courses.CourseContents.detail;
    this.ls_insert_handler = Lino.courses.CourseContents.insert;
    Lino.courses.CourseContents.insertPanel.superclass.initComponent.call(this);
  }
});

Lino.courses.CourseContents.insert = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.courses.CourseContents.insertPanel(p);
});

Lino.courses.CourseContents.detailPanel = Ext.extend(Lino.courses.CourseContents.DetailFormPanel,{
  empty_title: "Detail Kursinhalte",
  ls_bbar_actions: [ { "itemId": "put", "menu_item_text": "Speichern", "tooltip": "\u00c4nderungen in diesem Formular speichern", "panel_btn_handler": function(panel){panel.save(null,false,'put')}, "iconCls": "x-tbar-save", "overflowText": "Speichern", "auto_save": false }, { "itemId": "insert", "menu_item_text": "Neu", "must_save": true, "tooltip": "Neuen Datensatz erstellen", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-new", "overflowText": "Neu", "auto_save": true }, { "itemId": null, "menu_item_text": "L\u00f6schen", "tooltip": "Diesen Datensatz l\u00f6schen", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "L\u00f6schen", "auto_save": false } ],
  ls_url: "/courses/CourseContents",
  action_name: "detail",
  initComponent : function() {
    this.ls_detail_handler = Lino.courses.CourseContents.detail;
    this.ls_insert_handler = Lino.courses.CourseContents.insert;
    Lino.courses.CourseContents.detailPanel.superclass.initComponent.call(this);
  }
});

Lino.courses.CourseContents.detail = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.courses.CourseContents.detailPanel(p);
});
Lino.courses.CourseContents.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.courses.CourseContents.GridPanel(p);
});

// js_render_GridPanel_class courses.Courses
Lino.courses.Courses.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "Keine Daten anzuzeigen." },
  ls_url : "/courses/Courses",
  ls_bbar_actions : [ { "itemId": "insert", "menu_item_text": "Neu", "must_save": true, "tooltip": "Neuen Datensatz erstellen", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-new", "overflowText": "Neu", "auto_save": true }, { "itemId": "detail", "menu_item_text": "Detail", "tooltip": "Detail-Fenster auf diesem Datensatz \u00f6ffnen", "panel_btn_handler": Lino.show_detail, "iconCls": "x-tbar-detail", "overflowText": "Detail", "auto_save": true }, { "itemId": null, "menu_item_text": "L\u00f6schen", "tooltip": "Diesen Datensatz l\u00f6schen", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "L\u00f6schen", "auto_save": false }, { "itemId": "print_candidates", "menu_item_text": "Kandidatenliste", "must_save": true, "tooltip": "Kandidatenliste", "panel_btn_handler": Lino.row_action_handler('print_candidates','GET'), "iconCls": "x-tbar-print", "overflowText": "Kandidatenliste", "auto_save": true }, { "itemId": "print_participants", "menu_item_text": "Teilnehmerliste", "must_save": true, "tooltip": "Teilnehmerliste", "panel_btn_handler": Lino.row_action_handler('print_participants','GET'), "iconCls": "x-tbar-print", "overflowText": "Teilnehmerliste", "auto_save": true } ],
  title : "Kurse",
  page_length : 20,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "type": "int", "name": "id" }, { "name": "offer" }, 'offerHidden', { "name": "title" }, { "type": "date", "name": "start_date", "dateFormat": "d.m.Y" }, { "name": "remark" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 0,
  ls_grid_configs : [  ],
  content_type : 76,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 7,
  initComponent : function() {
    this.ls_detail_handler = Lino.courses.Courses.detail;
    this.ls_insert_handler = Lino.courses.Courses.insert;
    var ww = this.containing_window;
    var id2864 = new Ext.form.NumberField({ "selectOnFocus": true });
    var offer2865 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/courses/Courses/offer", "method": "GET" }) }), "allowBlank": false, "pageSize": 20, "emptyText": "Kursangebot ausw\u00e4hlen..." });
    var title2866 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var start_date2867 = new Lino.DateField({ "selectOnFocus": true, "allowBlank": false });
    var remark2868 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ new Lino.NullNumberColumn({ "colIndex": 0, "sortable": true, "format": "0", "editable": true, "filter": { "type": "numeric" }, "header": "ID", "renderer": Lino.id_renderer, "editor": id2864, "width": Lino.chars2width(6), "dataIndex": "id" }), { "colIndex": 1, "sortable": true, "header": "Kursangebot", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('offerHidden','Lino.courses.CourseOffers.detail'), "editor": offer2865, "dataIndex": "offer" }, { "colIndex": 2, "sortable": true, "header": "Name", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "title", "editor": title2866 }, { "colIndex": 3, "sortable": true, "xtype": "datecolumn", "format": "d.m.Y", "editable": true, "filter": { "type": "date", "dateFormat": "d.m.Y" }, "header": "Beginndatum", "editor": start_date2867, "width": Lino.chars2width(9), "dataIndex": "start_date" }, { "colIndex": 4, "sortable": true, "header": "Bemerkung", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "remark", "editor": remark2868 } ];
    Lino.courses.Courses.GridPanel.superclass.initComponent.call(this);
  }
});


Lino.courses.Courses.insertPanel = Ext.extend(Lino.courses.Courses.DetailFormPanel,{
  empty_title: "Neu Kurse",
  hide_navigator: true,
  ls_bbar_actions: [ { "itemId": "post", "menu_item_text": "Erstellen", "tooltip": "Datensatz erstellen und dann im Detail-Fenster \u00f6ffnen", "panel_btn_handler": function(panel){panel.save(null,true,'post')}, "text": "Erstellen", "overflowText": "Erstellen", "auto_save": false }, { "itemId": "poststay", "menu_item_text": "Erstellen ohne Detail", "tooltip": "Nach Erstellen des Datensatzes kein Detail-Fenster \u00f6ffnen", "panel_btn_handler": function(panel){panel.save(null,false,'poststay')}, "text": "Erstellen ohne Detail", "overflowText": "Erstellen ohne Detail", "auto_save": false } ],
  ls_url: "/courses/Courses",
  action_name: "insert",
  initComponent : function() {
    this.ls_detail_handler = Lino.courses.Courses.detail;
    this.ls_insert_handler = Lino.courses.Courses.insert;
    Lino.courses.Courses.insertPanel.superclass.initComponent.call(this);
  }
});

Lino.courses.Courses.insert = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.courses.Courses.insertPanel(p);
});

Lino.courses.Courses.detailPanel = Ext.extend(Lino.courses.Courses.DetailFormPanel,{
  empty_title: "Detail Kurse",
  ls_bbar_actions: [ { "itemId": "put", "menu_item_text": "Speichern", "tooltip": "\u00c4nderungen in diesem Formular speichern", "panel_btn_handler": function(panel){panel.save(null,false,'put')}, "iconCls": "x-tbar-save", "overflowText": "Speichern", "auto_save": false }, { "itemId": "insert", "menu_item_text": "Neu", "must_save": true, "tooltip": "Neuen Datensatz erstellen", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-new", "overflowText": "Neu", "auto_save": true }, { "itemId": null, "menu_item_text": "L\u00f6schen", "tooltip": "Diesen Datensatz l\u00f6schen", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "L\u00f6schen", "auto_save": false }, { "itemId": "print_candidates", "menu_item_text": "Kandidatenliste", "must_save": true, "tooltip": "Kandidatenliste", "panel_btn_handler": Lino.row_action_handler('print_candidates','GET'), "iconCls": "x-tbar-print", "overflowText": "Kandidatenliste", "auto_save": true }, { "itemId": "print_participants", "menu_item_text": "Teilnehmerliste", "must_save": true, "tooltip": "Teilnehmerliste", "panel_btn_handler": Lino.row_action_handler('print_participants','GET'), "iconCls": "x-tbar-print", "overflowText": "Teilnehmerliste", "auto_save": true } ],
  ls_url: "/courses/Courses",
  action_name: "detail",
  initComponent : function() {
    this.ls_detail_handler = Lino.courses.Courses.detail;
    this.ls_insert_handler = Lino.courses.Courses.insert;
    Lino.courses.Courses.detailPanel.superclass.initComponent.call(this);
  }
});

Lino.courses.Courses.detail = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.courses.Courses.detailPanel(p);
});
Lino.courses.Courses.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.courses.Courses.GridPanel(p);
});

// js_render_GridPanel_class courses.CourseOffers
Lino.courses.CourseOffers.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "Keine Daten anzuzeigen." },
  ls_url : "/courses/CourseOffers",
  ls_bbar_actions : [ { "itemId": "insert", "menu_item_text": "Neu", "must_save": true, "tooltip": "Neuen Datensatz erstellen", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-new", "overflowText": "Neu", "auto_save": true }, { "itemId": "detail", "menu_item_text": "Detail", "tooltip": "Detail-Fenster auf diesem Datensatz \u00f6ffnen", "panel_btn_handler": Lino.show_detail, "iconCls": "x-tbar-detail", "overflowText": "Detail", "auto_save": true }, { "itemId": null, "menu_item_text": "L\u00f6schen", "tooltip": "Diesen Datensatz l\u00f6schen", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "L\u00f6schen", "auto_save": false } ],
  title : "Kursangebote",
  page_length : 20,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "type": "int", "name": "id" }, { "name": "title" }, { "name": "content" }, 'contentHidden', { "name": "provider" }, 'providerHidden', { "name": "description" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 0,
  ls_grid_configs : [  ],
  content_type : 79,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 8,
  initComponent : function() {
    this.ls_detail_handler = Lino.courses.CourseOffers.detail;
    this.ls_insert_handler = Lino.courses.CourseOffers.insert;
    var ww = this.containing_window;
    var id2870 = new Ext.form.NumberField({ "selectOnFocus": true });
    var title2871 = new Ext.form.TextField({ "selectOnFocus": true, "allowBlank": false, "maxLength": 200 });
    var content2872 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/courses/CourseOffers/content", "method": "GET" }) }), "allowBlank": false, "pageSize": 20, "emptyText": "Kursinhalt ausw\u00e4hlen..." });
    var provider2873 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/courses/CourseOffers/provider", "method": "GET" }) }), "allowBlank": false, "pageSize": 20, "emptyText": "Kursanbieter ausw\u00e4hlen..." });
    var description2874 = new Lino.RichTextPanel({ "selectOnFocus": true, "containing_panel": this, "title": "Beschreibung" });
    this.before_row_edit = function(record) {
      description2874.refresh();
    };
    this.ls_columns = [ new Lino.NullNumberColumn({ "colIndex": 0, "sortable": true, "format": "0", "editable": true, "filter": { "type": "numeric" }, "header": "ID", "renderer": Lino.id_renderer, "editor": id2870, "width": Lino.chars2width(6), "dataIndex": "id" }), { "colIndex": 1, "sortable": true, "header": "Name", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "title", "editor": title2871 }, { "colIndex": 2, "sortable": true, "header": "Kursinhalt", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('contentHidden','Lino.courses.CourseContents.detail'), "editor": content2872, "dataIndex": "content" }, { "colIndex": 3, "sortable": true, "header": "Kursanbieter", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('providerHidden','Lino.courses.CourseProviders.detail'), "editor": provider2873, "dataIndex": "provider" }, { "colIndex": 4, "sortable": false, "header": "description", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(61), "renderer": Lino.text_renderer, "editor": description2874, "dataIndex": "description" } ];
    Lino.courses.CourseOffers.GridPanel.superclass.initComponent.call(this);
  }
});


Lino.courses.CourseOffers.insertPanel = Ext.extend(Lino.courses.CourseOffers.DetailFormPanel,{
  empty_title: "Neu Kursangebote",
  hide_navigator: true,
  ls_bbar_actions: [ { "itemId": "post", "menu_item_text": "Erstellen", "tooltip": "Datensatz erstellen und dann im Detail-Fenster \u00f6ffnen", "panel_btn_handler": function(panel){panel.save(null,true,'post')}, "text": "Erstellen", "overflowText": "Erstellen", "auto_save": false }, { "itemId": "poststay", "menu_item_text": "Erstellen ohne Detail", "tooltip": "Nach Erstellen des Datensatzes kein Detail-Fenster \u00f6ffnen", "panel_btn_handler": function(panel){panel.save(null,false,'poststay')}, "text": "Erstellen ohne Detail", "overflowText": "Erstellen ohne Detail", "auto_save": false } ],
  ls_url: "/courses/CourseOffers",
  action_name: "insert",
  initComponent : function() {
    this.ls_detail_handler = Lino.courses.CourseOffers.detail;
    this.ls_insert_handler = Lino.courses.CourseOffers.insert;
    Lino.courses.CourseOffers.insertPanel.superclass.initComponent.call(this);
  }
});

Lino.courses.CourseOffers.insert = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.courses.CourseOffers.insertPanel(p);
});

Lino.courses.CourseOffers.detailPanel = Ext.extend(Lino.courses.CourseOffers.DetailFormPanel,{
  empty_title: "Detail Kursangebote",
  ls_bbar_actions: [ { "itemId": "put", "menu_item_text": "Speichern", "tooltip": "\u00c4nderungen in diesem Formular speichern", "panel_btn_handler": function(panel){panel.save(null,false,'put')}, "iconCls": "x-tbar-save", "overflowText": "Speichern", "auto_save": false }, { "itemId": "insert", "menu_item_text": "Neu", "must_save": true, "tooltip": "Neuen Datensatz erstellen", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-new", "overflowText": "Neu", "auto_save": true }, { "itemId": null, "menu_item_text": "L\u00f6schen", "tooltip": "Diesen Datensatz l\u00f6schen", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "L\u00f6schen", "auto_save": false } ],
  ls_url: "/courses/CourseOffers",
  action_name: "detail",
  initComponent : function() {
    this.ls_detail_handler = Lino.courses.CourseOffers.detail;
    this.ls_insert_handler = Lino.courses.CourseOffers.insert;
    Lino.courses.CourseOffers.detailPanel.superclass.initComponent.call(this);
  }
});

Lino.courses.CourseOffers.detail = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.courses.CourseOffers.detailPanel(p);
});
Lino.courses.CourseOffers.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.courses.CourseOffers.GridPanel(p);
});

// js_render_GridPanel_class debts.Budgets
Lino.debts.Budgets.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "Keine Daten anzuzeigen." },
  ls_url : "/debts/Budgets",
  ls_bbar_actions : [ { "itemId": "insert", "menu_item_text": "Neu", "must_save": true, "tooltip": "Neuen Datensatz erstellen", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-new", "overflowText": "Neu", "auto_save": true }, { "itemId": "duplicate", "menu_item_text": "Duplizieren", "must_save": true, "tooltip": "Duplizieren", "panel_btn_handler": Lino.row_action_handler('duplicate','GET'), "iconCls": "x-tbar-duplicate", "overflowText": "Duplizieren", "auto_save": true }, { "itemId": "detail", "menu_item_text": "Detail", "tooltip": "Detail-Fenster auf diesem Datensatz \u00f6ffnen", "panel_btn_handler": Lino.show_detail, "iconCls": "x-tbar-detail", "overflowText": "Detail", "auto_save": true }, { "itemId": null, "menu_item_text": "L\u00f6schen", "tooltip": "Diesen Datensatz l\u00f6schen", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "L\u00f6schen", "auto_save": false }, { "itemId": "do_print", "menu_item_text": "Drucken", "must_save": true, "tooltip": "Drucken", "panel_btn_handler": Lino.row_action_handler('do_print','GET'), "iconCls": "x-tbar-print", "overflowText": "Drucken", "auto_save": true }, { "itemId": "do_clear_cache", "menu_item_text": "Cache l\u00f6schen", "must_save": true, "tooltip": "Cache l\u00f6schen", "panel_btn_handler": Lino.row_action_handler('do_clear_cache','GET'), "iconCls": "x-tbar-clearcache", "overflowText": "Cache l\u00f6schen", "auto_save": true } ],
  title : "Budgets",
  page_length : 20,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "type": "int", "name": "id" }, { "name": "user" }, 'userHidden', { "name": "build_time" }, { "type": "date", "name": "date", "dateFormat": "d.m.Y" }, { "name": "partner" }, 'partnerHidden', { "type": "boolean", "name": "print_todos" }, { "type": "boolean", "name": "print_empty_rows" }, { "type": "boolean", "name": "include_yearly_incomes" }, { "name": "intro" }, { "name": "conclusion" }, { "name": "dist_amount" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 0,
  ls_grid_configs : [  ],
  content_type : 84,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 14,
  initComponent : function() {
    this.ls_detail_handler = Lino.debts.Budgets.detail;
    this.ls_insert_handler = Lino.debts.Budgets.insert;
    var ww = this.containing_window;
    var id2876 = new Ext.form.NumberField({ "selectOnFocus": true });
    var user2877 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/debts/Budgets/user", "method": "GET" }) }), "pageSize": 20, "emptyText": "Benutzer ausw\u00e4hlen..." });
    var build_time2878 = new Ext.form.DisplayField({ "disabled": true, "value": "<br>" });
    var date2879 = new Lino.DateField({ "selectOnFocus": true });
    var partner2880 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/debts/Budgets/partner", "method": "GET" }) }), "allowBlank": false, "pageSize": 20, "emptyText": "Partner ausw\u00e4hlen..." });
    var print_todos2881 = new Ext.form.Checkbox({ "selectOnFocus": true, "checked": false });
    var print_empty_rows2882 = new Ext.form.Checkbox({ "selectOnFocus": true, "checked": false });
    var include_yearly_incomes2883 = new Ext.form.Checkbox({ "selectOnFocus": true, "checked": false });
    var intro2884 = new Lino.RichTextPanel({ "selectOnFocus": true, "containing_panel": this, "title": "Einleitung" });
    var conclusion2885 = new Lino.RichTextPanel({ "selectOnFocus": true, "containing_panel": this, "title": "Schlussfolgerung" });
    var dist_amount2886 = new Ext.form.NumberField({ "selectOnFocus": true, "decimalSeparator": ",", "decimalPrecision": 2, "allowBlank": false, "value": 120 });
    this.before_row_edit = function(record) {
      intro2884.refresh();
      conclusion2885.refresh();
    };
    this.ls_columns = [ new Lino.NullNumberColumn({ "colIndex": 0, "sortable": true, "format": "0", "editable": true, "filter": { "type": "numeric" }, "header": "ID", "renderer": Lino.id_renderer, "editor": id2876, "width": Lino.chars2width(6), "dataIndex": "id" }), { "colIndex": 1, "sortable": true, "header": "Autor", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(16), "dataIndex": "user", "editor": user2877 }, { "width": Lino.chars2width(17), "colIndex": 2, "sortable": true, "dataIndex": "build_time", "header": "Druckdatum", "editable": false }, { "colIndex": 3, "sortable": true, "xtype": "datecolumn", "format": "d.m.Y", "editable": true, "filter": { "type": "date", "dateFormat": "d.m.Y" }, "header": "Datum", "editor": date2879, "width": Lino.chars2width(9), "dataIndex": "date" }, { "colIndex": 4, "sortable": true, "header": "Partner", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('partnerHidden','Lino.contacts.Partners.detail'), "editor": partner2880, "dataIndex": "partner" }, { "colIndex": 5, "sortable": false, "xtype": "checkcolumn", "header": "To-do-Liste drucken", "editable": true, "tooltip": "Eintr\u00e4ge im Feld \"To-do\" werden nur ausgedruckt, \nwenn die Option \"To-dos drucken\" des Budgets angekreuzt ist. \nDiese Option wird aber momentan noch ignoriert \n(d.h. To-do-Liste wird gar nicht ausgedruckt), \nweil wir noch \u00fcberlegen m\u00fcssen, *wie* sie ausgedruckt werden sollen. \nVielleicht mit Fu\u00dfnoten?", "filter": { "type": "boolean" }, "width": Lino.chars2width(11), "dataIndex": "print_todos" }, { "colIndex": 6, "sortable": false, "xtype": "checkcolumn", "header": "Auch leere Eintr\u00e4ge drucken", "editable": true, "tooltip": "Check this to print also empty rows for later completion.", "filter": { "type": "boolean" }, "width": Lino.chars2width(11), "dataIndex": "print_empty_rows" }, { "colIndex": 7, "sortable": false, "xtype": "checkcolumn", "header": "J\u00e4hrliche Einkommen ber\u00fccksichtigen", "editable": true, "tooltip": "Check this to include yearly incomes in the Debts Overview table of this Budget.", "filter": { "type": "boolean" }, "width": Lino.chars2width(11), "dataIndex": "include_yearly_incomes" }, { "colIndex": 8, "sortable": false, "header": "intro", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(61), "renderer": Lino.text_renderer, "editor": intro2884, "dataIndex": "intro" }, { "colIndex": 9, "sortable": false, "header": "conclusion", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(61), "renderer": Lino.text_renderer, "editor": conclusion2885, "dataIndex": "conclusion" }, new Lino.NullNumberColumn({ "colIndex": 10, "sortable": true, "header": "Verteilbarer Betrag", "editable": true, "tooltip": "Der monatlich verf\u00fcgbare Gesamtbetrag f\u00fcr Tabelle Schuldenverteilung.", "filter": { "type": "numeric" }, "width": Lino.chars2width(13), "dataIndex": "dist_amount", "editor": dist_amount2886 }) ];
    Lino.debts.Budgets.GridPanel.superclass.initComponent.call(this);
  }
});


Lino.debts.Budgets.insertPanel = Ext.extend(Lino.debts.Budgets.InsertFormPanel,{
  empty_title: "Neu Budgets",
  hide_navigator: true,
  ls_bbar_actions: [ { "itemId": "post", "menu_item_text": "Erstellen", "tooltip": "Datensatz erstellen und dann im Detail-Fenster \u00f6ffnen", "panel_btn_handler": function(panel){panel.save(null,true,'post')}, "text": "Erstellen", "overflowText": "Erstellen", "auto_save": false }, { "itemId": "poststay", "menu_item_text": "Erstellen ohne Detail", "tooltip": "Nach Erstellen des Datensatzes kein Detail-Fenster \u00f6ffnen", "panel_btn_handler": function(panel){panel.save(null,false,'poststay')}, "text": "Erstellen ohne Detail", "overflowText": "Erstellen ohne Detail", "auto_save": false } ],
  ls_url: "/debts/Budgets",
  action_name: "insert",
  initComponent : function() {
    this.ls_detail_handler = Lino.debts.Budgets.detail;
    this.ls_insert_handler = Lino.debts.Budgets.insert;
    Lino.debts.Budgets.insertPanel.superclass.initComponent.call(this);
  }
});

Lino.debts.Budgets.insert = new Lino.WindowAction({ "draggable": true, "width": Lino.chars2width(50), "autoHeight": true, "maximizable": true, "modal": true, "maximized": false },function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.debts.Budgets.insertPanel(p);
});

Lino.debts.Budgets.detailPanel = Ext.extend(Lino.debts.Budgets.DetailFormPanel,{
  empty_title: "Detail Budgets",
  ls_bbar_actions: [ { "itemId": "put", "menu_item_text": "Speichern", "tooltip": "\u00c4nderungen in diesem Formular speichern", "panel_btn_handler": function(panel){panel.save(null,false,'put')}, "iconCls": "x-tbar-save", "overflowText": "Speichern", "auto_save": false }, { "itemId": "insert", "menu_item_text": "Neu", "must_save": true, "tooltip": "Neuen Datensatz erstellen", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-new", "overflowText": "Neu", "auto_save": true }, { "itemId": "duplicate", "menu_item_text": "Duplizieren", "must_save": true, "tooltip": "Duplizieren", "panel_btn_handler": Lino.row_action_handler('duplicate','GET'), "iconCls": "x-tbar-duplicate", "overflowText": "Duplizieren", "auto_save": true }, { "itemId": null, "menu_item_text": "L\u00f6schen", "tooltip": "Diesen Datensatz l\u00f6schen", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "L\u00f6schen", "auto_save": false }, { "itemId": "do_print", "menu_item_text": "Drucken", "must_save": true, "tooltip": "Drucken", "panel_btn_handler": Lino.row_action_handler('do_print','GET'), "iconCls": "x-tbar-print", "overflowText": "Drucken", "auto_save": true }, { "itemId": "do_clear_cache", "menu_item_text": "Cache l\u00f6schen", "must_save": true, "tooltip": "Cache l\u00f6schen", "panel_btn_handler": Lino.row_action_handler('do_clear_cache','GET'), "iconCls": "x-tbar-clearcache", "overflowText": "Cache l\u00f6schen", "auto_save": true } ],
  ls_url: "/debts/Budgets",
  action_name: "detail",
  initComponent : function() {
    this.ls_detail_handler = Lino.debts.Budgets.detail;
    this.ls_insert_handler = Lino.debts.Budgets.insert;
    Lino.debts.Budgets.detailPanel.superclass.initComponent.call(this);
  }
});

Lino.debts.Budgets.detail = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.debts.Budgets.detailPanel(p);
});
Lino.debts.Budgets.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.debts.Budgets.GridPanel(p);
});

// js_render_GridPanel_class debts.Actors
Lino.debts.Actors.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "Keine Daten anzuzeigen." },
  ls_url : "/debts/Actors",
  ls_bbar_actions : [ { "itemId": "duplicate", "menu_item_text": "Duplizieren", "must_save": true, "tooltip": "Duplizieren", "panel_btn_handler": Lino.row_action_handler('duplicate','GET'), "iconCls": "x-tbar-duplicate", "overflowText": "Duplizieren", "auto_save": true }, { "itemId": null, "menu_item_text": "L\u00f6schen", "tooltip": "Diesen Datensatz l\u00f6schen", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "L\u00f6schen", "auto_save": false }, { "itemId": "move_up", "menu_item_text": "Up", "must_save": true, "panel_btn_handler": Lino.row_action_handler('move_up','GET'), "text": "Up", "overflowText": "Up", "auto_save": true }, { "itemId": "move_down", "menu_item_text": "Down", "must_save": true, "panel_btn_handler": Lino.row_action_handler('move_down','GET'), "text": "Down", "overflowText": "Down", "auto_save": true } ],
  title : "Budget-Akteure",
  page_length : 20,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "name": "budget" }, 'budgetHidden', { "type": "int", "name": "seqno" }, { "name": "partner" }, 'partnerHidden', { "name": "header" }, { "name": "remark" }, { "type": "int", "name": "id" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 7,
  ls_grid_configs : [  ],
  content_type : 85,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 9,
  initComponent : function() {
    var ww = this.containing_window;
    var budget2888 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/debts/Actors/budget", "method": "GET" }) }), "allowBlank": false, "pageSize": 20, "emptyText": "Budget ausw\u00e4hlen..." });
    var seqno2889 = new Ext.form.NumberField({ "selectOnFocus": true });
    var partner2890 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/debts/Actors/partner", "method": "GET" }) }), "pageSize": 20, "emptyText": "Partner ausw\u00e4hlen..." });
    var header2891 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 20 });
    var remark2892 = new Lino.RichTextPanel({ "selectOnFocus": true, "containing_panel": this, "title": "Bemerkung" });
    var id2893 = new Ext.form.NumberField({ "selectOnFocus": true });
    this.before_row_edit = function(record) {
      remark2892.refresh();
    };
    this.ls_columns = [ { "colIndex": 0, "sortable": true, "header": "Budget", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('budgetHidden','Lino.debts.Budgets.detail'), "editor": budget2888, "dataIndex": "budget" }, new Lino.NullNumberColumn({ "colIndex": 1, "sortable": true, "format": "0", "editable": true, "filter": { "type": "numeric" }, "header": "Seq.-Nr.", "dataIndex": "seqno", "width": Lino.chars2width(6), "editor": seqno2889 }), { "colIndex": 2, "sortable": true, "header": "Partner", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('partnerHidden','Lino.contacts.Partners.detail'), "editor": partner2890, "dataIndex": "partner" }, { "colIndex": 3, "sortable": true, "header": "Kopfdaten", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "header", "editor": header2891 }, { "colIndex": 4, "sortable": false, "header": "remark", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(61), "renderer": Lino.text_renderer, "editor": remark2892, "dataIndex": "remark" }, new Lino.NullNumberColumn({ "colIndex": 5, "sortable": true, "format": "0", "editable": true, "filter": { "type": "numeric" }, "header": "ID", "renderer": Lino.id_renderer, "editor": id2893, "width": Lino.chars2width(6), "dataIndex": "id" }) ];
    Lino.debts.Actors.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.debts.Actors.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.debts.Actors.GridPanel(p);
});
Lino.debts.Actors.move_up = function(rp,pk) { 
  Lino.run_row_action(rp,"/debts/Actors",pk,"move_up");
};
Lino.debts.Actors.move_down = function(rp,pk) { 
  Lino.run_row_action(rp,"/debts/Actors",pk,"move_down");
};

// js_render_GridPanel_class debts.EntriesByType
Lino.debts.EntriesByType.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "Keine Daten anzuzeigen." },
  ls_url : "/debts/EntriesByType",
  ls_bbar_actions : [ { "itemId": "duplicate", "menu_item_text": "Duplizieren", "must_save": true, "tooltip": "Duplizieren", "panel_btn_handler": Lino.row_action_handler('duplicate','GET'), "iconCls": "x-tbar-duplicate", "overflowText": "Duplizieren", "auto_save": true }, { "itemId": null, "menu_item_text": "L\u00f6schen", "tooltip": "Diesen Datensatz l\u00f6schen", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "L\u00f6schen", "auto_save": false }, { "itemId": "move_up", "menu_item_text": "Up", "must_save": true, "panel_btn_handler": Lino.row_action_handler('move_up','GET'), "text": "Up", "overflowText": "Up", "auto_save": true }, { "itemId": "move_down", "menu_item_text": "Down", "must_save": true, "panel_btn_handler": Lino.row_action_handler('move_down','GET'), "text": "Down", "overflowText": "Down", "auto_save": true } ],
  title : "Eintr\u00e4ge",
  page_length : 20,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "type": "int", "name": "id" }, { "type": "int", "name": "seqno" }, { "name": "budget" }, 'budgetHidden', { "name": "account_type" }, 'account_typeHidden', { "name": "account" }, 'accountHidden', { "name": "partner" }, 'partnerHidden', { "name": "amount" }, { "name": "actor" }, 'actorHidden', { "type": "boolean", "name": "circa" }, { "type": "boolean", "name": "distribute" }, { "name": "todo" }, { "name": "remark" }, { "name": "description" }, { "name": "periods" }, { "name": "monthly_rate" }, { "name": "bailiff" }, 'bailiffHidden', { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 0,
  ls_grid_configs : [  ],
  content_type : 83,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 23,
  initComponent : function() {
    var ww = this.containing_window;
    var id2895 = new Ext.form.NumberField({ "selectOnFocus": true });
    var seqno2896 = new Ext.form.NumberField({ "selectOnFocus": true });
    var budget2897 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/debts/EntriesByType/budget", "method": "GET" }) }), "allowBlank": false, "pageSize": 20, "emptyText": "Budget ausw\u00e4hlen..." });
    var account_type2898 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "forceSelection": true, "store": Lino.accounts.AccountTypes });
    var account2899 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/debts/EntriesByType/account", "method": "GET" }) }), "allowBlank": false, "pageSize": 20, "emptyText": "Konto ausw\u00e4hlen..." });
    var partner2900 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/debts/EntriesByType/partner", "method": "GET" }) }), "pageSize": 20, "emptyText": "Partner ausw\u00e4hlen..." });
    var amount2901 = new Ext.form.NumberField({ "selectOnFocus": true, "decimalPrecision": 2, "allowBlank": true, "decimalSeparator": "," });
    var actor2902 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/debts/EntriesByType/actor", "method": "GET" }) }), "pageSize": 20, "emptyText": "Budget-Akteur ausw\u00e4hlen..." });
    var circa2903 = new Ext.form.Checkbox({ "selectOnFocus": true, "checked": false });
    var distribute2904 = new Ext.form.Checkbox({ "selectOnFocus": true, "checked": false });
    var todo2905 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var remark2906 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var description2907 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var periods2908 = new Ext.form.NumberField({ "selectOnFocus": true, "allowBlank": true, "value": 1, "allowDecimals": false });
    var monthly_rate2909 = new Ext.form.NumberField({ "selectOnFocus": true, "decimalSeparator": ",", "decimalPrecision": 2, "allowBlank": false, "value": 0 });
    var bailiff2910 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/debts/EntriesByType/bailiff", "method": "GET" }) }), "pageSize": 20, "emptyText": "Organisation ausw\u00e4hlen..." });
    this.before_row_edit = function(record) {
      account2899.setContextValue('account_type',record ? record.data['account_typeHidden'] : undefined);
      actor2902.setContextValue('budget',record ? record.data['budgetHidden'] : undefined);
    };
    this.onRender = function(ct, position) {
      account_type2898.on('change',Lino.chooser_handler(account2899,'account_type'));
      budget2897.on('change',Lino.chooser_handler(actor2902,'budget'));
      Lino.debts.EntriesByType.GridPanel.superclass.onRender.call(this, ct, position);
    }
    this.ls_columns = [ new Lino.NullNumberColumn({ "colIndex": 0, "sortable": true, "format": "0", "editable": true, "filter": { "type": "numeric" }, "header": "ID", "renderer": Lino.id_renderer, "editor": id2895, "width": Lino.chars2width(6), "dataIndex": "id" }), new Lino.NullNumberColumn({ "colIndex": 1, "sortable": true, "format": "0", "editable": true, "filter": { "type": "numeric" }, "header": "Seq.-Nr.", "dataIndex": "seqno", "width": Lino.chars2width(6), "editor": seqno2896 }), { "colIndex": 2, "sortable": true, "header": "Budget", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('budgetHidden','Lino.debts.Budgets.detail'), "editor": budget2897, "dataIndex": "budget" }, { "colIndex": 3, "sortable": true, "header": "Kontenart", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(19), "dataIndex": "account_type", "editor": account_type2898 }, { "colIndex": 4, "sortable": true, "header": "Konto", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "account", "editor": account2899 }, { "colIndex": 5, "sortable": true, "header": "Partner", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('partnerHidden','Lino.contacts.Partners.detail'), "editor": partner2900, "dataIndex": "partner" }, new Lino.NullNumberColumn({ "colIndex": 6, "sortable": true, "header": "Betrag", "editable": true, "filter": { "type": "numeric" }, "width": Lino.chars2width(13), "dataIndex": "amount", "editor": amount2901 }), { "colIndex": 7, "sortable": true, "header": "Budget-Akteur", "editable": true, "tooltip": "Hier optional einen Akteur angeben, wenn der Eintrag \nsich nicht auf den Gesamthaushalt bezieht.", "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "actor", "editor": actor2902 }, { "colIndex": 8, "sortable": false, "xtype": "checkcolumn", "header": "ca.", "editable": true, "filter": { "type": "boolean" }, "width": Lino.chars2width(11), "dataIndex": "circa" }, { "colIndex": 9, "sortable": false, "xtype": "checkcolumn", "header": "Verteilen", "editable": true, "tooltip": "Ob diese Schuld in die Schuldenverteilung aufgeommen wird oder nicht.", "filter": { "type": "boolean" }, "width": Lino.chars2width(11), "dataIndex": "distribute" }, { "colIndex": 10, "sortable": true, "header": "to do", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "todo", "editor": todo2905 }, { "colIndex": 11, "sortable": true, "header": "Bemerkung", "editable": true, "tooltip": "Bemerkungen sind intern und werden nie ausgedruckt.", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "remark", "editor": remark2906 }, { "colIndex": 12, "sortable": true, "header": "Beschreibung", "editable": true, "tooltip": "Beschreibung wird automatisch mit der Kontobezeichung \nausgef\u00fcllt. Kann man aber manuell \u00e4ndern. \nWenn man das Konto \u00e4ndert, gehen manuelle \u00c4nderungen in diesem Feld verloren.\nBeim Ausdruck steht in Kolonne \"Beschreibung\"\nlediglich der Inhalt dieses Feldes, der eventuellen Bemerkung sowie \n(falls angegeben bei Schulden) der Partner.", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "description", "editor": description2907 }, new Lino.NullNumberColumn({ "colIndex": 13, "sortable": true, "format": "0/i", "editable": true, "tooltip": "Gibt an, f\u00fcr wieviele Monate dieser Betrag sich versteht. \nAlso bei monatlichen Ausgaben steht hier 1, \nbei j\u00e4hrlichen Ausgaben 12.", "filter": { "type": "numeric" }, "header": "Perioden", "dataIndex": "periods", "width": Lino.chars2width(6), "editor": periods2908 }), new Lino.NullNumberColumn({ "colIndex": 14, "sortable": true, "header": "Monatsrate", "editable": true, "tooltip": "\nEventueller Betrag monatlicher R\u00fcckzahlungen, \u00fcber deren Zahlung nicht verhandelt wird. \nWenn hier ein Betrag steht, darf \"Verteilen\" nicht angekreuzt sein.\n    ", "filter": { "type": "numeric" }, "width": Lino.chars2width(13), "dataIndex": "monthly_rate", "editor": monthly_rate2909 }), { "colIndex": 15, "sortable": true, "header": "Gerichtsvollzieher", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('bailiffHidden','Lino.contacts.Companies.detail'), "editor": bailiff2910, "dataIndex": "bailiff" } ];
    Lino.debts.EntriesByType.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.debts.EntriesByType.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.debts.EntriesByType.GridPanel(p);
});
Lino.debts.EntriesByType.move_up = function(rp,pk) { 
  Lino.run_row_action(rp,"/debts/EntriesByType",pk,"move_up");
};
Lino.debts.EntriesByType.move_down = function(rp,pk) { 
  Lino.run_row_action(rp,"/debts/EntriesByType",pk,"move_down");
};

// js_render_GridPanel_class cbss.RetrieveTIGroupsRequests
Lino.cbss.RetrieveTIGroupsRequests.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "Keine Daten anzuzeigen." },
  ls_url : "/cbss/RetrieveTIGroupsRequests",
  ls_bbar_actions : [ { "itemId": "insert", "menu_item_text": "Neu", "must_save": true, "tooltip": "Neuen Datensatz erstellen", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-new", "overflowText": "Neu", "auto_save": true }, { "itemId": "duplicate", "menu_item_text": "Duplizieren", "must_save": true, "tooltip": "Duplizieren", "panel_btn_handler": Lino.row_action_handler('duplicate','GET'), "iconCls": "x-tbar-duplicate", "overflowText": "Duplizieren", "auto_save": true }, { "itemId": "detail", "menu_item_text": "Detail", "tooltip": "Detail-Fenster auf diesem Datensatz \u00f6ffnen", "panel_btn_handler": Lino.show_detail, "iconCls": "x-tbar-detail", "overflowText": "Detail", "auto_save": true }, { "itemId": null, "menu_item_text": "L\u00f6schen", "tooltip": "Diesen Datensatz l\u00f6schen", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "L\u00f6schen", "auto_save": false }, { "itemId": "print_action", "menu_item_text": "Drucken", "must_save": true, "tooltip": "Drucken", "panel_btn_handler": Lino.row_action_handler('print_action','GET'), "iconCls": "x-tbar-print", "overflowText": "Drucken", "auto_save": true } ],
  title : "Tx25-Anfragen",
  page_length : 20,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "type": "int", "name": "id" }, { "name": "user" }, 'userHidden', { "name": "person" }, 'personHidden', { "name": "national_id" }, { "name": "language" }, 'languageHidden', { "type": "boolean", "name": "history" }, { "name": "status" }, 'statusHidden', { "name": "ticket" }, { "name": "sent" }, { "name": "environment" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 0,
  ls_grid_configs : [  ],
  content_type : 87,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 15,
  initComponent : function() {
    this.ls_detail_handler = Lino.cbss.RetrieveTIGroupsRequests.detail;
    this.ls_insert_handler = Lino.cbss.RetrieveTIGroupsRequests.insert;
    var ww = this.containing_window;
    var id2912 = new Ext.form.NumberField({ "selectOnFocus": true });
    var user2913 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cbss/RetrieveTIGroupsRequests/user", "method": "GET" }) }), "allowBlank": false, "pageSize": 20, "emptyText": "Benutzer ausw\u00e4hlen..." });
    var person2914 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cbss/RetrieveTIGroupsRequests/person", "method": "GET" }) }), "allowBlank": false, "pageSize": 20, "emptyText": "Klient ausw\u00e4hlen..." });
    var national_id2915 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var language2916 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "forceSelection": true, "store": Lino.cbss.RequestLanguages });
    var history2917 = new Ext.form.Checkbox({ "selectOnFocus": true, "checked": true });
    var status2918 = new Lino.ChoicesFieldElement({ "disabled": true, "forceSelection": true, "store": Lino.cbss.RequestStates });
    var ticket2919 = new Ext.form.TextField({ "disabled": true, "maxLength": 36 });
    var sent2920 = new Ext.form.DisplayField({ "disabled": true, "value": "<br>" });
    var environment2921 = new Ext.form.TextField({ "disabled": true, "boxMinWidth": Lino.chars2width(4), "maxLength": 4 });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ new Lino.NullNumberColumn({ "colIndex": 0, "sortable": true, "format": "0", "editable": true, "filter": { "type": "numeric" }, "header": "ID", "renderer": Lino.id_renderer, "editor": id2912, "width": Lino.chars2width(6), "dataIndex": "id" }), { "colIndex": 1, "sortable": true, "header": "Autor", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(16), "dataIndex": "user", "editor": user2913 }, { "colIndex": 2, "sortable": true, "header": "Klient", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('personHidden','Lino.pcsw.Clients.detail'), "editor": person2914, "dataIndex": "person" }, { "colIndex": 3, "sortable": true, "header": "NR-Nummer", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "national_id", "editor": national_id2915 }, { "colIndex": 4, "sortable": true, "header": "Sprache", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(18), "dataIndex": "language", "editor": language2916 }, { "colIndex": 5, "sortable": false, "xtype": "checkcolumn", "header": "Historie", "editable": true, "tooltip": "Whatever this means.", "filter": { "type": "boolean" }, "width": Lino.chars2width(11), "dataIndex": "history" }, { "filter": { "type": "string" }, "width": Lino.chars2width(19), "colIndex": 6, "sortable": true, "dataIndex": "status", "header": "Zustand", "editable": false }, { "filter": { "type": "string" }, "width": Lino.chars2width(22), "colIndex": 7, "sortable": true, "dataIndex": "ticket", "header": "Ticket", "editable": false }, { "width": Lino.chars2width(17), "colIndex": 8, "sortable": true, "dataIndex": "sent", "header": "Versendet", "editable": false, "tooltip": "The date and time when this request has been executed. \nThis is empty for requests than haven't been sent.\nRead-only." }, { "filter": { "type": "string" }, "width": Lino.chars2width(6), "colIndex": 9, "sortable": true, "dataIndex": "environment", "header": "T/A/B", "editable": false } ];
    Lino.cbss.RetrieveTIGroupsRequests.GridPanel.superclass.initComponent.call(this);
  }
});


Lino.cbss.RetrieveTIGroupsRequests.insertPanel = Ext.extend(Lino.cbss.RetrieveTIGroupsRequests.InsertFormPanel,{
  empty_title: "Neu Tx25-Anfragen",
  hide_navigator: true,
  ls_bbar_actions: [ { "itemId": "post", "menu_item_text": "Erstellen", "tooltip": "Datensatz erstellen und dann im Detail-Fenster \u00f6ffnen", "panel_btn_handler": function(panel){panel.save(null,true,'post')}, "text": "Erstellen", "overflowText": "Erstellen", "auto_save": false }, { "itemId": "poststay", "menu_item_text": "Erstellen ohne Detail", "tooltip": "Nach Erstellen des Datensatzes kein Detail-Fenster \u00f6ffnen", "panel_btn_handler": function(panel){panel.save(null,false,'poststay')}, "text": "Erstellen ohne Detail", "overflowText": "Erstellen ohne Detail", "auto_save": false } ],
  ls_url: "/cbss/RetrieveTIGroupsRequests",
  action_name: "insert",
  initComponent : function() {
    this.ls_detail_handler = Lino.cbss.RetrieveTIGroupsRequests.detail;
    this.ls_insert_handler = Lino.cbss.RetrieveTIGroupsRequests.insert;
    Lino.cbss.RetrieveTIGroupsRequests.insertPanel.superclass.initComponent.call(this);
  }
});

Lino.cbss.RetrieveTIGroupsRequests.insert = new Lino.WindowAction({ "draggable": true, "width": Lino.chars2width(40), "autoHeight": true, "maximizable": true, "modal": true, "maximized": false },function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.cbss.RetrieveTIGroupsRequests.insertPanel(p);
});

Lino.cbss.RetrieveTIGroupsRequests.detailPanel = Ext.extend(Lino.cbss.RetrieveTIGroupsRequests.DetailFormPanel,{
  empty_title: "Detail Tx25-Anfragen",
  ls_bbar_actions: [ { "itemId": "put", "menu_item_text": "Speichern", "tooltip": "\u00c4nderungen in diesem Formular speichern", "panel_btn_handler": function(panel){panel.save(null,false,'put')}, "iconCls": "x-tbar-save", "overflowText": "Speichern", "auto_save": false }, { "itemId": "insert", "menu_item_text": "Neu", "must_save": true, "tooltip": "Neuen Datensatz erstellen", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-new", "overflowText": "Neu", "auto_save": true }, { "itemId": "duplicate", "menu_item_text": "Duplizieren", "must_save": true, "tooltip": "Duplizieren", "panel_btn_handler": Lino.row_action_handler('duplicate','GET'), "iconCls": "x-tbar-duplicate", "overflowText": "Duplizieren", "auto_save": true }, { "itemId": null, "menu_item_text": "L\u00f6schen", "tooltip": "Diesen Datensatz l\u00f6schen", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "L\u00f6schen", "auto_save": false }, { "itemId": "print_action", "menu_item_text": "Drucken", "must_save": true, "tooltip": "Drucken", "panel_btn_handler": Lino.row_action_handler('print_action','GET'), "iconCls": "x-tbar-print", "overflowText": "Drucken", "auto_save": true } ],
  ls_url: "/cbss/RetrieveTIGroupsRequests",
  action_name: "detail",
  initComponent : function() {
    this.ls_detail_handler = Lino.cbss.RetrieveTIGroupsRequests.detail;
    this.ls_insert_handler = Lino.cbss.RetrieveTIGroupsRequests.insert;
    Lino.cbss.RetrieveTIGroupsRequests.detailPanel.superclass.initComponent.call(this);
  }
});

Lino.cbss.RetrieveTIGroupsRequests.detail = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.cbss.RetrieveTIGroupsRequests.detailPanel(p);
});
Lino.cbss.RetrieveTIGroupsRequests.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.cbss.RetrieveTIGroupsRequests.GridPanel(p);
});

// js_render_GridPanel_class sessions.SessionTable
Lino.sessions.SessionTable.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "Keine Daten anzuzeigen." },
  ls_url : "/sessions/SessionTable",
  ls_bbar_actions : [ { "itemId": null, "menu_item_text": "L\u00f6schen", "tooltip": "Diesen Datensatz l\u00f6schen", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "L\u00f6schen", "auto_save": false } ],
  title : "Sitzungen",
  page_length : 20,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "name": "session_key" }, { "name": "session_data" }, { "name": "expire_date" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 0,
  ls_grid_configs : [  ],
  content_type : 4,
  ls_id_property : "session_key",
  gc_name : 0,
  disabled_actions_index : 4,
  initComponent : function() {
    var ww = this.containing_window;
    var session_key2923 = new Ext.form.TextField({ "selectOnFocus": true, "allowBlank": false, "maxLength": 40 });
    var session_data2924 = new Ext.form.TextArea({ "selectOnFocus": true, "allowBlank": false, "growMax": 2000 });
    var expire_date2925 = new Ext.form.DisplayField({ "selectOnFocus": true, "allowBlank": false, "value": "<br>" });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ { "colIndex": 0, "sortable": true, "header": "Sitzungs-ID", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "session_key", "editor": session_key2923 }, { "colIndex": 1, "sortable": false, "header": "Sitzungsdaten", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(61), "renderer": Lino.text_renderer, "editor": session_data2924, "dataIndex": "session_data" }, { "width": Lino.chars2width(17), "colIndex": 2, "sortable": true, "dataIndex": "expire_date", "header": "Verfallsdatum", "editable": true, "editor": expire_date2925 } ];
    Lino.sessions.SessionTable.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.sessions.SessionTable.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.sessions.SessionTable.GridPanel(p);
});

// js_render_GridPanel_class ui.MyTextFieldTemplates
Lino.ui.MyTextFieldTemplates.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "Keine Daten anzuzeigen." },
  ls_url : "/ui/MyTextFieldTemplates",
  ls_bbar_actions : [ { "itemId": "insert", "menu_item_text": "Neu", "must_save": true, "tooltip": "Neuen Datensatz erstellen", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-new", "overflowText": "Neu", "auto_save": true }, { "itemId": "detail", "menu_item_text": "Detail", "tooltip": "Detail-Fenster auf diesem Datensatz \u00f6ffnen", "panel_btn_handler": Lino.show_detail, "iconCls": "x-tbar-detail", "overflowText": "Detail", "auto_save": true }, { "itemId": null, "menu_item_text": "L\u00f6schen", "tooltip": "Diesen Datensatz l\u00f6schen", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "L\u00f6schen", "auto_save": false } ],
  title : "Meine Einf\u00fcgetexte",
  page_length : 20,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "type": "int", "name": "id" }, { "name": "name" }, { "name": "description" }, { "name": "team" }, 'teamHidden', { "name": "text" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 0,
  ls_grid_configs : [  ],
  content_type : 1,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 7,
  initComponent : function() {
    this.ls_detail_handler = Lino.ui.MyTextFieldTemplates.detail;
    this.ls_insert_handler = Lino.ui.MyTextFieldTemplates.insert;
    var ww = this.containing_window;
    var id2927 = new Ext.form.NumberField({ "selectOnFocus": true });
    var name2928 = new Ext.form.TextField({ "selectOnFocus": true, "allowBlank": false, "maxLength": 200 });
    var description2929 = new Ext.form.TextArea({ "selectOnFocus": true, "growMax": 2000 });
    var team2930 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/ui/MyTextFieldTemplates/team", "method": "GET" }) }), "pageSize": 20, "emptyText": "Team ausw\u00e4hlen..." });
    var text2931 = new Lino.RichTextPanel({ "selectOnFocus": true, "containing_panel": this, "title": "Vorlagentext" });
    this.before_row_edit = function(record) {
      text2931.refresh();
    };
    this.ls_columns = [ new Lino.NullNumberColumn({ "colIndex": 0, "sortable": true, "format": "0", "editable": true, "filter": { "type": "numeric" }, "header": "ID", "renderer": Lino.id_renderer, "editor": id2927, "width": Lino.chars2width(6), "dataIndex": "id" }), { "colIndex": 1, "sortable": true, "header": "Bezeichnung", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "name", "editor": name2928 }, { "colIndex": 2, "sortable": false, "header": "Beschreibung", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(61), "renderer": Lino.text_renderer, "editor": description2929, "dataIndex": "description" }, { "colIndex": 3, "sortable": true, "header": "Team", "editable": true, "tooltip": "If not empty, then this template is reserved to members of this team.", "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "team", "editor": team2930 }, { "colIndex": 4, "sortable": false, "header": "text", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(61), "renderer": Lino.text_renderer, "editor": text2931, "dataIndex": "text" } ];
    Lino.ui.MyTextFieldTemplates.GridPanel.superclass.initComponent.call(this);
  }
});


Lino.ui.MyTextFieldTemplates.insertPanel = Ext.extend(Lino.ui.TextFieldTemplates.InsertFormPanel,{
  empty_title: "Neu Meine Einf\u00fcgetexte",
  hide_navigator: true,
  ls_bbar_actions: [ { "itemId": "post", "menu_item_text": "Erstellen", "tooltip": "Datensatz erstellen und dann im Detail-Fenster \u00f6ffnen", "panel_btn_handler": function(panel){panel.save(null,true,'post')}, "text": "Erstellen", "overflowText": "Erstellen", "auto_save": false }, { "itemId": "poststay", "menu_item_text": "Erstellen ohne Detail", "tooltip": "Nach Erstellen des Datensatzes kein Detail-Fenster \u00f6ffnen", "panel_btn_handler": function(panel){panel.save(null,false,'poststay')}, "text": "Erstellen ohne Detail", "overflowText": "Erstellen ohne Detail", "auto_save": false } ],
  ls_url: "/ui/MyTextFieldTemplates",
  action_name: "insert",
  initComponent : function() {
    this.ls_detail_handler = Lino.ui.MyTextFieldTemplates.detail;
    this.ls_insert_handler = Lino.ui.MyTextFieldTemplates.insert;
    Lino.ui.MyTextFieldTemplates.insertPanel.superclass.initComponent.call(this);
  }
});

Lino.ui.MyTextFieldTemplates.insert = new Lino.WindowAction({ "draggable": true, "width": Lino.chars2width(60), "autoHeight": true, "maximizable": true, "modal": true, "maximized": false },function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.ui.MyTextFieldTemplates.insertPanel(p);
});

Lino.ui.MyTextFieldTemplates.detailPanel = Ext.extend(Lino.ui.TextFieldTemplates.DetailFormPanel,{
  empty_title: "Detail Meine Einf\u00fcgetexte",
  ls_bbar_actions: [ { "itemId": "put", "menu_item_text": "Speichern", "tooltip": "\u00c4nderungen in diesem Formular speichern", "panel_btn_handler": function(panel){panel.save(null,false,'put')}, "iconCls": "x-tbar-save", "overflowText": "Speichern", "auto_save": false }, { "itemId": "insert", "menu_item_text": "Neu", "must_save": true, "tooltip": "Neuen Datensatz erstellen", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-new", "overflowText": "Neu", "auto_save": true }, { "itemId": null, "menu_item_text": "L\u00f6schen", "tooltip": "Diesen Datensatz l\u00f6schen", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "L\u00f6schen", "auto_save": false } ],
  ls_url: "/ui/MyTextFieldTemplates",
  action_name: "detail",
  initComponent : function() {
    this.ls_detail_handler = Lino.ui.MyTextFieldTemplates.detail;
    this.ls_insert_handler = Lino.ui.MyTextFieldTemplates.insert;
    Lino.ui.MyTextFieldTemplates.detailPanel.superclass.initComponent.call(this);
  }
});

Lino.ui.MyTextFieldTemplates.detail = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.ui.MyTextFieldTemplates.detailPanel(p);
});
Lino.ui.MyTextFieldTemplates.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.ui.MyTextFieldTemplates.GridPanel(p);
});

// js_render_GridPanel_class users.AuthoritiesGiven
Lino.users.AuthoritiesGiven.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "forceFit": true, "emptyText": "Keine Daten anzuzeigen." },
  ls_url : "/users/AuthoritiesGiven",
  ls_bbar_actions : [ { "itemId": null, "menu_item_text": "L\u00f6schen", "tooltip": "Diesen Datensatz l\u00f6schen", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "L\u00f6schen", "auto_save": false } ],
  title : "Erteilte Vollmachten",
  page_length : 20,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "name": "authorized" }, 'authorizedHidden', { "type": "int", "name": "id" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 2,
  ls_grid_configs : [  ],
  content_type : 8,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 4,
  initComponent : function() {
    var ww = this.containing_window;
    var authorized108 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/users/AuthoritiesGiven/authorized", "method": "GET" }) }), "allowBlank": false, "pageSize": 20, "emptyText": "Benutzer ausw\u00e4hlen..." });
    this.before_row_edit = function(record) {
      var bp = this.get_base_params();
      authorized108.setContextValue('mk',bp['mk']);
      authorized108.setContextValue('mt',bp['mt']);
    };
    this.ls_columns = [ { "colIndex": 0, "sortable": true, "header": "Benutzer", "editable": true, "tooltip": "The user who gets authority to act in your name.", "filter": { "type": "string" }, "width": Lino.chars2width(16), "dataIndex": "authorized", "editor": authorized108 } ];
    Lino.users.AuthoritiesGiven.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.users.AuthoritiesGiven.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.users.AuthoritiesGiven.GridPanel(p);
});

// js_render_GridPanel_class users.AuthoritiesTaken
Lino.users.AuthoritiesTaken.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "forceFit": true, "emptyText": "Keine Daten anzuzeigen." },
  ls_url : "/users/AuthoritiesTaken",
  ls_bbar_actions : [ { "itemId": null, "menu_item_text": "L\u00f6schen", "tooltip": "Diesen Datensatz l\u00f6schen", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "L\u00f6schen", "auto_save": false } ],
  title : "Erhaltene Vollmachten",
  page_length : 20,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "name": "user" }, 'userHidden', { "type": "int", "name": "id" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 2,
  ls_grid_configs : [  ],
  content_type : 8,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 4,
  initComponent : function() {
    var ww = this.containing_window;
    var user2933 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/users/AuthoritiesTaken/user", "method": "GET" }) }), "pageSize": 20, "emptyText": "Benutzer ausw\u00e4hlen..." });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ { "colIndex": 0, "sortable": true, "header": "Autor", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(16), "dataIndex": "user", "editor": user2933 } ];
    Lino.users.AuthoritiesTaken.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.users.AuthoritiesTaken.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.users.AuthoritiesTaken.GridPanel(p);
});

// js_render_GridPanel_class countries.CitiesByCity
Lino.countries.CitiesByCity.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "Keine Daten anzuzeigen." },
  ls_url : "/countries/CitiesByCity",
  ls_bbar_actions : [ { "itemId": "insert", "menu_item_text": "Neu", "must_save": true, "tooltip": "Neuen Datensatz erstellen", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-new", "overflowText": "Neu", "auto_save": true }, { "itemId": "detail", "menu_item_text": "Detail", "tooltip": "Detail-Fenster auf diesem Datensatz \u00f6ffnen", "panel_btn_handler": Lino.show_detail, "iconCls": "x-tbar-detail", "overflowText": "Detail", "auto_save": true }, { "itemId": null, "menu_item_text": "L\u00f6schen", "tooltip": "Diesen Datensatz l\u00f6schen", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "L\u00f6schen", "auto_save": false } ],
  title : "Subdivisions",
  page_length : 20,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "name": "name" }, { "name": "name_fr" }, { "name": "name_nl" }, { "name": "type" }, 'typeHidden', { "name": "zip_code" }, { "type": "int", "name": "id" }, { "name": "country" }, 'countryHidden', { "name": "inscode" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 6,
  ls_grid_configs : [  ],
  content_type : 13,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 11,
  initComponent : function() {
    this.ls_detail_handler = Lino.countries.CitiesByCity.detail;
    this.ls_insert_handler = Lino.countries.CitiesByCity.insert;
    var ww = this.containing_window;
    var name300 = new Ext.form.TextField({ "selectOnFocus": true, "allowBlank": false, "maxLength": 200 });
    var name_fr301 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var name_nl302 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var type303 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/countries/CitiesByCity/type", "method": "GET" }) }) });
    var zip_code304 = new Ext.form.TextField({ "selectOnFocus": true, "boxMinWidth": Lino.chars2width(8), "maxLength": 8 });
    var id305 = new Ext.form.NumberField({ "selectOnFocus": true });
    var country306 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/countries/CitiesByCity/country", "method": "GET" }) }), "allowBlank": false, "pageSize": 20, "emptyText": "Land ausw\u00e4hlen..." });
    var inscode307 = new Ext.form.TextField({ "selectOnFocus": true, "boxMinWidth": Lino.chars2width(5), "maxLength": 5 });
    this.before_row_edit = function(record) {
      type303.setContextValue('country',record ? record.data['countryHidden'] : undefined);
    };
    this.onRender = function(ct, position) {
      country306.on('change',Lino.chooser_handler(type303,'country'));
      Lino.countries.CitiesByCity.GridPanel.superclass.onRender.call(this, ct, position);
    }
    this.ls_columns = [ { "colIndex": 0, "sortable": true, "header": "Bezeichnung", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "name", "editor": name300 }, { "colIndex": 1, "sortable": true, "header": "Bezeichnung (fr)", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "name_fr", "editor": name_fr301 }, { "colIndex": 2, "sortable": true, "header": "Bezeichnung (nl)", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "name_nl", "editor": name_nl302 }, { "colIndex": 3, "sortable": true, "header": "Ortsart", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(11), "dataIndex": "type", "editor": type303 }, { "colIndex": 4, "sortable": true, "header": "zip code", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(10), "dataIndex": "zip_code", "editor": zip_code304 }, new Lino.NullNumberColumn({ "colIndex": 5, "sortable": true, "format": "0", "editable": true, "filter": { "type": "numeric" }, "header": "ID", "renderer": Lino.id_renderer, "editor": id305, "width": Lino.chars2width(6), "dataIndex": "id" }), { "colIndex": 6, "sortable": true, "header": "Land", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('countryHidden','Lino.countries.Countries.detail'), "editor": country306, "dataIndex": "country" }, { "colIndex": 7, "sortable": true, "header": "INS-Code", "editable": true, "tooltip": "The official code for this place used by statbel.fgov.be", "filter": { "type": "string" }, "width": Lino.chars2width(7), "dataIndex": "inscode", "editor": inscode307 } ];
    Lino.countries.CitiesByCity.GridPanel.superclass.initComponent.call(this);
  }
});


Lino.countries.CitiesByCity.insertPanel = Ext.extend(Lino.countries.CitiesByCity.DetailFormPanel,{
  empty_title: "Neu Subdivisions",
  hide_navigator: true,
  ls_bbar_actions: [ { "itemId": "post", "menu_item_text": "Erstellen", "tooltip": "Datensatz erstellen und dann im Detail-Fenster \u00f6ffnen", "panel_btn_handler": function(panel){panel.save(null,true,'post')}, "text": "Erstellen", "overflowText": "Erstellen", "auto_save": false }, { "itemId": "poststay", "menu_item_text": "Erstellen ohne Detail", "tooltip": "Nach Erstellen des Datensatzes kein Detail-Fenster \u00f6ffnen", "panel_btn_handler": function(panel){panel.save(nu