/*
 Copyright 2009-2013 Luc Saffre
 This file is part of the Lino project.
 Lino is free software; you can redistribute it and/or modify 
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 3 of the License, or
 (at your option) any later version.
 Lino is distributed in the hope that it will be useful, 
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the 
 GNU General Public License for more details.
 You should have received a copy of the GNU General Public License
 along with Lino; if not, see <http://www.gnu.org/licenses/>.
*/

// lino.js --- generated Thu May 16 06:29:39 2013 by Lino version 1.6.7.
Ext.BLANK_IMAGE_URL = '/media/extjs/resources/images/default/s.gif';
LANGUAGE_CHOICES = [ [ "de", "German" ], [ "fr", "French" ], [ "nl", "Dutch" ] ];
MEDIA_URL = "/media";

/* MonthPickerPlugin: thanks to keypoint @ sencha forum
   http://www.sencha.com/forum/showthread.php?74002-3.x-Ext.ux.MonthMenu&p=356860#post356860
*/
Ext.namespace('Ext.ux'); 

Ext.ux.MonthPickerPlugin = function() { 
    var picker; 
    var oldDateDefaults; 

    this.init = function(pk) { 
        picker = pk; 
        picker.onTriggerClick = picker.onTriggerClick.createSequence(onClick); 
        picker.getValue = picker.getValue.createInterceptor(setDefaultMonthDay).createSequence(restoreDefaultMonthDay); 
        picker.beforeBlur = picker.beforeBlur.createInterceptor(setDefaultMonthDay).createSequence(restoreDefaultMonthDay); 
    }; 

    function setDefaultMonthDay() { 
        oldDateDefaults = Date.defaults.d; 
        Date.defaults.d = 1; 
        return true; 
    } 

    function restoreDefaultMonthDay(ret) { 
        Date.defaults.d = oldDateDefaults; 
        return ret; 
    } 

    function onClick(e, el, opt) { 
        var p = picker.menu.picker; 
        p.activeDate = p.activeDate.getFirstDateOfMonth(); 
        if (p.value) { 
            p.value = p.value.getFirstDateOfMonth(); 
        } 

        p.showMonthPicker(); 
         
        if (!p.disabled) { 
            p.monthPicker.stopFx(); 
            p.monthPicker.show(); 

            p.mun(p.monthPicker, 'click', p.onMonthClick, p); 
            p.mun(p.monthPicker, 'dblclick', p.onMonthDblClick, p); 
            p.onMonthClick = p.onMonthClick.createSequence(pickerClick); 
            p.onMonthDblClick = p.onMonthDblClick.createSequence(pickerDblclick); 
            p.mon(p.monthPicker, 'click', p.onMonthClick, p); 
            p.mon(p.monthPicker, 'dblclick', p.onMonthDblClick, p); 
        } 
    } 

    function pickerClick(e, t) { 
        var el = new Ext.Element(t); 
        if (el.is('button.x-date-mp-cancel')) { 
            picker.menu.hide(); 
        } else if(el.is('button.x-date-mp-ok')) { 
            var p = picker.menu.picker; 
            p.setValue(p.activeDate); 
            p.fireEvent('select', p, p.value); 
        } 
    } 

    function pickerDblclick(e, t) { 
        var el = new Ext.Element(t); 
        if (el.parent() 
            && (el.parent().is('td.x-date-mp-month') 
            || el.parent().is('td.x-date-mp-year'))) { 

            var p = picker.menu.picker; 
            p.setValue(p.activeDate); 
            p.fireEvent('select', p, p.value); 
        } 
    } 
}; 

Ext.preg('monthPickerPlugin', Ext.ux.MonthPickerPlugin);  

//~ /* 
  //~ http://www.diloc.de/blog/2008/03/05/how-to-submit-ext-forms-the-right-way/
//~ */
//~ /**
 //~ * This submit action is basically the same as the normal submit action,
 //~ * only that it uses the fields getSubmitValue() to compose the values to submit,
 //~ * instead of looping over the input-tags in the form-tag of the form.
 //~ *
 //~ * To use it, just use the OOSubmit-plugin on either a FormPanel or a BasicForm,
 //~ * or explicitly call form.doAction('oosubmit');
 //~ *
 //~ * @param {Object} form
 //~ * @param {Object} options
 //~ */
//~ Ext.ux.OOSubmitAction = function(form, options){
    //~ Ext.ux.OOSubmitAction.superclass.constructor.call(this, form, options);
//~ };

//~ Ext.extend(Ext.ux.OOSubmitAction, Ext.form.Action.Submit, {
    //~ /**
    //~ * @cfg {boolean} clientValidation Determines whether a Form's fields are validated
    //~ * in a final call to {@link Ext.form.BasicForm#isValid isValid} prior to submission.
    //~ * Pass <tt>false</tt> in the Form's submit options to prevent this. If not defined, pre-submission field validation
    //~ * is performed.
    //~ */
    //~ type : 'oosubmit',

    //~ // private
    //~ /**
     //~ * This is nearly a copy of the original submit action run method
     //~ */
    //~ run : function(){
        //~ var o = this.options;
        //~ var method = this.getMethod();
        //~ var isPost = method == 'POST';

        //~ var params = this.options.params || {};
        //~ if (isPost) Ext.applyIf(params, this.form.baseParams);

        //~ //now add the form parameters
        //~ this.form.items.each(function(field)
        //~ {
            //~ if (!field.disabled)
            //~ {
                //~ //check if the form item provides a specialized getSubmitValue() and use that if available
                //~ if (typeof field.getSubmitValue == "function")
                    //~ params[field.getName()] = field.getSubmitValue();
                //~ else
                    //~ params[field.getName()] = field.getValue();
            //~ }
        //~ });

        //~ //convert params to get style if we are not post
        //~ if (!isPost) params=Ext.urlEncode(params);

        //~ if(o.clientValidation === false || this.form.isValid()){
            //~ Ext.Ajax.request(Ext.apply(this.createCallback(o), {
                //~ url:this.getUrl(!isPost),
                //~ method: method,
                //~ params:params, //add our values
                //~ isUpload: this.form.fileUpload
            //~ }));

        //~ }else if (o.clientValidation !== false){ // client validation failed
            //~ this.failureType = Ext.form.Action.CLIENT_INVALID;
            //~ this.form.afterAction(this, false);
        //~ }
    //~ },

//~ });
//~ //add our action to the registry of known actions
//~ Ext.form.Action.ACTION_TYPES['oosubmit'] = Ext.ux.OOSubmitAction;




/**
JC Watsons solution (adapted to ExtJS 3.3.1 by LS) is elegant and simple:
`A "fix" for unchecked checkbox submission  behaviour
<http://www.sencha.com/forum/showthread.php?28449>`_

Added special handling for checkbox inputs. 
ExtJS defines disabled checkboxes `readonly`, not `disabled` as for other inputs.

*/
Ext.lib.Ajax.serializeForm = function(form) {
    //~ console.log('20120203 linolib.js serializeForm',form);
    var fElements = form.elements || (document.forms[form] || Ext.getDom(form)).elements, 
        hasSubmit = false, 
        encoder = encodeURIComponent, 
        name, 
        data = '', 
        type, 
        hasValue;

    Ext.each(fElements, function(element){
        name = element.name;
        type = element.type;

        if (!element.disabled && name && !(type == 'checkbox' && element.readonly)) {
            if (/select-(one|multiple)/i.test(type)) {
                Ext.each(element.options, function(opt){
                    if (opt.selected) {
                        hasValue = opt.hasAttribute ? opt.hasAttribute('value') : opt.getAttributeNode('value').specified;
                        data += String.format("{0}={1}&", encoder(name), encoder(hasValue ? opt.value : opt.text));
                    }
                });
            } else if (!(/file|undefined|reset|button/i.test(type))) {
                //~ if (!(/radio|checkbox/i.test(type) && !element.checked) && !(type == 'submit' && hasSubmit)) {
                if (!(type == 'submit' && hasSubmit)) {
                    if (type == 'checkbox') {
                        //~ console.log('20111001',element,'data += ',encoder(name) + '=' + (element.checked ? 'on' : 'off') + '&');
                        data += encoder(name) + '=' + (element.checked ? 'on' : 'off') + '&';
                    } else {
                        //~ console.log('20111001',element,'data += ',encoder(name) + '=' + encoder(element.value) + '&');
                        data += encoder(name) + '=' + encoder(element.value) + '&';
                    }
                    hasSubmit = /submit/i.test(type);
                }
            }
        //~ } else {
            //~ console.log(name,type,element.readonly);
        }
    });
    return data.substr(0, data.length - 1);
};



/*
Set a long timeout of fifteen minutes. 
See /blog/2012/0307
*/
Ext.Ajax.timeout = 15 * 60 * 1000; 


/*
My fix for the "Cannot set QuickTips dismissDelay to 0" bug,
see http://www.sencha.com/forum/showthread.php?183515 
*/
Ext.override(Ext.QuickTip,{
  showAt : function(xy){
        var t = this.activeTarget;
        //~ console.log("20120224 QuickTip.showAt",this.title,this.dismissDelay,t.dismissDelay);
        if(t){
            if(!this.rendered){
                this.render(Ext.getBody());
                this.activeTarget = t;
            }
            if(t.width){
                this.setWidth(t.width);
                this.body.setWidth(this.adjustBodyWidth(t.width - this.getFrameWidth()));
                this.measureWidth = false;
            } else{
                this.measureWidth = true;
            }
            this.setTitle(t.title || '');
            this.body.update(t.text);
            this.autoHide = t.autoHide;
            // bugfix by Luc 20120226
            if (t.dismissDelay != undefined) this.dismissDelay = t.dismissDelay;
            //~ this.dismissDelay = t.dismissDelay || this.dismissDelay;
            if(this.lastCls){
                this.el.removeClass(this.lastCls);
                delete this.lastCls;
            }
            if(t.cls){
                this.el.addClass(t.cls);
                this.lastCls = t.cls;
            }
            if(this.anchor){
                this.constrainPosition = false;
            }else if(t.align){ 
                xy = this.el.getAlignToXY(t.el, t.align);
                this.constrainPosition = false;
            }else{
                this.constrainPosition = true;
            }
        }
        Ext.QuickTip.superclass.showAt.call(this, xy);
    }
});

/*
Another hack. See /docs/blog/2012/0228
*/
Ext.Element.addMethods(
    function() {
        var VISIBILITY      = "visibility",
            DISPLAY         = "display",
            HIDDEN          = "hidden",
            NONE            = "none",
            XMASKED         = "x-masked",
            XMASKEDRELATIVE = "x-masked-relative",
            data            = Ext.Element.data;

        return {
            
            mask : function(msg, msgCls) {
                var me  = this,
                    dom = me.dom,
                    dh  = Ext.DomHelper,
                    EXTELMASKMSG = "ext-el-mask-msg",
                    el,
                    mask;
                // removed the following lines. See /docs/blog/2012/0228
                //~ if (!(/^body/i.test(dom.tagName) && me.getStyle('position') == 'static')) {
                    //~ console.log(20120228,dom.tagName,me);
                    //~ me.addClass(XMASKEDRELATIVE); 
                //~ }
                if (el = data(dom, 'maskMsg')) {
                    el.remove();
                }
                if (el = data(dom, 'mask')) {
                    el.remove();
                }

                mask = dh.append(dom, {cls : "ext-el-mask"}, true);
                data(dom, 'mask', mask);

                me.addClass(XMASKED);
                mask.setDisplayed(true);
                
                if (typeof msg == 'string') {
                    var mm = dh.append(dom, {cls : EXTELMASKMSG, cn:{tag:'div'}}, true);
                    data(dom, 'maskMsg', mm);
                    mm.dom.className = msgCls ? EXTELMASKMSG + " " + msgCls : EXTELMASKMSG;
                    mm.dom.firstChild.innerHTML = msg;
                    mm.setDisplayed(true);
                    mm.center(me);
                }
                
                
                if (Ext.isIE && !(Ext.isIE7 && Ext.isStrict) && me.getStyle('height') == 'auto') {
                    mask.setSize(undefined, me.getHeight());
                }
                
                return mask;
            }

            
        };
    }()
);



Ext.namespace('Lino');
    
    

//~ Lino.subst_user_field = new Ext.form.ComboBox({});
//~ Lino.subst_user = null;
Lino.insert_subst_user = function(p){
    //~ console.log('20120714 insert_subst_user',Lino.subst_user,p);
    //~ if (Lino.subst_user_field.getValue()) {
    if (p.su) return;
    if (Lino.subst_user) {
        //~ p.su = Lino.subst_user_field.getValue();
        p.su = Lino.subst_user;
    //~ } else {
        //~ delete p.su;
    }
    //~ console.log('20120714 insert_subst_user -->',Lino.subst_user,p);
}

Lino.login_window = null;


Lino.show_login_window = function() {
  //~ console.log('20121103 show_login_window',arguments);
  //~ var current_window = Lino.current_window;
  if (Lino.login_window == null) {
    
      function do_login() { 
            Lino.viewport.loadMask.show()
            //~ Lino.body_loadMask.show()
            login_panel.getForm().submit({ 
                method:'POST', 
                waitTitle:'Connecting', 
                waitMsg:'Sending data...',
                success:function(){ 
                  //~ console.log('20121104 logged in',arguments);
                  Lino.login_window.hide();
                  Lino.close_all_windows();
                  Lino.viewport.loadMask.hide()
                  //~ Lino.body_loadMask.hide()
                },
                failure: function(form,action) { 
                  //~ this.loadMask.hide();
                  Lino.on_submit_failure(form,action);
                  Lino.viewport.loadMask.hide()
                  //~ Lino.body_loadMask.hide()
                  //~ if (Lino.current_window) Lino.current_window.main_item.loadMask.hide()
                }
                //~ failure:function(form, action){ 
                    //~ alert_msg
                    //~ if(action.failureType == 'server'){ 
                        //~ obj = Ext.util.JSON.decode(action.response.responseText); 
                        //~ Ext.Msg.alert('Login Failed!', obj.errors.reason); 
                    //~ }else{ 
                        //~ Ext.Msg.alert('Warning!', 'Authentication server is unreachable : ' + action.response.responseText); 
                    //~ } 
                    //~ Lino.login_panel.getForm().reset(); 
                //~ } 
            }); 
      };
    
      var login_button = new Ext.Button({ 
        text:"Log in",
        formBind: true,	 
        // Function that fires when user clicks the button 
        handler: do_login});
    
      var login_panel = new Ext.FormPanel({ 
        //~ inspired by http://www.sencha.com/learn/a-basic-login/
        autoHeight:true,
        labelWidth:90,
        url:'/auth', 
        frame:true, 
        defaultType:'textfield',
        monitorValid:true,
        items:[{ 
            fieldLabel:"Username", 
            id: 'username',
            name:'username', 
            autoHeight:true,
            allowBlank:false 
        },{ 
            fieldLabel:"Password", 
            name:'password', 
            inputType:'password', 
            autoHeight:true,
            allowBlank:false 
        }],        
        buttons:[ login_button ]});
        
      Lino.login_window = new Ext.Window({
          layout:'fit',
          defaultButton: 'username',
          width:300,
          title:"Log in", 
          autoHeight:true,
          modal: true,
          closeAction: "hide",
          keys: {
            key: Ext.EventObject.ENTER,
            fn: function() { do_login()}
          },
          //~ defaultButton: login_button,
          //~ height:'auto',
          //~ closable: false,
          //~ resizable: false,
          //~ plain: true,
          //~ border: false,
          items: [login_panel] });
  };
  Lino.login_window.show();
};

Lino.logout = function(id,name) {
    //~ console.log('20121104 gonna log out',arguments);
    //~ Lino.do_action
    Lino.call_ajax_action(Lino.viewport,'GET','/auth',{},'logout',undefined,undefined,function(){
        //~ console.log('20121104 logged out',arguments);
        //~ Lino.login_window.hide();
        Lino.close_all_windows();
    })
}

Lino.set_subst_user = function(id,name) {
    //~ console.log(20120714,'Lino.set_subst_user',id,name);
    Lino.subst_user = id;

    if(id) {
        Lino.eventStore.setBaseParam("su",id);
    } else {
      delete Lino.eventStore.baseParams['su'];
    }

    if (Lino.current_window) 
        Lino.current_window.main_item.set_base_param("su",id);
    if (Lino.viewport) Lino.permalink_handler(Lino.current_window)();
}



//~ Lino.select_subst_user = function(cmp,rec,value){
    //~ Lino.subst_user=value;
    //~ console.log(20120713,rec);
//~ }
    
Lino.current_window = null;
Lino.window_history = Array();
    
Lino.chars2width = function(cols) {  return cols * 9; }
Lino.rows2height = function(cols) {  return cols * 20; }



Lino.Viewport = Ext.extend(Ext.Viewport,{
  layout:"fit"
  ,initComponent : function(){
    Lino.Viewport.superclass.initComponent.call(this);
    this.on('render',function(){
      this.loadMask = new Ext.LoadMask(this.el,{msg:"Please wait..."});
      //~ console.log("20121118 Lino.viewport.loadMask",this.loadMask);
    },this);
  }
  ,get_base_params : function() { 
    var p = {};
    Lino.insert_subst_user(p);
    return p;
  }
  ,refresh : function() {
      var caller = this;
      console.log("20121120 Lino.Viewport.refresh()");
      if (caller.loadMask) caller.loadMask.show();
      var success = function(response) {
        if (caller.loadMask) caller.loadMask.hide();
        if (response.responseText) {
          var result = Ext.decode(response.responseText);
          //~ console.log('Lino.do_action()',action.name,'result is',result);
          if (result.html) {
              Ext.getCmp('main_area').update(result.html);
          }
          if (result.message) {
              if (result.alert) {
                  //~ Ext.MessageBox.alert('Alert',result.alert_msg);
                  Ext.MessageBox.alert('Alert',result.message);
              } else {
                  Lino.notify(result.message);
              }
          }
          
          if (result.notify_msg) Lino.notify(result.notify_msg);
          if (result.js_code) { 
            var jsr = result.js_code(caller);
            //~ console.log('Lino.do_action()',action,'returned from js_code in',result);
          };
        }
      };
      var action = {
        url : '/api/main_html',
        waitMsg: "Please wait...",
        failure: Lino.ajax_error_handler(caller),
        success: success,
        method: 'GET',
        params: {}
      };
      Lino.insert_subst_user(action.params);
      Ext.Ajax.request(action);
    
  }
});


Lino.open_window = function(win,st,requesting_panel) {
  //~ console.log("20120918 Lino.open_window()",win,st);
  var cw = Lino.current_window;
  if (cw) {
    //~ console.log("20120918 Lino.open_window() save current status",cw.main_item.get_status());
    Lino.window_history.push({
      window:cw,
      status:cw.main_item.get_status()
    });
  }
  Lino.current_window = win;
  //~ if (st.su) 
      //~ Lino.subst_user_field.setValue(st.su);
  win.main_item.set_status(st,requesting_panel);
  win.show();
};

Lino.load_url = function(url) {
    //~ foo.bar.baz = 2; 
    //~ console.log("20121120 Lino.load_url()");
    //~ Lino.body_loadMask.show();
    Lino.viewport.loadMask.show();
    //~ location.replace(url);
    document.location = url;
}

Lino.close_window = function(status_update) {
  var cw = Lino.current_window;
  var ww = Lino.window_history.pop();
  if (ww) {
    //~ if (status_update) Ext.apply(ww.status,status_update);
    if (status_update) status_update(ww);
    ww.window.main_item.set_status(ww.status);
    Lino.current_window = ww.window;
  } else {
    Lino.current_window = null;
  }
  if (cw) cw.hide_really();
};

Lino.close_all_windows = function() {
  if (Lino.window_history.length == 0) {
      //~ Lino.viewport.refresh();
      var url =  "/"
      //~ console.log("20121120 Lino.close_all_windows() : no window_history");
      //~ if (ADMIN_URL) 
      var p = {};
      Lino.insert_subst_user(p)
      if (Ext.urlEncode(p)) url = url + "?" + Ext.urlEncode(p);
      Lino.load_url(url);
  } else {
    //~ console.log("20121120 Lino.close_all_windows() with window_history");
    while (Lino.window_history.length > 0) {
      Lino.close_window();
      //~ Lino.window_history.pop().hide_really();
    }
  }
  //~ Lino.current_window = null;
  //~ Lino.close_window();
  //~ var ww = 
}

Lino.kill_current_window = function() {
  var cw = Lino.current_window;
  Lino.current_window = null;
  if (cw) cw.hide_really();
};

Lino.calling_window = function() {
    if (Lino.window_history.length) return Lino.window_history[Lino.window_history.length-1];
}

//~ Lino.WindowAction = function(mainItemClass,windowConfig,mainConfig,ppf) {
Lino.WindowAction = function(windowConfig,main_item_fn) {
    //~ if(!mainConfig) mainConfig = {};
    //~ mainConfig.is_main_window = true;
    this.windowConfig = windowConfig;
    this.main_item_fn = main_item_fn;
    //~ if (ppf) mainConfig.params_panel.fields = ppf;
    //~ this.mainConfig = mainConfig;
    //~ this.mainItemClass = mainItemClass;
};

Lino.WindowAction = Ext.extend(Lino.WindowAction,{
    window : null,
    //~ mainItemClass: null,
    get_window : function() {
      //~ if(mainConfig) Ext.apply(this.mainConfig,mainConfig);
      if (this.window == null)  {
          //~ this.windowConfig.main_item = new this.mainItemClass(this.mainConfig);
          this.windowConfig.main_item = this.main_item_fn();
          this.window = new Lino.Window(this.windowConfig);
      }
      return this.window;
    },
    run : function(requesting_panel,status) {
      //~ console.log('20120625 window_action.run()',this)
      Lino.open_window(this.get_window(),status,requesting_panel);
    }
  
});


Lino.PanelMixin = {
  get_containing_window : function (){
      if (this.containing_window) return this.containing_window;
      return this.containing_panel.get_containing_window();
  }
  ,set_window_title : function(title) {
    //~ this.setTitle(title);
    var cw = this.get_containing_window();

    //~ if (cw) {
    //~ if (cw && cw.closable) {
    if (cw && !cw.main_item.hide_window_title) {
      //~ console.log('20111202 set_window_title(',title,') for',this.containing_window);
      //~ if (! this.containing_window.rendered) console.log("WARNING: not rendered!");
      cw.setTitle(title);
    //~ } else {
      //~ document.title = title;
    }
    //~ else console.log('20111202 not set_window_title(',title,') for',this);
  }
  
};


Lino.status_bar = new Ext.ux.StatusBar({defaultText:'Lino version 1.6.7.'});



Lino.edit_tinymce_text = function(panel,options) {
  // `panel` is the RichTextPanel
  //~ console.log(20111220,panel);
  //~ var rec = panel.get_current_record();
  var rec = panel.containing_panel.get_current_record();
  var value = rec ? rec.data[panel.editor.name] : '';
  var saving = false;
  var todo_after_save = false;
  var discard_changes = false;
  
  
  function save() {
    //~ if (todo_after_save) {alert('tried to save again'); return; }
    if (saving) {alert('tried to save again'); return; }
    //~ var url = panel.containing_window.main_item.get_record_url(rec.id);
    var url = panel.containing_panel.get_record_url(rec.id);
    var params = Ext.apply({},panel.containing_panel.get_base_params());
    params[panel.editor.name] = editor.getValue();
    //~ params.su = Lino.subst_user;
    //~ Lino.insert_subst_user(params);
    var a = { 
      params: params, 
      method: 'PUT',
      url: url,
      failure: function() {
          //~ if (editor.ed.getContainer()) 
          editor.ed.setProgressState(0);
          todo_after_save = false;
          saving = false;
          console.log('tinymce.save() failed. sorry.',arguments);
        },
      success: function() {
        saving = false;
        //~ if (editor.ed.getContainer()) 
        editor.ed.setProgressState(0);
        rec.data[panel.editor.name] = editor.getValue();
        if(todo_after_save) {
            var fn = todo_after_save;
            todo_after_save = false;
            fn();
        }
        //~ panel.containing_window.set_current_record(rec);
        panel.refresh();
      }
    };
    //~ if (editor.ed.getContainer()) 
    editor.ed.setProgressState(1); // Show progress
    saving = true;
    //~ console.log(a);
    Ext.Ajax.request(a);
  };
  function save_callback() {
      save();
      //~ save(function(){editor.ed.setDirty(false);})
      /* return true have the save button disabled.  
      That's not perfect because the PUT is asynchronous 
      and the response is not yet known.
      */
      return true;
  }
  //~ var actions = [
    //~ {text:"Save",handler:save}
  //~ ]; 
  //~ console.log(20110610,panel.editor.disabled);
  var settings = {};
  Ext.apply(settings,{
        readonly: panel.editor.disabled,
        //~ language: "de",
        plugins : "save,emotions,spellchecker,advhr,insertdatetime,preview,table,searchreplace,template", 
        // Theme options - button# indicated the row# only
        theme_advanced_buttons1 : "save,cancel,|,bold,italic,underline,|,justifyleft,justifycenter,justifyright,fontselect,fontsizeselect,formatselect,|,search,replace",
        theme_advanced_buttons2 : "cut,copy,paste,template,|,bullist,numlist,|,outdent,indent,|,undo,redo,|,link,unlink,anchor,image,|,code,preview,|,forecolor,backcolor",
        theme_advanced_buttons3 : "insertdate,inserttime,|,spellchecker,advhr,,removeformat,|,sub,sup,|,charmap,emotions,|,tablecontrols",      
        theme_advanced_resizing : false,
        convert_urls : false,
        save_onsavecallback : save_callback,
        save_enablewhendirty : true
        //~ save_oncancelcallback: on_cancel
  });
  Ext.apply(settings,options);
  var editor = new Ext.ux.TinyMCE({
      value : value,
      tinymceSettings: settings
    });
  var win = new Ext.Window({
    title: rec.title, 
    //~ bbar: actions,
    layout: 'fit',
    items: editor,
    width: 600, 
    height:500,
    minWidth: 100,
		minHeight: 100,
    modal: true,
    resizable: true,
    maximizable: true,
    //~ maximized: true,
    //~ closeAction: "close"
    closeAction: "hide"
    //~ hideMode: "offsets",
    //~ constrainHeader: true,
    //~ bodyStyle: 'padding: 10px'
  });

  //~ win.on('beforeclose',function() {
  win.on('beforehide',function() {
    if (todo_after_save) return false;
    if (discard_changes) return true;
    if (editor.isDirty()) {
        //~ var ok = false;
        //~ var allowClose = true;
        var config = {title:"Confirmation"};
        config.buttons = Ext.MessageBox.YESNOCANCEL;
        config.msg = "Save changes to text ?";
        config.modal = true;
        config.fn = function(buttonId,text,opt) {
          //~ console.log('do_when_clean',buttonId)
          if (buttonId == "yes") {
              /* we cancel this close, but save()'s onSuccess will call again.*/
              //~ allowClose = false;
              todo_after_save = function(){win.hide();}
              editor.ed.execCommand('mceSave');
              //~ editor.ed.save(function(){win.close();});
          } else if (buttonId == "no") { 
              discard_changes = true;
              win.hide()
          //~ } else if (buttonId == "cancel") { 
            //~ ok = true;
              //~ allowClose = false;
          //~ } else { 
            //~ console.log('unknwon buttonId:',buttonId);
          }
        }
        Ext.MessageBox.show(config);
        return false;
        //~ return allowClose;
    }
  });
  win.show();
}







/* 
  Originally copied from Ext JS Library 3.3.1
  Modifications by Luc Saffre : 
  - rendering of phantom records
  - fire afteredit event
  - react on dblclcik, not on single click

 */
Lino.CheckColumn = Ext.extend(Ext.grid.Column, {

    processEvent : function(name, e, grid, rowIndex, colIndex){
        //~ console.log('20110713 Lino.CheckColumn.processEvent',name)
        if (name == 'click') {
        //~ if (name == 'mousedown') {
        //~ if (name == 'dblclick') {
            return this.toggleValue(grid, rowIndex, colIndex);
        } else {
            return Ext.grid.ActionColumn.superclass.processEvent.apply(this, arguments);
        }
    },
    
    toggleValue : function (grid,rowIndex,colIndex) {
        var record = grid.store.getAt(rowIndex);
        var dataIndex = grid.colModel.getDataIndex(colIndex);
        // 20120514
        //~ if(record.data.disabled_fields && record.data.disabled_fields[dataIndex]) {
          //~ Lino.notify("This field is disabled");
          //~ return false;
        //~ }
      
        //~ if (dataIndex in record.data['disabled_fields']) {
            //~ Lino.notify("This field is disabled.");
            //~ return false;
        //~ }
        var startValue = record.data[dataIndex];
        var value = !startValue;
        //~ record.set(this.dataIndex, value);
        var e = {
            grid: grid,
            record: record,
            field: dataIndex,
            originalValue: startValue,
            value: value,
            row: rowIndex,
            column: colIndex,
            cancel: false
        };
        if(grid.fireEvent("beforeedit", e) !== false && !e.cancel){
        //~ if(grid.fireEvent("validateedit", e) !== false && !e.cancel){
            record.set(dataIndex, value);
            delete e.cancel;
            grid.fireEvent("afteredit", e);
        }
        return false; // Cancel event propagation
    },

    renderer : function(v, p, record){
        if (record.phantom) return '';
        p.css += ' x-grid3-check-col-td'; 
        return String.format('<div class="x-grid3-check-col{0}">&#160;</div>', v ? '-on' : '');
    }

    // Deprecate use as a plugin. Remove in 4.0
    // init: Ext.emptyFn
});

// register ptype. Deprecate. Remove in 4.0
// Ext.preg('checkcolumn', Lino.CheckColumn);

// backwards compat. Remove in 4.0
// Ext.grid.CheckColumn = Lino.CheckColumn;

// register Column xtype
Ext.grid.Column.types.checkcolumn = Lino.CheckColumn;


/* 20110725 : 
Lino.on_tab_activate is necessary 
in contacts.Person.2.dtl 
(but don't ask me why...)
*/
Lino.on_tab_activate = function(item) {
  //~ console.log('activate',item); 
  if (item.rendered && item.doLayout) item.doLayout();
  //~ if (item.rendered) item.doLayout();
}

Lino.TimeField = Ext.extend(Ext.form.TimeField,{
  format: 'H:i',
  increment: 15
  });
Lino.DateField = Ext.extend(Ext.form.DateField,{
  boxMinWidth: Lino.chars2width(11),
  format: 'd.m.Y',
  altFormats: 'd/m/Y|Y-m-d'
  });
Lino.DatePickerField = Ext.extend(Ext.DatePicker,{
  //~ boxMinWidth: Lino.chars2width(11),
  format: 'd.m.Y',
  //~ altFormats: 'd/m/Y|Y-m-d'
  formatDate : function(date){
      console.log("20121203 formatDate",this.name,date);
      return Ext.isDate(date) ? date.dateFormat(this.format) : date;
  }
  });
Lino.DateTimeField = Ext.extend(Ext.ux.form.DateTime,{
  dateFormat: 'd.m.Y',
  timeFormat: 'H:i',
  //~ hiddenFormat: 'd.m.Y H:i'
  });
Lino.URLField = Ext.extend(Ext.form.TriggerField,{
  triggerClass : 'x-form-search-trigger',
  //~ triggerClass : 'x-form-world-trigger',
  vtype: 'url',
  onTriggerClick : function() {
    //~ console.log('Lino.URLField.onTriggerClick',this.value)
    //~ document.location = this.value;
    window.open(this.getValue(),'_blank');
  }
});
Lino.IncompleteDateField = Ext.extend(Ext.form.TextField,{
  //~ regex: /^-?\d+-[01]\d-[0123]\d$/,
  //~ regex: /^[0123]\d\.[01]\d\.-?\d+$/,
  maxLength: 10,
  boxMinWidth: Lino.chars2width(10),
  regex: /^[0123]?\d\.[01]?\d\.-?\d+$/,
  regexText: 'Enter a date in format YYYY-MM-DD (use zeroes for unknown parts).'
  });


//~ Lino.make_dropzone = function(cmp) {
    //~ cmp.on('render', function(ct, position){
      //~ ct.el.on({
        //~ dragenter:function(event){
          //~ event.browserEvent.dataTransfer.dropEffect = 'move';
          //~ return true;
        //~ }
        //~ ,dragover:function(event){
          //~ event.browserEvent.dataTransfer.dropEffect = 'move';
          //~ event.stopEvent();
          //~ return true;
        //~ }
        //~ ,drop:{
          //~ scope:this
          //~ ,fn:function(event){
            //~ event.stopEvent();
            //~ console.log(20110516);
            //~ var files = event.browserEvent.dataTransfer.files;
            //~ if(files === undefined){
              //~ return true;
            //~ }
            //~ var len = files.length;
            //~ while(--len >= 0){
              //~ console.log(files[len]);
              //~ // this.processDragAndDropFileUpload(files[len]);
            //~ }
          //~ }
        //~ }
      //~ });
    //~ });
//~ };

//~ Lino.FileUploadField = Ext.ux.form.FileUploadField;

Lino.FileUploadField = Ext.extend(Ext.ux.form.FileUploadField,{
    onRender : function(ct, position){
      Lino.FileUploadField.superclass.onRender.call(this, ct, position);
      this.el.on({
        dragenter:function(event){
          event.browserEvent.dataTransfer.dropEffect = 'move';
          return true;
        }
        ,dragover:function(event){
          event.browserEvent.dataTransfer.dropEffect = 'move';
          event.stopEvent();
          return true;
        }
        ,drop:{
          scope:this
          ,fn:function(event){
            event.stopEvent();
            //~ console.log(20110516);
            var files = event.browserEvent.dataTransfer.files;
            if(files === undefined){
              return true;
            }
            var len = files.length;
            while(--len >= 0){
              console.log(files[len]);
              //~ this.processDragAndDropFileUpload(files[len]);
            }
          }
        }
      });
    }
});

Lino.FileField = Ext.extend(Ext.form.TriggerField,{
  triggerClass : 'x-form-search-trigger',
  editable: false,
  onTriggerClick : function() {
    //~ console.log('Lino.URLField.onTriggerClick',this.value)
    //~ document.location = this.value;
    if (this.getValue()) window.open(MEDIA_URL + '/'+this.getValue(),'_blank');
  }
});

Lino.file_field_handler = function(panel,config) {
  //~ if (instanceof Lino.DetailWrapper) {
  if (panel.action_name == 'insert') {
  //~ if (panel.get_current_record().phantom) {
      panel.has_file_upload = true;

      var f = new Lino.FileUploadField(config);
      //~ Lino.make_dropzone(f);
      return f;
      //~ return new Ext.ux.form.FileUploadField(config);
      //~ return new Lino.FileField(config);
      
  } else {
      //~ return new Lino.URLField(config);
      return new Lino.FileField(config);
  }
}

Lino.VBorderPanel = Ext.extend(Ext.Panel,{
    constructor : function(config) {
      config.layout = 'border';
      delete config.layoutConfig;
      Lino.VBorderPanel.superclass.constructor.call(this,config);
      for(var i=0; i < this.items.length;i++) {
        var item = this.items.get(i);
        if (this.isVertical(item) && item.collapsible) {
          item.on('collapse',this.onBodyResize,this);
          item.on('expand',this.onBodyResize,this);
        }
      }
    },
    isVertical : function(item) {
       return (item.region == 'north' || item.region == 'south' || item.region == 'center');
    },
    onBodyResize: function(w, h){
        //~ console.log('VBorderPanel.onBodyResize',this.title)
      if (this.isVisible()) { // to avoid "Uncaught TypeError: Cannot call method 'getHeight' of undefined."
        var sumflex = 0;
        var availableHeight = this.getInnerHeight();
        var me = this;
        this.items.each(function(item){
          if (me.isVertical(item)) {
              if (item.collapsed || item.flex == 0 || item.flex === undefined) {
                  if (item.rendered) availableHeight -= item.getHeight();
              } else {
                  sumflex += item.flex;
              }
          } 
          
        });
        //~ for(var i=0; i < this.items.length;i++) {
          //~ var item = this.items.get(i);
          //~ // if (this.isVertical(item) && item.getResizeEl()) {
          //~ if (this.isVertical(item)) {
              //~ if (item.collapsed || item.flex == 0 || item.flex === undefined) {
                  //~ // item.syncSize()
                  //~ // item.doLayout()
                  //~ // if (item.region == "north") console.log('region north',item.getHeight(),item.id, item);
                  //~ // if (item.getHeight() == 0) console.log(20100921,'both flex and getHeight() are 0!');
                  //~ availableHeight -= item.getHeight();
              //~ } else {
                  //~ sumflex += item.flex;
                  //~ // console.log(item.flex);
              //~ }
          //~ } 
          //~ // else console.log('non-vertical item in VBoderPanel:',item)
        //~ }
        var hunit = availableHeight / sumflex;
        //~ console.log('sumflex=',sumflex,'hunit=',hunit, 'availableHeight=',availableHeight);
        for(var i=0; i < this.items.length;i++) {
          var item = this.items.get(i);
          if (this.isVertical(item)) {
              if (item.flex != 0 && ! item.collapsed) {
                  item.setHeight(hunit * item.flex);
                  //~ console.log(item.region,' : height set to',item.getHeight());
              }
          }
          //~ else console.log('non-vertical item in VBoderPanel:',item)
        }
      }
      Lino.VBorderPanel.superclass.onBodyResize.call(this, w, h);
    }
});


/*
  modifications to the standard behaviour of a CellSelectionModel:
  
*/
Ext.override(Ext.grid.CellSelectionModel, {
//~ var dummy = {

    handleKeyDown : function(e){
        /* removed because F2 wouldn't pass
        if(!e.isNavKeyPress()){
            return;
        }
        */
        //~ console.log('handleKeyDown',e)
        var k = e.getKey(),
            g = this.grid,
            s = this.selection,
            sm = this,
            walk = function(row, col, step){
                return g.walkCells(
                    row,
                    col,
                    step,
                    g.isEditor && g.editing ? sm.acceptsNav : sm.isSelectable, 
                    sm
                );
            },
            cell, newCell, r, c, ae;

        switch(k){
            case e.ESC:
            case e.PAGE_UP:
            case e.PAGE_DOWN:
                break;
            default:
                // e.stopEvent(); // removed because Browser keys like Alt-Home, Ctrl-R wouldn't work
                break;
        }

        if(!s){
            cell = walk(0, 0, 1); 
            if(cell){
                this.select(cell[0], cell[1]);
            }
            return;
        }

        cell = s.cell;  
        r = cell[0];    
        c = cell[1];    
        
        switch(k){
            case e.TAB:
                if(e.shiftKey){
                    newCell = walk(r, c - 1, -1);
                }else{
                    newCell = walk(r, c + 1, 1);
                }
                break;
            case e.HOME:
                if (! (g.isEditor && g.editing)) {
                  if (!e.hasModifier()){
                      newCell = [r, 0];
                      //~ console.log('home',newCell);
                      break;
                  }else if(e.ctrlKey){
                      var t = g.getTopToolbar();
                      var activePage = Math.ceil((t.cursor + t.pageSize) / t.pageSize);
                      if (activePage > 1) {
                          e.stopEvent();
                          t.moveFirst();
                          return;
                      }
                      newCell = [0, c];
                      break;
                  }
                }
            case e.END:
                if (! (g.isEditor && g.editing)) {
                  c = g.colModel.getColumnCount()-1;
                  if (!e.hasModifier()) {
                      newCell = [r, c];
                      //~ console.log('end',newCell);
                      break;
                  }else if(e.ctrlKey){
                      var t = g.getTopToolbar();
                      var d = t.getPageData();
                      if (d.activePage < d.pages) {
                          e.stopEvent();
                          var self = this;
                          t.on('change',function(tb,pageData) {
                              var r = g.store.getCount()-2;
                              self.select(r, c);
                              //~ console.log('change',r,c);
                          },this,{single:true});
                          t.moveLast();
                          return;
                      } else {
                          newCell = [g.store.getCount()-1, c];
                          //~ console.log('ctrl-end',newCell);
                          break;
                      }
                  }
                }
            case e.DOWN:
                newCell = walk(r + 1, c, 1);
                break;
            case e.UP:
                newCell = walk(r - 1, c, -1);
                break;
            case e.RIGHT:
                newCell = walk(r, c + 1, 1);
                break;
            case e.LEFT:
                newCell = walk(r, c - 1, -1);
                break;
            case e.F2:
                if (!e.hasModifier()) {
                    if (g.isEditor && !g.editing) {
                        g.startEditing(r, c);
                        e.stopEvent();
                        return;
                    }
                    break;
                }
            case e.INSERT:
                if (!e.hasModifier()) {
                    if (g.ls_insert_handler && !g.editing) {
                        e.stopEvent();
                        Lino.show_insert(g);
                        return;
                    }
                    break;
                }
            case e.DELETE:
                if (!e.hasModifier()) {
                    if (!g.editing) {
                        e.stopEvent();
                        Lino.delete_selected(g);
                        return;
                    }
                    break;
                }
            case e.ENTER:
                e.stopEvent();
                g.onCellDblClick(r,c);
                break;
                
        }
        

        if(newCell){
          e.stopEvent();
          r = newCell[0];
          c = newCell[1];
          this.select(r, c); 
          if(g.isEditor && g.editing){ 
            ae = g.activeEditor;
            if(ae && ae.field.triggerBlur){
                ae.field.triggerBlur();
            }
            g.startEditing(r, c);
          }
        //~ } else if (g.isEditor && !g.editing && e.charCode) {
        //~ // } else if (!e.isSpecialKey() && g.isEditor && !g.editing) {
            //~ g.set_start_value(String.fromCharCode(e.charCode));
            //~ // g.set_start_value(String.fromCharCode(k));
            //~ // g.set_start_value(e.charCode);
            //~ g.startEditing(r, c);
            //~ // e.stopEvent();
            //~ return;
        // } else {
          // console.log('20120513',e,g);
        }
        
    }


//~ };
});

 

function PseudoConsole() {
    this.log = function() {};
};
if (typeof(console) == 'undefined') console = new PseudoConsole();

Lino.notify = function(msg) {
  if (msg == undefined) msg = ''; else console.log(msg);
  //~ Ext.getCmp('konsole').update(msg);
  Lino.status_bar.setStatus({
    text: msg,
    iconCls: 'ok-icon',
    clear: true // auto-clear after a set interval
  });
  //~ Ext.getCmp('konsole').setTitle(msg.replace(/\n/g,'<br/>'));
  //~ Ext.getCmp('konsole').update(msg.replace(/\n/g,'<br/>'));
};
Lino.alert = function(msg) {
  //~ if (msg == undefined) msg = ''; else console.log(msg);
  Ext.MessageBox.alert('Notify',msg);
};


//~ Lino.show_about = function() {
  //~ new Ext.Window({
    //~ width: 400, height: 400,
    //~ title: "About",
    //~ html: '<a href="http://www.extjs.com" target="_blank">ExtJS</a> version ' + Ext.version
  //~ }).show();
//~ };

function obj2str(o) {
  if (typeof o != 'object') return String(o);
  var s = '';
  for (var p in o) {
    s += p + ': ' + obj2str(o[p]) + '\n';
  }
  return s;
}

Lino.on_store_exception = function (store,type,action,options,response,arg) {
  //~ throw response;
  console.log("on_store_exception: store=",store,
    "type=",type,
    "action=",action,
    "options=",options,
    "response=",response,
    "arg=",arg);
  if (arg) { console.log(arg.stack)};
};

//~ Lino.on_submit_success = function(form, action) {
   //~ Lino.notify(action.result.message);
   //~ this.close();
//~ };

Lino.on_submit_failure = function(form, action) {
    //~ Lino.notify();
  // action may be undefined
    switch (action.failureType) {
        case Ext.form.Action.CLIENT_INVALID:
            Ext.Msg.alert('Client-side failure', 'Form fields may not be submitted with invalid values');
            break;
        case Ext.form.Action.CONNECT_FAILURE:
            Ext.Msg.alert('Connection failure', 'Ajax communication failed');
            break;
        case Ext.form.Action.SERVER_INVALID:
            Ext.Msg.alert('Server-side failure', action.result.message);
   }
};



/*
Lino.save_wc_handler = function(ww) {
  return function(event,toolEl,panel,tc) {
    var pos = panel.getPosition();
    var size = panel.getSize();
    wc = ww.get_window_config();
    Ext.applyIf(wc,{ 
      x:pos[0],y:pos[1],height:size.height,width:size.width,
      maximized:panel.maximized});
    Lino.do_action(ww,{url:'/window_configs/'+ww.config.permalink_name,params:wc,method:'POST'});
  }
};

*/

Lino.show_in_own_window_button = function(handler) {
  return {
    qtip: "Show this panel in own window", 
    id: "up",
    handler: function(event,toolEl,panel, tc) {
      //~ console.log('20111206 report_window_button',panel,handler);
      //~ var bp = ww.get_master_params();
      //~ panel.containing_window = ww; // for HtmlBox. see blog/2010/1022
      //~ handler(panel,{base_params:bp});
      //~ handler(panel,{base_params:panel.get_master_params()});
      handler.run(null,{base_params:panel.containing_panel.get_master_params()});
      //~ handler(panel,{master_panel:panel.containing_window.main_item});
    }
  }
}




Lino.delete_selected = function(panel) {
  //~ console.log("Lino.delete_selected",panel);
  var recs1 = panel.get_selected();
  var recs = [];
  for ( var i=0; i < recs1.length; i++ ) { if (! recs1[i].phantom) recs.push(recs1[i]); }
  if (recs.length == 0) {
    Lino.notify("Please select at least one record.");
    return;
  };
  if (recs.length == 1) {
      if (recs[0].disable_delete) {
        Lino.alert(recs[0].disable_delete);
        return;
      }
  };
  //~ console.log(recs);
  Ext.MessageBox.show({
    title: "Confirmation",
    msg: String.format("Delete {0} rows. Are you sure?",String(recs.length)),
    //~ msg: "Delete " + String(recs.length) + " rows. Are you sure?",
    //~ buttons: Ext.MessageBox.YESNOCANCEL,
    buttons: Ext.MessageBox.YESNO,
    fn: function(btn) {
      if (btn == 'yes') {
        for ( var i=0; i < recs.length; i++ ) {
          Lino.do_action(panel,{
              method:'DELETE',
              url:  '/api' + panel.ls_url + '/' + recs[i].id,
              after_success: panel.after_delete.createDelegate(panel)
          })
        }
        //~ caller.after_delete();
      }
      else Lino.notify("Dann eben nicht.");
    }
  });
};

Lino.action_handler = function (panel,on_success,on_confirm) {
  return function (response) {
    //~ console.log(20120608,panel);
    if (panel instanceof Lino.GridPanel) {
        //~ gridmode = false;
        gridmode = true;
        //~ console.log('20120608 yes');
    } else {
        gridmode = false;
        //~ console.log('20120608 no');
    }
    panel.loadMask.hide(); // 20120211
    if (!response.responseText) return ;
    var result = Ext.decode(response.responseText);
    //~ console.log('Lino.action_handler()','result is',result,'on_confirm is',on_confirm);
    
    if (result.eval_js) {
        //~ console.log(20120618,result.eval_js);
        eval(result.eval_js);
    }
    
    if (result.xcallback) {
        //~ var config = {title:"Confirmation"};
        var config = {title:result.xcallback.title};
        //~ config.buttons = Ext.MessageBox.YESNOCANCEL;
        //~ config.buttons = Ext.MessageBox.YESNO;
        config.buttons = result.xcallback.buttons;
        config.msg = result.message;
        config.fn = function(buttonId,text,opt) {
          panel.loadMask.show(); 
          //~ Lino.insert_subst_user(p);
          Ext.Ajax.request({
            method: 'GET',
            url: '/callbacks/'+result.xcallback.id + '/' + buttonId,
            //~ params: {bi: buttonId},
            success: Lino.action_handler(panel,on_success,on_confirm)
          });
          //~ Lino.call_ajax_action(panel,'GET',)
        }
        Ext.MessageBox.show(config);
        return;
    }
    
    if (on_success && result.success) on_success(result);
    
    //~ if (on_confirm && result.confirm_message) {
        //~ var config = {title:"Confirmation"};
        //~ // config.buttons = Ext.MessageBox.YESNOCANCEL;
        //~ config.buttons = Ext.MessageBox.YESNO;
        //~ config.msg = result.confirm_message;
        //~ config.fn = function(buttonId,text,opt) {
          //~ if (buttonId == "yes") {
              //~ on_confirm(panel,undefined,result.step);
          //~ }
        //~ }
        //~ Ext.MessageBox.show(config);
        //~ return;
    //~ }
    //~ if (result.dialog_fn) {
        //~ console.log('20120928 TODO',result.dialog_fn);
    //~ }
    if (result.message) {
        //~ if (result.alert && ! gridmode) {
        if (result.alert) { // 20120628b 
            //~ Ext.MessageBox.alert('Alert',result.alert_msg);
            if (result.alert === true) result.alert = "Alert";
            Ext.MessageBox.alert(result.alert,result.message);
        } else {
            Lino.notify(result.message);
        }
    }
    // 
    if (result.data_record && ! gridmode) {
        //~ not used
        panel.set_status({data_record:result.data_record});
    }
    else if (result.new_status && ! gridmode) {
        //~ not used
        //~ console.log('20120607 new_status');
        panel.set_status(result.new_status);
    }
    else if (result.goto_record_id != undefined && ! gridmode) {
        //~ console.log('20120607 new_status');
        panel.load_record_id(result.goto_record_id);
    }
    else if (result.refresh_all) {
        var cw = panel.get_containing_window();
        //~ console.log("20120123 refresh_all");
        if (cw) {
          cw.main_item.refresh();
        }
        else console.log("20120123 cannot refresh_all",panel);
    } else {
        //~ console.log("20121212 b gonna refresh",panel);
        if (result.refresh) panel.refresh();
    }
    
    if (result.open_url) {
        //~ console.log(20111126,result.open_url);
        //~ if (!result.message)
            //~ Lino.notify('Open new window <a href="'+result.open_url+'" target="_blank">'+result.open_url+'</a>');
        window.open(result.open_url,'foo',"");
        //~ document.location = result.open_url;
    }
  }
};

Lino.do_action = function(caller,action) {
  action.success = function(response) {
    if (caller.loadMask) caller.loadMask.hide();
    //~ console.log('Lino.do_action()',action,'action success',response);
    if (action.after_success) {
        //~ console.log('Lino.do_action() calling after_success');
        action.after_success();
    }
    if (response.responseText) {
      var result = Ext.decode(response.responseText);
      //~ console.log('Lino.do_action()',action.name,'result is',result);
      if (result.message) {
          if (result.alert) {
              //~ Ext.MessageBox.alert('Alert',result.alert_msg);
              Ext.MessageBox.alert('Alert',result.message);
          } else {
              Lino.notify(result.message);
          }
      }
      
      //~ if (result.alert_msg) Ext.MessageBox.alert('Alert',result.alert_msg);
      //~ if (result.message) Lino.notify(result.message);
      if (result.notify_msg) Lino.notify(result.notify_msg);
      if (result.js_code) { 
        //~ console.log('Lino.do_action()',action,'gonna call js_code in',result);
        var jsr = result.js_code(caller);
        //~ console.log('Lino.do_action()',action,'returned from js_code in',result);
        if (action.after_js_code) {
          //~ console.log('Lino.do_action()',action,'gonna call after_js_code');
          action.after_js_code(jsr);
          //~ console.log('Lino.do_action()',action,'returned from after_js_code');
        //~ } else {
          //~ console.log('Lino.do_action()',action,' : after_js_code is false');
        }
      };
    }
  };
  Ext.applyIf(action,{
    waitMsg: "Please wait...",
    failure: Lino.ajax_error_handler(caller),
    params: {}
  });
  //~ action.params.su = Lino.subst_user;
  Lino.insert_subst_user(action.params);
  
  Ext.Ajax.request(action);
};

//~ Lino.gup = function( name )
//~ {
  //~ // Thanks to http://www.netlobo.com/url_query_string_javascript.html
  //~ name = name.replace(/[\[]/,"\\\[").replace(/[\]]/,"\\\]");
  //~ var regexS = "[\\?&]"+name+"=([^&#]*)";
  //~ var regex = new RegExp( regexS );
  //~ var results = regex.exec( window.location.href );
  //~ if( results == null )
    //~ return "";
  //~ else
    //~ return results[1];
//~ };

//~ Lino.refresh_handler = function (ww) {
  //~ return function() { 
      //~ console.log('refresh',ww);
      //~ ww.main_item.doLayout(false,true);
      //~ ww.main_item.syncSize();
  //~ }
//~ };

//~ Lino.tools_close_handler = function (ww) {
  //~ return function() { 
      //~ ww.close();
  //~ }
//~ };
Lino.permalink_handler = function (ww) {
  return function() { 
    //~ console.log(20100923,ww.get_permalink());
    //~ document.location = ww.main_item.get_permalink();
    Lino.load_url(ww.main_item.get_permalink());
    //~ console.log(20120715, ww.main_item.get_permalink());
    //~ document.location = "?permalink=" + ww.get_permalink();
    //~ document.location = "?permalink=" + ww.config.permalink_name +'()';
  }
};
//~ Lino.run_permalink = function() {
  //~ var plink = Lino.gup('permalink');
  //~ if(plink) { eval('Lino.'+plink); }
//~ }

Lino.MainPanel = {
  is_home_page : false,
  setting_param_values : false,
  config_containing_window : function(wincfg) { }
  ,init_containing_window : function(win) { }
  ,is_loading : function() { 
      if (!this.rendered) return true;
      //~ return (Ext.select('.x-loading-msg').elements.length > 0);
      return true; 
    } 
  ,do_when_clean : function(auto_save,todo) { todo() }
  ,get_master_params : function() {
    var p = {}
    p['mt'] = this.content_type; 
    rec = this.get_current_record()
    if (rec) {
      if (rec.phantom) {
          p['mk'] = undefined; 
      }else{
          p['mk'] = rec.id; 
      }
    } else {
      p['mk'] = undefined;
    }
    //~ console.log('get_master_params returns',p,'using record',rec);
    return p;
  }
  ,get_permalink : function() {
    //~ var p = this.main_item.get_base_params() || {};
    var p = Ext.apply({},this.get_base_params());
    delete p.fmt;
    //~ if (p.fmt) delete p.fmt;
    Ext.apply(p,this.get_permalink_params());
    //~ Lino.insert_subst_user(p);
     //~ p.fmt = 'html';
    //~ console.log('get_permalink',p,this.get_permalink_params());
    if (this.is_home_page)
        //~ var url = '';
        var url = '/';
    else 
        var url = this.get_permalink_url();
    if (p.su == null) 
        delete p.su;
    if (Ext.urlEncode(p)) url = url + "?" + Ext.urlEncode(p);
    return url;
  }
  ,get_record_url : function(record_id) {
      var url = '/api' + this.ls_url
      //~ var url = this.containing_window.config.url_data; // ls_url;
      url += '/' + (record_id === undefined ? '-99999' : String(record_id));
      //~ if (record_id !== undefined) url += '/' + String(record_id);
      //~ url += '/' + String(record_id);
      return url;
  }
  ,get_permalink_url : function() {
      return '/api' + this.ls_url;
  }
  ,get_permalink_params : function() {
      //~ return {an:'grid'};
      var p = {};
      if (this.action_name)
          p.an = this.action_name;
      this.add_param_values(p)
      return p;
  }
  ,set_status : function(status) {}
  ,get_status : function() { return {}}
  ,refresh : function() {}
  ,get_base_params : function() { 
    var p = {};
    Lino.insert_subst_user(p);
    return p;
  }
  ,add_params_panel : function (tbar) {
      if (this.params_panel) {
        tbar = tbar.concat([{ scope:this, 
          //~ text: "$_("[parameters]")", // gear
          iconCls: 'x-tbar-parameters',
          tooltip:"Show or hide the table parameters panel",
          enableToggle: true,
          //~ pressed: ! this.params_panel.hidden,
          pressed: ! this.params_panel_hidden,
          toggleHandler: function(btn,state) { 
            //~ if (this.params_panel.isVisible()) 
                //~ this.params_panel.hide();
            //~ else
                //~ this.params_panel.show();
            //~ console.log("20120210 add_params_panel",state,this.params_panel);
            if (state) {
              this.params_panel.show();
              this.params_panel.doLayout();
            } else this.params_panel.hide();
            this.get_containing_window().doLayout();
          }
        }]);
        var t = this;
        var refresh = function() {if (!t.setting_param_values) t.refresh();}
        Ext.each(this.params_panel.fields,function(f) {
          //~ f.on('valid',function() {t.refresh()});
          if (f instanceof Ext.form.Checkbox) {
              f.on('check',refresh);
          } else if (f instanceof Ext.DatePicker) {
              f.on('select',refresh);
          } else if (f instanceof Ext.form.TriggerField) {
              f.on('select',refresh);
              //~ f.on('change',refresh);
              //~ f.on('valid',refresh);
          } else {
              if (! f.on) 
                  console.log("20121010 no method 'on'",f);
              else
                  f.on('change',refresh);
            }
          });
      }
      return tbar;
  }
  ,add_param_values : function (p) {
    if (this.params_panel) {
      /* 
      20120918 add param_values to the request string 
      *only if the params_form is dirty*.
      Otherwise Actor.default_params() would never be used.
      
      20121023 But IntegClients.params_default has non-empty default values. 
      Users must have the possibility to make them empty.
      */
      if (this.params_panel.form.isDirty()) {
        p.pv = this.get_param_values();
      }else{
        if (this.status_param_values) 
          p.pv = Lino.fields2array(
            this.params_panel.fields,this.status_param_values);
      }
      //~ if (!this.params_panel.form.isDirty()) return;
      //~ p.pv = this.get_param_values();
      //~ console.log("20120203 add_param_values added pv",pv,"to",p);
    }
  },
  get_param_values : function() { // similar to get_field_values()
      return Lino.fields2array(this.params_panel.fields);
  },
  set_param_values : function(pv) {
    if (this.params_panel) {
      //~ console.log('20120203 MainPanel.set_param_values', pv);
      this.status_param_values = pv;
      //~ this.params_panel.form.suspendEvents(false);
      this.setting_param_values = true;
      if (pv) { 
          this.params_panel.form.my_loadRecord(pv);
      } else { 
        this.params_panel.form.reset(); 
      }
      this.setting_param_values = false;
      //~ this.params_panel.form.resumeEvents();
    }
  }
};


Lino.ajax_error_handler = function(panel) {
  return function(response,options) {
    console.log('Ajax failure:',response,options);
    if (panel.loadMask) panel.loadMask.hide();
    if (response.responseText) {
      var lines = response.responseText.split('\n');
      if (lines.length > 10) {
          line = lines.splice(5,lines.length-10,"(...)");
      }
      Ext.MessageBox.alert(
        response.statusText,
        lines.join('<br/>')
        //~ response.responseText.replace(/\n/g,'<br/>'))
      )
    } else {
      Ext.MessageBox.alert('Action failed',
        'Lino server did not respond to Ajax request');
    }
  }
}
// Ext.Ajax.on('requestexception',Lino.ajax_error_handler)
 


Ext.QuickTips.init();

/* setting QuickTips dismissDelay to 0 */
// Apply a set of config properties to the singleton
//~ Ext.apply(Ext.QuickTips.getQuickTip(), {
//~ Ext.apply(Ext.ToolTip, {
    //~ dismissDelay: 0
    //~ autoHide: false,
    //~ closable: true,
    //~ maxWidth: 200,
    //~ minWidth: 100,
    //~ showDelay: 50      // Show 50ms after entering target
    //~ ,trackMouse: true
//~ });


//~ Ext.apply(Ext.QuickTip, {
    //~ dismissDelay: 0,
//~ });
  
Lino.quicktip_renderer = function(title,body) {
  return function(c) {
    //~ if (c instanceof Ext.Panel) var t = c.bwrap; else // 20130129
    if (c instanceof Ext.Panel) var t = c.header; else // 20130129
    var t = c.getEl();
    //~ console.log(20130129,t,title,body);
    //~ t.dismissDelay = 0;
    Ext.QuickTips.register({
      target: t,
      //~ cls: 'lino-quicktip-classical',
      dismissDelay: 0,
      //~ autoHide: false,
      showDelay: 50,      // Show 50ms after entering target
      //~ title: title,
      text: body
    });
  }
};


  
Lino.help_text_editor = function() {
  //~ var bp = {
      //~ mk:this.content_type,
      //~ mt:1
    //~ };
    //~ console.log(20120202,bp);
  //~ Lino.lino.ContentTypes.detail({},{base_params:bp});
  //~ Lino.lino.ContentTypes.detail.run(null,{record_id:this.content_type});
  Lino.lino.ContentTypes.detail.run(null,{record_id:this.content_type});
}

// Path to the blank image should point to a valid location on your server
//~ Ext.BLANK_IMAGE_URL = MEDIA_URL + '/extjs/resources/images/default/s.gif'; 


// used as Ext.grid.Column.renderer for id columns in order to hide the special id value -99999
Lino.id_renderer = function(value, metaData, record, rowIndex, colIndex, store) {
  //~ if (record.phantom) return '';
  return value;
}

Lino.raw_renderer = function(value, metaData, record, rowIndex, colIndex, store) {
  return value;
}

Lino.text_renderer = function(value, metaData, record, rowIndex, colIndex, store) {
  //~ return "not implemented"; 
  return value;
}

Lino.NullNumberColumn = Ext.extend(Ext.grid.Column, {
    align : 'right', 
    format : '0,00/i', 
    renderer : function(value, metaData, record, rowIndex, colIndex, store) {
        //~ console.log(20130128,"NullNumberColumn.renderer",value);
        if (value === null) return '';
        return Ext.util.Format.number(value, this.format);
    }
});

//~ Lino.NullNumberColumn = Ext.extend(Ext.grid.NumberColumn, {
    //~ align : 'right', 
    //~ constructor: function(cfg){
        //~ Ext.grid.NumberColumn.superclass.constructor.call(this, cfg);
        //~ var t = this;
        //~ this.renderer = function(value, metaData, record, rowIndex, colIndex, store) {
          //~ console.log(20130128,"NullNumberColumn.renderer",value);
          //~ if (value === null) return '';
          //~ return Ext.util.Format.number(value, t.format);
      //~ };
    //~ }
//~ });




//~ Lino.cell_button_renderer = function(value, metaData, record, rowIndex, colIndex, store) {
  //~ return '<input type="button" onclick="alert(value)" value=" ? ">' ;
//~ }


//~ Lino.default_renderer = function(value, metaData, record, rowIndex, colIndex, store) {
  //~ if (record.phantom) return '';
  //~ return value;
//~ }

Lino.fk_renderer = function(fkname,handlername) {
  //~ console.log('Lino.fk_renderer handler=',handler);
  return function(value, metaData, record, rowIndex, colIndex, store) {
    //~ console.log('Lino.fk_renderer',fkname,rowIndex,colIndex,record,metaData,store);
    //~ if (record.phantom) return '';
    if (value) {
        var s = '<a href="javascript:' ;
        s += handlername + '.run(null,{record_id:\'' + String(record.data[fkname]) + '\'})">';
        s += value + '</a>';
        //~ console.log('Lino.fk_renderer',value,'-->',s);
        return s
    }
    return '';
  }
};

Lino.lfk_renderer = function(panel,fkname) {
  //~ console.log('Lino.fk_renderer handler=',handler);
  var handlername = 'console.log';
  return function(value, metaData, record, rowIndex, colIndex, store) {
    //~ console.log('Lino.fk_renderer',fkname,rowIndex,colIndex,record,metaData,store);
    if (record.phantom) return '';
    if (value) {
        var s = '<a href="javascript:' ;
        s += handlername + '({},{record_id:\'' + String(record.data[fkname]) + '\'})">';
        s += value + '</a>';
        //~ console.log('Lino.fk_renderer',value,'-->',s);
        return s
    }
    return '';
  }
};

//~ Lino.gfk_renderer = function() {
  //~ return function(value, metaData, record, rowIndex, colIndex, store) {
    //~ if (record.phantom) return '';
    //~ console.log('Lino.gfk_renderer',value,colIndex,record,metaData,store);
    //~ return value;
  //~ }
//~ };


Lino.build_buttons = function(panel,actions) {
  //~ console.log("20121006 Lino.build_buttons",actions);
  if (actions) {
    var buttons = Array(actions.length);
    var cmenu = Array(actions.length);
    for (var i=0; i < actions.length; i++) { 
      buttons[i] = new Ext.Toolbar.Button(actions[i]);
      cmenu[i] = actions[i]
      cmenu[i].text = actions[i].menu_item_text;
      if (actions[i].panel_btn_handler) {
          var h = actions[i].panel_btn_handler.createCallback(panel,buttons[i]);
          //~ if (actions[i].must_save) {
          if (actions[i].auto_save == true) {
              buttons[i].on('click',panel.do_when_clean.createDelegate(panel,[true,h]));
          } else if (actions[i].auto_save == null) {
              buttons[i].on('click',panel.do_when_clean.createDelegate(panel,[false,h]));
          } else if (actions[i].auto_save == false) {
              buttons[i].on('click',h);
          } else {
              console.log("20120703 unhandled auto_save value",actions[i])
          }
          cmenu[i].handler = actions[i].panel_btn_handler.createCallback(panel,cmenu[i]);
      }
    }
    return {bbar:buttons, cmenu:new Ext.menu.Menu(cmenu)};
  }
}

Lino.do_when_visible = function(cmp,todo) {
  //~ if (cmp.el && cmp.el.dom) 
  if (cmp.isVisible()) { 
    // 'visible' means 'rendered and not hidden'
    //~ console.log(cmp.title,'-> cmp is visible now');
    todo(); 
  //~ } else {
      //~ cmp.on('resize',todo,cmp,{single:true});
  //~ }
  //~ if (false) { // 20120213
  } else { 
    //~ console.log('Lino.do_when_visible() must defer because not isVisible()',todo,cmp);
    if (cmp.rendered) {
      //~ console.log(cmp,'-> cmp is rendered but not visible: and now?');
      //~ console.log(cmp.title,'-> cmp is rendered but not visible: try again in a moment...');
      //~ var fn = function() {Lino.do_when_visible(cmp,todo)};
      //~ fn.defer(100);
      
      Lino.do_when_visible.defer(50,this,[cmp,todo]);
      //~ Lino.do_when_visible.defer(100,this,[cmp,todo]);
      
    } else {
      //~ console.log(cmp.title,'-> after render');
      cmp.on('afterrender',todo,cmp,{single:true});
    }
  }
  
};    

/*
*/
Lino.do_on_current_record = function(panel,fn,phantom_fn) {
  var rec = panel.get_current_record();
  if (rec == undefined) {
    Lino.notify("There's no selected record.");
    return;
  }
  // 20120307 A VirtualTable with a Detail (lino.Models) has only "phantom" records.
  if (rec.phantom) {
    //~ if (!panel.editable) { console.log("20120312 not editable:",panel)}
    if (phantom_fn) {
      phantom_fn(panel);
    } else {
      Lino.notify("Action not available on phantom record.");
    }
    return;
  }
  return fn(rec);
};






Lino.call_ajax_action = function(panel,method,url,p,actionName,step,on_confirm,on_success) {
  p.an = actionName;
  if (!panel) panel = Lino.viewport;
  Ext.apply(p,panel.get_base_params());
  //~ console.log("20121212 Lino.call_ajax_action",panel);
  panel.loadMask.show(); 
  //~ p.$ext_requests.URL_PARAM_SUBST_USER = Lino.subst_user;
  //~ Lino.insert_subst_user(p);
    
  //~ if (step) p['$ext_requests.URL_PARAM_ACTION_STEP'] = step;
  //~ if (pp) pp(p); // "parameter processor" : first used for read beid card
  Ext.Ajax.request({
    method: method,
    url: url,
    params: p,
    success: Lino.action_handler(panel,on_success,on_confirm)
  });
};

Lino.row_action_handler = function(actionName,hm,pp) {
  var p = {};
  var fn = function(panel,btn,step) {
      if (pp) { p = pp(); if (! p) return; }
      Lino.do_on_current_record(panel,function(rec) {
          //~ console.log(panel);
          //~ 20120723 Lino.call_ajax_action(panel,rec.id,actionName,step,fn);
          Lino.call_ajax_action(panel,hm,panel.get_record_url(rec.id),p,actionName,step,fn);
      });
  };
  return fn;
};

Lino.list_action_handler = function(ls_url,actionName,hm,pp) {
  var p = {};
  var url = '/api' + ls_url
  var fn = function(panel,btn,step) {
      //~ console.log("20121210 Lino.list_action_handler",arguments);
      //~ var url = ADMIN_URL + '/api' + panel.ls_url
      if (pp) { p = pp();  if (! p) return; }
      Lino.call_ajax_action(panel,hm,url,p,actionName,step,fn);
  };
  return fn;
};

Lino.param_action_handler = function(window_action) { // 20121012
  var fn = function(panel,btn,step) {
    Lino.do_on_current_record(panel,function(rec) {
      //~ console.log(panel);
      //~ 20120723 Lino.call_ajax_action(panel,rec.id,actionName,step,fn);
      window_action.run(panel.getId(),{}); 
    });
  };
  return fn;
};


Lino.run_row_action = function(requesting_panel,url,pk,actionName,pp) {
  //~ var panel = action.get_window().main_item;
  url = '/api' + url  + '/' + pk;
  var panel = Ext.getCmp(requesting_panel);
  if (pp) var p = pp(); else var p = {};
  var fn = function(panel,btn,step) {
    //~ 20120723 Lino.call_ajax_action(panel,pk,actionName,step,fn);
    Lino.call_ajax_action(panel,'GET',url,p,actionName,step,fn);
  }
  fn(panel,null,null);
}



Lino.show_detail = function(panel,btn) {
  Lino.do_on_current_record(panel, 
    function(rec) {
      //~ panel.loadMask.show();
      var bp = panel.get_base_params();
      //~ var bp = {};
      panel.add_param_values(bp); // 20120918
      var status = {
        record_id:rec.id,
        base_params:bp
        //~ param_values: pv.$ext_requests.URL_PARAM_PARAM_VALUES
      }
      //~ console.log("20120918 Lino.show_detail",status);
      panel.ls_detail_handler.run(null,status);
      //~ panel.loadMask.hide();
      //~ panel.containing_window.window.hideMask();
      //~ panel.el.unmask();
    },
    Lino.show_insert
  );
};

Lino.show_fk_detail = function(combo,detail_action) {
    //~ console.log("Lino.show_fk_detail",combo,handler);
    pk = combo.getValue();
    if (pk) {
        detail_action.run(null,{record_id: pk})
      } else {
        Lino.notify("Cannot show detail for empty foreign key.");
      }
};

Lino.show_insert = function(panel,btn) {
  var bp = panel.get_base_params();
  //~ console.log('20120125 Lino.show_insert',bp)
  //~ panel.ls_insert_handler.run(null,{record_id:-99999,base_params:bp});
  panel.ls_insert_handler.run(panel.getId(),{record_id:-99999,base_params:bp});
};

Lino.show_insert_duplicate = function(panel,btn) {
  Lino.do_on_current_record(panel,
    function(rec) {
      var newRec = {};
      Ext.apply(newRec,rec);
      newRec.id = -99999;
      panel.ls_insert_handler.run(null,{data_record:rec});
    });
};

//~ Lino.update_row_handler = function(action_name) {
  //~ return function(panel,btn) {
    //~ Lino.notify("Sorry, " + action_name + " is not implemented.");
  //~ }
//~ };




if (Ext.ux.grid !== undefined) {
    Lino.GridFilters = Ext.extend(Ext.ux.grid.GridFilters,{
      encode:true,
      local:false
    });
} else {
    Lino.GridFilters = function() {}; // dummy
    Ext.override(Lino.GridFilters,{
      init : function() {}
    });
};



//~ Lino.ButtonField = Ext.extend(Ext.form.TextField,{
//~ Lino.ButtonField = Ext.extend(Ext.form.Field,{
    //~ editable : false,
    //~ constructor : function(ww,config,params){
      //~ this.containing_window = ww;
      //~ if (params) Ext.apply(config,params);
      //~ Lino.ButtonField.superclass.constructor.call(this, config);
    //~ },
    //~ setButtons : function(buttons){
      //~ console.log('setButtons',buttons);
    //~ },
    //~ onRender : function(ct, position){
        //~ if(!this.el){
            //~ this.panel = new Ext.Container({items:[
              //~ {xtype:'button',text:'upload'},
              //~ {xtype:'button',text:'show'},
              //~ {xtype:'button',text:'edit'}
            //~ ]});
            //~ this.panel.ownerCt = this;
            //~ this.el = this.panel.getEl();

        //~ }
        //~ Lino.ButtonField.superclass.onRender.call(this, ct, position);
    //~ },

  
//~ });

Lino.FieldBoxMixin = {
  before_init : function(config,params) {
    if (params) Ext.apply(config,params);
    var actions = Lino.build_buttons(this,config.ls_bbar_actions);
    if (actions) config.bbar = actions.bbar;
  },
  //~ constructor : function(ww,config,params){
    //~ this.containing_window = ww;
    //~ if (params) Ext.apply(config,params);
    //~ var actions = Lino.build_buttons(this,config.ls_bbar_actions);
    //~ if (actions) config.bbar = actions.bbar;
    //~ Lino.FieldBoxMixin.superclass.constructor.call(this, config);
  //~ },
  do_when_clean : function(auto_save,todo) { todo() },
  //~ format_data : function(html) { return '<div class="htmlText">' + html + '</div>' },
  format_data : function(html) { return html },
  get_base_params : function() {
    // needed for insert action
    var p = Ext.apply({},this.base_params);
    Lino.insert_subst_user(p);
    return p;
  },
  set_base_params : function(p) {
    this.base_params = Ext.apply({},p);
    //~ if (p.param_values) this.set_param_values(p.param_values);  
  },
  clear_base_params : function() {
      this.base_params = {};
      Lino.insert_subst_user(this.base_params);
  },
  set_base_param : function(k,v) {
    this.base_params[k] = v;
  }
};



Lino.HtmlBoxPanel = Ext.extend(Ext.Panel,Lino.PanelMixin);
Lino.HtmlBoxPanel = Ext.extend(Lino.HtmlBoxPanel,Lino.FieldBoxMixin);
Lino.HtmlBoxPanel = Ext.extend(Lino.HtmlBoxPanel,{
  disabled_in_insert_window : true,
  constructor : function(config,params) {
    this.before_init(config,params);
    Lino.HtmlBoxPanel.superclass.constructor.call(this, config);
  },
  //~ constructor : function(ww,config,params){
    //~ this.ww = ww;
    //~ if (params) Ext.apply(config,params);
    //~ var actions = Lino.build_buttons(this,config.ls_bbar_actions);
    //~ if (actions) config.bbar = actions.bbar;
    //~ Lino.FieldBoxMixin.constructor.call(this, ww,config,params);
  //~ },
  //~ constructor : function(ww,config,params){
    //~ this.ww = ww;
    //~ if (params) Ext.apply(config,params);
    //~ var actions = Lino.build_buttons(this,config.ls_bbar_actions);
    //~ if (actions) config.bbar = actions.bbar;
    //~ Lino.FieldBoxMixin.superclass.constructor.call(this, config);
  //~ },
  //~ disable : function() { var tb = this.getBottomToolbar(); if(tb) tb.disable()},
  //~ enable : function() { var tb = this.getBottomToolbar(); if(tb) tb.enable()},
  onRender : function(ct, position){
    Lino.HtmlBoxPanel.superclass.onRender.call(this, ct, position);
    //~ console.log(20111125,this.containing_window);
    if (this.containing_panel) {
      this.containing_panel.on('enable',this.enable,this);
      this.containing_panel.on('disable',this.disable,this);
    }
    this.el.on({
      dragenter:function(event){
        event.browserEvent.dataTransfer.dropEffect = 'move';
        return true;
      }
      ,dragover:function(event){
        event.browserEvent.dataTransfer.dropEffect = 'move';
        event.stopEvent();
        return true;
      }
      ,drop:{
        scope:this
        ,fn:function(event){
          event.stopEvent();
          //~ console.log(20110516);
          var files = event.browserEvent.dataTransfer.files;
          if(files === undefined){
            return true;
          }
          var len = files.length;
          while(--len >= 0){
            console.log(files[len]);
            //~ this.processDragAndDropFileUpload(files[len]);
          }
          Lino.show_insert(this);
        }
      }
    });
  },
  refresh : function(unused) { 
      this.refresh_with_after();
  },
  refresh_with_after : function(after) {
    //~ if (this.master_panel) {
      var record = this.containing_panel.get_current_record();
      //~ console.log('HtmlBox.refresh()',this.title,record,record.title);
      var box = this.items.get(0);
      var todo = function() {
        if (this.disabled) return;
        //~ this.set_base_params(this.containing_window.get_base_params());
        this.set_base_params(this.containing_panel.get_master_params());
        var el = box.getEl();
        if (el) {
          el.update(record ? this.format_data(record.data[this.name]) : '');
          //~ console.log('HtmlBox.refresh()',this.name);
        //~ } else {
          //~ console.log('HtmlBox.refresh() failed for',this.name);
        }
      };
      Lino.do_when_visible(box,todo.createDelegate(this));
    //~ }
  }
});
//~ Ext.override(Lino.HtmlBoxPanel,Lino.FieldBoxMixin);



Lino.RichTextPanel = Ext.extend(Ext.Panel,Lino.PanelMixin);
Lino.RichTextPanel = Ext.extend(Lino.RichTextPanel,Lino.FieldBoxMixin);
Lino.RichTextPanel = Ext.extend(Lino.RichTextPanel,{
    
  //~ initComponent : function(){
    //~ Lino.RichTextPanel.superclass.initComponent.call(this);
  //~ },
  constructor : function(config,params) {
    //~ console.log('Lino.RichTextPanel.initComponent',this);
    //~ var url = TEMPLATES_URL + config.ls_url + "/" + String(rec.id) + "/" + config.name;
    //~ var url = TEMPLATES_URL + config.ls_url + "/" + config.name;
    var t = this;
    var tinymce_options = {
        theme : "advanced",
        content_css: '/media/lino/extjs/lino.css',
        language: 'de',
        //~ template_external_list_url : url,
        theme_advanced_toolbar_location : "top",
        theme_advanced_toolbar_align : "left",
        theme_advanced_statusbar_location : "bottom",
        template_popup_width : 700,
        template_popup_height : 500,
        template_replace_values : { 
            data_field : function(element){ 
                //~ console.log(20110722,fieldName,t.containing_window.get_current_record()); 
                var fieldName = element.innerHTML;
                element.innerHTML = t.containing_panel.get_current_record().data[fieldName];
            } 
        }
      };
      
    var editorConfig = {
      tinymceSettings: {
        plugins : "noneditable,template", 
        // Theme options - button# indicated the row# only
        theme_advanced_buttons1 : "bold,italic,underline,|,justifyleft,justifycenter,justifyright,|,bullist,numlist,|,outdent,indent,|,undo,redo,|,removeformat,template",
        theme_advanced_buttons2 : "",
        theme_advanced_buttons3 : "", // ,|,sub,sup,|,charmap",      
        theme_advanced_resizing : false
        //~ save_onsavecallback : save_callback,
        //~ save_enablewhendirty : true
        //~ save_oncancelcallback: on_cancel
        
    }};
    Ext.apply(editorConfig.tinymceSettings,tinymce_options);
    //~ editorConfig.name = config.action_name;
    editorConfig.name = config.name;
    delete config.name;
    //~ config.title = config.label;
    //~ delete config.label;
    this.before_init(config,params);
    
    this.editor = new Ext.ux.TinyMCE(editorConfig);
    var t = this;
    config.tools = [{
                      qtip: "Edit text in own window", 
                      id: "up",
                      handler: function(){
                        if(t.editor.isDirty()) {
                            var record = t.containing_panel.get_current_record();
                            record.data[t.editor.name] = t.editor.getValue();
                        }
                        Lino.edit_tinymce_text(t,tinymce_options)
                      }
                    }];
    
    config.items = this.editor;
    config.layout = "fit";
    Lino.RichTextPanel.superclass.constructor.call(this, config);
  },
  refresh : function(unused) { 
      this.refresh_with_after();
  },
  refresh_with_after : function(after) {
    var record = this.containing_panel.get_current_record();
    //~ console.log('RichTextPanel.refresh()',this.title,record.title,record);
    var todo = function() {
      //~ this.set_base_params(this.containing_window.get_base_params());
      if (record) {
        var url = '/templates' + this.containing_panel.ls_url + "/" 
            + String(record.id) + "/" + this.editor.name;
        //~ console.log('RichTextPanel.refresh()',url);
        if (this.editor.ed) this.editor.ed.settings.template_external_list_url = url;
        this.set_base_params(this.containing_panel.get_master_params());
        //~ var v = record ? this.format_data(record.data[this.editor.name]) : ''
        var v = this.format_data(record.data[this.editor.name])
        this.editor.setValue(v);
      } else {
        this.editor.setValue('(no data)');
      }
    };
    Lino.do_when_visible(this,todo.createDelegate(this));
  }
});
//~ Ext.override(Lino.RichTextPanel,Lino.FieldBoxMixin);



Lino.ActionFormPanel = Ext.extend(Ext.form.FormPanel,Lino.MainPanel);
Lino.ActionFormPanel = Ext.extend(Lino.ActionFormPanel,Lino.PanelMixin);
Lino.ActionFormPanel = Ext.extend(Lino.ActionFormPanel,Lino.FieldBoxMixin);
Lino.ActionFormPanel = Ext.extend(Lino.ActionFormPanel,{
  //~ layout:'fit'
  //~ ,autoHeight: true
  //~ ,frame: true
  window_title: "Action Parameters",
  constructor : function(config){
    config.bbar = [
        {text:'OK',handler:this.on_ok,scope:this},
        {text:'Cancel',handler:this.on_cancel,scope:this}
    ];
    //~ config.items = config.params_panel;
    Lino.ActionFormPanel.superclass.constructor.call(this, config);
  }
  //~ ,initComponent : function(){
    //~ Lino.ActionFormPanel.superclass.initComponent.call(this);
  //~ }
  ,on_cancel : function() { 
    this.get_containing_window().close();
  }
  ,on_ok : function() { 
    //~ var rp = this.requesting_panel;
    //~ console.log("on_ok",this.requesting_panel,arguments);
    //~ Lino.row_action_handler()
    var panel = this.requesting_panel;
    var actionName = this.action_name;
    var rec = panel.get_current_record();
    var self = this;
    function on_success() { self.get_containing_window().close(); };
    var fn = function(panel,btn,step) {
      var p = {};
      self.add_field_values(p)
      Lino.call_ajax_action(panel,'GET',panel.get_record_url(rec.id),p,actionName,step,fn,on_success);
    }
    fn(panel,null,null);
    
    
  }
  ,set_status : function(status,rp){
    this.requesting_panel = Ext.getCmp(rp);
    //~ console.log('20120918 ActionFormPanel.set_status()',status,rp,this.requesting_panel);
    this.clear_base_params();
    if (status == undefined) status = {};
    //~ if (status.param_values) 
    this.set_field_values(status.field_values);
    if (status.base_params) this.set_base_params(status.base_params);
  }
  
  ,add_field_values : function (p) { // similar to add_param_values()
      //~ 20121023 
      if (this.form.isDirty()) {
        p.fv = this.get_field_values();
      }else{
        if (this.status_field_values) 
          p.fv = Lino.fields2array(this.fields,this.status_field_values);
      }
      //~ if (!this.form.isDirty()) return;
      //~ p.$ext_requests.URL_PARAM_FIELD_VALUES = this.get_field_values();
      //~ console.log("20120203 add_param_values added pv",pv,"to",p);
  }
  ,get_field_values : function() {
      return Lino.fields2array(this.fields);
  }
  ,set_field_values : function(pv) {
      //~ console.log('20120203 MainPanel.set_param_values', pv);
      this.status_field_values = pv;
      if (pv) this.form.my_loadRecord(pv);
      else this.form.reset(); 
  }
  ,config_containing_window : function(wincfg) { 
      wincfg.title = this.window_title;
      wincfg.keys = [
        { key: Ext.EventObject.ENTER, fn: this.on_ok }
      ]
  }
});

Lino.fields2array = function(fields,values) {
    //~ console.log('20120116 gonna loop on', fields);
    var pv = Array(fields.length);
    for(var i=0; i < fields.length;i++) {
        var f = fields[i]
        if (values) 
          var v = values[f.name];
        else 
          var v = f.getValue();
        if (f.formatDate) {
            pv[i] = f.formatDate(v); 
        } else {
            pv[i] = v; // f.getValue(); 
        }
    }
    return pv;
}


Lino.FormPanel = Ext.extend(Ext.form.FormPanel,Lino.MainPanel);
Lino.FormPanel = Ext.extend(Lino.FormPanel,Lino.PanelMixin);
Lino.FormPanel = Ext.extend(Lino.FormPanel,{
  params_panel_hidden : false,
  //~ base_params : {},
  //~ trackResetOnLoad : true,
  //~ query_params : {},
  //~ 20110119b quick_search_text : '',
  constructor : function(config,params){
    if (params) Ext.apply(config,params);
    this.base_params = {};
    //~ ww.config.base_params.query = ''; // 20111018
    //~ console.log(config);
    //~ console.log('FormPanel.constructor() 1',config)
    //~ Ext.applyIf(config,{base_params:{}});
    //~ console.log('FormPanel.constructor() 2',config)
      
    config.trackResetOnLoad = true;
    
    Lino.FormPanel.superclass.constructor.call(this, config);
      
    //~ this.set_base_param('$URL_PARAM_FILTER',null); // 20111018
    //~ this.set_base_param('$URL_PARAM_FILTER',''); // 20111018
      
  },
  initComponent : function(){
    
    //~ console.log("20111201 containing_window",this.containing_window,this);
    
    var actions = Lino.build_buttons(this,this.ls_bbar_actions);
    if (actions) {
        this.bbar = actions.bbar;
    //~ } else {
        //~ this.bbar = [];
    }
    //~ Ext.apply(config,Lino.build_buttons(this,config.ls_bbar_actions));
    //~ config.bbar = Lino.build_buttons(this,config.ls_bbar_actions);
    //~ var config = this;
    
    //~ if (this.containing_window instanceof Lino.DetailWrapper) {
    
    //~ console.log('20120121 initComponent', this.action_name);
    //~ if (this.action_name == 'detail' | this.action_name == 'show') {
    //~ if (this.action_name != 'insert') {
    if (! this.hide_top_toolbar) {
      this.tbar = [];
      // 20111015    
      if (! this.hide_navigator) {
        this.record_selector = new Lino.RemoteComboFieldElement({
          store: new Lino.ComplexRemoteComboStore({
            //~ baseParams: this.containing_window.config.base_params,
            baseParams: this.get_base_params(),
            //~ value: this.containing_window.config.base_params.query,
            proxy: new Ext.data.HttpProxy({
              url: '/choices' + this.ls_url,
              method:'GET'
            })
          }),
          pageSize:25,
          listeners: { 
            scope:this, 
            select:function(combo,record,index) {
              //~ console.log('jumpto_select',arguments);
              this.goto_record_id(record.id);
            }
          },
          emptyText: "Go to record"
        })
        this.tbar = this.tbar.concat([this.record_selector]);
        
        this.tbar = this.tbar.concat([
          this.first = new Ext.Toolbar.Button({
            tooltip:"First",disabled:true,handler:this.moveFirst,scope:this,iconCls:'x-tbar-page-first'}),
          this.prev = new Ext.Toolbar.Button({
            tooltip:"Previous",disabled:true,handler:this.movePrev,scope:this,iconCls:'x-tbar-page-prev'}),
          this.next = new Ext.Toolbar.Button({
            tooltip:"Next",disabled:true,handler:this.moveNext,scope:this,iconCls:'x-tbar-page-next'}),
          this.last = new Ext.Toolbar.Button({
            tooltip:"Last",disabled:true,handler:this.moveLast,scope:this,iconCls:'x-tbar-page-last'})
        ]);
      }
      this.tbar = this.add_params_panel(this.tbar);
      
      //~ console.log(20101117,this.containing_window.refresh);
      this.tbar = this.tbar.concat([
        {
          //~ text:'Refresh',
          handler:function(){ this.do_when_clean(true,this.refresh.createDelegate(this)) },
          iconCls: 'x-tbar-loading',
          tooltip:"Reload current record",
          scope:this}
      ]);
          
      if (this.bbar) { // since 20121016
        if (this.tbar) {
            this.tbar = this.tbar.concat(['-']) ;
        } else {
          this.tbar = [];
        }
        this.tbar = this.tbar.concat(this.bbar) ;
        this.bbar = undefined;
      }
    
      this.tbar = this.tbar.concat([
          '->',
          this.displayItem = new Ext.Toolbar.TextItem({})
      ]);
          
    }
    //~ if (this.content_type && this.action_name != 'insert') {
      //~ this.bbar = this.bbar.concat([
        //~ '->',
        //~ { text: "[$_('Help Text Editor')]",
          //~ handler: Lino.help_text_editor,
          //~ qtip: "$_('Edit help texts for fields on this model.')",
          //~ scope: this}
      //~ ])
    //~ }
    //~ this.before_row_edit = config.before_row_edit.createDelegate(this);
      
    //~ if (this.master_panel) {
        //~ this.set_base_params(this.master_panel.get_master_params());
    //~ }
      
    Lino.FormPanel.superclass.initComponent.call(this);
    
    this.on('render',function(){
      this.loadMask = new Ext.LoadMask(this.bwrap,{msg:"Please wait..."});
    },this);
    
    
    //~ var this_ = this;
    //~ this.cascade(function(cmp){
      //~ // var active_field = false;
      //~ for (i = 0; i < this_.active_fields.length; i++) {
        //~ if (cmp.name == this_.active_fields[i]) {
            //~ // active_field = true; break;
            //~ cmp.on("change",function() {this_.save()});
        //~ }
      //~ };
      //~ if (active_field) {
      // if (cmp instanceof Lino.GridPanel) {
          //~ cmp.on("change",function() {this_.save()});
      //~ }
    //~ });
    
    if (this.action_name == 'insert') {
      this.cascade(function(cmp){
        // console.log('20110613 cascade',cmp);
        if (cmp.disabled_in_insert_window) {
            //~ cmp.disable();
            cmp.hide();
        }
      });
      
    }
    
  },
  
  unused_is_loading : function() { 
    if (this.current_record == null) {
        //~ console.log("20130515 current_record is null");
        return true; 
    }
    
    if (! this.loadMask) return true; // not even rendered: 
    if (! this.loadMask.el) return true; // not even rendered: 
    // thanks to Marco Pegoraro http://movableapp.com/2011/09/sencha-touch-loadmask-isvisible/
    var loading = (this.loadMask.el.select('.x-loading-msg').elements.length > 0);
    //~ console.log('20130515 GridPanel.is_loading() returns',loading);
    return loading;

    
    var loading = false;
    this.cascade(function(cmp){
        if (cmp instanceof Lino.GridPanel && cmp.is_loading()) {
            //~ console.log(20130515, cmp.title,'is loading');
            loading = true;
            return false;
        }
      });
    return loading;
    //~ var a = this.findByType(Lino.GridPanel);
    //~ for (i=0;i<a.length;i++) {
        //~ if (a[i].is_loading()) return true;
    //~ }
    //~ return false;
  },
  
  get_status : function(){
      var st = {
        base_params: this.get_base_params(),
        data_record : this.get_current_record()
        }
      var tp = this.items.get(0);
      if (tp instanceof Ext.TabPanel) {
        st.active_tab = tp.getActiveTab();
      }
      st.param_values = this.status_param_values;
      return st;
  },
  set_status : function(status,rp){
    this.requesting_panel = Ext.getCmp(rp);
    //~ console.log('20120918 FormPanel.set_status()',status);
    this.clear_base_params();
    if (status == undefined) status = {};
    //~ if (status.param_values) 
    this.set_param_values(status.param_values);
    if (status.base_params) this.set_base_params(status.base_params);
    var tp = this.items.get(0);
    if (tp instanceof Ext.TabPanel) {
      if (status.active_tab) {
        //~ console.log('20111201 active_tab',this.active_tab,this.items.get(0));
        //~ tp.activeTab = status.active_tab;
        tp.setActiveTab(status.active_tab);
        //~ this.main_item.items.get(0).activate(status.active_tab);
      } else {
        tp.setActiveTab(0);
      }
      }
    
    if (status.data_record) {
      //~ console.log('20111201 Lino.FormPanel with data_record',this.data_record.title,this.containing_window);
      //~ this.main_item.on_master_changed.defer(2000,this.main_item,[status.data_record]);
      //~ Lino.do_when_visible(this.main_item,function(){this.on_master_changed(status.data_record)});
      //~ this.main_item.on('afterrender',function(){
      //~   this.main_item.on_master_changed(status.data_record)},this,{single:true});
      /* must defer because because set_window_title() didn't work otherwise */
      this.set_current_record.createDelegate(this,[status.data_record]).defer(100);
      //~ this.set_current_record(this.data_record);
      //~ return;
    } else if (status.record_id != undefined) { 
      /* possible values include 0 and null, 0 being a valid record id, 
      null the equivalent of undefined
      */
      //~ this.main_item.goto_record_id(this.status.record_id);
      this.load_record_id(status.record_id);
    } else {
      this.set_current_record(undefined);
    }
  },
    
  get_base_params : function() {
    // needed for insert_action
    var p = Ext.apply({},this.base_params);
    Lino.insert_subst_user(p);
    return p;
    //~ return this.base_params;
  },
  set_base_params : function(p) {
    //~ this.base_params = Ext.apply({},this.base_params); // make sure it is an instance variable
    delete p['query'] // 20120725
    Ext.apply(this.base_params,p);
    if (this.record_selector) {
        var store = this.record_selector.getStore();
        for (k in p) store.setBaseParam(k,p[k]);
        delete this.record_selector.lastQuery;
        //~ console.log("20120725 record_selector.setBaseParam",p)
    }
  },
  clear_base_params : function() {
      this.base_params = {};
      Lino.insert_subst_user(this.base_params);
        
      //~ if (this.record_selector) {
          //~ var store = this.record_selector.getStore();
          //~ for (k in store.baseParams) store.setBaseParam(k,undefined);
          //~ delete this.record_selector.lastQuery;
          //~ console.log("20120725 record_selector.getBaseParams() -->",store.baseParams)
      //~ }
  },
  set_base_param : function(k,v) {
    //~ this.base_params = Ext.apply({},this.base_params); // make sure it is an instance variable
    this.base_params[k] = v;
    //~ if (this.record_selector) {
        //~ this.record_selector.getStore().setBaseParam(k,v);
        //~ delete this.record_selector.lastQuery;
    //~ }
  },
  
  after_delete : function() {
    if (this.current_record.navinfo.next)
      this.moveNext();
    else if (this.current_record.navinfo.prev)
      this.movePrev();
    else 
      this.abandon();
  },
  moveFirst : function() {this.goto_record_id(this.current_record.navinfo.first)},
  movePrev : function() {this.goto_record_id(this.current_record.navinfo.prev)},
  moveNext : function() {this.goto_record_id(this.current_record.navinfo.next)},
  moveLast : function() {this.goto_record_id(this.current_record.navinfo.last)},
  
  
  refresh : function(unused) { 
      this.refresh_with_after();
  },
  refresh_with_after : function(after) { 
    //~ console.log('20120121 Lino.FormPanel.refresh()',this);
    if (this.current_record) {
        this.load_record_id(this.current_record.id,after);
    } else {
        this.set_current_record(undefined,after);
    }
  },
  
  do_when_clean : function(auto_save,todo) {
    var this_ = this;
    if (this.form.isDirty()) {
        if (auto_save) {
            this_.save(todo);
        } else {
          //~ console.log('20111217 do_when_clean() form is dirty',this.form);
          var config = {title:"Confirmation"};
          config.buttons = Ext.MessageBox.YESNOCANCEL;
          config.msg = "Save changes to current record ?";
          config.fn = function(buttonId,text,opt) {
            //~ console.log('do_when_clean',buttonId)
            if (buttonId == "yes") {
                //~ Lino.submit_detail(this_,undefined,todo);
                //~ this_.containing_window.save(todo);
                this_.save(todo);
            } else if (buttonId == "no") { 
              todo();
            }
          }
        }
        Ext.MessageBox.show(config);
    }else{
      //~ console.log('do_when_clean : now!')
      todo();
    }
  },
  
  goto_record_id : function(record_id) {
    //~ console.log('20110701 Lino.FormPanel.goto_record_id()',record_id);
    //~ var this_ = this;
    //~ this.do_when_clean(function() { this_.load_record_id(record_id) }
    this.do_when_clean(true,this.load_record_id.createDelegate(this,[record_id]));
  },
  
  load_record_id : function(record_id,after) {
    var this_ = this;
    //~ var p = { fmt: this.containing_window.config.action_name};
    //~ var p = Ext.apply({},this.containing_window.config.base_params);
    var p = Ext.apply({},this.get_base_params());
    //~ Lino.insert_subst_user(p);
    //~ console.log('20110713 action_name=',this.containing_window.config.action_name,
      //~ 'base_params=',this.containing_window.config.base_params);
    if (this.action_name)
        p.an = this.action_name;
    //~ p.an = this.action_name;
    //~ p.an = this.containing_window.config.action_name;
    //~ p.fmt = 'json';
    //~ p.fmt = '$ext_requests.URL_FORMAT_JSON';
    p.rp = this.getId();
    //~ p.$ext_requests.URL_PARAM_SUBST_USER = Lino.subst_user;
    p.fmt = 'json';
    //~ 20110119b p['$URL_PARAM_FILTER'] = this.quick_search_text;
    //~ Ext.apply(p,this.query_params);
    this.add_param_values(p);
    //~ console.log('20121120 FormPanel.load_record_id',record_id,p);
    if (this.loadMask) this.loadMask.show();
    Ext.Ajax.request({ 
      waitMsg: 'Loading record...',
      method: 'GET',
      params: p,
      scope: this,
      url: this.get_record_url(record_id),
      success: function(response) {   
        // todo: convert to Lino.action_handler.... but result 
        if (this.loadMask) this.loadMask.hide();
        if (response.responseText) {
          var rec = Ext.decode(response.responseText);
          //~ console.log('20120918 goto_record_id success',rec);
          this.set_param_values(rec.param_values);
          this.set_current_record(rec,after);
        }
      },
      failure: Lino.ajax_error_handler(this)
    });
  },

  abandon : function () {
    Ext.MessageBox.alert('Note',
      "No more records to display. Detail window has been closed.");
    Lino.close_window();
    //~ if (this.containing_window) {
        //~ this.containing_window.hide();
    //~ }
  },
  
  set_current_record : function(record,after) {
    //~ console.log('20120722 Lino.FormPanel.set_current_record',record.title,record);
    if (this.record_selector) {
        this.record_selector.clearValue();
        // e.g. InsertWrapper FormPanel doesn't have a record_selector
    }
    this.current_record = record;
    //~ if (record) 
        //~ console.log('Lino.FormPanel.set_current_record',record.title,record);
    //~ else
        //~ console.log('Lino.FormPanel.set_current_record',record);
    //~ this.config.main_panel.form.load(record);    
    if (record) {
      this.enable();
      this.form.my_loadRecord(record.data);
      this.set_window_title(record.title);
      //~ this.getBottomToolbar().enable();
      var da = record.data.disabled_actions;
      if (da) {
          //~ console.log('20120528 disabled_actions =',da,this.getBottomToolbar());
          //~ 20121016 this.getBottomToolbar().items.each(function(item,index,length){
          var tb = this.getTopToolbar();
          if (tb) tb.items.each(function(item,index,length){
              //~ console.log('20120528 ',item.itemId,'-->',da[item.itemId]);
              if (da[item.itemId]) item.disable(); else item.enable();
          });
      };
      if (this.disable_editing | record.data.disable_editing) {
          //~ console.log("20120202 disable_editing",record.title);
          this.form.items.each(function(cmp){
            if (!cmp.always_enabled) cmp.disable();
          },this);
      } else {
          this.form.items.each(function(cmp){
            //~ console.log("20120202",cmp);
            if (record.data.disabled_fields[cmp.name]) cmp.disable();
            else cmp.enable();
          },this);
        
          //~ if (record.data.disabled_fields) {
              //~ for (i = 0; i < record.data.disabled_fields.length; i++) {
                  //~ var flds = this.find('name',record.data.disabled_fields[i]);
                  //~ if (flds.length == 1) { 
                    //~ flds[0].disable(); 
                  //~ }
              //~ }
          //~ }
      };
      
      if (record.navinfo && ! this.hide_top_toolbar && ! this.hide_navigator) {
        //~ if (record.navinfo.recno == 0) {
            //~ this.first.setDisabled(true);
            //~ this.prev.setDisabled(true);
            //~ this.next.setDisabled(true);
            //~ this.last.setDisabled(true);
        //~ } else {
            this.first.setDisabled(!record.navinfo.first);
            this.prev.setDisabled(!record.navinfo.prev);
            this.next.setDisabled(!record.navinfo.next);
            this.last.setDisabled(!record.navinfo.last);
        //~ }
        this.displayItem.setText(record.navinfo.message);
      }
    } else {
      if (this.form.rendered) 
        this.form.reset(); /* FileUploadField would fail when resetting a non-rendered form */
      //~ this.disable();
      //~ this.getBottomToolbar().disable();
      this.form.items.each(function(cmp){
        cmp.disable();
      },this);
      this.set_window_title(this.empty_title);
      //~ this.containing_window.window.setTitle(this.empty_title);
      if (!this.hide_navigator) {
        this.first.disable();
        this.prev.disable();
        this.next.disable();
        this.last.disable();
      }
    }
    //~ console.log('20100531 Lino.DetailMixin.on_load_master_record',this.main_form);
    this.before_row_edit(record);
    if (after) after();
  },
  
  before_row_edit : function(record) {},
  search_change : function(field,oldValue,newValue) {
    //~ console.log('search_change',field.getValue(),oldValue,newValue)
    this.set_base_param('query',field.getValue()); 
    this.refresh();
  },
  
  get_selected : function() { return [ this.current_record ] },
  get_current_record : function() {  
    //~ console.log(20100714,this.current_record);
    return this.current_record 
  },
  
  get_permalink_url : function() {
      var rec = this.get_current_record();
      if (rec && ! rec.phantom && rec.id != -99998)
          return '/api' + this.ls_url + '/' + rec.id;
      return '/api' + this.ls_url;
    
  },
  get_permalink_params : function() {
    var p = {};
    //~ var p = {an:'detail'};
    if (this.action_name)
        p.an = this.action_name;
    //~ var p = {an:this.action_name};
    var main = this.items.get(0);
    if (main.activeTab) {
      var tab = main.items.indexOf(main.activeTab);
      //~ console.log('main.activeTab',tab,main.activeTab);
      if (tab) p.tab = tab;
    }
    this.add_param_values(p)
    return p;
  },
  
  /* 
  Lino.FormPanel.save() 
  */
  save : function(after,switch_to_detail,action_name) {
    //~ var panel = this;
    //~ console.log('20121120 FormPanel.save');
    this.loadMask.show();
    var rec = this.get_current_record();
    if (this.has_file_upload) this.form.fileUpload = true;
    //~ console.log('FormPanel.save()',rec);
    if (!action_name) action_name = this.action_name;
    if (rec) {
      var p = {};
      Ext.apply(p,this.get_base_params());
      p.rp = this.getId();
      //~ if (this.action_name) 
          //~ p.$ext_requests.URL_PARAM_ACTION_NAME = this.action_name;
      p.an = action_name;
      if (rec.phantom) {
        //~ if (this.action_name != 'insert') 
            //~ console.log("Warning: phantom record, but action_name is",this.action_name)
        this.form.submit({
          url: '/api' + this.ls_url,
          method: 'POST',
          params: p, 
          scope: this,
          success: function(form, action) {
            this.loadMask.hide();
            Lino.notify(action.result.message);
            /***
            Close this window, but update the status of the 
            calling window.
            If the calling window is a detail on the same table,
            then it should skip to the new record. But only then.
            A successful response usually has a data_record,
            except if it is a fileupload form where some mysterious 
            decoding problems (20120209) force us to return a record_id 
            which will lead to an additional GET.
            ***/
            var url = this.ls_url;
            var ww = Lino.calling_window();
            if (ww && ww.window.main_item instanceof Lino.FormPanel 
                   && ww.window.main_item.ls_url == this.ls_url) {
                //~ console.log("20120217 case 1");
                ww.status.record_id = action.result.record_id;
                ww.status.data_record = action.result.data_record;
                Lino.close_window();
            } else if (this.ls_detail_handler && switch_to_detail) {
                //~ console.log("20120217 case 2");
                Lino.kill_current_window();
                this.ls_detail_handler.run(null,{
                    record_id:action.result.record_id,
                    data_record: action.result.data_record,
                    base_params:this.get_base_params()
                });
            } else {
                //~ console.log("20120217 case 3");
                Lino.close_window();
            }
            //~ Lino.close_window(function(ww){
                //~ if (ww.window.main_item instanceof Lino.FormPanel 
                    //~ && ww.window.main_item.ls_url == url) {
                  //~ ww.status.record_id = action.result.record_id,
                  //~ ww.status.data_record = action.result.data_record
                //~ }
            //~ });
          },
          failure: function(form,action) { 
            this.loadMask.hide();
            Lino.on_submit_failure(form,action);
          },
          clientValidation: true
        })
      } else {
        //~ if (this.action_name != 'detail') 
            //~ console.log("Warning: non-phantom record, but action_name is",this.action_name)
        this.form.submit({
          url: '/api' + this.ls_url + '/' + rec.id,
          method: 'PUT',
          //~ headers: { 'HTTP_X_REQUESTED_WITH' : 'XMLHttpRequest'},
          scope: this,
          params: p, 
          success: function(form, action) {
            //~ panel.form.setValues(rec.data);
            //~ 20110701 panel.form.my_loadRecord(rec);
            this.loadMask.hide();
            Lino.notify(action.result.message);
            if (action.result.data_record)
                this.set_current_record(action.result.data_record,after);
            else
                console.log("Warning: no data_record in response to FormPanel.PUT")
            //~ this.refresh_with_after(after);
            //~ if (after) after(); else panel.refresh();
          },
          failure: function(form,action) { 
            this.loadMask.hide();
            Lino.on_submit_failure(form,action)},
          clientValidation: true
        })
      }
    } else Lino.notify("Sorry, no current record.");
  }
  
  ,on_cancel : function() { 
    this.get_containing_window().close();
  }
  ,on_ok : function() { 
      this.save(null,true);
      //~ var rec = this.get_current_record();
      //~ if (rec && rec.phantom)
          //~ this.do_when_clean(true,function() { Lino.close_window(); });
  }
  ,config_containing_window : function(wincfg) { 
      wincfg.keys = [
        { key: Ext.EventObject.ENTER, fn: this.on_ok, scope:this }
        ,{ key: Ext.EventObject.ESCAPE, fn: this.on_cancel, scope:this }
      ]
  }
  
  
  /* not used (no longer possible without .dtl files)
  , edit_detail_config : function () {
    var active_tab = {};
    var main = this.items.get(0);
    if (main.getActiveTab !== undefined) {
      var tabitem = main.getActiveTab();
      Ext.apply(active_tab,{$ext_requests.URL_PARAM_TAB : main.items.indexOf(tabitem)});
    }
    var editor = new Ext.form.TextArea();
    var close = function() { win.close(); }
    var _this = this;
    var save = function() { 
      //~ console.log(20110609,arguments); 
      var params = {desc: editor.getValue()};
      Ext.apply(params,active_tab);
      var a = { 
        params: params, 
        method: 'PUT',
        url: ADMIN_URL + '/detail_config' + _this.ls_url,
        failure : Lino.ajax_error_handler(this),
        success: Lino.action_handler( _this, function(result) {
          //~ console.log('detail_config/save success',result);
          win.close();
          document.location = _this.get_permalink();
        })
      };
      //~ console.log('detail_config/save sent',a);
      _this.loadMask.show(); // 20120211
      Ext.Ajax.request(a);
    }
    var save_btn = new Ext.Button({text:'Save',handler:save,disabled:true});
    var win = new Ext.Window({title:'Detail Layout',
      items:editor, layout:'fit',
      width:500,height:500,
      bbar:[{text:'Cancel',handler:close},save_btn]});
    var a = { 
      params:active_tab, 
      method:'GET',
      url:ADMIN_URL+'/detail_config'+_this.ls_url,
      success : function(response) {
        if (response.responseText) {
          var result = Ext.decode(response.responseText);
          if (result.success) {
            editor.setValue(result.desc);
            save_btn.enable();
          }
        }
      }
    };
    Ext.Ajax.request(a);
    win.show();
  }
  */
});


Lino.getRowClass = function(record, rowIndex, rowParams, store) {
  if (record.phantom) {
    //~ console.log(20101009,record);
    //~ rowParams.bodyStyle = "color:red;background-color:blue";
    return 'lino-phantom-row';
    }
  //~ console.log('20101009 not a phantom:',record);
  return '';
}

//~ FOO = 0;



Lino.GridStore = Ext.extend(Ext.data.ArrayStore,{ 
  autoLoad: false
  ,load: function(options) {
    //~ foo.bar = baz; // 20120213
    if (!options) options = {};
    if (!options.params) options.params = {};
    options.params.fmt = 'json';
    options.params.rp = this.grid_panel.getId();
    Lino.insert_subst_user(options.params); // since 20121016
      
    if (this.grid_panel.hide_top_toolbar) {
        //~ console.log("20120206 GridStore.load() toolbar is hidden");
        options.params.start = 0;
        if (this.grid_panel.preview_limit) {
          options.params.limit = this.grid_panel.preview_limit;
        }
    } else {
        var ps = this.grid_panel.calculatePageSize();
        if (!ps) {
            //~ this.gridpanel.on('render',this.load())
          //~ console.log("20120814 GridStore.load() failed to calculate pagesize");
          return false;
            //~ params.$URL_PARAM_LIMIT = 1;
            //~ this.grid_panel.on('render',this.load.createDelegate(this,options))
            //~ return;
        } 
        options.params.limit = ps;
      
        //~ options.params.start = this.grid_panel.getTopToolbar().cursor;
        //~ if (this.grid_panel.getTopToolbar().pageSize !=  ps) {
          //~ console.log("20120206 abort load because toolbar says pagesize",
            //~ this.grid_panel.getTopToolbar().pageSize,
            //~ "while actual pagesize is",ps);
            //~ return;
        //~ }
        
        this.grid_panel.getTopToolbar().pageSize =  ps;
        if (options.params.start == undefined)
            options.params.start = this.grid_panel.getTopToolbar().cursor;
      
    }
      
    this.grid_panel.add_param_values(options.params);
    //~ Lino.insert_subst_user(options.params);
    //~ console.log("20120814 GridStore.load()",options.params,this.baseParams);
    //~ if (FOO > 0) {
        //~ foo.bar = baz;
    //~ } else FOO += 1;
    return Lino.GridStore.superclass.load.call(this,options);
  }
});

    
Lino.GridPanel = Ext.extend(Ext.grid.EditorGridPanel,Lino.MainPanel);
Lino.GridPanel = Ext.extend(Lino.GridPanel,Lino.PanelMixin);
Lino.GridPanel = Ext.extend(Lino.GridPanel,{
  quick_search_text : '',
  is_searching : false,
  disabled_in_insert_window : true,
  clicksToEdit:2,
  enableColLock: false,
  autoHeight: false,
  params_panel_hidden : false,
  preview_limit : undefined, 
  //~ loadMask: true,
  //~ viewConfig: {
          //~ getRowClass: Lino.getRowClass,
          //~ emptyText:"$_('No data to display.')"
        //~ },
  loadMask: {msg:"Please wait..."},
  
  constructor : function(config){

    config.plugins = [new Lino.GridFilters()];
    
    
    Lino.GridPanel.superclass.constructor.call(this,config);
    
    //~ if (this.containing_window) {
        //~ console.log("20111206 install refresh");
        //~ this.containing_window.on('show',this.refresh,this);
    //~ }
    
  },
  
  unused_is_loading : function() { 
    if (! this.loadMask.el) return true; // not even rendered: 
    // thanks to Marco Pegoraro http://movableapp.com/2011/09/sencha-touch-loadmask-isvisible/
    var loading = (this.loadMask.el.select('.x-loading-msg').elements.length > 0);
    //~ console.log('20130515 GridPanel.is_loading() returns',loading);
    return loading;
    //~ return this.store.getCount() > 0; 
    //~ return (this.loadMask.el.select('.x-loading-msg').elements.length)
    //~ return !this.viewReady; 
    //~ return this.loadMask.isVisible(); 
    //~ return !this.loadMask.disabled; 
  },
  
  unused_config_containing_window : function(wincfg) { 
      //~ temporarily remove save_grid_config button (see /blog(2012/1107)
      if (wincfg.tools != undefined) 
        wincfg.tools = [
          //~ {handler:this.save_grid_data,
            //~ qtip:"$_("Save Grid Data")",
            //~ scope:this, id:"save_data"}, // 20120814
          {handler:this.save_grid_config,
            qtip:"Save Grid Configuration",
            scope:this, id:"save"}
        ].concat(wincfg.tools);
      //~ wincfg.listeners = { show: ... };
  },
  init_containing_window : function(win) { 
    //~ console.log("20111206 install refresh");
    //~ win.on('show',this.refresh,this);
  },
  
  initComponent : function(){
    
    /* 
    Problem 20111206:
    When a GridPanel is the main item of the window, then it doesn't 
    have it's own header but uses the window's header bar.
    We must do this in initComponent because e.g. in beforerender 
    it's already to late: a header element has been created because 
    there was a title.
    But Lino.Window adds itself as `this.containing_window` 
    only after the GridPanel has been initialized.
    Workaround is to generate a line "params.containing_window = true;" 
    in the handler function.
    */ 
    //~ if (this.containing_window) {
    if (this.is_main_window) {
        //~ console.log(20111206, 'delete title',this.title,'from',this);
        //~ delete this.title;
        this.tools = undefined;  
        this.title = undefined;  /* simply deleting it 
          isn't enough because that would only 
          unhide the title defined in some base class. */
    } 
    //~ else console.log(20111206, 'dont delete title',this.title,'from',this);
    
    /* e.g. when slave gridwindow called from a permalink */
    //~ if (this.base_params) Ext.apply(bp,this.base_params);  
    //~ bp['fmt'] = 'json';
    
    //~ function on_proxy_write( proxy, action,data, response,rs,options) {
      //~ console.log('20120814 on_proxy_write',action,data,response)
      //~ this.getStore().doUpdate();
      //~ this.getStore().loadData(data);
    //~ }
    //~ function on_proxy_load( proxy, transactionObject, callbackOptions ) {
      //~ console.log('on_proxy_load',transactionObject)
    //~ }
    var proxy = new Ext.data.HttpProxy({ 
      // 20120814 
      url: '/api' + this.ls_url
      ,method: "GET"
      //~ ,url: ADMIN_URL + '/restful' + this.ls_url
      //~ ,restful: true 
      //~ ,listeners: {load:on_proxy_load} 
      //~ ,listeners: {write:on_proxy_write} 
    });
    //~ config.store = new Ext.data.JsonStore({ 
    //~ this.store = new Ext.data.ArrayStore({ 
    this.store = new Lino.GridStore({ 
      grid_panel: this
      ,listeners: { exception: Lino.on_store_exception }
      ,remoteSort: true
      ,totalProperty: "count"
      ,root: "rows"
      //~ ,id: "id" 
      ,proxy: proxy
      //~ autoLoad: this.containing_window ? true : false
      ,idIndex: this.pk_index
      //~ ,baseParams: bp
      ,fields: this.ls_store_fields
      ,idProperty: this.ls_id_property 
      // 20120814
      //~ ,writer : new Ext.data.JsonWriter({
        //~ writeAllFields: false
        //~ ,listful: true
      //~ })
      //~ ,restful : true
    });
      
    //~ console.log('config.pk_index',config.pk_index,config.store),
    delete this.ls_store_fields;
      
    var this_ = this;
    //~ var grid = this;
    this.store.on('load', function() {
        //~ console.log('20120814 GridStore.on(load)',this_.store);
        //~ var da = this_.store.reader.arrayData.disabled_actions;
        //~ if (da) {
            //~ this.cmenu.cascade(function(item){ 
              //~ console.log(20120531, item.itemId, da[item.itemId]);
              //~ if (da[item.itemId]) item.disable(); else item.enable();
            //~ });
        //~ };
        this_.set_param_values(this_.store.reader.arrayData.param_values);
        //~ this_.set_status(this_.store.reader.arrayData.status);
        //~ 20120918
        if (this_.store.reader.arrayData.no_data_text) {
            //~ this.viewConfig.emptyText = this_.store.reader.arrayData.no_data_text;
            this.getView().emptyText = this_.store.reader.arrayData.no_data_text;
            this.getView().refresh();
        }
        if (this_.containing_window)
            this_.set_window_title(this_.store.reader.arrayData.title);
            //~ this_.containing_window.setTitle(this_.store.reader.arrayData.title);
        if (!this.is_searching) { // disabled 20121025: quick_search_field may not lose focus
          this.is_searching = false;
          if (this_.selModel.getSelectedCell){
              if (this_.getStore().getCount()) // there may be no data
                  this_.selModel.select(0,0); 
          } else {
              this_.selModel.selectFirstRow();
              this_.getView().focusEl.focus();
          }
        } 
        //~ else console.log("is_searching -> no focussing");
        //~ var t = this.getTopToolbar();
        //~ var activePage = Math.ceil((t.cursor + t.pageSize) / t.pageSize);
        //~ this.quick_search_field.focus(); // 20121024
      }, this
    );
    var actions = Lino.build_buttons(this,this.ls_bbar_actions);
    //~ Ext.apply(config,Lino.build_buttons(this,config.ls_bbar_actions));
    //~ config.bbar, this.cmenu = Lino.build_buttons(this,config.ls_bbar_actions);
    //~ this.cmenu = new Ext.menu.Menu({items: config.bbar});
    delete this.ls_bbar_actions
    if (actions) {
        this.cmenu = actions.cmenu;
    }
    
    if (!this.hide_top_toolbar) {  
      var tbar = [ 
        this.quick_search_field = new Ext.form.TextField({ 
          //~ fieldLabel: "Search"
          listeners: { 
            scope:this_
            //~ ,change:this_.search_change
            
            ,render: Lino.quicktip_renderer("Quick Search","Enter a text to use as quick search filter")
            
            //~ ,keypress: this.search_keypress 
            ,blur: function() { this.is_searching = false}
          }
          ,validator:function(value) { return this_.search_validate(value) }
          //~ ,tooltip: "Enter a quick search text, then press TAB"
          //~ value: text
          //~ scope:this, 
          //~ ,enableKeyEvents: true
          //~ listeners: { keypress: this.search_keypress }, 
          //~ id: "seachString" 
      })];
      tbar = this.add_params_panel(tbar);
      tbar = tbar.concat([
        { scope:this, 
          //~ text: "[csv]", 
          tooltip: "Export this table to a .csv file", 
          iconCls: 'x-tbar-csv',
          handler: function() { 
            //~ 20130116 var p = Ext.apply({},this.get_base_params());
            //~ 20130116 p.fmt = 'csv';
            //~ url += "?" + Ext.urlEncode(p);
            var p = this.get_current_grid_config();
            Ext.apply(p,this.get_base_params());
            p.fmt = "csv";
            this.add_param_values(p);
            
            window.open('/api'+this.ls_url + "?" + Ext.urlEncode(p)) 
          } },
        //~ { scope:this, 
          //~ text: "[html]", 
          //~ handler: function() { 
            //~ var p = this.get_current_grid_config();
            //~ Ext.apply(p,this.get_base_params());
            //~ p.$ext_requests.URL_PARAM_FORMAT = "$ext_requests.URL_FORMAT_PRINTER";
            //~ this.add_param_values(p);
            //~ window.open(ADMIN_URL+'/api'+this.ls_url + "?" + Ext.urlEncode(p)) 
          //~ } },
        { scope:this, 
          //~ text: "[html]", 
          tooltip: "Show this table in plain html", 
          iconCls: 'x-tbar-html',
          handler: function() { 
            var p = this.get_current_grid_config();
            Ext.apply(p,this.get_base_params());
            //~ since 20121226 p.$ext_requests.URL_PARAM_FORMAT = "$ext_requests.URL_FORMAT_PLAIN";
            this.add_param_values(p);
            //~ since 20121226 window.open(ADMIN_URL+'/api'+this.ls_url + "?" + Ext.urlEncode(p)) 
            window.open('/plain'+this.ls_url + "?" + Ext.urlEncode(p)) 
          } },
        { scope:this, 
          //~ text: "[pdf]", 
          tooltip: "Show this table as a pdf document", 
          iconCls: 'x-tbar-pdf',
          handler: function() { 
            var p = this.get_current_grid_config();
            Ext.apply(p,this.get_base_params());
            p.fmt = "pdf";
            this.add_param_values(p);
            window.open('/api'+this.ls_url + "?" + Ext.urlEncode(p)) 
          } }
      ]);
    
    
      var menu = [];
      var set_gc = function(index) {
        return function() {
          //~ console.log('set_gc() 20100812');
          this.getColumnModel().setConfig(
              this.apply_grid_config(index,this.ls_grid_configs,this.ls_columns));
        }
      }
      for (var i = 0; i < this.ls_grid_configs.length;i++) {
        var gc = this.ls_grid_configs[i];
        menu.push({text:gc.label,handler:set_gc(i),scope:this})
      }
      if(menu.length > 1) {
        tbar = tbar.concat([
          { text:"View",
            menu: menu,
            tooltip:"Select another view of this report"
          }
        ]);
      }
      
      if (actions) {
        tbar = tbar.concat(actions.bbar);
          //~ this.bbar = actions.bbar;
      }
      
      this.tbar = new Ext.PagingToolbar({ 
        store: this.store, 
        prependButtons: true, 
        //~ pageSize: this.page_length, 
        pageSize: 1, 
        displayInfo: true, 
        beforePageText: "Page",
        afterPageText: "of {0}",
        displayMsg: "Displaying {0} - {1} of {2}",
        firstText: "Première page",
        lastText: "Dernière page",
        prevText: "Page précédente",
        nextText: "Page suivante",
        items: tbar
      });
      //~ this.on('resize', function(cmp,aw,ah,rw,rh) {
          //~ var ps = this.calculatePageSize();
          //~ if (ps && ps != this.getTopToolbar().pageSize) {
              //~ // console.log('20120203 resize : pageSize',this.getTopToolbar().pageSize,'->',ps);
              //~ // this.getTopToolbar().pageSize =  ps;
              //~ cmp.refresh();
              //~ // this.getTopToolbar().doRefresh();
          //~ }
        //~ }, this);
      //~ this.on('resize', function(cmp,aw,ah,rw,rh) {
          //~ cmp.getTopToolbar().pageSize = this.calculatePageSize(aw,ah,rw,rh) || 10;
          //~ cmp.refresh();
        //~ }, this, {delay:500});
    }
    
    //~ delete this.page_length
    
    
      
    if (this.ls_quick_edit) {
      this.selModel = new Ext.grid.CellSelectionModel()
      this.get_selected = function() {
        //~ console.log(this.getSelectionModel().selection);
        if (this.selModel.selection)
            return [ this.selModel.selection.record ];
        return [this.store.getAt(0)];
      };
      this.get_current_record = function() { 
        if (this.getSelectionModel().selection) 
          return this.selModel.selection.record;
        return this.store.getAt(0);
      };
    } else { 
      this.selModel = new Ext.grid.RowSelectionModel() 
      this.get_selected = function() {
        var sels = this.selModel.getSelections();
        if (sels.length == 0) sels = [this.store.getAt(0)];
        return sels
        //~ var sels = this.getSelectionModel().getSelections();
        //~ return Ext.pluck(sels,'id');
      };
      this.get_current_record = function() { 
        var rec = this.selModel.getSelected();
        if (rec == undefined) rec = this.store.getAt(0);
        return rec
      };
    };
    delete this.ls_quick_edit;
    
    this.columns  = this.apply_grid_config(this.gc_name,this.ls_grid_configs,this.ls_columns);
    
    //~ var grid = this;
    //~ this.colModel = new Ext.grid.ColumnModel({
      //~ columns: this.apply_grid_config(this.gc_name,this.ls_grid_configs,this.ls_columns),
      //~ isCellEditable: function(col, row) {
        //~ var record = grid.store.getAt(row);
        //~ console.log('20120514',col,record); // dataIndex
        //~ var dataIndex = grid.colModel.getDataIndex(col);
        //~ if (dataIndex in record.data['disabled_fields']) {
            //~ Lino.notify("$_("This field is disabled")");
            //~ return false;
        //~ }
        //~ return Ext.grid.ColumnModel.prototype.isCellEditable.call(this, col, row);
      //~ }
    //~ });    
    
    
    Lino.GridPanel.superclass.initComponent.call(this);
    
    //~ if (this.containing_window) 
        //~ this.on('afterlayout', this.refresh, this);
        //~ this.on('afterrender', this.refresh,this);
    //~ else
        //~ this.on('show', this.refresh,this);
    //~ this.on('afterlayout', function() {
      //~ if (this.id == "ext-comp-1157") 
        //~ console.log("20120213 afterlayout",this); 
      //~ // this.refresh();
      //~ },this);
    //~ this.on('afterrender', this.refresh);
    //~ this.on('resize', this.refresh,this,{delay:500});
    //~ this.on('resize', function(){console.log("20120213 resize",arguments)},this);
    this.on('resize', function(){
      //~ console.log("20120213 resize",arguments)
      this.refresh();
      },this);
    this.on('viewready', function(){
      //~ console.log("20120213 resize",arguments);
      this.view_is_ready = true;
      this.refresh();
      },this);
    this.on('afteredit', this.on_afteredit); // 20120814
    //~ this.on('afteredit', this.new_on_afteredit);
    this.on('beforeedit', this.on_beforeedit);
    this.on('beforeedit',function(e) { this.before_row_edit(e.record)},this);
    this.on('cellcontextmenu', Lino.cell_context_menu, this);
    //~ this.on('contextmenu', Lino.grid_context_menu, this);
    
    
    //~ if (this.id == "ext-comp-1157") captureEvents(this);    
    
  },
  
  //~ onResize : function(){
      //~ console.log("20120206 GridPanel.onResize",arguments);
      //~ Lino.GridPanel.superclass.onResize.apply(this, arguments);
      //~ this.refresh();
  //~ },
  
  
  get_status : function(){
    var st = { base_params : this.get_base_params()};
    if (!this.hide_top_toolbar) {
        st.current_page = this.getTopToolbar().current;
    }
    st.param_values = this.status_param_values;
    //~ console.log("20120213 GridPanel.get_status",st);
    return st;
  },
  
  /* 
  Lino.GridPanel.set_status() 
  */
  set_status : function(status){
    //~ console.log("20120918 GridPanel.set_status",status);
    this.clear_base_params();
    if (status == undefined) status = {};
    this.set_param_values(status.param_values);
    if (status.base_params) { 
      this.set_base_params(status.base_params);
    }
    if (!this.hide_top_toolbar) {
      //~ console.log("20120213 GridPanel.getTopToolbar().changePage",
          //~ status.current_page || 1);
      this.getTopToolbar().changePage(status.current_page || 1);
    }
    //~ this.fireEvent('resize');
    //~ this.refresh.defer(100,this); 
    //~ this.onResize.defer(100,this); 
    //~ this.refresh(); 
    //~ this.doLayout(); 
    //~ this.onResize(); 
    //~ this.store.load();
  },
  
  refresh : function(unused) { 
    this.refresh_with_after();
  },
  refresh_with_after : function(after) { 
    //~ Lino.notify('20120204 Lino.GridPanel.refresh');
    //~ Lino.notify('Lino.GridPanel.refresh '+this.store.proxy.url);
    //~ var bp = { fmt:'json' }
    if (this.containing_panel) {
        //~ Ext.apply(p,this.master_panel.get_master_params());
        //~ Ext.apply(options.params,this.containing_panel.get_master_params());
        this.set_base_params(this.containing_panel.get_master_params());
    }
    
    if (! this.view_is_ready) return;
    
    var options = {};
    if (after) {
        options.callback = function(r,options,success) {if(success) after()}
    }
      
    //~ if (!this.rendered) {
        //~ console.log("20120206 GridPanel.refresh() must wait until rendered",options);
        //~ this.grid_panel.on('render',this.load.createDelegate(this,options))
        //~ return;
    //~ }
    
    this.store.load(options);
  },
  
  /* pageSize depends on grid height (Trying to remove scrollbar)
  Thanks to 
  - Christophe Badoit on http://www.sencha.com/forum/showthread.php?82647
  - http://www.sencha.com/forum/archive/index.php/t-37231.html
  */
  calculatePageSize : function(second_attempt) {
    //~ if (!this.rendered) { 
    if (!this.view_is_ready) { 
      //~ console.log('Cannot calculatePageSize() : not rendered');
      return false; }
    //~ if (!this.isVisible()) { 
      //~ console.log('calculatePageSize : not visible');
      //~ return false; }
      
    //~ console.log('getFrameHeight() is',this.getFrameHeight());
    //~ console.log('getView().scroller.getHeight() is',this.getView().scroller.getHeight());
    //~ console.log('mainBody.getHeight() is',this.getView().mainBody.getHeight());
    //~ console.log('getInnerHeight() is',this.getInnerHeight());
    //~ console.log('getHeight() is',this.getHeight());
    //~ console.log('el.getHeight() is',this.getEl().getHeight());
    //~ console.log('getGridEl().getHeight() is',this.getGridEl().getHeight());
    //~ console.log('getOuterSize().height is',this.getOuterSize().height);
    //~ console.log('getBox().height is',this.getBox().height);
    //~ console.log('getResizeEl.getHeight() is',this.getResizeEl().getHeight());
    //~ console.log('getLayoutTarget().getHeight() is',this.getLayoutTarget().getHeight());
      
    var rowHeight = this.getFrameHeight();
    //~ var rowHeight = 52; // experimental value
    var row = this.view.getRow(0);
    if (row) {
      //~ console.log('20120213 yes');
      rowHeight = Ext.get(row).getHeight();
    }
    //~ console.log('rowHeight is ',rowHeight,this,caller);
    //~ this.getView().syncScroll();
    //~ this.getView().initTemplates();
    var height = this.getView().scroller.getHeight();
    //~ console.log('getView().scroller.getHeight() is',this.getView().scroller.getHeight());
    //~ console.log('getInnerHeight() - getFrameHeight() is',
      //~ this.getInnerHeight(), '-',
      //~ this.getFrameHeight(), '=',
      //~ this.getInnerHeight() - this.getFrameHeight());
    //~ var height = this.getView().mainBody.getHeight();
    //~ var height = this.getView().mainWrap.getHeight();
    //~ var height = this.getView().resizeMarker.getHeight();
    //~ this.syncSize();
    //~ var height = this.getInnerHeight() - this.getFrameHeight();
    //~ var height = this.getHeight() - this.getFrameHeight();
    height -= Ext.getScrollBarWidth(); // leave room for a possible horizontal scrollbar... 
    //~ height -= this.getView().scrollOffset;
    var ps = Math.floor(height / rowHeight);
    //~ console.log('20120203 calculatePageSize():',height,'/',rowHeight,'->',ps);
    ps -= 1; // leave room for a possible phantom row
    //~ return (ps > 1 ? ps : false);
    if (ps > 1) return ps;
    //~ console.log('calculatePageSize() found less than 1 row:',height,'/',rowHeight,'->',ps);
    //~ foo.bar = baz; // 20120213
    return 5; // preview_limit
    //~ if (second_attempt) {
        //~ console.log('calculatePageSize() abandons after second attempt:',
          //~ height,'/',rowHeight,'->',ps);
      //~ return 5;
    //~ }
    //~ return this.calculatePageSize.defer(500,this,[true]);
  },
  
  onCellDblClick : function(grid, row, col){
      //~ console.log("20120307 onCellDblClick",this,grid, row, col);
      if (this.ls_detail_handler) {
          //~ Lino.notify('show detail');
          Lino.show_detail(this);
          return false;
      }else{
        //~ console.log('startEditing');
        this.startEditing(row,col);
      }
  },
  
  get_base_params : function() {
    //~ return this.containing_window.config.base_params;
    //~ console.log(20120717,this.store.baseParams);
    var p = Ext.apply({},this.store.baseParams);
    Lino.insert_subst_user(p);
    //~ console.log("20120717 GRidPanel.get_base_params() returns",p);
    return p;
    //~ return this.store.baseParams;
  },
  set_base_params : function(p) {
    //~ console.log('GridPanel.set_base_params',p)
    for (k in p) this.store.setBaseParam(k,p[k]);
    //~ this.store.baseParams = p;
    if (p.query) 
        this.quick_search_field.setValue(p.query);
    //~ if (p.param_values) 
        //~ this.set_param_values(p.param_values);  
  },
  clear_base_params : function() {
      this.store.baseParams = {};
      Lino.insert_subst_user(this.store.baseParams);
  },
  set_base_param : function(k,v) {
    this.store.setBaseParam(k,v);
  },
  
  //~ get_permalink_params : function() {
    //~ var p = {};
    //~ return p;
  //~ },
  
  before_row_edit : function(record) {},
    
  //~ search_keypress : function(){
    //~ console.log("2012124 search_keypress",arguments);
  //~ },
  search_validate : function(value) {
    if (value == this.quick_search_text) return true;
    this.is_searching = true;
    //~ console.log('search_validate',value)
    this.quick_search_text = value;
    this.set_base_param('query',value); 
    //~ this.getTopToolbar().changePage(1);
    this.getTopToolbar().moveFirst();
    //~ this.refresh();
    return true;
  },
  
  search_change : function(field,oldValue,newValue) {
    //~ console.log('search_change',field.getValue(),oldValue,newValue)
    this.set_base_param('query',field.getValue()); 
    this.getTopToolbar().moveFirst();
    //~ this.refresh();
  },
  
  apply_grid_config : function(index,grid_configs,rpt_columns) {
    //~ var rpt_columns = this.ls_columns;
    var gc = grid_configs[index];    
    //~ console.log('apply_grid_config() 20100812',name,gc);
    this.gc_name = index;
    if (gc == undefined) {
      return rpt_columns;
      //~ config.columns = config.ls_columns;
      //~ return;
    } 
    //~ delete config.ls_filters
    
    //~ console.log(20100805,config.ls_columns);
    var columns = Array(gc.columns.length);
    for (var j = 0; j < rpt_columns.length;j++) {
      var col = rpt_columns[j];
      for (var i = 0; i < gc.columns.length; i++) {
        if (col.dataIndex == gc.ci[i]) {
          col.width = gc.cw[i];
          col.hidden = gc.ch[i];
          columns[i] = col;
          break;
        }
      }
    }
    
    //~ var columns = Array(rpt_columns.length);
    //~ for (var i = 0; i < rpt_columns.length; i++) {
      //~ columns[i] = rpt_columns[gc.columns[i]];
      //~ columns[i].width = gc.widths[i];
    //~ }
    
    //~ if (gc.hidden_cols) {
      //~ for (var i = 0; i < gc.hidden_cols.length; i++) {
        //~ var hc = gc.hidden_cols[i];
        //~ for (var j = 0; j < columns.length;j++) {
          //~ var col = columns[j];
          //~ if (col.dataIndex == hc) {
            //~ col.hidden = true;
            //~ break
          //~ }
        //~ }
      //~ }
    //~ }
    if (gc.filters) {
      //~ console.log(20100811,'config.ls_filters',config.ls_filters);
      //~ console.log(20100811,'config.ls_grid_config.filters',config.ls_grid_config.filters);
      for (var i = 0; i < gc.filters.length; i++) {
        var fv = gc.filters[i];
        for (var j = 0; j < columns.length;j++) {
          var col = columns[j];
          if (col.dataIndex == fv.field) {
            //~ console.log(20100811, f,' == ',fv);
            if (fv.type == 'string') {
              col.filter.value = fv.value;
              //~ if (fv.comparison !== undefined) f.comparison = fv.comparison;
            } else {
              //~ console.log(20100811, fv);
              col.filter.value = {};
              col.filter.value[fv.comparison] = fv.value;
            }
            break;
          }
        };
      }
    }
    
    return columns;
    //~ config.columns = cols;
    //~ delete config.ls_columns
  },
  
  get_current_grid_config : function () {
    var cm = this.getColumnModel();
    var widths = Array(cm.config.length);
    var hiddens = Array(cm.config.length);
    //~ var hiddens = Array(cm.config.length);
    var columns = Array(cm.config.length);
    //~ var columns = Array(cm.config.length);
    //~ var hidden_cols = [];
    //~ var filters = this.filters.getFilterValues();
    var p = this.filters.buildQuery(this.filters.getFilterData())
    for (var i = 0; i < cm.config.length; i++) {
      var col = cm.config[i];
      columns[i] = col.dataIndex;
      //~ hiddens[i] = col.hidden;
      widths[i] = col.width;
      hiddens[i] = col.hidden;
      //~ if (col.hidden) hidden_cols.push(col.dataIndex);
    }
    //~ p['hidden_cols'] = hidden_cols;
    p.cw = widths;
    p.ch = hiddens;
    p.ci = columns;
    //~ p['widths'] = widths;
    //~ p['hiddens'] = hiddens;
    //~ p['columns'] = columns;
    p['name'] = this.gc_name;
    //~ var gc = this.ls_grid_configs[this.gc_name];
    //~ if (gc !== undefined) 
        //~ p['label'] = gc.label
    //~ console.log('20100810 save_grid_config',p);
    return p;
  },
  
  unused_manage_grid_configs : function() {
    var data = [];
    for (k in this.ls_grid_configs) {
      var v = this.ls_grid_configs[k];
      var i = [k,String(v.columns),String(v.hidden_cols),String(v.filters)];
      data.push(i)
    }
    if (this.ls_grid_configs[this.gc_name] == undefined) {
      var v = this.get_current_grid_config();
      var i = [k,String(v.columns),String(v.hidden_cols),String(v.filters)];
      data.push(i);
    }
    //~ console.log(20100811, data);
    var main = new Ext.grid.GridPanel({
      store: new Ext.data.ArrayStore({
        idIndex:0,
        fields:['name','columns','hidden_cols','filters'],
        autoDestroy:true,
        data: data}),
      //~ autoHeight:true,
      selModel: new Ext.grid.RowSelectionModel(),
      listeners: { 
        rowdblclick: function(grid,rowIndex,e) {
          console.log('row doubleclicked',grid, rowIndex,e);
        },
        rowclick: function(grid,rowIndex,e) {
          console.log('row clicked',grid, rowIndex,e);
        }
      },
      columns: [ 
        {dataIndex:'name',header:'Name'}, 
        {dataIndex:'columns',header:'columns'}, 
        {dataIndex:'hidden_cols',header:'hidden columns'}, 
        {dataIndex:'filters',header:'filters'} 
      ]
    });
    var win = new Ext.Window({title:'GridConfigs Manager',layout:'fit',items:main,height:200});
    win.show();
  },
  
  unused_edit_grid_config : function(name) {
    gc = this.ls_grid_configs[name];
    var win = new Ext.Window({
      title:'Edit Grid Config',layout:'vbox', 
      //~ layoutConfig:'stretch'
      items:[
        {xtype:'text', value: gc.name},
        {xtype:'text', value: gc.columns},
        {xtype:'text', value: gc.hidden_cols},
        {xtype:'text', value: gc.filters}
      ]
    });
    win.show();
  },
  
  save_grid_config : function () {
    //~ console.log('TODO: save_grid_config',this);
    //~ p.column_widths = Ext.pluck(this.colModel.columns,'width');
    var a = { 
      params:this.get_current_grid_config(), 
      method:'PUT',
      url:'/grid_config' + this.ls_url,
      success: Lino.action_handler(this),
      scope: this,
      failure: Lino.ajax_error_handler(this)
    };
    this.loadMask.show(); // 20120211
    Ext.Ajax.request(a);
    //~ Lino.do_action(this,a);
  },
  
  on_beforeedit : function(e) {
    //~ console.log('20130128 GridPanel.on_beforeedit()',e,e.record.data.disable_editing);
    if(this.disable_editing | e.record.data.disable_editing) {
      e.cancel = true;
      Lino.notify("This record is disabled");
      return;
    }
    if(e.record.data.disabled_fields && e.record.data.disabled_fields[e.field]) {
      e.cancel = true;
      Lino.notify("This field is disabled");
      return;
    }
    //~ if (e.record.data.disabled_fields) {
      //~ for (i in e.record.data.disabled_fields) {
        //~ if(e.record.data.disabled_fields[i] == e.field) {
          //~ e.cancel = true;
          //~ Lino.notify(String.format('Field "{0}" is disabled for this record',e.field));
          //~ return
        //~ }
      //~ }
    //~ }
  },
  save_grid_data : function() {
      //~ console.log("20120814 save_grid_data");
      this.getStore().commitChanges();
  },
  new_on_afteredit : function(e) {
      //~ this.getStore().commitChanges();
      //~ this.getStore().doUpdate();
      //~ this.getStore().loadData(data);
      console.log("20120814 new_on_afteredit",e);
  },
  on_afteredit : function(e) {
    /*
    e.grid - The grid that fired the event
    e.record - The record being edited
    e.field - The field name being edited
    e.value - The value being set
    e.originalValue - The original value for the field, before the edit.
    e.row - The grid row index
    e.column - The grid column index
    */
    var p = {};
    //~ console.log('20101130 modified: ',e.record.modified);
    //~ console.log('20101130 value: ',e.value);
    //~ var p = e.record.getChanges();
    //~ console.log('20101130 getChanges: ',e.record.getChanges());
    //~ this.before_row_edit(e.record);
    for(k in e.record.getChanges()) {
        var v = e.record.get(k);
    //~ for(k in e.record.modified) {
        //~ console.log('20101130',k,'=',v);
        //~ var cm = e.grid.getColumnModel();
        //~ var di = cm.getDataIndex(k);
        var f = e.record.fields.get(k);
        //~ console.log('20101130 f = ',f);
        //~ var v = e.record.get(di);
        if (f.type.type == 'date') {
            p[k] = Ext.util.Format.date(v, f.dateFormat);
        }else{
            p[k] = v;
            var v = e.record.get(k+'Hidden');
            if (v !== undefined) {
              p[k+'Hidden'] = v;
            }
        }
        //~ var i = cm.findColumnIndex(k);
        //~ var r = cm.getRenderer(i);
        //~ var editor = cm.getCellEditor(i,e.row);
        //~ var col = e.grid.getColumnModel().getColumnById(k);
        //~ console.log('20101130 r = ',r(v));
        //~ var f = e.record.fields[k];
        //~ console.log('20101130 f = ',f);
        //~ console.log('20101130 editor = ',editor);
        //~ p[k] = f.getValue();
        //~ p[k] = r(v);
    }
    //~ console.log('20101130 p:',p);
    //~ var cm = e.grid.getColumnModel();
    //~ var di = cm.getDataIndex(e.column);
    //~ var f = e.record.fields.get(di);
    //~ console.log('20101130 f = ',f);
    //~ if (f.type.type == 'date') e.record.set(di,Ext.util.Format.date(e.value, f.dateFormat));
    
    
    //~ var p = e.record.data;
    
    // var p = {};
    //~ p['grid_afteredit_colname'] = e.field;
    //~ p[e.field] = e.value;
    //~ console.log('20100723 GridPanel.on_afteredit()',e);
    // add value used by ForeignKeyStoreField CHOICES_HIDDEN_SUFFIX
    // not sure whether this is still needed:
    p[e.field+'Hidden'] = e.value;
    //~ p.su = Lino.subst_user;
    Lino.insert_subst_user(p);
    // this one is needed so that this field can serve as choice context:
    e.record.data[e.field+'Hidden'] = e.value;
    // p[pk] = e.record.data[pk];
    // console.log("grid_afteredit:",e.field,'=',e.value);
    Ext.apply(p,this.get_base_params()); // needed for POST, ignored for PUT
    //~ Ext.apply(p,this.containing_window.config.base_params);
    //~ 20121109 p['$ext_requests.URL_PARAM_ACTION_NAME'] = 'grid';
    var self = this;
    var req = {
        params:p,
        waitMsg: 'Saving your data...',
        success: Lino.action_handler( this, function(result) {
          //~ if (result.data_record) {
          if (result.refresh_all) {
              var cw = self.get_containing_window();
              if (cw) {
                  cw.main_item.refresh();
              }
              else console.log("20120123 cannot refresh_all",self);
          } else if (result.rows) {
              //~ self.getStore().loadData(result,true);
              var r = self.getStore().reader.readRecords(result);
              if (e.record.phantom) {
                  //~ console.log("20120816 afteredit.success POST",r);
                  self.getStore().insert(e.row,r.records);
              }else{
                  //~ console.log("20120816 afteredit.success PUT",r);
                  self.getStore().doUpdate(r.records[0]);
              }
              self.getStore().rejectChanges(); /* 
              get rid of the red triangles without saving the record again
              */
              //~ self.getStore().commitChanges(); // get rid of the red triangles
          } else {
              self.getStore().commitChanges(); // get rid of the red triangles
              self.getStore().reload();        // reload our datastore.
          }
          }),
        scope: this,
        failure: Lino.ajax_error_handler(this)
    };
    if (e.record.phantom) {
      req.params.an = 'post'; // SubmitInsert.action_name
      Ext.apply(req,{
        method: 'POST',
        url: '/api' + this.ls_url
      });
    } else {
      req.params.an = 'put'; // SubmitDetail.action_name
      Ext.apply(req,{
        method: 'PUT',
        url: '/api' + this.ls_url + '/' + e.record.id
      });
    }
    //~ console.log('20110406 on_afteredit',req);
    this.loadMask.show(); // 20120211
    Ext.Ajax.request(req);
  },

  afterRender : function() {
    Lino.GridPanel.superclass.afterRender.call(this);
    // this.getView().mainBody.focus();
    // console.log(20100114,this.getView().getRows());
    // if (this.getView().getRows().length > 0) {
    //  this.getView().focusRow(1);
    // }
    //~ this.my_load_mask = new Ext.LoadMask(this.getEl(), {
        //~ msg:'$_("Please wait...")',
        //~ store:this.store});
      
    var tbar = this.getTopToolbar();
    // tbar.on('change',function() {this.getView().focusRow(1);},this);
    // tbar.on('change',function() {this.getSelectionModel().selectFirstRow();this.getView().mainBody.focus();},this);
    // tbar.on('change',function() {this.getView().mainBody.focus();},this);
    // tbar.on('change',function() {this.getView().focusRow(1);},this);
    this.nav = new Ext.KeyNav(this.getEl(),{
      pageUp: function() {tbar.movePrevious(); },
      pageDown: function() {tbar.moveNext(); },
      home: function() {tbar.moveFirst(); },
      end: function() {tbar.moveLast(); },
      scope: this
    });
  },
  after_delete : function() {
    //~ console.log('Lino.GridPanel.after_delete');
    this.refresh();
  },
  add_row_listener : function(fn,scope) {
    this.getSelectionModel().addListener('rowselect',fn,scope);
  },
  postEditValue : function(value, originalValue, r, field){
    value = Lino.GridPanel.superclass.postEditValue.call(this,value,originalValue,r,field);
    //~ console.log('GridPanel.postEdit()',value, originalValue, r, field);
    return value;
  },
  
  set_start_value : function(v) {
      this.start_value = v;
  },
  preEditValue : function(r, field){
      if (this.start_value) {
        var v = this.start_value;
        delete this.start_value;
        this.activeEditor.selectOnFocus = false;
        return v;
      }
      var value = r.data[field];
      return this.autoEncode && Ext.isString(value) ? Ext.util.Format.htmlDecode(value) : value;
  },
  
  on_master_changed : function() {
    //~ if (! this.enabled) return;
    //~ cmp = this;
    //~ console.log('Lino.GridPanel.on_master_changed()',this.title);
    if (! this.rendered) return; // 20120213
    var todo = function() {
      if (this.disabled) return;
      //~ if (this.disabled) return;
      //~ if (this.enabled) {
          //~ var src = caller.config.url_data + "/" + record.id + ".jpg"
          //~ console.log(20111125, this.containing_window);
          //~ for (k in p) this.getStore().setBaseParam(k,p[k]);
          //~ console.log('Lino.GridPanel.on_master_changed()',this.title,p);
          this.refresh();
          //~ this.set_base_params(this.master_panel.get_master_params());
          //~ this.getStore().load(); 
      //~ }
    };
    Lino.do_when_visible(this,todo.createDelegate(this));
  }
});
  

//~ Lino.MainPanelMixin = {
  //~ tbar_items : function() {
      //~ return ;
  //~ }
//~ };

//~ Ext.override(Lino.GridPanel,Lino.MainPanelMixin);
//~ Ext.override(Lino.FormPanel,Lino.MainPanelMixin);

//~ Lino.grid_context_menu = function(e) {
  //~ console.log('contextmenu',arguments);
//~ }

Lino.cell_context_menu = function(grid,row,col,e) {
  //~ console.log('20120531 cellcontextmenu',grid,row,col,e,grid.store.reader.arrayData.rows[row]);
  e.stopEvent();
  //~ grid.getView().focusCell(row,col);
  grid.getSelectionModel().select(row,col);
  //~ console.log(grid.store.getAt(row));
  //~ grid.getView().focusRow(row);
  //~ return;
  if(!grid.cmenu.el){grid.cmenu.render(); }
  //~ if(e.record.data.disabled_fields) {
  
  var da = grid.store.reader.arrayData.rows[row][grid.disabled_actions_index];
  if (da) {
      this.cmenu.cascade(function(item){ 
        //~ console.log(20120531, item.itemId, da[item.itemId]);
        if (da[item.itemId]) item.disable(); else item.enable();
      });
  };
  
  var xy = e.getXY();
  xy[1] -= grid.cmenu.el.getHeight();
  grid.cmenu.showAt(xy);
}


//~ Lino.load_main_menu = function() {
  //~ Ext.Ajax.request({
    //~ waitMsg: 'Loading main menu...',
    //~ method: 'GET',
    //~ url: '/menu',
    //~ success: Lino.on_load_menu,
    //~ failure: Lino.ajax_error_handler
  //~ });
//~ };



//~ Lino.SlavePlugin = function(caller) {
  //~ this.caller = caller;
//~ };

Lino.chooser_handler = function(combo,name) {
  return function(cmp,newValue,oldValue) {
    //~ console.log('Lino.chooser_handler()',cmp,oldValue,newValue);
    combo.setContextValue(name,newValue);
  }
};



Lino.ComboBox = Ext.extend(Ext.form.ComboBox,{
  forceSelection: true,
  triggerAction: 'all',
  minListWidth:230,
  autoSelect: false,
  selectOnFocus: true, // select any existing text in the field immediately on focus.
  submitValue: true,
  displayField: 'text', // 'text', 
  valueField: 'value', // 'value',
  
  //~ initComponent : Ext.form.ComboBox.prototype.initComponent.createSequence(function() {
  initComponent : function(){
      this.contextParams = {};
      //~ Ext.form.ComboBox.initComponent(this);
      Lino.ComboBox.superclass.initComponent.call(this);
  },
  setValue : function(v,record_data){
      /*
      Based on feature request developed in http://extjs.net/forum/showthread.php?t=75751
      */
      /* `record_data` is used to get the text corresponding to this value */
      //~ if(this.name == 'city') 
      //~ console.log('20120203', this.name,'.setValue(', v ,') this=', this,'record_data=',record_data);
      var text = v;
      if(this.valueField){
        if(v == null || v == '') { 
            //~ if (this.name == 'birth_country') 
                //~ console.log(this.name,'.setValue',v,'no lookup needed, value is empty');
            //~ v = undefined;
            v = '';
            //~ text = '';
        } else if (Ext.isDefined(record_data)) {
          text = record_data[this.name];
          //~ if (this.name == 'birth_country') 
            //~ console.log(this.name,'.setValue',v,'got text ',text,' from record ',record);
        } else {
          // if(this.mode == 'remote' && !Ext.isDefined(this.store.totalLength)){
          if(this.mode == 'remote' && ( this.lastQuery === null || (!Ext.isDefined(this.store.totalLength)))){
              //~ if (this.name == 'birth_country') console.log(this.name,'.setValue',v,'store not yet loaded');
              this.store.on('load', this.setValue.createDelegate(this, arguments), null, {single: true});
              if(this.store.lastOptions === null || this.lastQuery === null){
                  var params;
                  if(this.valueParam){
                      params = {};
                      params[this.valueParam] = v;
                  }else{
                      var q = this.allQuery;
                      this.lastQuery = q;
                      this.store.setBaseParam(this.queryParam, q);
                      params = this.getParams(q);
                  }
                  //~ if (this.name == 'birth_country') 
                    //~ console.log(this.name,'.setValue',v,' : call load() with params ',params);
                  this.store.load({params: params});
              //~ }else{
                  //~ if (this.name == 'birth_country') 
                    //~ console.log(this.name,'.setValue',v,' : but store is loading',this.store.lastOptions);
              }
              return;
          //~ }else{
              //~ if (this.name == 'birth_country') 
                //~ console.log(this.name,'.setValue',v,' : store is loaded, lastQuery is "',this.lastQuery,'"');
          }
          var r = this.findRecord(this.valueField, v);
          if(r){
              text = r.data[this.displayField];
          }else if(this.valueNotFoundText !== undefined){
              text = this.valueNotFoundText;
          }
        }
      }
      this.lastSelectionText = text;
      //~ this.lastSelectionText = v;
      if(this.hiddenField){
          //~ this.hiddenField.originalValue = v;
          this.hiddenField.value = v;
      }
      Ext.form.ComboBox.superclass.setValue.call(this, text);
      this.value = v; // needed for grid.afteredit
  },
  
  getParams : function(q){
    // p = Ext.form.ComboBox.superclass.getParams.call(this, q);
    // causes "Ext.form.ComboBox.superclass.getParams is undefined"
    var p = {};
    //p[this.queryParam] = q;
    if(this.pageSize){
        //~ p.start = 0;
        //~ p.limit = this.pageSize;
        p['start'] = 0;
        p['limit'] = this.pageSize;
    }
    // now my code:
    if(this.contextParams) Ext.apply(p,this.contextParams);
    //~ if(this.contextParams && this.contextValues) {
      //~ for(i = 0; i <= this.contextParams.length; i++)
        //~ p[this.contextParams[i]] = this.contextValues[i];
    //~ }
    return p;
  },
  setContextValue : function(name,value) {
    //~ console.log('setContextValue',this,this.name,':',name,'=',value);
    //~ if (this.contextValues === undefined) {
        //~ this.contextValues = Array(); // this.contextParams.length);
    //~ }
    if (this.contextParams[name] != value) {
      //~ console.log('setContextValue 1',this.contextParams);
      this.contextParams[name] = value;
      this.lastQuery = null;
      //~ console.log('setContextValue 2',this.contextParams);
    }
  }
});

Lino.ChoicesFieldElement = Ext.extend(Lino.ComboBox,{
  mode: 'local'
});


Lino.SimpleRemoteComboStore = Ext.extend(Ext.data.JsonStore,{
  forceSelection: true,
  constructor: function(config){
      Lino.SimpleRemoteComboStore.superclass.constructor.call(this, Ext.apply(config, {
          totalProperty: 'count',
          root: 'rows',
          id: 'value', // ext_requests.CHOICES_VALUE_FIELD
          fields: ['value' ], // ext_requests.CHOICES_VALUE_FIELD, // ext_requests.CHOICES_TEXT_FIELD
          listeners: { exception: Lino.on_store_exception }
      }));
  }
});

Lino.ComplexRemoteComboStore = Ext.extend(Ext.data.JsonStore,{
  constructor: function(config){
      Lino.ComplexRemoteComboStore.superclass.constructor.call(this, Ext.apply(config, {
          totalProperty: 'count',
          root: 'rows',
          id: 'value', // ext_requests.CHOICES_VALUE_FIELD
          fields: ['value','text'], // ext_requests.CHOICES_VALUE_FIELD, // ext_requests.CHOICES_TEXT_FIELD
          listeners: { exception: Lino.on_store_exception }
      }));
  }
});

Lino.RemoteComboFieldElement = Ext.extend(Lino.ComboBox,{
  mode: 'remote',
  //~ forceSelection:false,
  minChars: 2, // default 4 is too much
  queryDelay: 300, // default 500 is maybe slow
  queryParam: 'query', 
  //~ typeAhead: true,
  //~ selectOnFocus: true, // select any existing text in the field immediately on focus.
  resizable: true
});

/*
Thanks to Animal for posting the basic idea:
http://www.sencha.com/forum/showthread.php?15842-2.0-SOLVED-Combobox-twintrigger-clear&p=76130&viewfull=1#post76130

*/
Lino.TwinCombo = Ext.extend(Lino.RemoteComboFieldElement,{
    trigger2Class : 'x-form-search-trigger',
    //~ trigger2Class : 'x-tbar-detail',
    initComponent : function() {
        //~ Lino.TwinCombo.superclass.initComponent.call(this);
        Lino.ComboBox.prototype.initComponent.call(this);
        Ext.form.TwinTriggerField.prototype.initComponent.call(this);
    },
    onTrigger2Click : function() {
        //~ console.log('onTrigger2Click',this,arguments);
    }
  });
//~ Lino.TwinCombo.prototype.initComponent = Ext.form.TwinTriggerField.prototype.initComponent;
Lino.TwinCombo.prototype.getTrigger = Ext.form.TwinTriggerField.prototype.getTrigger;
Lino.TwinCombo.prototype.getOuterSize = Ext.form.TwinTriggerField.prototype.getOuterSize;
Lino.TwinCombo.prototype.initTrigger = Ext.form.TwinTriggerField.prototype.initTrigger;
Lino.TwinCombo.prototype.onTrigger1Click = Ext.form.ComboBox.prototype.onTriggerClick;
//~ Lino.TwinCombo.prototype.onTrigger2Click = function() {
    //~ console.log('onTrigger2Click',arguments);
//~ };



Lino.SimpleRemoteComboFieldElement = Ext.extend(Lino.RemoteComboFieldElement,{
  displayField: 'value', 
  valueField: null,
  forceSelection: false
});




Lino.Window = Ext.extend(Ext.Window,{
  //~ layout: "fit", 
  closeAction : 'hide',
  renderTo: 'main_area', 
  constrain: true,
  maximized: true,
  draggable: false,
  width: 700,
  height: 500,
  maximizable: false,
  constructor : function (config) {
    if (config.main_item.params_panel) {
        config.layout = 'border';
        config.main_item.region = 'center';
        config.main_item.params_panel.region = 'north';
        config.main_item.params_panel.hidden = config.main_item.params_panel_hidden;
        config.items = [config.main_item.params_panel, config.main_item];
    } else {
        config.layout = 'fit';
        config.items = config.main_item;
    }
    this.main_item = config.main_item; 
    
    delete config.main_item;
    //~ delete config.params_item;
    
    //~ this.main_item = config.items.get(0);
    this.main_item.containing_window = this;
    
    //~ console.log('20120110 Lino.Window.constructor() 1');
    //~ if (Lino.current_window) { // all windows except the top are closable
    if (this.main_item.hide_window_title) { 
      config.closable = false;
      config.frame = false;
      config.shadow = false;
      //~ config.border = true;
      //~ config.title = undefined;
      //~ config.tools = null;
      delete config.title;
      delete config.tools;
    } else {
      config.title = this.main_item.empty_title;
      config.closable = true;
      config.tools = [ 
        { qtip: 'permalink', handler: Lino.permalink_handler(this), id: "pin" }
      ];
      if (this.main_item.content_type && this.main_item.action_name != 'insert') {
        config.tools = [ {
          handler: Lino.help_text_editor,
          qtip: "Edit help texts for fields on this model.",
          scope: this.main_item,
          id: "gear"
        }].concat(config.tools);
      }
        
    //~ { qtip: '', handler: Lino.save_wc_handler(this), id: "save" }, 
    //~ { qtip: this.config.qtip, handler: Lino.save_wc_handler(this), id: "save" }, 
    //~ { qtip: 'Call doLayout() on main Container.', handler: Lino.refresh_handler(this), id: "refresh" },
    //~ if (this.main_item.params_panel) {
        //~ config.tools = config.tools.concat([ 
          //~ { qtip: 'Show/hide parameter panel', handler: this.toggle_params_panel, id: "gear", scope:this } 
        //~ ]);
    //~ }
    //~ if (config.closable !== false) {
      // if undefined, will take default behaviour
      //~ config.tools = config.tools.concat([ 
        //~ { qtip: 'close', handler: this.hide, id: "close", scope:this } 
      //~ ]);
    }
    
    this.main_item.config_containing_window(config);
    
    //~ console.log('20120110 Lino.Window.constructor() 2');
    Lino.Window.superclass.constructor.call(this,config);
    
    //~ console.log('20120110 Lino.Window.constructor() 3');
    
  },
  initComponent : function() {
    this.main_item.init_containing_window(this);
    Lino.Window.superclass.initComponent.call(this);
  
  },
  hide : function() { 
      this.main_item.do_when_clean(false,function() { 
        Lino.close_window(); });
  },
  hide_really : function() { 
    Lino.Window.superclass.hide.call(this);
  },
  onRender : function(ct, position){
    //~ console.log('20120110 Lino.Window.onRender() 1');
    Lino.Window.superclass.onRender.call(this, ct, position);
    var main_area = Ext.getCmp('main_area')
    //~ console.log('20120110 Lino.Window.onRender() 2');
  
    this.on('show', function(win) {
        //~ console.log('20120110 Lino.Window.on show 1');
        main_area.on('resize', win.onWindowResize, win);
    });
    this.on('hide', function(win) {
        main_area.un('resize', win.onWindowResize, win);
    });
    //~ console.log('20120110 Lino.Window.onRender() 3');
  }
});


Lino.unused_ParamWindow = Ext.extend(Lino.Window,{
  //~ layout: "border", 
  constructor : function (config) {
    Lino.ParamWindow.superclass.constructor.call(this,config);
    this.main_item = config.items; // `items` must be a single component
    config.layout = 'border';
    this.main_item.region = 'center';
    config.params.region = 'north';
    config.items = [config.params, config.items];
    //~ delete config.params;
  }
});




(function(){
    var ns = Ext.ns('Ext.ux.plugins');

    /**
     * @class Ext.ux.plugins.DefaultButton
     * @extends Object
     *
     * Plugin for Button that will click() the button if the user presses ENTER while
     * a component in the button's form has focus.
     *
     * @author Stephen Friedrich
     * @date 09-DEC-2009
     * @version 0.1
     *
     */
    ns.DefaultButton =  Ext.extend(Object, {
        init: function(button) {
            button.on('afterRender', setupKeyListener, button);
        }
    });

    function setupKeyListener() {
        var formPanel = this.findParentByType('form');
        new Ext.KeyMap(formPanel.el, {
            key: Ext.EventObject.ENTER,
            shift: false,
            alt: false,
            fn: function(keyCode, e){
                if(e.target.type === 'textarea' && !e.ctrlKey) {
                    return true;
                }

                this.el.select('button').item(0).dom.click();
                return false;
            },
            scope: this
        });
    }

    Ext.ComponentMgr.registerPlugin('defaultButton', ns.DefaultButton);

})(); 

Ext.override(Ext.form.BasicForm,{
    my_loadRecord : function(values){
    //~ loadRecord : function(record){
        /* Same as ExtJS's loadRecord() (setValues()), except that we 
        forward also the record to field.setValue() so that Lino.Combobox 
        can use it. 
        */
        //~ console.log('20120918 my_loadRecord',values)
        if(Ext.isArray(values)){ 
            for(var i = 0, len = values.length; i < len; i++){
                var v = values[i];
                var f = this.findField(v.id);
                if(f){
                    f.setValue(v.value,values);
                    if(this.trackResetOnLoad){
                        f.originalValue = f.getValue();
                    }
                }
            }
        }else{ 
            var field, id;
            for(id in values){
                if(!Ext.isFunction(values[id]) && (field = this.findField(id))){
                    field.setValue(values[id],values);
                    if(this.trackResetOnLoad){
                        field.originalValue = field.getValue();
                        //~ if (field.hiddenField) {
                          //~ field.hiddenField.originalValue = field.hiddenField.value;
                        //~ }
                    }
                }
            }
        }
        return this;
    }
});




function initializeFooBarDropZone(cmp) {
    //~ console.log('initializeFooBarDropZone',cmp);
    cmp.dropTarget = new Ext.dd.DropTarget(cmp.bwrap, {
      //~ ddGroup     : 'gridDDGroup',
      notifyEnter : function(ddSource, e, data) {
        console.log('notifyEnter',ddSource,e,data);
        //Add some flare to invite drop.
        cmp.body.stopFx();
        cmp.body.highlight();
      },
      notifyDrop  : function(ddSource, e, data){
        console.log('notifyDrop',ddSource,e,data);
        // Reference the record (single selection) for readability
        //~ var selectedRecord = ddSource.dragData.selections[0];


        // Load the record into the form
        //~ formPanel.getForm().my_loadRecord(selectedRecord);


        // Delete record from the grid.  not really required.
        //~ ddSource.grid.store.remove(selectedRecord);

        return(true);
      }
    })
}



Lino.show_mti_child = function(fieldname,detail_handler) {
  //~ console.log('show_mti_child',this);
  //~ console.log('show_mti_child',panel.find("main_area"));
  rec = Lino.current_window.main_item.get_current_record();
  //~ rec = panel.get_current_record();
  if (rec) {
    //~ console.log('show_mti_child',Lino.current_window,rec);
    if (rec.phantom) {
      Lino.notify('Not allowed on phantom record.');
    }else if (rec.data[fieldname]) {
      //~ console.log('show_mti_child',rec.id);
      //~ detail_handler(Lino.current_window.main_item,{},{record_id:rec.id});
      detail_handler.run(null,{record_id:rec.id});
      //~ window.open(urlroot + '/' + rec.id);
      //~ document.location = urlroot + '/' + rec.id;
      //~ window.open(urlroot + '/' + rec.id,'_blank');
    } else {
      Lino.alert("Cannot show MTI child if checkbox is off.");
    }
  } else {
    Lino.notify('No current record.');
  }
};






/*
Mappings towards lino.modlib.cal.models.PanelCalendars
*/
// Sset SS = Ssite.modules.cal.PanelCalendars.get_handle(Sui).store
Ext.ensible.cal.CalendarMappings = {
    CalendarId:   {name:'ID',       mapping: 'id', type: 'int'},
    Title:        {name:'CalTitle', mapping: 'babel_name', type: 'string'},
    Description:  {name:'Desc',     mapping: 'description', type: 'string'},
    ColorId:      {name:'Color',    mapping: 'color', type: 'int'},
    IsHidden:     {name:'Hidden',   mapping: 'is_hidden', type: 'boolean'},    
};
Ext.ensible.cal.CalendarRecord.reconfigure();  


/*
Mappings towards lino.modlib.cal.models.PanelEvents 
*/
// Sset SS = Ssite.modules.cal.PanelEvents.get_handle(Sui).store
Ext.ensible.cal.EventMappings = {
    EventId:     {name: 'ID',        mapping: 'id', type:'int'},
    CalendarId:  {name: 'CalID',     mapping: 'calendarHidden', type: 'int'},
    Title:       {name: 'EvtTitle',  mapping: 'summary'},
    StartDate:   {name: 'StartDt',   mapping: 'start_dt', 
      type: 'date', 
      dateFormat: "Y-m-d\TH:i:s" },
    EndDate:     {name: 'EndDt',     mapping: 'end_dt', 
      type: 'date', 
      dateFormat: "Y-m-d\TH:i:s"},
    RRule:       {name: 'RecurRule', mapping: 'rsetHidden'},
    Location:    {name: 'Location',  mapping: 'placeHidden'},
    Notes:       {name: 'Desc',      mapping: 'description'},
    Url:         {name: 'LinkUrl',   mapping: 'url'},
    IsAllDay:    {name: 'AllDay',    mapping: 'all_day', type: 'boolean'},
    Reminder:    {name: 'Reminder',  mapping: 'reminder'}
    
};
Ext.ensible.cal.EventRecord.reconfigure();


Lino.on_eventclick = function(cp,rec,el) {
  //~ console.log("Lino.on_eventclick",arguments);
  //~ Lino.cal.Events.detail_action.run({record_id:rec.data.ID});
  Lino.cal.PanelEvents.detail.run(null,{record_id:rec.data.ID,base_params:Lino.eventStore.baseParams});
  return false;
}
    
Lino.on_editdetails = function(cp,rec,el) {
  //~ console.log("Lino.on_editdetails",arguments);
  if (rec.data.ID)
      //~ Lino.cal.Events.detail_action.run({record_id:rec.data.ID});
      Lino.cal.PanelEvents.detail.run(null,{record_id:rec.data.ID,base_params:Lino.eventStore.baseParams});
  return false;
}

Lino.format_time = function(dt) {
    return dt.getHours() + ':' + dt.getMinutes();
}
    
Lino.on_eventdelete = function() {
  //~ console.log("Lino.on_eventdelete",arguments);
};

Lino.on_eventadd  = function(cp,rec,el) {
  //~ console.log("Lino.on_eventadd ",arguments);
  return false;
}
    
Lino.on_eventresize  = function(cp,rec,el) {
  //~ console.log("Lino.on_eventresize ",arguments);
  //~ Lino.cal.Events.insert(cp);
  //~ return false;
}
    
Lino.on_eventupdate  = function(cp,rec,el) {
  //~ console.log("Lino.on_eventupdate",arguments);
  //~ Lino.cal.Events.insert(cp);
  //~ return false;
}
    

//~ Lino.eventStore = new Ext.ensible.cal.EventStore({ 
//~ Lino.eventStore = new Ext.data.ArrayStore({ 
Lino.eventStore = new Ext.data.JsonStore({ 
  listeners: { exception: Lino.on_store_exception }
  ,url: '/restful/cal/PanelEvents'
  ,restful : true
  ,proxy: new Ext.data.HttpProxy({ 
      url: '/restful/cal/PanelEvents', 
      disableCaching: false // no need for cache busting when loading via Ajax
      //~ disableCaching:true,
  })
  ,fields: Ext.ensible.cal.EventRecord.prototype.fields.getRange()
  ,totalProperty: "count"
  ,root: "rows"
  ,idProperty: Ext.ensible.cal.EventMappings.EventId.mapping
  ,writer : new Ext.data.JsonWriter({
    writeAllFields: false
  })
  ,load: function(options) {
    //~ foo.bar = baz; // 20120213
      if (!options) options = {};
      if (!options.params) options.params = {};
      //~ options.params.$ext_requests.URL_PARAM_TEAM_VIEW = Lino.calendar_app.team_view_button.pressed;
      
      var view = this.cal_panel.getActiveView();
      var bounds = view.getViewBounds();
      //~ var p = {sd:'05.02.2012',ed:'11.02.2012'};
      //~ var p = {};
      options.params[view.dateParamStart] = bounds.start.format(view.dateParamFormat);
      options.params[view.dateParamEnd] = bounds.end.format(view.dateParamFormat);
      Lino.insert_subst_user(options.params);
      //~ Ext.apply(options.params,p)
      //~ console.log('20120710 eventStore.load()',this.baseParams,options);
    
    return Ext.data.JsonStore.prototype.load.call(this,options);
  }
});

//~ Lino.calendarStore = new Ext.data.ArrayStore({ 
Lino.calendarStore = new Ext.data.JsonStore({ 
      listeners: { exception: Lino.on_store_exception }
      ,restful : true
      ,proxy: new Ext.data.HttpProxy({ 
          url: '/restful/cal/PanelCalendars?fmt=json', 
          disableCaching: false // no need for cache busting when loading via Ajax
          //~ restful : true
          //~ method: "GET"
      })
      //~ ,autoLoad: true
      //~ ,remoteSort: true
      //~ ,baseParams: bp
      ,totalProperty: "count"
      ,root: "rows"
      ,fields: Ext.ensible.cal.CalendarRecord.prototype.fields.getRange()
      ,idProperty: Ext.ensible.cal.CalendarMappings.CalendarId.mapping
      //~ ,idIndex: Ext.ensible.cal.CalendarMappings.CalendarId.mapping
    });


Lino.CalendarCfg = {
    dateParamFormat: 'd.m.Y',
    dateParamStart:'sd',
    dateParamEnd:'ed'
};
//~ 20120704 Lino.CalendarPanel = Ext.extend(Ext.ensible.cal.CalendarPanel,Lino.MainPanel);
//~ Lino.CalendarPanel = Ext.extend(Lino.CalendarPanel,{
Ext.override(Ext.ensible.cal.CalendarPanel,Lino.MainPanel);
Ext.override(Ext.ensible.cal.CalendarPanel,{
  //~ empty_title : "\$ui.get_actor('cal.Panel').report.label",
  empty_title : "Calendrier"
  ,activeItem: 1 // 0: day, 1: week
  ,ls_url: '/cal/CalendarPanel'
  //~ ,disableCaching:true
  ,eventStore: Lino.eventStore
  ,calendarStore: Lino.calendarStore
  ,listeners: { 
    editdetails: Lino.on_editdetails
    ,eventclick: Lino.on_eventclick
    //~ ,eventadd: Lino.on_eventadd
    //~ ,eventdelete: Lino.on_eventdelete
    //~ ,eventresize: Lino.on_eventresize
    ,afterrender : function(config) {
      //~ console.log("20120704 afterrender");
      Lino.calendarStore.load();
      //~ console.log("20120704 afterrender calls eventStore.load()",p);
      Lino.eventStore.cal_panel = this;
      //~ Lino.eventStore.load({params:p});
      Lino.eventStore.load();
      //~ Lino.CalendarPanel.superclass.constructor.call(this, config);
      //~ console.log(20120118, config,this);
    }
    }
  ,enableEditDetails: false
  //~ ,monthViewCfg: Lino.CalendarCfg
  //~ ,weekViewCfg: Lino.CalendarCfg
  //~ ,multiDayViewCfg: Lino.CalendarCfg
  //~ ,multiWeekViewCfg: Lino.CalendarCfg
  //~ ,dayViewCfg: Lino.CalendarCfg
  //~ ,initComponent : function() {
    //~ // this.on('eventadd',Lino.on_eventadd);
    //~ Lino.CalendarPanel.superclass.initComponent.call(this);
  //~ }
});




Lino.CalendarAppPanel = Ext.extend(Ext.Panel,Lino.MainPanel);
Lino.CalendarAppPanel = Ext.extend(Lino.CalendarAppPanel,{
  //~ empty_title : "\$ui.get_actor('cal.Panel').report.label",
  empty_title : "Calendrier"
  ,ls_url: '/cal/CalendarPanel'
  ,set_status : function(status) { this.refresh();}
  ,refresh : function() {Lino.eventStore.reload();}
  ,layout: 'fit'
  ,unused_is_loading : function() { 
      var loading = Lino.calendarStore.getCount() == 0 | Lino.eventStore.getCount() == 0
      //~ console.log("CalendarPanel loading:",loading);
      return loading; 
  }
  ,get_base_params : function() {
    var p = Ext.apply({},this.base_params);
    Lino.insert_subst_user(p);
    return p;
  }
  ,set_base_params : function(p) {
    this.base_params = Ext.apply({},p);
  }
  ,clear_base_params : function() {
      this.base_params = {};
      Lino.insert_subst_user(this.base_params);
  }
  ,set_base_param : function(k,v) {
      if (!this.base_params) this.base_params = {};
      this.base_params[k] = v;
  }
});

Lino.calendar_app = function() { return {
  get_main_panel : function() {
      return new Lino.CalendarAppPanel({ items : 
        //~ [{
          //~ id: 'app-header',
          //~ region: 'north',
          //~ height: 35,
          //~ border: false,
          // contentEl: 'app-header-content'
        //~ },
      {
          id: 'app-center',
          title: '...', // will be updated to the current view's date range
          region: 'center',
          layout: 'border',
          listeners: {
              'afterrender': function(){
                  Ext.getCmp('app-center').header.addClass('app-center-header');
              }
          },
          items: [{
              id:'app-west',
              region: 'west',
              width: 176,
              border: false,
              items: [{
                  xtype: 'datepicker',
                  id: 'app-nav-picker',
                  cls: 'ext-cal-nav-picker',
                  listeners: {
                      'select': {
                          fn: function(dp, dt){
                              Lino.calendarPanel.setStartDate(dt);
                          },
                          scope: this
                      }
                  }
              //~ },{ 
                //~ layout:'fit',
                //~ items: [
                  //~ new Ext.form.Checkbox({
                    //~ boxLabel:"$_('Team view')",
                    //~ hideLabel:true
                    //~ listeners: { click: }
                  //~ })
                //~ ]
              },{ 
                layout:'form',
                items: [
                  this.team_view_button = new Ext.Button({
                    text:"Team view",
                    enableToggle:true,
                    pressed:false,
                    toggleHandler: function(btn,state) { 
                      //~ console.log('20120716 teamView.toggle()');
                      Lino.eventStore.setBaseParam('tv',state);
                      Lino.eventStore.load();
                      //~ Lino.eventStore.load({params:{$ext_requests.URL_PARAM_TEAM_VIEW:state}});
                      //~ console.log("team view",state);
                    }
                  })
                ]
              },{
                  xtype: 'extensible.calendarlist',
                  store: Lino.calendarStore,
                  border: false,
                  width: 175
              }]
          },{
              xtype: 'extensible.calendarpanel',
              eventStore: Lino.eventStore,
              calendarStore: Lino.calendarStore,
              border: false,
              id:'app-calendar',
              region: 'center',
              //~ activeItem: 3, // month view
              
              // Any generic view options that should be applied to all sub views:
              viewConfig: {
                  // Lino.CalendarCfg
                  dateParamFormat: 'd.m.Y',
                  dateParamStart:'sd',
                  dateParamEnd:'ed',
                
                  //enableFx: false,
                  //ddIncrement: 10, //only applies to DayView and subclasses, but convenient to put it here
                  viewStartHour: 8,
                  viewEndHour: 18
                  //minEventDisplayMinutes: 15
              },
              
              // View options specific to a certain view (if the same options exist in viewConfig
              // they will be overridden by the view-specific config):
              monthViewCfg: {
                  showHeader: true,
                  showWeekLinks: true,
                  showWeekNumbers: true,
                  eventBodyMarkup: ['{Title}',
                    //~ '<tpl if="url">',
                        //~ '<a href="{url}">XX</a>',
                    //~ '</tpl>',
                    '<tpl if="_isReminder">',
                        '<i class="ext-cal-ic ext-cal-ic-rem">&#160;</i>',
                    '</tpl>',
                    '<tpl if="_isRecurring">',
                        '<i class="ext-cal-ic ext-cal-ic-rcr">&#160;</i>',
                    '</tpl>',
                    '<tpl if="spanLeft">',
                        '<i class="ext-cal-spl">&#160;</i>',
                    '</tpl>',
                    '<tpl if="spanRight">',
                        '<i class="ext-cal-spr">&#160;</i>',
                    '</tpl>'
                ].join('')
              },
              
              multiWeekViewCfg: {
                  //weekCount: 3
              },
              
              // Some optional CalendarPanel configs to experiment with:
              //readOnly: true,
              //showDayView: false,
              //showMultiDayView: true,
              //showWeekView: false,
              //showMultiWeekView: false,
              //showMonthView: false,
              //showNavBar: false,
              //showTodayText: false,
              //showTime: false,
              //editModal: true,
              //enableEditDetails: false,
              //title: 'My Calendar', // the header of the calendar, could be a subtitle for the app
              
              // Once this component inits it will set a reference to itself as an application
              // member property for easy reference in other functions within App.
              initComponent: function() {
                  Lino.calendarPanel = this;
                  this.constructor.prototype.initComponent.apply(this, arguments);
              },
              
              listeners: {
                  //~ 'eventclick': {
                      //~ fn: function(vw, rec, el){
                          //~ this.clearMsg();
                      //~ },
                      //~ scope: this
                  //~ },
                  'eventover': function(vw, rec, el){
                      //console.log('Entered evt rec='+rec.data[Ext.ensible.cal.EventMappings.Title.name]', view='+ vw.id +', el='+el.id);
                  },
                  'eventout': function(vw, rec, el){
                      //console.log('Leaving evt rec='+rec.data[Ext.ensible.cal.EventMappings.Title.name]+', view='+ vw.id +', el='+el.id);
                  },
                  'eventadd': {
                      fn: function(cp, rec){
                          this.showMsg('Event '+ rec.data[Ext.ensible.cal.EventMappings.Title.name] +' was added');
                      },
                      scope: this
                  },
                  'eventupdate': {
                      fn: function(cp, rec){
                          this.showMsg('Event '+ rec.data[Ext.ensible.cal.EventMappings.Title.name] +' was updated');
                      },
                      scope: this
                  },
                  'eventdelete': {
                      fn: function(cp, rec){
                          //this.eventStore.remove(rec);
                          this.showMsg('Event '+ rec.data[Ext.ensible.cal.EventMappings.Title.name] +' was deleted');
                      },
                      scope: this
                  },
                  'eventcancel': {
                      fn: function(cp, rec){
                          // edit canceled
                      },
                      scope: this
                  },
                  'viewchange': {
                      fn: function(p, vw, dateInfo){
                          if(this.editWin){
                              this.editWin.hide();
                          };
                          if(dateInfo !== null){
                              // will be null when switching to the event edit form so ignore
                              Ext.getCmp('app-nav-picker').setValue(dateInfo.activeDate);
                              this.updateTitle(dateInfo.viewStart, dateInfo.viewEnd);
                          }
                      },
                      scope: this
                  },
                  'dayclick': {
                      fn: function(vw, dt, ad, el){
                          this.clearMsg();
                      },
                      scope: this
                  },
                  'rangeselect': {
                      fn: function(vw, dates, onComplete){
                          this.clearMsg();
                      },
                      scope: this
                  },
                  'eventmove': {
                      fn: function(vw, rec){
                          rec.commit();
                          var time = rec.data[Ext.ensible.cal.EventMappings.IsAllDay.name] ? '' : ' \\a\\t g:i a';
                          this.showMsg('Event '+ rec.data[Ext.ensible.cal.EventMappings.Title.name] +' was moved to '+
                              rec.data[Ext.ensible.cal.EventMappings.StartDate.name].format('F jS'+time));
                      },
                      scope: this
                  },
                  'eventresize': {
                      fn: function(vw, rec){
                          rec.commit();
                          this.showMsg('Event '+ rec.data[Ext.ensible.cal.EventMappings.Title.name] +' was updated');
                      },
                      scope: this
                  },
                  'eventdelete': {
                      fn: function(win, rec){
                          Lino.eventStore.remove(rec);
                          this.showMsg('Event '+ rec.data[Ext.ensible.cal.EventMappings.Title.name] +' was deleted');
                      },
                      scope: this
                  },
                  'initdrag': {
                      fn: function(vw){
                          if(this.editWin && this.editWin.isVisible()){
                              this.editWin.hide();
                          }
                      },
                      scope: this
                  }
              }
          }]
        }
        //~ ]
        
      });
      
  }
  ,updateTitle: function(startDt, endDt){
      var p = Ext.getCmp('app-center');
      
      if(startDt.clearTime().getTime() == endDt.clearTime().getTime()){
          p.setTitle(startDt.format('F j, Y'));
      }
      else if(startDt.getFullYear() == endDt.getFullYear()){
          if(startDt.getMonth() == endDt.getMonth()){
              p.setTitle(startDt.format('F j') + ' - ' + endDt.format('j, Y'));
          }
          else{
              p.setTitle(startDt.format('F j') + ' - ' + endDt.format('F j, Y'));
          }
      }
      else{
          p.setTitle(startDt.format('F j, Y') + ' - ' + endDt.format('F j, Y'));
      }
  }
  // This is an application-specific way to communicate CalendarPanel event messages back to the user.
  // This could be replaced with a function to do "toast" style messages, growl messages, etc. This will
  // vary based on application requirements, which is why it's not baked into the CalendarPanel.
  ,showMsg: function(msg){
      Lino.notify(msg);
      //~ Ext.fly('app-msg').update(msg).removeClass('x-hidden');
  }
  
  ,clearMsg: function(){
      Lino.notify('');
      //~ Ext.fly('app-msg').update('').addClass('x-hidden');
  }
}
}();




/*
captureEvents utility by Aaron Conran
<http://www.sencha.com/learn/grid-faq/>

Ext.onReady(function(){
    var grid = new Ext.grid.GridPanel({
        ... 
    });
    captureEvents(grid);
});
*/
function captureEvents(observable) {
    Ext.util.Observable.capture(
        observable,
        function(eventName) {
            console.info(eventName);
        },
        this
    );		
}
 






Lino.main_menu = [ { "menu": { "items": [ { "text": "Personnes", "handler": function() {Lino.contacts.Persons.grid.run(null)} }, { "text": " \u25b6 Clients", "handler": function() {Lino.pcsw.Clients.grid.run(null)} }, { "text": "Organisations", "handler": function() {Lino.contacts.Companies.grid.run(null)} }, { "text": "M\u00e9nages", "handler": function() {Lino.households.Households.grid.run(null)} }, "-", { "text": "Partenaires (tous)", "handler": function() {Lino.contacts.Partners.grid.run(null)} } ] }, "text": "Contacts" }, { "menu": { "items": [ { "text": "Mon courrier sortant", "handler": function() {Lino.outbox.MyOutbox.grid.run(null)} }, { "menu": { "items": [ { "text": "Mes Envois postaux", "handler": function() {Lino.postings.MyPostings.grid.run(null)} }, { "text": "Envois postaux \u00e0 imprimer", "handler": function() {Lino.postings.PostingsReady.grid.run(null)} }, { "text": "Envois postaux imprim\u00e9s", "handler": function() {Lino.postings.PostingsPrinted.grid.run(null)} }, { "text": "Envois postaux envoy\u00e9s", "handler": function() {Lino.postings.PostingsSent.grid.run(null)} } ] }, "text": "Envois postaux" }, { "text": "Mes notes", "handler": function() {Lino.notes.MyNotes.grid.run(null)} } ] }, "text": "Office" }, { "menu": { "items": [ { "text": "Calendrier", "iconCls": "x-tbar-calendar", "handler": function() {Lino.cal.CalendarPanel.grid.run(null)} }, { "text": "Events", "listeners": { "render": Lino.quicktip_renderer("Foo","Table of all my calendar events.") }, "handler": function() {Lino.cal.MyEvents.grid.run(null)} }, "-", { "text": "Mes T\u00e2ches", "listeners": { "render": Lino.quicktip_renderer("Foo","Table of all my tasks.") }, "handler": function() {Lino.cal.MyTasks.grid.run(null)} }, { "text": "To-do list", "listeners": { "render": Lino.quicktip_renderer("Foo","Table of my tasks marked 'to do'.") }, "handler": function() {Lino.cal.MyTasksToDo.grid.run(null)} }, "-", { "text": "Mes pr\u00e9sences", "listeners": { "render": Lino.quicktip_renderer("Foo","Shows all my presences in calendar events, independently of their state.") }, "handler": function() {Lino.cal.MyPresences.grid.run(null)} }, { "text": "Mes invitations re\u00e7ues", "listeners": { "render": Lino.quicktip_renderer("Foo","Shows received invitations which I must accept or reject.") }, "handler": function() {Lino.cal.MyPendingInvitations.grid.run(null)} } ] }, "text": "Calendrier" }, { "menu": { "items": [ { "text": "Clients", "listeners": { "render": Lino.quicktip_renderer("Foo","Wie Kontakte \u25b8 Klienten, aber mit DSBE-spezifischen Kolonnen und Filterparametern.") }, "handler": function() {Lino.pcsw.IntegClients.grid.run(null)} }, { "text": "PIISs", "handler": function() {Lino.isip.MyContracts.grid.run(null)} }, { "text": "Contrats de travail", "handler": function() {Lino.jobs.MyContracts.grid.run(null)} }, { "text": "Employants", "handler": function() {Lino.jobs.JobProviders.grid.run(null)} }, { "text": "Emplois", "listeners": { "render": Lino.quicktip_renderer("Foo","\n    Eine Stelle ist ein Arbeitsplatz bei einem Stellenabieter. \n    ") }, "handler": function() {Lino.jobs.Jobs.grid.run(null)} }, { "text": "Offres d'emploi", "handler": function() {Lino.jobs.Offers.grid.run(null)} }, { "text": "Situation contrats Art 60-7", "listeners": { "render": Lino.quicktip_renderer("Foo","Open a detail window on this record") }, "handler": function() {Lino.jobs.NewJobsOverview.show.run(null,{ "record_id": -99998 })} } ] }, "text": "Int\u00e9gration" }, { "menu": { "items": [ { "text": "Organisateurs de cours", "handler": function() {Lino.courses.CourseProviders.grid.run(null)} }, { "text": "Offres de cours", "handler": function() {Lino.courses.CourseOffers.grid.run(null)} }, { "text": "Demandes de cours ouvertes", "handler": function() {Lino.courses.PendingCourseRequests.grid.run(null)} } ] }, "text": "Cours" }, { "menu": { "items": [ { "text": "Nouveaux clients", "listeners": { "render": Lino.quicktip_renderer("Foo","Liste der neuen Klienten zwecks Zuweisung \neines Begleiters oder Ablehnen des Hilfeantrags.") }, "handler": function() {Lino.newcomers.NewClients.grid.run(null)} } ] }, "text": "Nouvelles demandes" }, { "menu": { "items": [ { "text": "Clients", "listeners": { "render": Lino.quicktip_renderer("Foo","Wie Kontakte \u25b8 Klienten, aber mit Kolonnen und Filterparametern f\u00fcr Schuldnerberatung.") }, "handler": function() {Lino.pcsw.DebtsClients.grid.run(null)} }, { "text": "Mes Budgets", "handler": function() {Lino.debts.MyBudgets.grid.run(null)} } ] }, "text": "M\u00e9diation de dettes" }, { "menu": { "items": [ { "text": "Situation contrats Art 60-7", "listeners": { "render": Lino.quicktip_renderer("Foo","Open a detail window on this record") }, "handler": function() {Lino.jobs.JobsOverview.show.run(null,{ "record_id": -99998 })} }, { "text": "Agents et leurs clients", "handler": function() {Lino.pcsw.UsersWithClients.grid.run(null)} }, { "text": "Data Test Clients", "listeners": { "render": Lino.quicktip_renderer("Foo","Table of Clients whose data seems unlogical or inconsistent.") }, "handler": function() {Lino.pcsw.ClientsTest.grid.run(null)} }, { "text": "Agents disponibles", "handler": function() {Lino.newcomers.AvailableCoaches.grid.run(null)} } ] }, "text": "Listings" }, { "menu": { "items": [ { "menu": { "items": [ { "text": "Mes Text Field Templates", "handler": function() {Lino.ui.MyTextFieldTemplates.grid.run(null)} }, { "text": "Types d'upload", "handler": function() {Lino.uploads.UploadTypes.grid.run(null)} }, { "text": "Types de note", "handler": function() {Lino.notes.NoteTypes.grid.run(null)} }, { "text": "Types d'\u00e9v\u00e9nements", "handler": function() {Lino.notes.EventTypes.grid.run(null)} } ] }, "text": "Office" }, { "menu": { "items": [ { "text": "Param\u00e8tres du Site", "handler": function() {Lino.ui.SiteConfigs.detail.run(null,{ "record_id": 1 })} }, { "text": "Utilisateurs", "listeners": { "render": Lino.quicktip_renderer("Foo","\n    Shows the list of all users on this site.\n    \n    A User is somebody who can log into the application.\n    \n    ") }, "handler": function() {Lino.users.Users.grid.run(null)} }, { "text": "Teams", "handler": function() {Lino.users.Teams.grid.run(null)} }, { "text": "types de contenu", "handler": function() {Lino.ui.ContentTypes.grid.run(null)} }, { "text": "Textes d'aide", "handler": function() {Lino.ui.HelpTexts.grid.run(null)} } ] }, "text": "Syst\u00e8me" }, { "menu": { "items": [ { "text": "Pays", "listeners": { "render": Lino.quicktip_renderer("Foo","\n    A country is a geographic entity considered a \"nation\".\n    ") }, "handler": function() {Lino.countries.Countries.grid.run(null)} }, { "text": "Places", "listeners": { "render": Lino.quicktip_renderer("Foo","\n    The table of known geographical places.\n    A geographical place can be a city, a town, a suburb, \n    a province, a lake... any named geographic entity,\n    except for countries because these have their own table.\n    ") }, "handler": function() {Lino.countries.Cities.grid.run(null)} }, { "text": "Langues", "handler": function() {Lino.countries.Languages.grid.run(null)} }, { "text": "Types d'organisation", "handler": function() {Lino.contacts.CompanyTypes.grid.run(null)} }, { "text": "Fonctions", "handler": function() {Lino.contacts.RoleTypes.grid.run(null)} } ] }, "text": "Contacts" }, { "menu": { "items": [ { "text": "Groupes de propri\u00e9t\u00e9s", "handler": function() {Lino.properties.PropGroups.grid.run(null)} }, { "text": "Types de propri\u00e9t\u00e9s", "handler": function() {Lino.properties.PropTypes.grid.run(null)} }, { "text": "Fachkompetenzen", "handler": function() {Lino.properties.PropsByGroup.grid.run(null,{ "base_params": { "mt": 15, "mk": 1 } })} }, { "text": "Sozialkompetenzen", "handler": function() {Lino.properties.PropsByGroup.grid.run(null,{ "base_params": { "mt": 15, "mk": 2 } })} }, { "text": "Hindernisse", "handler": function() {Lino.properties.PropsByGroup.grid.run(null,{ "base_params": { "mt": 15, "mk": 3 } })} } ] }, "text": "Propri\u00e9t\u00e9s" }, { "menu": { "items": [ { "text": "Places", "listeners": { "render": Lino.quicktip_renderer("Foo","List of places where calendar events can happen.") }, "handler": function() {Lino.cal.Places.grid.run(null)} }, { "text": "Priorit\u00e9s", "listeners": { "render": Lino.quicktip_renderer("Foo","List of possible priorities of calendar events.") }, "handler": function() {Lino.cal.Priorities.grid.run(null)} }, { "text": "R\u014dles de participant", "listeners": { "render": Lino.quicktip_renderer("Foo","The role of a guest expresses what the \n    partner is going to do there.") }, "handler": function() {Lino.cal.GuestRoles.grid.run(null)} }, { "text": "Calendriers", "listeners": { "render": Lino.quicktip_renderer("Foo","The list of calendars defined on this system.\n    A calendar is a list of events which have certain things in common,\n    especially they are displayed in the same colour in the calendar panel") }, "handler": function() {Lino.cal.Calendars.grid.run(null)} } ] }, "text": "Calendrier" }, { "menu": { "items": [ { "text": "R\u00f4les dans m\u00e9nage", "handler": function() {Lino.households.Roles.grid.run(null)} }, { "text": "Types de m\u00e9nage", "handler": function() {Lino.households.Types.grid.run(null)} } ] }, "text": "M\u00e9nages" }, { "menu": { "items": [ { "text": "Plan comptables", "handler": function() {Lino.accounts.Charts.grid.run(null)} }, { "text": "Groupes de comptes", "handler": function() {Lino.accounts.Groups.grid.run(null)} }, { "text": "Comptes", "handler": function() {Lino.accounts.Accounts.grid.run(null)} } ] }, "text": "Comptabilit\u00e9" }, { "menu": { "items": [ { "text": "Phases d'int\u00e9gration", "listeners": { "render": Lino.quicktip_renderer("Foo","Liste des phases d'int\u00e9gration possibles.") }, "handler": function() {Lino.pcsw.PersonGroups.grid.run(null)} }, { "text": "Activit\u00e9s", "listeners": { "render": Lino.quicktip_renderer("Foo","Liste des \"activit\u00e9s\" ou \"codes profession\".") }, "handler": function() {Lino.pcsw.Activities.grid.run(null)} }, { "text": "Exclusion Types", "listeners": { "render": Lino.quicktip_renderer("Foo","Liste des raisons possibles d'arr\u00eater temporairement \n    le paiement d'une aide financi\u00e8re pr\u00e9vue.") }, "handler": function() {Lino.pcsw.ExclusionTypes.grid.run(null)} }, { "text": "Services", "listeners": { "render": Lino.quicktip_renderer("Foo","Liste des types d'accompagnement.") }, "handler": function() {Lino.pcsw.CoachingTypes.grid.run(null)} }, { "text": "Types de contact client", "listeners": { "render": Lino.quicktip_renderer("Foo","Liste des types de contacts client.") }, "handler": function() {Lino.pcsw.ClientContactTypes.grid.run(null)} } ] }, "text": "CPAS" }, { "menu": { "items": [ { "text": "Types de PIIS", "handler": function() {Lino.isip.ContractTypes.grid.run(null)} }, { "text": "Causes d'abandon", "handler": function() {Lino.isip.ContractEndings.grid.run(null)} }, { "text": "M\u00e9thode d'examination", "handler": function() {Lino.isip.ExamPolicies.grid.run(null)} }, { "text": "Types de contrat de travail", "handler": function() {Lino.jobs.ContractTypes.grid.run(null)} }, { "text": "Types d'emplois", "handler": function() {Lino.jobs.JobTypes.grid.run(null)} }, { "text": "Secteurs d'activit\u00e9", "handler": function() {Lino.jobs.Sectors.grid.run(null)} }, { "text": "Fonctions", "handler": function() {Lino.jobs.Functions.grid.run(null)} }, { "text": "Type d'\u00e9tudes", "handler": function() {Lino.jobs.StudyTypes.grid.run(null)} }, { "text": "Horaires", "handler": function() {Lino.jobs.Schedules.grid.run(null)} }, { "text": "R\u00e9gimes de travail", "handler": function() {Lino.jobs.Regimes.grid.run(null)} } ] }, "text": "Int\u00e9gration" }, { "menu": { "items": [ { "text": "Contenus de cours", "handler": function() {Lino.courses.CourseContents.grid.run(null)} } ] }, "text": "Cours" }, { "menu": { "items": [ { "text": "Interm\u00e9diaires", "handler": function() {Lino.newcomers.Brokers.grid.run(null)} }, { "text": "Sp\u00e9cificit\u00e9s", "handler": function() {Lino.newcomers.Faculties.grid.run(null)} } ] }, "text": "Nouvelles demandes" }, { "menu": { "items": [ { "text": "Secteurs", "handler": function() {Lino.cbss.Sectors.grid.run(null)} }, { "text": "Codes fonction", "handler": function() {Lino.cbss.Purposes.grid.run(null)} } ] }, "text": "BCSS" } ] }, "text": "Configuration" }, { "menu": { "items": [ { "menu": { "items": [ { "text": "Text Field Templates", "handler": function() {Lino.ui.TextFieldTemplates.grid.run(null)} }, { "text": "Uploads", "handler": function() {Lino.uploads.Uploads.grid.run(null)} }, { "text": "Outgoing Mails", "handler": function() {Lino.outbox.Mails.grid.run(null)} }, { "text": "Pi\u00e8ces jointes", "handler": function() {Lino.outbox.Attachments.grid.run(null)} }, { "text": "Envois postaux", "handler": function() {Lino.postings.Postings.grid.run(null)} } ] }, "text": "Office" }, { "menu": { "items": [ { "text": "Procurations", "handler": function() {Lino.users.Authorities.grid.run(null)} }, { "text": "User Groups", "handler": function() {Lino.lino.UserGroups.grid.run(null)} }, { "text": "User Levels", "handler": function() {Lino.lino.UserLevels.grid.run(null)} }, { "text": "User Profiles", "handler": function() {Lino.lino.UserProfiles.grid.run(null)} }, { "text": "Changes", "handler": function() {Lino.changes.Changes.grid.run(null)} } ] }, "text": "Syst\u00e8me" }, { "menu": { "items": [ { "text": "Personnes de contact", "handler": function() {Lino.contacts.Roles.grid.run(null)} } ] }, "text": "Contacts" }, { "menu": { "items": [ { "text": "T\u00e2ches", "listeners": { "render": Lino.quicktip_renderer("Foo","A calendar task is something you need to do.\n    ") }, "handler": function() {Lino.cal.Tasks.grid.run(null)} }, { "text": "Participants", "listeners": { "render": Lino.quicktip_renderer("Foo","A guest is a partner invited to an event.\n    ") }, "handler": function() {Lino.cal.Guests.grid.run(null)} }, { "text": "Abonnements", "handler": function() {Lino.cal.Subscriptions.grid.run(null)} }, { "text": "States", "listeners": { "render": Lino.quicktip_renderer("Foo","List of the possible states of a calendar event.") }, "handler": function() {Lino.cal.EventStates.grid.run(null)} }, { "text": "States", "handler": function() {Lino.cal.GuestStates.grid.run(null)} }, { "text": "States", "handler": function() {Lino.cal.TaskStates.grid.run(null)} } ] }, "text": "Calendrier" }, { "menu": { "items": [ { "text": "Membres de m\u00e9nage", "handler": function() {Lino.households.Members.grid.run(null)} } ] }, "text": "M\u00e9nages" }, { "menu": { "items": [ { "text": "Accompagnements", "listeners": { "render": Lino.quicktip_renderer("Foo","Liste des accompagnements.") }, "handler": function() {Lino.pcsw.Coachings.grid.run(null)} }, { "text": "Contacts client", "listeners": { "render": Lino.quicktip_renderer("Foo","Liste des contacts clients.") }, "handler": function() {Lino.pcsw.ClientContacts.grid.run(null)} }, { "text": "exclusions", "listeners": { "render": Lino.quicktip_renderer("Foo","Liste des exclusions.") }, "handler": function() {Lino.pcsw.Exclusions.grid.run(null)} }, { "text": "Etats civils", "handler": function() {Lino.pcsw.CivilState.grid.run(null)} }, { "text": "Etats clients", "handler": function() {Lino.pcsw.ClientStates.grid.run(null)} }, { "text": "eID card types", "handler": function() {Lino.pcsw.BeIdCardTypes.grid.run(null)} } ] }, "text": "CPAS" }, { "menu": { "items": [ { "text": "Connaissances de langue", "handler": function() {Lino.cv.LanguageKnowledges.grid.run(null)} } ] }, "text": "CV" }, { "menu": { "items": [ { "text": "PIISs", "handler": function() {Lino.isip.Contracts.grid.run(null)} }, { "text": "Contrats de travail", "handler": function() {Lino.jobs.Contracts.grid.run(null)} }, { "text": "Candidatures", "handler": function() {Lino.jobs.Candidatures.grid.run(null)} }, { "text": "\u00c9tudes & formations", "handler": function() {Lino.jobs.Studies.grid.run(null)} } ] }, "text": "Int\u00e9gration" }, { "menu": { "items": [ { "text": "Cours", "handler": function() {Lino.courses.Courses.grid.run(null)} }, { "text": "Demande de cours", "handler": function() {Lino.courses.CourseRequests.grid.run(null)} } ] }, "text": "Cours" }, { "text": "Comp\u00e9tences", "handler": function() {Lino.newcomers.Competences.grid.run(null)} }, { "menu": { "items": [ { "text": "Budgets", "handler": function() {Lino.debts.Budgets.grid.run(null)} }, { "text": "Entr\u00e9es", "handler": function() {Lino.debts.Entries.grid.run(null)} } ] }, "text": "M\u00e9diation de dettes" }, { "menu": { "items": [ { "text": "Requ\u00eates IdentifyPerson", "handler": function() {Lino.cbss.IdentifyPersonRequests.grid.run(null)} }, { "text": "Requ\u00eates ManageAccess", "handler": function() {Lino.cbss.ManageAccessRequests.grid.run(null)} }, { "text": "Requ\u00eates Tx25", "handler": function() {Lino.cbss.RetrieveTIGroupsRequests.grid.run(null)} } ] }, "text": "BCSS" }, { "text": "Events/Notes", "handler": function() {Lino.notes.Notes.grid.run(null)} }, { "text": "Propri\u00e9t\u00e9s", "handler": function() {Lino.properties.Properties.grid.run(null)} } ] }, "text": "Explorateur" }, { "menu": { "items": [ { "text": "About", "listeners": { "render": Lino.quicktip_renderer("Foo","Show information about this site.") }, "handler": function() {Lino.about.About.show.run(null,{ "record_id": -99998 })} } ] }, "text": "Site" }, { "text": "D\u00e9part", "handler": function() {Lino.close_all_windows()} } ];
Ext.namespace('Lino.ui.SiteConfigs')
Ext.namespace('Lino.ui.ContentTypes')
Ext.namespace('Lino.ui.HelpTexts')
Ext.namespace('Lino.ui.TextFieldTemplates')
Ext.namespace('Lino.users.Users')
Ext.namespace('Lino.users.MySettings')
Ext.namespace('Lino.users.UsersOverview')
Ext.namespace('Lino.users.Teams')
Ext.namespace('Lino.users.Memberships')
Ext.namespace('Lino.users.Authorities')
Ext.namespace('Lino.changes.Changes')
Ext.namespace('Lino.countries.Languages')
Ext.namespace('Lino.countries.Countries')
Ext.namespace('Lino.countries.Cities')
Ext.namespace('Lino.properties.PropGroups')
Ext.namespace('Lino.properties.PropTypes')
Ext.namespace('Lino.properties.Properties')
Ext.namespace('Lino.properties.PropChoices')
Ext.namespace('Lino.contacts.CompanyTypes')
Ext.namespace('Lino.contacts.Partners')
Ext.namespace('Lino.contacts.Companies')
Ext.namespace('Lino.contacts.RoleTypes')
Ext.namespace('Lino.contacts.Roles')
Ext.namespace('Lino.postings.Postings')
Ext.namespace('Lino.postings.PostingsByState')
Ext.namespace('Lino.postings.PostingsReady')
Ext.namespace('Lino.postings.PostingsPrinted')
Ext.namespace('Lino.postings.PostingsSent')
Ext.namespace('Lino.outbox.Recipients')
Ext.namespace('Lino.outbox.Mails')
Ext.namespace('Lino.outbox.Attachments')
Ext.namespace('Lino.cal.Calendars')
Ext.namespace('Lino.cal.Subscriptions')
Ext.namespace('Lino.cal.Places')
Ext.namespace('Lino.cal.Priorities')
Ext.namespace('Lino.cal.Events')
Ext.namespace('Lino.cal.MyEvents')
Ext.namespace('Lino.cal.MyUnclearEvents')
Ext.namespace('Lino.cal.EventsAssignedToMe')
Ext.namespace('Lino.cal.MyEventsToday')
Ext.namespace('Lino.cal.Tasks')
Ext.namespace('Lino.cal.GuestRoles')
Ext.namespace('Lino.cal.Guests')
Ext.namespace('Lino.cal.PanelCalendars')
Ext.namespace('Lino.cal.PanelEvents')
Ext.namespace('Lino.uploads.UploadTypes')
Ext.namespace('Lino.uploads.Uploads')
Ext.namespace('Lino.households.Types')
Ext.namespace('Lino.households.Households')
Ext.namespace('Lino.households.Roles')
Ext.namespace('Lino.households.Members')
Ext.namespace('Lino.accounts.Charts')
Ext.namespace('Lino.accounts.Groups')
Ext.namespace('Lino.accounts.Accounts')
Ext.namespace('Lino.notes.NoteTypes')
Ext.namespace('Lino.notes.EventTypes')
Ext.namespace('Lino.notes.Notes')
Ext.namespace('Lino.cv.LanguageKnowledges')
Ext.namespace('Lino.cv.PersonProperties')
Ext.namespace('Lino.contacts.Persons')
Ext.namespace('Lino.pcsw.Clients')
Ext.namespace('Lino.pcsw.DebtsClients')
Ext.namespace('Lino.pcsw.IntegClients')
Ext.namespace('Lino.pcsw.ClientsTest')
Ext.namespace('Lino.pcsw.PersonGroups')
Ext.namespace('Lino.pcsw.Activities')
Ext.namespace('Lino.pcsw.ExclusionTypes')
Ext.namespace('Lino.pcsw.Exclusions')
Ext.namespace('Lino.pcsw.AidTypes')
Ext.namespace('Lino.pcsw.OverlappingContracts')
Ext.namespace('Lino.pcsw.ClientContactTypes')
Ext.namespace('Lino.pcsw.ClientContacts')
Ext.namespace('Lino.pcsw.CoachingTypes')
Ext.namespace('Lino.pcsw.Coachings')
Ext.namespace('Lino.isip.ContractTypes')
Ext.namespace('Lino.isip.ExamPolicies')
Ext.namespace('Lino.isip.ContractEndings')
Ext.namespace('Lino.isip.Contracts')
Ext.namespace('Lino.isip.MyContracts')
Ext.namespace('Lino.jobs.Schedules')
Ext.namespace('Lino.jobs.Regimes')
Ext.namespace('Lino.jobs.JobProviders')
Ext.namespace('Lino.jobs.ContractTypes')
Ext.namespace('Lino.jobs.Sectors')
Ext.namespace('Lino.jobs.Functions')
Ext.namespace('Lino.jobs.Contracts')
Ext.namespace('Lino.jobs.MyContracts')
Ext.namespace('Lino.jobs.Offers')
Ext.namespace('Lino.jobs.StudyTypes')
Ext.namespace('Lino.jobs.Studies')
Ext.namespace('Lino.jobs.Experiences')
Ext.namespace('Lino.jobs.Candidatures')
Ext.namespace('Lino.jobs.Jobs')
Ext.namespace('Lino.jobs.JobTypes')
Ext.namespace('Lino.jobs.ContractsSearch')
Ext.namespace('Lino.courses.CourseProviders')
Ext.namespace('Lino.courses.CourseContents')
Ext.namespace('Lino.courses.Courses')
Ext.namespace('Lino.courses.CourseOffers')
Ext.namespace('Lino.courses.CourseRequests')
Ext.namespace('Lino.courses.PendingCourseRequests')
Ext.namespace('Lino.newcomers.Brokers')
Ext.namespace('Lino.newcomers.Faculties')
Ext.namespace('Lino.newcomers.Competences')
Ext.namespace('Lino.newcomers.NewClients')
Ext.namespace('Lino.newcomers.AvailableCoaches')
Ext.namespace('Lino.debts.Budgets')
Ext.namespace('Lino.debts.Actors')
Ext.namespace('Lino.debts.Entries')
Ext.namespace('Lino.debts.EntriesByType')
Ext.namespace('Lino.cbss.Sectors')
Ext.namespace('Lino.cbss.Purposes')
Ext.namespace('Lino.cbss.IdentifyPersonRequests')
Ext.namespace('Lino.cbss.ManageAccessRequests')
Ext.namespace('Lino.cbss.RetrieveTIGroupsRequests')
Ext.namespace('Lino.sessions.SessionTable')
Ext.namespace('Lino.ui.MyTextFieldTemplates')
Ext.namespace('Lino.users.MembershipsByUser')
Ext.namespace('Lino.users.AuthoritiesGiven')
Ext.namespace('Lino.users.AuthoritiesTaken')
Ext.namespace('Lino.countries.CitiesByCity')
Ext.namespace('Lino.countries.CitiesByCountry')
Ext.namespace('Lino.properties.PropsByGroup')
Ext.namespace('Lino.properties.PropsByType')
Ext.namespace('Lino.properties.ChoicesByType')
Ext.namespace('Lino.contacts.PartnersByCity')
Ext.namespace('Lino.contacts.PartnersByCountry')
Ext.namespace('Lino.contacts.RolesByCompany')
Ext.namespace('Lino.contacts.RolesByPerson')
Ext.namespace('Lino.postings.MyPostings')
Ext.namespace('Lino.postings.PostingsByPartner')
Ext.namespace('Lino.postings.PostingsByProject')
Ext.namespace('Lino.outbox.RecipientsByMail')
Ext.namespace('Lino.outbox.MyOutbox')
Ext.namespace('Lino.outbox.MailsByUser')
Ext.namespace('Lino.outbox.MailsByProject')
Ext.namespace('Lino.outbox.SentByPartner')
Ext.namespace('Lino.outbox.AttachmentsByMail')
Ext.namespace('Lino.cal.SubscriptionsByCalendar')
Ext.namespace('Lino.cal.SubscriptionsByUser')
Ext.namespace('Lino.cal.EventsByCalendar')
Ext.namespace('Lino.cal.EventsByPlace')
Ext.namespace('Lino.cal.EventsByProject')
Ext.namespace('Lino.cal.TasksByUser')
Ext.namespace('Lino.cal.MyTasks')
Ext.namespace('Lino.cal.MyTasksToDo')
Ext.namespace('Lino.cal.TasksByProject')
Ext.namespace('Lino.cal.GuestsByEvent')
Ext.namespace('Lino.cal.GuestsByRole')
Ext.namespace('Lino.cal.GuestsByPartner')
Ext.namespace('Lino.cal.MyPresences')
Ext.namespace('Lino.cal.MyPendingInvitations')
Ext.namespace('Lino.uploads.MyUploads')
Ext.namespace('Lino.households.HouseholdsByType')
Ext.namespace('Lino.households.MembersByHousehold')
Ext.namespace('Lino.households.MembersByPerson')
Ext.namespace('Lino.households.MembersByRole')
Ext.namespace('Lino.accounts.GroupsByChart')
Ext.namespace('Lino.accounts.AccountsByGroup')
Ext.namespace('Lino.notes.MyNotes')
Ext.namespace('Lino.notes.NotesByType')
Ext.namespace('Lino.notes.NotesByEventType')
Ext.namespace('Lino.notes.NotesByProject')
Ext.namespace('Lino.cv.LanguageKnowledgesByPerson')
Ext.namespace('Lino.cv.KnowledgesByLanguage')
Ext.namespace('Lino.cv.PropsByPerson')
Ext.namespace('Lino.cv.PersonPropsByProp')
Ext.namespace('Lino.cv.ConfiguredPropsByPerson')
Ext.namespace('Lino.cv.SkillsByPerson')
Ext.namespace('Lino.cv.SoftSkillsByPerson')
Ext.namespace('Lino.cv.ObstaclesByPerson')
Ext.namespace('Lino.pcsw.ClientsByNationality')
Ext.namespace('Lino.pcsw.ExclusionsByPerson')
Ext.namespace('Lino.pcsw.ContactsByClient')
Ext.namespace('Lino.pcsw.CoachingsByClient')
Ext.namespace('Lino.pcsw.CoachingsByUser')
Ext.namespace('Lino.pcsw.NotesByPerson')
Ext.namespace('Lino.pcsw.NotesByCompany')
Ext.namespace('Lino.isip.ContractsByPerson')
Ext.namespace('Lino.isip.ContractsByPolicy')
Ext.namespace('Lino.isip.ContractsByType')
Ext.namespace('Lino.jobs.FunctionsBySector')
Ext.namespace('Lino.jobs.ContractsByPerson')
Ext.namespace('Lino.jobs.ContractsByProvider')
Ext.namespace('Lino.jobs.ContractsByPolicy')
Ext.namespace('Lino.jobs.ContractsByJob')
Ext.namespace('Lino.jobs.ContractsByRegime')
Ext.namespace('Lino.jobs.ContractsBySchedule')
Ext.namespace('Lino.jobs.StudiesByCountry')
Ext.namespace('Lino.jobs.StudiesByCity')
Ext.namespace('Lino.jobs.StudiesByPerson')
Ext.namespace('Lino.jobs.ExperiencesByFunction')
Ext.namespace('Lino.jobs.ExperiencesByPerson')
Ext.namespace('Lino.jobs.CandidaturesByPerson')
Ext.namespace('Lino.jobs.CandidaturesBySector')
Ext.namespace('Lino.jobs.CandidaturesByFunction')
Ext.namespace('Lino.jobs.CandidaturesByJob')
Ext.namespace('Lino.jobs.CandidaturesByOffer')
Ext.namespace('Lino.jobs.ExperiencesByOffer')
Ext.namespace('Lino.jobs.JobsByProvider')
Ext.namespace('Lino.jobs.JobsByType')
Ext.namespace('Lino.jobs.ContractsByType')
Ext.namespace('Lino.jobs.JobsOverviewByType')
Ext.namespace('Lino.courses.CoursesByOffer')
Ext.namespace('Lino.courses.CourseOffersByProvider')
Ext.namespace('Lino.courses.CourseOffersByContent')
Ext.namespace('Lino.courses.CourseRequestsByPerson')
Ext.namespace('Lino.courses.CourseRequestsByContent')
Ext.namespace('Lino.courses.RequestsByCourse')
Ext.namespace('Lino.courses.ParticipantsByCourse')
Ext.namespace('Lino.courses.CandidatesByCourse')
Ext.namespace('Lino.newcomers.CompetencesByUser')
Ext.namespace('Lino.newcomers.CompetencesByFaculty')
Ext.namespace('Lino.newcomers.MyCompetences')
Ext.namespace('Lino.newcomers.ClientsByFaculty')
Ext.namespace('Lino.newcomers.AvailableCoachesByClient')
Ext.namespace('Lino.debts.MyBudgets')
Ext.namespace('Lino.debts.BudgetsByPartner')
Ext.namespace('Lino.debts.ActorsByBudget')
Ext.namespace('Lino.debts.ActorsByPartner')
Ext.namespace('Lino.debts.EntriesByBudget')
Ext.namespace('Lino.debts.ExpensesByBudget')
Ext.namespace('Lino.debts.IncomesByBudget')
Ext.namespace('Lino.debts.LiabilitiesByBudget')
Ext.namespace('Lino.debts.AssetsByBudget')
Ext.namespace('Lino.debts.DistByBudget')
Ext.namespace('Lino.cbss.MyIdentifyPersonRequests')
Ext.namespace('Lino.cbss.IdentifyRequestsByPerson')
Ext.namespace('Lino.cbss.ManageAccessRequestsByPerson')
Ext.namespace('Lino.cbss.MyManageAccessRequests')
Ext.namespace('Lino.cbss.RetrieveTIGroupsRequestsByPerson')
Ext.namespace('Lino.cbss.MyRetrieveTIGroupsRequests')
Ext.namespace('Lino.uploads.UploadsByController')
Ext.namespace('Lino.postings.PostingsByController')
Ext.namespace('Lino.cal.TasksByController')
Ext.namespace('Lino.outbox.MailsByController')
Ext.namespace('Lino.changes.ChangesByMaster')
Ext.namespace('Lino.ui.HelpTextsByModel')
Ext.namespace('Lino.outbox.AttachmentsByController')
Ext.namespace('Lino.cal.EventsByController')
Ext.namespace('Lino.about.Models')
Ext.namespace('Lino.about.FieldsByModel')
Ext.namespace('Lino.about.Inspector')
Ext.namespace('Lino.about.SourceFiles')
Ext.namespace('Lino.pcsw.UsersWithClients')
Ext.namespace('Lino.debts.PrintEntriesByBudget')
Ext.namespace('Lino.debts.PrintExpensesByBudget')
Ext.namespace('Lino.debts.PrintIncomesByBudget')
Ext.namespace('Lino.debts.PrintLiabilitiesByBudget')
Ext.namespace('Lino.debts.PrintAssetsByBudget')
Ext.namespace('Lino.debts.SummaryTable')
Ext.namespace('Lino.debts.ResultByBudget')
Ext.namespace('Lino.debts.DebtsByBudget')
Ext.namespace('Lino.debts.BailiffDebtsByBudget')
Ext.namespace('Lino.cbss.IdentifyPersonResult')
Ext.namespace('Lino.cbss.RetrieveTIGroupsResult')
Ext.namespace('Lino.ui.Home')
Ext.namespace('Lino.about.About')
Ext.namespace('Lino.cal.CalendarPanel')
Ext.namespace('Lino.lino.Home')
Ext.namespace('Lino.jobs.JobsOverview')
Ext.namespace('Lino.jobs.NewJobsOverview')
Ext.namespace('Lino.courses.CourseRequestStates')
Ext.namespace('Lino.postings.PostingStates')
Ext.namespace('Lino.cal.DurationUnits')
Ext.namespace('Lino.cal.TaskStates')
Ext.namespace('Lino.cal.Weekdays')
Ext.namespace('Lino.lino.UserLevels')
Ext.namespace('Lino.lino.UserProfiles')
Ext.namespace('Lino.cal.EventStates')
Ext.namespace('Lino.accounts.AccountTypes')
Ext.namespace('Lino.cv.CefLevel')
Ext.namespace('Lino.properties.HowWell')
Ext.namespace('Lino.jobs.CandidatureStates')
Ext.namespace('Lino.outbox.RecipientType')
Ext.namespace('Lino.countries.CityTypes')
Ext.namespace('Lino.pcsw.BeIdCardTypes')
Ext.namespace('Lino.pcsw.CivilState')
Ext.namespace('Lino.pcsw.ClientStates')
Ext.namespace('Lino.cal.GuestStates')
Ext.namespace('Lino.properties.DoYouLike')
Ext.namespace('Lino.cbss.RequestLanguages')
Ext.namespace('Lino.cbss.ManageAction')
Ext.namespace('Lino.pcsw.RefusalReasons')
Ext.namespace('Lino.lino.UserGroups')
Ext.namespace('Lino.cbss.RequestStates')
Ext.namespace('Lino.lino.ChangeTypes')
Ext.namespace('Lino.cal.AccessClasses')
Ext.namespace('Lino.cbss.QueryRegister')
Ext.namespace('Lino.lino.Genders')
Ext.namespace('Lino.pcsw.ResidenceType')

// ChoiceLists: 
Lino.courses.CourseRequestStates = [ [ "10", "Open" ], [ "20", "Registered" ], [ "30", "R\u00e9ussi" ], [ "40", "Bien r\u00e9ussi" ], [ "50", "echec" ], [ "60", "Abandonn\u00e9" ], [ "70", "Inactif" ] ];
Lino.postings.PostingStates = [ [ "10", "Ouvert" ], [ "20", "Pr\u00e8t \u00e0 imprimer" ], [ "30", "Imprim\u00e9" ], [ "40", "Ex\u00e9cut\u00e9" ], [ "50", "Retour" ] ];
Lino.cal.DurationUnits = [ [ "s", "secondes" ], [ "m", "minutes" ], [ "h", "heures" ], [ "D", "jours" ], [ "W", "semaines" ], [ "M", "mois" ], [ "Y", "ann\u00e9es" ] ];
Lino.cal.TaskStates = [ [ "10", "\u00e0 faire" ], [ "20", "Started" ], [ "30", "accomplie" ], [ "50", "Annul\u00e9" ] ];
Lino.cal.Weekdays = [ [ "1", "Lundi" ], [ "2", "Mardi" ], [ "3", "Mercredit" ], [ "4", "Jeudi" ], [ "5", "Vendredi" ], [ "6", "Samedi" ], [ "7", "Dimanche" ] ];
Lino.lino.UserLevels = [ [ "10", "Guest" ], [ "20", "Secr\u00e9taire" ], [ "30", "Utilisateur" ], [ "40", "Manager" ], [ "50", "Administrateur" ], [ "90", "Expert" ] ];
Lino.lino.UserProfiles = [ [ "000", "000 (Anonyme)" ], [ "100", "100 (Agent d'insertion)" ], [ "110", "110 (Agent d'insertion (chef de service))" ], [ "200", "200 (Consultat nouveaux clients)" ], [ "300", "300 (Consultate m\u00e9diateur dettes)" ], [ "500", "500 (BCSS seulement)" ], [ "900", "900 (Administrateur)" ] ];
Lino.cal.EventStates = [ [ "10", "Propos\u00e9" ], [ "20", "Draft" ], [ "30", "Communiqu\u00e9" ], [ "40", "Planif\u00e9" ], [ "50", "a eu lieu" ], [ "60", "D\u00e9plac\u00e9" ], [ "70", "Annul\u00e9" ], [ "80", "Absent" ] ];
Lino.accounts.AccountTypes = [ [ "A", "Actifs" ], [ "L", "Obligations" ], [ "I", "Revenus" ], [ "E", "D\u00e9penses" ], [ "C", "Capital" ], [ "B", "Bank accounts" ] ];
Lino.cv.CefLevel = [ [ "A1", "A1 (basic language skills)" ], [ "A2", "A2 (basic language skills)" ], [ "A2+", "A2+ (basic language skills)" ], [ "B1", "B1 (independent use of language)" ], [ "B2", "B2 (independent use of language)" ], [ "B2+", "B2+ (independent use of language)" ], [ "C1", "C1 (proficient use of language)" ], [ "C2", "C2 (proficient use of language)" ], [ "C2+", "C2+ (proficient use of language)" ] ];
Lino.properties.HowWell = [ [ "0", "not at all" ], [ "1", "a bit" ], [ "2", "moderate" ], [ "3", "quite well" ], [ "4", "very well" ] ];
Lino.jobs.CandidatureStates = [ [ "10", "Active" ], [ "20", "p\u00e9riode d'essai" ], [ "25", "Probation failed" ], [ "27", "Travaille" ], [ "30", "Inactive" ] ];
Lino.outbox.RecipientType = [ [ "to", "to" ], [ "cc", "cc" ], [ "bcc", "bcc" ] ];
Lino.countries.CityTypes = [ [ "10", "Member State" ], [ "11", "Division" ], [ "12", "Region" ], [ "13", "Community" ], [ "14", "Territory" ], [ "20", "County" ], [ "21", "Province" ], [ "22", "Shire" ], [ "23", "Subregion" ], [ "24", "Department" ], [ "25", "Arrondissement" ], [ "26", "Prefecture" ], [ "27", "District" ], [ "28", "Secteur" ], [ "50", "Ville" ], [ "51", "Town" ], [ "52", "Municipality" ], [ "54", "Parish" ], [ "55", "Township" ], [ "56", "Quarter" ], [ "61", "Borough" ], [ "62", "Small borough" ], [ "70", "Village" ] ];
Lino.pcsw.BeIdCardTypes = [ [ "1", "Registre national" ], [ "6", "Kids card (< 12 year)" ], [ "11", "Foreigner card A" ], [ "12", "Foreigner card B" ], [ "13", "Foreigner card C" ], [ "14", "Foreigner card D" ], [ "15", "Foreigner card E" ], [ "16", "Foreigner card E+" ], [ "17", "Foreigner card F" ], [ "18", "Foreigner card F+" ] ];
Lino.pcsw.CivilState = [ [ "10", "c\u00e9libataire" ], [ "13", "C\u00e9libateire cohabitant" ], [ "18", "C\u00e9libataire avec enfant" ], [ "20", "mari\u00e9" ], [ "21", "Mari\u00e9 (habitant seul)" ], [ "22", "Mari\u00e9 (vivant avec autre partenaire)" ], [ "30", "veuf/veuve" ], [ "33", "Veuf cohabitant" ], [ "40", "divorc\u00e9" ], [ "50", "s\u00e9par\u00e9" ] ];
Lino.pcsw.ClientStates = [ [ "10", "Nouveau" ], [ "20", "Refus\u00e9" ], [ "30", "Accompagn\u00e9" ], [ "50", "Ancien" ] ];
Lino.cal.GuestStates = [ [ "10", "Invit\u00e9" ], [ "20", "Accept\u00e9" ], [ "30", "Rejet\u00e9" ], [ "40", "Pr\u00e9sent" ], [ "50", "Absent" ] ];
Lino.properties.DoYouLike = [ [ "0", "certainly not" ], [ "1", "rather not" ], [ "2", "normally" ], [ "3", "quite much" ], [ "4", "very much" ] ];
Lino.cbss.RequestLanguages = [ [ "nl", "Dutch" ], [ "fr", "French" ], [ "de", "German" ] ];
Lino.cbss.ManageAction = [ [ "1", "Int\u00e9grer" ], [ "2", "Annuler int\u00e9gration" ], [ "3", "Listing" ] ];
Lino.pcsw.RefusalReasons = [ [ "10", "Information request (No coaching needed)" ], [ "20", "CPAS n'est pas comp\u00e9tent" ], [ "30", "Client n'est plus revenu" ] ];
Lino.lino.UserGroups = [ [ "office", "office (Office)" ], [ "accounting", "accounting (Comptabilit\u00e9)" ], [ "integ", "integ (Int\u00e9gration)" ], [ "newcomers", "newcomers (Nouvelles demandes)" ], [ "debts", "debts (M\u00e9diation de dettes)" ], [ "cbss", "cbss (BCSS)" ] ];
Lino.cbss.RequestStates = [ [ "10", "Ex\u00e9cut\u00e9" ], [ "20", "echec" ], [ "25", "Valid\u00e9" ], [ "30", "OK" ], [ "40", "Avertissements" ], [ "50", "Erreurs" ] ];
Lino.lino.ChangeTypes = [ [ "C", "Cr\u00e9er" ], [ "U", "Update" ], [ "D", "Supprimer" ], [ "R", "Remove child" ], [ "A", "Add child" ], [ "M", "Merge" ] ];
Lino.cal.AccessClasses = [ [ "10", "Priv\u00e9" ], [ "20", "Montrer \"occup\u00e9\"" ], [ "30", "Public" ] ];
Lino.cbss.QueryRegister = [ [ "1", "Primaire" ], [ "2", "Secondaire" ], [ "3", "Tous" ] ];
Lino.lino.Genders = [ [ "M", "Masculin" ], [ "F", "F\u00e9minin" ] ];
Lino.pcsw.ResidenceType = [ [ "1", "Registre national" ], [ "2", "Registre des \u00e9trangers" ], [ "3", "Registre d'attente " ] ];

Lino.jobs.JobsOverview.ParamsPanel = Ext.extend(Ext.form.FormPanel,{
  autoHeight: true,
  layout: "hbox",
  frame: true,
  layoutConfig: { "align": "stretchmax" },
  hideCheckBoxLabels: true,
  autoScroll: false,
  labelWidth: 243,
  border: false,
  bodyBorder: false,
  labelAlign: "top",
  initComponent : function() {
    var containing_panel = this;
    var contract_type3328 = new Lino.TwinCombo({ "fieldLabel": "Type de contrat de travail", "name": "contract_type", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.jobs.ContractTypes.detail)}, "emptyText": "Choisir Type de contrat de travail...", "selectOnFocus": true, "hiddenName": "contract_typeHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/jobs/JobsOverview/contract_type", "method": "GET" }) }) });
    var date3329 = new Lino.DateField({ "selectOnFocus": true, "fieldLabel": "Date", "anchor": "-20", "name": "date" });
    var job_type3330 = new Lino.TwinCombo({ "fieldLabel": "Type d'emploi", "name": "job_type", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.jobs.JobTypes.detail)}, "emptyText": "Choisir Type d'emploi...", "selectOnFocus": true, "hiddenName": "job_typeHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/jobs/JobsOverview/job_type", "method": "GET" }) }) });
    this.items = [ { "flex": 41, "autoHeight": true, "layout": "form", "xtype": "panel", "items": contract_type3328, "labelAlign": "top" }, { "flex": 16, "autoHeight": true, "layout": "form", "xtype": "panel", "items": date3329, "labelAlign": "top" }, { "flex": 41, "autoHeight": true, "layout": "form", "xtype": "panel", "items": job_type3330, "labelAlign": "top" } ];
    this.fields = [ contract_type3328, date3329, job_type3330 ];
    Lino.jobs.JobsOverview.ParamsPanel.superclass.initComponent.call(this);
  }
});


Lino.cal.Events.ParamsPanel = Ext.extend(Ext.form.FormPanel,{
  autoScroll: false,
  border: false,
  layout: "fit",
  hideCheckBoxLabels: true,
  frame: true,
  bodyBorder: false,
  labelAlign: "top",
  initComponent : function() {
    var containing_panel = this;
    var dates_from1008 = new Lino.DateField({ "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Date du","Nur Termine ab diesem Datum.") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Date du</span>", "anchor": "-20", "name": "dates_from" });
    var dates_to1009 = new Lino.DateField({ "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("au ","Nur Termine bis zu diesem Datum.") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">au </span>", "anchor": "-20", "name": "dates_to" });
    var user1010 = new Lino.TwinCombo({ "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Responsible user</span>", "name": "user", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.users.Users.detail)}, "emptyText": "Choisir Utilisateur...", "listeners": { "render": Lino.quicktip_renderer("Responsible user","Nur Termine dieses Benutzers.") }, "selectOnFocus": true, "hiddenName": "userHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/Events/user", "method": "GET" }) }) });
    var assigned_to1011 = new Lino.TwinCombo({ "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Attribu\u00e9 \u00e0</span>", "name": "assigned_to", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.users.Users.detail)}, "emptyText": "Choisir Utilisateur...", "listeners": { "render": Lino.quicktip_renderer("Attribu\u00e9 \u00e0","Nur Termine, die diesem Benutzer zugewiesen sind.") }, "selectOnFocus": true, "hiddenName": "assigned_toHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/Events/assigned_to", "method": "GET" }) }) });
    var state1012 = new Lino.ChoicesFieldElement({ "forceSelection": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">State</span>", "name": "state", "hiddenName": "stateHidden", "listeners": { "render": Lino.quicktip_renderer("State","Nur Termine in diesem Bearbeitungszustand.") }, "selectOnFocus": true, "anchor": "-20", "store": Lino.cal.EventStates });
    var unclear1013 = new Ext.form.Checkbox({ "boxLabel": "Mes rendez-vous \u00e0 clarifier", "hideLabel": true, "checked": false, "name": "unclear", "selectOnFocus": true, "anchor": "-20" });
    var main_1_panel1014 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 252, "hideCheckBoxLabels": true, "items": [ { "flex": 11, "autoHeight": true, "layout": "form", "xtype": "panel", "items": dates_from1008, "labelAlign": "top" }, { "flex": 11, "autoHeight": true, "layout": "form", "xtype": "panel", "items": dates_to1009, "labelAlign": "top" }, { "flex": 21, "autoHeight": true, "layout": "form", "xtype": "panel", "items": user1010, "labelAlign": "top" }, { "flex": 21, "autoHeight": true, "layout": "form", "xtype": "panel", "items": assigned_to1011, "labelAlign": "top" }, { "flex": 20, "autoHeight": true, "layout": "form", "xtype": "panel", "items": state1012, "labelAlign": "top" }, { "flex": 14, "autoHeight": true, "layout": "form", "xtype": "panel", "items": unclear1013, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    this.items = [ main_1_panel1014 ];
    this.fields = [ dates_from1008, dates_to1009, user1010, assigned_to1011, state1012, unclear1013 ];
    Lino.cal.Events.ParamsPanel.superclass.initComponent.call(this);
  }
});


Lino.pcsw.Clients.ParamsPanel = Ext.extend(Ext.form.FormPanel,{
  autoScroll: false,
  autoHeight: true,
  border: false,
  layout: "form",
  hideCheckBoxLabels: true,
  frame: true,
  bodyBorder: false,
  labelAlign: "top",
  initComponent : function() {
    var containing_panel = this;
    var aged_from2204 = new Ext.form.NumberField({ "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Age: de","Nur Klienten, die mindestens so alt sind.") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Age: de</span>", "anchor": "-20", "name": "aged_from" });
    var aged_to2205 = new Ext.form.NumberField({ "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Age: jusque","Nur Klienten, die h\u00f6chstens so alt sind.") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Age: jusque</span>", "anchor": "-20", "name": "aged_to" });
    var gender2206 = new Lino.ChoicesFieldElement({ "forceSelection": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Sexe</span>", "name": "gender", "hiddenName": "genderHidden", "listeners": { "render": Lino.quicktip_renderer("Sexe","Nur Personen, deren Feld \"Geschlecht\" ausgef\u00fcllt ist und dem angegebenen Wert entspricht.") }, "selectOnFocus": true, "anchor": "-20", "store": Lino.lino.Genders });
    var also_obsolete2207 = new Ext.form.Checkbox({ "boxLabel": "aussi clients obsol\u00e8tes", "listeners": { "render": Lino.quicktip_renderer("aussi clients obsol\u00e8tes","Auch Datens\u00e4tze anzeigen, die als veraltet markiert sind.") }, "hideLabel": true, "checked": false, "name": "also_obsolete", "selectOnFocus": true, "anchor": "-20" });
    var main_1_panel2208 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 17, "autoHeight": true, "layout": "form", "xtype": "panel", "items": aged_from2204, "labelAlign": "top" }, { "flex": 17, "autoHeight": true, "layout": "form", "xtype": "panel", "items": aged_to2205, "labelAlign": "top" }, { "flex": 31, "autoHeight": true, "layout": "form", "xtype": "panel", "items": gender2206, "labelAlign": "top" }, { "flex": 34, "autoHeight": true, "layout": "form", "xtype": "panel", "items": also_obsolete2207, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 216, "border": false, "anchor": "-20", "labelAlign": "top" });
    var client_state2213 = new Lino.ChoicesFieldElement({ "forceSelection": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">State</span>", "name": "client_state", "hiddenName": "client_stateHidden", "listeners": { "render": Lino.quicktip_renderer("State","Nur Klienten mit diesem Status (Aktenzustand).") }, "selectOnFocus": true, "anchor": "-20", "store": Lino.pcsw.ClientStates });
    var coached_by2214 = new Lino.TwinCombo({ "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">AI</span>", "name": "coached_by", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.users.Users.detail)}, "emptyText": "Choisir Utilisateur...", "listeners": { "render": Lino.quicktip_renderer("AI","Nur Klienten, die eine Begleitung mit diesem Benutzer haben.") }, "selectOnFocus": true, "hiddenName": "coached_byHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/pcsw/Clients/coached_by", "method": "GET" }) }) });
    var and_coached_by2215 = new Lino.TwinCombo({ "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">et par</span>", "name": "and_coached_by", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.users.Users.detail)}, "emptyText": "Choisir Utilisateur...", "listeners": { "render": Lino.quicktip_renderer("et par","Nur Klienten, die auch mit diesem Benutzer eine Begleitung haben.") }, "selectOnFocus": true, "hiddenName": "and_coached_byHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/pcsw/Clients/and_coached_by", "method": "GET" }) }) });
    var coached_on2216 = new Lino.DateField({ "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Accompagn\u00e9 le","Nur Klienten, die zu diesem Datum effektiv begleitet waren \n(d.h. die mindestens eine aktive Begleitung an diesem Datum haben)") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Accompagn\u00e9 le</span>", "anchor": "-20", "name": "coached_on" });
    var only_primary2217 = new Ext.form.Checkbox({ "boxLabel": "Dossiers primaires seulement", "listeners": { "render": Lino.quicktip_renderer("Dossiers primaires seulement","Nur Klienten, die eine effektive <b>prim\u00e4re</b> Begleitung haben.") }, "hideLabel": true, "checked": false, "name": "only_primary", "selectOnFocus": true, "anchor": "-20" });
    var nationality2218 = new Lino.TwinCombo({ "fieldLabel": "Nationalit\u00e9", "name": "nationality", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.countries.Countries.detail)}, "emptyText": "Choisir Pays...", "selectOnFocus": true, "hiddenName": "nationalityHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/pcsw/Clients/nationality", "method": "GET" }) }) });
    var main_2_panel2219 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 13, "autoHeight": true, "layout": "form", "xtype": "panel", "items": client_state2213, "labelAlign": "top" }, { "flex": 18, "autoHeight": true, "layout": "form", "xtype": "panel", "items": coached_by2214, "labelAlign": "top" }, { "flex": 18, "autoHeight": true, "layout": "form", "xtype": "panel", "items": and_coached_by2215, "labelAlign": "top" }, { "flex": 10, "autoHeight": true, "layout": "form", "xtype": "panel", "items": coached_on2216, "labelAlign": "top" }, { "flex": 12, "autoHeight": true, "layout": "form", "xtype": "panel", "items": only_primary2217, "labelAlign": "top" }, { "flex": 25, "autoHeight": true, "layout": "form", "xtype": "panel", "items": nationality2218, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 261, "border": false, "anchor": "-20", "labelAlign": "top" });
    this.items = [ main_1_panel2208, main_2_panel2219 ];
    this.fields = [ aged_from2204, aged_to2205, gender2206, also_obsolete2207, client_state2213, coached_by2214, and_coached_by2215, coached_on2216, only_primary2217, nationality2218 ];
    Lino.pcsw.Clients.ParamsPanel.superclass.initComponent.call(this);
  }
});


Lino.courses.PendingCourseRequests.ParamsPanel = Ext.extend(Ext.form.FormPanel,{
  autoScroll: false,
  autoHeight: true,
  border: false,
  layout: "form",
  hideCheckBoxLabels: true,
  frame: true,
  bodyBorder: false,
  labelAlign: "top",
  initComponent : function() {
    var containing_panel = this;
    var aged_from2951 = new Ext.form.NumberField({ "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Age: de","Nur Klienten, die mindestens so alt sind.") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Age: de</span>", "anchor": "-20", "name": "aged_from" });
    var aged_to2952 = new Ext.form.NumberField({ "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Age: jusque","Nur Klienten, die h\u00f6chstens so alt sind.") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Age: jusque</span>", "anchor": "-20", "name": "aged_to" });
    var gender2953 = new Lino.ChoicesFieldElement({ "forceSelection": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Sexe</span>", "name": "gender", "hiddenName": "genderHidden", "listeners": { "render": Lino.quicktip_renderer("Sexe","Nur Personen, deren Feld \"Geschlecht\" ausgef\u00fcllt ist und dem angegebenen Wert entspricht.") }, "selectOnFocus": true, "anchor": "-20", "store": Lino.lino.Genders });
    var also_obsolete2954 = new Ext.form.Checkbox({ "boxLabel": "aussi clients obsol\u00e8tes", "listeners": { "render": Lino.quicktip_renderer("aussi clients obsol\u00e8tes","Auch Datens\u00e4tze anzeigen, die als veraltet markiert sind.") }, "hideLabel": true, "checked": false, "name": "also_obsolete", "selectOnFocus": true, "anchor": "-20" });
    var main_1_panel2955 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 17, "autoHeight": true, "layout": "form", "xtype": "panel", "items": aged_from2951, "labelAlign": "top" }, { "flex": 17, "autoHeight": true, "layout": "form", "xtype": "panel", "items": aged_to2952, "labelAlign": "top" }, { "flex": 31, "autoHeight": true, "layout": "form", "xtype": "panel", "items": gender2953, "labelAlign": "top" }, { "flex": 34, "autoHeight": true, "layout": "form", "xtype": "panel", "items": also_obsolete2954, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 216, "border": false, "anchor": "-20", "labelAlign": "top" });
    var client_state2960 = new Lino.ChoicesFieldElement({ "forceSelection": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">State</span>", "name": "client_state", "hiddenName": "client_stateHidden", "listeners": { "render": Lino.quicktip_renderer("State","Nur Klienten mit diesem Status (Aktenzustand).") }, "selectOnFocus": true, "anchor": "-20", "store": Lino.pcsw.ClientStates });
    var coached_by2961 = new Lino.TwinCombo({ "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">AI</span>", "name": "coached_by", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.users.Users.detail)}, "emptyText": "Choisir Utilisateur...", "listeners": { "render": Lino.quicktip_renderer("AI","Nur Klienten, die eine Begleitung mit diesem Benutzer haben.") }, "selectOnFocus": true, "hiddenName": "coached_byHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/courses/PendingCourseRequests/coached_by", "method": "GET" }) }) });
    var and_coached_by2962 = new Lino.TwinCombo({ "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">et par</span>", "name": "and_coached_by", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.users.Users.detail)}, "emptyText": "Choisir Utilisateur...", "listeners": { "render": Lino.quicktip_renderer("et par","Nur Klienten, die auch mit diesem Benutzer eine Begleitung haben.") }, "selectOnFocus": true, "hiddenName": "and_coached_byHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/courses/PendingCourseRequests/and_coached_by", "method": "GET" }) }) });
    var coached_on2963 = new Lino.DateField({ "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Accompagn\u00e9 le","Nur Klienten, die zu diesem Datum effektiv begleitet waren \n(d.h. die mindestens eine aktive Begleitung an diesem Datum haben)") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Accompagn\u00e9 le</span>", "anchor": "-20", "name": "coached_on" });
    var only_primary2964 = new Ext.form.Checkbox({ "boxLabel": "Dossiers primaires seulement", "listeners": { "render": Lino.quicktip_renderer("Dossiers primaires seulement","Nur Klienten, die eine effektive <b>prim\u00e4re</b> Begleitung haben.") }, "hideLabel": true, "checked": false, "name": "only_primary", "selectOnFocus": true, "anchor": "-20" });
    var nationality2965 = new Lino.TwinCombo({ "fieldLabel": "Nationalit\u00e9", "name": "nationality", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.countries.Countries.detail)}, "emptyText": "Choisir Pays...", "selectOnFocus": true, "hiddenName": "nationalityHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/courses/PendingCourseRequests/nationality", "method": "GET" }) }) });
    var main_2_panel2966 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 13, "autoHeight": true, "layout": "form", "xtype": "panel", "items": client_state2960, "labelAlign": "top" }, { "flex": 18, "autoHeight": true, "layout": "form", "xtype": "panel", "items": coached_by2961, "labelAlign": "top" }, { "flex": 18, "autoHeight": true, "layout": "form", "xtype": "panel", "items": and_coached_by2962, "labelAlign": "top" }, { "flex": 10, "autoHeight": true, "layout": "form", "xtype": "panel", "items": coached_on2963, "labelAlign": "top" }, { "flex": 12, "autoHeight": true, "layout": "form", "xtype": "panel", "items": only_primary2964, "labelAlign": "top" }, { "flex": 25, "autoHeight": true, "layout": "form", "xtype": "panel", "items": nationality2965, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 261, "border": false, "anchor": "-20", "labelAlign": "top" });
    var request_state2973 = new Lino.ChoicesFieldElement({ "forceSelection": true, "fieldLabel": "State", "name": "request_state", "selectOnFocus": true, "anchor": "-20", "store": Lino.courses.CourseRequestStates, "hiddenName": "request_stateHidden" });
    var course_content2974 = new Lino.TwinCombo({ "fieldLabel": "Contenu de cours", "name": "course_content", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.courses.CourseContents.detail)}, "emptyText": "Choisir Contenu de cours...", "selectOnFocus": true, "hiddenName": "course_contentHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/courses/PendingCourseRequests/course_content", "method": "GET" }) }) });
    var course_provider2975 = new Lino.TwinCombo({ "fieldLabel": "Organisateur de cours", "name": "course_provider", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.courses.CourseProviders.detail)}, "emptyText": "Choisir Organisateur de cours...", "selectOnFocus": true, "hiddenName": "course_providerHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/courses/PendingCourseRequests/course_provider", "method": "GET" }) }) });
    var main_3_panel2976 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 24, "autoHeight": true, "layout": "form", "xtype": "panel", "items": request_state2973, "labelAlign": "top" }, { "flex": 37, "autoHeight": true, "layout": "form", "xtype": "panel", "items": course_content2974, "labelAlign": "top" }, { "flex": 37, "autoHeight": true, "layout": "form", "xtype": "panel", "items": course_provider2975, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 198, "border": false, "anchor": "-20", "labelAlign": "top" });
    this.items = [ main_1_panel2955, main_2_panel2966, main_3_panel2976 ];
    this.fields = [ aged_from2951, aged_to2952, gender2953, also_obsolete2954, client_state2960, coached_by2961, and_coached_by2962, coached_on2963, only_primary2964, nationality2965, request_state2973, course_content2974, course_provider2975 ];
    Lino.courses.PendingCourseRequests.ParamsPanel.superclass.initComponent.call(this);
  }
});


Lino.jobs.NewJobsOverview.ParamsPanel = Ext.extend(Ext.form.FormPanel,{
  autoHeight: true,
  layout: "hbox",
  frame: true,
  layoutConfig: { "align": "stretchmax" },
  hideCheckBoxLabels: true,
  autoScroll: false,
  labelWidth: 126,
  border: false,
  bodyBorder: false,
  labelAlign: "top",
  initComponent : function() {
    var containing_panel = this;
    var job_type3337 = new Lino.TwinCombo({ "fieldLabel": "Type d'emploi", "name": "job_type", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.jobs.JobTypes.detail)}, "emptyText": "Choisir Type d'emploi...", "selectOnFocus": true, "hiddenName": "job_typeHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/jobs/NewJobsOverview/job_type", "method": "GET" }) }) });
    var today3338 = new Lino.DateField({ "selectOnFocus": true, "fieldLabel": "Date", "anchor": "-20", "name": "today" });
    this.items = [ { "flex": 71, "autoHeight": true, "layout": "form", "xtype": "panel", "items": job_type3337, "labelAlign": "top" }, { "flex": 28, "autoHeight": true, "layout": "form", "xtype": "panel", "items": today3338, "labelAlign": "top" } ];
    this.fields = [ job_type3337, today3338 ];
    Lino.jobs.NewJobsOverview.ParamsPanel.superclass.initComponent.call(this);
  }
});


Lino.isip.Contracts.ParamsPanel = Ext.extend(Ext.form.FormPanel,{
  autoHeight: true,
  layout: "hbox",
  frame: true,
  layoutConfig: { "align": "stretchmax" },
  hideCheckBoxLabels: true,
  autoScroll: false,
  labelWidth: 252,
  border: false,
  bodyBorder: false,
  labelAlign: "top",
  initComponent : function() {
    var containing_panel = this;
    var user1878 = new Lino.TwinCombo({ "fieldLabel": "Utilisateur", "name": "user", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.users.Users.detail)}, "emptyText": "Choisir Utilisateur...", "selectOnFocus": true, "hiddenName": "userHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/isip/Contracts/user", "method": "GET" }) }) });
    var type1879 = new Lino.TwinCombo({ "fieldLabel": "Uniquement contrats de type", "name": "type", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.isip.ContractTypes.detail)}, "emptyText": "Choisir Type de PIIS...", "selectOnFocus": true, "hiddenName": "typeHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/isip/Contracts/type", "method": "GET" }) }) });
    var show_past1880 = new Ext.form.Checkbox({ "boxLabel": "contrats termin\u00e9s", "hideLabel": true, "checked": true, "name": "show_past", "selectOnFocus": true, "anchor": "-20" });
    var show_active1881 = new Ext.form.Checkbox({ "boxLabel": "contrats actifs", "hideLabel": true, "checked": true, "name": "show_active", "selectOnFocus": true, "anchor": "-20" });
    var show_coming1882 = new Ext.form.Checkbox({ "boxLabel": "contrats \u00e0 venir", "hideLabel": true, "checked": true, "name": "show_coming", "selectOnFocus": true, "anchor": "-20" });
    var today1883 = new Lino.DateField({ "selectOnFocus": true, "fieldLabel": "le", "anchor": "-20", "name": "today" });
    this.items = [ { "flex": 20, "autoHeight": true, "layout": "form", "xtype": "panel", "items": user1878, "labelAlign": "top" }, { "flex": 27, "autoHeight": true, "layout": "form", "xtype": "panel", "items": type1879, "labelAlign": "top" }, { "flex": 13, "autoHeight": true, "layout": "form", "xtype": "panel", "items": show_past1880, "labelAlign": "top" }, { "flex": 13, "autoHeight": true, "layout": "form", "xtype": "panel", "items": show_active1881, "labelAlign": "top" }, { "flex": 13, "autoHeight": true, "layout": "form", "xtype": "panel", "items": show_coming1882, "labelAlign": "top" }, { "flex": 10, "autoHeight": true, "layout": "form", "xtype": "panel", "items": today1883, "labelAlign": "top" } ];
    this.fields = [ user1878, type1879, show_past1880, show_active1881, show_coming1882, today1883 ];
    Lino.isip.Contracts.ParamsPanel.superclass.initComponent.call(this);
  }
});


Lino.contacts.Persons.ParamsPanel = Ext.extend(Ext.form.FormPanel,{
  autoScroll: false,
  border: false,
  layout: "fit",
  hideCheckBoxLabels: true,
  frame: true,
  bodyBorder: false,
  labelAlign: "top",
  initComponent : function() {
    var containing_panel = this;
    var gender1549 = new Lino.ChoicesFieldElement({ "forceSelection": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Sexe</span>", "name": "gender", "hiddenName": "genderHidden", "listeners": { "render": Lino.quicktip_renderer("Sexe","Nur Personen, deren Feld \"Geschlecht\" ausgef\u00fcllt ist und dem angegebenen Wert entspricht.") }, "selectOnFocus": true, "anchor": "-20", "store": Lino.lino.Genders });
    var also_obsolete1550 = new Ext.form.Checkbox({ "boxLabel": "aussi clients obsol\u00e8tes", "listeners": { "render": Lino.quicktip_renderer("aussi clients obsol\u00e8tes","Auch Datens\u00e4tze anzeigen, die als veraltet markiert sind.") }, "hideLabel": true, "checked": false, "name": "also_obsolete", "selectOnFocus": true, "anchor": "-20" });
    var main_1_panel1551 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 216, "hideCheckBoxLabels": true, "items": [ { "flex": 47, "autoHeight": true, "layout": "form", "xtype": "panel", "items": gender1549, "labelAlign": "top" }, { "flex": 52, "autoHeight": true, "layout": "form", "xtype": "panel", "items": also_obsolete1550, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    this.items = [ main_1_panel1551 ];
    this.fields = [ gender1549, also_obsolete1550 ];
    Lino.contacts.Persons.ParamsPanel.superclass.initComponent.call(this);
  }
});


Lino.newcomers.NewClients.ParamsPanel = Ext.extend(Ext.form.FormPanel,{
  autoHeight: true,
  layout: "hbox",
  frame: true,
  layoutConfig: { "align": "stretchmax" },
  hideCheckBoxLabels: true,
  autoScroll: false,
  labelWidth: 297,
  border: false,
  bodyBorder: false,
  labelAlign: "top",
  initComponent : function() {
    var containing_panel = this;
    var also_refused3073 = new Ext.form.Checkbox({ "boxLabel": "Also refused clients", "hideLabel": true, "checked": false, "name": "also_refused", "selectOnFocus": true, "anchor": "-20" });
    var also_obsolete3074 = new Ext.form.Checkbox({ "boxLabel": "Also deprecated clients", "hideLabel": true, "checked": false, "name": "also_obsolete", "selectOnFocus": true, "anchor": "-20" });
    var new_since3075 = new Lino.DateField({ "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Also newly coached clients since","Auch Klienten, die erst seit Kurzem begleitet sind.") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Also newly coached clients since</span>", "anchor": "-20", "name": "new_since" });
    var coached_by3076 = new Lino.TwinCombo({ "fieldLabel": "AI", "name": "coached_by", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.users.Users.detail)}, "emptyText": "Choisir Utilisateur...", "selectOnFocus": true, "hiddenName": "coached_byHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/newcomers/NewClients/coached_by", "method": "GET" }) }) });
    this.items = [ { "flex": 23, "autoHeight": true, "layout": "form", "xtype": "panel", "items": also_refused3073, "labelAlign": "top" }, { "flex": 23, "autoHeight": true, "layout": "form", "xtype": "panel", "items": also_obsolete3074, "labelAlign": "top" }, { "flex": 18, "autoHeight": true, "layout": "form", "xtype": "panel", "items": new_since3075, "labelAlign": "top" }, { "flex": 34, "autoHeight": true, "layout": "form", "xtype": "panel", "items": coached_by3076, "labelAlign": "top" } ];
    this.fields = [ also_refused3073, also_obsolete3074, new_since3075, coached_by3076 ];
    Lino.newcomers.NewClients.ParamsPanel.superclass.initComponent.call(this);
  }
});


Lino.pcsw.IntegClients.ParamsPanel = Ext.extend(Ext.form.FormPanel,{
  autoScroll: false,
  autoHeight: true,
  border: false,
  layout: "form",
  hideCheckBoxLabels: true,
  frame: true,
  bodyBorder: false,
  labelAlign: "top",
  initComponent : function() {
    var containing_panel = this;
    var client_state2227 = new Lino.ChoicesFieldElement({ "forceSelection": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">State</span>", "name": "client_state", "hiddenName": "client_stateHidden", "listeners": { "render": Lino.quicktip_renderer("State","Nur Klienten mit diesem Status (Aktenzustand).") }, "selectOnFocus": true, "anchor": "-20", "store": Lino.pcsw.ClientStates });
    var coached_by2228 = new Lino.TwinCombo({ "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">AI</span>", "name": "coached_by", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.users.Users.detail)}, "emptyText": "Choisir Utilisateur...", "listeners": { "render": Lino.quicktip_renderer("AI","Nur Klienten, die eine Begleitung mit diesem Benutzer haben.") }, "selectOnFocus": true, "hiddenName": "coached_byHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/pcsw/IntegClients/coached_by", "method": "GET" }) }) });
    var and_coached_by2229 = new Lino.TwinCombo({ "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">et par</span>", "name": "and_coached_by", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.users.Users.detail)}, "emptyText": "Choisir Utilisateur...", "listeners": { "render": Lino.quicktip_renderer("et par","Nur Klienten, die auch mit diesem Benutzer eine Begleitung haben.") }, "selectOnFocus": true, "hiddenName": "and_coached_byHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/pcsw/IntegClients/and_coached_by", "method": "GET" }) }) });
    var coached_on2230 = new Lino.DateField({ "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Accompagn\u00e9 le","Nur Klienten, die zu diesem Datum effektiv begleitet waren \n(d.h. die mindestens eine aktive Begleitung an diesem Datum haben)") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Accompagn\u00e9 le</span>", "anchor": "-20", "name": "coached_on" });
    var only_primary2231 = new Ext.form.Checkbox({ "boxLabel": "Dossiers primaires seulement", "listeners": { "render": Lino.quicktip_renderer("Dossiers primaires seulement","Nur Klienten, die eine effektive <b>prim\u00e4re</b> Begleitung haben.") }, "hideLabel": true, "checked": false, "name": "only_primary", "selectOnFocus": true, "anchor": "-20" });
    var also_obsolete2232 = new Ext.form.Checkbox({ "boxLabel": "aussi clients obsol\u00e8tes", "listeners": { "render": Lino.quicktip_renderer("aussi clients obsol\u00e8tes","Auch Datens\u00e4tze anzeigen, die als veraltet markiert sind.") }, "hideLabel": true, "checked": false, "name": "also_obsolete", "selectOnFocus": true, "anchor": "-20" });
    var main_1_panel2233 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 15, "autoHeight": true, "layout": "form", "xtype": "panel", "items": client_state2227, "labelAlign": "top" }, { "flex": 21, "autoHeight": true, "layout": "form", "xtype": "panel", "items": coached_by2228, "labelAlign": "top" }, { "flex": 21, "autoHeight": true, "layout": "form", "xtype": "panel", "items": and_coached_by2229, "labelAlign": "top" }, { "flex": 11, "autoHeight": true, "layout": "form", "xtype": "panel", "items": coached_on2230, "labelAlign": "top" }, { "flex": 14, "autoHeight": true, "layout": "form", "xtype": "panel", "items": only_primary2231, "labelAlign": "top" }, { "flex": 14, "autoHeight": true, "layout": "form", "xtype": "panel", "items": also_obsolete2232, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 261, "border": false, "anchor": "-20", "labelAlign": "top" });
    var aged_from2240 = new Ext.form.NumberField({ "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Age: de","Nur Klienten, die mindestens so alt sind.") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Age: de</span>", "anchor": "-20", "name": "aged_from" });
    var aged_to2241 = new Ext.form.NumberField({ "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Age: jusque","Nur Klienten, die h\u00f6chstens so alt sind.") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Age: jusque</span>", "anchor": "-20", "name": "aged_to" });
    var gender2242 = new Lino.ChoicesFieldElement({ "forceSelection": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Sexe</span>", "name": "gender", "hiddenName": "genderHidden", "listeners": { "render": Lino.quicktip_renderer("Sexe","Nur Personen, deren Feld \"Geschlecht\" ausgef\u00fcllt ist und dem angegebenen Wert entspricht.") }, "selectOnFocus": true, "anchor": "-20", "store": Lino.lino.Genders });
    var nationality2243 = new Lino.TwinCombo({ "fieldLabel": "Nationalit\u00e9", "name": "nationality", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.countries.Countries.detail)}, "emptyText": "Choisir Pays...", "selectOnFocus": true, "hiddenName": "nationalityHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/pcsw/IntegClients/nationality", "method": "GET" }) }) });
    var main_2_panel2244 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 12, "autoHeight": true, "layout": "form", "xtype": "panel", "items": aged_from2240, "labelAlign": "top" }, { "flex": 12, "autoHeight": true, "layout": "form", "xtype": "panel", "items": aged_to2241, "labelAlign": "top" }, { "flex": 23, "autoHeight": true, "layout": "form", "xtype": "panel", "items": gender2242, "labelAlign": "top" }, { "flex": 51, "autoHeight": true, "layout": "form", "xtype": "panel", "items": nationality2243, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 108, "border": false, "anchor": "-20", "labelAlign": "top" });
    var language2249 = new Lino.TwinCombo({ "fieldLabel": "Connaissance de langue", "name": "language", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.countries.Languages.detail)}, "emptyText": "Choisir Langue...", "selectOnFocus": true, "hiddenName": "languageHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/pcsw/IntegClients/language", "method": "GET" }) }) });
    var wanted_property2250 = new Lino.TwinCombo({ "fieldLabel": "Comp\u00e9tence requise", "name": "wanted_property", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.properties.Properties.detail)}, "emptyText": "Choisir Propri\u00e9t\u00e9...", "selectOnFocus": true, "hiddenName": "wanted_propertyHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/pcsw/IntegClients/wanted_property", "method": "GET" }) }) });
    var group2251 = new Lino.RemoteComboFieldElement({ "fieldLabel": "Phase d'int\u00e9gration", "name": "group", "pageSize": 20, "emptyText": "Choisir Phase d'int\u00e9gration...", "selectOnFocus": true, "hiddenName": "groupHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/pcsw/IntegClients/group", "method": "GET" }) }) });
    var only_active2252 = new Ext.form.Checkbox({ "boxLabel": "Clients actifs seulement", "listeners": { "render": Lino.quicktip_renderer("Clients actifs seulement","Show only clients in 'active' integration phases") }, "hideLabel": true, "checked": false, "name": "only_active", "selectOnFocus": true, "anchor": "-20" });
    var main_3_panel2253 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 28, "autoHeight": true, "layout": "form", "xtype": "panel", "items": language2249, "labelAlign": "top" }, { "flex": 28, "autoHeight": true, "layout": "form", "xtype": "panel", "items": wanted_property2250, "labelAlign": "top" }, { "flex": 28, "autoHeight": true, "layout": "form", "xtype": "panel", "items": group2251, "labelAlign": "top" }, { "flex": 14, "autoHeight": true, "layout": "form", "xtype": "panel", "items": only_active2252, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 225, "border": false, "anchor": "-20", "labelAlign": "top" });
    this.items = [ main_1_panel2233, main_2_panel2244, main_3_panel2253 ];
    this.fields = [ client_state2227, coached_by2228, and_coached_by2229, coached_on2230, only_primary2231, also_obsolete2232, aged_from2240, aged_to2241, gender2242, nationality2243, language2249, wanted_property2250, group2251, only_active2252 ];
    Lino.pcsw.IntegClients.ParamsPanel.superclass.initComponent.call(this);
  }
});


Lino.about.Inspector.ParamsPanel = Ext.extend(Ext.form.FormPanel,{
  autoHeight: true,
  layout: "hbox",
  frame: true,
  layoutConfig: { "align": "stretchmax" },
  hideCheckBoxLabels: true,
  autoScroll: false,
  labelWidth: 153,
  border: false,
  bodyBorder: false,
  labelAlign: "top",
  initComponent : function() {
    var containing_panel = this;
    var inspected3309 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 100, "fieldLabel": "Inspected object", "anchor": "-20", "name": "inspected" });
    var show_callables3310 = new Ext.form.Checkbox({ "boxLabel": "show callables", "hideLabel": true, "checked": false, "name": "show_callables", "selectOnFocus": true, "anchor": "-20" });
    this.items = [ { "flex": 67, "autoHeight": true, "layout": "form", "xtype": "panel", "items": inspected3309, "labelAlign": "top" }, { "flex": 32, "autoHeight": true, "layout": "form", "xtype": "panel", "items": show_callables3310, "labelAlign": "top" } ];
    this.fields = [ inspected3309, show_callables3310 ];
    Lino.about.Inspector.ParamsPanel.superclass.initComponent.call(this);
  }
});


Lino.pcsw.ClientsTest.ParamsPanel = Ext.extend(Ext.form.FormPanel,{
  autoScroll: false,
  autoHeight: true,
  border: false,
  layout: "form",
  hideCheckBoxLabels: true,
  frame: true,
  bodyBorder: false,
  labelAlign: "top",
  initComponent : function() {
    var containing_panel = this;
    var aged_from2259 = new Ext.form.NumberField({ "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Age: de","Nur Klienten, die mindestens so alt sind.") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Age: de</span>", "anchor": "-20", "name": "aged_from" });
    var aged_to2260 = new Ext.form.NumberField({ "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Age: jusque","Nur Klienten, die h\u00f6chstens so alt sind.") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Age: jusque</span>", "anchor": "-20", "name": "aged_to" });
    var gender2261 = new Lino.ChoicesFieldElement({ "forceSelection": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Sexe</span>", "name": "gender", "hiddenName": "genderHidden", "listeners": { "render": Lino.quicktip_renderer("Sexe","Nur Personen, deren Feld \"Geschlecht\" ausgef\u00fcllt ist und dem angegebenen Wert entspricht.") }, "selectOnFocus": true, "anchor": "-20", "store": Lino.lino.Genders });
    var also_obsolete2262 = new Ext.form.Checkbox({ "boxLabel": "aussi clients obsol\u00e8tes", "listeners": { "render": Lino.quicktip_renderer("aussi clients obsol\u00e8tes","Auch Datens\u00e4tze anzeigen, die als veraltet markiert sind.") }, "hideLabel": true, "checked": false, "name": "also_obsolete", "selectOnFocus": true, "anchor": "-20" });
    var main_1_panel2263 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 17, "autoHeight": true, "layout": "form", "xtype": "panel", "items": aged_from2259, "labelAlign": "top" }, { "flex": 17, "autoHeight": true, "layout": "form", "xtype": "panel", "items": aged_to2260, "labelAlign": "top" }, { "flex": 31, "autoHeight": true, "layout": "form", "xtype": "panel", "items": gender2261, "labelAlign": "top" }, { "flex": 34, "autoHeight": true, "layout": "form", "xtype": "panel", "items": also_obsolete2262, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 216, "border": false, "anchor": "-20", "labelAlign": "top" });
    var client_state2268 = new Lino.ChoicesFieldElement({ "forceSelection": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">State</span>", "name": "client_state", "hiddenName": "client_stateHidden", "listeners": { "render": Lino.quicktip_renderer("State","Nur Klienten mit diesem Status (Aktenzustand).") }, "selectOnFocus": true, "anchor": "-20", "store": Lino.pcsw.ClientStates });
    var coached_by2269 = new Lino.TwinCombo({ "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">AI</span>", "name": "coached_by", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.users.Users.detail)}, "emptyText": "Choisir Utilisateur...", "listeners": { "render": Lino.quicktip_renderer("AI","Nur Klienten, die eine Begleitung mit diesem Benutzer haben.") }, "selectOnFocus": true, "hiddenName": "coached_byHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/pcsw/ClientsTest/coached_by", "method": "GET" }) }) });
    var and_coached_by2270 = new Lino.TwinCombo({ "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">et par</span>", "name": "and_coached_by", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.users.Users.detail)}, "emptyText": "Choisir Utilisateur...", "listeners": { "render": Lino.quicktip_renderer("et par","Nur Klienten, die auch mit diesem Benutzer eine Begleitung haben.") }, "selectOnFocus": true, "hiddenName": "and_coached_byHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/pcsw/ClientsTest/and_coached_by", "method": "GET" }) }) });
    var coached_on2271 = new Lino.DateField({ "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Accompagn\u00e9 le","Nur Klienten, die zu diesem Datum effektiv begleitet waren \n(d.h. die mindestens eine aktive Begleitung an diesem Datum haben)") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Accompagn\u00e9 le</span>", "anchor": "-20", "name": "coached_on" });
    var only_primary2272 = new Ext.form.Checkbox({ "boxLabel": "Dossiers primaires seulement", "listeners": { "render": Lino.quicktip_renderer("Dossiers primaires seulement","Nur Klienten, die eine effektive <b>prim\u00e4re</b> Begleitung haben.") }, "hideLabel": true, "checked": false, "name": "only_primary", "selectOnFocus": true, "anchor": "-20" });
    var nationality2273 = new Lino.TwinCombo({ "fieldLabel": "Nationalit\u00e9", "name": "nationality", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.countries.Countries.detail)}, "emptyText": "Choisir Pays...", "selectOnFocus": true, "hiddenName": "nationalityHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/pcsw/ClientsTest/nationality", "method": "GET" }) }) });
    var main_2_panel2274 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 13, "autoHeight": true, "layout": "form", "xtype": "panel", "items": client_state2268, "labelAlign": "top" }, { "flex": 18, "autoHeight": true, "layout": "form", "xtype": "panel", "items": coached_by2269, "labelAlign": "top" }, { "flex": 18, "autoHeight": true, "layout": "form", "xtype": "panel", "items": and_coached_by2270, "labelAlign": "top" }, { "flex": 10, "autoHeight": true, "layout": "form", "xtype": "panel", "items": coached_on2271, "labelAlign": "top" }, { "flex": 12, "autoHeight": true, "layout": "form", "xtype": "panel", "items": only_primary2272, "labelAlign": "top" }, { "flex": 25, "autoHeight": true, "layout": "form", "xtype": "panel", "items": nationality2273, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 261, "border": false, "anchor": "-20", "labelAlign": "top" });
    var invalid_niss2281 = new Ext.form.Checkbox({ "boxLabel": "Check NISS validity", "hideLabel": true, "checked": true, "name": "invalid_niss", "selectOnFocus": true, "anchor": "-20" });
    var overlapping_contracts2282 = new Ext.form.Checkbox({ "boxLabel": "Check for overlapping contracts", "hideLabel": true, "checked": true, "name": "overlapping_contracts", "selectOnFocus": true, "anchor": "-20" });
    var main_3_panel2283 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": invalid_niss2281, "labelAlign": "top" }, { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": overlapping_contracts2282, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 288, "border": false, "anchor": "-20", "labelAlign": "top" });
    this.items = [ main_1_panel2263, main_2_panel2274, main_3_panel2283 ];
    this.fields = [ aged_from2259, aged_to2260, gender2261, also_obsolete2262, client_state2268, coached_by2269, and_coached_by2270, coached_on2271, only_primary2272, nationality2273, invalid_niss2281, overlapping_contracts2282 ];
    Lino.pcsw.ClientsTest.ParamsPanel.superclass.initComponent.call(this);
  }
});


Lino.jobs.JobsOverviewByType.ParamsPanel = Ext.extend(Ext.form.FormPanel,{
  autoHeight: true,
  layout: "hbox",
  frame: true,
  layoutConfig: { "align": "stretchmax" },
  hideCheckBoxLabels: true,
  autoScroll: false,
  labelWidth: 243,
  border: false,
  bodyBorder: false,
  labelAlign: "top",
  initComponent : function() {
    var containing_panel = this;
    var contract_type3289 = new Lino.TwinCombo({ "fieldLabel": "Type de contrat de travail", "name": "contract_type", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.jobs.ContractTypes.detail)}, "emptyText": "Choisir Type de contrat de travail...", "selectOnFocus": true, "hiddenName": "contract_typeHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/jobs/JobsOverviewByType/contract_type", "method": "GET" }) }) });
    var date3290 = new Lino.DateField({ "selectOnFocus": true, "fieldLabel": "Date", "anchor": "-20", "name": "date" });
    this.items = [ { "flex": 71, "autoHeight": true, "layout": "form", "xtype": "panel", "items": contract_type3289, "labelAlign": "top" }, { "flex": 28, "autoHeight": true, "layout": "form", "xtype": "panel", "items": date3290, "labelAlign": "top" } ];
    this.fields = [ contract_type3289, date3290 ];
    Lino.jobs.JobsOverviewByType.ParamsPanel.superclass.initComponent.call(this);
  }
});


Lino.jobs.Contracts.ParamsPanel = Ext.extend(Ext.form.FormPanel,{
  autoHeight: true,
  layout: "hbox",
  frame: true,
  layoutConfig: { "align": "stretchmax" },
  hideCheckBoxLabels: true,
  autoScroll: false,
  labelWidth: 252,
  border: false,
  bodyBorder: false,
  labelAlign: "top",
  initComponent : function() {
    var containing_panel = this;
    var user1985 = new Lino.TwinCombo({ "fieldLabel": "Utilisateur", "name": "user", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.users.Users.detail)}, "emptyText": "Choisir Utilisateur...", "selectOnFocus": true, "hiddenName": "userHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/jobs/Contracts/user", "method": "GET" }) }) });
    var type1986 = new Lino.TwinCombo({ "fieldLabel": "Uniquement contrats de type", "name": "type", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.jobs.ContractTypes.detail)}, "emptyText": "Choisir Type de contrat de travail...", "selectOnFocus": true, "hiddenName": "typeHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/jobs/Contracts/type", "method": "GET" }) }) });
    var show_past1987 = new Ext.form.Checkbox({ "boxLabel": "contrats termin\u00e9s", "hideLabel": true, "checked": true, "name": "show_past", "selectOnFocus": true, "anchor": "-20" });
    var show_active1988 = new Ext.form.Checkbox({ "boxLabel": "contrats actifs", "hideLabel": true, "checked": true, "name": "show_active", "selectOnFocus": true, "anchor": "-20" });
    var show_coming1989 = new Ext.form.Checkbox({ "boxLabel": "contrats \u00e0 venir", "hideLabel": true, "checked": true, "name": "show_coming", "selectOnFocus": true, "anchor": "-20" });
    var today1990 = new Lino.DateField({ "selectOnFocus": true, "fieldLabel": "le", "anchor": "-20", "name": "today" });
    this.items = [ { "flex": 20, "autoHeight": true, "layout": "form", "xtype": "panel", "items": user1985, "labelAlign": "top" }, { "flex": 27, "autoHeight": true, "layout": "form", "xtype": "panel", "items": type1986, "labelAlign": "top" }, { "flex": 13, "autoHeight": true, "layout": "form", "xtype": "panel", "items": show_past1987, "labelAlign": "top" }, { "flex": 13, "autoHeight": true, "layout": "form", "xtype": "panel", "items": show_active1988, "labelAlign": "top" }, { "flex": 13, "autoHeight": true, "layout": "form", "xtype": "panel", "items": show_coming1989, "labelAlign": "top" }, { "flex": 10, "autoHeight": true, "layout": "form", "xtype": "panel", "items": today1990, "labelAlign": "top" } ];
    this.fields = [ user1985, type1986, show_past1987, show_active1988, show_coming1989, today1990 ];
    Lino.jobs.Contracts.ParamsPanel.superclass.initComponent.call(this);
  }
});


Lino.newcomers.AvailableCoaches.ParamsPanel = Ext.extend(Ext.form.FormPanel,{
  autoHeight: true,
  layout: "hbox",
  frame: true,
  layoutConfig: { "align": "stretchmax" },
  hideCheckBoxLabels: true,
  autoScroll: false,
  labelWidth: 261,
  border: false,
  bodyBorder: false,
  labelAlign: "top",
  initComponent : function() {
    var containing_panel = this;
    var for_client1723 = new Lino.TwinCombo({ "fieldLabel": "Montrer agents propos\u00e9s pour", "name": "for_client", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.pcsw.Clients.detail)}, "emptyText": "Choisir Client...", "selectOnFocus": true, "hiddenName": "for_clientHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/newcomers/AvailableCoaches/for_client", "method": "GET" }) }) });
    var since1724 = new Lino.DateField({ "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("New clients since","New clients are those whose coaching started after this date") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">New clients since</span>", "anchor": "-20", "name": "since" });
    this.items = [ { "flex": 71, "autoHeight": true, "layout": "form", "xtype": "panel", "items": for_client1723, "labelAlign": "top" }, { "flex": 28, "autoHeight": true, "layout": "form", "xtype": "panel", "items": since1724, "labelAlign": "top" } ];
    this.fields = [ for_client1723, since1724 ];
    Lino.newcomers.AvailableCoaches.ParamsPanel.superclass.initComponent.call(this);
  }
});


Lino.pcsw.Clients.wf2_ActionFormPanel = Ext.extend(Lino.ActionFormPanel,{
  autoScroll: false,
  border: false,
  layout: "vbox",
  labelWidth: 90,
  hideCheckBoxLabels: true,
  frame: true,
  layoutConfig: { "align": "stretch" },
  bodyBorder: false,
  labelAlign: "top",
  action_name: 'wf2',
  window_title: "Refuser",
  initComponent : function() {
    var containing_panel = this;
    var reason13 = new Lino.ChoicesFieldElement({ "forceSelection": true, "fieldLabel": "reason", "allowBlank": false, "hiddenName": "reasonHidden", "selectOnFocus": true, "anchor": "-20", "store": Lino.pcsw.RefusalReasons, "name": "reason" });
    var remark14 = new Ext.form.TextArea({ "selectOnFocus": true, "fieldLabel": "Remarque", "anchor": "-20 -10", "growMax": 2000, "name": "remark" });
    this.items = [ { "items": reason13, "autoHeight": true, "layout": "form", "xtype": "panel", "labelAlign": "top" }, { "items": remark14, "labelAlign": "top", "layout": "form", "xtype": "panel", "flex": 83 } ];
    this.fields = [ reason13, remark14 ];
    Lino.pcsw.Clients.wf2_ActionFormPanel.superclass.initComponent.call(this);
  }
});


Lino.newcomers.AvailableCoachesByClient.assign_coach_ActionFormPanel = Ext.extend(Lino.ActionFormPanel,{
  autoScroll: false,
  border: false,
  layout: "vbox",
  labelWidth: 387,
  hideCheckBoxLabels: true,
  frame: true,
  layoutConfig: { "align": "stretch" },
  bodyBorder: false,
  labelAlign: "top",
  action_name: 'assign_coach',
  window_title: "Attribuer",
  initComponent : function() {
    var containing_panel = this;
    var notify_subject31 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200, "fieldLabel": "R\u00e9sum\u00e9", "anchor": "-20", "name": "notify_subject" });
    var notify_body32 = new Ext.form.TextArea({ "selectOnFocus": true, "fieldLabel": "Description", "anchor": "-20 -10", "growMax": 2000, "name": "notify_body" });
    var notify_silent33 = new Ext.form.Checkbox({ "boxLabel": "Don't send email notification", "hideLabel": true, "checked": false, "name": "notify_silent", "selectOnFocus": true, "anchor": "-20" });
    this.items = [ { "items": notify_subject31, "autoHeight": true, "layout": "form", "xtype": "panel", "labelAlign": "top" }, { "items": notify_body32, "labelAlign": "top", "layout": "form", "xtype": "panel", "flex": 71 }, { "items": notify_silent33, "autoHeight": true, "layout": "form", "xtype": "panel", "labelAlign": "top" } ];
    this.fields = [ notify_subject31, notify_body32, notify_silent33 ];
    Lino.newcomers.AvailableCoachesByClient.assign_coach_ActionFormPanel.superclass.initComponent.call(this);
  }
});


Lino.cal.Guests.wf2_ActionFormPanel = Ext.extend(Lino.ActionFormPanel,{
  autoScroll: false,
  border: false,
  layout: "vbox",
  labelWidth: 387,
  hideCheckBoxLabels: true,
  frame: true,
  layoutConfig: { "align": "stretch" },
  bodyBorder: false,
  labelAlign: "top",
  action_name: 'wf2',
  window_title: "Rejeter",
  initComponent : function() {
    var containing_panel = this;
    var notify_subject6 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200, "fieldLabel": "R\u00e9sum\u00e9", "anchor": "-20", "name": "notify_subject" });
    var notify_body7 = new Ext.form.TextArea({ "selectOnFocus": true, "fieldLabel": "Description", "anchor": "-20 -10", "growMax": 2000, "name": "notify_body" });
    var notify_silent8 = new Ext.form.Checkbox({ "boxLabel": "Don't send email notification", "hideLabel": true, "checked": false, "name": "notify_silent", "selectOnFocus": true, "anchor": "-20" });
    this.items = [ { "items": notify_subject6, "autoHeight": true, "layout": "form", "xtype": "panel", "labelAlign": "top" }, { "items": notify_body7, "labelAlign": "top", "layout": "form", "xtype": "panel", "flex": 71 }, { "items": notify_silent8, "autoHeight": true, "layout": "form", "xtype": "panel", "labelAlign": "top" } ];
    this.fields = [ notify_subject6, notify_body7, notify_silent8 ];
    Lino.cal.Guests.wf2_ActionFormPanel.superclass.initComponent.call(this);
  }
});


Lino.pcsw.Clients.merge_row_ActionFormPanel = Ext.extend(Lino.ActionFormPanel,{
  autoScroll: false,
  autoHeight: true,
  border: false,
  layout: "form",
  labelWidth: 99,
  hideCheckBoxLabels: true,
  frame: true,
  bodyBorder: false,
  labelAlign: "top",
  action_name: 'merge_row',
  window_title: "Merge",
  autoHeight: true,
  initComponent : function() {
    var containing_panel = this;
    var merge_to18 = new Lino.TwinCombo({ "fieldLabel": "nach...", "allowBlank": false, "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.pcsw.Clients.detail)}, "emptyText": "Choisir Client...", "selectOnFocus": true, "hiddenName": "merge_toHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/apchoices/pcsw/Clients/merge_row/merge_to", "method": "GET" }) }), "name": "merge_to" });
    var pcsw_Coaching19 = new Ext.form.Checkbox({ "boxLabel": "Accompagnements", "hideLabel": true, "checked": false, "name": "pcsw_Coaching", "selectOnFocus": true, "anchor": "-20" });
    var cv_LanguageKnowledge20 = new Ext.form.Checkbox({ "boxLabel": "Connaissances de langue", "hideLabel": true, "checked": false, "name": "cv_LanguageKnowledge", "selectOnFocus": true, "anchor": "-20" });
    var keep_volatiles_1_panel21 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": pcsw_Coaching19, "labelAlign": "top" }, { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": cv_LanguageKnowledge20, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 153, "border": false, "anchor": "-20", "labelAlign": "top" });
    var properties_PersonProperty24 = new Ext.form.Checkbox({ "boxLabel": "Propri\u00e9t\u00e9s", "hideLabel": true, "checked": false, "name": "properties_PersonProperty", "selectOnFocus": true, "anchor": "-20" });
    var keep_volatiles_panel25 = new Ext.form.FieldSet({ "autoHeight": true, "layout": "form", "title": "Auch verg\u00e4ngliche verkn\u00fcpfte Objekte \u00fcberweisen", "items": [ keep_volatiles_1_panel21, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": properties_PersonProperty24, "anchor": "-20", "labelAlign": "top" } ], "frame": true, "bodyBorder": false, "autoScroll": false, "hideCheckBoxLabels": true, "labelWidth": 126, "border": false, "anchor": "-20", "labelAlign": "top" });
    var reason27 = new Ext.form.TextField({ "fieldLabel": "Begr\u00fcndung", "name": "reason", "maxLength": 100, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    this.items = [ { "autoHeight": true, "layout": "form", "xtype": "panel", "items": merge_to18, "anchor": "-20", "labelAlign": "top" }, keep_volatiles_panel25, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": reason27, "anchor": "-20", "labelAlign": "top" } ];
    this.fields = [ merge_to18, pcsw_Coaching19, cv_LanguageKnowledge20, properties_PersonProperty24, reason27 ];
    Lino.pcsw.Clients.merge_row_ActionFormPanel.superclass.initComponent.call(this);
  }
});


Lino.contacts.Companies.merge_row_ActionFormPanel = Ext.extend(Lino.ActionFormPanel,{
  autoScroll: false,
  autoHeight: true,
  border: false,
  layout: "form",
  labelWidth: 99,
  hideCheckBoxLabels: true,
  frame: true,
  bodyBorder: false,
  labelAlign: "top",
  action_name: 'merge_row',
  window_title: "Merge",
  autoHeight: true,
  initComponent : function() {
    var containing_panel = this;
    var merge_to1 = new Lino.TwinCombo({ "fieldLabel": "nach...", "allowBlank": false, "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.contacts.Companies.detail)}, "emptyText": "Choisir Organisation...", "selectOnFocus": true, "hiddenName": "merge_toHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/apchoices/contacts/Companies/merge_row/merge_to", "method": "GET" }) }), "name": "merge_to" });
    var reason2 = new Ext.form.TextField({ "fieldLabel": "Begr\u00fcndung", "name": "reason", "maxLength": 100, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    this.items = [ { "autoHeight": true, "layout": "form", "xtype": "panel", "items": merge_to1, "anchor": "-20", "labelAlign": "top" }, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": reason2, "anchor": "-20", "labelAlign": "top" } ];
    this.fields = [ merge_to1, reason2 ];
    Lino.contacts.Companies.merge_row_ActionFormPanel.superclass.initComponent.call(this);
  }
});


Lino.changes.Changes.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 10,
  disable_editing: true,
  initComponent : function() {
    var containing_panel = this;
    var time336 = new Ext.form.DisplayField({ "fieldLabel": "time", "name": "time", "selectOnFocus": true, "anchor": "-20", "value": "<br>", "allowBlank": false });
    var user337 = new Lino.TwinCombo({ "fieldLabel": "Utilisateur", "allowBlank": false, "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.users.Users.detail)}, "emptyText": "Choisir Utilisateur...", "selectOnFocus": true, "hiddenName": "userHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/changes/Changes/user", "method": "GET" }) }), "name": "user" });
    var type338 = new Lino.ChoicesFieldElement({ "forceSelection": true, "fieldLabel": "Change Type", "allowBlank": false, "hiddenName": "typeHidden", "selectOnFocus": true, "anchor": "-20", "store": Lino.lino.ChangeTypes, "name": "type" });
    var master_disp339 = new Ext.form.DisplayField({ "disabled": true, "fieldLabel": "Signal\u00e9tique", "anchor": "-20", "name": "master" });
    var object_disp340 = new Ext.form.DisplayField({ "disabled": true, "fieldLabel": "Object", "anchor": "-20", "name": "object" });
    var id341 = new Ext.form.NumberField({ "selectOnFocus": true, "fieldLabel": "ID", "anchor": "-20", "name": "id" });
    var main_1_panel342 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 117, "hideCheckBoxLabels": true, "items": [ { "flex": 22, "autoHeight": true, "layout": "form", "xtype": "panel", "items": time336, "labelAlign": "top" }, { "flex": 21, "autoHeight": true, "layout": "form", "xtype": "panel", "items": user337, "labelAlign": "top" }, { "flex": 21, "autoHeight": true, "layout": "form", "xtype": "panel", "items": type338, "labelAlign": "top" }, { "flex": 14, "autoHeight": true, "layout": "form", "xtype": "panel", "items": master_disp339, "labelAlign": "top" }, { "flex": 14, "autoHeight": true, "layout": "form", "xtype": "panel", "items": object_disp340, "labelAlign": "top" }, { "flex": 7, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id341, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var diff349 = new Ext.form.TextArea({ "selectOnFocus": true, "fieldLabel": "Changes", "anchor": "-20 -10", "growMax": 2000, "name": "diff" });
    var main_panel350 = new Ext.Panel({ "autoScroll": false, "border": false, "layout": "vbox", "labelWidth": 72, "hideCheckBoxLabels": true, "items": [ main_1_panel342, { "items": diff349, "labelAlign": "top", "layout": "form", "xtype": "panel", "flex": 83 } ], "frame": true, "layoutConfig": { "align": "stretch" }, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel350;
    this.before_row_edit = function(record) {
    }
    Lino.changes.Changes.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.pcsw.Clients.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 50,
  initComponent : function() {
    var containing_panel = this;
    var last_name1555 = new Ext.form.TextField({ "fieldLabel": "Nom de famille", "name": "last_name", "maxLength": 200, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var first_name1556 = new Ext.form.TextField({ "fieldLabel": "Pr\u00e9nom", "name": "first_name", "maxLength": 200, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var title1557 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200, "fieldLabel": "Allocution", "anchor": "-20", "name": "title" });
    var box1_1_panel1558 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 45, "autoHeight": true, "layout": "form", "xtype": "panel", "items": last_name1555, "labelAlign": "top" }, { "flex": 32, "autoHeight": true, "layout": "form", "xtype": "panel", "items": first_name1556, "labelAlign": "top" }, { "flex": 21, "autoHeight": true, "layout": "form", "xtype": "panel", "items": title1557, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 135, "border": false, "anchor": "-20", "labelAlign": "top" });
    var country1562 = new Lino.TwinCombo({ "fieldLabel": "Pays", "name": "country", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.countries.Countries.detail)}, "emptyText": "Choisir Pays...", "selectOnFocus": true, "hiddenName": "countryHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/pcsw/Clients/country", "method": "GET" }) }) });
    var city1563 = new Lino.TwinCombo({ "forceSelection": false, "fieldLabel": "Place", "name": "city", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.countries.Cities.detail)}, "emptyText": "Choisir Place...", "selectOnFocus": true, "hiddenName": "cityHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/pcsw/Clients/city", "method": "GET" }) }) });
    var zip_code1564 = new Ext.form.TextField({ "fieldLabel": "Zip code", "name": "zip_code", "maxLength": 10, "selectOnFocus": true, "boxMinWidth": Lino.chars2width(10), "anchor": "-20" });
    var box1_2_panel1565 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 40, "autoHeight": true, "layout": "form", "xtype": "panel", "items": country1562, "labelAlign": "top" }, { "flex": 40, "autoHeight": true, "layout": "form", "xtype": "panel", "items": city1563, "labelAlign": "top" }, { "flex": 20, "autoHeight": true, "layout": "form", "xtype": "panel", "items": zip_code1564, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 81, "border": false, "anchor": "-20", "labelAlign": "top" });
    var street_prefix1569 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Pr\u00e9fixe rue","Text to print before name of street, but to ignore for sorting.") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Pr\u00e9fixe rue</span>", "name": "street_prefix", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var street1570 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Rue","Name of street. Without house number.") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Rue</span>", "name": "street", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var street_no1571 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("N\u00b0","House number") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">N\u00b0</span>", "name": "street_no", "maxLength": 10, "selectOnFocus": true, "boxMinWidth": Lino.chars2width(10), "anchor": "-20" });
    var street_box1572 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("bo\u00eete","Text to print after :attr:`steet_no` on the same line") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">bo\u00eete</span>", "name": "street_box", "maxLength": 10, "selectOnFocus": true, "boxMinWidth": Lino.chars2width(10), "anchor": "-20" });
    var box1_3_panel1573 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 30, "autoHeight": true, "layout": "form", "xtype": "panel", "items": street_prefix1569, "labelAlign": "top" }, { "flex": 36, "autoHeight": true, "layout": "form", "xtype": "panel", "items": street1570, "labelAlign": "top" }, { "flex": 16, "autoHeight": true, "layout": "form", "xtype": "panel", "items": street_no1571, "labelAlign": "top" }, { "flex": 16, "autoHeight": true, "layout": "form", "xtype": "panel", "items": street_box1572, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 108, "border": false, "anchor": "-20", "labelAlign": "top" });
    var addr21578 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Ligne apr\u00e8s le nom de rue","Address line to print below street line") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Ligne apr\u00e8s le nom de rue</span>", "name": "addr2", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var box1_panel1579 = new Ext.form.FieldSet({ "flex": 61, "autoHeight": true, "layout": "form", "title": "Addresse", "items": [ box1_1_panel1558, box1_2_panel1565, box1_3_panel1573, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": addr21578, "anchor": "-20", "labelAlign": "top" } ], "frame": true, "bodyBorder": false, "autoScroll": false, "hideCheckBoxLabels": true, "labelWidth": 234, "border": false, "labelAlign": "top" });
    var id1581 = new Ext.form.NumberField({ "selectOnFocus": true, "fieldLabel": "ID", "anchor": "-20", "name": "id" });
    var language1582 = new Lino.ChoicesFieldElement({ "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Langue</span>", "allowBlank": false, "value": "de", "hiddenName": "languageHidden", "listeners": { "render": Lino.quicktip_renderer("Langue","Die Sprache, in der Dokumente ausgestellt werden sollen.") }, "selectOnFocus": true, "anchor": "-20", "store": [ [ "de", "German" ], [ "fr", "French" ], [ "nl", "Dutch" ] ], "name": "language" });
    var box2_1_panel1583 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 37, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id1581, "labelAlign": "top" }, { "flex": 62, "autoHeight": true, "layout": "form", "xtype": "panel", "items": language1582, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 63, "border": false, "anchor": "-20", "labelAlign": "top" });
    var email1586 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 75, "fieldLabel": "E-mail", "anchor": "-20", "name": "email" });
    var phone1587 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200, "fieldLabel": "T\u00e9l\u00e9phone", "anchor": "-20", "name": "phone" });
    var fax1588 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200, "fieldLabel": "Fax", "anchor": "-20", "name": "fax" });
    var box2_3_panel1589 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": phone1587, "labelAlign": "top" }, { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": fax1588, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 90, "border": false, "anchor": "-20", "labelAlign": "top" });
    var gsm1592 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200, "fieldLabel": "GSM", "anchor": "-20", "name": "gsm" });
    var box2_panel1593 = new Ext.form.FieldSet({ "flex": 38, "autoHeight": true, "layout": "form", "title": "Contact", "items": [ box2_1_panel1583, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": email1586, "anchor": "-20", "labelAlign": "top" }, box2_3_panel1589, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": gsm1592, "anchor": "-20", "labelAlign": "top" } ], "frame": true, "bodyBorder": false, "autoScroll": false, "hideCheckBoxLabels": true, "labelWidth": 63, "border": false, "labelAlign": "top" });
    var general_1_panel1596 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "hideCheckBoxLabels": true, "items": [ box1_panel1579, box2_panel1593 ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "anchor": "-20", "labelAlign": "top" });
    var gender1597 = new Lino.ChoicesFieldElement({ "forceSelection": true, "fieldLabel": "Sexe", "name": "gender", "selectOnFocus": true, "anchor": "-20", "store": Lino.lino.Genders, "hiddenName": "genderHidden" });
    var birth_date1598 = new Lino.IncompleteDateField({ "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("date de naissance","Uncomplete dates are allowed, e.g. \n\"00.00.1980\" means \"some day in 1980\", \n\"00.07.1980\" means \"in July 1980\"\nor \"23.07.0000\" means \"on a 23th of July\".") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">date de naissance</span>", "anchor": "-20", "name": "birth_date" });
    var age_disp1599 = new Ext.form.DisplayField({ "disabled": true, "fieldLabel": "\u00e2ge", "name": "age", "anchor": "-20", "value": "<br/>", "always_enabled": true });
    var civil_state1600 = new Lino.ChoicesFieldElement({ "forceSelection": true, "fieldLabel": "Etat civil", "name": "civil_state", "selectOnFocus": true, "anchor": "-20", "store": Lino.pcsw.CivilState, "hiddenName": "civil_stateHidden" });
    var noble_condition1601 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Titre de noblesse","The eventual noble condition of this person. Imported from TIM.") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Titre de noblesse</span>", "name": "noble_condition", "maxLength": 50, "selectOnFocus": true, "anchor": "-20" });
    var box3_1_panel1602 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 14, "autoHeight": true, "layout": "form", "xtype": "panel", "items": gender1597, "labelAlign": "top" }, { "flex": 17, "autoHeight": true, "layout": "form", "xtype": "panel", "items": birth_date1598, "labelAlign": "top" }, { "flex": 14, "autoHeight": true, "layout": "form", "xtype": "panel", "items": age_disp1599, "labelAlign": "top" }, { "flex": 22, "autoHeight": true, "layout": "form", "xtype": "panel", "items": civil_state1600, "labelAlign": "top" }, { "flex": 30, "autoHeight": true, "layout": "form", "xtype": "panel", "items": noble_condition1601, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 162, "border": false, "anchor": "-20", "labelAlign": "top" });
    var birth_country1608 = new Lino.TwinCombo({ "fieldLabel": "Pays de naissance", "name": "birth_country", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.countries.Countries.detail)}, "emptyText": "Choisir Pays...", "selectOnFocus": true, "hiddenName": "birth_countryHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/pcsw/Clients/birth_country", "method": "GET" }) }) });
    var birth_place1609 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200, "fieldLabel": "Lieu de naissance", "anchor": "-20", "name": "birth_place" });
    var nationality1610 = new Lino.TwinCombo({ "fieldLabel": "Nationalit\u00e9", "name": "nationality", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.countries.Countries.detail)}, "emptyText": "Choisir Pays...", "selectOnFocus": true, "hiddenName": "nationalityHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/pcsw/Clients/nationality", "method": "GET" }) }) });
    var national_id1611 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200, "fieldLabel": "NISS", "anchor": "-20", "name": "national_id" });
    var box3_2_panel1612 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 28, "autoHeight": true, "layout": "form", "xtype": "panel", "items": birth_country1608, "labelAlign": "top" }, { "flex": 29, "autoHeight": true, "layout": "form", "xtype": "panel", "items": birth_place1609, "labelAlign": "top" }, { "flex": 21, "autoHeight": true, "layout": "form", "xtype": "panel", "items": nationality1610, "labelAlign": "top" }, { "flex": 21, "autoHeight": true, "layout": "form", "xtype": "panel", "items": national_id1611, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 162, "border": false, "anchor": "-20", "labelAlign": "top" });
    var box3_panel1617 = new Ext.form.FieldSet({ "autoHeight": true, "layout": "form", "title": "Naissance", "items": [ box3_1_panel1602, box3_2_panel1612 ], "frame": true, "bodyBorder": false, "autoScroll": false, "hideCheckBoxLabels": true, "border": false, "anchor": "-20", "labelAlign": "top" });
    var card_number1618 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 20, "fieldLabel": "n\u00b0", "anchor": "-20", "name": "card_number" });
    var card_valid_from1619 = new Lino.DateField({ "selectOnFocus": true, "fieldLabel": "valide de", "anchor": "-20", "name": "card_valid_from" });
    var card_valid_until1620 = new Lino.DateField({ "selectOnFocus": true, "fieldLabel": "expire le", "anchor": "-20", "name": "card_valid_until" });
    var card_issuer1621 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 50, "fieldLabel": "\u00e9mise par", "anchor": "-20", "name": "card_issuer" });
    var card_type1622 = new Lino.ChoicesFieldElement({ "forceSelection": true, "fieldLabel": "Type de carte eID", "name": "card_type", "selectOnFocus": true, "anchor": "-20", "store": Lino.pcsw.BeIdCardTypes, "hiddenName": "card_typeHidden" });
    var eid_panel_1_panel1623 = new Ext.form.FieldSet({ "autoHeight": true, "layout": "hbox", "title": "Carte eID", "bodyBorder": true, "frame": false, "layoutConfig": { "align": "stretchmax" }, "autoScroll": false, "items": [ { "flex": 20, "autoHeight": true, "layout": "form", "xtype": "panel", "items": card_number1618, "labelAlign": "top" }, { "flex": 20, "autoHeight": true, "layout": "form", "xtype": "panel", "items": card_valid_from1619, "labelAlign": "top" }, { "flex": 20, "autoHeight": true, "layout": "form", "xtype": "panel", "items": card_valid_until1620, "labelAlign": "top" }, { "flex": 17, "autoHeight": true, "layout": "form", "xtype": "panel", "items": card_issuer1621, "labelAlign": "top" }, { "flex": 20, "autoHeight": true, "layout": "form", "xtype": "panel", "items": card_type1622, "labelAlign": "top" } ], "hideCheckBoxLabels": true, "labelWidth": 225, "border": false, "anchor": "-20", "labelAlign": "top" });
    var created1629 = new Ext.form.DisplayField({ "disabled": true, "fieldLabel": "Cr\u00e9\u00e9", "anchor": "-20", "value": "<br>", "name": "created" });
    var modified1630 = new Ext.form.DisplayField({ "disabled": true, "fieldLabel": "Modified", "anchor": "-20", "value": "<br>", "name": "modified" });
    var box4_3_panel1631 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": created1629, "labelAlign": "top" }, { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": modified1630, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 81, "border": false, "anchor": "-20", "labelAlign": "top" });
    var box4_panel1634 = new Ext.Panel({ "flex": 82, "autoHeight": true, "border": false, "layout": "form", "hideCheckBoxLabels": true, "items": [ box3_panel1617, eid_panel_1_panel1623, box4_3_panel1631 ], "frame": true, "autoScroll": false, "bodyBorder": false, "labelAlign": "top" });
    var image_htmlbox1635 = new Lino.HtmlBoxPanel({ "flex": 17, "layout": "fit", "name": "image", "containing_panel": this, "items": new Ext.BoxComponent({autoScroll:true}), "master_panel": this, "value": "<br/>", "always_enabled": true, "bodyStyle": "overflow-x:hidden" });
    var general_2_panel1636 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ box4_panel1634, image_htmlbox1635 ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 0, "border": false, "anchor": "-20", "labelAlign": "top" });
    var general_panel1637 = new Ext.Panel({ "autoHeight": true, "layout": "form", "title": "Personne", "items": [ general_1_panel1596, general_2_panel1636 ], "frame": true, "bodyBorder": false, "hideCheckBoxLabels": true, "listeners": { "activate": Lino.on_tab_activate }, "autoScroll": false, "border": false, "labelAlign": "top" });
    var in_belgium_since1638 = new Lino.DateField({ "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("en Belgique depuis","Since when this person in Belgium lives.\n<b>Important:</b> help_text can be formatted.") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">en Belgique depuis</span>", "anchor": "-20", "name": "in_belgium_since" });
    var residence_type1639 = new Lino.ChoicesFieldElement({ "forceSelection": true, "fieldLabel": "Type de s\u00e9jour", "name": "residence_type", "selectOnFocus": true, "anchor": "-20", "store": Lino.pcsw.ResidenceType, "hiddenName": "residence_typeHidden" });
    var gesdos_id1640 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 40, "fieldLabel": "N\u00b0 GesDos", "anchor": "-20", "name": "gesdos_id" });
    var status_1_panel1641 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 24, "autoHeight": true, "layout": "form", "xtype": "panel", "items": in_belgium_since1638, "labelAlign": "top" }, { "flex": 40, "autoHeight": true, "layout": "form", "xtype": "panel", "items": residence_type1639, "labelAlign": "top" }, { "flex": 34, "autoHeight": true, "layout": "form", "xtype": "panel", "items": gesdos_id1640, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 171, "border": false, "anchor": "-20", "labelAlign": "top" });
    var bank_account11645 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 40, "fieldLabel": "Compte en banque 1", "anchor": "-20", "name": "bank_account1" });
    var bank_account21646 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 40, "fieldLabel": "Compte en banque 2", "anchor": "-20", "name": "bank_account2" });
    var status_2_panel1647 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": bank_account11645, "labelAlign": "top" }, { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": bank_account21646, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 171, "border": false, "anchor": "-20", "labelAlign": "top" });
    var job_agents1650 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 100, "fieldLabel": "Agences de travail", "anchor": "-20", "name": "job_agents" });
    var group1651 = new Lino.RemoteComboFieldElement({ "fieldLabel": "Phase d'int\u00e9gration", "name": "group", "pageSize": 20, "emptyText": "Choisir Phase d'int\u00e9gration...", "selectOnFocus": true, "hiddenName": "groupHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/pcsw/Clients/group", "method": "GET" }) }) });
    var status_3_panel1652 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 56, "autoHeight": true, "layout": "form", "xtype": "panel", "items": job_agents1650, "labelAlign": "top" }, { "flex": 43, "autoHeight": true, "layout": "form", "xtype": "panel", "items": group1651, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 180, "border": false, "anchor": "-20", "labelAlign": "top" });
    var status_panel1655 = new Ext.Panel({ "flex": 68, "autoHeight": true, "border": false, "layout": "form", "hideCheckBoxLabels": true, "items": [ status_1_panel1641, status_2_panel1647, status_3_panel1652 ], "frame": true, "autoScroll": false, "bodyBorder": false, "labelAlign": "top" });
    var aid_type1656 = new Lino.RemoteComboFieldElement({ "fieldLabel": "Type d'aide sociale", "name": "aid_type", "pageSize": 20, "emptyText": "Choisir Type d'aide sociale...", "selectOnFocus": true, "hiddenName": "aid_typeHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/pcsw/Clients/aid_type", "method": "GET" }) }) });
    var income_ag1657 = new Ext.form.Checkbox({ "boxLabel": "allocation de ch\u00f4mage", "hideLabel": true, "checked": false, "name": "income_ag", "selectOnFocus": true, "anchor": "-20" });
    var income_wg1658 = new Ext.form.Checkbox({ "boxLabel": "waiting pay", "hideLabel": true, "checked": false, "name": "income_wg", "selectOnFocus": true, "anchor": "-20" });
    var income_2_panel1659 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": income_ag1657, "labelAlign": "top" }, { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": income_wg1658, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 198, "border": false, "anchor": "-20", "labelAlign": "top" });
    var income_kg1662 = new Ext.form.Checkbox({ "boxLabel": "indemnisation maladie", "hideLabel": true, "checked": false, "name": "income_kg", "selectOnFocus": true, "anchor": "-20" });
    var income_rente1663 = new Ext.form.Checkbox({ "boxLabel": "persone de retraite", "hideLabel": true, "checked": false, "name": "income_rente", "selectOnFocus": true, "anchor": "-20" });
    var income_3_panel1664 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": income_kg1662, "labelAlign": "top" }, { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": income_rente1663, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 198, "border": false, "anchor": "-20", "labelAlign": "top" });
    var income_misc1667 = new Ext.form.Checkbox({ "boxLabel": "autres revenus", "hideLabel": true, "checked": false, "name": "income_misc", "selectOnFocus": true, "anchor": "-20" });
    var income_panel1668 = new Ext.Panel({ "flex": 31, "autoHeight": true, "layout": "form", "items": [ { "autoHeight": true, "layout": "form", "xtype": "panel", "items": aid_type1656, "anchor": "-20", "labelAlign": "top" }, income_2_panel1659, income_3_panel1664, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": income_misc1667, "anchor": "-20", "labelAlign": "top" } ], "frame": true, "bodyBorder": false, "autoScroll": false, "hideCheckBoxLabels": true, "labelWidth": 180, "border": false, "labelAlign": "top" });
    var status_tab_1_panel1671 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "hideCheckBoxLabels": true, "items": [ status_panel1655, income_panel1668 ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var is_seeking1672 = new Ext.form.Checkbox({ "boxLabel": "cherche du travail", "hideLabel": true, "checked": false, "name": "is_seeking", "selectOnFocus": true, "anchor": "-20" });
    var unemployed_since1673 = new Lino.DateField({ "selectOnFocus": true, "fieldLabel": "Cherche du travail depuis", "anchor": "-20", "name": "unemployed_since" });
    var work_permit_suspended_until1674 = new Lino.DateField({ "selectOnFocus": true, "fieldLabel": "suspendu jusque", "anchor": "-20", "name": "work_permit_suspended_until" });
    var suche_1_panel1675 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 234, "hideCheckBoxLabels": true, "items": [ { "flex": 38, "autoHeight": true, "layout": "form", "xtype": "panel", "items": is_seeking1672, "labelAlign": "top" }, { "flex": 30, "autoHeight": true, "layout": "form", "xtype": "panel", "items": unemployed_since1673, "labelAlign": "top" }, { "flex": 30, "autoHeight": true, "layout": "form", "xtype": "panel", "items": work_permit_suspended_until1674, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var unavailable_until1679 = new Lino.DateField({ "selectOnFocus": true, "fieldLabel": "Indidponible jusque", "anchor": "-20", "name": "unavailable_until" });
    var unavailable_why1680 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 100, "fieldLabel": "raison", "anchor": "-20", "name": "unavailable_why" });
    var suche_2_panel1681 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 180, "hideCheckBoxLabels": true, "items": [ { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": unavailable_until1679, "labelAlign": "top" }, { "flex": 66, "autoHeight": true, "layout": "form", "xtype": "panel", "items": unavailable_why1680, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var pcsw_ExclusionsByPerson_grid1689 = new Lino.pcsw.ExclusionsByPerson.GridPanel({ "tools": [ Lino.show_in_own_window_button(Lino.pcsw.ExclusionsByPerson.grid) ], "containing_panel": this, "hide_top_toolbar": true, "master_panel": this, "flex": 71 });
    var suche_panel1690 = new Ext.form.FieldSet({ "flex": 50, "layout": "vbox", "title": "Recherche de travail", "layoutConfig": { "align": "stretch" }, "frame": true, "bodyBorder": false, "autoScroll": false, "items": [ suche_1_panel1675, suche_2_panel1681, pcsw_ExclusionsByPerson_grid1689 ], "hideCheckBoxLabels": true, "border": false, "labelAlign": "top" });
    var needs_residence_permit1691 = new Ext.form.Checkbox({ "boxLabel": "A besoin d'un permis de s\u00e9jour", "hideLabel": true, "checked": false, "name": "needs_residence_permit", "selectOnFocus": true, "anchor": "-20" });
    var needs_work_permit1692 = new Ext.form.Checkbox({ "boxLabel": "A besoin d'un permis de travail", "hideLabel": true, "checked": false, "name": "needs_work_permit", "selectOnFocus": true, "anchor": "-20" });
    var papers_1_panel1693 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 288, "hideCheckBoxLabels": true, "items": [ { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": needs_residence_permit1691, "labelAlign": "top" }, { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": needs_work_permit1692, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var residence_permit_disp1696 = new Ext.form.DisplayField({ "disabled": true, "fieldLabel": "Permis de s\u00e9jour", "name": "residence_permit", "anchor": "-20", "value": "<br/>", "always_enabled": true });
    var work_permit_disp1697 = new Ext.form.DisplayField({ "disabled": true, "fieldLabel": "Permis de travail", "name": "work_permit", "anchor": "-20", "value": "<br/>", "always_enabled": true });
    var driving_licence_disp1698 = new Ext.form.DisplayField({ "disabled": true, "fieldLabel": "permis de conduire", "name": "driving_licence", "anchor": "-20", "value": "<br/>", "always_enabled": true });
    var papers_2_panel1699 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 171, "hideCheckBoxLabels": true, "items": [ { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": residence_permit_disp1696, "labelAlign": "top" }, { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": work_permit_disp1697, "labelAlign": "top" }, { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": driving_licence_disp1698, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var UploadsByController_htmlbox1703 = new Lino.HtmlBoxPanel({ "flex": 42, "ls_bbar_actions": [ { "itemId": "insert", "menu_item_text": "Nouveau", "must_save": true, "tooltip": "Insert a new record", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-new", "overflowText": "Nouveau", "auto_save": true } ], "name": "UploadsByController", "containing_panel": this, "items": new Ext.BoxComponent({autoScroll:true}), "title": "Uploads", "master_panel": this, "value": "<br/>", "always_enabled": true, "bodyStyle": "overflow-x:hidden", "ls_insert_handler": Lino.uploads.UploadsByController.insert, "layout": "fit", "tools": [ Lino.show_in_own_window_button(Lino.uploads.UploadsByController.grid) ] });
    var papers_panel1704 = new Ext.form.FieldSet({ "flex": 50, "layout": "vbox", "title": "Papiers", "layoutConfig": { "align": "stretch" }, "frame": true, "bodyBorder": false, "autoScroll": false, "items": [ papers_1_panel1693, papers_2_panel1699, UploadsByController_htmlbox1703 ], "hideCheckBoxLabels": true, "labelWidth": 72, "border": false, "labelAlign": "top" });
    var status_tab_2_panel1705 = new Ext.Panel({ "flex": 63, "border": false, "layout": "hbox", "hideCheckBoxLabels": true, "items": [ suche_panel1690, papers_panel1704 ], "autoScroll": false, "layoutConfig": { "align": "stretch" }, "frame": false, "labelAlign": "top" });
    var status_tab_panel1706 = new Ext.Panel({ "layout": "vbox", "title": "Statut", "items": [ status_tab_1_panel1671, status_tab_2_panel1705 ], "frame": true, "layoutConfig": { "align": "stretch" }, "hideCheckBoxLabels": true, "listeners": { "activate": Lino.on_tab_activate }, "autoScroll": false, "border": false, "bodyBorder": false, "labelAlign": "top" });
    var workflow_buttons_disp1707 = new Ext.form.DisplayField({ "disabled": true, "fieldLabel": "Workflow", "name": "workflow_buttons", "anchor": "-20", "value": "<br/>", "always_enabled": true });
    var broker1708 = new Lino.RemoteComboFieldElement({ "fieldLabel": "Interm\u00e9diaire ", "name": "broker", "pageSize": 20, "emptyText": "Choisir Interm\u00e9diaire ...", "selectOnFocus": true, "hiddenName": "brokerHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/pcsw/Clients/broker", "method": "GET" }) }) });
    var faculty1709 = new Lino.TwinCombo({ "fieldLabel": "Sp\u00e9cificit\u00e9", "name": "faculty", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.newcomers.Faculties.detail)}, "emptyText": "Choisir Sp\u00e9cificit\u00e9...", "selectOnFocus": true, "hiddenName": "facultyHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/pcsw/Clients/faculty", "method": "GET" }) }) });
    var newcomers_left_panel1710 = new Ext.Panel({ "flex": 33, "autoHeight": true, "layout": "form", "items": [ { "autoHeight": true, "layout": "form", "xtype": "panel", "items": workflow_buttons_disp1707, "anchor": "-20", "labelAlign": "top" }, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": broker1708, "anchor": "-20", "labelAlign": "top" }, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": faculty1709, "anchor": "-20", "labelAlign": "top" } ], "frame": true, "bodyBorder": false, "autoScroll": false, "hideCheckBoxLabels": true, "labelWidth": 135, "border": false, "labelAlign": "top" });
    var newcomers_AvailableCoachesByClient_grid1728 = new Lino.newcomers.AvailableCoachesByClient.GridPanel({ "tools": [ Lino.show_in_own_window_button(Lino.newcomers.AvailableCoachesByClient.grid) ], "containing_panel": this, "hide_top_toolbar": true, "master_panel": this, "flex": 66 });
    var coaching_1_panel1729 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "hideCheckBoxLabels": true, "items": [ newcomers_left_panel1710, newcomers_AvailableCoachesByClient_grid1728 ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var pcsw_ContactsByClient_grid1737 = new Lino.pcsw.ContactsByClient.GridPanel({ "tools": [ Lino.show_in_own_window_button(Lino.pcsw.ContactsByClient.grid) ], "containing_panel": this, "hide_top_toolbar": true, "master_panel": this, "flex": 50 });
    var pcsw_CoachingsByClient_grid1745 = new Lino.pcsw.CoachingsByClient.GridPanel({ "tools": [ Lino.show_in_own_window_button(Lino.pcsw.CoachingsByClient.grid) ], "containing_panel": this, "hide_top_toolbar": true, "master_panel": this, "flex": 50 });
    var coaching_2_panel1746 = new Ext.Panel({ "flex": 50, "border": false, "layout": "hbox", "hideCheckBoxLabels": true, "items": [ pcsw_ContactsByClient_grid1737, pcsw_CoachingsByClient_grid1745 ], "autoScroll": false, "layoutConfig": { "align": "stretch" }, "frame": false, "labelAlign": "top" });
    var coaching_panel1747 = new Ext.Panel({ "layout": "vbox", "title": "Accompagnement", "items": [ coaching_1_panel1729, coaching_2_panel1746 ], "frame": true, "layoutConfig": { "align": "stretch" }, "hideCheckBoxLabels": true, "listeners": { "activate": Lino.on_tab_activate }, "autoScroll": false, "border": false, "bodyBorder": false, "labelAlign": "top" });
    var jobs_StudiesByPerson_grid1760 = new Lino.jobs.StudiesByPerson.GridPanel({ "flex": 5, "hide_top_toolbar": true, "containing_panel": this, "region": "north", "master_panel": this, "listeners": { "render": Lino.quicktip_renderer("\u00c9tudes & formations","List of studies for a given person.") }, "split": true, "tools": [ Lino.show_in_own_window_button(Lino.jobs.StudiesByPerson.grid) ] });
    var jobs_ExperiencesByPerson_grid1770 = new Lino.jobs.ExperiencesByPerson.GridPanel({ "flex": 5, "hide_top_toolbar": true, "split": true, "containing_panel": this, "region": "center", "tools": [ Lino.show_in_own_window_button(Lino.jobs.ExperiencesByPerson.grid) ], "master_panel": this });
    var education_panel1771 = new Lino.VBorderPanel({ "autoScroll": false, "listeners": { "activate": Lino.on_tab_activate }, "border": false, "title": "Formation", "hideCheckBoxLabels": true, "items": [ jobs_StudiesByPerson_grid1760, jobs_ExperiencesByPerson_grid1770 ], "frame": true, "bodyBorder": false, "labelAlign": "top" });
    var cv_LanguageKnowledgesByPerson_grid1778 = new Lino.cv.LanguageKnowledgesByPerson.GridPanel({ "flex": 5, "hide_top_toolbar": true, "split": true, "containing_panel": this, "region": "north", "tools": [ Lino.show_in_own_window_button(Lino.cv.LanguageKnowledgesByPerson.grid) ], "master_panel": this });
    var courses_CourseRequestsByPerson_grid1814 = new Lino.courses.CourseRequestsByPerson.GridPanel({ "flex": 5, "hide_top_toolbar": true, "split": true, "containing_panel": this, "region": "center", "tools": [ Lino.show_in_own_window_button(Lino.courses.CourseRequestsByPerson.grid) ], "master_panel": this });
    var languages_panel1815 = new Lino.VBorderPanel({ "autoScroll": false, "listeners": { "activate": Lino.on_tab_activate }, "border": false, "title": "Langues", "hideCheckBoxLabels": true, "items": [ cv_LanguageKnowledgesByPerson_grid1778, courses_CourseRequestsByPerson_grid1814 ], "frame": true, "bodyBorder": false, "labelAlign": "top" });
    var cv_SkillsByPerson_grid1822 = new Lino.cv.SkillsByPerson.GridPanel({ "tools": [ Lino.show_in_own_window_button(Lino.cv.SkillsByPerson.grid) ], "containing_panel": this, "hide_top_toolbar": true, "master_panel": this, "flex": 35 });
    var cv_SoftSkillsByPerson_grid1829 = new Lino.cv.SoftSkillsByPerson.GridPanel({ "tools": [ Lino.show_in_own_window_button(Lino.cv.SoftSkillsByPerson.grid) ], "containing_panel": this, "hide_top_toolbar": true, "master_panel": this, "flex": 35 });
    var skills1830 = new Ext.form.TextArea({ "selectOnFocus": true, "fieldLabel": "Autres talents", "anchor": "-20 -10", "growMax": 2000, "name": "skills" });
    var competences_1_panel1831 = new Ext.Panel({ "flex": 5, "layout": "hbox", "items": [ cv_SkillsByPerson_grid1822, cv_SoftSkillsByPerson_grid1829, { "items": skills1830, "labelAlign": "top", "layout": "form", "xtype": "panel", "flex": 28 } ], "region": "north", "layoutConfig": { "align": "stretch" }, "hideCheckBoxLabels": true, "split": true, "autoScroll": false, "labelWidth": 135, "border": false, "frame": false, "labelAlign": "top" });
    var cv_ObstaclesByPerson_grid1839 = new Lino.cv.ObstaclesByPerson.GridPanel({ "tools": [ Lino.show_in_own_window_button(Lino.cv.ObstaclesByPerson.grid) ], "containing_panel": this, "hide_top_toolbar": true, "master_panel": this, "flex": 55 });
    var obstacles1840 = new Ext.form.TextArea({ "selectOnFocus": true, "fieldLabel": "Obstacles", "anchor": "-20 -10", "growMax": 2000, "name": "obstacles" });
    var competences_2_panel1841 = new Ext.Panel({ "flex": 5, "layout": "hbox", "items": [ cv_ObstaclesByPerson_grid1839, { "items": obstacles1840, "labelAlign": "top", "layout": "form", "xtype": "panel", "flex": 44 } ], "region": "center", "layoutConfig": { "align": "stretch" }, "hideCheckBoxLabels": true, "split": true, "autoScroll": false, "labelWidth": 90, "border": false, "frame": false, "labelAlign": "top" });
    var competences_panel1843 = new Lino.VBorderPanel({ "autoScroll": false, "listeners": { "activate": Lino.on_tab_activate }, "border": false, "title": "Comp\u00e9tences", "hideCheckBoxLabels": true, "items": [ competences_1_panel1831, competences_2_panel1841 ], "frame": true, "bodyBorder": false, "labelAlign": "top" });
    var jobs_CandidaturesByPerson_grid1852 = new Lino.jobs.CandidaturesByPerson.GridPanel({ "listeners": { "activate": Lino.on_tab_activate }, "hide_top_toolbar": true, "title": "Demandes d'emploi", "containing_panel": this, "tools": [ Lino.show_in_own_window_button(Lino.jobs.CandidaturesByPerson.grid) ], "master_panel": this });
    var isip_ContractsByPerson_grid1956 = new Lino.isip.ContractsByPerson.GridPanel({ "flex": 5, "hide_top_toolbar": true, "containing_panel": this, "region": "north", "params_panel_hidden": true, "master_panel": this, "split": true, "tools": [ Lino.show_in_own_window_button(Lino.isip.ContractsByPerson.grid) ] });
    var jobs_ContractsByPerson_grid2064 = new Lino.jobs.ContractsByPerson.GridPanel({ "flex": 5, "hide_top_toolbar": true, "containing_panel": this, "region": "center", "params_panel_hidden": true, "master_panel": this, "split": true, "tools": [ Lino.show_in_own_window_button(Lino.jobs.ContractsByPerson.grid) ] });
    var contracts_panel2065 = new Lino.VBorderPanel({ "autoScroll": false, "listeners": { "activate": Lino.on_tab_activate }, "border": false, "title": "Contrats", "hideCheckBoxLabels": true, "items": [ isip_ContractsByPerson_grid1956, jobs_ContractsByPerson_grid2064 ], "frame": true, "bodyBorder": false, "labelAlign": "top" });
    var pcsw_NotesByPerson_grid2080 = new Lino.pcsw.NotesByPerson.GridPanel({ "listeners": { "activate": Lino.on_tab_activate }, "hide_top_toolbar": true, "title": "Historique", "containing_panel": this, "tools": [ Lino.show_in_own_window_button(Lino.pcsw.NotesByPerson.grid) ], "master_panel": this });
    var cal_EventsByProject_grid2106 = new Lino.cal.EventsByProject.GridPanel({ "flex": 5, "hide_top_toolbar": true, "containing_panel": this, "region": "north", "params_panel_hidden": true, "master_panel": this, "split": true, "tools": [ Lino.show_in_own_window_button(Lino.cal.EventsByProject.grid) ] });
    var cal_TasksByProject_grid2129 = new Lino.cal.TasksByProject.GridPanel({ "flex": 5, "hide_top_toolbar": true, "split": true, "containing_panel": this, "region": "center", "tools": [ Lino.show_in_own_window_button(Lino.cal.TasksByProject.grid) ], "master_panel": this });
    var calendar_panel2130 = new Lino.VBorderPanel({ "autoScroll": false, "listeners": { "activate": Lino.on_tab_activate }, "border": false, "title": "Calendrier", "hideCheckBoxLabels": true, "items": [ cal_EventsByProject_grid2106, cal_TasksByProject_grid2129 ], "frame": true, "bodyBorder": false, "labelAlign": "top" });
    var outbox_MailsByProject_grid2142 = new Lino.outbox.MailsByProject.GridPanel({ "flex": 5, "hide_top_toolbar": true, "split": true, "containing_panel": this, "region": "north", "tools": [ Lino.show_in_own_window_button(Lino.outbox.MailsByProject.grid) ], "master_panel": this });
    var postings_PostingsByProject_grid2153 = new Lino.postings.PostingsByProject.GridPanel({ "flex": 5, "hide_top_toolbar": true, "split": true, "containing_panel": this, "region": "center", "tools": [ Lino.show_in_own_window_button(Lino.postings.PostingsByProject.grid) ], "master_panel": this });
    var outbox_panel2154 = new Lino.VBorderPanel({ "autoScroll": false, "listeners": { "activate": Lino.on_tab_activate }, "border": false, "title": "Correspondence", "hideCheckBoxLabels": true, "items": [ outbox_MailsByProject_grid2142, postings_PostingsByProject_grid2153 ], "frame": true, "bodyBorder": false, "labelAlign": "top" });
    var activity2155 = new Lino.RemoteComboFieldElement({ "fieldLabel": "Activit\u00e9", "name": "activity", "pageSize": 20, "emptyText": "Choisir Activit\u00e9...", "selectOnFocus": true, "hiddenName": "activityHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/pcsw/Clients/activity", "method": "GET" }) }) });
    var client_state2156 = new Lino.ChoicesFieldElement({ "forceSelection": true, "fieldLabel": "State", "allowBlank": false, "hiddenName": "client_stateHidden", "selectOnFocus": true, "anchor": "-20", "store": Lino.pcsw.ClientStates, "name": "client_state" });
    var refusal_reason2157 = new Lino.ChoicesFieldElement({ "forceSelection": true, "fieldLabel": "refusal reason", "name": "refusal_reason", "selectOnFocus": true, "anchor": "-20", "store": Lino.pcsw.RefusalReasons, "hiddenName": "refusal_reasonHidden" });
    var misc_1_panel2158 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 135, "hideCheckBoxLabels": true, "items": [ { "flex": 27, "autoHeight": true, "layout": "form", "xtype": "panel", "items": activity2155, "labelAlign": "top" }, { "flex": 14, "autoHeight": true, "layout": "form", "xtype": "panel", "items": client_state2156, "labelAlign": "top" }, { "flex": 58, "autoHeight": true, "layout": "form", "xtype": "panel", "items": refusal_reason2157, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var is_cpas2162 = new Ext.form.Checkbox({ "boxLabel": "client CPAS", "hideLabel": true, "checked": false, "name": "is_cpas", "selectOnFocus": true, "anchor": "-20" });
    var is_senior2163 = new Ext.form.Checkbox({ "boxLabel": "retrait\u00e9", "hideLabel": true, "checked": false, "name": "is_senior", "selectOnFocus": true, "anchor": "-20" });
    var is_obsolete2164 = new Ext.form.Checkbox({ "boxLabel": "obsolete", "listeners": { "render": Lino.quicktip_renderer("obsolete","Altf\u00e4lle sind Partner, deren Stammdaten nicht mehr gepflegt werden und \nf\u00fcr neue Operationen nicht benutzt werden k\u00f6nnen.") }, "hideLabel": true, "checked": false, "name": "is_obsolete", "selectOnFocus": true, "anchor": "-20" });
    var misc_2_panel2165 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 108, "hideCheckBoxLabels": true, "items": [ { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": is_cpas2162, "labelAlign": "top" }, { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": is_senior2163, "labelAlign": "top" }, { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": is_obsolete2164, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var remarks2169 = new Ext.form.TextArea({ "selectOnFocus": true, "fieldLabel": "Remarques", "anchor": "-20 -10", "growMax": 2000, "name": "remarks" });
    var remarks22170 = new Ext.form.TextArea({ "selectOnFocus": true, "fieldLabel": "Remarque (Bureau Social)", "anchor": "-20 -10", "growMax": 2000, "name": "remarks2" });
    var misc_3_panel2171 = new Ext.Panel({ "flex": 41, "border": false, "layout": "hbox", "labelWidth": 225, "hideCheckBoxLabels": true, "items": [ { "items": remarks2169, "labelAlign": "top", "layout": "form", "xtype": "panel", "flex": 50 }, { "items": remarks22170, "labelAlign": "top", "layout": "form", "xtype": "panel", "flex": 50 } ], "autoScroll": false, "layoutConfig": { "align": "stretch" }, "frame": false, "labelAlign": "top" });
    var contacts_RolesByPerson_grid2174 = new Lino.contacts.RolesByPerson.GridPanel({ "tools": [ Lino.show_in_own_window_button(Lino.contacts.RolesByPerson.grid) ], "containing_panel": this, "hide_top_toolbar": true, "master_panel": this, "flex": 33 });
    var households_MembersByPerson_grid2175 = new Lino.households.MembersByPerson.GridPanel({ "tools": [ Lino.show_in_own_window_button(Lino.households.MembersByPerson.grid) ], "containing_panel": this, "hide_top_toolbar": true, "master_panel": this, "flex": 66 });
    var misc_4_panel2176 = new Ext.Panel({ "flex": 41, "border": false, "layout": "hbox", "hideCheckBoxLabels": true, "items": [ contacts_RolesByPerson_grid2174, households_MembersByPerson_grid2175 ], "autoScroll": false, "layoutConfig": { "align": "stretch" }, "frame": false, "labelAlign": "top" });
    var misc_panel2177 = new Ext.Panel({ "layout": "vbox", "title": "Divers", "items": [ misc_1_panel2158, misc_2_panel2165, misc_3_panel2171, misc_4_panel2176 ], "frame": true, "layoutConfig": { "align": "stretch" }, "hideCheckBoxLabels": true, "listeners": { "activate": Lino.on_tab_activate }, "autoScroll": false, "border": false, "bodyBorder": false, "labelAlign": "top" });
    var cbss_identify_person_disp2178 = new Ext.form.DisplayField({ "disabled": true, "fieldLabel": "Requ\u00eates IdentifyPerson", "name": "cbss_identify_person", "anchor": "-20", "value": "<br/>", "always_enabled": true });
    var cbss_manage_access_disp2179 = new Ext.form.DisplayField({ "disabled": true, "fieldLabel": "Requ\u00eates ManageAccess", "name": "cbss_manage_access", "anchor": "-20", "value": "<br/>", "always_enabled": true });
    var cbss_retrieve_ti_groups_disp2180 = new Ext.form.DisplayField({ "disabled": true, "fieldLabel": "Requ\u00eates Tx25", "name": "cbss_retrieve_ti_groups", "anchor": "-20", "value": "<br/>", "always_enabled": true });
    var cbss_1_panel2181 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 216, "hideCheckBoxLabels": true, "items": [ { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": cbss_identify_person_disp2178, "labelAlign": "top" }, { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": cbss_manage_access_disp2179, "labelAlign": "top" }, { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": cbss_retrieve_ti_groups_disp2180, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var cbss_summary_htmlbox2185 = new Lino.HtmlBoxPanel({ "flex": 50, "layout": "fit", "name": "cbss_summary", "containing_panel": this, "items": new Ext.BoxComponent({autoScroll:true}), "title": "Sommaire BCSS", "master_panel": this, "value": "<br/>", "always_enabled": true, "bodyStyle": "overflow-x:hidden" });
    var cbss_panel2186 = new Ext.Panel({ "layout": "vbox", "title": "BCSS", "items": [ cbss_1_panel2181, cbss_summary_htmlbox2185 ], "frame": true, "layoutConfig": { "align": "stretch" }, "hideCheckBoxLabels": true, "listeners": { "activate": Lino.on_tab_activate }, "autoScroll": false, "labelWidth": 126, "border": false, "bodyBorder": false, "labelAlign": "top" });
    var debts_BudgetsByPartner_grid2187 = new Lino.debts.BudgetsByPartner.GridPanel({ "flex": 5, "hide_top_toolbar": true, "split": true, "containing_panel": this, "region": "north", "tools": [ Lino.show_in_own_window_button(Lino.debts.BudgetsByPartner.grid) ], "master_panel": this });
    var debts_ActorsByPartner_grid2188 = new Lino.debts.ActorsByPartner.GridPanel({ "flex": 5, "hide_top_toolbar": true, "split": true, "containing_panel": this, "region": "center", "tools": [ Lino.show_in_own_window_button(Lino.debts.ActorsByPartner.grid) ], "master_panel": this });
    var debts_panel2189 = new Lino.VBorderPanel({ "autoScroll": false, "listeners": { "activate": Lino.on_tab_activate }, "border": false, "title": "M\u00e9diation de dettes", "hideCheckBoxLabels": true, "items": [ debts_BudgetsByPartner_grid2187, debts_ActorsByPartner_grid2188 ], "frame": true, "bodyBorder": false, "labelAlign": "top" });
    var main_panel2190 = new Ext.TabPanel({ "hideCheckBoxLabels": true, "border": false, "split": true, "autoScroll": false, "items": [ general_panel1637, status_tab_panel1706, coaching_panel1747, education_panel1771, languages_panel1815, competences_panel1843, jobs_CandidaturesByPerson_grid1852, contracts_panel2065, pcsw_NotesByPerson_grid2080, calendar_panel2130, outbox_panel2154, misc_panel2177, cbss_panel2186, debts_panel2189 ], "activeTab": 0, "bodyBorder": false, "frame": true, "labelAlign": "top" });
    this.items = main_panel2190;
    this.before_row_edit = function(record) {
      city1563.setContextValue('country',record ? record.data['countryHidden'] : undefined);
      city1563.setContextValue('region',record ? record.data['regionHidden'] : undefined);
      image_htmlbox1635.refresh();
      pcsw_ExclusionsByPerson_grid1689.on_master_changed();
      UploadsByController_htmlbox1703.refresh();
      newcomers_AvailableCoachesByClient_grid1728.on_master_changed();
      pcsw_ContactsByClient_grid1737.on_master_changed();
      pcsw_CoachingsByClient_grid1745.on_master_changed();
      jobs_StudiesByPerson_grid1760.on_master_changed();
      jobs_ExperiencesByPerson_grid1770.on_master_changed();
      cv_LanguageKnowledgesByPerson_grid1778.on_master_changed();
      courses_CourseRequestsByPerson_grid1814.on_master_changed();
      cv_SkillsByPerson_grid1822.on_master_changed();
      cv_SoftSkillsByPerson_grid1829.on_master_changed();
      cv_ObstaclesByPerson_grid1839.on_master_changed();
      jobs_CandidaturesByPerson_grid1852.on_master_changed();
      isip_ContractsByPerson_grid1956.on_master_changed();
      jobs_ContractsByPerson_grid2064.on_master_changed();
      pcsw_NotesByPerson_grid2080.on_master_changed();
      cal_EventsByProject_grid2106.on_master_changed();
      cal_TasksByProject_grid2129.on_master_changed();
      outbox_MailsByProject_grid2142.on_master_changed();
      postings_PostingsByProject_grid2153.on_master_changed();
      contacts_RolesByPerson_grid2174.on_master_changed();
      households_MembersByPerson_grid2175.on_master_changed();
      cbss_summary_htmlbox2185.refresh();
      debts_BudgetsByPartner_grid2187.on_master_changed();
      debts_ActorsByPartner_grid2188.on_master_changed();
    }
    this.onRender = function(ct, position) {
      country1562.on('change',Lino.chooser_handler(city1563,'country'));
      Lino.pcsw.Clients.DetailFormPanel.superclass.onRender.call(this, ct, position);
    }
    Lino.pcsw.Clients.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.cal.GuestRoles.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 34,
  initComponent : function() {
    var containing_panel = this;
    var id1161 = new Ext.form.NumberField({ "selectOnFocus": true, "fieldLabel": "ID", "anchor": "-20", "name": "id" });
    var name1162 = new Ext.form.TextField({ "fieldLabel": "Description", "name": "name", "maxLength": 200, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var name_fr1163 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200, "fieldLabel": "Description (fr)", "anchor": "-20", "name": "name_fr" });
    var name_nl1164 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200, "fieldLabel": "Description (nl)", "anchor": "-20", "name": "name_nl" });
    var main_1_panel1165 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 153, "hideCheckBoxLabels": true, "items": [ { "flex": 7, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id1161, "labelAlign": "top" }, { "flex": 30, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name1162, "labelAlign": "top" }, { "flex": 30, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_fr1163, "labelAlign": "top" }, { "flex": 30, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_nl1164, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var build_method1170 = new Lino.ChoicesFieldElement({ "fieldLabel": "M\u00e9thode de construction", "name": "build_method", "selectOnFocus": true, "anchor": "-20", "store": [ [ "appyodt", "AppyOdtBuildMethod" ], [ "appypdf", "AppyPdfBuildMethod" ], [ "appyrtf", "AppyRtfBuildMethod" ], [ "latex", "LatexBuildMethod" ], [ "pisa", "PisaBuildMethod" ], [ "rtf", "RtfBuildMethod" ] ], "hiddenName": "build_methodHidden" });
    var template1171 = new Lino.SimpleRemoteComboFieldElement({ "selectOnFocus": true, "fieldLabel": "Mod\u00e8le", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/GuestRoles/template", "method": "GET" }) }), "name": "template" });
    var email_template1172 = new Lino.SimpleRemoteComboFieldElement({ "listeners": { "render": Lino.quicktip_renderer("Email template","The name of the file to be used as template \nwhen creating an email from a mailable of this type.\n") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Email template</span>", "name": "email_template", "selectOnFocus": true, "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/GuestRoles/email_template", "method": "GET" }) }) });
    var attach_to_email1173 = new Ext.form.Checkbox({ "boxLabel": "Attach to email", "listeners": { "render": Lino.quicktip_renderer("Attach to email","Whether the printable file should be attached to the email\nwhen creating an email from a mailable of this type.\n") }, "hideLabel": true, "checked": false, "name": "attach_to_email", "selectOnFocus": true, "anchor": "-20" });
    var main_2_panel1174 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 216, "hideCheckBoxLabels": true, "items": [ { "flex": 40, "autoHeight": true, "layout": "form", "xtype": "panel", "items": build_method1170, "labelAlign": "top" }, { "flex": 20, "autoHeight": true, "layout": "form", "xtype": "panel", "items": template1171, "labelAlign": "top" }, { "flex": 20, "autoHeight": true, "layout": "form", "xtype": "panel", "items": email_template1172, "labelAlign": "top" }, { "flex": 20, "autoHeight": true, "layout": "form", "xtype": "panel", "items": attach_to_email1173, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var cal_GuestsByRole_grid1188 = new Lino.cal.GuestsByRole.GridPanel({ "tools": [ Lino.show_in_own_window_button(Lino.cal.GuestsByRole.grid) ], "containing_panel": this, "hide_top_toolbar": true, "master_panel": this, "flex": 71 });
    var main_panel1189 = new Ext.Panel({ "autoScroll": false, "border": false, "layout": "vbox", "hideCheckBoxLabels": true, "items": [ main_1_panel1165, main_2_panel1174, cal_GuestsByRole_grid1188 ], "frame": true, "layoutConfig": { "align": "stretch" }, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel1189;
    this.before_row_edit = function(record) {
      template1171.setContextValue('build_method',record ? record.data['build_methodHidden'] : undefined);
      cal_GuestsByRole_grid1188.on_master_changed();
    }
    this.onRender = function(ct, position) {
      build_method1170.on('change',Lino.chooser_handler(template1171,'build_method'));
      Lino.cal.GuestRoles.DetailFormPanel.superclass.onRender.call(this, ct, position);
    }
    Lino.cal.GuestRoles.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.cbss.RetrieveTIGroupsRequests.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 87,
  initComponent : function() {
    var containing_panel = this;
    var id3242 = new Ext.form.NumberField({ "selectOnFocus": true, "fieldLabel": "ID", "anchor": "-20", "name": "id" });
    var person3243 = new Lino.TwinCombo({ "fieldLabel": "Client", "allowBlank": false, "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.pcsw.Clients.detail)}, "emptyText": "Choisir Client...", "selectOnFocus": true, "hiddenName": "personHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cbss/RetrieveTIGroupsRequests/person", "method": "GET" }) }), "name": "person" });
    var user3244 = new Lino.TwinCombo({ "fieldLabel": "Auteur", "allowBlank": false, "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.users.Users.detail)}, "emptyText": "Choisir Utilisateur...", "selectOnFocus": true, "hiddenName": "userHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cbss/RetrieveTIGroupsRequests/user", "method": "GET" }) }), "name": "user" });
    var environment3245 = new Ext.form.TextField({ "disabled": true, "fieldLabel": "T/A/B", "name": "environment", "maxLength": 4, "boxMinWidth": Lino.chars2width(4), "anchor": "-20" });
    var sent3246 = new Ext.form.DisplayField({ "disabled": true, "listeners": { "render": Lino.quicktip_renderer("Ex\u00e9cut\u00e9","The date and time when this request has been executed. \nThis is empty for requests than haven't been sent.\nRead-only.") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Ex\u00e9cut\u00e9</span>", "name": "sent", "anchor": "-20", "value": "<br>" });
    var status3247 = new Lino.ChoicesFieldElement({ "disabled": true, "forceSelection": true, "fieldLabel": "State", "name": "status", "anchor": "-20", "store": Lino.cbss.RequestStates, "hiddenName": "statusHidden" });
    var ticket3248 = new Ext.form.TextField({ "disabled": true, "maxLength": 36, "fieldLabel": "Ticket", "anchor": "-20", "name": "ticket" });
    var info_1_panel3249 = new Ext.form.FieldSet({ "autoHeight": true, "layout": "hbox", "title": "Information requ\u00eate", "layoutConfig": { "align": "stretchmax" }, "frame": false, "bodyBorder": true, "autoScroll": false, "items": [ { "flex": 5, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id3242, "labelAlign": "top" }, { "flex": 21, "autoHeight": true, "layout": "form", "xtype": "panel", "items": person3243, "labelAlign": "top" }, { "flex": 15, "autoHeight": true, "layout": "form", "xtype": "panel", "items": user3244, "labelAlign": "top" }, { "flex": 5, "autoHeight": true, "layout": "form", "xtype": "panel", "items": environment3245, "labelAlign": "top" }, { "flex": 17, "autoHeight": true, "layout": "form", "xtype": "panel", "items": sent3246, "labelAlign": "top" }, { "flex": 12, "autoHeight": true, "layout": "form", "xtype": "panel", "items": status3247, "labelAlign": "top" }, { "flex": 22, "autoHeight": true, "layout": "form", "xtype": "panel", "items": ticket3248, "labelAlign": "top" } ], "hideCheckBoxLabels": true, "labelWidth": 72, "border": false, "labelAlign": "top" });
    var national_id3257 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200, "fieldLabel": "NISS", "anchor": "-20", "name": "national_id" });
    var language3258 = new Lino.ChoicesFieldElement({ "forceSelection": true, "fieldLabel": "Langue", "name": "language", "selectOnFocus": true, "anchor": "-20", "store": Lino.cbss.RequestLanguages, "hiddenName": "languageHidden" });
    var history3259 = new Ext.form.Checkbox({ "boxLabel": "Historique", "listeners": { "render": Lino.quicktip_renderer("Historique","Whatever this means.") }, "hideLabel": true, "checked": true, "name": "history", "selectOnFocus": true, "anchor": "-20" });
    var parameters_panel3260 = new Ext.form.FieldSet({ "autoHeight": true, "layout": "hbox", "title": "Param\u00e8tres", "layoutConfig": { "align": "stretchmax" }, "frame": false, "bodyBorder": true, "autoScroll": false, "items": [ { "flex": 52, "autoHeight": true, "layout": "form", "xtype": "panel", "items": national_id3257, "labelAlign": "top" }, { "flex": 22, "autoHeight": true, "layout": "form", "xtype": "panel", "items": language3258, "labelAlign": "top" }, { "flex": 25, "autoHeight": true, "layout": "form", "xtype": "panel", "items": history3259, "labelAlign": "top" } ], "hideCheckBoxLabels": true, "labelWidth": 99, "border": false, "labelAlign": "top" });
    var cbss_RetrieveTIGroupsResult_grid3269 = new Lino.cbss.RetrieveTIGroupsResult.GridPanel({ "tools": [ Lino.show_in_own_window_button(Lino.cbss.RetrieveTIGroupsResult.grid) ], "containing_panel": this, "hide_top_toolbar": true, "master_panel": this, "flex": 71 });
    var request_panel3270 = new Ext.Panel({ "layout": "vbox", "title": "Requ\u00eate", "items": [ info_1_panel3249, parameters_panel3260, cbss_RetrieveTIGroupsResult_grid3269 ], "frame": true, "layoutConfig": { "align": "stretch" }, "hideCheckBoxLabels": true, "listeners": { "activate": Lino.on_tab_activate }, "autoScroll": false, "border": false, "bodyBorder": false, "labelAlign": "top" });
    var response_xml3271 = new Ext.form.TextArea({ "disabled": true, "listeners": { "render": Lino.quicktip_renderer("R\u00e9ponse","The raw XML response received. \n") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">R\u00e9ponse</span>", "name": "response_xml", "growMax": 2000, "anchor": "-20 -10" });
    var info_messages3272 = new Ext.form.TextArea({ "disabled": true, "fieldLabel": "Messages info", "anchor": "-20 -10", "growMax": 2000, "name": "info_messages" });
    var debug_messages3273 = new Ext.form.TextArea({ "disabled": true, "fieldLabel": "Messages debug", "anchor": "-20 -10", "growMax": 2000, "name": "debug_messages" });
    var technical_panel3274 = new Lino.VBorderPanel({ "autoScroll": false, "listeners": { "activate": Lino.on_tab_activate }, "border": false, "labelWidth": 135, "title": "Technique", "hideCheckBoxLabels": true, "items": [ { "flex": 5, "layout": "form", "xtype": "panel", "items": response_xml3271, "region": "north", "labelAlign": "top", "split": true }, { "flex": 5, "layout": "form", "xtype": "panel", "items": info_messages3272, "region": "center", "labelAlign": "top", "split": true }, { "flex": 5, "layout": "form", "xtype": "panel", "items": debug_messages3273, "region": "south", "labelAlign": "top", "split": true } ], "frame": true, "bodyBorder": false, "labelAlign": "top" });
    var main_panel3278 = new Ext.TabPanel({ "hideCheckBoxLabels": true, "border": false, "split": true, "autoScroll": false, "items": [ request_panel3270, technical_panel3274 ], "activeTab": 0, "bodyBorder": false, "frame": true, "labelAlign": "top" });
    this.items = main_panel3278;
    this.before_row_edit = function(record) {
      cbss_RetrieveTIGroupsResult_grid3269.on_master_changed();
    }
    Lino.cbss.RetrieveTIGroupsRequests.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.uploads.Uploads.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 26,
  initComponent : function() {
    var containing_panel = this;
    var file1190 = Lino.file_field_handler(this,{ "fieldLabel": "File", "name": "file", "maxLength": 100, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var user1191 = new Lino.TwinCombo({ "fieldLabel": "Auteur", "name": "user", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.users.Users.detail)}, "emptyText": "Choisir Utilisateur...", "selectOnFocus": true, "hiddenName": "userHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/uploads/Uploads/user", "method": "GET" }) }) });
    var main_1_panel1192 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 63, "hideCheckBoxLabels": true, "items": [ { "flex": 58, "autoHeight": true, "layout": "form", "xtype": "panel", "items": file1190, "labelAlign": "top" }, { "flex": 41, "autoHeight": true, "layout": "form", "xtype": "panel", "items": user1191, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var type1195 = new Lino.RemoteComboFieldElement({ "fieldLabel": "Type d'upload", "name": "type", "pageSize": 20, "emptyText": "Choisir Type d'upload...", "selectOnFocus": true, "hiddenName": "typeHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/uploads/Uploads/type", "method": "GET" }) }) });
    var description1196 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200, "fieldLabel": "Description", "anchor": "-20", "name": "description" });
    var valid_until1197 = new Lino.DateField({ "selectOnFocus": true, "fieldLabel": "expire le", "anchor": "-20", "name": "valid_until" });
    var main_2_panel1198 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 126, "hideCheckBoxLabels": true, "items": [ { "flex": 40, "autoHeight": true, "layout": "form", "xtype": "panel", "items": type1195, "labelAlign": "top" }, { "flex": 42, "autoHeight": true, "layout": "form", "xtype": "panel", "items": description1196, "labelAlign": "top" }, { "flex": 16, "autoHeight": true, "layout": "form", "xtype": "panel", "items": valid_until1197, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var modified1202 = new Ext.form.DisplayField({ "disabled": true, "fieldLabel": "Modified", "anchor": "-20", "value": "<br>", "name": "modified" });
    var created1203 = new Ext.form.DisplayField({ "disabled": true, "fieldLabel": "Cr\u00e9\u00e9", "anchor": "-20", "value": "<br>", "name": "created" });
    var owner_disp1204 = new Ext.form.DisplayField({ "disabled": true, "fieldLabel": "Contr\u00f4l\u00e9 par", "anchor": "-20", "name": "owner" });
    var main_3_panel1205 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 117, "hideCheckBoxLabels": true, "items": [ { "flex": 38, "autoHeight": true, "layout": "form", "xtype": "panel", "items": modified1202, "labelAlign": "top" }, { "flex": 38, "autoHeight": true, "layout": "form", "xtype": "panel", "items": created1203, "labelAlign": "top" }, { "flex": 23, "autoHeight": true, "layout": "form", "xtype": "panel", "items": owner_disp1204, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var cal_TasksByController_grid1209 = new Lino.cal.TasksByController.GridPanel({ "tools": [ Lino.show_in_own_window_button(Lino.cal.TasksByController.grid) ], "containing_panel": this, "hide_top_toolbar": true, "master_panel": this, "flex": 62 });
    var main_panel1210 = new Ext.Panel({ "autoScroll": false, "border": false, "layout": "vbox", "hideCheckBoxLabels": true, "items": [ main_1_panel1192, main_2_panel1198, main_3_panel1205, cal_TasksByController_grid1209 ], "frame": true, "layoutConfig": { "align": "stretch" }, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel1210;
    this.before_row_edit = function(record) {
      cal_TasksByController_grid1209.on_master_changed();
    }
    Lino.uploads.Uploads.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.jobs.NewJobsOverview.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  disable_editing: true,
  initComponent : function() {
    var containing_panel = this;
    var preview_htmlbox3335 = new Lino.HtmlBoxPanel({ "layout": "fit", "name": "preview", "containing_panel": this, "items": new Ext.BoxComponent({autoScroll:true}), "master_panel": this, "value": "<br/>", "always_enabled": true, "bodyStyle": "overflow-x:hidden" });
    var main_panel3336 = new Ext.Panel({ "autoScroll": false, "border": false, "layout": "fit", "labelWidth": 0, "hideCheckBoxLabels": true, "items": [ preview_htmlbox3335 ], "frame": true, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel3336;
    this.before_row_edit = function(record) {
      preview_htmlbox3335.refresh();
    }
    Lino.jobs.NewJobsOverview.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.courses.CourseProviders.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 77,
  initComponent : function() {
    var containing_panel = this;
    var prefix2817 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200, "fieldLabel": "prefix", "anchor": "-20", "name": "prefix" });
    var name2818 = new Ext.form.TextField({ "fieldLabel": "Name", "name": "name", "maxLength": 200, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var id2819 = new Ext.form.NumberField({ "selectOnFocus": true, "fieldLabel": "ID", "anchor": "-20", "name": "id" });
    var language2820 = new Lino.ChoicesFieldElement({ "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Langue</span>", "allowBlank": false, "value": "de", "hiddenName": "languageHidden", "listeners": { "render": Lino.quicktip_renderer("Langue","Die Sprache, in der Dokumente ausgestellt werden sollen.") }, "selectOnFocus": true, "anchor": "-20", "store": [ [ "de", "German" ], [ "fr", "French" ], [ "nl", "Dutch" ] ], "name": "language" });
    var intro_box_1_panel2821 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 31, "autoHeight": true, "layout": "form", "xtype": "panel", "items": prefix2817, "labelAlign": "top" }, { "flex": 31, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name2818, "labelAlign": "top" }, { "flex": 7, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id2819, "labelAlign": "top" }, { "flex": 29, "autoHeight": true, "layout": "form", "xtype": "panel", "items": language2820, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 63, "border": false, "anchor": "-20", "labelAlign": "top" });
    var vat_id2826 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200, "fieldLabel": "N\u00b0 de TVA", "anchor": "-20", "name": "vat_id" });
    var activity2827 = new Lino.RemoteComboFieldElement({ "fieldLabel": "Activit\u00e9", "name": "activity", "pageSize": 20, "emptyText": "Choisir Activit\u00e9...", "selectOnFocus": true, "hiddenName": "activityHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/courses/CourseProviders/activity", "method": "GET" }) }) });
    var type2828 = new Lino.RemoteComboFieldElement({ "fieldLabel": "Type de soci\u00e9t\u00e9", "name": "type", "pageSize": 20, "emptyText": "Choisir Type d'organisation...", "selectOnFocus": true, "hiddenName": "typeHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/courses/CourseProviders/type", "method": "GET" }) }) });
    var intro_box_2_panel2829 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 23, "autoHeight": true, "layout": "form", "xtype": "panel", "items": vat_id2826, "labelAlign": "top" }, { "flex": 38, "autoHeight": true, "layout": "form", "xtype": "panel", "items": activity2827, "labelAlign": "top" }, { "flex": 38, "autoHeight": true, "layout": "form", "xtype": "panel", "items": type2828, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 144, "border": false, "anchor": "-20", "labelAlign": "top" });
    var bank_account12833 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 40, "fieldLabel": "Compte en banque 1", "anchor": "-20", "name": "bank_account1" });
    var bank_account22834 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 40, "fieldLabel": "Compte en banque 2", "anchor": "-20", "name": "bank_account2" });
    var is_obsolete2835 = new Ext.form.Checkbox({ "boxLabel": "obsolete", "listeners": { "render": Lino.quicktip_renderer("obsolete","Altf\u00e4lle sind Partner, deren Stammdaten nicht mehr gepflegt werden und \nf\u00fcr neue Operationen nicht benutzt werden k\u00f6nnen.") }, "hideLabel": true, "checked": false, "name": "is_obsolete", "selectOnFocus": true, "anchor": "-20" });
    var intro_box_3_panel2836 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 40, "autoHeight": true, "layout": "form", "xtype": "panel", "items": bank_account12833, "labelAlign": "top" }, { "flex": 40, "autoHeight": true, "layout": "form", "xtype": "panel", "items": bank_account22834, "labelAlign": "top" }, { "flex": 19, "autoHeight": true, "layout": "form", "xtype": "panel", "items": is_obsolete2835, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 171, "border": false, "anchor": "-20", "labelAlign": "top" });
    var intro_box_panel2840 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "form", "hideCheckBoxLabels": true, "items": [ intro_box_1_panel2821, intro_box_2_panel2829, intro_box_3_panel2836 ], "frame": true, "bodyBorder": false, "labelAlign": "top" });
    var country2841 = new Lino.TwinCombo({ "fieldLabel": "Pays", "name": "country", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.countries.Countries.detail)}, "emptyText": "Choisir Pays...", "selectOnFocus": true, "hiddenName": "countryHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/courses/CourseProviders/country", "method": "GET" }) }) });
    var region2842 = new Lino.TwinCombo({ "fieldLabel": "Region", "name": "region", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.countries.Cities.detail)}, "emptyText": "Choisir Place...", "selectOnFocus": true, "hiddenName": "regionHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/courses/CourseProviders/region", "method": "GET" }) }) });
    var box3_1_panel2843 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": country2841, "labelAlign": "top" }, { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": region2842, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 63, "border": false, "anchor": "-20", "labelAlign": "top" });
    var city2846 = new Lino.TwinCombo({ "forceSelection": false, "fieldLabel": "Place", "name": "city", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.countries.Cities.detail)}, "emptyText": "Choisir Place...", "selectOnFocus": true, "hiddenName": "cityHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/courses/CourseProviders/city", "method": "GET" }) }) });
    var zip_code2847 = new Ext.form.TextField({ "fieldLabel": "Zip code", "name": "zip_code", "maxLength": 10, "selectOnFocus": true, "boxMinWidth": Lino.chars2width(10), "anchor": "-20" });
    var box3_2_panel2848 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 66, "autoHeight": true, "layout": "form", "xtype": "panel", "items": city2846, "labelAlign": "top" }, { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": zip_code2847, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 81, "border": false, "anchor": "-20", "labelAlign": "top" });
    var street_prefix2851 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Pr\u00e9fixe rue","Text to print before name of street, but to ignore for sorting.") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Pr\u00e9fixe rue</span>", "name": "street_prefix", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var street2852 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Rue","Name of street. Without house number.") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Rue</span>", "name": "street", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var street_no2853 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("N\u00b0","House number") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">N\u00b0</span>", "name": "street_no", "maxLength": 10, "selectOnFocus": true, "boxMinWidth": Lino.chars2width(10), "anchor": "-20" });
    var street_box2854 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("bo\u00eete","Text to print after :attr:`steet_no` on the same line") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">bo\u00eete</span>", "name": "street_box", "maxLength": 10, "selectOnFocus": true, "boxMinWidth": Lino.chars2width(10), "anchor": "-20" });
    var box3_3_panel2855 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 30, "autoHeight": true, "layout": "form", "xtype": "panel", "items": street_prefix2851, "labelAlign": "top" }, { "flex": 36, "autoHeight": true, "layout": "form", "xtype": "panel", "items": street2852, "labelAlign": "top" }, { "flex": 16, "autoHeight": true, "layout": "form", "xtype": "panel", "items": street_no2853, "labelAlign": "top" }, { "flex": 16, "autoHeight": true, "layout": "form", "xtype": "panel", "items": street_box2854, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 108, "border": false, "anchor": "-20", "labelAlign": "top" });
    var addr22860 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Ligne apr\u00e8s le nom de rue","Address line to print below street line") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Ligne apr\u00e8s le nom de rue</span>", "name": "addr2", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var box3_panel2861 = new Ext.Panel({ "flex": 62, "autoHeight": true, "layout": "form", "items": [ box3_1_panel2843, box3_2_panel2848, box3_3_panel2855, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": addr22860, "anchor": "-20", "labelAlign": "top" } ], "frame": true, "bodyBorder": false, "autoScroll": false, "hideCheckBoxLabels": true, "labelWidth": 234, "border": false, "labelAlign": "top" });
    var email2863 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 75, "fieldLabel": "E-mail", "anchor": "-20", "name": "email" });
    var url2864 = new Lino.URLField({ "selectOnFocus": true, "maxLength": 200, "fieldLabel": "URL", "anchor": "-20", "name": "url" });
    var phone2865 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200, "fieldLabel": "T\u00e9l\u00e9phone", "anchor": "-20", "name": "phone" });
    var gsm2866 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200, "fieldLabel": "GSM", "anchor": "-20", "name": "gsm" });
    var box4_panel2867 = new Ext.Panel({ "flex": 37, "autoHeight": true, "layout": "form", "items": [ { "autoHeight": true, "layout": "form", "xtype": "panel", "items": email2863, "anchor": "-20", "labelAlign": "top" }, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": url2864, "anchor": "-20", "labelAlign": "top" }, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": phone2865, "anchor": "-20", "labelAlign": "top" }, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": gsm2866, "anchor": "-20", "labelAlign": "top" } ], "frame": true, "bodyBorder": false, "autoScroll": false, "hideCheckBoxLabels": true, "labelWidth": 90, "border": false, "labelAlign": "top" });
    var address_box_panel2872 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "hideCheckBoxLabels": true, "items": [ box3_panel2861, box4_panel2867 ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var remarks2873 = new Ext.form.TextArea({ "selectOnFocus": true, "fieldLabel": "Remarques", "anchor": "-20 -10", "growMax": 2000, "name": "remarks" });
    var contacts_RolesByCompany_grid2874 = new Lino.contacts.RolesByCompany.GridPanel({ "tools": [ Lino.show_in_own_window_button(Lino.contacts.RolesByCompany.grid) ], "containing_panel": this, "hide_top_toolbar": true, "master_panel": this, "flex": 42 });
    var bottom_box_panel2875 = new Ext.Panel({ "flex": 41, "border": false, "layout": "hbox", "labelWidth": 90, "hideCheckBoxLabels": true, "items": [ { "items": remarks2873, "labelAlign": "top", "layout": "form", "xtype": "panel", "flex": 57 }, contacts_RolesByCompany_grid2874 ], "autoScroll": false, "layoutConfig": { "align": "stretch" }, "frame": false, "labelAlign": "top" });
    var general_panel2877 = new Ext.Panel({ "layout": "vbox", "title": "G\u00e9n\u00e9ral", "items": [ intro_box_panel2840, address_box_panel2872, bottom_box_panel2875 ], "frame": true, "layoutConfig": { "align": "stretch" }, "hideCheckBoxLabels": true, "listeners": { "activate": Lino.on_tab_activate }, "autoScroll": false, "border": false, "bodyBorder": false, "labelAlign": "top" });
    var pcsw_NotesByCompany_grid2878 = new Lino.pcsw.NotesByCompany.GridPanel({ "listeners": { "activate": Lino.on_tab_activate }, "hide_top_toolbar": true, "title": "Events/Notes", "containing_panel": this, "tools": [ Lino.show_in_own_window_button(Lino.pcsw.NotesByCompany.grid) ], "master_panel": this });
    var CourseOffersByProvider_grid2926 = new Lino.courses.CourseOffersByProvider.GridPanel({ "listeners": { "activate": Lino.on_tab_activate }, "hide_top_toolbar": true, "title": "Offres de cours", "containing_panel": this, "tools": [ Lino.show_in_own_window_button(Lino.courses.CourseOffersByProvider.grid) ], "master_panel": this });
    var main_panel2927 = new Ext.TabPanel({ "hideCheckBoxLabels": true, "border": false, "split": true, "autoScroll": false, "items": [ general_panel2877, pcsw_NotesByCompany_grid2878, CourseOffersByProvider_grid2926 ], "activeTab": 0, "bodyBorder": false, "frame": true, "labelAlign": "top" });
    this.items = main_panel2927;
    this.before_row_edit = function(record) {
      region2842.setContextValue('country',record ? record.data['countryHidden'] : undefined);
      city2846.setContextValue('country',record ? record.data['countryHidden'] : undefined);
      city2846.setContextValue('region',record ? record.data['regionHidden'] : undefined);
      contacts_RolesByCompany_grid2874.on_master_changed();
      pcsw_NotesByCompany_grid2878.on_master_changed();
      CourseOffersByProvider_grid2926.on_master_changed();
    }
    this.onRender = function(ct, position) {
      country2841.on('change',Lino.chooser_handler(region2842,'country'));
      country2841.on('change',Lino.chooser_handler(city2846,'country'));
      region2842.on('change',Lino.chooser_handler(city2846,'region'));
      Lino.courses.CourseProviders.DetailFormPanel.superclass.onRender.call(this, ct, position);
    }
    Lino.courses.CourseProviders.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.properties.PropGroups.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 15,
  initComponent : function() {
    var containing_panel = this;
    var id700 = new Ext.form.NumberField({ "selectOnFocus": true, "fieldLabel": "ID", "anchor": "-20", "name": "id" });
    var name701 = new Ext.form.TextField({ "fieldLabel": "Description", "name": "name", "maxLength": 200, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var name_fr702 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200, "fieldLabel": "Description (fr)", "anchor": "-20", "name": "name_fr" });
    var name_nl703 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200, "fieldLabel": "Description (nl)", "anchor": "-20", "name": "name_nl" });
    var main_1_panel704 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 153, "hideCheckBoxLabels": true, "items": [ { "flex": 7, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id700, "labelAlign": "top" }, { "flex": 30, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name701, "labelAlign": "top" }, { "flex": 30, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_fr702, "labelAlign": "top" }, { "flex": 30, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_nl703, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var PropsByGroup_grid709 = new Lino.properties.PropsByGroup.GridPanel({ "tools": [ Lino.show_in_own_window_button(Lino.properties.PropsByGroup.grid) ], "containing_panel": this, "hide_top_toolbar": true, "master_panel": this, "flex": 83 });
    var main_panel710 = new Ext.Panel({ "autoScroll": false, "border": false, "layout": "vbox", "hideCheckBoxLabels": true, "items": [ main_1_panel704, PropsByGroup_grid709 ], "frame": true, "layoutConfig": { "align": "stretch" }, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel710;
    this.before_row_edit = function(record) {
      PropsByGroup_grid709.on_master_changed();
    }
    Lino.properties.PropGroups.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.notes.Notes.InsertFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  autoHeight: true,
  content_type: 91,
  initComponent : function() {
    var containing_panel = this;
    var event_type918 = new Lino.TwinCombo({ "fieldLabel": "Event Type (Form)", "name": "event_type", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.notes.EventTypes.detail)}, "emptyText": "Choisir Event Type...", "selectOnFocus": true, "hiddenName": "event_typeHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/notes/Notes/event_type", "method": "GET" }) }) });
    var type919 = new Lino.TwinCombo({ "fieldLabel": "Note Type (Content)", "name": "type", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.notes.NoteTypes.detail)}, "emptyText": "Choisir Type de note...", "selectOnFocus": true, "hiddenName": "typeHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/notes/Notes/type", "method": "GET" }) }) });
    var main_1_panel920 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": event_type918, "labelAlign": "top" }, { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": type919, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 180, "border": false, "anchor": "-20", "labelAlign": "top" });
    var subject923 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200, "fieldLabel": "Subject", "anchor": "-20", "name": "subject" });
    var project924 = new Lino.TwinCombo({ "fieldLabel": "Client", "name": "project", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.pcsw.Clients.detail)}, "emptyText": "Choisir Client...", "selectOnFocus": true, "hiddenName": "projectHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/notes/Notes/project", "method": "GET" }) }) });
    var company925 = new Lino.TwinCombo({ "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Organisation</span>", "name": "company", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.contacts.Companies.detail)}, "emptyText": "Choisir Organisation...", "listeners": { "render": Lino.quicktip_renderer("Organisation","    An optional third-party Organization that is related to this Note.\n    The note will then be visible in that company's history panel.\n    ") }, "selectOnFocus": true, "hiddenName": "companyHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/notes/Notes/company", "method": "GET" }) }) });
    var main_3_panel926 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": project924, "labelAlign": "top" }, { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": company925, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 117, "border": false, "anchor": "-20", "labelAlign": "top" });
    var main_panel929 = new Ext.Panel({ "hideCheckBoxLabels": true, "autoHeight": true, "border": false, "layout": "form", "labelWidth": 72, "autoScroll": false, "items": [ main_1_panel920, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": subject923, "anchor": "-20", "labelAlign": "top" }, main_3_panel926 ], "frame": true, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel929;
    this.before_row_edit = function(record) {
    }
    Lino.notes.Notes.InsertFormPanel.superclass.initComponent.call(this);
  }
});


Lino.courses.CourseContents.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 78,
  initComponent : function() {
    var containing_panel = this;
    var id2928 = new Ext.form.NumberField({ "selectOnFocus": true, "fieldLabel": "ID", "anchor": "-20", "name": "id" });
    var name2929 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200, "fieldLabel": "Name", "anchor": "-20", "name": "name" });
    var main_1_panel2930 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 19, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id2928, "labelAlign": "top" }, { "flex": 80, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name2929, "labelAlign": "top" } ], "region": "north", "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "split": true, "autoScroll": false, "labelWidth": 45, "border": false, "frame": false, "labelAlign": "top" });
    var courses_CourseOffersByContent_grid2938 = new Lino.courses.CourseOffersByContent.GridPanel({ "flex": 5, "hide_top_toolbar": true, "split": true, "containing_panel": this, "region": "center", "tools": [ Lino.show_in_own_window_button(Lino.courses.CourseOffersByContent.grid) ], "master_panel": this });
    var courses_CourseRequestsByContent_grid2949 = new Lino.courses.CourseRequestsByContent.GridPanel({ "flex": 5, "hide_top_toolbar": true, "split": true, "containing_panel": this, "region": "south", "tools": [ Lino.show_in_own_window_button(Lino.courses.CourseRequestsByContent.grid) ], "master_panel": this });
    var main_panel2950 = new Lino.VBorderPanel({ "autoScroll": false, "border": false, "hideCheckBoxLabels": true, "items": [ main_1_panel2930, courses_CourseOffersByContent_grid2938, courses_CourseRequestsByContent_grid2949 ], "frame": true, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel2950;
    this.before_row_edit = function(record) {
      courses_CourseOffersByContent_grid2938.on_master_changed();
      courses_CourseRequestsByContent_grid2949.on_master_changed();
    }
    Lino.courses.CourseContents.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.countries.Countries.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 11,
  initComponent : function() {
    var containing_panel = this;
    var isocode371 = new Ext.form.TextField({ "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">ISO code</span>", "name": "isocode", "boxMinWidth": Lino.chars2width(4), "listeners": { "render": Lino.quicktip_renderer("ISO code","        The two-letter code for this country as defined by ISO 3166-1. \n        For countries that no longer exist it may be a 4-letter code.") }, "maxLength": 4, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var name372 = new Ext.form.TextField({ "fieldLabel": "Description", "name": "name", "maxLength": 200, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var name_fr373 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200, "fieldLabel": "Description (fr)", "anchor": "-20", "name": "name_fr" });
    var name_nl374 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200, "fieldLabel": "Description (nl)", "anchor": "-20", "name": "name_nl" });
    var short_code375 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Short code","A short abbreviation for regional usage. Obsolete.") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Short code</span>", "name": "short_code", "maxLength": 4, "selectOnFocus": true, "boxMinWidth": Lino.chars2width(4), "anchor": "-20" });
    var inscode376 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("INS code","The official code for this country used by statbel.fgov.be") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">INS code</span>", "name": "inscode", "maxLength": 3, "selectOnFocus": true, "boxMinWidth": Lino.chars2width(3), "anchor": "-20" });
    var main_1_panel377 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 153, "hideCheckBoxLabels": true, "items": [ { "flex": 6, "autoHeight": true, "layout": "form", "xtype": "panel", "items": isocode371, "labelAlign": "top" }, { "flex": 27, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name372, "labelAlign": "top" }, { "flex": 27, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_fr373, "labelAlign": "top" }, { "flex": 27, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_nl374, "labelAlign": "top" }, { "flex": 6, "autoHeight": true, "layout": "form", "xtype": "panel", "items": short_code375, "labelAlign": "top" }, { "flex": 5, "autoHeight": true, "layout": "form", "xtype": "panel", "items": inscode376, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var countries_CitiesByCountry_grid684 = new Lino.countries.CitiesByCountry.GridPanel({ "tools": [ Lino.show_in_own_window_button(Lino.countries.CitiesByCountry.grid) ], "containing_panel": this, "hide_top_toolbar": true, "master_panel": this, "flex": 48 });
    var jobs_StudiesByCountry_grid697 = new Lino.jobs.StudiesByCountry.GridPanel({ "tools": [ Lino.show_in_own_window_button(Lino.jobs.StudiesByCountry.grid) ], "containing_panel": this, "hide_top_toolbar": true, "master_panel": this, "flex": 51 });
    var main_2_panel698 = new Ext.Panel({ "flex": 83, "border": false, "layout": "hbox", "hideCheckBoxLabels": true, "items": [ countries_CitiesByCountry_grid684, jobs_StudiesByCountry_grid697 ], "autoScroll": false, "layoutConfig": { "align": "stretch" }, "frame": false, "labelAlign": "top" });
    var main_panel699 = new Ext.Panel({ "autoScroll": false, "border": false, "layout": "vbox", "hideCheckBoxLabels": true, "items": [ main_1_panel377, main_2_panel698 ], "frame": true, "layoutConfig": { "align": "stretch" }, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel699;
    this.before_row_edit = function(record) {
      countries_CitiesByCountry_grid684.on_master_changed();
      jobs_StudiesByCountry_grid697.on_master_changed();
    }
    Lino.countries.Countries.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.about.About.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  disable_editing: true,
  initComponent : function() {
    var containing_panel = this;
    var main_panel3318 = new Ext.Panel({ "autoScroll": false, "border": false, "layout": "fit", "hideCheckBoxLabels": true, "items": [ { "html": "<div class=\"htmlText\"><span>This is <a href=\"http://welfare.lino-framework.org\" target=\"_blank\">Lino Welfare</a> 1.1.4 using <a href=\"http://site.lino-framework.org\" target=\"_blank\">djangosite</a> 0.1.4, <a href=\"http://www.python.org/\" target=\"_blank\">Python</a> 2.7.3, <a href=\"http://www.djangoproject.com\" target=\"_blank\">Django</a> 1.5.1, <a href=\"http://babel.edgewall.org/\" target=\"_blank\">Babel</a> 1.0dev-r661, <a href=\"http://www.lino-framework.org\" target=\"_blank\">Lino</a> 1.6.7, <a href=\"http://jinja.pocoo.org/\" target=\"_blank\">Jinja</a> 2.6, <a href=\"http://sphinx-doc.org/\" target=\"_blank\">Sphinx</a> 1.2b1, <a href=\"http://labix.org/python-dateutil\" target=\"_blank\">python-dateutil</a> 2.1, <a href=\"http://pypi.python.org/pypi/odfpy\" target=\"_blank\">OdfPy</a> ODFPY/0.9.6, <a href=\"http://docutils.sourceforge.net/\" target=\"_blank\">docutils</a> 0.10, <a href=\"https://fedorahosted.org/suds/\" target=\"_blank\">suds</a> 0.4, <a href=\"http://pyyaml.org/\" target=\"_blank\">PyYaml</a> 3.10, <a href=\"http://appyframework.org/pod.html\" target=\"_blank\">Appy</a> 0.8.3 (2013/02/22 15:29)</span><p>Server uptime : <b>jeudi 16 mai 2013 at 06:29:38.338897</b></p><p>Source timestamps:</p><ul><li>lino : <b>jeudi 16 mai 2013 at 06:28:54.074717</b></li><li>djangosite : <b>jeudi 16 mai 2013 at 05:29:39.050810</b></li><li>atelier : <b>jeudi 16 mai 2013 at 05:05:10.678849</b></li><li>lino_welfare : <b>mercredi 15 mai 2013 at 19:42:04.917727</b></li><li>django : <b>mercredi 8 mai 2013 at 10:18:59.384324</b></li><li>north : <b>dimanche 5 mai 2013 at 22:52:00.438131</b></li></ul></div>", "xtype": "label" } ], "frame": true, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel3318;
    this.before_row_edit = function(record) {
    }
    Lino.about.About.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.countries.Cities.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 13,
  initComponent : function() {
    var containing_panel = this;
    var name393 = new Ext.form.TextField({ "fieldLabel": "Description", "name": "name", "maxLength": 200, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var name_fr394 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200, "fieldLabel": "Description (fr)", "anchor": "-20", "name": "name_fr" });
    var name_nl395 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200, "fieldLabel": "Description (nl)", "anchor": "-20", "name": "name_nl" });
    var country396 = new Lino.TwinCombo({ "fieldLabel": "Pays", "allowBlank": false, "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.countries.Countries.detail)}, "emptyText": "Choisir Pays...", "selectOnFocus": true, "hiddenName": "countryHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/countries/Cities/country", "method": "GET" }) }), "name": "country" });
    var inscode397 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("INS code","The official code for this place used by statbel.fgov.be") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">INS code</span>", "name": "inscode", "maxLength": 5, "selectOnFocus": true, "boxMinWidth": Lino.chars2width(5), "anchor": "-20" });
    var main_1_panel398 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 153, "hideCheckBoxLabels": true, "items": [ { "flex": 23, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name393, "labelAlign": "top" }, { "flex": 23, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_fr394, "labelAlign": "top" }, { "flex": 23, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_nl395, "labelAlign": "top" }, { "flex": 22, "autoHeight": true, "layout": "form", "xtype": "panel", "items": country396, "labelAlign": "top" }, { "flex": 6, "autoHeight": true, "layout": "form", "xtype": "panel", "items": inscode397, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var parent404 = new Lino.TwinCombo({ "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Part of</span>", "name": "parent", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.countries.Cities.detail)}, "emptyText": "Choisir Place...", "listeners": { "render": Lino.quicktip_renderer("Part of","The superordinate geographic place of which this place is a part.") }, "selectOnFocus": true, "hiddenName": "parentHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/countries/Cities/parent", "method": "GET" }) }) });
    var type405 = new Lino.RemoteComboFieldElement({ "fieldLabel": "Place Type", "name": "type", "selectOnFocus": true, "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/countries/Cities/type", "method": "GET" }) }), "hiddenName": "typeHidden" });
    var id406 = new Ext.form.NumberField({ "selectOnFocus": true, "fieldLabel": "ID", "anchor": "-20", "name": "id" });
    var main_2_panel407 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 99, "hideCheckBoxLabels": true, "items": [ { "flex": 57, "autoHeight": true, "layout": "form", "xtype": "panel", "items": parent404, "labelAlign": "top" }, { "flex": 28, "autoHeight": true, "layout": "form", "xtype": "panel", "items": type405, "labelAlign": "top" }, { "flex": 14, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id406, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var CitiesByCity_grid679 = new Lino.countries.CitiesByCity.GridPanel({ "tools": [ Lino.show_in_own_window_button(Lino.countries.CitiesByCity.grid) ], "containing_panel": this, "hide_top_toolbar": true, "master_panel": this, "flex": 41 });
    var contacts_PartnersByCity_grid680 = new Lino.contacts.PartnersByCity.GridPanel({ "tools": [ Lino.show_in_own_window_button(Lino.contacts.PartnersByCity.grid) ], "containing_panel": this, "hide_top_toolbar": true, "master_panel": this, "flex": 50 });
    var jobs_StudiesByCity_grid681 = new Lino.jobs.StudiesByCity.GridPanel({ "tools": [ Lino.show_in_own_window_button(Lino.jobs.StudiesByCity.grid) ], "containing_panel": this, "hide_top_toolbar": true, "master_panel": this, "flex": 50 });
    var main_4_panel682 = new Ext.Panel({ "flex": 41, "border": false, "layout": "hbox", "hideCheckBoxLabels": true, "items": [ contacts_PartnersByCity_grid680, jobs_StudiesByCity_grid681 ], "autoScroll": false, "layoutConfig": { "align": "stretch" }, "frame": false, "labelAlign": "top" });
    var main_panel683 = new Ext.Panel({ "autoScroll": false, "border": false, "layout": "vbox", "hideCheckBoxLabels": true, "items": [ main_1_panel398, main_2_panel407, CitiesByCity_grid679, main_4_panel682 ], "frame": true, "layoutConfig": { "align": "stretch" }, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel683;
    this.before_row_edit = function(record) {
      type405.setContextValue('country',record ? record.data['countryHidden'] : undefined);
      CitiesByCity_grid679.on_master_changed();
      contacts_PartnersByCity_grid680.on_master_changed();
      jobs_StudiesByCity_grid681.on_master_changed();
    }
    this.onRender = function(ct, position) {
      country396.on('change',Lino.chooser_handler(type405,'country'));
      Lino.countries.Cities.DetailFormPanel.superclass.onRender.call(this, ct, position);
    }
    Lino.countries.Cities.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.cbss.ManageAccessRequests.InsertFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  autoHeight: true,
  content_type: 88,
  initComponent : function() {
    var containing_panel = this;
    var person3211 = new Lino.TwinCombo({ "fieldLabel": "Client", "allowBlank": false, "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.pcsw.Clients.detail)}, "emptyText": "Choisir Client...", "selectOnFocus": true, "hiddenName": "personHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cbss/ManageAccessRequests/person", "method": "GET" }) }), "name": "person" });
    var action3212 = new Lino.ChoicesFieldElement({ "forceSelection": true, "fieldLabel": "Action", "allowBlank": false, "hiddenName": "actionHidden", "selectOnFocus": true, "anchor": "-20", "store": Lino.cbss.ManageAction, "name": "action" });
    var start_date3213 = new Lino.DateField({ "selectOnFocus": true, "allowBlank": false, "fieldLabel": "P\u00e9riode du", "anchor": "-20", "name": "start_date" });
    var end_date3214 = new Lino.DateField({ "selectOnFocus": true, "allowBlank": false, "fieldLabel": "P\u00e9riode au", "anchor": "-20", "name": "end_date" });
    var p1_1_panel3215 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 44, "autoHeight": true, "layout": "form", "xtype": "panel", "items": action3212, "labelAlign": "top" }, { "flex": 27, "autoHeight": true, "layout": "form", "xtype": "panel", "items": start_date3213, "labelAlign": "top" }, { "flex": 27, "autoHeight": true, "layout": "form", "xtype": "panel", "items": end_date3214, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 99, "border": false, "anchor": "-20", "labelAlign": "top" });
    var purpose3219 = new Lino.RemoteComboFieldElement({ "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Code fonction</span>", "allowBlank": false, "pageSize": 20, "emptyText": "Choisir Code fonction...", "listeners": { "render": Lino.quicktip_renderer("Code fonction","The purpose for which the inscription needs to be \nregistered/unregistered or listed. \nFor listing this field is optional, \nfor register/unregister it is mandatory.") }, "selectOnFocus": true, "hiddenName": "purposeHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cbss/ManageAccessRequests/purpose", "method": "GET" }) }), "name": "purpose" });
    var query_register3220 = new Lino.ChoicesFieldElement({ "forceSelection": true, "fieldLabel": "Query Register", "allowBlank": false, "hiddenName": "query_registerHidden", "selectOnFocus": true, "anchor": "-20", "store": Lino.cbss.QueryRegister, "name": "query_register" });
    var p1_2_panel3221 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 62, "autoHeight": true, "layout": "form", "xtype": "panel", "items": purpose3219, "labelAlign": "top" }, { "flex": 37, "autoHeight": true, "layout": "form", "xtype": "panel", "items": query_register3220, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 135, "border": false, "anchor": "-20", "labelAlign": "top" });
    var p1_panel3224 = new Ext.form.FieldSet({ "autoHeight": true, "layout": "form", "title": "Action demand\u00e9e", "items": [ p1_1_panel3215, p1_2_panel3221 ], "frame": true, "bodyBorder": false, "autoScroll": false, "hideCheckBoxLabels": true, "border": false, "anchor": "-20", "labelAlign": "top" });
    var national_id3225 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("NISS","The SSIN of the person to register/unregister/list.\n") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">NISS</span>", "name": "national_id", "maxLength": 200, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var sis_card_no3226 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("No carte SIS","The number of the SIS card used to authenticate the person.") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">No carte SIS</span>", "name": "sis_card_no", "maxLength": 10, "selectOnFocus": true, "boxMinWidth": Lino.chars2width(10), "anchor": "-20" });
    var id_card_no3227 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("No carte eID","The number of the ID card used to authenticate the person.") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">No carte eID</span>", "name": "id_card_no", "maxLength": 20, "selectOnFocus": true, "anchor": "-20" });
    var proof_1_panel3228 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 39, "autoHeight": true, "layout": "form", "xtype": "panel", "items": national_id3225, "labelAlign": "top" }, { "flex": 20, "autoHeight": true, "layout": "form", "xtype": "panel", "items": sis_card_no3226, "labelAlign": "top" }, { "flex": 39, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id_card_no3227, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 117, "border": false, "anchor": "-20", "labelAlign": "top" });
    var first_name3232 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200, "fieldLabel": "Pr\u00e9nom", "anchor": "-20", "name": "first_name" });
    var last_name3233 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200, "fieldLabel": "Nom de famille", "anchor": "-20", "name": "last_name" });
    var birth_date3234 = new Lino.IncompleteDateField({ "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("date de naissance","Uncomplete dates are allowed, e.g. \n\"00.00.1980\" means \"some day in 1980\", \n\"00.07.1980\" means \"in July 1980\"\nor \"23.07.0000\" means \"on a 23th of July\".") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">date de naissance</span>", "anchor": "-20", "name": "birth_date" });
    var proof_2_panel3235 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 38, "autoHeight": true, "layout": "form", "xtype": "panel", "items": first_name3232, "labelAlign": "top" }, { "flex": 38, "autoHeight": true, "layout": "form", "xtype": "panel", "items": last_name3233, "labelAlign": "top" }, { "flex": 22, "autoHeight": true, "layout": "form", "xtype": "panel", "items": birth_date3234, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 162, "border": false, "anchor": "-20", "labelAlign": "top" });
    var proof_panel3239 = new Ext.form.FieldSet({ "autoHeight": true, "layout": "form", "title": "Preuve d'identification", "items": [ proof_1_panel3228, proof_2_panel3235 ], "frame": true, "bodyBorder": false, "autoScroll": false, "hideCheckBoxLabels": true, "border": false, "anchor": "-20", "labelAlign": "top" });
    var main_panel3240 = new Ext.Panel({ "hideCheckBoxLabels": true, "autoHeight": true, "border": false, "layout": "form", "labelWidth": 63, "autoScroll": false, "items": [ { "autoHeight": true, "layout": "form", "xtype": "panel", "items": person3211, "anchor": "-20", "labelAlign": "top" }, p1_panel3224, proof_panel3239 ], "frame": true, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel3240;
    this.before_row_edit = function(record) {
      purpose3219.setContextValue('sector',record ? record.data['sectorHidden'] : undefined);
    }
    Lino.cbss.ManageAccessRequests.InsertFormPanel.superclass.initComponent.call(this);
    // active_fields:
    person3211.on("change",function(){this.save()},this);
  }
});


Lino.jobs.JobsOverview.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  disable_editing: true,
  initComponent : function() {
    var containing_panel = this;
    var body_htmlbox3326 = new Lino.HtmlBoxPanel({ "layout": "fit", "name": "body", "containing_panel": this, "items": new Ext.BoxComponent({autoScroll:true}), "master_panel": this, "value": "<br/>", "always_enabled": true, "bodyStyle": "overflow-x:hidden" });
    var main_panel3327 = new Ext.Panel({ "autoScroll": false, "border": false, "layout": "fit", "labelWidth": 0, "hideCheckBoxLabels": true, "items": [ body_htmlbox3326 ], "frame": true, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel3327;
    this.before_row_edit = function(record) {
      body_htmlbox3326.refresh();
    }
    Lino.jobs.JobsOverview.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.contacts.Persons.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 21,
  initComponent : function() {
    var containing_panel = this;
    var last_name1449 = new Ext.form.TextField({ "fieldLabel": "Nom de famille", "name": "last_name", "maxLength": 200, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var first_name1450 = new Ext.form.TextField({ "fieldLabel": "Pr\u00e9nom", "name": "first_name", "maxLength": 200, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var gender1451 = new Lino.ChoicesFieldElement({ "forceSelection": true, "fieldLabel": "Sexe", "name": "gender", "selectOnFocus": true, "anchor": "-20", "store": Lino.lino.Genders, "hiddenName": "genderHidden" });
    var title1452 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200, "fieldLabel": "Allocution", "anchor": "-20", "name": "title" });
    var name_box_panel1453 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 38, "autoHeight": true, "layout": "form", "xtype": "panel", "items": last_name1449, "labelAlign": "top" }, { "flex": 27, "autoHeight": true, "layout": "form", "xtype": "panel", "items": first_name1450, "labelAlign": "top" }, { "flex": 16, "autoHeight": true, "layout": "form", "xtype": "panel", "items": gender1451, "labelAlign": "top" }, { "flex": 18, "autoHeight": true, "layout": "form", "xtype": "panel", "items": title1452, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 135, "border": false, "anchor": "-20", "labelAlign": "top" });
    var country1458 = new Lino.TwinCombo({ "fieldLabel": "Pays", "name": "country", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.countries.Countries.detail)}, "emptyText": "Choisir Pays...", "selectOnFocus": true, "hiddenName": "countryHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/contacts/Persons/country", "method": "GET" }) }) });
    var region1459 = new Lino.TwinCombo({ "fieldLabel": "Region", "name": "region", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.countries.Cities.detail)}, "emptyText": "Choisir Place...", "selectOnFocus": true, "hiddenName": "regionHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/contacts/Persons/region", "method": "GET" }) }) });
    var city1460 = new Lino.TwinCombo({ "forceSelection": false, "fieldLabel": "Place", "name": "city", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.countries.Cities.detail)}, "emptyText": "Choisir Place...", "selectOnFocus": true, "hiddenName": "cityHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/contacts/Persons/city", "method": "GET" }) }) });
    var zip_code1461 = new Ext.form.TextField({ "fieldLabel": "Zip code", "name": "zip_code", "maxLength": 10, "selectOnFocus": true, "boxMinWidth": Lino.chars2width(10), "anchor": "-20" });
    var address_box_2_panel1462 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 28, "autoHeight": true, "layout": "form", "xtype": "panel", "items": country1458, "labelAlign": "top" }, { "flex": 28, "autoHeight": true, "layout": "form", "xtype": "panel", "items": region1459, "labelAlign": "top" }, { "flex": 28, "autoHeight": true, "layout": "form", "xtype": "panel", "items": city1460, "labelAlign": "top" }, { "flex": 14, "autoHeight": true, "layout": "form", "xtype": "panel", "items": zip_code1461, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 81, "border": false, "anchor": "-20", "labelAlign": "top" });
    var addr11467 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Ligne avant le nom de rue","Address line before street") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Ligne avant le nom de rue</span>", "name": "addr1", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var street_prefix1468 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Pr\u00e9fixe rue","Text to print before name of street, but to ignore for sorting.") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Pr\u00e9fixe rue</span>", "name": "street_prefix", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var street1469 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Rue","Name of street. Without house number.") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Rue</span>", "name": "street", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var street_no1470 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("N\u00b0","House number") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">N\u00b0</span>", "name": "street_no", "maxLength": 10, "selectOnFocus": true, "boxMinWidth": Lino.chars2width(10), "anchor": "-20" });
    var street_box1471 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("bo\u00eete","Text to print after :attr:`steet_no` on the same line") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">bo\u00eete</span>", "name": "street_box", "maxLength": 10, "selectOnFocus": true, "boxMinWidth": Lino.chars2width(10), "anchor": "-20" });
    var address_box_4_panel1472 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 30, "autoHeight": true, "layout": "form", "xtype": "panel", "items": street_prefix1468, "labelAlign": "top" }, { "flex": 36, "autoHeight": true, "layout": "form", "xtype": "panel", "items": street1469, "labelAlign": "top" }, { "flex": 16, "autoHeight": true, "layout": "form", "xtype": "panel", "items": street_no1470, "labelAlign": "top" }, { "flex": 16, "autoHeight": true, "layout": "form", "xtype": "panel", "items": street_box1471, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 108, "border": false, "anchor": "-20", "labelAlign": "top" });
    var addr21477 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Ligne apr\u00e8s le nom de rue","Address line to print below street line") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Ligne apr\u00e8s le nom de rue</span>", "name": "addr2", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var address_box_panel1478 = new Ext.form.FieldSet({ "flex": 66, "autoHeight": true, "layout": "form", "title": "Addresse", "items": [ name_box_panel1453, address_box_2_panel1462, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": addr11467, "anchor": "-20", "labelAlign": "top" }, address_box_4_panel1472, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": addr21477, "anchor": "-20", "labelAlign": "top" } ], "frame": true, "bodyBorder": false, "autoScroll": false, "hideCheckBoxLabels": true, "labelWidth": 234, "border": false, "labelAlign": "top" });
    var id1481 = new Ext.form.NumberField({ "selectOnFocus": true, "fieldLabel": "ID", "anchor": "-20", "name": "id" });
    var language1482 = new Lino.ChoicesFieldElement({ "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Langue</span>", "allowBlank": false, "value": "de", "hiddenName": "languageHidden", "listeners": { "render": Lino.quicktip_renderer("Langue","Die Sprache, in der Dokumente ausgestellt werden sollen.") }, "selectOnFocus": true, "anchor": "-20", "store": [ [ "de", "German" ], [ "fr", "French" ], [ "nl", "Dutch" ] ], "name": "language" });
    var info_box_panel1483 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id1481, "labelAlign": "top" }, { "flex": 66, "autoHeight": true, "layout": "form", "xtype": "panel", "items": language1482, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 63, "border": false, "anchor": "-20", "labelAlign": "top" });
    var email1486 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 75, "fieldLabel": "E-mail", "anchor": "-20", "name": "email" });
    var url1487 = new Lino.URLField({ "selectOnFocus": true, "maxLength": 200, "fieldLabel": "URL", "anchor": "-20", "name": "url" });
    var phone1488 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200, "fieldLabel": "T\u00e9l\u00e9phone", "anchor": "-20", "name": "phone" });
    var gsm1489 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200, "fieldLabel": "GSM", "anchor": "-20", "name": "gsm" });
    var fax1490 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200, "fieldLabel": "Fax", "anchor": "-20", "name": "fax" });
    var contact_box_5_panel1491 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": gsm1489, "labelAlign": "top" }, { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": fax1490, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 36, "border": false, "anchor": "-20", "labelAlign": "top" });
    var contact_box_panel1494 = new Ext.form.FieldSet({ "flex": 33, "autoHeight": true, "layout": "form", "title": "Contact", "items": [ info_box_panel1483, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": email1486, "anchor": "-20", "labelAlign": "top" }, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": url1487, "anchor": "-20", "labelAlign": "top" }, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": phone1488, "anchor": "-20", "labelAlign": "top" }, contact_box_5_panel1491 ], "frame": true, "bodyBorder": false, "autoScroll": false, "hideCheckBoxLabels": true, "labelWidth": 90, "border": false, "labelAlign": "top" });
    var general_1_panel1498 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "hideCheckBoxLabels": true, "items": [ address_box_panel1478, contact_box_panel1494 ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var activity1499 = new Lino.RemoteComboFieldElement({ "fieldLabel": "Activit\u00e9", "name": "activity", "pageSize": 20, "emptyText": "Choisir Activit\u00e9...", "selectOnFocus": true, "hiddenName": "activityHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/contacts/Persons/activity", "method": "GET" }) }) });
    var bank_account11500 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 40, "fieldLabel": "Compte en banque 1", "anchor": "-20", "name": "bank_account1" });
    var bank_account21501 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 40, "fieldLabel": "Compte en banque 2", "anchor": "-20", "name": "bank_account2" });
    var is_obsolete1502 = new Ext.form.Checkbox({ "boxLabel": "obsolete", "listeners": { "render": Lino.quicktip_renderer("obsolete","Altf\u00e4lle sind Partner, deren Stammdaten nicht mehr gepflegt werden und \nf\u00fcr neue Operationen nicht benutzt werden k\u00f6nnen.") }, "hideLabel": true, "checked": false, "name": "is_obsolete", "selectOnFocus": true, "anchor": "-20" });
    var bottom_box_1_panel1503 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 171, "hideCheckBoxLabels": true, "items": [ { "flex": 27, "autoHeight": true, "layout": "form", "xtype": "panel", "items": activity1499, "labelAlign": "top" }, { "flex": 29, "autoHeight": true, "layout": "form", "xtype": "panel", "items": bank_account11500, "labelAlign": "top" }, { "flex": 29, "autoHeight": true, "layout": "form", "xtype": "panel", "items": bank_account21501, "labelAlign": "top" }, { "flex": 13, "autoHeight": true, "layout": "form", "xtype": "panel", "items": is_obsolete1502, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var is_client1508 = new Ext.form.Checkbox({ "boxLabel": "est un client (<a href=\"javascript:Lino.show_mti_child('is_client',Lino.pcsw.Clients.detail)\">montrer</a>)", "listeners": { "render": Lino.quicktip_renderer("est un client","Whether this Person is a Client.") }, "hideLabel": true, "name": "is_client", "selectOnFocus": true, "anchor": "-20" });
    var created1509 = new Ext.form.DisplayField({ "disabled": true, "fieldLabel": "Cr\u00e9\u00e9", "anchor": "-20", "value": "<br>", "name": "created" });
    var modified1510 = new Ext.form.DisplayField({ "disabled": true, "fieldLabel": "Modified", "anchor": "-20", "value": "<br>", "name": "modified" });
    var bottom_box_2_panel1511 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 126, "hideCheckBoxLabels": true, "items": [ { "flex": 23, "autoHeight": true, "layout": "form", "xtype": "panel", "items": is_client1508, "labelAlign": "top" }, { "flex": 38, "autoHeight": true, "layout": "form", "xtype": "panel", "items": created1509, "labelAlign": "top" }, { "flex": 38, "autoHeight": true, "layout": "form", "xtype": "panel", "items": modified1510, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var remarks1515 = new Ext.form.TextArea({ "selectOnFocus": true, "fieldLabel": "Remarques", "anchor": "-20 -10", "growMax": 2000, "name": "remarks" });
    var contacts_RolesByPerson_grid1520 = new Lino.contacts.RolesByPerson.GridPanel({ "tools": [ Lino.show_in_own_window_button(Lino.contacts.RolesByPerson.grid) ], "containing_panel": this, "hide_top_toolbar": true, "master_panel": this, "flex": 27 });
    var households_MembersByPerson_grid1527 = new Lino.households.MembersByPerson.GridPanel({ "tools": [ Lino.show_in_own_window_button(Lino.households.MembersByPerson.grid) ], "containing_panel": this, "hide_top_toolbar": true, "master_panel": this, "flex": 36 });
    var bottom_box_3_panel1528 = new Ext.Panel({ "flex": 71, "border": false, "layout": "hbox", "labelWidth": 90, "hideCheckBoxLabels": true, "items": [ { "items": remarks1515, "labelAlign": "top", "layout": "form", "xtype": "panel", "flex": 36 }, contacts_RolesByPerson_grid1520, households_MembersByPerson_grid1527 ], "autoScroll": false, "layoutConfig": { "align": "stretch" }, "frame": false, "labelAlign": "top" });
    var bottom_box_panel1530 = new Ext.Panel({ "flex": 58, "border": false, "layout": "vbox", "bodyBorder": false, "hideCheckBoxLabels": true, "items": [ bottom_box_1_panel1503, bottom_box_2_panel1511, bottom_box_3_panel1528 ], "autoScroll": false, "layoutConfig": { "align": "stretch" }, "frame": true, "labelAlign": "top" });
    var general_panel1531 = new Ext.Panel({ "layout": "vbox", "title": "G\u00e9n\u00e9ral", "items": [ general_1_panel1498, bottom_box_panel1530 ], "frame": true, "layoutConfig": { "align": "stretch" }, "hideCheckBoxLabels": true, "listeners": { "activate": Lino.on_tab_activate }, "autoScroll": false, "border": false, "bodyBorder": false, "labelAlign": "top" });
    var debts_BudgetsByPartner_grid1532 = new Lino.debts.BudgetsByPartner.GridPanel({ "flex": 5, "hide_top_toolbar": true, "split": true, "containing_panel": this, "region": "north", "tools": [ Lino.show_in_own_window_button(Lino.debts.BudgetsByPartner.grid) ], "master_panel": this });
    var debts_ActorsByPartner_grid1533 = new Lino.debts.ActorsByPartner.GridPanel({ "flex": 5, "hide_top_toolbar": true, "split": true, "containing_panel": this, "region": "center", "tools": [ Lino.show_in_own_window_button(Lino.debts.ActorsByPartner.grid) ], "master_panel": this });
    var debts_panel1534 = new Lino.VBorderPanel({ "autoScroll": false, "listeners": { "activate": Lino.on_tab_activate }, "border": false, "title": "M\u00e9diation de dettes", "hideCheckBoxLabels": true, "items": [ debts_BudgetsByPartner_grid1532, debts_ActorsByPartner_grid1533 ], "frame": true, "bodyBorder": false, "labelAlign": "top" });
    var main_panel1535 = new Ext.TabPanel({ "hideCheckBoxLabels": true, "border": false, "split": true, "autoScroll": false, "items": [ general_panel1531, debts_panel1534 ], "activeTab": 0, "bodyBorder": false, "frame": true, "labelAlign": "top" });
    this.items = main_panel1535;
    this.before_row_edit = function(record) {
      region1459.setContextValue('country',record ? record.data['countryHidden'] : undefined);
      city1460.setContextValue('country',record ? record.data['countryHidden'] : undefined);
      city1460.setContextValue('region',record ? record.data['regionHidden'] : undefined);
      contacts_RolesByPerson_grid1520.on_master_changed();
      households_MembersByPerson_grid1527.on_master_changed();
      debts_BudgetsByPartner_grid1532.on_master_changed();
      debts_ActorsByPartner_grid1533.on_master_changed();
    }
    this.onRender = function(ct, position) {
      country1458.on('change',Lino.chooser_handler(region1459,'country'));
      country1458.on('change',Lino.chooser_handler(city1460,'country'));
      region1459.on('change',Lino.chooser_handler(city1460,'region'));
      Lino.contacts.Persons.DetailFormPanel.superclass.onRender.call(this, ct, position);
    }
    Lino.contacts.Persons.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.isip.Contracts.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 59,
  initComponent : function() {
    var containing_panel = this;
    var id1891 = new Ext.form.NumberField({ "selectOnFocus": true, "fieldLabel": "ID", "anchor": "-20", "name": "id" });
    var client1892 = new Lino.TwinCombo({ "fieldLabel": "Client", "allowBlank": false, "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.pcsw.Clients.detail)}, "emptyText": "Choisir Client...", "selectOnFocus": true, "hiddenName": "clientHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/isip/Contracts/client", "method": "GET" }) }), "name": "client" });
    var user1893 = new Lino.TwinCombo({ "fieldLabel": "Auteur", "name": "user", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.users.Users.detail)}, "emptyText": "Choisir Utilisateur...", "selectOnFocus": true, "hiddenName": "userHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/isip/Contracts/user", "method": "GET" }) }) });
    var user_asd1894 = new Lino.TwinCombo({ "fieldLabel": "Responsable (SSG)", "name": "user_asd", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.users.Users.detail)}, "emptyText": "Choisir Utilisateur...", "selectOnFocus": true, "hiddenName": "user_asdHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/isip/Contracts/user_asd", "method": "GET" }) }) });
    var language1895 = new Lino.ChoicesFieldElement({ "fieldLabel": "Langue", "allowBlank": false, "value": "de", "hiddenName": "languageHidden", "selectOnFocus": true, "anchor": "-20", "store": [ [ "de", "German" ], [ "fr", "French" ], [ "nl", "Dutch" ] ], "name": "language" });
    var general_1_panel1896 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 162, "hideCheckBoxLabels": true, "items": [ { "flex": 11, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id1891, "labelAlign": "top" }, { "flex": 35, "autoHeight": true, "layout": "form", "xtype": "panel", "items": client1892, "labelAlign": "top" }, { "flex": 21, "autoHeight": true, "layout": "form", "xtype": "panel", "items": user1893, "labelAlign": "top" }, { "flex": 21, "autoHeight": true, "layout": "form", "xtype": "panel", "items": user_asd1894, "labelAlign": "top" }, { "flex": 11, "autoHeight": true, "layout": "form", "xtype": "panel", "items": language1895, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var type1902 = new Lino.TwinCombo({ "fieldLabel": "Type de contrat", "name": "type", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.isip.ContractTypes.detail)}, "emptyText": "Choisir Type de PIIS...", "selectOnFocus": true, "hiddenName": "typeHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/isip/Contracts/type", "method": "GET" }) }) });
    var company1903 = new Lino.TwinCombo({ "fieldLabel": "Organisation", "name": "company", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.contacts.Companies.detail)}, "emptyText": "Choisir Organisation...", "selectOnFocus": true, "hiddenName": "companyHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/isip/Contracts/company", "method": "GET" }) }) });
    var contact_person1904 = new Lino.TwinCombo({ "fieldLabel": "repr\u00e9sent\u00e9 par", "name": "contact_person", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.contacts.Persons.detail)}, "emptyText": "Choisir Personne...", "selectOnFocus": true, "hiddenName": "contact_personHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/isip/Contracts/contact_person", "method": "GET" }) }) });
    var contact_role1905 = new Lino.RemoteComboFieldElement({ "fieldLabel": "repr\u00e9sent\u00e9 par", "name": "contact_role", "pageSize": 20, "emptyText": "Choisir Fonction...", "selectOnFocus": true, "hiddenName": "contact_roleHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/isip/Contracts/contact_role", "method": "GET" }) }) });
    var general_2_panel1906 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 144, "hideCheckBoxLabels": true, "items": [ { "flex": 25, "autoHeight": true, "layout": "form", "xtype": "panel", "items": type1902, "labelAlign": "top" }, { "flex": 25, "autoHeight": true, "layout": "form", "xtype": "panel", "items": company1903, "labelAlign": "top" }, { "flex": 25, "autoHeight": true, "layout": "form", "xtype": "panel", "items": contact_person1904, "labelAlign": "top" }, { "flex": 25, "autoHeight": true, "layout": "form", "xtype": "panel", "items": contact_role1905, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var applies_from1911 = new Lino.DateField({ "selectOnFocus": true, "fieldLabel": "D\u00e9but de contrat", "anchor": "-20", "name": "applies_from" });
    var applies_until1912 = new Lino.DateField({ "selectOnFocus": true, "fieldLabel": "Fin pr\u00e9vue", "anchor": "-20", "name": "applies_until" });
    var exam_policy1913 = new Lino.TwinCombo({ "fieldLabel": "M\u00e9thode d'examination", "name": "exam_policy", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.isip.ExamPolicies.detail)}, "emptyText": "Choisir M\u00e9thode d'examination...", "selectOnFocus": true, "hiddenName": "exam_policyHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/isip/Contracts/exam_policy", "method": "GET" }) }) });
    var general_3_panel1914 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 198, "hideCheckBoxLabels": true, "items": [ { "flex": 22, "autoHeight": true, "layout": "form", "xtype": "panel", "items": applies_from1911, "labelAlign": "top" }, { "flex": 22, "autoHeight": true, "layout": "form", "xtype": "panel", "items": applies_until1912, "labelAlign": "top" }, { "flex": 55, "autoHeight": true, "layout": "form", "xtype": "panel", "items": exam_policy1913, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var date_decided1918 = new Lino.DateField({ "selectOnFocus": true, "fieldLabel": "D\u00e9cid\u00e9 le", "anchor": "-20", "name": "date_decided" });
    var date_issued1919 = new Lino.DateField({ "selectOnFocus": true, "fieldLabel": "D\u00e9livr\u00e9 le", "anchor": "-20", "name": "date_issued" });
    var date_ended1920 = new Lino.DateField({ "selectOnFocus": true, "fieldLabel": "Date de fin", "anchor": "-20", "name": "date_ended" });
    var ending1921 = new Lino.RemoteComboFieldElement({ "fieldLabel": "Cause d'abandon", "name": "ending", "pageSize": 20, "emptyText": "Choisir Cause d'abandon...", "selectOnFocus": true, "hiddenName": "endingHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/isip/Contracts/ending", "method": "GET" }) }) });
    var general_4_panel1922 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 144, "hideCheckBoxLabels": true, "items": [ { "flex": 18, "autoHeight": true, "layout": "form", "xtype": "panel", "items": date_decided1918, "labelAlign": "top" }, { "flex": 18, "autoHeight": true, "layout": "form", "xtype": "panel", "items": date_issued1919, "labelAlign": "top" }, { "flex": 18, "autoHeight": true, "layout": "form", "xtype": "panel", "items": date_ended1920, "labelAlign": "top" }, { "flex": 45, "autoHeight": true, "layout": "form", "xtype": "panel", "items": ending1921, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var cal_TasksByController_grid1927 = new Lino.cal.TasksByController.GridPanel({ "tools": [ Lino.show_in_own_window_button(Lino.cal.TasksByController.grid) ], "containing_panel": this, "hide_top_toolbar": true, "master_panel": this, "flex": 47 });
    var cal_EventsByController_grid1934 = new Lino.cal.EventsByController.GridPanel({ "flex": 52, "hide_top_toolbar": true, "containing_panel": this, "params_panel_hidden": true, "tools": [ Lino.show_in_own_window_button(Lino.cal.EventsByController.grid) ], "master_panel": this });
    var general_5_panel1935 = new Ext.Panel({ "flex": 55, "border": false, "layout": "hbox", "hideCheckBoxLabels": true, "items": [ cal_TasksByController_grid1927, cal_EventsByController_grid1934 ], "autoScroll": false, "layoutConfig": { "align": "stretch" }, "frame": false, "labelAlign": "top" });
    var general_panel1936 = new Ext.Panel({ "layout": "vbox", "title": "G\u00e9n\u00e9ral", "items": [ general_1_panel1896, general_2_panel1906, general_3_panel1914, general_4_panel1922, general_5_panel1935 ], "frame": true, "layoutConfig": { "align": "stretch" }, "hideCheckBoxLabels": true, "listeners": { "activate": Lino.on_tab_activate }, "autoScroll": false, "border": false, "bodyBorder": false, "labelAlign": "top" });
    var stages1937 = new Lino.RichTextPanel({ "selectOnFocus": true, "flex": 50, "containing_panel": this, "name": "stages", "title": "stages" });
    var goals1938 = new Lino.RichTextPanel({ "selectOnFocus": true, "flex": 50, "containing_panel": this, "name": "goals", "title": "buts" });
    var isip_1_panel1939 = new Ext.Panel({ "flex": 5, "layout": "hbox", "items": [ stages1937, goals1938 ], "region": "north", "layoutConfig": { "align": "stretch" }, "hideCheckBoxLabels": true, "split": true, "autoScroll": false, "labelWidth": 0, "border": false, "frame": false, "labelAlign": "top" });
    var duties_asd1940 = new Lino.RichTextPanel({ "selectOnFocus": true, "flex": 50, "containing_panel": this, "name": "duties_asd", "title": "devoirs SSG" });
    var duties_dsbe1941 = new Lino.RichTextPanel({ "selectOnFocus": true, "flex": 50, "containing_panel": this, "name": "duties_dsbe", "title": "devois ISP" });
    var isip_2_panel1942 = new Ext.Panel({ "flex": 5, "layout": "hbox", "items": [ duties_asd1940, duties_dsbe1941 ], "region": "center", "layoutConfig": { "align": "stretch" }, "hideCheckBoxLabels": true, "split": true, "autoScroll": false, "labelWidth": 0, "border": false, "frame": false, "labelAlign": "top" });
    var duties_company1943 = new Lino.RichTextPanel({ "selectOnFocus": true, "flex": 50, "containing_panel": this, "name": "duties_company", "title": "devoirs entreprise" });
    var duties_person1944 = new Lino.RichTextPanel({ "selectOnFocus": true, "flex": 50, "containing_panel": this, "name": "duties_person", "title": "Devoirs personne" });
    var isip_3_panel1945 = new Ext.Panel({ "flex": 5, "layout": "hbox", "items": [ duties_company1943, duties_person1944 ], "region": "south", "layoutConfig": { "align": "stretch" }, "hideCheckBoxLabels": true, "split": true, "autoScroll": false, "labelWidth": 0, "border": false, "frame": false, "labelAlign": "top" });
    var isip_panel1946 = new Lino.VBorderPanel({ "autoScroll": false, "listeners": { "activate": Lino.on_tab_activate }, "border": false, "title": "PIIS", "hideCheckBoxLabels": true, "items": [ isip_1_panel1939, isip_2_panel1942, isip_3_panel1945 ], "frame": true, "bodyBorder": false, "labelAlign": "top" });
    var main_panel1947 = new Ext.TabPanel({ "hideCheckBoxLabels": true, "border": false, "split": true, "autoScroll": false, "items": [ general_panel1936, isip_panel1946 ], "activeTab": 0, "bodyBorder": false, "frame": true, "labelAlign": "top" });
    this.items = main_panel1947;
    this.before_row_edit = function(record) {
      contact_person1904.setContextValue('company',record ? record.data['companyHidden'] : undefined);
      cal_TasksByController_grid1927.on_master_changed();
      cal_EventsByController_grid1934.on_master_changed();
      stages1937.refresh();
      goals1938.refresh();
      duties_asd1940.refresh();
      duties_dsbe1941.refresh();
      duties_company1943.refresh();
      duties_person1944.refresh();
    }
    this.onRender = function(ct, position) {
      company1903.on('change',Lino.chooser_handler(contact_person1904,'company'));
      Lino.isip.Contracts.DetailFormPanel.superclass.onRender.call(this, ct, position);
    }
    Lino.isip.Contracts.DetailFormPanel.superclass.initComponent.call(this);
    // active_fields:
    company1903.on("change",function(){this.save()},this);
  }
});


Lino.ui.ContentTypes.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 5,
  initComponent : function() {
    var containing_panel = this;
    var id149 = new Ext.form.NumberField({ "selectOnFocus": true, "fieldLabel": "ID", "anchor": "-20", "name": "id" });
    var name150 = new Ext.form.TextField({ "fieldLabel": "name", "name": "name", "maxLength": 100, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var app_label151 = new Ext.form.TextField({ "fieldLabel": "app label", "name": "app_label", "maxLength": 100, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var model152 = new Ext.form.TextField({ "fieldLabel": "nom de la classe python du mod\u00e8le", "name": "model", "maxLength": 100, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var base_classes_disp153 = new Ext.form.DisplayField({ "disabled": true, "fieldLabel": "Base classes", "name": "base_classes", "anchor": "-20", "value": "<br/>", "always_enabled": true });
    var main_1_panel154 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 306, "hideCheckBoxLabels": true, "items": [ { "flex": 5, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id149, "labelAlign": "top" }, { "flex": 21, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name150, "labelAlign": "top" }, { "flex": 21, "autoHeight": true, "layout": "form", "xtype": "panel", "items": app_label151, "labelAlign": "top" }, { "flex": 21, "autoHeight": true, "layout": "form", "xtype": "panel", "items": model152, "labelAlign": "top" }, { "flex": 30, "autoHeight": true, "layout": "form", "xtype": "panel", "items": base_classes_disp153, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var ui_HelpTextsByModel_grid166 = new Lino.ui.HelpTextsByModel.GridPanel({ "tools": [ Lino.show_in_own_window_button(Lino.ui.HelpTextsByModel.grid) ], "containing_panel": this, "hide_top_toolbar": true, "master_panel": this, "flex": 62 });
    var main_panel167 = new Ext.Panel({ "autoScroll": false, "border": false, "layout": "vbox", "hideCheckBoxLabels": true, "items": [ main_1_panel154, ui_HelpTextsByModel_grid166 ], "frame": true, "layoutConfig": { "align": "stretch" }, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel167;
    this.before_row_edit = function(record) {
      ui_HelpTextsByModel_grid166.on_master_changed();
    }
    Lino.ui.ContentTypes.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.lino.Home.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  disable_editing: true,
  initComponent : function() {
    var containing_panel = this;
    var quick_links_htmlbox3319 = new Lino.HtmlBoxPanel({ "flex": 3, "layout": "fit", "name": "quick_links", "containing_panel": this, "items": new Ext.BoxComponent({autoScroll:true}), "master_panel": this, "value": "<br/>", "always_enabled": true, "bodyStyle": "overflow-x:hidden" });
    var welcome_htmlbox3320 = new Lino.HtmlBoxPanel({ "flex": 10, "layout": "fit", "name": "welcome", "containing_panel": this, "items": new Ext.BoxComponent({autoScroll:true}), "title": "Bienvenue", "master_panel": this, "value": "<br/>", "always_enabled": true, "bodyStyle": "overflow-x:hidden" });
    var UsersWithClients_htmlbox3321 = new Lino.HtmlBoxPanel({ "flex": 28, "layout": "fit", "name": "UsersWithClients", "containing_panel": this, "items": new Ext.BoxComponent({autoScroll:true}), "title": "Agents et leurs clients", "master_panel": this, "value": "<br/>", "always_enabled": true, "bodyStyle": "overflow-x:hidden", "tools": [ Lino.show_in_own_window_button(Lino.pcsw.UsersWithClients.grid) ] });
    var coming_reminders_htmlbox3322 = new Lino.HtmlBoxPanel({ "flex": 50, "layout": "fit", "name": "coming_reminders", "containing_panel": this, "items": new Ext.BoxComponent({autoScroll:true}), "title": "Rappels \u00e0 venir", "master_panel": this, "value": "<br/>", "always_enabled": true, "bodyStyle": "overflow-x:hidden" });
    var missed_reminders_htmlbox3323 = new Lino.HtmlBoxPanel({ "flex": 50, "layout": "fit", "name": "missed_reminders", "containing_panel": this, "items": new Ext.BoxComponent({autoScroll:true}), "title": "Rappels rat\u00e9s", "master_panel": this, "value": "<br/>", "always_enabled": true, "bodyStyle": "overflow-x:hidden" });
    var main_4_panel3324 = new Ext.Panel({ "flex": 57, "border": false, "layout": "hbox", "labelWidth": 144, "hideCheckBoxLabels": true, "items": [ coming_reminders_htmlbox3322, missed_reminders_htmlbox3323 ], "autoScroll": false, "layoutConfig": { "align": "stretch" }, "frame": false, "labelAlign": "top" });
    var main_panel3325 = new Ext.Panel({ "autoScroll": false, "border": false, "layout": "vbox", "labelWidth": 216, "hideCheckBoxLabels": true, "items": [ quick_links_htmlbox3319, welcome_htmlbox3320, UsersWithClients_htmlbox3321, main_4_panel3324 ], "frame": true, "layoutConfig": { "align": "stretch" }, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel3325;
    this.before_row_edit = function(record) {
      quick_links_htmlbox3319.refresh();
      welcome_htmlbox3320.refresh();
      UsersWithClients_htmlbox3321.refresh();
      coming_reminders_htmlbox3322.refresh();
      missed_reminders_htmlbox3323.refresh();
    }
    Lino.lino.Home.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.jobs.ContractTypes.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 71,
  initComponent : function() {
    var containing_panel = this;
    var id2647 = new Ext.form.NumberField({ "selectOnFocus": true, "fieldLabel": "ID", "anchor": "-20", "name": "id" });
    var name2648 = new Ext.form.TextField({ "fieldLabel": "Description", "name": "name", "maxLength": 200, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var name_fr2649 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200, "fieldLabel": "Description (fr)", "anchor": "-20", "name": "name_fr" });
    var name_nl2650 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200, "fieldLabel": "Description (nl)", "anchor": "-20", "name": "name_nl" });
    var main_1_panel2651 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 153, "hideCheckBoxLabels": true, "items": [ { "flex": 7, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id2647, "labelAlign": "top" }, { "flex": 30, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name2648, "labelAlign": "top" }, { "flex": 30, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_fr2649, "labelAlign": "top" }, { "flex": 30, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_nl2650, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var ref2656 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 20, "fieldLabel": "R\u00e9f\u00e9rence", "anchor": "-20", "name": "ref" });
    var build_method2657 = new Lino.ChoicesFieldElement({ "fieldLabel": "M\u00e9thode de construction", "name": "build_method", "selectOnFocus": true, "anchor": "-20", "store": [ [ "appyodt", "AppyOdtBuildMethod" ], [ "appypdf", "AppyPdfBuildMethod" ], [ "appyrtf", "AppyRtfBuildMethod" ], [ "latex", "LatexBuildMethod" ], [ "pisa", "PisaBuildMethod" ], [ "rtf", "RtfBuildMethod" ] ], "hiddenName": "build_methodHidden" });
    var template2658 = new Lino.SimpleRemoteComboFieldElement({ "selectOnFocus": true, "fieldLabel": "Mod\u00e8le", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/jobs/ContractTypes/template", "method": "GET" }) }), "name": "template" });
    var main_2_panel2659 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 216, "hideCheckBoxLabels": true, "items": [ { "flex": 41, "autoHeight": true, "layout": "form", "xtype": "panel", "items": ref2656, "labelAlign": "top" }, { "flex": 39, "autoHeight": true, "layout": "form", "xtype": "panel", "items": build_method2657, "labelAlign": "top" }, { "flex": 19, "autoHeight": true, "layout": "form", "xtype": "panel", "items": template2658, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var ContractsByType_grid2692 = new Lino.jobs.ContractsByType.GridPanel({ "flex": 71, "hide_top_toolbar": true, "containing_panel": this, "params_panel_hidden": true, "tools": [ Lino.show_in_own_window_button(Lino.jobs.ContractsByType.grid) ], "master_panel": this });
    var main_panel2693 = new Ext.Panel({ "autoScroll": false, "border": false, "layout": "vbox", "hideCheckBoxLabels": true, "items": [ main_1_panel2651, main_2_panel2659, ContractsByType_grid2692 ], "frame": true, "layoutConfig": { "align": "stretch" }, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel2693;
    this.before_row_edit = function(record) {
      template2658.setContextValue('build_method',record ? record.data['build_methodHidden'] : undefined);
      ContractsByType_grid2692.on_master_changed();
    }
    this.onRender = function(ct, position) {
      build_method2657.on('change',Lino.chooser_handler(template2658,'build_method'));
      Lino.jobs.ContractTypes.DetailFormPanel.superclass.onRender.call(this, ct, position);
    }
    Lino.jobs.ContractTypes.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.cbss.RetrieveTIGroupsRequests.InsertFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  autoHeight: true,
  content_type: 87,
  initComponent : function() {
    var containing_panel = this;
    var person3279 = new Lino.TwinCombo({ "fieldLabel": "Client", "allowBlank": false, "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.pcsw.Clients.detail)}, "emptyText": "Choisir Client...", "selectOnFocus": true, "hiddenName": "personHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cbss/RetrieveTIGroupsRequests/person", "method": "GET" }) }), "name": "person" });
    var national_id3280 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200, "fieldLabel": "NISS", "anchor": "-20", "name": "national_id" });
    var language3281 = new Lino.ChoicesFieldElement({ "forceSelection": true, "fieldLabel": "Langue", "name": "language", "selectOnFocus": true, "anchor": "-20", "store": Lino.cbss.RequestLanguages, "hiddenName": "languageHidden" });
    var main_2_panel3282 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 70, "autoHeight": true, "layout": "form", "xtype": "panel", "items": national_id3280, "labelAlign": "top" }, { "flex": 30, "autoHeight": true, "layout": "form", "xtype": "panel", "items": language3281, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 63, "border": false, "anchor": "-20", "labelAlign": "top" });
    var history3285 = new Ext.form.Checkbox({ "boxLabel": "Historique", "listeners": { "render": Lino.quicktip_renderer("Historique","Whatever this means.") }, "hideLabel": true, "checked": true, "name": "history", "selectOnFocus": true, "anchor": "-20" });
    var main_panel3286 = new Ext.Panel({ "hideCheckBoxLabels": true, "autoHeight": true, "border": false, "layout": "form", "labelWidth": 99, "autoScroll": false, "items": [ { "autoHeight": true, "layout": "form", "xtype": "panel", "items": person3279, "anchor": "-20", "labelAlign": "top" }, main_2_panel3282, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": history3285, "anchor": "-20", "labelAlign": "top" } ], "frame": true, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel3286;
    this.before_row_edit = function(record) {
    }
    Lino.cbss.RetrieveTIGroupsRequests.InsertFormPanel.superclass.initComponent.call(this);
  }
});


Lino.users.Users.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 7,
  initComponent : function() {
    var containing_panel = this;
    var username189 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Username","\n        Required. Must be unique. \n        ") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Username</span>", "name": "username", "maxLength": 30, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var id190 = new Ext.form.NumberField({ "selectOnFocus": true, "fieldLabel": "ID", "anchor": "-20", "name": "id" });
    var profile191 = new Lino.ChoicesFieldElement({ "forceSelection": true, "fieldLabel": "User Profile", "name": "profile", "selectOnFocus": true, "anchor": "-20", "store": Lino.lino.UserProfiles, "hiddenName": "profileHidden" });
    var box1_1_panel192 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 29, "autoHeight": true, "layout": "form", "xtype": "panel", "items": username189, "labelAlign": "top" }, { "flex": 6, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id190, "labelAlign": "top" }, { "flex": 63, "autoHeight": true, "layout": "form", "xtype": "panel", "items": profile191, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 117, "border": false, "anchor": "-20", "labelAlign": "top" });
    var first_name196 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 30, "fieldLabel": "Pr\u00e9nom", "anchor": "-20", "name": "first_name" });
    var last_name197 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 30, "fieldLabel": "Nom de famille", "anchor": "-20", "name": "last_name" });
    var partner198 = new Lino.TwinCombo({ "fieldLabel": "Partenaire", "name": "partner", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.contacts.Partners.detail)}, "emptyText": "Choisir Partenaire...", "selectOnFocus": true, "hiddenName": "partnerHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/users/Users/partner", "method": "GET" }) }) });
    var box1_2_panel199 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": first_name196, "labelAlign": "top" }, { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": last_name197, "labelAlign": "top" }, { "flex": 32, "autoHeight": true, "layout": "form", "xtype": "panel", "items": partner198, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 135, "border": false, "anchor": "-20", "labelAlign": "top" });
    var email203 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 75, "fieldLabel": "adresse e-mail", "anchor": "-20", "name": "email" });
    var language204 = new Lino.ChoicesFieldElement({ "fieldLabel": "Langue", "allowBlank": false, "selectOnFocus": true, "hiddenName": "languageHidden", "anchor": "-20", "store": [ [ "de", "German" ], [ "fr", "French" ], [ "nl", "Dutch" ] ], "name": "language" });
    var box1_3_panel205 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 51, "autoHeight": true, "layout": "form", "xtype": "panel", "items": email203, "labelAlign": "top" }, { "flex": 48, "autoHeight": true, "layout": "form", "xtype": "panel", "items": language204, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 135, "border": false, "anchor": "-20", "labelAlign": "top" });
    var created208 = new Ext.form.DisplayField({ "disabled": true, "fieldLabel": "Cr\u00e9\u00e9", "anchor": "-20", "value": "<br>", "name": "created" });
    var modified209 = new Ext.form.DisplayField({ "disabled": true, "fieldLabel": "Modified", "anchor": "-20", "value": "<br>", "name": "modified" });
    var box1_4_panel210 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": created208, "labelAlign": "top" }, { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": modified209, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 81, "border": false, "anchor": "-20", "labelAlign": "top" });
    var box1_panel213 = new Ext.Panel({ "flex": 66, "autoHeight": true, "border": false, "layout": "form", "hideCheckBoxLabels": true, "items": [ box1_1_panel192, box1_2_panel199, box1_3_panel205, box1_4_panel210 ], "frame": true, "autoScroll": false, "bodyBorder": false, "labelAlign": "top" });
    var MembershipsByUser_grid216 = new Lino.users.MembershipsByUser.GridPanel({ "tools": [ Lino.show_in_own_window_button(Lino.users.MembershipsByUser.grid) ], "containing_panel": this, "hide_top_toolbar": true, "master_panel": this, "flex": 33 });
    var general_1_panel217 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "hideCheckBoxLabels": true, "items": [ box1_panel213, MembershipsByUser_grid216 ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var remarks218 = new Ext.form.TextArea({ "selectOnFocus": true, "fieldLabel": "Remarques", "anchor": "-20 -10", "growMax": 2000, "name": "remarks" });
    var AuthoritiesGiven_grid221 = new Lino.users.AuthoritiesGiven.GridPanel({ "tools": [ Lino.show_in_own_window_button(Lino.users.AuthoritiesGiven.grid) ], "containing_panel": this, "hide_top_toolbar": true, "master_panel": this, "flex": 33 });
    var general_2_panel222 = new Ext.Panel({ "flex": 50, "border": false, "layout": "hbox", "labelWidth": 90, "hideCheckBoxLabels": true, "items": [ { "items": remarks218, "labelAlign": "top", "layout": "form", "xtype": "panel", "flex": 66 }, AuthoritiesGiven_grid221 ], "autoScroll": false, "layoutConfig": { "align": "stretch" }, "frame": false, "labelAlign": "top" });
    var general_panel224 = new Ext.Panel({ "layout": "vbox", "title": "G\u00e9n\u00e9ral", "items": [ general_1_panel217, general_2_panel222 ], "frame": true, "layoutConfig": { "align": "stretch" }, "hideCheckBoxLabels": true, "listeners": { "activate": Lino.on_tab_activate }, "autoScroll": false, "border": false, "bodyBorder": false, "labelAlign": "top" });
    var calendar225 = new Lino.TwinCombo({ "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Calendrier par d\u00e9faut</span>", "name": "calendar", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.cal.Calendars.detail)}, "emptyText": "Choisir Calendrier...", "listeners": { "render": Lino.quicktip_renderer("Calendrier par d\u00e9faut","Le calendrier par d\u00e9faut pour vos rendez-vous et t\u00e2ches.") }, "selectOnFocus": true, "hiddenName": "calendarHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/users/Users/calendar", "method": "GET" }) }) });
    var access_class226 = new Lino.ChoicesFieldElement({ "forceSelection": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Classe d'acc\u00e8s par d\u00e9faut</span>", "allowBlank": false, "hiddenName": "access_classHidden", "listeners": { "render": Lino.quicktip_renderer("Classe d'acc\u00e8s par d\u00e9faut","The default access class for your calendar events and tasks.") }, "selectOnFocus": true, "anchor": "-20", "store": Lino.cal.AccessClasses, "name": "access_class" });
    var cal_left_1_panel227 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 234, "hideCheckBoxLabels": true, "items": [ { "flex": 62, "autoHeight": true, "layout": "form", "xtype": "panel", "items": calendar225, "labelAlign": "top" }, { "flex": 37, "autoHeight": true, "layout": "form", "xtype": "panel", "items": access_class226, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var cal_SubscriptionsByUser_grid234 = new Lino.cal.SubscriptionsByUser.GridPanel({ "tools": [ Lino.show_in_own_window_button(Lino.cal.SubscriptionsByUser.grid) ], "containing_panel": this, "hide_top_toolbar": true, "master_panel": this, "flex": 83 });
    var cal_left_panel235 = new Ext.Panel({ "flex": 33, "border": false, "layout": "vbox", "bodyBorder": false, "hideCheckBoxLabels": true, "items": [ cal_left_1_panel227, cal_SubscriptionsByUser_grid234 ], "autoScroll": false, "layoutConfig": { "align": "stretch" }, "frame": true, "labelAlign": "top" });
    var cal_TasksByUser_grid293 = new Lino.cal.TasksByUser.GridPanel({ "tools": [ Lino.show_in_own_window_button(Lino.cal.TasksByUser.grid) ], "containing_panel": this, "hide_top_toolbar": true, "master_panel": this, "flex": 66 });
    var cal_1_panel294 = new Ext.Panel({ "autoScroll": false, "listeners": { "activate": Lino.on_tab_activate }, "border": false, "layout": "hbox", "title": "Calendrier", "hideCheckBoxLabels": true, "items": [ cal_left_panel235, cal_TasksByUser_grid293 ], "frame": false, "layoutConfig": { "align": "stretch" }, "labelAlign": "top" });
    var newcomer_quota295 = new Ext.form.NumberField({ "listeners": { "render": Lino.quicktip_renderer("Quota nouvelles demandes","Wieviel Arbeitszeit dieser Benutzer f\u00fcr Neuantr\u00e4ge zur Verf\u00fcgung steht\n(100 = ganztags, 50 = halbtags, 0 = gar nicht).\nWenn zwei Benutzer die gleiche Belastungspunktzahl haben, \naber einer davon sich nur zu 50% um Neuantr\u00e4ge k\u00fcmmert, \ngilt er als doppelt so belastet wie sein Kollege.\n") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Quota nouvelles demandes</span>", "name": "newcomer_quota", "selectOnFocus": true, "anchor": "-20", "value": 0, "allowBlank": false });
    var coaching_type296 = new Lino.RemoteComboFieldElement({ "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Service</span>", "name": "coaching_type", "pageSize": 20, "emptyText": "Choisir Service...", "listeners": { "render": Lino.quicktip_renderer("Service","The default CoachingType used when creating Coachings.") }, "selectOnFocus": true, "hiddenName": "coaching_typeHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/users/Users/coaching_type", "method": "GET" }) }) });
    var coaching_supervisor297 = new Ext.form.Checkbox({ "boxLabel": "Notify me when a coach has been assigned", "listeners": { "render": Lino.quicktip_renderer("Notify me when a coach has been assigned","Wenn ein Neuantrag einem Begleiter zugewiesen wurde, wird au\u00dfer dem Begleiter auch dieser Benutzer benachrichtigt.") }, "hideLabel": true, "checked": false, "name": "coaching_supervisor", "selectOnFocus": true, "anchor": "-20" });
    var newcomers_CompetencesByUser_grid303 = new Lino.newcomers.CompetencesByUser.GridPanel({ "tools": [ Lino.show_in_own_window_button(Lino.newcomers.CompetencesByUser.grid) ], "containing_panel": this, "hide_top_toolbar": true, "master_panel": this, "flex": 62 });
    var coaching_a_panel304 = new Ext.Panel({ "flex": 33, "layout": "vbox", "items": [ { "items": newcomer_quota295, "autoHeight": true, "layout": "form", "xtype": "panel", "labelAlign": "top" }, { "items": coaching_type296, "autoHeight": true, "layout": "form", "xtype": "panel", "labelAlign": "top" }, { "items": coaching_supervisor297, "autoHeight": true, "layout": "form", "xtype": "panel", "labelAlign": "top" }, newcomers_CompetencesByUser_grid303 ], "frame": true, "layoutConfig": { "align": "stretch" }, "autoScroll": false, "hideCheckBoxLabels": true, "labelWidth": 369, "border": false, "bodyBorder": false, "labelAlign": "top" });
    var pcsw_CoachingsByUser_grid315 = new Lino.pcsw.CoachingsByUser.GridPanel({ "tools": [ Lino.show_in_own_window_button(Lino.pcsw.CoachingsByUser.grid) ], "containing_panel": this, "hide_top_toolbar": true, "master_panel": this, "flex": 66 });
    var coaching_1_panel316 = new Ext.Panel({ "autoScroll": false, "listeners": { "activate": Lino.on_tab_activate }, "border": false, "layout": "hbox", "title": "Accompagnement", "hideCheckBoxLabels": true, "items": [ coaching_a_panel304, pcsw_CoachingsByUser_grid315 ], "frame": false, "layoutConfig": { "align": "stretch" }, "labelAlign": "top" });
    var main_panel317 = new Ext.TabPanel({ "hideCheckBoxLabels": true, "border": false, "split": true, "autoScroll": false, "items": [ general_panel224, cal_1_panel294, coaching_1_panel316 ], "activeTab": 0, "bodyBorder": false, "frame": true, "labelAlign": "top" });
    this.items = main_panel317;
    this.before_row_edit = function(record) {
      MembershipsByUser_grid216.on_master_changed();
      AuthoritiesGiven_grid221.on_master_changed();
      cal_SubscriptionsByUser_grid234.on_master_changed();
      cal_TasksByUser_grid293.on_master_changed();
      newcomers_CompetencesByUser_grid303.on_master_changed();
      pcsw_CoachingsByUser_grid315.on_master_changed();
    }
    Lino.users.Users.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.notes.EventTypes.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 92,
  initComponent : function() {
    var containing_panel = this;
    var id1422 = new Ext.form.NumberField({ "selectOnFocus": true, "fieldLabel": "ID", "anchor": "-20", "name": "id" });
    var name1423 = new Ext.form.TextField({ "fieldLabel": "Description", "name": "name", "maxLength": 200, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var name_fr1424 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200, "fieldLabel": "Description (fr)", "anchor": "-20", "name": "name_fr" });
    var name_nl1425 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200, "fieldLabel": "Description (nl)", "anchor": "-20", "name": "name_nl" });
    var main_1_panel1426 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 7, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id1422, "labelAlign": "top" }, { "flex": 30, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name1423, "labelAlign": "top" }, { "flex": 30, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_fr1424, "labelAlign": "top" }, { "flex": 30, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_nl1425, "labelAlign": "top" } ], "region": "north", "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "split": true, "autoScroll": false, "labelWidth": 153, "border": false, "frame": false, "labelAlign": "top" });
    var remark1431 = new Ext.form.TextArea({ "selectOnFocus": true, "fieldLabel": "Remarque", "anchor": "-20 -10", "growMax": 2000, "name": "remark" });
    var notes_NotesByEventType_grid1446 = new Lino.notes.NotesByEventType.GridPanel({ "flex": 6, "hide_top_toolbar": true, "split": true, "containing_panel": this, "region": "south", "tools": [ Lino.show_in_own_window_button(Lino.notes.NotesByEventType.grid) ], "master_panel": this });
    var main_panel1447 = new Lino.VBorderPanel({ "autoScroll": false, "border": false, "labelWidth": 81, "hideCheckBoxLabels": true, "items": [ main_1_panel1426, { "flex": 3, "layout": "form", "xtype": "panel", "items": remark1431, "region": "center", "labelAlign": "top", "split": true }, notes_NotesByEventType_grid1446 ], "frame": true, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel1447;
    this.before_row_edit = function(record) {
      notes_NotesByEventType_grid1446.on_master_changed();
    }
    Lino.notes.EventTypes.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.jobs.JobTypes.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 73,
  initComponent : function() {
    var containing_panel = this;
    var id2800 = new Ext.form.NumberField({ "selectOnFocus": true, "fieldLabel": "ID", "anchor": "-20", "name": "id" });
    var name2801 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200, "fieldLabel": "Description", "anchor": "-20", "name": "name" });
    var main_1_panel2802 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 108, "hideCheckBoxLabels": true, "items": [ { "flex": 19, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id2800, "labelAlign": "top" }, { "flex": 80, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name2801, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var JobsByType_grid2815 = new Lino.jobs.JobsByType.GridPanel({ "tools": [ Lino.show_in_own_window_button(Lino.jobs.JobsByType.grid) ], "containing_panel": this, "hide_top_toolbar": true, "master_panel": this, "flex": 83 });
    var main_panel2816 = new Ext.Panel({ "autoScroll": false, "border": false, "layout": "vbox", "hideCheckBoxLabels": true, "items": [ main_1_panel2802, JobsByType_grid2815 ], "frame": true, "layoutConfig": { "align": "stretch" }, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel2816;
    this.before_row_edit = function(record) {
      JobsByType_grid2815.on_master_changed();
    }
    Lino.jobs.JobTypes.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.courses.CourseOffers.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 79,
  initComponent : function() {
    var containing_panel = this;
    var id2884 = new Ext.form.NumberField({ "selectOnFocus": true, "fieldLabel": "ID", "anchor": "-20", "name": "id" });
    var title2885 = new Ext.form.TextField({ "fieldLabel": "Name", "name": "title", "maxLength": 200, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var content2886 = new Lino.TwinCombo({ "fieldLabel": "Contenu de cours", "allowBlank": false, "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.courses.CourseContents.detail)}, "emptyText": "Choisir Contenu de cours...", "selectOnFocus": true, "hiddenName": "contentHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/courses/CourseOffers/content", "method": "GET" }) }), "name": "content" });
    var provider2887 = new Lino.TwinCombo({ "fieldLabel": "Organisateur de cours", "allowBlank": false, "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.courses.CourseProviders.detail)}, "emptyText": "Choisir Organisateur de cours...", "selectOnFocus": true, "hiddenName": "providerHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/courses/CourseOffers/provider", "method": "GET" }) }), "name": "provider" });
    var main_1_panel2888 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 11, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id2884, "labelAlign": "top" }, { "flex": 30, "autoHeight": true, "layout": "form", "xtype": "panel", "items": title2885, "labelAlign": "top" }, { "flex": 28, "autoHeight": true, "layout": "form", "xtype": "panel", "items": content2886, "labelAlign": "top" }, { "flex": 28, "autoHeight": true, "layout": "form", "xtype": "panel", "items": provider2887, "labelAlign": "top" } ], "region": "north", "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "split": true, "autoScroll": false, "labelWidth": 198, "border": false, "frame": false, "labelAlign": "top" });
    var description2893 = new Lino.RichTextPanel({ "flex": 5, "split": true, "containing_panel": this, "selectOnFocus": true, "region": "center", "title": "Description", "name": "description" });
    var CoursesByOffer_grid2924 = new Lino.courses.CoursesByOffer.GridPanel({ "flex": 5, "hide_top_toolbar": true, "split": true, "containing_panel": this, "region": "south", "tools": [ Lino.show_in_own_window_button(Lino.courses.CoursesByOffer.grid) ], "master_panel": this });
    var main_panel2925 = new Lino.VBorderPanel({ "autoScroll": false, "border": false, "labelWidth": 0, "hideCheckBoxLabels": true, "items": [ main_1_panel2888, description2893, CoursesByOffer_grid2924 ], "frame": true, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel2925;
    this.before_row_edit = function(record) {
      description2893.refresh();
      CoursesByOffer_grid2924.on_master_changed();
    }
    Lino.courses.CourseOffers.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.isip.ContractTypes.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 57,
  initComponent : function() {
    var containing_panel = this;
    var id2287 = new Ext.form.NumberField({ "selectOnFocus": true, "fieldLabel": "ID", "anchor": "-20", "name": "id" });
    var name2288 = new Ext.form.TextField({ "fieldLabel": "Description", "name": "name", "maxLength": 200, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var name_fr2289 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200, "fieldLabel": "Description (fr)", "anchor": "-20", "name": "name_fr" });
    var name_nl2290 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200, "fieldLabel": "Description (nl)", "anchor": "-20", "name": "name_nl" });
    var main_1_panel2291 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 153, "hideCheckBoxLabels": true, "items": [ { "flex": 7, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id2287, "labelAlign": "top" }, { "flex": 30, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name2288, "labelAlign": "top" }, { "flex": 30, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_fr2289, "labelAlign": "top" }, { "flex": 30, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_nl2290, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var ref2296 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 20, "fieldLabel": "R\u00e9f\u00e9rence", "anchor": "-20", "name": "ref" });
    var build_method2297 = new Lino.ChoicesFieldElement({ "fieldLabel": "M\u00e9thode de construction", "name": "build_method", "selectOnFocus": true, "anchor": "-20", "store": [ [ "appyodt", "AppyOdtBuildMethod" ], [ "appypdf", "AppyPdfBuildMethod" ], [ "appyrtf", "AppyRtfBuildMethod" ], [ "latex", "LatexBuildMethod" ], [ "pisa", "PisaBuildMethod" ], [ "rtf", "RtfBuildMethod" ] ], "hiddenName": "build_methodHidden" });
    var template2298 = new Lino.SimpleRemoteComboFieldElement({ "selectOnFocus": true, "fieldLabel": "Mod\u00e8le", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/isip/ContractTypes/template", "method": "GET" }) }), "name": "template" });
    var main_2_panel2299 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 216, "hideCheckBoxLabels": true, "items": [ { "flex": 41, "autoHeight": true, "layout": "form", "xtype": "panel", "items": ref2296, "labelAlign": "top" }, { "flex": 39, "autoHeight": true, "layout": "form", "xtype": "panel", "items": build_method2297, "labelAlign": "top" }, { "flex": 19, "autoHeight": true, "layout": "form", "xtype": "panel", "items": template2298, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var ContractsByType_grid2328 = new Lino.isip.ContractsByType.GridPanel({ "flex": 71, "hide_top_toolbar": true, "containing_panel": this, "params_panel_hidden": true, "tools": [ Lino.show_in_own_window_button(Lino.isip.ContractsByType.grid) ], "master_panel": this });
    var main_panel2329 = new Ext.Panel({ "autoScroll": false, "border": false, "layout": "vbox", "hideCheckBoxLabels": true, "items": [ main_1_panel2291, main_2_panel2299, ContractsByType_grid2328 ], "frame": true, "layoutConfig": { "align": "stretch" }, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel2329;
    this.before_row_edit = function(record) {
      template2298.setContextValue('build_method',record ? record.data['build_methodHidden'] : undefined);
      ContractsByType_grid2328.on_master_changed();
    }
    this.onRender = function(ct, position) {
      build_method2297.on('change',Lino.chooser_handler(template2298,'build_method'));
      Lino.isip.ContractTypes.DetailFormPanel.superclass.onRender.call(this, ct, position);
    }
    Lino.isip.ContractTypes.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.accounts.Groups.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 44,
  initComponent : function() {
    var containing_panel = this;
    var ref1357 = new Ext.form.TextField({ "fieldLabel": "ref", "name": "ref", "maxLength": 5, "selectOnFocus": true, "boxMinWidth": Lino.chars2width(5), "anchor": "-20" });
    var name1358 = new Ext.form.TextField({ "fieldLabel": "Description", "name": "name", "maxLength": 200, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var name_fr1359 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200, "fieldLabel": "Description (fr)", "anchor": "-20", "name": "name_fr" });
    var name_nl1360 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200, "fieldLabel": "Description (nl)", "anchor": "-20", "name": "name_nl" });
    var main_1_panel1361 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 153, "hideCheckBoxLabels": true, "items": [ { "flex": 8, "autoHeight": true, "layout": "form", "xtype": "panel", "items": ref1357, "labelAlign": "top" }, { "flex": 30, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name1358, "labelAlign": "top" }, { "flex": 30, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_fr1359, "labelAlign": "top" }, { "flex": 30, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_nl1360, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var account_type1366 = new Lino.ChoicesFieldElement({ "forceSelection": true, "fieldLabel": "Type de compte", "name": "account_type", "selectOnFocus": true, "anchor": "-20", "store": Lino.accounts.AccountTypes, "hiddenName": "account_typeHidden" });
    var id1367 = new Ext.form.NumberField({ "selectOnFocus": true, "fieldLabel": "ID", "anchor": "-20", "name": "id" });
    var main_2_panel1368 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 135, "hideCheckBoxLabels": true, "items": [ { "flex": 76, "autoHeight": true, "layout": "form", "xtype": "panel", "items": account_type1366, "labelAlign": "top" }, { "flex": 23, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id1367, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var help_text1371 = new Lino.RichTextPanel({ "selectOnFocus": true, "flex": 41, "containing_panel": this, "name": "help_text", "title": "Introduction" });
    var AccountsByGroup_grid1382 = new Lino.accounts.AccountsByGroup.GridPanel({ "tools": [ Lino.show_in_own_window_button(Lino.accounts.AccountsByGroup.grid) ], "containing_panel": this, "hide_top_toolbar": true, "master_panel": this, "flex": 41 });
    var main_panel1383 = new Ext.Panel({ "autoScroll": false, "border": false, "layout": "vbox", "labelWidth": 0, "hideCheckBoxLabels": true, "items": [ main_1_panel1361, main_2_panel1368, help_text1371, AccountsByGroup_grid1382 ], "frame": true, "layoutConfig": { "align": "stretch" }, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel1383;
    this.before_row_edit = function(record) {
      help_text1371.refresh();
      AccountsByGroup_grid1382.on_master_changed();
    }
    Lino.accounts.Groups.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.contacts.Companies.InsertFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  autoHeight: true,
  content_type: 20,
  initComponent : function() {
    var containing_panel = this;
    var name933 = new Ext.form.TextField({ "fieldLabel": "Name", "name": "name", "maxLength": 200, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var language934 = new Lino.ChoicesFieldElement({ "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Langue</span>", "allowBlank": false, "value": "de", "hiddenName": "languageHidden", "listeners": { "render": Lino.quicktip_renderer("Langue","Die Sprache, in der Dokumente ausgestellt werden sollen.") }, "selectOnFocus": true, "anchor": "-20", "store": [ [ "de", "German" ], [ "fr", "French" ], [ "nl", "Dutch" ] ], "name": "language" });
    var email935 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 75, "fieldLabel": "E-mail", "anchor": "-20", "name": "email" });
    var main_2_panel936 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": language934, "labelAlign": "top" }, { "flex": 66, "autoHeight": true, "layout": "form", "xtype": "panel", "items": email935, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 63, "border": false, "anchor": "-20", "labelAlign": "top" });
    var type939 = new Lino.RemoteComboFieldElement({ "fieldLabel": "Type de soci\u00e9t\u00e9", "name": "type", "pageSize": 20, "emptyText": "Choisir Type d'organisation...", "selectOnFocus": true, "hiddenName": "typeHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/contacts/Companies/type", "method": "GET" }) }) });
    var id940 = new Ext.form.NumberField({ "selectOnFocus": true, "fieldLabel": "ID", "anchor": "-20", "name": "id" });
    var main_3_panel941 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 80, "autoHeight": true, "layout": "form", "xtype": "panel", "items": type939, "labelAlign": "top" }, { "flex": 20, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id940, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 144, "border": false, "anchor": "-20", "labelAlign": "top" });
    var main_panel944 = new Ext.Panel({ "hideCheckBoxLabels": true, "autoHeight": true, "border": false, "layout": "form", "labelWidth": 45, "autoScroll": false, "items": [ { "autoHeight": true, "layout": "form", "xtype": "panel", "items": name933, "anchor": "-20", "labelAlign": "top" }, main_2_panel936, main_3_panel941 ], "frame": true, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel944;
    this.before_row_edit = function(record) {
    }
    Lino.contacts.Companies.InsertFormPanel.superclass.initComponent.call(this);
  }
});


Lino.jobs.Contracts.InsertFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  autoHeight: true,
  content_type: 67,
  initComponent : function() {
    var containing_panel = this;
    var client2059 = new Lino.TwinCombo({ "fieldLabel": "Client", "allowBlank": false, "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.pcsw.Clients.detail)}, "emptyText": "Choisir Client...", "selectOnFocus": true, "hiddenName": "clientHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/jobs/Contracts/client", "method": "GET" }) }), "name": "client" });
    var job2060 = new Lino.TwinCombo({ "fieldLabel": "Emploi", "allowBlank": false, "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.jobs.Jobs.detail)}, "emptyText": "Choisir Emploi...", "selectOnFocus": true, "hiddenName": "jobHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/jobs/Contracts/job", "method": "GET" }) }), "name": "job" });
    var main_panel2061 = new Ext.Panel({ "hideCheckBoxLabels": true, "autoHeight": true, "border": false, "layout": "form", "labelWidth": 63, "autoScroll": false, "items": [ { "autoHeight": true, "layout": "form", "xtype": "panel", "items": client2059, "anchor": "-20", "labelAlign": "top" }, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": job2060, "anchor": "-20", "labelAlign": "top" } ], "frame": true, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel2061;
    this.before_row_edit = function(record) {
    }
    Lino.jobs.Contracts.InsertFormPanel.superclass.initComponent.call(this);
    // active_fields:
    job2060.on("change",function(){this.save()},this);
  }
});


Lino.debts.Budgets.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 84,
  initComponent : function() {
    var containing_panel = this;
    var date551 = new Lino.DateField({ "selectOnFocus": true, "fieldLabel": "Date", "anchor": "-20", "name": "date" });
    var partner552 = new Lino.TwinCombo({ "fieldLabel": "Partenaire", "allowBlank": false, "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.contacts.Partners.detail)}, "emptyText": "Choisir Partenaire...", "selectOnFocus": true, "hiddenName": "partnerHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/debts/Budgets/partner", "method": "GET" }) }), "name": "partner" });
    var id553 = new Ext.form.NumberField({ "selectOnFocus": true, "fieldLabel": "ID", "anchor": "-20", "name": "id" });
    var user554 = new Lino.TwinCombo({ "fieldLabel": "Auteur", "name": "user", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.users.Users.detail)}, "emptyText": "Choisir Utilisateur...", "selectOnFocus": true, "hiddenName": "userHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/debts/Budgets/user", "method": "GET" }) }) });
    var general_1_panel555 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 16, "autoHeight": true, "layout": "form", "xtype": "panel", "items": date551, "labelAlign": "top" }, { "flex": 41, "autoHeight": true, "layout": "form", "xtype": "panel", "items": partner552, "labelAlign": "top" }, { "flex": 10, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id553, "labelAlign": "top" }, { "flex": 31, "autoHeight": true, "layout": "form", "xtype": "panel", "items": user554, "labelAlign": "top" } ], "region": "north", "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "split": true, "autoScroll": false, "labelWidth": 99, "border": false, "frame": false, "labelAlign": "top" });
    var intro560 = new Lino.RichTextPanel({ "flex": 5, "split": true, "containing_panel": this, "selectOnFocus": true, "region": "center", "title": "Introduction", "name": "intro" });
    var ActorsByBudget_grid567 = new Lino.debts.ActorsByBudget.GridPanel({ "flex": 5, "hide_top_toolbar": true, "containing_panel": this, "region": "south", "master_panel": this, "listeners": { "render": Lino.quicktip_renderer("Acteurs","To be filled if there is more than one person involved.") }, "split": true, "tools": [ Lino.show_in_own_window_button(Lino.debts.ActorsByBudget.grid) ] });
    var general_panel568 = new Lino.VBorderPanel({ "autoScroll": false, "listeners": { "activate": Lino.on_tab_activate }, "border": false, "labelWidth": 0, "title": "G\u00e9n\u00e9ral", "hideCheckBoxLabels": true, "items": [ general_1_panel555, intro560, ActorsByBudget_grid567 ], "frame": true, "bodyBorder": false, "labelAlign": "top" });
    var ExpensesByBudget_grid579 = new Lino.debts.ExpensesByBudget.GridPanel({ "flex": 5, "hide_top_toolbar": true, "split": true, "containing_panel": this, "region": "north", "tools": [ Lino.show_in_own_window_button(Lino.debts.ExpensesByBudget.grid) ], "master_panel": this });
    var IncomesByBudget_grid590 = new Lino.debts.IncomesByBudget.GridPanel({ "flex": 5, "hide_top_toolbar": true, "split": true, "containing_panel": this, "region": "center", "tools": [ Lino.show_in_own_window_button(Lino.debts.IncomesByBudget.grid) ], "master_panel": this });
    var entries1_panel591 = new Lino.VBorderPanel({ "autoScroll": false, "listeners": { "activate": Lino.on_tab_activate }, "border": false, "title": "Revenus & D\u00e9penses", "hideCheckBoxLabels": true, "items": [ ExpensesByBudget_grid579, IncomesByBudget_grid590 ], "frame": true, "bodyBorder": false, "labelAlign": "top" });
    var LiabilitiesByBudget_grid603 = new Lino.debts.LiabilitiesByBudget.GridPanel({ "flex": 5, "hide_top_toolbar": true, "split": true, "containing_panel": this, "region": "north", "tools": [ Lino.show_in_own_window_button(Lino.debts.LiabilitiesByBudget.grid) ], "master_panel": this });
    var AssetsByBudget_grid611 = new Lino.debts.AssetsByBudget.GridPanel({ "flex": 5, "hide_top_toolbar": true, "split": true, "containing_panel": this, "region": "center", "tools": [ Lino.show_in_own_window_button(Lino.debts.AssetsByBudget.grid) ], "master_panel": this });
    var entries2_panel612 = new Lino.VBorderPanel({ "autoScroll": false, "listeners": { "activate": Lino.on_tab_activate }, "border": false, "title": "Liabilities & Assets", "hideCheckBoxLabels": true, "items": [ LiabilitiesByBudget_grid603, AssetsByBudget_grid611 ], "frame": true, "bodyBorder": false, "labelAlign": "top" });
    var ResultByBudget_htmlbox613 = new Lino.HtmlBoxPanel({ "flex": 3, "layout": "fit", "name": "ResultByBudget", "containing_panel": this, "items": new Ext.BoxComponent({autoScroll:true}), "region": "north", "title": "Incomes & Expenses", "master_panel": this, "value": "<br/>", "always_enabled": true, "listeners": { "render": Lino.quicktip_renderer("Incomes & Expenses","Shows the Incomes & Expenses for this budget.") }, "bodyStyle": "overflow-x:hidden", "split": true, "tools": [ Lino.show_in_own_window_button(Lino.debts.ResultByBudget.grid) ] });
    var DebtsByBudget_htmlbox614 = new Lino.HtmlBoxPanel({ "flex": 3, "layout": "fit", "name": "DebtsByBudget", "containing_panel": this, "items": new Ext.BoxComponent({autoScroll:true}), "region": "center", "title": "Dettes", "master_panel": this, "value": "<br/>", "always_enabled": true, "bodyStyle": "overflow-x:hidden", "split": true, "tools": [ Lino.show_in_own_window_button(Lino.debts.DebtsByBudget.grid) ] });
    var BailiffDebtsByBudget_htmlbox615 = new Lino.HtmlBoxPanel({ "flex": 3, "layout": "fit", "name": "BailiffDebtsByBudget", "containing_panel": this, "items": new Ext.BoxComponent({autoScroll:true}), "region": "south", "title": "Bailiff Debts", "master_panel": this, "value": "<br/>", "always_enabled": true, "bodyStyle": "overflow-x:hidden", "split": true, "tools": [ Lino.show_in_own_window_button(Lino.debts.BailiffDebtsByBudget.grid) ] });
    var summary1_panel616 = new Lino.VBorderPanel({ "flex": 42, "border": false, "labelWidth": 171, "hideCheckBoxLabels": true, "items": [ ResultByBudget_htmlbox613, DebtsByBudget_htmlbox614, BailiffDebtsByBudget_htmlbox615 ], "frame": true, "autoScroll": false, "bodyBorder": false, "labelAlign": "top" });
    var conclusion617 = new Lino.RichTextPanel({ "selectOnFocus": true, "flex": 71, "containing_panel": this, "name": "conclusion", "title": "Conclusion" });
    var dist_amount618 = new Ext.form.NumberField({ "decimalPrecision": 2, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Distributable amount</span>", "name": "dist_amount", "decimalSeparator": ",", "value": 120, "listeners": { "render": Lino.quicktip_renderer("Distributable amount","The total monthly amount available for debts distribution.") }, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var build_time619 = new Ext.form.DisplayField({ "disabled": true, "fieldLabel": "build time", "anchor": "-20", "value": "<br>", "name": "build_time" });
    var summary2_2_panel620 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 189, "hideCheckBoxLabels": true, "items": [ { "flex": 42, "autoHeight": true, "layout": "form", "xtype": "panel", "items": dist_amount618, "labelAlign": "top" }, { "flex": 57, "autoHeight": true, "layout": "form", "xtype": "panel", "items": build_time619, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var include_yearly_incomes623 = new Ext.form.Checkbox({ "boxLabel": "Include yearly incomes", "listeners": { "render": Lino.quicktip_renderer("Include yearly incomes","Check this to include yearly incomes in the Debts Overview table of this Budget.") }, "hideLabel": true, "checked": false, "name": "include_yearly_incomes", "selectOnFocus": true, "anchor": "-20" });
    var print_empty_rows624 = new Ext.form.Checkbox({ "boxLabel": "Print empty rows", "listeners": { "render": Lino.quicktip_renderer("Print empty rows","Check this to print also empty rows for later completion.") }, "hideLabel": true, "checked": false, "name": "print_empty_rows", "selectOnFocus": true, "anchor": "-20" });
    var print_todos625 = new Ext.form.Checkbox({ "boxLabel": "imprimer liste to-do", "listeners": { "render": Lino.quicktip_renderer("imprimer liste to-do","Eintr\u00e4ge im Feld \"To-do\" werden nur ausgedruckt, \nwenn die Option \"To-dos drucken\" des Budgets angekreuzt ist. \nDiese Option wird aber momentan noch ignoriert \n(d.h. To-do-Liste wird gar nicht ausgedruckt), \nweil wir noch \u00fcberlegen m\u00fcssen, *wie* sie ausgedruckt werden sollen. \nVielleicht mit Fu\u00dfnoten?") }, "hideLabel": true, "checked": false, "name": "print_todos", "selectOnFocus": true, "anchor": "-20" });
    var summary2_3_panel626 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 207, "hideCheckBoxLabels": true, "items": [ { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": include_yearly_incomes623, "labelAlign": "top" }, { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": print_empty_rows624, "labelAlign": "top" }, { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": print_todos625, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var summary2_panel630 = new Ext.Panel({ "flex": 57, "layout": "vbox", "items": [ conclusion617, summary2_2_panel620, summary2_3_panel626 ], "frame": true, "layoutConfig": { "align": "stretch" }, "autoScroll": false, "hideCheckBoxLabels": true, "labelWidth": 0, "border": false, "bodyBorder": false, "labelAlign": "top" });
    var summary_tab_1_panel631 = new Ext.Panel({ "flex": 9, "layout": "hbox", "items": [ summary1_panel616, summary2_panel630 ], "region": "north", "layoutConfig": { "align": "stretch" }, "hideCheckBoxLabels": true, "split": true, "autoScroll": false, "border": false, "frame": false, "labelAlign": "top" });
    var DistByBudget_htmlbox632 = new Lino.HtmlBoxPanel({ "flex": 3, "layout": "fit", "name": "DistByBudget", "containing_panel": this, "items": new Ext.BoxComponent({autoScroll:true}), "region": "center", "title": "R\u00e9partition au marc-le-franc", "master_panel": this, "value": "<br/>", "always_enabled": true, "listeners": { "render": Lino.quicktip_renderer("R\u00e9partition au marc-le-franc","R\u00e9partition au marc-le-franc.\nA table with one row per entry in Liabilities which has \"distribute\" checked, \nproportionally distributing the `Distributable amount` among the debtors.\n") }, "bodyStyle": "overflow-x:hidden", "split": true, "tools": [ Lino.show_in_own_window_button(Lino.debts.DistByBudget.grid) ] });
    var summary_tab_panel633 = new Lino.VBorderPanel({ "autoScroll": false, "listeners": { "activate": Lino.on_tab_activate }, "border": false, "labelWidth": 261, "title": "Summary", "hideCheckBoxLabels": true, "items": [ summary_tab_1_panel631, DistByBudget_htmlbox632 ], "frame": true, "bodyBorder": false, "labelAlign": "top" });
    var preview_htmlbox634 = new Lino.HtmlBoxPanel({ "layout": "fit", "name": "preview", "title": "Pr\u00e9visualisation", "master_panel": this, "items": new Ext.BoxComponent({autoScroll:true}), "containing_panel": this, "bodyStyle": "overflow-x:hidden", "value": "<br/>", "always_enabled": true, "listeners": { "activate": Lino.on_tab_activate } });
    var main_panel635 = new Ext.TabPanel({ "hideCheckBoxLabels": true, "border": false, "split": true, "autoScroll": false, "items": [ general_panel568, entries1_panel591, entries2_panel612, summary_tab_panel633, preview_htmlbox634 ], "activeTab": 0, "bodyBorder": false, "frame": true, "labelAlign": "top" });
    this.items = main_panel635;
    this.before_row_edit = function(record) {
      intro560.refresh();
      ActorsByBudget_grid567.on_master_changed();
      ExpensesByBudget_grid579.on_master_changed();
      IncomesByBudget_grid590.on_master_changed();
      LiabilitiesByBudget_grid603.on_master_changed();
      AssetsByBudget_grid611.on_master_changed();
      ResultByBudget_htmlbox613.refresh();
      DebtsByBudget_htmlbox614.refresh();
      BailiffDebtsByBudget_htmlbox615.refresh();
      conclusion617.refresh();
      DistByBudget_htmlbox632.refresh();
      preview_htmlbox634.refresh();
    }
    Lino.debts.Budgets.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.contacts.Partners.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 23,
  initComponent : function() {
    var containing_panel = this;
    var name464 = new Ext.form.TextField({ "fieldLabel": "Name", "name": "name", "maxLength": 200, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var country465 = new Lino.TwinCombo({ "fieldLabel": "Pays", "name": "country", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.countries.Countries.detail)}, "emptyText": "Choisir Pays...", "selectOnFocus": true, "hiddenName": "countryHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/contacts/Partners/country", "method": "GET" }) }) });
    var region466 = new Lino.TwinCombo({ "fieldLabel": "Region", "name": "region", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.countries.Cities.detail)}, "emptyText": "Choisir Place...", "selectOnFocus": true, "hiddenName": "regionHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/contacts/Partners/region", "method": "GET" }) }) });
    var city467 = new Lino.TwinCombo({ "forceSelection": false, "fieldLabel": "Place", "name": "city", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.countries.Cities.detail)}, "emptyText": "Choisir Place...", "selectOnFocus": true, "hiddenName": "cityHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/contacts/Partners/city", "method": "GET" }) }) });
    var zip_code468 = new Ext.form.TextField({ "fieldLabel": "Zip code", "name": "zip_code", "maxLength": 10, "selectOnFocus": true, "boxMinWidth": Lino.chars2width(10), "anchor": "-20" });
    var address_box_2_panel469 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 28, "autoHeight": true, "layout": "form", "xtype": "panel", "items": country465, "labelAlign": "top" }, { "flex": 28, "autoHeight": true, "layout": "form", "xtype": "panel", "items": region466, "labelAlign": "top" }, { "flex": 28, "autoHeight": true, "layout": "form", "xtype": "panel", "items": city467, "labelAlign": "top" }, { "flex": 14, "autoHeight": true, "layout": "form", "xtype": "panel", "items": zip_code468, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 81, "border": false, "anchor": "-20", "labelAlign": "top" });
    var addr1474 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Ligne avant le nom de rue","Address line before street") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Ligne avant le nom de rue</span>", "name": "addr1", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var street_prefix475 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Pr\u00e9fixe rue","Text to print before name of street, but to ignore for sorting.") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Pr\u00e9fixe rue</span>", "name": "street_prefix", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var street476 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Rue","Name of street. Without house number.") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Rue</span>", "name": "street", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var street_no477 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("N\u00b0","House number") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">N\u00b0</span>", "name": "street_no", "maxLength": 10, "selectOnFocus": true, "boxMinWidth": Lino.chars2width(10), "anchor": "-20" });
    var street_box478 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("bo\u00eete","Text to print after :attr:`steet_no` on the same line") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">bo\u00eete</span>", "name": "street_box", "maxLength": 10, "selectOnFocus": true, "boxMinWidth": Lino.chars2width(10), "anchor": "-20" });
    var address_box_4_panel479 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 30, "autoHeight": true, "layout": "form", "xtype": "panel", "items": street_prefix475, "labelAlign": "top" }, { "flex": 36, "autoHeight": true, "layout": "form", "xtype": "panel", "items": street476, "labelAlign": "top" }, { "flex": 16, "autoHeight": true, "layout": "form", "xtype": "panel", "items": street_no477, "labelAlign": "top" }, { "flex": 16, "autoHeight": true, "layout": "form", "xtype": "panel", "items": street_box478, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 108, "border": false, "anchor": "-20", "labelAlign": "top" });
    var addr2484 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Ligne apr\u00e8s le nom de rue","Address line to print below street line") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Ligne apr\u00e8s le nom de rue</span>", "name": "addr2", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var address_box_panel485 = new Ext.form.FieldSet({ "flex": 66, "autoHeight": true, "layout": "form", "title": "Addresse", "items": [ { "autoHeight": true, "layout": "form", "xtype": "panel", "items": name464, "anchor": "-20", "labelAlign": "top" }, address_box_2_panel469, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": addr1474, "anchor": "-20", "labelAlign": "top" }, address_box_4_panel479, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": addr2484, "anchor": "-20", "labelAlign": "top" } ], "frame": true, "bodyBorder": false, "autoScroll": false, "hideCheckBoxLabels": true, "labelWidth": 234, "border": false, "labelAlign": "top" });
    var id489 = new Ext.form.NumberField({ "selectOnFocus": true, "fieldLabel": "ID", "anchor": "-20", "name": "id" });
    var language490 = new Lino.ChoicesFieldElement({ "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Langue</span>", "allowBlank": false, "value": "de", "hiddenName": "languageHidden", "listeners": { "render": Lino.quicktip_renderer("Langue","Die Sprache, in der Dokumente ausgestellt werden sollen.") }, "selectOnFocus": true, "anchor": "-20", "store": [ [ "de", "German" ], [ "fr", "French" ], [ "nl", "Dutch" ] ], "name": "language" });
    var info_box_panel491 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 20, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id489, "labelAlign": "top" }, { "flex": 80, "autoHeight": true, "layout": "form", "xtype": "panel", "items": language490, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 63, "border": false, "anchor": "-20", "labelAlign": "top" });
    var email494 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 75, "fieldLabel": "E-mail", "anchor": "-20", "name": "email" });
    var url495 = new Lino.URLField({ "selectOnFocus": true, "maxLength": 200, "fieldLabel": "URL", "anchor": "-20", "name": "url" });
    var phone496 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200, "fieldLabel": "T\u00e9l\u00e9phone", "anchor": "-20", "name": "phone" });
    var gsm497 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200, "fieldLabel": "GSM", "anchor": "-20", "name": "gsm" });
    var fax498 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200, "fieldLabel": "Fax", "anchor": "-20", "name": "fax" });
    var contact_box_5_panel499 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": gsm497, "labelAlign": "top" }, { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": fax498, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 36, "border": false, "anchor": "-20", "labelAlign": "top" });
    var contact_box_panel502 = new Ext.form.FieldSet({ "flex": 33, "autoHeight": true, "layout": "form", "title": "Contact", "items": [ info_box_panel491, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": email494, "anchor": "-20", "labelAlign": "top" }, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": url495, "anchor": "-20", "labelAlign": "top" }, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": phone496, "anchor": "-20", "labelAlign": "top" }, contact_box_5_panel499 ], "frame": true, "bodyBorder": false, "autoScroll": false, "hideCheckBoxLabels": true, "labelWidth": 90, "border": false, "labelAlign": "top" });
    var general_1_panel506 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "hideCheckBoxLabels": true, "items": [ address_box_panel485, contact_box_panel502 ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var remarks507 = new Ext.form.TextArea({ "selectOnFocus": true, "fieldLabel": "Remarques", "anchor": "-20 -10", "growMax": 2000, "name": "remarks" });
    var activity508 = new Lino.RemoteComboFieldElement({ "fieldLabel": "Activit\u00e9", "name": "activity", "pageSize": 20, "emptyText": "Choisir Activit\u00e9...", "selectOnFocus": true, "hiddenName": "activityHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/contacts/Partners/activity", "method": "GET" }) }) });
    var bank_account1509 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 40, "fieldLabel": "Compte en banque 1", "anchor": "-20", "name": "bank_account1" });
    var bank_account2510 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 40, "fieldLabel": "Compte en banque 2", "anchor": "-20", "name": "bank_account2" });
    var is_obsolete511 = new Ext.form.Checkbox({ "boxLabel": "obsolete", "listeners": { "render": Lino.quicktip_renderer("obsolete","Altf\u00e4lle sind Partner, deren Stammdaten nicht mehr gepflegt werden und \nf\u00fcr neue Operationen nicht benutzt werden k\u00f6nnen.") }, "hideLabel": true, "checked": false, "name": "is_obsolete", "selectOnFocus": true, "anchor": "-20" });
    var bottom_box_2_panel512 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 171, "hideCheckBoxLabels": true, "items": [ { "flex": 27, "autoHeight": true, "layout": "form", "xtype": "panel", "items": activity508, "labelAlign": "top" }, { "flex": 29, "autoHeight": true, "layout": "form", "xtype": "panel", "items": bank_account1509, "labelAlign": "top" }, { "flex": 29, "autoHeight": true, "layout": "form", "xtype": "panel", "items": bank_account2510, "labelAlign": "top" }, { "flex": 13, "autoHeight": true, "layout": "form", "xtype": "panel", "items": is_obsolete511, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var is_person517 = new Ext.form.Checkbox({ "boxLabel": "est une Personne (<a href=\"javascript:Lino.show_mti_child('is_person',Lino.contacts.Persons.detail)\">montrer</a>)", "listeners": { "render": Lino.quicktip_renderer("est une Personne","Si ce partenaire est \u00e9galement une personne.") }, "hideLabel": true, "name": "is_person", "selectOnFocus": true, "anchor": "-20" });
    var is_company518 = new Ext.form.Checkbox({ "boxLabel": "est une Organisation (<a href=\"javascript:Lino.show_mti_child('is_company',Lino.contacts.Companies.detail)\">montrer</a>)", "listeners": { "render": Lino.quicktip_renderer("est une Organisation","Si ce partenaire est \u00e9galement une organisation.") }, "hideLabel": true, "name": "is_company", "selectOnFocus": true, "anchor": "-20" });
    var is_household519 = new Ext.form.Checkbox({ "selectOnFocus": true, "boxLabel": "est un m\u00e9nage (<a href=\"javascript:Lino.show_mti_child('is_household',Lino.households.Households.detail)\">montrer</a>)", "hideLabel": true, "anchor": "-20", "name": "is_household" });
    var created520 = new Ext.form.DisplayField({ "disabled": true, "fieldLabel": "Cr\u00e9\u00e9", "anchor": "-20", "value": "<br>", "name": "created" });
    var modified521 = new Ext.form.DisplayField({ "disabled": true, "fieldLabel": "Modified", "anchor": "-20", "value": "<br>", "name": "modified" });
    var bottom_box_3_panel522 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 189, "hideCheckBoxLabels": true, "items": [ { "flex": 16, "autoHeight": true, "layout": "form", "xtype": "panel", "items": is_person517, "labelAlign": "top" }, { "flex": 16, "autoHeight": true, "layout": "form", "xtype": "panel", "items": is_company518, "labelAlign": "top" }, { "flex": 16, "autoHeight": true, "layout": "form", "xtype": "panel", "items": is_household519, "labelAlign": "top" }, { "flex": 25, "autoHeight": true, "layout": "form", "xtype": "panel", "items": created520, "labelAlign": "top" }, { "flex": 25, "autoHeight": true, "layout": "form", "xtype": "panel", "items": modified521, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var bottom_box_panel528 = new Ext.Panel({ "flex": 58, "layout": "vbox", "items": [ { "items": remarks507, "labelAlign": "top", "layout": "form", "xtype": "panel", "flex": 71 }, bottom_box_2_panel512, bottom_box_3_panel522 ], "frame": true, "layoutConfig": { "align": "stretch" }, "autoScroll": false, "hideCheckBoxLabels": true, "labelWidth": 90, "border": false, "bodyBorder": false, "labelAlign": "top" });
    var general_panel530 = new Ext.Panel({ "layout": "vbox", "title": "G\u00e9n\u00e9ral", "items": [ general_1_panel506, bottom_box_panel528 ], "frame": true, "layoutConfig": { "align": "stretch" }, "hideCheckBoxLabels": true, "listeners": { "activate": Lino.on_tab_activate }, "autoScroll": false, "border": false, "bodyBorder": false, "labelAlign": "top" });
    var changes_ChangesByMaster_grid539 = new Lino.changes.ChangesByMaster.GridPanel({ "listeners": { "activate": Lino.on_tab_activate }, "hide_top_toolbar": true, "title": "Changes", "containing_panel": this, "tools": [ Lino.show_in_own_window_button(Lino.changes.ChangesByMaster.grid) ], "master_panel": this });
    var debts_BudgetsByPartner_grid644 = new Lino.debts.BudgetsByPartner.GridPanel({ "flex": 5, "hide_top_toolbar": true, "split": true, "containing_panel": this, "region": "north", "tools": [ Lino.show_in_own_window_button(Lino.debts.BudgetsByPartner.grid) ], "master_panel": this });
    var debts_ActorsByPartner_grid652 = new Lino.debts.ActorsByPartner.GridPanel({ "flex": 5, "hide_top_toolbar": true, "split": true, "containing_panel": this, "region": "center", "tools": [ Lino.show_in_own_window_button(Lino.debts.ActorsByPartner.grid) ], "master_panel": this });
    var debts_panel653 = new Lino.VBorderPanel({ "autoScroll": false, "listeners": { "activate": Lino.on_tab_activate }, "border": false, "title": "M\u00e9diation de dettes", "hideCheckBoxLabels": true, "items": [ debts_BudgetsByPartner_grid644, debts_ActorsByPartner_grid652 ], "frame": true, "bodyBorder": false, "labelAlign": "top" });
    var main_panel654 = new Ext.TabPanel({ "hideCheckBoxLabels": true, "border": false, "split": true, "autoScroll": false, "items": [ general_panel530, changes_ChangesByMaster_grid539, debts_panel653 ], "activeTab": 0, "bodyBorder": false, "frame": true, "labelAlign": "top" });
    this.items = main_panel654;
    this.before_row_edit = function(record) {
      region466.setContextValue('country',record ? record.data['countryHidden'] : undefined);
      city467.setContextValue('country',record ? record.data['countryHidden'] : undefined);
      city467.setContextValue('region',record ? record.data['regionHidden'] : undefined);
      changes_ChangesByMaster_grid539.on_master_changed();
      debts_BudgetsByPartner_grid644.on_master_changed();
      debts_ActorsByPartner_grid652.on_master_changed();
    }
    this.onRender = function(ct, position) {
      country465.on('change',Lino.chooser_handler(region466,'country'));
      country465.on('change',Lino.chooser_handler(city467,'country'));
      region466.on('change',Lino.chooser_handler(city467,'region'));
      Lino.contacts.Partners.DetailFormPanel.superclass.onRender.call(this, ct, position);
    }
    Lino.contacts.Partners.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.newcomers.Faculties.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 82,
  initComponent : function() {
    var containing_panel = this;
    var id2981 = new Ext.form.NumberField({ "selectOnFocus": true, "fieldLabel": "ID", "anchor": "-20", "name": "id" });
    var name2982 = new Ext.form.TextField({ "fieldLabel": "Description", "name": "name", "maxLength": 200, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var name_fr2983 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200, "fieldLabel": "Description (fr)", "anchor": "-20", "name": "name_fr" });
    var name_nl2984 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200, "fieldLabel": "Description (nl)", "anchor": "-20", "name": "name_nl" });
    var weight2985 = new Ext.form.NumberField({ "listeners": { "render": Lino.quicktip_renderer("Work effort","Wieviel Aufwand ein Neuantrag in diesem Fachbereich allgemein verursacht\n(0 = gar kein Aufwand, 10 = maximaler Aufwand).") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Work effort</span>", "name": "weight", "selectOnFocus": true, "anchor": "-20", "value": 10, "allowBlank": false });
    var main_1_panel2986 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 6, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id2981, "labelAlign": "top" }, { "flex": 28, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name2982, "labelAlign": "top" }, { "flex": 28, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_fr2983, "labelAlign": "top" }, { "flex": 28, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_nl2984, "labelAlign": "top" }, { "flex": 6, "autoHeight": true, "layout": "form", "xtype": "panel", "items": weight2985, "labelAlign": "top" } ], "region": "north", "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "split": true, "autoScroll": false, "labelWidth": 153, "border": false, "frame": false, "labelAlign": "top" });
    var CompetencesByFaculty_grid2997 = new Lino.newcomers.CompetencesByFaculty.GridPanel({ "flex": 5, "hide_top_toolbar": true, "split": true, "containing_panel": this, "region": "center", "tools": [ Lino.show_in_own_window_button(Lino.newcomers.CompetencesByFaculty.grid) ], "master_panel": this });
    var ClientsByFaculty_grid3071 = new Lino.newcomers.ClientsByFaculty.GridPanel({ "flex": 5, "hide_top_toolbar": true, "containing_panel": this, "region": "south", "params_panel_hidden": true, "master_panel": this, "split": true, "tools": [ Lino.show_in_own_window_button(Lino.newcomers.ClientsByFaculty.grid) ] });
    var main_panel3072 = new Lino.VBorderPanel({ "autoScroll": false, "border": false, "hideCheckBoxLabels": true, "items": [ main_1_panel2986, CompetencesByFaculty_grid2997, ClientsByFaculty_grid3071 ], "frame": true, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel3072;
    this.before_row_edit = function(record) {
      CompetencesByFaculty_grid2997.on_master_changed();
      ClientsByFaculty_grid3071.on_master_changed();
    }
    Lino.newcomers.Faculties.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.users.Users.InsertFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  autoHeight: true,
  content_type: 7,
  initComponent : function() {
    var containing_panel = this;
    var username318 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Username","\n        Required. Must be unique. \n        ") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Username</span>", "name": "username", "maxLength": 30, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var email319 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 75, "fieldLabel": "adresse e-mail", "anchor": "-20", "name": "email" });
    var main_1_panel320 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": username318, "labelAlign": "top" }, { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": email319, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 135, "border": false, "anchor": "-20", "labelAlign": "top" });
    var first_name323 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 30, "fieldLabel": "Pr\u00e9nom", "anchor": "-20", "name": "first_name" });
    var last_name324 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 30, "fieldLabel": "Nom de famille", "anchor": "-20", "name": "last_name" });
    var main_2_panel325 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": first_name323, "labelAlign": "top" }, { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": last_name324, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 135, "border": false, "anchor": "-20", "labelAlign": "top" });
    var partner328 = new Lino.TwinCombo({ "fieldLabel": "Partenaire", "name": "partner", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.contacts.Partners.detail)}, "emptyText": "Choisir Partenaire...", "selectOnFocus": true, "hiddenName": "partnerHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/users/Users/partner", "method": "GET" }) }) });
    var language329 = new Lino.ChoicesFieldElement({ "fieldLabel": "Langue", "allowBlank": false, "selectOnFocus": true, "hiddenName": "languageHidden", "anchor": "-20", "store": [ [ "de", "German" ], [ "fr", "French" ], [ "nl", "Dutch" ] ], "name": "language" });
    var profile330 = new Lino.ChoicesFieldElement({ "forceSelection": true, "fieldLabel": "User Profile", "name": "profile", "selectOnFocus": true, "anchor": "-20", "store": Lino.lino.UserProfiles, "hiddenName": "profileHidden" });
    var main_4_panel331 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 30, "autoHeight": true, "layout": "form", "xtype": "panel", "items": language329, "labelAlign": "top" }, { "flex": 69, "autoHeight": true, "layout": "form", "xtype": "panel", "items": profile330, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 117, "border": false, "anchor": "-20", "labelAlign": "top" });
    var main_panel334 = new Ext.Panel({ "hideCheckBoxLabels": true, "autoHeight": true, "border": false, "layout": "form", "labelWidth": 99, "autoScroll": false, "items": [ main_1_panel320, main_2_panel325, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": partner328, "anchor": "-20", "labelAlign": "top" }, main_4_panel331 ], "frame": true, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel334;
    this.before_row_edit = function(record) {
    }
    Lino.users.Users.InsertFormPanel.superclass.initComponent.call(this);
  }
});


Lino.contacts.Partners.InsertFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  autoHeight: true,
  content_type: 23,
  initComponent : function() {
    var containing_panel = this;
    var name655 = new Ext.form.TextField({ "fieldLabel": "Name", "name": "name", "maxLength": 200, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var language656 = new Lino.ChoicesFieldElement({ "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Langue</span>", "allowBlank": false, "value": "de", "hiddenName": "languageHidden", "listeners": { "render": Lino.quicktip_renderer("Langue","Die Sprache, in der Dokumente ausgestellt werden sollen.") }, "selectOnFocus": true, "anchor": "-20", "store": [ [ "de", "German" ], [ "fr", "French" ], [ "nl", "Dutch" ] ], "name": "language" });
    var email657 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 75, "fieldLabel": "E-mail", "anchor": "-20", "name": "email" });
    var main_2_panel658 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 48, "autoHeight": true, "layout": "form", "xtype": "panel", "items": language656, "labelAlign": "top" }, { "flex": 51, "autoHeight": true, "layout": "form", "xtype": "panel", "items": email657, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 63, "border": false, "anchor": "-20", "labelAlign": "top" });
    var main_panel661 = new Ext.Panel({ "hideCheckBoxLabels": true, "autoHeight": true, "border": false, "layout": "form", "labelWidth": 45, "autoScroll": false, "items": [ { "autoHeight": true, "layout": "form", "xtype": "panel", "items": name655, "anchor": "-20", "labelAlign": "top" }, main_2_panel658 ], "frame": true, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel661;
    this.before_row_edit = function(record) {
    }
    Lino.contacts.Partners.InsertFormPanel.superclass.initComponent.call(this);
  }
});


Lino.households.Roles.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 40,
  initComponent : function() {
    var containing_panel = this;
    var name1323 = new Ext.form.TextField({ "fieldLabel": "Description", "name": "name", "maxLength": 200, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var name_fr1324 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200, "fieldLabel": "Description (fr)", "anchor": "-20", "name": "name_fr" });
    var name_nl1325 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200, "fieldLabel": "Description (nl)", "anchor": "-20", "name": "name_nl" });
    var name_giving1326 = new Ext.form.Checkbox({ "boxLabel": "donneur de nom", "listeners": { "render": Lino.quicktip_renderer("donneur de nom","When the `name` field of a Household is empty, \nits value is computed by joining the `Last Name` \nof all name-giving members with a dash (\"-\").\n      ") }, "hideLabel": true, "checked": false, "name": "name_giving", "selectOnFocus": true, "anchor": "-20" });
    var main_1_panel1327 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 153, "hideCheckBoxLabels": true, "items": [ { "flex": 28, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name1323, "labelAlign": "top" }, { "flex": 28, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_fr1324, "labelAlign": "top" }, { "flex": 28, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_nl1325, "labelAlign": "top" }, { "flex": 13, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_giving1326, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var MembersByRole_grid1338 = new Lino.households.MembersByRole.GridPanel({ "tools": [ Lino.show_in_own_window_button(Lino.households.MembersByRole.grid) ], "containing_panel": this, "hide_top_toolbar": true, "master_panel": this, "flex": 83 });
    var main_panel1339 = new Ext.Panel({ "autoScroll": false, "border": false, "layout": "vbox", "hideCheckBoxLabels": true, "items": [ main_1_panel1327, MembersByRole_grid1338 ], "frame": true, "layoutConfig": { "align": "stretch" }, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel1339;
    this.before_row_edit = function(record) {
      MembersByRole_grid1338.on_master_changed();
    }
    Lino.households.Roles.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.outbox.Mails.InsertFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 27,
  initComponent : function() {
    var containing_panel = this;
    var project891 = new Lino.TwinCombo({ "fieldLabel": "Client", "name": "project", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.pcsw.Clients.detail)}, "emptyText": "Choisir Client...", "selectOnFocus": true, "hiddenName": "projectHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/outbox/Mails/project", "method": "GET" }) }) });
    var subject892 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200, "fieldLabel": "Subject", "anchor": "-20", "name": "subject" });
    var body893 = new Lino.RichTextPanel({ "selectOnFocus": true, "flex": 71, "containing_panel": this, "name": "body", "title": "Body" });
    var main_panel894 = new Ext.Panel({ "autoScroll": false, "border": false, "layout": "vbox", "labelWidth": 72, "hideCheckBoxLabels": true, "items": [ { "items": project891, "autoHeight": true, "layout": "form", "xtype": "panel", "labelAlign": "top" }, { "items": subject892, "autoHeight": true, "layout": "form", "xtype": "panel", "labelAlign": "top" }, body893 ], "frame": true, "layoutConfig": { "align": "stretch" }, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel894;
    this.before_row_edit = function(record) {
      body893.refresh();
    }
    Lino.outbox.Mails.InsertFormPanel.superclass.initComponent.call(this);
  }
});


Lino.courses.Courses.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 76,
  initComponent : function() {
    var containing_panel = this;
    var id2899 = new Ext.form.NumberField({ "selectOnFocus": true, "fieldLabel": "ID", "anchor": "-20", "name": "id" });
    var start_date2900 = new Lino.DateField({ "selectOnFocus": true, "allowBlank": false, "fieldLabel": "Date de d\u00e9but", "anchor": "-20", "name": "start_date" });
    var offer2901 = new Lino.TwinCombo({ "fieldLabel": "Offre de cours", "allowBlank": false, "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.courses.CourseOffers.detail)}, "emptyText": "Choisir Offre de cours...", "selectOnFocus": true, "hiddenName": "offerHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/courses/Courses/offer", "method": "GET" }) }), "name": "offer" });
    var title2902 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200, "fieldLabel": "Name", "anchor": "-20", "name": "title" });
    var main_1_panel2903 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 135, "hideCheckBoxLabels": true, "items": [ { "flex": 14, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id2899, "labelAlign": "top" }, { "flex": 14, "autoHeight": true, "layout": "form", "xtype": "panel", "items": start_date2900, "labelAlign": "top" }, { "flex": 35, "autoHeight": true, "layout": "form", "xtype": "panel", "items": offer2901, "labelAlign": "top" }, { "flex": 36, "autoHeight": true, "layout": "form", "xtype": "panel", "items": title2902, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var remark2908 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200, "fieldLabel": "Remarque", "anchor": "-20", "name": "remark" });
    var courses_ParticipantsByCourse_grid2914 = new Lino.courses.ParticipantsByCourse.GridPanel({ "tools": [ Lino.show_in_own_window_button(Lino.courses.ParticipantsByCourse.grid) ], "containing_panel": this, "hide_top_toolbar": true, "master_panel": this, "flex": 41 });
    var courses_CandidatesByCourse_grid2921 = new Lino.courses.CandidatesByCourse.GridPanel({ "tools": [ Lino.show_in_own_window_button(Lino.courses.CandidatesByCourse.grid) ], "containing_panel": this, "hide_top_toolbar": true, "master_panel": this, "flex": 41 });
    var main_panel2922 = new Ext.Panel({ "autoScroll": false, "border": false, "layout": "vbox", "labelWidth": 81, "hideCheckBoxLabels": true, "items": [ main_1_panel2903, { "items": remark2908, "autoHeight": true, "layout": "form", "xtype": "panel", "labelAlign": "top" }, courses_ParticipantsByCourse_grid2914, courses_CandidatesByCourse_grid2921 ], "frame": true, "layoutConfig": { "align": "stretch" }, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel2922;
    this.before_row_edit = function(record) {
      courses_ParticipantsByCourse_grid2914.on_master_changed();
      courses_CandidatesByCourse_grid2921.on_master_changed();
    }
    Lino.courses.Courses.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.cal.Calendars.InsertFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  autoHeight: true,
  content_type: 35,
  initComponent : function() {
    var containing_panel = this;
    var name1110 = new Ext.form.TextField({ "fieldLabel": "Description", "name": "name", "maxLength": 200, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var name_fr1111 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200, "fieldLabel": "Description (fr)", "anchor": "-20", "name": "name_fr" });
    var name_nl1112 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200, "fieldLabel": "Description (nl)", "anchor": "-20", "name": "name_nl" });
    var main_1_panel1113 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name1110, "labelAlign": "top" }, { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_fr1111, "labelAlign": "top" }, { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_nl1112, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 153, "border": false, "anchor": "-20", "labelAlign": "top" });
    var type1117 = new Lino.ChoicesFieldElement({ "fieldLabel": "Type", "allowBlank": false, "value": "local", "hiddenName": "typeHidden", "selectOnFocus": true, "anchor": "-20", "store": [ [ "local", "Local Calendar" ], [ "google", "Google Calendar" ] ], "name": "type" });
    var invite_team_members1118 = new Lino.RemoteComboFieldElement({ "fieldLabel": "Team", "name": "invite_team_members", "pageSize": 20, "emptyText": "Choisir Team...", "selectOnFocus": true, "hiddenName": "invite_team_membersHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/Calendars/invite_team_members", "method": "GET" }) }) });
    var color1119 = new Ext.form.NumberField({ "fieldLabel": "Couleur", "name": "color", "selectOnFocus": true, "anchor": "-20", "value": 1, "allowBlank": false });
    var main_2_panel1120 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 44, "autoHeight": true, "layout": "form", "xtype": "panel", "items": type1117, "labelAlign": "top" }, { "flex": 44, "autoHeight": true, "layout": "form", "xtype": "panel", "items": invite_team_members1118, "labelAlign": "top" }, { "flex": 11, "autoHeight": true, "layout": "form", "xtype": "panel", "items": color1119, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 72, "border": false, "anchor": "-20", "labelAlign": "top" });
    var main_panel1124 = new Ext.Panel({ "hideCheckBoxLabels": true, "autoHeight": true, "border": false, "layout": "form", "autoScroll": false, "items": [ main_1_panel1113, main_2_panel1120 ], "frame": true, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel1124;
    this.before_row_edit = function(record) {
    }
    Lino.cal.Calendars.InsertFormPanel.superclass.initComponent.call(this);
  }
});


Lino.jobs.Contracts.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 67,
  initComponent : function() {
    var containing_panel = this;
    var id1998 = new Ext.form.NumberField({ "selectOnFocus": true, "fieldLabel": "ID", "anchor": "-20", "name": "id" });
    var client1999 = new Lino.TwinCombo({ "fieldLabel": "Client", "allowBlank": false, "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.pcsw.Clients.detail)}, "emptyText": "Choisir Client...", "selectOnFocus": true, "hiddenName": "clientHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/jobs/Contracts/client", "method": "GET" }) }), "name": "client" });
    var user2000 = new Lino.TwinCombo({ "fieldLabel": "Auteur", "name": "user", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.users.Users.detail)}, "emptyText": "Choisir Utilisateur...", "selectOnFocus": true, "hiddenName": "userHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/jobs/Contracts/user", "method": "GET" }) }) });
    var user_asd2001 = new Lino.TwinCombo({ "fieldLabel": "Responsable (SSG)", "name": "user_asd", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.users.Users.detail)}, "emptyText": "Choisir Utilisateur...", "selectOnFocus": true, "hiddenName": "user_asdHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/jobs/Contracts/user_asd", "method": "GET" }) }) });
    var language2002 = new Lino.ChoicesFieldElement({ "fieldLabel": "Langue", "allowBlank": false, "value": "de", "hiddenName": "languageHidden", "selectOnFocus": true, "anchor": "-20", "store": [ [ "de", "German" ], [ "fr", "French" ], [ "nl", "Dutch" ] ], "name": "language" });
    var box1_1_panel2003 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 162, "hideCheckBoxLabels": true, "items": [ { "flex": 11, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id1998, "labelAlign": "top" }, { "flex": 35, "autoHeight": true, "layout": "form", "xtype": "panel", "items": client1999, "labelAlign": "top" }, { "flex": 21, "autoHeight": true, "layout": "form", "xtype": "panel", "items": user2000, "labelAlign": "top" }, { "flex": 21, "autoHeight": true, "layout": "form", "xtype": "panel", "items": user_asd2001, "labelAlign": "top" }, { "flex": 11, "autoHeight": true, "layout": "form", "xtype": "panel", "items": language2002, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var job2009 = new Lino.TwinCombo({ "fieldLabel": "Emploi", "allowBlank": false, "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.jobs.Jobs.detail)}, "emptyText": "Choisir Emploi...", "selectOnFocus": true, "hiddenName": "jobHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/jobs/Contracts/job", "method": "GET" }) }), "name": "job" });
    var type2010 = new Lino.TwinCombo({ "fieldLabel": "Type de contrat", "name": "type", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.jobs.ContractTypes.detail)}, "emptyText": "Choisir Type de contrat de travail...", "selectOnFocus": true, "hiddenName": "typeHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/jobs/Contracts/type", "method": "GET" }) }) });
    var company2011 = new Lino.TwinCombo({ "fieldLabel": "Organisation", "name": "company", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.contacts.Companies.detail)}, "emptyText": "Choisir Organisation...", "selectOnFocus": true, "hiddenName": "companyHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/jobs/Contracts/company", "method": "GET" }) }) });
    var contact_person2012 = new Lino.TwinCombo({ "fieldLabel": "repr\u00e9sent\u00e9 par", "name": "contact_person", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.contacts.Persons.detail)}, "emptyText": "Choisir Personne...", "selectOnFocus": true, "hiddenName": "contact_personHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/jobs/Contracts/contact_person", "method": "GET" }) }) });
    var contact_role2013 = new Lino.RemoteComboFieldElement({ "fieldLabel": "repr\u00e9sent\u00e9 par", "name": "contact_role", "pageSize": 20, "emptyText": "Choisir Fonction...", "selectOnFocus": true, "hiddenName": "contact_roleHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/jobs/Contracts/contact_role", "method": "GET" }) }) });
    var box1_2_panel2014 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 144, "hideCheckBoxLabels": true, "items": [ { "flex": 20, "autoHeight": true, "layout": "form", "xtype": "panel", "items": job2009, "labelAlign": "top" }, { "flex": 20, "autoHeight": true, "layout": "form", "xtype": "panel", "items": type2010, "labelAlign": "top" }, { "flex": 20, "autoHeight": true, "layout": "form", "xtype": "panel", "items": company2011, "labelAlign": "top" }, { "flex": 20, "autoHeight": true, "layout": "form", "xtype": "panel", "items": contact_person2012, "labelAlign": "top" }, { "flex": 20, "autoHeight": true, "layout": "form", "xtype": "panel", "items": contact_role2013, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var applies_from2020 = new Lino.DateField({ "selectOnFocus": true, "fieldLabel": "D\u00e9but de contrat", "anchor": "-20", "name": "applies_from" });
    var duration2021 = new Lino.SimpleRemoteComboFieldElement({ "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/jobs/Contracts/duration", "method": "GET" }) }), "fieldLabel": "dur\u00e9e (jours)", "name": "duration", "selectOnFocus": true, "anchor": "-20", "value": null });
    var applies_until2022 = new Lino.DateField({ "selectOnFocus": true, "fieldLabel": "Fin pr\u00e9vue", "anchor": "-20", "name": "applies_until" });
    var exam_policy2023 = new Lino.TwinCombo({ "fieldLabel": "M\u00e9thode d'examination", "name": "exam_policy", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.isip.ExamPolicies.detail)}, "emptyText": "Choisir M\u00e9thode d'examination...", "selectOnFocus": true, "hiddenName": "exam_policyHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/jobs/Contracts/exam_policy", "method": "GET" }) }) });
    var box1_3_panel2024 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 198, "hideCheckBoxLabels": true, "items": [ { "flex": 17, "autoHeight": true, "layout": "form", "xtype": "panel", "items": applies_from2020, "labelAlign": "top" }, { "flex": 21, "autoHeight": true, "layout": "form", "xtype": "panel", "items": duration2021, "labelAlign": "top" }, { "flex": 17, "autoHeight": true, "layout": "form", "xtype": "panel", "items": applies_until2022, "labelAlign": "top" }, { "flex": 43, "autoHeight": true, "layout": "form", "xtype": "panel", "items": exam_policy2023, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var regime2029 = new Lino.TwinCombo({ "fieldLabel": "R\u00e9gime de travail", "name": "regime", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.jobs.Regimes.detail)}, "emptyText": "Choisir R\u00e9gime de travail...", "selectOnFocus": true, "hiddenName": "regimeHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/jobs/Contracts/regime", "method": "GET" }) }) });
    var schedule2030 = new Lino.TwinCombo({ "fieldLabel": "Horaire", "name": "schedule", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.jobs.Schedules.detail)}, "emptyText": "Choisir Horaire...", "selectOnFocus": true, "hiddenName": "scheduleHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/jobs/Contracts/schedule", "method": "GET" }) }) });
    var hourly_rate2031 = new Ext.form.NumberField({ "decimalPrecision": 2, "fieldLabel": "co\u00fbr horaire", "name": "hourly_rate", "decimalSeparator": ",", "selectOnFocus": true, "anchor": "-20", "allowBlank": true });
    var refund_rate2032 = new Lino.SimpleRemoteComboFieldElement({ "selectOnFocus": true, "fieldLabel": "tarif de remboursement", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/jobs/Contracts/refund_rate", "method": "GET" }) }), "name": "refund_rate" });
    var box1_4_panel2033 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 207, "hideCheckBoxLabels": true, "items": [ { "flex": 28, "autoHeight": true, "layout": "form", "xtype": "panel", "items": regime2029, "labelAlign": "top" }, { "flex": 42, "autoHeight": true, "layout": "form", "xtype": "panel", "items": schedule2030, "labelAlign": "top" }, { "flex": 14, "autoHeight": true, "layout": "form", "xtype": "panel", "items": hourly_rate2031, "labelAlign": "top" }, { "flex": 14, "autoHeight": true, "layout": "form", "xtype": "panel", "items": refund_rate2032, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var reference_person2038 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200, "fieldLabel": "persone de r\u00e9f\u00e9rence", "anchor": "-20", "name": "reference_person" });
    var build_time2039 = new Ext.form.DisplayField({ "disabled": true, "fieldLabel": "build time", "anchor": "-20", "value": "<br>", "name": "build_time" });
    var box1_5_panel2040 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 189, "hideCheckBoxLabels": true, "items": [ { "flex": 56, "autoHeight": true, "layout": "form", "xtype": "panel", "items": reference_person2038, "labelAlign": "top" }, { "flex": 43, "autoHeight": true, "layout": "form", "xtype": "panel", "items": build_time2039, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var date_decided2043 = new Lino.DateField({ "selectOnFocus": true, "fieldLabel": "D\u00e9cid\u00e9 le", "anchor": "-20", "name": "date_decided" });
    var date_issued2044 = new Lino.DateField({ "selectOnFocus": true, "fieldLabel": "D\u00e9livr\u00e9 le", "anchor": "-20", "name": "date_issued" });
    var date_ended2045 = new Lino.DateField({ "selectOnFocus": true, "fieldLabel": "Date de fin", "anchor": "-20", "name": "date_ended" });
    var ending2046 = new Lino.RemoteComboFieldElement({ "fieldLabel": "Cause d'abandon", "name": "ending", "pageSize": 20, "emptyText": "Choisir Cause d'abandon...", "selectOnFocus": true, "hiddenName": "endingHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/jobs/Contracts/ending", "method": "GET" }) }) });
    var box1_6_panel2047 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 144, "hideCheckBoxLabels": true, "items": [ { "flex": 18, "autoHeight": true, "layout": "form", "xtype": "panel", "items": date_decided2043, "labelAlign": "top" }, { "flex": 18, "autoHeight": true, "layout": "form", "xtype": "panel", "items": date_issued2044, "labelAlign": "top" }, { "flex": 18, "autoHeight": true, "layout": "form", "xtype": "panel", "items": date_ended2045, "labelAlign": "top" }, { "flex": 45, "autoHeight": true, "layout": "form", "xtype": "panel", "items": ending2046, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var responsibilities2052 = new Lino.RichTextPanel({ "selectOnFocus": true, "flex": 45, "containing_panel": this, "name": "responsibilities", "title": "responsabilit\u00e9s" });
    var box1_panel2053 = new Ext.Panel({ "flex": 70, "layout": "vbox", "items": [ box1_1_panel2003, box1_2_panel2014, box1_3_panel2024, box1_4_panel2033, box1_5_panel2040, box1_6_panel2047, responsibilities2052 ], "frame": true, "layoutConfig": { "align": "stretch" }, "autoScroll": false, "hideCheckBoxLabels": true, "labelWidth": 0, "border": false, "bodyBorder": false, "labelAlign": "top" });
    var cal_EventsByController_grid2054 = new Lino.cal.EventsByController.GridPanel({ "flex": 5, "hide_top_toolbar": true, "containing_panel": this, "region": "north", "params_panel_hidden": true, "master_panel": this, "split": true, "tools": [ Lino.show_in_own_window_button(Lino.cal.EventsByController.grid) ] });
    var cal_TasksByController_grid2055 = new Lino.cal.TasksByController.GridPanel({ "flex": 5, "hide_top_toolbar": true, "split": true, "containing_panel": this, "region": "center", "tools": [ Lino.show_in_own_window_button(Lino.cal.TasksByController.grid) ], "master_panel": this });
    var right_panel2056 = new Lino.VBorderPanel({ "flex": 30, "border": false, "hideCheckBoxLabels": true, "items": [ cal_EventsByController_grid2054, cal_TasksByController_grid2055 ], "frame": true, "autoScroll": false, "bodyBorder": false, "labelAlign": "top" });
    var main_1_panel2057 = new Ext.Panel({ "autoScroll": false, "border": false, "layout": "hbox", "hideCheckBoxLabels": true, "items": [ box1_panel2053, right_panel2056 ], "frame": false, "layoutConfig": { "align": "stretch" }, "labelAlign": "top" });
    var main_panel2058 = new Ext.Panel({ "autoScroll": false, "border": false, "layout": "fit", "hideCheckBoxLabels": true, "items": [ main_1_panel2057 ], "frame": true, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel2058;
    this.before_row_edit = function(record) {
      contact_person2012.setContextValue('company',record ? record.data['companyHidden'] : undefined);
      responsibilities2052.refresh();
      cal_EventsByController_grid2054.on_master_changed();
      cal_TasksByController_grid2055.on_master_changed();
    }
    this.onRender = function(ct, position) {
      company2011.on('change',Lino.chooser_handler(contact_person2012,'company'));
      Lino.jobs.Contracts.DetailFormPanel.superclass.onRender.call(this, ct, position);
    }
    Lino.jobs.Contracts.DetailFormPanel.superclass.initComponent.call(this);
    // active_fields:
    job2009.on("change",function(){this.save()},this);
    company2011.on("change",function(){this.save()},this);
    contact_person2012.on("change",function(){this.save()},this);
    contact_role2013.on("change",function(){this.save()},this);
  }
});


Lino.jobs.Regimes.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 74,
  initComponent : function() {
    var containing_panel = this;
    var id2441 = new Ext.form.NumberField({ "selectOnFocus": true, "fieldLabel": "ID", "anchor": "-20", "name": "id" });
    var name2442 = new Ext.form.TextField({ "fieldLabel": "Description", "name": "name", "maxLength": 200, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var name_fr2443 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200, "fieldLabel": "Description (fr)", "anchor": "-20", "name": "name_fr" });
    var name_nl2444 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200, "fieldLabel": "Description (nl)", "anchor": "-20", "name": "name_nl" });
    var main_1_panel2445 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 153, "hideCheckBoxLabels": true, "items": [ { "flex": 7, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id2441, "labelAlign": "top" }, { "flex": 30, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name2442, "labelAlign": "top" }, { "flex": 30, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_fr2443, "labelAlign": "top" }, { "flex": 30, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_nl2444, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var ContractsByRegime_grid2478 = new Lino.jobs.ContractsByRegime.GridPanel({ "flex": 83, "hide_top_toolbar": true, "containing_panel": this, "params_panel_hidden": true, "tools": [ Lino.show_in_own_window_button(Lino.jobs.ContractsByRegime.grid) ], "master_panel": this });
    var main_panel2479 = new Ext.Panel({ "autoScroll": false, "border": false, "layout": "vbox", "hideCheckBoxLabels": true, "items": [ main_1_panel2445, ContractsByRegime_grid2478 ], "frame": true, "layoutConfig": { "align": "stretch" }, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel2479;
    this.before_row_edit = function(record) {
      ContractsByRegime_grid2478.on_master_changed();
    }
    Lino.jobs.Regimes.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.properties.Properties.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 14,
  initComponent : function() {
    var containing_panel = this;
    var id127 = new Ext.form.NumberField({ "selectOnFocus": true, "fieldLabel": "ID", "anchor": "-20", "name": "id" });
    var group128 = new Lino.TwinCombo({ "fieldLabel": "Groupe de propri\u00e9t\u00e9s", "allowBlank": false, "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.properties.PropGroups.detail)}, "emptyText": "Choisir Groupe de propri\u00e9t\u00e9s...", "selectOnFocus": true, "hiddenName": "groupHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/properties/Properties/group", "method": "GET" }) }), "name": "group" });
    var type129 = new Lino.TwinCombo({ "fieldLabel": "Type de propri\u00e9t\u00e9", "allowBlank": false, "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.properties.PropTypes.detail)}, "emptyText": "Choisir Type de propri\u00e9t\u00e9...", "selectOnFocus": true, "hiddenName": "typeHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/properties/Properties/type", "method": "GET" }) }), "name": "type" });
    var main_1_panel130 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 189, "hideCheckBoxLabels": true, "items": [ { "flex": 11, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id127, "labelAlign": "top" }, { "flex": 44, "autoHeight": true, "layout": "form", "xtype": "panel", "items": group128, "labelAlign": "top" }, { "flex": 44, "autoHeight": true, "layout": "form", "xtype": "panel", "items": type129, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var name134 = new Ext.form.TextField({ "fieldLabel": "Description", "name": "name", "maxLength": 200, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var name_fr135 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200, "fieldLabel": "Description (fr)", "anchor": "-20", "name": "name_fr" });
    var name_nl136 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200, "fieldLabel": "Description (nl)", "anchor": "-20", "name": "name_nl" });
    var main_2_panel137 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 153, "hideCheckBoxLabels": true, "items": [ { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name134, "labelAlign": "top" }, { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_fr135, "labelAlign": "top" }, { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_nl136, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var cv_PersonPropsByProp_grid147 = new Lino.cv.PersonPropsByProp.GridPanel({ "tools": [ Lino.show_in_own_window_button(Lino.cv.PersonPropsByProp.grid) ], "containing_panel": this, "hide_top_toolbar": true, "master_panel": this, "flex": 71 });
    var main_panel148 = new Ext.Panel({ "autoScroll": false, "border": false, "layout": "vbox", "hideCheckBoxLabels": true, "items": [ main_1_panel130, main_2_panel137, cv_PersonPropsByProp_grid147 ], "frame": true, "layoutConfig": { "align": "stretch" }, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel148;
    this.before_row_edit = function(record) {
      cv_PersonPropsByProp_grid147.on_master_changed();
    }
    Lino.properties.Properties.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.cbss.IdentifyPersonRequests.InsertFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  autoHeight: true,
  content_type: 90,
  initComponent : function() {
    var containing_panel = this;
    var person3136 = new Lino.TwinCombo({ "fieldLabel": "Client", "allowBlank": false, "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.pcsw.Clients.detail)}, "emptyText": "Choisir Client...", "selectOnFocus": true, "hiddenName": "personHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cbss/IdentifyPersonRequests/person", "method": "GET" }) }), "name": "person" });
    var national_id3137 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200, "fieldLabel": "NISS", "anchor": "-20", "name": "national_id" });
    var main_1_panel3138 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 48, "autoHeight": true, "layout": "form", "xtype": "panel", "items": person3136, "labelAlign": "top" }, { "flex": 51, "autoHeight": true, "layout": "form", "xtype": "panel", "items": national_id3137, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 63, "border": false, "anchor": "-20", "labelAlign": "top" });
    var first_name3141 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200, "fieldLabel": "Pr\u00e9nom", "anchor": "-20", "name": "first_name" });
    var middle_name3142 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Middle name","Whatever this means...") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Middle name</span>", "name": "middle_name", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var last_name3143 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200, "fieldLabel": "Nom de famille", "anchor": "-20", "name": "last_name" });
    var p2_1_panel3144 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": first_name3141, "labelAlign": "top" }, { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": middle_name3142, "labelAlign": "top" }, { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": last_name3143, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 135, "border": false, "anchor": "-20", "labelAlign": "top" });
    var birth_date3148 = new Lino.IncompleteDateField({ "listeners": { "render": Lino.quicktip_renderer("date de naissance","Uncomplete dates are allowed, e.g. \n\"00.00.1980\" means \"some day in 1980\", \n\"00.07.1980\" means \"in July 1980\"\nor \"23.07.0000\" means \"on a 23th of July\".") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">date de naissance</span>", "name": "birth_date", "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var tolerance3149 = new Ext.form.NumberField({ "listeners": { "render": Lino.quicktip_renderer("Tol\u00e9rance","\n      Falls Monat oder Tag des Geburtsdatums unbekannt sind, \n      um wieviel Monate bzw. Tage die Suche nach unten/oben ausgeweitet wird.\n      G\u00fcltige Werte: 0 bis 10.\n      ") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Tol\u00e9rance</span>", "name": "tolerance", "selectOnFocus": true, "anchor": "-20", "value": 0, "allowBlank": false });
    var gender3150 = new Lino.ChoicesFieldElement({ "forceSelection": true, "fieldLabel": "Sexe", "name": "gender", "selectOnFocus": true, "anchor": "-20", "store": Lino.lino.Genders, "hiddenName": "genderHidden" });
    var p2_2_panel3151 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 46, "autoHeight": true, "layout": "form", "xtype": "panel", "items": birth_date3148, "labelAlign": "top" }, { "flex": 19, "autoHeight": true, "layout": "form", "xtype": "panel", "items": tolerance3149, "labelAlign": "top" }, { "flex": 34, "autoHeight": true, "layout": "form", "xtype": "panel", "items": gender3150, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 162, "border": false, "anchor": "-20", "labelAlign": "top" });
    var p2_panel3155 = new Ext.form.FieldSet({ "autoHeight": true, "layout": "form", "title": "Recherche phon\u00e9tique", "items": [ p2_1_panel3144, p2_2_panel3151 ], "frame": true, "bodyBorder": false, "autoScroll": false, "hideCheckBoxLabels": true, "border": false, "anchor": "-20", "labelAlign": "top" });
    var main_panel3156 = new Ext.Panel({ "hideCheckBoxLabels": true, "autoHeight": true, "border": false, "layout": "form", "autoScroll": false, "items": [ main_1_panel3138, p2_panel3155 ], "frame": true, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel3156;
    this.before_row_edit = function(record) {
    }
    Lino.cbss.IdentifyPersonRequests.InsertFormPanel.superclass.initComponent.call(this);
    // active_fields:
    person3136.on("change",function(){this.save()},this);
  }
});


Lino.jobs.Schedules.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 64,
  initComponent : function() {
    var containing_panel = this;
    var id2402 = new Ext.form.NumberField({ "selectOnFocus": true, "fieldLabel": "ID", "anchor": "-20", "name": "id" });
    var name2403 = new Ext.form.TextField({ "fieldLabel": "Description", "name": "name", "maxLength": 200, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var name_fr2404 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200, "fieldLabel": "Description (fr)", "anchor": "-20", "name": "name_fr" });
    var name_nl2405 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200, "fieldLabel": "Description (nl)", "anchor": "-20", "name": "name_nl" });
    var main_1_panel2406 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 153, "hideCheckBoxLabels": true, "items": [ { "flex": 7, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id2402, "labelAlign": "top" }, { "flex": 30, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name2403, "labelAlign": "top" }, { "flex": 30, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_fr2404, "labelAlign": "top" }, { "flex": 30, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_nl2405, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var ContractsBySchedule_grid2439 = new Lino.jobs.ContractsBySchedule.GridPanel({ "flex": 83, "hide_top_toolbar": true, "containing_panel": this, "params_panel_hidden": true, "tools": [ Lino.show_in_own_window_button(Lino.jobs.ContractsBySchedule.grid) ], "master_panel": this });
    var main_panel2440 = new Ext.Panel({ "autoScroll": false, "border": false, "layout": "vbox", "hideCheckBoxLabels": true, "items": [ main_1_panel2406, ContractsBySchedule_grid2439 ], "frame": true, "layoutConfig": { "align": "stretch" }, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel2440;
    this.before_row_edit = function(record) {
      ContractsBySchedule_grid2439.on_master_changed();
    }
    Lino.jobs.Schedules.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.jobs.Functions.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 62,
  initComponent : function() {
    var containing_panel = this;
    var id2711 = new Ext.form.NumberField({ "selectOnFocus": true, "fieldLabel": "ID", "anchor": "-20", "name": "id" });
    var name2712 = new Ext.form.TextField({ "fieldLabel": "Description", "name": "name", "maxLength": 200, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var name_fr2713 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200, "fieldLabel": "Description (fr)", "anchor": "-20", "name": "name_fr" });
    var name_nl2714 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200, "fieldLabel": "Description (nl)", "anchor": "-20", "name": "name_nl" });
    var sector2715 = new Lino.TwinCombo({ "fieldLabel": "Secteur d'activit\u00e9", "allowBlank": false, "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.jobs.Sectors.detail)}, "emptyText": "Choisir Secteur d'activit\u00e9...", "selectOnFocus": true, "hiddenName": "sectorHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/jobs/Functions/sector", "method": "GET" }) }), "name": "sector" });
    var main_1_panel2716 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 171, "hideCheckBoxLabels": true, "items": [ { "flex": 5, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id2711, "labelAlign": "top" }, { "flex": 23, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name2712, "labelAlign": "top" }, { "flex": 23, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_fr2713, "labelAlign": "top" }, { "flex": 23, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_nl2714, "labelAlign": "top" }, { "flex": 22, "autoHeight": true, "layout": "form", "xtype": "panel", "items": sector2715, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var remark2722 = new Ext.form.TextArea({ "selectOnFocus": true, "fieldLabel": "Remarque", "anchor": "-20 -10", "growMax": 2000, "name": "remark" });
    var CandidaturesByFunction_grid2731 = new Lino.jobs.CandidaturesByFunction.GridPanel({ "tools": [ Lino.show_in_own_window_button(Lino.jobs.CandidaturesByFunction.grid) ], "containing_panel": this, "hide_top_toolbar": true, "master_panel": this, "flex": 31 });
    var ExperiencesByFunction_grid2742 = new Lino.jobs.ExperiencesByFunction.GridPanel({ "tools": [ Lino.show_in_own_window_button(Lino.jobs.ExperiencesByFunction.grid) ], "containing_panel": this, "hide_top_toolbar": true, "master_panel": this, "flex": 31 });
    var main_panel2743 = new Ext.Panel({ "autoScroll": false, "border": false, "layout": "vbox", "labelWidth": 81, "hideCheckBoxLabels": true, "items": [ main_1_panel2716, { "items": remark2722, "labelAlign": "top", "layout": "form", "xtype": "panel", "flex": 31 }, CandidaturesByFunction_grid2731, ExperiencesByFunction_grid2742 ], "frame": true, "layoutConfig": { "align": "stretch" }, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel2743;
    this.before_row_edit = function(record) {
      CandidaturesByFunction_grid2731.on_master_changed();
      ExperiencesByFunction_grid2742.on_master_changed();
    }
    Lino.jobs.Functions.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.jobs.Offers.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 66,
  initComponent : function() {
    var containing_panel = this;
    var name2758 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 100, "fieldLabel": "Name", "anchor": "-20", "name": "name" });
    var provider2759 = new Lino.TwinCombo({ "fieldLabel": "Employant", "name": "provider", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.jobs.JobProviders.detail)}, "emptyText": "Choisir Employant...", "selectOnFocus": true, "hiddenName": "providerHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/jobs/Offers/provider", "method": "GET" }) }) });
    var sector2760 = new Lino.TwinCombo({ "fieldLabel": "Secteur d'activit\u00e9", "name": "sector", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.jobs.Sectors.detail)}, "emptyText": "Choisir Secteur d'activit\u00e9...", "selectOnFocus": true, "hiddenName": "sectorHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/jobs/Offers/sector", "method": "GET" }) }) });
    var function2761 = new Lino.TwinCombo({ "fieldLabel": "Fonction", "name": "function", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.jobs.Functions.detail)}, "emptyText": "Choisir Fonction...", "selectOnFocus": true, "hiddenName": "functionHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/jobs/Offers/function", "method": "GET" }) }) });
    var main_1_panel2762 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 171, "hideCheckBoxLabels": true, "items": [ { "flex": 25, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name2758, "labelAlign": "top" }, { "flex": 24, "autoHeight": true, "layout": "form", "xtype": "panel", "items": provider2759, "labelAlign": "top" }, { "flex": 24, "autoHeight": true, "layout": "form", "xtype": "panel", "items": sector2760, "labelAlign": "top" }, { "flex": 24, "autoHeight": true, "layout": "form", "xtype": "panel", "items": function2761, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var selection_from2767 = new Lino.DateField({ "selectOnFocus": true, "fieldLabel": "D\u00e9but de s\u00e9lection", "anchor": "-20", "name": "selection_from" });
    var selection_until2768 = new Lino.DateField({ "selectOnFocus": true, "fieldLabel": "Fin de s\u00e9lection", "anchor": "-20", "name": "selection_until" });
    var start_date2769 = new Lino.DateField({ "selectOnFocus": true, "fieldLabel": "Date de d\u00e9but", "anchor": "-20", "name": "start_date" });
    var main_2_panel2770 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 171, "hideCheckBoxLabels": true, "items": [ { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": selection_from2767, "labelAlign": "top" }, { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": selection_until2768, "labelAlign": "top" }, { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": start_date2769, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var remark2774 = new Ext.form.TextArea({ "selectOnFocus": true, "fieldLabel": "Remarque", "anchor": "-20 -10", "growMax": 2000, "name": "remark" });
    var ExperiencesByOffer_grid2786 = new Lino.jobs.ExperiencesByOffer.GridPanel({ "tools": [ Lino.show_in_own_window_button(Lino.jobs.ExperiencesByOffer.grid) ], "containing_panel": this, "hide_top_toolbar": true, "master_panel": this, "flex": 50 });
    var CandidaturesByOffer_grid2796 = new Lino.jobs.CandidaturesByOffer.GridPanel({ "tools": [ Lino.show_in_own_window_button(Lino.jobs.CandidaturesByOffer.grid) ], "containing_panel": this, "hide_top_toolbar": true, "master_panel": this, "flex": 50 });
    var main_4_panel2797 = new Ext.Panel({ "flex": 41, "border": false, "layout": "hbox", "hideCheckBoxLabels": true, "items": [ ExperiencesByOffer_grid2786, CandidaturesByOffer_grid2796 ], "autoScroll": false, "layoutConfig": { "align": "stretch" }, "frame": false, "labelAlign": "top" });
    var main_panel2798 = new Ext.Panel({ "autoScroll": false, "border": false, "layout": "vbox", "labelWidth": 81, "hideCheckBoxLabels": true, "items": [ main_1_panel2762, main_2_panel2770, { "items": remark2774, "labelAlign": "top", "layout": "form", "xtype": "panel", "flex": 41 }, main_4_panel2797 ], "frame": true, "layoutConfig": { "align": "stretch" }, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel2798;
    this.before_row_edit = function(record) {
      function2761.setContextValue('sector',record ? record.data['sectorHidden'] : undefined);
      ExperiencesByOffer_grid2786.on_master_changed();
      CandidaturesByOffer_grid2796.on_master_changed();
    }
    this.onRender = function(ct, position) {
      sector2760.on('change',Lino.chooser_handler(function2761,'sector'));
      Lino.jobs.Offers.DetailFormPanel.superclass.onRender.call(this, ct, position);
    }
    Lino.jobs.Offers.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.notes.Notes.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 91,
  initComponent : function() {
    var containing_panel = this;
    var date826 = new Lino.DateField({ "selectOnFocus": true, "allowBlank": false, "fieldLabel": "Date", "anchor": "-20", "name": "date" });
    var event_type827 = new Lino.TwinCombo({ "fieldLabel": "Event Type (Form)", "name": "event_type", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.notes.EventTypes.detail)}, "emptyText": "Choisir Event Type...", "selectOnFocus": true, "hiddenName": "event_typeHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/notes/Notes/event_type", "method": "GET" }) }) });
    var type828 = new Lino.TwinCombo({ "fieldLabel": "Note Type (Content)", "name": "type", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.notes.NoteTypes.detail)}, "emptyText": "Choisir Type de note...", "selectOnFocus": true, "hiddenName": "typeHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/notes/Notes/type", "method": "GET" }) }) });
    var left_1_panel829 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 180, "hideCheckBoxLabels": true, "items": [ { "flex": 16, "autoHeight": true, "layout": "form", "xtype": "panel", "items": date826, "labelAlign": "top" }, { "flex": 41, "autoHeight": true, "layout": "form", "xtype": "panel", "items": event_type827, "labelAlign": "top" }, { "flex": 41, "autoHeight": true, "layout": "form", "xtype": "panel", "items": type828, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var subject833 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200, "fieldLabel": "Subject", "anchor": "-20", "name": "subject" });
    var project834 = new Lino.TwinCombo({ "fieldLabel": "Client", "name": "project", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.pcsw.Clients.detail)}, "emptyText": "Choisir Client...", "selectOnFocus": true, "hiddenName": "projectHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/notes/Notes/project", "method": "GET" }) }) });
    var company835 = new Lino.TwinCombo({ "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Organisation</span>", "name": "company", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.contacts.Companies.detail)}, "emptyText": "Choisir Organisation...", "listeners": { "render": Lino.quicktip_renderer("Organisation","    An optional third-party Organization that is related to this Note.\n    The note will then be visible in that company's history panel.\n    ") }, "selectOnFocus": true, "hiddenName": "companyHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/notes/Notes/company", "method": "GET" }) }) });
    var left_3_panel836 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 117, "hideCheckBoxLabels": true, "items": [ { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": project834, "labelAlign": "top" }, { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": company835, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var id839 = new Ext.form.NumberField({ "selectOnFocus": true, "fieldLabel": "ID", "anchor": "-20", "name": "id" });
    var user840 = new Lino.TwinCombo({ "fieldLabel": "Auteur", "name": "user", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.users.Users.detail)}, "emptyText": "Choisir Utilisateur...", "selectOnFocus": true, "hiddenName": "userHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/notes/Notes/user", "method": "GET" }) }) });
    var language841 = new Lino.ChoicesFieldElement({ "fieldLabel": "Langue", "allowBlank": false, "value": "de", "hiddenName": "languageHidden", "selectOnFocus": true, "anchor": "-20", "store": [ [ "de", "German" ], [ "fr", "French" ], [ "nl", "Dutch" ] ], "name": "language" });
    var build_time842 = new Ext.form.DisplayField({ "disabled": true, "fieldLabel": "build time", "anchor": "-20", "value": "<br>", "name": "build_time" });
    var left_4_panel843 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 99, "hideCheckBoxLabels": true, "items": [ { "flex": 12, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id839, "labelAlign": "top" }, { "flex": 25, "autoHeight": true, "layout": "form", "xtype": "panel", "items": user840, "labelAlign": "top" }, { "flex": 20, "autoHeight": true, "layout": "form", "xtype": "panel", "items": language841, "labelAlign": "top" }, { "flex": 41, "autoHeight": true, "layout": "form", "xtype": "panel", "items": build_time842, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var body848 = new Lino.RichTextPanel({ "selectOnFocus": true, "flex": 55, "containing_panel": this, "name": "body", "title": "Body" });
    var left_panel849 = new Ext.Panel({ "flex": 66, "layout": "vbox", "items": [ left_1_panel829, { "items": subject833, "autoHeight": true, "layout": "form", "xtype": "panel", "labelAlign": "top" }, left_3_panel836, left_4_panel843, body848 ], "frame": true, "layoutConfig": { "align": "stretch" }, "autoScroll": false, "hideCheckBoxLabels": true, "labelWidth": 72, "border": false, "bodyBorder": false, "labelAlign": "top" });
    var UploadsByController_htmlbox851 = new Lino.HtmlBoxPanel({ "flex": 16, "ls_bbar_actions": [ { "itemId": "insert", "menu_item_text": "Nouveau", "must_save": true, "tooltip": "Insert a new record", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-new", "overflowText": "Nouveau", "auto_save": true } ], "name": "UploadsByController", "containing_panel": this, "items": new Ext.BoxComponent({autoScroll:true}), "title": "Uploads", "master_panel": this, "value": "<br/>", "always_enabled": true, "bodyStyle": "overflow-x:hidden", "ls_insert_handler": Lino.uploads.UploadsByController.insert, "layout": "fit", "tools": [ Lino.show_in_own_window_button(Lino.uploads.UploadsByController.grid) ] });
    var outbox_MailsByController_grid897 = new Lino.outbox.MailsByController.GridPanel({ "tools": [ Lino.show_in_own_window_button(Lino.outbox.MailsByController.grid) ], "containing_panel": this, "hide_top_toolbar": true, "master_panel": this, "flex": 27 });
    var postings_PostingsByController_grid908 = new Lino.postings.PostingsByController.GridPanel({ "tools": [ Lino.show_in_own_window_button(Lino.postings.PostingsByController.grid) ], "containing_panel": this, "hide_top_toolbar": true, "master_panel": this, "flex": 27 });
    var cal_TasksByController_grid914 = new Lino.cal.TasksByController.GridPanel({ "tools": [ Lino.show_in_own_window_button(Lino.cal.TasksByController.grid) ], "containing_panel": this, "hide_top_toolbar": true, "master_panel": this, "flex": 27 });
    var right_panel915 = new Ext.Panel({ "flex": 33, "layout": "vbox", "items": [ UploadsByController_htmlbox851, outbox_MailsByController_grid897, postings_PostingsByController_grid908, cal_TasksByController_grid914 ], "frame": true, "layoutConfig": { "align": "stretch" }, "autoScroll": false, "hideCheckBoxLabels": true, "labelWidth": 72, "border": false, "bodyBorder": false, "labelAlign": "top" });
    var main_1_panel916 = new Ext.Panel({ "autoScroll": false, "border": false, "layout": "hbox", "hideCheckBoxLabels": true, "items": [ left_panel849, right_panel915 ], "frame": false, "layoutConfig": { "align": "stretch" }, "labelAlign": "top" });
    var main_panel917 = new Ext.Panel({ "autoScroll": false, "border": false, "layout": "fit", "hideCheckBoxLabels": true, "items": [ main_1_panel916 ], "frame": true, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel917;
    this.before_row_edit = function(record) {
      body848.refresh();
      UploadsByController_htmlbox851.refresh();
      outbox_MailsByController_grid897.on_master_changed();
      postings_PostingsByController_grid908.on_master_changed();
      cal_TasksByController_grid914.on_master_changed();
    }
    Lino.notes.Notes.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.jobs.Jobs.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 69,
  initComponent : function() {
    var containing_panel = this;
    var name2553 = new Ext.form.TextField({ "fieldLabel": "Name", "name": "name", "maxLength": 100, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var provider2554 = new Lino.TwinCombo({ "fieldLabel": "Employant", "name": "provider", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.jobs.JobProviders.detail)}, "emptyText": "Choisir Employant...", "selectOnFocus": true, "hiddenName": "providerHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/jobs/Jobs/provider", "method": "GET" }) }) });
    var contract_type2555 = new Lino.TwinCombo({ "fieldLabel": "Type de contrat", "name": "contract_type", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.jobs.ContractTypes.detail)}, "emptyText": "Choisir Type de contrat de travail...", "selectOnFocus": true, "hiddenName": "contract_typeHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/jobs/Jobs/contract_type", "method": "GET" }) }) });
    var type2556 = new Lino.TwinCombo({ "fieldLabel": "Type d'emploi", "name": "type", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.jobs.JobTypes.detail)}, "emptyText": "Choisir Type d'emploi...", "selectOnFocus": true, "hiddenName": "typeHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/jobs/Jobs/type", "method": "GET" }) }) });
    var id2557 = new Ext.form.NumberField({ "selectOnFocus": true, "fieldLabel": "ID", "anchor": "-20", "name": "id" });
    var main_1_panel2558 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 144, "hideCheckBoxLabels": true, "items": [ { "flex": 24, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name2553, "labelAlign": "top" }, { "flex": 23, "autoHeight": true, "layout": "form", "xtype": "panel", "items": provider2554, "labelAlign": "top" }, { "flex": 23, "autoHeight": true, "layout": "form", "xtype": "panel", "items": contract_type2555, "labelAlign": "top" }, { "flex": 23, "autoHeight": true, "layout": "form", "xtype": "panel", "items": type2556, "labelAlign": "top" }, { "flex": 5, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id2557, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var sector2564 = new Lino.TwinCombo({ "fieldLabel": "Secteur d'activit\u00e9", "name": "sector", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.jobs.Sectors.detail)}, "emptyText": "Choisir Secteur d'activit\u00e9...", "selectOnFocus": true, "hiddenName": "sectorHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/jobs/Jobs/sector", "method": "GET" }) }) });
    var function2565 = new Lino.TwinCombo({ "fieldLabel": "Fonction", "name": "function", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.jobs.Functions.detail)}, "emptyText": "Choisir Fonction...", "selectOnFocus": true, "hiddenName": "functionHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/jobs/Jobs/function", "method": "GET" }) }) });
    var capacity2566 = new Ext.form.NumberField({ "fieldLabel": "Capacit\u00e9", "name": "capacity", "selectOnFocus": true, "anchor": "-20", "value": 1, "allowBlank": false });
    var hourly_rate2567 = new Ext.form.NumberField({ "decimalPrecision": 2, "fieldLabel": "co\u00fbr horaire", "name": "hourly_rate", "decimalSeparator": ",", "selectOnFocus": true, "anchor": "-20", "allowBlank": true });
    var main_2_panel2568 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 171, "hideCheckBoxLabels": true, "items": [ { "flex": 35, "autoHeight": true, "layout": "form", "xtype": "panel", "items": sector2564, "labelAlign": "top" }, { "flex": 35, "autoHeight": true, "layout": "form", "xtype": "panel", "items": function2565, "labelAlign": "top" }, { "flex": 8, "autoHeight": true, "layout": "form", "xtype": "panel", "items": capacity2566, "labelAlign": "top" }, { "flex": 21, "autoHeight": true, "layout": "form", "xtype": "panel", "items": hourly_rate2567, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var remark2573 = new Ext.form.TextArea({ "selectOnFocus": true, "fieldLabel": "Remarque", "anchor": "-20 -10", "growMax": 2000, "name": "remark" });
    var CandidaturesByJob_grid2582 = new Lino.jobs.CandidaturesByJob.GridPanel({ "tools": [ Lino.show_in_own_window_button(Lino.jobs.CandidaturesByJob.grid) ], "containing_panel": this, "hide_top_toolbar": true, "master_panel": this, "flex": 66 });
    var main_3_panel2583 = new Ext.Panel({ "flex": 41, "border": false, "layout": "hbox", "labelWidth": 81, "hideCheckBoxLabels": true, "items": [ { "items": remark2573, "labelAlign": "top", "layout": "form", "xtype": "panel", "flex": 33 }, CandidaturesByJob_grid2582 ], "autoScroll": false, "layoutConfig": { "align": "stretch" }, "frame": false, "labelAlign": "top" });
    var ContractsByJob_grid2613 = new Lino.jobs.ContractsByJob.GridPanel({ "flex": 41, "hide_top_toolbar": true, "containing_panel": this, "params_panel_hidden": true, "tools": [ Lino.show_in_own_window_button(Lino.jobs.ContractsByJob.grid) ], "master_panel": this });
    var main_panel2614 = new Ext.Panel({ "autoScroll": false, "border": false, "layout": "vbox", "hideCheckBoxLabels": true, "items": [ main_1_panel2558, main_2_panel2568, main_3_panel2583, ContractsByJob_grid2613 ], "frame": true, "layoutConfig": { "align": "stretch" }, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel2614;
    this.before_row_edit = function(record) {
      function2565.setContextValue('sector',record ? record.data['sectorHidden'] : undefined);
      CandidaturesByJob_grid2582.on_master_changed();
      ContractsByJob_grid2613.on_master_changed();
    }
    this.onRender = function(ct, position) {
      sector2564.on('change',Lino.chooser_handler(function2565,'sector'));
      Lino.jobs.Jobs.DetailFormPanel.superclass.onRender.call(this, ct, position);
    }
    Lino.jobs.Jobs.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.ui.TextFieldTemplates.InsertFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  autoHeight: true,
  content_type: 1,
  initComponent : function() {
    var containing_panel = this;
    var name181 = new Ext.form.TextField({ "fieldLabel": "Description", "name": "name", "maxLength": 200, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var user182 = new Lino.TwinCombo({ "fieldLabel": "Auteur", "name": "user", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.users.Users.detail)}, "emptyText": "Choisir Utilisateur...", "selectOnFocus": true, "hiddenName": "userHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/ui/TextFieldTemplates/user", "method": "GET" }) }) });
    var team183 = new Lino.RemoteComboFieldElement({ "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Team</span>", "name": "team", "pageSize": 20, "emptyText": "Choisir Team...", "listeners": { "render": Lino.quicktip_renderer("Team","If not empty, then this template is reserved to members of this team.") }, "selectOnFocus": true, "hiddenName": "teamHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/ui/TextFieldTemplates/team", "method": "GET" }) }) });
    var main_2_panel184 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 42, "autoHeight": true, "layout": "form", "xtype": "panel", "items": user182, "labelAlign": "top" }, { "flex": 57, "autoHeight": true, "layout": "form", "xtype": "panel", "items": team183, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 63, "border": false, "anchor": "-20", "labelAlign": "top" });
    var main_panel187 = new Ext.Panel({ "hideCheckBoxLabels": true, "autoHeight": true, "border": false, "layout": "form", "labelWidth": 108, "autoScroll": false, "items": [ { "autoHeight": true, "layout": "form", "xtype": "panel", "items": name181, "anchor": "-20", "labelAlign": "top" }, main_2_panel184 ], "frame": true, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel187;
    this.before_row_edit = function(record) {
    }
    Lino.ui.TextFieldTemplates.InsertFormPanel.superclass.initComponent.call(this);
  }
});


Lino.notes.NoteTypes.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 93,
  initComponent : function() {
    var containing_panel = this;
    var id1386 = new Ext.form.NumberField({ "selectOnFocus": true, "fieldLabel": "ID", "anchor": "-20", "name": "id" });
    var name1387 = new Ext.form.TextField({ "fieldLabel": "Description", "name": "name", "maxLength": 200, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var name_fr1388 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200, "fieldLabel": "Description (fr)", "anchor": "-20", "name": "name_fr" });
    var name_nl1389 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200, "fieldLabel": "Description (nl)", "anchor": "-20", "name": "name_nl" });
    var main_1_panel1390 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 153, "hideCheckBoxLabels": true, "items": [ { "flex": 7, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id1386, "labelAlign": "top" }, { "flex": 30, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name1387, "labelAlign": "top" }, { "flex": 30, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_fr1388, "labelAlign": "top" }, { "flex": 30, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_nl1389, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var build_method1395 = new Lino.ChoicesFieldElement({ "fieldLabel": "M\u00e9thode de construction", "name": "build_method", "selectOnFocus": true, "anchor": "-20", "store": [ [ "appyodt", "AppyOdtBuildMethod" ], [ "appypdf", "AppyPdfBuildMethod" ], [ "appyrtf", "AppyRtfBuildMethod" ], [ "latex", "LatexBuildMethod" ], [ "pisa", "PisaBuildMethod" ], [ "rtf", "RtfBuildMethod" ] ], "hiddenName": "build_methodHidden" });
    var template1396 = new Lino.SimpleRemoteComboFieldElement({ "selectOnFocus": true, "fieldLabel": "Mod\u00e8le", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/notes/NoteTypes/template", "method": "GET" }) }), "name": "template" });
    var email_template1397 = new Lino.SimpleRemoteComboFieldElement({ "listeners": { "render": Lino.quicktip_renderer("Email template","The name of the file to be used as template \nwhen creating an email from a mailable of this type.\n") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Email template</span>", "name": "email_template", "selectOnFocus": true, "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/notes/NoteTypes/email_template", "method": "GET" }) }) });
    var attach_to_email1398 = new Ext.form.Checkbox({ "boxLabel": "Attach to email", "listeners": { "render": Lino.quicktip_renderer("Attach to email","Whether the printable file should be attached to the email\nwhen creating an email from a mailable of this type.\n") }, "hideLabel": true, "checked": false, "name": "attach_to_email", "selectOnFocus": true, "anchor": "-20" });
    var main_2_panel1399 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 216, "hideCheckBoxLabels": true, "items": [ { "flex": 40, "autoHeight": true, "layout": "form", "xtype": "panel", "items": build_method1395, "labelAlign": "top" }, { "flex": 20, "autoHeight": true, "layout": "form", "xtype": "panel", "items": template1396, "labelAlign": "top" }, { "flex": 20, "autoHeight": true, "layout": "form", "xtype": "panel", "items": email_template1397, "labelAlign": "top" }, { "flex": 20, "autoHeight": true, "layout": "form", "xtype": "panel", "items": attach_to_email1398, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var remark1404 = new Ext.form.TextArea({ "selectOnFocus": true, "fieldLabel": "Remarque", "anchor": "-20 -10", "growMax": 2000, "name": "remark" });
    var notes_NotesByType_grid1419 = new Lino.notes.NotesByType.GridPanel({ "tools": [ Lino.show_in_own_window_button(Lino.notes.NotesByType.grid) ], "containing_panel": this, "hide_top_toolbar": true, "master_panel": this, "flex": 41 });
    var main_panel1420 = new Ext.Panel({ "autoScroll": false, "border": false, "layout": "vbox", "labelWidth": 81, "hideCheckBoxLabels": true, "items": [ main_1_panel1390, main_2_panel1399, { "items": remark1404, "labelAlign": "top", "layout": "form", "xtype": "panel", "flex": 41 }, notes_NotesByType_grid1419 ], "frame": true, "layoutConfig": { "align": "stretch" }, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel1420;
    this.before_row_edit = function(record) {
      template1396.setContextValue('build_method',record ? record.data['build_methodHidden'] : undefined);
      notes_NotesByType_grid1419.on_master_changed();
    }
    this.onRender = function(ct, position) {
      build_method1395.on('change',Lino.chooser_handler(template1396,'build_method'));
      Lino.notes.NoteTypes.DetailFormPanel.superclass.onRender.call(this, ct, position);
    }
    Lino.notes.NoteTypes.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.ui.Home.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  disable_editing: true,
  initComponent : function() {
    var containing_panel = this;
    var quick_links_htmlbox3314 = new Lino.HtmlBoxPanel({ "flex": 1, "layout": "fit", "name": "quick_links", "containing_panel": this, "items": new Ext.BoxComponent({autoScroll:true}), "region": "north", "master_panel": this, "value": "<br/>", "always_enabled": true, "bodyStyle": "overflow-x:hidden", "split": true });
    var welcome_htmlbox3315 = new Lino.HtmlBoxPanel({ "flex": 3, "layout": "fit", "name": "welcome", "containing_panel": this, "items": new Ext.BoxComponent({autoScroll:true}), "region": "center", "title": "Bienvenue", "master_panel": this, "value": "<br/>", "always_enabled": true, "bodyStyle": "overflow-x:hidden", "split": true });
    var main_panel3316 = new Lino.VBorderPanel({ "autoScroll": false, "border": false, "labelWidth": 90, "hideCheckBoxLabels": true, "items": [ quick_links_htmlbox3314, welcome_htmlbox3315 ], "frame": true, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel3316;
    this.before_row_edit = function(record) {
      quick_links_htmlbox3314.refresh();
      welcome_htmlbox3315.refresh();
    }
    Lino.ui.Home.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.households.Households.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 41,
  initComponent : function() {
    var containing_panel = this;
    var type1258 = new Lino.TwinCombo({ "fieldLabel": "Type de m\u00e9nage", "name": "type", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.households.Types.detail)}, "emptyText": "Choisir Type de m\u00e9nage...", "selectOnFocus": true, "hiddenName": "typeHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/households/Households/type", "method": "GET" }) }) });
    var name1259 = new Ext.form.TextField({ "fieldLabel": "Name", "name": "name", "maxLength": 200, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var language1260 = new Lino.ChoicesFieldElement({ "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Langue</span>", "allowBlank": false, "value": "de", "hiddenName": "languageHidden", "listeners": { "render": Lino.quicktip_renderer("Langue","Die Sprache, in der Dokumente ausgestellt werden sollen.") }, "selectOnFocus": true, "anchor": "-20", "store": [ [ "de", "German" ], [ "fr", "French" ], [ "nl", "Dutch" ] ], "name": "language" });
    var id1261 = new Ext.form.NumberField({ "selectOnFocus": true, "fieldLabel": "ID", "anchor": "-20", "name": "id" });
    var intro_box_1_panel1262 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 135, "hideCheckBoxLabels": true, "items": [ { "flex": 35, "autoHeight": true, "layout": "form", "xtype": "panel", "items": type1258, "labelAlign": "top" }, { "flex": 37, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name1259, "labelAlign": "top" }, { "flex": 17, "autoHeight": true, "layout": "form", "xtype": "panel", "items": language1260, "labelAlign": "top" }, { "flex": 8, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id1261, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var country1267 = new Lino.TwinCombo({ "fieldLabel": "Pays", "name": "country", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.countries.Countries.detail)}, "emptyText": "Choisir Pays...", "selectOnFocus": true, "hiddenName": "countryHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/households/Households/country", "method": "GET" }) }) });
    var region1268 = new Lino.TwinCombo({ "fieldLabel": "Region", "name": "region", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.countries.Cities.detail)}, "emptyText": "Choisir Place...", "selectOnFocus": true, "hiddenName": "regionHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/households/Households/region", "method": "GET" }) }) });
    var box3_1_panel1269 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": country1267, "labelAlign": "top" }, { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": region1268, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 63, "border": false, "anchor": "-20", "labelAlign": "top" });
    var city1272 = new Lino.TwinCombo({ "forceSelection": false, "fieldLabel": "Place", "name": "city", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.countries.Cities.detail)}, "emptyText": "Choisir Place...", "selectOnFocus": true, "hiddenName": "cityHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/households/Households/city", "method": "GET" }) }) });
    var zip_code1273 = new Ext.form.TextField({ "fieldLabel": "Zip code", "name": "zip_code", "maxLength": 10, "selectOnFocus": true, "boxMinWidth": Lino.chars2width(10), "anchor": "-20" });
    var box3_2_panel1274 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 66, "autoHeight": true, "layout": "form", "xtype": "panel", "items": city1272, "labelAlign": "top" }, { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": zip_code1273, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 81, "border": false, "anchor": "-20", "labelAlign": "top" });
    var street_prefix1277 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Pr\u00e9fixe rue","Text to print before name of street, but to ignore for sorting.") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Pr\u00e9fixe rue</span>", "name": "street_prefix", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var street1278 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Rue","Name of street. Without house number.") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Rue</span>", "name": "street", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var street_no1279 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("N\u00b0","House number") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">N\u00b0</span>", "name": "street_no", "maxLength": 10, "selectOnFocus": true, "boxMinWidth": Lino.chars2width(10), "anchor": "-20" });
    var street_box1280 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("bo\u00eete","Text to print after :attr:`steet_no` on the same line") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">bo\u00eete</span>", "name": "street_box", "maxLength": 10, "selectOnFocus": true, "boxMinWidth": Lino.chars2width(10), "anchor": "-20" });
    var box3_3_panel1281 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 30, "autoHeight": true, "layout": "form", "xtype": "panel", "items": street_prefix1277, "labelAlign": "top" }, { "flex": 36, "autoHeight": true, "layout": "form", "xtype": "panel", "items": street1278, "labelAlign": "top" }, { "flex": 16, "autoHeight": true, "layout": "form", "xtype": "panel", "items": street_no1279, "labelAlign": "top" }, { "flex": 16, "autoHeight": true, "layout": "form", "xtype": "panel", "items": street_box1280, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 108, "border": false, "anchor": "-20", "labelAlign": "top" });
    var addr21286 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Ligne apr\u00e8s le nom de rue","Address line to print below street line") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Ligne apr\u00e8s le nom de rue</span>", "name": "addr2", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var activity1287 = new Lino.RemoteComboFieldElement({ "fieldLabel": "Activit\u00e9", "name": "activity", "pageSize": 20, "emptyText": "Choisir Activit\u00e9...", "selectOnFocus": true, "hiddenName": "activityHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/households/Households/activity", "method": "GET" }) }) });
    var bank_account11288 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 40, "fieldLabel": "Compte en banque 1", "anchor": "-20", "name": "bank_account1" });
    var bank_account21289 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 40, "fieldLabel": "Compte en banque 2", "anchor": "-20", "name": "bank_account2" });
    var box3_5_panel1290 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 45, "autoHeight": true, "layout": "form", "xtype": "panel", "items": activity1287, "labelAlign": "top" }, { "flex": 27, "autoHeight": true, "layout": "form", "xtype": "panel", "items": bank_account11288, "labelAlign": "top" }, { "flex": 27, "autoHeight": true, "layout": "form", "xtype": "panel", "items": bank_account21289, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 171, "border": false, "anchor": "-20", "labelAlign": "top" });
    var box3_panel1294 = new Ext.Panel({ "flex": 62, "autoHeight": true, "layout": "form", "items": [ box3_1_panel1269, box3_2_panel1274, box3_3_panel1281, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": addr21286, "anchor": "-20", "labelAlign": "top" }, box3_5_panel1290 ], "frame": true, "bodyBorder": false, "autoScroll": false, "hideCheckBoxLabels": true, "labelWidth": 234, "border": false, "labelAlign": "top" });
    var email1296 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 75, "fieldLabel": "E-mail", "anchor": "-20", "name": "email" });
    var url1297 = new Lino.URLField({ "selectOnFocus": true, "maxLength": 200, "fieldLabel": "URL", "anchor": "-20", "name": "url" });
    var phone1298 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200, "fieldLabel": "T\u00e9l\u00e9phone", "anchor": "-20", "name": "phone" });
    var gsm1299 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200, "fieldLabel": "GSM", "anchor": "-20", "name": "gsm" });
    var box4_panel1300 = new Ext.Panel({ "flex": 37, "autoHeight": true, "layout": "form", "items": [ { "autoHeight": true, "layout": "form", "xtype": "panel", "items": email1296, "anchor": "-20", "labelAlign": "top" }, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": url1297, "anchor": "-20", "labelAlign": "top" }, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": phone1298, "anchor": "-20", "labelAlign": "top" }, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": gsm1299, "anchor": "-20", "labelAlign": "top" } ], "frame": true, "bodyBorder": false, "autoScroll": false, "hideCheckBoxLabels": true, "labelWidth": 90, "border": false, "labelAlign": "top" });
    var address_box_panel1305 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "hideCheckBoxLabels": true, "items": [ box3_panel1294, box4_panel1300 ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var remarks1306 = new Ext.form.TextArea({ "selectOnFocus": true, "fieldLabel": "Remarques", "anchor": "-20 -10", "growMax": 2000, "name": "remarks" });
    var households_MembersByHousehold_grid1313 = new Lino.households.MembersByHousehold.GridPanel({ "tools": [ Lino.show_in_own_window_button(Lino.households.MembersByHousehold.grid) ], "containing_panel": this, "hide_top_toolbar": true, "master_panel": this, "flex": 50 });
    var bottom_box_panel1314 = new Ext.Panel({ "flex": 45, "border": false, "layout": "hbox", "labelWidth": 90, "hideCheckBoxLabels": true, "items": [ { "items": remarks1306, "labelAlign": "top", "layout": "form", "xtype": "panel", "flex": 49 }, households_MembersByHousehold_grid1313 ], "autoScroll": false, "layoutConfig": { "align": "stretch" }, "frame": false, "labelAlign": "top" });
    var general_panel1316 = new Ext.Panel({ "layout": "vbox", "title": "G\u00e9n\u00e9ral", "items": [ intro_box_1_panel1262, address_box_panel1305, bottom_box_panel1314 ], "frame": true, "layoutConfig": { "align": "stretch" }, "hideCheckBoxLabels": true, "listeners": { "activate": Lino.on_tab_activate }, "autoScroll": false, "border": false, "bodyBorder": false, "labelAlign": "top" });
    var debts_BudgetsByPartner_grid1317 = new Lino.debts.BudgetsByPartner.GridPanel({ "flex": 5, "hide_top_toolbar": true, "split": true, "containing_panel": this, "region": "north", "tools": [ Lino.show_in_own_window_button(Lino.debts.BudgetsByPartner.grid) ], "master_panel": this });
    var debts_ActorsByPartner_grid1318 = new Lino.debts.ActorsByPartner.GridPanel({ "flex": 5, "hide_top_toolbar": true, "split": true, "containing_panel": this, "region": "center", "tools": [ Lino.show_in_own_window_button(Lino.debts.ActorsByPartner.grid) ], "master_panel": this });
    var debts_panel1319 = new Lino.VBorderPanel({ "autoScroll": false, "listeners": { "activate": Lino.on_tab_activate }, "border": false, "title": "M\u00e9diation de dettes", "hideCheckBoxLabels": true, "items": [ debts_BudgetsByPartner_grid1317, debts_ActorsByPartner_grid1318 ], "frame": true, "bodyBorder": false, "labelAlign": "top" });
    var main_panel1320 = new Ext.TabPanel({ "hideCheckBoxLabels": true, "border": false, "split": true, "autoScroll": false, "items": [ general_panel1316, debts_panel1319 ], "activeTab": 0, "bodyBorder": false, "frame": true, "labelAlign": "top" });
    this.items = main_panel1320;
    this.before_row_edit = function(record) {
      region1268.setContextValue('country',record ? record.data['countryHidden'] : undefined);
      city1272.setContextValue('country',record ? record.data['countryHidden'] : undefined);
      city1272.setContextValue('region',record ? record.data['regionHidden'] : undefined);
      households_MembersByHousehold_grid1313.on_master_changed();
      debts_BudgetsByPartner_grid1317.on_master_changed();
      debts_ActorsByPartner_grid1318.on_master_changed();
    }
    this.onRender = function(ct, position) {
      country1267.on('change',Lino.chooser_handler(region1268,'country'));
      country1267.on('change',Lino.chooser_handler(city1272,'country'));
      region1268.on('change',Lino.chooser_handler(city1272,'region'));
      Lino.households.Households.DetailFormPanel.superclass.onRender.call(this, ct, position);
    }
    Lino.households.Households.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.isip.ExamPolicies.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 58,
  initComponent : function() {
    var containing_panel = this;
    var id2330 = new Ext.form.NumberField({ "selectOnFocus": true, "fieldLabel": "ID", "anchor": "-20", "name": "id" });
    var name2331 = new Ext.form.TextField({ "fieldLabel": "Description", "name": "name", "maxLength": 200, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var name_fr2332 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200, "fieldLabel": "Description (fr)", "anchor": "-20", "name": "name_fr" });
    var name_nl2333 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200, "fieldLabel": "Description (nl)", "anchor": "-20", "name": "name_nl" });
    var main_1_panel2334 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 153, "hideCheckBoxLabels": true, "items": [ { "flex": 7, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id2330, "labelAlign": "top" }, { "flex": 30, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name2331, "labelAlign": "top" }, { "flex": 30, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_fr2332, "labelAlign": "top" }, { "flex": 30, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_nl2333, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var every2339 = new Ext.form.NumberField({ "fieldLabel": "Evaluation every X months", "name": "every", "selectOnFocus": true, "anchor": "-20", "value": 0, "allowBlank": false });
    var every_unit2340 = new Lino.ChoicesFieldElement({ "forceSelection": true, "fieldLabel": "Dur\u00e9e (unit\u00e9)", "name": "every_unit", "selectOnFocus": true, "anchor": "-20", "store": Lino.cal.DurationUnits, "hiddenName": "every_unitHidden" });
    var calendar2341 = new Lino.TwinCombo({ "fieldLabel": "Calendrier", "name": "calendar", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.cal.Calendars.detail)}, "emptyText": "Choisir Calendrier...", "selectOnFocus": true, "hiddenName": "calendarHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/isip/ExamPolicies/calendar", "method": "GET" }) }) });
    var main_2_panel2342 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 234, "hideCheckBoxLabels": true, "items": [ { "flex": 14, "autoHeight": true, "layout": "form", "xtype": "panel", "items": every2339, "labelAlign": "top" }, { "flex": 28, "autoHeight": true, "layout": "form", "xtype": "panel", "items": every_unit2340, "labelAlign": "top" }, { "flex": 57, "autoHeight": true, "layout": "form", "xtype": "panel", "items": calendar2341, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var isip_ContractsByPolicy_grid2371 = new Lino.isip.ContractsByPolicy.GridPanel({ "flex": 41, "hide_top_toolbar": true, "containing_panel": this, "params_panel_hidden": true, "tools": [ Lino.show_in_own_window_button(Lino.isip.ContractsByPolicy.grid) ], "master_panel": this });
    var jobs_ContractsByPolicy_grid2400 = new Lino.jobs.ContractsByPolicy.GridPanel({ "flex": 41, "hide_top_toolbar": true, "containing_panel": this, "params_panel_hidden": true, "tools": [ Lino.show_in_own_window_button(Lino.jobs.ContractsByPolicy.grid) ], "master_panel": this });
    var main_panel2401 = new Ext.Panel({ "autoScroll": false, "border": false, "layout": "vbox", "hideCheckBoxLabels": true, "items": [ main_1_panel2334, main_2_panel2342, isip_ContractsByPolicy_grid2371, jobs_ContractsByPolicy_grid2400 ], "frame": true, "layoutConfig": { "align": "stretch" }, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel2401;
    this.before_row_edit = function(record) {
      isip_ContractsByPolicy_grid2371.on_master_changed();
      jobs_ContractsByPolicy_grid2400.on_master_changed();
    }
    Lino.isip.ExamPolicies.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.households.Types.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 42,
  initComponent : function() {
    var containing_panel = this;
    var name1224 = new Ext.form.TextField({ "fieldLabel": "Description", "name": "name", "maxLength": 200, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var name_fr1225 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200, "fieldLabel": "Description (fr)", "anchor": "-20", "name": "name_fr" });
    var name_nl1226 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200, "fieldLabel": "Description (nl)", "anchor": "-20", "name": "name_nl" });
    var main_1_panel1227 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 153, "hideCheckBoxLabels": true, "items": [ { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name1224, "labelAlign": "top" }, { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_fr1225, "labelAlign": "top" }, { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_nl1226, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var HouseholdsByType_grid1321 = new Lino.households.HouseholdsByType.GridPanel({ "tools": [ Lino.show_in_own_window_button(Lino.households.HouseholdsByType.grid) ], "containing_panel": this, "hide_top_toolbar": true, "master_panel": this, "flex": 83 });
    var main_panel1322 = new Ext.Panel({ "autoScroll": false, "border": false, "layout": "vbox", "hideCheckBoxLabels": true, "items": [ main_1_panel1227, HouseholdsByType_grid1321 ], "frame": true, "layoutConfig": { "align": "stretch" }, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel1322;
    this.before_row_edit = function(record) {
      HouseholdsByType_grid1321.on_master_changed();
    }
    Lino.households.Types.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.cal.Events.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 36,
  initComponent : function() {
    var containing_panel = this;
    var calendar1022 = new Lino.TwinCombo({ "fieldLabel": "Calendrier", "name": "calendar", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.cal.Calendars.detail)}, "emptyText": "Choisir Calendrier...", "selectOnFocus": true, "hiddenName": "calendarHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/Events/calendar", "method": "GET" }) }) });
    var summary1023 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200, "fieldLabel": "R\u00e9sum\u00e9", "anchor": "-20", "name": "summary" });
    var project1024 = new Lino.TwinCombo({ "fieldLabel": "Client", "name": "project", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.pcsw.Clients.detail)}, "emptyText": "Choisir Client...", "selectOnFocus": true, "hiddenName": "projectHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/Events/project", "method": "GET" }) }) });
    var general_1_panel1025 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 99, "hideCheckBoxLabels": true, "items": [ { "flex": 32, "autoHeight": true, "layout": "form", "xtype": "panel", "items": calendar1022, "labelAlign": "top" }, { "flex": 34, "autoHeight": true, "layout": "form", "xtype": "panel", "items": summary1023, "labelAlign": "top" }, { "flex": 32, "autoHeight": true, "layout": "form", "xtype": "panel", "items": project1024, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var start_date1029 = new Lino.DateField({ "selectOnFocus": true, "fieldLabel": "Date d\u00e9but", "anchor": "-20", "name": "start_date" });
    var start_time1030 = new Lino.TimeField({ "selectOnFocus": true, "fieldLabel": "Heure de d\u00e9but", "anchor": "-20", "name": "start_time" });
    var start_panel1031 = new Ext.Panel({ "flex": 25, "autoHeight": true, "layout": "hbox", "items": [ { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": start_date1029, "labelAlign": "top" }, { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": start_time1030, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "autoScroll": false, "hideCheckBoxLabels": true, "labelWidth": 135, "border": false, "labelAlign": "top" });
    var end_date1034 = new Lino.DateField({ "selectOnFocus": true, "fieldLabel": "Date de fin", "anchor": "-20", "name": "end_date" });
    var end_time1035 = new Lino.TimeField({ "selectOnFocus": true, "fieldLabel": "Heure de fin", "anchor": "-20", "name": "end_time" });
    var end_panel1036 = new Ext.Panel({ "flex": 25, "autoHeight": true, "layout": "hbox", "items": [ { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": end_date1034, "labelAlign": "top" }, { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": end_time1035, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "autoScroll": false, "hideCheckBoxLabels": true, "labelWidth": 117, "border": false, "labelAlign": "top" });
    var user1039 = new Lino.TwinCombo({ "fieldLabel": "Responsible user", "name": "user", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.users.Users.detail)}, "emptyText": "Choisir Utilisateur...", "selectOnFocus": true, "hiddenName": "userHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/Events/user", "method": "GET" }) }) });
    var assigned_to1040 = new Lino.TwinCombo({ "fieldLabel": "Attribu\u00e9 \u00e0", "name": "assigned_to", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.users.Users.detail)}, "emptyText": "Choisir Utilisateur...", "selectOnFocus": true, "hiddenName": "assigned_toHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/Events/assigned_to", "method": "GET" }) }) });
    var general_2_panel1041 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 153, "hideCheckBoxLabels": true, "items": [ start_panel1031, end_panel1036, { "flex": 24, "autoHeight": true, "layout": "form", "xtype": "panel", "items": user1039, "labelAlign": "top" }, { "flex": 24, "autoHeight": true, "layout": "form", "xtype": "panel", "items": assigned_to1040, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var place1044 = new Lino.TwinCombo({ "fieldLabel": "Place", "name": "place", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.cal.Places.detail)}, "emptyText": "Choisir Place...", "selectOnFocus": true, "hiddenName": "placeHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/Events/place", "method": "GET" }) }) });
    var priority1045 = new Lino.RemoteComboFieldElement({ "fieldLabel": "Priorit\u00e9", "name": "priority", "pageSize": 20, "emptyText": "Choisir Priorit\u00e9...", "selectOnFocus": true, "hiddenName": "priorityHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/Events/priority", "method": "GET" }) }) });
    var access_class1046 = new Lino.ChoicesFieldElement({ "forceSelection": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Classe d'acc\u00e8s</span>", "name": "access_class", "hiddenName": "access_classHidden", "listeners": { "render": Lino.quicktip_renderer("Classe d'acc\u00e8s","Public, priv\u00e9 ou \"marquer occup\u00e9\".") }, "selectOnFocus": true, "anchor": "-20", "store": Lino.cal.AccessClasses });
    var transparent1047 = new Ext.form.Checkbox({ "boxLabel": "non bloquant", "listeners": { "render": Lino.quicktip_renderer("non bloquant","Indique que ce rendez-vous n'emp\u00eache pas d'avoir d'autres rendez-vous en m\u00eame temps.") }, "hideLabel": true, "checked": false, "name": "transparent", "selectOnFocus": true, "anchor": "-20" });
    var general_3_panel1048 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 135, "hideCheckBoxLabels": true, "items": [ { "flex": 32, "autoHeight": true, "layout": "form", "xtype": "panel", "items": place1044, "labelAlign": "top" }, { "flex": 32, "autoHeight": true, "layout": "form", "xtype": "panel", "items": priority1045, "labelAlign": "top" }, { "flex": 19, "autoHeight": true, "layout": "form", "xtype": "panel", "items": access_class1046, "labelAlign": "top" }, { "flex": 16, "autoHeight": true, "layout": "form", "xtype": "panel", "items": transparent1047, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var owner_disp1053 = new Ext.form.DisplayField({ "disabled": true, "fieldLabel": "Contr\u00f4l\u00e9 par", "anchor": "-20", "name": "owner" });
    var workflow_buttons_disp1054 = new Ext.form.DisplayField({ "disabled": true, "fieldLabel": "Workflow", "name": "workflow_buttons", "anchor": "-20", "value": "<br/>", "always_enabled": true });
    var general_4_panel1055 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 117, "hideCheckBoxLabels": true, "items": [ { "flex": 25, "autoHeight": true, "layout": "form", "xtype": "panel", "items": owner_disp1053, "labelAlign": "top" }, { "flex": 75, "autoHeight": true, "layout": "form", "xtype": "panel", "items": workflow_buttons_disp1054, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var description1058 = new Lino.RichTextPanel({ "selectOnFocus": true, "flex": 33, "containing_panel": this, "name": "description", "title": "Description" });
    var GuestsByEvent_grid1068 = new Lino.cal.GuestsByEvent.GridPanel({ "tools": [ Lino.show_in_own_window_button(Lino.cal.GuestsByEvent.grid) ], "containing_panel": this, "hide_top_toolbar": true, "master_panel": this, "flex": 66 });
    var general_5_panel1069 = new Ext.Panel({ "flex": 45, "border": false, "layout": "hbox", "labelWidth": 0, "hideCheckBoxLabels": true, "items": [ description1058, GuestsByEvent_grid1068 ], "autoScroll": false, "layoutConfig": { "align": "stretch" }, "frame": false, "labelAlign": "top" });
    var general_panel1070 = new Ext.Panel({ "layout": "vbox", "title": "G\u00e9n\u00e9ral", "items": [ general_1_panel1025, general_2_panel1041, general_3_panel1048, general_4_panel1055, general_5_panel1069 ], "frame": true, "layoutConfig": { "align": "stretch" }, "hideCheckBoxLabels": true, "listeners": { "activate": Lino.on_tab_activate }, "autoScroll": false, "border": false, "bodyBorder": false, "labelAlign": "top" });
    var id1071 = new Ext.form.NumberField({ "selectOnFocus": true, "fieldLabel": "ID", "anchor": "-20", "name": "id" });
    var created1072 = new Ext.form.DisplayField({ "disabled": true, "fieldLabel": "Cr\u00e9\u00e9", "anchor": "-20", "value": "<br>", "name": "created" });
    var modified1073 = new Ext.form.DisplayField({ "disabled": true, "fieldLabel": "Modified", "anchor": "-20", "value": "<br>", "name": "modified" });
    var more_1_panel1074 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 81, "hideCheckBoxLabels": true, "items": [ { "flex": 11, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id1071, "labelAlign": "top" }, { "flex": 44, "autoHeight": true, "layout": "form", "xtype": "panel", "items": created1072, "labelAlign": "top" }, { "flex": 44, "autoHeight": true, "layout": "form", "xtype": "panel", "items": modified1073, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var outbox_MailsByController_grid1078 = new Lino.outbox.MailsByController.GridPanel({ "tools": [ Lino.show_in_own_window_button(Lino.outbox.MailsByController.grid) ], "containing_panel": this, "hide_top_toolbar": true, "master_panel": this, "flex": 50 });
    var postings_PostingsByController_grid1079 = new Lino.postings.PostingsByController.GridPanel({ "tools": [ Lino.show_in_own_window_button(Lino.postings.PostingsByController.grid) ], "containing_panel": this, "hide_top_toolbar": true, "master_panel": this, "flex": 50 });
    var more_2_panel1080 = new Ext.Panel({ "flex": 83, "border": false, "layout": "hbox", "hideCheckBoxLabels": true, "items": [ outbox_MailsByController_grid1078, postings_PostingsByController_grid1079 ], "autoScroll": false, "layoutConfig": { "align": "stretch" }, "frame": false, "labelAlign": "top" });
    var more_panel1081 = new Ext.Panel({ "layout": "vbox", "title": "Plus", "items": [ more_1_panel1074, more_2_panel1080 ], "frame": true, "layoutConfig": { "align": "stretch" }, "hideCheckBoxLabels": true, "listeners": { "activate": Lino.on_tab_activate }, "autoScroll": false, "border": false, "bodyBorder": false, "labelAlign": "top" });
    var main_panel1082 = new Ext.TabPanel({ "hideCheckBoxLabels": true, "border": false, "split": true, "autoScroll": false, "items": [ general_panel1070, more_panel1081 ], "activeTab": 0, "bodyBorder": false, "frame": true, "labelAlign": "top" });
    this.items = main_panel1082;
    this.before_row_edit = function(record) {
      description1058.refresh();
      GuestsByEvent_grid1068.on_master_changed();
      outbox_MailsByController_grid1078.on_master_changed();
      postings_PostingsByController_grid1079.on_master_changed();
    }
    Lino.cal.Events.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.cal.Events.InsertFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  autoHeight: true,
  content_type: 36,
  initComponent : function() {
    var containing_panel = this;
    var summary1083 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200, "fieldLabel": "R\u00e9sum\u00e9", "anchor": "-20", "name": "summary" });
    var start_date1084 = new Lino.DateField({ "selectOnFocus": true, "fieldLabel": "Date d\u00e9but", "anchor": "-20", "name": "start_date" });
    var start_time1085 = new Lino.TimeField({ "selectOnFocus": true, "fieldLabel": "Heure de d\u00e9but", "anchor": "-20", "name": "start_time" });
    var start_panel1086 = new Ext.Panel({ "flex": 50, "autoHeight": true, "layout": "hbox", "items": [ { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": start_date1084, "labelAlign": "top" }, { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": start_time1085, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "autoScroll": false, "hideCheckBoxLabels": true, "labelWidth": 135, "border": false, "labelAlign": "top" });
    var end_date1089 = new Lino.DateField({ "selectOnFocus": true, "fieldLabel": "Date de fin", "anchor": "-20", "name": "end_date" });
    var end_time1090 = new Lino.TimeField({ "selectOnFocus": true, "fieldLabel": "Heure de fin", "anchor": "-20", "name": "end_time" });
    var end_panel1091 = new Ext.Panel({ "flex": 50, "autoHeight": true, "layout": "hbox", "items": [ { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": end_date1089, "labelAlign": "top" }, { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": end_time1090, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "autoScroll": false, "hideCheckBoxLabels": true, "labelWidth": 117, "border": false, "labelAlign": "top" });
    var main_2_panel1094 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "hideCheckBoxLabels": true, "items": [ start_panel1086, end_panel1091 ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "anchor": "-20", "labelAlign": "top" });
    var calendar1095 = new Lino.TwinCombo({ "fieldLabel": "Calendrier", "name": "calendar", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.cal.Calendars.detail)}, "emptyText": "Choisir Calendrier...", "selectOnFocus": true, "hiddenName": "calendarHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/Events/calendar", "method": "GET" }) }) });
    var project1096 = new Lino.TwinCombo({ "fieldLabel": "Client", "name": "project", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.pcsw.Clients.detail)}, "emptyText": "Choisir Client...", "selectOnFocus": true, "hiddenName": "projectHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/Events/project", "method": "GET" }) }) });
    var main_3_panel1097 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": calendar1095, "labelAlign": "top" }, { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": project1096, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 99, "border": false, "anchor": "-20", "labelAlign": "top" });
    var main_panel1100 = new Ext.Panel({ "hideCheckBoxLabels": true, "autoHeight": true, "border": false, "layout": "form", "labelWidth": 63, "autoScroll": false, "items": [ { "autoHeight": true, "layout": "form", "xtype": "panel", "items": summary1083, "anchor": "-20", "labelAlign": "top" }, main_2_panel1094, main_3_panel1097 ], "frame": true, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel1100;
    this.before_row_edit = function(record) {
    }
    Lino.cal.Events.InsertFormPanel.superclass.initComponent.call(this);
  }
});


Lino.isip.Contracts.InsertFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  autoHeight: true,
  content_type: 59,
  initComponent : function() {
    var containing_panel = this;
    var client1948 = new Lino.TwinCombo({ "fieldLabel": "Client", "allowBlank": false, "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.pcsw.Clients.detail)}, "emptyText": "Choisir Client...", "selectOnFocus": true, "hiddenName": "clientHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/isip/Contracts/client", "method": "GET" }) }), "name": "client" });
    var type1949 = new Lino.TwinCombo({ "fieldLabel": "Type de contrat", "name": "type", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.isip.ContractTypes.detail)}, "emptyText": "Choisir Type de PIIS...", "selectOnFocus": true, "hiddenName": "typeHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/isip/Contracts/type", "method": "GET" }) }) });
    var company1950 = new Lino.TwinCombo({ "fieldLabel": "Organisation", "name": "company", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.contacts.Companies.detail)}, "emptyText": "Choisir Organisation...", "selectOnFocus": true, "hiddenName": "companyHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/isip/Contracts/company", "method": "GET" }) }) });
    var main_2_panel1951 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": type1949, "labelAlign": "top" }, { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": company1950, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 144, "border": false, "anchor": "-20", "labelAlign": "top" });
    var main_panel1954 = new Ext.Panel({ "hideCheckBoxLabels": true, "autoHeight": true, "border": false, "layout": "form", "labelWidth": 63, "autoScroll": false, "items": [ { "autoHeight": true, "layout": "form", "xtype": "panel", "items": client1948, "anchor": "-20", "labelAlign": "top" }, main_2_panel1951 ], "frame": true, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel1954;
    this.before_row_edit = function(record) {
    }
    Lino.isip.Contracts.InsertFormPanel.superclass.initComponent.call(this);
    // active_fields:
    company1950.on("change",function(){this.save()},this);
  }
});


Lino.about.Models.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  disable_editing: true,
  initComponent : function() {
    var containing_panel = this;
    var app_disp3294 = new Ext.form.DisplayField({ "disabled": true, "fieldLabel": "app_label", "name": "app", "anchor": "-20", "value": "<br/>", "always_enabled": true });
    var name_disp3295 = new Ext.form.DisplayField({ "disabled": true, "fieldLabel": "name", "name": "name", "anchor": "-20", "value": "<br/>", "always_enabled": true });
    var docstring_disp3296 = new Ext.form.DisplayField({ "disabled": true, "fieldLabel": "docstring", "name": "docstring", "anchor": "-20", "value": "<br/>", "always_enabled": true });
    var rows3297 = new Ext.form.NumberField({ "disabled": true, "fieldLabel": "Rows", "anchor": "-20", "name": "rows" });
    var main_1_panel3298 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 90, "hideCheckBoxLabels": true, "items": [ { "flex": 31, "autoHeight": true, "layout": "form", "xtype": "panel", "items": app_disp3294, "labelAlign": "top" }, { "flex": 31, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_disp3295, "labelAlign": "top" }, { "flex": 31, "autoHeight": true, "layout": "form", "xtype": "panel", "items": docstring_disp3296, "labelAlign": "top" }, { "flex": 5, "autoHeight": true, "layout": "form", "xtype": "panel", "items": rows3297, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var about_FieldsByModel_grid3307 = new Lino.about.FieldsByModel.GridPanel({ "tools": [ Lino.show_in_own_window_button(Lino.about.FieldsByModel.grid) ], "containing_panel": this, "hide_top_toolbar": true, "master_panel": this, "flex": 62 });
    var main_panel3308 = new Ext.Panel({ "autoScroll": false, "border": false, "layout": "vbox", "hideCheckBoxLabels": true, "items": [ main_1_panel3298, about_FieldsByModel_grid3307 ], "frame": true, "layoutConfig": { "align": "stretch" }, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel3308;
    this.before_row_edit = function(record) {
      about_FieldsByModel_grid3307.on_master_changed();
    }
    Lino.about.Models.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.cal.Tasks.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 30,
  initComponent : function() {
    var containing_panel = this;
    var start_date258 = new Lino.DateField({ "selectOnFocus": true, "fieldLabel": "Date d\u00e9but", "anchor": "-20", "name": "start_date" });
    var due_date259 = new Lino.DateField({ "selectOnFocus": true, "fieldLabel": "Due date", "anchor": "-20", "name": "due_date" });
    var id260 = new Ext.form.NumberField({ "selectOnFocus": true, "fieldLabel": "ID", "anchor": "-20", "name": "id" });
    var workflow_buttons_disp261 = new Ext.form.DisplayField({ "disabled": true, "fieldLabel": "Workflow", "name": "workflow_buttons", "anchor": "-20", "value": "<br/>", "always_enabled": true });
    var main_1_panel262 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 99, "hideCheckBoxLabels": true, "items": [ { "flex": 15, "autoHeight": true, "layout": "form", "xtype": "panel", "items": start_date258, "labelAlign": "top" }, { "flex": 15, "autoHeight": true, "layout": "form", "xtype": "panel", "items": due_date259, "labelAlign": "top" }, { "flex": 9, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id260, "labelAlign": "top" }, { "flex": 58, "autoHeight": true, "layout": "form", "xtype": "panel", "items": workflow_buttons_disp261, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var summary267 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200, "fieldLabel": "R\u00e9sum\u00e9", "anchor": "-20", "name": "summary" });
    var user268 = new Lino.TwinCombo({ "fieldLabel": "Auteur", "name": "user", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.users.Users.detail)}, "emptyText": "Choisir Utilisateur...", "selectOnFocus": true, "hiddenName": "userHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/Tasks/user", "method": "GET" }) }) });
    var project269 = new Lino.TwinCombo({ "fieldLabel": "Client", "name": "project", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.pcsw.Clients.detail)}, "emptyText": "Choisir Client...", "selectOnFocus": true, "hiddenName": "projectHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/Tasks/project", "method": "GET" }) }) });
    var main_3_panel270 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 63, "hideCheckBoxLabels": true, "items": [ { "flex": 42, "autoHeight": true, "layout": "form", "xtype": "panel", "items": user268, "labelAlign": "top" }, { "flex": 57, "autoHeight": true, "layout": "form", "xtype": "panel", "items": project269, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var calendar273 = new Lino.TwinCombo({ "fieldLabel": "Calendrier", "name": "calendar", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.cal.Calendars.detail)}, "emptyText": "Choisir Calendrier...", "selectOnFocus": true, "hiddenName": "calendarHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/Tasks/calendar", "method": "GET" }) }) });
    var owner_disp274 = new Ext.form.DisplayField({ "disabled": true, "fieldLabel": "Contr\u00f4l\u00e9 par", "anchor": "-20", "name": "owner" });
    var created275 = new Ext.form.DisplayField({ "disabled": true, "fieldLabel": "Cr\u00e9\u00e9", "anchor": "-20", "value": "<br>", "name": "created" });
    var modified276 = new Ext.form.DisplayField({ "disabled": true, "fieldLabel": "Modified", "anchor": "-20", "value": "<br>", "name": "modified" });
    var main_4_panel277 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 117, "hideCheckBoxLabels": true, "items": [ { "flex": 28, "autoHeight": true, "layout": "form", "xtype": "panel", "items": calendar273, "labelAlign": "top" }, { "flex": 14, "autoHeight": true, "layout": "form", "xtype": "panel", "items": owner_disp274, "labelAlign": "top" }, { "flex": 28, "autoHeight": true, "layout": "form", "xtype": "panel", "items": created275, "labelAlign": "top" }, { "flex": 28, "autoHeight": true, "layout": "form", "xtype": "panel", "items": modified276, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var description282 = new Lino.RichTextPanel({ "selectOnFocus": true, "flex": 45, "containing_panel": this, "name": "description", "title": "Description" });
    var main_panel283 = new Ext.Panel({ "autoScroll": false, "border": false, "layout": "vbox", "labelWidth": 63, "hideCheckBoxLabels": true, "items": [ main_1_panel262, { "items": summary267, "autoHeight": true, "layout": "form", "xtype": "panel", "labelAlign": "top" }, main_3_panel270, main_4_panel277, description282 ], "frame": true, "layoutConfig": { "align": "stretch" }, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel283;
    this.before_row_edit = function(record) {
      description282.refresh();
    }
    Lino.cal.Tasks.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.properties.PropTypes.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 16,
  initComponent : function() {
    var containing_panel = this;
    var id711 = new Ext.form.NumberField({ "selectOnFocus": true, "fieldLabel": "ID", "anchor": "-20", "name": "id" });
    var name712 = new Ext.form.TextField({ "fieldLabel": "Description", "name": "name", "maxLength": 200, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var name_fr713 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200, "fieldLabel": "Description (fr)", "anchor": "-20", "name": "name_fr" });
    var name_nl714 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200, "fieldLabel": "Description (nl)", "anchor": "-20", "name": "name_nl" });
    var choicelist715 = new Lino.ChoicesFieldElement({ "fieldLabel": "Liste de choix", "name": "choicelist", "selectOnFocus": true, "anchor": "-20", "store": [ [ "countries.CityTypes", "CityTypes" ], [ "lino.ChangeTypes", "Change Types" ], [ "lino.Genders", "Genders" ], [ "lino.UserGroups", "User Groups" ], [ "lino.UserLevels", "User Levels" ], [ "lino.UserProfiles", "User Profiles" ], [ "properties.DoYouLike", "DoYouLike" ], [ "properties.HowWell", "HowWell" ] ], "hiddenName": "choicelistHidden" });
    var default_value716 = new Lino.RemoteComboFieldElement({ "fieldLabel": "valeur par d\u00e9fault", "name": "default_value", "selectOnFocus": true, "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/properties/PropTypes/default_value", "method": "GET" }) }), "hiddenName": "default_valueHidden" });
    var main_1_panel717 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 5, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id711, "labelAlign": "top" }, { "flex": 21, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name712, "labelAlign": "top" }, { "flex": 21, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_fr713, "labelAlign": "top" }, { "flex": 21, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_nl714, "labelAlign": "top" }, { "flex": 20, "autoHeight": true, "layout": "form", "xtype": "panel", "items": choicelist715, "labelAlign": "top" }, { "flex": 10, "autoHeight": true, "layout": "form", "xtype": "panel", "items": default_value716, "labelAlign": "top" } ], "region": "north", "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "split": true, "autoScroll": false, "labelWidth": 171, "border": false, "frame": false, "labelAlign": "top" });
    var ChoicesByType_grid730 = new Lino.properties.ChoicesByType.GridPanel({ "flex": 5, "hide_top_toolbar": true, "split": true, "containing_panel": this, "region": "center", "tools": [ Lino.show_in_own_window_button(Lino.properties.ChoicesByType.grid) ], "master_panel": this });
    var PropsByType_grid737 = new Lino.properties.PropsByType.GridPanel({ "flex": 5, "hide_top_toolbar": true, "split": true, "containing_panel": this, "region": "south", "tools": [ Lino.show_in_own_window_button(Lino.properties.PropsByType.grid) ], "master_panel": this });
    var main_panel738 = new Lino.VBorderPanel({ "autoScroll": false, "border": false, "hideCheckBoxLabels": true, "items": [ main_1_panel717, ChoicesByType_grid730, PropsByType_grid737 ], "frame": true, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel738;
    this.before_row_edit = function(record) {
      default_value716.setContextValue('choicelist',record ? record.data['choicelistHidden'] : undefined);
      ChoicesByType_grid730.on_master_changed();
      PropsByType_grid737.on_master_changed();
    }
    this.onRender = function(ct, position) {
      choicelist715.on('change',Lino.chooser_handler(default_value716,'choicelist'));
      Lino.properties.PropTypes.DetailFormPanel.superclass.onRender.call(this, ct, position);
    }
    Lino.properties.PropTypes.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.jobs.Sectors.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 61,
  initComponent : function() {
    var containing_panel = this;
    var id2694 = new Ext.form.NumberField({ "selectOnFocus": true, "fieldLabel": "ID", "anchor": "-20", "name": "id" });
    var name2695 = new Ext.form.TextField({ "fieldLabel": "Description", "name": "name", "maxLength": 200, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var name_fr2696 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200, "fieldLabel": "Description (fr)", "anchor": "-20", "name": "name_fr" });
    var name_nl2697 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200, "fieldLabel": "Description (nl)", "anchor": "-20", "name": "name_nl" });
    var main_1_panel2698 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 7, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id2694, "labelAlign": "top" }, { "flex": 30, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name2695, "labelAlign": "top" }, { "flex": 30, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_fr2696, "labelAlign": "top" }, { "flex": 30, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_nl2697, "labelAlign": "top" } ], "region": "north", "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "split": true, "autoScroll": false, "labelWidth": 153, "border": false, "frame": false, "labelAlign": "top" });
    var remark2703 = new Ext.form.TextArea({ "selectOnFocus": true, "fieldLabel": "Remarque", "anchor": "-20 -10", "growMax": 2000, "name": "remark" });
    var FunctionsBySector_grid2745 = new Lino.jobs.FunctionsBySector.GridPanel({ "tools": [ Lino.show_in_own_window_button(Lino.jobs.FunctionsBySector.grid) ], "containing_panel": this, "hide_top_toolbar": true, "master_panel": this, "flex": 66 });
    var main_2_panel2746 = new Ext.Panel({ "flex": 5, "layout": "hbox", "items": [ { "items": remark2703, "labelAlign": "top", "layout": "form", "xtype": "panel", "flex": 33 }, FunctionsBySector_grid2745 ], "region": "center", "layoutConfig": { "align": "stretch" }, "hideCheckBoxLabels": true, "split": true, "autoScroll": false, "labelWidth": 81, "border": false, "frame": false, "labelAlign": "top" });
    var CandidaturesBySector_grid2756 = new Lino.jobs.CandidaturesBySector.GridPanel({ "flex": 5, "hide_top_toolbar": true, "split": true, "containing_panel": this, "region": "south", "tools": [ Lino.show_in_own_window_button(Lino.jobs.CandidaturesBySector.grid) ], "master_panel": this });
    var main_panel2757 = new Lino.VBorderPanel({ "autoScroll": false, "border": false, "hideCheckBoxLabels": true, "items": [ main_1_panel2698, main_2_panel2746, CandidaturesBySector_grid2756 ], "frame": true, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel2757;
    this.before_row_edit = function(record) {
      FunctionsBySector_grid2745.on_master_changed();
      CandidaturesBySector_grid2756.on_master_changed();
    }
    Lino.jobs.Sectors.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.outbox.Mails.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 27,
  initComponent : function() {
    var containing_panel = this;
    var subject863 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200, "fieldLabel": "Subject", "anchor": "-20", "name": "subject" });
    var project864 = new Lino.TwinCombo({ "fieldLabel": "Client", "name": "project", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.pcsw.Clients.detail)}, "emptyText": "Choisir Client...", "selectOnFocus": true, "hiddenName": "projectHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/outbox/Mails/project", "method": "GET" }) }) });
    var date865 = new Lino.DateField({ "listeners": { "render": Lino.quicktip_renderer("Date","\n        The official date to be printed on the document.\n        ") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Date</span>", "name": "date", "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var main_1_panel866 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 72, "hideCheckBoxLabels": true, "items": [ { "flex": 42, "autoHeight": true, "layout": "form", "xtype": "panel", "items": subject863, "labelAlign": "top" }, { "flex": 40, "autoHeight": true, "layout": "form", "xtype": "panel", "items": project864, "labelAlign": "top" }, { "flex": 16, "autoHeight": true, "layout": "form", "xtype": "panel", "items": date865, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var user870 = new Lino.TwinCombo({ "fieldLabel": "exp\u00e9diteur", "name": "user", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.users.Users.detail)}, "emptyText": "Choisir Utilisateur...", "selectOnFocus": true, "hiddenName": "userHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/outbox/Mails/user", "method": "GET" }) }) });
    var sent871 = new Ext.form.DisplayField({ "disabled": true, "fieldLabel": "sent", "anchor": "-20", "value": "<br>", "name": "sent" });
    var id872 = new Ext.form.NumberField({ "selectOnFocus": true, "fieldLabel": "ID", "anchor": "-20", "name": "id" });
    var owner_disp873 = new Ext.form.DisplayField({ "disabled": true, "fieldLabel": "Contr\u00f4l\u00e9 par", "anchor": "-20", "name": "owner" });
    var main_2_panel874 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 117, "hideCheckBoxLabels": true, "items": [ { "flex": 32, "autoHeight": true, "layout": "form", "xtype": "panel", "items": user870, "labelAlign": "top" }, { "flex": 34, "autoHeight": true, "layout": "form", "xtype": "panel", "items": sent871, "labelAlign": "top" }, { "flex": 10, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id872, "labelAlign": "top" }, { "flex": 21, "autoHeight": true, "layout": "form", "xtype": "panel", "items": owner_disp873, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var RecipientsByMail_grid885 = new Lino.outbox.RecipientsByMail.GridPanel({ "tools": [ Lino.show_in_own_window_button(Lino.outbox.RecipientsByMail.grid) ], "containing_panel": this, "hide_top_toolbar": true, "master_panel": this, "flex": 55 });
    var AttachmentsByMail_htmlbox886 = new Lino.HtmlBoxPanel({ "flex": 22, "layout": "fit", "name": "AttachmentsByMail", "containing_panel": this, "items": new Ext.BoxComponent({autoScroll:true}), "title": "Pi\u00e8ces jointes", "master_panel": this, "value": "<br/>", "always_enabled": true, "bodyStyle": "overflow-x:hidden", "tools": [ Lino.show_in_own_window_button(Lino.outbox.AttachmentsByMail.grid) ] });
    var UploadsByController_htmlbox887 = new Lino.HtmlBoxPanel({ "flex": 22, "ls_bbar_actions": [ { "itemId": "insert", "menu_item_text": "Nouveau", "must_save": true, "tooltip": "Insert a new record", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-new", "overflowText": "Nouveau", "auto_save": true } ], "name": "UploadsByController", "containing_panel": this, "items": new Ext.BoxComponent({autoScroll:true}), "title": "Uploads", "master_panel": this, "value": "<br/>", "always_enabled": true, "bodyStyle": "overflow-x:hidden", "ls_insert_handler": Lino.uploads.UploadsByController.insert, "layout": "fit", "tools": [ Lino.show_in_own_window_button(Lino.uploads.UploadsByController.grid) ] });
    var main_3_panel888 = new Ext.Panel({ "flex": 29, "border": false, "layout": "hbox", "labelWidth": 135, "hideCheckBoxLabels": true, "items": [ RecipientsByMail_grid885, AttachmentsByMail_htmlbox886, UploadsByController_htmlbox887 ], "autoScroll": false, "layoutConfig": { "align": "stretch" }, "frame": false, "labelAlign": "top" });
    var body889 = new Lino.RichTextPanel({ "selectOnFocus": true, "flex": 58, "containing_panel": this, "name": "body", "title": "Body" });
    var main_panel890 = new Ext.Panel({ "autoScroll": false, "border": false, "layout": "vbox", "labelWidth": 0, "hideCheckBoxLabels": true, "items": [ main_1_panel866, main_2_panel874, main_3_panel888, body889 ], "frame": true, "layoutConfig": { "align": "stretch" }, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel890;
    this.before_row_edit = function(record) {
      RecipientsByMail_grid885.on_master_changed();
      AttachmentsByMail_htmlbox886.refresh();
      UploadsByController_htmlbox887.refresh();
      body889.refresh();
    }
    Lino.outbox.Mails.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.cbss.ManageAccessRequests.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 88,
  initComponent : function() {
    var containing_panel = this;
    var id3157 = new Ext.form.NumberField({ "selectOnFocus": true, "fieldLabel": "ID", "anchor": "-20", "name": "id" });
    var person3158 = new Lino.TwinCombo({ "fieldLabel": "Client", "allowBlank": false, "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.pcsw.Clients.detail)}, "emptyText": "Choisir Client...", "selectOnFocus": true, "hiddenName": "personHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cbss/ManageAccessRequests/person", "method": "GET" }) }), "name": "person" });
    var user3159 = new Lino.TwinCombo({ "fieldLabel": "Auteur", "allowBlank": false, "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.users.Users.detail)}, "emptyText": "Choisir Utilisateur...", "selectOnFocus": true, "hiddenName": "userHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cbss/ManageAccessRequests/user", "method": "GET" }) }), "name": "user" });
    var environment3160 = new Ext.form.TextField({ "disabled": true, "fieldLabel": "T/A/B", "name": "environment", "maxLength": 4, "boxMinWidth": Lino.chars2width(4), "anchor": "-20" });
    var sent3161 = new Ext.form.DisplayField({ "disabled": true, "listeners": { "render": Lino.quicktip_renderer("Ex\u00e9cut\u00e9","The date and time when this request has been executed. \nThis is empty for requests than haven't been sent.\nRead-only.") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Ex\u00e9cut\u00e9</span>", "name": "sent", "anchor": "-20", "value": "<br>" });
    var status3162 = new Lino.ChoicesFieldElement({ "disabled": true, "forceSelection": true, "fieldLabel": "State", "name": "status", "anchor": "-20", "store": Lino.cbss.RequestStates, "hiddenName": "statusHidden" });
    var ticket3163 = new Ext.form.TextField({ "disabled": true, "maxLength": 36, "fieldLabel": "Ticket", "anchor": "-20", "name": "ticket" });
    var info_1_panel3164 = new Ext.form.FieldSet({ "autoHeight": true, "layout": "hbox", "title": "Information requ\u00eate", "layoutConfig": { "align": "stretchmax" }, "frame": false, "bodyBorder": true, "autoScroll": false, "items": [ { "flex": 5, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id3157, "labelAlign": "top" }, { "flex": 21, "autoHeight": true, "layout": "form", "xtype": "panel", "items": person3158, "labelAlign": "top" }, { "flex": 15, "autoHeight": true, "layout": "form", "xtype": "panel", "items": user3159, "labelAlign": "top" }, { "flex": 5, "autoHeight": true, "layout": "form", "xtype": "panel", "items": environment3160, "labelAlign": "top" }, { "flex": 17, "autoHeight": true, "layout": "form", "xtype": "panel", "items": sent3161, "labelAlign": "top" }, { "flex": 12, "autoHeight": true, "layout": "form", "xtype": "panel", "items": status3162, "labelAlign": "top" }, { "flex": 22, "autoHeight": true, "layout": "form", "xtype": "panel", "items": ticket3163, "labelAlign": "top" } ], "hideCheckBoxLabels": true, "labelWidth": 72, "border": false, "labelAlign": "top" });
    var action3172 = new Lino.ChoicesFieldElement({ "forceSelection": true, "fieldLabel": "Action", "allowBlank": false, "hiddenName": "actionHidden", "selectOnFocus": true, "anchor": "-20", "store": Lino.cbss.ManageAction, "name": "action" });
    var start_date3173 = new Lino.DateField({ "selectOnFocus": true, "allowBlank": false, "fieldLabel": "P\u00e9riode du", "anchor": "-20", "name": "start_date" });
    var end_date3174 = new Lino.DateField({ "selectOnFocus": true, "allowBlank": false, "fieldLabel": "P\u00e9riode au", "anchor": "-20", "name": "end_date" });
    var p1_1_panel3175 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 44, "autoHeight": true, "layout": "form", "xtype": "panel", "items": action3172, "labelAlign": "top" }, { "flex": 27, "autoHeight": true, "layout": "form", "xtype": "panel", "items": start_date3173, "labelAlign": "top" }, { "flex": 27, "autoHeight": true, "layout": "form", "xtype": "panel", "items": end_date3174, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 99, "border": false, "anchor": "-20", "labelAlign": "top" });
    var purpose3179 = new Lino.RemoteComboFieldElement({ "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Code fonction</span>", "allowBlank": false, "pageSize": 20, "emptyText": "Choisir Code fonction...", "listeners": { "render": Lino.quicktip_renderer("Code fonction","The purpose for which the inscription needs to be \nregistered/unregistered or listed. \nFor listing this field is optional, \nfor register/unregister it is mandatory.") }, "selectOnFocus": true, "hiddenName": "purposeHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cbss/ManageAccessRequests/purpose", "method": "GET" }) }), "name": "purpose" });
    var query_register3180 = new Lino.ChoicesFieldElement({ "forceSelection": true, "fieldLabel": "Query Register", "allowBlank": false, "hiddenName": "query_registerHidden", "selectOnFocus": true, "anchor": "-20", "store": Lino.cbss.QueryRegister, "name": "query_register" });
    var p1_2_panel3181 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 62, "autoHeight": true, "layout": "form", "xtype": "panel", "items": purpose3179, "labelAlign": "top" }, { "flex": 37, "autoHeight": true, "layout": "form", "xtype": "panel", "items": query_register3180, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 135, "border": false, "anchor": "-20", "labelAlign": "top" });
    var p1_panel3184 = new Ext.form.FieldSet({ "flex": 37, "autoHeight": true, "layout": "form", "title": "Action demand\u00e9e", "items": [ p1_1_panel3175, p1_2_panel3181 ], "frame": true, "bodyBorder": false, "autoScroll": false, "hideCheckBoxLabels": true, "border": false, "labelAlign": "top" });
    var national_id3185 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("NISS","The SSIN of the person to register/unregister/list.\n") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">NISS</span>", "name": "national_id", "maxLength": 200, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var sis_card_no3186 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("No carte SIS","The number of the SIS card used to authenticate the person.") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">No carte SIS</span>", "name": "sis_card_no", "maxLength": 10, "selectOnFocus": true, "boxMinWidth": Lino.chars2width(10), "anchor": "-20" });
    var id_card_no3187 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("No carte eID","The number of the ID card used to authenticate the person.") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">No carte eID</span>", "name": "id_card_no", "maxLength": 20, "selectOnFocus": true, "anchor": "-20" });
    var proof_1_panel3188 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 39, "autoHeight": true, "layout": "form", "xtype": "panel", "items": national_id3185, "labelAlign": "top" }, { "flex": 20, "autoHeight": true, "layout": "form", "xtype": "panel", "items": sis_card_no3186, "labelAlign": "top" }, { "flex": 39, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id_card_no3187, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 117, "border": false, "anchor": "-20", "labelAlign": "top" });
    var first_name3192 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200, "fieldLabel": "Pr\u00e9nom", "anchor": "-20", "name": "first_name" });
    var last_name3193 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200, "fieldLabel": "Nom de famille", "anchor": "-20", "name": "last_name" });
    var birth_date3194 = new Lino.IncompleteDateField({ "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("date de naissance","Uncomplete dates are allowed, e.g. \n\"00.00.1980\" means \"some day in 1980\", \n\"00.07.1980\" means \"in July 1980\"\nor \"23.07.0000\" means \"on a 23th of July\".") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">date de naissance</span>", "anchor": "-20", "name": "birth_date" });
    var proof_2_panel3195 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 38, "autoHeight": true, "layout": "form", "xtype": "panel", "items": first_name3192, "labelAlign": "top" }, { "flex": 38, "autoHeight": true, "layout": "form", "xtype": "panel", "items": last_name3193, "labelAlign": "top" }, { "flex": 22, "autoHeight": true, "layout": "form", "xtype": "panel", "items": birth_date3194, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 162, "border": false, "anchor": "-20", "labelAlign": "top" });
    var proof_panel3199 = new Ext.form.FieldSet({ "flex": 62, "autoHeight": true, "layout": "form", "title": "Preuve d'identification", "items": [ proof_1_panel3188, proof_2_panel3195 ], "frame": true, "bodyBorder": false, "autoScroll": false, "hideCheckBoxLabels": true, "border": false, "labelAlign": "top" });
    var parameters_panel3200 = new Ext.form.FieldSet({ "autoHeight": true, "layout": "hbox", "title": "Param\u00e8tres", "layoutConfig": { "align": "stretchmax" }, "frame": false, "bodyBorder": true, "autoScroll": false, "items": [ p1_panel3184, proof_panel3199 ], "hideCheckBoxLabels": true, "border": false, "labelAlign": "top" });
    var result_htmlbox3201 = new Lino.HtmlBoxPanel({ "flex": 50, "layout": "fit", "name": "result", "containing_panel": this, "items": new Ext.BoxComponent({autoScroll:true}), "title": "R\u015bultat", "master_panel": this, "value": "<br/>", "always_enabled": true, "bodyStyle": "overflow-x:hidden" });
    var request_panel3202 = new Ext.Panel({ "layout": "vbox", "title": "Requ\u00eate", "items": [ info_1_panel3164, parameters_panel3200, result_htmlbox3201 ], "frame": true, "layoutConfig": { "align": "stretch" }, "hideCheckBoxLabels": true, "listeners": { "activate": Lino.on_tab_activate }, "autoScroll": false, "labelWidth": 72, "border": false, "bodyBorder": false, "labelAlign": "top" });
    var response_xml3203 = new Ext.form.TextArea({ "disabled": true, "listeners": { "render": Lino.quicktip_renderer("R\u00e9ponse","The raw XML response received. \n") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">R\u00e9ponse</span>", "name": "response_xml", "growMax": 2000, "anchor": "-20 -10" });
    var info_messages3204 = new Ext.form.TextArea({ "disabled": true, "fieldLabel": "Messages info", "anchor": "-20 -10", "growMax": 2000, "name": "info_messages" });
    var debug_messages3205 = new Ext.form.TextArea({ "disabled": true, "fieldLabel": "Messages debug", "anchor": "-20 -10", "growMax": 2000, "name": "debug_messages" });
    var technical_panel3206 = new Lino.VBorderPanel({ "autoScroll": false, "listeners": { "activate": Lino.on_tab_activate }, "border": false, "labelWidth": 135, "title": "Technique", "hideCheckBoxLabels": true, "items": [ { "flex": 5, "layout": "form", "xtype": "panel", "items": response_xml3203, "region": "north", "labelAlign": "top", "split": true }, { "flex": 5, "layout": "form", "xtype": "panel", "items": info_messages3204, "region": "center", "labelAlign": "top", "split": true }, { "flex": 5, "layout": "form", "xtype": "panel", "items": debug_messages3205, "region": "south", "labelAlign": "top", "split": true } ], "frame": true, "bodyBorder": false, "labelAlign": "top" });
    var main_panel3210 = new Ext.TabPanel({ "hideCheckBoxLabels": true, "border": false, "split": true, "autoScroll": false, "items": [ request_panel3202, technical_panel3206 ], "activeTab": 0, "bodyBorder": false, "frame": true, "labelAlign": "top" });
    this.items = main_panel3210;
    this.before_row_edit = function(record) {
      purpose3179.setContextValue('sector',record ? record.data['sectorHidden'] : undefined);
      result_htmlbox3201.refresh();
    }
    Lino.cbss.ManageAccessRequests.DetailFormPanel.superclass.initComponent.call(this);
    // active_fields:
    person3158.on("change",function(){this.save()},this);
  }
});


Lino.ui.TextFieldTemplates.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 1,
  initComponent : function() {
    var containing_panel = this;
    var id168 = new Ext.form.NumberField({ "selectOnFocus": true, "fieldLabel": "ID", "anchor": "-20", "name": "id" });
    var name169 = new Ext.form.TextField({ "fieldLabel": "Description", "name": "name", "maxLength": 200, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var user170 = new Lino.TwinCombo({ "fieldLabel": "Auteur", "name": "user", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.users.Users.detail)}, "emptyText": "Choisir Utilisateur...", "selectOnFocus": true, "hiddenName": "userHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/ui/TextFieldTemplates/user", "method": "GET" }) }) });
    var team171 = new Lino.RemoteComboFieldElement({ "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Team</span>", "name": "team", "pageSize": 20, "emptyText": "Choisir Team...", "listeners": { "render": Lino.quicktip_renderer("Team","If not empty, then this template is reserved to members of this team.") }, "selectOnFocus": true, "hiddenName": "teamHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/ui/TextFieldTemplates/team", "method": "GET" }) }) });
    var main_1_panel172 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 8, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id168, "labelAlign": "top" }, { "flex": 34, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name169, "labelAlign": "top" }, { "flex": 24, "autoHeight": true, "layout": "form", "xtype": "panel", "items": user170, "labelAlign": "top" }, { "flex": 32, "autoHeight": true, "layout": "form", "xtype": "panel", "items": team171, "labelAlign": "top" } ], "region": "north", "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "split": true, "autoScroll": false, "labelWidth": 108, "border": false, "frame": false, "labelAlign": "top" });
    var description177 = new Ext.form.TextArea({ "selectOnFocus": true, "fieldLabel": "Description", "anchor": "-20 -10", "growMax": 2000, "name": "description" });
    var text178 = new Lino.RichTextPanel({ "flex": 5, "split": true, "containing_panel": this, "selectOnFocus": true, "region": "south", "title": "Texte mod\u00e8le", "name": "text" });
    var main_panel179 = new Lino.VBorderPanel({ "autoScroll": false, "border": false, "labelWidth": 108, "hideCheckBoxLabels": true, "items": [ main_1_panel172, { "flex": 5, "layout": "form", "xtype": "panel", "items": description177, "region": "center", "labelAlign": "top", "split": true }, text178 ], "frame": true, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel179;
    this.before_row_edit = function(record) {
      text178.refresh();
    }
    Lino.ui.TextFieldTemplates.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.cal.Tasks.InsertFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  autoHeight: true,
  content_type: 30,
  initComponent : function() {
    var containing_panel = this;
    var summary285 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200, "fieldLabel": "R\u00e9sum\u00e9", "anchor": "-20", "name": "summary" });
    var user286 = new Lino.TwinCombo({ "fieldLabel": "Auteur", "name": "user", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.users.Users.detail)}, "emptyText": "Choisir Utilisateur...", "selectOnFocus": true, "hiddenName": "userHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/Tasks/user", "method": "GET" }) }) });
    var project287 = new Lino.TwinCombo({ "fieldLabel": "Client", "name": "project", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.pcsw.Clients.detail)}, "emptyText": "Choisir Client...", "selectOnFocus": true, "hiddenName": "projectHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/Tasks/project", "method": "GET" }) }) });
    var main_2_panel288 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 42, "autoHeight": true, "layout": "form", "xtype": "panel", "items": user286, "labelAlign": "top" }, { "flex": 57, "autoHeight": true, "layout": "form", "xtype": "panel", "items": project287, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 63, "border": false, "anchor": "-20", "labelAlign": "top" });
    var main_panel291 = new Ext.Panel({ "hideCheckBoxLabels": true, "autoHeight": true, "border": false, "layout": "form", "labelWidth": 63, "autoScroll": false, "items": [ { "autoHeight": true, "layout": "form", "xtype": "panel", "items": summary285, "anchor": "-20", "labelAlign": "top" }, main_2_panel288 ], "frame": true, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel291;
    this.before_row_edit = function(record) {
    }
    Lino.cal.Tasks.InsertFormPanel.superclass.initComponent.call(this);
  }
});


Lino.cal.Places.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 33,
  initComponent : function() {
    var containing_panel = this;
    var id1125 = new Ext.form.NumberField({ "selectOnFocus": true, "fieldLabel": "ID", "anchor": "-20", "name": "id" });
    var name1126 = new Ext.form.TextField({ "fieldLabel": "Description", "name": "name", "maxLength": 200, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var name_fr1127 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200, "fieldLabel": "Description (fr)", "anchor": "-20", "name": "name_fr" });
    var name_nl1128 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200, "fieldLabel": "Description (nl)", "anchor": "-20", "name": "name_nl" });
    var main_1_panel1129 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 153, "hideCheckBoxLabels": true, "items": [ { "flex": 7, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id1125, "labelAlign": "top" }, { "flex": 30, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name1126, "labelAlign": "top" }, { "flex": 30, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_fr1127, "labelAlign": "top" }, { "flex": 30, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_nl1128, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var cal_EventsByPlace_grid1159 = new Lino.cal.EventsByPlace.GridPanel({ "flex": 83, "hide_top_toolbar": true, "containing_panel": this, "params_panel_hidden": true, "tools": [ Lino.show_in_own_window_button(Lino.cal.EventsByPlace.grid) ], "master_panel": this });
    var main_panel1160 = new Ext.Panel({ "autoScroll": false, "border": false, "layout": "vbox", "hideCheckBoxLabels": true, "items": [ main_1_panel1129, cal_EventsByPlace_grid1159 ], "frame": true, "layoutConfig": { "align": "stretch" }, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel1160;
    this.before_row_edit = function(record) {
      cal_EventsByPlace_grid1159.on_master_changed();
    }
    Lino.cal.Places.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.cbss.IdentifyPersonRequests.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 90,
  initComponent : function() {
    var containing_panel = this;
    var id3082 = new Ext.form.NumberField({ "selectOnFocus": true, "fieldLabel": "ID", "anchor": "-20", "name": "id" });
    var person3083 = new Lino.TwinCombo({ "fieldLabel": "Client", "allowBlank": false, "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.pcsw.Clients.detail)}, "emptyText": "Choisir Client...", "selectOnFocus": true, "hiddenName": "personHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cbss/IdentifyPersonRequests/person", "method": "GET" }) }), "name": "person" });
    var user3084 = new Lino.TwinCombo({ "fieldLabel": "Auteur", "allowBlank": false, "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.users.Users.detail)}, "emptyText": "Choisir Utilisateur...", "selectOnFocus": true, "hiddenName": "userHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cbss/IdentifyPersonRequests/user", "method": "GET" }) }), "name": "user" });
    var environment3085 = new Ext.form.TextField({ "disabled": true, "fieldLabel": "T/A/B", "name": "environment", "maxLength": 4, "boxMinWidth": Lino.chars2width(4), "anchor": "-20" });
    var sent3086 = new Ext.form.DisplayField({ "disabled": true, "listeners": { "render": Lino.quicktip_renderer("Ex\u00e9cut\u00e9","The date and time when this request has been executed. \nThis is empty for requests than haven't been sent.\nRead-only.") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Ex\u00e9cut\u00e9</span>", "name": "sent", "anchor": "-20", "value": "<br>" });
    var status3087 = new Lino.ChoicesFieldElement({ "disabled": true, "forceSelection": true, "fieldLabel": "State", "name": "status", "anchor": "-20", "store": Lino.cbss.RequestStates, "hiddenName": "statusHidden" });
    var ticket3088 = new Ext.form.TextField({ "disabled": true, "maxLength": 36, "fieldLabel": "Ticket", "anchor": "-20", "name": "ticket" });
    var info_1_panel3089 = new Ext.form.FieldSet({ "autoHeight": true, "layout": "hbox", "title": "Information requ\u00eate", "layoutConfig": { "align": "stretchmax" }, "frame": false, "bodyBorder": true, "autoScroll": false, "items": [ { "flex": 5, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id3082, "labelAlign": "top" }, { "flex": 21, "autoHeight": true, "layout": "form", "xtype": "panel", "items": person3083, "labelAlign": "top" }, { "flex": 15, "autoHeight": true, "layout": "form", "xtype": "panel", "items": user3084, "labelAlign": "top" }, { "flex": 5, "autoHeight": true, "layout": "form", "xtype": "panel", "items": environment3085, "labelAlign": "top" }, { "flex": 17, "autoHeight": true, "layout": "form", "xtype": "panel", "items": sent3086, "labelAlign": "top" }, { "flex": 12, "autoHeight": true, "layout": "form", "xtype": "panel", "items": status3087, "labelAlign": "top" }, { "flex": 22, "autoHeight": true, "layout": "form", "xtype": "panel", "items": ticket3088, "labelAlign": "top" } ], "hideCheckBoxLabels": true, "labelWidth": 72, "border": false, "labelAlign": "top" });
    var national_id3097 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200, "fieldLabel": "NISS", "anchor": "-20", "name": "national_id" });
    var p1_panel3099 = new Ext.form.FieldSet({ "flex": 25, "layout": "vbox", "title": "avec NISS", "layoutConfig": { "align": "stretch" }, "frame": true, "bodyBorder": false, "autoScroll": false, "items": [ { "items": national_id3097, "autoHeight": true, "layout": "form", "xtype": "panel", "labelAlign": "top" }, { "flex": 50, "html": "<br/>", "xtype": "label" } ], "hideCheckBoxLabels": true, "labelWidth": 45, "border": false, "labelAlign": "top" });
    var first_name3101 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200, "fieldLabel": "Pr\u00e9nom", "anchor": "-20", "name": "first_name" });
    var middle_name3102 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Middle name","Whatever this means...") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Middle name</span>", "name": "middle_name", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var last_name3103 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200, "fieldLabel": "Nom de famille", "anchor": "-20", "name": "last_name" });
    var p2_1_panel3104 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": first_name3101, "labelAlign": "top" }, { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": middle_name3102, "labelAlign": "top" }, { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": last_name3103, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 135, "border": false, "anchor": "-20", "labelAlign": "top" });
    var birth_date3108 = new Lino.IncompleteDateField({ "listeners": { "render": Lino.quicktip_renderer("date de naissance","Uncomplete dates are allowed, e.g. \n\"00.00.1980\" means \"some day in 1980\", \n\"00.07.1980\" means \"in July 1980\"\nor \"23.07.0000\" means \"on a 23th of July\".") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">date de naissance</span>", "name": "birth_date", "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var tolerance3109 = new Ext.form.NumberField({ "listeners": { "render": Lino.quicktip_renderer("Tol\u00e9rance","\n      Falls Monat oder Tag des Geburtsdatums unbekannt sind, \n      um wieviel Monate bzw. Tage die Suche nach unten/oben ausgeweitet wird.\n      G\u00fcltige Werte: 0 bis 10.\n      ") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Tol\u00e9rance</span>", "name": "tolerance", "selectOnFocus": true, "anchor": "-20", "value": 0, "allowBlank": false });
    var gender3110 = new Lino.ChoicesFieldElement({ "forceSelection": true, "fieldLabel": "Sexe", "name": "gender", "selectOnFocus": true, "anchor": "-20", "store": Lino.lino.Genders, "hiddenName": "genderHidden" });
    var p2_2_panel3111 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 46, "autoHeight": true, "layout": "form", "xtype": "panel", "items": birth_date3108, "labelAlign": "top" }, { "flex": 19, "autoHeight": true, "layout": "form", "xtype": "panel", "items": tolerance3109, "labelAlign": "top" }, { "flex": 34, "autoHeight": true, "layout": "form", "xtype": "panel", "items": gender3110, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 162, "border": false, "anchor": "-20", "labelAlign": "top" });
    var p2_panel3115 = new Ext.form.FieldSet({ "flex": 75, "autoHeight": true, "layout": "form", "title": "Recherche phon\u00e9tique", "items": [ p2_1_panel3104, p2_2_panel3111 ], "frame": true, "bodyBorder": false, "autoScroll": false, "hideCheckBoxLabels": true, "border": false, "labelAlign": "top" });
    var parameters_panel3116 = new Ext.form.FieldSet({ "autoHeight": true, "layout": "hbox", "title": "Param\u00e8tres", "layoutConfig": { "align": "stretchmax" }, "frame": false, "bodyBorder": true, "autoScroll": false, "items": [ p1_panel3099, p2_panel3115 ], "hideCheckBoxLabels": true, "border": false, "labelAlign": "top" });
    var IdentifyPersonResult_grid3126 = new Lino.cbss.IdentifyPersonResult.GridPanel({ "tools": [ Lino.show_in_own_window_button(Lino.cbss.IdentifyPersonResult.grid) ], "containing_panel": this, "hide_top_toolbar": true, "master_panel": this, "flex": 62 });
    var request_panel3127 = new Ext.Panel({ "layout": "vbox", "title": "Requ\u00eate", "items": [ info_1_panel3089, parameters_panel3116, IdentifyPersonResult_grid3126 ], "frame": true, "layoutConfig": { "align": "stretch" }, "hideCheckBoxLabels": true, "listeners": { "activate": Lino.on_tab_activate }, "autoScroll": false, "border": false, "bodyBorder": false, "labelAlign": "top" });
    var response_xml3128 = new Ext.form.TextArea({ "disabled": true, "listeners": { "render": Lino.quicktip_renderer("R\u00e9ponse","The raw XML response received. \n") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">R\u00e9ponse</span>", "name": "response_xml", "growMax": 2000, "anchor": "-20 -10" });
    var info_messages3129 = new Ext.form.TextArea({ "disabled": true, "fieldLabel": "Messages info", "anchor": "-20 -10", "growMax": 2000, "name": "info_messages" });
    var debug_messages3130 = new Ext.form.TextArea({ "disabled": true, "fieldLabel": "Messages debug", "anchor": "-20 -10", "growMax": 2000, "name": "debug_messages" });
    var technical_panel3131 = new Lino.VBorderPanel({ "autoScroll": false, "listeners": { "activate": Lino.on_tab_activate }, "border": false, "labelWidth": 135, "title": "Technique", "hideCheckBoxLabels": true, "items": [ { "flex": 5, "layout": "form", "xtype": "panel", "items": response_xml3128, "region": "north", "labelAlign": "top", "split": true }, { "flex": 5, "layout": "form", "xtype": "panel", "items": info_messages3129, "region": "center", "labelAlign": "top", "split": true }, { "flex": 5, "layout": "form", "xtype": "panel", "items": debug_messages3130, "region": "south", "labelAlign": "top", "split": true } ], "frame": true, "bodyBorder": false, "labelAlign": "top" });
    var main_panel3135 = new Ext.TabPanel({ "hideCheckBoxLabels": true, "border": false, "split": true, "autoScroll": false, "items": [ request_panel3127, technical_panel3131 ], "activeTab": 0, "bodyBorder": false, "frame": true, "labelAlign": "top" });
    this.items = main_panel3135;
    this.before_row_edit = function(record) {
      IdentifyPersonResult_grid3126.on_master_changed();
    }
    Lino.cbss.IdentifyPersonRequests.DetailFormPanel.superclass.initComponent.call(this);
    // active_fields:
    person3083.on("change",function(){this.save()},this);
  }
});


Lino.uploads.Uploads.InsertFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  autoHeight: true,
  content_type: 26,
  initComponent : function() {
    var containing_panel = this;
    var file1211 = Lino.file_field_handler(this,{ "fieldLabel": "File", "name": "file", "maxLength": 100, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var user1212 = new Lino.TwinCombo({ "fieldLabel": "Auteur", "name": "user", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.users.Users.detail)}, "emptyText": "Choisir Utilisateur...", "selectOnFocus": true, "hiddenName": "userHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/uploads/Uploads/user", "method": "GET" }) }) });
    var main_1_panel1213 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 58, "autoHeight": true, "layout": "form", "xtype": "panel", "items": file1211, "labelAlign": "top" }, { "flex": 41, "autoHeight": true, "layout": "form", "xtype": "panel", "items": user1212, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 63, "border": false, "anchor": "-20", "labelAlign": "top" });
    var type1216 = new Lino.RemoteComboFieldElement({ "fieldLabel": "Type d'upload", "name": "type", "pageSize": 20, "emptyText": "Choisir Type d'upload...", "selectOnFocus": true, "hiddenName": "typeHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/uploads/Uploads/type", "method": "GET" }) }) });
    var valid_until1217 = new Lino.DateField({ "selectOnFocus": true, "fieldLabel": "expire le", "anchor": "-20", "name": "valid_until" });
    var main_2_panel1218 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 71, "autoHeight": true, "layout": "form", "xtype": "panel", "items": type1216, "labelAlign": "top" }, { "flex": 28, "autoHeight": true, "layout": "form", "xtype": "panel", "items": valid_until1217, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 126, "border": false, "anchor": "-20", "labelAlign": "top" });
    var description1221 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200, "fieldLabel": "Description", "anchor": "-20", "name": "description" });
    var main_panel1222 = new Ext.Panel({ "hideCheckBoxLabels": true, "autoHeight": true, "border": false, "layout": "form", "labelWidth": 108, "autoScroll": false, "items": [ main_1_panel1213, main_2_panel1218, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": description1221, "anchor": "-20", "labelAlign": "top" } ], "frame": true, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel1222;
    this.before_row_edit = function(record) {
    }
    Lino.uploads.Uploads.InsertFormPanel.superclass.initComponent.call(this);
  }
});


Lino.contacts.Companies.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 20,
  initComponent : function() {
    var containing_panel = this;
    var prefix739 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200, "fieldLabel": "prefix", "anchor": "-20", "name": "prefix" });
    var name740 = new Ext.form.TextField({ "fieldLabel": "Name", "name": "name", "maxLength": 200, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var id741 = new Ext.form.NumberField({ "selectOnFocus": true, "fieldLabel": "ID", "anchor": "-20", "name": "id" });
    var language742 = new Lino.ChoicesFieldElement({ "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Langue</span>", "allowBlank": false, "value": "de", "hiddenName": "languageHidden", "listeners": { "render": Lino.quicktip_renderer("Langue","Die Sprache, in der Dokumente ausgestellt werden sollen.") }, "selectOnFocus": true, "anchor": "-20", "store": [ [ "de", "German" ], [ "fr", "French" ], [ "nl", "Dutch" ] ], "name": "language" });
    var intro_box_1_panel743 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 31, "autoHeight": true, "layout": "form", "xtype": "panel", "items": prefix739, "labelAlign": "top" }, { "flex": 31, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name740, "labelAlign": "top" }, { "flex": 7, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id741, "labelAlign": "top" }, { "flex": 29, "autoHeight": true, "layout": "form", "xtype": "panel", "items": language742, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 63, "border": false, "anchor": "-20", "labelAlign": "top" });
    var vat_id748 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200, "fieldLabel": "N\u00b0 de TVA", "anchor": "-20", "name": "vat_id" });
    var activity749 = new Lino.RemoteComboFieldElement({ "fieldLabel": "Activit\u00e9", "name": "activity", "pageSize": 20, "emptyText": "Choisir Activit\u00e9...", "selectOnFocus": true, "hiddenName": "activityHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/contacts/Companies/activity", "method": "GET" }) }) });
    var type750 = new Lino.RemoteComboFieldElement({ "fieldLabel": "Type de soci\u00e9t\u00e9", "name": "type", "pageSize": 20, "emptyText": "Choisir Type d'organisation...", "selectOnFocus": true, "hiddenName": "typeHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/contacts/Companies/type", "method": "GET" }) }) });
    var intro_box_2_panel751 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 23, "autoHeight": true, "layout": "form", "xtype": "panel", "items": vat_id748, "labelAlign": "top" }, { "flex": 38, "autoHeight": true, "layout": "form", "xtype": "panel", "items": activity749, "labelAlign": "top" }, { "flex": 38, "autoHeight": true, "layout": "form", "xtype": "panel", "items": type750, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 144, "border": false, "anchor": "-20", "labelAlign": "top" });
    var bank_account1755 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 40, "fieldLabel": "Compte en banque 1", "anchor": "-20", "name": "bank_account1" });
    var bank_account2756 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 40, "fieldLabel": "Compte en banque 2", "anchor": "-20", "name": "bank_account2" });
    var is_obsolete757 = new Ext.form.Checkbox({ "boxLabel": "obsolete", "listeners": { "render": Lino.quicktip_renderer("obsolete","Altf\u00e4lle sind Partner, deren Stammdaten nicht mehr gepflegt werden und \nf\u00fcr neue Operationen nicht benutzt werden k\u00f6nnen.") }, "hideLabel": true, "checked": false, "name": "is_obsolete", "selectOnFocus": true, "anchor": "-20" });
    var intro_box_3_panel758 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 40, "autoHeight": true, "layout": "form", "xtype": "panel", "items": bank_account1755, "labelAlign": "top" }, { "flex": 40, "autoHeight": true, "layout": "form", "xtype": "panel", "items": bank_account2756, "labelAlign": "top" }, { "flex": 19, "autoHeight": true, "layout": "form", "xtype": "panel", "items": is_obsolete757, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 171, "border": false, "anchor": "-20", "labelAlign": "top" });
    var intro_box_panel762 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "form", "hideCheckBoxLabels": true, "items": [ intro_box_1_panel743, intro_box_2_panel751, intro_box_3_panel758 ], "frame": true, "bodyBorder": false, "labelAlign": "top" });
    var country763 = new Lino.TwinCombo({ "fieldLabel": "Pays", "name": "country", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.countries.Countries.detail)}, "emptyText": "Choisir Pays...", "selectOnFocus": true, "hiddenName": "countryHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/contacts/Companies/country", "method": "GET" }) }) });
    var region764 = new Lino.TwinCombo({ "fieldLabel": "Region", "name": "region", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.countries.Cities.detail)}, "emptyText": "Choisir Place...", "selectOnFocus": true, "hiddenName": "regionHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/contacts/Companies/region", "method": "GET" }) }) });
    var box3_1_panel765 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": country763, "labelAlign": "top" }, { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": region764, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 63, "border": false, "anchor": "-20", "labelAlign": "top" });
    var city768 = new Lino.TwinCombo({ "forceSelection": false, "fieldLabel": "Place", "name": "city", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.countries.Cities.detail)}, "emptyText": "Choisir Place...", "selectOnFocus": true, "hiddenName": "cityHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/contacts/Companies/city", "method": "GET" }) }) });
    var zip_code769 = new Ext.form.TextField({ "fieldLabel": "Zip code", "name": "zip_code", "maxLength": 10, "selectOnFocus": true, "boxMinWidth": Lino.chars2width(10), "anchor": "-20" });
    var box3_2_panel770 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 66, "autoHeight": true, "layout": "form", "xtype": "panel", "items": city768, "labelAlign": "top" }, { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": zip_code769, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 81, "border": false, "anchor": "-20", "labelAlign": "top" });
    var street_prefix773 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Pr\u00e9fixe rue","Text to print before name of street, but to ignore for sorting.") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Pr\u00e9fixe rue</span>", "name": "street_prefix", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var street774 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Rue","Name of street. Without house number.") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Rue</span>", "name": "street", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var street_no775 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("N\u00b0","House number") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">N\u00b0</span>", "name": "street_no", "maxLength": 10, "selectOnFocus": true, "boxMinWidth": Lino.chars2width(10), "anchor": "-20" });
    var street_box776 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("bo\u00eete","Text to print after :attr:`steet_no` on the same line") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">bo\u00eete</span>", "name": "street_box", "maxLength": 10, "selectOnFocus": true, "boxMinWidth": Lino.chars2width(10), "anchor": "-20" });
    var box3_3_panel777 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 30, "autoHeight": true, "layout": "form", "xtype": "panel", "items": street_prefix773, "labelAlign": "top" }, { "flex": 36, "autoHeight": true, "layout": "form", "xtype": "panel", "items": street774, "labelAlign": "top" }, { "flex": 16, "autoHeight": true, "layout": "form", "xtype": "panel", "items": street_no775, "labelAlign": "top" }, { "flex": 16, "autoHeight": true, "layout": "form", "xtype": "panel", "items": street_box776, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 108, "border": false, "anchor": "-20", "labelAlign": "top" });
    var addr2782 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Ligne apr\u00e8s le nom de rue","Address line to print below street line") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Ligne apr\u00e8s le nom de rue</span>", "name": "addr2", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var box3_panel783 = new Ext.Panel({ "flex": 62, "autoHeight": true, "layout": "form", "items": [ box3_1_panel765, box3_2_panel770, box3_3_panel777, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": addr2782, "anchor": "-20", "labelAlign": "top" } ], "frame": true, "bodyBorder": false, "autoScroll": false, "hideCheckBoxLabels": true, "labelWidth": 234, "border": false, "labelAlign": "top" });
    var email785 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 75, "fieldLabel": "E-mail", "anchor": "-20", "name": "email" });
    var url786 = new Lino.URLField({ "selectOnFocus": true, "maxLength": 200, "fieldLabel": "URL", "anchor": "-20", "name": "url" });
    var phone787 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200, "fieldLabel": "T\u00e9l\u00e9phone", "anchor": "-20", "name": "phone" });
    var gsm788 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200, "fieldLabel": "GSM", "anchor": "-20", "name": "gsm" });
    var box4_panel789 = new Ext.Panel({ "flex": 37, "autoHeight": true, "layout": "form", "items": [ { "autoHeight": true, "layout": "form", "xtype": "panel", "items": email785, "anchor": "-20", "labelAlign": "top" }, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": url786, "anchor": "-20", "labelAlign": "top" }, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": phone787, "anchor": "-20", "labelAlign": "top" }, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": gsm788, "anchor": "-20", "labelAlign": "top" } ], "frame": true, "bodyBorder": false, "autoScroll": false, "hideCheckBoxLabels": true, "labelWidth": 90, "border": false, "labelAlign": "top" });
    var address_box_panel794 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "hideCheckBoxLabels": true, "items": [ box3_panel783, box4_panel789 ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var remarks795 = new Ext.form.TextArea({ "selectOnFocus": true, "fieldLabel": "Remarques", "anchor": "-20 -10", "growMax": 2000, "name": "remarks" });
    var is_courseprovider796 = new Ext.form.Checkbox({ "selectOnFocus": true, "boxLabel": "est un organisateur de cours (<a href=\"javascript:Lino.show_mti_child('is_courseprovider',Lino.courses.CourseProviders.detail)\">montrer</a>)", "hideLabel": true, "anchor": "-20", "name": "is_courseprovider" });
    var is_jobprovider797 = new Ext.form.Checkbox({ "selectOnFocus": true, "boxLabel": "est Employant (<a href=\"javascript:Lino.show_mti_child('is_jobprovider',Lino.jobs.JobProviders.detail)\">montrer</a>)", "hideLabel": true, "anchor": "-20", "name": "is_jobprovider" });
    var client_contact_type798 = new Lino.RemoteComboFieldElement({ "fieldLabel": "Type de contact client", "name": "client_contact_type", "pageSize": 20, "emptyText": "Choisir Type de contact client...", "selectOnFocus": true, "hiddenName": "client_contact_typeHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/contacts/Companies/client_contact_type", "method": "GET" }) }) });
    var box5_2_panel799 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 261, "hideCheckBoxLabels": true, "items": [ { "flex": 25, "autoHeight": true, "layout": "form", "xtype": "panel", "items": is_courseprovider796, "labelAlign": "top" }, { "flex": 25, "autoHeight": true, "layout": "form", "xtype": "panel", "items": is_jobprovider797, "labelAlign": "top" }, { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": client_contact_type798, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var box5_panel803 = new Ext.Panel({ "flex": 57, "layout": "vbox", "items": [ { "items": remarks795, "labelAlign": "top", "layout": "form", "xtype": "panel", "flex": 83 }, box5_2_panel799 ], "frame": true, "layoutConfig": { "align": "stretch" }, "autoScroll": false, "hideCheckBoxLabels": true, "labelWidth": 90, "border": false, "bodyBorder": false, "labelAlign": "top" });
    var contacts_RolesByCompany_grid809 = new Lino.contacts.RolesByCompany.GridPanel({ "tools": [ Lino.show_in_own_window_button(Lino.contacts.RolesByCompany.grid) ], "containing_panel": this, "hide_top_toolbar": true, "master_panel": this, "flex": 42 });
    var bottom_box_panel810 = new Ext.Panel({ "flex": 46, "border": false, "layout": "hbox", "hideCheckBoxLabels": true, "items": [ box5_panel803, contacts_RolesByCompany_grid809 ], "autoScroll": false, "layoutConfig": { "align": "stretch" }, "frame": false, "labelAlign": "top" });
    var general_panel811 = new Ext.Panel({ "layout": "vbox", "title": "G\u00e9n\u00e9ral", "items": [ intro_box_panel762, address_box_panel794, bottom_box_panel810 ], "frame": true, "layoutConfig": { "align": "stretch" }, "hideCheckBoxLabels": true, "listeners": { "activate": Lino.on_tab_activate }, "autoScroll": false, "border": false, "bodyBorder": false, "labelAlign": "top" });
    var pcsw_NotesByCompany_grid931 = new Lino.pcsw.NotesByCompany.GridPanel({ "listeners": { "activate": Lino.on_tab_activate }, "hide_top_toolbar": true, "title": "Events/Notes", "containing_panel": this, "tools": [ Lino.show_in_own_window_button(Lino.pcsw.NotesByCompany.grid) ], "master_panel": this });
    var main_panel932 = new Ext.TabPanel({ "hideCheckBoxLabels": true, "border": false, "split": true, "autoScroll": false, "items": [ general_panel811, pcsw_NotesByCompany_grid931 ], "activeTab": 0, "bodyBorder": false, "frame": true, "labelAlign": "top" });
    this.items = main_panel932;
    this.before_row_edit = function(record) {
      region764.setContextValue('country',record ? record.data['countryHidden'] : undefined);
      city768.setContextValue('country',record ? record.data['countryHidden'] : undefined);
      city768.setContextValue('region',record ? record.data['regionHidden'] : undefined);
      contacts_RolesByCompany_grid809.on_master_changed();
      pcsw_NotesByCompany_grid931.on_master_changed();
    }
    this.onRender = function(ct, position) {
      country763.on('change',Lino.chooser_handler(region764,'country'));
      country763.on('change',Lino.chooser_handler(city768,'country'));
      region764.on('change',Lino.chooser_handler(city768,'region'));
      Lino.contacts.Companies.DetailFormPanel.superclass.onRender.call(this, ct, position);
    }
    Lino.contacts.Companies.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.ui.SiteConfigs.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 3,
  initComponent : function() {
    var containing_panel = this;
    var site_company63 = new Lino.TwinCombo({ "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">La soci\u00e9t\u00e9 ou tourne ce site</span>", "name": "site_company", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.contacts.Companies.detail)}, "emptyText": "Choisir Organisation...", "listeners": { "render": Lino.quicktip_renderer("La soci\u00e9t\u00e9 ou tourne ce site","The Company to be used as sender in documents.") }, "selectOnFocus": true, "hiddenName": "site_companyHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/ui/SiteConfigs/site_company", "method": "GET" }) }) });
    var system_note_type64 = new Lino.TwinCombo({ "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Default system note type</span>", "name": "system_note_type", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.notes.EventTypes.detail)}, "emptyText": "Choisir Event Type...", "listeners": { "render": Lino.quicktip_renderer("Default system note type","Note Type used by system notes.\nIf this is empty, then system notes won't create any entry to the Notes table.") }, "selectOnFocus": true, "hiddenName": "system_note_typeHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/ui/SiteConfigs/system_note_type", "method": "GET" }) }) });
    var default_build_method65 = new Lino.ChoicesFieldElement({ "store": [ [ "appyodt", "AppyOdtBuildMethod" ], [ "appypdf", "AppyPdfBuildMethod" ], [ "appyrtf", "AppyRtfBuildMethod" ], [ "latex", "LatexBuildMethod" ], [ "pisa", "PisaBuildMethod" ], [ "rtf", "RtfBuildMethod" ] ], "fieldLabel": "M\u00e9thode de constuction par d\u00e9fault", "name": "default_build_method", "selectOnFocus": true, "anchor": "-20", "value": "appyodt", "hiddenName": "default_build_methodHidden" });
    var general_1_panel66 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": site_company63, "labelAlign": "top" }, { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": system_note_type64, "labelAlign": "top" }, { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": default_build_method65, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 315, "border": false, "anchor": "-20", "labelAlign": "top" });
    var next_partner_id70 = new Ext.form.NumberField({ "fieldLabel": "The next automatic id for a manually created partner.", "name": "next_partner_id", "selectOnFocus": true, "anchor": "-20", "value": 100, "allowBlank": false });
    var job_office71 = new Lino.TwinCombo({ "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Agence locale pour l'emploi ?</span>", "name": "job_office", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.contacts.Companies.detail)}, "emptyText": "Choisir Organisation...", "listeners": { "render": Lino.quicktip_renderer("Agence locale pour l'emploi ?","The Company whose contact persons \n            will be choices for `Person.job_office_contact`.") }, "selectOnFocus": true, "hiddenName": "job_officeHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/ui/SiteConfigs/job_office", "method": "GET" }) }) });
    var debts_bailiff_type72 = new Lino.RemoteComboFieldElement({ "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Bailiff</span>", "name": "debts_bailiff_type", "pageSize": 20, "emptyText": "Choisir Type de contact client...", "listeners": { "render": Lino.quicktip_renderer("Bailiff","Client contact type for Bailiff.") }, "selectOnFocus": true, "hiddenName": "debts_bailiff_typeHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/ui/SiteConfigs/debts_bailiff_type", "method": "GET" }) }) });
    var master_budget73 = new Lino.TwinCombo({ "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Master budget</span>", "name": "master_budget", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.debts.Budgets.detail)}, "emptyText": "Choisir Budget...", "listeners": { "render": Lino.quicktip_renderer("Master budget","The budget whose content is to be copied into new budgets.") }, "selectOnFocus": true, "hiddenName": "master_budgetHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/ui/SiteConfigs/master_budget", "method": "GET" }) }) });
    var general_2_panel74 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 25, "autoHeight": true, "layout": "form", "xtype": "panel", "items": next_partner_id70, "labelAlign": "top" }, { "flex": 25, "autoHeight": true, "layout": "form", "xtype": "panel", "items": job_office71, "labelAlign": "top" }, { "flex": 25, "autoHeight": true, "layout": "form", "xtype": "panel", "items": debts_bailiff_type72, "labelAlign": "top" }, { "flex": 25, "autoHeight": true, "layout": "form", "xtype": "panel", "items": master_budget73, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 486, "border": false, "anchor": "-20", "labelAlign": "top" });
    var signer179 = new Lino.TwinCombo({ "fieldLabel": "Secr\u00e9taire", "name": "signer1", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.contacts.Persons.detail)}, "emptyText": "Choisir Personne...", "selectOnFocus": true, "hiddenName": "signer1Hidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/ui/SiteConfigs/signer1", "method": "GET" }) }) });
    var signer280 = new Lino.TwinCombo({ "fieldLabel": "President", "name": "signer2", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.contacts.Persons.detail)}, "emptyText": "Choisir Personne...", "selectOnFocus": true, "hiddenName": "signer2Hidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/ui/SiteConfigs/signer2", "method": "GET" }) }) });
    var general_3_panel81 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": signer179, "labelAlign": "top" }, { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": signer280, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 99, "border": false, "anchor": "-20", "labelAlign": "top" });
    var signer1_function84 = new Lino.RemoteComboFieldElement({ "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">First signer function</span>", "name": "signer1_function", "pageSize": 20, "emptyText": "Choisir Fonction...", "listeners": { "render": Lino.quicktip_renderer("First signer function","Contact function to designate the secretary.") }, "selectOnFocus": true, "hiddenName": "signer1_functionHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/ui/SiteConfigs/signer1_function", "method": "GET" }) }) });
    var signer2_function85 = new Lino.RemoteComboFieldElement({ "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Second signer function</span>", "name": "signer2_function", "pageSize": 20, "emptyText": "Choisir Fonction...", "listeners": { "render": Lino.quicktip_renderer("Second signer function","Contact function to designate the president.") }, "selectOnFocus": true, "hiddenName": "signer2_functionHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/ui/SiteConfigs/signer2_function", "method": "GET" }) }) });
    var general_4_panel86 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": signer1_function84, "labelAlign": "top" }, { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": signer2_function85, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 207, "border": false, "anchor": "-20", "labelAlign": "top" });
    var propgroup_skills89 = new Lino.TwinCombo({ "fieldLabel": "Groupe de propri\u00e9t\u00e9s 'Skills'", "name": "propgroup_skills", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.properties.PropGroups.detail)}, "emptyText": "Choisir Groupe de propri\u00e9t\u00e9s...", "selectOnFocus": true, "hiddenName": "propgroup_skillsHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/ui/SiteConfigs/propgroup_skills", "method": "GET" }) }) });
    var propgroup_softskills90 = new Lino.TwinCombo({ "fieldLabel": "Groupe de propri\u00e9t\u00e9s 'Soft Skills'", "name": "propgroup_softskills", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.properties.PropGroups.detail)}, "emptyText": "Choisir Groupe de propri\u00e9t\u00e9s...", "selectOnFocus": true, "hiddenName": "propgroup_softskillsHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/ui/SiteConfigs/propgroup_softskills", "method": "GET" }) }) });
    var propgroup_obstacles91 = new Lino.TwinCombo({ "fieldLabel": "Groupe de propri\u00e9t\u00e9s 'Obstacles'", "name": "propgroup_obstacles", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.properties.PropGroups.detail)}, "emptyText": "Choisir Groupe de propri\u00e9t\u00e9s...", "selectOnFocus": true, "hiddenName": "propgroup_obstaclesHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/ui/SiteConfigs/propgroup_obstacles", "method": "GET" }) }) });
    var constants_1_panel92 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": propgroup_skills89, "labelAlign": "top" }, { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": propgroup_softskills90, "labelAlign": "top" }, { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": propgroup_obstacles91, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 315, "border": false, "anchor": "-20", "labelAlign": "top" });
    var residence_permit_upload_type96 = new Lino.RemoteComboFieldElement({ "fieldLabel": "Type d'upload \"permis de r\u00e9sidence\"", "name": "residence_permit_upload_type", "pageSize": 20, "emptyText": "Choisir Type d'upload...", "selectOnFocus": true, "hiddenName": "residence_permit_upload_typeHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/ui/SiteConfigs/residence_permit_upload_type", "method": "GET" }) }) });
    var work_permit_upload_type97 = new Lino.RemoteComboFieldElement({ "fieldLabel": "Type d'upload \"permis de travail\"", "name": "work_permit_upload_type", "pageSize": 20, "emptyText": "Choisir Type d'upload...", "selectOnFocus": true, "hiddenName": "work_permit_upload_typeHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/ui/SiteConfigs/work_permit_upload_type", "method": "GET" }) }) });
    var driving_licence_upload_type98 = new Lino.RemoteComboFieldElement({ "fieldLabel": "Type d'upload \"permis de conduire\"", "name": "driving_licence_upload_type", "pageSize": 20, "emptyText": "Choisir Type d'upload...", "selectOnFocus": true, "hiddenName": "driving_licence_upload_typeHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/ui/SiteConfigs/driving_licence_upload_type", "method": "GET" }) }) });
    var constants_2_panel99 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": residence_permit_upload_type96, "labelAlign": "top" }, { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": work_permit_upload_type97, "labelAlign": "top" }, { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": driving_licence_upload_type98, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 324, "border": false, "anchor": "-20", "labelAlign": "top" });
    var constants_panel103 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "form", "hideCheckBoxLabels": true, "items": [ constants_1_panel92, constants_2_panel99 ], "frame": true, "bodyBorder": false, "anchor": "-20", "labelAlign": "top" });
    var general_panel104 = new Ext.Panel({ "autoHeight": true, "layout": "form", "title": "G\u00e9n\u00e9ral", "items": [ general_1_panel66, general_2_panel74, general_3_panel81, general_4_panel86, constants_panel103 ], "frame": true, "bodyBorder": false, "hideCheckBoxLabels": true, "listeners": { "activate": Lino.on_tab_activate }, "autoScroll": false, "border": false, "labelAlign": "top" });
    var cbss_org_unit105 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Requesting organisation","In CBSS requests, identifies the requesting organization.\nFor PCSWs this is the enterprise number \n(CBE, KBO) and should have 10 digits and no formatting characters.\n\nUsed in SSDN requests as text of the `AuthorizedUser\\OrgUnit` element . \nUsed in new style requests as text of the `CustomerIdentification\\cbeNumber` element . \n") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Requesting organisation</span>", "name": "cbss_org_unit", "maxLength": 50, "selectOnFocus": true, "anchor": "-20" });
    var sector106 = new Lino.RemoteComboFieldElement({ "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Secteur</span>", "name": "sector", "pageSize": 20, "emptyText": "Choisir Secteur...", "listeners": { "render": Lino.quicktip_renderer("Secteur","The CBSS sector/subsector of the requesting organization.        \nFor PCSWs this is always 17.1.\nUsed in SSDN requests as text of the `MatrixID` and `MatrixSubID` \nelements of `AuthorizedUser`. \nUsed in ManageAccess requests as default value \nfor the non-editable field `sector` \n(which defines the choices of the `purpose` field).\n") }, "selectOnFocus": true, "hiddenName": "sectorHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/ui/SiteConfigs/sector", "method": "GET" }) }) });
    var ssdn_user_id107 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("SSDN User Id","Used in SSDN requests as text of the `AuthorizedUser\\UserID` element.\n") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">SSDN User Id</span>", "name": "ssdn_user_id", "maxLength": 50, "selectOnFocus": true, "anchor": "-20" });
    var ssdn_email108 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("SSDN email address","Used in SSDN requests as text of the `AuthorizedUser\\Email` element.\n") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">SSDN email address</span>", "name": "ssdn_email", "maxLength": 75, "selectOnFocus": true, "anchor": "-20" });
    var cbss_1_panel109 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 25, "autoHeight": true, "layout": "form", "xtype": "panel", "items": cbss_org_unit105, "labelAlign": "top" }, { "flex": 24, "autoHeight": true, "layout": "form", "xtype": "panel", "items": sector106, "labelAlign": "top" }, { "flex": 25, "autoHeight": true, "layout": "form", "xtype": "panel", "items": ssdn_user_id107, "labelAlign": "top" }, { "flex": 25, "autoHeight": true, "layout": "form", "xtype": "panel", "items": ssdn_email108, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 216, "border": false, "anchor": "-20", "labelAlign": "top" });
    var cbss_http_username114 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("HTTP username","Used in the http header of new-style requests.\n") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">HTTP username</span>", "name": "cbss_http_username", "maxLength": 50, "selectOnFocus": true, "anchor": "-20" });
    var cbss_http_password115 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("HTTP password","Used in the http header of new-style requests.\n") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">HTTP password</span>", "name": "cbss_http_password", "maxLength": 50, "selectOnFocus": true, "anchor": "-20" });
    var cbss_2_panel116 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": cbss_http_username114, "labelAlign": "top" }, { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": cbss_http_password115, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 126, "border": false, "anchor": "-20", "labelAlign": "top" });
    var cbss_panel119 = new Ext.Panel({ "autoHeight": true, "layout": "form", "title": "BCSS", "items": [ cbss_1_panel109, cbss_2_panel116 ], "frame": true, "bodyBorder": false, "hideCheckBoxLabels": true, "listeners": { "activate": Lino.on_tab_activate }, "autoScroll": false, "border": false, "labelAlign": "top" });
    var main_panel120 = new Ext.TabPanel({ "hideCheckBoxLabels": true, "border": false, "split": true, "autoScroll": false, "items": [ general_panel104, cbss_panel119 ], "activeTab": 0, "bodyBorder": false, "frame": true, "labelAlign": "top" });
    this.items = main_panel120;
    this.before_row_edit = function(record) {
    }
    Lino.ui.SiteConfigs.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.debts.Budgets.InsertFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  autoHeight: true,
  content_type: 84,
  initComponent : function() {
    var containing_panel = this;
    var partner636 = new Lino.TwinCombo({ "fieldLabel": "Partenaire", "allowBlank": false, "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.contacts.Partners.detail)}, "emptyText": "Choisir Partenaire...", "selectOnFocus": true, "hiddenName": "partnerHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/debts/Budgets/partner", "method": "GET" }) }), "name": "partner" });
    var date637 = new Lino.DateField({ "selectOnFocus": true, "fieldLabel": "Date", "anchor": "-20", "name": "date" });
    var user638 = new Lino.TwinCombo({ "fieldLabel": "Auteur", "name": "user", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.users.Users.detail)}, "emptyText": "Choisir Utilisateur...", "selectOnFocus": true, "hiddenName": "userHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/debts/Budgets/user", "method": "GET" }) }) });
    var main_2_panel639 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 34, "autoHeight": true, "layout": "form", "xtype": "panel", "items": date637, "labelAlign": "top" }, { "flex": 65, "autoHeight": true, "layout": "form", "xtype": "panel", "items": user638, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 63, "border": false, "anchor": "-20", "labelAlign": "top" });
    var main_panel642 = new Ext.Panel({ "hideCheckBoxLabels": true, "autoHeight": true, "border": false, "layout": "form", "labelWidth": 99, "autoScroll": false, "items": [ { "autoHeight": true, "layout": "form", "xtype": "panel", "items": partner636, "anchor": "-20", "labelAlign": "top" }, main_2_panel639 ], "frame": true, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel642;
    this.before_row_edit = function(record) {
    }
    Lino.debts.Budgets.InsertFormPanel.superclass.initComponent.call(this);
  }
});


Lino.contacts.Persons.InsertFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  autoHeight: true,
  content_type: 21,
  initComponent : function() {
    var containing_panel = this;
    var title1536 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200, "fieldLabel": "Allocution", "anchor": "-20", "name": "title" });
    var first_name1537 = new Ext.form.TextField({ "fieldLabel": "Pr\u00e9nom", "name": "first_name", "maxLength": 200, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var last_name1538 = new Ext.form.TextField({ "fieldLabel": "Nom de famille", "name": "last_name", "maxLength": 200, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var main_1_panel1539 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": title1536, "labelAlign": "top" }, { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": first_name1537, "labelAlign": "top" }, { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": last_name1538, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 135, "border": false, "anchor": "-20", "labelAlign": "top" });
    var gender1543 = new Lino.ChoicesFieldElement({ "forceSelection": true, "fieldLabel": "Sexe", "name": "gender", "selectOnFocus": true, "anchor": "-20", "store": Lino.lino.Genders, "hiddenName": "genderHidden" });
    var language1544 = new Lino.ChoicesFieldElement({ "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Langue</span>", "allowBlank": false, "value": "de", "hiddenName": "languageHidden", "listeners": { "render": Lino.quicktip_renderer("Langue","Die Sprache, in der Dokumente ausgestellt werden sollen.") }, "selectOnFocus": true, "anchor": "-20", "store": [ [ "de", "German" ], [ "fr", "French" ], [ "nl", "Dutch" ] ], "name": "language" });
    var main_2_panel1545 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 31, "autoHeight": true, "layout": "form", "xtype": "panel", "items": gender1543, "labelAlign": "top" }, { "flex": 68, "autoHeight": true, "layout": "form", "xtype": "panel", "items": language1544, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 63, "border": false, "anchor": "-20", "labelAlign": "top" });
    var main_panel1548 = new Ext.Panel({ "hideCheckBoxLabels": true, "autoHeight": true, "border": false, "layout": "form", "autoScroll": false, "items": [ main_1_panel1539, main_2_panel1545 ], "frame": true, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel1548;
    this.before_row_edit = function(record) {
    }
    Lino.contacts.Persons.InsertFormPanel.superclass.initComponent.call(this);
  }
});


Lino.cal.Calendars.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 35,
  initComponent : function() {
    var containing_panel = this;
    var type946 = new Lino.ChoicesFieldElement({ "fieldLabel": "Type", "allowBlank": false, "value": "local", "hiddenName": "typeHidden", "selectOnFocus": true, "anchor": "-20", "store": [ [ "local", "Local Calendar" ], [ "google", "Google Calendar" ] ], "name": "type" });
    var name947 = new Ext.form.TextField({ "fieldLabel": "Description", "name": "name", "maxLength": 200, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var name_fr948 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200, "fieldLabel": "Description (fr)", "anchor": "-20", "name": "name_fr" });
    var name_nl949 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200, "fieldLabel": "Description (nl)", "anchor": "-20", "name": "name_nl" });
    var id950 = new Ext.form.NumberField({ "selectOnFocus": true, "fieldLabel": "ID", "anchor": "-20", "name": "id" });
    var main_1_panel951 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 153, "hideCheckBoxLabels": true, "items": [ { "flex": 22, "autoHeight": true, "layout": "form", "xtype": "panel", "items": type946, "labelAlign": "top" }, { "flex": 23, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name947, "labelAlign": "top" }, { "flex": 23, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_fr948, "labelAlign": "top" }, { "flex": 23, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_nl949, "labelAlign": "top" }, { "flex": 5, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id950, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var url_template957 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200, "fieldLabel": "URL template", "anchor": "-20", "name": "url_template" });
    var username958 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200, "fieldLabel": "Username", "anchor": "-20", "name": "username" });
    var password959 = new Ext.form.TextField({ "fieldLabel": "Password", "name": "password", "maxLength": 200, "selectOnFocus": true, "anchor": "-20", "inputType": "password" });
    var main_2_panel960 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 117, "hideCheckBoxLabels": true, "items": [ { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": url_template957, "labelAlign": "top" }, { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": username958, "labelAlign": "top" }, { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": password959, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var readonly964 = new Ext.form.Checkbox({ "boxLabel": "read-only", "hideLabel": true, "checked": false, "name": "readonly", "selectOnFocus": true, "anchor": "-20" });
    var invite_team_members965 = new Lino.RemoteComboFieldElement({ "fieldLabel": "Team", "name": "invite_team_members", "pageSize": 20, "emptyText": "Choisir Team...", "selectOnFocus": true, "hiddenName": "invite_team_membersHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/Calendars/invite_team_members", "method": "GET" }) }) });
    var color966 = new Ext.form.NumberField({ "fieldLabel": "Couleur", "name": "color", "selectOnFocus": true, "anchor": "-20", "value": 1, "allowBlank": false });
    var start_date967 = new Lino.DateField({ "selectOnFocus": true, "fieldLabel": "Date d\u00e9but", "anchor": "-20", "name": "start_date" });
    var main_3_panel968 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 99, "hideCheckBoxLabels": true, "items": [ { "flex": 23, "autoHeight": true, "layout": "form", "xtype": "panel", "items": readonly964, "labelAlign": "top" }, { "flex": 46, "autoHeight": true, "layout": "form", "xtype": "panel", "items": invite_team_members965, "labelAlign": "top" }, { "flex": 11, "autoHeight": true, "layout": "form", "xtype": "panel", "items": color966, "labelAlign": "top" }, { "flex": 18, "autoHeight": true, "layout": "form", "xtype": "panel", "items": start_date967, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var build_method973 = new Lino.ChoicesFieldElement({ "fieldLabel": "M\u00e9thode de construction", "name": "build_method", "selectOnFocus": true, "anchor": "-20", "store": [ [ "appyodt", "AppyOdtBuildMethod" ], [ "appypdf", "AppyPdfBuildMethod" ], [ "appyrtf", "AppyRtfBuildMethod" ], [ "latex", "LatexBuildMethod" ], [ "pisa", "PisaBuildMethod" ], [ "rtf", "RtfBuildMethod" ] ], "hiddenName": "build_methodHidden" });
    var template974 = new Lino.SimpleRemoteComboFieldElement({ "selectOnFocus": true, "fieldLabel": "Mod\u00e8le", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/Calendars/template", "method": "GET" }) }), "name": "template" });
    var email_template975 = new Lino.SimpleRemoteComboFieldElement({ "listeners": { "render": Lino.quicktip_renderer("Email template","The name of the file to be used as template \nwhen creating an email from a mailable of this type.\n") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Email template</span>", "name": "email_template", "selectOnFocus": true, "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/Calendars/email_template", "method": "GET" }) }) });
    var attach_to_email976 = new Ext.form.Checkbox({ "boxLabel": "Attach to email", "listeners": { "render": Lino.quicktip_renderer("Attach to email","Whether the printable file should be attached to the email\nwhen creating an email from a mailable of this type.\n") }, "hideLabel": true, "checked": false, "name": "attach_to_email", "selectOnFocus": true, "anchor": "-20" });
    var main_4_panel977 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 216, "hideCheckBoxLabels": true, "items": [ { "flex": 40, "autoHeight": true, "layout": "form", "xtype": "panel", "items": build_method973, "labelAlign": "top" }, { "flex": 20, "autoHeight": true, "layout": "form", "xtype": "panel", "items": template974, "labelAlign": "top" }, { "flex": 20, "autoHeight": true, "layout": "form", "xtype": "panel", "items": email_template975, "labelAlign": "top" }, { "flex": 20, "autoHeight": true, "layout": "form", "xtype": "panel", "items": attach_to_email976, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var EventsByCalendar_grid1102 = new Lino.cal.EventsByCalendar.GridPanel({ "flex": 80, "hide_top_toolbar": true, "containing_panel": this, "params_panel_hidden": true, "tools": [ Lino.show_in_own_window_button(Lino.cal.EventsByCalendar.grid) ], "master_panel": this });
    var SubscriptionsByCalendar_grid1107 = new Lino.cal.SubscriptionsByCalendar.GridPanel({ "tools": [ Lino.show_in_own_window_button(Lino.cal.SubscriptionsByCalendar.grid) ], "containing_panel": this, "hide_top_toolbar": true, "master_panel": this, "flex": 20 });
    var main_5_panel1108 = new Ext.Panel({ "flex": 55, "border": false, "layout": "hbox", "hideCheckBoxLabels": true, "items": [ EventsByCalendar_grid1102, SubscriptionsByCalendar_grid1107 ], "autoScroll": false, "layoutConfig": { "align": "stretch" }, "frame": false, "labelAlign": "top" });
    var main_panel1109 = new Ext.Panel({ "autoScroll": false, "border": false, "layout": "vbox", "hideCheckBoxLabels": true, "items": [ main_1_panel951, main_2_panel960, main_3_panel968, main_4_panel977, main_5_panel1108 ], "frame": true, "layoutConfig": { "align": "stretch" }, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel1109;
    this.before_row_edit = function(record) {
      template974.setContextValue('build_method',record ? record.data['build_methodHidden'] : undefined);
      EventsByCalendar_grid1102.on_master_changed();
      SubscriptionsByCalendar_grid1107.on_master_changed();
    }
    this.onRender = function(ct, position) {
      build_method973.on('change',Lino.chooser_handler(template974,'build_method'));
      Lino.cal.Calendars.DetailFormPanel.superclass.onRender.call(this, ct, position);
    }
    Lino.cal.Calendars.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.countries.Languages.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 12,
  initComponent : function() {
    var containing_panel = this;
    var id352 = new Ext.form.TextField({ "fieldLabel": "id", "name": "id", "maxLength": 3, "selectOnFocus": true, "boxMinWidth": Lino.chars2width(3), "anchor": "-20", "allowBlank": false });
    var iso2353 = new Ext.form.TextField({ "fieldLabel": "iso2", "name": "iso2", "maxLength": 2, "selectOnFocus": true, "boxMinWidth": Lino.chars2width(2), "anchor": "-20" });
    var name354 = new Ext.form.TextField({ "fieldLabel": "Description", "name": "name", "maxLength": 200, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var name_fr355 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200, "fieldLabel": "Description (fr)", "anchor": "-20", "name": "name_fr" });
    var name_nl356 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200, "fieldLabel": "Description (nl)", "anchor": "-20", "name": "name_nl" });
    var main_1_panel357 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 153, "hideCheckBoxLabels": true, "items": [ { "flex": 5, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id352, "labelAlign": "top" }, { "flex": 5, "autoHeight": true, "layout": "form", "xtype": "panel", "items": iso2353, "labelAlign": "top" }, { "flex": 29, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name354, "labelAlign": "top" }, { "flex": 29, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_fr355, "labelAlign": "top" }, { "flex": 29, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_nl356, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var cv_KnowledgesByLanguage_grid369 = new Lino.cv.KnowledgesByLanguage.GridPanel({ "tools": [ Lino.show_in_own_window_button(Lino.cv.KnowledgesByLanguage.grid) ], "containing_panel": this, "hide_top_toolbar": true, "master_panel": this, "flex": 83 });
    var main_panel370 = new Ext.Panel({ "autoScroll": false, "border": false, "layout": "vbox", "hideCheckBoxLabels": true, "items": [ main_1_panel357, cv_KnowledgesByLanguage_grid369 ], "frame": true, "layoutConfig": { "align": "stretch" }, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel370;
    this.before_row_edit = function(record) {
      cv_KnowledgesByLanguage_grid369.on_master_changed();
    }
    Lino.countries.Languages.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.courses.CourseRequests.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 75,
  initComponent : function() {
    var containing_panel = this;
    var date_submitted1789 = new Lino.DateField({ "listeners": { "render": Lino.quicktip_renderer("Date d\u00e9ntr\u00e9e","When this request has been submitted.") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Date d\u00e9ntr\u00e9e</span>", "name": "date_submitted", "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var person1790 = new Lino.TwinCombo({ "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Client</span>", "allowBlank": false, "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.pcsw.Clients.detail)}, "emptyText": "Choisir Client...", "listeners": { "render": Lino.quicktip_renderer("Client","Le client qui d\u00e9sire suivre un cours.") }, "selectOnFocus": true, "hiddenName": "personHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/courses/CourseRequests/person", "method": "GET" }) }), "name": "person" });
    var content1791 = new Lino.TwinCombo({ "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Contenu</span>", "allowBlank": false, "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.courses.CourseContents.detail)}, "emptyText": "Choisir Contenu de cours...", "listeners": { "render": Lino.quicktip_renderer("Contenu","Der gew\u00fcnschte Kursinhalt.)") }, "selectOnFocus": true, "hiddenName": "contentHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/courses/CourseRequests/content", "method": "GET" }) }), "name": "content" });
    var offer1792 = new Lino.TwinCombo({ "fieldLabel": "Offre de cours", "name": "offer", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.courses.CourseOffers.detail)}, "emptyText": "Choisir Offre de cours...", "selectOnFocus": true, "hiddenName": "offerHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/courses/CourseRequests/offer", "method": "GET" }) }) });
    var urgent1793 = new Ext.form.Checkbox({ "boxLabel": "cause professionnelle", "listeners": { "render": Lino.quicktip_renderer("cause professionnelle","Check this if the request is needed for job search.") }, "hideLabel": true, "checked": false, "name": "urgent", "selectOnFocus": true, "anchor": "-20" });
    var main_1_panel1794 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 198, "hideCheckBoxLabels": true, "items": [ { "flex": 10, "autoHeight": true, "layout": "form", "xtype": "panel", "items": date_submitted1789, "labelAlign": "top" }, { "flex": 25, "autoHeight": true, "layout": "form", "xtype": "panel", "items": person1790, "labelAlign": "top" }, { "flex": 25, "autoHeight": true, "layout": "form", "xtype": "panel", "items": content1791, "labelAlign": "top" }, { "flex": 25, "autoHeight": true, "layout": "form", "xtype": "panel", "items": offer1792, "labelAlign": "top" }, { "flex": 12, "autoHeight": true, "layout": "form", "xtype": "panel", "items": urgent1793, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var course1800 = new Lino.TwinCombo({ "fieldLabel": "Cours trouv\u00e9", "name": "course", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.courses.Courses.detail)}, "emptyText": "Choisir Cours...", "selectOnFocus": true, "hiddenName": "courseHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/courses/CourseRequests/course", "method": "GET" }) }) });
    var state1801 = new Lino.ChoicesFieldElement({ "forceSelection": true, "fieldLabel": "State", "allowBlank": false, "hiddenName": "stateHidden", "selectOnFocus": true, "anchor": "-20", "store": Lino.courses.CourseRequestStates, "name": "state" });
    var date_ended1802 = new Lino.DateField({ "selectOnFocus": true, "fieldLabel": "Date de fin", "anchor": "-20", "name": "date_ended" });
    var id1803 = new Ext.form.NumberField({ "selectOnFocus": true, "fieldLabel": "ID", "anchor": "-20", "name": "id" });
    var main_2_panel1804 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 117, "hideCheckBoxLabels": true, "items": [ { "flex": 40, "autoHeight": true, "layout": "form", "xtype": "panel", "items": course1800, "labelAlign": "top" }, { "flex": 26, "autoHeight": true, "layout": "form", "xtype": "panel", "items": state1801, "labelAlign": "top" }, { "flex": 16, "autoHeight": true, "layout": "form", "xtype": "panel", "items": date_ended1802, "labelAlign": "top" }, { "flex": 16, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id1803, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var remark1809 = new Ext.form.TextArea({ "selectOnFocus": true, "fieldLabel": "Remarque", "anchor": "-20 -10", "growMax": 2000, "name": "remark" });
    var UploadsByController_htmlbox1810 = new Lino.HtmlBoxPanel({ "flex": 33, "ls_bbar_actions": [ { "itemId": "insert", "menu_item_text": "Nouveau", "must_save": true, "tooltip": "Insert a new record", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-new", "overflowText": "Nouveau", "auto_save": true } ], "name": "UploadsByController", "containing_panel": this, "items": new Ext.BoxComponent({autoScroll:true}), "title": "Uploads", "master_panel": this, "value": "<br/>", "always_enabled": true, "bodyStyle": "overflow-x:hidden", "ls_insert_handler": Lino.uploads.UploadsByController.insert, "layout": "fit", "tools": [ Lino.show_in_own_window_button(Lino.uploads.UploadsByController.grid) ] });
    var main_3_panel1811 = new Ext.Panel({ "flex": 71, "border": false, "layout": "hbox", "labelWidth": 81, "hideCheckBoxLabels": true, "items": [ { "items": remark1809, "labelAlign": "top", "layout": "form", "xtype": "panel", "flex": 66 }, UploadsByController_htmlbox1810 ], "autoScroll": false, "layoutConfig": { "align": "stretch" }, "frame": false, "labelAlign": "top" });
    var main_panel1813 = new Ext.Panel({ "autoScroll": false, "border": false, "layout": "vbox", "hideCheckBoxLabels": true, "items": [ main_1_panel1794, main_2_panel1804, main_3_panel1811 ], "frame": true, "layoutConfig": { "align": "stretch" }, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel1813;
    this.before_row_edit = function(record) {
      offer1792.setContextValue('content',record ? record.data['contentHidden'] : undefined);
      UploadsByController_htmlbox1810.refresh();
    }
    this.onRender = function(ct, position) {
      content1791.on('change',Lino.chooser_handler(offer1792,'content'));
      Lino.courses.CourseRequests.DetailFormPanel.superclass.onRender.call(this, ct, position);
    }
    Lino.courses.CourseRequests.DetailFormPanel.superclass.initComponent.call(this);
    // active_fields:
    offer1792.on("change",function(){this.save()},this);
  }
});


Lino.jobs.JobProviders.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 72,
  initComponent : function() {
    var containing_panel = this;
    var prefix2480 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200, "fieldLabel": "prefix", "anchor": "-20", "name": "prefix" });
    var name2481 = new Ext.form.TextField({ "fieldLabel": "Name", "name": "name", "maxLength": 200, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var id2482 = new Ext.form.NumberField({ "selectOnFocus": true, "fieldLabel": "ID", "anchor": "-20", "name": "id" });
    var language2483 = new Lino.ChoicesFieldElement({ "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Langue</span>", "allowBlank": false, "value": "de", "hiddenName": "languageHidden", "listeners": { "render": Lino.quicktip_renderer("Langue","Die Sprache, in der Dokumente ausgestellt werden sollen.") }, "selectOnFocus": true, "anchor": "-20", "store": [ [ "de", "German" ], [ "fr", "French" ], [ "nl", "Dutch" ] ], "name": "language" });
    var intro_box_1_panel2484 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 31, "autoHeight": true, "layout": "form", "xtype": "panel", "items": prefix2480, "labelAlign": "top" }, { "flex": 31, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name2481, "labelAlign": "top" }, { "flex": 7, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id2482, "labelAlign": "top" }, { "flex": 29, "autoHeight": true, "layout": "form", "xtype": "panel", "items": language2483, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 63, "border": false, "anchor": "-20", "labelAlign": "top" });
    var vat_id2489 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200, "fieldLabel": "N\u00b0 de TVA", "anchor": "-20", "name": "vat_id" });
    var activity2490 = new Lino.RemoteComboFieldElement({ "fieldLabel": "Activit\u00e9", "name": "activity", "pageSize": 20, "emptyText": "Choisir Activit\u00e9...", "selectOnFocus": true, "hiddenName": "activityHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/jobs/JobProviders/activity", "method": "GET" }) }) });
    var type2491 = new Lino.RemoteComboFieldElement({ "fieldLabel": "Type de soci\u00e9t\u00e9", "name": "type", "pageSize": 20, "emptyText": "Choisir Type d'organisation...", "selectOnFocus": true, "hiddenName": "typeHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/jobs/JobProviders/type", "method": "GET" }) }) });
    var intro_box_2_panel2492 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 23, "autoHeight": true, "layout": "form", "xtype": "panel", "items": vat_id2489, "labelAlign": "top" }, { "flex": 38, "autoHeight": true, "layout": "form", "xtype": "panel", "items": activity2490, "labelAlign": "top" }, { "flex": 38, "autoHeight": true, "layout": "form", "xtype": "panel", "items": type2491, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 144, "border": false, "anchor": "-20", "labelAlign": "top" });
    var bank_account12496 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 40, "fieldLabel": "Compte en banque 1", "anchor": "-20", "name": "bank_account1" });
    var bank_account22497 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 40, "fieldLabel": "Compte en banque 2", "anchor": "-20", "name": "bank_account2" });
    var is_obsolete2498 = new Ext.form.Checkbox({ "boxLabel": "obsolete", "listeners": { "render": Lino.quicktip_renderer("obsolete","Altf\u00e4lle sind Partner, deren Stammdaten nicht mehr gepflegt werden und \nf\u00fcr neue Operationen nicht benutzt werden k\u00f6nnen.") }, "hideLabel": true, "checked": false, "name": "is_obsolete", "selectOnFocus": true, "anchor": "-20" });
    var intro_box_3_panel2499 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 40, "autoHeight": true, "layout": "form", "xtype": "panel", "items": bank_account12496, "labelAlign": "top" }, { "flex": 40, "autoHeight": true, "layout": "form", "xtype": "panel", "items": bank_account22497, "labelAlign": "top" }, { "flex": 19, "autoHeight": true, "layout": "form", "xtype": "panel", "items": is_obsolete2498, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 171, "border": false, "anchor": "-20", "labelAlign": "top" });
    var intro_box_panel2503 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "form", "hideCheckBoxLabels": true, "items": [ intro_box_1_panel2484, intro_box_2_panel2492, intro_box_3_panel2499 ], "frame": true, "bodyBorder": false, "labelAlign": "top" });
    var country2504 = new Lino.TwinCombo({ "fieldLabel": "Pays", "name": "country", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.countries.Countries.detail)}, "emptyText": "Choisir Pays...", "selectOnFocus": true, "hiddenName": "countryHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/jobs/JobProviders/country", "method": "GET" }) }) });
    var region2505 = new Lino.TwinCombo({ "fieldLabel": "Region", "name": "region", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.countries.Cities.detail)}, "emptyText": "Choisir Place...", "selectOnFocus": true, "hiddenName": "regionHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/jobs/JobProviders/region", "method": "GET" }) }) });
    var box3_1_panel2506 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": country2504, "labelAlign": "top" }, { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": region2505, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 63, "border": false, "anchor": "-20", "labelAlign": "top" });
    var city2509 = new Lino.TwinCombo({ "forceSelection": false, "fieldLabel": "Place", "name": "city", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.countries.Cities.detail)}, "emptyText": "Choisir Place...", "selectOnFocus": true, "hiddenName": "cityHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/jobs/JobProviders/city", "method": "GET" }) }) });
    var zip_code2510 = new Ext.form.TextField({ "fieldLabel": "Zip code", "name": "zip_code", "maxLength": 10, "selectOnFocus": true, "boxMinWidth": Lino.chars2width(10), "anchor": "-20" });
    var box3_2_panel2511 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 66, "autoHeight": true, "layout": "form", "xtype": "panel", "items": city2509, "labelAlign": "top" }, { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": zip_code2510, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 81, "border": false, "anchor": "-20", "labelAlign": "top" });
    var street_prefix2514 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Pr\u00e9fixe rue","Text to print before name of street, but to ignore for sorting.") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Pr\u00e9fixe rue</span>", "name": "street_prefix", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var street2515 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Rue","Name of street. Without house number.") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Rue</span>", "name": "street", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var street_no2516 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("N\u00b0","House number") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">N\u00b0</span>", "name": "street_no", "maxLength": 10, "selectOnFocus": true, "boxMinWidth": Lino.chars2width(10), "anchor": "-20" });
    var street_box2517 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("bo\u00eete","Text to print after :attr:`steet_no` on the same line") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">bo\u00eete</span>", "name": "street_box", "maxLength": 10, "selectOnFocus": true, "boxMinWidth": Lino.chars2width(10), "anchor": "-20" });
    var box3_3_panel2518 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 30, "autoHeight": true, "layout": "form", "xtype": "panel", "items": street_prefix2514, "labelAlign": "top" }, { "flex": 36, "autoHeight": true, "layout": "form", "xtype": "panel", "items": street2515, "labelAlign": "top" }, { "flex": 16, "autoHeight": true, "layout": "form", "xtype": "panel", "items": street_no2516, "labelAlign": "top" }, { "flex": 16, "autoHeight": true, "layout": "form", "xtype": "panel", "items": street_box2517, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 108, "border": false, "anchor": "-20", "labelAlign": "top" });
    var addr22523 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Ligne apr\u00e8s le nom de rue","Address line to print below street line") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Ligne apr\u00e8s le nom de rue</span>", "name": "addr2", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var box3_panel2524 = new Ext.Panel({ "flex": 62, "autoHeight": true, "layout": "form", "items": [ box3_1_panel2506, box3_2_panel2511, box3_3_panel2518, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": addr22523, "anchor": "-20", "labelAlign": "top" } ], "frame": true, "bodyBorder": false, "autoScroll": false, "hideCheckBoxLabels": true, "labelWidth": 234, "border": false, "labelAlign": "top" });
    var email2526 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 75, "fieldLabel": "E-mail", "anchor": "-20", "name": "email" });
    var url2527 = new Lino.URLField({ "selectOnFocus": true, "maxLength": 200, "fieldLabel": "URL", "anchor": "-20", "name": "url" });
    var phone2528 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200, "fieldLabel": "T\u00e9l\u00e9phone", "anchor": "-20", "name": "phone" });
    var gsm2529 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200, "fieldLabel": "GSM", "anchor": "-20", "name": "gsm" });
    var box4_panel2530 = new Ext.Panel({ "flex": 37, "autoHeight": true, "layout": "form", "items": [ { "autoHeight": true, "layout": "form", "xtype": "panel", "items": email2526, "anchor": "-20", "labelAlign": "top" }, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": url2527, "anchor": "-20", "labelAlign": "top" }, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": phone2528, "anchor": "-20", "labelAlign": "top" }, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": gsm2529, "anchor": "-20", "labelAlign": "top" } ], "frame": true, "bodyBorder": false, "autoScroll": false, "hideCheckBoxLabels": true, "labelWidth": 90, "border": false, "labelAlign": "top" });
    var address_box_panel2535 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "hideCheckBoxLabels": true, "items": [ box3_panel2524, box4_panel2530 ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var remarks2536 = new Ext.form.TextArea({ "selectOnFocus": true, "fieldLabel": "Remarques", "anchor": "-20 -10", "growMax": 2000, "name": "remarks" });
    var contacts_RolesByCompany_grid2537 = new Lino.contacts.RolesByCompany.GridPanel({ "tools": [ Lino.show_in_own_window_button(Lino.contacts.RolesByCompany.grid) ], "containing_panel": this, "hide_top_toolbar": true, "master_panel": this, "flex": 42 });
    var bottom_box_panel2538 = new Ext.Panel({ "flex": 41, "border": false, "layout": "hbox", "labelWidth": 90, "hideCheckBoxLabels": true, "items": [ { "items": remarks2536, "labelAlign": "top", "layout": "form", "xtype": "panel", "flex": 57 }, contacts_RolesByCompany_grid2537 ], "autoScroll": false, "layoutConfig": { "align": "stretch" }, "frame": false, "labelAlign": "top" });
    var general_panel2540 = new Ext.Panel({ "layout": "vbox", "title": "G\u00e9n\u00e9ral", "items": [ intro_box_panel2503, address_box_panel2535, bottom_box_panel2538 ], "frame": true, "layoutConfig": { "align": "stretch" }, "hideCheckBoxLabels": true, "listeners": { "activate": Lino.on_tab_activate }, "autoScroll": false, "border": false, "bodyBorder": false, "labelAlign": "top" });
    var pcsw_NotesByCompany_grid2541 = new Lino.pcsw.NotesByCompany.GridPanel({ "listeners": { "activate": Lino.on_tab_activate }, "hide_top_toolbar": true, "title": "Events/Notes", "containing_panel": this, "tools": [ Lino.show_in_own_window_button(Lino.pcsw.NotesByCompany.grid) ], "master_panel": this });
    var JobsByProvider_grid2615 = new Lino.jobs.JobsByProvider.GridPanel({ "flex": 5, "hide_top_toolbar": true, "split": true, "containing_panel": this, "region": "north", "tools": [ Lino.show_in_own_window_button(Lino.jobs.JobsByProvider.grid) ], "master_panel": this });
    var ContractsByProvider_grid2644 = new Lino.jobs.ContractsByProvider.GridPanel({ "flex": 5, "hide_top_toolbar": true, "containing_panel": this, "region": "center", "params_panel_hidden": true, "master_panel": this, "split": true, "tools": [ Lino.show_in_own_window_button(Lino.jobs.ContractsByProvider.grid) ] });
    var jobs_panel2645 = new Lino.VBorderPanel({ "autoScroll": false, "listeners": { "activate": Lino.on_tab_activate }, "border": false, "title": "Emplois", "hideCheckBoxLabels": true, "items": [ JobsByProvider_grid2615, ContractsByProvider_grid2644 ], "frame": true, "bodyBorder": false, "labelAlign": "top" });
    var main_panel2646 = new Ext.TabPanel({ "hideCheckBoxLabels": true, "border": false, "split": true, "autoScroll": false, "items": [ general_panel2540, pcsw_NotesByCompany_grid2541, jobs_panel2645 ], "activeTab": 0, "bodyBorder": false, "frame": true, "labelAlign": "top" });
    this.items = main_panel2646;
    this.before_row_edit = function(record) {
      region2505.setContextValue('country',record ? record.data['countryHidden'] : undefined);
      city2509.setContextValue('country',record ? record.data['countryHidden'] : undefined);
      city2509.setContextValue('region',record ? record.data['regionHidden'] : undefined);
      contacts_RolesByCompany_grid2537.on_master_changed();
      pcsw_NotesByCompany_grid2541.on_master_changed();
      JobsByProvider_grid2615.on_master_changed();
      ContractsByProvider_grid2644.on_master_changed();
    }
    this.onRender = function(ct, position) {
      country2504.on('change',Lino.chooser_handler(region2505,'country'));
      country2504.on('change',Lino.chooser_handler(city2509,'country'));
      region2505.on('change',Lino.chooser_handler(city2509,'region'));
      Lino.jobs.JobProviders.DetailFormPanel.superclass.onRender.call(this, ct, position);
    }
    Lino.jobs.JobProviders.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.accounts.Charts.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 45,
  initComponent : function() {
    var containing_panel = this;
    var id1340 = new Ext.form.NumberField({ "selectOnFocus": true, "fieldLabel": "ID", "anchor": "-20", "name": "id" });
    var name1341 = new Ext.form.TextField({ "fieldLabel": "Description", "name": "name", "maxLength": 200, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var name_fr1342 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200, "fieldLabel": "Description (fr)", "anchor": "-20", "name": "name_fr" });
    var name_nl1343 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200, "fieldLabel": "Description (nl)", "anchor": "-20", "name": "name_nl" });
    var main_1_panel1344 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 153, "hideCheckBoxLabels": true, "items": [ { "flex": 7, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id1340, "labelAlign": "top" }, { "flex": 30, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name1341, "labelAlign": "top" }, { "flex": 30, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_fr1342, "labelAlign": "top" }, { "flex": 30, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_nl1343, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var GroupsByChart_grid1384 = new Lino.accounts.GroupsByChart.GridPanel({ "tools": [ Lino.show_in_own_window_button(Lino.accounts.GroupsByChart.grid) ], "containing_panel": this, "hide_top_toolbar": true, "master_panel": this, "flex": 83 });
    var main_panel1385 = new Ext.Panel({ "autoScroll": false, "border": false, "layout": "vbox", "hideCheckBoxLabels": true, "items": [ main_1_panel1344, GroupsByChart_grid1384 ], "frame": true, "layoutConfig": { "align": "stretch" }, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel1385;
    this.before_row_edit = function(record) {
      GroupsByChart_grid1384.on_master_changed();
    }
    Lino.accounts.Charts.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.pcsw.Clients.InsertFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  autoHeight: true,
  content_type: 50,
  initComponent : function() {
    var containing_panel = this;
    var first_name2191 = new Ext.form.TextField({ "fieldLabel": "Pr\u00e9nom", "name": "first_name", "maxLength": 200, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var last_name2192 = new Ext.form.TextField({ "fieldLabel": "Nom de famille", "name": "last_name", "maxLength": 200, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var main_1_panel2193 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": first_name2191, "labelAlign": "top" }, { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": last_name2192, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 135, "border": false, "anchor": "-20", "labelAlign": "top" });
    var national_id2196 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200, "fieldLabel": "NISS", "anchor": "-20", "name": "national_id" });
    var gender2197 = new Lino.ChoicesFieldElement({ "forceSelection": true, "fieldLabel": "Sexe", "name": "gender", "selectOnFocus": true, "anchor": "-20", "store": Lino.lino.Genders, "hiddenName": "genderHidden" });
    var language2198 = new Lino.ChoicesFieldElement({ "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Langue</span>", "allowBlank": false, "value": "de", "hiddenName": "languageHidden", "listeners": { "render": Lino.quicktip_renderer("Langue","Die Sprache, in der Dokumente ausgestellt werden sollen.") }, "selectOnFocus": true, "anchor": "-20", "store": [ [ "de", "German" ], [ "fr", "French" ], [ "nl", "Dutch" ] ], "name": "language" });
    var main_3_panel2199 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 31, "autoHeight": true, "layout": "form", "xtype": "panel", "items": gender2197, "labelAlign": "top" }, { "flex": 68, "autoHeight": true, "layout": "form", "xtype": "panel", "items": language2198, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 63, "border": false, "anchor": "-20", "labelAlign": "top" });
    var main_panel2202 = new Ext.Panel({ "hideCheckBoxLabels": true, "autoHeight": true, "border": false, "layout": "form", "labelWidth": 45, "autoScroll": false, "items": [ main_1_panel2193, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": national_id2196, "anchor": "-20", "labelAlign": "top" }, main_3_panel2199 ], "frame": true, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel2202;
    this.before_row_edit = function(record) {
    }
    Lino.pcsw.Clients.InsertFormPanel.superclass.initComponent.call(this);
  }
});

Lino.contacts.Companies.merge_row = new Lino.WindowAction({ "draggable": true, "width": Lino.chars2width(50), "autoHeight": true, "maximizable": true, "modal": true, "maximized": false },function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.contacts.Companies.merge_row_ActionFormPanel({});
});
Lino.cal.GuestStates.wf2 = new Lino.WindowAction({ "draggable": true, "width": Lino.chars2width(50), "maximizable": true, "modal": true, "maximized": false, "height": Lino.rows2height(15) },function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.cal.Guests.wf2_ActionFormPanel({});
});
Lino.pcsw.ClientStates.wf2 = new Lino.WindowAction({ "draggable": true, "width": Lino.chars2width(50), "maximizable": true, "modal": true, "maximized": false, "height": Lino.rows2height(15) },function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.pcsw.Clients.wf2_ActionFormPanel({});
});
Lino.pcsw.Clients.merge_row = new Lino.WindowAction({ "draggable": true, "width": Lino.chars2width(70), "autoHeight": true, "maximizable": true, "modal": true, "maximized": false },function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.pcsw.Clients.merge_row_ActionFormPanel({});
});
Lino.newcomers.AvailableCoachesByClient.assign_coach = new Lino.WindowAction({ "draggable": true, "width": Lino.chars2width(50), "maximizable": true, "modal": true, "maximized": false, "height": Lino.rows2height(15) },function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.newcomers.AvailableCoachesByClient.assign_coach_ActionFormPanel({});
});

// js_render_GridPanel_class ui.SiteConfigs
Lino.ui.SiteConfigs.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "No data to display." },
  ls_url : "/ui/SiteConfigs",
  ls_bbar_actions : [ { "itemId": "detail", "menu_item_text": "D\u00e9tail", "tooltip": "Open a detail window on this record", "panel_btn_handler": Lino.show_detail, "iconCls": "x-tbar-detail", "overflowText": "D\u00e9tail", "auto_save": true }, { "itemId": "do_build", "menu_item_text": "Rebuild site cache", "must_save": true, "panel_btn_handler": Lino.row_action_handler('do_build','GET'), "text": "Rebuild site cache", "overflowText": "Rebuild site cache", "auto_save": true } ],
  title : "site configs",
  page_length : 20,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "type": "int", "name": "id" }, { "name": "default_build_method" }, 'default_build_methodHidden', { "type": "int", "name": "next_partner_id" }, { "name": "site_company" }, 'site_companyHidden', { "name": "system_note_type" }, 'system_note_typeHidden', { "name": "propgroup_skills" }, 'propgroup_skillsHidden', { "name": "propgroup_softskills" }, 'propgroup_softskillsHidden', { "name": "propgroup_obstacles" }, 'propgroup_obstaclesHidden', { "name": "signer1" }, 'signer1Hidden', { "name": "signer2" }, 'signer2Hidden', { "name": "signer1_function" }, 'signer1_functionHidden', { "name": "signer2_function" }, 'signer2_functionHidden', { "name": "job_office" }, 'job_officeHidden', { "name": "residence_permit_upload_type" }, 'residence_permit_upload_typeHidden', { "name": "work_permit_upload_type" }, 'work_permit_upload_typeHidden', { "name": "driving_licence_upload_type" }, 'driving_licence_upload_typeHidden', { "name": "debts_bailiff_type" }, 'debts_bailiff_typeHidden', { "name": "master_budget" }, 'master_budgetHidden', { "name": "sector" }, 'sectorHidden', { "name": "cbss_org_unit" }, { "name": "ssdn_user_id" }, { "name": "ssdn_email" }, { "name": "cbss_http_username" }, { "name": "cbss_http_password" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 0,
  ls_grid_configs : [  ],
  content_type : 3,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 42,
  initComponent : function() {
    this.ls_detail_handler = Lino.ui.SiteConfigs.detail;
    var ww = this.containing_window;
    var id38 = new Ext.form.NumberField({ "selectOnFocus": true });
    var default_build_method39 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "store": [ [ "appyodt", "AppyOdtBuildMethod" ], [ "appypdf", "AppyPdfBuildMethod" ], [ "appyrtf", "AppyRtfBuildMethod" ], [ "latex", "LatexBuildMethod" ], [ "pisa", "PisaBuildMethod" ], [ "rtf", "RtfBuildMethod" ] ], "value": "appyodt" });
    var next_partner_id40 = new Ext.form.NumberField({ "selectOnFocus": true, "allowBlank": false, "value": 100 });
    var site_company41 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/ui/SiteConfigs/site_company", "method": "GET" }) }), "pageSize": 20, "emptyText": "Choisir Organisation..." });
    var system_note_type42 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/ui/SiteConfigs/system_note_type", "method": "GET" }) }), "pageSize": 20, "emptyText": "Choisir Event Type..." });
    var propgroup_skills43 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/ui/SiteConfigs/propgroup_skills", "method": "GET" }) }), "pageSize": 20, "emptyText": "Choisir Groupe de propri\u00e9t\u00e9s..." });
    var propgroup_softskills44 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/ui/SiteConfigs/propgroup_softskills", "method": "GET" }) }), "pageSize": 20, "emptyText": "Choisir Groupe de propri\u00e9t\u00e9s..." });
    var propgroup_obstacles45 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/ui/SiteConfigs/propgroup_obstacles", "method": "GET" }) }), "pageSize": 20, "emptyText": "Choisir Groupe de propri\u00e9t\u00e9s..." });
    var signer146 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/ui/SiteConfigs/signer1", "method": "GET" }) }), "pageSize": 20, "emptyText": "Choisir Personne..." });
    var signer247 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/ui/SiteConfigs/signer2", "method": "GET" }) }), "pageSize": 20, "emptyText": "Choisir Personne..." });
    var signer1_function48 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/ui/SiteConfigs/signer1_function", "method": "GET" }) }), "pageSize": 20, "emptyText": "Choisir Fonction..." });
    var signer2_function49 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/ui/SiteConfigs/signer2_function", "method": "GET" }) }), "pageSize": 20, "emptyText": "Choisir Fonction..." });
    var job_office50 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/ui/SiteConfigs/job_office", "method": "GET" }) }), "pageSize": 20, "emptyText": "Choisir Organisation..." });
    var residence_permit_upload_type51 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/ui/SiteConfigs/residence_permit_upload_type", "method": "GET" }) }), "pageSize": 20, "emptyText": "Choisir Type d'upload..." });
    var work_permit_upload_type52 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/ui/SiteConfigs/work_permit_upload_type", "method": "GET" }) }), "pageSize": 20, "emptyText": "Choisir Type d'upload..." });
    var driving_licence_upload_type53 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/ui/SiteConfigs/driving_licence_upload_type", "method": "GET" }) }), "pageSize": 20, "emptyText": "Choisir Type d'upload..." });
    var debts_bailiff_type54 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/ui/SiteConfigs/debts_bailiff_type", "method": "GET" }) }), "pageSize": 20, "emptyText": "Choisir Type de contact client..." });
    var master_budget55 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/ui/SiteConfigs/master_budget", "method": "GET" }) }), "pageSize": 20, "emptyText": "Choisir Budget..." });
    var sector56 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/ui/SiteConfigs/sector", "method": "GET" }) }), "pageSize": 20, "emptyText": "Choisir Secteur..." });
    var cbss_org_unit57 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 50 });
    var ssdn_user_id58 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 50 });
    var ssdn_email59 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 75 });
    var cbss_http_username60 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 50 });
    var cbss_http_password61 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 50 });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ new Lino.NullNumberColumn({ "colIndex": 0, "sortable": true, "format": "0", "editable": true, "filter": { "type": "numeric" }, "header": "ID", "renderer": Lino.id_renderer, "editor": id38, "width": Lino.chars2width(6), "dataIndex": "id" }), { "colIndex": 1, "sortable": true, "header": "M\u00e9thode de constuction par d\u00e9fault", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "default_build_method", "editor": default_build_method39 }, new Lino.NullNumberColumn({ "colIndex": 2, "sortable": true, "format": "0", "editable": true, "filter": { "type": "numeric" }, "header": "The next automatic id for a manually created partner.", "dataIndex": "next_partner_id", "width": Lino.chars2width(6), "editor": next_partner_id40 }), { "colIndex": 3, "sortable": true, "header": "La soci\u00e9t\u00e9 ou tourne ce site", "editable": true, "tooltip": "The Company to be used as sender in documents.", "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('site_companyHidden','Lino.contacts.Companies.detail'), "editor": site_company41, "dataIndex": "site_company" }, { "colIndex": 4, "sortable": true, "header": "Default system note type", "editable": true, "tooltip": "Note Type used by system notes.\nIf this is empty, then system notes won't create any entry to the Notes table.", "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('system_note_typeHidden','Lino.notes.EventTypes.detail'), "editor": system_note_type42, "dataIndex": "system_note_type" }, { "colIndex": 5, "sortable": true, "header": "Groupe de propri\u00e9t\u00e9s 'Skills'", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('propgroup_skillsHidden','Lino.properties.PropGroups.detail'), "editor": propgroup_skills43, "dataIndex": "propgroup_skills" }, { "colIndex": 6, "sortable": true, "header": "Groupe de propri\u00e9t\u00e9s 'Soft Skills'", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('propgroup_softskillsHidden','Lino.properties.PropGroups.detail'), "editor": propgroup_softskills44, "dataIndex": "propgroup_softskills" }, { "colIndex": 7, "sortable": true, "header": "Groupe de propri\u00e9t\u00e9s 'Obstacles'", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('propgroup_obstaclesHidden','Lino.properties.PropGroups.detail'), "editor": propgroup_obstacles45, "dataIndex": "propgroup_obstacles" }, { "colIndex": 8, "sortable": true, "header": "Secr\u00e9taire", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('signer1Hidden','Lino.contacts.Persons.detail'), "editor": signer146, "dataIndex": "signer1" }, { "colIndex": 9, "sortable": true, "header": "President", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('signer2Hidden','Lino.contacts.Persons.detail'), "editor": signer247, "dataIndex": "signer2" }, { "colIndex": 10, "sortable": true, "header": "First signer function", "editable": true, "tooltip": "Contact function to designate the secretary.", "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "signer1_function", "editor": signer1_function48 }, { "colIndex": 11, "sortable": true, "header": "Second signer function", "editable": true, "tooltip": "Contact function to designate the president.", "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "signer2_function", "editor": signer2_function49 }, { "colIndex": 12, "sortable": true, "header": "Agence locale pour l'emploi ?", "editable": true, "tooltip": "The Company whose contact persons \n            will be choices for `Person.job_office_contact`.", "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('job_officeHidden','Lino.contacts.Companies.detail'), "editor": job_office50, "dataIndex": "job_office" }, { "colIndex": 13, "sortable": true, "header": "Type d'upload \"permis de r\u00e9sidence\"", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "residence_permit_upload_type", "editor": residence_permit_upload_type51 }, { "colIndex": 14, "sortable": true, "header": "Type d'upload \"permis de travail\"", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "work_permit_upload_type", "editor": work_permit_upload_type52 }, { "colIndex": 15, "sortable": true, "header": "Type d'upload \"permis de conduire\"", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "driving_licence_upload_type", "editor": driving_licence_upload_type53 }, { "colIndex": 16, "sortable": true, "header": "Bailiff", "editable": true, "tooltip": "Client contact type for Bailiff.", "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "debts_bailiff_type", "editor": debts_bailiff_type54 }, { "colIndex": 17, "sortable": true, "header": "Master budget", "editable": true, "tooltip": "The budget whose content is to be copied into new budgets.", "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('master_budgetHidden','Lino.debts.Budgets.detail'), "editor": master_budget55, "dataIndex": "master_budget" }, { "colIndex": 18, "sortable": true, "header": "Secteur", "editable": true, "tooltip": "The CBSS sector/subsector of the requesting organization.        \nFor PCSWs this is always 17.1.\nUsed in SSDN requests as text of the `MatrixID` and `MatrixSubID` \nelements of `AuthorizedUser`. \nUsed in ManageAccess requests as default value \nfor the non-editable field `sector` \n(which defines the choices of the `purpose` field).\n", "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "sector", "editor": sector56 }, { "colIndex": 19, "sortable": true, "header": "Requesting organisation", "editable": true, "tooltip": "In CBSS requests, identifies the requesting organization.\nFor PCSWs this is the enterprise number \n(CBE, KBO) and should have 10 digits and no formatting characters.\n\nUsed in SSDN requests as text of the `AuthorizedUser\\OrgUnit` element . \nUsed in new style requests as text of the `CustomerIdentification\\cbeNumber` element . \n", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "cbss_org_unit", "editor": cbss_org_unit57 }, { "colIndex": 20, "sortable": true, "header": "SSDN User Id", "editable": true, "tooltip": "Used in SSDN requests as text of the `AuthorizedUser\\UserID` element.\n", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "ssdn_user_id", "editor": ssdn_user_id58 }, { "colIndex": 21, "sortable": true, "header": "SSDN email address", "editable": true, "tooltip": "Used in SSDN requests as text of the `AuthorizedUser\\Email` element.\n", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "ssdn_email", "editor": ssdn_email59 }, { "colIndex": 22, "sortable": true, "header": "HTTP username", "editable": true, "tooltip": "Used in the http header of new-style requests.\n", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "cbss_http_username", "editor": cbss_http_username60 }, { "colIndex": 23, "sortable": true, "header": "HTTP password", "editable": true, "tooltip": "Used in the http header of new-style requests.\n", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "cbss_http_password", "editor": cbss_http_password61 } ];
    Lino.ui.SiteConfigs.GridPanel.superclass.initComponent.call(this);
  }
});


Lino.ui.SiteConfigs.detailPanel = Ext.extend(Lino.ui.SiteConfigs.DetailFormPanel,{
  empty_title: "D\u00e9tail site configs",
  ls_bbar_actions: [ { "itemId": "put", "menu_item_text": "Enregistrer", "tooltip": "Save changes in this form", "panel_btn_handler": function(panel){panel.save(null,false,'put')}, "iconCls": "x-tbar-save", "overflowText": "Enregistrer", "auto_save": false }, { "itemId": "do_build", "menu_item_text": "Rebuild site cache", "must_save": true, "panel_btn_handler": Lino.row_action_handler('do_build','GET'), "text": "Rebuild site cache", "overflowText": "Rebuild site cache", "auto_save": true } ],
  ls_url: "/ui/SiteConfigs",
  action_name: "detail",
  initComponent : function() {
    this.ls_detail_handler = Lino.ui.SiteConfigs.detail;
    Lino.ui.SiteConfigs.detailPanel.superclass.initComponent.call(this);
  }
});

Lino.ui.SiteConfigs.detail = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.ui.SiteConfigs.detailPanel(p);
});
Lino.ui.SiteConfigs.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.ui.SiteConfigs.GridPanel(p);
});

// js_render_GridPanel_class ui.ContentTypes
Lino.ui.ContentTypes.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "No data to display." },
  ls_url : "/ui/ContentTypes",
  ls_bbar_actions : [ { "itemId": "insert", "menu_item_text": "Nouveau", "must_save": true, "tooltip": "Insert a new record", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-new", "overflowText": "Nouveau", "auto_save": true }, { "itemId": "detail", "menu_item_text": "D\u00e9tail", "tooltip": "Open a detail window on this record", "panel_btn_handler": Lino.show_detail, "iconCls": "x-tbar-detail", "overflowText": "D\u00e9tail", "auto_save": true }, { "itemId": null, "menu_item_text": "Supprimer", "tooltip": "Delete this record", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "Supprimer", "auto_save": false } ],
  title : "types de contenu",
  page_length : 20,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "type": "int", "name": "id" }, { "name": "name" }, { "name": "app_label" }, { "name": "model" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 0,
  ls_grid_configs : [  ],
  content_type : 5,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 5,
  initComponent : function() {
    this.ls_detail_handler = Lino.ui.ContentTypes.detail;
    this.ls_insert_handler = Lino.ui.ContentTypes.insert;
    var ww = this.containing_window;
    var id3342 = new Ext.form.NumberField({ "selectOnFocus": true });
    var name3343 = new Ext.form.TextField({ "selectOnFocus": true, "allowBlank": false, "maxLength": 100 });
    var app_label3344 = new Ext.form.TextField({ "selectOnFocus": true, "allowBlank": false, "maxLength": 100 });
    var model3345 = new Ext.form.TextField({ "selectOnFocus": true, "allowBlank": false, "maxLength": 100 });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ new Lino.NullNumberColumn({ "colIndex": 0, "sortable": true, "format": "0", "editable": true, "filter": { "type": "numeric" }, "header": "ID", "renderer": Lino.id_renderer, "editor": id3342, "width": Lino.chars2width(6), "dataIndex": "id" }), { "colIndex": 1, "sortable": true, "header": "name", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "name", "editor": name3343 }, { "colIndex": 2, "sortable": true, "header": "app label", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "app_label", "editor": app_label3344 }, { "colIndex": 3, "sortable": true, "header": "nom de la classe python du mod\u00e8le", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "model", "editor": model3345 } ];
    Lino.ui.ContentTypes.GridPanel.superclass.initComponent.call(this);
  }
});


Lino.ui.ContentTypes.insertPanel = Ext.extend(Lino.ui.ContentTypes.DetailFormPanel,{
  empty_title: "Nouveau types de contenu",
  hide_navigator: true,
  ls_bbar_actions: [ { "itemId": "post", "menu_item_text": "Cr\u00e9er", "tooltip": "Create the record and open a detail window on it", "panel_btn_handler": function(panel){panel.save(null,true,'post')}, "text": "Cr\u00e9er", "overflowText": "Cr\u00e9er", "auto_save": false }, { "itemId": "poststay", "menu_item_text": "Create without detail", "tooltip": "Don't open a detail window on the new record", "panel_btn_handler": function(panel){panel.save(null,false,'poststay')}, "text": "Create without detail", "overflowText": "Create without detail", "auto_save": false } ],
  ls_url: "/ui/ContentTypes",
  action_name: "insert",
  initComponent : function() {
    this.ls_detail_handler = Lino.ui.ContentTypes.detail;
    this.ls_insert_handler = Lino.ui.ContentTypes.insert;
    Lino.ui.ContentTypes.insertPanel.superclass.initComponent.call(this);
  }
});

Lino.ui.ContentTypes.insert = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.ui.ContentTypes.insertPanel(p);
});

Lino.ui.ContentTypes.detailPanel = Ext.extend(Lino.ui.ContentTypes.DetailFormPanel,{
  empty_title: "D\u00e9tail types de contenu",
  ls_bbar_actions: [ { "itemId": "put", "menu_item_text": "Enregistrer", "tooltip": "Save changes in this form", "panel_btn_handler": function(panel){panel.save(null,false,'put')}, "iconCls": "x-tbar-save", "overflowText": "Enregistrer", "auto_save": false }, { "itemId": "insert", "menu_item_text": "Nouveau", "must_save": true, "tooltip": "Insert a new record", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-new", "overflowText": "Nouveau", "auto_save": true }, { "itemId": null, "menu_item_text": "Supprimer", "tooltip": "Delete this record", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "Supprimer", "auto_save": false } ],
  ls_url: "/ui/ContentTypes",
  action_name: "detail",
  initComponent : function() {
    this.ls_detail_handler = Lino.ui.ContentTypes.detail;
    this.ls_insert_handler = Lino.ui.ContentTypes.insert;
    Lino.ui.ContentTypes.detailPanel.superclass.initComponent.call(this);
  }
});

Lino.ui.ContentTypes.detail = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.ui.ContentTypes.detailPanel(p);
});
Lino.ui.ContentTypes.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.ui.ContentTypes.GridPanel(p);
});

// js_render_GridPanel_class ui.HelpTexts
Lino.ui.HelpTexts.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "No data to display." },
  ls_url : "/ui/HelpTexts",
  ls_bbar_actions : [ { "itemId": null, "menu_item_text": "Supprimer", "tooltip": "Delete this record", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "Supprimer", "auto_save": false } ],
  title : "Textes d'aide",
  page_length : 20,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "name": "field" }, { "name": "verbose_name" }, { "name": "help_text" }, { "type": "int", "name": "id" }, { "name": "content_type" }, 'content_typeHidden', { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 3,
  ls_grid_configs : [  ],
  content_type : 2,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 7,
  initComponent : function() {
    var ww = this.containing_window;
    var field3347 = new Lino.SimpleRemoteComboFieldElement({ "selectOnFocus": true, "allowBlank": false, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/ui/HelpTexts/field", "method": "GET" }) }) });
    var verbose_name3348 = new Ext.form.TextField({ "disabled": true, "maxLength": 200 });
    var help_text3349 = new Ext.form.TextArea({ "selectOnFocus": true, "growMax": 2000 });
    var id3350 = new Ext.form.NumberField({ "selectOnFocus": true });
    var content_type3351 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/ui/HelpTexts/content_type", "method": "GET" }) }), "allowBlank": false, "pageSize": 20, "emptyText": "Choisir type de contenu..." });
    this.before_row_edit = function(record) {
      field3347.setContextValue('content_type',record ? record.data['content_typeHidden'] : undefined);
    };
    this.onRender = function(ct, position) {
      content_type3351.on('change',Lino.chooser_handler(field3347,'content_type'));
      Lino.ui.HelpTexts.GridPanel.superclass.onRender.call(this, ct, position);
    }
    this.ls_columns = [ { "colIndex": 0, "sortable": true, "header": "Field", "editable": true, "tooltip": "The name of the field.", "filter": { "type": "string" }, "width": Lino.chars2width(11), "dataIndex": "field", "editor": field3347 }, { "width": Lino.chars2width(22), "colIndex": 1, "sortable": false, "dataIndex": "verbose_name", "header": "Verbose name", "editable": false }, { "colIndex": 2, "sortable": false, "header": "HelpText", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(61), "renderer": Lino.text_renderer, "editor": help_text3349, "dataIndex": "help_text" }, new Lino.NullNumberColumn({ "colIndex": 3, "sortable": true, "format": "0", "editable": true, "filter": { "type": "numeric" }, "header": "ID", "renderer": Lino.id_renderer, "editor": id3350, "width": Lino.chars2width(6), "dataIndex": "id" }), { "colIndex": 4, "sortable": true, "header": "Mod\u00e8le", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('content_typeHidden','Lino.ui.ContentTypes.detail'), "editor": content_type3351, "dataIndex": "content_type" } ];
    Lino.ui.HelpTexts.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.ui.HelpTexts.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.ui.HelpTexts.GridPanel(p);
});

// js_render_GridPanel_class ui.TextFieldTemplates
Lino.ui.TextFieldTemplates.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "No data to display." },
  ls_url : "/ui/TextFieldTemplates",
  ls_bbar_actions : [ { "itemId": "insert", "menu_item_text": "Nouveau", "must_save": true, "tooltip": "Insert a new record", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-new", "overflowText": "Nouveau", "auto_save": true }, { "itemId": "detail", "menu_item_text": "D\u00e9tail", "tooltip": "Open a detail window on this record", "panel_btn_handler": Lino.show_detail, "iconCls": "x-tbar-detail", "overflowText": "D\u00e9tail", "auto_save": true }, { "itemId": null, "menu_item_text": "Supprimer", "tooltip": "Delete this record", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "Supprimer", "auto_save": false } ],
  title : "Text Field Templates",
  page_length : 20,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "type": "int", "name": "id" }, { "name": "user" }, 'userHidden', { "name": "name" }, { "name": "description" }, { "name": "team" }, 'teamHidden', { "name": "text" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 0,
  ls_grid_configs : [  ],
  content_type : 1,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 9,
  initComponent : function() {
    this.ls_detail_handler = Lino.ui.TextFieldTemplates.detail;
    this.ls_insert_handler = Lino.ui.TextFieldTemplates.insert;
    var ww = this.containing_window;
    var id3353 = new Ext.form.NumberField({ "selectOnFocus": true });
    var user3354 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/ui/TextFieldTemplates/user", "method": "GET" }) }), "pageSize": 20, "emptyText": "Choisir Utilisateur..." });
    var name3355 = new Ext.form.TextField({ "selectOnFocus": true, "allowBlank": false, "maxLength": 200 });
    var description3356 = new Ext.form.TextArea({ "selectOnFocus": true, "growMax": 2000 });
    var team3357 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/ui/TextFieldTemplates/team", "method": "GET" }) }), "pageSize": 20, "emptyText": "Choisir Team..." });
    var text3358 = new Lino.RichTextPanel({ "selectOnFocus": true, "containing_panel": this, "title": "Texte mod\u00e8le" });
    this.before_row_edit = function(record) {
      text3358.refresh();
    };
    this.ls_columns = [ new Lino.NullNumberColumn({ "colIndex": 0, "sortable": true, "format": "0", "editable": true, "filter": { "type": "numeric" }, "header": "ID", "renderer": Lino.id_renderer, "editor": id3353, "width": Lino.chars2width(6), "dataIndex": "id" }), { "colIndex": 1, "sortable": true, "header": "Auteur", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(16), "renderer": Lino.fk_renderer('userHidden','Lino.users.Users.detail'), "editor": user3354, "dataIndex": "user" }, { "colIndex": 2, "sortable": true, "header": "Description", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "name", "editor": name3355 }, { "colIndex": 3, "sortable": false, "header": "Description", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(61), "renderer": Lino.text_renderer, "editor": description3356, "dataIndex": "description" }, { "colIndex": 4, "sortable": true, "header": "Team", "editable": true, "tooltip": "If not empty, then this template is reserved to members of this team.", "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "team", "editor": team3357 }, { "colIndex": 5, "sortable": false, "header": "text", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(61), "renderer": Lino.text_renderer, "editor": text3358, "dataIndex": "text" } ];
    Lino.ui.TextFieldTemplates.GridPanel.superclass.initComponent.call(this);
  }
});


Lino.ui.TextFieldTemplates.insertPanel = Ext.extend(Lino.ui.TextFieldTemplates.InsertFormPanel,{
  empty_title: "Nouveau Text Field Templates",
  hide_navigator: true,
  ls_bbar_actions: [ { "itemId": "post", "menu_item_text": "Cr\u00e9er", "tooltip": "Create the record and open a detail window on it", "panel_btn_handler": function(panel){panel.save(null,true,'post')}, "text": "Cr\u00e9er", "overflowText": "Cr\u00e9er", "auto_save": false }, { "itemId": "poststay", "menu_item_text": "Create without detail", "tooltip": "Don't open a detail window on the new record", "panel_btn_handler": function(panel){panel.save(null,false,'poststay')}, "text": "Create without detail", "overflowText": "Create without detail", "auto_save": false } ],
  ls_url: "/ui/TextFieldTemplates",
  action_name: "insert",
  initComponent : function() {
    this.ls_detail_handler = Lino.ui.TextFieldTemplates.detail;
    this.ls_insert_handler = Lino.ui.TextFieldTemplates.insert;
    Lino.ui.TextFieldTemplates.insertPanel.superclass.initComponent.call(this);
  }
});

Lino.ui.TextFieldTemplates.insert = new Lino.WindowAction({ "draggable": true, "width": Lino.chars2width(60), "autoHeight": true, "maximizable": true, "modal": true, "maximized": false },function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.ui.TextFieldTemplates.insertPanel(p);
});

Lino.ui.TextFieldTemplates.detailPanel = Ext.extend(Lino.ui.TextFieldTemplates.DetailFormPanel,{
  empty_title: "D\u00e9tail Text Field Templates",
  ls_bbar_actions: [ { "itemId": "put", "menu_item_text": "Enregistrer", "tooltip": "Save changes in this form", "panel_btn_handler": function(panel){panel.save(null,false,'put')}, "iconCls": "x-tbar-save", "overflowText": "Enregistrer", "auto_save": false }, { "itemId": "insert", "menu_item_text": "Nouveau", "must_save": true, "tooltip": "Insert a new record", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-new", "overflowText": "Nouveau", "auto_save": true }, { "itemId": null, "menu_item_text": "Supprimer", "tooltip": "Delete this record", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "Supprimer", "auto_save": false } ],
  ls_url: "/ui/TextFieldTemplates",
  action_name: "detail",
  initComponent : function() {
    this.ls_detail_handler = Lino.ui.TextFieldTemplates.detail;
    this.ls_insert_handler = Lino.ui.TextFieldTemplates.insert;
    Lino.ui.TextFieldTemplates.detailPanel.superclass.initComponent.call(this);
  }
});

Lino.ui.TextFieldTemplates.detail = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.ui.TextFieldTemplates.detailPanel(p);
});
Lino.ui.TextFieldTemplates.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.ui.TextFieldTemplates.GridPanel(p);
});

// js_render_GridPanel_class users.Users
Lino.users.Users.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "No data to display." },
  ls_url : "/users/Users",
  ls_bbar_actions : [ { "itemId": "insert", "menu_item_text": "Nouveau", "must_save": true, "tooltip": "Insert a new record", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-new", "overflowText": "Nouveau", "auto_save": true }, { "itemId": "detail", "menu_item_text": "D\u00e9tail", "tooltip": "Open a detail window on this record", "panel_btn_handler": Lino.show_detail, "iconCls": "x-tbar-detail", "overflowText": "D\u00e9tail", "auto_save": true }, { "itemId": null, "menu_item_text": "Supprimer", "tooltip": "Delete this record", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "Supprimer", "auto_save": false }, { "itemId": "update_reminders", "menu_item_text": "Update Reminders", "must_save": true, "panel_btn_handler": Lino.row_action_handler('update_reminders','GET'), "text": "Update Reminders", "overflowText": "Update Reminders", "auto_save": true } ],
  title : "Utilisateurs",
  page_length : 20,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "name": "username" }, { "name": "profile" }, 'profileHidden', { "name": "first_name" }, { "name": "last_name" }, { "type": "int", "name": "id" }, { "name": "created" }, { "name": "modified" }, { "name": "password" }, { "name": "email" }, { "name": "remarks" }, { "name": "language" }, 'languageHidden', { "name": "partner" }, 'partnerHidden', { "name": "access_class" }, 'access_classHidden', { "name": "calendar" }, 'calendarHidden', { "name": "coaching_type" }, 'coaching_typeHidden', { "type": "boolean", "name": "coaching_supervisor" }, { "type": "int", "name": "newcomer_quota" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 5,
  ls_grid_configs : [  ],
  content_type : 7,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 24,
  initComponent : function() {
    this.ls_detail_handler = Lino.users.Users.detail;
    this.ls_insert_handler = Lino.users.Users.insert;
    var ww = this.containing_window;
    var username3360 = new Ext.form.TextField({ "selectOnFocus": true, "allowBlank": false, "maxLength": 30 });
    var profile3361 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "forceSelection": true, "store": Lino.lino.UserProfiles });
    var first_name3362 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 30 });
    var last_name3363 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 30 });
    var id3364 = new Ext.form.NumberField({ "selectOnFocus": true });
    var created3365 = new Ext.form.DisplayField({ "disabled": true, "value": "<br>" });
    var modified3366 = new Ext.form.DisplayField({ "disabled": true, "value": "<br>" });
    var password3367 = new Ext.form.TextField({ "selectOnFocus": true, "allowBlank": false, "maxLength": 128 });
    var email3368 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 75 });
    var remarks3369 = new Ext.form.TextArea({ "selectOnFocus": true, "growMax": 2000 });
    var language3370 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "allowBlank": false, "store": [ [ "de", "German" ], [ "fr", "French" ], [ "nl", "Dutch" ] ] });
    var partner3371 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/users/Users/partner", "method": "GET" }) }), "pageSize": 20, "emptyText": "Choisir Partenaire..." });
    var access_class3372 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "forceSelection": true, "allowBlank": false, "store": Lino.cal.AccessClasses });
    var calendar3373 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/users/Users/calendar", "method": "GET" }) }), "pageSize": 20, "emptyText": "Choisir Calendrier..." });
    var coaching_type3374 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/users/Users/coaching_type", "method": "GET" }) }), "pageSize": 20, "emptyText": "Choisir Service..." });
    var coaching_supervisor3375 = new Ext.form.Checkbox({ "selectOnFocus": true, "checked": false });
    var newcomer_quota3376 = new Ext.form.NumberField({ "selectOnFocus": true, "allowBlank": false, "value": 0 });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ { "colIndex": 0, "sortable": true, "header": "Username", "editable": true, "tooltip": "\n        Required. Must be unique. \n        ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "username", "editor": username3360 }, { "colIndex": 1, "sortable": true, "header": "User Profile", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(47), "dataIndex": "profile", "editor": profile3361 }, { "colIndex": 2, "sortable": true, "header": "Pr\u00e9nom", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "first_name", "editor": first_name3362 }, { "colIndex": 3, "sortable": true, "header": "Nom de famille", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "last_name", "editor": last_name3363 }, new Lino.NullNumberColumn({ "colIndex": 4, "sortable": true, "format": "0", "editable": true, "filter": { "type": "numeric" }, "header": "ID", "renderer": Lino.id_renderer, "editor": id3364, "width": Lino.chars2width(6), "dataIndex": "id" }), { "width": Lino.chars2width(17), "colIndex": 5, "sortable": true, "dataIndex": "created", "header": "Cr\u00e9\u00e9", "editable": false }, { "width": Lino.chars2width(17), "colIndex": 6, "sortable": true, "dataIndex": "modified", "header": "Modified", "editable": false }, { "colIndex": 7, "sortable": true, "header": "Password", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "password", "hidden": true, "editor": password3367 }, { "colIndex": 8, "sortable": true, "header": "adresse e-mail", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "email", "editor": email3368 }, { "colIndex": 9, "sortable": false, "header": "Remarques", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(61), "renderer": Lino.text_renderer, "hidden": true, "editor": remarks3369, "dataIndex": "remarks" }, { "colIndex": 10, "sortable": true, "header": "Langue", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "language", "editor": language3370 }, { "colIndex": 11, "sortable": true, "header": "Partenaire", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('partnerHidden','Lino.contacts.Partners.detail'), "editor": partner3371, "dataIndex": "partner" }, { "colIndex": 12, "sortable": true, "header": "Classe d'acc\u00e8s par d\u00e9faut", "editable": true, "tooltip": "The default access class for your calendar events and tasks.", "filter": { "type": "string" }, "width": Lino.chars2width(13), "dataIndex": "access_class", "editor": access_class3372 }, { "colIndex": 13, "sortable": true, "header": "Calendrier par d\u00e9faut", "editable": true, "tooltip": "Le calendrier par d\u00e9faut pour vos rendez-vous et t\u00e2ches.", "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('calendarHidden','Lino.cal.Calendars.detail'), "editor": calendar3373, "dataIndex": "calendar" }, { "colIndex": 14, "sortable": true, "header": "Service", "editable": true, "tooltip": "The default CoachingType used when creating Coachings.", "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "coaching_type", "editor": coaching_type3374 }, { "colIndex": 15, "sortable": false, "xtype": "checkcolumn", "header": "Notify me when a coach has been assigned", "editable": true, "tooltip": "Wenn ein Neuantrag einem Begleiter zugewiesen wurde, wird au\u00dfer dem Begleiter auch dieser Benutzer benachrichtigt.", "filter": { "type": "boolean" }, "width": Lino.chars2width(11), "dataIndex": "coaching_supervisor" }, new Lino.NullNumberColumn({ "colIndex": 16, "sortable": true, "format": "0", "editable": true, "tooltip": "Wieviel Arbeitszeit dieser Benutzer f\u00fcr Neuantr\u00e4ge zur Verf\u00fcgung steht\n(100 = ganztags, 50 = halbtags, 0 = gar nicht).\nWenn zwei Benutzer die gleiche Belastungspunktzahl haben, \naber einer davon sich nur zu 50% um Neuantr\u00e4ge k\u00fcmmert, \ngilt er als doppelt so belastet wie sein Kollege.\n", "filter": { "type": "numeric" }, "header": "Quota nouvelles demandes", "dataIndex": "newcomer_quota", "width": Lino.chars2width(6), "editor": newcomer_quota3376 }) ];
    Lino.users.Users.GridPanel.superclass.initComponent.call(this);
  }
});


Lino.users.Users.insertPanel = Ext.extend(Lino.users.Users.InsertFormPanel,{
  empty_title: "Nouveau Utilisateurs",
  hide_navigator: true,
  ls_bbar_actions: [ { "itemId": "post", "menu_item_text": "Cr\u00e9er", "tooltip": "Create the record and open a detail window on it", "panel_btn_handler": function(panel){panel.save(null,true,'post')}, "text": "Cr\u00e9er", "overflowText": "Cr\u00e9er", "auto_save": false }, { "itemId": "poststay", "menu_item_text": "Create without detail", "tooltip": "Don't open a detail window on the new record", "panel_btn_handler": function(panel){panel.save(null,false,'poststay')}, "text": "Create without detail", "overflowText": "Create without detail", "auto_save": false } ],
  ls_url: "/users/Users",
  action_name: "insert",
  initComponent : function() {
    this.ls_detail_handler = Lino.users.Users.detail;
    this.ls_insert_handler = Lino.users.Users.insert;
    Lino.users.Users.insertPanel.superclass.initComponent.call(this);
  }
});

Lino.users.Users.insert = new Lino.WindowAction({ "draggable": true, "width": Lino.chars2width(60), "autoHeight": true, "maximizable": true, "modal": true, "maximized": false },function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.users.Users.insertPanel(p);
});

Lino.users.Users.detailPanel = Ext.extend(Lino.users.Users.DetailFormPanel,{
  empty_title: "D\u00e9tail Utilisateurs",
  ls_bbar_actions: [ { "itemId": "put", "menu_item_text": "Enregistrer", "tooltip": "Save changes in this form", "panel_btn_handler": function(panel){panel.save(null,false,'put')}, "iconCls": "x-tbar-save", "overflowText": "Enregistrer", "auto_save": false }, { "itemId": "insert", "menu_item_text": "Nouveau", "must_save": true, "tooltip": "Insert a new record", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-new", "overflowText": "Nouveau", "auto_save": true }, { "itemId": null, "menu_item_text": "Supprimer", "tooltip": "Delete this record", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "Supprimer", "auto_save": false }, { "itemId": "update_reminders", "menu_item_text": "Update Reminders", "must_save": true, "panel_btn_handler": Lino.row_action_handler('update_reminders','GET'), "text": "Update Reminders", "overflowText": "Update Reminders", "auto_save": true } ],
  ls_url: "/users/Users",
  action_name: "detail",
  initComponent : function() {
    this.ls_detail_handler = Lino.users.Users.detail;
    this.ls_insert_handler = Lino.users.Users.insert;
    Lino.users.Users.detailPanel.superclass.initComponent.call(this);
  }
});

Lino.users.Users.detail = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.users.Users.detailPanel(p);
});
Lino.users.Users.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.users.Users.GridPanel(p);
});

// js_render_GridPanel_class users.MySettings
Lino.users.MySettings.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "No data to display." },
  ls_url : "/users/MySettings",
  ls_bbar_actions : [ { "itemId": "put", "menu_item_text": "Enregistrer", "tooltip": "Save changes in this form", "panel_btn_handler": function(panel){panel.save(null,false,'put')}, "iconCls": "x-tbar-save", "overflowText": "Enregistrer", "auto_save": false }, { "itemId": "update_reminders", "menu_item_text": "Update Reminders", "must_save": true, "panel_btn_handler": Lino.row_action_handler('update_reminders','GET'), "text": "Update Reminders", "overflowText": "Update Reminders", "auto_save": true } ],
  title : "Utilisateurs",
  page_length : 20,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "name": "username" }, { "name": "profile" }, 'profileHidden', { "name": "first_name" }, { "name": "last_name" }, { "type": "int", "name": "id" }, { "name": "created" }, { "name": "modified" }, { "name": "password" }, { "name": "email" }, { "name": "remarks" }, { "name": "language" }, 'languageHidden', { "name": "partner" }, 'partnerHidden', { "name": "access_class" }, 'access_classHidden', { "name": "calendar" }, 'calendarHidden', { "name": "coaching_type" }, 'coaching_typeHidden', { "type": "boolean", "name": "coaching_supervisor" }, { "type": "int", "name": "newcomer_quota" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 5,
  ls_grid_configs : [  ],
  content_type : 7,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 24,
  initComponent : function() {
    this.ls_detail_handler = Lino.users.MySettings.detail;
    this.ls_insert_handler = Lino.users.Users.insert;
    var ww = this.containing_window;
    var username3378 = new Ext.form.TextField({ "selectOnFocus": true, "allowBlank": false, "maxLength": 30 });
    var profile3379 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "forceSelection": true, "store": Lino.lino.UserProfiles });
    var first_name3380 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 30 });
    var last_name3381 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 30 });
    var id3382 = new Ext.form.NumberField({ "selectOnFocus": true });
    var created3383 = new Ext.form.DisplayField({ "disabled": true, "value": "<br>" });
    var modified3384 = new Ext.form.DisplayField({ "disabled": true, "value": "<br>" });
    var password3385 = new Ext.form.TextField({ "selectOnFocus": true, "allowBlank": false, "maxLength": 128 });
    var email3386 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 75 });
    var remarks3387 = new Ext.form.TextArea({ "selectOnFocus": true, "growMax": 2000 });
    var language3388 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "allowBlank": false, "store": [ [ "de", "German" ], [ "fr", "French" ], [ "nl", "Dutch" ] ] });
    var partner3389 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/users/MySettings/partner", "method": "GET" }) }), "pageSize": 20, "emptyText": "Choisir Partenaire..." });
    var access_class3390 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "forceSelection": true, "allowBlank": false, "store": Lino.cal.AccessClasses });
    var calendar3391 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/users/MySettings/calendar", "method": "GET" }) }), "pageSize": 20, "emptyText": "Choisir Calendrier..." });
    var coaching_type3392 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/users/MySettings/coaching_type", "method": "GET" }) }), "pageSize": 20, "emptyText": "Choisir Service..." });
    var coaching_supervisor3393 = new Ext.form.Checkbox({ "selectOnFocus": true, "checked": false });
    var newcomer_quota3394 = new Ext.form.NumberField({ "selectOnFocus": true, "allowBlank": false, "value": 0 });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ { "colIndex": 0, "sortable": true, "header": "Username", "editable": true, "tooltip": "\n        Required. Must be unique. \n        ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "username", "editor": username3378 }, { "colIndex": 1, "sortable": true, "header": "User Profile", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(47), "dataIndex": "profile", "editor": profile3379 }, { "colIndex": 2, "sortable": true, "header": "Pr\u00e9nom", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "first_name", "editor": first_name3380 }, { "colIndex": 3, "sortable": true, "header": "Nom de famille", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "last_name", "editor": last_name3381 }, new Lino.NullNumberColumn({ "colIndex": 4, "sortable": true, "format": "0", "editable": true, "filter": { "type": "numeric" }, "header": "ID", "renderer": Lino.id_renderer, "editor": id3382, "width": Lino.chars2width(6), "dataIndex": "id" }), { "width": Lino.chars2width(17), "colIndex": 5, "sortable": true, "dataIndex": "created", "header": "Cr\u00e9\u00e9", "editable": false }, { "width": Lino.chars2width(17), "colIndex": 6, "sortable": true, "dataIndex": "modified", "header": "Modified", "editable": false }, { "colIndex": 7, "sortable": true, "header": "Password", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "password", "hidden": true, "editor": password3385 }, { "colIndex": 8, "sortable": true, "header": "adresse e-mail", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "email", "editor": email3386 }, { "colIndex": 9, "sortable": false, "header": "Remarques", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(61), "renderer": Lino.text_renderer, "hidden": true, "editor": remarks3387, "dataIndex": "remarks" }, { "colIndex": 10, "sortable": true, "header": "Langue", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "language", "editor": language3388 }, { "colIndex": 11, "sortable": true, "header": "Partenaire", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('partnerHidden','Lino.contacts.Partners.detail'), "editor": partner3389, "dataIndex": "partner" }, { "colIndex": 12, "sortable": true, "header": "Classe d'acc\u00e8s par d\u00e9faut", "editable": true, "tooltip": "The default access class for your calendar events and tasks.", "filter": { "type": "string" }, "width": Lino.chars2width(13), "dataIndex": "access_class", "editor": access_class3390 }, { "colIndex": 13, "sortable": true, "header": "Calendrier par d\u00e9faut", "editable": true, "tooltip": "Le calendrier par d\u00e9faut pour vos rendez-vous et t\u00e2ches.", "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('calendarHidden','Lino.cal.Calendars.detail'), "editor": calendar3391, "dataIndex": "calendar" }, { "colIndex": 14, "sortable": true, "header": "Service", "editable": true, "tooltip": "The default CoachingType used when creating Coachings.", "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "coaching_type", "editor": coaching_type3392 }, { "colIndex": 15, "sortable": false, "xtype": "checkcolumn", "header": "Notify me when a coach has been assigned", "editable": true, "tooltip": "Wenn ein Neuantrag einem Begleiter zugewiesen wurde, wird au\u00dfer dem Begleiter auch dieser Benutzer benachrichtigt.", "filter": { "type": "boolean" }, "width": Lino.chars2width(11), "dataIndex": "coaching_supervisor" }, new Lino.NullNumberColumn({ "colIndex": 16, "sortable": true, "format": "0", "editable": true, "tooltip": "Wieviel Arbeitszeit dieser Benutzer f\u00fcr Neuantr\u00e4ge zur Verf\u00fcgung steht\n(100 = ganztags, 50 = halbtags, 0 = gar nicht).\nWenn zwei Benutzer die gleiche Belastungspunktzahl haben, \naber einer davon sich nur zu 50% um Neuantr\u00e4ge k\u00fcmmert, \ngilt er als doppelt so belastet wie sein Kollege.\n", "filter": { "type": "numeric" }, "header": "Quota nouvelles demandes", "dataIndex": "newcomer_quota", "width": Lino.chars2width(6), "editor": newcomer_quota3394 }) ];
    Lino.users.MySettings.GridPanel.superclass.initComponent.call(this);
  }
});


Lino.users.MySettings.detailPanel = Ext.extend(Lino.users.Users.DetailFormPanel,{
  empty_title: "Utilisateurs",
  ls_bbar_actions: [ { "itemId": "put", "menu_item_text": "Enregistrer", "tooltip": "Save changes in this form", "panel_btn_handler": function(panel){panel.save(null,false,'put')}, "iconCls": "x-tbar-save", "overflowText": "Enregistrer", "auto_save": false }, { "itemId": "update_reminders", "menu_item_text": "Update Reminders", "must_save": true, "panel_btn_handler": Lino.row_action_handler('update_reminders','GET'), "text": "Update Reminders", "overflowText": "Update Reminders", "auto_save": true } ],
  ls_url: "/users/MySettings",
  initComponent : function() {
    this.ls_detail_handler = Lino.users.MySettings.detail;
    this.ls_insert_handler = Lino.users.Users.insert;
    Lino.users.MySettings.detailPanel.superclass.initComponent.call(this);
  }
});

Lino.users.MySettings.detail = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.users.MySettings.detailPanel(p);
});

Lino.users.MySettings.detailPanel = Ext.extend(Lino.users.Users.DetailFormPanel,{
  empty_title: "Utilisateurs",
  ls_bbar_actions: [ { "itemId": "put", "menu_item_text": "Enregistrer", "tooltip": "Save changes in this form", "panel_btn_handler": function(panel){panel.save(null,false,'put')}, "iconCls": "x-tbar-save", "overflowText": "Enregistrer", "auto_save": false }, { "itemId": "update_reminders", "menu_item_text": "Update Reminders", "must_save": true, "panel_btn_handler": Lino.row_action_handler('update_reminders','GET'), "text": "Update Reminders", "overflowText": "Update Reminders", "auto_save": true } ],
  ls_url: "/users/MySettings",
  initComponent : function() {
    this.ls_detail_handler = Lino.users.MySettings.detail;
    this.ls_insert_handler = Lino.users.Users.insert;
    Lino.users.MySettings.detailPanel.superclass.initComponent.call(this);
  }
});

Lino.users.MySettings.detail = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.users.MySettings.detailPanel(p);
});

// js_render_GridPanel_class users.UsersOverview
Lino.users.UsersOverview.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "No data to display." },
  ls_url : "/users/UsersOverview",
  ls_bbar_actions : [ { "itemId": "insert", "menu_item_text": "Nouveau", "must_save": true, "tooltip": "Insert a new record", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-new", "overflowText": "Nouveau", "auto_save": true }, { "itemId": "detail", "menu_item_text": "D\u00e9tail", "tooltip": "Open a detail window on this record", "panel_btn_handler": Lino.show_detail, "iconCls": "x-tbar-detail", "overflowText": "D\u00e9tail", "auto_save": true }, { "itemId": null, "menu_item_text": "Supprimer", "tooltip": "Delete this record", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "Supprimer", "auto_save": false }, { "itemId": "update_reminders", "menu_item_text": "Update Reminders", "must_save": true, "panel_btn_handler": Lino.row_action_handler('update_reminders','GET'), "text": "Update Reminders", "overflowText": "Update Reminders", "auto_save": true } ],
  title : "Utilisateurs",
  page_length : 20,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "name": "username" }, { "name": "profile" }, 'profileHidden', { "name": "language" }, 'languageHidden', { "type": "int", "name": "id" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 5,
  ls_grid_configs : [  ],
  content_type : 7,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 7,
  initComponent : function() {
    this.ls_detail_handler = Lino.users.UsersOverview.detail;
    this.ls_insert_handler = Lino.users.UsersOverview.insert;
    var ww = this.containing_window;
    var username3396 = new Ext.form.TextField({ "selectOnFocus": true, "allowBlank": false, "maxLength": 30 });
    var profile3397 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "forceSelection": true, "store": Lino.lino.UserProfiles });
    var language3398 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "allowBlank": false, "store": [ [ "de", "German" ], [ "fr", "French" ], [ "nl", "Dutch" ] ] });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ { "colIndex": 0, "sortable": true, "header": "Username", "editable": true, "tooltip": "\n        Required. Must be unique. \n        ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "username", "editor": username3396 }, { "colIndex": 1, "sortable": true, "header": "User Profile", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(47), "dataIndex": "profile", "editor": profile3397 }, { "colIndex": 2, "sortable": true, "header": "Langue", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "language", "editor": language3398 } ];
    Lino.users.UsersOverview.GridPanel.superclass.initComponent.call(this);
  }
});


Lino.users.UsersOverview.insertPanel = Ext.extend(Lino.users.Users.InsertFormPanel,{
  empty_title: "Nouveau Utilisateurs",
  hide_navigator: true,
  ls_bbar_actions: [ { "itemId": "post", "menu_item_text": "Cr\u00e9er", "tooltip": "Create the record and open a detail window on it", "panel_btn_handler": function(panel){panel.save(null,true,'post')}, "text": "Cr\u00e9er", "overflowText": "Cr\u00e9er", "auto_save": false }, { "itemId": "poststay", "menu_item_text": "Create without detail", "tooltip": "Don't open a detail window on the new record", "panel_btn_handler": function(panel){panel.save(null,false,'poststay')}, "text": "Create without detail", "overflowText": "Create without detail", "auto_save": false } ],
  ls_url: "/users/UsersOverview",
  action_name: "insert",
  initComponent : function() {
    this.ls_detail_handler = Lino.users.UsersOverview.detail;
    this.ls_insert_handler = Lino.users.UsersOverview.insert;
    Lino.users.UsersOverview.insertPanel.superclass.initComponent.call(this);
  }
});

Lino.users.UsersOverview.insert = new Lino.WindowAction({ "draggable": true, "width": Lino.chars2width(60), "autoHeight": true, "maximizable": true, "modal": true, "maximized": false },function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.users.UsersOverview.insertPanel(p);
});

Lino.users.UsersOverview.detailPanel = Ext.extend(Lino.users.Users.DetailFormPanel,{
  empty_title: "D\u00e9tail Utilisateurs",
  ls_bbar_actions: [ { "itemId": "put", "menu_item_text": "Enregistrer", "tooltip": "Save changes in this form", "panel_btn_handler": function(panel){panel.save(null,false,'put')}, "iconCls": "x-tbar-save", "overflowText": "Enregistrer", "auto_save": false }, { "itemId": "insert", "menu_item_text": "Nouveau", "must_save": true, "tooltip": "Insert a new record", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-new", "overflowText": "Nouveau", "auto_save": true }, { "itemId": null, "menu_item_text": "Supprimer", "tooltip": "Delete this record", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "Supprimer", "auto_save": false }, { "itemId": "update_reminders", "menu_item_text": "Update Reminders", "must_save": true, "panel_btn_handler": Lino.row_action_handler('update_reminders','GET'), "text": "Update Reminders", "overflowText": "Update Reminders", "auto_save": true } ],
  ls_url: "/users/UsersOverview",
  action_name: "detail",
  initComponent : function() {
    this.ls_detail_handler = Lino.users.UsersOverview.detail;
    this.ls_insert_handler = Lino.users.UsersOverview.insert;
    Lino.users.UsersOverview.detailPanel.superclass.initComponent.call(this);
  }
});

Lino.users.UsersOverview.detail = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.users.UsersOverview.detailPanel(p);
});
Lino.users.UsersOverview.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.users.UsersOverview.GridPanel(p);
});

// js_render_GridPanel_class users.Teams
Lino.users.Teams.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "No data to display." },
  ls_url : "/users/Teams",
  ls_bbar_actions : [ { "itemId": null, "menu_item_text": "Supprimer", "tooltip": "Delete this record", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "Supprimer", "auto_save": false } ],
  title : "Teams",
  page_length : 20,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "type": "int", "name": "id" }, { "name": "name" }, { "name": "name_fr" }, { "name": "name_nl" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 0,
  ls_grid_configs : [  ],
  content_type : 9,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 5,
  initComponent : function() {
    var ww = this.containing_window;
    var id3400 = new Ext.form.NumberField({ "selectOnFocus": true });
    var name3401 = new Ext.form.TextField({ "selectOnFocus": true, "allowBlank": false, "maxLength": 200 });
    var name_fr3402 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var name_nl3403 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ new Lino.NullNumberColumn({ "colIndex": 0, "sortable": true, "format": "0", "editable": true, "filter": { "type": "numeric" }, "header": "ID", "renderer": Lino.id_renderer, "editor": id3400, "width": Lino.chars2width(6), "dataIndex": "id" }), { "colIndex": 1, "sortable": true, "header": "Description", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "name", "editor": name3401 }, { "colIndex": 2, "sortable": true, "header": "Description (fr)", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "name_fr", "editor": name_fr3402 }, { "colIndex": 3, "sortable": true, "header": "Description (nl)", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "name_nl", "editor": name_nl3403 } ];
    Lino.users.Teams.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.users.Teams.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.users.Teams.GridPanel(p);
});

// js_render_GridPanel_class users.Memberships
Lino.users.Memberships.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "No data to display." },
  ls_url : "/users/Memberships",
  ls_bbar_actions : [ { "itemId": null, "menu_item_text": "Supprimer", "tooltip": "Delete this record", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "Supprimer", "auto_save": false } ],
  title : "Membres d'\u00e9quipe",
  page_length : 20,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "type": "int", "name": "id" }, { "name": "user" }, 'userHidden', { "name": "team" }, 'teamHidden', { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 0,
  ls_grid_configs : [  ],
  content_type : 6,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 6,
  initComponent : function() {
    var ww = this.containing_window;
    var id3405 = new Ext.form.NumberField({ "selectOnFocus": true });
    var user3406 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/users/Memberships/user", "method": "GET" }) }), "pageSize": 20, "emptyText": "Choisir Utilisateur..." });
    var team3407 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/users/Memberships/team", "method": "GET" }) }), "allowBlank": false, "pageSize": 20, "emptyText": "Choisir Team..." });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ new Lino.NullNumberColumn({ "colIndex": 0, "sortable": true, "format": "0", "editable": true, "filter": { "type": "numeric" }, "header": "ID", "renderer": Lino.id_renderer, "editor": id3405, "width": Lino.chars2width(6), "dataIndex": "id" }), { "colIndex": 1, "sortable": true, "header": "Auteur", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(16), "renderer": Lino.fk_renderer('userHidden','Lino.users.Users.detail'), "editor": user3406, "dataIndex": "user" }, { "colIndex": 2, "sortable": true, "header": "Team", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "team", "editor": team3407 } ];
    Lino.users.Memberships.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.users.Memberships.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.users.Memberships.GridPanel(p);
});

// js_render_GridPanel_class users.Authorities
Lino.users.Authorities.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "No data to display." },
  ls_url : "/users/Authorities",
  ls_bbar_actions : [ { "itemId": null, "menu_item_text": "Supprimer", "tooltip": "Delete this record", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "Supprimer", "auto_save": false } ],
  title : "Procurations",
  page_length : 20,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "type": "int", "name": "id" }, { "name": "user" }, 'userHidden', { "name": "authorized" }, 'authorizedHidden', { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 0,
  ls_grid_configs : [  ],
  content_type : 8,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 6,
  initComponent : function() {
    var ww = this.containing_window;
    var id3409 = new Ext.form.NumberField({ "selectOnFocus": true });
    var user3410 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/users/Authorities/user", "method": "GET" }) }), "pageSize": 20, "emptyText": "Choisir Utilisateur..." });
    var authorized3411 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/users/Authorities/authorized", "method": "GET" }) }), "allowBlank": false, "pageSize": 20, "emptyText": "Choisir Utilisateur..." });
    this.before_row_edit = function(record) {
      authorized3411.setContextValue('user',record ? record.data['userHidden'] : undefined);
    };
    this.onRender = function(ct, position) {
      user3410.on('change',Lino.chooser_handler(authorized3411,'user'));
      Lino.users.Authorities.GridPanel.superclass.onRender.call(this, ct, position);
    }
    this.ls_columns = [ new Lino.NullNumberColumn({ "colIndex": 0, "sortable": true, "format": "0", "editable": true, "filter": { "type": "numeric" }, "header": "ID", "renderer": Lino.id_renderer, "editor": id3409, "width": Lino.chars2width(6), "dataIndex": "id" }), { "colIndex": 1, "sortable": true, "header": "Auteur", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(16), "renderer": Lino.fk_renderer('userHidden','Lino.users.Users.detail'), "editor": user3410, "dataIndex": "user" }, { "colIndex": 2, "sortable": true, "header": "Utilisateur", "editable": true, "tooltip": "The user who gets authority to act in your name.", "filter": { "type": "string" }, "width": Lino.chars2width(16), "renderer": Lino.fk_renderer('authorizedHidden','Lino.users.Users.detail'), "editor": authorized3411, "dataIndex": "authorized" } ];
    Lino.users.Authorities.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.users.Authorities.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.users.Authorities.GridPanel(p);
});

// js_render_GridPanel_class changes.Changes
Lino.changes.Changes.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "emptyText": "No data to display." },
  ls_url : "/changes/Changes",
  ls_bbar_actions : [ { "itemId": "detail", "menu_item_text": "D\u00e9tail", "tooltip": "Open a detail window on this record", "panel_btn_handler": Lino.show_detail, "iconCls": "x-tbar-detail", "overflowText": "D\u00e9tail", "auto_save": true } ],
  title : "Changes",
  page_length : 20,
  stripeRows : true,
  disable_editing : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "type": "int", "name": "id" }, { "name": "time" }, { "name": "type" }, 'typeHidden', { "name": "user" }, 'userHidden', { "name": "object_type" }, 'object_typeHidden', { "name": "object_id" }, 'object_idHidden', { "name": "master_type" }, 'master_typeHidden', { "name": "master_id" }, 'master_idHidden', { "name": "diff" }, { "name": "object" }, { "name": "master" }, { "name": "disabled_fields" }, { "name": "disabled_actions" } ],
  pk_index : 0,
  ls_grid_configs : [  ],
  content_type : 10,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 18,
  initComponent : function() {
    this.ls_detail_handler = Lino.changes.Changes.detail;
    var ww = this.containing_window;
    var id3413 = new Ext.form.NumberField({ "selectOnFocus": true });
    var time3414 = new Ext.form.DisplayField({ "selectOnFocus": true, "allowBlank": false, "value": "<br>" });
    var type3415 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "forceSelection": true, "allowBlank": false, "store": Lino.lino.ChangeTypes });
    var user3416 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/changes/Changes/user", "method": "GET" }) }), "allowBlank": false, "pageSize": 20, "emptyText": "Choisir Utilisateur..." });
    var object_type3417 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/changes/Changes/object_type", "method": "GET" }) }), "allowBlank": false, "pageSize": 20, "emptyText": "Choisir type de contenu..." });
    var object_id3418 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "allowBlank": false, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/changes/Changes/object_id", "method": "GET" }) }) });
    var master_type3419 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/changes/Changes/master_type", "method": "GET" }) }), "allowBlank": false, "pageSize": 20, "emptyText": "Choisir type de contenu..." });
    var master_id3420 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "allowBlank": false, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/changes/Changes/master_id", "method": "GET" }) }) });
    var diff3421 = new Ext.form.TextArea({ "selectOnFocus": true, "growMax": 2000 });
    var object_disp3422 = new Ext.form.DisplayField({ "disabled": true });
    var master_disp3423 = new Ext.form.DisplayField({ "disabled": true });
    this.before_row_edit = function(record) {
      object_id3418.setContextValue('object_type',record ? record.data['object_typeHidden'] : undefined);
      master_id3420.setContextValue('master_type',record ? record.data['master_typeHidden'] : undefined);
    };
    this.onRender = function(ct, position) {
      object_type3417.on('change',Lino.chooser_handler(object_id3418,'object_type'));
      master_type3419.on('change',Lino.chooser_handler(master_id3420,'master_type'));
      Lino.changes.Changes.GridPanel.superclass.onRender.call(this, ct, position);
    }
    this.ls_columns = [ new Lino.NullNumberColumn({ "colIndex": 0, "sortable": true, "format": "0", "editable": true, "filter": { "type": "numeric" }, "header": "ID", "renderer": Lino.id_renderer, "editor": id3413, "width": Lino.chars2width(6), "dataIndex": "id" }), { "width": Lino.chars2width(17), "colIndex": 1, "sortable": true, "dataIndex": "time", "header": "time", "editable": true, "editor": time3414 }, { "colIndex": 2, "sortable": true, "header": "Change Type", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(16), "dataIndex": "type", "editor": type3415 }, { "colIndex": 3, "sortable": true, "header": "Utilisateur", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(16), "renderer": Lino.fk_renderer('userHidden','Lino.users.Users.detail'), "editor": user3416, "dataIndex": "user" }, { "colIndex": 4, "sortable": true, "header": "Object type", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('object_typeHidden','Lino.ui.ContentTypes.detail'), "editor": object_type3417, "dataIndex": "object_type" }, { "colIndex": 5, "sortable": true, "header": "object id", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(11), "dataIndex": "object_id", "editor": object_id3418 }, { "colIndex": 6, "sortable": true, "header": "Master type", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('master_typeHidden','Lino.ui.ContentTypes.detail'), "editor": master_type3419, "dataIndex": "master_type" }, { "colIndex": 7, "sortable": true, "header": "master id", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(11), "dataIndex": "master_id", "editor": master_id3420 }, { "colIndex": 8, "sortable": false, "header": "Changes", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(61), "renderer": Lino.text_renderer, "editor": diff3421, "dataIndex": "diff" }, { "width": Lino.chars2width(11), "colIndex": 9, "sortable": false, "dataIndex": "object", "header": "Object", "editable": false }, { "width": Lino.chars2width(11), "colIndex": 10, "sortable": false, "dataIndex": "master", "header": "Signal\u00e9tique", "editable": false } ];
    Lino.changes.Changes.GridPanel.superclass.initComponent.call(this);
  }
});


Lino.changes.Changes.detailPanel = Ext.extend(Lino.changes.Changes.DetailFormPanel,{
  empty_title: "D\u00e9tail Changes",
  ls_bbar_actions: [  ],
  ls_url: "/changes/Changes",
  action_name: "detail",
  initComponent : function() {
    this.ls_detail_handler = Lino.changes.Changes.detail;
    Lino.changes.Changes.detailPanel.superclass.initComponent.call(this);
  }
});

Lino.changes.Changes.detail = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.changes.Changes.detailPanel(p);
});
Lino.changes.Changes.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.changes.Changes.GridPanel(p);
});

// js_render_GridPanel_class countries.Languages
Lino.countries.Languages.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "No data to display." },
  ls_url : "/countries/Languages",
  ls_bbar_actions : [ { "itemId": "insert", "menu_item_text": "Nouveau", "must_save": true, "tooltip": "Insert a new record", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-new", "overflowText": "Nouveau", "auto_save": true }, { "itemId": "detail", "menu_item_text": "D\u00e9tail", "tooltip": "Open a detail window on this record", "panel_btn_handler": Lino.show_detail, "iconCls": "x-tbar-detail", "overflowText": "D\u00e9tail", "auto_save": true }, { "itemId": null, "menu_item_text": "Supprimer", "tooltip": "Delete this record", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "Supprimer", "auto_save": false } ],
  title : "Langues",
  page_length : 20,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "name": "name" }, { "name": "name_fr" }, { "name": "name_nl" }, { "name": "id" }, { "name": "iso2" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 3,
  ls_grid_configs : [  ],
  content_type : 12,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 6,
  initComponent : function() {
    this.ls_detail_handler = Lino.countries.Languages.detail;
    this.ls_insert_handler = Lino.countries.Languages.insert;
    var ww = this.containing_window;
    var name3425 = new Ext.form.TextField({ "selectOnFocus": true, "allowBlank": false, "maxLength": 200 });
    var name_fr3426 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var name_nl3427 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var id3428 = new Ext.form.TextField({ "selectOnFocus": true, "boxMinWidth": Lino.chars2width(3), "allowBlank": false, "maxLength": 3 });
    var iso23429 = new Ext.form.TextField({ "selectOnFocus": true, "boxMinWidth": Lino.chars2width(2), "maxLength": 2 });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ { "colIndex": 0, "sortable": true, "header": "Description", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "name", "editor": name3425 }, { "colIndex": 1, "sortable": true, "header": "Description (fr)", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "name_fr", "editor": name_fr3426 }, { "colIndex": 2, "sortable": true, "header": "Description (nl)", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "name_nl", "editor": name_nl3427 }, { "colIndex": 3, "sortable": true, "header": "id", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(5), "dataIndex": "id", "editor": id3428 }, { "colIndex": 4, "sortable": true, "header": "iso2", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(5), "dataIndex": "iso2", "editor": iso23429 } ];
    Lino.countries.Languages.GridPanel.superclass.initComponent.call(this);
  }
});


Lino.countries.Languages.insertPanel = Ext.extend(Lino.countries.Languages.DetailFormPanel,{
  empty_title: "Nouveau Langues",
  hide_navigator: true,
  ls_bbar_actions: [ { "itemId": "post", "menu_item_text": "Cr\u00e9er", "tooltip": "Create the record and open a detail window on it", "panel_btn_handler": function(panel){panel.save(null,true,'post')}, "text": "Cr\u00e9er", "overflowText": "Cr\u00e9er", "auto_save": false }, { "itemId": "poststay", "menu_item_text": "Create without detail", "tooltip": "Don't open a detail window on the new record", "panel_btn_handler": function(panel){panel.save(null,false,'poststay')}, "text": "Create without detail", "overflowText": "Create without detail", "auto_save": false } ],
  ls_url: "/countries/Languages",
  action_name: "insert",
  initComponent : function() {
    this.ls_detail_handler = Lino.countries.Languages.detail;
    this.ls_insert_handler = Lino.countries.Languages.insert;
    Lino.countries.Languages.insertPanel.superclass.initComponent.call(this);
  }
});

Lino.countries.Languages.insert = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.countries.Languages.insertPanel(p);
});

Lino.countries.Languages.detailPanel = Ext.extend(Lino.countries.Languages.DetailFormPanel,{
  empty_title: "D\u00e9tail Langues",
  ls_bbar_actions: [ { "itemId": "put", "menu_item_text": "Enregistrer", "tooltip": "Save changes in this form", "panel_btn_handler": function(panel){panel.save(null,false,'put')}, "iconCls": "x-tbar-save", "overflowText": "Enregistrer", "auto_save": false }, { "itemId": "insert", "menu_item_text": "Nouveau", "must_save": true, "tooltip": "Insert a new record", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-new", "overflowText": "Nouveau", "auto_save": true }, { "itemId": null, "menu_item_text": "Supprimer", "tooltip": "Delete this record", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "Supprimer", "auto_save": false } ],
  ls_url: "/countries/Languages",
  action_name: "detail",
  initComponent : function() {
    this.ls_detail_handler = Lino.countries.Languages.detail;
    this.ls_insert_handler = Lino.countries.Languages.insert;
    Lino.countries.Languages.detailPanel.superclass.initComponent.call(this);
  }
});

Lino.countries.Languages.detail = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.countries.Languages.detailPanel(p);
});
Lino.countries.Languages.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.countries.Languages.GridPanel(p);
});

// js_render_GridPanel_class countries.Countries
Lino.countries.Countries.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "No data to display." },
  ls_url : "/countries/Countries",
  ls_bbar_actions : [ { "itemId": "insert", "menu_item_text": "Nouveau", "must_save": true, "tooltip": "Insert a new record", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-new", "overflowText": "Nouveau", "auto_save": true }, { "itemId": "detail", "menu_item_text": "D\u00e9tail", "tooltip": "Open a detail window on this record", "panel_btn_handler": Lino.show_detail, "iconCls": "x-tbar-detail", "overflowText": "D\u00e9tail", "auto_save": true }, { "itemId": null, "menu_item_text": "Supprimer", "tooltip": "Delete this record", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "Supprimer", "auto_save": false } ],
  title : "Pays",
  page_length : 20,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "name": "name" }, { "name": "name_fr" }, { "name": "name_nl" }, { "name": "isocode" }, { "name": "short_code" }, { "name": "iso3" }, { "name": "inscode" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 3,
  ls_grid_configs : [  ],
  content_type : 11,
  ls_id_property : "isocode",
  gc_name : 0,
  disabled_actions_index : 8,
  initComponent : function() {
    this.ls_detail_handler = Lino.countries.Countries.detail;
    this.ls_insert_handler = Lino.countries.Countries.insert;
    var ww = this.containing_window;
    var name3431 = new Ext.form.TextField({ "selectOnFocus": true, "allowBlank": false, "maxLength": 200 });
    var name_fr3432 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var name_nl3433 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var isocode3434 = new Ext.form.TextField({ "selectOnFocus": true, "boxMinWidth": Lino.chars2width(4), "allowBlank": false, "maxLength": 4 });
    var short_code3435 = new Ext.form.TextField({ "selectOnFocus": true, "boxMinWidth": Lino.chars2width(4), "maxLength": 4 });
    var iso33436 = new Ext.form.TextField({ "selectOnFocus": true, "boxMinWidth": Lino.chars2width(3), "maxLength": 3 });
    var inscode3437 = new Ext.form.TextField({ "selectOnFocus": true, "boxMinWidth": Lino.chars2width(3), "maxLength": 3 });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ { "colIndex": 0, "sortable": true, "header": "Description", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "name", "editor": name3431 }, { "colIndex": 1, "sortable": true, "header": "Description (fr)", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "name_fr", "editor": name_fr3432 }, { "colIndex": 2, "sortable": true, "header": "Description (nl)", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "name_nl", "editor": name_nl3433 }, { "colIndex": 3, "sortable": true, "header": "ISO code", "editable": true, "tooltip": "        The two-letter code for this country as defined by ISO 3166-1. \n        For countries that no longer exist it may be a 4-letter code.", "filter": { "type": "string" }, "width": Lino.chars2width(6), "dataIndex": "isocode", "editor": isocode3434 }, { "colIndex": 4, "sortable": true, "header": "Short code", "editable": true, "tooltip": "A short abbreviation for regional usage. Obsolete.", "filter": { "type": "string" }, "width": Lino.chars2width(6), "dataIndex": "short_code", "editor": short_code3435 }, { "colIndex": 5, "sortable": true, "header": "ISO-3 code", "editable": true, "tooltip": "The three-letter code for this country as defined by ISO 3166-1.", "filter": { "type": "string" }, "width": Lino.chars2width(5), "dataIndex": "iso3", "editor": iso33436 }, { "colIndex": 6, "sortable": true, "header": "INS code", "editable": true, "tooltip": "The official code for this country used by statbel.fgov.be", "filter": { "type": "string" }, "width": Lino.chars2width(5), "dataIndex": "inscode", "editor": inscode3437 } ];
    Lino.countries.Countries.GridPanel.superclass.initComponent.call(this);
  }
});


Lino.countries.Countries.insertPanel = Ext.extend(Lino.countries.Countries.DetailFormPanel,{
  empty_title: "Nouveau Pays",
  hide_navigator: true,
  ls_bbar_actions: [ { "itemId": "post", "menu_item_text": "Cr\u00e9er", "tooltip": "Create the record and open a detail window on it", "panel_btn_handler": function(panel){panel.save(null,true,'post')}, "text": "Cr\u00e9er", "overflowText": "Cr\u00e9er", "auto_save": false }, { "itemId": "poststay", "menu_item_text": "Create without detail", "tooltip": "Don't open a detail window on the new record", "panel_btn_handler": function(panel){panel.save(null,false,'poststay')}, "text": "Create without detail", "overflowText": "Create without detail", "auto_save": false } ],
  ls_url: "/countries/Countries",
  action_name: "insert",
  initComponent : function() {
    this.ls_detail_handler = Lino.countries.Countries.detail;
    this.ls_insert_handler = Lino.countries.Countries.insert;
    Lino.countries.Countries.insertPanel.superclass.initComponent.call(this);
  }
});

Lino.countries.Countries.insert = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.countries.Countries.insertPanel(p);
});

Lino.countries.Countries.detailPanel = Ext.extend(Lino.countries.Countries.DetailFormPanel,{
  empty_title: "D\u00e9tail Pays",
  ls_bbar_actions: [ { "itemId": "put", "menu_item_text": "Enregistrer", "tooltip": "Save changes in this form", "panel_btn_handler": function(panel){panel.save(null,false,'put')}, "iconCls": "x-tbar-save", "overflowText": "Enregistrer", "auto_save": false }, { "itemId": "insert", "menu_item_text": "Nouveau", "must_save": true, "tooltip": "Insert a new record", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-new", "overflowText": "Nouveau", "auto_save": true }, { "itemId": null, "menu_item_text": "Supprimer", "tooltip": "Delete this record", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "Supprimer", "auto_save": false } ],
  ls_url: "/countries/Countries",
  action_name: "detail",
  initComponent : function() {
    this.ls_detail_handler = Lino.countries.Countries.detail;
    this.ls_insert_handler = Lino.countries.Countries.insert;
    Lino.countries.Countries.detailPanel.superclass.initComponent.call(this);
  }
});

Lino.countries.Countries.detail = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.countries.Countries.detailPanel(p);
});
Lino.countries.Countries.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.countries.Countries.GridPanel(p);
});

// js_render_GridPanel_class countries.Cities
Lino.countries.Cities.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "No data to display." },
  ls_url : "/countries/Cities",
  ls_bbar_actions : [ { "itemId": "insert", "menu_item_text": "Nouveau", "must_save": true, "tooltip": "Insert a new record", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-new", "overflowText": "Nouveau", "auto_save": true }, { "itemId": "detail", "menu_item_text": "D\u00e9tail", "tooltip": "Open a detail window on this record", "panel_btn_handler": Lino.show_detail, "iconCls": "x-tbar-detail", "overflowText": "D\u00e9tail", "auto_save": true }, { "itemId": null, "menu_item_text": "Supprimer", "tooltip": "Delete this record", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "Supprimer", "auto_save": false } ],
  title : "Places",
  page_length : 20,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "name": "country" }, 'countryHidden', { "name": "name" }, { "name": "name_fr" }, { "name": "name_nl" }, { "name": "type" }, 'typeHidden', { "name": "zip_code" }, { "type": "int", "name": "id" }, { "name": "parent" }, 'parentHidden', { "name": "inscode" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 8,
  ls_grid_configs : [  ],
  content_type : 13,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 13,
  initComponent : function() {
    this.ls_detail_handler = Lino.countries.Cities.detail;
    this.ls_insert_handler = Lino.countries.Cities.insert;
    var ww = this.containing_window;
    var country3439 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/countries/Cities/country", "method": "GET" }) }), "allowBlank": false, "pageSize": 20, "emptyText": "Choisir Pays..." });
    var name3440 = new Ext.form.TextField({ "selectOnFocus": true, "allowBlank": false, "maxLength": 200 });
    var name_fr3441 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var name_nl3442 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var type3443 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/countries/Cities/type", "method": "GET" }) }) });
    var zip_code3444 = new Ext.form.TextField({ "selectOnFocus": true, "boxMinWidth": Lino.chars2width(8), "maxLength": 8 });
    var id3445 = new Ext.form.NumberField({ "selectOnFocus": true });
    var parent3446 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/countries/Cities/parent", "method": "GET" }) }), "pageSize": 20, "emptyText": "Choisir Place..." });
    var inscode3447 = new Ext.form.TextField({ "selectOnFocus": true, "boxMinWidth": Lino.chars2width(5), "maxLength": 5 });
    this.before_row_edit = function(record) {
      type3443.setContextValue('country',record ? record.data['countryHidden'] : undefined);
    };
    this.onRender = function(ct, position) {
      country3439.on('change',Lino.chooser_handler(type3443,'country'));
      Lino.countries.Cities.GridPanel.superclass.onRender.call(this, ct, position);
    }
    this.ls_columns = [ { "colIndex": 0, "sortable": true, "header": "Pays", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('countryHidden','Lino.countries.Countries.detail'), "editor": country3439, "dataIndex": "country" }, { "colIndex": 1, "sortable": true, "header": "Description", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "name", "editor": name3440 }, { "colIndex": 2, "sortable": true, "header": "Description (fr)", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "name_fr", "editor": name_fr3441 }, { "colIndex": 3, "sortable": true, "header": "Description (nl)", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "name_nl", "editor": name_nl3442 }, { "colIndex": 4, "sortable": true, "header": "Place Type", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(11), "dataIndex": "type", "editor": type3443 }, { "colIndex": 5, "sortable": true, "header": "zip code", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(10), "dataIndex": "zip_code", "editor": zip_code3444 }, new Lino.NullNumberColumn({ "colIndex": 6, "sortable": true, "format": "0", "editable": true, "filter": { "type": "numeric" }, "header": "ID", "renderer": Lino.id_renderer, "editor": id3445, "width": Lino.chars2width(6), "dataIndex": "id" }), { "colIndex": 7, "sortable": true, "header": "Part of", "editable": true, "tooltip": "The superordinate geographic place of which this place is a part.", "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('parentHidden','Lino.countries.Cities.detail'), "editor": parent3446, "dataIndex": "parent" }, { "colIndex": 8, "sortable": true, "header": "INS code", "editable": true, "tooltip": "The official code for this place used by statbel.fgov.be", "filter": { "type": "string" }, "width": Lino.chars2width(7), "dataIndex": "inscode", "editor": inscode3447 } ];
    Lino.countries.Cities.GridPanel.superclass.initComponent.call(this);
  }
});


Lino.countries.Cities.insertPanel = Ext.extend(Lino.countries.Cities.DetailFormPanel,{
  empty_title: "Nouveau Places",
  hide_navigator: true,
  ls_bbar_actions: [ { "itemId": "post", "menu_item_text": "Cr\u00e9er", "tooltip": "Create the record and open a detail window on it", "panel_btn_handler": function(panel){panel.save(null,true,'post')}, "text": "Cr\u00e9er", "overflowText": "Cr\u00e9er", "auto_save": false }, { "itemId": "poststay", "menu_item_text": "Create without detail", "tooltip": "Don't open a detail window on the new record", "panel_btn_handler": function(panel){panel.save(null,false,'poststay')}, "text": "Create without detail", "overflowText": "Create without detail", "auto_save": false } ],
  ls_url: "/countries/Cities",
  action_name: "insert",
  initComponent : function() {
    this.ls_detail_handler = Lino.countries.Cities.detail;
    this.ls_insert_handler = Lino.countries.Cities.insert;
    Lino.countries.Cities.insertPanel.superclass.initComponent.call(this);
  }
});

Lino.countries.Cities.insert = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.countries.Cities.insertPanel(p);
});

Lino.countries.Cities.detailPanel = Ext.extend(Lino.countries.Cities.DetailFormPanel,{
  empty_title: "D\u00e9tail Places",
  ls_bbar_actions: [ { "itemId": "put", "menu_item_text": "Enregistrer", "tooltip": "Save changes in this form", "panel_btn_handler": function(panel){panel.save(null,false,'put')}, "iconCls": "x-tbar-save", "overflowText": "Enregistrer", "auto_save": false }, { "itemId": "insert", "menu_item_text": "Nouveau", "must_save": true, "tooltip": "Insert a new record", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-new", "overflowText": "Nouveau", "auto_save": true }, { "itemId": null, "menu_item_text": "Supprimer", "tooltip": "Delete this record", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "Supprimer", "auto_save": false } ],
  ls_url: "/countries/Cities",
  action_name: "detail",
  initComponent : function() {
    this.ls_detail_handler = Lino.countries.Cities.detail;
    this.ls_insert_handler = Lino.countries.Cities.insert;
    Lino.countries.Cities.detailPanel.superclass.initComponent.call(this);
  }
});

Lino.countries.Cities.detail = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.countries.Cities.detailPanel(p);
});
Lino.countries.Cities.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.countries.Cities.GridPanel(p);
});

// js_render_GridPanel_class properties.PropGroups
Lino.properties.PropGroups.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "No data to display." },
  ls_url : "/properties/PropGroups",
  ls_bbar_actions : [ { "itemId": "insert", "menu_item_text": "Nouveau", "must_save": true, "tooltip": "Insert a new record", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-new", "overflowText": "Nouveau", "auto_save": true }, { "itemId": "detail", "menu_item_text": "D\u00e9tail", "tooltip": "Open a detail window on this record", "panel_btn_handler": Lino.show_detail, "iconCls": "x-tbar-detail", "overflowText": "D\u00e9tail", "auto_save": true }, { "itemId": null, "menu_item_text": "Supprimer", "tooltip": "Delete this record", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "Supprimer", "auto_save": false } ],
  title : "Groupes de propri\u00e9t\u00e9s",
  page_length : 20,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "type": "int", "name": "id" }, { "name": "name" }, { "name": "name_fr" }, { "name": "name_nl" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 0,
  ls_grid_configs : [  ],
  content_type : 15,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 5,
  initComponent : function() {
    this.ls_detail_handler = Lino.properties.PropGroups.detail;
    this.ls_insert_handler = Lino.properties.PropGroups.insert;
    var ww = this.containing_window;
    var id3449 = new Ext.form.NumberField({ "selectOnFocus": true });
    var name3450 = new Ext.form.TextField({ "selectOnFocus": true, "allowBlank": false, "maxLength": 200 });
    var name_fr3451 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var name_nl3452 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ new Lino.NullNumberColumn({ "colIndex": 0, "sortable": true, "format": "0", "editable": true, "filter": { "type": "numeric" }, "header": "ID", "renderer": Lino.id_renderer, "editor": id3449, "width": Lino.chars2width(6), "dataIndex": "id" }), { "colIndex": 1, "sortable": true, "header": "Description", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "name", "editor": name3450 }, { "colIndex": 2, "sortable": true, "header": "Description (fr)", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "name_fr", "editor": name_fr3451 }, { "colIndex": 3, "sortable": true, "header": "Description (nl)", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "name_nl", "editor": name_nl3452 } ];
    Lino.properties.PropGroups.GridPanel.superclass.initComponent.call(this);
  }
});


Lino.properties.PropGroups.insertPanel = Ext.extend(Lino.properties.PropGroups.DetailFormPanel,{
  empty_title: "Nouveau Groupes de propri\u00e9t\u00e9s",
  hide_navigator: true,
  ls_bbar_actions: [ { "itemId": "post", "menu_item_text": "Cr\u00e9er", "tooltip": "Create the record and open a detail window on it", "panel_btn_handler": function(panel){panel.save(null,true,'post')}, "text": "Cr\u00e9er", "overflowText": "Cr\u00e9er", "auto_save": false }, { "itemId": "poststay", "menu_item_text": "Create without detail", "tooltip": "Don't open a detail window on the new record", "panel_btn_handler": function(panel){panel.save(null,false,'poststay')}, "text": "Create without detail", "overflowText": "Create without detail", "auto_save": false } ],
  ls_url: "/properties/PropGroups",
  action_name: "insert",
  initComponent : function() {
    this.ls_detail_handler = Lino.properties.PropGroups.detail;
    this.ls_insert_handler = Lino.properties.PropGroups.insert;
    Lino.properties.PropGroups.insertPanel.superclass.initComponent.call(this);
  }
});

Lino.properties.PropGroups.insert = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.properties.PropGroups.insertPanel(p);
});

Lino.properties.PropGroups.detailPanel = Ext.extend(Lino.properties.PropGroups.DetailFormPanel,{
  empty_title: "D\u00e9tail Groupes de propri\u00e9t\u00e9s",
  ls_bbar_actions: [ { "itemId": "put", "menu_item_text": "Enregistrer", "tooltip": "Save changes in this form", "panel_btn_handler": function(panel){panel.save(null,false,'put')}, "iconCls": "x-tbar-save", "overflowText": "Enregistrer", "auto_save": false }, { "itemId": "insert", "menu_item_text": "Nouveau", "must_save": true, "tooltip": "Insert a new record", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-new", "overflowText": "Nouveau", "auto_save": true }, { "itemId": null, "menu_item_text": "Supprimer", "tooltip": "Delete this record", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "Supprimer", "auto_save": false } ],
  ls_url: "/properties/PropGroups",
  action_name: "detail",
  initComponent : function() {
    this.ls_detail_handler = Lino.properties.PropGroups.detail;
    this.ls_insert_handler = Lino.properties.PropGroups.insert;
    Lino.properties.PropGroups.detailPanel.superclass.initComponent.call(this);
  }
});

Lino.properties.PropGroups.detail = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.properties.PropGroups.detailPanel(p);
});
Lino.properties.PropGroups.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.properties.PropGroups.GridPanel(p);
});

// js_render_GridPanel_class properties.PropTypes
Lino.properties.PropTypes.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "No data to display." },
  ls_url : "/properties/PropTypes",
  ls_bbar_actions : [ { "itemId": "insert", "menu_item_text": "Nouveau", "must_save": true, "tooltip": "Insert a new record", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-new", "overflowText": "Nouveau", "auto_save": true }, { "itemId": "detail", "menu_item_text": "D\u00e9tail", "tooltip": "Open a detail window on this record", "panel_btn_handler": Lino.show_detail, "iconCls": "x-tbar-detail", "overflowText": "D\u00e9tail", "auto_save": true }, { "itemId": null, "menu_item_text": "Supprimer", "tooltip": "Delete this record", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "Supprimer", "auto_save": false } ],
  title : "Types de propri\u00e9t\u00e9s",
  page_length : 20,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "type": "int", "name": "id" }, { "name": "name" }, { "name": "name_fr" }, { "name": "name_nl" }, { "name": "choicelist" }, 'choicelistHidden', { "name": "default_value" }, 'default_valueHidden', { "type": "boolean", "name": "limit_to_choices" }, { "type": "boolean", "name": "multiple_choices" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 0,
  ls_grid_configs : [  ],
  content_type : 16,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 11,
  initComponent : function() {
    this.ls_detail_handler = Lino.properties.PropTypes.detail;
    this.ls_insert_handler = Lino.properties.PropTypes.insert;
    var ww = this.containing_window;
    var id3454 = new Ext.form.NumberField({ "selectOnFocus": true });
    var name3455 = new Ext.form.TextField({ "selectOnFocus": true, "allowBlank": false, "maxLength": 200 });
    var name_fr3456 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var name_nl3457 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var choicelist3458 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "store": [ [ "countries.CityTypes", "CityTypes" ], [ "lino.ChangeTypes", "Change Types" ], [ "lino.Genders", "Genders" ], [ "lino.UserGroups", "User Groups" ], [ "lino.UserLevels", "User Levels" ], [ "lino.UserProfiles", "User Profiles" ], [ "properties.DoYouLike", "DoYouLike" ], [ "properties.HowWell", "HowWell" ] ] });
    var default_value3459 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/properties/PropTypes/default_value", "method": "GET" }) }) });
    var limit_to_choices3460 = new Ext.form.Checkbox({ "selectOnFocus": true, "checked": false });
    var multiple_choices3461 = new Ext.form.Checkbox({ "selectOnFocus": true, "checked": false });
    this.before_row_edit = function(record) {
      default_value3459.setContextValue('choicelist',record ? record.data['choicelistHidden'] : undefined);
    };
    this.onRender = function(ct, position) {
      choicelist3458.on('change',Lino.chooser_handler(default_value3459,'choicelist'));
      Lino.properties.PropTypes.GridPanel.superclass.onRender.call(this, ct, position);
    }
    this.ls_columns = [ new Lino.NullNumberColumn({ "colIndex": 0, "sortable": true, "format": "0", "editable": true, "filter": { "type": "numeric" }, "header": "ID", "renderer": Lino.id_renderer, "editor": id3454, "width": Lino.chars2width(6), "dataIndex": "id" }), { "colIndex": 1, "sortable": true, "header": "Description", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "name", "editor": name3455 }, { "colIndex": 2, "sortable": true, "header": "Description (fr)", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "name_fr", "editor": name_fr3456 }, { "colIndex": 3, "sortable": true, "header": "Description (nl)", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "name_nl", "editor": name_nl3457 }, { "colIndex": 4, "sortable": true, "header": "Liste de choix", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "choicelist", "editor": choicelist3458 }, { "colIndex": 5, "sortable": true, "header": "valeur par d\u00e9fault", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(11), "dataIndex": "default_value", "editor": default_value3459 }, { "colIndex": 6, "sortable": false, "xtype": "checkcolumn", "header": "Limite aux choix", "editable": true, "filter": { "type": "boolean" }, "width": Lino.chars2width(11), "dataIndex": "limit_to_choices" }, { "colIndex": 7, "sortable": false, "xtype": "checkcolumn", "header": "Choix multiples", "editable": true, "filter": { "type": "boolean" }, "width": Lino.chars2width(11), "dataIndex": "multiple_choices" } ];
    Lino.properties.PropTypes.GridPanel.superclass.initComponent.call(this);
  }
});


Lino.properties.PropTypes.insertPanel = Ext.extend(Lino.properties.PropTypes.DetailFormPanel,{
  empty_title: "Nouveau Types de propri\u00e9t\u00e9s",
  hide_navigator: true,
  ls_bbar_actions: [ { "itemId": "post", "menu_item_text": "Cr\u00e9er", "tooltip": "Create the record and open a detail window on it", "panel_btn_handler": function(panel){panel.save(null,true,'post')}, "text": "Cr\u00e9er", "overflowText": "Cr\u00e9er", "auto_save": false }, { "itemId": "poststay", "menu_item_text": "Create without detail", "tooltip": "Don't open a detail window on the new record", "panel_btn_handler": function(panel){panel.save(null,false,'poststay')}, "text": "Create without detail", "overflowText": "Create without detail", "auto_save": false } ],
  ls_url: "/properties/PropTypes",
  action_name: "insert",
  initComponent : function() {
    this.ls_detail_handler = Lino.properties.PropTypes.detail;
    this.ls_insert_handler = Lino.properties.PropTypes.insert;
    Lino.properties.PropTypes.insertPanel.superclass.initComponent.call(this);
  }
});

Lino.properties.PropTypes.insert = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.properties.PropTypes.insertPanel(p);
});

Lino.properties.PropTypes.detailPanel = Ext.extend(Lino.properties.PropTypes.DetailFormPanel,{
  empty_title: "D\u00e9tail Types de propri\u00e9t\u00e9s",
  ls_bbar_actions: [ { "itemId": "put", "menu_item_text": "Enregistrer", "tooltip": "Save changes in this form", "panel_btn_handler": function(panel){panel.save(null,false,'put')}, "iconCls": "x-tbar-save", "overflowText": "Enregistrer", "auto_save": false }, { "itemId": "insert", "menu_item_text": "Nouveau", "must_save": true, "tooltip": "Insert a new record", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-new", "overflowText": "Nouveau", "auto_save": true }, { "itemId": null, "menu_item_text": "Supprimer", "tooltip": "Delete this record", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "Supprimer", "auto_save": false } ],
  ls_url: "/properties/PropTypes",
  action_name: "detail",
  initComponent : function() {
    this.ls_detail_handler = Lino.properties.PropTypes.detail;
    this.ls_insert_handler = Lino.properties.PropTypes.insert;
    Lino.properties.PropTypes.detailPanel.superclass.initComponent.call(this);
  }
});

Lino.properties.PropTypes.detail = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.properties.PropTypes.detailPanel(p);
});
Lino.properties.PropTypes.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.properties.PropTypes.GridPanel(p);
});

// js_render_GridPanel_class properties.Properties
Lino.properties.Properties.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "No data to display." },
  ls_url : "/properties/Properties",
  ls_bbar_actions : [ { "itemId": "insert", "menu_item_text": "Nouveau", "must_save": true, "tooltip": "Insert a new record", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-new", "overflowText": "Nouveau", "auto_save": true }, { "itemId": "detail", "menu_item_text": "D\u00e9tail", "tooltip": "Open a detail window on this record", "panel_btn_handler": Lino.show_detail, "iconCls": "x-tbar-detail", "overflowText": "D\u00e9tail", "auto_save": true }, { "itemId": null, "menu_item_text": "Supprimer", "tooltip": "Delete this record", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "Supprimer", "auto_save": false } ],
  title : "Propri\u00e9t\u00e9s",
  page_length : 20,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "type": "int", "name": "id" }, { "name": "name" }, { "name": "name_fr" }, { "name": "name_nl" }, { "name": "group" }, 'groupHidden', { "name": "type" }, 'typeHidden', { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 0,
  ls_grid_configs : [  ],
  content_type : 14,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 9,
  initComponent : function() {
    this.ls_detail_handler = Lino.properties.Properties.detail;
    this.ls_insert_handler = Lino.properties.Properties.insert;
    var ww = this.containing_window;
    var id3463 = new Ext.form.NumberField({ "selectOnFocus": true });
    var name3464 = new Ext.form.TextField({ "selectOnFocus": true, "allowBlank": false, "maxLength": 200 });
    var name_fr3465 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var name_nl3466 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var group3467 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/properties/Properties/group", "method": "GET" }) }), "allowBlank": false, "pageSize": 20, "emptyText": "Choisir Groupe de propri\u00e9t\u00e9s..." });
    var type3468 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/properties/Properties/type", "method": "GET" }) }), "allowBlank": false, "pageSize": 20, "emptyText": "Choisir Type de propri\u00e9t\u00e9..." });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ new Lino.NullNumberColumn({ "colIndex": 0, "sortable": true, "format": "0", "editable": true, "filter": { "type": "numeric" }, "header": "ID", "renderer": Lino.id_renderer, "editor": id3463, "width": Lino.chars2width(6), "dataIndex": "id" }), { "colIndex": 1, "sortable": true, "header": "Description", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "name", "editor": name3464 }, { "colIndex": 2, "sortable": true, "header": "Description (fr)", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "name_fr", "editor": name_fr3465 }, { "colIndex": 3, "sortable": true, "header": "Description (nl)", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "name_nl", "editor": name_nl3466 }, { "colIndex": 4, "sortable": true, "header": "Groupe de propri\u00e9t\u00e9s", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('groupHidden','Lino.properties.PropGroups.detail'), "editor": group3467, "dataIndex": "group" }, { "colIndex": 5, "sortable": true, "header": "Type de propri\u00e9t\u00e9", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('typeHidden','Lino.properties.PropTypes.detail'), "editor": type3468, "dataIndex": "type" } ];
    Lino.properties.Properties.GridPanel.superclass.initComponent.call(this);
  }
});


Lino.properties.Properties.insertPanel = Ext.extend(Lino.properties.Properties.DetailFormPanel,{
  empty_title: "Nouveau Propri\u00e9t\u00e9s",
  hide_navigator: true,
  ls_bbar_actions: [ { "itemId": "post", "menu_item_text": "Cr\u00e9er", "tooltip": "Create the record and open a detail window on it", "panel_btn_handler": function(panel){panel.save(null,true,'post')}, "text": "Cr\u00e9er", "overflowText": "Cr\u00e9er", "auto_save": false }, { "itemId": "poststay", "menu_item_text": "Create without detail", "tooltip": "Don't open a detail window on the new record", "panel_btn_handler": function(panel){panel.save(null,false,'poststay')}, "text": "Create without detail", "overflowText": "Create without detail", "auto_save": false } ],
  ls_url: "/properties/Properties",
  action_name: "insert",
  initComponent : function() {
    this.ls_detail_handler = Lino.properties.Properties.detail;
    this.ls_insert_handler = Lino.properties.Properties.insert;
    Lino.properties.Properties.insertPanel.superclass.initComponent.call(this);
  }
});

Lino.properties.Properties.insert = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.properties.Properties.insertPanel(p);
});

Lino.properties.Properties.detailPanel = Ext.extend(Lino.properties.Properties.DetailFormPanel,{
  empty_title: "D\u00e9tail Propri\u00e9t\u00e9s",
  ls_bbar_actions: [ { "itemId": "put", "menu_item_text": "Enregistrer", "tooltip": "Save changes in this form", "panel_btn_handler": function(panel){panel.save(null,false,'put')}, "iconCls": "x-tbar-save", "overflowText": "Enregistrer", "auto_save": false }, { "itemId": "insert", "menu_item_text": "Nouveau", "must_save": true, "tooltip": "Insert a new record", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-new", "overflowText": "Nouveau", "auto_save": true }, { "itemId": null, "menu_item_text": "Supprimer", "tooltip": "Delete this record", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "Supprimer", "auto_save": false } ],
  ls_url: "/properties/Properties",
  action_name: "detail",
  initComponent : function() {
    this.ls_detail_handler = Lino.properties.Properties.detail;
    this.ls_insert_handler = Lino.properties.Properties.insert;
    Lino.properties.Properties.detailPanel.superclass.initComponent.call(this);
  }
});

Lino.properties.Properties.detail = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.properties.Properties.detailPanel(p);
});
Lino.properties.Properties.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.properties.Properties.GridPanel(p);
});

// js_render_GridPanel_class properties.PropChoices
Lino.properties.PropChoices.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "No data to display." },
  ls_url : "/properties/PropChoices",
  ls_bbar_actions : [ { "itemId": null, "menu_item_text": "Supprimer", "tooltip": "Delete this record", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "Supprimer", "auto_save": false } ],
  title : "Choix de propri\u00e9t\u00e9s",
  page_length : 20,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "type": "int", "name": "id" }, { "name": "type" }, 'typeHidden', { "name": "value" }, { "name": "text" }, { "name": "text_fr" }, { "name": "text_nl" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 0,
  ls_grid_configs : [  ],
  content_type : 17,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 8,
  initComponent : function() {
    var ww = this.containing_window;
    var id3470 = new Ext.form.NumberField({ "selectOnFocus": true });
    var type3471 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/properties/PropChoices/type", "method": "GET" }) }), "allowBlank": false, "pageSize": 20, "emptyText": "Choisir Type de propri\u00e9t\u00e9..." });
    var value3472 = new Ext.form.TextField({ "selectOnFocus": true, "allowBlank": false, "maxLength": 200 });
    var text3473 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var text_fr3474 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var text_nl3475 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ new Lino.NullNumberColumn({ "colIndex": 0, "sortable": true, "format": "0", "editable": true, "filter": { "type": "numeric" }, "header": "ID", "renderer": Lino.id_renderer, "editor": id3470, "width": Lino.chars2width(6), "dataIndex": "id" }), { "colIndex": 1, "sortable": true, "header": "Type de propri\u00e9t\u00e9", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('typeHidden','Lino.properties.PropTypes.detail'), "editor": type3471, "dataIndex": "type" }, { "colIndex": 2, "sortable": true, "header": "Valeur", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "value", "editor": value3472 }, { "colIndex": 3, "sortable": true, "header": "Description", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "text", "editor": text3473 }, { "colIndex": 4, "sortable": true, "header": "Description (fr)", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "text_fr", "editor": text_fr3474 }, { "colIndex": 5, "sortable": true, "header": "Description (nl)", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "text_nl", "editor": text_nl3475 } ];
    Lino.properties.PropChoices.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.properties.PropChoices.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.properties.PropChoices.GridPanel(p);
});

// js_render_GridPanel_class contacts.CompanyTypes
Lino.contacts.CompanyTypes.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "No data to display." },
  ls_url : "/contacts/CompanyTypes",
  ls_bbar_actions : [ { "itemId": null, "menu_item_text": "Supprimer", "tooltip": "Delete this record", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "Supprimer", "auto_save": false } ],
  title : "Types d'organisation",
  page_length : 20,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "name": "name" }, { "name": "name_fr" }, { "name": "name_nl" }, { "type": "int", "name": "id" }, { "name": "abbr" }, { "name": "abbr_fr" }, { "name": "abbr_nl" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 3,
  ls_grid_configs : [  ],
  content_type : 24,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 8,
  initComponent : function() {
    var ww = this.containing_window;
    var name3477 = new Ext.form.TextField({ "selectOnFocus": true, "allowBlank": false, "maxLength": 200 });
    var name_fr3478 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var name_nl3479 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var id3480 = new Ext.form.NumberField({ "selectOnFocus": true });
    var abbr3481 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 30 });
    var abbr_fr3482 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 30 });
    var abbr_nl3483 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 30 });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ { "colIndex": 0, "sortable": true, "header": "Description", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "name", "editor": name3477 }, { "colIndex": 1, "sortable": true, "header": "Description (fr)", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "name_fr", "editor": name_fr3478 }, { "colIndex": 2, "sortable": true, "header": "Description (nl)", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "name_nl", "editor": name_nl3479 }, new Lino.NullNumberColumn({ "colIndex": 3, "sortable": true, "format": "0", "editable": true, "filter": { "type": "numeric" }, "header": "ID", "renderer": Lino.id_renderer, "editor": id3480, "width": Lino.chars2width(6), "dataIndex": "id" }), { "colIndex": 4, "sortable": true, "header": "Abbr\u00e9viation", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "abbr", "editor": abbr3481 }, { "colIndex": 5, "sortable": true, "header": "Abbr\u00e9viation (fr)", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "abbr_fr", "editor": abbr_fr3482 }, { "colIndex": 6, "sortable": true, "header": "Abbr\u00e9viation (nl)", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "abbr_nl", "editor": abbr_nl3483 } ];
    Lino.contacts.CompanyTypes.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.contacts.CompanyTypes.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.contacts.CompanyTypes.GridPanel(p);
});

// js_render_GridPanel_class contacts.Partners
Lino.contacts.Partners.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "No data to display." },
  ls_url : "/contacts/Partners",
  ls_bbar_actions : [ { "itemId": "insert", "menu_item_text": "Nouveau", "must_save": true, "tooltip": "Insert a new record", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-new", "overflowText": "Nouveau", "auto_save": true }, { "itemId": "detail", "menu_item_text": "D\u00e9tail", "tooltip": "Open a detail window on this record", "panel_btn_handler": Lino.show_detail, "iconCls": "x-tbar-detail", "overflowText": "D\u00e9tail", "auto_save": true }, { "itemId": null, "menu_item_text": "Supprimer", "tooltip": "Delete this record", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "Supprimer", "auto_save": false } ],
  title : "Partenaires",
  page_length : 20,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "name": "name" }, { "name": "email" }, { "name": "created" }, { "name": "modified" }, { "name": "country" }, 'countryHidden', { "name": "city" }, 'cityHidden', { "name": "region" }, 'regionHidden', { "name": "zip_code" }, { "name": "addr1" }, { "name": "street_prefix" }, { "name": "street" }, { "name": "street_no" }, { "name": "street_box" }, { "name": "addr2" }, { "name": "language" }, 'languageHidden', { "name": "url" }, { "name": "phone" }, { "name": "gsm" }, { "name": "fax" }, { "name": "remarks" }, { "type": "boolean", "name": "is_obsolete" }, { "name": "activity" }, 'activityHidden', { "name": "bank_account1" }, { "name": "bank_account2" }, { "type": "int", "name": "id" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 29,
  ls_grid_configs : [  ],
  content_type : 23,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 31,
  initComponent : function() {
    this.ls_detail_handler = Lino.contacts.Partners.detail;
    this.ls_insert_handler = Lino.contacts.Partners.insert;
    var ww = this.containing_window;
    var name3485 = new Ext.form.TextField({ "selectOnFocus": true, "allowBlank": false, "maxLength": 200 });
    var email3486 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 75 });
    var created3487 = new Ext.form.DisplayField({ "disabled": true, "value": "<br>" });
    var modified3488 = new Ext.form.DisplayField({ "disabled": true, "value": "<br>" });
    var country3489 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/contacts/Partners/country", "method": "GET" }) }), "pageSize": 20, "emptyText": "Choisir Pays..." });
    var city3490 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "forceSelection": false, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/contacts/Partners/city", "method": "GET" }) }), "pageSize": 20, "emptyText": "Choisir Place..." });
    var region3491 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/contacts/Partners/region", "method": "GET" }) }), "pageSize": 20, "emptyText": "Choisir Place..." });
    var zip_code3492 = new Ext.form.TextField({ "selectOnFocus": true, "boxMinWidth": Lino.chars2width(10), "maxLength": 10 });
    var addr13493 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var street_prefix3494 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var street3495 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var street_no3496 = new Ext.form.TextField({ "selectOnFocus": true, "boxMinWidth": Lino.chars2width(10), "maxLength": 10 });
    var street_box3497 = new Ext.form.TextField({ "selectOnFocus": true, "boxMinWidth": Lino.chars2width(10), "maxLength": 10 });
    var addr23498 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var language3499 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "store": [ [ "de", "German" ], [ "fr", "French" ], [ "nl", "Dutch" ] ], "allowBlank": false, "value": "de" });
    var url3500 = new Lino.URLField({ "selectOnFocus": true, "maxLength": 200 });
    var phone3501 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var gsm3502 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var fax3503 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var remarks3504 = new Ext.form.TextArea({ "selectOnFocus": true, "growMax": 2000 });
    var is_obsolete3505 = new Ext.form.Checkbox({ "selectOnFocus": true, "checked": false });
    var activity3506 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/contacts/Partners/activity", "method": "GET" }) }), "pageSize": 20, "emptyText": "Choisir Activit\u00e9..." });
    var bank_account13507 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 40 });
    var bank_account23508 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 40 });
    var id3509 = new Ext.form.NumberField({ "selectOnFocus": true });
    this.before_row_edit = function(record) {
      city3490.setContextValue('country',record ? record.data['countryHidden'] : undefined);
      city3490.setContextValue('region',record ? record.data['regionHidden'] : undefined);
      region3491.setContextValue('country',record ? record.data['countryHidden'] : undefined);
    };
    this.onRender = function(ct, position) {
      country3489.on('change',Lino.chooser_handler(city3490,'country'));
      region3491.on('change',Lino.chooser_handler(city3490,'region'));
      country3489.on('change',Lino.chooser_handler(region3491,'country'));
      Lino.contacts.Partners.GridPanel.superclass.onRender.call(this, ct, position);
    }
    this.ls_columns = [ { "colIndex": 0, "sortable": true, "header": "Name", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "name", "editor": name3485 }, { "colIndex": 1, "sortable": true, "header": "E-mail", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "email", "editor": email3486 }, { "width": Lino.chars2width(17), "colIndex": 2, "sortable": true, "dataIndex": "created", "header": "Cr\u00e9\u00e9", "hidden": true, "editable": false }, { "width": Lino.chars2width(17), "colIndex": 3, "sortable": true, "dataIndex": "modified", "header": "Modified", "hidden": true, "editable": false }, { "colIndex": 4, "sortable": true, "header": "Pays", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('countryHidden','Lino.countries.Countries.detail'), "editor": country3489, "dataIndex": "country" }, { "colIndex": 5, "sortable": true, "header": "Place", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('cityHidden','Lino.countries.Cities.detail'), "editor": city3490, "dataIndex": "city" }, { "colIndex": 6, "sortable": true, "header": "Region", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('regionHidden','Lino.countries.Cities.detail'), "editor": region3491, "dataIndex": "region" }, { "colIndex": 7, "sortable": true, "header": "Zip code", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(12), "dataIndex": "zip_code", "editor": zip_code3492 }, { "colIndex": 8, "sortable": true, "header": "Ligne avant le nom de rue", "editable": true, "tooltip": "Address line before street", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "addr1", "editor": addr13493 }, { "colIndex": 9, "sortable": true, "header": "Pr\u00e9fixe rue", "editable": true, "tooltip": "Text to print before name of street, but to ignore for sorting.", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "street_prefix", "editor": street_prefix3494 }, { "colIndex": 10, "sortable": true, "header": "Rue", "editable": true, "tooltip": "Name of street. Without house number.", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "street", "editor": street3495 }, { "colIndex": 11, "sortable": true, "header": "N\u00b0", "editable": true, "tooltip": "House number", "filter": { "type": "string" }, "width": Lino.chars2width(12), "dataIndex": "street_no", "editor": street_no3496 }, { "colIndex": 12, "sortable": true, "header": "bo\u00eete", "editable": true, "tooltip": "Text to print after :attr:`steet_no` on the same line", "filter": { "type": "string" }, "width": Lino.chars2width(12), "dataIndex": "street_box", "editor": street_box3497 }, { "colIndex": 13, "sortable": true, "header": "Ligne apr\u00e8s le nom de rue", "editable": true, "tooltip": "Address line to print below street line", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "addr2", "editor": addr23498 }, { "colIndex": 14, "sortable": true, "header": "Langue", "editable": true, "tooltip": "Die Sprache, in der Dokumente ausgestellt werden sollen.", "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "language", "editor": language3499 }, { "colIndex": 15, "sortable": true, "header": "URL", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "url", "editor": url3500 }, { "colIndex": 16, "sortable": true, "header": "T\u00e9l\u00e9phone", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "phone", "editor": phone3501 }, { "colIndex": 17, "sortable": true, "header": "GSM", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "gsm", "editor": gsm3502 }, { "colIndex": 18, "sortable": true, "header": "Fax", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "fax", "editor": fax3503 }, { "colIndex": 19, "sortable": false, "header": "Remarques", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(61), "renderer": Lino.text_renderer, "editor": remarks3504, "dataIndex": "remarks" }, { "colIndex": 20, "sortable": false, "xtype": "checkcolumn", "header": "obsolete", "editable": true, "tooltip": "Altf\u00e4lle sind Partner, deren Stammdaten nicht mehr gepflegt werden und \nf\u00fcr neue Operationen nicht benutzt werden k\u00f6nnen.", "filter": { "type": "boolean" }, "width": Lino.chars2width(11), "dataIndex": "is_obsolete" }, { "colIndex": 21, "sortable": true, "header": "Activit\u00e9", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "activity", "hidden": true, "editor": activity3506 }, { "colIndex": 22, "sortable": true, "header": "Compte en banque 1", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "bank_account1", "hidden": true, "editor": bank_account13507 }, { "colIndex": 23, "sortable": true, "header": "Compte en banque 2", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "bank_account2", "hidden": true, "editor": bank_account23508 }, new Lino.NullNumberColumn({ "colIndex": 24, "sortable": true, "format": "0", "editable": true, "filter": { "type": "numeric" }, "header": "ID", "renderer": Lino.id_renderer, "editor": id3509, "width": Lino.chars2width(6), "dataIndex": "id" }) ];
    Lino.contacts.Partners.GridPanel.superclass.initComponent.call(this);
  }
});


Lino.contacts.Partners.insertPanel = Ext.extend(Lino.contacts.Partners.InsertFormPanel,{
  empty_title: "Nouveau Partenaires",
  hide_navigator: true,
  ls_bbar_actions: [ { "itemId": "post", "menu_item_text": "Cr\u00e9er", "tooltip": "Create the record and open a detail window on it", "panel_btn_handler": function(panel){panel.save(null,true,'post')}, "text": "Cr\u00e9er", "overflowText": "Cr\u00e9er", "auto_save": false }, { "itemId": "poststay", "menu_item_text": "Create without detail", "tooltip": "Don't open a detail window on the new record", "panel_btn_handler": function(panel){panel.save(null,false,'poststay')}, "text": "Create without detail", "overflowText": "Create without detail", "auto_save": false } ],
  ls_url: "/contacts/Partners",
  action_name: "insert",
  initComponent : function() {
    this.ls_detail_handler = Lino.contacts.Partners.detail;
    this.ls_insert_handler = Lino.contacts.Partners.insert;
    Lino.contacts.Partners.insertPanel.superclass.initComponent.call(this);
  }
});

Lino.contacts.Partners.insert = new Lino.WindowAction({ "draggable": true, "width": Lino.chars2width(40), "autoHeight": true, "maximizable": true, "modal": true, "maximized": false },function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.contacts.Partners.insertPanel(p);
});

Lino.contacts.Partners.detailPanel = Ext.extend(Lino.contacts.Partners.DetailFormPanel,{
  empty_title: "D\u00e9tail Partenaires",
  ls_bbar_actions: [ { "itemId": "put", "menu_item_text": "Enregistrer", "tooltip": "Save changes in this form", "panel_btn_handler": function(panel){panel.save(null,false,'put')}, "iconCls": "x-tbar-save", "overflowText": "Enregistrer", "auto_save": false }, { "itemId": "insert", "menu_item_text": "Nouveau", "must_save": true, "tooltip": "Insert a new record", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-new", "overflowText": "Nouveau", "auto_save": true }, { "itemId": null, "menu_item_text": "Supprimer", "tooltip": "Delete this record", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "Supprimer", "auto_save": false } ],
  ls_url: "/contacts/Partners",
  action_name: "detail",
  initComponent : function() {
    this.ls_detail_handler = Lino.contacts.Partners.detail;
    this.ls_insert_handler = Lino.contacts.Partners.insert;
    Lino.contacts.Partners.detailPanel.superclass.initComponent.call(this);
  }
});

Lino.contacts.Partners.detail = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.contacts.Partners.detailPanel(p);
});
Lino.contacts.Partners.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.contacts.Partners.GridPanel(p);
});

// js_render_GridPanel_class contacts.Companies
Lino.contacts.Companies.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "No data to display." },
  ls_url : "/contacts/Companies",
  ls_bbar_actions : [ { "itemId": "insert", "menu_item_text": "Nouveau", "must_save": true, "tooltip": "Insert a new record", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-new", "overflowText": "Nouveau", "auto_save": true }, { "itemId": "detail", "menu_item_text": "D\u00e9tail", "tooltip": "Open a detail window on this record", "panel_btn_handler": Lino.show_detail, "iconCls": "x-tbar-detail", "overflowText": "D\u00e9tail", "auto_save": true }, { "itemId": null, "menu_item_text": "Supprimer", "tooltip": "Delete this record", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "Supprimer", "auto_save": false }, { "itemId": "merge_row", "menu_item_text": "Merge", "tooltip": "Merge this object into another object of same class.", "panel_btn_handler": Lino.param_action_handler(Lino.contacts.Companies.merge_row), "text": "Merge", "overflowText": "Merge", "auto_save": true } ],
  title : "Organisations",
  page_length : 20,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "name": "name" }, { "name": "email" }, { "name": "created" }, { "name": "modified" }, { "name": "country" }, 'countryHidden', { "name": "city" }, 'cityHidden', { "name": "region" }, 'regionHidden', { "name": "zip_code" }, { "name": "addr1" }, { "name": "street_prefix" }, { "name": "street" }, { "name": "street_no" }, { "name": "street_box" }, { "name": "addr2" }, { "name": "language" }, 'languageHidden', { "name": "url" }, { "name": "phone" }, { "name": "gsm" }, { "name": "fax" }, { "name": "remarks" }, { "type": "boolean", "name": "is_obsolete" }, { "name": "activity" }, 'activityHidden', { "name": "bank_account1" }, { "name": "bank_account2" }, { "name": "prefix" }, { "name": "vat_id" }, { "name": "type" }, 'typeHidden', { "name": "client_contact_type" }, 'client_contact_typeHidden', { "type": "int", "name": "id" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 35,
  ls_grid_configs : [  ],
  content_type : 20,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 37,
  initComponent : function() {
    this.ls_detail_handler = Lino.contacts.Companies.detail;
    this.ls_insert_handler = Lino.contacts.Companies.insert;
    var ww = this.containing_window;
    var name3511 = new Ext.form.TextField({ "selectOnFocus": true, "allowBlank": false, "maxLength": 200 });
    var email3512 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 75 });
    var created3513 = new Ext.form.DisplayField({ "disabled": true, "value": "<br>" });
    var modified3514 = new Ext.form.DisplayField({ "disabled": true, "value": "<br>" });
    var country3515 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/contacts/Companies/country", "method": "GET" }) }), "pageSize": 20, "emptyText": "Choisir Pays..." });
    var city3516 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "forceSelection": false, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/contacts/Companies/city", "method": "GET" }) }), "pageSize": 20, "emptyText": "Choisir Place..." });
    var region3517 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/contacts/Companies/region", "method": "GET" }) }), "pageSize": 20, "emptyText": "Choisir Place..." });
    var zip_code3518 = new Ext.form.TextField({ "selectOnFocus": true, "boxMinWidth": Lino.chars2width(10), "maxLength": 10 });
    var addr13519 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var street_prefix3520 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var street3521 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var street_no3522 = new Ext.form.TextField({ "selectOnFocus": true, "boxMinWidth": Lino.chars2width(10), "maxLength": 10 });
    var street_box3523 = new Ext.form.TextField({ "selectOnFocus": true, "boxMinWidth": Lino.chars2width(10), "maxLength": 10 });
    var addr23524 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var language3525 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "store": [ [ "de", "German" ], [ "fr", "French" ], [ "nl", "Dutch" ] ], "allowBlank": false, "value": "de" });
    var url3526 = new Lino.URLField({ "selectOnFocus": true, "maxLength": 200 });
    var phone3527 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var gsm3528 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var fax3529 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var remarks3530 = new Ext.form.TextArea({ "selectOnFocus": true, "growMax": 2000 });
    var is_obsolete3531 = new Ext.form.Checkbox({ "selectOnFocus": true, "checked": false });
    var activity3532 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/contacts/Companies/activity", "method": "GET" }) }), "pageSize": 20, "emptyText": "Choisir Activit\u00e9..." });
    var bank_account13533 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 40 });
    var bank_account23534 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 40 });
    var prefix3535 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var vat_id3536 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var type3537 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/contacts/Companies/type", "method": "GET" }) }), "pageSize": 20, "emptyText": "Choisir Type d'organisation..." });
    var client_contact_type3538 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/contacts/Companies/client_contact_type", "method": "GET" }) }), "pageSize": 20, "emptyText": "Choisir Type de contact client..." });
    var id3539 = new Ext.form.NumberField({ "selectOnFocus": true });
    this.before_row_edit = function(record) {
      city3516.setContextValue('country',record ? record.data['countryHidden'] : undefined);
      city3516.setContextValue('region',record ? record.data['regionHidden'] : undefined);
      region3517.setContextValue('country',record ? record.data['countryHidden'] : undefined);
    };
    this.onRender = function(ct, position) {
      country3515.on('change',Lino.chooser_handler(city3516,'country'));
      region3517.on('change',Lino.chooser_handler(city3516,'region'));
      country3515.on('change',Lino.chooser_handler(region3517,'country'));
      Lino.contacts.Companies.GridPanel.superclass.onRender.call(this, ct, position);
    }
    this.ls_columns = [ { "colIndex": 0, "sortable": true, "header": "Name", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "name", "editor": name3511 }, { "colIndex": 1, "sortable": true, "header": "E-mail", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "email", "editor": email3512 }, { "width": Lino.chars2width(17), "colIndex": 2, "sortable": true, "dataIndex": "created", "header": "Cr\u00e9\u00e9", "hidden": true, "editable": false }, { "width": Lino.chars2width(17), "colIndex": 3, "sortable": true, "dataIndex": "modified", "header": "Modified", "hidden": true, "editable": false }, { "colIndex": 4, "sortable": true, "header": "Pays", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('countryHidden','Lino.countries.Countries.detail'), "editor": country3515, "dataIndex": "country" }, { "colIndex": 5, "sortable": true, "header": "Place", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('cityHidden','Lino.countries.Cities.detail'), "editor": city3516, "dataIndex": "city" }, { "colIndex": 6, "sortable": true, "header": "Region", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('regionHidden','Lino.countries.Cities.detail'), "editor": region3517, "dataIndex": "region" }, { "colIndex": 7, "sortable": true, "header": "Zip code", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(12), "dataIndex": "zip_code", "editor": zip_code3518 }, { "colIndex": 8, "sortable": true, "header": "Ligne avant le nom de rue", "editable": true, "tooltip": "Address line before street", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "addr1", "editor": addr13519 }, { "colIndex": 9, "sortable": true, "header": "Pr\u00e9fixe rue", "editable": true, "tooltip": "Text to print before name of street, but to ignore for sorting.", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "street_prefix", "editor": street_prefix3520 }, { "colIndex": 10, "sortable": true, "header": "Rue", "editable": true, "tooltip": "Name of street. Without house number.", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "street", "editor": street3521 }, { "colIndex": 11, "sortable": true, "header": "N\u00b0", "editable": true, "tooltip": "House number", "filter": { "type": "string" }, "width": Lino.chars2width(12), "dataIndex": "street_no", "editor": street_no3522 }, { "colIndex": 12, "sortable": true, "header": "bo\u00eete", "editable": true, "tooltip": "Text to print after :attr:`steet_no` on the same line", "filter": { "type": "string" }, "width": Lino.chars2width(12), "dataIndex": "street_box", "editor": street_box3523 }, { "colIndex": 13, "sortable": true, "header": "Ligne apr\u00e8s le nom de rue", "editable": true, "tooltip": "Address line to print below street line", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "addr2", "editor": addr23524 }, { "colIndex": 14, "sortable": true, "header": "Langue", "editable": true, "tooltip": "Die Sprache, in der Dokumente ausgestellt werden sollen.", "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "language", "editor": language3525 }, { "colIndex": 15, "sortable": true, "header": "URL", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "url", "editor": url3526 }, { "colIndex": 16, "sortable": true, "header": "T\u00e9l\u00e9phone", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "phone", "editor": phone3527 }, { "colIndex": 17, "sortable": true, "header": "GSM", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "gsm", "editor": gsm3528 }, { "colIndex": 18, "sortable": true, "header": "Fax", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "fax", "editor": fax3529 }, { "colIndex": 19, "sortable": false, "header": "Remarques", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(61), "renderer": Lino.text_renderer, "editor": remarks3530, "dataIndex": "remarks" }, { "colIndex": 20, "sortable": false, "xtype": "checkcolumn", "header": "obsolete", "editable": true, "tooltip": "Altf\u00e4lle sind Partner, deren Stammdaten nicht mehr gepflegt werden und \nf\u00fcr neue Operationen nicht benutzt werden k\u00f6nnen.", "filter": { "type": "boolean" }, "width": Lino.chars2width(11), "dataIndex": "is_obsolete" }, { "colIndex": 21, "sortable": true, "header": "Activit\u00e9", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "activity", "hidden": true, "editor": activity3532 }, { "colIndex": 22, "sortable": true, "header": "Compte en banque 1", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "bank_account1", "hidden": true, "editor": bank_account13533 }, { "colIndex": 23, "sortable": true, "header": "Compte en banque 2", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "bank_account2", "hidden": true, "editor": bank_account23534 }, { "colIndex": 24, "sortable": true, "header": "prefix", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "prefix", "editor": prefix3535 }, { "colIndex": 25, "sortable": true, "header": "N\u00b0 de TVA", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "vat_id", "editor": vat_id3536 }, { "colIndex": 26, "sortable": true, "header": "Type de soci\u00e9t\u00e9", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "type", "editor": type3537 }, { "colIndex": 27, "sortable": true, "header": "Type de contact client", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "client_contact_type", "editor": client_contact_type3538 }, new Lino.NullNumberColumn({ "colIndex": 28, "sortable": true, "format": "0", "editable": true, "filter": { "type": "numeric" }, "header": "ID", "renderer": Lino.id_renderer, "editor": id3539, "width": Lino.chars2width(6), "dataIndex": "id" }) ];
    Lino.contacts.Companies.GridPanel.superclass.initComponent.call(this);
  }
});


Lino.contacts.Companies.insertPanel = Ext.extend(Lino.contacts.Companies.InsertFormPanel,{
  empty_title: "Nouveau Organisations",
  hide_navigator: true,
  ls_bbar_actions: [ { "itemId": "post", "menu_item_text": "Cr\u00e9er", "tooltip": "Create the record and open a detail window on it", "panel_btn_handler": function(panel){panel.save(null,true,'post')}, "text": "Cr\u00e9er", "overflowText": "Cr\u00e9er", "auto_save": false }, { "itemId": "poststay", "menu_item_text": "Create without detail", "tooltip": "Don't open a detail window on the new record", "panel_btn_handler": function(panel){panel.save(null,false,'poststay')}, "text": "Create without detail", "overflowText": "Create without detail", "auto_save": false } ],
  ls_url: "/contacts/Companies",
  action_name: "insert",
  initComponent : function() {
    this.ls_detail_handler = Lino.contacts.Companies.detail;
    this.ls_insert_handler = Lino.contacts.Companies.insert;
    Lino.contacts.Companies.insertPanel.superclass.initComponent.call(this);
  }
});

Lino.contacts.Companies.insert = new Lino.WindowAction({ "draggable": true, "width": Lino.chars2width(60), "autoHeight": true, "maximizable": true, "modal": true, "maximized": false },function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.contacts.Companies.insertPanel(p);
});

Lino.contacts.Companies.detailPanel = Ext.extend(Lino.contacts.Companies.DetailFormPanel,{
  empty_title: "D\u00e9tail Organisations",
  ls_bbar_actions: [ { "itemId": "put", "menu_item_text": "Enregistrer", "tooltip": "Save changes in this form", "panel_btn_handler": function(panel){panel.save(null,false,'put')}, "iconCls": "x-tbar-save", "overflowText": "Enregistrer", "auto_save": false }, { "itemId": "insert", "menu_item_text": "Nouveau", "must_save": true, "tooltip": "Insert a new record", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-new", "overflowText": "Nouveau", "auto_save": true }, { "itemId": null, "menu_item_text": "Supprimer", "tooltip": "Delete this record", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "Supprimer", "auto_save": false }, { "itemId": "merge_row", "menu_item_text": "Merge", "tooltip": "Merge this object into another object of same class.", "panel_btn_handler": Lino.param_action_handler(Lino.contacts.Companies.merge_row), "text": "Merge", "overflowText": "Merge", "auto_save": true } ],
  ls_url: "/contacts/Companies",
  action_name: "detail",
  initComponent : function() {
    this.ls_detail_handler = Lino.contacts.Companies.detail;
    this.ls_insert_handler = Lino.contacts.Companies.insert;
    Lino.contacts.Companies.detailPanel.superclass.initComponent.call(this);
  }
});

Lino.contacts.Companies.detail = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.contacts.Companies.detailPanel(p);
});
Lino.contacts.Companies.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.contacts.Companies.GridPanel(p);
});

// js_render_GridPanel_class contacts.RoleTypes
Lino.contacts.RoleTypes.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "No data to display." },
  ls_url : "/contacts/RoleTypes",
  ls_bbar_actions : [ { "itemId": null, "menu_item_text": "Supprimer", "tooltip": "Delete this record", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "Supprimer", "auto_save": false } ],
  title : "Fonctions",
  page_length : 20,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "type": "int", "name": "id" }, { "name": "name" }, { "name": "name_fr" }, { "name": "name_nl" }, { "type": "boolean", "name": "use_in_contracts" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 0,
  ls_grid_configs : [  ],
  content_type : 19,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 6,
  initComponent : function() {
    var ww = this.containing_window;
    var id3541 = new Ext.form.NumberField({ "selectOnFocus": true });
    var name3542 = new Ext.form.TextField({ "selectOnFocus": true, "allowBlank": false, "maxLength": 200 });
    var name_fr3543 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var name_nl3544 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var use_in_contracts3545 = new Ext.form.Checkbox({ "selectOnFocus": true, "checked": true });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ new Lino.NullNumberColumn({ "colIndex": 0, "sortable": true, "format": "0", "editable": true, "filter": { "type": "numeric" }, "header": "ID", "renderer": Lino.id_renderer, "editor": id3541, "width": Lino.chars2width(6), "dataIndex": "id" }), { "colIndex": 1, "sortable": true, "header": "Description", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "name", "editor": name3542 }, { "colIndex": 2, "sortable": true, "header": "Description (fr)", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "name_fr", "editor": name_fr3543 }, { "colIndex": 3, "sortable": true, "header": "Description (nl)", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "name_nl", "editor": name_nl3544 }, { "colIndex": 4, "sortable": false, "xtype": "checkcolumn", "header": "utilisable dans contrats", "editable": true, "tooltip": "Whether Links of this type can be used as contact person of a job contract.", "filter": { "type": "boolean" }, "width": Lino.chars2width(11), "dataIndex": "use_in_contracts" } ];
    Lino.contacts.RoleTypes.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.contacts.RoleTypes.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.contacts.RoleTypes.GridPanel(p);
});

// js_render_GridPanel_class contacts.Roles
Lino.contacts.Roles.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "No data to display." },
  ls_url : "/contacts/Roles",
  ls_bbar_actions : [ { "itemId": null, "menu_item_text": "Supprimer", "tooltip": "Delete this record", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "Supprimer", "auto_save": false } ],
  title : "Personnes de contact",
  page_length : 20,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "type": "int", "name": "id" }, { "name": "type" }, 'typeHidden', { "name": "person" }, 'personHidden', { "name": "company" }, 'companyHidden', { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 0,
  ls_grid_configs : [  ],
  content_type : 22,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 8,
  initComponent : function() {
    var ww = this.containing_window;
    var id3547 = new Ext.form.NumberField({ "selectOnFocus": true });
    var type3548 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/contacts/Roles/type", "method": "GET" }) }), "pageSize": 20, "emptyText": "Choisir Fonction..." });
    var person3549 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/contacts/Roles/person", "method": "GET" }) }), "allowBlank": false, "pageSize": 20, "emptyText": "Choisir Personne..." });
    var company3550 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/contacts/Roles/company", "method": "GET" }) }), "allowBlank": false, "pageSize": 20, "emptyText": "Choisir Organisation..." });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ new Lino.NullNumberColumn({ "colIndex": 0, "sortable": true, "format": "0", "editable": true, "filter": { "type": "numeric" }, "header": "ID", "renderer": Lino.id_renderer, "editor": id3547, "width": Lino.chars2width(6), "dataIndex": "id" }), { "colIndex": 1, "sortable": true, "header": "R\u00f4le", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "type", "editor": type3548 }, { "colIndex": 2, "sortable": true, "header": "Personne", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('personHidden','Lino.contacts.Persons.detail'), "editor": person3549, "dataIndex": "person" }, { "colIndex": 3, "sortable": true, "header": "Organisation", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('companyHidden','Lino.contacts.Companies.detail'), "editor": company3550, "dataIndex": "company" } ];
    Lino.contacts.Roles.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.contacts.Roles.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.contacts.Roles.GridPanel(p);
});

// js_render_GridPanel_class postings.Postings
Lino.postings.Postings.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "No data to display." },
  ls_url : "/postings/Postings",
  ls_bbar_actions : [ { "itemId": null, "menu_item_text": "Supprimer", "tooltip": "Delete this record", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "Supprimer", "auto_save": false }, { "itemId": "print_action", "menu_item_text": "Imprimer", "must_save": true, "tooltip": "Imprimer", "panel_btn_handler": Lino.row_action_handler('print_action','GET'), "iconCls": "x-tbar-print", "overflowText": "Imprimer", "auto_save": true } ],
  title : "Envois postaux",
  page_length : 20,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "type": "date", "name": "date", "dateFormat": "d.m.Y" }, { "name": "user" }, 'userHidden', { "name": "owner" }, { "name": "partner" }, 'partnerHidden', { "type": "int", "name": "id" }, { "name": "owner_type" }, 'owner_typeHidden', { "name": "owner_id" }, 'owner_idHidden', { "name": "project" }, 'projectHidden', { "name": "state" }, 'stateHidden', { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 6,
  ls_grid_configs : [  ],
  content_type : 38,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 16,
  initComponent : function() {
    var ww = this.containing_window;
    var date3552 = new Lino.DateField({ "selectOnFocus": true, "allowBlank": false });
    var user3553 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/postings/Postings/user", "method": "GET" }) }), "pageSize": 20, "emptyText": "Choisir Utilisateur..." });
    var owner_disp3554 = new Ext.form.DisplayField({ "disabled": true });
    var partner3555 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/postings/Postings/partner", "method": "GET" }) }), "pageSize": 20, "emptyText": "Choisir Partenaire..." });
    var id3556 = new Ext.form.NumberField({ "selectOnFocus": true });
    var owner_type3557 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/postings/Postings/owner_type", "method": "GET" }) }), "pageSize": 20, "emptyText": "Choisir type de contenu..." });
    var owner_id3558 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/postings/Postings/owner_id", "method": "GET" }) }) });
    var project3559 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/postings/Postings/project", "method": "GET" }) }), "pageSize": 20, "emptyText": "Choisir Client..." });
    var state3560 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "forceSelection": true, "allowBlank": false, "store": Lino.postings.PostingStates });
    this.before_row_edit = function(record) {
      owner_id3558.setContextValue('owner_type',record ? record.data['owner_typeHidden'] : undefined);
    };
    this.onRender = function(ct, position) {
      owner_type3557.on('change',Lino.chooser_handler(owner_id3558,'owner_type'));
      Lino.postings.Postings.GridPanel.superclass.onRender.call(this, ct, position);
    }
    this.ls_columns = [ { "colIndex": 0, "sortable": true, "xtype": "datecolumn", "format": "d.m.Y", "editable": true, "filter": { "type": "date", "dateFormat": "d.m.Y" }, "header": "date", "editor": date3552, "width": Lino.chars2width(9), "dataIndex": "date" }, { "colIndex": 1, "sortable": true, "header": "Auteur", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(16), "renderer": Lino.fk_renderer('userHidden','Lino.users.Users.detail'), "editor": user3553, "dataIndex": "user" }, { "width": Lino.chars2width(11), "colIndex": 2, "sortable": false, "dataIndex": "owner", "header": "Contr\u00f4l\u00e9 par", "editable": false }, { "colIndex": 3, "sortable": true, "header": "Destinataire", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('partnerHidden','Lino.contacts.Partners.detail'), "editor": partner3555, "dataIndex": "partner" }, new Lino.NullNumberColumn({ "colIndex": 4, "sortable": true, "format": "0", "editable": true, "filter": { "type": "numeric" }, "header": "ID", "renderer": Lino.id_renderer, "editor": id3556, "width": Lino.chars2width(6), "dataIndex": "id" }), { "colIndex": 5, "sortable": true, "header": "Contr\u00f4l\u00e9 par (type)", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('owner_typeHidden','Lino.ui.ContentTypes.detail'), "editor": owner_type3557, "dataIndex": "owner_type" }, { "colIndex": 6, "sortable": true, "header": "Contr\u00f4l\u00e9 par (object)", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(11), "dataIndex": "owner_id", "editor": owner_id3558 }, { "colIndex": 7, "sortable": true, "header": "Client", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('projectHidden','Lino.pcsw.Clients.detail'), "editor": project3559, "dataIndex": "project" }, { "colIndex": 8, "sortable": true, "header": "State", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(18), "dataIndex": "state", "editor": state3560 } ];
    Lino.postings.Postings.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.postings.Postings.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.postings.Postings.GridPanel(p);
});
Lino.postings.Postings.print_action = function(rp,pk) { 
  Lino.run_row_action(rp,"/postings/Postings",pk,"print_action");
};

// js_render_GridPanel_class postings.PostingsByState
Lino.postings.PostingsByState.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "No data to display." },
  ls_url : "/postings/PostingsByState",
  ls_bbar_actions : [ { "itemId": null, "menu_item_text": "Supprimer", "tooltip": "Delete this record", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "Supprimer", "auto_save": false }, { "itemId": "print_action", "menu_item_text": "Imprimer", "must_save": true, "tooltip": "Imprimer", "panel_btn_handler": Lino.row_action_handler('print_action','GET'), "iconCls": "x-tbar-print", "overflowText": "Imprimer", "auto_save": true } ],
  title : "Envois postaux",
  page_length : 20,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "type": "date", "name": "date", "dateFormat": "d.m.Y" }, { "name": "user" }, 'userHidden', { "name": "partner" }, 'partnerHidden', { "name": "workflow_buttons" }, { "type": "int", "name": "id" }, { "name": "owner_type" }, 'owner_typeHidden', { "name": "owner_id" }, 'owner_idHidden', { "name": "project" }, 'projectHidden', { "name": "state" }, 'stateHidden', { "name": "owner" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 6,
  ls_grid_configs : [  ],
  content_type : 38,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 17,
  initComponent : function() {
    var ww = this.containing_window;
    var date3562 = new Lino.DateField({ "selectOnFocus": true, "allowBlank": false });
    var user3563 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/postings/PostingsByState/user", "method": "GET" }) }), "pageSize": 20, "emptyText": "Choisir Utilisateur..." });
    var partner3564 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/postings/PostingsByState/partner", "method": "GET" }) }), "pageSize": 20, "emptyText": "Choisir Partenaire..." });
    var workflow_buttons_disp3565 = new Ext.form.DisplayField({ "disabled": true, "value": "<br/>", "always_enabled": true });
    var id3566 = new Ext.form.NumberField({ "selectOnFocus": true });
    var owner_type3567 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/postings/PostingsByState/owner_type", "method": "GET" }) }), "pageSize": 20, "emptyText": "Choisir type de contenu..." });
    var owner_id3568 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/postings/PostingsByState/owner_id", "method": "GET" }) }) });
    var project3569 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/postings/PostingsByState/project", "method": "GET" }) }), "pageSize": 20, "emptyText": "Choisir Client..." });
    var state3570 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "forceSelection": true, "allowBlank": false, "store": Lino.postings.PostingStates });
    var owner_disp3571 = new Ext.form.DisplayField({ "disabled": true });
    this.before_row_edit = function(record) {
      owner_id3568.setContextValue('owner_type',record ? record.data['owner_typeHidden'] : undefined);
    };
    this.onRender = function(ct, position) {
      owner_type3567.on('change',Lino.chooser_handler(owner_id3568,'owner_type'));
      Lino.postings.PostingsByState.GridPanel.superclass.onRender.call(this, ct, position);
    }
    this.ls_columns = [ { "colIndex": 0, "sortable": true, "xtype": "datecolumn", "format": "d.m.Y", "editable": true, "filter": { "type": "date", "dateFormat": "d.m.Y" }, "header": "date", "editor": date3562, "width": Lino.chars2width(9), "dataIndex": "date" }, { "colIndex": 1, "sortable": true, "header": "Auteur", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(16), "renderer": Lino.fk_renderer('userHidden','Lino.users.Users.detail'), "editor": user3563, "dataIndex": "user" }, { "colIndex": 2, "sortable": true, "header": "Destinataire", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('partnerHidden','Lino.contacts.Partners.detail'), "editor": partner3564, "dataIndex": "partner" }, { "width": Lino.chars2width(31), "colIndex": 3, "sortable": false, "dataIndex": "workflow_buttons", "header": "Workflow", "editable": false }, new Lino.NullNumberColumn({ "colIndex": 4, "sortable": true, "format": "0", "editable": true, "filter": { "type": "numeric" }, "header": "ID", "renderer": Lino.id_renderer, "editor": id3566, "width": Lino.chars2width(6), "dataIndex": "id" }), { "colIndex": 5, "sortable": true, "header": "Contr\u00f4l\u00e9 par (type)", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('owner_typeHidden','Lino.ui.ContentTypes.detail'), "editor": owner_type3567, "dataIndex": "owner_type" }, { "colIndex": 6, "sortable": true, "header": "Contr\u00f4l\u00e9 par (object)", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(11), "dataIndex": "owner_id", "editor": owner_id3568 }, { "colIndex": 7, "sortable": true, "header": "Client", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('projectHidden','Lino.pcsw.Clients.detail'), "editor": project3569, "dataIndex": "project" }, { "colIndex": 8, "sortable": true, "header": "State", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(18), "dataIndex": "state", "editor": state3570 }, { "width": Lino.chars2width(11), "colIndex": 9, "sortable": false, "dataIndex": "owner", "header": "Contr\u00f4l\u00e9 par", "editable": false } ];
    Lino.postings.PostingsByState.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.postings.PostingsByState.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.postings.PostingsByState.GridPanel(p);
});
Lino.postings.PostingsByState.print_action = function(rp,pk) { 
  Lino.run_row_action(rp,"/postings/PostingsByState",pk,"print_action");
};

// js_render_GridPanel_class postings.PostingsReady
Lino.postings.PostingsReady.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "No data to display." },
  ls_url : "/postings/PostingsReady",
  ls_bbar_actions : [ { "itemId": null, "menu_item_text": "Supprimer", "tooltip": "Delete this record", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "Supprimer", "auto_save": false }, { "itemId": "print_action", "menu_item_text": "Imprimer", "must_save": true, "tooltip": "Imprimer", "panel_btn_handler": Lino.row_action_handler('print_action','GET'), "iconCls": "x-tbar-print", "overflowText": "Imprimer", "auto_save": true } ],
  title : "Envois postaux \u00e0 imprimer",
  page_length : 20,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "type": "date", "name": "date", "dateFormat": "d.m.Y" }, { "name": "user" }, 'userHidden', { "name": "partner" }, 'partnerHidden', { "name": "workflow_buttons" }, { "type": "int", "name": "id" }, { "name": "owner_type" }, 'owner_typeHidden', { "name": "owner_id" }, 'owner_idHidden', { "name": "project" }, 'projectHidden', { "name": "state" }, 'stateHidden', { "name": "owner" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 6,
  ls_grid_configs : [  ],
  content_type : 38,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 17,
  initComponent : function() {
    var ww = this.containing_window;
    var date3573 = new Lino.DateField({ "selectOnFocus": true, "allowBlank": false });
    var user3574 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/postings/PostingsReady/user", "method": "GET" }) }), "pageSize": 20, "emptyText": "Choisir Utilisateur..." });
    var partner3575 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/postings/PostingsReady/partner", "method": "GET" }) }), "pageSize": 20, "emptyText": "Choisir Partenaire..." });
    var workflow_buttons_disp3576 = new Ext.form.DisplayField({ "disabled": true, "value": "<br/>", "always_enabled": true });
    var id3577 = new Ext.form.NumberField({ "selectOnFocus": true });
    var owner_type3578 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/postings/PostingsReady/owner_type", "method": "GET" }) }), "pageSize": 20, "emptyText": "Choisir type de contenu..." });
    var owner_id3579 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/postings/PostingsReady/owner_id", "method": "GET" }) }) });
    var project3580 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/postings/PostingsReady/project", "method": "GET" }) }), "pageSize": 20, "emptyText": "Choisir Client..." });
    var state3581 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "forceSelection": true, "allowBlank": false, "store": Lino.postings.PostingStates });
    var owner_disp3582 = new Ext.form.DisplayField({ "disabled": true });
    this.before_row_edit = function(record) {
      owner_id3579.setContextValue('owner_type',record ? record.data['owner_typeHidden'] : undefined);
    };
    this.onRender = function(ct, position) {
      owner_type3578.on('change',Lino.chooser_handler(owner_id3579,'owner_type'));
      Lino.postings.PostingsReady.GridPanel.superclass.onRender.call(this, ct, position);
    }
    this.ls_columns = [ { "colIndex": 0, "sortable": true, "xtype": "datecolumn", "format": "d.m.Y", "editable": true, "filter": { "type": "date", "dateFormat": "d.m.Y" }, "header": "date", "editor": date3573, "width": Lino.chars2width(9), "dataIndex": "date" }, { "colIndex": 1, "sortable": true, "header": "Auteur", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(16), "renderer": Lino.fk_renderer('userHidden','Lino.users.Users.detail'), "editor": user3574, "dataIndex": "user" }, { "colIndex": 2, "sortable": true, "header": "Destinataire", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('partnerHidden','Lino.contacts.Partners.detail'), "editor": partner3575, "dataIndex": "partner" }, { "width": Lino.chars2width(31), "colIndex": 3, "sortable": false, "dataIndex": "workflow_buttons", "header": "Workflow", "editable": false }, new Lino.NullNumberColumn({ "colIndex": 4, "sortable": true, "format": "0", "editable": true, "filter": { "type": "numeric" }, "header": "ID", "renderer": Lino.id_renderer, "editor": id3577, "width": Lino.chars2width(6), "dataIndex": "id" }), { "colIndex": 5, "sortable": true, "header": "Contr\u00f4l\u00e9 par (type)", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('owner_typeHidden','Lino.ui.ContentTypes.detail'), "editor": owner_type3578, "dataIndex": "owner_type" }, { "colIndex": 6, "sortable": true, "header": "Contr\u00f4l\u00e9 par (object)", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(11), "dataIndex": "owner_id", "editor": owner_id3579 }, { "colIndex": 7, "sortable": true, "header": "Client", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('projectHidden','Lino.pcsw.Clients.detail'), "editor": project3580, "dataIndex": "project" }, { "colIndex": 8, "sortable": true, "header": "State", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(18), "dataIndex": "state", "editor": state3581 }, { "width": Lino.chars2width(11), "colIndex": 9, "sortable": false, "dataIndex": "owner", "header": "Contr\u00f4l\u00e9 par", "editable": false } ];
    Lino.postings.PostingsReady.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.postings.PostingsReady.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.postings.PostingsReady.GridPanel(p);
});
Lino.postings.PostingsReady.print_action = function(rp,pk) { 
  Lino.run_row_action(rp,"/postings/PostingsReady",pk,"print_action");
};

// js_render_GridPanel_class postings.PostingsPrinted
Lino.postings.PostingsPrinted.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "No data to display." },
  ls_url : "/postings/PostingsPrinted",
  ls_bbar_actions : [ { "itemId": null, "menu_item_text": "Supprimer", "tooltip": "Delete this record", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "Supprimer", "auto_save": false }, { "itemId": "print_action", "menu_item_text": "Imprimer", "must_save": true, "tooltip": "Imprimer", "panel_btn_handler": Lino.row_action_handler('print_action','GET'), "iconCls": "x-tbar-print", "overflowText": "Imprimer", "auto_save": true } ],
  title : "Envois postaux imprim\u00e9s",
  page_length : 20,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "type": "date", "name": "date", "dateFormat": "d.m.Y" }, { "name": "user" }, 'userHidden', { "name": "partner" }, 'partnerHidden', { "name": "workflow_buttons" }, { "type": "int", "name": "id" }, { "name": "owner_type" }, 'owner_typeHidden', { "name": "owner_id" }, 'owner_idHidden', { "name": "project" }, 'projectHidden', { "name": "state" }, 'stateHidden', { "name": "owner" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 6,
  ls_grid_configs : [  ],
  content_type : 38,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 17,
  initComponent : function() {
    var ww = this.containing_window;
    var date3584 = new Lino.DateField({ "selectOnFocus": true, "allowBlank": false });
    var user3585 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/postings/PostingsPrinted/user", "method": "GET" }) }), "pageSize": 20, "emptyText": "Choisir Utilisateur..." });
    var partner3586 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/postings/PostingsPrinted/partner", "method": "GET" }) }), "pageSize": 20, "emptyText": "Choisir Partenaire..." });
    var workflow_buttons_disp3587 = new Ext.form.DisplayField({ "disabled": true, "value": "<br/>", "always_enabled": true });
    var id3588 = new Ext.form.NumberField({ "selectOnFocus": true });
    var owner_type3589 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/postings/PostingsPrinted/owner_type", "method": "GET" }) }), "pageSize": 20, "emptyText": "Choisir type de contenu..." });
    var owner_id3590 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/postings/PostingsPrinted/owner_id", "method": "GET" }) }) });
    var project3591 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/postings/PostingsPrinted/project", "method": "GET" }) }), "pageSize": 20, "emptyText": "Choisir Client..." });
    var state3592 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "forceSelection": true, "allowBlank": false, "store": Lino.postings.PostingStates });
    var owner_disp3593 = new Ext.form.DisplayField({ "disabled": true });
    this.before_row_edit = function(record) {
      owner_id3590.setContextValue('owner_type',record ? record.data['owner_typeHidden'] : undefined);
    };
    this.onRender = function(ct, position) {
      owner_type3589.on('change',Lino.chooser_handler(owner_id3590,'owner_type'));
      Lino.postings.PostingsPrinted.GridPanel.superclass.onRender.call(this, ct, position);
    }
    this.ls_columns = [ { "colIndex": 0, "sortable": true, "xtype": "datecolumn", "format": "d.m.Y", "editable": true, "filter": { "type": "date", "dateFormat": "d.m.Y" }, "header": "date", "editor": date3584, "width": Lino.chars2width(9), "dataIndex": "date" }, { "colIndex": 1, "sortable": true, "header": "Auteur", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(16), "renderer": Lino.fk_renderer('userHidden','Lino.users.Users.detail'), "editor": user3585, "dataIndex": "user" }, { "colIndex": 2, "sortable": true, "header": "Destinataire", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('partnerHidden','Lino.contacts.Partners.detail'), "editor": partner3586, "dataIndex": "partner" }, { "width": Lino.chars2width(31), "colIndex": 3, "sortable": false, "dataIndex": "workflow_buttons", "header": "Workflow", "editable": false }, new Lino.NullNumberColumn({ "colIndex": 4, "sortable": true, "format": "0", "editable": true, "filter": { "type": "numeric" }, "header": "ID", "renderer": Lino.id_renderer, "editor": id3588, "width": Lino.chars2width(6), "dataIndex": "id" }), { "colIndex": 5, "sortable": true, "header": "Contr\u00f4l\u00e9 par (type)", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('owner_typeHidden','Lino.ui.ContentTypes.detail'), "editor": owner_type3589, "dataIndex": "owner_type" }, { "colIndex": 6, "sortable": true, "header": "Contr\u00f4l\u00e9 par (object)", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(11), "dataIndex": "owner_id", "editor": owner_id3590 }, { "colIndex": 7, "sortable": true, "header": "Client", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('projectHidden','Lino.pcsw.Clients.detail'), "editor": project3591, "dataIndex": "project" }, { "colIndex": 8, "sortable": true, "header": "State", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(18), "dataIndex": "state", "editor": state3592 }, { "width": Lino.chars2width(11), "colIndex": 9, "sortable": false, "dataIndex": "owner", "header": "Contr\u00f4l\u00e9 par", "editable": false } ];
    Lino.postings.PostingsPrinted.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.postings.PostingsPrinted.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.postings.PostingsPrinted.GridPanel(p);
});
Lino.postings.PostingsPrinted.print_action = function(rp,pk) { 
  Lino.run_row_action(rp,"/postings/PostingsPrinted",pk,"print_action");
};

// js_render_GridPanel_class postings.PostingsSent
Lino.postings.PostingsSent.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "No data to display." },
  ls_url : "/postings/PostingsSent",
  ls_bbar_actions : [ { "itemId": null, "menu_item_text": "Supprimer", "tooltip": "Delete this record", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "Supprimer", "auto_save": false }, { "itemId": "print_action", "menu_item_text": "Imprimer", "must_save": true, "tooltip": "Imprimer", "panel_btn_handler": Lino.row_action_handler('print_action','GET'), "iconCls": "x-tbar-print", "overflowText": "Imprimer", "auto_save": true } ],
  title : "Envois postaux envoy\u00e9s",
  page_length : 20,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "type": "date", "name": "date", "dateFormat": "d.m.Y" }, { "name": "user" }, 'userHidden', { "name": "partner" }, 'partnerHidden', { "name": "workflow_buttons" }, { "type": "int", "name": "id" }, { "name": "owner_type" }, 'owner_typeHidden', { "name": "owner_id" }, 'owner_idHidden', { "name": "project" }, 'projectHidden', { "name": "state" }, 'stateHidden', { "name": "owner" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 6,
  ls_grid_configs : [  ],
  content_type : 38,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 17,
  initComponent : function() {
    var ww = this.containing_window;
    var date3595 = new Lino.DateField({ "selectOnFocus": true, "allowBlank": false });
    var user3596 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/postings/PostingsSent/user", "method": "GET" }) }), "pageSize": 20, "emptyText": "Choisir Utilisateur..." });
    var partner3597 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/postings/PostingsSent/partner", "method": "GET" }) }), "pageSize": 20, "emptyText": "Choisir Partenaire..." });
    var workflow_buttons_disp3598 = new Ext.form.DisplayField({ "disabled": true, "value": "<br/>", "always_enabled": true });
    var id3599 = new Ext.form.NumberField({ "selectOnFocus": true });
    var owner_type3600 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/postings/PostingsSent/owner_type", "method": "GET" }) }), "pageSize": 20, "emptyText": "Choisir type de contenu..." });
    var owner_id3601 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/postings/PostingsSent/owner_id", "method": "GET" }) }) });
    var project3602 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/postings/PostingsSent/project", "method": "GET" }) }), "pageSize": 20, "emptyText": "Choisir Client..." });
    var state3603 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "forceSelection": true, "allowBlank": false, "store": Lino.postings.PostingStates });
    var owner_disp3604 = new Ext.form.DisplayField({ "disabled": true });
    this.before_row_edit = function(record) {
      owner_id3601.setContextValue('owner_type',record ? record.data['owner_typeHidden'] : undefined);
    };
    this.onRender = function(ct, position) {
      owner_type3600.on('change',Lino.chooser_handler(owner_id3601,'owner_type'));
      Lino.postings.PostingsSent.GridPanel.superclass.onRender.call(this, ct, position);
    }
    this.ls_columns = [ { "colIndex": 0, "sortable": true, "xtype": "datecolumn", "format": "d.m.Y", "editable": true, "filter": { "type": "date", "dateFormat": "d.m.Y" }, "header": "date", "editor": date3595, "width": Lino.chars2width(9), "dataIndex": "date" }, { "colIndex": 1, "sortable": true, "header": "Auteur", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(16), "renderer": Lino.fk_renderer('userHidden','Lino.users.Users.detail'), "editor": user3596, "dataIndex": "user" }, { "colIndex": 2, "sortable": true, "header": "Destinataire", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('partnerHidden','Lino.contacts.Partners.detail'), "editor": partner3597, "dataIndex": "partner" }, { "width": Lino.chars2width(31), "colIndex": 3, "sortable": false, "dataIndex": "workflow_buttons", "header": "Workflow", "editable": false }, new Lino.NullNumberColumn({ "colIndex": 4, "sortable": true, "format": "0", "editable": true, "filter": { "type": "numeric" }, "header": "ID", "renderer": Lino.id_renderer, "editor": id3599, "width": Lino.chars2width(6), "dataIndex": "id" }), { "colIndex": 5, "sortable": true, "header": "Contr\u00f4l\u00e9 par (type)", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('owner_typeHidden','Lino.ui.ContentTypes.detail'), "editor": owner_type3600, "dataIndex": "owner_type" }, { "colIndex": 6, "sortable": true, "header": "Contr\u00f4l\u00e9 par (object)", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(11), "dataIndex": "owner_id", "editor": owner_id3601 }, { "colIndex": 7, "sortable": true, "header": "Client", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('projectHidden','Lino.pcsw.Clients.detail'), "editor": project3602, "dataIndex": "project" }, { "colIndex": 8, "sortable": true, "header": "State", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(18), "dataIndex": "state", "editor": state3603 }, { "width": Lino.chars2width(11), "colIndex": 9, "sortable": false, "dataIndex": "owner", "header": "Contr\u00f4l\u00e9 par", "editable": false } ];
    Lino.postings.PostingsSent.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.postings.PostingsSent.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.postings.PostingsSent.GridPanel(p);
});
Lino.postings.PostingsSent.print_action = function(rp,pk) { 
  Lino.run_row_action(rp,"/postings/PostingsSent",pk,"print_action");
};

// js_render_GridPanel_class outbox.Recipients
Lino.outbox.Recipients.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "No data to display." },
  ls_url : "/outbox/Recipients",
  ls_bbar_actions : [ { "itemId": null, "menu_item_text": "Supprimer", "tooltip": "Delete this record", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "Supprimer", "auto_save": false } ],
  title : "Recipients",
  page_length : 20,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "type": "int", "name": "id" }, { "name": "mail" }, 'mailHidden', { "name": "partner" }, 'partnerHidden', { "name": "type" }, 'typeHidden', { "name": "address" }, { "name": "name" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 0,
  ls_grid_configs : [  ],
  content_type : 28,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 10,
  initComponent : function() {
    var ww = this.containing_window;
    var id3606 = new Ext.form.NumberField({ "selectOnFocus": true });
    var mail3607 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/outbox/Recipients/mail", "method": "GET" }) }), "allowBlank": false, "pageSize": 20, "emptyText": "Choisir Outgoing Mail..." });
    var partner3608 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/outbox/Recipients/partner", "method": "GET" }) }), "pageSize": 20, "emptyText": "Choisir Partenaire..." });
    var type3609 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "forceSelection": true, "allowBlank": false, "store": Lino.outbox.RecipientType });
    var address3610 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 75 });
    var name3611 = new Ext.form.TextField({ "selectOnFocus": true, "allowBlank": false, "maxLength": 200 });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ new Lino.NullNumberColumn({ "colIndex": 0, "sortable": true, "format": "0", "editable": true, "filter": { "type": "numeric" }, "header": "ID", "renderer": Lino.id_renderer, "editor": id3606, "width": Lino.chars2width(6), "dataIndex": "id" }), { "colIndex": 1, "sortable": true, "header": "Outgoing Mail", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('mailHidden','Lino.outbox.Mails.detail'), "editor": mail3607, "dataIndex": "mail" }, { "colIndex": 2, "sortable": true, "header": "Partenaire", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('partnerHidden','Lino.contacts.Partners.detail'), "editor": partner3608, "dataIndex": "partner" }, { "colIndex": 3, "sortable": true, "header": "Recipient Type", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(8), "dataIndex": "type", "editor": type3609 }, { "colIndex": 4, "sortable": true, "header": "Addresse", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "address", "editor": address3610 }, { "colIndex": 5, "sortable": true, "header": "Name", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "name", "editor": name3611 } ];
    Lino.outbox.Recipients.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.outbox.Recipients.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.outbox.Recipients.GridPanel(p);
});

// js_render_GridPanel_class outbox.Mails
Lino.outbox.Mails.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "No data to display." },
  ls_url : "/outbox/Mails",
  ls_bbar_actions : [ { "itemId": "insert", "menu_item_text": "Nouveau", "must_save": true, "tooltip": "Insert a new record", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-new", "overflowText": "Nouveau", "auto_save": true }, { "itemId": "detail", "menu_item_text": "D\u00e9tail", "tooltip": "Open a detail window on this record", "panel_btn_handler": Lino.show_detail, "iconCls": "x-tbar-detail", "overflowText": "D\u00e9tail", "auto_save": true }, { "itemId": null, "menu_item_text": "Supprimer", "tooltip": "Delete this record", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "Supprimer", "auto_save": false }, { "itemId": "send_mail", "menu_item_text": "Envoyer", "must_save": true, "tooltip": "Envoyer", "panel_btn_handler": Lino.row_action_handler('send_mail','GET'), "iconCls": "x-tbar-email_send", "overflowText": "Envoyer", "auto_save": true } ],
  title : "Outgoing Mails",
  page_length : 20,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "name": "sent" }, { "name": "recipients" }, { "name": "subject" }, { "type": "int", "name": "id" }, { "name": "owner_type" }, 'owner_typeHidden', { "name": "owner_id" }, 'owner_idHidden', { "name": "user" }, 'userHidden', { "name": "project" }, 'projectHidden', { "type": "date", "name": "date", "dateFormat": "d.m.Y" }, { "name": "owner" }, { "name": "body" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 3,
  ls_grid_configs : [  ],
  content_type : 27,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 16,
  initComponent : function() {
    this.ls_detail_handler = Lino.outbox.Mails.detail;
    this.ls_insert_handler = Lino.outbox.Mails.insert;
    var ww = this.containing_window;
    var sent3613 = new Ext.form.DisplayField({ "disabled": true, "value": "<br>" });
    var recipients_htmlbox3614 = new Lino.HtmlBoxPanel({ "layout": "fit", "name": "recipients", "containing_panel": this, "items": new Ext.BoxComponent({autoScroll:true}), "title": "Recipients", "master_panel": this, "value": "<br/>", "always_enabled": true, "bodyStyle": "overflow-x:hidden" });
    var subject3615 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var id3616 = new Ext.form.NumberField({ "selectOnFocus": true });
    var owner_type3617 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/outbox/Mails/owner_type", "method": "GET" }) }), "pageSize": 20, "emptyText": "Choisir type de contenu..." });
    var owner_id3618 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/outbox/Mails/owner_id", "method": "GET" }) }) });
    var user3619 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/outbox/Mails/user", "method": "GET" }) }), "pageSize": 20, "emptyText": "Choisir Utilisateur..." });
    var project3620 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/outbox/Mails/project", "method": "GET" }) }), "pageSize": 20, "emptyText": "Choisir Client..." });
    var date3621 = new Lino.DateField({ "selectOnFocus": true, "allowBlank": false });
    var owner_disp3622 = new Ext.form.DisplayField({ "disabled": true });
    var body3623 = new Lino.RichTextPanel({ "selectOnFocus": true, "containing_panel": this, "title": "Body" });
    this.before_row_edit = function(record) {
      recipients_htmlbox3614.refresh();
      owner_id3618.setContextValue('owner_type',record ? record.data['owner_typeHidden'] : undefined);
      body3623.refresh();
    };
    this.onRender = function(ct, position) {
      owner_type3617.on('change',Lino.chooser_handler(owner_id3618,'owner_type'));
      Lino.outbox.Mails.GridPanel.superclass.onRender.call(this, ct, position);
    }
    this.ls_columns = [ { "width": Lino.chars2width(17), "colIndex": 0, "sortable": true, "dataIndex": "sent", "header": "sent", "editable": false }, { "width": Lino.chars2width(31), "colIndex": 1, "sortable": false, "dataIndex": "recipients", "header": "Recipients", "editable": false }, { "colIndex": 2, "sortable": true, "header": "Subject", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "subject", "editor": subject3615 }, new Lino.NullNumberColumn({ "colIndex": 3, "sortable": true, "format": "0", "editable": true, "filter": { "type": "numeric" }, "header": "ID", "renderer": Lino.id_renderer, "editor": id3616, "width": Lino.chars2width(6), "dataIndex": "id" }), { "colIndex": 4, "sortable": true, "header": "Contr\u00f4l\u00e9 par (type)", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('owner_typeHidden','Lino.ui.ContentTypes.detail'), "editor": owner_type3617, "dataIndex": "owner_type" }, { "colIndex": 5, "sortable": true, "header": "Contr\u00f4l\u00e9 par (object)", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(11), "dataIndex": "owner_id", "editor": owner_id3618 }, { "colIndex": 6, "sortable": true, "header": "exp\u00e9diteur", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(16), "renderer": Lino.fk_renderer('userHidden','Lino.users.Users.detail'), "editor": user3619, "dataIndex": "user" }, { "colIndex": 7, "sortable": true, "header": "Client", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('projectHidden','Lino.pcsw.Clients.detail'), "editor": project3620, "dataIndex": "project" }, { "colIndex": 8, "sortable": true, "xtype": "datecolumn", "format": "d.m.Y", "editable": true, "tooltip": "\n        The official date to be printed on the document.\n        ", "filter": { "type": "date", "dateFormat": "d.m.Y" }, "header": "Date", "dataIndex": "date", "width": Lino.chars2width(9), "editor": date3621 }, { "width": Lino.chars2width(11), "colIndex": 9, "sortable": false, "dataIndex": "owner", "header": "Contr\u00f4l\u00e9 par", "editable": false }, { "colIndex": 10, "sortable": false, "header": "body", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(61), "renderer": Lino.text_renderer, "editor": body3623, "dataIndex": "body" } ];
    Lino.outbox.Mails.GridPanel.superclass.initComponent.call(this);
  }
});


Lino.outbox.Mails.insertPanel = Ext.extend(Lino.outbox.Mails.InsertFormPanel,{
  empty_title: "Nouveau Outgoing Mails",
  hide_navigator: true,
  ls_bbar_actions: [ { "itemId": "post", "menu_item_text": "Cr\u00e9er", "tooltip": "Create the record and open a detail window on it", "panel_btn_handler": function(panel){panel.save(null,true,'post')}, "text": "Cr\u00e9er", "overflowText": "Cr\u00e9er", "auto_save": false }, { "itemId": "poststay", "menu_item_text": "Create without detail", "tooltip": "Don't open a detail window on the new record", "panel_btn_handler": function(panel){panel.save(null,false,'poststay')}, "text": "Create without detail", "overflowText": "Create without detail", "auto_save": false } ],
  ls_url: "/outbox/Mails",
  action_name: "insert",
  initComponent : function() {
    this.ls_detail_handler = Lino.outbox.Mails.detail;
    this.ls_insert_handler = Lino.outbox.Mails.insert;
    Lino.outbox.Mails.insertPanel.superclass.initComponent.call(this);
  }
});

Lino.outbox.Mails.insert = new Lino.WindowAction({ "draggable": true, "width": Lino.chars2width(60), "maximizable": true, "modal": true, "maximized": false, "height": Lino.rows2height(20) },function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.outbox.Mails.insertPanel(p);
});

Lino.outbox.Mails.detailPanel = Ext.extend(Lino.outbox.Mails.DetailFormPanel,{
  empty_title: "D\u00e9tail Outgoing Mails",
  ls_bbar_actions: [ { "itemId": "put", "menu_item_text": "Enregistrer", "tooltip": "Save changes in this form", "panel_btn_handler": function(panel){panel.save(null,false,'put')}, "iconCls": "x-tbar-save", "overflowText": "Enregistrer", "auto_save": false }, { "itemId": "insert", "menu_item_text": "Nouveau", "must_save": true, "tooltip": "Insert a new record", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-new", "overflowText": "Nouveau", "auto_save": true }, { "itemId": null, "menu_item_text": "Supprimer", "tooltip": "Delete this record", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "Supprimer", "auto_save": false }, { "itemId": "send_mail", "menu_item_text": "Envoyer", "must_save": true, "tooltip": "Envoyer", "panel_btn_handler": Lino.row_action_handler('send_mail','GET'), "iconCls": "x-tbar-email_send", "overflowText": "Envoyer", "auto_save": true } ],
  ls_url: "/outbox/Mails",
  action_name: "detail",
  initComponent : function() {
    this.ls_detail_handler = Lino.outbox.Mails.detail;
    this.ls_insert_handler = Lino.outbox.Mails.insert;
    Lino.outbox.Mails.detailPanel.superclass.initComponent.call(this);
  }
});

Lino.outbox.Mails.detail = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.outbox.Mails.detailPanel(p);
});
Lino.outbox.Mails.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.outbox.Mails.GridPanel(p);
});

// js_render_GridPanel_class outbox.Attachments
Lino.outbox.Attachments.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "No data to display." },
  ls_url : "/outbox/Attachments",
  ls_bbar_actions : [ { "itemId": null, "menu_item_text": "Supprimer", "tooltip": "Delete this record", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "Supprimer", "auto_save": false } ],
  title : "Pi\u00e8ces jointes",
  page_length : 20,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "type": "int", "name": "id" }, { "name": "owner_type" }, 'owner_typeHidden', { "name": "owner_id" }, 'owner_idHidden', { "name": "mail" }, 'mailHidden', { "name": "owner" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 0,
  ls_grid_configs : [  ],
  content_type : 29,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 9,
  initComponent : function() {
    var ww = this.containing_window;
    var id3625 = new Ext.form.NumberField({ "selectOnFocus": true });
    var owner_type3626 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/outbox/Attachments/owner_type", "method": "GET" }) }), "pageSize": 20, "emptyText": "Choisir type de contenu..." });
    var owner_id3627 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/outbox/Attachments/owner_id", "method": "GET" }) }) });
    var mail3628 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/outbox/Attachments/mail", "method": "GET" }) }), "allowBlank": false, "pageSize": 20, "emptyText": "Choisir Outgoing Mail..." });
    var owner_disp3629 = new Ext.form.DisplayField({ "disabled": true });
    this.before_row_edit = function(record) {
      owner_id3627.setContextValue('owner_type',record ? record.data['owner_typeHidden'] : undefined);
    };
    this.onRender = function(ct, position) {
      owner_type3626.on('change',Lino.chooser_handler(owner_id3627,'owner_type'));
      Lino.outbox.Attachments.GridPanel.superclass.onRender.call(this, ct, position);
    }
    this.ls_columns = [ new Lino.NullNumberColumn({ "colIndex": 0, "sortable": true, "format": "0", "editable": true, "filter": { "type": "numeric" }, "header": "ID", "renderer": Lino.id_renderer, "editor": id3625, "width": Lino.chars2width(6), "dataIndex": "id" }), { "colIndex": 1, "sortable": true, "header": "Contr\u00f4l\u00e9 par (type)", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('owner_typeHidden','Lino.ui.ContentTypes.detail'), "editor": owner_type3626, "dataIndex": "owner_type" }, { "colIndex": 2, "sortable": true, "header": "Contr\u00f4l\u00e9 par (object)", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(11), "dataIndex": "owner_id", "editor": owner_id3627 }, { "colIndex": 3, "sortable": true, "header": "Outgoing Mail", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('mailHidden','Lino.outbox.Mails.detail'), "editor": mail3628, "dataIndex": "mail" }, { "width": Lino.chars2width(11), "colIndex": 4, "sortable": false, "dataIndex": "owner", "header": "Contr\u00f4l\u00e9 par", "editable": false } ];
    Lino.outbox.Attachments.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.outbox.Attachments.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.outbox.Attachments.GridPanel(p);
});

// js_render_GridPanel_class cal.Calendars
Lino.cal.Calendars.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "No data to display." },
  ls_url : "/cal/Calendars",
  ls_bbar_actions : [ { "itemId": "insert", "menu_item_text": "Nouveau", "must_save": true, "tooltip": "Insert a new record", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-new", "overflowText": "Nouveau", "auto_save": true }, { "itemId": "detail", "menu_item_text": "D\u00e9tail", "tooltip": "Open a detail window on this record", "panel_btn_handler": Lino.show_detail, "iconCls": "x-tbar-detail", "overflowText": "D\u00e9tail", "auto_save": true }, { "itemId": null, "menu_item_text": "Supprimer", "tooltip": "Delete this record", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "Supprimer", "auto_save": false } ],
  title : "Calendriers",
  page_length : 20,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "name": "name" }, { "name": "name_fr" }, { "name": "name_nl" }, { "name": "type" }, 'typeHidden', { "type": "int", "name": "color" }, { "type": "boolean", "name": "readonly" }, { "name": "build_method" }, 'build_methodHidden', { "name": "template" }, { "type": "int", "name": "id" }, { "type": "boolean", "name": "attach_to_email" }, { "name": "email_template" }, { "name": "description" }, { "name": "url_template" }, { "name": "username" }, { "name": "password" }, { "name": "invite_team_members" }, 'invite_team_membersHidden', { "type": "date", "name": "start_date", "dateFormat": "d.m.Y" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 10,
  ls_grid_configs : [  ],
  content_type : 35,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 21,
  initComponent : function() {
    this.ls_detail_handler = Lino.cal.Calendars.detail;
    this.ls_insert_handler = Lino.cal.Calendars.insert;
    var ww = this.containing_window;
    var name3631 = new Ext.form.TextField({ "selectOnFocus": true, "allowBlank": false, "maxLength": 200 });
    var name_fr3632 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var name_nl3633 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var type3634 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "store": [ [ "local", "Local Calendar" ], [ "google", "Google Calendar" ] ], "allowBlank": false, "value": "local" });
    var color3635 = new Ext.form.NumberField({ "selectOnFocus": true, "allowBlank": false, "value": 1 });
    var readonly3636 = new Ext.form.Checkbox({ "selectOnFocus": true, "checked": false });
    var build_method3637 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "store": [ [ "appyodt", "AppyOdtBuildMethod" ], [ "appypdf", "AppyPdfBuildMethod" ], [ "appyrtf", "AppyRtfBuildMethod" ], [ "latex", "LatexBuildMethod" ], [ "pisa", "PisaBuildMethod" ], [ "rtf", "RtfBuildMethod" ] ] });
    var template3638 = new Lino.SimpleRemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/Calendars/template", "method": "GET" }) }) });
    var id3639 = new Ext.form.NumberField({ "selectOnFocus": true });
    var attach_to_email3640 = new Ext.form.Checkbox({ "selectOnFocus": true, "checked": false });
    var email_template3641 = new Lino.SimpleRemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/Calendars/email_template", "method": "GET" }) }) });
    var description3642 = new Lino.RichTextPanel({ "selectOnFocus": true, "containing_panel": this, "title": "Description" });
    var url_template3643 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var username3644 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var password3645 = new Ext.form.TextField({ "selectOnFocus": true, "inputType": "password", "maxLength": 200 });
    var invite_team_members3646 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/Calendars/invite_team_members", "method": "GET" }) }), "pageSize": 20, "emptyText": "Choisir Team..." });
    var start_date3647 = new Lino.DateField({ "selectOnFocus": true });
    this.before_row_edit = function(record) {
      template3638.setContextValue('build_method',record ? record.data['build_methodHidden'] : undefined);
      description3642.refresh();
    };
    this.onRender = function(ct, position) {
      build_method3637.on('change',Lino.chooser_handler(template3638,'build_method'));
      Lino.cal.Calendars.GridPanel.superclass.onRender.call(this, ct, position);
    }
    this.ls_columns = [ { "colIndex": 0, "sortable": true, "header": "Description", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "name", "editor": name3631 }, { "colIndex": 1, "sortable": true, "header": "Description (fr)", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "name_fr", "editor": name_fr3632 }, { "colIndex": 2, "sortable": true, "header": "Description (nl)", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "name_nl", "editor": name_nl3633 }, { "colIndex": 3, "sortable": true, "header": "Type", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "type", "editor": type3634 }, new Lino.NullNumberColumn({ "colIndex": 4, "sortable": true, "format": "0", "editable": true, "filter": { "type": "numeric" }, "header": "Couleur", "dataIndex": "color", "width": Lino.chars2width(6), "editor": color3635 }), { "colIndex": 5, "sortable": false, "xtype": "checkcolumn", "header": "read-only", "editable": true, "filter": { "type": "boolean" }, "width": Lino.chars2width(11), "dataIndex": "readonly" }, { "colIndex": 6, "sortable": true, "header": "M\u00e9thode de construction", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "build_method", "editor": build_method3637 }, { "colIndex": 7, "sortable": true, "header": "Mod\u00e8le", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(11), "dataIndex": "template", "editor": template3638 }, new Lino.NullNumberColumn({ "colIndex": 8, "sortable": true, "format": "0", "editable": true, "filter": { "type": "numeric" }, "header": "ID", "renderer": Lino.id_renderer, "editor": id3639, "width": Lino.chars2width(6), "dataIndex": "id" }), { "colIndex": 9, "sortable": false, "xtype": "checkcolumn", "header": "Attach to email", "editable": true, "tooltip": "Whether the printable file should be attached to the email\nwhen creating an email from a mailable of this type.\n", "filter": { "type": "boolean" }, "width": Lino.chars2width(11), "dataIndex": "attach_to_email" }, { "colIndex": 10, "sortable": true, "header": "Email template", "editable": true, "tooltip": "The name of the file to be used as template \nwhen creating an email from a mailable of this type.\n", "filter": { "type": "string" }, "width": Lino.chars2width(11), "dataIndex": "email_template", "editor": email_template3641 }, { "colIndex": 11, "sortable": false, "header": "description", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(61), "renderer": Lino.text_renderer, "editor": description3642, "dataIndex": "description" }, { "colIndex": 12, "sortable": true, "header": "URL template", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "url_template", "editor": url_template3643 }, { "colIndex": 13, "sortable": true, "header": "Username", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "username", "editor": username3644 }, { "colIndex": 14, "sortable": true, "header": "Password", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "password", "editor": password3645 }, { "colIndex": 15, "sortable": true, "header": "Team", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "invite_team_members", "editor": invite_team_members3646 }, { "colIndex": 16, "sortable": true, "xtype": "datecolumn", "format": "d.m.Y", "editable": true, "filter": { "type": "date", "dateFormat": "d.m.Y" }, "header": "Date d\u00e9but", "editor": start_date3647, "width": Lino.chars2width(9), "dataIndex": "start_date" } ];
    Lino.cal.Calendars.GridPanel.superclass.initComponent.call(this);
  }
});


Lino.cal.Calendars.insertPanel = Ext.extend(Lino.cal.Calendars.InsertFormPanel,{
  empty_title: "Nouveau Calendriers",
  hide_navigator: true,
  ls_bbar_actions: [ { "itemId": "post", "menu_item_text": "Cr\u00e9er", "tooltip": "Create the record and open a detail window on it", "panel_btn_handler": function(panel){panel.save(null,true,'post')}, "text": "Cr\u00e9er", "overflowText": "Cr\u00e9er", "auto_save": false }, { "itemId": "poststay", "menu_item_text": "Create without detail", "tooltip": "Don't open a detail window on the new record", "panel_btn_handler": function(panel){panel.save(null,false,'poststay')}, "text": "Create without detail", "overflowText": "Create without detail", "auto_save": false } ],
  ls_url: "/cal/Calendars",
  action_name: "insert",
  initComponent : function() {
    this.ls_detail_handler = Lino.cal.Calendars.detail;
    this.ls_insert_handler = Lino.cal.Calendars.insert;
    Lino.cal.Calendars.insertPanel.superclass.initComponent.call(this);
  }
});

Lino.cal.Calendars.insert = new Lino.WindowAction({ "draggable": true, "width": Lino.chars2width(60), "autoHeight": true, "maximizable": true, "modal": true, "maximized": false },function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.cal.Calendars.insertPanel(p);
});

Lino.cal.Calendars.detailPanel = Ext.extend(Lino.cal.Calendars.DetailFormPanel,{
  empty_title: "D\u00e9tail Calendriers",
  ls_bbar_actions: [ { "itemId": "put", "menu_item_text": "Enregistrer", "tooltip": "Save changes in this form", "panel_btn_handler": function(panel){panel.save(null,false,'put')}, "iconCls": "x-tbar-save", "overflowText": "Enregistrer", "auto_save": false }, { "itemId": "insert", "menu_item_text": "Nouveau", "must_save": true, "tooltip": "Insert a new record", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-new", "overflowText": "Nouveau", "auto_save": true }, { "itemId": null, "menu_item_text": "Supprimer", "tooltip": "Delete this record", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "Supprimer", "auto_save": false } ],
  ls_url: "/cal/Calendars",
  action_name: "detail",
  initComponent : function() {
    this.ls_detail_handler = Lino.cal.Calendars.detail;
    this.ls_insert_handler = Lino.cal.Calendars.insert;
    Lino.cal.Calendars.detailPanel.superclass.initComponent.call(this);
  }
});

Lino.cal.Calendars.detail = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.cal.Calendars.detailPanel(p);
});
Lino.cal.Calendars.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.cal.Calendars.GridPanel(p);
});

// js_render_GridPanel_class cal.Subscriptions
Lino.cal.Subscriptions.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "No data to display." },
  ls_url : "/cal/Subscriptions",
  ls_bbar_actions : [ { "itemId": null, "menu_item_text": "Supprimer", "tooltip": "Delete this record", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "Supprimer", "auto_save": false } ],
  title : "Abonnements",
  page_length : 20,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "type": "int", "name": "id" }, { "name": "user" }, 'userHidden', { "name": "calendar" }, 'calendarHidden', { "type": "boolean", "name": "is_hidden" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 0,
  ls_grid_configs : [  ],
  content_type : 37,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 7,
  initComponent : function() {
    var ww = this.containing_window;
    var id3649 = new Ext.form.NumberField({ "selectOnFocus": true });
    var user3650 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/Subscriptions/user", "method": "GET" }) }), "pageSize": 20, "emptyText": "Choisir Utilisateur..." });
    var calendar3651 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/Subscriptions/calendar", "method": "GET" }) }), "allowBlank": false, "pageSize": 20, "emptyText": "Choisir Calendrier..." });
    var is_hidden3652 = new Ext.form.Checkbox({ "selectOnFocus": true, "checked": false });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ new Lino.NullNumberColumn({ "colIndex": 0, "sortable": true, "format": "0", "editable": true, "filter": { "type": "numeric" }, "header": "ID", "renderer": Lino.id_renderer, "editor": id3649, "width": Lino.chars2width(6), "dataIndex": "id" }), { "colIndex": 1, "sortable": true, "header": "Auteur", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(16), "renderer": Lino.fk_renderer('userHidden','Lino.users.Users.detail'), "editor": user3650, "dataIndex": "user" }, { "colIndex": 2, "sortable": true, "header": "Calendrier", "editable": true, "tooltip": "The calendar you want to subscribe to.\nYou can subscribe to *non-private* calendars of *other* users.", "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('calendarHidden','Lino.cal.Calendars.detail'), "editor": calendar3651, "dataIndex": "calendar" }, { "colIndex": 3, "sortable": false, "xtype": "checkcolumn", "header": "cach\u00e9", "editable": true, "tooltip": "Activer cette case pour ne pas afficher ce calendrier en ouvrant le panneau.", "filter": { "type": "boolean" }, "width": Lino.chars2width(11), "dataIndex": "is_hidden" } ];
    Lino.cal.Subscriptions.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.cal.Subscriptions.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.cal.Subscriptions.GridPanel(p);
});

// js_render_GridPanel_class cal.Places
Lino.cal.Places.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "No data to display." },
  ls_url : "/cal/Places",
  ls_bbar_actions : [ { "itemId": "insert", "menu_item_text": "Nouveau", "must_save": true, "tooltip": "Insert a new record", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-new", "overflowText": "Nouveau", "auto_save": true }, { "itemId": "detail", "menu_item_text": "D\u00e9tail", "tooltip": "Open a detail window on this record", "panel_btn_handler": Lino.show_detail, "iconCls": "x-tbar-detail", "overflowText": "D\u00e9tail", "auto_save": true }, { "itemId": null, "menu_item_text": "Supprimer", "tooltip": "Delete this record", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "Supprimer", "auto_save": false } ],
  title : "Places",
  page_length : 20,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "type": "int", "name": "id" }, { "name": "name" }, { "name": "name_fr" }, { "name": "name_nl" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 0,
  ls_grid_configs : [  ],
  content_type : 33,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 5,
  initComponent : function() {
    this.ls_detail_handler = Lino.cal.Places.detail;
    this.ls_insert_handler = Lino.cal.Places.insert;
    var ww = this.containing_window;
    var id3654 = new Ext.form.NumberField({ "selectOnFocus": true });
    var name3655 = new Ext.form.TextField({ "selectOnFocus": true, "allowBlank": false, "maxLength": 200 });
    var name_fr3656 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var name_nl3657 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ new Lino.NullNumberColumn({ "colIndex": 0, "sortable": true, "format": "0", "editable": true, "filter": { "type": "numeric" }, "header": "ID", "renderer": Lino.id_renderer, "editor": id3654, "width": Lino.chars2width(6), "dataIndex": "id" }), { "colIndex": 1, "sortable": true, "header": "Description", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "name", "editor": name3655 }, { "colIndex": 2, "sortable": true, "header": "Description (fr)", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "name_fr", "editor": name_fr3656 }, { "colIndex": 3, "sortable": true, "header": "Description (nl)", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "name_nl", "editor": name_nl3657 } ];
    Lino.cal.Places.GridPanel.superclass.initComponent.call(this);
  }
});


Lino.cal.Places.insertPanel = Ext.extend(Lino.cal.Places.DetailFormPanel,{
  empty_title: "Nouveau Places",
  hide_navigator: true,
  ls_bbar_actions: [ { "itemId": "post", "menu_item_text": "Cr\u00e9er", "tooltip": "Create the record and open a detail window on it", "panel_btn_handler": function(panel){panel.save(null,true,'post')}, "text": "Cr\u00e9er", "overflowText": "Cr\u00e9er", "auto_save": false }, { "itemId": "poststay", "menu_item_text": "Create without detail", "tooltip": "Don't open a detail window on the new record", "panel_btn_handler": function(panel){panel.save(null,false,'poststay')}, "text": "Create without detail", "overflowText": "Create without detail", "auto_save": false } ],
  ls_url: "/cal/Places",
  action_name: "insert",
  initComponent : function() {
    this.ls_detail_handler = Lino.cal.Places.detail;
    this.ls_insert_handler = Lino.cal.Places.insert;
    Lino.cal.Places.insertPanel.superclass.initComponent.call(this);
  }
});

Lino.cal.Places.insert = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.cal.Places.insertPanel(p);
});

Lino.cal.Places.detailPanel = Ext.extend(Lino.cal.Places.DetailFormPanel,{
  empty_title: "D\u00e9tail Places",
  ls_bbar_actions: [ { "itemId": "put", "menu_item_text": "Enregistrer", "tooltip": "Save changes in this form", "panel_btn_handler": function(panel){panel.save(null,false,'put')}, "iconCls": "x-tbar-save", "overflowText": "Enregistrer", "auto_save": false }, { "itemId": "insert", "menu_item_text": "Nouveau", "must_save": true, "tooltip": "Insert a new record", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-new", "overflowText": "Nouveau", "auto_save": true }, { "itemId": null, "menu_item_text": "Supprimer", "tooltip": "Delete this record", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "Supprimer", "auto_save": false } ],
  ls_url: "/cal/Places",
  action_name: "detail",
  initComponent : function() {
    this.ls_detail_handler = Lino.cal.Places.detail;
    this.ls_insert_handler = Lino.cal.Places.insert;
    Lino.cal.Places.detailPanel.superclass.initComponent.call(this);
  }
});

Lino.cal.Places.detail = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.cal.Places.detailPanel(p);
});
Lino.cal.Places.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.cal.Places.GridPanel(p);
});

// js_render_GridPanel_class cal.Priorities
Lino.cal.Priorities.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "No data to display." },
  ls_url : "/cal/Priorities",
  ls_bbar_actions : [ { "itemId": null, "menu_item_text": "Supprimer", "tooltip": "Delete this record", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "Supprimer", "auto_save": false } ],
  title : "Priorit\u00e9s",
  page_length : 20,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "name": "name" }, { "name": "name_fr" }, { "name": "name_nl" }, { "type": "in