/*
 Copyright 2009-2013 Luc Saffre
 This file is part of the Lino project.
 Lino is free software; you can redistribute it and/or modify 
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 3 of the License, or
 (at your option) any later version.
 Lino is distributed in the hope that it will be useful, 
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the 
 GNU General Public License for more details.
 You should have received a copy of the GNU General Public License
 along with Lino; if not, see <http://www.gnu.org/licenses/>.
*/

// lino.js --- generated Thu May 30 06:54:33 2013 by Lino version 1.6.9.
Ext.BLANK_IMAGE_URL = '/media/extjs/resources/images/default/s.gif';
LANGUAGE_CHOICES = [ [ "de", "German" ], [ "fr", "French" ], [ "nl", "Dutch" ] ];
MEDIA_URL = "/media";

/* MonthPickerPlugin: thanks to keypoint @ sencha forum
   http://www.sencha.com/forum/showthread.php?74002-3.x-Ext.ux.MonthMenu&p=356860#post356860
*/
Ext.namespace('Ext.ux'); 

Ext.ux.MonthPickerPlugin = function() { 
    var picker; 
    var oldDateDefaults; 

    this.init = function(pk) { 
        picker = pk; 
        picker.onTriggerClick = picker.onTriggerClick.createSequence(onClick); 
        picker.getValue = picker.getValue.createInterceptor(setDefaultMonthDay).createSequence(restoreDefaultMonthDay); 
        picker.beforeBlur = picker.beforeBlur.createInterceptor(setDefaultMonthDay).createSequence(restoreDefaultMonthDay); 
    }; 

    function setDefaultMonthDay() { 
        oldDateDefaults = Date.defaults.d; 
        Date.defaults.d = 1; 
        return true; 
    } 

    function restoreDefaultMonthDay(ret) { 
        Date.defaults.d = oldDateDefaults; 
        return ret; 
    } 

    function onClick(e, el, opt) { 
        var p = picker.menu.picker; 
        p.activeDate = p.activeDate.getFirstDateOfMonth(); 
        if (p.value) { 
            p.value = p.value.getFirstDateOfMonth(); 
        } 

        p.showMonthPicker(); 
         
        if (!p.disabled) { 
            p.monthPicker.stopFx(); 
            p.monthPicker.show(); 

            p.mun(p.monthPicker, 'click', p.onMonthClick, p); 
            p.mun(p.monthPicker, 'dblclick', p.onMonthDblClick, p); 
            p.onMonthClick = p.onMonthClick.createSequence(pickerClick); 
            p.onMonthDblClick = p.onMonthDblClick.createSequence(pickerDblclick); 
            p.mon(p.monthPicker, 'click', p.onMonthClick, p); 
            p.mon(p.monthPicker, 'dblclick', p.onMonthDblClick, p); 
        } 
    } 

    function pickerClick(e, t) { 
        var el = new Ext.Element(t); 
        if (el.is('button.x-date-mp-cancel')) { 
            picker.menu.hide(); 
        } else if(el.is('button.x-date-mp-ok')) { 
            var p = picker.menu.picker; 
            p.setValue(p.activeDate); 
            p.fireEvent('select', p, p.value); 
        } 
    } 

    function pickerDblclick(e, t) { 
        var el = new Ext.Element(t); 
        if (el.parent() 
            && (el.parent().is('td.x-date-mp-month') 
            || el.parent().is('td.x-date-mp-year'))) { 

            var p = picker.menu.picker; 
            p.setValue(p.activeDate); 
            p.fireEvent('select', p, p.value); 
        } 
    } 
}; 

Ext.preg('monthPickerPlugin', Ext.ux.MonthPickerPlugin);  

//~ /* 
  //~ http://www.diloc.de/blog/2008/03/05/how-to-submit-ext-forms-the-right-way/
//~ */
//~ /**
 //~ * This submit action is basically the same as the normal submit action,
 //~ * only that it uses the fields getSubmitValue() to compose the values to submit,
 //~ * instead of looping over the input-tags in the form-tag of the form.
 //~ *
 //~ * To use it, just use the OOSubmit-plugin on either a FormPanel or a BasicForm,
 //~ * or explicitly call form.doAction('oosubmit');
 //~ *
 //~ * @param {Object} form
 //~ * @param {Object} options
 //~ */
//~ Ext.ux.OOSubmitAction = function(form, options){
    //~ Ext.ux.OOSubmitAction.superclass.constructor.call(this, form, options);
//~ };

//~ Ext.extend(Ext.ux.OOSubmitAction, Ext.form.Action.Submit, {
    //~ /**
    //~ * @cfg {boolean} clientValidation Determines whether a Form's fields are validated
    //~ * in a final call to {@link Ext.form.BasicForm#isValid isValid} prior to submission.
    //~ * Pass <tt>false</tt> in the Form's submit options to prevent this. If not defined, pre-submission field validation
    //~ * is performed.
    //~ */
    //~ type : 'oosubmit',

    //~ // private
    //~ /**
     //~ * This is nearly a copy of the original submit action run method
     //~ */
    //~ run : function(){
        //~ var o = this.options;
        //~ var method = this.getMethod();
        //~ var isPost = method == 'POST';

        //~ var params = this.options.params || {};
        //~ if (isPost) Ext.applyIf(params, this.form.baseParams);

        //~ //now add the form parameters
        //~ this.form.items.each(function(field)
        //~ {
            //~ if (!field.disabled)
            //~ {
                //~ //check if the form item provides a specialized getSubmitValue() and use that if available
                //~ if (typeof field.getSubmitValue == "function")
                    //~ params[field.getName()] = field.getSubmitValue();
                //~ else
                    //~ params[field.getName()] = field.getValue();
            //~ }
        //~ });

        //~ //convert params to get style if we are not post
        //~ if (!isPost) params=Ext.urlEncode(params);

        //~ if(o.clientValidation === false || this.form.isValid()){
            //~ Ext.Ajax.request(Ext.apply(this.createCallback(o), {
                //~ url:this.getUrl(!isPost),
                //~ method: method,
                //~ params:params, //add our values
                //~ isUpload: this.form.fileUpload
            //~ }));

        //~ }else if (o.clientValidation !== false){ // client validation failed
            //~ this.failureType = Ext.form.Action.CLIENT_INVALID;
            //~ this.form.afterAction(this, false);
        //~ }
    //~ },

//~ });
//~ //add our action to the registry of known actions
//~ Ext.form.Action.ACTION_TYPES['oosubmit'] = Ext.ux.OOSubmitAction;




/**
JC Watsons solution (adapted to ExtJS 3.3.1 by LS) is elegant and simple:
`A "fix" for unchecked checkbox submission  behaviour
<http://www.sencha.com/forum/showthread.php?28449>`_

Added special handling for checkbox inputs. 
ExtJS defines disabled checkboxes `readonly`, not `disabled` as for other inputs.

*/
Ext.lib.Ajax.serializeForm = function(form) {
    //~ console.log('20120203 linolib.js serializeForm',form);
    var fElements = form.elements || (document.forms[form] || Ext.getDom(form)).elements, 
        hasSubmit = false, 
        encoder = encodeURIComponent, 
        name, 
        data = '', 
        type, 
        hasValue;

    Ext.each(fElements, function(element){
        name = element.name;
        type = element.type;

        if (!element.disabled && name && !(type == 'checkbox' && element.readonly)) {
            if (/select-(one|multiple)/i.test(type)) {
                Ext.each(element.options, function(opt){
                    if (opt.selected) {
                        hasValue = opt.hasAttribute ? opt.hasAttribute('value') : opt.getAttributeNode('value').specified;
                        data += String.format("{0}={1}&", encoder(name), encoder(hasValue ? opt.value : opt.text));
                    }
                });
            } else if (!(/file|undefined|reset|button/i.test(type))) {
                //~ if (!(/radio|checkbox/i.test(type) && !element.checked) && !(type == 'submit' && hasSubmit)) {
                if (!(type == 'submit' && hasSubmit)) {
                    if (type == 'checkbox') {
                        //~ console.log('20111001',element,'data += ',encoder(name) + '=' + (element.checked ? 'on' : 'off') + '&');
                        data += encoder(name) + '=' + (element.checked ? 'on' : 'off') + '&';
                    } else {
                        //~ console.log('20111001',element,'data += ',encoder(name) + '=' + encoder(element.value) + '&');
                        data += encoder(name) + '=' + encoder(element.value) + '&';
                    }
                    hasSubmit = /submit/i.test(type);
                }
            }
        //~ } else {
            //~ console.log(name,type,element.readonly);
        }
    });
    return data.substr(0, data.length - 1);
};



/*
Set a long timeout of fifteen minutes. 
See /blog/2012/0307
*/
Ext.Ajax.timeout = 15 * 60 * 1000; 


/*
My fix for the "Cannot set QuickTips dismissDelay to 0" bug,
see http://www.sencha.com/forum/showthread.php?183515 
*/
Ext.override(Ext.QuickTip,{
  showAt : function(xy){
        var t = this.activeTarget;
        //~ console.log("20120224 QuickTip.showAt",this.title,this.dismissDelay,t.dismissDelay);
        if(t){
            if(!this.rendered){
                this.render(Ext.getBody());
                this.activeTarget = t;
            }
            if(t.width){
                this.setWidth(t.width);
                this.body.setWidth(this.adjustBodyWidth(t.width - this.getFrameWidth()));
                this.measureWidth = false;
            } else{
                this.measureWidth = true;
            }
            this.setTitle(t.title || '');
            this.body.update(t.text);
            this.autoHide = t.autoHide;
            // bugfix by Luc 20120226
            if (t.dismissDelay != undefined) this.dismissDelay = t.dismissDelay;
            //~ this.dismissDelay = t.dismissDelay || this.dismissDelay;
            if(this.lastCls){
                this.el.removeClass(this.lastCls);
                delete this.lastCls;
            }
            if(t.cls){
                this.el.addClass(t.cls);
                this.lastCls = t.cls;
            }
            if(this.anchor){
                this.constrainPosition = false;
            }else if(t.align){ 
                xy = this.el.getAlignToXY(t.el, t.align);
                this.constrainPosition = false;
            }else{
                this.constrainPosition = true;
            }
        }
        Ext.QuickTip.superclass.showAt.call(this, xy);
    }
});

/*
Another hack. See /docs/blog/2012/0228
*/
Ext.Element.addMethods(
    function() {
        var VISIBILITY      = "visibility",
            DISPLAY         = "display",
            HIDDEN          = "hidden",
            NONE            = "none",
            XMASKED         = "x-masked",
            XMASKEDRELATIVE = "x-masked-relative",
            data            = Ext.Element.data;

        return {
            
            mask : function(msg, msgCls) {
                var me  = this,
                    dom = me.dom,
                    dh  = Ext.DomHelper,
                    EXTELMASKMSG = "ext-el-mask-msg",
                    el,
                    mask;
                // removed the following lines. See /docs/blog/2012/0228
                //~ if (!(/^body/i.test(dom.tagName) && me.getStyle('position') == 'static')) {
                    //~ console.log(20120228,dom.tagName,me);
                    //~ me.addClass(XMASKEDRELATIVE); 
                //~ }
                if (el = data(dom, 'maskMsg')) {
                    el.remove();
                }
                if (el = data(dom, 'mask')) {
                    el.remove();
                }

                mask = dh.append(dom, {cls : "ext-el-mask"}, true);
                data(dom, 'mask', mask);

                me.addClass(XMASKED);
                mask.setDisplayed(true);
                
                if (typeof msg == 'string') {
                    var mm = dh.append(dom, {cls : EXTELMASKMSG, cn:{tag:'div'}}, true);
                    data(dom, 'maskMsg', mm);
                    mm.dom.className = msgCls ? EXTELMASKMSG + " " + msgCls : EXTELMASKMSG;
                    mm.dom.firstChild.innerHTML = msg;
                    mm.setDisplayed(true);
                    mm.center(me);
                }
                
                
                if (Ext.isIE && !(Ext.isIE7 && Ext.isStrict) && me.getStyle('height') == 'auto') {
                    mask.setSize(undefined, me.getHeight());
                }
                
                return mask;
            }

            
        };
    }()
);



Ext.namespace('Lino');
    
    

//~ Lino.subst_user_field = new Ext.form.ComboBox({});
//~ Lino.subst_user = null;
Lino.insert_subst_user = function(p){
    //~ console.log('20120714 insert_subst_user',Lino.subst_user,p);
    //~ if (Lino.subst_user_field.getValue()) {
    if (p.su) return;
    if (Lino.subst_user) {
        //~ p.su = Lino.subst_user_field.getValue();
        p.su = Lino.subst_user;
    //~ } else {
        //~ delete p.su;
    }
    //~ console.log('20120714 insert_subst_user -->',Lino.subst_user,p);
}

Lino.login_window = null;


Lino.show_login_window = function() {
  //~ console.log('20121103 show_login_window',arguments);
  //~ var current_window = Lino.current_window;
  if (Lino.login_window == null) {
    
      function do_login() { 
            Lino.viewport.loadMask.show()
            //~ Lino.body_loadMask.show()
            login_panel.getForm().submit({ 
                method:'POST', 
                waitTitle:'Connecting', 
                waitMsg:'Sending data...',
                success:function(){ 
                  //~ console.log('20121104 logged in',arguments);
                  Lino.login_window.hide();
                  Lino.close_all_windows();
                  Lino.viewport.loadMask.hide()
                  //~ Lino.body_loadMask.hide()
                },
                failure: function(form,action) { 
                  //~ this.loadMask.hide();
                  Lino.on_submit_failure(form,action);
                  Lino.viewport.loadMask.hide()
                  //~ Lino.body_loadMask.hide()
                  //~ if (Lino.current_window) Lino.current_window.main_item.loadMask.hide()
                }
                //~ failure:function(form, action){ 
                    //~ alert_msg
                    //~ if(action.failureType == 'server'){ 
                        //~ obj = Ext.util.JSON.decode(action.response.responseText); 
                        //~ Ext.Msg.alert('Login Failed!', obj.errors.reason); 
                    //~ }else{ 
                        //~ Ext.Msg.alert('Warning!', 'Authentication server is unreachable : ' + action.response.responseText); 
                    //~ } 
                    //~ Lino.login_panel.getForm().reset(); 
                //~ } 
            }); 
      };
    
      var login_button = new Ext.Button({ 
        text:"Log in",
        formBind: true,	 
        // Function that fires when user clicks the button 
        handler: do_login});
    
      var login_panel = new Ext.FormPanel({ 
        //~ inspired by http://www.sencha.com/learn/a-basic-login/
        autoHeight:true,
        labelWidth:90,
        url:'/auth', 
        frame:true, 
        defaultType:'textfield',
        monitorValid:true,
        items:[{ 
            fieldLabel:"Username", 
            id: 'username',
            name:'username', 
            autoHeight:true,
            allowBlank:false 
        },{ 
            fieldLabel:"Password", 
            name:'password', 
            inputType:'password', 
            autoHeight:true,
            allowBlank:false 
        }],        
        buttons:[ login_button ]});
        
      Lino.login_window = new Ext.Window({
          layout:'fit',
          defaultButton: 'username',
          width:300,
          title:"Log in", 
          autoHeight:true,
          modal: true,
          closeAction: "hide",
          keys: {
            key: Ext.EventObject.ENTER,
            fn: function() { do_login()}
          },
          //~ defaultButton: login_button,
          //~ height:'auto',
          //~ closable: false,
          //~ resizable: false,
          //~ plain: true,
          //~ border: false,
          items: [login_panel] });
  };
  Lino.login_window.show();
};

Lino.logout = function(id,name) {
    //~ console.log('20121104 gonna log out',arguments);
    //~ Lino.do_action
    Lino.call_ajax_action(Lino.viewport,'GET','/auth',{},'logout',undefined,undefined,function(){
        //~ console.log('20121104 logged out',arguments);
        //~ Lino.login_window.hide();
        Lino.close_all_windows();
    })
}

Lino.set_subst_user = function(id,name) {
    //~ console.log(20120714,'Lino.set_subst_user',id,name);
    Lino.subst_user = id;

    if(id) {
        Lino.eventStore.setBaseParam("su",id);
    } else {
      delete Lino.eventStore.baseParams['su'];
    }

    if (Lino.current_window) 
        Lino.current_window.main_item.set_base_param("su",id);
    if (Lino.viewport) Lino.permalink_handler(Lino.current_window)();
}



//~ Lino.select_subst_user = function(cmp,rec,value){
    //~ Lino.subst_user=value;
    //~ console.log(20120713,rec);
//~ }
    
Lino.current_window = null;
Lino.window_history = Array();
    
Lino.chars2width = function(cols) {  return cols * 9; }
Lino.rows2height = function(cols) {  return cols * 20; }



Lino.Viewport = Ext.extend(Ext.Viewport,{
  layout:"fit"
  ,initComponent : function(){
    Lino.Viewport.superclass.initComponent.call(this);
    this.on('render',function(){
      this.loadMask = new Ext.LoadMask(this.el,{msg:"Please wait..."});
      //~ console.log("20121118 Lino.viewport.loadMask",this.loadMask);
    },this);
  }
  ,get_base_params : function() { 
    var p = {};
    Lino.insert_subst_user(p);
    return p;
  }
  ,refresh : function() {
      var caller = this;
      console.log("20121120 Lino.Viewport.refresh()");
      if (caller.loadMask) caller.loadMask.show();
      var success = function(response) {
        if (caller.loadMask) caller.loadMask.hide();
        if (response.responseText) {
          var result = Ext.decode(response.responseText);
          //~ console.log('Lino.do_action()',action.name,'result is',result);
          if (result.html) {
              Ext.getCmp('main_area').update(result.html);
          }
          if (result.message) {
              if (result.alert) {
                  //~ Ext.MessageBox.alert('Alert',result.alert_msg);
                  Ext.MessageBox.alert('Alert',result.message);
              } else {
                  Lino.notify(result.message);
              }
          }
          
          if (result.notify_msg) Lino.notify(result.notify_msg);
          if (result.js_code) { 
            var jsr = result.js_code(caller);
            //~ console.log('Lino.do_action()',action,'returned from js_code in',result);
          };
        }
      };
      var action = {
        url : '/api/main_html',
        waitMsg: "Please wait...",
        failure: Lino.ajax_error_handler(caller),
        success: success,
        method: 'GET',
        params: {}
      };
      Lino.insert_subst_user(action.params);
      Ext.Ajax.request(action);
    
  }
});


Lino.open_window = function(win,st,requesting_panel) {
  //~ console.log("20120918 Lino.open_window()",win,st);
  var cw = Lino.current_window;
  if (cw) {
    //~ console.log("20120918 Lino.open_window() save current status",cw.main_item.get_status());
    Lino.window_history.push({
      window:cw,
      status:cw.main_item.get_status()
    });
  }
  Lino.current_window = win;
  //~ if (st.su) 
      //~ Lino.subst_user_field.setValue(st.su);
  win.main_item.set_status(st,requesting_panel);
  win.show();
};

Lino.load_url = function(url) {
    //~ foo.bar.baz = 2; 
    //~ console.log("20121120 Lino.load_url()");
    //~ Lino.body_loadMask.show();
    Lino.viewport.loadMask.show();
    //~ location.replace(url);
    document.location = url;
}

Lino.close_window = function(status_update) {
  var cw = Lino.current_window;
  var ww = Lino.window_history.pop();
  if (ww) {
    //~ if (status_update) Ext.apply(ww.status,status_update);
    if (status_update) status_update(ww);
    ww.window.main_item.set_status(ww.status);
    Lino.current_window = ww.window;
  } else {
    Lino.current_window = null;
  }
  if (cw) cw.hide_really();
};

Lino.close_all_windows = function() {
  if (Lino.window_history.length == 0) {
      //~ Lino.viewport.refresh();
      var url =  "/"
      //~ console.log("20121120 Lino.close_all_windows() : no window_history");
      //~ if (ADMIN_URL) 
      var p = {};
      Lino.insert_subst_user(p)
      if (Ext.urlEncode(p)) url = url + "?" + Ext.urlEncode(p);
      Lino.load_url(url);
  } else {
    //~ console.log("20121120 Lino.close_all_windows() with window_history");
    while (Lino.window_history.length > 0) {
      Lino.close_window();
      //~ Lino.window_history.pop().hide_really();
    }
  }
  //~ Lino.current_window = null;
  //~ Lino.close_window();
  //~ var ww = 
}

Lino.kill_current_window = function() {
  var cw = Lino.current_window;
  Lino.current_window = null;
  if (cw) cw.hide_really();
};

Lino.calling_window = function() {
    if (Lino.window_history.length) return Lino.window_history[Lino.window_history.length-1];
}

//~ Lino.WindowAction = function(mainItemClass,windowConfig,mainConfig,ppf) {
Lino.WindowAction = function(windowConfig,main_item_fn) {
    //~ if(!mainConfig) mainConfig = {};
    //~ mainConfig.is_main_window = true;
    this.windowConfig = windowConfig;
    this.main_item_fn = main_item_fn;
    //~ if (ppf) mainConfig.params_panel.fields = ppf;
    //~ this.mainConfig = mainConfig;
    //~ this.mainItemClass = mainItemClass;
};

Lino.WindowAction = Ext.extend(Lino.WindowAction,{
    window : null,
    //~ mainItemClass: null,
    get_window : function() {
      //~ if(mainConfig) Ext.apply(this.mainConfig,mainConfig);
      if (this.window == null)  {
          //~ this.windowConfig.main_item = new this.mainItemClass(this.mainConfig);
          this.windowConfig.main_item = this.main_item_fn();
          this.window = new Lino.Window(this.windowConfig);
      }
      return this.window;
    },
    run : function(requesting_panel,status) {
      //~ console.log('20120625 window_action.run()',this)
      Lino.open_window(this.get_window(),status,requesting_panel);
    }
  
});


Lino.PanelMixin = {
  get_containing_window : function (){
      if (this.containing_window) return this.containing_window;
      return this.containing_panel.get_containing_window();
  }
  ,set_window_title : function(title) {
    //~ this.setTitle(title);
    var cw = this.get_containing_window();

    //~ if (cw) {
    //~ if (cw && cw.closable) {
    if (cw && !cw.main_item.hide_window_title) {
      //~ console.log('20111202 set_window_title(',title,') for',this.containing_window);
      //~ if (! this.containing_window.rendered) console.log("WARNING: not rendered!");
      cw.setTitle(title);
    //~ } else {
      //~ document.title = title;
    }
    //~ else console.log('20111202 not set_window_title(',title,') for',this);
  }
  
};


// Lino.status_bar = new Ext.ux.StatusBar({defaultText:'Lino version 1.6.9.'});
Lino.status_bar = new Ext.ux.StatusBar({defaultText:'Lino Welfare 1.1.6.'});



Lino.edit_tinymce_text = function(panel,options) {
  // `panel` is the RichTextPanel
  //~ console.log(20111220,panel);
  //~ var rec = panel.get_current_record();
  var rec = panel.containing_panel.get_current_record();
  var value = rec ? rec.data[panel.editor.name] : '';
  var saving = false;
  var todo_after_save = false;
  var discard_changes = false;
  
  
  function save() {
    //~ if (todo_after_save) {alert('tried to save again'); return; }
    if (saving) {alert('tried to save again'); return; }
    //~ var url = panel.containing_window.main_item.get_record_url(rec.id);
    var url = panel.containing_panel.get_record_url(rec.id);
    var params = Ext.apply({},panel.containing_panel.get_base_params());
    params[panel.editor.name] = editor.getValue();
    //~ params.su = Lino.subst_user;
    //~ Lino.insert_subst_user(params);
    var a = { 
      params: params, 
      method: 'PUT',
      url: url,
      failure: function() {
          //~ if (editor.ed.getContainer()) 
          editor.ed.setProgressState(0);
          todo_after_save = false;
          saving = false;
          console.log('tinymce.save() failed. sorry.',arguments);
        },
      success: function() {
        saving = false;
        //~ if (editor.ed.getContainer()) 
        editor.ed.setProgressState(0);
        rec.data[panel.editor.name] = editor.getValue();
        if(todo_after_save) {
            var fn = todo_after_save;
            todo_after_save = false;
            fn();
        }
        //~ panel.containing_window.set_current_record(rec);
        panel.refresh();
      }
    };
    //~ if (editor.ed.getContainer()) 
    editor.ed.setProgressState(1); // Show progress
    saving = true;
    //~ console.log(a);
    Ext.Ajax.request(a);
  };
  function save_callback() {
      save();
      //~ save(function(){editor.ed.setDirty(false);})
      /* return true have the save button disabled.  
      That's not perfect because the PUT is asynchronous 
      and the response is not yet known.
      */
      return true;
  }
  //~ var actions = [
    //~ {text:"Save",handler:save}
  //~ ]; 
  //~ console.log(20110610,panel.editor.disabled);
  var settings = {};
  Ext.apply(settings,{
        readonly: panel.editor.disabled,
        //~ language: "de",
        plugins : "save,emotions,spellchecker,advhr,insertdatetime,preview,table,searchreplace,template", 
        // Theme options - button# indicated the row# only
        theme_advanced_buttons1 : "save,cancel,|,bold,italic,underline,|,justifyleft,justifycenter,justifyright,fontselect,fontsizeselect,formatselect,|,search,replace",
        theme_advanced_buttons2 : "cut,copy,paste,template,|,bullist,numlist,|,outdent,indent,|,undo,redo,|,link,unlink,anchor,image,|,code,preview,|,forecolor,backcolor",
        theme_advanced_buttons3 : "insertdate,inserttime,|,spellchecker,advhr,,removeformat,|,sub,sup,|,charmap,emotions,|,tablecontrols",      
        theme_advanced_resizing : false,
        convert_urls : false,
        save_onsavecallback : save_callback,
        save_enablewhendirty : true
        //~ save_oncancelcallback: on_cancel
  });
  Ext.apply(settings,options);
  var editor = new Ext.ux.TinyMCE({
      value : value,
      tinymceSettings: settings
    });
  var win = new Ext.Window({
    title: rec.title, 
    //~ bbar: actions,
    layout: 'fit',
    items: editor,
    width: 600, 
    height:500,
    minWidth: 100,
		minHeight: 100,
    modal: true,
    resizable: true,
    maximizable: true,
    //~ maximized: true,
    //~ closeAction: "close"
    closeAction: "hide"
    //~ hideMode: "offsets",
    //~ constrainHeader: true,
    //~ bodyStyle: 'padding: 10px'
  });

  //~ win.on('beforeclose',function() {
  win.on('beforehide',function() {
    if (todo_after_save) return false;
    if (discard_changes) return true;
    if (editor.isDirty()) {
        //~ var ok = false;
        //~ var allowClose = true;
        var config = {title:"Confirmation"};
        config.buttons = Ext.MessageBox.YESNOCANCEL;
        config.msg = "Save changes to text ?";
        config.modal = true;
        config.fn = function(buttonId,text,opt) {
          //~ console.log('do_when_clean',buttonId)
          if (buttonId == "yes") {
              /* we cancel this close, but save()'s onSuccess will call again.*/
              //~ allowClose = false;
              todo_after_save = function(){win.hide();}
              editor.ed.execCommand('mceSave');
              //~ editor.ed.save(function(){win.close();});
          } else if (buttonId == "no") { 
              discard_changes = true;
              win.hide()
          //~ } else if (buttonId == "cancel") { 
            //~ ok = true;
              //~ allowClose = false;
          //~ } else { 
            //~ console.log('unknwon buttonId:',buttonId);
          }
        }
        Ext.MessageBox.show(config);
        return false;
        //~ return allowClose;
    }
  });
  win.show();
}







/* 
  Originally copied from Ext JS Library 3.3.1
  Modifications by Luc Saffre : 
  - rendering of phantom records
  - fire afteredit event
  - react on dblclcik, not on single click

 */
Lino.CheckColumn = Ext.extend(Ext.grid.Column, {

    processEvent : function(name, e, grid, rowIndex, colIndex){
        //~ console.log('20110713 Lino.CheckColumn.processEvent',name)
        if (name == 'click') {
        //~ if (name == 'mousedown') {
        //~ if (name == 'dblclick') {
            return this.toggleValue(grid, rowIndex, colIndex);
        } else {
            return Ext.grid.ActionColumn.superclass.processEvent.apply(this, arguments);
        }
    },
    
    toggleValue : function (grid,rowIndex,colIndex) {
        var record = grid.store.getAt(rowIndex);
        var dataIndex = grid.colModel.getDataIndex(colIndex);
        // 20120514
        //~ if(record.data.disabled_fields && record.data.disabled_fields[dataIndex]) {
          //~ Lino.notify("This field is disabled");
          //~ return false;
        //~ }
      
        //~ if (dataIndex in record.data['disabled_fields']) {
            //~ Lino.notify("This field is disabled.");
            //~ return false;
        //~ }
        var startValue = record.data[dataIndex];
        var value = !startValue;
        //~ record.set(this.dataIndex, value);
        var e = {
            grid: grid,
            record: record,
            field: dataIndex,
            originalValue: startValue,
            value: value,
            row: rowIndex,
            column: colIndex,
            cancel: false
        };
        if(grid.fireEvent("beforeedit", e) !== false && !e.cancel){
        //~ if(grid.fireEvent("validateedit", e) !== false && !e.cancel){
            record.set(dataIndex, value);
            delete e.cancel;
            grid.fireEvent("afteredit", e);
        }
        return false; // Cancel event propagation
    },

    renderer : function(v, p, record){
        if (record.phantom) return '';
        p.css += ' x-grid3-check-col-td'; 
        return String.format('<div class="x-grid3-check-col{0}">&#160;</div>', v ? '-on' : '');
    }

    // Deprecate use as a plugin. Remove in 4.0
    // init: Ext.emptyFn
});

// register ptype. Deprecate. Remove in 4.0
// Ext.preg('checkcolumn', Lino.CheckColumn);

// backwards compat. Remove in 4.0
// Ext.grid.CheckColumn = Lino.CheckColumn;

// register Column xtype
Ext.grid.Column.types.checkcolumn = Lino.CheckColumn;


/* 20110725 : 
Lino.on_tab_activate is necessary 
in contacts.Person.2.dtl 
(but don't ask me why...)
*/
Lino.on_tab_activate = function(item) {
  //~ console.log('activate',item); 
  if (item.rendered && item.doLayout) item.doLayout();
  //~ if (item.rendered) item.doLayout();
}

Lino.TimeField = Ext.extend(Ext.form.TimeField,{
  format: 'H:i',
  increment: 15
  });
Lino.DateField = Ext.extend(Ext.form.DateField,{
  boxMinWidth: Lino.chars2width(11),
  format: 'd.m.Y',
  altFormats: 'd/m/Y|Y-m-d'
  });
Lino.DatePickerField = Ext.extend(Ext.DatePicker,{
  //~ boxMinWidth: Lino.chars2width(11),
  format: 'd.m.Y',
  //~ altFormats: 'd/m/Y|Y-m-d'
  formatDate : function(date){
      console.log("20121203 formatDate",this.name,date);
      return Ext.isDate(date) ? date.dateFormat(this.format) : date;
  }
  });
Lino.DateTimeField = Ext.extend(Ext.ux.form.DateTime,{
  dateFormat: 'd.m.Y',
  timeFormat: 'H:i',
  //~ hiddenFormat: 'd.m.Y H:i'
  });
Lino.URLField = Ext.extend(Ext.form.TriggerField,{
  triggerClass : 'x-form-search-trigger',
  //~ triggerClass : 'x-form-world-trigger',
  vtype: 'url',
  onTriggerClick : function() {
    //~ console.log('Lino.URLField.onTriggerClick',this.value)
    //~ document.location = this.value;
    window.open(this.getValue(),'_blank');
  }
});
Lino.IncompleteDateField = Ext.extend(Ext.form.TextField,{
  //~ regex: /^-?\d+-[01]\d-[0123]\d$/,
  //~ regex: /^[0123]\d\.[01]\d\.-?\d+$/,
  maxLength: 10,
  boxMinWidth: Lino.chars2width(10),
  regex: /^[0123]?\d\.[01]?\d\.-?\d+$/,
  regexText: 'Enter a date in format YYYY-MM-DD (use zeroes for unknown parts).'
  });


//~ Lino.make_dropzone = function(cmp) {
    //~ cmp.on('render', function(ct, position){
      //~ ct.el.on({
        //~ dragenter:function(event){
          //~ event.browserEvent.dataTransfer.dropEffect = 'move';
          //~ return true;
        //~ }
        //~ ,dragover:function(event){
          //~ event.browserEvent.dataTransfer.dropEffect = 'move';
          //~ event.stopEvent();
          //~ return true;
        //~ }
        //~ ,drop:{
          //~ scope:this
          //~ ,fn:function(event){
            //~ event.stopEvent();
            //~ console.log(20110516);
            //~ var files = event.browserEvent.dataTransfer.files;
            //~ if(files === undefined){
              //~ return true;
            //~ }
            //~ var len = files.length;
            //~ while(--len >= 0){
              //~ console.log(files[len]);
              //~ // this.processDragAndDropFileUpload(files[len]);
            //~ }
          //~ }
        //~ }
      //~ });
    //~ });
//~ };

//~ Lino.FileUploadField = Ext.ux.form.FileUploadField;

Lino.FileUploadField = Ext.extend(Ext.ux.form.FileUploadField,{
    onRender : function(ct, position){
      Lino.FileUploadField.superclass.onRender.call(this, ct, position);
      this.el.on({
        dragenter:function(event){
          event.browserEvent.dataTransfer.dropEffect = 'move';
          return true;
        }
        ,dragover:function(event){
          event.browserEvent.dataTransfer.dropEffect = 'move';
          event.stopEvent();
          return true;
        }
        ,drop:{
          scope:this
          ,fn:function(event){
            event.stopEvent();
            //~ console.log(20110516);
            var files = event.browserEvent.dataTransfer.files;
            if(files === undefined){
              return true;
            }
            var len = files.length;
            while(--len >= 0){
              console.log(files[len]);
              //~ this.processDragAndDropFileUpload(files[len]);
            }
          }
        }
      });
    }
});

Lino.FileField = Ext.extend(Ext.form.TriggerField,{
  triggerClass : 'x-form-search-trigger',
  editable: false,
  onTriggerClick : function() {
    //~ console.log('Lino.URLField.onTriggerClick',this.value)
    //~ document.location = this.value;
    if (this.getValue()) window.open(MEDIA_URL + '/'+this.getValue(),'_blank');
  }
});

Lino.file_field_handler = function(panel,config) {
  //~ if (instanceof Lino.DetailWrapper) {
  if (panel.action_name == 'insert') {
  //~ if (panel.get_current_record().phantom) {
      panel.has_file_upload = true;

      var f = new Lino.FileUploadField(config);
      //~ Lino.make_dropzone(f);
      return f;
      //~ return new Ext.ux.form.FileUploadField(config);
      //~ return new Lino.FileField(config);
      
  } else {
      //~ return new Lino.URLField(config);
      return new Lino.FileField(config);
  }
}

Lino.VBorderPanel = Ext.extend(Ext.Panel,{
    constructor : function(config) {
      config.layout = 'border';
      delete config.layoutConfig;
      Lino.VBorderPanel.superclass.constructor.call(this,config);
      for(var i=0; i < this.items.length;i++) {
        var item = this.items.get(i);
        if (this.isVertical(item) && item.collapsible) {
          item.on('collapse',this.onBodyResize,this);
          item.on('expand',this.onBodyResize,this);
        }
      }
    },
    isVertical : function(item) {
       return (item.region == 'north' || item.region == 'south' || item.region == 'center');
    },
    onBodyResize: function(w, h){
        //~ console.log('VBorderPanel.onBodyResize',this.title)
      if (this.isVisible()) { // to avoid "Uncaught TypeError: Cannot call method 'getHeight' of undefined."
        var sumflex = 0;
        var availableHeight = this.getInnerHeight();
        var me = this;
        this.items.each(function(item){
          if (me.isVertical(item)) {
              if (item.collapsed || item.flex == 0 || item.flex === undefined) {
                  if (item.rendered) availableHeight -= item.getHeight();
              } else {
                  sumflex += item.flex;
              }
          } 
          
        });
        //~ for(var i=0; i < this.items.length;i++) {
          //~ var item = this.items.get(i);
          //~ // if (this.isVertical(item) && item.getResizeEl()) {
          //~ if (this.isVertical(item)) {
              //~ if (item.collapsed || item.flex == 0 || item.flex === undefined) {
                  //~ // item.syncSize()
                  //~ // item.doLayout()
                  //~ // if (item.region == "north") console.log('region north',item.getHeight(),item.id, item);
                  //~ // if (item.getHeight() == 0) console.log(20100921,'both flex and getHeight() are 0!');
                  //~ availableHeight -= item.getHeight();
              //~ } else {
                  //~ sumflex += item.flex;
                  //~ // console.log(item.flex);
              //~ }
          //~ } 
          //~ // else console.log('non-vertical item in VBoderPanel:',item)
        //~ }
        var hunit = availableHeight / sumflex;
        //~ console.log('sumflex=',sumflex,'hunit=',hunit, 'availableHeight=',availableHeight);
        for(var i=0; i < this.items.length;i++) {
          var item = this.items.get(i);
          if (this.isVertical(item)) {
              if (item.flex != 0 && ! item.collapsed) {
                  item.setHeight(hunit * item.flex);
                  //~ console.log(item.region,' : height set to',item.getHeight());
              }
          }
          //~ else console.log('non-vertical item in VBoderPanel:',item)
        }
      }
      Lino.VBorderPanel.superclass.onBodyResize.call(this, w, h);
    }
});


/*
  modifications to the standard behaviour of a CellSelectionModel:
  
*/
Ext.override(Ext.grid.CellSelectionModel, {
//~ var dummy = {

    handleKeyDown : function(e){
        /* removed because F2 wouldn't pass
        if(!e.isNavKeyPress()){
            return;
        }
        */
        //~ console.log('handleKeyDown',e)
        var k = e.getKey(),
            g = this.grid,
            s = this.selection,
            sm = this,
            walk = function(row, col, step){
                return g.walkCells(
                    row,
                    col,
                    step,
                    g.isEditor && g.editing ? sm.acceptsNav : sm.isSelectable, 
                    sm
                );
            },
            cell, newCell, r, c, ae;

        switch(k){
            case e.ESC:
            case e.PAGE_UP:
            case e.PAGE_DOWN:
                break;
            default:
                // e.stopEvent(); // removed because Browser keys like Alt-Home, Ctrl-R wouldn't work
                break;
        }

        if(!s){
            cell = walk(0, 0, 1); 
            if(cell){
                this.select(cell[0], cell[1]);
            }
            return;
        }

        cell = s.cell;  
        r = cell[0];    
        c = cell[1];    
        
        switch(k){
            case e.TAB:
                if(e.shiftKey){
                    newCell = walk(r, c - 1, -1);
                }else{
                    newCell = walk(r, c + 1, 1);
                }
                break;
            case e.HOME:
                if (! (g.isEditor && g.editing)) {
                  if (!e.hasModifier()){
                      newCell = [r, 0];
                      //~ console.log('home',newCell);
                      break;
                  }else if(e.ctrlKey){
                      var t = g.getTopToolbar();
                      var activePage = Math.ceil((t.cursor + t.pageSize) / t.pageSize);
                      if (activePage > 1) {
                          e.stopEvent();
                          t.moveFirst();
                          return;
                      }
                      newCell = [0, c];
                      break;
                  }
                }
            case e.END:
                if (! (g.isEditor && g.editing)) {
                  c = g.colModel.getColumnCount()-1;
                  if (!e.hasModifier()) {
                      newCell = [r, c];
                      //~ console.log('end',newCell);
                      break;
                  }else if(e.ctrlKey){
                      var t = g.getTopToolbar();
                      var d = t.getPageData();
                      if (d.activePage < d.pages) {
                          e.stopEvent();
                          var self = this;
                          t.on('change',function(tb,pageData) {
                              var r = g.store.getCount()-2;
                              self.select(r, c);
                              //~ console.log('change',r,c);
                          },this,{single:true});
                          t.moveLast();
                          return;
                      } else {
                          newCell = [g.store.getCount()-1, c];
                          //~ console.log('ctrl-end',newCell);
                          break;
                      }
                  }
                }
            case e.DOWN:
                newCell = walk(r + 1, c, 1);
                break;
            case e.UP:
                newCell = walk(r - 1, c, -1);
                break;
            case e.RIGHT:
                newCell = walk(r, c + 1, 1);
                break;
            case e.LEFT:
                newCell = walk(r, c - 1, -1);
                break;
            case e.F2:
                if (!e.hasModifier()) {
                    if (g.isEditor && !g.editing) {
                        g.startEditing(r, c);
                        e.stopEvent();
                        return;
                    }
                    break;
                }
            case e.INSERT:
                if (!e.hasModifier()) {
                    if (g.ls_insert_handler && !g.editing) {
                        e.stopEvent();
                        Lino.show_insert(g);
                        return;
                    }
                    break;
                }
            case e.DELETE:
                if (!e.hasModifier()) {
                    if (!g.editing) {
                        e.stopEvent();
                        Lino.delete_selected(g);
                        return;
                    }
                    break;
                }
            case e.ENTER:
                e.stopEvent();
                g.onCellDblClick(r,c);
                break;
                
        }
        

        if(newCell){
          e.stopEvent();
          r = newCell[0];
          c = newCell[1];
          this.select(r, c); 
          if(g.isEditor && g.editing){ 
            ae = g.activeEditor;
            if(ae && ae.field.triggerBlur){
                ae.field.triggerBlur();
            }
            g.startEditing(r, c);
          }
        //~ } else if (g.isEditor && !g.editing && e.charCode) {
        //~ // } else if (!e.isSpecialKey() && g.isEditor && !g.editing) {
            //~ g.set_start_value(String.fromCharCode(e.charCode));
            //~ // g.set_start_value(String.fromCharCode(k));
            //~ // g.set_start_value(e.charCode);
            //~ g.startEditing(r, c);
            //~ // e.stopEvent();
            //~ return;
        // } else {
          // console.log('20120513',e,g);
        }
        
    }


//~ };
});

 

function PseudoConsole() {
    this.log = function() {};
};
if (typeof(console) == 'undefined') console = new PseudoConsole();

Lino.notify = function(msg) {
  if (msg == undefined) msg = ''; else console.log(msg);
  //~ Ext.getCmp('konsole').update(msg);
  Lino.status_bar.setStatus({
    text: msg,
    iconCls: 'ok-icon',
    clear: true // auto-clear after a set interval
  });
  //~ Ext.getCmp('konsole').setTitle(msg.replace(/\n/g,'<br/>'));
  //~ Ext.getCmp('konsole').update(msg.replace(/\n/g,'<br/>'));
};
Lino.alert = function(msg) {
  //~ if (msg == undefined) msg = ''; else console.log(msg);
  Ext.MessageBox.alert('Notify',msg);
};


//~ Lino.show_about = function() {
  //~ new Ext.Window({
    //~ width: 400, height: 400,
    //~ title: "About",
    //~ html: '<a href="http://www.extjs.com" target="_blank">ExtJS</a> version ' + Ext.version
  //~ }).show();
//~ };

function obj2str(o) {
  if (typeof o != 'object') return String(o);
  var s = '';
  for (var p in o) {
    s += p + ': ' + obj2str(o[p]) + '\n';
  }
  return s;
}

Lino.on_store_exception = function (store,type,action,options,response,arg) {
  //~ throw response;
  console.log("on_store_exception: store=",store,
    "type=",type,
    "action=",action,
    "options=",options,
    "response=",response,
    "arg=",arg);
  if (arg) { console.log(arg.stack)};
};

//~ Lino.on_submit_success = function(form, action) {
   //~ Lino.notify(action.result.message);
   //~ this.close();
//~ };

Lino.on_submit_failure = function(form, action) {
    //~ Lino.notify();
  // action may be undefined
    switch (action.failureType) {
        case Ext.form.Action.CLIENT_INVALID:
            Ext.Msg.alert('Client-side failure', 'Form fields may not be submitted with invalid values');
            break;
        case Ext.form.Action.CONNECT_FAILURE:
            Ext.Msg.alert('Connection failure', 'Ajax communication failed');
            break;
        case Ext.form.Action.SERVER_INVALID:
            Ext.Msg.alert('Server-side failure', action.result.message);
   }
};



/*
Lino.save_wc_handler = function(ww) {
  return function(event,toolEl,panel,tc) {
    var pos = panel.getPosition();
    var size = panel.getSize();
    wc = ww.get_window_config();
    Ext.applyIf(wc,{ 
      x:pos[0],y:pos[1],height:size.height,width:size.width,
      maximized:panel.maximized});
    Lino.do_action(ww,{url:'/window_configs/'+ww.config.permalink_name,params:wc,method:'POST'});
  }
};

*/

Lino.show_in_own_window_button = function(handler) {
  return {
    qtip: "Show this panel in own window", 
    id: "up",
    handler: function(event,toolEl,panel, tc) {
      //~ console.log('20111206 report_window_button',panel,handler);
      //~ var bp = ww.get_master_params();
      //~ panel.containing_window = ww; // for HtmlBox. see blog/2010/1022
      //~ handler(panel,{base_params:bp});
      //~ handler(panel,{base_params:panel.get_master_params()});
      handler.run(null,{base_params:panel.containing_panel.get_master_params()});
      //~ handler(panel,{master_panel:panel.containing_window.main_item});
    }
  }
}




Lino.delete_selected = function(panel) {
  //~ console.log("Lino.delete_selected",panel);
  var recs1 = panel.get_selected();
  var recs = [];
  for ( var i=0; i < recs1.length; i++ ) { if (! recs1[i].phantom) recs.push(recs1[i]); }
  if (recs.length == 0) {
    Lino.notify("Please select at least one record.");
    return;
  };
  if (recs.length == 1) {
      if (recs[0].disable_delete) {
        Lino.alert(recs[0].disable_delete);
        return;
      }
  };
  //~ console.log(recs);
  Ext.MessageBox.show({
    title: "Confirmation",
    msg: String.format("Delete {0} rows. Are you sure?",String(recs.length)),
    //~ msg: "Delete " + String(recs.length) + " rows. Are you sure?",
    //~ buttons: Ext.MessageBox.YESNOCANCEL,
    buttons: Ext.MessageBox.YESNO,
    fn: function(btn) {
      if (btn == 'yes') {
        for ( var i=0; i < recs.length; i++ ) {
          Lino.do_action(panel,{
              method:'DELETE',
              url:  '/api' + panel.ls_url + '/' + recs[i].id,
              after_success: panel.after_delete.createDelegate(panel)
          })
        }
        //~ caller.after_delete();
      }
      else Lino.notify("Dann eben nicht.");
    }
  });
};

Lino.action_handler = function (panel,on_success,on_confirm) {
  return function (response) {
    //~ console.log(20120608,panel);
    if (panel instanceof Lino.GridPanel) {
        //~ gridmode = false;
        gridmode = true;
        //~ console.log('20120608 yes');
    } else {
        gridmode = false;
        //~ console.log('20120608 no');
    }
    panel.loadMask.hide(); // 20120211
    if (!response.responseText) return ;
    var result = Ext.decode(response.responseText);
    //~ console.log('Lino.action_handler()','result is',result,'on_confirm is',on_confirm);
    
    if (result.eval_js) {
        //~ console.log(20120618,result.eval_js);
        eval(result.eval_js);
    }
    
    if (result.xcallback) {
        //~ var config = {title:"Confirmation"};
        var config = {title:result.xcallback.title};
        //~ config.buttons = Ext.MessageBox.YESNOCANCEL;
        //~ config.buttons = Ext.MessageBox.YESNO;
        config.buttons = result.xcallback.buttons;
        config.msg = result.message;
        config.fn = function(buttonId,text,opt) {
          panel.loadMask.show(); 
          //~ Lino.insert_subst_user(p);
          Ext.Ajax.request({
            method: 'GET',
            url: '/callbacks/'+result.xcallback.id + '/' + buttonId,
            //~ params: {bi: buttonId},
            success: Lino.action_handler(panel,on_success,on_confirm)
          });
          //~ Lino.call_ajax_action(panel,'GET',)
        }
        Ext.MessageBox.show(config);
        return;
    }
    
    if (on_success && result.success) on_success(result);
    
    //~ if (on_confirm && result.confirm_message) {
        //~ var config = {title:"Confirmation"};
        //~ // config.buttons = Ext.MessageBox.YESNOCANCEL;
        //~ config.buttons = Ext.MessageBox.YESNO;
        //~ config.msg = result.confirm_message;
        //~ config.fn = function(buttonId,text,opt) {
          //~ if (buttonId == "yes") {
              //~ on_confirm(panel,undefined,result.step);
          //~ }
        //~ }
        //~ Ext.MessageBox.show(config);
        //~ return;
    //~ }
    //~ if (result.dialog_fn) {
        //~ console.log('20120928 TODO',result.dialog_fn);
    //~ }
    if (result.message) {
        //~ if (result.alert && ! gridmode) {
        if (result.alert) { // 20120628b 
            //~ Ext.MessageBox.alert('Alert',result.alert_msg);
            if (result.alert === true) result.alert = "Alert";
            Ext.MessageBox.alert(result.alert,result.message);
        } else {
            Lino.notify(result.message);
        }
    }
    // 
    if (result.data_record && ! gridmode) {
        //~ not used
        panel.set_status({data_record:result.data_record});
    }
    else if (result.new_status && ! gridmode) {
        //~ not used
        //~ console.log('20120607 new_status');
        panel.set_status(result.new_status);
    }
    else if (result.goto_record_id != undefined && ! gridmode) {
        //~ console.log('20120607 new_status');
        panel.load_record_id(result.goto_record_id);
    }
    else if (result.refresh_all) {
        var cw = panel.get_containing_window();
        //~ console.log("20120123 refresh_all");
        if (cw) {
          cw.main_item.refresh();
        }
        else console.log("20120123 cannot refresh_all",panel);
    } else {
        //~ console.log("20121212 b gonna refresh",panel);
        if (result.refresh) panel.refresh();
    }
    
    if (result.open_url) {
        //~ console.log(20111126,result.open_url);
        //~ if (!result.message)
            //~ Lino.notify('Open new window <a href="'+result.open_url+'" target="_blank">'+result.open_url+'</a>');
        window.open(result.open_url,'foo',"");
        //~ document.location = result.open_url;
    }
  }
};

Lino.do_action = function(caller,action) {
  action.success = function(response) {
    if (caller.loadMask) caller.loadMask.hide();
    //~ console.log('Lino.do_action()',action,'action success',response);
    if (action.after_success) {
        //~ console.log('Lino.do_action() calling after_success');
        action.after_success();
    }
    if (response.responseText) {
      var result = Ext.decode(response.responseText);
      //~ console.log('Lino.do_action()',action.name,'result is',result);
      if (result.message) {
          if (result.alert) {
              //~ Ext.MessageBox.alert('Alert',result.alert_msg);
              Ext.MessageBox.alert('Alert',result.message);
          } else {
              Lino.notify(result.message);
          }
      }
      
      //~ if (result.alert_msg) Ext.MessageBox.alert('Alert',result.alert_msg);
      //~ if (result.message) Lino.notify(result.message);
      if (result.notify_msg) Lino.notify(result.notify_msg);
      if (result.js_code) { 
        //~ console.log('Lino.do_action()',action,'gonna call js_code in',result);
        var jsr = result.js_code(caller);
        //~ console.log('Lino.do_action()',action,'returned from js_code in',result);
        if (action.after_js_code) {
          //~ console.log('Lino.do_action()',action,'gonna call after_js_code');
          action.after_js_code(jsr);
          //~ console.log('Lino.do_action()',action,'returned from after_js_code');
        //~ } else {
          //~ console.log('Lino.do_action()',action,' : after_js_code is false');
        }
      };
    }
  };
  Ext.applyIf(action,{
    waitMsg: "Please wait...",
    failure: Lino.ajax_error_handler(caller),
    params: {}
  });
  //~ action.params.su = Lino.subst_user;
  Lino.insert_subst_user(action.params);
  
  Ext.Ajax.request(action);
};

//~ Lino.gup = function( name )
//~ {
  //~ // Thanks to http://www.netlobo.com/url_query_string_javascript.html
  //~ name = name.replace(/[\[]/,"\\\[").replace(/[\]]/,"\\\]");
  //~ var regexS = "[\\?&]"+name+"=([^&#]*)";
  //~ var regex = new RegExp( regexS );
  //~ var results = regex.exec( window.location.href );
  //~ if( results == null )
    //~ return "";
  //~ else
    //~ return results[1];
//~ };

//~ Lino.refresh_handler = function (ww) {
  //~ return function() { 
      //~ console.log('refresh',ww);
      //~ ww.main_item.doLayout(false,true);
      //~ ww.main_item.syncSize();
  //~ }
//~ };

//~ Lino.tools_close_handler = function (ww) {
  //~ return function() { 
      //~ ww.close();
  //~ }
//~ };
Lino.permalink_handler = function (ww) {
  return function() { 
    //~ console.log(20100923,ww.get_permalink());
    //~ document.location = ww.main_item.get_permalink();
    Lino.load_url(ww.main_item.get_permalink());
    //~ console.log(20120715, ww.main_item.get_permalink());
    //~ document.location = "?permalink=" + ww.get_permalink();
    //~ document.location = "?permalink=" + ww.config.permalink_name +'()';
  }
};
//~ Lino.run_permalink = function() {
  //~ var plink = Lino.gup('permalink');
  //~ if(plink) { eval('Lino.'+plink); }
//~ }

Lino.MainPanel = {
  is_home_page : false,
  setting_param_values : false,
  config_containing_window : function(wincfg) { }
  ,init_containing_window : function(win) { }
  ,is_loading : function() { 
      if (!this.rendered) return true;
      //~ return (Ext.select('.x-loading-msg').elements.length > 0);
      return true; 
    } 
  ,do_when_clean : function(auto_save,todo) { todo() }
  ,get_master_params : function() {
    var p = {}
    p['mt'] = this.content_type; 
    rec = this.get_current_record()
    if (rec) {
      if (rec.phantom) {
          p['mk'] = undefined; 
      }else{
          p['mk'] = rec.id; 
      }
    } else {
      p['mk'] = undefined;
    }
    //~ console.log('get_master_params returns',p,'using record',rec);
    return p;
  }
  ,get_permalink : function() {
    //~ var p = this.main_item.get_base_params() || {};
    var p = Ext.apply({},this.get_base_params());
    delete p.fmt;
    //~ if (p.fmt) delete p.fmt;
    Ext.apply(p,this.get_permalink_params());
    //~ Lino.insert_subst_user(p);
     //~ p.fmt = 'html';
    //~ console.log('get_permalink',p,this.get_permalink_params());
    if (this.is_home_page)
        //~ var url = '';
        var url = '/';
    else 
        var url = this.get_permalink_url();
    if (p.su == null) 
        delete p.su;
    if (Ext.urlEncode(p)) url = url + "?" + Ext.urlEncode(p);
    return url;
  }
  ,get_record_url : function(record_id) {
      var url = '/api' + this.ls_url
      //~ var url = this.containing_window.config.url_data; // ls_url;
      url += '/' + (record_id === undefined ? '-99999' : String(record_id));
      //~ if (record_id !== undefined) url += '/' + String(record_id);
      //~ url += '/' + String(record_id);
      return url;
  }
  ,get_permalink_url : function() {
      return '/api' + this.ls_url;
  }
  ,get_permalink_params : function() {
      //~ return {an:'grid'};
      var p = {};
      if (this.action_name)
          p.an = this.action_name;
      this.add_param_values(p)
      return p;
  }
  ,set_status : function(status) {}
  ,get_status : function() { return {}}
  ,refresh : function() {}
  ,get_base_params : function() { 
    var p = {};
    Lino.insert_subst_user(p);
    return p;
  }
  ,add_params_panel : function (tbar) {
      if (this.params_panel) {
        tbar = tbar.concat([{ scope:this, 
          //~ text: "$_("[parameters]")", // gear
          iconCls: 'x-tbar-parameters',
          tooltip:"Show or hide the table parameters panel",
          enableToggle: true,
          //~ pressed: ! this.params_panel.hidden,
          pressed: ! this.params_panel_hidden,
          toggleHandler: function(btn,state) { 
            //~ if (this.params_panel.isVisible()) 
                //~ this.params_panel.hide();
            //~ else
                //~ this.params_panel.show();
            //~ console.log("20120210 add_params_panel",state,this.params_panel);
            if (state) {
              this.params_panel.show();
              this.params_panel.doLayout();
            } else this.params_panel.hide();
            this.get_containing_window().doLayout();
          }
        }]);
        var t = this;
        var refresh = function() {if (!t.setting_param_values) t.refresh();}
        Ext.each(this.params_panel.fields,function(f) {
          //~ f.on('valid',function() {t.refresh()});
          if (f instanceof Ext.form.Checkbox) {
              f.on('check',refresh);
          } else if (f instanceof Ext.DatePicker) {
              f.on('select',refresh);
          } else if (f instanceof Ext.form.TriggerField) {
              f.on('select',refresh);
              //~ f.on('change',refresh);
              //~ f.on('valid',refresh);
          } else {
              if (! f.on) 
                  console.log("20121010 no method 'on'",f);
              else
                  f.on('change',refresh);
            }
          });
      }
      return tbar;
  }
  ,add_param_values : function (p) {
    if (this.params_panel) {
      /* 
      20120918 add param_values to the request string 
      *only if the params_form is dirty*.
      Otherwise Actor.default_params() would never be used.
      
      20121023 But IntegClients.params_default has non-empty default values. 
      Users must have the possibility to make them empty.
      */
      if (this.params_panel.form.isDirty()) {
        p.pv = this.get_param_values();
      }else{
        if (this.status_param_values) 
          p.pv = Lino.fields2array(
            this.params_panel.fields,this.status_param_values);
      }
      //~ if (!this.params_panel.form.isDirty()) return;
      //~ p.pv = this.get_param_values();
      //~ console.log("20120203 add_param_values added pv",pv,"to",p);
    }
  },
  get_param_values : function() { // similar to get_field_values()
      return Lino.fields2array(this.params_panel.fields);
  },
  set_param_values : function(pv) {
    if (this.params_panel) {
      //~ console.log('20120203 MainPanel.set_param_values', pv);
      this.status_param_values = pv;
      //~ this.params_panel.form.suspendEvents(false);
      this.setting_param_values = true;
      if (pv) { 
          this.params_panel.form.my_loadRecord(pv);
      } else { 
        this.params_panel.form.reset(); 
      }
      this.setting_param_values = false;
      //~ this.params_panel.form.resumeEvents();
    }
  }
};


Lino.ajax_error_handler = function(panel) {
  return function(response,options) {
    console.log('Ajax failure:',response,options);
    if (panel.loadMask) panel.loadMask.hide();
    if (response.responseText) {
      var lines = response.responseText.split('\n');
      if (lines.length > 10) {
          line = lines.splice(5,lines.length-10,"(...)");
      }
      Ext.MessageBox.alert(
        response.statusText,
        lines.join('<br/>')
        //~ response.responseText.replace(/\n/g,'<br/>'))
      )
    } else {
      Ext.MessageBox.alert('Action failed',
        'Lino server did not respond to Ajax request');
    }
  }
}
// Ext.Ajax.on('requestexception',Lino.ajax_error_handler)
 


Ext.QuickTips.init();

/* setting QuickTips dismissDelay to 0 */
// Apply a set of config properties to the singleton
//~ Ext.apply(Ext.QuickTips.getQuickTip(), {
//~ Ext.apply(Ext.ToolTip, {
    //~ dismissDelay: 0
    //~ autoHide: false,
    //~ closable: true,
    //~ maxWidth: 200,
    //~ minWidth: 100,
    //~ showDelay: 50      // Show 50ms after entering target
    //~ ,trackMouse: true
//~ });


//~ Ext.apply(Ext.QuickTip, {
    //~ dismissDelay: 0,
//~ });
  
Lino.quicktip_renderer = function(title,body) {
  return function(c) {
    //~ if (c instanceof Ext.Panel) var t = c.bwrap; else // 20130129
    if (c instanceof Ext.Panel) var t = c.header; else // 20130129
    var t = c.getEl();
    //~ console.log(20130129,t,title,body);
    //~ t.dismissDelay = 0;
    Ext.QuickTips.register({
      target: t,
      //~ cls: 'lino-quicktip-classical',
      dismissDelay: 0,
      //~ autoHide: false,
      showDelay: 50,      // Show 50ms after entering target
      //~ title: title,
      text: body
    });
  }
};


  
Lino.help_text_editor = function() {
  //~ var bp = {
      //~ mk:this.content_type,
      //~ mt:1
    //~ };
    //~ console.log(20120202,bp);
  //~ Lino.lino.ContentTypes.detail({},{base_params:bp});
  //~ Lino.lino.ContentTypes.detail.run(null,{record_id:this.content_type});
  Lino.lino.ContentTypes.detail.run(null,{record_id:this.content_type});
}

// Path to the blank image should point to a valid location on your server
//~ Ext.BLANK_IMAGE_URL = MEDIA_URL + '/extjs/resources/images/default/s.gif'; 


// used as Ext.grid.Column.renderer for id columns in order to hide the special id value -99999
Lino.id_renderer = function(value, metaData, record, rowIndex, colIndex, store) {
  //~ if (record.phantom) return '';
  return value;
}

Lino.raw_renderer = function(value, metaData, record, rowIndex, colIndex, store) {
  return value;
}

Lino.text_renderer = function(value, metaData, record, rowIndex, colIndex, store) {
  //~ return "not implemented"; 
  return value;
}

Lino.NullNumberColumn = Ext.extend(Ext.grid.Column, {
    align : 'right', 
    format : '0,00/i', 
    renderer : function(value, metaData, record, rowIndex, colIndex, store) {
        //~ console.log(20130128,"NullNumberColumn.renderer",value);
        if (value === null) return '';
        return Ext.util.Format.number(value, this.format);
    }
});

//~ Lino.NullNumberColumn = Ext.extend(Ext.grid.NumberColumn, {
    //~ align : 'right', 
    //~ constructor: function(cfg){
        //~ Ext.grid.NumberColumn.superclass.constructor.call(this, cfg);
        //~ var t = this;
        //~ this.renderer = function(value, metaData, record, rowIndex, colIndex, store) {
          //~ console.log(20130128,"NullNumberColumn.renderer",value);
          //~ if (value === null) return '';
          //~ return Ext.util.Format.number(value, t.format);
      //~ };
    //~ }
//~ });




//~ Lino.cell_button_renderer = function(value, metaData, record, rowIndex, colIndex, store) {
  //~ return '<input type="button" onclick="alert(value)" value=" ? ">' ;
//~ }


//~ Lino.default_renderer = function(value, metaData, record, rowIndex, colIndex, store) {
  //~ if (record.phantom) return '';
  //~ return value;
//~ }

Lino.fk_renderer = function(fkname,handlername) {
  //~ console.log('Lino.fk_renderer handler=',handler);
  return function(value, metaData, record, rowIndex, colIndex, store) {
    //~ console.log('Lino.fk_renderer',fkname,rowIndex,colIndex,record,metaData,store);
    //~ if (record.phantom) return '';
    if (value) {
        var s = '<a href="javascript:' ;
        s += handlername + '.run(null,{record_id:\'' + String(record.data[fkname]) + '\'})">';
        s += value + '</a>';
        //~ console.log('Lino.fk_renderer',value,'-->',s);
        return s
    }
    return '';
  }
};

Lino.lfk_renderer = function(panel,fkname) {
  //~ console.log('Lino.fk_renderer handler=',handler);
  var handlername = 'console.log';
  return function(value, metaData, record, rowIndex, colIndex, store) {
    //~ console.log('Lino.fk_renderer',fkname,rowIndex,colIndex,record,metaData,store);
    if (record.phantom) return '';
    if (value) {
        var s = '<a href="javascript:' ;
        s += handlername + '({},{record_id:\'' + String(record.data[fkname]) + '\'})">';
        s += value + '</a>';
        //~ console.log('Lino.fk_renderer',value,'-->',s);
        return s
    }
    return '';
  }
};

//~ Lino.gfk_renderer = function() {
  //~ return function(value, metaData, record, rowIndex, colIndex, store) {
    //~ if (record.phantom) return '';
    //~ console.log('Lino.gfk_renderer',value,colIndex,record,metaData,store);
    //~ return value;
  //~ }
//~ };


Lino.build_buttons = function(panel,actions) {
  //~ console.log("20121006 Lino.build_buttons",actions);
  if (actions) {
    var buttons = Array(actions.length);
    var cmenu = Array(actions.length);
    for (var i=0; i < actions.length; i++) { 
      buttons[i] = new Ext.Toolbar.Button(actions[i]);
      cmenu[i] = actions[i]
      cmenu[i].text = actions[i].menu_item_text;
      if (actions[i].panel_btn_handler) {
          var h = actions[i].panel_btn_handler.createCallback(panel,buttons[i]);
          //~ if (actions[i].must_save) {
          if (actions[i].auto_save == true) {
              buttons[i].on('click',panel.do_when_clean.createDelegate(panel,[true,h]));
          } else if (actions[i].auto_save == null) {
              buttons[i].on('click',panel.do_when_clean.createDelegate(panel,[false,h]));
          } else if (actions[i].auto_save == false) {
              buttons[i].on('click',h);
          } else {
              console.log("20120703 unhandled auto_save value",actions[i])
          }
          cmenu[i].handler = actions[i].panel_btn_handler.createCallback(panel,cmenu[i]);
      }
    }
    return {bbar:buttons, cmenu:new Ext.menu.Menu(cmenu)};
  }
}

Lino.do_when_visible = function(cmp,todo) {
  //~ if (cmp.el && cmp.el.dom) 
  if (cmp.isVisible()) { 
    // 'visible' means 'rendered and not hidden'
    //~ console.log(cmp.title,'-> cmp is visible now');
    todo(); 
  //~ } else {
      //~ cmp.on('resize',todo,cmp,{single:true});
  //~ }
  //~ if (false) { // 20120213
  } else { 
    //~ console.log('Lino.do_when_visible() must defer because not isVisible()',todo,cmp);
    if (cmp.rendered) {
      //~ console.log(cmp,'-> cmp is rendered but not visible: and now?');
      //~ console.log(cmp.title,'-> cmp is rendered but not visible: try again in a moment...');
      //~ var fn = function() {Lino.do_when_visible(cmp,todo)};
      //~ fn.defer(100);
      
      Lino.do_when_visible.defer(50,this,[cmp,todo]);
      //~ Lino.do_when_visible.defer(100,this,[cmp,todo]);
      
    } else {
      //~ console.log(cmp.title,'-> after render');
      cmp.on('afterrender',todo,cmp,{single:true});
    }
  }
  
};    

/*
*/
Lino.do_on_current_record = function(panel,fn,phantom_fn) {
  var rec = panel.get_current_record();
  if (rec == undefined) {
    Lino.notify("There's no selected record.");
    return;
  }
  // 20120307 A VirtualTable with a Detail (lino.Models) has only "phantom" records.
  if (rec.phantom) {
    //~ if (!panel.editable) { console.log("20120312 not editable:",panel)}
    if (phantom_fn) {
      phantom_fn(panel);
    } else {
      Lino.notify("Action not available on phantom record.");
    }
    return;
  }
  return fn(rec);
};






Lino.call_ajax_action = function(panel,method,url,p,actionName,step,on_confirm,on_success) {
  p.an = actionName;
  if (!panel) panel = Lino.viewport;
  Ext.apply(p,panel.get_base_params());
  //~ console.log("20121212 Lino.call_ajax_action",panel);
  panel.loadMask.show(); 
  //~ p.$ext_requests.URL_PARAM_SUBST_USER = Lino.subst_user;
  //~ Lino.insert_subst_user(p);
    
  //~ if (step) p['$ext_requests.URL_PARAM_ACTION_STEP'] = step;
  //~ if (pp) pp(p); // "parameter processor" : first used for read beid card
  Ext.Ajax.request({
    method: method,
    url: url,
    params: p,
    success: Lino.action_handler(panel,on_success,on_confirm)
  });
};

Lino.row_action_handler = function(actionName,hm,pp) {
  var p = {};
  var fn = function(panel,btn,step) {
      if (pp) { p = pp(); if (! p) return; }
      Lino.do_on_current_record(panel,function(rec) {
          //~ console.log(panel);
          //~ 20120723 Lino.call_ajax_action(panel,rec.id,actionName,step,fn);
          Lino.call_ajax_action(panel,hm,panel.get_record_url(rec.id),p,actionName,step,fn);
      });
  };
  return fn;
};

Lino.list_action_handler = function(ls_url,actionName,hm,pp) {
  var p = {};
  var url = '/api' + ls_url
  var fn = function(panel,btn,step) {
      //~ console.log("20121210 Lino.list_action_handler",arguments);
      //~ var url = ADMIN_URL + '/api' + panel.ls_url
      if (pp) { p = pp();  if (! p) return; }
      Lino.call_ajax_action(panel,hm,url,p,actionName,step,fn);
  };
  return fn;
};

Lino.param_action_handler = function(window_action) { // 20121012
  var fn = function(panel,btn,step) {
    Lino.do_on_current_record(panel,function(rec) {
      //~ console.log(panel);
      //~ 20120723 Lino.call_ajax_action(panel,rec.id,actionName,step,fn);
      window_action.run(panel.getId(),{}); 
    });
  };
  return fn;
};


Lino.run_row_action = function(requesting_panel,url,pk,actionName,pp) {
  //~ var panel = action.get_window().main_item;
  url = '/api' + url  + '/' + pk;
  var panel = Ext.getCmp(requesting_panel);
  if (pp) var p = pp(); else var p = {};
  var fn = function(panel,btn,step) {
    //~ 20120723 Lino.call_ajax_action(panel,pk,actionName,step,fn);
    Lino.call_ajax_action(panel,'GET',url,p,actionName,step,fn);
  }
  fn(panel,null,null);
}



Lino.show_detail = function(panel,btn) {
  Lino.do_on_current_record(panel, 
    function(rec) {
      //~ panel.loadMask.show();
      var bp = panel.get_base_params();
      //~ var bp = {};
      panel.add_param_values(bp); // 20120918
      var status = {
        record_id:rec.id,
        base_params:bp
        //~ param_values: pv.$ext_requests.URL_PARAM_PARAM_VALUES
      }
      //~ console.log("20120918 Lino.show_detail",status);
      panel.ls_detail_handler.run(null,status);
      //~ panel.loadMask.hide();
      //~ panel.containing_window.window.hideMask();
      //~ panel.el.unmask();
    },
    Lino.show_insert
  );
};

Lino.show_fk_detail = function(combo,detail_action) {
    //~ console.log("Lino.show_fk_detail",combo,handler);
    pk = combo.getValue();
    if (pk) {
        detail_action.run(null,{record_id: pk})
      } else {
        Lino.notify("Cannot show detail for empty foreign key.");
      }
};

Lino.show_insert = function(panel,btn) {
  var bp = panel.get_base_params();
  //~ console.log('20120125 Lino.show_insert',bp)
  //~ panel.ls_insert_handler.run(null,{record_id:-99999,base_params:bp});
  panel.ls_insert_handler.run(panel.getId(),{record_id:-99999,base_params:bp});
};

Lino.show_insert_duplicate = function(panel,btn) {
  Lino.do_on_current_record(panel,
    function(rec) {
      var newRec = {};
      Ext.apply(newRec,rec);
      newRec.id = -99999;
      panel.ls_insert_handler.run(null,{data_record:rec});
    });
};

//~ Lino.update_row_handler = function(action_name) {
  //~ return function(panel,btn) {
    //~ Lino.notify("Sorry, " + action_name + " is not implemented.");
  //~ }
//~ };




if (Ext.ux.grid !== undefined) {
    Lino.GridFilters = Ext.extend(Ext.ux.grid.GridFilters,{
      encode:true,
      local:false
    });
} else {
    Lino.GridFilters = function() {}; // dummy
    Ext.override(Lino.GridFilters,{
      init : function() {}
    });
};



//~ Lino.ButtonField = Ext.extend(Ext.form.TextField,{
//~ Lino.ButtonField = Ext.extend(Ext.form.Field,{
    //~ editable : false,
    //~ constructor : function(ww,config,params){
      //~ this.containing_window = ww;
      //~ if (params) Ext.apply(config,params);
      //~ Lino.ButtonField.superclass.constructor.call(this, config);
    //~ },
    //~ setButtons : function(buttons){
      //~ console.log('setButtons',buttons);
    //~ },
    //~ onRender : function(ct, position){
        //~ if(!this.el){
            //~ this.panel = new Ext.Container({items:[
              //~ {xtype:'button',text:'upload'},
              //~ {xtype:'button',text:'show'},
              //~ {xtype:'button',text:'edit'}
            //~ ]});
            //~ this.panel.ownerCt = this;
            //~ this.el = this.panel.getEl();

        //~ }
        //~ Lino.ButtonField.superclass.onRender.call(this, ct, position);
    //~ },

  
//~ });

Lino.FieldBoxMixin = {
  before_init : function(config,params) {
    if (params) Ext.apply(config,params);
    var actions = Lino.build_buttons(this,config.ls_bbar_actions);
    if (actions) config.bbar = actions.bbar;
  },
  //~ constructor : function(ww,config,params){
    //~ this.containing_window = ww;
    //~ if (params) Ext.apply(config,params);
    //~ var actions = Lino.build_buttons(this,config.ls_bbar_actions);
    //~ if (actions) config.bbar = actions.bbar;
    //~ Lino.FieldBoxMixin.superclass.constructor.call(this, config);
  //~ },
  do_when_clean : function(auto_save,todo) { todo() },
  //~ format_data : function(html) { return '<div class="htmlText">' + html + '</div>' },
  format_data : function(html) { return html },
  get_base_params : function() {
    // needed for insert action
    var p = Ext.apply({},this.base_params);
    Lino.insert_subst_user(p);
    return p;
  },
  set_base_params : function(p) {
    this.base_params = Ext.apply({},p);
    //~ if (p.param_values) this.set_param_values(p.param_values);  
  },
  clear_base_params : function() {
      this.base_params = {};
      Lino.insert_subst_user(this.base_params);
  },
  set_base_param : function(k,v) {
    this.base_params[k] = v;
  }
};



Lino.HtmlBoxPanel = Ext.extend(Ext.Panel,Lino.PanelMixin);
Lino.HtmlBoxPanel = Ext.extend(Lino.HtmlBoxPanel,Lino.FieldBoxMixin);
Lino.HtmlBoxPanel = Ext.extend(Lino.HtmlBoxPanel,{
  disabled_in_insert_window : true,
  constructor : function(config,params) {
    this.before_init(config,params);
    Lino.HtmlBoxPanel.superclass.constructor.call(this, config);
  },
  //~ constructor : function(ww,config,params){
    //~ this.ww = ww;
    //~ if (params) Ext.apply(config,params);
    //~ var actions = Lino.build_buttons(this,config.ls_bbar_actions);
    //~ if (actions) config.bbar = actions.bbar;
    //~ Lino.FieldBoxMixin.constructor.call(this, ww,config,params);
  //~ },
  //~ constructor : function(ww,config,params){
    //~ this.ww = ww;
    //~ if (params) Ext.apply(config,params);
    //~ var actions = Lino.build_buttons(this,config.ls_bbar_actions);
    //~ if (actions) config.bbar = actions.bbar;
    //~ Lino.FieldBoxMixin.superclass.constructor.call(this, config);
  //~ },
  //~ disable : function() { var tb = this.getBottomToolbar(); if(tb) tb.disable()},
  //~ enable : function() { var tb = this.getBottomToolbar(); if(tb) tb.enable()},
  onRender : function(ct, position){
    Lino.HtmlBoxPanel.superclass.onRender.call(this, ct, position);
    //~ console.log(20111125,this.containing_window);
    if (this.containing_panel) {
      this.containing_panel.on('enable',this.enable,this);
      this.containing_panel.on('disable',this.disable,this);
    }
    this.el.on({
      dragenter:function(event){
        event.browserEvent.dataTransfer.dropEffect = 'move';
        return true;
      }
      ,dragover:function(event){
        event.browserEvent.dataTransfer.dropEffect = 'move';
        event.stopEvent();
        return true;
      }
      ,drop:{
        scope:this
        ,fn:function(event){
          event.stopEvent();
          //~ console.log(20110516);
          var files = event.browserEvent.dataTransfer.files;
          if(files === undefined){
            return true;
          }
          var len = files.length;
          while(--len >= 0){
            console.log(files[len]);
            //~ this.processDragAndDropFileUpload(files[len]);
          }
          Lino.show_insert(this);
        }
      }
    });
  },
  refresh : function(unused) { 
      this.refresh_with_after();
  },
  refresh_with_after : function(after) {
    //~ if (this.master_panel) {
      var record = this.containing_panel.get_current_record();
      //~ console.log('HtmlBox.refresh()',this.title,record,record.title);
      var box = this.items.get(0);
      var todo = function() {
        if (this.disabled) return;
        //~ this.set_base_params(this.containing_window.get_base_params());
        this.set_base_params(this.containing_panel.get_master_params());
        var el = box.getEl();
        if (el) {
          el.update(record ? this.format_data(record.data[this.name]) : '');
          //~ console.log('HtmlBox.refresh()',this.name);
        //~ } else {
          //~ console.log('HtmlBox.refresh() failed for',this.name);
        }
      };
      Lino.do_when_visible(box,todo.createDelegate(this));
    //~ }
  }
});
//~ Ext.override(Lino.HtmlBoxPanel,Lino.FieldBoxMixin);



Lino.RichTextPanel = Ext.extend(Ext.Panel,Lino.PanelMixin);
Lino.RichTextPanel = Ext.extend(Lino.RichTextPanel,Lino.FieldBoxMixin);
Lino.RichTextPanel = Ext.extend(Lino.RichTextPanel,{
    
  //~ initComponent : function(){
    //~ Lino.RichTextPanel.superclass.initComponent.call(this);
  //~ },
  constructor : function(config,params) {
    //~ console.log('Lino.RichTextPanel.initComponent',this);
    //~ var url = TEMPLATES_URL + config.ls_url + "/" + String(rec.id) + "/" + config.name;
    //~ var url = TEMPLATES_URL + config.ls_url + "/" + config.name;
    var t = this;
    var tinymce_options = {
        theme : "advanced",
        content_css: '/media/lino/extjs/lino.css',
        language: 'de',
        //~ template_external_list_url : url,
        theme_advanced_toolbar_location : "top",
        theme_advanced_toolbar_align : "left",
        theme_advanced_statusbar_location : "bottom",
        template_popup_width : 700,
        template_popup_height : 500,
        template_replace_values : { 
            data_field : function(element){ 
                //~ console.log(20110722,fieldName,t.containing_window.get_current_record()); 
                var fieldName = element.innerHTML;
                element.innerHTML = t.containing_panel.get_current_record().data[fieldName];
            } 
        }
      };
      
    var editorConfig = {
      tinymceSettings: {
        plugins : "noneditable,template", 
        // Theme options - button# indicated the row# only
        theme_advanced_buttons1 : "bold,italic,underline,|,justifyleft,justifycenter,justifyright,|,bullist,numlist,|,outdent,indent,|,undo,redo,|,removeformat,template",
        theme_advanced_buttons2 : "",
        theme_advanced_buttons3 : "", // ,|,sub,sup,|,charmap",      
        theme_advanced_resizing : false
        //~ save_onsavecallback : save_callback,
        //~ save_enablewhendirty : true
        //~ save_oncancelcallback: on_cancel
        
    }};
    Ext.apply(editorConfig.tinymceSettings,tinymce_options);
    //~ editorConfig.name = config.action_name;
    editorConfig.name = config.name;
    delete config.name;
    //~ config.title = config.label;
    //~ delete config.label;
    this.before_init(config,params);
    
    this.editor = new Ext.ux.TinyMCE(editorConfig);
    var t = this;
    config.tools = [{
                      qtip: "Edit text in own window", 
                      id: "up",
                      handler: function(){
                        if(t.editor.isDirty()) {
                            var record = t.containing_panel.get_current_record();
                            record.data[t.editor.name] = t.editor.getValue();
                        }
                        Lino.edit_tinymce_text(t,tinymce_options)
                      }
                    }];
    
    config.items = this.editor;
    config.layout = "fit";
    Lino.RichTextPanel.superclass.constructor.call(this, config);
  },
  refresh : function(unused) { 
      this.refresh_with_after();
  },
  refresh_with_after : function(after) {
    var record = this.containing_panel.get_current_record();
    //~ console.log('RichTextPanel.refresh()',this.title,record.title,record);
    var todo = function() {
      //~ this.set_base_params(this.containing_window.get_base_params());
      if (record) {
        var url = '/templates' + this.containing_panel.ls_url + "/" 
            + String(record.id) + "/" + this.editor.name;
        //~ console.log('RichTextPanel.refresh()',url);
        if (this.editor.ed) this.editor.ed.settings.template_external_list_url = url;
        this.set_base_params(this.containing_panel.get_master_params());
        //~ var v = record ? this.format_data(record.data[this.editor.name]) : ''
        var v = this.format_data(record.data[this.editor.name])
        this.editor.setValue(v);
      } else {
        this.editor.setValue('(no data)');
      }
    };
    Lino.do_when_visible(this,todo.createDelegate(this));
  }
});
//~ Ext.override(Lino.RichTextPanel,Lino.FieldBoxMixin);



Lino.ActionFormPanel = Ext.extend(Ext.form.FormPanel,Lino.MainPanel);
Lino.ActionFormPanel = Ext.extend(Lino.ActionFormPanel,Lino.PanelMixin);
Lino.ActionFormPanel = Ext.extend(Lino.ActionFormPanel,Lino.FieldBoxMixin);
Lino.ActionFormPanel = Ext.extend(Lino.ActionFormPanel,{
  //~ layout:'fit'
  //~ ,autoHeight: true
  //~ ,frame: true
  window_title: "Action Parameters",
  constructor : function(config){
    config.bbar = [
        {text:'OK',handler:this.on_ok,scope:this},
        {text:'Cancel',handler:this.on_cancel,scope:this}
    ];
    //~ config.items = config.params_panel;
    Lino.ActionFormPanel.superclass.constructor.call(this, config);
  }
  //~ ,initComponent : function(){
    //~ Lino.ActionFormPanel.superclass.initComponent.call(this);
  //~ }
  ,on_cancel : function() { 
    this.get_containing_window().close();
  }
  ,on_ok : function() { 
    //~ var rp = this.requesting_panel;
    //~ console.log("on_ok",this.requesting_panel,arguments);
    //~ Lino.row_action_handler()
    var panel = this.requesting_panel;
    var actionName = this.action_name;
    var rec = panel.get_current_record();
    var self = this;
    function on_success() { self.get_containing_window().close(); };
    var fn = function(panel,btn,step) {
      var p = {};
      self.add_field_values(p)
      Lino.call_ajax_action(panel,'GET',panel.get_record_url(rec.id),p,actionName,step,fn,on_success);
    }
    fn(panel,null,null);
    
    
  }
  ,set_status : function(status,rp){
    this.requesting_panel = Ext.getCmp(rp);
    //~ console.log('20120918 ActionFormPanel.set_status()',status,rp,this.requesting_panel);
    this.clear_base_params();
    if (status == undefined) status = {};
    //~ if (status.param_values) 
    this.set_field_values(status.field_values);
    if (status.base_params) this.set_base_params(status.base_params);
  }
  
  ,add_field_values : function (p) { // similar to add_param_values()
      //~ 20121023 
      if (this.form.isDirty()) {
        p.fv = this.get_field_values();
      }else{
        if (this.status_field_values) 
          p.fv = Lino.fields2array(this.fields,this.status_field_values);
      }
      //~ if (!this.form.isDirty()) return;
      //~ p.$ext_requests.URL_PARAM_FIELD_VALUES = this.get_field_values();
      //~ console.log("20120203 add_param_values added pv",pv,"to",p);
  }
  ,get_field_values : function() {
      return Lino.fields2array(this.fields);
  }
  ,set_field_values : function(pv) {
      //~ console.log('20120203 MainPanel.set_param_values', pv);
      this.status_field_values = pv;
      if (pv) this.form.my_loadRecord(pv);
      else this.form.reset(); 
  }
  ,config_containing_window : function(wincfg) { 
      wincfg.title = this.window_title;
      wincfg.keys = [
        { key: Ext.EventObject.ENTER, fn: this.on_ok }
      ]
  }
});

Lino.fields2array = function(fields,values) {
    //~ console.log('20120116 gonna loop on', fields);
    var pv = Array(fields.length);
    for(var i=0; i < fields.length;i++) {
        var f = fields[i]
        if (values) 
          var v = values[f.name];
        else 
          var v = f.getValue();
        if (f.formatDate) {
            pv[i] = f.formatDate(v); 
        } else {
            pv[i] = v; // f.getValue(); 
        }
    }
    return pv;
}


Lino.FormPanel = Ext.extend(Ext.form.FormPanel,Lino.MainPanel);
Lino.FormPanel = Ext.extend(Lino.FormPanel,Lino.PanelMixin);
Lino.FormPanel = Ext.extend(Lino.FormPanel,{
  params_panel_hidden : false,
  //~ base_params : {},
  //~ trackResetOnLoad : true,
  //~ query_params : {},
  //~ 20110119b quick_search_text : '',
  constructor : function(config,params){
    if (params) Ext.apply(config,params);
    this.base_params = {};
    //~ ww.config.base_params.query = ''; // 20111018
    //~ console.log(config);
    //~ console.log('FormPanel.constructor() 1',config)
    //~ Ext.applyIf(config,{base_params:{}});
    //~ console.log('FormPanel.constructor() 2',config)
      
    config.trackResetOnLoad = true;
    
    Lino.FormPanel.superclass.constructor.call(this, config);
      
    //~ this.set_base_param('$URL_PARAM_FILTER',null); // 20111018
    //~ this.set_base_param('$URL_PARAM_FILTER',''); // 20111018
      
  },
  initComponent : function(){
    
    //~ console.log("20111201 containing_window",this.containing_window,this);
    
    var actions = Lino.build_buttons(this,this.ls_bbar_actions);
    if (actions) {
        this.bbar = actions.bbar;
    //~ } else {
        //~ this.bbar = [];
    }
    //~ Ext.apply(config,Lino.build_buttons(this,config.ls_bbar_actions));
    //~ config.bbar = Lino.build_buttons(this,config.ls_bbar_actions);
    //~ var config = this;
    
    //~ if (this.containing_window instanceof Lino.DetailWrapper) {
    
    //~ console.log('20120121 initComponent', this.action_name);
    //~ if (this.action_name == 'detail' | this.action_name == 'show') {
    //~ if (this.action_name != 'insert') {
    if (! this.hide_top_toolbar) {
      this.tbar = [];
      // 20111015    
      if (! this.hide_navigator) {
        this.record_selector = new Lino.RemoteComboFieldElement({
          store: new Lino.ComplexRemoteComboStore({
            //~ baseParams: this.containing_window.config.base_params,
            baseParams: this.get_base_params(),
            //~ value: this.containing_window.config.base_params.query,
            proxy: new Ext.data.HttpProxy({
              url: '/choices' + this.ls_url,
              method:'GET'
            })
          }),
          pageSize:25,
          listeners: { 
            scope:this, 
            select:function(combo,record,index) {
              //~ console.log('jumpto_select',arguments);
              this.goto_record_id(record.id);
            }
          },
          emptyText: "Go to record"
        })
        this.tbar = this.tbar.concat([this.record_selector]);
        
        this.tbar = this.tbar.concat([
          this.first = new Ext.Toolbar.Button({
            tooltip:"First",disabled:true,handler:this.moveFirst,scope:this,iconCls:'x-tbar-page-first'}),
          this.prev = new Ext.Toolbar.Button({
            tooltip:"Previous",disabled:true,handler:this.movePrev,scope:this,iconCls:'x-tbar-page-prev'}),
          this.next = new Ext.Toolbar.Button({
            tooltip:"Next",disabled:true,handler:this.moveNext,scope:this,iconCls:'x-tbar-page-next'}),
          this.last = new Ext.Toolbar.Button({
            tooltip:"Last",disabled:true,handler:this.moveLast,scope:this,iconCls:'x-tbar-page-last'})
        ]);
      }
      this.tbar = this.add_params_panel(this.tbar);
      
      //~ console.log(20101117,this.containing_window.refresh);
      this.tbar = this.tbar.concat([
        {
          //~ text:'Refresh',
          handler:function(){ this.do_when_clean(true,this.refresh.createDelegate(this)) },
          iconCls: 'x-tbar-loading',
          tooltip:"Reload current record",
          scope:this}
      ]);
          
      if (this.bbar) { // since 20121016
        if (this.tbar) {
            this.tbar = this.tbar.concat(['-']) ;
        } else {
          this.tbar = [];
        }
        this.tbar = this.tbar.concat(this.bbar) ;
        this.bbar = undefined;
      }
    
      this.tbar = this.tbar.concat([
          '->',
          this.displayItem = new Ext.Toolbar.TextItem({})
      ]);
          
    }
    //~ if (this.content_type && this.action_name != 'insert') {
      //~ this.bbar = this.bbar.concat([
        //~ '->',
        //~ { text: "[$_('Help Text Editor')]",
          //~ handler: Lino.help_text_editor,
          //~ qtip: "$_('Edit help texts for fields on this model.')",
          //~ scope: this}
      //~ ])
    //~ }
    //~ this.before_row_edit = config.before_row_edit.createDelegate(this);
      
    //~ if (this.master_panel) {
        //~ this.set_base_params(this.master_panel.get_master_params());
    //~ }
      
    Lino.FormPanel.superclass.initComponent.call(this);
    
    this.on('render',function(){
      this.loadMask = new Ext.LoadMask(this.bwrap,{msg:"Please wait..."});
    },this);
    
    
    //~ var this_ = this;
    //~ this.cascade(function(cmp){
      //~ // var active_field = false;
      //~ for (i = 0; i < this_.active_fields.length; i++) {
        //~ if (cmp.name == this_.active_fields[i]) {
            //~ // active_field = true; break;
            //~ cmp.on("change",function() {this_.save()});
        //~ }
      //~ };
      //~ if (active_field) {
      // if (cmp instanceof Lino.GridPanel) {
          //~ cmp.on("change",function() {this_.save()});
      //~ }
    //~ });
    
    if (this.action_name == 'insert') {
      this.cascade(function(cmp){
        // console.log('20110613 cascade',cmp);
        if (cmp.disabled_in_insert_window) {
            //~ cmp.disable();
            cmp.hide();
        }
      });
      
    }
    
  },
  
  unused_is_loading : function() { 
    if (this.current_record == null) {
        //~ console.log("20130515 current_record is null");
        return true; 
    }
    
    if (! this.loadMask) return true; // not even rendered: 
    if (! this.loadMask.el) return true; // not even rendered: 
    // thanks to Marco Pegoraro http://movableapp.com/2011/09/sencha-touch-loadmask-isvisible/
    var loading = (this.loadMask.el.select('.x-loading-msg').elements.length > 0);
    //~ console.log('20130515 GridPanel.is_loading() returns',loading);
    return loading;

    
    var loading = false;
    this.cascade(function(cmp){
        if (cmp instanceof Lino.GridPanel && cmp.is_loading()) {
            //~ console.log(20130515, cmp.title,'is loading');
            loading = true;
            return false;
        }
      });
    return loading;
    //~ var a = this.findByType(Lino.GridPanel);
    //~ for (i=0;i<a.length;i++) {
        //~ if (a[i].is_loading()) return true;
    //~ }
    //~ return false;
  },
  
  get_status : function(){
      var st = {
        base_params: this.get_base_params(),
        data_record : this.get_current_record()
        }
      var tp = this.items.get(0);
      if (tp instanceof Ext.TabPanel) {
        st.active_tab = tp.getActiveTab();
      }
      st.param_values = this.status_param_values;
      return st;
  },
  set_status : function(status,rp){
    this.requesting_panel = Ext.getCmp(rp);
    //~ console.log('20120918 FormPanel.set_status()',status);
    this.clear_base_params();
    if (status == undefined) status = {};
    //~ if (status.param_values) 
    this.set_param_values(status.param_values);
    if (status.base_params) this.set_base_params(status.base_params);
    var tp = this.items.get(0);
    if (tp instanceof Ext.TabPanel) {
      if (status.active_tab) {
        //~ console.log('20111201 active_tab',this.active_tab,this.items.get(0));
        //~ tp.activeTab = status.active_tab;
        tp.setActiveTab(status.active_tab);
        //~ this.main_item.items.get(0).activate(status.active_tab);
      } else {
        tp.setActiveTab(0);
      }
      }
    
    if (status.data_record) {
      //~ console.log('20111201 Lino.FormPanel with data_record',this.data_record.title,this.containing_window);
      //~ this.main_item.on_master_changed.defer(2000,this.main_item,[status.data_record]);
      //~ Lino.do_when_visible(this.main_item,function(){this.on_master_changed(status.data_record)});
      //~ this.main_item.on('afterrender',function(){
      //~   this.main_item.on_master_changed(status.data_record)},this,{single:true});
      /* must defer because because set_window_title() didn't work otherwise */
      this.set_current_record.createDelegate(this,[status.data_record]).defer(100);
      //~ this.set_current_record(this.data_record);
      //~ return;
    } else if (status.record_id != undefined) { 
      /* possible values include 0 and null, 0 being a valid record id, 
      null the equivalent of undefined
      */
      //~ this.main_item.goto_record_id(this.status.record_id);
      this.load_record_id(status.record_id);
    } else {
      this.set_current_record(undefined);
    }
  },
    
  get_base_params : function() {
    // needed for insert_action
    var p = Ext.apply({},this.base_params);
    Lino.insert_subst_user(p);
    return p;
    //~ return this.base_params;
  },
  set_base_params : function(p) {
    //~ this.base_params = Ext.apply({},this.base_params); // make sure it is an instance variable
    delete p['query'] // 20120725
    Ext.apply(this.base_params,p);
    if (this.record_selector) {
        var store = this.record_selector.getStore();
        for (k in p) store.setBaseParam(k,p[k]);
        delete this.record_selector.lastQuery;
        //~ console.log("20120725 record_selector.setBaseParam",p)
    }
  },
  clear_base_params : function() {
      this.base_params = {};
      Lino.insert_subst_user(this.base_params);
        
      //~ if (this.record_selector) {
          //~ var store = this.record_selector.getStore();
          //~ for (k in store.baseParams) store.setBaseParam(k,undefined);
          //~ delete this.record_selector.lastQuery;
          //~ console.log("20120725 record_selector.getBaseParams() -->",store.baseParams)
      //~ }
  },
  set_base_param : function(k,v) {
    //~ this.base_params = Ext.apply({},this.base_params); // make sure it is an instance variable
    this.base_params[k] = v;
    //~ if (this.record_selector) {
        //~ this.record_selector.getStore().setBaseParam(k,v);
        //~ delete this.record_selector.lastQuery;
    //~ }
  },
  
  after_delete : function() {
    if (this.current_record.navinfo.next)
      this.moveNext();
    else if (this.current_record.navinfo.prev)
      this.movePrev();
    else 
      this.abandon();
  },
  moveFirst : function() {this.goto_record_id(this.current_record.navinfo.first)},
  movePrev : function() {this.goto_record_id(this.current_record.navinfo.prev)},
  moveNext : function() {this.goto_record_id(this.current_record.navinfo.next)},
  moveLast : function() {this.goto_record_id(this.current_record.navinfo.last)},
  
  
  refresh : function(unused) { 
      this.refresh_with_after();
  },
  refresh_with_after : function(after) { 
    //~ console.log('20120121 Lino.FormPanel.refresh()',this);
    if (this.current_record) {
        this.load_record_id(this.current_record.id,after);
    } else {
        this.set_current_record(undefined,after);
    }
  },
  
  do_when_clean : function(auto_save,todo) {
    var this_ = this;
    if (this.form.isDirty()) {
        if (auto_save) {
            this_.save(todo);
        } else {
          //~ console.log('20111217 do_when_clean() form is dirty',this.form);
          var config = {title:"Confirmation"};
          config.buttons = Ext.MessageBox.YESNOCANCEL;
          config.msg = "Save changes to current record ?";
          config.fn = function(buttonId,text,opt) {
            //~ console.log('do_when_clean',buttonId)
            if (buttonId == "yes") {
                //~ Lino.submit_detail(this_,undefined,todo);
                //~ this_.containing_window.save(todo);
                this_.save(todo);
            } else if (buttonId == "no") { 
              todo();
            }
          }
        }
        Ext.MessageBox.show(config);
    }else{
      //~ console.log('do_when_clean : now!')
      todo();
    }
  },
  
  goto_record_id : function(record_id) {
    //~ console.log('20110701 Lino.FormPanel.goto_record_id()',record_id);
    //~ var this_ = this;
    //~ this.do_when_clean(function() { this_.load_record_id(record_id) }
    this.do_when_clean(true,this.load_record_id.createDelegate(this,[record_id]));
  },
  
  load_record_id : function(record_id,after) {
    var this_ = this;
    //~ var p = { fmt: this.containing_window.config.action_name};
    //~ var p = Ext.apply({},this.containing_window.config.base_params);
    var p = Ext.apply({},this.get_base_params());
    //~ Lino.insert_subst_user(p);
    //~ console.log('20110713 action_name=',this.containing_window.config.action_name,
      //~ 'base_params=',this.containing_window.config.base_params);
    if (this.action_name)
        p.an = this.action_name;
    //~ p.an = this.action_name;
    //~ p.an = this.containing_window.config.action_name;
    //~ p.fmt = 'json';
    //~ p.fmt = '$ext_requests.URL_FORMAT_JSON';
    p.rp = this.getId();
    //~ p.$ext_requests.URL_PARAM_SUBST_USER = Lino.subst_user;
    p.fmt = 'json';
    //~ 20110119b p['$URL_PARAM_FILTER'] = this.quick_search_text;
    //~ Ext.apply(p,this.query_params);
    this.add_param_values(p);
    //~ console.log('20121120 FormPanel.load_record_id',record_id,p);
    if (this.loadMask) this.loadMask.show();
    Ext.Ajax.request({ 
      waitMsg: 'Loading record...',
      method: 'GET',
      params: p,
      scope: this,
      url: this.get_record_url(record_id),
      success: function(response) {   
        // todo: convert to Lino.action_handler.... but result 
        if (this.loadMask) this.loadMask.hide();
        if (response.responseText) {
          var rec = Ext.decode(response.responseText);
          //~ console.log('20120918 goto_record_id success',rec);
          this.set_param_values(rec.param_values);
          this.set_current_record(rec,after);
        }
      },
      failure: Lino.ajax_error_handler(this)
    });
  },

  abandon : function () {
    Ext.MessageBox.alert('Note',
      "No more records to display. Detail window has been closed.");
    Lino.close_window();
    //~ if (this.containing_window) {
        //~ this.containing_window.hide();
    //~ }
  },
  
  set_current_record : function(record,after) {
    //~ console.log('20120722 Lino.FormPanel.set_current_record',record.title,record);
    if (this.record_selector) {
        this.record_selector.clearValue();
        // e.g. InsertWrapper FormPanel doesn't have a record_selector
    }
    this.current_record = record;
    //~ if (record) 
        //~ console.log('Lino.FormPanel.set_current_record',record.title,record);
    //~ else
        //~ console.log('Lino.FormPanel.set_current_record',record);
    //~ this.config.main_panel.form.load(record);    
    if (record) {
      this.enable();
      this.form.my_loadRecord(record.data);
      this.set_window_title(record.title);
      //~ this.getBottomToolbar().enable();
      var da = record.data.disabled_actions;
      if (da) {
          //~ console.log('20120528 disabled_actions =',da,this.getBottomToolbar());
          //~ 20121016 this.getBottomToolbar().items.each(function(item,index,length){
          var tb = this.getTopToolbar();
          if (tb) tb.items.each(function(item,index,length){
              //~ console.log('20120528 ',item.itemId,'-->',da[item.itemId]);
              if (da[item.itemId]) item.disable(); else item.enable();
          });
      };
      if (this.disable_editing | record.data.disable_editing) {
          //~ console.log("20120202 disable_editing",record.title);
          this.form.items.each(function(cmp){
            if (!cmp.always_enabled) cmp.disable();
          },this);
      } else {
          this.form.items.each(function(cmp){
            //~ console.log("20120202",cmp);
            if (record.data.disabled_fields[cmp.name]) cmp.disable();
            else cmp.enable();
          },this);
        
          //~ if (record.data.disabled_fields) {
              //~ for (i = 0; i < record.data.disabled_fields.length; i++) {
                  //~ var flds = this.find('name',record.data.disabled_fields[i]);
                  //~ if (flds.length == 1) { 
                    //~ flds[0].disable(); 
                  //~ }
              //~ }
          //~ }
      };
      
      if (record.navinfo && ! this.hide_top_toolbar && ! this.hide_navigator) {
        //~ if (record.navinfo.recno == 0) {
            //~ this.first.setDisabled(true);
            //~ this.prev.setDisabled(true);
            //~ this.next.setDisabled(true);
            //~ this.last.setDisabled(true);
        //~ } else {
            this.first.setDisabled(!record.navinfo.first);
            this.prev.setDisabled(!record.navinfo.prev);
            this.next.setDisabled(!record.navinfo.next);
            this.last.setDisabled(!record.navinfo.last);
        //~ }
        this.displayItem.setText(record.navinfo.message);
      }
    } else {
      if (this.form.rendered) 
        this.form.reset(); /* FileUploadField would fail when resetting a non-rendered form */
      //~ this.disable();
      //~ this.getBottomToolbar().disable();
      this.form.items.each(function(cmp){
        cmp.disable();
      },this);
      this.set_window_title(this.empty_title);
      //~ this.containing_window.window.setTitle(this.empty_title);
      if (!this.hide_navigator) {
        this.first.disable();
        this.prev.disable();
        this.next.disable();
        this.last.disable();
      }
    }
    //~ console.log('20100531 Lino.DetailMixin.on_load_master_record',this.main_form);
    this.before_row_edit(record);
    if (after) after();
  },
  
  before_row_edit : function(record) {},
  search_change : function(field,oldValue,newValue) {
    //~ console.log('search_change',field.getValue(),oldValue,newValue)
    this.set_base_param('query',field.getValue()); 
    this.refresh();
  },
  
  get_selected : function() { return [ this.current_record ] },
  get_current_record : function() {  
    //~ console.log(20100714,this.current_record);
    return this.current_record 
  },
  
  get_permalink_url : function() {
      var rec = this.get_current_record();
      if (rec && ! rec.phantom && rec.id != -99998)
          return '/api' + this.ls_url + '/' + rec.id;
      return '/api' + this.ls_url;
    
  },
  get_permalink_params : function() {
    var p = {};
    //~ var p = {an:'detail'};
    if (this.action_name)
        p.an = this.action_name;
    //~ var p = {an:this.action_name};
    var main = this.items.get(0);
    if (main.activeTab) {
      var tab = main.items.indexOf(main.activeTab);
      //~ console.log('main.activeTab',tab,main.activeTab);
      if (tab) p.tab = tab;
    }
    this.add_param_values(p)
    return p;
  },
  
  /* 
  Lino.FormPanel.save() 
  */
  save : function(after,switch_to_detail,action_name) {
    //~ var panel = this;
    //~ console.log('20121120 FormPanel.save');
    this.loadMask.show();
    var rec = this.get_current_record();
    if (this.has_file_upload) this.form.fileUpload = true;
    //~ console.log('FormPanel.save()',rec);
    if (!action_name) action_name = this.action_name;
    if (rec) {
      var p = {};
      Ext.apply(p,this.get_base_params());
      p.rp = this.getId();
      //~ if (this.action_name) 
          //~ p.$ext_requests.URL_PARAM_ACTION_NAME = this.action_name;
      p.an = action_name;
      if (rec.phantom) {
        //~ if (this.action_name != 'insert') 
            //~ console.log("Warning: phantom record, but action_name is",this.action_name)
        this.form.submit({
          url: '/api' + this.ls_url,
          method: 'POST',
          params: p, 
          scope: this,
          success: function(form, action) {
            this.loadMask.hide();
            Lino.notify(action.result.message);
            /***
            Close this window, but update the status of the 
            calling window.
            If the calling window is a detail on the same table,
            then it should skip to the new record. But only then.
            A successful response usually has a data_record,
            except if it is a fileupload form where some mysterious 
            decoding problems (20120209) force us to return a record_id 
            which will lead to an additional GET.
            ***/
            var url = this.ls_url;
            var ww = Lino.calling_window();
            if (ww && ww.window.main_item instanceof Lino.FormPanel 
                   && ww.window.main_item.ls_url == this.ls_url) {
                //~ console.log("20120217 case 1");
                ww.status.record_id = action.result.record_id;
                ww.status.data_record = action.result.data_record;
                Lino.close_window();
            } else if (this.ls_detail_handler && switch_to_detail) {
                //~ console.log("20120217 case 2");
                Lino.kill_current_window();
                this.ls_detail_handler.run(null,{
                    record_id:action.result.record_id,
                    data_record: action.result.data_record,
                    base_params:this.get_base_params()
                });
            } else {
                //~ console.log("20120217 case 3");
                Lino.close_window();
            }
            //~ Lino.close_window(function(ww){
                //~ if (ww.window.main_item instanceof Lino.FormPanel 
                    //~ && ww.window.main_item.ls_url == url) {
                  //~ ww.status.record_id = action.result.record_id,
                  //~ ww.status.data_record = action.result.data_record
                //~ }
            //~ });
          },
          failure: function(form,action) { 
            this.loadMask.hide();
            Lino.on_submit_failure(form,action);
          },
          clientValidation: true
        })
      } else {
        //~ if (this.action_name != 'detail') 
            //~ console.log("Warning: non-phantom record, but action_name is",this.action_name)
        this.form.submit({
          url: '/api' + this.ls_url + '/' + rec.id,
          method: 'PUT',
          //~ headers: { 'HTTP_X_REQUESTED_WITH' : 'XMLHttpRequest'},
          scope: this,
          params: p, 
          success: function(form, action) {
            //~ panel.form.setValues(rec.data);
            //~ 20110701 panel.form.my_loadRecord(rec);
            this.loadMask.hide();
            Lino.notify(action.result.message);
            if (action.result.data_record)
                this.set_current_record(action.result.data_record,after);
            else
                console.log("Warning: no data_record in response to FormPanel.PUT")
            //~ this.refresh_with_after(after);
            //~ if (after) after(); else panel.refresh();
          },
          failure: function(form,action) { 
            this.loadMask.hide();
            Lino.on_submit_failure(form,action)},
          clientValidation: true
        })
      }
    } else Lino.notify("Sorry, no current record.");
  }
  
  ,on_cancel : function() { 
    this.get_containing_window().close();
  }
  ,on_ok : function() { 
      this.save(null,true);
      //~ var rec = this.get_current_record();
      //~ if (rec && rec.phantom)
          //~ this.do_when_clean(true,function() { Lino.close_window(); });
  }
  ,config_containing_window : function(wincfg) { 
      wincfg.keys = [
        { key: Ext.EventObject.ENTER, fn: this.on_ok, scope:this }
        ,{ key: Ext.EventObject.ESCAPE, fn: this.on_cancel, scope:this }
      ]
  }
  
  
  /* not used (no longer possible without .dtl files)
  , edit_detail_config : function () {
    var active_tab = {};
    var main = this.items.get(0);
    if (main.getActiveTab !== undefined) {
      var tabitem = main.getActiveTab();
      Ext.apply(active_tab,{$ext_requests.URL_PARAM_TAB : main.items.indexOf(tabitem)});
    }
    var editor = new Ext.form.TextArea();
    var close = function() { win.close(); }
    var _this = this;
    var save = function() { 
      //~ console.log(20110609,arguments); 
      var params = {desc: editor.getValue()};
      Ext.apply(params,active_tab);
      var a = { 
        params: params, 
        method: 'PUT',
        url: ADMIN_URL + '/detail_config' + _this.ls_url,
        failure : Lino.ajax_error_handler(this),
        success: Lino.action_handler( _this, function(result) {
          //~ console.log('detail_config/save success',result);
          win.close();
          document.location = _this.get_permalink();
        })
      };
      //~ console.log('detail_config/save sent',a);
      _this.loadMask.show(); // 20120211
      Ext.Ajax.request(a);
    }
    var save_btn = new Ext.Button({text:'Save',handler:save,disabled:true});
    var win = new Ext.Window({title:'Detail Layout',
      items:editor, layout:'fit',
      width:500,height:500,
      bbar:[{text:'Cancel',handler:close},save_btn]});
    var a = { 
      params:active_tab, 
      method:'GET',
      url:ADMIN_URL+'/detail_config'+_this.ls_url,
      success : function(response) {
        if (response.responseText) {
          var result = Ext.decode(response.responseText);
          if (result.success) {
            editor.setValue(result.desc);
            save_btn.enable();
          }
        }
      }
    };
    Ext.Ajax.request(a);
    win.show();
  }
  */
});


Lino.getRowClass = function(record, rowIndex, rowParams, store) {
  if (record.phantom) {
    //~ console.log(20101009,record);
    //~ rowParams.bodyStyle = "color:red;background-color:blue";
    return 'lino-phantom-row';
    }
  //~ console.log('20101009 not a phantom:',record);
  return '';
}

//~ FOO = 0;



Lino.GridStore = Ext.extend(Ext.data.ArrayStore,{ 
  autoLoad: false
  ,load: function(options) {
    //~ foo.bar = baz; // 20120213
    if (!options) options = {};
    if (!options.params) options.params = {};
    options.params.fmt = 'json';
    options.params.rp = this.grid_panel.getId();
    Lino.insert_subst_user(options.params); // since 20121016
      
    if (this.grid_panel.hide_top_toolbar) {
        //~ console.log("20120206 GridStore.load() toolbar is hidden");
        options.params.start = 0;
        if (this.grid_panel.preview_limit) {
          options.params.limit = this.grid_panel.preview_limit;
        }
    } else {
        var ps = this.grid_panel.calculatePageSize();
        if (!ps) {
            //~ this.gridpanel.on('render',this.load())
          //~ console.log("20120814 GridStore.load() failed to calculate pagesize");
          return false;
            //~ params.$URL_PARAM_LIMIT = 1;
            //~ this.grid_panel.on('render',this.load.createDelegate(this,options))
            //~ return;
        } 
        options.params.limit = ps;
      
        //~ options.params.start = this.grid_panel.getTopToolbar().cursor;
        //~ if (this.grid_panel.getTopToolbar().pageSize !=  ps) {
          //~ console.log("20120206 abort load because toolbar says pagesize",
            //~ this.grid_panel.getTopToolbar().pageSize,
            //~ "while actual pagesize is",ps);
            //~ return;
        //~ }
        
        this.grid_panel.getTopToolbar().pageSize =  ps;
        if (options.params.start == undefined)
            options.params.start = this.grid_panel.getTopToolbar().cursor;
      
    }
      
    this.grid_panel.add_param_values(options.params);
    //~ Lino.insert_subst_user(options.params);
    //~ console.log("20120814 GridStore.load()",options.params,this.baseParams);
    //~ if (FOO > 0) {
        //~ foo.bar = baz;
    //~ } else FOO += 1;
    return Lino.GridStore.superclass.load.call(this,options);
  }
});

    
Lino.GridPanel = Ext.extend(Ext.grid.EditorGridPanel,Lino.MainPanel);
Lino.GridPanel = Ext.extend(Lino.GridPanel,Lino.PanelMixin);
Lino.GridPanel = Ext.extend(Lino.GridPanel,{
  quick_search_text : '',
  is_searching : false,
  disabled_in_insert_window : true,
  clicksToEdit:2,
  enableColLock: false,
  autoHeight: false,
  params_panel_hidden : false,
  preview_limit : undefined, 
  //~ loadMask: true,
  //~ viewConfig: {
          //~ getRowClass: Lino.getRowClass,
          //~ emptyText:"$_('No data to display.')"
        //~ },
  loadMask: {msg:"Please wait..."},
  
  constructor : function(config){

    config.plugins = [new Lino.GridFilters()];
    
    
    Lino.GridPanel.superclass.constructor.call(this,config);
    
    //~ if (this.containing_window) {
        //~ console.log("20111206 install refresh");
        //~ this.containing_window.on('show',this.refresh,this);
    //~ }
    
  },
  
  unused_is_loading : function() { 
    if (! this.loadMask.el) return true; // not even rendered: 
    // thanks to Marco Pegoraro http://movableapp.com/2011/09/sencha-touch-loadmask-isvisible/
    var loading = (this.loadMask.el.select('.x-loading-msg').elements.length > 0);
    //~ console.log('20130515 GridPanel.is_loading() returns',loading);
    return loading;
    //~ return this.store.getCount() > 0; 
    //~ return (this.loadMask.el.select('.x-loading-msg').elements.length)
    //~ return !this.viewReady; 
    //~ return this.loadMask.isVisible(); 
    //~ return !this.loadMask.disabled; 
  },
  
  unused_config_containing_window : function(wincfg) { 
      //~ temporarily remove save_grid_config button (see /blog(2012/1107)
      if (wincfg.tools != undefined) 
        wincfg.tools = [
          //~ {handler:this.save_grid_data,
            //~ qtip:"$_("Save Grid Data")",
            //~ scope:this, id:"save_data"}, // 20120814
          {handler:this.save_grid_config,
            qtip:"Save Grid Configuration",
            scope:this, id:"save"}
        ].concat(wincfg.tools);
      //~ wincfg.listeners = { show: ... };
  },
  init_containing_window : function(win) { 
    //~ console.log("20111206 install refresh");
    //~ win.on('show',this.refresh,this);
  },
  
  initComponent : function(){
    
    /* 
    Problem 20111206:
    When a GridPanel is the main item of the window, then it doesn't 
    have it's own header but uses the window's header bar.
    We must do this in initComponent because e.g. in beforerender 
    it's already to late: a header element has been created because 
    there was a title.
    But Lino.Window adds itself as `this.containing_window` 
    only after the GridPanel has been initialized.
    Workaround is to generate a line "params.containing_window = true;" 
    in the handler function.
    */ 
    //~ if (this.containing_window) {
    if (this.is_main_window) {
        //~ console.log(20111206, 'delete title',this.title,'from',this);
        //~ delete this.title;
        this.tools = undefined;  
        this.title = undefined;  /* simply deleting it 
          isn't enough because that would only 
          unhide the title defined in some base class. */
    } 
    //~ else console.log(20111206, 'dont delete title',this.title,'from',this);
    
    /* e.g. when slave gridwindow called from a permalink */
    //~ if (this.base_params) Ext.apply(bp,this.base_params);  
    //~ bp['fmt'] = 'json';
    
    //~ function on_proxy_write( proxy, action,data, response,rs,options) {
      //~ console.log('20120814 on_proxy_write',action,data,response)
      //~ this.getStore().doUpdate();
      //~ this.getStore().loadData(data);
    //~ }
    //~ function on_proxy_load( proxy, transactionObject, callbackOptions ) {
      //~ console.log('on_proxy_load',transactionObject)
    //~ }
    var proxy = new Ext.data.HttpProxy({ 
      // 20120814 
      url: '/api' + this.ls_url
      ,method: "GET"
      //~ ,url: ADMIN_URL + '/restful' + this.ls_url
      //~ ,restful: true 
      //~ ,listeners: {load:on_proxy_load} 
      //~ ,listeners: {write:on_proxy_write} 
    });
    //~ config.store = new Ext.data.JsonStore({ 
    //~ this.store = new Ext.data.ArrayStore({ 
    this.store = new Lino.GridStore({ 
      grid_panel: this
      ,listeners: { exception: Lino.on_store_exception }
      ,remoteSort: true
      ,totalProperty: "count"
      ,root: "rows"
      //~ ,id: "id" 
      ,proxy: proxy
      //~ autoLoad: this.containing_window ? true : false
      ,idIndex: this.pk_index
      //~ ,baseParams: bp
      ,fields: this.ls_store_fields
      ,idProperty: this.ls_id_property 
      // 20120814
      //~ ,writer : new Ext.data.JsonWriter({
        //~ writeAllFields: false
        //~ ,listful: true
      //~ })
      //~ ,restful : true
    });
      
    //~ console.log('config.pk_index',config.pk_index,config.store),
    delete this.ls_store_fields;
      
    var this_ = this;
    //~ var grid = this;
    this.store.on('load', function() {
        //~ console.log('20120814 GridStore.on(load)',this_.store);
        //~ var da = this_.store.reader.arrayData.disabled_actions;
        //~ if (da) {
            //~ this.cmenu.cascade(function(item){ 
              //~ console.log(20120531, item.itemId, da[item.itemId]);
              //~ if (da[item.itemId]) item.disable(); else item.enable();
            //~ });
        //~ };
        this_.set_param_values(this_.store.reader.arrayData.param_values);
        //~ this_.set_status(this_.store.reader.arrayData.status);
        //~ 20120918
        if (this_.store.reader.arrayData.no_data_text) {
            //~ this.viewConfig.emptyText = this_.store.reader.arrayData.no_data_text;
            this.getView().emptyText = this_.store.reader.arrayData.no_data_text;
            this.getView().refresh();
        }
        if (this_.containing_window)
            this_.set_window_title(this_.store.reader.arrayData.title);
            //~ this_.containing_window.setTitle(this_.store.reader.arrayData.title);
        if (!this.is_searching) { // disabled 20121025: quick_search_field may not lose focus
          this.is_searching = false;
          if (this_.selModel.getSelectedCell){
              if (this_.getStore().getCount()) // there may be no data
                  this_.selModel.select(0,0); 
          } else {
              this_.selModel.selectFirstRow();
              this_.getView().focusEl.focus();
          }
        } 
        //~ else console.log("is_searching -> no focussing");
        //~ var t = this.getTopToolbar();
        //~ var activePage = Math.ceil((t.cursor + t.pageSize) / t.pageSize);
        //~ this.quick_search_field.focus(); // 20121024
      }, this
    );
    var actions = Lino.build_buttons(this,this.ls_bbar_actions);
    //~ Ext.apply(config,Lino.build_buttons(this,config.ls_bbar_actions));
    //~ config.bbar, this.cmenu = Lino.build_buttons(this,config.ls_bbar_actions);
    //~ this.cmenu = new Ext.menu.Menu({items: config.bbar});
    delete this.ls_bbar_actions
    if (actions) {
        this.cmenu = actions.cmenu;
    }
    
    if (!this.hide_top_toolbar) {  
      var tbar = [ 
        this.quick_search_field = new Ext.form.TextField({ 
          //~ fieldLabel: "Search"
          listeners: { 
            scope:this_
            //~ ,change:this_.search_change
            
            ,render: Lino.quicktip_renderer("Quick Search","Enter a text to use as quick search filter")
            
            //~ ,keypress: this.search_keypress 
            ,blur: function() { this.is_searching = false}
          }
          ,validator:function(value) { return this_.search_validate(value) }
          //~ ,tooltip: "Enter a quick search text, then press TAB"
          //~ value: text
          //~ scope:this, 
          //~ ,enableKeyEvents: true
          //~ listeners: { keypress: this.search_keypress }, 
          //~ id: "seachString" 
      })];
      tbar = this.add_params_panel(tbar);
      tbar = tbar.concat([
        { scope:this, 
          //~ text: "[csv]", 
          tooltip: "Export this table to a .csv file", 
          iconCls: 'x-tbar-csv',
          handler: function() { 
            //~ 20130116 var p = Ext.apply({},this.get_base_params());
            //~ 20130116 p.fmt = 'csv';
            //~ url += "?" + Ext.urlEncode(p);
            var p = this.get_current_grid_config();
            Ext.apply(p,this.get_base_params());
            p.fmt = "csv";
            this.add_param_values(p);
            
            window.open('/api'+this.ls_url + "?" + Ext.urlEncode(p)) 
          } },
        //~ { scope:this, 
          //~ text: "[html]", 
          //~ handler: function() { 
            //~ var p = this.get_current_grid_config();
            //~ Ext.apply(p,this.get_base_params());
            //~ p.$ext_requests.URL_PARAM_FORMAT = "$ext_requests.URL_FORMAT_PRINTER";
            //~ this.add_param_values(p);
            //~ window.open(ADMIN_URL+'/api'+this.ls_url + "?" + Ext.urlEncode(p)) 
          //~ } },
        { scope:this, 
          //~ text: "[html]", 
          tooltip: "Show this table in plain html", 
          iconCls: 'x-tbar-html',
          handler: function() { 
            var p = this.get_current_grid_config();
            Ext.apply(p,this.get_base_params());
            //~ since 20121226 p.$ext_requests.URL_PARAM_FORMAT = "$ext_requests.URL_FORMAT_PLAIN";
            this.add_param_values(p);
            //~ since 20121226 window.open(ADMIN_URL+'/api'+this.ls_url + "?" + Ext.urlEncode(p)) 
            window.open('/plain'+this.ls_url + "?" + Ext.urlEncode(p)) 
          } },
        { scope:this, 
          //~ text: "[pdf]", 
          tooltip: "Show this table as a pdf document", 
          iconCls: 'x-tbar-pdf',
          handler: function() { 
            var p = this.get_current_grid_config();
            Ext.apply(p,this.get_base_params());
            p.fmt = "pdf";
            this.add_param_values(p);
            window.open('/api'+this.ls_url + "?" + Ext.urlEncode(p)) 
          } }
      ]);
    
    
      var menu = [];
      var set_gc = function(index) {
        return function() {
          //~ console.log('set_gc() 20100812');
          this.getColumnModel().setConfig(
              this.apply_grid_config(index,this.ls_grid_configs,this.ls_columns));
        }
      }
      for (var i = 0; i < this.ls_grid_configs.length;i++) {
        var gc = this.ls_grid_configs[i];
        menu.push({text:gc.label,handler:set_gc(i),scope:this})
      }
      if(menu.length > 1) {
        tbar = tbar.concat([
          { text:"View",
            menu: menu,
            tooltip:"Select another view of this report"
          }
        ]);
      }
      
      if (actions) {
        tbar = tbar.concat(actions.bbar);
          //~ this.bbar = actions.bbar;
      }
      
      this.tbar = new Ext.PagingToolbar({ 
        store: this.store, 
        prependButtons: true, 
        //~ pageSize: this.page_length, 
        pageSize: 1, 
        displayInfo: true, 
        beforePageText: "Page",
        afterPageText: "of {0}",
        displayMsg: "Displaying {0} - {1} of {2}",
        firstText: "Première page",
        lastText: "Dernière page",
        prevText: "Page précédente",
        nextText: "Page suivante",
        items: tbar
      });
      //~ this.on('resize', function(cmp,aw,ah,rw,rh) {
          //~ var ps = this.calculatePageSize();
          //~ if (ps && ps != this.getTopToolbar().pageSize) {
              //~ // console.log('20120203 resize : pageSize',this.getTopToolbar().pageSize,'->',ps);
              //~ // this.getTopToolbar().pageSize =  ps;
              //~ cmp.refresh();
              //~ // this.getTopToolbar().doRefresh();
          //~ }
        //~ }, this);
      //~ this.on('resize', function(cmp,aw,ah,rw,rh) {
          //~ cmp.getTopToolbar().pageSize = this.calculatePageSize(aw,ah,rw,rh) || 10;
          //~ cmp.refresh();
        //~ }, this, {delay:500});
    }
    
    //~ delete this.page_length
    
    
      
    if (this.ls_quick_edit) {
      this.selModel = new Ext.grid.CellSelectionModel()
      this.get_selected = function() {
        //~ console.log(this.getSelectionModel().selection);
        if (this.selModel.selection)
            return [ this.selModel.selection.record ];
        return [this.store.getAt(0)];
      };
      this.get_current_record = function() { 
        if (this.getSelectionModel().selection) 
          return this.selModel.selection.record;
        return this.store.getAt(0);
      };
    } else { 
      this.selModel = new Ext.grid.RowSelectionModel() 
      this.get_selected = function() {
        var sels = this.selModel.getSelections();
        if (sels.length == 0) sels = [this.store.getAt(0)];
        return sels
        //~ var sels = this.getSelectionModel().getSelections();
        //~ return Ext.pluck(sels,'id');
      };
      this.get_current_record = function() { 
        var rec = this.selModel.getSelected();
        if (rec == undefined) rec = this.store.getAt(0);
        return rec
      };
    };
    delete this.ls_quick_edit;
    
    this.columns  = this.apply_grid_config(this.gc_name,this.ls_grid_configs,this.ls_columns);
    
    //~ var grid = this;
    //~ this.colModel = new Ext.grid.ColumnModel({
      //~ columns: this.apply_grid_config(this.gc_name,this.ls_grid_configs,this.ls_columns),
      //~ isCellEditable: function(col, row) {
        //~ var record = grid.store.getAt(row);
        //~ console.log('20120514',col,record); // dataIndex
        //~ var dataIndex = grid.colModel.getDataIndex(col);
        //~ if (dataIndex in record.data['disabled_fields']) {
            //~ Lino.notify("$_("This field is disabled")");
            //~ return false;
        //~ }
        //~ return Ext.grid.ColumnModel.prototype.isCellEditable.call(this, col, row);
      //~ }
    //~ });    
    
    
    Lino.GridPanel.superclass.initComponent.call(this);
    
    //~ if (this.containing_window) 
        //~ this.on('afterlayout', this.refresh, this);
        //~ this.on('afterrender', this.refresh,this);
    //~ else
        //~ this.on('show', this.refresh,this);
    //~ this.on('afterlayout', function() {
      //~ if (this.id == "ext-comp-1157") 
        //~ console.log("20120213 afterlayout",this); 
      //~ // this.refresh();
      //~ },this);
    //~ this.on('afterrender', this.refresh);
    //~ this.on('resize', this.refresh,this,{delay:500});
    //~ this.on('resize', function(){console.log("20120213 resize",arguments)},this);
    this.on('resize', function(){
      //~ console.log("20120213 resize",arguments)
      this.refresh();
      },this);
    this.on('viewready', function(){
      //~ console.log("20120213 resize",arguments);
      this.view_is_ready = true;
      this.refresh();
      },this);
    this.on('afteredit', this.on_afteredit); // 20120814
    //~ this.on('afteredit', this.new_on_afteredit);
    this.on('beforeedit', this.on_beforeedit);
    this.on('beforeedit',function(e) { this.before_row_edit(e.record)},this);
    this.on('cellcontextmenu', Lino.cell_context_menu, this);
    //~ this.on('contextmenu', Lino.grid_context_menu, this);
    
    
    //~ if (this.id == "ext-comp-1157") captureEvents(this);    
    
  },
  
  //~ onResize : function(){
      //~ console.log("20120206 GridPanel.onResize",arguments);
      //~ Lino.GridPanel.superclass.onResize.apply(this, arguments);
      //~ this.refresh();
  //~ },
  
  
  get_status : function(){
    var st = { base_params : this.get_base_params()};
    if (!this.hide_top_toolbar) {
        st.current_page = this.getTopToolbar().current;
    }
    st.param_values = this.status_param_values;
    //~ console.log("20120213 GridPanel.get_status",st);
    return st;
  },
  
  /* 
  Lino.GridPanel.set_status() 
  */
  set_status : function(status){
    //~ console.log("20120918 GridPanel.set_status",status);
    this.clear_base_params();
    if (status == undefined) status = {};
    this.set_param_values(status.param_values);
    if (status.base_params) { 
      this.set_base_params(status.base_params);
    }
    if (!this.hide_top_toolbar) {
      //~ console.log("20120213 GridPanel.getTopToolbar().changePage",
          //~ status.current_page || 1);
      this.getTopToolbar().changePage(status.current_page || 1);
    }
    //~ this.fireEvent('resize');
    //~ this.refresh.defer(100,this); 
    //~ this.onResize.defer(100,this); 
    //~ this.refresh(); 
    //~ this.doLayout(); 
    //~ this.onResize(); 
    //~ this.store.load();
  },
  
  refresh : function(unused) { 
    this.refresh_with_after();
  },
  refresh_with_after : function(after) { 
    //~ Lino.notify('20120204 Lino.GridPanel.refresh');
    //~ Lino.notify('Lino.GridPanel.refresh '+this.store.proxy.url);
    //~ var bp = { fmt:'json' }
    if (this.containing_panel) {
        //~ Ext.apply(p,this.master_panel.get_master_params());
        //~ Ext.apply(options.params,this.containing_panel.get_master_params());
        this.set_base_params(this.containing_panel.get_master_params());
    }
    
    if (! this.view_is_ready) return;
    
    var options = {};
    if (after) {
        options.callback = function(r,options,success) {if(success) after()}
    }
      
    //~ if (!this.rendered) {
        //~ console.log("20120206 GridPanel.refresh() must wait until rendered",options);
        //~ this.grid_panel.on('render',this.load.createDelegate(this,options))
        //~ return;
    //~ }
    
    this.store.load(options);
  },
  
  /* pageSize depends on grid height (Trying to remove scrollbar)
  Thanks to 
  - Christophe Badoit on http://www.sencha.com/forum/showthread.php?82647
  - http://www.sencha.com/forum/archive/index.php/t-37231.html
  */
  calculatePageSize : function(second_attempt) {
    //~ if (!this.rendered) { 
    if (!this.view_is_ready) { 
      //~ console.log('Cannot calculatePageSize() : not rendered');
      return false; }
    //~ if (!this.isVisible()) { 
      //~ console.log('calculatePageSize : not visible');
      //~ return false; }
      
    //~ console.log('getFrameHeight() is',this.getFrameHeight());
    //~ console.log('getView().scroller.getHeight() is',this.getView().scroller.getHeight());
    //~ console.log('mainBody.getHeight() is',this.getView().mainBody.getHeight());
    //~ console.log('getInnerHeight() is',this.getInnerHeight());
    //~ console.log('getHeight() is',this.getHeight());
    //~ console.log('el.getHeight() is',this.getEl().getHeight());
    //~ console.log('getGridEl().getHeight() is',this.getGridEl().getHeight());
    //~ console.log('getOuterSize().height is',this.getOuterSize().height);
    //~ console.log('getBox().height is',this.getBox().height);
    //~ console.log('getResizeEl.getHeight() is',this.getResizeEl().getHeight());
    //~ console.log('getLayoutTarget().getHeight() is',this.getLayoutTarget().getHeight());
      
    var rowHeight = this.getFrameHeight();
    //~ var rowHeight = 52; // experimental value
    var row = this.view.getRow(0);
    if (row) {
      //~ console.log('20120213 yes');
      rowHeight = Ext.get(row).getHeight();
    }
    //~ console.log('rowHeight is ',rowHeight,this,caller);
    //~ this.getView().syncScroll();
    //~ this.getView().initTemplates();
    var height = this.getView().scroller.getHeight();
    //~ console.log('getView().scroller.getHeight() is',this.getView().scroller.getHeight());
    //~ console.log('getInnerHeight() - getFrameHeight() is',
      //~ this.getInnerHeight(), '-',
      //~ this.getFrameHeight(), '=',
      //~ this.getInnerHeight() - this.getFrameHeight());
    //~ var height = this.getView().mainBody.getHeight();
    //~ var height = this.getView().mainWrap.getHeight();
    //~ var height = this.getView().resizeMarker.getHeight();
    //~ this.syncSize();
    //~ var height = this.getInnerHeight() - this.getFrameHeight();
    //~ var height = this.getHeight() - this.getFrameHeight();
    height -= Ext.getScrollBarWidth(); // leave room for a possible horizontal scrollbar... 
    //~ height -= this.getView().scrollOffset;
    var ps = Math.floor(height / rowHeight);
    //~ console.log('20120203 calculatePageSize():',height,'/',rowHeight,'->',ps);
    ps -= 1; // leave room for a possible phantom row
    //~ return (ps > 1 ? ps : false);
    if (ps > 1) return ps;
    //~ console.log('calculatePageSize() found less than 1 row:',height,'/',rowHeight,'->',ps);
    //~ foo.bar = baz; // 20120213
    return 5; // preview_limit
    //~ if (second_attempt) {
        //~ console.log('calculatePageSize() abandons after second attempt:',
          //~ height,'/',rowHeight,'->',ps);
      //~ return 5;
    //~ }
    //~ return this.calculatePageSize.defer(500,this,[true]);
  },
  
  onCellDblClick : function(grid, row, col){
      //~ console.log("20120307 onCellDblClick",this,grid, row, col);
      if (this.ls_detail_handler) {
          //~ Lino.notify('show detail');
          Lino.show_detail(this);
          return false;
      }else{
        //~ console.log('startEditing');
        this.startEditing(row,col);
      }
  },
  
  get_base_params : function() {
    //~ return this.containing_window.config.base_params;
    //~ console.log(20120717,this.store.baseParams);
    var p = Ext.apply({},this.store.baseParams);
    Lino.insert_subst_user(p);
    //~ console.log("20120717 GRidPanel.get_base_params() returns",p);
    return p;
    //~ return this.store.baseParams;
  },
  set_base_params : function(p) {
    //~ console.log('GridPanel.set_base_params',p)
    for (k in p) this.store.setBaseParam(k,p[k]);
    //~ this.store.baseParams = p;
    if (p.query) 
        this.quick_search_field.setValue(p.query);
    //~ if (p.param_values) 
        //~ this.set_param_values(p.param_values);  
  },
  clear_base_params : function() {
      this.store.baseParams = {};
      Lino.insert_subst_user(this.store.baseParams);
  },
  set_base_param : function(k,v) {
    this.store.setBaseParam(k,v);
  },
  
  //~ get_permalink_params : function() {
    //~ var p = {};
    //~ return p;
  //~ },
  
  before_row_edit : function(record) {},
    
  //~ search_keypress : function(){
    //~ console.log("2012124 search_keypress",arguments);
  //~ },
  search_validate : function(value) {
    if (value == this.quick_search_text) return true;
    this.is_searching = true;
    //~ console.log('search_validate',value)
    this.quick_search_text = value;
    this.set_base_param('query',value); 
    //~ this.getTopToolbar().changePage(1);
    this.getTopToolbar().moveFirst();
    //~ this.refresh();
    return true;
  },
  
  search_change : function(field,oldValue,newValue) {
    //~ console.log('search_change',field.getValue(),oldValue,newValue)
    this.set_base_param('query',field.getValue()); 
    this.getTopToolbar().moveFirst();
    //~ this.refresh();
  },
  
  apply_grid_config : function(index,grid_configs,rpt_columns) {
    //~ var rpt_columns = this.ls_columns;
    var gc = grid_configs[index];    
    //~ console.log('apply_grid_config() 20100812',name,gc);
    this.gc_name = index;
    if (gc == undefined) {
      return rpt_columns;
      //~ config.columns = config.ls_columns;
      //~ return;
    } 
    //~ delete config.ls_filters
    
    //~ console.log(20100805,config.ls_columns);
    var columns = Array(gc.columns.length);
    for (var j = 0; j < rpt_columns.length;j++) {
      var col = rpt_columns[j];
      for (var i = 0; i < gc.columns.length; i++) {
        if (col.dataIndex == gc.ci[i]) {
          col.width = gc.cw[i];
          col.hidden = gc.ch[i];
          columns[i] = col;
          break;
        }
      }
    }
    
    //~ var columns = Array(rpt_columns.length);
    //~ for (var i = 0; i < rpt_columns.length; i++) {
      //~ columns[i] = rpt_columns[gc.columns[i]];
      //~ columns[i].width = gc.widths[i];
    //~ }
    
    //~ if (gc.hidden_cols) {
      //~ for (var i = 0; i < gc.hidden_cols.length; i++) {
        //~ var hc = gc.hidden_cols[i];
        //~ for (var j = 0; j < columns.length;j++) {
          //~ var col = columns[j];
          //~ if (col.dataIndex == hc) {
            //~ col.hidden = true;
            //~ break
          //~ }
        //~ }
      //~ }
    //~ }
    if (gc.filters) {
      //~ console.log(20100811,'config.ls_filters',config.ls_filters);
      //~ console.log(20100811,'config.ls_grid_config.filters',config.ls_grid_config.filters);
      for (var i = 0; i < gc.filters.length; i++) {
        var fv = gc.filters[i];
        for (var j = 0; j < columns.length;j++) {
          var col = columns[j];
          if (col.dataIndex == fv.field) {
            //~ console.log(20100811, f,' == ',fv);
            if (fv.type == 'string') {
              col.filter.value = fv.value;
              //~ if (fv.comparison !== undefined) f.comparison = fv.comparison;
            } else {
              //~ console.log(20100811, fv);
              col.filter.value = {};
              col.filter.value[fv.comparison] = fv.value;
            }
            break;
          }
        };
      }
    }
    
    return columns;
    //~ config.columns = cols;
    //~ delete config.ls_columns
  },
  
  get_current_grid_config : function () {
    var cm = this.getColumnModel();
    var widths = Array(cm.config.length);
    var hiddens = Array(cm.config.length);
    //~ var hiddens = Array(cm.config.length);
    var columns = Array(cm.config.length);
    //~ var columns = Array(cm.config.length);
    //~ var hidden_cols = [];
    //~ var filters = this.filters.getFilterValues();
    var p = this.filters.buildQuery(this.filters.getFilterData())
    for (var i = 0; i < cm.config.length; i++) {
      var col = cm.config[i];
      columns[i] = col.dataIndex;
      //~ hiddens[i] = col.hidden;
      widths[i] = col.width;
      hiddens[i] = col.hidden;
      //~ if (col.hidden) hidden_cols.push(col.dataIndex);
    }
    //~ p['hidden_cols'] = hidden_cols;
    p.cw = widths;
    p.ch = hiddens;
    p.ci = columns;
    //~ p['widths'] = widths;
    //~ p['hiddens'] = hiddens;
    //~ p['columns'] = columns;
    p['name'] = this.gc_name;
    //~ var gc = this.ls_grid_configs[this.gc_name];
    //~ if (gc !== undefined) 
        //~ p['label'] = gc.label
    //~ console.log('20100810 save_grid_config',p);
    return p;
  },
  
  unused_manage_grid_configs : function() {
    var data = [];
    for (k in this.ls_grid_configs) {
      var v = this.ls_grid_configs[k];
      var i = [k,String(v.columns),String(v.hidden_cols),String(v.filters)];
      data.push(i)
    }
    if (this.ls_grid_configs[this.gc_name] == undefined) {
      var v = this.get_current_grid_config();
      var i = [k,String(v.columns),String(v.hidden_cols),String(v.filters)];
      data.push(i);
    }
    //~ console.log(20100811, data);
    var main = new Ext.grid.GridPanel({
      store: new Ext.data.ArrayStore({
        idIndex:0,
        fields:['name','columns','hidden_cols','filters'],
        autoDestroy:true,
        data: data}),
      //~ autoHeight:true,
      selModel: new Ext.grid.RowSelectionModel(),
      listeners: { 
        rowdblclick: function(grid,rowIndex,e) {
          console.log('row doubleclicked',grid, rowIndex,e);
        },
        rowclick: function(grid,rowIndex,e) {
          console.log('row clicked',grid, rowIndex,e);
        }
      },
      columns: [ 
        {dataIndex:'name',header:'Name'}, 
        {dataIndex:'columns',header:'columns'}, 
        {dataIndex:'hidden_cols',header:'hidden columns'}, 
        {dataIndex:'filters',header:'filters'} 
      ]
    });
    var win = new Ext.Window({title:'GridConfigs Manager',layout:'fit',items:main,height:200});
    win.show();
  },
  
  unused_edit_grid_config : function(name) {
    gc = this.ls_grid_configs[name];
    var win = new Ext.Window({
      title:'Edit Grid Config',layout:'vbox', 
      //~ layoutConfig:'stretch'
      items:[
        {xtype:'text', value: gc.name},
        {xtype:'text', value: gc.columns},
        {xtype:'text', value: gc.hidden_cols},
        {xtype:'text', value: gc.filters}
      ]
    });
    win.show();
  },
  
  save_grid_config : function () {
    //~ console.log('TODO: save_grid_config',this);
    //~ p.column_widths = Ext.pluck(this.colModel.columns,'width');
    var a = { 
      params:this.get_current_grid_config(), 
      method:'PUT',
      url:'/grid_config' + this.ls_url,
      success: Lino.action_handler(this),
      scope: this,
      failure: Lino.ajax_error_handler(this)
    };
    this.loadMask.show(); // 20120211
    Ext.Ajax.request(a);
    //~ Lino.do_action(this,a);
  },
  
  on_beforeedit : function(e) {
    //~ console.log('20130128 GridPanel.on_beforeedit()',e,e.record.data.disable_editing);
    if(this.disable_editing | e.record.data.disable_editing) {
      e.cancel = true;
      Lino.notify("This record is disabled");
      return;
    }
    if(e.record.data.disabled_fields && e.record.data.disabled_fields[e.field]) {
      e.cancel = true;
      Lino.notify("This field is disabled");
      return;
    }
    //~ if (e.record.data.disabled_fields) {
      //~ for (i in e.record.data.disabled_fields) {
        //~ if(e.record.data.disabled_fields[i] == e.field) {
          //~ e.cancel = true;
          //~ Lino.notify(String.format('Field "{0}" is disabled for this record',e.field));
          //~ return
        //~ }
      //~ }
    //~ }
  },
  save_grid_data : function() {
      //~ console.log("20120814 save_grid_data");
      this.getStore().commitChanges();
  },
  new_on_afteredit : function(e) {
      //~ this.getStore().commitChanges();
      //~ this.getStore().doUpdate();
      //~ this.getStore().loadData(data);
      console.log("20120814 new_on_afteredit",e);
  },
  on_afteredit : function(e) {
    /*
    e.grid - The grid that fired the event
    e.record - The record being edited
    e.field - The field name being edited
    e.value - The value being set
    e.originalValue - The original value for the field, before the edit.
    e.row - The grid row index
    e.column - The grid column index
    */
    var p = {};
    //~ console.log('20101130 modified: ',e.record.modified);
    //~ console.log('20101130 value: ',e.value);
    //~ var p = e.record.getChanges();
    //~ console.log('20101130 getChanges: ',e.record.getChanges());
    //~ this.before_row_edit(e.record);
    for(k in e.record.getChanges()) {
        var v = e.record.get(k);
    //~ for(k in e.record.modified) {
        //~ console.log('20101130',k,'=',v);
        //~ var cm = e.grid.getColumnModel();
        //~ var di = cm.getDataIndex(k);
        var f = e.record.fields.get(k);
        //~ console.log('20101130 f = ',f);
        //~ var v = e.record.get(di);
        if (f.type.type == 'date') {
            p[k] = Ext.util.Format.date(v, f.dateFormat);
        }else{
            p[k] = v;
            var v = e.record.get(k+'Hidden');
            if (v !== undefined) {
              p[k+'Hidden'] = v;
            }
        }
        //~ var i = cm.findColumnIndex(k);
        //~ var r = cm.getRenderer(i);
        //~ var editor = cm.getCellEditor(i,e.row);
        //~ var col = e.grid.getColumnModel().getColumnById(k);
        //~ console.log('20101130 r = ',r(v));
        //~ var f = e.record.fields[k];
        //~ console.log('20101130 f = ',f);
        //~ console.log('20101130 editor = ',editor);
        //~ p[k] = f.getValue();
        //~ p[k] = r(v);
    }
    //~ console.log('20101130 p:',p);
    //~ var cm = e.grid.getColumnModel();
    //~ var di = cm.getDataIndex(e.column);
    //~ var f = e.record.fields.get(di);
    //~ console.log('20101130 f = ',f);
    //~ if (f.type.type == 'date') e.record.set(di,Ext.util.Format.date(e.value, f.dateFormat));
    
    
    //~ var p = e.record.data;
    
    // var p = {};
    //~ p['grid_afteredit_colname'] = e.field;
    //~ p[e.field] = e.value;
    //~ console.log('20100723 GridPanel.on_afteredit()',e);
    // add value used by ForeignKeyStoreField CHOICES_HIDDEN_SUFFIX
    // not sure whether this is still needed:
    p[e.field+'Hidden'] = e.value;
    //~ p.su = Lino.subst_user;
    Lino.insert_subst_user(p);
    // this one is needed so that this field can serve as choice context:
    e.record.data[e.field+'Hidden'] = e.value;
    // p[pk] = e.record.data[pk];
    // console.log("grid_afteredit:",e.field,'=',e.value);
    Ext.apply(p,this.get_base_params()); // needed for POST, ignored for PUT
    //~ Ext.apply(p,this.containing_window.config.base_params);
    //~ 20121109 p['$ext_requests.URL_PARAM_ACTION_NAME'] = 'grid';
    var self = this;
    var req = {
        params:p,
        waitMsg: 'Saving your data...',
        success: Lino.action_handler( this, function(result) {
          //~ if (result.data_record) {
          if (result.refresh_all) {
              var cw = self.get_containing_window();
              if (cw) {
                  cw.main_item.refresh();
              }
              else console.log("20120123 cannot refresh_all",self);
          } else if (result.rows) {
              //~ self.getStore().loadData(result,true);
              var r = self.getStore().reader.readRecords(result);
              if (e.record.phantom) {
                  //~ console.log("20120816 afteredit.success POST",r);
                  self.getStore().insert(e.row,r.records);
              }else{
                  //~ console.log("20120816 afteredit.success PUT",r);
                  self.getStore().doUpdate(r.records[0]);
              }
              self.getStore().rejectChanges(); /* 
              get rid of the red triangles without saving the record again
              */
              //~ self.getStore().commitChanges(); // get rid of the red triangles
          } else {
              self.getStore().commitChanges(); // get rid of the red triangles
              self.getStore().reload();        // reload our datastore.
          }
          }),
        scope: this,
        failure: Lino.ajax_error_handler(this)
    };
    if (e.record.phantom) {
      req.params.an = 'post'; // SubmitInsert.action_name
      Ext.apply(req,{
        method: 'POST',
        url: '/api' + this.ls_url
      });
    } else {
      req.params.an = 'put'; // SubmitDetail.action_name
      Ext.apply(req,{
        method: 'PUT',
        url: '/api' + this.ls_url + '/' + e.record.id
      });
    }
    //~ console.log('20110406 on_afteredit',req);
    this.loadMask.show(); // 20120211
    Ext.Ajax.request(req);
  },

  afterRender : function() {
    Lino.GridPanel.superclass.afterRender.call(this);
    // this.getView().mainBody.focus();
    // console.log(20100114,this.getView().getRows());
    // if (this.getView().getRows().length > 0) {
    //  this.getView().focusRow(1);
    // }
    //~ this.my_load_mask = new Ext.LoadMask(this.getEl(), {
        //~ msg:'$_("Please wait...")',
        //~ store:this.store});
      
    var tbar = this.getTopToolbar();
    // tbar.on('change',function() {this.getView().focusRow(1);},this);
    // tbar.on('change',function() {this.getSelectionModel().selectFirstRow();this.getView().mainBody.focus();},this);
    // tbar.on('change',function() {this.getView().mainBody.focus();},this);
    // tbar.on('change',function() {this.getView().focusRow(1);},this);
    this.nav = new Ext.KeyNav(this.getEl(),{
      pageUp: function() {tbar.movePrevious(); },
      pageDown: function() {tbar.moveNext(); },
      home: function() {tbar.moveFirst(); },
      end: function() {tbar.moveLast(); },
      scope: this
    });
  },
  after_delete : function() {
    //~ console.log('Lino.GridPanel.after_delete');
    this.refresh();
  },
  add_row_listener : function(fn,scope) {
    this.getSelectionModel().addListener('rowselect',fn,scope);
  },
  postEditValue : function(value, originalValue, r, field){
    value = Lino.GridPanel.superclass.postEditValue.call(this,value,originalValue,r,field);
    //~ console.log('GridPanel.postEdit()',value, originalValue, r, field);
    return value;
  },
  
  set_start_value : function(v) {
      this.start_value = v;
  },
  preEditValue : function(r, field){
      if (this.start_value) {
        var v = this.start_value;
        delete this.start_value;
        this.activeEditor.selectOnFocus = false;
        return v;
      }
      var value = r.data[field];
      return this.autoEncode && Ext.isString(value) ? Ext.util.Format.htmlDecode(value) : value;
  },
  
  on_master_changed : function() {
    //~ if (! this.enabled) return;
    //~ cmp = this;
    //~ console.log('Lino.GridPanel.on_master_changed()',this.title);
    if (! this.rendered) return; // 20120213
    var todo = function() {
      if (this.disabled) return;
      //~ if (this.disabled) return;
      //~ if (this.enabled) {
          //~ var src = caller.config.url_data + "/" + record.id + ".jpg"
          //~ console.log(20111125, this.containing_window);
          //~ for (k in p) this.getStore().setBaseParam(k,p[k]);
          //~ console.log('Lino.GridPanel.on_master_changed()',this.title,p);
          this.refresh();
          //~ this.set_base_params(this.master_panel.get_master_params());
          //~ this.getStore().load(); 
      //~ }
    };
    Lino.do_when_visible(this,todo.createDelegate(this));
  }
});
  

//~ Lino.MainPanelMixin = {
  //~ tbar_items : function() {
      //~ return ;
  //~ }
//~ };

//~ Ext.override(Lino.GridPanel,Lino.MainPanelMixin);
//~ Ext.override(Lino.FormPanel,Lino.MainPanelMixin);

//~ Lino.grid_context_menu = function(e) {
  //~ console.log('contextmenu',arguments);
//~ }

Lino.cell_context_menu = function(grid,row,col,e) {
  //~ console.log('20120531 cellcontextmenu',grid,row,col,e,grid.store.reader.arrayData.rows[row]);
  e.stopEvent();
  //~ grid.getView().focusCell(row,col);
  grid.getSelectionModel().select(row,col);
  //~ console.log(grid.store.getAt(row));
  //~ grid.getView().focusRow(row);
  //~ return;
  if(!grid.cmenu.el){grid.cmenu.render(); }
  //~ if(e.record.data.disabled_fields) {
  
  var da = grid.store.reader.arrayData.rows[row][grid.disabled_actions_index];
  if (da) {
      this.cmenu.cascade(function(item){ 
        //~ console.log(20120531, item.itemId, da[item.itemId]);
        if (da[item.itemId]) item.disable(); else item.enable();
      });
  };
  
  var xy = e.getXY();
  xy[1] -= grid.cmenu.el.getHeight();
  grid.cmenu.showAt(xy);
}


//~ Lino.load_main_menu = function() {
  //~ Ext.Ajax.request({
    //~ waitMsg: 'Loading main menu...',
    //~ method: 'GET',
    //~ url: '/menu',
    //~ success: Lino.on_load_menu,
    //~ failure: Lino.ajax_error_handler
  //~ });
//~ };



//~ Lino.SlavePlugin = function(caller) {
  //~ this.caller = caller;
//~ };

Lino.chooser_handler = function(combo,name) {
  return function(cmp,newValue,oldValue) {
    //~ console.log('Lino.chooser_handler()',cmp,oldValue,newValue);
    combo.setContextValue(name,newValue);
  }
};



Lino.ComboBox = Ext.extend(Ext.form.ComboBox,{
  forceSelection: true,
  triggerAction: 'all',
  minListWidth:230,
  autoSelect: false,
  selectOnFocus: true, // select any existing text in the field immediately on focus.
  submitValue: true,
  displayField: 'text', // 'text', 
  valueField: 'value', // 'value',
  
  //~ initComponent : Ext.form.ComboBox.prototype.initComponent.createSequence(function() {
  initComponent : function(){
      this.contextParams = {};
      //~ Ext.form.ComboBox.initComponent(this);
      Lino.ComboBox.superclass.initComponent.call(this);
  },
  setValue : function(v,record_data){
      /*
      Based on feature request developed in http://extjs.net/forum/showthread.php?t=75751
      */
      /* `record_data` is used to get the text corresponding to this value */
      //~ if(this.name == 'city') 
      //~ console.log('20120203', this.name,'.setValue(', v ,') this=', this,'record_data=',record_data);
      var text = v;
      if(this.valueField){
        if(v == null || v == '') { 
            //~ if (this.name == 'birth_country') 
                //~ console.log(this.name,'.setValue',v,'no lookup needed, value is empty');
            //~ v = undefined;
            v = '';
            //~ text = '';
        } else if (Ext.isDefined(record_data)) {
          text = record_data[this.name];
          //~ if (this.name == 'birth_country') 
            //~ console.log(this.name,'.setValue',v,'got text ',text,' from record ',record);
        } else {
          // if(this.mode == 'remote' && !Ext.isDefined(this.store.totalLength)){
          if(this.mode == 'remote' && ( this.lastQuery === null || (!Ext.isDefined(this.store.totalLength)))){
              //~ if (this.name == 'birth_country') console.log(this.name,'.setValue',v,'store not yet loaded');
              this.store.on('load', this.setValue.createDelegate(this, arguments), null, {single: true});
              if(this.store.lastOptions === null || this.lastQuery === null){
                  var params;
                  if(this.valueParam){
                      params = {};
                      params[this.valueParam] = v;
                  }else{
                      var q = this.allQuery;
                      this.lastQuery = q;
                      this.store.setBaseParam(this.queryParam, q);
                      params = this.getParams(q);
                  }
                  //~ if (this.name == 'birth_country') 
                    //~ console.log(this.name,'.setValue',v,' : call load() with params ',params);
                  this.store.load({params: params});
              //~ }else{
                  //~ if (this.name == 'birth_country') 
                    //~ console.log(this.name,'.setValue',v,' : but store is loading',this.store.lastOptions);
              }
              return;
          //~ }else{
              //~ if (this.name == 'birth_country') 
                //~ console.log(this.name,'.setValue',v,' : store is loaded, lastQuery is "',this.lastQuery,'"');
          }
          var r = this.findRecord(this.valueField, v);
          if(r){
              text = r.data[this.displayField];
          }else if(this.valueNotFoundText !== undefined){
              text = this.valueNotFoundText;
          }
        }
      }
      this.lastSelectionText = text;
      //~ this.lastSelectionText = v;
      if(this.hiddenField){
          //~ this.hiddenField.originalValue = v;
          this.hiddenField.value = v;
      }
      Ext.form.ComboBox.superclass.setValue.call(this, text);
      this.value = v; // needed for grid.afteredit
  },
  
  getParams : function(q){
    // p = Ext.form.ComboBox.superclass.getParams.call(this, q);
    // causes "Ext.form.ComboBox.superclass.getParams is undefined"
    var p = {};
    //p[this.queryParam] = q;
    if(this.pageSize){
        //~ p.start = 0;
        //~ p.limit = this.pageSize;
        p['start'] = 0;
        p['limit'] = this.pageSize;
    }
    // now my code:
    if(this.contextParams) Ext.apply(p,this.contextParams);
    //~ if(this.contextParams && this.contextValues) {
      //~ for(i = 0; i <= this.contextParams.length; i++)
        //~ p[this.contextParams[i]] = this.contextValues[i];
    //~ }
    return p;
  },
  setContextValue : function(name,value) {
    //~ console.log('setContextValue',this,this.name,':',name,'=',value);
    //~ if (this.contextValues === undefined) {
        //~ this.contextValues = Array(); // this.contextParams.length);
    //~ }
    if (this.contextParams[name] != value) {
      //~ console.log('setContextValue 1',this.contextParams);
      this.contextParams[name] = value;
      this.lastQuery = null;
      //~ console.log('setContextValue 2',this.contextParams);
    }
  }
});

Lino.ChoicesFieldElement = Ext.extend(Lino.ComboBox,{
  mode: 'local'
});


Lino.SimpleRemoteComboStore = Ext.extend(Ext.data.JsonStore,{
  forceSelection: true,
  constructor: function(config){
      Lino.SimpleRemoteComboStore.superclass.constructor.call(this, Ext.apply(config, {
          totalProperty: 'count',
          root: 'rows',
          id: 'value', // ext_requests.CHOICES_VALUE_FIELD
          fields: ['value' ], // ext_requests.CHOICES_VALUE_FIELD, // ext_requests.CHOICES_TEXT_FIELD
          listeners: { exception: Lino.on_store_exception }
      }));
  }
});

Lino.ComplexRemoteComboStore = Ext.extend(Ext.data.JsonStore,{
  constructor: function(config){
      Lino.ComplexRemoteComboStore.superclass.constructor.call(this, Ext.apply(config, {
          totalProperty: 'count',
          root: 'rows',
          id: 'value', // ext_requests.CHOICES_VALUE_FIELD
          fields: ['value','text'], // ext_requests.CHOICES_VALUE_FIELD, // ext_requests.CHOICES_TEXT_FIELD
          listeners: { exception: Lino.on_store_exception }
      }));
  }
});

Lino.RemoteComboFieldElement = Ext.extend(Lino.ComboBox,{
  mode: 'remote',
  //~ forceSelection:false,
  minChars: 2, // default 4 is too much
  queryDelay: 300, // default 500 is maybe slow
  queryParam: 'query', 
  //~ typeAhead: true,
  //~ selectOnFocus: true, // select any existing text in the field immediately on focus.
  resizable: true
});

/*
Thanks to Animal for posting the basic idea:
http://www.sencha.com/forum/showthread.php?15842-2.0-SOLVED-Combobox-twintrigger-clear&p=76130&viewfull=1#post76130

*/
Lino.TwinCombo = Ext.extend(Lino.RemoteComboFieldElement,{
    trigger2Class : 'x-form-search-trigger',
    //~ trigger2Class : 'x-tbar-detail',
    initComponent : function() {
        //~ Lino.TwinCombo.superclass.initComponent.call(this);
        Lino.ComboBox.prototype.initComponent.call(this);
        Ext.form.TwinTriggerField.prototype.initComponent.call(this);
    },
    onTrigger2Click : function() {
        //~ console.log('onTrigger2Click',this,arguments);
    }
  });
//~ Lino.TwinCombo.prototype.initComponent = Ext.form.TwinTriggerField.prototype.initComponent;
Lino.TwinCombo.prototype.getTrigger = Ext.form.TwinTriggerField.prototype.getTrigger;
Lino.TwinCombo.prototype.getOuterSize = Ext.form.TwinTriggerField.prototype.getOuterSize;
Lino.TwinCombo.prototype.initTrigger = Ext.form.TwinTriggerField.prototype.initTrigger;
Lino.TwinCombo.prototype.onTrigger1Click = Ext.form.ComboBox.prototype.onTriggerClick;
//~ Lino.TwinCombo.prototype.onTrigger2Click = function() {
    //~ console.log('onTrigger2Click',arguments);
//~ };



Lino.SimpleRemoteComboFieldElement = Ext.extend(Lino.RemoteComboFieldElement,{
  displayField: 'value', 
  valueField: null,
  forceSelection: false
});




Lino.Window = Ext.extend(Ext.Window,{
  //~ layout: "fit", 
  closeAction : 'hide',
  renderTo: 'main_area', 
  constrain: true,
  maximized: true,
  draggable: false,
  width: 700,
  height: 500,
  maximizable: false,
  constructor : function (config) {
    if (config.main_item.params_panel) {
        config.layout = 'border';
        config.main_item.region = 'center';
        config.main_item.params_panel.region = 'north';
        config.main_item.params_panel.hidden = config.main_item.params_panel_hidden;
        config.items = [config.main_item.params_panel, config.main_item];
    } else {
        config.layout = 'fit';
        config.items = config.main_item;
    }
    this.main_item = config.main_item; 
    
    delete config.main_item;
    //~ delete config.params_item;
    
    //~ this.main_item = config.items.get(0);
    this.main_item.containing_window = this;
    
    //~ console.log('20120110 Lino.Window.constructor() 1');
    //~ if (Lino.current_window) { // all windows except the top are closable
    if (this.main_item.hide_window_title) { 
      config.closable = false;
      config.frame = false;
      config.shadow = false;
      //~ config.border = true;
      //~ config.title = undefined;
      //~ config.tools = null;
      delete config.title;
      delete config.tools;
    } else {
      config.title = this.main_item.empty_title;
      config.closable = true;
      config.tools = [ 
        { qtip: 'permalink', handler: Lino.permalink_handler(this), id: "pin" }
      ];
      if (this.main_item.content_type && this.main_item.action_name != 'insert') {
        config.tools = [ {
          handler: Lino.help_text_editor,
          qtip: "Edit help texts for fields on this model.",
          scope: this.main_item,
          id: "gear"
        }].concat(config.tools);
      }
        
    //~ { qtip: '', handler: Lino.save_wc_handler(this), id: "save" }, 
    //~ { qtip: this.config.qtip, handler: Lino.save_wc_handler(this), id: "save" }, 
    //~ { qtip: 'Call doLayout() on main Container.', handler: Lino.refresh_handler(this), id: "refresh" },
    //~ if (this.main_item.params_panel) {
        //~ config.tools = config.tools.concat([ 
          //~ { qtip: 'Show/hide parameter panel', handler: this.toggle_params_panel, id: "gear", scope:this } 
        //~ ]);
    //~ }
    //~ if (config.closable !== false) {
      // if undefined, will take default behaviour
      //~ config.tools = config.tools.concat([ 
        //~ { qtip: 'close', handler: this.hide, id: "close", scope:this } 
      //~ ]);
    }
    
    this.main_item.config_containing_window(config);
    
    //~ console.log('20120110 Lino.Window.constructor() 2');
    Lino.Window.superclass.constructor.call(this,config);
    
    //~ console.log('20120110 Lino.Window.constructor() 3');
    
  },
  initComponent : function() {
    this.main_item.init_containing_window(this);
    Lino.Window.superclass.initComponent.call(this);
  
  },
  hide : function() { 
      this.main_item.do_when_clean(false,function() { 
        Lino.close_window(); });
  },
  hide_really : function() { 
    Lino.Window.superclass.hide.call(this);
  },
  onRender : function(ct, position){
    //~ console.log('20120110 Lino.Window.onRender() 1');
    Lino.Window.superclass.onRender.call(this, ct, position);
    var main_area = Ext.getCmp('main_area')
    //~ console.log('20120110 Lino.Window.onRender() 2');
  
    this.on('show', function(win) {
        //~ console.log('20120110 Lino.Window.on show 1');
        main_area.on('resize', win.onWindowResize, win);
    });
    this.on('hide', function(win) {
        main_area.un('resize', win.onWindowResize, win);
    });
    //~ console.log('20120110 Lino.Window.onRender() 3');
  }
});


Lino.unused_ParamWindow = Ext.extend(Lino.Window,{
  //~ layout: "border", 
  constructor : function (config) {
    Lino.ParamWindow.superclass.constructor.call(this,config);
    this.main_item = config.items; // `items` must be a single component
    config.layout = 'border';
    this.main_item.region = 'center';
    config.params.region = 'north';
    config.items = [config.params, config.items];
    //~ delete config.params;
  }
});




(function(){
    var ns = Ext.ns('Ext.ux.plugins');

    /**
     * @class Ext.ux.plugins.DefaultButton
     * @extends Object
     *
     * Plugin for Button that will click() the button if the user presses ENTER while
     * a component in the button's form has focus.
     *
     * @author Stephen Friedrich
     * @date 09-DEC-2009
     * @version 0.1
     *
     */
    ns.DefaultButton =  Ext.extend(Object, {
        init: function(button) {
            button.on('afterRender', setupKeyListener, button);
        }
    });

    function setupKeyListener() {
        var formPanel = this.findParentByType('form');
        new Ext.KeyMap(formPanel.el, {
            key: Ext.EventObject.ENTER,
            shift: false,
            alt: false,
            fn: function(keyCode, e){
                if(e.target.type === 'textarea' && !e.ctrlKey) {
                    return true;
                }

                this.el.select('button').item(0).dom.click();
                return false;
            },
            scope: this
        });
    }

    Ext.ComponentMgr.registerPlugin('defaultButton', ns.DefaultButton);

})(); 

Ext.override(Ext.form.BasicForm,{
    my_loadRecord : function(values){
    //~ loadRecord : function(record){
        /* Same as ExtJS's loadRecord() (setValues()), except that we 
        forward also the record to field.setValue() so that Lino.Combobox 
        can use it. 
        */
        //~ console.log('20120918 my_loadRecord',values)
        if(Ext.isArray(values)){ 
            for(var i = 0, len = values.length; i < len; i++){
                var v = values[i];
                var f = this.findField(v.id);
                if(f){
                    f.setValue(v.value,values);
                    if(this.trackResetOnLoad){
                        f.originalValue = f.getValue();
                    }
                }
            }
        }else{ 
            var field, id;
            for(id in values){
                if(!Ext.isFunction(values[id]) && (field = this.findField(id))){
                    field.setValue(values[id],values);
                    if(this.trackResetOnLoad){
                        field.originalValue = field.getValue();
                        //~ if (field.hiddenField) {
                          //~ field.hiddenField.originalValue = field.hiddenField.value;
                        //~ }
                    }
                }
            }
        }
        return this;
    }
});




function initializeFooBarDropZone(cmp) {
    //~ console.log('initializeFooBarDropZone',cmp);
    cmp.dropTarget = new Ext.dd.DropTarget(cmp.bwrap, {
      //~ ddGroup     : 'gridDDGroup',
      notifyEnter : function(ddSource, e, data) {
        console.log('notifyEnter',ddSource,e,data);
        //Add some flare to invite drop.
        cmp.body.stopFx();
        cmp.body.highlight();
      },
      notifyDrop  : function(ddSource, e, data){
        console.log('notifyDrop',ddSource,e,data);
        // Reference the record (single selection) for readability
        //~ var selectedRecord = ddSource.dragData.selections[0];


        // Load the record into the form
        //~ formPanel.getForm().my_loadRecord(selectedRecord);


        // Delete record from the grid.  not really required.
        //~ ddSource.grid.store.remove(selectedRecord);

        return(true);
      }
    })
}



Lino.show_mti_child = function(fieldname,detail_handler) {
  //~ console.log('show_mti_child',this);
  //~ console.log('show_mti_child',panel.find("main_area"));
  rec = Lino.current_window.main_item.get_current_record();
  //~ rec = panel.get_current_record();
  if (rec) {
    //~ console.log('show_mti_child',Lino.current_window,rec);
    if (rec.phantom) {
      Lino.notify('Not allowed on phantom record.');
    }else if (rec.data[fieldname]) {
      //~ console.log('show_mti_child',rec.id);
      //~ detail_handler(Lino.current_window.main_item,{},{record_id:rec.id});
      detail_handler.run(null,{record_id:rec.id});
      //~ window.open(urlroot + '/' + rec.id);
      //~ document.location = urlroot + '/' + rec.id;
      //~ window.open(urlroot + '/' + rec.id,'_blank');
    } else {
      Lino.alert("Cannot show MTI child if checkbox is off.");
    }
  } else {
    Lino.notify('No current record.');
  }
};






/*
Mappings towards lino.modlib.cal.models.PanelCalendars
*/
// Sset SS = Ssite.modules.cal.PanelCalendars.get_handle(Sui).store
Ext.ensible.cal.CalendarMappings = {
    CalendarId:   {name:'ID',       mapping: 'id', type: 'int'},
    Title:        {name:'CalTitle', mapping: 'babel_name', type: 'string'},
    Description:  {name:'Desc',     mapping: 'description', type: 'string'},
    ColorId:      {name:'Color',    mapping: 'color', type: 'int'},
    IsHidden:     {name:'Hidden',   mapping: 'is_hidden', type: 'boolean'},    
};
Ext.ensible.cal.CalendarRecord.reconfigure();  


/*
Mappings towards lino.modlib.cal.models.PanelEvents 
*/
// Sset SS = Ssite.modules.cal.PanelEvents.get_handle(Sui).store
Ext.ensible.cal.EventMappings = {
    EventId:     {name: 'ID',        mapping: 'id', type:'int'},
    CalendarId:  {name: 'CalID',     mapping: 'calendarHidden', type: 'int'},
    Title:       {name: 'EvtTitle',  mapping: 'summary'},
    StartDate:   {name: 'StartDt',   mapping: 'start_dt', 
      type: 'date', 
      dateFormat: "Y-m-d\TH:i:s" },
    EndDate:     {name: 'EndDt',     mapping: 'end_dt', 
      type: 'date', 
      dateFormat: "Y-m-d\TH:i:s"},
    RRule:       {name: 'RecurRule', mapping: 'rsetHidden'},
    Location:    {name: 'Location',  mapping: 'placeHidden'},
    Notes:       {name: 'Desc',      mapping: 'description'},
    Url:         {name: 'LinkUrl',   mapping: 'url'},
    IsAllDay:    {name: 'AllDay',    mapping: 'all_day', type: 'boolean'},
    Reminder:    {name: 'Reminder',  mapping: 'reminder'}
    
};
Ext.ensible.cal.EventRecord.reconfigure();


Lino.on_eventclick = function(cp,rec,el) {
  //~ console.log("Lino.on_eventclick",arguments);
  //~ Lino.cal.Events.detail_action.run({record_id:rec.data.ID});
  Lino.cal.PanelEvents.detail.run(null,{record_id:rec.data.ID,base_params:Lino.eventStore.baseParams});
  return false;
}
    
Lino.on_editdetails = function(cp,rec,el) {
  //~ console.log("Lino.on_editdetails",arguments);
  if (rec.data.ID)
      //~ Lino.cal.Events.detail_action.run({record_id:rec.data.ID});
      Lino.cal.PanelEvents.detail.run(null,{record_id:rec.data.ID,base_params:Lino.eventStore.baseParams});
  return false;
}

Lino.format_time = function(dt) {
    return dt.getHours() + ':' + dt.getMinutes();
}
    
Lino.on_eventdelete = function() {
  //~ console.log("Lino.on_eventdelete",arguments);
};

Lino.on_eventadd  = function(cp,rec,el) {
  //~ console.log("Lino.on_eventadd ",arguments);
  return false;
}
    
Lino.on_eventresize  = function(cp,rec,el) {
  //~ console.log("Lino.on_eventresize ",arguments);
  //~ Lino.cal.Events.insert(cp);
  //~ return false;
}
    
Lino.on_eventupdate  = function(cp,rec,el) {
  //~ console.log("Lino.on_eventupdate",arguments);
  //~ Lino.cal.Events.insert(cp);
  //~ return false;
}
    

//~ Lino.eventStore = new Ext.ensible.cal.EventStore({ 
//~ Lino.eventStore = new Ext.data.ArrayStore({ 
Lino.eventStore = new Ext.data.JsonStore({ 
  listeners: { exception: Lino.on_store_exception }
  ,url: '/restful/cal/PanelEvents'
  ,restful : true
  ,proxy: new Ext.data.HttpProxy({ 
      url: '/restful/cal/PanelEvents', 
      disableCaching: false // no need for cache busting when loading via Ajax
      //~ disableCaching:true,
  })
  ,fields: Ext.ensible.cal.EventRecord.prototype.fields.getRange()
  ,totalProperty: "count"
  ,root: "rows"
  ,idProperty: Ext.ensible.cal.EventMappings.EventId.mapping
  ,writer : new Ext.data.JsonWriter({
    writeAllFields: false
  })
  ,load: function(options) {
    //~ foo.bar = baz; // 20120213
      if (!options) options = {};
      if (!options.params) options.params = {};
      //~ options.params.$ext_requests.URL_PARAM_TEAM_VIEW = Lino.calendar_app.team_view_button.pressed;
      
      var view = this.cal_panel.getActiveView();
      var bounds = view.getViewBounds();
      //~ var p = {sd:'05.02.2012',ed:'11.02.2012'};
      //~ var p = {};
      options.params[view.dateParamStart] = bounds.start.format(view.dateParamFormat);
      options.params[view.dateParamEnd] = bounds.end.format(view.dateParamFormat);
      Lino.insert_subst_user(options.params);
      //~ Ext.apply(options.params,p)
      //~ console.log('20120710 eventStore.load()',this.baseParams,options);
    
    return Ext.data.JsonStore.prototype.load.call(this,options);
  }
});

//~ Lino.calendarStore = new Ext.data.ArrayStore({ 
Lino.calendarStore = new Ext.data.JsonStore({ 
      listeners: { exception: Lino.on_store_exception }
      ,restful : true
      ,proxy: new Ext.data.HttpProxy({ 
          url: '/restful/cal/PanelCalendars?fmt=json', 
          disableCaching: false // no need for cache busting when loading via Ajax
          //~ restful : true
          //~ method: "GET"
      })
      //~ ,autoLoad: true
      //~ ,remoteSort: true
      //~ ,baseParams: bp
      ,totalProperty: "count"
      ,root: "rows"
      ,fields: Ext.ensible.cal.CalendarRecord.prototype.fields.getRange()
      ,idProperty: Ext.ensible.cal.CalendarMappings.CalendarId.mapping
      //~ ,idIndex: Ext.ensible.cal.CalendarMappings.CalendarId.mapping
    });


Lino.CalendarCfg = {
    dateParamFormat: 'd.m.Y',
    dateParamStart:'sd',
    dateParamEnd:'ed'
};
//~ 20120704 Lino.CalendarPanel = Ext.extend(Ext.ensible.cal.CalendarPanel,Lino.MainPanel);
//~ Lino.CalendarPanel = Ext.extend(Lino.CalendarPanel,{
Ext.override(Ext.ensible.cal.CalendarPanel,Lino.MainPanel);
Ext.override(Ext.ensible.cal.CalendarPanel,{
  //~ empty_title : "\$ui.get_actor('cal.Panel').report.label",
  empty_title : "Calendrier"
  ,activeItem: 1 // 0: day, 1: week
  ,ls_url: '/cal/CalendarPanel'
  //~ ,disableCaching:true
  ,eventStore: Lino.eventStore
  ,calendarStore: Lino.calendarStore
  ,listeners: { 
    editdetails: Lino.on_editdetails
    ,eventclick: Lino.on_eventclick
    //~ ,eventadd: Lino.on_eventadd
    //~ ,eventdelete: Lino.on_eventdelete
    //~ ,eventresize: Lino.on_eventresize
    ,afterrender : function(config) {
      //~ console.log("20120704 afterrender");
      Lino.calendarStore.load();
      //~ console.log("20120704 afterrender calls eventStore.load()",p);
      Lino.eventStore.cal_panel = this;
      //~ Lino.eventStore.load({params:p});
      Lino.eventStore.load();
      //~ Lino.CalendarPanel.superclass.constructor.call(this, config);
      //~ console.log(20120118, config,this);
    }
    }
  ,enableEditDetails: false
  //~ ,monthViewCfg: Lino.CalendarCfg
  //~ ,weekViewCfg: Lino.CalendarCfg
  //~ ,multiDayViewCfg: Lino.CalendarCfg
  //~ ,multiWeekViewCfg: Lino.CalendarCfg
  //~ ,dayViewCfg: Lino.CalendarCfg
  //~ ,initComponent : function() {
    //~ // this.on('eventadd',Lino.on_eventadd);
    //~ Lino.CalendarPanel.superclass.initComponent.call(this);
  //~ }
});




Lino.CalendarAppPanel = Ext.extend(Ext.Panel,Lino.MainPanel);
Lino.CalendarAppPanel = Ext.extend(Lino.CalendarAppPanel,{
  //~ empty_title : "\$ui.get_actor('cal.Panel').report.label",
  empty_title : "Calendrier"
  ,ls_url: '/cal/CalendarPanel'
  ,set_status : function(status) { this.refresh();}
  ,refresh : function() {Lino.eventStore.reload();}
  ,layout: 'fit'
  ,unused_is_loading : function() { 
      var loading = Lino.calendarStore.getCount() == 0 | Lino.eventStore.getCount() == 0
      //~ console.log("CalendarPanel loading:",loading);
      return loading; 
  }
  ,get_base_params : function() {
    var p = Ext.apply({},this.base_params);
    Lino.insert_subst_user(p);
    return p;
  }
  ,set_base_params : function(p) {
    this.base_params = Ext.apply({},p);
  }
  ,clear_base_params : function() {
      this.base_params = {};
      Lino.insert_subst_user(this.base_params);
  }
  ,set_base_param : function(k,v) {
      if (!this.base_params) this.base_params = {};
      this.base_params[k] = v;
  }
});

Lino.calendar_app = function() { return {
  get_main_panel : function() {
      return new Lino.CalendarAppPanel({ items : 
        //~ [{
          //~ id: 'app-header',
          //~ region: 'north',
          //~ height: 35,
          //~ border: false,
          // contentEl: 'app-header-content'
        //~ },
      {
          id: 'app-center',
          title: '...', // will be updated to the current view's date range
          region: 'center',
          layout: 'border',
          listeners: {
              'afterrender': function(){
                  Ext.getCmp('app-center').header.addClass('app-center-header');
              }
          },
          items: [{
              id:'app-west',
              region: 'west',
              width: 176,
              border: false,
              items: [{
                  xtype: 'datepicker',
                  id: 'app-nav-picker',
                  cls: 'ext-cal-nav-picker',
                  listeners: {
                      'select': {
                          fn: function(dp, dt){
                              Lino.calendarPanel.setStartDate(dt);
                          },
                          scope: this
                      }
                  }
              //~ },{ 
                //~ layout:'fit',
                //~ items: [
                  //~ new Ext.form.Checkbox({
                    //~ boxLabel:"$_('Team view')",
                    //~ hideLabel:true
                    //~ listeners: { click: }
                  //~ })
                //~ ]
              },{ 
                layout:'form',
                items: [
                  this.team_view_button = new Ext.Button({
                    text:"Team view",
                    enableToggle:true,
                    pressed:false,
                    toggleHandler: function(btn,state) { 
                      //~ console.log('20120716 teamView.toggle()');
                      Lino.eventStore.setBaseParam('tv',state);
                      Lino.eventStore.load();
                      //~ Lino.eventStore.load({params:{$ext_requests.URL_PARAM_TEAM_VIEW:state}});
                      //~ console.log("team view",state);
                    }
                  })
                ]
              },{
                  xtype: 'extensible.calendarlist',
                  store: Lino.calendarStore,
                  border: false,
                  width: 175
              }]
          },{
              xtype: 'extensible.calendarpanel',
              eventStore: Lino.eventStore,
              calendarStore: Lino.calendarStore,
              border: false,
              id:'app-calendar',
              region: 'center',
              //~ activeItem: 3, // month view
              
              // Any generic view options that should be applied to all sub views:
              viewConfig: {
                  // Lino.CalendarCfg
                  dateParamFormat: 'd.m.Y',
                  dateParamStart:'sd',
                  dateParamEnd:'ed',
                
                  //enableFx: false,
                  //ddIncrement: 10, //only applies to DayView and subclasses, but convenient to put it here
                  viewStartHour: 8,
                  viewEndHour: 18
                  //minEventDisplayMinutes: 15
              },
              
              // View options specific to a certain view (if the same options exist in viewConfig
              // they will be overridden by the view-specific config):
              monthViewCfg: {
                  showHeader: true,
                  showWeekLinks: true,
                  showWeekNumbers: true,
                  eventBodyMarkup: ['{Title}',
                    //~ '<tpl if="url">',
                        //~ '<a href="{url}">XX</a>',
                    //~ '</tpl>',
                    '<tpl if="_isReminder">',
                        '<i class="ext-cal-ic ext-cal-ic-rem">&#160;</i>',
                    '</tpl>',
                    '<tpl if="_isRecurring">',
                        '<i class="ext-cal-ic ext-cal-ic-rcr">&#160;</i>',
                    '</tpl>',
                    '<tpl if="spanLeft">',
                        '<i class="ext-cal-spl">&#160;</i>',
                    '</tpl>',
                    '<tpl if="spanRight">',
                        '<i class="ext-cal-spr">&#160;</i>',
                    '</tpl>'
                ].join('')
              },
              
              multiWeekViewCfg: {
                  //weekCount: 3
              },
              
              // Some optional CalendarPanel configs to experiment with:
              //readOnly: true,
              //showDayView: false,
              //showMultiDayView: true,
              //showWeekView: false,
              //showMultiWeekView: false,
              //showMonthView: false,
              //showNavBar: false,
              //showTodayText: false,
              //showTime: false,
              //editModal: true,
              //enableEditDetails: false,
              //title: 'My Calendar', // the header of the calendar, could be a subtitle for the app
              
              // Once this component inits it will set a reference to itself as an application
              // member property for easy reference in other functions within App.
              initComponent: function() {
                  Lino.calendarPanel = this;
                  this.constructor.prototype.initComponent.apply(this, arguments);
              },
              
              listeners: {
                  //~ 'eventclick': {
                      //~ fn: function(vw, rec, el){
                          //~ this.clearMsg();
                      //~ },
                      //~ scope: this
                  //~ },
                  'eventover': function(vw, rec, el){
                      //console.log('Entered evt rec='+rec.data[Ext.ensible.cal.EventMappings.Title.name]', view='+ vw.id +', el='+el.id);
                  },
                  'eventout': function(vw, rec, el){
                      //console.log('Leaving evt rec='+rec.data[Ext.ensible.cal.EventMappings.Title.name]+', view='+ vw.id +', el='+el.id);
                  },
                  'eventadd': {
                      fn: function(cp, rec){
                          this.showMsg('Event '+ rec.data[Ext.ensible.cal.EventMappings.Title.name] +' was added');
                      },
                      scope: this
                  },
                  'eventupdate': {
                      fn: function(cp, rec){
                          this.showMsg('Event '+ rec.data[Ext.ensible.cal.EventMappings.Title.name] +' was updated');
                      },
                      scope: this
                  },
                  'eventdelete': {
                      fn: function(cp, rec){
                          //this.eventStore.remove(rec);
                          this.showMsg('Event '+ rec.data[Ext.ensible.cal.EventMappings.Title.name] +' was deleted');
                      },
                      scope: this
                  },
                  'eventcancel': {
                      fn: function(cp, rec){
                          // edit canceled
                      },
                      scope: this
                  },
                  'viewchange': {
                      fn: function(p, vw, dateInfo){
                          if(this.editWin){
                              this.editWin.hide();
                          };
                          if(dateInfo !== null){
                              // will be null when switching to the event edit form so ignore
                              Ext.getCmp('app-nav-picker').setValue(dateInfo.activeDate);
                              this.updateTitle(dateInfo.viewStart, dateInfo.viewEnd);
                          }
                      },
                      scope: this
                  },
                  'dayclick': {
                      fn: function(vw, dt, ad, el){
                          this.clearMsg();
                      },
                      scope: this
                  },
                  'rangeselect': {
                      fn: function(vw, dates, onComplete){
                          this.clearMsg();
                      },
                      scope: this
                  },
                  'eventmove': {
                      fn: function(vw, rec){
                          rec.commit();
                          var time = rec.data[Ext.ensible.cal.EventMappings.IsAllDay.name] ? '' : ' \\a\\t g:i a';
                          this.showMsg('Event '+ rec.data[Ext.ensible.cal.EventMappings.Title.name] +' was moved to '+
                              rec.data[Ext.ensible.cal.EventMappings.StartDate.name].format('F jS'+time));
                      },
                      scope: this
                  },
                  'eventresize': {
                      fn: function(vw, rec){
                          rec.commit();
                          this.showMsg('Event '+ rec.data[Ext.ensible.cal.EventMappings.Title.name] +' was updated');
                      },
                      scope: this
                  },
                  'eventdelete': {
                      fn: function(win, rec){
                          Lino.eventStore.remove(rec);
                          this.showMsg('Event '+ rec.data[Ext.ensible.cal.EventMappings.Title.name] +' was deleted');
                      },
                      scope: this
                  },
                  'initdrag': {
                      fn: function(vw){
                          if(this.editWin && this.editWin.isVisible()){
                              this.editWin.hide();
                          }
                      },
                      scope: this
                  }
              }
          }]
        }
        //~ ]
        
      });
      
  }
  ,updateTitle: function(startDt, endDt){
      var p = Ext.getCmp('app-center');
      
      if(startDt.clearTime().getTime() == endDt.clearTime().getTime()){
          p.setTitle(startDt.format('F j, Y'));
      }
      else if(startDt.getFullYear() == endDt.getFullYear()){
          if(startDt.getMonth() == endDt.getMonth()){
              p.setTitle(startDt.format('F j') + ' - ' + endDt.format('j, Y'));
          }
          else{
              p.setTitle(startDt.format('F j') + ' - ' + endDt.format('F j, Y'));
          }
      }
      else{
          p.setTitle(startDt.format('F j, Y') + ' - ' + endDt.format('F j, Y'));
      }
  }
  // This is an application-specific way to communicate CalendarPanel event messages back to the user.
  // This could be replaced with a function to do "toast" style messages, growl messages, etc. This will
  // vary based on application requirements, which is why it's not baked into the CalendarPanel.
  ,showMsg: function(msg){
      Lino.notify(msg);
      //~ Ext.fly('app-msg').update(msg).removeClass('x-hidden');
  }
  
  ,clearMsg: function(){
      Lino.notify('');
      //~ Ext.fly('app-msg').update('').addClass('x-hidden');
  }
}
}();




/*
captureEvents utility by Aaron Conran
<http://www.sencha.com/learn/grid-faq/>

Ext.onReady(function(){
    var grid = new Ext.grid.GridPanel({
        ... 
    });
    captureEvents(grid);
});
*/
function captureEvents(observable) {
    Ext.util.Observable.capture(
        observable,
        function(eventName) {
            console.info(eventName);
        },
        this
    );		
}
 






Lino.main_menu = [ { "menu": { "items": [ { "text": "Personnes", "handler": function() {Lino.contacts.Persons.grid.run(null)} }, { "text": " \u25b6 Clients", "handler": function() {Lino.pcsw.Clients.grid.run(null)} }, { "text": "Organisations", "handler": function() {Lino.contacts.Companies.grid.run(null)} }, { "text": "M\u00e9nages", "handler": function() {Lino.households.Households.grid.run(null)} }, "-", { "text": "Partenaires (tous)", "handler": function() {Lino.contacts.Partners.grid.run(null)} } ] }, "text": "Contacts" }, { "menu": { "items": [ { "text": "Mon courrier sortant", "handler": function() {Lino.outbox.MyOutbox.grid.run(null)} }, { "menu": { "items": [ { "text": "Mes Envois postaux", "handler": function() {Lino.postings.MyPostings.grid.run(null)} }, { "text": "Envois postaux \u00e0 imprimer", "handler": function() {Lino.postings.PostingsReady.grid.run(null)} }, { "text": "Envois postaux imprim\u00e9s", "handler": function() {Lino.postings.PostingsPrinted.grid.run(null)} }, { "text": "Envois postaux envoy\u00e9s", "handler": function() {Lino.postings.PostingsSent.grid.run(null)} } ] }, "text": "Envois postaux" }, { "text": "Mes notes", "handler": function() {Lino.notes.MyNotes.grid.run(null)} } ] }, "text": "Office" }, { "menu": { "items": [ { "text": "Calendrier", "iconCls": "x-tbar-calendar", "handler": function() {Lino.cal.CalendarPanel.grid.run(null)} }, { "text": "Events", "listeners": { "render": Lino.quicktip_renderer("Foo","Table of all my calendar events.") }, "handler": function() {Lino.cal.MyEvents.grid.run(null)} }, "-", { "text": "Mes T\u00e2ches", "listeners": { "render": Lino.quicktip_renderer("Foo","Table of all my tasks.") }, "handler": function() {Lino.cal.MyTasks.grid.run(null)} }, { "text": "To-do list", "listeners": { "render": Lino.quicktip_renderer("Foo","Table of my tasks marked 'to do'.") }, "handler": function() {Lino.cal.MyTasksToDo.grid.run(null)} }, "-", { "text": "Mes pr\u00e9sences", "listeners": { "render": Lino.quicktip_renderer("Foo","Shows all my presences in calendar events, independently of their state.") }, "handler": function() {Lino.cal.MyPresences.grid.run(null)} }, { "text": "Mes invitations re\u00e7ues", "listeners": { "render": Lino.quicktip_renderer("Foo","Shows received invitations which I must accept or reject.") }, "handler": function() {Lino.cal.MyPendingInvitations.grid.run(null)} } ] }, "text": "Calendrier" }, { "menu": { "items": [ { "text": "Clients", "listeners": { "render": Lino.quicktip_renderer("Foo","Wie Kontakte \u25b8 Klienten, aber mit DSBE-spezifischen Kolonnen und Filterparametern.") }, "handler": function() {Lino.pcsw.IntegClients.grid.run(null)} }, { "text": "PIISs", "handler": function() {Lino.isip.MyContracts.grid.run(null)} }, { "text": "Art.60\u00a77 contracts", "handler": function() {Lino.jobs.MyContracts.grid.run(null)} }, { "text": "Employants", "handler": function() {Lino.jobs.JobProviders.grid.run(null)} }, { "text": "Emplois", "listeners": { "render": Lino.quicktip_renderer("Foo","\n    Eine Stelle ist ein Arbeitsplatz bei einem Stellenabieter. \n    ") }, "handler": function() {Lino.jobs.Jobs.grid.run(null)} }, { "text": "Offres d'emploi", "handler": function() {Lino.jobs.Offers.grid.run(null)} }, { "text": "Situation contrats Art 60-7", "listeners": { "render": Lino.quicktip_renderer("Foo","Open a detail window on this record") }, "handler": function() {Lino.jobs.NewJobsOverview.show.run(null,{ "record_id": -99998 })} } ] }, "text": "Int\u00e9gration" }, { "menu": { "items": [ { "text": "Organisateurs de cours", "handler": function() {Lino.courses.CourseProviders.grid.run(null)} }, { "text": "Offres de cours", "handler": function() {Lino.courses.CourseOffers.grid.run(null)} }, { "text": "Demandes de cours ouvertes", "handler": function() {Lino.courses.PendingCourseRequests.grid.run(null)} } ] }, "text": "Cours" }, { "menu": { "items": [ { "text": "Situation contrats Art 60-7", "listeners": { "render": Lino.quicktip_renderer("Foo","Open a detail window on this record") }, "handler": function() {Lino.jobs.JobsOverview.show.run(null,{ "record_id": -99998 })} }, { "text": "Agents et leurs clients", "handler": function() {Lino.pcsw.UsersWithClients.grid.run(null)} } ] }, "text": "Listings" }, { "menu": { "items": [ { "menu": { "items": [ { "text": "Mes Text Field Templates", "handler": function() {Lino.ui.MyTextFieldTemplates.grid.run(null)} } ] }, "text": "Office" }, { "menu": { "items": [ { "text": "Pays", "listeners": { "render": Lino.quicktip_renderer("Foo","\n    A country is a geographic entity considered a \"nation\".\n    ") }, "handler": function() {Lino.countries.Countries.grid.run(null)} }, { "text": "Langues", "handler": function() {Lino.countries.Languages.grid.run(null)} } ] }, "text": "Contacts" } ] }, "text": "Configuration" }, { "menu": { "items": [ { "menu": { "items": [ { "text": "PIISs", "handler": function() {Lino.isip.Contracts.grid.run(null)} }, { "text": "Art.60\u00a77 contracts", "handler": function() {Lino.jobs.Contracts.grid.run(null)} } ] }, "text": "Int\u00e9gration" } ] }, "text": "Explorateur" }, { "menu": { "items": [ { "text": "Info", "listeners": { "render": Lino.quicktip_renderer("Foo","Zeigt Informationen \u00fcber diese Site an.") }, "handler": function() {Lino.about.About.show.run(null,{ "record_id": -99998 })} } ] }, "text": "Site" }, { "text": "D\u00e9part", "handler": function() {Lino.close_all_windows()} } ];
Ext.namespace('Lino.ui.SiteConfigs')
Ext.namespace('Lino.ui.ContentTypes')
Ext.namespace('Lino.ui.HelpTexts')
Ext.namespace('Lino.ui.TextFieldTemplates')
Ext.namespace('Lino.users.Users')
Ext.namespace('Lino.users.MySettings')
Ext.namespace('Lino.users.UsersOverview')
Ext.namespace('Lino.users.Teams')
Ext.namespace('Lino.users.Memberships')
Ext.namespace('Lino.users.Authorities')
Ext.namespace('Lino.changes.Changes')
Ext.namespace('Lino.countries.Languages')
Ext.namespace('Lino.countries.Countries')
Ext.namespace('Lino.countries.Cities')
Ext.namespace('Lino.properties.PropGroups')
Ext.namespace('Lino.properties.PropTypes')
Ext.namespace('Lino.properties.Properties')
Ext.namespace('Lino.properties.PropChoices')
Ext.namespace('Lino.contacts.CompanyTypes')
Ext.namespace('Lino.contacts.Partners')
Ext.namespace('Lino.contacts.Companies')
Ext.namespace('Lino.contacts.RoleTypes')
Ext.namespace('Lino.contacts.Roles')
Ext.namespace('Lino.postings.Postings')
Ext.namespace('Lino.postings.PostingsByState')
Ext.namespace('Lino.postings.PostingsReady')
Ext.namespace('Lino.postings.PostingsPrinted')
Ext.namespace('Lino.postings.PostingsSent')
Ext.namespace('Lino.outbox.Recipients')
Ext.namespace('Lino.outbox.Mails')
Ext.namespace('Lino.outbox.Attachments')
Ext.namespace('Lino.cal.Calendars')
Ext.namespace('Lino.cal.Subscriptions')
Ext.namespace('Lino.cal.Places')
Ext.namespace('Lino.cal.Priorities')
Ext.namespace('Lino.cal.Events')
Ext.namespace('Lino.cal.MyEvents')
Ext.namespace('Lino.cal.MyUnclearEvents')
Ext.namespace('Lino.cal.EventsAssignedToMe')
Ext.namespace('Lino.cal.MyEventsToday')
Ext.namespace('Lino.cal.Tasks')
Ext.namespace('Lino.cal.GuestRoles')
Ext.namespace('Lino.cal.Guests')
Ext.namespace('Lino.cal.PanelCalendars')
Ext.namespace('Lino.cal.PanelEvents')
Ext.namespace('Lino.uploads.UploadTypes')
Ext.namespace('Lino.uploads.Uploads')
Ext.namespace('Lino.households.Types')
Ext.namespace('Lino.households.Households')
Ext.namespace('Lino.households.Roles')
Ext.namespace('Lino.households.Members')
Ext.namespace('Lino.accounts.Charts')
Ext.namespace('Lino.accounts.Groups')
Ext.namespace('Lino.accounts.Accounts')
Ext.namespace('Lino.notes.NoteTypes')
Ext.namespace('Lino.notes.EventTypes')
Ext.namespace('Lino.notes.Notes')
Ext.namespace('Lino.cv.LanguageKnowledges')
Ext.namespace('Lino.cv.PersonProperties')
Ext.namespace('Lino.contacts.Persons')
Ext.namespace('Lino.pcsw.Clients')
Ext.namespace('Lino.pcsw.DebtsClients')
Ext.namespace('Lino.pcsw.IntegClients')
Ext.namespace('Lino.pcsw.ClientsTest')
Ext.namespace('Lino.pcsw.PersonGroups')
Ext.namespace('Lino.pcsw.Activities')
Ext.namespace('Lino.pcsw.DispenseReasons')
Ext.namespace('Lino.pcsw.Dispenses')
Ext.namespace('Lino.pcsw.ExclusionTypes')
Ext.namespace('Lino.pcsw.Exclusions')
Ext.namespace('Lino.pcsw.AidTypes')
Ext.namespace('Lino.pcsw.OverlappingContracts')
Ext.namespace('Lino.pcsw.ClientContactTypes')
Ext.namespace('Lino.pcsw.ClientContacts')
Ext.namespace('Lino.pcsw.CoachingTypes')
Ext.namespace('Lino.pcsw.CoachingEndings')
Ext.namespace('Lino.pcsw.Coachings')
Ext.namespace('Lino.isip.ContractTypes')
Ext.namespace('Lino.isip.ExamPolicies')
Ext.namespace('Lino.isip.ContractEndings')
Ext.namespace('Lino.isip.StudyTypes')
Ext.namespace('Lino.isip.Contracts')
Ext.namespace('Lino.isip.MyContracts')
Ext.namespace('Lino.jobs.Schedules')
Ext.namespace('Lino.jobs.Regimes')
Ext.namespace('Lino.jobs.JobProviders')
Ext.namespace('Lino.jobs.ContractTypes')
Ext.namespace('Lino.jobs.Sectors')
Ext.namespace('Lino.jobs.Functions')
Ext.namespace('Lino.jobs.Contracts')
Ext.namespace('Lino.jobs.MyContracts')
Ext.namespace('Lino.jobs.Offers')
Ext.namespace('Lino.jobs.Studies')
Ext.namespace('Lino.jobs.Experiences')
Ext.namespace('Lino.jobs.Candidatures')
Ext.namespace('Lino.jobs.Jobs')
Ext.namespace('Lino.jobs.JobTypes')
Ext.namespace('Lino.jobs.ContractsSearch')
Ext.namespace('Lino.courses.CourseProviders')
Ext.namespace('Lino.courses.CourseContents')
Ext.namespace('Lino.courses.Courses')
Ext.namespace('Lino.courses.CourseOffers')
Ext.namespace('Lino.courses.CourseRequests')
Ext.namespace('Lino.courses.PendingCourseRequests')
Ext.namespace('Lino.lino_welfare.CoachingEndingsByUser')
Ext.namespace('Lino.lino_welfare.CoachingEndingsByType')
Ext.namespace('Lino.lino_welfare.ContractEndingsByType')
Ext.namespace('Lino.lino_welfare.JobsContractEndingsByType')
Ext.namespace('Lino.lino_welfare.StudyTypesAndContracts')
Ext.namespace('Lino.lino_welfare.CompaniesAndContracts')
Ext.namespace('Lino.lino_welfare.JobProvidersAndContracts')
Ext.namespace('Lino.newcomers.Brokers')
Ext.namespace('Lino.newcomers.Faculties')
Ext.namespace('Lino.newcomers.Competences')
Ext.namespace('Lino.newcomers.NewClients')
Ext.namespace('Lino.newcomers.AvailableCoaches')
Ext.namespace('Lino.debts.Budgets')
Ext.namespace('Lino.debts.Actors')
Ext.namespace('Lino.debts.Entries')
Ext.namespace('Lino.debts.EntriesByType')
Ext.namespace('Lino.cbss.Sectors')
Ext.namespace('Lino.cbss.Purposes')
Ext.namespace('Lino.cbss.IdentifyPersonRequests')
Ext.namespace('Lino.cbss.ManageAccessRequests')
Ext.namespace('Lino.cbss.RetrieveTIGroupsRequests')
Ext.namespace('Lino.sessions.SessionTable')
Ext.namespace('Lino.ui.MyTextFieldTemplates')
Ext.namespace('Lino.users.MembershipsByUser')
Ext.namespace('Lino.users.AuthoritiesGiven')
Ext.namespace('Lino.users.AuthoritiesTaken')
Ext.namespace('Lino.countries.CitiesByCity')
Ext.namespace('Lino.countries.CitiesByCountry')
Ext.namespace('Lino.properties.PropsByGroup')
Ext.namespace('Lino.properties.PropsByType')
Ext.namespace('Lino.properties.ChoicesByType')
Ext.namespace('Lino.contacts.PartnersByCity')
Ext.namespace('Lino.contacts.PartnersByCountry')
Ext.namespace('Lino.contacts.RolesByCompany')
Ext.namespace('Lino.contacts.RolesByPerson')
Ext.namespace('Lino.postings.MyPostings')
Ext.namespace('Lino.postings.PostingsByPartner')
Ext.namespace('Lino.postings.PostingsByProject')
Ext.namespace('Lino.outbox.RecipientsByMail')
Ext.namespace('Lino.outbox.MyOutbox')
Ext.namespace('Lino.outbox.MailsByUser')
Ext.namespace('Lino.outbox.MailsByProject')
Ext.namespace('Lino.outbox.SentByPartner')
Ext.namespace('Lino.outbox.AttachmentsByMail')
Ext.namespace('Lino.cal.SubscriptionsByCalendar')
Ext.namespace('Lino.cal.SubscriptionsByUser')
Ext.namespace('Lino.cal.EventsByCalendar')
Ext.namespace('Lino.cal.EventsByPlace')
Ext.namespace('Lino.cal.EventsByProject')
Ext.namespace('Lino.cal.TasksByUser')
Ext.namespace('Lino.cal.MyTasks')
Ext.namespace('Lino.cal.MyTasksToDo')
Ext.namespace('Lino.cal.TasksByProject')
Ext.namespace('Lino.cal.GuestsByEvent')
Ext.namespace('Lino.cal.GuestsByRole')
Ext.namespace('Lino.cal.GuestsByPartner')
Ext.namespace('Lino.cal.MyPresences')
Ext.namespace('Lino.cal.MyPendingInvitations')
Ext.namespace('Lino.uploads.MyUploads')
Ext.namespace('Lino.households.HouseholdsByType')
Ext.namespace('Lino.households.MembersByHousehold')
Ext.namespace('Lino.households.MembersByPerson')
Ext.namespace('Lino.households.MembersByRole')
Ext.namespace('Lino.accounts.GroupsByChart')
Ext.namespace('Lino.accounts.AccountsByGroup')
Ext.namespace('Lino.notes.MyNotes')
Ext.namespace('Lino.notes.NotesByType')
Ext.namespace('Lino.notes.NotesByEventType')
Ext.namespace('Lino.notes.NotesByProject')
Ext.namespace('Lino.cv.LanguageKnowledgesByPerson')
Ext.namespace('Lino.cv.KnowledgesByLanguage')
Ext.namespace('Lino.cv.PropsByPerson')
Ext.namespace('Lino.cv.PersonPropsByProp')
Ext.namespace('Lino.cv.ConfiguredPropsByPerson')
Ext.namespace('Lino.cv.SkillsByPerson')
Ext.namespace('Lino.cv.SoftSkillsByPerson')
Ext.namespace('Lino.cv.ObstaclesByPerson')
Ext.namespace('Lino.pcsw.ClientsByNationality')
Ext.namespace('Lino.pcsw.DispensesByClient')
Ext.namespace('Lino.pcsw.ExclusionsByClient')
Ext.namespace('Lino.pcsw.ContactsByClient')
Ext.namespace('Lino.pcsw.CoachingsByClient')
Ext.namespace('Lino.pcsw.CoachingsByUser')
Ext.namespace('Lino.pcsw.CoachingsByEnding')
Ext.namespace('Lino.pcsw.NotesByPerson')
Ext.namespace('Lino.pcsw.NotesByCompany')
Ext.namespace('Lino.isip.ContractsByPerson')
Ext.namespace('Lino.isip.ContractsByPolicy')
Ext.namespace('Lino.isip.ContractsByType')
Ext.namespace('Lino.isip.ContractsByEnding')
Ext.namespace('Lino.isip.ContractsByStudyType')
Ext.namespace('Lino.jobs.FunctionsBySector')
Ext.namespace('Lino.jobs.ContractsByPerson')
Ext.namespace('Lino.jobs.ContractsByProvider')
Ext.namespace('Lino.jobs.ContractsByPolicy')
Ext.namespace('Lino.jobs.ContractsByEnding')
Ext.namespace('Lino.jobs.ContractsByJob')
Ext.namespace('Lino.jobs.ContractsByRegime')
Ext.namespace('Lino.jobs.ContractsBySchedule')
Ext.namespace('Lino.jobs.StudiesByCountry')
Ext.namespace('Lino.jobs.StudiesByCity')
Ext.namespace('Lino.jobs.StudiesByPerson')
Ext.namespace('Lino.jobs.ExperiencesByFunction')
Ext.namespace('Lino.jobs.ExperiencesByPerson')
Ext.namespace('Lino.jobs.CandidaturesByPerson')
Ext.namespace('Lino.jobs.CandidaturesBySector')
Ext.namespace('Lino.jobs.CandidaturesByFunction')
Ext.namespace('Lino.jobs.CandidaturesByJob')
Ext.namespace('Lino.jobs.CandidaturesByOffer')
Ext.namespace('Lino.jobs.ExperiencesByOffer')
Ext.namespace('Lino.jobs.JobsByProvider')
Ext.namespace('Lino.jobs.JobsByType')
Ext.namespace('Lino.jobs.ContractsByType')
Ext.namespace('Lino.jobs.JobsOverviewByType')
Ext.namespace('Lino.courses.CoursesByOffer')
Ext.namespace('Lino.courses.CourseOffersByProvider')
Ext.namespace('Lino.courses.CourseOffersByContent')
Ext.namespace('Lino.courses.CourseRequestsByPerson')
Ext.namespace('Lino.courses.CourseRequestsByContent')
Ext.namespace('Lino.courses.RequestsByCourse')
Ext.namespace('Lino.courses.ParticipantsByCourse')
Ext.namespace('Lino.courses.CandidatesByCourse')
Ext.namespace('Lino.newcomers.CompetencesByUser')
Ext.namespace('Lino.newcomers.CompetencesByFaculty')
Ext.namespace('Lino.newcomers.MyCompetences')
Ext.namespace('Lino.newcomers.ClientsByFaculty')
Ext.namespace('Lino.newcomers.AvailableCoachesByClient')
Ext.namespace('Lino.debts.MyBudgets')
Ext.namespace('Lino.debts.BudgetsByPartner')
Ext.namespace('Lino.debts.ActorsByBudget')
Ext.namespace('Lino.debts.ActorsByPartner')
Ext.namespace('Lino.debts.EntriesByBudget')
Ext.namespace('Lino.debts.ExpensesByBudget')
Ext.namespace('Lino.debts.IncomesByBudget')
Ext.namespace('Lino.debts.LiabilitiesByBudget')
Ext.namespace('Lino.debts.AssetsByBudget')
Ext.namespace('Lino.debts.DistByBudget')
Ext.namespace('Lino.cbss.MyIdentifyPersonRequests')
Ext.namespace('Lino.cbss.IdentifyRequestsByPerson')
Ext.namespace('Lino.cbss.ManageAccessRequestsByPerson')
Ext.namespace('Lino.cbss.MyManageAccessRequests')
Ext.namespace('Lino.cbss.RetrieveTIGroupsRequestsByPerson')
Ext.namespace('Lino.cbss.MyRetrieveTIGroupsRequests')
Ext.namespace('Lino.uploads.UploadsByController')
Ext.namespace('Lino.postings.PostingsByController')
Ext.namespace('Lino.cal.TasksByController')
Ext.namespace('Lino.outbox.MailsByController')
Ext.namespace('Lino.changes.ChangesByMaster')
Ext.namespace('Lino.ui.HelpTextsByModel')
Ext.namespace('Lino.outbox.AttachmentsByController')
Ext.namespace('Lino.cal.EventsByController')
Ext.namespace('Lino.about.Models')
Ext.namespace('Lino.about.FieldsByModel')
Ext.namespace('Lino.about.Inspector')
Ext.namespace('Lino.about.SourceFiles')
Ext.namespace('Lino.pcsw.UsersWithClients')
Ext.namespace('Lino.lino_welfare.CompareRequestsTable')
Ext.namespace('Lino.lino_welfare.PeriodicNumbers')
Ext.namespace('Lino.debts.PrintEntriesByBudget')
Ext.namespace('Lino.debts.PrintExpensesByBudget')
Ext.namespace('Lino.debts.PrintIncomesByBudget')
Ext.namespace('Lino.debts.PrintLiabilitiesByBudget')
Ext.namespace('Lino.debts.PrintAssetsByBudget')
Ext.namespace('Lino.debts.SummaryTable')
Ext.namespace('Lino.debts.ResultByBudget')
Ext.namespace('Lino.debts.DebtsByBudget')
Ext.namespace('Lino.debts.BailiffDebtsByBudget')
Ext.namespace('Lino.cbss.IdentifyPersonResult')
Ext.namespace('Lino.cbss.RetrieveTIGroupsResult')
Ext.namespace('Lino.lino.Report')
Ext.namespace('Lino.ui.Home')
Ext.namespace('Lino.about.About')
Ext.namespace('Lino.cal.CalendarPanel')
Ext.namespace('Lino.lino.Home')
Ext.namespace('Lino.jobs.JobsOverview')
Ext.namespace('Lino.jobs.NewJobsOverview')
Ext.namespace('Lino.lino_welfare.ActivityReport1')
Ext.namespace('Lino.lino_welfare.ActivityReport')
Ext.namespace('Lino.courses.CourseRequestStates')
Ext.namespace('Lino.postings.PostingStates')
Ext.namespace('Lino.cal.DurationUnits')
Ext.namespace('Lino.cal.TaskStates')
Ext.namespace('Lino.cal.Weekdays')
Ext.namespace('Lino.lino.UserLevels')
Ext.namespace('Lino.pcsw.CoachingEvents')
Ext.namespace('Lino.lino.YesNo')
Ext.namespace('Lino.cal.EventStates')
Ext.namespace('Lino.accounts.AccountTypes')
Ext.namespace('Lino.cal.Recurrencies')
Ext.namespace('Lino.properties.HowWell')
Ext.namespace('Lino.cv.CefLevel')
Ext.namespace('Lino.jobs.CandidatureStates')
Ext.namespace('Lino.outbox.RecipientType')
Ext.namespace('Lino.countries.CityTypes')
Ext.namespace('Lino.pcsw.BeIdCardTypes')
Ext.namespace('Lino.pcsw.CivilState')
Ext.namespace('Lino.pcsw.ClientStates')
Ext.namespace('Lino.cal.GuestStates')
Ext.namespace('Lino.properties.DoYouLike')
Ext.namespace('Lino.cbss.RequestLanguages')
Ext.namespace('Lino.cbss.ManageAction')
Ext.namespace('Lino.pcsw.RefusalReasons')
Ext.namespace('Lino.lino.UserGroups')
Ext.namespace('Lino.cbss.RequestStates')
Ext.namespace('Lino.lino.ChangeTypes')
Ext.namespace('Lino.cal.AccessClasses')
Ext.namespace('Lino.cbss.QueryRegister')
Ext.namespace('Lino.isip.ContractEvents')
Ext.namespace('Lino.lino.Genders')
Ext.namespace('Lino.pcsw.ClientEvents')
Ext.namespace('Lino.lino.UserProfiles')
Ext.namespace('Lino.pcsw.ResidenceType')

// ChoiceLists: 
Lino.courses.CourseRequestStates = [ [ "10", "Open" ], [ "20", "Registered" ], [ "30", "R\u00e9ussi" ], [ "40", "Bien r\u00e9ussi" ], [ "50", "echec" ], [ "60", "Abandonn\u00e9" ], [ "70", "Inactif" ] ];
Lino.postings.PostingStates = [ [ "10", "Ouvert" ], [ "20", "Pr\u00e8t \u00e0 imprimer" ], [ "30", "Imprim\u00e9" ], [ "40", "Ex\u00e9cut\u00e9" ], [ "50", "Retour" ] ];
Lino.cal.DurationUnits = [ [ "s", "secondes" ], [ "m", "minutes" ], [ "h", "heures" ], [ "D", "jours" ], [ "W", "semaines" ], [ "M", "mois" ], [ "Y", "ann\u00e9es" ] ];
Lino.cal.TaskStates = [ [ "10", "\u00e0 faire" ], [ "20", "Started" ], [ "30", "accomplie" ], [ "50", "Annul\u00e9" ] ];
Lino.cal.Weekdays = [ [ "1", "Lundi" ], [ "2", "Mardi" ], [ "3", "Mercredit" ], [ "4", "Jeudi" ], [ "5", "Vendredi" ], [ "6", "Samedi" ], [ "7", "Dimanche" ] ];
Lino.lino.UserLevels = [ [ "10", "Guest" ], [ "20", "Secr\u00e9taire" ], [ "30", "Utilisateur" ], [ "40", "Manager" ], [ "50", "Administrateur" ], [ "90", "Expert" ] ];
Lino.pcsw.CoachingEvents = [ [ "10", "Started" ], [ "20", "Active" ], [ "30", "Ended" ] ];
Lino.lino.YesNo = [ [ "y", "Oui" ], [ "n", "Non" ] ];
Lino.cal.EventStates = [ [ "10", "Propos\u00e9" ], [ "20", "Draft" ], [ "30", "Communiqu\u00e9" ], [ "40", "Planif\u00e9" ], [ "50", "a eu lieu" ], [ "60", "D\u00e9plac\u00e9" ], [ "70", "Annul\u00e9" ], [ "80", "Absent" ] ];
Lino.accounts.AccountTypes = [ [ "A", "Actifs" ], [ "L", "Obligations" ], [ "I", "Revenus" ], [ "E", "D\u00e9penses" ], [ "C", "Capital" ], [ "B", "Bank accounts" ] ];
Lino.cal.Recurrencies = [ [ "D", "daily" ], [ "W", "weekly" ], [ "M", "monthly" ], [ "Y", "yearly" ], [ "P", "per weekday" ] ];
Lino.properties.HowWell = [ [ "0", "not at all" ], [ "1", "a bit" ], [ "2", "moderate" ], [ "3", "quite well" ], [ "4", "very well" ] ];
Lino.cv.CefLevel = [ [ "A1", "A1 (basic language skills)" ], [ "A2", "A2 (basic language skills)" ], [ "A2+", "A2+ (basic language skills)" ], [ "B1", "B1 (independent use of language)" ], [ "B2", "B2 (independent use of language)" ], [ "B2+", "B2+ (independent use of language)" ], [ "C1", "C1 (proficient use of language)" ], [ "C2", "C2 (proficient use of language)" ], [ "C2+", "C2+ (proficient use of language)" ] ];
Lino.jobs.CandidatureStates = [ [ "10", "Active" ], [ "20", "p\u00e9riode d'essai" ], [ "25", "Probation failed" ], [ "27", "Travaille" ], [ "30", "Inactive" ] ];
Lino.outbox.RecipientType = [ [ "to", "to" ], [ "cc", "cc" ], [ "bcc", "bcc" ] ];
Lino.countries.CityTypes = [ [ "10", "Member State" ], [ "11", "Division" ], [ "12", "Region" ], [ "13", "Community" ], [ "14", "Territory" ], [ "20", "County" ], [ "21", "Province" ], [ "22", "Shire" ], [ "23", "Subregion" ], [ "24", "Department" ], [ "25", "Arrondissement" ], [ "26", "Prefecture" ], [ "27", "District" ], [ "28", "Secteur" ], [ "50", "Ville" ], [ "51", "Town" ], [ "52", "Municipality" ], [ "54", "Parish" ], [ "55", "Township" ], [ "56", "Quarter" ], [ "61", "Borough" ], [ "62", "Small borough" ], [ "70", "Village" ] ];
Lino.pcsw.BeIdCardTypes = [ [ "1", "Registre national" ], [ "6", "Kids card (< 12 year)" ], [ "11", "Foreigner card A" ], [ "12", "Foreigner card B" ], [ "13", "Foreigner card C" ], [ "14", "Foreigner card D" ], [ "15", "Foreigner card E" ], [ "16", "Foreigner card E+" ], [ "17", "Foreigner card F" ], [ "18", "Foreigner card F+" ] ];
Lino.pcsw.CivilState = [ [ "10", "c\u00e9libataire" ], [ "13", "C\u00e9libateire cohabitant" ], [ "18", "C\u00e9libataire avec enfant" ], [ "20", "mari\u00e9" ], [ "21", "Mari\u00e9 (habitant seul)" ], [ "22", "Mari\u00e9 (vivant avec autre partenaire)" ], [ "30", "veuf/veuve" ], [ "33", "Veuf cohabitant" ], [ "40", "divorc\u00e9" ], [ "50", "s\u00e9par\u00e9" ] ];
Lino.pcsw.ClientStates = [ [ "10", "Nouveau" ], [ "20", "Refus\u00e9" ], [ "30", "Accompagn\u00e9" ], [ "50", "Ancien" ] ];
Lino.cal.GuestStates = [ [ "10", "Invit\u00e9" ], [ "20", "Accept\u00e9" ], [ "30", "Rejet\u00e9" ], [ "40", "Pr\u00e9sent" ], [ "50", "Absent" ] ];
Lino.properties.DoYouLike = [ [ "0", "certainly not" ], [ "1", "rather not" ], [ "2", "normally" ], [ "3", "quite much" ], [ "4", "very much" ] ];
Lino.cbss.RequestLanguages = [ [ "nl", "Dutch" ], [ "fr", "French" ], [ "de", "German" ] ];
Lino.cbss.ManageAction = [ [ "1", "Int\u00e9grer" ], [ "2", "Annuler int\u00e9gration" ], [ "3", "Listing" ] ];
Lino.pcsw.RefusalReasons = [ [ "10", "Information request (No coaching needed)" ], [ "20", "CPAS n'est pas comp\u00e9tent" ], [ "30", "Client n'est plus revenu" ] ];
Lino.lino.UserGroups = [ [ "office", "office (Office)" ], [ "accounting", "accounting (Comptabilit\u00e9)" ], [ "integ", "integ (Int\u00e9gration)" ], [ "newcomers", "newcomers (Nouvelles demandes)" ], [ "debts", "debts (M\u00e9diation de dettes)" ], [ "cbss", "cbss (BCSS)" ] ];
Lino.cbss.RequestStates = [ [ "10", "Ex\u00e9cut\u00e9" ], [ "20", "echec" ], [ "25", "Valid\u00e9" ], [ "30", "OK" ], [ "40", "Avertissements" ], [ "50", "Erreurs" ] ];
Lino.lino.ChangeTypes = [ [ "C", "Cr\u00e9er" ], [ "U", "Update" ], [ "D", "Supprimer" ], [ "R", "Remove child" ], [ "A", "Add child" ], [ "M", "Merge" ] ];
Lino.cal.AccessClasses = [ [ "10", "Priv\u00e9" ], [ "20", "Montrer \"occup\u00e9\"" ], [ "30", "Public" ] ];
Lino.cbss.QueryRegister = [ [ "1", "Primaire" ], [ "2", "Secondaire" ], [ "3", "Tous" ] ];
Lino.isip.ContractEvents = [ [ "10", "Started" ], [ "20", "Active" ], [ "30", "Ended" ], [ "40", "Signed" ] ];
Lino.lino.Genders = [ [ "M", "Masculin" ], [ "F", "F\u00e9minin" ] ];
Lino.pcsw.ClientEvents = [ [ "10", "Accompagn\u00e9" ], [ "20", "Dispense" ], [ "30", "Exclusion" ], [ "40", "Note" ], [ "50", "Cr\u00e9\u00e9" ], [ "60", "Modified" ] ];
Lino.lino.UserProfiles = [ [ "000", "000 (Anonyme)" ], [ "100", "100 (Agent d'insertion)" ], [ "110", "110 (Integration Agent (Manager))" ], [ "200", "200 (Consultat nouveaux clients)" ], [ "300", "300 (Consultate m\u00e9diateur dettes)" ], [ "500", "500 (BCSS seulement)" ], [ "900", "900 (Administrateur)" ] ];
Lino.pcsw.ResidenceType = [ [ "1", "Registre national" ], [ "2", "Registre des \u00e9trangers" ], [ "3", "Registre d'attente " ] ];

Lino.jobs.JobsOverviewByType.ParamsPanel = Ext.extend(Ext.form.FormPanel,{
  autoHeight: true,
  layout: "hbox",
  frame: true,
  layoutConfig: { "align": "stretchmax" },
  hideCheckBoxLabels: true,
  autoScroll: false,
  labelWidth: 243,
  border: false,
  bodyBorder: false,
  labelAlign: "top",
  initComponent : function() {
    var containing_panel = this;
    var contract_type2507 = new Lino.TwinCombo({ "fieldLabel": "Type de contrat de travail", "name": "contract_type", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.jobs.ContractTypes.detail)}, "emptyText": "Choisir Type de contrat de travail...", "selectOnFocus": true, "hiddenName": "contract_typeHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/jobs/JobsOverviewByType/contract_type", "method": "GET" }) }) });
    var date2508 = new Lino.DateField({ "selectOnFocus": true, "fieldLabel": "Date", "anchor": "-20", "name": "date" });
    this.items = [ { "flex": 71, "autoHeight": true, "layout": "form", "xtype": "panel", "items": contract_type2507, "labelAlign": "top" }, { "flex": 28, "autoHeight": true, "layout": "form", "xtype": "panel", "items": date2508, "labelAlign": "top" } ];
    this.fields = [ contract_type2507, date2508 ];
    Lino.jobs.JobsOverviewByType.ParamsPanel.superclass.initComponent.call(this);
  }
});


Lino.contacts.Persons.ParamsPanel = Ext.extend(Ext.form.FormPanel,{
  autoScroll: false,
  border: false,
  layout: "fit",
  hideCheckBoxLabels: true,
  frame: true,
  bodyBorder: false,
  labelAlign: "top",
  initComponent : function() {
    var containing_panel = this;
    var gender1147 = new Lino.ChoicesFieldElement({ "forceSelection": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Sexe</span>", "name": "gender", "hiddenName": "genderHidden", "listeners": { "render": Lino.quicktip_renderer("Sexe","Nur Personen, deren Feld \"Geschlecht\" ausgef\u00fcllt ist und dem angegebenen Wert entspricht.") }, "selectOnFocus": true, "anchor": "-20", "store": Lino.lino.Genders });
    var also_obsolete1148 = new Ext.form.Checkbox({ "boxLabel": "aussi clients obsol\u00e8tes", "listeners": { "render": Lino.quicktip_renderer("aussi clients obsol\u00e8tes","Auch Datens\u00e4tze anzeigen, die als veraltet markiert sind.") }, "hideLabel": true, "checked": false, "name": "also_obsolete", "selectOnFocus": true, "anchor": "-20" });
    var main_1_panel1149 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 216, "hideCheckBoxLabels": true, "items": [ { "flex": 52, "autoHeight": true, "layout": "form", "xtype": "panel", "items": gender1147, "labelAlign": "top" }, { "flex": 47, "autoHeight": true, "layout": "form", "xtype": "panel", "items": also_obsolete1148, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    this.items = [ main_1_panel1149 ];
    this.fields = [ gender1147, also_obsolete1148 ];
    Lino.contacts.Persons.ParamsPanel.superclass.initComponent.call(this);
  }
});


Lino.cal.MyEvents.ParamsPanel = Ext.extend(Ext.form.FormPanel,{
  autoScroll: false,
  border: false,
  layout: "fit",
  hideCheckBoxLabels: true,
  frame: true,
  bodyBorder: false,
  labelAlign: "top",
  initComponent : function() {
    var containing_panel = this;
    var dates_from68 = new Lino.DateField({ "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Date du","Nur Termine ab diesem Datum.") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Date du</span>", "anchor": "-20", "name": "dates_from" });
    var dates_to69 = new Lino.DateField({ "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("au ","Nur Termine bis zu diesem Datum.") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">au </span>", "anchor": "-20", "name": "dates_to" });
    var user70 = new Lino.TwinCombo({ "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Responsible user</span>", "name": "user", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.users.Users.detail)}, "emptyText": "Choisir Utilisateur...", "listeners": { "render": Lino.quicktip_renderer("Responsible user","Nur Termine dieses Benutzers.") }, "selectOnFocus": true, "hiddenName": "userHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/Events/user", "method": "GET" }) }) });
    var assigned_to71 = new Lino.TwinCombo({ "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Attribu\u00e9 \u00e0</span>", "name": "assigned_to", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.users.Users.detail)}, "emptyText": "Choisir Utilisateur...", "listeners": { "render": Lino.quicktip_renderer("Attribu\u00e9 \u00e0","Nur Termine, die diesem Benutzer zugewiesen sind.") }, "selectOnFocus": true, "hiddenName": "assigned_toHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/Events/assigned_to", "method": "GET" }) }) });
    var state72 = new Lino.ChoicesFieldElement({ "forceSelection": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">State</span>", "name": "state", "hiddenName": "stateHidden", "listeners": { "render": Lino.quicktip_renderer("State","Nur Termine in diesem Bearbeitungszustand.") }, "selectOnFocus": true, "anchor": "-20", "store": Lino.cal.EventStates });
    var unclear73 = new Ext.form.Checkbox({ "boxLabel": "Mes rendez-vous \u00e0 clarifier", "hideLabel": true, "checked": false, "name": "unclear", "selectOnFocus": true, "anchor": "-20" });
    var main_1_panel74 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 252, "hideCheckBoxLabels": true, "items": [ { "flex": 11, "autoHeight": true, "layout": "form", "xtype": "panel", "items": dates_from68, "labelAlign": "top" }, { "flex": 11, "autoHeight": true, "layout": "form", "xtype": "panel", "items": dates_to69, "labelAlign": "top" }, { "flex": 20, "autoHeight": true, "layout": "form", "xtype": "panel", "items": user70, "labelAlign": "top" }, { "flex": 20, "autoHeight": true, "layout": "form", "xtype": "panel", "items": assigned_to71, "labelAlign": "top" }, { "flex": 22, "autoHeight": true, "layout": "form", "xtype": "panel", "items": state72, "labelAlign": "top" }, { "flex": 13, "autoHeight": true, "layout": "form", "xtype": "panel", "items": unclear73, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    this.items = [ main_1_panel74 ];
    this.fields = [ dates_from68, dates_to69, user70, assigned_to71, state72, unclear73 ];
    Lino.cal.MyEvents.ParamsPanel.superclass.initComponent.call(this);
  }
});


Lino.jobs.Contracts.ParamsPanel = Ext.extend(Ext.form.FormPanel,{
  autoScroll: false,
  autoHeight: true,
  border: false,
  layout: "form",
  hideCheckBoxLabels: true,
  frame: true,
  bodyBorder: false,
  labelAlign: "top",
  initComponent : function() {
    var containing_panel = this;
    var user1598 = new Lino.TwinCombo({ "fieldLabel": "Utilisateur", "name": "user", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.users.Users.detail)}, "emptyText": "Choisir Utilisateur...", "selectOnFocus": true, "hiddenName": "userHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/jobs/Contracts/user", "method": "GET" }) }) });
    var type1599 = new Lino.TwinCombo({ "fieldLabel": "Uniquement contrats de type", "name": "type", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.jobs.ContractTypes.detail)}, "emptyText": "Choisir Type de contrat de travail...", "selectOnFocus": true, "hiddenName": "typeHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/jobs/Contracts/type", "method": "GET" }) }) });
    var start_date1600 = new Lino.DateField({ "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("P\u00e9riode du","Date d\u00e9but de la p\u00e9riode observ\u00e9e") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">P\u00e9riode du</span>", "anchor": "-20", "name": "start_date" });
    var end_date1601 = new Lino.DateField({ "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("au ","Date fin de la p\u00e9riode observ\u00e9e") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">au </span>", "anchor": "-20", "name": "end_date" });
    var observed_event1602 = new Lino.ChoicesFieldElement({ "forceSelection": true, "fieldLabel": "Observed event", "name": "observed_event", "selectOnFocus": true, "anchor": "-20", "store": Lino.isip.ContractEvents, "hiddenName": "observed_eventHidden" });
    var main_1_panel1603 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 22, "autoHeight": true, "layout": "form", "xtype": "panel", "items": user1598, "labelAlign": "top" }, { "flex": 29, "autoHeight": true, "layout": "form", "xtype": "panel", "items": type1599, "labelAlign": "top" }, { "flex": 11, "autoHeight": true, "layout": "form", "xtype": "panel", "items": start_date1600, "labelAlign": "top" }, { "flex": 11, "autoHeight": true, "layout": "form", "xtype": "panel", "items": end_date1601, "labelAlign": "top" }, { "flex": 25, "autoHeight": true, "layout": "form", "xtype": "panel", "items": observed_event1602, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 252, "border": false, "anchor": "-20", "labelAlign": "top" });
    var ending_success1609 = new Lino.ChoicesFieldElement({ "forceSelection": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Successfully ended</span>", "name": "ending_success", "hiddenName": "ending_successHidden", "listeners": { "render": Lino.quicktip_renderer("Successfully ended","Contrats termin\u00e9s avec succ\u00e8s.") }, "selectOnFocus": true, "anchor": "-20", "store": Lino.lino.YesNo });
    var ending1610 = new Lino.TwinCombo({ "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Cause d'abandon</span>", "name": "ending", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.isip.ContractEndings.detail)}, "emptyText": "Choisir Cause d'abandon...", "listeners": { "render": Lino.quicktip_renderer("Cause d'abandon","Nur Konventionen mit diesem Beendigungsgrund.") }, "selectOnFocus": true, "hiddenName": "endingHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/jobs/Contracts/ending", "method": "GET" }) }) });
    var main_2_panel1611 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 25, "autoHeight": true, "layout": "form", "xtype": "panel", "items": ending_success1609, "labelAlign": "top" }, { "flex": 74, "autoHeight": true, "layout": "form", "xtype": "panel", "items": ending1610, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 171, "border": false, "anchor": "-20", "labelAlign": "top" });
    this.items = [ main_1_panel1603, main_2_panel1611 ];
    this.fields = [ user1598, type1599, start_date1600, end_date1601, observed_event1602, ending_success1609, ending1610 ];
    Lino.jobs.Contracts.ParamsPanel.superclass.initComponent.call(this);
  }
});


Lino.pcsw.CoachingsByClient.ParamsPanel = Ext.extend(Ext.form.FormPanel,{
  autoScroll: false,
  autoHeight: true,
  border: false,
  layout: "form",
  hideCheckBoxLabels: true,
  frame: true,
  bodyBorder: false,
  labelAlign: "top",
  initComponent : function() {
    var containing_panel = this;
    var start_date343 = new Lino.DateField({ "listeners": { "render": Lino.quicktip_renderer("P\u00e9riode du","Date d\u00e9but de la p\u00e9riode observ\u00e9e") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">P\u00e9riode du</span>", "name": "start_date", "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var end_date344 = new Lino.DateField({ "listeners": { "render": Lino.quicktip_renderer("au ","Date fin de la p\u00e9riode observ\u00e9e") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">au </span>", "name": "end_date", "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var observed_event345 = new Lino.ChoicesFieldElement({ "forceSelection": true, "fieldLabel": "Observed event", "name": "observed_event", "selectOnFocus": true, "anchor": "-20", "store": Lino.pcsw.CoachingEvents, "hiddenName": "observed_eventHidden" });
    var coached_by346 = new Lino.TwinCombo({ "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">AI</span>", "name": "coached_by", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.users.Users.detail)}, "emptyText": "Choisir Utilisateur...", "listeners": { "render": Lino.quicktip_renderer("AI","Nur Begleitungen dieses Benutzers.") }, "selectOnFocus": true, "hiddenName": "coached_byHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/pcsw/Coachings/coached_by", "method": "GET" }) }) });
    var and_coached_by347 = new Lino.TwinCombo({ "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">et par</span>", "name": "and_coached_by", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.users.Users.detail)}, "emptyText": "Choisir Utilisateur...", "listeners": { "render": Lino.quicktip_renderer("et par","... und auch Begleitungen dieses Benutzers.") }, "selectOnFocus": true, "hiddenName": "and_coached_byHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/pcsw/Coachings/and_coached_by", "method": "GET" }) }) });
    var main_1_panel348 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 14, "autoHeight": true, "layout": "form", "xtype": "panel", "items": start_date343, "labelAlign": "top" }, { "flex": 14, "autoHeight": true, "layout": "form", "xtype": "panel", "items": end_date344, "labelAlign": "top" }, { "flex": 19, "autoHeight": true, "layout": "form", "xtype": "panel", "items": observed_event345, "labelAlign": "top" }, { "flex": 26, "autoHeight": true, "layout": "form", "xtype": "panel", "items": coached_by346, "labelAlign": "top" }, { "flex": 26, "autoHeight": true, "layout": "form", "xtype": "panel", "items": and_coached_by347, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 135, "border": false, "anchor": "-20", "labelAlign": "top" });
    var primary_coachings354 = new Lino.ChoicesFieldElement({ "forceSelection": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Primary coachings</span>", "name": "primary_coachings", "hiddenName": "primary_coachingsHidden", "listeners": { "render": Lino.quicktip_renderer("Primary coachings","Accompagnements primaires.") }, "selectOnFocus": true, "anchor": "-20", "store": Lino.lino.YesNo });
    var coaching_type355 = new Lino.RemoteComboFieldElement({ "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Service</span>", "name": "coaching_type", "pageSize": 20, "emptyText": "Choisir Service...", "listeners": { "render": Lino.quicktip_renderer("Service","Nur Begleitungen dieses Dienstes.") }, "selectOnFocus": true, "hiddenName": "coaching_typeHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/pcsw/Coachings/coaching_type", "method": "GET" }) }) });
    var ending356 = new Lino.TwinCombo({ "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Cause d'abandon</span>", "name": "ending", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.pcsw.CoachingEndings.detail)}, "emptyText": "Choisir Cause d'abandon...", "listeners": { "render": Lino.quicktip_renderer("Cause d'abandon","Nur Begleitungen mit diesem Beendigungsgrund.") }, "selectOnFocus": true, "hiddenName": "endingHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/pcsw/Coachings/ending", "method": "GET" }) }) });
    var main_2_panel357 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 14, "autoHeight": true, "layout": "form", "xtype": "panel", "items": primary_coachings354, "labelAlign": "top" }, { "flex": 42, "autoHeight": true, "layout": "form", "xtype": "panel", "items": coaching_type355, "labelAlign": "top" }, { "flex": 42, "autoHeight": true, "layout": "form", "xtype": "panel", "items": ending356, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 162, "border": false, "anchor": "-20", "labelAlign": "top" });
    this.items = [ main_1_panel348, main_2_panel357 ];
    this.fields = [ start_date343, end_date344, observed_event345, coached_by346, and_coached_by347, primary_coachings354, coaching_type355, ending356 ];
    Lino.pcsw.CoachingsByClient.ParamsPanel.superclass.initComponent.call(this);
  }
});


Lino.jobs.JobsOverview.ParamsPanel = Ext.extend(Ext.form.FormPanel,{
  autoHeight: true,
  layout: "hbox",
  frame: true,
  layoutConfig: { "align": "stretchmax" },
  hideCheckBoxLabels: true,
  autoScroll: false,
  labelWidth: 243,
  border: false,
  bodyBorder: false,
  labelAlign: "top",
  initComponent : function() {
    var containing_panel = this;
    var contract_type2543 = new Lino.TwinCombo({ "fieldLabel": "Type de contrat de travail", "name": "contract_type", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.jobs.ContractTypes.detail)}, "emptyText": "Choisir Type de contrat de travail...", "selectOnFocus": true, "hiddenName": "contract_typeHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/jobs/JobsOverview/contract_type", "method": "GET" }) }) });
    var date2544 = new Lino.DateField({ "selectOnFocus": true, "fieldLabel": "Date", "anchor": "-20", "name": "date" });
    var job_type2545 = new Lino.TwinCombo({ "fieldLabel": "Type d'emploi", "name": "job_type", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.jobs.JobTypes.detail)}, "emptyText": "Choisir Type d'emploi...", "selectOnFocus": true, "hiddenName": "job_typeHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/jobs/JobsOverview/job_type", "method": "GET" }) }) });
    this.items = [ { "flex": 41, "autoHeight": true, "layout": "form", "xtype": "panel", "items": contract_type2543, "labelAlign": "top" }, { "flex": 16, "autoHeight": true, "layout": "form", "xtype": "panel", "items": date2544, "labelAlign": "top" }, { "flex": 41, "autoHeight": true, "layout": "form", "xtype": "panel", "items": job_type2545, "labelAlign": "top" } ];
    this.fields = [ contract_type2543, date2544, job_type2545 ];
    Lino.jobs.JobsOverview.ParamsPanel.superclass.initComponent.call(this);
  }
});


Lino.jobs.NewJobsOverview.ParamsPanel = Ext.extend(Ext.form.FormPanel,{
  autoHeight: true,
  layout: "hbox",
  frame: true,
  layoutConfig: { "align": "stretchmax" },
  hideCheckBoxLabels: true,
  autoScroll: false,
  labelWidth: 126,
  border: false,
  bodyBorder: false,
  labelAlign: "top",
  initComponent : function() {
    var containing_panel = this;
    var job_type2552 = new Lino.TwinCombo({ "fieldLabel": "Type d'emploi", "name": "job_type", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.jobs.JobTypes.detail)}, "emptyText": "Choisir Type d'emploi...", "selectOnFocus": true, "hiddenName": "job_typeHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/jobs/NewJobsOverview/job_type", "method": "GET" }) }) });
    var today2553 = new Lino.DateField({ "selectOnFocus": true, "fieldLabel": "Date", "anchor": "-20", "name": "today" });
    this.items = [ { "flex": 71, "autoHeight": true, "layout": "form", "xtype": "panel", "items": job_type2552, "labelAlign": "top" }, { "flex": 28, "autoHeight": true, "layout": "form", "xtype": "panel", "items": today2553, "labelAlign": "top" } ];
    this.fields = [ job_type2552, today2553 ];
    Lino.jobs.NewJobsOverview.ParamsPanel.superclass.initComponent.call(this);
  }
});


Lino.courses.PendingCourseRequests.ParamsPanel = Ext.extend(Ext.form.FormPanel,{
  autoScroll: false,
  autoHeight: true,
  border: false,
  layout: "form",
  hideCheckBoxLabels: true,
  frame: true,
  bodyBorder: false,
  labelAlign: "top",
  initComponent : function() {
    var containing_panel = this;
    var aged_from2211 = new Ext.form.NumberField({ "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Age: de","Nur Klienten, die mindestens so alt sind.") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Age: de</span>", "anchor": "-20", "name": "aged_from" });
    var aged_to2212 = new Ext.form.NumberField({ "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Age: jusque","Nur Klienten, die h\u00f6chstens so alt sind.") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Age: jusque</span>", "anchor": "-20", "name": "aged_to" });
    var gender2213 = new Lino.ChoicesFieldElement({ "forceSelection": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Sexe</span>", "name": "gender", "hiddenName": "genderHidden", "listeners": { "render": Lino.quicktip_renderer("Sexe","Nur Personen, deren Feld \"Geschlecht\" ausgef\u00fcllt ist und dem angegebenen Wert entspricht.") }, "selectOnFocus": true, "anchor": "-20", "store": Lino.lino.Genders });
    var nationality2214 = new Lino.TwinCombo({ "fieldLabel": "Nationalit\u00e9", "name": "nationality", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.countries.Countries.detail)}, "emptyText": "Choisir Pays...", "selectOnFocus": true, "hiddenName": "nationalityHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/courses/PendingCourseRequests/nationality", "method": "GET" }) }) });
    var also_obsolete2215 = new Ext.form.Checkbox({ "boxLabel": "aussi clients obsol\u00e8tes", "listeners": { "render": Lino.quicktip_renderer("aussi clients obsol\u00e8tes","Auch Datens\u00e4tze anzeigen, die als veraltet markiert sind.") }, "hideLabel": true, "checked": false, "name": "also_obsolete", "selectOnFocus": true, "anchor": "-20" });
    var main_1_panel2216 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 9, "autoHeight": true, "layout": "form", "xtype": "panel", "items": aged_from2211, "labelAlign": "top" }, { "flex": 9, "autoHeight": true, "layout": "form", "xtype": "panel", "items": aged_to2212, "labelAlign": "top" }, { "flex": 21, "autoHeight": true, "layout": "form", "xtype": "panel", "items": gender2213, "labelAlign": "top" }, { "flex": 39, "autoHeight": true, "layout": "form", "xtype": "panel", "items": nationality2214, "labelAlign": "top" }, { "flex": 19, "autoHeight": true, "layout": "form", "xtype": "panel", "items": also_obsolete2215, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 216, "border": false, "anchor": "-20", "labelAlign": "top" });
    var client_state2222 = new Lino.ChoicesFieldElement({ "forceSelection": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">State</span>", "name": "client_state", "hiddenName": "client_stateHidden", "listeners": { "render": Lino.quicktip_renderer("State","Nur Klienten mit diesem Status (Aktenzustand).") }, "selectOnFocus": true, "anchor": "-20", "store": Lino.pcsw.ClientStates });
    var coached_by2223 = new Lino.TwinCombo({ "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">AI</span>", "name": "coached_by", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.users.Users.detail)}, "emptyText": "Choisir Utilisateur...", "listeners": { "render": Lino.quicktip_renderer("AI","Nur Klienten, die eine Begleitung mit diesem Benutzer haben.") }, "selectOnFocus": true, "hiddenName": "coached_byHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/courses/PendingCourseRequests/coached_by", "method": "GET" }) }) });
    var and_coached_by2224 = new Lino.TwinCombo({ "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">et par</span>", "name": "and_coached_by", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.users.Users.detail)}, "emptyText": "Choisir Utilisateur...", "listeners": { "render": Lino.quicktip_renderer("et par","Nur Klienten, die auch mit diesem Benutzer eine Begleitung haben.") }, "selectOnFocus": true, "hiddenName": "and_coached_byHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/courses/PendingCourseRequests/and_coached_by", "method": "GET" }) }) });
    var start_date2225 = new Lino.DateField({ "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("P\u00e9riode du","Date d\u00e9but de la p\u00e9riode observ\u00e9e") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">P\u00e9riode du</span>", "anchor": "-20", "name": "start_date" });
    var end_date2226 = new Lino.DateField({ "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("au ","Date fin de la p\u00e9riode observ\u00e9e") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">au </span>", "anchor": "-20", "name": "end_date" });
    var observed_event2227 = new Lino.ChoicesFieldElement({ "forceSelection": true, "fieldLabel": "Observed event", "name": "observed_event", "selectOnFocus": true, "anchor": "-20", "store": Lino.pcsw.ClientEvents, "hiddenName": "observed_eventHidden" });
    var only_primary2228 = new Ext.form.Checkbox({ "boxLabel": "Dossiers primaires seulement", "listeners": { "render": Lino.quicktip_renderer("Dossiers primaires seulement","Nur Klienten, die eine effektive <b>prim\u00e4re</b> Begleitung haben.") }, "hideLabel": true, "checked": false, "name": "only_primary", "selectOnFocus": true, "anchor": "-20" });
    var main_2_panel2229 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 14, "autoHeight": true, "layout": "form", "xtype": "panel", "items": client_state2222, "labelAlign": "top" }, { "flex": 18, "autoHeight": true, "layout": "form", "xtype": "panel", "items": coached_by2223, "labelAlign": "top" }, { "flex": 18, "autoHeight": true, "layout": "form", "xtype": "panel", "items": and_coached_by2224, "labelAlign": "top" }, { "flex": 9, "autoHeight": true, "layout": "form", "xtype": "panel", "items": start_date2225, "labelAlign": "top" }, { "flex": 9, "autoHeight": true, "layout": "form", "xtype": "panel", "items": end_date2226, "labelAlign": "top" }, { "flex": 16, "autoHeight": true, "layout": "form", "xtype": "panel", "items": observed_event2227, "labelAlign": "top" }, { "flex": 12, "autoHeight": true, "layout": "form", "xtype": "panel", "items": only_primary2228, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 261, "border": false, "anchor": "-20", "labelAlign": "top" });
    var request_state2237 = new Lino.ChoicesFieldElement({ "forceSelection": true, "fieldLabel": "State", "name": "request_state", "selectOnFocus": true, "anchor": "-20", "store": Lino.courses.CourseRequestStates, "hiddenName": "request_stateHidden" });
    var course_content2238 = new Lino.TwinCombo({ "fieldLabel": "Contenu de cours", "name": "course_content", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.courses.CourseContents.detail)}, "emptyText": "Choisir Contenu de cours...", "selectOnFocus": true, "hiddenName": "course_contentHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/courses/PendingCourseRequests/course_content", "method": "GET" }) }) });
    var course_provider2239 = new Lino.TwinCombo({ "fieldLabel": "Organisateur de cours", "name": "course_provider", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.courses.CourseProviders.detail)}, "emptyText": "Choisir Organisateur de cours...", "selectOnFocus": true, "hiddenName": "course_providerHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/courses/PendingCourseRequests/course_provider", "method": "GET" }) }) });
    var main_3_panel2240 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 31, "autoHeight": true, "layout": "form", "xtype": "panel", "items": request_state2237, "labelAlign": "top" }, { "flex": 34, "autoHeight": true, "layout": "form", "xtype": "panel", "items": course_content2238, "labelAlign": "top" }, { "flex": 34, "autoHeight": true, "layout": "form", "xtype": "panel", "items": course_provider2239, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 198, "border": false, "anchor": "-20", "labelAlign": "top" });
    this.items = [ main_1_panel2216, main_2_panel2229, main_3_panel2240 ];
    this.fields = [ aged_from2211, aged_to2212, gender2213, nationality2214, also_obsolete2215, client_state2222, coached_by2223, and_coached_by2224, start_date2225, end_date2226, observed_event2227, only_primary2228, request_state2237, course_content2238, course_provider2239 ];
    Lino.courses.PendingCourseRequests.ParamsPanel.superclass.initComponent.call(this);
  }
});


Lino.pcsw.IntegClients.ParamsPanel = Ext.extend(Ext.form.FormPanel,{
  autoScroll: false,
  autoHeight: true,
  border: false,
  layout: "form",
  hideCheckBoxLabels: true,
  frame: true,
  bodyBorder: false,
  labelAlign: "top",
  initComponent : function() {
    var containing_panel = this;
    var client_state1853 = new Lino.ChoicesFieldElement({ "forceSelection": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">State</span>", "name": "client_state", "hiddenName": "client_stateHidden", "listeners": { "render": Lino.quicktip_renderer("State","Nur Klienten mit diesem Status (Aktenzustand).") }, "selectOnFocus": true, "anchor": "-20", "store": Lino.pcsw.ClientStates });
    var coached_by1854 = new Lino.TwinCombo({ "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">AI</span>", "name": "coached_by", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.users.Users.detail)}, "emptyText": "Choisir Utilisateur...", "listeners": { "render": Lino.quicktip_renderer("AI","Nur Klienten, die eine Begleitung mit diesem Benutzer haben.") }, "selectOnFocus": true, "hiddenName": "coached_byHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/pcsw/IntegClients/coached_by", "method": "GET" }) }) });
    var and_coached_by1855 = new Lino.TwinCombo({ "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">et par</span>", "name": "and_coached_by", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.users.Users.detail)}, "emptyText": "Choisir Utilisateur...", "listeners": { "render": Lino.quicktip_renderer("et par","Nur Klienten, die auch mit diesem Benutzer eine Begleitung haben.") }, "selectOnFocus": true, "hiddenName": "and_coached_byHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/pcsw/IntegClients/and_coached_by", "method": "GET" }) }) });
    var start_date1856 = new Lino.DateField({ "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("P\u00e9riode du","Date d\u00e9but de la p\u00e9riode observ\u00e9e") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">P\u00e9riode du</span>", "anchor": "-20", "name": "start_date" });
    var end_date1857 = new Lino.DateField({ "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("au ","Date fin de la p\u00e9riode observ\u00e9e") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">au </span>", "anchor": "-20", "name": "end_date" });
    var observed_event1858 = new Lino.ChoicesFieldElement({ "forceSelection": true, "fieldLabel": "Observed event", "name": "observed_event", "selectOnFocus": true, "anchor": "-20", "store": Lino.pcsw.ClientEvents, "hiddenName": "observed_eventHidden" });
    var main_1_panel1859 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 16, "autoHeight": true, "layout": "form", "xtype": "panel", "items": client_state1853, "labelAlign": "top" }, { "flex": 21, "autoHeight": true, "layout": "form", "xtype": "panel", "items": coached_by1854, "labelAlign": "top" }, { "flex": 21, "autoHeight": true, "layout": "form", "xtype": "panel", "items": and_coached_by1855, "labelAlign": "top" }, { "flex": 11, "autoHeight": true, "layout": "form", "xtype": "panel", "items": start_date1856, "labelAlign": "top" }, { "flex": 11, "autoHeight": true, "layout": "form", "xtype": "panel", "items": end_date1857, "labelAlign": "top" }, { "flex": 18, "autoHeight": true, "layout": "form", "xtype": "panel", "items": observed_event1858, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 135, "border": false, "anchor": "-20", "labelAlign": "top" });
    var aged_from1866 = new Ext.form.NumberField({ "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Age: de","Nur Klienten, die mindestens so alt sind.") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Age: de</span>", "anchor": "-20", "name": "aged_from" });
    var aged_to1867 = new Ext.form.NumberField({ "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Age: jusque","Nur Klienten, die h\u00f6chstens so alt sind.") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Age: jusque</span>", "anchor": "-20", "name": "aged_to" });
    var gender1868 = new Lino.ChoicesFieldElement({ "forceSelection": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Sexe</span>", "name": "gender", "hiddenName": "genderHidden", "listeners": { "render": Lino.quicktip_renderer("Sexe","Nur Personen, deren Feld \"Geschlecht\" ausgef\u00fcllt ist und dem angegebenen Wert entspricht.") }, "selectOnFocus": true, "anchor": "-20", "store": Lino.lino.Genders });
    var nationality1869 = new Lino.TwinCombo({ "fieldLabel": "Nationalit\u00e9", "name": "nationality", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.countries.Countries.detail)}, "emptyText": "Choisir Pays...", "selectOnFocus": true, "hiddenName": "nationalityHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/pcsw/IntegClients/nationality", "method": "GET" }) }) });
    var also_obsolete1870 = new Ext.form.Checkbox({ "boxLabel": "aussi clients obsol\u00e8tes", "listeners": { "render": Lino.quicktip_renderer("aussi clients obsol\u00e8tes","Auch Datens\u00e4tze anzeigen, die als veraltet markiert sind.") }, "hideLabel": true, "checked": false, "name": "also_obsolete", "selectOnFocus": true, "anchor": "-20" });
    var main_2_panel1871 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 9, "autoHeight": true, "layout": "form", "xtype": "panel", "items": aged_from1866, "labelAlign": "top" }, { "flex": 9, "autoHeight": true, "layout": "form", "xtype": "panel", "items": aged_to1867, "labelAlign": "top" }, { "flex": 21, "autoHeight": true, "layout": "form", "xtype": "panel", "items": gender1868, "labelAlign": "top" }, { "flex": 39, "autoHeight": true, "layout": "form", "xtype": "panel", "items": nationality1869, "labelAlign": "top" }, { "flex": 19, "autoHeight": true, "layout": "form", "xtype": "panel", "items": also_obsolete1870, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 216, "border": false, "anchor": "-20", "labelAlign": "top" });
    var language1877 = new Lino.TwinCombo({ "fieldLabel": "Connaissance de langue", "name": "language", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.countries.Languages.detail)}, "emptyText": "Choisir Langue...", "selectOnFocus": true, "hiddenName": "languageHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/pcsw/IntegClients/language", "method": "GET" }) }) });
    var wanted_property1878 = new Lino.TwinCombo({ "fieldLabel": "Comp\u00e9tence requise", "name": "wanted_property", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.properties.Properties.detail)}, "emptyText": "Choisir Propri\u00e9t\u00e9...", "selectOnFocus": true, "hiddenName": "wanted_propertyHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/pcsw/IntegClients/wanted_property", "method": "GET" }) }) });
    var group1879 = new Lino.RemoteComboFieldElement({ "fieldLabel": "Phase d'int\u00e9gration", "name": "group", "pageSize": 20, "emptyText": "Choisir Phase d'int\u00e9gration...", "selectOnFocus": true, "hiddenName": "groupHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/pcsw/IntegClients/group", "method": "GET" }) }) });
    var only_active1880 = new Ext.form.Checkbox({ "boxLabel": "Clients actifs seulement", "listeners": { "render": Lino.quicktip_renderer("Clients actifs seulement","Show only clients in 'active' integration phases") }, "hideLabel": true, "checked": false, "name": "only_active", "selectOnFocus": true, "anchor": "-20" });
    var only_primary1881 = new Ext.form.Checkbox({ "boxLabel": "Dossiers primaires seulement", "listeners": { "render": Lino.quicktip_renderer("Dossiers primaires seulement","Nur Klienten, die eine effektive <b>prim\u00e4re</b> Begleitung haben.") }, "hideLabel": true, "checked": false, "name": "only_primary", "selectOnFocus": true, "anchor": "-20" });
    var main_3_panel1882 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 25, "autoHeight": true, "layout": "form", "xtype": "panel", "items": language1877, "labelAlign": "top" }, { "flex": 25, "autoHeight": true, "layout": "form", "xtype": "panel", "items": wanted_property1878, "labelAlign": "top" }, { "flex": 25, "autoHeight": true, "layout": "form", "xtype": "panel", "items": group1879, "labelAlign": "top" }, { "flex": 12, "autoHeight": true, "layout": "form", "xtype": "panel", "items": only_active1880, "labelAlign": "top" }, { "flex": 12, "autoHeight": true, "layout": "form", "xtype": "panel", "items": only_primary1881, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 261, "border": false, "anchor": "-20", "labelAlign": "top" });
    this.items = [ main_1_panel1859, main_2_panel1871, main_3_panel1882 ];
    this.fields = [ client_state1853, coached_by1854, and_coached_by1855, start_date1856, end_date1857, observed_event1858, aged_from1866, aged_to1867, gender1868, nationality1869, also_obsolete1870, language1877, wanted_property1878, group1879, only_active1880, only_primary1881 ];
    Lino.pcsw.IntegClients.ParamsPanel.superclass.initComponent.call(this);
  }
});


Lino.isip.Contracts.ParamsPanel = Ext.extend(Ext.form.FormPanel,{
  autoScroll: false,
  autoHeight: true,
  border: false,
  layout: "form",
  hideCheckBoxLabels: true,
  frame: true,
  bodyBorder: false,
  labelAlign: "top",
  initComponent : function() {
    var containing_panel = this;
    var user1480 = new Lino.TwinCombo({ "fieldLabel": "Utilisateur", "name": "user", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.users.Users.detail)}, "emptyText": "Choisir Utilisateur...", "selectOnFocus": true, "hiddenName": "userHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/isip/Contracts/user", "method": "GET" }) }) });
    var type1481 = new Lino.TwinCombo({ "fieldLabel": "Type de PIIS", "name": "type", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.isip.ContractTypes.detail)}, "emptyText": "Choisir Type de PIIS...", "selectOnFocus": true, "hiddenName": "typeHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/isip/Contracts/type", "method": "GET" }) }) });
    var start_date1482 = new Lino.DateField({ "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("P\u00e9riode du","Date d\u00e9but de la p\u00e9riode observ\u00e9e") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">P\u00e9riode du</span>", "anchor": "-20", "name": "start_date" });
    var end_date1483 = new Lino.DateField({ "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("au ","Date fin de la p\u00e9riode observ\u00e9e") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">au </span>", "anchor": "-20", "name": "end_date" });
    var observed_event1484 = new Lino.ChoicesFieldElement({ "forceSelection": true, "fieldLabel": "Observed event", "name": "observed_event", "selectOnFocus": true, "anchor": "-20", "store": Lino.isip.ContractEvents, "hiddenName": "observed_eventHidden" });
    var main_1_panel1485 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 22, "autoHeight": true, "layout": "form", "xtype": "panel", "items": user1480, "labelAlign": "top" }, { "flex": 29, "autoHeight": true, "layout": "form", "xtype": "panel", "items": type1481, "labelAlign": "top" }, { "flex": 11, "autoHeight": true, "layout": "form", "xtype": "panel", "items": start_date1482, "labelAlign": "top" }, { "flex": 11, "autoHeight": true, "layout": "form", "xtype": "panel", "items": end_date1483, "labelAlign": "top" }, { "flex": 25, "autoHeight": true, "layout": "form", "xtype": "panel", "items": observed_event1484, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 135, "border": false, "anchor": "-20", "labelAlign": "top" });
    var company1491 = new Lino.TwinCombo({ "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Organisation</span>", "name": "company", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.contacts.Companies.detail)}, "emptyText": "Choisir Organisation...", "listeners": { "render": Lino.quicktip_renderer("Organisation","Nur Konventionen mit dieser Organisation als Drittpartner.") }, "selectOnFocus": true, "hiddenName": "companyHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/isip/Contracts/company", "method": "GET" }) }) });
    var study_type1492 = new Lino.TwinCombo({ "fieldLabel": "Type d'\u00e9tude", "name": "study_type", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.isip.StudyTypes.detail)}, "emptyText": "Choisir Type d'\u00e9tude...", "selectOnFocus": true, "hiddenName": "study_typeHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/isip/Contracts/study_type", "method": "GET" }) }) });
    var ending_success1493 = new Lino.ChoicesFieldElement({ "forceSelection": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Successfully ended</span>", "name": "ending_success", "hiddenName": "ending_successHidden", "listeners": { "render": Lino.quicktip_renderer("Successfully ended","Contrats termin\u00e9s avec succ\u00e8s.") }, "selectOnFocus": true, "anchor": "-20", "store": Lino.lino.YesNo });
    var ending1494 = new Lino.TwinCombo({ "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Cause d'abandon</span>", "name": "ending", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.isip.ContractEndings.detail)}, "emptyText": "Choisir Cause d'abandon...", "listeners": { "render": Lino.quicktip_renderer("Cause d'abandon","Nur Konventionen mit diesem Beendigungsgrund.") }, "selectOnFocus": true, "hiddenName": "endingHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/isip/Contracts/ending", "method": "GET" }) }) });
    var main_2_panel1495 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 26, "autoHeight": true, "layout": "form", "xtype": "panel", "items": company1491, "labelAlign": "top" }, { "flex": 20, "autoHeight": true, "layout": "form", "xtype": "panel", "items": study_type1492, "labelAlign": "top" }, { "flex": 26, "autoHeight": true, "layout": "form", "xtype": "panel", "items": ending_success1493, "labelAlign": "top" }, { "flex": 26, "autoHeight": true, "layout": "form", "xtype": "panel", "items": ending1494, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 171, "border": false, "anchor": "-20", "labelAlign": "top" });
    this.items = [ main_1_panel1485, main_2_panel1495 ];
    this.fields = [ user1480, type1481, start_date1482, end_date1483, observed_event1484, company1491, study_type1492, ending_success1493, ending1494 ];
    Lino.isip.Contracts.ParamsPanel.superclass.initComponent.call(this);
  }
});


Lino.pcsw.Clients.ParamsPanel = Ext.extend(Ext.form.FormPanel,{
  autoScroll: false,
  autoHeight: true,
  border: false,
  layout: "form",
  hideCheckBoxLabels: true,
  frame: true,
  bodyBorder: false,
  labelAlign: "top",
  initComponent : function() {
    var containing_panel = this;
    var aged_from1826 = new Ext.form.NumberField({ "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Age: de","Nur Klienten, die mindestens so alt sind.") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Age: de</span>", "anchor": "-20", "name": "aged_from" });
    var aged_to1827 = new Ext.form.NumberField({ "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Age: jusque","Nur Klienten, die h\u00f6chstens so alt sind.") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Age: jusque</span>", "anchor": "-20", "name": "aged_to" });
    var gender1828 = new Lino.ChoicesFieldElement({ "forceSelection": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Sexe</span>", "name": "gender", "hiddenName": "genderHidden", "listeners": { "render": Lino.quicktip_renderer("Sexe","Nur Personen, deren Feld \"Geschlecht\" ausgef\u00fcllt ist und dem angegebenen Wert entspricht.") }, "selectOnFocus": true, "anchor": "-20", "store": Lino.lino.Genders });
    var nationality1829 = new Lino.TwinCombo({ "fieldLabel": "Nationalit\u00e9", "name": "nationality", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.countries.Countries.detail)}, "emptyText": "Choisir Pays...", "selectOnFocus": true, "hiddenName": "nationalityHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/pcsw/Clients/nationality", "method": "GET" }) }) });
    var also_obsolete1830 = new Ext.form.Checkbox({ "boxLabel": "aussi clients obsol\u00e8tes", "listeners": { "render": Lino.quicktip_renderer("aussi clients obsol\u00e8tes","Auch Datens\u00e4tze anzeigen, die als veraltet markiert sind.") }, "hideLabel": true, "checked": false, "name": "also_obsolete", "selectOnFocus": true, "anchor": "-20" });
    var main_1_panel1831 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 9, "autoHeight": true, "layout": "form", "xtype": "panel", "items": aged_from1826, "labelAlign": "top" }, { "flex": 9, "autoHeight": true, "layout": "form", "xtype": "panel", "items": aged_to1827, "labelAlign": "top" }, { "flex": 21, "autoHeight": true, "layout": "form", "xtype": "panel", "items": gender1828, "labelAlign": "top" }, { "flex": 39, "autoHeight": true, "layout": "form", "xtype": "panel", "items": nationality1829, "labelAlign": "top" }, { "flex": 19, "autoHeight": true, "layout": "form", "xtype": "panel", "items": also_obsolete1830, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 216, "border": false, "anchor": "-20", "labelAlign": "top" });
    var client_state1837 = new Lino.ChoicesFieldElement({ "forceSelection": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">State</span>", "name": "client_state", "hiddenName": "client_stateHidden", "listeners": { "render": Lino.quicktip_renderer("State","Nur Klienten mit diesem Status (Aktenzustand).") }, "selectOnFocus": true, "anchor": "-20", "store": Lino.pcsw.ClientStates });
    var coached_by1838 = new Lino.TwinCombo({ "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">AI</span>", "name": "coached_by", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.users.Users.detail)}, "emptyText": "Choisir Utilisateur...", "listeners": { "render": Lino.quicktip_renderer("AI","Nur Klienten, die eine Begleitung mit diesem Benutzer haben.") }, "selectOnFocus": true, "hiddenName": "coached_byHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/pcsw/Clients/coached_by", "method": "GET" }) }) });
    var and_coached_by1839 = new Lino.TwinCombo({ "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">et par</span>", "name": "and_coached_by", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.users.Users.detail)}, "emptyText": "Choisir Utilisateur...", "listeners": { "render": Lino.quicktip_renderer("et par","Nur Klienten, die auch mit diesem Benutzer eine Begleitung haben.") }, "selectOnFocus": true, "hiddenName": "and_coached_byHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/pcsw/Clients/and_coached_by", "method": "GET" }) }) });
    var start_date1840 = new Lino.DateField({ "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("P\u00e9riode du","Date d\u00e9but de la p\u00e9riode observ\u00e9e") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">P\u00e9riode du</span>", "anchor": "-20", "name": "start_date" });
    var end_date1841 = new Lino.DateField({ "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("au ","Date fin de la p\u00e9riode observ\u00e9e") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">au </span>", "anchor": "-20", "name": "end_date" });
    var observed_event1842 = new Lino.ChoicesFieldElement({ "forceSelection": true, "fieldLabel": "Observed event", "name": "observed_event", "selectOnFocus": true, "anchor": "-20", "store": Lino.pcsw.ClientEvents, "hiddenName": "observed_eventHidden" });
    var only_primary1843 = new Ext.form.Checkbox({ "boxLabel": "Dossiers primaires seulement", "listeners": { "render": Lino.quicktip_renderer("Dossiers primaires seulement","Nur Klienten, die eine effektive <b>prim\u00e4re</b> Begleitung haben.") }, "hideLabel": true, "checked": false, "name": "only_primary", "selectOnFocus": true, "anchor": "-20" });
    var main_2_panel1844 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 14, "autoHeight": true, "layout": "form", "xtype": "panel", "items": client_state1837, "labelAlign": "top" }, { "flex": 18, "autoHeight": true, "layout": "form", "xtype": "panel", "items": coached_by1838, "labelAlign": "top" }, { "flex": 18, "autoHeight": true, "layout": "form", "xtype": "panel", "items": and_coached_by1839, "labelAlign": "top" }, { "flex": 9, "autoHeight": true, "layout": "form", "xtype": "panel", "items": start_date1840, "labelAlign": "top" }, { "flex": 9, "autoHeight": true, "layout": "form", "xtype": "panel", "items": end_date1841, "labelAlign": "top" }, { "flex": 16, "autoHeight": true, "layout": "form", "xtype": "panel", "items": observed_event1842, "labelAlign": "top" }, { "flex": 12, "autoHeight": true, "layout": "form", "xtype": "panel", "items": only_primary1843, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 261, "border": false, "anchor": "-20", "labelAlign": "top" });
    this.items = [ main_1_panel1831, main_2_panel1844 ];
    this.fields = [ aged_from1826, aged_to1827, gender1828, nationality1829, also_obsolete1830, client_state1837, coached_by1838, and_coached_by1839, start_date1840, end_date1841, observed_event1842, only_primary1843 ];
    Lino.pcsw.Clients.ParamsPanel.superclass.initComponent.call(this);
  }
});


Lino.pcsw.Clients.wf2_ActionFormPanel = Ext.extend(Lino.ActionFormPanel,{
  autoScroll: false,
  border: false,
  layout: "vbox",
  labelWidth: 90,
  hideCheckBoxLabels: true,
  frame: true,
  layoutConfig: { "align": "stretch" },
  bodyBorder: false,
  labelAlign: "top",
  action_name: 'wf2',
  window_title: "Refuser",
  initComponent : function() {
    var containing_panel = this;
    var reason13 = new Lino.ChoicesFieldElement({ "forceSelection": true, "fieldLabel": "reason", "allowBlank": false, "hiddenName": "reasonHidden", "selectOnFocus": true, "anchor": "-20", "store": Lino.pcsw.RefusalReasons, "name": "reason" });
    var remark14 = new Ext.form.TextArea({ "selectOnFocus": true, "fieldLabel": "Remarque", "anchor": "-20 -10", "growMax": 2000, "name": "remark" });
    this.items = [ { "items": reason13, "autoHeight": true, "layout": "form", "xtype": "panel", "labelAlign": "top" }, { "items": remark14, "labelAlign": "top", "layout": "form", "xtype": "panel", "flex": 83 } ];
    this.fields = [ reason13, remark14 ];
    Lino.pcsw.Clients.wf2_ActionFormPanel.superclass.initComponent.call(this);
  }
});


Lino.cal.GuestsByEvent.wf2_ActionFormPanel = Ext.extend(Lino.ActionFormPanel,{
  autoScroll: false,
  border: false,
  layout: "vbox",
  labelWidth: 387,
  hideCheckBoxLabels: true,
  frame: true,
  layoutConfig: { "align": "stretch" },
  bodyBorder: false,
  labelAlign: "top",
  action_name: 'wf2',
  window_title: "Rejeter",
  initComponent : function() {
    var containing_panel = this;
    var notify_subject6 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200, "fieldLabel": "R\u00e9sum\u00e9", "anchor": "-20", "name": "notify_subject" });
    var notify_body7 = new Ext.form.TextArea({ "selectOnFocus": true, "fieldLabel": "Description", "anchor": "-20 -10", "growMax": 2000, "name": "notify_body" });
    var notify_silent8 = new Ext.form.Checkbox({ "boxLabel": "Don't send email notification", "hideLabel": true, "checked": false, "name": "notify_silent", "selectOnFocus": true, "anchor": "-20" });
    this.items = [ { "items": notify_subject6, "autoHeight": true, "layout": "form", "xtype": "panel", "labelAlign": "top" }, { "items": notify_body7, "labelAlign": "top", "layout": "form", "xtype": "panel", "flex": 71 }, { "items": notify_silent8, "autoHeight": true, "layout": "form", "xtype": "panel", "labelAlign": "top" } ];
    this.fields = [ notify_subject6, notify_body7, notify_silent8 ];
    Lino.cal.GuestsByEvent.wf2_ActionFormPanel.superclass.initComponent.call(this);
  }
});


Lino.contacts.Companies.merge_row_ActionFormPanel = Ext.extend(Lino.ActionFormPanel,{
  autoScroll: false,
  autoHeight: true,
  border: false,
  layout: "form",
  labelWidth: 99,
  hideCheckBoxLabels: true,
  frame: true,
  bodyBorder: false,
  labelAlign: "top",
  action_name: 'merge_row',
  window_title: "Fusionieren",
  autoHeight: true,
  initComponent : function() {
    var containing_panel = this;
    var merge_to1 = new Lino.TwinCombo({ "fieldLabel": "nach...", "allowBlank": false, "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.contacts.Companies.detail)}, "emptyText": "Choisir Organisation...", "selectOnFocus": true, "hiddenName": "merge_toHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/apchoices/contacts/Companies/merge_row/merge_to", "method": "GET" }) }), "name": "merge_to" });
    var reason2 = new Ext.form.TextField({ "fieldLabel": "Begr\u00fcndung", "name": "reason", "maxLength": 100, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    this.items = [ { "autoHeight": true, "layout": "form", "xtype": "panel", "items": merge_to1, "anchor": "-20", "labelAlign": "top" }, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": reason2, "anchor": "-20", "labelAlign": "top" } ];
    this.fields = [ merge_to1, reason2 ];
    Lino.contacts.Companies.merge_row_ActionFormPanel.superclass.initComponent.call(this);
  }
});


Lino.pcsw.Clients.merge_row_ActionFormPanel = Ext.extend(Lino.ActionFormPanel,{
  autoScroll: false,
  autoHeight: true,
  border: false,
  layout: "form",
  labelWidth: 99,
  hideCheckBoxLabels: true,
  frame: true,
  bodyBorder: false,
  labelAlign: "top",
  action_name: 'merge_row',
  window_title: "Fusionieren",
  autoHeight: true,
  initComponent : function() {
    var containing_panel = this;
    var merge_to18 = new Lino.TwinCombo({ "fieldLabel": "nach...", "allowBlank": false, "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.pcsw.Clients.detail)}, "emptyText": "Choisir Client...", "selectOnFocus": true, "hiddenName": "merge_toHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/apchoices/pcsw/Clients/merge_row/merge_to", "method": "GET" }) }), "name": "merge_to" });
    var pcsw_Dispense19 = new Ext.form.Checkbox({ "boxLabel": "Dispenses", "hideLabel": true, "checked": false, "name": "pcsw_Dispense", "selectOnFocus": true, "anchor": "-20" });
    var pcsw_Coaching20 = new Ext.form.Checkbox({ "boxLabel": "Accompagnements", "hideLabel": true, "checked": false, "name": "pcsw_Coaching", "selectOnFocus": true, "anchor": "-20" });
    var keep_volatiles_1_panel21 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": pcsw_Dispense19, "labelAlign": "top" }, { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": pcsw_Coaching20, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 117, "border": false, "anchor": "-20", "labelAlign": "top" });
    var cv_LanguageKnowledge24 = new Ext.form.Checkbox({ "boxLabel": "Connaissances de langue", "hideLabel": true, "checked": false, "name": "cv_LanguageKnowledge", "selectOnFocus": true, "anchor": "-20" });
    var properties_PersonProperty25 = new Ext.form.Checkbox({ "boxLabel": "Propri\u00e9t\u00e9s", "hideLabel": true, "checked": false, "name": "properties_PersonProperty", "selectOnFocus": true, "anchor": "-20" });
    var keep_volatiles_2_panel26 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": cv_LanguageKnowledge24, "labelAlign": "top" }, { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": properties_PersonProperty25, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 153, "border": false, "anchor": "-20", "labelAlign": "top" });
    var keep_volatiles_panel29 = new Ext.form.FieldSet({ "autoHeight": true, "layout": "form", "title": "Auch verg\u00e4ngliche verkn\u00fcpfte Objekte \u00fcberweisen", "items": [ keep_volatiles_1_panel21, keep_volatiles_2_panel26 ], "frame": true, "bodyBorder": false, "autoScroll": false, "hideCheckBoxLabels": true, "border": false, "anchor": "-20", "labelAlign": "top" });
    var reason30 = new Ext.form.TextField({ "fieldLabel": "Begr\u00fcndung", "name": "reason", "maxLength": 100, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    this.items = [ { "autoHeight": true, "layout": "form", "xtype": "panel", "items": merge_to18, "anchor": "-20", "labelAlign": "top" }, keep_volatiles_panel29, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": reason30, "anchor": "-20", "labelAlign": "top" } ];
    this.fields = [ merge_to18, pcsw_Dispense19, pcsw_Coaching20, cv_LanguageKnowledge24, properties_PersonProperty25, reason30 ];
    Lino.pcsw.Clients.merge_row_ActionFormPanel.superclass.initComponent.call(this);
  }
});


Lino.jobs.Contracts.InsertFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  autoHeight: true,
  content_type: 71,
  initComponent : function() {
    var containing_panel = this;
    var client1676 = new Lino.TwinCombo({ "fieldLabel": "Client", "allowBlank": false, "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.pcsw.Clients.detail)}, "emptyText": "Choisir Client...", "selectOnFocus": true, "hiddenName": "clientHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/jobs/Contracts/client", "method": "GET" }) }), "name": "client" });
    var job1677 = new Lino.TwinCombo({ "fieldLabel": "Emploi", "allowBlank": false, "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.jobs.Jobs.detail)}, "emptyText": "Choisir Emploi...", "selectOnFocus": true, "hiddenName": "jobHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/jobs/Contracts/job", "method": "GET" }) }), "name": "job" });
    var main_panel1678 = new Ext.Panel({ "hideCheckBoxLabels": true, "autoHeight": true, "border": false, "layout": "form", "labelWidth": 63, "autoScroll": false, "items": [ { "autoHeight": true, "layout": "form", "xtype": "panel", "items": client1676, "anchor": "-20", "labelAlign": "top" }, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": job1677, "anchor": "-20", "labelAlign": "top" } ], "frame": true, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel1678;
    this.before_row_edit = function(record) {
    }
    Lino.jobs.Contracts.InsertFormPanel.superclass.initComponent.call(this);
    // active_fields:
    job1677.on("change",function(){this.save()},this);
  }
});


Lino.uploads.MyUploads.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 26,
  initComponent : function() {
    var containing_panel = this;
    var file2473 = Lino.file_field_handler(this,{ "fieldLabel": "Datei", "name": "file", "maxLength": 100, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var user2474 = new Lino.TwinCombo({ "fieldLabel": "Auteur", "name": "user", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.users.Users.detail)}, "emptyText": "Choisir Utilisateur...", "selectOnFocus": true, "hiddenName": "userHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/uploads/Uploads/user", "method": "GET" }) }) });
    var main_1_panel2475 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 63, "hideCheckBoxLabels": true, "items": [ { "flex": 58, "autoHeight": true, "layout": "form", "xtype": "panel", "items": file2473, "labelAlign": "top" }, { "flex": 41, "autoHeight": true, "layout": "form", "xtype": "panel", "items": user2474, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var type2478 = new Lino.RemoteComboFieldElement({ "fieldLabel": "Type d'upload", "name": "type", "pageSize": 20, "emptyText": "Choisir Type d'upload...", "selectOnFocus": true, "hiddenName": "typeHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/uploads/Uploads/type", "method": "GET" }) }) });
    var description2479 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200, "fieldLabel": "Description", "anchor": "-20", "name": "description" });
    var valid_until2480 = new Lino.DateField({ "selectOnFocus": true, "fieldLabel": "expire le", "anchor": "-20", "name": "valid_until" });
    var main_2_panel2481 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 126, "hideCheckBoxLabels": true, "items": [ { "flex": 40, "autoHeight": true, "layout": "form", "xtype": "panel", "items": type2478, "labelAlign": "top" }, { "flex": 42, "autoHeight": true, "layout": "form", "xtype": "panel", "items": description2479, "labelAlign": "top" }, { "flex": 16, "autoHeight": true, "layout": "form", "xtype": "panel", "items": valid_until2480, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var modified2485 = new Ext.form.DisplayField({ "disabled": true, "fieldLabel": "Modified", "anchor": "-20", "value": "<br>", "name": "modified" });
    var created2486 = new Ext.form.DisplayField({ "disabled": true, "fieldLabel": "Cr\u00e9\u00e9", "anchor": "-20", "value": "<br>", "name": "created" });
    var owner_disp2487 = new Ext.form.DisplayField({ "disabled": true, "fieldLabel": "Contr\u00f4l\u00e9 par", "anchor": "-20", "name": "owner" });
    var main_3_panel2488 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 117, "hideCheckBoxLabels": true, "items": [ { "flex": 38, "autoHeight": true, "layout": "form", "xtype": "panel", "items": modified2485, "labelAlign": "top" }, { "flex": 38, "autoHeight": true, "layout": "form", "xtype": "panel", "items": created2486, "labelAlign": "top" }, { "flex": 23, "autoHeight": true, "layout": "form", "xtype": "panel", "items": owner_disp2487, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var cal_TasksByController_grid2492 = new Lino.cal.TasksByController.GridPanel({ "tools": [ Lino.show_in_own_window_button(Lino.cal.TasksByController.grid) ], "containing_panel": this, "hide_top_toolbar": true, "master_panel": this, "flex": 62 });
    var main_panel2493 = new Ext.Panel({ "autoScroll": false, "border": false, "layout": "vbox", "hideCheckBoxLabels": true, "items": [ main_1_panel2475, main_2_panel2481, main_3_panel2488, cal_TasksByController_grid2492 ], "frame": true, "layoutConfig": { "align": "stretch" }, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel2493;
    this.before_row_edit = function(record) {
      cal_TasksByController_grid2492.on_master_changed();
    }
    Lino.uploads.MyUploads.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.countries.Countries.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 11,
  initComponent : function() {
    var containing_panel = this;
    var isocode402 = new Ext.form.TextField({ "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">ISO code</span>", "name": "isocode", "boxMinWidth": Lino.chars2width(4), "listeners": { "render": Lino.quicktip_renderer("ISO code","        The two-letter code for this country as defined by ISO 3166-1. \n        For countries that no longer exist it may be a 4-letter code.") }, "maxLength": 4, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var name403 = new Ext.form.TextField({ "fieldLabel": "Description", "name": "name", "maxLength": 200, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var name_fr404 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200, "fieldLabel": "Description (fr)", "anchor": "-20", "name": "name_fr" });
    var name_nl405 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200, "fieldLabel": "Description (nl)", "anchor": "-20", "name": "name_nl" });
    var short_code406 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Short code","A short abbreviation for regional usage. Obsolete.") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Short code</span>", "name": "short_code", "maxLength": 4, "selectOnFocus": true, "boxMinWidth": Lino.chars2width(4), "anchor": "-20" });
    var inscode407 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("INS code","The official code for this country used by statbel.fgov.be") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">INS code</span>", "name": "inscode", "maxLength": 3, "selectOnFocus": true, "boxMinWidth": Lino.chars2width(3), "anchor": "-20" });
    var main_1_panel408 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 153, "hideCheckBoxLabels": true, "items": [ { "flex": 6, "autoHeight": true, "layout": "form", "xtype": "panel", "items": isocode402, "labelAlign": "top" }, { "flex": 27, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name403, "labelAlign": "top" }, { "flex": 27, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_fr404, "labelAlign": "top" }, { "flex": 27, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_nl405, "labelAlign": "top" }, { "flex": 6, "autoHeight": true, "layout": "form", "xtype": "panel", "items": short_code406, "labelAlign": "top" }, { "flex": 5, "autoHeight": true, "layout": "form", "xtype": "panel", "items": inscode407, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var countries_CitiesByCountry_grid731 = new Lino.countries.CitiesByCountry.GridPanel({ "tools": [ Lino.show_in_own_window_button(Lino.countries.CitiesByCountry.grid) ], "containing_panel": this, "hide_top_toolbar": true, "master_panel": this, "flex": 48 });
    var jobs_StudiesByCountry_grid744 = new Lino.jobs.StudiesByCountry.GridPanel({ "tools": [ Lino.show_in_own_window_button(Lino.jobs.StudiesByCountry.grid) ], "containing_panel": this, "hide_top_toolbar": true, "master_panel": this, "flex": 51 });
    var main_2_panel745 = new Ext.Panel({ "flex": 83, "border": false, "layout": "hbox", "hideCheckBoxLabels": true, "items": [ countries_CitiesByCountry_grid731, jobs_StudiesByCountry_grid744 ], "autoScroll": false, "layoutConfig": { "align": "stretch" }, "frame": false, "labelAlign": "top" });
    var main_panel746 = new Ext.Panel({ "autoScroll": false, "border": false, "layout": "vbox", "hideCheckBoxLabels": true, "items": [ main_1_panel408, main_2_panel745 ], "frame": true, "layoutConfig": { "align": "stretch" }, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel746;
    this.before_row_edit = function(record) {
      countries_CitiesByCountry_grid731.on_master_changed();
      jobs_StudiesByCountry_grid744.on_master_changed();
    }
    Lino.countries.Countries.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.outbox.MyOutbox.InsertFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 27,
  initComponent : function() {
    var containing_panel = this;
    var project177 = new Lino.TwinCombo({ "fieldLabel": "Client", "name": "project", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.pcsw.Clients.detail)}, "emptyText": "Choisir Client...", "selectOnFocus": true, "hiddenName": "projectHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/outbox/Mails/project", "method": "GET" }) }) });
    var subject178 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200, "fieldLabel": "Subject", "anchor": "-20", "name": "subject" });
    var body179 = new Lino.RichTextPanel({ "selectOnFocus": true, "flex": 71, "containing_panel": this, "name": "body", "title": "Body" });
    var main_panel180 = new Ext.Panel({ "autoScroll": false, "border": false, "layout": "vbox", "labelWidth": 72, "hideCheckBoxLabels": true, "items": [ { "items": project177, "autoHeight": true, "layout": "form", "xtype": "panel", "labelAlign": "top" }, { "items": subject178, "autoHeight": true, "layout": "form", "xtype": "panel", "labelAlign": "top" }, body179 ], "frame": true, "layoutConfig": { "align": "stretch" }, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel180;
    this.before_row_edit = function(record) {
      body179.refresh();
    }
    Lino.outbox.MyOutbox.InsertFormPanel.superclass.initComponent.call(this);
  }
});


Lino.outbox.MyOutbox.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 27,
  initComponent : function() {
    var containing_panel = this;
    var subject149 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200, "fieldLabel": "Subject", "anchor": "-20", "name": "subject" });
    var project150 = new Lino.TwinCombo({ "fieldLabel": "Client", "name": "project", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.pcsw.Clients.detail)}, "emptyText": "Choisir Client...", "selectOnFocus": true, "hiddenName": "projectHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/outbox/Mails/project", "method": "GET" }) }) });
    var date151 = new Lino.DateField({ "listeners": { "render": Lino.quicktip_renderer("Date","\n        The official date to be printed on the document.\n        ") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Date</span>", "name": "date", "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var main_1_panel152 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 72, "hideCheckBoxLabels": true, "items": [ { "flex": 42, "autoHeight": true, "layout": "form", "xtype": "panel", "items": subject149, "labelAlign": "top" }, { "flex": 40, "autoHeight": true, "layout": "form", "xtype": "panel", "items": project150, "labelAlign": "top" }, { "flex": 16, "autoHeight": true, "layout": "form", "xtype": "panel", "items": date151, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var user156 = new Lino.TwinCombo({ "fieldLabel": "exp\u00e9diteur", "name": "user", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.users.Users.detail)}, "emptyText": "Choisir Utilisateur...", "selectOnFocus": true, "hiddenName": "userHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/outbox/Mails/user", "method": "GET" }) }) });
    var sent157 = new Ext.form.DisplayField({ "disabled": true, "fieldLabel": "sent", "anchor": "-20", "value": "<br>", "name": "sent" });
    var id158 = new Ext.form.NumberField({ "selectOnFocus": true, "fieldLabel": "ID", "anchor": "-20", "name": "id" });
    var owner_disp159 = new Ext.form.DisplayField({ "disabled": true, "fieldLabel": "Contr\u00f4l\u00e9 par", "anchor": "-20", "name": "owner" });
    var main_2_panel160 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 117, "hideCheckBoxLabels": true, "items": [ { "flex": 32, "autoHeight": true, "layout": "form", "xtype": "panel", "items": user156, "labelAlign": "top" }, { "flex": 34, "autoHeight": true, "layout": "form", "xtype": "panel", "items": sent157, "labelAlign": "top" }, { "flex": 10, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id158, "labelAlign": "top" }, { "flex": 21, "autoHeight": true, "layout": "form", "xtype": "panel", "items": owner_disp159, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var RecipientsByMail_grid171 = new Lino.outbox.RecipientsByMail.GridPanel({ "tools": [ Lino.show_in_own_window_button(Lino.outbox.RecipientsByMail.grid) ], "containing_panel": this, "hide_top_toolbar": true, "master_panel": this, "flex": 55 });
    var AttachmentsByMail_htmlbox172 = new Lino.HtmlBoxPanel({ "flex": 22, "layout": "fit", "name": "AttachmentsByMail", "containing_panel": this, "items": new Ext.BoxComponent({autoScroll:true}), "title": "Pi\u00e8ces jointes", "master_panel": this, "value": "<br/>", "always_enabled": true, "bodyStyle": "overflow-x:hidden", "tools": [ Lino.show_in_own_window_button(Lino.outbox.AttachmentsByMail.grid) ] });
    var UploadsByController_htmlbox173 = new Lino.HtmlBoxPanel({ "flex": 22, "ls_bbar_actions": [ { "itemId": "insert", "menu_item_text": "Nouveau", "must_save": true, "tooltip": "Insert a new record", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-new", "overflowText": "Nouveau", "auto_save": true } ], "name": "UploadsByController", "containing_panel": this, "items": new Ext.BoxComponent({autoScroll:true}), "title": "Uploads", "master_panel": this, "value": "<br/>", "always_enabled": true, "bodyStyle": "overflow-x:hidden", "ls_insert_handler": Lino.uploads.UploadsByController.insert, "layout": "fit", "tools": [ Lino.show_in_own_window_button(Lino.uploads.UploadsByController.grid) ] });
    var main_3_panel174 = new Ext.Panel({ "flex": 29, "border": false, "layout": "hbox", "labelWidth": 135, "hideCheckBoxLabels": true, "items": [ RecipientsByMail_grid171, AttachmentsByMail_htmlbox172, UploadsByController_htmlbox173 ], "autoScroll": false, "layoutConfig": { "align": "stretch" }, "frame": false, "labelAlign": "top" });
    var body175 = new Lino.RichTextPanel({ "selectOnFocus": true, "flex": 58, "containing_panel": this, "name": "body", "title": "Body" });
    var main_panel176 = new Ext.Panel({ "autoScroll": false, "border": false, "layout": "vbox", "labelWidth": 0, "hideCheckBoxLabels": true, "items": [ main_1_panel152, main_2_panel160, main_3_panel174, body175 ], "frame": true, "layoutConfig": { "align": "stretch" }, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel176;
    this.before_row_edit = function(record) {
      RecipientsByMail_grid171.on_master_changed();
      AttachmentsByMail_htmlbox172.refresh();
      UploadsByController_htmlbox173.refresh();
      body175.refresh();
    }
    Lino.outbox.MyOutbox.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.contacts.Partners.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 23,
  initComponent : function() {
    var containing_panel = this;
    var name495 = new Ext.form.TextField({ "fieldLabel": "Name", "name": "name", "maxLength": 200, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var country496 = new Lino.TwinCombo({ "fieldLabel": "Pays", "name": "country", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.countries.Countries.detail)}, "emptyText": "Choisir Pays...", "selectOnFocus": true, "hiddenName": "countryHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/contacts/Partners/country", "method": "GET" }) }) });
    var region497 = new Lino.TwinCombo({ "fieldLabel": "Region", "name": "region", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.countries.Cities.detail)}, "emptyText": "Choisir Place...", "selectOnFocus": true, "hiddenName": "regionHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/contacts/Partners/region", "method": "GET" }) }) });
    var city498 = new Lino.TwinCombo({ "forceSelection": false, "fieldLabel": "Place", "name": "city", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.countries.Cities.detail)}, "emptyText": "Choisir Place...", "selectOnFocus": true, "hiddenName": "cityHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/contacts/Partners/city", "method": "GET" }) }) });
    var zip_code499 = new Ext.form.TextField({ "fieldLabel": "Zip code", "name": "zip_code", "maxLength": 10, "selectOnFocus": true, "boxMinWidth": Lino.chars2width(10), "anchor": "-20" });
    var address_box_2_panel500 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 28, "autoHeight": true, "layout": "form", "xtype": "panel", "items": country496, "labelAlign": "top" }, { "flex": 28, "autoHeight": true, "layout": "form", "xtype": "panel", "items": region497, "labelAlign": "top" }, { "flex": 28, "autoHeight": true, "layout": "form", "xtype": "panel", "items": city498, "labelAlign": "top" }, { "flex": 14, "autoHeight": true, "layout": "form", "xtype": "panel", "items": zip_code499, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 81, "border": false, "anchor": "-20", "labelAlign": "top" });
    var addr1505 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Ligne avant le nom de rue","Address line before street") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Ligne avant le nom de rue</span>", "name": "addr1", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var street_prefix506 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Pr\u00e9fixe rue","Text to print before name of street, but to ignore for sorting.") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Pr\u00e9fixe rue</span>", "name": "street_prefix", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var street507 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Rue","Name of street. Without house number.") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Rue</span>", "name": "street", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var street_no508 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("N\u00b0","House number") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">N\u00b0</span>", "name": "street_no", "maxLength": 10, "selectOnFocus": true, "boxMinWidth": Lino.chars2width(10), "anchor": "-20" });
    var street_box509 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("bo\u00eete","Text to print after :attr:`steet_no` on the same line") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">bo\u00eete</span>", "name": "street_box", "maxLength": 10, "selectOnFocus": true, "boxMinWidth": Lino.chars2width(10), "anchor": "-20" });
    var address_box_4_panel510 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 30, "autoHeight": true, "layout": "form", "xtype": "panel", "items": street_prefix506, "labelAlign": "top" }, { "flex": 36, "autoHeight": true, "layout": "form", "xtype": "panel", "items": street507, "labelAlign": "top" }, { "flex": 16, "autoHeight": true, "layout": "form", "xtype": "panel", "items": street_no508, "labelAlign": "top" }, { "flex": 16, "autoHeight": true, "layout": "form", "xtype": "panel", "items": street_box509, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 108, "border": false, "anchor": "-20", "labelAlign": "top" });
    var addr2515 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Ligne apr\u00e8s le nom de rue","Address line to print below street line") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Ligne apr\u00e8s le nom de rue</span>", "name": "addr2", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var address_box_panel516 = new Ext.form.FieldSet({ "flex": 66, "autoHeight": true, "layout": "form", "title": "Addresse", "items": [ { "autoHeight": true, "layout": "form", "xtype": "panel", "items": name495, "anchor": "-20", "labelAlign": "top" }, address_box_2_panel500, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": addr1505, "anchor": "-20", "labelAlign": "top" }, address_box_4_panel510, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": addr2515, "anchor": "-20", "labelAlign": "top" } ], "frame": true, "bodyBorder": false, "autoScroll": false, "hideCheckBoxLabels": true, "labelWidth": 234, "border": false, "labelAlign": "top" });
    var id520 = new Ext.form.NumberField({ "selectOnFocus": true, "fieldLabel": "ID", "anchor": "-20", "name": "id" });
    var language521 = new Lino.ChoicesFieldElement({ "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Langue</span>", "allowBlank": false, "value": "de", "hiddenName": "languageHidden", "listeners": { "render": Lino.quicktip_renderer("Langue","Die Sprache, in der Dokumente ausgestellt werden sollen.") }, "selectOnFocus": true, "anchor": "-20", "store": [ [ "de", "German" ], [ "fr", "French" ], [ "nl", "Dutch" ] ], "name": "language" });
    var info_box_panel522 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 20, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id520, "labelAlign": "top" }, { "flex": 80, "autoHeight": true, "layout": "form", "xtype": "panel", "items": language521, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 63, "border": false, "anchor": "-20", "labelAlign": "top" });
    var email525 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 75, "fieldLabel": "E-mail", "anchor": "-20", "name": "email" });
    var url526 = new Lino.URLField({ "selectOnFocus": true, "maxLength": 200, "fieldLabel": "URL", "anchor": "-20", "name": "url" });
    var phone527 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200, "fieldLabel": "T\u00e9l\u00e9phone", "anchor": "-20", "name": "phone" });
    var gsm528 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200, "fieldLabel": "GSM", "anchor": "-20", "name": "gsm" });
    var fax529 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200, "fieldLabel": "Fax", "anchor": "-20", "name": "fax" });
    var contact_box_5_panel530 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": gsm528, "labelAlign": "top" }, { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": fax529, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 36, "border": false, "anchor": "-20", "labelAlign": "top" });
    var contact_box_panel533 = new Ext.form.FieldSet({ "flex": 33, "autoHeight": true, "layout": "form", "title": "Contact", "items": [ info_box_panel522, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": email525, "anchor": "-20", "labelAlign": "top" }, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": url526, "anchor": "-20", "labelAlign": "top" }, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": phone527, "anchor": "-20", "labelAlign": "top" }, contact_box_5_panel530 ], "frame": true, "bodyBorder": false, "autoScroll": false, "hideCheckBoxLabels": true, "labelWidth": 90, "border": false, "labelAlign": "top" });
    var general_1_panel537 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "hideCheckBoxLabels": true, "items": [ address_box_panel516, contact_box_panel533 ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var remarks538 = new Ext.form.TextArea({ "selectOnFocus": true, "fieldLabel": "Remarques", "anchor": "-20 -10", "growMax": 2000, "name": "remarks" });
    var activity539 = new Lino.RemoteComboFieldElement({ "fieldLabel": "Activit\u00e9", "name": "activity", "pageSize": 20, "emptyText": "Choisir Activit\u00e9...", "selectOnFocus": true, "hiddenName": "activityHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/contacts/Partners/activity", "method": "GET" }) }) });
    var bank_account1540 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 40, "fieldLabel": "Compte en banque 1", "anchor": "-20", "name": "bank_account1" });
    var bank_account2541 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 40, "fieldLabel": "Compte en banque 2", "anchor": "-20", "name": "bank_account2" });
    var is_obsolete542 = new Ext.form.Checkbox({ "boxLabel": "obsolete", "listeners": { "render": Lino.quicktip_renderer("obsolete","Altf\u00e4lle sind Partner, deren Stammdaten nicht mehr gepflegt werden und \nf\u00fcr neue Operationen nicht benutzt werden k\u00f6nnen.") }, "hideLabel": true, "checked": false, "name": "is_obsolete", "selectOnFocus": true, "anchor": "-20" });
    var bottom_box_2_panel543 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 171, "hideCheckBoxLabels": true, "items": [ { "flex": 27, "autoHeight": true, "layout": "form", "xtype": "panel", "items": activity539, "labelAlign": "top" }, { "flex": 29, "autoHeight": true, "layout": "form", "xtype": "panel", "items": bank_account1540, "labelAlign": "top" }, { "flex": 29, "autoHeight": true, "layout": "form", "xtype": "panel", "items": bank_account2541, "labelAlign": "top" }, { "flex": 13, "autoHeight": true, "layout": "form", "xtype": "panel", "items": is_obsolete542, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var is_person548 = new Ext.form.Checkbox({ "boxLabel": "est une Personne (<a href=\"javascript:Lino.show_mti_child('is_person',Lino.contacts.Persons.detail)\">montrer</a>)", "listeners": { "render": Lino.quicktip_renderer("est une Personne","Si ce partenaire est \u00e9galement une personne.") }, "hideLabel": true, "name": "is_person", "selectOnFocus": true, "anchor": "-20" });
    var is_company549 = new Ext.form.Checkbox({ "boxLabel": "est une Organisation (<a href=\"javascript:Lino.show_mti_child('is_company',Lino.contacts.Companies.detail)\">montrer</a>)", "listeners": { "render": Lino.quicktip_renderer("est une Organisation","Si ce partenaire est \u00e9galement une organisation.") }, "hideLabel": true, "name": "is_company", "selectOnFocus": true, "anchor": "-20" });
    var is_household550 = new Ext.form.Checkbox({ "selectOnFocus": true, "boxLabel": "est un m\u00e9nage (<a href=\"javascript:Lino.show_mti_child('is_household',Lino.households.Households.detail)\">montrer</a>)", "hideLabel": true, "anchor": "-20", "name": "is_household" });
    var created551 = new Ext.form.DisplayField({ "disabled": true, "fieldLabel": "Cr\u00e9\u00e9", "anchor": "-20", "value": "<br>", "name": "created" });
    var modified552 = new Ext.form.DisplayField({ "disabled": true, "fieldLabel": "Modified", "anchor": "-20", "value": "<br>", "name": "modified" });
    var bottom_box_3_panel553 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 189, "hideCheckBoxLabels": true, "items": [ { "flex": 16, "autoHeight": true, "layout": "form", "xtype": "panel", "items": is_person548, "labelAlign": "top" }, { "flex": 16, "autoHeight": true, "layout": "form", "xtype": "panel", "items": is_company549, "labelAlign": "top" }, { "flex": 16, "autoHeight": true, "layout": "form", "xtype": "panel", "items": is_household550, "labelAlign": "top" }, { "flex": 25, "autoHeight": true, "layout": "form", "xtype": "panel", "items": created551, "labelAlign": "top" }, { "flex": 25, "autoHeight": true, "layout": "form", "xtype": "panel", "items": modified552, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var bottom_box_panel559 = new Ext.Panel({ "flex": 58, "layout": "vbox", "items": [ { "items": remarks538, "labelAlign": "top", "layout": "form", "xtype": "panel", "flex": 71 }, bottom_box_2_panel543, bottom_box_3_panel553 ], "frame": true, "layoutConfig": { "align": "stretch" }, "autoScroll": false, "hideCheckBoxLabels": true, "labelWidth": 90, "border": false, "bodyBorder": false, "labelAlign": "top" });
    var general_panel561 = new Ext.Panel({ "layout": "vbox", "title": "G\u00e9n\u00e9ral", "items": [ general_1_panel537, bottom_box_panel559 ], "frame": true, "layoutConfig": { "align": "stretch" }, "hideCheckBoxLabels": true, "listeners": { "activate": Lino.on_tab_activate }, "autoScroll": false, "border": false, "bodyBorder": false, "labelAlign": "top" });
    var changes_ChangesByMaster_grid586 = new Lino.changes.ChangesByMaster.GridPanel({ "listeners": { "activate": Lino.on_tab_activate }, "hide_top_toolbar": true, "title": "Changes", "containing_panel": this, "tools": [ Lino.show_in_own_window_button(Lino.changes.ChangesByMaster.grid) ], "master_panel": this });
    var main_panel701 = new Ext.TabPanel({ "hideCheckBoxLabels": true, "border": false, "split": true, "autoScroll": false, "items": [ general_panel561, changes_ChangesByMaster_grid586 ], "activeTab": 0, "bodyBorder": false, "frame": true, "labelAlign": "top" });
    this.items = main_panel701;
    this.before_row_edit = function(record) {
      region497.setContextValue('country',record ? record.data['countryHidden'] : undefined);
      city498.setContextValue('country',record ? record.data['countryHidden'] : undefined);
      city498.setContextValue('region',record ? record.data['regionHidden'] : undefined);
      changes_ChangesByMaster_grid586.on_master_changed();
    }
    this.onRender = function(ct, position) {
      country496.on('change',Lino.chooser_handler(region497,'country'));
      country496.on('change',Lino.chooser_handler(city498,'country'));
      region497.on('change',Lino.chooser_handler(city498,'region'));
      Lino.contacts.Partners.DetailFormPanel.superclass.onRender.call(this, ct, position);
    }
    Lino.contacts.Partners.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.jobs.JobProviders.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 75,
  initComponent : function() {
    var containing_panel = this;
    var prefix1889 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200, "fieldLabel": "prefix", "anchor": "-20", "name": "prefix" });
    var name1890 = new Ext.form.TextField({ "fieldLabel": "Name", "name": "name", "maxLength": 200, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var id1891 = new Ext.form.NumberField({ "selectOnFocus": true, "fieldLabel": "ID", "anchor": "-20", "name": "id" });
    var language1892 = new Lino.ChoicesFieldElement({ "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Langue</span>", "allowBlank": false, "value": "de", "hiddenName": "languageHidden", "listeners": { "render": Lino.quicktip_renderer("Langue","Die Sprache, in der Dokumente ausgestellt werden sollen.") }, "selectOnFocus": true, "anchor": "-20", "store": [ [ "de", "German" ], [ "fr", "French" ], [ "nl", "Dutch" ] ], "name": "language" });
    var intro_box_1_panel1893 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 31, "autoHeight": true, "layout": "form", "xtype": "panel", "items": prefix1889, "labelAlign": "top" }, { "flex": 31, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name1890, "labelAlign": "top" }, { "flex": 7, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id1891, "labelAlign": "top" }, { "flex": 29, "autoHeight": true, "layout": "form", "xtype": "panel", "items": language1892, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 63, "border": false, "anchor": "-20", "labelAlign": "top" });
    var vat_id1898 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200, "fieldLabel": "N\u00b0 de TVA", "anchor": "-20", "name": "vat_id" });
    var activity1899 = new Lino.RemoteComboFieldElement({ "fieldLabel": "Activit\u00e9", "name": "activity", "pageSize": 20, "emptyText": "Choisir Activit\u00e9...", "selectOnFocus": true, "hiddenName": "activityHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/jobs/JobProviders/activity", "method": "GET" }) }) });
    var type1900 = new Lino.RemoteComboFieldElement({ "fieldLabel": "Type de soci\u00e9t\u00e9", "name": "type", "pageSize": 20, "emptyText": "Choisir Type d'organisation...", "selectOnFocus": true, "hiddenName": "typeHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/jobs/JobProviders/type", "method": "GET" }) }) });
    var intro_box_2_panel1901 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 23, "autoHeight": true, "layout": "form", "xtype": "panel", "items": vat_id1898, "labelAlign": "top" }, { "flex": 38, "autoHeight": true, "layout": "form", "xtype": "panel", "items": activity1899, "labelAlign": "top" }, { "flex": 38, "autoHeight": true, "layout": "form", "xtype": "panel", "items": type1900, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 144, "border": false, "anchor": "-20", "labelAlign": "top" });
    var bank_account11905 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 40, "fieldLabel": "Compte en banque 1", "anchor": "-20", "name": "bank_account1" });
    var bank_account21906 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 40, "fieldLabel": "Compte en banque 2", "anchor": "-20", "name": "bank_account2" });
    var is_obsolete1907 = new Ext.form.Checkbox({ "boxLabel": "obsolete", "listeners": { "render": Lino.quicktip_renderer("obsolete","Altf\u00e4lle sind Partner, deren Stammdaten nicht mehr gepflegt werden und \nf\u00fcr neue Operationen nicht benutzt werden k\u00f6nnen.") }, "hideLabel": true, "checked": false, "name": "is_obsolete", "selectOnFocus": true, "anchor": "-20" });
    var intro_box_3_panel1908 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 40, "autoHeight": true, "layout": "form", "xtype": "panel", "items": bank_account11905, "labelAlign": "top" }, { "flex": 40, "autoHeight": true, "layout": "form", "xtype": "panel", "items": bank_account21906, "labelAlign": "top" }, { "flex": 19, "autoHeight": true, "layout": "form", "xtype": "panel", "items": is_obsolete1907, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 171, "border": false, "anchor": "-20", "labelAlign": "top" });
    var intro_box_panel1912 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "form", "hideCheckBoxLabels": true, "items": [ intro_box_1_panel1893, intro_box_2_panel1901, intro_box_3_panel1908 ], "frame": true, "bodyBorder": false, "labelAlign": "top" });
    var country1913 = new Lino.TwinCombo({ "fieldLabel": "Pays", "name": "country", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.countries.Countries.detail)}, "emptyText": "Choisir Pays...", "selectOnFocus": true, "hiddenName": "countryHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/jobs/JobProviders/country", "method": "GET" }) }) });
    var region1914 = new Lino.TwinCombo({ "fieldLabel": "Region", "name": "region", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.countries.Cities.detail)}, "emptyText": "Choisir Place...", "selectOnFocus": true, "hiddenName": "regionHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/jobs/JobProviders/region", "method": "GET" }) }) });
    var box3_1_panel1915 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": country1913, "labelAlign": "top" }, { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": region1914, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 63, "border": false, "anchor": "-20", "labelAlign": "top" });
    var city1918 = new Lino.TwinCombo({ "forceSelection": false, "fieldLabel": "Place", "name": "city", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.countries.Cities.detail)}, "emptyText": "Choisir Place...", "selectOnFocus": true, "hiddenName": "cityHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/jobs/JobProviders/city", "method": "GET" }) }) });
    var zip_code1919 = new Ext.form.TextField({ "fieldLabel": "Zip code", "name": "zip_code", "maxLength": 10, "selectOnFocus": true, "boxMinWidth": Lino.chars2width(10), "anchor": "-20" });
    var box3_2_panel1920 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 66, "autoHeight": true, "layout": "form", "xtype": "panel", "items": city1918, "labelAlign": "top" }, { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": zip_code1919, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 81, "border": false, "anchor": "-20", "labelAlign": "top" });
    var street_prefix1923 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Pr\u00e9fixe rue","Text to print before name of street, but to ignore for sorting.") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Pr\u00e9fixe rue</span>", "name": "street_prefix", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var street1924 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Rue","Name of street. Without house number.") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Rue</span>", "name": "street", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var street_no1925 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("N\u00b0","House number") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">N\u00b0</span>", "name": "street_no", "maxLength": 10, "selectOnFocus": true, "boxMinWidth": Lino.chars2width(10), "anchor": "-20" });
    var street_box1926 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("bo\u00eete","Text to print after :attr:`steet_no` on the same line") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">bo\u00eete</span>", "name": "street_box", "maxLength": 10, "selectOnFocus": true, "boxMinWidth": Lino.chars2width(10), "anchor": "-20" });
    var box3_3_panel1927 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 30, "autoHeight": true, "layout": "form", "xtype": "panel", "items": street_prefix1923, "labelAlign": "top" }, { "flex": 36, "autoHeight": true, "layout": "form", "xtype": "panel", "items": street1924, "labelAlign": "top" }, { "flex": 16, "autoHeight": true, "layout": "form", "xtype": "panel", "items": street_no1925, "labelAlign": "top" }, { "flex": 16, "autoHeight": true, "layout": "form", "xtype": "panel", "items": street_box1926, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 108, "border": false, "anchor": "-20", "labelAlign": "top" });
    var addr21932 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Ligne apr\u00e8s le nom de rue","Address line to print below street line") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Ligne apr\u00e8s le nom de rue</span>", "name": "addr2", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var box3_panel1933 = new Ext.Panel({ "flex": 62, "autoHeight": true, "layout": "form", "items": [ box3_1_panel1915, box3_2_panel1920, box3_3_panel1927, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": addr21932, "anchor": "-20", "labelAlign": "top" } ], "frame": true, "bodyBorder": false, "autoScroll": false, "hideCheckBoxLabels": true, "labelWidth": 234, "border": false, "labelAlign": "top" });
    var email1935 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 75, "fieldLabel": "E-mail", "anchor": "-20", "name": "email" });
    var url1936 = new Lino.URLField({ "selectOnFocus": true, "maxLength": 200, "fieldLabel": "URL", "anchor": "-20", "name": "url" });
    var phone1937 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200, "fieldLabel": "T\u00e9l\u00e9phone", "anchor": "-20", "name": "phone" });
    var gsm1938 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200, "fieldLabel": "GSM", "anchor": "-20", "name": "gsm" });
    var box4_panel1939 = new Ext.Panel({ "flex": 37, "autoHeight": true, "layout": "form", "items": [ { "autoHeight": true, "layout": "form", "xtype": "panel", "items": email1935, "anchor": "-20", "labelAlign": "top" }, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": url1936, "anchor": "-20", "labelAlign": "top" }, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": phone1937, "anchor": "-20", "labelAlign": "top" }, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": gsm1938, "anchor": "-20", "labelAlign": "top" } ], "frame": true, "bodyBorder": false, "autoScroll": false, "hideCheckBoxLabels": true, "labelWidth": 90, "border": false, "labelAlign": "top" });
    var address_box_panel1944 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "hideCheckBoxLabels": true, "items": [ box3_panel1933, box4_panel1939 ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var remarks1945 = new Ext.form.TextArea({ "selectOnFocus": true, "fieldLabel": "Remarques", "anchor": "-20 -10", "growMax": 2000, "name": "remarks" });
    var contacts_RolesByCompany_grid1946 = new Lino.contacts.RolesByCompany.GridPanel({ "tools": [ Lino.show_in_own_window_button(Lino.contacts.RolesByCompany.grid) ], "containing_panel": this, "hide_top_toolbar": true, "master_panel": this, "flex": 42 });
    var bottom_box_panel1947 = new Ext.Panel({ "flex": 41, "border": false, "layout": "hbox", "labelWidth": 90, "hideCheckBoxLabels": true, "items": [ { "items": remarks1945, "labelAlign": "top", "layout": "form", "xtype": "panel", "flex": 57 }, contacts_RolesByCompany_grid1946 ], "autoScroll": false, "layoutConfig": { "align": "stretch" }, "frame": false, "labelAlign": "top" });
    var general_panel1949 = new Ext.Panel({ "layout": "vbox", "title": "G\u00e9n\u00e9ral", "items": [ intro_box_panel1912, address_box_panel1944, bottom_box_panel1947 ], "frame": true, "layoutConfig": { "align": "stretch" }, "hideCheckBoxLabels": true, "listeners": { "activate": Lino.on_tab_activate }, "autoScroll": false, "border": false, "bodyBorder": false, "labelAlign": "top" });
    var pcsw_NotesByCompany_grid1950 = new Lino.pcsw.NotesByCompany.GridPanel({ "listeners": { "activate": Lino.on_tab_activate }, "hide_top_toolbar": true, "title": "Events/Notes", "containing_panel": this, "tools": [ Lino.show_in_own_window_button(Lino.pcsw.NotesByCompany.grid) ], "master_panel": this });
    var JobsByProvider_grid2025 = new Lino.jobs.JobsByProvider.GridPanel({ "flex": 5, "hide_top_toolbar": true, "split": true, "containing_panel": this, "region": "north", "tools": [ Lino.show_in_own_window_button(Lino.jobs.JobsByProvider.grid) ], "master_panel": this });
    var ContractsByProvider_grid2055 = new Lino.jobs.ContractsByProvider.GridPanel({ "flex": 5, "hide_top_toolbar": true, "containing_panel": this, "region": "center", "params_panel_hidden": true, "master_panel": this, "split": true, "tools": [ Lino.show_in_own_window_button(Lino.jobs.ContractsByProvider.grid) ] });
    var jobs_panel2056 = new Lino.VBorderPanel({ "autoScroll": false, "listeners": { "activate": Lino.on_tab_activate }, "border": false, "title": "Emplois", "hideCheckBoxLabels": true, "items": [ JobsByProvider_grid2025, ContractsByProvider_grid2055 ], "frame": true, "bodyBorder": false, "labelAlign": "top" });
    var main_panel2057 = new Ext.TabPanel({ "hideCheckBoxLabels": true, "border": false, "split": true, "autoScroll": false, "items": [ general_panel1949, pcsw_NotesByCompany_grid1950, jobs_panel2056 ], "activeTab": 0, "bodyBorder": false, "frame": true, "labelAlign": "top" });
    this.items = main_panel2057;
    this.before_row_edit = function(record) {
      region1914.setContextValue('country',record ? record.data['countryHidden'] : undefined);
      city1918.setContextValue('country',record ? record.data['countryHidden'] : undefined);
      city1918.setContextValue('region',record ? record.data['regionHidden'] : undefined);
      contacts_RolesByCompany_grid1946.on_master_changed();
      pcsw_NotesByCompany_grid1950.on_master_changed();
      JobsByProvider_grid2025.on_master_changed();
      ContractsByProvider_grid2055.on_master_changed();
    }
    this.onRender = function(ct, position) {
      country1913.on('change',Lino.chooser_handler(region1914,'country'));
      country1913.on('change',Lino.chooser_handler(city1918,'country'));
      region1914.on('change',Lino.chooser_handler(city1918,'region'));
      Lino.jobs.JobProviders.DetailFormPanel.superclass.onRender.call(this, ct, position);
    }
    Lino.jobs.JobProviders.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.contacts.Persons.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 21,
  initComponent : function() {
    var containing_panel = this;
    var last_name1047 = new Ext.form.TextField({ "fieldLabel": "Nom de famille", "name": "last_name", "maxLength": 200, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var first_name1048 = new Ext.form.TextField({ "fieldLabel": "Pr\u00e9nom", "name": "first_name", "maxLength": 200, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var gender1049 = new Lino.ChoicesFieldElement({ "forceSelection": true, "fieldLabel": "Sexe", "name": "gender", "selectOnFocus": true, "anchor": "-20", "store": Lino.lino.Genders, "hiddenName": "genderHidden" });
    var title1050 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200, "fieldLabel": "Allocution", "anchor": "-20", "name": "title" });
    var name_box_panel1051 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 36, "autoHeight": true, "layout": "form", "xtype": "panel", "items": last_name1047, "labelAlign": "top" }, { "flex": 26, "autoHeight": true, "layout": "form", "xtype": "panel", "items": first_name1048, "labelAlign": "top" }, { "flex": 19, "autoHeight": true, "layout": "form", "xtype": "panel", "items": gender1049, "labelAlign": "top" }, { "flex": 17, "autoHeight": true, "layout": "form", "xtype": "panel", "items": title1050, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 135, "border": false, "anchor": "-20", "labelAlign": "top" });
    var country1056 = new Lino.TwinCombo({ "fieldLabel": "Pays", "name": "country", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.countries.Countries.detail)}, "emptyText": "Choisir Pays...", "selectOnFocus": true, "hiddenName": "countryHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/contacts/Persons/country", "method": "GET" }) }) });
    var region1057 = new Lino.TwinCombo({ "fieldLabel": "Region", "name": "region", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.countries.Cities.detail)}, "emptyText": "Choisir Place...", "selectOnFocus": true, "hiddenName": "regionHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/contacts/Persons/region", "method": "GET" }) }) });
    var city1058 = new Lino.TwinCombo({ "forceSelection": false, "fieldLabel": "Place", "name": "city", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.countries.Cities.detail)}, "emptyText": "Choisir Place...", "selectOnFocus": true, "hiddenName": "cityHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/contacts/Persons/city", "method": "GET" }) }) });
    var zip_code1059 = new Ext.form.TextField({ "fieldLabel": "Zip code", "name": "zip_code", "maxLength": 10, "selectOnFocus": true, "boxMinWidth": Lino.chars2width(10), "anchor": "-20" });
    var address_box_2_panel1060 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 28, "autoHeight": true, "layout": "form", "xtype": "panel", "items": country1056, "labelAlign": "top" }, { "flex": 28, "autoHeight": true, "layout": "form", "xtype": "panel", "items": region1057, "labelAlign": "top" }, { "flex": 28, "autoHeight": true, "layout": "form", "xtype": "panel", "items": city1058, "labelAlign": "top" }, { "flex": 14, "autoHeight": true, "layout": "form", "xtype": "panel", "items": zip_code1059, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 81, "border": false, "anchor": "-20", "labelAlign": "top" });
    var addr11065 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Ligne avant le nom de rue","Address line before street") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Ligne avant le nom de rue</span>", "name": "addr1", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var street_prefix1066 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Pr\u00e9fixe rue","Text to print before name of street, but to ignore for sorting.") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Pr\u00e9fixe rue</span>", "name": "street_prefix", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var street1067 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Rue","Name of street. Without house number.") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Rue</span>", "name": "street", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var street_no1068 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("N\u00b0","House number") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">N\u00b0</span>", "name": "street_no", "maxLength": 10, "selectOnFocus": true, "boxMinWidth": Lino.chars2width(10), "anchor": "-20" });
    var street_box1069 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("bo\u00eete","Text to print after :attr:`steet_no` on the same line") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">bo\u00eete</span>", "name": "street_box", "maxLength": 10, "selectOnFocus": true, "boxMinWidth": Lino.chars2width(10), "anchor": "-20" });
    var address_box_4_panel1070 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 30, "autoHeight": true, "layout": "form", "xtype": "panel", "items": street_prefix1066, "labelAlign": "top" }, { "flex": 36, "autoHeight": true, "layout": "form", "xtype": "panel", "items": street1067, "labelAlign": "top" }, { "flex": 16, "autoHeight": true, "layout": "form", "xtype": "panel", "items": street_no1068, "labelAlign": "top" }, { "flex": 16, "autoHeight": true, "layout": "form", "xtype": "panel", "items": street_box1069, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 108, "border": false, "anchor": "-20", "labelAlign": "top" });
    var addr21075 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Ligne apr\u00e8s le nom de rue","Address line to print below street line") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Ligne apr\u00e8s le nom de rue</span>", "name": "addr2", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var address_box_panel1076 = new Ext.form.FieldSet({ "flex": 66, "autoHeight": true, "layout": "form", "title": "Addresse", "items": [ name_box_panel1051, address_box_2_panel1060, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": addr11065, "anchor": "-20", "labelAlign": "top" }, address_box_4_panel1070, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": addr21075, "anchor": "-20", "labelAlign": "top" } ], "frame": true, "bodyBorder": false, "autoScroll": false, "hideCheckBoxLabels": true, "labelWidth": 234, "border": false, "labelAlign": "top" });
    var id1079 = new Ext.form.NumberField({ "selectOnFocus": true, "fieldLabel": "ID", "anchor": "-20", "name": "id" });
    var language1080 = new Lino.ChoicesFieldElement({ "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Langue</span>", "allowBlank": false, "value": "de", "hiddenName": "languageHidden", "listeners": { "render": Lino.quicktip_renderer("Langue","Die Sprache, in der Dokumente ausgestellt werden sollen.") }, "selectOnFocus": true, "anchor": "-20", "store": [ [ "de", "German" ], [ "fr", "French" ], [ "nl", "Dutch" ] ], "name": "language" });
    var info_box_panel1081 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id1079, "labelAlign": "top" }, { "flex": 66, "autoHeight": true, "layout": "form", "xtype": "panel", "items": language1080, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 63, "border": false, "anchor": "-20", "labelAlign": "top" });
    var email1084 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 75, "fieldLabel": "E-mail", "anchor": "-20", "name": "email" });
    var url1085 = new Lino.URLField({ "selectOnFocus": true, "maxLength": 200, "fieldLabel": "URL", "anchor": "-20", "name": "url" });
    var phone1086 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200, "fieldLabel": "T\u00e9l\u00e9phone", "anchor": "-20", "name": "phone" });
    var gsm1087 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200, "fieldLabel": "GSM", "anchor": "-20", "name": "gsm" });
    var fax1088 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200, "fieldLabel": "Fax", "anchor": "-20", "name": "fax" });
    var contact_box_5_panel1089 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": gsm1087, "labelAlign": "top" }, { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": fax1088, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 36, "border": false, "anchor": "-20", "labelAlign": "top" });
    var contact_box_panel1092 = new Ext.form.FieldSet({ "flex": 33, "autoHeight": true, "layout": "form", "title": "Contact", "items": [ info_box_panel1081, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": email1084, "anchor": "-20", "labelAlign": "top" }, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": url1085, "anchor": "-20", "labelAlign": "top" }, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": phone1086, "anchor": "-20", "labelAlign": "top" }, contact_box_5_panel1089 ], "frame": true, "bodyBorder": false, "autoScroll": false, "hideCheckBoxLabels": true, "labelWidth": 90, "border": false, "labelAlign": "top" });
    var general_1_panel1096 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "hideCheckBoxLabels": true, "items": [ address_box_panel1076, contact_box_panel1092 ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var activity1097 = new Lino.RemoteComboFieldElement({ "fieldLabel": "Activit\u00e9", "name": "activity", "pageSize": 20, "emptyText": "Choisir Activit\u00e9...", "selectOnFocus": true, "hiddenName": "activityHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/contacts/Persons/activity", "method": "GET" }) }) });
    var bank_account11098 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 40, "fieldLabel": "Compte en banque 1", "anchor": "-20", "name": "bank_account1" });
    var bank_account21099 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 40, "fieldLabel": "Compte en banque 2", "anchor": "-20", "name": "bank_account2" });
    var is_obsolete1100 = new Ext.form.Checkbox({ "boxLabel": "obsolete", "listeners": { "render": Lino.quicktip_renderer("obsolete","Altf\u00e4lle sind Partner, deren Stammdaten nicht mehr gepflegt werden und \nf\u00fcr neue Operationen nicht benutzt werden k\u00f6nnen.") }, "hideLabel": true, "checked": false, "name": "is_obsolete", "selectOnFocus": true, "anchor": "-20" });
    var bottom_box_1_panel1101 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 171, "hideCheckBoxLabels": true, "items": [ { "flex": 27, "autoHeight": true, "layout": "form", "xtype": "panel", "items": activity1097, "labelAlign": "top" }, { "flex": 29, "autoHeight": true, "layout": "form", "xtype": "panel", "items": bank_account11098, "labelAlign": "top" }, { "flex": 29, "autoHeight": true, "layout": "form", "xtype": "panel", "items": bank_account21099, "labelAlign": "top" }, { "flex": 13, "autoHeight": true, "layout": "form", "xtype": "panel", "items": is_obsolete1100, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var is_client1106 = new Ext.form.Checkbox({ "boxLabel": "est un client (<a href=\"javascript:Lino.show_mti_child('is_client',Lino.pcsw.Clients.detail)\">montrer</a>)", "listeners": { "render": Lino.quicktip_renderer("est un client","Whether this Person is a Client.") }, "hideLabel": true, "name": "is_client", "selectOnFocus": true, "anchor": "-20" });
    var created1107 = new Ext.form.DisplayField({ "disabled": true, "fieldLabel": "Cr\u00e9\u00e9", "anchor": "-20", "value": "<br>", "name": "created" });
    var modified1108 = new Ext.form.DisplayField({ "disabled": true, "fieldLabel": "Modified", "anchor": "-20", "value": "<br>", "name": "modified" });
    var bottom_box_2_panel1109 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 126, "hideCheckBoxLabels": true, "items": [ { "flex": 23, "autoHeight": true, "layout": "form", "xtype": "panel", "items": is_client1106, "labelAlign": "top" }, { "flex": 38, "autoHeight": true, "layout": "form", "xtype": "panel", "items": created1107, "labelAlign": "top" }, { "flex": 38, "autoHeight": true, "layout": "form", "xtype": "panel", "items": modified1108, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var remarks1113 = new Ext.form.TextArea({ "selectOnFocus": true, "fieldLabel": "Remarques", "anchor": "-20 -10", "growMax": 2000, "name": "remarks" });
    var contacts_RolesByPerson_grid1118 = new Lino.contacts.RolesByPerson.GridPanel({ "tools": [ Lino.show_in_own_window_button(Lino.contacts.RolesByPerson.grid) ], "containing_panel": this, "hide_top_toolbar": true, "master_panel": this, "flex": 27 });
    var households_MembersByPerson_grid1125 = new Lino.households.MembersByPerson.GridPanel({ "tools": [ Lino.show_in_own_window_button(Lino.households.MembersByPerson.grid) ], "containing_panel": this, "hide_top_toolbar": true, "master_panel": this, "flex": 36 });
    var bottom_box_3_panel1126 = new Ext.Panel({ "flex": 71, "border": false, "layout": "hbox", "labelWidth": 90, "hideCheckBoxLabels": true, "items": [ { "items": remarks1113, "labelAlign": "top", "layout": "form", "xtype": "panel", "flex": 36 }, contacts_RolesByPerson_grid1118, households_MembersByPerson_grid1125 ], "autoScroll": false, "layoutConfig": { "align": "stretch" }, "frame": false, "labelAlign": "top" });
    var bottom_box_panel1128 = new Ext.Panel({ "flex": 58, "border": false, "layout": "vbox", "bodyBorder": false, "hideCheckBoxLabels": true, "items": [ bottom_box_1_panel1101, bottom_box_2_panel1109, bottom_box_3_panel1126 ], "autoScroll": false, "layoutConfig": { "align": "stretch" }, "frame": true, "labelAlign": "top" });
    var general_panel1129 = new Ext.Panel({ "layout": "vbox", "title": "G\u00e9n\u00e9ral", "items": [ general_1_panel1096, bottom_box_panel1128 ], "frame": true, "layoutConfig": { "align": "stretch" }, "hideCheckBoxLabels": true, "listeners": { "activate": Lino.on_tab_activate }, "autoScroll": false, "border": false, "bodyBorder": false, "labelAlign": "top" });
    var main_panel1133 = new Ext.TabPanel({ "hideCheckBoxLabels": true, "border": false, "split": true, "autoScroll": false, "items": [ general_panel1129 ], "activeTab": 0, "bodyBorder": false, "frame": true, "labelAlign": "top" });
    this.items = main_panel1133;
    this.before_row_edit = function(record) {
      region1057.setContextValue('country',record ? record.data['countryHidden'] : undefined);
      city1058.setContextValue('country',record ? record.data['countryHidden'] : undefined);
      city1058.setContextValue('region',record ? record.data['regionHidden'] : undefined);
      contacts_RolesByPerson_grid1118.on_master_changed();
      households_MembersByPerson_grid1125.on_master_changed();
    }
    this.onRender = function(ct, position) {
      country1056.on('change',Lino.chooser_handler(region1057,'country'));
      country1056.on('change',Lino.chooser_handler(city1058,'country'));
      region1057.on('change',Lino.chooser_handler(city1058,'region'));
      Lino.contacts.Persons.DetailFormPanel.superclass.onRender.call(this, ct, position);
    }
    Lino.contacts.Persons.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.cal.TasksByUser.InsertFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  autoHeight: true,
  content_type: 30,
  initComponent : function() {
    var containing_panel = this;
    var summary313 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200, "fieldLabel": "R\u00e9sum\u00e9", "anchor": "-20", "name": "summary" });
    var user314 = new Lino.TwinCombo({ "fieldLabel": "Auteur", "name": "user", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.users.Users.detail)}, "emptyText": "Choisir Utilisateur...", "selectOnFocus": true, "hiddenName": "userHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/Tasks/user", "method": "GET" }) }) });
    var project315 = new Lino.TwinCombo({ "fieldLabel": "Client", "name": "project", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.pcsw.Clients.detail)}, "emptyText": "Choisir Client...", "selectOnFocus": true, "hiddenName": "projectHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/Tasks/project", "method": "GET" }) }) });
    var main_2_panel316 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 42, "autoHeight": true, "layout": "form", "xtype": "panel", "items": user314, "labelAlign": "top" }, { "flex": 57, "autoHeight": true, "layout": "form", "xtype": "panel", "items": project315, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 63, "border": false, "anchor": "-20", "labelAlign": "top" });
    var main_panel319 = new Ext.Panel({ "hideCheckBoxLabels": true, "autoHeight": true, "border": false, "layout": "form", "labelWidth": 63, "autoScroll": false, "items": [ { "autoHeight": true, "layout": "form", "xtype": "panel", "items": summary313, "anchor": "-20", "labelAlign": "top" }, main_2_panel316 ], "frame": true, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel319;
    this.before_row_edit = function(record) {
    }
    Lino.cal.TasksByUser.InsertFormPanel.superclass.initComponent.call(this);
  }
});


Lino.courses.PendingCourseRequests.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 78,
  initComponent : function() {
    var containing_panel = this;
    var date_submitted1389 = new Lino.DateField({ "listeners": { "render": Lino.quicktip_renderer("Date d\u00e9ntr\u00e9e","When this request has been submitted.") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Date d\u00e9ntr\u00e9e</span>", "name": "date_submitted", "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var person1390 = new Lino.TwinCombo({ "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Client</span>", "allowBlank": false, "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.pcsw.Clients.detail)}, "emptyText": "Choisir Client...", "listeners": { "render": Lino.quicktip_renderer("Client","Le client qui d\u00e9sire suivre un cours.") }, "selectOnFocus": true, "hiddenName": "personHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/courses/CourseRequests/person", "method": "GET" }) }), "name": "person" });
    var content1391 = new Lino.TwinCombo({ "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Contenu</span>", "allowBlank": false, "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.courses.CourseContents.detail)}, "emptyText": "Choisir Contenu de cours...", "listeners": { "render": Lino.quicktip_renderer("Contenu","Der gew\u00fcnschte Kursinhalt.)") }, "selectOnFocus": true, "hiddenName": "contentHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/courses/CourseRequests/content", "method": "GET" }) }), "name": "content" });
    var offer1392 = new Lino.TwinCombo({ "fieldLabel": "Offre de cours", "name": "offer", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.courses.CourseOffers.detail)}, "emptyText": "Choisir Offre de cours...", "selectOnFocus": true, "hiddenName": "offerHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/courses/CourseRequests/offer", "method": "GET" }) }) });
    var urgent1393 = new Ext.form.Checkbox({ "boxLabel": "cause professionnelle", "listeners": { "render": Lino.quicktip_renderer("cause professionnelle","Check this if the request is needed for job search.") }, "hideLabel": true, "checked": false, "name": "urgent", "selectOnFocus": true, "anchor": "-20" });
    var main_1_panel1394 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 198, "hideCheckBoxLabels": true, "items": [ { "flex": 10, "autoHeight": true, "layout": "form", "xtype": "panel", "items": date_submitted1389, "labelAlign": "top" }, { "flex": 25, "autoHeight": true, "layout": "form", "xtype": "panel", "items": person1390, "labelAlign": "top" }, { "flex": 25, "autoHeight": true, "layout": "form", "xtype": "panel", "items": content1391, "labelAlign": "top" }, { "flex": 25, "autoHeight": true, "layout": "form", "xtype": "panel", "items": offer1392, "labelAlign": "top" }, { "flex": 12, "autoHeight": true, "layout": "form", "xtype": "panel", "items": urgent1393, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var course1400 = new Lino.TwinCombo({ "fieldLabel": "Cours trouv\u00e9", "name": "course", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.courses.Courses.detail)}, "emptyText": "Choisir Cours...", "selectOnFocus": true, "hiddenName": "courseHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/courses/CourseRequests/course", "method": "GET" }) }) });
    var state1401 = new Lino.ChoicesFieldElement({ "forceSelection": true, "fieldLabel": "State", "allowBlank": false, "hiddenName": "stateHidden", "selectOnFocus": true, "anchor": "-20", "store": Lino.courses.CourseRequestStates, "name": "state" });
    var date_ended1402 = new Lino.DateField({ "selectOnFocus": true, "fieldLabel": "Date de fin", "anchor": "-20", "name": "date_ended" });
    var id1403 = new Ext.form.NumberField({ "selectOnFocus": true, "fieldLabel": "ID", "anchor": "-20", "name": "id" });
    var main_2_panel1404 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 117, "hideCheckBoxLabels": true, "items": [ { "flex": 37, "autoHeight": true, "layout": "form", "xtype": "panel", "items": course1400, "labelAlign": "top" }, { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": state1401, "labelAlign": "top" }, { "flex": 14, "autoHeight": true, "layout": "form", "xtype": "panel", "items": date_ended1402, "labelAlign": "top" }, { "flex": 14, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id1403, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var remark1409 = new Ext.form.TextArea({ "selectOnFocus": true, "fieldLabel": "Remarque", "anchor": "-20 -10", "growMax": 2000, "name": "remark" });
    var UploadsByController_htmlbox1410 = new Lino.HtmlBoxPanel({ "flex": 33, "ls_bbar_actions": [ { "itemId": "insert", "menu_item_text": "Nouveau", "must_save": true, "tooltip": "Insert a new record", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-new", "overflowText": "Nouveau", "auto_save": true } ], "name": "UploadsByController", "containing_panel": this, "items": new Ext.BoxComponent({autoScroll:true}), "title": "Uploads", "master_panel": this, "value": "<br/>", "always_enabled": true, "bodyStyle": "overflow-x:hidden", "ls_insert_handler": Lino.uploads.UploadsByController.insert, "layout": "fit", "tools": [ Lino.show_in_own_window_button(Lino.uploads.UploadsByController.grid) ] });
    var main_3_panel1411 = new Ext.Panel({ "flex": 71, "border": false, "layout": "hbox", "labelWidth": 81, "hideCheckBoxLabels": true, "items": [ { "items": remark1409, "labelAlign": "top", "layout": "form", "xtype": "panel", "flex": 66 }, UploadsByController_htmlbox1410 ], "autoScroll": false, "layoutConfig": { "align": "stretch" }, "frame": false, "labelAlign": "top" });
    var main_panel1413 = new Ext.Panel({ "autoScroll": false, "border": false, "layout": "vbox", "hideCheckBoxLabels": true, "items": [ main_1_panel1394, main_2_panel1404, main_3_panel1411 ], "frame": true, "layoutConfig": { "align": "stretch" }, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel1413;
    this.before_row_edit = function(record) {
      offer1392.setContextValue('content',record ? record.data['contentHidden'] : undefined);
      UploadsByController_htmlbox1410.refresh();
    }
    this.onRender = function(ct, position) {
      content1391.on('change',Lino.chooser_handler(offer1392,'content'));
      Lino.courses.PendingCourseRequests.DetailFormPanel.superclass.onRender.call(this, ct, position);
    }
    Lino.courses.PendingCourseRequests.DetailFormPanel.superclass.initComponent.call(this);
    // active_fields:
    offer1392.on("change",function(){this.save()},this);
  }
});


Lino.jobs.JobsOverview.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  disable_editing: true,
  initComponent : function() {
    var containing_panel = this;
    var body_htmlbox2541 = new Lino.HtmlBoxPanel({ "layout": "fit", "name": "body", "containing_panel": this, "items": new Ext.BoxComponent({autoScroll:true}), "master_panel": this, "value": "<br/>", "always_enabled": true, "bodyStyle": "overflow-x:hidden" });
    var main_panel2542 = new Ext.Panel({ "autoScroll": false, "border": false, "layout": "fit", "labelWidth": 0, "hideCheckBoxLabels": true, "items": [ body_htmlbox2541 ], "frame": true, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel2542;
    this.before_row_edit = function(record) {
      body_htmlbox2541.refresh();
    }
    Lino.jobs.JobsOverview.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.lino.Home.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  disable_editing: true,
  initComponent : function() {
    var containing_panel = this;
    var quick_links_htmlbox2534 = new Lino.HtmlBoxPanel({ "flex": 3, "layout": "fit", "name": "quick_links", "containing_panel": this, "items": new Ext.BoxComponent({autoScroll:true}), "master_panel": this, "value": "<br/>", "always_enabled": true, "bodyStyle": "overflow-x:hidden" });
    var welcome_htmlbox2535 = new Lino.HtmlBoxPanel({ "flex": 10, "layout": "fit", "name": "welcome", "containing_panel": this, "items": new Ext.BoxComponent({autoScroll:true}), "title": "Bienvenue", "master_panel": this, "value": "<br/>", "always_enabled": true, "bodyStyle": "overflow-x:hidden" });
    var UsersWithClients_htmlbox2536 = new Lino.HtmlBoxPanel({ "flex": 28, "layout": "fit", "name": "UsersWithClients", "containing_panel": this, "items": new Ext.BoxComponent({autoScroll:true}), "title": "Agents et leurs clients", "master_panel": this, "value": "<br/>", "always_enabled": true, "bodyStyle": "overflow-x:hidden", "tools": [ Lino.show_in_own_window_button(Lino.pcsw.UsersWithClients.grid) ] });
    var coming_reminders_htmlbox2537 = new Lino.HtmlBoxPanel({ "flex": 50, "layout": "fit", "name": "coming_reminders", "containing_panel": this, "items": new Ext.BoxComponent({autoScroll:true}), "title": "Rappels \u00e0 venir", "master_panel": this, "value": "<br/>", "always_enabled": true, "bodyStyle": "overflow-x:hidden" });
    var missed_reminders_htmlbox2538 = new Lino.HtmlBoxPanel({ "flex": 50, "layout": "fit", "name": "missed_reminders", "containing_panel": this, "items": new Ext.BoxComponent({autoScroll:true}), "title": "Rappels rat\u00e9s", "master_panel": this, "value": "<br/>", "always_enabled": true, "bodyStyle": "overflow-x:hidden" });
    var main_4_panel2539 = new Ext.Panel({ "flex": 57, "border": false, "layout": "hbox", "labelWidth": 144, "hideCheckBoxLabels": true, "items": [ coming_reminders_htmlbox2537, missed_reminders_htmlbox2538 ], "autoScroll": false, "layoutConfig": { "align": "stretch" }, "frame": false, "labelAlign": "top" });
    var main_panel2540 = new Ext.Panel({ "autoScroll": false, "border": false, "layout": "vbox", "labelWidth": 216, "hideCheckBoxLabels": true, "items": [ quick_links_htmlbox2534, welcome_htmlbox2535, UsersWithClients_htmlbox2536, main_4_panel2539 ], "frame": true, "layoutConfig": { "align": "stretch" }, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel2540;
    this.before_row_edit = function(record) {
      quick_links_htmlbox2534.refresh();
      welcome_htmlbox2535.refresh();
      UsersWithClients_htmlbox2536.refresh();
      coming_reminders_htmlbox2537.refresh();
      missed_reminders_htmlbox2538.refresh();
    }
    Lino.lino.Home.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.ui.Home.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  disable_editing: true,
  initComponent : function() {
    var containing_panel = this;
    var quick_links_htmlbox2529 = new Lino.HtmlBoxPanel({ "flex": 1, "layout": "fit", "name": "quick_links", "containing_panel": this, "items": new Ext.BoxComponent({autoScroll:true}), "region": "north", "master_panel": this, "value": "<br/>", "always_enabled": true, "bodyStyle": "overflow-x:hidden", "split": true });
    var welcome_htmlbox2530 = new Lino.HtmlBoxPanel({ "flex": 3, "layout": "fit", "name": "welcome", "containing_panel": this, "items": new Ext.BoxComponent({autoScroll:true}), "region": "center", "title": "Bienvenue", "master_panel": this, "value": "<br/>", "always_enabled": true, "bodyStyle": "overflow-x:hidden", "split": true });
    var main_panel2531 = new Lino.VBorderPanel({ "autoScroll": false, "border": false, "labelWidth": 90, "hideCheckBoxLabels": true, "items": [ quick_links_htmlbox2529, welcome_htmlbox2530 ], "frame": true, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel2531;
    this.before_row_edit = function(record) {
      quick_links_htmlbox2529.refresh();
      welcome_htmlbox2530.refresh();
    }
    Lino.ui.Home.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.jobs.NewJobsOverview.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  disable_editing: true,
  initComponent : function() {
    var containing_panel = this;
    var preview_htmlbox2550 = new Lino.HtmlBoxPanel({ "layout": "fit", "name": "preview", "containing_panel": this, "items": new Ext.BoxComponent({autoScroll:true}), "master_panel": this, "value": "<br/>", "always_enabled": true, "bodyStyle": "overflow-x:hidden" });
    var main_panel2551 = new Ext.Panel({ "autoScroll": false, "border": false, "layout": "fit", "labelWidth": 0, "hideCheckBoxLabels": true, "items": [ preview_htmlbox2550 ], "frame": true, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel2551;
    this.before_row_edit = function(record) {
      preview_htmlbox2550.refresh();
    }
    Lino.jobs.NewJobsOverview.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.countries.CitiesByCity.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 13,
  initComponent : function() {
    var containing_panel = this;
    var name424 = new Ext.form.TextField({ "fieldLabel": "Description", "name": "name", "maxLength": 200, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var name_fr425 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200, "fieldLabel": "Description (fr)", "anchor": "-20", "name": "name_fr" });
    var name_nl426 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200, "fieldLabel": "Description (nl)", "anchor": "-20", "name": "name_nl" });
    var country427 = new Lino.TwinCombo({ "fieldLabel": "Pays", "allowBlank": false, "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.countries.Countries.detail)}, "emptyText": "Choisir Pays...", "selectOnFocus": true, "hiddenName": "countryHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/countries/Cities/country", "method": "GET" }) }), "name": "country" });
    var inscode428 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("INS code","The official code for this place used by statbel.fgov.be") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">INS code</span>", "name": "inscode", "maxLength": 5, "selectOnFocus": true, "boxMinWidth": Lino.chars2width(5), "anchor": "-20" });
    var main_1_panel429 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 153, "hideCheckBoxLabels": true, "items": [ { "flex": 23, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name424, "labelAlign": "top" }, { "flex": 23, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_fr425, "labelAlign": "top" }, { "flex": 23, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_nl426, "labelAlign": "top" }, { "flex": 22, "autoHeight": true, "layout": "form", "xtype": "panel", "items": country427, "labelAlign": "top" }, { "flex": 6, "autoHeight": true, "layout": "form", "xtype": "panel", "items": inscode428, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var parent435 = new Lino.TwinCombo({ "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Part of</span>", "name": "parent", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.countries.Cities.detail)}, "emptyText": "Choisir Place...", "listeners": { "render": Lino.quicktip_renderer("Part of","The superordinate geographic place of which this place is a part.") }, "selectOnFocus": true, "hiddenName": "parentHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/countries/Cities/parent", "method": "GET" }) }) });
    var type436 = new Lino.RemoteComboFieldElement({ "fieldLabel": "Place Type", "name": "type", "selectOnFocus": true, "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/countries/Cities/type", "method": "GET" }) }), "hiddenName": "typeHidden" });
    var id437 = new Ext.form.NumberField({ "selectOnFocus": true, "fieldLabel": "ID", "anchor": "-20", "name": "id" });
    var main_2_panel438 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 99, "hideCheckBoxLabels": true, "items": [ { "flex": 57, "autoHeight": true, "layout": "form", "xtype": "panel", "items": parent435, "labelAlign": "top" }, { "flex": 28, "autoHeight": true, "layout": "form", "xtype": "panel", "items": type436, "labelAlign": "top" }, { "flex": 14, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id437, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var CitiesByCity_grid726 = new Lino.countries.CitiesByCity.GridPanel({ "tools": [ Lino.show_in_own_window_button(Lino.countries.CitiesByCity.grid) ], "containing_panel": this, "hide_top_toolbar": true, "master_panel": this, "flex": 41 });
    var contacts_PartnersByCity_grid727 = new Lino.contacts.PartnersByCity.GridPanel({ "tools": [ Lino.show_in_own_window_button(Lino.contacts.PartnersByCity.grid) ], "containing_panel": this, "hide_top_toolbar": true, "master_panel": this, "flex": 50 });
    var jobs_StudiesByCity_grid728 = new Lino.jobs.StudiesByCity.GridPanel({ "tools": [ Lino.show_in_own_window_button(Lino.jobs.StudiesByCity.grid) ], "containing_panel": this, "hide_top_toolbar": true, "master_panel": this, "flex": 50 });
    var main_4_panel729 = new Ext.Panel({ "flex": 41, "border": false, "layout": "hbox", "hideCheckBoxLabels": true, "items": [ contacts_PartnersByCity_grid727, jobs_StudiesByCity_grid728 ], "autoScroll": false, "layoutConfig": { "align": "stretch" }, "frame": false, "labelAlign": "top" });
    var main_panel730 = new Ext.Panel({ "autoScroll": false, "border": false, "layout": "vbox", "hideCheckBoxLabels": true, "items": [ main_1_panel429, main_2_panel438, CitiesByCity_grid726, main_4_panel729 ], "frame": true, "layoutConfig": { "align": "stretch" }, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel730;
    this.before_row_edit = function(record) {
      type436.setContextValue('country',record ? record.data['countryHidden'] : undefined);
      CitiesByCity_grid726.on_master_changed();
      contacts_PartnersByCity_grid727.on_master_changed();
      jobs_StudiesByCity_grid728.on_master_changed();
    }
    this.onRender = function(ct, position) {
      country427.on('change',Lino.chooser_handler(type436,'country'));
      Lino.countries.CitiesByCity.DetailFormPanel.superclass.onRender.call(this, ct, position);
    }
    Lino.countries.CitiesByCity.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.cal.TasksByUser.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 30,
  initComponent : function() {
    var containing_panel = this;
    var start_date286 = new Lino.DateField({ "selectOnFocus": true, "fieldLabel": "Date d\u00e9but", "anchor": "-20", "name": "start_date" });
    var due_date287 = new Lino.DateField({ "selectOnFocus": true, "fieldLabel": "Due date", "anchor": "-20", "name": "due_date" });
    var id288 = new Ext.form.NumberField({ "selectOnFocus": true, "fieldLabel": "ID", "anchor": "-20", "name": "id" });
    var workflow_buttons_disp289 = new Ext.form.DisplayField({ "disabled": true, "fieldLabel": "Arbeitsablauf", "name": "workflow_buttons", "anchor": "-20", "value": "<br/>", "always_enabled": true });
    var main_1_panel290 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 126, "hideCheckBoxLabels": true, "items": [ { "flex": 15, "autoHeight": true, "layout": "form", "xtype": "panel", "items": start_date286, "labelAlign": "top" }, { "flex": 15, "autoHeight": true, "layout": "form", "xtype": "panel", "items": due_date287, "labelAlign": "top" }, { "flex": 9, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id288, "labelAlign": "top" }, { "flex": 58, "autoHeight": true, "layout": "form", "xtype": "panel", "items": workflow_buttons_disp289, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var summary295 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200, "fieldLabel": "R\u00e9sum\u00e9", "anchor": "-20", "name": "summary" });
    var user296 = new Lino.TwinCombo({ "fieldLabel": "Auteur", "name": "user", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.users.Users.detail)}, "emptyText": "Choisir Utilisateur...", "selectOnFocus": true, "hiddenName": "userHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/Tasks/user", "method": "GET" }) }) });
    var project297 = new Lino.TwinCombo({ "fieldLabel": "Client", "name": "project", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.pcsw.Clients.detail)}, "emptyText": "Choisir Client...", "selectOnFocus": true, "hiddenName": "projectHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/Tasks/project", "method": "GET" }) }) });
    var main_3_panel298 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 63, "hideCheckBoxLabels": true, "items": [ { "flex": 42, "autoHeight": true, "layout": "form", "xtype": "panel", "items": user296, "labelAlign": "top" }, { "flex": 57, "autoHeight": true, "layout": "form", "xtype": "panel", "items": project297, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var calendar301 = new Lino.TwinCombo({ "fieldLabel": "Calendrier", "name": "calendar", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.cal.Calendars.detail)}, "emptyText": "Choisir Calendrier...", "selectOnFocus": true, "hiddenName": "calendarHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/Tasks/calendar", "method": "GET" }) }) });
    var owner_disp302 = new Ext.form.DisplayField({ "disabled": true, "fieldLabel": "Contr\u00f4l\u00e9 par", "anchor": "-20", "name": "owner" });
    var created303 = new Ext.form.DisplayField({ "disabled": true, "fieldLabel": "Cr\u00e9\u00e9", "anchor": "-20", "value": "<br>", "name": "created" });
    var modified304 = new Ext.form.DisplayField({ "disabled": true, "fieldLabel": "Modified", "anchor": "-20", "value": "<br>", "name": "modified" });
    var main_4_panel305 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 117, "hideCheckBoxLabels": true, "items": [ { "flex": 28, "autoHeight": true, "layout": "form", "xtype": "panel", "items": calendar301, "labelAlign": "top" }, { "flex": 14, "autoHeight": true, "layout": "form", "xtype": "panel", "items": owner_disp302, "labelAlign": "top" }, { "flex": 28, "autoHeight": true, "layout": "form", "xtype": "panel", "items": created303, "labelAlign": "top" }, { "flex": 28, "autoHeight": true, "layout": "form", "xtype": "panel", "items": modified304, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var description310 = new Lino.RichTextPanel({ "selectOnFocus": true, "flex": 45, "containing_panel": this, "name": "description", "title": "Description" });
    var main_panel311 = new Ext.Panel({ "autoScroll": false, "border": false, "layout": "vbox", "labelWidth": 63, "hideCheckBoxLabels": true, "items": [ main_1_panel290, { "items": summary295, "autoHeight": true, "layout": "form", "xtype": "panel", "labelAlign": "top" }, main_3_panel298, main_4_panel305, description310 ], "frame": true, "layoutConfig": { "align": "stretch" }, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel311;
    this.before_row_edit = function(record) {
      description310.refresh();
    }
    Lino.cal.TasksByUser.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.ui.MyTextFieldTemplates.InsertFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  autoHeight: true,
  content_type: 1,
  initComponent : function() {
    var containing_panel = this;
    var name2465 = new Ext.form.TextField({ "fieldLabel": "Description", "name": "name", "maxLength": 200, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var user2466 = new Lino.TwinCombo({ "fieldLabel": "Auteur", "name": "user", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.users.Users.detail)}, "emptyText": "Choisir Utilisateur...", "selectOnFocus": true, "hiddenName": "userHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/ui/TextFieldTemplates/user", "method": "GET" }) }) });
    var team2467 = new Lino.RemoteComboFieldElement({ "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Team</span>", "name": "team", "pageSize": 20, "emptyText": "Choisir Team...", "listeners": { "render": Lino.quicktip_renderer("Team","If not empty, then this template is reserved to members of this team.") }, "selectOnFocus": true, "hiddenName": "teamHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/ui/TextFieldTemplates/team", "method": "GET" }) }) });
    var main_2_panel2468 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 42, "autoHeight": true, "layout": "form", "xtype": "panel", "items": user2466, "labelAlign": "top" }, { "flex": 57, "autoHeight": true, "layout": "form", "xtype": "panel", "items": team2467, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 63, "border": false, "anchor": "-20", "labelAlign": "top" });
    var main_panel2471 = new Ext.Panel({ "hideCheckBoxLabels": true, "autoHeight": true, "border": false, "layout": "form", "labelWidth": 108, "autoScroll": false, "items": [ { "autoHeight": true, "layout": "form", "xtype": "panel", "items": name2465, "anchor": "-20", "labelAlign": "top" }, main_2_panel2468 ], "frame": true, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel2471;
    this.before_row_edit = function(record) {
    }
    Lino.ui.MyTextFieldTemplates.InsertFormPanel.superclass.initComponent.call(this);
  }
});


Lino.contacts.Companies.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 20,
  initComponent : function() {
    var containing_panel = this;
    var prefix747 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200, "fieldLabel": "prefix", "anchor": "-20", "name": "prefix" });
    var name748 = new Ext.form.TextField({ "fieldLabel": "Name", "name": "name", "maxLength": 200, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var id749 = new Ext.form.NumberField({ "selectOnFocus": true, "fieldLabel": "ID", "anchor": "-20", "name": "id" });
    var language750 = new Lino.ChoicesFieldElement({ "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Langue</span>", "allowBlank": false, "value": "de", "hiddenName": "languageHidden", "listeners": { "render": Lino.quicktip_renderer("Langue","Die Sprache, in der Dokumente ausgestellt werden sollen.") }, "selectOnFocus": true, "anchor": "-20", "store": [ [ "de", "German" ], [ "fr", "French" ], [ "nl", "Dutch" ] ], "name": "language" });
    var intro_box_1_panel751 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 31, "autoHeight": true, "layout": "form", "xtype": "panel", "items": prefix747, "labelAlign": "top" }, { "flex": 31, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name748, "labelAlign": "top" }, { "flex": 7, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id749, "labelAlign": "top" }, { "flex": 29, "autoHeight": true, "layout": "form", "xtype": "panel", "items": language750, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 63, "border": false, "anchor": "-20", "labelAlign": "top" });
    var vat_id756 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200, "fieldLabel": "N\u00b0 de TVA", "anchor": "-20", "name": "vat_id" });
    var activity757 = new Lino.RemoteComboFieldElement({ "fieldLabel": "Activit\u00e9", "name": "activity", "pageSize": 20, "emptyText": "Choisir Activit\u00e9...", "selectOnFocus": true, "hiddenName": "activityHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/contacts/Companies/activity", "method": "GET" }) }) });
    var type758 = new Lino.RemoteComboFieldElement({ "fieldLabel": "Type de soci\u00e9t\u00e9", "name": "type", "pageSize": 20, "emptyText": "Choisir Type d'organisation...", "selectOnFocus": true, "hiddenName": "typeHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/contacts/Companies/type", "method": "GET" }) }) });
    var intro_box_2_panel759 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 23, "autoHeight": true, "layout": "form", "xtype": "panel", "items": vat_id756, "labelAlign": "top" }, { "flex": 38, "autoHeight": true, "layout": "form", "xtype": "panel", "items": activity757, "labelAlign": "top" }, { "flex": 38, "autoHeight": true, "layout": "form", "xtype": "panel", "items": type758, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 144, "border": false, "anchor": "-20", "labelAlign": "top" });
    var bank_account1763 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 40, "fieldLabel": "Compte en banque 1", "anchor": "-20", "name": "bank_account1" });
    var bank_account2764 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 40, "fieldLabel": "Compte en banque 2", "anchor": "-20", "name": "bank_account2" });
    var is_obsolete765 = new Ext.form.Checkbox({ "boxLabel": "obsolete", "listeners": { "render": Lino.quicktip_renderer("obsolete","Altf\u00e4lle sind Partner, deren Stammdaten nicht mehr gepflegt werden und \nf\u00fcr neue Operationen nicht benutzt werden k\u00f6nnen.") }, "hideLabel": true, "checked": false, "name": "is_obsolete", "selectOnFocus": true, "anchor": "-20" });
    var intro_box_3_panel766 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 40, "autoHeight": true, "layout": "form", "xtype": "panel", "items": bank_account1763, "labelAlign": "top" }, { "flex": 40, "autoHeight": true, "layout": "form", "xtype": "panel", "items": bank_account2764, "labelAlign": "top" }, { "flex": 19, "autoHeight": true, "layout": "form", "xtype": "panel", "items": is_obsolete765, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 171, "border": false, "anchor": "-20", "labelAlign": "top" });
    var intro_box_panel770 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "form", "hideCheckBoxLabels": true, "items": [ intro_box_1_panel751, intro_box_2_panel759, intro_box_3_panel766 ], "frame": true, "bodyBorder": false, "labelAlign": "top" });
    var country771 = new Lino.TwinCombo({ "fieldLabel": "Pays", "name": "country", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.countries.Countries.detail)}, "emptyText": "Choisir Pays...", "selectOnFocus": true, "hiddenName": "countryHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/contacts/Companies/country", "method": "GET" }) }) });
    var region772 = new Lino.TwinCombo({ "fieldLabel": "Region", "name": "region", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.countries.Cities.detail)}, "emptyText": "Choisir Place...", "selectOnFocus": true, "hiddenName": "regionHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/contacts/Companies/region", "method": "GET" }) }) });
    var box3_1_panel773 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": country771, "labelAlign": "top" }, { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": region772, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 63, "border": false, "anchor": "-20", "labelAlign": "top" });
    var city776 = new Lino.TwinCombo({ "forceSelection": false, "fieldLabel": "Place", "name": "city", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.countries.Cities.detail)}, "emptyText": "Choisir Place...", "selectOnFocus": true, "hiddenName": "cityHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/contacts/Companies/city", "method": "GET" }) }) });
    var zip_code777 = new Ext.form.TextField({ "fieldLabel": "Zip code", "name": "zip_code", "maxLength": 10, "selectOnFocus": true, "boxMinWidth": Lino.chars2width(10), "anchor": "-20" });
    var box3_2_panel778 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 66, "autoHeight": true, "layout": "form", "xtype": "panel", "items": city776, "labelAlign": "top" }, { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": zip_code777, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 81, "border": false, "anchor": "-20", "labelAlign": "top" });
    var street_prefix781 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Pr\u00e9fixe rue","Text to print before name of street, but to ignore for sorting.") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Pr\u00e9fixe rue</span>", "name": "street_prefix", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var street782 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Rue","Name of street. Without house number.") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Rue</span>", "name": "street", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var street_no783 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("N\u00b0","House number") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">N\u00b0</span>", "name": "street_no", "maxLength": 10, "selectOnFocus": true, "boxMinWidth": Lino.chars2width(10), "anchor": "-20" });
    var street_box784 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("bo\u00eete","Text to print after :attr:`steet_no` on the same line") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">bo\u00eete</span>", "name": "street_box", "maxLength": 10, "selectOnFocus": true, "boxMinWidth": Lino.chars2width(10), "anchor": "-20" });
    var box3_3_panel785 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 30, "autoHeight": true, "layout": "form", "xtype": "panel", "items": street_prefix781, "labelAlign": "top" }, { "flex": 36, "autoHeight": true, "layout": "form", "xtype": "panel", "items": street782, "labelAlign": "top" }, { "flex": 16, "autoHeight": true, "layout": "form", "xtype": "panel", "items": street_no783, "labelAlign": "top" }, { "flex": 16, "autoHeight": true, "layout": "form", "xtype": "panel", "items": street_box784, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 108, "border": false, "anchor": "-20", "labelAlign": "top" });
    var addr2790 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Ligne apr\u00e8s le nom de rue","Address line to print below street line") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Ligne apr\u00e8s le nom de rue</span>", "name": "addr2", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var box3_panel791 = new Ext.Panel({ "flex": 62, "autoHeight": true, "layout": "form", "items": [ box3_1_panel773, box3_2_panel778, box3_3_panel785, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": addr2790, "anchor": "-20", "labelAlign": "top" } ], "frame": true, "bodyBorder": false, "autoScroll": false, "hideCheckBoxLabels": true, "labelWidth": 234, "border": false, "labelAlign": "top" });
    var email793 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 75, "fieldLabel": "E-mail", "anchor": "-20", "name": "email" });
    var url794 = new Lino.URLField({ "selectOnFocus": true, "maxLength": 200, "fieldLabel": "URL", "anchor": "-20", "name": "url" });
    var phone795 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200, "fieldLabel": "T\u00e9l\u00e9phone", "anchor": "-20", "name": "phone" });
    var gsm796 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200, "fieldLabel": "GSM", "anchor": "-20", "name": "gsm" });
    var box4_panel797 = new Ext.Panel({ "flex": 37, "autoHeight": true, "layout": "form", "items": [ { "autoHeight": true, "layout": "form", "xtype": "panel", "items": email793, "anchor": "-20", "labelAlign": "top" }, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": url794, "anchor": "-20", "labelAlign": "top" }, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": phone795, "anchor": "-20", "labelAlign": "top" }, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": gsm796, "anchor": "-20", "labelAlign": "top" } ], "frame": true, "bodyBorder": false, "autoScroll": false, "hideCheckBoxLabels": true, "labelWidth": 90, "border": false, "labelAlign": "top" });
    var address_box_panel802 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "hideCheckBoxLabels": true, "items": [ box3_panel791, box4_panel797 ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var remarks803 = new Ext.form.TextArea({ "selectOnFocus": true, "fieldLabel": "Remarques", "anchor": "-20 -10", "growMax": 2000, "name": "remarks" });
    var is_courseprovider804 = new Ext.form.Checkbox({ "selectOnFocus": true, "boxLabel": "est un organisateur de cours (<a href=\"javascript:Lino.show_mti_child('is_courseprovider',Lino.courses.CourseProviders.detail)\">montrer</a>)", "hideLabel": true, "anchor": "-20", "name": "is_courseprovider" });
    var is_jobprovider805 = new Ext.form.Checkbox({ "selectOnFocus": true, "boxLabel": "est Employant (<a href=\"javascript:Lino.show_mti_child('is_jobprovider',Lino.jobs.JobProviders.detail)\">montrer</a>)", "hideLabel": true, "anchor": "-20", "name": "is_jobprovider" });
    var client_contact_type806 = new Lino.RemoteComboFieldElement({ "fieldLabel": "Type de contact client", "name": "client_contact_type", "pageSize": 20, "emptyText": "Choisir Type de contact client...", "selectOnFocus": true, "hiddenName": "client_contact_typeHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/contacts/Companies/client_contact_type", "method": "GET" }) }) });
    var box5_2_panel807 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 261, "hideCheckBoxLabels": true, "items": [ { "flex": 25, "autoHeight": true, "layout": "form", "xtype": "panel", "items": is_courseprovider804, "labelAlign": "top" }, { "flex": 25, "autoHeight": true, "layout": "form", "xtype": "panel", "items": is_jobprovider805, "labelAlign": "top" }, { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": client_contact_type806, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var box5_panel811 = new Ext.Panel({ "flex": 57, "layout": "vbox", "items": [ { "items": remarks803, "labelAlign": "top", "layout": "form", "xtype": "panel", "flex": 83 }, box5_2_panel807 ], "frame": true, "layoutConfig": { "align": "stretch" }, "autoScroll": false, "hideCheckBoxLabels": true, "labelWidth": 90, "border": false, "bodyBorder": false, "labelAlign": "top" });
    var contacts_RolesByCompany_grid817 = new Lino.contacts.RolesByCompany.GridPanel({ "tools": [ Lino.show_in_own_window_button(Lino.contacts.RolesByCompany.grid) ], "containing_panel": this, "hide_top_toolbar": true, "master_panel": this, "flex": 42 });
    var bottom_box_panel818 = new Ext.Panel({ "flex": 46, "border": false, "layout": "hbox", "hideCheckBoxLabels": true, "items": [ box5_panel811, contacts_RolesByCompany_grid817 ], "autoScroll": false, "layoutConfig": { "align": "stretch" }, "frame": false, "labelAlign": "top" });
    var general_panel819 = new Ext.Panel({ "layout": "vbox", "title": "G\u00e9n\u00e9ral", "items": [ intro_box_panel770, address_box_panel802, bottom_box_panel818 ], "frame": true, "layoutConfig": { "align": "stretch" }, "hideCheckBoxLabels": true, "listeners": { "activate": Lino.on_tab_activate }, "autoScroll": false, "border": false, "bodyBorder": false, "labelAlign": "top" });
    var pcsw_NotesByCompany_grid884 = new Lino.pcsw.NotesByCompany.GridPanel({ "listeners": { "activate": Lino.on_tab_activate }, "hide_top_toolbar": true, "title": "Events/Notes", "containing_panel": this, "tools": [ Lino.show_in_own_window_button(Lino.pcsw.NotesByCompany.grid) ], "master_panel": this });
    var main_panel885 = new Ext.TabPanel({ "hideCheckBoxLabels": true, "border": false, "split": true, "autoScroll": false, "items": [ general_panel819, pcsw_NotesByCompany_grid884 ], "activeTab": 0, "bodyBorder": false, "frame": true, "labelAlign": "top" });
    this.items = main_panel885;
    this.before_row_edit = function(record) {
      region772.setContextValue('country',record ? record.data['countryHidden'] : undefined);
      city776.setContextValue('country',record ? record.data['countryHidden'] : undefined);
      city776.setContextValue('region',record ? record.data['regionHidden'] : undefined);
      contacts_RolesByCompany_grid817.on_master_changed();
      pcsw_NotesByCompany_grid884.on_master_changed();
    }
    this.onRender = function(ct, position) {
      country771.on('change',Lino.chooser_handler(region772,'country'));
      country771.on('change',Lino.chooser_handler(city776,'country'));
      region772.on('change',Lino.chooser_handler(city776,'region'));
      Lino.contacts.Companies.DetailFormPanel.superclass.onRender.call(this, ct, position);
    }
    Lino.contacts.Companies.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.contacts.Partners.InsertFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  autoHeight: true,
  content_type: 23,
  initComponent : function() {
    var containing_panel = this;
    var name702 = new Ext.form.TextField({ "fieldLabel": "Name", "name": "name", "maxLength": 200, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var language703 = new Lino.ChoicesFieldElement({ "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Langue</span>", "allowBlank": false, "value": "de", "hiddenName": "languageHidden", "listeners": { "render": Lino.quicktip_renderer("Langue","Die Sprache, in der Dokumente ausgestellt werden sollen.") }, "selectOnFocus": true, "anchor": "-20", "store": [ [ "de", "German" ], [ "fr", "French" ], [ "nl", "Dutch" ] ], "name": "language" });
    var email704 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 75, "fieldLabel": "E-mail", "anchor": "-20", "name": "email" });
    var main_2_panel705 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 48, "autoHeight": true, "layout": "form", "xtype": "panel", "items": language703, "labelAlign": "top" }, { "flex": 51, "autoHeight": true, "layout": "form", "xtype": "panel", "items": email704, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 63, "border": false, "anchor": "-20", "labelAlign": "top" });
    var main_panel708 = new Ext.Panel({ "hideCheckBoxLabels": true, "autoHeight": true, "border": false, "layout": "form", "labelWidth": 45, "autoScroll": false, "items": [ { "autoHeight": true, "layout": "form", "xtype": "panel", "items": name702, "anchor": "-20", "labelAlign": "top" }, main_2_panel705 ], "frame": true, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel708;
    this.before_row_edit = function(record) {
    }
    Lino.contacts.Partners.InsertFormPanel.superclass.initComponent.call(this);
  }
});


Lino.contacts.Persons.InsertFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  autoHeight: true,
  content_type: 21,
  initComponent : function() {
    var containing_panel = this;
    var title1134 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200, "fieldLabel": "Allocution", "anchor": "-20", "name": "title" });
    var first_name1135 = new Ext.form.TextField({ "fieldLabel": "Pr\u00e9nom", "name": "first_name", "maxLength": 200, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var last_name1136 = new Ext.form.TextField({ "fieldLabel": "Nom de famille", "name": "last_name", "maxLength": 200, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var main_1_panel1137 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": title1134, "labelAlign": "top" }, { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": first_name1135, "labelAlign": "top" }, { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": last_name1136, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 135, "border": false, "anchor": "-20", "labelAlign": "top" });
    var gender1141 = new Lino.ChoicesFieldElement({ "forceSelection": true, "fieldLabel": "Sexe", "name": "gender", "selectOnFocus": true, "anchor": "-20", "store": Lino.lino.Genders, "hiddenName": "genderHidden" });
    var language1142 = new Lino.ChoicesFieldElement({ "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Langue</span>", "allowBlank": false, "value": "de", "hiddenName": "languageHidden", "listeners": { "render": Lino.quicktip_renderer("Langue","Die Sprache, in der Dokumente ausgestellt werden sollen.") }, "selectOnFocus": true, "anchor": "-20", "store": [ [ "de", "German" ], [ "fr", "French" ], [ "nl", "Dutch" ] ], "name": "language" });
    var main_2_panel1143 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 35, "autoHeight": true, "layout": "form", "xtype": "panel", "items": gender1141, "labelAlign": "top" }, { "flex": 64, "autoHeight": true, "layout": "form", "xtype": "panel", "items": language1142, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 63, "border": false, "anchor": "-20", "labelAlign": "top" });
    var main_panel1146 = new Ext.Panel({ "hideCheckBoxLabels": true, "autoHeight": true, "border": false, "layout": "form", "autoScroll": false, "items": [ main_1_panel1137, main_2_panel1143 ], "frame": true, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel1146;
    this.before_row_edit = function(record) {
    }
    Lino.contacts.Persons.InsertFormPanel.superclass.initComponent.call(this);
  }
});


Lino.about.About.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  disable_editing: true,
  initComponent : function() {
    var containing_panel = this;
    var main_panel2533 = new Ext.Panel({ "autoScroll": false, "border": false, "layout": "fit", "hideCheckBoxLabels": true, "items": [ { "html": "<div class=\"htmlText\"><span>This is <a href=\"http://welfare.lino-framework.org\" target=\"_blank\">Lino Welfare</a> 1.1.6 using <a href=\"http://site.lino-framework.org\" target=\"_blank\">djangosite</a> 0.1.5, <a href=\"http://www.python.org/\" target=\"_blank\">Python</a> 2.7.3, <a href=\"http://www.djangoproject.com\" target=\"_blank\">Django</a> 1.5.1, <a href=\"http://babel.edgewall.org/\" target=\"_blank\">Babel</a> 1.0dev-r661, <a href=\"http://www.lino-framework.org\" target=\"_blank\">Lino</a> 1.6.9, <a href=\"http://jinja.pocoo.org/\" target=\"_blank\">Jinja</a> 2.6, <a href=\"http://sphinx-doc.org/\" target=\"_blank\">Sphinx</a> 1.2b1, <a href=\"http://labix.org/python-dateutil\" target=\"_blank\">python-dateutil</a> 2.1, <a href=\"http://pypi.python.org/pypi/odfpy\" target=\"_blank\">OdfPy</a> ODFPY/0.9.6, <a href=\"http://docutils.sourceforge.net/\" target=\"_blank\">docutils</a> 0.10, <a href=\"https://fedorahosted.org/suds/\" target=\"_blank\">suds</a> 0.4, <a href=\"http://pyyaml.org/\" target=\"_blank\">PyYaml</a> 3.10, <a href=\"http://appyframework.org/pod.html\" target=\"_blank\">Appy</a> 0.8.3 (2013/02/22 15:29)</span><p>Server uptime : <b>jeudi 30 mai 2013 at 06:54:28.976944</b></p><p>Source timestamps:</p><ul><li>lino : <b>jeudi 30 mai 2013 at 06:54:27.733736</b></li><li>lino_welfare : <b>lundi 27 mai 2013 at 15:53:14.838787</b></li><li>djangosite : <b>vendredi 24 mai 2013 at 12:39:59.567402</b></li><li>atelier : <b>jeudi 16 mai 2013 at 05:05:10.678849</b></li><li>django : <b>mercredi 8 mai 2013 at 10:18:59.384324</b></li><li>north : <b>dimanche 5 mai 2013 at 22:52:00.438131</b></li></ul></div>", "xtype": "label" } ], "frame": true, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel2533;
    this.before_row_edit = function(record) {
    }
    Lino.about.About.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.contacts.Companies.InsertFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  autoHeight: true,
  content_type: 20,
  initComponent : function() {
    var containing_panel = this;
    var name886 = new Ext.form.TextField({ "fieldLabel": "Name", "name": "name", "maxLength": 200, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var language887 = new Lino.ChoicesFieldElement({ "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Langue</span>", "allowBlank": false, "value": "de", "hiddenName": "languageHidden", "listeners": { "render": Lino.quicktip_renderer("Langue","Die Sprache, in der Dokumente ausgestellt werden sollen.") }, "selectOnFocus": true, "anchor": "-20", "store": [ [ "de", "German" ], [ "fr", "French" ], [ "nl", "Dutch" ] ], "name": "language" });
    var email888 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 75, "fieldLabel": "E-mail", "anchor": "-20", "name": "email" });
    var main_2_panel889 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": language887, "labelAlign": "top" }, { "flex": 66, "autoHeight": true, "layout": "form", "xtype": "panel", "items": email888, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 63, "border": false, "anchor": "-20", "labelAlign": "top" });
    var type892 = new Lino.RemoteComboFieldElement({ "fieldLabel": "Type de soci\u00e9t\u00e9", "name": "type", "pageSize": 20, "emptyText": "Choisir Type d'organisation...", "selectOnFocus": true, "hiddenName": "typeHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/contacts/Companies/type", "method": "GET" }) }) });
    var id893 = new Ext.form.NumberField({ "selectOnFocus": true, "fieldLabel": "ID", "anchor": "-20", "name": "id" });
    var main_3_panel894 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 80, "autoHeight": true, "layout": "form", "xtype": "panel", "items": type892, "labelAlign": "top" }, { "flex": 20, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id893, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 144, "border": false, "anchor": "-20", "labelAlign": "top" });
    var main_panel897 = new Ext.Panel({ "hideCheckBoxLabels": true, "autoHeight": true, "border": false, "layout": "form", "labelWidth": 45, "autoScroll": false, "items": [ { "autoHeight": true, "layout": "form", "xtype": "panel", "items": name886, "anchor": "-20", "labelAlign": "top" }, main_2_panel889, main_3_panel894 ], "frame": true, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel897;
    this.before_row_edit = function(record) {
    }
    Lino.contacts.Companies.InsertFormPanel.superclass.initComponent.call(this);
  }
});


Lino.cbss.ManageAccessRequests.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 91,
  initComponent : function() {
    var containing_panel = this;
    var id2320 = new Ext.form.NumberField({ "selectOnFocus": true, "fieldLabel": "ID", "anchor": "-20", "name": "id" });
    var person2321 = new Lino.TwinCombo({ "fieldLabel": "Client", "allowBlank": false, "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.pcsw.Clients.detail)}, "emptyText": "Choisir Client...", "selectOnFocus": true, "hiddenName": "personHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cbss/ManageAccessRequests/person", "method": "GET" }) }), "name": "person" });
    var user2322 = new Lino.TwinCombo({ "fieldLabel": "Auteur", "allowBlank": false, "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.users.Users.detail)}, "emptyText": "Choisir Utilisateur...", "selectOnFocus": true, "hiddenName": "userHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cbss/ManageAccessRequests/user", "method": "GET" }) }), "name": "user" });
    var environment2323 = new Ext.form.TextField({ "disabled": true, "fieldLabel": "T/A/B", "name": "environment", "maxLength": 4, "boxMinWidth": Lino.chars2width(4), "anchor": "-20" });
    var sent2324 = new Ext.form.DisplayField({ "disabled": true, "listeners": { "render": Lino.quicktip_renderer("Ex\u00e9cut\u00e9","The date and time when this request has been executed. \nThis is empty for requests than haven't been sent.\nRead-only.") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Ex\u00e9cut\u00e9</span>", "name": "sent", "anchor": "-20", "value": "<br>" });
    var status2325 = new Lino.ChoicesFieldElement({ "disabled": true, "forceSelection": true, "fieldLabel": "State", "name": "status", "anchor": "-20", "store": Lino.cbss.RequestStates, "hiddenName": "statusHidden" });
    var ticket2326 = new Ext.form.TextField({ "disabled": true, "maxLength": 36, "fieldLabel": "Ticket", "anchor": "-20", "name": "ticket" });
    var info_1_panel2327 = new Ext.form.FieldSet({ "autoHeight": true, "layout": "hbox", "title": "Information requ\u00eate", "layoutConfig": { "align": "stretchmax" }, "frame": false, "bodyBorder": true, "autoScroll": false, "items": [ { "flex": 5, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id2320, "labelAlign": "top" }, { "flex": 20, "autoHeight": true, "layout": "form", "xtype": "panel", "items": person2321, "labelAlign": "top" }, { "flex": 15, "autoHeight": true, "layout": "form", "xtype": "panel", "items": user2322, "labelAlign": "top" }, { "flex": 5, "autoHeight": true, "layout": "form", "xtype": "panel", "items": environment2323, "labelAlign": "top" }, { "flex": 16, "autoHeight": true, "layout": "form", "xtype": "panel", "items": sent2324, "labelAlign": "top" }, { "flex": 18, "autoHeight": true, "layout": "form", "xtype": "panel", "items": status2325, "labelAlign": "top" }, { "flex": 21, "autoHeight": true, "layout": "form", "xtype": "panel", "items": ticket2326, "labelAlign": "top" } ], "hideCheckBoxLabels": true, "labelWidth": 72, "border": false, "labelAlign": "top" });
    var action2335 = new Lino.ChoicesFieldElement({ "forceSelection": true, "fieldLabel": "Action", "allowBlank": false, "hiddenName": "actionHidden", "selectOnFocus": true, "anchor": "-20", "store": Lino.cbss.ManageAction, "name": "action" });
    var start_date2336 = new Lino.DateField({ "selectOnFocus": true, "allowBlank": false, "fieldLabel": "P\u00e9riode du", "anchor": "-20", "name": "start_date" });
    var end_date2337 = new Lino.DateField({ "selectOnFocus": true, "allowBlank": false, "fieldLabel": "P\u00e9riode au", "anchor": "-20", "name": "end_date" });
    var p1_1_panel2338 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 48, "autoHeight": true, "layout": "form", "xtype": "panel", "items": action2335, "labelAlign": "top" }, { "flex": 25, "autoHeight": true, "layout": "form", "xtype": "panel", "items": start_date2336, "labelAlign": "top" }, { "flex": 25, "autoHeight": true, "layout": "form", "xtype": "panel", "items": end_date2337, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 99, "border": false, "anchor": "-20", "labelAlign": "top" });
    var purpose2342 = new Lino.RemoteComboFieldElement({ "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Code fonction</span>", "allowBlank": false, "pageSize": 20, "emptyText": "Choisir Code fonction...", "listeners": { "render": Lino.quicktip_renderer("Code fonction","The purpose for which the inscription needs to be \nregistered/unregistered or listed. \nFor listing this field is optional, \nfor register/unregister it is mandatory.") }, "selectOnFocus": true, "hiddenName": "purposeHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cbss/ManageAccessRequests/purpose", "method": "GET" }) }), "name": "purpose" });
    var query_register2343 = new Lino.ChoicesFieldElement({ "forceSelection": true, "fieldLabel": "Query Register", "allowBlank": false, "hiddenName": "query_registerHidden", "selectOnFocus": true, "anchor": "-20", "store": Lino.cbss.QueryRegister, "name": "query_register" });
    var p1_2_panel2344 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 64, "autoHeight": true, "layout": "form", "xtype": "panel", "items": purpose2342, "labelAlign": "top" }, { "flex": 35, "autoHeight": true, "layout": "form", "xtype": "panel", "items": query_register2343, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 135, "border": false, "anchor": "-20", "labelAlign": "top" });
    var p1_panel2347 = new Ext.form.FieldSet({ "flex": 36, "autoHeight": true, "layout": "form", "title": "Action demand\u00e9e", "items": [ p1_1_panel2338, p1_2_panel2344 ], "frame": true, "bodyBorder": false, "autoScroll": false, "hideCheckBoxLabels": true, "border": false, "labelAlign": "top" });
    var national_id2348 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("NISS","The SSIN of the person to register/unregister/list.\n") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">NISS</span>", "name": "national_id", "maxLength": 200, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var sis_card_no2349 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("No carte SIS","The number of the SIS card used to authenticate the person.") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">No carte SIS</span>", "name": "sis_card_no", "maxLength": 10, "selectOnFocus": true, "boxMinWidth": Lino.chars2width(10), "anchor": "-20" });
    var id_card_no2350 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("No carte eID","The number of the ID card used to authenticate the person.") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">No carte eID</span>", "name": "id_card_no", "maxLength": 20, "selectOnFocus": true, "anchor": "-20" });
    var proof_1_panel2351 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 39, "autoHeight": true, "layout": "form", "xtype": "panel", "items": national_id2348, "labelAlign": "top" }, { "flex": 20, "autoHeight": true, "layout": "form", "xtype": "panel", "items": sis_card_no2349, "labelAlign": "top" }, { "flex": 39, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id_card_no2350, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 117, "border": false, "anchor": "-20", "labelAlign": "top" });
    var first_name2355 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200, "fieldLabel": "Pr\u00e9nom", "anchor": "-20", "name": "first_name" });
    var last_name2356 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200, "fieldLabel": "Nom de famille", "anchor": "-20", "name": "last_name" });
    var birth_date2357 = new Lino.IncompleteDateField({ "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("date de naissance","Unkomplette Datumsangaben sind erlaubt, z.B. \"00.00.1980\" hei\u00dft \"irgendwann im Jahr 1980\", \"00.07.1980\" hei\u00dft \"im Juli 1980\"oder \"23.07.0000\" hei\u00dft \"an einem 23. Juli\".") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">date de naissance</span>", "anchor": "-20", "name": "birth_date" });
    var proof_2_panel2358 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 38, "autoHeight": true, "layout": "form", "xtype": "panel", "items": first_name2355, "labelAlign": "top" }, { "flex": 38, "autoHeight": true, "layout": "form", "xtype": "panel", "items": last_name2356, "labelAlign": "top" }, { "flex": 22, "autoHeight": true, "layout": "form", "xtype": "panel", "items": birth_date2357, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 162, "border": false, "anchor": "-20", "labelAlign": "top" });
    var proof_panel2362 = new Ext.form.FieldSet({ "flex": 63, "autoHeight": true, "layout": "form", "title": "Preuve d'identification", "items": [ proof_1_panel2351, proof_2_panel2358 ], "frame": true, "bodyBorder": false, "autoScroll": false, "hideCheckBoxLabels": true, "border": false, "labelAlign": "top" });
    var parameters_panel2363 = new Ext.form.FieldSet({ "autoHeight": true, "layout": "hbox", "title": "Param\u00e8tres", "layoutConfig": { "align": "stretchmax" }, "frame": false, "bodyBorder": true, "autoScroll": false, "items": [ p1_panel2347, proof_panel2362 ], "hideCheckBoxLabels": true, "border": false, "labelAlign": "top" });
    var result_htmlbox2364 = new Lino.HtmlBoxPanel({ "flex": 50, "layout": "fit", "name": "result", "containing_panel": this, "items": new Ext.BoxComponent({autoScroll:true}), "title": "R\u015bultat", "master_panel": this, "value": "<br/>", "always_enabled": true, "bodyStyle": "overflow-x:hidden" });
    var request_panel2365 = new Ext.Panel({ "layout": "vbox", "title": "Requ\u00eate", "items": [ info_1_panel2327, parameters_panel2363, result_htmlbox2364 ], "frame": true, "layoutConfig": { "align": "stretch" }, "hideCheckBoxLabels": true, "listeners": { "activate": Lino.on_tab_activate }, "autoScroll": false, "labelWidth": 72, "border": false, "bodyBorder": false, "labelAlign": "top" });
    var main_panel2373 = new Ext.TabPanel({ "hideCheckBoxLabels": true, "border": false, "split": true, "autoScroll": false, "items": [ request_panel2365 ], "activeTab": 0, "bodyBorder": false, "frame": true, "labelAlign": "top" });
    this.items = main_panel2373;
    this.before_row_edit = function(record) {
      purpose2342.setContextValue('sector',record ? record.data['sectorHidden'] : undefined);
      result_htmlbox2364.refresh();
    }
    Lino.cbss.ManageAccessRequests.DetailFormPanel.superclass.initComponent.call(this);
    // active_fields:
    person2321.on("change",function(){this.save()},this);
  }
});


Lino.courses.CoursesByOffer.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 79,
  initComponent : function() {
    var containing_panel = this;
    var id2182 = new Ext.form.NumberField({ "selectOnFocus": true, "fieldLabel": "ID", "anchor": "-20", "name": "id" });
    var start_date2183 = new Lino.DateField({ "selectOnFocus": true, "allowBlank": false, "fieldLabel": "Date de d\u00e9but", "anchor": "-20", "name": "start_date" });
    var offer2184 = new Lino.TwinCombo({ "fieldLabel": "Offre de cours", "allowBlank": false, "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.courses.CourseOffers.detail)}, "emptyText": "Choisir Offre de cours...", "selectOnFocus": true, "hiddenName": "offerHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/courses/Courses/offer", "method": "GET" }) }), "name": "offer" });
    var title2185 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200, "fieldLabel": "Name", "anchor": "-20", "name": "title" });
    var main_1_panel2186 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 135, "hideCheckBoxLabels": true, "items": [ { "flex": 14, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id2182, "labelAlign": "top" }, { "flex": 14, "autoHeight": true, "layout": "form", "xtype": "panel", "items": start_date2183, "labelAlign": "top" }, { "flex": 35, "autoHeight": true, "layout": "form", "xtype": "panel", "items": offer2184, "labelAlign": "top" }, { "flex": 36, "autoHeight": true, "layout": "form", "xtype": "panel", "items": title2185, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var remark2191 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200, "fieldLabel": "Remarque", "anchor": "-20", "name": "remark" });
    var courses_ParticipantsByCourse_grid2197 = new Lino.courses.ParticipantsByCourse.GridPanel({ "tools": [ Lino.show_in_own_window_button(Lino.courses.ParticipantsByCourse.grid) ], "containing_panel": this, "hide_top_toolbar": true, "master_panel": this, "flex": 41 });
    var courses_CandidatesByCourse_grid2204 = new Lino.courses.CandidatesByCourse.GridPanel({ "tools": [ Lino.show_in_own_window_button(Lino.courses.CandidatesByCourse.grid) ], "containing_panel": this, "hide_top_toolbar": true, "master_panel": this, "flex": 41 });
    var main_panel2205 = new Ext.Panel({ "autoScroll": false, "border": false, "layout": "vbox", "labelWidth": 81, "hideCheckBoxLabels": true, "items": [ main_1_panel2186, { "items": remark2191, "autoHeight": true, "layout": "form", "xtype": "panel", "labelAlign": "top" }, courses_ParticipantsByCourse_grid2197, courses_CandidatesByCourse_grid2204 ], "frame": true, "layoutConfig": { "align": "stretch" }, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel2205;
    this.before_row_edit = function(record) {
      courses_ParticipantsByCourse_grid2197.on_master_changed();
      courses_CandidatesByCourse_grid2204.on_master_changed();
    }
    Lino.courses.CoursesByOffer.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.cbss.RetrieveTIGroupsRequests.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 90,
  initComponent : function() {
    var containing_panel = this;
    var id2405 = new Ext.form.NumberField({ "selectOnFocus": true, "fieldLabel": "ID", "anchor": "-20", "name": "id" });
    var person2406 = new Lino.TwinCombo({ "fieldLabel": "Client", "allowBlank": false, "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.pcsw.Clients.detail)}, "emptyText": "Choisir Client...", "selectOnFocus": true, "hiddenName": "personHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cbss/RetrieveTIGroupsRequests/person", "method": "GET" }) }), "name": "person" });
    var user2407 = new Lino.TwinCombo({ "fieldLabel": "Auteur", "allowBlank": false, "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.users.Users.detail)}, "emptyText": "Choisir Utilisateur...", "selectOnFocus": true, "hiddenName": "userHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cbss/RetrieveTIGroupsRequests/user", "method": "GET" }) }), "name": "user" });
    var environment2408 = new Ext.form.TextField({ "disabled": true, "fieldLabel": "T/A/B", "name": "environment", "maxLength": 4, "boxMinWidth": Lino.chars2width(4), "anchor": "-20" });
    var sent2409 = new Ext.form.DisplayField({ "disabled": true, "listeners": { "render": Lino.quicktip_renderer("Ex\u00e9cut\u00e9","The date and time when this request has been executed. \nThis is empty for requests than haven't been sent.\nRead-only.") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Ex\u00e9cut\u00e9</span>", "name": "sent", "anchor": "-20", "value": "<br>" });
    var status2410 = new Lino.ChoicesFieldElement({ "disabled": true, "forceSelection": true, "fieldLabel": "State", "name": "status", "anchor": "-20", "store": Lino.cbss.RequestStates, "hiddenName": "statusHidden" });
    var ticket2411 = new Ext.form.TextField({ "disabled": true, "maxLength": 36, "fieldLabel": "Ticket", "anchor": "-20", "name": "ticket" });
    var info_1_panel2412 = new Ext.form.FieldSet({ "autoHeight": true, "layout": "hbox", "title": "Information requ\u00eate", "layoutConfig": { "align": "stretchmax" }, "frame": false, "bodyBorder": true, "autoScroll": false, "items": [ { "flex": 5, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id2405, "labelAlign": "top" }, { "flex": 20, "autoHeight": true, "layout": "form", "xtype": "panel", "items": person2406, "labelAlign": "top" }, { "flex": 15, "autoHeight": true, "layout": "form", "xtype": "panel", "items": user2407, "labelAlign": "top" }, { "flex": 5, "autoHeight": true, "layout": "form", "xtype": "panel", "items": environment2408, "labelAlign": "top" }, { "flex": 16, "autoHeight": true, "layout": "form", "xtype": "panel", "items": sent2409, "labelAlign": "top" }, { "flex": 18, "autoHeight": true, "layout": "form", "xtype": "panel", "items": status2410, "labelAlign": "top" }, { "flex": 21, "autoHeight": true, "layout": "form", "xtype": "panel", "items": ticket2411, "labelAlign": "top" } ], "hideCheckBoxLabels": true, "labelWidth": 72, "border": false, "labelAlign": "top" });
    var national_id2420 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200, "fieldLabel": "NISS", "anchor": "-20", "name": "national_id" });
    var language2421 = new Lino.ChoicesFieldElement({ "forceSelection": true, "fieldLabel": "Langue", "name": "language", "selectOnFocus": true, "anchor": "-20", "store": Lino.cbss.RequestLanguages, "hiddenName": "languageHidden" });
    var history2422 = new Ext.form.Checkbox({ "boxLabel": "Historique", "listeners": { "render": Lino.quicktip_renderer("Historique","Whatever this means.") }, "hideLabel": true, "checked": true, "name": "history", "selectOnFocus": true, "anchor": "-20" });
    var parameters_panel2423 = new Ext.form.FieldSet({ "autoHeight": true, "layout": "hbox", "title": "Param\u00e8tres", "layoutConfig": { "align": "stretchmax" }, "frame": false, "bodyBorder": true, "autoScroll": false, "items": [ { "flex": 43, "autoHeight": true, "layout": "form", "xtype": "panel", "items": national_id2420, "labelAlign": "top" }, { "flex": 35, "autoHeight": true, "layout": "form", "xtype": "panel", "items": language2421, "labelAlign": "top" }, { "flex": 20, "autoHeight": true, "layout": "form", "xtype": "panel", "items": history2422, "labelAlign": "top" } ], "hideCheckBoxLabels": true, "labelWidth": 99, "border": false, "labelAlign": "top" });
    var cbss_RetrieveTIGroupsResult_grid2432 = new Lino.cbss.RetrieveTIGroupsResult.GridPanel({ "tools": [ Lino.show_in_own_window_button(Lino.cbss.RetrieveTIGroupsResult.grid) ], "containing_panel": this, "hide_top_toolbar": true, "master_panel": this, "flex": 71 });
    var request_panel2433 = new Ext.Panel({ "layout": "vbox", "title": "Requ\u00eate", "items": [ info_1_panel2412, parameters_panel2423, cbss_RetrieveTIGroupsResult_grid2432 ], "frame": true, "layoutConfig": { "align": "stretch" }, "hideCheckBoxLabels": true, "listeners": { "activate": Lino.on_tab_activate }, "autoScroll": false, "border": false, "bodyBorder": false, "labelAlign": "top" });
    var response_xml2434 = new Ext.form.TextArea({ "disabled": true, "listeners": { "render": Lino.quicktip_renderer("R\u00e9ponse","The raw XML response received. \n") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">R\u00e9ponse</span>", "name": "response_xml", "growMax": 2000, "anchor": "-20 -10" });
    var info_messages2435 = new Ext.form.TextArea({ "disabled": true, "fieldLabel": "Messages info", "anchor": "-20 -10", "growMax": 2000, "name": "info_messages" });
    var debug_messages2436 = new Ext.form.TextArea({ "disabled": true, "fieldLabel": "Messages debug", "anchor": "-20 -10", "growMax": 2000, "name": "debug_messages" });
    var technical_panel2437 = new Lino.VBorderPanel({ "autoScroll": false, "listeners": { "activate": Lino.on_tab_activate }, "border": false, "labelWidth": 135, "title": "Technique", "hideCheckBoxLabels": true, "items": [ { "flex": 5, "layout": "form", "xtype": "panel", "items": response_xml2434, "region": "north", "labelAlign": "top", "split": true }, { "flex": 5, "layout": "form", "xtype": "panel", "items": info_messages2435, "region": "center", "labelAlign": "top", "split": true }, { "flex": 5, "layout": "form", "xtype": "panel", "items": debug_messages2436, "region": "south", "labelAlign": "top", "split": true } ], "frame": true, "bodyBorder": false, "labelAlign": "top" });
    var main_panel2441 = new Ext.TabPanel({ "hideCheckBoxLabels": true, "border": false, "split": true, "autoScroll": false, "items": [ request_panel2433, technical_panel2437 ], "activeTab": 0, "bodyBorder": false, "frame": true, "labelAlign": "top" });
    this.items = main_panel2441;
    this.before_row_edit = function(record) {
      cbss_RetrieveTIGroupsResult_grid2432.on_master_changed();
    }
    Lino.cbss.RetrieveTIGroupsRequests.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.cbss.ManageAccessRequests.InsertFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  autoHeight: true,
  content_type: 91,
  initComponent : function() {
    var containing_panel = this;
    var person2374 = new Lino.TwinCombo({ "fieldLabel": "Client", "allowBlank": false, "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.pcsw.Clients.detail)}, "emptyText": "Choisir Client...", "selectOnFocus": true, "hiddenName": "personHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cbss/ManageAccessRequests/person", "method": "GET" }) }), "name": "person" });
    var action2375 = new Lino.ChoicesFieldElement({ "forceSelection": true, "fieldLabel": "Action", "allowBlank": false, "hiddenName": "actionHidden", "selectOnFocus": true, "anchor": "-20", "store": Lino.cbss.ManageAction, "name": "action" });
    var start_date2376 = new Lino.DateField({ "selectOnFocus": true, "allowBlank": false, "fieldLabel": "P\u00e9riode du", "anchor": "-20", "name": "start_date" });
    var end_date2377 = new Lino.DateField({ "selectOnFocus": true, "allowBlank": false, "fieldLabel": "P\u00e9riode au", "anchor": "-20", "name": "end_date" });
    var p1_1_panel2378 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 48, "autoHeight": true, "layout": "form", "xtype": "panel", "items": action2375, "labelAlign": "top" }, { "flex": 25, "autoHeight": true, "layout": "form", "xtype": "panel", "items": start_date2376, "labelAlign": "top" }, { "flex": 25, "autoHeight": true, "layout": "form", "xtype": "panel", "items": end_date2377, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 99, "border": false, "anchor": "-20", "labelAlign": "top" });
    var purpose2382 = new Lino.RemoteComboFieldElement({ "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Code fonction</span>", "allowBlank": false, "pageSize": 20, "emptyText": "Choisir Code fonction...", "listeners": { "render": Lino.quicktip_renderer("Code fonction","The purpose for which the inscription needs to be \nregistered/unregistered or listed. \nFor listing this field is optional, \nfor register/unregister it is mandatory.") }, "selectOnFocus": true, "hiddenName": "purposeHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cbss/ManageAccessRequests/purpose", "method": "GET" }) }), "name": "purpose" });
    var query_register2383 = new Lino.ChoicesFieldElement({ "forceSelection": true, "fieldLabel": "Query Register", "allowBlank": false, "hiddenName": "query_registerHidden", "selectOnFocus": true, "anchor": "-20", "store": Lino.cbss.QueryRegister, "name": "query_register" });
    var p1_2_panel2384 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 64, "autoHeight": true, "layout": "form", "xtype": "panel", "items": purpose2382, "labelAlign": "top" }, { "flex": 35, "autoHeight": true, "layout": "form", "xtype": "panel", "items": query_register2383, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 135, "border": false, "anchor": "-20", "labelAlign": "top" });
    var p1_panel2387 = new Ext.form.FieldSet({ "autoHeight": true, "layout": "form", "title": "Action demand\u00e9e", "items": [ p1_1_panel2378, p1_2_panel2384 ], "frame": true, "bodyBorder": false, "autoScroll": false, "hideCheckBoxLabels": true, "border": false, "anchor": "-20", "labelAlign": "top" });
    var national_id2388 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("NISS","The SSIN of the person to register/unregister/list.\n") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">NISS</span>", "name": "national_id", "maxLength": 200, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var sis_card_no2389 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("No carte SIS","The number of the SIS card used to authenticate the person.") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">No carte SIS</span>", "name": "sis_card_no", "maxLength": 10, "selectOnFocus": true, "boxMinWidth": Lino.chars2width(10), "anchor": "-20" });
    var id_card_no2390 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("No carte eID","The number of the ID card used to authenticate the person.") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">No carte eID</span>", "name": "id_card_no", "maxLength": 20, "selectOnFocus": true, "anchor": "-20" });
    var proof_1_panel2391 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 39, "autoHeight": true, "layout": "form", "xtype": "panel", "items": national_id2388, "labelAlign": "top" }, { "flex": 20, "autoHeight": true, "layout": "form", "xtype": "panel", "items": sis_card_no2389, "labelAlign": "top" }, { "flex": 39, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id_card_no2390, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 117, "border": false, "anchor": "-20", "labelAlign": "top" });
    var first_name2395 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200, "fieldLabel": "Pr\u00e9nom", "anchor": "-20", "name": "first_name" });
    var last_name2396 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200, "fieldLabel": "Nom de famille", "anchor": "-20", "name": "last_name" });
    var birth_date2397 = new Lino.IncompleteDateField({ "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("date de naissance","Unkomplette Datumsangaben sind erlaubt, z.B. \"00.00.1980\" hei\u00dft \"irgendwann im Jahr 1980\", \"00.07.1980\" hei\u00dft \"im Juli 1980\"oder \"23.07.0000\" hei\u00dft \"an einem 23. Juli\".") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">date de naissance</span>", "anchor": "-20", "name": "birth_date" });
    var proof_2_panel2398 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 38, "autoHeight": true, "layout": "form", "xtype": "panel", "items": first_name2395, "labelAlign": "top" }, { "flex": 38, "autoHeight": true, "layout": "form", "xtype": "panel", "items": last_name2396, "labelAlign": "top" }, { "flex": 22, "autoHeight": true, "layout": "form", "xtype": "panel", "items": birth_date2397, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 162, "border": false, "anchor": "-20", "labelAlign": "top" });
    var proof_panel2402 = new Ext.form.FieldSet({ "autoHeight": true, "layout": "form", "title": "Preuve d'identification", "items": [ proof_1_panel2391, proof_2_panel2398 ], "frame": true, "bodyBorder": false, "autoScroll": false, "hideCheckBoxLabels": true, "border": false, "anchor": "-20", "labelAlign": "top" });
    var main_panel2403 = new Ext.Panel({ "hideCheckBoxLabels": true, "autoHeight": true, "border": false, "layout": "form", "labelWidth": 63, "autoScroll": false, "items": [ { "autoHeight": true, "layout": "form", "xtype": "panel", "items": person2374, "anchor": "-20", "labelAlign": "top" }, p1_panel2387, proof_panel2402 ], "frame": true, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel2403;
    this.before_row_edit = function(record) {
      purpose2382.setContextValue('sector',record ? record.data['sectorHidden'] : undefined);
    }
    Lino.cbss.ManageAccessRequests.InsertFormPanel.superclass.initComponent.call(this);
    // active_fields:
    person2374.on("change",function(){this.save()},this);
  }
});


Lino.courses.CourseOffers.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 82,
  initComponent : function() {
    var containing_panel = this;
    var id2167 = new Ext.form.NumberField({ "selectOnFocus": true, "fieldLabel": "ID", "anchor": "-20", "name": "id" });
    var title2168 = new Ext.form.TextField({ "fieldLabel": "Name", "name": "title", "maxLength": 200, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var content2169 = new Lino.TwinCombo({ "fieldLabel": "Contenu de cours", "allowBlank": false, "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.courses.CourseContents.detail)}, "emptyText": "Choisir Contenu de cours...", "selectOnFocus": true, "hiddenName": "contentHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/courses/CourseOffers/content", "method": "GET" }) }), "name": "content" });
    var provider2170 = new Lino.TwinCombo({ "fieldLabel": "Organisateur de cours", "allowBlank": false, "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.courses.CourseProviders.detail)}, "emptyText": "Choisir Organisateur de cours...", "selectOnFocus": true, "hiddenName": "providerHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/courses/CourseOffers/provider", "method": "GET" }) }), "name": "provider" });
    var main_1_panel2171 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 11, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id2167, "labelAlign": "top" }, { "flex": 30, "autoHeight": true, "layout": "form", "xtype": "panel", "items": title2168, "labelAlign": "top" }, { "flex": 28, "autoHeight": true, "layout": "form", "xtype": "panel", "items": content2169, "labelAlign": "top" }, { "flex": 28, "autoHeight": true, "layout": "form", "xtype": "panel", "items": provider2170, "labelAlign": "top" } ], "region": "north", "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "split": true, "autoScroll": false, "labelWidth": 198, "border": false, "frame": false, "labelAlign": "top" });
    var description2176 = new Lino.RichTextPanel({ "flex": 5, "split": true, "containing_panel": this, "selectOnFocus": true, "region": "center", "title": "Description", "name": "description" });
    var CoursesByOffer_grid2207 = new Lino.courses.CoursesByOffer.GridPanel({ "flex": 5, "hide_top_toolbar": true, "split": true, "containing_panel": this, "region": "south", "tools": [ Lino.show_in_own_window_button(Lino.courses.CoursesByOffer.grid) ], "master_panel": this });
    var main_panel2208 = new Lino.VBorderPanel({ "autoScroll": false, "border": false, "labelWidth": 0, "hideCheckBoxLabels": true, "items": [ main_1_panel2171, description2176, CoursesByOffer_grid2207 ], "frame": true, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel2208;
    this.before_row_edit = function(record) {
      description2176.refresh();
      CoursesByOffer_grid2207.on_master_changed();
    }
    Lino.courses.CourseOffers.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.jobs.Offers.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 70,
  initComponent : function() {
    var containing_panel = this;
    var name2058 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 100, "fieldLabel": "Name", "anchor": "-20", "name": "name" });
    var provider2059 = new Lino.TwinCombo({ "fieldLabel": "Employant", "name": "provider", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.jobs.JobProviders.detail)}, "emptyText": "Choisir Employant...", "selectOnFocus": true, "hiddenName": "providerHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/jobs/Offers/provider", "method": "GET" }) }) });
    var sector2060 = new Lino.TwinCombo({ "fieldLabel": "Secteur d'activit\u00e9", "name": "sector", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.jobs.Sectors.detail)}, "emptyText": "Choisir Secteur d'activit\u00e9...", "selectOnFocus": true, "hiddenName": "sectorHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/jobs/Offers/sector", "method": "GET" }) }) });
    var function2061 = new Lino.TwinCombo({ "fieldLabel": "Fonction", "name": "function", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.jobs.Functions.detail)}, "emptyText": "Choisir Fonction...", "selectOnFocus": true, "hiddenName": "functionHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/jobs/Offers/function", "method": "GET" }) }) });
    var main_1_panel2062 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 171, "hideCheckBoxLabels": true, "items": [ { "flex": 25, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name2058, "labelAlign": "top" }, { "flex": 24, "autoHeight": true, "layout": "form", "xtype": "panel", "items": provider2059, "labelAlign": "top" }, { "flex": 24, "autoHeight": true, "layout": "form", "xtype": "panel", "items": sector2060, "labelAlign": "top" }, { "flex": 24, "autoHeight": true, "layout": "form", "xtype": "panel", "items": function2061, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var selection_from2067 = new Lino.DateField({ "selectOnFocus": true, "fieldLabel": "D\u00e9but de s\u00e9lection", "anchor": "-20", "name": "selection_from" });
    var selection_until2068 = new Lino.DateField({ "selectOnFocus": true, "fieldLabel": "Fin de s\u00e9lection", "anchor": "-20", "name": "selection_until" });
    var start_date2069 = new Lino.DateField({ "selectOnFocus": true, "fieldLabel": "Date de d\u00e9but", "anchor": "-20", "name": "start_date" });
    var main_2_panel2070 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 171, "hideCheckBoxLabels": true, "items": [ { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": selection_from2067, "labelAlign": "top" }, { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": selection_until2068, "labelAlign": "top" }, { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": start_date2069, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var remark2074 = new Ext.form.TextArea({ "selectOnFocus": true, "fieldLabel": "Remarque", "anchor": "-20 -10", "growMax": 2000, "name": "remark" });
    var ExperiencesByOffer_grid2086 = new Lino.jobs.ExperiencesByOffer.GridPanel({ "tools": [ Lino.show_in_own_window_button(Lino.jobs.ExperiencesByOffer.grid) ], "containing_panel": this, "hide_top_toolbar": true, "master_panel": this, "flex": 50 });
    var CandidaturesByOffer_grid2096 = new Lino.jobs.CandidaturesByOffer.GridPanel({ "tools": [ Lino.show_in_own_window_button(Lino.jobs.CandidaturesByOffer.grid) ], "containing_panel": this, "hide_top_toolbar": true, "master_panel": this, "flex": 50 });
    var main_4_panel2097 = new Ext.Panel({ "flex": 41, "border": false, "layout": "hbox", "hideCheckBoxLabels": true, "items": [ ExperiencesByOffer_grid2086, CandidaturesByOffer_grid2096 ], "autoScroll": false, "layoutConfig": { "align": "stretch" }, "frame": false, "labelAlign": "top" });
    var main_panel2098 = new Ext.Panel({ "autoScroll": false, "border": false, "layout": "vbox", "labelWidth": 81, "hideCheckBoxLabels": true, "items": [ main_1_panel2062, main_2_panel2070, { "items": remark2074, "labelAlign": "top", "layout": "form", "xtype": "panel", "flex": 41 }, main_4_panel2097 ], "frame": true, "layoutConfig": { "align": "stretch" }, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel2098;
    this.before_row_edit = function(record) {
      function2061.setContextValue('sector',record ? record.data['sectorHidden'] : undefined);
      ExperiencesByOffer_grid2086.on_master_changed();
      CandidaturesByOffer_grid2096.on_master_changed();
    }
    this.onRender = function(ct, position) {
      sector2060.on('change',Lino.chooser_handler(function2061,'sector'));
      Lino.jobs.Offers.DetailFormPanel.superclass.onRender.call(this, ct, position);
    }
    Lino.jobs.Offers.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.jobs.Jobs.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 72,
  initComponent : function() {
    var containing_panel = this;
    var name1962 = new Ext.form.TextField({ "fieldLabel": "Name", "name": "name", "maxLength": 100, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var provider1963 = new Lino.TwinCombo({ "fieldLabel": "Employant", "name": "provider", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.jobs.JobProviders.detail)}, "emptyText": "Choisir Employant...", "selectOnFocus": true, "hiddenName": "providerHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/jobs/Jobs/provider", "method": "GET" }) }) });
    var contract_type1964 = new Lino.TwinCombo({ "fieldLabel": "Type de contrat", "name": "contract_type", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.jobs.ContractTypes.detail)}, "emptyText": "Choisir Type de contrat de travail...", "selectOnFocus": true, "hiddenName": "contract_typeHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/jobs/Jobs/contract_type", "method": "GET" }) }) });
    var type1965 = new Lino.TwinCombo({ "fieldLabel": "Type d'emploi", "name": "type", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.jobs.JobTypes.detail)}, "emptyText": "Choisir Type d'emploi...", "selectOnFocus": true, "hiddenName": "typeHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/jobs/Jobs/type", "method": "GET" }) }) });
    var id1966 = new Ext.form.NumberField({ "selectOnFocus": true, "fieldLabel": "ID", "anchor": "-20", "name": "id" });
    var main_1_panel1967 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 144, "hideCheckBoxLabels": true, "items": [ { "flex": 24, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name1962, "labelAlign": "top" }, { "flex": 23, "autoHeight": true, "layout": "form", "xtype": "panel", "items": provider1963, "labelAlign": "top" }, { "flex": 23, "autoHeight": true, "layout": "form", "xtype": "panel", "items": contract_type1964, "labelAlign": "top" }, { "flex": 23, "autoHeight": true, "layout": "form", "xtype": "panel", "items": type1965, "labelAlign": "top" }, { "flex": 5, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id1966, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var sector1973 = new Lino.TwinCombo({ "fieldLabel": "Secteur d'activit\u00e9", "name": "sector", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.jobs.Sectors.detail)}, "emptyText": "Choisir Secteur d'activit\u00e9...", "selectOnFocus": true, "hiddenName": "sectorHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/jobs/Jobs/sector", "method": "GET" }) }) });
    var function1974 = new Lino.TwinCombo({ "fieldLabel": "Fonction", "name": "function", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.jobs.Functions.detail)}, "emptyText": "Choisir Fonction...", "selectOnFocus": true, "hiddenName": "functionHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/jobs/Jobs/function", "method": "GET" }) }) });
    var capacity1975 = new Ext.form.NumberField({ "fieldLabel": "Capacit\u00e9", "name": "capacity", "selectOnFocus": true, "anchor": "-20", "value": 1, "allowBlank": false });
    var hourly_rate1976 = new Ext.form.NumberField({ "decimalPrecision": 2, "fieldLabel": "co\u00fbr horaire", "name": "hourly_rate", "decimalSeparator": ",", "selectOnFocus": true, "anchor": "-20", "allowBlank": true });
    var main_2_panel1977 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 171, "hideCheckBoxLabels": true, "items": [ { "flex": 35, "autoHeight": true, "layout": "form", "xtype": "panel", "items": sector1973, "labelAlign": "top" }, { "flex": 35, "autoHeight": true, "layout": "form", "xtype": "panel", "items": function1974, "labelAlign": "top" }, { "flex": 8, "autoHeight": true, "layout": "form", "xtype": "panel", "items": capacity1975, "labelAlign": "top" }, { "flex": 21, "autoHeight": true, "layout": "form", "xtype": "panel", "items": hourly_rate1976, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var remark1982 = new Ext.form.TextArea({ "selectOnFocus": true, "fieldLabel": "Remarque", "anchor": "-20 -10", "growMax": 2000, "name": "remark" });
    var CandidaturesByJob_grid1991 = new Lino.jobs.CandidaturesByJob.GridPanel({ "tools": [ Lino.show_in_own_window_button(Lino.jobs.CandidaturesByJob.grid) ], "containing_panel": this, "hide_top_toolbar": true, "master_panel": this, "flex": 66 });
    var main_3_panel1992 = new Ext.Panel({ "flex": 41, "border": false, "layout": "hbox", "labelWidth": 81, "hideCheckBoxLabels": true, "items": [ { "items": remark1982, "labelAlign": "top", "layout": "form", "xtype": "panel", "flex": 33 }, CandidaturesByJob_grid1991 ], "autoScroll": false, "layoutConfig": { "align": "stretch" }, "frame": false, "labelAlign": "top" });
    var ContractsByJob_grid2023 = new Lino.jobs.ContractsByJob.GridPanel({ "flex": 41, "hide_top_toolbar": true, "containing_panel": this, "params_panel_hidden": true, "tools": [ Lino.show_in_own_window_button(Lino.jobs.ContractsByJob.grid) ], "master_panel": this });
    var main_panel2024 = new Ext.Panel({ "autoScroll": false, "border": false, "layout": "vbox", "hideCheckBoxLabels": true, "items": [ main_1_panel1967, main_2_panel1977, main_3_panel1992, ContractsByJob_grid2023 ], "frame": true, "layoutConfig": { "align": "stretch" }, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel2024;
    this.before_row_edit = function(record) {
      function1974.setContextValue('sector',record ? record.data['sectorHidden'] : undefined);
      CandidaturesByJob_grid1991.on_master_changed();
      ContractsByJob_grid2023.on_master_changed();
    }
    this.onRender = function(ct, position) {
      sector1973.on('change',Lino.chooser_handler(function1974,'sector'));
      Lino.jobs.Jobs.DetailFormPanel.superclass.onRender.call(this, ct, position);
    }
    Lino.jobs.Jobs.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.courses.CourseProviders.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 80,
  initComponent : function() {
    var containing_panel = this;
    var prefix2100 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200, "fieldLabel": "prefix", "anchor": "-20", "name": "prefix" });
    var name2101 = new Ext.form.TextField({ "fieldLabel": "Name", "name": "name", "maxLength": 200, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var id2102 = new Ext.form.NumberField({ "selectOnFocus": true, "fieldLabel": "ID", "anchor": "-20", "name": "id" });
    var language2103 = new Lino.ChoicesFieldElement({ "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Langue</span>", "allowBlank": false, "value": "de", "hiddenName": "languageHidden", "listeners": { "render": Lino.quicktip_renderer("Langue","Die Sprache, in der Dokumente ausgestellt werden sollen.") }, "selectOnFocus": true, "anchor": "-20", "store": [ [ "de", "German" ], [ "fr", "French" ], [ "nl", "Dutch" ] ], "name": "language" });
    var intro_box_1_panel2104 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 31, "autoHeight": true, "layout": "form", "xtype": "panel", "items": prefix2100, "labelAlign": "top" }, { "flex": 31, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name2101, "labelAlign": "top" }, { "flex": 7, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id2102, "labelAlign": "top" }, { "flex": 29, "autoHeight": true, "layout": "form", "xtype": "panel", "items": language2103, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 63, "border": false, "anchor": "-20", "labelAlign": "top" });
    var vat_id2109 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200, "fieldLabel": "N\u00b0 de TVA", "anchor": "-20", "name": "vat_id" });
    var activity2110 = new Lino.RemoteComboFieldElement({ "fieldLabel": "Activit\u00e9", "name": "activity", "pageSize": 20, "emptyText": "Choisir Activit\u00e9...", "selectOnFocus": true, "hiddenName": "activityHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/courses/CourseProviders/activity", "method": "GET" }) }) });
    var type2111 = new Lino.RemoteComboFieldElement({ "fieldLabel": "Type de soci\u00e9t\u00e9", "name": "type", "pageSize": 20, "emptyText": "Choisir Type d'organisation...", "selectOnFocus": true, "hiddenName": "typeHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/courses/CourseProviders/type", "method": "GET" }) }) });
    var intro_box_2_panel2112 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 23, "autoHeight": true, "layout": "form", "xtype": "panel", "items": vat_id2109, "labelAlign": "top" }, { "flex": 38, "autoHeight": true, "layout": "form", "xtype": "panel", "items": activity2110, "labelAlign": "top" }, { "flex": 38, "autoHeight": true, "layout": "form", "xtype": "panel", "items": type2111, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 144, "border": false, "anchor": "-20", "labelAlign": "top" });
    var bank_account12116 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 40, "fieldLabel": "Compte en banque 1", "anchor": "-20", "name": "bank_account1" });
    var bank_account22117 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 40, "fieldLabel": "Compte en banque 2", "anchor": "-20", "name": "bank_account2" });
    var is_obsolete2118 = new Ext.form.Checkbox({ "boxLabel": "obsolete", "listeners": { "render": Lino.quicktip_renderer("obsolete","Altf\u00e4lle sind Partner, deren Stammdaten nicht mehr gepflegt werden und \nf\u00fcr neue Operationen nicht benutzt werden k\u00f6nnen.") }, "hideLabel": true, "checked": false, "name": "is_obsolete", "selectOnFocus": true, "anchor": "-20" });
    var intro_box_3_panel2119 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 40, "autoHeight": true, "layout": "form", "xtype": "panel", "items": bank_account12116, "labelAlign": "top" }, { "flex": 40, "autoHeight": true, "layout": "form", "xtype": "panel", "items": bank_account22117, "labelAlign": "top" }, { "flex": 19, "autoHeight": true, "layout": "form", "xtype": "panel", "items": is_obsolete2118, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 171, "border": false, "anchor": "-20", "labelAlign": "top" });
    var intro_box_panel2123 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "form", "hideCheckBoxLabels": true, "items": [ intro_box_1_panel2104, intro_box_2_panel2112, intro_box_3_panel2119 ], "frame": true, "bodyBorder": false, "labelAlign": "top" });
    var country2124 = new Lino.TwinCombo({ "fieldLabel": "Pays", "name": "country", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.countries.Countries.detail)}, "emptyText": "Choisir Pays...", "selectOnFocus": true, "hiddenName": "countryHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/courses/CourseProviders/country", "method": "GET" }) }) });
    var region2125 = new Lino.TwinCombo({ "fieldLabel": "Region", "name": "region", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.countries.Cities.detail)}, "emptyText": "Choisir Place...", "selectOnFocus": true, "hiddenName": "regionHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/courses/CourseProviders/region", "method": "GET" }) }) });
    var box3_1_panel2126 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": country2124, "labelAlign": "top" }, { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": region2125, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 63, "border": false, "anchor": "-20", "labelAlign": "top" });
    var city2129 = new Lino.TwinCombo({ "forceSelection": false, "fieldLabel": "Place", "name": "city", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.countries.Cities.detail)}, "emptyText": "Choisir Place...", "selectOnFocus": true, "hiddenName": "cityHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/courses/CourseProviders/city", "method": "GET" }) }) });
    var zip_code2130 = new Ext.form.TextField({ "fieldLabel": "Zip code", "name": "zip_code", "maxLength": 10, "selectOnFocus": true, "boxMinWidth": Lino.chars2width(10), "anchor": "-20" });
    var box3_2_panel2131 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 66, "autoHeight": true, "layout": "form", "xtype": "panel", "items": city2129, "labelAlign": "top" }, { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": zip_code2130, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 81, "border": false, "anchor": "-20", "labelAlign": "top" });
    var street_prefix2134 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Pr\u00e9fixe rue","Text to print before name of street, but to ignore for sorting.") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Pr\u00e9fixe rue</span>", "name": "street_prefix", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var street2135 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Rue","Name of street. Without house number.") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Rue</span>", "name": "street", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var street_no2136 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("N\u00b0","House number") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">N\u00b0</span>", "name": "street_no", "maxLength": 10, "selectOnFocus": true, "boxMinWidth": Lino.chars2width(10), "anchor": "-20" });
    var street_box2137 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("bo\u00eete","Text to print after :attr:`steet_no` on the same line") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">bo\u00eete</span>", "name": "street_box", "maxLength": 10, "selectOnFocus": true, "boxMinWidth": Lino.chars2width(10), "anchor": "-20" });
    var box3_3_panel2138 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 30, "autoHeight": true, "layout": "form", "xtype": "panel", "items": street_prefix2134, "labelAlign": "top" }, { "flex": 36, "autoHeight": true, "layout": "form", "xtype": "panel", "items": street2135, "labelAlign": "top" }, { "flex": 16, "autoHeight": true, "layout": "form", "xtype": "panel", "items": street_no2136, "labelAlign": "top" }, { "flex": 16, "autoHeight": true, "layout": "form", "xtype": "panel", "items": street_box2137, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 108, "border": false, "anchor": "-20", "labelAlign": "top" });
    var addr22143 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Ligne apr\u00e8s le nom de rue","Address line to print below street line") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Ligne apr\u00e8s le nom de rue</span>", "name": "addr2", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var box3_panel2144 = new Ext.Panel({ "flex": 62, "autoHeight": true, "layout": "form", "items": [ box3_1_panel2126, box3_2_panel2131, box3_3_panel2138, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": addr22143, "anchor": "-20", "labelAlign": "top" } ], "frame": true, "bodyBorder": false, "autoScroll": false, "hideCheckBoxLabels": true, "labelWidth": 234, "border": false, "labelAlign": "top" });
    var email2146 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 75, "fieldLabel": "E-mail", "anchor": "-20", "name": "email" });
    var url2147 = new Lino.URLField({ "selectOnFocus": true, "maxLength": 200, "fieldLabel": "URL", "anchor": "-20", "name": "url" });
    var phone2148 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200, "fieldLabel": "T\u00e9l\u00e9phone", "anchor": "-20", "name": "phone" });
    var gsm2149 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200, "fieldLabel": "GSM", "anchor": "-20", "name": "gsm" });
    var box4_panel2150 = new Ext.Panel({ "flex": 37, "autoHeight": true, "layout": "form", "items": [ { "autoHeight": true, "layout": "form", "xtype": "panel", "items": email2146, "anchor": "-20", "labelAlign": "top" }, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": url2147, "anchor": "-20", "labelAlign": "top" }, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": phone2148, "anchor": "-20", "labelAlign": "top" }, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": gsm2149, "anchor": "-20", "labelAlign": "top" } ], "frame": true, "bodyBorder": false, "autoScroll": false, "hideCheckBoxLabels": true, "labelWidth": 90, "border": false, "labelAlign": "top" });
    var address_box_panel2155 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "hideCheckBoxLabels": true, "items": [ box3_panel2144, box4_panel2150 ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var remarks2156 = new Ext.form.TextArea({ "selectOnFocus": true, "fieldLabel": "Remarques", "anchor": "-20 -10", "growMax": 2000, "name": "remarks" });
    var contacts_RolesByCompany_grid2157 = new Lino.contacts.RolesByCompany.GridPanel({ "tools": [ Lino.show_in_own_window_button(Lino.contacts.RolesByCompany.grid) ], "containing_panel": this, "hide_top_toolbar": true, "master_panel": this, "flex": 42 });
    var bottom_box_panel2158 = new Ext.Panel({ "flex": 41, "border": false, "layout": "hbox", "labelWidth": 90, "hideCheckBoxLabels": true, "items": [ { "items": remarks2156, "labelAlign": "top", "layout": "form", "xtype": "panel", "flex": 57 }, contacts_RolesByCompany_grid2157 ], "autoScroll": false, "layoutConfig": { "align": "stretch" }, "frame": false, "labelAlign": "top" });
    var general_panel2160 = new Ext.Panel({ "layout": "vbox", "title": "G\u00e9n\u00e9ral", "items": [ intro_box_panel2123, address_box_panel2155, bottom_box_panel2158 ], "frame": true, "layoutConfig": { "align": "stretch" }, "hideCheckBoxLabels": true, "listeners": { "activate": Lino.on_tab_activate }, "autoScroll": false, "border": false, "bodyBorder": false, "labelAlign": "top" });
    var pcsw_NotesByCompany_grid2161 = new Lino.pcsw.NotesByCompany.GridPanel({ "listeners": { "activate": Lino.on_tab_activate }, "hide_top_toolbar": true, "title": "Events/Notes", "containing_panel": this, "tools": [ Lino.show_in_own_window_button(Lino.pcsw.NotesByCompany.grid) ], "master_panel": this });
    var CourseOffersByProvider_grid2209 = new Lino.courses.CourseOffersByProvider.GridPanel({ "listeners": { "activate": Lino.on_tab_activate }, "hide_top_toolbar": true, "title": "Offres de cours", "containing_panel": this, "tools": [ Lino.show_in_own_window_button(Lino.courses.CourseOffersByProvider.grid) ], "master_panel": this });
    var main_panel2210 = new Ext.TabPanel({ "hideCheckBoxLabels": true, "border": false, "split": true, "autoScroll": false, "items": [ general_panel2160, pcsw_NotesByCompany_grid2161, CourseOffersByProvider_grid2209 ], "activeTab": 0, "bodyBorder": false, "frame": true, "labelAlign": "top" });
    this.items = main_panel2210;
    this.before_row_edit = function(record) {
      region2125.setContextValue('country',record ? record.data['countryHidden'] : undefined);
      city2129.setContextValue('country',record ? record.data['countryHidden'] : undefined);
      city2129.setContextValue('region',record ? record.data['regionHidden'] : undefined);
      contacts_RolesByCompany_grid2157.on_master_changed();
      pcsw_NotesByCompany_grid2161.on_master_changed();
      CourseOffersByProvider_grid2209.on_master_changed();
    }
    this.onRender = function(ct, position) {
      country2124.on('change',Lino.chooser_handler(region2125,'country'));
      country2124.on('change',Lino.chooser_handler(city2129,'country'));
      region2125.on('change',Lino.chooser_handler(city2129,'region'));
      Lino.courses.CourseProviders.DetailFormPanel.superclass.onRender.call(this, ct, position);
    }
    Lino.courses.CourseProviders.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.cbss.RetrieveTIGroupsRequests.InsertFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  autoHeight: true,
  content_type: 90,
  initComponent : function() {
    var containing_panel = this;
    var person2442 = new Lino.TwinCombo({ "fieldLabel": "Client", "allowBlank": false, "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.pcsw.Clients.detail)}, "emptyText": "Choisir Client...", "selectOnFocus": true, "hiddenName": "personHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cbss/RetrieveTIGroupsRequests/person", "method": "GET" }) }), "name": "person" });
    var national_id2443 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200, "fieldLabel": "NISS", "anchor": "-20", "name": "national_id" });
    var language2444 = new Lino.ChoicesFieldElement({ "forceSelection": true, "fieldLabel": "Langue", "name": "language", "selectOnFocus": true, "anchor": "-20", "store": Lino.cbss.RequestLanguages, "hiddenName": "languageHidden" });
    var main_2_panel2445 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 55, "autoHeight": true, "layout": "form", "xtype": "panel", "items": national_id2443, "labelAlign": "top" }, { "flex": 44, "autoHeight": true, "layout": "form", "xtype": "panel", "items": language2444, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 63, "border": false, "anchor": "-20", "labelAlign": "top" });
    var history2448 = new Ext.form.Checkbox({ "boxLabel": "Historique", "listeners": { "render": Lino.quicktip_renderer("Historique","Whatever this means.") }, "hideLabel": true, "checked": true, "name": "history", "selectOnFocus": true, "anchor": "-20" });
    var main_panel2449 = new Ext.Panel({ "hideCheckBoxLabels": true, "autoHeight": true, "border": false, "layout": "form", "labelWidth": 99, "autoScroll": false, "items": [ { "autoHeight": true, "layout": "form", "xtype": "panel", "items": person2442, "anchor": "-20", "labelAlign": "top" }, main_2_panel2445, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": history2448, "anchor": "-20", "labelAlign": "top" } ], "frame": true, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel2449;
    this.before_row_edit = function(record) {
    }
    Lino.cbss.RetrieveTIGroupsRequests.InsertFormPanel.superclass.initComponent.call(this);
  }
});


Lino.uploads.MyUploads.InsertFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  autoHeight: true,
  content_type: 26,
  initComponent : function() {
    var containing_panel = this;
    var file2494 = Lino.file_field_handler(this,{ "fieldLabel": "Datei", "name": "file", "maxLength": 100, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var user2495 = new Lino.TwinCombo({ "fieldLabel": "Auteur", "name": "user", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.users.Users.detail)}, "emptyText": "Choisir Utilisateur...", "selectOnFocus": true, "hiddenName": "userHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/uploads/Uploads/user", "method": "GET" }) }) });
    var main_1_panel2496 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 58, "autoHeight": true, "layout": "form", "xtype": "panel", "items": file2494, "labelAlign": "top" }, { "flex": 41, "autoHeight": true, "layout": "form", "xtype": "panel", "items": user2495, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 63, "border": false, "anchor": "-20", "labelAlign": "top" });
    var type2499 = new Lino.RemoteComboFieldElement({ "fieldLabel": "Type d'upload", "name": "type", "pageSize": 20, "emptyText": "Choisir Type d'upload...", "selectOnFocus": true, "hiddenName": "typeHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/uploads/Uploads/type", "method": "GET" }) }) });
    var valid_until2500 = new Lino.DateField({ "selectOnFocus": true, "fieldLabel": "expire le", "anchor": "-20", "name": "valid_until" });
    var main_2_panel2501 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 71, "autoHeight": true, "layout": "form", "xtype": "panel", "items": type2499, "labelAlign": "top" }, { "flex": 28, "autoHeight": true, "layout": "form", "xtype": "panel", "items": valid_until2500, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 126, "border": false, "anchor": "-20", "labelAlign": "top" });
    var description2504 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200, "fieldLabel": "Description", "anchor": "-20", "name": "description" });
    var main_panel2505 = new Ext.Panel({ "hideCheckBoxLabels": true, "autoHeight": true, "border": false, "layout": "form", "labelWidth": 108, "autoScroll": false, "items": [ main_1_panel2496, main_2_panel2501, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": description2504, "anchor": "-20", "labelAlign": "top" } ], "frame": true, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel2505;
    this.before_row_edit = function(record) {
    }
    Lino.uploads.MyUploads.InsertFormPanel.superclass.initComponent.call(this);
  }
});


Lino.lino.Report.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  disable_editing: true,
  initComponent : function() {
    var containing_panel = this;
    var body_htmlbox2527 = new Lino.HtmlBoxPanel({ "layout": "fit", "name": "body", "containing_panel": this, "items": new Ext.BoxComponent({autoScroll:true}), "master_panel": this, "value": "<br/>", "always_enabled": true, "bodyStyle": "overflow-x:hidden" });
    var main_panel2528 = new Ext.Panel({ "autoScroll": false, "border": false, "layout": "fit", "labelWidth": 0, "hideCheckBoxLabels": true, "items": [ body_htmlbox2527 ], "frame": true, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel2528;
    this.before_row_edit = function(record) {
      body_htmlbox2527.refresh();
    }
    Lino.lino.Report.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.pcsw.Clients.InsertFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  autoHeight: true,
  content_type: 53,
  initComponent : function() {
    var containing_panel = this;
    var first_name1813 = new Ext.form.TextField({ "fieldLabel": "Pr\u00e9nom", "name": "first_name", "maxLength": 200, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var last_name1814 = new Ext.form.TextField({ "fieldLabel": "Nom de famille", "name": "last_name", "maxLength": 200, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var main_1_panel1815 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": first_name1813, "labelAlign": "top" }, { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": last_name1814, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 135, "border": false, "anchor": "-20", "labelAlign": "top" });
    var national_id1818 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200, "fieldLabel": "NISS", "anchor": "-20", "name": "national_id" });
    var gender1819 = new Lino.ChoicesFieldElement({ "forceSelection": true, "fieldLabel": "Sexe", "name": "gender", "selectOnFocus": true, "anchor": "-20", "store": Lino.lino.Genders, "hiddenName": "genderHidden" });
    var language1820 = new Lino.ChoicesFieldElement({ "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Langue</span>", "allowBlank": false, "value": "de", "hiddenName": "languageHidden", "listeners": { "render": Lino.quicktip_renderer("Langue","Die Sprache, in der Dokumente ausgestellt werden sollen.") }, "selectOnFocus": true, "anchor": "-20", "store": [ [ "de", "German" ], [ "fr", "French" ], [ "nl", "Dutch" ] ], "name": "language" });
    var main_3_panel1821 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 35, "autoHeight": true, "layout": "form", "xtype": "panel", "items": gender1819, "labelAlign": "top" }, { "flex": 64, "autoHeight": true, "layout": "form", "xtype": "panel", "items": language1820, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 63, "border": false, "anchor": "-20", "labelAlign": "top" });
    var main_panel1824 = new Ext.Panel({ "hideCheckBoxLabels": true, "autoHeight": true, "border": false, "layout": "form", "labelWidth": 45, "autoScroll": false, "items": [ main_1_panel1815, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": national_id1818, "anchor": "-20", "labelAlign": "top" }, main_3_panel1821 ], "frame": true, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel1824;
    this.before_row_edit = function(record) {
    }
    Lino.pcsw.Clients.InsertFormPanel.superclass.initComponent.call(this);
  }
});


Lino.countries.Languages.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 12,
  initComponent : function() {
    var containing_panel = this;
    var id383 = new Ext.form.TextField({ "fieldLabel": "id", "name": "id", "maxLength": 3, "selectOnFocus": true, "boxMinWidth": Lino.chars2width(3), "anchor": "-20", "allowBlank": false });
    var iso2384 = new Ext.form.TextField({ "fieldLabel": "iso2", "name": "iso2", "maxLength": 2, "selectOnFocus": true, "boxMinWidth": Lino.chars2width(2), "anchor": "-20" });
    var name385 = new Ext.form.TextField({ "fieldLabel": "Description", "name": "name", "maxLength": 200, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var name_fr386 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200, "fieldLabel": "Description (fr)", "anchor": "-20", "name": "name_fr" });
    var name_nl387 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200, "fieldLabel": "Description (nl)", "anchor": "-20", "name": "name_nl" });
    var main_1_panel388 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 153, "hideCheckBoxLabels": true, "items": [ { "flex": 5, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id383, "labelAlign": "top" }, { "flex": 5, "autoHeight": true, "layout": "form", "xtype": "panel", "items": iso2384, "labelAlign": "top" }, { "flex": 29, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name385, "labelAlign": "top" }, { "flex": 29, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_fr386, "labelAlign": "top" }, { "flex": 29, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_nl387, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var cv_KnowledgesByLanguage_grid400 = new Lino.cv.KnowledgesByLanguage.GridPanel({ "tools": [ Lino.show_in_own_window_button(Lino.cv.KnowledgesByLanguage.grid) ], "containing_panel": this, "hide_top_toolbar": true, "master_panel": this, "flex": 83 });
    var main_panel401 = new Ext.Panel({ "autoScroll": false, "border": false, "layout": "vbox", "hideCheckBoxLabels": true, "items": [ main_1_panel388, cv_KnowledgesByLanguage_grid400 ], "frame": true, "layoutConfig": { "align": "stretch" }, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel401;
    this.before_row_edit = function(record) {
      cv_KnowledgesByLanguage_grid400.on_master_changed();
    }
    Lino.countries.Languages.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.jobs.Contracts.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 71,
  initComponent : function() {
    var containing_panel = this;
    var id1615 = new Ext.form.NumberField({ "selectOnFocus": true, "fieldLabel": "ID", "anchor": "-20", "name": "id" });
    var client1616 = new Lino.TwinCombo({ "fieldLabel": "Client", "allowBlank": false, "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.pcsw.Clients.detail)}, "emptyText": "Choisir Client...", "selectOnFocus": true, "hiddenName": "clientHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/jobs/Contracts/client", "method": "GET" }) }), "name": "client" });
    var user1617 = new Lino.TwinCombo({ "fieldLabel": "Auteur", "name": "user", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.users.Users.detail)}, "emptyText": "Choisir Utilisateur...", "selectOnFocus": true, "hiddenName": "userHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/jobs/Contracts/user", "method": "GET" }) }) });
    var user_asd1618 = new Lino.TwinCombo({ "fieldLabel": "Responsable (SSG)", "name": "user_asd", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.users.Users.detail)}, "emptyText": "Choisir Utilisateur...", "selectOnFocus": true, "hiddenName": "user_asdHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/jobs/Contracts/user_asd", "method": "GET" }) }) });
    var language1619 = new Lino.ChoicesFieldElement({ "fieldLabel": "Langue", "allowBlank": false, "value": "de", "hiddenName": "languageHidden", "selectOnFocus": true, "anchor": "-20", "store": [ [ "de", "German" ], [ "fr", "French" ], [ "nl", "Dutch" ] ], "name": "language" });
    var box1_1_panel1620 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 162, "hideCheckBoxLabels": true, "items": [ { "flex": 11, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id1615, "labelAlign": "top" }, { "flex": 35, "autoHeight": true, "layout": "form", "xtype": "panel", "items": client1616, "labelAlign": "top" }, { "flex": 21, "autoHeight": true, "layout": "form", "xtype": "panel", "items": user1617, "labelAlign": "top" }, { "flex": 21, "autoHeight": true, "layout": "form", "xtype": "panel", "items": user_asd1618, "labelAlign": "top" }, { "flex": 11, "autoHeight": true, "layout": "form", "xtype": "panel", "items": language1619, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var job1626 = new Lino.TwinCombo({ "fieldLabel": "Emploi", "allowBlank": false, "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.jobs.Jobs.detail)}, "emptyText": "Choisir Emploi...", "selectOnFocus": true, "hiddenName": "jobHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/jobs/Contracts/job", "method": "GET" }) }), "name": "job" });
    var type1627 = new Lino.TwinCombo({ "fieldLabel": "Type de contrat", "name": "type", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.jobs.ContractTypes.detail)}, "emptyText": "Choisir Type de contrat de travail...", "selectOnFocus": true, "hiddenName": "typeHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/jobs/Contracts/type", "method": "GET" }) }) });
    var company1628 = new Lino.TwinCombo({ "fieldLabel": "Organisation", "name": "company", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.contacts.Companies.detail)}, "emptyText": "Choisir Organisation...", "selectOnFocus": true, "hiddenName": "companyHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/jobs/Contracts/company", "method": "GET" }) }) });
    var contact_person1629 = new Lino.TwinCombo({ "fieldLabel": "repr\u00e9sent\u00e9 par", "name": "contact_person", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.contacts.Persons.detail)}, "emptyText": "Choisir Personne...", "selectOnFocus": true, "hiddenName": "contact_personHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/jobs/Contracts/contact_person", "method": "GET" }) }) });
    var contact_role1630 = new Lino.RemoteComboFieldElement({ "fieldLabel": "repr\u00e9sent\u00e9 par", "name": "contact_role", "pageSize": 20, "emptyText": "Choisir Fonction...", "selectOnFocus": true, "hiddenName": "contact_roleHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/jobs/Contracts/contact_role", "method": "GET" }) }) });
    var box1_2_panel1631 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 144, "hideCheckBoxLabels": true, "items": [ { "flex": 20, "autoHeight": true, "layout": "form", "xtype": "panel", "items": job1626, "labelAlign": "top" }, { "flex": 20, "autoHeight": true, "layout": "form", "xtype": "panel", "items": type1627, "labelAlign": "top" }, { "flex": 20, "autoHeight": true, "layout": "form", "xtype": "panel", "items": company1628, "labelAlign": "top" }, { "flex": 20, "autoHeight": true, "layout": "form", "xtype": "panel", "items": contact_person1629, "labelAlign": "top" }, { "flex": 20, "autoHeight": true, "layout": "form", "xtype": "panel", "items": contact_role1630, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var applies_from1637 = new Lino.DateField({ "selectOnFocus": true, "fieldLabel": "D\u00e9but de contrat", "anchor": "-20", "name": "applies_from" });
    var duration1638 = new Lino.SimpleRemoteComboFieldElement({ "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/jobs/Contracts/duration", "method": "GET" }) }), "fieldLabel": "dur\u00e9e (jours)", "name": "duration", "selectOnFocus": true, "anchor": "-20", "value": null });
    var applies_until1639 = new Lino.DateField({ "selectOnFocus": true, "fieldLabel": "Fin pr\u00e9vue", "anchor": "-20", "name": "applies_until" });
    var exam_policy1640 = new Lino.TwinCombo({ "fieldLabel": "M\u00e9thode d'examination", "name": "exam_policy", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.isip.ExamPolicies.detail)}, "emptyText": "Choisir M\u00e9thode d'examination...", "selectOnFocus": true, "hiddenName": "exam_policyHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/jobs/Contracts/exam_policy", "method": "GET" }) }) });
    var box1_3_panel1641 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 198, "hideCheckBoxLabels": true, "items": [ { "flex": 17, "autoHeight": true, "layout": "form", "xtype": "panel", "items": applies_from1637, "labelAlign": "top" }, { "flex": 21, "autoHeight": true, "layout": "form", "xtype": "panel", "items": duration1638, "labelAlign": "top" }, { "flex": 17, "autoHeight": true, "layout": "form", "xtype": "panel", "items": applies_until1639, "labelAlign": "top" }, { "flex": 43, "autoHeight": true, "layout": "form", "xtype": "panel", "items": exam_policy1640, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var regime1646 = new Lino.TwinCombo({ "fieldLabel": "R\u00e9gime de travail", "name": "regime", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.jobs.Regimes.detail)}, "emptyText": "Choisir R\u00e9gime de travail...", "selectOnFocus": true, "hiddenName": "regimeHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/jobs/Contracts/regime", "method": "GET" }) }) });
    var schedule1647 = new Lino.TwinCombo({ "fieldLabel": "Horaire", "name": "schedule", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.jobs.Schedules.detail)}, "emptyText": "Choisir Horaire...", "selectOnFocus": true, "hiddenName": "scheduleHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/jobs/Contracts/schedule", "method": "GET" }) }) });
    var hourly_rate1648 = new Ext.form.NumberField({ "decimalPrecision": 2, "fieldLabel": "co\u00fbr horaire", "name": "hourly_rate", "decimalSeparator": ",", "selectOnFocus": true, "anchor": "-20", "allowBlank": true });
    var refund_rate1649 = new Lino.SimpleRemoteComboFieldElement({ "selectOnFocus": true, "fieldLabel": "tarif de remboursement", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/jobs/Contracts/refund_rate", "method": "GET" }) }), "name": "refund_rate" });
    var box1_4_panel1650 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 207, "hideCheckBoxLabels": true, "items": [ { "flex": 28, "autoHeight": true, "layout": "form", "xtype": "panel", "items": regime1646, "labelAlign": "top" }, { "flex": 42, "autoHeight": true, "layout": "form", "xtype": "panel", "items": schedule1647, "labelAlign": "top" }, { "flex": 14, "autoHeight": true, "layout": "form", "xtype": "panel", "items": hourly_rate1648, "labelAlign": "top" }, { "flex": 14, "autoHeight": true, "layout": "form", "xtype": "panel", "items": refund_rate1649, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var reference_person1655 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200, "fieldLabel": "persone de r\u00e9f\u00e9rence", "anchor": "-20", "name": "reference_person" });
    var build_time1656 = new Ext.form.DisplayField({ "disabled": true, "fieldLabel": "build time", "anchor": "-20", "value": "<br>", "name": "build_time" });
    var box1_5_panel1657 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 189, "hideCheckBoxLabels": true, "items": [ { "flex": 56, "autoHeight": true, "layout": "form", "xtype": "panel", "items": reference_person1655, "labelAlign": "top" }, { "flex": 43, "autoHeight": true, "layout": "form", "xtype": "panel", "items": build_time1656, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var date_decided1660 = new Lino.DateField({ "selectOnFocus": true, "fieldLabel": "D\u00e9cid\u00e9 le", "anchor": "-20", "name": "date_decided" });
    var date_issued1661 = new Lino.DateField({ "selectOnFocus": true, "fieldLabel": "D\u00e9livr\u00e9 le", "anchor": "-20", "name": "date_issued" });
    var date_ended1662 = new Lino.DateField({ "selectOnFocus": true, "fieldLabel": "Date de fin", "anchor": "-20", "name": "date_ended" });
    var ending1663 = new Lino.TwinCombo({ "fieldLabel": "Cause d'abandon", "name": "ending", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.isip.ContractEndings.detail)}, "emptyText": "Choisir Cause d'abandon...", "selectOnFocus": true, "hiddenName": "endingHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/jobs/Contracts/ending", "method": "GET" }) }) });
    var box1_6_panel1664 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 144, "hideCheckBoxLabels": true, "items": [ { "flex": 18, "autoHeight": true, "layout": "form", "xtype": "panel", "items": date_decided1660, "labelAlign": "top" }, { "flex": 18, "autoHeight": true, "layout": "form", "xtype": "panel", "items": date_issued1661, "labelAlign": "top" }, { "flex": 18, "autoHeight": true, "layout": "form", "xtype": "panel", "items": date_ended1662, "labelAlign": "top" }, { "flex": 45, "autoHeight": true, "layout": "form", "xtype": "panel", "items": ending1663, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var responsibilities1669 = new Lino.RichTextPanel({ "selectOnFocus": true, "flex": 45, "containing_panel": this, "name": "responsibilities", "title": "responsabilit\u00e9s" });
    var box1_panel1670 = new Ext.Panel({ "flex": 70, "layout": "vbox", "items": [ box1_1_panel1620, box1_2_panel1631, box1_3_panel1641, box1_4_panel1650, box1_5_panel1657, box1_6_panel1664, responsibilities1669 ], "frame": true, "layoutConfig": { "align": "stretch" }, "autoScroll": false, "hideCheckBoxLabels": true, "labelWidth": 0, "border": false, "bodyBorder": false, "labelAlign": "top" });
    var cal_EventsByController_grid1671 = new Lino.cal.EventsByController.GridPanel({ "flex": 5, "hide_top_toolbar": true, "containing_panel": this, "region": "north", "params_panel_hidden": true, "master_panel": this, "split": true, "tools": [ Lino.show_in_own_window_button(Lino.cal.EventsByController.grid) ] });
    var cal_TasksByController_grid1672 = new Lino.cal.TasksByController.GridPanel({ "flex": 5, "hide_top_toolbar": true, "split": true, "containing_panel": this, "region": "center", "tools": [ Lino.show_in_own_window_button(Lino.cal.TasksByController.grid) ], "master_panel": this });
    var right_panel1673 = new Lino.VBorderPanel({ "flex": 30, "border": false, "hideCheckBoxLabels": true, "items": [ cal_EventsByController_grid1671, cal_TasksByController_grid1672 ], "frame": true, "autoScroll": false, "bodyBorder": false, "labelAlign": "top" });
    var main_1_panel1674 = new Ext.Panel({ "autoScroll": false, "border": false, "layout": "hbox", "hideCheckBoxLabels": true, "items": [ box1_panel1670, right_panel1673 ], "frame": false, "layoutConfig": { "align": "stretch" }, "labelAlign": "top" });
    var main_panel1675 = new Ext.Panel({ "autoScroll": false, "border": false, "layout": "fit", "hideCheckBoxLabels": true, "items": [ main_1_panel1674 ], "frame": true, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel1675;
    this.before_row_edit = function(record) {
      contact_person1629.setContextValue('company',record ? record.data['companyHidden'] : undefined);
      responsibilities1669.refresh();
      cal_EventsByController_grid1671.on_master_changed();
      cal_TasksByController_grid1672.on_master_changed();
    }
    this.onRender = function(ct, position) {
      company1628.on('change',Lino.chooser_handler(contact_person1629,'company'));
      Lino.jobs.Contracts.DetailFormPanel.superclass.onRender.call(this, ct, position);
    }
    Lino.jobs.Contracts.DetailFormPanel.superclass.initComponent.call(this);
    // active_fields:
    job1626.on("change",function(){this.save()},this);
    company1628.on("change",function(){this.save()},this);
    contact_person1629.on("change",function(){this.save()},this);
    contact_role1630.on("change",function(){this.save()},this);
  }
});


Lino.households.Households.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 41,
  initComponent : function() {
    var containing_panel = this;
    var type984 = new Lino.TwinCombo({ "fieldLabel": "Type de m\u00e9nage", "name": "type", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.households.Types.detail)}, "emptyText": "Choisir Type de m\u00e9nage...", "selectOnFocus": true, "hiddenName": "typeHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/households/Households/type", "method": "GET" }) }) });
    var name985 = new Ext.form.TextField({ "fieldLabel": "Name", "name": "name", "maxLength": 200, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var language986 = new Lino.ChoicesFieldElement({ "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Langue</span>", "allowBlank": false, "value": "de", "hiddenName": "languageHidden", "listeners": { "render": Lino.quicktip_renderer("Langue","Die Sprache, in der Dokumente ausgestellt werden sollen.") }, "selectOnFocus": true, "anchor": "-20", "store": [ [ "de", "German" ], [ "fr", "French" ], [ "nl", "Dutch" ] ], "name": "language" });
    var id987 = new Ext.form.NumberField({ "selectOnFocus": true, "fieldLabel": "ID", "anchor": "-20", "name": "id" });
    var intro_box_1_panel988 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 135, "hideCheckBoxLabels": true, "items": [ { "flex": 35, "autoHeight": true, "layout": "form", "xtype": "panel", "items": type984, "labelAlign": "top" }, { "flex": 37, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name985, "labelAlign": "top" }, { "flex": 17, "autoHeight": true, "layout": "form", "xtype": "panel", "items": language986, "labelAlign": "top" }, { "flex": 8, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id987, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var country993 = new Lino.TwinCombo({ "fieldLabel": "Pays", "name": "country", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.countries.Countries.detail)}, "emptyText": "Choisir Pays...", "selectOnFocus": true, "hiddenName": "countryHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/households/Households/country", "method": "GET" }) }) });
    var region994 = new Lino.TwinCombo({ "fieldLabel": "Region", "name": "region", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.countries.Cities.detail)}, "emptyText": "Choisir Place...", "selectOnFocus": true, "hiddenName": "regionHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/households/Households/region", "method": "GET" }) }) });
    var box3_1_panel995 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": country993, "labelAlign": "top" }, { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": region994, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 63, "border": false, "anchor": "-20", "labelAlign": "top" });
    var city998 = new Lino.TwinCombo({ "forceSelection": false, "fieldLabel": "Place", "name": "city", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.countries.Cities.detail)}, "emptyText": "Choisir Place...", "selectOnFocus": true, "hiddenName": "cityHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/households/Households/city", "method": "GET" }) }) });
    var zip_code999 = new Ext.form.TextField({ "fieldLabel": "Zip code", "name": "zip_code", "maxLength": 10, "selectOnFocus": true, "boxMinWidth": Lino.chars2width(10), "anchor": "-20" });
    var box3_2_panel1000 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 66, "autoHeight": true, "layout": "form", "xtype": "panel", "items": city998, "labelAlign": "top" }, { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": zip_code999, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 81, "border": false, "anchor": "-20", "labelAlign": "top" });
    var street_prefix1003 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Pr\u00e9fixe rue","Text to print before name of street, but to ignore for sorting.") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Pr\u00e9fixe rue</span>", "name": "street_prefix", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var street1004 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Rue","Name of street. Without house number.") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Rue</span>", "name": "street", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var street_no1005 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("N\u00b0","House number") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">N\u00b0</span>", "name": "street_no", "maxLength": 10, "selectOnFocus": true, "boxMinWidth": Lino.chars2width(10), "anchor": "-20" });
    var street_box1006 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("bo\u00eete","Text to print after :attr:`steet_no` on the same line") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">bo\u00eete</span>", "name": "street_box", "maxLength": 10, "selectOnFocus": true, "boxMinWidth": Lino.chars2width(10), "anchor": "-20" });
    var box3_3_panel1007 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 30, "autoHeight": true, "layout": "form", "xtype": "panel", "items": street_prefix1003, "labelAlign": "top" }, { "flex": 36, "autoHeight": true, "layout": "form", "xtype": "panel", "items": street1004, "labelAlign": "top" }, { "flex": 16, "autoHeight": true, "layout": "form", "xtype": "panel", "items": street_no1005, "labelAlign": "top" }, { "flex": 16, "autoHeight": true, "layout": "form", "xtype": "panel", "items": street_box1006, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 108, "border": false, "anchor": "-20", "labelAlign": "top" });
    var addr21012 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Ligne apr\u00e8s le nom de rue","Address line to print below street line") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Ligne apr\u00e8s le nom de rue</span>", "name": "addr2", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var activity1013 = new Lino.RemoteComboFieldElement({ "fieldLabel": "Activit\u00e9", "name": "activity", "pageSize": 20, "emptyText": "Choisir Activit\u00e9...", "selectOnFocus": true, "hiddenName": "activityHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/households/Households/activity", "method": "GET" }) }) });
    var bank_account11014 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 40, "fieldLabel": "Compte en banque 1", "anchor": "-20", "name": "bank_account1" });
    var bank_account21015 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 40, "fieldLabel": "Compte en banque 2", "anchor": "-20", "name": "bank_account2" });
    var box3_5_panel1016 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 45, "autoHeight": true, "layout": "form", "xtype": "panel", "items": activity1013, "labelAlign": "top" }, { "flex": 27, "autoHeight": true, "layout": "form", "xtype": "panel", "items": bank_account11014, "labelAlign": "top" }, { "flex": 27, "autoHeight": true, "layout": "form", "xtype": "panel", "items": bank_account21015, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 171, "border": false, "anchor": "-20", "labelAlign": "top" });
    var box3_panel1020 = new Ext.Panel({ "flex": 62, "autoHeight": true, "layout": "form", "items": [ box3_1_panel995, box3_2_panel1000, box3_3_panel1007, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": addr21012, "anchor": "-20", "labelAlign": "top" }, box3_5_panel1016 ], "frame": true, "bodyBorder": false, "autoScroll": false, "hideCheckBoxLabels": true, "labelWidth": 234, "border": false, "labelAlign": "top" });
    var email1022 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 75, "fieldLabel": "E-mail", "anchor": "-20", "name": "email" });
    var url1023 = new Lino.URLField({ "selectOnFocus": true, "maxLength": 200, "fieldLabel": "URL", "anchor": "-20", "name": "url" });
    var phone1024 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200, "fieldLabel": "T\u00e9l\u00e9phone", "anchor": "-20", "name": "phone" });
    var gsm1025 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200, "fieldLabel": "GSM", "anchor": "-20", "name": "gsm" });
    var box4_panel1026 = new Ext.Panel({ "flex": 37, "autoHeight": true, "layout": "form", "items": [ { "autoHeight": true, "layout": "form", "xtype": "panel", "items": email1022, "anchor": "-20", "labelAlign": "top" }, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": url1023, "anchor": "-20", "labelAlign": "top" }, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": phone1024, "anchor": "-20", "labelAlign": "top" }, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": gsm1025, "anchor": "-20", "labelAlign": "top" } ], "frame": true, "bodyBorder": false, "autoScroll": false, "hideCheckBoxLabels": true, "labelWidth": 90, "border": false, "labelAlign": "top" });
    var address_box_panel1031 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "hideCheckBoxLabels": true, "items": [ box3_panel1020, box4_panel1026 ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var remarks1032 = new Ext.form.TextArea({ "selectOnFocus": true, "fieldLabel": "Remarques", "anchor": "-20 -10", "growMax": 2000, "name": "remarks" });
    var households_MembersByHousehold_grid1039 = new Lino.households.MembersByHousehold.GridPanel({ "tools": [ Lino.show_in_own_window_button(Lino.households.MembersByHousehold.grid) ], "containing_panel": this, "hide_top_toolbar": true, "master_panel": this, "flex": 50 });
    var bottom_box_panel1040 = new Ext.Panel({ "flex": 45, "border": false, "layout": "hbox", "labelWidth": 90, "hideCheckBoxLabels": true, "items": [ { "items": remarks1032, "labelAlign": "top", "layout": "form", "xtype": "panel", "flex": 49 }, households_MembersByHousehold_grid1039 ], "autoScroll": false, "layoutConfig": { "align": "stretch" }, "frame": false, "labelAlign": "top" });
    var general_panel1042 = new Ext.Panel({ "layout": "vbox", "title": "G\u00e9n\u00e9ral", "items": [ intro_box_1_panel988, address_box_panel1031, bottom_box_panel1040 ], "frame": true, "layoutConfig": { "align": "stretch" }, "hideCheckBoxLabels": true, "listeners": { "activate": Lino.on_tab_activate }, "autoScroll": false, "border": false, "bodyBorder": false, "labelAlign": "top" });
    var main_panel1046 = new Ext.TabPanel({ "hideCheckBoxLabels": true, "border": false, "split": true, "autoScroll": false, "items": [ general_panel1042 ], "activeTab": 0, "bodyBorder": false, "frame": true, "labelAlign": "top" });
    this.items = main_panel1046;
    this.before_row_edit = function(record) {
      region994.setContextValue('country',record ? record.data['countryHidden'] : undefined);
      city998.setContextValue('country',record ? record.data['countryHidden'] : undefined);
      city998.setContextValue('region',record ? record.data['regionHidden'] : undefined);
      households_MembersByHousehold_grid1039.on_master_changed();
    }
    this.onRender = function(ct, position) {
      country993.on('change',Lino.chooser_handler(region994,'country'));
      country993.on('change',Lino.chooser_handler(city998,'country'));
      region994.on('change',Lino.chooser_handler(city998,'region'));
      Lino.households.Households.DetailFormPanel.superclass.onRender.call(this, ct, position);
    }
    Lino.households.Households.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.about.Models.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  disable_editing: true,
  initComponent : function() {
    var containing_panel = this;
    var app_disp2512 = new Ext.form.DisplayField({ "disabled": true, "fieldLabel": "app_label", "name": "app", "anchor": "-20", "value": "<br/>", "always_enabled": true });
    var name_disp2513 = new Ext.form.DisplayField({ "disabled": true, "fieldLabel": "name", "name": "name", "anchor": "-20", "value": "<br/>", "always_enabled": true });
    var docstring_disp2514 = new Ext.form.DisplayField({ "disabled": true, "fieldLabel": "docstring", "name": "docstring", "anchor": "-20", "value": "<br/>", "always_enabled": true });
    var rows2515 = new Ext.form.NumberField({ "disabled": true, "fieldLabel": "Rows", "anchor": "-20", "name": "rows" });
    var main_1_panel2516 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 90, "hideCheckBoxLabels": true, "items": [ { "flex": 31, "autoHeight": true, "layout": "form", "xtype": "panel", "items": app_disp2512, "labelAlign": "top" }, { "flex": 31, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_disp2513, "labelAlign": "top" }, { "flex": 31, "autoHeight": true, "layout": "form", "xtype": "panel", "items": docstring_disp2514, "labelAlign": "top" }, { "flex": 5, "autoHeight": true, "layout": "form", "xtype": "panel", "items": rows2515, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var about_FieldsByModel_grid2525 = new Lino.about.FieldsByModel.GridPanel({ "tools": [ Lino.show_in_own_window_button(Lino.about.FieldsByModel.grid) ], "containing_panel": this, "hide_top_toolbar": true, "master_panel": this, "flex": 62 });
    var main_panel2526 = new Ext.Panel({ "autoScroll": false, "border": false, "layout": "vbox", "hideCheckBoxLabels": true, "items": [ main_1_panel2516, about_FieldsByModel_grid2525 ], "frame": true, "layoutConfig": { "align": "stretch" }, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel2526;
    this.before_row_edit = function(record) {
      about_FieldsByModel_grid2525.on_master_changed();
    }
    Lino.about.Models.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.cbss.IdentifyPersonRequests.InsertFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  autoHeight: true,
  content_type: 93,
  initComponent : function() {
    var containing_panel = this;
    var person2299 = new Lino.TwinCombo({ "fieldLabel": "Client", "allowBlank": false, "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.pcsw.Clients.detail)}, "emptyText": "Choisir Client...", "selectOnFocus": true, "hiddenName": "personHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cbss/IdentifyPersonRequests/person", "method": "GET" }) }), "name": "person" });
    var national_id2300 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200, "fieldLabel": "NISS", "anchor": "-20", "name": "national_id" });
    var main_1_panel2301 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 48, "autoHeight": true, "layout": "form", "xtype": "panel", "items": person2299, "labelAlign": "top" }, { "flex": 51, "autoHeight": true, "layout": "form", "xtype": "panel", "items": national_id2300, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 63, "border": false, "anchor": "-20", "labelAlign": "top" });
    var first_name2304 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200, "fieldLabel": "Pr\u00e9nom", "anchor": "-20", "name": "first_name" });
    var middle_name2305 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Middle name","Whatever this means...") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Middle name</span>", "name": "middle_name", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var last_name2306 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200, "fieldLabel": "Nom de famille", "anchor": "-20", "name": "last_name" });
    var p2_1_panel2307 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": first_name2304, "labelAlign": "top" }, { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": middle_name2305, "labelAlign": "top" }, { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": last_name2306, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 135, "border": false, "anchor": "-20", "labelAlign": "top" });
    var birth_date2311 = new Lino.IncompleteDateField({ "listeners": { "render": Lino.quicktip_renderer("date de naissance","Unkomplette Datumsangaben sind erlaubt, z.B. \"00.00.1980\" hei\u00dft \"irgendwann im Jahr 1980\", \"00.07.1980\" hei\u00dft \"im Juli 1980\"oder \"23.07.0000\" hei\u00dft \"an einem 23. Juli\".") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">date de naissance</span>", "name": "birth_date", "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var tolerance2312 = new Ext.form.NumberField({ "listeners": { "render": Lino.quicktip_renderer("Tol\u00e9rance","\n      Falls Monat oder Tag des Geburtsdatums unbekannt sind, \n      um wieviel Monate bzw. Tage die Suche nach unten/oben ausgeweitet wird.\n      G\u00fcltige Werte: 0 bis 10.\n      ") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Tol\u00e9rance</span>", "name": "tolerance", "selectOnFocus": true, "anchor": "-20", "value": 0, "allowBlank": false });
    var gender2313 = new Lino.ChoicesFieldElement({ "forceSelection": true, "fieldLabel": "Sexe", "name": "gender", "selectOnFocus": true, "anchor": "-20", "store": Lino.lino.Genders, "hiddenName": "genderHidden" });
    var p2_2_panel2314 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 42, "autoHeight": true, "layout": "form", "xtype": "panel", "items": birth_date2311, "labelAlign": "top" }, { "flex": 17, "autoHeight": true, "layout": "form", "xtype": "panel", "items": tolerance2312, "labelAlign": "top" }, { "flex": 39, "autoHeight": true, "layout": "form", "xtype": "panel", "items": gender2313, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 162, "border": false, "anchor": "-20", "labelAlign": "top" });
    var p2_panel2318 = new Ext.form.FieldSet({ "autoHeight": true, "layout": "form", "title": "Recherche phon\u00e9tique", "items": [ p2_1_panel2307, p2_2_panel2314 ], "frame": true, "bodyBorder": false, "autoScroll": false, "hideCheckBoxLabels": true, "border": false, "anchor": "-20", "labelAlign": "top" });
    var main_panel2319 = new Ext.Panel({ "hideCheckBoxLabels": true, "autoHeight": true, "border": false, "layout": "form", "autoScroll": false, "items": [ main_1_panel2301, p2_panel2318 ], "frame": true, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel2319;
    this.before_row_edit = function(record) {
    }
    Lino.cbss.IdentifyPersonRequests.InsertFormPanel.superclass.initComponent.call(this);
    // active_fields:
    person2299.on("change",function(){this.save()},this);
  }
});


Lino.ui.MyTextFieldTemplates.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 1,
  initComponent : function() {
    var containing_panel = this;
    var id2452 = new Ext.form.NumberField({ "selectOnFocus": true, "fieldLabel": "ID", "anchor": "-20", "name": "id" });
    var name2453 = new Ext.form.TextField({ "fieldLabel": "Description", "name": "name", "maxLength": 200, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var user2454 = new Lino.TwinCombo({ "fieldLabel": "Auteur", "name": "user", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.users.Users.detail)}, "emptyText": "Choisir Utilisateur...", "selectOnFocus": true, "hiddenName": "userHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/ui/TextFieldTemplates/user", "method": "GET" }) }) });
    var team2455 = new Lino.RemoteComboFieldElement({ "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Team</span>", "name": "team", "pageSize": 20, "emptyText": "Choisir Team...", "listeners": { "render": Lino.quicktip_renderer("Team","If not empty, then this template is reserved to members of this team.") }, "selectOnFocus": true, "hiddenName": "teamHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/ui/TextFieldTemplates/team", "method": "GET" }) }) });
    var main_1_panel2456 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 8, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id2452, "labelAlign": "top" }, { "flex": 34, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name2453, "labelAlign": "top" }, { "flex": 24, "autoHeight": true, "layout": "form", "xtype": "panel", "items": user2454, "labelAlign": "top" }, { "flex": 32, "autoHeight": true, "layout": "form", "xtype": "panel", "items": team2455, "labelAlign": "top" } ], "region": "north", "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "split": true, "autoScroll": false, "labelWidth": 108, "border": false, "frame": false, "labelAlign": "top" });
    var description2461 = new Ext.form.TextArea({ "selectOnFocus": true, "fieldLabel": "Description", "anchor": "-20 -10", "growMax": 2000, "name": "description" });
    var text2462 = new Lino.RichTextPanel({ "flex": 5, "split": true, "containing_panel": this, "selectOnFocus": true, "region": "south", "title": "Texte mod\u00e8le", "name": "text" });
    var main_panel2463 = new Lino.VBorderPanel({ "autoScroll": false, "border": false, "labelWidth": 108, "hideCheckBoxLabels": true, "items": [ main_1_panel2456, { "flex": 5, "layout": "form", "xtype": "panel", "items": description2461, "region": "center", "labelAlign": "top", "split": true }, text2462 ], "frame": true, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel2463;
    this.before_row_edit = function(record) {
      text2462.refresh();
    }
    Lino.ui.MyTextFieldTemplates.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.users.MySettings.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 7,
  initComponent : function() {
    var containing_panel = this;
    var username217 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Username","\n        Required. Must be unique. \n        ") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Username</span>", "name": "username", "maxLength": 30, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var id218 = new Ext.form.NumberField({ "selectOnFocus": true, "fieldLabel": "ID", "anchor": "-20", "name": "id" });
    var profile219 = new Lino.ChoicesFieldElement({ "forceSelection": true, "fieldLabel": "User Profile", "name": "profile", "selectOnFocus": true, "anchor": "-20", "store": Lino.lino.UserProfiles, "hiddenName": "profileHidden" });
    var box1_1_panel220 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 31, "autoHeight": true, "layout": "form", "xtype": "panel", "items": username217, "labelAlign": "top" }, { "flex": 7, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id218, "labelAlign": "top" }, { "flex": 61, "autoHeight": true, "layout": "form", "xtype": "panel", "items": profile219, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 117, "border": false, "anchor": "-20", "labelAlign": "top" });
    var first_name224 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 30, "fieldLabel": "Pr\u00e9nom", "anchor": "-20", "name": "first_name" });
    var last_name225 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 30, "fieldLabel": "Nom de famille", "anchor": "-20", "name": "last_name" });
    var partner226 = new Lino.TwinCombo({ "fieldLabel": "Partenaire", "name": "partner", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.contacts.Partners.detail)}, "emptyText": "Choisir Partenaire...", "selectOnFocus": true, "hiddenName": "partnerHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/users/Users/partner", "method": "GET" }) }) });
    var box1_2_panel227 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": first_name224, "labelAlign": "top" }, { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": last_name225, "labelAlign": "top" }, { "flex": 32, "autoHeight": true, "layout": "form", "xtype": "panel", "items": partner226, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 135, "border": false, "anchor": "-20", "labelAlign": "top" });
    var email231 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 75, "fieldLabel": "adresse e-mail", "anchor": "-20", "name": "email" });
    var language232 = new Lino.ChoicesFieldElement({ "fieldLabel": "Langue", "allowBlank": false, "selectOnFocus": true, "hiddenName": "languageHidden", "anchor": "-20", "store": [ [ "de", "German" ], [ "fr", "French" ], [ "nl", "Dutch" ] ], "name": "language" });
    var box1_3_panel233 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 51, "autoHeight": true, "layout": "form", "xtype": "panel", "items": email231, "labelAlign": "top" }, { "flex": 48, "autoHeight": true, "layout": "form", "xtype": "panel", "items": language232, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 135, "border": false, "anchor": "-20", "labelAlign": "top" });
    var created236 = new Ext.form.DisplayField({ "disabled": true, "fieldLabel": "Cr\u00e9\u00e9", "anchor": "-20", "value": "<br>", "name": "created" });
    var modified237 = new Ext.form.DisplayField({ "disabled": true, "fieldLabel": "Modified", "anchor": "-20", "value": "<br>", "name": "modified" });
    var box1_4_panel238 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": created236, "labelAlign": "top" }, { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": modified237, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 81, "border": false, "anchor": "-20", "labelAlign": "top" });
    var box1_panel241 = new Ext.Panel({ "flex": 66, "autoHeight": true, "border": false, "layout": "form", "hideCheckBoxLabels": true, "items": [ box1_1_panel220, box1_2_panel227, box1_3_panel233, box1_4_panel238 ], "frame": true, "autoScroll": false, "bodyBorder": false, "labelAlign": "top" });
    var general_1_panel245 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "hideCheckBoxLabels": true, "items": [ box1_panel241 ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var remarks246 = new Ext.form.TextArea({ "selectOnFocus": true, "fieldLabel": "Remarques", "anchor": "-20 -10", "growMax": 2000, "name": "remarks" });
    var AuthoritiesGiven_grid249 = new Lino.users.AuthoritiesGiven.GridPanel({ "tools": [ Lino.show_in_own_window_button(Lino.users.AuthoritiesGiven.grid) ], "containing_panel": this, "hide_top_toolbar": true, "master_panel": this, "flex": 33 });
    var general_2_panel250 = new Ext.Panel({ "flex": 50, "border": false, "layout": "hbox", "labelWidth": 90, "hideCheckBoxLabels": true, "items": [ { "items": remarks246, "labelAlign": "top", "layout": "form", "xtype": "panel", "flex": 66 }, AuthoritiesGiven_grid249 ], "autoScroll": false, "layoutConfig": { "align": "stretch" }, "frame": false, "labelAlign": "top" });
    var general_panel252 = new Ext.Panel({ "layout": "vbox", "title": "G\u00e9n\u00e9ral", "items": [ general_1_panel245, general_2_panel250 ], "frame": true, "layoutConfig": { "align": "stretch" }, "hideCheckBoxLabels": true, "listeners": { "activate": Lino.on_tab_activate }, "autoScroll": false, "border": false, "bodyBorder": false, "labelAlign": "top" });
    var calendar253 = new Lino.TwinCombo({ "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Calendrier par d\u00e9faut</span>", "name": "calendar", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.cal.Calendars.detail)}, "emptyText": "Choisir Calendrier...", "listeners": { "render": Lino.quicktip_renderer("Calendrier par d\u00e9faut","Le calendrier par d\u00e9faut pour vos rendez-vous et t\u00e2ches.") }, "selectOnFocus": true, "hiddenName": "calendarHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/users/Users/calendar", "method": "GET" }) }) });
    var access_class254 = new Lino.ChoicesFieldElement({ "forceSelection": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Classe d'acc\u00e8s par d\u00e9faut</span>", "allowBlank": false, "hiddenName": "access_classHidden", "listeners": { "render": Lino.quicktip_renderer("Classe d'acc\u00e8s par d\u00e9faut","The default access class for your calendar events and tasks.") }, "selectOnFocus": true, "anchor": "-20", "store": Lino.cal.AccessClasses, "name": "access_class" });
    var cal_left_1_panel255 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 234, "hideCheckBoxLabels": true, "items": [ { "flex": 37, "autoHeight": true, "layout": "form", "xtype": "panel", "items": calendar253, "labelAlign": "top" }, { "flex": 62, "autoHeight": true, "layout": "form", "xtype": "panel", "items": access_class254, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var cal_SubscriptionsByUser_grid262 = new Lino.cal.SubscriptionsByUser.GridPanel({ "tools": [ Lino.show_in_own_window_button(Lino.cal.SubscriptionsByUser.grid) ], "containing_panel": this, "hide_top_toolbar": true, "master_panel": this, "flex": 83 });
    var cal_left_panel263 = new Ext.Panel({ "flex": 33, "border": false, "layout": "vbox", "bodyBorder": false, "hideCheckBoxLabels": true, "items": [ cal_left_1_panel255, cal_SubscriptionsByUser_grid262 ], "autoScroll": false, "layoutConfig": { "align": "stretch" }, "frame": true, "labelAlign": "top" });
    var cal_TasksByUser_grid321 = new Lino.cal.TasksByUser.GridPanel({ "tools": [ Lino.show_in_own_window_button(Lino.cal.TasksByUser.grid) ], "containing_panel": this, "hide_top_toolbar": true, "master_panel": this, "flex": 66 });
    var cal_1_panel322 = new Ext.Panel({ "autoScroll": false, "listeners": { "activate": Lino.on_tab_activate }, "border": false, "layout": "hbox", "title": "Calendrier", "hideCheckBoxLabels": true, "items": [ cal_left_panel263, cal_TasksByUser_grid321 ], "frame": false, "layoutConfig": { "align": "stretch" }, "labelAlign": "top" });
    var newcomer_quota323 = new Ext.form.NumberField({ "listeners": { "render": Lino.quicktip_renderer("Quota nouvelles demandes","Wieviel Arbeitszeit dieser Benutzer f\u00fcr Neuantr\u00e4ge zur Verf\u00fcgung steht\n(100 = ganztags, 50 = halbtags, 0 = gar nicht).\nWenn zwei Benutzer die gleiche Belastungspunktzahl haben, \naber einer davon sich nur zu 50% um Neuantr\u00e4ge k\u00fcmmert, \ngilt er als doppelt so belastet wie sein Kollege.\n") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Quota nouvelles demandes</span>", "name": "newcomer_quota", "selectOnFocus": true, "anchor": "-20", "value": 0, "allowBlank": false });
    var coaching_type324 = new Lino.RemoteComboFieldElement({ "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Service</span>", "name": "coaching_type", "pageSize": 20, "emptyText": "Choisir Service...", "listeners": { "render": Lino.quicktip_renderer("Service","The default CoachingType used when creating Coachings.") }, "selectOnFocus": true, "hiddenName": "coaching_typeHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/users/Users/coaching_type", "method": "GET" }) }) });
    var coaching_supervisor325 = new Ext.form.Checkbox({ "boxLabel": "Notify me when a coach has been assigned", "listeners": { "render": Lino.quicktip_renderer("Notify me when a coach has been assigned","Wenn ein Neuantrag einem Begleiter zugewiesen wurde, wird au\u00dfer dem Begleiter auch dieser Benutzer benachrichtigt.") }, "hideLabel": true, "checked": false, "name": "coaching_supervisor", "selectOnFocus": true, "anchor": "-20" });
    var newcomers_CompetencesByUser_grid331 = new Lino.newcomers.CompetencesByUser.GridPanel({ "tools": [ Lino.show_in_own_window_button(Lino.newcomers.CompetencesByUser.grid) ], "containing_panel": this, "hide_top_toolbar": true, "master_panel": this, "flex": 62 });
    var coaching_a_panel332 = new Ext.Panel({ "flex": 33, "layout": "vbox", "items": [ { "items": newcomer_quota323, "autoHeight": true, "layout": "form", "xtype": "panel", "labelAlign": "top" }, { "items": coaching_type324, "autoHeight": true, "layout": "form", "xtype": "panel", "labelAlign": "top" }, { "items": coaching_supervisor325, "autoHeight": true, "layout": "form", "xtype": "panel", "labelAlign": "top" }, newcomers_CompetencesByUser_grid331 ], "frame": true, "layoutConfig": { "align": "stretch" }, "autoScroll": false, "hideCheckBoxLabels": true, "labelWidth": 369, "border": false, "bodyBorder": false, "labelAlign": "top" });
    var pcsw_CoachingsByUser_grid362 = new Lino.pcsw.CoachingsByUser.GridPanel({ "flex": 66, "hide_top_toolbar": true, "containing_panel": this, "params_panel_hidden": true, "tools": [ Lino.show_in_own_window_button(Lino.pcsw.CoachingsByUser.grid) ], "master_panel": this });
    var coaching_1_panel363 = new Ext.Panel({ "autoScroll": false, "listeners": { "activate": Lino.on_tab_activate }, "border": false, "layout": "hbox", "title": "Accompagnement", "hideCheckBoxLabels": true, "items": [ coaching_a_panel332, pcsw_CoachingsByUser_grid362 ], "frame": false, "layoutConfig": { "align": "stretch" }, "labelAlign": "top" });
    var main_panel364 = new Ext.TabPanel({ "hideCheckBoxLabels": true, "border": false, "split": true, "autoScroll": false, "items": [ general_panel252, cal_1_panel322, coaching_1_panel363 ], "activeTab": 0, "bodyBorder": false, "frame": true, "labelAlign": "top" });
    this.items = main_panel364;
    this.before_row_edit = function(record) {
      AuthoritiesGiven_grid249.on_master_changed();
      cal_SubscriptionsByUser_grid262.on_master_changed();
      cal_TasksByUser_grid321.on_master_changed();
      newcomers_CompetencesByUser_grid331.on_master_changed();
      pcsw_CoachingsByUser_grid362.on_master_changed();
    }
    Lino.users.MySettings.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.pcsw.Clients.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 53,
  initComponent : function() {
    var containing_panel = this;
    var last_name1153 = new Ext.form.TextField({ "fieldLabel": "Nom de famille", "name": "last_name", "maxLength": 200, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var first_name1154 = new Ext.form.TextField({ "fieldLabel": "Pr\u00e9nom", "name": "first_name", "maxLength": 200, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var title1155 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200, "fieldLabel": "Allocution", "anchor": "-20", "name": "title" });
    var box1_1_panel1156 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 45, "autoHeight": true, "layout": "form", "xtype": "panel", "items": last_name1153, "labelAlign": "top" }, { "flex": 32, "autoHeight": true, "layout": "form", "xtype": "panel", "items": first_name1154, "labelAlign": "top" }, { "flex": 21, "autoHeight": true, "layout": "form", "xtype": "panel", "items": title1155, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 135, "border": false, "anchor": "-20", "labelAlign": "top" });
    var country1160 = new Lino.TwinCombo({ "fieldLabel": "Pays", "name": "country", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.countries.Countries.detail)}, "emptyText": "Choisir Pays...", "selectOnFocus": true, "hiddenName": "countryHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/pcsw/Clients/country", "method": "GET" }) }) });
    var city1161 = new Lino.TwinCombo({ "forceSelection": false, "fieldLabel": "Place", "name": "city", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.countries.Cities.detail)}, "emptyText": "Choisir Place...", "selectOnFocus": true, "hiddenName": "cityHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/pcsw/Clients/city", "method": "GET" }) }) });
    var zip_code1162 = new Ext.form.TextField({ "fieldLabel": "Zip code", "name": "zip_code", "maxLength": 10, "selectOnFocus": true, "boxMinWidth": Lino.chars2width(10), "anchor": "-20" });
    var box1_2_panel1163 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 40, "autoHeight": true, "layout": "form", "xtype": "panel", "items": country1160, "labelAlign": "top" }, { "flex": 40, "autoHeight": true, "layout": "form", "xtype": "panel", "items": city1161, "labelAlign": "top" }, { "flex": 20, "autoHeight": true, "layout": "form", "xtype": "panel", "items": zip_code1162, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 81, "border": false, "anchor": "-20", "labelAlign": "top" });
    var street_prefix1167 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Pr\u00e9fixe rue","Text to print before name of street, but to ignore for sorting.") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Pr\u00e9fixe rue</span>", "name": "street_prefix", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var street1168 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Rue","Name of street. Without house number.") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Rue</span>", "name": "street", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var street_no1169 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("N\u00b0","House number") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">N\u00b0</span>", "name": "street_no", "maxLength": 10, "selectOnFocus": true, "boxMinWidth": Lino.chars2width(10), "anchor": "-20" });
    var street_box1170 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("bo\u00eete","Text to print after :attr:`steet_no` on the same line") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">bo\u00eete</span>", "name": "street_box", "maxLength": 10, "selectOnFocus": true, "boxMinWidth": Lino.chars2width(10), "anchor": "-20" });
    var box1_3_panel1171 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 30, "autoHeight": true, "layout": "form", "xtype": "panel", "items": street_prefix1167, "labelAlign": "top" }, { "flex": 36, "autoHeight": true, "layout": "form", "xtype": "panel", "items": street1168, "labelAlign": "top" }, { "flex": 16, "autoHeight": true, "layout": "form", "xtype": "panel", "items": street_no1169, "labelAlign": "top" }, { "flex": 16, "autoHeight": true, "layout": "form", "xtype": "panel", "items": street_box1170, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 108, "border": false, "anchor": "-20", "labelAlign": "top" });
    var addr21176 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Ligne apr\u00e8s le nom de rue","Address line to print below street line") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Ligne apr\u00e8s le nom de rue</span>", "name": "addr2", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var box1_panel1177 = new Ext.form.FieldSet({ "flex": 61, "autoHeight": true, "layout": "form", "title": "Addresse", "items": [ box1_1_panel1156, box1_2_panel1163, box1_3_panel1171, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": addr21176, "anchor": "-20", "labelAlign": "top" } ], "frame": true, "bodyBorder": false, "autoScroll": false, "hideCheckBoxLabels": true, "labelWidth": 234, "border": false, "labelAlign": "top" });
    var id1179 = new Ext.form.NumberField({ "selectOnFocus": true, "fieldLabel": "ID", "anchor": "-20", "name": "id" });
    var language1180 = new Lino.ChoicesFieldElement({ "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Langue</span>", "allowBlank": false, "value": "de", "hiddenName": "languageHidden", "listeners": { "render": Lino.quicktip_renderer("Langue","Die Sprache, in der Dokumente ausgestellt werden sollen.") }, "selectOnFocus": true, "anchor": "-20", "store": [ [ "de", "German" ], [ "fr", "French" ], [ "nl", "Dutch" ] ], "name": "language" });
    var box2_1_panel1181 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 37, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id1179, "labelAlign": "top" }, { "flex": 62, "autoHeight": true, "layout": "form", "xtype": "panel", "items": language1180, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 63, "border": false, "anchor": "-20", "labelAlign": "top" });
    var email1184 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 75, "fieldLabel": "E-mail", "anchor": "-20", "name": "email" });
    var phone1185 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200, "fieldLabel": "T\u00e9l\u00e9phone", "anchor": "-20", "name": "phone" });
    var fax1186 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200, "fieldLabel": "Fax", "anchor": "-20", "name": "fax" });
    var box2_3_panel1187 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": phone1185, "labelAlign": "top" }, { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": fax1186, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 90, "border": false, "anchor": "-20", "labelAlign": "top" });
    var gsm1190 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200, "fieldLabel": "GSM", "anchor": "-20", "name": "gsm" });
    var box2_panel1191 = new Ext.form.FieldSet({ "flex": 38, "autoHeight": true, "layout": "form", "title": "Contact", "items": [ box2_1_panel1181, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": email1184, "anchor": "-20", "labelAlign": "top" }, box2_3_panel1187, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": gsm1190, "anchor": "-20", "labelAlign": "top" } ], "frame": true, "bodyBorder": false, "autoScroll": false, "hideCheckBoxLabels": true, "labelWidth": 63, "border": false, "labelAlign": "top" });
    var general_1_panel1194 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "hideCheckBoxLabels": true, "items": [ box1_panel1177, box2_panel1191 ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "anchor": "-20", "labelAlign": "top" });
    var gender1195 = new Lino.ChoicesFieldElement({ "forceSelection": true, "fieldLabel": "Sexe", "name": "gender", "selectOnFocus": true, "anchor": "-20", "store": Lino.lino.Genders, "hiddenName": "genderHidden" });
    var birth_date1196 = new Lino.IncompleteDateField({ "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("date de naissance","Unkomplette Datumsangaben sind erlaubt, z.B. \"00.00.1980\" hei\u00dft \"irgendwann im Jahr 1980\", \"00.07.1980\" hei\u00dft \"im Juli 1980\"oder \"23.07.0000\" hei\u00dft \"an einem 23. Juli\".") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">date de naissance</span>", "anchor": "-20", "name": "birth_date" });
    var age_disp1197 = new Ext.form.DisplayField({ "disabled": true, "fieldLabel": "\u00e2ge", "name": "age", "anchor": "-20", "value": "<br/>", "always_enabled": true });
    var civil_state1198 = new Lino.ChoicesFieldElement({ "forceSelection": true, "fieldLabel": "Etat civil", "name": "civil_state", "selectOnFocus": true, "anchor": "-20", "store": Lino.pcsw.CivilState, "hiddenName": "civil_stateHidden" });
    var noble_condition1199 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Titre de noblesse","The eventual noble condition of this person. Imported from TIM.") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Titre de noblesse</span>", "name": "noble_condition", "maxLength": 50, "selectOnFocus": true, "anchor": "-20" });
    var box3_1_panel1200 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 14, "autoHeight": true, "layout": "form", "xtype": "panel", "items": gender1195, "labelAlign": "top" }, { "flex": 17, "autoHeight": true, "layout": "form", "xtype": "panel", "items": birth_date1196, "labelAlign": "top" }, { "flex": 14, "autoHeight": true, "layout": "form", "xtype": "panel", "items": age_disp1197, "labelAlign": "top" }, { "flex": 22, "autoHeight": true, "layout": "form", "xtype": "panel", "items": civil_state1198, "labelAlign": "top" }, { "flex": 30, "autoHeight": true, "layout": "form", "xtype": "panel", "items": noble_condition1199, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 162, "border": false, "anchor": "-20", "labelAlign": "top" });
    var birth_country1206 = new Lino.TwinCombo({ "fieldLabel": "Pays de naissance", "name": "birth_country", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.countries.Countries.detail)}, "emptyText": "Choisir Pays...", "selectOnFocus": true, "hiddenName": "birth_countryHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/pcsw/Clients/birth_country", "method": "GET" }) }) });
    var birth_place1207 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200, "fieldLabel": "Lieu de naissance", "anchor": "-20", "name": "birth_place" });
    var nationality1208 = new Lino.TwinCombo({ "fieldLabel": "Nationalit\u00e9", "name": "nationality", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.countries.Countries.detail)}, "emptyText": "Choisir Pays...", "selectOnFocus": true, "hiddenName": "nationalityHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/pcsw/Clients/nationality", "method": "GET" }) }) });
    var national_id1209 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200, "fieldLabel": "NISS", "anchor": "-20", "name": "national_id" });
    var box3_2_panel1210 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 28, "autoHeight": true, "layout": "form", "xtype": "panel", "items": birth_country1206, "labelAlign": "top" }, { "flex": 29, "autoHeight": true, "layout": "form", "xtype": "panel", "items": birth_place1207, "labelAlign": "top" }, { "flex": 21, "autoHeight": true, "layout": "form", "xtype": "panel", "items": nationality1208, "labelAlign": "top" }, { "flex": 21, "autoHeight": true, "layout": "form", "xtype": "panel", "items": national_id1209, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 162, "border": false, "anchor": "-20", "labelAlign": "top" });
    var box3_panel1215 = new Ext.form.FieldSet({ "autoHeight": true, "layout": "form", "title": "Naissance", "items": [ box3_1_panel1200, box3_2_panel1210 ], "frame": true, "bodyBorder": false, "autoScroll": false, "hideCheckBoxLabels": true, "border": false, "anchor": "-20", "labelAlign": "top" });
    var card_number1216 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 20, "fieldLabel": "n\u00b0", "anchor": "-20", "name": "card_number" });
    var card_valid_from1217 = new Lino.DateField({ "selectOnFocus": true, "fieldLabel": "valide de", "anchor": "-20", "name": "card_valid_from" });
    var card_valid_until1218 = new Lino.DateField({ "selectOnFocus": true, "fieldLabel": "expire le", "anchor": "-20", "name": "card_valid_until" });
    var card_issuer1219 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 50, "fieldLabel": "\u00e9mise par", "anchor": "-20", "name": "card_issuer" });
    var card_type1220 = new Lino.ChoicesFieldElement({ "forceSelection": true, "fieldLabel": "Type de carte eID", "name": "card_type", "selectOnFocus": true, "anchor": "-20", "store": Lino.pcsw.BeIdCardTypes, "hiddenName": "card_typeHidden" });
    var eid_panel_1_panel1221 = new Ext.form.FieldSet({ "autoHeight": true, "layout": "hbox", "title": "Carte eID", "bodyBorder": true, "frame": false, "layoutConfig": { "align": "stretchmax" }, "autoScroll": false, "items": [ { "flex": 20, "autoHeight": true, "layout": "form", "xtype": "panel", "items": card_number1216, "labelAlign": "top" }, { "flex": 20, "autoHeight": true, "layout": "form", "xtype": "panel", "items": card_valid_from1217, "labelAlign": "top" }, { "flex": 20, "autoHeight": true, "layout": "form", "xtype": "panel", "items": card_valid_until1218, "labelAlign": "top" }, { "flex": 17, "autoHeight": true, "layout": "form", "xtype": "panel", "items": card_issuer1219, "labelAlign": "top" }, { "flex": 20, "autoHeight": true, "layout": "form", "xtype": "panel", "items": card_type1220, "labelAlign": "top" } ], "hideCheckBoxLabels": true, "labelWidth": 225, "border": false, "anchor": "-20", "labelAlign": "top" });
    var created1227 = new Ext.form.DisplayField({ "disabled": true, "fieldLabel": "Cr\u00e9\u00e9", "anchor": "-20", "value": "<br>", "name": "created" });
    var modified1228 = new Ext.form.DisplayField({ "disabled": true, "fieldLabel": "Modified", "anchor": "-20", "value": "<br>", "name": "modified" });
    var box4_3_panel1229 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": created1227, "labelAlign": "top" }, { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": modified1228, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 81, "border": false, "anchor": "-20", "labelAlign": "top" });
    var box4_panel1232 = new Ext.Panel({ "flex": 82, "autoHeight": true, "border": false, "layout": "form", "hideCheckBoxLabels": true, "items": [ box3_panel1215, eid_panel_1_panel1221, box4_3_panel1229 ], "frame": true, "autoScroll": false, "bodyBorder": false, "labelAlign": "top" });
    var image_htmlbox1233 = new Lino.HtmlBoxPanel({ "flex": 17, "layout": "fit", "name": "image", "containing_panel": this, "items": new Ext.BoxComponent({autoScroll:true}), "master_panel": this, "value": "<br/>", "always_enabled": true, "bodyStyle": "overflow-x:hidden" });
    var general_2_panel1234 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ box4_panel1232, image_htmlbox1233 ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 0, "border": false, "anchor": "-20", "labelAlign": "top" });
    var general_panel1235 = new Ext.Panel({ "autoHeight": true, "layout": "form", "title": "Personne", "items": [ general_1_panel1194, general_2_panel1234 ], "frame": true, "bodyBorder": false, "hideCheckBoxLabels": true, "listeners": { "activate": Lino.on_tab_activate }, "autoScroll": false, "border": false, "labelAlign": "top" });
    var in_belgium_since1236 = new Lino.DateField({ "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("en Belgique depuis","Since when this person in Belgium lives.\n<b>Important:</b> help_text can be formatted.") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">en Belgique depuis</span>", "anchor": "-20", "name": "in_belgium_since" });
    var residence_type1237 = new Lino.ChoicesFieldElement({ "forceSelection": true, "fieldLabel": "Type de s\u00e9jour", "name": "residence_type", "selectOnFocus": true, "anchor": "-20", "store": Lino.pcsw.ResidenceType, "hiddenName": "residence_typeHidden" });
    var gesdos_id1238 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 40, "fieldLabel": "N\u00b0 GesDos", "anchor": "-20", "name": "gesdos_id" });
    var status_1_panel1239 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 25, "autoHeight": true, "layout": "form", "xtype": "panel", "items": in_belgium_since1236, "labelAlign": "top" }, { "flex": 38, "autoHeight": true, "layout": "form", "xtype": "panel", "items": residence_type1237, "labelAlign": "top" }, { "flex": 35, "autoHeight": true, "layout": "form", "xtype": "panel", "items": gesdos_id1238, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 171, "border": false, "anchor": "-20", "labelAlign": "top" });
    var bank_account11243 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 40, "fieldLabel": "Compte en banque 1", "anchor": "-20", "name": "bank_account1" });
    var bank_account21244 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 40, "fieldLabel": "Compte en banque 2", "anchor": "-20", "name": "bank_account2" });
    var status_2_panel1245 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": bank_account11243, "labelAlign": "top" }, { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": bank_account21244, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 171, "border": false, "anchor": "-20", "labelAlign": "top" });
    var job_agents1248 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 100, "fieldLabel": "Agences de travail", "anchor": "-20", "name": "job_agents" });
    var group1249 = new Lino.RemoteComboFieldElement({ "fieldLabel": "Phase d'int\u00e9gration", "name": "group", "pageSize": 20, "emptyText": "Choisir Phase d'int\u00e9gration...", "selectOnFocus": true, "hiddenName": "groupHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/pcsw/Clients/group", "method": "GET" }) }) });
    var status_3_panel1250 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 56, "autoHeight": true, "layout": "form", "xtype": "panel", "items": job_agents1248, "labelAlign": "top" }, { "flex": 43, "autoHeight": true, "layout": "form", "xtype": "panel", "items": group1249, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 180, "border": false, "anchor": "-20", "labelAlign": "top" });
    var status_panel1253 = new Ext.Panel({ "flex": 68, "autoHeight": true, "border": false, "layout": "form", "hideCheckBoxLabels": true, "items": [ status_1_panel1239, status_2_panel1245, status_3_panel1250 ], "frame": true, "autoScroll": false, "bodyBorder": false, "labelAlign": "top" });
    var aid_type1254 = new Lino.RemoteComboFieldElement({ "fieldLabel": "Type d'aide sociale", "name": "aid_type", "pageSize": 20, "emptyText": "Choisir Type d'aide sociale...", "selectOnFocus": true, "hiddenName": "aid_typeHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/pcsw/Clients/aid_type", "method": "GET" }) }) });
    var income_ag1255 = new Ext.form.Checkbox({ "boxLabel": "allocation de ch\u00f4mage", "hideLabel": true, "checked": false, "name": "income_ag", "selectOnFocus": true, "anchor": "-20" });
    var income_wg1256 = new Ext.form.Checkbox({ "boxLabel": "waiting pay", "hideLabel": true, "checked": false, "name": "income_wg", "selectOnFocus": true, "anchor": "-20" });
    var income_2_panel1257 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": income_ag1255, "labelAlign": "top" }, { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": income_wg1256, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 198, "border": false, "anchor": "-20", "labelAlign": "top" });
    var income_kg1260 = new Ext.form.Checkbox({ "boxLabel": "indemnisation maladie", "hideLabel": true, "checked": false, "name": "income_kg", "selectOnFocus": true, "anchor": "-20" });
    var income_rente1261 = new Ext.form.Checkbox({ "boxLabel": "persone de retraite", "hideLabel": true, "checked": false, "name": "income_rente", "selectOnFocus": true, "anchor": "-20" });
    var income_3_panel1262 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": income_kg1260, "labelAlign": "top" }, { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": income_rente1261, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 198, "border": false, "anchor": "-20", "labelAlign": "top" });
    var income_misc1265 = new Ext.form.Checkbox({ "boxLabel": "autres revenus", "hideLabel": true, "checked": false, "name": "income_misc", "selectOnFocus": true, "anchor": "-20" });
    var income_panel1266 = new Ext.Panel({ "flex": 31, "autoHeight": true, "layout": "form", "items": [ { "autoHeight": true, "layout": "form", "xtype": "panel", "items": aid_type1254, "anchor": "-20", "labelAlign": "top" }, income_2_panel1257, income_3_panel1262, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": income_misc1265, "anchor": "-20", "labelAlign": "top" } ], "frame": true, "bodyBorder": false, "autoScroll": false, "hideCheckBoxLabels": true, "labelWidth": 180, "border": false, "labelAlign": "top" });
    var status_tab_1_panel1269 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "hideCheckBoxLabels": true, "items": [ status_panel1253, income_panel1266 ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var pcsw_ExclusionsByClient_grid1281 = new Lino.pcsw.ExclusionsByClient.GridPanel({ "flex": 3, "hide_top_toolbar": true, "split": true, "containing_panel": this, "region": "center", "tools": [ Lino.show_in_own_window_button(Lino.pcsw.ExclusionsByClient.grid) ], "master_panel": this });
    var suche_panel1282 = new Lino.VBorderPanel({ "flex": 50, "border": false, "hideCheckBoxLabels": true, "items": [ pcsw_ExclusionsByClient_grid1281 ], "frame": true, "autoScroll": false, "bodyBorder": false, "labelAlign": "top" });
    var is_seeking1283 = new Ext.form.Checkbox({ "boxLabel": "cherche du travail", "hideLabel": true, "checked": false, "name": "is_seeking", "selectOnFocus": true, "anchor": "-20" });
    var unemployed_since1284 = new Lino.DateField({ "selectOnFocus": true, "fieldLabel": "Cherche du travail depuis", "anchor": "-20", "name": "unemployed_since" });
    var work_permit_suspended_until1285 = new Lino.DateField({ "selectOnFocus": true, "fieldLabel": "suspendu jusque", "anchor": "-20", "name": "work_permit_suspended_until" });
    var papers_1_panel1286 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 234, "hideCheckBoxLabels": true, "items": [ { "flex": 38, "autoHeight": true, "layout": "form", "xtype": "panel", "items": is_seeking1283, "labelAlign": "top" }, { "flex": 30, "autoHeight": true, "layout": "form", "xtype": "panel", "items": unemployed_since1284, "labelAlign": "top" }, { "flex": 30, "autoHeight": true, "layout": "form", "xtype": "panel", "items": work_permit_suspended_until1285, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var needs_residence_permit1290 = new Ext.form.Checkbox({ "boxLabel": "A besoin d'un permis de s\u00e9jour", "hideLabel": true, "checked": false, "name": "needs_residence_permit", "selectOnFocus": true, "anchor": "-20" });
    var needs_work_permit1291 = new Ext.form.Checkbox({ "boxLabel": "A besoin d'un permis de travail", "hideLabel": true, "checked": false, "name": "needs_work_permit", "selectOnFocus": true, "anchor": "-20" });
    var papers_2_panel1292 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 288, "hideCheckBoxLabels": true, "items": [ { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": needs_residence_permit1290, "labelAlign": "top" }, { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": needs_work_permit1291, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var residence_permit_disp1295 = new Ext.form.DisplayField({ "disabled": true, "fieldLabel": "Permis de s\u00e9jour", "name": "residence_permit", "anchor": "-20", "value": "<br/>", "always_enabled": true });
    var work_permit_disp1296 = new Ext.form.DisplayField({ "disabled": true, "fieldLabel": "Permis de travail", "name": "work_permit", "anchor": "-20", "value": "<br/>", "always_enabled": true });
    var driving_licence_disp1297 = new Ext.form.DisplayField({ "disabled": true, "fieldLabel": "permis de conduire", "name": "driving_licence", "anchor": "-20", "value": "<br/>", "always_enabled": true });
    var papers_3_panel1298 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 171, "hideCheckBoxLabels": true, "items": [ { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": residence_permit_disp1295, "labelAlign": "top" }, { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": work_permit_disp1296, "labelAlign": "top" }, { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": driving_licence_disp1297, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var UploadsByController_htmlbox1302 = new Lino.HtmlBoxPanel({ "flex": 37, "ls_bbar_actions": [ { "itemId": "insert", "menu_item_text": "Nouveau", "must_save": true, "tooltip": "Insert a new record", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-new", "overflowText": "Nouveau", "auto_save": true } ], "name": "UploadsByController", "containing_panel": this, "items": new Ext.BoxComponent({autoScroll:true}), "title": "Uploads", "master_panel": this, "value": "<br/>", "always_enabled": true, "bodyStyle": "overflow-x:hidden", "ls_insert_handler": Lino.uploads.UploadsByController.insert, "layout": "fit", "tools": [ Lino.show_in_own_window_button(Lino.uploads.UploadsByController.grid) ] });
    var papers_panel1303 = new Ext.Panel({ "flex": 50, "layout": "vbox", "items": [ papers_1_panel1286, papers_2_panel1292, papers_3_panel1298, UploadsByController_htmlbox1302 ], "frame": true, "layoutConfig": { "align": "stretch" }, "autoScroll": false, "hideCheckBoxLabels": true, "labelWidth": 72, "border": false, "bodyBorder": false, "labelAlign": "top" });
    var status_tab_2_panel1304 = new Ext.Panel({ "flex": 66, "border": false, "layout": "hbox", "hideCheckBoxLabels": true, "items": [ suche_panel1282, papers_panel1303 ], "autoScroll": false, "layoutConfig": { "align": "stretch" }, "frame": false, "labelAlign": "top" });
    var status_tab_panel1305 = new Ext.Panel({ "layout": "vbox", "title": "Statut", "items": [ status_tab_1_panel1269, status_tab_2_panel1304 ], "frame": true, "layoutConfig": { "align": "stretch" }, "hideCheckBoxLabels": true, "listeners": { "activate": Lino.on_tab_activate }, "autoScroll": false, "border": false, "bodyBorder": false, "labelAlign": "top" });
    var workflow_buttons_disp1306 = new Ext.form.DisplayField({ "disabled": true, "fieldLabel": "Arbeitsablauf", "name": "workflow_buttons", "anchor": "-20", "value": "<br/>", "always_enabled": true });
    var broker1307 = new Lino.RemoteComboFieldElement({ "fieldLabel": "Interm\u00e9diaire ", "name": "broker", "pageSize": 20, "emptyText": "Choisir Interm\u00e9diaire ...", "selectOnFocus": true, "hiddenName": "brokerHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/pcsw/Clients/broker", "method": "GET" }) }) });
    var faculty1308 = new Lino.TwinCombo({ "fieldLabel": "Sp\u00e9cificit\u00e9", "name": "faculty", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.newcomers.Faculties.detail)}, "emptyText": "Choisir Sp\u00e9cificit\u00e9...", "selectOnFocus": true, "hiddenName": "facultyHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/pcsw/Clients/faculty", "method": "GET" }) }) });
    var newcomers_left_panel1309 = new Ext.Panel({ "flex": 33, "autoHeight": true, "layout": "form", "items": [ { "autoHeight": true, "layout": "form", "xtype": "panel", "items": workflow_buttons_disp1306, "anchor": "-20", "labelAlign": "top" }, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": broker1307, "anchor": "-20", "labelAlign": "top" }, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": faculty1308, "anchor": "-20", "labelAlign": "top" } ], "frame": true, "bodyBorder": false, "autoScroll": false, "hideCheckBoxLabels": true, "labelWidth": 135, "border": false, "labelAlign": "top" });
    var coaching_1_panel1328 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "hideCheckBoxLabels": true, "items": [ newcomers_left_panel1309 ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var pcsw_ContactsByClient_grid1336 = new Lino.pcsw.ContactsByClient.GridPanel({ "tools": [ Lino.show_in_own_window_button(Lino.pcsw.ContactsByClient.grid) ], "containing_panel": this, "hide_top_toolbar": true, "master_panel": this, "flex": 50 });
    var pcsw_CoachingsByClient_grid1345 = new Lino.pcsw.CoachingsByClient.GridPanel({ "flex": 50, "hide_top_toolbar": true, "containing_panel": this, "params_panel_hidden": true, "tools": [ Lino.show_in_own_window_button(Lino.pcsw.CoachingsByClient.grid) ], "master_panel": this });
    var coaching_2_panel1346 = new Ext.Panel({ "flex": 50, "border": false, "layout": "hbox", "hideCheckBoxLabels": true, "items": [ pcsw_ContactsByClient_grid1336, pcsw_CoachingsByClient_grid1345 ], "autoScroll": false, "layoutConfig": { "align": "stretch" }, "frame": false, "labelAlign": "top" });
    var coaching_panel1347 = new Ext.Panel({ "layout": "vbox", "title": "Accompagnement", "items": [ coaching_1_panel1328, coaching_2_panel1346 ], "frame": true, "layoutConfig": { "align": "stretch" }, "hideCheckBoxLabels": true, "listeners": { "activate": Lino.on_tab_activate }, "autoScroll": false, "border": false, "bodyBorder": false, "labelAlign": "top" });
    var jobs_StudiesByPerson_grid1360 = new Lino.jobs.StudiesByPerson.GridPanel({ "flex": 5, "hide_top_toolbar": true, "containing_panel": this, "region": "north", "master_panel": this, "listeners": { "render": Lino.quicktip_renderer("\u00c9tudes & formations","List of studies for a given person.") }, "split": true, "tools": [ Lino.show_in_own_window_button(Lino.jobs.StudiesByPerson.grid) ] });
    var jobs_ExperiencesByPerson_grid1370 = new Lino.jobs.ExperiencesByPerson.GridPanel({ "flex": 5, "hide_top_toolbar": true, "split": true, "containing_panel": this, "region": "center", "tools": [ Lino.show_in_own_window_button(Lino.jobs.ExperiencesByPerson.grid) ], "master_panel": this });
    var education_panel1371 = new Lino.VBorderPanel({ "autoScroll": false, "listeners": { "activate": Lino.on_tab_activate }, "border": false, "title": "Formation", "hideCheckBoxLabels": true, "items": [ jobs_StudiesByPerson_grid1360, jobs_ExperiencesByPerson_grid1370 ], "frame": true, "bodyBorder": false, "labelAlign": "top" });
    var cv_LanguageKnowledgesByPerson_grid1378 = new Lino.cv.LanguageKnowledgesByPerson.GridPanel({ "flex": 5, "hide_top_toolbar": true, "split": true, "containing_panel": this, "region": "north", "tools": [ Lino.show_in_own_window_button(Lino.cv.LanguageKnowledgesByPerson.grid) ], "master_panel": this });
    var courses_CourseRequestsByPerson_grid1414 = new Lino.courses.CourseRequestsByPerson.GridPanel({ "flex": 5, "hide_top_toolbar": true, "split": true, "containing_panel": this, "region": "center", "tools": [ Lino.show_in_own_window_button(Lino.courses.CourseRequestsByPerson.grid) ], "master_panel": this });
    var languages_panel1415 = new Lino.VBorderPanel({ "autoScroll": false, "listeners": { "activate": Lino.on_tab_activate }, "border": false, "title": "Langues", "hideCheckBoxLabels": true, "items": [ cv_LanguageKnowledgesByPerson_grid1378, courses_CourseRequestsByPerson_grid1414 ], "frame": true, "bodyBorder": false, "labelAlign": "top" });
    var cv_SkillsByPerson_grid1422 = new Lino.cv.SkillsByPerson.GridPanel({ "tools": [ Lino.show_in_own_window_button(Lino.cv.SkillsByPerson.grid) ], "containing_panel": this, "hide_top_toolbar": true, "master_panel": this, "flex": 35 });
    var cv_SoftSkillsByPerson_grid1429 = new Lino.cv.SoftSkillsByPerson.GridPanel({ "tools": [ Lino.show_in_own_window_button(Lino.cv.SoftSkillsByPerson.grid) ], "containing_panel": this, "hide_top_toolbar": true, "master_panel": this, "flex": 35 });
    var skills1430 = new Ext.form.TextArea({ "selectOnFocus": true, "fieldLabel": "Autres talents", "anchor": "-20 -10", "growMax": 2000, "name": "skills" });
    var competences_1_panel1431 = new Ext.Panel({ "flex": 5, "layout": "hbox", "items": [ cv_SkillsByPerson_grid1422, cv_SoftSkillsByPerson_grid1429, { "items": skills1430, "labelAlign": "top", "layout": "form", "xtype": "panel", "flex": 28 } ], "region": "north", "layoutConfig": { "align": "stretch" }, "hideCheckBoxLabels": true, "split": true, "autoScroll": false, "labelWidth": 135, "border": false, "frame": false, "labelAlign": "top" });
    var cv_ObstaclesByPerson_grid1439 = new Lino.cv.ObstaclesByPerson.GridPanel({ "tools": [ Lino.show_in_own_window_button(Lino.cv.ObstaclesByPerson.grid) ], "containing_panel": this, "hide_top_toolbar": true, "master_panel": this, "flex": 55 });
    var obstacles1440 = new Ext.form.TextArea({ "selectOnFocus": true, "fieldLabel": "Obstacles", "anchor": "-20 -10", "growMax": 2000, "name": "obstacles" });
    var competences_2_panel1441 = new Ext.Panel({ "flex": 5, "layout": "hbox", "items": [ cv_ObstaclesByPerson_grid1439, { "items": obstacles1440, "labelAlign": "top", "layout": "form", "xtype": "panel", "flex": 44 } ], "region": "center", "layoutConfig": { "align": "stretch" }, "hideCheckBoxLabels": true, "split": true, "autoScroll": false, "labelWidth": 90, "border": false, "frame": false, "labelAlign": "top" });
    var competences_panel1443 = new Lino.VBorderPanel({ "autoScroll": false, "listeners": { "activate": Lino.on_tab_activate }, "border": false, "title": "Comp\u00e9tences", "hideCheckBoxLabels": true, "items": [ competences_1_panel1431, competences_2_panel1441 ], "frame": true, "bodyBorder": false, "labelAlign": "top" });
    var jobs_CandidaturesByPerson_grid1452 = new Lino.jobs.CandidaturesByPerson.GridPanel({ "listeners": { "activate": Lino.on_tab_activate }, "hide_top_toolbar": true, "title": "Demandes d'emploi", "containing_panel": this, "tools": [ Lino.show_in_own_window_button(Lino.jobs.CandidaturesByPerson.grid) ], "master_panel": this });
    var isip_ContractsByPerson_grid1568 = new Lino.isip.ContractsByPerson.GridPanel({ "flex": 5, "hide_top_toolbar": true, "containing_panel": this, "region": "north", "params_panel_hidden": true, "master_panel": this, "split": true, "tools": [ Lino.show_in_own_window_button(Lino.isip.ContractsByPerson.grid) ] });
    var jobs_ContractsByPerson_grid1681 = new Lino.jobs.ContractsByPerson.GridPanel({ "flex": 5, "hide_top_toolbar": true, "containing_panel": this, "region": "center", "params_panel_hidden": true, "master_panel": this, "split": true, "tools": [ Lino.show_in_own_window_button(Lino.jobs.ContractsByPerson.grid) ] });
    var contracts_panel1682 = new Lino.VBorderPanel({ "autoScroll": false, "listeners": { "activate": Lino.on_tab_activate }, "border": false, "title": "Contrats", "hideCheckBoxLabels": true, "items": [ isip_ContractsByPerson_grid1568, jobs_ContractsByPerson_grid1681 ], "frame": true, "bodyBorder": false, "labelAlign": "top" });
    var pcsw_NotesByPerson_grid1697 = new Lino.pcsw.NotesByPerson.GridPanel({ "listeners": { "activate": Lino.on_tab_activate }, "hide_top_toolbar": true, "title": "Historique", "containing_panel": this, "tools": [ Lino.show_in_own_window_button(Lino.pcsw.NotesByPerson.grid) ], "master_panel": this });
    var cal_EventsByProject_grid1723 = new Lino.cal.EventsByProject.GridPanel({ "flex": 5, "hide_top_toolbar": true, "containing_panel": this, "region": "north", "params_panel_hidden": true, "master_panel": this, "split": true, "tools": [ Lino.show_in_own_window_button(Lino.cal.EventsByProject.grid) ] });
    var cal_TasksByProject_grid1746 = new Lino.cal.TasksByProject.GridPanel({ "flex": 5, "hide_top_toolbar": true, "split": true, "containing_panel": this, "region": "center", "tools": [ Lino.show_in_own_window_button(Lino.cal.TasksByProject.grid) ], "master_panel": this });
    var calendar_panel1747 = new Lino.VBorderPanel({ "autoScroll": false, "listeners": { "activate": Lino.on_tab_activate }, "border": false, "title": "Calendrier", "hideCheckBoxLabels": true, "items": [ cal_EventsByProject_grid1723, cal_TasksByProject_grid1746 ], "frame": true, "bodyBorder": false, "labelAlign": "top" });
    var outbox_MailsByProject_grid1759 = new Lino.outbox.MailsByProject.GridPanel({ "flex": 5, "hide_top_toolbar": true, "split": true, "containing_panel": this, "region": "north", "tools": [ Lino.show_in_own_window_button(Lino.outbox.MailsByProject.grid) ], "master_panel": this });
    var postings_PostingsByProject_grid1770 = new Lino.postings.PostingsByProject.GridPanel({ "flex": 5, "hide_top_toolbar": true, "split": true, "containing_panel": this, "region": "center", "tools": [ Lino.show_in_own_window_button(Lino.postings.PostingsByProject.grid) ], "master_panel": this });
    var outbox_panel1771 = new Lino.VBorderPanel({ "autoScroll": false, "listeners": { "activate": Lino.on_tab_activate }, "border": false, "title": "Correspondence", "hideCheckBoxLabels": true, "items": [ outbox_MailsByProject_grid1759, postings_PostingsByProject_grid1770 ], "frame": true, "bodyBorder": false, "labelAlign": "top" });
    var activity1772 = new Lino.RemoteComboFieldElement({ "fieldLabel": "Activit\u00e9", "name": "activity", "pageSize": 20, "emptyText": "Choisir Activit\u00e9...", "selectOnFocus": true, "hiddenName": "activityHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/pcsw/Clients/activity", "method": "GET" }) }) });
    var client_state1773 = new Lino.ChoicesFieldElement({ "forceSelection": true, "fieldLabel": "State", "allowBlank": false, "hiddenName": "client_stateHidden", "selectOnFocus": true, "anchor": "-20", "store": Lino.pcsw.ClientStates, "name": "client_state" });
    var refusal_reason1774 = new Lino.ChoicesFieldElement({ "forceSelection": true, "fieldLabel": "refusal reason", "name": "refusal_reason", "selectOnFocus": true, "anchor": "-20", "store": Lino.pcsw.RefusalReasons, "hiddenName": "refusal_reasonHidden" });
    var misc_1_panel1775 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 135, "hideCheckBoxLabels": true, "items": [ { "flex": 25, "autoHeight": true, "layout": "form", "xtype": "panel", "items": activity1772, "labelAlign": "top" }, { "flex": 15, "autoHeight": true, "layout": "form", "xtype": "panel", "items": client_state1773, "labelAlign": "top" }, { "flex": 58, "autoHeight": true, "layout": "form", "xtype": "panel", "items": refusal_reason1774, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var is_cpas1779 = new Ext.form.Checkbox({ "boxLabel": "client CPAS", "hideLabel": true, "checked": false, "name": "is_cpas", "selectOnFocus": true, "anchor": "-20" });
    var is_senior1780 = new Ext.form.Checkbox({ "boxLabel": "retrait\u00e9", "hideLabel": true, "checked": false, "name": "is_senior", "selectOnFocus": true, "anchor": "-20" });
    var is_obsolete1781 = new Ext.form.Checkbox({ "boxLabel": "obsolete", "listeners": { "render": Lino.quicktip_renderer("obsolete","Altf\u00e4lle sind Partner, deren Stammdaten nicht mehr gepflegt werden und \nf\u00fcr neue Operationen nicht benutzt werden k\u00f6nnen.") }, "hideLabel": true, "checked": false, "name": "is_obsolete", "selectOnFocus": true, "anchor": "-20" });
    var misc_2_panel1782 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 108, "hideCheckBoxLabels": true, "items": [ { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": is_cpas1779, "labelAlign": "top" }, { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": is_senior1780, "labelAlign": "top" }, { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": is_obsolete1781, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var unavailable_until1786 = new Lino.DateField({ "selectOnFocus": true, "fieldLabel": "Indidponible jusque", "anchor": "-20", "name": "unavailable_until" });
    var unavailable_why1787 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 100, "fieldLabel": "raison", "anchor": "-20", "name": "unavailable_why" });
    var misc_3_panel1788 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 180, "hideCheckBoxLabels": true, "items": [ { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": unavailable_until1786, "labelAlign": "top" }, { "flex": 66, "autoHeight": true, "layout": "form", "xtype": "panel", "items": unavailable_why1787, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var remarks1791 = new Ext.form.TextArea({ "selectOnFocus": true, "fieldLabel": "Remarques", "anchor": "-20 -10", "growMax": 2000, "name": "remarks" });
    var remarks21792 = new Ext.form.TextArea({ "selectOnFocus": true, "fieldLabel": "Remarque (Bureau Social)", "anchor": "-20 -10", "growMax": 2000, "name": "remarks2" });
    var misc_4_panel1793 = new Ext.Panel({ "flex": 38, "border": false, "layout": "hbox", "labelWidth": 225, "hideCheckBoxLabels": true, "items": [ { "items": remarks1791, "labelAlign": "top", "layout": "form", "xtype": "panel", "flex": 50 }, { "items": remarks21792, "labelAlign": "top", "layout": "form", "xtype": "panel", "flex": 50 } ], "autoScroll": false, "layoutConfig": { "align": "stretch" }, "frame": false, "labelAlign": "top" });
    var contacts_RolesByPerson_grid1796 = new Lino.contacts.RolesByPerson.GridPanel({ "tools": [ Lino.show_in_own_window_button(Lino.contacts.RolesByPerson.grid) ], "containing_panel": this, "hide_top_toolbar": true, "master_panel": this, "flex": 33 });
    var households_MembersByPerson_grid1797 = new Lino.households.MembersByPerson.GridPanel({ "tools": [ Lino.show_in_own_window_button(Lino.households.MembersByPerson.grid) ], "containing_panel": this, "hide_top_toolbar": true, "master_panel": this, "flex": 66 });
    var misc_5_panel1798 = new Ext.Panel({ "flex": 38, "border": false, "layout": "hbox", "hideCheckBoxLabels": true, "items": [ contacts_RolesByPerson_grid1796, households_MembersByPerson_grid1797 ], "autoScroll": false, "layoutConfig": { "align": "stretch" }, "frame": false, "labelAlign": "top" });
    var misc_panel1799 = new Ext.Panel({ "layout": "vbox", "title": "Divers", "items": [ misc_1_panel1775, misc_2_panel1782, misc_3_panel1788, misc_4_panel1793, misc_5_panel1798 ], "frame": true, "layoutConfig": { "align": "stretch" }, "hideCheckBoxLabels": true, "listeners": { "activate": Lino.on_tab_activate }, "autoScroll": false, "border": false, "bodyBorder": false, "labelAlign": "top" });
    var cbss_identify_person_disp1800 = new Ext.form.DisplayField({ "disabled": true, "fieldLabel": "Requ\u00eates IdentifyPerson", "name": "cbss_identify_person", "anchor": "-20", "value": "<br/>", "always_enabled": true });
    var cbss_manage_access_disp1801 = new Ext.form.DisplayField({ "disabled": true, "fieldLabel": "Requ\u00eates ManageAccess", "name": "cbss_manage_access", "anchor": "-20", "value": "<br/>", "always_enabled": true });
    var cbss_retrieve_ti_groups_disp1802 = new Ext.form.DisplayField({ "disabled": true, "fieldLabel": "Requ\u00eates Tx25", "name": "cbss_retrieve_ti_groups", "anchor": "-20", "value": "<br/>", "always_enabled": true });
    var cbss_1_panel1803 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 216, "hideCheckBoxLabels": true, "items": [ { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": cbss_identify_person_disp1800, "labelAlign": "top" }, { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": cbss_manage_access_disp1801, "labelAlign": "top" }, { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": cbss_retrieve_ti_groups_disp1802, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var cbss_summary_htmlbox1807 = new Lino.HtmlBoxPanel({ "flex": 50, "layout": "fit", "name": "cbss_summary", "containing_panel": this, "items": new Ext.BoxComponent({autoScroll:true}), "title": "Sommaire BCSS", "master_panel": this, "value": "<br/>", "always_enabled": true, "bodyStyle": "overflow-x:hidden" });
    var cbss_panel1808 = new Ext.Panel({ "layout": "vbox", "title": "BCSS", "items": [ cbss_1_panel1803, cbss_summary_htmlbox1807 ], "frame": true, "layoutConfig": { "align": "stretch" }, "hideCheckBoxLabels": true, "listeners": { "activate": Lino.on_tab_activate }, "autoScroll": false, "labelWidth": 126, "border": false, "bodyBorder": false, "labelAlign": "top" });
    var main_panel1812 = new Ext.TabPanel({ "hideCheckBoxLabels": true, "border": false, "split": true, "autoScroll": false, "items": [ general_panel1235, status_tab_panel1305, coaching_panel1347, education_panel1371, languages_panel1415, competences_panel1443, jobs_CandidaturesByPerson_grid1452, contracts_panel1682, pcsw_NotesByPerson_grid1697, calendar_panel1747, outbox_panel1771, misc_panel1799, cbss_panel1808 ], "activeTab": 0, "bodyBorder": false, "frame": true, "labelAlign": "top" });
    this.items = main_panel1812;
    this.before_row_edit = function(record) {
      city1161.setContextValue('country',record ? record.data['countryHidden'] : undefined);
      city1161.setContextValue('region',record ? record.data['regionHidden'] : undefined);
      image_htmlbox1233.refresh();
      pcsw_ExclusionsByClient_grid1281.on_master_changed();
      UploadsByController_htmlbox1302.refresh();
      pcsw_ContactsByClient_grid1336.on_master_changed();
      pcsw_CoachingsByClient_grid1345.on_master_changed();
      jobs_StudiesByPerson_grid1360.on_master_changed();
      jobs_ExperiencesByPerson_grid1370.on_master_changed();
      cv_LanguageKnowledgesByPerson_grid1378.on_master_changed();
      courses_CourseRequestsByPerson_grid1414.on_master_changed();
      cv_SkillsByPerson_grid1422.on_master_changed();
      cv_SoftSkillsByPerson_grid1429.on_master_changed();
      cv_ObstaclesByPerson_grid1439.on_master_changed();
      jobs_CandidaturesByPerson_grid1452.on_master_changed();
      isip_ContractsByPerson_grid1568.on_master_changed();
      jobs_ContractsByPerson_grid1681.on_master_changed();
      pcsw_NotesByPerson_grid1697.on_master_changed();
      cal_EventsByProject_grid1723.on_master_changed();
      cal_TasksByProject_grid1746.on_master_changed();
      outbox_MailsByProject_grid1759.on_master_changed();
      postings_PostingsByProject_grid1770.on_master_changed();
      contacts_RolesByPerson_grid1796.on_master_changed();
      households_MembersByPerson_grid1797.on_master_changed();
      cbss_summary_htmlbox1807.refresh();
    }
    this.onRender = function(ct, position) {
      country1160.on('change',Lino.chooser_handler(city1161,'country'));
      Lino.pcsw.Clients.DetailFormPanel.superclass.onRender.call(this, ct, position);
    }
    Lino.pcsw.Clients.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.cal.MyEvents.InsertFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  autoHeight: true,
  content_type: 36,
  initComponent : function() {
    var containing_panel = this;
    var summary198 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200, "fieldLabel": "R\u00e9sum\u00e9", "anchor": "-20", "name": "summary" });
    var start_date199 = new Lino.DateField({ "selectOnFocus": true, "fieldLabel": "Date d\u00e9but", "anchor": "-20", "name": "start_date" });
    var start_time200 = new Lino.TimeField({ "selectOnFocus": true, "fieldLabel": "Heure de d\u00e9but", "anchor": "-20", "name": "start_time" });
    var start_panel201 = new Ext.Panel({ "flex": 50, "autoHeight": true, "layout": "hbox", "items": [ { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": start_date199, "labelAlign": "top" }, { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": start_time200, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "autoScroll": false, "hideCheckBoxLabels": true, "labelWidth": 135, "border": false, "labelAlign": "top" });
    var end_date204 = new Lino.DateField({ "selectOnFocus": true, "fieldLabel": "Date de fin", "anchor": "-20", "name": "end_date" });
    var end_time205 = new Lino.TimeField({ "selectOnFocus": true, "fieldLabel": "Heure de fin", "anchor": "-20", "name": "end_time" });
    var end_panel206 = new Ext.Panel({ "flex": 50, "autoHeight": true, "layout": "hbox", "items": [ { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": end_date204, "labelAlign": "top" }, { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": end_time205, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "autoScroll": false, "hideCheckBoxLabels": true, "labelWidth": 117, "border": false, "labelAlign": "top" });
    var main_2_panel209 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "hideCheckBoxLabels": true, "items": [ start_panel201, end_panel206 ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "anchor": "-20", "labelAlign": "top" });
    var calendar210 = new Lino.TwinCombo({ "fieldLabel": "Calendrier", "name": "calendar", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.cal.Calendars.detail)}, "emptyText": "Choisir Calendrier...", "selectOnFocus": true, "hiddenName": "calendarHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/Events/calendar", "method": "GET" }) }) });
    var project211 = new Lino.TwinCombo({ "fieldLabel": "Client", "name": "project", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.pcsw.Clients.detail)}, "emptyText": "Choisir Client...", "selectOnFocus": true, "hiddenName": "projectHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/Events/project", "method": "GET" }) }) });
    var main_3_panel212 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": calendar210, "labelAlign": "top" }, { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": project211, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 99, "border": false, "anchor": "-20", "labelAlign": "top" });
    var main_panel215 = new Ext.Panel({ "hideCheckBoxLabels": true, "autoHeight": true, "border": false, "layout": "form", "labelWidth": 63, "autoScroll": false, "items": [ { "autoHeight": true, "layout": "form", "xtype": "panel", "items": summary198, "anchor": "-20", "labelAlign": "top" }, main_2_panel209, main_3_panel212 ], "frame": true, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel215;
    this.before_row_edit = function(record) {
    }
    Lino.cal.MyEvents.InsertFormPanel.superclass.initComponent.call(this);
  }
});


Lino.changes.ChangesByMaster.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 10,
  disable_editing: true,
  initComponent : function() {
    var containing_panel = this;
    var time570 = new Ext.form.DisplayField({ "fieldLabel": "time", "name": "time", "selectOnFocus": true, "anchor": "-20", "value": "<br>", "allowBlank": false });
    var user571 = new Lino.TwinCombo({ "fieldLabel": "Utilisateur", "allowBlank": false, "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.users.Users.detail)}, "emptyText": "Choisir Utilisateur...", "selectOnFocus": true, "hiddenName": "userHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/changes/Changes/user", "method": "GET" }) }), "name": "user" });
    var type572 = new Lino.ChoicesFieldElement({ "forceSelection": true, "fieldLabel": "Change Type", "allowBlank": false, "hiddenName": "typeHidden", "selectOnFocus": true, "anchor": "-20", "store": Lino.lino.ChangeTypes, "name": "type" });
    var master_disp573 = new Ext.form.DisplayField({ "disabled": true, "fieldLabel": "Signal\u00e9tique", "anchor": "-20", "name": "master" });
    var object_disp574 = new Ext.form.DisplayField({ "disabled": true, "fieldLabel": "Object", "anchor": "-20", "name": "object" });
    var id575 = new Ext.form.NumberField({ "selectOnFocus": true, "fieldLabel": "ID", "anchor": "-20", "name": "id" });
    var main_1_panel576 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 117, "hideCheckBoxLabels": true, "items": [ { "flex": 21, "autoHeight": true, "layout": "form", "xtype": "panel", "items": time570, "labelAlign": "top" }, { "flex": 20, "autoHeight": true, "layout": "form", "xtype": "panel", "items": user571, "labelAlign": "top" }, { "flex": 23, "autoHeight": true, "layout": "form", "xtype": "panel", "items": type572, "labelAlign": "top" }, { "flex": 13, "autoHeight": true, "layout": "form", "xtype": "panel", "items": master_disp573, "labelAlign": "top" }, { "flex": 13, "autoHeight": true, "layout": "form", "xtype": "panel", "items": object_disp574, "labelAlign": "top" }, { "flex": 6, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id575, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var diff583 = new Ext.form.TextArea({ "selectOnFocus": true, "fieldLabel": "Changes", "anchor": "-20 -10", "growMax": 2000, "name": "diff" });
    var main_panel584 = new Ext.Panel({ "autoScroll": false, "border": false, "layout": "vbox", "labelWidth": 72, "hideCheckBoxLabels": true, "items": [ main_1_panel576, { "items": diff583, "labelAlign": "top", "layout": "form", "xtype": "panel", "flex": 83 } ], "frame": true, "layoutConfig": { "align": "stretch" }, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel584;
    this.before_row_edit = function(record) {
    }
    Lino.changes.ChangesByMaster.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.cal.PanelCalendars.InsertFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  autoHeight: true,
  content_type: 35,
  initComponent : function() {
    var containing_panel = this;
    var name969 = new Ext.form.TextField({ "fieldLabel": "Description", "name": "name", "maxLength": 200, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var name_fr970 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200, "fieldLabel": "Description (fr)", "anchor": "-20", "name": "name_fr" });
    var name_nl971 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200, "fieldLabel": "Description (nl)", "anchor": "-20", "name": "name_nl" });
    var main_1_panel972 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name969, "labelAlign": "top" }, { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_fr970, "labelAlign": "top" }, { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_nl971, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 153, "border": false, "anchor": "-20", "labelAlign": "top" });
    var type976 = new Lino.ChoicesFieldElement({ "fieldLabel": "Type", "allowBlank": false, "value": "local", "hiddenName": "typeHidden", "selectOnFocus": true, "anchor": "-20", "store": [ [ "local", "Local Calendar" ], [ "google", "Google Calendar" ] ], "name": "type" });
    var invite_team_members977 = new Lino.RemoteComboFieldElement({ "fieldLabel": "Team", "name": "invite_team_members", "pageSize": 20, "emptyText": "Choisir Team...", "selectOnFocus": true, "hiddenName": "invite_team_membersHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/Calendars/invite_team_members", "method": "GET" }) }) });
    var color978 = new Ext.form.NumberField({ "fieldLabel": "Couleur", "name": "color", "selectOnFocus": true, "anchor": "-20", "value": 1, "allowBlank": false });
    var main_2_panel979 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 44, "autoHeight": true, "layout": "form", "xtype": "panel", "items": type976, "labelAlign": "top" }, { "flex": 44, "autoHeight": true, "layout": "form", "xtype": "panel", "items": invite_team_members977, "labelAlign": "top" }, { "flex": 11, "autoHeight": true, "layout": "form", "xtype": "panel", "items": color978, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 72, "border": false, "anchor": "-20", "labelAlign": "top" });
    var main_panel983 = new Ext.Panel({ "hideCheckBoxLabels": true, "autoHeight": true, "border": false, "layout": "form", "autoScroll": false, "items": [ main_1_panel972, main_2_panel979 ], "frame": true, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel983;
    this.before_row_edit = function(record) {
    }
    Lino.cal.PanelCalendars.InsertFormPanel.superclass.initComponent.call(this);
  }
});


Lino.notes.MyNotes.InsertFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  autoHeight: true,
  content_type: 94,
  initComponent : function() {
    var containing_panel = this;
    var event_type871 = new Lino.TwinCombo({ "fieldLabel": "Event Type (Form)", "name": "event_type", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.notes.EventTypes.detail)}, "emptyText": "Choisir Event Type...", "selectOnFocus": true, "hiddenName": "event_typeHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/notes/Notes/event_type", "method": "GET" }) }) });
    var type872 = new Lino.TwinCombo({ "fieldLabel": "Note Type (Content)", "name": "type", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.notes.NoteTypes.detail)}, "emptyText": "Choisir Type de note...", "selectOnFocus": true, "hiddenName": "typeHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/notes/Notes/type", "method": "GET" }) }) });
    var main_1_panel873 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": event_type871, "labelAlign": "top" }, { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": type872, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 180, "border": false, "anchor": "-20", "labelAlign": "top" });
    var subject876 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200, "fieldLabel": "Subject", "anchor": "-20", "name": "subject" });
    var project877 = new Lino.TwinCombo({ "fieldLabel": "Client", "name": "project", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.pcsw.Clients.detail)}, "emptyText": "Choisir Client...", "selectOnFocus": true, "hiddenName": "projectHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/notes/Notes/project", "method": "GET" }) }) });
    var company878 = new Lino.TwinCombo({ "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Organisation</span>", "name": "company", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.contacts.Companies.detail)}, "emptyText": "Choisir Organisation...", "listeners": { "render": Lino.quicktip_renderer("Organisation","    An optional third-party Organization that is related to this Note.\n    The note will then be visible in that company's history panel.\n    ") }, "selectOnFocus": true, "hiddenName": "companyHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/notes/Notes/company", "method": "GET" }) }) });
    var main_3_panel879 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": project877, "labelAlign": "top" }, { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": company878, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 117, "border": false, "anchor": "-20", "labelAlign": "top" });
    var main_panel882 = new Ext.Panel({ "hideCheckBoxLabels": true, "autoHeight": true, "border": false, "layout": "form", "labelWidth": 72, "autoScroll": false, "items": [ main_1_panel873, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": subject876, "anchor": "-20", "labelAlign": "top" }, main_3_panel879 ], "frame": true, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel882;
    this.before_row_edit = function(record) {
    }
    Lino.notes.MyNotes.InsertFormPanel.superclass.initComponent.call(this);
  }
});


Lino.cal.PanelCalendars.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 35,
  initComponent : function() {
    var containing_panel = this;
    var type899 = new Lino.ChoicesFieldElement({ "fieldLabel": "Type", "allowBlank": false, "value": "local", "hiddenName": "typeHidden", "selectOnFocus": true, "anchor": "-20", "store": [ [ "local", "Local Calendar" ], [ "google", "Google Calendar" ] ], "name": "type" });
    var name900 = new Ext.form.TextField({ "fieldLabel": "Description", "name": "name", "maxLength": 200, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var name_fr901 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200, "fieldLabel": "Description (fr)", "anchor": "-20", "name": "name_fr" });
    var name_nl902 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200, "fieldLabel": "Description (nl)", "anchor": "-20", "name": "name_nl" });
    var id903 = new Ext.form.NumberField({ "selectOnFocus": true, "fieldLabel": "ID", "anchor": "-20", "name": "id" });
    var main_1_panel904 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 153, "hideCheckBoxLabels": true, "items": [ { "flex": 22, "autoHeight": true, "layout": "form", "xtype": "panel", "items": type899, "labelAlign": "top" }, { "flex": 23, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name900, "labelAlign": "top" }, { "flex": 23, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_fr901, "labelAlign": "top" }, { "flex": 23, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_nl902, "labelAlign": "top" }, { "flex": 5, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id903, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var url_template910 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200, "fieldLabel": "URL template", "anchor": "-20", "name": "url_template" });
    var username911 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200, "fieldLabel": "Username", "anchor": "-20", "name": "username" });
    var password912 = new Ext.form.TextField({ "fieldLabel": "Password", "name": "password", "maxLength": 200, "selectOnFocus": true, "anchor": "-20", "inputType": "password" });
    var main_2_panel913 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 117, "hideCheckBoxLabels": true, "items": [ { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": url_template910, "labelAlign": "top" }, { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": username911, "labelAlign": "top" }, { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": password912, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var readonly917 = new Ext.form.Checkbox({ "boxLabel": "read-only", "hideLabel": true, "checked": false, "name": "readonly", "selectOnFocus": true, "anchor": "-20" });
    var invite_team_members918 = new Lino.RemoteComboFieldElement({ "fieldLabel": "Team", "name": "invite_team_members", "pageSize": 20, "emptyText": "Choisir Team...", "selectOnFocus": true, "hiddenName": "invite_team_membersHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/Calendars/invite_team_members", "method": "GET" }) }) });
    var color919 = new Ext.form.NumberField({ "fieldLabel": "Couleur", "name": "color", "selectOnFocus": true, "anchor": "-20", "value": 1, "allowBlank": false });
    var start_date920 = new Lino.DateField({ "selectOnFocus": true, "fieldLabel": "Date d\u00e9but", "anchor": "-20", "name": "start_date" });
    var main_3_panel921 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 99, "hideCheckBoxLabels": true, "items": [ { "flex": 23, "autoHeight": true, "layout": "form", "xtype": "panel", "items": readonly917, "labelAlign": "top" }, { "flex": 46, "autoHeight": true, "layout": "form", "xtype": "panel", "items": invite_team_members918, "labelAlign": "top" }, { "flex": 11, "autoHeight": true, "layout": "form", "xtype": "panel", "items": color919, "labelAlign": "top" }, { "flex": 18, "autoHeight": true, "layout": "form", "xtype": "panel", "items": start_date920, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var build_method926 = new Lino.ChoicesFieldElement({ "fieldLabel": "M\u00e9thode de construction", "name": "build_method", "selectOnFocus": true, "anchor": "-20", "store": [ [ "appyodt", "AppyOdtBuildMethod" ], [ "appypdf", "AppyPdfBuildMethod" ], [ "appyrtf", "AppyRtfBuildMethod" ], [ "latex", "LatexBuildMethod" ], [ "pisa", "PisaBuildMethod" ], [ "rtf", "RtfBuildMethod" ] ], "hiddenName": "build_methodHidden" });
    var template927 = new Lino.SimpleRemoteComboFieldElement({ "selectOnFocus": true, "fieldLabel": "Mod\u00e8le", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/Calendars/template", "method": "GET" }) }), "name": "template" });
    var email_template928 = new Lino.SimpleRemoteComboFieldElement({ "listeners": { "render": Lino.quicktip_renderer("Email template","The name of the file to be used as template \nwhen creating an email from a mailable of this type.\n") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Email template</span>", "name": "email_template", "selectOnFocus": true, "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/Calendars/email_template", "method": "GET" }) }) });
    var attach_to_email929 = new Ext.form.Checkbox({ "boxLabel": "Attach to email", "listeners": { "render": Lino.quicktip_renderer("Attach to email","Whether the printable file should be attached to the email\nwhen creating an email from a mailable of this type.\n") }, "hideLabel": true, "checked": false, "name": "attach_to_email", "selectOnFocus": true, "anchor": "-20" });
    var main_4_panel930 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 216, "hideCheckBoxLabels": true, "items": [ { "flex": 40, "autoHeight": true, "layout": "form", "xtype": "panel", "items": build_method926, "labelAlign": "top" }, { "flex": 20, "autoHeight": true, "layout": "form", "xtype": "panel", "items": template927, "labelAlign": "top" }, { "flex": 20, "autoHeight": true, "layout": "form", "xtype": "panel", "items": email_template928, "labelAlign": "top" }, { "flex": 20, "autoHeight": true, "layout": "form", "xtype": "panel", "items": attach_to_email929, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var main_panel968 = new Ext.Panel({ "autoScroll": false, "border": false, "layout": "vbox", "hideCheckBoxLabels": true, "items": [ main_1_panel904, main_2_panel913, main_3_panel921, main_4_panel930 ], "frame": true, "layoutConfig": { "align": "stretch" }, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel968;
    this.before_row_edit = function(record) {
      template927.setContextValue('build_method',record ? record.data['build_methodHidden'] : undefined);
    }
    this.onRender = function(ct, position) {
      build_method926.on('change',Lino.chooser_handler(template927,'build_method'));
      Lino.cal.PanelCalendars.DetailFormPanel.superclass.onRender.call(this, ct, position);
    }
    Lino.cal.PanelCalendars.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.cal.MyEvents.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 36,
  initComponent : function() {
    var containing_panel = this;
    var calendar82 = new Lino.TwinCombo({ "fieldLabel": "Calendrier", "name": "calendar", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.cal.Calendars.detail)}, "emptyText": "Choisir Calendrier...", "selectOnFocus": true, "hiddenName": "calendarHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/Events/calendar", "method": "GET" }) }) });
    var summary83 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200, "fieldLabel": "R\u00e9sum\u00e9", "anchor": "-20", "name": "summary" });
    var project84 = new Lino.TwinCombo({ "fieldLabel": "Client", "name": "project", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.pcsw.Clients.detail)}, "emptyText": "Choisir Client...", "selectOnFocus": true, "hiddenName": "projectHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/Events/project", "method": "GET" }) }) });
    var general_1_panel85 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 99, "hideCheckBoxLabels": true, "items": [ { "flex": 32, "autoHeight": true, "layout": "form", "xtype": "panel", "items": calendar82, "labelAlign": "top" }, { "flex": 34, "autoHeight": true, "layout": "form", "xtype": "panel", "items": summary83, "labelAlign": "top" }, { "flex": 32, "autoHeight": true, "layout": "form", "xtype": "panel", "items": project84, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var start_date89 = new Lino.DateField({ "selectOnFocus": true, "fieldLabel": "Date d\u00e9but", "anchor": "-20", "name": "start_date" });
    var start_time90 = new Lino.TimeField({ "selectOnFocus": true, "fieldLabel": "Heure de d\u00e9but", "anchor": "-20", "name": "start_time" });
    var start_panel91 = new Ext.Panel({ "flex": 25, "autoHeight": true, "layout": "hbox", "items": [ { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": start_date89, "labelAlign": "top" }, { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": start_time90, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "autoScroll": false, "hideCheckBoxLabels": true, "labelWidth": 135, "border": false, "labelAlign": "top" });
    var end_date94 = new Lino.DateField({ "selectOnFocus": true, "fieldLabel": "Date de fin", "anchor": "-20", "name": "end_date" });
    var end_time95 = new Lino.TimeField({ "selectOnFocus": true, "fieldLabel": "Heure de fin", "anchor": "-20", "name": "end_time" });
    var end_panel96 = new Ext.Panel({ "flex": 25, "autoHeight": true, "layout": "hbox", "items": [ { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": end_date94, "labelAlign": "top" }, { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": end_time95, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "autoScroll": false, "hideCheckBoxLabels": true, "labelWidth": 117, "border": false, "labelAlign": "top" });
    var user99 = new Lino.TwinCombo({ "fieldLabel": "Responsible user", "name": "user", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.users.Users.detail)}, "emptyText": "Choisir Utilisateur...", "selectOnFocus": true, "hiddenName": "userHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/Events/user", "method": "GET" }) }) });
    var assigned_to100 = new Lino.TwinCombo({ "fieldLabel": "Attribu\u00e9 \u00e0", "name": "assigned_to", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.users.Users.detail)}, "emptyText": "Choisir Utilisateur...", "selectOnFocus": true, "hiddenName": "assigned_toHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/Events/assigned_to", "method": "GET" }) }) });
    var general_2_panel101 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 153, "hideCheckBoxLabels": true, "items": [ start_panel91, end_panel96, { "flex": 24, "autoHeight": true, "layout": "form", "xtype": "panel", "items": user99, "labelAlign": "top" }, { "flex": 24, "autoHeight": true, "layout": "form", "xtype": "panel", "items": assigned_to100, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var place104 = new Lino.TwinCombo({ "fieldLabel": "Room", "name": "place", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.cal.Places.detail)}, "emptyText": "Choisir Room...", "selectOnFocus": true, "hiddenName": "placeHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/Events/place", "method": "GET" }) }) });
    var priority105 = new Lino.RemoteComboFieldElement({ "fieldLabel": "Priorit\u00e9", "name": "priority", "pageSize": 20, "emptyText": "Choisir Priorit\u00e9...", "selectOnFocus": true, "hiddenName": "priorityHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/Events/priority", "method": "GET" }) }) });
    var access_class106 = new Lino.ChoicesFieldElement({ "forceSelection": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Classe d'acc\u00e8s</span>", "name": "access_class", "hiddenName": "access_classHidden", "listeners": { "render": Lino.quicktip_renderer("Classe d'acc\u00e8s","Public, priv\u00e9 ou \"marquer occup\u00e9\".") }, "selectOnFocus": true, "anchor": "-20", "store": Lino.cal.AccessClasses });
    var transparent107 = new Ext.form.Checkbox({ "boxLabel": "non bloquant", "listeners": { "render": Lino.quicktip_renderer("non bloquant","Indique que ce rendez-vous n'emp\u00eache pas d'avoir d'autres rendez-vous en m\u00eame temps.") }, "hideLabel": true, "checked": false, "name": "transparent", "selectOnFocus": true, "anchor": "-20" });
    var general_3_panel108 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 135, "hideCheckBoxLabels": true, "items": [ { "flex": 23, "autoHeight": true, "layout": "form", "xtype": "panel", "items": place104, "labelAlign": "top" }, { "flex": 23, "autoHeight": true, "layout": "form", "xtype": "panel", "items": priority105, "labelAlign": "top" }, { "flex": 40, "autoHeight": true, "layout": "form", "xtype": "panel", "items": access_class106, "labelAlign": "top" }, { "flex": 11, "autoHeight": true, "layout": "form", "xtype": "panel", "items": transparent107, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var owner_disp113 = new Ext.form.DisplayField({ "disabled": true, "fieldLabel": "Contr\u00f4l\u00e9 par", "anchor": "-20", "name": "owner" });
    var workflow_buttons_disp114 = new Ext.form.DisplayField({ "disabled": true, "fieldLabel": "Arbeitsablauf", "name": "workflow_buttons", "anchor": "-20", "value": "<br/>", "always_enabled": true });
    var general_4_panel115 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 126, "hideCheckBoxLabels": true, "items": [ { "flex": 25, "autoHeight": true, "layout": "form", "xtype": "panel", "items": owner_disp113, "labelAlign": "top" }, { "flex": 75, "autoHeight": true, "layout": "form", "xtype": "panel", "items": workflow_buttons_disp114, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var description118 = new Lino.RichTextPanel({ "selectOnFocus": true, "flex": 33, "containing_panel": this, "name": "description", "title": "Description" });
    var GuestsByEvent_grid128 = new Lino.cal.GuestsByEvent.GridPanel({ "tools": [ Lino.show_in_own_window_button(Lino.cal.GuestsByEvent.grid) ], "containing_panel": this, "hide_top_toolbar": true, "master_panel": this, "flex": 66 });
    var general_5_panel129 = new Ext.Panel({ "flex": 45, "border": false, "layout": "hbox", "labelWidth": 0, "hideCheckBoxLabels": true, "items": [ description118, GuestsByEvent_grid128 ], "autoScroll": false, "layoutConfig": { "align": "stretch" }, "frame": false, "labelAlign": "top" });
    var general_panel130 = new Ext.Panel({ "layout": "vbox", "title": "G\u00e9n\u00e9ral", "items": [ general_1_panel85, general_2_panel101, general_3_panel108, general_4_panel115, general_5_panel129 ], "frame": true, "layoutConfig": { "align": "stretch" }, "hideCheckBoxLabels": true, "listeners": { "activate": Lino.on_tab_activate }, "autoScroll": false, "border": false, "bodyBorder": false, "labelAlign": "top" });
    var id131 = new Ext.form.NumberField({ "selectOnFocus": true, "fieldLabel": "ID", "anchor": "-20", "name": "id" });
    var created132 = new Ext.form.DisplayField({ "disabled": true, "fieldLabel": "Cr\u00e9\u00e9", "anchor": "-20", "value": "<br>", "name": "created" });
    var modified133 = new Ext.form.DisplayField({ "disabled": true, "fieldLabel": "Modified", "anchor": "-20", "value": "<br>", "name": "modified" });
    var more_1_panel134 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 81, "hideCheckBoxLabels": true, "items": [ { "flex": 11, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id131, "labelAlign": "top" }, { "flex": 44, "autoHeight": true, "layout": "form", "xtype": "panel", "items": created132, "labelAlign": "top" }, { "flex": 44, "autoHeight": true, "layout": "form", "xtype": "panel", "items": modified133, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var outbox_MailsByController_grid183 = new Lino.outbox.MailsByController.GridPanel({ "tools": [ Lino.show_in_own_window_button(Lino.outbox.MailsByController.grid) ], "containing_panel": this, "hide_top_toolbar": true, "master_panel": this, "flex": 50 });
    var postings_PostingsByController_grid194 = new Lino.postings.PostingsByController.GridPanel({ "tools": [ Lino.show_in_own_window_button(Lino.postings.PostingsByController.grid) ], "containing_panel": this, "hide_top_toolbar": true, "master_panel": this, "flex": 50 });
    var more_2_panel195 = new Ext.Panel({ "flex": 83, "border": false, "layout": "hbox", "hideCheckBoxLabels": true, "items": [ outbox_MailsByController_grid183, postings_PostingsByController_grid194 ], "autoScroll": false, "layoutConfig": { "align": "stretch" }, "frame": false, "labelAlign": "top" });
    var more_panel196 = new Ext.Panel({ "layout": "vbox", "title": "Plus", "items": [ more_1_panel134, more_2_panel195 ], "frame": true, "layoutConfig": { "align": "stretch" }, "hideCheckBoxLabels": true, "listeners": { "activate": Lino.on_tab_activate }, "autoScroll": false, "border": false, "bodyBorder": false, "labelAlign": "top" });
    var main_panel197 = new Ext.TabPanel({ "hideCheckBoxLabels": true, "border": false, "split": true, "autoScroll": false, "items": [ general_panel130, more_panel196 ], "activeTab": 0, "bodyBorder": false, "frame": true, "labelAlign": "top" });
    this.items = main_panel197;
    this.before_row_edit = function(record) {
      description118.refresh();
      GuestsByEvent_grid128.on_master_changed();
      outbox_MailsByController_grid183.on_master_changed();
      postings_PostingsByController_grid194.on_master_changed();
    }
    Lino.cal.MyEvents.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.notes.MyNotes.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 94,
  initComponent : function() {
    var containing_panel = this;
    var date834 = new Lino.DateField({ "selectOnFocus": true, "allowBlank": false, "fieldLabel": "Date", "anchor": "-20", "name": "date" });
    var event_type835 = new Lino.TwinCombo({ "fieldLabel": "Event Type (Form)", "name": "event_type", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.notes.EventTypes.detail)}, "emptyText": "Choisir Event Type...", "selectOnFocus": true, "hiddenName": "event_typeHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/notes/Notes/event_type", "method": "GET" }) }) });
    var type836 = new Lino.TwinCombo({ "fieldLabel": "Note Type (Content)", "name": "type", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.notes.NoteTypes.detail)}, "emptyText": "Choisir Type de note...", "selectOnFocus": true, "hiddenName": "typeHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/notes/Notes/type", "method": "GET" }) }) });
    var left_1_panel837 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 180, "hideCheckBoxLabels": true, "items": [ { "flex": 16, "autoHeight": true, "layout": "form", "xtype": "panel", "items": date834, "labelAlign": "top" }, { "flex": 41, "autoHeight": true, "layout": "form", "xtype": "panel", "items": event_type835, "labelAlign": "top" }, { "flex": 41, "autoHeight": true, "layout": "form", "xtype": "panel", "items": type836, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var subject841 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200, "fieldLabel": "Subject", "anchor": "-20", "name": "subject" });
    var project842 = new Lino.TwinCombo({ "fieldLabel": "Client", "name": "project", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.pcsw.Clients.detail)}, "emptyText": "Choisir Client...", "selectOnFocus": true, "hiddenName": "projectHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/notes/Notes/project", "method": "GET" }) }) });
    var company843 = new Lino.TwinCombo({ "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Organisation</span>", "name": "company", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.contacts.Companies.detail)}, "emptyText": "Choisir Organisation...", "listeners": { "render": Lino.quicktip_renderer("Organisation","    An optional third-party Organization that is related to this Note.\n    The note will then be visible in that company's history panel.\n    ") }, "selectOnFocus": true, "hiddenName": "companyHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/notes/Notes/company", "method": "GET" }) }) });
    var left_3_panel844 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 117, "hideCheckBoxLabels": true, "items": [ { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": project842, "labelAlign": "top" }, { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": company843, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var id847 = new Ext.form.NumberField({ "selectOnFocus": true, "fieldLabel": "ID", "anchor": "-20", "name": "id" });
    var user848 = new Lino.TwinCombo({ "fieldLabel": "Auteur", "name": "user", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.users.Users.detail)}, "emptyText": "Choisir Utilisateur...", "selectOnFocus": true, "hiddenName": "userHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/notes/Notes/user", "method": "GET" }) }) });
    var language849 = new Lino.ChoicesFieldElement({ "fieldLabel": "Langue", "allowBlank": false, "value": "de", "hiddenName": "languageHidden", "selectOnFocus": true, "anchor": "-20", "store": [ [ "de", "German" ], [ "fr", "French" ], [ "nl", "Dutch" ] ], "name": "language" });
    var build_time850 = new Ext.form.DisplayField({ "disabled": true, "fieldLabel": "build time", "anchor": "-20", "value": "<br>", "name": "build_time" });
    var left_4_panel851 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 99, "hideCheckBoxLabels": true, "items": [ { "flex": 12, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id847, "labelAlign": "top" }, { "flex": 25, "autoHeight": true, "layout": "form", "xtype": "panel", "items": user848, "labelAlign": "top" }, { "flex": 20, "autoHeight": true, "layout": "form", "xtype": "panel", "items": language849, "labelAlign": "top" }, { "flex": 41, "autoHeight": true, "layout": "form", "xtype": "panel", "items": build_time850, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var body856 = new Lino.RichTextPanel({ "selectOnFocus": true, "flex": 55, "containing_panel": this, "name": "body", "title": "Body" });
    var left_panel857 = new Ext.Panel({ "flex": 66, "layout": "vbox", "items": [ left_1_panel837, { "items": subject841, "autoHeight": true, "layout": "form", "xtype": "panel", "labelAlign": "top" }, left_3_panel844, left_4_panel851, body856 ], "frame": true, "layoutConfig": { "align": "stretch" }, "autoScroll": false, "hideCheckBoxLabels": true, "labelWidth": 72, "border": false, "bodyBorder": false, "labelAlign": "top" });
    var UploadsByController_htmlbox859 = new Lino.HtmlBoxPanel({ "flex": 16, "ls_bbar_actions": [ { "itemId": "insert", "menu_item_text": "Nouveau", "must_save": true, "tooltip": "Insert a new record", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-new", "overflowText": "Nouveau", "auto_save": true } ], "name": "UploadsByController", "containing_panel": this, "items": new Ext.BoxComponent({autoScroll:true}), "title": "Uploads", "master_panel": this, "value": "<br/>", "always_enabled": true, "bodyStyle": "overflow-x:hidden", "ls_insert_handler": Lino.uploads.UploadsByController.insert, "layout": "fit", "tools": [ Lino.show_in_own_window_button(Lino.uploads.UploadsByController.grid) ] });
    var outbox_MailsByController_grid860 = new Lino.outbox.MailsByController.GridPanel({ "tools": [ Lino.show_in_own_window_button(Lino.outbox.MailsByController.grid) ], "containing_panel": this, "hide_top_toolbar": true, "master_panel": this, "flex": 27 });
    var postings_PostingsByController_grid861 = new Lino.postings.PostingsByController.GridPanel({ "tools": [ Lino.show_in_own_window_button(Lino.postings.PostingsByController.grid) ], "containing_panel": this, "hide_top_toolbar": true, "master_panel": this, "flex": 27 });
    var cal_TasksByController_grid867 = new Lino.cal.TasksByController.GridPanel({ "tools": [ Lino.show_in_own_window_button(Lino.cal.TasksByController.grid) ], "containing_panel": this, "hide_top_toolbar": true, "master_panel": this, "flex": 27 });
    var right_panel868 = new Ext.Panel({ "flex": 33, "layout": "vbox", "items": [ UploadsByController_htmlbox859, outbox_MailsByController_grid860, postings_PostingsByController_grid861, cal_TasksByController_grid867 ], "frame": true, "layoutConfig": { "align": "stretch" }, "autoScroll": false, "hideCheckBoxLabels": true, "labelWidth": 72, "border": false, "bodyBorder": false, "labelAlign": "top" });
    var main_1_panel869 = new Ext.Panel({ "autoScroll": false, "border": false, "layout": "hbox", "hideCheckBoxLabels": true, "items": [ left_panel857, right_panel868 ], "frame": false, "layoutConfig": { "align": "stretch" }, "labelAlign": "top" });
    var main_panel870 = new Ext.Panel({ "autoScroll": false, "border": false, "layout": "fit", "hideCheckBoxLabels": true, "items": [ main_1_panel869 ], "frame": true, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel870;
    this.before_row_edit = function(record) {
      body856.refresh();
      UploadsByController_htmlbox859.refresh();
      outbox_MailsByController_grid860.on_master_changed();
      postings_PostingsByController_grid861.on_master_changed();
      cal_TasksByController_grid867.on_master_changed();
    }
    Lino.notes.MyNotes.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.cbss.IdentifyPersonRequests.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 93,
  initComponent : function() {
    var containing_panel = this;
    var id2245 = new Ext.form.NumberField({ "selectOnFocus": true, "fieldLabel": "ID", "anchor": "-20", "name": "id" });
    var person2246 = new Lino.TwinCombo({ "fieldLabel": "Client", "allowBlank": false, "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.pcsw.Clients.detail)}, "emptyText": "Choisir Client...", "selectOnFocus": true, "hiddenName": "personHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cbss/IdentifyPersonRequests/person", "method": "GET" }) }), "name": "person" });
    var user2247 = new Lino.TwinCombo({ "fieldLabel": "Auteur", "allowBlank": false, "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.users.Users.detail)}, "emptyText": "Choisir Utilisateur...", "selectOnFocus": true, "hiddenName": "userHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cbss/IdentifyPersonRequests/user", "method": "GET" }) }), "name": "user" });
    var environment2248 = new Ext.form.TextField({ "disabled": true, "fieldLabel": "T/A/B", "name": "environment", "maxLength": 4, "boxMinWidth": Lino.chars2width(4), "anchor": "-20" });
    var sent2249 = new Ext.form.DisplayField({ "disabled": true, "listeners": { "render": Lino.quicktip_renderer("Ex\u00e9cut\u00e9","The date and time when this request has been executed. \nThis is empty for requests than haven't been sent.\nRead-only.") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Ex\u00e9cut\u00e9</span>", "name": "sent", "anchor": "-20", "value": "<br>" });
    var status2250 = new Lino.ChoicesFieldElement({ "disabled": true, "forceSelection": true, "fieldLabel": "State", "name": "status", "anchor": "-20", "store": Lino.cbss.RequestStates, "hiddenName": "statusHidden" });
    var ticket2251 = new Ext.form.TextField({ "disabled": true, "maxLength": 36, "fieldLabel": "Ticket", "anchor": "-20", "name": "ticket" });
    var info_1_panel2252 = new Ext.form.FieldSet({ "autoHeight": true, "layout": "hbox", "title": "Information requ\u00eate", "layoutConfig": { "align": "stretchmax" }, "frame": false, "bodyBorder": true, "autoScroll": false, "items": [ { "flex": 5, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id2245, "labelAlign": "top" }, { "flex": 20, "autoHeight": true, "layout": "form", "xtype": "panel", "items": person2246, "labelAlign": "top" }, { "flex": 15, "autoHeight": true, "layout": "form", "xtype": "panel", "items": user2247, "labelAlign": "top" }, { "flex": 5, "autoHeight": true, "layout": "form", "xtype": "panel", "items": environment2248, "labelAlign": "top" }, { "flex": 16, "autoHeight": true, "layout": "form", "xtype": "panel", "items": sent2249, "labelAlign": "top" }, { "flex": 18, "autoHeight": true, "layout": "form", "xtype": "panel", "items": status2250, "labelAlign": "top" }, { "flex": 21, "autoHeight": true, "layout": "form", "xtype": "panel", "items": ticket2251, "labelAlign": "top" } ], "hideCheckBoxLabels": true, "labelWidth": 72, "border": false, "labelAlign": "top" });
    var national_id2260 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200, "fieldLabel": "NISS", "anchor": "-20", "name": "national_id" });
    var p1_panel2262 = new Ext.form.FieldSet({ "flex": 25, "layout": "vbox", "title": "avec NISS", "layoutConfig": { "align": "stretch" }, "frame": true, "bodyBorder": false, "autoScroll": false, "items": [ { "items": national_id2260, "autoHeight": true, "layout": "form", "xtype": "panel", "labelAlign": "top" }, { "flex": 50, "html": "<br/>", "xtype": "label" } ], "hideCheckBoxLabels": true, "labelWidth": 45, "border": false, "labelAlign": "top" });
    var first_name2264 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200, "fieldLabel": "Pr\u00e9nom", "anchor": "-20", "name": "first_name" });
    var middle_name2265 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Middle name","Whatever this means...") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Middle name</span>", "name": "middle_name", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var last_name2266 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200, "fieldLabel": "Nom de famille", "anchor": "-20", "name": "last_name" });
    var p2_1_panel2267 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": first_name2264, "labelAlign": "top" }, { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": middle_name2265, "labelAlign": "top" }, { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": last_name2266, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 135, "border": false, "anchor": "-20", "labelAlign": "top" });
    var birth_date2271 = new Lino.IncompleteDateField({ "listeners": { "render": Lino.quicktip_renderer("date de naissance","Unkomplette Datumsangaben sind erlaubt, z.B. \"00.00.1980\" hei\u00dft \"irgendwann im Jahr 1980\", \"00.07.1980\" hei\u00dft \"im Juli 1980\"oder \"23.07.0000\" hei\u00dft \"an einem 23. Juli\".") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">date de naissance</span>", "name": "birth_date", "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var tolerance2272 = new Ext.form.NumberField({ "listeners": { "render": Lino.quicktip_renderer("Tol\u00e9rance","\n      Falls Monat oder Tag des Geburtsdatums unbekannt sind, \n      um wieviel Monate bzw. Tage die Suche nach unten/oben ausgeweitet wird.\n      G\u00fcltige Werte: 0 bis 10.\n      ") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Tol\u00e9rance</span>", "name": "tolerance", "selectOnFocus": true, "anchor": "-20", "value": 0, "allowBlank": false });
    var gender2273 = new Lino.ChoicesFieldElement({ "forceSelection": true, "fieldLabel": "Sexe", "name": "gender", "selectOnFocus": true, "anchor": "-20", "store": Lino.lino.Genders, "hiddenName": "genderHidden" });
    var p2_2_panel2274 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 42, "autoHeight": true, "layout": "form", "xtype": "panel", "items": birth_date2271, "labelAlign": "top" }, { "flex": 17, "autoHeight": true, "layout": "form", "xtype": "panel", "items": tolerance2272, "labelAlign": "top" }, { "flex": 39, "autoHeight": true, "layout": "form", "xtype": "panel", "items": gender2273, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 162, "border": false, "anchor": "-20", "labelAlign": "top" });
    var p2_panel2278 = new Ext.form.FieldSet({ "flex": 75, "autoHeight": true, "layout": "form", "title": "Recherche phon\u00e9tique", "items": [ p2_1_panel2267, p2_2_panel2274 ], "frame": true, "bodyBorder": false, "autoScroll": false, "hideCheckBoxLabels": true, "border": false, "labelAlign": "top" });
    var parameters_panel2279 = new Ext.form.FieldSet({ "autoHeight": true, "layout": "hbox", "title": "Param\u00e8tres", "layoutConfig": { "align": "stretchmax" }, "frame": false, "bodyBorder": true, "autoScroll": false, "items": [ p1_panel2262, p2_panel2278 ], "hideCheckBoxLabels": true, "border": false, "labelAlign": "top" });
    var IdentifyPersonResult_grid2289 = new Lino.cbss.IdentifyPersonResult.GridPanel({ "tools": [ Lino.show_in_own_window_button(Lino.cbss.IdentifyPersonResult.grid) ], "containing_panel": this, "hide_top_toolbar": true, "master_panel": this, "flex": 62 });
    var request_panel2290 = new Ext.Panel({ "layout": "vbox", "title": "Requ\u00eate", "items": [ info_1_panel2252, parameters_panel2279, IdentifyPersonResult_grid2289 ], "frame": true, "layoutConfig": { "align": "stretch" }, "hideCheckBoxLabels": true, "listeners": { "activate": Lino.on_tab_activate }, "autoScroll": false, "border": false, "bodyBorder": false, "labelAlign": "top" });
    var response_xml2291 = new Ext.form.TextArea({ "disabled": true, "listeners": { "render": Lino.quicktip_renderer("R\u00e9ponse","The raw XML response received. \n") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">R\u00e9ponse</span>", "name": "response_xml", "growMax": 2000, "anchor": "-20 -10" });
    var info_messages2292 = new Ext.form.TextArea({ "disabled": true, "fieldLabel": "Messages info", "anchor": "-20 -10", "growMax": 2000, "name": "info_messages" });
    var debug_messages2293 = new Ext.form.TextArea({ "disabled": true, "fieldLabel": "Messages debug", "anchor": "-20 -10", "growMax": 2000, "name": "debug_messages" });
    var technical_panel2294 = new Lino.VBorderPanel({ "autoScroll": false, "listeners": { "activate": Lino.on_tab_activate }, "border": false, "labelWidth": 135, "title": "Technique", "hideCheckBoxLabels": true, "items": [ { "flex": 5, "layout": "form", "xtype": "panel", "items": response_xml2291, "region": "north", "labelAlign": "top", "split": true }, { "flex": 5, "layout": "form", "xtype": "panel", "items": info_messages2292, "region": "center", "labelAlign": "top", "split": true }, { "flex": 5, "layout": "form", "xtype": "panel", "items": debug_messages2293, "region": "south", "labelAlign": "top", "split": true } ], "frame": true, "bodyBorder": false, "labelAlign": "top" });
    var main_panel2298 = new Ext.TabPanel({ "hideCheckBoxLabels": true, "border": false, "split": true, "autoScroll": false, "items": [ request_panel2290, technical_panel2294 ], "activeTab": 0, "bodyBorder": false, "frame": true, "labelAlign": "top" });
    this.items = main_panel2298;
    this.before_row_edit = function(record) {
      IdentifyPersonResult_grid2289.on_master_changed();
    }
    Lino.cbss.IdentifyPersonRequests.DetailFormPanel.superclass.initComponent.call(this);
    // active_fields:
    person2246.on("change",function(){this.save()},this);
  }
});


Lino.isip.Contracts.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 60,
  initComponent : function() {
    var containing_panel = this;
    var id1501 = new Ext.form.NumberField({ "selectOnFocus": true, "fieldLabel": "ID", "anchor": "-20", "name": "id" });
    var client1502 = new Lino.TwinCombo({ "fieldLabel": "Client", "allowBlank": false, "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.pcsw.Clients.detail)}, "emptyText": "Choisir Client...", "selectOnFocus": true, "hiddenName": "clientHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/isip/Contracts/client", "method": "GET" }) }), "name": "client" });
    var type1503 = new Lino.TwinCombo({ "fieldLabel": "Type de contrat", "name": "type", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.isip.ContractTypes.detail)}, "emptyText": "Choisir Type de PIIS...", "selectOnFocus": true, "hiddenName": "typeHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/isip/Contracts/type", "method": "GET" }) }) });
    var user1504 = new Lino.TwinCombo({ "fieldLabel": "Auteur", "name": "user", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.users.Users.detail)}, "emptyText": "Choisir Utilisateur...", "selectOnFocus": true, "hiddenName": "userHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/isip/Contracts/user", "method": "GET" }) }) });
    var user_asd1505 = new Lino.TwinCombo({ "fieldLabel": "Responsable (SSG)", "name": "user_asd", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.users.Users.detail)}, "emptyText": "Choisir Utilisateur...", "selectOnFocus": true, "hiddenName": "user_asdHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/isip/Contracts/user_asd", "method": "GET" }) }) });
    var general_1_panel1506 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 162, "hideCheckBoxLabels": true, "items": [ { "flex": 9, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id1501, "labelAlign": "top" }, { "flex": 30, "autoHeight": true, "layout": "form", "xtype": "panel", "items": client1502, "labelAlign": "top" }, { "flex": 24, "autoHeight": true, "layout": "form", "xtype": "panel", "items": type1503, "labelAlign": "top" }, { "flex": 18, "autoHeight": true, "layout": "form", "xtype": "panel", "items": user1504, "labelAlign": "top" }, { "flex": 18, "autoHeight": true, "layout": "form", "xtype": "panel", "items": user_asd1505, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var study_type1512 = new Lino.TwinCombo({ "fieldLabel": "Type d'\u00e9tude", "name": "study_type", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.isip.StudyTypes.detail)}, "emptyText": "Choisir Type d'\u00e9tude...", "selectOnFocus": true, "hiddenName": "study_typeHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/isip/Contracts/study_type", "method": "GET" }) }) });
    var company1513 = new Lino.TwinCombo({ "fieldLabel": "Organisation", "name": "company", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.contacts.Companies.detail)}, "emptyText": "Choisir Organisation...", "selectOnFocus": true, "hiddenName": "companyHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/isip/Contracts/company", "method": "GET" }) }) });
    var contact_person1514 = new Lino.TwinCombo({ "fieldLabel": "repr\u00e9sent\u00e9 par", "name": "contact_person", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.contacts.Persons.detail)}, "emptyText": "Choisir Personne...", "selectOnFocus": true, "hiddenName": "contact_personHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/isip/Contracts/contact_person", "method": "GET" }) }) });
    var contact_role1515 = new Lino.RemoteComboFieldElement({ "fieldLabel": "repr\u00e9sent\u00e9 par", "name": "contact_role", "pageSize": 20, "emptyText": "Choisir Fonction...", "selectOnFocus": true, "hiddenName": "contact_roleHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/isip/Contracts/contact_role", "method": "GET" }) }) });
    var general_2_panel1516 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 135, "hideCheckBoxLabels": true, "items": [ { "flex": 25, "autoHeight": true, "layout": "form", "xtype": "panel", "items": study_type1512, "labelAlign": "top" }, { "flex": 25, "autoHeight": true, "layout": "form", "xtype": "panel", "items": company1513, "labelAlign": "top" }, { "flex": 25, "autoHeight": true, "layout": "form", "xtype": "panel", "items": contact_person1514, "labelAlign": "top" }, { "flex": 25, "autoHeight": true, "layout": "form", "xtype": "panel", "items": contact_role1515, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var applies_from1521 = new Lino.DateField({ "selectOnFocus": true, "fieldLabel": "D\u00e9but de contrat", "anchor": "-20", "name": "applies_from" });
    var applies_until1522 = new Lino.DateField({ "selectOnFocus": true, "fieldLabel": "Fin pr\u00e9vue", "anchor": "-20", "name": "applies_until" });
    var exam_policy1523 = new Lino.TwinCombo({ "fieldLabel": "M\u00e9thode d'examination", "name": "exam_policy", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.isip.ExamPolicies.detail)}, "emptyText": "Choisir M\u00e9thode d'examination...", "selectOnFocus": true, "hiddenName": "exam_policyHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/isip/Contracts/exam_policy", "method": "GET" }) }) });
    var language1524 = new Lino.ChoicesFieldElement({ "fieldLabel": "Langue", "allowBlank": false, "value": "de", "hiddenName": "languageHidden", "selectOnFocus": true, "anchor": "-20", "store": [ [ "de", "German" ], [ "fr", "French" ], [ "nl", "Dutch" ] ], "name": "language" });
    var general_3_panel1525 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 198, "hideCheckBoxLabels": true, "items": [ { "flex": 18, "autoHeight": true, "layout": "form", "xtype": "panel", "items": applies_from1521, "labelAlign": "top" }, { "flex": 18, "autoHeight": true, "layout": "form", "xtype": "panel", "items": applies_until1522, "labelAlign": "top" }, { "flex": 45, "autoHeight": true, "layout": "form", "xtype": "panel", "items": exam_policy1523, "labelAlign": "top" }, { "flex": 18, "autoHeight": true, "layout": "form", "xtype": "panel", "items": language1524, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var date_decided1530 = new Lino.DateField({ "selectOnFocus": true, "fieldLabel": "D\u00e9cid\u00e9 le", "anchor": "-20", "name": "date_decided" });
    var date_issued1531 = new Lino.DateField({ "selectOnFocus": true, "fieldLabel": "D\u00e9livr\u00e9 le", "anchor": "-20", "name": "date_issued" });
    var date_ended1532 = new Lino.DateField({ "selectOnFocus": true, "fieldLabel": "Date de fin", "anchor": "-20", "name": "date_ended" });
    var ending1533 = new Lino.TwinCombo({ "fieldLabel": "Cause d'abandon", "name": "ending", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.isip.ContractEndings.detail)}, "emptyText": "Choisir Cause d'abandon...", "selectOnFocus": true, "hiddenName": "endingHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/isip/Contracts/ending", "method": "GET" }) }) });
    var general_4_panel1534 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 144, "hideCheckBoxLabels": true, "items": [ { "flex": 18, "autoHeight": true, "layout": "form", "xtype": "panel", "items": date_decided1530, "labelAlign": "top" }, { "flex": 18, "autoHeight": true, "layout": "form", "xtype": "panel", "items": date_issued1531, "labelAlign": "top" }, { "flex": 18, "autoHeight": true, "layout": "form", "xtype": "panel", "items": date_ended1532, "labelAlign": "top" }, { "flex": 45, "autoHeight": true, "layout": "form", "xtype": "panel", "items": ending1533, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var cal_TasksByController_grid1539 = new Lino.cal.TasksByController.GridPanel({ "tools": [ Lino.show_in_own_window_button(Lino.cal.TasksByController.grid) ], "containing_panel": this, "hide_top_toolbar": true, "master_panel": this, "flex": 47 });
    var cal_EventsByController_grid1546 = new Lino.cal.EventsByController.GridPanel({ "flex": 52, "hide_top_toolbar": true, "containing_panel": this, "params_panel_hidden": true, "tools": [ Lino.show_in_own_window_button(Lino.cal.EventsByController.grid) ], "master_panel": this });
    var general_5_panel1547 = new Ext.Panel({ "flex": 55, "border": false, "layout": "hbox", "hideCheckBoxLabels": true, "items": [ cal_TasksByController_grid1539, cal_EventsByController_grid1546 ], "autoScroll": false, "layoutConfig": { "align": "stretch" }, "frame": false, "labelAlign": "top" });
    var general_panel1548 = new Ext.Panel({ "layout": "vbox", "title": "G\u00e9n\u00e9ral", "items": [ general_1_panel1506, general_2_panel1516, general_3_panel1525, general_4_panel1534, general_5_panel1547 ], "frame": true, "layoutConfig": { "align": "stretch" }, "hideCheckBoxLabels": true, "listeners": { "activate": Lino.on_tab_activate }, "autoScroll": false, "border": false, "bodyBorder": false, "labelAlign": "top" });
    var stages1549 = new Lino.RichTextPanel({ "selectOnFocus": true, "flex": 50, "containing_panel": this, "name": "stages", "title": "stages" });
    var goals1550 = new Lino.RichTextPanel({ "selectOnFocus": true, "flex": 50, "containing_panel": this, "name": "goals", "title": "buts" });
    var isip_1_panel1551 = new Ext.Panel({ "flex": 5, "layout": "hbox", "items": [ stages1549, goals1550 ], "region": "north", "layoutConfig": { "align": "stretch" }, "hideCheckBoxLabels": true, "split": true, "autoScroll": false, "labelWidth": 0, "border": false, "frame": false, "labelAlign": "top" });
    var duties_asd1552 = new Lino.RichTextPanel({ "selectOnFocus": true, "flex": 50, "containing_panel": this, "name": "duties_asd", "title": "devoirs SSG" });
    var duties_dsbe1553 = new Lino.RichTextPanel({ "selectOnFocus": true, "flex": 50, "containing_panel": this, "name": "duties_dsbe", "title": "devois ISP" });
    var isip_2_panel1554 = new Ext.Panel({ "flex": 5, "layout": "hbox", "items": [ duties_asd1552, duties_dsbe1553 ], "region": "center", "layoutConfig": { "align": "stretch" }, "hideCheckBoxLabels": true, "split": true, "autoScroll": false, "labelWidth": 0, "border": false, "frame": false, "labelAlign": "top" });
    var duties_company1555 = new Lino.RichTextPanel({ "selectOnFocus": true, "flex": 50, "containing_panel": this, "name": "duties_company", "title": "devoirs entreprise" });
    var duties_person1556 = new Lino.RichTextPanel({ "selectOnFocus": true, "flex": 50, "containing_panel": this, "name": "duties_person", "title": "Devoirs personne" });
    var isip_3_panel1557 = new Ext.Panel({ "flex": 5, "layout": "hbox", "items": [ duties_company1555, duties_person1556 ], "region": "south", "layoutConfig": { "align": "stretch" }, "hideCheckBoxLabels": true, "split": true, "autoScroll": false, "labelWidth": 0, "border": false, "frame": false, "labelAlign": "top" });
    var isip_panel1558 = new Lino.VBorderPanel({ "autoScroll": false, "listeners": { "activate": Lino.on_tab_activate }, "border": false, "title": "PIIS", "hideCheckBoxLabels": true, "items": [ isip_1_panel1551, isip_2_panel1554, isip_3_panel1557 ], "frame": true, "bodyBorder": false, "labelAlign": "top" });
    var main_panel1559 = new Ext.TabPanel({ "hideCheckBoxLabels": true, "border": false, "split": true, "autoScroll": false, "items": [ general_panel1548, isip_panel1558 ], "activeTab": 0, "bodyBorder": false, "frame": true, "labelAlign": "top" });
    this.items = main_panel1559;
    this.before_row_edit = function(record) {
      contact_person1514.setContextValue('company',record ? record.data['companyHidden'] : undefined);
      cal_TasksByController_grid1539.on_master_changed();
      cal_EventsByController_grid1546.on_master_changed();
      stages1549.refresh();
      goals1550.refresh();
      duties_asd1552.refresh();
      duties_dsbe1553.refresh();
      duties_company1555.refresh();
      duties_person1556.refresh();
    }
    this.onRender = function(ct, position) {
      company1513.on('change',Lino.chooser_handler(contact_person1514,'company'));
      Lino.isip.Contracts.DetailFormPanel.superclass.onRender.call(this, ct, position);
    }
    Lino.isip.Contracts.DetailFormPanel.superclass.initComponent.call(this);
    // active_fields:
    company1513.on("change",function(){this.save()},this);
  }
});


Lino.isip.Contracts.InsertFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  autoHeight: true,
  content_type: 60,
  initComponent : function() {
    var containing_panel = this;
    var client1560 = new Lino.TwinCombo({ "fieldLabel": "Client", "allowBlank": false, "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.pcsw.Clients.detail)}, "emptyText": "Choisir Client...", "selectOnFocus": true, "hiddenName": "clientHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/isip/Contracts/client", "method": "GET" }) }), "name": "client" });
    var type1561 = new Lino.TwinCombo({ "fieldLabel": "Type de contrat", "name": "type", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.isip.ContractTypes.detail)}, "emptyText": "Choisir Type de PIIS...", "selectOnFocus": true, "hiddenName": "typeHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/isip/Contracts/type", "method": "GET" }) }) });
    var company1562 = new Lino.TwinCombo({ "fieldLabel": "Organisation", "name": "company", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.contacts.Companies.detail)}, "emptyText": "Choisir Organisation...", "selectOnFocus": true, "hiddenName": "companyHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/isip/Contracts/company", "method": "GET" }) }) });
    var main_2_panel1563 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": type1561, "labelAlign": "top" }, { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": company1562, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 144, "border": false, "anchor": "-20", "labelAlign": "top" });
    var main_panel1566 = new Ext.Panel({ "hideCheckBoxLabels": true, "autoHeight": true, "border": false, "layout": "form", "labelWidth": 63, "autoScroll": false, "items": [ { "autoHeight": true, "layout": "form", "xtype": "panel", "items": client1560, "anchor": "-20", "labelAlign": "top" }, main_2_panel1563 ], "frame": true, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel1566;
    this.before_row_edit = function(record) {
    }
    Lino.isip.Contracts.InsertFormPanel.superclass.initComponent.call(this);
    // active_fields:
    company1562.on("change",function(){this.save()},this);
  }
});


Lino.users.MySettings.InsertFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  autoHeight: true,
  content_type: 7,
  initComponent : function() {
    var containing_panel = this;
    var username365 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Username","\n        Required. Must be unique. \n        ") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Username</span>", "name": "username", "maxLength": 30, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var email366 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 75, "fieldLabel": "adresse e-mail", "anchor": "-20", "name": "email" });
    var main_1_panel367 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": username365, "labelAlign": "top" }, { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": email366, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 135, "border": false, "anchor": "-20", "labelAlign": "top" });
    var first_name370 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 30, "fieldLabel": "Pr\u00e9nom", "anchor": "-20", "name": "first_name" });
    var last_name371 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 30, "fieldLabel": "Nom de famille", "anchor": "-20", "name": "last_name" });
    var main_2_panel372 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": first_name370, "labelAlign": "top" }, { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": last_name371, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 135, "border": false, "anchor": "-20", "labelAlign": "top" });
    var partner375 = new Lino.TwinCombo({ "fieldLabel": "Partenaire", "name": "partner", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.contacts.Partners.detail)}, "emptyText": "Choisir Partenaire...", "selectOnFocus": true, "hiddenName": "partnerHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/users/Users/partner", "method": "GET" }) }) });
    var language376 = new Lino.ChoicesFieldElement({ "fieldLabel": "Langue", "allowBlank": false, "selectOnFocus": true, "hiddenName": "languageHidden", "anchor": "-20", "store": [ [ "de", "German" ], [ "fr", "French" ], [ "nl", "Dutch" ] ], "name": "language" });
    var profile377 = new Lino.ChoicesFieldElement({ "forceSelection": true, "fieldLabel": "User Profile", "name": "profile", "selectOnFocus": true, "anchor": "-20", "store": Lino.lino.UserProfiles, "hiddenName": "profileHidden" });
    var main_4_panel378 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 32, "autoHeight": true, "layout": "form", "xtype": "panel", "items": language376, "labelAlign": "top" }, { "flex": 67, "autoHeight": true, "layout": "form", "xtype": "panel", "items": profile377, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 117, "border": false, "anchor": "-20", "labelAlign": "top" });
    var main_panel381 = new Ext.Panel({ "hideCheckBoxLabels": true, "autoHeight": true, "border": false, "layout": "form", "labelWidth": 99, "autoScroll": false, "items": [ main_1_panel367, main_2_panel372, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": partner375, "anchor": "-20", "labelAlign": "top" }, main_4_panel378 ], "frame": true, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel381;
    this.before_row_edit = function(record) {
    }
    Lino.users.MySettings.InsertFormPanel.superclass.initComponent.call(this);
  }
});

Lino.contacts.Companies.merge_row = new Lino.WindowAction({ "draggable": true, "width": Lino.chars2width(50), "autoHeight": true, "maximizable": true, "modal": true, "maximized": false },function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.contacts.Companies.merge_row_ActionFormPanel({});
});
Lino.pcsw.ClientStates.wf2 = new Lino.WindowAction({ "draggable": true, "width": Lino.chars2width(50), "maximizable": true, "modal": true, "maximized": false, "height": Lino.rows2height(15) },function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.pcsw.Clients.wf2_ActionFormPanel({});
});
Lino.pcsw.Clients.merge_row = new Lino.WindowAction({ "draggable": true, "width": Lino.chars2width(70), "autoHeight": true, "maximizable": true, "modal": true, "maximized": false },function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.pcsw.Clients.merge_row_ActionFormPanel({});
});
Lino.cal.GuestStates.wf2 = new Lino.WindowAction({ "draggable": true, "width": Lino.chars2width(50), "maximizable": true, "modal": true, "maximized": false, "height": Lino.rows2height(15) },function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.cal.GuestsByEvent.wf2_ActionFormPanel({});
});

// js_render_GridPanel_class users.MySettings
Lino.users.MySettings.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "No data to display." },
  ls_url : "/users/MySettings",
  ls_bbar_actions : [ { "itemId": "put", "menu_item_text": "Enregistrer", "tooltip": "Save changes in this form", "panel_btn_handler": function(panel){panel.save(null,false,'put')}, "iconCls": "x-tbar-save", "overflowText": "Enregistrer", "auto_save": false }, { "itemId": "update_reminders", "menu_item_text": "Update Reminders", "must_save": true, "panel_btn_handler": Lino.row_action_handler('update_reminders','GET'), "text": "Update Reminders", "overflowText": "Update Reminders", "auto_save": true } ],
  title : "Utilisateurs",
  page_length : 20,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "name": "username" }, { "name": "profile" }, 'profileHidden', { "name": "first_name" }, { "name": "last_name" }, { "type": "int", "name": "id" }, { "name": "created" }, { "name": "modified" }, { "name": "password" }, { "name": "email" }, { "name": "remarks" }, { "name": "language" }, 'languageHidden', { "name": "partner" }, 'partnerHidden', { "name": "access_class" }, 'access_classHidden', { "name": "calendar" }, 'calendarHidden', { "name": "coaching_type" }, 'coaching_typeHidden', { "type": "boolean", "name": "coaching_supervisor" }, { "type": "int", "name": "newcomer_quota" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 5,
  ls_grid_configs : [  ],
  content_type : 7,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 24,
  initComponent : function() {
    this.ls_detail_handler = Lino.users.MySettings.detail;
    this.ls_insert_handler = Lino.users.Users.insert;
    var ww = this.containing_window;
    var username2557 = new Ext.form.TextField({ "selectOnFocus": true, "allowBlank": false, "maxLength": 30 });
    var profile2558 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "forceSelection": true, "store": Lino.lino.UserProfiles });
    var first_name2559 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 30 });
    var last_name2560 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 30 });
    var id2561 = new Ext.form.NumberField({ "selectOnFocus": true });
    var created2562 = new Ext.form.DisplayField({ "disabled": true, "value": "<br>" });
    var modified2563 = new Ext.form.DisplayField({ "disabled": true, "value": "<br>" });
    var password2564 = new Ext.form.TextField({ "selectOnFocus": true, "allowBlank": false, "maxLength": 128 });
    var email2565 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 75 });
    var remarks2566 = new Ext.form.TextArea({ "selectOnFocus": true, "growMax": 2000 });
    var language2567 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "allowBlank": false, "store": [ [ "de", "German" ], [ "fr", "French" ], [ "nl", "Dutch" ] ] });
    var partner2568 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/users/MySettings/partner", "method": "GET" }) }), "pageSize": 20, "emptyText": "Choisir Partenaire..." });
    var access_class2569 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "forceSelection": true, "allowBlank": false, "store": Lino.cal.AccessClasses });
    var calendar2570 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/users/MySettings/calendar", "method": "GET" }) }), "pageSize": 20, "emptyText": "Choisir Calendrier..." });
    var coaching_type2571 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/users/MySettings/coaching_type", "method": "GET" }) }), "pageSize": 20, "emptyText": "Choisir Service..." });
    var coaching_supervisor2572 = new Ext.form.Checkbox({ "selectOnFocus": true, "checked": false });
    var newcomer_quota2573 = new Ext.form.NumberField({ "selectOnFocus": true, "allowBlank": false, "value": 0 });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ { "colIndex": 0, "sortable": true, "header": "Username", "editable": true, "tooltip": "\n        Required. Must be unique. \n        ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "username", "editor": username2557 }, { "colIndex": 1, "sortable": true, "header": "User Profile", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(42), "dataIndex": "profile", "editor": profile2558 }, { "colIndex": 2, "sortable": true, "header": "Pr\u00e9nom", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "first_name", "editor": first_name2559 }, { "colIndex": 3, "sortable": true, "header": "Nom de famille", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "last_name", "editor": last_name2560 }, new Lino.NullNumberColumn({ "colIndex": 4, "sortable": true, "format": "0", "editable": true, "filter": { "type": "numeric" }, "header": "ID", "renderer": Lino.id_renderer, "editor": id2561, "width": Lino.chars2width(6), "dataIndex": "id" }), { "width": Lino.chars2width(17), "colIndex": 5, "sortable": true, "dataIndex": "created", "header": "Cr\u00e9\u00e9", "editable": false }, { "width": Lino.chars2width(17), "colIndex": 6, "sortable": true, "dataIndex": "modified", "header": "Modified", "editable": false }, { "colIndex": 7, "sortable": true, "header": "Password", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "password", "hidden": true, "editor": password2564 }, { "colIndex": 8, "sortable": true, "header": "adresse e-mail", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "email", "editor": email2565 }, { "colIndex": 9, "sortable": false, "header": "Remarques", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(61), "renderer": Lino.text_renderer, "hidden": true, "editor": remarks2566, "dataIndex": "remarks" }, { "colIndex": 10, "sortable": true, "header": "Langue", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "language", "editor": language2567 }, { "colIndex": 11, "sortable": true, "header": "Partenaire", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('partnerHidden','Lino.contacts.Partners.detail'), "editor": partner2568, "dataIndex": "partner" }, { "colIndex": 12, "sortable": true, "header": "Classe d'acc\u00e8s par d\u00e9faut", "editable": true, "tooltip": "The default access class for your calendar events and tasks.", "filter": { "type": "string" }, "width": Lino.chars2width(35), "dataIndex": "access_class", "editor": access_class2569 }, { "colIndex": 13, "sortable": true, "header": "Calendrier par d\u00e9faut", "editable": true, "tooltip": "Le calendrier par d\u00e9faut pour vos rendez-vous et t\u00e2ches.", "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "calendar", "editor": calendar2570 }, { "colIndex": 14, "sortable": true, "header": "Service", "editable": true, "tooltip": "The default CoachingType used when creating Coachings.", "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "coaching_type", "editor": coaching_type2571 }, { "colIndex": 15, "sortable": false, "xtype": "checkcolumn", "header": "Notify me when a coach has been assigned", "editable": true, "tooltip": "Wenn ein Neuantrag einem Begleiter zugewiesen wurde, wird au\u00dfer dem Begleiter auch dieser Benutzer benachrichtigt.", "filter": { "type": "boolean" }, "width": Lino.chars2width(11), "dataIndex": "coaching_supervisor" }, new Lino.NullNumberColumn({ "colIndex": 16, "sortable": true, "format": "0", "editable": true, "tooltip": "Wieviel Arbeitszeit dieser Benutzer f\u00fcr Neuantr\u00e4ge zur Verf\u00fcgung steht\n(100 = ganztags, 50 = halbtags, 0 = gar nicht).\nWenn zwei Benutzer die gleiche Belastungspunktzahl haben, \naber einer davon sich nur zu 50% um Neuantr\u00e4ge k\u00fcmmert, \ngilt er als doppelt so belastet wie sein Kollege.\n", "filter": { "type": "numeric" }, "header": "Quota nouvelles demandes", "dataIndex": "newcomer_quota", "width": Lino.chars2width(6), "editor": newcomer_quota2573 }) ];
    Lino.users.MySettings.GridPanel.superclass.initComponent.call(this);
  }
});


Lino.users.MySettings.detailPanel = Ext.extend(Lino.users.MySettings.DetailFormPanel,{
  empty_title: "Utilisateurs",
  ls_bbar_actions: [ { "itemId": "put", "menu_item_text": "Enregistrer", "tooltip": "Save changes in this form", "panel_btn_handler": function(panel){panel.save(null,false,'put')}, "iconCls": "x-tbar-save", "overflowText": "Enregistrer", "auto_save": false }, { "itemId": "update_reminders", "menu_item_text": "Update Reminders", "must_save": true, "panel_btn_handler": Lino.row_action_handler('update_reminders','GET'), "text": "Update Reminders", "overflowText": "Update Reminders", "auto_save": true } ],
  ls_url: "/users/MySettings",
  initComponent : function() {
    this.ls_detail_handler = Lino.users.MySettings.detail;
    this.ls_insert_handler = Lino.users.Users.insert;
    Lino.users.MySettings.detailPanel.superclass.initComponent.call(this);
  }
});

Lino.users.MySettings.detail = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.users.MySettings.detailPanel(p);
});

Lino.users.MySettings.detailPanel = Ext.extend(Lino.users.MySettings.DetailFormPanel,{
  empty_title: "Utilisateurs",
  ls_bbar_actions: [ { "itemId": "put", "menu_item_text": "Enregistrer", "tooltip": "Save changes in this form", "panel_btn_handler": function(panel){panel.save(null,false,'put')}, "iconCls": "x-tbar-save", "overflowText": "Enregistrer", "auto_save": false }, { "itemId": "update_reminders", "menu_item_text": "Update Reminders", "must_save": true, "panel_btn_handler": Lino.row_action_handler('update_reminders','GET'), "text": "Update Reminders", "overflowText": "Update Reminders", "auto_save": true } ],
  ls_url: "/users/MySettings",
  initComponent : function() {
    this.ls_detail_handler = Lino.users.MySettings.detail;
    this.ls_insert_handler = Lino.users.Users.insert;
    Lino.users.MySettings.detailPanel.superclass.initComponent.call(this);
  }
});

Lino.users.MySettings.detail = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.users.MySettings.detailPanel(p);
});

// js_render_GridPanel_class countries.Languages
Lino.countries.Languages.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "No data to display." },
  ls_url : "/countries/Languages",
  ls_bbar_actions : [ { "itemId": "insert", "menu_item_text": "Nouveau", "must_save": true, "tooltip": "Insert a new record", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-new", "overflowText": "Nouveau", "auto_save": true }, { "itemId": "detail", "menu_item_text": "D\u00e9tail", "tooltip": "Open a detail window on this record", "panel_btn_handler": Lino.show_detail, "iconCls": "x-tbar-detail", "overflowText": "D\u00e9tail", "auto_save": true }, { "itemId": null, "menu_item_text": "Supprimer", "tooltip": "Delete this record", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "Supprimer", "auto_save": false } ],
  title : "Langues",
  page_length : 20,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "name": "name" }, { "name": "name_fr" }, { "name": "name_nl" }, { "name": "id" }, { "name": "iso2" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 3,
  ls_grid_configs : [  ],
  content_type : 12,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 6,
  initComponent : function() {
    this.ls_detail_handler = Lino.countries.Languages.detail;
    this.ls_insert_handler = Lino.countries.Languages.insert;
    var ww = this.containing_window;
    var name2575 = new Ext.form.TextField({ "selectOnFocus": true, "allowBlank": false, "maxLength": 200 });
    var name_fr2576 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var name_nl2577 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var id2578 = new Ext.form.TextField({ "selectOnFocus": true, "boxMinWidth": Lino.chars2width(3), "allowBlank": false, "maxLength": 3 });
    var iso22579 = new Ext.form.TextField({ "selectOnFocus": true, "boxMinWidth": Lino.chars2width(2), "maxLength": 2 });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ { "colIndex": 0, "sortable": true, "header": "Description", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "name", "editor": name2575 }, { "colIndex": 1, "sortable": true, "header": "Description (fr)", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "name_fr", "editor": name_fr2576 }, { "colIndex": 2, "sortable": true, "header": "Description (nl)", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "name_nl", "editor": name_nl2577 }, { "colIndex": 3, "sortable": true, "header": "id", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(5), "dataIndex": "id", "editor": id2578 }, { "colIndex": 4, "sortable": true, "header": "iso2", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(5), "dataIndex": "iso2", "editor": iso22579 } ];
    Lino.countries.Languages.GridPanel.superclass.initComponent.call(this);
  }
});


Lino.countries.Languages.insertPanel = Ext.extend(Lino.countries.Languages.DetailFormPanel,{
  empty_title: "Nouveau Langues",
  hide_navigator: true,
  ls_bbar_actions: [ { "itemId": "post", "menu_item_text": "Cr\u00e9er", "tooltip": "Create the record and open a detail window on it", "panel_btn_handler": function(panel){panel.save(null,true,'post')}, "text": "Cr\u00e9er", "overflowText": "Cr\u00e9er", "auto_save": false }, { "itemId": "poststay", "menu_item_text": "Create without detail", "tooltip": "Don't open a detail window on the new record", "panel_btn_handler": function(panel){panel.save(null,false,'poststay')}, "text": "Create without detail", "overflowText": "Create without detail", "auto_save": false } ],
  ls_url: "/countries/Languages",
  action_name: "insert",
  initComponent : function() {
    this.ls_detail_handler = Lino.countries.Languages.detail;
    this.ls_insert_handler = Lino.countries.Languages.insert;
    Lino.countries.Languages.insertPanel.superclass.initComponent.call(this);
  }
});

Lino.countries.Languages.insert = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.countries.Languages.insertPanel(p);
});

Lino.countries.Languages.detailPanel = Ext.extend(Lino.countries.Languages.DetailFormPanel,{
  empty_title: "D\u00e9tail Langues",
  ls_bbar_actions: [ { "itemId": "put", "menu_item_text": "Enregistrer", "tooltip": "Save changes in this form", "panel_btn_handler": function(panel){panel.save(null,false,'put')}, "iconCls": "x-tbar-save", "overflowText": "Enregistrer", "auto_save": false }, { "itemId": "insert", "menu_item_text": "Nouveau", "must_save": true, "tooltip": "Insert a new record", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-new", "overflowText": "Nouveau", "auto_save": true }, { "itemId": null, "menu_item_text": "Supprimer", "tooltip": "Delete this record", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "Supprimer", "auto_save": false } ],
  ls_url: "/countries/Languages",
  action_name: "detail",
  initComponent : function() {
    this.ls_detail_handler = Lino.countries.Languages.detail;
    this.ls_insert_handler = Lino.countries.Languages.insert;
    Lino.countries.Languages.detailPanel.superclass.initComponent.call(this);
  }
});

Lino.countries.Languages.detail = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.countries.Languages.detailPanel(p);
});
Lino.countries.Languages.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.countries.Languages.GridPanel(p);
});

// js_render_GridPanel_class countries.Countries
Lino.countries.Countries.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "No data to display." },
  ls_url : "/countries/Countries",
  ls_bbar_actions : [ { "itemId": "insert", "menu_item_text": "Nouveau", "must_save": true, "tooltip": "Insert a new record", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-new", "overflowText": "Nouveau", "auto_save": true }, { "itemId": "detail", "menu_item_text": "D\u00e9tail", "tooltip": "Open a detail window on this record", "panel_btn_handler": Lino.show_detail, "iconCls": "x-tbar-detail", "overflowText": "D\u00e9tail", "auto_save": true }, { "itemId": null, "menu_item_text": "Supprimer", "tooltip": "Delete this record", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "Supprimer", "auto_save": false } ],
  title : "Pays",
  page_length : 20,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "name": "name" }, { "name": "name_fr" }, { "name": "name_nl" }, { "name": "isocode" }, { "name": "short_code" }, { "name": "iso3" }, { "name": "inscode" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 3,
  ls_grid_configs : [  ],
  content_type : 11,
  ls_id_property : "isocode",
  gc_name : 0,
  disabled_actions_index : 8,
  initComponent : function() {
    this.ls_detail_handler = Lino.countries.Countries.detail;
    this.ls_insert_handler = Lino.countries.Countries.insert;
    var ww = this.containing_window;
    var name2581 = new Ext.form.TextField({ "selectOnFocus": true, "allowBlank": false, "maxLength": 200 });
    var name_fr2582 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var name_nl2583 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var isocode2584 = new Ext.form.TextField({ "selectOnFocus": true, "boxMinWidth": Lino.chars2width(4), "allowBlank": false, "maxLength": 4 });
    var short_code2585 = new Ext.form.TextField({ "selectOnFocus": true, "boxMinWidth": Lino.chars2width(4), "maxLength": 4 });
    var iso32586 = new Ext.form.TextField({ "selectOnFocus": true, "boxMinWidth": Lino.chars2width(3), "maxLength": 3 });
    var inscode2587 = new Ext.form.TextField({ "selectOnFocus": true, "boxMinWidth": Lino.chars2width(3), "maxLength": 3 });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ { "colIndex": 0, "sortable": true, "header": "Description", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "name", "editor": name2581 }, { "colIndex": 1, "sortable": true, "header": "Description (fr)", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "name_fr", "editor": name_fr2582 }, { "colIndex": 2, "sortable": true, "header": "Description (nl)", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "name_nl", "editor": name_nl2583 }, { "colIndex": 3, "sortable": true, "header": "ISO code", "editable": true, "tooltip": "        The two-letter code for this country as defined by ISO 3166-1. \n        For countries that no longer exist it may be a 4-letter code.", "filter": { "type": "string" }, "width": Lino.chars2width(6), "dataIndex": "isocode", "editor": isocode2584 }, { "colIndex": 4, "sortable": true, "header": "Short code", "editable": true, "tooltip": "A short abbreviation for regional usage. Obsolete.", "filter": { "type": "string" }, "width": Lino.chars2width(6), "dataIndex": "short_code", "editor": short_code2585 }, { "colIndex": 5, "sortable": true, "header": "ISO-3 code", "editable": true, "tooltip": "The three-letter code for this country as defined by ISO 3166-1.", "filter": { "type": "string" }, "width": Lino.chars2width(5), "dataIndex": "iso3", "editor": iso32586 }, { "colIndex": 6, "sortable": true, "header": "INS code", "editable": true, "tooltip": "The official code for this country used by statbel.fgov.be", "filter": { "type": "string" }, "width": Lino.chars2width(5), "dataIndex": "inscode", "editor": inscode2587 } ];
    Lino.countries.Countries.GridPanel.superclass.initComponent.call(this);
  }
});


Lino.countries.Countries.insertPanel = Ext.extend(Lino.countries.Countries.DetailFormPanel,{
  empty_title: "Nouveau Pays",
  hide_navigator: true,
  ls_bbar_actions: [ { "itemId": "post", "menu_item_text": "Cr\u00e9er", "tooltip": "Create the record and open a detail window on it", "panel_btn_handler": function(panel){panel.save(null,true,'post')}, "text": "Cr\u00e9er", "overflowText": "Cr\u00e9er", "auto_save": false }, { "itemId": "poststay", "menu_item_text": "Create without detail", "tooltip": "Don't open a detail window on the new record", "panel_btn_handler": function(panel){panel.save(null,false,'poststay')}, "text": "Create without detail", "overflowText": "Create without detail", "auto_save": false } ],
  ls_url: "/countries/Countries",
  action_name: "insert",
  initComponent : function() {
    this.ls_detail_handler = Lino.countries.Countries.detail;
    this.ls_insert_handler = Lino.countries.Countries.insert;
    Lino.countries.Countries.insertPanel.superclass.initComponent.call(this);
  }
});

Lino.countries.Countries.insert = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.countries.Countries.insertPanel(p);
});

Lino.countries.Countries.detailPanel = Ext.extend(Lino.countries.Countries.DetailFormPanel,{
  empty_title: "D\u00e9tail Pays",
  ls_bbar_actions: [ { "itemId": "put", "menu_item_text": "Enregistrer", "tooltip": "Save changes in this form", "panel_btn_handler": function(panel){panel.save(null,false,'put')}, "iconCls": "x-tbar-save", "overflowText": "Enregistrer", "auto_save": false }, { "itemId": "insert", "menu_item_text": "Nouveau", "must_save": true, "tooltip": "Insert a new record", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-new", "overflowText": "Nouveau", "auto_save": true }, { "itemId": null, "menu_item_text": "Supprimer", "tooltip": "Delete this record", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "Supprimer", "auto_save": false } ],
  ls_url: "/countries/Countries",
  action_name: "detail",
  initComponent : function() {
    this.ls_detail_handler = Lino.countries.Countries.detail;
    this.ls_insert_handler = Lino.countries.Countries.insert;
    Lino.countries.Countries.detailPanel.superclass.initComponent.call(this);
  }
});

Lino.countries.Countries.detail = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.countries.Countries.detailPanel(p);
});
Lino.countries.Countries.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.countries.Countries.GridPanel(p);
});

// js_render_GridPanel_class properties.PropChoices
Lino.properties.PropChoices.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "No data to display." },
  ls_url : "/properties/PropChoices",
  ls_bbar_actions : [ { "itemId": null, "menu_item_text": "Supprimer", "tooltip": "Delete this record", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "Supprimer", "auto_save": false } ],
  title : "Choix de propri\u00e9t\u00e9s",
  page_length : 20,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "type": "int", "name": "id" }, { "name": "type" }, 'typeHidden', { "name": "value" }, { "name": "text" }, { "name": "text_fr" }, { "name": "text_nl" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 0,
  ls_grid_configs : [  ],
  content_type : 17,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 8,
  initComponent : function() {
    var ww = this.containing_window;
    var id2589 = new Ext.form.NumberField({ "selectOnFocus": true });
    var type2590 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/properties/PropChoices/type", "method": "GET" }) }), "allowBlank": false, "pageSize": 20, "emptyText": "Choisir Type de propri\u00e9t\u00e9..." });
    var value2591 = new Ext.form.TextField({ "selectOnFocus": true, "allowBlank": false, "maxLength": 200 });
    var text2592 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var text_fr2593 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var text_nl2594 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ new Lino.NullNumberColumn({ "colIndex": 0, "sortable": true, "format": "0", "editable": true, "filter": { "type": "numeric" }, "header": "ID", "renderer": Lino.id_renderer, "editor": id2589, "width": Lino.chars2width(6), "dataIndex": "id" }), { "colIndex": 1, "sortable": true, "header": "Type de propri\u00e9t\u00e9", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "type", "editor": type2590 }, { "colIndex": 2, "sortable": true, "header": "Valeur", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "value", "editor": value2591 }, { "colIndex": 3, "sortable": true, "header": "Description", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "text", "editor": text2592 }, { "colIndex": 4, "sortable": true, "header": "Description (fr)", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "text_fr", "editor": text_fr2593 }, { "colIndex": 5, "sortable": true, "header": "Description (nl)", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "text_nl", "editor": text_nl2594 } ];
    Lino.properties.PropChoices.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.properties.PropChoices.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.properties.PropChoices.GridPanel(p);
});

// js_render_GridPanel_class contacts.Partners
Lino.contacts.Partners.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "No data to display." },
  ls_url : "/contacts/Partners",
  ls_bbar_actions : [ { "itemId": "insert", "menu_item_text": "Nouveau", "must_save": true, "tooltip": "Insert a new record", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-new", "overflowText": "Nouveau", "auto_save": true }, { "itemId": "detail", "menu_item_text": "D\u00e9tail", "tooltip": "Open a detail window on this record", "panel_btn_handler": Lino.show_detail, "iconCls": "x-tbar-detail", "overflowText": "D\u00e9tail", "auto_save": true }, { "itemId": null, "menu_item_text": "Supprimer", "tooltip": "Delete this record", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "Supprimer", "auto_save": false } ],
  title : "Partenaires",
  page_length : 20,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "name": "name" }, { "name": "email" }, { "name": "created" }, { "name": "modified" }, { "name": "country" }, 'countryHidden', { "name": "city" }, 'cityHidden', { "name": "region" }, 'regionHidden', { "name": "zip_code" }, { "name": "addr1" }, { "name": "street_prefix" }, { "name": "street" }, { "name": "street_no" }, { "name": "street_box" }, { "name": "addr2" }, { "name": "language" }, 'languageHidden', { "name": "url" }, { "name": "phone" }, { "name": "gsm" }, { "name": "fax" }, { "name": "remarks" }, { "type": "boolean", "name": "is_obsolete" }, { "name": "activity" }, 'activityHidden', { "name": "bank_account1" }, { "name": "bank_account2" }, { "type": "int", "name": "id" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 29,
  ls_grid_configs : [  ],
  content_type : 23,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 31,
  initComponent : function() {
    this.ls_detail_handler = Lino.contacts.Partners.detail;
    this.ls_insert_handler = Lino.contacts.Partners.insert;
    var ww = this.containing_window;
    var name2596 = new Ext.form.TextField({ "selectOnFocus": true, "allowBlank": false, "maxLength": 200 });
    var email2597 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 75 });
    var created2598 = new Ext.form.DisplayField({ "disabled": true, "value": "<br>" });
    var modified2599 = new Ext.form.DisplayField({ "disabled": true, "value": "<br>" });
    var country2600 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/contacts/Partners/country", "method": "GET" }) }), "pageSize": 20, "emptyText": "Choisir Pays..." });
    var city2601 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "forceSelection": false, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/contacts/Partners/city", "method": "GET" }) }), "pageSize": 20, "emptyText": "Choisir Place..." });
    var region2602 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/contacts/Partners/region", "method": "GET" }) }), "pageSize": 20, "emptyText": "Choisir Place..." });
    var zip_code2603 = new Ext.form.TextField({ "selectOnFocus": true, "boxMinWidth": Lino.chars2width(10), "maxLength": 10 });
    var addr12604 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var street_prefix2605 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var street2606 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var street_no2607 = new Ext.form.TextField({ "selectOnFocus": true, "boxMinWidth": Lino.chars2width(10), "maxLength": 10 });
    var street_box2608 = new Ext.form.TextField({ "selectOnFocus": true, "boxMinWidth": Lino.chars2width(10), "maxLength": 10 });
    var addr22609 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var language2610 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "store": [ [ "de", "German" ], [ "fr", "French" ], [ "nl", "Dutch" ] ], "allowBlank": false, "value": "de" });
    var url2611 = new Lino.URLField({ "selectOnFocus": true, "maxLength": 200 });
    var phone2612 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var gsm2613 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var fax2614 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var remarks2615 = new Ext.form.TextArea({ "selectOnFocus": true, "growMax": 2000 });
    var is_obsolete2616 = new Ext.form.Checkbox({ "selectOnFocus": true, "checked": false });
    var activity2617 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/contacts/Partners/activity", "method": "GET" }) }), "pageSize": 20, "emptyText": "Choisir Activit\u00e9..." });
    var bank_account12618 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 40 });
    var bank_account22619 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 40 });
    var id2620 = new Ext.form.NumberField({ "selectOnFocus": true });
    this.before_row_edit = function(record) {
      city2601.setContextValue('country',record ? record.data['countryHidden'] : undefined);
      city2601.setContextValue('region',record ? record.data['regionHidden'] : undefined);
      region2602.setContextValue('country',record ? record.data['countryHidden'] : undefined);
    };
    this.onRender = function(ct, position) {
      country2600.on('change',Lino.chooser_handler(city2601,'country'));
      region2602.on('change',Lino.chooser_handler(city2601,'region'));
      country2600.on('change',Lino.chooser_handler(region2602,'country'));
      Lino.contacts.Partners.GridPanel.superclass.onRender.call(this, ct, position);
    }
    this.ls_columns = [ { "colIndex": 0, "sortable": true, "header": "Name", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "name", "editor": name2596 }, { "colIndex": 1, "sortable": true, "header": "E-mail", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "email", "editor": email2597 }, { "width": Lino.chars2width(17), "colIndex": 2, "sortable": true, "dataIndex": "created", "header": "Cr\u00e9\u00e9", "hidden": true, "editable": false }, { "width": Lino.chars2width(17), "colIndex": 3, "sortable": true, "dataIndex": "modified", "header": "Modified", "hidden": true, "editable": false }, { "colIndex": 4, "sortable": true, "header": "Pays", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('countryHidden','Lino.countries.Countries.detail'), "editor": country2600, "dataIndex": "country" }, { "colIndex": 5, "sortable": true, "header": "Place", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "city", "editor": city2601 }, { "colIndex": 6, "sortable": true, "header": "Region", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "region", "editor": region2602 }, { "colIndex": 7, "sortable": true, "header": "Zip code", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(12), "dataIndex": "zip_code", "editor": zip_code2603 }, { "colIndex": 8, "sortable": true, "header": "Ligne avant le nom de rue", "editable": true, "tooltip": "Address line before street", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "addr1", "editor": addr12604 }, { "colIndex": 9, "sortable": true, "header": "Pr\u00e9fixe rue", "editable": true, "tooltip": "Text to print before name of street, but to ignore for sorting.", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "street_prefix", "editor": street_prefix2605 }, { "colIndex": 10, "sortable": true, "header": "Rue", "editable": true, "tooltip": "Name of street. Without house number.", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "street", "editor": street2606 }, { "colIndex": 11, "sortable": true, "header": "N\u00b0", "editable": true, "tooltip": "House number", "filter": { "type": "string" }, "width": Lino.chars2width(12), "dataIndex": "street_no", "editor": street_no2607 }, { "colIndex": 12, "sortable": true, "header": "bo\u00eete", "editable": true, "tooltip": "Text to print after :attr:`steet_no` on the same line", "filter": { "type": "string" }, "width": Lino.chars2width(12), "dataIndex": "street_box", "editor": street_box2608 }, { "colIndex": 13, "sortable": true, "header": "Ligne apr\u00e8s le nom de rue", "editable": true, "tooltip": "Address line to print below street line", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "addr2", "editor": addr22609 }, { "colIndex": 14, "sortable": true, "header": "Langue", "editable": true, "tooltip": "Die Sprache, in der Dokumente ausgestellt werden sollen.", "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "language", "editor": language2610 }, { "colIndex": 15, "sortable": true, "header": "URL", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "url", "editor": url2611 }, { "colIndex": 16, "sortable": true, "header": "T\u00e9l\u00e9phone", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "phone", "editor": phone2612 }, { "colIndex": 17, "sortable": true, "header": "GSM", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "gsm", "editor": gsm2613 }, { "colIndex": 18, "sortable": true, "header": "Fax", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "fax", "editor": fax2614 }, { "colIndex": 19, "sortable": false, "header": "Remarques", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(61), "renderer": Lino.text_renderer, "editor": remarks2615, "dataIndex": "remarks" }, { "colIndex": 20, "sortable": false, "xtype": "checkcolumn", "header": "obsolete", "editable": true, "tooltip": "Altf\u00e4lle sind Partner, deren Stammdaten nicht mehr gepflegt werden und \nf\u00fcr neue Operationen nicht benutzt werden k\u00f6nnen.", "filter": { "type": "boolean" }, "width": Lino.chars2width(11), "dataIndex": "is_obsolete" }, { "colIndex": 21, "sortable": true, "header": "Activit\u00e9", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "activity", "hidden": true, "editor": activity2617 }, { "colIndex": 22, "sortable": true, "header": "Compte en banque 1", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "bank_account1", "hidden": true, "editor": bank_account12618 }, { "colIndex": 23, "sortable": true, "header": "Compte en banque 2", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "bank_account2", "hidden": true, "editor": bank_account22619 }, new Lino.NullNumberColumn({ "colIndex": 24, "sortable": true, "format": "0", "editable": true, "filter": { "type": "numeric" }, "header": "ID", "renderer": Lino.id_renderer, "editor": id2620, "width": Lino.chars2width(6), "dataIndex": "id" }) ];
    Lino.contacts.Partners.GridPanel.superclass.initComponent.call(this);
  }
});


Lino.contacts.Partners.insertPanel = Ext.extend(Lino.contacts.Partners.InsertFormPanel,{
  empty_title: "Nouveau Partenaires",
  hide_navigator: true,
  ls_bbar_actions: [ { "itemId": "post", "menu_item_text": "Cr\u00e9er", "tooltip": "Create the record and open a detail window on it", "panel_btn_handler": function(panel){panel.save(null,true,'post')}, "text": "Cr\u00e9er", "overflowText": "Cr\u00e9er", "auto_save": false }, { "itemId": "poststay", "menu_item_text": "Create without detail", "tooltip": "Don't open a detail window on the new record", "panel_btn_handler": function(panel){panel.save(null,false,'poststay')}, "text": "Create without detail", "overflowText": "Create without detail", "auto_save": false } ],
  ls_url: "/contacts/Partners",
  action_name: "insert",
  initComponent : function() {
    this.ls_detail_handler = Lino.contacts.Partners.detail;
    this.ls_insert_handler = Lino.contacts.Partners.insert;
    Lino.contacts.Partners.insertPanel.superclass.initComponent.call(this);
  }
});

Lino.contacts.Partners.insert = new Lino.WindowAction({ "draggable": true, "width": Lino.chars2width(40), "autoHeight": true, "maximizable": true, "modal": true, "maximized": false },function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.contacts.Partners.insertPanel(p);
});

Lino.contacts.Partners.detailPanel = Ext.extend(Lino.contacts.Partners.DetailFormPanel,{
  empty_title: "D\u00e9tail Partenaires",
  ls_bbar_actions: [ { "itemId": "put", "menu_item_text": "Enregistrer", "tooltip": "Save changes in this form", "panel_btn_handler": function(panel){panel.save(null,false,'put')}, "iconCls": "x-tbar-save", "overflowText": "Enregistrer", "auto_save": false }, { "itemId": "insert", "menu_item_text": "Nouveau", "must_save": true, "tooltip": "Insert a new record", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-new", "overflowText": "Nouveau", "auto_save": true }, { "itemId": null, "menu_item_text": "Supprimer", "tooltip": "Delete this record", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "Supprimer", "auto_save": false } ],
  ls_url: "/contacts/Partners",
  action_name: "detail",
  initComponent : function() {
    this.ls_detail_handler = Lino.contacts.Partners.detail;
    this.ls_insert_handler = Lino.contacts.Partners.insert;
    Lino.contacts.Partners.detailPanel.superclass.initComponent.call(this);
  }
});

Lino.contacts.Partners.detail = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.contacts.Partners.detailPanel(p);
});
Lino.contacts.Partners.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.contacts.Partners.GridPanel(p);
});

// js_render_GridPanel_class contacts.Companies
Lino.contacts.Companies.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "No data to display." },
  ls_url : "/contacts/Companies",
  ls_bbar_actions : [ { "itemId": "insert", "menu_item_text": "Nouveau", "must_save": true, "tooltip": "Insert a new record", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-new", "overflowText": "Nouveau", "auto_save": true }, { "itemId": "detail", "menu_item_text": "D\u00e9tail", "tooltip": "Open a detail window on this record", "panel_btn_handler": Lino.show_detail, "iconCls": "x-tbar-detail", "overflowText": "D\u00e9tail", "auto_save": true }, { "itemId": null, "menu_item_text": "Supprimer", "tooltip": "Delete this record", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "Supprimer", "auto_save": false } ],
  title : "Organisations",
  page_length : 20,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "name": "name" }, { "name": "email" }, { "name": "created" }, { "name": "modified" }, { "name": "country" }, 'countryHidden', { "name": "city" }, 'cityHidden', { "name": "region" }, 'regionHidden', { "name": "zip_code" }, { "name": "addr1" }, { "name": "street_prefix" }, { "name": "street" }, { "name": "street_no" }, { "name": "street_box" }, { "name": "addr2" }, { "name": "language" }, 'languageHidden', { "name": "url" }, { "name": "phone" }, { "name": "gsm" }, { "name": "fax" }, { "name": "remarks" }, { "type": "boolean", "name": "is_obsolete" }, { "name": "activity" }, 'activityHidden', { "name": "bank_account1" }, { "name": "bank_account2" }, { "name": "prefix" }, { "name": "vat_id" }, { "name": "type" }, 'typeHidden', { "name": "client_contact_type" }, 'client_contact_typeHidden', { "type": "int", "name": "id" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 35,
  ls_grid_configs : [  ],
  content_type : 20,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 37,
  initComponent : function() {
    this.ls_detail_handler = Lino.contacts.Companies.detail;
    this.ls_insert_handler = Lino.contacts.Companies.insert;
    var ww = this.containing_window;
    var name2622 = new Ext.form.TextField({ "selectOnFocus": true, "allowBlank": false, "maxLength": 200 });
    var email2623 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 75 });
    var created2624 = new Ext.form.DisplayField({ "disabled": true, "value": "<br>" });
    var modified2625 = new Ext.form.DisplayField({ "disabled": true, "value": "<br>" });
    var country2626 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/contacts/Companies/country", "method": "GET" }) }), "pageSize": 20, "emptyText": "Choisir Pays..." });
    var city2627 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "forceSelection": false, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/contacts/Companies/city", "method": "GET" }) }), "pageSize": 20, "emptyText": "Choisir Place..." });
    var region2628 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/contacts/Companies/region", "method": "GET" }) }), "pageSize": 20, "emptyText": "Choisir Place..." });
    var zip_code2629 = new Ext.form.TextField({ "selectOnFocus": true, "boxMinWidth": Lino.chars2width(10), "maxLength": 10 });
    var addr12630 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var street_prefix2631 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var street2632 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var street_no2633 = new Ext.form.TextField({ "selectOnFocus": true, "boxMinWidth": Lino.chars2width(10), "maxLength": 10 });
    var street_box2634 = new Ext.form.TextField({ "selectOnFocus": true, "boxMinWidth": Lino.chars2width(10), "maxLength": 10 });
    var addr22635 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var language2636 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "store": [ [ "de", "German" ], [ "fr", "French" ], [ "nl", "Dutch" ] ], "allowBlank": false, "value": "de" });
    var url2637 = new Lino.URLField({ "selectOnFocus": true, "maxLength": 200 });
    var phone2638 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var gsm2639 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var fax2640 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var remarks2641 = new Ext.form.TextArea({ "selectOnFocus": true, "growMax": 2000 });
    var is_obsolete2642 = new Ext.form.Checkbox({ "selectOnFocus": true, "checked": false });
    var activity2643 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/contacts/Companies/activity", "method": "GET" }) }), "pageSize": 20, "emptyText": "Choisir Activit\u00e9..." });
    var bank_account12644 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 40 });
    var bank_account22645 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 40 });
    var prefix2646 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var vat_id2647 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var type2648 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/contacts/Companies/type", "method": "GET" }) }), "pageSize": 20, "emptyText": "Choisir Type d'organisation..." });
    var client_contact_type2649 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/contacts/Companies/client_contact_type", "method": "GET" }) }), "pageSize": 20, "emptyText": "Choisir Type de contact client..." });
    var id2650 = new Ext.form.NumberField({ "selectOnFocus": true });
    this.before_row_edit = function(record) {
      city2627.setContextValue('country',record ? record.data['countryHidden'] : undefined);
      city2627.setContextValue('region',record ? record.data['regionHidden'] : undefined);
      region2628.setContextValue('country',record ? record.data['countryHidden'] : undefined);
    };
    this.onRender = function(ct, position) {
      country2626.on('change',Lino.chooser_handler(city2627,'country'));
      region2628.on('change',Lino.chooser_handler(city2627,'region'));
      country2626.on('change',Lino.chooser_handler(region2628,'country'));
      Lino.contacts.Companies.GridPanel.superclass.onRender.call(this, ct, position);
    }
    this.ls_columns = [ { "colIndex": 0, "sortable": true, "header": "Name", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "name", "editor": name2622 }, { "colIndex": 1, "sortable": true, "header": "E-mail", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "email", "editor": email2623 }, { "width": Lino.chars2width(17), "colIndex": 2, "sortable": true, "dataIndex": "created", "header": "Cr\u00e9\u00e9", "hidden": true, "editable": false }, { "width": Lino.chars2width(17), "colIndex": 3, "sortable": true, "dataIndex": "modified", "header": "Modified", "hidden": true, "editable": false }, { "colIndex": 4, "sortable": true, "header": "Pays", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('countryHidden','Lino.countries.Countries.detail'), "editor": country2626, "dataIndex": "country" }, { "colIndex": 5, "sortable": true, "header": "Place", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "city", "editor": city2627 }, { "colIndex": 6, "sortable": true, "header": "Region", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "region", "editor": region2628 }, { "colIndex": 7, "sortable": true, "header": "Zip code", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(12), "dataIndex": "zip_code", "editor": zip_code2629 }, { "colIndex": 8, "sortable": true, "header": "Ligne avant le nom de rue", "editable": true, "tooltip": "Address line before street", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "addr1", "editor": addr12630 }, { "colIndex": 9, "sortable": true, "header": "Pr\u00e9fixe rue", "editable": true, "tooltip": "Text to print before name of street, but to ignore for sorting.", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "street_prefix", "editor": street_prefix2631 }, { "colIndex": 10, "sortable": true, "header": "Rue", "editable": true, "tooltip": "Name of street. Without house number.", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "street", "editor": street2632 }, { "colIndex": 11, "sortable": true, "header": "N\u00b0", "editable": true, "tooltip": "House number", "filter": { "type": "string" }, "width": Lino.chars2width(12), "dataIndex": "street_no", "editor": street_no2633 }, { "colIndex": 12, "sortable": true, "header": "bo\u00eete", "editable": true, "tooltip": "Text to print after :attr:`steet_no` on the same line", "filter": { "type": "string" }, "width": Lino.chars2width(12), "dataIndex": "street_box", "editor": street_box2634 }, { "colIndex": 13, "sortable": true, "header": "Ligne apr\u00e8s le nom de rue", "editable": true, "tooltip": "Address line to print below street line", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "addr2", "editor": addr22635 }, { "colIndex": 14, "sortable": true, "header": "Langue", "editable": true, "tooltip": "Die Sprache, in der Dokumente ausgestellt werden sollen.", "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "language", "editor": language2636 }, { "colIndex": 15, "sortable": true, "header": "URL", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "url", "editor": url2637 }, { "colIndex": 16, "sortable": true, "header": "T\u00e9l\u00e9phone", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "phone", "editor": phone2638 }, { "colIndex": 17, "sortable": true, "header": "GSM", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "gsm", "editor": gsm2639 }, { "colIndex": 18, "sortable": true, "header": "Fax", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "fax", "editor": fax2640 }, { "colIndex": 19, "sortable": false, "header": "Remarques", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(61), "renderer": Lino.text_renderer, "editor": remarks2641, "dataIndex": "remarks" }, { "colIndex": 20, "sortable": false, "xtype": "checkcolumn", "header": "obsolete", "editable": true, "tooltip": "Altf\u00e4lle sind Partner, deren Stammdaten nicht mehr gepflegt werden und \nf\u00fcr neue Operationen nicht benutzt werden k\u00f6nnen.", "filter": { "type": "boolean" }, "width": Lino.chars2width(11), "dataIndex": "is_obsolete" }, { "colIndex": 21, "sortable": true, "header": "Activit\u00e9", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "activity", "hidden": true, "editor": activity2643 }, { "colIndex": 22, "sortable": true, "header": "Compte en banque 1", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "bank_account1", "hidden": true, "editor": bank_account12644 }, { "colIndex": 23, "sortable": true, "header": "Compte en banque 2", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "bank_account2", "hidden": true, "editor": bank_account22645 }, { "colIndex": 24, "sortable": true, "header": "prefix", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "prefix", "editor": prefix2646 }, { "colIndex": 25, "sortable": true, "header": "N\u00b0 de TVA", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "vat_id", "editor": vat_id2647 }, { "colIndex": 26, "sortable": true, "header": "Type de soci\u00e9t\u00e9", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "type", "editor": type2648 }, { "colIndex": 27, "sortable": true, "header": "Type de contact client", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "client_contact_type", "editor": client_contact_type2649 }, new Lino.NullNumberColumn({ "colIndex": 28, "sortable": true, "format": "0", "editable": true, "filter": { "type": "numeric" }, "header": "ID", "renderer": Lino.id_renderer, "editor": id2650, "width": Lino.chars2width(6), "dataIndex": "id" }) ];
    Lino.contacts.Companies.GridPanel.superclass.initComponent.call(this);
  }
});


Lino.contacts.Companies.insertPanel = Ext.extend(Lino.contacts.Companies.InsertFormPanel,{
  empty_title: "Nouveau Organisations",
  hide_navigator: true,
  ls_bbar_actions: [ { "itemId": "post", "menu_item_text": "Cr\u00e9er", "tooltip": "Create the record and open a detail window on it", "panel_btn_handler": function(panel){panel.save(null,true,'post')}, "text": "Cr\u00e9er", "overflowText": "Cr\u00e9er", "auto_save": false }, { "itemId": "poststay", "menu_item_text": "Create without detail", "tooltip": "Don't open a detail window on the new record", "panel_btn_handler": function(panel){panel.save(null,false,'poststay')}, "text": "Create without detail", "overflowText": "Create without detail", "auto_save": false } ],
  ls_url: "/contacts/Companies",
  action_name: "insert",
  initComponent : function() {
    this.ls_detail_handler = Lino.contacts.Companies.detail;
    this.ls_insert_handler = Lino.contacts.Companies.insert;
    Lino.contacts.Companies.insertPanel.superclass.initComponent.call(this);
  }
});

Lino.contacts.Companies.insert = new Lino.WindowAction({ "draggable": true, "width": Lino.chars2width(60), "autoHeight": true, "maximizable": true, "modal": true, "maximized": false },function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.contacts.Companies.insertPanel(p);
});

Lino.contacts.Companies.detailPanel = Ext.extend(Lino.contacts.Companies.DetailFormPanel,{
  empty_title: "D\u00e9tail Organisations",
  ls_bbar_actions: [ { "itemId": "put", "menu_item_text": "Enregistrer", "tooltip": "Save changes in this form", "panel_btn_handler": function(panel){panel.save(null,false,'put')}, "iconCls": "x-tbar-save", "overflowText": "Enregistrer", "auto_save": false }, { "itemId": "insert", "menu_item_text": "Nouveau", "must_save": true, "tooltip": "Insert a new record", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-new", "overflowText": "Nouveau", "auto_save": true }, { "itemId": null, "menu_item_text": "Supprimer", "tooltip": "Delete this record", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "Supprimer", "auto_save": false } ],
  ls_url: "/contacts/Companies",
  action_name: "detail",
  initComponent : function() {
    this.ls_detail_handler = Lino.contacts.Companies.detail;
    this.ls_insert_handler = Lino.contacts.Companies.insert;
    Lino.contacts.Companies.detailPanel.superclass.initComponent.call(this);
  }
});

Lino.contacts.Companies.detail = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.contacts.Companies.detailPanel(p);
});
Lino.contacts.Companies.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.contacts.Companies.GridPanel(p);
});

// js_render_GridPanel_class postings.PostingsByState
Lino.postings.PostingsByState.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "No data to display." },
  ls_url : "/postings/PostingsByState",
  ls_bbar_actions : [ { "itemId": null, "menu_item_text": "Supprimer", "tooltip": "Delete this record", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "Supprimer", "auto_save": false }, { "itemId": "print_action", "menu_item_text": "Imprimer", "must_save": true, "tooltip": "Imprimer", "panel_btn_handler": Lino.row_action_handler('print_action','GET'), "iconCls": "x-tbar-print", "overflowText": "Imprimer", "auto_save": true } ],
  title : "Envois postaux",
  page_length : 20,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "type": "date", "name": "date", "dateFormat": "d.m.Y" }, { "name": "user" }, 'userHidden', { "name": "partner" }, 'partnerHidden', { "name": "workflow_buttons" }, { "type": "int", "name": "id" }, { "name": "owner_type" }, 'owner_typeHidden', { "name": "owner_id" }, 'owner_idHidden', { "name": "project" }, 'projectHidden', { "name": "state" }, 'stateHidden', { "name": "owner" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 6,
  ls_grid_configs : [  ],
  content_type : 38,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 17,
  initComponent : function() {
    var ww = this.containing_window;
    var date2652 = new Lino.DateField({ "selectOnFocus": true, "allowBlank": false });
    var user2653 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/postings/PostingsByState/user", "method": "GET" }) }), "pageSize": 20, "emptyText": "Choisir Utilisateur..." });
    var partner2654 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/postings/PostingsByState/partner", "method": "GET" }) }), "pageSize": 20, "emptyText": "Choisir Partenaire..." });
    var workflow_buttons_disp2655 = new Ext.form.DisplayField({ "disabled": true, "value": "<br/>", "always_enabled": true });
    var id2656 = new Ext.form.NumberField({ "selectOnFocus": true });
    var owner_type2657 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/postings/PostingsByState/owner_type", "method": "GET" }) }), "pageSize": 20, "emptyText": "Choisir type de contenu..." });
    var owner_id2658 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/postings/PostingsByState/owner_id", "method": "GET" }) }) });
    var project2659 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/postings/PostingsByState/project", "method": "GET" }) }), "pageSize": 20, "emptyText": "Choisir Client..." });
    var state2660 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "forceSelection": true, "allowBlank": false, "store": Lino.postings.PostingStates });
    var owner_disp2661 = new Ext.form.DisplayField({ "disabled": true });
    this.before_row_edit = function(record) {
      owner_id2658.setContextValue('owner_type',record ? record.data['owner_typeHidden'] : undefined);
    };
    this.onRender = function(ct, position) {
      owner_type2657.on('change',Lino.chooser_handler(owner_id2658,'owner_type'));
      Lino.postings.PostingsByState.GridPanel.superclass.onRender.call(this, ct, position);
    }
    this.ls_columns = [ { "colIndex": 0, "sortable": true, "xtype": "datecolumn", "format": "d.m.Y", "editable": true, "filter": { "type": "date", "dateFormat": "d.m.Y" }, "header": "date", "editor": date2652, "width": Lino.chars2width(9), "dataIndex": "date" }, { "colIndex": 1, "sortable": true, "header": "Auteur", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(16), "dataIndex": "user", "editor": user2653 }, { "colIndex": 2, "sortable": true, "header": "Destinataire", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('partnerHidden','Lino.contacts.Partners.detail'), "editor": partner2654, "dataIndex": "partner" }, { "width": Lino.chars2width(31), "colIndex": 3, "sortable": false, "dataIndex": "workflow_buttons", "header": "Arbeitsablauf", "editable": false }, new Lino.NullNumberColumn({ "colIndex": 4, "sortable": true, "format": "0", "editable": true, "filter": { "type": "numeric" }, "header": "ID", "renderer": Lino.id_renderer, "editor": id2656, "width": Lino.chars2width(6), "dataIndex": "id" }), { "colIndex": 5, "sortable": true, "header": "Contr\u00f4l\u00e9 par (type)", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "owner_type", "editor": owner_type2657 }, { "colIndex": 6, "sortable": true, "header": "Contr\u00f4l\u00e9 par (object)", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(11), "dataIndex": "owner_id", "editor": owner_id2658 }, { "colIndex": 7, "sortable": true, "header": "Client", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('projectHidden','Lino.pcsw.Clients.detail'), "editor": project2659, "dataIndex": "project" }, { "colIndex": 8, "sortable": true, "header": "State", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(23), "dataIndex": "state", "editor": state2660 }, { "width": Lino.chars2width(11), "colIndex": 9, "sortable": false, "dataIndex": "owner", "header": "Contr\u00f4l\u00e9 par", "editable": false } ];
    Lino.postings.PostingsByState.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.postings.PostingsByState.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.postings.PostingsByState.GridPanel(p);
});
Lino.postings.PostingsByState.print_action = function(rp,pk) { 
  Lino.run_row_action(rp,"/postings/PostingsByState",pk,"print_action");
};

// js_render_GridPanel_class postings.PostingsReady
Lino.postings.PostingsReady.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "No data to display." },
  ls_url : "/postings/PostingsReady",
  ls_bbar_actions : [ { "itemId": null, "menu_item_text": "Supprimer", "tooltip": "Delete this record", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "Supprimer", "auto_save": false }, { "itemId": "print_action", "menu_item_text": "Imprimer", "must_save": true, "tooltip": "Imprimer", "panel_btn_handler": Lino.row_action_handler('print_action','GET'), "iconCls": "x-tbar-print", "overflowText": "Imprimer", "auto_save": true } ],
  title : "Envois postaux \u00e0 imprimer",
  page_length : 20,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "type": "date", "name": "date", "dateFormat": "d.m.Y" }, { "name": "user" }, 'userHidden', { "name": "partner" }, 'partnerHidden', { "name": "workflow_buttons" }, { "type": "int", "name": "id" }, { "name": "owner_type" }, 'owner_typeHidden', { "name": "owner_id" }, 'owner_idHidden', { "name": "project" }, 'projectHidden', { "name": "state" }, 'stateHidden', { "name": "owner" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 6,
  ls_grid_configs : [  ],
  content_type : 38,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 17,
  initComponent : function() {
    var ww = this.containing_window;
    var date2663 = new Lino.DateField({ "selectOnFocus": true, "allowBlank": false });
    var user2664 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/postings/PostingsReady/user", "method": "GET" }) }), "pageSize": 20, "emptyText": "Choisir Utilisateur..." });
    var partner2665 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/postings/PostingsReady/partner", "method": "GET" }) }), "pageSize": 20, "emptyText": "Choisir Partenaire..." });
    var workflow_buttons_disp2666 = new Ext.form.DisplayField({ "disabled": true, "value": "<br/>", "always_enabled": true });
    var id2667 = new Ext.form.NumberField({ "selectOnFocus": true });
    var owner_type2668 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/postings/PostingsReady/owner_type", "method": "GET" }) }), "pageSize": 20, "emptyText": "Choisir type de contenu..." });
    var owner_id2669 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/postings/PostingsReady/owner_id", "method": "GET" }) }) });
    var project2670 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/postings/PostingsReady/project", "method": "GET" }) }), "pageSize": 20, "emptyText": "Choisir Client..." });
    var state2671 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "forceSelection": true, "allowBlank": false, "store": Lino.postings.PostingStates });
    var owner_disp2672 = new Ext.form.DisplayField({ "disabled": true });
    this.before_row_edit = function(record) {
      owner_id2669.setContextValue('owner_type',record ? record.data['owner_typeHidden'] : undefined);
    };
    this.onRender = function(ct, position) {
      owner_type2668.on('change',Lino.chooser_handler(owner_id2669,'owner_type'));
      Lino.postings.PostingsReady.GridPanel.superclass.onRender.call(this, ct, position);
    }
    this.ls_columns = [ { "colIndex": 0, "sortable": true, "xtype": "datecolumn", "format": "d.m.Y", "editable": true, "filter": { "type": "date", "dateFormat": "d.m.Y" }, "header": "date", "editor": date2663, "width": Lino.chars2width(9), "dataIndex": "date" }, { "colIndex": 1, "sortable": true, "header": "Auteur", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(16), "dataIndex": "user", "editor": user2664 }, { "colIndex": 2, "sortable": true, "header": "Destinataire", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('partnerHidden','Lino.contacts.Partners.detail'), "editor": partner2665, "dataIndex": "partner" }, { "width": Lino.chars2width(31), "colIndex": 3, "sortable": false, "dataIndex": "workflow_buttons", "header": "Arbeitsablauf", "editable": false }, new Lino.NullNumberColumn({ "colIndex": 4, "sortable": true, "format": "0", "editable": true, "filter": { "type": "numeric" }, "header": "ID", "renderer": Lino.id_renderer, "editor": id2667, "width": Lino.chars2width(6), "dataIndex": "id" }), { "colIndex": 5, "sortable": true, "header": "Contr\u00f4l\u00e9 par (type)", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "owner_type", "editor": owner_type2668 }, { "colIndex": 6, "sortable": true, "header": "Contr\u00f4l\u00e9 par (object)", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(11), "dataIndex": "owner_id", "editor": owner_id2669 }, { "colIndex": 7, "sortable": true, "header": "Client", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('projectHidden','Lino.pcsw.Clients.detail'), "editor": project2670, "dataIndex": "project" }, { "colIndex": 8, "sortable": true, "header": "State", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(23), "dataIndex": "state", "editor": state2671 }, { "width": Lino.chars2width(11), "colIndex": 9, "sortable": false, "dataIndex": "owner", "header": "Contr\u00f4l\u00e9 par", "editable": false } ];
    Lino.postings.PostingsReady.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.postings.PostingsReady.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.postings.PostingsReady.GridPanel(p);
});
Lino.postings.PostingsReady.print_action = function(rp,pk) { 
  Lino.run_row_action(rp,"/postings/PostingsReady",pk,"print_action");
};

// js_render_GridPanel_class postings.PostingsPrinted
Lino.postings.PostingsPrinted.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "No data to display." },
  ls_url : "/postings/PostingsPrinted",
  ls_bbar_actions : [ { "itemId": null, "menu_item_text": "Supprimer", "tooltip": "Delete this record", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "Supprimer", "auto_save": false }, { "itemId": "print_action", "menu_item_text": "Imprimer", "must_save": true, "tooltip": "Imprimer", "panel_btn_handler": Lino.row_action_handler('print_action','GET'), "iconCls": "x-tbar-print", "overflowText": "Imprimer", "auto_save": true } ],
  title : "Envois postaux imprim\u00e9s",
  page_length : 20,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "type": "date", "name": "date", "dateFormat": "d.m.Y" }, { "name": "user" }, 'userHidden', { "name": "partner" }, 'partnerHidden', { "name": "workflow_buttons" }, { "type": "int", "name": "id" }, { "name": "owner_type" }, 'owner_typeHidden', { "name": "owner_id" }, 'owner_idHidden', { "name": "project" }, 'projectHidden', { "name": "state" }, 'stateHidden', { "name": "owner" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 6,
  ls_grid_configs : [  ],
  content_type : 38,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 17,
  initComponent : function() {
    var ww = this.containing_window;
    var date2674 = new Lino.DateField({ "selectOnFocus": true, "allowBlank": false });
    var user2675 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/postings/PostingsPrinted/user", "method": "GET" }) }), "pageSize": 20, "emptyText": "Choisir Utilisateur..." });
    var partner2676 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/postings/PostingsPrinted/partner", "method": "GET" }) }), "pageSize": 20, "emptyText": "Choisir Partenaire..." });
    var workflow_buttons_disp2677 = new Ext.form.DisplayField({ "disabled": true, "value": "<br/>", "always_enabled": true });
    var id2678 = new Ext.form.NumberField({ "selectOnFocus": true });
    var owner_type2679 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/postings/PostingsPrinted/owner_type", "method": "GET" }) }), "pageSize": 20, "emptyText": "Choisir type de contenu..." });
    var owner_id2680 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/postings/PostingsPrinted/owner_id", "method": "GET" }) }) });
    var project2681 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/postings/PostingsPrinted/project", "method": "GET" }) }), "pageSize": 20, "emptyText": "Choisir Client..." });
    var state2682 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "forceSelection": true, "allowBlank": false, "store": Lino.postings.PostingStates });
    var owner_disp2683 = new Ext.form.DisplayField({ "disabled": true });
    this.before_row_edit = function(record) {
      owner_id2680.setContextValue('owner_type',record ? record.data['owner_typeHidden'] : undefined);
    };
    this.onRender = function(ct, position) {
      owner_type2679.on('change',Lino.chooser_handler(owner_id2680,'owner_type'));
      Lino.postings.PostingsPrinted.GridPanel.superclass.onRender.call(this, ct, position);
    }
    this.ls_columns = [ { "colIndex": 0, "sortable": true, "xtype": "datecolumn", "format": "d.m.Y", "editable": true, "filter": { "type": "date", "dateFormat": "d.m.Y" }, "header": "date", "editor": date2674, "width": Lino.chars2width(9), "dataIndex": "date" }, { "colIndex": 1, "sortable": true, "header": "Auteur", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(16), "dataIndex": "user", "editor": user2675 }, { "colIndex": 2, "sortable": true, "header": "Destinataire", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('partnerHidden','Lino.contacts.Partners.detail'), "editor": partner2676, "dataIndex": "partner" }, { "width": Lino.chars2width(31), "colIndex": 3, "sortable": false, "dataIndex": "workflow_buttons", "header": "Arbeitsablauf", "editable": false }, new Lino.NullNumberColumn({ "colIndex": 4, "sortable": true, "format": "0", "editable": true, "filter": { "type": "numeric" }, "header": "ID", "renderer": Lino.id_renderer, "editor": id2678, "width": Lino.chars2width(6), "dataIndex": "id" }), { "colIndex": 5, "sortable": true, "header": "Contr\u00f4l\u00e9 par (type)", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "owner_type", "editor": owner_type2679 }, { "colIndex": 6, "sortable": true, "header": "Contr\u00f4l\u00e9 par (object)", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(11), "dataIndex": "owner_id", "editor": owner_id2680 }, { "colIndex": 7, "sortable": true, "header": "Client", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('projectHidden','Lino.pcsw.Clients.detail'), "editor": project2681, "dataIndex": "project" }, { "colIndex": 8, "sortable": true, "header": "State", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(23), "dataIndex": "state", "editor": state2682 }, { "width": Lino.chars2width(11), "colIndex": 9, "sortable": false, "dataIndex": "owner", "header": "Contr\u00f4l\u00e9 par", "editable": false } ];
    Lino.postings.PostingsPrinted.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.postings.PostingsPrinted.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.postings.PostingsPrinted.GridPanel(p);
});
Lino.postings.PostingsPrinted.print_action = function(rp,pk) { 
  Lino.run_row_action(rp,"/postings/PostingsPrinted",pk,"print_action");
};

// js_render_GridPanel_class postings.PostingsSent
Lino.postings.PostingsSent.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "No data to display." },
  ls_url : "/postings/PostingsSent",
  ls_bbar_actions : [ { "itemId": null, "menu_item_text": "Supprimer", "tooltip": "Delete this record", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "Supprimer", "auto_save": false }, { "itemId": "print_action", "menu_item_text": "Imprimer", "must_save": true, "tooltip": "Imprimer", "panel_btn_handler": Lino.row_action_handler('print_action','GET'), "iconCls": "x-tbar-print", "overflowText": "Imprimer", "auto_save": true } ],
  title : "Envois postaux envoy\u00e9s",
  page_length : 20,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "type": "date", "name": "date", "dateFormat": "d.m.Y" }, { "name": "user" }, 'userHidden', { "name": "partner" }, 'partnerHidden', { "name": "workflow_buttons" }, { "type": "int", "name": "id" }, { "name": "owner_type" }, 'owner_typeHidden', { "name": "owner_id" }, 'owner_idHidden', { "name": "project" }, 'projectHidden', { "name": "state" }, 'stateHidden', { "name": "owner" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 6,
  ls_grid_configs : [  ],
  content_type : 38,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 17,
  initComponent : function() {
    var ww = this.containing_window;
    var date2685 = new Lino.DateField({ "selectOnFocus": true, "allowBlank": false });
    var user2686 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/postings/PostingsSent/user", "method": "GET" }) }), "pageSize": 20, "emptyText": "Choisir Utilisateur..." });
    var partner2687 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/postings/PostingsSent/partner", "method": "GET" }) }), "pageSize": 20, "emptyText": "Choisir Partenaire..." });
    var workflow_buttons_disp2688 = new Ext.form.DisplayField({ "disabled": true, "value": "<br/>", "always_enabled": true });
    var id2689 = new Ext.form.NumberField({ "selectOnFocus": true });
    var owner_type2690 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/postings/PostingsSent/owner_type", "method": "GET" }) }), "pageSize": 20, "emptyText": "Choisir type de contenu..." });
    var owner_id2691 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/postings/PostingsSent/owner_id", "method": "GET" }) }) });
    var project2692 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/postings/PostingsSent/project", "method": "GET" }) }), "pageSize": 20, "emptyText": "Choisir Client..." });
    var state2693 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "forceSelection": true, "allowBlank": false, "store": Lino.postings.PostingStates });
    var owner_disp2694 = new Ext.form.DisplayField({ "disabled": true });
    this.before_row_edit = function(record) {
      owner_id2691.setContextValue('owner_type',record ? record.data['owner_typeHidden'] : undefined);
    };
    this.onRender = function(ct, position) {
      owner_type2690.on('change',Lino.chooser_handler(owner_id2691,'owner_type'));
      Lino.postings.PostingsSent.GridPanel.superclass.onRender.call(this, ct, position);
    }
    this.ls_columns = [ { "colIndex": 0, "sortable": true, "xtype": "datecolumn", "format": "d.m.Y", "editable": true, "filter": { "type": "date", "dateFormat": "d.m.Y" }, "header": "date", "editor": date2685, "width": Lino.chars2width(9), "dataIndex": "date" }, { "colIndex": 1, "sortable": true, "header": "Auteur", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(16), "dataIndex": "user", "editor": user2686 }, { "colIndex": 2, "sortable": true, "header": "Destinataire", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('partnerHidden','Lino.contacts.Partners.detail'), "editor": partner2687, "dataIndex": "partner" }, { "width": Lino.chars2width(31), "colIndex": 3, "sortable": false, "dataIndex": "workflow_buttons", "header": "Arbeitsablauf", "editable": false }, new Lino.NullNumberColumn({ "colIndex": 4, "sortable": true, "format": "0", "editable": true, "filter": { "type": "numeric" }, "header": "ID", "renderer": Lino.id_renderer, "editor": id2689, "width": Lino.chars2width(6), "dataIndex": "id" }), { "colIndex": 5, "sortable": true, "header": "Contr\u00f4l\u00e9 par (type)", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "owner_type", "editor": owner_type2690 }, { "colIndex": 6, "sortable": true, "header": "Contr\u00f4l\u00e9 par (object)", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(11), "dataIndex": "owner_id", "editor": owner_id2691 }, { "colIndex": 7, "sortable": true, "header": "Client", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('projectHidden','Lino.pcsw.Clients.detail'), "editor": project2692, "dataIndex": "project" }, { "colIndex": 8, "sortable": true, "header": "State", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(23), "dataIndex": "state", "editor": state2693 }, { "width": Lino.chars2width(11), "colIndex": 9, "sortable": false, "dataIndex": "owner", "header": "Contr\u00f4l\u00e9 par", "editable": false } ];
    Lino.postings.PostingsSent.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.postings.PostingsSent.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.postings.PostingsSent.GridPanel(p);
});
Lino.postings.PostingsSent.print_action = function(rp,pk) { 
  Lino.run_row_action(rp,"/postings/PostingsSent",pk,"print_action");
};

// js_render_GridPanel_class cal.MyEvents
Lino.cal.MyEvents.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "No data to display." },
  ls_url : "/cal/MyEvents",
  ls_bbar_actions : [ { "itemId": "insert", "menu_item_text": "Nouveau", "must_save": true, "tooltip": "Insert a new record", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-new", "overflowText": "Nouveau", "auto_save": true }, { "itemId": "duplicate", "menu_item_text": "Dupliquer", "must_save": true, "tooltip": "Dupliquer", "panel_btn_handler": Lino.row_action_handler('duplicate','GET'), "iconCls": "x-tbar-duplicate", "overflowText": "Dupliquer", "auto_save": true }, { "itemId": "detail", "menu_item_text": "D\u00e9tail", "tooltip": "Open a detail window on this record", "panel_btn_handler": Lino.show_detail, "iconCls": "x-tbar-detail", "overflowText": "D\u00e9tail", "auto_save": true }, { "itemId": null, "menu_item_text": "Supprimer", "tooltip": "Delete this record", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "Supprimer", "auto_save": false }, { "itemId": "do_print", "menu_item_text": "Imprimer", "must_save": true, "tooltip": "Imprimer", "panel_btn_handler": Lino.row_action_handler('do_print','GET'), "iconCls": "x-tbar-print", "overflowText": "Imprimer", "auto_save": true }, { "itemId": "do_clear_cache", "menu_item_text": "Effacer la cache", "must_save": true, "tooltip": "Effacer la cache", "panel_btn_handler": Lino.row_action_handler('do_clear_cache','GET'), "iconCls": "x-tbar-clearcache", "overflowText": "Effacer la cache", "auto_save": true }, { "itemId": "create_postings", "menu_item_text": "C\u00e9er envoi postal", "must_save": true, "tooltip": "Create classical mail postings from this", "panel_btn_handler": Lino.row_action_handler('create_postings','GET'), "iconCls": "x-tbar-create-postings", "overflowText": "C\u00e9er envoi postal", "auto_save": true } ],
  title : "Events",
  page_length : 20,
  params_panel_hidden : true,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "type": "date", "name": "start_date", "dateFormat": "d.m.Y" }, { "name": "start_time" }, { "name": "calendar" }, 'calendarHidden', { "name": "project" }, 'projectHidden', { "name": "summary" }, { "type": "int", "name": "id" }, { "name": "owner_type" }, 'owner_typeHidden', { "name": "owner_id" }, 'owner_idHidden', { "name": "user" }, 'userHidden', { "name": "created" }, { "name": "modified" }, { "name": "build_time" }, { "type": "date", "name": "end_date", "dateFormat": "d.m.Y" }, { "name": "end_time" }, { "name": "description" }, { "name": "uid" }, { "name": "access_class" }, 'access_classHidden', { "type": "int", "name": "sequence" }, { "type": "int", "name": "auto_type" }, { "type": "boolean", "name": "transparent" }, { "name": "place" }, 'placeHidden', { "name": "priority" }, 'priorityHidden', { "name": "state" }, 'stateHidden', { "name": "assigned_to" }, 'assigned_toHidden', { "name": "owner" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 7,
  ls_grid_configs : [  ],
  content_type : 36,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 36,
  initComponent : function() {
    this.ls_detail_handler = Lino.cal.MyEvents.detail;
    this.ls_insert_handler = Lino.cal.MyEvents.insert;
    var ww = this.containing_window;
    var start_date2696 = new Lino.DateField({ "selectOnFocus": true });
    var start_time2697 = new Lino.TimeField({ "selectOnFocus": true });
    var calendar2698 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/MyEvents/calendar", "method": "GET" }) }), "pageSize": 20, "emptyText": "Choisir Calendrier..." });
    var project2699 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/MyEvents/project", "method": "GET" }) }), "pageSize": 20, "emptyText": "Choisir Client..." });
    var summary2700 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var id2701 = new Ext.form.NumberField({ "selectOnFocus": true });
    var owner_type2702 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/MyEvents/owner_type", "method": "GET" }) }), "pageSize": 20, "emptyText": "Choisir type de contenu..." });
    var owner_id2703 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/MyEvents/owner_id", "method": "GET" }) }) });
    var user2704 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/MyEvents/user", "method": "GET" }) }), "pageSize": 20, "emptyText": "Choisir Utilisateur..." });
    var created2705 = new Ext.form.DisplayField({ "disabled": true, "value": "<br>" });
    var modified2706 = new Ext.form.DisplayField({ "disabled": true, "value": "<br>" });
    var build_time2707 = new Ext.form.DisplayField({ "disabled": true, "value": "<br>" });
    var end_date2708 = new Lino.DateField({ "selectOnFocus": true });
    var end_time2709 = new Lino.TimeField({ "selectOnFocus": true });
    var description2710 = new Lino.RichTextPanel({ "selectOnFocus": true, "containing_panel": this, "title": "Description" });
    var uid2711 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var access_class2712 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "forceSelection": true, "store": Lino.cal.AccessClasses });
    var sequence2713 = new Ext.form.NumberField({ "selectOnFocus": true, "allowBlank": false, "value": 0 });
    var auto_type2714 = new Ext.form.NumberField({ "disabled": true });
    var transparent2715 = new Ext.form.Checkbox({ "selectOnFocus": true, "checked": false });
    var place2716 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/MyEvents/place", "method": "GET" }) }), "pageSize": 20, "emptyText": "Choisir Room..." });
    var priority2717 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/MyEvents/priority", "method": "GET" }) }), "pageSize": 20, "emptyText": "Choisir Priorit\u00e9..." });
    var state2718 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "forceSelection": true, "allowBlank": false, "store": Lino.cal.EventStates });
    var assigned_to2719 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/MyEvents/assigned_to", "method": "GET" }) }), "pageSize": 20, "emptyText": "Choisir Utilisateur..." });
    var owner_disp2720 = new Ext.form.DisplayField({ "disabled": true });
    this.before_row_edit = function(record) {
      owner_id2703.setContextValue('owner_type',record ? record.data['owner_typeHidden'] : undefined);
      description2710.refresh();
    };
    this.onRender = function(ct, position) {
      owner_type2702.on('change',Lino.chooser_handler(owner_id2703,'owner_type'));
      Lino.cal.MyEvents.GridPanel.superclass.onRender.call(this, ct, position);
    }
    this.ls_columns = [ { "colIndex": 0, "sortable": true, "xtype": "datecolumn", "format": "d.m.Y", "editable": true, "filter": { "type": "date", "dateFormat": "d.m.Y" }, "header": "Date d\u00e9but", "editor": start_date2696, "width": Lino.chars2width(9), "dataIndex": "start_date" }, { "width": Lino.chars2width(9), "colIndex": 1, "sortable": true, "dataIndex": "start_time", "header": "Heure de d\u00e9but", "editable": true, "editor": start_time2697 }, { "colIndex": 2, "sortable": true, "header": "Calendrier", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "calendar", "editor": calendar2698 }, { "colIndex": 3, "sortable": true, "header": "Client", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('projectHidden','Lino.pcsw.Clients.detail'), "editor": project2699, "dataIndex": "project" }, { "colIndex": 4, "sortable": true, "header": "R\u00e9sum\u00e9", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "summary", "editor": summary2700 }, new Lino.NullNumberColumn({ "colIndex": 5, "sortable": true, "format": "0", "editable": true, "filter": { "type": "numeric" }, "header": "ID", "renderer": Lino.id_renderer, "editor": id2701, "width": Lino.chars2width(6), "dataIndex": "id" }), { "colIndex": 6, "sortable": true, "header": "Contr\u00f4l\u00e9 par (type)", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "owner_type", "hidden": true, "editor": owner_type2702 }, { "colIndex": 7, "sortable": true, "header": "Contr\u00f4l\u00e9 par (object)", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(11), "dataIndex": "owner_id", "hidden": true, "editor": owner_id2703 }, { "colIndex": 8, "sortable": true, "header": "Responsible user", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(16), "dataIndex": "user", "editor": user2704 }, { "width": Lino.chars2width(17), "colIndex": 9, "sortable": true, "dataIndex": "created", "header": "Cr\u00e9\u00e9", "hidden": true, "editable": false }, { "width": Lino.chars2width(17), "colIndex": 10, "sortable": true, "dataIndex": "modified", "header": "Modified", "hidden": true, "editable": false }, { "width": Lino.chars2width(17), "colIndex": 11, "sortable": true, "dataIndex": "build_time", "header": "build time", "hidden": true, "editable": false }, { "colIndex": 12, "sortable": true, "xtype": "datecolumn", "format": "d.m.Y", "editable": true, "filter": { "type": "date", "dateFormat": "d.m.Y" }, "header": "Date de fin", "dataIndex": "end_date", "hidden": true, "width": Lino.chars2width(9), "editor": end_date2708 }, { "colIndex": 13, "sortable": true, "header": "Heure de fin", "editable": true, "width": Lino.chars2width(9), "dataIndex": "end_time", "hidden": true, "editor": end_time2709 }, { "colIndex": 14, "sortable": false, "header": "description", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(61), "renderer": Lino.text_renderer, "hidden": true, "editor": description2710, "dataIndex": "description" }, { "colIndex": 15, "sortable": true, "header": "UID", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "uid", "hidden": true, "editor": uid2711 }, { "colIndex": 16, "sortable": true, "header": "Classe d'acc\u00e8s", "editable": true, "tooltip": "Public, priv\u00e9 ou \"marquer occup\u00e9\".", "filter": { "type": "string" }, "width": Lino.chars2width(35), "dataIndex": "access_class", "hidden": true, "editor": access_class2712 }, new Lino.NullNumberColumn({ "colIndex": 17, "sortable": true, "format": "0", "editable": true, "filter": { "type": "numeric" }, "header": "Version", "dataIndex": "sequence", "hidden": true, "width": Lino.chars2width(6), "editor": sequence2713 }), new Lino.NullNumberColumn({ "colIndex": 18, "sortable": true, "format": "0", "editable": false, "filter": { "type": "numeric" }, "header": "auto type", "dataIndex": "auto_type", "hidden": true, "width": Lino.chars2width(6) }), { "colIndex": 19, "sortable": false, "xtype": "checkcolumn", "header": "non bloquant", "editable": true, "tooltip": "Indique que ce rendez-vous n'emp\u00eache pas d'avoir d'autres rendez-vous en m\u00eame temps.", "filter": { "type": "boolean" }, "width": Lino.chars2width(11), "dataIndex": "transparent", "hidden": true }, { "colIndex": 20, "sortable": true, "header": "Room", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "place", "hidden": true, "editor": place2716 }, { "colIndex": 21, "sortable": true, "header": "Priorit\u00e9", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "priority", "hidden": true, "editor": priority2717 }, { "colIndex": 22, "sortable": true, "header": "State", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(17), "dataIndex": "state", "editor": state2718 }, { "colIndex": 23, "sortable": true, "header": "Attribu\u00e9 \u00e0", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(16), "dataIndex": "assigned_to", "editor": assigned_to2719 }, { "width": Lino.chars2width(11), "colIndex": 24, "sortable": false, "dataIndex": "owner", "header": "Contr\u00f4l\u00e9 par", "hidden": true, "editable": false } ];
    Lino.cal.MyEvents.GridPanel.superclass.initComponent.call(this);
  }
});


Lino.cal.MyEvents.insertPanel = Ext.extend(Lino.cal.MyEvents.InsertFormPanel,{
  empty_title: "Nouveau Events",
  hide_navigator: true,
  params_panel_hidden: true,
  ls_bbar_actions: [ { "itemId": "post", "menu_item_text": "Cr\u00e9er", "tooltip": "Create the record and open a detail window on it", "panel_btn_handler": function(panel){panel.save(null,true,'post')}, "text": "Cr\u00e9er", "overflowText": "Cr\u00e9er", "auto_save": false }, { "itemId": "poststay", "menu_item_text": "Create without detail", "tooltip": "Don't open a detail window on the new record", "panel_btn_handler": function(panel){panel.save(null,false,'poststay')}, "text": "Create without detail", "overflowText": "Create without detail", "auto_save": false } ],
  ls_url: "/cal/MyEvents",
  action_name: "insert",
  initComponent : function() {
    this.ls_detail_handler = Lino.cal.MyEvents.detail;
    this.ls_insert_handler = Lino.cal.MyEvents.insert;
    Lino.cal.MyEvents.insertPanel.superclass.initComponent.call(this);
  }
});

Lino.cal.MyEvents.insert = new Lino.WindowAction({ "draggable": true, "width": Lino.chars2width(60), "autoHeight": true, "maximizable": true, "modal": true, "maximized": false },function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.cal.MyEvents.insertPanel(p);
});
Lino.cal.MyEvents.wf1 = function(rp,pk) { 
  Lino.run_row_action(rp,"/cal/MyEvents",pk,"wf1");
};
Lino.cal.MyEvents.wf2 = function(rp,pk) { 
  Lino.run_row_action(rp,"/cal/MyEvents",pk,"wf2");
};
Lino.cal.MyEvents.wf3 = function(rp,pk) { 
  Lino.run_row_action(rp,"/cal/MyEvents",pk,"wf3");
};
Lino.cal.MyEvents.wf4 = function(rp,pk) { 
  Lino.run_row_action(rp,"/cal/MyEvents",pk,"wf4");
};
Lino.cal.MyEvents.wf5 = function(rp,pk) { 
  Lino.run_row_action(rp,"/cal/MyEvents",pk,"wf5");
};
Lino.cal.MyEvents.wf6 = function(rp,pk) { 
  Lino.run_row_action(rp,"/cal/MyEvents",pk,"wf6");
};
Lino.cal.MyEvents.wf7 = function(rp,pk) { 
  Lino.run_row_action(rp,"/cal/MyEvents",pk,"wf7");
};
Lino.cal.MyEvents.wf8 = function(rp,pk) { 
  Lino.run_row_action(rp,"/cal/MyEvents",pk,"wf8");
};

Lino.cal.MyEvents.detailPanel = Ext.extend(Lino.cal.MyEvents.DetailFormPanel,{
  empty_title: "D\u00e9tail Events",
  params_panel_hidden: true,
  ls_bbar_actions: [ { "itemId": "put", "menu_item_text": "Enregistrer", "tooltip": "Save changes in this form", "panel_btn_handler": function(panel){panel.save(null,false,'put')}, "iconCls": "x-tbar-save", "overflowText": "Enregistrer", "auto_save": false }, { "itemId": "insert", "menu_item_text": "Nouveau", "must_save": true, "tooltip": "Insert a new record", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-new", "overflowText": "Nouveau", "auto_save": true }, { "itemId": "duplicate", "menu_item_text": "Dupliquer", "must_save": true, "tooltip": "Dupliquer", "panel_btn_handler": Lino.row_action_handler('duplicate','GET'), "iconCls": "x-tbar-duplicate", "overflowText": "Dupliquer", "auto_save": true }, { "itemId": null, "menu_item_text": "Supprimer", "tooltip": "Delete this record", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "Supprimer", "auto_save": false }, { "itemId": "do_print", "menu_item_text": "Imprimer", "must_save": true, "tooltip": "Imprimer", "panel_btn_handler": Lino.row_action_handler('do_print','GET'), "iconCls": "x-tbar-print", "overflowText": "Imprimer", "auto_save": true }, { "itemId": "do_clear_cache", "menu_item_text": "Effacer la cache", "must_save": true, "tooltip": "Effacer la cache", "panel_btn_handler": Lino.row_action_handler('do_clear_cache','GET'), "iconCls": "x-tbar-clearcache", "overflowText": "Effacer la cache", "auto_save": true }, { "itemId": "create_postings", "menu_item_text": "C\u00e9er envoi postal", "must_save": true, "tooltip": "Create classical mail postings from this", "panel_btn_handler": Lino.row_action_handler('create_postings','GET'), "iconCls": "x-tbar-create-postings", "overflowText": "C\u00e9er envoi postal", "auto_save": true } ],
  ls_url: "/cal/MyEvents",
  action_name: "detail",
  initComponent : function() {
    this.ls_detail_handler = Lino.cal.MyEvents.detail;
    this.ls_insert_handler = Lino.cal.MyEvents.insert;
    Lino.cal.MyEvents.detailPanel.superclass.initComponent.call(this);
  }
});

Lino.cal.MyEvents.detail = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.cal.MyEvents.detailPanel(p);
});
Lino.cal.MyEvents.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  p.params_panel = new Lino.cal.MyEvents.ParamsPanel({});
  return new Lino.cal.MyEvents.GridPanel(p);
});
Lino.cal.MyEvents.take = function(rp,pk) { 
  Lino.run_row_action(rp,"/cal/MyEvents",pk,"take");
};

// js_render_GridPanel_class cal.MyUnclearEvents
Lino.cal.MyUnclearEvents.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "No data to display." },
  ls_url : "/cal/MyUnclearEvents",
  ls_bbar_actions : [ { "itemId": "insert", "menu_item_text": "Nouveau", "must_save": true, "tooltip": "Insert a new record", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-new", "overflowText": "Nouveau", "auto_save": true }, { "itemId": "duplicate", "menu_item_text": "Dupliquer", "must_save": true, "tooltip": "Dupliquer", "panel_btn_handler": Lino.row_action_handler('duplicate','GET'), "iconCls": "x-tbar-duplicate", "overflowText": "Dupliquer", "auto_save": true }, { "itemId": "detail", "menu_item_text": "D\u00e9tail", "tooltip": "Open a detail window on this record", "panel_btn_handler": Lino.show_detail, "iconCls": "x-tbar-detail", "overflowText": "D\u00e9tail", "auto_save": true }, { "itemId": null, "menu_item_text": "Supprimer", "tooltip": "Delete this record", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "Supprimer", "auto_save": false }, { "itemId": "do_print", "menu_item_text": "Imprimer", "must_save": true, "tooltip": "Imprimer", "panel_btn_handler": Lino.row_action_handler('do_print','GET'), "iconCls": "x-tbar-print", "overflowText": "Imprimer", "auto_save": true }, { "itemId": "do_clear_cache", "menu_item_text": "Effacer la cache", "must_save": true, "tooltip": "Effacer la cache", "panel_btn_handler": Lino.row_action_handler('do_clear_cache','GET'), "iconCls": "x-tbar-clearcache", "overflowText": "Effacer la cache", "auto_save": true }, { "itemId": "create_postings", "menu_item_text": "C\u00e9er envoi postal", "must_save": true, "tooltip": "Create classical mail postings from this", "panel_btn_handler": Lino.row_action_handler('create_postings','GET'), "iconCls": "x-tbar-create-postings", "overflowText": "C\u00e9er envoi postal", "auto_save": true } ],
  title : "Mes rendez-vous \u00e0 clarifier",
  page_length : 20,
  params_panel_hidden : true,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "type": "date", "name": "start_date", "dateFormat": "d.m.Y" }, { "name": "start_time" }, { "name": "project" }, 'projectHidden', { "name": "summary" }, { "name": "workflow_buttons" }, { "type": "int", "name": "id" }, { "name": "owner_type" }, 'owner_typeHidden', { "name": "owner_id" }, 'owner_idHidden', { "name": "user" }, 'userHidden', { "name": "created" }, { "name": "modified" }, { "name": "build_time" }, { "type": "date", "name": "end_date", "dateFormat": "d.m.Y" }, { "name": "end_time" }, { "name": "description" }, { "name": "uid" }, { "name": "calendar" }, 'calendarHidden', { "name": "access_class" }, 'access_classHidden', { "type": "int", "name": "sequence" }, { "type": "int", "name": "auto_type" }, { "type": "boolean", "name": "transparent" }, { "name": "place" }, 'placeHidden', { "name": "priority" }, 'priorityHidden', { "name": "state" }, 'stateHidden', { "name": "assigned_to" }, 'assigned_toHidden', { "name": "owner" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 6,
  ls_grid_configs : [  ],
  content_type : 36,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 37,
  initComponent : function() {
    this.ls_detail_handler = Lino.cal.MyUnclearEvents.detail;
    this.ls_insert_handler = Lino.cal.MyUnclearEvents.insert;
    var ww = this.containing_window;
    var start_date2722 = new Lino.DateField({ "selectOnFocus": true });
    var start_time2723 = new Lino.TimeField({ "selectOnFocus": true });
    var project2724 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/MyUnclearEvents/project", "method": "GET" }) }), "pageSize": 20, "emptyText": "Choisir Client..." });
    var summary2725 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var workflow_buttons_disp2726 = new Ext.form.DisplayField({ "disabled": true, "value": "<br/>", "always_enabled": true });
    var id2727 = new Ext.form.NumberField({ "selectOnFocus": true });
    var owner_type2728 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/MyUnclearEvents/owner_type", "method": "GET" }) }), "pageSize": 20, "emptyText": "Choisir type de contenu..." });
    var owner_id2729 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/MyUnclearEvents/owner_id", "method": "GET" }) }) });
    var user2730 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/MyUnclearEvents/user", "method": "GET" }) }), "pageSize": 20, "emptyText": "Choisir Utilisateur..." });
    var created2731 = new Ext.form.DisplayField({ "disabled": true, "value": "<br>" });
    var modified2732 = new Ext.form.DisplayField({ "disabled": true, "value": "<br>" });
    var build_time2733 = new Ext.form.DisplayField({ "disabled": true, "value": "<br>" });
    var end_date2734 = new Lino.DateField({ "selectOnFocus": true });
    var end_time2735 = new Lino.TimeField({ "selectOnFocus": true });
    var description2736 = new Lino.RichTextPanel({ "selectOnFocus": true, "containing_panel": this, "title": "Description" });
    var uid2737 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var calendar2738 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/MyUnclearEvents/calendar", "method": "GET" }) }), "pageSize": 20, "emptyText": "Choisir Calendrier..." });
    var access_class2739 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "forceSelection": true, "store": Lino.cal.AccessClasses });
    var sequence2740 = new Ext.form.NumberField({ "selectOnFocus": true, "allowBlank": false, "value": 0 });
    var auto_type2741 = new Ext.form.NumberField({ "disabled": true });
    var transparent2742 = new Ext.form.Checkbox({ "selectOnFocus": true, "checked": false });
    var place2743 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/MyUnclearEvents/place", "method": "GET" }) }), "pageSize": 20, "emptyText": "Choisir Room..." });
    var priority2744 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/MyUnclearEvents/priority", "method": "GET" }) }), "pageSize": 20, "emptyText": "Choisir Priorit\u00e9..." });
    var state2745 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "forceSelection": true, "allowBlank": false, "store": Lino.cal.EventStates });
    var assigned_to2746 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/MyUnclearEvents/assigned_to", "method": "GET" }) }), "pageSize": 20, "emptyText": "Choisir Utilisateur..." });
    var owner_disp2747 = new Ext.form.DisplayField({ "disabled": true });
    this.before_row_edit = function(record) {
      owner_id2729.setContextValue('owner_type',record ? record.data['owner_typeHidden'] : undefined);
      description2736.refresh();
    };
    this.onRender = function(ct, position) {
      owner_type2728.on('change',Lino.chooser_handler(owner_id2729,'owner_type'));
      Lino.cal.MyUnclearEvents.GridPanel.superclass.onRender.call(this, ct, position);
    }
    this.ls_columns = [ { "colIndex": 0, "sortable": true, "xtype": "datecolumn", "format": "d.m.Y", "editable": true, "filter": { "type": "date", "dateFormat": "d.m.Y" }, "header": "Date d\u00e9but", "editor": start_date2722, "width": Lino.chars2width(9), "dataIndex": "start_date" }, { "width": Lino.chars2width(9), "colIndex": 1, "sortable": true, "dataIndex": "start_time", "header": "Heure de d\u00e9but", "editable": true, "editor": start_time2723 }, { "colIndex": 2, "sortable": true, "header": "Client", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('projectHidden','Lino.pcsw.Clients.detail'), "editor": project2724, "dataIndex": "project" }, { "colIndex": 3, "sortable": true, "header": "R\u00e9sum\u00e9", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "summary", "editor": summary2725 }, { "width": Lino.chars2width(31), "colIndex": 4, "sortable": false, "dataIndex": "workflow_buttons", "header": "Arbeitsablauf", "editable": false }, new Lino.NullNumberColumn({ "colIndex": 5, "sortable": true, "format": "0", "editable": true, "filter": { "type": "numeric" }, "header": "ID", "renderer": Lino.id_renderer, "editor": id2727, "width": Lino.chars2width(6), "dataIndex": "id" }), { "colIndex": 6, "sortable": true, "header": "Contr\u00f4l\u00e9 par (type)", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "owner_type", "hidden": true, "editor": owner_type2728 }, { "colIndex": 7, "sortable": true, "header": "Contr\u00f4l\u00e9 par (object)", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(11), "dataIndex": "owner_id", "hidden": true, "editor": owner_id2729 }, { "colIndex": 8, "sortable": true, "header": "Responsible user", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(16), "dataIndex": "user", "editor": user2730 }, { "width": Lino.chars2width(17), "colIndex": 9, "sortable": true, "dataIndex": "created", "header": "Cr\u00e9\u00e9", "hidden": true, "editable": false }, { "width": Lino.chars2width(17), "colIndex": 10, "sortable": true, "dataIndex": "modified", "header": "Modified", "hidden": true, "editable": false }, { "width": Lino.chars2width(17), "colIndex": 11, "sortable": true, "dataIndex": "build_time", "header": "build time", "hidden": true, "editable": false }, { "colIndex": 12, "sortable": true, "xtype": "datecolumn", "format": "d.m.Y", "editable": true, "filter": { "type": "date", "dateFormat": "d.m.Y" }, "header": "Date de fin", "dataIndex": "end_date", "hidden": true, "width": Lino.chars2width(9), "editor": end_date2734 }, { "colIndex": 13, "sortable": true, "header": "Heure de fin", "editable": true, "width": Lino.chars2width(9), "dataIndex": "end_time", "hidden": true, "editor": end_time2735 }, { "colIndex": 14, "sortable": false, "header": "description", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(61), "renderer": Lino.text_renderer, "hidden": true, "editor": description2736, "dataIndex": "description" }, { "colIndex": 15, "sortable": true, "header": "UID", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "uid", "hidden": true, "editor": uid2737 }, { "colIndex": 16, "sortable": true, "header": "Calendrier", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "calendar", "editor": calendar2738 }, { "colIndex": 17, "sortable": true, "header": "Classe d'acc\u00e8s", "editable": true, "tooltip": "Public, priv\u00e9 ou \"marquer occup\u00e9\".", "filter": { "type": "string" }, "width": Lino.chars2width(35), "dataIndex": "access_class", "hidden": true, "editor": access_class2739 }, new Lino.NullNumberColumn({ "colIndex": 18, "sortable": true, "format": "0", "editable": true, "filter": { "type": "numeric" }, "header": "Version", "dataIndex": "sequence", "hidden": true, "width": Lino.chars2width(6), "editor": sequence2740 }), new Lino.NullNumberColumn({ "colIndex": 19, "sortable": true, "format": "0", "editable": false, "filter": { "type": "numeric" }, "header": "auto type", "dataIndex": "auto_type", "hidden": true, "width": Lino.chars2width(6) }), { "colIndex": 20, "sortable": false, "xtype": "checkcolumn", "header": "non bloquant", "editable": true, "tooltip": "Indique que ce rendez-vous n'emp\u00eache pas d'avoir d'autres rendez-vous en m\u00eame temps.", "filter": { "type": "boolean" }, "width": Lino.chars2width(11), "dataIndex": "transparent", "hidden": true }, { "colIndex": 21, "sortable": true, "header": "Room", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "place", "hidden": true, "editor": place2743 }, { "colIndex": 22, "sortable": true, "header": "Priorit\u00e9", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "priority", "hidden": true, "editor": priority2744 }, { "colIndex": 23, "sortable": true, "header": "State", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(17), "dataIndex": "state", "editor": state2745 }, { "colIndex": 24, "sortable": true, "header": "Attribu\u00e9 \u00e0", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(16), "dataIndex": "assigned_to", "editor": assigned_to2746 }, { "width": Lino.chars2width(11), "colIndex": 25, "sortable": false, "dataIndex": "owner", "header": "Contr\u00f4l\u00e9 par", "hidden": true, "editable": false } ];
    Lino.cal.MyUnclearEvents.GridPanel.superclass.initComponent.call(this);
  }
});


Lino.cal.MyUnclearEvents.insertPanel = Ext.extend(Lino.cal.MyEvents.InsertFormPanel,{
  empty_title: "Nouveau Mes rendez-vous \u00e0 clarifier",
  hide_navigator: true,
  params_panel_hidden: true,
  ls_bbar_actions: [ { "itemId": "post", "menu_item_text": "Cr\u00e9er", "tooltip": "Create the record and open a detail window on it", "panel_btn_handler": function(panel){panel.save(null,true,'post')}, "text": "Cr\u00e9er", "overflowText": "Cr\u00e9er", "auto_save": false }, { "itemId": "poststay", "menu_item_text": "Create without detail", "tooltip": "Don't open a detail window on the new record", "panel_btn_handler": function(panel){panel.save(null,false,'poststay')}, "text": "Create without detail", "overflowText": "Create without detail", "auto_save": false } ],
  ls_url: "/cal/MyUnclearEvents",
  action_name: "insert",
  initComponent : function() {
    this.ls_detail_handler = Lino.cal.MyUnclearEvents.detail;
    this.ls_insert_handler = Lino.cal.MyUnclearEvents.insert;
    Lino.cal.MyUnclearEvents.insertPanel.superclass.initComponent.call(this);
  }
});

Lino.cal.MyUnclearEvents.insert = new Lino.WindowAction({ "draggable": true, "width": Lino.chars2width(60), "autoHeight": true, "maximizable": true, "modal": true, "maximized": false },function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.cal.MyUnclearEvents.insertPanel(p);
});
Lino.cal.MyUnclearEvents.wf1 = function(rp,pk) { 
  Lino.run_row_action(rp,"/cal/MyUnclearEvents",pk,"wf1");
};
Lino.cal.MyUnclearEvents.wf2 = function(rp,pk) { 
  Lino.run_row_action(rp,"/cal/MyUnclearEvents",pk,"wf2");
};
Lino.cal.MyUnclearEvents.wf3 = function(rp,pk) { 
  Lino.run_row_action(rp,"/cal/MyUnclearEvents",pk,"wf3");
};
Lino.cal.MyUnclearEvents.wf4 = function(rp,pk) { 
  Lino.run_row_action(rp,"/cal/MyUnclearEvents",pk,"wf4");
};
Lino.cal.MyUnclearEvents.wf5 = function(rp,pk) { 
  Lino.run_row_action(rp,"/cal/MyUnclearEvents",pk,"wf5");
};
Lino.cal.MyUnclearEvents.wf6 = function(rp,pk) { 
  Lino.run_row_action(rp,"/cal/MyUnclearEvents",pk,"wf6");
};
Lino.cal.MyUnclearEvents.wf7 = function(rp,pk) { 
  Lino.run_row_action(rp,"/cal/MyUnclearEvents",pk,"wf7");
};
Lino.cal.MyUnclearEvents.wf8 = function(rp,pk) { 
  Lino.run_row_action(rp,"/cal/MyUnclearEvents",pk,"wf8");
};

Lino.cal.MyUnclearEvents.detailPanel = Ext.extend(Lino.cal.MyEvents.DetailFormPanel,{
  empty_title: "D\u00e9tail Mes rendez-vous \u00e0 clarifier",
  params_panel_hidden: true,
  ls_bbar_actions: [ { "itemId": "put", "menu_item_text": "Enregistrer", "tooltip": "Save changes in this form", "panel_btn_handler": function(panel){panel.save(null,false,'put')}, "iconCls": "x-tbar-save", "overflowText": "Enregistrer", "auto_save": false }, { "itemId": "insert", "menu_item_text": "Nouveau", "must_save": true, "tooltip": "Insert a new record", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-new", "overflowText": "Nouveau", "auto_save": true }, { "itemId": "duplicate", "menu_item_text": "Dupliquer", "must_save": true, "tooltip": "Dupliquer", "panel_btn_handler": Lino.row_action_handler('duplicate','GET'), "iconCls": "x-tbar-duplicate", "overflowText": "Dupliquer", "auto_save": true }, { "itemId": null, "menu_item_text": "Supprimer", "tooltip": "Delete this record", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "Supprimer", "auto_save": false }, { "itemId": "do_print", "menu_item_text": "Imprimer", "must_save": true, "tooltip": "Imprimer", "panel_btn_handler": Lino.row_action_handler('do_print','GET'), "iconCls": "x-tbar-print", "overflowText": "Imprimer", "auto_save": true }, { "itemId": "do_clear_cache", "menu_item_text": "Effacer la cache", "must_save": true, "tooltip": "Effacer la cache", "panel_btn_handler": Lino.row_action_handler('do_clear_cache','GET'), "iconCls": "x-tbar-clearcache", "overflowText": "Effacer la cache", "auto_save": true }, { "itemId": "create_postings", "menu_item_text": "C\u00e9er envoi postal", "must_save": true, "tooltip": "Create classical mail postings from this", "panel_btn_handler": Lino.row_action_handler('create_postings','GET'), "iconCls": "x-tbar-create-postings", "overflowText": "C\u00e9er envoi postal", "auto_save": true } ],
  ls_url: "/cal/MyUnclearEvents",
  action_name: "detail",
  initComponent : function() {
    this.ls_detail_handler = Lino.cal.MyUnclearEvents.detail;
    this.ls_insert_handler = Lino.cal.MyUnclearEvents.insert;
    Lino.cal.MyUnclearEvents.detailPanel.superclass.initComponent.call(this);
  }
});

Lino.cal.MyUnclearEvents.detail = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.cal.MyUnclearEvents.detailPanel(p);
});
Lino.cal.MyUnclearEvents.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  p.params_panel = new Lino.cal.MyEvents.ParamsPanel({});
  return new Lino.cal.MyUnclearEvents.GridPanel(p);
});
Lino.cal.MyUnclearEvents.take = function(rp,pk) { 
  Lino.run_row_action(rp,"/cal/MyUnclearEvents",pk,"take");
};

// js_render_GridPanel_class cal.EventsAssignedToMe
Lino.cal.EventsAssignedToMe.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "No data to display." },
  ls_url : "/cal/EventsAssignedToMe",
  ls_bbar_actions : [ { "itemId": "insert", "menu_item_text": "Nouveau", "must_save": true, "tooltip": "Insert a new record", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-new", "overflowText": "Nouveau", "auto_save": true }, { "itemId": "duplicate", "menu_item_text": "Dupliquer", "must_save": true, "tooltip": "Dupliquer", "panel_btn_handler": Lino.row_action_handler('duplicate','GET'), "iconCls": "x-tbar-duplicate", "overflowText": "Dupliquer", "auto_save": true }, { "itemId": "detail", "menu_item_text": "D\u00e9tail", "tooltip": "Open a detail window on this record", "panel_btn_handler": Lino.show_detail, "iconCls": "x-tbar-detail", "overflowText": "D\u00e9tail", "auto_save": true }, { "itemId": null, "menu_item_text": "Supprimer", "tooltip": "Delete this record", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "Supprimer", "auto_save": false }, { "itemId": "do_print", "menu_item_text": "Imprimer", "must_save": true, "tooltip": "Imprimer", "panel_btn_handler": Lino.row_action_handler('do_print','GET'), "iconCls": "x-tbar-print", "overflowText": "Imprimer", "auto_save": true }, { "itemId": "do_clear_cache", "menu_item_text": "Effacer la cache", "must_save": true, "tooltip": "Effacer la cache", "panel_btn_handler": Lino.row_action_handler('do_clear_cache','GET'), "iconCls": "x-tbar-clearcache", "overflowText": "Effacer la cache", "auto_save": true }, { "itemId": "create_postings", "menu_item_text": "C\u00e9er envoi postal", "must_save": true, "tooltip": "Create classical mail postings from this", "panel_btn_handler": Lino.row_action_handler('create_postings','GET'), "iconCls": "x-tbar-create-postings", "overflowText": "C\u00e9er envoi postal", "auto_save": true } ],
  title : "Events",
  page_length : 20,
  params_panel_hidden : true,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "type": "date", "name": "start_date", "dateFormat": "d.m.Y" }, { "name": "start_time" }, { "name": "project" }, 'projectHidden', { "name": "summary" }, { "name": "workflow_buttons" }, { "type": "int", "name": "id" }, { "name": "owner_type" }, 'owner_typeHidden', { "name": "owner_id" }, 'owner_idHidden', { "name": "user" }, 'userHidden', { "name": "created" }, { "name": "modified" }, { "name": "build_time" }, { "type": "date", "name": "end_date", "dateFormat": "d.m.Y" }, { "name": "end_time" }, { "name": "description" }, { "name": "uid" }, { "name": "calendar" }, 'calendarHidden', { "name": "access_class" }, 'access_classHidden', { "type": "int", "name": "sequence" }, { "type": "int", "name": "auto_type" }, { "type": "boolean", "name": "transparent" }, { "name": "place" }, 'placeHidden', { "name": "priority" }, 'priorityHidden', { "name": "state" }, 'stateHidden', { "name": "assigned_to" }, 'assigned_toHidden', { "name": "owner" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 6,
  ls_grid_configs : [  ],
  content_type : 36,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 37,
  initComponent : function() {
    this.ls_detail_handler = Lino.cal.EventsAssignedToMe.detail;
    this.ls_insert_handler = Lino.cal.EventsAssignedToMe.insert;
    var ww = this.containing_window;
    var start_date41 = new Lino.DateField({ "selectOnFocus": true });
    var start_time42 = new Lino.TimeField({ "selectOnFocus": true });
    var project43 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/EventsAssignedToMe/project", "method": "GET" }) }), "pageSize": 20, "emptyText": "Choisir Client..." });
    var summary44 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var workflow_buttons_disp45 = new Ext.form.DisplayField({ "disabled": true, "value": "<br/>", "always_enabled": true });
    var id46 = new Ext.form.NumberField({ "selectOnFocus": true });
    var owner_type47 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/EventsAssignedToMe/owner_type", "method": "GET" }) }), "pageSize": 20, "emptyText": "Choisir type de contenu..." });
    var owner_id48 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/EventsAssignedToMe/owner_id", "method": "GET" }) }) });
    var user49 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/EventsAssignedToMe/user", "method": "GET" }) }), "pageSize": 20, "emptyText": "Choisir Utilisateur..." });
    var created50 = new Ext.form.DisplayField({ "disabled": true, "value": "<br>" });
    var modified51 = new Ext.form.DisplayField({ "disabled": true, "value": "<br>" });
    var build_time52 = new Ext.form.DisplayField({ "disabled": true, "value": "<br>" });
    var end_date53 = new Lino.DateField({ "selectOnFocus": true });
    var end_time54 = new Lino.TimeField({ "selectOnFocus": true });
    var description55 = new Lino.RichTextPanel({ "selectOnFocus": true, "containing_panel": this, "title": "Description" });
    var uid56 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var calendar57 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/EventsAssignedToMe/calendar", "method": "GET" }) }), "pageSize": 20, "emptyText": "Choisir Calendrier..." });
    var access_class58 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "forceSelection": true, "store": Lino.cal.AccessClasses });
    var sequence59 = new Ext.form.NumberField({ "selectOnFocus": true, "allowBlank": false, "value": 0 });
    var auto_type60 = new Ext.form.NumberField({ "disabled": true });
    var transparent61 = new Ext.form.Checkbox({ "selectOnFocus": true, "checked": false });
    var place62 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/EventsAssignedToMe/place", "method": "GET" }) }), "pageSize": 20, "emptyText": "Choisir Room..." });
    var priority63 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/EventsAssignedToMe/priority", "method": "GET" }) }), "pageSize": 20, "emptyText": "Choisir Priorit\u00e9..." });
    var state64 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "forceSelection": true, "allowBlank": false, "store": Lino.cal.EventStates });
    var assigned_to65 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/EventsAssignedToMe/assigned_to", "method": "GET" }) }), "pageSize": 20, "emptyText": "Choisir Utilisateur..." });
    var owner_disp66 = new Ext.form.DisplayField({ "disabled": true });
    this.before_row_edit = function(record) {
      owner_id48.setContextValue('owner_type',record ? record.data['owner_typeHidden'] : undefined);
      description55.refresh();
    };
    this.onRender = function(ct, position) {
      owner_type47.on('change',Lino.chooser_handler(owner_id48,'owner_type'));
      Lino.cal.EventsAssignedToMe.GridPanel.superclass.onRender.call(this, ct, position);
    }
    this.ls_columns = [ { "colIndex": 0, "sortable": true, "xtype": "datecolumn", "format": "d.m.Y", "editable": true, "filter": { "type": "date", "dateFormat": "d.m.Y" }, "header": "Date d\u00e9but", "editor": start_date41, "width": Lino.chars2width(9), "dataIndex": "start_date" }, { "width": Lino.chars2width(9), "colIndex": 1, "sortable": true, "dataIndex": "start_time", "header": "Heure de d\u00e9but", "editable": true, "editor": start_time42 }, { "colIndex": 2, "sortable": true, "header": "Client", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('projectHidden','Lino.pcsw.Clients.detail'), "editor": project43, "dataIndex": "project" }, { "colIndex": 3, "sortable": true, "header": "R\u00e9sum\u00e9", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "summary", "editor": summary44 }, { "width": Lino.chars2width(31), "colIndex": 4, "sortable": false, "dataIndex": "workflow_buttons", "header": "Arbeitsablauf", "editable": false }, new Lino.NullNumberColumn({ "colIndex": 5, "sortable": true, "format": "0", "editable": true, "filter": { "type": "numeric" }, "header": "ID", "renderer": Lino.id_renderer, "editor": id46, "width": Lino.chars2width(6), "dataIndex": "id" }), { "colIndex": 6, "sortable": true, "header": "Contr\u00f4l\u00e9 par (type)", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "owner_type", "hidden": true, "editor": owner_type47 }, { "colIndex": 7, "sortable": true, "header": "Contr\u00f4l\u00e9 par (object)", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(11), "dataIndex": "owner_id", "hidden": true, "editor": owner_id48 }, { "colIndex": 8, "sortable": true, "header": "Responsible user", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(16), "dataIndex": "user", "editor": user49 }, { "width": Lino.chars2width(17), "colIndex": 9, "sortable": true, "dataIndex": "created", "header": "Cr\u00e9\u00e9", "hidden": true, "editable": false }, { "width": Lino.chars2width(17), "colIndex": 10, "sortable": true, "dataIndex": "modified", "header": "Modified", "hidden": true, "editable": false }, { "width": Lino.chars2width(17), "colIndex": 11, "sortable": true, "dataIndex": "build_time", "header": "build time", "hidden": true, "editable": false }, { "colIndex": 12, "sortable": true, "xtype": "datecolumn", "format": "d.m.Y", "editable": true, "filter": { "type": "date", "dateFormat": "d.m.Y" }, "header": "Date de fin", "dataIndex": "end_date", "hidden": true, "width": Lino.chars2width(9), "editor": end_date53 }, { "colIndex": 13, "sortable": true, "header": "Heure de fin", "editable": true, "width": Lino.chars2width(9), "dataIndex": "end_time", "hidden": true, "editor": end_time54 }, { "colIndex": 14, "sortable": false, "header": "description", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(61), "renderer": Lino.text_renderer, "hidden": true, "editor": description55, "dataIndex": "description" }, { "colIndex": 15, "sortable": true, "header": "UID", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "uid", "hidden": true, "editor": uid56 }, { "colIndex": 16, "sortable": true, "header": "Calendrier", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "calendar", "editor": calendar57 }, { "colIndex": 17, "sortable": true, "header": "Classe d'acc\u00e8s", "editable": true, "tooltip": "Public, priv\u00e9 ou \"marquer occup\u00e9\".", "filter": { "type": "string" }, "width": Lino.chars2width(35), "dataIndex": "access_class", "hidden": true, "editor": access_class58 }, new Lino.NullNumberColumn({ "colIndex": 18, "sortable": true, "format": "0", "editable": true, "filter": { "type": "numeric" }, "header": "Version", "dataIndex": "sequence", "hidden": true, "width": Lino.chars2width(6), "editor": sequence59 }), new Lino.NullNumberColumn({ "colIndex": 19, "sortable": true, "format": "0", "editable": false, "filter": { "type": "numeric" }, "header": "auto type", "dataIndex": "auto_type", "hidden": true, "width": Lino.chars2width(6) }), { "colIndex": 20, "sortable": false, "xtype": "checkcolumn", "header": "non bloquant", "editable": true, "tooltip": "Indique que ce rendez-vous n'emp\u00eache pas d'avoir d'autres rendez-vous en m\u00eame temps.", "filter": { "type": "boolean" }, "width": Lino.chars2width(11), "dataIndex": "transparent", "hidden": true }, { "colIndex": 21, "sortable": true, "header": "Room", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "place", "hidden": true, "editor": place62 }, { "colIndex": 22, "sortable": true, "header": "Priorit\u00e9", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "priority", "hidden": true, "editor": priority63 }, { "colIndex": 23, "sortable": true, "header": "State", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(17), "dataIndex": "state", "editor": state64 }, { "colIndex": 24, "sortable": true, "header": "Attribu\u00e9 \u00e0", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(16), "dataIndex": "assigned_to", "editor": assigned_to65 }, { "width": Lino.chars2width(11), "colIndex": 25, "sortable": false, "dataIndex": "owner", "header": "Contr\u00f4l\u00e9 par", "hidden": true, "editable": false } ];
    Lino.cal.EventsAssignedToMe.GridPanel.superclass.initComponent.call(this);
  }
});


Lino.cal.EventsAssignedToMe.insertPanel = Ext.extend(Lino.cal.MyEvents.InsertFormPanel,{
  empty_title: "Nouveau Events",
  hide_navigator: true,
  params_panel_hidden: true,
  ls_bbar_actions: [ { "itemId": "post", "menu_item_text": "Cr\u00e9er", "tooltip": "Create the record and open a detail window on it", "panel_btn_handler": function(panel){panel.save(null,true,'post')}, "text": "Cr\u00e9er", "overflowText": "Cr\u00e9er", "auto_save": false }, { "itemId": "poststay", "menu_item_text": "Create without detail", "tooltip": "Don't open a detail window on the new record", "panel_btn_handler": function(panel){panel.save(null,false,'poststay')}, "text": "Create without detail", "overflowText": "Create without detail", "auto_save": false } ],
  ls_url: "/cal/EventsAssignedToMe",
  action_name: "insert",
  initComponent : function() {
    this.ls_detail_handler = Lino.cal.EventsAssignedToMe.detail;
    this.ls_insert_handler = Lino.cal.EventsAssignedToMe.insert;
    Lino.cal.EventsAssignedToMe.insertPanel.superclass.initComponent.call(this);
  }
});

Lino.cal.EventsAssignedToMe.insert = new Lino.WindowAction({ "draggable": true, "width": Lino.chars2width(60), "autoHeight": true, "maximizable": true, "modal": true, "maximized": false },function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.cal.EventsAssignedToMe.insertPanel(p);
});
Lino.cal.EventsAssignedToMe.wf1 = function(rp,pk) { 
  Lino.run_row_action(rp,"/cal/EventsAssignedToMe",pk,"wf1");
};
Lino.cal.EventsAssignedToMe.wf2 = function(rp,pk) { 
  Lino.run_row_action(rp,"/cal/EventsAssignedToMe",pk,"wf2");
};
Lino.cal.EventsAssignedToMe.wf3 = function(rp,pk) { 
  Lino.run_row_action(rp,"/cal/EventsAssignedToMe",pk,"wf3");
};
Lino.cal.EventsAssignedToMe.wf4 = function(rp,pk) { 
  Lino.run_row_action(rp,"/cal/EventsAssignedToMe",pk,"wf4");
};
Lino.cal.EventsAssignedToMe.wf5 = function(rp,pk) { 
  Lino.run_row_action(rp,"/cal/EventsAssignedToMe",pk,"wf5");
};
Lino.cal.EventsAssignedToMe.wf6 = function(rp,pk) { 
  Lino.run_row_action(rp,"/cal/EventsAssignedToMe",pk,"wf6");
};
Lino.cal.EventsAssignedToMe.wf7 = function(rp,pk) { 
  Lino.run_row_action(rp,"/cal/EventsAssignedToMe",pk,"wf7");
};
Lino.cal.EventsAssignedToMe.wf8 = function(rp,pk) { 
  Lino.run_row_action(rp,"/cal/EventsAssignedToMe",pk,"wf8");
};

Lino.cal.EventsAssignedToMe.detailPanel = Ext.extend(Lino.cal.MyEvents.DetailFormPanel,{
  empty_title: "D\u00e9tail Events",
  params_panel_hidden: true,
  ls_bbar_actions: [ { "itemId": "put", "menu_item_text": "Enregistrer", "tooltip": "Save changes in this form", "panel_btn_handler": function(panel){panel.save(null,false,'put')}, "iconCls": "x-tbar-save", "overflowText": "Enregistrer", "auto_save": false }, { "itemId": "insert", "menu_item_text": "Nouveau", "must_save": true, "tooltip": "Insert a new record", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-new", "overflowText": "Nouveau", "auto_save": true }, { "itemId": "duplicate", "menu_item_text": "Dupliquer", "must_save": true, "tooltip": "Dupliquer", "panel_btn_handler": Lino.row_action_handler('duplicate','GET'), "iconCls": "x-tbar-duplicate", "overflowText": "Dupliquer", "auto_save": true }, { "itemId": null, "menu_item_text": "Supprimer", "tooltip": "Delete this record", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "Supprimer", "auto_save": false }, { "itemId": "do_print", "menu_item_text": "Imprimer", "must_save": true, "tooltip": "Imprimer", "panel_btn_handler": Lino.row_action_handler('do_print','GET'), "iconCls": "x-tbar-print", "overflowText": "Imprimer", "auto_save": true }, { "itemId": "do_clear_cache", "menu_item_text": "Effacer la cache", "must_save": true, "tooltip": "Effacer la cache", "panel_btn_handler": Lino.row_action_handler('do_clear_cache','GET'), "iconCls": "x-tbar-clearcache", "overflowText": "Effacer la cache", "auto_save": true }, { "itemId": "create_postings", "menu_item_text": "C\u00e9er envoi postal", "must_save": true, "tooltip": "Create classical mail postings from this", "panel_btn_handler": Lino.row_action_handler('create_postings','GET'), "iconCls": "x-tbar-create-postings", "overflowText": "C\u00e9er envoi postal", "auto_save": true } ],
  ls_url: "/cal/EventsAssignedToMe",
  action_name: "detail",
  initComponent : function() {
    this.ls_detail_handler = Lino.cal.EventsAssignedToMe.detail;
    this.ls_insert_handler = Lino.cal.EventsAssignedToMe.insert;
    Lino.cal.EventsAssignedToMe.detailPanel.superclass.initComponent.call(this);
  }
});

Lino.cal.EventsAssignedToMe.detail = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.cal.EventsAssignedToMe.detailPanel(p);
});
Lino.cal.EventsAssignedToMe.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  p.params_panel = new Lino.cal.MyEvents.ParamsPanel({});
  return new Lino.cal.EventsAssignedToMe.GridPanel(p);
});
Lino.cal.EventsAssignedToMe.take = function(rp,pk) { 
  Lino.run_row_action(rp,"/cal/EventsAssignedToMe",pk,"take");
};

// js_render_GridPanel_class cal.MyEventsToday
Lino.cal.MyEventsToday.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "No data to display." },
  ls_url : "/cal/MyEventsToday",
  ls_bbar_actions : [ { "itemId": "insert", "menu_item_text": "Nouveau", "must_save": true, "tooltip": "Insert a new record", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-new", "overflowText": "Nouveau", "auto_save": true }, { "itemId": "duplicate", "menu_item_text": "Dupliquer", "must_save": true, "tooltip": "Dupliquer", "panel_btn_handler": Lino.row_action_handler('duplicate','GET'), "iconCls": "x-tbar-duplicate", "overflowText": "Dupliquer", "auto_save": true }, { "itemId": "detail", "menu_item_text": "D\u00e9tail", "tooltip": "Open a detail window on this record", "panel_btn_handler": Lino.show_detail, "iconCls": "x-tbar-detail", "overflowText": "D\u00e9tail", "auto_save": true }, { "itemId": null, "menu_item_text": "Supprimer", "tooltip": "Delete this record", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "Supprimer", "auto_save": false }, { "itemId": "do_print", "menu_item_text": "Imprimer", "must_save": true, "tooltip": "Imprimer", "panel_btn_handler": Lino.row_action_handler('do_print','GET'), "iconCls": "x-tbar-print", "overflowText": "Imprimer", "auto_save": true }, { "itemId": "do_clear_cache", "menu_item_text": "Effacer la cache", "must_save": true, "tooltip": "Effacer la cache", "panel_btn_handler": Lino.row_action_handler('do_clear_cache','GET'), "iconCls": "x-tbar-clearcache", "overflowText": "Effacer la cache", "auto_save": true }, { "itemId": "create_postings", "menu_item_text": "C\u00e9er envoi postal", "must_save": true, "tooltip": "Create classical mail postings from this", "panel_btn_handler": Lino.row_action_handler('create_postings','GET'), "iconCls": "x-tbar-create-postings", "overflowText": "C\u00e9er envoi postal", "auto_save": true } ],
  title : "Mes rendez-vous aujourd'hui",
  page_length : 20,
  params_panel_hidden : true,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "name": "start_time" }, { "name": "summary" }, { "name": "workflow_buttons" }, { "type": "int", "name": "id" }, { "name": "owner_type" }, 'owner_typeHidden', { "name": "owner_id" }, 'owner_idHidden', { "name": "user" }, 'userHidden', { "name": "created" }, { "name": "modified" }, { "name": "project" }, 'projectHidden', { "name": "build_time" }, { "type": "date", "name": "start_date", "dateFormat": "d.m.Y" }, { "type": "date", "name": "end_date", "dateFormat": "d.m.Y" }, { "name": "end_time" }, { "name": "description" }, { "name": "uid" }, { "name": "calendar" }, 'calendarHidden', { "name": "access_class" }, 'access_classHidden', { "type": "int", "name": "sequence" }, { "type": "int", "name": "auto_type" }, { "type": "boolean", "name": "transparent" }, { "name": "place" }, 'placeHidden', { "name": "priority" }, 'priorityHidden', { "name": "state" }, 'stateHidden', { "name": "assigned_to" }, 'assigned_toHidden', { "name": "owner" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 3,
  ls_grid_configs : [  ],
  content_type : 36,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 37,
  initComponent : function() {
    this.ls_detail_handler = Lino.cal.MyEventsToday.detail;
    this.ls_insert_handler = Lino.cal.MyEventsToday.insert;
    var ww = this.containing_window;
    var start_time2749 = new Lino.TimeField({ "selectOnFocus": true });
    var summary2750 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var workflow_buttons_disp2751 = new Ext.form.DisplayField({ "disabled": true, "value": "<br/>", "always_enabled": true });
    var id2752 = new Ext.form.NumberField({ "selectOnFocus": true });
    var owner_type2753 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/MyEventsToday/owner_type", "method": "GET" }) }), "pageSize": 20, "emptyText": "Choisir type de contenu..." });
    var owner_id2754 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/MyEventsToday/owner_id", "method": "GET" }) }) });
    var user2755 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/MyEventsToday/user", "method": "GET" }) }), "pageSize": 20, "emptyText": "Choisir Utilisateur..." });
    var created2756 = new Ext.form.DisplayField({ "disabled": true, "value": "<br>" });
    var modified2757 = new Ext.form.DisplayField({ "disabled": true, "value": "<br>" });
    var project2758 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/MyEventsToday/project", "method": "GET" }) }), "pageSize": 20, "emptyText": "Choisir Client..." });
    var build_time2759 = new Ext.form.DisplayField({ "disabled": true, "value": "<br>" });
    var start_date2760 = new Lino.DateField({ "selectOnFocus": true });
    var end_date2761 = new Lino.DateField({ "selectOnFocus": true });
    var end_time2762 = new Lino.TimeField({ "selectOnFocus": true });
    var description2763 = new Lino.RichTextPanel({ "selectOnFocus": true, "containing_panel": this, "title": "Description" });
    var uid2764 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var calendar2765 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/MyEventsToday/calendar", "method": "GET" }) }), "pageSize": 20, "emptyText": "Choisir Calendrier..." });
    var access_class2766 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "forceSelection": true, "store": Lino.cal.AccessClasses });
    var sequence2767 = new Ext.form.NumberField({ "selectOnFocus": true, "allowBlank": false, "value": 0 });
    var auto_type2768 = new Ext.form.NumberField({ "disabled": true });
    var transparent2769 = new Ext.form.Checkbox({ "selectOnFocus": true, "checked": false });
    var place2770 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/MyEventsToday/place", "method": "GET" }) }), "pageSize": 20, "emptyText": "Choisir Room..." });
    var priority2771 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/MyEventsToday/priority", "method": "GET" }) }), "pageSize": 20, "emptyText": "Choisir Priorit\u00e9..." });
    var state2772 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "forceSelection": true, "allowBlank": false, "store": Lino.cal.EventStates });
    var assigned_to2773 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/MyEventsToday/assigned_to", "method": "GET" }) }), "pageSize": 20, "emptyText": "Choisir Utilisateur..." });
    var owner_disp2774 = new Ext.form.DisplayField({ "disabled": true });
    this.before_row_edit = function(record) {
      owner_id2754.setContextValue('owner_type',record ? record.data['owner_typeHidden'] : undefined);
      description2763.refresh();
    };
    this.onRender = function(ct, position) {
      owner_type2753.on('change',Lino.chooser_handler(owner_id2754,'owner_type'));
      Lino.cal.MyEventsToday.GridPanel.superclass.onRender.call(this, ct, position);
    }
    this.ls_columns = [ { "width": Lino.chars2width(9), "colIndex": 0, "sortable": true, "dataIndex": "start_time", "header": "Heure de d\u00e9but", "editable": true, "editor": start_time2749 }, { "colIndex": 1, "sortable": true, "header": "R\u00e9sum\u00e9", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "summary", "editor": summary2750 }, { "width": Lino.chars2width(31), "colIndex": 2, "sortable": false, "dataIndex": "workflow_buttons", "header": "Arbeitsablauf", "editable": false }, new Lino.NullNumberColumn({ "colIndex": 3, "sortable": true, "format": "0", "editable": true, "filter": { "type": "numeric" }, "header": "ID", "renderer": Lino.id_renderer, "editor": id2752, "width": Lino.chars2width(6), "dataIndex": "id" }), { "colIndex": 4, "sortable": true, "header": "Contr\u00f4l\u00e9 par (type)", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "owner_type", "hidden": true, "editor": owner_type2753 }, { "colIndex": 5, "sortable": true, "header": "Contr\u00f4l\u00e9 par (object)", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(11), "dataIndex": "owner_id", "hidden": true, "editor": owner_id2754 }, { "colIndex": 6, "sortable": true, "header": "Responsible user", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(16), "dataIndex": "user", "editor": user2755 }, { "width": Lino.chars2width(17), "colIndex": 7, "sortable": true, "dataIndex": "created", "header": "Cr\u00e9\u00e9", "hidden": true, "editable": false }, { "width": Lino.chars2width(17), "colIndex": 8, "sortable": true, "dataIndex": "modified", "header": "Modified", "hidden": true, "editable": false }, { "colIndex": 9, "sortable": true, "header": "Client", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('projectHidden','Lino.pcsw.Clients.detail'), "editor": project2758, "dataIndex": "project" }, { "width": Lino.chars2width(17), "colIndex": 10, "sortable": true, "dataIndex": "build_time", "header": "build time", "hidden": true, "editable": false }, { "colIndex": 11, "sortable": true, "xtype": "datecolumn", "format": "d.m.Y", "editable": true, "filter": { "type": "date", "dateFormat": "d.m.Y" }, "header": "Date d\u00e9but", "editor": start_date2760, "width": Lino.chars2width(9), "dataIndex": "start_date" }, { "colIndex": 12, "sortable": true, "xtype": "datecolumn", "format": "d.m.Y", "editable": true, "filter": { "type": "date", "dateFormat": "d.m.Y" }, "header": "Date de fin", "dataIndex": "end_date", "hidden": true, "width": Lino.chars2width(9), "editor": end_date2761 }, { "colIndex": 13, "sortable": true, "header": "Heure de fin", "editable": true, "width": Lino.chars2width(9), "dataIndex": "end_time", "hidden": true, "editor": end_time2762 }, { "colIndex": 14, "sortable": false, "header": "description", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(61), "renderer": Lino.text_renderer, "hidden": true, "editor": description2763, "dataIndex": "description" }, { "colIndex": 15, "sortable": true, "header": "UID", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "uid", "hidden": true, "editor": uid2764 }, { "colIndex": 16, "sortable": true, "header": "Calendrier", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "calendar", "editor": calendar2765 }, { "colIndex": 17, "sortable": true, "header": "Classe d'acc\u00e8s", "editable": true, "tooltip": "Public, priv\u00e9 ou \"marquer occup\u00e9\".", "filter": { "type": "string" }, "width": Lino.chars2width(35), "dataIndex": "access_class", "hidden": true, "editor": access_class2766 }, new Lino.NullNumberColumn({ "colIndex": 18, "sortable": true, "format": "0", "editable": true, "filter": { "type": "numeric" }, "header": "Version", "dataIndex": "sequence", "hidden": true, "width": Lino.chars2width(6), "editor": sequence2767 }), new Lino.NullNumberColumn({ "colIndex": 19, "sortable": true, "format": "0", "editable": false, "filter": { "type": "numeric" }, "header": "auto type", "dataIndex": "auto_type", "hidden": true, "width": Lino.chars2width(6) }), { "colIndex": 20, "sortable": false, "xtype": "checkcolumn", "header": "non bloquant", "editable": true, "tooltip": "Indique que ce rendez-vous n'emp\u00eache pas d'avoir d'autres rendez-vous en m\u00eame temps.", "filter": { "type": "boolean" }, "width": Lino.chars2width(11), "dataIndex": "transparent", "hidden": true }, { "colIndex": 21, "sortable": true, "header": "Room", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "place", "hidden": true, "editor": place2770 }, { "colIndex": 22, "sortable": true, "header": "Priorit\u00e9", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "priority", "hidden": true, "editor": priority2771 }, { "colIndex": 23, "sortable": true, "header": "State", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(17), "dataIndex": "state", "editor": state2772 }, { "colIndex": 24, "sortable": true, "header": "Attribu\u00e9 \u00e0", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(16), "dataIndex": "assigned_to", "editor": assigned_to2773 }, { "width": Lino.chars2width(11), "colIndex": 25, "sortable": false, "dataIndex": "owner", "header": "Contr\u00f4l\u00e9 par", "hidden": true, "editable": false } ];
    Lino.cal.MyEventsToday.GridPanel.superclass.initComponent.call(this);
  }
});


Lino.cal.MyEventsToday.insertPanel = Ext.extend(Lino.cal.MyEvents.InsertFormPanel,{
  empty_title: "Nouveau Mes rendez-vous aujourd'hui",
  hide_navigator: true,
  params_panel_hidden: true,
  ls_bbar_actions: [ { "itemId": "post", "menu_item_text": "Cr\u00e9er", "tooltip": "Create the record and open a detail window on it", "panel_btn_handler": function(panel){panel.save(null,true,'post')}, "text": "Cr\u00e9er", "overflowText": "Cr\u00e9er", "auto_save": false }, { "itemId": "poststay", "menu_item_text": "Create without detail", "tooltip": "Don't open a detail window on the new record", "panel_btn_handler": function(panel){panel.save(null,false,'poststay')}, "text": "Create without detail", "overflowText": "Create without detail", "auto_save": false } ],
  ls_url: "/cal/MyEventsToday",
  action_name: "insert",
  initComponent : function() {
    this.ls_detail_handler = Lino.cal.MyEventsToday.detail;
    this.ls_insert_handler = Lino.cal.MyEventsToday.insert;
    Lino.cal.MyEventsToday.insertPanel.superclass.initComponent.call(this);
  }
});

Lino.cal.MyEventsToday.insert = new Lino.WindowAction({ "draggable": true, "width": Lino.chars2width(60), "autoHeight": true, "maximizable": true, "modal": true, "maximized": false },function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.cal.MyEventsToday.insertPanel(p);
});
Lino.cal.MyEventsToday.wf1 = function(rp,pk) { 
  Lino.run_row_action(rp,"/cal/MyEventsToday",pk,"wf1");
};
Lino.cal.MyEventsToday.wf2 = function(rp,pk) { 
  Lino.run_row_action(rp,"/cal/MyEventsToday",pk,"wf2");
};
Lino.cal.MyEventsToday.wf3 = function(rp,pk) { 
  Lino.run_row_action(rp,"/cal/MyEventsToday",pk,"wf3");
};
Lino.cal.MyEventsToday.wf4 = function(rp,pk) { 
  Lino.run_row_action(rp,"/cal/MyEventsToday",pk,"wf4");
};
Lino.cal.MyEventsToday.wf5 = function(rp,pk) { 
  Lino.run_row_action(rp,"/cal/MyEventsToday",pk,"wf5");
};
Lino.cal.MyEventsToday.wf6 = function(rp,pk) { 
  Lino.run_row_action(rp,"/cal/MyEventsToday",pk,"wf6");
};
Lino.cal.MyEventsToday.wf7 = function(rp,pk) { 
  Lino.run_row_action(rp,"/cal/MyEventsToday",pk,"wf7");
};
Lino.cal.MyEventsToday.wf8 = function(rp,pk) { 
  Lino.run_row_action(rp,"/cal/MyEventsToday",pk,"wf8");
};

Lino.cal.MyEventsToday.detailPanel = Ext.extend(Lino.cal.MyEvents.DetailFormPanel,{
  empty_title: "D\u00e9tail Mes rendez-vous aujourd'hui",
  params_panel_hidden: true,
  ls_bbar_actions: [ { "itemId": "put", "menu_item_text": "Enregistrer", "tooltip": "Save changes in this form", "panel_btn_handler": function(panel){panel.save(null,false,'put')}, "iconCls": "x-tbar-save", "overflowText": "Enregistrer", "auto_save": false }, { "itemId": "insert", "menu_item_text": "Nouveau", "must_save": true, "tooltip": "Insert a new record", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-new", "overflowText": "Nouveau", "auto_save": true }, { "itemId": "duplicate", "menu_item_text": "Dupliquer", "must_save": true, "tooltip": "Dupliquer", "panel_btn_handler": Lino.row_action_handler('duplicate','GET'), "iconCls": "x-tbar-duplicate", "overflowText": "Dupliquer", "auto_save": true }, { "itemId": null, "menu_item_text": "Supprimer", "tooltip": "Delete this record", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "Supprimer", "auto_save": false }, { "itemId": "do_print", "menu_item_text": "Imprimer", "must_save": true, "tooltip": "Imprimer", "panel_btn_handler": Lino.row_action_handler('do_print','GET'), "iconCls": "x-tbar-print", "overflowText": "Imprimer", "auto_save": true }, { "itemId": "do_clear_cache", "menu_item_text": "Effacer la cache", "must_save": true, "tooltip": "Effacer la cache", "panel_btn_handler": Lino.row_action_handler('do_clear_cache','GET'), "iconCls": "x-tbar-clearcache", "overflowText": "Effacer la cache", "auto_save": true }, { "itemId": "create_postings", "menu_item_text": "C\u00e9er envoi postal", "must_save": true, "tooltip": "Create classical mail postings from this", "panel_btn_handler": Lino.row_action_handler('create_postings','GET'), "iconCls": "x-tbar-create-postings", "overflowText": "C\u00e9er envoi postal", "auto_save": true } ],
  ls_url: "/cal/MyEventsToday",
  action_name: "detail",
  initComponent : function() {
    this.ls_detail_handler = Lino.cal.MyEventsToday.detail;
    this.ls_insert_handler = Lino.cal.MyEventsToday.insert;
    Lino.cal.MyEventsToday.detailPanel.superclass.initComponent.call(this);
  }
});

Lino.cal.MyEventsToday.detail = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.cal.MyEventsToday.detailPanel(p);
});
Lino.cal.MyEventsToday.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  p.params_panel = new Lino.cal.MyEvents.ParamsPanel({});
  return new Lino.cal.MyEventsToday.GridPanel(p);
});
Lino.cal.MyEventsToday.take = function(rp,pk) { 
  Lino.run_row_action(rp,"/cal/MyEventsToday",pk,"take");
};

// js_render_GridPanel_class cal.PanelCalendars
Lino.cal.PanelCalendars.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "No data to display." },
  ls_url : "/cal/PanelCalendars",
  ls_bbar_actions : [ { "itemId": "insert", "menu_item_text": "Nouveau", "must_save": true, "tooltip": "Insert a new record", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-new", "overflowText": "Nouveau", "auto_save": true }, { "itemId": "detail", "menu_item_text": "D\u00e9tail", "tooltip": "Open a detail window on this record", "panel_btn_handler": Lino.show_detail, "iconCls": "x-tbar-detail", "overflowText": "D\u00e9tail", "auto_save": true }, { "itemId": null, "menu_item_text": "Supprimer", "tooltip": "Delete this record", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "Supprimer", "auto_save": false } ],
  title : "Calendriers",
  page_length : 20,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "type": "int", "name": "id" }, { "name": "babel_name" }, { "name": "description" }, { "type": "int", "name": "color" }, { "type": "boolean", "name": "is_hidden" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 0,
  ls_grid_configs : [  ],
  content_type : 35,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 6,
  initComponent : function() {
    this.ls_detail_handler = Lino.cal.PanelCalendars.detail;
    this.ls_insert_handler = Lino.cal.PanelCalendars.insert;
    var ww = this.containing_window;
    var id2776 = new Ext.form.NumberField({ "selectOnFocus": true });
    var babel_name_disp2777 = new Ext.form.DisplayField({ "disabled": true, "value": "<br/>", "always_enabled": true });
    var description2778 = new Lino.RichTextPanel({ "selectOnFocus": true, "containing_panel": this, "title": "Description" });
    var color2779 = new Ext.form.NumberField({ "selectOnFocus": true, "allowBlank": false, "value": 1 });
    var is_hidden_disp2780 = new Ext.form.DisplayField({ "disabled": true, "value": "<br/>", "always_enabled": true });
    this.before_row_edit = function(record) {
      description2778.refresh();
    };
    this.ls_columns = [ new Lino.NullNumberColumn({ "colIndex": 0, "sortable": true, "format": "0", "editable": true, "filter": { "type": "numeric" }, "header": "ID", "renderer": Lino.id_renderer, "editor": id2776, "width": Lino.chars2width(6), "dataIndex": "id" }), { "width": Lino.chars2width(31), "colIndex": 1, "sortable": false, "dataIndex": "babel_name", "header": "babel_name", "editable": false }, { "colIndex": 2, "sortable": false, "header": "description", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(61), "renderer": Lino.text_renderer, "editor": description2778, "dataIndex": "description" }, new Lino.NullNumberColumn({ "colIndex": 3, "sortable": true, "format": "0", "editable": true, "filter": { "type": "numeric" }, "header": "Couleur", "dataIndex": "color", "width": Lino.chars2width(6), "editor": color2779 }), { "width": Lino.chars2width(31), "colIndex": 4, "sortable": false, "dataIndex": "is_hidden", "header": "Invisible", "editable": false } ];
    Lino.cal.PanelCalendars.GridPanel.superclass.initComponent.call(this);
  }
});


Lino.cal.PanelCalendars.insertPanel = Ext.extend(Lino.cal.PanelCalendars.InsertFormPanel,{
  empty_title: "Nouveau Calendriers",
  hide_navigator: true,
  ls_bbar_actions: [ { "itemId": "post", "menu_item_text": "Cr\u00e9er", "tooltip": "Create the record and open a detail window on it", "panel_btn_handler": function(panel){panel.save(null,true,'post')}, "text": "Cr\u00e9er", "overflowText": "Cr\u00e9er", "auto_save": false }, { "itemId": "poststay", "menu_item_text": "Create without detail", "tooltip": "Don't open a detail window on the new record", "panel_btn_handler": function(panel){panel.save(null,false,'poststay')}, "text": "Create without detail", "overflowText": "Create without detail", "auto_save": false } ],
  ls_url: "/cal/PanelCalendars",
  action_name: "insert",
  initComponent : function() {
    this.ls_detail_handler = Lino.cal.PanelCalendars.detail;
    this.ls_insert_handler = Lino.cal.PanelCalendars.insert;
    Lino.cal.PanelCalendars.insertPanel.superclass.initComponent.call(this);
  }
});

Lino.cal.PanelCalendars.insert = new Lino.WindowAction({ "draggable": true, "width": Lino.chars2width(60), "autoHeight": true, "maximizable": true, "modal": true, "maximized": false },function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.cal.PanelCalendars.insertPanel(p);
});

Lino.cal.PanelCalendars.detailPanel = Ext.extend(Lino.cal.PanelCalendars.DetailFormPanel,{
  empty_title: "D\u00e9tail Calendriers",
  ls_bbar_actions: [ { "itemId": "put", "menu_item_text": "Enregistrer", "tooltip": "Save changes in this form", "panel_btn_handler": function(panel){panel.save(null,false,'put')}, "iconCls": "x-tbar-save", "overflowText": "Enregistrer", "auto_save": false }, { "itemId": "insert", "menu_item_text": "Nouveau", "must_save": true, "tooltip": "Insert a new record", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-new", "overflowText": "Nouveau", "auto_save": true }, { "itemId": null, "menu_item_text": "Supprimer", "tooltip": "Delete this record", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "Supprimer", "auto_save": false } ],
  ls_url: "/cal/PanelCalendars",
  action_name: "detail",
  initComponent : function() {
    this.ls_detail_handler = Lino.cal.PanelCalendars.detail;
    this.ls_insert_handler = Lino.cal.PanelCalendars.insert;
    Lino.cal.PanelCalendars.detailPanel.superclass.initComponent.call(this);
  }
});

Lino.cal.PanelCalendars.detail = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.cal.PanelCalendars.detailPanel(p);
});
Lino.cal.PanelCalendars.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.cal.PanelCalendars.GridPanel(p);
});

// js_render_GridPanel_class cal.PanelEvents
Lino.cal.PanelEvents.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "No data to display." },
  ls_url : "/cal/PanelEvents",
  ls_bbar_actions : [ { "itemId": "insert", "menu_item_text": "Nouveau", "must_save": true, "tooltip": "Insert a new record", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-new", "overflowText": "Nouveau", "auto_save": true }, { "itemId": "duplicate", "menu_item_text": "Dupliquer", "must_save": true, "tooltip": "Dupliquer", "panel_btn_handler": Lino.row_action_handler('duplicate','GET'), "iconCls": "x-tbar-duplicate", "overflowText": "Dupliquer", "auto_save": true }, { "itemId": "detail", "menu_item_text": "D\u00e9tail", "tooltip": "Open a detail window on this record", "panel_btn_handler": Lino.show_detail, "iconCls": "x-tbar-detail", "overflowText": "D\u00e9tail", "auto_save": true }, { "itemId": null, "menu_item_text": "Supprimer", "tooltip": "Delete this record", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "Supprimer", "auto_save": false }, { "itemId": "do_print", "menu_item_text": "Imprimer", "must_save": true, "tooltip": "Imprimer", "panel_btn_handler": Lino.row_action_handler('do_print','GET'), "iconCls": "x-tbar-print", "overflowText": "Imprimer", "auto_save": true }, { "itemId": "do_clear_cache", "menu_item_text": "Effacer la cache", "must_save": true, "tooltip": "Effacer la cache", "panel_btn_handler": Lino.row_action_handler('do_clear_cache','GET'), "iconCls": "x-tbar-clearcache", "overflowText": "Effacer la cache", "auto_save": true }, { "itemId": "create_postings", "menu_item_text": "C\u00e9er envoi postal", "must_save": true, "tooltip": "Create classical mail postings from this", "panel_btn_handler": Lino.row_action_handler('create_postings','GET'), "iconCls": "x-tbar-create-postings", "overflowText": "C\u00e9er envoi postal", "auto_save": true } ],
  title : "Events",
  page_length : 20,
  params_panel_hidden : true,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "type": "int", "name": "id" }, { "name": "start_dt" }, { "name": "end_dt" }, { "name": "summary" }, { "name": "description" }, { "name": "user" }, 'userHidden', { "name": "place" }, 'placeHidden', { "name": "calendar" }, 'calendarHidden', { "name": "url" }, { "type": "boolean", "name": "all_day" }, { "name": "reminder" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 0,
  ls_grid_configs : [  ],
  content_type : 36,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 15,
  initComponent : function() {
    this.ls_detail_handler = Lino.cal.PanelEvents.detail;
    this.ls_insert_handler = Lino.cal.PanelEvents.insert;
    var ww = this.containing_window;
    var id2782 = new Ext.form.NumberField({ "selectOnFocus": true });
    var start_dt2783 = new Ext.form.DisplayField({ "disabled": true, "value": "<br>" });
    var end_dt2784 = new Ext.form.DisplayField({ "disabled": true, "value": "<br>" });
    var summary2785 = new Ext.form.TextField({ "disabled": true, "maxLength": null });
    var description2786 = new Lino.RichTextPanel({ "selectOnFocus": true, "containing_panel": this, "title": "Description" });
    var user2787 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/PanelEvents/user", "method": "GET" }) }), "pageSize": 20, "emptyText": "Choisir Utilisateur..." });
    var place2788 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/PanelEvents/place", "method": "GET" }) }), "pageSize": 20, "emptyText": "Choisir Room..." });
    var calendar2789 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/PanelEvents/calendar", "method": "GET" }) }), "pageSize": 20, "emptyText": "Choisir Calendrier..." });
    var url_disp2790 = new Ext.form.DisplayField({ "disabled": true, "value": "<br/>", "always_enabled": true });
    var all_day2791 = new Ext.form.Checkbox({ "disabled": true });
    var reminder_disp2792 = new Ext.form.DisplayField({ "disabled": true, "value": "<br/>", "always_enabled": true });
    this.before_row_edit = function(record) {
      description2786.refresh();
    };
    this.ls_columns = [ new Lino.NullNumberColumn({ "colIndex": 0, "sortable": true, "format": "0", "editable": true, "filter": { "type": "numeric" }, "header": "ID", "renderer": Lino.id_renderer, "editor": id2782, "width": Lino.chars2width(6), "dataIndex": "id" }), { "width": Lino.chars2width(17), "colIndex": 1, "sortable": false, "dataIndex": "start_dt", "header": "D\u00e9but", "editable": false }, { "width": Lino.chars2width(17), "colIndex": 2, "sortable": false, "dataIndex": "end_dt", "header": "Fin", "editable": false }, { "width": Lino.chars2width(5), "colIndex": 3, "sortable": false, "dataIndex": "summary", "header": "R\u00e9sum\u00e9", "editable": false }, { "colIndex": 4, "sortable": false, "header": "description", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(61), "renderer": Lino.text_renderer, "hidden": true, "editor": description2786, "dataIndex": "description" }, { "colIndex": 5, "sortable": true, "header": "Responsible user", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(16), "dataIndex": "user", "editor": user2787 }, { "colIndex": 6, "sortable": true, "header": "Room", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "place", "hidden": true, "editor": place2788 }, { "colIndex": 7, "sortable": true, "header": "Calendrier", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "calendar", "editor": calendar2789 }, { "width": Lino.chars2width(31), "colIndex": 8, "sortable": false, "dataIndex": "url", "header": "Link URL", "editable": false }, { "header": "journ\u00e9e enti\u00e8re", "colIndex": 9, "sortable": false, "xtype": "checkcolumn", "width": Lino.chars2width(11), "editable": false, "dataIndex": "all_day" }, { "width": Lino.chars2width(31), "colIndex": 10, "sortable": false, "dataIndex": "reminder", "header": "Rappel", "editable": false } ];
    Lino.cal.PanelEvents.GridPanel.superclass.initComponent.call(this);
  }
});


Lino.cal.PanelEvents.insertPanel = Ext.extend(Lino.cal.MyEvents.InsertFormPanel,{
  empty_title: "Nouveau Events",
  hide_navigator: true,
  params_panel_hidden: true,
  ls_bbar_actions: [ { "itemId": "post", "menu_item_text": "Cr\u00e9er", "tooltip": "Create the record and open a detail window on it", "panel_btn_handler": function(panel){panel.save(null,true,'post')}, "text": "Cr\u00e9er", "overflowText": "Cr\u00e9er", "auto_save": false }, { "itemId": "poststay", "menu_item_text": "Create without detail", "tooltip": "Don't open a detail window on the new record", "panel_btn_handler": function(panel){panel.save(null,false,'poststay')}, "text": "Create without detail", "overflowText": "Create without detail", "auto_save": false } ],
  ls_url: "/cal/PanelEvents",
  action_name: "insert",
  initComponent : function() {
    this.ls_detail_handler = Lino.cal.PanelEvents.detail;
    this.ls_insert_handler = Lino.cal.PanelEvents.insert;
    Lino.cal.PanelEvents.insertPanel.superclass.initComponent.call(this);
  }
});

Lino.cal.PanelEvents.insert = new Lino.WindowAction({ "draggable": true, "width": Lino.chars2width(60), "autoHeight": true, "maximizable": true, "modal": true, "maximized": false },function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.cal.PanelEvents.insertPanel(p);
});
Lino.cal.PanelEvents.wf1 = function(rp,pk) { 
  Lino.run_row_action(rp,"/cal/PanelEvents",pk,"wf1");
};
Lino.cal.PanelEvents.wf2 = function(rp,pk) { 
  Lino.run_row_action(rp,"/cal/PanelEvents",pk,"wf2");
};
Lino.cal.PanelEvents.wf3 = function(rp,pk) { 
  Lino.run_row_action(rp,"/cal/PanelEvents",pk,"wf3");
};
Lino.cal.PanelEvents.wf4 = function(rp,pk) { 
  Lino.run_row_action(rp,"/cal/PanelEvents",pk,"wf4");
};
Lino.cal.PanelEvents.wf5 = function(rp,pk) { 
  Lino.run_row_action(rp,"/cal/PanelEvents",pk,"wf5");
};
Lino.cal.PanelEvents.wf6 = function(rp,pk) { 
  Lino.run_row_action(rp,"/cal/PanelEvents",pk,"wf6");
};
Lino.cal.PanelEvents.wf7 = function(rp,pk) { 
  Lino.run_row_action(rp,"/cal/PanelEvents",pk,"wf7");
};
Lino.cal.PanelEvents.wf8 = function(rp,pk) { 
  Lino.run_row_action(rp,"/cal/PanelEvents",pk,"wf8");
};

Lino.cal.PanelEvents.detailPanel = Ext.extend(Lino.cal.MyEvents.DetailFormPanel,{
  empty_title: "D\u00e9tail Events",
  params_panel_hidden: true,
  ls_bbar_actions: [ { "itemId": "put", "menu_item_text": "Enregistrer", "tooltip": "Save changes in this form", "panel_btn_handler": function(panel){panel.save(null,false,'put')}, "iconCls": "x-tbar-save", "overflowText": "Enregistrer", "auto_save": false }, { "itemId": "insert", "menu_item_text": "Nouveau", "must_save": true, "tooltip": "Insert a new record", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-new", "overflowText": "Nouveau", "auto_save": true }, { "itemId": "duplicate", "menu_item_text": "Dupliquer", "must_save": true, "tooltip": "Dupliquer", "panel_btn_handler": Lino.row_action_handler('duplicate','GET'), "iconCls": "x-tbar-duplicate", "overflowText": "Dupliquer", "auto_save": true }, { "itemId": null, "menu_item_text": "Supprimer", "tooltip": "Delete this record", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "Supprimer", "auto_save": false }, { "itemId": "do_print", "menu_item_text": "Imprimer", "must_save": true, "tooltip": "Imprimer", "panel_btn_handler": Lino.row_action_handler('do_print','GET'), "iconCls": "x-tbar-print", "overflowText": "Imprimer", "auto_save": true }, { "itemId": "do_clear_cache", "menu_item_text": "Effacer la cache", "must_save": true, "tooltip": "Effacer la cache", "panel_btn_handler": Lino.row_action_handler('do_clear_cache','GET'), "iconCls": "x-tbar-clearcache", "overflowText": "Effacer la cache", "auto_save": true }, { "itemId": "create_postings", "menu_item_text": "C\u00e9er envoi postal", "must_save": true, "tooltip": "Create classical mail postings from this", "panel_btn_handler": Lino.row_action_handler('create_postings','GET'), "iconCls": "x-tbar-create-postings", "overflowText": "C\u00e9er envoi postal", "auto_save": true } ],
  ls_url: "/cal/PanelEvents",
  action_name: "detail",
  initComponent : function() {
    this.ls_detail_handler = Lino.cal.PanelEvents.detail;
    this.ls_insert_handler = Lino.cal.PanelEvents.insert;
    Lino.cal.PanelEvents.detailPanel.superclass.initComponent.call(this);
  }
});

Lino.cal.PanelEvents.detail = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.cal.PanelEvents.detailPanel(p);
});
Lino.cal.PanelEvents.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  p.params_panel = new Lino.cal.MyEvents.ParamsPanel({});
  return new Lino.cal.PanelEvents.GridPanel(p);
});
Lino.cal.PanelEvents.take = function(rp,pk) { 
  Lino.run_row_action(rp,"/cal/PanelEvents",pk,"take");
};

// js_render_GridPanel_class households.Households
Lino.households.Households.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "No data to display." },
  ls_url : "/households/Households",
  ls_bbar_actions : [ { "itemId": "insert", "menu_item_text": "Nouveau", "must_save": true, "tooltip": "Insert a new record", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-new", "overflowText": "Nouveau", "auto_save": true }, { "itemId": "detail", "menu_item_text": "D\u00e9tail", "tooltip": "Open a detail window on this record", "panel_btn_handler": Lino.show_detail, "iconCls": "x-tbar-detail", "overflowText": "D\u00e9tail", "auto_save": true }, { "itemId": null, "menu_item_text": "Supprimer", "tooltip": "Delete this record", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "Supprimer", "auto_save": false } ],
  title : "M\u00e9nages",
  page_length : 20,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "name": "name" }, { "name": "email" }, { "name": "created" }, { "name": "modified" }, { "name": "country" }, 'countryHidden', { "name": "city" }, 'cityHidden', { "name": "region" }, 'regionHidden', { "name": "zip_code" }, { "name": "addr1" }, { "name": "street_prefix" }, { "name": "street" }, { "name": "street_no" }, { "name": "street_box" }, { "name": "addr2" }, { "name": "language" }, 'languageHidden', { "name": "url" }, { "name": "phone" }, { "name": "gsm" }, { "name": "fax" }, { "name": "remarks" }, { "type": "boolean", "name": "is_obsolete" }, { "name": "activity" }, 'activityHidden', { "name": "bank_account1" }, { "name": "bank_account2" }, { "name": "prefix" }, { "name": "type" }, 'typeHidden', { "type": "int", "name": "id" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 32,
  ls_grid_configs : [  ],
  content_type : 41,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 34,
  initComponent : function() {
    this.ls_detail_handler = Lino.households.Households.detail;
    this.ls_insert_handler = Lino.households.Households.insert;
    var ww = this.containing_window;
    var name2794 = new Ext.form.TextField({ "selectOnFocus": true, "allowBlank": false, "maxLength": 200 });
    var email2795 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 75 });
    var created2796 = new Ext.form.DisplayField({ "disabled": true, "value": "<br>" });
    var modified2797 = new Ext.form.DisplayField({ "disabled": true, "value": "<br>" });
    var country2798 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/households/Households/country", "method": "GET" }) }), "pageSize": 20, "emptyText": "Choisir Pays..." });
    var city2799 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "forceSelection": false, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/households/Households/city", "method": "GET" }) }), "pageSize": 20, "emptyText": "Choisir Place..." });
    var region2800 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/households/Households/region", "method": "GET" }) }), "pageSize": 20, "emptyText": "Choisir Place..." });
    var zip_code2801 = new Ext.form.TextField({ "selectOnFocus": true, "boxMinWidth": Lino.chars2width(10), "maxLength": 10 });
    var addr12802 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var street_prefix2803 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var street2804 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var street_no2805 = new Ext.form.TextField({ "selectOnFocus": true, "boxMinWidth": Lino.chars2width(10), "maxLength": 10 });
    var street_box2806 = new Ext.form.TextField({ "selectOnFocus": true, "boxMinWidth": Lino.chars2width(10), "maxLength": 10 });
    var addr22807 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var language2808 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "store": [ [ "de", "German" ], [ "fr", "French" ], [ "nl", "Dutch" ] ], "allowBlank": false, "value": "de" });
    var url2809 = new Lino.URLField({ "selectOnFocus": true, "maxLength": 200 });
    var phone2810 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var gsm2811 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var fax2812 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var remarks2813 = new Ext.form.TextArea({ "selectOnFocus": true, "growMax": 2000 });
    var is_obsolete2814 = new Ext.form.Checkbox({ "selectOnFocus": true, "checked": false });
    var activity2815 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/households/Households/activity", "method": "GET" }) }), "pageSize": 20, "emptyText": "Choisir Activit\u00e9..." });
    var bank_account12816 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 40 });
    var bank_account22817 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 40 });
    var prefix2818 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var type2819 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/households/Households/type", "method": "GET" }) }), "pageSize": 20, "emptyText": "Choisir Type de m\u00e9nage..." });
    var id2820 = new Ext.form.NumberField({ "selectOnFocus": true });
    this.before_row_edit = function(record) {
      city2799.setContextValue('country',record ? record.data['countryHidden'] : undefined);
      city2799.setContextValue('region',record ? record.data['regionHidden'] : undefined);
      region2800.setContextValue('country',record ? record.data['countryHidden'] : undefined);
    };
    this.onRender = function(ct, position) {
      country2798.on('change',Lino.chooser_handler(city2799,'country'));
      region2800.on('change',Lino.chooser_handler(city2799,'region'));
      country2798.on('change',Lino.chooser_handler(region2800,'country'));
      Lino.households.Households.GridPanel.superclass.onRender.call(this, ct, position);
    }
    this.ls_columns = [ { "colIndex": 0, "sortable": true, "header": "Name", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "name", "editor": name2794 }, { "colIndex": 1, "sortable": true, "header": "E-mail", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "email", "editor": email2795 }, { "width": Lino.chars2width(17), "colIndex": 2, "sortable": true, "dataIndex": "created", "header": "Cr\u00e9\u00e9", "hidden": true, "editable": false }, { "width": Lino.chars2width(17), "colIndex": 3, "sortable": true, "dataIndex": "modified", "header": "Modified", "hidden": true, "editable": false }, { "colIndex": 4, "sortable": true, "header": "Pays", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('countryHidden','Lino.countries.Countries.detail'), "editor": country2798, "dataIndex": "country" }, { "colIndex": 5, "sortable": true, "header": "Place", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "city", "editor": city2799 }, { "colIndex": 6, "sortable": true, "header": "Region", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "region", "editor": region2800 }, { "colIndex": 7, "sortable": true, "header": "Zip code", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(12), "dataIndex": "zip_code", "editor": zip_code2801 }, { "colIndex": 8, "sortable": true, "header": "Ligne avant le nom de rue", "editable": true, "tooltip": "Address line before street", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "addr1", "editor": addr12802 }, { "colIndex": 9, "sortable": true, "header": "Pr\u00e9fixe rue", "editable": true, "tooltip": "Text to print before name of street, but to ignore for sorting.", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "street_prefix", "editor": street_prefix2803 }, { "colIndex": 10, "sortable": true, "header": "Rue", "editable": true, "tooltip": "Name of street. Without house number.", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "street", "editor": street2804 }, { "colIndex": 11, "sortable": true, "header": "N\u00b0", "editable": true, "tooltip": "House number", "filter": { "type": "string" }, "width": Lino.chars2width(12), "dataIndex": "street_no", "editor": street_no2805 }, { "colIndex": 12, "sortable": true, "header": "bo\u00eete", "editable": true, "tooltip": "Text to print after :attr:`steet_no` on the same line", "filter": { "type": "string" }, "width": Lino.chars2width(12), "dataIndex": "street_box", "editor": street_box2806 }, { "colIndex": 13, "sortable": true, "header": "Ligne apr\u00e8s le nom de rue", "editable": true, "tooltip": "Address line to print below street line", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "addr2", "editor": addr22807 }, { "colIndex": 14, "sortable": true, "header": "Langue", "editable": true, "tooltip": "Die Sprache, in der Dokumente ausgestellt werden sollen.", "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "language", "editor": language2808 }, { "colIndex": 15, "sortable": true, "header": "URL", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "url", "editor": url2809 }, { "colIndex": 16, "sortable": true, "header": "T\u00e9l\u00e9phone", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "phone", "editor": phone2810 }, { "colIndex": 17, "sortable": true, "header": "GSM", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "gsm", "editor": gsm2811 }, { "colIndex": 18, "sortable": true, "header": "Fax", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "fax", "editor": fax2812 }, { "colIndex": 19, "sortable": false, "header": "Remarques", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(61), "renderer": Lino.text_renderer, "editor": remarks2813, "dataIndex": "remarks" }, { "colIndex": 20, "sortable": false, "xtype": "checkcolumn", "header": "obsolete", "editable": true, "tooltip": "Altf\u00e4lle sind Partner, deren Stammdaten nicht mehr gepflegt werden und \nf\u00fcr neue Operationen nicht benutzt werden k\u00f6nnen.", "filter": { "type": "boolean" }, "width": Lino.chars2width(11), "dataIndex": "is_obsolete" }, { "colIndex": 21, "sortable": true, "header": "Activit\u00e9", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "activity", "hidden": true, "editor": activity2815 }, { "colIndex": 22, "sortable": true, "header": "Compte en banque 1", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "bank_account1", "hidden": true, "editor": bank_account12816 }, { "colIndex": 23, "sortable": true, "header": "Compte en banque 2", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "bank_account2", "hidden": true, "editor": bank_account22817 }, { "colIndex": 24, "sortable": true, "header": "prefix", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "prefix", "editor": prefix2818 }, { "colIndex": 25, "sortable": true, "header": "Type de m\u00e9nage", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "type", "editor": type2819 }, new Lino.NullNumberColumn({ "colIndex": 26, "sortable": true, "format": "0", "editable": true, "filter": { "type": "numeric" }, "header": "ID", "renderer": Lino.id_renderer, "editor": id2820, "width": Lino.chars2width(6), "dataIndex": "id" }) ];
    Lino.households.Households.GridPanel.superclass.initComponent.call(this);
  }
});


Lino.households.Households.insertPanel = Ext.extend(Lino.contacts.Partners.InsertFormPanel,{
  empty_title: "Nouveau M\u00e9nages",
  hide_navigator: true,
  ls_bbar_actions: [ { "itemId": "post", "menu_item_text": "Cr\u00e9er", "tooltip": "Create the record and open a detail window on it", "panel_btn_handler": function(panel){panel.save(null,true,'post')}, "text": "Cr\u00e9er", "overflowText": "Cr\u00e9er", "auto_save": false }, { "itemId": "poststay", "menu_item_text": "Create without detail", "tooltip": "Don't open a detail window on the new record", "panel_btn_handler": function(panel){panel.save(null,false,'poststay')}, "text": "Create without detail", "overflowText": "Create without detail", "auto_save": false } ],
  ls_url: "/households/Households",
  action_name: "insert",
  initComponent : function() {
    this.ls_detail_handler = Lino.households.Households.detail;
    this.ls_insert_handler = Lino.households.Households.insert;
    Lino.households.Households.insertPanel.superclass.initComponent.call(this);
  }
});

Lino.households.Households.insert = new Lino.WindowAction({ "draggable": true, "width": Lino.chars2width(40), "autoHeight": true, "maximizable": true, "modal": true, "maximized": false },function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.households.Households.insertPanel(p);
});

Lino.households.Households.detailPanel = Ext.extend(Lino.households.Households.DetailFormPanel,{
  empty_title: "D\u00e9tail M\u00e9nages",
  ls_bbar_actions: [ { "itemId": "put", "menu_item_text": "Enregistrer", "tooltip": "Save changes in this form", "panel_btn_handler": function(panel){panel.save(null,false,'put')}, "iconCls": "x-tbar-save", "overflowText": "Enregistrer", "auto_save": false }, { "itemId": "insert", "menu_item_text": "Nouveau", "must_save": true, "tooltip": "Insert a new record", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-new", "overflowText": "Nouveau", "auto_save": true }, { "itemId": null, "menu_item_text": "Supprimer", "tooltip": "Delete this record", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "Supprimer", "auto_save": false } ],
  ls_url: "/households/Households",
  action_name: "detail",
  initComponent : function() {
    this.ls_detail_handler = Lino.households.Households.detail;
    this.ls_insert_handler = Lino.households.Households.insert;
    Lino.households.Households.detailPanel.superclass.initComponent.call(this);
  }
});

Lino.households.Households.detail = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.households.Households.detailPanel(p);
});
Lino.households.Households.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.households.Households.GridPanel(p);
});

// js_render_GridPanel_class contacts.Persons
Lino.contacts.Persons.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "No data to display." },
  ls_url : "/contacts/Persons",
  ls_bbar_actions : [ { "itemId": "insert", "menu_item_text": "Nouveau", "must_save": true, "tooltip": "Insert a new record", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-new", "overflowText": "Nouveau", "auto_save": true }, { "itemId": "detail", "menu_item_text": "D\u00e9tail", "tooltip": "Open a detail window on this record", "panel_btn_handler": Lino.show_detail, "iconCls": "x-tbar-detail", "overflowText": "D\u00e9tail", "auto_save": true }, { "itemId": null, "menu_item_text": "Supprimer", "tooltip": "Delete this record", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "Supprimer", "auto_save": false } ],
  title : "Personnes",
  page_length : 20,
  params_panel_hidden : true,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "name": "name_column" }, { "name": "address_column" }, { "name": "email" }, { "name": "phone" }, { "name": "gsm" }, { "type": "int", "name": "id" }, { "name": "language" }, 'languageHidden', { "name": "created" }, { "name": "modified" }, { "name": "country" }, 'countryHidden', { "name": "city" }, 'cityHidden', { "name": "region" }, 'regionHidden', { "name": "zip_code" }, { "name": "name" }, { "name": "addr1" }, { "name": "street_prefix" }, { "name": "street" }, { "name": "street_no" }, { "name": "street_box" }, { "name": "addr2" }, { "name": "url" }, { "name": "fax" }, { "name": "remarks" }, { "type": "boolean", "name": "is_obsolete" }, { "name": "activity" }, 'activityHidden', { "name": "bank_account1" }, { "name": "bank_account2" }, { "name": "first_name" }, { "name": "last_name" }, { "name": "gender" }, 'genderHidden', { "name": "birth_date" }, { "name": "title" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 5,
  ls_grid_configs : [  ],
  content_type : 21,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 39,
  initComponent : function() {
    this.ls_detail_handler = Lino.contacts.Persons.detail;
    this.ls_insert_handler = Lino.contacts.Persons.insert;
    var ww = this.containing_window;
    var name_column_disp2822 = new Ext.form.DisplayField({ "disabled": true, "value": "<br/>", "always_enabled": true });
    var address_column_disp2823 = new Ext.form.DisplayField({ "disabled": true, "value": "<br/>", "always_enabled": true });
    var email2824 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 75 });
    var phone2825 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var gsm2826 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var id2827 = new Ext.form.NumberField({ "selectOnFocus": true });
    var language2828 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "store": [ [ "de", "German" ], [ "fr", "French" ], [ "nl", "Dutch" ] ], "allowBlank": false, "value": "de" });
    var created2829 = new Ext.form.DisplayField({ "disabled": true, "value": "<br>" });
    var modified2830 = new Ext.form.DisplayField({ "disabled": true, "value": "<br>" });
    var country2831 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/contacts/Persons/country", "method": "GET" }) }), "pageSize": 20, "emptyText": "Choisir Pays..." });
    var city2832 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "forceSelection": false, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/contacts/Persons/city", "method": "GET" }) }), "pageSize": 20, "emptyText": "Choisir Place..." });
    var region2833 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/contacts/Persons/region", "method": "GET" }) }), "pageSize": 20, "emptyText": "Choisir Place..." });
    var zip_code2834 = new Ext.form.TextField({ "selectOnFocus": true, "boxMinWidth": Lino.chars2width(10), "maxLength": 10 });
    var name2835 = new Ext.form.TextField({ "selectOnFocus": true, "allowBlank": false, "maxLength": 200 });
    var addr12836 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var street_prefix2837 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var street2838 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var street_no2839 = new Ext.form.TextField({ "selectOnFocus": true, "boxMinWidth": Lino.chars2width(10), "maxLength": 10 });
    var street_box2840 = new Ext.form.TextField({ "selectOnFocus": true, "boxMinWidth": Lino.chars2width(10), "maxLength": 10 });
    var addr22841 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var url2842 = new Lino.URLField({ "selectOnFocus": true, "maxLength": 200 });
    var fax2843 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var remarks2844 = new Ext.form.TextArea({ "selectOnFocus": true, "growMax": 2000 });
    var is_obsolete2845 = new Ext.form.Checkbox({ "selectOnFocus": true, "checked": false });
    var activity2846 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/contacts/Persons/activity", "method": "GET" }) }), "pageSize": 20, "emptyText": "Choisir Activit\u00e9..." });
    var bank_account12847 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 40 });
    var bank_account22848 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 40 });
    var first_name2849 = new Ext.form.TextField({ "selectOnFocus": true, "allowBlank": false, "maxLength": 200 });
    var last_name2850 = new Ext.form.TextField({ "selectOnFocus": true, "allowBlank": false, "maxLength": 200 });
    var gender2851 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "forceSelection": true, "store": Lino.lino.Genders });
    var birth_date2852 = new Lino.IncompleteDateField({ "selectOnFocus": true });
    var title2853 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    this.before_row_edit = function(record) {
      city2832.setContextValue('country',record ? record.data['countryHidden'] : undefined);
      city2832.setContextValue('region',record ? record.data['regionHidden'] : undefined);
      region2833.setContextValue('country',record ? record.data['countryHidden'] : undefined);
    };
    this.onRender = function(ct, position) {
      country2831.on('change',Lino.chooser_handler(city2832,'country'));
      region2833.on('change',Lino.chooser_handler(city2832,'region'));
      country2831.on('change',Lino.chooser_handler(region2833,'country'));
      Lino.contacts.Persons.GridPanel.superclass.onRender.call(this, ct, position);
    }
    this.ls_columns = [ { "width": Lino.chars2width(21), "colIndex": 0, "sortable": false, "dataIndex": "name_column", "header": "Name", "editable": false }, { "width": Lino.chars2width(31), "colIndex": 1, "sortable": false, "dataIndex": "address_column", "header": "Addresse", "editable": false }, { "colIndex": 2, "sortable": true, "header": "E-mail", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "email", "editor": email2824 }, { "colIndex": 3, "sortable": true, "header": "T\u00e9l\u00e9phone", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(11), "dataIndex": "phone", "editor": phone2825 }, { "colIndex": 4, "sortable": true, "header": "GSM", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(11), "dataIndex": "gsm", "editor": gsm2826 }, new Lino.NullNumberColumn({ "colIndex": 5, "sortable": true, "format": "0", "editable": true, "filter": { "type": "numeric" }, "header": "ID", "renderer": Lino.id_renderer, "editor": id2827, "width": Lino.chars2width(6), "dataIndex": "id" }), { "colIndex": 6, "sortable": true, "header": "Langue", "editable": true, "tooltip": "Die Sprache, in der Dokumente ausgestellt werden sollen.", "filter": { "type": "string" }, "width": Lino.chars2width(11), "dataIndex": "language", "editor": language2828 }, { "width": Lino.chars2width(17), "colIndex": 7, "sortable": true, "dataIndex": "created", "header": "Cr\u00e9\u00e9", "hidden": true, "editable": false }, { "width": Lino.chars2width(17), "colIndex": 8, "sortable": true, "dataIndex": "modified", "header": "Modified", "hidden": true, "editable": false }, { "colIndex": 9, "sortable": true, "header": "Pays", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('countryHidden','Lino.countries.Countries.detail'), "editor": country2831, "dataIndex": "country" }, { "colIndex": 10, "sortable": true, "header": "Place", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "city", "editor": city2832 }, { "colIndex": 11, "sortable": true, "header": "Region", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "region", "editor": region2833 }, { "colIndex": 12, "sortable": true, "header": "Zip code", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(12), "dataIndex": "zip_code", "editor": zip_code2834 }, { "colIndex": 13, "sortable": true, "header": "Name", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "name", "editor": name2835 }, { "colIndex": 14, "sortable": true, "header": "Ligne avant le nom de rue", "editable": true, "tooltip": "Address line before street", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "addr1", "editor": addr12836 }, { "colIndex": 15, "sortable": true, "header": "Pr\u00e9fixe rue", "editable": true, "tooltip": "Text to print before name of street, but to ignore for sorting.", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "street_prefix", "editor": street_prefix2837 }, { "colIndex": 16, "sortable": true, "header": "Rue", "editable": true, "tooltip": "Name of street. Without house number.", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "street", "editor": street2838 }, { "colIndex": 17, "sortable": true, "header": "N\u00b0", "editable": true, "tooltip": "House number", "filter": { "type": "string" }, "width": Lino.chars2width(12), "dataIndex": "street_no", "editor": street_no2839 }, { "colIndex": 18, "sortable": true, "header": "bo\u00eete", "editable": true, "tooltip": "Text to print after :attr:`steet_no` on the same line", "filter": { "type": "string" }, "width": Lino.chars2width(12), "dataIndex": "street_box", "editor": street_box2840 }, { "colIndex": 19, "sortable": true, "header": "Ligne apr\u00e8s le nom de rue", "editable": true, "tooltip": "Address line to print below street line", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "addr2", "editor": addr22841 }, { "colIndex": 20, "sortable": true, "header": "URL", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "url", "editor": url2842 }, { "colIndex": 21, "sortable": true, "header": "Fax", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "fax", "editor": fax2843 }, { "colIndex": 22, "sortable": false, "header": "Remarques", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(61), "renderer": Lino.text_renderer, "editor": remarks2844, "dataIndex": "remarks" }, { "colIndex": 23, "sortable": false, "xtype": "checkcolumn", "header": "obsolete", "editable": true, "tooltip": "Altf\u00e4lle sind Partner, deren Stammdaten nicht mehr gepflegt werden und \nf\u00fcr neue Operationen nicht benutzt werden k\u00f6nnen.", "filter": { "type": "boolean" }, "width": Lino.chars2width(11), "dataIndex": "is_obsolete" }, { "colIndex": 24, "sortable": true, "header": "Activit\u00e9", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "activity", "hidden": true, "editor": activity2846 }, { "colIndex": 25, "sortable": true, "header": "Compte en banque 1", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "bank_account1", "hidden": true, "editor": bank_account12847 }, { "colIndex": 26, "sortable": true, "header": "Compte en banque 2", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "bank_account2", "hidden": true, "editor": bank_account22848 }, { "colIndex": 27, "sortable": true, "header": "Pr\u00e9nom", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "first_name", "editor": first_name2849 }, { "colIndex": 28, "sortable": true, "header": "Nom de famille", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "last_name", "editor": last_name2850 }, { "colIndex": 29, "sortable": true, "header": "Sexe", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(12), "dataIndex": "gender", "editor": gender2851 }, { "colIndex": 30, "sortable": true, "header": "date de naissance", "editable": true, "tooltip": "Unkomplette Datumsangaben sind erlaubt, z.B. \"00.00.1980\" hei\u00dft \"irgendwann im Jahr 1980\", \"00.07.1980\" hei\u00dft \"im Juli 1980\"oder \"23.07.0000\" hei\u00dft \"an einem 23. Juli\".", "filter": { "type": "string" }, "width": Lino.chars2width(13), "dataIndex": "birth_date", "editor": birth_date2852 }, { "colIndex": 31, "sortable": true, "header": "Allocution", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "title", "editor": title2853 } ];
    Lino.contacts.Persons.GridPanel.superclass.initComponent.call(this);
  }
});


Lino.contacts.Persons.insertPanel = Ext.extend(Lino.contacts.Persons.InsertFormPanel,{
  empty_title: "Nouveau Personnes",
  hide_navigator: true,
  params_panel_hidden: true,
  ls_bbar_actions: [ { "itemId": "post", "menu_item_text": "Cr\u00e9er", "tooltip": "Create the record and open a detail window on it", "panel_btn_handler": function(panel){panel.save(null,true,'post')}, "text": "Cr\u00e9er", "overflowText": "Cr\u00e9er", "auto_save": false }, { "itemId": "poststay", "menu_item_text": "Create without detail", "tooltip": "Don't open a detail window on the new record", "panel_btn_handler": function(panel){panel.save(null,false,'poststay')}, "text": "Create without detail", "overflowText": "Create without detail", "auto_save": false } ],
  ls_url: "/contacts/Persons",
  action_name: "insert",
  initComponent : function() {
    this.ls_detail_handler = Lino.contacts.Persons.detail;
    this.ls_insert_handler = Lino.contacts.Persons.insert;
    Lino.contacts.Persons.insertPanel.superclass.initComponent.call(this);
  }
});

Lino.contacts.Persons.insert = new Lino.WindowAction({ "draggable": true, "width": Lino.chars2width(60), "autoHeight": true, "maximizable": true, "modal": true, "maximized": false },function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.contacts.Persons.insertPanel(p);
});

Lino.contacts.Persons.detailPanel = Ext.extend(Lino.contacts.Persons.DetailFormPanel,{
  empty_title: "D\u00e9tail Personnes",
  params_panel_hidden: true,
  ls_bbar_actions: [ { "itemId": "put", "menu_item_text": "Enregistrer", "tooltip": "Save changes in this form", "panel_btn_handler": function(panel){panel.save(null,false,'put')}, "iconCls": "x-tbar-save", "overflowText": "Enregistrer", "auto_save": false }, { "itemId": "insert", "menu_item_text": "Nouveau", "must_save": true, "tooltip": "Insert a new record", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-new", "overflowText": "Nouveau", "auto_save": true }, { "itemId": null, "menu_item_text": "Supprimer", "tooltip": "Delete this record", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "Supprimer", "auto_save": false } ],
  ls_url: "/contacts/Persons",
  action_name: "detail",
  initComponent : function() {
    this.ls_detail_handler = Lino.contacts.Persons.detail;
    this.ls_insert_handler = Lino.contacts.Persons.insert;
    Lino.contacts.Persons.detailPanel.superclass.initComponent.call(this);
  }
});

Lino.contacts.Persons.detail = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.contacts.Persons.detailPanel(p);
});
Lino.contacts.Persons.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  p.params_panel = new Lino.contacts.Persons.ParamsPanel({});
  return new Lino.contacts.Persons.GridPanel(p);
});

// js_render_GridPanel_class pcsw.Clients
Lino.pcsw.Clients.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "No data to display." },
  ls_url : "/pcsw/Clients",
  ls_bbar_actions : [ { "itemId": "insert", "menu_item_text": "Nouveau", "must_save": true, "tooltip": "Insert a new record", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-new", "overflowText": "Nouveau", "auto_save": true }, { "itemId": "detail", "menu_item_text": "D\u00e9tail", "tooltip": "Open a detail window on this record", "panel_btn_handler": Lino.show_detail, "iconCls": "x-tbar-detail", "overflowText": "D\u00e9tail", "auto_save": true }, { "itemId": null, "menu_item_text": "Supprimer", "tooltip": "Delete this record", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "Supprimer", "auto_save": false }, { "itemId": "print_eid_content", "menu_item_text": "fiche eID", "must_save": true, "tooltip": "fiche eID", "panel_btn_handler": Lino.row_action_handler('print_eid_content','GET'), "iconCls": "x-tbar-vcard", "overflowText": "fiche eID", "auto_save": true } ],
  title : "Clients",
  page_length : 20,
  params_panel_hidden : true,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "name": "name_column" }, { "name": "client_state" }, 'client_stateHidden', { "name": "national_id" }, { "name": "gsm" }, { "name": "address_column" }, { "name": "age" }, { "name": "email" }, { "name": "phone" }, { "type": "int", "name": "id" }, { "name": "bank_account1" }, { "name": "aid_type" }, 'aid_typeHidden', { "name": "language" }, 'languageHidden', { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 9,
  ls_grid_configs : [  ],
  content_type : 53,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 16,
  initComponent : function() {
    this.ls_detail_handler = Lino.pcsw.Clients.detail;
    this.ls_insert_handler = Lino.pcsw.Clients.insert;
    var ww = this.containing_window;
    var name_column_disp2855 = new Ext.form.DisplayField({ "disabled": true, "value": "<br/>", "always_enabled": true });
    var client_state2856 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "forceSelection": true, "allowBlank": false, "store": Lino.pcsw.ClientStates });
    var national_id2857 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var gsm2858 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var address_column_disp2859 = new Ext.form.DisplayField({ "disabled": true, "value": "<br/>", "always_enabled": true });
    var age_disp2860 = new Ext.form.DisplayField({ "disabled": true, "value": "<br/>", "always_enabled": true });
    var email2861 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 75 });
    var phone2862 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var id2863 = new Ext.form.NumberField({ "selectOnFocus": true });
    var bank_account12864 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 40 });
    var aid_type2865 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/pcsw/Clients/aid_type", "method": "GET" }) }), "pageSize": 20, "emptyText": "Choisir Type d'aide sociale..." });
    var language2866 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "store": [ [ "de", "German" ], [ "fr", "French" ], [ "nl", "Dutch" ] ], "allowBlank": false, "value": "de" });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ { "width": Lino.chars2width(21), "colIndex": 0, "sortable": false, "dataIndex": "name_column", "header": "Name", "editable": false }, { "colIndex": 1, "sortable": true, "header": "State", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(13), "dataIndex": "client_state", "editor": client_state2856 }, { "colIndex": 2, "sortable": true, "header": "NISS", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(11), "dataIndex": "national_id", "editor": national_id2857 }, { "colIndex": 3, "sortable": true, "header": "GSM", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(11), "dataIndex": "gsm", "editor": gsm2858 }, { "width": Lino.chars2width(31), "colIndex": 4, "sortable": false, "dataIndex": "address_column", "header": "Addresse", "editable": false }, { "width": Lino.chars2width(11), "colIndex": 5, "sortable": false, "dataIndex": "age", "header": "\u00e2ge", "editable": false }, { "colIndex": 6, "sortable": true, "header": "E-mail", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "email", "editor": email2861 }, { "colIndex": 7, "sortable": true, "header": "T\u00e9l\u00e9phone", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(11), "dataIndex": "phone", "editor": phone2862 }, new Lino.NullNumberColumn({ "colIndex": 8, "sortable": true, "format": "0", "editable": true, "filter": { "type": "numeric" }, "header": "ID", "renderer": Lino.id_renderer, "editor": id2863, "width": Lino.chars2width(6), "dataIndex": "id" }), { "colIndex": 9, "sortable": true, "header": "Compte en banque 1", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "bank_account1", "hidden": true, "editor": bank_account12864 }, { "colIndex": 10, "sortable": true, "header": "Type d'aide sociale", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "aid_type", "editor": aid_type2865 }, { "colIndex": 11, "sortable": true, "header": "Langue", "editable": true, "tooltip": "Die Sprache, in der Dokumente ausgestellt werden sollen.", "filter": { "type": "string" }, "width": Lino.chars2width(11), "dataIndex": "language", "editor": language2866 } ];
    Lino.pcsw.Clients.GridPanel.superclass.initComponent.call(this);
  }
});


Lino.pcsw.Clients.insertPanel = Ext.extend(Lino.pcsw.Clients.InsertFormPanel,{
  empty_title: "Nouveau Clients",
  hide_navigator: true,
  params_panel_hidden: true,
  ls_bbar_actions: [ { "itemId": "post", "menu_item_text": "Cr\u00e9er", "tooltip": "Create the record and open a detail window on it", "panel_btn_handler": function(panel){panel.save(null,true,'post')}, "text": "Cr\u00e9er", "overflowText": "Cr\u00e9er", "auto_save": false }, { "itemId": "poststay", "menu_item_text": "Create without detail", "tooltip": "Don't open a detail window on the new record", "panel_btn_handler": function(panel){panel.save(null,false,'poststay')}, "text": "Create without detail", "overflowText": "Create without detail", "auto_save": false } ],
  ls_url: "/pcsw/Clients",
  action_name: "insert",
  initComponent : function() {
    this.ls_detail_handler = Lino.pcsw.Clients.detail;
    this.ls_insert_handler = Lino.pcsw.Clients.insert;
    Lino.pcsw.Clients.insertPanel.superclass.initComponent.call(this);
  }
});

Lino.pcsw.Clients.insert = new Lino.WindowAction({ "draggable": true, "width": Lino.chars2width(60), "autoHeight": true, "maximizable": true, "modal": true, "maximized": false },function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.pcsw.Clients.insertPanel(p);
});
Lino.pcsw.Clients.wf1 = function(rp,pk) { 
  Lino.run_row_action(rp,"/pcsw/Clients",pk,"wf1");
};
Lino.pcsw.Clients.wf3 = function(rp,pk) { 
  Lino.run_row_action(rp,"/pcsw/Clients",pk,"wf3");
};

Lino.pcsw.Clients.detailPanel = Ext.extend(Lino.pcsw.Clients.DetailFormPanel,{
  empty_title: "D\u00e9tail Clients",
  params_panel_hidden: true,
  ls_bbar_actions: [ { "itemId": "put", "menu_item_text": "Enregistrer", "tooltip": "Save changes in this form", "panel_btn_handler": function(panel){panel.save(null,false,'put')}, "iconCls": "x-tbar-save", "overflowText": "Enregistrer", "auto_save": false }, { "itemId": "insert", "menu_item_text": "Nouveau", "must_save": true, "tooltip": "Insert a new record", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-new", "overflowText": "Nouveau", "auto_save": true }, { "itemId": null, "menu_item_text": "Supprimer", "tooltip": "Delete this record", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "Supprimer", "auto_save": false }, { "itemId": "print_eid_content", "menu_item_text": "fiche eID", "must_save": true, "tooltip": "fiche eID", "panel_btn_handler": Lino.row_action_handler('print_eid_content','GET'), "iconCls": "x-tbar-vcard", "overflowText": "fiche eID", "auto_save": true } ],
  ls_url: "/pcsw/Clients",
  action_name: "detail",
  initComponent : function() {
    this.ls_detail_handler = Lino.pcsw.Clients.detail;
    this.ls_insert_handler = Lino.pcsw.Clients.insert;
    Lino.pcsw.Clients.detailPanel.superclass.initComponent.call(this);
  }
});

Lino.pcsw.Clients.detail = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.pcsw.Clients.detailPanel(p);
});
Lino.pcsw.Clients.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  p.params_panel = new Lino.pcsw.Clients.ParamsPanel({});
  return new Lino.pcsw.Clients.GridPanel(p);
});

// js_render_GridPanel_class pcsw.IntegClients
Lino.pcsw.IntegClients.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "No data to display." },
  ls_url : "/pcsw/IntegClients",
  ls_bbar_actions : [ { "itemId": "detail", "menu_item_text": "D\u00e9tail", "tooltip": "Open a detail window on this record", "panel_btn_handler": Lino.show_detail, "iconCls": "x-tbar-detail", "overflowText": "D\u00e9tail", "auto_save": true }, { "itemId": null, "menu_item_text": "Supprimer", "tooltip": "Delete this record", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "Supprimer", "auto_save": false }, { "itemId": "print_eid_content", "menu_item_text": "fiche eID", "must_save": true, "tooltip": "fiche eID", "panel_btn_handler": Lino.row_action_handler('print_eid_content','GET'), "iconCls": "x-tbar-vcard", "overflowText": "fiche eID", "auto_save": true } ],
  title : "Clients",
  page_length : 20,
  params_panel_hidden : true,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "name": "name_column" }, { "type": "date", "name": "applies_from", "dateFormat": "d.m.Y" }, { "type": "date", "name": "applies_until", "dateFormat": "d.m.Y" }, { "name": "national_id" }, { "name": "gsm" }, { "name": "address_column" }, { "name": "age" }, { "name": "email" }, { "name": "phone" }, { "type": "int", "name": "id" }, { "name": "bank_account1" }, { "name": "aid_type" }, 'aid_typeHidden', { "name": "language" }, 'languageHidden', { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 9,
  ls_grid_configs : [  ],
  content_type : 53,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 16,
  initComponent : function() {
    this.ls_detail_handler = Lino.pcsw.IntegClients.detail;
    this.ls_insert_handler = Lino.pcsw.Clients.insert;
    var ww = this.containing_window;
    var name_column_disp2868 = new Ext.form.DisplayField({ "disabled": true, "value": "<br/>", "always_enabled": true });
    var applies_from2869 = new Lino.DateField({ "disabled": true });
    var applies_until2870 = new Lino.DateField({ "disabled": true });
    var national_id2871 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var gsm2872 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var address_column_disp2873 = new Ext.form.DisplayField({ "disabled": true, "value": "<br/>", "always_enabled": true });
    var age_disp2874 = new Ext.form.DisplayField({ "disabled": true, "value": "<br/>", "always_enabled": true });
    var email2875 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 75 });
    var phone2876 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var id2877 = new Ext.form.NumberField({ "selectOnFocus": true });
    var bank_account12878 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 40 });
    var aid_type2879 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/pcsw/IntegClients/aid_type", "method": "GET" }) }), "pageSize": 20, "emptyText": "Choisir Type d'aide sociale..." });
    var language2880 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "store": [ [ "de", "German" ], [ "fr", "French" ], [ "nl", "Dutch" ] ], "allowBlank": false, "value": "de" });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ { "width": Lino.chars2width(21), "colIndex": 0, "sortable": false, "dataIndex": "name_column", "header": "Name", "editable": false }, { "colIndex": 1, "sortable": false, "xtype": "datecolumn", "format": "d.m.Y", "editable": false, "header": "Contrat d\u00e9bute", "dataIndex": "applies_from", "width": Lino.chars2width(9) }, { "colIndex": 2, "sortable": false, "xtype": "datecolumn", "format": "d.m.Y", "editable": false, "header": "Contrat se termine", "dataIndex": "applies_until", "width": Lino.chars2width(9) }, { "colIndex": 3, "sortable": true, "header": "NISS", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(11), "dataIndex": "national_id", "editor": national_id2871 }, { "colIndex": 4, "sortable": true, "header": "GSM", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(11), "dataIndex": "gsm", "editor": gsm2872 }, { "width": Lino.chars2width(31), "colIndex": 5, "sortable": false, "dataIndex": "address_column", "header": "Addresse", "editable": false }, { "width": Lino.chars2width(11), "colIndex": 6, "sortable": false, "dataIndex": "age", "header": "\u00e2ge", "editable": false }, { "colIndex": 7, "sortable": true, "header": "E-mail", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "email", "editor": email2875 }, { "colIndex": 8, "sortable": true, "header": "T\u00e9l\u00e9phone", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(11), "dataIndex": "phone", "editor": phone2876 }, new Lino.NullNumberColumn({ "colIndex": 9, "sortable": true, "format": "0", "editable": true, "filter": { "type": "numeric" }, "header": "ID", "renderer": Lino.id_renderer, "editor": id2877, "width": Lino.chars2width(6), "dataIndex": "id" }), { "colIndex": 10, "sortable": true, "header": "Compte en banque 1", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "bank_account1", "hidden": true, "editor": bank_account12878 }, { "colIndex": 11, "sortable": true, "header": "Type d'aide sociale", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "aid_type", "editor": aid_type2879 }, { "colIndex": 12, "sortable": true, "header": "Langue", "editable": true, "tooltip": "Die Sprache, in der Dokumente ausgestellt werden sollen.", "filter": { "type": "string" }, "width": Lino.chars2width(11), "dataIndex": "language", "editor": language2880 } ];
    Lino.pcsw.IntegClients.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.pcsw.IntegClients.wf1 = function(rp,pk) { 
  Lino.run_row_action(rp,"/pcsw/IntegClients",pk,"wf1");
};
Lino.pcsw.IntegClients.wf3 = function(rp,pk) { 
  Lino.run_row_action(rp,"/pcsw/IntegClients",pk,"wf3");
};

Lino.pcsw.IntegClients.detailPanel = Ext.extend(Lino.pcsw.Clients.DetailFormPanel,{
  empty_title: "D\u00e9tail Clients",
  params_panel_hidden: true,
  ls_bbar_actions: [ { "itemId": "put", "menu_item_text": "Enregistrer", "tooltip": "Save changes in this form", "panel_btn_handler": function(panel){panel.save(null,false,'put')}, "iconCls": "x-tbar-save", "overflowText": "Enregistrer", "auto_save": false }, { "itemId": null, "menu_item_text": "Supprimer", "tooltip": "Delete this record", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "Supprimer", "auto_save": false }, { "itemId": "print_eid_content", "menu_item_text": "fiche eID", "must_save": true, "tooltip": "fiche eID", "panel_btn_handler": Lino.row_action_handler('print_eid_content','GET'), "iconCls": "x-tbar-vcard", "overflowText": "fiche eID", "auto_save": true } ],
  ls_url: "/pcsw/IntegClients",
  action_name: "detail",
  initComponent : function() {
    this.ls_detail_handler = Lino.pcsw.IntegClients.detail;
    this.ls_insert_handler = Lino.pcsw.Clients.insert;
    Lino.pcsw.IntegClients.detailPanel.superclass.initComponent.call(this);
  }
});

Lino.pcsw.IntegClients.detail = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.pcsw.IntegClients.detailPanel(p);
});
Lino.pcsw.IntegClients.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  p.params_panel = new Lino.pcsw.IntegClients.ParamsPanel({});
  return new Lino.pcsw.IntegClients.GridPanel(p);
});

// js_render_GridPanel_class pcsw.OverlappingContracts
Lino.pcsw.OverlappingContracts.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "No data to display." },
  ls_url : "/pcsw/OverlappingContracts",
  ls_bbar_actions : [ { "itemId": null, "menu_item_text": "Supprimer", "tooltip": "Delete this record", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "Supprimer", "auto_save": false } ],
  title : "contrats chevauchants",
  page_length : 20,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "type": "int", "name": "id" }, { "name": "created" }, { "name": "modified" }, { "name": "country" }, 'countryHidden', { "name": "city" }, 'cityHidden', { "name": "region" }, 'regionHidden', { "name": "zip_code" }, { "name": "name" }, { "name": "addr1" }, { "name": "street_prefix" }, { "name": "street" }, { "name": "street_no" }, { "name": "street_box" }, { "name": "addr2" }, { "name": "language" }, 'languageHidden', { "name": "email" }, { "name": "url" }, { "name": "phone" }, { "name": "gsm" }, { "name": "fax" }, { "name": "remarks" }, { "type": "boolean", "name": "is_obsolete" }, { "name": "activity" }, 'activityHidden', { "name": "bank_account1" }, { "name": "bank_account2" }, { "name": "first_name" }, { "name": "last_name" }, { "name": "gender" }, 'genderHidden', { "name": "birth_date" }, { "name": "title" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 0,
  ls_grid_configs : [  ],
  content_type : 21,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 37,
  initComponent : function() {
    var ww = this.containing_window;
    var id2882 = new Ext.form.NumberField({ "selectOnFocus": true });
    var created2883 = new Ext.form.DisplayField({ "disabled": true, "value": "<br>" });
    var modified2884 = new Ext.form.DisplayField({ "disabled": true, "value": "<br>" });
    var country2885 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/pcsw/OverlappingContracts/country", "method": "GET" }) }), "pageSize": 20, "emptyText": "Choisir Pays..." });
    var city2886 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "forceSelection": false, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/pcsw/OverlappingContracts/city", "method": "GET" }) }), "pageSize": 20, "emptyText": "Choisir Place..." });
    var region2887 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/pcsw/OverlappingContracts/region", "method": "GET" }) }), "pageSize": 20, "emptyText": "Choisir Place..." });
    var zip_code2888 = new Ext.form.TextField({ "selectOnFocus": true, "boxMinWidth": Lino.chars2width(10), "maxLength": 10 });
    var name2889 = new Ext.form.TextField({ "selectOnFocus": true, "allowBlank": false, "maxLength": 200 });
    var addr12890 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var street_prefix2891 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var street2892 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var street_no2893 = new Ext.form.TextField({ "selectOnFocus": true, "boxMinWidth": Lino.chars2width(10), "maxLength": 10 });
    var street_box2894 = new Ext.form.TextField({ "selectOnFocus": true, "boxMinWidth": Lino.chars2width(10), "maxLength": 10 });
    var addr22895 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var language2896 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "store": [ [ "de", "German" ], [ "fr", "French" ], [ "nl", "Dutch" ] ], "allowBlank": false, "value": "de" });
    var email2897 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 75 });
    var url2898 = new Lino.URLField({ "selectOnFocus": true, "maxLength": 200 });
    var phone2899 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var gsm2900 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var fax2901 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var remarks2902 = new Ext.form.TextArea({ "selectOnFocus": true, "growMax": 2000 });
    var is_obsolete2903 = new Ext.form.Checkbox({ "selectOnFocus": true, "checked": false });
    var activity2904 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/pcsw/OverlappingContracts/activity", "method": "GET" }) }), "pageSize": 20, "emptyText": "Choisir Activit\u00e9..." });
    var bank_account12905 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 40 });
    var bank_account22906 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 40 });
    var first_name2907 = new Ext.form.TextField({ "selectOnFocus": true, "allowBlank": false, "maxLength": 200 });
    var last_name2908 = new Ext.form.TextField({ "selectOnFocus": true, "allowBlank": false, "maxLength": 200 });
    var gender2909 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "forceSelection": true, "store": Lino.lino.Genders });
    var birth_date2910 = new Lino.IncompleteDateField({ "selectOnFocus": true });
    var title2911 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    this.before_row_edit = function(record) {
      city2886.setContextValue('country',record ? record.data['countryHidden'] : undefined);
      city2886.setContextValue('region',record ? record.data['regionHidden'] : undefined);
      region2887.setContextValue('country',record ? record.data['countryHidden'] : undefined);
    };
    this.onRender = function(ct, position) {
      country2885.on('change',Lino.chooser_handler(city2886,'country'));
      region2887.on('change',Lino.chooser_handler(city2886,'region'));
      country2885.on('change',Lino.chooser_handler(region2887,'country'));
      Lino.pcsw.OverlappingContracts.GridPanel.superclass.onRender.call(this, ct, position);
    }
    this.ls_columns = [ new Lino.NullNumberColumn({ "colIndex": 0, "sortable": true, "format": "0", "editable": true, "filter": { "type": "numeric" }, "header": "ID", "renderer": Lino.id_renderer, "editor": id2882, "width": Lino.chars2width(6), "dataIndex": "id" }), { "width": Lino.chars2width(17), "colIndex": 1, "sortable": true, "dataIndex": "created", "header": "Cr\u00e9\u00e9", "hidden": true, "editable": false }, { "width": Lino.chars2width(17), "colIndex": 2, "sortable": true, "dataIndex": "modified", "header": "Modified", "hidden": true, "editable": false }, { "colIndex": 3, "sortable": true, "header": "Pays", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('countryHidden','Lino.countries.Countries.detail'), "editor": country2885, "dataIndex": "country" }, { "colIndex": 4, "sortable": true, "header": "Place", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "city", "editor": city2886 }, { "colIndex": 5, "sortable": true, "header": "Region", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "region", "editor": region2887 }, { "colIndex": 6, "sortable": true, "header": "Zip code", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(12), "dataIndex": "zip_code", "editor": zip_code2888 }, { "colIndex": 7, "sortable": true, "header": "Name", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "name", "editor": name2889 }, { "colIndex": 8, "sortable": true, "header": "Ligne avant le nom de rue", "editable": true, "tooltip": "Address line before street", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "addr1", "editor": addr12890 }, { "colIndex": 9, "sortable": true, "header": "Pr\u00e9fixe rue", "editable": true, "tooltip": "Text to print before name of street, but to ignore for sorting.", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "street_prefix", "editor": street_prefix2891 }, { "colIndex": 10, "sortable": true, "header": "Rue", "editable": true, "tooltip": "Name of street. Without house number.", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "street", "editor": street2892 }, { "colIndex": 11, "sortable": true, "header": "N\u00b0", "editable": true, "tooltip": "House number", "filter": { "type": "string" }, "width": Lino.chars2width(12), "dataIndex": "street_no", "editor": street_no2893 }, { "colIndex": 12, "sortable": true, "header": "bo\u00eete", "editable": true, "tooltip": "Text to print after :attr:`steet_no` on the same line", "filter": { "type": "string" }, "width": Lino.chars2width(12), "dataIndex": "street_box", "editor": street_box2894 }, { "colIndex": 13, "sortable": true, "header": "Ligne apr\u00e8s le nom de rue", "editable": true, "tooltip": "Address line to print below street line", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "addr2", "editor": addr22895 }, { "colIndex": 14, "sortable": true, "header": "Langue", "editable": true, "tooltip": "Die Sprache, in der Dokumente ausgestellt werden sollen.", "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "language", "editor": language2896 }, { "colIndex": 15, "sortable": true, "header": "E-mail", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "email", "editor": email2897 }, { "colIndex": 16, "sortable": true, "header": "URL", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "url", "editor": url2898 }, { "colIndex": 17, "sortable": true, "header": "T\u00e9l\u00e9phone", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "phone", "editor": phone2899 }, { "colIndex": 18, "sortable": true, "header": "GSM", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "gsm", "editor": gsm2900 }, { "colIndex": 19, "sortable": true, "header": "Fax", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "fax", "editor": fax2901 }, { "colIndex": 20, "sortable": false, "header": "Remarques", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(61), "renderer": Lino.text_renderer, "editor": remarks2902, "dataIndex": "remarks" }, { "colIndex": 21, "sortable": false, "xtype": "checkcolumn", "header": "obsolete", "editable": true, "tooltip": "Altf\u00e4lle sind Partner, deren Stammdaten nicht mehr gepflegt werden und \nf\u00fcr neue Operationen nicht benutzt werden k\u00f6nnen.", "filter": { "type": "boolean" }, "width": Lino.chars2width(11), "dataIndex": "is_obsolete" }, { "colIndex": 22, "sortable": true, "header": "Activit\u00e9", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "activity", "hidden": true, "editor": activity2904 }, { "colIndex": 23, "sortable": true, "header": "Compte en banque 1", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "bank_account1", "hidden": true, "editor": bank_account12905 }, { "colIndex": 24, "sortable": true, "header": "Compte en banque 2", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "bank_account2", "hidden": true, "editor": bank_account22906 }, { "colIndex": 25, "sortable": true, "header": "Pr\u00e9nom", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "first_name", "editor": first_name2907 }, { "colIndex": 26, "sortable": true, "header": "Nom de famille", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "last_name", "editor": last_name2908 }, { "colIndex": 27, "sortable": true, "header": "Sexe", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(12), "dataIndex": "gender", "editor": gender2909 }, { "colIndex": 28, "sortable": true, "header": "date de naissance", "editable": true, "tooltip": "Unkomplette Datumsangaben sind erlaubt, z.B. \"00.00.1980\" hei\u00dft \"irgendwann im Jahr 1980\", \"00.07.1980\" hei\u00dft \"im Juli 1980\"oder \"23.07.0000\" hei\u00dft \"an einem 23. Juli\".", "filter": { "type": "string" }, "width": Lino.chars2width(13), "dataIndex": "birth_date", "editor": birth_date2910 }, { "colIndex": 29, "sortable": true, "header": "Allocution", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "title", "editor": title2911 } ];
    Lino.pcsw.OverlappingContracts.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.pcsw.OverlappingContracts.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.pcsw.OverlappingContracts.GridPanel(p);
});

// js_render_GridPanel_class isip.Contracts
Lino.isip.Contracts.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "No data to display." },
  ls_url : "/isip/Contracts",
  ls_bbar_actions : [ { "itemId": "insert", "menu_item_text": "Nouveau", "must_save": true, "tooltip": "Insert a new record", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-new", "overflowText": "Nouveau", "auto_save": true }, { "itemId": "duplicate", "menu_item_text": "Dupliquer", "must_save": true, "tooltip": "Dupliquer", "panel_btn_handler": Lino.row_action_handler('duplicate','GET'), "iconCls": "x-tbar-duplicate", "overflowText": "Dupliquer", "auto_save": true }, { "itemId": "detail", "menu_item_text": "D\u00e9tail", "tooltip": "Open a detail window on this record", "panel_btn_handler": Lino.show_detail, "iconCls": "x-tbar-detail", "overflowText": "D\u00e9tail", "auto_save": true }, { "itemId": null, "menu_item_text": "Supprimer", "tooltip": "Delete this record", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "Supprimer", "auto_save": false }, { "itemId": "do_print", "menu_item_text": "Imprimer", "must_save": true, "tooltip": "Imprimer", "panel_btn_handler": Lino.row_action_handler('do_print','GET'), "iconCls": "x-tbar-print", "overflowText": "Imprimer", "auto_save": true }, { "itemId": "do_clear_cache", "menu_item_text": "Effacer la cache", "must_save": true, "tooltip": "Effacer la cache", "panel_btn_handler": Lino.row_action_handler('do_clear_cache','GET'), "iconCls": "x-tbar-clearcache", "overflowText": "Effacer la cache", "auto_save": true } ],
  title : "PIISs",
  page_length : 20,
  params_panel_hidden : true,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "type": "int", "name": "id" }, { "type": "date", "name": "applies_from", "dateFormat": "d.m.Y" }, { "type": "date", "name": "applies_until", "dateFormat": "d.m.Y" }, { "name": "client" }, 'clientHidden', { "name": "user" }, 'userHidden', { "name": "type" }, 'typeHidden', { "name": "build_time" }, { "name": "company" }, 'companyHidden', { "name": "contact_person" }, 'contact_personHidden', { "name": "contact_role" }, 'contact_roleHidden', { "type": "int", "name": "max_occurences" }, { "name": "signer1" }, 'signer1Hidden', { "name": "signer2" }, 'signer2Hidden', { "name": "language" }, 'languageHidden', { "type": "date", "name": "date_decided", "dateFormat": "d.m.Y" }, { "type": "date", "name": "date_issued", "dateFormat": "d.m.Y" }, { "name": "user_asd" }, 'user_asdHidden', { "name": "exam_policy" }, 'exam_policyHidden', { "name": "ending" }, 'endingHidden', { "type": "date", "name": "date_ended", "dateFormat": "d.m.Y" }, { "name": "stages" }, { "name": "goals" }, { "name": "duties_asd" }, { "name": "duties_dsbe" }, { "name": "duties_company" }, { "name": "duties_person" }, { "name": "study_type" }, 'study_typeHidden', { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 0,
  ls_grid_configs : [  ],
  content_type : 60,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 41,
  initComponent : function() {
    this.ls_detail_handler = Lino.isip.Contracts.detail;
    this.ls_insert_handler = Lino.isip.Contracts.insert;
    var ww = this.containing_window;
    var id2913 = new Ext.form.NumberField({ "selectOnFocus": true });
    var applies_from2914 = new Lino.DateField({ "selectOnFocus": true });
    var applies_until2915 = new Lino.DateField({ "selectOnFocus": true });
    var client2916 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/isip/Contracts/client", "method": "GET" }) }), "allowBlank": false, "pageSize": 20, "emptyText": "Choisir Client..." });
    var user2917 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/isip/Contracts/user", "method": "GET" }) }), "pageSize": 20, "emptyText": "Choisir Utilisateur..." });
    var type2918 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/isip/Contracts/type", "method": "GET" }) }), "pageSize": 20, "emptyText": "Choisir Type de PIIS..." });
    var build_time2919 = new Ext.form.DisplayField({ "disabled": true, "value": "<br>" });
    var company2920 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/isip/Contracts/company", "method": "GET" }) }), "pageSize": 20, "emptyText": "Choisir Organisation..." });
    var contact_person2921 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/isip/Contracts/contact_person", "method": "GET" }) }), "pageSize": 20, "emptyText": "Choisir Personne..." });
    var contact_role2922 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/isip/Contracts/contact_role", "method": "GET" }) }), "pageSize": 20, "emptyText": "Choisir Fonction..." });
    var max_occurences2923 = new Ext.form.NumberField({ "selectOnFocus": true });
    var signer12924 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/isip/Contracts/signer1", "method": "GET" }) }), "allowBlank": false, "pageSize": 20, "emptyText": "Choisir Personne..." });
    var signer22925 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/isip/Contracts/signer2", "method": "GET" }) }), "allowBlank": false, "pageSize": 20, "emptyText": "Choisir Personne..." });
    var language2926 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "store": [ [ "de", "German" ], [ "fr", "French" ], [ "nl", "Dutch" ] ], "allowBlank": false, "value": "de" });
    var date_decided2927 = new Lino.DateField({ "selectOnFocus": true });
    var date_issued2928 = new Lino.DateField({ "selectOnFocus": true });
    var user_asd2929 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/isip/Contracts/user_asd", "method": "GET" }) }), "pageSize": 20, "emptyText": "Choisir Utilisateur..." });
    var exam_policy2930 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/isip/Contracts/exam_policy", "method": "GET" }) }), "pageSize": 20, "emptyText": "Choisir M\u00e9thode d'examination..." });
    var ending2931 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/isip/Contracts/ending", "method": "GET" }) }), "pageSize": 20, "emptyText": "Choisir Cause d'abandon..." });
    var date_ended2932 = new Lino.DateField({ "selectOnFocus": true });
    var stages2933 = new Lino.RichTextPanel({ "selectOnFocus": true, "containing_panel": this, "title": "stages" });
    var goals2934 = new Lino.RichTextPanel({ "selectOnFocus": true, "containing_panel": this, "title": "buts" });
    var duties_asd2935 = new Lino.RichTextPanel({ "selectOnFocus": true, "containing_panel": this, "title": "devoirs SSG" });
    var duties_dsbe2936 = new Lino.RichTextPanel({ "selectOnFocus": true, "containing_panel": this, "title": "devois ISP" });
    var duties_company2937 = new Lino.RichTextPanel({ "selectOnFocus": true, "containing_panel": this, "title": "devoirs entreprise" });
    var duties_person2938 = new Lino.RichTextPanel({ "selectOnFocus": true, "containing_panel": this, "title": "Devoirs personne" });
    var study_type2939 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/isip/Contracts/study_type", "method": "GET" }) }), "pageSize": 20, "emptyText": "Choisir Type d'\u00e9tude..." });
    this.before_row_edit = function(record) {
      contact_person2921.setContextValue('company',record ? record.data['companyHidden'] : undefined);
      stages2933.refresh();
      goals2934.refresh();
      duties_asd2935.refresh();
      duties_dsbe2936.refresh();
      duties_company2937.refresh();
      duties_person2938.refresh();
    };
    this.onRender = function(ct, position) {
      company2920.on('change',Lino.chooser_handler(contact_person2921,'company'));
      Lino.isip.Contracts.GridPanel.superclass.onRender.call(this, ct, position);
    }
    this.ls_columns = [ new Lino.NullNumberColumn({ "colIndex": 0, "sortable": true, "format": "0", "editable": true, "filter": { "type": "numeric" }, "header": "ID", "renderer": Lino.id_renderer, "editor": id2913, "width": Lino.chars2width(6), "dataIndex": "id" }), { "colIndex": 1, "sortable": true, "xtype": "datecolumn", "format": "d.m.Y", "editable": true, "filter": { "type": "date", "dateFormat": "d.m.Y" }, "header": "D\u00e9but de contrat", "editor": applies_from2914, "width": Lino.chars2width(9), "dataIndex": "applies_from" }, { "colIndex": 2, "sortable": true, "xtype": "datecolumn", "format": "d.m.Y", "editable": true, "filter": { "type": "date", "dateFormat": "d.m.Y" }, "header": "Fin pr\u00e9vue", "editor": applies_until2915, "width": Lino.chars2width(9), "dataIndex": "applies_until" }, { "colIndex": 3, "sortable": true, "header": "Client", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('clientHidden','Lino.pcsw.Clients.detail'), "editor": client2916, "dataIndex": "client" }, { "colIndex": 4, "sortable": true, "header": "Auteur", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(16), "dataIndex": "user", "editor": user2917 }, { "colIndex": 5, "sortable": true, "header": "Type de contrat", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "type", "editor": type2918 }, { "width": Lino.chars2width(17), "colIndex": 6, "sortable": true, "dataIndex": "build_time", "header": "build time", "editable": false }, { "colIndex": 7, "sortable": true, "header": "Organisation", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('companyHidden','Lino.contacts.Companies.detail'), "editor": company2920, "dataIndex": "company" }, { "colIndex": 8, "sortable": true, "header": "repr\u00e9sent\u00e9 par", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('contact_personHidden','Lino.contacts.Persons.detail'), "editor": contact_person2921, "dataIndex": "contact_person" }, { "colIndex": 9, "sortable": true, "header": "repr\u00e9sent\u00e9 par", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "contact_role", "editor": contact_role2922 }, new Lino.NullNumberColumn({ "colIndex": 10, "sortable": true, "format": "0", "editable": true, "filter": { "type": "numeric" }, "header": "Number of occurences", "dataIndex": "max_occurences", "width": Lino.chars2width(6), "editor": max_occurences2923 }), { "colIndex": 11, "sortable": true, "header": "Secr\u00e9taire", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('signer1Hidden','Lino.contacts.Persons.detail'), "hidden": true, "editor": signer12924, "dataIndex": "signer1" }, { "colIndex": 12, "sortable": true, "header": "President", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('signer2Hidden','Lino.contacts.Persons.detail'), "hidden": true, "editor": signer22925, "dataIndex": "signer2" }, { "colIndex": 13, "sortable": true, "header": "Langue", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "language", "editor": language2926 }, { "colIndex": 14, "sortable": true, "xtype": "datecolumn", "format": "d.m.Y", "editable": true, "filter": { "type": "date", "dateFormat": "d.m.Y" }, "header": "D\u00e9cid\u00e9 le", "dataIndex": "date_decided", "hidden": true, "width": Lino.chars2width(9), "editor": date_decided2927 }, { "colIndex": 15, "sortable": true, "xtype": "datecolumn", "format": "d.m.Y", "editable": true, "filter": { "type": "date", "dateFormat": "d.m.Y" }, "header": "D\u00e9livr\u00e9 le", "dataIndex": "date_issued", "hidden": true, "width": Lino.chars2width(9), "editor": date_issued2928 }, { "colIndex": 16, "sortable": true, "header": "Responsable (SSG)", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(16), "dataIndex": "user_asd", "hidden": true, "editor": user_asd2929 }, { "colIndex": 17, "sortable": true, "header": "M\u00e9thode d'examination", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "exam_policy", "hidden": true, "editor": exam_policy2930 }, { "colIndex": 18, "sortable": true, "header": "Cause d'abandon", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "ending", "hidden": true, "editor": ending2931 }, { "colIndex": 19, "sortable": true, "xtype": "datecolumn", "format": "d.m.Y", "editable": true, "filter": { "type": "date", "dateFormat": "d.m.Y" }, "header": "Date de fin", "dataIndex": "date_ended", "hidden": true, "width": Lino.chars2width(9), "editor": date_ended2932 }, { "colIndex": 20, "sortable": false, "header": "stages", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(61), "renderer": Lino.text_renderer, "hidden": true, "editor": stages2933, "dataIndex": "stages" }, { "colIndex": 21, "sortable": false, "header": "goals", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(61), "renderer": Lino.text_renderer, "hidden": true, "editor": goals2934, "dataIndex": "goals" }, { "colIndex": 22, "sortable": false, "header": "duties_asd", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(61), "renderer": Lino.text_renderer, "hidden": true, "editor": duties_asd2935, "dataIndex": "duties_asd" }, { "colIndex": 23, "sortable": false, "header": "duties_dsbe", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(61), "renderer": Lino.text_renderer, "hidden": true, "editor": duties_dsbe2936, "dataIndex": "duties_dsbe" }, { "colIndex": 24, "sortable": false, "header": "duties_company", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(61), "renderer": Lino.text_renderer, "hidden": true, "editor": duties_company2937, "dataIndex": "duties_company" }, { "colIndex": 25, "sortable": false, "header": "duties_person", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(61), "renderer": Lino.text_renderer, "hidden": true, "editor": duties_person2938, "dataIndex": "duties_person" }, { "colIndex": 26, "sortable": true, "header": "Type d'\u00e9tude", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "study_type", "editor": study_type2939 } ];
    Lino.isip.Contracts.GridPanel.superclass.initComponent.call(this);
  }
});


Lino.isip.Contracts.insertPanel = Ext.extend(Lino.isip.Contracts.InsertFormPanel,{
  empty_title: "Nouveau PIISs",
  hide_navigator: true,
  params_panel_hidden: true,
  ls_bbar_actions: [ { "itemId": "post", "menu_item_text": "Cr\u00e9er", "tooltip": "Create the record and open a detail window on it", "panel_btn_handler": function(panel){panel.save(null,true,'post')}, "text": "Cr\u00e9er", "overflowText": "Cr\u00e9er", "auto_save": false }, { "itemId": "poststay", "menu_item_text": "Create without detail", "tooltip": "Don't open a detail window on the new record", "panel_btn_handler": function(panel){panel.save(null,false,'poststay')}, "text": "Create without detail", "overflowText": "Create without detail", "auto_save": false } ],
  ls_url: "/isip/Contracts",
  action_name: "insert",
  initComponent : function() {
    this.ls_detail_handler = Lino.isip.Contracts.detail;
    this.ls_insert_handler = Lino.isip.Contracts.insert;
    Lino.isip.Contracts.insertPanel.superclass.initComponent.call(this);
  }
});

Lino.isip.Contracts.insert = new Lino.WindowAction({ "draggable": true, "width": Lino.chars2width(60), "autoHeight": true, "maximizable": true, "modal": true, "maximized": false },function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.isip.Contracts.insertPanel(p);
});

Lino.isip.Contracts.detailPanel = Ext.extend(Lino.isip.Contracts.DetailFormPanel,{
  empty_title: "D\u00e9tail PIISs",
  params_panel_hidden: true,
  ls_bbar_actions: [ { "itemId": "put", "menu_item_text": "Enregistrer", "tooltip": "Save changes in this form", "panel_btn_handler": function(panel){panel.save(null,false,'put')}, "iconCls": "x-tbar-save", "overflowText": "Enregistrer", "auto_save": false }, { "itemId": "insert", "menu_item_text": "Nouveau", "must_save": true, "tooltip": "Insert a new record", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-new", "overflowText": "Nouveau", "auto_save": true }, { "itemId": "duplicate", "menu_item_text": "Dupliquer", "must_save": true, "tooltip": "Dupliquer", "panel_btn_handler": Lino.row_action_handler('duplicate','GET'), "iconCls": "x-tbar-duplicate", "overflowText": "Dupliquer", "auto_save": true }, { "itemId": null, "menu_item_text": "Supprimer", "tooltip": "Delete this record", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "Supprimer", "auto_save": false }, { "itemId": "do_print", "menu_item_text": "Imprimer", "must_save": true, "tooltip": "Imprimer", "panel_btn_handler": Lino.row_action_handler('do_print','GET'), "iconCls": "x-tbar-print", "overflowText": "Imprimer", "auto_save": true }, { "itemId": "do_clear_cache", "menu_item_text": "Effacer la cache", "must_save": true, "tooltip": "Effacer la cache", "panel_btn_handler": Lino.row_action_handler('do_clear_cache','GET'), "iconCls": "x-tbar-clearcache", "overflowText": "Effacer la cache", "auto_save": true } ],
  ls_url: "/isip/Contracts",
  action_name: "detail",
  initComponent : function() {
    this.ls_detail_handler = Lino.isip.Contracts.detail;
    this.ls_insert_handler = Lino.isip.Contracts.insert;
    Lino.isip.Contracts.detailPanel.superclass.initComponent.call(this);
  }
});

Lino.isip.Contracts.detail = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.isip.Contracts.detailPanel(p);
});
Lino.isip.Contracts.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  p.params_panel = new Lino.isip.Contracts.ParamsPanel({});
  return new Lino.isip.Contracts.GridPanel(p);
});

// js_render_GridPanel_class isip.MyContracts
Lino.isip.MyContracts.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "No data to display." },
  ls_url : "/isip/MyContracts",
  ls_bbar_actions : [ { "itemId": "insert", "menu_item_text": "Nouveau", "must_save": true, "tooltip": "Insert a new record", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-new", "overflowText": "Nouveau", "auto_save": true }, { "itemId": "duplicate", "menu_item_text": "Dupliquer", "must_save": true, "tooltip": "Dupliquer", "panel_btn_handler": Lino.row_action_handler('duplicate','GET'), "iconCls": "x-tbar-duplicate", "overflowText": "Dupliquer", "auto_save": true }, { "itemId": "detail", "menu_item_text": "D\u00e9tail", "tooltip": "Open a detail window on this record", "panel_btn_handler": Lino.show_detail, "iconCls": "x-tbar-detail", "overflowText": "D\u00e9tail", "auto_save": true }, { "itemId": null, "menu_item_text": "Supprimer", "tooltip": "Delete this record", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "Supprimer", "auto_save": false }, { "itemId": "do_print", "menu_item_text": "Imprimer", "must_save": true, "tooltip": "Imprimer", "panel_btn_handler": Lino.row_action_handler('do_print','GET'), "iconCls": "x-tbar-print", "overflowText": "Imprimer", "auto_save": true }, { "itemId": "do_clear_cache", "menu_item_text": "Effacer la cache", "must_save": true, "tooltip": "Effacer la cache", "panel_btn_handler": Lino.row_action_handler('do_clear_cache','GET'), "iconCls": "x-tbar-clearcache", "overflowText": "Effacer la cache", "auto_save": true } ],
  title : "PIISs",
  page_length : 20,
  params_panel_hidden : true,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "type": "int", "name": "id" }, { "type": "date", "name": "applies_from", "dateFormat": "d.m.Y" }, { "type": "date", "name": "applies_until", "dateFormat": "d.m.Y" }, { "name": "client" }, 'clientHidden', { "name": "user" }, 'userHidden', { "name": "type" }, 'typeHidden', { "name": "build_time" }, { "name": "company" }, 'companyHidden', { "name": "contact_person" }, 'contact_personHidden', { "name": "contact_role" }, 'contact_roleHidden', { "type": "int", "name": "max_occurences" }, { "name": "signer1" }, 'signer1Hidden', { "name": "signer2" }, 'signer2Hidden', { "name": "language" }, 'languageHidden', { "type": "date", "name": "date_decided", "dateFormat": "d.m.Y" }, { "type": "date", "name": "date_issued", "dateFormat": "d.m.Y" }, { "name": "user_asd" }, 'user_asdHidden', { "name": "exam_policy" }, 'exam_policyHidden', { "name": "ending" }, 'endingHidden', { "type": "date", "name": "date_ended", "dateFormat": "d.m.Y" }, { "name": "stages" }, { "name": "goals" }, { "name": "duties_asd" }, { "name": "duties_dsbe" }, { "name": "duties_company" }, { "name": "duties_person" }, { "name": "study_type" }, 'study_typeHidden', { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 0,
  ls_grid_configs : [  ],
  content_type : 60,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 41,
  initComponent : function() {
    this.ls_detail_handler = Lino.isip.MyContracts.detail;
    this.ls_insert_handler = Lino.isip.MyContracts.insert;
    var ww = this.containing_window;
    var id2941 = new Ext.form.NumberField({ "selectOnFocus": true });
    var applies_from2942 = new Lino.DateField({ "selectOnFocus": true });
    var applies_until2943 = new Lino.DateField({ "selectOnFocus": true });
    var client2944 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/isip/MyContracts/client", "method": "GET" }) }), "allowBlank": false, "pageSize": 20, "emptyText": "Choisir Client..." });
    var user2945 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/isip/MyContracts/user", "method": "GET" }) }), "pageSize": 20, "emptyText": "Choisir Utilisateur..." });
    var type2946 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/isip/MyContracts/type", "method": "GET" }) }), "pageSize": 20, "emptyText": "Choisir Type de PIIS..." });
    var build_time2947 = new Ext.form.DisplayField({ "disabled": true, "value": "<br>" });
    var company2948 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/isip/MyContracts/company", "method": "GET" }) }), "pageSize": 20, "emptyText": "Choisir Organisation..." });
    var contact_person2949 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/isip/MyContracts/contact_person", "method": "GET" }) }), "pageSize": 20, "emptyText": "Choisir Personne..." });
    var contact_role2950 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/isip/MyContracts/contact_role", "method": "GET" }) }), "pageSize": 20, "emptyText": "Choisir Fonction..." });
    var max_occurences2951 = new Ext.form.NumberField({ "selectOnFocus": true });
    var signer12952 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/isip/MyContracts/signer1", "method": "GET" }) }), "allowBlank": false, "pageSize": 20, "emptyText": "Choisir Personne..." });
    var signer22953 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/isip/MyContracts/signer2", "method": "GET" }) }), "allowBlank": false, "pageSize": 20, "emptyText": "Choisir Personne..." });
    var language2954 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "store": [ [ "de", "German" ], [ "fr", "French" ], [ "nl", "Dutch" ] ], "allowBlank": false, "value": "de" });
    var date_decided2955 = new Lino.DateField({ "selectOnFocus": true });
    var date_issued2956 = new Lino.DateField({ "selectOnFocus": true });
    var user_asd2957 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/isip/MyContracts/user_asd", "method": "GET" }) }), "pageSize": 20, "emptyText": "Choisir Utilisateur..." });
    var exam_policy2958 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/isip/MyContracts/exam_policy", "method": "GET" }) }), "pageSize": 20, "emptyText": "Choisir M\u00e9thode d'examination..." });
    var ending2959 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/isip/MyContracts/ending", "method": "GET" }) }), "pageSize": 20, "emptyText": "Choisir Cause d'abandon..." });
    var date_ended2960 = new Lino.DateField({ "selectOnFocus": true });
    var stages2961 = new Lino.RichTextPanel({ "selectOnFocus": true, "containing_panel": this, "title": "stages" });
    var goals2962 = new Lino.RichTextPanel({ "selectOnFocus": true, "containing_panel": this, "title": "buts" });
    var duties_asd2963 = new Lino.RichTextPanel({ "selectOnFocus": true, "containing_panel": this, "title": "devoirs SSG" });
    var duties_dsbe2964 = new Lino.RichTextPanel({ "selectOnFocus": true, "containing_panel": this, "title": "devois ISP" });
    var duties_company2965 = new Lino.RichTextPanel({ "selectOnFocus": true, "containing_panel": this, "title": "devoirs entreprise" });
    var duties_person2966 = new Lino.RichTextPanel({ "selectOnFocus": true, "containing_panel": this, "title": "Devoirs personne" });
    var study_type2967 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/isip/MyContracts/study_type", "method": "GET" }) }), "pageSize": 20, "emptyText": "Choisir Type d'\u00e9tude..." });
    this.before_row_edit = function(record) {
      contact_person2949.setContextValue('company',record ? record.data['companyHidden'] : undefined);
      stages2961.refresh();
      goals2962.refresh();
      duties_asd2963.refresh();
      duties_dsbe2964.refresh();
      duties_company2965.refresh();
      duties_person2966.refresh();
    };
    this.onRender = function(ct, position) {
      company2948.on('change',Lino.chooser_handler(contact_person2949,'company'));
      Lino.isip.MyContracts.GridPanel.superclass.onRender.call(this, ct, position);
    }
    this.ls_columns = [ new Lino.NullNumberColumn({ "colIndex": 0, "sortable": true, "format": "0", "editable": true, "filter": { "type": "numeric" }, "header": "ID", "renderer": Lino.id_renderer, "editor": id2941, "width": Lino.chars2width(6), "dataIndex": "id" }), { "colIndex": 1, "sortable": true, "xtype": "datecolumn", "format": "d.m.Y", "editable": true, "filter": { "type": "date", "dateFormat": "d.m.Y" }, "header": "D\u00e9but de contrat", "editor": applies_from2942, "width": Lino.chars2width(9), "dataIndex": "applies_from" }, { "colIndex": 2, "sortable": true, "xtype": "datecolumn", "format": "d.m.Y", "editable": true, "filter": { "type": "date", "dateFormat": "d.m.Y" }, "header": "Fin pr\u00e9vue", "editor": applies_until2943, "width": Lino.chars2width(9), "dataIndex": "applies_until" }, { "colIndex": 3, "sortable": true, "header": "Client", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('clientHidden','Lino.pcsw.Clients.detail'), "editor": client2944, "dataIndex": "client" }, { "colIndex": 4, "sortable": true, "header": "Auteur", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(16), "dataIndex": "user", "editor": user2945 }, { "colIndex": 5, "sortable": true, "header": "Type de contrat", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "type", "editor": type2946 }, { "width": Lino.chars2width(17), "colIndex": 6, "sortable": true, "dataIndex": "build_time", "header": "build time", "editable": false }, { "colIndex": 7, "sortable": true, "header": "Organisation", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('companyHidden','Lino.contacts.Companies.detail'), "editor": company2948, "dataIndex": "company" }, { "colIndex": 8, "sortable": true, "header": "repr\u00e9sent\u00e9 par", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('contact_personHidden','Lino.contacts.Persons.detail'), "editor": contact_person2949, "dataIndex": "contact_person" }, { "colIndex": 9, "sortable": true, "header": "repr\u00e9sent\u00e9 par", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "contact_role", "editor": contact_role2950 }, new Lino.NullNumberColumn({ "colIndex": 10, "sortable": true, "format": "0", "editable": true, "filter": { "type": "numeric" }, "header": "Number of occurences", "dataIndex": "max_occurences", "width": Lino.chars2width(6), "editor": max_occurences2951 }), { "colIndex": 11, "sortable": true, "header": "Secr\u00e9taire", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('signer1Hidden','Lino.contacts.Persons.detail'), "hidden": true, "editor": signer12952, "dataIndex": "signer1" }, { "colIndex": 12, "sortable": true, "header": "President", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('signer2Hidden','Lino.contacts.Persons.detail'), "hidden": true, "editor": signer22953, "dataIndex": "signer2" }, { "colIndex": 13, "sortable": true, "header": "Langue", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "language", "editor": language2954 }, { "colIndex": 14, "sortable": true, "xtype": "datecolumn", "format": "d.m.Y", "editable": true, "filter": { "type": "date", "dateFormat": "d.m.Y" }, "header": "D\u00e9cid\u00e9 le", "dataIndex": "date_decided", "hidden": true, "width": Lino.chars2width(9), "editor": date_decided2955 }, { "colIndex": 15, "sortable": true, "xtype": "datecolumn", "format": "d.m.Y", "editable": true, "filter": { "type": "date", "dateFormat": "d.m.Y" }, "header": "D\u00e9livr\u00e9 le", "dataIndex": "date_issued", "hidden": true, "width": Lino.chars2width(9), "editor": date_issued2956 }, { "colIndex": 16, "sortable": true, "header": "Responsable (SSG)", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(16), "dataIndex": "user_asd", "hidden": true, "editor": user_asd2957 }, { "colIndex": 17, "sortable": true, "header": "M\u00e9thode d'examination", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "exam_policy", "hidden": true, "editor": exam_policy2958 }, { "colIndex": 18, "sortable": true, "header": "Cause d'abandon", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "ending", "hidden": true, "editor": ending2959 }, { "colIndex": 19, "sortable": true, "xtype": "datecolumn", "format": "d.m.Y", "editable": true, "filter": { "type": "date", "dateFormat": "d.m.Y" }, "header": "Date de fin", "dataIndex": "date_ended", "hidden": true, "width": Lino.chars2width(9), "editor": date_ended2960 }, { "colIndex": 20, "sortable": false, "header": "stages", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(61), "renderer": Lino.text_renderer, "hidden": true, "editor": stages2961, "dataIndex": "stages" }, { "colIndex": 21, "sortable": false, "header": "goals", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(61), "renderer": Lino.text_renderer, "hidden": true, "editor": goals2962, "dataIndex": "goals" }, { "colIndex": 22, "sortable": false, "header": "duties_asd", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(61), "renderer": Lino.text_renderer, "hidden": true, "editor": duties_asd2963, "dataIndex": "duties_asd" }, { "colIndex": 23, "sortable": false, "header": "duties_dsbe", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(61), "renderer": Lino.text_renderer, "hidden": true, "editor": duties_dsbe2964, "dataIndex": "duties_dsbe" }, { "colIndex": 24, "sortable": false, "header": "duties_company", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(61), "renderer": Lino.text_renderer, "hidden": true, "editor": duties_company2965, "dataIndex": "duties_company" }, { "colIndex": 25, "sortable": false, "header": "duties_person", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(61), "renderer": Lino.text_renderer, "hidden": true, "editor": duties_person2966, "dataIndex": "duties_person" }, { "colIndex": 26, "sortable": true, "header": "Type d'\u00e9tude", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "study_type", "editor": study_type2967 } ];
    Lino.isip.MyContracts.GridPanel.superclass.initComponent.call(this);
  }
});


Lino.isip.MyContracts.insertPanel = Ext.extend(Lino.isip.Contracts.InsertFormPanel,{
  empty_title: "Nouveau PIISs",
  hide_navigator: true,
  params_panel_hidden: true,
  ls_bbar_actions: [ { "itemId": "post", "menu_item_text": "Cr\u00e9er", "tooltip": "Create the record and open a detail window on it", "panel_btn_handler": function(panel){panel.save(null,true,'post')}, "text": "Cr\u00e9er", "overflowText": "Cr\u00e9er", "auto_save": false }, { "itemId": "poststay", "menu_item_text": "Create without detail", "tooltip": "Don't open a detail window on the new record", "panel_btn_handler": function(panel){panel.save(null,false,'poststay')}, "text": "Create without detail", "overflowText": "Create without detail", "auto_save": false } ],
  ls_url: "/isip/MyContracts",
  action_name: "insert",
  initComponent : function() {
    this.ls_detail_handler = Lino.isip.MyContracts.detail;
    this.ls_insert_handler = Lino.isip.MyContracts.insert;
    Lino.isip.MyContracts.insertPanel.superclass.initComponent.call(this);
  }
});

Lino.isip.MyContracts.insert = new Lino.WindowAction({ "draggable": true, "width": Lino.chars2width(60), "autoHeight": true, "maximizable": true, "modal": true, "maximized": false },function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.isip.MyContracts.insertPanel(p);
});

Lino.isip.MyContracts.detailPanel = Ext.extend(Lino.isip.Contracts.DetailFormPanel,{
  empty_title: "D\u00e9tail PIISs",
  params_panel_hidden: true,
  ls_bbar_actions: [ { "itemId": "put", "menu_item_text": "Enregistrer", "tooltip": "Save changes in this form", "panel_btn_handler": function(panel){panel.save(null,false,'put')}, "iconCls": "x-tbar-save", "overflowText": "Enregistrer", "auto_save": false }, { "itemId": "insert", "menu_item_text": "Nouveau", "must_save": true, "tooltip": "Insert a new record", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-new", "overflowText": "Nouveau", "auto_save": true }, { "itemId": "duplicate", "menu_item_text": "Dupliquer", "must_save": true, "tooltip": "Dupliquer", "panel_btn_handler": Lino.row_action_handler('duplicate','GET'), "iconCls": "x-tbar-duplicate", "overflowText": "Dupliquer", "auto_save": true }, { "itemId": null, "menu_item_text": "Supprimer", "tooltip": "Delete this record", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "Supprimer", "auto_save": false }, { "itemId": "do_print", "menu_item_text": "Imprimer", "must_save": true, "tooltip": "Imprimer", "panel_btn_handler": Lino.row_action_handler('do_print','GET'), "iconCls": "x-tbar-print", "overflowText": "Imprimer", "auto_save": true }, { "itemId": "do_clear_cache", "menu_item_text": "Effacer la cache", "must_save": true, "tooltip": "Effacer la cache", "panel_btn_handler": Lino.row_action_handler('do_clear_cache','GET'), "iconCls": "x-tbar-clearcache", "overflowText": "Effacer la cache", "auto_save": true } ],
  ls_url: "/isip/MyContracts",
  action_name: "detail",
  initComponent : function() {
    this.ls_detail_handler = Lino.isip.MyContracts.detail;
    this.ls_insert_handler = Lino.isip.MyContracts.insert;
    Lino.isip.MyContracts.detailPanel.superclass.initComponent.call(this);
  }
});

Lino.isip.MyContracts.detail = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.isip.MyContracts.detailPanel(p);
});
Lino.isip.MyContracts.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  p.params_panel = new Lino.isip.Contracts.ParamsPanel({});
  return new Lino.isip.MyContracts.GridPanel(p);
});

// js_render_GridPanel_class jobs.JobProviders
Lino.jobs.JobProviders.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "No data to display." },
  ls_url : "/jobs/JobProviders",
  ls_bbar_actions : [ { "itemId": "insert", "menu_item_text": "Nouveau", "must_save": true, "tooltip": "Insert a new record", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-new", "overflowText": "Nouveau", "auto_save": true }, { "itemId": "detail", "menu_item_text": "D\u00e9tail", "tooltip": "Open a detail window on this record", "panel_btn_handler": Lino.show_detail, "iconCls": "x-tbar-detail", "overflowText": "D\u00e9tail", "auto_save": true }, { "itemId": null, "menu_item_text": "Supprimer", "tooltip": "Delete this record", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "Supprimer", "auto_save": false } ],
  title : "Employants",
  page_length : 20,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "name": "name" }, { "name": "email" }, { "name": "created" }, { "name": "modified" }, { "name": "country" }, 'countryHidden', { "name": "city" }, 'cityHidden', { "name": "region" }, 'regionHidden', { "name": "zip_code" }, { "name": "addr1" }, { "name": "street_prefix" }, { "name": "street" }, { "name": "street_no" }, { "name": "street_box" }, { "name": "addr2" }, { "name": "language" }, 'languageHidden', { "name": "url" }, { "name": "phone" }, { "name": "gsm" }, { "name": "fax" }, { "name": "remarks" }, { "type": "boolean", "name": "is_obsolete" }, { "name": "activity" }, 'activityHidden', { "name": "bank_account1" }, { "name": "bank_account2" }, { "name": "prefix" }, { "name": "vat_id" }, { "name": "type" }, 'typeHidden', { "name": "client_contact_type" }, 'client_contact_typeHidden', { "type": "int", "name": "id" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 35,
  ls_grid_configs : [  ],
  content_type : 75,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 37,
  initComponent : function() {
    this.ls_detail_handler = Lino.jobs.JobProviders.detail;
    this.ls_insert_handler = Lino.jobs.JobProviders.insert;
    var ww = this.containing_window;
    var name2969 = new Ext.form.TextField({ "selectOnFocus": true, "allowBlank": false, "maxLength": 200 });
    var email2970 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 75 });
    var created2971 = new Ext.form.DisplayField({ "disabled": true, "value": "<br>" });
    var modified2972 = new Ext.form.DisplayField({ "disabled": true, "value": "<br>" });
    var country2973 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/jobs/JobProviders/country", "method": "GET" }) }), "pageSize": 20, "emptyText": "Choisir Pays..." });
    var city2974 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "forceSelection": false, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/jobs/JobProviders/city", "method": "GET" }) }), "pageSize": 20, "emptyText": "Choisir Place..." });
    var region2975 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/jobs/JobProviders/region", "method": "GET" }) }), "pageSize": 20, "emptyText": "Choisir Place..." });
    var zip_code2976 = new Ext.form.TextField({ "selectOnFocus": true, "boxMinWidth": Lino.chars2width(10), "maxLength": 10 });
    var addr12977 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var street_prefix2978 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var street2979 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var street_no2980 = new Ext.form.TextField({ "selectOnFocus": true, "boxMinWidth": Lino.chars2width(10), "maxLength": 10 });
    var street_box2981 = new Ext.form.TextField({ "selectOnFocus": true, "boxMinWidth": Lino.chars2width(10), "maxLength": 10 });
    var addr22982 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var language2983 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "store": [ [ "de", "German" ], [ "fr", "French" ], [ "nl", "Dutch" ] ], "allowBlank": false, "value": "de" });
    var url2984 = new Lino.URLField({ "selectOnFocus": true, "maxLength": 200 });
    var phone2985 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var gsm2986 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var fax2987 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var remarks2988 = new Ext.form.TextArea({ "selectOnFocus": true, "growMax": 2000 });
    var is_obsolete2989 = new Ext.form.Checkbox({ "selectOnFocus": true, "checked": false });
    var activity2990 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/jobs/JobProviders/activity", "method": "GET" }) }), "pageSize": 20, "emptyText": "Choisir Activit\u00e9..." });
    var bank_account12991 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 40 });
    var bank_account22992 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 40 });
    var prefix2993 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var vat_id2994 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var type2995 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/jobs/JobProviders/type", "method": "GET" }) }), "pageSize": 20, "emptyText": "Choisir Type d'organisation..." });
    var client_contact_type2996 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/jobs/JobProviders/client_contact_type", "method": "GET" }) }), "pageSize": 20, "emptyText": "Choisir Type de contact client..." });
    var id2997 = new Ext.form.NumberField({ "selectOnFocus": true });
    this.before_row_edit = function(record) {
      city2974.setContextValue('country',record ? record.data['countryHidden'] : undefined);
      city2974.setContextValue('region',record ? record.data['regionHidden'] : undefined);
      region2975.setContextValue('country',record ? record.data['countryHidden'] : undefined);
    };
    this.onRender = function(ct, position) {
      country2973.on('change',Lino.chooser_handler(city2974,'country'));
      region2975.on('change',Lino.chooser_handler(city2974,'region'));
      country2973.on('change',Lino.chooser_handler(region2975,'country'));
      Lino.jobs.JobProviders.GridPanel.superclass.onRender.call(this, ct, position);
    }
    this.ls_columns = [ { "colIndex": 0, "sortable": true, "header": "Name", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "name", "editor": name2969 }, { "colIndex": 1, "sortable": true, "header": "E-mail", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "email", "editor": email2970 }, { "width": Lino.chars2width(17), "colIndex": 2, "sortable": true, "dataIndex": "created", "header": "Cr\u00e9\u00e9", "hidden": true, "editable": false }, { "width": Lino.chars2width(17), "colIndex": 3, "sortable": true, "dataIndex": "modified", "header": "Modified", "hidden": true, "editable": false }, { "colIndex": 4, "sortable": true, "header": "Pays", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('countryHidden','Lino.countries.Countries.detail'), "editor": country2973, "dataIndex": "country" }, { "colIndex": 5, "sortable": true, "header": "Place", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "city", "editor": city2974 }, { "colIndex": 6, "sortable": true, "header": "Region", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "region", "editor": region2975 }, { "colIndex": 7, "sortable": true, "header": "Zip code", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(12), "dataIndex": "zip_code", "editor": zip_code2976 }, { "colIndex": 8, "sortable": true, "header": "Ligne avant le nom de rue", "editable": true, "tooltip": "Address line before street", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "addr1", "editor": addr12977 }, { "colIndex": 9, "sortable": true, "header": "Pr\u00e9fixe rue", "editable": true, "tooltip": "Text to print before name of street, but to ignore for sorting.", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "street_prefix", "editor": street_prefix2978 }, { "colIndex": 10, "sortable": true, "header": "Rue", "editable": true, "tooltip": "Name of street. Without house number.", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "street", "editor": street2979 }, { "colIndex": 11, "sortable": true, "header": "N\u00b0", "editable": true, "tooltip": "House number", "filter": { "type": "string" }, "width": Lino.chars2width(12), "dataIndex": "street_no", "editor": street_no2980 }, { "colIndex": 12, "sortable": true, "header": "bo\u00eete", "editable": true, "tooltip": "Text to print after :attr:`steet_no` on the same line", "filter": { "type": "string" }, "width": Lino.chars2width(12), "dataIndex": "street_box", "editor": street_box2981 }, { "colIndex": 13, "sortable": true, "header": "Ligne apr\u00e8s le nom de rue", "editable": true, "tooltip": "Address line to print below street line", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "addr2", "editor": addr22982 }, { "colIndex": 14, "sortable": true, "header": "Langue", "editable": true, "tooltip": "Die Sprache, in der Dokumente ausgestellt werden sollen.", "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "language", "editor": language2983 }, { "colIndex": 15, "sortable": true, "header": "URL", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "url", "editor": url2984 }, { "colIndex": 16, "sortable": true, "header": "T\u00e9l\u00e9phone", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "phone", "editor": phone2985 }, { "colIndex": 17, "sortable": true, "header": "GSM", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "gsm", "editor": gsm2986 }, { "colIndex": 18, "sortable": true, "header": "Fax", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "fax", "editor": fax2987 }, { "colIndex": 19, "sortable": false, "header": "Remarques", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(61), "renderer": Lino.text_renderer, "editor": remarks2988, "dataIndex": "remarks" }, { "colIndex": 20, "sortable": false, "xtype": "checkcolumn", "header": "obsolete", "editable": true, "tooltip": "Altf\u00e4lle sind Partner, deren Stammdaten nicht mehr gepflegt werden und \nf\u00fcr neue Operationen nicht benutzt werden k\u00f6nnen.", "filter": { "type": "boolean" }, "width": Lino.chars2width(11), "dataIndex": "is_obsolete" }, { "colIndex": 21, "sortable": true, "header": "Activit\u00e9", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "activity", "hidden": true, "editor": activity2990 }, { "colIndex": 22, "sortable": true, "header": "Compte en banque 1", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "bank_account1", "hidden": true, "editor": bank_account12991 }, { "colIndex": 23, "sortable": true, "header": "Compte en banque 2", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "bank_account2", "hidden": true, "editor": bank_account22992 }, { "colIndex": 24, "sortable": true, "header": "prefix", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "prefix", "editor": prefix2993 }, { "colIndex": 25, "sortable": true, "header": "N\u00b0 de TVA", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "vat_id", "editor": vat_id2994 }, { "colIndex": 26, "sortable": true, "header": "Type de soci\u00e9t\u00e9", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "type", "editor": type2995 }, { "colIndex": 27, "sortable": true, "header": "Type de contact client", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "client_contact_type", "editor": client_contact_type2996 }, new Lino.NullNumberColumn({ "colIndex": 28, "sortable": true, "format": "0", "editable": true, "filter": { "type": "numeric" }, "header": "ID", "renderer": Lino.id_renderer, "editor": id2997, "width": Lino.chars2width(6), "dataIndex": "id" }) ];
    Lino.jobs.JobProviders.GridPanel.superclass.initComponent.call(this);
  }
});


Lino.jobs.JobProviders.insertPanel = Ext.extend(Lino.contacts.Companies.InsertFormPanel,{
  empty_title: "Nouveau Employants",
  hide_navigator: true,
  ls_bbar_actions: [ { "itemId": "post", "menu_item_text": "Cr\u00e9er", "tooltip": "Create the record and open a detail window on it", "panel_btn_handler": function(panel){panel.save(null,true,'post')}, "text": "Cr\u00e9er", "overflowText": "Cr\u00e9er", "auto_save": false }, { "itemId": "poststay", "menu_item_text": "Create without detail", "tooltip": "Don't open a detail window on the new record", "panel_btn_handler": function(panel){panel.save(null,false,'poststay')}, "text": "Create without detail", "overflowText": "Create without detail", "auto_save": false } ],
  ls_url: "/jobs/JobProviders",
  action_name: "insert",
  initComponent : function() {
    this.ls_detail_handler = Lino.jobs.JobProviders.detail;
    this.ls_insert_handler = Lino.jobs.JobProviders.insert;
    Lino.jobs.JobProviders.insertPanel.superclass.initComponent.call(this);
  }
});

Lino.jobs.JobProviders.insert = new Lino.WindowAction({ "draggable": true, "width": Lino.chars2width(60), "autoHeight": true, "maximizable": true, "modal": true, "maximized": false },function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.jobs.JobProviders.insertPanel(p);
});

Lino.jobs.JobProviders.detailPanel = Ext.extend(Lino.jobs.JobProviders.DetailFormPanel,{
  empty_title: "D\u00e9tail Employants",
  ls_bbar_actions: [ { "itemId": "put", "menu_item_text": "Enregistrer", "tooltip": "Save changes in this form", "panel_btn_handler": function(panel){panel.save(null,false,'put')}, "iconCls": "x-tbar-save", "overflowText": "Enregistrer", "auto_save": false }, { "itemId": "insert", "menu_item_text": "Nouveau", "must_save": true, "tooltip": "Insert a new record", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-new", "overflowText": "Nouveau", "auto_save": true }, { "itemId": null, "menu_item_text": "Supprimer", "tooltip": "Delete this record", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "Supprimer", "auto_save": false } ],
  ls_url: "/jobs/JobProviders",
  action_name: "detail",
  initComponent : function() {
    this.ls_detail_handler = Lino.jobs.JobProviders.detail;
    this.ls_insert_handler = Lino.jobs.JobProviders.insert;
    Lino.jobs.JobProviders.detailPanel.superclass.initComponent.call(this);
  }
});

Lino.jobs.JobProviders.detail = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.jobs.JobProviders.detailPanel(p);
});
Lino.jobs.JobProviders.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.jobs.JobProviders.GridPanel(p);
});

// js_render_GridPanel_class jobs.Contracts
Lino.jobs.Contracts.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "No data to display." },
  ls_url : "/jobs/Contracts",
  ls_bbar_actions : [ { "itemId": "insert", "menu_item_text": "Nouveau", "must_save": true, "tooltip": "Insert a new record", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-new", "overflowText": "Nouveau", "auto_save": true }, { "itemId": "duplicate", "menu_item_text": "Dupliquer", "must_save": true, "tooltip": "Dupliquer", "panel_btn_handler": Lino.row_action_handler('duplicate','GET'), "iconCls": "x-tbar-duplicate", "overflowText": "Dupliquer", "auto_save": true }, { "itemId": "detail", "menu_item_text": "D\u00e9tail", "tooltip": "Open a detail window on this record", "panel_btn_handler": Lino.show_detail, "iconCls": "x-tbar-detail", "overflowText": "D\u00e9tail", "auto_save": true }, { "itemId": null, "menu_item_text": "Supprimer", "tooltip": "Delete this record", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "Supprimer", "auto_save": false }, { "itemId": "do_print", "menu_item_text": "Imprimer", "must_save": true, "tooltip": "Imprimer", "panel_btn_handler": Lino.row_action_handler('do_print','GET'), "iconCls": "x-tbar-print", "overflowText": "Imprimer", "auto_save": true }, { "itemId": "do_clear_cache", "menu_item_text": "Effacer la cache", "must_save": true, "tooltip": "Effacer la cache", "panel_btn_handler": Lino.row_action_handler('do_clear_cache','GET'), "iconCls": "x-tbar-clearcache", "overflowText": "Effacer la cache", "auto_save": true } ],
  title : "Art.60\u00a77 contracts",
  page_length : 20,
  params_panel_hidden : true,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "type": "int", "name": "id" }, { "name": "job" }, 'jobHidden', { "type": "date", "name": "applies_from", "dateFormat": "d.m.Y" }, { "type": "date", "name": "applies_until", "dateFormat": "d.m.Y" }, { "name": "user" }, 'userHidden', { "name": "type" }, 'typeHidden', { "name": "build_time" }, { "name": "company" }, 'companyHidden', { "name": "contact_person" }, 'contact_personHidden', { "name": "contact_role" }, 'contact_roleHidden', { "type": "int", "name": "max_occurences" }, { "name": "signer1" }, 'signer1Hidden', { "name": "signer2" }, 'signer2Hidden', { "name": "client" }, 'clientHidden', { "name": "language" }, 'languageHidden', { "type": "date", "name": "date_decided", "dateFormat": "d.m.Y" }, { "type": "date", "name": "date_issued", "dateFormat": "d.m.Y" }, { "name": "user_asd" }, 'user_asdHidden', { "name": "exam_policy" }, 'exam_policyHidden', { "name": "ending" }, 'endingHidden', { "type": "date", "name": "date_ended", "dateFormat": "d.m.Y" }, { "type": "int", "name": "duration" }, { "name": "regime" }, 'regimeHidden', { "name": "schedule" }, 'scheduleHidden', { "name": "hourly_rate" }, { "name": "refund_rate" }, { "name": "reference_person" }, { "name": "responsibilities" }, { "name": "remark" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 0,
  ls_grid_configs : [  ],
  content_type : 71,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 45,
  initComponent : function() {
    this.ls_detail_handler = Lino.jobs.Contracts.detail;
    this.ls_insert_handler = Lino.jobs.Contracts.insert;
    var ww = this.containing_window;
    var id2999 = new Ext.form.NumberField({ "selectOnFocus": true });
    var job3000 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/jobs/Contracts/job", "method": "GET" }) }), "allowBlank": false, "pageSize": 20, "emptyText": "Choisir Emploi..." });
    var applies_from3001 = new Lino.DateField({ "selectOnFocus": true });
    var applies_until3002 = new Lino.DateField({ "selectOnFocus": true });
    var user3003 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/jobs/Contracts/user", "method": "GET" }) }), "pageSize": 20, "emptyText": "Choisir Utilisateur..." });
    var type3004 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/jobs/Contracts/type", "method": "GET" }) }), "pageSize": 20, "emptyText": "Choisir Type de contrat de travail..." });
    var build_time3005 = new Ext.form.DisplayField({ "disabled": true, "value": "<br>" });
    var company3006 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/jobs/Contracts/company", "method": "GET" }) }), "pageSize": 20, "emptyText": "Choisir Organisation..." });
    var contact_person3007 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/jobs/Contracts/contact_person", "method": "GET" }) }), "pageSize": 20, "emptyText": "Choisir Personne..." });
    var contact_role3008 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/jobs/Contracts/contact_role", "method": "GET" }) }), "pageSize": 20, "emptyText": "Choisir Fonction..." });
    var max_occurences3009 = new Ext.form.NumberField({ "selectOnFocus": true });
    var signer13010 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/jobs/Contracts/signer1", "method": "GET" }) }), "allowBlank": false, "pageSize": 20, "emptyText": "Choisir Personne..." });
    var signer23011 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/jobs/Contracts/signer2", "method": "GET" }) }), "allowBlank": false, "pageSize": 20, "emptyText": "Choisir Personne..." });
    var client3012 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/jobs/Contracts/client", "method": "GET" }) }), "allowBlank": false, "pageSize": 20, "emptyText": "Choisir Client..." });
    var language3013 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "store": [ [ "de", "German" ], [ "fr", "French" ], [ "nl", "Dutch" ] ], "allowBlank": false, "value": "de" });
    var date_decided3014 = new Lino.DateField({ "selectOnFocus": true });
    var date_issued3015 = new Lino.DateField({ "selectOnFocus": true });
    var user_asd3016 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/jobs/Contracts/user_asd", "method": "GET" }) }), "pageSize": 20, "emptyText": "Choisir Utilisateur..." });
    var exam_policy3017 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/jobs/Contracts/exam_policy", "method": "GET" }) }), "pageSize": 20, "emptyText": "Choisir M\u00e9thode d'examination..." });
    var ending3018 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/jobs/Contracts/ending", "method": "GET" }) }), "pageSize": 20, "emptyText": "Choisir Cause d'abandon..." });
    var date_ended3019 = new Lino.DateField({ "selectOnFocus": true });
    var duration3020 = new Lino.SimpleRemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/jobs/Contracts/duration", "method": "GET" }) }), "value": null });
    var regime3021 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/jobs/Contracts/regime", "method": "GET" }) }), "pageSize": 20, "emptyText": "Choisir R\u00e9gime de travail..." });
    var schedule3022 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/jobs/Contracts/schedule", "method": "GET" }) }), "pageSize": 20, "emptyText": "Choisir Horaire..." });
    var hourly_rate3023 = new Ext.form.NumberField({ "selectOnFocus": true, "decimalPrecision": 2, "allowBlank": true, "decimalSeparator": "," });
    var refund_rate3024 = new Lino.SimpleRemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/jobs/Contracts/refund_rate", "method": "GET" }) }) });
    var reference_person3025 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var responsibilities3026 = new Lino.RichTextPanel({ "selectOnFocus": true, "containing_panel": this, "title": "responsabilit\u00e9s" });
    var remark3027 = new Ext.form.TextArea({ "selectOnFocus": true, "growMax": 2000 });
    this.before_row_edit = function(record) {
      contact_person3007.setContextValue('company',record ? record.data['companyHidden'] : undefined);
      responsibilities3026.refresh();
    };
    this.onRender = function(ct, position) {
      company3006.on('change',Lino.chooser_handler(contact_person3007,'company'));
      Lino.jobs.Contracts.GridPanel.superclass.onRender.call(this, ct, position);
    }
    this.ls_columns = [ new Lino.NullNumberColumn({ "colIndex": 0, "sortable": true, "format": "0", "editable": true, "filter": { "type": "numeric" }, "header": "ID", "renderer": Lino.id_renderer, "editor": id2999, "width": Lino.chars2width(6), "dataIndex": "id" }), { "colIndex": 1, "sortable": true, "header": "Emploi", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('jobHidden','Lino.jobs.Jobs.detail'), "editor": job3000, "dataIndex": "job" }, { "colIndex": 2, "sortable": true, "xtype": "datecolumn", "format": "d.m.Y", "editable": true, "filter": { "type": "date", "dateFormat": "d.m.Y" }, "header": "D\u00e9but de contrat", "editor": applies_from3001, "width": Lino.chars2width(9), "dataIndex": "applies_from" }, { "colIndex": 3, "sortable": true, "xtype": "datecolumn", "format": "d.m.Y", "editable": true, "filter": { "type": "date", "dateFormat": "d.m.Y" }, "header": "Fin pr\u00e9vue", "editor": applies_until3002, "width": Lino.chars2width(9), "dataIndex": "applies_until" }, { "colIndex": 4, "sortable": true, "header": "Auteur", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(16), "dataIndex": "user", "editor": user3003 }, { "colIndex": 5, "sortable": true, "header": "Type de contrat", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "type", "editor": type3004 }, { "width": Lino.chars2width(17), "colIndex": 6, "sortable": true, "dataIndex": "build_time", "header": "build time", "editable": false }, { "colIndex": 7, "sortable": true, "header": "Organisation", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('companyHidden','Lino.contacts.Companies.detail'), "editor": company3006, "dataIndex": "company" }, { "colIndex": 8, "sortable": true, "header": "repr\u00e9sent\u00e9 par", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('contact_personHidden','Lino.contacts.Persons.detail'), "editor": contact_person3007, "dataIndex": "contact_person" }, { "colIndex": 9, "sortable": true, "header": "repr\u00e9sent\u00e9 par", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "contact_role", "editor": contact_role3008 }, new Lino.NullNumberColumn({ "colIndex": 10, "sortable": true, "format": "0", "editable": true, "filter": { "type": "numeric" }, "header": "Number of occurences", "dataIndex": "max_occurences", "width": Lino.chars2width(6), "editor": max_occurences3009 }), { "colIndex": 11, "sortable": true, "header": "Secr\u00e9taire", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('signer1Hidden','Lino.contacts.Persons.detail'), "hidden": true, "editor": signer13010, "dataIndex": "signer1" }, { "colIndex": 12, "sortable": true, "header": "President", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('signer2Hidden','Lino.contacts.Persons.detail'), "hidden": true, "editor": signer23011, "dataIndex": "signer2" }, { "colIndex": 13, "sortable": true, "header": "Client", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('clientHidden','Lino.pcsw.Clients.detail'), "editor": client3012, "dataIndex": "client" }, { "colIndex": 14, "sortable": true, "header": "Langue", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "language", "editor": language3013 }, { "colIndex": 15, "sortable": true, "xtype": "datecolumn", "format": "d.m.Y", "editable": true, "filter": { "type": "date", "dateFormat": "d.m.Y" }, "header": "D\u00e9cid\u00e9 le", "dataIndex": "date_decided", "hidden": true, "width": Lino.chars2width(9), "editor": date_decided3014 }, { "colIndex": 16, "sortable": true, "xtype": "datecolumn", "format": "d.m.Y", "editable": true, "filter": { "type": "date", "dateFormat": "d.m.Y" }, "header": "D\u00e9livr\u00e9 le", "dataIndex": "date_issued", "hidden": true, "width": Lino.chars2width(9), "editor": date_issued3015 }, { "colIndex": 17, "sortable": true, "header": "Responsable (SSG)", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(16), "dataIndex": "user_asd", "hidden": true, "editor": user_asd3016 }, { "colIndex": 18, "sortable": true, "header": "M\u00e9thode d'examination", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "exam_policy", "hidden": true, "editor": exam_policy3017 }, { "colIndex": 19, "sortable": true, "header": "Cause d'abandon", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "ending", "hidden": true, "editor": ending3018 }, { "colIndex": 20, "sortable": true, "xtype": "datecolumn", "format": "d.m.Y", "editable": true, "filter": { "type": "date", "dateFormat": "d.m.Y" }, "header": "Date de fin", "dataIndex": "date_ended", "hidden": true, "width": Lino.chars2width(9), "editor": date_ended3019 }, { "colIndex": 21, "sortable": true, "header": "dur\u00e9e (jours)", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(11), "dataIndex": "duration", "editor": duration3020 }, { "colIndex": 22, "sortable": true, "header": "R\u00e9gime de travail", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "regime", "editor": regime3021 }, { "colIndex": 23, "sortable": true, "header": "Horaire", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "schedule", "editor": schedule3022 }, new Lino.NullNumberColumn({ "colIndex": 24, "sortable": true, "header": "co\u00fbr horaire", "editable": true, "filter": { "type": "numeric" }, "width": Lino.chars2width(13), "dataIndex": "hourly_rate", "editor": hourly_rate3023 }), { "colIndex": 25, "sortable": true, "header": "tarif de remboursement", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(11), "dataIndex": "refund_rate", "editor": refund_rate3024 }, { "colIndex": 26, "sortable": true, "header": "persone de r\u00e9f\u00e9rence", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "reference_person", "editor": reference_person3025 }, { "colIndex": 27, "sortable": false, "header": "responsibilities", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(61), "renderer": Lino.text_renderer, "editor": responsibilities3026, "dataIndex": "responsibilities" }, { "colIndex": 28, "sortable": false, "header": "Remarque", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(61), "renderer": Lino.text_renderer, "editor": remark3027, "dataIndex": "remark" } ];
    Lino.jobs.Contracts.GridPanel.superclass.initComponent.call(this);
  }
});


Lino.jobs.Contracts.insertPanel = Ext.extend(Lino.jobs.Contracts.InsertFormPanel,{
  empty_title: "Nouveau Art.60\u00a77 contracts",
  hide_navigator: true,
  params_panel_hidden: true,
  ls_bbar_actions: [ { "itemId": "post", "menu_item_text": "Cr\u00e9er", "tooltip": "Create the record and open a detail window on it", "panel_btn_handler": function(panel){panel.save(null,true,'post')}, "text": "Cr\u00e9er", "overflowText": "Cr\u00e9er", "auto_save": false }, { "itemId": "poststay", "menu_item_text": "Create without detail", "tooltip": "Don't open a detail window on the new record", "panel_btn_handler": function(panel){panel.save(null,false,'poststay')}, "text": "Create without detail", "overflowText": "Create without detail", "auto_save": false } ],
  ls_url: "/jobs/Contracts",
  action_name: "insert",
  initComponent : function() {
    this.ls_detail_handler = Lino.jobs.Contracts.detail;
    this.ls_insert_handler = Lino.jobs.Contracts.insert;
    Lino.jobs.Contracts.insertPanel.superclass.initComponent.call(this);
  }
});

Lino.jobs.Contracts.insert = new Lino.WindowAction({ "draggable": true, "width": Lino.chars2width(60), "autoHeight": true, "maximizable": true, "modal": true, "maximized": false },function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.jobs.Contracts.insertPanel(p);
});

Lino.jobs.Contracts.detailPanel = Ext.extend(Lino.jobs.Contracts.DetailFormPanel,{
  empty_title: "D\u00e9tail Art.60\u00a77 contracts",
  params_panel_hidden: true,
  ls_bbar_actions: [ { "itemId": "put", "menu_item_text": "Enregistrer", "tooltip": "Save changes in this form", "panel_btn_handler": function(panel){panel.save(null,false,'put')}, "iconCls": "x-tbar-save", "overflowText": "Enregistrer", "auto_save": false }, { "itemId": "insert", "menu_item_text": "Nouveau", "must_save": true, "tooltip": "Insert a new record", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-new", "overflowText": "Nouveau", "auto_save": true }, { "itemId": "duplicate", "menu_item_text": "Dupliquer", "must_save": true, "tooltip": "Dupliquer", "panel_btn_handler": Lino.row_action_handler('duplicate','GET'), "iconCls": "x-tbar-duplicate", "overflowText": "Dupliquer", "auto_save": true }, { "itemId": null, "menu_item_text": "Supprimer", "tooltip": "Delete this record", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "Supprimer", "auto_save": false }, { "itemId": "do_print", "menu_item_text": "Imprimer", "must_save": true, "tooltip": "Imprimer", "panel_btn_handler": Lino.row_action_handler('do_print','GET'), "iconCls": "x-tbar-print", "overflowText": "Imprimer", "auto_save": true }, { "itemId": "do_clear_cache", "menu_item_text": "Effacer la cache", "must_save": true, "tooltip": "Effacer la cache", "panel_btn_handler": Lino.row_action_handler('do_clear_cache','GET'), "iconCls": "x-tbar-clearcache", "overflowText": "Effacer la cache", "auto_save": true } ],
  ls_url: "/jobs/Contracts",
  action_name: "detail",
  initComponent : function() {
    this.ls_detail_handler = Lino.jobs.Contracts.detail;
    this.ls_insert_handler = Lino.jobs.Contracts.insert;
    Lino.jobs.Contracts.detailPanel.superclass.initComponent.call(this);
  }
});

Lino.jobs.Contracts.detail = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.jobs.Contracts.detailPanel(p);
});
Lino.jobs.Contracts.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  p.params_panel = new Lino.jobs.Contracts.ParamsPanel({});
  return new Lino.jobs.Contracts.GridPanel(p);
});

// js_render_GridPanel_class jobs.MyContracts
Lino.jobs.MyContracts.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "No data to display." },
  ls_url : "/jobs/MyContracts",
  ls_bbar_actions : [ { "itemId": "insert", "menu_item_text": "Nouveau", "must_save": true, "tooltip": "Insert a new record", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-new", "overflowText": "Nouveau", "auto_save": true }, { "itemId": "duplicate", "menu_item_text": "Dupliquer", "must_save": true, "tooltip": "Dupliquer", "panel_btn_handler": Lino.row_action_handler('duplicate','GET'), "iconCls": "x-tbar-duplicate", "overflowText": "Dupliquer", "auto_save": true }, { "itemId": "detail", "menu_item_text": "D\u00e9tail", "tooltip": "Open a detail window on this record", "panel_btn_handler": Lino.show_detail, "iconCls": "x-tbar-detail", "overflowText": "D\u00e9tail", "auto_save": true }, { "itemId": null, "menu_item_text": "Supprimer", "tooltip": "Delete this record", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "Supprimer", "auto_save": false }, { "itemId": "do_print", "menu_item_text": "Imprimer", "must_save": true, "tooltip": "Imprimer", "panel_btn_handler": Lino.row_action_handler('do_print','GET'), "iconCls": "x-tbar-print", "overflowText": "Imprimer", "auto_save": true }, { "itemId": "do_clear_cache", "menu_item_text": "Effacer la cache", "must_save": true, "tooltip": "Effacer la cache", "panel_btn_handler": Lino.row_action_handler('do_clear_cache','GET'), "iconCls": "x-tbar-clearcache", "overflowText": "Effacer la cache", "auto_save": true } ],
  title : "Art.60\u00a77 contracts",
  page_length : 20,
  params_panel_hidden : true,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "type": "date", "name": "applies_from", "dateFormat": "d.m.Y" }, { "name": "client" }, 'clientHidden', { "name": "job" }, 'jobHidden', { "type": "int", "name": "id" }, { "name": "user" }, 'userHidden', { "name": "build_time" }, { "name": "company" }, 'companyHidden', { "name": "contact_person" }, 'contact_personHidden', { "name": "contact_role" }, 'contact_roleHidden', { "type": "int", "name": "max_occurences" }, { "name": "signer1" }, 'signer1Hidden', { "name": "signer2" }, 'signer2Hidden', { "name": "language" }, 'languageHidden', { "type": "date", "name": "applies_until", "dateFormat": "d.m.Y" }, { "type": "date", "name": "date_decided", "dateFormat": "d.m.Y" }, { "type": "date", "name": "date_issued", "dateFormat": "d.m.Y" }, { "name": "user_asd" }, 'user_asdHidden', { "name": "exam_policy" }, 'exam_policyHidden', { "name": "ending" }, 'endingHidden', { "type": "date", "name": "date_ended", "dateFormat": "d.m.Y" }, { "name": "type" }, 'typeHidden', { "type": "int", "name": "duration" }, { "name": "regime" }, 'regimeHidden', { "name": "schedule" }, 'scheduleHidden', { "name": "hourly_rate" }, { "name": "refund_rate" }, { "name": "reference_person" }, { "name": "responsibilities" }, { "name": "remark" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 5,
  ls_grid_configs : [  ],
  content_type : 71,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 45,
  initComponent : function() {
    this.ls_detail_handler = Lino.jobs.MyContracts.detail;
    this.ls_insert_handler = Lino.jobs.MyContracts.insert;
    var ww = this.containing_window;
    var applies_from3029 = new Lino.DateField({ "selectOnFocus": true });
    var client3030 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/jobs/MyContracts/client", "method": "GET" }) }), "allowBlank": false, "pageSize": 20, "emptyText": "Choisir Client..." });
    var job3031 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/jobs/MyContracts/job", "method": "GET" }) }), "allowBlank": false, "pageSize": 20, "emptyText": "Choisir Emploi..." });
    var id3032 = new Ext.form.NumberField({ "selectOnFocus": true });
    var user3033 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/jobs/MyContracts/user", "method": "GET" }) }), "pageSize": 20, "emptyText": "Choisir Utilisateur..." });
    var build_time3034 = new Ext.form.DisplayField({ "disabled": true, "value": "<br>" });
    var company3035 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/jobs/MyContracts/company", "method": "GET" }) }), "pageSize": 20, "emptyText": "Choisir Organisation..." });
    var contact_person3036 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/jobs/MyContracts/contact_person", "method": "GET" }) }), "pageSize": 20, "emptyText": "Choisir Personne..." });
    var contact_role3037 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/jobs/MyContracts/contact_role", "method": "GET" }) }), "pageSize": 20, "emptyText": "Choisir Fonction..." });
    var max_occurences3038 = new Ext.form.NumberField({ "selectOnFocus": true });
    var signer13039 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/jobs/MyContracts/signer1", "method": "GET" }) }), "allowBlank": false, "pageSize": 20, "emptyText": "Choisir Personne..." });
    var signer23040 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/jobs/MyContracts/signer2", "method": "GET" }) }), "allowBlank": false, "pageSize": 20, "emptyText": "Choisir Personne..." });
    var language3041 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "store": [ [ "de", "German" ], [ "fr", "French" ], [ "nl", "Dutch" ] ], "allowBlank": false, "value": "de" });
    var applies_until3042 = new Lino.DateField({ "selectOnFocus": true });
    var date_decided3043 = new Lino.DateField({ "selectOnFocus": true });
    var date_issued3044 = new Lino.DateField({ "selectOnFocus": true });
    var user_asd3045 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/jobs/MyContracts/user_asd", "method": "GET" }) }), "pageSize": 20, "emptyText": "Choisir Utilisateur..." });
    var exam_policy3046 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/jobs/MyContracts/exam_policy", "method": "GET" }) }), "pageSize": 20, "emptyText": "Choisir M\u00e9thode d'examination..." });
    var ending3047 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/jobs/MyContracts/ending", "method": "GET" }) }), "pageSize": 20, "emptyText": "Choisir Cause d'abandon..." });
    var date_ended3048 = new Lino.DateField({ "selectOnFocus": true });
    var type3049 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/jobs/MyContracts/type", "method": "GET" }) }), "pageSize": 20, "emptyText": "Choisir Type de contrat de travail..." });
    var duration3050 = new Lino.SimpleRemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/jobs/MyContracts/duration", "method": "GET" }) }), "value": null });
    var regime3051 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/jobs/MyContracts/regime", "method": "GET" }) }), "pageSize": 20, "emptyText": "Choisir R\u00e9gime de travail..." });
    var schedule3052 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/jobs/MyContracts/schedule", "method": "GET" }) }), "pageSize": 20, "emptyText": "Choisir Horaire..." });
    var hourly_rate3053 = new Ext.form.NumberField({ "selectOnFocus": true, "decimalPrecision": 2, "allowBlank": true, "decimalSeparator": "," });
    var refund_rate3054 = new Lino.SimpleRemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/jobs/MyContracts/refund_rate", "method": "GET" }) }) });
    var reference_person3055 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var responsibilities3056 = new Lino.RichTextPanel({ "selectOnFocus": true, "containing_panel": this, "title": "responsabilit\u00e9s" });
    var remark3057 = new Ext.form.TextArea({ "selectOnFocus": true, "growMax": 2000 });
    this.before_row_edit = function(record) {
      contact_person3036.setContextValue('company',record ? record.data['companyHidden'] : undefined);
      responsibilities3056.refresh();
    };
    this.onRender = function(ct, position) {
      company3035.on('change',Lino.chooser_handler(contact_person3036,'company'));
      Lino.jobs.MyContracts.GridPanel.superclass.onRender.call(this, ct, position);
    }
    this.ls_columns = [ { "colIndex": 0, "sortable": true, "xtype": "datecolumn", "format": "d.m.Y", "editable": true, "filter": { "type": "date", "dateFormat": "d.m.Y" }, "header": "D\u00e9but de contrat", "editor": applies_from3029, "width": Lino.chars2width(9), "dataIndex": "applies_from" }, { "colIndex": 1, "sortable": true, "header": "Client", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('clientHidden','Lino.pcsw.Clients.detail'), "editor": client3030, "dataIndex": "client" }, { "colIndex": 2, "sortable": true, "header": "Emploi", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('jobHidden','Lino.jobs.Jobs.detail'), "editor": job3031, "dataIndex": "job" }, new Lino.NullNumberColumn({ "colIndex": 3, "sortable": true, "format": "0", "editable": true, "filter": { "type": "numeric" }, "header": "ID", "renderer": Lino.id_renderer, "editor": id3032, "width": Lino.chars2width(6), "dataIndex": "id" }), { "colIndex": 4, "sortable": true, "header": "Auteur", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(16), "dataIndex": "user", "editor": user3033 }, { "width": Lino.chars2width(17), "colIndex": 5, "sortable": true, "dataIndex": "build_time", "header": "build time", "editable": false }, { "colIndex": 6, "sortable": true, "header": "Organisation", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('companyHidden','Lino.contacts.Companies.detail'), "editor": company3035, "dataIndex": "company" }, { "colIndex": 7, "sortable": true, "header": "repr\u00e9sent\u00e9 par", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('contact_personHidden','Lino.contacts.Persons.detail'), "editor": contact_person3036, "dataIndex": "contact_person" }, { "colIndex": 8, "sortable": true, "header": "repr\u00e9sent\u00e9 par", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "contact_role", "editor": contact_role3037 }, new Lino.NullNumberColumn({ "colIndex": 9, "sortable": true, "format": "0", "editable": true, "filter": { "type": "numeric" }, "header": "Number of occurences", "dataIndex": "max_occurences", "width": Lino.chars2width(6), "editor": max_occurences3038 }), { "colIndex": 10, "sortable": true, "header": "Secr\u00e9taire", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('signer1Hidden','Lino.contacts.Persons.detail'), "hidden": true, "editor": signer13039, "dataIndex": "signer1" }, { "colIndex": 11, "sortable": true, "header": "President", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('signer2Hidden','Lino.contacts.Persons.detail'), "hidden": true, "editor": signer23040, "dataIndex": "signer2" }, { "colIndex": 12, "sortable": true, "header": "Langue", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "language", "editor": language3041 }, { "colIndex": 13, "sortable": true, "xtype": "datecolumn", "format": "d.m.Y", "editable": true, "filter": { "type": "date", "dateFormat": "d.m.Y" }, "header": "Fin pr\u00e9vue", "editor": applies_until3042, "width": Lino.chars2width(9), "dataIndex": "applies_until" }, { "colIndex": 14, "sortable": true, "xtype": "datecolumn", "format": "d.m.Y", "editable": true, "filter": { "type": "date", "dateFormat": "d.m.Y" }, "header": "D\u00e9cid\u00e9 le", "dataIndex": "date_decided", "hidden": true, "width": Lino.chars2width(9), "editor": date_decided3043 }, { "colIndex": 15, "sortable": true, "xtype": "datecolumn", "format": "d.m.Y", "editable": true, "filter": { "type": "date", "dateFormat": "d.m.Y" }, "header": "D\u00e9livr\u00e9 le", "dataIndex": "date_issued", "hidden": true, "width": Lino.chars2width(9), "editor": date_issued3044 }, { "colIndex": 16, "sortable": true, "header": "Responsable (SSG)", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(16), "dataIndex": "user_asd", "hidden": true, "editor": user_asd3045 }, { "colIndex": 17, "sortable": true, "header": "M\u00e9thode d'examination", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "exam_policy", "hidden": true, "editor": exam_policy3046 }, { "colIndex": 18, "sortable": true, "header": "Cause d'abandon", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "ending", "hidden": true, "editor": ending3047 }, { "colIndex": 19, "sortable": true, "xtype": "datecolumn", "format": "d.m.Y", "editable": true, "filter": { "type": "date", "dateFormat": "d.m.Y" }, "header": "Date de fin", "dataIndex": "date_ended", "hidden": true, "width": Lino.chars2width(9), "editor": date_ended3048 }, { "colIndex": 20, "sortable": true, "header": "Type de contrat", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "type", "editor": type3049 }, { "colIndex": 21, "sortable": true, "header": "dur\u00e9e (jours)", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(11), "dataIndex": "duration", "editor": duration3050 }, { "colIndex": 22, "sortable": true, "header": "R\u00e9gime de travail", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "regime", "editor": regime3051 }, { "colIndex": 23, "sortable": true, "header": "Horaire", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "schedule", "editor": schedule3052 }, new Lino.NullNumberColumn({ "colIndex": 24, "sortable": true, "header": "co\u00fbr horaire", "editable": true, "filter": { "type": "numeric" }, "width": Lino.chars2width(13), "dataIndex": "hourly_rate", "editor": hourly_rate3053 }), { "colIndex": 25, "sortable": true, "header": "tarif de remboursement", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(11), "dataIndex": "refund_rate", "editor": refund_rate3054 }, { "colIndex": 26, "sortable": true, "header": "persone de r\u00e9f\u00e9rence", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "reference_person", "editor": reference_person3055 }, { "colIndex": 27, "sortable": false, "header": "responsibilities", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(61), "renderer": Lino.text_renderer, "editor": responsibilities3056, "dataIndex": "responsibilities" }, { "colIndex": 28, "sortable": false, "header": "Remarque", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(61), "renderer": Lino.text_renderer, "editor": remark3057, "dataIndex": "remark" } ];
    Lino.jobs.MyContracts.GridPanel.superclass.initComponent.call(this);
  }
});


Lino.jobs.MyContracts.insertPanel = Ext.extend(Lino.jobs.Contracts.InsertFormPanel,{
  empty_title: "Nouveau Art.60\u00a77 contracts",
  hide_navigator: true,
  params_panel_hidden: true,
  ls_bbar_actions: [ { "itemId": "post", "menu_item_text": "Cr\u00e9er", "tooltip": "Create the record and open a detail window on it", "panel_btn_handler": function(panel){panel.save(null,true,'post')}, "text": "Cr\u00e9er", "overflowText": "Cr\u00e9er", "auto_save": false }, { "itemId": "poststay", "menu_item_text": "Create without detail", "tooltip": "Don't open a detail window on the new record", "panel_btn_handler": function(panel){panel.save(null,false,'poststay')}, "text": "Create without detail", "overflowText": "Create without detail", "auto_save": false } ],
  ls_url: "/jobs/MyContracts",
  action_name: "insert",
  initComponent : function() {
    this.ls_detail_handler = Lino.jobs.MyContracts.detail;
    this.ls_insert_handler = Lino.jobs.MyContracts.insert;
    Lino.jobs.MyContracts.insertPanel.superclass.initComponent.call(this);
  }
});

Lino.jobs.MyContracts.insert = new Lino.WindowAction({ "draggable": true, "width": Lino.chars2width(60), "autoHeight": true, "maximizable": true, "modal": true, "maximized": false },function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.jobs.MyContracts.insertPanel(p);
});

Lino.jobs.MyContracts.detailPanel = Ext.extend(Lino.jobs.Contracts.DetailFormPanel,{
  empty_title: "D\u00e9tail Art.60\u00a77 contracts",
  params_panel_hidden: true,
  ls_bbar_actions: [ { "itemId": "put", "menu_item_text": "Enregistrer", "tooltip": "Save changes in this form", "panel_btn_handler": function(panel){panel.save(null,false,'put')}, "iconCls": "x-tbar-save", "overflowText": "Enregistrer", "auto_save": false }, { "itemId": "insert", "menu_item_text": "Nouveau", "must_save": true, "tooltip": "Insert a new record", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-new", "overflowText": "Nouveau", "auto_save": true }, { "itemId": "duplicate", "menu_item_text": "Dupliquer", "must_save": true, "tooltip": "Dupliquer", "panel_btn_handler": Lino.row_action_handler('duplicate','GET'), "iconCls": "x-tbar-duplicate", "overflowText": "Dupliquer", "auto_save": true }, { "itemId": null, "menu_item_text": "Supprimer", "tooltip": "Delete this record", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "Supprimer", "auto_save": false }, { "itemId": "do_print", "menu_item_text": "Imprimer", "must_save": true, "tooltip": "Imprimer", "panel_btn_handler": Lino.row_action_handler('do_print','GET'), "iconCls": "x-tbar-print", "overflowText": "Imprimer", "auto_save": true }, { "itemId": "do_clear_cache", "menu_item_text": "Effacer la cache", "must_save": true, "tooltip": "Effacer la cache", "panel_btn_handler": Lino.row_action_handler('do_clear_cache','GET'), "iconCls": "x-tbar-clearcache", "overflowText": "Effacer la cache", "auto_save": true } ],
  ls_url: "/jobs/MyContracts",
  action_name: "detail",
  initComponent : function() {
    this.ls_detail_handler = Lino.jobs.MyContracts.detail;
    this.ls_insert_handler = Lino.jobs.MyContracts.insert;
    Lino.jobs.MyContracts.detailPanel.superclass.initComponent.call(this);
  }
});

Lino.jobs.MyContracts.detail = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.jobs.MyContracts.detailPanel(p);
});
Lino.jobs.MyContracts.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  p.params_panel = new Lino.jobs.Contracts.ParamsPanel({});
  return new Lino.jobs.MyContracts.GridPanel(p);
});

// js_render_GridPanel_class jobs.Offers
Lino.jobs.Offers.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "No data to display." },
  ls_url : "/jobs/Offers",
  ls_bbar_actions : [ { "itemId": "insert", "menu_item_text": "Nouveau", "must_save": true, "tooltip": "Insert a new record", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-new", "overflowText": "Nouveau", "auto_save": true }, { "itemId": "detail", "menu_item_text": "D\u00e9tail", "tooltip": "Open a detail window on this record", "panel_btn_handler": Lino.show_detail, "iconCls": "x-tbar-detail", "overflowText": "D\u00e9tail", "auto_save": true }, { "itemId": null, "menu_item_text": "Supprimer", "tooltip": "Delete this record", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "Supprimer", "auto_save": false } ],
  title : "Offres d'emploi",
  page_length : 20,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "type": "int", "name": "id" }, { "name": "sector" }, 'sectorHidden', { "name": "function" }, 'functionHidden', { "name": "name" }, { "name": "provider" }, 'providerHidden', { "type": "date", "name": "selection_from", "dateFormat": "d.m.Y" }, { "type": "date", "name": "selection_until", "dateFormat": "d.m.Y" }, { "type": "date", "name": "start_date", "dateFormat": "d.m.Y" }, { "name": "remark" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 0,
  ls_grid_configs : [  ],
  content_type : 70,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 13,
  initComponent : function() {
    this.ls_detail_handler = Lino.jobs.Offers.detail;
    this.ls_insert_handler = Lino.jobs.Offers.insert;
    var ww = this.containing_window;
    var id3059 = new Ext.form.NumberField({ "selectOnFocus": true });
    var sector3060 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/jobs/Offers/sector", "method": "GET" }) }), "pageSize": 20, "emptyText": "Choisir Secteur d'activit\u00e9..." });
    var function3061 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/jobs/Offers/function", "method": "GET" }) }), "pageSize": 20, "emptyText": "Choisir Fonction..." });
    var name3062 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 100 });
    var provider3063 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/jobs/Offers/provider", "method": "GET" }) }), "pageSize": 20, "emptyText": "Choisir Employant..." });
    var selection_from3064 = new Lino.DateField({ "selectOnFocus": true });
    var selection_until3065 = new Lino.DateField({ "selectOnFocus": true });
    var start_date3066 = new Lino.DateField({ "selectOnFocus": true });
    var remark3067 = new Ext.form.TextArea({ "selectOnFocus": true, "growMax": 2000 });
    this.before_row_edit = function(record) {
      function3061.setContextValue('sector',record ? record.data['sectorHidden'] : undefined);
    };
    this.onRender = function(ct, position) {
      sector3060.on('change',Lino.chooser_handler(function3061,'sector'));
      Lino.jobs.Offers.GridPanel.superclass.onRender.call(this, ct, position);
    }
    this.ls_columns = [ new Lino.NullNumberColumn({ "colIndex": 0, "sortable": true, "format": "0", "editable": true, "filter": { "type": "numeric" }, "header": "ID", "renderer": Lino.id_renderer, "editor": id3059, "width": Lino.chars2width(6), "dataIndex": "id" }), { "colIndex": 1, "sortable": true, "header": "Secteur d'activit\u00e9", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "sector", "editor": sector3060 }, { "colIndex": 2, "sortable": true, "header": "Fonction", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "function", "editor": function3061 }, { "colIndex": 3, "sortable": true, "header": "Name", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "name", "editor": name3062 }, { "colIndex": 4, "sortable": true, "header": "Employant", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('providerHidden','Lino.jobs.JobProviders.detail'), "editor": provider3063, "dataIndex": "provider" }, { "colIndex": 5, "sortable": true, "xtype": "datecolumn", "format": "d.m.Y", "editable": true, "filter": { "type": "date", "dateFormat": "d.m.Y" }, "header": "D\u00e9but de s\u00e9lection", "editor": selection_from3064, "width": Lino.chars2width(9), "dataIndex": "selection_from" }, { "colIndex": 6, "sortable": true, "xtype": "datecolumn", "format": "d.m.Y", "editable": true, "filter": { "type": "date", "dateFormat": "d.m.Y" }, "header": "Fin de s\u00e9lection", "editor": selection_until3065, "width": Lino.chars2width(9), "dataIndex": "selection_until" }, { "colIndex": 7, "sortable": true, "xtype": "datecolumn", "format": "d.m.Y", "editable": true, "filter": { "type": "date", "dateFormat": "d.m.Y" }, "header": "Date de d\u00e9but", "editor": start_date3066, "width": Lino.chars2width(9), "dataIndex": "start_date" }, { "colIndex": 8, "sortable": false, "header": "Remarque", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(61), "renderer": Lino.text_renderer, "editor": remark3067, "dataIndex": "remark" } ];
    Lino.jobs.Offers.GridPanel.superclass.initComponent.call(this);
  }
});


Lino.jobs.Offers.insertPanel = Ext.extend(Lino.jobs.Offers.DetailFormPanel,{
  empty_title: "Nouveau Offres d'emploi",
  hide_navigator: true,
  ls_bbar_actions: [ { "itemId": "post", "menu_item_text": "Cr\u00e9er", "tooltip": "Create the record and open a detail window on it", "panel_btn_handler": function(panel){panel.save(null,true,'post')}, "text": "Cr\u00e9er", "overflowText": "Cr\u00e9er", "auto_save": false }, { "itemId": "poststay", "menu_item_text": "Create without detail", "tooltip": "Don't open a detail window on the new record", "panel_btn_handler": function(panel){panel.save(null,false,'poststay')}, "text": "Create without detail", "overflowText": "Create without detail", "auto_save": false } ],
  ls_url: "/jobs/Offers",
  action_name: "insert",
  initComponent : function() {
    this.ls_detail_handler = Lino.jobs.Offers.detail;
    this.ls_insert_handler = Lino.jobs.Offers.insert;
    Lino.jobs.Offers.insertPanel.superclass.initComponent.call(this);
  }
});

Lino.jobs.Offers.insert = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.jobs.Offers.insertPanel(p);
});

Lino.jobs.Offers.detailPanel = Ext.extend(Lino.jobs.Offers.DetailFormPanel,{
  empty_title: "D\u00e9tail Offres d'emploi",
  ls_bbar_actions: [ { "itemId": "put", "menu_item_text": "Enregistrer", "tooltip": "Save changes in this form", "panel_btn_handler": function(panel){panel.save(null,false,'put')}, "iconCls": "x-tbar-save", "overflowText": "Enregistrer", "auto_save": false }, { "itemId": "insert", "menu_item_text": "Nouveau", "must_save": true, "tooltip": "Insert a new record", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-new", "overflowText": "Nouveau", "auto_save": true }, { "itemId": null, "menu_item_text": "Supprimer", "tooltip": "Delete this record", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "Supprimer", "auto_save": false } ],
  ls_url: "/jobs/Offers",
  action_name: "detail",
  initComponent : function() {
    this.ls_detail_handler = Lino.jobs.Offers.detail;
    this.ls_insert_handler = Lino.jobs.Offers.insert;
    Lino.jobs.Offers.detailPanel.superclass.initComponent.call(this);
  }
});

Lino.jobs.Offers.detail = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.jobs.Offers.detailPanel(p);
});
Lino.jobs.Offers.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.jobs.Offers.GridPanel(p);
});

// js_render_GridPanel_class jobs.Jobs
Lino.jobs.Jobs.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "No data to display." },
  ls_url : "/jobs/Jobs",
  ls_bbar_actions : [ { "itemId": "insert", "menu_item_text": "Nouveau", "must_save": true, "tooltip": "Insert a new record", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-new", "overflowText": "Nouveau", "auto_save": true }, { "itemId": "detail", "menu_item_text": "D\u00e9tail", "tooltip": "Open a detail window on this record", "panel_btn_handler": Lino.show_detail, "iconCls": "x-tbar-detail", "overflowText": "D\u00e9tail", "auto_save": true }, { "itemId": null, "menu_item_text": "Supprimer", "tooltip": "Delete this record", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "Supprimer", "auto_save": false } ],
  title : "Emplois",
  page_length : 20,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "name": "name" }, { "name": "provider" }, 'providerHidden', { "name": "sector" }, 'sectorHidden', { "name": "function" }, 'functionHidden', { "name": "type" }, 'typeHidden', { "name": "contract_type" }, 'contract_typeHidden', { "name": "hourly_rate" }, { "type": "int", "name": "capacity" }, { "name": "remark" }, { "type": "int", "name": "id" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 14,
  ls_grid_configs : [  ],
  content_type : 72,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 16,
  initComponent : function() {
    this.ls_detail_handler = Lino.jobs.Jobs.detail;
    this.ls_insert_handler = Lino.jobs.Jobs.insert;
    var ww = this.containing_window;
    var name3069 = new Ext.form.TextField({ "selectOnFocus": true, "allowBlank": false, "maxLength": 100 });
    var provider3070 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/jobs/Jobs/provider", "method": "GET" }) }), "pageSize": 20, "emptyText": "Choisir Employant..." });
    var sector3071 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/jobs/Jobs/sector", "method": "GET" }) }), "pageSize": 20, "emptyText": "Choisir Secteur d'activit\u00e9..." });
    var function3072 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/jobs/Jobs/function", "method": "GET" }) }), "pageSize": 20, "emptyText": "Choisir Fonction..." });
    var type3073 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/jobs/Jobs/type", "method": "GET" }) }), "pageSize": 20, "emptyText": "Choisir Type d'emploi..." });
    var contract_type3074 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/jobs/Jobs/contract_type", "method": "GET" }) }), "pageSize": 20, "emptyText": "Choisir Type de contrat de travail..." });
    var hourly_rate3075 = new Ext.form.NumberField({ "selectOnFocus": true, "decimalPrecision": 2, "allowBlank": true, "decimalSeparator": "," });
    var capacity3076 = new Ext.form.NumberField({ "selectOnFocus": true, "allowBlank": false, "value": 1 });
    var remark3077 = new Ext.form.TextArea({ "selectOnFocus": true, "growMax": 2000 });
    var id3078 = new Ext.form.NumberField({ "selectOnFocus": true });
    this.before_row_edit = function(record) {
      function3072.setContextValue('sector',record ? record.data['sectorHidden'] : undefined);
    };
    this.onRender = function(ct, position) {
      sector3071.on('change',Lino.chooser_handler(function3072,'sector'));
      Lino.jobs.Jobs.GridPanel.superclass.onRender.call(this, ct, position);
    }
    this.ls_columns = [ { "colIndex": 0, "sortable": true, "header": "Name", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "name", "editor": name3069 }, { "colIndex": 1, "sortable": true, "header": "Employant", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('providerHidden','Lino.jobs.JobProviders.detail'), "editor": provider3070, "dataIndex": "provider" }, { "colIndex": 2, "sortable": true, "header": "Secteur d'activit\u00e9", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "sector", "editor": sector3071 }, { "colIndex": 3, "sortable": true, "header": "Fonction", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "function", "editor": function3072 }, { "colIndex": 4, "sortable": true, "header": "Type d'emploi", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "type", "editor": type3073 }, { "colIndex": 5, "sortable": true, "header": "Type de contrat", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "contract_type", "editor": contract_type3074 }, new Lino.NullNumberColumn({ "colIndex": 6, "sortable": true, "header": "co\u00fbr horaire", "editable": true, "filter": { "type": "numeric" }, "width": Lino.chars2width(13), "dataIndex": "hourly_rate", "editor": hourly_rate3075 }), new Lino.NullNumberColumn({ "colIndex": 7, "sortable": true, "format": "0", "editable": true, "filter": { "type": "numeric" }, "header": "Capacit\u00e9", "dataIndex": "capacity", "width": Lino.chars2width(6), "editor": capacity3076 }), { "colIndex": 8, "sortable": false, "header": "Remarque", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(61), "renderer": Lino.text_renderer, "editor": remark3077, "dataIndex": "remark" }, new Lino.NullNumberColumn({ "colIndex": 9, "sortable": true, "format": "0", "editable": true, "filter": { "type": "numeric" }, "header": "ID", "renderer": Lino.id_renderer, "editor": id3078, "width": Lino.chars2width(6), "dataIndex": "id" }) ];
    Lino.jobs.Jobs.GridPanel.superclass.initComponent.call(this);
  }
});


Lino.jobs.Jobs.insertPanel = Ext.extend(Lino.jobs.Jobs.DetailFormPanel,{
  empty_title: "Nouveau Emplois",
  hide_navigator: true,
  ls_bbar_actions: [ { "itemId": "post", "menu_item_text": "Cr\u00e9er", "tooltip": "Create the record and open a detail window on it", "panel_btn_handler": function(panel){panel.save(null,true,'post')}, "text": "Cr\u00e9er", "overflowText": "Cr\u00e9er", "auto_save": false }, { "itemId": "poststay", "menu_item_text": "Create without detail", "tooltip": "Don't open a detail window on the new record", "panel_btn_handler": function(panel){panel.save(null,false,'poststay')}, "text": "Create without detail", "overflowText": "Create without detail", "auto_save": false } ],
  ls_url: "/jobs/Jobs",
  action_name: "insert",
  initComponent : function() {
    this.ls_detail_handler = Lino.jobs.Jobs.detail;
    this.ls_insert_handler = Lino.jobs.Jobs.insert;
    Lino.jobs.Jobs.insertPanel.superclass.initComponent.call(this);
  }
});

Lino.jobs.Jobs.insert = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.jobs.Jobs.insertPanel(p);
});

Lino.jobs.Jobs.detailPanel = Ext.extend(Lino.jobs.Jobs.DetailFormPanel,{
  empty_title: "D\u00e9tail Emplois",
  ls_bbar_actions: [ { "itemId": "put", "menu_item_text": "Enregistrer", "tooltip": "Save changes in this form", "panel_btn_handler": function(panel){panel.save(null,false,'put')}, "iconCls": "x-tbar-save", "overflowText": "Enregistrer", "auto_save": false }, { "itemId": "insert", "menu_item_text": "Nouveau", "must_save": true, "tooltip": "Insert a new record", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-new", "overflowText": "Nouveau", "auto_save": true }, { "itemId": null, "menu_item_text": "Supprimer", "tooltip": "Delete this record", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "Supprimer", "auto_save": false } ],
  ls_url: "/jobs/Jobs",
  action_name: "detail",
  initComponent : function() {
    this.ls_detail_handler = Lino.jobs.Jobs.detail;
    this.ls_insert_handler = Lino.jobs.Jobs.insert;
    Lino.jobs.Jobs.detailPanel.superclass.initComponent.call(this);
  }
});

Lino.jobs.Jobs.detail = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.jobs.Jobs.detailPanel(p);
});
Lino.jobs.Jobs.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.jobs.Jobs.GridPanel(p);
});

// js_render_GridPanel_class jobs.ContractsSearch
Lino.jobs.ContractsSearch.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "No data to display." },
  ls_url : "/jobs/ContractsSearch",
  ls_bbar_actions : [ { "itemId": "insert", "menu_item_text": "Nouveau", "must_save": true, "tooltip": "Insert a new record", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-new", "overflowText": "Nouveau", "auto_save": true }, { "itemId": "duplicate", "menu_item_text": "Dupliquer", "must_save": true, "tooltip": "Dupliquer", "panel_btn_handler": Lino.row_action_handler('duplicate','GET'), "iconCls": "x-tbar-duplicate", "overflowText": "Dupliquer", "auto_save": true }, { "itemId": "detail", "menu_item_text": "D\u00e9tail", "tooltip": "Open a detail window on this record", "panel_btn_handler": Lino.show_detail, "iconCls": "x-tbar-detail", "overflowText": "D\u00e9tail", "auto_save": true }, { "itemId": null, "menu_item_text": "Supprimer", "tooltip": "Delete this record", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "Supprimer", "auto_save": false }, { "itemId": "do_print", "menu_item_text": "Imprimer", "must_save": true, "tooltip": "Imprimer", "panel_btn_handler": Lino.row_action_handler('do_print','GET'), "iconCls": "x-tbar-print", "overflowText": "Imprimer", "auto_save": true }, { "itemId": "do_clear_cache", "menu_item_text": "Effacer la cache", "must_save": true, "tooltip": "Effacer la cache", "panel_btn_handler": Lino.row_action_handler('do_clear_cache','GET'), "iconCls": "x-tbar-clearcache", "overflowText": "Effacer la cache", "auto_save": true } ],
  title : "Recherche contrats de travail",
  page_length : 20,
  params_panel_hidden : true,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "type": "int", "name": "id" }, { "type": "date", "name": "applies_from", "dateFormat": "d.m.Y" }, { "type": "date", "name": "applies_until", "dateFormat": "d.m.Y" }, { "name": "job" }, 'jobHidden', { "name": "client" }, 'clientHidden', { "name": "client__city" }, 'client__cityHidden', { "name": "client__national_id" }, { "name": "client__gender" }, 'client__genderHidden', { "name": "user" }, 'userHidden', { "name": "type" }, 'typeHidden', { "name": "build_time" }, { "name": "company" }, 'companyHidden', { "name": "contact_person" }, 'contact_personHidden', { "name": "contact_role" }, 'contact_roleHidden', { "type": "int", "name": "max_occurences" }, { "name": "signer1" }, 'signer1Hidden', { "name": "signer2" }, 'signer2Hidden', { "name": "language" }, 'languageHidden', { "type": "date", "name": "date_decided", "dateFormat": "d.m.Y" }, { "type": "date", "name": "date_issued", "dateFormat": "d.m.Y" }, { "name": "user_asd" }, 'user_asdHidden', { "name": "exam_policy" }, 'exam_policyHidden', { "name": "ending" }, 'endingHidden', { "type": "date", "name": "date_ended", "dateFormat": "d.m.Y" }, { "type": "int", "name": "duration" }, { "name": "regime" }, 'regimeHidden', { "name": "schedule" }, 'scheduleHidden', { "name": "hourly_rate" }, { "name": "refund_rate" }, { "name": "reference_person" }, { "name": "responsibilities" }, { "name": "remark" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 0,
  ls_grid_configs : [  ],
  content_type : 71,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 50,
  initComponent : function() {
    this.ls_detail_handler = Lino.jobs.ContractsSearch.detail;
    this.ls_insert_handler = Lino.jobs.ContractsSearch.insert;
    var ww = this.containing_window;
    var id3080 = new Ext.form.NumberField({ "selectOnFocus": true });
    var applies_from3081 = new Lino.DateField({ "selectOnFocus": true });
    var applies_until3082 = new Lino.DateField({ "selectOnFocus": true });
    var job3083 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/jobs/ContractsSearch/job", "method": "GET" }) }), "allowBlank": false, "pageSize": 20, "emptyText": "Choisir Emploi..." });
    var client3084 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/jobs/ContractsSearch/client", "method": "GET" }) }), "allowBlank": false, "pageSize": 20, "emptyText": "Choisir Clien