/*
 Copyright 2009-2013 Luc Saffre
 This file is part of the Lino project.
 Lino is free software; you can redistribute it and/or modify 
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 3 of the License, or
 (at your option) any later version.
 Lino is distributed in the hope that it will be useful, 
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the 
 GNU General Public License for more details.
 You should have received a copy of the GNU General Public License
 along with Lino; if not, see <http://www.gnu.org/licenses/>.
*/

// lino.js --- generated Sat Jul 20 22:44:15 2013 by Lino version 1.6.11.
Ext.BLANK_IMAGE_URL = '/media/extjs/resources/images/default/s.gif';
LANGUAGE_CHOICES = [ [ "de", "Deutsch" ], [ "fr", "Franz\u00f6sisch" ], [ "nl", "Niederl\u00e4ndisch" ] ];
MEDIA_URL = "/media";

/* MonthPickerPlugin: thanks to keypoint @ sencha forum
   http://www.sencha.com/forum/showthread.php?74002-3.x-Ext.ux.MonthMenu&p=356860#post356860
*/
Ext.namespace('Ext.ux'); 

Ext.ux.MonthPickerPlugin = function() { 
    var picker; 
    var oldDateDefaults; 

    this.init = function(pk) { 
        picker = pk; 
        picker.onTriggerClick = picker.onTriggerClick.createSequence(onClick); 
        picker.getValue = picker.getValue.createInterceptor(setDefaultMonthDay).createSequence(restoreDefaultMonthDay); 
        picker.beforeBlur = picker.beforeBlur.createInterceptor(setDefaultMonthDay).createSequence(restoreDefaultMonthDay); 
    }; 

    function setDefaultMonthDay() { 
        oldDateDefaults = Date.defaults.d; 
        Date.defaults.d = 1; 
        return true; 
    } 

    function restoreDefaultMonthDay(ret) { 
        Date.defaults.d = oldDateDefaults; 
        return ret; 
    } 

    function onClick(e, el, opt) { 
        var p = picker.menu.picker; 
        p.activeDate = p.activeDate.getFirstDateOfMonth(); 
        if (p.value) { 
            p.value = p.value.getFirstDateOfMonth(); 
        } 

        p.showMonthPicker(); 
         
        if (!p.disabled) { 
            p.monthPicker.stopFx(); 
            p.monthPicker.show(); 

            p.mun(p.monthPicker, 'click', p.onMonthClick, p); 
            p.mun(p.monthPicker, 'dblclick', p.onMonthDblClick, p); 
            p.onMonthClick = p.onMonthClick.createSequence(pickerClick); 
            p.onMonthDblClick = p.onMonthDblClick.createSequence(pickerDblclick); 
            p.mon(p.monthPicker, 'click', p.onMonthClick, p); 
            p.mon(p.monthPicker, 'dblclick', p.onMonthDblClick, p); 
        } 
    } 

    function pickerClick(e, t) { 
        var el = new Ext.Element(t); 
        if (el.is('button.x-date-mp-cancel')) { 
            picker.menu.hide(); 
        } else if(el.is('button.x-date-mp-ok')) { 
            var p = picker.menu.picker; 
            p.setValue(p.activeDate); 
            p.fireEvent('select', p, p.value); 
        } 
    } 

    function pickerDblclick(e, t) { 
        var el = new Ext.Element(t); 
        if (el.parent() 
            && (el.parent().is('td.x-date-mp-month') 
            || el.parent().is('td.x-date-mp-year'))) { 

            var p = picker.menu.picker; 
            p.setValue(p.activeDate); 
            p.fireEvent('select', p, p.value); 
        } 
    } 
}; 

Ext.preg('monthPickerPlugin', Ext.ux.MonthPickerPlugin);  

//~ /* 
  //~ http://www.diloc.de/blog/2008/03/05/how-to-submit-ext-forms-the-right-way/
//~ */
//~ /**
 //~ * This submit action is basically the same as the normal submit action,
 //~ * only that it uses the fields getSubmitValue() to compose the values to submit,
 //~ * instead of looping over the input-tags in the form-tag of the form.
 //~ *
 //~ * To use it, just use the OOSubmit-plugin on either a FormPanel or a BasicForm,
 //~ * or explicitly call form.doAction('oosubmit');
 //~ *
 //~ * @param {Object} form
 //~ * @param {Object} options
 //~ */
//~ Ext.ux.OOSubmitAction = function(form, options){
    //~ Ext.ux.OOSubmitAction.superclass.constructor.call(this, form, options);
//~ };

//~ Ext.extend(Ext.ux.OOSubmitAction, Ext.form.Action.Submit, {
    //~ /**
    //~ * @cfg {boolean} clientValidation Determines whether a Form's fields are validated
    //~ * in a final call to {@link Ext.form.BasicForm#isValid isValid} prior to submission.
    //~ * Pass <tt>false</tt> in the Form's submit options to prevent this. If not defined, pre-submission field validation
    //~ * is performed.
    //~ */
    //~ type : 'oosubmit',

    //~ // private
    //~ /**
     //~ * This is nearly a copy of the original submit action run method
     //~ */
    //~ run : function(){
        //~ var o = this.options;
        //~ var method = this.getMethod();
        //~ var isPost = method == 'POST';

        //~ var params = this.options.params || {};
        //~ if (isPost) Ext.applyIf(params, this.form.baseParams);

        //~ //now add the form parameters
        //~ this.form.items.each(function(field)
        //~ {
            //~ if (!field.disabled)
            //~ {
                //~ //check if the form item provides a specialized getSubmitValue() and use that if available
                //~ if (typeof field.getSubmitValue == "function")
                    //~ params[field.getName()] = field.getSubmitValue();
                //~ else
                    //~ params[field.getName()] = field.getValue();
            //~ }
        //~ });

        //~ //convert params to get style if we are not post
        //~ if (!isPost) params=Ext.urlEncode(params);

        //~ if(o.clientValidation === false || this.form.isValid()){
            //~ Ext.Ajax.request(Ext.apply(this.createCallback(o), {
                //~ url:this.getUrl(!isPost),
                //~ method: method,
                //~ params:params, //add our values
                //~ isUpload: this.form.fileUpload
            //~ }));

        //~ }else if (o.clientValidation !== false){ // client validation failed
            //~ this.failureType = Ext.form.Action.CLIENT_INVALID;
            //~ this.form.afterAction(this, false);
        //~ }
    //~ },

//~ });
//~ //add our action to the registry of known actions
//~ Ext.form.Action.ACTION_TYPES['oosubmit'] = Ext.ux.OOSubmitAction;




/**
JC Watsons solution (adapted to ExtJS 3.3.1 by LS) is elegant and simple:
`A "fix" for unchecked checkbox submission  behaviour
<http://www.sencha.com/forum/showthread.php?28449>`_

Added special handling for checkbox inputs. 
ExtJS defines disabled checkboxes `readonly`, not `disabled` as for other inputs.

*/
Ext.lib.Ajax.serializeForm = function(form) {
    //~ console.log('20120203 linolib.js serializeForm',form);
    var fElements = form.elements || (document.forms[form] || Ext.getDom(form)).elements, 
        hasSubmit = false, 
        encoder = encodeURIComponent, 
        name, 
        data = '', 
        type, 
        hasValue;

    Ext.each(fElements, function(element){
        name = element.name;
        type = element.type;

        if (!element.disabled && name && !(type == 'checkbox' && element.readonly)) {
            if (/select-(one|multiple)/i.test(type)) {
                Ext.each(element.options, function(opt){
                    if (opt.selected) {
                        hasValue = opt.hasAttribute ? opt.hasAttribute('value') : opt.getAttributeNode('value').specified;
                        data += String.format("{0}={1}&", encoder(name), encoder(hasValue ? opt.value : opt.text));
                    }
                });
            } else if (!(/file|undefined|reset|button/i.test(type))) {
                //~ if (!(/radio|checkbox/i.test(type) && !element.checked) && !(type == 'submit' && hasSubmit)) {
                if (!(type == 'submit' && hasSubmit)) {
                    if (type == 'checkbox') {
                        //~ console.log('20111001',element,'data += ',encoder(name) + '=' + (element.checked ? 'on' : 'off') + '&');
                        data += encoder(name) + '=' + (element.checked ? 'on' : 'off') + '&';
                    } else {
                        //~ console.log('20111001',element,'data += ',encoder(name) + '=' + encoder(element.value) + '&');
                        data += encoder(name) + '=' + encoder(element.value) + '&';
                    }
                    hasSubmit = /submit/i.test(type);
                }
            }
        //~ } else {
            //~ console.log(name,type,element.readonly);
        }
    });
    return data.substr(0, data.length - 1);
};



/*
Set a long timeout of fifteen minutes. 
See /blog/2012/0307
*/
Ext.Ajax.timeout = 15 * 60 * 1000; 


/*
My fix for the "Cannot set QuickTips dismissDelay to 0" bug,
see http://www.sencha.com/forum/showthread.php?183515 
*/
Ext.override(Ext.QuickTip,{
  showAt : function(xy){
        var t = this.activeTarget;
        //~ console.log("20120224 QuickTip.showAt",this.title,this.dismissDelay,t.dismissDelay);
        if(t){
            if(!this.rendered){
                this.render(Ext.getBody());
                this.activeTarget = t;
            }
            if(t.width){
                this.setWidth(t.width);
                this.body.setWidth(this.adjustBodyWidth(t.width - this.getFrameWidth()));
                this.measureWidth = false;
            } else{
                this.measureWidth = true;
            }
            this.setTitle(t.title || '');
            this.body.update(t.text);
            this.autoHide = t.autoHide;
            // bugfix by Luc 20120226
            if (t.dismissDelay != undefined) this.dismissDelay = t.dismissDelay;
            //~ this.dismissDelay = t.dismissDelay || this.dismissDelay;
            if(this.lastCls){
                this.el.removeClass(this.lastCls);
                delete this.lastCls;
            }
            if(t.cls){
                this.el.addClass(t.cls);
                this.lastCls = t.cls;
            }
            if(this.anchor){
                this.constrainPosition = false;
            }else if(t.align){ 
                xy = this.el.getAlignToXY(t.el, t.align);
                this.constrainPosition = false;
            }else{
                this.constrainPosition = true;
            }
        }
        Ext.QuickTip.superclass.showAt.call(this, xy);
    }
});

/*
Another hack. See /docs/blog/2012/0228
*/
Ext.Element.addMethods(
    function() {
        var VISIBILITY      = "visibility",
            DISPLAY         = "display",
            HIDDEN          = "hidden",
            NONE            = "none",
            XMASKED         = "x-masked",
            XMASKEDRELATIVE = "x-masked-relative",
            data            = Ext.Element.data;

        return {
            
            mask : function(msg, msgCls) {
                var me  = this,
                    dom = me.dom,
                    dh  = Ext.DomHelper,
                    EXTELMASKMSG = "ext-el-mask-msg",
                    el,
                    mask;
                // removed the following lines. See /docs/blog/2012/0228
                //~ if (!(/^body/i.test(dom.tagName) && me.getStyle('position') == 'static')) {
                    //~ console.log(20120228,dom.tagName,me);
                    //~ me.addClass(XMASKEDRELATIVE); 
                //~ }
                if (el = data(dom, 'maskMsg')) {
                    el.remove();
                }
                if (el = data(dom, 'mask')) {
                    el.remove();
                }

                mask = dh.append(dom, {cls : "ext-el-mask"}, true);
                data(dom, 'mask', mask);

                me.addClass(XMASKED);
                mask.setDisplayed(true);
                
                if (typeof msg == 'string') {
                    var mm = dh.append(dom, {cls : EXTELMASKMSG, cn:{tag:'div'}}, true);
                    data(dom, 'maskMsg', mm);
                    mm.dom.className = msgCls ? EXTELMASKMSG + " " + msgCls : EXTELMASKMSG;
                    mm.dom.firstChild.innerHTML = msg;
                    mm.setDisplayed(true);
                    mm.center(me);
                }
                
                
                if (Ext.isIE && !(Ext.isIE7 && Ext.isStrict) && me.getStyle('height') == 'auto') {
                    mask.setSize(undefined, me.getHeight());
                }
                
                return mask;
            }

            
        };
    }()
);



Ext.namespace('Lino');
    
    

//~ Lino.subst_user_field = new Ext.form.ComboBox({});
//~ Lino.subst_user = null;
Lino.insert_subst_user = function(p){
    //~ console.log('20120714 insert_subst_user',Lino.subst_user,p);
    //~ if (Lino.subst_user_field.getValue()) {
    if (p.su) return;
    if (Lino.subst_user) {
        //~ p.su = Lino.subst_user_field.getValue();
        p.su = Lino.subst_user;
    //~ } else {
        //~ delete p.su;
    }
    //~ console.log('20120714 insert_subst_user -->',Lino.subst_user,p);
}

Lino.login_window = null;


Lino.show_login_window = function() {
  //~ console.log('20121103 show_login_window',arguments);
  //~ var current_window = Lino.current_window;
  if (Lino.login_window == null) {
    
      function do_login() { 
            Lino.viewport.loadMask.show()
            //~ Lino.body_loadMask.show()
            login_panel.getForm().submit({ 
                method:'POST', 
                waitTitle:'Connecting', 
                waitMsg:'Sending data...',
                success:function(){ 
                  //~ console.log('20121104 logged in',arguments);
                  Lino.login_window.hide();
                  Lino.close_all_windows();
                  Lino.viewport.loadMask.hide()
                  //~ Lino.body_loadMask.hide()
                },
                failure: function(form,action) { 
                  //~ this.loadMask.hide();
                  Lino.on_submit_failure(form,action);
                  Lino.viewport.loadMask.hide()
                  //~ Lino.body_loadMask.hide()
                  //~ if (Lino.current_window) Lino.current_window.main_item.loadMask.hide()
                }
                //~ failure:function(form, action){ 
                    //~ alert_msg
                    //~ if(action.failureType == 'server'){ 
                        //~ obj = Ext.util.JSON.decode(action.response.responseText); 
                        //~ Ext.Msg.alert('Login Failed!', obj.errors.reason); 
                    //~ }else{ 
                        //~ Ext.Msg.alert('Warning!', 'Authentication server is unreachable : ' + action.response.responseText); 
                    //~ } 
                    //~ Lino.login_panel.getForm().reset(); 
                //~ } 
            }); 
      };
    
      var login_button = new Ext.Button({ 
        text:"Anmelden",
        formBind: true,	 
        // Function that fires when user clicks the button 
        handler: do_login});
    
      var login_panel = new Ext.FormPanel({ 
        //~ inspired by http://www.sencha.com/learn/a-basic-login/
        autoHeight:true,
        labelWidth:90,
        url:'/auth', 
        frame:true, 
        defaultType:'textfield',
        monitorValid:true,
        items:[{ 
            fieldLabel:"Benutzername", 
            id: 'username',
            name:'username', 
            autoHeight:true,
            allowBlank:false 
        },{ 
            fieldLabel:"Passwort", 
            name:'password', 
            inputType:'password', 
            autoHeight:true,
            allowBlank:false 
        }],        
        buttons:[ login_button ]});
        
      Lino.login_window = new Ext.Window({
          layout:'fit',
          defaultButton: 'username',
          width:300,
          title:"Anmelden", 
          autoHeight:true,
          modal: true,
          closeAction: "hide",
          keys: {
            key: Ext.EventObject.ENTER,
            fn: function() { do_login()}
          },
          //~ defaultButton: login_button,
          //~ height:'auto',
          //~ closable: false,
          //~ resizable: false,
          //~ plain: true,
          //~ border: false,
          items: [login_panel] });
  };
  Lino.login_window.show();
};

Lino.logout = function(id,name) {
    //~ console.log('20121104 gonna log out',arguments);
    //~ Lino.do_action
    Lino.call_ajax_action(Lino.viewport,'GET','/auth',{},'logout',undefined,undefined,function(){
        //~ console.log('20121104 logged out',arguments);
        //~ Lino.login_window.hide();
        Lino.close_all_windows();
    })
}

Lino.set_subst_user = function(id,name) {
    //~ console.log(20120714,'Lino.set_subst_user',id,name);
    Lino.subst_user = id;

    if (Lino.current_window) 
        Lino.current_window.main_item.set_base_param("su",id);
    if (Lino.viewport) Lino.permalink_handler(Lino.current_window)();
}



//~ Lino.select_subst_user = function(cmp,rec,value){
    //~ Lino.subst_user=value;
    //~ console.log(20120713,rec);
//~ }
    
Lino.current_window = null;
Lino.window_history = Array();
    
Lino.chars2width = function(cols) {  return cols * 9; }
Lino.rows2height = function(cols) {  return cols * 20; }



Lino.Viewport = Ext.extend(Ext.Viewport,{
  layout:"fit"
  ,initComponent : function(){
    Lino.Viewport.superclass.initComponent.call(this);
    this.on('render',function(){
      this.loadMask = new Ext.LoadMask(this.el,{msg:"Bitte warten..."});
      //~ console.log("20121118 Lino.viewport.loadMask",this.loadMask);
    },this);
  }
  ,get_base_params : function() { 
    var p = {};
    Lino.insert_subst_user(p);
    return p;
  }
  ,refresh : function() {
      var caller = this;
      console.log("20121120 Lino.Viewport.refresh()");
      if (caller.loadMask) caller.loadMask.show();
      var success = function(response) {
        if (caller.loadMask) caller.loadMask.hide();
        if (response.responseText) {
          var result = Ext.decode(response.responseText);
          //~ console.log('Lino.do_action()',action.name,'result is',result);
          if (result.html) {
              Ext.getCmp('main_area').update(result.html);
          }
          if (result.message) {
              if (result.alert) {
                  //~ Ext.MessageBox.alert('Alert',result.alert_msg);
                  Ext.MessageBox.alert('Alert',result.message);
              } else {
                  Lino.notify(result.message);
              }
          }
          
          if (result.notify_msg) Lino.notify(result.notify_msg);
          if (result.js_code) { 
            var jsr = result.js_code(caller);
            //~ console.log('Lino.do_action()',action,'returned from js_code in',result);
          };
        }
      };
      var action = {
        url : '/api/main_html',
        waitMsg: "Bitte warten...",
        failure: Lino.ajax_error_handler(caller),
        success: success,
        method: 'GET',
        params: {}
      };
      Lino.insert_subst_user(action.params);
      Ext.Ajax.request(action);
    
  }
});


Lino.open_window = function(win,st,requesting_panel) {
  //~ console.log("20120918 Lino.open_window()",win,st);
  var cw = Lino.current_window;
  if (cw) {
    //~ console.log("20120918 Lino.open_window() save current status",cw.main_item.get_status());
    Lino.window_history.push({
      window:cw,
      status:cw.main_item.get_status()
    });
  }
  Lino.current_window = win;
  //~ if (st.su) 
      //~ Lino.subst_user_field.setValue(st.su);
  win.main_item.set_status(st,requesting_panel);
  win.show();
};

Lino.load_url = function(url) {
    //~ foo.bar.baz = 2; 
    //~ console.log("20121120 Lino.load_url()");
    //~ Lino.body_loadMask.show();
    Lino.viewport.loadMask.show();
    //~ location.replace(url);
    document.location = url;
}

Lino.close_window = function(status_update) {
  var cw = Lino.current_window;
  var ww = Lino.window_history.pop();
  if (ww) {
    //~ if (status_update) Ext.apply(ww.status,status_update);
    if (status_update) status_update(ww);
    ww.window.main_item.set_status(ww.status);
    Lino.current_window = ww.window;
  } else {
    Lino.current_window = null;
  }
  if (cw) cw.hide_really();
};

Lino.close_all_windows = function() {
  if (Lino.window_history.length == 0) {
      //~ Lino.viewport.refresh();
      var url =  "/"
      //~ console.log("20121120 Lino.close_all_windows() : no window_history");
      //~ if (ADMIN_URL) 
      var p = {};
      Lino.insert_subst_user(p)
      if (Ext.urlEncode(p)) url = url + "?" + Ext.urlEncode(p);
      Lino.load_url(url);
  } else {
    //~ console.log("20121120 Lino.close_all_windows() with window_history");
    while (Lino.window_history.length > 0) {
      Lino.close_window();
      //~ Lino.window_history.pop().hide_really();
    }
  }
  //~ Lino.current_window = null;
  //~ Lino.close_window();
  //~ var ww = 
}

Lino.kill_current_window = function() {
  var cw = Lino.current_window;
  Lino.current_window = null;
  if (cw) cw.hide_really();
};

Lino.calling_window = function() {
    if (Lino.window_history.length) return Lino.window_history[Lino.window_history.length-1];
}

//~ Lino.WindowAction = function(mainItemClass,windowConfig,mainConfig,ppf) {
Lino.WindowAction = function(windowConfig,main_item_fn) {
    //~ if(!mainConfig) mainConfig = {};
    //~ mainConfig.is_main_window = true;
    this.windowConfig = windowConfig;
    this.main_item_fn = main_item_fn;
    //~ if (ppf) mainConfig.params_panel.fields = ppf;
    //~ this.mainConfig = mainConfig;
    //~ this.mainItemClass = mainItemClass;
};

Lino.WindowAction = Ext.extend(Lino.WindowAction,{
    window : null,
    //~ mainItemClass: null,
    get_window : function() {
      //~ if(mainConfig) Ext.apply(this.mainConfig,mainConfig);
      if (this.window == null)  {
          //~ this.windowConfig.main_item = new this.mainItemClass(this.mainConfig);
          this.windowConfig.main_item = this.main_item_fn();
          this.window = new Lino.Window(this.windowConfig);
      }
      return this.window;
    },
    run : function(requesting_panel,status) {
      //~ console.log('20120625 window_action.run()',this)
      Lino.open_window(this.get_window(),status,requesting_panel);
    }
  
});


Lino.PanelMixin = {
  get_containing_window : function (){
      if (this.containing_window) return this.containing_window;
      return this.containing_panel.get_containing_window();
  }
  ,set_window_title : function(title) {
    //~ this.setTitle(title);
    var cw = this.get_containing_window();

    //~ if (cw) {
    //~ if (cw && cw.closable) {
    if (cw && !cw.main_item.hide_window_title) {
      //~ console.log('20111202 set_window_title(',title,') for',this.containing_window);
      //~ if (! this.containing_window.rendered) console.log("WARNING: not rendered!");
      cw.setTitle(title);
    //~ } else {
      //~ document.title = title;
    }
    //~ else console.log('20111202 not set_window_title(',title,') for',this);
  }
  
};


// Lino.status_bar = new Ext.ux.StatusBar({defaultText:'Lino version 1.6.11.'});
Lino.status_bar = new Ext.ux.StatusBar({defaultText:'Lino Welfare 1.1.8.'});



Lino.edit_tinymce_text = function(panel,options) {
  // `panel` is the RichTextPanel
  //~ console.log(20111220,panel);
  //~ var rec = panel.get_current_record();
  var rec = panel.containing_panel.get_current_record();
  var value = rec ? rec.data[panel.editor.name] : '';
  var saving = false;
  var todo_after_save = false;
  var discard_changes = false;
  
  
  function save() {
    //~ if (todo_after_save) {alert('tried to save again'); return; }
    if (saving) {alert('tried to save again'); return; }
    //~ var url = panel.containing_window.main_item.get_record_url(rec.id);
    var url = panel.containing_panel.get_record_url(rec.id);
    var params = Ext.apply({},panel.containing_panel.get_base_params());
    params[panel.editor.name] = editor.getValue();
    //~ params.su = Lino.subst_user;
    //~ Lino.insert_subst_user(params);
    var a = { 
      params: params, 
      method: 'PUT',
      url: url,
      failure: function() {
          //~ if (editor.ed.getContainer()) 
          editor.ed.setProgressState(0);
          todo_after_save = false;
          saving = false;
          console.log('tinymce.save() failed. sorry.',arguments);
        },
      success: function() {
        saving = false;
        //~ if (editor.ed.getContainer()) 
        editor.ed.setProgressState(0);
        rec.data[panel.editor.name] = editor.getValue();
        if(todo_after_save) {
            var fn = todo_after_save;
            todo_after_save = false;
            fn();
        }
        //~ panel.containing_window.set_current_record(rec);
        panel.refresh();
      }
    };
    //~ if (editor.ed.getContainer()) 
    editor.ed.setProgressState(1); // Show progress
    saving = true;
    //~ console.log(a);
    Ext.Ajax.request(a);
  };
  function save_callback() {
      save();
      //~ save(function(){editor.ed.setDirty(false);})
      /* return true have the save button disabled.  
      That's not perfect because the PUT is asynchronous 
      and the response is not yet known.
      */
      return true;
  }
  //~ var actions = [
    //~ {text:"Save",handler:save}
  //~ ]; 
  //~ console.log(20110610,panel.editor.disabled);
  var settings = {};
  Ext.apply(settings,{
        readonly: panel.editor.disabled,
        //~ language: "de",
        plugins : "save,emotions,spellchecker,advhr,insertdatetime,preview,table,searchreplace,template", 
        // Theme options - button# indicated the row# only
        theme_advanced_buttons1 : "save,cancel,|,bold,italic,underline,|,justifyleft,justifycenter,justifyright,fontselect,fontsizeselect,formatselect,|,search,replace",
        theme_advanced_buttons2 : "cut,copy,paste,template,|,bullist,numlist,|,outdent,indent,|,undo,redo,|,link,unlink,anchor,image,|,code,preview,|,forecolor,backcolor",
        theme_advanced_buttons3 : "insertdate,inserttime,|,spellchecker,advhr,,removeformat,|,sub,sup,|,charmap,emotions,|,tablecontrols",      
        theme_advanced_resizing : false,
        convert_urls : false,
        save_onsavecallback : save_callback,
        save_enablewhendirty : true
        //~ save_oncancelcallback: on_cancel
  });
  Ext.apply(settings,options);
  var editor = new Ext.ux.TinyMCE({
      value : value,
      tinymceSettings: settings
    });
  var win = new Ext.Window({
    title: rec.title, 
    //~ bbar: actions,
    layout: 'fit',
    items: editor,
    width: 600, 
    height:500,
    minWidth: 100,
		minHeight: 100,
    modal: true,
    resizable: true,
    maximizable: true,
    //~ maximized: true,
    //~ closeAction: "close"
    closeAction: "hide"
    //~ hideMode: "offsets",
    //~ constrainHeader: true,
    //~ bodyStyle: 'padding: 10px'
  });

  //~ win.on('beforeclose',function() {
  win.on('beforehide',function() {
    if (todo_after_save) return false;
    if (discard_changes) return true;
    if (editor.isDirty()) {
        //~ var ok = false;
        //~ var allowClose = true;
        var config = {title:"Bestätigung"};
        config.buttons = Ext.MessageBox.YESNOCANCEL;
        config.msg = "Änderungen im Text speichern?";
        config.modal = true;
        config.fn = function(buttonId,text,opt) {
          //~ console.log('do_when_clean',buttonId)
          if (buttonId == "yes") {
              /* we cancel this close, but save()'s onSuccess will call again.*/
              //~ allowClose = false;
              todo_after_save = function(){win.hide();}
              editor.ed.execCommand('mceSave');
              //~ editor.ed.save(function(){win.close();});
          } else if (buttonId == "no") { 
              discard_changes = true;
              win.hide()
          //~ } else if (buttonId == "cancel") { 
            //~ ok = true;
              //~ allowClose = false;
          //~ } else { 
            //~ console.log('unknwon buttonId:',buttonId);
          }
        }
        Ext.MessageBox.show(config);
        return false;
        //~ return allowClose;
    }
  });
  win.show();
}







/* 
  Originally copied from Ext JS Library 3.3.1
  Modifications by Luc Saffre : 
  - rendering of phantom records
  - fire afteredit event
  - react on dblclcik, not on single click

 */
Lino.CheckColumn = Ext.extend(Ext.grid.Column, {

    processEvent : function(name, e, grid, rowIndex, colIndex){
        //~ console.log('20110713 Lino.CheckColumn.processEvent',name)
        if (name == 'click') {
        //~ if (name == 'mousedown') {
        //~ if (name == 'dblclick') {
            return this.toggleValue(grid, rowIndex, colIndex);
        } else {
            return Ext.grid.ActionColumn.superclass.processEvent.apply(this, arguments);
        }
    },
    
    toggleValue : function (grid,rowIndex,colIndex) {
        var record = grid.store.getAt(rowIndex);
        var dataIndex = grid.colModel.getDataIndex(colIndex);
        // 20120514
        //~ if(record.data.disabled_fields && record.data.disabled_fields[dataIndex]) {
          //~ Lino.notify("Dieses Feld ist deaktiviert");
          //~ return false;
        //~ }
      
        //~ if (dataIndex in record.data['disabled_fields']) {
            //~ Lino.notify("This field is disabled.");
            //~ return false;
        //~ }
        var startValue = record.data[dataIndex];
        var value = !startValue;
        //~ record.set(this.dataIndex, value);
        var e = {
            grid: grid,
            record: record,
            field: dataIndex,
            originalValue: startValue,
            value: value,
            row: rowIndex,
            column: colIndex,
            cancel: false
        };
        if(grid.fireEvent("beforeedit", e) !== false && !e.cancel){
        //~ if(grid.fireEvent("validateedit", e) !== false && !e.cancel){
            record.set(dataIndex, value);
            delete e.cancel;
            grid.fireEvent("afteredit", e);
        }
        return false; // Cancel event propagation
    },

    renderer : function(v, p, record){
        if (record.phantom) return '';
        p.css += ' x-grid3-check-col-td'; 
        return String.format('<div class="x-grid3-check-col{0}">&#160;</div>', v ? '-on' : '');
    }

    // Deprecate use as a plugin. Remove in 4.0
    // init: Ext.emptyFn
});

// register ptype. Deprecate. Remove in 4.0
// Ext.preg('checkcolumn', Lino.CheckColumn);

// backwards compat. Remove in 4.0
// Ext.grid.CheckColumn = Lino.CheckColumn;

// register Column xtype
Ext.grid.Column.types.checkcolumn = Lino.CheckColumn;


/* 20110725 : 
Lino.on_tab_activate is necessary 
in contacts.Person.2.dtl 
(but don't ask me why...)
*/
Lino.on_tab_activate = function(item) {
  //~ console.log('activate',item); 
  if (item.rendered && item.doLayout) item.doLayout();
  //~ if (item.rendered) item.doLayout();
}

Lino.TimeField = Ext.extend(Ext.form.TimeField,{
  format: 'H:i',
  increment: 15
  });
Lino.DateField = Ext.extend(Ext.form.DateField,{
  boxMinWidth: Lino.chars2width(11),
  format: 'd.m.Y',
  altFormats: 'd/m/Y|Y-m-d'
  });
Lino.DatePickerField = Ext.extend(Ext.DatePicker,{
  //~ boxMinWidth: Lino.chars2width(11),
  format: 'd.m.Y',
  //~ altFormats: 'd/m/Y|Y-m-d'
  formatDate : function(date){
      console.log("20121203 formatDate",this.name,date);
      return Ext.isDate(date) ? date.dateFormat(this.format) : date;
  }
  });
Lino.DateTimeField = Ext.extend(Ext.ux.form.DateTime,{
  dateFormat: 'd.m.Y',
  timeFormat: 'H:i',
  //~ hiddenFormat: 'd.m.Y H:i'
  });
Lino.URLField = Ext.extend(Ext.form.TriggerField,{
  triggerClass : 'x-form-search-trigger',
  //~ triggerClass : 'x-form-world-trigger',
  vtype: 'url',
  onTriggerClick : function() {
    //~ console.log('Lino.URLField.onTriggerClick',this.value)
    //~ document.location = this.value;
    window.open(this.getValue(),'_blank');
  }
});
Lino.IncompleteDateField = Ext.extend(Ext.form.TextField,{
  //~ regex: /^-?\d+-[01]\d-[0123]\d$/,
  //~ regex: /^[0123]\d\.[01]\d\.-?\d+$/,
  maxLength: 10,
  boxMinWidth: Lino.chars2width(10),
  regex: /^[0123]?\d\.[01]?\d\.-?\d+$/,
  regexText: 'Datum im Format JJJJ-MM-TT eingeben (Nullen für unbekannte Teile)'
  });


//~ Lino.make_dropzone = function(cmp) {
    //~ cmp.on('render', function(ct, position){
      //~ ct.el.on({
        //~ dragenter:function(event){
          //~ event.browserEvent.dataTransfer.dropEffect = 'move';
          //~ return true;
        //~ }
        //~ ,dragover:function(event){
          //~ event.browserEvent.dataTransfer.dropEffect = 'move';
          //~ event.stopEvent();
          //~ return true;
        //~ }
        //~ ,drop:{
          //~ scope:this
          //~ ,fn:function(event){
            //~ event.stopEvent();
            //~ console.log(20110516);
            //~ var files = event.browserEvent.dataTransfer.files;
            //~ if(files === undefined){
              //~ return true;
            //~ }
            //~ var len = files.length;
            //~ while(--len >= 0){
              //~ console.log(files[len]);
              //~ // this.processDragAndDropFileUpload(files[len]);
            //~ }
          //~ }
        //~ }
      //~ });
    //~ });
//~ };

//~ Lino.FileUploadField = Ext.ux.form.FileUploadField;

Lino.FileUploadField = Ext.extend(Ext.ux.form.FileUploadField,{
    onRender : function(ct, position){
      Lino.FileUploadField.superclass.onRender.call(this, ct, position);
      this.el.on({
        dragenter:function(event){
          event.browserEvent.dataTransfer.dropEffect = 'move';
          return true;
        }
        ,dragover:function(event){
          event.browserEvent.dataTransfer.dropEffect = 'move';
          event.stopEvent();
          return true;
        }
        ,drop:{
          scope:this
          ,fn:function(event){
            event.stopEvent();
            //~ console.log(20110516);
            var files = event.browserEvent.dataTransfer.files;
            if(files === undefined){
              return true;
            }
            var len = files.length;
            while(--len >= 0){
              console.log(files[len]);
              //~ this.processDragAndDropFileUpload(files[len]);
            }
          }
        }
      });
    }
});

Lino.FileField = Ext.extend(Ext.form.TriggerField,{
  triggerClass : 'x-form-search-trigger',
  editable: false,
  onTriggerClick : function() {
    //~ console.log('Lino.URLField.onTriggerClick',this.value)
    //~ document.location = this.value;
    if (this.getValue()) window.open(MEDIA_URL + '/'+this.getValue(),'_blank');
  }
});

Lino.file_field_handler = function(panel,config) {
  //~ if (instanceof Lino.DetailWrapper) {
  if (panel.action_name == 'insert') {
  //~ if (panel.get_current_record().phantom) {
      panel.has_file_upload = true;

      var f = new Lino.FileUploadField(config);
      //~ Lino.make_dropzone(f);
      return f;
      //~ return new Ext.ux.form.FileUploadField(config);
      //~ return new Lino.FileField(config);
      
  } else {
      //~ return new Lino.URLField(config);
      return new Lino.FileField(config);
  }
}

Lino.VBorderPanel = Ext.extend(Ext.Panel,{
    constructor : function(config) {
      config.layout = 'border';
      delete config.layoutConfig;
      Lino.VBorderPanel.superclass.constructor.call(this,config);
      for(var i=0; i < this.items.length;i++) {
        var item = this.items.get(i);
        if (this.isVertical(item) && item.collapsible) {
          item.on('collapse',this.onBodyResize,this);
          item.on('expand',this.onBodyResize,this);
        }
      }
    },
    isVertical : function(item) {
       return (item.region == 'north' || item.region == 'south' || item.region == 'center');
    },
    onBodyResize: function(w, h){
        //~ console.log('VBorderPanel.onBodyResize',this.title)
      if (this.isVisible()) { // to avoid "Uncaught TypeError: Cannot call method 'getHeight' of undefined."
        var sumflex = 0;
        var availableHeight = this.getInnerHeight();
        var me = this;
        this.items.each(function(item){
          if (me.isVertical(item)) {
              if (item.collapsed || item.flex == 0 || item.flex === undefined) {
                  if (item.rendered) availableHeight -= item.getHeight();
              } else {
                  sumflex += item.flex;
              }
          } 
          
        });
        //~ for(var i=0; i < this.items.length;i++) {
          //~ var item = this.items.get(i);
          //~ // if (this.isVertical(item) && item.getResizeEl()) {
          //~ if (this.isVertical(item)) {
              //~ if (item.collapsed || item.flex == 0 || item.flex === undefined) {
                  //~ // item.syncSize()
                  //~ // item.doLayout()
                  //~ // if (item.region == "north") console.log('region north',item.getHeight(),item.id, item);
                  //~ // if (item.getHeight() == 0) console.log(20100921,'both flex and getHeight() are 0!');
                  //~ availableHeight -= item.getHeight();
              //~ } else {
                  //~ sumflex += item.flex;
                  //~ // console.log(item.flex);
              //~ }
          //~ } 
          //~ // else console.log('non-vertical item in VBoderPanel:',item)
        //~ }
        var hunit = availableHeight / sumflex;
        //~ console.log('sumflex=',sumflex,'hunit=',hunit, 'availableHeight=',availableHeight);
        for(var i=0; i < this.items.length;i++) {
          var item = this.items.get(i);
          if (this.isVertical(item)) {
              if (item.flex != 0 && ! item.collapsed) {
                  item.setHeight(hunit * item.flex);
                  //~ console.log(item.region,' : height set to',item.getHeight());
              }
          }
          //~ else console.log('non-vertical item in VBoderPanel:',item)
        }
      }
      Lino.VBorderPanel.superclass.onBodyResize.call(this, w, h);
    }
});


/*
  modifications to the standard behaviour of a CellSelectionModel:
  
*/
Ext.override(Ext.grid.CellSelectionModel, {
//~ var dummy = {

    handleKeyDown : function(e){
        /* removed because F2 wouldn't pass
        if(!e.isNavKeyPress()){
            return;
        }
        */
        //~ console.log('handleKeyDown',e)
        var k = e.getKey(),
            g = this.grid,
            s = this.selection,
            sm = this,
            walk = function(row, col, step){
                return g.walkCells(
                    row,
                    col,
                    step,
                    g.isEditor && g.editing ? sm.acceptsNav : sm.isSelectable, 
                    sm
                );
            },
            cell, newCell, r, c, ae;

        switch(k){
            case e.ESC:
            case e.PAGE_UP:
            case e.PAGE_DOWN:
                break;
            default:
                // e.stopEvent(); // removed because Browser keys like Alt-Home, Ctrl-R wouldn't work
                break;
        }

        if(!s){
            cell = walk(0, 0, 1); 
            if(cell){
                this.select(cell[0], cell[1]);
            }
            return;
        }

        cell = s.cell;  
        r = cell[0];    
        c = cell[1];    
        
        switch(k){
            case e.TAB:
                if(e.shiftKey){
                    newCell = walk(r, c - 1, -1);
                }else{
                    newCell = walk(r, c + 1, 1);
                }
                break;
            case e.HOME:
                if (! (g.isEditor && g.editing)) {
                  if (!e.hasModifier()){
                      newCell = [r, 0];
                      //~ console.log('home',newCell);
                      break;
                  }else if(e.ctrlKey){
                      var t = g.getTopToolbar();
                      var activePage = Math.ceil((t.cursor + t.pageSize) / t.pageSize);
                      if (activePage > 1) {
                          e.stopEvent();
                          t.moveFirst();
                          return;
                      }
                      newCell = [0, c];
                      break;
                  }
                }
            case e.END:
                if (! (g.isEditor && g.editing)) {
                  c = g.colModel.getColumnCount()-1;
                  if (!e.hasModifier()) {
                      newCell = [r, c];
                      //~ console.log('end',newCell);
                      break;
                  }else if(e.ctrlKey){
                      var t = g.getTopToolbar();
                      var d = t.getPageData();
                      if (d.activePage < d.pages) {
                          e.stopEvent();
                          var self = this;
                          t.on('change',function(tb,pageData) {
                              var r = g.store.getCount()-2;
                              self.select(r, c);
                              //~ console.log('change',r,c);
                          },this,{single:true});
                          t.moveLast();
                          return;
                      } else {
                          newCell = [g.store.getCount()-1, c];
                          //~ console.log('ctrl-end',newCell);
                          break;
                      }
                  }
                }
            case e.DOWN:
                newCell = walk(r + 1, c, 1);
                break;
            case e.UP:
                newCell = walk(r - 1, c, -1);
                break;
            case e.RIGHT:
                newCell = walk(r, c + 1, 1);
                break;
            case e.LEFT:
                newCell = walk(r, c - 1, -1);
                break;
            case e.F2:
                if (!e.hasModifier()) {
                    if (g.isEditor && !g.editing) {
                        g.startEditing(r, c);
                        e.stopEvent();
                        return;
                    }
                    break;
                }
            case e.INSERT:
                if (!e.hasModifier()) {
                    if (g.ls_insert_handler && !g.editing) {
                        e.stopEvent();
                        Lino.show_insert(g);
                        return;
                    }
                    break;
                }
            case e.DELETE:
                if (!e.hasModifier()) {
                    if (!g.editing) {
                        e.stopEvent();
                        Lino.delete_selected(g);
                        return;
                    }
                    break;
                }
            case e.ENTER:
                e.stopEvent();
                g.onCellDblClick(r,c);
                break;
                
        }
        

        if(newCell){
          e.stopEvent();
          r = newCell[0];
          c = newCell[1];
          this.select(r, c); 
          if(g.isEditor && g.editing){ 
            ae = g.activeEditor;
            if(ae && ae.field.triggerBlur){
                ae.field.triggerBlur();
            }
            g.startEditing(r, c);
          }
        //~ } else if (g.isEditor && !g.editing && e.charCode) {
        //~ // } else if (!e.isSpecialKey() && g.isEditor && !g.editing) {
            //~ g.set_start_value(String.fromCharCode(e.charCode));
            //~ // g.set_start_value(String.fromCharCode(k));
            //~ // g.set_start_value(e.charCode);
            //~ g.startEditing(r, c);
            //~ // e.stopEvent();
            //~ return;
        // } else {
          // console.log('20120513',e,g);
        }
        
    }


//~ };
});

 

function PseudoConsole() {
    this.log = function() {};
};
if (typeof(console) == 'undefined') console = new PseudoConsole();

Lino.notify = function(msg) {
  if (msg == undefined) msg = ''; else console.log(msg);
  //~ Ext.getCmp('konsole').update(msg);
  Lino.status_bar.setStatus({
    text: msg,
    iconCls: 'ok-icon',
    clear: true // auto-clear after a set interval
  });
  //~ Ext.getCmp('konsole').setTitle(msg.replace(/\n/g,'<br/>'));
  //~ Ext.getCmp('konsole').update(msg.replace(/\n/g,'<br/>'));
};
Lino.alert = function(msg) {
  //~ if (msg == undefined) msg = ''; else console.log(msg);
  Ext.MessageBox.alert('Notify',msg);
};


//~ Lino.show_about = function() {
  //~ new Ext.Window({
    //~ width: 400, height: 400,
    //~ title: "About",
    //~ html: '<a href="http://www.extjs.com" target="_blank">ExtJS</a> version ' + Ext.version
  //~ }).show();
//~ };

function obj2str(o) {
  if (typeof o != 'object') return String(o);
  var s = '';
  for (var p in o) {
    s += p + ': ' + obj2str(o[p]) + '\n';
  }
  return s;
}

Lino.on_store_exception = function (store,type,action,options,response,arg) {
  //~ throw response;
  console.log("on_store_exception: store=",store,
    "type=",type,
    "action=",action,
    "options=",options,
    "response=",response,
    "arg=",arg);
  if (arg) { console.log(arg.stack)};
};

//~ Lino.on_submit_success = function(form, action) {
   //~ Lino.notify(action.result.message);
   //~ this.close();
//~ };

Lino.on_submit_failure = function(form, action) {
    //~ Lino.notify();
  // action may be undefined
    switch (action.failureType) {
        case Ext.form.Action.CLIENT_INVALID:
            Ext.Msg.alert('Client-side failure', 'Form fields may not be submitted with invalid values');
            break;
        case Ext.form.Action.CONNECT_FAILURE:
            Ext.Msg.alert('Connection failure', 'Ajax communication failed');
            break;
        case Ext.form.Action.SERVER_INVALID:
            Ext.Msg.alert('Server-side failure', action.result.message);
   }
};



/*
Lino.save_wc_handler = function(ww) {
  return function(event,toolEl,panel,tc) {
    var pos = panel.getPosition();
    var size = panel.getSize();
    wc = ww.get_window_config();
    Ext.applyIf(wc,{ 
      x:pos[0],y:pos[1],height:size.height,width:size.width,
      maximized:panel.maximized});
    Lino.do_action(ww,{url:'/window_configs/'+ww.config.permalink_name,params:wc,method:'POST'});
  }
};

*/

Lino.show_in_own_window_button = function(handler) {
  return {
    qtip: "Dieses Panel in eigenem Fenster öffnen", 
    id: "up",
    handler: function(event,toolEl,panel, tc) {
      //~ console.log('20111206 report_window_button',panel,handler);
      //~ var bp = ww.get_master_params();
      //~ panel.containing_window = ww; // for HtmlBox. see blog/2010/1022
      //~ handler(panel,{base_params:bp});
      //~ handler(panel,{base_params:panel.get_master_params()});
      handler.run(null,{base_params:panel.containing_panel.get_master_params()});
      //~ handler(panel,{master_panel:panel.containing_window.main_item});
    }
  }
}




Lino.delete_selected = function(panel) {
  //~ console.log("Lino.delete_selected",panel);
  var recs1 = panel.get_selected();
  var recs = [];
  for ( var i=0; i < recs1.length; i++ ) { if (! recs1[i].phantom) recs.push(recs1[i]); }
  if (recs.length == 0) {
    Lino.notify("Please select at least one record.");
    return;
  };
  if (recs.length == 1) {
      if (recs[0].disable_delete) {
        Lino.alert(recs[0].disable_delete);
        return;
      }
  };
  //~ console.log(recs);
  Ext.MessageBox.show({
    title: "Bestätigung",
    msg: String.format("Es werden {0} Datensätze gelöscht. Sind Sie sicher?",String(recs.length)),
    //~ msg: "Delete " + String(recs.length) + " rows. Are you sure?",
    //~ buttons: Ext.MessageBox.YESNOCANCEL,
    buttons: Ext.MessageBox.YESNO,
    fn: function(btn) {
      if (btn == 'yes') {
        for ( var i=0; i < recs.length; i++ ) {
          Lino.do_action(panel,{
              method:'DELETE',
              url:  '/api' + panel.ls_url + '/' + recs[i].id,
              after_success: panel.after_delete.createDelegate(panel)
          })
        }
        //~ caller.after_delete();
      }
      else Lino.notify("Dann eben nicht.");
    }
  });
};

Lino.action_handler = function (panel,on_success,on_confirm) {
  return function (response) {
    //~ console.log(20120608,panel);
    if (panel instanceof Lino.GridPanel) {
        //~ gridmode = false;
        gridmode = true;
        //~ console.log('20120608 yes');
    } else {
        gridmode = false;
        //~ console.log('20120608 no');
    }
    panel.loadMask.hide(); // 20120211
    if (!response.responseText) return ;
    var result = Ext.decode(response.responseText);
    //~ console.log('Lino.action_handler()','result is',result,'on_confirm is',on_confirm);
    
    if (result.eval_js) {
        //~ console.log(20120618,result.eval_js);
        eval(result.eval_js);
    }
    
    if (result.xcallback) {
        //~ var config = {title:"Bestätigung"};
        var config = {title:result.xcallback.title};
        //~ config.buttons = Ext.MessageBox.YESNOCANCEL;
        //~ config.buttons = Ext.MessageBox.YESNO;
        config.buttons = result.xcallback.buttons;
        config.msg = result.message;
        config.fn = function(buttonId,text,opt) {
          panel.loadMask.show(); 
          //~ Lino.insert_subst_user(p);
          Ext.Ajax.request({
            method: 'GET',
            url: '/callbacks/'+result.xcallback.id + '/' + buttonId,
            //~ params: {bi: buttonId},
            success: Lino.action_handler(panel,on_success,on_confirm)
          });
          //~ Lino.call_ajax_action(panel,'GET',)
        }
        Ext.MessageBox.show(config);
        return;
    }
    
    if (on_success && result.success) on_success(result);
    
    //~ if (on_confirm && result.confirm_message) {
        //~ var config = {title:"Bestätigung"};
        //~ // config.buttons = Ext.MessageBox.YESNOCANCEL;
        //~ config.buttons = Ext.MessageBox.YESNO;
        //~ config.msg = result.confirm_message;
        //~ config.fn = function(buttonId,text,opt) {
          //~ if (buttonId == "yes") {
              //~ on_confirm(panel,undefined,result.step);
          //~ }
        //~ }
        //~ Ext.MessageBox.show(config);
        //~ return;
    //~ }
    //~ if (result.dialog_fn) {
        //~ console.log('20120928 TODO',result.dialog_fn);
    //~ }
    if (result.message) {
        //~ if (result.alert && ! gridmode) {
        if (result.alert) { // 20120628b 
            //~ Ext.MessageBox.alert('Alert',result.alert_msg);
            if (result.alert === true) result.alert = "Alarm";
            Ext.MessageBox.alert(result.alert,result.message);
        } else {
            Lino.notify(result.message);
        }
    }
    // 
    if (result.data_record && ! gridmode) {
        //~ not used
        panel.set_status({data_record:result.data_record});
    }
    else if (result.new_status && ! gridmode) {
        //~ not used
        //~ console.log('20120607 new_status');
        panel.set_status(result.new_status);
    }
    else if (result.goto_record_id != undefined && ! gridmode) {
        //~ console.log('20120607 new_status');
        panel.load_record_id(result.goto_record_id);
    }
    else if (result.refresh_all) {
        var cw = panel.get_containing_window();
        //~ console.log("20120123 refresh_all");
        if (cw) {
          cw.main_item.refresh();
        }
        else console.log("20120123 cannot refresh_all",panel);
    } else {
        //~ console.log("20121212 b gonna refresh",panel);
        if (result.refresh) panel.refresh();
    }
    
    if (result.open_davlink_url) {
       Lino.davlink_open(result.open_davlink_url);
    }
    
    if (result.open_url) {
        //~ console.log(20111126,result.open_url);
        //~ if (!result.message)
            //~ Lino.notify('Open new window <a href="'+result.open_url+'" target="_blank">'+result.open_url+'</a>');
        window.open(result.open_url,'foo',"");
        //~ document.location = result.open_url;
    }
  }
};

Lino.do_action = function(caller,action) {
  action.success = function(response) {
    if (caller.loadMask) caller.loadMask.hide();
    //~ console.log('Lino.do_action()',action,'action success',response);
    if (action.after_success) {
        //~ console.log('Lino.do_action() calling after_success');
        action.after_success();
    }
    if (response.responseText) {
      var result = Ext.decode(response.responseText);
      //~ console.log('Lino.do_action()',action.name,'result is',result);
      if (result.message) {
          if (result.alert) {
              //~ Ext.MessageBox.alert('Alert',result.alert_msg);
              Ext.MessageBox.alert('Alert',result.message);
          } else {
              Lino.notify(result.message);
          }
      }
      
      //~ if (result.alert_msg) Ext.MessageBox.alert('Alert',result.alert_msg);
      //~ if (result.message) Lino.notify(result.message);
      if (result.notify_msg) Lino.notify(result.notify_msg);
      if (result.js_code) { 
        //~ console.log('Lino.do_action()',action,'gonna call js_code in',result);
        var jsr = result.js_code(caller);
        //~ console.log('Lino.do_action()',action,'returned from js_code in',result);
        if (action.after_js_code) {
          //~ console.log('Lino.do_action()',action,'gonna call after_js_code');
          action.after_js_code(jsr);
          //~ console.log('Lino.do_action()',action,'returned from after_js_code');
        //~ } else {
          //~ console.log('Lino.do_action()',action,' : after_js_code is false');
        }
      };
    }
  };
  Ext.applyIf(action,{
    waitMsg: "Bitte warten...",
    failure: Lino.ajax_error_handler(caller),
    params: {}
  });
  //~ action.params.su = Lino.subst_user;
  Lino.insert_subst_user(action.params);
  
  Ext.Ajax.request(action);
};

//~ Lino.gup = function( name )
//~ {
  //~ // Thanks to http://www.netlobo.com/url_query_string_javascript.html
  //~ name = name.replace(/[\[]/,"\\\[").replace(/[\]]/,"\\\]");
  //~ var regexS = "[\\?&]"+name+"=([^&#]*)";
  //~ var regex = new RegExp( regexS );
  //~ var results = regex.exec( window.location.href );
  //~ if( results == null )
    //~ return "";
  //~ else
    //~ return results[1];
//~ };

//~ Lino.refresh_handler = function (ww) {
  //~ return function() { 
      //~ console.log('refresh',ww);
      //~ ww.main_item.doLayout(false,true);
      //~ ww.main_item.syncSize();
  //~ }
//~ };

//~ Lino.tools_close_handler = function (ww) {
  //~ return function() { 
      //~ ww.close();
  //~ }
//~ };
Lino.permalink_handler = function (ww) {
  return function() { 
    //~ console.log(20100923,ww.get_permalink());
    //~ document.location = ww.main_item.get_permalink();
    
    /* Uncaught TypeError: Cannot read property 'main_item' of null  */
    if (ww) {
        Lino.load_url(ww.main_item.get_permalink());
    } else {
        Lino.load_url('/');
    }
    //~ console.log(20120715, ww.main_item.get_permalink());
    //~ document.location = "?permalink=" + ww.get_permalink();
    //~ document.location = "?permalink=" + ww.config.permalink_name +'()';
  }
};
//~ Lino.run_permalink = function() {
  //~ var plink = Lino.gup('permalink');
  //~ if(plink) { eval('Lino.'+plink); }
//~ }

Lino.MainPanel = {
  is_home_page : false,
  setting_param_values : false,
  config_containing_window : function(wincfg) { }
  ,init_containing_window : function(win) { }
  ,is_loading : function() { 
      if (!this.rendered) return true;
      //~ return (Ext.select('.x-loading-msg').elements.length > 0);
      return true; 
    } 
  ,do_when_clean : function(auto_save,todo) { todo() }
  ,get_master_params : function() {
    var p = {}
    p['mt'] = this.content_type; 
    rec = this.get_current_record()
    if (rec) {
      if (rec.phantom) {
          p['mk'] = undefined; 
      }else{
          p['mk'] = rec.id; 
      }
    } else {
      p['mk'] = undefined;
    }
    //~ console.log('get_master_params returns',p,'using record',rec);
    return p;
  }
  ,get_permalink : function() {
    //~ var p = this.main_item.get_base_params() || {};
    var p = Ext.apply({},this.get_base_params());
    delete p.fmt;
    //~ if (p.fmt) delete p.fmt;
    Ext.apply(p,this.get_permalink_params());
    
    if (this.toggle_params_panel_btn) {
        p.sp = this.toggle_params_panel_btn.pressed;
        //~ if (this.toggle_params_panel_btn.pressed == this.params_panel_hidden) {
          //~ p.sp = true;
        //~ }
    }
    
    //~ Lino.insert_subst_user(p);
     //~ p.fmt = 'html';
    //~ console.log('get_permalink',p,this.get_permalink_params());
    if (this.is_home_page)
        //~ var url = '';
        var url = '/';
    else 
        var url = this.get_permalink_url();
    if (p.su == null) 
        delete p.su;
    if (Ext.urlEncode(p)) url = url + "?" + Ext.urlEncode(p);
    return url;
  }
  ,get_record_url : function(record_id) {
      var url = '/api' + this.ls_url
      //~ var url = this.containing_window.config.url_data; // ls_url;
      url += '/' + (record_id === undefined ? '-99999' : String(record_id));
      //~ if (record_id !== undefined) url += '/' + String(record_id);
      //~ url += '/' + String(record_id);
      return url;
  }
  ,get_permalink_url : function() {
      return '/api' + this.ls_url;
  }
  ,get_permalink_params : function() {
      //~ return {an:'grid'};
      var p = {};
      if (this.action_name)
          p.an = this.action_name;
      this.add_param_values(p,false)
      return p;
  }
  ,set_status : function(status) {}
  ,get_status : function() { return {}}
  ,refresh : function() {}
  ,get_base_params : function() { 
    var p = {};
    Lino.insert_subst_user(p);
    return p;
  }
  ,add_params_panel : function (tbar) {
      if (this.params_panel) {
        this.toggle_params_panel_btn = new Ext.Button({ scope:this, 
          //~ text: "$_("[parameters]")", // gear
          iconCls: 'x-tbar-parameters',
          tooltip:"Parameter-Panel ein- bzw. ausblenden",
          enableToggle: true,
          //~ pressed: ! this.params_panel.hidden,
          pressed: ! this.params_panel_hidden,
          toggleHandler: function(btn,state) { 
            //~ if (this.params_panel.isVisible()) 
                //~ this.params_panel.hide();
            //~ else
                //~ this.params_panel.show();
            //~ console.log("20120210 add_params_panel",state,this.params_panel);
            if (state) {
              this.params_panel.show();
              this.params_panel.doLayout();
            } else this.params_panel.hide();
            this.get_containing_window().doLayout();
          }
        });
        tbar = tbar.concat([this.toggle_params_panel_btn]);
        var t = this;
        var refresh = function() {if (!t.setting_param_values) t.refresh();}
        Ext.each(this.params_panel.fields,function(f) {
          //~ f.on('valid',function() {t.refresh()});
          if (f instanceof Ext.form.Checkbox) {
              f.on('check',refresh);
          } else if (f instanceof Ext.DatePicker) {
              f.on('select',refresh);
          } else if (f instanceof Ext.form.TriggerField) {
              f.on('select',refresh);
              //~ f.on('change',refresh);
              //~ f.on('valid',refresh);
          } else {
              if (! f.on) 
                  console.log("20121010 no method 'on'",f);
              else
                  f.on('change',refresh);
            }
          });
      }
      return tbar;
  }
  ,add_param_values : function (p,force_dirty) {
    if (this.params_panel) {
      /* 
      20120918 add param_values to the request string 
      *only if the params_form is dirty*.
      Otherwise Actor.default_params() would never be used.
      
      20121023 But IntegClients.params_default has non-empty default values. 
      Users must have the possibility to make them empty.
      * 20130605 : added force parameter because Checkbox fields don't 
      * mark their form as dirty when check is fired
      * 
      */
      if (force_dirty || this.params_panel.form.isDirty()) {
        p.pv = this.get_param_values();
        //~ console.log("20130605 form.isDirty",p);
      }else{
        //~ console.log("20130605 form not dirty:",this.params_panel.form);
        if (this.status_param_values) 
          p.pv = Lino.fields2array(
            this.params_panel.fields,this.status_param_values);
      }
      //~ if (!this.params_panel.form.isDirty()) return;
      //~ p.pv = this.get_param_values();
      //~ console.log("20120203 add_param_values added pv",pv,"to",p);
    }
  },
  get_param_values : function() { // similar to get_field_values()
      return Lino.fields2array(this.params_panel.fields);
  },
  set_param_values : function(pv) {
    if (this.params_panel) {
      //~ console.log('20120203 MainPanel.set_param_values', pv);
      this.status_param_values = pv;
      //~ this.params_panel.form.suspendEvents(false);
      this.setting_param_values = true;
      if (pv) { 
          this.params_panel.form.my_loadRecord(pv);
      } else { 
        this.params_panel.form.reset(); 
      }
      this.setting_param_values = false;
      //~ this.params_panel.form.resumeEvents();
    }
  }
};


Lino.ajax_error_handler = function(panel) {
  return function(response,options) {
    console.log('Ajax failure:',response,options);
    if (panel.loadMask) panel.loadMask.hide();
    if (response.responseText) {
      var lines = response.responseText.split('\n');
      if (lines.length > 10) {
          line = lines.splice(5,lines.length-10,"(...)");
      }
      Ext.MessageBox.alert(
        response.statusText,
        lines.join('<br/>')
        //~ response.responseText.replace(/\n/g,'<br/>'))
      )
    } else {
      Ext.MessageBox.alert('Action failed',
        'Lino server did not respond to Ajax request');
    }
  }
}
// Ext.Ajax.on('requestexception',Lino.ajax_error_handler)
 


Ext.QuickTips.init();

/* setting QuickTips dismissDelay to 0 */
// Apply a set of config properties to the singleton
//~ Ext.apply(Ext.QuickTips.getQuickTip(), {
//~ Ext.apply(Ext.ToolTip, {
    //~ dismissDelay: 0
    //~ autoHide: false,
    //~ closable: true,
    //~ maxWidth: 200,
    //~ minWidth: 100,
    //~ showDelay: 50      // Show 50ms after entering target
    //~ ,trackMouse: true
//~ });


//~ Ext.apply(Ext.QuickTip, {
    //~ dismissDelay: 0,
//~ });
  
Lino.quicktip_renderer = function(title,body) {
  return function(c) {
    //~ if (c instanceof Ext.Panel) var t = c.bwrap; else // 20130129
    if (c instanceof Ext.Panel) var t = c.header; else // 20130129
    var t = c.getEl();
    //~ console.log(20130129,t,title,body);
    //~ t.dismissDelay = 0;
    Ext.QuickTips.register({
      target: t,
      //~ cls: 'lino-quicktip-classical',
      dismissDelay: 0,
      //~ autoHide: false,
      showDelay: 50,      // Show 50ms after entering target
      //~ title: title,
      text: body
    });
  }
};


  
Lino.help_text_editor = function() {
  //~ var bp = {
      //~ mk:this.content_type,
      //~ mt:1
    //~ };
    //~ console.log(20120202,bp);
  //~ Lino.lino.ContentTypes.detail({},{base_params:bp});
  //~ Lino.lino.ContentTypes.detail.run(null,{record_id:this.content_type});
  Lino.lino.ContentTypes.detail.run(null,{record_id:this.content_type});
}

// Path to the blank image should point to a valid location on your server
//~ Ext.BLANK_IMAGE_URL = MEDIA_URL + '/extjs/resources/images/default/s.gif'; 


// used as Ext.grid.Column.renderer for id columns in order to hide the special id value -99999
Lino.id_renderer = function(value, metaData, record, rowIndex, colIndex, store) {
  //~ if (record.phantom) return '';
  return value;
}

Lino.raw_renderer = function(value, metaData, record, rowIndex, colIndex, store) {
  return value;
}

Lino.text_renderer = function(value, metaData, record, rowIndex, colIndex, store) {
  //~ return "not implemented"; 
  return value;
}

Lino.NullNumberColumn = Ext.extend(Ext.grid.Column, {
    align : 'right', 
    format : '0,00/i', 
    renderer : function(value, metaData, record, rowIndex, colIndex, store) {
        //~ console.log(20130128,"NullNumberColumn.renderer",value);
        if (value === null) return '';
        return Ext.util.Format.number(value, this.format);
    }
});

//~ Lino.NullNumberColumn = Ext.extend(Ext.grid.NumberColumn, {
    //~ align : 'right', 
    //~ constructor: function(cfg){
        //~ Ext.grid.NumberColumn.superclass.constructor.call(this, cfg);
        //~ var t = this;
        //~ this.renderer = function(value, metaData, record, rowIndex, colIndex, store) {
          //~ console.log(20130128,"NullNumberColumn.renderer",value);
          //~ if (value === null) return '';
          //~ return Ext.util.Format.number(value, t.format);
      //~ };
    //~ }
//~ });




//~ Lino.cell_button_renderer = function(value, metaData, record, rowIndex, colIndex, store) {
  //~ return '<input type="button" onclick="alert(value)" value=" ? ">' ;
//~ }


//~ Lino.default_renderer = function(value, metaData, record, rowIndex, colIndex, store) {
  //~ if (record.phantom) return '';
  //~ return value;
//~ }

Lino.fk_renderer = function(fkname,handlername) {
  //~ console.log('Lino.fk_renderer handler=',handler);
  return function(value, metaData, record, rowIndex, colIndex, store) {
    //~ console.log('Lino.fk_renderer',fkname,rowIndex,colIndex,record,metaData,store);
    //~ if (record.phantom) return '';
    if (value) {
        var s = '<a href="javascript:' ;
        s += handlername + '.run(null,{record_id:\'' + String(record.data[fkname]) + '\'})">';
        s += value + '</a>';
        //~ console.log('Lino.fk_renderer',value,'-->',s);
        return s
    }
    return '';
  }
};

Lino.lfk_renderer = function(panel,fkname) {
  //~ console.log('Lino.fk_renderer handler=',handler);
  var handlername = 'console.log';
  return function(value, metaData, record, rowIndex, colIndex, store) {
    //~ console.log('Lino.fk_renderer',fkname,rowIndex,colIndex,record,metaData,store);
    if (record.phantom) return '';
    if (value) {
        var s = '<a href="javascript:' ;
        s += handlername + '({},{record_id:\'' + String(record.data[fkname]) + '\'})">';
        s += value + '</a>';
        //~ console.log('Lino.fk_renderer',value,'-->',s);
        return s
    }
    return '';
  }
};

//~ Lino.gfk_renderer = function() {
  //~ return function(value, metaData, record, rowIndex, colIndex, store) {
    //~ if (record.phantom) return '';
    //~ console.log('Lino.gfk_renderer',value,colIndex,record,metaData,store);
    //~ return value;
  //~ }
//~ };


Lino.build_buttons = function(panel,actions) {
  //~ console.log("20121006 Lino.build_buttons",actions);
  if (actions) {
    var buttons = Array(actions.length);
    var cmenu = Array(actions.length);
    for (var i=0; i < actions.length; i++) { 
      buttons[i] = new Ext.Toolbar.Button(actions[i]);
      cmenu[i] = actions[i]
      cmenu[i].text = actions[i].menu_item_text;
      if (actions[i].panel_btn_handler) {
          var h = actions[i].panel_btn_handler.createCallback(panel,buttons[i]);
          //~ if (actions[i].must_save) {
          if (actions[i].auto_save == true) {
              buttons[i].on('click',panel.do_when_clean.createDelegate(panel,[true,h]));
          } else if (actions[i].auto_save == null) {
              buttons[i].on('click',panel.do_when_clean.createDelegate(panel,[false,h]));
          } else if (actions[i].auto_save == false) {
              buttons[i].on('click',h);
          } else {
              console.log("20120703 unhandled auto_save value",actions[i])
          }
          cmenu[i].handler = actions[i].panel_btn_handler.createCallback(panel,cmenu[i]);
      }
    }
    return {bbar:buttons, cmenu:new Ext.menu.Menu(cmenu)};
  }
}

Lino.do_when_visible = function(cmp,todo) {
  //~ if (cmp.el && cmp.el.dom) 
  if (cmp.isVisible()) { 
    // 'visible' means 'rendered and not hidden'
    //~ console.log(cmp.title,'-> cmp is visible now');
    todo(); 
  //~ } else {
      //~ cmp.on('resize',todo,cmp,{single:true});
  //~ }
  //~ if (false) { // 20120213
  } else { 
    //~ console.log('Lino.do_when_visible() must defer because not isVisible()',todo,cmp);
    if (cmp.rendered) {
      //~ console.log(cmp,'-> cmp is rendered but not visible: and now?');
      //~ console.log(cmp.title,'-> cmp is rendered but not visible: try again in a moment...');
      //~ var fn = function() {Lino.do_when_visible(cmp,todo)};
      //~ fn.defer(100);
      
      Lino.do_when_visible.defer(50,this,[cmp,todo]);
      //~ Lino.do_when_visible.defer(100,this,[cmp,todo]);
      
    } else {
      //~ console.log(cmp.title,'-> after render');
      cmp.on('afterrender',todo,cmp,{single:true});
    }
  }
  
};    

/*
*/
Lino.do_on_current_record = function(panel,fn,phantom_fn) {
  var rec = panel.get_current_record();
  if (rec == undefined) {
    Lino.notify("There's no selected record.");
    return;
  }
  // 20120307 A VirtualTable with a Detail (lino.Models) has only "phantom" records.
  if (rec.phantom) {
    //~ if (!panel.editable) { console.log("20120312 not editable:",panel)}
    if (phantom_fn) {
      phantom_fn(panel);
    } else {
      Lino.notify("Aktion nicht verfügbar auf dem Phantom-Record.");
    }
    return;
  }
  return fn(rec);
};






Lino.call_ajax_action = function(panel,method,url,p,actionName,step,on_confirm,on_success) {
  p.an = actionName;
  if (!panel) panel = Lino.viewport;
  Ext.apply(p,panel.get_base_params());
  //~ console.log("20121212 Lino.call_ajax_action",panel);
  panel.loadMask.show(); 
  //~ p.$ext_requests.URL_PARAM_SUBST_USER = Lino.subst_user;
  //~ Lino.insert_subst_user(p);
    
  //~ if (step) p['$ext_requests.URL_PARAM_ACTION_STEP'] = step;
  //~ if (pp) pp(p); // "parameter processor" : first used for read beid card
  Ext.Ajax.request({
    method: method,
    url: url,
    params: p,
    success: Lino.action_handler(panel,on_success,on_confirm)
  });
};

Lino.row_action_handler = function(actionName,hm,pp) {
  var p = {};
  var fn = function(panel,btn,step) {
      if (pp) { p = pp(); if (! p) return; }
      Lino.do_on_current_record(panel,function(rec) {
          //~ console.log(panel);
          //~ 20120723 Lino.call_ajax_action(panel,rec.id,actionName,step,fn);
          Lino.call_ajax_action(panel,hm,panel.get_record_url(rec.id),p,actionName,step,fn);
      });
  };
  return fn;
};

Lino.list_action_handler = function(ls_url,actionName,hm,pp) {
  var p = {};
  var url = '/api' + ls_url
  var fn = function(panel,btn,step) {
      //~ console.log("20121210 Lino.list_action_handler",arguments);
      //~ var url = ADMIN_URL + '/api' + panel.ls_url
      if (pp) { p = pp();  if (! p) return; }
      Lino.call_ajax_action(panel,hm,url,p,actionName,step,fn);
  };
  return fn;
};

Lino.param_action_handler = function(window_action) { // 20121012
  var fn = function(panel,btn,step) {
    Lino.do_on_current_record(panel,function(rec) {
      //~ console.log(panel);
      //~ 20120723 Lino.call_ajax_action(panel,rec.id,actionName,step,fn);
      window_action.run(panel.getId(),{}); 
    });
  };
  return fn;
};


Lino.run_row_action = function(requesting_panel,url,pk,actionName,pp) {
  //~ var panel = action.get_window().main_item;
  url = '/api' + url  + '/' + pk;
  var panel = Ext.getCmp(requesting_panel);
  if (pp) var p = pp(); else var p = {};
  var fn = function(panel,btn,step) {
    //~ 20120723 Lino.call_ajax_action(panel,pk,actionName,step,fn);
    Lino.call_ajax_action(panel,'GET',url,p,actionName,step,fn);
  }
  fn(panel,null,null);
}



Lino.show_detail = function(panel,btn) {
  Lino.do_on_current_record(panel, 
    function(rec) {
      //~ panel.loadMask.show();
      var bp = panel.get_base_params();
      //~ var bp = {};
      panel.add_param_values(bp); // 20120918
      var status = {
        record_id:rec.id,
        base_params:bp
        //~ param_values: pv.$ext_requests.URL_PARAM_PARAM_VALUES
      }
      //~ console.log("20120918 Lino.show_detail",status);
      panel.ls_detail_handler.run(null,status);
      //~ panel.loadMask.hide();
      //~ panel.containing_window.window.hideMask();
      //~ panel.el.unmask();
    },
    Lino.show_insert
  );
};

Lino.show_fk_detail = function(combo,detail_action) {
    //~ console.log("Lino.show_fk_detail",combo,handler);
    pk = combo.getValue();
    if (pk) {
        detail_action.run(null,{record_id: pk})
      } else {
        Lino.notify("Cannot show detail for empty foreign key.");
      }
};

Lino.show_insert = function(panel,btn) {
  var bp = panel.get_base_params();
  //~ console.log('20120125 Lino.show_insert',bp)
  //~ panel.ls_insert_handler.run(null,{record_id:-99999,base_params:bp});
  panel.ls_insert_handler.run(panel.getId(),{record_id:-99999,base_params:bp});
};

Lino.show_insert_duplicate = function(panel,btn) {
  Lino.do_on_current_record(panel,
    function(rec) {
      var newRec = {};
      Ext.apply(newRec,rec);
      newRec.id = -99999;
      panel.ls_insert_handler.run(null,{data_record:rec});
    });
};

//~ Lino.update_row_handler = function(action_name) {
  //~ return function(panel,btn) {
    //~ Lino.notify("Sorry, " + action_name + " is not implemented.");
  //~ }
//~ };




if (Ext.ux.grid !== undefined) {
    Lino.GridFilters = Ext.extend(Ext.ux.grid.GridFilters,{
      encode:true,
      local:false
    });
} else {
    Lino.GridFilters = function() {}; // dummy
    Ext.override(Lino.GridFilters,{
      init : function() {}
    });
};



//~ Lino.ButtonField = Ext.extend(Ext.form.TextField,{
//~ Lino.ButtonField = Ext.extend(Ext.form.Field,{
    //~ editable : false,
    //~ constructor : function(ww,config,params){
      //~ this.containing_window = ww;
      //~ if (params) Ext.apply(config,params);
      //~ Lino.ButtonField.superclass.constructor.call(this, config);
    //~ },
    //~ setButtons : function(buttons){
      //~ console.log('setButtons',buttons);
    //~ },
    //~ onRender : function(ct, position){
        //~ if(!this.el){
            //~ this.panel = new Ext.Container({items:[
              //~ {xtype:'button',text:'upload'},
              //~ {xtype:'button',text:'show'},
              //~ {xtype:'button',text:'edit'}
            //~ ]});
            //~ this.panel.ownerCt = this;
            //~ this.el = this.panel.getEl();

        //~ }
        //~ Lino.ButtonField.superclass.onRender.call(this, ct, position);
    //~ },

  
//~ });

Lino.FieldBoxMixin = {
  before_init : function(config,params) {
    if (params) Ext.apply(config,params);
    var actions = Lino.build_buttons(this,config.ls_bbar_actions);
    if (actions) config.bbar = actions.bbar;
  },
  //~ constructor : function(ww,config,params){
    //~ this.containing_window = ww;
    //~ if (params) Ext.apply(config,params);
    //~ var actions = Lino.build_buttons(this,config.ls_bbar_actions);
    //~ if (actions) config.bbar = actions.bbar;
    //~ Lino.FieldBoxMixin.superclass.constructor.call(this, config);
  //~ },
  do_when_clean : function(auto_save,todo) { todo() },
  //~ format_data : function(html) { return '<div class="htmlText">' + html + '</div>' },
  format_data : function(html) { return html },
  get_base_params : function() {
    // needed for insert action
    var p = Ext.apply({},this.base_params);
    Lino.insert_subst_user(p);
    return p;
  },
  set_base_params : function(p) {
    this.base_params = Ext.apply({},p);
    //~ if (p.param_values) this.set_param_values(p.param_values);  
  },
  clear_base_params : function() {
      this.base_params = {};
      Lino.insert_subst_user(this.base_params);
  },
  set_base_param : function(k,v) {
    this.base_params[k] = v;
  }
};



Lino.HtmlBoxPanel = Ext.extend(Ext.Panel,Lino.PanelMixin);
Lino.HtmlBoxPanel = Ext.extend(Lino.HtmlBoxPanel,Lino.FieldBoxMixin);
Lino.HtmlBoxPanel = Ext.extend(Lino.HtmlBoxPanel,{
  disabled_in_insert_window : true,
  constructor : function(config,params) {
    this.before_init(config,params);
    Lino.HtmlBoxPanel.superclass.constructor.call(this, config);
  },
  //~ constructor : function(ww,config,params){
    //~ this.ww = ww;
    //~ if (params) Ext.apply(config,params);
    //~ var actions = Lino.build_buttons(this,config.ls_bbar_actions);
    //~ if (actions) config.bbar = actions.bbar;
    //~ Lino.FieldBoxMixin.constructor.call(this, ww,config,params);
  //~ },
  //~ constructor : function(ww,config,params){
    //~ this.ww = ww;
    //~ if (params) Ext.apply(config,params);
    //~ var actions = Lino.build_buttons(this,config.ls_bbar_actions);
    //~ if (actions) config.bbar = actions.bbar;
    //~ Lino.FieldBoxMixin.superclass.constructor.call(this, config);
  //~ },
  //~ disable : function() { var tb = this.getBottomToolbar(); if(tb) tb.disable()},
  //~ enable : function() { var tb = this.getBottomToolbar(); if(tb) tb.enable()},
  onRender : function(ct, position){
    Lino.HtmlBoxPanel.superclass.onRender.call(this, ct, position);
    //~ console.log(20111125,this.containing_window);
    if (this.containing_panel) {
      this.containing_panel.on('enable',this.enable,this);
      this.containing_panel.on('disable',this.disable,this);
    }
    this.el.on({
      dragenter:function(event){
        event.browserEvent.dataTransfer.dropEffect = 'move';
        return true;
      }
      ,dragover:function(event){
        event.browserEvent.dataTransfer.dropEffect = 'move';
        event.stopEvent();
        return true;
      }
      ,drop:{
        scope:this
        ,fn:function(event){
          event.stopEvent();
          //~ console.log(20110516);
          var files = event.browserEvent.dataTransfer.files;
          if(files === undefined){
            return true;
          }
          var len = files.length;
          while(--len >= 0){
            console.log(files[len]);
            //~ this.processDragAndDropFileUpload(files[len]);
          }
          Lino.show_insert(this);
        }
      }
    });
  },
  refresh : function(unused) { 
      this.refresh_with_after();
  },
  refresh_with_after : function(after) {
    //~ if (this.master_panel) {
      var record = this.containing_panel.get_current_record();
      //~ console.log('HtmlBox.refresh()',this.title,record,record.title);
      var box = this.items.get(0);
      var todo = function() {
        if (this.disabled) return;
        //~ this.set_base_params(this.containing_window.get_base_params());
        this.set_base_params(this.containing_panel.get_master_params());
        var el = box.getEl();
        if (el) {
          el.update(record ? this.format_data(record.data[this.name]) : '');
          //~ console.log('HtmlBox.refresh()',this.name);
        //~ } else {
          //~ console.log('HtmlBox.refresh() failed for',this.name);
        }
      };
      Lino.do_when_visible(box,todo.createDelegate(this));
    //~ }
  }
});
//~ Ext.override(Lino.HtmlBoxPanel,Lino.FieldBoxMixin);



Lino.RichTextPanel = Ext.extend(Ext.Panel,Lino.PanelMixin);
Lino.RichTextPanel = Ext.extend(Lino.RichTextPanel,Lino.FieldBoxMixin);
Lino.RichTextPanel = Ext.extend(Lino.RichTextPanel,{
    
  //~ initComponent : function(){
    //~ Lino.RichTextPanel.superclass.initComponent.call(this);
  //~ },
  constructor : function(config,params) {
    //~ console.log('Lino.RichTextPanel.initComponent',this);
    //~ var url = TEMPLATES_URL + config.ls_url + "/" + String(rec.id) + "/" + config.name;
    //~ var url = TEMPLATES_URL + config.ls_url + "/" + config.name;
    var t = this;
    var tinymce_options = {
        theme : "advanced",
        content_css: '/media/lino/extjs/lino.css',
        language: 'de',
        //~ template_external_list_url : url,
        theme_advanced_toolbar_location : "top",
        theme_advanced_toolbar_align : "left",
        theme_advanced_statusbar_location : "bottom",
        template_popup_width : 700,
        template_popup_height : 500,
        template_replace_values : { 
            data_field : function(element){ 
                //~ console.log(20110722,fieldName,t.containing_window.get_current_record()); 
                var fieldName = element.innerHTML;
                element.innerHTML = t.containing_panel.get_current_record().data[fieldName];
            } 
        }
      };
      
    var editorConfig = {
      tinymceSettings: {
        plugins : "noneditable,template", 
        // Theme options - button# indicated the row# only
        theme_advanced_buttons1 : "bold,italic,underline,|,justifyleft,justifycenter,justifyright,|,bullist,numlist,|,outdent,indent,|,undo,redo,|,removeformat,template",
        theme_advanced_buttons2 : "",
        theme_advanced_buttons3 : "", // ,|,sub,sup,|,charmap",      
        theme_advanced_resizing : false
        //~ save_onsavecallback : save_callback,
        //~ save_enablewhendirty : true
        //~ save_oncancelcallback: on_cancel
        
    }};
    Ext.apply(editorConfig.tinymceSettings,tinymce_options);
    //~ editorConfig.name = config.action_name;
    editorConfig.name = config.name;
    delete config.name;
    //~ config.title = config.label;
    //~ delete config.label;
    this.before_init(config,params);
    
    this.editor = new Ext.ux.TinyMCE(editorConfig);
    var t = this;
    config.tools = [{
                      qtip: "Edit text in own window", 
                      id: "up",
                      handler: function(){
                        if(t.editor.isDirty()) {
                            var record = t.containing_panel.get_current_record();
                            record.data[t.editor.name] = t.editor.getValue();
                        }
                        Lino.edit_tinymce_text(t,tinymce_options)
                      }
                    }];
    
    config.items = this.editor;
    config.layout = "fit";
    Lino.RichTextPanel.superclass.constructor.call(this, config);
  },
  refresh : function(unused) { 
      this.refresh_with_after();
  },
  refresh_with_after : function(after) {
    var record = this.containing_panel.get_current_record();
    //~ console.log('RichTextPanel.refresh()',this.title,record.title,record);
    var todo = function() {
      //~ this.set_base_params(this.containing_window.get_base_params());
      if (record) {
        var url = '/templates' + this.containing_panel.ls_url + "/" 
            + String(record.id) + "/" + this.editor.name;
        //~ console.log('RichTextPanel.refresh()',url);
        if (this.editor.ed) this.editor.ed.settings.template_external_list_url = url;
        this.set_base_params(this.containing_panel.get_master_params());
        //~ var v = record ? this.format_data(record.data[this.editor.name]) : ''
        var v = this.format_data(record.data[this.editor.name])
        this.editor.setValue(v);
      } else {
        this.editor.setValue('(no data)');
      }
    };
    Lino.do_when_visible(this,todo.createDelegate(this));
  }
});
//~ Ext.override(Lino.RichTextPanel,Lino.FieldBoxMixin);



Lino.ActionFormPanel = Ext.extend(Ext.form.FormPanel,Lino.MainPanel);
Lino.ActionFormPanel = Ext.extend(Lino.ActionFormPanel,Lino.PanelMixin);
Lino.ActionFormPanel = Ext.extend(Lino.ActionFormPanel,Lino.FieldBoxMixin);
Lino.ActionFormPanel = Ext.extend(Lino.ActionFormPanel,{
  //~ layout:'fit'
  //~ ,autoHeight: true
  //~ ,frame: true
  window_title: "Action Parameters",
  constructor : function(config){
    config.bbar = [
        {text:'OK',handler:this.on_ok,scope:this},
        {text:'Cancel',handler:this.on_cancel,scope:this}
    ];
    //~ config.items = config.params_panel;
    Lino.ActionFormPanel.superclass.constructor.call(this, config);
  }
  //~ ,initComponent : function(){
    //~ Lino.ActionFormPanel.superclass.initComponent.call(this);
  //~ }
  ,on_cancel : function() { 
    this.get_containing_window().close();
  }
  ,on_ok : function() { 
    //~ var rp = this.requesting_panel;
    //~ console.log("on_ok",this.requesting_panel,arguments);
    //~ Lino.row_action_handler()
    var panel = this.requesting_panel;
    var actionName = this.action_name;
    var rec = panel.get_current_record();
    var self = this;
    function on_success() { self.get_containing_window().close(); };
    var fn = function(panel,btn,step) {
      var p = {};
      self.add_field_values(p)
      Lino.call_ajax_action(panel,'GET',panel.get_record_url(rec.id),p,actionName,step,fn,on_success);
    }
    fn(panel,null,null);
    
    
  }
  ,set_status : function(status,rp){
    this.requesting_panel = Ext.getCmp(rp);
    //~ console.log('20120918 ActionFormPanel.set_status()',status,rp,this.requesting_panel);
    this.clear_base_params();
    if (status == undefined) status = {};
    //~ if (status.param_values) 
    this.set_field_values(status.field_values);
    if (status.base_params) this.set_base_params(status.base_params);
  }
  
  ,add_field_values : function (p) { // similar to add_param_values()
      //~ 20121023 
      if (this.form.isDirty()) {
        p.fv = this.get_field_values();
      }else{
        if (this.status_field_values) 
          p.fv = Lino.fields2array(this.fields,this.status_field_values);
      }
      //~ if (!this.form.isDirty()) return;
      //~ p.$ext_requests.URL_PARAM_FIELD_VALUES = this.get_field_values();
      //~ console.log("20120203 add_param_values added pv",pv,"to",p);
  }
  ,get_field_values : function() {
      return Lino.fields2array(this.fields);
  }
  ,set_field_values : function(pv) {
      //~ console.log('20120203 MainPanel.set_param_values', pv);
      this.status_field_values = pv;
      if (pv) this.form.my_loadRecord(pv);
      else this.form.reset(); 
  }
  ,config_containing_window : function(wincfg) { 
      wincfg.title = this.window_title;
      wincfg.keys = [
        { key: Ext.EventObject.ENTER, fn: this.on_ok }
      ]
  }
});

//~ Lino.add_blank = function(oa) {
    //~ return [].concat(oa)
    //~ return 
    //~ }
    
Lino.fields2array = function(fields,values) {
    //~ console.log('20130605 fields2array gonna loop on', fields,values);
    var pv = Array(fields.length);
    for(var i=0; i < fields.length;i++) {
        var f = fields[i]
        if (values) 
          var v = values[f.name];
        else 
          var v = f.getValue();
        if (f.formatDate) {
            pv[i] = f.formatDate(v); 
        } else {
            pv[i] = v; // f.getValue(); 
        }
    }
    return pv;
}


Lino.FormPanel = Ext.extend(Ext.form.FormPanel,Lino.MainPanel);
Lino.FormPanel = Ext.extend(Lino.FormPanel,Lino.PanelMixin);
Lino.FormPanel = Ext.extend(Lino.FormPanel,{
  params_panel_hidden : false,
  //~ base_params : {},
  //~ trackResetOnLoad : true,
  //~ query_params : {},
  //~ 20110119b quick_search_text : '',
  constructor : function(config,params){
    if (params) Ext.apply(config,params);
    this.base_params = {};
    //~ ww.config.base_params.query = ''; // 20111018
    //~ console.log(config);
    //~ console.log('FormPanel.constructor() 1',config)
    //~ Ext.applyIf(config,{base_params:{}});
    //~ console.log('FormPanel.constructor() 2',config)
      
    config.trackResetOnLoad = true;
    
    Lino.FormPanel.superclass.constructor.call(this, config);
      
    //~ this.set_base_param('$URL_PARAM_FILTER',null); // 20111018
    //~ this.set_base_param('$URL_PARAM_FILTER',''); // 20111018
      
  },
  initComponent : function(){
    
    //~ console.log("20111201 containing_window",this.containing_window,this);
    
    var actions = Lino.build_buttons(this,this.ls_bbar_actions);
    if (actions) {
        this.bbar = actions.bbar;
    //~ } else {
        //~ this.bbar = [];
    }
    //~ Ext.apply(config,Lino.build_buttons(this,config.ls_bbar_actions));
    //~ config.bbar = Lino.build_buttons(this,config.ls_bbar_actions);
    //~ var config = this;
    
    //~ if (this.containing_window instanceof Lino.DetailWrapper) {
    
    //~ console.log('20120121 initComponent', this.action_name);
    //~ if (this.action_name == 'detail' | this.action_name == 'show') {
    //~ if (this.action_name != 'insert') {
    if (! this.hide_top_toolbar) {
      this.tbar = [];
      // 20111015    
      if (! this.hide_navigator) {
        this.record_selector = new Lino.RemoteComboFieldElement({
          store: new Lino.ComplexRemoteComboStore({
            //~ baseParams: this.containing_window.config.base_params,
            baseParams: this.get_base_params(),
            //~ value: this.containing_window.config.base_params.query,
            proxy: new Ext.data.HttpProxy({
              url: '/choices' + this.ls_url,
              method:'GET'
            })
          }),
          pageSize:25,
          listeners: { 
            scope:this, 
            select:function(combo,record,index) {
              //~ console.log('jumpto_select',arguments);
              this.goto_record_id(record.id);
            }
          },
          emptyText: "Gehe zu Datensatz"
        })
        this.tbar = this.tbar.concat([this.record_selector]);
        
        this.tbar = this.tbar.concat([
          this.first = new Ext.Toolbar.Button({
            tooltip:"Erster",disabled:true,handler:this.moveFirst,scope:this,iconCls:'x-tbar-page-first'}),
          this.prev = new Ext.Toolbar.Button({
            tooltip:"Voriger",disabled:true,handler:this.movePrev,scope:this,iconCls:'x-tbar-page-prev'}),
          this.next = new Ext.Toolbar.Button({
            tooltip:"Nächster",disabled:true,handler:this.moveNext,scope:this,iconCls:'x-tbar-page-next'}),
          this.last = new Ext.Toolbar.Button({
            tooltip:"Letzter",disabled:true,handler:this.moveLast,scope:this,iconCls:'x-tbar-page-last'})
        ]);
      }
      this.tbar = this.add_params_panel(this.tbar);
      
      //~ console.log(20101117,this.containing_window.refresh);
      this.tbar = this.tbar.concat([
        {
          //~ text:'Refresh',
          handler:function(){ this.do_when_clean(true,this.refresh.createDelegate(this)) },
          iconCls: 'x-tbar-loading',
          tooltip:"Datensatz neu laden",
          scope:this}
      ]);
          
      if (this.bbar) { // since 20121016
        if (this.tbar) {
            this.tbar = this.tbar.concat(['-']) ;
        } else {
          this.tbar = [];
        }
        this.tbar = this.tbar.concat(this.bbar) ;
        this.bbar = undefined;
      }
    
      this.tbar = this.tbar.concat([
          '->',
          this.displayItem = new Ext.Toolbar.TextItem({})
      ]);
          
    }
    //~ if (this.content_type && this.action_name != 'insert') {
      //~ this.bbar = this.bbar.concat([
        //~ '->',
        //~ { text: "[$_('Help Text Editor')]",
          //~ handler: Lino.help_text_editor,
          //~ qtip: "$_('Edit help texts for fields on this model.')",
          //~ scope: this}
      //~ ])
    //~ }
    //~ this.before_row_edit = config.before_row_edit.createDelegate(this);
      
    //~ if (this.master_panel) {
        //~ this.set_base_params(this.master_panel.get_master_params());
    //~ }
      
    Lino.FormPanel.superclass.initComponent.call(this);
    
    this.on('render',function(){
      this.loadMask = new Ext.LoadMask(this.bwrap,{msg:"Bitte warten..."});
    },this);
    
    
    //~ var this_ = this;
    //~ this.cascade(function(cmp){
      //~ // var active_field = false;
      //~ for (i = 0; i < this_.active_fields.length; i++) {
        //~ if (cmp.name == this_.active_fields[i]) {
            //~ // active_field = true; break;
            //~ cmp.on("change",function() {this_.save()});
        //~ }
      //~ };
      //~ if (active_field) {
      // if (cmp instanceof Lino.GridPanel) {
          //~ cmp.on("change",function() {this_.save()});
      //~ }
    //~ });
    
    if (this.action_name == 'insert') {
      this.cascade(function(cmp){
        // console.log('20110613 cascade',cmp);
        if (cmp.disabled_in_insert_window) {
            //~ cmp.disable();
            cmp.hide();
        }
      });
      
    }
    
  },
  
  unused_is_loading : function() { 
    if (this.current_record == null) {
        //~ console.log("20130515 current_record is null");
        return true; 
    }
    
    if (! this.loadMask) return true; // not even rendered: 
    if (! this.loadMask.el) return true; // not even rendered: 
    // thanks to Marco Pegoraro http://movableapp.com/2011/09/sencha-touch-loadmask-isvisible/
    var loading = (this.loadMask.el.select('.x-loading-msg').elements.length > 0);
    //~ console.log('20130515 GridPanel.is_loading() returns',loading);
    return loading;

    
    var loading = false;
    this.cascade(function(cmp){
        if (cmp instanceof Lino.GridPanel && cmp.is_loading()) {
            //~ console.log(20130515, cmp.title,'is loading');
            loading = true;
            return false;
        }
      });
    return loading;
    //~ var a = this.findByType(Lino.GridPanel);
    //~ for (i=0;i<a.length;i++) {
        //~ if (a[i].is_loading()) return true;
    //~ }
    //~ return false;
  },
  
  get_status : function(){
      var st = {
        base_params: this.get_base_params(),
        data_record : this.get_current_record()
        }
      var tp = this.items.get(0);
      if (tp instanceof Ext.TabPanel) {
        st.active_tab = tp.getActiveTab();
      }
      st.param_values = this.status_param_values;
      return st;
  },
  /* FormPanel */
  set_status : function(status,rp){
    this.requesting_panel = Ext.getCmp(rp);
    //~ console.log('20120918 FormPanel.set_status()',status);
    this.clear_base_params();
    if (status == undefined) status = {};
    //~ if (status.param_values) 
    this.set_param_values(status.param_values);
    if (status.base_params) this.set_base_params(status.base_params);
    var tp = this.items.get(0);
    if (tp instanceof Ext.TabPanel) {
      if (status.active_tab) {
        //~ console.log('20111201 active_tab',this.active_tab,this.items.get(0));
        //~ tp.activeTab = status.active_tab;
        tp.setActiveTab(status.active_tab);
        //~ this.main_item.items.get(0).activate(status.active_tab);
      } else {
        tp.setActiveTab(0);
      }
      }
    
    if (status.data_record) {
      //~ console.log('20111201 Lino.FormPanel with data_record',this.data_record.title,this.containing_window);
      //~ this.main_item.on_master_changed.defer(2000,this.main_item,[status.data_record]);
      //~ Lino.do_when_visible(this.main_item,function(){this.on_master_changed(status.data_record)});
      //~ this.main_item.on('afterrender',function(){
      //~   this.main_item.on_master_changed(status.data_record)},this,{single:true});
      /* must defer because because set_window_title() didn't work otherwise */
      this.set_current_record.createDelegate(this,[status.data_record]).defer(100);
      //~ this.set_current_record(this.data_record);
      //~ return;
    } else if (status.record_id != undefined) { 
      /* possible values include 0 and null, 0 being a valid record id, 
      null the equivalent of undefined
      */
      //~ this.main_item.goto_record_id(this.status.record_id);
      this.load_record_id(status.record_id);
    } else {
      this.set_current_record(undefined);
    }
  },
    
  get_base_params : function() {
    // needed for insert_action
    var p = Ext.apply({},this.base_params);
    Lino.insert_subst_user(p);
    return p;
    //~ return this.base_params;
  },
  set_base_params : function(p) {
    //~ this.base_params = Ext.apply({},this.base_params); // make sure it is an instance variable
    delete p['query'] // 20120725
    Ext.apply(this.base_params,p);
    if (this.record_selector) {
        var store = this.record_selector.getStore();
        for (k in p) store.setBaseParam(k,p[k]);
        delete this.record_selector.lastQuery;
        //~ console.log("20120725 record_selector.setBaseParam",p)
    }
  },
  clear_base_params : function() {
      this.base_params = {};
      Lino.insert_subst_user(this.base_params);
        
      //~ if (this.record_selector) {
          //~ var store = this.record_selector.getStore();
          //~ for (k in store.baseParams) store.setBaseParam(k,undefined);
          //~ delete this.record_selector.lastQuery;
          //~ console.log("20120725 record_selector.getBaseParams() -->",store.baseParams)
      //~ }
  },
  set_base_param : function(k,v) {
    //~ this.base_params = Ext.apply({},this.base_params); // make sure it is an instance variable
    this.base_params[k] = v;
    //~ if (this.record_selector) {
        //~ this.record_selector.getStore().setBaseParam(k,v);
        //~ delete this.record_selector.lastQuery;
    //~ }
  },
  
  after_delete : function() {
    if (this.current_record.navinfo.next)
      this.moveNext();
    else if (this.current_record.navinfo.prev)
      this.movePrev();
    else 
      this.abandon();
  },
  moveFirst : function() {this.goto_record_id(this.current_record.navinfo.first)},
  movePrev : function() {this.goto_record_id(this.current_record.navinfo.prev)},
  moveNext : function() {this.goto_record_id(this.current_record.navinfo.next)},
  moveLast : function() {this.goto_record_id(this.current_record.navinfo.last)},
  
  
  refresh : function(unused) { 
      this.refresh_with_after();
  },
  refresh_with_after : function(after) { 
    //~ console.log('20120121 Lino.FormPanel.refresh()',this);
    if (this.current_record) {
        this.load_record_id(this.current_record.id,after);
    } else {
        this.set_current_record(undefined,after);
    }
  },
  
  do_when_clean : function(auto_save,todo) {
    var this_ = this;
    if (this.form.isDirty()) {
        if (auto_save) {
            this_.save(todo);
        } else {
          //~ console.log('20111217 do_when_clean() form is dirty',this.form);
          var config = {title:"Bestätigung"};
          config.buttons = Ext.MessageBox.YESNOCANCEL;
          config.msg = "Änderungen in diesem Datensatz speichern?";
          config.fn = function(buttonId,text,opt) {
            //~ console.log('do_when_clean',buttonId)
            if (buttonId == "yes") {
                //~ Lino.submit_detail(this_,undefined,todo);
                //~ this_.containing_window.save(todo);
                this_.save(todo);
            } else if (buttonId == "no") { 
              todo();
            }
          }
        }
        Ext.MessageBox.show(config);
    }else{
      //~ console.log('do_when_clean : now!')
      todo();
    }
  },
  
  goto_record_id : function(record_id) {
    //~ console.log('20110701 Lino.FormPanel.goto_record_id()',record_id);
    //~ var this_ = this;
    //~ this.do_when_clean(function() { this_.load_record_id(record_id) }
    this.do_when_clean(true,this.load_record_id.createDelegate(this,[record_id]));
  },
  
  load_record_id : function(record_id,after) {
    var this_ = this;
    //~ var p = { fmt: this.containing_window.config.action_name};
    //~ var p = Ext.apply({},this.containing_window.config.base_params);
    var p = Ext.apply({},this.get_base_params());
    //~ Lino.insert_subst_user(p);
    //~ console.log('20110713 action_name=',this.containing_window.config.action_name,
      //~ 'base_params=',this.containing_window.config.base_params);
    if (this.action_name)
        p.an = this.action_name;
    //~ p.an = this.action_name;
    //~ p.an = this.containing_window.config.action_name;
    //~ p.fmt = 'json';
    //~ p.fmt = '$ext_requests.URL_FORMAT_JSON';
    p.rp = this.getId();
    //~ p.$ext_requests.URL_PARAM_SUBST_USER = Lino.subst_user;
    p.fmt = 'json';
    //~ 20110119b p['$URL_PARAM_FILTER'] = this.quick_search_text;
    //~ Ext.apply(p,this.query_params);
    this.add_param_values(p);
    //~ console.log('20121120 FormPanel.load_record_id',record_id,p);
    if (this.loadMask) this.loadMask.show();
    Ext.Ajax.request({ 
      waitMsg: 'Loading record...',
      method: 'GET',
      params: p,
      scope: this,
      url: this.get_record_url(record_id),
      success: function(response) {   
        // todo: convert to Lino.action_handler.... but result 
        if (this.loadMask) this.loadMask.hide();
        if (response.responseText) {
          var rec = Ext.decode(response.responseText);
          //~ console.log('20120918 goto_record_id success',rec);
          this.set_param_values(rec.param_values);
          this.set_current_record(rec,after);
        }
      },
      failure: Lino.ajax_error_handler(this)
    });
  },

  abandon : function () {
    Ext.MessageBox.alert('Note',
      "Keine weiteren Datensätze zu sehen. Detail-Fenster wird geschlossen.");
    Lino.close_window();
    //~ if (this.containing_window) {
        //~ this.containing_window.hide();
    //~ }
  },
  
  set_current_record : function(record,after) {
    //~ console.log('20120722 Lino.FormPanel.set_current_record',record.title,record);
    if (this.record_selector) {
        this.record_selector.clearValue();
        // e.g. InsertWrapper FormPanel doesn't have a record_selector
    }
    this.current_record = record;
    //~ if (record) 
        //~ console.log('Lino.FormPanel.set_current_record',record.title,record);
    //~ else
        //~ console.log('Lino.FormPanel.set_current_record',record);
    //~ this.config.main_panel.form.load(record);    
    if (record) {
      this.enable();
      this.form.my_loadRecord(record.data);
      this.set_window_title(record.title);
      //~ this.getBottomToolbar().enable();
      var da = record.data.disabled_actions;
      if (da) {
          //~ console.log('20120528 disabled_actions =',da,this.getBottomToolbar());
          //~ 20121016 this.getBottomToolbar().items.each(function(item,index,length){
          var tb = this.getTopToolbar();
          if (tb) tb.items.each(function(item,index,length){
              //~ console.log('20120528 ',item.itemId,'-->',da[item.itemId]);
              if (da[item.itemId]) item.disable(); else item.enable();
          });
      };
      if (this.disable_editing | record.data.disable_editing) {
          //~ console.log("20120202 disable_editing",record.title);
          this.form.items.each(function(cmp){
            if (!cmp.always_enabled) cmp.disable();
          },this);
      } else {
          this.form.items.each(function(cmp){
            //~ console.log("20120202",cmp);
            if (record.data.disabled_fields[cmp.name]) cmp.disable();
            else cmp.enable();
          },this);
        
          //~ if (record.data.disabled_fields) {
              //~ for (i = 0; i < record.data.disabled_fields.length; i++) {
                  //~ var flds = this.find('name',record.data.disabled_fields[i]);
                  //~ if (flds.length == 1) { 
                    //~ flds[0].disable(); 
                  //~ }
              //~ }
          //~ }
      };
      
      if (record.navinfo && ! this.hide_top_toolbar && ! this.hide_navigator) {
        this.first.setDisabled(!record.navinfo.first);
        this.prev.setDisabled(!record.navinfo.prev);
        this.next.setDisabled(!record.navinfo.next);
        this.last.setDisabled(!record.navinfo.last);
        this.displayItem.setText(record.navinfo.message);
      } else {
        this.first.setDisabled(true);
        this.prev.setDisabled(true);
        this.next.setDisabled(true);
        this.last.setDisabled(true);
      }
    } else {
      if (this.form.rendered) 
        this.form.reset(); /* FileUploadField would fail when resetting a non-rendered form */
      //~ this.disable();
      //~ this.getBottomToolbar().disable();
      this.form.items.each(function(cmp){
        cmp.disable();
      },this);
      this.set_window_title(this.empty_title);
      //~ this.containing_window.window.setTitle(this.empty_title);
      if (!this.hide_navigator) {
        this.first.disable();
        this.prev.disable();
        this.next.disable();
        this.last.disable();
      }
    }
    //~ console.log('20100531 Lino.DetailMixin.on_load_master_record',this.main_form);
    this.before_row_edit(record);
    if (after) after();
  },
  
  before_row_edit : function(record) {},
  search_change : function(field,oldValue,newValue) {
    //~ console.log('search_change',field.getValue(),oldValue,newValue)
    this.set_base_param('query',field.getValue()); 
    this.refresh();
  },
  
  get_selected : function() { return [ this.current_record ] },
  get_current_record : function() {  
    //~ console.log(20100714,this.current_record);
    return this.current_record 
  },
  
  get_permalink_url : function() {
      var rec = this.get_current_record();
      if (rec && ! rec.phantom && rec.id != -99998)
          return '/api' + this.ls_url + '/' + rec.id;
      return '/api' + this.ls_url;
    
  },
  get_permalink_params : function() {
    var p = {};
    //~ var p = {an:'detail'};
    if (this.action_name)
        p.an = this.action_name;
    //~ var p = {an:this.action_name};
    var main = this.items.get(0);
    if (main.activeTab) {
      var tab = main.items.indexOf(main.activeTab);
      //~ console.log('main.activeTab',tab,main.activeTab);
      if (tab) p.tab = tab;
    }
    this.add_param_values(p)
    return p;
  },
  
  /* 
  Lino.FormPanel.save() 
  */
  save : function(after,switch_to_detail,action_name) {
    //~ var panel = this;
    //~ console.log('20121120 FormPanel.save');
    this.loadMask.show();
    var rec = this.get_current_record();
    if (this.has_file_upload) this.form.fileUpload = true;
    //~ console.log('FormPanel.save()',rec);
    if (!action_name) action_name = this.action_name;
    if (rec) {
      var p = {};
      Ext.apply(p,this.get_base_params());
      p.rp = this.getId();
      //~ if (this.action_name) 
          //~ p.$ext_requests.URL_PARAM_ACTION_NAME = this.action_name;
      p.an = action_name;
      if (rec.phantom) {
        //~ if (this.action_name != 'insert') 
            //~ console.log("Warning: phantom record, but action_name is",this.action_name)
        this.form.submit({
          url: '/api' + this.ls_url,
          method: 'POST',
          params: p, 
          scope: this,
          success: function(form, action) {
            this.loadMask.hide();
            Lino.notify(action.result.message);
            /***
            Close this window, but update the status of the 
            calling window.
            If the calling window is a detail on the same table,
            then it should skip to the new record. But only then.
            A successful response usually has a data_record,
            except if it is a fileupload form where some mysterious 
            decoding problems (20120209) force us to return a record_id 
            which will lead to an additional GET.
            ***/
            var url = this.ls_url;
            var ww = Lino.calling_window();
            if (ww && ww.window.main_item instanceof Lino.FormPanel 
                   && ww.window.main_item.ls_url == this.ls_url) {
                //~ console.log("20120217 case 1");
                ww.status.record_id = action.result.record_id;
                ww.status.data_record = action.result.data_record;
                Lino.close_window();
            } else if (this.ls_detail_handler && switch_to_detail) {
                //~ console.log("20120217 case 2");
                Lino.kill_current_window();
                this.ls_detail_handler.run(null,{
                    record_id:action.result.record_id,
                    data_record: action.result.data_record,
                    base_params:this.get_base_params()
                });
            } else {
                //~ console.log("20120217 case 3");
                Lino.close_window();
            }
            //~ Lino.close_window(function(ww){
                //~ if (ww.window.main_item instanceof Lino.FormPanel 
                    //~ && ww.window.main_item.ls_url == url) {
                  //~ ww.status.record_id = action.result.record_id,
                  //~ ww.status.data_record = action.result.data_record
                //~ }
            //~ });
          },
          failure: function(form,action) { 
            this.loadMask.hide();
            Lino.on_submit_failure(form,action);
          },
          clientValidation: true
        })
      } else {
        //~ if (this.action_name != 'detail') 
            //~ console.log("Warning: non-phantom record, but action_name is",this.action_name)
        this.form.submit({
          url: '/api' + this.ls_url + '/' + rec.id,
          method: 'PUT',
          //~ headers: { 'HTTP_X_REQUESTED_WITH' : 'XMLHttpRequest'},
          scope: this,
          params: p, 
          success: function(form, action) {
            //~ panel.form.setValues(rec.data);
            //~ 20110701 panel.form.my_loadRecord(rec);
            this.loadMask.hide();
            Lino.notify(action.result.message);
            if (action.result.data_record)
                this.set_current_record(action.result.data_record,after);
            else
                console.log("Warning: no data_record in response to FormPanel.PUT")
            //~ this.refresh_with_after(after);
            //~ if (after) after(); else panel.refresh();
          },
          failure: function(form,action) { 
            this.loadMask.hide();
            Lino.on_submit_failure(form,action)},
          clientValidation: true
        })
      }
    } else Lino.notify("Sorry, no current record.");
  }
  
  ,on_cancel : function() { 
    this.get_containing_window().close();
  }
  ,on_ok : function() { 
      this.save(null,true);
      //~ var rec = this.get_current_record();
      //~ if (rec && rec.phantom)
          //~ this.do_when_clean(true,function() { Lino.close_window(); });
  }
  ,config_containing_window : function(wincfg) { 
      wincfg.keys = [
        { key: Ext.EventObject.ENTER, fn: this.on_ok, scope:this }
        ,{ key: Ext.EventObject.ESCAPE, fn: this.on_cancel, scope:this }
      ]
  }
  
  
  /* not used (no longer possible without .dtl files)
  , edit_detail_config : function () {
    var active_tab = {};
    var main = this.items.get(0);
    if (main.getActiveTab !== undefined) {
      var tabitem = main.getActiveTab();
      Ext.apply(active_tab,{$ext_requests.URL_PARAM_TAB : main.items.indexOf(tabitem)});
    }
    var editor = new Ext.form.TextArea();
    var close = function() { win.close(); }
    var _this = this;
    var save = function() { 
      //~ console.log(20110609,arguments); 
      var params = {desc: editor.getValue()};
      Ext.apply(params,active_tab);
      var a = { 
        params: params, 
        method: 'PUT',
        url: ADMIN_URL + '/detail_config' + _this.ls_url,
        failure : Lino.ajax_error_handler(this),
        success: Lino.action_handler( _this, function(result) {
          //~ console.log('detail_config/save success',result);
          win.close();
          document.location = _this.get_permalink();
        })
      };
      //~ console.log('detail_config/save sent',a);
      _this.loadMask.show(); // 20120211
      Ext.Ajax.request(a);
    }
    var save_btn = new Ext.Button({text:'Save',handler:save,disabled:true});
    var win = new Ext.Window({title:'Detail Layout',
      items:editor, layout:'fit',
      width:500,height:500,
      bbar:[{text:'Cancel',handler:close},save_btn]});
    var a = { 
      params:active_tab, 
      method:'GET',
      url:ADMIN_URL+'/detail_config'+_this.ls_url,
      success : function(response) {
        if (response.responseText) {
          var result = Ext.decode(response.responseText);
          if (result.success) {
            editor.setValue(result.desc);
            save_btn.enable();
          }
        }
      }
    };
    Ext.Ajax.request(a);
    win.show();
  }
  */
});


Lino.getRowClass = function(record, rowIndex, rowParams, store) {
  if (record.phantom) {
    //~ console.log(20101009,record);
    //~ rowParams.bodyStyle = "color:red;background-color:blue";
    return 'lino-phantom-row';
    }
  //~ console.log('20101009 not a phantom:',record);
  return '';
}

//~ FOO = 0;



Lino.GridStore = Ext.extend(Ext.data.ArrayStore,{ 
  autoLoad: false
  ,load: function(options) {
    //~ foo.bar = baz; // 20120213
    if (!options) options = {};
    if (!options.params) options.params = {};
    options.params.fmt = 'json';
    options.params.rp = this.grid_panel.getId();
    Lino.insert_subst_user(options.params); // since 20121016
      
    if (this.grid_panel.hide_top_toolbar) {
        //~ console.log("20120206 GridStore.load() toolbar is hidden");
        options.params.start = 0;
        if (this.grid_panel.preview_limit) {
          options.params.limit = this.grid_panel.preview_limit;
        }
    } else {
        var ps = this.grid_panel.calculatePageSize();
        if (!ps) {
            //~ this.gridpanel.on('render',this.load())
          //~ console.log("20120814 GridStore.load() failed to calculate pagesize");
          return false;
            //~ params.$URL_PARAM_LIMIT = 1;
            //~ this.grid_panel.on('render',this.load.createDelegate(this,options))
            //~ return;
        } 
        options.params.limit = ps;
      
        //~ options.params.start = this.grid_panel.getTopToolbar().cursor;
        //~ if (this.grid_panel.getTopToolbar().pageSize !=  ps) {
          //~ console.log("20120206 abort load because toolbar says pagesize",
            //~ this.grid_panel.getTopToolbar().pageSize,
            //~ "while actual pagesize is",ps);
            //~ return;
        //~ }
        
        this.grid_panel.getTopToolbar().pageSize =  ps;
        if (options.params.start == undefined)
            options.params.start = this.grid_panel.getTopToolbar().cursor;
      
    }
      
    this.grid_panel.add_param_values(options.params,true);
    //~ Lino.insert_subst_user(options.params);
    //~ console.log("20120814 GridStore.load()",options.params,this.baseParams);
    //~ if (FOO > 0) {
        //~ foo.bar = baz;
    //~ } else FOO += 1;
    return Lino.GridStore.superclass.load.call(this,options);
  }
});

    
Lino.GridPanel = Ext.extend(Ext.grid.EditorGridPanel,Lino.MainPanel);
Lino.GridPanel = Ext.extend(Lino.GridPanel,Lino.PanelMixin);
Lino.GridPanel = Ext.extend(Lino.GridPanel,{
  quick_search_text : '',
  is_searching : false,
  disabled_in_insert_window : true,
  clicksToEdit:2,
  enableColLock: false,
  autoHeight: false,
  params_panel_hidden : false,
  preview_limit : undefined, 
  //~ loadMask: true,
  //~ viewConfig: {
          //~ getRowClass: Lino.getRowClass,
          //~ emptyText:"$_('No data to display.')"
        //~ },
  loadMask: {msg:"Bitte warten..."},
  
  constructor : function(config){

    config.plugins = [new Lino.GridFilters()];
    
    
    Lino.GridPanel.superclass.constructor.call(this,config);
    
    //~ if (this.containing_window) {
        //~ console.log("20111206 install refresh");
        //~ this.containing_window.on('show',this.refresh,this);
    //~ }
    
  },
  
  unused_is_loading : function() { 
    if (! this.loadMask.el) return true; // not even rendered: 
    // thanks to Marco Pegoraro http://movableapp.com/2011/09/sencha-touch-loadmask-isvisible/
    var loading = (this.loadMask.el.select('.x-loading-msg').elements.length > 0);
    //~ console.log('20130515 GridPanel.is_loading() returns',loading);
    return loading;
    //~ return this.store.getCount() > 0; 
    //~ return (this.loadMask.el.select('.x-loading-msg').elements.length)
    //~ return !this.viewReady; 
    //~ return this.loadMask.isVisible(); 
    //~ return !this.loadMask.disabled; 
  },
  
  unused_config_containing_window : function(wincfg) { 
      //~ temporarily remove save_grid_config button (see /blog(2012/1107)
      if (wincfg.tools != undefined) 
        wincfg.tools = [
          //~ {handler:this.save_grid_data,
            //~ qtip:"$_("Save Grid Data")",
            //~ scope:this, id:"save_data"}, // 20120814
          {handler:this.save_grid_config,
            qtip:"Tabellenkonfiguration speichern",
            scope:this, id:"save"}
        ].concat(wincfg.tools);
      //~ wincfg.listeners = { show: ... };
  },
  init_containing_window : function(win) { 
    //~ console.log("20111206 install refresh");
    //~ win.on('show',this.refresh,this);
  },
  
  initComponent : function(){
    
    /* 
    Problem 20111206:
    When a GridPanel is the main item of the window, then it doesn't 
    have it's own header but uses the window's header bar.
    We must do this in initComponent because e.g. in beforerender 
    it's already to late: a header element has been created because 
    there was a title.
    But Lino.Window adds itself as `this.containing_window` 
    only after the GridPanel has been initialized.
    Workaround is to generate a line "params.containing_window = true;" 
    in the handler function.
    */ 
    //~ if (this.containing_window) {
    if (this.is_main_window) {
        //~ console.log(20111206, 'delete title',this.title,'from',this);
        //~ delete this.title;
        this.tools = undefined;  
        this.title = undefined;  /* simply deleting it 
          isn't enough because that would only 
          unhide the title defined in some base class. */
    } 
    //~ else console.log(20111206, 'dont delete title',this.title,'from',this);
    
    /* e.g. when slave gridwindow called from a permalink */
    //~ if (this.base_params) Ext.apply(bp,this.base_params);  
    //~ bp['fmt'] = 'json';
    
    //~ function on_proxy_write( proxy, action,data, response,rs,options) {
      //~ console.log('20120814 on_proxy_write',action,data,response)
      //~ this.getStore().doUpdate();
      //~ this.getStore().loadData(data);
    //~ }
    //~ function on_proxy_load( proxy, transactionObject, callbackOptions ) {
      //~ console.log('on_proxy_load',transactionObject)
    //~ }
    var proxy = new Ext.data.HttpProxy({ 
      // 20120814 
      url: '/api' + this.ls_url
      ,method: "GET"
      //~ ,url: ADMIN_URL + '/restful' + this.ls_url
      //~ ,restful: true 
      //~ ,listeners: {load:on_proxy_load} 
      //~ ,listeners: {write:on_proxy_write} 
    });
    //~ config.store = new Ext.data.JsonStore({ 
    //~ this.store = new Ext.data.ArrayStore({ 
    this.store = new Lino.GridStore({ 
      grid_panel: this
      ,listeners: { exception: Lino.on_store_exception }
      ,remoteSort: true
      ,totalProperty: "count"
      ,root: "rows"
      //~ ,id: "id" 
      ,proxy: proxy
      //~ autoLoad: this.containing_window ? true : false
      ,idIndex: this.pk_index
      //~ ,baseParams: bp
      ,fields: this.ls_store_fields
      ,idProperty: this.ls_id_property 
      // 20120814
      //~ ,writer : new Ext.data.JsonWriter({
        //~ writeAllFields: false
        //~ ,listful: true
      //~ })
      //~ ,restful : true
    });
      
    //~ console.log('config.pk_index',config.pk_index,config.store),
    delete this.ls_store_fields;
      
    var this_ = this;
    //~ var grid = this;
    this.store.on('load', function() {
        //~ console.log('20120814 GridStore.on(load)',this_.store);
        //~ var da = this_.store.reader.arrayData.disabled_actions;
        //~ if (da) {
            //~ this.cmenu.cascade(function(item){ 
              //~ console.log(20120531, item.itemId, da[item.itemId]);
              //~ if (da[item.itemId]) item.disable(); else item.enable();
            //~ });
        //~ };
        this_.set_param_values(this_.store.reader.arrayData.param_values);
        //~ this_.set_status(this_.store.reader.arrayData.status);
        //~ 20120918
        if (this_.store.reader.arrayData.no_data_text) {
            //~ this.viewConfig.emptyText = this_.store.reader.arrayData.no_data_text;
            this.getView().emptyText = this_.store.reader.arrayData.no_data_text;
            this.getView().refresh();
        }
        if (this_.containing_window)
            this_.set_window_title(this_.store.reader.arrayData.title);
            //~ this_.containing_window.setTitle(this_.store.reader.arrayData.title);
        if (!this.is_searching) { // disabled 20121025: quick_search_field may not lose focus
          this.is_searching = false;
          if (this_.selModel.getSelectedCell){
              if (this_.getStore().getCount()) // there may be no data
                  this_.selModel.select(0,0); 
          } else {
              this_.selModel.selectFirstRow();
              this_.getView().focusEl.focus();
          }
        } 
        //~ else console.log("is_searching -> no focussing");
        //~ var t = this.getTopToolbar();
        //~ var activePage = Math.ceil((t.cursor + t.pageSize) / t.pageSize);
        //~ this.quick_search_field.focus(); // 20121024
      }, this
    );
    var actions = Lino.build_buttons(this,this.ls_bbar_actions);
    //~ Ext.apply(config,Lino.build_buttons(this,config.ls_bbar_actions));
    //~ config.bbar, this.cmenu = Lino.build_buttons(this,config.ls_bbar_actions);
    //~ this.cmenu = new Ext.menu.Menu({items: config.bbar});
    delete this.ls_bbar_actions
    if (actions) {
        this.cmenu = actions.cmenu;
    }
    
    if (!this.hide_top_toolbar) {  
      var tbar = [ 
        this.quick_search_field = new Ext.form.TextField({ 
          //~ fieldLabel: "Search"
          listeners: { 
            scope:this_
            //~ ,change:this_.search_change
            
            ,render: Lino.quicktip_renderer("Schnellsuche","Hier Text eingeben für Schnellsuche.")
            
            //~ ,keypress: this.search_keypress 
            ,blur: function() { this.is_searching = false}
          }
          ,validator:function(value) { return this_.search_validate(value) }
          //~ ,tooltip: "Enter a quick search text, then press TAB"
          //~ value: text
          //~ scope:this, 
          //~ ,enableKeyEvents: true
          //~ listeners: { keypress: this.search_keypress }, 
          //~ id: "seachString" 
      })];
      tbar = this.add_params_panel(tbar);
      tbar = tbar.concat([
        { scope:this, 
          //~ text: "[csv]", 
          tooltip: "Diese Tabelle in eine .csv-Datei exportieren", 
          iconCls: 'x-tbar-csv',
          handler: function() { 
            //~ 20130116 var p = Ext.apply({},this.get_base_params());
            //~ 20130116 p.fmt = 'csv';
            //~ url += "?" + Ext.urlEncode(p);
            var p = this.get_current_grid_config();
            Ext.apply(p,this.get_base_params());
            p.fmt = "csv";
            this.add_param_values(p,true);
            
            window.open('/api'+this.ls_url + "?" + Ext.urlEncode(p)) 
          } },
        //~ { scope:this, 
          //~ text: "[html]", 
          //~ handler: function() { 
            //~ var p = this.get_current_grid_config();
            //~ Ext.apply(p,this.get_base_params());
            //~ p.$ext_requests.URL_PARAM_FORMAT = "$ext_requests.URL_FORMAT_PRINTER";
            //~ this.add_param_values(p);
            //~ window.open(ADMIN_URL+'/api'+this.ls_url + "?" + Ext.urlEncode(p)) 
          //~ } },
        { scope:this, 
          //~ text: "[html]", 
          tooltip: "Tabelle als HTML anzeigen", 
          iconCls: 'x-tbar-html',
          handler: function() { 
            var p = this.get_current_grid_config();
            Ext.apply(p,this.get_base_params());
            //~ since 20121226 p.$ext_requests.URL_PARAM_FORMAT = "$ext_requests.URL_FORMAT_PLAIN";
            this.add_param_values(p,true);
            //~ since 20121226 window.open(ADMIN_URL+'/api'+this.ls_url + "?" + Ext.urlEncode(p)) 
            window.open('/plain'+this.ls_url + "?" + Ext.urlEncode(p)) 
          } },
        { scope:this, 
          //~ text: "[pdf]", 
          tooltip: "Diese Tabelle in eine .pdf-Datei exportieren", 
          iconCls: 'x-tbar-pdf',
          handler: function() { 
            var p = this.get_current_grid_config();
            Ext.apply(p,this.get_base_params());
            p.fmt = "pdf";
            this.add_param_values(p,true);
            window.open('/api'+this.ls_url + "?" + Ext.urlEncode(p)) 
          } }
      ]);
    
    
      var menu = [];
      var set_gc = function(index) {
        return function() {
          //~ console.log('set_gc() 20100812');
          this.getColumnModel().setConfig(
              this.apply_grid_config(index,this.ls_grid_configs,this.ls_columns));
        }
      }
      for (var i = 0; i < this.ls_grid_configs.length;i++) {
        var gc = this.ls_grid_configs[i];
        menu.push({text:gc.label,handler:set_gc(i),scope:this})
      }
      if(menu.length > 1) {
        tbar = tbar.concat([
          { text:"Ansicht",
            menu: menu,
            tooltip:"Andere Ansicht auswählen"
          }
        ]);
      }
      
      if (actions) {
        tbar = tbar.concat(actions.bbar);
          //~ this.bbar = actions.bbar;
      }
      
      this.tbar = new Ext.PagingToolbar({ 
        store: this.store, 
        prependButtons: true, 
        //~ pageSize: this.page_length, 
        pageSize: 1, 
        displayInfo: true, 
        beforePageText: "Seite",
        afterPageText: "von {0}",
        displayMsg: "Zeilen {0} bis {1} von {2}",
        firstText: "Erste Seite",
        lastText: "Letzte Seite",
        prevText: "Vorige Seite",
        nextText: "Nächste Seite",
        items: tbar
      });
      //~ this.on('resize', function(cmp,aw,ah,rw,rh) {
          //~ var ps = this.calculatePageSize();
          //~ if (ps && ps != this.getTopToolbar().pageSize) {
              //~ // console.log('20120203 resize : pageSize',this.getTopToolbar().pageSize,'->',ps);
              //~ // this.getTopToolbar().pageSize =  ps;
              //~ cmp.refresh();
              //~ // this.getTopToolbar().doRefresh();
          //~ }
        //~ }, this);
      //~ this.on('resize', function(cmp,aw,ah,rw,rh) {
          //~ cmp.getTopToolbar().pageSize = this.calculatePageSize(aw,ah,rw,rh) || 10;
          //~ cmp.refresh();
        //~ }, this, {delay:500});
    }
    
    //~ delete this.page_length
    
    
      
    if (this.ls_quick_edit) {
      this.selModel = new Ext.grid.CellSelectionModel()
      this.get_selected = function() {
        //~ console.log(this.getSelectionModel().selection);
        if (this.selModel.selection)
            return [ this.selModel.selection.record ];
        return [this.store.getAt(0)];
      };
      this.get_current_record = function() { 
        if (this.getSelectionModel().selection) 
          return this.selModel.selection.record;
        return this.store.getAt(0);
      };
    } else { 
      this.selModel = new Ext.grid.RowSelectionModel() 
      this.get_selected = function() {
        var sels = this.selModel.getSelections();
        if (sels.length == 0) sels = [this.store.getAt(0)];
        return sels
        //~ var sels = this.getSelectionModel().getSelections();
        //~ return Ext.pluck(sels,'id');
      };
      this.get_current_record = function() { 
        var rec = this.selModel.getSelected();
        if (rec == undefined) rec = this.store.getAt(0);
        return rec
      };
    };
    delete this.ls_quick_edit;
    
    this.columns  = this.apply_grid_config(this.gc_name,this.ls_grid_configs,this.ls_columns);
    
    //~ var grid = this;
    //~ this.colModel = new Ext.grid.ColumnModel({
      //~ columns: this.apply_grid_config(this.gc_name,this.ls_grid_configs,this.ls_columns),
      //~ isCellEditable: function(col, row) {
        //~ var record = grid.store.getAt(row);
        //~ console.log('20120514',col,record); // dataIndex
        //~ var dataIndex = grid.colModel.getDataIndex(col);
        //~ if (dataIndex in record.data['disabled_fields']) {
            //~ Lino.notify("$_("This field is disabled")");
            //~ return false;
        //~ }
        //~ return Ext.grid.ColumnModel.prototype.isCellEditable.call(this, col, row);
      //~ }
    //~ });    
    
    
    Lino.GridPanel.superclass.initComponent.call(this);
    
    //~ if (this.containing_window) 
        //~ this.on('afterlayout', this.refresh, this);
        //~ this.on('afterrender', this.refresh,this);
    //~ else
        //~ this.on('show', this.refresh,this);
    //~ this.on('afterlayout', function() {
      //~ if (this.id == "ext-comp-1157") 
        //~ console.log("20120213 afterlayout",this); 
      //~ // this.refresh();
      //~ },this);
    //~ this.on('afterrender', this.refresh);
    //~ this.on('resize', this.refresh,this,{delay:500});
    //~ this.on('resize', function(){console.log("20120213 resize",arguments)},this);
    this.on('resize', function(){
      //~ console.log("20120213 resize",arguments)
      this.refresh();
      },this);
    this.on('viewready', function(){
      //~ console.log("20120213 resize",arguments);
      this.view_is_ready = true;
      this.refresh();
      },this);
    this.on('afteredit', this.on_afteredit); // 20120814
    //~ this.on('afteredit', this.new_on_afteredit);
    this.on('beforeedit', this.on_beforeedit);
    this.on('beforeedit',function(e) { this.before_row_edit(e.record)},this);
    this.on('cellcontextmenu', Lino.cell_context_menu, this);
    //~ this.on('contextmenu', Lino.grid_context_menu, this);
    
    
    //~ if (this.id == "ext-comp-1157") captureEvents(this);    
    
  },
  
  //~ onResize : function(){
      //~ console.log("20120206 GridPanel.onResize",arguments);
      //~ Lino.GridPanel.superclass.onResize.apply(this, arguments);
      //~ this.refresh();
  //~ },
  
  
  get_status : function(){
    var st = { base_params : this.get_base_params()};
    if (!this.hide_top_toolbar) {
        st.current_page = this.getTopToolbar().current;
    }
    st.param_values = this.status_param_values;
    //~ console.log("20120213 GridPanel.get_status",st);
    return st;
  },
  
  /* 
  Lino.GridPanel.set_status() 
  */
  set_status : function(status){
    //~ console.log("20130605 GridPanel.set_status",status);
    this.clear_base_params();
    if (status == undefined) status = {};
    this.set_param_values(status.param_values);
    if (status.base_params) { 
      this.set_base_params(status.base_params);
    }
    if (status.show_params_panel != undefined) {
        if (this.toggle_params_panel_btn) {
            //~ this.toggle_params_panel_btn.toggle(status.show_params_panel=='true');
            this.toggle_params_panel_btn.toggle(status.show_params_panel);
        }
    }
    if (!this.hide_top_toolbar) {
      //~ console.log("20120213 GridPanel.getTopToolbar().changePage",
          //~ status.current_page || 1);
      this.getTopToolbar().changePage(status.current_page || 1);
    }
    //~ this.fireEvent('resize');
    //~ this.refresh.defer(100,this); 
    //~ this.onResize.defer(100,this); 
    //~ this.refresh(); 
    //~ this.doLayout(); 
    //~ this.onResize(); 
    //~ this.store.load();
  },
  
  refresh : function(unused) { 
    this.refresh_with_after();
  },
  refresh_with_after : function(after) { 
    //~ Lino.notify('20120204 Lino.GridPanel.refresh');
    //~ Lino.notify('Lino.GridPanel.refresh '+this.store.proxy.url);
    //~ var bp = { fmt:'json' }
    if (this.containing_panel) {
        //~ Ext.apply(p,this.master_panel.get_master_params());
        //~ Ext.apply(options.params,this.containing_panel.get_master_params());
        this.set_base_params(this.containing_panel.get_master_params());
    }
    
    if (! this.view_is_ready) return;
    
    var options = {};
    if (after) {
        options.callback = function(r,options,success) {if(success) after()}
    }
      
    //~ if (!this.rendered) {
        //~ console.log("20120206 GridPanel.refresh() must wait until rendered",options);
        //~ this.grid_panel.on('render',this.load.createDelegate(this,options))
        //~ return;
    //~ }
    
    this.store.load(options);
  },
  
  /* pageSize depends on grid height (Trying to remove scrollbar)
  Thanks to 
  - Christophe Badoit on http://www.sencha.com/forum/showthread.php?82647
  - http://www.sencha.com/forum/archive/index.php/t-37231.html
  */
  calculatePageSize : function(second_attempt) {
    //~ if (!this.rendered) { 
    if (!this.view_is_ready) { 
      //~ console.log('Cannot calculatePageSize() : not rendered');
      return false; }
    //~ if (!this.isVisible()) { 
      //~ console.log('calculatePageSize : not visible');
      //~ return false; }
      
    //~ console.log('getFrameHeight() is',this.getFrameHeight());
    //~ console.log('getView().scroller.getHeight() is',this.getView().scroller.getHeight());
    //~ console.log('mainBody.getHeight() is',this.getView().mainBody.getHeight());
    //~ console.log('getInnerHeight() is',this.getInnerHeight());
    //~ console.log('getHeight() is',this.getHeight());
    //~ console.log('el.getHeight() is',this.getEl().getHeight());
    //~ console.log('getGridEl().getHeight() is',this.getGridEl().getHeight());
    //~ console.log('getOuterSize().height is',this.getOuterSize().height);
    //~ console.log('getBox().height is',this.getBox().height);
    //~ console.log('getResizeEl.getHeight() is',this.getResizeEl().getHeight());
    //~ console.log('getLayoutTarget().getHeight() is',this.getLayoutTarget().getHeight());
      
    var rowHeight = this.getFrameHeight();
    //~ var rowHeight = 52; // experimental value
    var row = this.view.getRow(0);
    if (row) {
      //~ console.log('20120213 yes');
      rowHeight = Ext.get(row).getHeight();
    }
    //~ console.log('rowHeight is ',rowHeight,this,caller);
    //~ this.getView().syncScroll();
    //~ this.getView().initTemplates();
    var height = this.getView().scroller.getHeight();
    //~ console.log('getView().scroller.getHeight() is',this.getView().scroller.getHeight());
    //~ console.log('getInnerHeight() - getFrameHeight() is',
      //~ this.getInnerHeight(), '-',
      //~ this.getFrameHeight(), '=',
      //~ this.getInnerHeight() - this.getFrameHeight());
    //~ var height = this.getView().mainBody.getHeight();
    //~ var height = this.getView().mainWrap.getHeight();
    //~ var height = this.getView().resizeMarker.getHeight();
    //~ this.syncSize();
    //~ var height = this.getInnerHeight() - this.getFrameHeight();
    //~ var height = this.getHeight() - this.getFrameHeight();
    height -= Ext.getScrollBarWidth(); // leave room for a possible horizontal scrollbar... 
    //~ height -= this.getView().scrollOffset;
    var ps = Math.floor(height / rowHeight);
    //~ console.log('20120203 calculatePageSize():',height,'/',rowHeight,'->',ps);
    ps -= 1; // leave room for a possible phantom row
    //~ return (ps > 1 ? ps : false);
    if (ps > 1) return ps;
    //~ console.log('calculatePageSize() found less than 1 row:',height,'/',rowHeight,'->',ps);
    //~ foo.bar = baz; // 20120213
    return 5; // preview_limit
    //~ if (second_attempt) {
        //~ console.log('calculatePageSize() abandons after second attempt:',
          //~ height,'/',rowHeight,'->',ps);
      //~ return 5;
    //~ }
    //~ return this.calculatePageSize.defer(500,this,[true]);
  },
  
  onCellDblClick : function(grid, row, col){
      //~ console.log("20120307 onCellDblClick",this,grid, row, col);
      if (this.ls_detail_handler) {
          //~ Lino.notify('show detail');
          Lino.show_detail(this);
          return false;
      }else{
        //~ console.log('startEditing');
        this.startEditing(row,col);
      }
  },
  
  get_base_params : function() {
    //~ return this.containing_window.config.base_params;
    //~ console.log(20120717,this.store.baseParams);
    var p = Ext.apply({},this.store.baseParams);
    Lino.insert_subst_user(p);
    //~ console.log("20120717 GRidPanel.get_base_params() returns",p);
    return p;
    //~ return this.store.baseParams;
  },
  set_base_params : function(p) {
    //~ console.log('GridPanel.set_base_params',p)
    for (k in p) this.store.setBaseParam(k,p[k]);
    //~ this.store.baseParams = p;
    if (p.query) 
        this.quick_search_field.setValue(p.query);
    //~ if (p.param_values) 
        //~ this.set_param_values(p.param_values);  
  },
  clear_base_params : function() {
      this.store.baseParams = {};
      Lino.insert_subst_user(this.store.baseParams);
  },
  set_base_param : function(k,v) {
    this.store.setBaseParam(k,v);
  },
  
  //~ get_permalink_params : function() {
    //~ var p = {};
    //~ return p;
  //~ },
  
  before_row_edit : function(record) {},
    
  //~ search_keypress : function(){
    //~ console.log("2012124 search_keypress",arguments);
  //~ },
  search_validate : function(value) {
    if (value == this.quick_search_text) return true;
    this.is_searching = true;
    //~ console.log('search_validate',value)
    this.quick_search_text = value;
    this.set_base_param('query',value); 
    //~ this.getTopToolbar().changePage(1);
    this.getTopToolbar().moveFirst();
    //~ this.refresh();
    return true;
  },
  
  search_change : function(field,oldValue,newValue) {
    //~ console.log('search_change',field.getValue(),oldValue,newValue)
    this.set_base_param('query',field.getValue()); 
    this.getTopToolbar().moveFirst();
    //~ this.refresh();
  },
  
  apply_grid_config : function(index,grid_configs,rpt_columns) {
    //~ var rpt_columns = this.ls_columns;
    var gc = grid_configs[index];    
    //~ console.log('apply_grid_config() 20100812',name,gc);
    this.gc_name = index;
    if (gc == undefined) {
      return rpt_columns;
      //~ config.columns = config.ls_columns;
      //~ return;
    } 
    //~ delete config.ls_filters
    
    //~ console.log(20100805,config.ls_columns);
    var columns = Array(gc.columns.length);
    for (var j = 0; j < rpt_columns.length;j++) {
      var col = rpt_columns[j];
      for (var i = 0; i < gc.columns.length; i++) {
        if (col.dataIndex == gc.ci[i]) {
          col.width = gc.cw[i];
          col.hidden = gc.ch[i];
          columns[i] = col;
          break;
        }
      }
    }
    
    //~ var columns = Array(rpt_columns.length);
    //~ for (var i = 0; i < rpt_columns.length; i++) {
      //~ columns[i] = rpt_columns[gc.columns[i]];
      //~ columns[i].width = gc.widths[i];
    //~ }
    
    //~ if (gc.hidden_cols) {
      //~ for (var i = 0; i < gc.hidden_cols.length; i++) {
        //~ var hc = gc.hidden_cols[i];
        //~ for (var j = 0; j < columns.length;j++) {
          //~ var col = columns[j];
          //~ if (col.dataIndex == hc) {
            //~ col.hidden = true;
            //~ break
          //~ }
        //~ }
      //~ }
    //~ }
    if (gc.filters) {
      //~ console.log(20100811,'config.ls_filters',config.ls_filters);
      //~ console.log(20100811,'config.ls_grid_config.filters',config.ls_grid_config.filters);
      for (var i = 0; i < gc.filters.length; i++) {
        var fv = gc.filters[i];
        for (var j = 0; j < columns.length;j++) {
          var col = columns[j];
          if (col.dataIndex == fv.field) {
            //~ console.log(20100811, f,' == ',fv);
            if (fv.type == 'string') {
              col.filter.value = fv.value;
              //~ if (fv.comparison !== undefined) f.comparison = fv.comparison;
            } else {
              //~ console.log(20100811, fv);
              col.filter.value = {};
              col.filter.value[fv.comparison] = fv.value;
            }
            break;
          }
        };
      }
    }
    
    return columns;
    //~ config.columns = cols;
    //~ delete config.ls_columns
  },
  
  get_current_grid_config : function () {
    var cm = this.getColumnModel();
    var widths = Array(cm.config.length);
    var hiddens = Array(cm.config.length);
    //~ var hiddens = Array(cm.config.length);
    var columns = Array(cm.config.length);
    //~ var columns = Array(cm.config.length);
    //~ var hidden_cols = [];
    //~ var filters = this.filters.getFilterValues();
    var p = this.filters.buildQuery(this.filters.getFilterData())
    for (var i = 0; i < cm.config.length; i++) {
      var col = cm.config[i];
      columns[i] = col.dataIndex;
      //~ hiddens[i] = col.hidden;
      widths[i] = col.width;
      hiddens[i] = col.hidden;
      //~ if (col.hidden) hidden_cols.push(col.dataIndex);
    }
    //~ p['hidden_cols'] = hidden_cols;
    p.cw = widths;
    p.ch = hiddens;
    p.ci = columns;
    //~ p['widths'] = widths;
    //~ p['hiddens'] = hiddens;
    //~ p['columns'] = columns;
    p['name'] = this.gc_name;
    //~ var gc = this.ls_grid_configs[this.gc_name];
    //~ if (gc !== undefined) 
        //~ p['label'] = gc.label
    //~ console.log('20100810 save_grid_config',p);
    return p;
  },
  
  unused_manage_grid_configs : function() {
    var data = [];
    for (k in this.ls_grid_configs) {
      var v = this.ls_grid_configs[k];
      var i = [k,String(v.columns),String(v.hidden_cols),String(v.filters)];
      data.push(i)
    }
    if (this.ls_grid_configs[this.gc_name] == undefined) {
      var v = this.get_current_grid_config();
      var i = [k,String(v.columns),String(v.hidden_cols),String(v.filters)];
      data.push(i);
    }
    //~ console.log(20100811, data);
    var main = new Ext.grid.GridPanel({
      store: new Ext.data.ArrayStore({
        idIndex:0,
        fields:['name','columns','hidden_cols','filters'],
        autoDestroy:true,
        data: data}),
      //~ autoHeight:true,
      selModel: new Ext.grid.RowSelectionModel(),
      listeners: { 
        rowdblclick: function(grid,rowIndex,e) {
          console.log('row doubleclicked',grid, rowIndex,e);
        },
        rowclick: function(grid,rowIndex,e) {
          console.log('row clicked',grid, rowIndex,e);
        }
      },
      columns: [ 
        {dataIndex:'name',header:'Name'}, 
        {dataIndex:'columns',header:'columns'}, 
        {dataIndex:'hidden_cols',header:'hidden columns'}, 
        {dataIndex:'filters',header:'filters'} 
      ]
    });
    var win = new Ext.Window({title:'GridConfigs Manager',layout:'fit',items:main,height:200});
    win.show();
  },
  
  unused_edit_grid_config : function(name) {
    gc = this.ls_grid_configs[name];
    var win = new Ext.Window({
      title:'Edit Grid Config',layout:'vbox', 
      //~ layoutConfig:'stretch'
      items:[
        {xtype:'text', value: gc.name},
        {xtype:'text', value: gc.columns},
        {xtype:'text', value: gc.hidden_cols},
        {xtype:'text', value: gc.filters}
      ]
    });
    win.show();
  },
  
  save_grid_config : function () {
    //~ console.log('TODO: save_grid_config',this);
    //~ p.column_widths = Ext.pluck(this.colModel.columns,'width');
    var a = { 
      params:this.get_current_grid_config(), 
      method:'PUT',
      url:'/grid_config' + this.ls_url,
      success: Lino.action_handler(this),
      scope: this,
      failure: Lino.ajax_error_handler(this)
    };
    this.loadMask.show(); // 20120211
    Ext.Ajax.request(a);
    //~ Lino.do_action(this,a);
  },
  
  on_beforeedit : function(e) {
    //~ console.log('20130128 GridPanel.on_beforeedit()',e,e.record.data.disable_editing);
    if(this.disable_editing | e.record.data.disable_editing) {
      e.cancel = true;
      Lino.notify("Dieser Datensatz ist deaktiviert");
      return;
    }
    if(e.record.data.disabled_fields && e.record.data.disabled_fields[e.field]) {
      e.cancel = true;
      Lino.notify("Dieses Feld ist deaktiviert");
      return;
    }
    //~ if (e.record.data.disabled_fields) {
      //~ for (i in e.record.data.disabled_fields) {
        //~ if(e.record.data.disabled_fields[i] == e.field) {
          //~ e.cancel = true;
          //~ Lino.notify(String.format('Field "{0}" is disabled for this record',e.field));
          //~ return
        //~ }
      //~ }
    //~ }
  },
  save_grid_data : function() {
      //~ console.log("20120814 save_grid_data");
      this.getStore().commitChanges();
  },
  new_on_afteredit : function(e) {
      //~ this.getStore().commitChanges();
      //~ this.getStore().doUpdate();
      //~ this.getStore().loadData(data);
      console.log("20120814 new_on_afteredit",e);
  },
  on_afteredit : function(e) {
    /*
    e.grid - The grid that fired the event
    e.record - The record being edited
    e.field - The field name being edited
    e.value - The value being set
    e.originalValue - The original value for the field, before the edit.
    e.row - The grid row index
    e.column - The grid column index
    */
    var p = {};
    //~ console.log('20101130 modified: ',e.record.modified);
    //~ console.log('20101130 value: ',e.value);
    //~ var p = e.record.getChanges();
    //~ console.log('20101130 getChanges: ',e.record.getChanges());
    //~ this.before_row_edit(e.record);
    for(k in e.record.getChanges()) {
        var v = e.record.get(k);
    //~ for(k in e.record.modified) {
        //~ console.log('20101130',k,'=',v);
        //~ var cm = e.grid.getColumnModel();
        //~ var di = cm.getDataIndex(k);
        var f = e.record.fields.get(k);
        //~ console.log('20101130 f = ',f);
        //~ var v = e.record.get(di);
        if (f.type.type == 'date') {
            p[k] = Ext.util.Format.date(v, f.dateFormat);
        }else{
            p[k] = v;
            var v = e.record.get(k+'Hidden');
            if (v !== undefined) {
              p[k+'Hidden'] = v;
            }
        }
        //~ var i = cm.findColumnIndex(k);
        //~ var r = cm.getRenderer(i);
        //~ var editor = cm.getCellEditor(i,e.row);
        //~ var col = e.grid.getColumnModel().getColumnById(k);
        //~ console.log('20101130 r = ',r(v));
        //~ var f = e.record.fields[k];
        //~ console.log('20101130 f = ',f);
        //~ console.log('20101130 editor = ',editor);
        //~ p[k] = f.getValue();
        //~ p[k] = r(v);
    }
    //~ console.log('20101130 p:',p);
    //~ var cm = e.grid.getColumnModel();
    //~ var di = cm.getDataIndex(e.column);
    //~ var f = e.record.fields.get(di);
    //~ console.log('20101130 f = ',f);
    //~ if (f.type.type == 'date') e.record.set(di,Ext.util.Format.date(e.value, f.dateFormat));
    
    
    //~ var p = e.record.data;
    
    // var p = {};
    //~ p['grid_afteredit_colname'] = e.field;
    //~ p[e.field] = e.value;
    //~ console.log('20100723 GridPanel.on_afteredit()',e);
    // add value used by ForeignKeyStoreField CHOICES_HIDDEN_SUFFIX
    // not sure whether this is still needed:
    p[e.field+'Hidden'] = e.value;
    //~ p.su = Lino.subst_user;
    Lino.insert_subst_user(p);
    // this one is needed so that this field can serve as choice context:
    e.record.data[e.field+'Hidden'] = e.value;
    // p[pk] = e.record.data[pk];
    // console.log("grid_afteredit:",e.field,'=',e.value);
    Ext.apply(p,this.get_base_params()); // needed for POST, ignored for PUT
    //~ Ext.apply(p,this.containing_window.config.base_params);
    //~ 20121109 p['$ext_requests.URL_PARAM_ACTION_NAME'] = 'grid';
    var self = this;
    var req = {
        params:p,
        waitMsg: 'Saving your data...',
        success: Lino.action_handler( this, function(result) {
          //~ if (result.data_record) {
          if (result.refresh_all) {
              var cw = self.get_containing_window();
              if (cw) {
                  cw.main_item.refresh();
              }
              else console.log("20120123 cannot refresh_all",self);
          } else if (result.rows) {
              //~ self.getStore().loadData(result,true);
              var r = self.getStore().reader.readRecords(result);
              if (e.record.phantom) {
                  //~ console.log("20120816 afteredit.success POST",r);
                  self.getStore().insert(e.row,r.records);
              }else{
                  //~ console.log("20120816 afteredit.success PUT",r);
                  self.getStore().doUpdate(r.records[0]);
              }
              self.getStore().rejectChanges(); /* 
              get rid of the red triangles without saving the record again
              */
              //~ self.getStore().commitChanges(); // get rid of the red triangles
          } else {
              self.getStore().commitChanges(); // get rid of the red triangles
              self.getStore().reload();        // reload our datastore.
          }
          }),
        scope: this,
        failure: Lino.ajax_error_handler(this)
    };
    if (e.record.phantom) {
      req.params.an = 'post'; // SubmitInsert.action_name
      Ext.apply(req,{
        method: 'POST',
        url: '/api' + this.ls_url
      });
    } else {
      req.params.an = 'put'; // SubmitDetail.action_name
      Ext.apply(req,{
        method: 'PUT',
        url: '/api' + this.ls_url + '/' + e.record.id
      });
    }
    //~ console.log('20110406 on_afteredit',req);
    this.loadMask.show(); // 20120211
    Ext.Ajax.request(req);
  },

  afterRender : function() {
    Lino.GridPanel.superclass.afterRender.call(this);
    // this.getView().mainBody.focus();
    // console.log(20100114,this.getView().getRows());
    // if (this.getView().getRows().length > 0) {
    //  this.getView().focusRow(1);
    // }
    //~ this.my_load_mask = new Ext.LoadMask(this.getEl(), {
        //~ msg:'$_("Please wait...")',
        //~ store:this.store});
      
    var tbar = this.getTopToolbar();
    // tbar.on('change',function() {this.getView().focusRow(1);},this);
    // tbar.on('change',function() {this.getSelectionModel().selectFirstRow();this.getView().mainBody.focus();},this);
    // tbar.on('change',function() {this.getView().mainBody.focus();},this);
    // tbar.on('change',function() {this.getView().focusRow(1);},this);
    this.nav = new Ext.KeyNav(this.getEl(),{
      pageUp: function() {tbar.movePrevious(); },
      pageDown: function() {tbar.moveNext(); },
      home: function() {tbar.moveFirst(); },
      end: function() {tbar.moveLast(); },
      scope: this
    });
  },
  after_delete : function() {
    //~ console.log('Lino.GridPanel.after_delete');
    this.refresh();
  },
  add_row_listener : function(fn,scope) {
    this.getSelectionModel().addListener('rowselect',fn,scope);
  },
  postEditValue : function(value, originalValue, r, field){
    value = Lino.GridPanel.superclass.postEditValue.call(this,value,originalValue,r,field);
    //~ console.log('GridPanel.postEdit()',value, originalValue, r, field);
    return value;
  },
  
  set_start_value : function(v) {
      this.start_value = v;
  },
  preEditValue : function(r, field){
      if (this.start_value) {
        var v = this.start_value;
        delete this.start_value;
        this.activeEditor.selectOnFocus = false;
        return v;
      }
      var value = r.data[field];
      return this.autoEncode && Ext.isString(value) ? Ext.util.Format.htmlDecode(value) : value;
  },
  
  on_master_changed : function() {
    //~ if (! this.enabled) return;
    //~ cmp = this;
    //~ console.log('Lino.GridPanel.on_master_changed()',this.title);
    if (! this.rendered) return; // 20120213
    var todo = function() {
      if (this.disabled) return;
      //~ if (this.disabled) return;
      //~ if (this.enabled) {
          //~ var src = caller.config.url_data + "/" + record.id + ".jpg"
          //~ console.log(20111125, this.containing_window);
          //~ for (k in p) this.getStore().setBaseParam(k,p[k]);
          //~ console.log('Lino.GridPanel.on_master_changed()',this.title,p);
          this.refresh();
          //~ this.set_base_params(this.master_panel.get_master_params());
          //~ this.getStore().load(); 
      //~ }
    };
    Lino.do_when_visible(this,todo.createDelegate(this));
  }
});
  

//~ Lino.MainPanelMixin = {
  //~ tbar_items : function() {
      //~ return ;
  //~ }
//~ };

//~ Ext.override(Lino.GridPanel,Lino.MainPanelMixin);
//~ Ext.override(Lino.FormPanel,Lino.MainPanelMixin);

//~ Lino.grid_context_menu = function(e) {
  //~ console.log('contextmenu',arguments);
//~ }

Lino.cell_context_menu = function(grid,row,col,e) {
  //~ console.log('20120531 cellcontextmenu',grid,row,col,e,grid.store.reader.arrayData.rows[row]);
  e.stopEvent();
  //~ grid.getView().focusCell(row,col);
  grid.getSelectionModel().select(row,col);
  //~ console.log(grid.store.getAt(row));
  //~ grid.getView().focusRow(row);
  //~ return;
  if(!grid.cmenu.el){grid.cmenu.render(); }
  //~ if(e.record.data.disabled_fields) {
  
  var da = grid.store.reader.arrayData.rows[row][grid.disabled_actions_index];
  if (da) {
      this.cmenu.cascade(function(item){ 
        //~ console.log(20120531, item.itemId, da[item.itemId]);
        if (da[item.itemId]) item.disable(); else item.enable();
      });
  };
  
  var xy = e.getXY();
  xy[1] -= grid.cmenu.el.getHeight();
  grid.cmenu.showAt(xy);
}


//~ Lino.load_main_menu = function() {
  //~ Ext.Ajax.request({
    //~ waitMsg: 'Loading main menu...',
    //~ method: 'GET',
    //~ url: '/menu',
    //~ success: Lino.on_load_menu,
    //~ failure: Lino.ajax_error_handler
  //~ });
//~ };



//~ Lino.SlavePlugin = function(caller) {
  //~ this.caller = caller;
//~ };

Lino.chooser_handler = function(combo,name) {
  return function(cmp,newValue,oldValue) {
    //~ console.log('Lino.chooser_handler()',cmp,oldValue,newValue);
    combo.setContextValue(name,newValue);
  }
};



Lino.ComboBox = Ext.extend(Ext.form.ComboBox,{
  forceSelection: true,
  triggerAction: 'all',
  minListWidth:230,
  autoSelect: false,
  selectOnFocus: true, // select any existing text in the field immediately on focus.
  submitValue: true,
  displayField: 'text', // 'text', 
  valueField: 'value', // 'value',
  
  //~ initComponent : Ext.form.ComboBox.prototype.initComponent.createSequence(function() {
  initComponent : function(){
      this.contextParams = {};
      //~ Ext.form.ComboBox.initComponent(this);
      Lino.ComboBox.superclass.initComponent.call(this);
  },
  setValue : function(v,record_data){
      /*
      Based on feature request developed in http://extjs.net/forum/showthread.php?t=75751
      */
      /* `record_data` is used to get the text corresponding to this value */
      //~ if(this.name == 'city') 
      //~ console.log('20120203', this.name,'.setValue(', v ,') this=', this,'record_data=',record_data);
      var text = v;
      if(this.valueField){
        if(v == null || v == '') { 
            //~ if (this.name == 'birth_country') 
                //~ console.log(this.name,'.setValue',v,'no lookup needed, value is empty');
            //~ v = undefined;
            v = '';
            //~ text = '';
        } else if (Ext.isDefined(record_data)) {
          text = record_data[this.name];
          //~ if (this.name == 'birth_country') 
            //~ console.log(this.name,'.setValue',v,'got text ',text,' from record ',record);
        } else {
          // if(this.mode == 'remote' && !Ext.isDefined(this.store.totalLength)){
          if(this.mode == 'remote' && ( this.lastQuery === null || (!Ext.isDefined(this.store.totalLength)))){
              //~ if (this.name == 'birth_country') console.log(this.name,'.setValue',v,'store not yet loaded');
              this.store.on('load', this.setValue.createDelegate(this, arguments), null, {single: true});
              if(this.store.lastOptions === null || this.lastQuery === null){
                  var params;
                  if(this.valueParam){
                      params = {};
                      params[this.valueParam] = v;
                  }else{
                      var q = this.allQuery;
                      this.lastQuery = q;
                      this.store.setBaseParam(this.queryParam, q);
                      params = this.getParams(q);
                  }
                  //~ if (this.name == 'birth_country') 
                    //~ console.log(this.name,'.setValue',v,' : call load() with params ',params);
                  this.store.load({params: params});
              //~ }else{
                  //~ if (this.name == 'birth_country') 
                    //~ console.log(this.name,'.setValue',v,' : but store is loading',this.store.lastOptions);
              }
              return;
          //~ }else{
              //~ if (this.name == 'birth_country') 
                //~ console.log(this.name,'.setValue',v,' : store is loaded, lastQuery is "',this.lastQuery,'"');
          }
          var r = this.findRecord(this.valueField, v);
          if(r){
              text = r.data[this.displayField];
          }else if(this.valueNotFoundText !== undefined){
              text = this.valueNotFoundText;
          }
        }
      }
      this.lastSelectionText = text;
      //~ this.lastSelectionText = v;
      if(this.hiddenField){
          //~ this.hiddenField.originalValue = v;
          this.hiddenField.value = v;
      }
      Ext.form.ComboBox.superclass.setValue.call(this, text);
      this.value = v; // needed for grid.afteredit
  },
  
  getParams : function(q){
    // p = Ext.form.ComboBox.superclass.getParams.call(this, q);
    // causes "Ext.form.ComboBox.superclass.getParams is undefined"
    var p = {};
    //p[this.queryParam] = q;
    if(this.pageSize){
        //~ p.start = 0;
        //~ p.limit = this.pageSize;
        p['start'] = 0;
        p['limit'] = this.pageSize;
    }
    // now my code:
    if(this.contextParams) Ext.apply(p,this.contextParams);
    //~ if(this.contextParams && this.contextValues) {
      //~ for(i = 0; i <= this.contextParams.length; i++)
        //~ p[this.contextParams[i]] = this.contextValues[i];
    //~ }
    return p;
  },
  setContextValue : function(name,value) {
    //~ console.log('setContextValue',this,this.name,':',name,'=',value);
    //~ if (this.contextValues === undefined) {
        //~ this.contextValues = Array(); // this.contextParams.length);
    //~ }
    if (this.contextParams[name] != value) {
      //~ console.log('setContextValue 1',this.contextParams);
      this.contextParams[name] = value;
      this.lastQuery = null;
      //~ console.log('setContextValue 2',this.contextParams);
    }
  }
});

Lino.ChoicesFieldElement = Ext.extend(Lino.ComboBox,{
  mode: 'local'
});


Lino.SimpleRemoteComboStore = Ext.extend(Ext.data.JsonStore,{
  forceSelection: true,
  constructor: function(config){
      Lino.SimpleRemoteComboStore.superclass.constructor.call(this, Ext.apply(config, {
          totalProperty: 'count',
          root: 'rows',
          id: 'value', // ext_requests.CHOICES_VALUE_FIELD
          fields: ['value' ], // ext_requests.CHOICES_VALUE_FIELD, // ext_requests.CHOICES_TEXT_FIELD
          listeners: { exception: Lino.on_store_exception }
      }));
  }
});

Lino.ComplexRemoteComboStore = Ext.extend(Ext.data.JsonStore,{
  constructor: function(config){
      Lino.ComplexRemoteComboStore.superclass.constructor.call(this, Ext.apply(config, {
          totalProperty: 'count',
          root: 'rows',
          id: 'value', // ext_requests.CHOICES_VALUE_FIELD
          fields: ['value','text'], // ext_requests.CHOICES_VALUE_FIELD, // ext_requests.CHOICES_TEXT_FIELD
          listeners: { exception: Lino.on_store_exception }
      }));
  }
});

Lino.RemoteComboFieldElement = Ext.extend(Lino.ComboBox,{
  mode: 'remote',
  //~ forceSelection:false,
  minChars: 2, // default 4 is too much
  queryDelay: 300, // default 500 is maybe slow
  queryParam: 'query', 
  //~ typeAhead: true,
  //~ selectOnFocus: true, // select any existing text in the field immediately on focus.
  resizable: true
});

/*
Thanks to Animal for posting the basic idea:
http://www.sencha.com/forum/showthread.php?15842-2.0-SOLVED-Combobox-twintrigger-clear&p=76130&viewfull=1#post76130

*/
Lino.TwinCombo = Ext.extend(Lino.RemoteComboFieldElement,{
    trigger2Class : 'x-form-search-trigger',
    //~ trigger2Class : 'x-tbar-detail',
    initComponent : function() {
        //~ Lino.TwinCombo.superclass.initComponent.call(this);
        Lino.ComboBox.prototype.initComponent.call(this);
        Ext.form.TwinTriggerField.prototype.initComponent.call(this);
    },
    onTrigger2Click : function() {
        //~ console.log('onTrigger2Click',this,arguments);
    }
  });
//~ Lino.TwinCombo.prototype.initComponent = Ext.form.TwinTriggerField.prototype.initComponent;
Lino.TwinCombo.prototype.getTrigger = Ext.form.TwinTriggerField.prototype.getTrigger;
Lino.TwinCombo.prototype.getOuterSize = Ext.form.TwinTriggerField.prototype.getOuterSize;
Lino.TwinCombo.prototype.initTrigger = Ext.form.TwinTriggerField.prototype.initTrigger;
Lino.TwinCombo.prototype.onTrigger1Click = Ext.form.ComboBox.prototype.onTriggerClick;
//~ Lino.TwinCombo.prototype.onTrigger2Click = function() {
    //~ console.log('onTrigger2Click',arguments);
//~ };



Lino.SimpleRemoteComboFieldElement = Ext.extend(Lino.RemoteComboFieldElement,{
  displayField: 'value', 
  valueField: null,
  forceSelection: false
});




Lino.Window = Ext.extend(Ext.Window,{
  //~ layout: "fit", 
  closeAction : 'hide',
  renderTo: 'main_area', 
  constrain: true,
  maximized: true,
  draggable: false,
  width: 700,
  height: 500,
  maximizable: false,
  constructor : function (config) {
    if (config.main_item.params_panel) {
        config.layout = 'border';
        config.main_item.region = 'center';
        config.main_item.params_panel.region = 'north';
        config.main_item.params_panel.hidden = config.main_item.params_panel_hidden;
        config.items = [config.main_item.params_panel, config.main_item];
    } else {
        config.layout = 'fit';
        config.items = config.main_item;
    }
    this.main_item = config.main_item; 
    
    delete config.main_item;
    //~ delete config.params_item;
    
    //~ this.main_item = config.items.get(0);
    this.main_item.containing_window = this;
    
    //~ console.log('20120110 Lino.Window.constructor() 1');
    //~ if (Lino.current_window) { // all windows except the top are closable
    if (this.main_item.hide_window_title) { 
      config.closable = false;
      config.frame = false;
      config.shadow = false;
      //~ config.border = true;
      //~ config.title = undefined;
      //~ config.tools = null;
      delete config.title;
      delete config.tools;
    } else {
      config.title = this.main_item.empty_title;
      config.closable = true;
      config.tools = [ 
        { qtip: 'permalink', handler: Lino.permalink_handler(this), id: "pin" }
      ];
      if (this.main_item.content_type && this.main_item.action_name != 'insert') {
        config.tools = [ {
          handler: Lino.help_text_editor,
          qtip: "Hilfetexte der Eingabefelder dieser Tabelle bearbeiten",
          scope: this.main_item,
          id: "gear"
        }].concat(config.tools);
      }
        
    //~ { qtip: '', handler: Lino.save_wc_handler(this), id: "save" }, 
    //~ { qtip: this.config.qtip, handler: Lino.save_wc_handler(this), id: "save" }, 
    //~ { qtip: 'Call doLayout() on main Container.', handler: Lino.refresh_handler(this), id: "refresh" },
    //~ if (this.main_item.params_panel) {
        //~ config.tools = config.tools.concat([ 
          //~ { qtip: 'Show/hide parameter panel', handler: this.toggle_params_panel, id: "gear", scope:this } 
        //~ ]);
    //~ }
    //~ if (config.closable !== false) {
      // if undefined, will take default behaviour
      //~ config.tools = config.tools.concat([ 
        //~ { qtip: 'close', handler: this.hide, id: "close", scope:this } 
      //~ ]);
    }
    
    this.main_item.config_containing_window(config);
    
    //~ console.log('20120110 Lino.Window.constructor() 2');
    Lino.Window.superclass.constructor.call(this,config);
    
    //~ console.log('20120110 Lino.Window.constructor() 3');
    
  },
  initComponent : function() {
    this.main_item.init_containing_window(this);
    Lino.Window.superclass.initComponent.call(this);
  
  },
  hide : function() { 
      this.main_item.do_when_clean(false,function() { 
        Lino.close_window(); });
  },
  hide_really : function() { 
    Lino.Window.superclass.hide.call(this);
  },
  onRender : function(ct, position){
    //~ console.log('20120110 Lino.Window.onRender() 1');
    Lino.Window.superclass.onRender.call(this, ct, position);
    var main_area = Ext.getCmp('main_area')
    //~ console.log('20120110 Lino.Window.onRender() 2');
  
    this.on('show', function(win) {
        //~ console.log('20120110 Lino.Window.on show 1');
        main_area.on('resize', win.onWindowResize, win);
    });
    this.on('hide', function(win) {
        main_area.un('resize', win.onWindowResize, win);
    });
    //~ console.log('20120110 Lino.Window.onRender() 3');
  }
});


Lino.unused_ParamWindow = Ext.extend(Lino.Window,{
  //~ layout: "border", 
  constructor : function (config) {
    Lino.ParamWindow.superclass.constructor.call(this,config);
    this.main_item = config.items; // `items` must be a single component
    config.layout = 'border';
    this.main_item.region = 'center';
    config.params.region = 'north';
    config.items = [config.params, config.items];
    //~ delete config.params;
  }
});




(function(){
    var ns = Ext.ns('Ext.ux.plugins');

    /**
     * @class Ext.ux.plugins.DefaultButton
     * @extends Object
     *
     * Plugin for Button that will click() the button if the user presses ENTER while
     * a component in the button's form has focus.
     *
     * @author Stephen Friedrich
     * @date 09-DEC-2009
     * @version 0.1
     *
     */
    ns.DefaultButton =  Ext.extend(Object, {
        init: function(button) {
            button.on('afterRender', setupKeyListener, button);
        }
    });

    function setupKeyListener() {
        var formPanel = this.findParentByType('form');
        new Ext.KeyMap(formPanel.el, {
            key: Ext.EventObject.ENTER,
            shift: false,
            alt: false,
            fn: function(keyCode, e){
                if(e.target.type === 'textarea' && !e.ctrlKey) {
                    return true;
                }

                this.el.select('button').item(0).dom.click();
                return false;
            },
            scope: this
        });
    }

    Ext.ComponentMgr.registerPlugin('defaultButton', ns.DefaultButton);

})(); 

Ext.override(Ext.form.BasicForm,{
    my_loadRecord : function(values){
    //~ loadRecord : function(record){
        /* Same as ExtJS's loadRecord() (setValues()), except that we 
        forward also the record to field.setValue() so that Lino.Combobox 
        can use it. 
        */
        //~ console.log('20120918 my_loadRecord',values)
        if(Ext.isArray(values)){ 
            for(var i = 0, len = values.length; i < len; i++){
                var v = values[i];
                var f = this.findField(v.id);
                if(f){
                    f.setValue(v.value,values);
                    if(this.trackResetOnLoad){
                        f.originalValue = f.getValue();
                    }
                }
            }
        }else{ 
            var field, id;
            for(id in values){
                if(!Ext.isFunction(values[id]) && (field = this.findField(id))){
                    field.setValue(values[id],values);
                    if(this.trackResetOnLoad){
                        field.originalValue = field.getValue();
                        //~ if (field.hiddenField) {
                          //~ field.hiddenField.originalValue = field.hiddenField.value;
                        //~ }
                    }
                }
            }
        }
        return this;
    }
});




function initializeFooBarDropZone(cmp) {
    //~ console.log('initializeFooBarDropZone',cmp);
    cmp.dropTarget = new Ext.dd.DropTarget(cmp.bwrap, {
      //~ ddGroup     : 'gridDDGroup',
      notifyEnter : function(ddSource, e, data) {
        console.log('notifyEnter',ddSource,e,data);
        //Add some flare to invite drop.
        cmp.body.stopFx();
        cmp.body.highlight();
      },
      notifyDrop  : function(ddSource, e, data){
        console.log('notifyDrop',ddSource,e,data);
        // Reference the record (single selection) for readability
        //~ var selectedRecord = ddSource.dragData.selections[0];


        // Load the record into the form
        //~ formPanel.getForm().my_loadRecord(selectedRecord);


        // Delete record from the grid.  not really required.
        //~ ddSource.grid.store.remove(selectedRecord);

        return(true);
      }
    })
}



Lino.show_mti_child = function(fieldname,detail_handler) {
  //~ console.log('show_mti_child',this);
  //~ console.log('show_mti_child',panel.find("main_area"));
  rec = Lino.current_window.main_item.get_current_record();
  //~ rec = panel.get_current_record();
  if (rec) {
    //~ console.log('show_mti_child',Lino.current_window,rec);
    if (rec.phantom) {
      Lino.notify('Not allowed on phantom record.');
    }else if (rec.data[fieldname]) {
      //~ console.log('show_mti_child',rec.id);
      //~ detail_handler(Lino.current_window.main_item,{},{record_id:rec.id});
      detail_handler.run(null,{record_id:rec.id});
      //~ window.open(urlroot + '/' + rec.id);
      //~ document.location = urlroot + '/' + rec.id;
      //~ window.open(urlroot + '/' + rec.id,'_blank');
    } else {
      Lino.alert("Kann MTI-Kind nicht anzeigen wenn Checkbox abgeschlatet ist.");
    }
  } else {
    Lino.notify('No current record.');
  }
};



Lino.davlink_open = function(webdavURL) {
  /* Calls lino.applets.davlink.DavLink.open()
  */
  //~ console.log('Going to call document.applets.DavLink.open(',webdavURL,')');
  var rv = document.applets.DavLink.open(webdavURL);
  if (rv) window.alert(rv);
}






/*
Mappings towards lino.modlib.cal.models.PanelCalendars
*/
// Sset SS = Ssite.modules.cal.PanelCalendars.get_handle(Sui).store
Ext.ensible.cal.CalendarMappings = {
    CalendarId:   {name:'ID',       mapping: 'id', type: 'int'},
    Title:        {name:'CalTitle', mapping: 'babel_name', type: 'string'},
    Description:  {name:'Desc',     mapping: 'description', type: 'string'},
    ColorId:      {name:'Color',    mapping: 'color', type: 'int'},
    IsHidden:     {name:'Hidden',   mapping: 'is_hidden', type: 'boolean'},    
};
Ext.ensible.cal.CalendarRecord.reconfigure();  


/*
Mappings towards lino.modlib.cal.models.PanelEvents 
*/
// Sset SS = Ssite.modules.cal.PanelEvents.get_handle(Sui).store
Ext.ensible.cal.EventMappings = {
    EventId:     {name: 'ID',        mapping: 'id', type:'int'},
    CalendarId:  {name: 'CalID',     mapping: 'calendarHidden', type: 'int'},
    Title:       {name: 'EvtTitle',  mapping: 'summary'},
    StartDate:   {name: 'StartDt',   mapping: 'start_dt', 
      type: 'date', 
      dateFormat: "Y-m-d\TH:i:s" },
    EndDate:     {name: 'EndDt',     mapping: 'end_dt', 
      type: 'date', 
      dateFormat: "Y-m-d\TH:i:s"},
    RRule:       {name: 'RecurRule', mapping: 'rsetHidden'},
    Location:    {name: 'Location',  mapping: 'placeHidden'},
    Notes:       {name: 'Desc',      mapping: 'description'},
    Url:         {name: 'LinkUrl',   mapping: 'url'},
    IsAllDay:    {name: 'AllDay',    mapping: 'all_day', type: 'boolean'},
    Reminder:    {name: 'Reminder',  mapping: 'reminder'}
    
};
Ext.ensible.cal.EventRecord.reconfigure();


Lino.on_eventclick = function(cp,rec,el) {
  //~ console.log("Lino.on_eventclick",arguments);
  //~ Lino.cal.Events.detail_action.run({record_id:rec.data.ID});
  Lino.cal.PanelEvents.detail.run(null,{record_id:rec.data.ID,base_params:Lino.eventStore.baseParams});
  return false;
}
    
Lino.on_editdetails = function(cp,rec,el) {
  //~ console.log("Lino.on_editdetails",arguments);
  if (rec.data.ID)
      //~ Lino.cal.Events.detail_action.run({record_id:rec.data.ID});
      Lino.cal.PanelEvents.detail.run(null,{record_id:rec.data.ID,base_params:Lino.eventStore.baseParams});
  return false;
}

Lino.format_time = function(dt) {
    return dt.getHours() + ':' + dt.getMinutes();
}
    
Lino.on_eventdelete = function() {
  //~ console.log("Lino.on_eventdelete",arguments);
};

Lino.on_eventadd  = function(cp,rec,el) {
  //~ console.log("Lino.on_eventadd ",arguments);
  return false;
}
    
Lino.on_eventresize  = function(cp,rec,el) {
  //~ console.log("Lino.on_eventresize ",arguments);
  //~ Lino.cal.Events.insert(cp);
  //~ return false;
}
    
Lino.on_eventupdate  = function(cp,rec,el) {
  //~ console.log("Lino.on_eventupdate",arguments);
  //~ Lino.cal.Events.insert(cp);
  //~ return false;
}
    

//~ Lino.eventStore = new Ext.ensible.cal.EventStore({ 
//~ Lino.eventStore = new Ext.data.ArrayStore({ 
Lino.eventStore = new Ext.data.JsonStore({ 
  listeners: { exception: Lino.on_store_exception }
  ,url: '/restful/cal/PanelEvents'
  ,restful : true
  ,proxy: new Ext.data.HttpProxy({ 
      url: '/restful/cal/PanelEvents', 
      disableCaching: false // no need for cache busting when loading via Ajax
      //~ disableCaching:true,
  })
  ,fields: Ext.ensible.cal.EventRecord.prototype.fields.getRange()
  ,totalProperty: "count"
  ,root: "rows"
  ,idProperty: Ext.ensible.cal.EventMappings.EventId.mapping
  ,writer : new Ext.data.JsonWriter({
    writeAllFields: false
  })
  ,load: function(options) {
    //~ foo.bar = baz; // 20120213
      if (!options) options = {};
      if (!options.params) options.params = {};
      //~ options.params.$ext_requests.URL_PARAM_TEAM_VIEW = Lino.calendar_app.team_view_button.pressed;
      
      var view = this.cal_panel.getActiveView();
      var bounds = view.getViewBounds();
      //~ var p = {sd:'05.02.2012',ed:'11.02.2012'};
      //~ var p = {};
      options.params[view.dateParamStart] = bounds.start.format(view.dateParamFormat);
      options.params[view.dateParamEnd] = bounds.end.format(view.dateParamFormat);
      Lino.insert_subst_user(options.params);
      //~ Ext.apply(options.params,p)
      //~ console.log('20120710 eventStore.load()',this.baseParams,options);
    
    return Ext.data.JsonStore.prototype.load.call(this,options);
  }
});

//~ Lino.calendarStore = new Ext.data.ArrayStore({ 
Lino.calendarStore = new Ext.data.JsonStore({ 
      listeners: { exception: Lino.on_store_exception }
      ,restful : true
      ,proxy: new Ext.data.HttpProxy({ 
          url: '/restful/cal/PanelCalendars?fmt=json', 
          disableCaching: false // no need for cache busting when loading via Ajax
          //~ restful : true
          //~ method: "GET"
      })
      //~ ,autoLoad: true
      //~ ,remoteSort: true
      //~ ,baseParams: bp
      ,totalProperty: "count"
      ,root: "rows"
      ,fields: Ext.ensible.cal.CalendarRecord.prototype.fields.getRange()
      ,idProperty: Ext.ensible.cal.CalendarMappings.CalendarId.mapping
      //~ ,idIndex: Ext.ensible.cal.CalendarMappings.CalendarId.mapping
    });


Lino.CalendarCfg = {
    dateParamFormat: 'd.m.Y',
    dateParamStart:'sd',
    dateParamEnd:'ed'
};
//~ 20120704 Lino.CalendarPanel = Ext.extend(Ext.ensible.cal.CalendarPanel,Lino.MainPanel);
//~ Lino.CalendarPanel = Ext.extend(Lino.CalendarPanel,{
Ext.override(Ext.ensible.cal.CalendarPanel,Lino.MainPanel);
Ext.override(Ext.ensible.cal.CalendarPanel,{
  //~ empty_title : "\$ui.get_actor('cal.Panel').report.label",
  empty_title : "Kalender"
  ,activeItem: 1 // 0: day, 1: week
  ,ls_url: '/cal/CalendarPanel'
  //~ ,disableCaching:true
  ,eventStore: Lino.eventStore
  ,calendarStore: Lino.calendarStore
  ,listeners: { 
    editdetails: Lino.on_editdetails
    ,eventclick: Lino.on_eventclick
    //~ ,eventadd: Lino.on_eventadd
    //~ ,eventdelete: Lino.on_eventdelete
    //~ ,eventresize: Lino.on_eventresize
    ,afterrender : function(config) {
      //~ console.log("20120704 afterrender");
      Lino.calendarStore.load();
      //~ console.log("20120704 afterrender calls eventStore.load()",p);
      Lino.eventStore.cal_panel = this;
      //~ Lino.eventStore.load({params:p});
      Lino.eventStore.load();
      //~ Lino.CalendarPanel.superclass.constructor.call(this, config);
      //~ console.log(20120118, config,this);
    }
    }
  ,enableEditDetails: false
  //~ ,monthViewCfg: Lino.CalendarCfg
  //~ ,weekViewCfg: Lino.CalendarCfg
  //~ ,multiDayViewCfg: Lino.CalendarCfg
  //~ ,multiWeekViewCfg: Lino.CalendarCfg
  //~ ,dayViewCfg: Lino.CalendarCfg
  //~ ,initComponent : function() {
    //~ // this.on('eventadd',Lino.on_eventadd);
    //~ Lino.CalendarPanel.superclass.initComponent.call(this);
  //~ }
});




Lino.CalendarAppPanel = Ext.extend(Ext.Panel,Lino.MainPanel);
Lino.CalendarAppPanel = Ext.extend(Lino.CalendarAppPanel,{
  //~ empty_title : "\$ui.get_actor('cal.Panel').report.label",
  empty_title : "Kalender"
  ,ls_url: '/cal/CalendarPanel'
  ,set_status : function(status) { this.refresh();}
  ,refresh : function() {Lino.eventStore.reload();}
  ,layout: 'fit'
  ,unused_is_loading : function() { 
      var loading = Lino.calendarStore.getCount() == 0 | Lino.eventStore.getCount() == 0
      //~ console.log("CalendarPanel loading:",loading);
      return loading; 
  }
  ,get_base_params : function() {
    var p = Ext.apply({},this.base_params);
    Lino.insert_subst_user(p);
    return p;
  }
  ,set_base_params : function(p) {
    this.base_params = Ext.apply({},p);
  }
  ,clear_base_params : function() {
      this.base_params = {};
      Lino.insert_subst_user(this.base_params);
  }
  ,set_base_param : function(k,v) {
      if (!this.base_params) this.base_params = {};
      this.base_params[k] = v;
  }
});

Lino.calendar_app = function() { return {
  get_main_panel : function() {
      return new Lino.CalendarAppPanel({ items : 
        //~ [{
          //~ id: 'app-header',
          //~ region: 'north',
          //~ height: 35,
          //~ border: false,
          // contentEl: 'app-header-content'
        //~ },
      {
          id: 'app-center',
          title: '...', // will be updated to the current view's date range
          region: 'center',
          layout: 'border',
          listeners: {
              'afterrender': function(){
                  Ext.getCmp('app-center').header.addClass('app-center-header');
              }
          },
          items: [{
              id:'app-west',
              region: 'west',
              width: 176,
              border: false,
              items: [{
                  xtype: 'datepicker',
                  id: 'app-nav-picker',
                  cls: 'ext-cal-nav-picker',
                  listeners: {
                      'select': {
                          fn: function(dp, dt){
                              Lino.calendarPanel.setStartDate(dt);
                          },
                          scope: this
                      }
                  }
              //~ },{ 
                //~ layout:'fit',
                //~ items: [
                  //~ new Ext.form.Checkbox({
                    //~ boxLabel:"$_('Team view')",
                    //~ hideLabel:true
                    //~ listeners: { click: }
                  //~ })
                //~ ]
              },{ 
                layout:'form',
                items: [
                  this.team_view_button = new Ext.Button({
                    text:"Team-Ansicht",
                    enableToggle:true,
                    pressed:false,
                    toggleHandler: function(btn,state) { 
                      //~ console.log('20120716 teamView.toggle()');
                      Lino.eventStore.setBaseParam('tv',state);
                      Lino.eventStore.load();
                      //~ Lino.eventStore.load({params:{$ext_requests.URL_PARAM_TEAM_VIEW:state}});
                      //~ console.log("team view",state);
                    }
                  })
                ]
              },{
                  xtype: 'extensible.calendarlist',
                  store: Lino.calendarStore,
                  border: false,
                  width: 175
              }]
          },{
              xtype: 'extensible.calendarpanel',
              eventStore: Lino.eventStore,
              calendarStore: Lino.calendarStore,
              border: false,
              id:'app-calendar',
              region: 'center',
              //~ activeItem: 3, // month view
              
              // Any generic view options that should be applied to all sub views:
              viewConfig: {
                  // Lino.CalendarCfg
                  dateParamFormat: 'd.m.Y',
                  dateParamStart:'sd',
                  dateParamEnd:'ed',
                
                  //enableFx: false,
                  //ddIncrement: 10, //only applies to DayView and subclasses, but convenient to put it here
                  viewStartHour: 8,
                  viewEndHour: 18
                  //minEventDisplayMinutes: 15
              },
              
              // View options specific to a certain view (if the same options exist in viewConfig
              // they will be overridden by the view-specific config):
              monthViewCfg: {
                  showHeader: true,
                  showWeekLinks: true,
                  showWeekNumbers: true,
                  eventBodyMarkup: ['{Title}',
                    //~ '<tpl if="url">',
                        //~ '<a href="{url}">XX</a>',
                    //~ '</tpl>',
                    '<tpl if="_isReminder">',
                        '<i class="ext-cal-ic ext-cal-ic-rem">&#160;</i>',
                    '</tpl>',
                    '<tpl if="_isRecurring">',
                        '<i class="ext-cal-ic ext-cal-ic-rcr">&#160;</i>',
                    '</tpl>',
                    '<tpl if="spanLeft">',
                        '<i class="ext-cal-spl">&#160;</i>',
                    '</tpl>',
                    '<tpl if="spanRight">',
                        '<i class="ext-cal-spr">&#160;</i>',
                    '</tpl>'
                ].join('')
              },
              
              multiWeekViewCfg: {
                  //weekCount: 3
              },
              
              // Some optional CalendarPanel configs to experiment with:
              //readOnly: true,
              //showDayView: false,
              //showMultiDayView: true,
              //showWeekView: false,
              //showMultiWeekView: false,
              //showMonthView: false,
              //showNavBar: false,
              //showTodayText: false,
              //showTime: false,
              //editModal: true,
              //enableEditDetails: false,
              //title: 'My Calendar', // the header of the calendar, could be a subtitle for the app
              
              // Once this component inits it will set a reference to itself as an application
              // member property for easy reference in other functions within App.
              initComponent: function() {
                  Lino.calendarPanel = this;
                  this.constructor.prototype.initComponent.apply(this, arguments);
              },
              
              listeners: {
                  //~ 'eventclick': {
                      //~ fn: function(vw, rec, el){
                          //~ this.clearMsg();
                      //~ },
                      //~ scope: this
                  //~ },
                  'eventover': function(vw, rec, el){
                      //console.log('Entered evt rec='+rec.data[Ext.ensible.cal.EventMappings.Title.name]', view='+ vw.id +', el='+el.id);
                  },
                  'eventout': function(vw, rec, el){
                      //console.log('Leaving evt rec='+rec.data[Ext.ensible.cal.EventMappings.Title.name]+', view='+ vw.id +', el='+el.id);
                  },
                  'eventadd': {
                      fn: function(cp, rec){
                          this.showMsg('Event '+ rec.data[Ext.ensible.cal.EventMappings.Title.name] +' was added');
                      },
                      scope: this
                  },
                  'eventupdate': {
                      fn: function(cp, rec){
                          this.showMsg('Event '+ rec.data[Ext.ensible.cal.EventMappings.Title.name] +' was updated');
                      },
                      scope: this
                  },
                  'eventdelete': {
                      fn: function(cp, rec){
                          //this.eventStore.remove(rec);
                          this.showMsg('Event '+ rec.data[Ext.ensible.cal.EventMappings.Title.name] +' was deleted');
                      },
                      scope: this
                  },
                  'eventcancel': {
                      fn: function(cp, rec){
                          // edit canceled
                      },
                      scope: this
                  },
                  'viewchange': {
                      fn: function(p, vw, dateInfo){
                          if(this.editWin){
                              this.editWin.hide();
                          };
                          if(dateInfo !== null){
                              // will be null when switching to the event edit form so ignore
                              Ext.getCmp('app-nav-picker').setValue(dateInfo.activeDate);
                              this.updateTitle(dateInfo.viewStart, dateInfo.viewEnd);
                          }
                      },
                      scope: this
                  },
                  'dayclick': {
                      fn: function(vw, dt, ad, el){
                          this.clearMsg();
                      },
                      scope: this
                  },
                  'rangeselect': {
                      fn: function(vw, dates, onComplete){
                          this.clearMsg();
                      },
                      scope: this
                  },
                  'eventmove': {
                      fn: function(vw, rec){
                          rec.commit();
                          var time = rec.data[Ext.ensible.cal.EventMappings.IsAllDay.name] ? '' : ' \\a\\t g:i a';
                          this.showMsg('Event '+ rec.data[Ext.ensible.cal.EventMappings.Title.name] +' was moved to '+
                              rec.data[Ext.ensible.cal.EventMappings.StartDate.name].format('F jS'+time));
                      },
                      scope: this
                  },
                  'eventresize': {
                      fn: function(vw, rec){
                          rec.commit();
                          this.showMsg('Event '+ rec.data[Ext.ensible.cal.EventMappings.Title.name] +' was updated');
                      },
                      scope: this
                  },
                  'eventdelete': {
                      fn: function(win, rec){
                          Lino.eventStore.remove(rec);
                          this.showMsg('Event '+ rec.data[Ext.ensible.cal.EventMappings.Title.name] +' was deleted');
                      },
                      scope: this
                  },
                  'initdrag': {
                      fn: function(vw){
                          if(this.editWin && this.editWin.isVisible()){
                              this.editWin.hide();
                          }
                      },
                      scope: this
                  }
              }
          }]
        }
        //~ ]
        
      });
      
  }
  ,updateTitle: function(startDt, endDt){
      var p = Ext.getCmp('app-center');
      
      if(startDt.clearTime().getTime() == endDt.clearTime().getTime()){
          p.setTitle(startDt.format('F j, Y'));
      }
      else if(startDt.getFullYear() == endDt.getFullYear()){
          if(startDt.getMonth() == endDt.getMonth()){
              p.setTitle(startDt.format('F j') + ' - ' + endDt.format('j, Y'));
          }
          else{
              p.setTitle(startDt.format('F j') + ' - ' + endDt.format('F j, Y'));
          }
      }
      else{
          p.setTitle(startDt.format('F j, Y') + ' - ' + endDt.format('F j, Y'));
      }
  }
  // This is an application-specific way to communicate CalendarPanel event messages back to the user.
  // This could be replaced with a function to do "toast" style messages, growl messages, etc. This will
  // vary based on application requirements, which is why it's not baked into the CalendarPanel.
  ,showMsg: function(msg){
      Lino.notify(msg);
      //~ Ext.fly('app-msg').update(msg).removeClass('x-hidden');
  }
  
  ,clearMsg: function(){
      Lino.notify('');
      //~ Ext.fly('app-msg').update('').addClass('x-hidden');
  }
}
}();




/*
captureEvents utility by Aaron Conran
<http://www.sencha.com/learn/grid-faq/>

Ext.onReady(function(){
    var grid = new Ext.grid.GridPanel({
        ... 
    });
    captureEvents(grid);
});
*/
function captureEvents(observable) {
    Ext.util.Observable.capture(
        observable,
        function(eventName) {
            console.info(eventName);
        },
        this
    );		
}
 






Lino.main_menu = [ { "menu": { "items": [ { "text": "Personen", "handler": function() {Lino.contacts.Persons.grid.run(null)} }, { "text": " \u25b6 Klienten", "handler": function() {Lino.pcsw.Clients.grid.run(null)} }, { "text": "Organisationen", "handler": function() {Lino.contacts.Companies.grid.run(null)} }, { "text": "Haushalte", "handler": function() {Lino.households.Households.grid.run(null)} }, "-", { "text": "Partner (alle)", "handler": function() {Lino.contacts.Partners.grid.run(null)} } ] }, "text": "Kontakte" }, { "menu": { "items": [ { "text": "Expected Guests", "handler": function() {Lino.reception.ExpectedGuests.grid.run(null)} }, { "text": "Waiting Guests", "listeners": { "render": Lino.quicktip_renderer("Foo","Shows the visitors in the waiting room.") }, "handler": function() {Lino.reception.WaitingGuests.grid.run(null)} } ] }, "text": "Kalender" }, { "menu": { "items": [ { "menu": { "items": [ { "text": "L\u00e4nder", "listeners": { "render": Lino.quicktip_renderer("Foo","\n    A country is a geographic entity considered a \"nation\".\n    ") }, "handler": function() {Lino.countries.Countries.grid.run(null)} }, { "text": "Sprachen", "handler": function() {Lino.countries.Languages.grid.run(null)} } ] }, "text": "Kontakte" } ] }, "text": "Konfigurierung" }, { "menu": { "items": [ { "text": "Info", "listeners": { "render": Lino.quicktip_renderer("Foo","Zeigt Informationen \u00fcber diese Site an.") }, "handler": function() {Lino.about.About.show.run(null,{ "record_id": -99998 })} } ] }, "text": "Site" }, { "text": "Startseite", "handler": function() {Lino.close_all_windows()} } ];
Ext.namespace('Lino.system.SiteConfigs')
Ext.namespace('Lino.system.ContentTypes')
Ext.namespace('Lino.system.HelpTexts')
Ext.namespace('Lino.system.TextFieldTemplates')
Ext.namespace('Lino.users.Users')
Ext.namespace('Lino.users.MySettings')
Ext.namespace('Lino.users.UsersOverview')
Ext.namespace('Lino.users.Teams')
Ext.namespace('Lino.users.Memberships')
Ext.namespace('Lino.users.Authorities')
Ext.namespace('Lino.changes.Changes')
Ext.namespace('Lino.countries.Languages')
Ext.namespace('Lino.countries.Countries')
Ext.namespace('Lino.countries.Cities')
Ext.namespace('Lino.properties.PropGroups')
Ext.namespace('Lino.properties.PropTypes')
Ext.namespace('Lino.properties.Properties')
Ext.namespace('Lino.properties.PropChoices')
Ext.namespace('Lino.contacts.CompanyTypes')
Ext.namespace('Lino.contacts.Partners')
Ext.namespace('Lino.contacts.Companies')
Ext.namespace('Lino.contacts.RoleTypes')
Ext.namespace('Lino.contacts.Roles')
Ext.namespace('Lino.contacts.Persons')
Ext.namespace('Lino.postings.Postings')
Ext.namespace('Lino.postings.PostingsByState')
Ext.namespace('Lino.postings.PostingsReady')
Ext.namespace('Lino.postings.PostingsPrinted')
Ext.namespace('Lino.postings.PostingsSent')
Ext.namespace('Lino.outbox.Recipients')
Ext.namespace('Lino.outbox.Mails')
Ext.namespace('Lino.outbox.Attachments')
Ext.namespace('Lino.cal.Calendars')
Ext.namespace('Lino.cal.Subscriptions')
Ext.namespace('Lino.cal.Rooms')
Ext.namespace('Lino.cal.Priorities')
Ext.namespace('Lino.cal.Events')
Ext.namespace('Lino.cal.MyEvents')
Ext.namespace('Lino.cal.MyUnclearEvents')
Ext.namespace('Lino.cal.EventsAssignedToMe')
Ext.namespace('Lino.cal.MyEventsToday')
Ext.namespace('Lino.cal.Tasks')
Ext.namespace('Lino.cal.GuestRoles')
Ext.namespace('Lino.cal.Guests')
Ext.namespace('Lino.cal.PanelCalendars')
Ext.namespace('Lino.cal.PanelEvents')
Ext.namespace('Lino.uploads.UploadTypes')
Ext.namespace('Lino.uploads.Uploads')
Ext.namespace('Lino.reception.ExpectedGuests')
Ext.namespace('Lino.reception.WaitingGuests')
Ext.namespace('Lino.households.Types')
Ext.namespace('Lino.households.Households')
Ext.namespace('Lino.households.Roles')
Ext.namespace('Lino.households.Members')
Ext.namespace('Lino.accounts.Charts')
Ext.namespace('Lino.accounts.Groups')
Ext.namespace('Lino.accounts.Accounts')
Ext.namespace('Lino.notes.NoteTypes')
Ext.namespace('Lino.notes.EventTypes')
Ext.namespace('Lino.notes.Notes')
Ext.namespace('Lino.cv.LanguageKnowledges')
Ext.namespace('Lino.cv.PersonProperties')
Ext.namespace('Lino.pcsw.Clients')
Ext.namespace('Lino.pcsw.DebtsClients')
Ext.namespace('Lino.pcsw.IntegClients')
Ext.namespace('Lino.pcsw.ClientsTest')
Ext.namespace('Lino.pcsw.PersonGroups')
Ext.namespace('Lino.pcsw.Activities')
Ext.namespace('Lino.pcsw.DispenseReasons')
Ext.namespace('Lino.pcsw.Dispenses')
Ext.namespace('Lino.pcsw.ExclusionTypes')
Ext.namespace('Lino.pcsw.Exclusions')
Ext.namespace('Lino.pcsw.AidTypes')
Ext.namespace('Lino.pcsw.ClientContactTypes')
Ext.namespace('Lino.pcsw.ClientContacts')
Ext.namespace('Lino.pcsw.CoachingTypes')
Ext.namespace('Lino.pcsw.CoachingEndings')
Ext.namespace('Lino.pcsw.Coachings')
Ext.namespace('Lino.isip.ContractTypes')
Ext.namespace('Lino.isip.ExamPolicies')
Ext.namespace('Lino.isip.ContractEndings')
Ext.namespace('Lino.isip.StudyTypes')
Ext.namespace('Lino.isip.Contracts')
Ext.namespace('Lino.isip.MyContracts')
Ext.namespace('Lino.jobs.Schedules')
Ext.namespace('Lino.jobs.Regimes')
Ext.namespace('Lino.jobs.JobProviders')
Ext.namespace('Lino.jobs.ContractTypes')
Ext.namespace('Lino.jobs.Sectors')
Ext.namespace('Lino.jobs.Functions')
Ext.namespace('Lino.jobs.Contracts')
Ext.namespace('Lino.jobs.MyContracts')
Ext.namespace('Lino.jobs.Offers')
Ext.namespace('Lino.jobs.Studies')
Ext.namespace('Lino.jobs.Experiences')
Ext.namespace('Lino.jobs.Candidatures')
Ext.namespace('Lino.jobs.Jobs')
Ext.namespace('Lino.jobs.JobTypes')
Ext.namespace('Lino.jobs.ContractsSearch')
Ext.namespace('Lino.courses.CourseProviders')
Ext.namespace('Lino.courses.CourseContents')
Ext.namespace('Lino.courses.Courses')
Ext.namespace('Lino.courses.CourseOffers')
Ext.namespace('Lino.courses.CourseRequests')
Ext.namespace('Lino.courses.PendingCourseRequests')
Ext.namespace('Lino.integ.CoachingEndingsByUser')
Ext.namespace('Lino.integ.CoachingEndingsByType')
Ext.namespace('Lino.integ.ContractEndingsByType')
Ext.namespace('Lino.integ.JobsContractEndingsByType')
Ext.namespace('Lino.integ.ContractsPerUserAndContractType')
Ext.namespace('Lino.integ.JobsContractsPerUserAndContractType')
Ext.namespace('Lino.integ.StudyTypesAndContracts')
Ext.namespace('Lino.integ.CompaniesAndContracts')
Ext.namespace('Lino.integ.JobProvidersAndContracts')
Ext.namespace('Lino.newcomers.Brokers')
Ext.namespace('Lino.newcomers.Faculties')
Ext.namespace('Lino.newcomers.Competences')
Ext.namespace('Lino.newcomers.NewClients')
Ext.namespace('Lino.newcomers.AvailableCoaches')
Ext.namespace('Lino.debts.Budgets')
Ext.namespace('Lino.debts.Actors')
Ext.namespace('Lino.debts.Entries')
Ext.namespace('Lino.debts.EntriesByType')
Ext.namespace('Lino.cbss.Sectors')
Ext.namespace('Lino.cbss.Purposes')
Ext.namespace('Lino.cbss.IdentifyPersonRequests')
Ext.namespace('Lino.cbss.ManageAccessRequests')
Ext.namespace('Lino.cbss.RetrieveTIGroupsRequests')
Ext.namespace('Lino.sessions.SessionTable')
Ext.namespace('Lino.system.MyTextFieldTemplates')
Ext.namespace('Lino.users.MembershipsByUser')
Ext.namespace('Lino.users.AuthoritiesGiven')
Ext.namespace('Lino.users.AuthoritiesTaken')
Ext.namespace('Lino.countries.CitiesByCity')
Ext.namespace('Lino.countries.CitiesByCountry')
Ext.namespace('Lino.properties.PropsByGroup')
Ext.namespace('Lino.properties.PropsByType')
Ext.namespace('Lino.properties.ChoicesByType')
Ext.namespace('Lino.contacts.PartnersByCity')
Ext.namespace('Lino.contacts.PartnersByCountry')
Ext.namespace('Lino.contacts.RolesByCompany')
Ext.namespace('Lino.contacts.RolesByPerson')
Ext.namespace('Lino.postings.MyPostings')
Ext.namespace('Lino.postings.PostingsByPartner')
Ext.namespace('Lino.postings.PostingsByProject')
Ext.namespace('Lino.outbox.RecipientsByMail')
Ext.namespace('Lino.outbox.MyOutbox')
Ext.namespace('Lino.outbox.MailsByUser')
Ext.namespace('Lino.outbox.MailsByProject')
Ext.namespace('Lino.outbox.SentByPartner')
Ext.namespace('Lino.outbox.AttachmentsByMail')
Ext.namespace('Lino.cal.SubscriptionsByCalendar')
Ext.namespace('Lino.cal.SubscriptionsByUser')
Ext.namespace('Lino.cal.EventsByCalendar')
Ext.namespace('Lino.cal.EventsByRoom')
Ext.namespace('Lino.cal.EventsByProject')
Ext.namespace('Lino.cal.TasksByUser')
Ext.namespace('Lino.cal.MyTasks')
Ext.namespace('Lino.cal.MyTasksToDo')
Ext.namespace('Lino.cal.TasksByProject')
Ext.namespace('Lino.cal.GuestsByEvent')
Ext.namespace('Lino.cal.GuestsByRole')
Ext.namespace('Lino.cal.GuestsByPartner')
Ext.namespace('Lino.cal.MyPresences')
Ext.namespace('Lino.cal.MyPendingInvitations')
Ext.namespace('Lino.uploads.MyUploads')
Ext.namespace('Lino.households.HouseholdsByType')
Ext.namespace('Lino.households.MembersByHousehold')
Ext.namespace('Lino.households.MembersByPerson')
Ext.namespace('Lino.households.MembersByRole')
Ext.namespace('Lino.accounts.GroupsByChart')
Ext.namespace('Lino.accounts.AccountsByGroup')
Ext.namespace('Lino.notes.MyNotes')
Ext.namespace('Lino.notes.NotesByType')
Ext.namespace('Lino.notes.NotesByEventType')
Ext.namespace('Lino.notes.NotesByProject')
Ext.namespace('Lino.cv.LanguageKnowledgesByPerson')
Ext.namespace('Lino.cv.KnowledgesByLanguage')
Ext.namespace('Lino.cv.PropsByPerson')
Ext.namespace('Lino.cv.PersonPropsByProp')
Ext.namespace('Lino.cv.ConfiguredPropsByPerson')
Ext.namespace('Lino.cv.SkillsByPerson')
Ext.namespace('Lino.cv.SoftSkillsByPerson')
Ext.namespace('Lino.cv.ObstaclesByPerson')
Ext.namespace('Lino.pcsw.ClientsByNationality')
Ext.namespace('Lino.pcsw.DispensesByClient')
Ext.namespace('Lino.pcsw.ExclusionsByClient')
Ext.namespace('Lino.pcsw.ContactsByClient')
Ext.namespace('Lino.pcsw.CoachingsByClient')
Ext.namespace('Lino.pcsw.CoachingsByUser')
Ext.namespace('Lino.pcsw.CoachingsByEnding')
Ext.namespace('Lino.pcsw.NotesByPerson')
Ext.namespace('Lino.pcsw.NotesByCompany')
Ext.namespace('Lino.isip.ContractsByPerson')
Ext.namespace('Lino.isip.ContractsByPolicy')
Ext.namespace('Lino.isip.ContractsByType')
Ext.namespace('Lino.isip.ContractsByEnding')
Ext.namespace('Lino.isip.ContractsByStudyType')
Ext.namespace('Lino.jobs.FunctionsBySector')
Ext.namespace('Lino.jobs.ContractsByPerson')
Ext.namespace('Lino.jobs.ContractsByProvider')
Ext.namespace('Lino.jobs.ContractsByPolicy')
Ext.namespace('Lino.jobs.ContractsByEnding')
Ext.namespace('Lino.jobs.ContractsByJob')
Ext.namespace('Lino.jobs.ContractsByRegime')
Ext.namespace('Lino.jobs.ContractsBySchedule')
Ext.namespace('Lino.jobs.StudiesByCountry')
Ext.namespace('Lino.jobs.StudiesByCity')
Ext.namespace('Lino.jobs.StudiesByPerson')
Ext.namespace('Lino.jobs.ExperiencesByFunction')
Ext.namespace('Lino.jobs.ExperiencesByPerson')
Ext.namespace('Lino.jobs.CandidaturesByPerson')
Ext.namespace('Lino.jobs.CandidaturesBySector')
Ext.namespace('Lino.jobs.CandidaturesByFunction')
Ext.namespace('Lino.jobs.CandidaturesByJob')
Ext.namespace('Lino.jobs.CandidaturesByOffer')
Ext.namespace('Lino.jobs.ExperiencesByOffer')
Ext.namespace('Lino.jobs.JobsByProvider')
Ext.namespace('Lino.jobs.JobsByType')
Ext.namespace('Lino.jobs.ContractsByType')
Ext.namespace('Lino.jobs.JobsOverviewByType')
Ext.namespace('Lino.courses.CoursesByOffer')
Ext.namespace('Lino.courses.CourseOffersByProvider')
Ext.namespace('Lino.courses.CourseOffersByContent')
Ext.namespace('Lino.courses.CourseRequestsByPerson')
Ext.namespace('Lino.courses.CourseRequestsByContent')
Ext.namespace('Lino.courses.RequestsByCourse')
Ext.namespace('Lino.courses.ParticipantsByCourse')
Ext.namespace('Lino.courses.CandidatesByCourse')
Ext.namespace('Lino.newcomers.CompetencesByUser')
Ext.namespace('Lino.newcomers.CompetencesByFaculty')
Ext.namespace('Lino.newcomers.MyCompetences')
Ext.namespace('Lino.newcomers.ClientsByFaculty')
Ext.namespace('Lino.newcomers.AvailableCoachesByClient')
Ext.namespace('Lino.debts.MyBudgets')
Ext.namespace('Lino.debts.BudgetsByPartner')
Ext.namespace('Lino.debts.ActorsByBudget')
Ext.namespace('Lino.debts.ActorsByPartner')
Ext.namespace('Lino.debts.EntriesByBudget')
Ext.namespace('Lino.debts.ExpensesByBudget')
Ext.namespace('Lino.debts.IncomesByBudget')
Ext.namespace('Lino.debts.LiabilitiesByBudget')
Ext.namespace('Lino.debts.AssetsByBudget')
Ext.namespace('Lino.debts.DistByBudget')
Ext.namespace('Lino.cbss.MyIdentifyPersonRequests')
Ext.namespace('Lino.cbss.IdentifyRequestsByPerson')
Ext.namespace('Lino.cbss.ManageAccessRequestsByPerson')
Ext.namespace('Lino.cbss.MyManageAccessRequests')
Ext.namespace('Lino.cbss.RetrieveTIGroupsRequestsByPerson')
Ext.namespace('Lino.cbss.MyRetrieveTIGroupsRequests')
Ext.namespace('Lino.uploads.UploadsByController')
Ext.namespace('Lino.postings.PostingsByController')
Ext.namespace('Lino.system.HelpTextsByModel')
Ext.namespace('Lino.cal.TasksByController')
Ext.namespace('Lino.outbox.MailsByController')
Ext.namespace('Lino.changes.ChangesByMaster')
Ext.namespace('Lino.outbox.AttachmentsByController')
Ext.namespace('Lino.cal.EventsByController')
Ext.namespace('Lino.about.Models')
Ext.namespace('Lino.about.FieldsByModel')
Ext.namespace('Lino.about.Inspector')
Ext.namespace('Lino.about.SourceFiles')
Ext.namespace('Lino.pcsw.UsersWithClients')
Ext.namespace('Lino.integ.CompareRequestsTable')
Ext.namespace('Lino.integ.PeriodicNumbers')
Ext.namespace('Lino.debts.PrintEntriesByBudget')
Ext.namespace('Lino.debts.PrintExpensesByBudget')
Ext.namespace('Lino.debts.PrintIncomesByBudget')
Ext.namespace('Lino.debts.PrintLiabilitiesByBudget')
Ext.namespace('Lino.debts.PrintAssetsByBudget')
Ext.namespace('Lino.debts.SummaryTable')
Ext.namespace('Lino.debts.ResultByBudget')
Ext.namespace('Lino.debts.DebtsByBudget')
Ext.namespace('Lino.debts.BailiffDebtsByBudget')
Ext.namespace('Lino.cbss.IdentifyPersonResult')
Ext.namespace('Lino.cbss.RetrieveTIGroupsResult')
Ext.namespace('Lino.lino.Report')
Ext.namespace('Lino.about.About')
Ext.namespace('Lino.system.Home')
Ext.namespace('Lino.cal.CalendarPanel')
Ext.namespace('Lino.lino.Home')
Ext.namespace('Lino.jobs.OldJobsOverview')
Ext.namespace('Lino.jobs.JobsOverview')
Ext.namespace('Lino.integ.ActivityReport')
Ext.namespace('Lino.courses.CourseRequestStates')
Ext.namespace('Lino.postings.PostingStates')
Ext.namespace('Lino.cal.DurationUnits')
Ext.namespace('Lino.cal.TaskStates')
Ext.namespace('Lino.cal.Weekdays')
Ext.namespace('Lino.lino.UserLevels')
Ext.namespace('Lino.pcsw.CoachingEvents')
Ext.namespace('Lino.lino.YesNo')
Ext.namespace('Lino.cal.EventStates')
Ext.namespace('Lino.accounts.AccountTypes')
Ext.namespace('Lino.cal.Recurrencies')
Ext.namespace('Lino.properties.HowWell')
Ext.namespace('Lino.cv.CefLevel')
Ext.namespace('Lino.jobs.CandidatureStates')
Ext.namespace('Lino.outbox.RecipientType')
Ext.namespace('Lino.cal.GuestStates')
Ext.namespace('Lino.pcsw.BeIdCardTypes')
Ext.namespace('Lino.pcsw.CivilState')
Ext.namespace('Lino.pcsw.ClientStates')
Ext.namespace('Lino.countries.CityTypes')
Ext.namespace('Lino.properties.DoYouLike')
Ext.namespace('Lino.cbss.RequestLanguages')
Ext.namespace('Lino.cbss.ManageAction')
Ext.namespace('Lino.pcsw.RefusalReasons')
Ext.namespace('Lino.lino.UserGroups')
Ext.namespace('Lino.cbss.RequestStates')
Ext.namespace('Lino.lino.ChangeTypes')
Ext.namespace('Lino.cal.AccessClasses')
Ext.namespace('Lino.cbss.QueryRegister')
Ext.namespace('Lino.isip.ContractEvents')
Ext.namespace('Lino.lino.Genders')
Ext.namespace('Lino.pcsw.ClientEvents')
Ext.namespace('Lino.lino.UserProfiles')
Ext.namespace('Lino.pcsw.ResidenceType')

// ChoiceLists: 
Lino.courses.CourseRequestStates = [ [ "10", "Offen" ], [ "20", "Eingetragen" ], [ "30", "Bestanden" ], [ "40", "Gut bestanden" ], [ "50", "Nicht bestanden" ], [ "60", "Abgebrochen" ], [ "70", "Inaktiv" ] ];
Lino.postings.PostingStates = [ [ "10", "In Bearbeitung" ], [ "20", "Bereit f\u00fcr Ausdruck" ], [ "30", "Ausgedruckt" ], [ "40", "Versendet" ], [ "50", "Retour" ] ];
Lino.cal.DurationUnits = [ [ "s", "Sekunden" ], [ "m", "Minuten" ], [ "h", "Stunden" ], [ "D", "Tage" ], [ "W", "Wochen" ], [ "M", "Monate" ], [ "Y", "Jahre" ] ];
Lino.cal.TaskStates = [ [ "10", "Zu tun" ], [ "20", "Begonnen" ], [ "30", "Erledigt" ], [ "50", "Storniert" ] ];
Lino.cal.Weekdays = [ [ "1", "Montag" ], [ "2", "Dienstag" ], [ "3", "Mittwoch" ], [ "4", "Donnerstag" ], [ "5", "Freitag" ], [ "6", "Samstag" ], [ "7", "Sonntag" ] ];
Lino.lino.UserLevels = [ [ "10", "Gast" ], [ "20", "Sekret\u00e4r" ], [ "30", "Benutzer" ], [ "40", "Manager" ], [ "50", "Verwalter" ], [ "90", "Experte" ] ];
Lino.pcsw.CoachingEvents = [ [ "10", "Begonnen" ], [ "20", "Aktiv" ], [ "30", "Beendet" ] ];
Lino.lino.YesNo = [ [ "y", "Ja" ], [ "n", "Nein" ] ];
Lino.cal.EventStates = [ [ "10", "Vorgeschlagen" ], [ "20", "Entwurf" ], [ "40", "Geplant" ], [ "50", "Stattgefunden" ], [ "60", "Verschoben" ], [ "70", "Storniert" ] ];
Lino.accounts.AccountTypes = [ [ "A", "Verm\u00f6gen" ], [ "L", "Verpflichtungen" ], [ "I", "Eink\u00fcnfte" ], [ "E", "Ausgaben" ], [ "C", "Kapital" ], [ "B", "Bankkonten" ] ];
Lino.cal.Recurrencies = [ [ "D", "t\u00e4glich" ], [ "W", "w\u00f6chentlich" ], [ "M", "monatlich" ], [ "Y", "j\u00e4hrlich" ], [ "P", "pro Wochentag" ] ];
Lino.properties.HowWell = [ [ "0", "gar nicht" ], [ "1", "ein bisschen" ], [ "2", "mittelm\u00e4\u00dfig" ], [ "3", "gut" ], [ "4", "sehr gut" ] ];
Lino.cv.CefLevel = [ [ "A1", "A1 (Elementare Sprachverwendung)" ], [ "A2", "A2 (Elementare Sprachverwendung)" ], [ "A2+", "A2+ (Elementare Sprachverwendung)" ], [ "B1", "B1 (Selbstst\u00e4ndige Sprachverwendung)" ], [ "B2", "B2 (Selbstst\u00e4ndige Sprachverwendung)" ], [ "B2+", "B2+ (Selbstst\u00e4ndige Sprachverwendung)" ], [ "C1", "C1 (Exzellente Sprachverwendung)" ], [ "C2", "C2 (Exzellente Sprachverwendung)" ], [ "C2+", "C2+ (Exzellente Sprachverwendung)" ] ];
Lino.jobs.CandidatureStates = [ [ "10", "Aktiv" ], [ "20", "Probezeit" ], [ "25", "Probezeit ohne Erfolg" ], [ "27", "Arbeitet" ], [ "30", "Inaktiv" ] ];
Lino.outbox.RecipientType = [ [ "to", "Empf\u00e4nger" ], [ "cc", "Kopie an" ], [ "bcc", "Blindkopie an" ] ];
Lino.cal.GuestStates = [ [ "10", "Eingeladen" ], [ "20", "Zugesagt" ], [ "30", "Abgesagt" ], [ "40", "Anwesend" ], [ "50", "Abwesend" ] ];
Lino.pcsw.BeIdCardTypes = [ [ "1", "Belgischer Staatsb\u00fcrger" ], [ "6", "Kind unter 12 Jahren" ], [ "11", "A (Bescheinigung der Eintragung im Ausl\u00e4nderregister - Vor\u00fcbergehender Aufenthalt)" ], [ "12", "B (Bescheinigung der Eintragung im Ausl\u00e4nderregister)" ], [ "13", "C (Personalausweis f\u00fcr Ausl\u00e4nder)" ], [ "14", "D (Daueraufenthalt - EG)" ], [ "15", "E (Anmeldebescheinigung)" ], [ "16", "E+" ], [ "17", "F (Aufenthaltskarte f\u00fcr Familienangeh\u00f6rige eines Unionsb\u00fcrgers)" ], [ "18", "F+" ] ];
Lino.pcsw.CivilState = [ [ "10", "Ledig" ], [ "13", "Ledig zusammenwohnend" ], [ "18", "Ledig mit Kind" ], [ "20", "Verheiratet" ], [ "21", "Verheirated (allein lebend)" ], [ "22", "Verheirated (mit anderem Partner lebend)" ], [ "30", "Verwitwet" ], [ "33", "Verwitwet (zusammenwohnend)" ], [ "40", "Geschieden" ], [ "50", "Getrennt von Tisch und Bett" ] ];
Lino.pcsw.ClientStates = [ [ "10", "Neuantrag" ], [ "20", "Abgelehnt" ], [ "30", "Begleitet" ], [ "50", "Ehemalig" ] ];
Lino.countries.CityTypes = [ [ "10", "Bundesland" ], [ "11", "Division" ], [ "12", "Region" ], [ "13", "Gemeinschaft" ], [ "14", "Territorium" ], [ "20", "Regierungsbezirk" ], [ "21", "Provinz" ], [ "22", "Grafschaft" ], [ "23", "Unterregion" ], [ "24", "Departement" ], [ "25", "Arrondissement" ], [ "26", "Pr\u00e4fektur" ], [ "27", "Distrikt" ], [ "28", "Sektor" ], [ "50", "Stadt" ], [ "51", "Kleinstadt" ], [ "52", "Gemeinde" ], [ "54", "Pfarre" ], [ "55", "Stadtteil" ], [ "56", "Viertel" ], [ "61", "Ortschaft" ], [ "62", "Kleine Ortschaft" ], [ "70", "Dorf" ] ];
Lino.properties.DoYouLike = [ [ "0", "blo\u00df nicht" ], [ "1", "eher nicht" ], [ "2", "normal" ], [ "3", "gerne" ], [ "4", "sehr gerne" ] ];
Lino.cbss.RequestLanguages = [ [ "nl", "Niederl\u00e4ndisch" ], [ "fr", "Franz\u00f6sisch" ], [ "de", "Deutsch" ] ];
Lino.cbss.ManageAction = [ [ "1", "Registrieren" ], [ "2", "Austragen" ], [ "3", "Auflisten" ] ];
Lino.pcsw.RefusalReasons = [ [ "10", "Information (keine Begleitung erforderlich)" ], [ "20", "\u00d6SHZ ist nicht zust\u00e4ndig" ], [ "30", "Antragsteller ist nicht zur\u00fcck gekommen" ] ];
Lino.lino.UserGroups = [ [ "office", "office (B\u00fcro)" ], [ "reception", "reception (Empfang)" ], [ "accounting", "accounting (Buchhaltung)" ], [ "integ", "integ (DSBE)" ], [ "newcomers", "newcomers (Neuantr\u00e4ge)" ], [ "debts", "debts (Schuldnerberatung)" ], [ "cbss", "cbss (ZDSS)" ] ];
Lino.cbss.RequestStates = [ [ "10", "Versendet" ], [ "20", "Fehlgeschlagen" ], [ "25", "Validiert" ], [ "30", "OK" ], [ "40", "Warnungen" ], [ "50", "Fehlermeldungen" ] ];
Lino.lino.ChangeTypes = [ [ "C", "Erstellen" ], [ "U", "Aktualisierung" ], [ "D", "L\u00f6schen" ], [ "R", "Remove child" ], [ "A", "Add child" ], [ "M", "Fusionieren" ] ];
Lino.cal.AccessClasses = [ [ "10", "Privat" ], [ "20", "halb \u00f6ffentlich (\"Besch\u00e4ftigt\")" ], [ "30", "\u00d6ffentlich" ] ];
Lino.cbss.QueryRegister = [ [ "1", "Prim\u00e4r" ], [ "2", "Sekund\u00e4r" ], [ "3", "Alle" ] ];
Lino.isip.ContractEvents = [ [ "10", "Begonnen" ], [ "20", "Aktiv" ], [ "30", "Beendet" ], [ "40", "Unterschrieben" ] ];
Lino.lino.Genders = [ [ "M", "M\u00e4nnlich" ], [ "F", "Weiblich" ] ];
Lino.pcsw.ClientEvents = [ [ "10", "Begleitet" ], [ "20", "VSE" ], [ "21", "Art.60\u00a77-Konvention" ], [ "22", "Dispenz" ], [ "30", "AG-Sperre" ], [ "40", "Note" ], [ "50", "Erstellt" ], [ "60", "Bearbeitet" ] ];
Lino.lino.UserProfiles = [ [ "000", "000 (Anonym)" ], [ "100", "100 (Begleiter im DSBE)" ], [ "110", "110 (Integrations-Assistent (Manager))" ], [ "200", "200 (Berater Neuantr\u00e4ge)" ], [ "210", "210 (Reception clerk)" ], [ "300", "300 (Schuldenberater)" ], [ "500", "500 (nur ZDSS)" ], [ "900", "900 (Verwalter)" ] ];
Lino.pcsw.ResidenceType = [ [ "1", "Bev\u00f6lkerungsregister" ], [ "2", "Fremdenregister" ], [ "3", "Warteregister" ] ];

Lino.pcsw.CoachingsByClient.ParamsPanel = Ext.extend(Ext.form.FormPanel,{
  autoScroll: false,
  autoHeight: true,
  border: false,
  layout: "form",
  hideCheckBoxLabels: true,
  frame: true,
  bodyBorder: false,
  labelAlign: "top",
  initComponent : function() {
    var containing_panel = this;
    var start_date188 = new Lino.DateField({ "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Periode vom","(pcsw.Coachings.start_date) Start date of observed period") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Periode vom</span>", "anchor": "-20", "name": "start_date" });
    var end_date189 = new Lino.DateField({ "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("bis","(pcsw.Coachings.end_date) End date of observed period") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">bis</span>", "anchor": "-20", "name": "end_date" });
    var observed_event190 = new Lino.ChoicesFieldElement({ "forceSelection": true, "fieldLabel": "Beobachtungskriterium", "name": "observed_event", "hiddenName": "observed_eventHidden", "listeners": { "render": Lino.quicktip_renderer("Beobachtungskriterium","(pcsw.Coachings.observed_event) ") }, "selectOnFocus": true, "anchor": "-20", "store": [['','<br>']].concat(Lino.pcsw.CoachingEvents) });
    var coached_by191 = new Lino.TwinCombo({ "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Begleitet durch</span>", "name": "coached_by", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.users.Users.detail)}, "emptyText": "Benutzer ausw\u00e4hlen...", "listeners": { "render": Lino.quicktip_renderer("Begleitet durch","(pcsw.Coachings.coached_by) Nur Begleitungen dieses Benutzers.") }, "selectOnFocus": true, "hiddenName": "coached_byHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/pcsw/Coachings/coached_by", "method": "GET" }) }) });
    var and_coached_by192 = new Lino.TwinCombo({ "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">und durch</span>", "name": "and_coached_by", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.users.Users.detail)}, "emptyText": "Benutzer ausw\u00e4hlen...", "listeners": { "render": Lino.quicktip_renderer("und durch","(pcsw.Coachings.and_coached_by) ... und auch Begleitungen dieses Benutzers.") }, "selectOnFocus": true, "hiddenName": "and_coached_byHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/pcsw/Coachings/and_coached_by", "method": "GET" }) }) });
    var main_1_panel193 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 14, "autoHeight": true, "layout": "form", "xtype": "panel", "items": start_date188, "labelAlign": "top" }, { "flex": 14, "autoHeight": true, "layout": "form", "xtype": "panel", "items": end_date189, "labelAlign": "top" }, { "flex": 19, "autoHeight": true, "layout": "form", "xtype": "panel", "items": observed_event190, "labelAlign": "top" }, { "flex": 26, "autoHeight": true, "layout": "form", "xtype": "panel", "items": coached_by191, "labelAlign": "top" }, { "flex": 26, "autoHeight": true, "layout": "form", "xtype": "panel", "items": and_coached_by192, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 198, "border": false, "anchor": "-20", "labelAlign": "top" });
    var primary_coachings199 = new Lino.ChoicesFieldElement({ "forceSelection": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Prim\u00e4re Begleitungen</span>", "name": "primary_coachings", "hiddenName": "primary_coachingsHidden", "listeners": { "render": Lino.quicktip_renderer("Prim\u00e4re Begleitungen","(pcsw.Coachings.primary_coachings) Accompagnements primaires.") }, "selectOnFocus": true, "anchor": "-20", "store": [['','<br>']].concat(Lino.lino.YesNo) });
    var coaching_type200 = new Lino.RemoteComboFieldElement({ "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Dienst</span>", "name": "coaching_type", "pageSize": 20, "emptyText": "Dienst ausw\u00e4hlen...", "listeners": { "render": Lino.quicktip_renderer("Dienst","(pcsw.Coachings.coaching_type) Nur Begleitungen dieses Dienstes.") }, "selectOnFocus": true, "hiddenName": "coaching_typeHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/pcsw/Coachings/coaching_type", "method": "GET" }) }) });
    var ending201 = new Lino.TwinCombo({ "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Beendigungsgrund</span>", "name": "ending", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.pcsw.CoachingEndings.detail)}, "emptyText": "Beendigungsgrund ausw\u00e4hlen...", "listeners": { "render": Lino.quicktip_renderer("Beendigungsgrund","(pcsw.Coachings.ending) Nur Begleitungen mit diesem Beendigungsgrund.") }, "selectOnFocus": true, "hiddenName": "endingHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/pcsw/Coachings/ending", "method": "GET" }) }) });
    var main_2_panel202 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 14, "autoHeight": true, "layout": "form", "xtype": "panel", "items": primary_coachings199, "labelAlign": "top" }, { "flex": 42, "autoHeight": true, "layout": "form", "xtype": "panel", "items": coaching_type200, "labelAlign": "top" }, { "flex": 42, "autoHeight": true, "layout": "form", "xtype": "panel", "items": ending201, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 189, "border": false, "anchor": "-20", "labelAlign": "top" });
    this.items = [ main_1_panel193, main_2_panel202 ];
    this.fields = [ start_date188, end_date189, observed_event190, coached_by191, and_coached_by192, primary_coachings199, coaching_type200, ending201 ];
    Lino.pcsw.CoachingsByClient.ParamsPanel.superclass.initComponent.call(this);
  }
});


Lino.contacts.Persons.ParamsPanel = Ext.extend(Ext.form.FormPanel,{
  autoScroll: false,
  border: false,
  layout: "fit",
  hideCheckBoxLabels: true,
  frame: true,
  bodyBorder: false,
  labelAlign: "top",
  initComponent : function() {
    var containing_panel = this;
    var gender905 = new Lino.ChoicesFieldElement({ "forceSelection": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Geschlecht</span>", "name": "gender", "hiddenName": "genderHidden", "listeners": { "render": Lino.quicktip_renderer("Geschlecht","(contacts.Persons.gender) Nur Personen, deren Feld \"Geschlecht\" ausgef\u00fcllt ist und dem angegebenen Wert entspricht.") }, "selectOnFocus": true, "anchor": "-20", "store": [['','<br>']].concat(Lino.lino.Genders) });
    var also_obsolete906 = new Ext.form.Checkbox({ "boxLabel": "Auch veraltete Daten", "listeners": { "render": Lino.quicktip_renderer("Auch veraltete Daten","(contacts.Persons.also_obsolete) Auch Datens\u00e4tze anzeigen, die als veraltet markiert sind.") }, "hideLabel": true, "checked": false, "name": "also_obsolete", "selectOnFocus": true, "anchor": "-20" });
    var main_1_panel907 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 189, "hideCheckBoxLabels": true, "items": [ { "flex": 52, "autoHeight": true, "layout": "form", "xtype": "panel", "items": gender905, "labelAlign": "top" }, { "flex": 47, "autoHeight": true, "layout": "form", "xtype": "panel", "items": also_obsolete906, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    this.items = [ main_1_panel907 ];
    this.fields = [ gender905, also_obsolete906 ];
    Lino.contacts.Persons.ParamsPanel.superclass.initComponent.call(this);
  }
});


Lino.pcsw.Clients.ParamsPanel = Ext.extend(Ext.form.FormPanel,{
  autoScroll: false,
  autoHeight: true,
  border: false,
  layout: "form",
  hideCheckBoxLabels: true,
  frame: true,
  bodyBorder: false,
  labelAlign: "top",
  initComponent : function() {
    var containing_panel = this;
    var aged_from1748 = new Ext.form.NumberField({ "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Alter von","(pcsw.Clients.aged_from) Nur Klienten, die mindestens so alt sind.") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Alter von</span>", "anchor": "-20", "name": "aged_from" });
    var aged_to1749 = new Ext.form.NumberField({ "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Alter bis","(pcsw.Clients.aged_to) Nur Klienten, die h\u00f6chstens so alt sind.") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Alter bis</span>", "anchor": "-20", "name": "aged_to" });
    var gender1750 = new Lino.ChoicesFieldElement({ "forceSelection": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Geschlecht</span>", "name": "gender", "hiddenName": "genderHidden", "listeners": { "render": Lino.quicktip_renderer("Geschlecht","(pcsw.Clients.gender) Nur Personen, deren Feld \"Geschlecht\" ausgef\u00fcllt ist und dem angegebenen Wert entspricht.") }, "selectOnFocus": true, "anchor": "-20", "store": [['','<br>']].concat(Lino.lino.Genders) });
    var nationality1751 = new Lino.TwinCombo({ "fieldLabel": "Staatsangeh\u00f6rigkeit", "name": "nationality", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.countries.Countries.detail)}, "emptyText": "Land ausw\u00e4hlen...", "listeners": { "render": Lino.quicktip_renderer("Staatsangeh\u00f6rigkeit","(pcsw.Clients.nationality) ") }, "selectOnFocus": true, "hiddenName": "nationalityHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/pcsw/Clients/nationality", "method": "GET" }) }) });
    var also_obsolete1752 = new Ext.form.Checkbox({ "boxLabel": "Auch veraltete Daten", "listeners": { "render": Lino.quicktip_renderer("Auch veraltete Daten","(pcsw.Clients.also_obsolete) Auch Datens\u00e4tze anzeigen, die als veraltet markiert sind.") }, "hideLabel": true, "checked": false, "name": "also_obsolete", "selectOnFocus": true, "anchor": "-20" });
    var main_1_panel1753 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 9, "autoHeight": true, "layout": "form", "xtype": "panel", "items": aged_from1748, "labelAlign": "top" }, { "flex": 9, "autoHeight": true, "layout": "form", "xtype": "panel", "items": aged_to1749, "labelAlign": "top" }, { "flex": 21, "autoHeight": true, "layout": "form", "xtype": "panel", "items": gender1750, "labelAlign": "top" }, { "flex": 39, "autoHeight": true, "layout": "form", "xtype": "panel", "items": nationality1751, "labelAlign": "top" }, { "flex": 19, "autoHeight": true, "layout": "form", "xtype": "panel", "items": also_obsolete1752, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 189, "border": false, "anchor": "-20", "labelAlign": "top" });
    var client_state1759 = new Lino.ChoicesFieldElement({ "forceSelection": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Zustand</span>", "name": "client_state", "hiddenName": "client_stateHidden", "listeners": { "render": Lino.quicktip_renderer("Zustand","(pcsw.Clients.client_state) Nur Klienten mit diesem Status (Aktenzustand).") }, "selectOnFocus": true, "anchor": "-20", "store": [['','<br>']].concat(Lino.pcsw.ClientStates) });
    var coached_by1760 = new Lino.TwinCombo({ "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Begleitet durch</span>", "name": "coached_by", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.users.Users.detail)}, "emptyText": "Benutzer ausw\u00e4hlen...", "listeners": { "render": Lino.quicktip_renderer("Begleitet durch","(pcsw.Clients.coached_by) Nur Klienten, die eine Begleitung mit diesem Benutzer haben.") }, "selectOnFocus": true, "hiddenName": "coached_byHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/pcsw/Clients/coached_by", "method": "GET" }) }) });
    var and_coached_by1761 = new Lino.TwinCombo({ "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">und durch</span>", "name": "and_coached_by", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.users.Users.detail)}, "emptyText": "Benutzer ausw\u00e4hlen...", "listeners": { "render": Lino.quicktip_renderer("und durch","(pcsw.Clients.and_coached_by) Nur Klienten, die auch mit diesem Benutzer eine Begleitung haben.") }, "selectOnFocus": true, "hiddenName": "and_coached_byHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/pcsw/Clients/and_coached_by", "method": "GET" }) }) });
    var start_date1762 = new Lino.DateField({ "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Periode vom","(pcsw.Clients.start_date) Start date of observed period") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Periode vom</span>", "anchor": "-20", "name": "start_date" });
    var end_date1763 = new Lino.DateField({ "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("bis","(pcsw.Clients.end_date) End date of observed period") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">bis</span>", "anchor": "-20", "name": "end_date" });
    var observed_event1764 = new Lino.ChoicesFieldElement({ "forceSelection": true, "fieldLabel": "Beobachtungskriterium", "name": "observed_event", "hiddenName": "observed_eventHidden", "listeners": { "render": Lino.quicktip_renderer("Beobachtungskriterium","(pcsw.Clients.observed_event) ") }, "selectOnFocus": true, "anchor": "-20", "store": [['','<br>']].concat(Lino.pcsw.ClientEvents) });
    var only_primary1765 = new Ext.form.Checkbox({ "boxLabel": "Nur prim\u00e4re Begleitungen", "listeners": { "render": Lino.quicktip_renderer("Nur prim\u00e4re Begleitungen","(pcsw.Clients.only_primary) Nur Klienten, die eine effektive <b>prim\u00e4re</b> Begleitung haben.") }, "hideLabel": true, "checked": false, "name": "only_primary", "selectOnFocus": true, "anchor": "-20" });
    var main_2_panel1766 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 13, "autoHeight": true, "layout": "form", "xtype": "panel", "items": client_state1759, "labelAlign": "top" }, { "flex": 16, "autoHeight": true, "layout": "form", "xtype": "panel", "items": coached_by1760, "labelAlign": "top" }, { "flex": 16, "autoHeight": true, "layout": "form", "xtype": "panel", "items": and_coached_by1761, "labelAlign": "top" }, { "flex": 8, "autoHeight": true, "layout": "form", "xtype": "panel", "items": start_date1762, "labelAlign": "top" }, { "flex": 8, "autoHeight": true, "layout": "form", "xtype": "panel", "items": end_date1763, "labelAlign": "top" }, { "flex": 24, "autoHeight": true, "layout": "form", "xtype": "panel", "items": observed_event1764, "labelAlign": "top" }, { "flex": 11, "autoHeight": true, "layout": "form", "xtype": "panel", "items": only_primary1765, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 225, "border": false, "anchor": "-20", "labelAlign": "top" });
    this.items = [ main_1_panel1753, main_2_panel1766 ];
    this.fields = [ aged_from1748, aged_to1749, gender1750, nationality1751, also_obsolete1752, client_state1759, coached_by1760, and_coached_by1761, start_date1762, end_date1763, observed_event1764, only_primary1765 ];
    Lino.pcsw.Clients.ParamsPanel.superclass.initComponent.call(this);
  }
});


Lino.reception.ExpectedGuests.wf2_ActionFormPanel = Ext.extend(Lino.ActionFormPanel,{
  autoScroll: false,
  border: false,
  layout: "vbox",
  labelWidth: 387,
  hideCheckBoxLabels: true,
  frame: true,
  layoutConfig: { "align": "stretch" },
  bodyBorder: false,
  labelAlign: "top",
  action_name: 'wf2',
  window_title: "Absagen",
  initComponent : function() {
    var containing_panel = this;
    var notify_subject13 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Kurzbeschreibung","(<RejectInvitation wf2 (u'Absagen')>.notify_subject) ") }, "fieldLabel": "Kurzbeschreibung", "name": "notify_subject", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var notify_body14 = new Ext.form.TextArea({ "listeners": { "render": Lino.quicktip_renderer("Beschreibung","(<RejectInvitation wf2 (u'Absagen')>.notify_body) ") }, "fieldLabel": "Beschreibung", "name": "notify_body", "growMax": 2000, "selectOnFocus": true, "anchor": "-20 -10" });
    var notify_silent15 = new Ext.form.Checkbox({ "boxLabel": "Keine Benachrichtigung per E-Mail schicken", "listeners": { "render": Lino.quicktip_renderer("Keine Benachrichtigung per E-Mail schicken","(<RejectInvitation wf2 (u'Absagen')>.notify_silent) ") }, "hideLabel": true, "checked": false, "name": "notify_silent", "selectOnFocus": true, "anchor": "-20" });
    this.items = [ { "items": notify_subject13, "autoHeight": true, "layout": "form", "xtype": "panel", "labelAlign": "top" }, { "items": notify_body14, "labelAlign": "top", "layout": "form", "xtype": "panel", "flex": 71 }, { "items": notify_silent15, "autoHeight": true, "layout": "form", "xtype": "panel", "labelAlign": "top" } ];
    this.fields = [ notify_subject13, notify_body14, notify_silent15 ];
    Lino.reception.ExpectedGuests.wf2_ActionFormPanel.superclass.initComponent.call(this);
  }
});


Lino.pcsw.Clients.wf2_ActionFormPanel = Ext.extend(Lino.ActionFormPanel,{
  autoScroll: false,
  border: false,
  layout: "vbox",
  labelWidth: 90,
  hideCheckBoxLabels: true,
  frame: true,
  layoutConfig: { "align": "stretch" },
  bodyBorder: false,
  labelAlign: "top",
  action_name: 'wf2',
  window_title: "Ablehnen",
  initComponent : function() {
    var containing_panel = this;
    var reason34 = new Lino.ChoicesFieldElement({ "forceSelection": true, "fieldLabel": "reason", "allowBlank": false, "hiddenName": "reasonHidden", "listeners": { "render": Lino.quicktip_renderer("reason","(<RefuseClient wf2 (u'Ablehnen')>.reason) ") }, "selectOnFocus": true, "anchor": "-20", "store": Lino.pcsw.RefusalReasons, "name": "reason" });
    var remark35 = new Ext.form.TextArea({ "listeners": { "render": Lino.quicktip_renderer("Bemerkung","(<RefuseClient wf2 (u'Ablehnen')>.remark) ") }, "fieldLabel": "Bemerkung", "name": "remark", "growMax": 2000, "selectOnFocus": true, "anchor": "-20 -10" });
    this.items = [ { "items": reason34, "autoHeight": true, "layout": "form", "xtype": "panel", "labelAlign": "top" }, { "items": remark35, "labelAlign": "top", "layout": "form", "xtype": "panel", "flex": 83 } ];
    this.fields = [ reason34, remark35 ];
    Lino.pcsw.Clients.wf2_ActionFormPanel.superclass.initComponent.call(this);
  }
});


Lino.contacts.Companies.merge_row_ActionFormPanel = Ext.extend(Lino.ActionFormPanel,{
  autoScroll: false,
  autoHeight: true,
  border: false,
  layout: "form",
  labelWidth: 99,
  hideCheckBoxLabels: true,
  frame: true,
  bodyBorder: false,
  labelAlign: "top",
  action_name: 'merge_row',
  window_title: "Fusionieren",
  autoHeight: true,
  initComponent : function() {
    var containing_panel = this;
    this.items = [  ];
    this.fields = [  ];
    Lino.contacts.Companies.merge_row_ActionFormPanel.superclass.initComponent.call(this);
  }
});


Lino.pcsw.Clients.merge_row_ActionFormPanel = Ext.extend(Lino.ActionFormPanel,{
  autoScroll: false,
  autoHeight: true,
  border: false,
  layout: "form",
  labelWidth: 99,
  hideCheckBoxLabels: true,
  frame: true,
  bodyBorder: false,
  labelAlign: "top",
  action_name: 'merge_row',
  window_title: "Fusionieren",
  autoHeight: true,
  initComponent : function() {
    var containing_panel = this;
    this.items = [  ];
    this.fields = [  ];
    Lino.pcsw.Clients.merge_row_ActionFormPanel.superclass.initComponent.call(this);
  }
});


Lino.reception.ExpectedGuests.checkout_ActionFormPanel = Ext.extend(Lino.ActionFormPanel,{
  autoScroll: false,
  border: false,
  layout: "vbox",
  labelWidth: 387,
  hideCheckBoxLabels: true,
  frame: true,
  layoutConfig: { "align": "stretch" },
  bodyBorder: false,
  labelAlign: "top",
  action_name: 'checkout',
  window_title: "Checkout",
  initComponent : function() {
    var containing_panel = this;
    var notify_subject20 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Kurzbeschreibung","(<CheckoutGuest checkout (u'Checkout')>.notify_subject) ") }, "fieldLabel": "Kurzbeschreibung", "name": "notify_subject", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var notify_body21 = new Ext.form.TextArea({ "listeners": { "render": Lino.quicktip_renderer("Beschreibung","(<CheckoutGuest checkout (u'Checkout')>.notify_body) ") }, "fieldLabel": "Beschreibung", "name": "notify_body", "growMax": 2000, "selectOnFocus": true, "anchor": "-20 -10" });
    var notify_silent22 = new Ext.form.Checkbox({ "boxLabel": "Keine Benachrichtigung per E-Mail schicken", "listeners": { "render": Lino.quicktip_renderer("Keine Benachrichtigung per E-Mail schicken","(<CheckoutGuest checkout (u'Checkout')>.notify_silent) ") }, "hideLabel": true, "checked": false, "name": "notify_silent", "selectOnFocus": true, "anchor": "-20" });
    this.items = [ { "items": notify_subject20, "autoHeight": true, "layout": "form", "xtype": "panel", "labelAlign": "top" }, { "items": notify_body21, "labelAlign": "top", "layout": "form", "xtype": "panel", "flex": 71 }, { "items": notify_silent22, "autoHeight": true, "layout": "form", "xtype": "panel", "labelAlign": "top" } ];
    this.fields = [ notify_subject20, notify_body21, notify_silent22 ];
    Lino.reception.ExpectedGuests.checkout_ActionFormPanel.superclass.initComponent.call(this);
  }
});


Lino.reception.ExpectedGuests.checkin_ActionFormPanel = Ext.extend(Lino.ActionFormPanel,{
  autoScroll: false,
  border: false,
  layout: "vbox",
  labelWidth: 387,
  hideCheckBoxLabels: true,
  frame: true,
  layoutConfig: { "align": "stretch" },
  bodyBorder: false,
  labelAlign: "top",
  action_name: 'checkin',
  window_title: "Checkin",
  initComponent : function() {
    var containing_panel = this;
    var notify_subject27 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Kurzbeschreibung","(<CheckinGuest checkin (u'Checkin')>.notify_subject) ") }, "fieldLabel": "Kurzbeschreibung", "name": "notify_subject", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var notify_body28 = new Ext.form.TextArea({ "listeners": { "render": Lino.quicktip_renderer("Beschreibung","(<CheckinGuest checkin (u'Checkin')>.notify_body) ") }, "fieldLabel": "Beschreibung", "name": "notify_body", "growMax": 2000, "selectOnFocus": true, "anchor": "-20 -10" });
    var notify_silent29 = new Ext.form.Checkbox({ "boxLabel": "Keine Benachrichtigung per E-Mail schicken", "listeners": { "render": Lino.quicktip_renderer("Keine Benachrichtigung per E-Mail schicken","(<CheckinGuest checkin (u'Checkin')>.notify_silent) ") }, "hideLabel": true, "checked": false, "name": "notify_silent", "selectOnFocus": true, "anchor": "-20" });
    this.items = [ { "items": notify_subject27, "autoHeight": true, "layout": "form", "xtype": "panel", "labelAlign": "top" }, { "items": notify_body28, "labelAlign": "top", "layout": "form", "xtype": "panel", "flex": 71 }, { "items": notify_silent29, "autoHeight": true, "layout": "form", "xtype": "panel", "labelAlign": "top" } ];
    this.fields = [ notify_subject27, notify_body28, notify_silent29 ];
    Lino.reception.ExpectedGuests.checkin_ActionFormPanel.superclass.initComponent.call(this);
  }
});


Lino.reception.ExpectedGuests.wf1_ActionFormPanel = Ext.extend(Lino.ActionFormPanel,{
  autoScroll: false,
  border: false,
  layout: "vbox",
  labelWidth: 387,
  hideCheckBoxLabels: true,
  frame: true,
  layoutConfig: { "align": "stretch" },
  bodyBorder: false,
  labelAlign: "top",
  action_name: 'wf1',
  window_title: "Zusagen",
  initComponent : function() {
    var containing_panel = this;
    var notify_subject6 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Kurzbeschreibung","(<AcceptInvitation wf1 (u'Zusagen')>.notify_subject) ") }, "fieldLabel": "Kurzbeschreibung", "name": "notify_subject", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var notify_body7 = new Ext.form.TextArea({ "listeners": { "render": Lino.quicktip_renderer("Beschreibung","(<AcceptInvitation wf1 (u'Zusagen')>.notify_body) ") }, "fieldLabel": "Beschreibung", "name": "notify_body", "growMax": 2000, "selectOnFocus": true, "anchor": "-20 -10" });
    var notify_silent8 = new Ext.form.Checkbox({ "boxLabel": "Keine Benachrichtigung per E-Mail schicken", "listeners": { "render": Lino.quicktip_renderer("Keine Benachrichtigung per E-Mail schicken","(<AcceptInvitation wf1 (u'Zusagen')>.notify_silent) ") }, "hideLabel": true, "checked": false, "name": "notify_silent", "selectOnFocus": true, "anchor": "-20" });
    this.items = [ { "items": notify_subject6, "autoHeight": true, "layout": "form", "xtype": "panel", "labelAlign": "top" }, { "items": notify_body7, "labelAlign": "top", "layout": "form", "xtype": "panel", "flex": 71 }, { "items": notify_silent8, "autoHeight": true, "layout": "form", "xtype": "panel", "labelAlign": "top" } ];
    this.fields = [ notify_subject6, notify_body7, notify_silent8 ];
    Lino.reception.ExpectedGuests.wf1_ActionFormPanel.superclass.initComponent.call(this);
  }
});


Lino.contacts.Persons.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 21,
  initComponent : function() {
    var containing_panel = this;
    var last_name805 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Familienname","(contacts.Persons.last_name) ") }, "fieldLabel": "Familienname", "name": "last_name", "maxLength": 200, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var first_name806 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Vorname","(contacts.Persons.first_name) ") }, "fieldLabel": "Vorname", "name": "first_name", "maxLength": 200, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var gender807 = new Lino.ChoicesFieldElement({ "forceSelection": true, "fieldLabel": "Geschlecht", "name": "gender", "hiddenName": "genderHidden", "listeners": { "render": Lino.quicktip_renderer("Geschlecht","(contacts.Persons.gender) ") }, "selectOnFocus": true, "anchor": "-20", "store": [['','<br>']].concat(Lino.lino.Genders) });
    var title808 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Anrede","(contacts.Persons.title) ") }, "fieldLabel": "Anrede", "name": "title", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var name_box_panel809 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 36, "autoHeight": true, "layout": "form", "xtype": "panel", "items": last_name805, "labelAlign": "top" }, { "flex": 26, "autoHeight": true, "layout": "form", "xtype": "panel", "items": first_name806, "labelAlign": "top" }, { "flex": 19, "autoHeight": true, "layout": "form", "xtype": "panel", "items": gender807, "labelAlign": "top" }, { "flex": 17, "autoHeight": true, "layout": "form", "xtype": "panel", "items": title808, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 117, "border": false, "anchor": "-20", "labelAlign": "top" });
    var country814 = new Lino.TwinCombo({ "fieldLabel": "Land", "name": "country", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.countries.Countries.detail)}, "emptyText": "Land ausw\u00e4hlen...", "listeners": { "render": Lino.quicktip_renderer("Land","(contacts.Persons.country) ") }, "selectOnFocus": true, "hiddenName": "countryHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/contacts/Persons/country", "method": "GET" }) }) });
    var region815 = new Lino.TwinCombo({ "fieldLabel": "Region", "name": "region", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.countries.Cities.detail)}, "emptyText": "Ort ausw\u00e4hlen...", "listeners": { "render": Lino.quicktip_renderer("Region","(contacts.Persons.region) ") }, "selectOnFocus": true, "hiddenName": "regionHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/contacts/Persons/region", "method": "GET" }) }) });
    var city816 = new Lino.TwinCombo({ "forceSelection": false, "fieldLabel": "Ort", "name": "city", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.countries.Cities.detail)}, "emptyText": "Ort ausw\u00e4hlen...", "listeners": { "render": Lino.quicktip_renderer("Ort","(contacts.Persons.city) ") }, "selectOnFocus": true, "hiddenName": "cityHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/contacts/Persons/city", "method": "GET" }) }) });
    var zip_code817 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Postleitzahl","(contacts.Persons.zip_code) ") }, "fieldLabel": "Postleitzahl", "name": "zip_code", "maxLength": 10, "selectOnFocus": true, "boxMinWidth": Lino.chars2width(10), "anchor": "-20" });
    var address_box_2_panel818 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 28, "autoHeight": true, "layout": "form", "xtype": "panel", "items": country814, "labelAlign": "top" }, { "flex": 28, "autoHeight": true, "layout": "form", "xtype": "panel", "items": region815, "labelAlign": "top" }, { "flex": 28, "autoHeight": true, "layout": "form", "xtype": "panel", "items": city816, "labelAlign": "top" }, { "flex": 14, "autoHeight": true, "layout": "form", "xtype": "panel", "items": zip_code817, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 117, "border": false, "anchor": "-20", "labelAlign": "top" });
    var addr1823 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Adresszeile vor Stra\u00dfe","(contacts.Persons.addr1) Address line before street") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Adresszeile vor Stra\u00dfe</span>", "name": "addr1", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var street_prefix824 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Pr\u00e4fix Stra\u00dfe","(contacts.Persons.street_prefix) Text to print before name of street, but to ignore for sorting.") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Pr\u00e4fix Stra\u00dfe</span>", "name": "street_prefix", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var street825 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Stra\u00dfe","(contacts.Persons.street) Name of street. Without house number.") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Stra\u00dfe</span>", "name": "street", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var street_no826 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Nr.","(contacts.Persons.street_no) House number") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Nr.</span>", "name": "street_no", "maxLength": 10, "selectOnFocus": true, "boxMinWidth": Lino.chars2width(10), "anchor": "-20" });
    var street_box827 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Box","(contacts.Persons.street_box) Text to print after :attr:`steet_no` on the same line") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Box</span>", "name": "street_box", "maxLength": 10, "selectOnFocus": true, "boxMinWidth": Lino.chars2width(10), "anchor": "-20" });
    var address_box_4_panel828 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 30, "autoHeight": true, "layout": "form", "xtype": "panel", "items": street_prefix824, "labelAlign": "top" }, { "flex": 36, "autoHeight": true, "layout": "form", "xtype": "panel", "items": street825, "labelAlign": "top" }, { "flex": 16, "autoHeight": true, "layout": "form", "xtype": "panel", "items": street_no826, "labelAlign": "top" }, { "flex": 16, "autoHeight": true, "layout": "form", "xtype": "panel", "items": street_box827, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 126, "border": false, "anchor": "-20", "labelAlign": "top" });
    var addr2833 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Adresszeile nach Stra\u00dfe","(contacts.Persons.addr2) Address line to print below street line") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Adresszeile nach Stra\u00dfe</span>", "name": "addr2", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var address_box_panel834 = new Ext.form.FieldSet({ "flex": 66, "autoHeight": true, "layout": "form", "title": "Adresse", "items": [ name_box_panel809, address_box_2_panel818, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": addr1823, "anchor": "-20", "labelAlign": "top" }, address_box_4_panel828, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": addr2833, "anchor": "-20", "labelAlign": "top" } ], "frame": true, "bodyBorder": false, "autoScroll": false, "hideCheckBoxLabels": true, "labelWidth": 216, "border": false, "labelAlign": "top" });
    var id837 = new Ext.form.NumberField({ "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("ID","(contacts.Persons.id) ") }, "fieldLabel": "ID", "anchor": "-20", "name": "id" });
    var language838 = new Lino.ChoicesFieldElement({ "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Sprache</span>", "allowBlank": false, "value": "de", "hiddenName": "languageHidden", "listeners": { "render": Lino.quicktip_renderer("Sprache","(contacts.Persons.language) Die Sprache, in der Dokumente ausgestellt werden sollen.") }, "selectOnFocus": true, "anchor": "-20", "store": [ [ "de", "Deutsch" ], [ "fr", "Franz\u00f6sisch" ], [ "nl", "Niederl\u00e4ndisch" ] ], "name": "language" });
    var info_box_panel839 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id837, "labelAlign": "top" }, { "flex": 66, "autoHeight": true, "layout": "form", "xtype": "panel", "items": language838, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 72, "border": false, "anchor": "-20", "labelAlign": "top" });
    var email842 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("E-Mail","(contacts.Persons.email) ") }, "fieldLabel": "E-Mail", "name": "email", "maxLength": 75, "selectOnFocus": true, "anchor": "-20" });
    var url843 = new Lino.URLField({ "listeners": { "render": Lino.quicktip_renderer("URL","(contacts.Persons.url) ") }, "fieldLabel": "URL", "name": "url", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var phone844 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Telefon","(contacts.Persons.phone) ") }, "fieldLabel": "Telefon", "name": "phone", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var gsm845 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("GSM","(contacts.Persons.gsm) ") }, "fieldLabel": "GSM", "name": "gsm", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var fax846 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Fax","(contacts.Persons.fax) ") }, "fieldLabel": "Fax", "name": "fax", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var contact_box_5_panel847 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": gsm845, "labelAlign": "top" }, { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": fax846, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 36, "border": false, "anchor": "-20", "labelAlign": "top" });
    var contact_box_panel850 = new Ext.form.FieldSet({ "flex": 33, "autoHeight": true, "layout": "form", "title": "Kontakt", "items": [ info_box_panel839, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": email842, "anchor": "-20", "labelAlign": "top" }, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": url843, "anchor": "-20", "labelAlign": "top" }, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": phone844, "anchor": "-20", "labelAlign": "top" }, contact_box_5_panel847 ], "frame": true, "bodyBorder": false, "autoScroll": false, "hideCheckBoxLabels": true, "labelWidth": 72, "border": false, "labelAlign": "top" });
    var general_1_panel854 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "hideCheckBoxLabels": true, "items": [ address_box_panel834, contact_box_panel850 ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var activity855 = new Lino.RemoteComboFieldElement({ "fieldLabel": "Beruf", "name": "activity", "pageSize": 20, "emptyText": "Beruf ausw\u00e4hlen...", "listeners": { "render": Lino.quicktip_renderer("Beruf","(contacts.Persons.activity) ") }, "selectOnFocus": true, "hiddenName": "activityHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/contacts/Persons/activity", "method": "GET" }) }) });
    var bank_account1856 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Bankkonto 1","(contacts.Persons.bank_account1) ") }, "fieldLabel": "Bankkonto 1", "name": "bank_account1", "maxLength": 40, "selectOnFocus": true, "anchor": "-20" });
    var bank_account2857 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Bankkonto 2","(contacts.Persons.bank_account2) ") }, "fieldLabel": "Bankkonto 2", "name": "bank_account2", "maxLength": 40, "selectOnFocus": true, "anchor": "-20" });
    var is_obsolete858 = new Ext.form.Checkbox({ "boxLabel": "veraltet", "listeners": { "render": Lino.quicktip_renderer("veraltet","(contacts.Persons.is_obsolete) Altf\u00e4lle sind Partner, deren Stammdaten nicht mehr gepflegt werden und \nf\u00fcr neue Operationen nicht benutzt werden k\u00f6nnen.") }, "hideLabel": true, "checked": false, "name": "is_obsolete", "selectOnFocus": true, "anchor": "-20" });
    var bottom_box_1_panel859 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 108, "hideCheckBoxLabels": true, "items": [ { "flex": 27, "autoHeight": true, "layout": "form", "xtype": "panel", "items": activity855, "labelAlign": "top" }, { "flex": 29, "autoHeight": true, "layout": "form", "xtype": "panel", "items": bank_account1856, "labelAlign": "top" }, { "flex": 29, "autoHeight": true, "layout": "form", "xtype": "panel", "items": bank_account2857, "labelAlign": "top" }, { "flex": 13, "autoHeight": true, "layout": "form", "xtype": "panel", "items": is_obsolete858, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var is_client864 = new Ext.form.Checkbox({ "boxLabel": "ist Klient (<a href=\"javascript:Lino.show_mti_child('is_client',Lino.pcsw.Clients.detail)\">zeigen</a>)", "listeners": { "render": Lino.quicktip_renderer("ist Klient","(contacts.Persons.is_client) Ob diese Person ein Klient ist") }, "hideLabel": true, "name": "is_client", "selectOnFocus": true, "anchor": "-20" });
    var created865 = new Ext.form.DisplayField({ "disabled": true, "listeners": { "render": Lino.quicktip_renderer("Erstellt","(contacts.Persons.created) ") }, "fieldLabel": "Erstellt", "name": "created", "anchor": "-20", "value": "<br>" });
    var modified866 = new Ext.form.DisplayField({ "disabled": true, "listeners": { "render": Lino.quicktip_renderer("Bearbeitet","(contacts.Persons.modified) ") }, "fieldLabel": "Bearbeitet", "name": "modified", "anchor": "-20", "value": "<br>" });
    var bottom_box_2_panel867 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 99, "hideCheckBoxLabels": true, "items": [ { "flex": 23, "autoHeight": true, "layout": "form", "xtype": "panel", "items": is_client864, "labelAlign": "top" }, { "flex": 38, "autoHeight": true, "layout": "form", "xtype": "panel", "items": created865, "labelAlign": "top" }, { "flex": 38, "autoHeight": true, "layout": "form", "xtype": "panel", "items": modified866, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var remarks871 = new Ext.form.TextArea({ "listeners": { "render": Lino.quicktip_renderer("Bemerkungen","(contacts.Persons.remarks) ") }, "fieldLabel": "Bemerkungen", "name": "remarks", "growMax": 2000, "selectOnFocus": true, "anchor": "-20 -10" });
    var contacts_RolesByPerson_grid876 = new Lino.contacts.RolesByPerson.GridPanel({ "flex": 27, "listeners": { "render": Lino.quicktip_renderer("Kontaktperson f\u00fcr","(contacts.contacts.RolesByPerson) ") }, "hide_top_toolbar": true, "containing_panel": this, "tools": [ Lino.show_in_own_window_button(Lino.contacts.RolesByPerson.grid) ], "master_panel": this });
    var households_MembersByPerson_grid883 = new Lino.households.MembersByPerson.GridPanel({ "flex": 36, "listeners": { "render": Lino.quicktip_renderer("Mitglied von","(households.households.MembersByPerson) ") }, "hide_top_toolbar": true, "containing_panel": this, "tools": [ Lino.show_in_own_window_button(Lino.households.MembersByPerson.grid) ], "master_panel": this });
    var bottom_box_3_panel884 = new Ext.Panel({ "flex": 71, "border": false, "layout": "hbox", "labelWidth": 108, "hideCheckBoxLabels": true, "items": [ { "items": remarks871, "labelAlign": "top", "layout": "form", "xtype": "panel", "flex": 36 }, contacts_RolesByPerson_grid876, households_MembersByPerson_grid883 ], "autoScroll": false, "layoutConfig": { "align": "stretch" }, "frame": false, "labelAlign": "top" });
    var bottom_box_panel886 = new Ext.Panel({ "flex": 58, "border": false, "layout": "vbox", "bodyBorder": false, "hideCheckBoxLabels": true, "items": [ bottom_box_1_panel859, bottom_box_2_panel867, bottom_box_3_panel884 ], "autoScroll": false, "layoutConfig": { "align": "stretch" }, "frame": true, "labelAlign": "top" });
    var general_panel887 = new Ext.Panel({ "layout": "vbox", "title": "Allgemein", "items": [ general_1_panel854, bottom_box_panel886 ], "frame": true, "layoutConfig": { "align": "stretch" }, "hideCheckBoxLabels": true, "listeners": { "activate": Lino.on_tab_activate }, "autoScroll": false, "border": false, "bodyBorder": false, "labelAlign": "top" });
    var main_panel891 = new Ext.TabPanel({ "hideCheckBoxLabels": true, "border": false, "split": true, "autoScroll": false, "items": [ general_panel887 ], "activeTab": 0, "bodyBorder": false, "frame": true, "labelAlign": "top" });
    this.items = main_panel891;
    this.before_row_edit = function(record) {
      region815.setContextValue('country',record ? record.data['countryHidden'] : undefined);
      city816.setContextValue('country',record ? record.data['countryHidden'] : undefined);
      city816.setContextValue('region',record ? record.data['regionHidden'] : undefined);
      contacts_RolesByPerson_grid876.on_master_changed();
      households_MembersByPerson_grid883.on_master_changed();
    }
    this.onRender = function(ct, position) {
      country814.on('change',Lino.chooser_handler(region815,'country'));
      country814.on('change',Lino.chooser_handler(city816,'country'));
      region815.on('change',Lino.chooser_handler(city816,'region'));
      Lino.contacts.Persons.DetailFormPanel.superclass.onRender.call(this, ct, position);
    }
    Lino.contacts.Persons.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.users.MySettings.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 7,
  initComponent : function() {
    var containing_panel = this;
    var username62 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Benutzername","(users.Users.username) \n        Required. Must be unique. \n        ") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Benutzername</span>", "name": "username", "maxLength": 30, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var id63 = new Ext.form.NumberField({ "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("ID","(users.Users.id) ") }, "fieldLabel": "ID", "anchor": "-20", "name": "id" });
    var profile64 = new Lino.ChoicesFieldElement({ "forceSelection": true, "fieldLabel": "Benutzerprofil", "name": "profile", "hiddenName": "profileHidden", "listeners": { "render": Lino.quicktip_renderer("Benutzerprofil","(users.Users.profile) ") }, "selectOnFocus": true, "anchor": "-20", "store": [['','<br>']].concat(Lino.lino.UserProfiles) });
    var box1_1_panel65 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 31, "autoHeight": true, "layout": "form", "xtype": "panel", "items": username62, "labelAlign": "top" }, { "flex": 7, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id63, "labelAlign": "top" }, { "flex": 61, "autoHeight": true, "layout": "form", "xtype": "panel", "items": profile64, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 135, "border": false, "anchor": "-20", "labelAlign": "top" });
    var first_name69 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Vorname","(users.Users.first_name) ") }, "fieldLabel": "Vorname", "name": "first_name", "maxLength": 30, "selectOnFocus": true, "anchor": "-20" });
    var last_name70 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Familienname","(users.Users.last_name) ") }, "fieldLabel": "Familienname", "name": "last_name", "maxLength": 30, "selectOnFocus": true, "anchor": "-20" });
    var partner71 = new Lino.TwinCombo({ "fieldLabel": "Partner", "name": "partner", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.contacts.Partners.detail)}, "emptyText": "Partner ausw\u00e4hlen...", "listeners": { "render": Lino.quicktip_renderer("Partner","(users.Users.partner) ") }, "selectOnFocus": true, "hiddenName": "partnerHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/users/Users/partner", "method": "GET" }) }) });
    var box1_2_panel72 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": first_name69, "labelAlign": "top" }, { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": last_name70, "labelAlign": "top" }, { "flex": 32, "autoHeight": true, "layout": "form", "xtype": "panel", "items": partner71, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 117, "border": false, "anchor": "-20", "labelAlign": "top" });
    var email76 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("e-mail address","(users.Users.email) ") }, "fieldLabel": "e-mail address", "name": "email", "maxLength": 75, "selectOnFocus": true, "anchor": "-20" });
    var language77 = new Lino.ChoicesFieldElement({ "fieldLabel": "Sprache", "allowBlank": false, "hiddenName": "languageHidden", "listeners": { "render": Lino.quicktip_renderer("Sprache","(users.Users.language) ") }, "selectOnFocus": true, "anchor": "-20", "store": [ [ "de", "Deutsch" ], [ "fr", "Franz\u00f6sisch" ], [ "nl", "Niederl\u00e4ndisch" ] ], "name": "language" });
    var box1_3_panel78 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 51, "autoHeight": true, "layout": "form", "xtype": "panel", "items": email76, "labelAlign": "top" }, { "flex": 48, "autoHeight": true, "layout": "form", "xtype": "panel", "items": language77, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 135, "border": false, "anchor": "-20", "labelAlign": "top" });
    var created81 = new Ext.form.DisplayField({ "disabled": true, "listeners": { "render": Lino.quicktip_renderer("Erstellt","(users.Users.created) ") }, "fieldLabel": "Erstellt", "name": "created", "anchor": "-20", "value": "<br>" });
    var modified82 = new Ext.form.DisplayField({ "disabled": true, "listeners": { "render": Lino.quicktip_renderer("Bearbeitet","(users.Users.modified) ") }, "fieldLabel": "Bearbeitet", "name": "modified", "anchor": "-20", "value": "<br>" });
    var box1_4_panel83 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": created81, "labelAlign": "top" }, { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": modified82, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 99, "border": false, "anchor": "-20", "labelAlign": "top" });
    var box1_panel86 = new Ext.Panel({ "flex": 66, "autoHeight": true, "border": false, "layout": "form", "hideCheckBoxLabels": true, "items": [ box1_1_panel65, box1_2_panel72, box1_3_panel78, box1_4_panel83 ], "frame": true, "autoScroll": false, "bodyBorder": false, "labelAlign": "top" });
    var general_1_panel90 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "hideCheckBoxLabels": true, "items": [ box1_panel86 ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var remarks91 = new Ext.form.TextArea({ "listeners": { "render": Lino.quicktip_renderer("Bemerkungen","(users.Users.remarks) ") }, "fieldLabel": "Bemerkungen", "name": "remarks", "growMax": 2000, "selectOnFocus": true, "anchor": "-20 -10" });
    var AuthoritiesGiven_grid94 = new Lino.users.AuthoritiesGiven.GridPanel({ "flex": 33, "listeners": { "render": Lino.quicktip_renderer("Erteilte Vollmachten","(users.users.AuthoritiesGiven) ") }, "hide_top_toolbar": true, "containing_panel": this, "tools": [ Lino.show_in_own_window_button(Lino.users.AuthoritiesGiven.grid) ], "master_panel": this });
    var general_2_panel95 = new Ext.Panel({ "flex": 50, "border": false, "layout": "hbox", "labelWidth": 108, "hideCheckBoxLabels": true, "items": [ { "items": remarks91, "labelAlign": "top", "layout": "form", "xtype": "panel", "flex": 66 }, AuthoritiesGiven_grid94 ], "autoScroll": false, "layoutConfig": { "align": "stretch" }, "frame": false, "labelAlign": "top" });
    var general_panel97 = new Ext.Panel({ "layout": "vbox", "title": "Allgemein", "items": [ general_1_panel90, general_2_panel95 ], "frame": true, "layoutConfig": { "align": "stretch" }, "hideCheckBoxLabels": true, "listeners": { "activate": Lino.on_tab_activate }, "autoScroll": false, "border": false, "bodyBorder": false, "labelAlign": "top" });
    var calendar98 = new Lino.TwinCombo({ "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Standard-Kalender</span>", "name": "calendar", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.cal.Calendars.detail)}, "emptyText": "Kalender ausw\u00e4hlen...", "listeners": { "render": Lino.quicktip_renderer("Standard-Kalender","(users.Users.calendar) The default calendar for your events and tasks.") }, "selectOnFocus": true, "hiddenName": "calendarHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/users/Users/calendar", "method": "GET" }) }) });
    var access_class99 = new Lino.ChoicesFieldElement({ "forceSelection": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Standardm\u00e4\u00dfige Zugriffsklasse</span>", "allowBlank": false, "hiddenName": "access_classHidden", "listeners": { "render": Lino.quicktip_renderer("Standardm\u00e4\u00dfige Zugriffsklasse","(users.Users.access_class) Die standardm\u00e4\u00dfige Zugriffsklasse f\u00fcr Ihre Termine und Aufgaben") }, "selectOnFocus": true, "anchor": "-20", "store": Lino.cal.AccessClasses, "name": "access_class" });
    var cal_left_1_panel100 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 270, "hideCheckBoxLabels": true, "items": [ { "flex": 37, "autoHeight": true, "layout": "form", "xtype": "panel", "items": calendar98, "labelAlign": "top" }, { "flex": 62, "autoHeight": true, "layout": "form", "xtype": "panel", "items": access_class99, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var cal_left_panel108 = new Ext.Panel({ "flex": 33, "border": false, "layout": "vbox", "bodyBorder": false, "hideCheckBoxLabels": true, "items": [ cal_left_1_panel100 ], "autoScroll": false, "layoutConfig": { "align": "stretch" }, "frame": true, "labelAlign": "top" });
    var cal_1_panel167 = new Ext.Panel({ "autoScroll": false, "listeners": { "activate": Lino.on_tab_activate }, "border": false, "layout": "hbox", "title": "Kalender", "hideCheckBoxLabels": true, "items": [ cal_left_panel108 ], "frame": false, "layoutConfig": { "align": "stretch" }, "labelAlign": "top" });
    var newcomer_quota168 = new Ext.form.NumberField({ "listeners": { "render": Lino.quicktip_renderer("Quote NZ","(users.Users.newcomer_quota) Wieviel Arbeitszeit dieser Benutzer f\u00fcr Neuantr\u00e4ge zur Verf\u00fcgung steht\n(100 = ganztags, 50 = halbtags, 0 = gar nicht).\nWenn zwei Benutzer die gleiche Belastungspunktzahl haben, \naber einer davon sich nur zu 50% um Neuantr\u00e4ge k\u00fcmmert, \ngilt er als doppelt so belastet wie sein Kollege.\n") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Quote NZ</span>", "name": "newcomer_quota", "selectOnFocus": true, "anchor": "-20", "value": 0, "allowBlank": false });
    var coaching_type169 = new Lino.RemoteComboFieldElement({ "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Dienst</span>", "name": "coaching_type", "pageSize": 20, "emptyText": "Dienst ausw\u00e4hlen...", "listeners": { "render": Lino.quicktip_renderer("Dienst","(users.Users.coaching_type) The default CoachingType used when creating Coachings.") }, "selectOnFocus": true, "hiddenName": "coaching_typeHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/users/Users/coaching_type", "method": "GET" }) }) });
    var coaching_supervisor170 = new Ext.form.Checkbox({ "boxLabel": "Benachrichtigung wenn ein Begleiter zugewiesen wird", "listeners": { "render": Lino.quicktip_renderer("Benachrichtigung wenn ein Begleiter zugewiesen wird","(users.Users.coaching_supervisor) Wenn ein Neuantrag einem Begleiter zugewiesen wurde, wird au\u00dfer dem Begleiter auch dieser Benutzer benachrichtigt.") }, "hideLabel": true, "checked": false, "name": "coaching_supervisor", "selectOnFocus": true, "anchor": "-20" });
    var newcomers_CompetencesByUser_grid176 = new Lino.newcomers.CompetencesByUser.GridPanel({ "flex": 62, "listeners": { "render": Lino.quicktip_renderer("Kompetenzen","(newcomers.newcomers.CompetencesByUser) ") }, "hide_top_toolbar": true, "containing_panel": this, "tools": [ Lino.show_in_own_window_button(Lino.newcomers.CompetencesByUser.grid) ], "master_panel": this });
    var coaching_a_panel177 = new Ext.Panel({ "flex": 33, "layout": "vbox", "items": [ { "items": newcomer_quota168, "autoHeight": true, "layout": "form", "xtype": "panel", "labelAlign": "top" }, { "items": coaching_type169, "autoHeight": true, "layout": "form", "xtype": "panel", "labelAlign": "top" }, { "items": coaching_supervisor170, "autoHeight": true, "layout": "form", "xtype": "panel", "labelAlign": "top" }, newcomers_CompetencesByUser_grid176 ], "frame": true, "layoutConfig": { "align": "stretch" }, "autoScroll": false, "hideCheckBoxLabels": true, "labelWidth": 468, "border": false, "bodyBorder": false, "labelAlign": "top" });
    var pcsw_CoachingsByUser_grid207 = new Lino.pcsw.CoachingsByUser.GridPanel({ "flex": 66, "listeners": { "render": Lino.quicktip_renderer("Begleitungen","(pcsw.pcsw.CoachingsByUser) ") }, "hide_top_toolbar": true, "containing_panel": this, "params_panel_hidden": true, "tools": [ Lino.show_in_own_window_button(Lino.pcsw.CoachingsByUser.grid) ], "master_panel": this });
    var coaching_1_panel208 = new Ext.Panel({ "autoScroll": false, "listeners": { "activate": Lino.on_tab_activate }, "border": false, "layout": "hbox", "title": "Begleitung", "hideCheckBoxLabels": true, "items": [ coaching_a_panel177, pcsw_CoachingsByUser_grid207 ], "frame": false, "layoutConfig": { "align": "stretch" }, "labelAlign": "top" });
    var main_panel209 = new Ext.TabPanel({ "hideCheckBoxLabels": true, "border": false, "split": true, "autoScroll": false, "items": [ general_panel97, cal_1_panel167, coaching_1_panel208 ], "activeTab": 0, "bodyBorder": false, "frame": true, "labelAlign": "top" });
    this.items = main_panel209;
    this.before_row_edit = function(record) {
      AuthoritiesGiven_grid94.on_master_changed();
      newcomers_CompetencesByUser_grid176.on_master_changed();
      pcsw_CoachingsByUser_grid207.on_master_changed();
    }
    Lino.users.MySettings.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.system.Home.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  disable_editing: true,
  initComponent : function() {
    var containing_panel = this;
    var quick_links_htmlbox1875 = new Lino.HtmlBoxPanel({ "flex": 1, "layout": "fit", "name": "quick_links", "containing_panel": this, "master_panel": this, "items": new Ext.BoxComponent({autoScroll:true}), "region": "north", "bodyStyle": "overflow-x:hidden", "value": "<br/>", "always_enabled": true, "listeners": { "render": Lino.quicktip_renderer(null,"(system.Home.quick_links) ") }, "split": true });
    var welcome_htmlbox1876 = new Lino.HtmlBoxPanel({ "flex": 3, "layout": "fit", "name": "welcome", "containing_panel": this, "master_panel": this, "items": new Ext.BoxComponent({autoScroll:true}), "region": "center", "title": "Willkommen", "bodyStyle": "overflow-x:hidden", "value": "<br/>", "always_enabled": true, "listeners": { "render": Lino.quicktip_renderer("Willkommen","(system.Home.welcome) ") }, "split": true });
    var main_panel1877 = new Lino.VBorderPanel({ "autoScroll": false, "border": false, "labelWidth": 99, "hideCheckBoxLabels": true, "items": [ quick_links_htmlbox1875, welcome_htmlbox1876 ], "frame": true, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel1877;
    this.before_row_edit = function(record) {
      quick_links_htmlbox1875.refresh();
      welcome_htmlbox1876.refresh();
    }
    Lino.system.Home.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.contacts.Partners.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 23,
  initComponent : function() {
    var containing_panel = this;
    var name340 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Name","(contacts.Partners.name) ") }, "fieldLabel": "Name", "name": "name", "maxLength": 200, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var country341 = new Lino.TwinCombo({ "fieldLabel": "Land", "name": "country", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.countries.Countries.detail)}, "emptyText": "Land ausw\u00e4hlen...", "listeners": { "render": Lino.quicktip_renderer("Land","(contacts.Partners.country) ") }, "selectOnFocus": true, "hiddenName": "countryHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/contacts/Partners/country", "method": "GET" }) }) });
    var region342 = new Lino.TwinCombo({ "fieldLabel": "Region", "name": "region", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.countries.Cities.detail)}, "emptyText": "Ort ausw\u00e4hlen...", "listeners": { "render": Lino.quicktip_renderer("Region","(contacts.Partners.region) ") }, "selectOnFocus": true, "hiddenName": "regionHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/contacts/Partners/region", "method": "GET" }) }) });
    var city343 = new Lino.TwinCombo({ "forceSelection": false, "fieldLabel": "Ort", "name": "city", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.countries.Cities.detail)}, "emptyText": "Ort ausw\u00e4hlen...", "listeners": { "render": Lino.quicktip_renderer("Ort","(contacts.Partners.city) ") }, "selectOnFocus": true, "hiddenName": "cityHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/contacts/Partners/city", "method": "GET" }) }) });
    var zip_code344 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Postleitzahl","(contacts.Partners.zip_code) ") }, "fieldLabel": "Postleitzahl", "name": "zip_code", "maxLength": 10, "selectOnFocus": true, "boxMinWidth": Lino.chars2width(10), "anchor": "-20" });
    var address_box_2_panel345 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 28, "autoHeight": true, "layout": "form", "xtype": "panel", "items": country341, "labelAlign": "top" }, { "flex": 28, "autoHeight": true, "layout": "form", "xtype": "panel", "items": region342, "labelAlign": "top" }, { "flex": 28, "autoHeight": true, "layout": "form", "xtype": "panel", "items": city343, "labelAlign": "top" }, { "flex": 14, "autoHeight": true, "layout": "form", "xtype": "panel", "items": zip_code344, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 117, "border": false, "anchor": "-20", "labelAlign": "top" });
    var addr1350 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Adresszeile vor Stra\u00dfe","(contacts.Partners.addr1) Address line before street") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Adresszeile vor Stra\u00dfe</span>", "name": "addr1", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var street_prefix351 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Pr\u00e4fix Stra\u00dfe","(contacts.Partners.street_prefix) Text to print before name of street, but to ignore for sorting.") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Pr\u00e4fix Stra\u00dfe</span>", "name": "street_prefix", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var street352 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Stra\u00dfe","(contacts.Partners.street) Name of street. Without house number.") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Stra\u00dfe</span>", "name": "street", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var street_no353 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Nr.","(contacts.Partners.street_no) House number") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Nr.</span>", "name": "street_no", "maxLength": 10, "selectOnFocus": true, "boxMinWidth": Lino.chars2width(10), "anchor": "-20" });
    var street_box354 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Box","(contacts.Partners.street_box) Text to print after :attr:`steet_no` on the same line") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Box</span>", "name": "street_box", "maxLength": 10, "selectOnFocus": true, "boxMinWidth": Lino.chars2width(10), "anchor": "-20" });
    var address_box_4_panel355 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 30, "autoHeight": true, "layout": "form", "xtype": "panel", "items": street_prefix351, "labelAlign": "top" }, { "flex": 36, "autoHeight": true, "layout": "form", "xtype": "panel", "items": street352, "labelAlign": "top" }, { "flex": 16, "autoHeight": true, "layout": "form", "xtype": "panel", "items": street_no353, "labelAlign": "top" }, { "flex": 16, "autoHeight": true, "layout": "form", "xtype": "panel", "items": street_box354, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 126, "border": false, "anchor": "-20", "labelAlign": "top" });
    var addr2360 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Adresszeile nach Stra\u00dfe","(contacts.Partners.addr2) Address line to print below street line") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Adresszeile nach Stra\u00dfe</span>", "name": "addr2", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var address_box_panel361 = new Ext.form.FieldSet({ "flex": 66, "autoHeight": true, "layout": "form", "title": "Adresse", "items": [ { "autoHeight": true, "layout": "form", "xtype": "panel", "items": name340, "anchor": "-20", "labelAlign": "top" }, address_box_2_panel345, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": addr1350, "anchor": "-20", "labelAlign": "top" }, address_box_4_panel355, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": addr2360, "anchor": "-20", "labelAlign": "top" } ], "frame": true, "bodyBorder": false, "autoScroll": false, "hideCheckBoxLabels": true, "labelWidth": 216, "border": false, "labelAlign": "top" });
    var id365 = new Ext.form.NumberField({ "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("ID","(contacts.Partners.id) ") }, "fieldLabel": "ID", "anchor": "-20", "name": "id" });
    var language366 = new Lino.ChoicesFieldElement({ "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Sprache</span>", "allowBlank": false, "value": "de", "hiddenName": "languageHidden", "listeners": { "render": Lino.quicktip_renderer("Sprache","(contacts.Partners.language) Die Sprache, in der Dokumente ausgestellt werden sollen.") }, "selectOnFocus": true, "anchor": "-20", "store": [ [ "de", "Deutsch" ], [ "fr", "Franz\u00f6sisch" ], [ "nl", "Niederl\u00e4ndisch" ] ], "name": "language" });
    var info_box_panel367 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 20, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id365, "labelAlign": "top" }, { "flex": 80, "autoHeight": true, "layout": "form", "xtype": "panel", "items": language366, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 72, "border": false, "anchor": "-20", "labelAlign": "top" });
    var email370 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("E-Mail","(contacts.Partners.email) ") }, "fieldLabel": "E-Mail", "name": "email", "maxLength": 75, "selectOnFocus": true, "anchor": "-20" });
    var url371 = new Lino.URLField({ "listeners": { "render": Lino.quicktip_renderer("URL","(contacts.Partners.url) ") }, "fieldLabel": "URL", "name": "url", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var phone372 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Telefon","(contacts.Partners.phone) ") }, "fieldLabel": "Telefon", "name": "phone", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var gsm373 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("GSM","(contacts.Partners.gsm) ") }, "fieldLabel": "GSM", "name": "gsm", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var fax374 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Fax","(contacts.Partners.fax) ") }, "fieldLabel": "Fax", "name": "fax", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var contact_box_5_panel375 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": gsm373, "labelAlign": "top" }, { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": fax374, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 36, "border": false, "anchor": "-20", "labelAlign": "top" });
    var contact_box_panel378 = new Ext.form.FieldSet({ "flex": 33, "autoHeight": true, "layout": "form", "title": "Kontakt", "items": [ info_box_panel367, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": email370, "anchor": "-20", "labelAlign": "top" }, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": url371, "anchor": "-20", "labelAlign": "top" }, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": phone372, "anchor": "-20", "labelAlign": "top" }, contact_box_5_panel375 ], "frame": true, "bodyBorder": false, "autoScroll": false, "hideCheckBoxLabels": true, "labelWidth": 72, "border": false, "labelAlign": "top" });
    var general_1_panel382 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "hideCheckBoxLabels": true, "items": [ address_box_panel361, contact_box_panel378 ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var remarks383 = new Ext.form.TextArea({ "listeners": { "render": Lino.quicktip_renderer("Bemerkungen","(contacts.Partners.remarks) ") }, "fieldLabel": "Bemerkungen", "name": "remarks", "growMax": 2000, "selectOnFocus": true, "anchor": "-20 -10" });
    var activity384 = new Lino.RemoteComboFieldElement({ "fieldLabel": "Beruf", "name": "activity", "pageSize": 20, "emptyText": "Beruf ausw\u00e4hlen...", "listeners": { "render": Lino.quicktip_renderer("Beruf","(contacts.Partners.activity) ") }, "selectOnFocus": true, "hiddenName": "activityHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/contacts/Partners/activity", "method": "GET" }) }) });
    var bank_account1385 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Bankkonto 1","(contacts.Partners.bank_account1) ") }, "fieldLabel": "Bankkonto 1", "name": "bank_account1", "maxLength": 40, "selectOnFocus": true, "anchor": "-20" });
    var bank_account2386 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Bankkonto 2","(contacts.Partners.bank_account2) ") }, "fieldLabel": "Bankkonto 2", "name": "bank_account2", "maxLength": 40, "selectOnFocus": true, "anchor": "-20" });
    var is_obsolete387 = new Ext.form.Checkbox({ "boxLabel": "veraltet", "listeners": { "render": Lino.quicktip_renderer("veraltet","(contacts.Partners.is_obsolete) Altf\u00e4lle sind Partner, deren Stammdaten nicht mehr gepflegt werden und \nf\u00fcr neue Operationen nicht benutzt werden k\u00f6nnen.") }, "hideLabel": true, "checked": false, "name": "is_obsolete", "selectOnFocus": true, "anchor": "-20" });
    var bottom_box_2_panel388 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 108, "hideCheckBoxLabels": true, "items": [ { "flex": 27, "autoHeight": true, "layout": "form", "xtype": "panel", "items": activity384, "labelAlign": "top" }, { "flex": 29, "autoHeight": true, "layout": "form", "xtype": "panel", "items": bank_account1385, "labelAlign": "top" }, { "flex": 29, "autoHeight": true, "layout": "form", "xtype": "panel", "items": bank_account2386, "labelAlign": "top" }, { "flex": 13, "autoHeight": true, "layout": "form", "xtype": "panel", "items": is_obsolete387, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var is_person393 = new Ext.form.Checkbox({ "boxLabel": "ist eine Person (<a href=\"javascript:Lino.show_mti_child('is_person',Lino.contacts.Persons.detail)\">zeigen</a>)", "listeners": { "render": Lino.quicktip_renderer("ist eine Person","(contacts.Partners.is_person) Ob dieser Partner auch eine Person ist.") }, "hideLabel": true, "name": "is_person", "selectOnFocus": true, "anchor": "-20" });
    var is_company394 = new Ext.form.Checkbox({ "boxLabel": "ist eine Organisation (<a href=\"javascript:Lino.show_mti_child('is_company',Lino.contacts.Companies.detail)\">zeigen</a>)", "listeners": { "render": Lino.quicktip_renderer("ist eine Organisation","(contacts.Partners.is_company) Ob dieser Partner auch eine Organisation ist.") }, "hideLabel": true, "name": "is_company", "selectOnFocus": true, "anchor": "-20" });
    var is_household395 = new Ext.form.Checkbox({ "boxLabel": "ist ein Haushalt (<a href=\"javascript:Lino.show_mti_child('is_household',Lino.households.Households.detail)\">zeigen</a>)", "listeners": { "render": Lino.quicktip_renderer("ist ein Haushalt","(contacts.Partners.is_household) ") }, "hideLabel": true, "name": "is_household", "selectOnFocus": true, "anchor": "-20" });
    var created396 = new Ext.form.DisplayField({ "disabled": true, "listeners": { "render": Lino.quicktip_renderer("Erstellt","(contacts.Partners.created) ") }, "fieldLabel": "Erstellt", "name": "created", "anchor": "-20", "value": "<br>" });
    var modified397 = new Ext.form.DisplayField({ "disabled": true, "listeners": { "render": Lino.quicktip_renderer("Bearbeitet","(contacts.Partners.modified) ") }, "fieldLabel": "Bearbeitet", "name": "modified", "anchor": "-20", "value": "<br>" });
    var bottom_box_3_panel398 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 198, "hideCheckBoxLabels": true, "items": [ { "flex": 16, "autoHeight": true, "layout": "form", "xtype": "panel", "items": is_person393, "labelAlign": "top" }, { "flex": 16, "autoHeight": true, "layout": "form", "xtype": "panel", "items": is_company394, "labelAlign": "top" }, { "flex": 16, "autoHeight": true, "layout": "form", "xtype": "panel", "items": is_household395, "labelAlign": "top" }, { "flex": 25, "autoHeight": true, "layout": "form", "xtype": "panel", "items": created396, "labelAlign": "top" }, { "flex": 25, "autoHeight": true, "layout": "form", "xtype": "panel", "items": modified397, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var bottom_box_panel404 = new Ext.Panel({ "flex": 58, "layout": "vbox", "items": [ { "items": remarks383, "labelAlign": "top", "layout": "form", "xtype": "panel", "flex": 71 }, bottom_box_2_panel388, bottom_box_3_panel398 ], "frame": true, "layoutConfig": { "align": "stretch" }, "autoScroll": false, "hideCheckBoxLabels": true, "labelWidth": 108, "border": false, "bodyBorder": false, "labelAlign": "top" });
    var general_panel406 = new Ext.Panel({ "layout": "vbox", "title": "Allgemein", "items": [ general_1_panel382, bottom_box_panel404 ], "frame": true, "layoutConfig": { "align": "stretch" }, "hideCheckBoxLabels": true, "listeners": { "activate": Lino.on_tab_activate }, "autoScroll": false, "border": false, "bodyBorder": false, "labelAlign": "top" });
    var changes_ChangesByMaster_grid431 = new Lino.changes.ChangesByMaster.GridPanel({ "listeners": { "activate": Lino.on_tab_activate }, "hide_top_toolbar": true, "containing_panel": this, "title": "\u00c4nderungen", "tools": [ Lino.show_in_own_window_button(Lino.changes.ChangesByMaster.grid) ], "master_panel": this });
    var main_panel552 = new Ext.TabPanel({ "hideCheckBoxLabels": true, "border": false, "split": true, "autoScroll": false, "items": [ general_panel406, changes_ChangesByMaster_grid431 ], "activeTab": 0, "bodyBorder": false, "frame": true, "labelAlign": "top" });
    this.items = main_panel552;
    this.before_row_edit = function(record) {
      region342.setContextValue('country',record ? record.data['countryHidden'] : undefined);
      city343.setContextValue('country',record ? record.data['countryHidden'] : undefined);
      city343.setContextValue('region',record ? record.data['regionHidden'] : undefined);
      changes_ChangesByMaster_grid431.on_master_changed();
    }
    this.onRender = function(ct, position) {
      country341.on('change',Lino.chooser_handler(region342,'country'));
      country341.on('change',Lino.chooser_handler(city343,'country'));
      region342.on('change',Lino.chooser_handler(city343,'region'));
      Lino.contacts.Partners.DetailFormPanel.superclass.onRender.call(this, ct, position);
    }
    Lino.contacts.Partners.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.users.MySettings.InsertFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  autoHeight: true,
  content_type: 7,
  initComponent : function() {
    var containing_panel = this;
    var username210 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Benutzername","(users.Users.username) \n        Required. Must be unique. \n        ") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Benutzername</span>", "name": "username", "maxLength": 30, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var email211 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("e-mail address","(users.Users.email) ") }, "fieldLabel": "e-mail address", "name": "email", "maxLength": 75, "selectOnFocus": true, "anchor": "-20" });
    var main_1_panel212 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": username210, "labelAlign": "top" }, { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": email211, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 135, "border": false, "anchor": "-20", "labelAlign": "top" });
    var first_name215 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Vorname","(users.Users.first_name) ") }, "fieldLabel": "Vorname", "name": "first_name", "maxLength": 30, "selectOnFocus": true, "anchor": "-20" });
    var last_name216 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Familienname","(users.Users.last_name) ") }, "fieldLabel": "Familienname", "name": "last_name", "maxLength": 30, "selectOnFocus": true, "anchor": "-20" });
    var main_2_panel217 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": first_name215, "labelAlign": "top" }, { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": last_name216, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 117, "border": false, "anchor": "-20", "labelAlign": "top" });
    var partner220 = new Lino.TwinCombo({ "fieldLabel": "Partner", "name": "partner", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.contacts.Partners.detail)}, "emptyText": "Partner ausw\u00e4hlen...", "listeners": { "render": Lino.quicktip_renderer("Partner","(users.Users.partner) ") }, "selectOnFocus": true, "hiddenName": "partnerHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/users/Users/partner", "method": "GET" }) }) });
    var language221 = new Lino.ChoicesFieldElement({ "fieldLabel": "Sprache", "allowBlank": false, "hiddenName": "languageHidden", "listeners": { "render": Lino.quicktip_renderer("Sprache","(users.Users.language) ") }, "selectOnFocus": true, "anchor": "-20", "store": [ [ "de", "Deutsch" ], [ "fr", "Franz\u00f6sisch" ], [ "nl", "Niederl\u00e4ndisch" ] ], "name": "language" });
    var profile222 = new Lino.ChoicesFieldElement({ "forceSelection": true, "fieldLabel": "Benutzerprofil", "name": "profile", "hiddenName": "profileHidden", "listeners": { "render": Lino.quicktip_renderer("Benutzerprofil","(users.Users.profile) ") }, "selectOnFocus": true, "anchor": "-20", "store": [['','<br>']].concat(Lino.lino.UserProfiles) });
    var main_4_panel223 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 32, "autoHeight": true, "layout": "form", "xtype": "panel", "items": language221, "labelAlign": "top" }, { "flex": 67, "autoHeight": true, "layout": "form", "xtype": "panel", "items": profile222, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 135, "border": false, "anchor": "-20", "labelAlign": "top" });
    var main_panel226 = new Ext.Panel({ "hideCheckBoxLabels": true, "autoHeight": true, "border": false, "layout": "form", "labelWidth": 72, "autoScroll": false, "items": [ main_1_panel212, main_2_panel217, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": partner220, "anchor": "-20", "labelAlign": "top" }, main_4_panel223 ], "frame": true, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel226;
    this.before_row_edit = function(record) {
    }
    Lino.users.MySettings.InsertFormPanel.superclass.initComponent.call(this);
  }
});


Lino.reception.ExpectedGuests.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 37,
  initComponent : function() {
    var containing_panel = this;
    var event911 = new Lino.TwinCombo({ "fieldLabel": "Termin", "allowBlank": false, "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.cal.Events.detail)}, "emptyText": "Termin ausw\u00e4hlen...", "listeners": { "render": Lino.quicktip_renderer("Termin","(cal.Guests.event) ") }, "selectOnFocus": true, "hiddenName": "eventHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/Guests/event", "method": "GET" }) }), "name": "event" });
    var partner912 = new Lino.TwinCombo({ "fieldLabel": "Partner", "allowBlank": false, "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.contacts.Partners.detail)}, "emptyText": "Partner ausw\u00e4hlen...", "listeners": { "render": Lino.quicktip_renderer("Partner","(cal.Guests.partner) ") }, "selectOnFocus": true, "hiddenName": "partnerHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/Guests/partner", "method": "GET" }) }), "name": "partner" });
    var role913 = new Lino.TwinCombo({ "fieldLabel": "Rolle", "name": "role", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.cal.GuestRoles.detail)}, "emptyText": "Gastrolle ausw\u00e4hlen...", "listeners": { "render": Lino.quicktip_renderer("Rolle","(cal.Guests.role) ") }, "selectOnFocus": true, "hiddenName": "roleHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/Guests/role", "method": "GET" }) }) });
    var main_1_panel914 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 72, "hideCheckBoxLabels": true, "items": [ { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": event911, "labelAlign": "top" }, { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": partner912, "labelAlign": "top" }, { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": role913, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var state918 = new Lino.ChoicesFieldElement({ "forceSelection": true, "fieldLabel": "Zustand", "allowBlank": false, "hiddenName": "stateHidden", "listeners": { "render": Lino.quicktip_renderer("Zustand","(cal.Guests.state) ") }, "selectOnFocus": true, "anchor": "-20", "store": Lino.cal.GuestStates, "name": "state" });
    var remark919 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Bemerkung","(cal.Guests.remark) ") }, "fieldLabel": "Bemerkung", "name": "remark", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var workflow_buttons_disp920 = new Ext.form.DisplayField({ "disabled": true, "listeners": { "render": Lino.quicktip_renderer("Arbeitsablauf","(cal.Guests.workflow_buttons) ") }, "fieldLabel": "Arbeitsablauf", "name": "workflow_buttons", "anchor": "-20", "value": "<br/>", "always_enabled": true });
    var main_2_panel921 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 126, "hideCheckBoxLabels": true, "items": [ { "flex": 20, "autoHeight": true, "layout": "form", "xtype": "panel", "items": state918, "labelAlign": "top" }, { "flex": 32, "autoHeight": true, "layout": "form", "xtype": "panel", "items": remark919, "labelAlign": "top" }, { "flex": 46, "autoHeight": true, "layout": "form", "xtype": "panel", "items": workflow_buttons_disp920, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var outbox_MailsByController_grid925 = new Lino.outbox.MailsByController.GridPanel({ "flex": 55, "listeners": { "render": Lino.quicktip_renderer("E-Mail-Ausg\u00e4nge","(outbox.outbox.MailsByController) ") }, "hide_top_toolbar": true, "containing_panel": this, "tools": [ Lino.show_in_own_window_button(Lino.outbox.MailsByController.grid) ], "master_panel": this });
    var main_panel926 = new Ext.Panel({ "autoScroll": false, "border": false, "layout": "vbox", "hideCheckBoxLabels": true, "items": [ main_1_panel914, main_2_panel921, outbox_MailsByController_grid925 ], "frame": true, "layoutConfig": { "align": "stretch" }, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel926;
    this.before_row_edit = function(record) {
      outbox_MailsByController_grid925.on_master_changed();
    }
    Lino.reception.ExpectedGuests.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.uploads.MyUploads.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 26,
  initComponent : function() {
    var containing_panel = this;
    var file1822 = Lino.file_field_handler(this,{ "listeners": { "render": Lino.quicktip_renderer("Datei","(uploads.Uploads.file) ") }, "fieldLabel": "Datei", "name": "file", "maxLength": 100, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var user1823 = new Lino.TwinCombo({ "fieldLabel": "Autor", "name": "user", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.users.Users.detail)}, "emptyText": "Benutzer ausw\u00e4hlen...", "listeners": { "render": Lino.quicktip_renderer("Autor","(uploads.Uploads.user) ") }, "selectOnFocus": true, "hiddenName": "userHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/uploads/Uploads/user", "method": "GET" }) }) });
    var main_1_panel1824 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 54, "hideCheckBoxLabels": true, "items": [ { "flex": 58, "autoHeight": true, "layout": "form", "xtype": "panel", "items": file1822, "labelAlign": "top" }, { "flex": 41, "autoHeight": true, "layout": "form", "xtype": "panel", "items": user1823, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var type1827 = new Lino.RemoteComboFieldElement({ "fieldLabel": "Upload-Art", "name": "type", "pageSize": 20, "emptyText": "Upload-Art ausw\u00e4hlen...", "listeners": { "render": Lino.quicktip_renderer("Upload-Art","(uploads.Uploads.type) ") }, "selectOnFocus": true, "hiddenName": "typeHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/uploads/Uploads/type", "method": "GET" }) }) });
    var description1828 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Beschreibung","(uploads.Uploads.description) ") }, "fieldLabel": "Beschreibung", "name": "description", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var valid_until1829 = new Lino.DateField({ "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("g\u00fcltig bis","(uploads.Uploads.valid_until) ") }, "fieldLabel": "g\u00fcltig bis", "anchor": "-20", "name": "valid_until" });
    var main_2_panel1830 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 117, "hideCheckBoxLabels": true, "items": [ { "flex": 40, "autoHeight": true, "layout": "form", "xtype": "panel", "items": type1827, "labelAlign": "top" }, { "flex": 42, "autoHeight": true, "layout": "form", "xtype": "panel", "items": description1828, "labelAlign": "top" }, { "flex": 16, "autoHeight": true, "layout": "form", "xtype": "panel", "items": valid_until1829, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var modified1834 = new Ext.form.DisplayField({ "disabled": true, "listeners": { "render": Lino.quicktip_renderer("Bearbeitet","(uploads.Uploads.modified) ") }, "fieldLabel": "Bearbeitet", "name": "modified", "anchor": "-20", "value": "<br>" });
    var created1835 = new Ext.form.DisplayField({ "disabled": true, "listeners": { "render": Lino.quicktip_renderer("Erstellt","(uploads.Uploads.created) ") }, "fieldLabel": "Erstellt", "name": "created", "anchor": "-20", "value": "<br>" });
    var owner_disp1836 = new Ext.form.DisplayField({ "disabled": true, "fieldLabel": "Verkn\u00fcpft mit", "anchor": "-20", "name": "owner" });
    var main_3_panel1837 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 126, "hideCheckBoxLabels": true, "items": [ { "flex": 38, "autoHeight": true, "layout": "form", "xtype": "panel", "items": modified1834, "labelAlign": "top" }, { "flex": 38, "autoHeight": true, "layout": "form", "xtype": "panel", "items": created1835, "labelAlign": "top" }, { "flex": 23, "autoHeight": true, "layout": "form", "xtype": "panel", "items": owner_disp1836, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var main_panel1842 = new Ext.Panel({ "autoScroll": false, "border": false, "layout": "vbox", "hideCheckBoxLabels": true, "items": [ main_1_panel1824, main_2_panel1830, main_3_panel1837 ], "frame": true, "layoutConfig": { "align": "stretch" }, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel1842;
    this.before_row_edit = function(record) {
    }
    Lino.uploads.MyUploads.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.lino.Home.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  disable_editing: true,
  initComponent : function() {
    var containing_panel = this;
    var quick_links_htmlbox1878 = new Lino.HtmlBoxPanel({ "flex": 1, "layout": "fit", "name": "quick_links", "containing_panel": this, "master_panel": this, "items": new Ext.BoxComponent({autoScroll:true}), "region": "north", "bodyStyle": "overflow-x:hidden", "value": "<br/>", "always_enabled": true, "listeners": { "render": Lino.quicktip_renderer(null,"(lino.Home.quick_links) ") }, "split": true });
    var welcome_htmlbox1879 = new Lino.HtmlBoxPanel({ "flex": 3, "layout": "fit", "name": "welcome", "containing_panel": this, "master_panel": this, "items": new Ext.BoxComponent({autoScroll:true}), "region": "center", "title": "Willkommen", "bodyStyle": "overflow-x:hidden", "value": "<br/>", "always_enabled": true, "listeners": { "render": Lino.quicktip_renderer("Willkommen","(lino.Home.welcome) ") }, "split": true });
    var coming_reminders_htmlbox1880 = new Lino.HtmlBoxPanel({ "flex": 50, "layout": "fit", "name": "coming_reminders", "containing_panel": this, "master_panel": this, "items": new Ext.BoxComponent({autoScroll:true}), "title": "Ausblick", "bodyStyle": "overflow-x:hidden", "value": "<br/>", "always_enabled": true, "listeners": { "render": Lino.quicktip_renderer("Ausblick","(lino.Home.coming_reminders) ") } });
    var missed_reminders_htmlbox1881 = new Lino.HtmlBoxPanel({ "flex": 50, "layout": "fit", "name": "missed_reminders", "containing_panel": this, "master_panel": this, "items": new Ext.BoxComponent({autoScroll:true}), "title": "Verpasste Erinnerungen", "bodyStyle": "overflow-x:hidden", "value": "<br/>", "always_enabled": true, "listeners": { "render": Lino.quicktip_renderer("Verpasste Erinnerungen","(lino.Home.missed_reminders) ") } });
    var main_3_panel1882 = new Ext.Panel({ "flex": 16, "layout": "hbox", "items": [ coming_reminders_htmlbox1880, missed_reminders_htmlbox1881 ], "region": "south", "layoutConfig": { "align": "stretch" }, "hideCheckBoxLabels": true, "split": true, "autoScroll": false, "labelWidth": 207, "border": false, "frame": false, "labelAlign": "top" });
    var main_panel1883 = new Lino.VBorderPanel({ "autoScroll": false, "border": false, "labelWidth": 99, "hideCheckBoxLabels": true, "items": [ quick_links_htmlbox1878, welcome_htmlbox1879, main_3_panel1882 ], "frame": true, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel1883;
    this.before_row_edit = function(record) {
      quick_links_htmlbox1878.refresh();
      welcome_htmlbox1879.refresh();
      coming_reminders_htmlbox1880.refresh();
      missed_reminders_htmlbox1881.refresh();
    }
    Lino.lino.Home.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.changes.ChangesByMaster.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 10,
  disable_editing: true,
  initComponent : function() {
    var containing_panel = this;
    var time415 = new Ext.form.DisplayField({ "listeners": { "render": Lino.quicktip_renderer("time","(changes.Changes.time) ") }, "fieldLabel": "time", "name": "time", "selectOnFocus": true, "anchor": "-20", "value": "<br>", "allowBlank": false });
    var user416 = new Lino.TwinCombo({ "fieldLabel": "Benutzer", "allowBlank": false, "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.users.Users.detail)}, "emptyText": "Benutzer ausw\u00e4hlen...", "listeners": { "render": Lino.quicktip_renderer("Benutzer","(changes.Changes.user) ") }, "selectOnFocus": true, "hiddenName": "userHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/changes/Changes/user", "method": "GET" }) }), "name": "user" });
    var type417 = new Lino.ChoicesFieldElement({ "forceSelection": true, "fieldLabel": "\u00c4nderungsart", "allowBlank": false, "hiddenName": "typeHidden", "listeners": { "render": Lino.quicktip_renderer("\u00c4nderungsart","(changes.Changes.type) ") }, "selectOnFocus": true, "anchor": "-20", "store": Lino.lino.ChangeTypes, "name": "type" });
    var master_disp418 = new Ext.form.DisplayField({ "disabled": true, "fieldLabel": "Stammdaten", "anchor": "-20", "name": "master" });
    var object_disp419 = new Ext.form.DisplayField({ "disabled": true, "fieldLabel": "Object", "anchor": "-20", "name": "object" });
    var id420 = new Ext.form.NumberField({ "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("ID","(changes.Changes.id) ") }, "fieldLabel": "ID", "anchor": "-20", "name": "id" });
    var main_1_panel421 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 117, "hideCheckBoxLabels": true, "items": [ { "flex": 21, "autoHeight": true, "layout": "form", "xtype": "panel", "items": time415, "labelAlign": "top" }, { "flex": 20, "autoHeight": true, "layout": "form", "xtype": "panel", "items": user416, "labelAlign": "top" }, { "flex": 23, "autoHeight": true, "layout": "form", "xtype": "panel", "items": type417, "labelAlign": "top" }, { "flex": 13, "autoHeight": true, "layout": "form", "xtype": "panel", "items": master_disp418, "labelAlign": "top" }, { "flex": 13, "autoHeight": true, "layout": "form", "xtype": "panel", "items": object_disp419, "labelAlign": "top" }, { "flex": 6, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id420, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var diff428 = new Ext.form.TextArea({ "listeners": { "render": Lino.quicktip_renderer("\u00c4nderungen","(changes.Changes.diff) ") }, "fieldLabel": "\u00c4nderungen", "name": "diff", "growMax": 2000, "selectOnFocus": true, "anchor": "-20 -10" });
    var main_panel429 = new Ext.Panel({ "autoScroll": false, "border": false, "layout": "vbox", "labelWidth": 99, "hideCheckBoxLabels": true, "items": [ main_1_panel421, { "items": diff428, "labelAlign": "top", "layout": "form", "xtype": "panel", "flex": 83 } ], "frame": true, "layoutConfig": { "align": "stretch" }, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel429;
    this.before_row_edit = function(record) {
    }
    Lino.changes.ChangesByMaster.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.contacts.Companies.InsertFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  autoHeight: true,
  content_type: 20,
  initComponent : function() {
    var containing_panel = this;
    var name792 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Name","(contacts.Companies.name) ") }, "fieldLabel": "Name", "name": "name", "maxLength": 200, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var language793 = new Lino.ChoicesFieldElement({ "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Sprache</span>", "allowBlank": false, "value": "de", "hiddenName": "languageHidden", "listeners": { "render": Lino.quicktip_renderer("Sprache","(contacts.Companies.language) Die Sprache, in der Dokumente ausgestellt werden sollen.") }, "selectOnFocus": true, "anchor": "-20", "store": [ [ "de", "Deutsch" ], [ "fr", "Franz\u00f6sisch" ], [ "nl", "Niederl\u00e4ndisch" ] ], "name": "language" });
    var email794 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("E-Mail","(contacts.Companies.email) ") }, "fieldLabel": "E-Mail", "name": "email", "maxLength": 75, "selectOnFocus": true, "anchor": "-20" });
    var main_2_panel795 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": language793, "labelAlign": "top" }, { "flex": 66, "autoHeight": true, "layout": "form", "xtype": "panel", "items": email794, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 72, "border": false, "anchor": "-20", "labelAlign": "top" });
    var type798 = new Lino.RemoteComboFieldElement({ "fieldLabel": "Organisationsart", "name": "type", "pageSize": 20, "emptyText": "Organisationsart ausw\u00e4hlen...", "listeners": { "render": Lino.quicktip_renderer("Organisationsart","(contacts.Companies.type) ") }, "selectOnFocus": true, "hiddenName": "typeHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/contacts/Companies/type", "method": "GET" }) }) });
    var id799 = new Ext.form.NumberField({ "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("ID","(contacts.Companies.id) ") }, "fieldLabel": "ID", "anchor": "-20", "name": "id" });
    var main_3_panel800 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 80, "autoHeight": true, "layout": "form", "xtype": "panel", "items": type798, "labelAlign": "top" }, { "flex": 20, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id799, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 153, "border": false, "anchor": "-20", "labelAlign": "top" });
    var main_panel803 = new Ext.Panel({ "hideCheckBoxLabels": true, "autoHeight": true, "border": false, "layout": "form", "labelWidth": 45, "autoScroll": false, "items": [ { "autoHeight": true, "layout": "form", "xtype": "panel", "items": name792, "anchor": "-20", "labelAlign": "top" }, main_2_panel795, main_3_panel800 ], "frame": true, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel803;
    this.before_row_edit = function(record) {
    }
    Lino.contacts.Companies.InsertFormPanel.superclass.initComponent.call(this);
  }
});


Lino.countries.Countries.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 11,
  initComponent : function() {
    var containing_panel = this;
    var isocode247 = new Ext.form.TextField({ "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">ISO-Code</span>", "name": "isocode", "boxMinWidth": Lino.chars2width(4), "listeners": { "render": Lino.quicktip_renderer("ISO-Code","(countries.Countries.isocode)         The two-letter code for this country as defined by ISO 3166-1. \n        For countries that no longer exist it may be a 4-letter code.") }, "maxLength": 4, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var name248 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Bezeichnung","(countries.Countries.name) ") }, "fieldLabel": "Bezeichnung", "name": "name", "maxLength": 200, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var name_fr249 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Bezeichnung (fr)","(countries.Countries.name_fr) ") }, "fieldLabel": "Bezeichnung (fr)", "name": "name_fr", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var name_nl250 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Bezeichnung (nl)","(countries.Countries.name_nl) ") }, "fieldLabel": "Bezeichnung (nl)", "name": "name_nl", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var short_code251 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Short code","(countries.Countries.short_code) A short abbreviation for regional usage. Obsolete.") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Short code</span>", "name": "short_code", "maxLength": 4, "selectOnFocus": true, "boxMinWidth": Lino.chars2width(4), "anchor": "-20" });
    var inscode252 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("INS-Code","(countries.Countries.inscode) The official code for this country used by statbel.fgov.be") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">INS-Code</span>", "name": "inscode", "maxLength": 3, "selectOnFocus": true, "boxMinWidth": Lino.chars2width(3), "anchor": "-20" });
    var main_1_panel253 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 153, "hideCheckBoxLabels": true, "items": [ { "flex": 6, "autoHeight": true, "layout": "form", "xtype": "panel", "items": isocode247, "labelAlign": "top" }, { "flex": 27, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name248, "labelAlign": "top" }, { "flex": 27, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_fr249, "labelAlign": "top" }, { "flex": 27, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_nl250, "labelAlign": "top" }, { "flex": 6, "autoHeight": true, "layout": "form", "xtype": "panel", "items": short_code251, "labelAlign": "top" }, { "flex": 5, "autoHeight": true, "layout": "form", "xtype": "panel", "items": inscode252, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var countries_CitiesByCountry_grid582 = new Lino.countries.CitiesByCountry.GridPanel({ "flex": 48, "listeners": { "render": Lino.quicktip_renderer("Orte","(countries.countries.CitiesByCountry) ") }, "hide_top_toolbar": true, "containing_panel": this, "tools": [ Lino.show_in_own_window_button(Lino.countries.CitiesByCountry.grid) ], "master_panel": this });
    var main_2_panel596 = new Ext.Panel({ "flex": 83, "border": false, "layout": "hbox", "hideCheckBoxLabels": true, "items": [ countries_CitiesByCountry_grid582 ], "autoScroll": false, "layoutConfig": { "align": "stretch" }, "frame": false, "labelAlign": "top" });
    var main_panel597 = new Ext.Panel({ "autoScroll": false, "border": false, "layout": "vbox", "hideCheckBoxLabels": true, "items": [ main_1_panel253, main_2_panel596 ], "frame": true, "layoutConfig": { "align": "stretch" }, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel597;
    this.before_row_edit = function(record) {
      countries_CitiesByCountry_grid582.on_master_changed();
    }
    Lino.countries.Countries.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.countries.CitiesByCity.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 13,
  initComponent : function() {
    var containing_panel = this;
    var name269 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Bezeichnung","(countries.Cities.name) ") }, "fieldLabel": "Bezeichnung", "name": "name", "maxLength": 200, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var name_fr270 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Bezeichnung (fr)","(countries.Cities.name_fr) ") }, "fieldLabel": "Bezeichnung (fr)", "name": "name_fr", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var name_nl271 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Bezeichnung (nl)","(countries.Cities.name_nl) ") }, "fieldLabel": "Bezeichnung (nl)", "name": "name_nl", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var country272 = new Lino.TwinCombo({ "fieldLabel": "Land", "allowBlank": false, "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.countries.Countries.detail)}, "emptyText": "Land ausw\u00e4hlen...", "listeners": { "render": Lino.quicktip_renderer("Land","(countries.Cities.country) ") }, "selectOnFocus": true, "hiddenName": "countryHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/countries/Cities/country", "method": "GET" }) }), "name": "country" });
    var inscode273 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("INS-Code","(countries.Cities.inscode) The official code for this place used by statbel.fgov.be") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">INS-Code</span>", "name": "inscode", "maxLength": 5, "selectOnFocus": true, "boxMinWidth": Lino.chars2width(5), "anchor": "-20" });
    var main_1_panel274 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 153, "hideCheckBoxLabels": true, "items": [ { "flex": 23, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name269, "labelAlign": "top" }, { "flex": 23, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_fr270, "labelAlign": "top" }, { "flex": 23, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_nl271, "labelAlign": "top" }, { "flex": 22, "autoHeight": true, "layout": "form", "xtype": "panel", "items": country272, "labelAlign": "top" }, { "flex": 6, "autoHeight": true, "layout": "form", "xtype": "panel", "items": inscode273, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var parent280 = new Lino.TwinCombo({ "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Teil von</span>", "name": "parent", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.countries.Cities.detail)}, "emptyText": "Ort ausw\u00e4hlen...", "listeners": { "render": Lino.quicktip_renderer("Teil von","(countries.Cities.parent) The superordinate geographic place of which this place is a part.") }, "selectOnFocus": true, "hiddenName": "parentHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/countries/Cities/parent", "method": "GET" }) }) });
    var type281 = new Lino.RemoteComboFieldElement({ "listeners": { "render": Lino.quicktip_renderer("Ortsart","(countries.Cities.type) ") }, "fieldLabel": "Ortsart", "name": "type", "selectOnFocus": true, "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/countries/Cities/type", "method": "GET" }) }), "hiddenName": "typeHidden" });
    var id282 = new Ext.form.NumberField({ "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("ID","(countries.Cities.id) ") }, "fieldLabel": "ID", "anchor": "-20", "name": "id" });
    var main_2_panel283 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 81, "hideCheckBoxLabels": true, "items": [ { "flex": 57, "autoHeight": true, "layout": "form", "xtype": "panel", "items": parent280, "labelAlign": "top" }, { "flex": 28, "autoHeight": true, "layout": "form", "xtype": "panel", "items": type281, "labelAlign": "top" }, { "flex": 14, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id282, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var CitiesByCity_grid577 = new Lino.countries.CitiesByCity.GridPanel({ "flex": 41, "listeners": { "render": Lino.quicktip_renderer("Subdivisions","(countries.countries.CitiesByCity) ") }, "hide_top_toolbar": true, "containing_panel": this, "tools": [ Lino.show_in_own_window_button(Lino.countries.CitiesByCity.grid) ], "master_panel": this });
    var contacts_PartnersByCity_grid578 = new Lino.contacts.PartnersByCity.GridPanel({ "flex": 50, "listeners": { "render": Lino.quicktip_renderer("Partner","(contacts.contacts.PartnersByCity) ") }, "hide_top_toolbar": true, "containing_panel": this, "tools": [ Lino.show_in_own_window_button(Lino.contacts.PartnersByCity.grid) ], "master_panel": this });
    var main_4_panel580 = new Ext.Panel({ "flex": 41, "border": false, "layout": "hbox", "hideCheckBoxLabels": true, "items": [ contacts_PartnersByCity_grid578 ], "autoScroll": false, "layoutConfig": { "align": "stretch" }, "frame": false, "labelAlign": "top" });
    var main_panel581 = new Ext.Panel({ "autoScroll": false, "border": false, "layout": "vbox", "hideCheckBoxLabels": true, "items": [ main_1_panel274, main_2_panel283, CitiesByCity_grid577, main_4_panel580 ], "frame": true, "layoutConfig": { "align": "stretch" }, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel581;
    this.before_row_edit = function(record) {
      type281.setContextValue('country',record ? record.data['countryHidden'] : undefined);
      CitiesByCity_grid577.on_master_changed();
      contacts_PartnersByCity_grid578.on_master_changed();
    }
    this.onRender = function(ct, position) {
      country272.on('change',Lino.chooser_handler(type281,'country'));
      Lino.countries.CitiesByCity.DetailFormPanel.superclass.onRender.call(this, ct, position);
    }
    Lino.countries.CitiesByCity.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.cbss.RetrieveTIGroupsRequests.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 90,
  initComponent : function() {
    var containing_panel = this;
    var id1775 = new Ext.form.NumberField({ "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("ID","(cbss.RetrieveTIGroupsRequests.id) ") }, "fieldLabel": "ID", "anchor": "-20", "name": "id" });
    var person1776 = new Lino.TwinCombo({ "fieldLabel": "Klient", "allowBlank": false, "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.pcsw.Clients.detail)}, "emptyText": "Klient ausw\u00e4hlen...", "listeners": { "render": Lino.quicktip_renderer("Klient","(cbss.RetrieveTIGroupsRequests.person) ") }, "selectOnFocus": true, "hiddenName": "personHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cbss/RetrieveTIGroupsRequests/person", "method": "GET" }) }), "name": "person" });
    var user1777 = new Lino.TwinCombo({ "fieldLabel": "Autor", "allowBlank": false, "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.users.Users.detail)}, "emptyText": "Benutzer ausw\u00e4hlen...", "listeners": { "render": Lino.quicktip_renderer("Autor","(cbss.RetrieveTIGroupsRequests.user) ") }, "selectOnFocus": true, "hiddenName": "userHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cbss/RetrieveTIGroupsRequests/user", "method": "GET" }) }), "name": "user" });
    var environment1778 = new Ext.form.TextField({ "disabled": true, "listeners": { "render": Lino.quicktip_renderer("T/A/B","(cbss.RetrieveTIGroupsRequests.environment) ") }, "fieldLabel": "T/A/B", "name": "environment", "maxLength": 4, "boxMinWidth": Lino.chars2width(4), "anchor": "-20" });
    var sent1779 = new Ext.form.DisplayField({ "disabled": true, "listeners": { "render": Lino.quicktip_renderer("Versendet","(cbss.RetrieveTIGroupsRequests.sent) The date and time when this request has been executed. \nThis is empty for requests than haven't been sent.\nRead-only.") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Versendet</span>", "name": "sent", "anchor": "-20", "value": "<br>" });
    var status1780 = new Lino.ChoicesFieldElement({ "forceSelection": true, "fieldLabel": "Zustand", "name": "status", "hiddenName": "statusHidden", "disabled": true, "listeners": { "render": Lino.quicktip_renderer("Zustand","(cbss.RetrieveTIGroupsRequests.status) ") }, "anchor": "-20", "store": [['','<br>']].concat(Lino.cbss.RequestStates) });
    var ticket1781 = new Ext.form.TextField({ "disabled": true, "listeners": { "render": Lino.quicktip_renderer("Ticket","(cbss.RetrieveTIGroupsRequests.ticket) ") }, "fieldLabel": "Ticket", "name": "ticket", "maxLength": 36, "anchor": "-20" });
    var info_1_panel1782 = new Ext.form.FieldSet({ "autoHeight": true, "layout": "hbox", "title": "Info zur Anfrage", "layoutConfig": { "align": "stretchmax" }, "frame": false, "bodyBorder": true, "autoScroll": false, "items": [ { "flex": 5, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id1775, "labelAlign": "top" }, { "flex": 20, "autoHeight": true, "layout": "form", "xtype": "panel", "items": person1776, "labelAlign": "top" }, { "flex": 15, "autoHeight": true, "layout": "form", "xtype": "panel", "items": user1777, "labelAlign": "top" }, { "flex": 5, "autoHeight": true, "layout": "form", "xtype": "panel", "items": environment1778, "labelAlign": "top" }, { "flex": 16, "autoHeight": true, "layout": "form", "xtype": "panel", "items": sent1779, "labelAlign": "top" }, { "flex": 18, "autoHeight": true, "layout": "form", "xtype": "panel", "items": status1780, "labelAlign": "top" }, { "flex": 21, "autoHeight": true, "layout": "form", "xtype": "panel", "items": ticket1781, "labelAlign": "top" } ], "hideCheckBoxLabels": true, "labelWidth": 90, "border": false, "labelAlign": "top" });
    var national_id1790 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("NR-Nummer","(cbss.RetrieveTIGroupsRequests.national_id) ") }, "fieldLabel": "NR-Nummer", "name": "national_id", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var language1791 = new Lino.ChoicesFieldElement({ "forceSelection": true, "fieldLabel": "Sprache", "name": "language", "hiddenName": "languageHidden", "listeners": { "render": Lino.quicktip_renderer("Sprache","(cbss.RetrieveTIGroupsRequests.language) ") }, "selectOnFocus": true, "anchor": "-20", "store": [['','<br>']].concat(Lino.cbss.RequestLanguages) });
    var history1792 = new Ext.form.Checkbox({ "boxLabel": "Historie", "listeners": { "render": Lino.quicktip_renderer("Historie","(cbss.RetrieveTIGroupsRequests.history) Whatever this means.") }, "hideLabel": true, "checked": true, "name": "history", "selectOnFocus": true, "anchor": "-20" });
    var parameters_panel1793 = new Ext.form.FieldSet({ "autoHeight": true, "layout": "hbox", "title": "Parameter", "layoutConfig": { "align": "stretchmax" }, "frame": false, "bodyBorder": true, "autoScroll": false, "items": [ { "flex": 43, "autoHeight": true, "layout": "form", "xtype": "panel", "items": national_id1790, "labelAlign": "top" }, { "flex": 35, "autoHeight": true, "layout": "form", "xtype": "panel", "items": language1791, "labelAlign": "top" }, { "flex": 20, "autoHeight": true, "layout": "form", "xtype": "panel", "items": history1792, "labelAlign": "top" } ], "hideCheckBoxLabels": true, "labelWidth": 90, "border": false, "labelAlign": "top" });
    var cbss_RetrieveTIGroupsResult_grid1802 = new Lino.cbss.RetrieveTIGroupsResult.GridPanel({ "flex": 71, "listeners": { "render": Lino.quicktip_renderer("Resultate","(cbss.cbss.RetrieveTIGroupsResult) ") }, "hide_top_toolbar": true, "containing_panel": this, "tools": [ Lino.show_in_own_window_button(Lino.cbss.RetrieveTIGroupsResult.grid) ], "master_panel": this });
    var request_panel1803 = new Ext.Panel({ "layout": "vbox", "title": "Abfrage", "items": [ info_1_panel1782, parameters_panel1793, cbss_RetrieveTIGroupsResult_grid1802 ], "frame": true, "layoutConfig": { "align": "stretch" }, "hideCheckBoxLabels": true, "listeners": { "activate": Lino.on_tab_activate }, "autoScroll": false, "border": false, "bodyBorder": false, "labelAlign": "top" });
    var response_xml1804 = new Ext.form.TextArea({ "disabled": true, "listeners": { "render": Lino.quicktip_renderer("Antwort","(cbss.RetrieveTIGroupsRequests.response_xml) The raw XML response received. \n") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Antwort</span>", "name": "response_xml", "growMax": 2000, "anchor": "-20 -10" });
    var info_messages1805 = new Ext.form.TextArea({ "disabled": true, "listeners": { "render": Lino.quicktip_renderer("Info-Meldungen","(cbss.RetrieveTIGroupsRequests.info_messages) ") }, "fieldLabel": "Info-Meldungen", "name": "info_messages", "growMax": 2000, "anchor": "-20 -10" });
    var debug_messages1806 = new Ext.form.TextArea({ "disabled": true, "listeners": { "render": Lino.quicktip_renderer("Debug-Meldungen","(cbss.RetrieveTIGroupsRequests.debug_messages) ") }, "fieldLabel": "Debug-Meldungen", "name": "debug_messages", "growMax": 2000, "anchor": "-20 -10" });
    var technical_panel1807 = new Lino.VBorderPanel({ "autoScroll": false, "listeners": { "activate": Lino.on_tab_activate }, "border": false, "labelWidth": 144, "title": "Technisch", "hideCheckBoxLabels": true, "items": [ { "flex": 5, "layout": "form", "xtype": "panel", "items": response_xml1804, "region": "north", "labelAlign": "top", "split": true }, { "flex": 5, "layout": "form", "xtype": "panel", "items": info_messages1805, "region": "center", "labelAlign": "top", "split": true }, { "flex": 5, "layout": "form", "xtype": "panel", "items": debug_messages1806, "region": "south", "labelAlign": "top", "split": true } ], "frame": true, "bodyBorder": false, "labelAlign": "top" });
    var main_panel1811 = new Ext.TabPanel({ "hideCheckBoxLabels": true, "border": false, "split": true, "autoScroll": false, "items": [ request_panel1803, technical_panel1807 ], "activeTab": 0, "bodyBorder": false, "frame": true, "labelAlign": "top" });
    this.items = main_panel1811;
    this.before_row_edit = function(record) {
      cbss_RetrieveTIGroupsResult_grid1802.on_master_changed();
    }
    Lino.cbss.RetrieveTIGroupsRequests.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.outbox.MailsByUser.InsertFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 27,
  initComponent : function() {
    var containing_panel = this;
    var project750 = new Lino.TwinCombo({ "fieldLabel": "Klient", "name": "project", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.pcsw.Clients.detail)}, "emptyText": "Klient ausw\u00e4hlen...", "listeners": { "render": Lino.quicktip_renderer("Klient","(outbox.Mails.project) ") }, "selectOnFocus": true, "hiddenName": "projectHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/outbox/Mails/project", "method": "GET" }) }) });
    var subject751 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Betreff","(outbox.Mails.subject) ") }, "fieldLabel": "Betreff", "name": "subject", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var body752 = new Lino.RichTextPanel({ "selectOnFocus": true, "flex": 71, "containing_panel": this, "name": "body", "title": "Inhalt" });
    var main_panel753 = new Ext.Panel({ "autoScroll": false, "border": false, "layout": "vbox", "labelWidth": 72, "hideCheckBoxLabels": true, "items": [ { "items": project750, "autoHeight": true, "layout": "form", "xtype": "panel", "labelAlign": "top" }, { "items": subject751, "autoHeight": true, "layout": "form", "xtype": "panel", "labelAlign": "top" }, body752 ], "frame": true, "layoutConfig": { "align": "stretch" }, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel753;
    this.before_row_edit = function(record) {
      body752.refresh();
    }
    Lino.outbox.MailsByUser.InsertFormPanel.superclass.initComponent.call(this);
  }
});


Lino.countries.Languages.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 12,
  initComponent : function() {
    var containing_panel = this;
    var id228 = new Ext.form.TextField({ "fieldLabel": "id", "name": "id", "boxMinWidth": Lino.chars2width(3), "listeners": { "render": Lino.quicktip_renderer("id","(countries.Languages.id) ") }, "maxLength": 3, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var iso2229 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("iso2","(countries.Languages.iso2) ") }, "fieldLabel": "iso2", "name": "iso2", "maxLength": 2, "selectOnFocus": true, "boxMinWidth": Lino.chars2width(2), "anchor": "-20" });
    var name230 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Bezeichnung","(countries.Languages.name) ") }, "fieldLabel": "Bezeichnung", "name": "name", "maxLength": 200, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var name_fr231 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Bezeichnung (fr)","(countries.Languages.name_fr) ") }, "fieldLabel": "Bezeichnung (fr)", "name": "name_fr", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var name_nl232 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Bezeichnung (nl)","(countries.Languages.name_nl) ") }, "fieldLabel": "Bezeichnung (nl)", "name": "name_nl", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var main_1_panel233 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 153, "hideCheckBoxLabels": true, "items": [ { "flex": 5, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id228, "labelAlign": "top" }, { "flex": 5, "autoHeight": true, "layout": "form", "xtype": "panel", "items": iso2229, "labelAlign": "top" }, { "flex": 29, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name230, "labelAlign": "top" }, { "flex": 29, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_fr231, "labelAlign": "top" }, { "flex": 29, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_nl232, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var main_panel246 = new Ext.Panel({ "autoScroll": false, "border": false, "layout": "vbox", "hideCheckBoxLabels": true, "items": [ main_1_panel233 ], "frame": true, "layoutConfig": { "align": "stretch" }, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel246;
    this.before_row_edit = function(record) {
    }
    Lino.countries.Languages.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.cbss.RetrieveTIGroupsRequests.InsertFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  autoHeight: true,
  content_type: 90,
  initComponent : function() {
    var containing_panel = this;
    var person1812 = new Lino.TwinCombo({ "fieldLabel": "Klient", "allowBlank": false, "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.pcsw.Clients.detail)}, "emptyText": "Klient ausw\u00e4hlen...", "listeners": { "render": Lino.quicktip_renderer("Klient","(cbss.RetrieveTIGroupsRequests.person) ") }, "selectOnFocus": true, "hiddenName": "personHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cbss/RetrieveTIGroupsRequests/person", "method": "GET" }) }), "name": "person" });
    var national_id1813 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("NR-Nummer","(cbss.RetrieveTIGroupsRequests.national_id) ") }, "fieldLabel": "NR-Nummer", "name": "national_id", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var language1814 = new Lino.ChoicesFieldElement({ "forceSelection": true, "fieldLabel": "Sprache", "name": "language", "hiddenName": "languageHidden", "listeners": { "render": Lino.quicktip_renderer("Sprache","(cbss.RetrieveTIGroupsRequests.language) ") }, "selectOnFocus": true, "anchor": "-20", "store": [['','<br>']].concat(Lino.cbss.RequestLanguages) });
    var main_2_panel1815 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 55, "autoHeight": true, "layout": "form", "xtype": "panel", "items": national_id1813, "labelAlign": "top" }, { "flex": 44, "autoHeight": true, "layout": "form", "xtype": "panel", "items": language1814, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 90, "border": false, "anchor": "-20", "labelAlign": "top" });
    var history1818 = new Ext.form.Checkbox({ "boxLabel": "Historie", "listeners": { "render": Lino.quicktip_renderer("Historie","(cbss.RetrieveTIGroupsRequests.history) Whatever this means.") }, "hideLabel": true, "checked": true, "name": "history", "selectOnFocus": true, "anchor": "-20" });
    var main_panel1819 = new Ext.Panel({ "hideCheckBoxLabels": true, "autoHeight": true, "border": false, "layout": "form", "labelWidth": 81, "autoScroll": false, "items": [ { "autoHeight": true, "layout": "form", "xtype": "panel", "items": person1812, "anchor": "-20", "labelAlign": "top" }, main_2_panel1815, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": history1818, "anchor": "-20", "labelAlign": "top" } ], "frame": true, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel1819;
    this.before_row_edit = function(record) {
    }
    Lino.cbss.RetrieveTIGroupsRequests.InsertFormPanel.superclass.initComponent.call(this);
  }
});


Lino.about.Models.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  disable_editing: true,
  initComponent : function() {
    var containing_panel = this;
    var app_disp1856 = new Ext.form.DisplayField({ "disabled": true, "listeners": { "render": Lino.quicktip_renderer("app_label","(about.Models.app) ") }, "fieldLabel": "app_label", "name": "app", "anchor": "-20", "value": "<br/>", "always_enabled": true });
    var name_disp1857 = new Ext.form.DisplayField({ "disabled": true, "listeners": { "render": Lino.quicktip_renderer("name","(about.Models.name) ") }, "fieldLabel": "name", "name": "name", "anchor": "-20", "value": "<br/>", "always_enabled": true });
    var docstring_disp1858 = new Ext.form.DisplayField({ "disabled": true, "listeners": { "render": Lino.quicktip_renderer("docstring","(about.Models.docstring) ") }, "fieldLabel": "docstring", "name": "docstring", "anchor": "-20", "value": "<br/>", "always_enabled": true });
    var rows1859 = new Ext.form.NumberField({ "disabled": true, "listeners": { "render": Lino.quicktip_renderer("Rows","(about.Models.rows) ") }, "fieldLabel": "Rows", "anchor": "-20", "name": "rows" });
    var main_1_panel1860 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 90, "hideCheckBoxLabels": true, "items": [ { "flex": 31, "autoHeight": true, "layout": "form", "xtype": "panel", "items": app_disp1856, "labelAlign": "top" }, { "flex": 31, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_disp1857, "labelAlign": "top" }, { "flex": 31, "autoHeight": true, "layout": "form", "xtype": "panel", "items": docstring_disp1858, "labelAlign": "top" }, { "flex": 5, "autoHeight": true, "layout": "form", "xtype": "panel", "items": rows1859, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var about_FieldsByModel_grid1869 = new Lino.about.FieldsByModel.GridPanel({ "flex": 62, "listeners": { "render": Lino.quicktip_renderer("Fields","(about.about.FieldsByModel) ") }, "hide_top_toolbar": true, "containing_panel": this, "tools": [ Lino.show_in_own_window_button(Lino.about.FieldsByModel.grid) ], "master_panel": this });
    var main_panel1870 = new Ext.Panel({ "autoScroll": false, "border": false, "layout": "vbox", "hideCheckBoxLabels": true, "items": [ main_1_panel1860, about_FieldsByModel_grid1869 ], "frame": true, "layoutConfig": { "align": "stretch" }, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel1870;
    this.before_row_edit = function(record) {
      about_FieldsByModel_grid1869.on_master_changed();
    }
    Lino.about.Models.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.uploads.MyUploads.InsertFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  autoHeight: true,
  content_type: 26,
  initComponent : function() {
    var containing_panel = this;
    var file1843 = Lino.file_field_handler(this,{ "listeners": { "render": Lino.quicktip_renderer("Datei","(uploads.Uploads.file) ") }, "fieldLabel": "Datei", "name": "file", "maxLength": 100, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var user1844 = new Lino.TwinCombo({ "fieldLabel": "Autor", "name": "user", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.users.Users.detail)}, "emptyText": "Benutzer ausw\u00e4hlen...", "listeners": { "render": Lino.quicktip_renderer("Autor","(uploads.Uploads.user) ") }, "selectOnFocus": true, "hiddenName": "userHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/uploads/Uploads/user", "method": "GET" }) }) });
    var main_1_panel1845 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 58, "autoHeight": true, "layout": "form", "xtype": "panel", "items": file1843, "labelAlign": "top" }, { "flex": 41, "autoHeight": true, "layout": "form", "xtype": "panel", "items": user1844, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 54, "border": false, "anchor": "-20", "labelAlign": "top" });
    var type1848 = new Lino.RemoteComboFieldElement({ "fieldLabel": "Upload-Art", "name": "type", "pageSize": 20, "emptyText": "Upload-Art ausw\u00e4hlen...", "listeners": { "render": Lino.quicktip_renderer("Upload-Art","(uploads.Uploads.type) ") }, "selectOnFocus": true, "hiddenName": "typeHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/uploads/Uploads/type", "method": "GET" }) }) });
    var valid_until1849 = new Lino.DateField({ "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("g\u00fcltig bis","(uploads.Uploads.valid_until) ") }, "fieldLabel": "g\u00fcltig bis", "anchor": "-20", "name": "valid_until" });
    var main_2_panel1850 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 71, "autoHeight": true, "layout": "form", "xtype": "panel", "items": type1848, "labelAlign": "top" }, { "flex": 28, "autoHeight": true, "layout": "form", "xtype": "panel", "items": valid_until1849, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 99, "border": false, "anchor": "-20", "labelAlign": "top" });
    var description1853 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Beschreibung","(uploads.Uploads.description) ") }, "fieldLabel": "Beschreibung", "name": "description", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var main_panel1854 = new Ext.Panel({ "hideCheckBoxLabels": true, "autoHeight": true, "border": false, "layout": "form", "labelWidth": 117, "autoScroll": false, "items": [ main_1_panel1845, main_2_panel1850, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": description1853, "anchor": "-20", "labelAlign": "top" } ], "frame": true, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel1854;
    this.before_row_edit = function(record) {
    }
    Lino.uploads.MyUploads.InsertFormPanel.superclass.initComponent.call(this);
  }
});


Lino.reception.ExpectedGuests.InsertFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  autoHeight: true,
  content_type: 37,
  initComponent : function() {
    var containing_panel = this;
    var event927 = new Lino.TwinCombo({ "fieldLabel": "Termin", "allowBlank": false, "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.cal.Events.detail)}, "emptyText": "Termin ausw\u00e4hlen...", "listeners": { "render": Lino.quicktip_renderer("Termin","(cal.Guests.event) ") }, "selectOnFocus": true, "hiddenName": "eventHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/Guests/event", "method": "GET" }) }), "name": "event" });
    var partner928 = new Lino.TwinCombo({ "fieldLabel": "Partner", "allowBlank": false, "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.contacts.Partners.detail)}, "emptyText": "Partner ausw\u00e4hlen...", "listeners": { "render": Lino.quicktip_renderer("Partner","(cal.Guests.partner) ") }, "selectOnFocus": true, "hiddenName": "partnerHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/Guests/partner", "method": "GET" }) }), "name": "partner" });
    var role929 = new Lino.TwinCombo({ "fieldLabel": "Rolle", "name": "role", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.cal.GuestRoles.detail)}, "emptyText": "Gastrolle ausw\u00e4hlen...", "listeners": { "render": Lino.quicktip_renderer("Rolle","(cal.Guests.role) ") }, "selectOnFocus": true, "hiddenName": "roleHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/Guests/role", "method": "GET" }) }) });
    var main_panel930 = new Ext.Panel({ "hideCheckBoxLabels": true, "autoHeight": true, "border": false, "layout": "form", "labelWidth": 72, "autoScroll": false, "items": [ { "autoHeight": true, "layout": "form", "xtype": "panel", "items": event927, "anchor": "-20", "labelAlign": "top" }, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": partner928, "anchor": "-20", "labelAlign": "top" }, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": role929, "anchor": "-20", "labelAlign": "top" } ], "frame": true, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel930;
    this.before_row_edit = function(record) {
    }
    Lino.reception.ExpectedGuests.InsertFormPanel.superclass.initComponent.call(this);
  }
});


Lino.pcsw.NotesByPerson.InsertFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  autoHeight: true,
  content_type: 94,
  initComponent : function() {
    var containing_panel = this;
    var event_type777 = new Lino.TwinCombo({ "fieldLabel": "Ereignisart (Form)", "name": "event_type", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.notes.EventTypes.detail)}, "emptyText": "Event Type ausw\u00e4hlen...", "listeners": { "render": Lino.quicktip_renderer("Ereignisart (Form)","(notes.Notes.event_type) ") }, "selectOnFocus": true, "hiddenName": "event_typeHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/notes/Notes/event_type", "method": "GET" }) }) });
    var type778 = new Lino.TwinCombo({ "fieldLabel": "Notizart (Inhalt)", "name": "type", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.notes.NoteTypes.detail)}, "emptyText": "Notizart ausw\u00e4hlen...", "listeners": { "render": Lino.quicktip_renderer("Notizart (Inhalt)","(notes.Notes.type) ") }, "selectOnFocus": true, "hiddenName": "typeHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/notes/Notes/type", "method": "GET" }) }) });
    var main_1_panel779 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": event_type777, "labelAlign": "top" }, { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": type778, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 171, "border": false, "anchor": "-20", "labelAlign": "top" });
    var subject782 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Betreff","(notes.Notes.subject) ") }, "fieldLabel": "Betreff", "name": "subject", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var project783 = new Lino.TwinCombo({ "fieldLabel": "Klient", "name": "project", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.pcsw.Clients.detail)}, "emptyText": "Klient ausw\u00e4hlen...", "listeners": { "render": Lino.quicktip_renderer("Klient","(notes.Notes.project) ") }, "selectOnFocus": true, "hiddenName": "projectHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/notes/Notes/project", "method": "GET" }) }) });
    var company784 = new Lino.TwinCombo({ "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Organisation</span>", "name": "company", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.contacts.Companies.detail)}, "emptyText": "Organisation ausw\u00e4hlen...", "listeners": { "render": Lino.quicktip_renderer("Organisation","(notes.Notes.company)     An optional third-party Organization that is related to this Note.\n    The note will then be visible in that company's history panel.\n    ") }, "selectOnFocus": true, "hiddenName": "companyHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/notes/Notes/company", "method": "GET" }) }) });
    var main_3_panel785 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": project783, "labelAlign": "top" }, { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": company784, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 117, "border": false, "anchor": "-20", "labelAlign": "top" });
    var main_panel788 = new Ext.Panel({ "hideCheckBoxLabels": true, "autoHeight": true, "border": false, "layout": "form", "labelWidth": 72, "autoScroll": false, "items": [ main_1_panel779, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": subject782, "anchor": "-20", "labelAlign": "top" }, main_3_panel785 ], "frame": true, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel788;
    this.before_row_edit = function(record) {
    }
    Lino.pcsw.NotesByPerson.InsertFormPanel.superclass.initComponent.call(this);
  }
});


Lino.about.About.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  disable_editing: true,
  initComponent : function() {
    var containing_panel = this;
    var main_panel1874 = new Ext.Panel({ "autoScroll": false, "border": false, "layout": "fit", "hideCheckBoxLabels": true, "items": [ { "html": "<div class=\"htmlText\"><span>This is <a href=\"http://welfare.lino-framework.org\" target=\"_blank\">Lino Welfare</a> 1.1.8 using <a href=\"http://site.lino-framework.org\" target=\"_blank\">djangosite</a> 0.1.5, <a href=\"http://www.python.org/\" target=\"_blank\">Python</a> 2.7.3, <a href=\"http://www.djangoproject.com\" target=\"_blank\">Django</a> 1.5.1, <a href=\"http://babel.edgewall.org/\" target=\"_blank\">Babel</a> 1.0dev-r661, <a href=\"http://www.lino-framework.org\" target=\"_blank\">Lino</a> 1.6.11, <a href=\"http://jinja.pocoo.org/\" target=\"_blank\">Jinja</a> 2.6, <a href=\"http://sphinx-doc.org/\" target=\"_blank\">Sphinx</a> 1.2b1, <a href=\"http://labix.org/python-dateutil\" target=\"_blank\">python-dateutil</a> 2.1, <a href=\"http://pypi.python.org/pypi/odfpy\" target=\"_blank\">OdfPy</a> ODFPY/0.9.6, <a href=\"http://docutils.sourceforge.net/\" target=\"_blank\">docutils</a> 0.8.1, <a href=\"https://fedorahosted.org/suds/\" target=\"_blank\">suds</a> 0.4, <a href=\"http://pyyaml.org/\" target=\"_blank\">PyYaml</a> 3.10, <a href=\"http://appyframework.org/pod.html\" target=\"_blank\">Appy</a> 0.8.3 (2013/02/22 15:29)</span><p>Server l&#228;uft seit : <b>Samstag, 20. Juli 2013 um 22:44:12.254115</b></p><p>Source timestamps:</p><ul><li>lino : <b>Samstag, 20. Juli 2013 um 22:43:58.955882</b></li><li>lino_welfare : <b>Samstag, 20. Juli 2013 um 03:58:11.650407</b></li><li>north : <b>Samstag, 20. Juli 2013 um 03:55:07.862412</b></li><li>atelier : <b>Donnerstag, 18. Juli 2013 um 05:07:07.070376</b></li><li>django : <b>Dienstag, 9. Juli 2013 um 10:54:45</b></li><li>djangosite : <b>Dienstag, 9. Juli 2013 um 10:31:38.549456</b></li></ul></div>", "xtype": "label" } ], "frame": true, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel1874;
    this.before_row_edit = function(record) {
    }
    Lino.about.About.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.lino.Report.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  disable_editing: true,
  initComponent : function() {
    var containing_panel = this;
    var body_htmlbox1871 = new Lino.HtmlBoxPanel({ "layout": "fit", "name": "body", "containing_panel": this, "master_panel": this, "items": new Ext.BoxComponent({autoScroll:true}), "bodyStyle": "overflow-x:hidden", "value": "<br/>", "always_enabled": true, "listeners": { "render": Lino.quicktip_renderer(null,"(lino.Report.body) ") } });
    var main_panel1872 = new Ext.Panel({ "autoScroll": false, "border": false, "layout": "fit", "labelWidth": 0, "hideCheckBoxLabels": true, "items": [ body_htmlbox1871 ], "frame": true, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel1872;
    this.before_row_edit = function(record) {
      body_htmlbox1871.refresh();
    }
    Lino.lino.Report.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.outbox.MailsByUser.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 27,
  initComponent : function() {
    var containing_panel = this;
    var subject722 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Betreff","(outbox.Mails.subject) ") }, "fieldLabel": "Betreff", "name": "subject", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var project723 = new Lino.TwinCombo({ "fieldLabel": "Klient", "name": "project", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.pcsw.Clients.detail)}, "emptyText": "Klient ausw\u00e4hlen...", "listeners": { "render": Lino.quicktip_renderer("Klient","(outbox.Mails.project) ") }, "selectOnFocus": true, "hiddenName": "projectHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/outbox/Mails/project", "method": "GET" }) }) });
    var date724 = new Lino.DateField({ "listeners": { "render": Lino.quicktip_renderer("Datum","(outbox.Mails.date) \n        The official date to be printed on the document.\n        ") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Datum</span>", "name": "date", "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var main_1_panel725 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 72, "hideCheckBoxLabels": true, "items": [ { "flex": 42, "autoHeight": true, "layout": "form", "xtype": "panel", "items": subject722, "labelAlign": "top" }, { "flex": 40, "autoHeight": true, "layout": "form", "xtype": "panel", "items": project723, "labelAlign": "top" }, { "flex": 16, "autoHeight": true, "layout": "form", "xtype": "panel", "items": date724, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var user729 = new Lino.TwinCombo({ "fieldLabel": "Absender", "name": "user", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.users.Users.detail)}, "emptyText": "Benutzer ausw\u00e4hlen...", "listeners": { "render": Lino.quicktip_renderer("Absender","(outbox.Mails.user) ") }, "selectOnFocus": true, "hiddenName": "userHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/outbox/Mails/user", "method": "GET" }) }) });
    var sent730 = new Ext.form.DisplayField({ "disabled": true, "listeners": { "render": Lino.quicktip_renderer("sent","(outbox.Mails.sent) ") }, "fieldLabel": "sent", "name": "sent", "anchor": "-20", "value": "<br>" });
    var id731 = new Ext.form.NumberField({ "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("ID","(outbox.Mails.id) ") }, "fieldLabel": "ID", "anchor": "-20", "name": "id" });
    var owner_disp732 = new Ext.form.DisplayField({ "disabled": true, "fieldLabel": "Verkn\u00fcpft mit", "anchor": "-20", "name": "owner" });
    var main_2_panel733 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 126, "hideCheckBoxLabels": true, "items": [ { "flex": 32, "autoHeight": true, "layout": "form", "xtype": "panel", "items": user729, "labelAlign": "top" }, { "flex": 34, "autoHeight": true, "layout": "form", "xtype": "panel", "items": sent730, "labelAlign": "top" }, { "flex": 10, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id731, "labelAlign": "top" }, { "flex": 21, "autoHeight": true, "layout": "form", "xtype": "panel", "items": owner_disp732, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var RecipientsByMail_grid744 = new Lino.outbox.RecipientsByMail.GridPanel({ "flex": 55, "listeners": { "render": Lino.quicktip_renderer("Empf\u00e4nger","(outbox.outbox.RecipientsByMail) ") }, "hide_top_toolbar": true, "containing_panel": this, "tools": [ Lino.show_in_own_window_button(Lino.outbox.RecipientsByMail.grid) ], "master_panel": this });
    var AttachmentsByMail_htmlbox745 = new Lino.HtmlBoxPanel({ "flex": 22, "layout": "fit", "name": "AttachmentsByMail", "containing_panel": this, "items": new Ext.BoxComponent({autoScroll:true}), "title": "Anh\u00e4nge", "master_panel": this, "value": "<br/>", "always_enabled": true, "listeners": { "render": Lino.quicktip_renderer("Anh\u00e4nge","(outbox.Mails.AttachmentsByMail) ") }, "bodyStyle": "overflow-x:hidden", "tools": [ Lino.show_in_own_window_button(Lino.outbox.AttachmentsByMail.grid) ] });
    var UploadsByController_htmlbox746 = new Lino.HtmlBoxPanel({ "flex": 22, "ls_bbar_actions": [ { "itemId": "insert", "menu_item_text": "Neu", "must_save": true, "tooltip": "Neuen Datensatz erstellen", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-new", "overflowText": "Neu", "auto_save": true } ], "name": "UploadsByController", "containing_panel": this, "items": new Ext.BoxComponent({autoScroll:true}), "title": "Uploads", "master_panel": this, "value": "<br/>", "always_enabled": true, "listeners": { "render": Lino.quicktip_renderer("Uploads","(outbox.Mails.UploadsByController) ") }, "bodyStyle": "overflow-x:hidden", "ls_insert_handler": Lino.uploads.UploadsByController.insert, "layout": "fit", "tools": [ Lino.show_in_own_window_button(Lino.uploads.UploadsByController.grid) ] });
    var main_3_panel747 = new Ext.Panel({ "flex": 29, "border": false, "layout": "hbox", "labelWidth": 72, "hideCheckBoxLabels": true, "items": [ RecipientsByMail_grid744, AttachmentsByMail_htmlbox745, UploadsByController_htmlbox746 ], "autoScroll": false, "layoutConfig": { "align": "stretch" }, "frame": false, "labelAlign": "top" });
    var body748 = new Lino.RichTextPanel({ "selectOnFocus": true, "flex": 58, "containing_panel": this, "name": "body", "title": "Inhalt" });
    var main_panel749 = new Ext.Panel({ "autoScroll": false, "border": false, "layout": "vbox", "labelWidth": 0, "hideCheckBoxLabels": true, "items": [ main_1_panel725, main_2_panel733, main_3_panel747, body748 ], "frame": true, "layoutConfig": { "align": "stretch" }, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel749;
    this.before_row_edit = function(record) {
      RecipientsByMail_grid744.on_master_changed();
      AttachmentsByMail_htmlbox745.refresh();
      UploadsByController_htmlbox746.refresh();
      body748.refresh();
    }
    Lino.outbox.MailsByUser.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.contacts.Partners.InsertFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  autoHeight: true,
  content_type: 23,
  initComponent : function() {
    var containing_panel = this;
    var name553 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Name","(contacts.Partners.name) ") }, "fieldLabel": "Name", "name": "name", "maxLength": 200, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var language554 = new Lino.ChoicesFieldElement({ "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Sprache</span>", "allowBlank": false, "value": "de", "hiddenName": "languageHidden", "listeners": { "render": Lino.quicktip_renderer("Sprache","(contacts.Partners.language) Die Sprache, in der Dokumente ausgestellt werden sollen.") }, "selectOnFocus": true, "anchor": "-20", "store": [ [ "de", "Deutsch" ], [ "fr", "Franz\u00f6sisch" ], [ "nl", "Niederl\u00e4ndisch" ] ], "name": "language" });
    var email555 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("E-Mail","(contacts.Partners.email) ") }, "fieldLabel": "E-Mail", "name": "email", "maxLength": 75, "selectOnFocus": true, "anchor": "-20" });
    var main_2_panel556 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 48, "autoHeight": true, "layout": "form", "xtype": "panel", "items": language554, "labelAlign": "top" }, { "flex": 51, "autoHeight": true, "layout": "form", "xtype": "panel", "items": email555, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 72, "border": false, "anchor": "-20", "labelAlign": "top" });
    var main_panel559 = new Ext.Panel({ "hideCheckBoxLabels": true, "autoHeight": true, "border": false, "layout": "form", "labelWidth": 45, "autoScroll": false, "items": [ { "autoHeight": true, "layout": "form", "xtype": "panel", "items": name553, "anchor": "-20", "labelAlign": "top" }, main_2_panel556 ], "frame": true, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel559;
    this.before_row_edit = function(record) {
    }
    Lino.contacts.Partners.InsertFormPanel.superclass.initComponent.call(this);
  }
});


Lino.households.Households.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 41,
  initComponent : function() {
    var containing_panel = this;
    var type934 = new Lino.TwinCombo({ "fieldLabel": "Haushaltsart", "name": "type", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.households.Types.detail)}, "emptyText": "Haushaltsart ausw\u00e4hlen...", "listeners": { "render": Lino.quicktip_renderer("Haushaltsart","(households.Households.type) ") }, "selectOnFocus": true, "hiddenName": "typeHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/households/Households/type", "method": "GET" }) }) });
    var name935 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Name","(households.Households.name) ") }, "fieldLabel": "Name", "name": "name", "maxLength": 200, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var language936 = new Lino.ChoicesFieldElement({ "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Sprache</span>", "allowBlank": false, "value": "de", "hiddenName": "languageHidden", "listeners": { "render": Lino.quicktip_renderer("Sprache","(households.Households.language) Die Sprache, in der Dokumente ausgestellt werden sollen.") }, "selectOnFocus": true, "anchor": "-20", "store": [ [ "de", "Deutsch" ], [ "fr", "Franz\u00f6sisch" ], [ "nl", "Niederl\u00e4ndisch" ] ], "name": "language" });
    var id937 = new Ext.form.NumberField({ "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("ID","(households.Households.id) ") }, "fieldLabel": "ID", "anchor": "-20", "name": "id" });
    var intro_box_1_panel938 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 117, "hideCheckBoxLabels": true, "items": [ { "flex": 35, "autoHeight": true, "layout": "form", "xtype": "panel", "items": type934, "labelAlign": "top" }, { "flex": 37, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name935, "labelAlign": "top" }, { "flex": 17, "autoHeight": true, "layout": "form", "xtype": "panel", "items": language936, "labelAlign": "top" }, { "flex": 8, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id937, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var country943 = new Lino.TwinCombo({ "fieldLabel": "Land", "name": "country", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.countries.Countries.detail)}, "emptyText": "Land ausw\u00e4hlen...", "listeners": { "render": Lino.quicktip_renderer("Land","(households.Households.country) ") }, "selectOnFocus": true, "hiddenName": "countryHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/households/Households/country", "method": "GET" }) }) });
    var region944 = new Lino.TwinCombo({ "fieldLabel": "Region", "name": "region", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.countries.Cities.detail)}, "emptyText": "Ort ausw\u00e4hlen...", "listeners": { "render": Lino.quicktip_renderer("Region","(households.Households.region) ") }, "selectOnFocus": true, "hiddenName": "regionHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/households/Households/region", "method": "GET" }) }) });
    var box3_1_panel945 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": country943, "labelAlign": "top" }, { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": region944, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 63, "border": false, "anchor": "-20", "labelAlign": "top" });
    var city948 = new Lino.TwinCombo({ "forceSelection": false, "fieldLabel": "Ort", "name": "city", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.countries.Cities.detail)}, "emptyText": "Ort ausw\u00e4hlen...", "listeners": { "render": Lino.quicktip_renderer("Ort","(households.Households.city) ") }, "selectOnFocus": true, "hiddenName": "cityHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/households/Households/city", "method": "GET" }) }) });
    var zip_code949 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Postleitzahl","(households.Households.zip_code) ") }, "fieldLabel": "Postleitzahl", "name": "zip_code", "maxLength": 10, "selectOnFocus": true, "boxMinWidth": Lino.chars2width(10), "anchor": "-20" });
    var box3_2_panel950 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 66, "autoHeight": true, "layout": "form", "xtype": "panel", "items": city948, "labelAlign": "top" }, { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": zip_code949, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 117, "border": false, "anchor": "-20", "labelAlign": "top" });
    var street_prefix953 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Pr\u00e4fix Stra\u00dfe","(households.Households.street_prefix) Text to print before name of street, but to ignore for sorting.") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Pr\u00e4fix Stra\u00dfe</span>", "name": "street_prefix", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var street954 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Stra\u00dfe","(households.Households.street) Name of street. Without house number.") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Stra\u00dfe</span>", "name": "street", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var street_no955 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Nr.","(households.Households.street_no) House number") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Nr.</span>", "name": "street_no", "maxLength": 10, "selectOnFocus": true, "boxMinWidth": Lino.chars2width(10), "anchor": "-20" });
    var street_box956 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Box","(households.Households.street_box) Text to print after :attr:`steet_no` on the same line") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Box</span>", "name": "street_box", "maxLength": 10, "selectOnFocus": true, "boxMinWidth": Lino.chars2width(10), "anchor": "-20" });
    var box3_3_panel957 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 30, "autoHeight": true, "layout": "form", "xtype": "panel", "items": street_prefix953, "labelAlign": "top" }, { "flex": 36, "autoHeight": true, "layout": "form", "xtype": "panel", "items": street954, "labelAlign": "top" }, { "flex": 16, "autoHeight": true, "layout": "form", "xtype": "panel", "items": street_no955, "labelAlign": "top" }, { "flex": 16, "autoHeight": true, "layout": "form", "xtype": "panel", "items": street_box956, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 126, "border": false, "anchor": "-20", "labelAlign": "top" });
    var addr2962 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Adresszeile nach Stra\u00dfe","(households.Households.addr2) Address line to print below street line") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Adresszeile nach Stra\u00dfe</span>", "name": "addr2", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var activity963 = new Lino.RemoteComboFieldElement({ "fieldLabel": "Beruf", "name": "activity", "pageSize": 20, "emptyText": "Beruf ausw\u00e4hlen...", "listeners": { "render": Lino.quicktip_renderer("Beruf","(households.Households.activity) ") }, "selectOnFocus": true, "hiddenName": "activityHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/households/Households/activity", "method": "GET" }) }) });
    var bank_account1964 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Bankkonto 1","(households.Households.bank_account1) ") }, "fieldLabel": "Bankkonto 1", "name": "bank_account1", "maxLength": 40, "selectOnFocus": true, "anchor": "-20" });
    var bank_account2965 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Bankkonto 2","(households.Households.bank_account2) ") }, "fieldLabel": "Bankkonto 2", "name": "bank_account2", "maxLength": 40, "selectOnFocus": true, "anchor": "-20" });
    var box3_5_panel966 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 45, "autoHeight": true, "layout": "form", "xtype": "panel", "items": activity963, "labelAlign": "top" }, { "flex": 27, "autoHeight": true, "layout": "form", "xtype": "panel", "items": bank_account1964, "labelAlign": "top" }, { "flex": 27, "autoHeight": true, "layout": "form", "xtype": "panel", "items": bank_account2965, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 108, "border": false, "anchor": "-20", "labelAlign": "top" });
    var box3_panel970 = new Ext.Panel({ "flex": 62, "autoHeight": true, "layout": "form", "items": [ box3_1_panel945, box3_2_panel950, box3_3_panel957, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": addr2962, "anchor": "-20", "labelAlign": "top" }, box3_5_panel966 ], "frame": true, "bodyBorder": false, "autoScroll": false, "hideCheckBoxLabels": true, "labelWidth": 216, "border": false, "labelAlign": "top" });
    var email972 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("E-Mail","(households.Households.email) ") }, "fieldLabel": "E-Mail", "name": "email", "maxLength": 75, "selectOnFocus": true, "anchor": "-20" });
    var url973 = new Lino.URLField({ "listeners": { "render": Lino.quicktip_renderer("URL","(households.Households.url) ") }, "fieldLabel": "URL", "name": "url", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var phone974 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Telefon","(households.Households.phone) ") }, "fieldLabel": "Telefon", "name": "phone", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var gsm975 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("GSM","(households.Households.gsm) ") }, "fieldLabel": "GSM", "name": "gsm", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var box4_panel976 = new Ext.Panel({ "flex": 37, "autoHeight": true, "layout": "form", "items": [ { "autoHeight": true, "layout": "form", "xtype": "panel", "items": email972, "anchor": "-20", "labelAlign": "top" }, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": url973, "anchor": "-20", "labelAlign": "top" }, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": phone974, "anchor": "-20", "labelAlign": "top" }, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": gsm975, "anchor": "-20", "labelAlign": "top" } ], "frame": true, "bodyBorder": false, "autoScroll": false, "hideCheckBoxLabels": true, "labelWidth": 72, "border": false, "labelAlign": "top" });
    var address_box_panel981 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "hideCheckBoxLabels": true, "items": [ box3_panel970, box4_panel976 ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var remarks982 = new Ext.form.TextArea({ "listeners": { "render": Lino.quicktip_renderer("Bemerkungen","(households.Households.remarks) ") }, "fieldLabel": "Bemerkungen", "name": "remarks", "growMax": 2000, "selectOnFocus": true, "anchor": "-20 -10" });
    var households_MembersByHousehold_grid989 = new Lino.households.MembersByHousehold.GridPanel({ "flex": 50, "listeners": { "render": Lino.quicktip_renderer("Mitglieder","(households.households.MembersByHousehold) ") }, "hide_top_toolbar": true, "containing_panel": this, "tools": [ Lino.show_in_own_window_button(Lino.households.MembersByHousehold.grid) ], "master_panel": this });
    var bottom_box_panel990 = new Ext.Panel({ "flex": 45, "border": false, "layout": "hbox", "labelWidth": 108, "hideCheckBoxLabels": true, "items": [ { "items": remarks982, "labelAlign": "top", "layout": "form", "xtype": "panel", "flex": 49 }, households_MembersByHousehold_grid989 ], "autoScroll": false, "layoutConfig": { "align": "stretch" }, "frame": false, "labelAlign": "top" });
    var general_panel992 = new Ext.Panel({ "layout": "vbox", "title": "Allgemein", "items": [ intro_box_1_panel938, address_box_panel981, bottom_box_panel990 ], "frame": true, "layoutConfig": { "align": "stretch" }, "hideCheckBoxLabels": true, "listeners": { "activate": Lino.on_tab_activate }, "autoScroll": false, "border": false, "bodyBorder": false, "labelAlign": "top" });
    var main_panel996 = new Ext.TabPanel({ "hideCheckBoxLabels": true, "border": false, "split": true, "autoScroll": false, "items": [ general_panel992 ], "activeTab": 0, "bodyBorder": false, "frame": true, "labelAlign": "top" });
    this.items = main_panel996;
    this.before_row_edit = function(record) {
      region944.setContextValue('country',record ? record.data['countryHidden'] : undefined);
      city948.setContextValue('country',record ? record.data['countryHidden'] : undefined);
      city948.setContextValue('region',record ? record.data['regionHidden'] : undefined);
      households_MembersByHousehold_grid989.on_master_changed();
    }
    this.onRender = function(ct, position) {
      country943.on('change',Lino.chooser_handler(region944,'country'));
      country943.on('change',Lino.chooser_handler(city948,'country'));
      region944.on('change',Lino.chooser_handler(city948,'region'));
      Lino.households.Households.DetailFormPanel.superclass.onRender.call(this, ct, position);
    }
    Lino.households.Households.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.contacts.Persons.InsertFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  autoHeight: true,
  content_type: 21,
  initComponent : function() {
    var containing_panel = this;
    var title892 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Anrede","(contacts.Persons.title) ") }, "fieldLabel": "Anrede", "name": "title", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var first_name893 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Vorname","(contacts.Persons.first_name) ") }, "fieldLabel": "Vorname", "name": "first_name", "maxLength": 200, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var last_name894 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Familienname","(contacts.Persons.last_name) ") }, "fieldLabel": "Familienname", "name": "last_name", "maxLength": 200, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var main_1_panel895 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": title892, "labelAlign": "top" }, { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": first_name893, "labelAlign": "top" }, { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": last_name894, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 117, "border": false, "anchor": "-20", "labelAlign": "top" });
    var gender899 = new Lino.ChoicesFieldElement({ "forceSelection": true, "fieldLabel": "Geschlecht", "name": "gender", "hiddenName": "genderHidden", "listeners": { "render": Lino.quicktip_renderer("Geschlecht","(contacts.Persons.gender) ") }, "selectOnFocus": true, "anchor": "-20", "store": [['','<br>']].concat(Lino.lino.Genders) });
    var language900 = new Lino.ChoicesFieldElement({ "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Sprache</span>", "allowBlank": false, "value": "de", "hiddenName": "languageHidden", "listeners": { "render": Lino.quicktip_renderer("Sprache","(contacts.Persons.language) Die Sprache, in der Dokumente ausgestellt werden sollen.") }, "selectOnFocus": true, "anchor": "-20", "store": [ [ "de", "Deutsch" ], [ "fr", "Franz\u00f6sisch" ], [ "nl", "Niederl\u00e4ndisch" ] ], "name": "language" });
    var main_2_panel901 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 35, "autoHeight": true, "layout": "form", "xtype": "panel", "items": gender899, "labelAlign": "top" }, { "flex": 64, "autoHeight": true, "layout": "form", "xtype": "panel", "items": language900, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 99, "border": false, "anchor": "-20", "labelAlign": "top" });
    var main_panel904 = new Ext.Panel({ "hideCheckBoxLabels": true, "autoHeight": true, "border": false, "layout": "form", "autoScroll": false, "items": [ main_1_panel895, main_2_panel901 ], "frame": true, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel904;
    this.before_row_edit = function(record) {
    }
    Lino.contacts.Persons.InsertFormPanel.superclass.initComponent.call(this);
  }
});


Lino.pcsw.NotesByPerson.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 94,
  initComponent : function() {
    var containing_panel = this;
    var date685 = new Lino.DateField({ "listeners": { "render": Lino.quicktip_renderer("Datum","(notes.Notes.date) ") }, "fieldLabel": "Datum", "name": "date", "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var event_type686 = new Lino.TwinCombo({ "fieldLabel": "Ereignisart (Form)", "name": "event_type", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.notes.EventTypes.detail)}, "emptyText": "Event Type ausw\u00e4hlen...", "listeners": { "render": Lino.quicktip_renderer("Ereignisart (Form)","(notes.Notes.event_type) ") }, "selectOnFocus": true, "hiddenName": "event_typeHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/notes/Notes/event_type", "method": "GET" }) }) });
    var type687 = new Lino.TwinCombo({ "fieldLabel": "Notizart (Inhalt)", "name": "type", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.notes.NoteTypes.detail)}, "emptyText": "Notizart ausw\u00e4hlen...", "listeners": { "render": Lino.quicktip_renderer("Notizart (Inhalt)","(notes.Notes.type) ") }, "selectOnFocus": true, "hiddenName": "typeHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/notes/Notes/type", "method": "GET" }) }) });
    var left_1_panel688 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 171, "hideCheckBoxLabels": true, "items": [ { "flex": 16, "autoHeight": true, "layout": "form", "xtype": "panel", "items": date685, "labelAlign": "top" }, { "flex": 41, "autoHeight": true, "layout": "form", "xtype": "panel", "items": event_type686, "labelAlign": "top" }, { "flex": 41, "autoHeight": true, "layout": "form", "xtype": "panel", "items": type687, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var subject692 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Betreff","(notes.Notes.subject) ") }, "fieldLabel": "Betreff", "name": "subject", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var project693 = new Lino.TwinCombo({ "fieldLabel": "Klient", "name": "project", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.pcsw.Clients.detail)}, "emptyText": "Klient ausw\u00e4hlen...", "listeners": { "render": Lino.quicktip_renderer("Klient","(notes.Notes.project) ") }, "selectOnFocus": true, "hiddenName": "projectHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/notes/Notes/project", "method": "GET" }) }) });
    var company694 = new Lino.TwinCombo({ "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Organisation</span>", "name": "company", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.contacts.Companies.detail)}, "emptyText": "Organisation ausw\u00e4hlen...", "listeners": { "render": Lino.quicktip_renderer("Organisation","(notes.Notes.company)     An optional third-party Organization that is related to this Note.\n    The note will then be visible in that company's history panel.\n    ") }, "selectOnFocus": true, "hiddenName": "companyHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/notes/Notes/company", "method": "GET" }) }) });
    var left_3_panel695 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 117, "hideCheckBoxLabels": true, "items": [ { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": project693, "labelAlign": "top" }, { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": company694, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var id698 = new Ext.form.NumberField({ "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("ID","(notes.Notes.id) ") }, "fieldLabel": "ID", "anchor": "-20", "name": "id" });
    var user699 = new Lino.TwinCombo({ "fieldLabel": "Autor", "name": "user", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.users.Users.detail)}, "emptyText": "Benutzer ausw\u00e4hlen...", "listeners": { "render": Lino.quicktip_renderer("Autor","(notes.Notes.user) ") }, "selectOnFocus": true, "hiddenName": "userHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/notes/Notes/user", "method": "GET" }) }) });
    var language700 = new Lino.ChoicesFieldElement({ "fieldLabel": "Sprache", "allowBlank": false, "value": "de", "hiddenName": "languageHidden", "listeners": { "render": Lino.quicktip_renderer("Sprache","(notes.Notes.language) ") }, "selectOnFocus": true, "anchor": "-20", "store": [ [ "de", "Deutsch" ], [ "fr", "Franz\u00f6sisch" ], [ "nl", "Niederl\u00e4ndisch" ] ], "name": "language" });
    var build_time701 = new Ext.form.DisplayField({ "disabled": true, "listeners": { "render": Lino.quicktip_renderer("Druckdatum","(notes.Notes.build_time) ") }, "fieldLabel": "Druckdatum", "name": "build_time", "anchor": "-20", "value": "<br>" });
    var left_4_panel702 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 99, "hideCheckBoxLabels": true, "items": [ { "flex": 12, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id698, "labelAlign": "top" }, { "flex": 25, "autoHeight": true, "layout": "form", "xtype": "panel", "items": user699, "labelAlign": "top" }, { "flex": 20, "autoHeight": true, "layout": "form", "xtype": "panel", "items": language700, "labelAlign": "top" }, { "flex": 41, "autoHeight": true, "layout": "form", "xtype": "panel", "items": build_time701, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var body707 = new Lino.RichTextPanel({ "selectOnFocus": true, "flex": 55, "containing_panel": this, "name": "body", "title": "Inhalt" });
    var left_panel708 = new Ext.Panel({ "flex": 66, "layout": "vbox", "items": [ left_1_panel688, { "items": subject692, "autoHeight": true, "layout": "form", "xtype": "panel", "labelAlign": "top" }, left_3_panel695, left_4_panel702, body707 ], "frame": true, "layoutConfig": { "align": "stretch" }, "autoScroll": false, "hideCheckBoxLabels": true, "labelWidth": 72, "border": false, "bodyBorder": false, "labelAlign": "top" });
    var UploadsByController_htmlbox710 = new Lino.HtmlBoxPanel({ "flex": 16, "ls_bbar_actions": [ { "itemId": "insert", "menu_item_text": "Neu", "must_save": true, "tooltip": "Neuen Datensatz erstellen", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-new", "overflowText": "Neu", "auto_save": true } ], "name": "UploadsByController", "containing_panel": this, "items": new Ext.BoxComponent({autoScroll:true}), "title": "Uploads", "master_panel": this, "value": "<br/>", "always_enabled": true, "listeners": { "render": Lino.quicktip_renderer("Uploads","(notes.Notes.UploadsByController) ") }, "bodyStyle": "overflow-x:hidden", "ls_insert_handler": Lino.uploads.UploadsByController.insert, "layout": "fit", "tools": [ Lino.show_in_own_window_button(Lino.uploads.UploadsByController.grid) ] });
    var outbox_MailsByController_grid756 = new Lino.outbox.MailsByController.GridPanel({ "flex": 27, "listeners": { "render": Lino.quicktip_renderer("E-Mail-Ausg\u00e4nge","(outbox.outbox.MailsByController) ") }, "hide_top_toolbar": true, "containing_panel": this, "tools": [ Lino.show_in_own_window_button(Lino.outbox.MailsByController.grid) ], "master_panel": this });
    var right_panel774 = new Ext.Panel({ "flex": 33, "layout": "vbox", "items": [ UploadsByController_htmlbox710, outbox_MailsByController_grid756 ], "frame": true, "layoutConfig": { "align": "stretch" }, "autoScroll": false, "hideCheckBoxLabels": true, "labelWidth": 72, "border": false, "bodyBorder": false, "labelAlign": "top" });
    var main_1_panel775 = new Ext.Panel({ "autoScroll": false, "border": false, "layout": "hbox", "hideCheckBoxLabels": true, "items": [ left_panel708, right_panel774 ], "frame": false, "layoutConfig": { "align": "stretch" }, "labelAlign": "top" });
    var main_panel776 = new Ext.Panel({ "autoScroll": false, "border": false, "layout": "fit", "hideCheckBoxLabels": true, "items": [ main_1_panel775 ], "frame": true, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel776;
    this.before_row_edit = function(record) {
      body707.refresh();
      UploadsByController_htmlbox710.refresh();
      outbox_MailsByController_grid756.on_master_changed();
    }
    Lino.pcsw.NotesByPerson.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.contacts.Companies.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 20,
  initComponent : function() {
    var containing_panel = this;
    var prefix598 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("prefix","(contacts.Companies.prefix) ") }, "fieldLabel": "prefix", "name": "prefix", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var name599 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Name","(contacts.Companies.name) ") }, "fieldLabel": "Name", "name": "name", "maxLength": 200, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var id600 = new Ext.form.NumberField({ "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("ID","(contacts.Companies.id) ") }, "fieldLabel": "ID", "anchor": "-20", "name": "id" });
    var language601 = new Lino.ChoicesFieldElement({ "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Sprache</span>", "allowBlank": false, "value": "de", "hiddenName": "languageHidden", "listeners": { "render": Lino.quicktip_renderer("Sprache","(contacts.Companies.language) Die Sprache, in der Dokumente ausgestellt werden sollen.") }, "selectOnFocus": true, "anchor": "-20", "store": [ [ "de", "Deutsch" ], [ "fr", "Franz\u00f6sisch" ], [ "nl", "Niederl\u00e4ndisch" ] ], "name": "language" });
    var intro_box_1_panel602 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 31, "autoHeight": true, "layout": "form", "xtype": "panel", "items": prefix598, "labelAlign": "top" }, { "flex": 31, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name599, "labelAlign": "top" }, { "flex": 7, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id600, "labelAlign": "top" }, { "flex": 29, "autoHeight": true, "layout": "form", "xtype": "panel", "items": language601, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 72, "border": false, "anchor": "-20", "labelAlign": "top" });
    var vat_id607 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("MWSt.-Nr.","(contacts.Companies.vat_id) ") }, "fieldLabel": "MWSt.-Nr.", "name": "vat_id", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var activity608 = new Lino.RemoteComboFieldElement({ "fieldLabel": "Beruf", "name": "activity", "pageSize": 20, "emptyText": "Beruf ausw\u00e4hlen...", "listeners": { "render": Lino.quicktip_renderer("Beruf","(contacts.Companies.activity) ") }, "selectOnFocus": true, "hiddenName": "activityHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/contacts/Companies/activity", "method": "GET" }) }) });
    var type609 = new Lino.RemoteComboFieldElement({ "fieldLabel": "Organisationsart", "name": "type", "pageSize": 20, "emptyText": "Organisationsart ausw\u00e4hlen...", "listeners": { "render": Lino.quicktip_renderer("Organisationsart","(contacts.Companies.type) ") }, "selectOnFocus": true, "hiddenName": "typeHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/contacts/Companies/type", "method": "GET" }) }) });
    var intro_box_2_panel610 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 23, "autoHeight": true, "layout": "form", "xtype": "panel", "items": vat_id607, "labelAlign": "top" }, { "flex": 38, "autoHeight": true, "layout": "form", "xtype": "panel", "items": activity608, "labelAlign": "top" }, { "flex": 38, "autoHeight": true, "layout": "form", "xtype": "panel", "items": type609, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 153, "border": false, "anchor": "-20", "labelAlign": "top" });
    var bank_account1614 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Bankkonto 1","(contacts.Companies.bank_account1) ") }, "fieldLabel": "Bankkonto 1", "name": "bank_account1", "maxLength": 40, "selectOnFocus": true, "anchor": "-20" });
    var bank_account2615 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Bankkonto 2","(contacts.Companies.bank_account2) ") }, "fieldLabel": "Bankkonto 2", "name": "bank_account2", "maxLength": 40, "selectOnFocus": true, "anchor": "-20" });
    var is_obsolete616 = new Ext.form.Checkbox({ "boxLabel": "veraltet", "listeners": { "render": Lino.quicktip_renderer("veraltet","(contacts.Companies.is_obsolete) Altf\u00e4lle sind Partner, deren Stammdaten nicht mehr gepflegt werden und \nf\u00fcr neue Operationen nicht benutzt werden k\u00f6nnen.") }, "hideLabel": true, "checked": false, "name": "is_obsolete", "selectOnFocus": true, "anchor": "-20" });
    var intro_box_3_panel617 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 40, "autoHeight": true, "layout": "form", "xtype": "panel", "items": bank_account1614, "labelAlign": "top" }, { "flex": 40, "autoHeight": true, "layout": "form", "xtype": "panel", "items": bank_account2615, "labelAlign": "top" }, { "flex": 19, "autoHeight": true, "layout": "form", "xtype": "panel", "items": is_obsolete616, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 108, "border": false, "anchor": "-20", "labelAlign": "top" });
    var intro_box_panel621 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "form", "hideCheckBoxLabels": true, "items": [ intro_box_1_panel602, intro_box_2_panel610, intro_box_3_panel617 ], "frame": true, "bodyBorder": false, "labelAlign": "top" });
    var country622 = new Lino.TwinCombo({ "fieldLabel": "Land", "name": "country", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.countries.Countries.detail)}, "emptyText": "Land ausw\u00e4hlen...", "listeners": { "render": Lino.quicktip_renderer("Land","(contacts.Companies.country) ") }, "selectOnFocus": true, "hiddenName": "countryHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/contacts/Companies/country", "method": "GET" }) }) });
    var region623 = new Lino.TwinCombo({ "fieldLabel": "Region", "name": "region", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.countries.Cities.detail)}, "emptyText": "Ort ausw\u00e4hlen...", "listeners": { "render": Lino.quicktip_renderer("Region","(contacts.Companies.region) ") }, "selectOnFocus": true, "hiddenName": "regionHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/contacts/Companies/region", "method": "GET" }) }) });
    var box3_1_panel624 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": country622, "labelAlign": "top" }, { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": region623, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 63, "border": false, "anchor": "-20", "labelAlign": "top" });
    var city627 = new Lino.TwinCombo({ "forceSelection": false, "fieldLabel": "Ort", "name": "city", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.countries.Cities.detail)}, "emptyText": "Ort ausw\u00e4hlen...", "listeners": { "render": Lino.quicktip_renderer("Ort","(contacts.Companies.city) ") }, "selectOnFocus": true, "hiddenName": "cityHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/contacts/Companies/city", "method": "GET" }) }) });
    var zip_code628 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Postleitzahl","(contacts.Companies.zip_code) ") }, "fieldLabel": "Postleitzahl", "name": "zip_code", "maxLength": 10, "selectOnFocus": true, "boxMinWidth": Lino.chars2width(10), "anchor": "-20" });
    var box3_2_panel629 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 66, "autoHeight": true, "layout": "form", "xtype": "panel", "items": city627, "labelAlign": "top" }, { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": zip_code628, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 117, "border": false, "anchor": "-20", "labelAlign": "top" });
    var street_prefix632 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Pr\u00e4fix Stra\u00dfe","(contacts.Companies.street_prefix) Text to print before name of street, but to ignore for sorting.") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Pr\u00e4fix Stra\u00dfe</span>", "name": "street_prefix", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var street633 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Stra\u00dfe","(contacts.Companies.street) Name of street. Without house number.") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Stra\u00dfe</span>", "name": "street", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var street_no634 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Nr.","(contacts.Companies.street_no) House number") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Nr.</span>", "name": "street_no", "maxLength": 10, "selectOnFocus": true, "boxMinWidth": Lino.chars2width(10), "anchor": "-20" });
    var street_box635 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Box","(contacts.Companies.street_box) Text to print after :attr:`steet_no` on the same line") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Box</span>", "name": "street_box", "maxLength": 10, "selectOnFocus": true, "boxMinWidth": Lino.chars2width(10), "anchor": "-20" });
    var box3_3_panel636 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 30, "autoHeight": true, "layout": "form", "xtype": "panel", "items": street_prefix632, "labelAlign": "top" }, { "flex": 36, "autoHeight": true, "layout": "form", "xtype": "panel", "items": street633, "labelAlign": "top" }, { "flex": 16, "autoHeight": true, "layout": "form", "xtype": "panel", "items": street_no634, "labelAlign": "top" }, { "flex": 16, "autoHeight": true, "layout": "form", "xtype": "panel", "items": street_box635, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 126, "border": false, "anchor": "-20", "labelAlign": "top" });
    var addr2641 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Adresszeile nach Stra\u00dfe","(contacts.Companies.addr2) Address line to print below street line") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Adresszeile nach Stra\u00dfe</span>", "name": "addr2", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var box3_panel642 = new Ext.Panel({ "flex": 62, "autoHeight": true, "layout": "form", "items": [ box3_1_panel624, box3_2_panel629, box3_3_panel636, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": addr2641, "anchor": "-20", "labelAlign": "top" } ], "frame": true, "bodyBorder": false, "autoScroll": false, "hideCheckBoxLabels": true, "labelWidth": 216, "border": false, "labelAlign": "top" });
    var email644 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("E-Mail","(contacts.Companies.email) ") }, "fieldLabel": "E-Mail", "name": "email", "maxLength": 75, "selectOnFocus": true, "anchor": "-20" });
    var url645 = new Lino.URLField({ "listeners": { "render": Lino.quicktip_renderer("URL","(contacts.Companies.url) ") }, "fieldLabel": "URL", "name": "url", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var phone646 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Telefon","(contacts.Companies.phone) ") }, "fieldLabel": "Telefon", "name": "phone", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var gsm647 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("GSM","(contacts.Companies.gsm) ") }, "fieldLabel": "GSM", "name": "gsm", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var box4_panel648 = new Ext.Panel({ "flex": 37, "autoHeight": true, "layout": "form", "items": [ { "autoHeight": true, "layout": "form", "xtype": "panel", "items": email644, "anchor": "-20", "labelAlign": "top" }, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": url645, "anchor": "-20", "labelAlign": "top" }, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": phone646, "anchor": "-20", "labelAlign": "top" }, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": gsm647, "anchor": "-20", "labelAlign": "top" } ], "frame": true, "bodyBorder": false, "autoScroll": false, "hideCheckBoxLabels": true, "labelWidth": 72, "border": false, "labelAlign": "top" });
    var address_box_panel653 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "hideCheckBoxLabels": true, "items": [ box3_panel642, box4_panel648 ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var remarks654 = new Ext.form.TextArea({ "listeners": { "render": Lino.quicktip_renderer("Bemerkungen","(contacts.Companies.remarks) ") }, "fieldLabel": "Bemerkungen", "name": "remarks", "growMax": 2000, "selectOnFocus": true, "anchor": "-20 -10" });
    var is_courseprovider655 = new Ext.form.Checkbox({ "boxLabel": "ist Kursanbieter (<a href=\"javascript:Lino.show_mti_child('is_courseprovider',Lino.courses.CourseProviders.detail)\">zeigen</a>)", "listeners": { "render": Lino.quicktip_renderer("ist Kursanbieter","(contacts.Companies.is_courseprovider) ") }, "hideLabel": true, "name": "is_courseprovider", "selectOnFocus": true, "anchor": "-20" });
    var is_jobprovider656 = new Ext.form.Checkbox({ "boxLabel": "Stellenanbieter (<a href=\"javascript:Lino.show_mti_child('is_jobprovider',Lino.jobs.JobProviders.detail)\">zeigen</a>)", "listeners": { "render": Lino.quicktip_renderer("Stellenanbieter","(contacts.Companies.is_jobprovider) ") }, "hideLabel": true, "name": "is_jobprovider", "selectOnFocus": true, "anchor": "-20" });
    var client_contact_type657 = new Lino.RemoteComboFieldElement({ "fieldLabel": "Klientenkontaktart", "name": "client_contact_type", "pageSize": 20, "emptyText": "Klientenkontaktart ausw\u00e4hlen...", "listeners": { "render": Lino.quicktip_renderer("Klientenkontaktart","(contacts.Companies.client_contact_type) ") }, "selectOnFocus": true, "hiddenName": "client_contact_typeHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/contacts/Companies/client_contact_type", "method": "GET" }) }) });
    var box5_2_panel658 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 171, "hideCheckBoxLabels": true, "items": [ { "flex": 25, "autoHeight": true, "layout": "form", "xtype": "panel", "items": is_courseprovider655, "labelAlign": "top" }, { "flex": 25, "autoHeight": true, "layout": "form", "xtype": "panel", "items": is_jobprovider656, "labelAlign": "top" }, { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": client_contact_type657, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var box5_panel662 = new Ext.Panel({ "flex": 57, "layout": "vbox", "items": [ { "items": remarks654, "labelAlign": "top", "layout": "form", "xtype": "panel", "flex": 83 }, box5_2_panel658 ], "frame": true, "layoutConfig": { "align": "stretch" }, "autoScroll": false, "hideCheckBoxLabels": true, "labelWidth": 108, "border": false, "bodyBorder": false, "labelAlign": "top" });
    var contacts_RolesByCompany_grid668 = new Lino.contacts.RolesByCompany.GridPanel({ "flex": 42, "listeners": { "render": Lino.quicktip_renderer("Kontaktpersonen","(contacts.contacts.RolesByCompany) ") }, "hide_top_toolbar": true, "containing_panel": this, "tools": [ Lino.show_in_own_window_button(Lino.contacts.RolesByCompany.grid) ], "master_panel": this });
    var bottom_box_panel669 = new Ext.Panel({ "flex": 46, "border": false, "layout": "hbox", "hideCheckBoxLabels": true, "items": [ box5_panel662, contacts_RolesByCompany_grid668 ], "autoScroll": false, "layoutConfig": { "align": "stretch" }, "frame": false, "labelAlign": "top" });
    var general_panel670 = new Ext.Panel({ "layout": "vbox", "title": "Allgemein", "items": [ intro_box_panel621, address_box_panel653, bottom_box_panel669 ], "frame": true, "layoutConfig": { "align": "stretch" }, "hideCheckBoxLabels": true, "listeners": { "activate": Lino.on_tab_activate }, "autoScroll": false, "border": false, "bodyBorder": false, "labelAlign": "top" });
    var pcsw_NotesByCompany_grid790 = new Lino.pcsw.NotesByCompany.GridPanel({ "listeners": { "activate": Lino.on_tab_activate }, "hide_top_toolbar": true, "containing_panel": this, "title": "Ereignisse/Notizen", "tools": [ Lino.show_in_own_window_button(Lino.pcsw.NotesByCompany.grid) ], "master_panel": this });
    var main_panel791 = new Ext.TabPanel({ "hideCheckBoxLabels": true, "border": false, "split": true, "autoScroll": false, "items": [ general_panel670, pcsw_NotesByCompany_grid790 ], "activeTab": 0, "bodyBorder": false, "frame": true, "labelAlign": "top" });
    this.items = main_panel791;
    this.before_row_edit = function(record) {
      region623.setContextValue('country',record ? record.data['countryHidden'] : undefined);
      city627.setContextValue('country',record ? record.data['countryHidden'] : undefined);
      city627.setContextValue('region',record ? record.data['regionHidden'] : undefined);
      contacts_RolesByCompany_grid668.on_master_changed();
      pcsw_NotesByCompany_grid790.on_master_changed();
    }
    this.onRender = function(ct, position) {
      country622.on('change',Lino.chooser_handler(region623,'country'));
      country622.on('change',Lino.chooser_handler(city627,'country'));
      region623.on('change',Lino.chooser_handler(city627,'region'));
      Lino.contacts.Companies.DetailFormPanel.superclass.onRender.call(this, ct, position);
    }
    Lino.contacts.Companies.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.pcsw.Clients.InsertFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  autoHeight: true,
  content_type: 53,
  initComponent : function() {
    var containing_panel = this;
    var first_name1735 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Vorname","(pcsw.Clients.first_name) ") }, "fieldLabel": "Vorname", "name": "first_name", "maxLength": 200, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var last_name1736 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Familienname","(pcsw.Clients.last_name) ") }, "fieldLabel": "Familienname", "name": "last_name", "maxLength": 200, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var main_1_panel1737 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": first_name1735, "labelAlign": "top" }, { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": last_name1736, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 117, "border": false, "anchor": "-20", "labelAlign": "top" });
    var national_id1740 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("NR-Nummer","(pcsw.Clients.national_id) ") }, "fieldLabel": "NR-Nummer", "name": "national_id", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var gender1741 = new Lino.ChoicesFieldElement({ "forceSelection": true, "fieldLabel": "Geschlecht", "name": "gender", "hiddenName": "genderHidden", "listeners": { "render": Lino.quicktip_renderer("Geschlecht","(pcsw.Clients.gender) ") }, "selectOnFocus": true, "anchor": "-20", "store": [['','<br>']].concat(Lino.lino.Genders) });
    var language1742 = new Lino.ChoicesFieldElement({ "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Sprache</span>", "allowBlank": false, "value": "de", "hiddenName": "languageHidden", "listeners": { "render": Lino.quicktip_renderer("Sprache","(pcsw.Clients.language) Die Sprache, in der Dokumente ausgestellt werden sollen.") }, "selectOnFocus": true, "anchor": "-20", "store": [ [ "de", "Deutsch" ], [ "fr", "Franz\u00f6sisch" ], [ "nl", "Niederl\u00e4ndisch" ] ], "name": "language" });
    var main_3_panel1743 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 35, "autoHeight": true, "layout": "form", "xtype": "panel", "items": gender1741, "labelAlign": "top" }, { "flex": 64, "autoHeight": true, "layout": "form", "xtype": "panel", "items": language1742, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 99, "border": false, "anchor": "-20", "labelAlign": "top" });
    var main_panel1746 = new Ext.Panel({ "hideCheckBoxLabels": true, "autoHeight": true, "border": false, "layout": "form", "labelWidth": 90, "autoScroll": false, "items": [ main_1_panel1737, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": national_id1740, "anchor": "-20", "labelAlign": "top" }, main_3_panel1743 ], "frame": true, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel1746;
    this.before_row_edit = function(record) {
    }
    Lino.pcsw.Clients.InsertFormPanel.superclass.initComponent.call(this);
  }
});


Lino.pcsw.Clients.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 53,
  initComponent : function() {
    var containing_panel = this;
    var last_name997 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Familienname","(pcsw.Clients.last_name) ") }, "fieldLabel": "Familienname", "name": "last_name", "maxLength": 200, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var first_name998 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Vorname","(pcsw.Clients.first_name) ") }, "fieldLabel": "Vorname", "name": "first_name", "maxLength": 200, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var title999 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Anrede","(pcsw.Clients.title) ") }, "fieldLabel": "Anrede", "name": "title", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var box1_1_panel1000 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 45, "autoHeight": true, "layout": "form", "xtype": "panel", "items": last_name997, "labelAlign": "top" }, { "flex": 32, "autoHeight": true, "layout": "form", "xtype": "panel", "items": first_name998, "labelAlign": "top" }, { "flex": 21, "autoHeight": true, "layout": "form", "xtype": "panel", "items": title999, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 117, "border": false, "anchor": "-20", "labelAlign": "top" });
    var country1004 = new Lino.TwinCombo({ "fieldLabel": "Land", "name": "country", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.countries.Countries.detail)}, "emptyText": "Land ausw\u00e4hlen...", "listeners": { "render": Lino.quicktip_renderer("Land","(pcsw.Clients.country) ") }, "selectOnFocus": true, "hiddenName": "countryHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/pcsw/Clients/country", "method": "GET" }) }) });
    var city1005 = new Lino.TwinCombo({ "forceSelection": false, "fieldLabel": "Ort", "name": "city", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.countries.Cities.detail)}, "emptyText": "Ort ausw\u00e4hlen...", "listeners": { "render": Lino.quicktip_renderer("Ort","(pcsw.Clients.city) ") }, "selectOnFocus": true, "hiddenName": "cityHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/pcsw/Clients/city", "method": "GET" }) }) });
    var zip_code1006 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Postleitzahl","(pcsw.Clients.zip_code) ") }, "fieldLabel": "Postleitzahl", "name": "zip_code", "maxLength": 10, "selectOnFocus": true, "boxMinWidth": Lino.chars2width(10), "anchor": "-20" });
    var box1_2_panel1007 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 40, "autoHeight": true, "layout": "form", "xtype": "panel", "items": country1004, "labelAlign": "top" }, { "flex": 40, "autoHeight": true, "layout": "form", "xtype": "panel", "items": city1005, "labelAlign": "top" }, { "flex": 20, "autoHeight": true, "layout": "form", "xtype": "panel", "items": zip_code1006, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 117, "border": false, "anchor": "-20", "labelAlign": "top" });
    var street_prefix1011 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Pr\u00e4fix Stra\u00dfe","(pcsw.Clients.street_prefix) Text to print before name of street, but to ignore for sorting.") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Pr\u00e4fix Stra\u00dfe</span>", "name": "street_prefix", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var street1012 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Stra\u00dfe","(pcsw.Clients.street) Name of street. Without house number.") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Stra\u00dfe</span>", "name": "street", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var street_no1013 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Nr.","(pcsw.Clients.street_no) House number") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Nr.</span>", "name": "street_no", "maxLength": 10, "selectOnFocus": true, "boxMinWidth": Lino.chars2width(10), "anchor": "-20" });
    var street_box1014 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Box","(pcsw.Clients.street_box) Text to print after :attr:`steet_no` on the same line") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Box</span>", "name": "street_box", "maxLength": 10, "selectOnFocus": true, "boxMinWidth": Lino.chars2width(10), "anchor": "-20" });
    var box1_3_panel1015 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 30, "autoHeight": true, "layout": "form", "xtype": "panel", "items": street_prefix1011, "labelAlign": "top" }, { "flex": 36, "autoHeight": true, "layout": "form", "xtype": "panel", "items": street1012, "labelAlign": "top" }, { "flex": 16, "autoHeight": true, "layout": "form", "xtype": "panel", "items": street_no1013, "labelAlign": "top" }, { "flex": 16, "autoHeight": true, "layout": "form", "xtype": "panel", "items": street_box1014, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 126, "border": false, "anchor": "-20", "labelAlign": "top" });
    var addr21020 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Adresszeile nach Stra\u00dfe","(pcsw.Clients.addr2) Address line to print below street line") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Adresszeile nach Stra\u00dfe</span>", "name": "addr2", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var box1_panel1021 = new Ext.form.FieldSet({ "flex": 61, "autoHeight": true, "layout": "form", "title": "Adresse", "items": [ box1_1_panel1000, box1_2_panel1007, box1_3_panel1015, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": addr21020, "anchor": "-20", "labelAlign": "top" } ], "frame": true, "bodyBorder": false, "autoScroll": false, "hideCheckBoxLabels": true, "labelWidth": 216, "border": false, "labelAlign": "top" });
    var id1023 = new Ext.form.NumberField({ "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("ID","(pcsw.Clients.id) ") }, "fieldLabel": "ID", "anchor": "-20", "name": "id" });
    var language1024 = new Lino.ChoicesFieldElement({ "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Sprache</span>", "allowBlank": false, "value": "de", "hiddenName": "languageHidden", "listeners": { "render": Lino.quicktip_renderer("Sprache","(pcsw.Clients.language) Die Sprache, in der Dokumente ausgestellt werden sollen.") }, "selectOnFocus": true, "anchor": "-20", "store": [ [ "de", "Deutsch" ], [ "fr", "Franz\u00f6sisch" ], [ "nl", "Niederl\u00e4ndisch" ] ], "name": "language" });
    var box2_1_panel1025 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 37, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id1023, "labelAlign": "top" }, { "flex": 62, "autoHeight": true, "layout": "form", "xtype": "panel", "items": language1024, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 72, "border": false, "anchor": "-20", "labelAlign": "top" });
    var email1028 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("E-Mail","(pcsw.Clients.email) ") }, "fieldLabel": "E-Mail", "name": "email", "maxLength": 75, "selectOnFocus": true, "anchor": "-20" });
    var phone1029 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Telefon","(pcsw.Clients.phone) ") }, "fieldLabel": "Telefon", "name": "phone", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var fax1030 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Fax","(pcsw.Clients.fax) ") }, "fieldLabel": "Fax", "name": "fax", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var box2_3_panel1031 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": phone1029, "labelAlign": "top" }, { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": fax1030, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 72, "border": false, "anchor": "-20", "labelAlign": "top" });
    var gsm1034 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("GSM","(pcsw.Clients.gsm) ") }, "fieldLabel": "GSM", "name": "gsm", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var box2_panel1035 = new Ext.form.FieldSet({ "flex": 38, "autoHeight": true, "layout": "form", "title": "Kontakt", "items": [ box2_1_panel1025, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": email1028, "anchor": "-20", "labelAlign": "top" }, box2_3_panel1031, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": gsm1034, "anchor": "-20", "labelAlign": "top" } ], "frame": true, "bodyBorder": false, "autoScroll": false, "hideCheckBoxLabels": true, "labelWidth": 63, "border": false, "labelAlign": "top" });
    var general_1_panel1038 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "hideCheckBoxLabels": true, "items": [ box1_panel1021, box2_panel1035 ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "anchor": "-20", "labelAlign": "top" });
    var gender1039 = new Lino.ChoicesFieldElement({ "forceSelection": true, "fieldLabel": "Geschlecht", "name": "gender", "hiddenName": "genderHidden", "listeners": { "render": Lino.quicktip_renderer("Geschlecht","(pcsw.Clients.gender) ") }, "selectOnFocus": true, "anchor": "-20", "store": [['','<br>']].concat(Lino.lino.Genders) });
    var birth_date1040 = new Lino.IncompleteDateField({ "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Geburtsdatum","(pcsw.Clients.birth_date) Unkomplette Datumsangaben sind erlaubt, z.B. \"00.00.1980\" hei\u00dft \"irgendwann im Jahr 1980\", \"00.07.1980\" hei\u00dft \"im Juli 1980\"oder \"23.07.0000\" hei\u00dft \"an einem 23. Juli\".") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Geburtsdatum</span>", "anchor": "-20", "name": "birth_date" });
    var age_disp1041 = new Ext.form.DisplayField({ "disabled": true, "listeners": { "render": Lino.quicktip_renderer("Alter","(pcsw.Clients.age) ") }, "fieldLabel": "Alter", "name": "age", "anchor": "-20", "value": "<br/>", "always_enabled": true });
    var civil_state1042 = new Lino.ChoicesFieldElement({ "forceSelection": true, "fieldLabel": "Zivilstand", "name": "civil_state", "hiddenName": "civil_stateHidden", "listeners": { "render": Lino.quicktip_renderer("Zivilstand","(pcsw.Clients.civil_state) ") }, "selectOnFocus": true, "anchor": "-20", "store": [['','<br>']].concat(Lino.pcsw.CivilState) });
    var noble_condition1043 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Adelstitel","(pcsw.Clients.noble_condition) The eventual noble condition of this person. Imported from TIM.") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Adelstitel</span>", "name": "noble_condition", "maxLength": 50, "selectOnFocus": true, "anchor": "-20" });
    var box3_1_panel1044 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 14, "autoHeight": true, "layout": "form", "xtype": "panel", "items": gender1039, "labelAlign": "top" }, { "flex": 17, "autoHeight": true, "layout": "form", "xtype": "panel", "items": birth_date1040, "labelAlign": "top" }, { "flex": 14, "autoHeight": true, "layout": "form", "xtype": "panel", "items": age_disp1041, "labelAlign": "top" }, { "flex": 22, "autoHeight": true, "layout": "form", "xtype": "panel", "items": civil_state1042, "labelAlign": "top" }, { "flex": 30, "autoHeight": true, "layout": "form", "xtype": "panel", "items": noble_condition1043, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 117, "border": false, "anchor": "-20", "labelAlign": "top" });
    var birth_country1050 = new Lino.TwinCombo({ "fieldLabel": "Geburtsland", "name": "birth_country", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.countries.Countries.detail)}, "emptyText": "Land ausw\u00e4hlen...", "listeners": { "render": Lino.quicktip_renderer("Geburtsland","(pcsw.Clients.birth_country) ") }, "selectOnFocus": true, "hiddenName": "birth_countryHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/pcsw/Clients/birth_country", "method": "GET" }) }) });
    var birth_place1051 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Geburtsort","(pcsw.Clients.birth_place) ") }, "fieldLabel": "Geburtsort", "name": "birth_place", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var nationality1052 = new Lino.TwinCombo({ "fieldLabel": "Staatsangeh\u00f6rigkeit", "name": "nationality", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.countries.Countries.detail)}, "emptyText": "Land ausw\u00e4hlen...", "listeners": { "render": Lino.quicktip_renderer("Staatsangeh\u00f6rigkeit","(pcsw.Clients.nationality) ") }, "selectOnFocus": true, "hiddenName": "nationalityHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/pcsw/Clients/nationality", "method": "GET" }) }) });
    var national_id1053 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("NR-Nummer","(pcsw.Clients.national_id) ") }, "fieldLabel": "NR-Nummer", "name": "national_id", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var box3_2_panel1054 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 28, "autoHeight": true, "layout": "form", "xtype": "panel", "items": birth_country1050, "labelAlign": "top" }, { "flex": 29, "autoHeight": true, "layout": "form", "xtype": "panel", "items": birth_place1051, "labelAlign": "top" }, { "flex": 21, "autoHeight": true, "layout": "form", "xtype": "panel", "items": nationality1052, "labelAlign": "top" }, { "flex": 21, "autoHeight": true, "layout": "form", "xtype": "panel", "items": national_id1053, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 180, "border": false, "anchor": "-20", "labelAlign": "top" });
    var box3_panel1059 = new Ext.form.FieldSet({ "autoHeight": true, "layout": "form", "title": "Geburtsangaben", "items": [ box3_1_panel1044, box3_2_panel1054 ], "frame": true, "bodyBorder": false, "autoScroll": false, "hideCheckBoxLabels": true, "border": false, "anchor": "-20", "labelAlign": "top" });
    var card_number1060 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("eID-Kartennummer","(pcsw.Clients.card_number) ") }, "fieldLabel": "Nummer", "name": "card_number", "maxLength": 20, "selectOnFocus": true, "anchor": "-20" });
    var card_valid_from1061 = new Lino.DateField({ "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("ID-Karte g\u00fcltig von","(pcsw.Clients.card_valid_from) ") }, "fieldLabel": "G\u00fcltig von", "anchor": "-20", "name": "card_valid_from" });
    var card_valid_until1062 = new Lino.DateField({ "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("bis","(pcsw.Clients.card_valid_until) ") }, "fieldLabel": "g\u00fcltig bis", "anchor": "-20", "name": "card_valid_until" });
    var card_issuer1063 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("eID-Karte ausgestellt durch","(pcsw.Clients.card_issuer) ") }, "fieldLabel": "Ausgestellt durch", "name": "card_issuer", "maxLength": 50, "selectOnFocus": true, "anchor": "-20" });
    var card_type1064 = new Lino.ChoicesFieldElement({ "forceSelection": true, "fieldLabel": "eID-Kartenart", "name": "card_type", "hiddenName": "card_typeHidden", "listeners": { "render": Lino.quicktip_renderer("eID-Kartenart","(pcsw.Clients.card_type) ") }, "selectOnFocus": true, "anchor": "-20", "store": [['','<br>']].concat(Lino.pcsw.BeIdCardTypes) });
    var eid_panel_1_panel1065 = new Ext.form.FieldSet({ "autoHeight": true, "layout": "hbox", "title": "eID-Karte", "bodyBorder": true, "frame": false, "layoutConfig": { "align": "stretchmax" }, "autoScroll": false, "items": [ { "flex": 20, "autoHeight": true, "layout": "form", "xtype": "panel", "items": card_number1060, "labelAlign": "top" }, { "flex": 20, "autoHeight": true, "layout": "form", "xtype": "panel", "items": card_valid_from1061, "labelAlign": "top" }, { "flex": 20, "autoHeight": true, "layout": "form", "xtype": "panel", "items": card_valid_until1062, "labelAlign": "top" }, { "flex": 17, "autoHeight": true, "layout": "form", "xtype": "panel", "items": card_issuer1063, "labelAlign": "top" }, { "flex": 20, "autoHeight": true, "layout": "form", "xtype": "panel", "items": card_type1064, "labelAlign": "top" } ], "hideCheckBoxLabels": true, "labelWidth": 252, "border": false, "anchor": "-20", "labelAlign": "top" });
    var created1071 = new Ext.form.DisplayField({ "disabled": true, "listeners": { "render": Lino.quicktip_renderer("Erstellt","(pcsw.Clients.created) ") }, "fieldLabel": "Erstellt", "name": "created", "anchor": "-20", "value": "<br>" });
    var modified1072 = new Ext.form.DisplayField({ "disabled": true, "listeners": { "render": Lino.quicktip_renderer("Bearbeitet","(pcsw.Clients.modified) ") }, "fieldLabel": "Bearbeitet", "name": "modified", "anchor": "-20", "value": "<br>" });
    var box4_3_panel1073 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": created1071, "labelAlign": "top" }, { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": modified1072, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 99, "border": false, "anchor": "-20", "labelAlign": "top" });
    var box4_panel1076 = new Ext.Panel({ "flex": 82, "autoHeight": true, "border": false, "layout": "form", "hideCheckBoxLabels": true, "items": [ box3_panel1059, eid_panel_1_panel1065, box4_3_panel1073 ], "frame": true, "autoScroll": false, "bodyBorder": false, "labelAlign": "top" });
    var image_htmlbox1077 = new Lino.HtmlBoxPanel({ "flex": 17, "layout": "fit", "name": "image", "containing_panel": this, "master_panel": this, "items": new Ext.BoxComponent({autoScroll:true}), "bodyStyle": "overflow-x:hidden", "value": "<br/>", "always_enabled": true, "listeners": { "render": Lino.quicktip_renderer(null,"(pcsw.Clients.image) ") } });
    var general_2_panel1078 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ box4_panel1076, image_htmlbox1077 ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 0, "border": false, "anchor": "-20", "labelAlign": "top" });
    var general_panel1079 = new Ext.Panel({ "autoHeight": true, "layout": "form", "title": "Person", "items": [ general_1_panel1038, general_2_panel1078 ], "frame": true, "bodyBorder": false, "hideCheckBoxLabels": true, "listeners": { "activate": Lino.on_tab_activate }, "autoScroll": false, "border": false, "labelAlign": "top" });
    var in_belgium_since1080 = new Lino.DateField({ "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Lebt in Belgien seit","(pcsw.Clients.in_belgium_since) Since when this person in Belgium lives.\n<b>Important:</b> help_text can be formatted.") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Lebt in Belgien seit</span>", "anchor": "-20", "name": "in_belgium_since" });
    var residence_type1081 = new Lino.ChoicesFieldElement({ "forceSelection": true, "fieldLabel": "Register", "name": "residence_type", "hiddenName": "residence_typeHidden", "listeners": { "render": Lino.quicktip_renderer("Register","(pcsw.Clients.residence_type) ") }, "selectOnFocus": true, "anchor": "-20", "store": [['','<br>']].concat(Lino.pcsw.ResidenceType) });
    var gesdos_id1082 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Gesdos-Nr","(pcsw.Clients.gesdos_id) ") }, "fieldLabel": "Gesdos-Nr", "name": "gesdos_id", "maxLength": 40, "selectOnFocus": true, "anchor": "-20" });
    var status_1_panel1083 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 25, "autoHeight": true, "layout": "form", "xtype": "panel", "items": in_belgium_since1080, "labelAlign": "top" }, { "flex": 38, "autoHeight": true, "layout": "form", "xtype": "panel", "items": residence_type1081, "labelAlign": "top" }, { "flex": 35, "autoHeight": true, "layout": "form", "xtype": "panel", "items": gesdos_id1082, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 189, "border": false, "anchor": "-20", "labelAlign": "top" });
    var bank_account11087 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Bankkonto 1","(pcsw.Clients.bank_account1) ") }, "fieldLabel": "Bankkonto 1", "name": "bank_account1", "maxLength": 40, "selectOnFocus": true, "anchor": "-20" });
    var bank_account21088 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Bankkonto 2","(pcsw.Clients.bank_account2) ") }, "fieldLabel": "Bankkonto 2", "name": "bank_account2", "maxLength": 40, "selectOnFocus": true, "anchor": "-20" });
    var status_2_panel1089 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": bank_account11087, "labelAlign": "top" }, { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": bank_account21088, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 108, "border": false, "anchor": "-20", "labelAlign": "top" });
    var job_agents1092 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Interim-Agenturen","(pcsw.Clients.job_agents) ") }, "fieldLabel": "Interim-Agenturen", "name": "job_agents", "maxLength": 100, "selectOnFocus": true, "anchor": "-20" });
    var group1093 = new Lino.RemoteComboFieldElement({ "fieldLabel": "Integrationsphase", "name": "group", "pageSize": 20, "emptyText": "Integrationsphase ausw\u00e4hlen...", "listeners": { "render": Lino.quicktip_renderer("Integrationsphase","(pcsw.Clients.group) ") }, "selectOnFocus": true, "hiddenName": "groupHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/pcsw/Clients/group", "method": "GET" }) }) });
    var status_3_panel1094 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 56, "autoHeight": true, "layout": "form", "xtype": "panel", "items": job_agents1092, "labelAlign": "top" }, { "flex": 43, "autoHeight": true, "layout": "form", "xtype": "panel", "items": group1093, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 162, "border": false, "anchor": "-20", "labelAlign": "top" });
    var status_panel1097 = new Ext.Panel({ "flex": 68, "autoHeight": true, "border": false, "layout": "form", "hideCheckBoxLabels": true, "items": [ status_1_panel1083, status_2_panel1089, status_3_panel1094 ], "frame": true, "autoScroll": false, "bodyBorder": false, "labelAlign": "top" });
    var aid_type1098 = new Lino.RemoteComboFieldElement({ "fieldLabel": "Sozialhilfeart", "name": "aid_type", "pageSize": 20, "emptyText": "Sozialhilfeart ausw\u00e4hlen...", "listeners": { "render": Lino.quicktip_renderer("Sozialhilfeart","(pcsw.Clients.aid_type) ") }, "selectOnFocus": true, "hiddenName": "aid_typeHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/pcsw/Clients/aid_type", "method": "GET" }) }) });
    var income_ag1099 = new Ext.form.Checkbox({ "boxLabel": "Arbeitslosengeld", "listeners": { "render": Lino.quicktip_renderer("Arbeitslosengeld","(pcsw.Clients.income_ag) ") }, "hideLabel": true, "checked": false, "name": "income_ag", "selectOnFocus": true, "anchor": "-20" });
    var income_wg1100 = new Ext.form.Checkbox({ "boxLabel": "Wartegeld", "listeners": { "render": Lino.quicktip_renderer("Wartegeld","(pcsw.Clients.income_wg) ") }, "hideLabel": true, "checked": false, "name": "income_wg", "selectOnFocus": true, "anchor": "-20" });
    var income_2_panel1101 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": income_ag1099, "labelAlign": "top" }, { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": income_wg1100, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 153, "border": false, "anchor": "-20", "labelAlign": "top" });
    var income_kg1104 = new Ext.form.Checkbox({ "boxLabel": "Krankengeld", "listeners": { "render": Lino.quicktip_renderer("Krankengeld","(pcsw.Clients.income_kg) ") }, "hideLabel": true, "checked": false, "name": "income_kg", "selectOnFocus": true, "anchor": "-20" });
    var income_rente1105 = new Ext.form.Checkbox({ "boxLabel": "Rente", "listeners": { "render": Lino.quicktip_renderer("Rente","(pcsw.Clients.income_rente) ") }, "hideLabel": true, "checked": false, "name": "income_rente", "selectOnFocus": true, "anchor": "-20" });
    var income_3_panel1106 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": income_kg1104, "labelAlign": "top" }, { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": income_rente1105, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 108, "border": false, "anchor": "-20", "labelAlign": "top" });
    var income_misc1109 = new Ext.form.Checkbox({ "boxLabel": "andere Einkommen", "listeners": { "render": Lino.quicktip_renderer("andere Einkommen","(pcsw.Clients.income_misc) ") }, "hideLabel": true, "checked": false, "name": "income_misc", "selectOnFocus": true, "anchor": "-20" });
    var income_panel1110 = new Ext.Panel({ "flex": 31, "autoHeight": true, "layout": "form", "items": [ { "autoHeight": true, "layout": "form", "xtype": "panel", "items": aid_type1098, "anchor": "-20", "labelAlign": "top" }, income_2_panel1101, income_3_panel1106, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": income_misc1109, "anchor": "-20", "labelAlign": "top" } ], "frame": true, "bodyBorder": false, "autoScroll": false, "hideCheckBoxLabels": true, "labelWidth": 153, "border": false, "labelAlign": "top" });
    var status_tab_1_panel1113 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "hideCheckBoxLabels": true, "items": [ status_panel1097, income_panel1110 ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var is_seeking1127 = new Ext.form.Checkbox({ "boxLabel": "Arbeit suchend", "listeners": { "render": Lino.quicktip_renderer("Arbeit suchend","(pcsw.Clients.is_seeking) ") }, "hideLabel": true, "checked": false, "name": "is_seeking", "selectOnFocus": true, "anchor": "-20" });
    var unemployed_since1128 = new Lino.DateField({ "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("eingetragen seit","(pcsw.Clients.unemployed_since) ") }, "fieldLabel": "eingetragen seit", "anchor": "-20", "name": "unemployed_since" });
    var work_permit_suspended_until1129 = new Lino.DateField({ "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Wartezeit bis","(pcsw.Clients.work_permit_suspended_until) ") }, "fieldLabel": "Wartezeit bis", "anchor": "-20", "name": "work_permit_suspended_until" });
    var papers_1_panel1130 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 153, "hideCheckBoxLabels": true, "items": [ { "flex": 38, "autoHeight": true, "layout": "form", "xtype": "panel", "items": is_seeking1127, "labelAlign": "top" }, { "flex": 30, "autoHeight": true, "layout": "form", "xtype": "panel", "items": unemployed_since1128, "labelAlign": "top" }, { "flex": 30, "autoHeight": true, "layout": "form", "xtype": "panel", "items": work_permit_suspended_until1129, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var needs_residence_permit1134 = new Ext.form.Checkbox({ "boxLabel": "Braucht Aufenthaltserlaubnis", "listeners": { "render": Lino.quicktip_renderer("Braucht Aufenthaltserlaubnis","(pcsw.Clients.needs_residence_permit) ") }, "hideLabel": true, "checked": false, "name": "needs_residence_permit", "selectOnFocus": true, "anchor": "-20" });
    var needs_work_permit1135 = new Ext.form.Checkbox({ "boxLabel": "Braucht Arb.Erl.", "listeners": { "render": Lino.quicktip_renderer("Braucht Arb.Erl.","(pcsw.Clients.needs_work_permit) ") }, "hideLabel": true, "checked": false, "name": "needs_work_permit", "selectOnFocus": true, "anchor": "-20" });
    var papers_2_panel1136 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 261, "hideCheckBoxLabels": true, "items": [ { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": needs_residence_permit1134, "labelAlign": "top" }, { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": needs_work_permit1135, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var residence_permit_disp1139 = new Ext.form.DisplayField({ "disabled": true, "listeners": { "render": Lino.quicktip_renderer("Aufenthaltserlaubnis","(pcsw.Clients.residence_permit) ") }, "fieldLabel": "Aufenthaltserlaubnis", "name": "residence_permit", "anchor": "-20", "value": "<br/>", "always_enabled": true });
    var work_permit_disp1140 = new Ext.form.DisplayField({ "disabled": true, "listeners": { "render": Lino.quicktip_renderer("Arbeitserlaubnis","(pcsw.Clients.work_permit) ") }, "fieldLabel": "Arbeitserlaubnis", "name": "work_permit", "anchor": "-20", "value": "<br/>", "always_enabled": true });
    var driving_licence_disp1141 = new Ext.form.DisplayField({ "disabled": true, "listeners": { "render": Lino.quicktip_renderer("F\u00fchrerschein","(pcsw.Clients.driving_licence) ") }, "fieldLabel": "F\u00fchrerschein", "name": "driving_licence", "anchor": "-20", "value": "<br/>", "always_enabled": true });
    var papers_3_panel1142 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 189, "hideCheckBoxLabels": true, "items": [ { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": residence_permit_disp1139, "labelAlign": "top" }, { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": work_permit_disp1140, "labelAlign": "top" }, { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": driving_licence_disp1141, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var UploadsByController_htmlbox1146 = new Lino.HtmlBoxPanel({ "flex": 37, "ls_bbar_actions": [ { "itemId": "insert", "menu_item_text": "Neu", "must_save": true, "tooltip": "Neuen Datensatz erstellen", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-new", "overflowText": "Neu", "auto_save": true } ], "name": "UploadsByController", "containing_panel": this, "items": new Ext.BoxComponent({autoScroll:true}), "title": "Uploads", "master_panel": this, "value": "<br/>", "always_enabled": true, "listeners": { "render": Lino.quicktip_renderer("Uploads","(pcsw.Clients.UploadsByController) ") }, "bodyStyle": "overflow-x:hidden", "ls_insert_handler": Lino.uploads.UploadsByController.insert, "layout": "fit", "tools": [ Lino.show_in_own_window_button(Lino.uploads.UploadsByController.grid) ] });
    var papers_panel1147 = new Ext.Panel({ "flex": 50, "layout": "vbox", "items": [ papers_1_panel1130, papers_2_panel1136, papers_3_panel1142, UploadsByController_htmlbox1146 ], "frame": true, "layoutConfig": { "align": "stretch" }, "autoScroll": false, "hideCheckBoxLabels": true, "labelWidth": 72, "border": false, "bodyBorder": false, "labelAlign": "top" });
    var status_tab_2_panel1148 = new Ext.Panel({ "flex": 66, "border": false, "layout": "hbox", "hideCheckBoxLabels": true, "items": [ papers_panel1147 ], "autoScroll": false, "layoutConfig": { "align": "stretch" }, "frame": false, "labelAlign": "top" });
    var status_tab_panel1149 = new Ext.Panel({ "layout": "vbox", "title": "Status", "items": [ status_tab_1_panel1113, status_tab_2_panel1148 ], "frame": true, "layoutConfig": { "align": "stretch" }, "hideCheckBoxLabels": true, "listeners": { "activate": Lino.on_tab_activate }, "autoScroll": false, "border": false, "bodyBorder": false, "labelAlign": "top" });
    var workflow_buttons_disp1150 = new Ext.form.DisplayField({ "disabled": true, "listeners": { "render": Lino.quicktip_renderer("Arbeitsablauf","(pcsw.Clients.workflow_buttons) ") }, "fieldLabel": "Arbeitsablauf", "name": "workflow_buttons", "anchor": "-20", "value": "<br/>", "always_enabled": true });
    var broker1151 = new Lino.RemoteComboFieldElement({ "fieldLabel": "Vermittler", "name": "broker", "pageSize": 20, "emptyText": "Vermittler ausw\u00e4hlen...", "listeners": { "render": Lino.quicktip_renderer("Vermittler","(pcsw.Clients.broker) ") }, "selectOnFocus": true, "hiddenName": "brokerHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/pcsw/Clients/broker", "method": "GET" }) }) });
    var faculty1152 = new Lino.TwinCombo({ "fieldLabel": "Fachbereich", "name": "faculty", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.newcomers.Faculties.detail)}, "emptyText": "Fachbereich ausw\u00e4hlen...", "listeners": { "render": Lino.quicktip_renderer("Fachbereich","(pcsw.Clients.faculty) ") }, "selectOnFocus": true, "hiddenName": "facultyHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/pcsw/Clients/faculty", "method": "GET" }) }) });
    var newcomers_left_panel1153 = new Ext.Panel({ "flex": 33, "autoHeight": true, "layout": "form", "items": [ { "autoHeight": true, "layout": "form", "xtype": "panel", "items": workflow_buttons_disp1150, "anchor": "-20", "labelAlign": "top" }, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": broker1151, "anchor": "-20", "labelAlign": "top" }, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": faculty1152, "anchor": "-20", "labelAlign": "top" } ], "frame": true, "bodyBorder": false, "autoScroll": false, "hideCheckBoxLabels": true, "labelWidth": 126, "border": false, "labelAlign": "top" });
    var coaching_1_panel1172 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "hideCheckBoxLabels": true, "items": [ newcomers_left_panel1153 ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var pcsw_ContactsByClient_grid1180 = new Lino.pcsw.ContactsByClient.GridPanel({ "flex": 50, "listeners": { "render": Lino.quicktip_renderer("Kontakte","(pcsw.pcsw.ContactsByClient) ") }, "hide_top_toolbar": true, "containing_panel": this, "tools": [ Lino.show_in_own_window_button(Lino.pcsw.ContactsByClient.grid) ], "master_panel": this });
    var pcsw_CoachingsByClient_grid1189 = new Lino.pcsw.CoachingsByClient.GridPanel({ "flex": 50, "listeners": { "render": Lino.quicktip_renderer("Begleitungen","(pcsw.pcsw.CoachingsByClient) ") }, "hide_top_toolbar": true, "containing_panel": this, "params_panel_hidden": true, "tools": [ Lino.show_in_own_window_button(Lino.pcsw.CoachingsByClient.grid) ], "master_panel": this });
    var coaching_2_panel1190 = new Ext.Panel({ "flex": 50, "border": false, "layout": "hbox", "hideCheckBoxLabels": true, "items": [ pcsw_ContactsByClient_grid1180, pcsw_CoachingsByClient_grid1189 ], "autoScroll": false, "layoutConfig": { "align": "stretch" }, "frame": false, "labelAlign": "top" });
    var coaching_panel1191 = new Ext.Panel({ "layout": "vbox", "title": "Begleitung", "items": [ coaching_1_panel1172, coaching_2_panel1190 ], "frame": true, "layoutConfig": { "align": "stretch" }, "hideCheckBoxLabels": true, "listeners": { "activate": Lino.on_tab_activate }, "autoScroll": false, "border": false, "bodyBorder": false, "labelAlign": "top" });
    var skills1274 = new Ext.form.TextArea({ "listeners": { "render": Lino.quicktip_renderer("Sonstige F\u00e4higkeiten","(pcsw.Clients.skills) ") }, "fieldLabel": "Sonstige F\u00e4higkeiten", "name": "skills", "growMax": 2000, "selectOnFocus": true, "anchor": "-20 -10" });
    var competences_1_panel1275 = new Ext.Panel({ "flex": 5, "layout": "hbox", "items": [ { "items": skills1274, "labelAlign": "top", "layout": "form", "xtype": "panel", "flex": 28 } ], "region": "north", "layoutConfig": { "align": "stretch" }, "hideCheckBoxLabels": true, "split": true, "autoScroll": false, "labelWidth": 189, "border": false, "frame": false, "labelAlign": "top" });
    var obstacles1284 = new Ext.form.TextArea({ "listeners": { "render": Lino.quicktip_renderer("Hindernisse","(pcsw.Clients.obstacles) ") }, "fieldLabel": "Hindernisse", "name": "obstacles", "growMax": 2000, "selectOnFocus": true, "anchor": "-20 -10" });
    var competences_2_panel1285 = new Ext.Panel({ "flex": 5, "layout": "hbox", "items": [ { "items": obstacles1284, "labelAlign": "top", "layout": "form", "xtype": "panel", "flex": 44 } ], "region": "center", "layoutConfig": { "align": "stretch" }, "hideCheckBoxLabels": true, "split": true, "autoScroll": false, "labelWidth": 108, "border": false, "frame": false, "labelAlign": "top" });
    var competences_panel1287 = new Lino.VBorderPanel({ "autoScroll": false, "listeners": { "activate": Lino.on_tab_activate }, "border": false, "title": "Kompetenzen", "hideCheckBoxLabels": true, "items": [ competences_1_panel1275, competences_2_panel1285 ], "frame": true, "bodyBorder": false, "labelAlign": "top" });
    var pcsw_NotesByPerson_grid1634 = new Lino.pcsw.NotesByPerson.GridPanel({ "listeners": { "activate": Lino.on_tab_activate }, "hide_top_toolbar": true, "containing_panel": this, "title": "Historie", "tools": [ Lino.show_in_own_window_button(Lino.pcsw.NotesByPerson.grid) ], "master_panel": this });
    var outbox_MailsByProject_grid1681 = new Lino.outbox.MailsByProject.GridPanel({ "flex": 5, "hide_top_toolbar": true, "containing_panel": this, "region": "north", "master_panel": this, "listeners": { "render": Lino.quicktip_renderer("E-Mail-Ausgang","(outbox.outbox.MailsByProject) ") }, "split": true, "tools": [ Lino.show_in_own_window_button(Lino.outbox.MailsByProject.grid) ] });
    var outbox_panel1693 = new Lino.VBorderPanel({ "autoScroll": false, "listeners": { "activate": Lino.on_tab_activate }, "border": false, "title": "Korrespondenz", "hideCheckBoxLabels": true, "items": [ outbox_MailsByProject_grid1681 ], "frame": true, "bodyBorder": false, "labelAlign": "top" });
    var cbss_identify_person_disp1722 = new Ext.form.DisplayField({ "disabled": true, "listeners": { "render": Lino.quicktip_renderer("IdentifyPerson-Anfragen","(pcsw.Clients.cbss_identify_person) ") }, "fieldLabel": "IdentifyPerson-Anfragen", "name": "cbss_identify_person", "anchor": "-20", "value": "<br/>", "always_enabled": true });
    var cbss_manage_access_disp1723 = new Ext.form.DisplayField({ "disabled": true, "listeners": { "render": Lino.quicktip_renderer("ManageAccess-Anfragen","(pcsw.Clients.cbss_manage_access) ") }, "fieldLabel": "ManageAccess-Anfragen", "name": "cbss_manage_access", "anchor": "-20", "value": "<br/>", "always_enabled": true });
    var cbss_retrieve_ti_groups_disp1724 = new Ext.form.DisplayField({ "disabled": true, "listeners": { "render": Lino.quicktip_renderer("Tx25-Anfragen","(pcsw.Clients.cbss_retrieve_ti_groups) ") }, "fieldLabel": "Tx25-Anfragen", "name": "cbss_retrieve_ti_groups", "anchor": "-20", "value": "<br/>", "always_enabled": true });
    var cbss_1_panel1725 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 216, "hideCheckBoxLabels": true, "items": [ { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": cbss_identify_person_disp1722, "labelAlign": "top" }, { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": cbss_manage_access_disp1723, "labelAlign": "top" }, { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": cbss_retrieve_ti_groups_disp1724, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var cbss_summary_htmlbox1729 = new Lino.HtmlBoxPanel({ "flex": 50, "layout": "fit", "name": "cbss_summary", "containing_panel": this, "master_panel": this, "items": new Ext.BoxComponent({autoScroll:true}), "title": "Zusammenfassung ZDSS", "bodyStyle": "overflow-x:hidden", "value": "<br/>", "always_enabled": true, "listeners": { "render": Lino.quicktip_renderer("Zusammenfassung ZDSS","(pcsw.Clients.cbss_summary) ") } });
    var cbss_panel1730 = new Ext.Panel({ "layout": "vbox", "title": "ZDSS", "items": [ cbss_1_panel1725, cbss_summary_htmlbox1729 ], "frame": true, "layoutConfig": { "align": "stretch" }, "hideCheckBoxLabels": true, "listeners": { "activate": Lino.on_tab_activate }, "autoScroll": false, "labelWidth": 189, "border": false, "bodyBorder": false, "labelAlign": "top" });
    var main_panel1734 = new Ext.TabPanel({ "hideCheckBoxLabels": true, "border": false, "split": true, "autoScroll": false, "items": [ general_panel1079, status_tab_panel1149, coaching_panel1191, competences_panel1287, pcsw_NotesByPerson_grid1634, outbox_panel1693, cbss_panel1730 ], "activeTab": 0, "bodyBorder": false, "frame": true, "labelAlign": "top" });
    this.items = main_panel1734;
    this.before_row_edit = function(record) {
      city1005.setContextValue('country',record ? record.data['countryHidden'] : undefined);
      city1005.setContextValue('region',record ? record.data['regionHidden'] : undefined);
      image_htmlbox1077.refresh();
      UploadsByController_htmlbox1146.refresh();
      pcsw_ContactsByClient_grid1180.on_master_changed();
      pcsw_CoachingsByClient_grid1189.on_master_changed();
      pcsw_NotesByPerson_grid1634.on_master_changed();
      outbox_MailsByProject_grid1681.on_master_changed();
      cbss_summary_htmlbox1729.refresh();
    }
    this.onRender = function(ct, position) {
      country1004.on('change',Lino.chooser_handler(city1005,'country'));
      Lino.pcsw.Clients.DetailFormPanel.superclass.onRender.call(this, ct, position);
    }
    Lino.pcsw.Clients.DetailFormPanel.superclass.initComponent.call(this);
  }
});

Lino.contacts.Companies.merge_row = new Lino.WindowAction({ "draggable": true, "width": Lino.chars2width(50), "autoHeight": true, "maximizable": true, "modal": true, "maximized": false },function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.contacts.Companies.merge_row_ActionFormPanel({});
});
Lino.cal.GuestStates.wf1 = new Lino.WindowAction({ "draggable": true, "width": Lino.chars2width(50), "maximizable": true, "modal": true, "maximized": false, "height": Lino.rows2height(15) },function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.reception.ExpectedGuests.wf1_ActionFormPanel({});
});
Lino.cal.GuestStates.wf2 = new Lino.WindowAction({ "draggable": true, "width": Lino.chars2width(50), "maximizable": true, "modal": true, "maximized": false, "height": Lino.rows2height(15) },function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.reception.ExpectedGuests.wf2_ActionFormPanel({});
});
Lino.cal.Guests.checkin = new Lino.WindowAction({ "draggable": true, "width": Lino.chars2width(50), "maximizable": true, "modal": true, "maximized": false, "height": Lino.rows2height(15) },function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.reception.ExpectedGuests.checkin_ActionFormPanel({});
});
Lino.cal.Guests.checkout = new Lino.WindowAction({ "draggable": true, "width": Lino.chars2width(50), "maximizable": true, "modal": true, "maximized": false, "height": Lino.rows2height(15) },function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.reception.ExpectedGuests.checkout_ActionFormPanel({});
});
Lino.pcsw.ClientStates.wf2 = new Lino.WindowAction({ "draggable": true, "width": Lino.chars2width(50), "maximizable": true, "modal": true, "maximized": false, "height": Lino.rows2height(15) },function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.pcsw.Clients.wf2_ActionFormPanel({});
});
Lino.pcsw.Clients.merge_row = new Lino.WindowAction({ "draggable": true, "width": Lino.chars2width(70), "autoHeight": true, "maximizable": true, "modal": true, "maximized": false },function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.pcsw.Clients.merge_row_ActionFormPanel({});
});

// js_render_GridPanel_class users.MySettings
Lino.users.MySettings.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "Keine Daten anzuzeigen." },
  ls_url : "/users/MySettings",
  ls_bbar_actions : [ { "itemId": "put", "menu_item_text": "Speichern", "tooltip": "\u00c4nderungen in diesem Formular speichern", "panel_btn_handler": function(panel){panel.save(null,false,'put')}, "iconCls": "x-tbar-save", "overflowText": "Speichern", "auto_save": false }, { "itemId": "update_reminders", "menu_item_text": "Erinnerungen aktualisieren", "must_save": true, "panel_btn_handler": Lino.row_action_handler('update_reminders','GET'), "text": "Erinnerungen aktualisieren", "overflowText": "Erinnerungen aktualisieren", "auto_save": true } ],
  title : "Benutzer",
  page_length : 20,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "name": "username" }, { "name": "profile" }, 'profileHidden', { "name": "first_name" }, { "name": "last_name" }, { "type": "int", "name": "id" }, { "name": "created" }, { "name": "modified" }, { "name": "password" }, { "name": "email" }, { "name": "remarks" }, { "name": "language" }, 'languageHidden', { "name": "partner" }, 'partnerHidden', { "name": "access_class" }, 'access_classHidden', { "name": "calendar" }, 'calendarHidden', { "name": "coaching_type" }, 'coaching_typeHidden', { "type": "boolean", "name": "coaching_supervisor" }, { "type": "int", "name": "newcomer_quota" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 5,
  ls_grid_configs : [  ],
  content_type : 7,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 24,
  initComponent : function() {
    this.ls_detail_handler = Lino.users.MySettings.detail;
    this.ls_insert_handler = Lino.users.Users.insert;
    var ww = this.containing_window;
    var username1884 = new Ext.form.TextField({ "selectOnFocus": true, "allowBlank": false, "maxLength": 30 });
    var profile1885 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "forceSelection": true, "store": [['','<br>']].concat(Lino.lino.UserProfiles) });
    var first_name1886 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 30 });
    var last_name1887 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 30 });
    var id1888 = new Ext.form.NumberField({ "selectOnFocus": true });
    var created1889 = new Ext.form.DisplayField({ "disabled": true, "value": "<br>" });
    var modified1890 = new Ext.form.DisplayField({ "disabled": true, "value": "<br>" });
    var password1891 = new Ext.form.TextField({ "selectOnFocus": true, "allowBlank": false, "maxLength": 128 });
    var email1892 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 75 });
    var remarks1893 = new Ext.form.TextArea({ "selectOnFocus": true, "growMax": 2000 });
    var language1894 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "allowBlank": false, "store": [ [ "de", "Deutsch" ], [ "fr", "Franz\u00f6sisch" ], [ "nl", "Niederl\u00e4ndisch" ] ] });
    var partner1895 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/users/MySettings/partner", "method": "GET" }) }), "pageSize": 20, "emptyText": "Partner ausw\u00e4hlen..." });
    var access_class1896 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "forceSelection": true, "allowBlank": false, "store": Lino.cal.AccessClasses });
    var calendar1897 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/users/MySettings/calendar", "method": "GET" }) }), "pageSize": 20, "emptyText": "Kalender ausw\u00e4hlen..." });
    var coaching_type1898 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/users/MySettings/coaching_type", "method": "GET" }) }), "pageSize": 20, "emptyText": "Dienst ausw\u00e4hlen..." });
    var coaching_supervisor1899 = new Ext.form.Checkbox({ "selectOnFocus": true, "checked": false });
    var newcomer_quota1900 = new Ext.form.NumberField({ "selectOnFocus": true, "allowBlank": false, "value": 0 });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ { "colIndex": 0, "sortable": true, "header": "Benutzername", "editable": true, "tooltip": "(users.MySettings.username) \n        Required. Must be unique. \n        ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "username", "editor": username1884 }, { "colIndex": 1, "sortable": true, "header": "Benutzerprofil", "editable": true, "tooltip": "(users.MySettings.profile) ", "filter": { "type": "string" }, "width": Lino.chars2width(42), "dataIndex": "profile", "editor": profile1885 }, { "colIndex": 2, "sortable": true, "header": "Vorname", "editable": true, "tooltip": "(users.MySettings.first_name) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "first_name", "editor": first_name1886 }, { "colIndex": 3, "sortable": true, "header": "Familienname", "editable": true, "tooltip": "(users.MySettings.last_name) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "last_name", "editor": last_name1887 }, new Lino.NullNumberColumn({ "colIndex": 4, "sortable": true, "format": "0", "editable": true, "tooltip": "(users.MySettings.id) ", "filter": { "type": "numeric" }, "header": "ID", "renderer": Lino.id_renderer, "editor": id1888, "width": Lino.chars2width(6), "dataIndex": "id" }), { "width": Lino.chars2width(17), "colIndex": 5, "sortable": true, "dataIndex": "created", "header": "Erstellt", "editable": false, "tooltip": "(users.MySettings.created) " }, { "width": Lino.chars2width(17), "colIndex": 6, "sortable": true, "dataIndex": "modified", "header": "Bearbeitet", "editable": false, "tooltip": "(users.MySettings.modified) " }, { "colIndex": 7, "sortable": true, "header": "Passwort", "editable": true, "tooltip": "(users.MySettings.password) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "password", "hidden": true, "editor": password1891 }, { "colIndex": 8, "sortable": true, "header": "e-mail address", "editable": true, "tooltip": "(users.MySettings.email) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "email", "editor": email1892 }, { "colIndex": 9, "sortable": false, "width": Lino.chars2width(61), "editable": true, "tooltip": "(users.MySettings.remarks) ", "filter": { "type": "string" }, "header": "Bemerkungen", "renderer": Lino.text_renderer, "hidden": true, "editor": remarks1893, "dataIndex": "remarks" }, { "colIndex": 10, "sortable": true, "header": "Sprache", "editable": true, "tooltip": "(users.MySettings.language) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "language", "editor": language1894 }, { "colIndex": 11, "sortable": true, "header": "Partner", "editable": true, "tooltip": "(users.MySettings.partner) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('partnerHidden','Lino.contacts.Partners.detail'), "editor": partner1895, "dataIndex": "partner" }, { "colIndex": 12, "sortable": true, "header": "Standardm\u00e4\u00dfige Zugriffsklasse", "editable": true, "tooltip": "(users.MySettings.access_class) Die standardm\u00e4\u00dfige Zugriffsklasse f\u00fcr Ihre Termine und Aufgaben", "filter": { "type": "string" }, "width": Lino.chars2width(35), "dataIndex": "access_class", "editor": access_class1896 }, { "colIndex": 13, "sortable": true, "header": "Standard-Kalender", "editable": true, "tooltip": "(users.MySettings.calendar) The default calendar for your events and tasks.", "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "calendar", "editor": calendar1897 }, { "colIndex": 14, "sortable": true, "header": "Dienst", "editable": true, "tooltip": "(users.MySettings.coaching_type) The default CoachingType used when creating Coachings.", "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "coaching_type", "editor": coaching_type1898 }, { "colIndex": 15, "sortable": false, "xtype": "checkcolumn", "header": "Benachrichtigung wenn ein Begleiter zugewiesen wird", "editable": true, "tooltip": "(users.MySettings.coaching_supervisor) Wenn ein Neuantrag einem Begleiter zugewiesen wurde, wird au\u00dfer dem Begleiter auch dieser Benutzer benachrichtigt.", "filter": { "type": "boolean" }, "width": Lino.chars2width(11), "dataIndex": "coaching_supervisor" }, new Lino.NullNumberColumn({ "colIndex": 16, "sortable": true, "format": "0", "editable": true, "tooltip": "(users.MySettings.newcomer_quota) Wieviel Arbeitszeit dieser Benutzer f\u00fcr Neuantr\u00e4ge zur Verf\u00fcgung steht\n(100 = ganztags, 50 = halbtags, 0 = gar nicht).\nWenn zwei Benutzer die gleiche Belastungspunktzahl haben, \naber einer davon sich nur zu 50% um Neuantr\u00e4ge k\u00fcmmert, \ngilt er als doppelt so belastet wie sein Kollege.\n", "filter": { "type": "numeric" }, "header": "Quote NZ", "dataIndex": "newcomer_quota", "width": Lino.chars2width(6), "editor": newcomer_quota1900 }) ];
    Lino.users.MySettings.GridPanel.superclass.initComponent.call(this);
  }
});


Lino.users.MySettings.detailPanel = Ext.extend(Lino.users.MySettings.DetailFormPanel,{
  empty_title: "Benutzer",
  ls_bbar_actions: [ { "itemId": "put", "menu_item_text": "Speichern", "tooltip": "\u00c4nderungen in diesem Formular speichern", "panel_btn_handler": function(panel){panel.save(null,false,'put')}, "iconCls": "x-tbar-save", "overflowText": "Speichern", "auto_save": false }, { "itemId": "update_reminders", "menu_item_text": "Erinnerungen aktualisieren", "must_save": true, "panel_btn_handler": Lino.row_action_handler('update_reminders','GET'), "text": "Erinnerungen aktualisieren", "overflowText": "Erinnerungen aktualisieren", "auto_save": true } ],
  ls_url: "/users/MySettings",
  initComponent : function() {
    this.ls_detail_handler = Lino.users.MySettings.detail;
    this.ls_insert_handler = Lino.users.Users.insert;
    Lino.users.MySettings.detailPanel.superclass.initComponent.call(this);
  }
});

Lino.users.MySettings.detail = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.users.MySettings.detailPanel(p);
});

Lino.users.MySettings.detailPanel = Ext.extend(Lino.users.MySettings.DetailFormPanel,{
  empty_title: "Benutzer",
  ls_bbar_actions: [ { "itemId": "put", "menu_item_text": "Speichern", "tooltip": "\u00c4nderungen in diesem Formular speichern", "panel_btn_handler": function(panel){panel.save(null,false,'put')}, "iconCls": "x-tbar-save", "overflowText": "Speichern", "auto_save": false }, { "itemId": "update_reminders", "menu_item_text": "Erinnerungen aktualisieren", "must_save": true, "panel_btn_handler": Lino.row_action_handler('update_reminders','GET'), "text": "Erinnerungen aktualisieren", "overflowText": "Erinnerungen aktualisieren", "auto_save": true } ],
  ls_url: "/users/MySettings",
  initComponent : function() {
    this.ls_detail_handler = Lino.users.MySettings.detail;
    this.ls_insert_handler = Lino.users.Users.insert;
    Lino.users.MySettings.detailPanel.superclass.initComponent.call(this);
  }
});

Lino.users.MySettings.detail = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.users.MySettings.detailPanel(p);
});

// js_render_GridPanel_class countries.Languages
Lino.countries.Languages.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "Keine Daten anzuzeigen." },
  ls_url : "/countries/Languages",
  ls_bbar_actions : [ { "itemId": "insert", "menu_item_text": "Neu", "must_save": true, "tooltip": "Neuen Datensatz erstellen", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-new", "overflowText": "Neu", "auto_save": true }, { "itemId": "detail", "menu_item_text": "Detail", "tooltip": "Detail-Fenster auf diesem Datensatz \u00f6ffnen", "panel_btn_handler": Lino.show_detail, "iconCls": "x-tbar-detail", "overflowText": "Detail", "auto_save": true }, { "itemId": null, "menu_item_text": "L\u00f6schen", "tooltip": "Diesen Datensatz l\u00f6schen", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "L\u00f6schen", "auto_save": false } ],
  title : "Sprachen",
  page_length : 20,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "name": "name" }, { "name": "name_fr" }, { "name": "name_nl" }, { "name": "id" }, { "name": "iso2" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 3,
  ls_grid_configs : [  ],
  content_type : 12,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 6,
  initComponent : function() {
    this.ls_detail_handler = Lino.countries.Languages.detail;
    this.ls_insert_handler = Lino.countries.Languages.insert;
    var ww = this.containing_window;
    var name1902 = new Ext.form.TextField({ "selectOnFocus": true, "allowBlank": false, "maxLength": 200 });
    var name_fr1903 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var name_nl1904 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var id1905 = new Ext.form.TextField({ "selectOnFocus": true, "boxMinWidth": Lino.chars2width(3), "allowBlank": false, "maxLength": 3 });
    var iso21906 = new Ext.form.TextField({ "selectOnFocus": true, "boxMinWidth": Lino.chars2width(2), "maxLength": 2 });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ { "colIndex": 0, "sortable": true, "header": "Bezeichnung", "editable": true, "tooltip": "(countries.Languages.name) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "name", "editor": name1902 }, { "colIndex": 1, "sortable": true, "header": "Bezeichnung (fr)", "editable": true, "tooltip": "(countries.Languages.name_fr) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "name_fr", "editor": name_fr1903 }, { "colIndex": 2, "sortable": true, "header": "Bezeichnung (nl)", "editable": true, "tooltip": "(countries.Languages.name_nl) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "name_nl", "editor": name_nl1904 }, { "colIndex": 3, "sortable": true, "header": "id", "editable": true, "tooltip": "(countries.Languages.id) ", "filter": { "type": "string" }, "width": Lino.chars2width(5), "dataIndex": "id", "editor": id1905 }, { "colIndex": 4, "sortable": true, "header": "iso2", "editable": true, "tooltip": "(countries.Languages.iso2) ", "filter": { "type": "string" }, "width": Lino.chars2width(5), "dataIndex": "iso2", "editor": iso21906 } ];
    Lino.countries.Languages.GridPanel.superclass.initComponent.call(this);
  }
});


Lino.countries.Languages.insertPanel = Ext.extend(Lino.countries.Languages.DetailFormPanel,{
  empty_title: "Neu Sprachen",
  hide_navigator: true,
  ls_bbar_actions: [ { "itemId": "post", "menu_item_text": "Erstellen", "tooltip": "Datensatz erstellen und dann im Detail-Fenster \u00f6ffnen", "panel_btn_handler": function(panel){panel.save(null,true,'post')}, "text": "Erstellen", "overflowText": "Erstellen", "auto_save": false }, { "itemId": "poststay", "menu_item_text": "Erstellen ohne Detail", "tooltip": "Nach Erstellen des Datensatzes kein Detail-Fenster \u00f6ffnen", "panel_btn_handler": function(panel){panel.save(null,false,'poststay')}, "text": "Erstellen ohne Detail", "overflowText": "Erstellen ohne Detail", "auto_save": false } ],
  ls_url: "/countries/Languages",
  action_name: "insert",
  initComponent : function() {
    this.ls_detail_handler = Lino.countries.Languages.detail;
    this.ls_insert_handler = Lino.countries.Languages.insert;
    Lino.countries.Languages.insertPanel.superclass.initComponent.call(this);
  }
});

Lino.countries.Languages.insert = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.countries.Languages.insertPanel(p);
});

Lino.countries.Languages.detailPanel = Ext.extend(Lino.countries.Languages.DetailFormPanel,{
  empty_title: "Detail Sprachen",
  ls_bbar_actions: [ { "itemId": "put", "menu_item_text": "Speichern", "tooltip": "\u00c4nderungen in diesem Formular speichern", "panel_btn_handler": function(panel){panel.save(null,false,'put')}, "iconCls": "x-tbar-save", "overflowText": "Speichern", "auto_save": false }, { "itemId": "insert", "menu_item_text": "Neu", "must_save": true, "tooltip": "Neuen Datensatz erstellen", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-new", "overflowText": "Neu", "auto_save": true }, { "itemId": null, "menu_item_text": "L\u00f6schen", "tooltip": "Diesen Datensatz l\u00f6schen", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "L\u00f6schen", "auto_save": false } ],
  ls_url: "/countries/Languages",
  action_name: "detail",
  initComponent : function() {
    this.ls_detail_handler = Lino.countries.Languages.detail;
    this.ls_insert_handler = Lino.countries.Languages.insert;
    Lino.countries.Languages.detailPanel.superclass.initComponent.call(this);
  }
});

Lino.countries.Languages.detail = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.countries.Languages.detailPanel(p);
});
Lino.countries.Languages.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.countries.Languages.GridPanel(p);
});

// js_render_GridPanel_class countries.Countries
Lino.countries.Countries.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "Keine Daten anzuzeigen." },
  ls_url : "/countries/Countries",
  ls_bbar_actions : [ { "itemId": "insert", "menu_item_text": "Neu", "must_save": true, "tooltip": "Neuen Datensatz erstellen", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-new", "overflowText": "Neu", "auto_save": true }, { "itemId": "detail", "menu_item_text": "Detail", "tooltip": "Detail-Fenster auf diesem Datensatz \u00f6ffnen", "panel_btn_handler": Lino.show_detail, "iconCls": "x-tbar-detail", "overflowText": "Detail", "auto_save": true }, { "itemId": null, "menu_item_text": "L\u00f6schen", "tooltip": "Diesen Datensatz l\u00f6schen", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "L\u00f6schen", "auto_save": false } ],
  title : "L\u00e4nder",
  page_length : 20,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "name": "name" }, { "name": "name_fr" }, { "name": "name_nl" }, { "name": "isocode" }, { "name": "short_code" }, { "name": "iso3" }, { "name": "inscode" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 3,
  ls_grid_configs : [  ],
  content_type : 11,
  ls_id_property : "isocode",
  gc_name : 0,
  disabled_actions_index : 8,
  initComponent : function() {
    this.ls_detail_handler = Lino.countries.Countries.detail;
    this.ls_insert_handler = Lino.countries.Countries.insert;
    var ww = this.containing_window;
    var name1908 = new Ext.form.TextField({ "selectOnFocus": true, "allowBlank": false, "maxLength": 200 });
    var name_fr1909 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var name_nl1910 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var isocode1911 = new Ext.form.TextField({ "selectOnFocus": true, "boxMinWidth": Lino.chars2width(4), "allowBlank": false, "maxLength": 4 });
    var short_code1912 = new Ext.form.TextField({ "selectOnFocus": true, "boxMinWidth": Lino.chars2width(4), "maxLength": 4 });
    var iso31913 = new Ext.form.TextField({ "selectOnFocus": true, "boxMinWidth": Lino.chars2width(3), "maxLength": 3 });
    var inscode1914 = new Ext.form.TextField({ "selectOnFocus": true, "boxMinWidth": Lino.chars2width(3), "maxLength": 3 });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ { "colIndex": 0, "sortable": true, "header": "Bezeichnung", "editable": true, "tooltip": "(countries.Countries.name) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "name", "editor": name1908 }, { "colIndex": 1, "sortable": true, "header": "Bezeichnung (fr)", "editable": true, "tooltip": "(countries.Countries.name_fr) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "name_fr", "editor": name_fr1909 }, { "colIndex": 2, "sortable": true, "header": "Bezeichnung (nl)", "editable": true, "tooltip": "(countries.Countries.name_nl) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "name_nl", "editor": name_nl1910 }, { "colIndex": 3, "sortable": true, "header": "ISO-Code", "editable": true, "tooltip": "(countries.Countries.isocode)         The two-letter code for this country as defined by ISO 3166-1. \n        For countries that no longer exist it may be a 4-letter code.", "filter": { "type": "string" }, "width": Lino.chars2width(6), "dataIndex": "isocode", "editor": isocode1911 }, { "colIndex": 4, "sortable": true, "header": "Short code", "editable": true, "tooltip": "(countries.Countries.short_code) A short abbreviation for regional usage. Obsolete.", "filter": { "type": "string" }, "width": Lino.chars2width(6), "dataIndex": "short_code", "editor": short_code1912 }, { "colIndex": 5, "sortable": true, "header": "ISO3-Code", "editable": true, "tooltip": "(countries.Countries.iso3) The three-letter code for this country as defined by ISO 3166-1.", "filter": { "type": "string" }, "width": Lino.chars2width(5), "dataIndex": "iso3", "editor": iso31913 }, { "colIndex": 6, "sortable": true, "header": "INS-Code", "editable": true, "tooltip": "(countries.Countries.inscode) The official code for this country used by statbel.fgov.be", "filter": { "type": "string" }, "width": Lino.chars2width(5), "dataIndex": "inscode", "editor": inscode1914 } ];
    Lino.countries.Countries.GridPanel.superclass.initComponent.call(this);
  }
});


Lino.countries.Countries.insertPanel = Ext.extend(Lino.countries.Countries.DetailFormPanel,{
  empty_title: "Neu L\u00e4nder",
  hide_navigator: true,
  ls_bbar_actions: [ { "itemId": "post", "menu_item_text": "Erstellen", "tooltip": "Datensatz erstellen und dann im Detail-Fenster \u00f6ffnen", "panel_btn_handler": function(panel){panel.save(null,true,'post')}, "text": "Erstellen", "overflowText": "Erstellen", "auto_save": false }, { "itemId": "poststay", "menu_item_text": "Erstellen ohne Detail", "tooltip": "Nach Erstellen des Datensatzes kein Detail-Fenster \u00f6ffnen", "panel_btn_handler": function(panel){panel.save(null,false,'poststay')}, "text": "Erstellen ohne Detail", "overflowText": "Erstellen ohne Detail", "auto_save": false } ],
  ls_url: "/countries/Countries",
  action_name: "insert",
  initComponent : function() {
    this.ls_detail_handler = Lino.countries.Countries.detail;
    this.ls_insert_handler = Lino.countries.Countries.insert;
    Lino.countries.Countries.insertPanel.superclass.initComponent.call(this);
  }
});

Lino.countries.Countries.insert = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.countries.Countries.insertPanel(p);
});

Lino.countries.Countries.detailPanel = Ext.extend(Lino.countries.Countries.DetailFormPanel,{
  empty_title: "Detail L\u00e4nder",
  ls_bbar_actions: [ { "itemId": "put", "menu_item_text": "Speichern", "tooltip": "\u00c4nderungen in diesem Formular speichern", "panel_btn_handler": function(panel){panel.save(null,false,'put')}, "iconCls": "x-tbar-save", "overflowText": "Speichern", "auto_save": false }, { "itemId": "insert", "menu_item_text": "Neu", "must_save": true, "tooltip": "Neuen Datensatz erstellen", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-new", "overflowText": "Neu", "auto_save": true }, { "itemId": null, "menu_item_text": "L\u00f6schen", "tooltip": "Diesen Datensatz l\u00f6schen", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "L\u00f6schen", "auto_save": false } ],
  ls_url: "/countries/Countries",
  action_name: "detail",
  initComponent : function() {
    this.ls_detail_handler = Lino.countries.Countries.detail;
    this.ls_insert_handler = Lino.countries.Countries.insert;
    Lino.countries.Countries.detailPanel.superclass.initComponent.call(this);
  }
});

Lino.countries.Countries.detail = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.countries.Countries.detailPanel(p);
});
Lino.countries.Countries.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.countries.Countries.GridPanel(p);
});

// js_render_GridPanel_class properties.PropChoices
Lino.properties.PropChoices.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "Keine Daten anzuzeigen." },
  ls_url : "/properties/PropChoices",
  ls_bbar_actions : [ { "itemId": null, "menu_item_text": "L\u00f6schen", "tooltip": "Diesen Datensatz l\u00f6schen", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "L\u00f6schen", "auto_save": false } ],
  title : "Auswahlm\u00f6glichkeiten",
  page_length : 20,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "type": "int", "name": "id" }, { "name": "type" }, 'typeHidden', { "name": "value" }, { "name": "text" }, { "name": "text_fr" }, { "name": "text_nl" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 0,
  ls_grid_configs : [  ],
  content_type : 17,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 8,
  initComponent : function() {
    var ww = this.containing_window;
    var id1916 = new Ext.form.NumberField({ "selectOnFocus": true });
    var type1917 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/properties/PropChoices/type", "method": "GET" }) }), "allowBlank": false, "pageSize": 20, "emptyText": "Eigenschafts-Datentyp ausw\u00e4hlen..." });
    var value1918 = new Ext.form.TextField({ "selectOnFocus": true, "allowBlank": false, "maxLength": 200 });
    var text1919 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var text_fr1920 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var text_nl1921 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ new Lino.NullNumberColumn({ "colIndex": 0, "sortable": true, "format": "0", "editable": true, "tooltip": "(properties.PropChoices.id) ", "filter": { "type": "numeric" }, "header": "ID", "renderer": Lino.id_renderer, "editor": id1916, "width": Lino.chars2width(6), "dataIndex": "id" }), { "colIndex": 1, "sortable": true, "header": "Eigenschafts-Datentyp", "editable": true, "tooltip": "(properties.PropChoices.type) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "type", "editor": type1917 }, { "colIndex": 2, "sortable": true, "header": "Wert", "editable": true, "tooltip": "(properties.PropChoices.value) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "value", "editor": value1918 }, { "colIndex": 3, "sortable": true, "header": "Bezeichnung", "editable": true, "tooltip": "(properties.PropChoices.text) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "text", "editor": text1919 }, { "colIndex": 4, "sortable": true, "header": "Bezeichnung (fr)", "editable": true, "tooltip": "(properties.PropChoices.text_fr) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "text_fr", "editor": text_fr1920 }, { "colIndex": 5, "sortable": true, "header": "Bezeichnung (nl)", "editable": true, "tooltip": "(properties.PropChoices.text_nl) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "text_nl", "editor": text_nl1921 } ];
    Lino.properties.PropChoices.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.properties.PropChoices.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.properties.PropChoices.GridPanel(p);
});

// js_render_GridPanel_class contacts.Partners
Lino.contacts.Partners.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "Keine Daten anzuzeigen." },
  ls_url : "/contacts/Partners",
  ls_bbar_actions : [ { "itemId": "insert", "menu_item_text": "Neu", "must_save": true, "tooltip": "Neuen Datensatz erstellen", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-new", "overflowText": "Neu", "auto_save": true }, { "itemId": "detail", "menu_item_text": "Detail", "tooltip": "Detail-Fenster auf diesem Datensatz \u00f6ffnen", "panel_btn_handler": Lino.show_detail, "iconCls": "x-tbar-detail", "overflowText": "Detail", "auto_save": true }, { "itemId": null, "menu_item_text": "L\u00f6schen", "tooltip": "Diesen Datensatz l\u00f6schen", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "L\u00f6schen", "auto_save": false } ],
  title : "Partner",
  page_length : 20,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "name": "name" }, { "name": "email" }, { "name": "created" }, { "name": "modified" }, { "name": "country" }, 'countryHidden', { "name": "city" }, 'cityHidden', { "name": "region" }, 'regionHidden', { "name": "zip_code" }, { "name": "addr1" }, { "name": "street_prefix" }, { "name": "street" }, { "name": "street_no" }, { "name": "street_box" }, { "name": "addr2" }, { "name": "language" }, 'languageHidden', { "name": "url" }, { "name": "phone" }, { "name": "gsm" }, { "name": "fax" }, { "name": "remarks" }, { "type": "boolean", "name": "is_obsolete" }, { "name": "activity" }, 'activityHidden', { "name": "bank_account1" }, { "name": "bank_account2" }, { "type": "int", "name": "id" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 29,
  ls_grid_configs : [  ],
  content_type : 23,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 31,
  initComponent : function() {
    this.ls_detail_handler = Lino.contacts.Partners.detail;
    this.ls_insert_handler = Lino.contacts.Partners.insert;
    var ww = this.containing_window;
    var name1923 = new Ext.form.TextField({ "selectOnFocus": true, "allowBlank": false, "maxLength": 200 });
    var email1924 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 75 });
    var created1925 = new Ext.form.DisplayField({ "disabled": true, "value": "<br>" });
    var modified1926 = new Ext.form.DisplayField({ "disabled": true, "value": "<br>" });
    var country1927 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/contacts/Partners/country", "method": "GET" }) }), "pageSize": 20, "emptyText": "Land ausw\u00e4hlen..." });
    var city1928 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "forceSelection": false, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/contacts/Partners/city", "method": "GET" }) }), "pageSize": 20, "emptyText": "Ort ausw\u00e4hlen..." });
    var region1929 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/contacts/Partners/region", "method": "GET" }) }), "pageSize": 20, "emptyText": "Ort ausw\u00e4hlen..." });
    var zip_code1930 = new Ext.form.TextField({ "selectOnFocus": true, "boxMinWidth": Lino.chars2width(10), "maxLength": 10 });
    var addr11931 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var street_prefix1932 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var street1933 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var street_no1934 = new Ext.form.TextField({ "selectOnFocus": true, "boxMinWidth": Lino.chars2width(10), "maxLength": 10 });
    var street_box1935 = new Ext.form.TextField({ "selectOnFocus": true, "boxMinWidth": Lino.chars2width(10), "maxLength": 10 });
    var addr21936 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var language1937 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "store": [ [ "de", "Deutsch" ], [ "fr", "Franz\u00f6sisch" ], [ "nl", "Niederl\u00e4ndisch" ] ], "allowBlank": false, "value": "de" });
    var url1938 = new Lino.URLField({ "selectOnFocus": true, "maxLength": 200 });
    var phone1939 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var gsm1940 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var fax1941 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var remarks1942 = new Ext.form.TextArea({ "selectOnFocus": true, "growMax": 2000 });
    var is_obsolete1943 = new Ext.form.Checkbox({ "selectOnFocus": true, "checked": false });
    var activity1944 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/contacts/Partners/activity", "method": "GET" }) }), "pageSize": 20, "emptyText": "Beruf ausw\u00e4hlen..." });
    var bank_account11945 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 40 });
    var bank_account21946 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 40 });
    var id1947 = new Ext.form.NumberField({ "selectOnFocus": true });
    this.before_row_edit = function(record) {
      city1928.setContextValue('country',record ? record.data['countryHidden'] : undefined);
      city1928.setContextValue('region',record ? record.data['regionHidden'] : undefined);
      region1929.setContextValue('country',record ? record.data['countryHidden'] : undefined);
    };
    this.onRender = function(ct, position) {
      country1927.on('change',Lino.chooser_handler(city1928,'country'));
      region1929.on('change',Lino.chooser_handler(city1928,'region'));
      country1927.on('change',Lino.chooser_handler(region1929,'country'));
      Lino.contacts.Partners.GridPanel.superclass.onRender.call(this, ct, position);
    }
    this.ls_columns = [ { "colIndex": 0, "sortable": true, "header": "Name", "editable": true, "tooltip": "(contacts.Partners.name) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "name", "editor": name1923 }, { "colIndex": 1, "sortable": true, "header": "E-Mail", "editable": true, "tooltip": "(contacts.Partners.email) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "email", "editor": email1924 }, { "colIndex": 2, "sortable": true, "header": "Erstellt", "editable": false, "tooltip": "(contacts.Partners.created) ", "width": Lino.chars2width(17), "dataIndex": "created", "hidden": true }, { "colIndex": 3, "sortable": true, "header": "Bearbeitet", "editable": false, "tooltip": "(contacts.Partners.modified) ", "width": Lino.chars2width(17), "dataIndex": "modified", "hidden": true }, { "colIndex": 4, "sortable": true, "header": "Land", "editable": true, "tooltip": "(contacts.Partners.country) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('countryHidden','Lino.countries.Countries.detail'), "editor": country1927, "dataIndex": "country" }, { "colIndex": 5, "sortable": true, "header": "Ort", "editable": true, "tooltip": "(contacts.Partners.city) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "city", "editor": city1928 }, { "colIndex": 6, "sortable": true, "header": "Region", "editable": true, "tooltip": "(contacts.Partners.region) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "region", "editor": region1929 }, { "colIndex": 7, "sortable": true, "header": "Postleitzahl", "editable": true, "tooltip": "(contacts.Partners.zip_code) ", "filter": { "type": "string" }, "width": Lino.chars2width(12), "dataIndex": "zip_code", "editor": zip_code1930 }, { "colIndex": 8, "sortable": true, "header": "Adresszeile vor Stra\u00dfe", "editable": true, "tooltip": "(contacts.Partners.addr1) Address line before street", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "addr1", "editor": addr11931 }, { "colIndex": 9, "sortable": true, "header": "Pr\u00e4fix Stra\u00dfe", "editable": true, "tooltip": "(contacts.Partners.street_prefix) Text to print before name of street, but to ignore for sorting.", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "street_prefix", "editor": street_prefix1932 }, { "colIndex": 10, "sortable": true, "header": "Stra\u00dfe", "editable": true, "tooltip": "(contacts.Partners.street) Name of street. Without house number.", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "street", "editor": street1933 }, { "colIndex": 11, "sortable": true, "header": "Nr.", "editable": true, "tooltip": "(contacts.Partners.street_no) House number", "filter": { "type": "string" }, "width": Lino.chars2width(12), "dataIndex": "street_no", "editor": street_no1934 }, { "colIndex": 12, "sortable": true, "header": "Box", "editable": true, "tooltip": "(contacts.Partners.street_box) Text to print after :attr:`steet_no` on the same line", "filter": { "type": "string" }, "width": Lino.chars2width(12), "dataIndex": "street_box", "editor": street_box1935 }, { "colIndex": 13, "sortable": true, "header": "Adresszeile nach Stra\u00dfe", "editable": true, "tooltip": "(contacts.Partners.addr2) Address line to print below street line", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "addr2", "editor": addr21936 }, { "colIndex": 14, "sortable": true, "header": "Sprache", "editable": true, "tooltip": "(contacts.Partners.language) Die Sprache, in der Dokumente ausgestellt werden sollen.", "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "language", "editor": language1937 }, { "colIndex": 15, "sortable": true, "header": "URL", "editable": true, "tooltip": "(contacts.Partners.url) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "url", "editor": url1938 }, { "colIndex": 16, "sortable": true, "header": "Telefon", "editable": true, "tooltip": "(contacts.Partners.phone) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "phone", "editor": phone1939 }, { "colIndex": 17, "sortable": true, "header": "GSM", "editable": true, "tooltip": "(contacts.Partners.gsm) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "gsm", "editor": gsm1940 }, { "colIndex": 18, "sortable": true, "header": "Fax", "editable": true, "tooltip": "(contacts.Partners.fax) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "fax", "editor": fax1941 }, { "colIndex": 19, "sortable": false, "header": "Bemerkungen", "editable": true, "tooltip": "(contacts.Partners.remarks) ", "filter": { "type": "string" }, "width": Lino.chars2width(61), "renderer": Lino.text_renderer, "editor": remarks1942, "dataIndex": "remarks" }, { "colIndex": 20, "sortable": false, "xtype": "checkcolumn", "header": "veraltet", "editable": true, "tooltip": "(contacts.Partners.is_obsolete) Altf\u00e4lle sind Partner, deren Stammdaten nicht mehr gepflegt werden und \nf\u00fcr neue Operationen nicht benutzt werden k\u00f6nnen.", "filter": { "type": "boolean" }, "width": Lino.chars2width(11), "dataIndex": "is_obsolete" }, { "colIndex": 21, "sortable": true, "header": "Beruf", "editable": true, "tooltip": "(contacts.Partners.activity) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "activity", "hidden": true, "editor": activity1944 }, { "colIndex": 22, "sortable": true, "header": "Bankkonto 1", "editable": true, "tooltip": "(contacts.Partners.bank_account1) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "bank_account1", "hidden": true, "editor": bank_account11945 }, { "colIndex": 23, "sortable": true, "header": "Bankkonto 2", "editable": true, "tooltip": "(contacts.Partners.bank_account2) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "bank_account2", "hidden": true, "editor": bank_account21946 }, new Lino.NullNumberColumn({ "colIndex": 24, "sortable": true, "format": "0", "editable": true, "tooltip": "(contacts.Partners.id) ", "filter": { "type": "numeric" }, "header": "ID", "renderer": Lino.id_renderer, "editor": id1947, "width": Lino.chars2width(6), "dataIndex": "id" }) ];
    Lino.contacts.Partners.GridPanel.superclass.initComponent.call(this);
  }
});


Lino.contacts.Partners.insertPanel = Ext.extend(Lino.contacts.Partners.InsertFormPanel,{
  empty_title: "Neu Partner",
  hide_navigator: true,
  ls_bbar_actions: [ { "itemId": "post", "menu_item_text": "Erstellen", "tooltip": "Datensatz erstellen und dann im Detail-Fenster \u00f6ffnen", "panel_btn_handler": function(panel){panel.save(null,true,'post')}, "text": "Erstellen", "overflowText": "Erstellen", "auto_save": false }, { "itemId": "poststay", "menu_item_text": "Erstellen ohne Detail", "tooltip": "Nach Erstellen des Datensatzes kein Detail-Fenster \u00f6ffnen", "panel_btn_handler": function(panel){panel.save(null,false,'poststay')}, "text": "Erstellen ohne Detail", "overflowText": "Erstellen ohne Detail", "auto_save": false } ],
  ls_url: "/contacts/Partners",
  action_name: "insert",
  initComponent : function() {
    this.ls_detail_handler = Lino.contacts.Partners.detail;
    this.ls_insert_handler = Lino.contacts.Partners.insert;
    Lino.contacts.Partners.insertPanel.superclass.initComponent.call(this);
  }
});

Lino.contacts.Partners.insert = new Lino.WindowAction({ "draggable": true, "width": Lino.chars2width(40), "autoHeight": true, "maximizable": true, "modal": true, "maximized": false },function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.contacts.Partners.insertPanel(p);
});

Lino.contacts.Partners.detailPanel = Ext.extend(Lino.contacts.Partners.DetailFormPanel,{
  empty_title: "Detail Partner",
  ls_bbar_actions: [ { "itemId": "put", "menu_item_text": "Speichern", "tooltip": "\u00c4nderungen in diesem Formular speichern", "panel_btn_handler": function(panel){panel.save(null,false,'put')}, "iconCls": "x-tbar-save", "overflowText": "Speichern", "auto_save": false }, { "itemId": "insert", "menu_item_text": "Neu", "must_save": true, "tooltip": "Neuen Datensatz erstellen", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-new", "overflowText": "Neu", "auto_save": true }, { "itemId": null, "menu_item_text": "L\u00f6schen", "tooltip": "Diesen Datensatz l\u00f6schen", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "L\u00f6schen", "auto_save": false } ],
  ls_url: "/contacts/Partners",
  action_name: "detail",
  initComponent : function() {
    this.ls_detail_handler = Lino.contacts.Partners.detail;
    this.ls_insert_handler = Lino.contacts.Partners.insert;
    Lino.contacts.Partners.detailPanel.superclass.initComponent.call(this);
  }
});

Lino.contacts.Partners.detail = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.contacts.Partners.detailPanel(p);
});
Lino.contacts.Partners.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.contacts.Partners.GridPanel(p);
});

// js_render_GridPanel_class contacts.Companies
Lino.contacts.Companies.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "Keine Daten anzuzeigen." },
  ls_url : "/contacts/Companies",
  ls_bbar_actions : [ { "itemId": "insert", "menu_item_text": "Neu", "must_save": true, "tooltip": "Neuen Datensatz erstellen", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-new", "overflowText": "Neu", "auto_save": true }, { "itemId": "detail", "menu_item_text": "Detail", "tooltip": "Detail-Fenster auf diesem Datensatz \u00f6ffnen", "panel_btn_handler": Lino.show_detail, "iconCls": "x-tbar-detail", "overflowText": "Detail", "auto_save": true }, { "itemId": null, "menu_item_text": "L\u00f6schen", "tooltip": "Diesen Datensatz l\u00f6schen", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "L\u00f6schen", "auto_save": false } ],
  title : "Organisationen",
  page_length : 20,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "name": "name" }, { "name": "email" }, { "name": "created" }, { "name": "modified" }, { "name": "country" }, 'countryHidden', { "name": "city" }, 'cityHidden', { "name": "region" }, 'regionHidden', { "name": "zip_code" }, { "name": "addr1" }, { "name": "street_prefix" }, { "name": "street" }, { "name": "street_no" }, { "name": "street_box" }, { "name": "addr2" }, { "name": "language" }, 'languageHidden', { "name": "url" }, { "name": "phone" }, { "name": "gsm" }, { "name": "fax" }, { "name": "remarks" }, { "type": "boolean", "name": "is_obsolete" }, { "name": "activity" }, 'activityHidden', { "name": "bank_account1" }, { "name": "bank_account2" }, { "name": "prefix" }, { "name": "vat_id" }, { "name": "type" }, 'typeHidden', { "name": "client_contact_type" }, 'client_contact_typeHidden', { "type": "int", "name": "id" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 35,
  ls_grid_configs : [  ],
  content_type : 20,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 37,
  initComponent : function() {
    this.ls_detail_handler = Lino.contacts.Companies.detail;
    this.ls_insert_handler = Lino.contacts.Companies.insert;
    var ww = this.containing_window;
    var name1949 = new Ext.form.TextField({ "selectOnFocus": true, "allowBlank": false, "maxLength": 200 });
    var email1950 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 75 });
    var created1951 = new Ext.form.DisplayField({ "disabled": true, "value": "<br>" });
    var modified1952 = new Ext.form.DisplayField({ "disabled": true, "value": "<br>" });
    var country1953 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/contacts/Companies/country", "method": "GET" }) }), "pageSize": 20, "emptyText": "Land ausw\u00e4hlen..." });
    var city1954 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "forceSelection": false, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/contacts/Companies/city", "method": "GET" }) }), "pageSize": 20, "emptyText": "Ort ausw\u00e4hlen..." });
    var region1955 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/contacts/Companies/region", "method": "GET" }) }), "pageSize": 20, "emptyText": "Ort ausw\u00e4hlen..." });
    var zip_code1956 = new Ext.form.TextField({ "selectOnFocus": true, "boxMinWidth": Lino.chars2width(10), "maxLength": 10 });
    var addr11957 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var street_prefix1958 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var street1959 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var street_no1960 = new Ext.form.TextField({ "selectOnFocus": true, "boxMinWidth": Lino.chars2width(10), "maxLength": 10 });
    var street_box1961 = new Ext.form.TextField({ "selectOnFocus": true, "boxMinWidth": Lino.chars2width(10), "maxLength": 10 });
    var addr21962 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var language1963 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "store": [ [ "de", "Deutsch" ], [ "fr", "Franz\u00f6sisch" ], [ "nl", "Niederl\u00e4ndisch" ] ], "allowBlank": false, "value": "de" });
    var url1964 = new Lino.URLField({ "selectOnFocus": true, "maxLength": 200 });
    var phone1965 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var gsm1966 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var fax1967 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var remarks1968 = new Ext.form.TextArea({ "selectOnFocus": true, "growMax": 2000 });
    var is_obsolete1969 = new Ext.form.Checkbox({ "selectOnFocus": true, "checked": false });
    var activity1970 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/contacts/Companies/activity", "method": "GET" }) }), "pageSize": 20, "emptyText": "Beruf ausw\u00e4hlen..." });
    var bank_account11971 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 40 });
    var bank_account21972 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 40 });
    var prefix1973 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var vat_id1974 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var type1975 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/contacts/Companies/type", "method": "GET" }) }), "pageSize": 20, "emptyText": "Organisationsart ausw\u00e4hlen..." });
    var client_contact_type1976 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/contacts/Companies/client_contact_type", "method": "GET" }) }), "pageSize": 20, "emptyText": "Klientenkontaktart ausw\u00e4hlen..." });
    var id1977 = new Ext.form.NumberField({ "selectOnFocus": true });
    this.before_row_edit = function(record) {
      city1954.setContextValue('country',record ? record.data['countryHidden'] : undefined);
      city1954.setContextValue('region',record ? record.data['regionHidden'] : undefined);
      region1955.setContextValue('country',record ? record.data['countryHidden'] : undefined);
    };
    this.onRender = function(ct, position) {
      country1953.on('change',Lino.chooser_handler(city1954,'country'));
      region1955.on('change',Lino.chooser_handler(city1954,'region'));
      country1953.on('change',Lino.chooser_handler(region1955,'country'));
      Lino.contacts.Companies.GridPanel.superclass.onRender.call(this, ct, position);
    }
    this.ls_columns = [ { "colIndex": 0, "sortable": true, "header": "Name", "editable": true, "tooltip": "(contacts.Companies.name) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "name", "editor": name1949 }, { "colIndex": 1, "sortable": true, "header": "E-Mail", "editable": true, "tooltip": "(contacts.Companies.email) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "email", "editor": email1950 }, { "colIndex": 2, "sortable": true, "header": "Erstellt", "editable": false, "tooltip": "(contacts.Companies.created) ", "width": Lino.chars2width(17), "dataIndex": "created", "hidden": true }, { "colIndex": 3, "sortable": true, "header": "Bearbeitet", "editable": false, "tooltip": "(contacts.Companies.modified) ", "width": Lino.chars2width(17), "dataIndex": "modified", "hidden": true }, { "colIndex": 4, "sortable": true, "header": "Land", "editable": true, "tooltip": "(contacts.Companies.country) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('countryHidden','Lino.countries.Countries.detail'), "editor": country1953, "dataIndex": "country" }, { "colIndex": 5, "sortable": true, "header": "Ort", "editable": true, "tooltip": "(contacts.Companies.city) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "city", "editor": city1954 }, { "colIndex": 6, "sortable": true, "header": "Region", "editable": true, "tooltip": "(contacts.Companies.region) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "region", "editor": region1955 }, { "colIndex": 7, "sortable": true, "header": "Postleitzahl", "editable": true, "tooltip": "(contacts.Companies.zip_code) ", "filter": { "type": "string" }, "width": Lino.chars2width(12), "dataIndex": "zip_code", "editor": zip_code1956 }, { "colIndex": 8, "sortable": true, "header": "Adresszeile vor Stra\u00dfe", "editable": true, "tooltip": "(contacts.Companies.addr1) Address line before street", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "addr1", "editor": addr11957 }, { "colIndex": 9, "sortable": true, "header": "Pr\u00e4fix Stra\u00dfe", "editable": true, "tooltip": "(contacts.Companies.street_prefix) Text to print before name of street, but to ignore for sorting.", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "street_prefix", "editor": street_prefix1958 }, { "colIndex": 10, "sortable": true, "header": "Stra\u00dfe", "editable": true, "tooltip": "(contacts.Companies.street) Name of street. Without house number.", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "street", "editor": street1959 }, { "colIndex": 11, "sortable": true, "header": "Nr.", "editable": true, "tooltip": "(contacts.Companies.street_no) House number", "filter": { "type": "string" }, "width": Lino.chars2width(12), "dataIndex": "street_no", "editor": street_no1960 }, { "colIndex": 12, "sortable": true, "header": "Box", "editable": true, "tooltip": "(contacts.Companies.street_box) Text to print after :attr:`steet_no` on the same line", "filter": { "type": "string" }, "width": Lino.chars2width(12), "dataIndex": "street_box", "editor": street_box1961 }, { "colIndex": 13, "sortable": true, "header": "Adresszeile nach Stra\u00dfe", "editable": true, "tooltip": "(contacts.Companies.addr2) Address line to print below street line", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "addr2", "editor": addr21962 }, { "colIndex": 14, "sortable": true, "header": "Sprache", "editable": true, "tooltip": "(contacts.Companies.language) Die Sprache, in der Dokumente ausgestellt werden sollen.", "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "language", "editor": language1963 }, { "colIndex": 15, "sortable": true, "header": "URL", "editable": true, "tooltip": "(contacts.Companies.url) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "url", "editor": url1964 }, { "colIndex": 16, "sortable": true, "header": "Telefon", "editable": true, "tooltip": "(contacts.Companies.phone) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "phone", "editor": phone1965 }, { "colIndex": 17, "sortable": true, "header": "GSM", "editable": true, "tooltip": "(contacts.Companies.gsm) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "gsm", "editor": gsm1966 }, { "colIndex": 18, "sortable": true, "header": "Fax", "editable": true, "tooltip": "(contacts.Companies.fax) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "fax", "editor": fax1967 }, { "colIndex": 19, "sortable": false, "header": "Bemerkungen", "editable": true, "tooltip": "(contacts.Companies.remarks) ", "filter": { "type": "string" }, "width": Lino.chars2width(61), "renderer": Lino.text_renderer, "editor": remarks1968, "dataIndex": "remarks" }, { "colIndex": 20, "sortable": false, "xtype": "checkcolumn", "header": "veraltet", "editable": true, "tooltip": "(contacts.Companies.is_obsolete) Altf\u00e4lle sind Partner, deren Stammdaten nicht mehr gepflegt werden und \nf\u00fcr neue Operationen nicht benutzt werden k\u00f6nnen.", "filter": { "type": "boolean" }, "width": Lino.chars2width(11), "dataIndex": "is_obsolete" }, { "colIndex": 21, "sortable": true, "header": "Beruf", "editable": true, "tooltip": "(contacts.Companies.activity) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "activity", "hidden": true, "editor": activity1970 }, { "colIndex": 22, "sortable": true, "header": "Bankkonto 1", "editable": true, "tooltip": "(contacts.Companies.bank_account1) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "bank_account1", "hidden": true, "editor": bank_account11971 }, { "colIndex": 23, "sortable": true, "header": "Bankkonto 2", "editable": true, "tooltip": "(contacts.Companies.bank_account2) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "bank_account2", "hidden": true, "editor": bank_account21972 }, { "colIndex": 24, "sortable": true, "header": "prefix", "editable": true, "tooltip": "(contacts.Companies.prefix) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "prefix", "editor": prefix1973 }, { "colIndex": 25, "sortable": true, "header": "MWSt.-Nr.", "editable": true, "tooltip": "(contacts.Companies.vat_id) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "vat_id", "editor": vat_id1974 }, { "colIndex": 26, "sortable": true, "header": "Organisationsart", "editable": true, "tooltip": "(contacts.Companies.type) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "type", "editor": type1975 }, { "colIndex": 27, "sortable": true, "header": "Klientenkontaktart", "editable": true, "tooltip": "(contacts.Companies.client_contact_type) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "client_contact_type", "editor": client_contact_type1976 }, new Lino.NullNumberColumn({ "colIndex": 28, "sortable": true, "format": "0", "editable": true, "tooltip": "(contacts.Companies.id) ", "filter": { "type": "numeric" }, "header": "ID", "renderer": Lino.id_renderer, "editor": id1977, "width": Lino.chars2width(6), "dataIndex": "id" }) ];
    Lino.contacts.Companies.GridPanel.superclass.initComponent.call(this);
  }
});


Lino.contacts.Companies.insertPanel = Ext.extend(Lino.contacts.Companies.InsertFormPanel,{
  empty_title: "Neu Organisationen",
  hide_navigator: true,
  ls_bbar_actions: [ { "itemId": "post", "menu_item_text": "Erstellen", "tooltip": "Datensatz erstellen und dann im Detail-Fenster \u00f6ffnen", "panel_btn_handler": function(panel){panel.save(null,true,'post')}, "text": "Erstellen", "overflowText": "Erstellen", "auto_save": false }, { "itemId": "poststay", "menu_item_text": "Erstellen ohne Detail", "tooltip": "Nach Erstellen des Datensatzes kein Detail-Fenster \u00f6ffnen", "panel_btn_handler": function(panel){panel.save(null,false,'poststay')}, "text": "Erstellen ohne Detail", "overflowText": "Erstellen ohne Detail", "auto_save": false } ],
  ls_url: "/contacts/Companies",
  action_name: "insert",
  initComponent : function() {
    this.ls_detail_handler = Lino.contacts.Companies.detail;
    this.ls_insert_handler = Lino.contacts.Companies.insert;
    Lino.contacts.Companies.insertPanel.superclass.initComponent.call(this);
  }
});

Lino.contacts.Companies.insert = new Lino.WindowAction({ "draggable": true, "width": Lino.chars2width(60), "autoHeight": true, "maximizable": true, "modal": true, "maximized": false },function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.contacts.Companies.insertPanel(p);
});

Lino.contacts.Companies.detailPanel = Ext.extend(Lino.contacts.Companies.DetailFormPanel,{
  empty_title: "Detail Organisationen",
  ls_bbar_actions: [ { "itemId": "put", "menu_item_text": "Speichern", "tooltip": "\u00c4nderungen in diesem Formular speichern", "panel_btn_handler": function(panel){panel.save(null,false,'put')}, "iconCls": "x-tbar-save", "overflowText": "Speichern", "auto_save": false }, { "itemId": "insert", "menu_item_text": "Neu", "must_save": true, "tooltip": "Neuen Datensatz erstellen", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-new", "overflowText": "Neu", "auto_save": true }, { "itemId": null, "menu_item_text": "L\u00f6schen", "tooltip": "Diesen Datensatz l\u00f6schen", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "L\u00f6schen", "auto_save": false } ],
  ls_url: "/contacts/Companies",
  action_name: "detail",
  initComponent : function() {
    this.ls_detail_handler = Lino.contacts.Companies.detail;
    this.ls_insert_handler = Lino.contacts.Companies.insert;
    Lino.contacts.Companies.detailPanel.superclass.initComponent.call(this);
  }
});

Lino.contacts.Companies.detail = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.contacts.Companies.detailPanel(p);
});
Lino.contacts.Companies.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.contacts.Companies.GridPanel(p);
});

// js_render_GridPanel_class contacts.Persons
Lino.contacts.Persons.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "Keine Daten anzuzeigen." },
  ls_url : "/contacts/Persons",
  ls_bbar_actions : [ { "itemId": "insert", "menu_item_text": "Neu", "must_save": true, "tooltip": "Neuen Datensatz erstellen", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-new", "overflowText": "Neu", "auto_save": true }, { "itemId": "detail", "menu_item_text": "Detail", "tooltip": "Detail-Fenster auf diesem Datensatz \u00f6ffnen", "panel_btn_handler": Lino.show_detail, "iconCls": "x-tbar-detail", "overflowText": "Detail", "auto_save": true }, { "itemId": null, "menu_item_text": "L\u00f6schen", "tooltip": "Diesen Datensatz l\u00f6schen", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "L\u00f6schen", "auto_save": false }, { "itemId": "do_print", "menu_item_text": "Drucken", "must_save": true, "tooltip": "Drucken", "panel_btn_handler": Lino.row_action_handler('do_print','GET'), "iconCls": "x-tbar-print", "overflowText": "Drucken", "auto_save": true } ],
  title : "Personen",
  page_length : 20,
  params_panel_hidden : true,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "name": "name_column" }, { "name": "address_column" }, { "name": "email" }, { "name": "phone" }, { "name": "gsm" }, { "type": "int", "name": "id" }, { "name": "language" }, 'languageHidden', { "name": "created" }, { "name": "modified" }, { "name": "country" }, 'countryHidden', { "name": "city" }, 'cityHidden', { "name": "region" }, 'regionHidden', { "name": "zip_code" }, { "name": "name" }, { "name": "addr1" }, { "name": "street_prefix" }, { "name": "street" }, { "name": "street_no" }, { "name": "street_box" }, { "name": "addr2" }, { "name": "url" }, { "name": "fax" }, { "name": "remarks" }, { "type": "boolean", "name": "is_obsolete" }, { "name": "activity" }, 'activityHidden', { "name": "bank_account1" }, { "name": "bank_account2" }, { "name": "first_name" }, { "name": "last_name" }, { "name": "gender" }, 'genderHidden', { "name": "birth_date" }, { "name": "title" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 5,
  ls_grid_configs : [  ],
  content_type : 21,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 39,
  initComponent : function() {
    this.ls_detail_handler = Lino.contacts.Persons.detail;
    this.ls_insert_handler = Lino.contacts.Persons.insert;
    var ww = this.containing_window;
    var name_column_disp1979 = new Ext.form.DisplayField({ "disabled": true, "value": "<br/>", "always_enabled": true });
    var address_column_disp1980 = new Ext.form.DisplayField({ "disabled": true, "value": "<br/>", "always_enabled": true });
    var email1981 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 75 });
    var phone1982 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var gsm1983 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var id1984 = new Ext.form.NumberField({ "selectOnFocus": true });
    var language1985 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "store": [ [ "de", "Deutsch" ], [ "fr", "Franz\u00f6sisch" ], [ "nl", "Niederl\u00e4ndisch" ] ], "allowBlank": false, "value": "de" });
    var created1986 = new Ext.form.DisplayField({ "disabled": true, "value": "<br>" });
    var modified1987 = new Ext.form.DisplayField({ "disabled": true, "value": "<br>" });
    var country1988 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/contacts/Persons/country", "method": "GET" }) }), "pageSize": 20, "emptyText": "Land ausw\u00e4hlen..." });
    var city1989 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "forceSelection": false, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/contacts/Persons/city", "method": "GET" }) }), "pageSize": 20, "emptyText": "Ort ausw\u00e4hlen..." });
    var region1990 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/contacts/Persons/region", "method": "GET" }) }), "pageSize": 20, "emptyText": "Ort ausw\u00e4hlen..." });
    var zip_code1991 = new Ext.form.TextField({ "selectOnFocus": true, "boxMinWidth": Lino.chars2width(10), "maxLength": 10 });
    var name1992 = new Ext.form.TextField({ "selectOnFocus": true, "allowBlank": false, "maxLength": 200 });
    var addr11993 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var street_prefix1994 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var street1995 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var street_no1996 = new Ext.form.TextField({ "selectOnFocus": true, "boxMinWidth": Lino.chars2width(10), "maxLength": 10 });
    var street_box1997 = new Ext.form.TextField({ "selectOnFocus": true, "boxMinWidth": Lino.chars2width(10), "maxLength": 10 });
    var addr21998 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var url1999 = new Lino.URLField({ "selectOnFocus": true, "maxLength": 200 });
    var fax2000 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var remarks2001 = new Ext.form.TextArea({ "selectOnFocus": true, "growMax": 2000 });
    var is_obsolete2002 = new Ext.form.Checkbox({ "selectOnFocus": true, "checked": false });
    var activity2003 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/contacts/Persons/activity", "method": "GET" }) }), "pageSize": 20, "emptyText": "Beruf ausw\u00e4hlen..." });
    var bank_account12004 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 40 });
    var bank_account22005 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 40 });
    var first_name2006 = new Ext.form.TextField({ "selectOnFocus": true, "allowBlank": false, "maxLength": 200 });
    var last_name2007 = new Ext.form.TextField({ "selectOnFocus": true, "allowBlank": false, "maxLength": 200 });
    var gender2008 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "forceSelection": true, "store": [['','<br>']].concat(Lino.lino.Genders) });
    var birth_date2009 = new Lino.IncompleteDateField({ "selectOnFocus": true });
    var title2010 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    this.before_row_edit = function(record) {
      city1989.setContextValue('country',record ? record.data['countryHidden'] : undefined);
      city1989.setContextValue('region',record ? record.data['regionHidden'] : undefined);
      region1990.setContextValue('country',record ? record.data['countryHidden'] : undefined);
    };
    this.onRender = function(ct, position) {
      country1988.on('change',Lino.chooser_handler(city1989,'country'));
      region1990.on('change',Lino.chooser_handler(city1989,'region'));
      country1988.on('change',Lino.chooser_handler(region1990,'country'));
      Lino.contacts.Persons.GridPanel.superclass.onRender.call(this, ct, position);
    }
    this.ls_columns = [ { "width": Lino.chars2width(21), "colIndex": 0, "sortable": false, "dataIndex": "name_column", "header": "Name", "editable": false, "tooltip": "(contacts.Persons.name_column) " }, { "width": Lino.chars2width(31), "colIndex": 1, "sortable": false, "dataIndex": "address_column", "header": "Adresse", "editable": false, "tooltip": "(contacts.Persons.address_column) " }, { "colIndex": 2, "sortable": true, "header": "E-Mail", "editable": true, "tooltip": "(contacts.Persons.email) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "email", "editor": email1981 }, { "colIndex": 3, "sortable": true, "header": "Telefon", "editable": true, "tooltip": "(contacts.Persons.phone) ", "filter": { "type": "string" }, "width": Lino.chars2width(11), "dataIndex": "phone", "editor": phone1982 }, { "colIndex": 4, "sortable": true, "header": "GSM", "editable": true, "tooltip": "(contacts.Persons.gsm) ", "filter": { "type": "string" }, "width": Lino.chars2width(11), "dataIndex": "gsm", "editor": gsm1983 }, new Lino.NullNumberColumn({ "colIndex": 5, "sortable": true, "format": "0", "editable": true, "tooltip": "(contacts.Persons.id) ", "filter": { "type": "numeric" }, "header": "ID", "renderer": Lino.id_renderer, "editor": id1984, "width": Lino.chars2width(6), "dataIndex": "id" }), { "colIndex": 6, "sortable": true, "header": "Sprache", "editable": true, "tooltip": "(contacts.Persons.language) Die Sprache, in der Dokumente ausgestellt werden sollen.", "filter": { "type": "string" }, "width": Lino.chars2width(11), "dataIndex": "language", "editor": language1985 }, { "colIndex": 7, "sortable": true, "header": "Erstellt", "editable": false, "tooltip": "(contacts.Persons.created) ", "width": Lino.chars2width(17), "dataIndex": "created", "hidden": true }, { "colIndex": 8, "sortable": true, "header": "Bearbeitet", "editable": false, "tooltip": "(contacts.Persons.modified) ", "width": Lino.chars2width(17), "dataIndex": "modified", "hidden": true }, { "colIndex": 9, "sortable": true, "header": "Land", "editable": true, "tooltip": "(contacts.Persons.country) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('countryHidden','Lino.countries.Countries.detail'), "editor": country1988, "dataIndex": "country" }, { "colIndex": 10, "sortable": true, "header": "Ort", "editable": true, "tooltip": "(contacts.Persons.city) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "city", "editor": city1989 }, { "colIndex": 11, "sortable": true, "header": "Region", "editable": true, "tooltip": "(contacts.Persons.region) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "region", "editor": region1990 }, { "colIndex": 12, "sortable": true, "header": "Postleitzahl", "editable": true, "tooltip": "(contacts.Persons.zip_code) ", "filter": { "type": "string" }, "width": Lino.chars2width(12), "dataIndex": "zip_code", "editor": zip_code1991 }, { "colIndex": 13, "sortable": true, "header": "Name", "editable": true, "tooltip": "(contacts.Persons.name) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "name", "editor": name1992 }, { "colIndex": 14, "sortable": true, "header": "Adresszeile vor Stra\u00dfe", "editable": true, "tooltip": "(contacts.Persons.addr1) Address line before street", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "addr1", "editor": addr11993 }, { "colIndex": 15, "sortable": true, "header": "Pr\u00e4fix Stra\u00dfe", "editable": true, "tooltip": "(contacts.Persons.street_prefix) Text to print before name of street, but to ignore for sorting.", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "street_prefix", "editor": street_prefix1994 }, { "colIndex": 16, "sortable": true, "header": "Stra\u00dfe", "editable": true, "tooltip": "(contacts.Persons.street) Name of street. Without house number.", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "street", "editor": street1995 }, { "colIndex": 17, "sortable": true, "header": "Nr.", "editable": true, "tooltip": "(contacts.Persons.street_no) House number", "filter": { "type": "string" }, "width": Lino.chars2width(12), "dataIndex": "street_no", "editor": street_no1996 }, { "colIndex": 18, "sortable": true, "header": "Box", "editable": true, "tooltip": "(contacts.Persons.street_box) Text to print after :attr:`steet_no` on the same line", "filter": { "type": "string" }, "width": Lino.chars2width(12), "dataIndex": "street_box", "editor": street_box1997 }, { "colIndex": 19, "sortable": true, "header": "Adresszeile nach Stra\u00dfe", "editable": true, "tooltip": "(contacts.Persons.addr2) Address line to print below street line", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "addr2", "editor": addr21998 }, { "colIndex": 20, "sortable": true, "header": "URL", "editable": true, "tooltip": "(contacts.Persons.url) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "url", "editor": url1999 }, { "colIndex": 21, "sortable": true, "header": "Fax", "editable": true, "tooltip": "(contacts.Persons.fax) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "fax", "editor": fax2000 }, { "colIndex": 22, "sortable": false, "header": "Bemerkungen", "editable": true, "tooltip": "(contacts.Persons.remarks) ", "filter": { "type": "string" }, "width": Lino.chars2width(61), "renderer": Lino.text_renderer, "editor": remarks2001, "dataIndex": "remarks" }, { "colIndex": 23, "sortable": false, "xtype": "checkcolumn", "header": "veraltet", "editable": true, "tooltip": "(contacts.Persons.is_obsolete) Altf\u00e4lle sind Partner, deren Stammdaten nicht mehr gepflegt werden und \nf\u00fcr neue Operationen nicht benutzt werden k\u00f6nnen.", "filter": { "type": "boolean" }, "width": Lino.chars2width(11), "dataIndex": "is_obsolete" }, { "colIndex": 24, "sortable": true, "header": "Beruf", "editable": true, "tooltip": "(contacts.Persons.activity) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "activity", "hidden": true, "editor": activity2003 }, { "colIndex": 25, "sortable": true, "header": "Bankkonto 1", "editable": true, "tooltip": "(contacts.Persons.bank_account1) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "bank_account1", "hidden": true, "editor": bank_account12004 }, { "colIndex": 26, "sortable": true, "header": "Bankkonto 2", "editable": true, "tooltip": "(contacts.Persons.bank_account2) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "bank_account2", "hidden": true, "editor": bank_account22005 }, { "colIndex": 27, "sortable": true, "header": "Vorname", "editable": true, "tooltip": "(contacts.Persons.first_name) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "first_name", "editor": first_name2006 }, { "colIndex": 28, "sortable": true, "header": "Familienname", "editable": true, "tooltip": "(contacts.Persons.last_name) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "last_name", "editor": last_name2007 }, { "colIndex": 29, "sortable": true, "header": "Geschlecht", "editable": true, "tooltip": "(contacts.Persons.gender) ", "filter": { "type": "string" }, "width": Lino.chars2width(12), "dataIndex": "gender", "editor": gender2008 }, { "colIndex": 30, "sortable": true, "header": "Geburtsdatum", "editable": true, "tooltip": "(contacts.Persons.birth_date) Unkomplette Datumsangaben sind erlaubt, z.B. \"00.00.1980\" hei\u00dft \"irgendwann im Jahr 1980\", \"00.07.1980\" hei\u00dft \"im Juli 1980\"oder \"23.07.0000\" hei\u00dft \"an einem 23. Juli\".", "filter": { "type": "string" }, "width": Lino.chars2width(13), "dataIndex": "birth_date", "editor": birth_date2009 }, { "colIndex": 31, "sortable": true, "header": "Anrede", "editable": true, "tooltip": "(contacts.Persons.title) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "title", "editor": title2010 } ];
    Lino.contacts.Persons.GridPanel.superclass.initComponent.call(this);
  }
});


Lino.contacts.Persons.insertPanel = Ext.extend(Lino.contacts.Persons.InsertFormPanel,{
  empty_title: "Neu Personen",
  hide_navigator: true,
  params_panel_hidden: true,
  ls_bbar_actions: [ { "itemId": "post", "menu_item_text": "Erstellen", "tooltip": "Datensatz erstellen und dann im Detail-Fenster \u00f6ffnen", "panel_btn_handler": function(panel){panel.save(null,true,'post')}, "text": "Erstellen", "overflowText": "Erstellen", "auto_save": false }, { "itemId": "poststay", "menu_item_text": "Erstellen ohne Detail", "tooltip": "Nach Erstellen des Datensatzes kein Detail-Fenster \u00f6ffnen", "panel_btn_handler": function(panel){panel.save(null,false,'poststay')}, "text": "Erstellen ohne Detail", "overflowText": "Erstellen ohne Detail", "auto_save": false } ],
  ls_url: "/contacts/Persons",
  action_name: "insert",
  initComponent : function() {
    this.ls_detail_handler = Lino.contacts.Persons.detail;
    this.ls_insert_handler = Lino.contacts.Persons.insert;
    Lino.contacts.Persons.insertPanel.superclass.initComponent.call(this);
  }
});

Lino.contacts.Persons.insert = new Lino.WindowAction({ "draggable": true, "width": Lino.chars2width(60), "autoHeight": true, "maximizable": true, "modal": true, "maximized": false },function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.contacts.Persons.insertPanel(p);
});

Lino.contacts.Persons.detailPanel = Ext.extend(Lino.contacts.Persons.DetailFormPanel,{
  empty_title: "Detail Personen",
  params_panel_hidden: true,
  ls_bbar_actions: [ { "itemId": "put", "menu_item_text": "Speichern", "tooltip": "\u00c4nderungen in diesem Formular speichern", "panel_btn_handler": function(panel){panel.save(null,false,'put')}, "iconCls": "x-tbar-save", "overflowText": "Speichern", "auto_save": false }, { "itemId": "insert", "menu_item_text": "Neu", "must_save": true, "tooltip": "Neuen Datensatz erstellen", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-new", "overflowText": "Neu", "auto_save": true }, { "itemId": null, "menu_item_text": "L\u00f6schen", "tooltip": "Diesen Datensatz l\u00f6schen", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "L\u00f6schen", "auto_save": false }, { "itemId": "do_print", "menu_item_text": "Drucken", "must_save": true, "tooltip": "Drucken", "panel_btn_handler": Lino.row_action_handler('do_print','GET'), "iconCls": "x-tbar-print", "overflowText": "Drucken", "auto_save": true } ],
  ls_url: "/contacts/Persons",
  action_name: "detail",
  initComponent : function() {
    this.ls_detail_handler = Lino.contacts.Persons.detail;
    this.ls_insert_handler = Lino.contacts.Persons.insert;
    Lino.contacts.Persons.detailPanel.superclass.initComponent.call(this);
  }
});

Lino.contacts.Persons.detail = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.contacts.Persons.detailPanel(p);
});
Lino.contacts.Persons.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  p.params_panel = new Lino.contacts.Persons.ParamsPanel({});
  return new Lino.contacts.Persons.GridPanel(p);
});

// js_render_GridPanel_class reception.ExpectedGuests
Lino.reception.ExpectedGuests.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "Keine Daten anzuzeigen." },
  ls_url : "/reception/ExpectedGuests",
  ls_bbar_actions : [ { "itemId": "insert", "menu_item_text": "Neu", "must_save": true, "tooltip": "Neuen Datensatz erstellen", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-new", "overflowText": "Neu", "auto_save": true }, { "itemId": "duplicate", "menu_item_text": "Duplizieren", "must_save": true, "tooltip": "Duplizieren", "panel_btn_handler": Lino.row_action_handler('duplicate','GET'), "iconCls": "x-tbar-duplicate", "overflowText": "Duplizieren", "auto_save": true }, { "itemId": "detail", "menu_item_text": "Detail", "tooltip": "Detail-Fenster auf diesem Datensatz \u00f6ffnen", "panel_btn_handler": Lino.show_detail, "iconCls": "x-tbar-detail", "overflowText": "Detail", "auto_save": true }, { "itemId": null, "menu_item_text": "L\u00f6schen", "tooltip": "Diesen Datensatz l\u00f6schen", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "L\u00f6schen", "auto_save": false }, { "itemId": "do_print", "menu_item_text": "Drucken", "must_save": true, "tooltip": "Drucken", "panel_btn_handler": Lino.row_action_handler('do_print','GET'), "iconCls": "x-tbar-print", "overflowText": "Drucken", "auto_save": true }, { "itemId": "do_clear_cache", "menu_item_text": "Cache l\u00f6schen", "must_save": true, "tooltip": "Cache l\u00f6schen", "panel_btn_handler": Lino.row_action_handler('do_clear_cache','GET'), "iconCls": "x-tbar-clearcache", "overflowText": "Cache l\u00f6schen", "auto_save": true }, { "itemId": "create_mail", "menu_item_text": "per E-Mail", "must_save": true, "tooltip": "Create an email from this", "panel_btn_handler": Lino.row_action_handler('create_mail','GET'), "iconCls": "x-tbar-email_add", "overflowText": "per E-Mail", "auto_save": true } ],
  title : "Expected Guests",
  page_length : 20,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "name": "partner" }, 'partnerHidden', { "name": "event__user" }, 'event__userHidden', { "name": "event__summary" }, { "name": "workflow_buttons" }, { "type": "int", "name": "id" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 6,
  ls_grid_configs : [  ],
  content_type : 37,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 8,
  initComponent : function() {
    this.ls_detail_handler = Lino.reception.ExpectedGuests.detail;
    this.ls_insert_handler = Lino.reception.ExpectedGuests.insert;
    var ww = this.containing_window;
    var partner2012 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/reception/ExpectedGuests/partner", "method": "GET" }) }), "allowBlank": false, "pageSize": 20, "emptyText": "Partner ausw\u00e4hlen..." });
    var event__user2013 = new Lino.RemoteComboFieldElement({ "disabled": true, "store": new Lino.ComplexRemoteComboStore({  }), "pageSize": 20, "emptyText": "Benutzer ausw\u00e4hlen..." });
    var event__summary2014 = new Ext.form.TextField({ "disabled": true, "maxLength": 200 });
    var workflow_buttons_disp2015 = new Ext.form.DisplayField({ "disabled": true, "value": "<br/>", "always_enabled": true });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ { "colIndex": 0, "sortable": true, "header": "Partner", "editable": true, "tooltip": "(reception.ExpectedGuests.partner) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('partnerHidden','Lino.contacts.Partners.detail'), "editor": partner2012, "dataIndex": "partner" }, { "colIndex": 1, "sortable": true, "header": "Verantwortlicher", "editable": false, "tooltip": "(reception.ExpectedGuests.event__user) ", "filter": { "type": "string" }, "width": Lino.chars2width(16), "dataIndex": "event__user" }, { "colIndex": 2, "sortable": true, "header": "Kurzbeschreibung", "editable": false, "tooltip": "(reception.ExpectedGuests.event__summary) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "event__summary" }, { "width": Lino.chars2width(31), "colIndex": 3, "sortable": false, "dataIndex": "workflow_buttons", "header": "Arbeitsablauf", "editable": false, "tooltip": "(reception.ExpectedGuests.workflow_buttons) " } ];
    Lino.reception.ExpectedGuests.GridPanel.superclass.initComponent.call(this);
  }
});


Lino.reception.ExpectedGuests.insertPanel = Ext.extend(Lino.reception.ExpectedGuests.InsertFormPanel,{
  empty_title: "Neu Expected Guests",
  hide_navigator: true,
  ls_bbar_actions: [ { "itemId": "post", "menu_item_text": "Erstellen", "tooltip": "Datensatz erstellen und dann im Detail-Fenster \u00f6ffnen", "panel_btn_handler": function(panel){panel.save(null,true,'post')}, "text": "Erstellen", "overflowText": "Erstellen", "auto_save": false }, { "itemId": "poststay", "menu_item_text": "Erstellen ohne Detail", "tooltip": "Nach Erstellen des Datensatzes kein Detail-Fenster \u00f6ffnen", "panel_btn_handler": function(panel){panel.save(null,false,'poststay')}, "text": "Erstellen ohne Detail", "overflowText": "Erstellen ohne Detail", "auto_save": false } ],
  ls_url: "/reception/ExpectedGuests",
  action_name: "insert",
  initComponent : function() {
    this.ls_detail_handler = Lino.reception.ExpectedGuests.detail;
    this.ls_insert_handler = Lino.reception.ExpectedGuests.insert;
    Lino.reception.ExpectedGuests.insertPanel.superclass.initComponent.call(this);
  }
});

Lino.reception.ExpectedGuests.insert = new Lino.WindowAction({ "draggable": true, "width": Lino.chars2width(60), "autoHeight": true, "maximizable": true, "modal": true, "maximized": false },function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.reception.ExpectedGuests.insertPanel(p);
});
Lino.reception.ExpectedGuests.wf3 = function(rp,pk) { 
  Lino.run_row_action(rp,"/reception/ExpectedGuests",pk,"wf3");
};
Lino.reception.ExpectedGuests.wf4 = function(rp,pk) { 
  Lino.run_row_action(rp,"/reception/ExpectedGuests",pk,"wf4");
};

Lino.reception.ExpectedGuests.detailPanel = Ext.extend(Lino.reception.ExpectedGuests.DetailFormPanel,{
  empty_title: "Detail Expected Guests",
  ls_bbar_actions: [ { "itemId": "put", "menu_item_text": "Speichern", "tooltip": "\u00c4nderungen in diesem Formular speichern", "panel_btn_handler": function(panel){panel.save(null,false,'put')}, "iconCls": "x-tbar-save", "overflowText": "Speichern", "auto_save": false }, { "itemId": "insert", "menu_item_text": "Neu", "must_save": true, "tooltip": "Neuen Datensatz erstellen", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-new", "overflowText": "Neu", "auto_save": true }, { "itemId": "duplicate", "menu_item_text": "Duplizieren", "must_save": true, "tooltip": "Duplizieren", "panel_btn_handler": Lino.row_action_handler('duplicate','GET'), "iconCls": "x-tbar-duplicate", "overflowText": "Duplizieren", "auto_save": true }, { "itemId": null, "menu_item_text": "L\u00f6schen", "tooltip": "Diesen Datensatz l\u00f6schen", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "L\u00f6schen", "auto_save": false }, { "itemId": "do_print", "menu_item_text": "Drucken", "must_save": true, "tooltip": "Drucken", "panel_btn_handler": Lino.row_action_handler('do_print','GET'), "iconCls": "x-tbar-print", "overflowText": "Drucken", "auto_save": true }, { "itemId": "do_clear_cache", "menu_item_text": "Cache l\u00f6schen", "must_save": true, "tooltip": "Cache l\u00f6schen", "panel_btn_handler": Lino.row_action_handler('do_clear_cache','GET'), "iconCls": "x-tbar-clearcache", "overflowText": "Cache l\u00f6schen", "auto_save": true }, { "itemId": "create_mail", "menu_item_text": "per E-Mail", "must_save": true, "tooltip": "Create an email from this", "panel_btn_handler": Lino.row_action_handler('create_mail','GET'), "iconCls": "x-tbar-email_add", "overflowText": "per E-Mail", "auto_save": true } ],
  ls_url: "/reception/ExpectedGuests",
  action_name: "detail",
  initComponent : function() {
    this.ls_detail_handler = Lino.reception.ExpectedGuests.detail;
    this.ls_insert_handler = Lino.reception.ExpectedGuests.insert;
    Lino.reception.ExpectedGuests.detailPanel.superclass.initComponent.call(this);
  }
});

Lino.reception.ExpectedGuests.detail = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.reception.ExpectedGuests.detailPanel(p);
});
Lino.reception.ExpectedGuests.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.reception.ExpectedGuests.GridPanel(p);
});

// js_render_GridPanel_class reception.WaitingGuests
Lino.reception.WaitingGuests.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "Keine Daten anzuzeigen." },
  ls_url : "/reception/WaitingGuests",
  ls_bbar_actions : [ { "itemId": "insert", "menu_item_text": "Neu", "must_save": true, "tooltip": "Neuen Datensatz erstellen", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-new", "overflowText": "Neu", "auto_save": true }, { "itemId": "duplicate", "menu_item_text": "Duplizieren", "must_save": true, "tooltip": "Duplizieren", "panel_btn_handler": Lino.row_action_handler('duplicate','GET'), "iconCls": "x-tbar-duplicate", "overflowText": "Duplizieren", "auto_save": true }, { "itemId": "detail", "menu_item_text": "Detail", "tooltip": "Detail-Fenster auf diesem Datensatz \u00f6ffnen", "panel_btn_handler": Lino.show_detail, "iconCls": "x-tbar-detail", "overflowText": "Detail", "auto_save": true }, { "itemId": null, "menu_item_text": "L\u00f6schen", "tooltip": "Diesen Datensatz l\u00f6schen", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "L\u00f6schen", "auto_save": false }, { "itemId": "do_print", "menu_item_text": "Drucken", "must_save": true, "tooltip": "Drucken", "panel_btn_handler": Lino.row_action_handler('do_print','GET'), "iconCls": "x-tbar-print", "overflowText": "Drucken", "auto_save": true }, { "itemId": "do_clear_cache", "menu_item_text": "Cache l\u00f6schen", "must_save": true, "tooltip": "Cache l\u00f6schen", "panel_btn_handler": Lino.row_action_handler('do_clear_cache','GET'), "iconCls": "x-tbar-clearcache", "overflowText": "Cache l\u00f6schen", "auto_save": true }, { "itemId": "create_mail", "menu_item_text": "per E-Mail", "must_save": true, "tooltip": "Create an email from this", "panel_btn_handler": Lino.row_action_handler('create_mail','GET'), "iconCls": "x-tbar-email_add", "overflowText": "per E-Mail", "auto_save": true } ],
  title : "Waiting Guests",
  page_length : 20,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "name": "waiting_since" }, { "name": "partner" }, 'partnerHidden', { "name": "event__user" }, 'event__userHidden', { "name": "event__summary" }, { "name": "workflow_buttons" }, { "type": "int", "name": "id" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 7,
  ls_grid_configs : [  ],
  content_type : 37,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 9,
  initComponent : function() {
    this.ls_detail_handler = Lino.reception.WaitingGuests.detail;
    this.ls_insert_handler = Lino.reception.WaitingGuests.insert;
    var ww = this.containing_window;
    var waiting_since2017 = new Ext.form.DisplayField({ "disabled": true, "value": "<br>" });
    var partner2018 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/reception/WaitingGuests/partner", "method": "GET" }) }), "allowBlank": false, "pageSize": 20, "emptyText": "Partner ausw\u00e4hlen..." });
    var event__user2019 = new Lino.RemoteComboFieldElement({ "disabled": true, "store": new Lino.ComplexRemoteComboStore({  }), "pageSize": 20, "emptyText": "Benutzer ausw\u00e4hlen..." });
    var event__summary2020 = new Ext.form.TextField({ "disabled": true, "maxLength": 200 });
    var workflow_buttons_disp2021 = new Ext.form.DisplayField({ "disabled": true, "value": "<br/>", "always_enabled": true });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ { "width": Lino.chars2width(17), "colIndex": 0, "sortable": true, "dataIndex": "waiting_since", "header": "Waiting since", "editable": false, "tooltip": "(reception.WaitingGuests.waiting_since) Time when the visitor arrived (checked in)." }, { "colIndex": 1, "sortable": true, "header": "Partner", "editable": true, "tooltip": "(reception.WaitingGuests.partner) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('partnerHidden','Lino.contacts.Partners.detail'), "editor": partner2018, "dataIndex": "partner" }, { "colIndex": 2, "sortable": true, "header": "Verantwortlicher", "editable": false, "tooltip": "(reception.WaitingGuests.event__user) ", "filter": { "type": "string" }, "width": Lino.chars2width(16), "dataIndex": "event__user" }, { "colIndex": 3, "sortable": true, "header": "Kurzbeschreibung", "editable": false, "tooltip": "(reception.WaitingGuests.event__summary) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "event__summary" }, { "width": Lino.chars2width(31), "colIndex": 4, "sortable": false, "dataIndex": "workflow_buttons", "header": "Arbeitsablauf", "editable": false, "tooltip": "(reception.WaitingGuests.workflow_buttons) " } ];
    Lino.reception.WaitingGuests.GridPanel.superclass.initComponent.call(this);
  }
});


Lino.reception.WaitingGuests.insertPanel = Ext.extend(Lino.reception.ExpectedGuests.InsertFormPanel,{
  empty_title: "Neu Waiting Guests",
  hide_navigator: true,
  ls_bbar_actions: [ { "itemId": "post", "menu_item_text": "Erstellen", "tooltip": "Datensatz erstellen und dann im Detail-Fenster \u00f6ffnen", "panel_btn_handler": function(panel){panel.save(null,true,'post')}, "text": "Erstellen", "overflowText": "Erstellen", "auto_save": false }, { "itemId": "poststay", "menu_item_text": "Erstellen ohne Detail", "tooltip": "Nach Erstellen des Datensatzes kein Detail-Fenster \u00f6ffnen", "panel_btn_handler": function(panel){panel.save(null,false,'poststay')}, "text": "Erstellen ohne Detail", "overflowText": "Erstellen ohne Detail", "auto_save": false } ],
  ls_url: "/reception/WaitingGuests",
  action_name: "insert",
  initComponent : function() {
    this.ls_detail_handler = Lino.reception.WaitingGuests.detail;
    this.ls_insert_handler = Lino.reception.WaitingGuests.insert;
    Lino.reception.WaitingGuests.insertPanel.superclass.initComponent.call(this);
  }
});

Lino.reception.WaitingGuests.insert = new Lino.WindowAction({ "draggable": true, "width": Lino.chars2width(60), "autoHeight": true, "maximizable": true, "modal": true, "maximized": false },function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.reception.WaitingGuests.insertPanel(p);
});
Lino.reception.WaitingGuests.wf3 = function(rp,pk) { 
  Lino.run_row_action(rp,"/reception/WaitingGuests",pk,"wf3");
};
Lino.reception.WaitingGuests.wf4 = function(rp,pk) { 
  Lino.run_row_action(rp,"/reception/WaitingGuests",pk,"wf4");
};

Lino.reception.WaitingGuests.detailPanel = Ext.extend(Lino.reception.ExpectedGuests.DetailFormPanel,{
  empty_title: "Detail Waiting Guests",
  ls_bbar_actions: [ { "itemId": "put", "menu_item_text": "Speichern", "tooltip": "\u00c4nderungen in diesem Formular speichern", "panel_btn_handler": function(panel){panel.save(null,false,'put')}, "iconCls": "x-tbar-save", "overflowText": "Speichern", "auto_save": false }, { "itemId": "insert", "menu_item_text": "Neu", "must_save": true, "tooltip": "Neuen Datensatz erstellen", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-new", "overflowText": "Neu", "auto_save": true }, { "itemId": "duplicate", "menu_item_text": "Duplizieren", "must_save": true, "tooltip": "Duplizieren", "panel_btn_handler": Lino.row_action_handler('duplicate','GET'), "iconCls": "x-tbar-duplicate", "overflowText": "Duplizieren", "auto_save": true }, { "itemId": null, "menu_item_text": "L\u00f6schen", "tooltip": "Diesen Datensatz l\u00f6schen", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "L\u00f6schen", "auto_save": false }, { "itemId": "do_print", "menu_item_text": "Drucken", "must_save": true, "tooltip": "Drucken", "panel_btn_handler": Lino.row_action_handler('do_print','GET'), "iconCls": "x-tbar-print", "overflowText": "Drucken", "auto_save": true }, { "itemId": "do_clear_cache", "menu_item_text": "Cache l\u00f6schen", "must_save": true, "tooltip": "Cache l\u00f6schen", "panel_btn_handler": Lino.row_action_handler('do_clear_cache','GET'), "iconCls": "x-tbar-clearcache", "overflowText": "Cache l\u00f6schen", "auto_save": true }, { "itemId": "create_mail", "menu_item_text": "per E-Mail", "must_save": true, "tooltip": "Create an email from this", "panel_btn_handler": Lino.row_action_handler('create_mail','GET'), "iconCls": "x-tbar-email_add", "overflowText": "per E-Mail", "auto_save": true } ],
  ls_url: "/reception/WaitingGuests",
  action_name: "detail",
  initComponent : function() {
    this.ls_detail_handler = Lino.reception.WaitingGuests.detail;
    this.ls_insert_handler = Lino.reception.WaitingGuests.insert;
    Lino.reception.WaitingGuests.detailPanel.superclass.initComponent.call(this);
  }
});

Lino.reception.WaitingGuests.detail = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.reception.WaitingGuests.detailPanel(p);
});
Lino.reception.WaitingGuests.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.reception.WaitingGuests.GridPanel(p);
});

// js_render_GridPanel_class households.Households
Lino.households.Households.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "Keine Daten anzuzeigen." },
  ls_url : "/households/Households",
  ls_bbar_actions : [ { "itemId": "insert", "menu_item_text": "Neu", "must_save": true, "tooltip": "Neuen Datensatz erstellen", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-new", "overflowText": "Neu", "auto_save": true }, { "itemId": "detail", "menu_item_text": "Detail", "tooltip": "Detail-Fenster auf diesem Datensatz \u00f6ffnen", "panel_btn_handler": Lino.show_detail, "iconCls": "x-tbar-detail", "overflowText": "Detail", "auto_save": true }, { "itemId": null, "menu_item_text": "L\u00f6schen", "tooltip": "Diesen Datensatz l\u00f6schen", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "L\u00f6schen", "auto_save": false } ],
  title : "Haushalte",
  page_length : 20,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "name": "name" }, { "name": "email" }, { "name": "created" }, { "name": "modified" }, { "name": "country" }, 'countryHidden', { "name": "city" }, 'cityHidden', { "name": "region" }, 'regionHidden', { "name": "zip_code" }, { "name": "addr1" }, { "name": "street_prefix" }, { "name": "street" }, { "name": "street_no" }, { "name": "street_box" }, { "name": "addr2" }, { "name": "language" }, 'languageHidden', { "name": "url" }, { "name": "phone" }, { "name": "gsm" }, { "name": "fax" }, { "name": "remarks" }, { "type": "boolean", "name": "is_obsolete" }, { "name": "activity" }, 'activityHidden', { "name": "bank_account1" }, { "name": "bank_account2" }, { "name": "prefix" }, { "name": "type" }, 'typeHidden', { "type": "int", "name": "id" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 32,
  ls_grid_configs : [  ],
  content_type : 41,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 34,
  initComponent : function() {
    this.ls_detail_handler = Lino.households.Households.detail;
    this.ls_insert_handler = Lino.households.Households.insert;
    var ww = this.containing_window;
    var name2023 = new Ext.form.TextField({ "selectOnFocus": true, "allowBlank": false, "maxLength": 200 });
    var email2024 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 75 });
    var created2025 = new Ext.form.DisplayField({ "disabled": true, "value": "<br>" });
    var modified2026 = new Ext.form.DisplayField({ "disabled": true, "value": "<br>" });
    var country2027 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/households/Households/country", "method": "GET" }) }), "pageSize": 20, "emptyText": "Land ausw\u00e4hlen..." });
    var city2028 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "forceSelection": false, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/households/Households/city", "method": "GET" }) }), "pageSize": 20, "emptyText": "Ort ausw\u00e4hlen..." });
    var region2029 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/households/Households/region", "method": "GET" }) }), "pageSize": 20, "emptyText": "Ort ausw\u00e4hlen..." });
    var zip_code2030 = new Ext.form.TextField({ "selectOnFocus": true, "boxMinWidth": Lino.chars2width(10), "maxLength": 10 });
    var addr12031 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var street_prefix2032 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var street2033 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var street_no2034 = new Ext.form.TextField({ "selectOnFocus": true, "boxMinWidth": Lino.chars2width(10), "maxLength": 10 });
    var street_box2035 = new Ext.form.TextField({ "selectOnFocus": true, "boxMinWidth": Lino.chars2width(10), "maxLength": 10 });
    var addr22036 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var language2037 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "store": [ [ "de", "Deutsch" ], [ "fr", "Franz\u00f6sisch" ], [ "nl", "Niederl\u00e4ndisch" ] ], "allowBlank": false, "value": "de" });
    var url2038 = new Lino.URLField({ "selectOnFocus": true, "maxLength": 200 });
    var phone2039 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var gsm2040 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var fax2041 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var remarks2042 = new Ext.form.TextArea({ "selectOnFocus": true, "growMax": 2000 });
    var is_obsolete2043 = new Ext.form.Checkbox({ "selectOnFocus": true, "checked": false });
    var activity2044 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/households/Households/activity", "method": "GET" }) }), "pageSize": 20, "emptyText": "Beruf ausw\u00e4hlen..." });
    var bank_account12045 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 40 });
    var bank_account22046 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 40 });
    var prefix2047 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var type2048 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/households/Households/type", "method": "GET" }) }), "pageSize": 20, "emptyText": "Haushaltsart ausw\u00e4hlen..." });
    var id2049 = new Ext.form.NumberField({ "selectOnFocus": true });
    this.before_row_edit = function(record) {
      city2028.setContextValue('country',record ? record.data['countryHidden'] : undefined);
      city2028.setContextValue('region',record ? record.data['regionHidden'] : undefined);
      region2029.setContextValue('country',record ? record.data['countryHidden'] : undefined);
    };
    this.onRender = function(ct, position) {
      country2027.on('change',Lino.chooser_handler(city2028,'country'));
      region2029.on('change',Lino.chooser_handler(city2028,'region'));
      country2027.on('change',Lino.chooser_handler(region2029,'country'));
      Lino.households.Households.GridPanel.superclass.onRender.call(this, ct, position);
    }
    this.ls_columns = [ { "colIndex": 0, "sortable": true, "header": "Name", "editable": true, "tooltip": "(households.Households.name) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "name", "editor": name2023 }, { "colIndex": 1, "sortable": true, "header": "E-Mail", "editable": true, "tooltip": "(households.Households.email) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "email", "editor": email2024 }, { "colIndex": 2, "sortable": true, "header": "Erstellt", "editable": false, "tooltip": "(households.Households.created) ", "width": Lino.chars2width(17), "dataIndex": "created", "hidden": true }, { "colIndex": 3, "sortable": true, "header": "Bearbeitet", "editable": false, "tooltip": "(households.Households.modified) ", "width": Lino.chars2width(17), "dataIndex": "modified", "hidden": true }, { "colIndex": 4, "sortable": true, "header": "Land", "editable": true, "tooltip": "(households.Households.country) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('countryHidden','Lino.countries.Countries.detail'), "editor": country2027, "dataIndex": "country" }, { "colIndex": 5, "sortable": true, "header": "Ort", "editable": true, "tooltip": "(households.Households.city) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "city", "editor": city2028 }, { "colIndex": 6, "sortable": true, "header": "Region", "editable": true, "tooltip": "(households.Households.region) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "region", "editor": region2029 }, { "colIndex": 7, "sortable": true, "header": "Postleitzahl", "editable": true, "tooltip": "(households.Households.zip_code) ", "filter": { "type": "string" }, "width": Lino.chars2width(12), "dataIndex": "zip_code", "editor": zip_code2030 }, { "colIndex": 8, "sortable": true, "header": "Adresszeile vor Stra\u00dfe", "editable": true, "tooltip": "(households.Households.addr1) Address line before street", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "addr1", "editor": addr12031 }, { "colIndex": 9, "sortable": true, "header": "Pr\u00e4fix Stra\u00dfe", "editable": true, "tooltip": "(households.Households.street_prefix) Text to print before name of street, but to ignore for sorting.", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "street_prefix", "editor": street_prefix2032 }, { "colIndex": 10, "sortable": true, "header": "Stra\u00dfe", "editable": true, "tooltip": "(households.Households.street) Name of street. Without house number.", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "street", "editor": street2033 }, { "colIndex": 11, "sortable": true, "header": "Nr.", "editable": true, "tooltip": "(households.Households.street_no) House number", "filter": { "type": "string" }, "width": Lino.chars2width(12), "dataIndex": "street_no", "editor": street_no2034 }, { "colIndex": 12, "sortable": true, "header": "Box", "editable": true, "tooltip": "(households.Households.street_box) Text to print after :attr:`steet_no` on the same line", "filter": { "type": "string" }, "width": Lino.chars2width(12), "dataIndex": "street_box", "editor": street_box2035 }, { "colIndex": 13, "sortable": true, "header": "Adresszeile nach Stra\u00dfe", "editable": true, "tooltip": "(households.Households.addr2) Address line to print below street line", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "addr2", "editor": addr22036 }, { "colIndex": 14, "sortable": true, "header": "Sprache", "editable": true, "tooltip": "(households.Households.language) Die Sprache, in der Dokumente ausgestellt werden sollen.", "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "language", "editor": language2037 }, { "colIndex": 15, "sortable": true, "header": "URL", "editable": true, "tooltip": "(households.Households.url) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "url", "editor": url2038 }, { "colIndex": 16, "sortable": true, "header": "Telefon", "editable": true, "tooltip": "(households.Households.phone) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "phone", "editor": phone2039 }, { "colIndex": 17, "sortable": true, "header": "GSM", "editable": true, "tooltip": "(households.Households.gsm) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "gsm", "editor": gsm2040 }, { "colIndex": 18, "sortable": true, "header": "Fax", "editable": true, "tooltip": "(households.Households.fax) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "fax", "editor": fax2041 }, { "colIndex": 19, "sortable": false, "header": "Bemerkungen", "editable": true, "tooltip": "(households.Households.remarks) ", "filter": { "type": "string" }, "width": Lino.chars2width(61), "renderer": Lino.text_renderer, "editor": remarks2042, "dataIndex": "remarks" }, { "colIndex": 20, "sortable": false, "xtype": "checkcolumn", "header": "veraltet", "editable": true, "tooltip": "(households.Households.is_obsolete) Altf\u00e4lle sind Partner, deren Stammdaten nicht mehr gepflegt werden und \nf\u00fcr neue Operationen nicht benutzt werden k\u00f6nnen.", "filter": { "type": "boolean" }, "width": Lino.chars2width(11), "dataIndex": "is_obsolete" }, { "colIndex": 21, "sortable": true, "header": "Beruf", "editable": true, "tooltip": "(households.Households.activity) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "activity", "hidden": true, "editor": activity2044 }, { "colIndex": 22, "sortable": true, "header": "Bankkonto 1", "editable": true, "tooltip": "(households.Households.bank_account1) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "bank_account1", "hidden": true, "editor": bank_account12045 }, { "colIndex": 23, "sortable": true, "header": "Bankkonto 2", "editable": true, "tooltip": "(households.Households.bank_account2) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "bank_account2", "hidden": true, "editor": bank_account22046 }, { "colIndex": 24, "sortable": true, "header": "prefix", "editable": true, "tooltip": "(households.Households.prefix) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "prefix", "editor": prefix2047 }, { "colIndex": 25, "sortable": true, "header": "Haushaltsart", "editable": true, "tooltip": "(households.Households.type) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "type", "editor": type2048 }, new Lino.NullNumberColumn({ "colIndex": 26, "sortable": true, "format": "0", "editable": true, "tooltip": "(households.Households.id) ", "filter": { "type": "numeric" }, "header": "ID", "renderer": Lino.id_renderer, "editor": id2049, "width": Lino.chars2width(6), "dataIndex": "id" }) ];
    Lino.households.Households.GridPanel.superclass.initComponent.call(this);
  }
});


Lino.households.Households.insertPanel = Ext.extend(Lino.contacts.Partners.InsertFormPanel,{
  empty_title: "Neu Haushalte",
  hide_navigator: true,
  ls_bbar_actions: [ { "itemId": "post", "menu_item_text": "Erstellen", "tooltip": "Datensatz erstellen und dann im Detail-Fenster \u00f6ffnen", "panel_btn_handler": function(panel){panel.save(null,true,'post')}, "text": "Erstellen", "overflowText": "Erstellen", "auto_save": false }, { "itemId": "poststay", "menu_item_text": "Erstellen ohne Detail", "tooltip": "Nach Erstellen des Datensatzes kein Detail-Fenster \u00f6ffnen", "panel_btn_handler": function(panel){panel.save(null,false,'poststay')}, "text": "Erstellen ohne Detail", "overflowText": "Erstellen ohne Detail", "auto_save": false } ],
  ls_url: "/households/Households",
  action_name: "insert",
  initComponent : function() {
    this.ls_detail_handler = Lino.households.Households.detail;
    this.ls_insert_handler = Lino.households.Households.insert;
    Lino.households.Households.insertPanel.superclass.initComponent.call(this);
  }
});

Lino.households.Households.insert = new Lino.WindowAction({ "draggable": true, "width": Lino.chars2width(40), "autoHeight": true, "maximizable": true, "modal": true, "maximized": false },function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.households.Households.insertPanel(p);
});

Lino.households.Households.detailPanel = Ext.extend(Lino.households.Households.DetailFormPanel,{
  empty_title: "Detail Haushalte",
  ls_bbar_actions: [ { "itemId": "put", "menu_item_text": "Speichern", "tooltip": "\u00c4nderungen in diesem Formular speichern", "panel_btn_handler": function(panel){panel.save(null,false,'put')}, "iconCls": "x-tbar-save", "overflowText": "Speichern", "auto_save": false }, { "itemId": "insert", "menu_item_text": "Neu", "must_save": true, "tooltip": "Neuen Datensatz erstellen", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-new", "overflowText": "Neu", "auto_save": true }, { "itemId": null, "menu_item_text": "L\u00f6schen", "tooltip": "Diesen Datensatz l\u00f6schen", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "L\u00f6schen", "auto_save": false } ],
  ls_url: "/households/Households",
  action_name: "detail",
  initComponent : function() {
    this.ls_detail_handler = Lino.households.Households.detail;
    this.ls_insert_handler = Lino.households.Households.insert;
    Lino.households.Households.detailPanel.superclass.initComponent.call(this);
  }
});

Lino.households.Households.detail = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.households.Households.detailPanel(p);
});
Lino.households.Households.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.households.Households.GridPanel(p);
});

// js_render_GridPanel_class pcsw.Clients
Lino.pcsw.Clients.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "Keine Daten anzuzeigen." },
  ls_url : "/pcsw/Clients",
  ls_bbar_actions : [ { "itemId": "insert", "menu_item_text": "Neu", "must_save": true, "tooltip": "Neuen Datensatz erstellen", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-new", "overflowText": "Neu", "auto_save": true }, { "itemId": "detail", "menu_item_text": "Detail", "tooltip": "Detail-Fenster auf diesem Datensatz \u00f6ffnen", "panel_btn_handler": Lino.show_detail, "iconCls": "x-tbar-detail", "overflowText": "Detail", "auto_save": true }, { "itemId": null, "menu_item_text": "L\u00f6schen", "tooltip": "Diesen Datensatz l\u00f6schen", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "L\u00f6schen", "auto_save": false }, { "itemId": "do_print", "menu_item_text": "Drucken", "must_save": true, "tooltip": "Drucken", "panel_btn_handler": Lino.row_action_handler('do_print','GET'), "iconCls": "x-tbar-print", "overflowText": "Drucken", "auto_save": true }, { "itemId": "print_eid_content", "menu_item_text": "eID-Inhalt", "must_save": true, "tooltip": "eID-Inhalt", "panel_btn_handler": Lino.row_action_handler('print_eid_content','GET'), "iconCls": "x-tbar-vcard", "overflowText": "eID-Inhalt", "auto_save": true } ],
  title : "Klienten",
  page_length : 20,
  params_panel_hidden : true,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "name": "name_column" }, { "name": "client_state" }, 'client_stateHidden', { "name": "national_id" }, { "name": "gsm" }, { "name": "address_column" }, { "name": "age" }, { "name": "email" }, { "name": "phone" }, { "type": "int", "name": "id" }, { "name": "bank_account1" }, { "name": "aid_type" }, 'aid_typeHidden', { "name": "language" }, 'languageHidden', { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 9,
  ls_grid_configs : [  ],
  content_type : 53,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 16,
  initComponent : function() {
    this.ls_detail_handler = Lino.pcsw.Clients.detail;
    this.ls_insert_handler = Lino.pcsw.Clients.insert;
    var ww = this.containing_window;
    var name_column_disp2051 = new Ext.form.DisplayField({ "disabled": true, "value": "<br/>", "always_enabled": true });
    var client_state2052 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "forceSelection": true, "allowBlank": false, "store": Lino.pcsw.ClientStates });
    var national_id2053 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var gsm2054 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var address_column_disp2055 = new Ext.form.DisplayField({ "disabled": true, "value": "<br/>", "always_enabled": true });
    var age_disp2056 = new Ext.form.DisplayField({ "disabled": true, "value": "<br/>", "always_enabled": true });
    var email2057 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 75 });
    var phone2058 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var id2059 = new Ext.form.NumberField({ "selectOnFocus": true });
    var bank_account12060 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 40 });
    var aid_type2061 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/pcsw/Clients/aid_type", "method": "GET" }) }), "pageSize": 20, "emptyText": "Sozialhilfeart ausw\u00e4hlen..." });
    var language2062 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "store": [ [ "de", "Deutsch" ], [ "fr", "Franz\u00f6sisch" ], [ "nl", "Niederl\u00e4ndisch" ] ], "allowBlank": false, "value": "de" });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ { "width": Lino.chars2width(21), "colIndex": 0, "sortable": false, "dataIndex": "name_column", "header": "Name", "editable": false, "tooltip": "(pcsw.Clients.name_column) " }, { "colIndex": 1, "sortable": true, "header": "Zustand", "editable": true, "tooltip": "(pcsw.Clients.client_state) ", "filter": { "type": "string" }, "width": Lino.chars2width(13), "dataIndex": "client_state", "editor": client_state2052 }, { "colIndex": 2, "sortable": true, "header": "NR-Nummer", "editable": true, "tooltip": "(pcsw.Clients.national_id) ", "filter": { "type": "string" }, "width": Lino.chars2width(11), "dataIndex": "national_id", "editor": national_id2053 }, { "colIndex": 3, "sortable": true, "header": "GSM", "editable": true, "tooltip": "(pcsw.Clients.gsm) ", "filter": { "type": "string" }, "width": Lino.chars2width(11), "dataIndex": "gsm", "editor": gsm2054 }, { "width": Lino.chars2width(31), "colIndex": 4, "sortable": false, "dataIndex": "address_column", "header": "Adresse", "editable": false, "tooltip": "(pcsw.Clients.address_column) " }, { "width": Lino.chars2width(11), "colIndex": 5, "sortable": false, "dataIndex": "age", "header": "Alter", "editable": false, "tooltip": "(pcsw.Clients.age) " }, { "colIndex": 6, "sortable": true, "header": "E-Mail", "editable": true, "tooltip": "(pcsw.Clients.email) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "email", "editor": email2057 }, { "colIndex": 7, "sortable": true, "header": "Telefon", "editable": true, "tooltip": "(pcsw.Clients.phone) ", "filter": { "type": "string" }, "width": Lino.chars2width(11), "dataIndex": "phone", "editor": phone2058 }, new Lino.NullNumberColumn({ "colIndex": 8, "sortable": true, "format": "0", "editable": true, "tooltip": "(pcsw.Clients.id) ", "filter": { "type": "numeric" }, "header": "ID", "renderer": Lino.id_renderer, "editor": id2059, "width": Lino.chars2width(6), "dataIndex": "id" }), { "colIndex": 9, "sortable": true, "header": "Bankkonto 1", "editable": true, "tooltip": "(pcsw.Clients.bank_account1) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "bank_account1", "hidden": true, "editor": bank_account12060 }, { "colIndex": 10, "sortable": true, "header": "Sozialhilfeart", "editable": true, "tooltip": "(pcsw.Clients.aid_type) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "aid_type", "editor": aid_type2061 }, { "colIndex": 11, "sortable": true, "header": "Sprache", "editable": true, "tooltip": "(pcsw.Clients.language) Die Sprache, in der Dokumente ausgestellt werden sollen.", "filter": { "type": "string" }, "width": Lino.chars2width(11), "dataIndex": "language", "editor": language2062 } ];
    Lino.pcsw.Clients.GridPanel.superclass.initComponent.call(this);
  }
});


Lino.pcsw.Clients.insertPanel = Ext.extend(Lino.pcsw.Clients.InsertFormPanel,{
  empty_title: "Neu Klienten",
  hide_navigator: true,
  params_panel_hidden: true,
  ls_bbar_actions: [ { "itemId": "post", "menu_item_text": "Erstellen", "tooltip": "Datensatz erstellen und dann im Detail-Fenster \u00f6ffnen", "panel_btn_handler": function(panel){panel.save(null,true,'post')}, "text": "Erstellen", "overflowText": "Erstellen", "auto_save": false }, { "itemId": "poststay", "menu_item_text": "Erstellen ohne Detail", "tooltip": "Nach Erstellen des Datensatzes kein Detail-Fenster \u00f6ffnen", "panel_btn_handler": function(panel){panel.save(null,false,'poststay')}, "text": "Erstellen ohne Detail", "overflowText": "Erstellen ohne Detail", "auto_save": false } ],
  ls_url: "/pcsw/Clients",
  action_name: "insert",
  initComponent : function() {
    this.ls_detail_handler = Lino.pcsw.Clients.detail;
    this.ls_insert_handler = Lino.pcsw.Clients.insert;
    Lino.pcsw.Clients.insertPanel.superclass.initComponent.call(this);
  }
});

Lino.pcsw.Clients.insert = new Lino.WindowAction({ "draggable": true, "width": Lino.chars2width(60), "autoHeight": true, "maximizable": true, "modal": true, "maximized": false },function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.pcsw.Clients.insertPanel(p);
});
Lino.pcsw.Clients.wf1 = function(rp,pk) { 
  Lino.run_row_action(rp,"/pcsw/Clients",pk,"wf1");
};
Lino.pcsw.Clients.wf3 = function(rp,pk) { 
  Lino.run_row_action(rp,"/pcsw/Clients",pk,"wf3");
};

Lino.pcsw.Clients.detailPanel = Ext.extend(Lino.pcsw.Clients.DetailFormPanel,{
  empty_title: "Detail Klienten",
  params_panel_hidden: true,
  ls_bbar_actions: [ { "itemId": "put", "menu_item_text": "Speichern", "tooltip": "\u00c4nderungen in diesem Formular speichern", "panel_btn_handler": function(panel){panel.save(null,false,'put')}, "iconCls": "x-tbar-save", "overflowText": "Speichern", "auto_save": false }, { "itemId": "insert", "menu_item_text": "Neu", "must_save": true, "tooltip": "Neuen Datensatz erstellen", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-new", "overflowText": "Neu", "auto_save": true }, { "itemId": null, "menu_item_text": "L\u00f6schen", "tooltip": "Diesen Datensatz l\u00f6schen", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "L\u00f6schen", "auto_save": false }, { "itemId": "do_print", "menu_item_text": "Drucken", "must_save": true, "tooltip": "Drucken", "panel_btn_handler": Lino.row_action_handler('do_print','GET'), "iconCls": "x-tbar-print", "overflowText": "Drucken", "auto_save": true }, { "itemId": "print_eid_content", "menu_item_text": "eID-Inhalt", "must_save": true, "tooltip": "eID-Inhalt", "panel_btn_handler": Lino.row_action_handler('print_eid_content','GET'), "iconCls": "x-tbar-vcard", "overflowText": "eID-Inhalt", "auto_save": true } ],
  ls_url: "/pcsw/Clients",
  action_name: "detail",
  initComponent : function() {
    this.ls_detail_handler = Lino.pcsw.Clients.detail;
    this.ls_insert_handler = Lino.pcsw.Clients.insert;
    Lino.pcsw.Clients.detailPanel.superclass.initComponent.call(this);
  }
});

Lino.pcsw.Clients.detail = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.pcsw.Clients.detailPanel(p);
});
Lino.pcsw.Clients.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  p.params_panel = new Lino.pcsw.Clients.ParamsPanel({});
  return new Lino.pcsw.Clients.GridPanel(p);
});

// js_render_GridPanel_class integ.CompaniesAndContracts
Lino.integ.CompaniesAndContracts.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "Keine Daten anzuzeigen." },
  ls_url : "/integ/CompaniesAndContracts",
  ls_bbar_actions : [ { "itemId": "insert", "menu_item_text": "Neu", "must_save": true, "tooltip": "Neuen Datensatz erstellen", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-new", "overflowText": "Neu", "auto_save": true }, { "itemId": "detail", "menu_item_text": "Detail", "tooltip": "Detail-Fenster auf diesem Datensatz \u00f6ffnen", "panel_btn_handler": Lino.show_detail, "iconCls": "x-tbar-detail", "overflowText": "Detail", "auto_save": true }, { "itemId": null, "menu_item_text": "L\u00f6schen", "tooltip": "Diesen Datensatz l\u00f6schen", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "L\u00f6schen", "auto_save": false } ],
  title : "Organisations externes et contrats",
  page_length : 20,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "name": "description" }, 'descriptionHidden', { "name": "vc0" }, { "name": "vc1" }, { "name": "vc2" }, { "name": "vc3" }, { "name": "vc4" }, { "name": "vc5" }, { "name": "partner_ptr" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 8,
  ls_grid_configs : [  ],
  content_type : 20,
  ls_id_property : "partner_ptr",
  gc_name : 0,
  disabled_actions_index : 10,
  initComponent : function() {
    this.ls_detail_handler = Lino.integ.CompaniesAndContracts.detail;
    this.ls_insert_handler = Lino.integ.CompaniesAndContracts.insert;
    var ww = this.containing_window;
    var description2064 = new Lino.RemoteComboFieldElement({ "disabled": true, "store": new Lino.ComplexRemoteComboStore({  }), "pageSize": 20, "emptyText": "Organisation ausw\u00e4hlen..." });
    var vc02065 = new Ext.form.NumberField({ "disabled": true });
    var vc12066 = new Ext.form.NumberField({ "disabled": true });
    var vc22067 = new Ext.form.NumberField({ "disabled": true });
    var vc32068 = new Ext.form.NumberField({ "disabled": true });
    var vc42069 = new Ext.form.NumberField({ "disabled": true });
    var vc52070 = new Ext.form.NumberField({ "disabled": true });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ { "colIndex": 0, "sortable": false, "header": "Organisation", "editable": false, "tooltip": "(integ.CompaniesAndContracts.description) ", "width": Lino.chars2width(21), "dataIndex": "description", "renderer": Lino.fk_renderer('descriptionHidden','Lino.contacts.Companies.detail') }, new Lino.NullNumberColumn({ "colIndex": 1, "sortable": false, "format": "0", "editable": false, "tooltip": "(integ.CompaniesAndContracts.vc0) ", "header": "VSE Ausbildung", "dataIndex": "vc0", "width": Lino.chars2width(6) }), new Lino.NullNumberColumn({ "colIndex": 2, "sortable": false, "format": "0", "editable": false, "tooltip": "(integ.CompaniesAndContracts.vc1) ", "header": "VSE Arbeitssuche", "dataIndex": "vc1", "width": Lino.chars2width(6) }), new Lino.NullNumberColumn({ "colIndex": 3, "sortable": false, "format": "0", "editable": false, "tooltip": "(integ.CompaniesAndContracts.vc2) ", "header": "VSE Lehre", "dataIndex": "vc2", "width": Lino.chars2width(6) }), new Lino.NullNumberColumn({ "colIndex": 4, "sortable": false, "format": "0", "editable": false, "tooltip": "(integ.CompaniesAndContracts.vc3) ", "header": "VSE Vollzeitstudium", "dataIndex": "vc3", "width": Lino.chars2width(6) }), new Lino.NullNumberColumn({ "colIndex": 5, "sortable": false, "format": "0", "editable": false, "tooltip": "(integ.CompaniesAndContracts.vc4) ", "header": "VSE Sprachkurs", "dataIndex": "vc4", "width": Lino.chars2width(6) }), new Lino.NullNumberColumn({ "colIndex": 6, "sortable": false, "format": "0", "editable": false, "tooltip": "(integ.CompaniesAndContracts.vc5) ", "header": "Total", "dataIndex": "vc5", "width": Lino.chars2width(6) }) ];
    Lino.integ.CompaniesAndContracts.GridPanel.superclass.initComponent.call(this);
  }
});


Lino.integ.CompaniesAndContracts.insertPanel = Ext.extend(Lino.contacts.Companies.InsertFormPanel,{
  empty_title: "Neu Organisations externes et contrats",
  hide_navigator: true,
  ls_bbar_actions: [ { "itemId": "post", "menu_item_text": "Erstellen", "tooltip": "Datensatz erstellen und dann im Detail-Fenster \u00f6ffnen", "panel_btn_handler": function(panel){panel.save(null,true,'post')}, "text": "Erstellen", "overflowText": "Erstellen", "auto_save": false }, { "itemId": "poststay", "menu_item_text": "Erstellen ohne Detail", "tooltip": "Nach Erstellen des Datensatzes kein Detail-Fenster \u00f6ffnen", "panel_btn_handler": function(panel){panel.save(null,false,'poststay')}, "text": "Erstellen ohne Detail", "overflowText": "Erstellen ohne Detail", "auto_save": false } ],
  ls_url: "/integ/CompaniesAndContracts",
  action_name: "insert",
  initComponent : function() {
    this.ls_detail_handler = Lino.integ.CompaniesAndContracts.detail;
    this.ls_insert_handler = Lino.integ.CompaniesAndContracts.insert;
    Lino.integ.CompaniesAndContracts.insertPanel.superclass.initComponent.call(this);
  }
});

Lino.integ.CompaniesAndContracts.insert = new Lino.WindowAction({ "draggable": true, "width": Lino.chars2width(60), "autoHeight": true, "maximizable": true, "modal": true, "maximized": false },function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.integ.CompaniesAndContracts.insertPanel(p);
});

Lino.integ.CompaniesAndContracts.detailPanel = Ext.extend(Lino.contacts.Companies.DetailFormPanel,{
  empty_title: "Detail Organisations externes et contrats",
  ls_bbar_actions: [ { "itemId": "put", "menu_item_text": "Speichern", "tooltip": "\u00c4nderungen in diesem Formular speichern", "panel_btn_handler": function(panel){panel.save(null,false,'put')}, "iconCls": "x-tbar-save", "overflowText": "Speichern", "auto_save": false }, { "itemId": "insert", "menu_item_text": "Neu", "must_save": true, "tooltip": "Neuen Datensatz erstellen", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-new", "overflowText": "Neu", "auto_save": true }, { "itemId": null, "menu_item_text": "L\u00f6schen", "tooltip": "Diesen Datensatz l\u00f6schen", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "L\u00f6schen", "auto_save": false } ],
  ls_url: "/integ/CompaniesAndContracts",
  action_name: "detail",
  initComponent : function() {
    this.ls_detail_handler = Lino.integ.CompaniesAndContracts.detail;
    this.ls_insert_handler = Lino.integ.CompaniesAndContracts.insert;
    Lino.integ.CompaniesAndContracts.detailPanel.superclass.initComponent.call(this);
  }
});

Lino.integ.CompaniesAndContracts.detail = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.integ.CompaniesAndContracts.detailPanel(p);
});
Lino.integ.CompaniesAndContracts.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.integ.CompaniesAndContracts.GridPanel(p);
});

// js_render_GridPanel_class integ.JobProvidersAndContracts
Lino.integ.JobProvidersAndContracts.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "Keine Daten anzuzeigen." },
  ls_url : "/integ/JobProvidersAndContracts",
  ls_bbar_actions : [ { "itemId": "insert", "menu_item_text": "Neu", "must_save": true, "tooltip": "Neuen Datensatz erstellen", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-new", "overflowText": "Neu", "auto_save": true }, { "itemId": "detail", "menu_item_text": "Detail", "tooltip": "Detail-Fenster auf diesem Datensatz \u00f6ffnen", "panel_btn_handler": Lino.show_detail, "iconCls": "x-tbar-detail", "overflowText": "Detail", "auto_save": true }, { "itemId": null, "menu_item_text": "L\u00f6schen", "tooltip": "Diesen Datensatz l\u00f6schen", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "L\u00f6schen", "auto_save": false } ],
  title : "Employants et contrats Art 60\u00a77",
  page_length : 20,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "name": "description" }, 'descriptionHidden', { "name": "vc0" }, { "name": "vc1" }, { "name": "vc2" }, { "name": "vc3" }, { "name": "vc4" }, { "name": "vc5" }, { "name": "partner_ptr" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 8,
  ls_grid_configs : [  ],
  content_type : 20,
  ls_id_property : "partner_ptr",
  gc_name : 0,
  disabled_actions_index : 10,
  initComponent : function() {
    this.ls_detail_handler = Lino.integ.JobProvidersAndContracts.detail;
    this.ls_insert_handler = Lino.integ.JobProvidersAndContracts.insert;
    var ww = this.containing_window;
    var description2072 = new Lino.RemoteComboFieldElement({ "disabled": true, "store": new Lino.ComplexRemoteComboStore({  }), "pageSize": 20, "emptyText": "Organisation ausw\u00e4hlen..." });
    var vc02073 = new Ext.form.NumberField({ "disabled": true });
    var vc12074 = new Ext.form.NumberField({ "disabled": true });
    var vc22075 = new Ext.form.NumberField({ "disabled": true });
    var vc32076 = new Ext.form.NumberField({ "disabled": true });
    var vc42077 = new Ext.form.NumberField({ "disabled": true });
    var vc52078 = new Ext.form.NumberField({ "disabled": true });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ { "colIndex": 0, "sortable": false, "header": "Organisation", "editable": false, "tooltip": "(integ.JobProvidersAndContracts.description) ", "width": Lino.chars2width(21), "dataIndex": "description", "renderer": Lino.fk_renderer('descriptionHidden','Lino.contacts.Companies.detail') }, new Lino.NullNumberColumn({ "colIndex": 1, "sortable": false, "format": "0", "editable": false, "tooltip": "(integ.JobProvidersAndContracts.vc0) ", "header": "Sozial\u00f6konomie", "dataIndex": "vc0", "width": Lino.chars2width(6) }), new Lino.NullNumberColumn({ "colIndex": 2, "sortable": false, "format": "0", "editable": false, "tooltip": "(integ.JobProvidersAndContracts.vc1) ", "header": "Sozial\u00f6konomie - major\u00e9", "dataIndex": "vc1", "width": Lino.chars2width(6) }), new Lino.NullNumberColumn({ "colIndex": 3, "sortable": false, "format": "0", "editable": false, "tooltip": "(integ.JobProvidersAndContracts.vc2) ", "header": "mit R\u00fcckerstattung", "dataIndex": "vc2", "width": Lino.chars2width(6) }), new Lino.NullNumberColumn({ "colIndex": 4, "sortable": false, "format": "0", "editable": false, "tooltip": "(integ.JobProvidersAndContracts.vc3) ", "header": "mit R\u00fcckerstattung Schule", "dataIndex": "vc3", "width": Lino.chars2width(6) }), new Lino.NullNumberColumn({ "colIndex": 5, "sortable": false, "format": "0", "editable": false, "tooltip": "(integ.JobProvidersAndContracts.vc4) ", "header": "Stadt Eupen", "dataIndex": "vc4", "width": Lino.chars2width(6) }), new Lino.NullNumberColumn({ "colIndex": 6, "sortable": false, "format": "0", "editable": false, "tooltip": "(integ.JobProvidersAndContracts.vc5) ", "header": "Total", "dataIndex": "vc5", "width": Lino.chars2width(6) }) ];
    Lino.integ.JobProvidersAndContracts.GridPanel.superclass.initComponent.call(this);
  }
});


Lino.integ.JobProvidersAndContracts.insertPanel = Ext.extend(Lino.contacts.Companies.InsertFormPanel,{
  empty_title: "Neu Employants et contrats Art 60\u00a77",
  hide_navigator: true,
  ls_bbar_actions: [ { "itemId": "post", "menu_item_text": "Erstellen", "tooltip": "Datensatz erstellen und dann im Detail-Fenster \u00f6ffnen", "panel_btn_handler": function(panel){panel.save(null,true,'post')}, "text": "Erstellen", "overflowText": "Erstellen", "auto_save": false }, { "itemId": "poststay", "menu_item_text": "Erstellen ohne Detail", "tooltip": "Nach Erstellen des Datensatzes kein Detail-Fenster \u00f6ffnen", "panel_btn_handler": function(panel){panel.save(null,false,'poststay')}, "text": "Erstellen ohne Detail", "overflowText": "Erstellen ohne Detail", "auto_save": false } ],
  ls_url: "/integ/JobProvidersAndContracts",
  action_name: "insert",
  initComponent : function() {
    this.ls_detail_handler = Lino.integ.JobProvidersAndContracts.detail;
    this.ls_insert_handler = Lino.integ.JobProvidersAndContracts.insert;
    Lino.integ.JobProvidersAndContracts.insertPanel.superclass.initComponent.call(this);
  }
});

Lino.integ.JobProvidersAndContracts.insert = new Lino.WindowAction({ "draggable": true, "width": Lino.chars2width(60), "autoHeight": true, "maximizable": true, "modal": true, "maximized": false },function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.integ.JobProvidersAndContracts.insertPanel(p);
});

Lino.integ.JobProvidersAndContracts.detailPanel = Ext.extend(Lino.contacts.Companies.DetailFormPanel,{
  empty_title: "Detail Employants et contrats Art 60\u00a77",
  ls_bbar_actions: [ { "itemId": "put", "menu_item_text": "Speichern", "tooltip": "\u00c4nderungen in diesem Formular speichern", "panel_btn_handler": function(panel){panel.save(null,false,'put')}, "iconCls": "x-tbar-save", "overflowText": "Speichern", "auto_save": false }, { "itemId": "insert", "menu_item_text": "Neu", "must_save": true, "tooltip": "Neuen Datensatz erstellen", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-new", "overflowText": "Neu", "auto_save": true }, { "itemId": null, "menu_item_text": "L\u00f6schen", "tooltip": "Diesen Datensatz l\u00f6schen", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "L\u00f6schen", "auto_save": false } ],
  ls_url: "/integ/JobProvidersAndContracts",
  action_name: "detail",
  initComponent : function() {
    this.ls_detail_handler = Lino.integ.JobProvidersAndContracts.detail;
    this.ls_insert_handler = Lino.integ.JobProvidersAndContracts.insert;
    Lino.integ.JobProvidersAndContracts.detailPanel.superclass.initComponent.call(this);
  }
});

Lino.integ.JobProvidersAndContracts.detail = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.integ.JobProvidersAndContracts.detailPanel(p);
});
Lino.integ.JobProvidersAndContracts.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.integ.JobProvidersAndContracts.GridPanel(p);
});

// js_render_GridPanel_class cbss.RetrieveTIGroupsRequests
Lino.cbss.RetrieveTIGroupsRequests.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "Keine Daten anzuzeigen." },
  ls_url : "/cbss/RetrieveTIGroupsRequests",
  ls_bbar_actions : [ { "itemId": "insert", "menu_item_text": "Neu", "must_save": true, "tooltip": "Neuen Datensatz erstellen", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-new", "overflowText": "Neu", "auto_save": true }, { "itemId": "duplicate", "menu_item_text": "Duplizieren", "must_save": true, "tooltip": "Duplizieren", "panel_btn_handler": Lino.row_action_handler('duplicate','GET'), "iconCls": "x-tbar-duplicate", "overflowText": "Duplizieren", "auto_save": true }, { "itemId": "detail", "menu_item_text": "Detail", "tooltip": "Detail-Fenster auf diesem Datensatz \u00f6ffnen", "panel_btn_handler": Lino.show_detail, "iconCls": "x-tbar-detail", "overflowText": "Detail", "auto_save": true }, { "itemId": null, "menu_item_text": "L\u00f6schen", "tooltip": "Diesen Datensatz l\u00f6schen", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "L\u00f6schen", "auto_save": false }, { "itemId": "do_print", "menu_item_text": "Drucken", "must_save": true, "tooltip": "Drucken", "panel_btn_handler": Lino.row_action_handler('do_print','GET'), "iconCls": "x-tbar-print", "overflowText": "Drucken", "auto_save": true } ],
  title : "Tx25-Anfragen",
  page_length : 20,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "type": "int", "name": "id" }, { "name": "user" }, 'userHidden', { "name": "person" }, 'personHidden', { "name": "national_id" }, { "name": "language" }, 'languageHidden', { "type": "boolean", "name": "history" }, { "name": "status" }, 'statusHidden', { "name": "ticket" }, { "name": "sent" }, { "name": "environment" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 0,
  ls_grid_configs : [  ],
  content_type : 90,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 15,
  initComponent : function() {
    this.ls_detail_handler = Lino.cbss.RetrieveTIGroupsRequests.detail;
    this.ls_insert_handler = Lino.cbss.RetrieveTIGroupsRequests.insert;
    var ww = this.containing_window;
    var id2080 = new Ext.form.NumberField({ "selectOnFocus": true });
    var user2081 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cbss/RetrieveTIGroupsRequests/user", "method": "GET" }) }), "allowBlank": false, "pageSize": 20, "emptyText": "Benutzer ausw\u00e4hlen..." });
    var person2082 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cbss/RetrieveTIGroupsRequests/person", "method": "GET" }) }), "allowBlank": false, "pageSize": 20, "emptyText": "Klient ausw\u00e4hlen..." });
    var national_id2083 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var language2084 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "forceSelection": true, "store": [['','<br>']].concat(Lino.cbss.RequestLanguages) });
    var history2085 = new Ext.form.Checkbox({ "selectOnFocus": true, "checked": true });
    var status2086 = new Lino.ChoicesFieldElement({ "disabled": true, "forceSelection": true, "store": [['','<br>']].concat(Lino.cbss.RequestStates) });
    var ticket2087 = new Ext.form.TextField({ "disabled": true, "maxLength": 36 });
    var sent2088 = new Ext.form.DisplayField({ "disabled": true, "value": "<br>" });
    var environment2089 = new Ext.form.TextField({ "disabled": true, "boxMinWidth": Lino.chars2width(4), "maxLength": 4 });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ new Lino.NullNumberColumn({ "colIndex": 0, "sortable": true, "format": "0", "editable": true, "tooltip": "(cbss.RetrieveTIGroupsRequests.id) ", "filter": { "type": "numeric" }, "header": "ID", "renderer": Lino.id_renderer, "editor": id2080, "width": Lino.chars2width(6), "dataIndex": "id" }), { "colIndex": 1, "sortable": true, "header": "Autor", "editable": true, "tooltip": "(cbss.RetrieveTIGroupsRequests.user) ", "filter": { "type": "string" }, "width": Lino.chars2width(16), "dataIndex": "user", "editor": user2081 }, { "colIndex": 2, "sortable": true, "header": "Klient", "editable": true, "tooltip": "(cbss.RetrieveTIGroupsRequests.person) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('personHidden','Lino.pcsw.Clients.detail'), "editor": person2082, "dataIndex": "person" }, { "colIndex": 3, "sortable": true, "header": "NR-Nummer", "editable": true, "tooltip": "(cbss.RetrieveTIGroupsRequests.national_id) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "national_id", "editor": national_id2083 }, { "colIndex": 4, "sortable": true, "header": "Sprache", "editable": true, "tooltip": "(cbss.RetrieveTIGroupsRequests.language) ", "filter": { "type": "string" }, "width": Lino.chars2width(18), "dataIndex": "language", "editor": language2084 }, { "colIndex": 5, "sortable": false, "xtype": "checkcolumn", "header": "Historie", "editable": true, "tooltip": "(cbss.RetrieveTIGroupsRequests.history) Whatever this means.", "filter": { "type": "boolean" }, "width": Lino.chars2width(11), "dataIndex": "history" }, { "colIndex": 6, "sortable": true, "header": "Zustand", "editable": false, "tooltip": "(cbss.RetrieveTIGroupsRequests.status) ", "filter": { "type": "string" }, "width": Lino.chars2width(19), "dataIndex": "status" }, { "colIndex": 7, "sortable": true, "header": "Ticket", "editable": false, "tooltip": "(cbss.RetrieveTIGroupsRequests.ticket) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "ticket" }, { "width": Lino.chars2width(17), "colIndex": 8, "sortable": true, "dataIndex": "sent", "header": "Versendet", "editable": false, "tooltip": "(cbss.RetrieveTIGroupsRequests.sent) The date and time when this request has been executed. \nThis is empty for requests than haven't been sent.\nRead-only." }, { "colIndex": 9, "sortable": true, "header": "T/A/B", "editable": false, "tooltip": "(cbss.RetrieveTIGroupsRequests.environment) ", "filter": { "type": "string" }, "width": Lino.chars2width(6), "dataIndex": "environment" } ];
    Lino.cbss.RetrieveTIGroupsRequests.GridPanel.superclass.initComponent.call(this);
  }
});


Lino.cbss.RetrieveTIGroupsRequests.insertPanel = Ext.extend(Lino.cbss.RetrieveTIGroupsRequests.InsertFormPanel,{
  empty_title: "Neu Tx25-Anfragen",
  hide_navigator: true,
  ls_bbar_actions: [ { "itemId": "post", "menu_item_text": "Erstellen", "tooltip": "Datensatz erstellen und dann im Detail-Fenster \u00f6ffnen", "panel_btn_handler": function(panel){panel.save(null,true,'post')}, "text": "Erstellen", "overflowText": "Erstellen", "auto_save": false }, { "itemId": "poststay", "menu_item_text": "Erstellen ohne Detail", "tooltip": "Nach Erstellen des Datensatzes kein Detail-Fenster \u00f6ffnen", "panel_btn_handler": function(panel){panel.save(null,false,'poststay')}, "text": "Erstellen ohne Detail", "overflowText": "Erstellen ohne Detail", "auto_save": false } ],
  ls_url: "/cbss/RetrieveTIGroupsRequests",
  action_name: "insert",
  initComponent : function() {
    this.ls_detail_handler = Lino.cbss.RetrieveTIGroupsRequests.detail;
    this.ls_insert_handler = Lino.cbss.RetrieveTIGroupsRequests.insert;
    Lino.cbss.RetrieveTIGroupsRequests.insertPanel.superclass.initComponent.call(this);
  }
});

Lino.cbss.RetrieveTIGroupsRequests.insert = new Lino.WindowAction({ "draggable": true, "width": Lino.chars2width(40), "autoHeight": true, "maximizable": true, "modal": true, "maximized": false },function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.cbss.RetrieveTIGroupsRequests.insertPanel(p);
});

Lino.cbss.RetrieveTIGroupsRequests.detailPanel = Ext.extend(Lino.cbss.RetrieveTIGroupsRequests.DetailFormPanel,{
  empty_title: "Detail Tx25-Anfragen",
  ls_bbar_actions: [ { "itemId": "put", "menu_item_text": "Speichern", "tooltip": "\u00c4nderungen in diesem Formular speichern", "panel_btn_handler": function(panel){panel.save(null,false,'put')}, "iconCls": "x-tbar-save", "overflowText": "Speichern", "auto_save": false }, { "itemId": "insert", "menu_item_text": "Neu", "must_save": true, "tooltip": "Neuen Datensatz erstellen", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-new", "overflowText": "Neu", "auto_save": true }, { "itemId": "duplicate", "menu_item_text": "Duplizieren", "must_save": true, "tooltip": "Duplizieren", "panel_btn_handler": Lino.row_action_handler('duplicate','GET'), "iconCls": "x-tbar-duplicate", "overflowText": "Duplizieren", "auto_save": true }, { "itemId": null, "menu_item_text": "L\u00f6schen", "tooltip": "Diesen Datensatz l\u00f6schen", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "L\u00f6schen", "auto_save": false }, { "itemId": "do_print", "menu_item_text": "Drucken", "must_save": true, "tooltip": "Drucken", "panel_btn_handler": Lino.row_action_handler('do_print','GET'), "iconCls": "x-tbar-print", "overflowText": "Drucken", "auto_save": true } ],
  ls_url: "/cbss/RetrieveTIGroupsRequests",
  action_name: "detail",
  initComponent : function() {
    this.ls_detail_handler = Lino.cbss.RetrieveTIGroupsRequests.detail;
    this.ls_insert_handler = Lino.cbss.RetrieveTIGroupsRequests.insert;
    Lino.cbss.RetrieveTIGroupsRequests.detailPanel.superclass.initComponent.call(this);
  }
});

Lino.cbss.RetrieveTIGroupsRequests.detail = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.cbss.RetrieveTIGroupsRequests.detailPanel(p);
});
Lino.cbss.RetrieveTIGroupsRequests.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.cbss.RetrieveTIGroupsRequests.GridPanel(p);
});

// js_render_GridPanel_class sessions.SessionTable
Lino.sessions.SessionTable.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "Keine Daten anzuzeigen." },
  ls_url : "/sessions/SessionTable",
  ls_bbar_actions : [ { "itemId": null, "menu_item_text": "L\u00f6schen", "tooltip": "Diesen Datensatz l\u00f6schen", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "L\u00f6schen", "auto_save": false } ],
  title : "Sitzungen",
  page_length : 20,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "name": "session_key" }, { "name": "session_data" }, { "name": "expire_date" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 0,
  ls_grid_configs : [  ],
  content_type : 1,
  ls_id_property : "session_key",
  gc_name : 0,
  disabled_actions_index : 4,
  initComponent : function() {
    var ww = this.containing_window;
    var session_key2091 = new Ext.form.TextField({ "selectOnFocus": true, "allowBlank": false, "maxLength": 40 });
    var session_data2092 = new Ext.form.TextArea({ "selectOnFocus": true, "allowBlank": false, "growMax": 2000 });
    var expire_date2093 = new Ext.form.DisplayField({ "selectOnFocus": true, "allowBlank": false, "value": "<br>" });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ { "colIndex": 0, "sortable": true, "header": "Sitzungs-ID", "editable": true, "tooltip": "(sessions.SessionTable.session_key) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "session_key", "editor": session_key2091 }, { "colIndex": 1, "sortable": false, "header": "Sitzungsdaten", "editable": true, "tooltip": "(sessions.SessionTable.session_data) ", "filter": { "type": "string" }, "width": Lino.chars2width(61), "renderer": Lino.text_renderer, "editor": session_data2092, "dataIndex": "session_data" }, { "colIndex": 2, "sortable": true, "header": "Verfallsdatum", "editable": true, "tooltip": "(sessions.SessionTable.expire_date) ", "width": Lino.chars2width(17), "dataIndex": "expire_date", "editor": expire_date2093 } ];
    Lino.sessions.SessionTable.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.sessions.SessionTable.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.sessions.SessionTable.GridPanel(p);
});

// js_render_GridPanel_class users.AuthoritiesGiven
Lino.users.AuthoritiesGiven.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "forceFit": true, "emptyText": "Keine Daten anzuzeigen." },
  ls_url : "/users/AuthoritiesGiven",
  ls_bbar_actions : [ { "itemId": null, "menu_item_text": "L\u00f6schen", "tooltip": "Diesen Datensatz l\u00f6schen", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "L\u00f6schen", "auto_save": false } ],
  title : "Erteilte Vollmachten",
  page_length : 20,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "name": "authorized" }, 'authorizedHidden', { "type": "int", "name": "id" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 2,
  ls_grid_configs : [  ],
  content_type : 8,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 4,
  initComponent : function() {
    var ww = this.containing_window;
    var authorized92 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/users/AuthoritiesGiven/authorized", "method": "GET" }) }), "allowBlank": false, "pageSize": 20, "emptyText": "Benutzer ausw\u00e4hlen..." });
    this.before_row_edit = function(record) {
      var bp = this.get_base_params();
      authorized92.setContextValue('mk',bp['mk']);
      authorized92.setContextValue('mt',bp['mt']);
    };
    this.ls_columns = [ { "colIndex": 0, "sortable": true, "header": "Benutzer", "editable": true, "tooltip": "(users.AuthoritiesGiven.authorized) The user who gets authority to act in your name.", "filter": { "type": "string" }, "width": Lino.chars2width(16), "dataIndex": "authorized", "editor": authorized92 } ];
    Lino.users.AuthoritiesGiven.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.users.AuthoritiesGiven.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.users.AuthoritiesGiven.GridPanel(p);
});

// js_render_GridPanel_class users.AuthoritiesTaken
Lino.users.AuthoritiesTaken.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "forceFit": true, "emptyText": "Keine Daten anzuzeigen." },
  ls_url : "/users/AuthoritiesTaken",
  ls_bbar_actions : [ { "itemId": null, "menu_item_text": "L\u00f6schen", "tooltip": "Diesen Datensatz l\u00f6schen", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "L\u00f6schen", "auto_save": false } ],
  title : "Erhaltene Vollmachten",
  page_length : 20,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "name": "user" }, 'userHidden', { "type": "int", "name": "id" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 2,
  ls_grid_configs : [  ],
  content_type : 8,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 4,
  initComponent : function() {
    var ww = this.containing_window;
    var user2095 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/users/AuthoritiesTaken/user", "method": "GET" }) }), "pageSize": 20, "emptyText": "Benutzer ausw\u00e4hlen..." });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ { "colIndex": 0, "sortable": true, "header": "Autor", "editable": true, "tooltip": "(users.AuthoritiesTaken.user) ", "filter": { "type": "string" }, "width": Lino.chars2width(16), "dataIndex": "user", "editor": user2095 } ];
    Lino.users.AuthoritiesTaken.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.users.AuthoritiesTaken.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.users.AuthoritiesTaken.GridPanel(p);
});

// js_render_GridPanel_class countries.CitiesByCity
Lino.countries.CitiesByCity.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "Keine Daten anzuzeigen." },
  ls_url : "/countries/CitiesByCity",
  ls_bbar_actions : [ { "itemId": "insert", "menu_item_text": "Neu", "must_save": true, "tooltip": "Neuen Datensatz erstellen", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-new", "overflowText": "Neu", "auto_save": true }, { "itemId": "detail", "menu_item_text": "Detail", "tooltip": "Detail-Fenster auf diesem Datensatz \u00f6ffnen", "panel_btn_handler": Lino.show_detail, "iconCls": "x-tbar-detail", "overflowText": "Detail", "auto_save": true }, { "itemId": null, "menu_item_text": "L\u00f6schen", "tooltip": "Diesen Datensatz l\u00f6schen", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "L\u00f6schen", "auto_save": false } ],
  title : "Subdivisions",
  page_length : 20,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "name": "name" }, { "name": "name_fr" }, { "name": "name_nl" }, { "name": "type" }, 'typeHidden', { "name": "zip_code" }, { "type": "int", "name": "id" }, { "name": "country" }, 'countryHidden', { "name": "inscode" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 6,
  ls_grid_configs : [  ],
  content_type : 13,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 11,
  initComponent : function() {
    this.ls_detail_handler = Lino.countries.CitiesByCity.detail;
    this.ls_insert_handler = Lino.countries.CitiesByCity.insert;
    var ww = this.containing_window;
    var name287 = new Ext.form.TextField({ "selectOnFocus": true, "allowBlank": false, "maxLength": 200 });
    var name_fr288 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var name_nl289 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var type290 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/countries/CitiesByCity/type", "method": "GET" }) }) });
    var zip_code291 = new Ext.form.TextField({ "selectOnFocus": true, "boxMinWidth": Lino.chars2width(8), "maxLength": 8 });
    var id292 = new Ext.form.NumberField({ "selectOnFocus": true });
    var country293 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/countries/CitiesByCity/country", "method": "GET" }) }), "allowBlank": false, "pageSize": 20, "emptyText": "Land ausw\u00e4hlen..." });
    var inscode294 = new Ext.form.TextField({ "selectOnFocus": true, "boxMinWidth": Lino.chars2width(5), "maxLength": 5 });
    this.before_row_edit = function(record) {
      type290.setContextValue('country',record ? record.data['countryHidden'] : undefined);
    };
    this.onRender = function(ct, position) {
      country293.on('change',Lino.chooser_handler(type290,'country'));
      Lino.countries.CitiesByCity.GridPanel.superclass.onRender.call(this, ct, position);
    }
    this.ls_columns = [ { "colIndex": 0, "sortable": true, "header": "Bezeichnung", "editable": true, "tooltip": "(countries.CitiesByCity.name) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "name", "editor": name287 }, { "colIndex": 1, "sortable": true, "header": "Bezeichnung (fr)", "editable": true, "tooltip": "(countries.CitiesByCity.name_fr) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "name_fr", "editor": name_fr288 }, { "colIndex": 2, "sortable": true, "header": "Bezeichnung (nl)", "editable": true, "tooltip": "(countries.CitiesByCity.name_nl) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "name_nl", "editor": name_nl289 }, { "colIndex": 3, "sortable": true, "header": "Ortsart", "editable": true, "tooltip": "(countries.CitiesByCity.type) ", "filter": { "type": "string" }, "width": Lino.chars2width(11), "dataIndex": "type", "editor": type290 }, { "colIndex": 4, "sortable": true, "header": "zip code", "editable": true, "tooltip": "(countries.CitiesByCity.zip_code) ", "filter": { "type": "string" }, "width": Lino.chars2width(10), "dataIndex": "zip_code", "editor": zip_code291 }, new Lino.NullNumberColumn({ "colIndex": 5, "sortable": true, "format": "0", "editable": true, "tooltip": "(countries.CitiesByCity.id) ", "filter": { "type": "numeric" }, "header": "ID", "renderer": Lino.id_renderer, "editor": id292, "width": Lino.chars2width(6), "dataIndex": "id" }), { "colIndex": 6, "sortable": true, "header": "Land", "editable": true, "tooltip": "(countries.CitiesByCity.country) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('countryHidden','Lino.countries.Countries.detail'), "editor": country293, "dataIndex": "country" }, { "colIndex": 7, "sortable": true, "header": "INS-Code", "editable": true, "tooltip": "(countries.CitiesByCity.inscode) The official code for this place used by statbel.fgov.be", "filter": { "type": "string" }, "width": Lino.chars2width(7), "dataIndex": "inscode", "editor": inscode294 } ];
    Lino.countries.CitiesByCity.GridPanel.superclass.initComponent.call(this);
  }
});


Lino.countries.CitiesByCity.insertPanel = Ext.extend(Lino.countries.CitiesByCity.DetailFormPanel,{
  empty_title: "Neu Subdivisions",
  hide_navigator: true,
  ls_bbar_actions: [ { "itemId": "post", "menu_item_text": "Erstellen", "tooltip": "Datensatz erstellen und dann im Detail-Fenster \u00f6ffnen", "panel_btn_handler": function(panel){panel.save(null,true,'post')}, "text": "Erstellen", "overflowText": "Erstellen", "auto_save": false }, { "itemId": "poststay", "menu_item_text": "Erstellen ohne Detail", "tooltip": "Nach Erstellen des Datensatzes kein Detail-Fenster \u00f6ffnen", "panel_btn_handler": function(panel){panel.save(null,false,'poststay')}, "text": "Erstellen ohne Detail", "overflowText": "Erstellen ohne Detail", "auto_save": false } ],
  ls_url: "/countries/CitiesByCity",
  action_name: "insert",
  initComponent : function() {
    this.ls_detail_handler = Lino.countries.CitiesByCity.detail;
    this.ls_insert_handler = Lino.countries.CitiesByCity.insert;
    Lino.countries.CitiesByCity.insertPanel.superclass.initComponent.call(this);
  }
});

Lino.countries.CitiesByCity.insert = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.countries.CitiesByCity.insertPanel(p);
});

Lino.countries.CitiesByCity.detailPanel = Ext.extend(Lino.countries.CitiesByCity.DetailFormPanel,{
  empty_title: "Detail Subdivisions",
  ls_bbar_actions: [ { "itemId": "put", "menu_item_text": "Speichern", "tooltip": "\u00c4nderungen in diesem Formular speichern", "panel_btn_handler": function(panel){panel.save(null,false,'put')}, "iconCls": "x-tbar-save", "overflowText": "Speichern", "auto_save": false }, { "itemId": "insert", "menu_item_text": "Neu", "must_save": true, "tooltip": "Neuen Datensatz erstellen", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-new", "overflowText": "Neu", "auto_save": true }, { "itemId": null, "menu_item_text": "L\u00f6schen", "tooltip": "Diesen Datensatz l\u00f6schen", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "L\u00f6schen", "auto_save": false } ],
  ls_url: "/countries/CitiesByCity",
  action_name: "detail",
  initComponent : function() {
    this.ls_detail_handler = Lino.countries.CitiesByCity.detail;
    this.ls_insert_handler = Lino.countries.CitiesByCity.insert;
    Lino.countries.CitiesByCity.detailPanel.superclass.initComponent.call(this);
  }
});

Lino.countries.CitiesByCity.detail = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.countries.CitiesByCity.detailPanel(p);
});
Lino.countries.CitiesByCity.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.countries.CitiesByCity.GridPanel(p);
});

// js_render_GridPanel_class countries.CitiesByCountry
Lino.countries.CitiesByCountry.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "Keine Daten anzuzeigen." },
  ls_url : "/countries/CitiesByCountry",
  ls_bbar_actions : [ { "itemId": "insert", "menu_item_text": "Neu", "must_save": true, "tooltip": "Neuen Datensatz erstellen", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-new", "overflowText": "Neu", "auto_save": true }, { "itemId": "detail", "menu_item_text": "Detail", "tooltip": "Detail-Fenster auf diesem Datensatz \u00f6ffnen", "panel_btn_handler": Lino.show_detail, "iconCls": "x-tbar-detail", "overflowText": "Detail", "auto_save": true }, { "itemId": null, "menu_item_text": "L\u00f6schen", "tooltip": "Diesen Datensatz l\u00f6schen", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "L\u00f6schen", "auto_save": false } ],
  title : "Orte",
  page_length : 20,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "name": "name" }, { "name": "name_fr" }, { "name": "name_nl" }, { "name": "type" }, 'typeHidden', { "name": "zip_code" }, { "type": "int", "name": "id" }, { "name": "parent" }, 'parentHidden', { "name": "inscode" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 6,
  ls_grid_configs : [  ],
  content_type : 13,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 11,
  initComponent : function() {
    this.ls_detail_handler = Lino.countries.CitiesByCountry.detail;
    this.ls_insert_handler = Lino.countries.CitiesByCountry.insert;
    var ww = this.containing_window;
    var name260 = new Ext.form.TextField({ "selectOnFocus": true, "allowBlank": false, "maxLength": 200 });
    var name_fr261 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var name_nl262 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var type263 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/countries/CitiesByCountry/type", "method": "GET" }) }) });
    var zip_code264 = new Ext.form.TextField({ "selectOnFocus": true, "boxMinWidth": Lino.chars2width(8), "maxLength": 8 });
    var id265 = new Ext.form.NumberField({ "selectOnFocus": true });
    var parent266 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/countries/CitiesByCountry/parent", "method": "GET" }) }), "pageSize": 20, "emptyText": "Ort ausw\u00e4hlen..." });
    var inscode267 = new Ext.form.TextField({ "selectOnFocus": true, "boxMinWidth": Lino.chars2width(5), "maxLength": 5 });
    this.before_row_edit = function(record) {
      var bp = this.get_base_params();
      type263.setContextValue('mk',bp['mk']);
      type263.setContextValue('mt',bp['mt']);
    };
    this.ls_columns = [ { "colIndex": 0, "sortable": true, "header": "Bezeichnung", "editable": true, "tooltip": "(countries.CitiesByCountry.name) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "name", "editor": name260 }, { "colIndex": 1, "sortable": true, "header": "Bezeichnung (fr)", "editable": true, "tooltip": "(countries.CitiesByCountry.name_fr) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "name_fr", "editor": name_fr261 }, { "colIndex": 2, "sortable": true, "header": "Bezeichnung (nl)", "editable": true, "tooltip": "(countries.CitiesByCountry.name_nl) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "name_nl", "editor": name_nl262 }, { "colIndex": 3, "sortable": true, "header": "Ortsart", "editable": true, "tooltip": "(countries.CitiesByCountry.type) ", "filter": { "type": "string" }, "width": Lino.chars2width(11), "dataIndex": "type", "editor": type263 }, { "colIndex": 4, "sortable": true, "header": "zip code", "editable": true, "tooltip": "(countries.CitiesByCountry.zip_code) ", "filter": { "type": "string" }, "width": Lino.chars2width(10), "dataIndex": "zip_code", "editor": zip_code264 }, new Lino.NullNumberColumn({ "colIndex": 5, "sortable": true, "format": "0", "editable": true, "tooltip": "(countries.CitiesByCountry.id) ", "filter": { "type": "numeric" }, "header": "ID", "renderer": Lino.id_renderer, "editor": id265, "width": Lino.chars2width(6), "dataIndex": "id" }), { "colIndex": 6, "sortable": true, "header": "Teil von", "editable": true, "tooltip": "(countries.CitiesByCountry.parent) The superordinate geographic place of which this place is a part.", "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "parent", "editor": parent266 }, { "colIndex": 7, "sortable": true, "header": "INS-Code", "editable": true, "tooltip": "(countries.CitiesByCountry.inscode) The official code for this place used by statbel.fgov.be", "filter": { "type": "string" }, "width": Lino.chars2width(7), "dataIndex": "inscode", "editor": inscode267 } ];
    Lino.countries.CitiesByCountry.GridPanel.superclass.initComponent.call(this);
  }
});


Lino.countries.CitiesByCountry.insertPanel = Ext.extend(Lino.countries.CitiesByCity.DetailFormPanel,{
  empty_title: "Neu Orte",
  hide_navigator: true,
  ls_bbar_actions: [ { "itemId": "post", "menu_item_text": "Erstellen", "tooltip": "Datensatz erstellen und dann im Detail-Fenster \u00f6ffnen", "panel_btn_handler": function(panel){panel.save(null,true,'post')}, "text": "Erstellen", "overflowText": "Erstellen", "auto_save": false }, { "itemId": "poststay", "menu_item_text": "Erstellen ohne Detail", "tooltip": "Nach Erstellen des Datensatzes kein Detail-Fenster \u00f6ffnen", "panel_btn_handler": function(panel){panel.save(null,false,'poststay')}, "text": "Erstellen ohne Detail", "overflowText": "Erstellen ohne Detail", "auto_save": false } ],
  ls_url: "/countries/CitiesByCountry",
  action_name: "insert",
  initComponent : function() {
    this.ls_detail_handler = Lino.countries.CitiesByCountry.detail;
    this.ls_insert_handler = Lino.countries.CitiesByCountry.insert;
    Lino.countries.CitiesByCountry.insertPanel.superclass.initComponent.call(this);
  }
});

Lino.countries.CitiesByCountry.insert = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.countries.CitiesByCountry.insertPanel(p);
});

Lino.countries.CitiesByCountry.detailPanel = Ext.extend(Lino.countries.CitiesByCity.DetailFormPanel,{
  empty_title: "Detail Orte",
  ls_bbar_actions: [ { "itemId": "put", "menu_item_text": "Speichern", "tooltip": "\u00c4nderungen in diesem Formular speichern", "panel_btn_handler": function(panel){panel.save(null,false,'put')}, "iconCls": "x-tbar-save", "overflowText": "Speichern", "auto_save": false }, { "itemId": "insert", "menu_item_text": "Neu", "must_save": true, "tooltip": "Neuen Datensatz erstellen", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-new", "overflowText": "Neu", "auto_save": true }, { "itemId": null, "menu_item_text": "L\u00f6schen", "tooltip": "Diesen Datensatz l\u00f6schen", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "L\u00f6schen", "auto_save": false } ],
  ls_url: "/countries/CitiesByCountry",
  action_name: "detail",
  initComponent : function() {
    this.ls_detail_handler = Lino.countries.CitiesByCountry.detail;
    this.ls_insert_handler = Lino.countries.CitiesByCountry.insert;
    Lino.countries.CitiesByCountry.detailPanel.superclass.initComponent.call(this);
  }
});

Lino.countries.CitiesByCountry.detail = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.countries.CitiesByCountry.detailPanel(p);
});
Lino.countries.CitiesByCountry.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.countries.CitiesByCountry.GridPanel(p);
});

// js_render_GridPanel_class properties.ChoicesByType
Lino.properties.ChoicesByType.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "Keine Daten anzuzeigen." },
  ls_url : "/properties/ChoicesByType",
  ls_bbar_actions : [ { "itemId": null, "menu_item_text": "L\u00f6schen", "tooltip": "Diesen Datensatz l\u00f6schen", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "L\u00f6schen", "auto_save": false } ],
  title : "Auswahlm\u00f6glichkeiten",
  page_length : 20,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "name": "value" }, { "name": "text" }, { "name": "text_fr" }, { "name": "text_nl" }, { "type": "int", "name": "id" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 4,
  ls_grid_configs : [  ],
  content_type : 17,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 6,
  initComponent : function() {
    var ww = this.containing_window;
    var value2097 = new Ext.form.TextField({ "selectOnFocus": true, "allowBlank": false, "maxLength": 200 });
    var text2098 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var text_fr2099 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var text_nl2100 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var id2101 = new Ext.form.NumberField({ "selectOnFocus": true });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ { "colIndex": 0, "sortable": true, "header": "Wert", "editable": true, "tooltip": "(properties.ChoicesByType.value) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "value", "editor": value2097 }, { "colIndex": 1, "sortable": true, "header": "Bezeichnung", "editable": true, "tooltip": "(properties.ChoicesByType.text) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "text", "editor": text2098 }, { "colIndex": 2, "sortable": true, "header": "Bezeichnung (fr)", "editable": true, "tooltip": "(properties.ChoicesByType.text_fr) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "text_fr", "editor": text_fr2099 }, { "colIndex": 3, "sortable": true, "header": "Bezeichnung (nl)", "editable": true, "tooltip": "(properties.ChoicesByType.text_nl) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "text_nl", "editor": text_nl2100 }, new Lino.NullNumberColumn({ "colIndex": 4, "sortable": true, "format": "0", "editable": true, "tooltip": "(properties.ChoicesByType.id) ", "filter": { "type": "numeric" }, "header": "ID", "renderer": Lino.id_renderer, "editor": id2101, "width": Lino.chars2width(6), "dataIndex": "id" }) ];
    Lino.properties.ChoicesByType.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.properties.ChoicesByType.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.properties.ChoicesByType.GridPanel(p);
});

// js_render_GridPanel_class contacts.PartnersByCity
Lino.contacts.PartnersByCity.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "Keine Daten anzuzeigen." },
  ls_url : "/contacts/PartnersByCity",
  ls_bbar_actions : [ { "itemId": "insert", "menu_item_text": "Neu", "must_save": true, "tooltip": "Neuen Datensatz erstellen", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-new", "overflowText": "Neu", "auto_save": true }, { "itemId": "detail", "menu_item_text": "Detail", "tooltip": "Detail-Fenster auf diesem Datensatz \u00f6ffnen", "panel_btn_handler": Lino.show_detail, "iconCls": "x-tbar-detail", "overflowText": "Detail", "auto_save": true }, { "itemId": null, "menu_item_text": "L\u00f6schen", "tooltip": "Diesen Datensatz l\u00f6schen", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "L\u00f6schen", "auto_save": false } ],
  title : "Partner",
  page_length : 20,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "name": "street" }, { "name": "street_no" }, { "name": "street_box" }, { "name": "addr2" }, { "name": "name" }, { "name": "language" }, 'languageHidden', { "type": "int", "name": "id" }, { "name": "created" }, { "name": "modified" }, { "name": "country" }, 'countryHidden', { "name": "region" }, 'regionHidden', { "name": "zip_code" }, { "name": "addr1" }, { "name": "street_prefix" }, { "name": "email" }, { "name": "url" }, { "name": "phone" }, { "name": "gsm" }, { "name": "fax" }, { "name": "remarks" }, { "type": "boolean", "name": "is_obsolete" }, { "name": "activity" }, 'activityHidden', { "name": "bank_account1" }, { "name": "bank_account2" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 7,
  ls_grid_configs : [  ],
  content_type : 23,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 29,
  initComponent : function() {
    this.ls_detail_handler = Lino.contacts.PartnersByCity.detail;
    this.ls_insert_handler = Lino.contacts.PartnersByCity.insert;
    var ww = this.containing_window;
    var street315 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var street_no316 = new Ext.form.TextField({ "selectOnFocus": true, "boxMinWidth": Lino.chars2width(10), "maxLength": 10 });
    var street_box317 = new Ext.form.TextField({ "selectOnFocus": true, "boxMinWidth": Lino.chars2width(10), "maxLength": 10 });
    var addr2318 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var name319 = new Ext.form.TextField({ "selectOnFocus": true, "allowBlank": false, "maxLength": 200 });
    var language320 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "store": [ [ "de", "Deutsch" ], [ "fr", "Franz\u00f6sisch" ], [ "nl", "Niederl\u00e4ndisch" ] ], "allowBlank": false, "value": "de" });
    var id321 = new Ext.form.NumberField({ "selectOnFocus": true });
    var created322 = new Ext.form.DisplayField({ "disabled": true, "value": "<br>" });
    var modified323 = new Ext.form.DisplayField({ "disabled": true, "value": "<br>" });
    var country324 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/contacts/PartnersByCity/country", "method": "GET" }) }), "pageSize": 20, "emptyText": "Land ausw\u00e4hlen..." });
    var region325 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/contacts/PartnersByCity/region", "method": "GET" }) }), "pageSize": 20, "emptyText": "Ort ausw\u00e4hlen..." });
    var zip_code326 = new Ext.form.TextField({ "selectOnFocus": true, "boxMinWidth": Lino.chars2width(10), "maxLength": 10 });
    var addr1327 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var street_prefix328 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var email329 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 75 });
    var url330 = new Lino.URLField({ "selectOnFocus": true, "maxLength": 200 });
    var phone331 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var gsm332 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var fax333 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var remarks334 = new Ext.form.TextArea({ "selectOnFocus": true, "growMax": 2000 });
    var is_obsolete335 = new Ext.form.Checkbox({ "selectOnFocus": true, "checked": false });
    var activity336 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/contacts/PartnersByCity/activity", "method": "GET" }) }), "pageSize": 20, "emptyText": "Beruf ausw\u00e4hlen..." });
    var bank_account1337 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 40 });
    var bank_account2338 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 40 });
    this.before_row_edit = function(record) {
      region325.setContextValue('country',record ? record.data['countryHidden'] : undefined);
    };
    this.onRender = function(ct, position) {
      country324.on('change',Lino.chooser_handler(region325,'country'));
      Lino.contacts.PartnersByCity.GridPanel.superclass.onRender.call(this, ct, position);
    }
    this.ls_columns = [ { "colIndex": 0, "sortable": true, "header": "Stra\u00dfe", "editable": true, "tooltip": "(contacts.PartnersByCity.street) Name of street. Without house number.", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "street", "editor": street315 }, { "colIndex": 1, "sortable": true, "header": "Nr.", "editable": true, "tooltip": "(contacts.PartnersByCity.street_no) House number", "filter": { "type": "string" }, "width": Lino.chars2width(12), "dataIndex": "street_no", "editor": street_no316 }, { "colIndex": 2, "sortable": true, "header": "Box", "editable": true, "tooltip": "(contacts.PartnersByCity.street_box) Text to print after :attr:`steet_no` on the same line", "filter": { "type": "string" }, "width": Lino.chars2width(12), "dataIndex": "street_box", "editor": street_box317 }, { "colIndex": 3, "sortable": true, "header": "Adresszeile nach Stra\u00dfe", "editable": true, "tooltip": "(contacts.PartnersByCity.addr2) Address line to print below street line", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "addr2", "editor": addr2318 }, { "colIndex": 4, "sortable": true, "header": "Name", "editable": true, "tooltip": "(contacts.PartnersByCity.name) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "name", "editor": name319 }, { "colIndex": 5, "sortable": true, "header": "Sprache", "editable": true, "tooltip": "(contacts.PartnersByCity.language) Die Sprache, in der Dokumente ausgestellt werden sollen.", "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "language", "editor": language320 }, new Lino.NullNumberColumn({ "colIndex": 6, "sortable": true, "format": "0", "editable": true, "tooltip": "(contacts.PartnersByCity.id) ", "filter": { "type": "numeric" }, "header": "ID", "renderer": Lino.id_renderer, "editor": id321, "width": Lino.chars2width(6), "dataIndex": "id" }), { "colIndex": 7, "sortable": true, "header": "Erstellt", "editable": false, "tooltip": "(contacts.PartnersByCity.created) ", "width": Lino.chars2width(17), "dataIndex": "created", "hidden": true }, { "colIndex": 8, "sortable": true, "header": "Bearbeitet", "editable": false, "tooltip": "(contacts.PartnersByCity.modified) ", "width": Lino.chars2width(17), "dataIndex": "modified", "hidden": true }, { "colIndex": 9, "sortable": true, "header": "Land", "editable": true, "tooltip": "(contacts.PartnersByCity.country) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('countryHidden','Lino.countries.Countries.detail'), "editor": country324, "dataIndex": "country" }, { "colIndex": 10, "sortable": true, "header": "Region", "editable": true, "tooltip": "(contacts.PartnersByCity.region) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "region", "editor": region325 }, { "colIndex": 11, "sortable": true, "header": "Postleitzahl", "editable": true, "tooltip": "(contacts.PartnersByCity.zip_code) ", "filter": { "type": "string" }, "width": Lino.chars2width(12), "dataIndex": "zip_code", "editor": zip_code326 }, { "colIndex": 12, "sortable": true, "header": "Adresszeile vor Stra\u00dfe", "editable": true, "tooltip": "(contacts.PartnersByCity.addr1) Address line before street", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "addr1", "editor": addr1327 }, { "colIndex": 13, "sortable": true, "header": "Pr\u00e4fix Stra\u00dfe", "editable": true, "tooltip": "(contacts.PartnersByCity.street_prefix) Text to print before name of street, but to ignore for sorting.", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "street_prefix", "editor": street_prefix328 }, { "colIndex": 14, "sortable": true, "header": "E-Mail", "editable": true, "tooltip": "(contacts.PartnersByCity.email) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "email", "editor": email329 }, { "colIndex": 15, "sortable": true, "header": "URL", "editable": true, "tooltip": "(contacts.PartnersByCity.url) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "url", "editor": url330 }, { "colIndex": 16, "sortable": true, "header": "Telefon", "editable": true, "tooltip": "(contacts.PartnersByCity.phone) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "phone", "editor": phone331 }, { "colIndex": 17, "sortable": true, "header": "GSM", "editable": true, "tooltip": "(contacts.PartnersByCity.gsm) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "gsm", "editor": gsm332 }, { "colIndex": 18, "sortable": true, "header": "Fax", "editable": true, "tooltip": "(contacts.PartnersByCity.fax) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "fax", "editor": fax333 }, { "colIndex": 19, "sortable": false, "header": "Bemerkungen", "editable": true, "tooltip": "(contacts.PartnersByCity.remarks) ", "filter": { "type": "string" }, "width": Lino.chars2width(61), "renderer": Lino.text_renderer, "editor": remarks334, "dataIndex": "remarks" }, { "colIndex": 20, "sortable": false, "xtype": "checkcolumn", "header": "veraltet", "editable": true, "tooltip": "(contacts.PartnersByCity.is_obsolete) Altf\u00e4lle sind Partner, deren Stammdaten nicht mehr gepflegt werden und \nf\u00fcr neue Operationen nicht benutzt werden k\u00f6nnen.", "filter": { "type": "boolean" }, "width": Lino.chars2width(11), "dataIndex": "is_obsolete" }, { "colIndex": 21, "sortable": true, "header": "Beruf", "editable": true, "tooltip": "(contacts.PartnersByCity.activity) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "activity", "hidden": true, "editor": activity336 }, { "colIndex": 22, "sortable": true, "header": "Bankkonto 1", "editable": true, "tooltip": "(contacts.PartnersByCity.bank_account1) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "bank_account1", "hidden": true, "editor": bank_account1337 }, { "colIndex": 23, "sortable": true, "header": "Bankkonto 2", "editable": true, "tooltip": "(contacts.PartnersByCity.bank_account2) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "bank_account2", "hidden": true, "editor": bank_account2338 } ];
    Lino.contacts.PartnersByCity.GridPanel.superclass.initComponent.call(this);
  }
});


Lino.contacts.PartnersByCity.insertPanel = Ext.extend(Lino.contacts.Partners.InsertFormPanel,{
  empty_title: "Neu Partner",
  hide_navigator: true,
  ls_bbar_actions: [ { "itemId": "post", "menu_item_text": "Erstellen", "tooltip": "Datensatz erstellen und dann im Detail-Fenster \u00f6ffnen", "panel_btn_handler": function(panel){panel.save(null,true,'post')}, "text": "Erstellen", "overflowText": "Erstellen", "auto_save": false }, { "itemId": "poststay", "menu_item_text": "Erstellen ohne Detail", "tooltip": "Nach Erstellen des Datensatzes kein Detail-Fenster \u00f6ffnen", "panel_btn_handler": function(panel){panel.save(null,false,'poststay')}, "text": "Erstellen ohne Detail", "overflowText": "Erstellen ohne Detail", "auto_save": false } ],
  ls_url: "/contacts/PartnersByCity",
  action_name: "insert",
  initComponent : function() {
    this.ls_detail_handler = Lino.contacts.PartnersByCity.detail;
    this.ls_insert_handler = Lino.contacts.PartnersByCity.insert;
    Lino.contacts.PartnersByCity.insertPanel.superclass.initComponent.call(this);
  }
});

Lino.contacts.PartnersByCity.insert = new Lino.WindowAction({ "draggable": true, "width": Lino.chars2width(40), "autoHeight": true, "maximizable": true, "modal": true, "maximized": false },function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.contacts.PartnersByCity.insertPanel(p);
});

Lino.contacts.PartnersByCity.detailPanel = Ext.extend(Lino.contacts.Partners.DetailFormPanel,{
  empty_title: "Detail Partner",
  ls_bbar_actions: [ { "itemId": "put", "menu_item_text": "Speichern", "tooltip": "\u00c4nderungen in diesem Formular speichern", "panel_btn_handler": function(panel){panel.save(null,false,'put')}, "iconCls": "x-tbar-save", "overflowText": "Speichern", "auto_save": false }, { "itemId": "insert", "menu_item_text": "Neu", "must_save": true, "tooltip": "Neuen Datensatz erstellen", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-new", "overflowText": "Neu", "auto_save": true }, { "itemId": null, "menu_item_text": "L\u00f6schen", "tooltip": "Diesen Datensatz l\u00f6schen", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "L\u00f6schen", "auto_save": false } ],
  ls_url: "/contacts/PartnersByCity",
  action_name: "detail",
  initComponent : function() {
    this.ls_detail_handler = Lino.contacts.PartnersByCity.detail;
    this.ls_insert_handler = Lino.contacts.PartnersByCity.insert;
    Lino.contacts.PartnersByCity.detailPanel.superclass.initComponent.call(this);
  }
});

Lino.contacts.PartnersByCity.detail = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.contacts.PartnersByCity.detailPanel(p);
});
Lino.contacts.PartnersByCity.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.contacts.PartnersByCity.GridPanel(p);
});

// js_render_GridPanel_class contacts.PartnersByCountry
Lino.contacts.PartnersByCountry.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "Keine Daten anzuzeigen." },
  ls_url : "/contacts/PartnersByCountry",
  ls_bbar_actions : [ { "itemId": "insert", "menu_item_text": "Neu", "must_save": true, "tooltip": "Neuen Datensatz erstellen", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-new", "overflowText": "Neu", "auto_save": true }, { "itemId": "detail", "menu_item_text": "Detail", "tooltip": "Detail-Fenster auf diesem Datensatz \u00f6ffnen", "panel_btn_handler": Lino.show_detail, "iconCls": "x-tbar-detail", "overflowText": "Detail", "auto_save": true }, { "itemId": null, "menu_item_text": "L\u00f6schen", "tooltip": "Diesen Datensatz l\u00f6schen", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "L\u00f6schen", "auto_save": false } ],
  title : "Partner",
  page_length : 20,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "name": "city" }, 'cityHidden', { "name": "street" }, { "name": "street_no" }, { "name": "name" }, { "name": "language" }, 'languageHidden', { "type": "int", "name": "id" }, { "name": "created" }, { "name": "modified" }, { "name": "region" }, 'regionHidden', { "name": "zip_code" }, { "name": "addr1" }, { "name": "street_prefix" }, { "name": "street_box" }, { "name": "addr2" }, { "name": "email" }, { "name": "url" }, { "name": "phone" }, { "name": "gsm" }, { "name": "fax" }, { "name": "remarks" }, { "type": "boolean", "name": "is_obsolete" }, { "name": "activity" }, 'activityHidden', { "name": "bank_account1" }, { "name": "bank_account2" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 7,
  ls_grid_configs : [  ],
  content_type : 23,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 29,
  initComponent : function() {
    this.ls_detail_handler = Lino.contacts.PartnersByCountry.detail;
    this.ls_insert_handler = Lino.contacts.PartnersByCountry.insert;
    var ww = this.containing_window;
    var city2103 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "forceSelection": false, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/contacts/PartnersByCountry/city", "method": "GET" }) }), "pageSize": 20, "emptyText": "Ort ausw\u00e4hlen..." });
    var street2104 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var street_no2105 = new Ext.form.TextField({ "selectOnFocus": true, "boxMinWidth": Lino.chars2width(10), "maxLength": 10 });
    var name2106 = new Ext.form.TextField({ "selectOnFocus": true, "allowBlank": false, "maxLength": 200 });
    var language2107 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "store": [ [ "de", "Deutsch" ], [ "fr", "Franz\u00f6sisch" ], [ "nl", "Niederl\u00e4ndisch" ] ], "allowBlank": false, "value": "de" });
    var id2108 = new Ext.form.NumberField({ "selectOnFocus": true });
    var created2109 = new Ext.form.DisplayField({ "disabled": true, "value": "<br>" });
    var modified2110 = new Ext.form.DisplayField({ "disabled": true, "value": "<br>" });
    var region2111 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/contacts/PartnersByCountry/region", "method": "GET" }) }), "pageSize": 20, "emptyText": "Ort ausw\u00e4hlen..." });
    var zip_code2112 = new Ext.form.TextField({ "selectOnFocus": true, "boxMinWidth": Lino.chars2width(10), "maxLength": 10 });
    var addr12113 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var street_prefix2114 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var street_box2115 = new Ext.form.TextField({ "selectOnFocus": true, "boxMinWidth": Lino.chars2width(10), "maxLength": 10 });
    var addr22116 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var email2117 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 75 });
    var url2118 = new Lino.URLField({ "selectOnFocus": true, "maxLength": 200 });
    var phone2119 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var gsm2120 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var fax2121 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var remarks2122 = new Ext.form.TextArea({ "selectOnFocus": true, "growMax": 2000 });
    var is_obsolete2123 = new Ext.form.Checkbox({ "selectOnFocus": true, "checked": false });
    var activity2124 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/contacts/PartnersByCountry/activity", "method": "GET" }) }), "pageSize": 20, "emptyText": "Beruf ausw\u00e4hlen..." });
    var bank_account12125 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 40 });
    var bank_account22126 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 40 });
    this.before_row_edit = function(record) {
      var bp = this.get_base_params();
      city2103.setContextValue('mk',bp['mk']);
      city2103.setContextValue('mt',bp['mt']);
      city2103.setContextValue('region',record ? record.data['regionHidden'] : undefined);
      var bp = this.get_base_params();
      region2111.setContextValue('mk',bp['mk']);
      region2111.setContextValue('mt',bp['mt']);
    };
    this.onRender = function(ct, position) {
      region2111.on('change',Lino.chooser_handler(city2103,'region'));
      Lino.contacts.PartnersByCountry.GridPanel.superclass.onRender.call(this, ct, position);
    }
    this.ls_columns = [ { "colIndex": 0, "sortable": true, "header": "Ort", "editable": true, "tooltip": "(contacts.PartnersByCountry.city) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "city", "editor": city2103 }, { "colIndex": 1, "sortable": true, "header": "Stra\u00dfe", "editable": true, "tooltip": "(contacts.PartnersByCountry.street) Name of street. Without house number.", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "street", "editor": street2104 }, { "colIndex": 2, "sortable": true, "header": "Nr.", "editable": true, "tooltip": "(contacts.PartnersByCountry.street_no) House number", "filter": { "type": "string" }, "width": Lino.chars2width(12), "dataIndex": "street_no", "editor": street_no2105 }, { "colIndex": 3, "sortable": true, "header": "Name", "editable": true, "tooltip": "(contacts.PartnersByCountry.name) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "name", "editor": name2106 }, { "colIndex": 4, "sortable": true, "header": "Sprache", "editable": true, "tooltip": "(contacts.PartnersByCountry.language) Die Sprache, in der Dokumente ausgestellt werden sollen.", "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "language", "editor": language2107 }, new Lino.NullNumberColumn({ "colIndex": 5, "sortable": true, "format": "0", "editable": true, "tooltip": "(contacts.PartnersByCountry.id) ", "filter": { "type": "numeric" }, "header": "ID", "renderer": Lino.id_renderer, "editor": id2108, "width": Lino.chars2width(6), "dataIndex": "id" }), { "colIndex": 6, "sortable": true, "header": "Erstellt", "editable": false, "tooltip": "(contacts.PartnersByCountry.created) ", "width": Lino.chars2width(17), "dataIndex": "created", "hidden": true }, { "colIndex": 7, "sortable": true, "header": "Bearbeitet", "editable": false, "tooltip": "(contacts.PartnersByCountry.modified) ", "width": Lino.chars2width(17), "dataIndex": "modified", "hidden": true }, { "colIndex": 8, "sortable": true, "header": "Region", "editable": true, "tooltip": "(contacts.PartnersByCountry.region) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "region", "editor": region2111 }, { "colIndex": 9, "sortable": true, "header": "Postleitzahl", "editable": true, "tooltip": "(contacts.PartnersByCountry.zip_code) ", "filter": { "type": "string" }, "width": Lino.chars2width(12), "dataIndex": "zip_code", "editor": zip_code2112 }, { "colIndex": 10, "sortable": true, "header": "Adresszeile vor Stra\u00dfe", "editable": true, "tooltip": "(contacts.PartnersByCountry.addr1) Address line before street", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "addr1", "editor": addr12113 }, { "colIndex": 11, "sortable": true, "header": "Pr\u00e4fix Stra\u00dfe", "editable": true, "tooltip": "(contacts.PartnersByCountry.street_prefix) Text to print before name of street, but to ignore for sorting.", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "street_prefix", "editor": street_prefix2114 }, { "colIndex": 12, "sortable": true, "header": "Box", "editable": true, "tooltip": "(contacts.PartnersByCountry.street_box) Text to print after :attr:`steet_no` on the same line", "filter": { "type": "string" }, "width": Lino.chars2width(12), "dataIndex": "street_box", "editor": street_box2115 }, { "colIndex": 13, "sortable": true, "header": "Adresszeile nach Stra\u00dfe", "editable": true, "tooltip": "(contacts.PartnersByCountry.addr2) Address line to print below street line", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "addr2", "editor": addr22116 }, { "colIndex": 14, "sortable": true, "header": "E-Mail", "editable": true, "tooltip": "(contacts.PartnersByCountry.email) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "email", "editor": email2117 }, { "colIndex": 15, "sortable": true, "header": "URL", "editable": true, "tooltip": "(contacts.PartnersByCountry.url) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "url", "editor": url2118 }, { "colIndex": 16, "sortable": true, "header": "Telefon", "editable": true, "tooltip": "(contacts.PartnersByCountry.phone) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "phone", "editor": phone2119 }, { "colIndex": 17, "sortable": true, "header": "GSM", "editable": true, "tooltip": "(contacts.PartnersByCountry.gsm) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "gsm", "editor": gsm2120 }, { "colIndex": 18, "sortable": true, "header": "Fax", "editable": true, "tooltip": "(contacts.PartnersByCountry.fax) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "fax", "editor": fax2121 }, { "colIndex": 19, "sortable": false, "header": "Bemerkungen", "editable": true, "tooltip": "(contacts.PartnersByCountry.remarks) ", "filter": { "type": "string" }, "width": Lino.chars2width(61), "renderer": Lino.text_renderer, "editor": remarks2122, "dataIndex": "remarks" }, { "colIndex": 20, "sortable": false, "xtype": "checkcolumn", "header": "veraltet", "editable": true, "tooltip": "(contacts.PartnersByCountry.is_obsolete) Altf\u00e4lle sind Partner, deren Stammdaten nicht mehr gepflegt werden und \nf\u00fcr neue Operationen nicht benutzt werden k\u00f6nnen.", "filter": { "type": "boolean" }, "width": Lino.chars2width(11), "dataIndex": "is_obsolete" }, { "colIndex": 21, "sortable": true, "header": "Beruf", "editable": true, "tooltip": "(contacts.PartnersByCountry.activity) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "activity", "hidden": true, "editor": activity2124 }, { "colIndex": 22, "sortable": true, "header": "Bankkonto 1", "editable": true, "tooltip": "(contacts.PartnersByCountry.bank_account1) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "bank_account1", "hidden": true, "editor": bank_account12125 }, { "colIndex": 23, "sortable": true, "header": "Bankkonto 2", "editable": true, "tooltip": "(contacts.PartnersByCountry.bank_account2) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "bank_account2", "hidden": true, "editor": bank_account22126 } ];
    Lino.contacts.PartnersByCountry.GridPanel.superclass.initComponent.call(this);
  }
});


Lino.contacts.PartnersByCountry.insertPanel = Ext.extend(Lino.contacts.Partners.InsertFormPanel,{
  empty_title: "Neu Partner",
  hide_navigator: true,
  ls_bbar_actions: [ { "itemId": "post", "menu_item_text": "Erstellen", "tooltip": "Datensatz erstellen und dann im Detail-Fenster \u00f6ffnen", "panel_btn_handler": function(panel){panel.save(null,true,'post')}, "text": "Erstellen", "overflowText": "Erstellen", "auto_save": false }, { "itemId": "poststay", "menu_item_text": "Erstellen ohne Detail", "tooltip": "Nach Erstellen des Datensatzes kein Detail-Fenster \u00f6ffnen", "panel_btn_handler": function(panel){panel.save(null,false,'poststay')}, "text": "Erstellen ohne Detail", "overflowText": "Erstellen ohne Detail", "auto_save": false } ],
  ls_url: "/contacts/PartnersByCountry",
  action_name: "insert",
  initComponent : function() {
    this.ls_detail_handler = Lino.contacts.PartnersByCountry.detail;
    this.ls_insert_handler = Lino.contacts.PartnersByCountry.insert;
    Lino.contacts.PartnersByCountry.insertPanel.superclass.initComponent.call(this);
  }
});

Lino.contacts.PartnersByCountry.insert = new Lino.WindowAction({ "draggable": true, "width": Lino.chars2width(40), "autoHeight": true, "maximizable": true, "modal": true, "maximized": false },function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.contacts.PartnersByCountry.insertPanel(p);
});

Lino.contacts.PartnersByCountry.detailPanel = Ext.extend(Lino.contacts.Partners.DetailFormPanel,{
  empty_title: "Detail Partner",
  ls_bbar_actions: [ { "itemId": "put", "menu_item_text": "Speichern", "tooltip": "\u00c4nderungen in diesem Formular speichern", "panel_btn_handler": function(panel){panel.save(null,false,'put')}, "iconCls": "x-tbar-save", "overflowText": "Speichern", "auto_save": false }, { "itemId": "insert", "menu_item_text": "Neu", "must_save": true, "tooltip": "Neuen Datensatz erstellen", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-new", "overflowText": "Neu", "auto_save": true }, { "itemId": null, "menu_item_text": "L\u00f6schen", "tooltip": "Diesen Datensatz l\u00f6schen", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "L\u00f6schen", "auto_save": false } ],
  ls_url: "/contacts/PartnersByCountry",
  action_name: "detail",
  initComponent : function() {
    this.ls_detail_handler = Lino.contacts.PartnersByCountry.detail;
    this.ls_insert_handler = Lino.contacts.PartnersByCountry.insert;
    Lino.contacts.PartnersByCountry.detailPanel.superclass.initComponent.call(this);
  }
});

Lino.contacts.PartnersByCountry.detail = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.contacts.PartnersByCountry.detailPanel(p);
});
Lino.contacts.PartnersByCountry.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.contacts.PartnersByCountry.GridPanel(p);
});

// js_render_GridPanel_class contacts.RolesByCompany
Lino.contacts.RolesByCompany.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "forceFit": true, "emptyText": "Keine Daten anzuzeigen." },
  ls_url : "/contacts/RolesByCompany",
  ls_bbar_actions : [ { "itemId": null, "menu_item_text": "L\u00f6schen", "tooltip": "Diesen Datensatz l\u00f6schen", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "L\u00f6schen", "auto_save": false } ],
  title : "Kontaktpersonen",
  page_length : 20,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "name": "person" }, 'personHidden', { "name": "type" }, 'typeHidden', { "type": "int", "name": "id" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 4,
  ls_grid_configs : [  ],
  content_type : 22,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 6,
  initComponent : function() {
    var ww = this.containing_window;
    var person664 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/contacts/RolesByCompany/person", "method": "GET" }) }), "allowBlank": false, "pageSize": 20, "emptyText": "Person ausw\u00e4hlen..." });
    var type665 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/contacts/RolesByCompany/type", "method": "GET" }) }), "pageSize": 20, "emptyText": "Funktion ausw\u00e4hlen..." });
    var id666 = new Ext.form.NumberField({ "selectOnFocus": true });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ { "colIndex": 0, "sortable": true, "header": "Person", "editable": true, "tooltip": "(contacts.RolesByCompany.person) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('personHidden','Lino.contacts.Persons.detail'), "editor": person664, "dataIndex": "person" }, { "colIndex": 1, "sortable": true, "header": "Funktion", "editable": true, "tooltip": "(contacts.RolesByCompany.type) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "type", "editor": type665 }, new Lino.NullNumberColumn({ "colIndex": 2, "sortable": true, "format": "0", "editable": true, "tooltip": "(contacts.RolesByCompany.id) ", "filter": { "type": "numeric" }, "header": "ID", "renderer": Lino.id_renderer, "hidden": true, "editor": id666, "width": Lino.chars2width(6), "dataIndex": "id" }) ];
    Lino.contacts.RolesByCompany.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.contacts.RolesByCompany.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.contacts.RolesByCompany.GridPanel(p);
});

// js_render_GridPanel_class contacts.RolesByPerson
Lino.contacts.RolesByPerson.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "forceFit": true, "emptyText": "Keine Daten anzuzeigen." },
  ls_url : "/contacts/RolesByPerson",
  ls_bbar_actions : [ { "itemId": null, "menu_item_text": "L\u00f6schen", "tooltip": "Diesen Datensatz l\u00f6schen", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "L\u00f6schen", "auto_save": false } ],
  title : "Kontaktperson f\u00fcr",
  page_length : 20,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "name": "company" }, 'companyHidden', { "name": "type" }, 'typeHidden', { "type": "int", "name": "id" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 4,
  ls_grid_configs : [  ],
  content_type : 22,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 6,
  initComponent : function() {
    var ww = this.containing_window;
    var company872 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/contacts/RolesByPerson/company", "method": "GET" }) }), "allowBlank": false, "pageSize": 20, "emptyText": "Organisation ausw\u00e4hlen..." });
    var type873 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/contacts/RolesByPerson/type", "method": "GET" }) }), "pageSize": 20, "emptyText": "Funktion ausw\u00e4hlen..." });
    var id874 = new Ext.form.NumberField({ "selectOnFocus": true });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ { "colIndex": 0, "sortable": true, "header": "Organisation", "editable": true, "tooltip": "(contacts.RolesByPerson.company) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('companyHidden','Lino.contacts.Companies.detail'), "editor": company872, "dataIndex": "company" }, { "colIndex": 1, "sortable": true, "header": "Funktion", "editable": true, "tooltip": "(contacts.RolesByPerson.type) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "type", "editor": type873 }, new Lino.NullNumberColumn({ "colIndex": 2, "sortable": true, "format": "0", "editable": true, "tooltip": "(contacts.RolesByPerson.id) ", "filter": { "type": "numeric" }, "header": "ID", "renderer": Lino.id_renderer, "hidden": true, "editor": id874, "width": Lino.chars2width(6), "dataIndex": "id" }) ];
    Lino.contacts.RolesByPerson.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.contacts.RolesByPerson.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.contacts.RolesByPerson.GridPanel(p);
});

// js_render_GridPanel_class outbox.RecipientsByMail
Lino.outbox.RecipientsByMail.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "Keine Daten anzuzeigen." },
  ls_url : "/outbox/RecipientsByMail",
  ls_bbar_actions : [ { "itemId": null, "menu_item_text": "L\u00f6schen", "tooltip": "Diesen Datensatz l\u00f6schen", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "L\u00f6schen", "auto_save": false } ],
  title : "Empf\u00e4nger",
  page_length : 20,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "name": "partner" }, 'partnerHidden', { "name": "address" }, { "name": "name" }, { "name": "type" }, 'typeHidden', { "type": "int", "name": "id" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 6,
  ls_grid_configs : [  ],
  content_type : 28,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 8,
  initComponent : function() {
    var ww = this.containing_window;
    var partner738 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/outbox/RecipientsByMail/partner", "method": "GET" }) }), "pageSize": 20, "emptyText": "Partner ausw\u00e4hlen..." });
    var address739 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 75 });
    var name740 = new Ext.form.TextField({ "selectOnFocus": true, "allowBlank": false, "maxLength": 200 });
    var type741 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "forceSelection": true, "allowBlank": false, "store": Lino.outbox.RecipientType });
    var id742 = new Ext.form.NumberField({ "selectOnFocus": true });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ { "colIndex": 0, "sortable": true, "header": "Partner", "editable": true, "tooltip": "(outbox.RecipientsByMail.partner) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('partnerHidden','Lino.contacts.Partners.detail'), "editor": partner738, "dataIndex": "partner" }, { "colIndex": 1, "sortable": true, "header": "Adresse", "editable": true, "tooltip": "(outbox.RecipientsByMail.address) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "address", "editor": address739 }, { "colIndex": 2, "sortable": true, "header": "Name", "editable": true, "tooltip": "(outbox.RecipientsByMail.name) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "name", "editor": name740 }, { "colIndex": 3, "sortable": true, "header": "Empf\u00e4ngerart", "editable": true, "tooltip": "(outbox.RecipientsByMail.type) ", "filter": { "type": "string" }, "width": Lino.chars2width(11), "dataIndex": "type", "editor": type741 }, new Lino.NullNumberColumn({ "colIndex": 4, "sortable": true, "format": "0", "editable": true, "tooltip": "(outbox.RecipientsByMail.id) ", "filter": { "type": "numeric" }, "header": "ID", "renderer": Lino.id_renderer, "editor": id742, "width": Lino.chars2width(6), "dataIndex": "id" }) ];
    Lino.outbox.RecipientsByMail.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.outbox.RecipientsByMail.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.outbox.RecipientsByMail.GridPanel(p);
});

// js_render_GridPanel_class outbox.MailsByUser
Lino.outbox.MailsByUser.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "Keine Daten anzuzeigen." },
  ls_url : "/outbox/MailsByUser",
  ls_bbar_actions : [ { "itemId": "insert", "menu_item_text": "Neu", "must_save": true, "tooltip": "Neuen Datensatz erstellen", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-new", "overflowText": "Neu", "auto_save": true }, { "itemId": "detail", "menu_item_text": "Detail", "tooltip": "Detail-Fenster auf diesem Datensatz \u00f6ffnen", "panel_btn_handler": Lino.show_detail, "iconCls": "x-tbar-detail", "overflowText": "Detail", "auto_save": true }, { "itemId": null, "menu_item_text": "L\u00f6schen", "tooltip": "Diesen Datensatz l\u00f6schen", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "L\u00f6schen", "auto_save": false }, { "itemId": "do_print", "menu_item_text": "Drucken", "must_save": true, "tooltip": "Drucken", "panel_btn_handler": Lino.row_action_handler('do_print','GET'), "iconCls": "x-tbar-print", "overflowText": "Drucken", "auto_save": true }, { "itemId": "send_mail", "menu_item_text": "E-Mail senden", "must_save": true, "tooltip": "E-Mail senden", "panel_btn_handler": Lino.row_action_handler('send_mail','GET'), "iconCls": "x-tbar-email_send", "overflowText": "E-Mail senden", "auto_save": true } ],
  title : "E-Mail-Ausgang",
  page_length : 20,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "name": "sent" }, { "name": "subject" }, { "name": "recipients" }, { "type": "int", "name": "id" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 3,
  ls_grid_configs : [  ],
  content_type : 27,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 5,
  initComponent : function() {
    this.ls_detail_handler = Lino.outbox.MailsByUser.detail;
    this.ls_insert_handler = Lino.outbox.MailsByUser.insert;
    var ww = this.containing_window;
    var sent2128 = new Ext.form.DisplayField({ "disabled": true, "value": "<br>" });
    var subject2129 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var recipients_htmlbox2130 = new Lino.HtmlBoxPanel({ "layout": "fit", "name": "recipients", "containing_panel": this, "items": new Ext.BoxComponent({autoScroll:true}), "title": "Empf\u00e4nger", "master_panel": this, "value": "<br/>", "always_enabled": true, "bodyStyle": "overflow-x:hidden" });
    this.before_row_edit = function(record) {
      recipients_htmlbox2130.refresh();
    };
    this.ls_columns = [ { "width": Lino.chars2width(17), "colIndex": 0, "sortable": true, "dataIndex": "sent", "header": "sent", "editable": false, "tooltip": "(outbox.MailsByUser.sent) " }, { "colIndex": 1, "sortable": true, "header": "Betreff", "editable": true, "tooltip": "(outbox.MailsByUser.subject) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "subject", "editor": subject2129 }, { "width": Lino.chars2width(31), "colIndex": 2, "sortable": false, "dataIndex": "recipients", "header": "Empf\u00e4nger", "editable": false, "tooltip": "(outbox.MailsByUser.recipients) " } ];
    Lino.outbox.MailsByUser.GridPanel.superclass.initComponent.call(this);
  }
});


Lino.outbox.MailsByUser.insertPanel = Ext.extend(Lino.outbox.MailsByUser.InsertFormPanel,{
  empty_title: "Neu E-Mail-Ausgang",
  hide_navigator: true,
  ls_bbar_actions: [ { "itemId": "post", "menu_item_text": "Erstellen", "tooltip": "Datensatz erstellen und dann im Detail-Fenster \u00f6ffnen", "panel_btn_handler": function(panel){panel.save(null,true,'post')}, "text": "Erstellen", "overflowText": "Erstellen", "auto_save": false }, { "itemId": "poststay", "menu_item_text": "Erstellen ohne Detail", "tooltip": "Nach Erstellen des Datensatzes kein Detail-Fenster \u00f6ffnen", "panel_btn_handler": function(panel){panel.save(null,false,'poststay')}, "text": "Erstellen ohne Detail", "overflowText": "Erstellen ohne Detail", "auto_save": false } ],
  ls_url: "/outbox/MailsByUser",
  action_name: "insert",
  initComponent : function() {
    this.ls_detail_handler = Lino.outbox.MailsByUser.detail;
    this.ls_insert_handler = Lino.outbox.MailsByUser.insert;
    Lino.outbox.MailsByUser.insertPanel.superclass.initComponent.call(this);
  }
});

Lino.outbox.MailsByUser.insert = new Lino.WindowAction({ "draggable": true, "width": Lino.chars2width(60), "maximizable": true, "modal": true, "maximized": false, "height": Lino.rows2height(20) },function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.outbox.MailsByUser.insertPanel(p);
});

Lino.outbox.MailsByUser.detailPanel = Ext.extend(Lino.outbox.MailsByUser.DetailFormPanel,{
  empty_title: "Detail E-Mail-Ausgang",
  ls_bbar_actions: [ { "itemId": "put", "menu_item_text": "Speichern", "tooltip": "\u00c4nderungen in diesem Formular speichern", "panel_btn_handler": function(panel){panel.save(null,false,'put')}, "iconCls": "x-tbar-save", "overflowText": "Speichern", "auto_save": false }, { "itemId": "insert", "menu_item_text": "Neu", "must_save": true, "tooltip": "Neuen Datensatz erstellen", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-new", "overflowText": "Neu", "auto_save": true }, { "itemId": null, "menu_item_text": "L\u00f6schen", "tooltip": "Diesen Datensatz l\u00f6schen", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "L\u00f6schen", "auto_save": false }, { "itemId": "do_print", "menu_item_text": "Drucken", "must_save": true, "tooltip": "Drucken", "panel_btn_handler": Lino.row_action_handler('do_print','GET'), "iconCls": "x-tbar-print", "overflowText": "Drucken", "auto_save": true }, { "itemId": "send_mail", "menu_item_text": "E-Mail senden", "must_save": true, "tooltip": "E-Mail senden", "panel_btn_handler": Lino.row_action_handler('send_mail','GET'), "iconCls": "x-tbar-email_send", "overflowText": "E-Mail senden", "auto_save": true } ],
  ls_url: "/outbox/MailsByUser",
  action_name: "detail",
  initComponent : function() {
    this.ls_detail_handler = Lino.outbox.MailsByUser.detail;
    this.ls_insert_handler = Lino.outbox.MailsByUser.insert;
    Lino.outbox.MailsByUser.detailPanel.superclass.initComponent.call(this);
  }
});

Lino.outbox.MailsByUser.detail = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.outbox.MailsByUser.detailPanel(p);
});
Lino.outbox.MailsByUser.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.outbox.MailsByUser.GridPanel(p);
});

// js_render_GridPanel_class outbox.MailsByProject
Lino.outbox.MailsByProject.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "Keine Daten anzuzeigen." },
  ls_url : "/outbox/MailsByProject",
  ls_bbar_actions : [ { "itemId": "insert", "menu_item_text": "Neu", "must_save": true, "tooltip": "Neuen Datensatz erstellen", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-new", "overflowText": "Neu", "auto_save": true }, { "itemId": "detail", "menu_item_text": "Detail", "tooltip": "Detail-Fenster auf diesem Datensatz \u00f6ffnen", "panel_btn_handler": Lino.show_detail, "iconCls": "x-tbar-detail", "overflowText": "Detail", "auto_save": true }, { "itemId": null, "menu_item_text": "L\u00f6schen", "tooltip": "Diesen Datensatz l\u00f6schen", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "L\u00f6schen", "auto_save": false }, { "itemId": "do_print", "menu_item_text": "Drucken", "must_save": true, "tooltip": "Drucken", "panel_btn_handler": Lino.row_action_handler('do_print','GET'), "iconCls": "x-tbar-print", "overflowText": "Drucken", "auto_save": true }, { "itemId": "send_mail", "menu_item_text": "E-Mail senden", "must_save": true, "tooltip": "E-Mail senden", "panel_btn_handler": Lino.row_action_handler('send_mail','GET'), "iconCls": "x-tbar-email_send", "overflowText": "E-Mail senden", "auto_save": true } ],
  title : "E-Mail-Ausgang",
  page_length : 20,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "type": "date", "name": "date", "dateFormat": "d.m.Y" }, { "name": "subject" }, { "name": "recipients" }, { "name": "user" }, 'userHidden', { "type": "int", "name": "id" }, { "name": "owner_type" }, 'owner_typeHidden', { "name": "owner_id" }, 'owner_idHidden', { "name": "body" }, { "name": "sent" }, { "name": "owner" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 5,
  ls_grid_configs : [  ],
  content_type : 27,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 14,
  initComponent : function() {
    this.ls_detail_handler = Lino.outbox.MailsByProject.detail;
    this.ls_insert_handler = Lino.outbox.MailsByProject.insert;
    var ww = this.containing_window;
    var date1670 = new Lino.DateField({ "selectOnFocus": true, "allowBlank": false });
    var subject1671 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var recipients_htmlbox1672 = new Lino.HtmlBoxPanel({ "layout": "fit", "name": "recipients", "containing_panel": this, "items": new Ext.BoxComponent({autoScroll:true}), "title": "Empf\u00e4nger", "master_panel": this, "value": "<br/>", "always_enabled": true, "bodyStyle": "overflow-x:hidden" });
    var user1673 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/outbox/MailsByProject/user", "method": "GET" }) }), "pageSize": 20, "emptyText": "Benutzer ausw\u00e4hlen..." });
    var id1674 = new Ext.form.NumberField({ "selectOnFocus": true });
    var owner_type1675 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/outbox/MailsByProject/owner_type", "method": "GET" }) }), "pageSize": 20, "emptyText": "Inhaltstyp ausw\u00e4hlen..." });
    var owner_id1676 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/outbox/MailsByProject/owner_id", "method": "GET" }) }) });
    var body1677 = new Lino.RichTextPanel({ "selectOnFocus": true, "containing_panel": this, "title": "Inhalt" });
    var sent1678 = new Ext.form.DisplayField({ "disabled": true, "value": "<br>" });
    var owner_disp1679 = new Ext.form.DisplayField({ "disabled": true });
    this.before_row_edit = function(record) {
      recipients_htmlbox1672.refresh();
      owner_id1676.setContextValue('owner_type',record ? record.data['owner_typeHidden'] : undefined);
      body1677.refresh();
    };
    this.onRender = function(ct, position) {
      owner_type1675.on('change',Lino.chooser_handler(owner_id1676,'owner_type'));
      Lino.outbox.MailsByProject.GridPanel.superclass.onRender.call(this, ct, position);
    }
    this.ls_columns = [ { "colIndex": 0, "sortable": true, "xtype": "datecolumn", "format": "d.m.Y", "editable": true, "tooltip": "(outbox.MailsByProject.date) \n        The official date to be printed on the document.\n        ", "filter": { "type": "date", "dateFormat": "d.m.Y" }, "header": "Datum", "dataIndex": "date", "width": Lino.chars2width(9), "editor": date1670 }, { "colIndex": 1, "sortable": true, "header": "Betreff", "editable": true, "tooltip": "(outbox.MailsByProject.subject) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "subject", "editor": subject1671 }, { "width": Lino.chars2width(31), "colIndex": 2, "sortable": false, "dataIndex": "recipients", "header": "Empf\u00e4nger", "editable": false, "tooltip": "(outbox.MailsByProject.recipients) " }, { "colIndex": 3, "sortable": true, "header": "Absender", "editable": true, "tooltip": "(outbox.MailsByProject.user) ", "filter": { "type": "string" }, "width": Lino.chars2width(16), "dataIndex": "user", "editor": user1673 }, new Lino.NullNumberColumn({ "colIndex": 4, "sortable": true, "format": "0", "editable": true, "tooltip": "(outbox.MailsByProject.id) ", "filter": { "type": "numeric" }, "header": "ID", "renderer": Lino.id_renderer, "editor": id1674, "width": Lino.chars2width(6), "dataIndex": "id" }), { "colIndex": 5, "sortable": true, "header": "Verkn\u00fcpft mit (Modell)", "editable": true, "tooltip": "(outbox.MailsByProject.owner_type) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "owner_type", "editor": owner_type1675 }, { "colIndex": 6, "sortable": true, "header": "Verkn\u00fcpft mit (Objekt)", "editable": true, "tooltip": "(outbox.MailsByProject.owner_id) ", "filter": { "type": "string" }, "width": Lino.chars2width(11), "dataIndex": "owner_id", "editor": owner_id1676 }, { "colIndex": 7, "sortable": false, "width": Lino.chars2width(61), "editable": true, "tooltip": "(outbox.MailsByProject.body) ", "filter": { "type": "string" }, "header": "body", "renderer": Lino.text_renderer, "hidden": true, "editor": body1677, "dataIndex": "body" }, { "width": Lino.chars2width(17), "colIndex": 8, "sortable": true, "dataIndex": "sent", "header": "sent", "editable": false, "tooltip": "(outbox.MailsByProject.sent) " }, { "width": Lino.chars2width(11), "colIndex": 9, "sortable": false, "dataIndex": "owner", "header": "Verkn\u00fcpft mit", "editable": false, "tooltip": "(outbox.MailsByProject.owner) " } ];
    Lino.outbox.MailsByProject.GridPanel.superclass.initComponent.call(this);
  }
});


Lino.outbox.MailsByProject.insertPanel = Ext.extend(Lino.outbox.MailsByUser.InsertFormPanel,{
  empty_title: "Neu E-Mail-Ausgang",
  hide_navigator: true,
  ls_bbar_actions: [ { "itemId": "post", "menu_item_text": "Erstellen", "tooltip": "Datensatz erstellen und dann im Detail-Fenster \u00f6ffnen", "panel_btn_handler": function(panel){panel.save(null,true,'post')}, "text": "Erstellen", "overflowText": "Erstellen", "auto_save": false }, { "itemId": "poststay", "menu_item_text": "Erstellen ohne Detail", "tooltip": "Nach Erstellen des Datensatzes kein Detail-Fenster \u00f6ffnen", "panel_btn_handler": function(panel){panel.save(null,false,'poststay')}, "text": "Erstellen ohne Detail", "overflowText": "Erstellen ohne Detail", "auto_save": false } ],
  ls_url: "/outbox/MailsByProject",
  action_name: "insert",
  initComponent : function() {
    this.ls_detail_handler = Lino.outbox.MailsByProject.detail;
    this.ls_insert_handler = Lino.outbox.MailsByProject.insert;
    Lino.outbox.MailsByProject.insertPanel.superclass.initComponent.call(this);
  }
});

Lino.outbox.MailsByProject.insert = new Lino.WindowAction({ "draggable": true, "width": Lino.chars2width(60), "maximizable": true, "modal": true, "maximized": false, "height": Lino.rows2height(20) },function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.outbox.MailsByProject.insertPanel(p);
});

Lino.outbox.MailsByProject.detailPanel = Ext.extend(Lino.outbox.MailsByUser.DetailFormPanel,{
  empty_title: "Detail E-Mail-Ausgang",
  ls_bbar_actions: [ { "itemId": "put", "menu_item_text": "Speichern", "tooltip": "\u00c4nderungen in diesem Formular speichern", "panel_btn_handler": function(panel){panel.save(null,false,'put')}, "iconCls": "x-tbar-save", "overflowText": "Speichern", "auto_save": false }, { "itemId": "insert", "menu_item_text": "Neu", "must_save": true, "tooltip": "Neuen Datensatz erstellen", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-new", "overflowText": "Neu", "auto_save": true }, { "itemId": null, "menu_item_text": "L\u00f6schen", "tooltip": "Diesen Datensatz l\u00f6schen", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "L\u00f6schen", "auto_save": false }, { "itemId": "do_print", "menu_item_text": "Drucken", "must_save": true, "tooltip": "Drucken", "panel_btn_handler": Lino.row_action_handler('do_print','GET'), "iconCls": "x-tbar-print", "overflowText": "Drucken", "auto_save": true }, { "itemId": "send_mail", "menu_item_text": "E-Mail senden", "must_save": true, "tooltip": "E-Mail senden", "panel_btn_handler": Lino.row_action_handler('send_mail','GET'), "iconCls": "x-tbar-email_send", "overflowText": "E-Mail senden", "auto_save": true } ],
  ls_url: "/outbox/MailsByProject",
  action_name: "detail",
  initComponent : function() {
    this.ls_detail_handler = Lino.outbox.MailsByProject.detail;
    this.ls_insert_handler = Lino.outbox.MailsByProject.insert;
    Lino.outbox.MailsByProject.detailPanel.superclass.initComponent.call(this);
  }
});

Lino.outbox.MailsByProject.detail = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.outbox.MailsByProject.detailPanel(p);
});
Lino.outbox.MailsByProject.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.outbox.MailsByProject.GridPanel(p);
});

// js_render_GridPanel_class outbox.SentByPartner
Lino.outbox.SentByPartner.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "Keine Daten anzuzeigen." },
  ls_url : "/outbox/SentByPartner",
  ls_bbar_actions : [ { "itemId": "insert", "menu_item_text": "Neu", "must_save": true, "tooltip": "Neuen Datensatz erstellen", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-new", "overflowText": "Neu", "auto_save": true }, { "itemId": "detail", "menu_item_text": "Detail", "tooltip": "Detail-Fenster auf diesem Datensatz \u00f6ffnen", "panel_btn_handler": Lino.show_detail, "iconCls": "x-tbar-detail", "overflowText": "Detail", "auto_save": true }, { "itemId": null, "menu_item_text": "L\u00f6schen", "tooltip": "Diesen Datensatz l\u00f6schen", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "L\u00f6schen", "auto_save": false }, { "itemId": "do_print", "menu_item_text": "Drucken", "must_save": true, "tooltip": "Drucken", "panel_btn_handler": Lino.row_action_handler('do_print','GET'), "iconCls": "x-tbar-print", "overflowText": "Drucken", "auto_save": true }, { "itemId": "send_mail", "menu_item_text": "E-Mail senden", "must_save": true, "tooltip": "E-Mail senden", "panel_btn_handler": Lino.row_action_handler('send_mail','GET'), "iconCls": "x-tbar-email_send", "overflowText": "E-Mail senden", "auto_save": true } ],
  title : "E-Mail-Ausgang",
  page_length : 20,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "name": "sent" }, { "name": "subject" }, { "name": "user" }, 'userHidden', { "type": "int", "name": "id" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 4,
  ls_grid_configs : [  ],
  content_type : 27,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 6,
  initComponent : function() {
    this.ls_detail_handler = Lino.outbox.SentByPartner.detail;
    this.ls_insert_handler = Lino.outbox.SentByPartner.insert;
    var ww = this.containing_window;
    var sent2132 = new Ext.form.DisplayField({ "disabled": true, "value": "<br>" });
    var subject2133 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var user2134 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/outbox/SentByPartner/user", "method": "GET" }) }), "pageSize": 20, "emptyText": "Benutzer ausw\u00e4hlen..." });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ { "width": Lino.chars2width(17), "colIndex": 0, "sortable": true, "dataIndex": "sent", "header": "sent", "editable": false, "tooltip": "(outbox.SentByPartner.sent) " }, { "colIndex": 1, "sortable": true, "header": "Betreff", "editable": true, "tooltip": "(outbox.SentByPartner.subject) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "subject", "editor": subject2133 }, { "colIndex": 2, "sortable": true, "header": "Absender", "editable": true, "tooltip": "(outbox.SentByPartner.user) ", "filter": { "type": "string" }, "width": Lino.chars2width(16), "dataIndex": "user", "editor": user2134 } ];
    Lino.outbox.SentByPartner.GridPanel.superclass.initComponent.call(this);
  }
});


Lino.outbox.SentByPartner.insertPanel = Ext.extend(Lino.outbox.MailsByUser.InsertFormPanel,{
  empty_title: "Neu E-Mail-Ausgang",
  hide_navigator: true,
  ls_bbar_actions: [ { "itemId": "post", "menu_item_text": "Erstellen", "tooltip": "Datensatz erstellen und dann im Detail-Fenster \u00f6ffnen", "panel_btn_handler": function(panel){panel.save(null,true,'post')}, "text": "Erstellen", "overflowText": "Erstellen", "auto_save": false }, { "itemId": "poststay", "menu_item_text": "Erstellen ohne Detail", "tooltip": "Nach Erstellen des Datensatzes kein Detail-Fenster \u00f6ffnen", "panel_btn_handler": function(panel){panel.save(null,false,'poststay')}, "text": "Erstellen ohne Detail", "overflowText": "Erstellen ohne Detail", "auto_save": false } ],
  ls_url: "/outbox/SentByPartner",
  action_name: "insert",
  initComponent : function() {
    this.ls_detail_handler = Lino.outbox.SentByPartner.detail;
    this.ls_insert_handler = Lino.outbox.SentByPartner.insert;
    Lino.outbox.SentByPartner.insertPanel.superclass.initComponent.call(this);
  }
});

Lino.outbox.SentByPartner.insert = new Lino.WindowAction({ "draggable": true, "width": Lino.chars2width(60), "maximizable": true, "modal": true, "maximized": false, "height": Lino.rows2height(20) },function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.outbox.SentByPartner.insertPanel(p);
});

Lino.outbox.SentByPartner.detailPanel = Ext.extend(Lino.outbox.MailsByUser.DetailFormPanel,{
  empty_title: "Detail E-Mail-Ausgang",
  ls_bbar_actions: [ { "itemId": "put", "menu_item_text": "Speichern", "tooltip": "\u00c4nderungen in diesem Formular speichern", "panel_btn_handler": function(panel){panel.save(null,false,'put')}, "iconCls": "x-tbar-save", "overflowText": "Speichern", "auto_save": false }, { "itemId": "insert", "menu_item_text": "Neu", "must_save": true, "tooltip": "Neuen Datensatz erstellen", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-new", "overflowText": "Neu", "auto_save": true }, { "itemId": null, "menu_item_text": "L\u00f6schen", "tooltip": "Diesen Datensatz l\u00f6schen", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "L\u00f6schen", "auto_save": false }, { "itemId": "do_print", "menu_item_text": "Drucken", "must_save": true, "tooltip": "Drucken", "panel_btn_handler": Lino.row_action_handler('do_print','GET'), "iconCls": "x-tbar-print", "overflowText": "Drucken", "auto_save": true }, { "itemId": "send_mail", "menu_item_text": "E-Mail senden", "must_save": true, "tooltip": "E-Mail senden", "panel_btn_handler": Lino.row_action_handler('send_mail','GET'), "iconCls": "x-tbar-email_send", "overflowText": "E-Mail senden", "auto_save": true } ],
  ls_url: "/outbox/SentByPartner",
  action_name: "detail",
  initComponent : function() {
    this.ls_detail_handler = Lino.outbox.SentByPartner.detail;
    this.ls_insert_handler = Lino.outbox.SentByPartner.insert;
    Lino.outbox.SentByPartner.detailPanel.superclass.initComponent.call(this);
  }
});

Lino.outbox.SentByPartner.detail = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.outbox.SentByPartner.detailPanel(p);
});
Lino.outbox.SentByPartner.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.outbox.SentByPartner.GridPanel(p);
});

// js_render_GridPanel_class uploads.MyUploads
Lino.uploads.MyUploads.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "Keine Daten anzuzeigen." },
  ls_url : "/uploads/MyUploads",
  ls_bbar_actions : [ { "itemId": "insert", "menu_item_text": "Neu", "must_save": true, "tooltip": "Neuen Datensatz erstellen", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-new", "overflowText": "Neu", "auto_save": true }, { "itemId": "detail", "menu_item_text": "Detail", "tooltip": "Detail-Fenster auf diesem Datensatz \u00f6ffnen", "panel_btn_handler": Lino.show_detail, "iconCls": "x-tbar-detail", "overflowText": "Detail", "auto_save": true }, { "itemId": null, "menu_item_text": "L\u00f6schen", "tooltip": "Diesen Datensatz l\u00f6schen", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "L\u00f6schen", "auto_save": false } ],
  title : "Meine Uploads",
  page_length : 20,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "name": "file" }, { "name": "description" }, { "name": "user" }, 'userHidden', { "name": "owner" }, { "type": "int", "name": "id" }, { "name": "owner_type" }, 'owner_typeHidden', { "name": "owner_id" }, 'owner_idHidden', { "name": "created" }, { "name": "modified" }, { "name": "mimetype" }, { "name": "type" }, 'typeHidden', { "type": "date", "name": "valid_until", "dateFormat": "d.m.Y" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 5,
  ls_grid_configs : [  ],
  content_type : 26,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 17,
  initComponent : function() {
    this.ls_detail_handler = Lino.uploads.MyUploads.detail;
    this.ls_insert_handler = Lino.uploads.MyUploads.insert;
    var ww = this.containing_window;
    var file2136 = Lino.file_field_handler(this,{ "selectOnFocus": true, "allowBlank": false, "maxLength": 100 });
    var description2137 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var user2138 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/uploads/MyUploads/user", "method": "GET" }) }), "pageSize": 20, "emptyText": "Benutzer ausw\u00e4hlen..." });
    var owner_disp2139 = new Ext.form.DisplayField({ "disabled": true });
    var id2140 = new Ext.form.NumberField({ "selectOnFocus": true });
    var owner_type2141 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/uploads/MyUploads/owner_type", "method": "GET" }) }), "pageSize": 20, "emptyText": "Inhaltstyp ausw\u00e4hlen..." });
    var owner_id2142 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/uploads/MyUploads/owner_id", "method": "GET" }) }) });
    var created2143 = new Ext.form.DisplayField({ "disabled": true, "value": "<br>" });
    var modified2144 = new Ext.form.DisplayField({ "disabled": true, "value": "<br>" });
    var mimetype2145 = new Ext.form.TextField({ "disabled": true, "maxLength": 64 });
    var type2146 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/uploads/MyUploads/type", "method": "GET" }) }), "pageSize": 20, "emptyText": "Upload-Art ausw\u00e4hlen..." });
    var valid_until2147 = new Lino.DateField({ "selectOnFocus": true });
    this.before_row_edit = function(record) {
      owner_id2142.setContextValue('owner_type',record ? record.data['owner_typeHidden'] : undefined);
    };
    this.onRender = function(ct, position) {
      owner_type2141.on('change',Lino.chooser_handler(owner_id2142,'owner_type'));
      Lino.uploads.MyUploads.GridPanel.superclass.onRender.call(this, ct, position);
    }
    this.ls_columns = [ { "colIndex": 0, "sortable": true, "header": "Datei", "editable": true, "tooltip": "(uploads.MyUploads.file) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "file", "editor": file2136 }, { "colIndex": 1, "sortable": true, "header": "Beschreibung", "editable": true, "tooltip": "(uploads.MyUploads.description) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "description", "editor": description2137 }, { "colIndex": 2, "sortable": true, "header": "Autor", "editable": true, "tooltip": "(uploads.MyUploads.user) ", "filter": { "type": "string" }, "width": Lino.chars2width(16), "dataIndex": "user", "editor": user2138 }, { "width": Lino.chars2width(11), "colIndex": 3, "sortable": false, "dataIndex": "owner", "header": "Verkn\u00fcpft mit", "editable": false, "tooltip": "(uploads.MyUploads.owner) " }, new Lino.NullNumberColumn({ "colIndex": 4, "sortable": true, "format": "0", "editable": true, "tooltip": "(uploads.MyUploads.id) ", "filter": { "type": "numeric" }, "header": "ID", "renderer": Lino.id_renderer, "editor": id2140, "width": Lino.chars2width(6), "dataIndex": "id" }), { "colIndex": 5, "sortable": true, "header": "Verkn\u00fcpft mit (Modell)", "editable": true, "tooltip": "(uploads.MyUploads.owner_type) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "owner_type", "editor": owner_type2141 }, { "colIndex": 6, "sortable": true, "header": "Verkn\u00fcpft mit (Objekt)", "editable": true, "tooltip": "(uploads.MyUploads.owner_id) ", "filter": { "type": "string" }, "width": Lino.chars2width(11), "dataIndex": "owner_id", "editor": owner_id2142 }, { "width": Lino.chars2width(17), "colIndex": 7, "sortable": true, "dataIndex": "created", "header": "Erstellt", "editable": false, "tooltip": "(uploads.MyUploads.created) " }, { "width": Lino.chars2width(17), "colIndex": 8, "sortable": true, "dataIndex": "modified", "header": "Bearbeitet", "editable": false, "tooltip": "(uploads.MyUploads.modified) " }, { "colIndex": 9, "sortable": true, "header": "MIME-Art", "editable": false, "tooltip": "(uploads.MyUploads.mimetype) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "mimetype" }, { "colIndex": 10, "sortable": true, "header": "Upload-Art", "editable": true, "tooltip": "(uploads.MyUploads.type) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "type", "editor": type2146 }, { "colIndex": 11, "sortable": true, "xtype": "datecolumn", "format": "d.m.Y", "editable": true, "tooltip": "(uploads.MyUploads.valid_until) ", "filter": { "type": "date", "dateFormat": "d.m.Y" }, "header": "g\u00fcltig bis", "dataIndex": "valid_until", "width": Lino.chars2width(9), "editor": valid_until2147 } ];
    Lino.uploads.MyUploads.GridPanel.superclass.initComponent.call(this);
  }
});


Lino.uploads.MyUploads.insertPanel = Ext.extend(Lino.uploads.MyUploads.InsertFormPanel,{
  empty_title: "Neu Meine Uploads",
  hide_navigator: true,
  ls_bbar_actions: [ { "itemId": "post", "menu_item_text": "Erstellen", "tooltip": "Datensatz erstellen und dann im Detail-Fenster \u00f6ffnen", "panel_btn_handler": function(panel){panel.save(null,true,'post')}, "text": "Erstellen", "overflowText": "Erstellen", "auto_save": false }, { "itemId": "poststay", "menu_item_text": "Erstellen ohne Detail", "tooltip": "Nach Erstellen des Datensatzes kein Detail-Fenster \u00f6ffnen", "panel_btn_handler": function(panel){panel.save(null,false,'poststay')}, "text": "Erstellen ohne Detail", "overflowText": "Erstellen ohne Detail", "auto_save": false } ],
  ls_url: "/uploads/MyUploads",
  action_name: "insert",
  initComponent : function() {
    this.ls_detail_handler = Lino.uploads.MyUploads.detail;
    this.ls_insert_handler = Lino.uploads.MyUploads.insert;
    Lino.uploads.MyUploads.insertPanel.superclass.initComponent.call(this);
  }
});

Lino.uploads.MyUploads.insert = new Lino.WindowAction({ "draggable": true, "width": Lino.chars2width(60), "autoHeight": true, "maximizable": true, "modal": true, "maximized": false },function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.uploads.MyUploads.insertPanel(p);
});

Lino.uploads.MyUploads.detailPanel = Ext.extend(Lino.uploads.MyUploads.DetailFormPanel,{
  empty_title: "Detail Meine Uploads",
  ls_bbar_actions: [ { "itemId": "put", "menu_item_text": "Speichern", "tooltip": "\u00c4nderungen in diesem Formular speichern", "panel_btn_handler": function(panel){panel.save(null,false,'put')}, "iconCls": "x-tbar-save", "overflowText": "Speichern", "auto_save": false }, { "itemId": "insert", "menu_item_text": "Neu", "must_save": true, "tooltip": "Neuen Datensatz erstellen", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-new", "overflowText": "Neu", "auto_save": true }, { "itemId": null, "menu_item_text": "L\u00f6schen", "tooltip": "Diesen Datensatz l\u00f6schen", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "L\u00f6schen", "auto_save": false } ],
  ls_url: "/uploads/MyUploads",
  action_name: "detail",
  initComponent : function() {
    this.ls_detail_handler = Lino.uploads.MyUploads.detail;
    this.ls_insert_handler = Lino.uploads.MyUploads.insert;
    Lino.uploads.MyUploads.detailPanel.superclass.initComponent.call(this);
  }
});

Lino.uploads.MyUploads.detail = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.uploads.MyUploads.detailPanel(p);
});
Lino.uploads.MyUploads.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.uploads.MyUploads.GridPanel(p);
});

// js_render_GridPanel_class households.HouseholdsByType
Lino.households.HouseholdsByType.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "Keine Daten anzuzeigen." },
  ls_url : "/households/HouseholdsByType",
  ls_bbar_actions : [ { "itemId": "insert", "menu_item_text": "Neu", "must_save": true, "tooltip": "Neuen Datensatz erstellen", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-new", "overflowText": "Neu", "auto_save": true }, { "itemId": "detail", "menu_item_text": "Detail", "tooltip": "Detail-Fenster auf diesem Datensatz \u00f6ffnen", "panel_btn_handler": Lino.show_detail, "iconCls": "x-tbar-detail", "overflowText": "Detail", "auto_save": true }, { "itemId": null, "menu_item_text": "L\u00f6schen", "tooltip": "Diesen Datensatz l\u00f6schen", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "L\u00f6schen", "auto_save": false } ],
  title : "Haushalte",
  page_length : 20,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "name": "name" }, { "name": "email" }, { "name": "created" }, { "name": "modified" }, { "name": "country" }, 'countryHidden', { "name": "city" }, 'cityHidden', { "name": "region" }, 'regionHidden', { "name": "zip_code" }, { "name": "addr1" }, { "name": "street_prefix" }, { "name": "street" }, { "name": "street_no" }, { "name": "street_box" }, { "name": "addr2" }, { "name": "language" }, 'languageHidden', { "name": "url" }, { "name": "phone" }, { "name": "gsm" }, { "name": "fax" }, { "name": "remarks" }, { "type": "boolean", "name": "is_obsolete" }, { "name": "activity" }, 'activityHidden', { "name": "bank_account1" }, { "name": "bank_account2" }, { "name": "prefix" }, { "type": "int", "name": "id" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 30,
  ls_grid_configs : [  ],
  content_type : 41,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 32,
  initComponent : function() {
    this.ls_detail_handler = Lino.households.HouseholdsByType.detail;
    this.ls_insert_handler = Lino.households.HouseholdsByType.insert;
    var ww = this.containing_window;
    var name2149 = new Ext.form.TextField({ "selectOnFocus": true, "allowBlank": false, "maxLength": 200 });
    var email2150 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 75 });
    var created2151 = new Ext.form.DisplayField({ "disabled": true, "value": "<br>" });
    var modified2152 = new Ext.form.DisplayField({ "disabled": true, "value": "<br>" });
    var country2153 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/households/HouseholdsByType/country", "method": "GET" }) }), "pageSize": 20, "emptyText": "Land ausw\u00e4hlen..." });
    var city2154 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "forceSelection": false, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/households/HouseholdsByType/city", "method": "GET" }) }), "pageSize": 20, "emptyText": "Ort ausw\u00e4hlen..." });
    var region2155 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/households/HouseholdsByType/region", "method": "GET" }) }), "pageSize": 20, "emptyText": "Ort ausw\u00e4hlen..." });
    var zip_code2156 = new Ext.form.TextField({ "selectOnFocus": true, "boxMinWidth": Lino.chars2width(10), "maxLength": 10 });
    var addr12157 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var street_prefix2158 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var street2159 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var street_no2160 = new Ext.form.TextField({ "selectOnFocus": true, "boxMinWidth": Lino.chars2width(10), "maxLength": 10 });
    var street_box2161 = new Ext.form.TextField({ "selectOnFocus": true, "boxMinWidth": Lino.chars2width(10), "maxLength": 10 });
    var addr22162 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var language2163 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "store": [ [ "de", "Deutsch" ], [ "fr", "Franz\u00f6sisch" ], [ "nl", "Niederl\u00e4ndisch" ] ], "allowBlank": false, "value": "de" });
    var url2164 = new Lino.URLField({ "selectOnFocus": true, "maxLength": 200 });
    var phone2165 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var gsm2166 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var fax2167 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var remarks2168 = new Ext.form.TextArea({ "selectOnFocus": true, "growMax": 2000 });
    var is_obsolete2169 = new Ext.form.Checkbox({ "selectOnFocus": true, "checked": false });
    var activity2170 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/households/HouseholdsByType/activity", "method": "GET" }) }), "pageSize": 20, "emptyText": "Beruf ausw\u00e4hlen..." });
    var bank_account12171 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 40 });
    var bank_account22172 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 40 });
    var prefix2173 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var id2174 = new Ext.form.NumberField({ "selectOnFocus": true });
    this.before_row_edit = function(record) {
      city2154.setContextValue('country',record ? record.data['countryHidden'] : undefined);
      city2154.setContextValue('region',record ? record.data['regionHidden'] : undefined);
      region2155.setContextValue('country',record ? record.data['countryHidden'] : undefined);
    };
    this.onRender = function(ct, position) {
      country2153.on('change',Lino.chooser_handler(city2154,'country'));
      region2155.on('change',Lino.chooser_handler(city2154,'region'));
      country2153.on('change',Lino.chooser_handler(region2155,'country'));
      Lino.households.HouseholdsByType.GridPanel.superclass.onRender.call(this, ct, position);
    }
    this.ls_columns = [ { "colIndex": 0, "sortable": true, "header": "Name", "editable": true, "tooltip": "(households.HouseholdsByType.name) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "name", "editor": name2149 }, { "colIndex": 1, "sortable": true, "header": "E-Mail", "editable": true, "tooltip": "(households.HouseholdsByType.email) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "email", "editor": email2150 }, { "colIndex": 2, "sortable": true, "header": "Erstellt", "editable": false, "tooltip": "(households.HouseholdsByType.created) ", "width": Lino.chars2width(17), "dataIndex": "created", "hidden": true }, { "colIndex": 3, "sortable": true, "header": "Bearbeitet", "editable": false, "tooltip": "(households.HouseholdsByType.modified) ", "width": Lino.chars2width(17), "dataIndex": "modified", "hidden": true }, { "colIndex": 4, "sortable": true, "header": "Land", "editable": true, "tooltip": "(households.HouseholdsByType.country) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('countryHidden','Lino.countries.Countries.detail'), "editor": country2153, "dataIndex": "country" }, { "colIndex": 5, "sortable": true, "header": "Ort", "editable": true, "tooltip": "(households.HouseholdsByType.city) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "city", "editor": city2154 }, { "colIndex": 6, "sortable": true, "header": "Region", "editable": true, "tooltip": "(households.HouseholdsByType.region) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "region", "editor": region2155 }, { "colIndex": 7, "sortable": true, "header": "Postleitzahl", "editable": true, "tooltip": "(households.HouseholdsByType.zip_code) ", "filter": { "type": "string" }, "width": Lino.chars2width(12), "dataIndex": "zip_code", "editor": zip_code2156 }, { "colIndex": 8, "sortable": true, "header": "Adresszeile vor Stra\u00dfe", "editable": true, "tooltip": "(households.HouseholdsByType.addr1) Address line before street", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "addr1", "editor": addr12157 }, { "colIndex": 9, "sortable": true, "header": "Pr\u00e4fix Stra\u00dfe", "editable": true, "tooltip": "(households.HouseholdsByType.street_prefix) Text to print before name of street, but to ignore for sorting.", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "street_prefix", "editor": street_prefix2158 }, { "colIndex": 10, "sortable": true, "header": "Stra\u00dfe", "editable": true, "tooltip": "(households.HouseholdsByType.street) Name of street. Without house number.", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "street", "editor": street2159 }, { "colIndex": 11, "sortable": true, "header": "Nr.", "editable": true, "tooltip": "(households.HouseholdsByType.street_no) House number", "filter": { "type": "string" }, "width": Lino.chars2width(12), "dataIndex": "street_no", "editor": street_no2160 }, { "colIndex": 12, "sortable": true, "header": "Box", "editable": true, "tooltip": "(households.HouseholdsByType.street_box) Text to print after :attr:`steet_no` on the same line", "filter": { "type": "string" }, "width": Lino.chars2width(12), "dataIndex": "street_box", "editor": street_box2161 }, { "colIndex": 13, "sortable": true, "header": "Adresszeile nach Stra\u00dfe", "editable": true, "tooltip": "(households.HouseholdsByType.addr2) Address line to print below street line", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "addr2", "editor": addr22162 }, { "colIndex": 14, "sortable": true, "header": "Sprache", "editable": true, "tooltip": "(households.HouseholdsByType.language) Die Sprache, in der Dokumente ausgestellt werden sollen.", "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "language", "editor": language2163 }, { "colIndex": 15, "sortable": true, "header": "URL", "editable": true, "tooltip": "(households.HouseholdsByType.url) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "url", "editor": url2164 }, { "colIndex": 16, "sortable": true, "header": "Telefon", "editable": true, "tooltip": "(households.HouseholdsByType.phone) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "phone", "editor": phone2165 }, { "colIndex": 17, "sortable": true, "header": "GSM", "editable": true, "tooltip": "(households.HouseholdsByType.gsm) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "gsm", "editor": gsm2166 }, { "colIndex": 18, "sortable": true, "header": "Fax", "editable": true, "tooltip": "(households.HouseholdsByType.fax) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "fax", "editor": fax2167 }, { "colIndex": 19, "sortable": false, "header": "Bemerkungen", "editable": true, "tooltip": "(households.HouseholdsByType.remarks) ", "filter": { "type": "string" }, "width": Lino.chars2width(61), "renderer": Lino.text_renderer, "editor": remarks2168, "dataIndex": "remarks" }, { "colIndex": 20, "sortable": false, "xtype": "checkcolumn", "header": "veraltet", "editable": true, "tooltip": "(households.HouseholdsByType.is_obsolete) Altf\u00e4lle sind Partner, deren Stammdaten nicht mehr gepflegt werden und \nf\u00fcr neue Operationen nicht benutzt werden k\u00f6nnen.", "filter": { "type": "boolean" }, "width": Lino.chars2width(11), "dataIndex": "is_obsolete" }, { "colIndex": 21, "sortable": true, "header": "Beruf", "editable": true, "tooltip": "(households.HouseholdsByType.activity) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "activity", "hidden": true, "editor": activity2170 }, { "colIndex": 22, "sortable": true, "header": "Bankkonto 1", "editable": true, "tooltip": "(households.HouseholdsByType.bank_account1) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "bank_account1", "hidden": true, "editor": bank_account12171 }, { "colIndex": 23, "sortable": true, "header": "Bankkonto 2", "editable": true, "tooltip": "(households.HouseholdsByType.bank_account2) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "bank_account2", "hidden": true, "editor": bank_account22172 }, { "colIndex": 24, "sortable": true, "header": "prefix", "editable": true, "tooltip": "(households.HouseholdsByType.prefix) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "prefix", "editor": prefix2173 }, new Lino.NullNumberColumn({ "colIndex": 25, "sortable": true, "format": "0", "editable": true, "tooltip": "(households.HouseholdsByType.id) ", "filter": { "type": "numeric" }, "header": "ID", "renderer": Lino.id_renderer, "editor": id2174, "width": Lino.chars2width(6), "dataIndex": "id" }) ];
    Lino.households.HouseholdsByType.GridPanel.superclass.initComponent.call(this);
  }
});


Lino.households.HouseholdsByType.insertPanel = Ext.extend(Lino.contacts.Partners.InsertFormPanel,{
  empty_title: "Neu Haushalte",
  hide_navigator: true,
  ls_bbar_actions: [ { "itemId": "post", "menu_item_text": "Erstellen", "tooltip": "Datensatz erstellen und dann im Detail-Fenster \u00f6ffnen", "panel_btn_handler": function(panel){panel.save(null,true,'post')}, "text": "Erstellen", "overflowText": "Erstellen", "auto_save": false }, { "itemId": "poststay", "menu_item_text": "Erstellen ohne Detail", "tooltip": "Nach Erstellen des Datensatzes kein Detail-Fenster \u00f6ffnen", "panel_btn_handler": function(panel){panel.save(null,false,'poststay')}, "text": "Erstellen ohne Detail", "overflowText": "Erstellen ohne Detail", "auto_save": false } ],
  ls_url: "/households/HouseholdsByType",
  action_name: "insert",
  initComponent : function() {
    this.ls_detail_handler = Lino.households.HouseholdsByType.detail;
    this.ls_insert_handler = Lino.households.HouseholdsByType.insert;
    Lino.households.HouseholdsByType.insertPanel.superclass.initComponent.call(this);
  }
});

Lino.households.HouseholdsByType.insert = new Lino.WindowAction({ "draggable": true, "width": Lino.chars2width(40), "autoHeight": true, "maximizable": true, "modal": true, "maximized": false },function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.households.HouseholdsByType.insertPanel(p);
});

Lino.households.HouseholdsByType.detailPanel = Ext.extend(Lino.households.Households.DetailFormPanel,{
  empty_title: "Detail Haushalte",
  ls_bbar_actions: [ { "itemId": "put", "menu_item_text": "Speichern", "tooltip": "\u00c4nderungen in diesem Formular speichern", "panel_btn_handler": function(panel){panel.save(null,false,'put')}, "iconCls": "x-tbar-save", "overflowText": "Speichern", "auto_save": false }, { "itemId": "insert", "menu_item_text": "Neu", "must_save": true, "tooltip": "Neuen Datensatz erstellen", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-new", "overflowText": "Neu", "auto_save": true }, { "itemId": null, "menu_item_text": "L\u00f6schen", "tooltip": "Diesen Datensatz l\u00f6schen", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "L\u00f6schen", "auto_save": false } ],
  ls_url: "/households/HouseholdsByType",
  action_name: "detail",
  initComponent : function() {
    this.ls_detail_handler = Lino.households.HouseholdsByType.detail;
    this.ls_insert_handler = Lino.households.HouseholdsByType.insert;
    Lino.households.HouseholdsByType.detailPanel.superclass.initComponent.call(this);
  }
});

Lino.households.HouseholdsByType.detail = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.households.HouseholdsByType.detailPanel(p);
});
Lino.households.HouseholdsByType.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.households.HouseholdsByType.GridPanel(p);
});

// js_render_GridPanel_class households.MembersByHousehold
Lino.households.MembersByHousehold.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "Keine Daten anzuzeigen." },
  ls_url : "/households/MembersByHousehold",
  ls_bbar_actions : [ { "itemId": null, "menu_item_text": "L\u00f6schen", "tooltip": "Diesen Datensatz l\u00f6schen", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "L\u00f6schen", "auto_save": false } ],
  title : "Mitglieder",
  page_length : 20,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "name": "person" }, 'personHidden', { "name": "role" }, 'roleHidden', { "type": "date", "name": "start_date", "dateFormat": "d.m.Y" }, { "type": "date", "name": "end_date", "dateFormat": "d.m.Y" }, { "type": "int", "name": "id" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 6,
  ls_grid_configs : [  ],
  content_type : 39,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 8,
  initComponent : function() {
    var ww = this.containing_window;
    var person983 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/households/MembersByHousehold/person", "method": "GET" }) }), "allowBlank": false, "pageSize": 20, "emptyText": "Person ausw\u00e4hlen..." });
    var role984 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/households/MembersByHousehold/role", "method": "GET" }) }), "pageSize": 20, "emptyText": "Rolle in Haushalt ausw\u00e4hlen..." });
    var start_date985 = new Lino.DateField({ "selectOnFocus": true });
    var end_date986 = new Lino.DateField({ "selectOnFocus": true });
    var id987 = new Ext.form.NumberField({ "selectOnFocus": true });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ { "colIndex": 0, "sortable": true, "header": "Person", "editable": true, "tooltip": "(households.MembersByHousehold.person) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('personHidden','Lino.contacts.Persons.detail'), "editor": person983, "dataIndex": "person" }, { "colIndex": 1, "sortable": true, "header": "Rolle in Haushalt", "editable": true, "tooltip": "(households.MembersByHousehold.role) The Role of this Person in this Household.\nList of choices is configured in `Configure --> Households --> Roles`.\n", "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "role", "editor": role984 }, { "colIndex": 2, "sortable": true, "xtype": "datecolumn", "format": "d.m.Y", "editable": true, "tooltip": "(households.MembersByHousehold.start_date) ", "filter": { "type": "date", "dateFormat": "d.m.Y" }, "header": "From", "dataIndex": "start_date", "width": Lino.chars2width(9), "editor": start_date985 }, { "colIndex": 3, "sortable": true, "xtype": "datecolumn", "format": "d.m.Y", "editable": true, "tooltip": "(households.MembersByHousehold.end_date) ", "filter": { "type": "date", "dateFormat": "d.m.Y" }, "header": "Until", "dataIndex": "end_date", "width": Lino.chars2width(9), "editor": end_date986 }, new Lino.NullNumberColumn({ "colIndex": 4, "sortable": true, "format": "0", "editable": true, "tooltip": "(households.MembersByHousehold.id) ", "filter": { "type": "numeric" }, "header": "ID", "renderer": Lino.id_renderer, "editor": id987, "width": Lino.chars2width(6), "dataIndex": "id" }) ];
    Lino.households.MembersByHousehold.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.households.MembersByHousehold.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.households.MembersByHousehold.GridPanel(p);
});

// js_render_GridPanel_class households.MembersByPerson
Lino.households.MembersByPerson.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "forceFit": true, "emptyText": "Keine Daten anzuzeigen." },
  ls_url : "/households/MembersByPerson",
  ls_bbar_actions : [ { "itemId": null, "menu_item_text": "L\u00f6schen", "tooltip": "Diesen Datensatz l\u00f6schen", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "L\u00f6schen", "auto_save": false } ],
  title : "Mitglied von",
  page_length : 20,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "name": "household" }, 'householdHidden', { "name": "role" }, 'roleHidden', { "type": "date", "name": "start_date", "dateFormat": "d.m.Y" }, { "type": "date", "name": "end_date", "dateFormat": "d.m.Y" }, { "type": "int", "name": "id" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 6,
  ls_grid_configs : [  ],
  content_type : 39,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 8,
  initComponent : function() {
    var ww = this.containing_window;
    var household877 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/households/MembersByPerson/household", "method": "GET" }) }), "allowBlank": false, "pageSize": 20, "emptyText": "Haushalt ausw\u00e4hlen..." });
    var role878 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/households/MembersByPerson/role", "method": "GET" }) }), "pageSize": 20, "emptyText": "Rolle in Haushalt ausw\u00e4hlen..." });
    var start_date879 = new Lino.DateField({ "selectOnFocus": true });
    var end_date880 = new Lino.DateField({ "selectOnFocus": true });
    var id881 = new Ext.form.NumberField({ "selectOnFocus": true });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ { "colIndex": 0, "sortable": true, "header": "Haushalt", "editable": true, "tooltip": "(households.MembersByPerson.household) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('householdHidden','Lino.households.Households.detail'), "editor": household877, "dataIndex": "household" }, { "colIndex": 1, "sortable": true, "header": "Rolle in Haushalt", "editable": true, "tooltip": "(households.MembersByPerson.role) The Role of this Person in this Household.\nList of choices is configured in `Configure --> Households --> Roles`.\n", "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "role", "editor": role878 }, { "colIndex": 2, "sortable": true, "xtype": "datecolumn", "format": "d.m.Y", "editable": true, "tooltip": "(households.MembersByPerson.start_date) ", "filter": { "type": "date", "dateFormat": "d.m.Y" }, "header": "From", "dataIndex": "start_date", "width": Lino.chars2width(9), "editor": start_date879 }, { "colIndex": 3, "sortable": true, "xtype": "datecolumn", "format": "d.m.Y", "editable": true, "tooltip": "(households.MembersByPerson.end_date) ", "filter": { "type": "date", "dateFormat": "d.m.Y" }, "header": "Until", "dataIndex": "end_date", "width": Lino.chars2width(9), "editor": end_date880 }, new Lino.NullNumberColumn({ "colIndex": 4, "sortable": true, "format": "0", "editable": true, "tooltip": "(households.MembersByPerson.id) ", "filter": { "type": "numeric" }, "header": "ID", "renderer": Lino.id_renderer, "editor": id881, "width": Lino.chars2width(6), "dataIndex": "id" }) ];
    Lino.households.MembersByPerson.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.households.MembersByPerson.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.households.MembersByPerson.GridPanel(p);
});

// js_render_GridPanel_class households.MembersByRole
Lino.households.MembersByRole.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "Keine Daten anzuzeigen." },
  ls_url : "/households/MembersByRole",
  ls_bbar_actions : [ { "itemId": null, "menu_item_text": "L\u00f6schen", "tooltip": "Diesen Datensatz l\u00f6schen", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "L\u00f6schen", "auto_save": false } ],
  title : "Mitglieder",
  page_length : 20,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "name": "person" }, 'personHidden', { "name": "household" }, 'householdHidden', { "type": "date", "name": "start_date", "dateFormat": "d.m.Y" }, { "type": "date", "name": "end_date", "dateFormat": "d.m.Y" }, { "type": "int", "name": "id" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 6,
  ls_grid_configs : [  ],
  content_type : 39,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 8,
  initComponent : function() {
    var ww = this.containing_window;
    var person2176 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/households/MembersByRole/person", "method": "GET" }) }), "allowBlank": false, "pageSize": 20, "emptyText": "Person ausw\u00e4hlen..." });
    var household2177 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/households/MembersByRole/household", "method": "GET" }) }), "allowBlank": false, "pageSize": 20, "emptyText": "Haushalt ausw\u00e4hlen..." });
    var start_date2178 = new Lino.DateField({ "selectOnFocus": true });
    var end_date2179 = new Lino.DateField({ "selectOnFocus": true });
    var id2180 = new Ext.form.NumberField({ "selectOnFocus": true });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ { "colIndex": 0, "sortable": true, "header": "Person", "editable": true, "tooltip": "(households.MembersByRole.person) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('personHidden','Lino.contacts.Persons.detail'), "editor": person2176, "dataIndex": "person" }, { "colIndex": 1, "sortable": true, "header": "Haushalt", "editable": true, "tooltip": "(households.MembersByRole.household) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('householdHidden','Lino.households.Households.detail'), "editor": household2177, "dataIndex": "household" }, { "colIndex": 2, "sortable": true, "xtype": "datecolumn", "format": "d.m.Y", "editable": true, "tooltip": "(households.MembersByRole.start_date) ", "filter": { "type": "date", "dateFormat": "d.m.Y" }, "header": "From", "dataIndex": "start_date", "width": Lino.chars2width(9), "editor": start_date2178 }, { "colIndex": 3, "sortable": true, "xtype": "datecolumn", "format": "d.m.Y", "editable": true, "tooltip": "(households.MembersByRole.end_date) ", "filter": { "type": "date", "dateFormat": "d.m.Y" }, "header": "Until", "dataIndex": "end_date", "width": Lino.chars2width(9), "editor": end_date2179 }, new Lino.NullNumberColumn({ "colIndex": 4, "sortable": true, "format": "0", "editable": true, "tooltip": "(households.MembersByRole.id) ", "filter": { "type": "numeric" }, "header": "ID", "renderer": Lino.id_renderer, "editor": id2180, "width": Lino.chars2width(6), "dataIndex": "id" }) ];
    Lino.households.MembersByRole.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.households.MembersByRole.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.households.MembersByRole.GridPanel(p);
});

// js_render_GridPanel_class accounts.AccountsByGroup
Lino.accounts.AccountsByGroup.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "Keine Daten anzuzeigen." },
  ls_url : "/accounts/AccountsByGroup",
  ls_bbar_actions : [ { "itemId": "duplicate", "menu_item_text": "Duplizieren", "must_save": true, "tooltip": "Duplizieren", "panel_btn_handler": Lino.row_action_handler('duplicate','GET'), "iconCls": "x-tbar-duplicate", "overflowText": "Duplizieren", "auto_save": true }, { "itemId": null, "menu_item_text": "L\u00f6schen", "tooltip": "Diesen Datensatz l\u00f6schen", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "L\u00f6schen", "auto_save": false }, { "itemId": "move_up", "menu_item_text": "Rauf", "must_save": true, "tooltip": "Move this row one row upwards", "panel_btn_handler": Lino.row_action_handler('move_up','GET'), "iconCls": "x-tbar-moveup", "overflowText": "Rauf", "auto_save": true }, { "itemId": "move_down", "menu_item_text": "Down", "must_save": true, "tooltip": "Move this row one row downwards", "panel_btn_handler": Lino.row_action_handler('move_down','GET'), "iconCls": "x-tbar-movedown", "overflowText": "Down", "auto_save": true } ],
  title : "Konten",
  page_length : 20,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "name": "ref" }, { "name": "name" }, { "name": "name_fr" }, { "name": "name_nl" }, { "name": "default_amount" }, { "name": "periods" }, { "type": "boolean", "name": "required_for_household" }, { "type": "boolean", "name": "required_for_person" }, { "name": "group" }, 'groupHidden', { "type": "int", "name": "id" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 10,
  ls_grid_configs : [  ],
  content_type : 43,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 12,
  initComponent : function() {
    var ww = this.containing_window;
    var ref2182 = new Ext.form.TextField({ "selectOnFocus": true, "boxMinWidth": Lino.chars2width(5), "maxLength": 5 });
    var name2183 = new Ext.form.TextField({ "selectOnFocus": true, "allowBlank": false, "maxLength": 200 });
    var name_fr2184 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var name_nl2185 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var default_amount2186 = new Ext.form.NumberField({ "selectOnFocus": true, "decimalPrecision": 2, "allowBlank": true, "decimalSeparator": "," });
    var periods2187 = new Ext.form.NumberField({ "selectOnFocus": true, "allowBlank": true, "value": 1, "allowDecimals": false });
    var required_for_household2188 = new Ext.form.Checkbox({ "selectOnFocus": true, "checked": false });
    var required_for_person2189 = new Ext.form.Checkbox({ "selectOnFocus": true, "checked": false });
    var group2190 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/accounts/AccountsByGroup/group", "method": "GET" }) }), "allowBlank": false, "pageSize": 20, "emptyText": "Kontengruppe ausw\u00e4hlen..." });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ { "colIndex": 0, "sortable": true, "header": "ref", "editable": true, "tooltip": "(accounts.AccountsByGroup.ref) ", "filter": { "type": "string" }, "width": Lino.chars2width(7), "dataIndex": "ref", "editor": ref2182 }, { "colIndex": 1, "sortable": true, "header": "Bezeichnung", "editable": true, "tooltip": "(accounts.AccountsByGroup.name) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "name", "editor": name2183 }, { "colIndex": 2, "sortable": true, "header": "Bezeichnung (fr)", "editable": true, "tooltip": "(accounts.AccountsByGroup.name_fr) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "name_fr", "editor": name_fr2184 }, { "colIndex": 3, "sortable": true, "header": "Bezeichnung (nl)", "editable": true, "tooltip": "(accounts.AccountsByGroup.name_nl) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "name_nl", "editor": name_nl2185 }, new Lino.NullNumberColumn({ "colIndex": 4, "sortable": true, "header": "Standard-Betrag", "editable": true, "tooltip": "(accounts.AccountsByGroup.default_amount) ", "filter": { "type": "numeric" }, "width": Lino.chars2width(13), "dataIndex": "default_amount", "editor": default_amount2186 }), new Lino.NullNumberColumn({ "colIndex": 5, "sortable": true, "format": "0/i", "editable": true, "tooltip": "(accounts.AccountsByGroup.periods) For how many months the entered amount counts. \nFor example 1 means a monthly amount, 12 a yearly amount.", "filter": { "type": "numeric" }, "header": "Perioden", "dataIndex": "periods", "width": Lino.chars2width(6), "editor": periods2187 }), { "colIndex": 6, "sortable": false, "xtype": "checkcolumn", "header": "verpflichtend f\u00fcr Haushalte", "editable": true, "tooltip": "(accounts.AccountsByGroup.required_for_household) ", "filter": { "type": "boolean" }, "width": Lino.chars2width(11), "dataIndex": "required_for_household" }, { "colIndex": 7, "sortable": false, "xtype": "checkcolumn", "header": "verpflichtend f\u00fcr Personen", "editable": true, "tooltip": "(accounts.AccountsByGroup.required_for_person) ", "filter": { "type": "boolean" }, "width": Lino.chars2width(11), "dataIndex": "required_for_person" }, { "colIndex": 8, "sortable": true, "header": "Kontengruppe", "editable": true, "tooltip": "(accounts.AccountsByGroup.group) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "group", "editor": group2190 } ];
    Lino.accounts.AccountsByGroup.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.accounts.AccountsByGroup.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.accounts.AccountsByGroup.GridPanel(p);
});
Lino.accounts.AccountsByGroup.move_up = function(rp,pk) { 
  Lino.run_row_action(rp,"/accounts/AccountsByGroup",pk,"move_up");
};
Lino.accounts.AccountsByGroup.move_down = function(rp,pk) { 
  Lino.run_row_action(rp,"/accounts/AccountsByGroup",pk,"move_down");
};

// js_render_GridPanel_class pcsw.ClientsByNationality
Lino.pcsw.ClientsByNationality.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "Keine Daten anzuzeigen." },
  ls_url : "/pcsw/ClientsByNationality",
  ls_bbar_actions : [ { "itemId": "insert", "menu_item_text": "Neu", "must_save": true, "tooltip": "Neuen Datensatz erstellen", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-new", "overflowText": "Neu", "auto_save": true }, { "itemId": "detail", "menu_item_text": "Detail", "tooltip": "Detail-Fenster auf diesem Datensatz \u00f6ffnen", "panel_btn_handler": Lino.show_detail, "iconCls": "x-tbar-detail", "overflowText": "Detail", "auto_save": true }, { "itemId": null, "menu_item_text": "L\u00f6schen", "tooltip": "Diesen Datensatz l\u00f6schen", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "L\u00f6schen", "auto_save": false }, { "itemId": "print_eid_content", "menu_item_text": "eID-Inhalt", "must_save": true, "tooltip": "eID-Inhalt", "panel_btn_handler": Lino.row_action_handler('print_eid_content','GET'), "iconCls": "x-tbar-vcard", "overflowText": "eID-Inhalt", "auto_save": true }, { "itemId": "do_print", "menu_item_text": "Drucken", "must_save": true, "tooltip": "Drucken", "panel_btn_handler": Lino.row_action_handler('do_print','GET'), "iconCls": "x-tbar-print", "overflowText": "Drucken", "auto_save": true } ],
  title : "Klienten",
  page_length : 20,
  params_panel_hidden : true,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "name": "city" }, 'cityHidden', { "name": "street" }, { "name": "street_no" }, { "name": "street_box" }, { "name": "addr2" }, { "name": "name" }, { "name": "country" }, 'countryHidden', { "name": "language" }, 'languageHidden', { "type": "int", "name": "id" }, { "name": "created" }, { "name": "modified" }, { "name": "region" }, 'regionHidden', { "name": "zip_code" }, { "name": "addr1" }, { "name": "street_prefix" }, { "name": "email" }, { "name": "url" }, { "name": "phone" }, { "name": "gsm" }, { "name": "fax" }, { "name": "remarks" }, { "type": "boolean", "name": "is_obsolete" }, { "name": "activity" }, 'activityHidden', { "name": "bank_account1" }, { "name": "bank_account2" }, { "name": "first_name" }, { "name": "last_name" }, { "name": "gender" }, 'genderHidden', { "name": "birth_date" }, { "name": "title" }, { "name": "remarks2" }, { "name": "gesdos_id" }, { "type": "boolean", "name": "is_cpas" }, { "type": "boolean", "name": "is_senior" }, { "name": "group" }, 'groupHidden', { "name": "birth_place" }, { "name": "birth_country" }, 'birth_countryHidden', { "name": "civil_state" }, 'civil_stateHidden', { "name": "national_id" }, { "name": "health_insurance" }, 'health_insuranceHidden', { "name": "pharmacy" }, 'pharmacyHidden', { "name": "card_number" }, { "type": "date", "name": "card_valid_from", "dateFormat": "d.m.Y" }, { "type": "date", "name": "card_valid_until", "dateFormat": "d.m.Y" }, { "name": "card_type" }, 'card_typeHidden', { "name": "card_issuer" }, { "name": "noble_condition" }, { "name": "residence_type" }, 'residence_typeHidden', { "type": "date", "name": "in_belgium_since", "dateFormat": "d.m.Y" }, { "type": "date", "name": "unemployed_since", "dateFormat": "d.m.Y" }, { "type": "boolean", "name": "needs_residence_permit" }, { "type": "boolean", "name": "needs_work_permit" }, { "type": "date", "name": "work_permit_suspended_until", "dateFormat": "d.m.Y" }, { "name": "aid_type" }, 'aid_typeHidden', { "type": "boolean", "name": "income_ag" }, { "type": "boolean", "name": "income_wg" }, { "type": "boolean", "name": "income_kg" }, { "type": "boolean", "name": "income_rente" }, { "type": "boolean", "name": "income_misc" }, { "type": "boolean", "name": "is_seeking" }, { "type": "date", "name": "unavailable_until", "dateFormat": "d.m.Y" }, { "name": "unavailable_why" }, { "name": "obstacles" }, { "name": "skills" }, { "name": "job_agents" }, { "name": "job_office_contact" }, 'job_office_contactHidden', { "name": "client_state" }, 'client_stateHidden', { "name": "refusal_reason" }, 'refusal_reasonHidden', { "name": "broker" }, 'brokerHidden', { "name": "faculty" }, 'facultyHidden', { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 11,
  ls_grid_configs : [  ],
  content_type : 53,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 90,
  initComponent : function() {
    this.ls_detail_handler = Lino.pcsw.ClientsByNationality.detail;
    this.ls_insert_handler = Lino.pcsw.ClientsByNationality.insert;
    var ww = this.containing_window;
    var city2192 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "forceSelection": false, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/pcsw/ClientsByNationality/city", "method": "GET" }) }), "pageSize": 20, "emptyText": "Ort ausw\u00e4hlen..." });
    var street2193 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var street_no2194 = new Ext.form.TextField({ "selectOnFocus": true, "boxMinWidth": Lino.chars2width(10), "maxLength": 10 });
    var street_box2195 = new Ext.form.TextField({ "selectOnFocus": true, "boxMinWidth": Lino.chars2width(10), "maxLength": 10 });
    var addr22196 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var name2197 = new Ext.form.TextField({ "selectOnFocus": true, "allowBlank": false, "maxLength": 200 });
    var country2198 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/pcsw/ClientsByNationality/country", "method": "GET" }) }), "pageSize": 20, "emptyText": "Land ausw\u00e4hlen..." });
    var language2199 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "store": [ [ "de", "Deutsch" ], [ "fr", "Franz\u00f6sisch" ], [ "nl", "Niederl\u00e4ndisch" ] ], "allowBlank": false, "value": "de" });
    var id2200 = new Ext.form.NumberField({ "selectOnFocus": true });
    var created2201 = new Ext.form.DisplayField({ "disabled": true, "value": "<br>" });
    var modified2202 = new Ext.form.DisplayField({ "disabled": true, "value": "<br>" });
    var region2203 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/pcsw/ClientsByNationality/region", "method": "GET" }) }), "pageSize": 20, "emptyText": "Ort ausw\u00e4hlen..." });
    var zip_code2204 = new Ext.form.TextField({ "selectOnFocus": true, "boxMinWidth": Lino.chars2width(10), "maxLength": 10 });
    var addr12205 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var street_prefix2206 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var email2207 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 75 });
    var url2208 = new Lino.URLField({ "selectOnFocus": true, "maxLength": 200 });
    var phone2209 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var gsm2210 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var fax2211 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var remarks2212 = new Ext.form.TextArea({ "selectOnFocus": true, "growMax": 2000 });
    var is_obsolete2213 = new Ext.form.Checkbox({ "selectOnFocus": true, "checked": false });
    var activity2214 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/pcsw/ClientsByNationality/activity", "method": "GET" }) }), "pageSize": 20, "emptyText": "Beruf ausw\u00e4hlen..." });
    var bank_account12215 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 40 });
    var bank_account22216 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 40 });
    var first_name2217 = new Ext.form.TextField({ "selectOnFocus": true, "allowBlank": false, "maxLength": 200 });
    var last_name2218 = new Ext.form.TextField({ "selectOnFocus": true, "allowBlank": false, "maxLength": 200 });
    var gender2219 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "forceSelection": true, "store": [['','<br>']].concat(Lino.lino.Genders) });
    var birth_date2220 = new Lino.IncompleteDateField({ "selectOnFocus": true });
    var title2221 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var remarks22222 = new Ext.form.TextArea({ "selectOnFocus": true, "growMax": 2000 });
    var gesdos_id2223 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 40 });
    var is_cpas2224 = new Ext.form.Checkbox({ "selectOnFocus": true, "checked": false });
    var is_senior2225 = new Ext.form.Checkbox({ "selectOnFocus": true, "checked": false });
    var group2226 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/pcsw/ClientsByNationality/group", "method": "GET" }) }), "pageSize": 20, "emptyText": "Integrationsphase ausw\u00e4hlen..." });
    var birth_place2227 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var birth_country2228 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/pcsw/ClientsByNationality/birth_country", "method": "GET" }) }), "pageSize": 20, "emptyText": "Land ausw\u00e4hlen..." });
    var civil_state2229 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "forceSelection": true, "store": [['','<br>']].concat(Lino.pcsw.CivilState) });
    var national_id2230 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var health_insurance2231 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/pcsw/ClientsByNationality/health_insurance", "method": "GET" }) }), "pageSize": 20, "emptyText": "Organisation ausw\u00e4hlen..." });
    var pharmacy2232 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/pcsw/ClientsByNationality/pharmacy", "method": "GET" }) }), "pageSize": 20, "emptyText": "Organisation ausw\u00e4hlen..." });
    var card_number2233 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 20 });
    var card_valid_from2234 = new Lino.DateField({ "selectOnFocus": true });
    var card_valid_until2235 = new Lino.DateField({ "selectOnFocus": true });
    var card_type2236 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "forceSelection": true, "store": [['','<br>']].concat(Lino.pcsw.BeIdCardTypes) });
    var card_issuer2237 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 50 });
    var noble_condition2238 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 50 });
    var residence_type2239 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "forceSelection": true, "store": [['','<br>']].concat(Lino.pcsw.ResidenceType) });
    var in_belgium_since2240 = new Lino.DateField({ "selectOnFocus": true });
    var unemployed_since2241 = new Lino.DateField({ "selectOnFocus": true });
    var needs_residence_permit2242 = new Ext.form.Checkbox({ "selectOnFocus": true, "checked": false });
    var needs_work_permit2243 = new Ext.form.Checkbox({ "selectOnFocus": true, "checked": false });
    var work_permit_suspended_until2244 = new Lino.DateField({ "selectOnFocus": true });
    var aid_type2245 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/pcsw/ClientsByNationality/aid_type", "method": "GET" }) }), "pageSize": 20, "emptyText": "Sozialhilfeart ausw\u00e4hlen..." });
    var income_ag2246 = new Ext.form.Checkbox({ "selectOnFocus": true, "checked": false });
    var income_wg2247 = new Ext.form.Checkbox({ "selectOnFocus": true, "checked": false });
    var income_kg2248 = new Ext.form.Checkbox({ "selectOnFocus": true, "checked": false });
    var income_rente2249 = new Ext.form.Checkbox({ "selectOnFocus": true, "checked": false });
    var income_misc2250 = new Ext.form.Checkbox({ "selectOnFocus": true, "checked": false });
    var is_seeking2251 = new Ext.form.Checkbox({ "selectOnFocus": true, "checked": false });
    var unavailable_until2252 = new Lino.DateField({ "selectOnFocus": true });
    var unavailable_why2253 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 100 });
    var obstacles2254 = new Ext.form.TextArea({ "selectOnFocus": true, "growMax": 2000 });
    var skills2255 = new Ext.form.TextArea({ "selectOnFocus": true, "growMax": 2000 });
    var job_agents2256 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 100 });
    var job_office_contact2257 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/pcsw/ClientsByNationality/job_office_contact", "method": "GET" }) }), "pageSize": 20, "emptyText": "Kontaktperson ausw\u00e4hlen..." });
    var client_state2258 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "forceSelection": true, "allowBlank": false, "store": Lino.pcsw.ClientStates });
    var refusal_reason2259 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "forceSelection": true, "store": [['','<br>']].concat(Lino.pcsw.RefusalReasons) });
    var broker2260 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/pcsw/ClientsByNationality/broker", "method": "GET" }) }), "pageSize": 20, "emptyText": "Vermittler ausw\u00e4hlen..." });
    var faculty2261 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/pcsw/ClientsByNationality/faculty", "method": "GET" }) }), "pageSize": 20, "emptyText": "Fachbereich ausw\u00e4hlen..." });
    this.before_row_edit = function(record) {
      city2192.setContextValue('country',record ? record.data['countryHidden'] : undefined);
      city2192.setContextValue('region',record ? record.data['regionHidden'] : undefined);
      region2203.setContextValue('country',record ? record.data['countryHidden'] : undefined);
    };
    this.onRender = function(ct, position) {
      country2198.on('change',Lino.chooser_handler(city2192,'country'));
      region2203.on('change',Lino.chooser_handler(city2192,'region'));
      country2198.on('change',Lino.chooser_handler(region2203,'country'));
      Lino.pcsw.ClientsByNationality.GridPanel.superclass.onRender.call(this, ct, position);
    }
    this.ls_columns = [ { "colIndex": 0, "sortable": true, "header": "Ort", "editable": true, "tooltip": "(pcsw.ClientsByNationality.city) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "city", "editor": city2192 }, { "colIndex": 1, "sortable": true, "header": "Stra\u00dfe", "editable": true, "tooltip": "(pcsw.ClientsByNationality.street) Name of street. Without house number.", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "street", "editor": street2193 }, { "colIndex": 2, "sortable": true, "header": "Nr.", "editable": true, "tooltip": "(pcsw.ClientsByNationality.street_no) House number", "filter": { "type": "string" }, "width": Lino.chars2width(12), "dataIndex": "street_no", "editor": street_no2194 }, { "colIndex": 3, "sortable": true, "header": "Box", "editable": true, "tooltip": "(pcsw.ClientsByNationality.street_box) Text to print after :attr:`steet_no` on the same line", "filter": { "type": "string" }, "width": Lino.chars2width(12), "dataIndex": "street_box", "editor": street_box2195 }, { "colIndex": 4, "sortable": true, "header": "Adresszeile nach Stra\u00dfe", "editable": true, "tooltip": "(pcsw.ClientsByNationality.addr2) Address line to print below street line", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "addr2", "editor": addr22196 }, { "colIndex": 5, "sortable": true, "header": "Name", "editable": true, "tooltip": "(pcsw.ClientsByNationality.name) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "name", "editor": name2197 }, { "colIndex": 6, "sortable": true, "header": "Land", "editable": true, "tooltip": "(pcsw.ClientsByNationality.country) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('countryHidden','Lino.countries.Countries.detail'), "editor": country2198, "dataIndex": "country" }, { "colIndex": 7, "sortable": true, "header": "Sprache", "editable": true, "tooltip": "(pcsw.ClientsByNationality.language) Die Sprache, in der Dokumente ausgestellt werden sollen.", "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "language", "editor": language2199 }, new Lino.NullNumberColumn({ "colIndex": 8, "sortable": true, "format": "0", "editable": true, "tooltip": "(pcsw.ClientsByNationality.id) ", "filter": { "type": "numeric" }, "header": "ID", "renderer": Lino.id_renderer, "editor": id2200, "width": Lino.chars2width(6), "dataIndex": "id" }), { "colIndex": 9, "sortable": true, "header": "Erstellt", "editable": false, "tooltip": "(pcsw.ClientsByNationality.created) ", "width": Lino.chars2width(17), "dataIndex": "created", "hidden": true }, { "colIndex": 10, "sortable": true, "header": "Bearbeitet", "editable": false, "tooltip": "(pcsw.ClientsByNationality.modified) ", "width": Lino.chars2width(17), "dataIndex": "modified", "hidden": true }, { "colIndex": 11, "sortable": true, "header": "Region", "editable": true, "tooltip": "(pcsw.ClientsByNationality.region) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "region", "editor": region2203 }, { "colIndex": 12, "sortable": true, "header": "Postleitzahl", "editable": true, "tooltip": "(pcsw.ClientsByNationality.zip_code) ", "filter": { "type": "string" }, "width": Lino.chars2width(12), "dataIndex": "zip_code", "editor": zip_code2204 }, { "colIndex": 13, "sortable": true, "header": "Adresszeile vor Stra\u00dfe", "editable": true, "tooltip": "(pcsw.ClientsByNationality.addr1) Address line before street", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "addr1", "editor": addr12205 }, { "colIndex": 14, "sortable": true, "header": "Pr\u00e4fix Stra\u00dfe", "editable": true, "tooltip": "(pcsw.ClientsByNationality.street_prefix) Text to print before name of street, but to ignore for sorting.", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "street_prefix", "editor": street_prefix2206 }, { "colIndex": 15, "sortable": true, "header": "E-Mail", "editable": true, "tooltip": "(pcsw.ClientsByNationality.email) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "email", "editor": email2207 }, { "colIndex": 16, "sortable": true, "header": "URL", "editable": true, "tooltip": "(pcsw.ClientsByNationality.url) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "url", "editor": url2208 }, { "colIndex": 17, "sortable": true, "header": "Telefon", "editable": true, "tooltip": "(pcsw.ClientsByNationality.phone) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "phone", "editor": phone2209 }, { "colIndex": 18, "sortable": true, "header": "GSM", "editable": true, "tooltip": "(pcsw.ClientsByNationality.gsm) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "gsm", "editor": gsm2210 }, { "colIndex": 19, "sortable": true, "header": "Fax", "editable": true, "tooltip": "(pcsw.ClientsByNationality.fax) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "fax", "editor": fax2211 }, { "colIndex": 20, "sortable": false, "header": "Bemerkungen", "editable": true, "tooltip": "(pcsw.ClientsByNationality.remarks) ", "filter": { "type": "string" }, "width": Lino.chars2width(61), "renderer": Lino.text_renderer, "editor": remarks2212, "dataIndex": "remarks" }, { "colIndex": 21, "sortable": false, "xtype": "checkcolumn", "header": "veraltet", "editable": true, "tooltip": "(pcsw.ClientsByNationality.is_obsolete) Altf\u00e4lle sind Partner, deren Stammdaten nicht mehr gepflegt werden und \nf\u00fcr neue Operationen nicht benutzt werden k\u00f6nnen.", "filter": { "type": "boolean" }, "width": Lino.chars2width(11), "dataIndex": "is_obsolete" }, { "colIndex": 22, "sortable": true, "header": "Beruf", "editable": true, "tooltip": "(pcsw.ClientsByNationality.activity) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "activity", "hidden": true, "editor": activity2214 }, { "colIndex": 23, "sortable": true, "header": "Bankkonto 1", "editable": true, "tooltip": "(pcsw.ClientsByNationality.bank_account1) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "bank_account1", "hidden": true, "editor": bank_account12215 }, { "colIndex": 24, "sortable": true, "header": "Bankkonto 2", "editable": true, "tooltip": "(pcsw.ClientsByNationality.bank_account2) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "bank_account2", "hidden": true, "editor": bank_account22216 }, { "colIndex": 25, "sortable": true, "header": "Vorname", "editable": true, "tooltip": "(pcsw.ClientsByNationality.first_name) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "first_name", "editor": first_name2217 }, { "colIndex": 26, "sortable": true, "header": "Familienname", "editable": true, "tooltip": "(pcsw.ClientsByNationality.last_name) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "last_name", "editor": last_name2218 }, { "colIndex": 27, "sortable": true, "header": "Geschlecht", "editable": true, "tooltip": "(pcsw.ClientsByNationality.gender) ", "filter": { "type": "string" }, "width": Lino.chars2width(12), "dataIndex": "gender", "editor": gender2219 }, { "colIndex": 28, "sortable": true, "header": "Geburtsdatum", "editable": true, "tooltip": "(pcsw.ClientsByNationality.birth_date) Unkomplette Datumsangaben sind erlaubt, z.B. \"00.00.1980\" hei\u00dft \"irgendwann im Jahr 1980\", \"00.07.1980\" hei\u00dft \"im Juli 1980\"oder \"23.07.0000\" hei\u00dft \"an einem 23. Juli\".", "filter": { "type": "string" }, "width": Lino.chars2width(13), "dataIndex": "birth_date", "editor": birth_date2220 }, { "colIndex": 29, "sortable": true, "header": "Anrede", "editable": true, "tooltip": "(pcsw.ClientsByNationality.title) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "title", "editor": title2221 }, { "colIndex": 30, "sortable": false, "header": "Bemerkungen (Sozialsekretariat)", "editable": true, "tooltip": "(pcsw.ClientsByNationality.remarks2) ", "filter": { "type": "string" }, "width": Lino.chars2width(61), "renderer": Lino.text_renderer, "editor": remarks22222, "dataIndex": "remarks2" }, { "colIndex": 31, "sortable": true, "header": "Gesdos-Nr", "editable": true, "tooltip": "(pcsw.ClientsByNationality.gesdos_id) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "gesdos_id", "editor": gesdos_id2223 }, { "colIndex": 32, "sortable": false, "xtype": "checkcolumn", "header": "Sozialhilfeempf\u00e4nger", "editable": true, "tooltip": "(pcsw.ClientsByNationality.is_cpas) ", "filter": { "type": "boolean" }, "width": Lino.chars2width(11), "dataIndex": "is_cpas" }, { "colIndex": 33, "sortable": false, "xtype": "checkcolumn", "header": "Altenheim", "editable": true, "tooltip": "(pcsw.ClientsByNationality.is_senior) ", "filter": { "type": "boolean" }, "width": Lino.chars2width(11), "dataIndex": "is_senior" }, { "colIndex": 34, "sortable": true, "header": "Integrationsphase", "editable": true, "tooltip": "(pcsw.ClientsByNationality.group) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "group", "editor": group2226 }, { "colIndex": 35, "sortable": true, "header": "Geburtsort", "editable": true, "tooltip": "(pcsw.ClientsByNationality.birth_place) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "birth_place", "editor": birth_place2227 }, { "colIndex": 36, "sortable": true, "header": "Geburtsland", "editable": true, "tooltip": "(pcsw.ClientsByNationality.birth_country) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('birth_countryHidden','Lino.countries.Countries.detail'), "editor": birth_country2228, "dataIndex": "birth_country" }, { "colIndex": 37, "sortable": true, "header": "Zivilstand", "editable": true, "tooltip": "(pcsw.ClientsByNationality.civil_state) ", "filter": { "type": "string" }, "width": Lino.chars2width(44), "dataIndex": "civil_state", "editor": civil_state2229 }, { "colIndex": 38, "sortable": true, "header": "NR-Nummer", "editable": true, "tooltip": "(pcsw.ClientsByNationality.national_id) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "national_id", "editor": national_id2230 }, { "colIndex": 39, "sortable": true, "header": "Krankenkasse", "editable": true, "tooltip": "(pcsw.ClientsByNationality.health_insurance) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('health_insuranceHidden','Lino.contacts.Companies.detail'), "editor": health_insurance2231, "dataIndex": "health_insurance" }, { "colIndex": 40, "sortable": true, "header": "Apotheke", "editable": true, "tooltip": "(pcsw.ClientsByNationality.pharmacy) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('pharmacyHidden','Lino.contacts.Companies.detail'), "editor": pharmacy2232, "dataIndex": "pharmacy" }, { "colIndex": 41, "sortable": true, "header": "eID-Kartennummer", "editable": true, "tooltip": "(pcsw.ClientsByNationality.card_number) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "card_number", "editor": card_number2233 }, { "colIndex": 42, "sortable": true, "xtype": "datecolumn", "format": "d.m.Y", "editable": true, "tooltip": "(pcsw.ClientsByNationality.card_valid_from) ", "filter": { "type": "date", "dateFormat": "d.m.Y" }, "header": "ID-Karte g\u00fcltig von", "dataIndex": "card_valid_from", "width": Lino.chars2width(9), "editor": card_valid_from2234 }, { "colIndex": 43, "sortable": true, "xtype": "datecolumn", "format": "d.m.Y", "editable": true, "tooltip": "(pcsw.ClientsByNationality.card_valid_until) ", "filter": { "type": "date", "dateFormat": "d.m.Y" }, "header": "bis", "dataIndex": "card_valid_until", "width": Lino.chars2width(9), "editor": card_valid_until2235 }, { "colIndex": 44, "sortable": true, "header": "eID-Kartenart", "editable": true, "tooltip": "(pcsw.ClientsByNationality.card_type) ", "filter": { "type": "string" }, "width": Lino.chars2width(86), "dataIndex": "card_type", "editor": card_type2236 }, { "colIndex": 45, "sortable": true, "header": "eID-Karte ausgestellt durch", "editable": true, "tooltip": "(pcsw.ClientsByNationality.card_issuer) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "card_issuer", "editor": card_issuer2237 }, { "colIndex": 46, "sortable": true, "header": "Adelstitel", "editable": true, "tooltip": "(pcsw.ClientsByNationality.noble_condition) The eventual noble condition of this person. Imported from TIM.", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "noble_condition", "editor": noble_condition2238 }, { "colIndex": 47, "sortable": true, "header": "Register", "editable": true, "tooltip": "(pcsw.ClientsByNationality.residence_type) ", "filter": { "type": "string" }, "width": Lino.chars2width(24), "dataIndex": "residence_type", "editor": residence_type2239 }, { "colIndex": 48, "sortable": true, "xtype": "datecolumn", "format": "d.m.Y", "editable": true, "tooltip": "(pcsw.ClientsByNationality.in_belgium_since) ", "filter": { "type": "date", "dateFormat": "d.m.Y" }, "header": "Lebt in Belgien seit", "dataIndex": "in_belgium_since", "width": Lino.chars2width(9), "editor": in_belgium_since2240 }, { "colIndex": 49, "sortable": true, "xtype": "datecolumn", "format": "d.m.Y", "editable": true, "tooltip": "(pcsw.ClientsByNationality.unemployed_since) ", "filter": { "type": "date", "dateFormat": "d.m.Y" }, "header": "eingetragen seit", "dataIndex": "unemployed_since", "width": Lino.chars2width(9), "editor": unemployed_since2241 }, { "colIndex": 50, "sortable": false, "xtype": "checkcolumn", "header": "Braucht Aufenthaltserlaubnis", "editable": true, "tooltip": "(pcsw.ClientsByNationality.needs_residence_permit) ", "filter": { "type": "boolean" }, "width": Lino.chars2width(11), "dataIndex": "needs_residence_permit" }, { "colIndex": 51, "sortable": false, "xtype": "checkcolumn", "header": "Braucht Arb.Erl.", "editable": true, "tooltip": "(pcsw.ClientsByNationality.needs_work_permit) ", "filter": { "type": "boolean" }, "width": Lino.chars2width(11), "dataIndex": "needs_work_permit" }, { "colIndex": 52, "sortable": true, "xtype": "datecolumn", "format": "d.m.Y", "editable": true, "tooltip": "(pcsw.ClientsByNationality.work_permit_suspended_until) ", "filter": { "type": "date", "dateFormat": "d.m.Y" }, "header": "Wartezeit bis", "dataIndex": "work_permit_suspended_until", "width": Lino.chars2width(9), "editor": work_permit_suspended_until2244 }, { "colIndex": 53, "sortable": true, "header": "Sozialhilfeart", "editable": true, "tooltip": "(pcsw.ClientsByNationality.aid_type) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "aid_type", "editor": aid_type2245 }, { "colIndex": 54, "sortable": false, "xtype": "checkcolumn", "header": "Arbeitslosengeld", "editable": true, "tooltip": "(pcsw.ClientsByNationality.income_ag) ", "filter": { "type": "boolean" }, "width": Lino.chars2width(11), "dataIndex": "income_ag" }, { "colIndex": 55, "sortable": false, "xtype": "checkcolumn", "header": "Wartegeld", "editable": true, "tooltip": "(pcsw.ClientsByNationality.income_wg) ", "filter": { "type": "boolean" }, "width": Lino.chars2width(11), "dataIndex": "income_wg" }, { "colIndex": 56, "sortable": false, "xtype": "checkcolumn", "header": "Krankengeld", "editable": true, "tooltip": "(pcsw.ClientsByNationality.income_kg) ", "filter": { "type": "boolean" }, "width": Lino.chars2width(11), "dataIndex": "income_kg" }, { "colIndex": 57, "sortable": false, "xtype": "checkcolumn", "header": "Rente", "editable": true, "tooltip": "(pcsw.ClientsByNationality.income_rente) ", "filter": { "type": "boolean" }, "width": Lino.chars2width(11), "dataIndex": "income_rente" }, { "colIndex": 58, "sortable": false, "xtype": "checkcolumn", "header": "andere Einkommen", "editable": true, "tooltip": "(pcsw.ClientsByNationality.income_misc) ", "filter": { "type": "boolean" }, "width": Lino.chars2width(11), "dataIndex": "income_misc" }, { "colIndex": 59, "sortable": false, "xtype": "checkcolumn", "header": "Arbeit suchend", "editable": true, "tooltip": "(pcsw.ClientsByNationality.is_seeking) ", "filter": { "type": "boolean" }, "width": Lino.chars2width(11), "dataIndex": "is_seeking" }, { "colIndex": 60, "sortable": true, "xtype": "datecolumn", "format": "d.m.Y", "editable": true, "tooltip": "(pcsw.ClientsByNationality.unavailable_until) ", "filter": { "type": "date", "dateFormat": "d.m.Y" }, "header": "Nicht verf\u00fcgbar bis", "dataIndex": "unavailable_until", "width": Lino.chars2width(9), "editor": unavailable_until2252 }, { "colIndex": 61, "sortable": true, "header": "Grund", "editable": true, "tooltip": "(pcsw.ClientsByNationality.unavailable_why) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "unavailable_why", "editor": unavailable_why2253 }, { "colIndex": 62, "sortable": false, "header": "Hindernisse", "editable": true, "tooltip": "(pcsw.ClientsByNationality.obstacles) ", "filter": { "type": "string" }, "width": Lino.chars2width(61), "renderer": Lino.text_renderer, "editor": obstacles2254, "dataIndex": "obstacles" }, { "colIndex": 63, "sortable": false, "header": "Sonstige F\u00e4higkeiten", "editable": true, "tooltip": "(pcsw.ClientsByNationality.skills) ", "filter": { "type": "string" }, "width": Lino.chars2width(61), "renderer": Lino.text_renderer, "editor": skills2255, "dataIndex": "skills" }, { "colIndex": 64, "sortable": true, "header": "Interim-Agenturen", "editable": true, "tooltip": "(pcsw.ClientsByNationality.job_agents) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "job_agents", "editor": job_agents2256 }, { "colIndex": 65, "sortable": true, "header": "Kontaktperson ADG", "editable": true, "tooltip": "(pcsw.ClientsByNationality.job_office_contact) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "job_office_contact", "editor": job_office_contact2257 }, { "colIndex": 66, "sortable": true, "header": "Zustand", "editable": true, "tooltip": "(pcsw.ClientsByNationality.client_state) ", "filter": { "type": "string" }, "width": Lino.chars2width(13), "dataIndex": "client_state", "editor": client_state2258 }, { "colIndex": 67, "sortable": true, "header": "refusal reason", "editable": true, "tooltip": "(pcsw.ClientsByNationality.refusal_reason) ", "filter": { "type": "string" }, "width": Lino.chars2width(47), "dataIndex": "refusal_reason", "editor": refusal_reason2259 }, { "colIndex": 68, "sortable": true, "header": "Vermittler", "editable": true, "tooltip": "(pcsw.ClientsByNationality.broker) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "broker", "editor": broker2260 }, { "colIndex": 69, "sortable": true, "header": "Fachbereich", "editable": true, "tooltip": "(pcsw.ClientsByNationality.faculty) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "faculty", "editor": faculty2261 } ];
    Lino.pcsw.ClientsByNationality.GridPanel.superclass.initComponent.call(this);
  }
});


Lino.pcsw.ClientsByNationality.insertPanel = Ext.extend(Lino.pcsw.Clients.InsertFormPanel,{
  empty_title: "Neu Klienten",
  hide_navigator: true,
  params_panel_hidden: true,
  ls_bbar_actions: [ { "itemId": "post", "menu_item_text": "Erstellen", "tooltip": "Datensatz erstellen und dann im Detail-Fenster \u00f6ffnen", "panel_btn_handler": function(panel){panel.save(null,true,'post')}, "text": "Erstellen", "overflowText": "Erstellen", "auto_save": false }, { "itemId": "poststay", "menu_item_text": "Erstellen ohne Detail", "tooltip": "Nach Erstellen des Datensatzes kein Detail-Fenster \u00f6ffnen", "panel_btn_handler": function(panel){panel.save(null,false,'poststay')}, "text": "Erstellen ohne Detail", "overflowText": "Erstellen ohne Detail", "auto_save": false } ],
  ls_url: "/pcsw/ClientsByNationality",
  action_name: "insert",
  initComponent : function() {
    this.ls_detail_handler = Lino.pcsw.ClientsByNationality.detail;
    this.ls_insert_handler = Lino.pcsw.ClientsByNationality.insert;
    Lino.pcsw.ClientsByNationality.insertPanel.superclass.initComponent.call(this);
  }
});

Lino.pcsw.ClientsByNationality.insert = new Lino.WindowAction({ "draggable": true, "width": Lino.chars2width(60), "autoHeight": true, "maximizable": true, "modal": true, "maximized": false },function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.pcsw.ClientsByNationality.insertPanel(p);
});
Lino.pcsw.ClientsByNationality.wf1 = function(rp,pk) { 
  Lino.run_row_action(rp,"/pcsw/ClientsByNationality",pk,"wf1");
};
Lino.pcsw.ClientsByNationality.wf3 = function(rp,pk) { 
  Lino.run_row_action(rp,"/pcsw/ClientsByNationality",pk,"wf3");
};

Lino.pcsw.ClientsByNationality.detailPanel = Ext.extend(Lino.pcsw.Clients.DetailFormPanel,{
  empty_title: "Detail Klienten",
  params_panel_hidden: true,
  ls_bbar_actions: [ { "itemId": "put", "menu_item_text": "Speichern", "tooltip": "\u00c4nderungen in diesem Formular speichern", "panel_btn_handler": function(panel){panel.save(null,false,'put')}, "iconCls": "x-tbar-save", "overflowText": "Speichern", "auto_save": false }, { "itemId": "insert", "menu_item_text": "Neu", "must_save": true, "tooltip": "Neuen Datensatz erstellen", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-new", "overflowText": "Neu", "auto_save": true }, { "itemId": null, "menu_item_text": "L\u00f6schen", "tooltip": "Diesen Datensatz l\u00f6schen", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "L\u00f6schen", "auto_save": false }, { "itemId": "print_eid_content", "menu_item_text": "eID-Inhalt", "must_save": true, "tooltip": "eID-Inhalt", "panel_btn_handler": Lino.row_action_handler('print_eid_content','GET'), "iconCls": "x-tbar-vcard", "overflowText": "eID-Inhalt", "auto_save": true }, { "itemId": "do_print", "menu_item_text": "Drucken", "must_save": true, "tooltip": "Drucken", "panel_btn_handler": Lino.row_action_handler('do_print','GET'), "iconCls": "x-tbar-print", "overflowText": "Drucken", "auto_save": true } ],
  ls_url: "/pcsw/ClientsByNationality",
  action_name: "detail",
  initComponent : function() {
    this.ls_detail_handler = Lino.pcsw.ClientsByNationality.detail;
    this.ls_insert_handler = Lino.pcsw.ClientsByNationality.insert;
    Lino.pcsw.ClientsByNationality.detailPanel.superclass.initComponent.call(this);
  }
});

Lino.pcsw.ClientsByNationality.detail = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.pcsw.ClientsByNationality.detailPanel(p);
});
Lino.pcsw.ClientsByNationality.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  p.params_panel = new Lino.pcsw.Clients.ParamsPanel({});
  return new Lino.pcsw.ClientsByNationality.GridPanel(p);
});

// js_render_GridPanel_class pcsw.ContactsByClient
Lino.pcsw.ContactsByClient.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "Keine Daten anzuzeigen." },
  ls_url : "/pcsw/ContactsByClient",
  ls_bbar_actions : [ { "itemId": null, "menu_item_text": "L\u00f6schen", "tooltip": "Diesen Datensatz l\u00f6schen", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "L\u00f6schen", "auto_save": false } ],
  title : "Kontakte",
  page_length : 20,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "name": "type" }, 'typeHidden', { "name": "company" }, 'companyHidden', { "name": "contact_person" }, 'contact_personHidden', { "name": "contact_role" }, 'contact_roleHidden', { "name": "remark" }, { "type": "int", "name": "id" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 9,
  ls_grid_configs : [  ],
  content_type : 57,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 11,
  initComponent : function() {
    var ww = this.containing_window;
    var type1173 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/pcsw/ContactsByClient/type", "method": "GET" }) }), "pageSize": 20, "emptyText": "Klientenkontaktart ausw\u00e4hlen..." });
    var company1174 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/pcsw/ContactsByClient/company", "method": "GET" }) }), "pageSize": 20, "emptyText": "Organisation ausw\u00e4hlen..." });
    var contact_person1175 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/pcsw/ContactsByClient/contact_person", "method": "GET" }) }), "pageSize": 20, "emptyText": "Person ausw\u00e4hlen..." });
    var contact_role1176 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/pcsw/ContactsByClient/contact_role", "method": "GET" }) }), "pageSize": 20, "emptyText": "Funktion ausw\u00e4hlen..." });
    var remark1177 = new Ext.form.TextArea({ "selectOnFocus": true, "growMax": 2000 });
    var id1178 = new Ext.form.NumberField({ "selectOnFocus": true });
    this.before_row_edit = function(record) {
      company1174.setContextValue('type',record ? record.data['typeHidden'] : undefined);
      contact_person1175.setContextValue('company',record ? record.data['companyHidden'] : undefined);
    };
    this.onRender = function(ct, position) {
      type1173.on('change',Lino.chooser_handler(company1174,'type'));
      company1174.on('change',Lino.chooser_handler(contact_person1175,'company'));
      Lino.pcsw.ContactsByClient.GridPanel.superclass.onRender.call(this, ct, position);
    }
    this.ls_columns = [ { "colIndex": 0, "sortable": true, "header": "Klientenkontaktart", "editable": true, "tooltip": "(pcsw.ContactsByClient.type) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "type", "editor": type1173 }, { "colIndex": 1, "sortable": true, "header": "Organisation", "editable": true, "tooltip": "(pcsw.ContactsByClient.company) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('companyHidden','Lino.contacts.Companies.detail'), "editor": company1174, "dataIndex": "company" }, { "colIndex": 2, "sortable": true, "header": "Kontaktperson", "editable": true, "tooltip": "(pcsw.ContactsByClient.contact_person) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('contact_personHidden','Lino.contacts.Persons.detail'), "editor": contact_person1175, "dataIndex": "contact_person" }, { "colIndex": 3, "sortable": true, "header": "in seiner Eigenschaft als", "editable": true, "tooltip": "(pcsw.ContactsByClient.contact_role) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "contact_role", "editor": contact_role1176 }, { "colIndex": 4, "sortable": false, "header": "Bemerkungen", "editable": true, "tooltip": "(pcsw.ContactsByClient.remark) ", "filter": { "type": "string" }, "width": Lino.chars2width(61), "renderer": Lino.text_renderer, "editor": remark1177, "dataIndex": "remark" }, new Lino.NullNumberColumn({ "colIndex": 5, "sortable": true, "format": "0", "editable": true, "tooltip": "(pcsw.ContactsByClient.id) ", "filter": { "type": "numeric" }, "header": "ID", "renderer": Lino.id_renderer, "editor": id1178, "width": Lino.chars2width(6), "dataIndex": "id" }) ];
    Lino.pcsw.ContactsByClient.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.pcsw.ContactsByClient.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.pcsw.ContactsByClient.GridPanel(p);
});

// js_render_GridPanel_class pcsw.CoachingsByClient
Lino.pcsw.CoachingsByClient.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "forceFit": true, "emptyText": "Keine Daten anzuzeigen." },
  ls_url : "/pcsw/CoachingsByClient",
  ls_bbar_actions : [ { "itemId": null, "menu_item_text": "L\u00f6schen", "tooltip": "Diesen Datensatz l\u00f6schen", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "L\u00f6schen", "auto_save": false } ],
  title : "Begleitungen",
  page_length : 20,
  params_panel_hidden : true,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "type": "date", "name": "start_date", "dateFormat": "d.m.Y" }, { "type": "date", "name": "end_date", "dateFormat": "d.m.Y" }, { "name": "user" }, 'userHidden', { "type": "boolean", "name": "primary" }, { "name": "type" }, 'typeHidden', { "name": "ending" }, 'endingHidden', { "type": "int", "name": "id" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 9,
  ls_grid_configs : [  ],
  content_type : 52,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 11,
  initComponent : function() {
    var ww = this.containing_window;
    var start_date1181 = new Lino.DateField({ "selectOnFocus": true });
    var end_date1182 = new Lino.DateField({ "selectOnFocus": true });
    var user1183 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/pcsw/CoachingsByClient/user", "method": "GET" }) }), "allowBlank": false, "pageSize": 20, "emptyText": "Benutzer ausw\u00e4hlen..." });
    var primary1184 = new Ext.form.Checkbox({ "selectOnFocus": true, "checked": false });
    var type1185 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/pcsw/CoachingsByClient/type", "method": "GET" }) }), "pageSize": 20, "emptyText": "Dienst ausw\u00e4hlen..." });
    var ending1186 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/pcsw/CoachingsByClient/ending", "method": "GET" }) }), "pageSize": 20, "emptyText": "Beendigungsgrund ausw\u00e4hlen..." });
    var id1187 = new Ext.form.NumberField({ "selectOnFocus": true });
    this.before_row_edit = function(record) {
      ending1186.setContextValue('type',record ? record.data['typeHidden'] : undefined);
    };
    this.onRender = function(ct, position) {
      type1185.on('change',Lino.chooser_handler(ending1186,'type'));
      Lino.pcsw.CoachingsByClient.GridPanel.superclass.onRender.call(this, ct, position);
    }
    this.ls_columns = [ { "colIndex": 0, "sortable": true, "xtype": "datecolumn", "format": "d.m.Y", "editable": true, "tooltip": "(pcsw.CoachingsByClient.start_date) ", "filter": { "type": "date", "dateFormat": "d.m.Y" }, "header": "Begleitet seit", "dataIndex": "start_date", "width": Lino.chars2width(9), "editor": start_date1181 }, { "colIndex": 1, "sortable": true, "xtype": "datecolumn", "format": "d.m.Y", "editable": true, "tooltip": "(pcsw.CoachingsByClient.end_date) ", "filter": { "type": "date", "dateFormat": "d.m.Y" }, "header": "bis", "dataIndex": "end_date", "width": Lino.chars2width(9), "editor": end_date1182 }, { "colIndex": 2, "sortable": true, "header": "Begleiter", "editable": true, "tooltip": "(pcsw.CoachingsByClient.user) ", "filter": { "type": "string" }, "width": Lino.chars2width(13), "dataIndex": "user", "editor": user1183 }, { "colIndex": 3, "sortable": false, "xtype": "checkcolumn", "header": "Prim\u00e4r", "editable": true, "tooltip": "(pcsw.CoachingsByClient.primary) There's at most one primary coach per client. \nEnabling this field will automatically make the other coachings non-primary.", "filter": { "type": "boolean" }, "width": Lino.chars2width(11), "dataIndex": "primary" }, { "colIndex": 4, "sortable": true, "header": "Dienst", "editable": true, "tooltip": "(pcsw.CoachingsByClient.type) ", "filter": { "type": "string" }, "width": Lino.chars2width(13), "dataIndex": "type", "editor": type1185 }, { "colIndex": 5, "sortable": true, "header": "Beendigungsgrund", "editable": true, "tooltip": "(pcsw.CoachingsByClient.ending) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "ending", "editor": ending1186 }, new Lino.NullNumberColumn({ "colIndex": 6, "sortable": true, "format": "0", "editable": true, "tooltip": "(pcsw.CoachingsByClient.id) ", "filter": { "type": "numeric" }, "header": "ID", "renderer": Lino.id_renderer, "hidden": true, "editor": id1187, "width": Lino.chars2width(6), "dataIndex": "id" }) ];
    Lino.pcsw.CoachingsByClient.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.pcsw.CoachingsByClient.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  p.params_panel = new Lino.pcsw.CoachingsByClient.ParamsPanel({});
  return new Lino.pcsw.CoachingsByClient.GridPanel(p);
});

// js_render_GridPanel_class pcsw.CoachingsByUser
Lino.pcsw.CoachingsByUser.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "Keine Daten anzuzeigen." },
  ls_url : "/pcsw/CoachingsByUser",
  ls_bbar_actions : [ { "itemId": null, "menu_item_text": "L\u00f6schen", "tooltip": "Diesen Datensatz l\u00f6schen", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "L\u00f6schen", "auto_save": false } ],
  title : "Begleitungen",
  page_length : 20,
  params_panel_hidden : true,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "type": "date", "name": "start_date", "dateFormat": "d.m.Y" }, { "type": "date", "name": "end_date", "dateFormat": "d.m.Y" }, { "name": "client" }, 'clientHidden', { "name": "type" }, 'typeHidden', { "type": "boolean", "name": "primary" }, { "type": "int", "name": "id" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 7,
  ls_grid_configs : [  ],
  content_type : 52,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 9,
  initComponent : function() {
    var ww = this.containing_window;
    var start_date181 = new Lino.DateField({ "selectOnFocus": true });
    var end_date182 = new Lino.DateField({ "selectOnFocus": true });
    var client183 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/pcsw/CoachingsByUser/client", "method": "GET" }) }), "allowBlank": false, "pageSize": 20, "emptyText": "Klient ausw\u00e4hlen..." });
    var type184 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/pcsw/CoachingsByUser/type", "method": "GET" }) }), "pageSize": 20, "emptyText": "Dienst ausw\u00e4hlen..." });
    var primary185 = new Ext.form.Checkbox({ "selectOnFocus": true, "checked": false });
    var id186 = new Ext.form.NumberField({ "selectOnFocus": true });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ { "colIndex": 0, "sortable": true, "xtype": "datecolumn", "format": "d.m.Y", "editable": true, "tooltip": "(pcsw.CoachingsByUser.start_date) ", "filter": { "type": "date", "dateFormat": "d.m.Y" }, "header": "Begleitet seit", "dataIndex": "start_date", "width": Lino.chars2width(9), "editor": start_date181 }, { "colIndex": 1, "sortable": true, "xtype": "datecolumn", "format": "d.m.Y", "editable": true, "tooltip": "(pcsw.CoachingsByUser.end_date) ", "filter": { "type": "date", "dateFormat": "d.m.Y" }, "header": "bis", "dataIndex": "end_date", "width": Lino.chars2width(9), "editor": end_date182 }, { "colIndex": 2, "sortable": true, "header": "Klient", "editable": true, "tooltip": "(pcsw.CoachingsByUser.client) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('clientHidden','Lino.pcsw.Clients.detail'), "editor": client183, "dataIndex": "client" }, { "colIndex": 3, "sortable": true, "header": "Dienst", "editable": true, "tooltip": "(pcsw.CoachingsByUser.type) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "type", "editor": type184 }, { "colIndex": 4, "sortable": false, "xtype": "checkcolumn", "header": "Prim\u00e4r", "editable": true, "tooltip": "(pcsw.CoachingsByUser.primary) There's at most one primary coach per client. \nEnabling this field will automatically make the other coachings non-primary.", "filter": { "type": "boolean" }, "width": Lino.chars2width(11), "dataIndex": "primary" }, new Lino.NullNumberColumn({ "colIndex": 5, "sortable": true, "format": "0", "editable": true, "tooltip": "(pcsw.CoachingsByUser.id) ", "filter": { "type": "numeric" }, "header": "ID", "renderer": Lino.id_renderer, "editor": id186, "width": Lino.chars2width(6), "dataIndex": "id" }) ];
    Lino.pcsw.CoachingsByUser.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.pcsw.CoachingsByUser.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  p.params_panel = new Lino.pcsw.CoachingsByClient.ParamsPanel({});
  return new Lino.pcsw.CoachingsByUser.GridPanel(p);
});

// js_render_GridPanel_class pcsw.NotesByPerson
Lino.pcsw.NotesByPerson.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "Keine Daten anzuzeigen." },
  ls_url : "/pcsw/NotesByPerson",
  ls_bbar_actions : [ { "itemId": "insert", "menu_item_text": "Neu", "must_save": true, "tooltip": "Neuen Datensatz erstellen", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-new", "overflowText": "Neu", "auto_save": true }, { "itemId": "duplicate", "menu_item_text": "Duplizieren", "must_save": true, "tooltip": "Duplizieren", "panel_btn_handler": Lino.row_action_handler('duplicate','GET'), "iconCls": "x-tbar-duplicate", "overflowText": "Duplizieren", "auto_save": true }, { "itemId": "detail", "menu_item_text": "Detail", "tooltip": "Detail-Fenster auf diesem Datensatz \u00f6ffnen", "panel_btn_handler": Lino.show_detail, "iconCls": "x-tbar-detail", "overflowText": "Detail", "auto_save": true }, { "itemId": null, "menu_item_text": "L\u00f6schen", "tooltip": "Diesen Datensatz l\u00f6schen", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "L\u00f6schen", "auto_save": false }, { "itemId": "do_print", "menu_item_text": "Drucken", "must_save": true, "tooltip": "Drucken", "panel_btn_handler": Lino.row_action_handler('do_print','GET'), "iconCls": "x-tbar-print", "overflowText": "Drucken", "auto_save": true }, { "itemId": "do_clear_cache", "menu_item_text": "Cache l\u00f6schen", "must_save": true, "tooltip": "Cache l\u00f6schen", "panel_btn_handler": Lino.row_action_handler('do_clear_cache','GET'), "iconCls": "x-tbar-clearcache", "overflowText": "Cache l\u00f6schen", "auto_save": true }, { "itemId": "create_postings", "menu_item_text": "per Post", "must_save": true, "tooltip": "Create classical mail postings from this", "panel_btn_handler": Lino.row_action_handler('create_postings','GET'), "iconCls": "x-tbar-create-postings", "overflowText": "per Post", "auto_save": true }, { "itemId": "create_mail", "menu_item_text": "per E-Mail", "must_save": true, "tooltip": "Create an email from this", "panel_btn_handler": Lino.row_action_handler('create_mail','GET'), "iconCls": "x-tbar-email_add", "overflowText": "per E-Mail", "auto_save": true } ],
  title : "Ereignisse/Notizen",
  page_length : 20,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "type": "date", "name": "date", "dateFormat": "d.m.Y" }, { "name": "event_type" }, 'event_typeHidden', { "name": "type" }, 'typeHidden', { "name": "subject" }, { "name": "body" }, { "name": "user" }, 'userHidden', { "name": "company" }, 'companyHidden', { "type": "int", "name": "id" }, { "name": "owner_type" }, 'owner_typeHidden', { "name": "owner_id" }, 'owner_idHidden', { "name": "build_time" }, { "name": "language" }, 'languageHidden', { "name": "owner" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 11,
  ls_grid_configs : [  ],
  content_type : 94,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 21,
  initComponent : function() {
    this.ls_detail_handler = Lino.pcsw.NotesByPerson.detail;
    this.ls_insert_handler = Lino.pcsw.NotesByPerson.insert;
    var ww = this.containing_window;
    var date1620 = new Lino.DateField({ "selectOnFocus": true, "allowBlank": false });
    var event_type1621 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/pcsw/NotesByPerson/event_type", "method": "GET" }) }), "pageSize": 20, "emptyText": "Event Type ausw\u00e4hlen..." });
    var type1622 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/pcsw/NotesByPerson/type", "method": "GET" }) }), "pageSize": 20, "emptyText": "Notizart ausw\u00e4hlen..." });
    var subject1623 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var body1624 = new Lino.RichTextPanel({ "selectOnFocus": true, "containing_panel": this, "title": "Inhalt" });
    var user1625 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/pcsw/NotesByPerson/user", "method": "GET" }) }), "pageSize": 20, "emptyText": "Benutzer ausw\u00e4hlen..." });
    var company1626 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/pcsw/NotesByPerson/company", "method": "GET" }) }), "pageSize": 20, "emptyText": "Organisation ausw\u00e4hlen..." });
    var id1627 = new Ext.form.NumberField({ "selectOnFocus": true });
    var owner_type1628 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/pcsw/NotesByPerson/owner_type", "method": "GET" }) }), "pageSize": 20, "emptyText": "Inhaltstyp ausw\u00e4hlen..." });
    var owner_id1629 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/pcsw/NotesByPerson/owner_id", "method": "GET" }) }) });
    var build_time1630 = new Ext.form.DisplayField({ "disabled": true, "value": "<br>" });
    var language1631 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "store": [ [ "de", "Deutsch" ], [ "fr", "Franz\u00f6sisch" ], [ "nl", "Niederl\u00e4ndisch" ] ], "allowBlank": false, "value": "de" });
    var owner_disp1632 = new Ext.form.DisplayField({ "disabled": true });
    this.before_row_edit = function(record) {
      body1624.refresh();
      owner_id1629.setContextValue('owner_type',record ? record.data['owner_typeHidden'] : undefined);
    };
    this.onRender = function(ct, position) {
      owner_type1628.on('change',Lino.chooser_handler(owner_id1629,'owner_type'));
      Lino.pcsw.NotesByPerson.GridPanel.superclass.onRender.call(this, ct, position);
    }
    this.ls_columns = [ { "colIndex": 0, "sortable": true, "xtype": "datecolumn", "format": "d.m.Y", "editable": true, "tooltip": "(pcsw.NotesByPerson.date) ", "filter": { "type": "date", "dateFormat": "d.m.Y" }, "header": "Datum", "dataIndex": "date", "width": Lino.chars2width(9), "editor": date1620 }, { "colIndex": 1, "sortable": true, "header": "Ereignisart (Form)", "editable": true, "tooltip": "(pcsw.NotesByPerson.event_type) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "event_type", "editor": event_type1621 }, { "colIndex": 2, "sortable": true, "header": "Notizart (Inhalt)", "editable": true, "tooltip": "(pcsw.NotesByPerson.type) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "type", "editor": type1622 }, { "colIndex": 3, "sortable": true, "header": "Betreff", "editable": true, "tooltip": "(pcsw.NotesByPerson.subject) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "subject", "editor": subject1623 }, { "colIndex": 4, "sortable": false, "header": "body", "editable": true, "tooltip": "(pcsw.NotesByPerson.body) ", "filter": { "type": "string" }, "width": Lino.chars2width(61), "renderer": Lino.text_renderer, "editor": body1624, "dataIndex": "body" }, { "colIndex": 5, "sortable": true, "header": "Autor", "editable": true, "tooltip": "(pcsw.NotesByPerson.user) ", "filter": { "type": "string" }, "width": Lino.chars2width(16), "dataIndex": "user", "editor": user1625 }, { "colIndex": 6, "sortable": true, "header": "Organisation", "editable": true, "tooltip": "(pcsw.NotesByPerson.company)     An optional third-party Organization that is related to this Note.\n    The note will then be visible in that company's history panel.\n    ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('companyHidden','Lino.contacts.Companies.detail'), "editor": company1626, "dataIndex": "company" }, new Lino.NullNumberColumn({ "colIndex": 7, "sortable": true, "format": "0", "editable": true, "tooltip": "(pcsw.NotesByPerson.id) ", "filter": { "type": "numeric" }, "header": "ID", "renderer": Lino.id_renderer, "editor": id1627, "width": Lino.chars2width(6), "dataIndex": "id" }), { "colIndex": 8, "sortable": true, "header": "Verkn\u00fcpft mit (Modell)", "editable": true, "tooltip": "(pcsw.NotesByPerson.owner_type) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "owner_type", "editor": owner_type1628 }, { "colIndex": 9, "sortable": true, "header": "Verkn\u00fcpft mit (Objekt)", "editable": true, "tooltip": "(pcsw.NotesByPerson.owner_id) ", "filter": { "type": "string" }, "width": Lino.chars2width(11), "dataIndex": "owner_id", "editor": owner_id1629 }, { "width": Lino.chars2width(17), "colIndex": 10, "sortable": true, "dataIndex": "build_time", "header": "Druckdatum", "editable": false, "tooltip": "(pcsw.NotesByPerson.build_time) " }, { "colIndex": 11, "sortable": true, "header": "Sprache", "editable": true, "tooltip": "(pcsw.NotesByPerson.language) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "language", "editor": language1631 }, { "width": Lino.chars2width(11), "colIndex": 12, "sortable": false, "dataIndex": "owner", "header": "Verkn\u00fcpft mit", "editable": false, "tooltip": "(pcsw.NotesByPerson.owner) " } ];
    Lino.pcsw.NotesByPerson.GridPanel.superclass.initComponent.call(this);
  }
});


Lino.pcsw.NotesByPerson.insertPanel = Ext.extend(Lino.pcsw.NotesByPerson.InsertFormPanel,{
  empty_title: "Neu Ereignisse/Notizen",
  hide_navigator: true,
  ls_bbar_actions: [ { "itemId": "post", "menu_item_text": "Erstellen", "tooltip": "Datensatz erstellen und dann im Detail-Fenster \u00f6ffnen", "panel_btn_handler": function(panel){panel.save(null,true,'post')}, "text": "Erstellen", "overflowText": "Erstellen", "auto_save": false }, { "itemId": "poststay", "menu_item_text": "Erstellen ohne Detail", "tooltip": "Nach Erstellen des Datensatzes kein Detail-Fenster \u00f6ffnen", "panel_btn_handler": function(panel){panel.save(null,false,'poststay')}, "text": "Erstellen ohne Detail", "overflowText": "Erstellen ohne Detail", "auto_save": false } ],
  ls_url: "/pcsw/NotesByPerson",
  action_name: "insert",
  initComponent : function() {
    this.ls_detail_handler = Lino.pcsw.NotesByPerson.detail;
    this.ls_insert_handler = Lino.pcsw.NotesByPerson.insert;
    Lino.pcsw.NotesByPerson.insertPanel.superclass.initComponent.call(this);
  }
});

Lino.pcsw.NotesByPerson.insert = new Lino.WindowAction({ "draggable": true, "width": Lino.chars2width(50), "autoHeight": true, "maximizable": true, "modal": true, "maximized": false },function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.pcsw.NotesByPerson.insertPanel(p);
});

Lino.pcsw.NotesByPerson.detailPanel = Ext.extend(Lino.pcsw.NotesByPerson.DetailFormPanel,{
  empty_title: "Detail Ereignisse/Notizen",
  ls_bbar_actions: [ { "itemId": "put", "menu_item_text": "Speichern", "tooltip": "\u00c4nderungen in diesem Formular speichern", "panel_btn_handler": function(panel){panel.save(null,false,'put')}, "iconCls": "x-tbar-save", "overflowText": "Speichern", "auto_save": false }, { "itemId": "insert", "menu_item_text": "Neu", "must_save": true, "tooltip": "Neuen Datensatz erstellen", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-new", "overflowText": "Neu", "auto_save": true }, { "itemId": "duplicate", "menu_item_text": "Duplizieren", "must_save": true, "tooltip": "Duplizieren", "panel_btn_handler": Lino.row_action_handler('duplicate','GET'), "iconCls": "x-tbar-duplicate", "overflowText": "Duplizieren", "auto_save": true }, { "itemId": null, "menu_item_text": "L\u00f6schen", "tooltip": "Diesen Datensatz l\u00f6schen", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "L\u00f6schen", "auto_save": false }, { "itemId": "do_print", "menu_item_text": "Drucken", "must_save": true, "tooltip": "Drucken", "panel_btn_handler": Lino.row_action_handler('do_print','GET'), "iconCls": "x-tbar-print", "overflowText": "Drucken", "auto_save": true }, { "itemId": "do_clear_cache", "menu_item_text": "Cache l\u00f6schen", "must_save": true, "tooltip": "Cache l\u00f6schen", "panel_btn_handler": Lino.row_action_handler('do_clear_cache','GET'), "iconCls": "x-tbar-clearcache", "overflowText": "Cache l\u00f6schen", "auto_save": true }, { "itemId": "create_postings", "menu_item_text": "per Post", "must_save": true, "tooltip": "Create classical mail postings from this", "panel_btn_handler": Lino.row_action_handler('create_postings','GET'), "iconCls": "x-tbar-create-postings", "overflowText": "per Post", "auto_save": true }, { "itemId": "create_mail", "menu_item_text": "per E-Mail", "must_save": true, "tooltip": "Create an email from this", "panel_btn_handler": Lino.row_action_handler('create_mail','GET'), "iconCls": "x-tbar-email_add", "overflowText": "per E-Mail", "auto_save": true } ],
  ls_url: "/pcsw/NotesByPerson",
  action_name: "detail",
  initComponent : function() {
    this.ls_detail_handler = Lino.pcsw.NotesByPerson.detail;
    this.ls_insert_handler = Lino.pcsw.NotesByPerson.insert;
    Lino.pcsw.NotesByPerson.detailPanel.superclass.initComponent.call(this);
  }
});

Lino.pcsw.NotesByPerson.detail = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.pcsw.NotesByPerson.detailPanel(p);
});
Lino.pcsw.NotesByPerson.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.pcsw.NotesByPerson.GridPanel(p);
});

// js_render_GridPanel_class pcsw.NotesByCompany
Lino.pcsw.NotesByCompany.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "Keine Daten anzuzeigen." },
  ls_url : "/pcsw/NotesByCompany",
  ls_bbar_actions : [ { "itemId": "insert", "menu_item_text": "Neu", "must_save": true, "tooltip": "Neuen Datensatz erstellen", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-new", "overflowText": "Neu", "auto_save": true }, { "itemId": "duplicate", "menu_item_text": "Duplizieren", "must_save": true, "tooltip": "Duplizieren", "panel_btn_handler": Lino.row_action_handler('duplicate','GET'), "iconCls": "x-tbar-duplicate", "overflowText": "Duplizieren", "auto_save": true }, { "itemId": "detail", "menu_item_text": "Detail", "tooltip": "Detail-Fenster auf diesem Datensatz \u00f6ffnen", "panel_btn_handler": Lino.show_detail, "iconCls": "x-tbar-detail", "overflowText": "Detail", "auto_save": true }, { "itemId": null, "menu_item_text": "L\u00f6schen", "tooltip": "Diesen Datensatz l\u00f6schen", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "L\u00f6schen", "auto_save": false }, { "itemId": "do_print", "menu_item_text": "Drucken", "must_save": true, "tooltip": "Drucken", "panel_btn_handler": Lino.row_action_handler('do_print','GET'), "iconCls": "x-tbar-print", "overflowText": "Drucken", "auto_save": true }, { "itemId": "do_clear_cache", "menu_item_text": "Cache l\u00f6schen", "must_save": true, "tooltip": "Cache l\u00f6schen", "panel_btn_handler": Lino.row_action_handler('do_clear_cache','GET'), "iconCls": "x-tbar-clearcache", "overflowText": "Cache l\u00f6schen", "auto_save": true }, { "itemId": "create_postings", "menu_item_text": "per Post", "must_save": true, "tooltip": "Create classical mail postings from this", "panel_btn_handler": Lino.row_action_handler('create_postings','GET'), "iconCls": "x-tbar-create-postings", "overflowText": "per Post", "auto_save": true }, { "itemId": "create_mail", "menu_item_text": "per E-Mail", "must_save": true, "tooltip": "Create an email from this", "panel_btn_handler": Lino.row_action_handler('create_mail','GET'), "iconCls": "x-tbar-email_add", "overflowText": "per E-Mail", "auto_save": true } ],
  title : "Ereignisse/Notizen",
  page_length : 20,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "type": "date", "name": "date", "dateFormat": "d.m.Y" }, { "name": "project" }, 'projectHidden', { "name": "event_type" }, 'event_typeHidden', { "name": "type" }, 'typeHidden', { "name": "subject" }, { "name": "body" }, { "name": "user" }, 'userHidden', { "type": "int", "name": "id" }, { "name": "owner_type" }, 'owner_typeHidden', { "name": "owner_id" }, 'owner_idHidden', { "name": "build_time" }, { "name": "language" }, 'languageHidden', { "name": "owner" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 11,
  ls_grid_configs : [  ],
  content_type : 94,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 21,
  initComponent : function() {
    this.ls_detail_handler = Lino.pcsw.NotesByCompany.detail;
    this.ls_insert_handler = Lino.pcsw.NotesByCompany.insert;
    var ww = this.containing_window;
    var date671 = new Lino.DateField({ "selectOnFocus": true, "allowBlank": false });
    var project672 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/pcsw/NotesByCompany/project", "method": "GET" }) }), "pageSize": 20, "emptyText": "Klient ausw\u00e4hlen..." });
    var event_type673 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/pcsw/NotesByCompany/event_type", "method": "GET" }) }), "pageSize": 20, "emptyText": "Event Type ausw\u00e4hlen..." });
    var type674 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/pcsw/NotesByCompany/type", "method": "GET" }) }), "pageSize": 20, "emptyText": "Notizart ausw\u00e4hlen..." });
    var subject675 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var body676 = new Lino.RichTextPanel({ "selectOnFocus": true, "containing_panel": this, "title": "Inhalt" });
    var user677 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/pcsw/NotesByCompany/user", "method": "GET" }) }), "pageSize": 20, "emptyText": "Benutzer ausw\u00e4hlen..." });
    var id678 = new Ext.form.NumberField({ "selectOnFocus": true });
    var owner_type679 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/pcsw/NotesByCompany/owner_type", "method": "GET" }) }), "pageSize": 20, "emptyText": "Inhaltstyp ausw\u00e4hlen..." });
    var owner_id680 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/pcsw/NotesByCompany/owner_id", "method": "GET" }) }) });
    var build_time681 = new Ext.form.DisplayField({ "disabled": true, "value": "<br>" });
    var language682 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "store": [ [ "de", "Deutsch" ], [ "fr", "Franz\u00f6sisch" ], [ "nl", "Niederl\u00e4ndisch" ] ], "allowBlank": false, "value": "de" });
    var owner_disp683 = new Ext.form.DisplayField({ "disabled": true });
    this.before_row_edit = function(record) {
      body676.refresh();
      owner_id680.setContextValue('owner_type',record ? record.data['owner_typeHidden'] : undefined);
    };
    this.onRender = function(ct, position) {
      owner_type679.on('change',Lino.chooser_handler(owner_id680,'owner_type'));
      Lino.pcsw.NotesByCompany.GridPanel.superclass.onRender.call(this, ct, position);
    }
    this.ls_columns = [ { "colIndex": 0, "sortable": true, "xtype": "datecolumn", "format": "d.m.Y", "editable": true, "tooltip": "(pcsw.NotesByCompany.date) ", "filter": { "type": "date", "dateFormat": "d.m.Y" }, "header": "Datum", "dataIndex": "date", "width": Lino.chars2width(9), "editor": date671 }, { "colIndex": 1, "sortable": true, "header": "Klient", "editable": true, "tooltip": "(pcsw.NotesByCompany.project) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('projectHidden','Lino.pcsw.Clients.detail'), "editor": project672, "dataIndex": "project" }, { "colIndex": 2, "sortable": true, "header": "Ereignisart (Form)", "editable": true, "tooltip": "(pcsw.NotesByCompany.event_type) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "event_type", "editor": event_type673 }, { "colIndex": 3, "sortable": true, "header": "Notizart (Inhalt)", "editable": true, "tooltip": "(pcsw.NotesByCompany.type) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "type", "editor": type674 }, { "colIndex": 4, "sortable": true, "header": "Betreff", "editable": true, "tooltip": "(pcsw.NotesByCompany.subject) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "subject", "editor": subject675 }, { "colIndex": 5, "sortable": false, "header": "body", "editable": true, "tooltip": "(pcsw.NotesByCompany.body) ", "filter": { "type": "string" }, "width": Lino.chars2width(61), "renderer": Lino.text_renderer, "editor": body676, "dataIndex": "body" }, { "colIndex": 6, "sortable": true, "header": "Autor", "editable": true, "tooltip": "(pcsw.NotesByCompany.user) ", "filter": { "type": "string" }, "width": Lino.chars2width(16), "dataIndex": "user", "editor": user677 }, new Lino.NullNumberColumn({ "colIndex": 7, "sortable": true, "format": "0", "editable": true, "tooltip": "(pcsw.NotesByCompany.id) ", "filter": { "type": "numeric" }, "header": "ID", "renderer": Lino.id_renderer, "editor": id678, "width": Lino.chars2width(6), "dataIndex": "id" }), { "colIndex": 8, "sortable": true, "header": "Verkn\u00fcpft mit (Modell)", "editable": true, "tooltip": "(pcsw.NotesByCompany.owner_type) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "owner_type", "editor": owner_type679 }, { "colIndex": 9, "sortable": true, "header": "Verkn\u00fcpft mit (Objekt)", "editable": true, "tooltip": "(pcsw.NotesByCompany.owner_id) ", "filter": { "type": "string" }, "width": Lino.chars2width(11), "dataIndex": "owner_id", "editor": owner_id680 }, { "width": Lino.chars2width(17), "colIndex": 10, "sortable": true, "dataIndex": "build_time", "header": "Druckdatum", "editable": false, "tooltip": "(pcsw.NotesByCompany.build_time) " }, { "colIndex": 11, "sortable": true, "header": "Sprache", "editable": true, "tooltip": "(pcsw.NotesByCompany.language) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "language", "editor": language682 }, { "width": Lino.chars2width(11), "colIndex": 12, "sortable": false, "dataIndex": "owner", "header": "Verkn\u00fcpft mit", "editable": false, "tooltip": "(pcsw.NotesByCompany.owner) " } ];
    Lino.pcsw.NotesByCompany.GridPanel.superclass.initComponent.call(this);
  }
});


Lino.pcsw.NotesByCompany.insertPanel = Ext.extend(Lino.pcsw.NotesByPerson.InsertFormPanel,{
  empty_title: "Neu Ereignisse/Notizen",
  hide_navigator: true,
  ls_bbar_actions: [ { "itemId": "post", "menu_item_text": "Erstellen", "tooltip": "Datensatz erstellen und dann im Detail-Fenster \u00f6ffnen", "panel_btn_handler": function(panel){panel.save(null,true,'post')}, "text": "Erstellen", "overflowText": "Erstellen", "auto_save": false }, { "itemId": "poststay", "menu_item_text": "Erstellen ohne Detail", "tooltip": "Nach Erstellen des Datensatzes kein Detail-Fenster \u00f6ffnen", "panel_btn_handler": function(panel){panel.save(null,false,'poststay')}, "text": "Erstellen ohne Detail", "overflowText": "Erstellen ohne Detail", "auto_save": false } ],
  ls_url: "/pcsw/NotesByCompany",
  action_name: "insert",
  initComponent : function() {
    this.ls_detail_handler = Lino.pcsw.NotesByCompany.detail;
    this.ls_insert_handler = Lino.pcsw.NotesByCompany.insert;
    Lino.pcsw.NotesByCompany.insertPanel.superclass.initComponent.call(this);
  }
});

Lino.pcsw.NotesByCompany.insert = new Lino.WindowAction({ "draggable": true, "width": Lino.chars2width(50), "autoHeight": true, "maximizable": true, "modal": true, "maximized": false },function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.pcsw.NotesByCompany.insertPanel(p);
});

Lino.pcsw.NotesByCompany.detailPanel = Ext.extend(Lino.pcsw.NotesByPerson.DetailFormPanel,{
  empty_title: "Detail Ereignisse/Notizen",
  ls_bbar_actions: [ { "itemId": "put", "menu_item_text": "Speichern", "tooltip": "\u00c4nderungen in diesem Formular speichern", "panel_btn_handler": function(panel){panel.save(null,false,'put')}, "iconCls": "x-tbar-save", "overflowText": "Speichern", "auto_save": false }, { "itemId": "insert", "menu_item_text": "Neu", "must_save": true, "tooltip": "Neuen Datensatz erstellen", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-new", "overflowText": "Neu", "auto_save": true }, { "itemId": "duplicate", "menu_item_text": "Duplizieren", "must_save": true, "tooltip": "Duplizieren", "panel_btn_handler": Lino.row_action_handler('duplicate','GET'), "iconCls": "x-tbar-duplicate", "overflowText": "Duplizieren", "auto_save": true }, { "itemId": null, "menu_item_text": "L\u00f6schen", "tooltip": "Diesen Datensatz l\u00f6schen", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "L\u00f6schen", "auto_save": false }, { "itemId": "do_print", "menu_item_text": "Drucken", "must_save": true, "tooltip": "Drucken", "panel_btn_handler": Lino.row_action_handler('do_print','GET'), "iconCls": "x-tbar-print", "overflowText": "Drucken", "auto_save": true }, { "itemId": "do_clear_cache", "menu_item_text": "Cache l\u00f6schen", "must_save": true, "tooltip": "Cache l\u00f6schen", "panel_btn_handler": Lino.row_action_handler('do_clear_cache','GET'), "iconCls": "x-tbar-clearcache", "overflowText": "Cache l\u00f6schen", "auto_save": true }, { "itemId": "create_postings", "menu_item_text": "per Post", "must_save": true, "tooltip": "Create classical mail postings from this", "panel_btn_handler": Lino.row_action_handler('create_postings','GET'), "iconCls": "x-tbar-create-postings", "overflowText": "per Post", "auto_save": true }, { "itemId": "create_mail", "menu_item_text": "per E-Mail", "must_save": true, "tooltip": "Create an email from this", "panel_btn_handler": Lino.row_action_handler('create_mail','GET'), "iconCls": "x-tbar-email_add", "overflowText": "per E-Mail", "auto_save": true } ],
  ls_url: "/pcsw/NotesByCompany",
  action_name: "detail",
  initComponent : function() {
    this.ls_detail_handler = Lino.pcsw.NotesByCompany.detail;
    this.ls_insert_handler = Lino.pcsw.NotesByCompany.insert;
    Lino.pcsw.NotesByCompany.detailPanel.superclass.initComponent.call(this);
  }
});

Lino.pcsw.NotesByCompany.detail = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.pcsw.NotesByCompany.detailPanel(p);
});
Lino.pcsw.NotesByCompany.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.pcsw.NotesByCompany.GridPanel(p);
});

// js_render_GridPanel_class jobs.CandidaturesByOffer
Lino.jobs.CandidaturesByOffer.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "Keine Daten anzuzeigen." },
  ls_url : "/jobs/CandidaturesByOffer",
  ls_bbar_actions : [ { "itemId": null, "menu_item_text": "L\u00f6schen", "tooltip": "Diesen Datensatz l\u00f6schen", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "L\u00f6schen", "auto_save": false } ],
  title : "Kandidaten",
  page_length : 20,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "type": "int", "name": "id" }, { "name": "sector" }, 'sectorHidden', { "name": "function" }, 'functionHidden', { "name": "person" }, 'personHidden', { "name": "job" }, 'jobHidden', { "type": "date", "name": "date_submitted", "dateFormat": "d.m.Y" }, { "name": "remark" }, { "name": "state" }, 'stateHidden', { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 0,
  ls_grid_configs : [  ],
  content_type : 67,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 14,
  initComponent : function() {
    var ww = this.containing_window;
    var id2263 = new Ext.form.NumberField({ "selectOnFocus": true });
    var sector2264 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/jobs/CandidaturesByOffer/sector", "method": "GET" }) }), "pageSize": 20, "emptyText": "Sektor ausw\u00e4hlen..." });
    var function2265 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/jobs/CandidaturesByOffer/function", "method": "GET" }) }), "pageSize": 20, "emptyText": "Funktion ausw\u00e4hlen..." });
    var person2266 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/jobs/CandidaturesByOffer/person", "method": "GET" }) }), "allowBlank": false, "pageSize": 20, "emptyText": "Klient ausw\u00e4hlen..." });
    var job2267 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/jobs/CandidaturesByOffer/job", "method": "GET" }) }), "pageSize": 20, "emptyText": "Stelle ausw\u00e4hlen..." });
    var date_submitted2268 = new Lino.DateField({ "selectOnFocus": true, "allowBlank": false });
    var remark2269 = new Ext.form.TextArea({ "selectOnFocus": true, "growMax": 2000 });
    var state2270 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "forceSelection": true, "allowBlank": false, "store": Lino.jobs.CandidatureStates });
    this.before_row_edit = function(record) {
      function2265.setContextValue('sector',record ? record.data['sectorHidden'] : undefined);
    };
    this.onRender = function(ct, position) {
      sector2264.on('change',Lino.chooser_handler(function2265,'sector'));
      Lino.jobs.CandidaturesByOffer.GridPanel.superclass.onRender.call(this, ct, position);
    }
    this.ls_columns = [ new Lino.NullNumberColumn({ "colIndex": 0, "sortable": true, "format": "0", "editable": true, "tooltip": "(jobs.CandidaturesByOffer.id) ", "filter": { "type": "numeric" }, "header": "ID", "renderer": Lino.id_renderer, "editor": id2263, "width": Lino.chars2width(6), "dataIndex": "id" }), { "colIndex": 1, "sortable": true, "header": "Sektor", "editable": true, "tooltip": "(jobs.CandidaturesByOffer.sector) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "sector", "editor": sector2264 }, { "colIndex": 2, "sortable": true, "header": "Funktion", "editable": true, "tooltip": "(jobs.CandidaturesByOffer.function) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "function", "editor": function2265 }, { "colIndex": 3, "sortable": true, "header": "Klient", "editable": true, "tooltip": "(jobs.CandidaturesByOffer.person) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('personHidden','Lino.pcsw.Clients.detail'), "editor": person2266, "dataIndex": "person" }, { "colIndex": 4, "sortable": true, "header": "Stelle", "editable": true, "tooltip": "(jobs.CandidaturesByOffer.job) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "job", "editor": job2267 }, { "colIndex": 5, "sortable": true, "xtype": "datecolumn", "format": "d.m.Y", "editable": true, "tooltip": "(jobs.CandidaturesByOffer.date_submitted) Datum wann der SA die Kandidatur erfasst hat.", "filter": { "type": "date", "dateFormat": "d.m.Y" }, "header": "Anfragedatum", "dataIndex": "date_submitted", "width": Lino.chars2width(9), "editor": date_submitted2268 }, { "colIndex": 6, "sortable": false, "header": "Bemerkung", "editable": true, "tooltip": "(jobs.CandidaturesByOffer.remark) ", "filter": { "type": "string" }, "width": Lino.chars2width(61), "renderer": Lino.text_renderer, "editor": remark2269, "dataIndex": "remark" }, { "colIndex": 7, "sortable": true, "header": "Kandidatur-Zustand", "editable": true, "tooltip": "(jobs.CandidaturesByOffer.state) ", "filter": { "type": "string" }, "width": Lino.chars2width(25), "dataIndex": "state", "editor": state2270 } ];
    Lino.jobs.CandidaturesByOffer.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.jobs.CandidaturesByOffer.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.jobs.CandidaturesByOffer.GridPanel(p);
});

// js_render_GridPanel_class jobs.ExperiencesByOffer
Lino.jobs.ExperiencesByOffer.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "Keine Daten anzuzeigen." },
  ls_url : "/jobs/ExperiencesByOffer",
  ls_bbar_actions : [ { "itemId": null, "menu_item_text": "L\u00f6schen", "tooltip": "Diesen Datensatz l\u00f6schen", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "L\u00f6schen", "auto_save": false } ],
  title : "Kandidaten",
  page_length : 20,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "type": "int", "name": "id" }, { "name": "sector" }, 'sectorHidden', { "name": "function" }, 'functionHidden', { "name": "person" }, 'personHidden', { "name": "company" }, { "name": "title" }, { "name": "country" }, 'countryHidden', { "type": "date", "name": "started", "dateFormat": "d.m.Y" }, { "type": "date", "name": "stopped", "dateFormat": "d.m.Y" }, { "name": "remarks" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 0,
  ls_grid_configs : [  ],
  content_type : 73,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 15,
  initComponent : function() {
    var ww = this.containing_window;
    var id2272 = new Ext.form.NumberField({ "selectOnFocus": true });
    var sector2273 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/jobs/ExperiencesByOffer/sector", "method": "GET" }) }), "pageSize": 20, "emptyText": "Sektor ausw\u00e4hlen..." });
    var function2274 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/jobs/ExperiencesByOffer/function", "method": "GET" }) }), "pageSize": 20, "emptyText": "Funktion ausw\u00e4hlen..." });
    var person2275 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/jobs/ExperiencesByOffer/person", "method": "GET" }) }), "allowBlank": false, "pageSize": 20, "emptyText": "Klient ausw\u00e4hlen..." });
    var company2276 = new Ext.form.TextField({ "selectOnFocus": true, "allowBlank": false, "maxLength": 200 });
    var title2277 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var country2278 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/jobs/ExperiencesByOffer/country", "method": "GET" }) }), "pageSize": 20, "emptyText": "Land ausw\u00e4hlen..." });
    var started2279 = new Lino.DateField({ "selectOnFocus": true, "format": "m/Y", "plugins": "monthPickerPlugin" });
    var stopped2280 = new Lino.DateField({ "selectOnFocus": true, "format": "m/Y", "plugins": "monthPickerPlugin" });
    var remarks2281 = new Ext.form.TextArea({ "selectOnFocus": true, "growMax": 2000 });
    this.before_row_edit = function(record) {
      function2274.setContextValue('sector',record ? record.data['sectorHidden'] : undefined);
    };
    this.onRender = function(ct, position) {
      sector2273.on('change',Lino.chooser_handler(function2274,'sector'));
      Lino.jobs.ExperiencesByOffer.GridPanel.superclass.onRender.call(this, ct, position);
    }
    this.ls_columns = [ new Lino.NullNumberColumn({ "colIndex": 0, "sortable": true, "format": "0", "editable": true, "tooltip": "(jobs.ExperiencesByOffer.id) ", "filter": { "type": "numeric" }, "header": "ID", "renderer": Lino.id_renderer, "editor": id2272, "width": Lino.chars2width(6), "dataIndex": "id" }), { "colIndex": 1, "sortable": true, "header": "Sektor", "editable": true, "tooltip": "(jobs.ExperiencesByOffer.sector) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "sector", "editor": sector2273 }, { "colIndex": 2, "sortable": true, "header": "Funktion", "editable": true, "tooltip": "(jobs.ExperiencesByOffer.function) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "function", "editor": function2274 }, { "colIndex": 3, "sortable": true, "header": "Klient", "editable": true, "tooltip": "(jobs.ExperiencesByOffer.person) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('personHidden','Lino.pcsw.Clients.detail'), "editor": person2275, "dataIndex": "person" }, { "colIndex": 4, "sortable": true, "header": "Firma", "editable": true, "tooltip": "(jobs.ExperiencesByOffer.company) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "company", "editor": company2276 }, { "colIndex": 5, "sortable": true, "header": "Bezeichnung", "editable": true, "tooltip": "(jobs.ExperiencesByOffer.title) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "title", "editor": title2277 }, { "colIndex": 6, "sortable": true, "header": "Land", "editable": true, "tooltip": "(jobs.ExperiencesByOffer.country) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('countryHidden','Lino.countries.Countries.detail'), "editor": country2278, "dataIndex": "country" }, { "colIndex": 7, "sortable": true, "xtype": "datecolumn", "format": "d.m.Y", "editable": true, "tooltip": "(jobs.ExperiencesByOffer.started) ", "filter": { "type": "date", "dateFormat": "d.m.Y" }, "header": "begonnen", "dataIndex": "started", "width": Lino.chars2width(9), "editor": started2279 }, { "colIndex": 8, "sortable": true, "xtype": "datecolumn", "format": "d.m.Y", "editable": true, "tooltip": "(jobs.ExperiencesByOffer.stopped) ", "filter": { "type": "date", "dateFormat": "d.m.Y" }, "header": "beendet", "dataIndex": "stopped", "width": Lino.chars2width(9), "editor": stopped2280 }, { "colIndex": 9, "sortable": false, "header": "Bemerkungen", "editable": true, "tooltip": "(jobs.ExperiencesByOffer.remarks) ", "filter": { "type": "string" }, "width": Lino.chars2width(61), "renderer": Lino.text_renderer, "editor": remarks2281, "dataIndex": "remarks" } ];
    Lino.jobs.ExperiencesByOffer.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.jobs.ExperiencesByOffer.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.jobs.ExperiencesByOffer.GridPanel(p);
});

// js_render_GridPanel_class newcomers.CompetencesByUser
Lino.newcomers.CompetencesByUser.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "Keine Daten anzuzeigen." },
  ls_url : "/newcomers/CompetencesByUser",
  ls_bbar_actions : [ { "itemId": "duplicate", "menu_item_text": "Duplizieren", "must_save": true, "tooltip": "Duplizieren", "panel_btn_handler": Lino.row_action_handler('duplicate','GET'), "iconCls": "x-tbar-duplicate", "overflowText": "Duplizieren", "auto_save": true }, { "itemId": null, "menu_item_text": "L\u00f6schen", "tooltip": "Diesen Datensatz l\u00f6schen", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "L\u00f6schen", "auto_save": false }, { "itemId": "move_up", "menu_item_text": "Rauf", "must_save": true, "tooltip": "Move this row one row upwards", "panel_btn_handler": Lino.row_action_handler('move_up','GET'), "iconCls": "x-tbar-moveup", "overflowText": "Rauf", "auto_save": true }, { "itemId": "move_down", "menu_item_text": "Down", "must_save": true, "tooltip": "Move this row one row downwards", "panel_btn_handler": Lino.row_action_handler('move_down','GET'), "iconCls": "x-tbar-movedown", "overflowText": "Down", "auto_save": true } ],
  title : "Kompetenzen",
  page_length : 20,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "type": "int", "name": "seqno" }, { "name": "faculty" }, 'facultyHidden', { "type": "int", "name": "weight" }, { "type": "int", "name": "id" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 4,
  ls_grid_configs : [  ],
  content_type : 83,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 6,
  initComponent : function() {
    var ww = this.containing_window;
    var seqno171 = new Ext.form.NumberField({ "selectOnFocus": true });
    var faculty172 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/newcomers/CompetencesByUser/faculty", "method": "GET" }) }), "allowBlank": false, "pageSize": 20, "emptyText": "Fachbereich ausw\u00e4hlen..." });
    var weight173 = new Ext.form.NumberField({ "selectOnFocus": true });
    var id174 = new Ext.form.NumberField({ "selectOnFocus": true });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ new Lino.NullNumberColumn({ "colIndex": 0, "sortable": true, "format": "0", "editable": true, "tooltip": "(newcomers.CompetencesByUser.seqno) ", "filter": { "type": "numeric" }, "header": "Seq.-Nr.", "dataIndex": "seqno", "width": Lino.chars2width(6), "editor": seqno171 }), { "colIndex": 1, "sortable": true, "header": "Fachbereich", "editable": true, "tooltip": "(newcomers.CompetencesByUser.faculty) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "faculty", "editor": faculty172 }, new Lino.NullNumberColumn({ "colIndex": 2, "sortable": true, "format": "0", "editable": true, "tooltip": "(newcomers.CompetencesByUser.weight) Wieviel Aufwand mir pers\u00f6nlich ein Neuantrag in diesem Fachbereich verursacht\n(0 = gar kein Aufwand, 10 = maximaler Aufwand).", "filter": { "type": "numeric" }, "header": "Aufwand", "dataIndex": "weight", "width": Lino.chars2width(6), "editor": weight173 }), new Lino.NullNumberColumn({ "colIndex": 3, "sortable": true, "format": "0", "editable": true, "tooltip": "(newcomers.CompetencesByUser.id) ", "filter": { "type": "numeric" }, "header": "ID", "renderer": Lino.id_renderer, "editor": id174, "width": Lino.chars2width(6), "dataIndex": "id" }) ];
    Lino.newcomers.CompetencesByUser.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.newcomers.CompetencesByUser.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.newcomers.CompetencesByUser.GridPanel(p);
});
Lino.newcomers.CompetencesByUser.move_up = function(rp,pk) { 
  Lino.run_row_action(rp,"/newcomers/CompetencesByUser",pk,"move_up");
};
Lino.newcomers.CompetencesByUser.move_down = function(rp,pk) { 
  Lino.run_row_action(rp,"/newcomers/CompetencesByUser",pk,"move_down");
};

// js_render_GridPanel_class newcomers.MyCompetences
Lino.newcomers.MyCompetences.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "Keine Daten anzuzeigen." },
  ls_url : "/newcomers/MyCompetences",
  ls_bbar_actions : [ { "itemId": "duplicate", "menu_item_text": "Duplizieren", "must_save": true, "tooltip": "Duplizieren", "panel_btn_handler": Lino.row_action_handler('duplicate','GET'), "iconCls": "x-tbar-duplicate", "overflowText": "Duplizieren", "auto_save": true }, { "itemId": null, "menu_item_text": "L\u00f6schen", "tooltip": "Diesen Datensatz l\u00f6schen", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "L\u00f6schen", "auto_save": false }, { "itemId": "move_up", "menu_item_text": "Rauf", "must_save": true, "tooltip": "Move this row one row upwards", "panel_btn_handler": Lino.row_action_handler('move_up','GET'), "iconCls": "x-tbar-moveup", "overflowText": "Rauf", "auto_save": true }, { "itemId": "move_down", "menu_item_text": "Down", "must_save": true, "tooltip": "Move this row one row downwards", "panel_btn_handler": Lino.row_action_handler('move_down','GET'), "iconCls": "x-tbar-movedown", "overflowText": "Down", "auto_save": true } ],
  title : "Meine Kompetenzen",
  page_length : 20,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "type": "int", "name": "seqno" }, { "name": "faculty" }, 'facultyHidden', { "type": "int", "name": "weight" }, { "type": "int", "name": "id" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 4,
  ls_grid_configs : [  ],
  content_type : 83,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 6,
  initComponent : function() {
    var ww = this.containing_window;
    var seqno2283 = new Ext.form.NumberField({ "selectOnFocus": true });
    var faculty2284 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/newcomers/MyCompetences/faculty", "method": "GET" }) }), "allowBlank": false, "pageSize": 20, "emptyText": "Fachbereich ausw\u00e4hlen..." });
    var weight2285 = new Ext.form.NumberField({ "selectOnFocus": true });
    var id2286 = new Ext.form.NumberField({ "selectOnFocus": true });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ new Lino.NullNumberColumn({ "colIndex": 0, "sortable": true, "format": "0", "editable": true, "tooltip": "(newcomers.MyCompetences.seqno) ", "filter": { "type": "numeric" }, "header": "Seq.-Nr.", "dataIndex": "seqno", "width": Lino.chars2width(6), "editor": seqno2283 }), { "colIndex": 1, "sortable": true, "header": "Fachbereich", "editable": true, "tooltip": "(newcomers.MyCompetences.faculty) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "faculty", "editor": faculty2284 }, new Lino.NullNumberColumn({ "colIndex": 2, "sortable": true, "format": "0", "editable": true, "tooltip": "(newcomers.MyCompetences.weight) Wieviel Aufwand mir pers\u00f6nlich ein Neuantrag in diesem Fachbereich verursacht\n(0 = gar kein Aufwand, 10 = maximaler Aufwand).", "filter": { "type": "numeric" }, "header": "Aufwand", "dataIndex": "weight", "width": Lino.chars2width(6), "editor": weight2285 }), new Lino.NullNumberColumn({ "colIndex": 3, "sortable": true, "format": "0", "editable": true, "tooltip": "(newcomers.MyCompetences.id) ", "filter": { "type": "numeric" }, "header": "ID", "renderer": Lino.id_renderer, "editor": id2286, "width": Lino.chars2width(6), "dataIndex": "id" }) ];
    Lino.newcomers.MyCompetences.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.newcomers.MyCompetences.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.newcomers.MyCompetences.GridPanel(p);
});
Lino.newcomers.MyCompetences.move_up = function(rp,pk) { 
  Lino.run_row_action(rp,"/newcomers/MyCompetences",pk,"move_up");
};
Lino.newcomers.MyCompetences.move_down = function(rp,pk) { 
  Lino.run_row_action(rp,"/newcomers/MyCompetences",pk,"move_down");
};

// js_render_GridPanel_class newcomers.ClientsByFaculty
Lino.newcomers.ClientsByFaculty.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "Keine Daten anzuzeigen." },
  ls_url : "/newcomers/ClientsByFaculty",
  ls_bbar_actions : [ { "itemId": "insert", "menu_item_text": "Neu", "must_save": true, "tooltip": "Neuen Datensatz erstellen", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-new", "overflowText": "Neu", "auto_save": true }, { "itemId": "detail", "menu_item_text": "Detail", "tooltip": "Detail-Fenster auf diesem Datensatz \u00f6ffnen", "panel_btn_handler": Lino.show_detail, "iconCls": "x-tbar-detail", "overflowText": "Detail", "auto_save": true }, { "itemId": null, "menu_item_text": "L\u00f6schen", "tooltip": "Diesen Datensatz l\u00f6schen", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "L\u00f6schen", "auto_save": false }, { "itemId": "print_eid_content", "menu_item_text": "eID-Inhalt", "must_save": true, "tooltip": "eID-Inhalt", "panel_btn_handler": Lino.row_action_handler('print_eid_content','GET'), "iconCls": "x-tbar-vcard", "overflowText": "eID-Inhalt", "auto_save": true }, { "itemId": "do_print", "menu_item_text": "Drucken", "must_save": true, "tooltip": "Drucken", "panel_btn_handler": Lino.row_action_handler('do_print','GET'), "iconCls": "x-tbar-print", "overflowText": "Drucken", "auto_save": true } ],
  title : "Klienten",
  page_length : 20,
  params_panel_hidden : true,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "name": "name_column" }, { "name": "broker" }, 'brokerHidden', { "name": "address_column" }, { "type": "int", "name": "id" }, { "name": "created" }, { "name": "modified" }, { "name": "country" }, 'countryHidden', { "name": "city" }, 'cityHidden', { "name": "region" }, 'regionHidden', { "name": "zip_code" }, { "name": "name" }, { "name": "addr1" }, { "name": "street_prefix" }, { "name": "street" }, { "name": "street_no" }, { "name": "street_box" }, { "name": "addr2" }, { "name": "language" }, 'languageHidden', { "name": "email" }, { "name": "url" }, { "name": "phone" }, { "name": "gsm" }, { "name": "fax" }, { "name": "remarks" }, { "type": "boolean", "name": "is_obsolete" }, { "name": "activity" }, 'activityHidden', { "name": "bank_account1" }, { "name": "bank_account2" }, { "name": "first_name" }, { "name": "last_name" }, { "name": "gender" }, 'genderHidden', { "name": "birth_date" }, { "name": "title" }, { "name": "remarks2" }, { "name": "gesdos_id" }, { "type": "boolean", "name": "is_cpas" }, { "type": "boolean", "name": "is_senior" }, { "name": "group" }, 'groupHidden', { "name": "birth_place" }, { "name": "birth_country" }, 'birth_countryHidden', { "name": "civil_state" }, 'civil_stateHidden', { "name": "national_id" }, { "name": "health_insurance" }, 'health_insuranceHidden', { "name": "pharmacy" }, 'pharmacyHidden', { "name": "nationality" }, 'nationalityHidden', { "name": "card_number" }, { "type": "date", "name": "card_valid_from", "dateFormat": "d.m.Y" }, { "type": "date", "name": "card_valid_until", "dateFormat": "d.m.Y" }, { "name": "card_type" }, 'card_typeHidden', { "name": "card_issuer" }, { "name": "noble_condition" }, { "name": "residence_type" }, 'residence_typeHidden', { "type": "date", "name": "in_belgium_since", "dateFormat": "d.m.Y" }, { "type": "date", "name": "unemployed_since", "dateFormat": "d.m.Y" }, { "type": "boolean", "name": "needs_residence_permit" }, { "type": "boolean", "name": "needs_work_permit" }, { "type": "date", "name": "work_permit_suspended_until", "dateFormat": "d.m.Y" }, { "name": "aid_type" }, 'aid_typeHidden', { "type": "boolean", "name": "income_ag" }, { "type": "boolean", "name": "income_wg" }, { "type": "boolean", "name": "income_kg" }, { "type": "boolean", "name": "income_rente" }, { "type": "boolean", "name": "income_misc" }, { "type": "boolean", "name": "is_seeking" }, { "type": "date", "name": "unavailable_until", "dateFormat": "d.m.Y" }, { "name": "unavailable_why" }, { "name": "obstacles" }, { "name": "skills" }, { "name": "job_agents" }, { "name": "job_office_contact" }, 'job_office_contactHidden', { "name": "client_state" }, 'client_stateHidden', { "name": "refusal_reason" }, 'refusal_reasonHidden', { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 4,
  ls_grid_configs : [  ],
  content_type : 53,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 92,
  initComponent : function() {
    this.ls_detail_handler = Lino.newcomers.ClientsByFaculty.detail;
    this.ls_insert_handler = Lino.newcomers.ClientsByFaculty.insert;
    var ww = this.containing_window;
    var name_column_disp2288 = new Ext.form.DisplayField({ "disabled": true, "value": "<br/>", "always_enabled": true });
    var broker2289 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/newcomers/ClientsByFaculty/broker", "method": "GET" }) }), "pageSize": 20, "emptyText": "Vermittler ausw\u00e4hlen..." });
    var address_column_disp2290 = new Ext.form.DisplayField({ "disabled": true, "value": "<br/>", "always_enabled": true });
    var id2291 = new Ext.form.NumberField({ "selectOnFocus": true });
    var created2292 = new Ext.form.DisplayField({ "disabled": true, "value": "<br>" });
    var modified2293 = new Ext.form.DisplayField({ "disabled": true, "value": "<br>" });
    var country2294 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/newcomers/ClientsByFaculty/country", "method": "GET" }) }), "pageSize": 20, "emptyText": "Land ausw\u00e4hlen..." });
    var city2295 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "forceSelection": false, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/newcomers/ClientsByFaculty/city", "method": "GET" }) }), "pageSize": 20, "emptyText": "Ort ausw\u00e4hlen..." });
    var region2296 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/newcomers/ClientsByFaculty/region", "method": "GET" }) }), "pageSize": 20, "emptyText": "Ort ausw\u00e4hlen..." });
    var zip_code2297 = new Ext.form.TextField({ "selectOnFocus": true, "boxMinWidth": Lino.chars2width(10), "maxLength": 10 });
    var name2298 = new Ext.form.TextField({ "selectOnFocus": true, "allowBlank": false, "maxLength": 200 });
    var addr12299 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var street_prefix2300 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var street2301 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var street_no2302 = new Ext.form.TextField({ "selectOnFocus": true, "boxMinWidth": Lino.chars2width(10), "maxLength": 10 });
    var street_box2303 = new Ext.form.TextField({ "selectOnFocus": true, "boxMinWidth": Lino.chars2width(10), "maxLength": 10 });
    var addr22304 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var language2305 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "store": [ [ "de", "Deutsch" ], [ "fr", "Franz\u00f6sisch" ], [ "nl", "Niederl\u00e4ndisch" ] ], "allowBlank": false, "value": "de" });
    var email2306 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 75 });
    var url2307 = new Lino.URLField({ "selectOnFocus": true, "maxLength": 200 });
    var phone2308 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var gsm2309 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var fax2310 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var remarks2311 = new Ext.form.TextArea({ "selectOnFocus": true, "growMax": 2000 });
    var is_obsolete2312 = new Ext.form.Checkbox({ "selectOnFocus": true, "checked": false });
    var activity2313 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/newcomers/ClientsByFaculty/activity", "method": "GET" }) }), "pageSize": 20, "emptyText": "Beruf ausw\u00e4hlen..." });
    var bank_account12314 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 40 });
    var bank_account22315 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 40 });
    var first_name2316 = new Ext.form.TextField({ "selectOnFocus": true, "allowBlank": false, "maxLength": 200 });
    var last_name2317 = new Ext.form.TextField({ "selectOnFocus": true, "allowBlank": false, "maxLength": 200 });
    var gender2318 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "forceSelection": true, "store": [['','<br>']].concat(Lino.lino.Genders) });
    var birth_date2319 = new Lino.IncompleteDateField({ "selectOnFocus": true });
    var title2320 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var remarks22321 = new Ext.form.TextArea({ "selectOnFocus": true, "growMax": 2000 });
    var gesdos_id2322 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 40 });
    var is_cpas2323 = new Ext.form.Checkbox({ "selectOnFocus": true, "checked": false });
    var is_senior2324 = new Ext.form.Checkbox({ "selectOnFocus": true, "checked": false });
    var group2325 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/newcomers/ClientsByFaculty/group", "method": "GET" }) }), "pageSize": 20, "emptyText": "Integrationsphase ausw\u00e4hlen..." });
    var birth_place2326 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var birth_country2327 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/newcomers/ClientsByFaculty/birth_country", "method": "GET" }) }), "pageSize": 20, "emptyText": "Land ausw\u00e4hlen..." });
    var civil_state2328 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "forceSelection": true, "store": [['','<br>']].concat(Lino.pcsw.CivilState) });
    var national_id2329 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var health_insurance2330 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/newcomers/ClientsByFaculty/health_insurance", "method": "GET" }) }), "pageSize": 20, "emptyText": "Organisation ausw\u00e4hlen..." });
    var pharmacy2331 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/newcomers/ClientsByFaculty/pharmacy", "method": "GET" }) }), "pageSize": 20, "emptyText": "Organisation ausw\u00e4hlen..." });
    var nationality2332 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/newcomers/ClientsByFaculty/nationality", "method": "GET" }) }), "pageSize": 20, "emptyText": "Land ausw\u00e4hlen..." });
    var card_number2333 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 20 });
    var card_valid_from2334 = new Lino.DateField({ "selectOnFocus": true });
    var card_valid_until2335 = new Lino.DateField({ "selectOnFocus": true });
    var card_type2336 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "forceSelection": true, "store": [['','<br>']].concat(Lino.pcsw.BeIdCardTypes) });
    var card_issuer2337 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 50 });
    var noble_condition2338 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 50 });
    var residence_type2339 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "forceSelection": true, "store": [['','<br>']].concat(Lino.pcsw.ResidenceType) });
    var in_belgium_since2340 = new Lino.DateField({ "selectOnFocus": true });
    var unemployed_since2341 = new Lino.DateField({ "selectOnFocus": true });
    var needs_residence_permit2342 = new Ext.form.Checkbox({ "selectOnFocus": true, "checked": false });
    var needs_work_permit2343 = new Ext.form.Checkbox({ "selectOnFocus": true, "checked": false });
    var work_permit_suspended_until2344 = new Lino.DateField({ "selectOnFocus": true });
    var aid_type2345 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/newcomers/ClientsByFaculty/aid_type", "method": "GET" }) }), "pageSize": 20, "emptyText": "Sozialhilfeart ausw\u00e4hlen..." });
    var income_ag2346 = new Ext.form.Checkbox({ "selectOnFocus": true, "checked": false });
    var income_wg2347 = new Ext.form.Checkbox({ "selectOnFocus": true, "checked": false });
    var income_kg2348 = new Ext.form.Checkbox({ "selectOnFocus": true, "checked": false });
    var income_rente2349 = new Ext.form.Checkbox({ "selectOnFocus": true, "checked": false });
    var income_misc2350 = new Ext.form.Checkbox({ "selectOnFocus": true, "checked": false });
    var is_seeking2351 = new Ext.form.Checkbox({ "selectOnFocus": true, "checked": false });
    var unavailable_until2352 = new Lino.DateField({ "selectOnFocus": true });
    var unavailable_why2353 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 100 });
    var obstacles2354 = new Ext.form.TextArea({ "selectOnFocus": true, "growMax": 2000 });
    var skills2355 = new Ext.form.TextArea({ "selectOnFocus": true, "growMax": 2000 });
    var job_agents2356 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 100 });
    var job_office_contact2357 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/newcomers/ClientsByFaculty/job_office_contact", "method": "GET" }) }), "pageSize": 20, "emptyText": "Kontaktperson ausw\u00e4hlen..." });
    var client_state2358 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "forceSelection": true, "allowBlank": false, "store": Lino.pcsw.ClientStates });
    var refusal_reason2359 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "forceSelection": true, "store": [['','<br>']].concat(Lino.pcsw.RefusalReasons) });
    this.before_row_edit = function(record) {
      city2295.setContextValue('country',record ? record.data['countryHidden'] : undefined);
      city2295.setContextValue('region',record ? record.data['regionHidden'] : undefined);
      region2296.setContextValue('country',record ? record.data['countryHidden'] : undefined);
    };
    this.onRender = function(ct, position) {
      country2294.on('change',Lino.chooser_handler(city2295,'country'));
      region2296.on('change',Lino.chooser_handler(city2295,'region'));
      country2294.on('change',Lino.chooser_handler(region2296,'country'));
      Lino.newcomers.ClientsByFaculty.GridPanel.superclass.onRender.call(this, ct, position);
    }
    this.ls_columns = [ { "width": Lino.chars2width(31), "colIndex": 0, "sortable": false, "dataIndex": "name_column", "header": "Name", "editable": false, "tooltip": "(newcomers.ClientsByFaculty.name_column) " }, { "colIndex": 1, "sortable": true, "header": "Vermittler", "editable": true, "tooltip": "(newcomers.ClientsByFaculty.broker) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "broker", "editor": broker2289 }, { "width": Lino.chars2width(31), "colIndex": 2, "sortable": false, "dataIndex": "address_column", "header": "Adresse", "editable": false, "tooltip": "(newcomers.ClientsByFaculty.address_column) " }, new Lino.NullNumberColumn({ "colIndex": 3, "sortable": true, "format": "0", "editable": true, "tooltip": "(newcomers.ClientsByFaculty.id) ", "filter": { "type": "numeric" }, "header": "ID", "renderer": Lino.id_renderer, "editor": id2291, "width": Lino.chars2width(6), "dataIndex": "id" }), { "colIndex": 4, "sortable": true, "header": "Erstellt", "editable": false, "tooltip": "(newcomers.ClientsByFaculty.created) ", "width": Lino.chars2width(17), "dataIndex": "created", "hidden": true }, { "colIndex": 5, "sortable": true, "header": "Bearbeitet", "editable": false, "tooltip": "(newcomers.ClientsByFaculty.modified) ", "width": Lino.chars2width(17), "dataIndex": "modified", "hidden": true }, { "colIndex": 6, "sortable": true, "header": "Land", "editable": true, "tooltip": "(newcomers.ClientsByFaculty.country) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('countryHidden','Lino.countries.Countries.detail'), "editor": country2294, "dataIndex": "country" }, { "colIndex": 7, "sortable": true, "header": "Ort", "editable": true, "tooltip": "(newcomers.ClientsByFaculty.city) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "city", "editor": city2295 }, { "colIndex": 8, "sortable": true, "header": "Region", "editable": true, "tooltip": "(newcomers.ClientsByFaculty.region) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "region", "editor": region2296 }, { "colIndex": 9, "sortable": true, "header": "Postleitzahl", "editable": true, "tooltip": "(newcomers.ClientsByFaculty.zip_code) ", "filter": { "type": "string" }, "width": Lino.chars2width(12), "dataIndex": "zip_code", "editor": zip_code2297 }, { "colIndex": 10, "sortable": true, "header": "Name", "editable": true, "tooltip": "(newcomers.ClientsByFaculty.name) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "name", "editor": name2298 }, { "colIndex": 11, "sortable": true, "header": "Adresszeile vor Stra\u00dfe", "editable": true, "tooltip": "(newcomers.ClientsByFaculty.addr1) Address line before street", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "addr1", "editor": addr12299 }, { "colIndex": 12, "sortable": true, "header": "Pr\u00e4fix Stra\u00dfe", "editable": true, "tooltip": "(newcomers.ClientsByFaculty.street_prefix) Text to print before name of street, but to ignore for sorting.", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "street_prefix", "editor": street_prefix2300 }, { "colIndex": 13, "sortable": true, "header": "Stra\u00dfe", "editable": true, "tooltip": "(newcomers.ClientsByFaculty.street) Name of street. Without house number.", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "street", "editor": street2301 }, { "colIndex": 14, "sortable": true, "header": "Nr.", "editable": true, "tooltip": "(newcomers.ClientsByFaculty.street_no) House number", "filter": { "type": "string" }, "width": Lino.chars2width(12), "dataIndex": "street_no", "editor": street_no2302 }, { "colIndex": 15, "sortable": true, "header": "Box", "editable": true, "tooltip": "(newcomers.ClientsByFaculty.street_box) Text to print after :attr:`steet_no` on the same line", "filter": { "type": "string" }, "width": Lino.chars2width(12), "dataIndex": "street_box", "editor": street_box2303 }, { "colIndex": 16, "sortable": true, "header": "Adresszeile nach Stra\u00dfe", "editable": true, "tooltip": "(newcomers.ClientsByFaculty.addr2) Address line to print below street line", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "addr2", "editor": addr22304 }, { "colIndex": 17, "sortable": true, "header": "Sprache", "editable": true, "tooltip": "(newcomers.ClientsByFaculty.language) Die Sprache, in der Dokumente ausgestellt werden sollen.", "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "language", "editor": language2305 }, { "colIndex": 18, "sortable": true, "header": "E-Mail", "editable": true, "tooltip": "(newcomers.ClientsByFaculty.email) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "email", "editor": email2306 }, { "colIndex": 19, "sortable": true, "header": "URL", "editable": true, "tooltip": "(newcomers.ClientsByFaculty.url) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "url", "editor": url2307 }, { "colIndex": 20, "sortable": true, "header": "Telefon", "editable": true, "tooltip": "(newcomers.ClientsByFaculty.phone) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "phone", "editor": phone2308 }, { "colIndex": 21, "sortable": true, "header": "GSM", "editable": true, "tooltip": "(newcomers.ClientsByFaculty.gsm) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "gsm", "editor": gsm2309 }, { "colIndex": 22, "sortable": true, "header": "Fax", "editable": true, "tooltip": "(newcomers.ClientsByFaculty.fax) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "fax", "editor": fax2310 }, { "colIndex": 23, "sortable": false, "header": "Bemerkungen", "editable": true, "tooltip": "(newcomers.ClientsByFaculty.remarks) ", "filter": { "type": "string" }, "width": Lino.chars2width(61), "renderer": Lino.text_renderer, "editor": remarks2311, "dataIndex": "remarks" }, { "colIndex": 24, "sortable": false, "xtype": "checkcolumn", "header": "veraltet", "editable": true, "tooltip": "(newcomers.ClientsByFaculty.is_obsolete) Altf\u00e4lle sind Partner, deren Stammdaten nicht mehr gepflegt werden und \nf\u00fcr neue Operationen nicht benutzt werden k\u00f6nnen.", "filter": { "type": "boolean" }, "width": Lino.chars2width(11), "dataIndex": "is_obsolete" }, { "colIndex": 25, "sortable": true, "header": "Beruf", "editable": true, "tooltip": "(newcomers.ClientsByFaculty.activity) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "activity", "hidden": true, "editor": activity2313 }, { "colIndex": 26, "sortable": true, "header": "Bankkonto 1", "editable": true, "tooltip": "(newcomers.ClientsByFaculty.bank_account1) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "bank_account1", "hidden": true, "editor": bank_account12314 }, { "colIndex": 27, "sortable": true, "header": "Bankkonto 2", "editable": true, "tooltip": "(newcomers.ClientsByFaculty.bank_account2) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "bank_account2", "hidden": true, "editor": bank_account22315 }, { "colIndex": 28, "sortable": true, "header": "Vorname", "editable": true, "tooltip": "(newcomers.ClientsByFaculty.first_name) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "first_name", "editor": first_name2316 }, { "colIndex": 29, "sortable": true, "header": "Familienname", "editable": true, "tooltip": "(newcomers.ClientsByFaculty.last_name) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "last_name", "editor": last_name2317 }, { "colIndex": 30, "sortable": true, "header": "Geschlecht", "editable": true, "tooltip": "(newcomers.ClientsByFaculty.gender) ", "filter": { "type": "string" }, "width": Lino.chars2width(12), "dataIndex": "gender", "editor": gender2318 }, { "colIndex": 31, "sortable": true, "header": "Geburtsdatum", "editable": true, "tooltip": "(newcomers.ClientsByFaculty.birth_date) Unkomplette Datumsangaben sind erlaubt, z.B. \"00.00.1980\" hei\u00dft \"irgendwann im Jahr 1980\", \"00.07.1980\" hei\u00dft \"im Juli 1980\"oder \"23.07.0000\" hei\u00dft \"an einem 23. Juli\".", "filter": { "type": "string" }, "width": Lino.chars2width(13), "dataIndex": "birth_date", "editor": birth_date2319 }, { "colIndex": 32, "sortable": true, "header": "Anrede", "editable": true, "tooltip": "(newcomers.ClientsByFaculty.title) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "title", "editor": title2320 }, { "colIndex": 33, "sortable": false, "header": "Bemerkungen (Sozialsekretariat)", "editable": true, "tooltip": "(newcomers.ClientsByFaculty.remarks2) ", "filter": { "type": "string" }, "width": Lino.chars2width(61), "renderer": Lino.text_renderer, "editor": remarks22321, "dataIndex": "remarks2" }, { "colIndex": 34, "sortable": true, "header": "Gesdos-Nr", "editable": true, "tooltip": "(newcomers.ClientsByFaculty.gesdos_id) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "gesdos_id", "editor": gesdos_id2322 }, { "colIndex": 35, "sortable": false, "xtype": "checkcolumn", "header": "Sozialhilfeempf\u00e4nger", "editable": true, "tooltip": "(newcomers.ClientsByFaculty.is_cpas) ", "filter": { "type": "boolean" }, "width": Lino.chars2width(11), "dataIndex": "is_cpas" }, { "colIndex": 36, "sortable": false, "xtype": "checkcolumn", "header": "Altenheim", "editable": true, "tooltip": "(newcomers.ClientsByFaculty.is_senior) ", "filter": { "type": "boolean" }, "width": Lino.chars2width(11), "dataIndex": "is_senior" }, { "colIndex": 37, "sortable": true, "header": "Integrationsphase", "editable": true, "tooltip": "(newcomers.ClientsByFaculty.group) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "group", "editor": group2325 }, { "colIndex": 38, "sortable": true, "header": "Geburtsort", "editable": true, "tooltip": "(newcomers.ClientsByFaculty.birth_place) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "birth_place", "editor": birth_place2326 }, { "colIndex": 39, "sortable": true, "header": "Geburtsland", "editable": true, "tooltip": "(newcomers.ClientsByFaculty.birth_country) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('birth_countryHidden','Lino.countries.Countries.detail'), "editor": birth_country2327, "dataIndex": "birth_country" }, { "colIndex": 40, "sortable": true, "header": "Zivilstand", "editable": true, "tooltip": "(newcomers.ClientsByFaculty.civil_state) ", "filter": { "type": "string" }, "width": Lino.chars2width(44), "dataIndex": "civil_state", "editor": civil_state2328 }, { "colIndex": 41, "sortable": true, "header": "NR-Nummer", "editable": true, "tooltip": "(newcomers.ClientsByFaculty.national_id) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "national_id", "editor": national_id2329 }, { "colIndex": 42, "sortable": true, "header": "Krankenkasse", "editable": true, "tooltip": "(newcomers.ClientsByFaculty.health_insurance) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('health_insuranceHidden','Lino.contacts.Companies.detail'), "editor": health_insurance2330, "dataIndex": "health_insurance" }, { "colIndex": 43, "sortable": true, "header": "Apotheke", "editable": true, "tooltip": "(newcomers.ClientsByFaculty.pharmacy) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('pharmacyHidden','Lino.contacts.Companies.detail'), "editor": pharmacy2331, "dataIndex": "pharmacy" }, { "colIndex": 44, "sortable": true, "header": "Staatsangeh\u00f6rigkeit", "editable": true, "tooltip": "(newcomers.ClientsByFaculty.nationality) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('nationalityHidden','Lino.countries.Countries.detail'), "editor": nationality2332, "dataIndex": "nationality" }, { "colIndex": 45, "sortable": true, "header": "eID-Kartennummer", "editable": true, "tooltip": "(newcomers.ClientsByFaculty.card_number) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "card_number", "editor": card_number2333 }, { "colIndex": 46, "sortable": true, "xtype": "datecolumn", "format": "d.m.Y", "editable": true, "tooltip": "(newcomers.ClientsByFaculty.card_valid_from) ", "filter": { "type": "date", "dateFormat": "d.m.Y" }, "header": "ID-Karte g\u00fcltig von", "dataIndex": "card_valid_from", "width": Lino.chars2width(9), "editor": card_valid_from2334 }, { "colIndex": 47, "sortable": true, "xtype": "datecolumn", "format": "d.m.Y", "editable": true, "tooltip": "(newcomers.ClientsByFaculty.card_valid_until) ", "filter": { "type": "date", "dateFormat": "d.m.Y" }, "header": "bis", "dataIndex": "card_valid_until", "width": Lino.chars2width(9), "editor": card_valid_until2335 }, { "colIndex": 48, "sortable": true, "header": "eID-Kartenart", "editable": true, "tooltip": "(newcomers.ClientsByFaculty.card_type) ", "filter": { "type": "string" }, "width": Lino.chars2width(86), "dataIndex": "card_type", "editor": card_type2336 }, { "colIndex": 49, "sortable": true, "header": "eID-Karte ausgestellt durch", "editable": true, "tooltip": "(newcomers.ClientsByFaculty.card_issuer) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "card_issuer", "editor": card_issuer2337 }, { "colIndex": 50, "sortable": true, "header": "Adelstitel", "editable": true, "tooltip": "(newcomers.ClientsByFaculty.noble_condition) The eventual noble condition of this person. Imported from TIM.", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "noble_condition", "editor": noble_condition2338 }, { "colIndex": 51, "sortable": true, "header": "Register", "editable": true, "tooltip": "(newcomers.ClientsByFaculty.residence_type) ", "filter": { "type": "string" }, "width": Lino.chars2width(24), "dataIndex": "residence_type", "editor": residence_type2339 }, { "colIndex": 52, "sortable": true, "xtype": "datecolumn", "format": "d.m.Y", "editable": true, "tooltip": "(newcomers.ClientsByFaculty.in_belgium_since) ", "filter": { "type": "date", "dateFormat": "d.m.Y" }, "header": "Lebt in Belgien seit", "dataIndex": "in_belgium_since", "width": Lino.chars2width(9), "editor": in_belgium_since2340 }, { "colIndex": 53, "sortable": true, "xtype": "datecolumn", "format": "d.m.Y", "editable": true, "tooltip": "(newcomers.ClientsByFaculty.unemployed_since) ", "filter": { "type": "date", "dateFormat": "d.m.Y" }, "header": "eingetragen seit", "dataIndex": "unemployed_since", "width": Lino.chars2width(9), "editor": unemployed_since2341 }, { "colIndex": 54, "sortable": false, "xtype": "checkcolumn", "header": "Braucht Aufenthaltserlaubnis", "editable": true, "tooltip": "(newcomers.ClientsByFaculty.needs_residence_permit) ", "filter": { "type": "boolean" }, "width": Lino.chars2width(11), "dataIndex": "needs_residence_permit" }, { "colIndex": 55, "sortable": false, "xtype": "checkcolumn", "header": "Braucht Arb.Erl.", "editable": true, "tooltip": "(newcomers.ClientsByFaculty.needs_work_permit) ", "filter": { "type": "boolean" }, "width": Lino.chars2width(11), "dataIndex": "needs_work_permit" }, { "colIndex": 56, "sortable": true, "xtype": "datecolumn", "format": "d.m.Y", "editable": true, "tooltip": "(newcomers.ClientsByFaculty.work_permit_suspended_until) ", "filter": { "type": "date", "dateFormat": "d.m.Y" }, "header": "Wartezeit bis", "dataIndex": "work_permit_suspended_until", "width": Lino.chars2width(9), "editor": work_permit_suspended_until2344 }, { "colIndex": 57, "sortable": true, "header": "Sozialhilfeart", "editable": true, "tooltip": "(newcomers.ClientsByFaculty.aid_type) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "aid_type", "editor": aid_type2345 }, { "colIndex": 58, "sortable": false, "xtype": "checkcolumn", "header": "Arbeitslosengeld", "editable": true, "tooltip": "(newcomers.ClientsByFaculty.income_ag) ", "filter": { "type": "boolean" }, "width": Lino.chars2width(11), "dataIndex": "income_ag" }, { "colIndex": 59, "sortable": false, "xtype": "checkcolumn", "header": "Wartegeld", "editable": true, "tooltip": "(newcomers.ClientsByFaculty.income_wg) ", "filter": { "type": "boolean" }, "width": Lino.chars2width(11), "dataIndex": "income_wg" }, { "colIndex": 60, "sortable": false, "xtype": "checkcolumn", "header": "Krankengeld", "editable": true, "tooltip": "(newcomers.ClientsByFaculty.income_kg) ", "filter": { "type": "boolean" }, "width": Lino.chars2width(11), "dataIndex": "income_kg" }, { "colIndex": 61, "sortable": false, "xtype": "checkcolumn", "header": "Rente", "editable": true, "tooltip": "(newcomers.ClientsByFaculty.income_rente) ", "filter": { "type": "boolean" }, "width": Lino.chars2width(11), "dataIndex": "income_rente" }, { "colIndex": 62, "sortable": false, "xtype": "checkcolumn", "header": "andere Einkommen", "editable": true, "tooltip": "(newcomers.ClientsByFaculty.income_misc) ", "filter": { "type": "boolean" }, "width": Lino.chars2width(11), "dataIndex": "income_misc" }, { "colIndex": 63, "sortable": false, "xtype": "checkcolumn", "header": "Arbeit suchend", "editable": true, "tooltip": "(newcomers.ClientsByFaculty.is_seeking) ", "filter": { "type": "boolean" }, "width": Lino.chars2width(11), "dataIndex": "is_seeking" }, { "colIndex": 64, "sortable": true, "xtype": "datecolumn", "format": "d.m.Y", "editable": true, "tooltip": "(newcomers.ClientsByFaculty.unavailable_until) ", "filter": { "type": "date", "dateFormat": "d.m.Y" }, "header": "Nicht verf\u00fcgbar bis", "dataIndex": "unavailable_until", "width": Lino.chars2width(9), "editor": unavailable_until2352 }, { "colIndex": 65, "sortable": true, "header": "Grund", "editable": true, "tooltip": "(newcomers.ClientsByFaculty.unavailable_why) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "unavailable_why", "editor": unavailable_why2353 }, { "colIndex": 66, "sortable": false, "header": "Hindernisse", "editable": true, "tooltip": "(newcomers.ClientsByFaculty.obstacles) ", "filter": { "type": "string" }, "width": Lino.chars2width(61), "renderer": Lino.text_renderer, "editor": obstacles2354, "dataIndex": "obstacles" }, { "colIndex": 67, "sortable": false, "header": "Sonstige F\u00e4higkeiten", "editable": true, "tooltip": "(newcomers.ClientsByFaculty.skills) ", "filter": { "type": "string" }, "width": Lino.chars2width(61), "renderer": Lino.text_renderer, "editor": skills2355, "dataIndex": "skills" }, { "colIndex": 68, "sortable": true, "header": "Interim-Agenturen", "editable": true, "tooltip": "(newcomers.ClientsByFaculty.job_agents) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "job_agents", "editor": job_agents2356 }, { "colIndex": 69, "sortable": true, "header": "Kontaktperson ADG", "editable": true, "tooltip": "(newcomers.ClientsByFaculty.job_office_contact) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "job_office_contact", "editor": job_office_contact2357 }, { "colIndex": 70, "sortable": true, "header": "Zustand", "editable": true, "tooltip": "(newcomers.ClientsByFaculty.client_state) ", "filter": { "type": "string" }, "width": Lino.chars2width(13), "dataIndex": "client_state", "editor": client_state2358 }, { "colIndex": 71, "sortable": true, "header": "refusal reason", "editable": true, "tooltip": "(newcomers.ClientsByFaculty.refusal_reason) ", "filter": { "type": "string" }, "width": Lino.chars2width(47), "dataIndex": "refusal_reason", "editor": refusal_reason2359 } ];
    Lino.newcomers.ClientsByFaculty.GridPanel.superclass.initComponent.call(this);
  }
});


Lino.newcomers.ClientsByFaculty.insertPanel = Ext.extend(Lino.pcsw.Clients.InsertFormPanel,{
  empty_title: "Neu Klienten",
  hide_navigator: true,
  params_panel_hidden: true,
  ls_bbar_actions: [ { "itemId": "post", "menu_item_text": "Erstellen", "tooltip": "Datensatz erstellen und dann im Detail-Fenster \u00f6ffnen", "panel_btn_handler": function(panel){panel.save(null,true,'post')}, "text": "Erstellen", "overflowText": "Erstellen", "auto_save": false }, { "itemId": "poststay", "menu_item_text": "Erstellen ohne Detail", "tooltip": "Nach Erstellen des Datensatzes kein Detail-Fenster \u00f6ffnen", "panel_btn_handler": function(panel){panel.save(null,false,'poststay')}, "text": "Erstellen ohne Detail", "overflowText": "Erstellen ohne Detail", "auto_save": false } ],
  ls_url: "/newcomers/ClientsByFaculty",
  action_name: "insert",
  initComponent : function() {
    this.ls_detail_handler = Lino.newcomers.ClientsByFaculty.detail;
    this.ls_insert_handler = Lino.newcomers.ClientsByFaculty.insert;
    Lino.newcomers.ClientsByFaculty.insertPanel.superclass.initComponent.call(this);
  }
});

Lino.newcomers.ClientsByFaculty.insert = new Lino.WindowAction({ "draggable": true, "width": Lino.chars2width(60), "autoHeight": true, "maximizable": true, "modal": true, "maximized": false },function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.newcomers.ClientsByFaculty.insertPanel(p);
});
Lino.newcomers.ClientsByFaculty.wf1 = function(rp,pk) { 
  Lino.run_row_action(rp,"/newcomers/ClientsByFaculty",pk,"wf1");
};
Lino.newcomers.ClientsByFaculty.wf3 = function(rp,pk) { 
  Lino.run_row_action(rp,"/newcomers/ClientsByFaculty",pk,"wf3");
};

Lino.newcomers.ClientsByFaculty.detailPanel = Ext.extend(Lino.pcsw.Clients.DetailFormPanel,{
  empty_title: "Detail Klienten",
  params_panel_hidden: true,
  ls_bbar_actions: [ { "itemId": "put", "menu_item_text": "Speichern", "tooltip": "\u00c4nderungen in diesem Formular speichern", "panel_btn_handler": function(panel){panel.save(null,false,'put')}, "iconCls": "x-tbar-save", "overflowText": "Speichern", "auto_save": false }, { "itemId": "insert", "menu_item_text": "Neu", "must_save": true, "tooltip": "Neuen Datensatz erstellen", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-new", "overflowText": "Neu", "auto_save": true }, { "itemId": null, "menu_item_text": "L\u00f6schen", "tooltip": "Diesen Datensatz l\u00f6schen", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "L\u00f6schen", "auto_save": false }, { "itemId": "print_eid_content", "menu_item_text": "eID-Inhalt", "must_save": true, "tooltip": "eID-Inhalt", "panel_btn_handler": Lino.row_action_handler('print_eid_content','GET'), "iconCls": "x-tbar-vcard", "overflowText": "eID-Inhalt", "auto_save": true }, { "itemId": "do_print", "menu_item_text": "Drucken", "must_save": true, "tooltip": "Drucken", "panel_btn_handler": Lino.row_action_handler('do_print','GET'), "iconCls": "x-tbar-print", "overflowText": "Drucken", "auto_save": true } ],
  ls_url: "/newcomers/ClientsByFaculty",
  action_name: "detail",
  initComponent : function() {
    this.ls_detail_handler = Lino.newcomers.ClientsByFaculty.detail;
    this.ls_insert_handler = Lino.newcomers.ClientsByFaculty.insert;
    Lino.newcomers.ClientsByFaculty.detailPanel.superclass.initComponent.call(this);
  }
});

Lino.newcomers.ClientsByFaculty.detail = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.newcomers.ClientsByFaculty.detailPanel(p);
});
Lino.newcomers.ClientsByFaculty.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  p.params_panel = new Lino.pcsw.Clients.ParamsPanel({});
  return new Lino.newcomers.ClientsByFaculty.GridPanel(p);
});

// js_render_GridPanel_class cbss.RetrieveTIGroupsRequestsByPerson
Lino.cbss.RetrieveTIGroupsRequestsByPerson.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "Keine Daten anzuzeigen." },
  ls_url : "/cbss/RetrieveTIGroupsRequestsByPerson",
  ls_bbar_actions : [ { "itemId": "insert", "menu_item_text": "Neu", "must_save": true, "tooltip": "Neuen Datensatz erstellen", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-new", "overflowText": "Neu", "auto_save": true }, { "itemId": "duplicate", "menu_item_text": "Duplizieren", "must_save": true, "tooltip": "Duplizieren", "panel_btn_handler": Lino.row_action_handler('duplicate','GET'), "iconCls": "x-tbar-duplicate", "overflowText": "Duplizieren", "auto_save": true }, { "itemId": "detail", "menu_item_text": "Detail", "tooltip": "Detail-Fenster auf diesem Datensatz \u00f6ffnen", "panel_btn_handler": Lino.show_detail, "iconCls": "x-tbar-detail", "overflowText": "Detail", "auto_save": true }, { "itemId": null, "menu_item_text": "L\u00f6schen", "tooltip": "Diesen Datensatz l\u00f6schen", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "L\u00f6schen", "auto_save": false }, { "itemId": "do_print", "menu_item_text": "Drucken", "must_save": true, "tooltip": "Drucken", "panel_btn_handler": Lino.row_action_handler('do_print','GET'), "iconCls": "x-tbar-print", "overflowText": "Drucken", "auto_save": true } ],
  title : "Tx25-Anfragen",
  page_length : 20,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "type": "int", "name": "id" }, { "name": "user" }, 'userHidden', { "name": "person" }, 'personHidden', { "name": "national_id" }, { "name": "language" }, 'languageHidden', { "type": "boolean", "name": "history" }, { "name": "status" }, 'statusHidden', { "name": "ticket" }, { "name": "sent" }, { "name": "environment" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 0,
  ls_grid_configs : [  ],
  content_type : 90,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 15,
  initComponent : function() {
    this.ls_detail_handler = Lino.cbss.RetrieveTIGroupsRequestsByPerson.detail;
    this.ls_insert_handler = Lino.cbss.RetrieveTIGroupsRequestsByPerson.insert;
    var ww = this.containing_window;
    var id2361 = new Ext.form.NumberField({ "selectOnFocus": true });
    var user2362 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cbss/RetrieveTIGroupsRequestsByPerson/user", "method": "GET" }) }), "allowBlank": false, "pageSize": 20, "emptyText": "Benutzer ausw\u00e4hlen..." });
    var person2363 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cbss/RetrieveTIGroupsRequestsByPerson/person", "method": "GET" }) }), "allowBlank": false, "pageSize": 20, "emptyText": "Klient ausw\u00e4hlen..." });
    var national_id2364 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var language2365 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "forceSelection": true, "store": [['','<br>']].concat(Lino.cbss.RequestLanguages) });
    var history2366 = new Ext.form.Checkbox({ "selectOnFocus": true, "checked": true });
    var status2367 = new Lino.ChoicesFieldElement({ "disabled": true, "forceSelection": true, "store": [['','<br>']].concat(Lino.cbss.RequestStates) });
    var ticket2368 = new Ext.form.TextField({ "disabled": true, "maxLength": 36 });
    var sent2369 = new Ext.form.DisplayField({ "disabled": true, "value": "<br>" });
    var environment2370 = new Ext.form.TextField({ "disabled": true, "boxMinWidth": Lino.chars2width(4), "maxLength": 4 });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ new Lino.NullNumberColumn({ "colIndex": 0, "sortable": true, "format": "0", "editable": true, "tooltip": "(cbss.RetrieveTIGroupsRequestsByPerson.id) ", "filter": { "type": "numeric" }, "header": "ID", "renderer": Lino.id_renderer, "editor": id2361, "width": Lino.chars2width(6), "dataIndex": "id" }), { "colIndex": 1, "sortable": true, "header": "Autor", "editable": true, "tooltip": "(cbss.RetrieveTIGroupsRequestsByPerson.user) ", "filter": { "type": "string" }, "width": Lino.chars2width(16), "dataIndex": "user", "editor": user2362 }, { "colIndex": 2, "sortable": true, "header": "Klient", "editable": true, "tooltip": "(cbss.RetrieveTIGroupsRequestsByPerson.person) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('personHidden','Lino.pcsw.Clients.detail'), "editor": person2363, "dataIndex": "person" }, { "colIndex": 3, "sortable": true, "header": "NR-Nummer", "editable": true, "tooltip": "(cbss.RetrieveTIGroupsRequestsByPerson.national_id) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "national_id", "editor": national_id2364 }, { "colIndex": 4, "sortable": true, "header": "Sprache", "editable": true, "tooltip": "(cbss.RetrieveTIGroupsRequestsByPerson.language) ", "filter": { "type": "string" }, "width": Lino.chars2width(18), "dataIndex": "language", "editor": language2365 }, { "colIndex": 5, "sortable": false, "xtype": "checkcolumn", "header": "Historie", "editable": true, "tooltip": "(cbss.RetrieveTIGroupsRequestsByPerson.history) Whatever this means.", "filter": { "type": "boolean" }, "width": Lino.chars2width(11), "dataIndex": "history" }, { "colIndex": 6, "sortable": true, "header": "Zustand", "editable": false, "tooltip": "(cbss.RetrieveTIGroupsRequestsByPerson.status) ", "filter": { "type": "string" }, "width": Lino.chars2width(19), "dataIndex": "status" }, { "colIndex": 7, "sortable": true, "header": "Ticket", "editable": false, "tooltip": "(cbss.RetrieveTIGroupsRequestsByPerson.ticket) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "ticket" }, { "width": Lino.chars2width(17), "colIndex": 8, "sortable": true, "dataIndex": "sent", "header": "Versendet", "editable": false, "tooltip": "(cbss.RetrieveTIGroupsRequestsByPerson.sent) The date and time when this request has been executed. \nThis is empty for requests than haven't been sent.\nRead-only." }, { "colIndex": 9, "sortable": true, "header": "T/A/B", "editable": false, "tooltip": "(cbss.RetrieveTIGroupsRequestsByPerson.environment) ", "filter": { "type": "string" }, "width": Lino.chars2width(6), "dataIndex": "environment" } ];
    Lino.cbss.RetrieveTIGroupsRequestsByPerson.GridPanel.superclass.initComponent.call(this);
  }
});


Lino.cbss.RetrieveTIGroupsRequestsByPerson.insertPanel = Ext.extend(Lino.cbss.RetrieveTIGroupsRequests.InsertFormPanel,{
  empty_title: "Neu Tx25-Anfragen",
  hide_navigator: true,
  ls_bbar_actions: [ { "itemId": "post", "menu_item_text": "Erstellen", "tooltip": "Datensatz erstellen und dann im Detail-Fenster \u00f6ffnen", "panel_btn_handler": function(panel){panel.save(null,true,'post')}, "text": "Erstellen", "overflowText": "Erstellen", "auto_save": false }, { "itemId": "poststay", "menu_item_text": "Erstellen ohne Detail", "tooltip": "Nach Erstellen des Datensatzes kein Detail-Fenster \u00f6ffnen", "panel_btn_handler": function(panel){panel.save(null,false,'poststay')}, "text": "Erstellen ohne Detail", "overflowText": "Erstellen ohne Detail", "auto_save": false } ],
  ls_url: "/cbss/RetrieveTIGroupsRequestsByPerson",
  action_name: "insert",
  initComponent : function() {
    this.ls_detail_handler = Lino.cbss.RetrieveTIGroupsRequestsByPerson.detail;
    this.ls_insert_handler = Lino.cbss.RetrieveTIGroupsRequestsByPerson.insert;
    Lino.cbss.RetrieveTIGroupsRequestsByPerson.insertPanel.superclass.initComponent.call(this);
  }
});

Lino.cbss.RetrieveTIGroupsRequestsByPerson.insert = new Lino.WindowAction({ "draggable": true, "width": Lino.chars2width(40), "autoHeight": true, "maximizable": true, "modal": true, "maximized": false },function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.cbss.RetrieveTIGroupsRequestsByPerson.insertPanel(p);
});

Lino.cbss.RetrieveTIGroupsRequestsByPerson.detailPanel = Ext.extend(Lino.cbss.RetrieveTIGroupsRequests.DetailFormPanel,{
  empty_title: "Detail Tx25-Anfragen",
  ls_bbar_actions: [ { "itemId": "put", "menu_item_text": "Speichern", "tooltip": "\u00c4nderungen in diesem Formular speichern", "panel_btn_handler": function(panel){panel.save(null,false,'put')}, "iconCls": "x-tbar-save", "overflowText": "Speichern", "auto_save": false }, { "itemId": "insert", "menu_item_text": "Neu", "must_save": true, "tooltip": "Neuen Datensatz erstellen", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-new", "overflowText": "Neu", "auto_save": true }, { "itemId": "duplicate", "menu_item_text": "Duplizieren", "must_save": true, "tooltip": "Duplizieren", "panel_btn_handler": Lino.row_action_handler('duplicate','GET'), "iconCls": "x-tbar-duplicate", "overflowText": "Duplizieren", "auto_save": true }, { "itemId": null, "menu_item_text": "L\u00f6schen", "tooltip": "Diesen Datensatz l\u00f6schen", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "L\u00f6schen", "auto_save": false }, { "itemId": "do_print", "menu_item_text": "Drucken", "must_save": true, "tooltip": "Drucken", "panel_btn_handler": Lino.row_action_handler('do_print','GET'), "iconCls": "x-tbar-print", "overflowText": "Drucken", "auto_save": true } ],
  ls_url: "/cbss/RetrieveTIGroupsRequestsByPerson",
  action_name: "detail",
  initComponent : function() {
    this.ls_detail_handler = Lino.cbss.RetrieveTIGroupsRequestsByPerson.detail;
    this.ls_insert_handler = Lino.cbss.RetrieveTIGroupsRequestsByPerson.insert;
    Lino.cbss.RetrieveTIGroupsRequestsByPerson.detailPanel.superclass.initComponent.call(this);
  }
});

Lino.cbss.RetrieveTIGroupsRequestsByPerson.detail = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.cbss.RetrieveTIGroupsRequestsByPerson.detailPanel(p);
});
Lino.cbss.RetrieveTIGroupsRequestsByPerson.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.cbss.RetrieveTIGroupsRequestsByPerson.GridPanel(p);
});

// js_render_GridPanel_class cbss.MyRetrieveTIGroupsRequests
Lino.cbss.MyRetrieveTIGroupsRequests.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "Keine Daten anzuzeigen." },
  ls_url : "/cbss/MyRetrieveTIGroupsRequests",
  ls_bbar_actions : [ { "itemId": "insert", "menu_item_text": "Neu", "must_save": true, "tooltip": "Neuen Datensatz erstellen", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-new", "overflowText": "Neu", "auto_save": true }, { "itemId": "duplicate", "menu_item_text": "Duplizieren", "must_save": true, "tooltip": "Duplizieren", "panel_btn_handler": Lino.row_action_handler('duplicate','GET'), "iconCls": "x-tbar-duplicate", "overflowText": "Duplizieren", "auto_save": true }, { "itemId": "detail", "menu_item_text": "Detail", "tooltip": "Detail-Fenster auf diesem Datensatz \u00f6ffnen", "panel_btn_handler": Lino.show_detail, "iconCls": "x-tbar-detail", "overflowText": "Detail", "auto_save": true }, { "itemId": null, "menu_item_text": "L\u00f6schen", "tooltip": "Diesen Datensatz l\u00f6schen", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "L\u00f6schen", "auto_save": false }, { "itemId": "do_print", "menu_item_text": "Drucken", "must_save": true, "tooltip": "Drucken", "panel_btn_handler": Lino.row_action_handler('do_print','GET'), "iconCls": "x-tbar-print", "overflowText": "Drucken", "auto_save": true } ],
  title : "Meine Tx25-Anfragen",
  page_length : 20,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "type": "int", "name": "id" }, { "name": "user" }, 'userHidden', { "name": "person" }, 'personHidden', { "name": "national_id" }, { "name": "language" }, 'languageHidden', { "type": "boolean", "name": "history" }, { "name": "status" }, 'statusHidden', { "name": "ticket" }, { "name": "sent" }, { "name": "environment" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 0,
  ls_grid_configs : [  ],
  content_type : 90,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 15,
  initComponent : function() {
    this.ls_detail_handler = Lino.cbss.MyRetrieveTIGroupsRequests.detail;
    this.ls_insert_handler = Lino.cbss.MyRetrieveTIGroupsRequests.insert;
    var ww = this.containing_window;
    var id2372 = new Ext.form.NumberField({ "selectOnFocus": true });
    var user2373 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cbss/MyRetrieveTIGroupsRequests/user", "method": "GET" }) }), "allowBlank": false, "pageSize": 20, "emptyText": "Benutzer ausw\u00e4hlen..." });
    var person2374 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cbss/MyRetrieveTIGroupsRequests/person", "method": "GET" }) }), "allowBlank": false, "pageSize": 20, "emptyText": "Klient ausw\u00e4hlen..." });
    var national_id2375 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var language2376 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "forceSelection": true, "store": [['','<br>']].concat(Lino.cbss.RequestLanguages) });
    var history2377 = new Ext.form.Checkbox({ "selectOnFocus": true, "checked": true });
    var status2378 = new Lino.ChoicesFieldElement({ "disabled": true, "forceSelection": true, "store": [['','<br>']].concat(Lino.cbss.RequestStates) });
    var ticket2379 = new Ext.form.TextField({ "disabled": true, "maxLength": 36 });
    var sent2380 = new Ext.form.DisplayField({ "disabled": true, "value": "<br>" });
    var environment2381 = new Ext.form.TextField({ "disabled": true, "boxMinWidth": Lino.chars2width(4), "maxLength": 4 });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ new Lino.NullNumberColumn({ "colIndex": 0, "sortable": true, "format": "0", "editable": true, "tooltip": "(cbss.MyRetrieveTIGroupsRequests.id) ", "filter": { "type": "numeric" }, "header": "ID", "renderer": Lino.id_renderer, "editor": id2372, "width": Lino.chars2width(6), "dataIndex": "id" }), { "colIndex": 1, "sortable": true, "header": "Autor", "editable": true, "tooltip": "(cbss.MyRetrieveTIGroupsRequests.user) ", "filter": { "type": "string" }, "width": Lino.chars2width(16), "dataIndex": "user", "editor": user2373 }, { "colIndex": 2, "sortable": true, "header": "Klient", "editable": true, "tooltip": "(cbss.MyRetrieveTIGroupsRequests.person) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('personHidden','Lino.pcsw.Clients.detail'), "editor": person2374, "dataIndex": "person" }, { "colIndex": 3, "sortable": true, "header": "NR-Nummer", "editable": true, "tooltip": "(cbss.MyRetrieveTIGroupsRequests.national_id) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "national_id", "editor": national_id2375 }, { "colIndex": 4, "sortable": true, "header": "Sprache", "editable": true, "tooltip": "(cbss.MyRetrieveTIGroupsRequests.language) ", "filter": { "type": "string" }, "width": Lino.chars2width(18), "dataIndex": "language", "editor": language2376 }, { "colIndex": 5, "sortable": false, "xtype": "checkcolumn", "header": "Historie", "editable": true, "tooltip": "(cbss.MyRetrieveTIGroupsRequests.history) Whatever this means.", "filter": { "type": "boolean" }, "width": Lino.chars2width(11), "dataIndex": "history" }, { "colIndex": 6, "sortable": true, "header": "Zustand", "editable": false, "tooltip": "(cbss.MyRetrieveTIGroupsRequests.status) ", "filter": { "type": "string" }, "width": Lino.chars2width(19), "dataIndex": "status" }, { "colIndex": 7, "sortable": true, "header": "Ticket", "editable": false, "tooltip": "(cbss.MyRetrieveTIGroupsRequests.ticket) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "ticket" }, { "width": Lino.chars2width(17), "colIndex": 8, "sortable": true, "dataIndex": "sent", "header": "Versendet", "editable": false, "tooltip": "(cbss.MyRetrieveTIGroupsRequests.sent) The date and time when this request has been executed. \nThis is empty for requests than haven't been sent.\nRead-only." }, { "colIndex": 9, "sortable": true, "header": "T/A/B", "editable": false, "tooltip": "(cbss.MyRetrieveTIGroupsRequests.environment) ", "filter": { "type": "string" }, "width": Lino.chars2width(6), "dataIndex": "environment" } ];
    Lino.cbss.MyRetrieveTIGroupsRequests.GridPanel.superclass.initComponent.call(this);
  }
});


Lino.cbss.MyRetrieveTIGroupsRequests.insertPanel = Ext.extend(Lino.cbss.RetrieveTIGroupsRequests.InsertFormPanel,{
  empty_title: "Neu Meine Tx25-Anfragen",
  hide_navigator: true,
  ls_bbar_actions: [ { "itemId": "post", "menu_item_text": "Erstellen", "tooltip": "Datensatz erstellen und dann im Detail-Fenster \u00f6ffnen", "panel_btn_handler": function(panel){panel.save(null,true,'post')}, "text": "Erstellen", "overflowText": "Erstellen", "auto_save": false }, { "itemId": "poststay", "menu_item_text": "Erstellen ohne Detail", "tooltip": "Nach Erstellen des Datensatzes kein Detail-Fenster \u00f6ffnen", "panel_btn_handler": function(panel){panel.save(null,false,'poststay')}, "text": "Erstellen ohne Detail", "overflowText": "Erstellen ohne Detail", "auto_save": false } ],
  ls_url: "/cbss/MyRetrieveTIGroupsRequests",
  action_name: "insert",
  initComponent : function() {
    this.ls_detail_handler = Lino.cbss.MyRetrieveTIGroupsRequests.detail;
    this.ls_insert_handler = Lino.cbss.MyRetrieveTIGroupsRequests.insert;
    Lino.cbss.MyRetrieveTIGroupsRequests.insertPanel.superclass.initComponent.call(this);
  }
});

Lino.cbss.MyRetrieveTIGroupsRequests.insert = new Lino.WindowAction({ "draggable": true, "width": Lino.chars2width(40), "autoHeight": true, "maximizable": true, "modal": true, "maximized": false },function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.cbss.MyRetrieveTIGroupsRequests.insertPanel(p);
});

Lino.cbss.MyRetrieveTIGroupsRequests.detailPanel = Ext.extend(Lino.cbss.RetrieveTIGroupsRequests.DetailFormPanel,{
  empty_title: "Detail Meine Tx25-Anfragen",
  ls_bbar_actions: [ { "itemId": "put", "menu_item_text": "Speichern", "tooltip": "\u00c4nderungen in diesem Formular speichern", "panel_btn_handler": function(panel){panel.save(null,false,'put')}, "iconCls": "x-tbar-save", "overflowText": "Speichern", "auto_save": false }, { "itemId": "insert", "menu_item_text": "Neu", "must_save": true, "tooltip": "Neuen Datensatz erstellen", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-new", "overflowText": "Neu", "auto_save": true }, { "itemId": "duplicate", "menu_item_text": "Duplizieren", "must_save": true, "tooltip": "Duplizieren", "panel_btn_handler": Lino.row_action_handler('duplicate','GET'), "iconCls": "x-tbar-duplicate", "overflowText": "Duplizieren", "auto_save": true }, { "itemId": null, "menu_item_text": "L\u00f6schen", "tooltip": "Diesen Datensatz l\u00f6schen", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "L\u00f6schen", "auto_save": false }, { "itemId": "do_print", "menu_item_text": "Drucken", "must_save": true, "tooltip": "Drucken", "panel_btn_handler": Lino.row_action_handler('do_print','GET'), "iconCls": "x-tbar-print", "overflowText": "Drucken", "auto_save": true } ],
  ls_url: "/cbss/MyRetrieveTIGroupsRequests",
  action_name: "detail",
  initComponent : function() {
    this.ls_detail_handler = Lino.cbss.MyRetrieveTIGroupsRequests.detail;
    this.ls_insert_handler = Lino.cbss.MyRetrieveTIGroupsRequests.insert;
    Lino.cbss.MyRetrieveTIGroupsRequests.detailPanel.superclass.initComponent.call(this);
  }
});

Lino.cbss.MyRetrieveTIGroupsRequests.detail = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.cbss.MyRetrieveTIGroupsRequests.detailPanel(p);
});
Lino.cbss.MyRetrieveTIGroupsRequests.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.cbss.MyRetrieveTIGroupsRequests.GridPanel(p);
});

// js_render_GridPanel_class uploads.UploadsByController
Lino.uploads.UploadsByController.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "Keine Daten anzuzeigen." },
  ls_url : "/uploads/UploadsByController",
  ls_bbar_actions : [ { "itemId": "insert", "menu_item_text": "Neu", "must_save": true, "tooltip": "Neuen Datensatz erstellen", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-new", "overflowText": "Neu", "auto_save": true }, { "itemId": "detail", "menu_item_text": "Detail", "tooltip": "Detail-Fenster auf diesem Datensatz \u00f6ffnen", "panel_btn_handler": Lino.show_detail, "iconCls": "x-tbar-detail", "overflowText": "Detail", "auto_save": true }, { "itemId": null, "menu_item_text": "L\u00f6schen", "tooltip": "Diesen Datensatz l\u00f6schen", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "L\u00f6schen", "auto_save": false } ],
  title : "Uploads",
  page_length : 20,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "name": "file" }, { "name": "type" }, 'typeHidden', { "name": "description" }, { "name": "user" }, 'userHidden', { "type": "int", "name": "id" }, { "name": "owner_type" }, 'owner_typeHidden', { "name": "owner_id" }, 'owner_idHidden', { "name": "created" }, { "name": "modified" }, { "name": "mimetype" }, { "type": "date", "name": "valid_until", "dateFormat": "d.m.Y" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 6,
  ls_grid_configs : [  ],
  content_type : 26,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 16,
  initComponent : function() {
    this.ls_detail_handler = Lino.uploads.UploadsByController.detail;
    this.ls_insert_handler = Lino.uploads.UploadsByController.insert;
    var ww = this.containing_window;
    var file2383 = Lino.file_field_handler(this,{ "selectOnFocus": true, "allowBlank": false, "maxLength": 100 });
    var type2384 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/uploads/UploadsByController/type", "method": "GET" }) }), "pageSize": 20, "emptyText": "Upload-Art ausw\u00e4hlen..." });
    var description2385 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var user2386 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/uploads/UploadsByController/user", "method": "GET" }) }), "pageSize": 20, "emptyText": "Benutzer ausw\u00e4hlen..." });
    var id2387 = new Ext.form.NumberField({ "selectOnFocus": true });
    var owner_type2388 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/uploads/UploadsByController/owner_type", "method": "GET" }) }), "pageSize": 20, "emptyText": "Inhaltstyp ausw\u00e4hlen..." });
    var owner_id2389 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/uploads/UploadsByController/owner_id", "method": "GET" }) }) });
    var created2390 = new Ext.form.DisplayField({ "disabled": true, "value": "<br>" });
    var modified2391 = new Ext.form.DisplayField({ "disabled": true, "value": "<br>" });
    var mimetype2392 = new Ext.form.TextField({ "disabled": true, "maxLength": 64 });
    var valid_until2393 = new Lino.DateField({ "selectOnFocus": true });
    this.before_row_edit = function(record) {
      owner_id2389.setContextValue('owner_type',record ? record.data['owner_typeHidden'] : undefined);
    };
    this.onRender = function(ct, position) {
      owner_type2388.on('change',Lino.chooser_handler(owner_id2389,'owner_type'));
      Lino.uploads.UploadsByController.GridPanel.superclass.onRender.call(this, ct, position);
    }
    this.ls_columns = [ { "colIndex": 0, "sortable": true, "header": "Datei", "editable": true, "tooltip": "(uploads.UploadsByController.file) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "file", "editor": file2383 }, { "colIndex": 1, "sortable": true, "header": "Upload-Art", "editable": true, "tooltip": "(uploads.UploadsByController.type) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "type", "editor": type2384 }, { "colIndex": 2, "sortable": true, "header": "Beschreibung", "editable": true, "tooltip": "(uploads.UploadsByController.description) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "description", "editor": description2385 }, { "colIndex": 3, "sortable": true, "header": "Autor", "editable": true, "tooltip": "(uploads.UploadsByController.user) ", "filter": { "type": "string" }, "width": Lino.chars2width(16), "dataIndex": "user", "editor": user2386 }, new Lino.NullNumberColumn({ "colIndex": 4, "sortable": true, "format": "0", "editable": true, "tooltip": "(uploads.UploadsByController.id) ", "filter": { "type": "numeric" }, "header": "ID", "renderer": Lino.id_renderer, "editor": id2387, "width": Lino.chars2width(6), "dataIndex": "id" }), { "colIndex": 5, "sortable": true, "header": "Verkn\u00fcpft mit (Modell)", "editable": true, "tooltip": "(uploads.UploadsByController.owner_type) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "owner_type", "editor": owner_type2388 }, { "colIndex": 6, "sortable": true, "header": "Verkn\u00fcpft mit (Objekt)", "editable": true, "tooltip": "(uploads.UploadsByController.owner_id) ", "filter": { "type": "string" }, "width": Lino.chars2width(11), "dataIndex": "owner_id", "editor": owner_id2389 }, { "width": Lino.chars2width(17), "colIndex": 7, "sortable": true, "dataIndex": "created", "header": "Erstellt", "editable": false, "tooltip": "(uploads.UploadsByController.created) " }, { "width": Lino.chars2width(17), "colIndex": 8, "sortable": true, "dataIndex": "modified", "header": "Bearbeitet", "editable": false, "tooltip": "(uploads.UploadsByController.modified) " }, { "colIndex": 9, "sortable": true, "header": "MIME-Art", "editable": false, "tooltip": "(uploads.UploadsByController.mimetype) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "mimetype" }, { "colIndex": 10, "sortable": true, "xtype": "datecolumn", "format": "d.m.Y", "editable": true, "tooltip": "(uploads.UploadsByController.valid_until) ", "filter": { "type": "date", "dateFormat": "d.m.Y" }, "header": "g\u00fcltig bis", "dataIndex": "valid_until", "width": Lino.chars2width(9), "editor": valid_until2393 } ];
    Lino.uploads.UploadsByController.GridPanel.superclass.initComponent.call(this);
  }
});


Lino.uploads.UploadsByController.insertPanel = Ext.extend(Lino.uploads.MyUploads.InsertFormPanel,{
  empty_title: "Neu Uploads",
  hide_navigator: true,
  ls_bbar_actions: [ { "itemId": "post", "menu_item_text": "Erstellen", "tooltip": "Datensatz erstellen und dann im Detail-Fenster \u00f6ffnen", "panel_btn_handler": function(panel){panel.save(null,true,'post')}, "text": "Erstellen", "overflowText": "Erstellen", "auto_save": false }, { "itemId": "poststay", "menu_item_text": "Erstellen ohne Detail", "tooltip": "Nach Erstellen des Datensatzes kein Detail-Fenster \u00f6ffnen", "panel_btn_handler": function(panel){panel.save(null,false,'poststay')}, "text": "Erstellen ohne Detail", "overflowText": "Erstellen ohne Detail", "auto_save": false } ],
  ls_url: "/uploads/UploadsByController",
  action_name: "insert",
  initComponent : function() {
    this.ls_detail_handler = Lino.uploads.UploadsByController.detail;
    this.ls_insert_handler = Lino.uploads.UploadsByController.insert;
    Lino.uploads.UploadsByController.insertPanel.superclass.initComponent.call(this);
  }
});

Lino.uploads.UploadsByController.insert = new Lino.WindowAction({ "draggable": true, "width": Lino.chars2width(60), "autoHeight": true, "maximizable": true, "modal": true, "maximized": false },function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.uploads.UploadsByController.insertPanel(p);
});

Lino.uploads.UploadsByController.detailPanel = Ext.extend(Lino.uploads.MyUploads.DetailFormPanel,{
  empty_title: "Detail Uploads",
  ls_bbar_actions: [ { "itemId": "put", "menu_item_text": "Speichern", "tooltip": "\u00c4nderungen in diesem Formular speichern", "panel_btn_handler": function(panel){panel.save(null,false,'put')}, "iconCls": "x-tbar-save", "overflowText": "Speichern", "auto_save": false }, { "itemId": "insert", "menu_item_text": "Neu", "must_save": true, "tooltip": "Neuen Datensatz erstellen", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-new", "overflowText": "Neu", "auto_save": true }, { "itemId": null, "menu_item_text": "L\u00f6schen", "tooltip": "Diesen Datensatz l\u00f6schen", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "L\u00f6schen", "auto_save": false } ],
  ls_url: "/uploads/UploadsByController",
  action_name: "detail",
  initComponent : function() {
    this.ls_detail_handler = Lino.uploads.UploadsByController.detail;
    this.ls_insert_handler = Lino.uploads.UploadsByController.insert;
    Lino.uploads.UploadsByController.detailPanel.superclass.initComponent.call(this);
  }
});

Lino.uploads.UploadsByController.detail = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.uploads.UploadsByController.detailPanel(p);
});
Lino.uploads.UploadsByController.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.uploads.UploadsByController.GridPanel(p);
});

// js_render_GridPanel_class outbox.MailsByController
Lino.outbox.MailsByController.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "Keine Daten anzuzeigen." },
  ls_url : "/outbox/MailsByController",
  ls_bbar_actions : [ { "itemId": "insert", "menu_item_text": "Neu", "must_save": true, "tooltip": "Neuen Datensatz erstellen", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-new", "overflowText": "Neu", "auto_save": true }, { "itemId": "detail", "menu_item_text": "Detail", "tooltip": "Detail-Fenster auf diesem Datensatz \u00f6ffnen", "panel_btn_handler": Lino.show_detail, "iconCls": "x-tbar-detail", "overflowText": "Detail", "auto_save": true }, { "itemId": null, "menu_item_text": "L\u00f6schen", "tooltip": "Diesen Datensatz l\u00f6schen", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "L\u00f6schen", "auto_save": false }, { "itemId": "do_print", "menu_item_text": "Drucken", "must_save": true, "tooltip": "Drucken", "panel_btn_handler": Lino.row_action_handler('do_print','GET'), "iconCls": "x-tbar-print", "overflowText": "Drucken", "auto_save": true }, { "itemId": "send_mail", "menu_item_text": "E-Mail senden", "must_save": true, "tooltip": "E-Mail senden", "panel_btn_handler": Lino.row_action_handler('send_mail','GET'), "iconCls": "x-tbar-email_send", "overflowText": "E-Mail senden", "auto_save": true } ],
  title : "E-Mail-Ausg\u00e4nge",
  page_length : 20,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "name": "sent" }, { "name": "recipients" }, { "name": "subject" }, { "type": "int", "name": "id" }, { "name": "owner_type" }, 'owner_typeHidden', { "name": "owner_id" }, 'owner_idHidden', { "name": "user" }, 'userHidden', { "name": "project" }, 'projectHidden', { "type": "date", "name": "date", "dateFormat": "d.m.Y" }, { "name": "body" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 3,
  ls_grid_configs : [  ],
  content_type : 27,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 15,
  initComponent : function() {
    this.ls_detail_handler = Lino.outbox.MailsByController.detail;
    this.ls_insert_handler = Lino.outbox.MailsByController.insert;
    var ww = this.containing_window;
    var sent711 = new Ext.form.DisplayField({ "disabled": true, "value": "<br>" });
    var recipients_htmlbox712 = new Lino.HtmlBoxPanel({ "layout": "fit", "name": "recipients", "containing_panel": this, "items": new Ext.BoxComponent({autoScroll:true}), "title": "Empf\u00e4nger", "master_panel": this, "value": "<br/>", "always_enabled": true, "bodyStyle": "overflow-x:hidden" });
    var subject713 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var id714 = new Ext.form.NumberField({ "selectOnFocus": true });
    var owner_type715 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/outbox/MailsByController/owner_type", "method": "GET" }) }), "pageSize": 20, "emptyText": "Inhaltstyp ausw\u00e4hlen..." });
    var owner_id716 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/outbox/MailsByController/owner_id", "method": "GET" }) }) });
    var user717 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/outbox/MailsByController/user", "method": "GET" }) }), "pageSize": 20, "emptyText": "Benutzer ausw\u00e4hlen..." });
    var project718 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/outbox/MailsByController/project", "method": "GET" }) }), "pageSize": 20, "emptyText": "Klient ausw\u00e4hlen..." });
    var date719 = new Lino.DateField({ "selectOnFocus": true, "allowBlank": false });
    var body720 = new Lino.RichTextPanel({ "selectOnFocus": true, "containing_panel": this, "title": "Inhalt" });
    this.before_row_edit = function(record) {
      recipients_htmlbox712.refresh();
      owner_id716.setContextValue('owner_type',record ? record.data['owner_typeHidden'] : undefined);
      body720.refresh();
    };
    this.onRender = function(ct, position) {
      owner_type715.on('change',Lino.chooser_handler(owner_id716,'owner_type'));
      Lino.outbox.MailsByController.GridPanel.superclass.onRender.call(this, ct, position);
    }
    this.ls_columns = [ { "width": Lino.chars2width(17), "colIndex": 0, "sortable": true, "dataIndex": "sent", "header": "sent", "editable": false, "tooltip": "(outbox.MailsByController.sent) " }, { "width": Lino.chars2width(31), "colIndex": 1, "sortable": false, "dataIndex": "recipients", "header": "Empf\u00e4nger", "editable": false, "tooltip": "(outbox.MailsByController.recipients) " }, { "colIndex": 2, "sortable": true, "header": "Betreff", "editable": true, "tooltip": "(outbox.MailsByController.subject) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "subject", "editor": subject713 }, new Lino.NullNumberColumn({ "colIndex": 3, "sortable": true, "format": "0", "editable": true, "tooltip": "(outbox.MailsByController.id) ", "filter": { "type": "numeric" }, "header": "ID", "renderer": Lino.id_renderer, "editor": id714, "width": Lino.chars2width(6), "dataIndex": "id" }), { "colIndex": 4, "sortable": true, "header": "Verkn\u00fcpft mit (Modell)", "editable": true, "tooltip": "(outbox.MailsByController.owner_type) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "owner_type", "editor": owner_type715 }, { "colIndex": 5, "sortable": true, "header": "Verkn\u00fcpft mit (Objekt)", "editable": true, "tooltip": "(outbox.MailsByController.owner_id) ", "filter": { "type": "string" }, "width": Lino.chars2width(11), "dataIndex": "owner_id", "editor": owner_id716 }, { "colIndex": 6, "sortable": true, "header": "Absender", "editable": true, "tooltip": "(outbox.MailsByController.user) ", "filter": { "type": "string" }, "width": Lino.chars2width(16), "dataIndex": "user", "editor": user717 }, { "colIndex": 7, "sortable": true, "header": "Klient", "editable": true, "tooltip": "(outbox.MailsByController.project) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('projectHidden','Lino.pcsw.Clients.detail'), "editor": project718, "dataIndex": "project" }, { "colIndex": 8, "sortable": true, "xtype": "datecolumn", "format": "d.m.Y", "editable": true, "tooltip": "(outbox.MailsByController.date) \n        The official date to be printed on the document.\n        ", "filter": { "type": "date", "dateFormat": "d.m.Y" }, "header": "Datum", "dataIndex": "date", "width": Lino.chars2width(9), "editor": date719 }, { "colIndex": 9, "sortable": false, "width": Lino.chars2width(61), "editable": true, "tooltip": "(outbox.MailsByController.body) ", "filter": { "type": "string" }, "header": "body", "renderer": Lino.text_renderer, "hidden": true, "editor": body720, "dataIndex": "body" } ];
    Lino.outbox.MailsByController.GridPanel.superclass.initComponent.call(this);
  }
});


Lino.outbox.MailsByController.insertPanel = Ext.extend(Lino.outbox.MailsByUser.InsertFormPanel,{
  empty_title: "Neu E-Mail-Ausg\u00e4nge",
  hide_navigator: true,
  ls_bbar_actions: [ { "itemId": "post", "menu_item_text": "Erstellen", "tooltip": "Datensatz erstellen und dann im Detail-Fenster \u00f6ffnen", "panel_btn_handler": function(panel){panel.save(null,true,'post')}, "text": "Erstellen", "overflowText": "Erstellen", "auto_save": false }, { "itemId": "poststay", "menu_item_text": "Erstellen ohne Detail", "tooltip": "Nach Erstellen des Datensatzes kein Detail-Fenster \u00f6ffnen", "panel_btn_handler": function(panel){panel.save(null,false,'poststay')}, "text": "Erstellen ohne Detail", "overflowText": "Erstellen ohne Detail", "auto_save": false } ],
  ls_url: "/outbox/MailsByController",
  action_name: "insert",
  initComponent : function() {
    this.ls_detail_handler = Lino.outbox.MailsByController.detail;
    this.ls_insert_handler = Lino.outbox.MailsByController.insert;
    Lino.outbox.MailsByController.insertPanel.superclass.initComponent.call(this);
  }
});

Lino.outbox.MailsByController.insert = new Lino.WindowAction({ "draggable": true, "width": Lino.chars2width(60), "maximizable": true, "modal": true, "maximized": false, "height": Lino.rows2height(20) },function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.outbox.MailsByController.insertPanel(p);
});

Lino.outbox.MailsByController.detailPanel = Ext.extend(Lino.outbox.MailsByUser.DetailFormPanel,{
  empty_title: "Detail E-Mail-Ausg\u00e4nge",
  ls_bbar_actions: [ { "itemId": "put", "menu_item_text": "Speichern", "tooltip": "\u00c4nderungen in diesem Formular speichern", "panel_btn_handler": function(panel){panel.save(null,false,'put')}, "iconCls": "x-tbar-save", "overflowText": "Speichern", "auto_save": false }, { "itemId": "insert", "menu_item_text": "Neu", "must_save": true, "tooltip": "Neuen Datensatz erstellen", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-new", "overflowText": "Neu", "auto_save": true }, { "itemId": null, "menu_item_text": "L\u00f6schen", "tooltip": "Diesen Datensatz l\u00f6schen", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "L\u00f6schen", "auto_save": false }, { "itemId": "do_print", "menu_item_text": "Drucken", "must_save": true, "tooltip": "Drucken", "panel_btn_handler": Lino.row_action_handler('do_print','GET'), "iconCls": "x-tbar-print", "overflowText": "Drucken", "auto_save": true }, { "itemId": "send_mail", "menu_item_text": "E-Mail senden", "must_save": true, "tooltip": "E-Mail senden", "panel_btn_handler": Lino.row_action_handler('send_mail','GET'), "iconCls": "x-tbar-email_send", "overflowText": "E-Mail senden", "auto_save": true } ],
  ls_url: "/outbox/MailsByController",
  action_name: "detail",
  initComponent : function() {
    this.ls_detail_handler = Lino.outbox.MailsByController.detail;
    this.ls_insert_handler = Lino.outbox.MailsByController.insert;
    Lino.outbox.MailsByController.detailPanel.superclass.initComponent.call(this);
  }
});

Lino.outbox.MailsByController.detail = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.outbox.MailsByController.detailPanel(p);
});
Lino.outbox.MailsByController.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.outbox.MailsByController.GridPanel(p);
});

// js_render_GridPanel_class changes.ChangesByMaster
Lino.changes.ChangesByMaster.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "Keine Daten anzuzeigen." },
  ls_url : "/changes/ChangesByMaster",
  ls_bbar_actions : [ { "itemId": "insert", "menu_item_text": "Neu", "must_save": true, "tooltip": "Neuen Datensatz erstellen", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-new", "overflowText": "Neu", "auto_save": true }, { "itemId": "detail", "menu_item_text": "Detail", "tooltip": "Detail-Fenster auf diesem Datensatz \u00f6ffnen", "panel_btn_handler": Lino.show_detail, "iconCls": "x-tbar-detail", "overflowText": "Detail", "auto_save": true }, { "itemId": null, "menu_item_text": "L\u00f6schen", "tooltip": "Diesen Datensatz l\u00f6schen", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "L\u00f6schen", "auto_save": false } ],
  title : "\u00c4nderungen",
  page_length : 20,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "name": "time" }, { "name": "user" }, 'userHidden', { "name": "type" }, 'typeHidden', { "name": "object" }, { "name": "diff" }, { "name": "object_type" }, 'object_typeHidden', { "name": "object_id" }, 'object_idHidden', { "type": "int", "name": "id" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 11,
  ls_grid_configs : [  ],
  content_type : 10,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 13,
  initComponent : function() {
    this.ls_detail_handler = Lino.changes.ChangesByMaster.detail;
    this.ls_insert_handler = Lino.changes.ChangesByMaster.insert;
    var ww = this.containing_window;
    var time407 = new Ext.form.DisplayField({ "selectOnFocus": true, "allowBlank": false, "value": "<br>" });
    var user408 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/changes/ChangesByMaster/user", "method": "GET" }) }), "allowBlank": false, "pageSize": 20, "emptyText": "Benutzer ausw\u00e4hlen..." });
    var type409 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "forceSelection": true, "allowBlank": false, "store": Lino.lino.ChangeTypes });
    var object_disp410 = new Ext.form.DisplayField({ "disabled": true });
    var diff411 = new Ext.form.TextArea({ "selectOnFocus": true, "growMax": 2000 });
    var object_type412 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/changes/ChangesByMaster/object_type", "method": "GET" }) }), "allowBlank": false, "pageSize": 20, "emptyText": "Inhaltstyp ausw\u00e4hlen..." });
    var object_id413 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "allowBlank": false, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/changes/ChangesByMaster/object_id", "method": "GET" }) }) });
    this.before_row_edit = function(record) {
      object_id413.setContextValue('object_type',record ? record.data['object_typeHidden'] : undefined);
    };
    this.onRender = function(ct, position) {
      object_type412.on('change',Lino.chooser_handler(object_id413,'object_type'));
      Lino.changes.ChangesByMaster.GridPanel.superclass.onRender.call(this, ct, position);
    }
    this.ls_columns = [ { "colIndex": 0, "sortable": true, "header": "time", "editable": true, "tooltip": "(changes.ChangesByMaster.time) ", "width": Lino.chars2width(17), "dataIndex": "time", "editor": time407 }, { "colIndex": 1, "sortable": true, "header": "Benutzer", "editable": true, "tooltip": "(changes.ChangesByMaster.user) ", "filter": { "type": "string" }, "width": Lino.chars2width(16), "dataIndex": "user", "editor": user408 }, { "colIndex": 2, "sortable": true, "header": "\u00c4nderungsart", "editable": true, "tooltip": "(changes.ChangesByMaster.type) ", "filter": { "type": "string" }, "width": Lino.chars2width(18), "dataIndex": "type", "editor": type409 }, { "width": Lino.chars2width(11), "colIndex": 3, "sortable": false, "dataIndex": "object", "header": "Object", "editable": false, "tooltip": "(changes.ChangesByMaster.object) " }, { "colIndex": 4, "sortable": false, "header": "\u00c4nderungen", "editable": true, "tooltip": "(changes.ChangesByMaster.diff) ", "filter": { "type": "string" }, "width": Lino.chars2width(61), "renderer": Lino.text_renderer, "editor": diff411, "dataIndex": "diff" }, { "colIndex": 5, "sortable": true, "header": "Object type", "editable": true, "tooltip": "(changes.ChangesByMaster.object_type) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "object_type", "editor": object_type412 }, { "colIndex": 6, "sortable": true, "header": "object id", "editable": true, "tooltip": "(changes.ChangesByMaster.object_id) ", "filter": { "type": "string" }, "width": Lino.chars2width(11), "dataIndex": "object_id", "editor": object_id413 } ];
    Lino.changes.ChangesByMaster.GridPanel.superclass.initComponent.call(this);
  }
});


Lino.changes.ChangesByMaster.insertPanel = Ext.extend(Lino.changes.ChangesByMaster.DetailFormPanel,{
  empty_title: "Neu \u00c4nderungen",
  hide_navigator: true,
  ls_bbar_actions: [ { "itemId": "post", "menu_item_text": "Erstellen", "tooltip": "Datensatz erstellen und dann im Detail-Fenster \u00f6ffnen", "panel_btn_handler": function(panel){panel.save(null,true,'post')}, "text": "Erstellen", "overflowText": "Erstellen", "auto_save": false }, { "itemId": "poststay", "menu_item_text": "Erstellen ohne Detail", "tooltip": "Nach Erstellen des Datensatzes kein Detail-Fenster \u00f6ffnen", "panel_btn_handler": function(panel){panel.save(null,false,'poststay')}, "text": "Erstellen ohne Detail", "overflowText": "Erstellen ohne Detail", "auto_save": false } ],
  ls_url: "/changes/ChangesByMaster",
  action_name: "insert",
  initComponent : function() {
    this.ls_detail_handler = Lino.changes.ChangesByMaster.detail;
    this.ls_insert_handler = Lino.changes.ChangesByMaster.insert;
    Lino.changes.ChangesByMaster.insertPanel.superclass.initComponent.call(this);
  }
});

Lino.changes.ChangesByMaster.insert = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.changes.ChangesByMaster.insertPanel(p);
});

Lino.changes.ChangesByMaster.detailPanel = Ext.extend(Lino.changes.ChangesByMaster.DetailFormPanel,{
  empty_title: "Detail \u00c4nderungen",
  ls_bbar_actions: [ { "itemId": "put", "menu_item_text": "Speichern", "tooltip": "\u00c4nderungen in diesem Formular speichern", "panel_btn_handler": function(panel){panel.save(null,false,'put')}, "iconCls": "x-tbar-save", "overflowText": "Speichern", "auto_save": false }, { "itemId": "insert", "menu_item_text": "Neu", "must_save": true, "tooltip": "Neuen Datensatz erstellen", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-new", "overflowText": "Neu", "auto_save": true }, { "itemId": null, "menu_item_text": "L\u00f6schen", "tooltip": "Diesen Datensatz l\u00f6schen", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "L\u00f6schen", "auto_save": false } ],
  ls_url: "/changes/ChangesByMaster",
  action_name: "detail",
  initComponent : function() {
    this.ls_detail_handler = Lino.changes.ChangesByMaster.detail;
    this.ls_insert_handler = Lino.changes.ChangesByMaster.insert;
    Lino.changes.ChangesByMaster.detailPanel.superclass.initComponent.call(this);
  }
});

Lino.changes.ChangesByMaster.detail = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.changes.ChangesByMaster.detailPanel(p);
});
Lino.changes.ChangesByMaster.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.changes.ChangesByMaster.GridPanel(p);
});

// js_render_GridPanel_class about.Models
Lino.about.Models.GridPanel = Ext.extend(Lino.GridPanel,{
  ls_url : "/about/Models",
  ls_bbar_actions : [ { "itemId": "detail", "menu_item_text": "Detail", "tooltip": "Detail-Fenster auf diesem Datensatz \u00f6ffnen", "panel_btn_handler": Lino.show_detail, "iconCls": "x-tbar-detail", "overflowText": "Detail", "auto_save": true } ],
  title : "Models",
  page_length : 20,
  gc_name : 0,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "name": "app" }, { "name": "name" }, { "name": "docstring" }, { "name": "rows" }, { "name": "detail_action" }, { "name": "disabled_fields" }, { "name": "disabled_actions" } ],
  ls_grid_configs : [  ],
  viewConfig : { "emptyText": "Keine Daten anzuzeigen." },
  disable_editing : true,
  disabled_actions_index : 6,
  initComponent : function() {
    this.ls_detail_handler = Lino.about.Models.detail;
    var ww = this.containing_window;
    var app_disp2395 = new Ext.form.DisplayField({ "disabled": true, "value": "<br/>", "always_enabled": true });
    var name_disp2396 = new Ext.form.DisplayField({ "disabled": true, "value": "<br/>", "always_enabled": true });
    var docstring_disp2397 = new Ext.form.DisplayField({ "disabled": true, "value": "<br/>", "always_enabled": true });
    var rows2398 = new Ext.form.NumberField({ "disabled": true });
    var detail_action_disp2399 = new Ext.form.DisplayField({ "disabled": true, "value": "<br/>", "always_enabled": true });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ { "width": Lino.chars2width(31), "colIndex": 0, "sortable": false, "dataIndex": "app", "header": "app_label", "editable": false, "tooltip": "(about.Models.app) " }, { "width": Lino.chars2width(31), "colIndex": 1, "sortable": false, "dataIndex": "name", "header": "name", "editable": false, "tooltip": "(about.Models.name) " }, { "width": Lino.chars2width(31), "colIndex": 2, "sortable": false, "dataIndex": "docstring", "header": "docstring", "editable": false, "tooltip": "(about.Models.docstring) " }, new Lino.NullNumberColumn({ "colIndex": 3, "sortable": false, "format": "0", "editable": false, "tooltip": "(about.Models.rows) ", "header": "Rows", "dataIndex": "rows", "width": Lino.chars2width(6) }), { "width": Lino.chars2width(31), "colIndex": 4, "sortable": false, "dataIndex": "detail_action", "header": "detail_action", "editable": false, "tooltip": "(about.Models.detail_action) " } ];
    Lino.about.Models.GridPanel.superclass.initComponent.call(this);
  }
});


Lino.about.Models.detailPanel = Ext.extend(Lino.about.Models.DetailFormPanel,{
  empty_title: "Detail Models",
  ls_bbar_actions: [  ],
  ls_url: "/about/Models",
  action_name: "detail",
  initComponent : function() {
    this.ls_detail_handler = Lino.about.Models.detail;
    Lino.about.Models.detailPanel.superclass.initComponent.call(this);
  }
});

Lino.about.Models.detail = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.about.Models.detailPanel(p);
});
Lino.about.Models.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.about.Models.GridPanel(p);
});

// js_render_GridPanel_class about.FieldsByModel
Lino.about.FieldsByModel.GridPanel = Ext.extend(Lino.GridPanel,{
  ls_url : "/about/FieldsByModel",
  ls_bbar_actions : [  ],
  title : "Fields",
  page_length : 20,
  gc_name : 0,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "name": "name" }, { "name": "verbose_name" }, { "name": "help_text_column" }, { "name": "disabled_fields" }, { "name": "disabled_actions" } ],
  ls_grid_configs : [  ],
  viewConfig : { "emptyText": "Keine Daten anzuzeigen." },
  disable_editing : true,
  disabled_actions_index : 4,
  initComponent : function() {
    var ww = this.containing_window;
    var name_disp1865 = new Ext.form.DisplayField({ "disabled": true, "value": "<br/>", "always_enabled": true });
    var verbose_name_disp1866 = new Ext.form.DisplayField({ "disabled": true, "value": "<br/>", "always_enabled": true });
    var help_text_column_disp1867 = new Ext.form.DisplayField({ "disabled": true, "value": "<br/>", "always_enabled": true });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ { "width": Lino.chars2width(31), "colIndex": 0, "sortable": false, "dataIndex": "name", "header": "name", "editable": false, "tooltip": "(about.FieldsByModel.name) " }, { "width": Lino.chars2width(31), "colIndex": 1, "sortable": false, "dataIndex": "verbose_name", "header": "verbose name", "editable": false, "tooltip": "(about.FieldsByModel.verbose_name) " }, { "width": Lino.chars2width(31), "colIndex": 2, "sortable": false, "dataIndex": "help_text_column", "header": "help text", "editable": false, "tooltip": "(about.FieldsByModel.help_text_column) " } ];
    Lino.about.FieldsByModel.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.about.FieldsByModel.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.about.FieldsByModel.GridPanel(p);
});

// js_render_GridPanel_class about.SourceFiles
Lino.about.SourceFiles.GridPanel = Ext.extend(Lino.GridPanel,{
  ls_url : "/about/SourceFiles",
  ls_bbar_actions : [  ],
  title : "Source files",
  page_length : 20,
  gc_name : 0,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "name": "module_name" }, { "type": "int", "name": "code_lines" }, { "type": "int", "name": "doc_lines" }, { "name": "disabled_fields" }, { "name": "disabled_actions" } ],
  ls_grid_configs : [  ],
  viewConfig : { "emptyText": "Keine Daten anzuzeigen." },
  disable_editing : true,
  disabled_actions_index : 4,
  initComponent : function() {
    var ww = this.containing_window;
    var module_name2401 = new Ext.form.TextField({ "disabled": true, "maxLength": null });
    var code_lines2402 = new Ext.form.NumberField({ "disabled": true });
    var doc_lines2403 = new Ext.form.NumberField({ "disabled": true });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ { "width": Lino.chars2width(5), "colIndex": 0, "sortable": false, "dataIndex": "module_name", "header": "module name", "editable": false, "tooltip": "(about.SourceFiles.module_name) " }, new Lino.NullNumberColumn({ "colIndex": 1, "sortable": false, "format": "0", "editable": false, "tooltip": "(about.SourceFiles.code_lines) ", "header": "Code", "dataIndex": "code_lines", "width": Lino.chars2width(6) }), new Lino.NullNumberColumn({ "colIndex": 2, "sortable": false, "format": "0", "editable": false, "tooltip": "(about.SourceFiles.doc_lines) ", "header": "doc", "dataIndex": "doc_lines", "width": Lino.chars2width(6) }) ];
    Lino.about.SourceFiles.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.about.SourceFiles.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.about.SourceFiles.GridPanel(p);
});

// js_render_GridPanel_class integ.CompareRequestsTable
Lino.integ.CompareRequestsTable.GridPanel = Ext.extend(Lino.GridPanel,{
  ls_url : "/integ/CompareRequestsTable",
  ls_bbar_actions : [  ],
  title : "Allgemeine Entwicklung",
  page_length : 20,
  gc_name : 0,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "name": "description" }, { "name": "old_value" }, { "name": "new_value" }, { "name": "disabled_fields" }, { "name": "disabled_actions" } ],
  ls_grid_configs : [  ],
  viewConfig : { "forceFit": true, "emptyText": "Keine Daten anzuzeigen." },
  disable_editing : true,
  disabled_actions_index : 4,
  initComponent : function() {
    var ww = this.containing_window;
    var description_disp2405 = new Ext.form.DisplayField({ "disabled": true, "value": "<br/>", "always_enabled": true });
    var old_value2406 = new Ext.form.NumberField({ "disabled": true });
    var new_value2407 = new Ext.form.NumberField({ "disabled": true });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ { "width": Lino.chars2width(31), "colIndex": 0, "sortable": false, "dataIndex": "description", "header": "Beschreibung", "editable": false, "tooltip": "(integ.CompareRequestsTable.description) " }, new Lino.NullNumberColumn({ "colIndex": 1, "sortable": false, "format": "0", "editable": false, "tooltip": "(integ.CompareRequestsTable.old_value) ", "header": "Anfangswert", "dataIndex": "old_value", "width": Lino.chars2width(6) }), new Lino.NullNumberColumn({ "colIndex": 2, "sortable": false, "format": "0", "editable": false, "tooltip": "(integ.CompareRequestsTable.new_value) ", "header": "Endwert", "dataIndex": "new_value", "width": Lino.chars2width(6) }) ];
    Lino.integ.CompareRequestsTable.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.integ.CompareRequestsTable.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.integ.CompareRequestsTable.GridPanel(p);
});

// js_render_GridPanel_class integ.PeriodicNumbers
Lino.integ.PeriodicNumbers.GridPanel = Ext.extend(Lino.GridPanel,{
  ls_url : "/integ/PeriodicNumbers",
  ls_bbar_actions : [  ],
  title : "Aktivit\u00e4t",
  page_length : 20,
  gc_name : 0,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "name": "description" }, { "name": "number" }, { "name": "disabled_fields" }, { "name": "disabled_actions" } ],
  ls_grid_configs : [  ],
  viewConfig : { "forceFit": true, "emptyText": "Keine Daten anzuzeigen." },
  disable_editing : true,
  disabled_actions_index : 3,
  initComponent : function() {
    var ww = this.containing_window;
    var description_disp2409 = new Ext.form.DisplayField({ "disabled": true, "value": "<br/>", "always_enabled": true });
    var number2410 = new Ext.form.NumberField({ "disabled": true });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ { "width": Lino.chars2width(31), "colIndex": 0, "sortable": false, "dataIndex": "description", "header": "Beschreibung", "editable": false, "tooltip": "(integ.PeriodicNumbers.description) " }, new Lino.NullNumberColumn({ "colIndex": 1, "sortable": false, "format": "0", "editable": false, "tooltip": "(integ.PeriodicNumbers.number) ", "header": "Anzahl", "dataIndex": "number", "width": Lino.chars2width(6) }) ];
    Lino.integ.PeriodicNumbers.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.integ.PeriodicNumbers.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.integ.PeriodicNumbers.GridPanel(p);
});

// js_render_GridPanel_class debts.SummaryTable
Lino.debts.SummaryTable.GridPanel = Ext.extend(Lino.GridPanel,{
  ls_url : "/debts/SummaryTable",
  ls_bbar_actions : [  ],
  title : "SummaryTable",
  page_length : 20,
  gc_name : 0,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "name": "desc" }, { "name": "amount" }, { "name": "disabled_fields" }, { "name": "disabled_actions" } ],
  ls_grid_configs : [  ],
  viewConfig : { "forceFit": true, "emptyText": "Keine Daten anzuzeigen." },
  disable_editing : true,
  disabled_actions_index : 3,
  initComponent : function() {
    var ww = this.containing_window;
    var desc_disp2412 = new Ext.form.DisplayField({ "disabled": true, "value": "<br/>", "always_enabled": true });
    var amount2413 = new Ext.form.NumberField({ "disabled": true, "decimalPrecision": 2, "decimalSeparator": "," });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ { "width": Lino.chars2width(31), "colIndex": 0, "sortable": false, "dataIndex": "desc", "header": "Beschreibung", "editable": false, "tooltip": "(debts.SummaryTable.desc) " }, new Lino.NullNumberColumn({ "width": Lino.chars2width(13), "colIndex": 1, "sortable": false, "dataIndex": "amount", "header": "Betrag", "editable": false, "tooltip": "(debts.SummaryTable.amount) " }) ];
    Lino.debts.SummaryTable.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.debts.SummaryTable.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.debts.SummaryTable.GridPanel(p);
});

// js_render_GridPanel_class cbss.IdentifyPersonResult
Lino.cbss.IdentifyPersonResult.GridPanel = Ext.extend(Lino.GridPanel,{
  ls_url : "/cbss/IdentifyPersonResult",
  ls_bbar_actions : [  ],
  title : "Resultate",
  page_length : 20,
  gc_name : 0,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "name": "national_id" }, { "name": "last_name" }, { "name": "first_name" }, { "name": "address" }, { "name": "birth_date" }, { "name": "birth_location" }, { "name": "civil_state" }, { "name": "gender" }, 'genderHidden', { "name": "disabled_fields" }, { "name": "disabled_actions" } ],
  ls_grid_configs : [  ],
  viewConfig : { "emptyText": "Keine Daten anzuzeigen." },
  disable_editing : true,
  disabled_actions_index : 10,
  initComponent : function() {
    var ww = this.containing_window;
    var national_id_disp2415 = new Ext.form.DisplayField({ "disabled": true, "value": "<br/>", "always_enabled": true });
    var last_name_disp2416 = new Ext.form.DisplayField({ "disabled": true, "value": "<br/>", "always_enabled": true });
    var first_name_disp2417 = new Ext.form.DisplayField({ "disabled": true, "value": "<br/>", "always_enabled": true });
    var address_disp2418 = new Ext.form.DisplayField({ "disabled": true, "value": "<br/>", "always_enabled": true });
    var birth_date_disp2419 = new Ext.form.DisplayField({ "disabled": true, "value": "<br/>", "always_enabled": true });
    var birth_location_disp2420 = new Ext.form.DisplayField({ "disabled": true, "value": "<br/>", "always_enabled": true });
    var civil_state_disp2421 = new Ext.form.DisplayField({ "disabled": true, "value": "<br/>", "always_enabled": true });
    var gender2422 = new Lino.ChoicesFieldElement({ "disabled": true, "store": [ [ "M", "M\u00e4nnlich" ], [ "F", "Weiblich" ] ] });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ { "width": Lino.chars2width(11), "colIndex": 0, "sortable": false, "dataIndex": "national_id", "header": "NR-Nummer", "editable": false, "tooltip": "(cbss.IdentifyPersonResult.national_id) " }, { "width": Lino.chars2width(21), "colIndex": 1, "sortable": false, "dataIndex": "last_name", "header": "Familienname", "editable": false, "tooltip": "(cbss.IdentifyPersonResult.last_name) " }, { "width": Lino.chars2width(11), "colIndex": 2, "sortable": false, "dataIndex": "first_name", "header": "Vorname", "editable": false, "tooltip": "(cbss.IdentifyPersonResult.first_name) " }, { "width": Lino.chars2width(31), "colIndex": 3, "sortable": false, "dataIndex": "address", "header": "Adresse", "editable": false, "tooltip": "(cbss.IdentifyPersonResult.address) " }, { "width": Lino.chars2width(11), "colIndex": 4, "sortable": false, "dataIndex": "birth_date", "header": "Geburtsdatum", "editable": false, "tooltip": "(cbss.IdentifyPersonResult.birth_date) " }, { "width": Lino.chars2width(31), "colIndex": 5, "sortable": false, "dataIndex": "birth_location", "header": "Geburtsort", "editable": false, "tooltip": "(cbss.IdentifyPersonResult.birth_location) " }, { "width": Lino.chars2width(31), "colIndex": 6, "sortable": false, "dataIndex": "civil_state", "header": "Zivilstand", "editable": false, "tooltip": "(cbss.IdentifyPersonResult.civil_state) " }, { "width": Lino.chars2width(21), "colIndex": 7, "sortable": false, "dataIndex": "gender", "header": "Geschlecht", "editable": false, "tooltip": "(cbss.IdentifyPersonResult.gender) " } ];
    Lino.cbss.IdentifyPersonResult.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.cbss.IdentifyPersonResult.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.cbss.IdentifyPersonResult.GridPanel(p);
});

// js_render_GridPanel_class cbss.RetrieveTIGroupsResult
Lino.cbss.RetrieveTIGroupsResult.GridPanel = Ext.extend(Lino.GridPanel,{
  ls_url : "/cbss/RetrieveTIGroupsResult",
  ls_bbar_actions : [  ],
  title : "Resultate",
  page_length : 20,
  gc_name : 0,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "name": "group" }, { "name": "type" }, { "type": "date", "name": "since", "dateFormat": "d.m.Y" }, { "name": "info" }, { "name": "disabled_fields" }, { "name": "disabled_actions" } ],
  ls_grid_configs : [  ],
  viewConfig : { "emptyText": "Keine Daten anzuzeigen." },
  disable_editing : true,
  disabled_actions_index : 5,
  initComponent : function() {
    var ww = this.containing_window;
    var group_disp1797 = new Ext.form.DisplayField({ "disabled": true, "value": "<br/>", "always_enabled": true });
    var type_disp1798 = new Ext.form.DisplayField({ "disabled": true, "value": "<br/>", "always_enabled": true });
    var since1799 = new Lino.DateField({ "disabled": true });
    var info_disp1800 = new Ext.form.DisplayField({ "disabled": true, "value": "<br/>", "always_enabled": true });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ { "width": Lino.chars2width(19), "colIndex": 0, "sortable": false, "dataIndex": "group", "header": "Gruppe", "editable": false, "tooltip": "(cbss.RetrieveTIGroupsResult.group) " }, { "width": Lino.chars2width(6), "colIndex": 1, "sortable": false, "dataIndex": "type", "header": "TI", "editable": false, "tooltip": "(cbss.RetrieveTIGroupsResult.type) " }, { "colIndex": 2, "sortable": false, "xtype": "datecolumn", "format": "d.m.Y", "editable": false, "tooltip": "(cbss.RetrieveTIGroupsResult.since) ", "header": "Seit", "dataIndex": "since", "width": Lino.chars2width(15) }, { "width": Lino.chars2width(51), "colIndex": 3, "sortable": false, "dataIndex": "info", "header": "Information", "editable": false, "tooltip": "(cbss.RetrieveTIGroupsResult.info) " } ];
    Lino.cbss.RetrieveTIGroupsResult.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.cbss.RetrieveTIGroupsResult.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.cbss.RetrieveTIGroupsResult.GridPanel(p);
});

Lino.lino.Report.showPanel = Ext.extend(Lino.lino.Report.DetailFormPanel,{
  empty_title: "Report",
  hide_navigator: true,
  ls_bbar_actions: [ { "itemId": "do_print", "menu_item_text": "Drucken", "must_save": true, "tooltip": "Drucken", "panel_btn_handler": Lino.row_action_handler('do_print','GET'), "iconCls": "x-tbar-print", "overflowText": "Drucken", "auto_save": true } ],
  ls_url: "/lino/Report",
  initComponent : function() {
    this.ls_detail_handler = Lino.lino.Report.show;
    Lino.lino.Report.showPanel.superclass.initComponent.call(this);
  }
});

Lino.lino.Report.show = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.lino.Report.showPanel(p);
});

Lino.lino.Report.showPanel = Ext.extend(Lino.lino.Report.DetailFormPanel,{
  empty_title: "Report",
  hide_navigator: true,
  ls_bbar_actions: [ { "itemId": "do_print", "menu_item_text": "Drucken", "must_save": true, "tooltip": "Drucken", "panel_btn_handler": Lino.row_action_handler('do_print','GET'), "iconCls": "x-tbar-print", "overflowText": "Drucken", "auto_save": true } ],
  ls_url: "/lino/Report",
  initComponent : function() {
    this.ls_detail_handler = Lino.lino.Report.show;
    Lino.lino.Report.showPanel.superclass.initComponent.call(this);
  }
});

Lino.lino.Report.show = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.lino.Report.showPanel(p);
});

Lino.about.About.showPanel = Ext.extend(Lino.about.About.DetailFormPanel,{
  empty_title: "Info",
  hide_navigator: true,
  ls_bbar_actions: [ { "itemId": "do_print", "menu_item_text": "Drucken", "must_save": true, "tooltip": "Drucken", "panel_btn_handler": Lino.row_action_handler('do_print','GET'), "iconCls": "x-tbar-print", "overflowText": "Drucken", "auto_save": true } ],
  ls_url: "/about/About",
  initComponent : function() {
    this.ls_detail_handler = Lino.about.About.show;
    Lino.about.About.showPanel.superclass.initComponent.call(this);
  }
});

Lino.about.About.show = new Lino.WindowAction({ "draggable": true, "width": Lino.chars2width(60), "maximizable": true, "modal": true, "maximized": false, "height": Lino.rows2height(20) },function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.about.About.showPanel(p);
});

Lino.about.About.showPanel = Ext.extend(Lino.about.About.DetailFormPanel,{
  empty_title: "Info",
  hide_navigator: true,
  ls_bbar_actions: [ { "itemId": "do_print", "menu_item_text": "Drucken", "must_save": true, "tooltip": "Drucken", "panel_btn_handler": Lino.row_action_handler('do_print','GET'), "iconCls": "x-tbar-print", "overflowText": "Drucken", "auto_save": true } ],
  ls_url: "/about/About",
  initComponent : function() {
    this.ls_detail_handler = Lino.about.About.show;
    Lino.about.About.showPanel.superclass.initComponent.call(this);
  }
});

Lino.about.About.show = new Lino.WindowAction({ "draggable": true, "width": Lino.chars2width(60), "maximizable": true, "modal": true, "maximized": false, "height": Lino.rows2height(20) },function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.about.About.showPanel(p);
});

Lino.system.Home.showPanel = Ext.extend(Lino.system.Home.DetailFormPanel,{
  empty_title: "Startseite",
  hide_navigator: true,
  ls_bbar_actions: [ { "itemId": "do_print", "menu_item_text": "Drucken", "must_save": true, "tooltip": "Drucken", "panel_btn_handler": Lino.row_action_handler('do_print','GET'), "iconCls": "x-tbar-print", "overflowText": "Drucken", "auto_save": true } ],
  ls_url: "/system/Home",
  initComponent : function() {
    this.ls_detail_handler = Lino.system.Home.show;
    Lino.system.Home.showPanel.superclass.initComponent.call(this);
  }
});

Lino.system.Home.show = new Lino.WindowAction({  },function(){
  var p = { "hide_window_title": true, "hide_top_toolbar": true, "is_main_window": true };
  return new Lino.system.Home.showPanel(p);
});

Lino.system.Home.showPanel = Ext.extend(Lino.system.Home.DetailFormPanel,{
  empty_title: "Startseite",
  hide_navigator: true,
  ls_bbar_actions: [ { "itemId": "do_print", "menu_item_text": "Drucken", "must_save": true, "tooltip": "Drucken", "panel_btn_handler": Lino.row_action_handler('do_print','GET'), "iconCls": "x-tbar-print", "overflowText": "Drucken", "auto_save": true } ],
  ls_url: "/system/Home",
  initComponent : function() {
    this.ls_detail_handler = Lino.system.Home.show;
    Lino.system.Home.showPanel.superclass.initComponent.call(this);
  }
});

Lino.system.Home.show = new Lino.WindowAction({  },function(){
  var p = { "hide_window_title": true, "hide_top_toolbar": true, "is_main_window": true };
  return new Lino.system.Home.showPanel(p);
});

Lino.lino.Home.showPanel = Ext.extend(Lino.lino.Home.DetailFormPanel,{
  empty_title: "Startseite",
  hide_navigator: true,
  ls_bbar_actions: [ { "itemId": "do_print", "menu_item_text": "Drucken", "must_save": true, "tooltip": "Drucken", "panel_btn_handler": Lino.row_action_handler('do_print','GET'), "iconCls": "x-tbar-print", "overflowText": "Drucken", "auto_save": true } ],
  ls_url: "/lino/Home",
  initComponent : function() {
    this.ls_detail_handler = Lino.lino.Home.show;
    Lino.lino.Home.showPanel.superclass.initComponent.call(this);
  }
});

Lino.lino.Home.show = new Lino.WindowAction({  },function(){
  var p = { "hide_window_title": true, "hide_top_toolbar": true, "is_main_window": true };
  return new Lino.lino.Home.showPanel(p);
});

Lino.lino.Home.showPanel = Ext.extend(Lino.lino.Home.DetailFormPanel,{
  empty_title: "Startseite",
  hide_navigator: true,
  ls_bbar_actions: [ { "itemId": "do_print", "menu_item_text": "Drucken", "must_save": true, "tooltip": "Drucken", "panel_btn_handler": Lino.row_action_handler('do_print','GET'), "iconCls": "x-tbar-print", "overflowText": "Drucken", "auto_save": true } ],
  ls_url: "/lino/Home",
  initComponent : function() {
    this.ls_detail_handler = Lino.lino.Home.show;
    Lino.lino.Home.showPanel.superclass.initComponent.call(this);
  }
});

Lino.lino.Home.show = new Lino.WindowAction({  },function(){
  var p = { "hide_window_title": true, "hide_top_toolbar": true, "is_main_window": true };
  return new Lino.lino.Home.showPanel(p);
});

// js_render_GridPanel_class courses.CourseRequestStates
Lino.courses.CourseRequestStates.GridPanel = Ext.extend(Lino.GridPanel,{
  ls_url : "/courses/CourseRequestStates",
  ls_bbar_actions : [  ],
  title : "Zust\u00e4nde",
  page_length : 20,
  gc_name : 0,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "name": "value" }, { "name": "name" }, { "name": "text" }, { "name": "disabled_fields" }, { "name": "disabled_actions" } ],
  ls_grid_configs : [  ],
  viewConfig : { "emptyText": "Keine Daten anzuzeigen." },
  disable_editing : true,
  disabled_actions_index : 4,
  initComponent : function() {
    var ww = this.containing_window;
    var value2424 = new Ext.form.TextField({ "disabled": true, "maxLength": 20 });
    var name2425 = new Ext.form.TextField({ "disabled": true, "maxLength": 20 });
    var text2426 = new Ext.form.TextField({ "disabled": true, "maxLength": 50 });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ { "width": Lino.chars2width(22), "colIndex": 0, "sortable": false, "dataIndex": "value", "header": "Wert", "editable": false, "tooltip": "(courses.CourseRequestStates.value) " }, { "width": Lino.chars2width(22), "colIndex": 1, "sortable": false, "dataIndex": "name", "header": "name", "editable": false, "tooltip": "(courses.CourseRequestStates.name) " }, { "width": Lino.chars2width(22), "colIndex": 2, "sortable": false, "dataIndex": "text", "header": "Text", "editable": false, "tooltip": "(courses.CourseRequestStates.text) " } ];
    Lino.courses.CourseRequestStates.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.courses.CourseRequestStates.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.courses.CourseRequestStates.GridPanel(p);
});

// js_render_GridPanel_class postings.PostingStates
Lino.postings.PostingStates.GridPanel = Ext.extend(Lino.GridPanel,{
  ls_url : "/postings/PostingStates",
  ls_bbar_actions : [  ],
  title : "Zust\u00e4nde",
  page_length : 20,
  gc_name : 0,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "name": "value" }, { "name": "name" }, { "name": "text" }, { "name": "disabled_fields" }, { "name": "disabled_actions" } ],
  ls_grid_configs : [  ],
  viewConfig : { "emptyText": "Keine Daten anzuzeigen." },
  disable_editing : true,
  disabled_actions_index : 4,
  initComponent : function() {
    var ww = this.containing_window;
    var value2428 = new Ext.form.TextField({ "disabled": true, "maxLength": 20 });
    var name2429 = new Ext.form.TextField({ "disabled": true, "maxLength": 20 });
    var text2430 = new Ext.form.TextField({ "disabled": true, "maxLength": 50 });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ { "width": Lino.chars2width(22), "colIndex": 0, "sortable": false, "dataIndex": "value", "header": "Wert", "editable": false, "tooltip": "(postings.PostingStates.value) " }, { "width": Lino.chars2width(22), "colIndex": 1, "sortable": false, "dataIndex": "name", "header": "name", "editable": false, "tooltip": "(postings.PostingStates.name) " }, { "width": Lino.chars2width(22), "colIndex": 2, "sortable": false, "dataIndex": "text", "header": "Text", "editable": false, "tooltip": "(postings.PostingStates.text) " } ];
    Lino.postings.PostingStates.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.postings.PostingStates.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.postings.PostingStates.GridPanel(p);
});

// js_render_GridPanel_class cal.DurationUnits
Lino.cal.DurationUnits.GridPanel = Ext.extend(Lino.GridPanel,{
  ls_url : "/cal/DurationUnits",
  ls_bbar_actions : [  ],
  title : "DurationUnits",
  page_length : 20,
  gc_name : 0,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "name": "value" }, { "name": "name" }, { "name": "text" }, { "name": "disabled_fields" }, { "name": "disabled_actions" } ],
  ls_grid_configs : [  ],
  viewConfig : { "emptyText": "Keine Daten anzuzeigen." },
  disable_editing : true,
  disabled_actions_index : 4,
  initComponent : function() {
    var ww = this.containing_window;
    var value2432 = new Ext.form.TextField({ "disabled": true, "maxLength": 20 });
    var name2433 = new Ext.form.TextField({ "disabled": true, "maxLength": 20 });
    var text2434 = new Ext.form.TextField({ "disabled": true, "maxLength": 50 });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ { "width": Lino.chars2width(22), "colIndex": 0, "sortable": false, "dataIndex": "value", "header": "Wert", "editable": false, "tooltip": "(cal.DurationUnits.value) " }, { "width": Lino.chars2width(22), "colIndex": 1, "sortable": false, "dataIndex": "name", "header": "name", "editable": false, "tooltip": "(cal.DurationUnits.name) " }, { "width": Lino.chars2width(22), "colIndex": 2, "sortable": false, "dataIndex": "text", "header": "Text", "editable": false, "tooltip": "(cal.DurationUnits.text) " } ];
    Lino.cal.DurationUnits.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.cal.DurationUnits.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.cal.DurationUnits.GridPanel(p);
});

// js_render_GridPanel_class cal.Weekdays
Lino.cal.Weekdays.GridPanel = Ext.extend(Lino.GridPanel,{
  ls_url : "/cal/Weekdays",
  ls_bbar_actions : [  ],
  title : "Weekdays",
  page_length : 20,
  gc_name : 0,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "name": "value" }, { "name": "name" }, { "name": "text" }, { "name": "disabled_fields" }, { "name": "disabled_actions" } ],
  ls_grid_configs : [  ],
  viewConfig : { "emptyText": "Keine Daten anzuzeigen." },
  disable_editing : true,
  disabled_actions_index : 4,
  initComponent : function() {
    var ww = this.containing_window;
    var value2436 = new Ext.form.TextField({ "disabled": true, "maxLength": 20 });
    var name2437 = new Ext.form.TextField({ "disabled": true, "maxLength": 20 });
    var text2438 = new Ext.form.TextField({ "disabled": true, "maxLength": 50 });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ { "width": Lino.chars2width(22), "colIndex": 0, "sortable": false, "dataIndex": "value", "header": "Wert", "editable": false, "tooltip": "(cal.Weekdays.value) " }, { "width": Lino.chars2width(22), "colIndex": 1, "sortable": false, "dataIndex": "name", "header": "name", "editable": false, "tooltip": "(cal.Weekdays.name) " }, { "width": Lino.chars2width(22), "colIndex": 2, "sortable": false, "dataIndex": "text", "header": "Text", "editable": false, "tooltip": "(cal.Weekdays.text) " } ];
    Lino.cal.Weekdays.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.cal.Weekdays.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.cal.Weekdays.GridPanel(p);
});

// js_render_GridPanel_class pcsw.CoachingEvents
Lino.pcsw.CoachingEvents.GridPanel = Ext.extend(Lino.GridPanel,{
  ls_url : "/pcsw/CoachingEvents",
  ls_bbar_actions : [  ],
  title : "Observed events",
  page_length : 20,
  gc_name : 0,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "name": "value" }, { "name": "name" }, { "name": "text" }, { "name": "disabled_fields" }, { "name": "disabled_actions" } ],
  ls_grid_configs : [  ],
  viewConfig : { "emptyText": "Keine Daten anzuzeigen." },
  disable_editing : true,
  disabled_actions_index : 4,
  initComponent : function() {
    var ww = this.containing_window;
    var value2440 = new Ext.form.TextField({ "disabled": true, "maxLength": 20 });
    var name2441 = new Ext.form.TextField({ "disabled": true, "maxLength": 20 });
    var text2442 = new Ext.form.TextField({ "disabled": true, "maxLength": 50 });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ { "width": Lino.chars2width(22), "colIndex": 0, "sortable": false, "dataIndex": "value", "header": "Wert", "editable": false, "tooltip": "(pcsw.CoachingEvents.value) " }, { "width": Lino.chars2width(22), "colIndex": 1, "sortable": false, "dataIndex": "name", "header": "name", "editable": false, "tooltip": "(pcsw.CoachingEvents.name) " }, { "width": Lino.chars2width(22), "colIndex": 2, "sortable": false, "dataIndex": "text", "header": "Text", "editable": false, "tooltip": "(pcsw.CoachingEvents.text) " } ];
    Lino.pcsw.CoachingEvents.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.pcsw.CoachingEvents.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.pcsw.CoachingEvents.GridPanel(p);
});

// js_render_GridPanel_class lino.YesNo
Lino.lino.YesNo.GridPanel = Ext.extend(Lino.GridPanel,{
  ls_url : "/lino/YesNo",
  ls_bbar_actions : [  ],
  title : "Ja oder Nein",
  page_length : 20,
  gc_name : 0,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "name": "value" }, { "name": "name" }, { "name": "text" }, { "name": "disabled_fields" }, { "name": "disabled_actions" } ],
  ls_grid_configs : [  ],
  viewConfig : { "emptyText": "Keine Daten anzuzeigen." },
  disable_editing : true,
  disabled_actions_index : 4,
  initComponent : function() {
    var ww = this.containing_window;
    var value2444 = new Ext.form.TextField({ "disabled": true, "maxLength": 20 });
    var name2445 = new Ext.form.TextField({ "disabled": true, "maxLength": 20 });
    var text2446 = new Ext.form.TextField({ "disabled": true, "maxLength": 50 });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ { "width": Lino.chars2width(22), "colIndex": 0, "sortable": false, "dataIndex": "value", "header": "Wert", "editable": false, "tooltip": "(lino.YesNo.value) " }, { "width": Lino.chars2width(22), "colIndex": 1, "sortable": false, "dataIndex": "name", "header": "name", "editable": false, "tooltip": "(lino.YesNo.name) " }, { "width": Lino.chars2width(22), "colIndex": 2, "sortable": false, "dataIndex": "text", "header": "Text", "editable": false, "tooltip": "(lino.YesNo.text) " } ];
    Lino.lino.YesNo.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.lino.YesNo.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.lino.YesNo.GridPanel(p);
});

// js_render_GridPanel_class accounts.AccountTypes
Lino.accounts.AccountTypes.GridPanel = Ext.extend(Lino.GridPanel,{
  ls_url : "/accounts/AccountTypes",
  ls_bbar_actions : [  ],
  title : "AccountTypes",
  page_length : 20,
  gc_name : 0,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "name": "value" }, { "name": "name" }, { "name": "text" }, { "name": "disabled_fields" }, { "name": "disabled_actions" } ],
  ls_grid_configs : [  ],
  viewConfig : { "emptyText": "Keine Daten anzuzeigen." },
  disable_editing : true,
  disabled_actions_index : 4,
  initComponent : function() {
    var ww = this.containing_window;
    var value2448 = new Ext.form.TextField({ "disabled": true, "maxLength": 20 });
    var name2449 = new Ext.form.TextField({ "disabled": true, "maxLength": 20 });
    var text2450 = new Ext.form.TextField({ "disabled": true, "maxLength": 50 });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ { "width": Lino.chars2width(22), "colIndex": 0, "sortable": false, "dataIndex": "value", "header": "Wert", "editable": false, "tooltip": "(accounts.AccountTypes.value) " }, { "width": Lino.chars2width(22), "colIndex": 1, "sortable": false, "dataIndex": "name", "header": "name", "editable": false, "tooltip": "(accounts.AccountTypes.name) " }, { "width": Lino.chars2width(22), "colIndex": 2, "sortable": false, "dataIndex": "text", "header": "Text", "editable": false, "tooltip": "(accounts.AccountTypes.text) " } ];
    Lino.accounts.AccountTypes.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.accounts.AccountTypes.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.accounts.AccountTypes.GridPanel(p);
});

// js_render_GridPanel_class cal.Recurrencies
Lino.cal.Recurrencies.GridPanel = Ext.extend(Lino.GridPanel,{
  ls_url : "/cal/Recurrencies",
  ls_bbar_actions : [  ],
  title : "Recurrencies",
  page_length : 20,
  gc_name : 0,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "name": "value" }, { "name": "name" }, { "name": "text" }, { "name": "disabled_fields" }, { "name": "disabled_actions" } ],
  ls_grid_configs : [  ],
  viewConfig : { "emptyText": "Keine Daten anzuzeigen." },
  disable_editing : true,
  disabled_actions_index : 4,
  initComponent : function() {
    var ww = this.containing_window;
    var value2452 = new Ext.form.TextField({ "disabled": true, "maxLength": 20 });
    var name2453 = new Ext.form.TextField({ "disabled": true, "maxLength": 20 });
    var text2454 = new Ext.form.TextField({ "disabled": true, "maxLength": 50 });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ { "width": Lino.chars2width(22), "colIndex": 0, "sortable": false, "dataIndex": "value", "header": "Wert", "editable": false, "tooltip": "(cal.Recurrencies.value) " }, { "width": Lino.chars2width(22), "colIndex": 1, "sortable": false, "dataIndex": "name", "header": "name", "editable": false, "tooltip": "(cal.Recurrencies.name) " }, { "width": Lino.chars2width(22), "colIndex": 2, "sortable": false, "dataIndex": "text", "header": "Text", "editable": false, "tooltip": "(cal.Recurrencies.text) " } ];
    Lino.cal.Recurrencies.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.cal.Recurrencies.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.cal.Recurrencies.GridPanel(p);
});

// js_render_GridPanel_class properties.HowWell
Lino.properties.HowWell.GridPanel = Ext.extend(Lino.GridPanel,{
  ls_url : "/properties/HowWell",
  ls_bbar_actions : [  ],
  title : "HowWell",
  page_length : 20,
  gc_name : 0,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "name": "value" }, { "name": "name" }, { "name": "text" }, { "name": "disabled_fields" }, { "name": "disabled_actions" } ],
  ls_grid_configs : [  ],
  viewConfig : { "emptyText": "Keine Daten anzuzeigen." },
  disable_editing : true,
  disabled_actions_index : 4,
  initComponent : function() {
    var ww = this.containing_window;
    var value2456 = new Ext.form.TextField({ "disabled": true, "maxLength": 20 });
    var name2457 = new Ext.form.TextField({ "disabled": true, "maxLength": 20 });
    var text2458 = new Ext.form.TextField({ "disabled": true, "maxLength": 50 });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ { "width": Lino.chars2width(22), "colIndex": 0, "sortable": false, "dataIndex": "value", "header": "Wert", "editable": false, "tooltip": "(properties.HowWell.value) " }, { "width": Lino.chars2width(22), "colIndex": 1, "sortable": false, "dataIndex": "name", "header": "name", "editable": false, "tooltip": "(properties.HowWell.name) " }, { "width": Lino.chars2width(22), "colIndex": 2, "sortable": false, "dataIndex": "text", "header": "Text", "editable": false, "tooltip": "(properties.HowWell.text) " } ];
    Lino.properties.HowWell.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.properties.HowWell.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.properties.HowWell.GridPanel(p);
});

// js_render_GridPanel_class cv.CefLevel
Lino.cv.CefLevel.GridPanel = Ext.extend(Lino.GridPanel,{
  ls_url : "/cv/CefLevel",
  ls_bbar_actions : [  ],
  title : "CEF-Kategorien",
  page_length : 20,
  gc_name : 0,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "name": "value" }, { "name": "name" }, { "name": "text" }, { "name": "disabled_fields" }, { "name": "disabled_actions" } ],
  ls_grid_configs : [  ],
  viewConfig : { "emptyText": "Keine Daten anzuzeigen." },
  disable_editing : true,
  disabled_actions_index : 4,
  initComponent : function() {
    var ww = this.containing_window;
    var value2460 = new Ext.form.TextField({ "disabled": true, "maxLength": 20 });
    var name2461 = new Ext.form.TextField({ "disabled": true, "maxLength": 20 });
    var text2462 = new Ext.form.TextField({ "disabled": true, "maxLength": 50 });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ { "width": Lino.chars2width(22), "colIndex": 0, "sortable": false, "dataIndex": "value", "header": "Wert", "editable": false, "tooltip": "(cv.CefLevel.value) " }, { "width": Lino.chars2width(22), "colIndex": 1, "sortable": false, "dataIndex": "name", "header": "name", "editable": false, "tooltip": "(cv.CefLevel.name) " }, { "width": Lino.chars2width(22), "colIndex": 2, "sortable": false, "dataIndex": "text", "header": "Text", "editable": false, "tooltip": "(cv.CefLevel.text) " } ];
    Lino.cv.CefLevel.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.cv.CefLevel.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.cv.CefLevel.GridPanel(p);
});

// js_render_GridPanel_class jobs.CandidatureStates
Lino.jobs.CandidatureStates.GridPanel = Ext.extend(Lino.GridPanel,{
  ls_url : "/jobs/CandidatureStates",
  ls_bbar_actions : [  ],
  title : "Kandidatur-Zust\u00e4nde",
  page_length : 20,
  gc_name : 0,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "name": "value" }, { "name": "name" }, { "name": "text" }, { "name": "disabled_fields" }, { "name": "disabled_actions" } ],
  ls_grid_configs : [  ],
  viewConfig : { "emptyText": "Keine Daten anzuzeigen." },
  disable_editing : true,
  disabled_actions_index : 4,
  initComponent : function() {
    var ww = this.containing_window;
    var value2464 = new Ext.form.TextField({ "disabled": true, "maxLength": 20 });
    var name2465 = new Ext.form.TextField({ "disabled": true, "maxLength": 20 });
    var text2466 = new Ext.form.TextField({ "disabled": true, "maxLength": 50 });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ { "width": Lino.chars2width(22), "colIndex": 0, "sortable": false, "dataIndex": "value", "header": "Wert", "editable": false, "tooltip": "(jobs.CandidatureStates.value) " }, { "width": Lino.chars2width(22), "colIndex": 1, "sortable": false, "dataIndex": "name", "header": "name", "editable": false, "tooltip": "(jobs.CandidatureStates.name) " }, { "width": Lino.chars2width(22), "colIndex": 2, "sortable": false, "dataIndex": "text", "header": "Text", "editable": false, "tooltip": "(jobs.CandidatureStates.text) " } ];
    Lino.jobs.CandidatureStates.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.jobs.CandidatureStates.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.jobs.CandidatureStates.GridPanel(p);
});

// js_render_GridPanel_class outbox.RecipientType
Lino.outbox.RecipientType.GridPanel = Ext.extend(Lino.GridPanel,{
  ls_url : "/outbox/RecipientType",
  ls_bbar_actions : [  ],
  title : "RecipientType",
  page_length : 20,
  gc_name : 0,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "name": "value" }, { "name": "name" }, { "name": "text" }, { "name": "disabled_fields" }, { "name": "disabled_actions" } ],
  ls_grid_configs : [  ],
  viewConfig : { "emptyText": "Keine Daten anzuzeigen." },
  disable_editing : true,
  disabled_actions_index : 4,
  initComponent : function() {
    var ww = this.containing_window;
    var value2468 = new Ext.form.TextField({ "disabled": true, "maxLength": 20 });
    var name2469 = new Ext.form.TextField({ "disabled": true, "maxLength": 20 });
    var text2470 = new Ext.form.TextField({ "disabled": true, "maxLength": 50 });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ { "width": Lino.chars2width(22), "colIndex": 0, "sortable": false, "dataIndex": "value", "header": "Wert", "editable": false, "tooltip": "(outbox.RecipientType.value) " }, { "width": Lino.chars2width(22), "colIndex": 1, "sortable": false, "dataIndex": "name", "header": "name", "editable": false, "tooltip": "(outbox.RecipientType.name) " }, { "width": Lino.chars2width(22), "colIndex": 2, "sortable": false, "dataIndex": "text", "header": "Text", "editable": false, "tooltip": "(outbox.RecipientType.text) " } ];
    Lino.outbox.RecipientType.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.outbox.RecipientType.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.outbox.RecipientType.GridPanel(p);
});

// js_render_GridPanel_class countries.CityTypes
Lino.countries.CityTypes.GridPanel = Ext.extend(Lino.GridPanel,{
  ls_url : "/countries/CityTypes",
  ls_bbar_actions : [  ],
  title : "CityTypes",
  page_length : 20,
  gc_name : 0,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "name": "value" }, { "name": "name" }, { "name": "text" }, { "name": "disabled_fields" }, { "name": "disabled_actions" } ],
  ls_grid_configs : [  ],
  viewConfig : { "emptyText": "Keine Daten anzuzeigen." },
  disable_editing : true,
  disabled_actions_index : 4,
  initComponent : function() {
    var ww = this.containing_window;
    var value2472 = new Ext.form.TextField({ "disabled": true, "maxLength": 20 });
    var name2473 = new Ext.form.TextField({ "disabled": true, "maxLength": 20 });
    var text2474 = new Ext.form.TextField({ "disabled": true, "maxLength": 50 });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ { "width": Lino.chars2width(22), "colIndex": 0, "sortable": false, "dataIndex": "value", "header": "Wert", "editable": false, "tooltip": "(countries.CityTypes.value) " }, { "width": Lino.chars2width(22), "colIndex": 1, "sortable": false, "dataIndex": "name", "header": "name", "editable": false, "tooltip": "(countries.CityTypes.name) " }, { "width": Lino.chars2width(22), "colIndex": 2, "sortable": false, "dataIndex": "text", "header": "Text", "editable": false, "tooltip": "(countries.CityTypes.text) " } ];
    Lino.countries.CityTypes.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.countries.CityTypes.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.countries.CityTypes.GridPanel(p);
});

// js_render_GridPanel_class properties.DoYouLike
Lino.properties.DoYouLike.GridPanel = Ext.extend(Lino.GridPanel,{
  ls_url : "/properties/DoYouLike",
  ls_bbar_actions : [  ],
  title : "DoYouLike",
  page_length : 20,
  gc_name : 0,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "name": "value" }, { "name": "name" }, { "name": "text" }, { "name": "disabled_fields" }, { "name": "disabled_actions" } ],
  ls_grid_configs : [  ],
  viewConfig : { "emptyText": "Keine Daten anzuzeigen." },
  disable_editing : true,
  disabled_actions_index : 4,
  initComponent : function() {
    var ww = this.containing_window;
    var value2476 = new Ext.form.TextField({ "disabled": true, "maxLength": 20 });
    var name2477 = new Ext.form.TextField({ "disabled": true, "maxLength": 20 });
    var text2478 = new Ext.form.TextField({ "disabled": true, "maxLength": 50 });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ { "width": Lino.chars2width(22), "colIndex": 0, "sortable": false, "dataIndex": "value", "header": "Wert", "editable": false, "tooltip": "(properties.DoYouLike.value) " }, { "width": Lino.chars2width(22), "colIndex": 1, "sortable": false, "dataIndex": "name", "header": "name", "editable": false, "tooltip": "(properties.DoYouLike.name) " }, { "width": Lino.chars2width(22), "colIndex": 2, "sortable": false, "dataIndex": "text", "header": "Text", "editable": false, "tooltip": "(properties.DoYouLike.text) " } ];
    Lino.properties.DoYouLike.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.properties.DoYouLike.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.properties.DoYouLike.GridPanel(p);
});

// js_render_GridPanel_class cbss.RequestLanguages
Lino.cbss.RequestLanguages.GridPanel = Ext.extend(Lino.GridPanel,{
  ls_url : "/cbss/RequestLanguages",
  ls_bbar_actions : [  ],
  title : "RequestLanguages",
  page_length : 20,
  gc_name : 0,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "name": "value" }, { "name": "name" }, { "name": "text" }, { "name": "disabled_fields" }, { "name": "disabled_actions" } ],
  ls_grid_configs : [  ],
  viewConfig : { "emptyText": "Keine Daten anzuzeigen." },
  disable_editing : true,
  disabled_actions_index : 4,
  initComponent : function() {
    var ww = this.containing_window;
    var value2480 = new Ext.form.TextField({ "disabled": true, "maxLength": 20 });
    var name2481 = new Ext.form.TextField({ "disabled": true, "maxLength": 20 });
    var text2482 = new Ext.form.TextField({ "disabled": true, "maxLength": 50 });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ { "width": Lino.chars2width(22), "colIndex": 0, "sortable": false, "dataIndex": "value", "header": "Wert", "editable": false, "tooltip": "(cbss.RequestLanguages.value) " }, { "width": Lino.chars2width(22), "colIndex": 1, "sortable": false, "dataIndex": "name", "header": "name", "editable": false, "tooltip": "(cbss.RequestLanguages.name) " }, { "width": Lino.chars2width(22), "colIndex": 2, "sortable": false, "dataIndex": "text", "header": "Text", "editable": false, "tooltip": "(cbss.RequestLanguages.text) " } ];
    Lino.cbss.RequestLanguages.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.cbss.RequestLanguages.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.cbss.RequestLanguages.GridPanel(p);
});

// js_render_GridPanel_class cbss.ManageAction
Lino.cbss.ManageAction.GridPanel = Ext.extend(Lino.GridPanel,{
  ls_url : "/cbss/ManageAction",
  ls_bbar_actions : [  ],
  title : "ManageAction",
  page_length : 20,
  gc_name : 0,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "name": "value" }, { "name": "name" }, { "name": "text" }, { "name": "disabled_fields" }, { "name": "disabled_actions" } ],
  ls_grid_configs : [  ],
  viewConfig : { "emptyText": "Keine Daten anzuzeigen." },
  disable_editing : true,
  disabled_actions_index : 4,
  initComponent : function() {
    var ww = this.containing_window;
    var value2484 = new Ext.form.TextField({ "disabled": true, "maxLength": 20 });
    var name2485 = new Ext.form.TextField({ "disabled": true, "maxLength": 20 });
    var text2486 = new Ext.form.TextField({ "disabled": true, "maxLength": 50 });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ { "width": Lino.chars2width(22), "colIndex": 0, "sortable": false, "dataIndex": "value", "header": "Wert", "editable": false, "tooltip": "(cbss.ManageAction.value) " }, { "width": Lino.chars2width(22), "colIndex": 1, "sortable": false, "dataIndex": "name", "header": "name", "editable": false, "tooltip": "(cbss.ManageAction.name) " }, { "width": Lino.chars2width(22), "colIndex": 2, "sortable": false, "dataIndex": "text", "header": "Text", "editable": false, "tooltip": "(cbss.ManageAction.text) " } ];
    Lino.cbss.ManageAction.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.cbss.ManageAction.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.cbss.ManageAction.GridPanel(p);
});

// js_render_GridPanel_class pcsw.RefusalReasons
Lino.pcsw.RefusalReasons.GridPanel = Ext.extend(Lino.GridPanel,{
  ls_url : "/pcsw/RefusalReasons",
  ls_bbar_actions : [  ],
  title : "RefusalReasons",
  page_length : 20,
  gc_name : 0,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "name": "value" }, { "name": "name" }, { "name": "text" }, { "name": "disabled_fields" }, { "name": "disabled_actions" } ],
  ls_grid_configs : [  ],
  viewConfig : { "emptyText": "Keine Daten anzuzeigen." },
  disable_editing : true,
  disabled_actions_index : 4,
  initComponent : function() {
    var ww = this.containing_window;
    var value2488 = new Ext.form.TextField({ "disabled": true, "maxLength": 20 });
    var name2489 = new Ext.form.TextField({ "disabled": true, "maxLength": 20 });
    var text2490 = new Ext.form.TextField({ "disabled": true, "maxLength": 50 });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ { "width": Lino.chars2width(22), "colIndex": 0, "sortable": false, "dataIndex": "value", "header": "Wert", "editable": false, "tooltip": "(pcsw.RefusalReasons.value) " }, { "width": Lino.chars2width(22), "colIndex": 1, "sortable": false, "dataIndex": "name", "header": "name", "editable": false, "tooltip": "(pcsw.RefusalReasons.name) " }, { "width": Lino.chars2width(22), "colIndex": 2, "sortable": false, "dataIndex": "text", "header": "Text", "editable": false, "tooltip": "(pcsw.RefusalReasons.text) " } ];
    Lino.pcsw.RefusalReasons.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.pcsw.RefusalReasons.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.pcsw.RefusalReasons.GridPanel(p);
});

// js_render_GridPanel_class cbss.RequestStates
Lino.cbss.RequestStates.GridPanel = Ext.extend(Lino.GridPanel,{
  ls_url : "/cbss/RequestStates",
  ls_bbar_actions : [  ],
  title : "Zust\u00e4nde",
  page_length : 20,
  gc_name : 0,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "name": "value" }, { "name": "name" }, { "name": "text" }, { "name": "disabled_fields" }, { "name": "disabled_actions" } ],
  ls_grid_configs : [  ],
  viewConfig : { "emptyText": "Keine Daten anzuzeigen." },
  disable_editing : true,
  disabled_actions_index : 4,
  initComponent : function() {
    var ww = this.containing_window;
    var value2492 = new Ext.form.TextField({ "disabled": true, "maxLength": 20 });
    var name2493 = new Ext.form.TextField({ "disabled": true, "maxLength": 20 });
    var text2494 = new Ext.form.TextField({ "disabled": true, "maxLength": 50 });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ { "width": Lino.chars2width(22), "colIndex": 0, "sortable": false, "dataIndex": "value", "header": "Wert", "editable": false, "tooltip": "(cbss.RequestStates.value) " }, { "width": Lino.chars2width(22), "colIndex": 1, "sortable": false, "dataIndex": "name", "header": "name", "editable": false, "tooltip": "(cbss.RequestStates.name) " }, { "width": Lino.chars2width(22), "colIndex": 2, "sortable": false, "dataIndex": "text", "header": "Text", "editable": false, "tooltip": "(cbss.RequestStates.text) " } ];
    Lino.cbss.RequestStates.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.cbss.RequestStates.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.cbss.RequestStates.GridPanel(p);
});

// js_render_GridPanel_class lino.ChangeTypes
Lino.lino.ChangeTypes.GridPanel = Ext.extend(Lino.GridPanel,{
  ls_url : "/lino/ChangeTypes",
  ls_bbar_actions : [  ],
  title : "\u00c4nderungsarten",
  page_length : 20,
  gc_name : 0,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "name": "value" }, { "name": "name" }, { "name": "text" }, { "name": "disabled_fields" }, { "name": "disabled_actions" } ],
  ls_grid_configs : [  ],
  viewConfig : { "emptyText": "Keine Daten anzuzeigen." },
  disable_editing : true,
  disabled_actions_index : 4,
  initComponent : function() {
    var ww = this.containing_window;
    var value2496 = new Ext.form.TextField({ "disabled": true, "maxLength": 20 });
    var name2497 = new Ext.form.TextField({ "disabled": true, "maxLength": 20 });
    var text2498 = new Ext.form.TextField({ "disabled": true, "maxLength": 50 });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ { "width": Lino.chars2width(22), "colIndex": 0, "sortable": false, "dataIndex": "value", "header": "Wert", "editable": false, "tooltip": "(lino.ChangeTypes.value) " }, { "width": Lino.chars2width(22), "colIndex": 1, "sortable": false, "dataIndex": "name", "header": "name", "editable": false, "tooltip": "(lino.ChangeTypes.name) " }, { "width": Lino.chars2width(22), "colIndex": 2, "sortable": false, "dataIndex": "text", "header": "Text", "editable": false, "tooltip": "(lino.ChangeTypes.text) " } ];
    Lino.lino.ChangeTypes.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.lino.ChangeTypes.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.lino.ChangeTypes.GridPanel(p);
});

// js_render_GridPanel_class cal.AccessClasses
Lino.cal.AccessClasses.GridPanel = Ext.extend(Lino.GridPanel,{
  ls_url : "/cal/AccessClasses",
  ls_bbar_actions : [  ],
  title : "AccessClasses",
  page_length : 20,
  gc_name : 0,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "name": "value" }, { "name": "name" }, { "name": "text" }, { "name": "disabled_fields" }, { "name": "disabled_actions" } ],
  ls_grid_configs : [  ],
  viewConfig : { "emptyText": "Keine Daten anzuzeigen." },
  disable_editing : true,
  disabled_actions_index : 4,
  initComponent : function() {
    var ww = this.containing_window;
    var value2500 = new Ext.form.TextField({ "disabled": true, "maxLength": 20 });
    var name2501 = new Ext.form.TextField({ "disabled": true, "maxLength": 20 });
    var text2502 = new Ext.form.TextField({ "disabled": true, "maxLength": 50 });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ { "width": Lino.chars2width(22), "colIndex": 0, "sortable": false, "dataIndex": "value", "header": "Wert", "editable": false, "tooltip": "(cal.AccessClasses.value) " }, { "width": Lino.chars2width(22), "colIndex": 1, "sortable": false, "dataIndex": "name", "header": "name", "editable": false, "tooltip": "(cal.AccessClasses.name) " }, { "width": Lino.chars2width(22), "colIndex": 2, "sortable": false, "dataIndex": "text", "header": "Text", "editable": false, "tooltip": "(cal.AccessClasses.text) " } ];
    Lino.cal.AccessClasses.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.cal.AccessClasses.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.cal.AccessClasses.GridPanel(p);
});

// js_render_GridPanel_class cbss.QueryRegister
Lino.cbss.QueryRegister.GridPanel = Ext.extend(Lino.GridPanel,{
  ls_url : "/cbss/QueryRegister",
  ls_bbar_actions : [  ],
  title : "QueryRegister",
  page_length : 20,
  gc_name : 0,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "name": "value" }, { "name": "name" }, { "name": "text" }, { "name": "disabled_fields" }, { "name": "disabled_actions" } ],
  ls_grid_configs : [  ],
  viewConfig : { "emptyText": "Keine Daten anzuzeigen." },
  disable_editing : true,
  disabled_actions_index : 4,
  initComponent : function() {
    var ww = this.containing_window;
    var value2504 = new Ext.form.TextField({ "disabled": true, "maxLength": 20 });
    var name2505 = new Ext.form.TextField({ "disabled": true, "maxLength": 20 });
    var text2506 = new Ext.form.TextField({ "disabled": true, "maxLength": 50 });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ { "width": Lino.chars2width(22), "colIndex": 0, "sortable": false, "dataIndex": "value", "header": "Wert", "editable": false, "tooltip": "(cbss.QueryRegister.value) " }, { "width": Lino.chars2width(22), "colIndex": 1, "sortable": false, "dataIndex": "name", "header": "name", "editable": false, "tooltip": "(cbss.QueryRegister.name) " }, { "width": Lino.chars2width(22), "colIndex": 2, "sortable": false, "dataIndex": "text", "header": "Text", "editable": false, "tooltip": "(cbss.QueryRegister.text) " } ];
    Lino.cbss.QueryRegister.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.cbss.QueryRegister.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.cbss.QueryRegister.GridPanel(p);
});

// js_render_GridPanel_class isip.ContractEvents
Lino.isip.ContractEvents.GridPanel = Ext.extend(Lino.GridPanel,{
  ls_url : "/isip/ContractEvents",
  ls_bbar_actions : [  ],
  title : "Observed events",
  page_length : 20,
  gc_name : 0,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "name": "value" }, { "name": "name" }, { "name": "text" }, { "name": "disabled_fields" }, { "name": "disabled_actions" } ],
  ls_grid_configs : [  ],
  viewConfig : { "emptyText": "Keine Daten anzuzeigen." },
  disable_editing : true,
  disabled_actions_index : 4,
  initComponent : function() {
    var ww = this.containing_window;
    var value2508 = new Ext.form.TextField({ "disabled": true, "maxLength": 20 });
    var name2509 = new Ext.form.TextField({ "disabled": true, "maxLength": 20 });
    var text2510 = new Ext.form.TextField({ "disabled": true, "maxLength": 50 });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ { "width": Lino.chars2width(22), "colIndex": 0, "sortable": false, "dataIndex": "value", "header": "Wert", "editable": false, "tooltip": "(isip.ContractEvents.value) " }, { "width": Lino.chars2width(22), "colIndex": 1, "sortable": false, "dataIndex": "name", "header": "name", "editable": false, "tooltip": "(isip.ContractEvents.name) " }, { "width": Lino.chars2width(22), "colIndex": 2, "sortable": false, "dataIndex": "text", "header": "Text", "editable": false, "tooltip": "(isip.ContractEvents.text) " } ];
    Lino.isip.ContractEvents.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.isip.ContractEvents.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.isip.ContractEvents.GridPanel(p);
});

// js_render_GridPanel_class lino.Genders
Lino.lino.Genders.GridPanel = Ext.extend(Lino.GridPanel,{
  ls_url : "/lino/Genders",
  ls_bbar_actions : [  ],
  title : "Genders",
  page_length : 20,
  gc_name : 0,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "name": "value" }, { "name": "name" }, { "name": "text" }, { "name": "disabled_fields" }, { "name": "disabled_actions" } ],
  ls_grid_configs : [  ],
  viewConfig : { "emptyText": "Keine Daten anzuzeigen." },
  disable_editing : true,
  disabled_actions_index : 4,
  initComponent : function() {
    var ww = this.containing_window;
    var value2512 = new Ext.form.TextField({ "disabled": true, "maxLength": 20 });
    var name2513 = new Ext.form.TextField({ "disabled": true, "maxLength": 20 });
    var text2514 = new Ext.form.TextField({ "disabled": true, "maxLength": 50 });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ { "width": Lino.chars2width(22), "colIndex": 0, "sortable": false, "dataIndex": "value", "header": "Wert", "editable": false, "tooltip": "(lino.Genders.value) " }, { "width": Lino.chars2width(22), "colIndex": 1, "sortable": false, "dataIndex": "name", "header": "name", "editable": false, "tooltip": "(lino.Genders.name) " }, { "width": Lino.chars2width(22), "colIndex": 2, "sortable": false, "dataIndex": "text", "header": "Text", "editable": false, "tooltip": "(lino.Genders.text) " } ];
    Lino.lino.Genders.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.lino.Genders.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.lino.Genders.GridPanel(p);
});

// js_render_GridPanel_class pcsw.ClientEvents
Lino.pcsw.ClientEvents.GridPanel = Ext.extend(Lino.GridPanel,{
  ls_url : "/pcsw/ClientEvents",
  ls_bbar_actions : [  ],
  title : "Observed events",
  page_length : 20,
  gc_name : 0,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "name": "value" }, { "name": "name" }, { "name": "text" }, { "name": "disabled_fields" }, { "name": "disabled_actions" } ],
  ls_grid_configs : [  ],
  viewConfig : { "emptyText": "Keine Daten anzuzeigen." },
  disable_editing : true,
  disabled_actions_index : 4,
  initComponent : function() {
    var ww = this.containing_window;
    var value2516 = new Ext.form.TextField({ "disabled": true, "maxLength": 20 });
    var name2517 = new Ext.form.TextField({ "disabled": true, "maxLength": 20 });
    var text2518 = new Ext.form.TextField({ "disabled": true, "maxLength": 50 });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ { "width": Lino.chars2width(22), "colIndex": 0, "sortable": false, "dataIndex": "value", "header": "Wert", "editable": false, "tooltip": "(pcsw.ClientEvents.value) " }, { "width": Lino.chars2width(22), "colIndex": 1, "sortable": false, "dataIndex": "name", "header": "name", "editable": false, "tooltip": "(pcsw.ClientEvents.name) " }, { "width": Lino.chars2width(22), "colIndex": 2, "sortable": false, "dataIndex": "text", "header": "Text", "editable": false, "tooltip": "(pcsw.ClientEvents.text) " } ];
    Lino.pcsw.ClientEvents.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.pcsw.ClientEvents.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.pcsw.ClientEvents.GridPanel(p);
});

// js_render_GridPanel_class pcsw.ResidenceType
Lino.pcsw.ResidenceType.GridPanel = Ext.extend(Lino.GridPanel,{
  ls_url : "/pcsw/ResidenceType",
  ls_bbar_actions : [  ],
  title : "ResidenceType",
  page_length : 20,
  gc_name : 0,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "name": "value" }, { "name": "name" }, { "name": "text" }, { "name": "disabled_fields" }, { "name": "disabled_actions" } ],
  ls_grid_configs : [  ],
  viewConfig : { "emptyText": "Keine Daten anzuzeigen." },
  disable_editing : true,
  disabled_actions_index : 4,
  initComponent : function() {
    var ww = this.containing_window;
    var value2520 = new Ext.form.TextField({ "disabled": true, "maxLength": 20 });
    var name2521 = new Ext.form.TextField({ "disabled": true, "maxLength": 20 });
    var text2522 = new Ext.form.TextField({ "disabled": true, "maxLength": 50 });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ { "width": Lino.chars2width(22), "colIndex": 0, "sortable": false, "dataIndex": "value", "header": "Wert", "editable": false, "tooltip": "(pcsw.ResidenceType.value) " }, { "width": Lino.chars2width(22), "colIndex": 1, "sortable": false, "dataIndex": "name", "header": "name", "editable": false, "tooltip": "(pcsw.ResidenceType.name) " }, { "width": Lino.chars2width(22), "colIndex": 2, "sortable": false, "dataIndex": "text", "header": "Text", "editable": false, "tooltip": "(pcsw.ResidenceType.text) " } ];
    Lino.pcsw.ResidenceType.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.pcsw.ResidenceType.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.pcsw.ResidenceType.GridPanel(p);
});
