/*
 Copyright 2009-2013 Luc Saffre
 This file is part of the Lino project.
 Lino is free software; you can redistribute it and/or modify 
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 3 of the License, or
 (at your option) any later version.
 Lino is distributed in the hope that it will be useful, 
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the 
 GNU General Public License for more details.
 You should have received a copy of the GNU General Public License
 along with Lino; if not, see <http://www.gnu.org/licenses/>.
*/

// lino.js --- generated Thu Aug 29 15:39:39 2013 by Lino version 1.6.11.
Ext.BLANK_IMAGE_URL = '/media/extjs/resources/images/default/s.gif';
LANGUAGE_CHOICES = [ [ "en", "Englisch" ], [ "fr", "Franz\u00f6sisch" ], [ "de", "Deutsch" ], [ "nl", "Niederl\u00e4ndisch" ] ];
MEDIA_URL = "/media";

/* MonthPickerPlugin: thanks to keypoint @ sencha forum
   http://www.sencha.com/forum/showthread.php?74002-3.x-Ext.ux.MonthMenu&p=356860#post356860
*/
Ext.namespace('Ext.ux'); 

Ext.ux.MonthPickerPlugin = function() { 
    var picker; 
    var oldDateDefaults; 

    this.init = function(pk) { 
        picker = pk; 
        picker.onTriggerClick = picker.onTriggerClick.createSequence(onClick); 
        picker.getValue = picker.getValue.createInterceptor(setDefaultMonthDay).createSequence(restoreDefaultMonthDay); 
        picker.beforeBlur = picker.beforeBlur.createInterceptor(setDefaultMonthDay).createSequence(restoreDefaultMonthDay); 
    }; 

    function setDefaultMonthDay() { 
        oldDateDefaults = Date.defaults.d; 
        Date.defaults.d = 1; 
        return true; 
    } 

    function restoreDefaultMonthDay(ret) { 
        Date.defaults.d = oldDateDefaults; 
        return ret; 
    } 

    function onClick(e, el, opt) { 
        var p = picker.menu.picker; 
        p.activeDate = p.activeDate.getFirstDateOfMonth(); 
        if (p.value) { 
            p.value = p.value.getFirstDateOfMonth(); 
        } 

        p.showMonthPicker(); 
         
        if (!p.disabled) { 
            p.monthPicker.stopFx(); 
            p.monthPicker.show(); 

            p.mun(p.monthPicker, 'click', p.onMonthClick, p); 
            p.mun(p.monthPicker, 'dblclick', p.onMonthDblClick, p); 
            p.onMonthClick = p.onMonthClick.createSequence(pickerClick); 
            p.onMonthDblClick = p.onMonthDblClick.createSequence(pickerDblclick); 
            p.mon(p.monthPicker, 'click', p.onMonthClick, p); 
            p.mon(p.monthPicker, 'dblclick', p.onMonthDblClick, p); 
        } 
    } 

    function pickerClick(e, t) { 
        var el = new Ext.Element(t); 
        if (el.is('button.x-date-mp-cancel')) { 
            picker.menu.hide(); 
        } else if(el.is('button.x-date-mp-ok')) { 
            var p = picker.menu.picker; 
            p.setValue(p.activeDate); 
            p.fireEvent('select', p, p.value); 
        } 
    } 

    function pickerDblclick(e, t) { 
        var el = new Ext.Element(t); 
        if (el.parent() 
            && (el.parent().is('td.x-date-mp-month') 
            || el.parent().is('td.x-date-mp-year'))) { 

            var p = picker.menu.picker; 
            p.setValue(p.activeDate); 
            p.fireEvent('select', p, p.value); 
        } 
    } 
}; 

Ext.preg('monthPickerPlugin', Ext.ux.MonthPickerPlugin);  

//~ /* 
  //~ http://www.diloc.de/blog/2008/03/05/how-to-submit-ext-forms-the-right-way/
//~ */
//~ /**
 //~ * This submit action is basically the same as the normal submit action,
 //~ * only that it uses the fields getSubmitValue() to compose the values to submit,
 //~ * instead of looping over the input-tags in the form-tag of the form.
 //~ *
 //~ * To use it, just use the OOSubmit-plugin on either a FormPanel or a BasicForm,
 //~ * or explicitly call form.doAction('oosubmit');
 //~ *
 //~ * @param {Object} form
 //~ * @param {Object} options
 //~ */
//~ Ext.ux.OOSubmitAction = function(form, options){
    //~ Ext.ux.OOSubmitAction.superclass.constructor.call(this, form, options);
//~ };

//~ Ext.extend(Ext.ux.OOSubmitAction, Ext.form.Action.Submit, {
    //~ /**
    //~ * @cfg {boolean} clientValidation Determines whether a Form's fields are validated
    //~ * in a final call to {@link Ext.form.BasicForm#isValid isValid} prior to submission.
    //~ * Pass <tt>false</tt> in the Form's submit options to prevent this. If not defined, pre-submission field validation
    //~ * is performed.
    //~ */
    //~ type : 'oosubmit',

    //~ // private
    //~ /**
     //~ * This is nearly a copy of the original submit action run method
     //~ */
    //~ run : function(){
        //~ var o = this.options;
        //~ var method = this.getMethod();
        //~ var isPost = method == 'POST';

        //~ var params = this.options.params || {};
        //~ if (isPost) Ext.applyIf(params, this.form.baseParams);

        //~ //now add the form parameters
        //~ this.form.items.each(function(field)
        //~ {
            //~ if (!field.disabled)
            //~ {
                //~ //check if the form item provides a specialized getSubmitValue() and use that if available
                //~ if (typeof field.getSubmitValue == "function")
                    //~ params[field.getName()] = field.getSubmitValue();
                //~ else
                    //~ params[field.getName()] = field.getValue();
            //~ }
        //~ });

        //~ //convert params to get style if we are not post
        //~ if (!isPost) params=Ext.urlEncode(params);

        //~ if(o.clientValidation === false || this.form.isValid()){
            //~ Ext.Ajax.request(Ext.apply(this.createCallback(o), {
                //~ url:this.getUrl(!isPost),
                //~ method: method,
                //~ params:params, //add our values
                //~ isUpload: this.form.fileUpload
            //~ }));

        //~ }else if (o.clientValidation !== false){ // client validation failed
            //~ this.failureType = Ext.form.Action.CLIENT_INVALID;
            //~ this.form.afterAction(this, false);
        //~ }
    //~ },

//~ });
//~ //add our action to the registry of known actions
//~ Ext.form.Action.ACTION_TYPES['oosubmit'] = Ext.ux.OOSubmitAction;




/**
JC Watsons solution (adapted to ExtJS 3.3.1 by LS) is elegant and simple:
`A "fix" for unchecked checkbox submission  behaviour
<http://www.sencha.com/forum/showthread.php?28449>`_

Added special handling for checkbox inputs. 
ExtJS defines disabled checkboxes `readonly`, not `disabled` as for other inputs.

*/
Ext.lib.Ajax.serializeForm = function(form) {
    //~ console.log('20120203 linolib.js serializeForm',form);
    var fElements = form.elements || (document.forms[form] || Ext.getDom(form)).elements, 
        hasSubmit = false, 
        encoder = encodeURIComponent, 
        name, 
        data = '', 
        type, 
        hasValue;

    Ext.each(fElements, function(element){
        name = element.name;
        type = element.type;

        if (!element.disabled && name && !(type == 'checkbox' && element.readonly)) {
            if (/select-(one|multiple)/i.test(type)) {
                Ext.each(element.options, function(opt){
                    if (opt.selected) {
                        hasValue = opt.hasAttribute ? opt.hasAttribute('value') : opt.getAttributeNode('value').specified;
                        data += String.format("{0}={1}&", encoder(name), encoder(hasValue ? opt.value : opt.text));
                    }
                });
            } else if (!(/file|undefined|reset|button/i.test(type))) {
                //~ if (!(/radio|checkbox/i.test(type) && !element.checked) && !(type == 'submit' && hasSubmit)) {
                if (!(type == 'submit' && hasSubmit)) {
                    if (type == 'checkbox') {
                        //~ console.log('20111001',element,'data += ',encoder(name) + '=' + (element.checked ? 'on' : 'off') + '&');
                        data += encoder(name) + '=' + (element.checked ? 'on' : 'off') + '&';
                    } else {
                        //~ console.log('20111001',element,'data += ',encoder(name) + '=' + encoder(element.value) + '&');
                        data += encoder(name) + '=' + encoder(element.value) + '&';
                    }
                    hasSubmit = /submit/i.test(type);
                }
            }
        //~ } else {
            //~ console.log(name,type,element.readonly);
        }
    });
    return data.substr(0, data.length - 1);
};



/*
Set a long timeout of fifteen minutes. 
See /blog/2012/0307
*/
Ext.Ajax.timeout = 15 * 60 * 1000; 

/*
 * Thanks to 
 * `huuze <http://stackoverflow.com/users/10040/huuuze>`_ for the question
 * and to 
 * `chrisv <http://stackoverflow.com/users/683808/chrisv>`_
 * for the answer on
 * http://stackoverflow.com/questions/3764589/how-do-i-include-django-1-2s-csrf-token-in-a-javascript-generated-html-form/5485616#5485616
 * 
 * */
 
Ext.Ajax.on('beforerequest', function (conn, options) {
   if (!(/^http:.*/.test(options.url) || /^https:.*/.test(options.url))) {
     if (typeof(options.headers) == "undefined") {
       options.headers = {'X-CSRFToken': Ext.util.Cookies.get('csrftoken')};
     } else {
       options.headers.extend({'X-CSRFToken': Ext.util.Cookies.get('csrftoken')});
     }                        
   }
}, this);


/*
My fix for the "Cannot set QuickTips dismissDelay to 0" bug,
see http://www.sencha.com/forum/showthread.php?183515 
*/
Ext.override(Ext.QuickTip,{
  showAt : function(xy){
        var t = this.activeTarget;
        //~ console.log("20120224 QuickTip.showAt",this.title,this.dismissDelay,t.dismissDelay);
        if(t){
            if(!this.rendered){
                this.render(Ext.getBody());
                this.activeTarget = t;
            }
            if(t.width){
                this.setWidth(t.width);
                this.body.setWidth(this.adjustBodyWidth(t.width - this.getFrameWidth()));
                this.measureWidth = false;
            } else{
                this.measureWidth = true;
            }
            this.setTitle(t.title || '');
            this.body.update(t.text);
            this.autoHide = t.autoHide;
            // bugfix by Luc 20120226
            if (t.dismissDelay != undefined) this.dismissDelay = t.dismissDelay;
            //~ this.dismissDelay = t.dismissDelay || this.dismissDelay;
            if(this.lastCls){
                this.el.removeClass(this.lastCls);
                delete this.lastCls;
            }
            if(t.cls){
                this.el.addClass(t.cls);
                this.lastCls = t.cls;
            }
            if(this.anchor){
                this.constrainPosition = false;
            }else if(t.align){ 
                xy = this.el.getAlignToXY(t.el, t.align);
                this.constrainPosition = false;
            }else{
                this.constrainPosition = true;
            }
        }
        Ext.QuickTip.superclass.showAt.call(this, xy);
    }
});

/*
Another hack. See /docs/blog/2012/0228
*/
Ext.Element.addMethods(
    function() {
        var VISIBILITY      = "visibility",
            DISPLAY         = "display",
            HIDDEN          = "hidden",
            NONE            = "none",
            XMASKED         = "x-masked",
            XMASKEDRELATIVE = "x-masked-relative",
            data            = Ext.Element.data;

        return {
            
            mask : function(msg, msgCls) {
                var me  = this,
                    dom = me.dom,
                    dh  = Ext.DomHelper,
                    EXTELMASKMSG = "ext-el-mask-msg",
                    el,
                    mask;
                // removed the following lines. See /docs/blog/2012/0228
                //~ if (!(/^body/i.test(dom.tagName) && me.getStyle('position') == 'static')) {
                    //~ console.log(20120228,dom.tagName,me);
                    //~ me.addClass(XMASKEDRELATIVE); 
                //~ }
                if (el = data(dom, 'maskMsg')) {
                    el.remove();
                }
                if (el = data(dom, 'mask')) {
                    el.remove();
                }

                mask = dh.append(dom, {cls : "ext-el-mask"}, true);
                data(dom, 'mask', mask);

                me.addClass(XMASKED);
                mask.setDisplayed(true);
                
                if (typeof msg == 'string') {
                    var mm = dh.append(dom, {cls : EXTELMASKMSG, cn:{tag:'div'}}, true);
                    data(dom, 'maskMsg', mm);
                    mm.dom.className = msgCls ? EXTELMASKMSG + " " + msgCls : EXTELMASKMSG;
                    mm.dom.firstChild.innerHTML = msg;
                    mm.setDisplayed(true);
                    mm.center(me);
                }
                
                
                if (Ext.isIE && !(Ext.isIE7 && Ext.isStrict) && me.getStyle('height') == 'auto') {
                    mask.setSize(undefined, me.getHeight());
                }
                
                return mask;
            }

            
        };
    }()
);



Ext.namespace('Lino');
    
    

//~ Lino.subst_user_field = new Ext.form.ComboBox({});
//~ Lino.subst_user = null;
Lino.insert_subst_user = function(p){
    //~ console.log('20120714 insert_subst_user',Lino.subst_user,p);
    //~ if (Lino.subst_user_field.getValue()) {
    if (p.su) return;
    if (Lino.subst_user) {
        //~ p.su = Lino.subst_user_field.getValue();
        p.su = Lino.subst_user;
    //~ } else {
        //~ delete p.su;
    }
    //~ console.log('20120714 insert_subst_user -->',Lino.subst_user,p);
}

Lino.login_window = null;


Lino.show_login_window = function(on_login) {
  //~ console.log('20121103 show_login_window',arguments);
  //~ var current_window = Lino.current_window;
  if (Lino.login_window == null) {
    
      function do_login() { 
            Lino.viewport.loadMask.show()
            //~ Lino.body_loadMask.show()
            login_panel.getForm().submit({ 
                method:'POST', 
                waitTitle:'Connecting', 
                waitMsg:'Sending data...',
                success:function(){ 
                  //~ console.log('20121104 logged in',arguments);
                  Lino.login_window.hide();
                  Lino.close_all_windows();
                  Lino.viewport.loadMask.hide();
                  if (typeof on_login == 'string') {
                      //~ console.log("20130829 on_login",on_login);
                      //~ alert("20130829 on_login gonna load_url");
                      Lino.load_url(on_login);
                      //~ eval(on_login);
                  }
                  //~ Lino.body_loadMask.hide();
                },
                failure: function(form,action) { 
                  //~ this.loadMask.hide();
                  Lino.on_submit_failure(form,action);
                  Lino.viewport.loadMask.hide()
                  //~ Lino.body_loadMask.hide()
                  //~ if (Lino.current_window) Lino.current_window.main_item.loadMask.hide()
                }
                //~ failure:function(form, action){ 
                    //~ alert_msg
                    //~ if(action.failureType == 'server'){ 
                        //~ obj = Ext.util.JSON.decode(action.response.responseText); 
                        //~ Ext.Msg.alert('Login Failed!', obj.errors.reason); 
                    //~ }else{ 
                        //~ Ext.Msg.alert('Warning!', 'Authentication server is unreachable : ' + action.response.responseText); 
                    //~ } 
                    //~ Lino.login_panel.getForm().reset(); 
                //~ } 
            }); 
      };
    
      var login_button = new Ext.Button({ 
        text:"Anmelden",
        formBind: true,	 
        // Function that fires when user clicks the button 
        handler: do_login});
    
      var login_panel = new Ext.FormPanel({ 
        //~ inspired by http://www.sencha.com/learn/a-basic-login/
        autoHeight:true,
        labelWidth:90,
        url:'/auth', 
        frame:true, 
        defaultType:'textfield',
        monitorValid:true,
        items:[{ 
            fieldLabel:"Benutzername", 
            id: 'username',
            name:'username', 
            autoHeight:true,
            allowBlank:false 
        },{ 
            fieldLabel:"Passwort", 
            name:'password', 
            inputType:'password', 
            autoHeight:true,
            allowBlank:false 
        }],        
        buttons:[ login_button ]});
        
      Lino.login_window = new Ext.Window({
          layout:'fit',
          defaultButton: 'username',
          width:300,
          title:"Anmelden", 
          autoHeight:true,
          modal: true,
          closeAction: "hide",
          keys: {
            key: Ext.EventObject.ENTER,
            fn: function() { do_login()}
          },
          //~ defaultButton: login_button,
          //~ height:'auto',
          //~ closable: false,
          //~ resizable: false,
          //~ plain: true,
          //~ border: false,
          items: [login_panel] });
  };
  Lino.login_window.show();
};

Lino.logout = function(id,name) {
    //~ console.log('20121104 gonna log out',arguments);
    //~ Lino.do_action
    Lino.call_ajax_action(Lino.viewport,'GET','/auth',{},'logout',undefined,undefined,function(){
        //~ console.log('20121104 logged out',arguments);
        //~ Lino.login_window.hide();
        Lino.close_all_windows();
    })
}

Lino.set_subst_user = function(id,name) {
    //~ console.log(20130723,'Lino.set_subst_user',id,name,Lino.current_window,Lino.viewport);
    Lino.subst_user = id;
//~ 
    if (Lino.current_window) 
        Lino.current_window.main_item.set_base_param("su",id);
    if (Lino.viewport) 
        Lino.permalink_handler(Lino.current_window)();
}



//~ Lino.select_subst_user = function(cmp,rec,value){
    //~ Lino.subst_user=value;
    //~ console.log(20120713,rec);
//~ }
    
Lino.current_window = null;
Lino.window_history = Array();
    
Lino.chars2width = function(cols) {  return cols * 9; }
Lino.rows2height = function(cols) {  return cols * 20; }



Lino.MainPanel = {
  is_home_page : false,
  setting_param_values : false,
  config_containing_window : function(wincfg) { }
  ,init_containing_window : function(win) { }
  ,is_loading : function() { 
      if (!this.rendered) return true;
      //~ return (Ext.select('.x-loading-msg').elements.length > 0);
      return true; 
    } 
  ,do_when_clean : function(auto_save,todo) { todo() }
  ,get_master_params : function() {
    var p = {}
    p['mt'] = this.content_type; 
    rec = this.get_current_record()
    if (rec) {
      if (rec.phantom) {
          p['mk'] = undefined; 
      }else{
          p['mk'] = rec.id; 
      }
    } else {
      p['mk'] = undefined;
    }
    //~ console.log('get_master_params returns',p,'using record',rec);
    return p;
  }
  ,get_permalink : function() {
    //~ var p = this.main_item.get_base_params() || {};
    var p = Ext.apply({},this.get_base_params());
    delete p.fmt;
    //~ if (p.fmt) delete p.fmt;
    Ext.apply(p,this.get_permalink_params());
    
    if (this.toggle_params_panel_btn) {
        p.sp = this.toggle_params_panel_btn.pressed;
        //~ if (this.toggle_params_panel_btn.pressed == this.params_panel_hidden) {
          //~ p.sp = true;
        //~ }
    }
    
    //~ Lino.insert_subst_user(p);
     //~ p.fmt = 'html';
    //~ console.log('get_permalink',p,this.get_permalink_params());
    if (this.is_home_page)
        //~ var url = '';
        var url = '/';
    else 
        var url = this.get_permalink_url();
    if (p.su == null) 
        delete p.su;
    if (Ext.urlEncode(p)) url = url + "?" + Ext.urlEncode(p);
    return url;
  }
  ,get_record_url : function(record_id) {
      var url = '/api' + this.ls_url
      //~ var url = this.containing_window.config.url_data; // ls_url;
      url += '/' + (record_id === undefined ? '-99999' : String(record_id));
      //~ if (record_id !== undefined) url += '/' + String(record_id);
      //~ url += '/' + String(record_id);
      return url;
  }
  ,get_permalink_url : function() {
      return '/api' + this.ls_url;
  }
  ,get_permalink_params : function() {
      //~ return {an:'grid'};
      var p = {};
      if (this.action_name)
          p.an = this.action_name;
      this.add_param_values(p,false)
      return p;
  }
  ,set_status : function(status) {}
  ,get_status : function() { return {}}
  ,refresh : function() {}
  ,get_base_params : function() { 
    var p = {};
    Lino.insert_subst_user(p);
    return p;
  }
  ,add_params_panel : function (tbar) {
      if (this.params_panel) {
        this.toggle_params_panel_btn = new Ext.Button({ scope:this, 
          //~ text: "$_("[parameters]")", // gear
          iconCls: 'x-tbar-parameters',
          tooltip:"Parameter-Panel ein- bzw. ausblenden",
          enableToggle: true,
          //~ pressed: ! this.params_panel.hidden,
          pressed: ! this.params_panel_hidden,
          toggleHandler: function(btn,state) { 
            //~ if (this.params_panel.isVisible()) 
                //~ this.params_panel.hide();
            //~ else
                //~ this.params_panel.show();
            //~ console.log("20120210 add_params_panel",state,this.params_panel);
            if (state) {
              this.params_panel.show();
              this.params_panel.doLayout();
            } else this.params_panel.hide();
            this.get_containing_window().doLayout();
          }
        });
        tbar = tbar.concat([this.toggle_params_panel_btn]);
        var t = this;
        var refresh = function() {if (!t.setting_param_values) {t._force_dirty = true; t.refresh();}}
        Ext.each(this.params_panel.fields,function(f) {
          //~ f.on('valid',function() {t.refresh()});
          if (f instanceof Ext.form.Checkbox) {
              f.on('check',refresh);
          } else if (f instanceof Ext.DatePicker) {
              f.on('select',refresh);
          } else if (f instanceof Ext.form.TriggerField) {
              f.on('select',refresh);
              //~ f.on('change',refresh);
              //~ f.on('valid',refresh);
          } else {
              if (! f.on) 
                  console.log("20121010 no method 'on'",f);
              else
                  f.on('change',refresh);
            }
          });
      }
      return tbar;
  }
  ,add_param_values : function (p,unused_force_dirty) {
    if (this.params_panel) {
      /* 
      * 20120918 add param_values to the request string 
      * *only if the params_form is dirty*.
      * Otherwise Actor.default_params() would never be used.
      *
      * 20121023 But IntegClients.params_default has non-empty default values. 
      * Users must have the possibility to make them empty.
      * 
      * 20130605 : added `force_dirty` parameter because Checkbox fields don't 
      * mark their form as dirty when check is fired.
      * 
      * 20130721 : `force_dirty` not as a parameter but as 
      * `this._force_dirty` because
      * 
      */
      if (this._force_dirty || this.params_panel.form.isDirty()) {
        p.pv = this.get_param_values();
        //~ console.log("20130605 form.isDirty",p);
      }else{
        //~ console.log("20130605 form not dirty:",this.params_panel.form);
        if (this.status_param_values) 
          p.pv = Lino.fields2array(
            this.params_panel.fields,this.status_param_values);
      }
      //~ if (!this.params_panel.form.isDirty()) return;
      //~ p.pv = this.get_param_values();
      //~ console.log("20120203 add_param_values added pv",pv,"to",p);
    }
  },
  get_param_values : function() { // similar to get_field_values()
      return Lino.fields2array(this.params_panel.fields);
  },
  set_param_values : function(pv) {
    if (this.params_panel) {
      //~ console.log('20120203 MainPanel.set_param_values', pv);
      this.status_param_values = pv;
      //~ this.params_panel.form.suspendEvents(false);
      this.setting_param_values = true;
      if (pv) { 
          this.params_panel.form.my_loadRecord(pv);
      } else { 
        this.params_panel.form.reset(); 
      }
      this.setting_param_values = false;
      //~ this.params_panel.form.resumeEvents();
    }
  }
};




Lino.Viewport = Ext.extend(Ext.Viewport,Lino.MainPanel);
Lino.Viewport = Ext.extend(Lino.Viewport,{
  layout : "fit"
  ,is_home_page : true
  ,initComponent : function(){
    Lino.Viewport.superclass.initComponent.call(this);
    this.on('render',function(){
      this.loadMask = new Ext.LoadMask(this.el,{msg:"Bitte warten..."});
      //~ console.log("20121118 Lino.viewport.loadMask",this.loadMask);
    },this);
  }
  ,get_base_params : function() { 
    var p = {};
    Lino.insert_subst_user(p);
    return p;
  }
  ,refresh : function() {
      var caller = this;
      //~ console.log("20121120 Lino.Viewport.refresh()");
      if (caller.loadMask) caller.loadMask.show();
      var success = function(response) {
        if (caller.loadMask) caller.loadMask.hide();
        if (response.responseText) {
          var result = Ext.decode(response.responseText);
          //~ console.log('Lino.do_action()',action.name,'result is',result);
          if (result.html) {
              Ext.getCmp('main_area').update(result.html);
          }
          if (result.message) {
              if (result.alert) {
                  //~ Ext.MessageBox.alert('Alert',result.alert_msg);
                  Ext.MessageBox.alert('Alert',result.message);
              } else {
                  Lino.notify(result.message);
              }
          }
          
          if (result.notify_msg) Lino.notify(result.notify_msg);
          if (result.js_code) { 
            var jsr = result.js_code(caller);
            //~ console.log('Lino.do_action()',action,'returned from js_code in',result);
          };
        }
      };
      var action = {
        url : '/api/main_html',
        waitMsg: "Bitte warten...",
        failure: Lino.ajax_error_handler(caller),
        success: success,
        method: 'GET',
        params: {}
      };
      Lino.insert_subst_user(action.params);
      Ext.Ajax.request(action);
    
  }
});




Lino.open_window = function(win,st,requesting_panel) {
  //~ console.log("20120918 Lino.open_window()",win,st);
  var cw = Lino.current_window;
  if (cw) {
    //~ console.log("20120918 Lino.open_window() save current status",cw.main_item.get_status());
    Lino.window_history.push({
      window:cw,
      status:cw.main_item.get_status()
    });
  }
  Lino.current_window = win;
  //~ if (st.su) 
      //~ Lino.subst_user_field.setValue(st.su);
  win.main_item.set_status(st,requesting_panel);
  win.show();
};

Lino.load_url = function(url) {
    //~ foo.bar.baz = 2; 
    //~ console.log("20121120 Lino.load_url()");
    //~ Lino.body_loadMask.show();
    Lino.viewport.loadMask.show();
    //~ location.replace(url);
    document.location = url;
}

Lino.close_window = function(status_update) {
  var cw = Lino.current_window;
  var ww = Lino.window_history.pop();
  if (ww) {
    //~ if (status_update) Ext.apply(ww.status,status_update);
    if (status_update) status_update(ww);
    ww.window.main_item.set_status(ww.status);
    Lino.current_window = ww.window;
  } else {
    Lino.current_window = null;
  }
  if (cw) cw.hide_really();
};

Lino.close_all_windows = function() {
  if (Lino.window_history.length == 0) {
      //~ Lino.viewport.refresh();
      var url =  "/"
      //~ console.log("20121120 Lino.close_all_windows() : no window_history");
      //~ if (ADMIN_URL) 
      var p = {};
      Lino.insert_subst_user(p)
      if (Ext.urlEncode(p)) url = url + "?" + Ext.urlEncode(p);
      Lino.load_url(url);
  } else {
    //~ console.log("20121120 Lino.close_all_windows() with window_history");
    while (Lino.window_history.length > 0) {
      Lino.close_window();
      //~ Lino.window_history.pop().hide_really();
    }
  }
  //~ Lino.current_window = null;
  //~ Lino.close_window();
  //~ var ww = 
}

Lino.kill_current_window = function() {
  var cw = Lino.current_window;
  Lino.current_window = null;
  if (cw) cw.hide_really();
};

Lino.calling_window = function() {
    if (Lino.window_history.length) return Lino.window_history[Lino.window_history.length-1];
}

//~ Lino.WindowAction = function(mainItemClass,windowConfig,mainConfig,ppf) {
Lino.WindowAction = function(windowConfig,main_item_fn) {
    //~ if(!mainConfig) mainConfig = {};
    //~ mainConfig.is_main_window = true;
    this.windowConfig = windowConfig;
    this.main_item_fn = main_item_fn;
    //~ if (ppf) mainConfig.params_panel.fields = ppf;
    //~ this.mainConfig = mainConfig;
    //~ this.mainItemClass = mainItemClass;
};

Lino.WindowAction = Ext.extend(Lino.WindowAction,{
    window : null,
    //~ mainItemClass: null,
    get_window : function() {
      //~ if(mainConfig) Ext.apply(this.mainConfig,mainConfig);
      if (this.window == null)  {
          //~ this.windowConfig.main_item = new this.mainItemClass(this.mainConfig);
          this.windowConfig.main_item = this.main_item_fn();
          this.window = new Lino.Window(this.windowConfig);
      }
      return this.window;
    },
    run : function(requesting_panel,status) {
      //~ console.log('20120625 window_action.run()',this)
      Lino.open_window(this.get_window(),status,requesting_panel);
    }
  
});


Lino.PanelMixin = {
  get_containing_window : function (){
      if (this.containing_window) return this.containing_window;
      return this.containing_panel.get_containing_window();
  }
  ,set_window_title : function(title) {
    //~ this.setTitle(title);
    var cw = this.get_containing_window();

    //~ if (cw) {
    //~ if (cw && cw.closable) {
    if (cw && !cw.main_item.hide_window_title) {
      //~ console.log('20111202 set_window_title(',title,') for',this.containing_window);
      //~ if (! this.containing_window.rendered) console.log("WARNING: not rendered!");
      cw.setTitle(title);
    //~ } else {
      //~ document.title = title;
    }
    //~ else console.log('20111202 not set_window_title(',title,') for',this);
  }
  
};


// Lino.status_bar = new Ext.ux.StatusBar({defaultText:'Lino version 1.6.11.'});
Lino.status_bar = new Ext.ux.StatusBar({
    autoClear: 10000, // 10 seconds
    defaultText:'Lino Welfare 1.1.9.'
    });



Lino.edit_tinymce_text = function(panel,options) {
  // `panel` is the RichTextPanel
  //~ console.log(20111220,panel);
  //~ var rec = panel.get_current_record();
  var rec = panel.containing_panel.get_current_record();
  var value = rec ? rec.data[panel.editor.name] : '';
  var saving = false;
  var todo_after_save = false;
  var discard_changes = false;
  
  
  function save() {
    //~ if (todo_after_save) {alert('tried to save again'); return; }
    if (saving) {alert('tried to save again'); return; }
    //~ var url = panel.containing_window.main_item.get_record_url(rec.id);
    var url = panel.containing_panel.get_record_url(rec.id);
    var params = Ext.apply({},panel.containing_panel.get_base_params());
    params[panel.editor.name] = editor.getValue();
    //~ params.su = Lino.subst_user;
    //~ Lino.insert_subst_user(params);
    var a = { 
      params: params, 
      method: 'PUT',
      url: url,
      failure: function() {
          //~ if (editor.ed.getContainer()) 
          editor.ed.setProgressState(0);
          todo_after_save = false;
          saving = false;
          console.log('tinymce.save() failed. sorry.',arguments);
        },
      success: function() {
        saving = false;
        //~ if (editor.ed.getContainer()) 
        editor.ed.setProgressState(0);
        rec.data[panel.editor.name] = editor.getValue();
        if(todo_after_save) {
            var fn = todo_after_save;
            todo_after_save = false;
            fn();
        }
        //~ panel.containing_window.set_current_record(rec);
        panel.refresh();
      }
    };
    //~ if (editor.ed.getContainer()) 
    editor.ed.setProgressState(1); // Show progress
    saving = true;
    //~ console.log(a);
    Ext.Ajax.request(a);
  };
  function save_callback() {
      save();
      //~ save(function(){editor.ed.setDirty(false);})
      /* return true have the save button disabled.  
      That's not perfect because the PUT is asynchronous 
      and the response is not yet known.
      */
      return true;
  }
  //~ var actions = [
    //~ {text:"Save",handler:save}
  //~ ]; 
  //~ console.log(20110610,panel.editor.disabled);
  var settings = {};
  Ext.apply(settings,{
        readonly: panel.editor.disabled,
        //~ language: "de",
        plugins : "save,emotions,spellchecker,advhr,insertdatetime,preview,table,searchreplace,template", 
        // Theme options - button# indicated the row# only
        theme_advanced_buttons1 : "save,cancel,|,bold,italic,underline,|,justifyleft,justifycenter,justifyright,fontselect,fontsizeselect,formatselect,|,search,replace",
        theme_advanced_buttons2 : "cut,copy,paste,template,|,bullist,numlist,|,outdent,indent,|,undo,redo,|,link,unlink,anchor,image,|,code,preview,|,forecolor,backcolor",
        theme_advanced_buttons3 : "insertdate,inserttime,|,spellchecker,advhr,,removeformat,|,sub,sup,|,charmap,emotions,|,tablecontrols",      
        theme_advanced_resizing : false,
        convert_urls : false,
        save_onsavecallback : save_callback,
        save_enablewhendirty : true
        //~ save_oncancelcallback: on_cancel
  });
  Ext.apply(settings,options);
  var editor = new Ext.ux.TinyMCE({
      value : value,
      tinymceSettings: settings
    });
  var win = new Ext.Window({
    title: rec.title, 
    //~ bbar: actions,
    layout: 'fit',
    items: editor,
    width: 600, 
    height:500,
    minWidth: 100,
		minHeight: 100,
    modal: true,
    resizable: true,
    maximizable: true,
    //~ maximized: true,
    //~ closeAction: "close"
    closeAction: "hide"
    //~ hideMode: "offsets",
    //~ constrainHeader: true,
    //~ bodyStyle: 'padding: 10px'
  });

  //~ win.on('beforeclose',function() {
  win.on('beforehide',function() {
    if (todo_after_save) return false;
    if (discard_changes) return true;
    if (editor.isDirty()) {
        //~ var ok = false;
        //~ var allowClose = true;
        var config = {title:"Bestätigung"};
        config.buttons = Ext.MessageBox.YESNOCANCEL;
        config.msg = "Änderungen im Text speichern?";
        config.modal = true;
        config.fn = function(buttonId,text,opt) {
          //~ console.log('do_when_clean',buttonId)
          if (buttonId == "yes") {
              /* we cancel this close, but save()'s onSuccess will call again.*/
              //~ allowClose = false;
              todo_after_save = function(){win.hide();}
              editor.ed.execCommand('mceSave');
              //~ editor.ed.save(function(){win.close();});
          } else if (buttonId == "no") { 
              discard_changes = true;
              win.hide()
          //~ } else if (buttonId == "cancel") { 
            //~ ok = true;
              //~ allowClose = false;
          //~ } else { 
            //~ console.log('unknwon buttonId:',buttonId);
          }
        }
        Ext.MessageBox.show(config);
        return false;
        //~ return allowClose;
    }
  });
  win.show();
}







/* 
  Originally copied from Ext JS Library 3.3.1
  Modifications by Luc Saffre : 
  - rendering of phantom records
  - fire afteredit event
  - react on dblclcik, not on single click

 */
Lino.CheckColumn = Ext.extend(Ext.grid.Column, {

    processEvent : function(name, e, grid, rowIndex, colIndex){
        //~ console.log('20110713 Lino.CheckColumn.processEvent',name)
        if (name == 'click') {
        //~ if (name == 'mousedown') {
        //~ if (name == 'dblclick') {
            return this.toggleValue(grid, rowIndex, colIndex);
        } else {
            return Ext.grid.ActionColumn.superclass.processEvent.apply(this, arguments);
        }
    },
    
    toggleValue : function (grid,rowIndex,colIndex) {
        var record = grid.store.getAt(rowIndex);
        var dataIndex = grid.colModel.getDataIndex(colIndex);
        // 20120514
        //~ if(record.data.disabled_fields && record.data.disabled_fields[dataIndex]) {
          //~ Lino.notify("Dieses Feld ist deaktiviert");
          //~ return false;
        //~ }
      
        //~ if (dataIndex in record.data['disabled_fields']) {
            //~ Lino.notify("This field is disabled.");
            //~ return false;
        //~ }
        var startValue = record.data[dataIndex];
        var value = !startValue;
        //~ record.set(this.dataIndex, value);
        var e = {
            grid: grid,
            record: record,
            field: dataIndex,
            originalValue: startValue,
            value: value,
            row: rowIndex,
            column: colIndex,
            cancel: false
        };
        if(grid.fireEvent("beforeedit", e) !== false && !e.cancel){
        //~ if(grid.fireEvent("validateedit", e) !== false && !e.cancel){
            record.set(dataIndex, value);
            delete e.cancel;
            grid.fireEvent("afteredit", e);
        }
        return false; // Cancel event propagation
    },

    renderer : function(v, p, record){
        if (record.phantom) return '';
        p.css += ' x-grid3-check-col-td'; 
        return String.format('<div class="x-grid3-check-col{0}">&#160;</div>', v ? '-on' : '');
    }

    // Deprecate use as a plugin. Remove in 4.0
    // init: Ext.emptyFn
});

// register ptype. Deprecate. Remove in 4.0
// Ext.preg('checkcolumn', Lino.CheckColumn);

// backwards compat. Remove in 4.0
// Ext.grid.CheckColumn = Lino.CheckColumn;

// register Column xtype
Ext.grid.Column.types.checkcolumn = Lino.CheckColumn;


/* 20110725 : 
Lino.on_tab_activate is necessary 
in contacts.Person.2.dtl 
(but don't ask me why...)
*/
Lino.on_tab_activate = function(item) {
  //~ console.log('activate',item); 
  if (item.rendered && item.doLayout) item.doLayout();
  //~ if (item.rendered) item.doLayout();
}

Lino.TimeField = Ext.extend(Ext.form.TimeField,{
  format: 'H:i',
  increment: 15
  });
Lino.DateField = Ext.extend(Ext.form.DateField,{
  boxMinWidth: Lino.chars2width(11),
  format: 'd.m.Y',
  altFormats: 'd/m/Y|Y-m-d'
  });
Lino.DatePickerField = Ext.extend(Ext.DatePicker,{
  //~ boxMinWidth: Lino.chars2width(11),
  format: 'd.m.Y',
  //~ altFormats: 'd/m/Y|Y-m-d'
  formatDate : function(date){
      //~ console.log("20121203 formatDate",this.name,date);
      return Ext.isDate(date) ? date.dateFormat(this.format) : date;
  }
  });
Lino.DateTimeField = Ext.extend(Ext.ux.form.DateTime,{
  dateFormat: 'd.m.Y',
  timeFormat: 'H:i'
  //~ ,hiddenFormat: 'd.m.Y H:i'
  });
Lino.URLField = Ext.extend(Ext.form.TriggerField,{
  triggerClass : 'x-form-search-trigger',
  //~ triggerClass : 'x-form-world-trigger',
  vtype: 'url',
  onTriggerClick : function() {
    //~ console.log('Lino.URLField.onTriggerClick',this.value)
    //~ document.location = this.value;
    window.open(this.getValue(),'_blank');
  }
});
Lino.IncompleteDateField = Ext.extend(Ext.form.TextField,{
  //~ regex: /^-?\d+-[01]\d-[0123]\d$/,
  //~ regex: /^[0123]\d\.[01]\d\.-?\d+$/,
  maxLength: 10,
  boxMinWidth: Lino.chars2width(10),
  regex: /^[0123]?\d\.[01]?\d\.-?\d+$/,
  regexText: 'Datum im Format JJJJ-MM-TT eingeben (Nullen für unbekannte Teile)'
  });


//~ Lino.make_dropzone = function(cmp) {
    //~ cmp.on('render', function(ct, position){
      //~ ct.el.on({
        //~ dragenter:function(event){
          //~ event.browserEvent.dataTransfer.dropEffect = 'move';
          //~ return true;
        //~ }
        //~ ,dragover:function(event){
          //~ event.browserEvent.dataTransfer.dropEffect = 'move';
          //~ event.stopEvent();
          //~ return true;
        //~ }
        //~ ,drop:{
          //~ scope:this
          //~ ,fn:function(event){
            //~ event.stopEvent();
            //~ console.log(20110516);
            //~ var files = event.browserEvent.dataTransfer.files;
            //~ if(files === undefined){
              //~ return true;
            //~ }
            //~ var len = files.length;
            //~ while(--len >= 0){
              //~ console.log(files[len]);
              //~ // this.processDragAndDropFileUpload(files[len]);
            //~ }
          //~ }
        //~ }
      //~ });
    //~ });
//~ };

//~ Lino.FileUploadField = Ext.ux.form.FileUploadField;

Lino.FileUploadField = Ext.extend(Ext.ux.form.FileUploadField,{
    onRender : function(ct, position){
      Lino.FileUploadField.superclass.onRender.call(this, ct, position);
      this.el.on({
        dragenter:function(event){
          event.browserEvent.dataTransfer.dropEffect = 'move';
          return true;
        }
        ,dragover:function(event){
          event.browserEvent.dataTransfer.dropEffect = 'move';
          event.stopEvent();
          return true;
        }
        ,drop:{
          scope:this
          ,fn:function(event){
            event.stopEvent();
            //~ console.log(20110516);
            var files = event.browserEvent.dataTransfer.files;
            if(files === undefined){
              return true;
            }
            var len = files.length;
            while(--len >= 0){
              console.log(files[len]);
              //~ this.processDragAndDropFileUpload(files[len]);
            }
          }
        }
      });
    }
});

Lino.FileField = Ext.extend(Ext.form.TriggerField,{
  triggerClass : 'x-form-search-trigger',
  editable: false,
  onTriggerClick : function() {
    //~ console.log('Lino.URLField.onTriggerClick',this.value)
    //~ document.location = this.value;
    if (this.getValue()) window.open(MEDIA_URL + '/'+this.getValue(),'_blank');
  }
});

Lino.file_field_handler = function(panel,config) {
  //~ if (instanceof Lino.DetailWrapper) {
  if (panel.action_name == 'insert') {
  //~ if (panel.get_current_record().phantom) {
      panel.has_file_upload = true;

      var f = new Lino.FileUploadField(config);
      //~ Lino.make_dropzone(f);
      return f;
      //~ return new Ext.ux.form.FileUploadField(config);
      //~ return new Lino.FileField(config);
      
  } else {
      //~ return new Lino.URLField(config);
      return new Lino.FileField(config);
  }
}

Lino.VBorderPanel = Ext.extend(Ext.Panel,{
    constructor : function(config) {
      config.layout = 'border';
      delete config.layoutConfig;
      Lino.VBorderPanel.superclass.constructor.call(this,config);
      for(var i=0; i < this.items.length;i++) {
        var item = this.items.get(i);
        if (this.isVertical(item) && item.collapsible) {
          item.on('collapse',this.onBodyResize,this);
          item.on('expand',this.onBodyResize,this);
        }
      }
    },
    isVertical : function(item) {
       return (item.region == 'north' || item.region == 'south' || item.region == 'center');
    },
    onBodyResize: function(w, h){
        //~ console.log('VBorderPanel.onBodyResize',this.title)
      if (this.isVisible()) { // to avoid "Uncaught TypeError: Cannot call method 'getHeight' of undefined."
        var sumflex = 0;
        var availableHeight = this.getInnerHeight();
        var me = this;
        this.items.each(function(item){
          if (me.isVertical(item)) {
              if (item.collapsed || item.flex == 0 || item.flex === undefined) {
                  if (item.rendered) availableHeight -= item.getHeight();
              } else {
                  sumflex += item.flex;
              }
          } 
          
        });
        //~ for(var i=0; i < this.items.length;i++) {
          //~ var item = this.items.get(i);
          //~ // if (this.isVertical(item) && item.getResizeEl()) {
          //~ if (this.isVertical(item)) {
              //~ if (item.collapsed || item.flex == 0 || item.flex === undefined) {
                  //~ // item.syncSize()
                  //~ // item.doLayout()
                  //~ // if (item.region == "north") console.log('region north',item.getHeight(),item.id, item);
                  //~ // if (item.getHeight() == 0) console.log(20100921,'both flex and getHeight() are 0!');
                  //~ availableHeight -= item.getHeight();
              //~ } else {
                  //~ sumflex += item.flex;
                  //~ // console.log(item.flex);
              //~ }
          //~ } 
          //~ // else console.log('non-vertical item in VBoderPanel:',item)
        //~ }
        var hunit = availableHeight / sumflex;
        //~ console.log('sumflex=',sumflex,'hunit=',hunit, 'availableHeight=',availableHeight);
        for(var i=0; i < this.items.length;i++) {
          var item = this.items.get(i);
          if (this.isVertical(item)) {
              if (item.flex != 0 && ! item.collapsed) {
                  item.setHeight(hunit * item.flex);
                  //~ console.log(item.region,' : height set to',item.getHeight());
              }
          }
          //~ else console.log('non-vertical item in VBoderPanel:',item)
        }
      }
      Lino.VBorderPanel.superclass.onBodyResize.call(this, w, h);
    }
});


/*
  modifications to the standard behaviour of a CellSelectionModel:
  
*/
Ext.override(Ext.grid.CellSelectionModel, {
//~ var dummy = {

    handleKeyDown : function(e){
        /* removed because F2 wouldn't pass
        if(!e.isNavKeyPress()){
            return;
        }
        */
        //~ console.log('handleKeyDown',e)
        var k = e.getKey(),
            g = this.grid,
            s = this.selection,
            sm = this,
            walk = function(row, col, step){
                return g.walkCells(
                    row,
                    col,
                    step,
                    g.isEditor && g.editing ? sm.acceptsNav : sm.isSelectable, 
                    sm
                );
            },
            cell, newCell, r, c, ae;

        switch(k){
            case e.ESC:
            case e.PAGE_UP:
            case e.PAGE_DOWN:
                break;
            default:
                // e.stopEvent(); // removed because Browser keys like Alt-Home, Ctrl-R wouldn't work
                break;
        }

        if(!s){
            cell = walk(0, 0, 1); 
            if(cell){
                this.select(cell[0], cell[1]);
            }
            return;
        }

        cell = s.cell;  
        r = cell[0];    
        c = cell[1];    
        
        switch(k){
            case e.TAB:
                if(e.shiftKey){
                    newCell = walk(r, c - 1, -1);
                }else{
                    newCell = walk(r, c + 1, 1);
                }
                break;
            case e.HOME:
                if (! (g.isEditor && g.editing)) {
                  if (!e.hasModifier()){
                      newCell = [r, 0];
                      //~ console.log('home',newCell);
                      break;
                  }else if(e.ctrlKey){
                      var t = g.getTopToolbar();
                      var activePage = Math.ceil((t.cursor + t.pageSize) / t.pageSize);
                      if (activePage > 1) {
                          e.stopEvent();
                          t.moveFirst();
                          return;
                      }
                      newCell = [0, c];
                      break;
                  }
                }
            case e.END:
                if (! (g.isEditor && g.editing)) {
                  c = g.colModel.getColumnCount()-1;
                  if (!e.hasModifier()) {
                      newCell = [r, c];
                      //~ console.log('end',newCell);
                      break;
                  }else if(e.ctrlKey){
                      var t = g.getTopToolbar();
                      var d = t.getPageData();
                      if (d.activePage < d.pages) {
                          e.stopEvent();
                          var self = this;
                          t.on('change',function(tb,pageData) {
                              var r = g.store.getCount()-2;
                              self.select(r, c);
                              //~ console.log('change',r,c);
                          },this,{single:true});
                          t.moveLast();
                          return;
                      } else {
                          newCell = [g.store.getCount()-1, c];
                          //~ console.log('ctrl-end',newCell);
                          break;
                      }
                  }
                }
            case e.DOWN:
                newCell = walk(r + 1, c, 1);
                break;
            case e.UP:
                newCell = walk(r - 1, c, -1);
                break;
            case e.RIGHT:
                newCell = walk(r, c + 1, 1);
                break;
            case e.LEFT:
                newCell = walk(r, c - 1, -1);
                break;
            case e.F2:
                if (!e.hasModifier()) {
                    if (g.isEditor && !g.editing) {
                        g.startEditing(r, c);
                        e.stopEvent();
                        return;
                    }
                    break;
                }
            case e.INSERT:
                if (!e.hasModifier()) {
                    if (g.ls_insert_handler && !g.editing) {
                        e.stopEvent();
                        Lino.show_insert(g);
                        return;
                    }
                    break;
                }
            case e.DELETE:
                if (!e.hasModifier()) {
                    if (!g.editing) {
                        e.stopEvent();
                        Lino.delete_selected(g);
                        return;
                    }
                    break;
                }
            case e.ENTER:
                e.stopEvent();
                g.onCellDblClick(r,c);
                break;
                
        }
        

        if(newCell){
          e.stopEvent();
          r = newCell[0];
          c = newCell[1];
          this.select(r, c); 
          if(g.isEditor && g.editing){ 
            ae = g.activeEditor;
            if(ae && ae.field.triggerBlur){
                ae.field.triggerBlur();
            }
            g.startEditing(r, c);
          }
        //~ } else if (g.isEditor && !g.editing && e.charCode) {
        //~ // } else if (!e.isSpecialKey() && g.isEditor && !g.editing) {
            //~ g.set_start_value(String.fromCharCode(e.charCode));
            //~ // g.set_start_value(String.fromCharCode(k));
            //~ // g.set_start_value(e.charCode);
            //~ g.startEditing(r, c);
            //~ // e.stopEvent();
            //~ return;
        // } else {
          // console.log('20120513',e,g);
        }
        
    }


//~ };
});

 

function PseudoConsole() {
    this.log = function() {};
};
if (typeof(console) == 'undefined') console = new PseudoConsole();

Lino.notify = function(msg) {
  if (msg == undefined) msg = ''; else console.log(msg);
  //~ Ext.getCmp('konsole').update(msg);
  Lino.status_bar.setStatus({
    text: msg,
    iconCls: 'ok-icon',
    clear: true // auto-clear after a set interval
  });
  //~ Ext.getCmp('konsole').setTitle(msg.replace(/\n/g,'<br/>'));
  //~ Ext.getCmp('konsole').update(msg.replace(/\n/g,'<br/>'));
};
Lino.alert = function(msg) {
  //~ if (msg == undefined) msg = ''; else console.log(msg);
  Ext.MessageBox.alert('Notify',msg);
};


//~ Lino.show_about = function() {
  //~ new Ext.Window({
    //~ width: 400, height: 400,
    //~ title: "About",
    //~ html: '<a href="http://www.extjs.com" target="_blank">ExtJS</a> version ' + Ext.version
  //~ }).show();
//~ };

function obj2str(o) {
  if (typeof o != 'object') return String(o);
  var s = '';
  for (var p in o) {
    s += p + ': ' + obj2str(o[p]) + '\n';
  }
  return s;
}

Lino.on_store_exception = function (store,type,action,options,response,arg) {
  //~ throw response;
  console.log("on_store_exception: store=",store,
    "type=",type,
    "action=",action,
    "options=",options,
    "response=",response,
    "arg=",arg);
  if (arg) { console.log(arg.stack)};
};

//~ Lino.on_submit_success = function(form, action) {
   //~ Lino.notify(action.result.message);
   //~ this.close();
//~ };

Lino.on_submit_failure = function(form, action) {
    //~ Lino.notify();
  // action may be undefined
    switch (action.failureType) {
        case Ext.form.Action.CLIENT_INVALID:
            Ext.Msg.alert('Client-side failure', 'Form fields may not be submitted with invalid values');
            break;
        case Ext.form.Action.CONNECT_FAILURE:
            Ext.Msg.alert('Connection failure', 'Ajax communication failed');
            break;
        case Ext.form.Action.SERVER_INVALID:
            Ext.Msg.alert('Server-side failure', action.result.message);
   }
};



/*
Lino.save_wc_handler = function(ww) {
  return function(event,toolEl,panel,tc) {
    var pos = panel.getPosition();
    var size = panel.getSize();
    wc = ww.get_window_config();
    Ext.applyIf(wc,{ 
      x:pos[0],y:pos[1],height:size.height,width:size.width,
      maximized:panel.maximized});
    Lino.do_action(ww,{url:'/window_configs/'+ww.config.permalink_name,params:wc,method:'POST'});
  }
};

*/

Lino.show_in_own_window_button = function(handler) {
  return {
    qtip: "Dieses Panel in eigenem Fenster öffnen", 
    id: "up",
    handler: function(event,toolEl,panel, tc) {
      //~ console.log('20111206 report_window_button',panel,handler);
      handler.run(null,{base_params:panel.containing_panel.get_master_params()});
    }
  }
}




Lino.delete_selected = function(panel) {
  //~ console.log("Lino.delete_selected",panel);
  var recs1 = panel.get_selected();
  var recs = [];
  for ( var i=0; i < recs1.length; i++ ) { if (! recs1[i].phantom) recs.push(recs1[i]); }
  if (recs.length == 0) {
    Lino.notify("Please select at least one record.");
    return;
  };
  if (recs.length == 1) {
      if (recs[0].disable_delete) {
        Lino.alert(recs[0].disable_delete);
        return;
      }
  };
  //~ console.log(recs);
  Ext.MessageBox.show({
    title: "Bestätigung",
    msg: String.format("Es werden {0} Datensätze gelöscht. Sind Sie sicher?",String(recs.length)),
    //~ msg: "Delete " + String(recs.length) + " rows. Are you sure?",
    //~ buttons: Ext.MessageBox.YESNOCANCEL,
    buttons: Ext.MessageBox.YESNO,
    fn: function(btn) {
      if (btn == 'yes') {
        for ( var i=0; i < recs.length; i++ ) {
          Lino.do_action(panel,{
              method:'DELETE',
              url:  '/api' + panel.ls_url + '/' + recs[i].id,
              after_success: panel.after_delete.createDelegate(panel)
          })
        }
        //~ caller.after_delete();
      }
      else Lino.notify("Dann eben nicht.");
    }
  });
};

Lino.action_handler = function (panel,on_success,on_confirm) {
  return function (response) {
    //~ console.log(20120608,panel);
    if (panel instanceof Lino.GridPanel) {
        //~ gridmode = false;
        gridmode = true;
        //~ console.log('20120608 yes');
    } else {
        gridmode = false;
        //~ console.log('20120608 no');
    }
    if (panel.loadMask) panel.loadMask.hide(); // 20120211
    if (!response.responseText) return ;
    var result = Ext.decode(response.responseText);
    //~ console.log('Lino.action_handler()','result is',result,'on_confirm is',on_confirm);
    
    if (result.eval_js) {
        //~ console.log(20120618,result.eval_js);
        eval(result.eval_js);
    }
    
    //~ if (result.goto_record) {
        //~ var js = "Lino." + result.goto_record[0] + '.detail.run';
        //~ var h = eval(js);
        //~ h(panel,{record_id:result.goto_record[1]});
    //~ }
    
    if (result.xcallback) {
        //~ var config = {title:"Bestätigung"};
        var config = {title:result.xcallback.title};
        //~ config.buttons = Ext.MessageBox.YESNOCANCEL;
        //~ config.buttons = Ext.MessageBox.YESNO;
        config.buttons = result.xcallback.buttons;
        config.msg = result.message;
        config.fn = function(buttonId,text,opt) {
          panel.loadMask.show(); 
          //~ Lino.insert_subst_user(p);
          Ext.Ajax.request({
            method: 'GET',
            url: '/callbacks/'+result.xcallback.id + '/' + buttonId,
            //~ params: {bi: buttonId},
            success: Lino.action_handler(panel,on_success,on_confirm)
          });
          //~ Lino.call_ajax_action(panel,'GET',)
        }
        Ext.MessageBox.show(config);
        return;
    }
    
    if (on_success && result.success) on_success(result);
    
    //~ if (on_confirm && result.confirm_message) {
        //~ var config = {title:"Bestätigung"};
        //~ // config.buttons = Ext.MessageBox.YESNOCANCEL;
        //~ config.buttons = Ext.MessageBox.YESNO;
        //~ config.msg = result.confirm_message;
        //~ config.fn = function(buttonId,text,opt) {
          //~ if (buttonId == "yes") {
              //~ on_confirm(panel,undefined,result.step);
          //~ }
        //~ }
        //~ Ext.MessageBox.show(config);
        //~ return;
    //~ }
    //~ if (result.dialog_fn) {
        //~ console.log('20120928 TODO',result.dialog_fn);
    //~ }
    if (result.data_record && ! gridmode) {
        //~ not used
        panel.set_status({data_record:result.data_record});
    }  else if (result.new_status && ! gridmode) {
        //~ not used
        //~ console.log('20120607 new_status');
        panel.set_status(result.new_status);
    } else if (result.goto_record_id != undefined) {
        panel.load_record_id(result.goto_record_id);
    } 
    
    if (result.message) {
        //~ if (result.alert && ! gridmode) {
        if (result.alert) { // 20120628b 
            //~ Ext.MessageBox.alert('Alert',result.alert_msg);
            if (result.alert === true) result.alert = "Alarm";
            Ext.MessageBox.alert(result.alert,result.message);
        } else {
            Lino.notify(result.message);
        }
    }
     
    if (result.refresh_all) {
        var cw = panel.get_containing_window();
        //~ console.log("20120123 refresh_all");
        if (cw) {
          cw.main_item.refresh();
        }
        //~ else console.log("20120123 cannot refresh_all",panel);
    } else {
        //~ console.log("20121212 b gonna refresh",panel);
        if (result.refresh) panel.refresh();
    }
    
    if (result.open_davlink_url) {
       Lino.davlink_open(result.open_davlink_url);
    }
    
    if (result.open_url) {
        //~ console.log(20111126,result.open_url);
        //~ if (!result.message)
            //~ Lino.notify('Open new window <a href="'+result.open_url+'" target="_blank">'+result.open_url+'</a>');
        window.open(result.open_url,'foo',"");
        //~ document.location = result.open_url;
    }
  }
};

Lino.do_action = function(caller,action) {
  action.success = function(response) {
    if (caller.loadMask) caller.loadMask.hide();
    //~ console.log('Lino.do_action()',action,'action success',response);
    if (action.after_success) {
        //~ console.log('Lino.do_action() calling after_success');
        action.after_success();
    }
    if (response.responseText) {
      var result = Ext.decode(response.responseText);
      //~ console.log('Lino.do_action()',action.name,'result is',result);
      if (result.message) {
          if (result.alert) {
              //~ Ext.MessageBox.alert('Alert',result.alert_msg);
              Ext.MessageBox.alert('Alert',result.message);
          } else {
              Lino.notify(result.message);
          }
      }
      
      //~ if (result.alert_msg) Ext.MessageBox.alert('Alert',result.alert_msg);
      //~ if (result.message) Lino.notify(result.message);
      if (result.notify_msg) Lino.notify(result.notify_msg);
      if (result.js_code) { 
        //~ console.log('Lino.do_action()',action,'gonna call js_code in',result);
        var jsr = result.js_code(caller);
        //~ console.log('Lino.do_action()',action,'returned from js_code in',result);
        if (action.after_js_code) {
          //~ console.log('Lino.do_action()',action,'gonna call after_js_code');
          action.after_js_code(jsr);
          //~ console.log('Lino.do_action()',action,'returned from after_js_code');
        //~ } else {
          //~ console.log('Lino.do_action()',action,' : after_js_code is false');
        }
      };
    }
  };
  Ext.applyIf(action,{
    waitMsg: "Bitte warten...",
    failure: Lino.ajax_error_handler(caller),
    params: {}
  });
  //~ action.params.su = Lino.subst_user;
  Lino.insert_subst_user(action.params);
  
  Ext.Ajax.request(action);
};

//~ Lino.gup = function( name )
//~ {
  //~ // Thanks to http://www.netlobo.com/url_query_string_javascript.html
  //~ name = name.replace(/[\[]/,"\\\[").replace(/[\]]/,"\\\]");
  //~ var regexS = "[\\?&]"+name+"=([^&#]*)";
  //~ var regex = new RegExp( regexS );
  //~ var results = regex.exec( window.location.href );
  //~ if( results == null )
    //~ return "";
  //~ else
    //~ return results[1];
//~ };

//~ Lino.refresh_handler = function (ww) {
  //~ return function() { 
      //~ console.log('refresh',ww);
      //~ ww.main_item.doLayout(false,true);
      //~ ww.main_item.syncSize();
  //~ }
//~ };

//~ Lino.tools_close_handler = function (ww) {
  //~ return function() { 
      //~ ww.close();
  //~ }
//~ };
Lino.permalink_handler = function (ww) {
  return function() { 
    //~ document.location = ww.main_item.get_permalink();
    //~ console.log('20130723 Lino.permalink_handler',ww);
    
    /* Uncaught TypeError: Cannot read property 'main_item' of null  */
    if (ww) {
        var url = ww.main_item.get_permalink();
    } else {
        var url = Lino.viewport.get_permalink();
        //~ var url = '/';
    }
    Lino.load_url(url);
  }
};
//~ Lino.run_permalink = function() {
  //~ var plink = Lino.gup('permalink');
  //~ if(plink) { eval('Lino.'+plink); }
//~ }

Lino.ajax_error_handler = function(panel) {
  return function(response,options) {
    console.log('Ajax failure:',response,options);
    if (panel.loadMask) panel.loadMask.hide();
    if (response.responseText) {
      var lines = response.responseText.split('\n');
      if (lines.length > 10) {
          line = lines.splice(5,lines.length-10,"(...)");
      }
      Ext.MessageBox.alert(
        response.statusText,
        lines.join('<br/>')
        //~ response.responseText.replace(/\n/g,'<br/>'))
      )
    } else {
      Ext.MessageBox.alert('Action failed',
        'Lino server did not respond to Ajax request');
    }
  }
}
// Ext.Ajax.on('requestexception',Lino.ajax_error_handler)
 


Ext.QuickTips.init();

/* setting QuickTips dismissDelay to 0 */
// Apply a set of config properties to the singleton
//~ Ext.apply(Ext.QuickTips.getQuickTip(), {
//~ Ext.apply(Ext.ToolTip, {
    //~ dismissDelay: 0
    //~ autoHide: false,
    //~ closable: true,
    //~ maxWidth: 200,
    //~ minWidth: 100,
    //~ showDelay: 50      // Show 50ms after entering target
    //~ ,trackMouse: true
//~ });


//~ Ext.apply(Ext.QuickTip, {
    //~ dismissDelay: 0,
//~ });
  
Lino.quicktip_renderer = function(title,body) {
  return function(c) {
    //~ if (c instanceof Ext.Panel) var t = c.bwrap; else // 20130129
    if (c instanceof Ext.Panel) var t = c.header; else // 20130129
    var t = c.getEl();
    //~ console.log(20130129,t,title,body);
    //~ t.dismissDelay = 0;
    Ext.QuickTips.register({
      target: t,
      //~ cls: 'lino-quicktip-classical',
      dismissDelay: 0,
      //~ autoHide: false,
      showDelay: 50,      // Show 50ms after entering target
      //~ title: title,
      text: body
    });
  }
};


  
Lino.help_text_editor = function() {
  //~ var bp = {
      //~ mk:this.content_type,
      //~ mt:1
    //~ };
    //~ console.log(20120202,bp);
  //~ Lino.lino.ContentTypes.detail({},{base_params:bp});
  //~ Lino.lino.ContentTypes.detail.run(null,{record_id:this.content_type});
  Lino.lino.ContentTypes.detail.run(null,{record_id:this.content_type});
}

// Path to the blank image should point to a valid location on your server
//~ Ext.BLANK_IMAGE_URL = MEDIA_URL + '/extjs/resources/images/default/s.gif'; 


// used as Ext.grid.Column.renderer for id columns in order to hide the special id value -99999
Lino.id_renderer = function(value, metaData, record, rowIndex, colIndex, store) {
  //~ if (record.phantom) return '';
  return value;
}

Lino.raw_renderer = function(value, metaData, record, rowIndex, colIndex, store) {
  return value;
}

Lino.text_renderer = function(value, metaData, record, rowIndex, colIndex, store) {
  //~ return "not implemented"; 
  return value;
}

Lino.NullNumberColumn = Ext.extend(Ext.grid.Column, {
    align : 'right', 
    format : '0,00/i', 
    renderer : function(value, metaData, record, rowIndex, colIndex, store) {
        //~ console.log(20130128,"NullNumberColumn.renderer",value);
        if (value === null) return '';
        return Ext.util.Format.number(value, this.format);
    }
});

//~ Lino.NullNumberColumn = Ext.extend(Ext.grid.NumberColumn, {
    //~ align : 'right', 
    //~ constructor: function(cfg){
        //~ Ext.grid.NumberColumn.superclass.constructor.call(this, cfg);
        //~ var t = this;
        //~ this.renderer = function(value, metaData, record, rowIndex, colIndex, store) {
          //~ console.log(20130128,"NullNumberColumn.renderer",value);
          //~ if (value === null) return '';
          //~ return Ext.util.Format.number(value, t.format);
      //~ };
    //~ }
//~ });




//~ Lino.cell_button_renderer = function(value, metaData, record, rowIndex, colIndex, store) {
  //~ return '<input type="button" onclick="alert(value)" value=" ? ">' ;
//~ }


//~ Lino.default_renderer = function(value, metaData, record, rowIndex, colIndex, store) {
  //~ if (record.phantom) return '';
  //~ return value;
//~ }

Lino.fk_renderer = function(fkname,handlername) {
  //~ console.log('Lino.fk_renderer handler=',handler);
  return function(value, metaData, record, rowIndex, colIndex, store) {
    //~ console.log('Lino.fk_renderer',fkname,rowIndex,colIndex,record,metaData,store);
    //~ if (record.phantom) return '';
    if (value) {
        var s = '<a href="javascript:' ;
        s += handlername + '.run(null,{record_id:\'' + String(record.data[fkname]) + '\'})">';
        s += value + '</a>';
        //~ console.log('Lino.fk_renderer',value,'-->',s);
        return s
    }
    return '';
  }
};

Lino.lfk_renderer = function(panel,fkname) {
  //~ console.log('Lino.fk_renderer handler=',handler);
  var handlername = 'console.log';
  return function(value, metaData, record, rowIndex, colIndex, store) {
    //~ console.log('Lino.fk_renderer',fkname,rowIndex,colIndex,record,metaData,store);
    if (record.phantom) return '';
    if (value) {
        var s = '<a href="javascript:' ;
        s += handlername + '({},{record_id:\'' + String(record.data[fkname]) + '\'})">';
        s += value + '</a>';
        //~ console.log('Lino.fk_renderer',value,'-->',s);
        return s
    }
    return '';
  }
};

//~ Lino.gfk_renderer = function() {
  //~ return function(value, metaData, record, rowIndex, colIndex, store) {
    //~ if (record.phantom) return '';
    //~ console.log('Lino.gfk_renderer',value,colIndex,record,metaData,store);
    //~ return value;
  //~ }
//~ };


Lino.build_buttons = function(panel,actions) {
  //~ console.log("20121006 Lino.build_buttons",actions);
  if (actions) {
    var buttons = Array(actions.length);
    var cmenu = Array(actions.length);
    for (var i=0; i < actions.length; i++) { 
      buttons[i] = new Ext.Toolbar.Button(actions[i]);
      cmenu[i] = actions[i]
      cmenu[i].text = actions[i].menu_item_text;
      if (actions[i].panel_btn_handler) {
          var h = actions[i].panel_btn_handler.createCallback(panel,buttons[i]);
          //~ if (actions[i].must_save) {
          if (actions[i].auto_save == true) {
              buttons[i].on('click',panel.do_when_clean.createDelegate(panel,[true,h]));
          } else if (actions[i].auto_save == null) {
              buttons[i].on('click',panel.do_when_clean.createDelegate(panel,[false,h]));
          } else if (actions[i].auto_save == false) {
              buttons[i].on('click',h);
          } else {
              console.log("20120703 unhandled auto_save value",actions[i])
          }
          cmenu[i].handler = actions[i].panel_btn_handler.createCallback(panel,cmenu[i]);
      }
    }
    return {bbar:buttons, cmenu:new Ext.menu.Menu(cmenu)};
  }
}

Lino.do_when_visible = function(cmp,todo) {
  //~ if (cmp.el && cmp.el.dom) 
  if (cmp.isVisible()) { 
    // 'visible' means 'rendered and not hidden'
    //~ console.log(cmp.title,'-> cmp is visible now');
    todo(); 
  //~ } else {
      //~ cmp.on('resize',todo,cmp,{single:true});
  //~ }
  //~ if (false) { // 20120213
  } else { 
    //~ console.log('Lino.do_when_visible() must defer because not isVisible()',todo,cmp);
    if (cmp.rendered) {
      //~ console.log(cmp,'-> cmp is rendered but not visible: and now?');
      //~ console.log(cmp.title,'-> cmp is rendered but not visible: try again in a moment...');
      //~ var fn = function() {Lino.do_when_visible(cmp,todo)};
      //~ fn.defer(100);
      
      Lino.do_when_visible.defer(50,this,[cmp,todo]);
      //~ Lino.do_when_visible.defer(100,this,[cmp,todo]);
      
    } else {
      //~ console.log(cmp.title,'-> after render');
      cmp.on('afterrender',todo,cmp,{single:true});
    }
  }
  
};    

/*
*/
Lino.do_on_current_record = function(panel,fn,phantom_fn) {
  var rec = panel.get_current_record();
  if (rec == undefined) {
    Lino.notify("There's no selected record.");
    return;
  }
  // 20120307 A VirtualTable with a Detail (lino.Models) has only "phantom" records.
  if (rec.phantom) {
    //~ if (!panel.editable) { console.log("20120312 not editable:",panel)}
    if (phantom_fn) {
      phantom_fn(panel);
    } else {
      Lino.notify("Aktion nicht verfügbar auf dem Phantom-Record.");
    }
    return;
  }
  return fn(rec);
};






Lino.call_ajax_action = function(panel,method,url,p,actionName,step,on_confirm,on_success) {
  p.an = actionName;
  if (!panel) {
      if (Lino.current_window) 
          panel = Lino.current_window.main_item;
      else panel = Lino.viewport;
  }
  //~ console.log("20130809 Lino.call_ajax_action",panel);
  Ext.apply(p,panel.get_base_params());
  if (panel.loadMask) panel.loadMask.show(); 
  //~ p.$ext_requests.URL_PARAM_SUBST_USER = Lino.subst_user;
  //~ Lino.insert_subst_user(p);
    
  //~ if (step) p['$ext_requests.URL_PARAM_ACTION_STEP'] = step;
  //~ if (pp) pp(p); // "parameter processor" : first used for read beid card
  Ext.Ajax.request({
    method: method,
    url: url,
    params: p,
    success: Lino.action_handler(panel,on_success,on_confirm)
  });
};

Lino.row_action_handler = function(actionName,hm,pp) {
  var p = {};
  var fn = function(panel,btn,step) {
      if (pp) { p = pp(); if (! p) return; }
      
      if (panel.get_current_record == undefined) { // AFTER_20130725
        panel = Ext.getCmp(panel);
        if (panel == undefined) {
          Lino.notify("Invalid panel spec.");
          return;
        }
      }
      
      Lino.do_on_current_record(panel,function(rec) {
          //~ console.log(panel);
          //~ 20120723 Lino.call_ajax_action(panel,rec.id,actionName,step,fn);
          Lino.call_ajax_action(panel,hm,panel.get_record_url(rec.id),p,actionName,step,fn);
      });
  };
  return fn;
};

Lino.list_action_handler = function(ls_url,actionName,hm,pp) {
  var p = {};
  var url = '/api' + ls_url
  var fn = function(panel,btn,step) {
      //~ console.log("20121210 Lino.list_action_handler",arguments);
      //~ var url = ADMIN_URL + '/api' + panel.ls_url
      if (pp) { p = pp();  if (! p) return; }
      Lino.call_ajax_action(panel,hm,url,p,actionName,step,fn);
  };
  return fn;
};

Lino.param_action_handler = function(window_action) { // 20121012
  var fn = function(panel,btn,step) {
    Lino.do_on_current_record(panel,function(rec) {
      //~ console.log(panel);
      //~ 20120723 Lino.call_ajax_action(panel,rec.id,actionName,step,fn);
      window_action.run(panel.getId(),{}); 
    });
  };
  return fn;
};


//~ 20130726 Lino.run_row_action = function(requesting_panel,url,pk,actionName,pp) {
Lino.run_row_action = function(requesting_panel,url,meth,pk,actionName,preprocessor) {
  //~ var panel = action.get_window().main_item;
  url = '/api' + url  + '/' + pk;
  var panel = Ext.getCmp(requesting_panel);
  if (preprocessor) var p = preprocessor(); else var p = {};
  var fn = function(panel,btn,step) {
    //~ 20120723 Lino.call_ajax_action(panel,pk,actionName,step,fn);
    //~ 20130726 Lino.call_ajax_action(panel,'GET',url,p,actionName,step,fn);
    Lino.call_ajax_action(panel,meth,url,p,actionName,step,fn);
  }
  fn(panel,null,null);
}



Lino.show_detail = function(panel,btn) {
  Lino.do_on_current_record(panel, 
    function(rec) {
      //~ panel.loadMask.show();
      Lino.run_detail_handler(panel,rec.id);
    },
    Lino.show_insert
  );
};

Lino.run_detail_handler = function(panel,pk) {
  var bp = panel.get_base_params();
  //~ var bp = {};
  panel.add_param_values(bp); // 20120918
  var status = {
    record_id:pk,
    base_params:bp
    //~ param_values: pv.$ext_requests.URL_PARAM_PARAM_VALUES
  }
  //~ console.log("20120918 Lino.show_detail",status);
  panel.ls_detail_handler.run(null,status);
  //~ panel.loadMask.hide();
  //~ panel.containing_window.window.hideMask();
  //~ panel.el.unmask();
}

Lino.show_fk_detail = function(combo,detail_action) {
    //~ console.log("Lino.show_fk_detail",combo,handler);
    pk = combo.getValue();
    if (pk) {
        detail_action.run(null,{record_id: pk})
      } else {
        Lino.notify("Cannot show detail for empty foreign key.");
      }
};

Lino.show_insert = function(panel,btn) {
  var bp = panel.get_base_params();
  //~ console.log('20120125 Lino.show_insert',bp)
  //~ panel.ls_insert_handler.run(null,{record_id:-99999,base_params:bp});
  panel.ls_insert_handler.run(panel.getId(),{record_id:-99999,base_params:bp});
};

Lino.show_insert_duplicate = function(panel,btn) {
  Lino.do_on_current_record(panel,
    function(rec) {
      var newRec = {};
      Ext.apply(newRec,rec);
      newRec.id = -99999;
      panel.ls_insert_handler.run(null,{data_record:rec});
    });
};

//~ Lino.update_row_handler = function(action_name) {
  //~ return function(panel,btn) {
    //~ Lino.notify("Sorry, " + action_name + " is not implemented.");
  //~ }
//~ };




if (Ext.ux.grid !== undefined) {
    Lino.GridFilters = Ext.extend(Ext.ux.grid.GridFilters,{
      encode:true,
      local:false
    });
} else {
    Lino.GridFilters = function() {}; // dummy
    Ext.override(Lino.GridFilters,{
      init : function() {}
    });
};



//~ Lino.ButtonField = Ext.extend(Ext.form.TextField,{
//~ Lino.ButtonField = Ext.extend(Ext.form.Field,{
    //~ editable : false,
    //~ constructor : function(ww,config,params){
      //~ this.containing_window = ww;
      //~ if (params) Ext.apply(config,params);
      //~ Lino.ButtonField.superclass.constructor.call(this, config);
    //~ },
    //~ setButtons : function(buttons){
      //~ console.log('setButtons',buttons);
    //~ },
    //~ onRender : function(ct, position){
        //~ if(!this.el){
            //~ this.panel = new Ext.Container({items:[
              //~ {xtype:'button',text:'upload'},
              //~ {xtype:'button',text:'show'},
              //~ {xtype:'button',text:'edit'}
            //~ ]});
            //~ this.panel.ownerCt = this;
            //~ this.el = this.panel.getEl();

        //~ }
        //~ Lino.ButtonField.superclass.onRender.call(this, ct, position);
    //~ },

  
//~ });

Lino.FieldBoxMixin = {
  before_init : function(config,params) {
    if (params) Ext.apply(config,params);
    var actions = Lino.build_buttons(this,config.ls_bbar_actions);
    if (actions) config.bbar = actions.bbar;
  },
  //~ constructor : function(ww,config,params){
    //~ this.containing_window = ww;
    //~ if (params) Ext.apply(config,params);
    //~ var actions = Lino.build_buttons(this,config.ls_bbar_actions);
    //~ if (actions) config.bbar = actions.bbar;
    //~ Lino.FieldBoxMixin.superclass.constructor.call(this, config);
  //~ },
  do_when_clean : function(auto_save,todo) { todo() },
  //~ format_data : function(html) { return '<div class="htmlText">' + html + '</div>' },
  format_data : function(html) { return html },
  get_base_params : function() {
    // needed for insert action
    var p = Ext.apply({},this.base_params);
    Lino.insert_subst_user(p);
    return p;
  },
  set_base_params : function(p) {
    this.base_params = Ext.apply({},p);
    //~ if (p.param_values) this.set_param_values(p.param_values);  
  },
  clear_base_params : function() {
      this.base_params = {};
      Lino.insert_subst_user(this.base_params);
  },
  set_base_param : function(k,v) {
    this.base_params[k] = v;
  }
};



Lino.HtmlBoxPanel = Ext.extend(Ext.Panel,Lino.PanelMixin);
Lino.HtmlBoxPanel = Ext.extend(Lino.HtmlBoxPanel,Lino.FieldBoxMixin);
Lino.HtmlBoxPanel = Ext.extend(Lino.HtmlBoxPanel,{
  disabled_in_insert_window : true,
  constructor : function(config,params) {
    this.before_init(config,params);
    Lino.HtmlBoxPanel.superclass.constructor.call(this, config);
  },
  //~ constructor : function(ww,config,params){
    //~ this.ww = ww;
    //~ if (params) Ext.apply(config,params);
    //~ var actions = Lino.build_buttons(this,config.ls_bbar_actions);
    //~ if (actions) config.bbar = actions.bbar;
    //~ Lino.FieldBoxMixin.constructor.call(this, ww,config,params);
  //~ },
  //~ constructor : function(ww,config,params){
    //~ this.ww = ww;
    //~ if (params) Ext.apply(config,params);
    //~ var actions = Lino.build_buttons(this,config.ls_bbar_actions);
    //~ if (actions) config.bbar = actions.bbar;
    //~ Lino.FieldBoxMixin.superclass.constructor.call(this, config);
  //~ },
  //~ disable : function() { var tb = this.getBottomToolbar(); if(tb) tb.disable()},
  //~ enable : function() { var tb = this.getBottomToolbar(); if(tb) tb.enable()},
  onRender : function(ct, position){
    Lino.HtmlBoxPanel.superclass.onRender.call(this, ct, position);
    //~ console.log(20111125,this.containing_window);
    if (this.containing_panel) {
      this.containing_panel.on('enable',this.enable,this);
      this.containing_panel.on('disable',this.disable,this);
    }
    this.el.on({
      dragenter:function(event){
        event.browserEvent.dataTransfer.dropEffect = 'move';
        return true;
      }
      ,dragover:function(event){
        event.browserEvent.dataTransfer.dropEffect = 'move';
        event.stopEvent();
        return true;
      }
      ,drop:{
        scope:this
        ,fn:function(event){
          event.stopEvent();
          //~ console.log(20110516);
          var files = event.browserEvent.dataTransfer.files;
          if(files === undefined){
            return true;
          }
          var len = files.length;
          while(--len >= 0){
            console.log(files[len]);
            //~ this.processDragAndDropFileUpload(files[len]);
          }
          Lino.show_insert(this);
        }
      }
    });
  },
  refresh : function(unused) { 
      this.refresh_with_after();
  },
  refresh_with_after : function(after) {
    //~ if (this.master_panel) {
      var record = this.containing_panel.get_current_record();
      //~ console.log('HtmlBox.refresh()',this.title,record,record.title);
      var box = this.items.get(0);
      var todo = function() {
        if (this.disabled) return;
        //~ this.set_base_params(this.containing_window.get_base_params());
        this.set_base_params(this.containing_panel.get_master_params());
        var el = box.getEl();
        if (el) {
          el.update(record ? this.format_data(record.data[this.name]) : '');
          //~ console.log('20130723 HtmlBox.refresh()',this.name);
        //~ } else {
          //~ console.log('HtmlBox.refresh() failed for',this.name);
        }
      };
      Lino.do_when_visible(box,todo.createDelegate(this));
    //~ }
  }
});
//~ Ext.override(Lino.HtmlBoxPanel,Lino.FieldBoxMixin);



Lino.RichTextPanel = Ext.extend(Ext.Panel,Lino.PanelMixin);
Lino.RichTextPanel = Ext.extend(Lino.RichTextPanel,Lino.FieldBoxMixin);
Lino.RichTextPanel = Ext.extend(Lino.RichTextPanel,{
    
  //~ initComponent : function(){
    //~ Lino.RichTextPanel.superclass.initComponent.call(this);
  //~ },
  constructor : function(config,params) {
    //~ console.log('Lino.RichTextPanel.initComponent',this);
    //~ var url = TEMPLATES_URL + config.ls_url + "/" + String(rec.id) + "/" + config.name;
    //~ var url = TEMPLATES_URL + config.ls_url + "/" + config.name;
    var t = this;
    var tinymce_options = {
        theme : "advanced",
        content_css: '/media/lino/extjs/lino.css',
        language: 'en',
        //~ template_external_list_url : url,
        theme_advanced_toolbar_location : "top",
        theme_advanced_toolbar_align : "left",
        theme_advanced_statusbar_location : "bottom",
        template_popup_width : 700,
        template_popup_height : 500,
        template_replace_values : { 
            data_field : function(element){ 
                //~ console.log(20110722,fieldName,t.containing_window.get_current_record()); 
                var fieldName = element.innerHTML;
                element.innerHTML = t.containing_panel.get_current_record().data[fieldName];
            } 
        }
      };
      
    var editorConfig = {
      tinymceSettings: {
        plugins : "noneditable,template", 
        // Theme options - button# indicated the row# only
        theme_advanced_buttons1 : "bold,italic,underline,|,justifyleft,justifycenter,justifyright,|,bullist,numlist,|,outdent,indent,|,undo,redo,|,removeformat,template",
        theme_advanced_buttons2 : "",
        theme_advanced_buttons3 : "", // ,|,sub,sup,|,charmap",      
        theme_advanced_resizing : false
        //~ save_onsavecallback : save_callback,
        //~ save_enablewhendirty : true
        //~ save_oncancelcallback: on_cancel
        
    }};
    Ext.apply(editorConfig.tinymceSettings,tinymce_options);
    //~ editorConfig.name = config.action_name;
    editorConfig.name = config.name;
    delete config.name;
    //~ config.title = config.label;
    //~ delete config.label;
    this.before_init(config,params);
    
    this.editor = new Ext.ux.TinyMCE(editorConfig);
    var t = this;
    config.tools = [{
                      qtip: "Edit text in own window", 
                      id: "up",
                      handler: function(){
                        if(t.editor.isDirty()) {
                            var record = t.containing_panel.get_current_record();
                            record.data[t.editor.name] = t.editor.getValue();
                        }
                        Lino.edit_tinymce_text(t,tinymce_options)
                      }
                    }];
    
    config.items = this.editor;
    config.layout = "fit";
    Lino.RichTextPanel.superclass.constructor.call(this, config);
  },
  refresh : function(unused) { 
      this.refresh_with_after();
  },
  refresh_with_after : function(after) {
    var record = this.containing_panel.get_current_record();
    //~ console.log('RichTextPanel.refresh()',this.title,record.title,record);
    var todo = function() {
      //~ this.set_base_params(this.containing_window.get_base_params());
      if (record) {
        var url = '/templates' + this.containing_panel.ls_url + "/" 
            + String(record.id) + "/" + this.editor.name;
        //~ console.log('RichTextPanel.refresh()',url);
        if (this.editor.ed) this.editor.ed.settings.template_external_list_url = url;
        this.set_base_params(this.containing_panel.get_master_params());
        //~ var v = record ? this.format_data(record.data[this.editor.name]) : ''
        var v = this.format_data(record.data[this.editor.name])
        this.editor.setValue(v);
      } else {
        this.editor.setValue('(no data)');
      }
    };
    Lino.do_when_visible(this,todo.createDelegate(this));
  }
});
//~ Ext.override(Lino.RichTextPanel,Lino.FieldBoxMixin);



Lino.ActionFormPanel = Ext.extend(Ext.form.FormPanel,Lino.MainPanel);
Lino.ActionFormPanel = Ext.extend(Lino.ActionFormPanel,Lino.PanelMixin);
Lino.ActionFormPanel = Ext.extend(Lino.ActionFormPanel,Lino.FieldBoxMixin);
Lino.ActionFormPanel = Ext.extend(Lino.ActionFormPanel,{
  //~ layout:'fit'
  //~ ,autoHeight: true
  //~ ,frame: true
  window_title: "Action Parameters",
  constructor : function(config){
    config.bbar = [
        {text:'OK',handler:this.on_ok,scope:this},
        {text:'Cancel',handler:this.on_cancel,scope:this}
    ];
    //~ config.items = config.params_panel;
    Lino.ActionFormPanel.superclass.constructor.call(this, config);
  }
  //~ ,initComponent : function(){
    //~ Lino.ActionFormPanel.superclass.initComponent.call(this);
  //~ }
  ,on_cancel : function() { 
    this.get_containing_window().close();
  }
  ,on_ok : function() { 
    //~ var rp = this.requesting_panel;
    //~ console.log("on_ok",this.requesting_panel,arguments);
    var panel = this.requesting_panel;
    //~ if (panel == undefined) {
        //~ Lino.alert("Sorry, dialog actions don't work without a requesting_panel");
        //~ return;
    //~ }
    //~ var rec = panel.get_current_record();
    var actionName = this.action_name;
    var pk = this.base_params.mk;
    if (pk == undefined && panel) {
        pk = panel.get_current_record().id;
    }
    if (pk == undefined) {
        Lino.alert("Sorry, dialog action without base_params.mk");
        return;
    }
    var self = this;
    function on_success() { self.get_containing_window().close(); };
    var url = '/api' + this.ls_url + '/' + pk;
    var fn = function(panel,btn,step) {
      var p = {};
      self.add_field_values(p)
      //~ Lino.call_ajax_action(panel,'GET',panel.get_record_url(rec.id),p,actionName,step,fn,on_success);
      Lino.call_ajax_action(panel,'GET',url,p,actionName,step,fn,on_success);
    }
    fn(panel,null,null);
    
    
  }
  ,set_status : function(status,rp){
    this.requesting_panel = Ext.getCmp(rp);
    //~ console.log('20120918 ActionFormPanel.set_status()',status,rp,this.requesting_panel);
    this.clear_base_params();
    if (status == undefined) status = {};
    //~ if (status.param_values) 
    this.set_field_values(status.field_values);
    if (status.base_params) this.set_base_params(status.base_params);
  }
  
  ,add_field_values : function (p) { // similar to add_param_values()
      //~ 20121023 
      if (this.form.isDirty()) {
        p.fv = this.get_field_values();
      }else{
        if (this.status_field_values) 
          p.fv = Lino.fields2array(this.fields,this.status_field_values);
      }
      //~ if (!this.form.isDirty()) return;
      //~ p.$ext_requests.URL_PARAM_FIELD_VALUES = this.get_field_values();
      //~ console.log("20120203 add_param_values added pv",pv,"to",p);
  }
  ,get_field_values : function() {
      return Lino.fields2array(this.fields);
  }
  ,set_field_values : function(pv) {
      //~ console.log('20120203 MainPanel.set_param_values', pv);
      this.status_field_values = pv;
      if (pv) this.form.my_loadRecord(pv);
      else this.form.reset(); 
  }
  ,config_containing_window : function(wincfg) { 
      wincfg.title = this.window_title;
      wincfg.keys = [
        { key: Ext.EventObject.ENTER, fn: this.on_ok }
      ]
  }
});

//~ Lino.add_blank = function(oa) {
    //~ return [].concat(oa)
    //~ return 
    //~ }
    
Lino.fields2array = function(fields,values) {
    //~ console.log('20130605 fields2array gonna loop on', fields,values);
    var pv = Array(fields.length);
    for(var i=0; i < fields.length;i++) {
        var f = fields[i]
        if (values) 
          var v = values[f.name];
        else 
          var v = f.getValue();
        if (f.formatDate) {
            pv[i] = f.formatDate(v); 
        } else {
            pv[i] = v; // f.getValue(); 
        }
    }
    return pv;
}


Lino.FormPanel = Ext.extend(Ext.form.FormPanel,Lino.MainPanel);
Lino.FormPanel = Ext.extend(Lino.FormPanel,Lino.PanelMixin);
Lino.FormPanel = Ext.extend(Lino.FormPanel,{
  params_panel_hidden : false,
  //~ base_params : {},
  //~ trackResetOnLoad : true,
  //~ query_params : {},
  //~ 20110119b quick_search_text : '',
  constructor : function(config,params){
    if (params) Ext.apply(config,params);
    this.base_params = {};
    //~ ww.config.base_params.query = ''; // 20111018
    //~ console.log(config);
    //~ console.log('FormPanel.constructor() 1',config)
    //~ Ext.applyIf(config,{base_params:{}});
    //~ console.log('FormPanel.constructor() 2',config)
      
    config.trackResetOnLoad = true;
    
    Lino.FormPanel.superclass.constructor.call(this, config);
      
    //~ this.set_base_param('$URL_PARAM_FILTER',null); // 20111018
    //~ this.set_base_param('$URL_PARAM_FILTER',''); // 20111018
      
  },
  initComponent : function(){
    
    //~ console.log("20111201 containing_window",this.containing_window,this);
    
    var actions = Lino.build_buttons(this,this.ls_bbar_actions);
    if (actions) {
        this.bbar = actions.bbar;
    //~ } else {
        //~ this.bbar = [];
    }
    //~ Ext.apply(config,Lino.build_buttons(this,config.ls_bbar_actions));
    //~ config.bbar = Lino.build_buttons(this,config.ls_bbar_actions);
    //~ var config = this;
    
    //~ if (this.containing_window instanceof Lino.DetailWrapper) {
    
    //~ console.log('20120121 initComponent', this.action_name);
    //~ if (this.action_name == 'detail' | this.action_name == 'show') {
    //~ if (this.action_name != 'insert') {
    if (! this.hide_top_toolbar) {
      this.tbar = [];
      // 20111015    
      if (! this.hide_navigator) {
        this.record_selector = new Lino.RemoteComboFieldElement({
          store: new Lino.ComplexRemoteComboStore({
            //~ baseParams: this.containing_window.config.base_params,
            baseParams: this.get_base_params(),
            //~ value: this.containing_window.config.base_params.query,
            proxy: new Ext.data.HttpProxy({
              url: '/choices' + this.ls_url,
              method:'GET'
            })
          }),
          pageSize:25,
          listeners: { 
            scope:this, 
            select:function(combo,record,index) {
              //~ console.log('jumpto_select',arguments);
              this.goto_record_id(record.id);
            }
          },
          emptyText: "Gehe zu Datensatz"
        })
        this.tbar = this.tbar.concat([this.record_selector]);
        
        this.tbar = this.tbar.concat([
          this.first = new Ext.Toolbar.Button({
            tooltip:"Erster",disabled:true,handler:this.moveFirst,scope:this,iconCls:'x-tbar-page-first'}),
          this.prev = new Ext.Toolbar.Button({
            tooltip:"Voriger",disabled:true,handler:this.movePrev,scope:this,iconCls:'x-tbar-page-prev'}),
          this.next = new Ext.Toolbar.Button({
            tooltip:"Nächster",disabled:true,handler:this.moveNext,scope:this,iconCls:'x-tbar-page-next'}),
          this.last = new Ext.Toolbar.Button({
            tooltip:"Letzter",disabled:true,handler:this.moveLast,scope:this,iconCls:'x-tbar-page-last'})
        ]);
      }
      this.tbar = this.add_params_panel(this.tbar);
      
      //~ console.log(20101117,this.containing_window.refresh);
      this.tbar = this.tbar.concat([
        {
          //~ text:'Refresh',
          handler:function(){ this.do_when_clean(true,this.refresh.createDelegate(this)) },
          iconCls: 'x-tbar-loading',
          tooltip:"Datensatz neu laden",
          scope:this}
      ]);
          
      if (this.bbar) { // since 20121016
        if (this.tbar) {
            this.tbar = this.tbar.concat(['-']) ;
        } else {
          this.tbar = [];
        }
        this.tbar = this.tbar.concat(this.bbar) ;
        this.bbar = undefined;
      }
    
      this.tbar = this.tbar.concat([
          '->',
          this.displayItem = new Ext.Toolbar.TextItem({})
      ]);
          
    }
    //~ if (this.content_type && this.action_name != 'insert') {
      //~ this.bbar = this.bbar.concat([
        //~ '->',
        //~ { text: "[$_('Help Text Editor')]",
          //~ handler: Lino.help_text_editor,
          //~ qtip: "$_('Edit help texts for fields on this model.')",
          //~ scope: this}
      //~ ])
    //~ }
    //~ this.before_row_edit = config.before_row_edit.createDelegate(this);
      
    //~ if (this.master_panel) {
        //~ this.set_base_params(this.master_panel.get_master_params());
    //~ }
      
    Lino.FormPanel.superclass.initComponent.call(this);
    
    this.on('render',function(){
      this.loadMask = new Ext.LoadMask(this.bwrap,{msg:"Bitte warten..."});
    },this);
    
    
    //~ var this_ = this;
    //~ this.cascade(function(cmp){
      //~ // var active_field = false;
      //~ for (i = 0; i < this_.active_fields.length; i++) {
        //~ if (cmp.name == this_.active_fields[i]) {
            //~ // active_field = true; break;
            //~ cmp.on("change",function() {this_.save()});
        //~ }
      //~ };
      //~ if (active_field) {
      // if (cmp instanceof Lino.GridPanel) {
          //~ cmp.on("change",function() {this_.save()});
      //~ }
    //~ });
    
    if (this.action_name == 'insert') {
      this.cascade(function(cmp){
        // console.log('20110613 cascade',cmp);
        if (cmp.disabled_in_insert_window) {
            //~ cmp.disable();
            cmp.hide();
        }
      });
      
    }
    
  },
  
  unused_is_loading : function() { 
    if (this.current_record == null) {
        //~ console.log("20130515 current_record is null");
        return true; 
    }
    
    if (! this.loadMask) return true; // not even rendered: 
    if (! this.loadMask.el) return true; // not even rendered: 
    // thanks to Marco Pegoraro http://movableapp.com/2011/09/sencha-touch-loadmask-isvisible/
    var loading = (this.loadMask.el.select('.x-loading-msg').elements.length > 0);
    //~ console.log('20130515 GridPanel.is_loading() returns',loading);
    return loading;

    
    var loading = false;
    this.cascade(function(cmp){
        if (cmp instanceof Lino.GridPanel && cmp.is_loading()) {
            //~ console.log(20130515, cmp.title,'is loading');
            loading = true;
            return false;
        }
      });
    return loading;
    //~ var a = this.findByType(Lino.GridPanel);
    //~ for (i=0;i<a.length;i++) {
        //~ if (a[i].is_loading()) return true;
    //~ }
    //~ return false;
  },
  
  get_status : function(){
      var st = {
        base_params: this.get_base_params(),
        data_record : this.get_current_record()
        }
      var tp = this.items.get(0);
      if (tp instanceof Ext.TabPanel) {
        st.active_tab = tp.getActiveTab();
      }
      st.param_values = this.status_param_values;
      return st;
  },
  /* FormPanel */
  set_status : function(status,rp){
    this.requesting_panel = Ext.getCmp(rp);
    //~ console.log('20120918 FormPanel.set_status()',status);
    this.clear_base_params();
    if (status == undefined) status = {};
    //~ if (status.param_values) 
    this.set_param_values(status.param_values);
    if (status.base_params) this.set_base_params(status.base_params);
    var tp = this.items.get(0);
    if (tp instanceof Ext.TabPanel) {
      if (status.active_tab) {
        //~ console.log('20111201 active_tab',this.active_tab,this.items.get(0));
        //~ tp.activeTab = status.active_tab;
        tp.setActiveTab(status.active_tab);
        //~ this.main_item.items.get(0).activate(status.active_tab);
      } else {
        tp.setActiveTab(0);
      }
      }
    
    if (status.data_record) {
      //~ console.log('20111201 Lino.FormPanel with data_record',this.data_record.title,this.containing_window);
      //~ this.main_item.on_master_changed.defer(2000,this.main_item,[status.data_record]);
      //~ Lino.do_when_visible(this.main_item,function(){this.on_master_changed(status.data_record)});
      //~ this.main_item.on('afterrender',function(){
      //~   this.main_item.on_master_changed(status.data_record)},this,{single:true});
      /* must defer because because set_window_title() didn't work otherwise */
      this.set_current_record.createDelegate(this,[status.data_record]).defer(100);
      //~ this.set_current_record(this.data_record);
      //~ return;
    } else if (status.record_id != undefined) { 
      /* possible values include 0 and null, 0 being a valid record id, 
      null the equivalent of undefined
      */
      //~ this.main_item.goto_record_id(this.status.record_id);
      this.load_record_id(status.record_id);
    } else {
      this.set_current_record(undefined);
    }
  },
    
  get_base_params : function() {
    // needed for insert_action
    var p = Ext.apply({},this.base_params);
    Lino.insert_subst_user(p);
    return p;
    //~ return this.base_params;
  },
  set_base_params : function(p) {
    //~ this.base_params = Ext.apply({},this.base_params); // make sure it is an instance variable
    delete p['query'] // 20120725
    Ext.apply(this.base_params,p);
    if (this.record_selector) {
        var store = this.record_selector.getStore();
        for (k in p) store.setBaseParam(k,p[k]);
        delete this.record_selector.lastQuery;
        //~ console.log("20120725 record_selector.setBaseParam",p)
    }
  },
  clear_base_params : function() {
      this.base_params = {};
      Lino.insert_subst_user(this.base_params);
        
      //~ if (this.record_selector) {
          //~ var store = this.record_selector.getStore();
          //~ for (k in store.baseParams) store.setBaseParam(k,undefined);
          //~ delete this.record_selector.lastQuery;
          //~ console.log("20120725 record_selector.getBaseParams() -->",store.baseParams)
      //~ }
  },
  set_base_param : function(k,v) {
    //~ this.base_params = Ext.apply({},this.base_params); // make sure it is an instance variable
    this.base_params[k] = v;
    //~ if (this.record_selector) {
        //~ this.record_selector.getStore().setBaseParam(k,v);
        //~ delete this.record_selector.lastQuery;
    //~ }
  },
  
  after_delete : function() {
    if (this.current_record.navinfo.next)
      this.moveNext();
    else if (this.current_record.navinfo.prev)
      this.movePrev();
    else 
      this.abandon();
  },
  moveFirst : function() {this.goto_record_id(this.current_record.navinfo.first)},
  movePrev : function() {this.goto_record_id(this.current_record.navinfo.prev)},
  moveNext : function() {this.goto_record_id(this.current_record.navinfo.next)},
  moveLast : function() {this.goto_record_id(this.current_record.navinfo.last)},
  
  
  refresh : function(unused) { 
      this.refresh_with_after();
  },
  refresh_with_after : function(after) { 
    //~ console.log('20120121 Lino.FormPanel.refresh()',this);
    if (this.current_record) {
        this.load_record_id(this.current_record.id,after);
    } else {
        this.set_current_record(undefined,after);
    }
  },
  
  do_when_clean : function(auto_save,todo) {
    var this_ = this;
    if (this.form.isDirty()) {
        if (auto_save) {
            this_.save(todo);
        } else {
          //~ console.log('20111217 do_when_clean() form is dirty',this.form);
          var config = {title:"Bestätigung"};
          config.buttons = Ext.MessageBox.YESNOCANCEL;
          config.msg = "Änderungen in diesem Datensatz speichern?";
          config.fn = function(buttonId,text,opt) {
            //~ console.log('do_when_clean',buttonId)
            if (buttonId == "yes") {
                //~ Lino.submit_detail(this_,undefined,todo);
                //~ this_.containing_window.save(todo);
                this_.save(todo);
            } else if (buttonId == "no") { 
              todo();
            }
          }
        }
        Ext.MessageBox.show(config);
    }else{
      //~ console.log('do_when_clean : now!')
      todo();
    }
  },
  
  goto_record_id : function(record_id) {
    //~ console.log('20110701 Lino.FormPanel.goto_record_id()',record_id);
    //~ var this_ = this;
    //~ this.do_when_clean(function() { this_.load_record_id(record_id) }
    this.do_when_clean(true,this.load_record_id.createDelegate(this,[record_id]));
  },
  
  load_record_id : function(record_id,after) {
    var this_ = this;
    //~ var p = { fmt: this.containing_window.config.action_name};
    //~ var p = Ext.apply({},this.containing_window.config.base_params);
    var p = Ext.apply({},this.get_base_params());
    //~ Lino.insert_subst_user(p);
    //~ console.log('20110713 action_name=',this.containing_window.config.action_name,
      //~ 'base_params=',this.containing_window.config.base_params);
    if (this.action_name)
        p.an = this.action_name;
    //~ p.an = this.action_name;
    //~ p.an = this.containing_window.config.action_name;
    //~ p.fmt = 'json';
    //~ p.fmt = '$ext_requests.URL_FORMAT_JSON';
    p.rp = this.getId();
    //~ p.$ext_requests.URL_PARAM_SUBST_USER = Lino.subst_user;
    p.fmt = 'json';
    //~ 20110119b p['$URL_PARAM_FILTER'] = this.quick_search_text;
    //~ Ext.apply(p,this.query_params);
    this.add_param_values(p);
    //~ console.log('20121120 FormPanel.load_record_id',record_id,p);
    if (this.loadMask) this.loadMask.show();
    Ext.Ajax.request({ 
      waitMsg: 'Loading record...',
      method: 'GET',
      params: p,
      scope: this,
      url: this.get_record_url(record_id),
      success: function(response) {   
        // todo: convert to Lino.action_handler.... but result 
        if (this.loadMask) this.loadMask.hide();
        if (response.responseText) {
          var rec = Ext.decode(response.responseText);
          //~ console.log('20120918 goto_record_id success',rec);
          this.set_param_values(rec.param_values);
          this.set_current_record(rec,after);
        }
      },
      failure: Lino.ajax_error_handler(this)
    });
  },

  abandon : function () {
    Ext.MessageBox.alert('Note',
      "Keine weiteren Datensätze zu sehen. Detail-Fenster wird geschlossen.");
    Lino.close_window();
    //~ if (this.containing_window) {
        //~ this.containing_window.hide();
    //~ }
  },
  
  set_current_record : function(record,after) {
    //~ console.log('20120722 Lino.FormPanel.set_current_record',record.title,record);
    if (this.record_selector) {
        this.record_selector.clearValue();
        // e.g. InsertWrapper FormPanel doesn't have a record_selector
    }
    this.current_record = record;
    //~ if (record) 
        //~ console.log('Lino.FormPanel.set_current_record',record.title,record);
    //~ else
        //~ console.log('Lino.FormPanel.set_current_record',record);
    //~ this.config.main_panel.form.load(record);    
    if (record) {
      this.enable();
      this.form.my_loadRecord(record.data);
      this.set_window_title(record.title);
      //~ this.getBottomToolbar().enable();
      var da = record.data.disabled_actions;
      if (da) {
          //~ console.log('20120528 disabled_actions =',da,this.getBottomToolbar());
          //~ 20121016 this.getBottomToolbar().items.each(function(item,index,length){
          var tb = this.getTopToolbar();
          if (tb) tb.items.each(function(item,index,length){
              //~ console.log('20120528 ',item.itemId,'-->',da[item.itemId]);
              if (da[item.itemId]) item.disable(); else item.enable();
          });
      };
      if (this.disable_editing | record.data.disable_editing) {
          //~ console.log("20120202 disable_editing",record.title);
          this.form.items.each(function(cmp){
            if (!cmp.always_enabled) cmp.disable();
          },this);
      } else {
          this.form.items.each(function(cmp){
            //~ console.log("20120202",cmp);
            if (record.data.disabled_fields[cmp.name]) cmp.disable();
            else cmp.enable();
          },this);
        
          //~ if (record.data.disabled_fields) {
              //~ for (i = 0; i < record.data.disabled_fields.length; i++) {
                  //~ var flds = this.find('name',record.data.disabled_fields[i]);
                  //~ if (flds.length == 1) { 
                    //~ flds[0].disable(); 
                  //~ }
              //~ }
          //~ }
      };
      if (this.first) {
        if (record.navinfo  && ! this.hide_navigator) {
          this.first.setDisabled(!record.navinfo.first);
          this.prev.setDisabled(!record.navinfo.prev);
          this.next.setDisabled(!record.navinfo.next);
          this.last.setDisabled(!record.navinfo.last);
          this.displayItem.setText(record.navinfo.message);
        } else {
          this.first.setDisabled(true);
          this.prev.setDisabled(true);
          this.next.setDisabled(true);
          this.last.setDisabled(true);
        }
      }
    } else {
      if (this.form.rendered) 
        this.form.reset(); /* FileUploadField would fail when resetting a non-rendered form */
      //~ this.disable();
      //~ this.getBottomToolbar().disable();
      this.form.items.each(function(cmp){
        cmp.disable();
      },this);
      this.set_window_title(this.empty_title);
      //~ this.containing_window.window.setTitle(this.empty_title);
      if (!this.hide_navigator) {
        this.first.disable();
        this.prev.disable();
        this.next.disable();
        this.last.disable();
      }
    }
    //~ console.log('20100531 Lino.DetailMixin.on_load_master_record',this.main_form);
    this.before_row_edit(record);
    if (after) after();
  },
  
  before_row_edit : function(record) {},
  search_change : function(field,oldValue,newValue) {
    //~ console.log('search_change',field.getValue(),oldValue,newValue)
    this.set_base_param('query',field.getValue()); 
    this.refresh();
  },
  
  get_selected : function() { return [ this.current_record ] },
  get_current_record : function() {  
    //~ console.log(20100714,this.current_record);
    return this.current_record 
  },
  
  get_permalink_url : function() {
      var rec = this.get_current_record();
      if (rec && ! rec.phantom && rec.id != -99998)
          return '/api' + this.ls_url + '/' + rec.id;
      return '/api' + this.ls_url;
    
  },
  get_permalink_params : function() {
    var p = {};
    //~ var p = {an:'detail'};
    if (this.action_name)
        p.an = this.action_name;
    //~ var p = {an:this.action_name};
    var main = this.items.get(0);
    if (main.activeTab) {
      var tab = main.items.indexOf(main.activeTab);
      //~ console.log('main.activeTab',tab,main.activeTab);
      if (tab) p.tab = tab;
    }
    this.add_param_values(p)
    return p;
  },
  
  /* 
  Lino.FormPanel.save() 
  */
  save : function(after,switch_to_detail,action_name) {
    //~ var panel = this;
    //~ console.log('20121120 FormPanel.save');
    this.loadMask.show();
    var rec = this.get_current_record();
    if (this.has_file_upload) this.form.fileUpload = true;
    //~ console.log('FormPanel.save()',rec);
    if (!action_name) action_name = this.action_name;
    if (rec) {
      var p = {};
      Ext.apply(p,this.get_base_params());
      p.rp = this.getId();
      //~ if (this.action_name) 
          //~ p.$ext_requests.URL_PARAM_ACTION_NAME = this.action_name;
      p.an = action_name;
      if (rec.phantom) {
        //~ if (this.action_name != 'insert') 
            //~ console.log("Warning: phantom record, but action_name is",this.action_name)
        this.form.submit({
          url: '/api' + this.ls_url,
          method: 'POST',
          params: p, 
          scope: this,
          success: function(form, action) {
            this.loadMask.hide();
            Lino.notify(action.result.message);
            /***
            Close this window, but update the status of the 
            calling window.
            If the calling window is a detail on the same table,
            then it should skip to the new record. But only then.
            A successful response usually has a data_record,
            except if it is a fileupload form where some mysterious 
            decoding problems (20120209) force us to return a record_id 
            which will lead to an additional GET.
            ***/
            var url = this.ls_url;
            var ww = Lino.calling_window();
            if (ww && ww.window.main_item instanceof Lino.FormPanel 
                   && ww.window.main_item.ls_url == this.ls_url) {
                //~ console.log("20120217 case 1");
                ww.status.record_id = action.result.record_id;
                ww.status.data_record = action.result.data_record;
                Lino.close_window();
            } else if (this.ls_detail_handler && switch_to_detail) {
                //~ console.log("20120217 case 2");
                Lino.kill_current_window();
                this.ls_detail_handler.run(null,{
                    record_id:action.result.record_id,
                    data_record: action.result.data_record,
                    base_params:this.get_base_params()
                });
            } else {
                //~ console.log("20120217 case 3");
                Lino.close_window();
            }
            //~ Lino.close_window(function(ww){
                //~ if (ww.window.main_item instanceof Lino.FormPanel 
                    //~ && ww.window.main_item.ls_url == url) {
                  //~ ww.status.record_id = action.result.record_id,
                  //~ ww.status.data_record = action.result.data_record
                //~ }
            //~ });
          },
          failure: function(form,action) { 
            this.loadMask.hide();
            Lino.on_submit_failure(form,action);
          },
          clientValidation: true
        })
      } else {
        //~ if (this.action_name != 'detail') 
            //~ console.log("Warning: non-phantom record, but action_name is",this.action_name)
        this.form.submit({
          url: '/api' + this.ls_url + '/' + rec.id,
          method: 'PUT',
          //~ headers: { 'HTTP_X_REQUESTED_WITH' : 'XMLHttpRequest'},
          scope: this,
          params: p, 
          success: function(form, action) {
            //~ panel.form.setValues(rec.data);
            //~ 20110701 panel.form.my_loadRecord(rec);
            this.loadMask.hide();
            Lino.notify(action.result.message);
            if (action.result.data_record)
                this.set_current_record(action.result.data_record,after);
            else
                console.log("Warning: no data_record in response to FormPanel.PUT")
            //~ this.refresh_with_after(after);
            //~ if (after) after(); else panel.refresh();
          },
          failure: function(form,action) { 
            this.loadMask.hide();
            Lino.on_submit_failure(form,action)},
          clientValidation: true
        })
      }
    } else Lino.notify("Sorry, no current record.");
  }
  
  ,on_cancel : function() { 
    this.get_containing_window().close();
  }
  ,on_ok : function() { 
      this.save(null,true);
      //~ var rec = this.get_current_record();
      //~ if (rec && rec.phantom)
          //~ this.do_when_clean(true,function() { Lino.close_window(); });
  }
  ,config_containing_window : function(wincfg) { 
      wincfg.keys = [
        { key: Ext.EventObject.ENTER, fn: this.on_ok, scope:this }
        ,{ key: Ext.EventObject.ESCAPE, fn: this.on_cancel, scope:this }
      ]
  }
  
  
  /* not used (no longer possible without .dtl files)
  , edit_detail_config : function () {
    var active_tab = {};
    var main = this.items.get(0);
    if (main.getActiveTab !== undefined) {
      var tabitem = main.getActiveTab();
      Ext.apply(active_tab,{$ext_requests.URL_PARAM_TAB : main.items.indexOf(tabitem)});
    }
    var editor = new Ext.form.TextArea();
    var close = function() { win.close(); }
    var _this = this;
    var save = function() { 
      //~ console.log(20110609,arguments); 
      var params = {desc: editor.getValue()};
      Ext.apply(params,active_tab);
      var a = { 
        params: params, 
        method: 'PUT',
        url: ADMIN_URL + '/detail_config' + _this.ls_url,
        failure : Lino.ajax_error_handler(this),
        success: Lino.action_handler( _this, function(result) {
          //~ console.log('detail_config/save success',result);
          win.close();
          document.location = _this.get_permalink();
        })
      };
      //~ console.log('detail_config/save sent',a);
      _this.loadMask.show(); // 20120211
      Ext.Ajax.request(a);
    }
    var save_btn = new Ext.Button({text:'Save',handler:save,disabled:true});
    var win = new Ext.Window({title:'Detail Layout',
      items:editor, layout:'fit',
      width:500,height:500,
      bbar:[{text:'Cancel',handler:close},save_btn]});
    var a = { 
      params:active_tab, 
      method:'GET',
      url:ADMIN_URL+'/detail_config'+_this.ls_url,
      success : function(response) {
        if (response.responseText) {
          var result = Ext.decode(response.responseText);
          if (result.success) {
            editor.setValue(result.desc);
            save_btn.enable();
          }
        }
      }
    };
    Ext.Ajax.request(a);
    win.show();
  }
  */
});



Lino.getRowClass = function(record, rowIndex, rowParams, store) {
    //~ console.log(20130816,record);
    //~ return 'x-grid3-row-green';
    return record.data.row_class;
  //~ if (true) {
      //~ return 'x-grid3-row-red';
  //~ }
  //~ if (record.phantom) {
    //~ console.log(20101009,record);
    //~ rowParams.bodyStyle = "color:red;background-color:blue";
    //~ return 'lino-phantom-row';
    //~ }
  //~ console.log('20101009 not a phantom:',record);
  //~ return '';
}

//~ FOO = 0;



Lino.GridStore = Ext.extend(Ext.data.ArrayStore,{ 
  autoLoad: false
  ,load: function(options) {
    //~ foo.bar = baz; // 20120213
    if (!options) options = {};
    if (!options.params) options.params = {};
    options.params.fmt = 'json';
    options.params.rp = this.grid_panel.getId();
    Lino.insert_subst_user(options.params); // since 20121016
      
    if (this.grid_panel.hide_top_toolbar) {
        //~ console.log("20120206 GridStore.load() toolbar is hidden");
        options.params.start = 0;
        if (this.grid_panel.preview_limit) {
          options.params.limit = this.grid_panel.preview_limit;
        }
    } else {
        var ps = this.grid_panel.calculatePageSize();
        if (!ps) {
            //~ this.gridpanel.on('render',this.load())
          //~ console.log("20120814 GridStore.load() failed to calculate pagesize");
          return false;
            //~ params.$URL_PARAM_LIMIT = 1;
            //~ this.grid_panel.on('render',this.load.createDelegate(this,options))
            //~ return;
        } 
        options.params.limit = ps;
      
        //~ options.params.start = this.grid_panel.getTopToolbar().cursor;
        //~ if (this.grid_panel.getTopToolbar().pageSize !=  ps) {
          //~ console.log("20120206 abort load because toolbar says pagesize",
            //~ this.grid_panel.getTopToolbar().pageSize,
            //~ "while actual pagesize is",ps);
            //~ return;
        //~ }
        
        this.grid_panel.getTopToolbar().pageSize =  ps;
        if (options.params.start == undefined)
            options.params.start = this.grid_panel.getTopToolbar().cursor;
      
    }
      
    this.grid_panel.add_param_values(options.params,true);
    //~ Lino.insert_subst_user(options.params);
    //~ console.log("20120814 GridStore.load()",options.params,this.baseParams);
    //~ if (FOO > 0) {
        //~ foo.bar = baz;
    //~ } else FOO += 1;
    return Lino.GridStore.superclass.load.call(this,options);
  }
});

    
Lino.GridPanel = Ext.extend(Ext.grid.EditorGridPanel,Lino.MainPanel);
Lino.GridPanel = Ext.extend(Lino.GridPanel,Lino.PanelMixin);
Lino.GridPanel = Ext.extend(Lino.GridPanel,{
  quick_search_text : '',
  is_searching : false,
  disabled_in_insert_window : true,
  clicksToEdit:2,
  enableColLock: false,
  autoHeight: false,
  params_panel_hidden : false,
  preview_limit : undefined, 
  //~ loadMask: true,
  //~ viewConfig: {
          //~ getRowClass: Lino.getRowClass,
          //~ emptyText:"$_('No data to display.')"
        //~ },
  loadMask: {msg:"Bitte warten..."},
  
  constructor : function(config){

    config.plugins = [new Lino.GridFilters()];
    
    
    Lino.GridPanel.superclass.constructor.call(this,config);
    
    //~ if (this.containing_window) {
        //~ console.log("20111206 install refresh");
        //~ this.containing_window.on('show',this.refresh,this);
    //~ }
    
  },
  
  unused_is_loading : function() { 
    if (! this.loadMask.el) return true; // not even rendered: 
    // thanks to Marco Pegoraro http://movableapp.com/2011/09/sencha-touch-loadmask-isvisible/
    var loading = (this.loadMask.el.select('.x-loading-msg').elements.length > 0);
    //~ console.log('20130515 GridPanel.is_loading() returns',loading);
    return loading;
    //~ return this.store.getCount() > 0; 
    //~ return (this.loadMask.el.select('.x-loading-msg').elements.length)
    //~ return !this.viewReady; 
    //~ return this.loadMask.isVisible(); 
    //~ return !this.loadMask.disabled; 
  },
  
  unused_config_containing_window : function(wincfg) { 
      //~ temporarily remove save_grid_config button (see /blog(2012/1107)
      if (wincfg.tools != undefined) 
        wincfg.tools = [
          //~ {handler:this.save_grid_data,
            //~ qtip:"$_("Save Grid Data")",
            //~ scope:this, id:"save_data"}, // 20120814
          {handler:this.save_grid_config,
            qtip:"Tabellenkonfiguration speichern",
            scope:this, id:"save"}
        ].concat(wincfg.tools);
      //~ wincfg.listeners = { show: ... };
  },
  init_containing_window : function(win) { 
    //~ console.log("20111206 install refresh");
    //~ win.on('show',this.refresh,this);
  },
  
  initComponent : function(){
    
    /* 
    Problem 20111206:
    When a GridPanel is the main item of the window, then it doesn't 
    have it's own header but uses the window's header bar.
    We must do this in initComponent because e.g. in beforerender 
    it's already to late: a header element has been created because 
    there was a title.
    But Lino.Window adds itself as `this.containing_window` 
    only after the GridPanel has been initialized.
    Workaround is to generate a line "params.containing_window = true;" 
    in the handler function.
    */ 
    //~ if (this.containing_window) {
    if (this.is_main_window) {
        //~ console.log(20111206, 'delete title',this.title,'from',this);
        //~ delete this.title;
        this.tools = undefined;  
        this.title = undefined;  /* simply deleting it 
          isn't enough because that would only 
          unhide the title defined in some base class. */
    } 
    //~ else console.log(20111206, 'dont delete title',this.title,'from',this);
    
    /* e.g. when slave gridwindow called from a permalink */
    //~ if (this.base_params) Ext.apply(bp,this.base_params);  
    //~ bp['fmt'] = 'json';
    
    //~ function on_proxy_write( proxy, action,data, response,rs,options) {
      //~ console.log('20120814 on_proxy_write',action,data,response)
      //~ this.getStore().doUpdate();
      //~ this.getStore().loadData(data);
    //~ }
    //~ function on_proxy_load( proxy, transactionObject, callbackOptions ) {
      //~ console.log('on_proxy_load',transactionObject)
    //~ }
    var proxy = new Ext.data.HttpProxy({ 
      // 20120814 
      url: '/api' + this.ls_url
      ,method: "GET"
      //~ ,url: ADMIN_URL + '/restful' + this.ls_url
      //~ ,restful: true 
      //~ ,listeners: {load:on_proxy_load} 
      //~ ,listeners: {write:on_proxy_write} 
    });
    //~ config.store = new Ext.data.JsonStore({ 
    //~ this.store = new Ext.data.ArrayStore({ 
    this.store = new Lino.GridStore({ 
      grid_panel: this
      ,listeners: { exception: Lino.on_store_exception }
      ,remoteSort: true
      ,totalProperty: "count"
      ,root: "rows"
      //~ ,id: "id" 
      ,proxy: proxy
      //~ autoLoad: this.containing_window ? true : false
      ,idIndex: this.pk_index
      //~ ,baseParams: bp
      ,fields: this.ls_store_fields
      ,idProperty: this.ls_id_property 
      // 20120814
      //~ ,writer : new Ext.data.JsonWriter({
        //~ writeAllFields: false
        //~ ,listful: true
      //~ })
      //~ ,restful : true
    });
      
    //~ console.log('config.pk_index',config.pk_index,config.store),
    delete this.ls_store_fields;
      
    var this_ = this;
    //~ var grid = this;
    this.store.on('load', function() {
        //~ console.log('20120814 GridStore.on(load)',this_.store);
        //~ var da = this_.store.reader.arrayData.disabled_actions;
        //~ if (da) {
            //~ this.cmenu.cascade(function(item){ 
              //~ console.log(20120531, item.itemId, da[item.itemId]);
              //~ if (da[item.itemId]) item.disable(); else item.enable();
            //~ });
        //~ };
        this_.set_param_values(this_.store.reader.arrayData.param_values);
        //~ this_.set_status(this_.store.reader.arrayData.status);
        //~ 20120918
        this.getView().getRowClass = Lino.getRowClass;
        if (this_.store.reader.arrayData.no_data_text) {
            //~ this.viewConfig.emptyText = this_.store.reader.arrayData.no_data_text;
            this.getView().emptyText = this_.store.reader.arrayData.no_data_text;
            this.getView().refresh();
        }
        if (this_.containing_window)
            this_.set_window_title(this_.store.reader.arrayData.title);
            //~ this_.containing_window.setTitle(this_.store.reader.arrayData.title);
        if (!this.is_searching) { // disabled 20121025: quick_search_field may not lose focus
          this.is_searching = false;
          if (this_.selModel.getSelectedCell){
              if (this_.getStore().getCount()) // there may be no data
                  this_.selModel.select(0,0); 
          } else {
              this_.selModel.selectFirstRow();
              this_.getView().focusEl.focus();
          }
        } 
        //~ else console.log("is_searching -> no focussing");
        //~ var t = this.getTopToolbar();
        //~ var activePage = Math.ceil((t.cursor + t.pageSize) / t.pageSize);
        //~ this.quick_search_field.focus(); // 20121024
      }, this
    );
    var actions = Lino.build_buttons(this,this.ls_bbar_actions);
    //~ Ext.apply(config,Lino.build_buttons(this,config.ls_bbar_actions));
    //~ config.bbar, this.cmenu = Lino.build_buttons(this,config.ls_bbar_actions);
    //~ this.cmenu = new Ext.menu.Menu({items: config.bbar});
    delete this.ls_bbar_actions
    if (actions) {
        this.cmenu = actions.cmenu;
    }
    
    if (!this.hide_top_toolbar) {  
      var tbar = [ 
        this.quick_search_field = new Ext.form.TextField({ 
          //~ fieldLabel: "Search"
          listeners: { 
            scope:this_
            //~ ,change:this_.search_change
            
            ,render: Lino.quicktip_renderer("Schnellsuche","Hier Text eingeben für Schnellsuche.")
            
            //~ ,keypress: this.search_keypress 
            ,blur: function() { this.is_searching = false}
          }
          ,validator:function(value) { return this_.search_validate(value) }
          //~ ,tooltip: "Enter a quick search text, then press TAB"
          //~ value: text
          //~ scope:this, 
          //~ ,enableKeyEvents: true
          //~ listeners: { keypress: this.search_keypress }, 
          //~ id: "seachString" 
      })];
      tbar = this.add_params_panel(tbar);
      tbar = tbar.concat([
        { scope:this, 
          //~ text: "[csv]", 
          tooltip: "Diese Tabelle in eine .csv-Datei exportieren", 
          iconCls: 'x-tbar-csv',
          handler: function() { 
            //~ 20130116 var p = Ext.apply({},this.get_base_params());
            //~ 20130116 p.fmt = 'csv';
            //~ url += "?" + Ext.urlEncode(p);
            var p = this.get_current_grid_config();
            Ext.apply(p,this.get_base_params());
            p.fmt = "csv";
            this.add_param_values(p,true);
            
            window.open('/api'+this.ls_url + "?" + Ext.urlEncode(p)) 
          } },
        //~ { scope:this, 
          //~ text: "[html]", 
          //~ handler: function() { 
            //~ var p = this.get_current_grid_config();
            //~ Ext.apply(p,this.get_base_params());
            //~ p.$ext_requests.URL_PARAM_FORMAT = "$ext_requests.URL_FORMAT_PRINTER";
            //~ this.add_param_values(p);
            //~ window.open(ADMIN_URL+'/api'+this.ls_url + "?" + Ext.urlEncode(p)) 
          //~ } },
        { scope:this, 
          //~ text: "[html]", 
          tooltip: "Tabelle als HTML anzeigen", 
          iconCls: 'x-tbar-html',
          handler: function() { 
            var p = this.get_current_grid_config();
            Ext.apply(p,this.get_base_params());
            //~ since 20121226 p.$ext_requests.URL_PARAM_FORMAT = "$ext_requests.URL_FORMAT_PLAIN";
            this.add_param_values(p,true);
            //~ since 20121226 window.open(ADMIN_URL+'/api'+this.ls_url + "?" + Ext.urlEncode(p)) 
            window.open('/plain'+this.ls_url + "?" + Ext.urlEncode(p)) 
          } }
        
        ,{ scope:this, 
          //~ text: "[pdf]", 
          tooltip: "Diese Tabelle in eine .pdf-Datei exportieren", 
          iconCls: 'x-tbar-pdf',
          handler: function() { 
            var p = this.get_current_grid_config();
            Ext.apply(p,this.get_base_params());
            p.fmt = "pdf";
            this.add_param_values(p,true);
            window.open('/api'+this.ls_url + "?" + Ext.urlEncode(p)) 
          } }
        
      ]);
    
    
      var menu = [];
      var set_gc = function(index) {
        return function() {
          //~ console.log('set_gc() 20100812');
          this.getColumnModel().setConfig(
              this.apply_grid_config(index,this.ls_grid_configs,this.ls_columns));
        }
      }
      for (var i = 0; i < this.ls_grid_configs.length;i++) {
        var gc = this.ls_grid_configs[i];
        menu.push({text:gc.label,handler:set_gc(i),scope:this})
      }
      if(menu.length > 1) {
        tbar = tbar.concat([
          { text:"Ansicht",
            menu: menu,
            tooltip:"Andere Ansicht auswählen"
          }
        ]);
      }
      
      if (actions) {
        tbar = tbar.concat(actions.bbar);
          //~ this.bbar = actions.bbar;
      }
      
      this.tbar = new Ext.PagingToolbar({ 
        store: this.store, 
        prependButtons: true, 
        //~ pageSize: this.page_length, 
        pageSize: 1, 
        displayInfo: true, 
        beforePageText: "Seite",
        afterPageText: "von {0}",
        displayMsg: "Zeilen {0} bis {1} von {2}",
        firstText: "Erste Seite",
        lastText: "Letzte Seite",
        prevText: "Vorige Seite",
        nextText: "Nächste Seite",
        items: tbar
      });
      //~ this.on('resize', function(cmp,aw,ah,rw,rh) {
          //~ var ps = this.calculatePageSize();
          //~ if (ps && ps != this.getTopToolbar().pageSize) {
              //~ // console.log('20120203 resize : pageSize',this.getTopToolbar().pageSize,'->',ps);
              //~ // this.getTopToolbar().pageSize =  ps;
              //~ cmp.refresh();
              //~ // this.getTopToolbar().doRefresh();
          //~ }
        //~ }, this);
      //~ this.on('resize', function(cmp,aw,ah,rw,rh) {
          //~ cmp.getTopToolbar().pageSize = this.calculatePageSize(aw,ah,rw,rh) || 10;
          //~ cmp.refresh();
        //~ }, this, {delay:500});
    }
    
    //~ delete this.page_length
    
    
      
    if (this.ls_quick_edit) {
      this.selModel = new Ext.grid.CellSelectionModel()
      this.get_selected = function() {
        //~ console.log(this.getSelectionModel().selection);
        if (this.selModel.selection)
            return [ this.selModel.selection.record ];
        return [this.store.getAt(0)];
      };
      this.get_current_record = function() { 
        if (this.getSelectionModel().selection) 
          return this.selModel.selection.record;
        return this.store.getAt(0);
      };
    } else { 
      this.selModel = new Ext.grid.RowSelectionModel() 
      this.get_selected = function() {
        var sels = this.selModel.getSelections();
        if (sels.length == 0) sels = [this.store.getAt(0)];
        return sels
        //~ var sels = this.getSelectionModel().getSelections();
        //~ return Ext.pluck(sels,'id');
      };
      this.get_current_record = function() { 
        var rec = this.selModel.getSelected();
        if (rec == undefined) rec = this.store.getAt(0);
        return rec
      };
    };
    delete this.ls_quick_edit;
    
    this.columns  = this.apply_grid_config(this.gc_name,this.ls_grid_configs,this.ls_columns);
    
    //~ var grid = this;
    //~ this.colModel = new Ext.grid.ColumnModel({
      //~ columns: this.apply_grid_config(this.gc_name,this.ls_grid_configs,this.ls_columns),
      //~ isCellEditable: function(col, row) {
        //~ var record = grid.store.getAt(row);
        //~ console.log('20120514',col,record); // dataIndex
        //~ var dataIndex = grid.colModel.getDataIndex(col);
        //~ if (dataIndex in record.data['disabled_fields']) {
            //~ Lino.notify("$_("This field is disabled")");
            //~ return false;
        //~ }
        //~ return Ext.grid.ColumnModel.prototype.isCellEditable.call(this, col, row);
      //~ }
    //~ });    
    
    
    Lino.GridPanel.superclass.initComponent.call(this);
    
    //~ if (this.containing_window) 
        //~ this.on('afterlayout', this.refresh, this);
        //~ this.on('afterrender', this.refresh,this);
    //~ else
        //~ this.on('show', this.refresh,this);
    //~ this.on('afterlayout', function() {
      //~ if (this.id == "ext-comp-1157") 
        //~ console.log("20120213 afterlayout",this); 
      //~ // this.refresh();
      //~ },this);
    //~ this.on('afterrender', this.refresh);
    //~ this.on('resize', this.refresh,this,{delay:500});
    //~ this.on('resize', function(){console.log("20120213 resize",arguments)},this);
    this.on('resize', function(){
      //~ console.log("20120213 resize",arguments)
      this.refresh();
      },this);
    this.on('viewready', function(){
      //~ console.log("20120213 resize",arguments);
      this.view_is_ready = true;
      this.refresh();
      },this);
    this.on('afteredit', this.on_afteredit); // 20120814
    //~ this.on('afteredit', this.new_on_afteredit);
    this.on('beforeedit', this.on_beforeedit);
    this.on('beforeedit',function(e) { this.before_row_edit(e.record)},this);
    this.on('cellcontextmenu', Lino.cell_context_menu, this);
    //~ this.on('contextmenu', Lino.grid_context_menu, this);
    
    
    //~ if (this.id == "ext-comp-1157") captureEvents(this);    
    
  },
  
  //~ onResize : function(){
      //~ console.log("20120206 GridPanel.onResize",arguments);
      //~ Lino.GridPanel.superclass.onResize.apply(this, arguments);
      //~ this.refresh();
  //~ },
  
  
  get_status : function(){
    var st = { base_params : this.get_base_params()};
    if (!this.hide_top_toolbar) {
        st.current_page = this.getTopToolbar().current;
    }
    st.param_values = this.status_param_values;
    //~ console.log("20120213 GridPanel.get_status",st);
    return st;
  },
  
  /* 
  Lino.GridPanel.set_status() 
  */
  set_status : function(status){
    //~ console.log("20130605 GridPanel.set_status",status);
    this.clear_base_params();
    if (status == undefined) status = {};
    this.set_param_values(status.param_values);
    if (status.base_params) { 
      this.set_base_params(status.base_params);
    }
    if (status.show_params_panel != undefined) {
        if (this.toggle_params_panel_btn) {
            //~ this.toggle_params_panel_btn.toggle(status.show_params_panel=='true');
            this.toggle_params_panel_btn.toggle(status.show_params_panel);
        }
    }
    if (!this.hide_top_toolbar) {
      //~ console.log("20120213 GridPanel.getTopToolbar().changePage",
          //~ status.current_page || 1);
      this.getTopToolbar().changePage(status.current_page || 1);
    }
    //~ this.fireEvent('resize');
    //~ this.refresh.defer(100,this); 
    //~ this.onResize.defer(100,this); 
    //~ this.refresh(); 
    //~ this.doLayout(); 
    //~ this.onResize(); 
    //~ this.store.load();
  },
  
  refresh : function(unused) { 
    this.refresh_with_after();
  },
  refresh_with_after : function(after) { 
    //~ Lino.notify('20120204 Lino.GridPanel.refresh');
    //~ Lino.notify('Lino.GridPanel.refresh '+this.store.proxy.url);
    //~ var bp = { fmt:'json' }
    if (this.containing_panel) {
        //~ Ext.apply(p,this.master_panel.get_master_params());
        //~ Ext.apply(options.params,this.containing_panel.get_master_params());
        this.set_base_params(this.containing_panel.get_master_params());
    }
    
    if (! this.view_is_ready) return;
    
    var options = {};
    if (after) {
        options.callback = function(r,options,success) {if(success) after()}
    }
      
    //~ if (!this.rendered) {
        //~ console.log("20120206 GridPanel.refresh() must wait until rendered",options);
        //~ this.grid_panel.on('render',this.load.createDelegate(this,options))
        //~ return;
    //~ }
    
    this.store.load(options);
  },
  
  /* pageSize depends on grid height (Trying to remove scrollbar)
  Thanks to 
  - Christophe Badoit on http://www.sencha.com/forum/showthread.php?82647
  - http://www.sencha.com/forum/archive/index.php/t-37231.html
  */
  calculatePageSize : function(second_attempt) {
    //~ if (!this.rendered) { 
    if (!this.view_is_ready) { 
      //~ console.log('Cannot calculatePageSize() : not rendered');
      return false; }
    //~ if (!this.isVisible()) { 
      //~ console.log('calculatePageSize : not visible');
      //~ return false; }
      
    //~ console.log('getFrameHeight() is',this.getFrameHeight());
    //~ console.log('getView().scroller.getHeight() is',this.getView().scroller.getHeight());
    //~ console.log('mainBody.getHeight() is',this.getView().mainBody.getHeight());
    //~ console.log('getInnerHeight() is',this.getInnerHeight());
    //~ console.log('getHeight() is',this.getHeight());
    //~ console.log('el.getHeight() is',this.getEl().getHeight());
    //~ console.log('getGridEl().getHeight() is',this.getGridEl().getHeight());
    //~ console.log('getOuterSize().height is',this.getOuterSize().height);
    //~ console.log('getBox().height is',this.getBox().height);
    //~ console.log('getResizeEl.getHeight() is',this.getResizeEl().getHeight());
    //~ console.log('getLayoutTarget().getHeight() is',this.getLayoutTarget().getHeight());
      
    //~ var rowHeight = 52; // experimental value
    var row = this.view.getRow(0);
    if (row) {
      //~ console.log('20120213 yes');
      var rowHeight = Ext.get(row).getHeight();
    } else {
        //~ var rowHeight = this.getFrameHeight();
        //~ var rowHeight = 10; // reasonably smallest approximative value
        //~ There is no data yet. Construct a fake row and get its height
        var Element = Ext.Element;
        var gv = this.view;
        var fakeBody = new Element(Element.fly(gv.scroller).child('div.x-grid3-body'));
        var rowTemplate = gv.templates.row;
        var cellTemplate = gv.templates.cell;
        var tstyle  = 'width:' + gv.getGridInnerWidth() + 'px;';
        var cells = cellTemplate.apply({value:'&#160;'});
        var markup = rowTemplate.apply({
                tstyle: tstyle,
                cols  : 1,
                cells : cells,
                alt   : ''
            });        
        fakeBody.dom.innerHTML = gv.templates.body.apply({rows: markup});
        var row = fakeBody.dom.childNodes[0];
        var rowHeight = Ext.get(row).getHeight();
    }
    //~ console.log('rowHeight is ',rowHeight,this,caller);
    //~ this.getView().syncScroll();
    //~ this.getView().initTemplates();
    var height = this.getView().scroller.getHeight();
    //~ console.log('getView().scroller.getHeight() is',this.getView().scroller.getHeight());
    //~ console.log('getInnerHeight() - getFrameHeight() is',
      //~ this.getInnerHeight(), '-',
      //~ this.getFrameHeight(), '=',
      //~ this.getInnerHeight() - this.getFrameHeight());
    //~ var height = this.getView().mainBody.getHeight();
    //~ var height = this.getView().mainWrap.getHeight();
    //~ var height = this.getView().resizeMarker.getHeight();
    //~ this.syncSize();
    //~ var height = this.getInnerHeight() - this.getFrameHeight();
    //~ var height = this.getHeight() - this.getFrameHeight();
    height -= Ext.getScrollBarWidth(); // leave room for a possible horizontal scrollbar... 
    //~ height -= this.getView().scrollOffset;
    var ps = Math.floor(height / rowHeight);
    //~ console.log('20130816 calculatePageSize():',height,'/',rowHeight,'->',ps);
    ps -= 1; // leave room for a possible phantom row
    //~ return (ps > 1 ? ps : false);
    if (ps > 1) return ps;
    //~ console.log('calculatePageSize() found less than 1 row:',height,'/',rowHeight,'->',ps);
    //~ foo.bar = baz; // 20120213
    return 5; // preview_limit
    //~ if (second_attempt) {
        //~ console.log('calculatePageSize() abandons after second attempt:',
          //~ height,'/',rowHeight,'->',ps);
      //~ return 5;
    //~ }
    //~ return this.calculatePageSize.defer(500,this,[true]);
  },
  
  onCellDblClick : function(grid, row, col){
      //~ console.log("20120307 onCellDblClick",this,grid, row, col);
      if (this.ls_detail_handler) {
          //~ Lino.notify('show detail');
          Lino.show_detail(this);
          return false;
      }else{
        //~ console.log('startEditing');
        this.startEditing(row,col);
      }
  },
  
  get_base_params : function() {
    //~ return this.containing_window.config.base_params;
    //~ console.log(20120717,this.store.baseParams);
    var p = Ext.apply({},this.store.baseParams);
    Lino.insert_subst_user(p);
    //~ console.log("20120717 GRidPanel.get_base_params() returns",p);
    return p;
    //~ return this.store.baseParams;
  },
  set_base_params : function(p) {
    //~ console.log('GridPanel.set_base_params',p)
    for (k in p) this.store.setBaseParam(k,p[k]);
    //~ this.store.baseParams = p;
    if (p.query) 
        this.quick_search_field.setValue(p.query);
    //~ if (p.param_values) 
        //~ this.set_param_values(p.param_values);  
  },
  clear_base_params : function() {
      this.store.baseParams = {};
      Lino.insert_subst_user(this.store.baseParams);
  },
  set_base_param : function(k,v) {
    this.store.setBaseParam(k,v);
  },
  
  //~ get_permalink_params : function() {
    //~ var p = {};
    //~ return p;
  //~ },
  
  before_row_edit : function(record) {},
    
  //~ search_keypress : function(){
    //~ console.log("2012124 search_keypress",arguments);
  //~ },
  search_validate : function(value) {
    if (value == this.quick_search_text) return true;
    this.is_searching = true;
    //~ console.log('search_validate',value)
    this.quick_search_text = value;
    this.set_base_param('query',value); 
    //~ this.getTopToolbar().changePage(1);
    this.getTopToolbar().moveFirst();
    //~ this.refresh();
    return true;
  },
  
  search_change : function(field,oldValue,newValue) {
    //~ console.log('search_change',field.getValue(),oldValue,newValue)
    this.set_base_param('query',field.getValue()); 
    this.getTopToolbar().moveFirst();
    //~ this.refresh();
  },
  
  apply_grid_config : function(index,grid_configs,rpt_columns) {
    //~ var rpt_columns = this.ls_columns;
    var gc = grid_configs[index];    
    //~ console.log('apply_grid_config() 20100812',name,gc);
    this.gc_name = index;
    if (gc == undefined) {
      return rpt_columns;
      //~ config.columns = config.ls_columns;
      //~ return;
    } 
    //~ delete config.ls_filters
    
    //~ console.log(20100805,config.ls_columns);
    var columns = Array(gc.columns.length);
    for (var j = 0; j < rpt_columns.length;j++) {
      var col = rpt_columns[j];
      for (var i = 0; i < gc.columns.length; i++) {
        if (col.dataIndex == gc.ci[i]) {
          col.width = gc.cw[i];
          col.hidden = gc.ch[i];
          columns[i] = col;
          break;
        }
      }
    }
    
    //~ var columns = Array(rpt_columns.length);
    //~ for (var i = 0; i < rpt_columns.length; i++) {
      //~ columns[i] = rpt_columns[gc.columns[i]];
      //~ columns[i].width = gc.widths[i];
    //~ }
    
    //~ if (gc.hidden_cols) {
      //~ for (var i = 0; i < gc.hidden_cols.length; i++) {
        //~ var hc = gc.hidden_cols[i];
        //~ for (var j = 0; j < columns.length;j++) {
          //~ var col = columns[j];
          //~ if (col.dataIndex == hc) {
            //~ col.hidden = true;
            //~ break
          //~ }
        //~ }
      //~ }
    //~ }
    if (gc.filters) {
      //~ console.log(20100811,'config.ls_filters',config.ls_filters);
      //~ console.log(20100811,'config.ls_grid_config.filters',config.ls_grid_config.filters);
      for (var i = 0; i < gc.filters.length; i++) {
        var fv = gc.filters[i];
        for (var j = 0; j < columns.length;j++) {
          var col = columns[j];
          if (col.dataIndex == fv.field) {
            //~ console.log(20100811, f,' == ',fv);
            if (fv.type == 'string') {
              col.filter.value = fv.value;
              //~ if (fv.comparison !== undefined) f.comparison = fv.comparison;
            } else {
              //~ console.log(20100811, fv);
              col.filter.value = {};
              col.filter.value[fv.comparison] = fv.value;
            }
            break;
          }
        };
      }
    }
    
    return columns;
    //~ config.columns = cols;
    //~ delete config.ls_columns
  },
  
  get_current_grid_config : function () {
    var cm = this.getColumnModel();
    var widths = Array(cm.config.length);
    var hiddens = Array(cm.config.length);
    //~ var hiddens = Array(cm.config.length);
    var columns = Array(cm.config.length);
    //~ var columns = Array(cm.config.length);
    //~ var hidden_cols = [];
    //~ var filters = this.filters.getFilterValues();
    var p = this.filters.buildQuery(this.filters.getFilterData())
    for (var i = 0; i < cm.config.length; i++) {
      var col = cm.config[i];
      columns[i] = col.dataIndex;
      //~ hiddens[i] = col.hidden;
      widths[i] = col.width;
      hiddens[i] = col.hidden;
      //~ if (col.hidden) hidden_cols.push(col.dataIndex);
    }
    //~ p['hidden_cols'] = hidden_cols;
    p.cw = widths;
    p.ch = hiddens;
    p.ci = columns;
    //~ p['widths'] = widths;
    //~ p['hiddens'] = hiddens;
    //~ p['columns'] = columns;
    p['name'] = this.gc_name;
    //~ var gc = this.ls_grid_configs[this.gc_name];
    //~ if (gc !== undefined) 
        //~ p['label'] = gc.label
    //~ console.log('20100810 save_grid_config',p);
    return p;
  },
  
  unused_manage_grid_configs : function() {
    var data = [];
    for (k in this.ls_grid_configs) {
      var v = this.ls_grid_configs[k];
      var i = [k,String(v.columns),String(v.hidden_cols),String(v.filters)];
      data.push(i)
    }
    if (this.ls_grid_configs[this.gc_name] == undefined) {
      var v = this.get_current_grid_config();
      var i = [k,String(v.columns),String(v.hidden_cols),String(v.filters)];
      data.push(i);
    }
    //~ console.log(20100811, data);
    var main = new Ext.grid.GridPanel({
      store: new Ext.data.ArrayStore({
        idIndex:0,
        fields:['name','columns','hidden_cols','filters'],
        autoDestroy:true,
        data: data}),
      //~ autoHeight:true,
      selModel: new Ext.grid.RowSelectionModel(),
      listeners: { 
        rowdblclick: function(grid,rowIndex,e) {
          console.log('row doubleclicked',grid, rowIndex,e);
        },
        rowclick: function(grid,rowIndex,e) {
          console.log('row clicked',grid, rowIndex,e);
        }
      },
      columns: [ 
        {dataIndex:'name',header:'Name'}, 
        {dataIndex:'columns',header:'columns'}, 
        {dataIndex:'hidden_cols',header:'hidden columns'}, 
        {dataIndex:'filters',header:'filters'} 
      ]
    });
    var win = new Ext.Window({title:'GridConfigs Manager',layout:'fit',items:main,height:200});
    win.show();
  },
  
  unused_edit_grid_config : function(name) {
    gc = this.ls_grid_configs[name];
    var win = new Ext.Window({
      title:'Edit Grid Config',layout:'vbox', 
      //~ layoutConfig:'stretch'
      items:[
        {xtype:'text', value: gc.name},
        {xtype:'text', value: gc.columns},
        {xtype:'text', value: gc.hidden_cols},
        {xtype:'text', value: gc.filters}
      ]
    });
    win.show();
  },
  
  save_grid_config : function () {
    //~ console.log('TODO: save_grid_config',this);
    //~ p.column_widths = Ext.pluck(this.colModel.columns,'width');
    var a = { 
      params:this.get_current_grid_config(), 
      method:'PUT',
      url:'/grid_config' + this.ls_url,
      success: Lino.action_handler(this),
      scope: this,
      failure: Lino.ajax_error_handler(this)
    };
    this.loadMask.show(); // 20120211
    Ext.Ajax.request(a);
    //~ Lino.do_action(this,a);
  },
  
  on_beforeedit : function(e) {
    //~ console.log('20130128 GridPanel.on_beforeedit()',e,e.record.data.disable_editing);
    if(this.disable_editing | e.record.data.disable_editing) {
      e.cancel = true;
      Lino.notify("Dieser Datensatz ist deaktiviert");
      return;
    }
    if(e.record.data.disabled_fields && e.record.data.disabled_fields[e.field]) {
      e.cancel = true;
      Lino.notify("Dieses Feld ist deaktiviert");
      return;
    }
    //~ if (e.record.data.disabled_fields) {
      //~ for (i in e.record.data.disabled_fields) {
        //~ if(e.record.data.disabled_fields[i] == e.field) {
          //~ e.cancel = true;
          //~ Lino.notify(String.format('Field "{0}" is disabled for this record',e.field));
          //~ return
        //~ }
      //~ }
    //~ }
  },
  save_grid_data : function() {
      //~ console.log("20120814 save_grid_data");
      this.getStore().commitChanges();
  },
  new_on_afteredit : function(e) {
      //~ this.getStore().commitChanges();
      //~ this.getStore().doUpdate();
      //~ this.getStore().loadData(data);
      console.log("20120814 new_on_afteredit",e);
  },
  on_afteredit : function(e) {
    /*
    e.grid - The grid that fired the event
    e.record - The record being edited
    e.field - The field name being edited
    e.value - The value being set
    e.originalValue - The original value for the field, before the edit.
    e.row - The grid row index
    e.column - The grid column index
    */
    var p = {};
    //~ console.log('20101130 modified: ',e.record.modified);
    //~ console.log('20101130 value: ',e.value);
    //~ var p = e.record.getChanges();
    //~ console.log('20101130 getChanges: ',e.record.getChanges());
    //~ this.before_row_edit(e.record);
    for(k in e.record.getChanges()) {
        var v = e.record.get(k);
    //~ for(k in e.record.modified) {
        //~ console.log('20101130',k,'=',v);
        //~ var cm = e.grid.getColumnModel();
        //~ var di = cm.getDataIndex(k);
        var f = e.record.fields.get(k);
        //~ console.log('20101130 f = ',f);
        //~ var v = e.record.get(di);
        if (f.type.type == 'date') {
            p[k] = Ext.util.Format.date(v, f.dateFormat);
        }else{
            p[k] = v;
            var v = e.record.get(k+'Hidden');
            if (v !== undefined) {
              p[k+'Hidden'] = v;
            }
        }
        //~ var i = cm.findColumnIndex(k);
        //~ var r = cm.getRenderer(i);
        //~ var editor = cm.getCellEditor(i,e.row);
        //~ var col = e.grid.getColumnModel().getColumnById(k);
        //~ console.log('20101130 r = ',r(v));
        //~ var f = e.record.fields[k];
        //~ console.log('20101130 f = ',f);
        //~ console.log('20101130 editor = ',editor);
        //~ p[k] = f.getValue();
        //~ p[k] = r(v);
    }
    //~ console.log('20101130 p:',p);
    //~ var cm = e.grid.getColumnModel();
    //~ var di = cm.getDataIndex(e.column);
    //~ var f = e.record.fields.get(di);
    //~ console.log('20101130 f = ',f);
    //~ if (f.type.type == 'date') e.record.set(di,Ext.util.Format.date(e.value, f.dateFormat));
    
    
    //~ var p = e.record.data;
    
    // var p = {};
    //~ p['grid_afteredit_colname'] = e.field;
    //~ p[e.field] = e.value;
    //~ console.log('20100723 GridPanel.on_afteredit()',e);
    // add value used by ForeignKeyStoreField CHOICES_HIDDEN_SUFFIX
    // not sure whether this is still needed:
    p[e.field+'Hidden'] = e.value;
    //~ p.su = Lino.subst_user;
    Lino.insert_subst_user(p);
    // this one is needed so that this field can serve as choice context:
    e.record.data[e.field+'Hidden'] = e.value;
    // p[pk] = e.record.data[pk];
    // console.log("grid_afteredit:",e.field,'=',e.value);
    Ext.apply(p,this.get_base_params()); // needed for POST, ignored for PUT
    //~ Ext.apply(p,this.containing_window.config.base_params);
    //~ 20121109 p['$ext_requests.URL_PARAM_ACTION_NAME'] = 'grid';
    var self = this;
    var req = {
        params:p,
        waitMsg: 'Saving your data...',
        success: Lino.action_handler( this, function(result) {
          //~ if (result.data_record) {
          if (result.refresh_all) {
              var cw = self.get_containing_window();
              if (cw) {
                  cw.main_item.refresh();
              }
              else console.log("20120123 cannot refresh_all",self);
          } else if (result.rows) {
              //~ self.getStore().loadData(result,true);
              var r = self.getStore().reader.readRecords(result);
              if (e.record.phantom) {
                  //~ console.log("20120816 afteredit.success POST",r);
                  self.getStore().insert(e.row,r.records);
              }else{
                  //~ console.log("20120816 afteredit.success PUT",r);
                  self.getStore().doUpdate(r.records[0]);
              }
              self.getStore().rejectChanges(); /* 
              get rid of the red triangles without saving the record again
              */
              //~ self.getStore().commitChanges(); // get rid of the red triangles
          } else {
              self.getStore().commitChanges(); // get rid of the red triangles
              self.getStore().reload();        // reload our datastore.
          }
          }),
        scope: this,
        failure: Lino.ajax_error_handler(this)
    };
    if (e.record.phantom) {
      req.params.an = 'post'; // SubmitInsert.action_name
      Ext.apply(req,{
        method: 'POST',
        url: '/api' + this.ls_url
      });
    } else {
      req.params.an = 'put'; // SubmitDetail.action_name
      Ext.apply(req,{
        method: 'PUT',
        url: '/api' + this.ls_url + '/' + e.record.id
      });
    }
    //~ console.log('20110406 on_afteredit',req);
    this.loadMask.show(); // 20120211
    Ext.Ajax.request(req);
  },

  afterRender : function() {
    Lino.GridPanel.superclass.afterRender.call(this);
    // this.getView().mainBody.focus();
    // console.log(20100114,this.getView().getRows());
    // if (this.getView().getRows().length > 0) {
    //  this.getView().focusRow(1);
    // }
    //~ this.my_load_mask = new Ext.LoadMask(this.getEl(), {
        //~ msg:'$_("Please wait...")',
        //~ store:this.store});
      
    var tbar = this.getTopToolbar();
    // tbar.on('change',function() {this.getView().focusRow(1);},this);
    // tbar.on('change',function() {this.getSelectionModel().selectFirstRow();this.getView().mainBody.focus();},this);
    // tbar.on('change',function() {this.getView().mainBody.focus();},this);
    // tbar.on('change',function() {this.getView().focusRow(1);},this);
    this.nav = new Ext.KeyNav(this.getEl(),{
      pageUp: function() {tbar.movePrevious(); },
      pageDown: function() {tbar.moveNext(); },
      home: function() {tbar.moveFirst(); },
      end: function() {tbar.moveLast(); },
      scope: this
    });
  },
  after_delete : function() {
    //~ console.log('Lino.GridPanel.after_delete');
    this.refresh();
  },
  add_row_listener : function(fn,scope) {
    this.getSelectionModel().addListener('rowselect',fn,scope);
  },
  postEditValue : function(value, originalValue, r, field){
    value = Lino.GridPanel.superclass.postEditValue.call(this,value,originalValue,r,field);
    //~ console.log('GridPanel.postEdit()',value, originalValue, r, field);
    return value;
  },
  
  set_start_value : function(v) {
      this.start_value = v;
  },
  preEditValue : function(r, field){
      if (this.start_value) {
        var v = this.start_value;
        delete this.start_value;
        this.activeEditor.selectOnFocus = false;
        return v;
      }
      var value = r.data[field];
      return this.autoEncode && Ext.isString(value) ? Ext.util.Format.htmlDecode(value) : value;
  },
  
  on_master_changed : function() {
    //~ if (! this.enabled) return;
    //~ cmp = this;
    //~ console.log('Lino.GridPanel.on_master_changed()',this.title);
    if (! this.rendered) return; // 20120213
    var todo = function() {
      if (this.disabled) return;
      //~ if (this.disabled) return;
      //~ if (this.enabled) {
          //~ var src = caller.config.url_data + "/" + record.id + ".jpg"
          //~ console.log(20111125, this.containing_window);
          //~ for (k in p) this.getStore().setBaseParam(k,p[k]);
          //~ console.log('Lino.GridPanel.on_master_changed()',this.title,p);
          this.refresh();
          //~ this.set_base_params(this.master_panel.get_master_params());
          //~ this.getStore().load(); 
      //~ }
    };
    Lino.do_when_visible(this,todo.createDelegate(this));
  },
  load_record_id : function(record_id,after) {
      Lino.run_detail_handler(this,record_id)
  }
  
});
  

//~ Lino.MainPanelMixin = {
  //~ tbar_items : function() {
      //~ return ;
  //~ }
//~ };

//~ Ext.override(Lino.GridPanel,Lino.MainPanelMixin);
//~ Ext.override(Lino.FormPanel,Lino.MainPanelMixin);

//~ Lino.grid_context_menu = function(e) {
  //~ console.log('contextmenu',arguments);
//~ }

Lino.cell_context_menu = function(grid,row,col,e) {
  //~ console.log('20120531 cellcontextmenu',grid,row,col,e,grid.store.reader.arrayData.rows[row]);
  e.stopEvent();
  //~ grid.getView().focusCell(row,col);
  grid.getSelectionModel().select(row,col);
  //~ console.log(grid.store.getAt(row));
  //~ grid.getView().focusRow(row);
  //~ return;
  if(!grid.cmenu.el){grid.cmenu.render(); }
  //~ if(e.record.data.disabled_fields) {
  
  var da = grid.store.reader.arrayData.rows[row][grid.disabled_actions_index];
  if (da) {
      this.cmenu.cascade(function(item){ 
        //~ console.log(20120531, item.itemId, da[item.itemId]);
        if (da[item.itemId]) item.disable(); else item.enable();
      });
  };
  
  var xy = e.getXY();
  xy[1] -= grid.cmenu.el.getHeight();
  grid.cmenu.showAt(xy);
}


//~ Lino.load_main_menu = function() {
  //~ Ext.Ajax.request({
    //~ waitMsg: 'Loading main menu...',
    //~ method: 'GET',
    //~ url: '/menu',
    //~ success: Lino.on_load_menu,
    //~ failure: Lino.ajax_error_handler
  //~ });
//~ };



//~ Lino.SlavePlugin = function(caller) {
  //~ this.caller = caller;
//~ };

Lino.chooser_handler = function(combo,name) {
  return function(cmp,newValue,oldValue) {
    //~ console.log('Lino.chooser_handler()',cmp,oldValue,newValue);
    combo.setContextValue(name,newValue);
  }
};



Lino.ComboBox = Ext.extend(Ext.form.ComboBox,{
  forceSelection: true,
  triggerAction: 'all',
  minListWidth:230,
  autoSelect: false,
  selectOnFocus: true, // select any existing text in the field immediately on focus.
  submitValue: true,
  displayField: 'text', // 'text', 
  valueField: 'value', // 'value',
  
  //~ initComponent : Ext.form.ComboBox.prototype.initComponent.createSequence(function() {
  initComponent : function(){
      this.contextParams = {};
      //~ Ext.form.ComboBox.initComponent(this);
      Lino.ComboBox.superclass.initComponent.call(this);
  },
  setValue : function(v,record_data){
      /*
      Based on feature request developed in http://extjs.net/forum/showthread.php?t=75751
      */
      /* `record_data` is used to get the text corresponding to this value */
      //~ if(this.name == 'city') 
      //~ console.log('20120203', this.name,'.setValue(', v ,') this=', this,'record_data=',record_data);
      var text = v;
      if(this.valueField){
        if(v == null || v == '') { 
            //~ if (this.name == 'birth_country') 
                //~ console.log(this.name,'.setValue',v,'no lookup needed, value is empty');
            //~ v = undefined;
            v = '';
            //~ text = '';
        } else if (Ext.isDefined(record_data)) {
          text = record_data[this.name];
          //~ if (this.name == 'birth_country') 
            //~ console.log(this.name,'.setValue',v,'got text ',text,' from record ',record);
        } else {
          // if(this.mode == 'remote' && !Ext.isDefined(this.store.totalLength)){
          if(this.mode == 'remote' && ( this.lastQuery === null || (!Ext.isDefined(this.store.totalLength)))){
              //~ if (this.name == 'birth_country') console.log(this.name,'.setValue',v,'store not yet loaded');
              this.store.on('load', this.setValue.createDelegate(this, arguments), null, {single: true});
              if(this.store.lastOptions === null || this.lastQuery === null){
                  var params;
                  if(this.valueParam){
                      params = {};
                      params[this.valueParam] = v;
                  }else{
                      var q = this.allQuery;
                      this.lastQuery = q;
                      this.store.setBaseParam(this.queryParam, q);
                      params = this.getParams(q);
                  }
                  //~ if (this.name == 'birth_country') 
                    //~ console.log(this.name,'.setValue',v,' : call load() with params ',params);
                  this.store.load({params: params});
              //~ }else{
                  //~ if (this.name == 'birth_country') 
                    //~ console.log(this.name,'.setValue',v,' : but store is loading',this.store.lastOptions);
              }
              return;
          //~ }else{
              //~ if (this.name == 'birth_country') 
                //~ console.log(this.name,'.setValue',v,' : store is loaded, lastQuery is "',this.lastQuery,'"');
          }
          var r = this.findRecord(this.valueField, v);
          if(r){
              text = r.data[this.displayField];
          }else if(this.valueNotFoundText !== undefined){
              text = this.valueNotFoundText;
          }
        }
      }
      this.lastSelectionText = text;
      //~ this.lastSelectionText = v;
      if(this.hiddenField){
          //~ this.hiddenField.originalValue = v;
          this.hiddenField.value = v;
      }
      Ext.form.ComboBox.superclass.setValue.call(this, text);
      this.value = v; // needed for grid.afteredit
  },
  
  getParams : function(q){
    // p = Ext.form.ComboBox.superclass.getParams.call(this, q);
    // causes "Ext.form.ComboBox.superclass.getParams is undefined"
    var p = {};
    //p[this.queryParam] = q;
    if(this.pageSize){
        //~ p.start = 0;
        //~ p.limit = this.pageSize;
        p['start'] = 0;
        p['limit'] = this.pageSize;
    }
    // now my code:
    if(this.contextParams) Ext.apply(p,this.contextParams);
    //~ if(this.contextParams && this.contextValues) {
      //~ for(i = 0; i <= this.contextParams.length; i++)
        //~ p[this.contextParams[i]] = this.contextValues[i];
    //~ }
    return p;
  },
  setContextValue : function(name,value) {
    //~ console.log('setContextValue',this,this.name,':',name,'=',value);
    //~ if (this.contextValues === undefined) {
        //~ this.contextValues = Array(); // this.contextParams.length);
    //~ }
    if (this.contextParams[name] != value) {
      //~ console.log('setContextValue 1',this.contextParams);
      this.contextParams[name] = value;
      this.lastQuery = null;
      //~ console.log('setContextValue 2',this.contextParams);
    }
  }
});

Lino.ChoicesFieldElement = Ext.extend(Lino.ComboBox,{
  mode: 'local'
});


Lino.SimpleRemoteComboStore = Ext.extend(Ext.data.JsonStore,{
  forceSelection: true,
  constructor: function(config){
      Lino.SimpleRemoteComboStore.superclass.constructor.call(this, Ext.apply(config, {
          totalProperty: 'count',
          root: 'rows',
          id: 'value', // ext_requests.CHOICES_VALUE_FIELD
          fields: ['value' ], // ext_requests.CHOICES_VALUE_FIELD, // ext_requests.CHOICES_TEXT_FIELD
          listeners: { exception: Lino.on_store_exception }
      }));
  }
});

Lino.ComplexRemoteComboStore = Ext.extend(Ext.data.JsonStore,{
  constructor: function(config){
      Lino.ComplexRemoteComboStore.superclass.constructor.call(this, Ext.apply(config, {
          totalProperty: 'count',
          root: 'rows',
          id: 'value', // ext_requests.CHOICES_VALUE_FIELD
          fields: ['value','text'], // ext_requests.CHOICES_VALUE_FIELD, // ext_requests.CHOICES_TEXT_FIELD
          listeners: { exception: Lino.on_store_exception }
      }));
  }
});

Lino.RemoteComboFieldElement = Ext.extend(Lino.ComboBox,{
  mode: 'remote',
  //~ forceSelection:false,
  minChars: 2, // default 4 is too much
  queryDelay: 300, // default 500 is maybe slow
  queryParam: 'query', 
  //~ typeAhead: true,
  //~ selectOnFocus: true, // select any existing text in the field immediately on focus.
  resizable: true
});

/*
Thanks to Animal for posting the basic idea:
http://www.sencha.com/forum/showthread.php?15842-2.0-SOLVED-Combobox-twintrigger-clear&p=76130&viewfull=1#post76130

*/
Lino.TwinCombo = Ext.extend(Lino.RemoteComboFieldElement,{
    trigger2Class : 'x-form-search-trigger',
    //~ trigger2Class : 'x-tbar-detail',
    initComponent : function() {
        //~ Lino.TwinCombo.superclass.initComponent.call(this);
        Lino.ComboBox.prototype.initComponent.call(this);
        Ext.form.TwinTriggerField.prototype.initComponent.call(this);
    },
    onTrigger2Click : function() {
        //~ console.log('onTrigger2Click',this,arguments);
    }
  });
//~ Lino.TwinCombo.prototype.initComponent = Ext.form.TwinTriggerField.prototype.initComponent;
Lino.TwinCombo.prototype.getTrigger = Ext.form.TwinTriggerField.prototype.getTrigger;
Lino.TwinCombo.prototype.getOuterSize = Ext.form.TwinTriggerField.prototype.getOuterSize;
Lino.TwinCombo.prototype.initTrigger = Ext.form.TwinTriggerField.prototype.initTrigger;
Lino.TwinCombo.prototype.onTrigger1Click = Ext.form.ComboBox.prototype.onTriggerClick;
//~ Lino.TwinCombo.prototype.onTrigger2Click = function() {
    //~ console.log('onTrigger2Click',arguments);
//~ };



Lino.SimpleRemoteComboFieldElement = Ext.extend(Lino.RemoteComboFieldElement,{
  displayField: 'value', 
  valueField: null,
  forceSelection: false
});




Lino.Window = Ext.extend(Ext.Window,{
  //~ layout: "fit", 
  closeAction : 'hide',
  renderTo: 'main_area', 
  constrain: true,
  maximized: true,
  draggable: false,
  width: 700,
  height: 500,
  maximizable: false,
  constructor : function (config) {
    if (config.main_item.params_panel) {
        config.layout = 'border';
        config.main_item.region = 'center';
        config.main_item.params_panel.region = 'north';
        config.main_item.params_panel.hidden = config.main_item.params_panel_hidden;
        config.items = [config.main_item.params_panel, config.main_item];
    } else {
        config.layout = 'fit';
        config.items = config.main_item;
    }
    this.main_item = config.main_item; 
    
    delete config.main_item;
    //~ delete config.params_item;
    
    //~ this.main_item = config.items.get(0);
    this.main_item.containing_window = this;
    
    //~ console.log('20120110 Lino.Window.constructor() 1');
    //~ if (Lino.current_window) { // all windows except the top are closable
    if (this.main_item.hide_window_title) { 
      config.closable = false;
      config.frame = false;
      config.shadow = false;
      //~ config.border = true;
      //~ config.title = undefined;
      //~ config.tools = null;
      delete config.title;
      delete config.tools;
    } else {
      config.title = this.main_item.empty_title;
      config.closable = true;
      config.tools = [ 
        { qtip: 'permalink', handler: Lino.permalink_handler(this), id: "pin" }
      ];
      if (this.main_item.content_type && this.main_item.action_name != 'insert') {
        config.tools = [ {
          handler: Lino.help_text_editor,
          qtip: "Hilfetexte der Eingabefelder dieser Tabelle bearbeiten",
          scope: this.main_item,
          id: "gear"
        }].concat(config.tools);
      }
        
    //~ { qtip: '', handler: Lino.save_wc_handler(this), id: "save" }, 
    //~ { qtip: this.config.qtip, handler: Lino.save_wc_handler(this), id: "save" }, 
    //~ { qtip: 'Call doLayout() on main Container.', handler: Lino.refresh_handler(this), id: "refresh" },
    //~ if (this.main_item.params_panel) {
        //~ config.tools = config.tools.concat([ 
          //~ { qtip: 'Show/hide parameter panel', handler: this.toggle_params_panel, id: "gear", scope:this } 
        //~ ]);
    //~ }
    //~ if (config.closable !== false) {
      // if undefined, will take default behaviour
      //~ config.tools = config.tools.concat([ 
        //~ { qtip: 'close', handler: this.hide, id: "close", scope:this } 
      //~ ]);
    }
    
    this.main_item.config_containing_window(config);
    
    //~ console.log('20120110 Lino.Window.constructor() 2');
    Lino.Window.superclass.constructor.call(this,config);
    
    //~ console.log('20120110 Lino.Window.constructor() 3');
    
  },
  initComponent : function() {
    this.main_item.init_containing_window(this);
    Lino.Window.superclass.initComponent.call(this);
  
  },
  hide : function() { 
      this.main_item.do_when_clean(false,function() { 
        Lino.close_window(); });
  },
  hide_really : function() { 
    Lino.Window.superclass.hide.call(this);
  },
  onRender : function(ct, position){
    //~ console.log('20120110 Lino.Window.onRender() 1');
    Lino.Window.superclass.onRender.call(this, ct, position);
    var main_area = Ext.getCmp('main_area')
    //~ console.log('20120110 Lino.Window.onRender() 2');
  
    this.on('show', function(win) {
        //~ console.log('20120110 Lino.Window.on show 1');
        main_area.on('resize', win.onWindowResize, win);
    });
    this.on('hide', function(win) {
        main_area.un('resize', win.onWindowResize, win);
    });
    //~ console.log('20120110 Lino.Window.onRender() 3');
  }
});


Lino.unused_ParamWindow = Ext.extend(Lino.Window,{
  //~ layout: "border", 
  constructor : function (config) {
    Lino.ParamWindow.superclass.constructor.call(this,config);
    this.main_item = config.items; // `items` must be a single component
    config.layout = 'border';
    this.main_item.region = 'center';
    config.params.region = 'north';
    config.items = [config.params, config.items];
    //~ delete config.params;
  }
});




(function(){
    var ns = Ext.ns('Ext.ux.plugins');

    /**
     * @class Ext.ux.plugins.DefaultButton
     * @extends Object
     *
     * Plugin for Button that will click() the button if the user presses ENTER while
     * a component in the button's form has focus.
     *
     * @author Stephen Friedrich
     * @date 09-DEC-2009
     * @version 0.1
     *
     */
    ns.DefaultButton =  Ext.extend(Object, {
        init: function(button) {
            button.on('afterRender', setupKeyListener, button);
        }
    });

    function setupKeyListener() {
        var formPanel = this.findParentByType('form');
        new Ext.KeyMap(formPanel.el, {
            key: Ext.EventObject.ENTER,
            shift: false,
            alt: false,
            fn: function(keyCode, e){
                if(e.target.type === 'textarea' && !e.ctrlKey) {
                    return true;
                }

                this.el.select('button').item(0).dom.click();
                return false;
            },
            scope: this
        });
    }

    Ext.ComponentMgr.registerPlugin('defaultButton', ns.DefaultButton);

})(); 

Ext.override(Ext.form.BasicForm,{
    my_loadRecord : function(values){
    //~ loadRecord : function(record){
        /* Same as ExtJS's loadRecord() (setValues()), except that we 
        forward also the record to field.setValue() so that Lino.Combobox 
        can use it. 
        */
        //~ console.log('20120918 my_loadRecord',values)
        if(Ext.isArray(values)){ 
            for(var i = 0, len = values.length; i < len; i++){
                var v = values[i];
                var f = this.findField(v.id);
                if(f){
                    f.setValue(v.value,values);
                    if(this.trackResetOnLoad){
                        f.originalValue = f.getValue();
                    }
                }
            }
        }else{ 
            var field, id;
            for(id in values){
                if(!Ext.isFunction(values[id]) && (field = this.findField(id))){
                    field.setValue(values[id],values);
                    if(this.trackResetOnLoad){
                        field.originalValue = field.getValue();
                        //~ if (field.hiddenField) {
                          //~ field.hiddenField.originalValue = field.hiddenField.value;
                        //~ }
                    }
                }
            }
        }
        return this;
    }
});




function initializeFooBarDropZone(cmp) {
    //~ console.log('initializeFooBarDropZone',cmp);
    cmp.dropTarget = new Ext.dd.DropTarget(cmp.bwrap, {
      //~ ddGroup     : 'gridDDGroup',
      notifyEnter : function(ddSource, e, data) {
        console.log('notifyEnter',ddSource,e,data);
        //Add some flare to invite drop.
        cmp.body.stopFx();
        cmp.body.highlight();
      },
      notifyDrop  : function(ddSource, e, data){
        console.log('notifyDrop',ddSource,e,data);
        // Reference the record (single selection) for readability
        //~ var selectedRecord = ddSource.dragData.selections[0];


        // Load the record into the form
        //~ formPanel.getForm().my_loadRecord(selectedRecord);


        // Delete record from the grid.  not really required.
        //~ ddSource.grid.store.remove(selectedRecord);

        return(true);
      }
    })
}



Lino.show_mti_child = function(fieldname,detail_handler) {
  //~ console.log('show_mti_child',this);
  //~ console.log('show_mti_child',panel.find("main_area"));
  rec = Lino.current_window.main_item.get_current_record();
  //~ rec = panel.get_current_record();
  if (rec) {
    //~ console.log('show_mti_child',Lino.current_window,rec);
    if (rec.phantom) {
      Lino.notify('Not allowed on phantom record.');
    }else if (rec.data[fieldname]) {
      //~ console.log('show_mti_child',rec.id);
      //~ detail_handler(Lino.current_window.main_item,{},{record_id:rec.id});
      detail_handler.run(null,{record_id:rec.id});
      //~ window.open(urlroot + '/' + rec.id);
      //~ document.location = urlroot + '/' + rec.id;
      //~ window.open(urlroot + '/' + rec.id,'_blank');
    } else {
      Lino.alert("Kann MTI-Kind nicht anzeigen wenn Checkbox abgeschlatet ist.");
    }
  } else {
    Lino.notify('No current record.');
  }
};



Lino.davlink_open = function(webdavURL) {
  /* Calls lino.applets.davlink.DavLink.open()
  */
  //~ console.log('Going to call document.applets.DavLink.open(',webdavURL,')');
  var rv = document.applets.DavLink.open(webdavURL);
  if (rv) window.alert(rv);
}






/*
Mappings towards lino.modlib.cal.models.PanelCalendars
*/
// Sset SS = Ssite.modules.cal.PanelCalendars.get_handle(Sui).store
Ext.ensible.cal.CalendarMappings = {
    CalendarId:   {name:'ID',       mapping: 'id', type: 'int'},
    Title:        {name:'CalTitle', mapping: 'babel_name', type: 'string'},
    Description:  {name:'Desc',     mapping: 'description', type: 'string'},
    ColorId:      {name:'Color',    mapping: 'color', type: 'int'},
    IsHidden:     {name:'Hidden',   mapping: 'is_hidden', type: 'boolean'},    
};
Ext.ensible.cal.CalendarRecord.reconfigure();  


/*
Mappings towards lino.modlib.cal.models.PanelEvents 
*/
// Sset SS = Ssite.modules.cal.PanelEvents.get_handle(Sui).store
Ext.ensible.cal.EventMappings = {
    EventId:     {name: 'ID',        mapping: 'id', type:'int'},
    CalendarId:  {name: 'CalID',     mapping: 'calendarHidden', type: 'int'},
    Title:       {name: 'EvtTitle',  mapping: 'summary'},
    StartDate:   {name: 'StartDt',   mapping: 'start_dt', 
      type: 'date', 
      dateFormat: "Y-m-d\TH:i:s" },
    EndDate:     {name: 'EndDt',     mapping: 'end_dt', 
      type: 'date', 
      dateFormat: "Y-m-d\TH:i:s"},
    RRule:       {name: 'RecurRule', mapping: 'rsetHidden'},
    Location:    {name: 'Location',  mapping: 'placeHidden'},
    Notes:       {name: 'Desc',      mapping: 'description'},
    Url:         {name: 'LinkUrl',   mapping: 'url'},
    IsAllDay:    {name: 'AllDay',    mapping: 'all_day', type: 'boolean'},
    Reminder:    {name: 'Reminder',  mapping: 'reminder'}
    
};
Ext.ensible.cal.EventRecord.reconfigure();


//~ Lino.on_eventclick = 
    
Lino.on_editdetails = 

Lino.format_time = function(dt) {
    return dt.getHours() + ':' + dt.getMinutes();
}
    
Lino.on_eventdelete = function() {
  //~ console.log("Lino.on_eventdelete",arguments);
};

Lino.on_eventadd  = function(cp,rec,el) {
  //~ console.log("Lino.on_eventadd ",arguments);
  return false;
}
    
Lino.on_eventresize  = function(cp,rec,el) {
  //~ console.log("Lino.on_eventresize ",arguments);
  //~ Lino.cal.Events.insert(cp);
  //~ return false;
}
    
Lino.on_eventupdate  = function(cp,rec,el) {
  //~ console.log("Lino.on_eventupdate",arguments);
  //~ Lino.cal.Events.insert(cp);
  //~ return false;
}
    

//~ Lino.eventStore = new Ext.ensible.cal.EventStore({ 
//~ Lino.eventStore = new Ext.data.ArrayStore({ 
Lino.unused_eventStore = new Ext.data.JsonStore({ 
  listeners: { exception: Lino.on_store_exception }
  ,url: '/restful/cal/PanelEvents'
  ,restful : true
  ,proxy: new Ext.data.HttpProxy({ 
      url: '/restful/cal/PanelEvents', 
      disableCaching: false // no need for cache busting when loading via Ajax
      //~ disableCaching:true,
  })
  ,fields: Ext.ensible.cal.EventRecord.prototype.fields.getRange()
  ,totalProperty: "count"
  ,root: "rows"
  ,idProperty: Ext.ensible.cal.EventMappings.EventId.mapping
  ,writer : new Ext.data.JsonWriter({
    writeAllFields: false
  })
  ,load: function(options) {
    //~ foo.bar = baz; // 20120213
      if (!options) options = {};
      if (!options.params) options.params = {};
      //~ options.params.$ext_requests.URL_PARAM_TEAM_VIEW = Lino.calendar_app.team_view_button.pressed;
      
      var view = this.cal_panel.getActiveView();
      var bounds = view.getViewBounds();
      //~ var p = {sd:'05.02.2012',ed:'11.02.2012'};
      //~ var p = {};
      options.params[view.dateParamStart] = bounds.start.format(view.dateParamFormat);
      options.params[view.dateParamEnd] = bounds.end.format(view.dateParamFormat);
      Lino.insert_subst_user(options.params);
      //~ Ext.apply(options.params,p)
      //~ console.log('20120710 eventStore.load()',this.baseParams,options);
    
    return Ext.data.JsonStore.prototype.load.call(this,options);
  }
});

//~ Lino.eventStore.on('load', function() {
//~ });


    //~ Lino.subst_user = id;


//~ Lino.calendarStore = new Ext.data.ArrayStore({ 
Lino.unused_calendarStore = new Ext.data.JsonStore({ 
      listeners: { exception: Lino.on_store_exception }
      ,restful : true
      ,proxy: new Ext.data.HttpProxy({ 
          url: '/restful/cal/PanelCalendars?fmt=json', 
          disableCaching: false // no need for cache busting when loading via Ajax
          //~ restful : true
          //~ method: "GET"
      })
      //~ ,autoLoad: true
      //~ ,remoteSort: true
      //~ ,baseParams: bp
      ,totalProperty: "count"
      ,root: "rows"
      ,fields: Ext.ensible.cal.CalendarRecord.prototype.fields.getRange()
      ,idProperty: Ext.ensible.cal.CalendarMappings.CalendarId.mapping
      //~ ,idIndex: Ext.ensible.cal.CalendarMappings.CalendarId.mapping
    });


Lino.CalendarCfg = {
    dateParamFormat: 'd.m.Y',
    dateParamStart:'sd',
    dateParamEnd:'ed'
};
//~ 20120704 Lino.CalendarPanel = Ext.extend(Ext.ensible.cal.CalendarPanel,Lino.MainPanel);
//~ Lino.CalendarPanel = Ext.extend(Lino.CalendarPanel,{
Ext.override(Ext.ensible.cal.CalendarPanel,Lino.MainPanel);
Ext.override(Ext.ensible.cal.CalendarPanel,{
  //~ empty_title : "\$ui.get_actor('cal.Panel').report.label",
  empty_title : "Kalender"
  ,activeItem: 1 // 0: day, 1: week
  ,ls_url: '/cal/CalendarPanel'
  //~ ,disableCaching:true
  //~ ,eventStore: Lino.eventStore
  //~ ,calendarStore: Lino.calendarStore
  //~ ,initComponent : function(){
    //~ Ext.ensible.cal.CalendarPanel.superclass.initComponent.call(this);
    //~ this.eventStore.on('load',function(){
      //~ console.log("20130808",Lino.eventStore);
      //~ if (this.eventStore.reader.jsonData) {
        //~ console.log("20130808 b",this.eventStore.reader.jsonData.title);
        //~ this.set_window_title(this.eventStore.reader.jsonData.title);
      //~ }
    //~ },this);
  //~ }
  ,listeners: { 
    editdetails: function(cp,rec,el) {
      //~ console.log("Lino.on_editdetails",arguments);
      if (rec.data.ID)
          Lino.cal.PanelEvents.detail.run(null,{record_id:rec.data.ID,base_params:this.app_instance.event_store.baseParams});
      return false;
    }
    ,eventclick: function(cp,rec,el) {
      //~ console.log("Lino.on_eventclick",arguments);
      //~ Lino.cal.Events.detail_action.run({record_id:rec.data.ID});
      Lino.cal.PanelEvents.detail.run(null,{record_id:rec.data.ID,base_params:this.app_instance.event_store.baseParams});
      return false;
    }
    //~ ,eventadd: Lino.on_eventadd
    //~ ,eventdelete: Lino.on_eventdelete
    //~ ,eventresize: Lino.on_eventresize
    ,afterrender : function(config) {
      //~ console.log("20120704 afterrender");
      this.app_instance.calendar_store.load();
      //~ console.log("20120704 afterrender calls eventStore.load()",p);
      this.app_instance.event_store.cal_panel = this;
      //~ Lino.eventStore.load({params:p});
      this.app_instance.event_store.load();
      //~ Lino.CalendarPanel.superclass.constructor.call(this, config);
      //~ console.log(20120118, config,this);
    }
    }
  ,enableEditDetails: false
  //~ ,monthViewCfg: Lino.CalendarCfg
  //~ ,weekViewCfg: Lino.CalendarCfg
  //~ ,multiDayViewCfg: Lino.CalendarCfg
  //~ ,multiWeekViewCfg: Lino.CalendarCfg
  //~ ,dayViewCfg: Lino.CalendarCfg
  //~ ,initComponent : function() {
    //~ // this.on('eventadd',Lino.on_eventadd);
    //~ Lino.CalendarPanel.superclass.initComponent.call(this);
  //~ }
});




Lino.CalendarAppPanel = Ext.extend(Ext.Panel,Lino.MainPanel);
Lino.CalendarAppPanel = Ext.extend(Lino.CalendarAppPanel,Lino.PanelMixin);
Lino.CalendarAppPanel = Ext.extend(Lino.CalendarAppPanel,{
  app_instance : null
  //~ empty_title : "\$ui.get_actor('cal.Panel').report.label",
  ,empty_title : "Kalender"
  ,ls_url: '/cal/CalendarPanel'
  ,set_status : function(status,rp) { 
      this.requesting_panel = Ext.getCmp(rp);
      //~ console.log('20120918 CalendarAppPanel.set_status()',status,rp,this.requesting_panel);
      this.clear_base_params();
      if (status == undefined) status = {};
      //~ if (status.param_values) 
      //~ this.set_field_values(status.field_values);
      if (status.base_params) this.set_base_params(status.base_params);
      this.refresh();
      }
  ,refresh : function() {
      this.app_instance.event_store.reload();
  }
  ,layout: 'fit'
  ,get_base_params : function() {
    var p = Ext.apply({},this.base_params);
    Lino.insert_subst_user(p);
    return p;
  }
  ,set_base_params : function(p) {
    this.base_params = Ext.apply(this.app_instance.event_store.baseParams,p);
    this.app_instance.event_store.baseParams = this.base_params;
  }
  ,clear_base_params : function() {
      this.base_params = {};
      Lino.insert_subst_user(this.base_params);
  }
  ,set_base_param : function(k,v) {
      if (!this.base_params) this.base_params = {};
      this.base_params[k] = v;
  }
});

Lino.CalendarApp = function() { return {
  team_view_button : null 
  ,get_main_panel : function() {
      this.event_store = new Ext.data.JsonStore({ 
          listeners: { exception: Lino.on_store_exception }
          ,url: '/restful/cal/PanelEvents'
          ,restful : true
          ,proxy: new Ext.data.HttpProxy({ 
              url: '/restful/cal/PanelEvents', 
              disableCaching: false // no need for cache busting when loading via Ajax
              //~ disableCaching:true,
          })
          ,fields: Ext.ensible.cal.EventRecord.prototype.fields.getRange()
          ,totalProperty: "count"
          ,root: "rows"
          ,idProperty: Ext.ensible.cal.EventMappings.EventId.mapping
          ,writer : new Ext.data.JsonWriter({
            writeAllFields: false
          })
          ,load: function(options) {
            //~ foo.bar = baz; // 20120213
              if (!options) options = {};
              if (!options.params) options.params = {};
              //~ options.params.$ext_requests.URL_PARAM_TEAM_VIEW = Lino.calendar_app.team_view_button.pressed;
              
              var view = this.cal_panel.getActiveView();
              var bounds = view.getViewBounds();
              //~ var p = {sd:'05.02.2012',ed:'11.02.2012'};
              //~ var p = {};
              options.params[view.dateParamStart] = bounds.start.format(view.dateParamFormat);
              options.params[view.dateParamEnd] = bounds.end.format(view.dateParamFormat);
              Lino.insert_subst_user(options.params);
              //~ Ext.apply(options.params,p)
              //~ console.log('20120710 eventStore.load()',this.baseParams,options);
            
            return Ext.data.JsonStore.prototype.load.call(this,options);
          }
      });

      //~ Lino.calendarStore
      this.calendar_store = new Ext.data.JsonStore({ 
          listeners: { exception: Lino.on_store_exception }
          ,restful : true
          ,proxy: new Ext.data.HttpProxy({ 
              url: '/restful/cal/PanelCalendars?fmt=json', 
              disableCaching: false // no need for cache busting when loading via Ajax
              //~ restful : true
              //~ method: "GET"
          })
          //~ ,autoLoad: true
          //~ ,remoteSort: true
          //~ ,baseParams: bp
          ,totalProperty: "count"
          ,root: "rows"
          ,fields: Ext.ensible.cal.CalendarRecord.prototype.fields.getRange()
          ,idProperty: Ext.ensible.cal.CalendarMappings.CalendarId.mapping
          //~ ,idIndex: Ext.ensible.cal.CalendarMappings.CalendarId.mapping
      });
      
      var cap = new Lino.CalendarAppPanel({ 
          app_instance: this, 
          items : 
        //~ [{
          //~ id: 'app-header',
          //~ region: 'north',
          //~ height: 35,
          //~ border: false,
          // contentEl: 'app-header-content'
        //~ },
      {
          id: 'app-center',
          title: '...', // will be updated to the current view's date range
          region: 'center',
          layout: 'border',
          listeners: {
              'afterrender': function(){
                  Ext.getCmp('app-center').header.addClass('app-center-header');
              }
          },
          items: [{
              id:'app-west',
              region: 'west',
              width: 176,
              border: false,
              items: [{
                  xtype: 'datepicker',
                  id: 'app-nav-picker',
                  cls: 'ext-cal-nav-picker',
                  listeners: {
                      'select': {
                          fn: function(dp, dt){
                              //~ Lino.calendarPanel.setStartDate(dt);
                              this.setStartDate(dt);
                          },
                          scope: this
                      }
                  }
              //~ },{ 
                //~ layout:'fit',
                //~ items: [
                  //~ new Ext.form.Checkbox({
                    //~ boxLabel:"$_('Team view')",
                    //~ hideLabel:true
                    //~ listeners: { click: }
                  //~ })
                //~ ]
              },{ 
                layout:'form',
                items: [
                  this.team_view_button = new Ext.Button({
                    text:"Team-Ansicht",
                    enableToggle:true,
                    pressed:false,
                    toggleHandler: function(btn,state) { 
                      //~ console.log('20120716 teamView.toggle()');
                      this.event_store.setBaseParam('tv',state);
                      this.event_store.load();
                      //~ Lino.eventStore.load({params:{$ext_requests.URL_PARAM_TEAM_VIEW:state}});
                      //~ console.log("team view",state);
                    }
                  })
                ]
              },{
                  xtype: 'extensible.calendarlist',
                  store: this.calendar_store,
                  border: false,
                  width: 175
              }]
          },{
              xtype: 'extensible.calendarpanel', // Ext.ensible.cal.CalendarPanel
              eventStore: this.event_store,
              app_instance: this,
              calendarStore: this.calendar_store,
              border: false,
              id:'app-calendar',
              region: 'center',
              //~ activeItem: 3, // month view
              
              // Any generic view options that should be applied to all sub views:
              viewConfig: {
                  // Lino.CalendarCfg
                  dateParamFormat: 'd.m.Y',
                  dateParamStart:'sd',
                  dateParamEnd:'ed',
                
                  //enableFx: false,
                  //ddIncrement: 10, //only applies to DayView and subclasses, but convenient to put it here
                  viewStartHour: 8,
                  viewEndHour: 18
                  //minEventDisplayMinutes: 15
              },
              
              // View options specific to a certain view (if the same options exist in viewConfig
              // they will be overridden by the view-specific config):
              monthViewCfg: {
                  showHeader: true,
                  showWeekLinks: true,
                  showWeekNumbers: true,
                  eventBodyMarkup: ['{Title}',
                    //~ '<tpl if="url">',
                        //~ '<a href="{url}">XX</a>',
                    //~ '</tpl>',
                    '<tpl if="_isReminder">',
                        '<i class="ext-cal-ic ext-cal-ic-rem">&#160;</i>',
                    '</tpl>',
                    '<tpl if="_isRecurring">',
                        '<i class="ext-cal-ic ext-cal-ic-rcr">&#160;</i>',
                    '</tpl>',
                    '<tpl if="spanLeft">',
                        '<i class="ext-cal-spl">&#160;</i>',
                    '</tpl>',
                    '<tpl if="spanRight">',
                        '<i class="ext-cal-spr">&#160;</i>',
                    '</tpl>'
                ].join('')
              },
              
              multiWeekViewCfg: {
                  //weekCount: 3
              },
              
              // Some optional CalendarPanel configs to experiment with:
              //readOnly: true,
              //showDayView: false,
              //showMultiDayView: true,
              //showWeekView: false,
              //showMultiWeekView: false,
              //showMonthView: false,
              //showNavBar: false,
              //showTodayText: false,
              //showTime: false,
              //editModal: true,
              //enableEditDetails: false,
              //title: 'My Calendar', // the header of the calendar, could be a subtitle for the app
              
              // Once this component inits it will set a reference to itself as an application
              // member property for easy reference in other functions within App.
              //~ initComponent: function() {
                  //~ Lino.calendarPanel = this;
                  //~ this.constructor.prototype.initComponent.apply(this, arguments);
              //~ },
              
              listeners: {
                  //~ 'eventclick': {
                      //~ fn: function(vw, rec, el){
                          //~ this.clearMsg();
                      //~ },
                      //~ scope: this
                  //~ },
                  'eventover': function(vw, rec, el){
                      //console.log('Entered evt rec='+rec.data[Ext.ensible.cal.EventMappings.Title.name]', view='+ vw.id +', el='+el.id);
                  },
                  'eventout': function(vw, rec, el){
                      //console.log('Leaving evt rec='+rec.data[Ext.ensible.cal.EventMappings.Title.name]+', view='+ vw.id +', el='+el.id);
                  },
                  'eventadd': {
                      fn: function(cp, rec){
                          this.showMsg('Event '+ rec.data[Ext.ensible.cal.EventMappings.Title.name] +' was added');
                      },
                      scope: this
                  },
                  'eventupdate': {
                      fn: function(cp, rec){
                          this.showMsg('Event '+ rec.data[Ext.ensible.cal.EventMappings.Title.name] +' was updated');
                      },
                      scope: this
                  },
                  'eventdelete': {
                      fn: function(cp, rec){
                          //this.eventStore.remove(rec);
                          this.showMsg('Event '+ rec.data[Ext.ensible.cal.EventMappings.Title.name] +' was deleted');
                      },
                      scope: this
                  },
                  'eventcancel': {
                      fn: function(cp, rec){
                          // edit canceled
                      },
                      scope: this
                  },
                  'viewchange': {
                      fn: function(p, vw, dateInfo){
                          if(this.editWin){
                              this.editWin.hide();
                          };
                          if(dateInfo !== null){
                              // will be null when switching to the event edit form so ignore
                              Ext.getCmp('app-nav-picker').setValue(dateInfo.activeDate);
                              this.updateTitle(dateInfo.viewStart, dateInfo.viewEnd);
                          }
                          
                      },
                      scope: this
                  },
                  'dayclick': {
                      fn: function(vw, dt, ad, el){
                          this.clearMsg();
                      },
                      scope: this
                  },
                  'rangeselect': {
                      fn: function(vw, dates, onComplete){
                          this.clearMsg();
                      },
                      scope: this
                  },
                  'eventmove': {
                      fn: function(vw, rec){
                          rec.commit();
                          var time = rec.data[Ext.ensible.cal.EventMappings.IsAllDay.name] ? '' : ' \\a\\t g:i a';
                          this.showMsg('Event '+ rec.data[Ext.ensible.cal.EventMappings.Title.name] +' was moved to '+
                              rec.data[Ext.ensible.cal.EventMappings.StartDate.name].format('F jS'+time));
                      },
                      scope: this
                  },
                  'eventresize': {
                      fn: function(vw, rec){
                          rec.commit();
                          this.showMsg('Event '+ rec.data[Ext.ensible.cal.EventMappings.Title.name] +' was updated');
                      },
                      scope: this
                  },
                  'eventdelete': {
                      fn: function(win, rec){
                          this.event_store.remove(rec);
                          this.showMsg('Event '+ rec.data[Ext.ensible.cal.EventMappings.Title.name] +' was deleted');
                      },
                      scope: this
                  },
                  'initdrag': {
                      fn: function(vw){
                          if(this.editWin && this.editWin.isVisible()){
                              this.editWin.hide();
                          }
                      },
                      scope: this
                  }
              }
          }]
        }
        //~ ]
        
      });
      
      this.event_store.on('load',function(){
        //~ console.log("20130808",this.event_store);
        if (this.event_store.reader.jsonData) {
          //~ console.log("20130808 b",this.event_store.reader.jsonData.title);
          //~ console.log("20130808 c",this);
          cap.set_window_title(this.event_store.reader.jsonData.title);
        }
      },this);
      
      //~ cap.app_instance = this;
      return cap;
      
  }
  ,updateTitle: function(startDt, endDt){
      var p = Ext.getCmp('app-center');
      
      if(startDt.clearTime().getTime() == endDt.clearTime().getTime()){
          p.setTitle(startDt.format('F j, Y'));
      }
      else if(startDt.getFullYear() == endDt.getFullYear()){
          if(startDt.getMonth() == endDt.getMonth()){
              p.setTitle(startDt.format('F j') + ' - ' + endDt.format('j, Y'));
          }
          else{
              p.setTitle(startDt.format('F j') + ' - ' + endDt.format('F j, Y'));
          }
      }
      else{
          p.setTitle(startDt.format('F j, Y') + ' - ' + endDt.format('F j, Y'));
      }
  }
  // This is an application-specific way to communicate CalendarPanel event messages back to the user.
  // This could be replaced with a function to do "toast" style messages, growl messages, etc. This will
  // vary based on application requirements, which is why it's not baked into the CalendarPanel.
  ,showMsg: function(msg){
      Lino.notify(msg);
      //~ Ext.fly('app-msg').update(msg).removeClass('x-hidden');
  }
  
  ,clearMsg: function(){
      Lino.notify('');
      //~ Ext.fly('app-msg').update('').addClass('x-hidden');
  }
}
};




/*
captureEvents utility by Aaron Conran
<http://www.sencha.com/learn/grid-faq/>

Ext.onReady(function(){
    var grid = new Ext.grid.GridPanel({
        ... 
    });
    captureEvents(grid);
});
*/
function captureEvents(observable) {
    Ext.util.Observable.capture(
        observable,
        function(eventName) {
            console.info(eventName);
        },
        this
    );		
}
 




var cardReader = new be.belgium.eid.CardReader();

function noCardPresentHandler() {
  window.alert("No card present!");
}
cardReader.setNoCardPresentHandler(noCardPresentHandler);

function noReaderDetectedHandler() {
  window.alert("No reader detected!");
}
cardReader.setNoReaderDetectedHandler(noReaderDetectedHandler);

function appletNotFoundHandler() {
  window.alert("Applet not found!");
}
cardReader.setAppletNotFoundHandler(appletNotFoundHandler);

function appletExceptionHandler(e) {
  window.alert("Error reading card!\r\nException: " + e + "\r\nPlease try again.");
}
cardReader.setAppletExceptionHandler(appletExceptionHandler);

//~ function clearPicture() {
  //~ document.getElementById("encoded_picture").src = "data:image/jpeg;base64,";
//~ }

Lino.beid_read_card_processor = function() {
    var card = cardReader.read();
    if (!card) {
        //~ Lino.alert("No card returned.");
        return null;
    } 
    console.log(card.getPicture());
    return {
      cardNumber: card.cardNumber,
      validityBeginDate:card.validityBeginDate.format("d.m.Y"),
      validityEndDate: card.validityEndDate.format("d.m.Y"),
      chipNumber:card.chipNumber,
      issuingMunicipality:card.issuingMunicipality,
      nationalNumber:card.nationalNumber,
      surname:card.surname,
      firstName1:card.firstName1,
      firstName2:card.firstName2,
      firstName3:card.firstName3,
      nationality:card.nationality,
      birthLocation:card.birthLocation,
      birthDate: card.birthDate.format("d.m.Y"),
      sex:card.sex,
      nobleCondition:card.nobleCondition,
      documentType:card.documentType,
      specialStatus:card.specialStatus,
      whiteCane:card.whiteCane,
      yellowCane:card.yellowCane,
      extendedMinority:card.extendedMinority,
      street:card.street,
      streetNumber:card.streetNumber,
      boxNumber:card.boxNumber,
      zipCode:card.zipCode,
      municipality:card.municipality,
      country:card.country
      //~ comment the following line out to test whether the picture takes a lot of time
      //~ test 20121214 on my machine revealed no perceivable gain
      ,picture:base64.encode(card.getPicture())
    };
}





Lino.main_menu = [ { "menu": { "items": [ { "text": "Info", "listeners": { "render": Lino.quicktip_renderer("Foo","Zeigt Informationen \u00fcber diese Site an.") }, "handler": function() {Lino.about.About.show.run(null,{ "record_id": -99998 })} } ] }, "text": "Site" }, { "text": "Startseite", "handler": function() {Lino.close_all_windows()} } ];
Ext.namespace('Lino.system.SiteConfigs')
Ext.namespace('Lino.system.ContentTypes')
Ext.namespace('Lino.system.HelpTexts')
Ext.namespace('Lino.system.TextFieldTemplates')
Ext.namespace('Lino.users.Users')
Ext.namespace('Lino.users.MySettings')
Ext.namespace('Lino.users.UsersOverview')
Ext.namespace('Lino.users.Teams')
Ext.namespace('Lino.users.Memberships')
Ext.namespace('Lino.users.Authorities')
Ext.namespace('Lino.changes.Changes')
Ext.namespace('Lino.countries.Countries')
Ext.namespace('Lino.countries.Cities')
Ext.namespace('Lino.properties.PropGroups')
Ext.namespace('Lino.properties.PropTypes')
Ext.namespace('Lino.properties.Properties')
Ext.namespace('Lino.properties.PropChoices')
Ext.namespace('Lino.contacts.CompanyTypes')
Ext.namespace('Lino.contacts.Partners')
Ext.namespace('Lino.contacts.Companies')
Ext.namespace('Lino.contacts.RoleTypes')
Ext.namespace('Lino.contacts.Roles')
Ext.namespace('Lino.contacts.Persons')
Ext.namespace('Lino.outbox.Recipients')
Ext.namespace('Lino.outbox.Mails')
Ext.namespace('Lino.outbox.Attachments')
Ext.namespace('Lino.cal.Calendars')
Ext.namespace('Lino.cal.Subscriptions')
Ext.namespace('Lino.cal.Rooms')
Ext.namespace('Lino.cal.Priorities')
Ext.namespace('Lino.cal.Events')
Ext.namespace('Lino.cal.OneEvent')
Ext.namespace('Lino.cal.MyEvents')
Ext.namespace('Lino.cal.MyAssignedEvents')
Ext.namespace('Lino.cal.Tasks')
Ext.namespace('Lino.cal.MyTasks')
Ext.namespace('Lino.cal.GuestRoles')
Ext.namespace('Lino.cal.Guests')
Ext.namespace('Lino.cal.MyPresences')
Ext.namespace('Lino.cal.MyPendingPresences')
Ext.namespace('Lino.cal.MyGuests')
Ext.namespace('Lino.cal.PanelCalendars')
Ext.namespace('Lino.cal.PanelEvents')
Ext.namespace('Lino.uploads.UploadTypes')
Ext.namespace('Lino.uploads.Uploads')
Ext.namespace('Lino.households.Types')
Ext.namespace('Lino.households.Households')
Ext.namespace('Lino.households.Roles')
Ext.namespace('Lino.households.Members')
Ext.namespace('Lino.reception.ExpectedGuests')
Ext.namespace('Lino.reception.ReceivedGuests')
Ext.namespace('Lino.reception.MyWaitingGuests')
Ext.namespace('Lino.notes.NoteTypes')
Ext.namespace('Lino.notes.EventTypes')
Ext.namespace('Lino.notes.Notes')
Ext.namespace('Lino.cv.LanguageKnowledges')
Ext.namespace('Lino.cv.PersonProperties')
Ext.namespace('Lino.isip.ContractTypes')
Ext.namespace('Lino.isip.ExamPolicies')
Ext.namespace('Lino.isip.ContractEndings')
Ext.namespace('Lino.isip.StudyTypes')
Ext.namespace('Lino.isip.Contracts')
Ext.namespace('Lino.isip.MyContracts')
Ext.namespace('Lino.jobs.Schedules')
Ext.namespace('Lino.jobs.Regimes')
Ext.namespace('Lino.jobs.JobProviders')
Ext.namespace('Lino.jobs.ContractTypes')
Ext.namespace('Lino.jobs.Sectors')
Ext.namespace('Lino.jobs.Functions')
Ext.namespace('Lino.jobs.Contracts')
Ext.namespace('Lino.jobs.MyContracts')
Ext.namespace('Lino.jobs.Offers')
Ext.namespace('Lino.jobs.Studies')
Ext.namespace('Lino.jobs.Experiences')
Ext.namespace('Lino.jobs.Candidatures')
Ext.namespace('Lino.jobs.Jobs')
Ext.namespace('Lino.jobs.JobTypes')
Ext.namespace('Lino.jobs.ContractsSearch')
Ext.namespace('Lino.pcsw.Clients')
Ext.namespace('Lino.pcsw.DebtsClients')
Ext.namespace('Lino.pcsw.ClientsTest')
Ext.namespace('Lino.pcsw.PersonGroups')
Ext.namespace('Lino.pcsw.Activities')
Ext.namespace('Lino.pcsw.DispenseReasons')
Ext.namespace('Lino.pcsw.Dispenses')
Ext.namespace('Lino.pcsw.ExclusionTypes')
Ext.namespace('Lino.pcsw.Exclusions')
Ext.namespace('Lino.pcsw.AidTypes')
Ext.namespace('Lino.pcsw.ClientContactTypes')
Ext.namespace('Lino.pcsw.ClientContacts')
Ext.namespace('Lino.pcsw.CoachingTypes')
Ext.namespace('Lino.pcsw.CoachingEndings')
Ext.namespace('Lino.pcsw.Coachings')
Ext.namespace('Lino.reception.Clients')
Ext.namespace('Lino.reception.WaitingGuests')
Ext.namespace('Lino.languages.Languages')
Ext.namespace('Lino.accounts.Charts')
Ext.namespace('Lino.accounts.Groups')
Ext.namespace('Lino.accounts.Accounts')
Ext.namespace('Lino.courses.CourseProviders')
Ext.namespace('Lino.courses.CourseContents')
Ext.namespace('Lino.courses.Courses')
Ext.namespace('Lino.courses.CourseOffers')
Ext.namespace('Lino.courses.CourseRequests')
Ext.namespace('Lino.courses.PendingCourseRequests')
Ext.namespace('Lino.integ.Clients')
Ext.namespace('Lino.integ.CoachingEndingsByUser')
Ext.namespace('Lino.integ.CoachingEndingsByType')
Ext.namespace('Lino.integ.ContractEndingsByType')
Ext.namespace('Lino.integ.JobsContractEndingsByType')
Ext.namespace('Lino.integ.ContractsPerUserAndContractType')
Ext.namespace('Lino.integ.JobsContractsPerUserAndContractType')
Ext.namespace('Lino.integ.StudyTypesAndContracts')
Ext.namespace('Lino.integ.CompaniesAndContracts')
Ext.namespace('Lino.integ.JobProvidersAndContracts')
Ext.namespace('Lino.newcomers.Brokers')
Ext.namespace('Lino.newcomers.Faculties')
Ext.namespace('Lino.newcomers.Competences')
Ext.namespace('Lino.newcomers.NewClients')
Ext.namespace('Lino.newcomers.AvailableCoaches')
Ext.namespace('Lino.debts.Budgets')
Ext.namespace('Lino.debts.Actors')
Ext.namespace('Lino.debts.Entries')
Ext.namespace('Lino.debts.EntriesByType')
Ext.namespace('Lino.cbss.Sectors')
Ext.namespace('Lino.cbss.Purposes')
Ext.namespace('Lino.cbss.IdentifyPersonRequests')
Ext.namespace('Lino.cbss.ManageAccessRequests')
Ext.namespace('Lino.cbss.RetrieveTIGroupsRequests')
Ext.namespace('Lino.sessions.SessionTable')
Ext.namespace('Lino.system.MyTextFieldTemplates')
Ext.namespace('Lino.users.MembershipsByUser')
Ext.namespace('Lino.users.AuthoritiesGiven')
Ext.namespace('Lino.users.AuthoritiesTaken')
Ext.namespace('Lino.countries.CitiesByCity')
Ext.namespace('Lino.countries.CitiesByCountry')
Ext.namespace('Lino.properties.PropsByGroup')
Ext.namespace('Lino.properties.PropsByType')
Ext.namespace('Lino.properties.ChoicesByType')
Ext.namespace('Lino.contacts.PartnersByCity')
Ext.namespace('Lino.contacts.PartnersByCountry')
Ext.namespace('Lino.contacts.RolesByCompany')
Ext.namespace('Lino.contacts.RolesByPerson')
Ext.namespace('Lino.outbox.RecipientsByMail')
Ext.namespace('Lino.outbox.MyOutbox')
Ext.namespace('Lino.outbox.MailsByUser')
Ext.namespace('Lino.outbox.MailsByProject')
Ext.namespace('Lino.outbox.SentByPartner')
Ext.namespace('Lino.outbox.AttachmentsByMail')
Ext.namespace('Lino.cal.SubscriptionsByCalendar')
Ext.namespace('Lino.cal.SubscriptionsByUser')
Ext.namespace('Lino.cal.EventsByCalendar')
Ext.namespace('Lino.cal.EventsByRoom')
Ext.namespace('Lino.cal.EventsByProject')
Ext.namespace('Lino.cal.TasksByUser')
Ext.namespace('Lino.cal.TasksByProject')
Ext.namespace('Lino.cal.GuestsByEvent')
Ext.namespace('Lino.cal.GuestsByRole')
Ext.namespace('Lino.cal.GuestsByPartner')
Ext.namespace('Lino.uploads.MyUploads')
Ext.namespace('Lino.households.HouseholdsByType')
Ext.namespace('Lino.households.MembersByHousehold')
Ext.namespace('Lino.households.MembersByPerson')
Ext.namespace('Lino.households.MembersByRole')
Ext.namespace('Lino.reception.AppointmentsByGuest')
Ext.namespace('Lino.notes.MyNotes')
Ext.namespace('Lino.notes.NotesByType')
Ext.namespace('Lino.notes.NotesByEventType')
Ext.namespace('Lino.notes.NotesByProject')
Ext.namespace('Lino.cv.LanguageKnowledgesByPerson')
Ext.namespace('Lino.cv.KnowledgesByLanguage')
Ext.namespace('Lino.cv.PropsByPerson')
Ext.namespace('Lino.cv.PersonPropsByProp')
Ext.namespace('Lino.cv.ConfiguredPropsByPerson')
Ext.namespace('Lino.cv.SkillsByPerson')
Ext.namespace('Lino.cv.SoftSkillsByPerson')
Ext.namespace('Lino.cv.ObstaclesByPerson')
Ext.namespace('Lino.isip.ContractsByPerson')
Ext.namespace('Lino.isip.ContractsByPolicy')
Ext.namespace('Lino.isip.ContractsByType')
Ext.namespace('Lino.isip.ContractsByEnding')
Ext.namespace('Lino.isip.ContractsByStudyType')
Ext.namespace('Lino.jobs.FunctionsBySector')
Ext.namespace('Lino.jobs.ContractsByPerson')
Ext.namespace('Lino.jobs.ContractsByProvider')
Ext.namespace('Lino.jobs.ContractsByPolicy')
Ext.namespace('Lino.jobs.ContractsByEnding')
Ext.namespace('Lino.jobs.ContractsByJob')
Ext.namespace('Lino.jobs.ContractsByRegime')
Ext.namespace('Lino.jobs.ContractsBySchedule')
Ext.namespace('Lino.jobs.StudiesByCountry')
Ext.namespace('Lino.jobs.StudiesByCity')
Ext.namespace('Lino.jobs.StudiesByPerson')
Ext.namespace('Lino.jobs.ExperiencesByFunction')
Ext.namespace('Lino.jobs.ExperiencesByPerson')
Ext.namespace('Lino.jobs.CandidaturesByPerson')
Ext.namespace('Lino.jobs.CandidaturesBySector')
Ext.namespace('Lino.jobs.CandidaturesByFunction')
Ext.namespace('Lino.jobs.CandidaturesByJob')
Ext.namespace('Lino.jobs.CandidaturesByOffer')
Ext.namespace('Lino.jobs.ExperiencesByOffer')
Ext.namespace('Lino.jobs.JobsByProvider')
Ext.namespace('Lino.jobs.JobsByType')
Ext.namespace('Lino.jobs.ContractsByType')
Ext.namespace('Lino.jobs.JobsOverviewByType')
Ext.namespace('Lino.pcsw.ClientsByNationality')
Ext.namespace('Lino.pcsw.DispensesByClient')
Ext.namespace('Lino.pcsw.ExclusionsByClient')
Ext.namespace('Lino.pcsw.ContactsByClient')
Ext.namespace('Lino.pcsw.CoachingsByClient')
Ext.namespace('Lino.pcsw.CoachingsByUser')
Ext.namespace('Lino.pcsw.CoachingsByEnding')
Ext.namespace('Lino.pcsw.NotesByPerson')
Ext.namespace('Lino.pcsw.NotesByCompany')
Ext.namespace('Lino.reception.CoachingsByClient')
Ext.namespace('Lino.accounts.GroupsByChart')
Ext.namespace('Lino.accounts.AccountsByGroup')
Ext.namespace('Lino.courses.CoursesByOffer')
Ext.namespace('Lino.courses.CourseOffersByProvider')
Ext.namespace('Lino.courses.CourseOffersByContent')
Ext.namespace('Lino.courses.CourseRequestsByPerson')
Ext.namespace('Lino.courses.CourseRequestsByContent')
Ext.namespace('Lino.courses.RequestsByCourse')
Ext.namespace('Lino.courses.ParticipantsByCourse')
Ext.namespace('Lino.courses.CandidatesByCourse')
Ext.namespace('Lino.newcomers.CompetencesByUser')
Ext.namespace('Lino.newcomers.CompetencesByFaculty')
Ext.namespace('Lino.newcomers.MyCompetences')
Ext.namespace('Lino.newcomers.ClientsByFaculty')
Ext.namespace('Lino.newcomers.AvailableCoachesByClient')
Ext.namespace('Lino.debts.MyBudgets')
Ext.namespace('Lino.debts.BudgetsByPartner')
Ext.namespace('Lino.debts.ActorsByBudget')
Ext.namespace('Lino.debts.ActorsByPartner')
Ext.namespace('Lino.debts.EntriesByBudget')
Ext.namespace('Lino.debts.ExpensesByBudget')
Ext.namespace('Lino.debts.IncomesByBudget')
Ext.namespace('Lino.debts.LiabilitiesByBudget')
Ext.namespace('Lino.debts.AssetsByBudget')
Ext.namespace('Lino.debts.DistByBudget')
Ext.namespace('Lino.cbss.MyIdentifyPersonRequests')
Ext.namespace('Lino.cbss.IdentifyRequestsByPerson')
Ext.namespace('Lino.cbss.ManageAccessRequestsByPerson')
Ext.namespace('Lino.cbss.MyManageAccessRequests')
Ext.namespace('Lino.cbss.RetrieveTIGroupsRequestsByPerson')
Ext.namespace('Lino.cbss.MyRetrieveTIGroupsRequests')
Ext.namespace('Lino.uploads.UploadsByController')
Ext.namespace('Lino.system.HelpTextsByModel')
Ext.namespace('Lino.cal.TasksByController')
Ext.namespace('Lino.outbox.MailsByController')
Ext.namespace('Lino.changes.ChangesByMaster')
Ext.namespace('Lino.outbox.AttachmentsByController')
Ext.namespace('Lino.cal.EventsByController')
Ext.namespace('Lino.about.Models')
Ext.namespace('Lino.about.FieldsByModel')
Ext.namespace('Lino.about.Inspector')
Ext.namespace('Lino.about.SourceFiles')
Ext.namespace('Lino.reception.ButtonsTable')
Ext.namespace('Lino.reception.CreateNoteActionsByClient')
Ext.namespace('Lino.integ.UsersWithClients')
Ext.namespace('Lino.integ.CompareRequestsTable')
Ext.namespace('Lino.integ.PeriodicNumbers')
Ext.namespace('Lino.debts.PrintEntriesByBudget')
Ext.namespace('Lino.debts.PrintExpensesByBudget')
Ext.namespace('Lino.debts.PrintIncomesByBudget')
Ext.namespace('Lino.debts.PrintLiabilitiesByBudget')
Ext.namespace('Lino.debts.PrintAssetsByBudget')
Ext.namespace('Lino.debts.SummaryTable')
Ext.namespace('Lino.debts.ResultByBudget')
Ext.namespace('Lino.debts.DebtsByBudget')
Ext.namespace('Lino.debts.BailiffDebtsByBudget')
Ext.namespace('Lino.cbss.IdentifyPersonResult')
Ext.namespace('Lino.cbss.RetrieveTIGroupsResult')
Ext.namespace('Lino.lino.Report')
Ext.namespace('Lino.about.About')
Ext.namespace('Lino.system.Home')
Ext.namespace('Lino.cal.CalendarPanel')
Ext.namespace('Lino.jobs.OldJobsOverview')
Ext.namespace('Lino.jobs.JobsOverview')
Ext.namespace('Lino.integ.ActivityReport')
Ext.namespace('Lino.courses.CourseRequestStates')
Ext.namespace('Lino.cal.DurationUnits')
Ext.namespace('Lino.cal.TaskStates')
Ext.namespace('Lino.cal.Weekdays')
Ext.namespace('Lino.lino.UserLevels')
Ext.namespace('Lino.pcsw.CoachingEvents')
Ext.namespace('Lino.lino.YesNo')
Ext.namespace('Lino.cal.EventStates')
Ext.namespace('Lino.lino.BeIdCardTypes')
Ext.namespace('Lino.accounts.AccountTypes')
Ext.namespace('Lino.cal.Recurrencies')
Ext.namespace('Lino.properties.HowWell')
Ext.namespace('Lino.cv.CefLevel')
Ext.namespace('Lino.jobs.CandidatureStates')
Ext.namespace('Lino.outbox.RecipientType')
Ext.namespace('Lino.cal.EventEvents')
Ext.namespace('Lino.cal.GuestStates')
Ext.namespace('Lino.pcsw.CivilState')
Ext.namespace('Lino.pcsw.ClientStates')
Ext.namespace('Lino.countries.CityTypes')
Ext.namespace('Lino.properties.DoYouLike')
Ext.namespace('Lino.cbss.RequestLanguages')
Ext.namespace('Lino.cbss.ManageAction')
Ext.namespace('Lino.pcsw.RefusalReasons')
Ext.namespace('Lino.lino.UserGroups')
Ext.namespace('Lino.cbss.RequestStates')
Ext.namespace('Lino.lino.ChangeTypes')
Ext.namespace('Lino.cal.AccessClasses')
Ext.namespace('Lino.cbss.QueryRegister')
Ext.namespace('Lino.isip.ContractEvents')
Ext.namespace('Lino.lino.Genders')
Ext.namespace('Lino.pcsw.ClientEvents')
Ext.namespace('Lino.lino.UserProfiles')
Ext.namespace('Lino.pcsw.ResidenceType')

// ChoiceLists: 
Lino.courses.CourseRequestStates = [ [ "10", "Offen" ], [ "20", "Eingetragen" ], [ "30", "Bestanden" ], [ "40", "Gut bestanden" ], [ "50", "Nicht bestanden" ], [ "60", "Abgebrochen" ], [ "70", "Inaktiv" ] ];
Lino.cal.DurationUnits = [ [ "s", "Sekunden" ], [ "m", "Minuten" ], [ "h", "Stunden" ], [ "D", "Tage" ], [ "W", "Wochen" ], [ "M", "Monate" ], [ "Y", "Jahre" ] ];
Lino.cal.TaskStates = [ [ "10", "Zu tun" ], [ "20", "Begonnen" ], [ "30", "Erledigt" ], [ "50", "Storniert" ] ];
Lino.cal.Weekdays = [ [ "1", "Montag" ], [ "2", "Dienstag" ], [ "3", "Mittwoch" ], [ "4", "Donnerstag" ], [ "5", "Freitag" ], [ "6", "Samstag" ], [ "7", "Sonntag" ] ];
Lino.lino.UserLevels = [ [ "10", "Gast" ], [ "30", "Benutzer" ], [ "40", "Manager" ], [ "50", "Verwalter" ], [ "90", "Experte" ] ];
Lino.pcsw.CoachingEvents = [ [ "10", "Begonnen" ], [ "20", "Aktiv" ], [ "30", "Beendet" ] ];
Lino.lino.YesNo = [ [ "y", "Ja" ], [ "n", "Nein" ] ];
Lino.cal.EventStates = [ [ "10", "Vorgeschlagen" ], [ "20", "Entwurf" ], [ "50", "Stattgefunden" ], [ "70", "Storniert" ], [ "40", "Geplant" ] ];
Lino.lino.BeIdCardTypes = [ [ "1", "Belgischer Staatsb\u00fcrger" ], [ "6", "Kind unter 12 Jahren" ], [ "11", "A (Bescheinigung der Eintragung im Ausl\u00e4nderregister - Vor\u00fcbergehender Aufenthalt)" ], [ "12", "B (Bescheinigung der Eintragung im Ausl\u00e4nderregister)" ], [ "13", "C (Personalausweis f\u00fcr Ausl\u00e4nder)" ], [ "14", "D (Daueraufenthalt - EG)" ], [ "15", "E (Anmeldebescheinigung)" ], [ "16", "E+" ], [ "17", "F (Aufenthaltskarte f\u00fcr Familienangeh\u00f6rige eines Unionsb\u00fcrgers)" ], [ "18", "F+" ] ];
Lino.accounts.AccountTypes = [ [ "A", "Verm\u00f6gen" ], [ "L", "Verpflichtungen" ], [ "I", "Eink\u00fcnfte" ], [ "E", "Ausgaben" ], [ "C", "Kapital" ], [ "B", "Bankkonten" ] ];
Lino.cal.Recurrencies = [ [ "D", "t\u00e4glich" ], [ "W", "w\u00f6chentlich" ], [ "M", "monatlich" ], [ "Y", "j\u00e4hrlich" ], [ "P", "pro Wochentag" ] ];
Lino.properties.HowWell = [ [ "0", "gar nicht" ], [ "1", "ein bisschen" ], [ "2", "mittelm\u00e4\u00dfig" ], [ "3", "gut" ], [ "4", "sehr gut" ] ];
Lino.cv.CefLevel = [ [ "A1", "A1 (Elementare Sprachverwendung)" ], [ "A2", "A2 (Elementare Sprachverwendung)" ], [ "A2+", "A2+ (Elementare Sprachverwendung)" ], [ "B1", "B1 (Selbstst\u00e4ndige Sprachverwendung)" ], [ "B2", "B2 (Selbstst\u00e4ndige Sprachverwendung)" ], [ "B2+", "B2+ (Selbstst\u00e4ndige Sprachverwendung)" ], [ "C1", "C1 (Exzellente Sprachverwendung)" ], [ "C2", "C2 (Exzellente Sprachverwendung)" ], [ "C2+", "C2+ (Exzellente Sprachverwendung)" ] ];
Lino.jobs.CandidatureStates = [ [ "10", "Aktiv" ], [ "20", "Probezeit" ], [ "25", "Probezeit ohne Erfolg" ], [ "27", "Arbeitet" ], [ "30", "Inaktiv" ] ];
Lino.outbox.RecipientType = [ [ "to", "Empf\u00e4nger" ], [ "cc", "Kopie an" ], [ "bcc", "Blindkopie an" ] ];
Lino.cal.EventEvents = [ [ "10", "Okay" ], [ "20", "Pending" ] ];
Lino.cal.GuestStates = [ [ "10", "Eingeladen" ], [ "20", "Zugesagt" ], [ "30", "Abgesagt" ], [ "40", "Anwesend" ], [ "50", "Abwesend" ] ];
Lino.pcsw.CivilState = [ [ "10", "Ledig" ], [ "13", "Ledig zusammenwohnend" ], [ "18", "Ledig mit Kind" ], [ "20", "Verheiratet" ], [ "21", "Verheirated (allein lebend)" ], [ "22", "Verheirated (mit anderem Partner lebend)" ], [ "30", "Verwitwet" ], [ "33", "Verwitwet (zusammenwohnend)" ], [ "40", "Geschieden" ], [ "50", "Getrennt von Tisch und Bett" ] ];
Lino.pcsw.ClientStates = [ [ "10", "Neuantrag" ], [ "20", "Abgelehnt" ], [ "30", "Begleitet" ], [ "50", "Ehemalig" ] ];
Lino.countries.CityTypes = [ [ "10", "Bundesland" ], [ "11", "Division" ], [ "12", "Region" ], [ "13", "Gemeinschaft" ], [ "14", "Territorium" ], [ "20", "Regierungsbezirk" ], [ "21", "Provinz" ], [ "22", "Grafschaft" ], [ "23", "Unterregion" ], [ "24", "Departement" ], [ "25", "Arrondissement" ], [ "26", "Pr\u00e4fektur" ], [ "27", "Distrikt" ], [ "28", "Sektor" ], [ "50", "Stadt" ], [ "51", "Kleinstadt" ], [ "52", "Gemeinde" ], [ "54", "Pfarre" ], [ "55", "Stadtteil" ], [ "56", "Viertel" ], [ "61", "Ortschaft" ], [ "62", "Kleine Ortschaft" ], [ "70", "Dorf" ] ];
Lino.properties.DoYouLike = [ [ "0", "blo\u00df nicht" ], [ "1", "eher nicht" ], [ "2", "normal" ], [ "3", "gerne" ], [ "4", "sehr gerne" ] ];
Lino.cbss.RequestLanguages = [ [ "nl", "Niederl\u00e4ndisch" ], [ "fr", "Franz\u00f6sisch" ], [ "de", "Deutsch" ] ];
Lino.cbss.ManageAction = [ [ "1", "Registrieren" ], [ "2", "Austragen" ], [ "3", "Auflisten" ] ];
Lino.pcsw.RefusalReasons = [ [ "10", "Information (keine Begleitung erforderlich)" ], [ "20", "\u00d6SHZ ist nicht zust\u00e4ndig" ], [ "30", "Antragsteller ist nicht zur\u00fcck gekommen" ] ];
Lino.lino.UserGroups = [ [ "office", "office (B\u00fcro)" ], [ "reception", "reception (Empfang)" ], [ "accounting", "accounting (Buchhaltung)" ], [ "integ", "integ (DSBE)" ], [ "newcomers", "newcomers (Neuantr\u00e4ge)" ], [ "debts", "debts (Schuldnerberatung)" ], [ "cbss", "cbss (ZDSS)" ] ];
Lino.cbss.RequestStates = [ [ "10", "Versendet" ], [ "20", "Fehlgeschlagen" ], [ "25", "Validiert" ], [ "30", "OK" ], [ "40", "Warnungen" ], [ "50", "Fehlermeldungen" ] ];
Lino.lino.ChangeTypes = [ [ "C", "Erstellen" ], [ "U", "Aktualisierung" ], [ "D", "L\u00f6schen" ], [ "R", "Remove child" ], [ "A", "Add child" ], [ "M", "Fusionieren" ] ];
Lino.cal.AccessClasses = [ [ "10", "Privat" ], [ "20", "halb \u00f6ffentlich (\"Besch\u00e4ftigt\")" ], [ "30", "\u00d6ffentlich" ] ];
Lino.cbss.QueryRegister = [ [ "1", "Prim\u00e4r" ], [ "2", "Sekund\u00e4r" ], [ "3", "Alle" ] ];
Lino.isip.ContractEvents = [ [ "10", "Begonnen" ], [ "20", "Aktiv" ], [ "30", "Beendet" ], [ "40", "Unterschrieben" ] ];
Lino.lino.Genders = [ [ "M", "M\u00e4nnlich" ], [ "F", "Weiblich" ] ];
Lino.pcsw.ClientEvents = [ [ "10", "Aktiv" ], [ "20", "VSE" ], [ "21", "Art.60\u00a77-Konvention" ], [ "22", "Dispenz" ], [ "30", "AG-Sperre" ], [ "40", "Note" ], [ "50", "Erstellt" ], [ "60", "Bearbeitet" ] ];
Lino.lino.UserProfiles = [ [ "000", "000 (Anonym)" ], [ "100", "100 (Begleiter im DSBE)" ], [ "110", "110 (Integrations-Assistent (Manager))" ], [ "200", "200 (Berater Neuantr\u00e4ge)" ], [ "210", "210 (Empfangsschalter)" ], [ "300", "300 (Schuldenberater)" ], [ "500", "500 (nur ZDSS)" ], [ "900", "900 (Verwalter)" ] ];
Lino.pcsw.ResidenceType = [ [ "1", "Bev\u00f6lkerungsregister" ], [ "2", "Fremdenregister" ], [ "3", "Warteregister" ] ];

Lino.pcsw.CoachingsByClient.ParamsPanel = Ext.extend(Ext.form.FormPanel,{
  autoScroll: false,
  autoHeight: true,
  border: false,
  layout: "form",
  hideCheckBoxLabels: true,
  frame: true,
  bodyBorder: false,
  labelAlign: "top",
  initComponent : function() {
    var containing_panel = this;
    var start_date377 = new Lino.DateField({ "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Periode vom","(pcsw.Coachings.start_date) Start date of observed period") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Periode vom</span>", "anchor": "-20", "name": "start_date" });
    var end_date378 = new Lino.DateField({ "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("bis","(pcsw.Coachings.end_date) End date of observed period") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">bis</span>", "anchor": "-20", "name": "end_date" });
    var observed_event379 = new Lino.ChoicesFieldElement({ "forceSelection": true, "fieldLabel": "Beobachtungskriterium", "name": "observed_event", "hiddenName": "observed_eventHidden", "listeners": { "render": Lino.quicktip_renderer("Beobachtungskriterium","(pcsw.Coachings.observed_event) ") }, "selectOnFocus": true, "anchor": "-20", "store": [['','<br>']].concat(Lino.pcsw.CoachingEvents) });
    var coached_by380 = new Lino.TwinCombo({ "preferred_width": 15, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Begleitet durch</span>", "name": "coached_by", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.users.Users.detail)}, "hiddenName": "coached_byHidden", "listeners": { "render": Lino.quicktip_renderer("Begleitet durch","(pcsw.Coachings.coached_by) Nur Begleitungen dieses Benutzers.") }, "selectOnFocus": true, "emptyText": "Benutzer ausw\u00e4hlen...", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/pcsw/Coachings/coached_by", "method": "GET" }) }) });
    var and_coached_by381 = new Lino.TwinCombo({ "preferred_width": 15, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">und durch</span>", "name": "and_coached_by", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.users.Users.detail)}, "hiddenName": "and_coached_byHidden", "listeners": { "render": Lino.quicktip_renderer("und durch","(pcsw.Coachings.and_coached_by) ... und auch Begleitungen dieses Benutzers.") }, "selectOnFocus": true, "emptyText": "Benutzer ausw\u00e4hlen...", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/pcsw/Coachings/and_coached_by", "method": "GET" }) }) });
    var main_1_panel382 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 12, "autoHeight": true, "layout": "form", "xtype": "panel", "items": start_date377, "labelAlign": "top" }, { "flex": 12, "autoHeight": true, "layout": "form", "xtype": "panel", "items": end_date378, "labelAlign": "top" }, { "flex": 15, "autoHeight": true, "layout": "form", "xtype": "panel", "items": observed_event379, "labelAlign": "top" }, { "flex": 30, "autoHeight": true, "layout": "form", "xtype": "panel", "items": coached_by380, "labelAlign": "top" }, { "flex": 30, "autoHeight": true, "layout": "form", "xtype": "panel", "items": and_coached_by381, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 198, "border": false, "anchor": "-20", "labelAlign": "top" });
    var primary_coachings388 = new Lino.ChoicesFieldElement({ "forceSelection": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Prim\u00e4re Begleitungen</span>", "name": "primary_coachings", "hiddenName": "primary_coachingsHidden", "listeners": { "render": Lino.quicktip_renderer("Prim\u00e4re Begleitungen","(pcsw.Coachings.primary_coachings) Accompagnements primaires.") }, "selectOnFocus": true, "anchor": "-20", "store": [['','<br>']].concat(Lino.lino.YesNo) });
    var coaching_type389 = new Lino.RemoteComboFieldElement({ "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Dienst</span>", "name": "coaching_type", "pageSize": 20, "emptyText": "Dienst ausw\u00e4hlen...", "listeners": { "render": Lino.quicktip_renderer("Dienst","(pcsw.Coachings.coaching_type) Nur Begleitungen dieses Dienstes.") }, "selectOnFocus": true, "hiddenName": "coaching_typeHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/pcsw/Coachings/coaching_type", "method": "GET" }) }) });
    var ending390 = new Lino.TwinCombo({ "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Beendigungsgrund</span>", "name": "ending", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.pcsw.CoachingEndings.detail)}, "emptyText": "Beendigungsgrund ausw\u00e4hlen...", "listeners": { "render": Lino.quicktip_renderer("Beendigungsgrund","(pcsw.Coachings.ending) Nur Begleitungen mit diesem Beendigungsgrund.") }, "selectOnFocus": true, "hiddenName": "endingHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/pcsw/Coachings/ending", "method": "GET" }) }) });
    var main_2_panel391 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 14, "autoHeight": true, "layout": "form", "xtype": "panel", "items": primary_coachings388, "labelAlign": "top" }, { "flex": 42, "autoHeight": true, "layout": "form", "xtype": "panel", "items": coaching_type389, "labelAlign": "top" }, { "flex": 42, "autoHeight": true, "layout": "form", "xtype": "panel", "items": ending390, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 189, "border": false, "anchor": "-20", "labelAlign": "top" });
    this.items = [ main_1_panel382, main_2_panel391 ];
    this.fields = [ start_date377, end_date378, observed_event379, coached_by380, and_coached_by381, primary_coachings388, coaching_type389, ending390 ];
    Lino.pcsw.CoachingsByClient.ParamsPanel.superclass.initComponent.call(this);
  }
});


Lino.reception.AppointmentsByGuest.wf2_ActionFormPanel = Ext.extend(Lino.ActionFormPanel,{
  autoScroll: false,
  border: false,
  layout: "vbox",
  labelWidth: 270,
  hideCheckBoxLabels: true,
  frame: true,
  layoutConfig: { "align": "stretch" },
  bodyBorder: false,
  labelAlign: "top",
  action_name: 'wf2',
  ls_url: "/reception/AppointmentsByGuest",
  window_title: "Absagen",
  initComponent : function() {
    var containing_panel = this;
    var notify_subject13 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Summary","(<RejectInvitation wf2 (u'Reject')>.notify_subject) ") }, "fieldLabel": "Kurzbeschreibung", "name": "notify_subject", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var notify_body14 = new Ext.form.TextArea({ "listeners": { "render": Lino.quicktip_renderer("Description","(<RejectInvitation wf2 (u'Reject')>.notify_body) ") }, "fieldLabel": "Beschreibung", "name": "notify_body", "growMax": 2000, "selectOnFocus": true, "anchor": "-20 -10" });
    var notify_silent15 = new Ext.form.Checkbox({ "boxLabel": "Keine Benachrichtigung per E-Mail schicken", "listeners": { "render": Lino.quicktip_renderer("Don't send email notification","(<RejectInvitation wf2 (u'Reject')>.notify_silent) ") }, "hideLabel": true, "checked": false, "name": "notify_silent", "selectOnFocus": true, "anchor": "-20" });
    this.items = [ { "items": notify_subject13, "autoHeight": true, "layout": "form", "xtype": "panel", "labelAlign": "top" }, { "items": notify_body14, "labelAlign": "top", "layout": "form", "xtype": "panel", "flex": 71 }, { "items": notify_silent15, "autoHeight": true, "layout": "form", "xtype": "panel", "labelAlign": "top" } ];
    this.fields = [ notify_subject13, notify_body14, notify_silent15 ];
    Lino.reception.AppointmentsByGuest.wf2_ActionFormPanel.superclass.initComponent.call(this);
  }
});


Lino.reception.AppointmentsByGuest.checkin_ActionFormPanel = Ext.extend(Lino.ActionFormPanel,{
  autoScroll: false,
  border: false,
  layout: "vbox",
  labelWidth: 270,
  hideCheckBoxLabels: true,
  frame: true,
  layoutConfig: { "align": "stretch" },
  bodyBorder: false,
  labelAlign: "top",
  action_name: 'checkin',
  ls_url: "/reception/AppointmentsByGuest",
  window_title: "Einchecken",
  initComponent : function() {
    var containing_panel = this;
    var notify_subject20 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Summary","(<CheckinGuest checkin (u'Checkin')>.notify_subject) ") }, "fieldLabel": "Kurzbeschreibung", "name": "notify_subject", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var notify_body21 = new Ext.form.TextArea({ "listeners": { "render": Lino.quicktip_renderer("Description","(<CheckinGuest checkin (u'Checkin')>.notify_body) ") }, "fieldLabel": "Beschreibung", "name": "notify_body", "growMax": 2000, "selectOnFocus": true, "anchor": "-20 -10" });
    var notify_silent22 = new Ext.form.Checkbox({ "boxLabel": "Keine Benachrichtigung per E-Mail schicken", "listeners": { "render": Lino.quicktip_renderer("Don't send email notification","(<CheckinGuest checkin (u'Checkin')>.notify_silent) ") }, "hideLabel": true, "checked": false, "name": "notify_silent", "selectOnFocus": true, "anchor": "-20" });
    this.items = [ { "items": notify_subject20, "autoHeight": true, "layout": "form", "xtype": "panel", "labelAlign": "top" }, { "items": notify_body21, "labelAlign": "top", "layout": "form", "xtype": "panel", "flex": 71 }, { "items": notify_silent22, "autoHeight": true, "layout": "form", "xtype": "panel", "labelAlign": "top" } ];
    this.fields = [ notify_subject20, notify_body21, notify_silent22 ];
    Lino.reception.AppointmentsByGuest.checkin_ActionFormPanel.superclass.initComponent.call(this);
  }
});


Lino.reception.AppointmentsByGuest.wf1_ActionFormPanel = Ext.extend(Lino.ActionFormPanel,{
  autoScroll: false,
  border: false,
  layout: "vbox",
  labelWidth: 270,
  hideCheckBoxLabels: true,
  frame: true,
  layoutConfig: { "align": "stretch" },
  bodyBorder: false,
  labelAlign: "top",
  action_name: 'wf1',
  ls_url: "/reception/AppointmentsByGuest",
  window_title: "Zusagen",
  initComponent : function() {
    var containing_panel = this;
    var notify_subject6 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Summary","(<AcceptInvitation wf1 (u'Accept')>.notify_subject) ") }, "fieldLabel": "Kurzbeschreibung", "name": "notify_subject", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var notify_body7 = new Ext.form.TextArea({ "listeners": { "render": Lino.quicktip_renderer("Description","(<AcceptInvitation wf1 (u'Accept')>.notify_body) ") }, "fieldLabel": "Beschreibung", "name": "notify_body", "growMax": 2000, "selectOnFocus": true, "anchor": "-20 -10" });
    var notify_silent8 = new Ext.form.Checkbox({ "boxLabel": "Keine Benachrichtigung per E-Mail schicken", "listeners": { "render": Lino.quicktip_renderer("Don't send email notification","(<AcceptInvitation wf1 (u'Accept')>.notify_silent) ") }, "hideLabel": true, "checked": false, "name": "notify_silent", "selectOnFocus": true, "anchor": "-20" });
    this.items = [ { "items": notify_subject6, "autoHeight": true, "layout": "form", "xtype": "panel", "labelAlign": "top" }, { "items": notify_body7, "labelAlign": "top", "layout": "form", "xtype": "panel", "flex": 71 }, { "items": notify_silent8, "autoHeight": true, "layout": "form", "xtype": "panel", "labelAlign": "top" } ];
    this.fields = [ notify_subject6, notify_body7, notify_silent8 ];
    Lino.reception.AppointmentsByGuest.wf1_ActionFormPanel.superclass.initComponent.call(this);
  }
});


Lino.pcsw.CoachingsByClient.create_visit_ActionFormPanel = Ext.extend(Lino.ActionFormPanel,{
  autoScroll: false,
  autoHeight: true,
  border: false,
  layout: "form",
  labelWidth: 63,
  hideCheckBoxLabels: true,
  frame: true,
  bodyBorder: false,
  labelAlign: "top",
  action_name: 'create_visit',
  ls_url: "/pcsw/CoachingsByClient",
  window_title: "Create visit",
  autoHeight: true,
  initComponent : function() {
    var containing_panel = this;
    var user48 = new Lino.TwinCombo({ "preferred_width": 15, "fieldLabel": "Benutzer", "allowBlank": false, "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.users.Users.detail)}, "emptyText": "Benutzer ausw\u00e4hlen...", "listeners": { "render": Lino.quicktip_renderer("User","(<CreateCoachingVisit create_visit (u'Create visit')>.user) ") }, "selectOnFocus": true, "hiddenName": "userHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/apchoices/pcsw/Coachings/create_visit/user", "method": "GET" }) }), "name": "user" });
    var summary49 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Reason","(<CreateCoachingVisit create_visit (u'Create visit')>.summary) ") }, "fieldLabel": "Begr\u00fcndung", "name": "summary", "maxLength": null, "selectOnFocus": true, "anchor": "-20" });
    this.items = [ { "autoHeight": true, "layout": "form", "xtype": "panel", "items": user48, "anchor": "-20", "labelAlign": "top" }, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": summary49, "anchor": "-20", "labelAlign": "top" } ];
    this.fields = [ user48, summary49 ];
    Lino.pcsw.CoachingsByClient.create_visit_ActionFormPanel.superclass.initComponent.call(this);
  }
});


Lino.outbox.MailsByUser.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 26,
  initComponent : function() {
    var containing_panel = this;
    var subject954 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Betreff","(outbox.Mails.subject) ") }, "fieldLabel": "Betreff", "name": "subject", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var project955 = new Lino.TwinCombo({ "preferred_width": 20, "fieldLabel": "Klient", "name": "project", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.pcsw.Clients.detail)}, "hiddenName": "projectHidden", "listeners": { "render": Lino.quicktip_renderer("Klient","(outbox.Mails.project) ") }, "selectOnFocus": true, "emptyText": "Klient ausw\u00e4hlen...", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/outbox/Mails/project", "method": "GET" }) }) });
    var date956 = new Lino.DateField({ "listeners": { "render": Lino.quicktip_renderer("Datum","(outbox.Mails.date) \n        The official date to be printed on the document.\n        ") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Datum</span>", "name": "date", "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var main_1_panel957 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 72, "hideCheckBoxLabels": true, "items": [ { "flex": 42, "autoHeight": true, "layout": "form", "xtype": "panel", "items": subject954, "labelAlign": "top" }, { "flex": 40, "autoHeight": true, "layout": "form", "xtype": "panel", "items": project955, "labelAlign": "top" }, { "flex": 16, "autoHeight": true, "layout": "form", "xtype": "panel", "items": date956, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var user961 = new Lino.TwinCombo({ "preferred_width": 15, "fieldLabel": "Absender", "name": "user", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.users.Users.detail)}, "hiddenName": "userHidden", "listeners": { "render": Lino.quicktip_renderer("Absender","(outbox.Mails.user) ") }, "selectOnFocus": true, "emptyText": "Benutzer ausw\u00e4hlen...", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/outbox/Mails/user", "method": "GET" }) }) });
    var sent962 = new Ext.form.DisplayField({ "disabled": true, "listeners": { "render": Lino.quicktip_renderer("sent","(outbox.Mails.sent) ") }, "fieldLabel": "sent", "name": "sent", "anchor": "-20", "value": "<br>" });
    var id963 = new Ext.form.NumberField({ "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("ID","(outbox.Mails.id) ") }, "fieldLabel": "ID", "anchor": "-20", "name": "id" });
    var owner_disp964 = new Ext.form.DisplayField({ "disabled": true, "fieldLabel": "Verkn\u00fcpft mit", "anchor": "-20", "name": "owner" });
    var main_2_panel965 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 126, "hideCheckBoxLabels": true, "items": [ { "flex": 39, "autoHeight": true, "layout": "form", "xtype": "panel", "items": user961, "labelAlign": "top" }, { "flex": 31, "autoHeight": true, "layout": "form", "xtype": "panel", "items": sent962, "labelAlign": "top" }, { "flex": 9, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id963, "labelAlign": "top" }, { "flex": 19, "autoHeight": true, "layout": "form", "xtype": "panel", "items": owner_disp964, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var RecipientsByMail_grid976 = new Lino.outbox.RecipientsByMail.GridPanel({ "flex": 55, "listeners": { "render": Lino.quicktip_renderer("Empf\u00e4nger","(outbox.outbox.RecipientsByMail) ") }, "hide_top_toolbar": true, "containing_panel": this, "tools": [ Lino.show_in_own_window_button(Lino.outbox.RecipientsByMail.grid) ], "master_panel": this });
    var AttachmentsByMail_htmlbox977 = new Lino.HtmlBoxPanel({ "flex": 22, "layout": "fit", "name": "AttachmentsByMail", "containing_panel": this, "items": new Ext.BoxComponent({autoScroll:true}), "title": "Anh\u00e4nge", "master_panel": this, "value": "<br/>", "always_enabled": true, "listeners": { "render": Lino.quicktip_renderer("Anh\u00e4nge","(outbox.Mails.AttachmentsByMail) ") }, "bodyStyle": "overflow-x:hidden;", "tools": [ Lino.show_in_own_window_button(Lino.outbox.AttachmentsByMail.grid) ] });
    var UploadsByController_htmlbox978 = new Lino.HtmlBoxPanel({ "flex": 22, "ls_bbar_actions": [ { "itemId": "insert", "menu_item_text": "Neu", "must_save": true, "tooltip": "Neuen Datensatz erstellen", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-new", "overflowText": "Neu", "auto_save": true } ], "name": "UploadsByController", "containing_panel": this, "items": new Ext.BoxComponent({autoScroll:true}), "title": "Uploads", "master_panel": this, "value": "<br/>", "always_enabled": true, "listeners": { "render": Lino.quicktip_renderer("Uploads","(outbox.Mails.UploadsByController) ") }, "bodyStyle": "overflow-x:hidden;", "ls_insert_handler": Lino.uploads.UploadsByController.insert, "layout": "fit", "tools": [ Lino.show_in_own_window_button(Lino.uploads.UploadsByController.grid) ] });
    var main_3_panel979 = new Ext.Panel({ "flex": 29, "border": false, "layout": "hbox", "labelWidth": 72, "hideCheckBoxLabels": true, "items": [ RecipientsByMail_grid976, AttachmentsByMail_htmlbox977, UploadsByController_htmlbox978 ], "autoScroll": false, "layoutConfig": { "align": "stretch" }, "frame": false, "labelAlign": "top" });
    var body980 = new Lino.RichTextPanel({ "selectOnFocus": true, "flex": 58, "containing_panel": this, "name": "body", "title": "Inhalt" });
    var main_panel981 = new Ext.Panel({ "autoScroll": false, "border": false, "layout": "vbox", "labelWidth": 0, "hideCheckBoxLabels": true, "items": [ main_1_panel957, main_2_panel965, main_3_panel979, body980 ], "frame": true, "layoutConfig": { "align": "stretch" }, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel981;
    this.before_row_edit = function(record) {
      RecipientsByMail_grid976.on_master_changed();
      AttachmentsByMail_htmlbox977.refresh();
      UploadsByController_htmlbox978.refresh();
      body980.refresh();
    }
    Lino.outbox.MailsByUser.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.outbox.MailsByUser.InsertFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 26,
  initComponent : function() {
    var containing_panel = this;
    var project982 = new Lino.TwinCombo({ "preferred_width": 20, "fieldLabel": "Klient", "name": "project", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.pcsw.Clients.detail)}, "hiddenName": "projectHidden", "listeners": { "render": Lino.quicktip_renderer("Klient","(outbox.Mails.project) ") }, "selectOnFocus": true, "emptyText": "Klient ausw\u00e4hlen...", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/outbox/Mails/project", "method": "GET" }) }) });
    var subject983 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Betreff","(outbox.Mails.subject) ") }, "fieldLabel": "Betreff", "name": "subject", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var body984 = new Lino.RichTextPanel({ "selectOnFocus": true, "flex": 71, "containing_panel": this, "name": "body", "title": "Inhalt" });
    var main_panel985 = new Ext.Panel({ "autoScroll": false, "border": false, "layout": "vbox", "labelWidth": 72, "hideCheckBoxLabels": true, "items": [ { "items": project982, "autoHeight": true, "layout": "form", "xtype": "panel", "labelAlign": "top" }, { "items": subject983, "autoHeight": true, "layout": "form", "xtype": "panel", "labelAlign": "top" }, body984 ], "frame": true, "layoutConfig": { "align": "stretch" }, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel985;
    this.before_row_edit = function(record) {
      body984.refresh();
    }
    Lino.outbox.MailsByUser.InsertFormPanel.superclass.initComponent.call(this);
  }
});


Lino.cbss.IdentifyPersonRequests.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 92,
  initComponent : function() {
    var containing_panel = this;
    var id3482 = new Ext.form.NumberField({ "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("ID","(cbss.IdentifyPersonRequests.id) ") }, "fieldLabel": "ID", "anchor": "-20", "name": "id" });
    var person3483 = new Lino.TwinCombo({ "preferred_width": 20, "fieldLabel": "Klient", "allowBlank": false, "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.pcsw.Clients.detail)}, "emptyText": "Klient ausw\u00e4hlen...", "listeners": { "render": Lino.quicktip_renderer("Klient","(cbss.IdentifyPersonRequests.person) ") }, "selectOnFocus": true, "hiddenName": "personHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cbss/IdentifyPersonRequests/person", "method": "GET" }) }), "name": "person" });
    var user3484 = new Lino.TwinCombo({ "preferred_width": 15, "fieldLabel": "Autor", "allowBlank": false, "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.users.Users.detail)}, "emptyText": "Benutzer ausw\u00e4hlen...", "listeners": { "render": Lino.quicktip_renderer("Autor","(cbss.IdentifyPersonRequests.user) ") }, "selectOnFocus": true, "hiddenName": "userHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cbss/IdentifyPersonRequests/user", "method": "GET" }) }), "name": "user" });
    var environment3485 = new Ext.form.TextField({ "disabled": true, "listeners": { "render": Lino.quicktip_renderer("T/A/B","(cbss.IdentifyPersonRequests.environment) ") }, "fieldLabel": "T/A/B", "name": "environment", "maxLength": 4, "boxMinWidth": Lino.chars2width(4), "anchor": "-20" });
    var sent3486 = new Ext.form.DisplayField({ "disabled": true, "listeners": { "render": Lino.quicktip_renderer("Versendet","(cbss.IdentifyPersonRequests.sent) The date and time when this request has been executed. \nThis is empty for requests than haven't been sent.\nRead-only.") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Versendet</span>", "name": "sent", "anchor": "-20", "value": "<br>" });
    var status3487 = new Lino.ChoicesFieldElement({ "forceSelection": true, "fieldLabel": "Zustand", "name": "status", "hiddenName": "statusHidden", "disabled": true, "listeners": { "render": Lino.quicktip_renderer("Zustand","(cbss.IdentifyPersonRequests.status) ") }, "anchor": "-20", "store": [['','<br>']].concat(Lino.cbss.RequestStates) });
    var ticket3488 = new Ext.form.TextField({ "disabled": true, "listeners": { "render": Lino.quicktip_renderer("Ticket","(cbss.IdentifyPersonRequests.ticket) ") }, "fieldLabel": "Ticket", "name": "ticket", "maxLength": 36, "anchor": "-20" });
    var info_1_panel3489 = new Ext.form.FieldSet({ "autoHeight": true, "layout": "hbox", "title": "Info zur Anfrage", "layoutConfig": { "align": "stretchmax" }, "frame": false, "bodyBorder": true, "autoScroll": false, "items": [ { "flex": 5, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id3482, "labelAlign": "top" }, { "flex": 20, "autoHeight": true, "layout": "form", "xtype": "panel", "items": person3483, "labelAlign": "top" }, { "flex": 20, "autoHeight": true, "layout": "form", "xtype": "panel", "items": user3484, "labelAlign": "top" }, { "flex": 5, "autoHeight": true, "layout": "form", "xtype": "panel", "items": environment3485, "labelAlign": "top" }, { "flex": 16, "autoHeight": true, "layout": "form", "xtype": "panel", "items": sent3486, "labelAlign": "top" }, { "flex": 12, "autoHeight": true, "layout": "form", "xtype": "panel", "items": status3487, "labelAlign": "top" }, { "flex": 21, "autoHeight": true, "layout": "form", "xtype": "panel", "items": ticket3488, "labelAlign": "top" } ], "hideCheckBoxLabels": true, "labelWidth": 90, "border": false, "labelAlign": "top" });
    var national_id3497 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("NR-Nummer","(cbss.IdentifyPersonRequests.national_id) ") }, "fieldLabel": "NR-Nummer", "name": "national_id", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var p1_panel3499 = new Ext.form.FieldSet({ "flex": 25, "layout": "vbox", "title": "Suche per NISS", "layoutConfig": { "align": "stretch" }, "frame": true, "bodyBorder": false, "autoScroll": false, "items": [ { "items": national_id3497, "autoHeight": true, "layout": "form", "xtype": "panel", "labelAlign": "top" }, { "flex": 50, "html": "<br/>", "xtype": "label" } ], "hideCheckBoxLabels": true, "labelWidth": 90, "border": false, "labelAlign": "top" });
    var first_name3501 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Vorname","(cbss.IdentifyPersonRequests.first_name) ") }, "fieldLabel": "Vorname", "name": "first_name", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var middle_name3502 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Mittelnamen","(cbss.IdentifyPersonRequests.middle_name) Whatever this means...") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Mittelnamen</span>", "name": "middle_name", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var last_name3503 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Familienname","(cbss.IdentifyPersonRequests.last_name) ") }, "fieldLabel": "Familienname", "name": "last_name", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var p2_1_panel3504 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": first_name3501, "labelAlign": "top" }, { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": middle_name3502, "labelAlign": "top" }, { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": last_name3503, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 117, "border": false, "anchor": "-20", "labelAlign": "top" });
    var birth_date3508 = new Lino.IncompleteDateField({ "listeners": { "render": Lino.quicktip_renderer("Geburtsdatum","(cbss.IdentifyPersonRequests.birth_date) Uncomplete dates are allowed, e.g. \n\"00.00.1980\" means \"some day in 1980\", \n\"00.07.1980\" means \"in July 1980\"\nor \"23.07.0000\" means \"on a 23th of July\".") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Geburtsdatum</span>", "name": "birth_date", "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var tolerance3509 = new Ext.form.NumberField({ "listeners": { "render": Lino.quicktip_renderer("Toleranz","(cbss.IdentifyPersonRequests.tolerance) \n      Falls Monat oder Tag des Geburtsdatums unbekannt sind, \n      um wieviel Monate bzw. Tage die Suche nach unten/oben ausgeweitet wird.\n      G\u00fcltige Werte: 0 bis 10.\n      ") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Toleranz</span>", "name": "tolerance", "selectOnFocus": true, "anchor": "-20", "value": 0, "allowBlank": false });
    var gender3510 = new Lino.ChoicesFieldElement({ "forceSelection": true, "fieldLabel": "Geschlecht", "name": "gender", "hiddenName": "genderHidden", "listeners": { "render": Lino.quicktip_renderer("Geschlecht","(cbss.IdentifyPersonRequests.gender) ") }, "selectOnFocus": true, "anchor": "-20", "store": [['','<br>']].concat(Lino.lino.Genders) });
    var p2_2_panel3511 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 46, "autoHeight": true, "layout": "form", "xtype": "panel", "items": birth_date3508, "labelAlign": "top" }, { "flex": 19, "autoHeight": true, "layout": "form", "xtype": "panel", "items": tolerance3509, "labelAlign": "top" }, { "flex": 34, "autoHeight": true, "layout": "form", "xtype": "panel", "items": gender3510, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 117, "border": false, "anchor": "-20", "labelAlign": "top" });
    var p2_panel3515 = new Ext.form.FieldSet({ "flex": 75, "autoHeight": true, "layout": "form", "title": "Phonetische Suche", "items": [ p2_1_panel3504, p2_2_panel3511 ], "frame": true, "bodyBorder": false, "autoScroll": false, "hideCheckBoxLabels": true, "border": false, "labelAlign": "top" });
    var parameters_panel3516 = new Ext.form.FieldSet({ "autoHeight": true, "layout": "hbox", "title": "Parameter", "layoutConfig": { "align": "stretchmax" }, "frame": false, "bodyBorder": true, "autoScroll": false, "items": [ p1_panel3499, p2_panel3515 ], "hideCheckBoxLabels": true, "border": false, "labelAlign": "top" });
    var IdentifyPersonResult_grid3527 = new Lino.cbss.IdentifyPersonResult.GridPanel({ "flex": 62, "listeners": { "render": Lino.quicktip_renderer("Resultate","(cbss.cbss.IdentifyPersonResult) ") }, "hide_top_toolbar": true, "containing_panel": this, "tools": [ Lino.show_in_own_window_button(Lino.cbss.IdentifyPersonResult.grid) ], "master_panel": this });
    var request_panel3528 = new Ext.Panel({ "layout": "vbox", "title": "Abfrage", "items": [ info_1_panel3489, parameters_panel3516, IdentifyPersonResult_grid3527 ], "frame": true, "layoutConfig": { "align": "stretch" }, "hideCheckBoxLabels": true, "listeners": { "activate": Lino.on_tab_activate }, "autoScroll": false, "border": false, "bodyBorder": false, "labelAlign": "top" });
    var response_xml3529 = new Ext.form.TextArea({ "disabled": true, "listeners": { "render": Lino.quicktip_renderer("Antwort","(cbss.IdentifyPersonRequests.response_xml) The raw XML response received. \n") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Antwort</span>", "name": "response_xml", "growMax": 2000, "anchor": "-20 -10" });
    var info_messages3530 = new Ext.form.TextArea({ "disabled": true, "listeners": { "render": Lino.quicktip_renderer("Info-Meldungen","(cbss.IdentifyPersonRequests.info_messages) ") }, "fieldLabel": "Info-Meldungen", "name": "info_messages", "growMax": 2000, "anchor": "-20 -10" });
    var debug_messages3531 = new Ext.form.TextArea({ "disabled": true, "listeners": { "render": Lino.quicktip_renderer("Debug-Meldungen","(cbss.IdentifyPersonRequests.debug_messages) ") }, "fieldLabel": "Debug-Meldungen", "name": "debug_messages", "growMax": 2000, "anchor": "-20 -10" });
    var technical_panel3532 = new Lino.VBorderPanel({ "autoScroll": false, "listeners": { "activate": Lino.on_tab_activate }, "border": false, "labelWidth": 144, "title": "Technisch", "hideCheckBoxLabels": true, "items": [ { "flex": 5, "layout": "form", "xtype": "panel", "items": response_xml3529, "region": "north", "labelAlign": "top", "split": true }, { "flex": 5, "layout": "form", "xtype": "panel", "items": info_messages3530, "region": "center", "labelAlign": "top", "split": true }, { "flex": 5, "layout": "form", "xtype": "panel", "items": debug_messages3531, "region": "south", "labelAlign": "top", "split": true } ], "frame": true, "bodyBorder": false, "labelAlign": "top" });
    var main_panel3536 = new Ext.TabPanel({ "hideCheckBoxLabels": true, "border": false, "split": true, "autoScroll": false, "items": [ request_panel3528, technical_panel3532 ], "activeTab": 0, "bodyBorder": false, "frame": true, "labelAlign": "top" });
    this.items = main_panel3536;
    this.before_row_edit = function(record) {
      IdentifyPersonResult_grid3527.on_master_changed();
    }
    Lino.cbss.IdentifyPersonRequests.DetailFormPanel.superclass.initComponent.call(this);
    // active_fields:
    person3483.on("change",function(){this.save()},this);
  }
});


Lino.changes.ChangesByMaster.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 10,
  disable_editing: true,
  initComponent : function() {
    var containing_panel = this;
    var time417 = new Ext.form.DisplayField({ "listeners": { "render": Lino.quicktip_renderer("time","(changes.Changes.time) ") }, "fieldLabel": "time", "name": "time", "selectOnFocus": true, "anchor": "-20", "value": "<br>", "allowBlank": false });
    var user418 = new Lino.TwinCombo({ "preferred_width": 15, "fieldLabel": "Benutzer", "allowBlank": false, "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.users.Users.detail)}, "emptyText": "Benutzer ausw\u00e4hlen...", "listeners": { "render": Lino.quicktip_renderer("Benutzer","(changes.Changes.user) ") }, "selectOnFocus": true, "hiddenName": "userHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/changes/Changes/user", "method": "GET" }) }), "name": "user" });
    var type419 = new Lino.ChoicesFieldElement({ "forceSelection": true, "fieldLabel": "\u00c4nderungsart", "allowBlank": false, "hiddenName": "typeHidden", "listeners": { "render": Lino.quicktip_renderer("\u00c4nderungsart","(changes.Changes.type) ") }, "selectOnFocus": true, "anchor": "-20", "store": Lino.lino.ChangeTypes, "name": "type" });
    var master_disp420 = new Ext.form.DisplayField({ "disabled": true, "fieldLabel": "Stammdaten", "anchor": "-20", "name": "master" });
    var object_disp421 = new Ext.form.DisplayField({ "disabled": true, "fieldLabel": "Object", "anchor": "-20", "name": "object" });
    var id422 = new Ext.form.NumberField({ "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("ID","(changes.Changes.id) ") }, "fieldLabel": "ID", "anchor": "-20", "name": "id" });
    var main_1_panel423 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 117, "hideCheckBoxLabels": true, "items": [ { "flex": 21, "autoHeight": true, "layout": "form", "xtype": "panel", "items": time417, "labelAlign": "top" }, { "flex": 26, "autoHeight": true, "layout": "form", "xtype": "panel", "items": user418, "labelAlign": "top" }, { "flex": 19, "autoHeight": true, "layout": "form", "xtype": "panel", "items": type419, "labelAlign": "top" }, { "flex": 13, "autoHeight": true, "layout": "form", "xtype": "panel", "items": master_disp420, "labelAlign": "top" }, { "flex": 13, "autoHeight": true, "layout": "form", "xtype": "panel", "items": object_disp421, "labelAlign": "top" }, { "flex": 6, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id422, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var diff430 = new Ext.form.TextArea({ "listeners": { "render": Lino.quicktip_renderer("\u00c4nderungen","(changes.Changes.diff) ") }, "fieldLabel": "\u00c4nderungen", "name": "diff", "growMax": 2000, "selectOnFocus": true, "anchor": "-20 -10" });
    var main_panel431 = new Ext.Panel({ "autoScroll": false, "border": false, "layout": "vbox", "labelWidth": 99, "hideCheckBoxLabels": true, "items": [ main_1_panel423, { "items": diff430, "labelAlign": "top", "layout": "form", "xtype": "panel", "flex": 83 } ], "frame": true, "layoutConfig": { "align": "stretch" }, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel431;
    this.before_row_edit = function(record) {
    }
    Lino.changes.ChangesByMaster.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.uploads.MyUploads.InsertFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  autoHeight: true,
  content_type: 25,
  initComponent : function() {
    var containing_panel = this;
    var file1467 = Lino.file_field_handler(this,{ "listeners": { "render": Lino.quicktip_renderer("File","(uploads.Uploads.file) ") }, "fieldLabel": "File", "name": "file", "maxLength": 100, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var user1468 = new Lino.TwinCombo({ "preferred_width": 15, "fieldLabel": "Autor", "name": "user", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.users.Users.detail)}, "hiddenName": "userHidden", "listeners": { "render": Lino.quicktip_renderer("Autor","(uploads.Uploads.user) ") }, "selectOnFocus": true, "emptyText": "Benutzer ausw\u00e4hlen...", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/uploads/Uploads/user", "method": "GET" }) }) });
    var main_1_panel1469 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 51, "autoHeight": true, "layout": "form", "xtype": "panel", "items": file1467, "labelAlign": "top" }, { "flex": 48, "autoHeight": true, "layout": "form", "xtype": "panel", "items": user1468, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 54, "border": false, "anchor": "-20", "labelAlign": "top" });
    var type1472 = new Lino.RemoteComboFieldElement({ "fieldLabel": "Upload-Art", "name": "type", "pageSize": 20, "emptyText": "Upload-Art ausw\u00e4hlen...", "listeners": { "render": Lino.quicktip_renderer("Upload-Art","(uploads.Uploads.type) ") }, "selectOnFocus": true, "hiddenName": "typeHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/uploads/Uploads/type", "method": "GET" }) }) });
    var valid_until1473 = new Lino.DateField({ "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("g\u00fcltig bis","(uploads.Uploads.valid_until) ") }, "fieldLabel": "g\u00fcltig bis", "anchor": "-20", "name": "valid_until" });
    var main_2_panel1474 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 71, "autoHeight": true, "layout": "form", "xtype": "panel", "items": type1472, "labelAlign": "top" }, { "flex": 28, "autoHeight": true, "layout": "form", "xtype": "panel", "items": valid_until1473, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 99, "border": false, "anchor": "-20", "labelAlign": "top" });
    var description1477 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Beschreibung","(uploads.Uploads.description) ") }, "fieldLabel": "Beschreibung", "name": "description", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var main_panel1478 = new Ext.Panel({ "hideCheckBoxLabels": true, "autoHeight": true, "border": false, "layout": "form", "labelWidth": 117, "autoScroll": false, "items": [ main_1_panel1469, main_2_panel1474, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": description1477, "anchor": "-20", "labelAlign": "top" } ], "frame": true, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel1478;
    this.before_row_edit = function(record) {
    }
    Lino.uploads.MyUploads.InsertFormPanel.superclass.initComponent.call(this);
  }
});


Lino.users.MySettings.InsertFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  autoHeight: true,
  content_type: 7,
  initComponent : function() {
    var containing_panel = this;
    var username399 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Benutzername","(users.Users.username) Required. Must be unique.") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Benutzername</span>", "name": "username", "maxLength": 30, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var email400 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("e-mail address","(users.Users.email) ") }, "fieldLabel": "e-mail address", "name": "email", "maxLength": 75, "selectOnFocus": true, "anchor": "-20" });
    var main_1_panel401 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": username399, "labelAlign": "top" }, { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": email400, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 135, "border": false, "anchor": "-20", "labelAlign": "top" });
    var first_name404 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Vorname","(users.Users.first_name) ") }, "fieldLabel": "Vorname", "name": "first_name", "maxLength": 30, "selectOnFocus": true, "anchor": "-20" });
    var last_name405 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Familienname","(users.Users.last_name) ") }, "fieldLabel": "Familienname", "name": "last_name", "maxLength": 30, "selectOnFocus": true, "anchor": "-20" });
    var main_2_panel406 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": first_name404, "labelAlign": "top" }, { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": last_name405, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 117, "border": false, "anchor": "-20", "labelAlign": "top" });
    var partner409 = new Lino.TwinCombo({ "preferred_width": 20, "fieldLabel": "Partner", "name": "partner", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.contacts.Partners.detail)}, "hiddenName": "partnerHidden", "listeners": { "render": Lino.quicktip_renderer("Partner","(users.Users.partner) ") }, "selectOnFocus": true, "emptyText": "Partner ausw\u00e4hlen...", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/users/Users/partner", "method": "GET" }) }) });
    var language410 = new Lino.ChoicesFieldElement({ "listeners": { "render": Lino.quicktip_renderer("Sprache","(users.Users.language) ") }, "fieldLabel": "Sprache", "name": "language", "selectOnFocus": true, "anchor": "-20", "store": [ [ "en", "Englisch" ], [ "fr", "Franz\u00f6sisch" ], [ "de", "Deutsch" ], [ "nl", "Niederl\u00e4ndisch" ] ], "hiddenName": "languageHidden" });
    var profile411 = new Lino.ChoicesFieldElement({ "forceSelection": true, "fieldLabel": "Benutzerprofil", "name": "profile", "hiddenName": "profileHidden", "listeners": { "render": Lino.quicktip_renderer("Benutzerprofil","(users.Users.profile) ") }, "selectOnFocus": true, "anchor": "-20", "store": [['','<br>']].concat(Lino.lino.UserProfiles) });
    var main_4_panel412 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 35, "autoHeight": true, "layout": "form", "xtype": "panel", "items": language410, "labelAlign": "top" }, { "flex": 64, "autoHeight": true, "layout": "form", "xtype": "panel", "items": profile411, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 135, "border": false, "anchor": "-20", "labelAlign": "top" });
    var main_panel415 = new Ext.Panel({ "hideCheckBoxLabels": true, "autoHeight": true, "border": false, "layout": "form", "labelWidth": 72, "autoScroll": false, "items": [ main_1_panel401, main_2_panel406, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": partner409, "anchor": "-20", "labelAlign": "top" }, main_4_panel412 ], "frame": true, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel415;
    this.before_row_edit = function(record) {
    }
    Lino.users.MySettings.InsertFormPanel.superclass.initComponent.call(this);
    // active_fields:
    partner409.on("change",function(){this.save()},this);
  }
});


Lino.uploads.MyUploads.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 25,
  initComponent : function() {
    var containing_panel = this;
    var file1446 = Lino.file_field_handler(this,{ "listeners": { "render": Lino.quicktip_renderer("File","(uploads.Uploads.file) ") }, "fieldLabel": "File", "name": "file", "maxLength": 100, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var user1447 = new Lino.TwinCombo({ "preferred_width": 15, "fieldLabel": "Autor", "name": "user", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.users.Users.detail)}, "hiddenName": "userHidden", "listeners": { "render": Lino.quicktip_renderer("Autor","(uploads.Uploads.user) ") }, "selectOnFocus": true, "emptyText": "Benutzer ausw\u00e4hlen...", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/uploads/Uploads/user", "method": "GET" }) }) });
    var main_1_panel1448 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 54, "hideCheckBoxLabels": true, "items": [ { "flex": 51, "autoHeight": true, "layout": "form", "xtype": "panel", "items": file1446, "labelAlign": "top" }, { "flex": 48, "autoHeight": true, "layout": "form", "xtype": "panel", "items": user1447, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var type1451 = new Lino.RemoteComboFieldElement({ "fieldLabel": "Upload-Art", "name": "type", "pageSize": 20, "emptyText": "Upload-Art ausw\u00e4hlen...", "listeners": { "render": Lino.quicktip_renderer("Upload-Art","(uploads.Uploads.type) ") }, "selectOnFocus": true, "hiddenName": "typeHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/uploads/Uploads/type", "method": "GET" }) }) });
    var description1452 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Beschreibung","(uploads.Uploads.description) ") }, "fieldLabel": "Beschreibung", "name": "description", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var valid_until1453 = new Lino.DateField({ "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("g\u00fcltig bis","(uploads.Uploads.valid_until) ") }, "fieldLabel": "g\u00fcltig bis", "anchor": "-20", "name": "valid_until" });
    var main_2_panel1454 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 117, "hideCheckBoxLabels": true, "items": [ { "flex": 40, "autoHeight": true, "layout": "form", "xtype": "panel", "items": type1451, "labelAlign": "top" }, { "flex": 42, "autoHeight": true, "layout": "form", "xtype": "panel", "items": description1452, "labelAlign": "top" }, { "flex": 16, "autoHeight": true, "layout": "form", "xtype": "panel", "items": valid_until1453, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var modified1458 = new Ext.form.DisplayField({ "disabled": true, "listeners": { "render": Lino.quicktip_renderer("Bearbeitet","(uploads.Uploads.modified) ") }, "fieldLabel": "Bearbeitet", "name": "modified", "anchor": "-20", "value": "<br>" });
    var created1459 = new Ext.form.DisplayField({ "disabled": true, "listeners": { "render": Lino.quicktip_renderer("Erstellt","(uploads.Uploads.created) ") }, "fieldLabel": "Erstellt", "name": "created", "anchor": "-20", "value": "<br>" });
    var owner_disp1460 = new Ext.form.DisplayField({ "disabled": true, "fieldLabel": "Verkn\u00fcpft mit", "anchor": "-20", "name": "owner" });
    var main_3_panel1461 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 126, "hideCheckBoxLabels": true, "items": [ { "flex": 38, "autoHeight": true, "layout": "form", "xtype": "panel", "items": modified1458, "labelAlign": "top" }, { "flex": 38, "autoHeight": true, "layout": "form", "xtype": "panel", "items": created1459, "labelAlign": "top" }, { "flex": 23, "autoHeight": true, "layout": "form", "xtype": "panel", "items": owner_disp1460, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var main_panel1466 = new Ext.Panel({ "autoScroll": false, "border": false, "layout": "vbox", "hideCheckBoxLabels": true, "items": [ main_1_panel1448, main_2_panel1454, main_3_panel1461 ], "frame": true, "layoutConfig": { "align": "stretch" }, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel1466;
    this.before_row_edit = function(record) {
    }
    Lino.uploads.MyUploads.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.cbss.IdentifyPersonRequests.InsertFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  autoHeight: true,
  content_type: 92,
  initComponent : function() {
    var containing_panel = this;
    var person3537 = new Lino.TwinCombo({ "preferred_width": 20, "fieldLabel": "Klient", "allowBlank": false, "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.pcsw.Clients.detail)}, "emptyText": "Klient ausw\u00e4hlen...", "listeners": { "render": Lino.quicktip_renderer("Klient","(cbss.IdentifyPersonRequests.person) ") }, "selectOnFocus": true, "hiddenName": "personHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cbss/IdentifyPersonRequests/person", "method": "GET" }) }), "name": "person" });
    var national_id3538 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("NR-Nummer","(cbss.IdentifyPersonRequests.national_id) ") }, "fieldLabel": "NR-Nummer", "name": "national_id", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var main_1_panel3539 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 48, "autoHeight": true, "layout": "form", "xtype": "panel", "items": person3537, "labelAlign": "top" }, { "flex": 51, "autoHeight": true, "layout": "form", "xtype": "panel", "items": national_id3538, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 90, "border": false, "anchor": "-20", "labelAlign": "top" });
    var first_name3542 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Vorname","(cbss.IdentifyPersonRequests.first_name) ") }, "fieldLabel": "Vorname", "name": "first_name", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var middle_name3543 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Mittelnamen","(cbss.IdentifyPersonRequests.middle_name) Whatever this means...") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Mittelnamen</span>", "name": "middle_name", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var last_name3544 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Familienname","(cbss.IdentifyPersonRequests.last_name) ") }, "fieldLabel": "Familienname", "name": "last_name", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var p2_1_panel3545 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": first_name3542, "labelAlign": "top" }, { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": middle_name3543, "labelAlign": "top" }, { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": last_name3544, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 117, "border": false, "anchor": "-20", "labelAlign": "top" });
    var birth_date3549 = new Lino.IncompleteDateField({ "listeners": { "render": Lino.quicktip_renderer("Geburtsdatum","(cbss.IdentifyPersonRequests.birth_date) Uncomplete dates are allowed, e.g. \n\"00.00.1980\" means \"some day in 1980\", \n\"00.07.1980\" means \"in July 1980\"\nor \"23.07.0000\" means \"on a 23th of July\".") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Geburtsdatum</span>", "name": "birth_date", "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var tolerance3550 = new Ext.form.NumberField({ "listeners": { "render": Lino.quicktip_renderer("Toleranz","(cbss.IdentifyPersonRequests.tolerance) \n      Falls Monat oder Tag des Geburtsdatums unbekannt sind, \n      um wieviel Monate bzw. Tage die Suche nach unten/oben ausgeweitet wird.\n      G\u00fcltige Werte: 0 bis 10.\n      ") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Toleranz</span>", "name": "tolerance", "selectOnFocus": true, "anchor": "-20", "value": 0, "allowBlank": false });
    var gender3551 = new Lino.ChoicesFieldElement({ "forceSelection": true, "fieldLabel": "Geschlecht", "name": "gender", "hiddenName": "genderHidden", "listeners": { "render": Lino.quicktip_renderer("Geschlecht","(cbss.IdentifyPersonRequests.gender) ") }, "selectOnFocus": true, "anchor": "-20", "store": [['','<br>']].concat(Lino.lino.Genders) });
    var p2_2_panel3552 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 46, "autoHeight": true, "layout": "form", "xtype": "panel", "items": birth_date3549, "labelAlign": "top" }, { "flex": 19, "autoHeight": true, "layout": "form", "xtype": "panel", "items": tolerance3550, "labelAlign": "top" }, { "flex": 34, "autoHeight": true, "layout": "form", "xtype": "panel", "items": gender3551, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 117, "border": false, "anchor": "-20", "labelAlign": "top" });
    var p2_panel3556 = new Ext.form.FieldSet({ "autoHeight": true, "layout": "form", "title": "Phonetische Suche", "items": [ p2_1_panel3545, p2_2_panel3552 ], "frame": true, "bodyBorder": false, "autoScroll": false, "hideCheckBoxLabels": true, "border": false, "anchor": "-20", "labelAlign": "top" });
    var main_panel3557 = new Ext.Panel({ "hideCheckBoxLabels": true, "autoHeight": true, "border": false, "layout": "form", "autoScroll": false, "items": [ main_1_panel3539, p2_panel3556 ], "frame": true, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel3557;
    this.before_row_edit = function(record) {
    }
    Lino.cbss.IdentifyPersonRequests.InsertFormPanel.superclass.initComponent.call(this);
    // active_fields:
    person3537.on("change",function(){this.save()},this);
  }
});


Lino.cbss.RetrieveTIGroupsRequests.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 89,
  initComponent : function() {
    var containing_panel = this;
    var id3643 = new Ext.form.NumberField({ "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("ID","(cbss.RetrieveTIGroupsRequests.id) ") }, "fieldLabel": "ID", "anchor": "-20", "name": "id" });
    var person3644 = new Lino.TwinCombo({ "preferred_width": 20, "fieldLabel": "Klient", "allowBlank": false, "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.pcsw.Clients.detail)}, "emptyText": "Klient ausw\u00e4hlen...", "listeners": { "render": Lino.quicktip_renderer("Klient","(cbss.RetrieveTIGroupsRequests.person) ") }, "selectOnFocus": true, "hiddenName": "personHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cbss/RetrieveTIGroupsRequests/person", "method": "GET" }) }), "name": "person" });
    var user3645 = new Lino.TwinCombo({ "preferred_width": 15, "fieldLabel": "Autor", "allowBlank": false, "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.users.Users.detail)}, "emptyText": "Benutzer ausw\u00e4hlen...", "listeners": { "render": Lino.quicktip_renderer("Autor","(cbss.RetrieveTIGroupsRequests.user) ") }, "selectOnFocus": true, "hiddenName": "userHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cbss/RetrieveTIGroupsRequests/user", "method": "GET" }) }), "name": "user" });
    var environment3646 = new Ext.form.TextField({ "disabled": true, "listeners": { "render": Lino.quicktip_renderer("T/A/B","(cbss.RetrieveTIGroupsRequests.environment) ") }, "fieldLabel": "T/A/B", "name": "environment", "maxLength": 4, "boxMinWidth": Lino.chars2width(4), "anchor": "-20" });
    var sent3647 = new Ext.form.DisplayField({ "disabled": true, "listeners": { "render": Lino.quicktip_renderer("Versendet","(cbss.RetrieveTIGroupsRequests.sent) The date and time when this request has been executed. \nThis is empty for requests than haven't been sent.\nRead-only.") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Versendet</span>", "name": "sent", "anchor": "-20", "value": "<br>" });
    var status3648 = new Lino.ChoicesFieldElement({ "forceSelection": true, "fieldLabel": "Zustand", "name": "status", "hiddenName": "statusHidden", "disabled": true, "listeners": { "render": Lino.quicktip_renderer("Zustand","(cbss.RetrieveTIGroupsRequests.status) ") }, "anchor": "-20", "store": [['','<br>']].concat(Lino.cbss.RequestStates) });
    var ticket3649 = new Ext.form.TextField({ "disabled": true, "listeners": { "render": Lino.quicktip_renderer("Ticket","(cbss.RetrieveTIGroupsRequests.ticket) ") }, "fieldLabel": "Ticket", "name": "ticket", "maxLength": 36, "anchor": "-20" });
    var info_1_panel3650 = new Ext.form.FieldSet({ "autoHeight": true, "layout": "hbox", "title": "Info zur Anfrage", "layoutConfig": { "align": "stretchmax" }, "frame": false, "bodyBorder": true, "autoScroll": false, "items": [ { "flex": 5, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id3643, "labelAlign": "top" }, { "flex": 20, "autoHeight": true, "layout": "form", "xtype": "panel", "items": person3644, "labelAlign": "top" }, { "flex": 20, "autoHeight": true, "layout": "form", "xtype": "panel", "items": user3645, "labelAlign": "top" }, { "flex": 5, "autoHeight": true, "layout": "form", "xtype": "panel", "items": environment3646, "labelAlign": "top" }, { "flex": 16, "autoHeight": true, "layout": "form", "xtype": "panel", "items": sent3647, "labelAlign": "top" }, { "flex": 12, "autoHeight": true, "layout": "form", "xtype": "panel", "items": status3648, "labelAlign": "top" }, { "flex": 21, "autoHeight": true, "layout": "form", "xtype": "panel", "items": ticket3649, "labelAlign": "top" } ], "hideCheckBoxLabels": true, "labelWidth": 90, "border": false, "labelAlign": "top" });
    var national_id3658 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("NR-Nummer","(cbss.RetrieveTIGroupsRequests.national_id) ") }, "fieldLabel": "NR-Nummer", "name": "national_id", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var language3659 = new Lino.ChoicesFieldElement({ "forceSelection": true, "fieldLabel": "Sprache", "name": "language", "hiddenName": "languageHidden", "listeners": { "render": Lino.quicktip_renderer("Sprache","(cbss.RetrieveTIGroupsRequests.language) ") }, "selectOnFocus": true, "anchor": "-20", "store": [['','<br>']].concat(Lino.cbss.RequestLanguages) });
    var history3660 = new Ext.form.Checkbox({ "boxLabel": "Historie", "listeners": { "render": Lino.quicktip_renderer("Historie","(cbss.RetrieveTIGroupsRequests.history) Whatever this means.") }, "hideLabel": true, "checked": true, "name": "history", "selectOnFocus": true, "anchor": "-20" });
    var parameters_panel3661 = new Ext.form.FieldSet({ "autoHeight": true, "layout": "hbox", "title": "Parameter", "layoutConfig": { "align": "stretchmax" }, "frame": false, "bodyBorder": true, "autoScroll": false, "items": [ { "flex": 52, "autoHeight": true, "layout": "form", "xtype": "panel", "items": national_id3658, "labelAlign": "top" }, { "flex": 22, "autoHeight": true, "layout": "form", "xtype": "panel", "items": language3659, "labelAlign": "top" }, { "flex": 25, "autoHeight": true, "layout": "form", "xtype": "panel", "items": history3660, "labelAlign": "top" } ], "hideCheckBoxLabels": true, "labelWidth": 90, "border": false, "labelAlign": "top" });
    var cbss_RetrieveTIGroupsResult_grid3670 = new Lino.cbss.RetrieveTIGroupsResult.GridPanel({ "flex": 71, "listeners": { "render": Lino.quicktip_renderer("Resultate","(cbss.cbss.RetrieveTIGroupsResult) ") }, "hide_top_toolbar": true, "containing_panel": this, "tools": [ Lino.show_in_own_window_button(Lino.cbss.RetrieveTIGroupsResult.grid) ], "master_panel": this });
    var request_panel3671 = new Ext.Panel({ "layout": "vbox", "title": "Abfrage", "items": [ info_1_panel3650, parameters_panel3661, cbss_RetrieveTIGroupsResult_grid3670 ], "frame": true, "layoutConfig": { "align": "stretch" }, "hideCheckBoxLabels": true, "listeners": { "activate": Lino.on_tab_activate }, "autoScroll": false, "border": false, "bodyBorder": false, "labelAlign": "top" });
    var response_xml3672 = new Ext.form.TextArea({ "disabled": true, "listeners": { "render": Lino.quicktip_renderer("Antwort","(cbss.RetrieveTIGroupsRequests.response_xml) The raw XML response received. \n") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Antwort</span>", "name": "response_xml", "growMax": 2000, "anchor": "-20 -10" });
    var info_messages3673 = new Ext.form.TextArea({ "disabled": true, "listeners": { "render": Lino.quicktip_renderer("Info-Meldungen","(cbss.RetrieveTIGroupsRequests.info_messages) ") }, "fieldLabel": "Info-Meldungen", "name": "info_messages", "growMax": 2000, "anchor": "-20 -10" });
    var debug_messages3674 = new Ext.form.TextArea({ "disabled": true, "listeners": { "render": Lino.quicktip_renderer("Debug-Meldungen","(cbss.RetrieveTIGroupsRequests.debug_messages) ") }, "fieldLabel": "Debug-Meldungen", "name": "debug_messages", "growMax": 2000, "anchor": "-20 -10" });
    var technical_panel3675 = new Lino.VBorderPanel({ "autoScroll": false, "listeners": { "activate": Lino.on_tab_activate }, "border": false, "labelWidth": 144, "title": "Technisch", "hideCheckBoxLabels": true, "items": [ { "flex": 5, "layout": "form", "xtype": "panel", "items": response_xml3672, "region": "north", "labelAlign": "top", "split": true }, { "flex": 5, "layout": "form", "xtype": "panel", "items": info_messages3673, "region": "center", "labelAlign": "top", "split": true }, { "flex": 5, "layout": "form", "xtype": "panel", "items": debug_messages3674, "region": "south", "labelAlign": "top", "split": true } ], "frame": true, "bodyBorder": false, "labelAlign": "top" });
    var main_panel3679 = new Ext.TabPanel({ "hideCheckBoxLabels": true, "border": false, "split": true, "autoScroll": false, "items": [ request_panel3671, technical_panel3675 ], "activeTab": 0, "bodyBorder": false, "frame": true, "labelAlign": "top" });
    this.items = main_panel3679;
    this.before_row_edit = function(record) {
      cbss_RetrieveTIGroupsResult_grid3670.on_master_changed();
    }
    Lino.cbss.RetrieveTIGroupsRequests.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.cbss.ManageAccessRequests.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 90,
  initComponent : function() {
    var containing_panel = this;
    var id3558 = new Ext.form.NumberField({ "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("ID","(cbss.ManageAccessRequests.id) ") }, "fieldLabel": "ID", "anchor": "-20", "name": "id" });
    var person3559 = new Lino.TwinCombo({ "preferred_width": 20, "fieldLabel": "Klient", "allowBlank": false, "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.pcsw.Clients.detail)}, "emptyText": "Klient ausw\u00e4hlen...", "listeners": { "render": Lino.quicktip_renderer("Klient","(cbss.ManageAccessRequests.person) ") }, "selectOnFocus": true, "hiddenName": "personHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cbss/ManageAccessRequests/person", "method": "GET" }) }), "name": "person" });
    var user3560 = new Lino.TwinCombo({ "preferred_width": 15, "fieldLabel": "Autor", "allowBlank": false, "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.users.Users.detail)}, "emptyText": "Benutzer ausw\u00e4hlen...", "listeners": { "render": Lino.quicktip_renderer("Autor","(cbss.ManageAccessRequests.user) ") }, "selectOnFocus": true, "hiddenName": "userHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cbss/ManageAccessRequests/user", "method": "GET" }) }), "name": "user" });
    var environment3561 = new Ext.form.TextField({ "disabled": true, "listeners": { "render": Lino.quicktip_renderer("T/A/B","(cbss.ManageAccessRequests.environment) ") }, "fieldLabel": "T/A/B", "name": "environment", "maxLength": 4, "boxMinWidth": Lino.chars2width(4), "anchor": "-20" });
    var sent3562 = new Ext.form.DisplayField({ "disabled": true, "listeners": { "render": Lino.quicktip_renderer("Versendet","(cbss.ManageAccessRequests.sent) The date and time when this request has been executed. \nThis is empty for requests than haven't been sent.\nRead-only.") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Versendet</span>", "name": "sent", "anchor": "-20", "value": "<br>" });
    var status3563 = new Lino.ChoicesFieldElement({ "forceSelection": true, "fieldLabel": "Zustand", "name": "status", "hiddenName": "statusHidden", "disabled": true, "listeners": { "render": Lino.quicktip_renderer("Zustand","(cbss.ManageAccessRequests.status) ") }, "anchor": "-20", "store": [['','<br>']].concat(Lino.cbss.RequestStates) });
    var ticket3564 = new Ext.form.TextField({ "disabled": true, "listeners": { "render": Lino.quicktip_renderer("Ticket","(cbss.ManageAccessRequests.ticket) ") }, "fieldLabel": "Ticket", "name": "ticket", "maxLength": 36, "anchor": "-20" });
    var info_1_panel3565 = new Ext.form.FieldSet({ "autoHeight": true, "layout": "hbox", "title": "Info zur Anfrage", "layoutConfig": { "align": "stretchmax" }, "frame": false, "bodyBorder": true, "autoScroll": false, "items": [ { "flex": 5, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id3558, "labelAlign": "top" }, { "flex": 20, "autoHeight": true, "layout": "form", "xtype": "panel", "items": person3559, "labelAlign": "top" }, { "flex": 20, "autoHeight": true, "layout": "form", "xtype": "panel", "items": user3560, "labelAlign": "top" }, { "flex": 5, "autoHeight": true, "layout": "form", "xtype": "panel", "items": environment3561, "labelAlign": "top" }, { "flex": 16, "autoHeight": true, "layout": "form", "xtype": "panel", "items": sent3562, "labelAlign": "top" }, { "flex": 12, "autoHeight": true, "layout": "form", "xtype": "panel", "items": status3563, "labelAlign": "top" }, { "flex": 21, "autoHeight": true, "layout": "form", "xtype": "panel", "items": ticket3564, "labelAlign": "top" } ], "hideCheckBoxLabels": true, "labelWidth": 90, "border": false, "labelAlign": "top" });
    var action3573 = new Lino.ChoicesFieldElement({ "forceSelection": true, "fieldLabel": "Aktion", "allowBlank": false, "hiddenName": "actionHidden", "listeners": { "render": Lino.quicktip_renderer("Aktion","(cbss.ManageAccessRequests.action) ") }, "selectOnFocus": true, "anchor": "-20", "store": Lino.cbss.ManageAction, "name": "action" });
    var start_date3574 = new Lino.DateField({ "listeners": { "render": Lino.quicktip_renderer("Periode vom","(cbss.ManageAccessRequests.start_date) ") }, "fieldLabel": "Periode vom", "name": "start_date", "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var end_date3575 = new Lino.DateField({ "listeners": { "render": Lino.quicktip_renderer("Periode bis","(cbss.ManageAccessRequests.end_date) ") }, "fieldLabel": "Periode bis", "name": "end_date", "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var p1_1_panel3576 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 44, "autoHeight": true, "layout": "form", "xtype": "panel", "items": action3573, "labelAlign": "top" }, { "flex": 27, "autoHeight": true, "layout": "form", "xtype": "panel", "items": start_date3574, "labelAlign": "top" }, { "flex": 27, "autoHeight": true, "layout": "form", "xtype": "panel", "items": end_date3575, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 108, "border": false, "anchor": "-20", "labelAlign": "top" });
    var purpose3580 = new Lino.RemoteComboFieldElement({ "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Eigenschafts-Code</span>", "allowBlank": false, "pageSize": 20, "emptyText": "Eigenschafts-Code ausw\u00e4hlen...", "listeners": { "render": Lino.quicktip_renderer("Eigenschafts-Code","(cbss.ManageAccessRequests.purpose) The purpose for which the inscription needs to be \nregistered/unregistered or listed. \nFor listing this field is optional, \nfor register/unregister it is mandatory.") }, "selectOnFocus": true, "hiddenName": "purposeHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cbss/ManageAccessRequests/purpose", "method": "GET" }) }), "name": "purpose" });
    var query_register3581 = new Lino.ChoicesFieldElement({ "forceSelection": true, "fieldLabel": "Abfrageregister", "allowBlank": false, "hiddenName": "query_registerHidden", "listeners": { "render": Lino.quicktip_renderer("Abfrageregister","(cbss.ManageAccessRequests.query_register) ") }, "selectOnFocus": true, "anchor": "-20", "store": Lino.cbss.QueryRegister, "name": "query_register" });
    var p1_2_panel3582 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 62, "autoHeight": true, "layout": "form", "xtype": "panel", "items": purpose3580, "labelAlign": "top" }, { "flex": 37, "autoHeight": true, "layout": "form", "xtype": "panel", "items": query_register3581, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 162, "border": false, "anchor": "-20", "labelAlign": "top" });
    var p1_panel3585 = new Ext.form.FieldSet({ "flex": 37, "autoHeight": true, "layout": "form", "title": "Angefragte Aktion", "items": [ p1_1_panel3576, p1_2_panel3582 ], "frame": true, "bodyBorder": false, "autoScroll": false, "hideCheckBoxLabels": true, "border": false, "labelAlign": "top" });
    var national_id3586 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("NR-Nummer","(cbss.ManageAccessRequests.national_id) The SSIN of the person to register/unregister/list.\n") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">NR-Nummer</span>", "name": "national_id", "maxLength": 200, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var sis_card_no3587 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("SIS-Karten-Nr","(cbss.ManageAccessRequests.sis_card_no) The number of the SIS card used to authenticate the person.") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">SIS-Karten-Nr</span>", "name": "sis_card_no", "maxLength": 10, "selectOnFocus": true, "boxMinWidth": Lino.chars2width(10), "anchor": "-20" });
    var id_card_no3588 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("ID-Karten-Nr","(cbss.ManageAccessRequests.id_card_no) The number of the ID card used to authenticate the person.") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">ID-Karten-Nr</span>", "name": "id_card_no", "maxLength": 20, "selectOnFocus": true, "anchor": "-20" });
    var proof_1_panel3589 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 39, "autoHeight": true, "layout": "form", "xtype": "panel", "items": national_id3586, "labelAlign": "top" }, { "flex": 20, "autoHeight": true, "layout": "form", "xtype": "panel", "items": sis_card_no3587, "labelAlign": "top" }, { "flex": 39, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id_card_no3588, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 126, "border": false, "anchor": "-20", "labelAlign": "top" });
    var first_name3593 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Vorname","(cbss.ManageAccessRequests.first_name) ") }, "fieldLabel": "Vorname", "name": "first_name", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var last_name3594 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Familienname","(cbss.ManageAccessRequests.last_name) ") }, "fieldLabel": "Familienname", "name": "last_name", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var birth_date3595 = new Lino.IncompleteDateField({ "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Geburtsdatum","(cbss.ManageAccessRequests.birth_date) Uncomplete dates are allowed, e.g. \n\"00.00.1980\" means \"some day in 1980\", \n\"00.07.1980\" means \"in July 1980\"\nor \"23.07.0000\" means \"on a 23th of July\".") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Geburtsdatum</span>", "anchor": "-20", "name": "birth_date" });
    var proof_2_panel3596 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 38, "autoHeight": true, "layout": "form", "xtype": "panel", "items": first_name3593, "labelAlign": "top" }, { "flex": 38, "autoHeight": true, "layout": "form", "xtype": "panel", "items": last_name3594, "labelAlign": "top" }, { "flex": 22, "autoHeight": true, "layout": "form", "xtype": "panel", "items": birth_date3595, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 117, "border": false, "anchor": "-20", "labelAlign": "top" });
    var proof_panel3600 = new Ext.form.FieldSet({ "flex": 62, "autoHeight": true, "layout": "form", "title": "Authentifizierungsbeleg", "items": [ proof_1_panel3589, proof_2_panel3596 ], "frame": true, "bodyBorder": false, "autoScroll": false, "hideCheckBoxLabels": true, "border": false, "labelAlign": "top" });
    var parameters_panel3601 = new Ext.form.FieldSet({ "autoHeight": true, "layout": "hbox", "title": "Parameter", "layoutConfig": { "align": "stretchmax" }, "frame": false, "bodyBorder": true, "autoScroll": false, "items": [ p1_panel3585, proof_panel3600 ], "hideCheckBoxLabels": true, "border": false, "labelAlign": "top" });
    var result_htmlbox3602 = new Lino.HtmlBoxPanel({ "flex": 50, "layout": "fit", "name": "result", "containing_panel": this, "master_panel": this, "items": new Ext.BoxComponent({autoScroll:true}), "title": "Resultat", "bodyStyle": "overflow-x:hidden;", "value": "<br/>", "always_enabled": true, "listeners": { "render": Lino.quicktip_renderer("Resultat","(cbss.ManageAccessRequests.result) ") } });
    var request_panel3603 = new Ext.Panel({ "layout": "vbox", "title": "Abfrage", "items": [ info_1_panel3565, parameters_panel3601, result_htmlbox3602 ], "frame": true, "layoutConfig": { "align": "stretch" }, "hideCheckBoxLabels": true, "listeners": { "activate": Lino.on_tab_activate }, "autoScroll": false, "labelWidth": 81, "border": false, "bodyBorder": false, "labelAlign": "top" });
    var main_panel3611 = new Ext.TabPanel({ "hideCheckBoxLabels": true, "border": false, "split": true, "autoScroll": false, "items": [ request_panel3603 ], "activeTab": 0, "bodyBorder": false, "frame": true, "labelAlign": "top" });
    this.items = main_panel3611;
    this.before_row_edit = function(record) {
      purpose3580.setContextValue('sector',record ? record.data['sectorHidden'] : undefined);
      result_htmlbox3602.refresh();
    }
    Lino.cbss.ManageAccessRequests.DetailFormPanel.superclass.initComponent.call(this);
    // active_fields:
    person3559.on("change",function(){this.save()},this);
  }
});


Lino.lino.Report.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  disable_editing: true,
  initComponent : function() {
    var containing_panel = this;
    var body_htmlbox3715 = new Lino.HtmlBoxPanel({ "layout": "fit", "name": "body", "containing_panel": this, "master_panel": this, "items": new Ext.BoxComponent({autoScroll:true}), "bodyStyle": "overflow-x:hidden;", "value": "<br/>", "always_enabled": true, "listeners": { "render": Lino.quicktip_renderer(null,"(lino.Report.body) ") } });
    var main_panel3716 = new Ext.Panel({ "autoScroll": false, "border": false, "layout": "fit", "labelWidth": 0, "hideCheckBoxLabels": true, "items": [ body_htmlbox3715 ], "frame": true, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel3716;
    this.before_row_edit = function(record) {
      body_htmlbox3715.refresh();
    }
    Lino.lino.Report.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.users.MySettings.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 7,
  initComponent : function() {
    var containing_panel = this;
    var username237 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Benutzername","(users.Users.username) Required. Must be unique.") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Benutzername</span>", "name": "username", "maxLength": 30, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var profile238 = new Lino.ChoicesFieldElement({ "forceSelection": true, "fieldLabel": "Benutzerprofil", "name": "profile", "hiddenName": "profileHidden", "listeners": { "render": Lino.quicktip_renderer("Benutzerprofil","(users.Users.profile) ") }, "selectOnFocus": true, "anchor": "-20", "store": [['','<br>']].concat(Lino.lino.UserProfiles) });
    var partner239 = new Lino.TwinCombo({ "preferred_width": 20, "fieldLabel": "Partner", "name": "partner", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.contacts.Partners.detail)}, "hiddenName": "partnerHidden", "listeners": { "render": Lino.quicktip_renderer("Partner","(users.Users.partner) ") }, "selectOnFocus": true, "emptyText": "Partner ausw\u00e4hlen...", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/users/Users/partner", "method": "GET" }) }) });
    var box1_1_panel240 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 34, "autoHeight": true, "layout": "form", "xtype": "panel", "items": username237, "labelAlign": "top" }, { "flex": 32, "autoHeight": true, "layout": "form", "xtype": "panel", "items": profile238, "labelAlign": "top" }, { "flex": 32, "autoHeight": true, "layout": "form", "xtype": "panel", "items": partner239, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 135, "border": false, "anchor": "-20", "labelAlign": "top" });
    var first_name244 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Vorname","(users.Users.first_name) ") }, "fieldLabel": "Vorname", "name": "first_name", "maxLength": 30, "selectOnFocus": true, "anchor": "-20" });
    var last_name245 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Familienname","(users.Users.last_name) ") }, "fieldLabel": "Familienname", "name": "last_name", "maxLength": 30, "selectOnFocus": true, "anchor": "-20" });
    var initials246 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Initials","(users.Users.initials) ") }, "fieldLabel": "Initials", "name": "initials", "maxLength": 10, "selectOnFocus": true, "boxMinWidth": Lino.chars2width(10), "anchor": "-20" });
    var box1_2_panel247 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 39, "autoHeight": true, "layout": "form", "xtype": "panel", "items": first_name244, "labelAlign": "top" }, { "flex": 39, "autoHeight": true, "layout": "form", "xtype": "panel", "items": last_name245, "labelAlign": "top" }, { "flex": 20, "autoHeight": true, "layout": "form", "xtype": "panel", "items": initials246, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 117, "border": false, "anchor": "-20", "labelAlign": "top" });
    var email251 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("e-mail address","(users.Users.email) ") }, "fieldLabel": "e-mail address", "name": "email", "maxLength": 75, "selectOnFocus": true, "anchor": "-20" });
    var language252 = new Lino.ChoicesFieldElement({ "listeners": { "render": Lino.quicktip_renderer("Sprache","(users.Users.language) ") }, "fieldLabel": "Sprache", "name": "language", "selectOnFocus": true, "anchor": "-20", "store": [ [ "en", "Englisch" ], [ "fr", "Franz\u00f6sisch" ], [ "de", "Deutsch" ], [ "nl", "Niederl\u00e4ndisch" ] ], "hiddenName": "languageHidden" });
    var box1_3_panel253 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 51, "autoHeight": true, "layout": "form", "xtype": "panel", "items": email251, "labelAlign": "top" }, { "flex": 48, "autoHeight": true, "layout": "form", "xtype": "panel", "items": language252, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 135, "border": false, "anchor": "-20", "labelAlign": "top" });
    var id256 = new Ext.form.NumberField({ "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("ID","(users.Users.id) ") }, "fieldLabel": "ID", "anchor": "-20", "name": "id" });
    var created257 = new Ext.form.DisplayField({ "disabled": true, "listeners": { "render": Lino.quicktip_renderer("Erstellt","(users.Users.created) ") }, "fieldLabel": "Erstellt", "name": "created", "anchor": "-20", "value": "<br>" });
    var modified258 = new Ext.form.DisplayField({ "disabled": true, "listeners": { "render": Lino.quicktip_renderer("Bearbeitet","(users.Users.modified) ") }, "fieldLabel": "Bearbeitet", "name": "modified", "anchor": "-20", "value": "<br>" });
    var box1_4_panel259 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 13, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id256, "labelAlign": "top" }, { "flex": 43, "autoHeight": true, "layout": "form", "xtype": "panel", "items": created257, "labelAlign": "top" }, { "flex": 43, "autoHeight": true, "layout": "form", "xtype": "panel", "items": modified258, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 99, "border": false, "anchor": "-20", "labelAlign": "top" });
    var box1_panel263 = new Ext.Panel({ "flex": 66, "autoHeight": true, "border": false, "layout": "form", "hideCheckBoxLabels": true, "items": [ box1_1_panel240, box1_2_panel247, box1_3_panel253, box1_4_panel259 ], "frame": true, "autoScroll": false, "bodyBorder": false, "labelAlign": "top" });
    var general_1_panel267 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "hideCheckBoxLabels": true, "items": [ box1_panel263 ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var remarks268 = new Ext.form.TextArea({ "listeners": { "render": Lino.quicktip_renderer("Bemerkungen","(users.Users.remarks) ") }, "fieldLabel": "Bemerkungen", "name": "remarks", "growMax": 2000, "selectOnFocus": true, "anchor": "-20 -10" });
    var AuthoritiesGiven_grid271 = new Lino.users.AuthoritiesGiven.GridPanel({ "flex": 33, "listeners": { "render": Lino.quicktip_renderer("Erteilte Vollmachten","(users.users.AuthoritiesGiven) ") }, "hide_top_toolbar": true, "containing_panel": this, "tools": [ Lino.show_in_own_window_button(Lino.users.AuthoritiesGiven.grid) ], "master_panel": this, "hideHeaders": true });
    var general_2_panel272 = new Ext.Panel({ "flex": 50, "border": false, "layout": "hbox", "labelWidth": 108, "hideCheckBoxLabels": true, "items": [ { "items": remarks268, "labelAlign": "top", "layout": "form", "xtype": "panel", "flex": 66 }, AuthoritiesGiven_grid271 ], "autoScroll": false, "layoutConfig": { "align": "stretch" }, "frame": false, "labelAlign": "top" });
    var general_panel274 = new Ext.Panel({ "layout": "vbox", "title": "Allgemein", "items": [ general_1_panel267, general_2_panel272 ], "frame": true, "layoutConfig": { "align": "stretch" }, "hideCheckBoxLabels": true, "listeners": { "activate": Lino.on_tab_activate }, "autoScroll": false, "border": false, "bodyBorder": false, "labelAlign": "top" });
    var calendar275 = new Lino.TwinCombo({ "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Standard-Kalender</span>", "name": "calendar", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.cal.Calendars.detail)}, "emptyText": "Kalender ausw\u00e4hlen...", "listeners": { "render": Lino.quicktip_renderer("Standard-Kalender","(users.Users.calendar) The default calendar for your events and tasks.") }, "selectOnFocus": true, "hiddenName": "calendarHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/users/Users/calendar", "method": "GET" }) }) });
    var access_class276 = new Lino.ChoicesFieldElement({ "forceSelection": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Standardm\u00e4\u00dfige Zugriffsklasse</span>", "allowBlank": false, "hiddenName": "access_classHidden", "listeners": { "render": Lino.quicktip_renderer("Standardm\u00e4\u00dfige Zugriffsklasse","(users.Users.access_class) Die standardm\u00e4\u00dfige Zugriffsklasse f\u00fcr Ihre Termine und Aufgaben") }, "selectOnFocus": true, "anchor": "-20", "store": Lino.cal.AccessClasses, "name": "access_class" });
    var cal_left_1_panel277 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 270, "hideCheckBoxLabels": true, "items": [ { "flex": 62, "autoHeight": true, "layout": "form", "xtype": "panel", "items": calendar275, "labelAlign": "top" }, { "flex": 37, "autoHeight": true, "layout": "form", "xtype": "panel", "items": access_class276, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var cal_left_panel285 = new Ext.Panel({ "flex": 33, "border": false, "layout": "vbox", "bodyBorder": false, "hideCheckBoxLabels": true, "items": [ cal_left_1_panel277 ], "autoScroll": false, "layoutConfig": { "align": "stretch" }, "frame": true, "labelAlign": "top" });
    var cal_1_panel356 = new Ext.Panel({ "autoScroll": false, "listeners": { "activate": Lino.on_tab_activate }, "border": false, "layout": "hbox", "title": "Kalender", "hideCheckBoxLabels": true, "items": [ cal_left_panel285 ], "frame": false, "layoutConfig": { "align": "stretch" }, "labelAlign": "top" });
    var newcomer_quota357 = new Ext.form.NumberField({ "listeners": { "render": Lino.quicktip_renderer("Quote NZ","(users.Users.newcomer_quota) Wieviel Arbeitszeit dieser Benutzer f\u00fcr Neuantr\u00e4ge zur Verf\u00fcgung steht\n(100 = ganztags, 50 = halbtags, 0 = gar nicht).\nWenn zwei Benutzer die gleiche Belastungspunktzahl haben, \naber einer davon sich nur zu 50% um Neuantr\u00e4ge k\u00fcmmert, \ngilt er als doppelt so belastet wie sein Kollege.\n") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Quote NZ</span>", "name": "newcomer_quota", "selectOnFocus": true, "anchor": "-20", "value": 0, "allowBlank": false });
    var coaching_type358 = new Lino.RemoteComboFieldElement({ "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Dienst</span>", "name": "coaching_type", "pageSize": 20, "emptyText": "Dienst ausw\u00e4hlen...", "listeners": { "render": Lino.quicktip_renderer("Dienst","(users.Users.coaching_type) The default CoachingType used when creating Coachings.") }, "selectOnFocus": true, "hiddenName": "coaching_typeHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/users/Users/coaching_type", "method": "GET" }) }) });
    var coaching_supervisor359 = new Ext.form.Checkbox({ "boxLabel": "Benachrichtigung wenn ein Begleiter zugewiesen wird", "listeners": { "render": Lino.quicktip_renderer("Benachrichtigung wenn ein Begleiter zugewiesen wird","(users.Users.coaching_supervisor) Wenn ein Neuantrag einem Begleiter zugewiesen wurde, wird au\u00dfer dem Begleiter auch dieser Benutzer benachrichtigt.") }, "hideLabel": true, "checked": false, "name": "coaching_supervisor", "selectOnFocus": true, "anchor": "-20" });
    var newcomers_CompetencesByUser_grid365 = new Lino.newcomers.CompetencesByUser.GridPanel({ "flex": 62, "listeners": { "render": Lino.quicktip_renderer("Kompetenzen","(newcomers.newcomers.CompetencesByUser) ") }, "hide_top_toolbar": true, "containing_panel": this, "tools": [ Lino.show_in_own_window_button(Lino.newcomers.CompetencesByUser.grid) ], "master_panel": this });
    var coaching_a_panel366 = new Ext.Panel({ "flex": 33, "layout": "vbox", "items": [ { "items": newcomer_quota357, "autoHeight": true, "layout": "form", "xtype": "panel", "labelAlign": "top" }, { "items": coaching_type358, "autoHeight": true, "layout": "form", "xtype": "panel", "labelAlign": "top" }, { "items": coaching_supervisor359, "autoHeight": true, "layout": "form", "xtype": "panel", "labelAlign": "top" }, newcomers_CompetencesByUser_grid365 ], "frame": true, "layoutConfig": { "align": "stretch" }, "autoScroll": false, "hideCheckBoxLabels": true, "labelWidth": 468, "border": false, "bodyBorder": false, "labelAlign": "top" });
    var pcsw_CoachingsByUser_grid396 = new Lino.pcsw.CoachingsByUser.GridPanel({ "flex": 66, "listeners": { "render": Lino.quicktip_renderer("Begleitungen","(pcsw.pcsw.CoachingsByUser) ") }, "hide_top_toolbar": true, "containing_panel": this, "params_panel_hidden": true, "tools": [ Lino.show_in_own_window_button(Lino.pcsw.CoachingsByUser.grid) ], "master_panel": this });
    var coaching_1_panel397 = new Ext.Panel({ "autoScroll": false, "listeners": { "activate": Lino.on_tab_activate }, "border": false, "layout": "hbox", "title": "Begleitung", "hideCheckBoxLabels": true, "items": [ coaching_a_panel366, pcsw_CoachingsByUser_grid396 ], "frame": false, "layoutConfig": { "align": "stretch" }, "labelAlign": "top" });
    var main_panel398 = new Ext.TabPanel({ "hideCheckBoxLabels": true, "border": false, "split": true, "autoScroll": false, "items": [ general_panel274, cal_1_panel356, coaching_1_panel397 ], "activeTab": 0, "bodyBorder": false, "frame": true, "labelAlign": "top" });
    this.items = main_panel398;
    this.before_row_edit = function(record) {
      AuthoritiesGiven_grid271.on_master_changed();
      newcomers_CompetencesByUser_grid365.on_master_changed();
      pcsw_CoachingsByUser_grid396.on_master_changed();
    }
    Lino.users.MySettings.DetailFormPanel.superclass.initComponent.call(this);
    // active_fields:
    partner239.on("change",function(){this.save()},this);
  }
});


Lino.cbss.ManageAccessRequests.InsertFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  autoHeight: true,
  content_type: 90,
  initComponent : function() {
    var containing_panel = this;
    var person3612 = new Lino.TwinCombo({ "preferred_width": 20, "fieldLabel": "Klient", "allowBlank": false, "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.pcsw.Clients.detail)}, "emptyText": "Klient ausw\u00e4hlen...", "listeners": { "render": Lino.quicktip_renderer("Klient","(cbss.ManageAccessRequests.person) ") }, "selectOnFocus": true, "hiddenName": "personHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cbss/ManageAccessRequests/person", "method": "GET" }) }), "name": "person" });
    var action3613 = new Lino.ChoicesFieldElement({ "forceSelection": true, "fieldLabel": "Aktion", "allowBlank": false, "hiddenName": "actionHidden", "listeners": { "render": Lino.quicktip_renderer("Aktion","(cbss.ManageAccessRequests.action) ") }, "selectOnFocus": true, "anchor": "-20", "store": Lino.cbss.ManageAction, "name": "action" });
    var start_date3614 = new Lino.DateField({ "listeners": { "render": Lino.quicktip_renderer("Periode vom","(cbss.ManageAccessRequests.start_date) ") }, "fieldLabel": "Periode vom", "name": "start_date", "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var end_date3615 = new Lino.DateField({ "listeners": { "render": Lino.quicktip_renderer("Periode bis","(cbss.ManageAccessRequests.end_date) ") }, "fieldLabel": "Periode bis", "name": "end_date", "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var p1_1_panel3616 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 44, "autoHeight": true, "layout": "form", "xtype": "panel", "items": action3613, "labelAlign": "top" }, { "flex": 27, "autoHeight": true, "layout": "form", "xtype": "panel", "items": start_date3614, "labelAlign": "top" }, { "flex": 27, "autoHeight": true, "layout": "form", "xtype": "panel", "items": end_date3615, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 108, "border": false, "anchor": "-20", "labelAlign": "top" });
    var purpose3620 = new Lino.RemoteComboFieldElement({ "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Eigenschafts-Code</span>", "allowBlank": false, "pageSize": 20, "emptyText": "Eigenschafts-Code ausw\u00e4hlen...", "listeners": { "render": Lino.quicktip_renderer("Eigenschafts-Code","(cbss.ManageAccessRequests.purpose) The purpose for which the inscription needs to be \nregistered/unregistered or listed. \nFor listing this field is optional, \nfor register/unregister it is mandatory.") }, "selectOnFocus": true, "hiddenName": "purposeHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cbss/ManageAccessRequests/purpose", "method": "GET" }) }), "name": "purpose" });
    var query_register3621 = new Lino.ChoicesFieldElement({ "forceSelection": true, "fieldLabel": "Abfrageregister", "allowBlank": false, "hiddenName": "query_registerHidden", "listeners": { "render": Lino.quicktip_renderer("Abfrageregister","(cbss.ManageAccessRequests.query_register) ") }, "selectOnFocus": true, "anchor": "-20", "store": Lino.cbss.QueryRegister, "name": "query_register" });
    var p1_2_panel3622 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 62, "autoHeight": true, "layout": "form", "xtype": "panel", "items": purpose3620, "labelAlign": "top" }, { "flex": 37, "autoHeight": true, "layout": "form", "xtype": "panel", "items": query_register3621, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 162, "border": false, "anchor": "-20", "labelAlign": "top" });
    var p1_panel3625 = new Ext.form.FieldSet({ "autoHeight": true, "layout": "form", "title": "Angefragte Aktion", "items": [ p1_1_panel3616, p1_2_panel3622 ], "frame": true, "bodyBorder": false, "autoScroll": false, "hideCheckBoxLabels": true, "border": false, "anchor": "-20", "labelAlign": "top" });
    var national_id3626 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("NR-Nummer","(cbss.ManageAccessRequests.national_id) The SSIN of the person to register/unregister/list.\n") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">NR-Nummer</span>", "name": "national_id", "maxLength": 200, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var sis_card_no3627 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("SIS-Karten-Nr","(cbss.ManageAccessRequests.sis_card_no) The number of the SIS card used to authenticate the person.") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">SIS-Karten-Nr</span>", "name": "sis_card_no", "maxLength": 10, "selectOnFocus": true, "boxMinWidth": Lino.chars2width(10), "anchor": "-20" });
    var id_card_no3628 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("ID-Karten-Nr","(cbss.ManageAccessRequests.id_card_no) The number of the ID card used to authenticate the person.") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">ID-Karten-Nr</span>", "name": "id_card_no", "maxLength": 20, "selectOnFocus": true, "anchor": "-20" });
    var proof_1_panel3629 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 39, "autoHeight": true, "layout": "form", "xtype": "panel", "items": national_id3626, "labelAlign": "top" }, { "flex": 20, "autoHeight": true, "layout": "form", "xtype": "panel", "items": sis_card_no3627, "labelAlign": "top" }, { "flex": 39, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id_card_no3628, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 126, "border": false, "anchor": "-20", "labelAlign": "top" });
    var first_name3633 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Vorname","(cbss.ManageAccessRequests.first_name) ") }, "fieldLabel": "Vorname", "name": "first_name", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var last_name3634 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Familienname","(cbss.ManageAccessRequests.last_name) ") }, "fieldLabel": "Familienname", "name": "last_name", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var birth_date3635 = new Lino.IncompleteDateField({ "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Geburtsdatum","(cbss.ManageAccessRequests.birth_date) Uncomplete dates are allowed, e.g. \n\"00.00.1980\" means \"some day in 1980\", \n\"00.07.1980\" means \"in July 1980\"\nor \"23.07.0000\" means \"on a 23th of July\".") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Geburtsdatum</span>", "anchor": "-20", "name": "birth_date" });
    var proof_2_panel3636 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 38, "autoHeight": true, "layout": "form", "xtype": "panel", "items": first_name3633, "labelAlign": "top" }, { "flex": 38, "autoHeight": true, "layout": "form", "xtype": "panel", "items": last_name3634, "labelAlign": "top" }, { "flex": 22, "autoHeight": true, "layout": "form", "xtype": "panel", "items": birth_date3635, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 117, "border": false, "anchor": "-20", "labelAlign": "top" });
    var proof_panel3640 = new Ext.form.FieldSet({ "autoHeight": true, "layout": "form", "title": "Authentifizierungsbeleg", "items": [ proof_1_panel3629, proof_2_panel3636 ], "frame": true, "bodyBorder": false, "autoScroll": false, "hideCheckBoxLabels": true, "border": false, "anchor": "-20", "labelAlign": "top" });
    var main_panel3641 = new Ext.Panel({ "hideCheckBoxLabels": true, "autoHeight": true, "border": false, "layout": "form", "labelWidth": 63, "autoScroll": false, "items": [ { "autoHeight": true, "layout": "form", "xtype": "panel", "items": person3612, "anchor": "-20", "labelAlign": "top" }, p1_panel3625, proof_panel3640 ], "frame": true, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel3641;
    this.before_row_edit = function(record) {
      purpose3620.setContextValue('sector',record ? record.data['sectorHidden'] : undefined);
    }
    Lino.cbss.ManageAccessRequests.InsertFormPanel.superclass.initComponent.call(this);
    // active_fields:
    person3612.on("change",function(){this.save()},this);
  }
});


Lino.cbss.RetrieveTIGroupsRequests.InsertFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  autoHeight: true,
  content_type: 89,
  initComponent : function() {
    var containing_panel = this;
    var person3680 = new Lino.TwinCombo({ "preferred_width": 20, "fieldLabel": "Klient", "allowBlank": false, "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.pcsw.Clients.detail)}, "emptyText": "Klient ausw\u00e4hlen...", "listeners": { "render": Lino.quicktip_renderer("Klient","(cbss.RetrieveTIGroupsRequests.person) ") }, "selectOnFocus": true, "hiddenName": "personHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cbss/RetrieveTIGroupsRequests/person", "method": "GET" }) }), "name": "person" });
    var national_id3681 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("NR-Nummer","(cbss.RetrieveTIGroupsRequests.national_id) ") }, "fieldLabel": "NR-Nummer", "name": "national_id", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var language3682 = new Lino.ChoicesFieldElement({ "forceSelection": true, "fieldLabel": "Sprache", "name": "language", "hiddenName": "languageHidden", "listeners": { "render": Lino.quicktip_renderer("Sprache","(cbss.RetrieveTIGroupsRequests.language) ") }, "selectOnFocus": true, "anchor": "-20", "store": [['','<br>']].concat(Lino.cbss.RequestLanguages) });
    var main_2_panel3683 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 70, "autoHeight": true, "layout": "form", "xtype": "panel", "items": national_id3681, "labelAlign": "top" }, { "flex": 30, "autoHeight": true, "layout": "form", "xtype": "panel", "items": language3682, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 90, "border": false, "anchor": "-20", "labelAlign": "top" });
    var history3686 = new Ext.form.Checkbox({ "boxLabel": "Historie", "listeners": { "render": Lino.quicktip_renderer("Historie","(cbss.RetrieveTIGroupsRequests.history) Whatever this means.") }, "hideLabel": true, "checked": true, "name": "history", "selectOnFocus": true, "anchor": "-20" });
    var main_panel3687 = new Ext.Panel({ "hideCheckBoxLabels": true, "autoHeight": true, "border": false, "layout": "form", "labelWidth": 81, "autoScroll": false, "items": [ { "autoHeight": true, "layout": "form", "xtype": "panel", "items": person3680, "anchor": "-20", "labelAlign": "top" }, main_2_panel3683, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": history3686, "anchor": "-20", "labelAlign": "top" } ], "frame": true, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel3687;
    this.before_row_edit = function(record) {
    }
    Lino.cbss.RetrieveTIGroupsRequests.InsertFormPanel.superclass.initComponent.call(this);
  }
});


Lino.pcsw.NotesByPerson.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 93,
  initComponent : function() {
    var containing_panel = this;
    var date914 = new Lino.DateField({ "listeners": { "render": Lino.quicktip_renderer("Datum","(notes.Notes.date) ") }, "fieldLabel": "Datum", "name": "date", "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var event_type915 = new Lino.TwinCombo({ "fieldLabel": "Ereignisart (Form)", "name": "event_type", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.notes.EventTypes.detail)}, "emptyText": "Event Type ausw\u00e4hlen...", "listeners": { "render": Lino.quicktip_renderer("Ereignisart (Form)","(notes.Notes.event_type) ") }, "selectOnFocus": true, "hiddenName": "event_typeHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/notes/Notes/event_type", "method": "GET" }) }) });
    var type916 = new Lino.TwinCombo({ "fieldLabel": "Notizart (Inhalt)", "name": "type", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.notes.NoteTypes.detail)}, "emptyText": "Notizart ausw\u00e4hlen...", "listeners": { "render": Lino.quicktip_renderer("Notizart (Inhalt)","(notes.Notes.type) ") }, "selectOnFocus": true, "hiddenName": "typeHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/notes/Notes/type", "method": "GET" }) }) });
    var left_1_panel917 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 171, "hideCheckBoxLabels": true, "items": [ { "flex": 16, "autoHeight": true, "layout": "form", "xtype": "panel", "items": date914, "labelAlign": "top" }, { "flex": 41, "autoHeight": true, "layout": "form", "xtype": "panel", "items": event_type915, "labelAlign": "top" }, { "flex": 41, "autoHeight": true, "layout": "form", "xtype": "panel", "items": type916, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var project921 = new Lino.TwinCombo({ "preferred_width": 20, "fieldLabel": "Klient", "name": "project", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.pcsw.Clients.detail)}, "hiddenName": "projectHidden", "listeners": { "render": Lino.quicktip_renderer("Klient","(notes.Notes.project) ") }, "selectOnFocus": true, "emptyText": "Klient ausw\u00e4hlen...", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/notes/Notes/project", "method": "GET" }) }) });
    var subject922 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Betreff","(notes.Notes.subject) ") }, "fieldLabel": "Betreff", "name": "subject", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var left_2_panel923 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 72, "hideCheckBoxLabels": true, "items": [ { "flex": 48, "autoHeight": true, "layout": "form", "xtype": "panel", "items": project921, "labelAlign": "top" }, { "flex": 51, "autoHeight": true, "layout": "form", "xtype": "panel", "items": subject922, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var company926 = new Lino.TwinCombo({ "preferred_width": 20, "fieldLabel": "Empf\u00e4nger (Organisation)", "name": "company", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.contacts.Companies.detail)}, "hiddenName": "companyHidden", "listeners": { "render": Lino.quicktip_renderer("Empf\u00e4nger (Organisation)","(notes.Notes.company) ") }, "selectOnFocus": true, "emptyText": "Organisation ausw\u00e4hlen...", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/notes/Notes/company", "method": "GET" }) }) });
    var contact_person927 = new Lino.TwinCombo({ "preferred_width": 20, "fieldLabel": "Empf\u00e4nger (Person)", "name": "contact_person", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.contacts.Persons.detail)}, "hiddenName": "contact_personHidden", "listeners": { "render": Lino.quicktip_renderer("Empf\u00e4nger (Person)","(notes.Notes.contact_person) ") }, "selectOnFocus": true, "emptyText": "Person ausw\u00e4hlen...", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/notes/Notes/contact_person", "method": "GET" }) }) });
    var left_3_panel928 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 225, "hideCheckBoxLabels": true, "items": [ { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": company926, "labelAlign": "top" }, { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": contact_person927, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var user931 = new Lino.TwinCombo({ "preferred_width": 15, "fieldLabel": "Autor", "name": "user", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.users.Users.detail)}, "hiddenName": "userHidden", "listeners": { "render": Lino.quicktip_renderer("Autor","(notes.Notes.user) ") }, "selectOnFocus": true, "emptyText": "Benutzer ausw\u00e4hlen...", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/notes/Notes/user", "method": "GET" }) }) });
    var language932 = new Lino.ChoicesFieldElement({ "fieldLabel": "Sprache", "allowBlank": false, "hiddenName": "languageHidden", "listeners": { "render": Lino.quicktip_renderer("Sprache","(notes.Notes.language) ") }, "selectOnFocus": true, "anchor": "-20", "store": [ [ "en", "Englisch" ], [ "fr", "Franz\u00f6sisch" ], [ "de", "Deutsch" ], [ "nl", "Niederl\u00e4ndisch" ] ], "name": "language" });
    var build_time933 = new Ext.form.DisplayField({ "disabled": true, "listeners": { "render": Lino.quicktip_renderer("Druckdatum","(notes.Notes.build_time) ") }, "fieldLabel": "Druckdatum", "name": "build_time", "anchor": "-20", "value": "<br>" });
    var id934 = new Ext.form.NumberField({ "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("ID","(notes.Notes.id) ") }, "fieldLabel": "ID", "anchor": "-20", "name": "id" });
    var left_4_panel935 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 99, "hideCheckBoxLabels": true, "items": [ { "flex": 25, "autoHeight": true, "layout": "form", "xtype": "panel", "items": user931, "labelAlign": "top" }, { "flex": 20, "autoHeight": true, "layout": "form", "xtype": "panel", "items": language932, "labelAlign": "top" }, { "flex": 41, "autoHeight": true, "layout": "form", "xtype": "panel", "items": build_time933, "labelAlign": "top" }, { "flex": 12, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id934, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var body940 = new Lino.RichTextPanel({ "selectOnFocus": true, "flex": 55, "containing_panel": this, "name": "body", "title": "Inhalt" });
    var left_panel941 = new Ext.Panel({ "flex": 66, "layout": "vbox", "items": [ left_1_panel917, left_2_panel923, left_3_panel928, left_4_panel935, body940 ], "frame": true, "layoutConfig": { "align": "stretch" }, "autoScroll": false, "hideCheckBoxLabels": true, "labelWidth": 0, "border": false, "bodyBorder": false, "labelAlign": "top" });
    var UploadsByController_htmlbox942 = new Lino.HtmlBoxPanel({ "flex": 3, "ls_bbar_actions": [ { "itemId": "insert", "menu_item_text": "Neu", "must_save": true, "tooltip": "Neuen Datensatz erstellen", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-new", "overflowText": "Neu", "auto_save": true } ], "name": "UploadsByController", "containing_panel": this, "items": new Ext.BoxComponent({autoScroll:true}), "region": "north", "title": "Uploads", "master_panel": this, "value": "<br/>", "always_enabled": true, "listeners": { "render": Lino.quicktip_renderer("Uploads","(notes.Notes.UploadsByController) ") }, "bodyStyle": "overflow-x:hidden;", "ls_insert_handler": Lino.uploads.UploadsByController.insert, "layout": "fit", "tools": [ Lino.show_in_own_window_button(Lino.uploads.UploadsByController.grid) ], "split": true });
    var outbox_MailsByController_grid988 = new Lino.outbox.MailsByController.GridPanel({ "flex": 5, "hide_top_toolbar": true, "containing_panel": this, "region": "center", "master_panel": this, "listeners": { "render": Lino.quicktip_renderer("E-Mail-Ausg\u00e4nge","(outbox.outbox.MailsByController) ") }, "split": true, "tools": [ Lino.show_in_own_window_button(Lino.outbox.MailsByController.grid) ] });
    var right_panel995 = new Lino.VBorderPanel({ "flex": 33, "border": false, "labelWidth": 72, "hideCheckBoxLabels": true, "items": [ UploadsByController_htmlbox942, outbox_MailsByController_grid988 ], "frame": true, "autoScroll": false, "bodyBorder": false, "labelAlign": "top" });
    var main_1_panel996 = new Ext.Panel({ "autoScroll": false, "border": false, "layout": "hbox", "hideCheckBoxLabels": true, "items": [ left_panel941, right_panel995 ], "frame": false, "layoutConfig": { "align": "stretch" }, "labelAlign": "top" });
    var main_panel997 = new Ext.Panel({ "autoScroll": false, "border": false, "layout": "fit", "hideCheckBoxLabels": true, "items": [ main_1_panel996 ], "frame": true, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel997;
    this.before_row_edit = function(record) {
      contact_person927.setContextValue('company',record ? record.data['companyHidden'] : undefined);
      body940.refresh();
      UploadsByController_htmlbox942.refresh();
      outbox_MailsByController_grid988.on_master_changed();
    }
    this.onRender = function(ct, position) {
      company926.on('change',Lino.chooser_handler(contact_person927,'company'));
      Lino.pcsw.NotesByPerson.DetailFormPanel.superclass.onRender.call(this, ct, position);
    }
    Lino.pcsw.NotesByPerson.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.system.Home.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  disable_editing: true,
  initComponent : function() {
    var containing_panel = this;
    var quick_links_htmlbox3721 = new Lino.HtmlBoxPanel({ "flex": 1, "layout": "fit", "name": "quick_links", "containing_panel": this, "master_panel": this, "items": new Ext.BoxComponent({autoScroll:true}), "region": "north", "bodyStyle": "overflow-x:hidden;", "value": "<br/>", "always_enabled": true, "listeners": { "render": Lino.quicktip_renderer(null,"(system.Home.quick_links) ") }, "split": true });
    var welcome_htmlbox3722 = new Lino.HtmlBoxPanel({ "flex": 3, "layout": "fit", "name": "welcome", "containing_panel": this, "master_panel": this, "items": new Ext.BoxComponent({autoScroll:true}), "region": "center", "title": "Willkommen", "bodyStyle": "overflow-x:hidden;", "value": "<br/>", "always_enabled": true, "listeners": { "render": Lino.quicktip_renderer("Willkommen","(system.Home.welcome) ") }, "split": true });
    var main_panel3723 = new Lino.VBorderPanel({ "autoScroll": false, "border": false, "labelWidth": 99, "hideCheckBoxLabels": true, "items": [ quick_links_htmlbox3721, welcome_htmlbox3722 ], "frame": true, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel3723;
    this.before_row_edit = function(record) {
      quick_links_htmlbox3721.refresh();
      welcome_htmlbox3722.refresh();
    }
    Lino.system.Home.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.about.About.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  disable_editing: true,
  initComponent : function() {
    var containing_panel = this;
    var server_status_disp3718 = new Ext.form.DisplayField({ "disabled": true, "listeners": { "render": Lino.quicktip_renderer("Server-Status","(about.About.server_status) ") }, "fieldLabel": "Server-Status", "name": "server_status", "anchor": "-20", "value": "<br/>", "always_enabled": true });
    var main_panel3719 = new Ext.Panel({ "autoScroll": false, "border": false, "layout": "vbox", "labelWidth": 126, "hideCheckBoxLabels": true, "items": [ { "flex": 25, "html": "<div class=\"htmlText\"><span>This is <a href=\"http://welfare.lino-framework.org\" target=\"_blank\">Lino Welfare</a> 1.1.9 using <a href=\"http://www.lino-framework.org\" target=\"_blank\">Lino</a> 1.6.11, <a href=\"http://jinja.pocoo.org/\" target=\"_blank\">Jinja</a> 2.6, <a href=\"http://sphinx-doc.org/\" target=\"_blank\">Sphinx</a> 1.2b1, <a href=\"http://labix.org/python-dateutil\" target=\"_blank\">python-dateutil</a> 2.1, <a href=\"http://pypi.python.org/pypi/odfpy\" target=\"_blank\">OdfPy</a> ODFPY/0.9.6, <a href=\"http://docutils.sourceforge.net/\" target=\"_blank\">docutils</a> 0.8.1, <a href=\"https://fedorahosted.org/suds/\" target=\"_blank\">suds</a> 0.4, <a href=\"http://pyyaml.org/\" target=\"_blank\">PyYaml</a> 3.10, <a href=\"http://appyframework.org/pod.html\" target=\"_blank\">Appy</a> 0.8.3 (2013/02/22 15:29), <a href=\"http://babel.edgewall.org/\" target=\"_blank\">Babel</a> 1.0, <a href=\"http://site.lino-framework.org\" target=\"_blank\">djangosite</a> 0.1.7, <a href=\"http://www.djangoproject.com\" target=\"_blank\">Django</a> 1.5.1, <a href=\"http://www.python.org/\" target=\"_blank\">Python</a> 2.7.3, <a href=\"http://www.sencha.com\" target=\"_blank\">ExtJS</a> <a href=\"#\" onclick=\"alert('ExtJS client version is ' + Ext.version);\" title=\"Click to see ExtJS client version\">(version)</a>, <a href=\"http://ext.ensible.com/products/calendar/\" target=\"_blank\">Extensible</a> <a href=\"#\" onclick=\"alert('Extensible Calendar version is ' + Ext.ensible.version);\" title=\"Click to see Extensible Calendar version\">(version)</a>, <a href=\"http://www.famfamfam.com/lab/icons/silk/\" target=\"_blank\">Silk Icons</a> 1.3</span><p>Server l&#228;uft seit : <b>Donnerstag, 29. August 2013 um 15:38:19.657040</b></p><p>Source timestamps:</p><ul><li>lino_welfare : <b>Donnerstag, 29. August 2013 um 15:38:18.483767</b></li><li>lino : <b>Donnerstag, 29. August 2013 um 15:29:53.719782</b></li><li>django : <b>Mittwoch, 28. August 2013 um 22:37:33.244067</b></li><li>north : <b>Mittwoch, 28. August 2013 um 11:25:41.253661</b></li><li>djangosite : <b>Mittwoch, 28. August 2013 um 10:33:15.877785</b></li><li>atelier : <b>Mittwoch, 28. August 2013 um 05:15:31.302605</b></li></ul></div>", "xtype": "label" }, { "items": server_status_disp3718, "autoHeight": true, "layout": "form", "xtype": "panel", "labelAlign": "top" } ], "frame": true, "layoutConfig": { "align": "stretch" }, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel3719;
    this.before_row_edit = function(record) {
    }
    Lino.about.About.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.about.Models.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  disable_editing: true,
  initComponent : function() {
    var containing_panel = this;
    var app_disp3695 = new Ext.form.DisplayField({ "disabled": true, "listeners": { "render": Lino.quicktip_renderer("app_label","(about.Models.app) ") }, "fieldLabel": "app_label", "name": "app", "anchor": "-20", "value": "<br/>", "always_enabled": true });
    var name_disp3696 = new Ext.form.DisplayField({ "disabled": true, "listeners": { "render": Lino.quicktip_renderer("name","(about.Models.name) ") }, "fieldLabel": "name", "name": "name", "anchor": "-20", "value": "<br/>", "always_enabled": true });
    var docstring_disp3697 = new Ext.form.DisplayField({ "disabled": true, "listeners": { "render": Lino.quicktip_renderer("docstring","(about.Models.docstring) ") }, "fieldLabel": "docstring", "name": "docstring", "anchor": "-20", "value": "<br/>", "always_enabled": true });
    var rows3698 = new Ext.form.NumberField({ "disabled": true, "listeners": { "render": Lino.quicktip_renderer("Zeilen","(about.Models.rows) ") }, "fieldLabel": "Zeilen", "anchor": "-20", "name": "rows" });
    var main_1_panel3699 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 90, "hideCheckBoxLabels": true, "items": [ { "flex": 31, "autoHeight": true, "layout": "form", "xtype": "panel", "items": app_disp3695, "labelAlign": "top" }, { "flex": 31, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_disp3696, "labelAlign": "top" }, { "flex": 31, "autoHeight": true, "layout": "form", "xtype": "panel", "items": docstring_disp3697, "labelAlign": "top" }, { "flex": 5, "autoHeight": true, "layout": "form", "xtype": "panel", "items": rows3698, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var about_FieldsByModel_grid3708 = new Lino.about.FieldsByModel.GridPanel({ "flex": 62, "listeners": { "render": Lino.quicktip_renderer("Felder","(about.about.FieldsByModel) ") }, "hide_top_toolbar": true, "containing_panel": this, "tools": [ Lino.show_in_own_window_button(Lino.about.FieldsByModel.grid) ], "master_panel": this });
    var main_panel3709 = new Ext.Panel({ "autoScroll": false, "border": false, "layout": "vbox", "hideCheckBoxLabels": true, "items": [ main_1_panel3699, about_FieldsByModel_grid3708 ], "frame": true, "layoutConfig": { "align": "stretch" }, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel3709;
    this.before_row_edit = function(record) {
      about_FieldsByModel_grid3708.on_master_changed();
    }
    Lino.about.Models.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.pcsw.NotesByPerson.InsertFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  autoHeight: true,
  content_type: 93,
  initComponent : function() {
    var containing_panel = this;
    var event_type998 = new Lino.TwinCombo({ "fieldLabel": "Ereignisart (Form)", "name": "event_type", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.notes.EventTypes.detail)}, "emptyText": "Event Type ausw\u00e4hlen...", "listeners": { "render": Lino.quicktip_renderer("Ereignisart (Form)","(notes.Notes.event_type) ") }, "selectOnFocus": true, "hiddenName": "event_typeHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/notes/Notes/event_type", "method": "GET" }) }) });
    var type999 = new Lino.TwinCombo({ "fieldLabel": "Notizart (Inhalt)", "name": "type", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.notes.NoteTypes.detail)}, "emptyText": "Notizart ausw\u00e4hlen...", "listeners": { "render": Lino.quicktip_renderer("Notizart (Inhalt)","(notes.Notes.type) ") }, "selectOnFocus": true, "hiddenName": "typeHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/notes/Notes/type", "method": "GET" }) }) });
    var main_1_panel1000 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": event_type998, "labelAlign": "top" }, { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": type999, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 171, "border": false, "anchor": "-20", "labelAlign": "top" });
    var subject1003 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Betreff","(notes.Notes.subject) ") }, "fieldLabel": "Betreff", "name": "subject", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var project1004 = new Lino.TwinCombo({ "preferred_width": 20, "fieldLabel": "Klient", "name": "project", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.pcsw.Clients.detail)}, "hiddenName": "projectHidden", "listeners": { "render": Lino.quicktip_renderer("Klient","(notes.Notes.project) ") }, "selectOnFocus": true, "emptyText": "Klient ausw\u00e4hlen...", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/notes/Notes/project", "method": "GET" }) }) });
    var company1005 = new Lino.TwinCombo({ "preferred_width": 20, "fieldLabel": "Empf\u00e4nger (Organisation)", "name": "company", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.contacts.Companies.detail)}, "hiddenName": "companyHidden", "listeners": { "render": Lino.quicktip_renderer("Empf\u00e4nger (Organisation)","(notes.Notes.company) ") }, "selectOnFocus": true, "emptyText": "Organisation ausw\u00e4hlen...", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/notes/Notes/company", "method": "GET" }) }) });
    var main_3_panel1006 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": project1004, "labelAlign": "top" }, { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": company1005, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 225, "border": false, "anchor": "-20", "labelAlign": "top" });
    var main_panel1009 = new Ext.Panel({ "hideCheckBoxLabels": true, "autoHeight": true, "border": false, "layout": "form", "labelWidth": 72, "autoScroll": false, "items": [ main_1_panel1000, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": subject1003, "anchor": "-20", "labelAlign": "top" }, main_3_panel1006 ], "frame": true, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel1009;
    this.before_row_edit = function(record) {
    }
    Lino.pcsw.NotesByPerson.InsertFormPanel.superclass.initComponent.call(this);
  }
});

Lino.cal.GuestStates.wf1 = new Lino.WindowAction({ "draggable": true, "width": Lino.chars2width(50), "maximizable": true, "modal": true, "maximized": false, "height": Lino.rows2height(15) },function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.reception.AppointmentsByGuest.wf1_ActionFormPanel({});
});
Lino.cal.GuestStates.wf2 = new Lino.WindowAction({ "draggable": true, "width": Lino.chars2width(50), "maximizable": true, "modal": true, "maximized": false, "height": Lino.rows2height(15) },function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.reception.AppointmentsByGuest.wf2_ActionFormPanel({});
});
Lino.cal.Guests.checkin = new Lino.WindowAction({ "draggable": true, "width": Lino.chars2width(50), "maximizable": true, "modal": true, "maximized": false, "height": Lino.rows2height(15) },function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.reception.AppointmentsByGuest.checkin_ActionFormPanel({});
});
Lino.pcsw.Coachings.create_visit = new Lino.WindowAction({ "draggable": true, "width": Lino.chars2width(50), "autoHeight": true, "maximizable": true, "modal": true, "maximized": false },function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.pcsw.CoachingsByClient.create_visit_ActionFormPanel({});
});

// js_render_GridPanel_class users.MySettings
Lino.users.MySettings.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "Keine Daten anzuzeigen." },
  ls_url : "/users/MySettings",
  ls_bbar_actions : [ { "itemId": "put", "menu_item_text": "Speichern", "tooltip": "\u00c4nderungen in diesem Formular speichern", "panel_btn_handler": function(panel){panel.save(null,false,'put')}, "iconCls": "x-tbar-save", "overflowText": "Speichern", "auto_save": false }, { "itemId": "update_reminders", "menu_item_text": "Erinnerungen aktualisieren", "must_save": true, "panel_btn_handler": Lino.row_action_handler('update_reminders','GET',null), "text": "Erinnerungen aktualisieren", "overflowText": "Erinnerungen aktualisieren", "auto_save": true } ],
  title : "Benutzer",
  page_length : 20,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "name": "username" }, { "name": "profile" }, 'profileHidden', { "name": "first_name" }, { "name": "last_name" }, { "type": "int", "name": "id" }, { "name": "created" }, { "name": "modified" }, { "name": "password" }, { "name": "initials" }, { "name": "email" }, { "name": "remarks" }, { "name": "language" }, 'languageHidden', { "name": "partner" }, 'partnerHidden', { "name": "access_class" }, 'access_classHidden', { "name": "calendar" }, 'calendarHidden', { "name": "coaching_type" }, 'coaching_typeHidden', { "type": "boolean", "name": "coaching_supervisor" }, { "type": "int", "name": "newcomer_quota" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 5,
  ls_grid_configs : [  ],
  content_type : 7,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 25,
  initComponent : function() {
    this.ls_detail_handler = Lino.users.MySettings.detail;
    this.ls_insert_handler = Lino.users.Users.insert;
    var ww = this.containing_window;
    var username3786 = new Ext.form.TextField({ "selectOnFocus": true, "allowBlank": false, "maxLength": 30 });
    var profile3787 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "forceSelection": true, "store": [['','<br>']].concat(Lino.lino.UserProfiles) });
    var first_name3788 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 30 });
    var last_name3789 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 30 });
    var id3790 = new Ext.form.NumberField({ "selectOnFocus": true });
    var created3791 = new Ext.form.DisplayField({ "disabled": true, "value": "<br>" });
    var modified3792 = new Ext.form.DisplayField({ "disabled": true, "value": "<br>" });
    var password3793 = new Ext.form.TextField({ "selectOnFocus": true, "allowBlank": false, "maxLength": 128 });
    var initials3794 = new Ext.form.TextField({ "selectOnFocus": true, "boxMinWidth": Lino.chars2width(10), "maxLength": 10 });
    var email3795 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 75 });
    var remarks3796 = new Ext.form.TextArea({ "selectOnFocus": true, "growMax": 2000 });
    var language3797 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "store": [ [ "en", "Englisch" ], [ "fr", "Franz\u00f6sisch" ], [ "de", "Deutsch" ], [ "nl", "Niederl\u00e4ndisch" ] ] });
    var partner3798 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "preferred_width": 20, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/users/MySettings/partner", "method": "GET" }) }), "pageSize": 20, "emptyText": "Partner ausw\u00e4hlen..." });
    var access_class3799 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "forceSelection": true, "allowBlank": false, "store": Lino.cal.AccessClasses });
    var calendar3800 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/users/MySettings/calendar", "method": "GET" }) }), "pageSize": 20, "emptyText": "Kalender ausw\u00e4hlen..." });
    var coaching_type3801 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/users/MySettings/coaching_type", "method": "GET" }) }), "pageSize": 20, "emptyText": "Dienst ausw\u00e4hlen..." });
    var coaching_supervisor3802 = new Ext.form.Checkbox({ "selectOnFocus": true, "checked": false });
    var newcomer_quota3803 = new Ext.form.NumberField({ "selectOnFocus": true, "allowBlank": false, "value": 0 });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ { "colIndex": 0, "sortable": true, "header": "Benutzername", "editable": true, "tooltip": "(users.MySettings.username) Required. Must be unique.", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "username", "editor": username3786 }, { "colIndex": 1, "sortable": true, "header": "Benutzerprofil", "editable": true, "tooltip": "(users.MySettings.profile) ", "filter": { "type": "string" }, "width": Lino.chars2width(37), "dataIndex": "profile", "editor": profile3787 }, { "colIndex": 2, "sortable": true, "header": "Vorname", "editable": true, "tooltip": "(users.MySettings.first_name) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "first_name", "editor": first_name3788 }, { "colIndex": 3, "sortable": true, "header": "Familienname", "editable": true, "tooltip": "(users.MySettings.last_name) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "last_name", "editor": last_name3789 }, new Lino.NullNumberColumn({ "colIndex": 4, "sortable": true, "format": "0", "editable": true, "tooltip": "(users.MySettings.id) ", "filter": { "type": "numeric" }, "header": "ID", "renderer": Lino.id_renderer, "editor": id3790, "width": Lino.chars2width(6), "dataIndex": "id" }), { "width": Lino.chars2width(17), "colIndex": 5, "sortable": true, "dataIndex": "created", "header": "Erstellt", "editable": false, "tooltip": "(users.MySettings.created) " }, { "width": Lino.chars2width(17), "colIndex": 6, "sortable": true, "dataIndex": "modified", "header": "Bearbeitet", "editable": false, "tooltip": "(users.MySettings.modified) " }, { "colIndex": 7, "sortable": true, "header": "Passwort", "editable": true, "tooltip": "(users.MySettings.password) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "password", "hidden": true, "editor": password3793 }, { "colIndex": 8, "sortable": true, "header": "Initials", "editable": true, "tooltip": "(users.MySettings.initials) ", "filter": { "type": "string" }, "width": Lino.chars2width(12), "dataIndex": "initials", "editor": initials3794 }, { "colIndex": 9, "sortable": true, "header": "e-mail address", "editable": true, "tooltip": "(users.MySettings.email) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "email", "editor": email3795 }, { "colIndex": 10, "sortable": false, "width": Lino.chars2width(61), "editable": true, "tooltip": "(users.MySettings.remarks) ", "filter": { "type": "string" }, "header": "Bemerkungen", "renderer": Lino.text_renderer, "hidden": true, "editor": remarks3796, "dataIndex": "remarks" }, { "colIndex": 11, "sortable": true, "header": "Sprache", "editable": true, "tooltip": "(users.MySettings.language) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "language", "editor": language3797 }, { "colIndex": 12, "sortable": true, "header": "Partner", "editable": true, "tooltip": "(users.MySettings.partner) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "partner", "editor": partner3798 }, { "colIndex": 13, "sortable": true, "header": "Standardm\u00e4\u00dfige Zugriffsklasse", "editable": true, "tooltip": "(users.MySettings.access_class) Die standardm\u00e4\u00dfige Zugriffsklasse f\u00fcr Ihre Termine und Aufgaben", "filter": { "type": "string" }, "width": Lino.chars2width(13), "dataIndex": "access_class", "editor": access_class3799 }, { "colIndex": 14, "sortable": true, "header": "Standard-Kalender", "editable": true, "tooltip": "(users.MySettings.calendar) The default calendar for your events and tasks.", "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "calendar", "editor": calendar3800 }, { "colIndex": 15, "sortable": true, "header": "Dienst", "editable": true, "tooltip": "(users.MySettings.coaching_type) The default CoachingType used when creating Coachings.", "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "coaching_type", "editor": coaching_type3801 }, { "colIndex": 16, "sortable": false, "xtype": "checkcolumn", "header": "Benachrichtigung wenn ein Begleiter zugewiesen wird", "editable": true, "tooltip": "(users.MySettings.coaching_supervisor) Wenn ein Neuantrag einem Begleiter zugewiesen wurde, wird au\u00dfer dem Begleiter auch dieser Benutzer benachrichtigt.", "filter": { "type": "boolean" }, "width": Lino.chars2width(11), "dataIndex": "coaching_supervisor" }, new Lino.NullNumberColumn({ "colIndex": 17, "sortable": true, "format": "0", "editable": true, "tooltip": "(users.MySettings.newcomer_quota) Wieviel Arbeitszeit dieser Benutzer f\u00fcr Neuantr\u00e4ge zur Verf\u00fcgung steht\n(100 = ganztags, 50 = halbtags, 0 = gar nicht).\nWenn zwei Benutzer die gleiche Belastungspunktzahl haben, \naber einer davon sich nur zu 50% um Neuantr\u00e4ge k\u00fcmmert, \ngilt er als doppelt so belastet wie sein Kollege.\n", "filter": { "type": "numeric" }, "header": "Quote NZ", "dataIndex": "newcomer_quota", "width": Lino.chars2width(6), "editor": newcomer_quota3803 }) ];
    Lino.users.MySettings.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.users.MySettings.put = function(rp,pk) { 
  Lino.run_row_action(rp,"/users/MySettings","GET",pk,"put",null);
};
Lino.users.MySettings.post = function(rp,pk) { 
  Lino.run_row_action(rp,"/users/MySettings","GET",pk,"post",null);
};

Lino.users.MySettings.detailPanel = Ext.extend(Lino.users.MySettings.DetailFormPanel,{
  empty_title: "Benutzer",
  ls_bbar_actions: [ { "itemId": "put", "menu_item_text": "Speichern", "tooltip": "\u00c4nderungen in diesem Formular speichern", "panel_btn_handler": function(panel){panel.save(null,false,'put')}, "iconCls": "x-tbar-save", "overflowText": "Speichern", "auto_save": false }, { "itemId": "update_reminders", "menu_item_text": "Erinnerungen aktualisieren", "must_save": true, "panel_btn_handler": Lino.row_action_handler('update_reminders','GET',null), "text": "Erinnerungen aktualisieren", "overflowText": "Erinnerungen aktualisieren", "auto_save": true } ],
  ls_url: "/users/MySettings",
  initComponent : function() {
    this.ls_detail_handler = Lino.users.MySettings.detail;
    this.ls_insert_handler = Lino.users.Users.insert;
    Lino.users.MySettings.detailPanel.superclass.initComponent.call(this);
  }
});

Lino.users.MySettings.detail = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.users.MySettings.detailPanel(p);
});

Lino.users.MySettings.detailPanel = Ext.extend(Lino.users.MySettings.DetailFormPanel,{
  empty_title: "Benutzer",
  ls_bbar_actions: [ { "itemId": "put", "menu_item_text": "Speichern", "tooltip": "\u00c4nderungen in diesem Formular speichern", "panel_btn_handler": function(panel){panel.save(null,false,'put')}, "iconCls": "x-tbar-save", "overflowText": "Speichern", "auto_save": false }, { "itemId": "update_reminders", "menu_item_text": "Erinnerungen aktualisieren", "must_save": true, "panel_btn_handler": Lino.row_action_handler('update_reminders','GET',null), "text": "Erinnerungen aktualisieren", "overflowText": "Erinnerungen aktualisieren", "auto_save": true } ],
  ls_url: "/users/MySettings",
  initComponent : function() {
    this.ls_detail_handler = Lino.users.MySettings.detail;
    this.ls_insert_handler = Lino.users.Users.insert;
    Lino.users.MySettings.detailPanel.superclass.initComponent.call(this);
  }
});

Lino.users.MySettings.detail = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.users.MySettings.detailPanel(p);
});
Lino.users.MySettings.update_reminders = function(rp,pk) { 
  Lino.run_row_action(rp,"/users/MySettings","GET",pk,"update_reminders",null);
};

// js_render_GridPanel_class properties.PropChoices
Lino.properties.PropChoices.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "Keine Daten anzuzeigen." },
  ls_url : "/properties/PropChoices",
  ls_bbar_actions : [ { "itemId": null, "menu_item_text": "L\u00f6schen", "tooltip": "Diesen Datensatz l\u00f6schen", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "L\u00f6schen", "auto_save": false } ],
  title : "Auswahlm\u00f6glichkeiten",
  page_length : 20,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "type": "int", "name": "id" }, { "name": "type" }, 'typeHidden', { "name": "value" }, { "name": "text" }, { "name": "text_fr" }, { "name": "text_de" }, { "name": "text_nl" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 0,
  ls_grid_configs : [  ],
  content_type : 16,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 9,
  initComponent : function() {
    var ww = this.containing_window;
    var id3879 = new Ext.form.NumberField({ "selectOnFocus": true });
    var type3880 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/properties/PropChoices/type", "method": "GET" }) }), "allowBlank": false, "pageSize": 20, "emptyText": "Eigenschafts-Datentyp ausw\u00e4hlen..." });
    var value3881 = new Ext.form.TextField({ "selectOnFocus": true, "allowBlank": false, "maxLength": 200 });
    var text3882 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var text_fr3883 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var text_de3884 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var text_nl3885 = new Ext.form.TextField({ "selectOnFocus": true, "hidden": true, "maxLength": 200 });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ new Lino.NullNumberColumn({ "colIndex": 0, "sortable": true, "format": "0", "editable": true, "tooltip": "(properties.PropChoices.id) ", "filter": { "type": "numeric" }, "header": "ID", "renderer": Lino.id_renderer, "editor": id3879, "width": Lino.chars2width(6), "dataIndex": "id" }), { "colIndex": 1, "sortable": true, "header": "Eigenschafts-Datentyp", "editable": true, "tooltip": "(properties.PropChoices.type) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "type", "editor": type3880 }, { "colIndex": 2, "sortable": true, "header": "Wert", "editable": true, "tooltip": "(properties.PropChoices.value) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "value", "editor": value3881 }, { "colIndex": 3, "sortable": true, "header": "Bezeichnung", "editable": true, "tooltip": "(properties.PropChoices.text) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "text", "editor": text3882 }, { "colIndex": 4, "sortable": true, "header": "Bezeichnung (fr)", "editable": true, "tooltip": "(properties.PropChoices.text_fr) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "text_fr", "editor": text_fr3883 }, { "colIndex": 5, "sortable": true, "header": "Bezeichnung (de)", "editable": true, "tooltip": "(properties.PropChoices.text_de) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "text_de", "editor": text_de3884 }, { "colIndex": 6, "sortable": true, "header": "Bezeichnung (nl)", "editable": true, "tooltip": "(properties.PropChoices.text_nl) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "text_nl", "hidden": true, "editor": text_nl3885 } ];
    Lino.properties.PropChoices.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.properties.PropChoices.put = function(rp,pk) { 
  Lino.run_row_action(rp,"/properties/PropChoices","GET",pk,"put",null);
};
Lino.properties.PropChoices.post = function(rp,pk) { 
  Lino.run_row_action(rp,"/properties/PropChoices","GET",pk,"post",null);
};
Lino.properties.PropChoices.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.properties.PropChoices.GridPanel(p);
});

// js_render_GridPanel_class cbss.IdentifyPersonRequests
Lino.cbss.IdentifyPersonRequests.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "Keine Daten anzuzeigen." },
  ls_url : "/cbss/IdentifyPersonRequests",
  ls_bbar_actions : [ { "itemId": "insert", "menu_item_text": "Neu", "must_save": true, "tooltip": "Neuen Datensatz erstellen", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-new", "overflowText": "Neu", "auto_save": true }, { "itemId": "duplicate", "menu_item_text": "Duplizieren", "must_save": true, "tooltip": "Duplizieren", "panel_btn_handler": Lino.row_action_handler('duplicate','GET',null), "iconCls": "x-tbar-duplicate", "overflowText": "Duplizieren", "auto_save": true }, { "itemId": "detail", "menu_item_text": "Detail", "tooltip": "Detail-Fenster auf diesem Datensatz \u00f6ffnen", "panel_btn_handler": Lino.show_detail, "iconCls": "x-tbar-detail", "overflowText": "Detail", "auto_save": true }, { "itemId": null, "menu_item_text": "L\u00f6schen", "tooltip": "Diesen Datensatz l\u00f6schen", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "L\u00f6schen", "auto_save": false }, { "itemId": "do_print", "menu_item_text": "Drucken", "must_save": true, "tooltip": "Drucken", "panel_btn_handler": Lino.row_action_handler('do_print','GET',null), "iconCls": "x-tbar-print", "overflowText": "Drucken", "auto_save": true } ],
  title : "IdentifyPerson-Anfragen",
  page_length : 20,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "type": "int", "name": "id" }, { "name": "user" }, 'userHidden', { "name": "person" }, 'personHidden', { "name": "sent" }, { "name": "status" }, 'statusHidden', { "name": "environment" }, { "name": "ticket" }, { "name": "request_xml" }, { "name": "response_xml" }, { "name": "debug_messages" }, { "name": "info_messages" }, { "name": "national_id" }, { "name": "birth_date" }, { "name": "sis_card_no" }, { "name": "id_card_no" }, { "name": "first_name" }, { "name": "last_name" }, { "name": "middle_name" }, { "name": "gender" }, 'genderHidden', { "type": "int", "name": "tolerance" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 0,
  ls_grid_configs : [  ],
  content_type : 92,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 25,
  initComponent : function() {
    this.ls_detail_handler = Lino.cbss.IdentifyPersonRequests.detail;
    this.ls_insert_handler = Lino.cbss.IdentifyPersonRequests.insert;
    var ww = this.containing_window;
    var id5167 = new Ext.form.NumberField({ "selectOnFocus": true });
    var user5168 = new Lino.RemoteComboFieldElement({ "preferred_width": 15, "allowBlank": false, "pageSize": 20, "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cbss/IdentifyPersonRequests/user", "method": "GET" }) }), "emptyText": "Benutzer ausw\u00e4hlen..." });
    var person5169 = new Lino.RemoteComboFieldElement({ "preferred_width": 20, "allowBlank": false, "pageSize": 20, "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cbss/IdentifyPersonRequests/person", "method": "GET" }) }), "emptyText": "Klient ausw\u00e4hlen..." });
    var sent5170 = new Ext.form.DisplayField({ "disabled": true, "value": "<br>" });
    var status5171 = new Lino.ChoicesFieldElement({ "disabled": true, "forceSelection": true, "store": [['','<br>']].concat(Lino.cbss.RequestStates) });
    var environment5172 = new Ext.form.TextField({ "disabled": true, "boxMinWidth": Lino.chars2width(4), "maxLength": 4 });
    var ticket5173 = new Ext.form.TextField({ "disabled": true, "maxLength": 36 });
    var request_xml5174 = new Ext.form.TextArea({ "disabled": true, "growMax": 2000 });
    var response_xml5175 = new Ext.form.TextArea({ "disabled": true, "growMax": 2000 });
    var debug_messages5176 = new Ext.form.TextArea({ "disabled": true, "growMax": 2000 });
    var info_messages5177 = new Ext.form.TextArea({ "disabled": true, "growMax": 2000 });
    var national_id5178 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var birth_date5179 = new Lino.IncompleteDateField({ "selectOnFocus": true, "allowBlank": false });
    var sis_card_no5180 = new Ext.form.TextField({ "selectOnFocus": true, "boxMinWidth": Lino.chars2width(10), "maxLength": 10 });
    var id_card_no5181 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 20 });
    var first_name5182 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var last_name5183 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var middle_name5184 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var gender5185 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "forceSelection": true, "store": [['','<br>']].concat(Lino.lino.Genders) });
    var tolerance5186 = new Ext.form.NumberField({ "selectOnFocus": true, "allowBlank": false, "value": 0 });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ new Lino.NullNumberColumn({ "colIndex": 0, "sortable": true, "format": "0", "editable": true, "tooltip": "(cbss.IdentifyPersonRequests.id) ", "filter": { "type": "numeric" }, "header": "ID", "renderer": Lino.id_renderer, "editor": id5167, "width": Lino.chars2width(6), "dataIndex": "id" }), { "colIndex": 1, "sortable": true, "header": "Autor", "editable": true, "tooltip": "(cbss.IdentifyPersonRequests.user) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "user", "editor": user5168 }, { "colIndex": 2, "sortable": true, "header": "Klient", "editable": true, "tooltip": "(cbss.IdentifyPersonRequests.person) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "person", "editor": person5169 }, { "width": Lino.chars2width(17), "colIndex": 3, "sortable": true, "dataIndex": "sent", "header": "Versendet", "editable": false, "tooltip": "(cbss.IdentifyPersonRequests.sent) The date and time when this request has been executed. \nThis is empty for requests than haven't been sent.\nRead-only." }, { "colIndex": 4, "sortable": true, "header": "Zustand", "editable": false, "tooltip": "(cbss.IdentifyPersonRequests.status) ", "filter": { "type": "string" }, "width": Lino.chars2width(13), "dataIndex": "status" }, { "colIndex": 5, "sortable": true, "header": "T/A/B", "editable": false, "tooltip": "(cbss.IdentifyPersonRequests.environment) ", "filter": { "type": "string" }, "width": Lino.chars2width(6), "dataIndex": "environment" }, { "colIndex": 6, "sortable": true, "header": "Ticket", "editable": false, "tooltip": "(cbss.IdentifyPersonRequests.ticket) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "ticket" }, { "colIndex": 7, "sortable": false, "header": "Abfrage", "editable": false, "tooltip": "(cbss.IdentifyPersonRequests.request_xml) The raw XML string that has (or would have) been sent.", "filter": { "type": "string" }, "width": Lino.chars2width(61), "dataIndex": "request_xml", "renderer": Lino.text_renderer }, { "colIndex": 8, "sortable": false, "header": "Antwort", "editable": false, "tooltip": "(cbss.IdentifyPersonRequests.response_xml) The raw XML response received. \n", "filter": { "type": "string" }, "width": Lino.chars2width(61), "dataIndex": "response_xml", "renderer": Lino.text_renderer }, { "colIndex": 9, "sortable": false, "header": "Debug-Meldungen", "editable": false, "tooltip": "(cbss.IdentifyPersonRequests.debug_messages) ", "filter": { "type": "string" }, "width": Lino.chars2width(61), "dataIndex": "debug_messages", "renderer": Lino.text_renderer }, { "colIndex": 10, "sortable": false, "header": "Info-Meldungen", "editable": false, "tooltip": "(cbss.IdentifyPersonRequests.info_messages) ", "filter": { "type": "string" }, "width": Lino.chars2width(61), "dataIndex": "info_messages", "renderer": Lino.text_renderer }, { "colIndex": 11, "sortable": true, "header": "NR-Nummer", "editable": true, "tooltip": "(cbss.IdentifyPersonRequests.national_id) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "national_id", "editor": national_id5178 }, { "colIndex": 12, "sortable": true, "header": "Geburtsdatum", "editable": true, "tooltip": "(cbss.IdentifyPersonRequests.birth_date) Uncomplete dates are allowed, e.g. \n\"00.00.1980\" means \"some day in 1980\", \n\"00.07.1980\" means \"in July 1980\"\nor \"23.07.0000\" means \"on a 23th of July\".", "filter": { "type": "string" }, "width": Lino.chars2width(13), "dataIndex": "birth_date", "editor": birth_date5179 }, { "colIndex": 13, "sortable": true, "header": "SIS-Karten-Nr", "editable": true, "tooltip": "(cbss.IdentifyPersonRequests.sis_card_no) The number of the SIS card used to authenticate the person.", "filter": { "type": "string" }, "width": Lino.chars2width(12), "dataIndex": "sis_card_no", "editor": sis_card_no5180 }, { "colIndex": 14, "sortable": true, "header": "ID-Karten-Nr", "editable": true, "tooltip": "(cbss.IdentifyPersonRequests.id_card_no) The number of the ID card used to authenticate the person.", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "id_card_no", "editor": id_card_no5181 }, { "colIndex": 15, "sortable": true, "header": "Vorname", "editable": true, "tooltip": "(cbss.IdentifyPersonRequests.first_name) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "first_name", "editor": first_name5182 }, { "colIndex": 16, "sortable": true, "header": "Familienname", "editable": true, "tooltip": "(cbss.IdentifyPersonRequests.last_name) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "last_name", "editor": last_name5183 }, { "colIndex": 17, "sortable": true, "header": "Mittelnamen", "editable": true, "tooltip": "(cbss.IdentifyPersonRequests.middle_name) Whatever this means...", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "middle_name", "editor": middle_name5184 }, { "colIndex": 18, "sortable": true, "header": "Geschlecht", "editable": true, "tooltip": "(cbss.IdentifyPersonRequests.gender) ", "filter": { "type": "string" }, "width": Lino.chars2width(10), "dataIndex": "gender", "editor": gender5185 }, new Lino.NullNumberColumn({ "colIndex": 19, "sortable": true, "format": "0", "editable": true, "tooltip": "(cbss.IdentifyPersonRequests.tolerance) \n      Falls Monat oder Tag des Geburtsdatums unbekannt sind, \n      um wieviel Monate bzw. Tage die Suche nach unten/oben ausgeweitet wird.\n      G\u00fcltige Werte: 0 bis 10.\n      ", "filter": { "type": "numeric" }, "header": "Toleranz", "dataIndex": "tolerance", "width": Lino.chars2width(6), "editor": tolerance5186 }) ];
    Lino.cbss.IdentifyPersonRequests.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.cbss.IdentifyPersonRequests.put = function(rp,pk) { 
  Lino.run_row_action(rp,"/cbss/IdentifyPersonRequests","GET",pk,"put",null);
};
Lino.cbss.IdentifyPersonRequests.post = function(rp,pk) { 
  Lino.run_row_action(rp,"/cbss/IdentifyPersonRequests","GET",pk,"post",null);
};

Lino.cbss.IdentifyPersonRequests.insertPanel = Ext.extend(Lino.cbss.IdentifyPersonRequests.InsertFormPanel,{
  empty_title: "Neu IdentifyPerson-Anfragen",
  hide_navigator: true,
  ls_bbar_actions: [ { "itemId": "post", "menu_item_text": "Erstellen", "tooltip": "Datensatz erstellen und dann im Detail-Fenster \u00f6ffnen", "panel_btn_handler": function(panel){panel.save(null,true,'post')}, "text": "Erstellen", "overflowText": "Erstellen", "auto_save": false }, { "itemId": "poststay", "menu_item_text": "Erstellen ohne Detail", "tooltip": "Nach Erstellen des Datensatzes kein Detail-Fenster \u00f6ffnen", "panel_btn_handler": function(panel){panel.save(null,false,'poststay')}, "text": "Erstellen ohne Detail", "overflowText": "Erstellen ohne Detail", "auto_save": false } ],
  ls_url: "/cbss/IdentifyPersonRequests",
  action_name: "insert",
  initComponent : function() {
    this.ls_detail_handler = Lino.cbss.IdentifyPersonRequests.detail;
    this.ls_insert_handler = Lino.cbss.IdentifyPersonRequests.insert;
    Lino.cbss.IdentifyPersonRequests.insertPanel.superclass.initComponent.call(this);
  }
});

Lino.cbss.IdentifyPersonRequests.insert = new Lino.WindowAction({ "draggable": true, "width": Lino.chars2width(60), "autoHeight": true, "maximizable": true, "modal": true, "maximized": false },function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.cbss.IdentifyPersonRequests.insertPanel(p);
});
Lino.cbss.IdentifyPersonRequests.poststay = function(rp,pk) { 
  Lino.run_row_action(rp,"/cbss/IdentifyPersonRequests","GET",pk,"poststay",null);
};
Lino.cbss.IdentifyPersonRequests.duplicate = function(rp,pk) { 
  Lino.run_row_action(rp,"/cbss/IdentifyPersonRequests","GET",pk,"duplicate",null);
};

Lino.cbss.IdentifyPersonRequests.detailPanel = Ext.extend(Lino.cbss.IdentifyPersonRequests.DetailFormPanel,{
  empty_title: "Detail IdentifyPerson-Anfragen",
  ls_bbar_actions: [ { "itemId": "put", "menu_item_text": "Speichern", "tooltip": "\u00c4nderungen in diesem Formular speichern", "panel_btn_handler": function(panel){panel.save(null,false,'put')}, "iconCls": "x-tbar-save", "overflowText": "Speichern", "auto_save": false }, { "itemId": "insert", "menu_item_text": "Neu", "must_save": true, "tooltip": "Neuen Datensatz erstellen", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-new", "overflowText": "Neu", "auto_save": true }, { "itemId": "duplicate", "menu_item_text": "Duplizieren", "must_save": true, "tooltip": "Duplizieren", "panel_btn_handler": Lino.row_action_handler('duplicate','GET',null), "iconCls": "x-tbar-duplicate", "overflowText": "Duplizieren", "auto_save": true }, { "itemId": null, "menu_item_text": "L\u00f6schen", "tooltip": "Diesen Datensatz l\u00f6schen", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "L\u00f6schen", "auto_save": false }, { "itemId": "do_print", "menu_item_text": "Drucken", "must_save": true, "tooltip": "Drucken", "panel_btn_handler": Lino.row_action_handler('do_print','GET',null), "iconCls": "x-tbar-print", "overflowText": "Drucken", "auto_save": true } ],
  ls_url: "/cbss/IdentifyPersonRequests",
  action_name: "detail",
  initComponent : function() {
    this.ls_detail_handler = Lino.cbss.IdentifyPersonRequests.detail;
    this.ls_insert_handler = Lino.cbss.IdentifyPersonRequests.insert;
    Lino.cbss.IdentifyPersonRequests.detailPanel.superclass.initComponent.call(this);
  }
});

Lino.cbss.IdentifyPersonRequests.detail = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.cbss.IdentifyPersonRequests.detailPanel(p);
});
Lino.cbss.IdentifyPersonRequests.do_print = function(rp,pk) { 
  Lino.run_row_action(rp,"/cbss/IdentifyPersonRequests","GET",pk,"do_print",null);
};
Lino.cbss.IdentifyPersonRequests.edit_template = function(rp,pk) { 
  Lino.run_row_action(rp,"/cbss/IdentifyPersonRequests","GET",pk,"edit_template",null);
};
Lino.cbss.IdentifyPersonRequests.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.cbss.IdentifyPersonRequests.GridPanel(p);
});

// js_render_GridPanel_class cbss.ManageAccessRequests
Lino.cbss.ManageAccessRequests.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "Keine Daten anzuzeigen." },
  ls_url : "/cbss/ManageAccessRequests",
  ls_bbar_actions : [ { "itemId": "insert", "menu_item_text": "Neu", "must_save": true, "tooltip": "Neuen Datensatz erstellen", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-new", "overflowText": "Neu", "auto_save": true }, { "itemId": "duplicate", "menu_item_text": "Duplizieren", "must_save": true, "tooltip": "Duplizieren", "panel_btn_handler": Lino.row_action_handler('duplicate','GET',null), "iconCls": "x-tbar-duplicate", "overflowText": "Duplizieren", "auto_save": true }, { "itemId": "detail", "menu_item_text": "Detail", "tooltip": "Detail-Fenster auf diesem Datensatz \u00f6ffnen", "panel_btn_handler": Lino.show_detail, "iconCls": "x-tbar-detail", "overflowText": "Detail", "auto_save": true }, { "itemId": null, "menu_item_text": "L\u00f6schen", "tooltip": "Diesen Datensatz l\u00f6schen", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "L\u00f6schen", "auto_save": false }, { "itemId": "do_print", "menu_item_text": "Drucken", "must_save": true, "tooltip": "Drucken", "panel_btn_handler": Lino.row_action_handler('do_print','GET',null), "iconCls": "x-tbar-print", "overflowText": "Drucken", "auto_save": true } ],
  title : "ManageAccess-Anfragen",
  page_length : 20,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "type": "int", "name": "id" }, { "name": "user" }, 'userHidden', { "name": "person" }, 'personHidden', { "name": "sent" }, { "name": "status" }, 'statusHidden', { "name": "environment" }, { "name": "ticket" }, { "name": "request_xml" }, { "name": "response_xml" }, { "name": "debug_messages" }, { "name": "info_messages" }, { "name": "national_id" }, { "name": "birth_date" }, { "name": "sis_card_no" }, { "name": "id_card_no" }, { "name": "first_name" }, { "name": "last_name" }, { "name": "sector" }, 'sectorHidden', { "name": "purpose" }, 'purposeHidden', { "type": "date", "name": "start_date", "dateFormat": "d.m.Y" }, { "type": "date", "name": "end_date", "dateFormat": "d.m.Y" }, { "name": "action" }, 'actionHidden', { "name": "query_register" }, 'query_registerHidden', { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 0,
  ls_grid_configs : [  ],
  content_type : 90,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 31,
  initComponent : function() {
    this.ls_detail_handler = Lino.cbss.ManageAccessRequests.detail;
    this.ls_insert_handler = Lino.cbss.ManageAccessRequests.insert;
    var ww = this.containing_window;
    var id5188 = new Ext.form.NumberField({ "selectOnFocus": true });
    var user5189 = new Lino.RemoteComboFieldElement({ "preferred_width": 15, "allowBlank": false, "pageSize": 20, "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cbss/ManageAccessRequests/user", "method": "GET" }) }), "emptyText": "Benutzer ausw\u00e4hlen..." });
    var person5190 = new Lino.RemoteComboFieldElement({ "preferred_width": 20, "allowBlank": false, "pageSize": 20, "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cbss/ManageAccessRequests/person", "method": "GET" }) }), "emptyText": "Klient ausw\u00e4hlen..." });
    var sent5191 = new Ext.form.DisplayField({ "disabled": true, "value": "<br>" });
    var status5192 = new Lino.ChoicesFieldElement({ "disabled": true, "forceSelection": true, "store": [['','<br>']].concat(Lino.cbss.RequestStates) });
    var environment5193 = new Ext.form.TextField({ "disabled": true, "boxMinWidth": Lino.chars2width(4), "maxLength": 4 });
    var ticket5194 = new Ext.form.TextField({ "disabled": true, "maxLength": 36 });
    var request_xml5195 = new Ext.form.TextArea({ "disabled": true, "growMax": 2000 });
    var response_xml5196 = new Ext.form.TextArea({ "disabled": true, "growMax": 2000 });
    var debug_messages5197 = new Ext.form.TextArea({ "disabled": true, "growMax": 2000 });
    var info_messages5198 = new Ext.form.TextArea({ "disabled": true, "growMax": 2000 });
    var national_id5199 = new Ext.form.TextField({ "selectOnFocus": true, "allowBlank": false, "maxLength": 200 });
    var birth_date5200 = new Lino.IncompleteDateField({ "selectOnFocus": true });
    var sis_card_no5201 = new Ext.form.TextField({ "selectOnFocus": true, "boxMinWidth": Lino.chars2width(10), "maxLength": 10 });
    var id_card_no5202 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 20 });
    var first_name5203 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var last_name5204 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var sector5205 = new Lino.RemoteComboFieldElement({ "disabled": true, "store": new Lino.ComplexRemoteComboStore({  }), "pageSize": 20, "emptyText": "Sektor ausw\u00e4hlen..." });
    var purpose5206 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cbss/ManageAccessRequests/purpose", "method": "GET" }) }), "allowBlank": false, "pageSize": 20, "emptyText": "Eigenschafts-Code ausw\u00e4hlen..." });
    var start_date5207 = new Lino.DateField({ "selectOnFocus": true, "allowBlank": false });
    var end_date5208 = new Lino.DateField({ "selectOnFocus": true, "allowBlank": false });
    var action5209 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "forceSelection": true, "allowBlank": false, "store": Lino.cbss.ManageAction });
    var query_register5210 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "forceSelection": true, "allowBlank": false, "store": Lino.cbss.QueryRegister });
    this.before_row_edit = function(record) {
      purpose5206.setContextValue('sector',record ? record.data['sectorHidden'] : undefined);
    };
    this.onRender = function(ct, position) {
      sector5205.on('change',Lino.chooser_handler(purpose5206,'sector'));
      Lino.cbss.ManageAccessRequests.GridPanel.superclass.onRender.call(this, ct, position);
    }
    this.ls_columns = [ new Lino.NullNumberColumn({ "colIndex": 0, "sortable": true, "format": "0", "editable": true, "tooltip": "(cbss.ManageAccessRequests.id) ", "filter": { "type": "numeric" }, "header": "ID", "renderer": Lino.id_renderer, "editor": id5188, "width": Lino.chars2width(6), "dataIndex": "id" }), { "colIndex": 1, "sortable": true, "header": "Autor", "editable": true, "tooltip": "(cbss.ManageAccessRequests.user) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "user", "editor": user5189 }, { "colIndex": 2, "sortable": true, "header": "Klient", "editable": true, "tooltip": "(cbss.ManageAccessRequests.person) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "person", "editor": person5190 }, { "width": Lino.chars2width(17), "colIndex": 3, "sortable": true, "dataIndex": "sent", "header": "Versendet", "editable": false, "tooltip": "(cbss.ManageAccessRequests.sent) The date and time when this request has been executed. \nThis is empty for requests than haven't been sent.\nRead-only." }, { "colIndex": 4, "sortable": true, "header": "Zustand", "editable": false, "tooltip": "(cbss.ManageAccessRequests.status) ", "filter": { "type": "string" }, "width": Lino.chars2width(13), "dataIndex": "status" }, { "colIndex": 5, "sortable": true, "header": "T/A/B", "editable": false, "tooltip": "(cbss.ManageAccessRequests.environment) ", "filter": { "type": "string" }, "width": Lino.chars2width(6), "dataIndex": "environment" }, { "colIndex": 6, "sortable": true, "header": "Ticket", "editable": false, "tooltip": "(cbss.ManageAccessRequests.ticket) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "ticket" }, { "colIndex": 7, "sortable": false, "header": "Abfrage", "editable": false, "tooltip": "(cbss.ManageAccessRequests.request_xml) The raw XML string that has (or would have) been sent.", "filter": { "type": "string" }, "width": Lino.chars2width(61), "dataIndex": "request_xml", "renderer": Lino.text_renderer }, { "colIndex": 8, "sortable": false, "header": "Antwort", "editable": false, "tooltip": "(cbss.ManageAccessRequests.response_xml) The raw XML response received. \n", "filter": { "type": "string" }, "width": Lino.chars2width(61), "dataIndex": "response_xml", "renderer": Lino.text_renderer }, { "colIndex": 9, "sortable": false, "header": "Debug-Meldungen", "editable": false, "tooltip": "(cbss.ManageAccessRequests.debug_messages) ", "filter": { "type": "string" }, "width": Lino.chars2width(61), "dataIndex": "debug_messages", "renderer": Lino.text_renderer }, { "colIndex": 10, "sortable": false, "header": "Info-Meldungen", "editable": false, "tooltip": "(cbss.ManageAccessRequests.info_messages) ", "filter": { "type": "string" }, "width": Lino.chars2width(61), "dataIndex": "info_messages", "renderer": Lino.text_renderer }, { "colIndex": 11, "sortable": true, "header": "NR-Nummer", "editable": true, "tooltip": "(cbss.ManageAccessRequests.national_id) The SSIN of the person to register/unregister/list.\n", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "national_id", "editor": national_id5199 }, { "colIndex": 12, "sortable": true, "header": "Geburtsdatum", "editable": true, "tooltip": "(cbss.ManageAccessRequests.birth_date) Uncomplete dates are allowed, e.g. \n\"00.00.1980\" means \"some day in 1980\", \n\"00.07.1980\" means \"in July 1980\"\nor \"23.07.0000\" means \"on a 23th of July\".", "filter": { "type": "string" }, "width": Lino.chars2width(13), "dataIndex": "birth_date", "editor": birth_date5200 }, { "colIndex": 13, "sortable": true, "header": "SIS-Karten-Nr", "editable": true, "tooltip": "(cbss.ManageAccessRequests.sis_card_no) The number of the SIS card used to authenticate the person.", "filter": { "type": "string" }, "width": Lino.chars2width(12), "dataIndex": "sis_card_no", "editor": sis_card_no5201 }, { "colIndex": 14, "sortable": true, "header": "ID-Karten-Nr", "editable": true, "tooltip": "(cbss.ManageAccessRequests.id_card_no) The number of the ID card used to authenticate the person.", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "id_card_no", "editor": id_card_no5202 }, { "colIndex": 15, "sortable": true, "header": "Vorname", "editable": true, "tooltip": "(cbss.ManageAccessRequests.first_name) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "first_name", "editor": first_name5203 }, { "colIndex": 16, "sortable": true, "header": "Familienname", "editable": true, "tooltip": "(cbss.ManageAccessRequests.last_name) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "last_name", "editor": last_name5204 }, { "colIndex": 17, "sortable": true, "header": "Sektor", "editable": false, "tooltip": "(cbss.ManageAccessRequests.sector) For register and unregister this element is ignored. \nIt can be used for list, \nwhen information about sectors is required.", "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "sector" }, { "colIndex": 18, "sortable": true, "header": "Eigenschafts-Code", "editable": true, "tooltip": "(cbss.ManageAccessRequests.purpose) The purpose for which the inscription needs to be \nregistered/unregistered or listed. \nFor listing this field is optional, \nfor register/unregister it is mandatory.", "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "purpose", "editor": purpose5206 }, { "colIndex": 19, "sortable": true, "xtype": "datecolumn", "format": "d.m.Y", "editable": true, "tooltip": "(cbss.ManageAccessRequests.start_date) ", "filter": { "type": "date", "dateFormat": "d.m.Y" }, "header": "Periode vom", "dataIndex": "start_date", "width": Lino.chars2width(9), "editor": start_date5207 }, { "colIndex": 20, "sortable": true, "xtype": "datecolumn", "format": "d.m.Y", "editable": true, "tooltip": "(cbss.ManageAccessRequests.end_date) ", "filter": { "type": "date", "dateFormat": "d.m.Y" }, "header": "Periode bis", "dataIndex": "end_date", "width": Lino.chars2width(9), "editor": end_date5208 }, { "colIndex": 21, "sortable": true, "header": "Aktion", "editable": true, "tooltip": "(cbss.ManageAccessRequests.action) ", "filter": { "type": "string" }, "width": Lino.chars2width(14), "dataIndex": "action", "editor": action5209 }, { "colIndex": 22, "sortable": true, "header": "Abfrageregister", "editable": true, "tooltip": "(cbss.ManageAccessRequests.query_register) ", "filter": { "type": "string" }, "width": Lino.chars2width(13), "dataIndex": "query_register", "editor": query_register5210 } ];
    Lino.cbss.ManageAccessRequests.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.cbss.ManageAccessRequests.put = function(rp,pk) { 
  Lino.run_row_action(rp,"/cbss/ManageAccessRequests","GET",pk,"put",null);
};
Lino.cbss.ManageAccessRequests.post = function(rp,pk) { 
  Lino.run_row_action(rp,"/cbss/ManageAccessRequests","GET",pk,"post",null);
};

Lino.cbss.ManageAccessRequests.insertPanel = Ext.extend(Lino.cbss.ManageAccessRequests.InsertFormPanel,{
  empty_title: "Neu ManageAccess-Anfragen",
  hide_navigator: true,
  ls_bbar_actions: [ { "itemId": "post", "menu_item_text": "Erstellen", "tooltip": "Datensatz erstellen und dann im Detail-Fenster \u00f6ffnen", "panel_btn_handler": function(panel){panel.save(null,true,'post')}, "text": "Erstellen", "overflowText": "Erstellen", "auto_save": false }, { "itemId": "poststay", "menu_item_text": "Erstellen ohne Detail", "tooltip": "Nach Erstellen des Datensatzes kein Detail-Fenster \u00f6ffnen", "panel_btn_handler": function(panel){panel.save(null,false,'poststay')}, "text": "Erstellen ohne Detail", "overflowText": "Erstellen ohne Detail", "auto_save": false } ],
  ls_url: "/cbss/ManageAccessRequests",
  action_name: "insert",
  initComponent : function() {
    this.ls_detail_handler = Lino.cbss.ManageAccessRequests.detail;
    this.ls_insert_handler = Lino.cbss.ManageAccessRequests.insert;
    Lino.cbss.ManageAccessRequests.insertPanel.superclass.initComponent.call(this);
  }
});

Lino.cbss.ManageAccessRequests.insert = new Lino.WindowAction({ "draggable": true, "width": Lino.chars2width(60), "autoHeight": true, "maximizable": true, "modal": true, "maximized": false },function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.cbss.ManageAccessRequests.insertPanel(p);
});
Lino.cbss.ManageAccessRequests.poststay = function(rp,pk) { 
  Lino.run_row_action(rp,"/cbss/ManageAccessRequests","GET",pk,"poststay",null);
};
Lino.cbss.ManageAccessRequests.duplicate = function(rp,pk) { 
  Lino.run_row_action(rp,"/cbss/ManageAccessRequests","GET",pk,"duplicate",null);
};

Lino.cbss.ManageAccessRequests.detailPanel = Ext.extend(Lino.cbss.ManageAccessRequests.DetailFormPanel,{
  empty_title: "Detail ManageAccess-Anfragen",
  ls_bbar_actions: [ { "itemId": "put", "menu_item_text": "Speichern", "tooltip": "\u00c4nderungen in diesem Formular speichern", "panel_btn_handler": function(panel){panel.save(null,false,'put')}, "iconCls": "x-tbar-save", "overflowText": "Speichern", "auto_save": false }, { "itemId": "insert", "menu_item_text": "Neu", "must_save": true, "tooltip": "Neuen Datensatz erstellen", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-new", "overflowText": "Neu", "auto_save": true }, { "itemId": "duplicate", "menu_item_text": "Duplizieren", "must_save": true, "tooltip": "Duplizieren", "panel_btn_handler": Lino.row_action_handler('duplicate','GET',null), "iconCls": "x-tbar-duplicate", "overflowText": "Duplizieren", "auto_save": true }, { "itemId": null, "menu_item_text": "L\u00f6schen", "tooltip": "Diesen Datensatz l\u00f6schen", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "L\u00f6schen", "auto_save": false }, { "itemId": "do_print", "menu_item_text": "Drucken", "must_save": true, "tooltip": "Drucken", "panel_btn_handler": Lino.row_action_handler('do_print','GET',null), "iconCls": "x-tbar-print", "overflowText": "Drucken", "auto_save": true } ],
  ls_url: "/cbss/ManageAccessRequests",
  action_name: "detail",
  initComponent : function() {
    this.ls_detail_handler = Lino.cbss.ManageAccessRequests.detail;
    this.ls_insert_handler = Lino.cbss.ManageAccessRequests.insert;
    Lino.cbss.ManageAccessRequests.detailPanel.superclass.initComponent.call(this);
  }
});

Lino.cbss.ManageAccessRequests.detail = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.cbss.ManageAccessRequests.detailPanel(p);
});
Lino.cbss.ManageAccessRequests.do_print = function(rp,pk) { 
  Lino.run_row_action(rp,"/cbss/ManageAccessRequests","GET",pk,"do_print",null);
};
Lino.cbss.ManageAccessRequests.edit_template = function(rp,pk) { 
  Lino.run_row_action(rp,"/cbss/ManageAccessRequests","GET",pk,"edit_template",null);
};
Lino.cbss.ManageAccessRequests.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.cbss.ManageAccessRequests.GridPanel(p);
});

// js_render_GridPanel_class cbss.RetrieveTIGroupsRequests
Lino.cbss.RetrieveTIGroupsRequests.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "Keine Daten anzuzeigen." },
  ls_url : "/cbss/RetrieveTIGroupsRequests",
  ls_bbar_actions : [ { "itemId": "insert", "menu_item_text": "Neu", "must_save": true, "tooltip": "Neuen Datensatz erstellen", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-new", "overflowText": "Neu", "auto_save": true }, { "itemId": "duplicate", "menu_item_text": "Duplizieren", "must_save": true, "tooltip": "Duplizieren", "panel_btn_handler": Lino.row_action_handler('duplicate','GET',null), "iconCls": "x-tbar-duplicate", "overflowText": "Duplizieren", "auto_save": true }, { "itemId": "detail", "menu_item_text": "Detail", "tooltip": "Detail-Fenster auf diesem Datensatz \u00f6ffnen", "panel_btn_handler": Lino.show_detail, "iconCls": "x-tbar-detail", "overflowText": "Detail", "auto_save": true }, { "itemId": null, "menu_item_text": "L\u00f6schen", "tooltip": "Diesen Datensatz l\u00f6schen", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "L\u00f6schen", "auto_save": false }, { "itemId": "do_print", "menu_item_text": "Drucken", "must_save": true, "tooltip": "Drucken", "panel_btn_handler": Lino.row_action_handler('do_print','GET',null), "iconCls": "x-tbar-print", "overflowText": "Drucken", "auto_save": true } ],
  title : "Tx25-Anfragen",
  page_length : 20,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "type": "int", "name": "id" }, { "name": "user" }, 'userHidden', { "name": "person" }, 'personHidden', { "name": "national_id" }, { "name": "language" }, 'languageHidden', { "type": "boolean", "name": "history" }, { "name": "status" }, 'statusHidden', { "name": "ticket" }, { "name": "sent" }, { "name": "environment" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 0,
  ls_grid_configs : [  ],
  content_type : 89,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 15,
  initComponent : function() {
    this.ls_detail_handler = Lino.cbss.RetrieveTIGroupsRequests.detail;
    this.ls_insert_handler = Lino.cbss.RetrieveTIGroupsRequests.insert;
    var ww = this.containing_window;
    var id5212 = new Ext.form.NumberField({ "selectOnFocus": true });
    var user5213 = new Lino.RemoteComboFieldElement({ "preferred_width": 15, "allowBlank": false, "pageSize": 20, "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cbss/RetrieveTIGroupsRequests/user", "method": "GET" }) }), "emptyText": "Benutzer ausw\u00e4hlen..." });
    var person5214 = new Lino.RemoteComboFieldElement({ "preferred_width": 20, "allowBlank": false, "pageSize": 20, "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cbss/RetrieveTIGroupsRequests/person", "method": "GET" }) }), "emptyText": "Klient ausw\u00e4hlen..." });
    var national_id5215 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var language5216 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "forceSelection": true, "store": [['','<br>']].concat(Lino.cbss.RequestLanguages) });
    var history5217 = new Ext.form.Checkbox({ "selectOnFocus": true, "checked": true });
    var status5218 = new Lino.ChoicesFieldElement({ "disabled": true, "forceSelection": true, "store": [['','<br>']].concat(Lino.cbss.RequestStates) });
    var ticket5219 = new Ext.form.TextField({ "disabled": true, "maxLength": 36 });
    var sent5220 = new Ext.form.DisplayField({ "disabled": true, "value": "<br>" });
    var environment5221 = new Ext.form.TextField({ "disabled": true, "boxMinWidth": Lino.chars2width(4), "maxLength": 4 });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ new Lino.NullNumberColumn({ "colIndex": 0, "sortable": true, "format": "0", "editable": true, "tooltip": "(cbss.RetrieveTIGroupsRequests.id) ", "filter": { "type": "numeric" }, "header": "ID", "renderer": Lino.id_renderer, "editor": id5212, "width": Lino.chars2width(6), "dataIndex": "id" }), { "colIndex": 1, "sortable": true, "header": "Autor", "editable": true, "tooltip": "(cbss.RetrieveTIGroupsRequests.user) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "user", "editor": user5213 }, { "colIndex": 2, "sortable": true, "header": "Klient", "editable": true, "tooltip": "(cbss.RetrieveTIGroupsRequests.person) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "person", "editor": person5214 }, { "colIndex": 3, "sortable": true, "header": "NR-Nummer", "editable": true, "tooltip": "(cbss.RetrieveTIGroupsRequests.national_id) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "national_id", "editor": national_id5215 }, { "colIndex": 4, "sortable": true, "header": "Sprache", "editable": true, "tooltip": "(cbss.RetrieveTIGroupsRequests.language) ", "filter": { "type": "string" }, "width": Lino.chars2width(10), "dataIndex": "language", "editor": language5216 }, { "colIndex": 5, "sortable": false, "xtype": "checkcolumn", "header": "Historie", "editable": true, "tooltip": "(cbss.RetrieveTIGroupsRequests.history) Whatever this means.", "filter": { "type": "boolean" }, "width": Lino.chars2width(11), "dataIndex": "history" }, { "colIndex": 6, "sortable": true, "header": "Zustand", "editable": false, "tooltip": "(cbss.RetrieveTIGroupsRequests.status) ", "filter": { "type": "string" }, "width": Lino.chars2width(13), "dataIndex": "status" }, { "colIndex": 7, "sortable": true, "header": "Ticket", "editable": false, "tooltip": "(cbss.RetrieveTIGroupsRequests.ticket) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "ticket" }, { "width": Lino.chars2width(17), "colIndex": 8, "sortable": true, "dataIndex": "sent", "header": "Versendet", "editable": false, "tooltip": "(cbss.RetrieveTIGroupsRequests.sent) The date and time when this request has been executed. \nThis is empty for requests than haven't been sent.\nRead-only." }, { "colIndex": 9, "sortable": true, "header": "T/A/B", "editable": false, "tooltip": "(cbss.RetrieveTIGroupsRequests.environment) ", "filter": { "type": "string" }, "width": Lino.chars2width(6), "dataIndex": "environment" } ];
    Lino.cbss.RetrieveTIGroupsRequests.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.cbss.RetrieveTIGroupsRequests.put = function(rp,pk) { 
  Lino.run_row_action(rp,"/cbss/RetrieveTIGroupsRequests","GET",pk,"put",null);
};
Lino.cbss.RetrieveTIGroupsRequests.post = function(rp,pk) { 
  Lino.run_row_action(rp,"/cbss/RetrieveTIGroupsRequests","GET",pk,"post",null);
};

Lino.cbss.RetrieveTIGroupsRequests.insertPanel = Ext.extend(Lino.cbss.RetrieveTIGroupsRequests.InsertFormPanel,{
  empty_title: "Neu Tx25-Anfragen",
  hide_navigator: true,
  ls_bbar_actions: [ { "itemId": "post", "menu_item_text": "Erstellen", "tooltip": "Datensatz erstellen und dann im Detail-Fenster \u00f6ffnen", "panel_btn_handler": function(panel){panel.save(null,true,'post')}, "text": "Erstellen", "overflowText": "Erstellen", "auto_save": false }, { "itemId": "poststay", "menu_item_text": "Erstellen ohne Detail", "tooltip": "Nach Erstellen des Datensatzes kein Detail-Fenster \u00f6ffnen", "panel_btn_handler": function(panel){panel.save(null,false,'poststay')}, "text": "Erstellen ohne Detail", "overflowText": "Erstellen ohne Detail", "auto_save": false } ],
  ls_url: "/cbss/RetrieveTIGroupsRequests",
  action_name: "insert",
  initComponent : function() {
    this.ls_detail_handler = Lino.cbss.RetrieveTIGroupsRequests.detail;
    this.ls_insert_handler = Lino.cbss.RetrieveTIGroupsRequests.insert;
    Lino.cbss.RetrieveTIGroupsRequests.insertPanel.superclass.initComponent.call(this);
  }
});

Lino.cbss.RetrieveTIGroupsRequests.insert = new Lino.WindowAction({ "draggable": true, "width": Lino.chars2width(40), "autoHeight": true, "maximizable": true, "modal": true, "maximized": false },function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.cbss.RetrieveTIGroupsRequests.insertPanel(p);
});
Lino.cbss.RetrieveTIGroupsRequests.poststay = function(rp,pk) { 
  Lino.run_row_action(rp,"/cbss/RetrieveTIGroupsRequests","GET",pk,"poststay",null);
};
Lino.cbss.RetrieveTIGroupsRequests.duplicate = function(rp,pk) { 
  Lino.run_row_action(rp,"/cbss/RetrieveTIGroupsRequests","GET",pk,"duplicate",null);
};

Lino.cbss.RetrieveTIGroupsRequests.detailPanel = Ext.extend(Lino.cbss.RetrieveTIGroupsRequests.DetailFormPanel,{
  empty_title: "Detail Tx25-Anfragen",
  ls_bbar_actions: [ { "itemId": "put", "menu_item_text": "Speichern", "tooltip": "\u00c4nderungen in diesem Formular speichern", "panel_btn_handler": function(panel){panel.save(null,false,'put')}, "iconCls": "x-tbar-save", "overflowText": "Speichern", "auto_save": false }, { "itemId": "insert", "menu_item_text": "Neu", "must_save": true, "tooltip": "Neuen Datensatz erstellen", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-new", "overflowText": "Neu", "auto_save": true }, { "itemId": "duplicate", "menu_item_text": "Duplizieren", "must_save": true, "tooltip": "Duplizieren", "panel_btn_handler": Lino.row_action_handler('duplicate','GET',null), "iconCls": "x-tbar-duplicate", "overflowText": "Duplizieren", "auto_save": true }, { "itemId": null, "menu_item_text": "L\u00f6schen", "tooltip": "Diesen Datensatz l\u00f6schen", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "L\u00f6schen", "auto_save": false }, { "itemId": "do_print", "menu_item_text": "Drucken", "must_save": true, "tooltip": "Drucken", "panel_btn_handler": Lino.row_action_handler('do_print','GET',null), "iconCls": "x-tbar-print", "overflowText": "Drucken", "auto_save": true } ],
  ls_url: "/cbss/RetrieveTIGroupsRequests",
  action_name: "detail",
  initComponent : function() {
    this.ls_detail_handler = Lino.cbss.RetrieveTIGroupsRequests.detail;
    this.ls_insert_handler = Lino.cbss.RetrieveTIGroupsRequests.insert;
    Lino.cbss.RetrieveTIGroupsRequests.detailPanel.superclass.initComponent.call(this);
  }
});

Lino.cbss.RetrieveTIGroupsRequests.detail = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.cbss.RetrieveTIGroupsRequests.detailPanel(p);
});
Lino.cbss.RetrieveTIGroupsRequests.do_print = function(rp,pk) { 
  Lino.run_row_action(rp,"/cbss/RetrieveTIGroupsRequests","GET",pk,"do_print",null);
};
Lino.cbss.RetrieveTIGroupsRequests.edit_template = function(rp,pk) { 
  Lino.run_row_action(rp,"/cbss/RetrieveTIGroupsRequests","GET",pk,"edit_template",null);
};
Lino.cbss.RetrieveTIGroupsRequests.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.cbss.RetrieveTIGroupsRequests.GridPanel(p);
});

// js_render_GridPanel_class sessions.SessionTable
Lino.sessions.SessionTable.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "Keine Daten anzuzeigen." },
  ls_url : "/sessions/SessionTable",
  ls_bbar_actions : [ { "itemId": null, "menu_item_text": "L\u00f6schen", "tooltip": "Diesen Datensatz l\u00f6schen", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "L\u00f6schen", "auto_save": false } ],
  title : "Sitzungen",
  page_length : 20,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "name": "session_key" }, { "name": "session_data" }, { "name": "expire_date" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 0,
  ls_grid_configs : [  ],
  content_type : 1,
  ls_id_property : "session_key",
  gc_name : 0,
  disabled_actions_index : 4,
  initComponent : function() {
    var ww = this.containing_window;
    var session_key5223 = new Ext.form.TextField({ "selectOnFocus": true, "allowBlank": false, "maxLength": 40 });
    var session_data5224 = new Ext.form.TextArea({ "selectOnFocus": true, "allowBlank": false, "growMax": 2000 });
    var expire_date5225 = new Ext.form.DisplayField({ "selectOnFocus": true, "allowBlank": false, "value": "<br>" });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ { "colIndex": 0, "sortable": true, "header": "Sitzungs-ID", "editable": true, "tooltip": "(sessions.SessionTable.session_key) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "session_key", "editor": session_key5223 }, { "colIndex": 1, "sortable": false, "header": "Sitzungsdaten", "editable": true, "tooltip": "(sessions.SessionTable.session_data) ", "filter": { "type": "string" }, "width": Lino.chars2width(61), "renderer": Lino.text_renderer, "editor": session_data5224, "dataIndex": "session_data" }, { "colIndex": 2, "sortable": true, "header": "Verfallsdatum", "editable": true, "tooltip": "(sessions.SessionTable.expire_date) ", "width": Lino.chars2width(17), "dataIndex": "expire_date", "editor": expire_date5225 } ];
    Lino.sessions.SessionTable.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.sessions.SessionTable.put = function(rp,pk) { 
  Lino.run_row_action(rp,"/sessions/SessionTable","GET",pk,"put",null);
};
Lino.sessions.SessionTable.post = function(rp,pk) { 
  Lino.run_row_action(rp,"/sessions/SessionTable","GET",pk,"post",null);
};
Lino.sessions.SessionTable.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.sessions.SessionTable.GridPanel(p);
});

// js_render_GridPanel_class users.AuthoritiesGiven
Lino.users.AuthoritiesGiven.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "forceFit": true, "emptyText": "Keine Daten anzuzeigen." },
  ls_url : "/users/AuthoritiesGiven",
  ls_bbar_actions : [ { "itemId": null, "menu_item_text": "L\u00f6schen", "tooltip": "Diesen Datensatz l\u00f6schen", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "L\u00f6schen", "auto_save": false } ],
  title : "Erteilte Vollmachten",
  page_length : 20,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "name": "authorized" }, 'authorizedHidden', { "type": "int", "name": "id" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 2,
  ls_grid_configs : [  ],
  content_type : 8,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 4,
  initComponent : function() {
    var ww = this.containing_window;
    var authorized269 = new Lino.RemoteComboFieldElement({ "preferred_width": 15, "allowBlank": false, "pageSize": 20, "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/users/AuthoritiesGiven/authorized", "method": "GET" }) }), "emptyText": "Benutzer ausw\u00e4hlen..." });
    this.before_row_edit = function(record) {
      var bp = this.get_base_params();
      authorized269.setContextValue('mk',bp['mk']);
      authorized269.setContextValue('mt',bp['mt']);
    };
    this.ls_columns = [ { "colIndex": 0, "sortable": true, "header": "Benutzer", "editable": true, "tooltip": "(users.AuthoritiesGiven.authorized) The user who gets authority to act in your name.", "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "authorized", "editor": authorized269 } ];
    Lino.users.AuthoritiesGiven.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.users.AuthoritiesGiven.put = function(rp,pk) { 
  Lino.run_row_action(rp,"/users/AuthoritiesGiven","GET",pk,"put",null);
};
Lino.users.AuthoritiesGiven.post = function(rp,pk) { 
  Lino.run_row_action(rp,"/users/AuthoritiesGiven","GET",pk,"post",null);
};
Lino.users.AuthoritiesGiven.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.users.AuthoritiesGiven.GridPanel(p);
});

// js_render_GridPanel_class users.AuthoritiesTaken
Lino.users.AuthoritiesTaken.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "forceFit": true, "emptyText": "Keine Daten anzuzeigen." },
  ls_url : "/users/AuthoritiesTaken",
  ls_bbar_actions : [ { "itemId": null, "menu_item_text": "L\u00f6schen", "tooltip": "Diesen Datensatz l\u00f6schen", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "L\u00f6schen", "auto_save": false } ],
  title : "Erhaltene Vollmachten",
  page_length : 20,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "name": "user" }, 'userHidden', { "type": "int", "name": "id" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 2,
  ls_grid_configs : [  ],
  content_type : 8,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 4,
  initComponent : function() {
    var ww = this.containing_window;
    var user5233 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "preferred_width": 15, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/users/AuthoritiesTaken/user", "method": "GET" }) }), "pageSize": 20, "emptyText": "Benutzer ausw\u00e4hlen..." });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ { "colIndex": 0, "sortable": true, "header": "Autor", "editable": true, "tooltip": "(users.AuthoritiesTaken.user) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "user", "editor": user5233 } ];
    Lino.users.AuthoritiesTaken.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.users.AuthoritiesTaken.put = function(rp,pk) { 
  Lino.run_row_action(rp,"/users/AuthoritiesTaken","GET",pk,"put",null);
};
Lino.users.AuthoritiesTaken.post = function(rp,pk) { 
  Lino.run_row_action(rp,"/users/AuthoritiesTaken","GET",pk,"post",null);
};
Lino.users.AuthoritiesTaken.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.users.AuthoritiesTaken.GridPanel(p);
});

// js_render_GridPanel_class properties.ChoicesByType
Lino.properties.ChoicesByType.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "Keine Daten anzuzeigen." },
  ls_url : "/properties/ChoicesByType",
  ls_bbar_actions : [ { "itemId": null, "menu_item_text": "L\u00f6schen", "tooltip": "Diesen Datensatz l\u00f6schen", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "L\u00f6schen", "auto_save": false } ],
  title : "Auswahlm\u00f6glichkeiten",
  page_length : 20,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "name": "value" }, { "name": "text" }, { "name": "text_fr" }, { "name": "text_de" }, { "name": "text_nl" }, { "type": "int", "name": "id" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 5,
  ls_grid_configs : [  ],
  content_type : 16,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 7,
  initComponent : function() {
    var ww = this.containing_window;
    var value808 = new Ext.form.TextField({ "selectOnFocus": true, "allowBlank": false, "maxLength": 200 });
    var text809 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var text_fr810 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var text_de811 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var text_nl812 = new Ext.form.TextField({ "selectOnFocus": true, "hidden": true, "maxLength": 200 });
    var id813 = new Ext.form.NumberField({ "selectOnFocus": true });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ { "colIndex": 0, "sortable": true, "header": "Wert", "editable": true, "tooltip": "(properties.ChoicesByType.value) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "value", "editor": value808 }, { "colIndex": 1, "sortable": true, "header": "Bezeichnung", "editable": true, "tooltip": "(properties.ChoicesByType.text) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "text", "editor": text809 }, { "colIndex": 2, "sortable": true, "header": "Bezeichnung (fr)", "editable": true, "tooltip": "(properties.ChoicesByType.text_fr) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "text_fr", "editor": text_fr810 }, { "colIndex": 3, "sortable": true, "header": "Bezeichnung (de)", "editable": true, "tooltip": "(properties.ChoicesByType.text_de) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "text_de", "editor": text_de811 }, { "colIndex": 4, "sortable": true, "header": "Bezeichnung (nl)", "editable": true, "tooltip": "(properties.ChoicesByType.text_nl) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "text_nl", "hidden": true, "editor": text_nl812 }, new Lino.NullNumberColumn({ "colIndex": 5, "sortable": true, "format": "0", "editable": true, "tooltip": "(properties.ChoicesByType.id) ", "filter": { "type": "numeric" }, "header": "ID", "renderer": Lino.id_renderer, "editor": id813, "width": Lino.chars2width(6), "dataIndex": "id" }) ];
    Lino.properties.ChoicesByType.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.properties.ChoicesByType.put = function(rp,pk) { 
  Lino.run_row_action(rp,"/properties/ChoicesByType","GET",pk,"put",null);
};
Lino.properties.ChoicesByType.post = function(rp,pk) { 
  Lino.run_row_action(rp,"/properties/ChoicesByType","GET",pk,"post",null);
};
Lino.properties.ChoicesByType.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.properties.ChoicesByType.GridPanel(p);
});

// js_render_GridPanel_class contacts.RolesByCompany
Lino.contacts.RolesByCompany.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "forceFit": true, "emptyText": "Keine Daten anzuzeigen." },
  ls_url : "/contacts/RolesByCompany",
  ls_bbar_actions : [ { "itemId": null, "menu_item_text": "L\u00f6schen", "tooltip": "Diesen Datensatz l\u00f6schen", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "L\u00f6schen", "auto_save": false } ],
  title : "Kontaktpersonen",
  page_length : 20,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "name": "person" }, 'personHidden', { "name": "type" }, 'typeHidden', { "type": "int", "name": "id" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 4,
  ls_grid_configs : [  ],
  content_type : 21,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 6,
  initComponent : function() {
    var ww = this.containing_window;
    var person891 = new Lino.RemoteComboFieldElement({ "preferred_width": 20, "allowBlank": false, "pageSize": 20, "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/contacts/RolesByCompany/person", "method": "GET" }) }), "emptyText": "Person ausw\u00e4hlen..." });
    var type892 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/contacts/RolesByCompany/type", "method": "GET" }) }), "pageSize": 20, "emptyText": "Funktion ausw\u00e4hlen..." });
    var id893 = new Ext.form.NumberField({ "selectOnFocus": true });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ { "colIndex": 0, "sortable": true, "header": "Person", "editable": true, "tooltip": "(contacts.RolesByCompany.person) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "person", "editor": person891 }, { "colIndex": 1, "sortable": true, "header": "Funktion", "editable": true, "tooltip": "(contacts.RolesByCompany.type) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "type", "editor": type892 }, new Lino.NullNumberColumn({ "colIndex": 2, "sortable": true, "format": "0", "editable": true, "tooltip": "(contacts.RolesByCompany.id) ", "filter": { "type": "numeric" }, "header": "ID", "renderer": Lino.id_renderer, "hidden": true, "editor": id893, "width": Lino.chars2width(6), "dataIndex": "id" }) ];
    Lino.contacts.RolesByCompany.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.contacts.RolesByCompany.put = function(rp,pk) { 
  Lino.run_row_action(rp,"/contacts/RolesByCompany","GET",pk,"put",null);
};
Lino.contacts.RolesByCompany.post = function(rp,pk) { 
  Lino.run_row_action(rp,"/contacts/RolesByCompany","GET",pk,"post",null);
};
Lino.contacts.RolesByCompany.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.contacts.RolesByCompany.GridPanel(p);
});

// js_render_GridPanel_class contacts.RolesByPerson
Lino.contacts.RolesByPerson.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "forceFit": true, "emptyText": "Keine Daten anzuzeigen." },
  ls_url : "/contacts/RolesByPerson",
  ls_bbar_actions : [ { "itemId": null, "menu_item_text": "L\u00f6schen", "tooltip": "Diesen Datensatz l\u00f6schen", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "L\u00f6schen", "auto_save": false } ],
  title : "Kontaktperson f\u00fcr",
  page_length : 20,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "name": "company" }, 'companyHidden', { "name": "type" }, 'typeHidden', { "type": "int", "name": "id" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 4,
  ls_grid_configs : [  ],
  content_type : 21,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 6,
  initComponent : function() {
    var ww = this.containing_window;
    var company1093 = new Lino.RemoteComboFieldElement({ "preferred_width": 20, "allowBlank": false, "pageSize": 20, "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/contacts/RolesByPerson/company", "method": "GET" }) }), "emptyText": "Organisation ausw\u00e4hlen..." });
    var type1094 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/contacts/RolesByPerson/type", "method": "GET" }) }), "pageSize": 20, "emptyText": "Funktion ausw\u00e4hlen..." });
    var id1095 = new Ext.form.NumberField({ "selectOnFocus": true });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ { "colIndex": 0, "sortable": true, "header": "Organisation", "editable": true, "tooltip": "(contacts.RolesByPerson.company) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "company", "editor": company1093 }, { "colIndex": 1, "sortable": true, "header": "Funktion", "editable": true, "tooltip": "(contacts.RolesByPerson.type) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "type", "editor": type1094 }, new Lino.NullNumberColumn({ "colIndex": 2, "sortable": true, "format": "0", "editable": true, "tooltip": "(contacts.RolesByPerson.id) ", "filter": { "type": "numeric" }, "header": "ID", "renderer": Lino.id_renderer, "hidden": true, "editor": id1095, "width": Lino.chars2width(6), "dataIndex": "id" }) ];
    Lino.contacts.RolesByPerson.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.contacts.RolesByPerson.put = function(rp,pk) { 
  Lino.run_row_action(rp,"/contacts/RolesByPerson","GET",pk,"put",null);
};
Lino.contacts.RolesByPerson.post = function(rp,pk) { 
  Lino.run_row_action(rp,"/contacts/RolesByPerson","GET",pk,"post",null);
};
Lino.contacts.RolesByPerson.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.contacts.RolesByPerson.GridPanel(p);
});

// js_render_GridPanel_class outbox.RecipientsByMail
Lino.outbox.RecipientsByMail.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "Keine Daten anzuzeigen." },
  ls_url : "/outbox/RecipientsByMail",
  ls_bbar_actions : [ { "itemId": null, "menu_item_text": "L\u00f6schen", "tooltip": "Diesen Datensatz l\u00f6schen", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "L\u00f6schen", "auto_save": false } ],
  title : "Empf\u00e4nger",
  page_length : 20,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "name": "partner" }, 'partnerHidden', { "name": "address" }, { "name": "name" }, { "name": "type" }, 'typeHidden', { "type": "int", "name": "id" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 6,
  ls_grid_configs : [  ],
  content_type : 27,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 8,
  initComponent : function() {
    var ww = this.containing_window;
    var partner970 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "preferred_width": 20, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/outbox/RecipientsByMail/partner", "method": "GET" }) }), "pageSize": 20, "emptyText": "Partner ausw\u00e4hlen..." });
    var address971 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 75 });
    var name972 = new Ext.form.TextField({ "selectOnFocus": true, "allowBlank": false, "maxLength": 200 });
    var type973 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "forceSelection": true, "allowBlank": false, "store": Lino.outbox.RecipientType });
    var id974 = new Ext.form.NumberField({ "selectOnFocus": true });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ { "colIndex": 0, "sortable": true, "header": "Partner", "editable": true, "tooltip": "(outbox.RecipientsByMail.partner) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "partner", "editor": partner970 }, { "colIndex": 1, "sortable": true, "header": "Adresse", "editable": true, "tooltip": "(outbox.RecipientsByMail.address) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "address", "editor": address971 }, { "colIndex": 2, "sortable": true, "header": "Name", "editable": true, "tooltip": "(outbox.RecipientsByMail.name) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "name", "editor": name972 }, { "colIndex": 3, "sortable": true, "header": "Empf\u00e4ngerart", "editable": true, "tooltip": "(outbox.RecipientsByMail.type) ", "filter": { "type": "string" }, "width": Lino.chars2width(11), "dataIndex": "type", "editor": type973 }, new Lino.NullNumberColumn({ "colIndex": 4, "sortable": true, "format": "0", "editable": true, "tooltip": "(outbox.RecipientsByMail.id) ", "filter": { "type": "numeric" }, "header": "ID", "renderer": Lino.id_renderer, "editor": id974, "width": Lino.chars2width(6), "dataIndex": "id" }) ];
    Lino.outbox.RecipientsByMail.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.outbox.RecipientsByMail.put = function(rp,pk) { 
  Lino.run_row_action(rp,"/outbox/RecipientsByMail","GET",pk,"put",null);
};
Lino.outbox.RecipientsByMail.post = function(rp,pk) { 
  Lino.run_row_action(rp,"/outbox/RecipientsByMail","GET",pk,"post",null);
};
Lino.outbox.RecipientsByMail.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.outbox.RecipientsByMail.GridPanel(p);
});

// js_render_GridPanel_class outbox.MailsByUser
Lino.outbox.MailsByUser.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "Keine Daten anzuzeigen." },
  ls_url : "/outbox/MailsByUser",
  ls_bbar_actions : [ { "itemId": "insert", "menu_item_text": "Neu", "must_save": true, "tooltip": "Neuen Datensatz erstellen", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-new", "overflowText": "Neu", "auto_save": true }, { "itemId": "detail", "menu_item_text": "Detail", "tooltip": "Detail-Fenster auf diesem Datensatz \u00f6ffnen", "panel_btn_handler": Lino.show_detail, "iconCls": "x-tbar-detail", "overflowText": "Detail", "auto_save": true }, { "itemId": null, "menu_item_text": "L\u00f6schen", "tooltip": "Diesen Datensatz l\u00f6schen", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "L\u00f6schen", "auto_save": false }, { "itemId": "do_print", "menu_item_text": "Drucken", "must_save": true, "tooltip": "Drucken", "panel_btn_handler": Lino.row_action_handler('do_print','GET',null), "iconCls": "x-tbar-print", "overflowText": "Drucken", "auto_save": true }, { "itemId": "send_mail", "menu_item_text": "E-Mail senden", "must_save": true, "tooltip": "E-Mail senden", "panel_btn_handler": Lino.row_action_handler('send_mail','GET',null), "iconCls": "x-tbar-email_send", "overflowText": "E-Mail senden", "auto_save": true } ],
  title : "E-Mail-Ausgang",
  page_length : 20,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "name": "sent" }, { "name": "subject" }, { "name": "recipients" }, { "type": "int", "name": "id" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 3,
  ls_grid_configs : [  ],
  content_type : 26,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 5,
  initComponent : function() {
    this.ls_detail_handler = Lino.outbox.MailsByUser.detail;
    this.ls_insert_handler = Lino.outbox.MailsByUser.insert;
    var ww = this.containing_window;
    var sent5271 = new Ext.form.DisplayField({ "disabled": true, "value": "<br>" });
    var subject5272 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var recipients_htmlbox5273 = new Lino.HtmlBoxPanel({ "layout": "fit", "name": "recipients", "containing_panel": this, "items": new Ext.BoxComponent({autoScroll:true}), "title": "Empf\u00e4nger", "master_panel": this, "value": "<br/>", "always_enabled": true, "bodyStyle": "overflow-x:hidden;" });
    this.before_row_edit = function(record) {
      recipients_htmlbox5273.refresh();
    };
    this.ls_columns = [ { "width": Lino.chars2width(17), "colIndex": 0, "sortable": true, "dataIndex": "sent", "header": "sent", "editable": false, "tooltip": "(outbox.MailsByUser.sent) " }, { "colIndex": 1, "sortable": true, "header": "Betreff", "editable": true, "tooltip": "(outbox.MailsByUser.subject) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "subject", "editor": subject5272 }, { "width": Lino.chars2width(31), "colIndex": 2, "sortable": false, "dataIndex": "recipients", "header": "Empf\u00e4nger", "editable": false, "tooltip": "(outbox.MailsByUser.recipients) " } ];
    Lino.outbox.MailsByUser.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.outbox.MailsByUser.put = function(rp,pk) { 
  Lino.run_row_action(rp,"/outbox/MailsByUser","GET",pk,"put",null);
};
Lino.outbox.MailsByUser.post = function(rp,pk) { 
  Lino.run_row_action(rp,"/outbox/MailsByUser","GET",pk,"post",null);
};

Lino.outbox.MailsByUser.insertPanel = Ext.extend(Lino.outbox.MailsByUser.InsertFormPanel,{
  empty_title: "Neu E-Mail-Ausgang",
  hide_navigator: true,
  ls_bbar_actions: [ { "itemId": "post", "menu_item_text": "Erstellen", "tooltip": "Datensatz erstellen und dann im Detail-Fenster \u00f6ffnen", "panel_btn_handler": function(panel){panel.save(null,true,'post')}, "text": "Erstellen", "overflowText": "Erstellen", "auto_save": false }, { "itemId": "poststay", "menu_item_text": "Erstellen ohne Detail", "tooltip": "Nach Erstellen des Datensatzes kein Detail-Fenster \u00f6ffnen", "panel_btn_handler": function(panel){panel.save(null,false,'poststay')}, "text": "Erstellen ohne Detail", "overflowText": "Erstellen ohne Detail", "auto_save": false } ],
  ls_url: "/outbox/MailsByUser",
  action_name: "insert",
  initComponent : function() {
    this.ls_detail_handler = Lino.outbox.MailsByUser.detail;
    this.ls_insert_handler = Lino.outbox.MailsByUser.insert;
    Lino.outbox.MailsByUser.insertPanel.superclass.initComponent.call(this);
  }
});

Lino.outbox.MailsByUser.insert = new Lino.WindowAction({ "draggable": true, "width": Lino.chars2width(60), "maximizable": true, "modal": true, "maximized": false, "height": Lino.rows2height(20) },function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.outbox.MailsByUser.insertPanel(p);
});
Lino.outbox.MailsByUser.poststay = function(rp,pk) { 
  Lino.run_row_action(rp,"/outbox/MailsByUser","GET",pk,"poststay",null);
};

Lino.outbox.MailsByUser.detailPanel = Ext.extend(Lino.outbox.MailsByUser.DetailFormPanel,{
  empty_title: "Detail E-Mail-Ausgang",
  ls_bbar_actions: [ { "itemId": "put", "menu_item_text": "Speichern", "tooltip": "\u00c4nderungen in diesem Formular speichern", "panel_btn_handler": function(panel){panel.save(null,false,'put')}, "iconCls": "x-tbar-save", "overflowText": "Speichern", "auto_save": false }, { "itemId": "insert", "menu_item_text": "Neu", "must_save": true, "tooltip": "Neuen Datensatz erstellen", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-new", "overflowText": "Neu", "auto_save": true }, { "itemId": null, "menu_item_text": "L\u00f6schen", "tooltip": "Diesen Datensatz l\u00f6schen", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "L\u00f6schen", "auto_save": false }, { "itemId": "do_print", "menu_item_text": "Drucken", "must_save": true, "tooltip": "Drucken", "panel_btn_handler": Lino.row_action_handler('do_print','GET',null), "iconCls": "x-tbar-print", "overflowText": "Drucken", "auto_save": true }, { "itemId": "send_mail", "menu_item_text": "E-Mail senden", "must_save": true, "tooltip": "E-Mail senden", "panel_btn_handler": Lino.row_action_handler('send_mail','GET',null), "iconCls": "x-tbar-email_send", "overflowText": "E-Mail senden", "auto_save": true } ],
  ls_url: "/outbox/MailsByUser",
  action_name: "detail",
  initComponent : function() {
    this.ls_detail_handler = Lino.outbox.MailsByUser.detail;
    this.ls_insert_handler = Lino.outbox.MailsByUser.insert;
    Lino.outbox.MailsByUser.detailPanel.superclass.initComponent.call(this);
  }
});

Lino.outbox.MailsByUser.detail = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.outbox.MailsByUser.detailPanel(p);
});
Lino.outbox.MailsByUser.do_print = function(rp,pk) { 
  Lino.run_row_action(rp,"/outbox/MailsByUser","GET",pk,"do_print",null);
};
Lino.outbox.MailsByUser.edit_template = function(rp,pk) { 
  Lino.run_row_action(rp,"/outbox/MailsByUser","GET",pk,"edit_template",null);
};
Lino.outbox.MailsByUser.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.outbox.MailsByUser.GridPanel(p);
});
Lino.outbox.MailsByUser.send_mail = function(rp,pk) { 
  Lino.run_row_action(rp,"/outbox/MailsByUser","GET",pk,"send_mail",null);
};

// js_render_GridPanel_class outbox.MailsByProject
Lino.outbox.MailsByProject.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "Keine Daten anzuzeigen." },
  ls_url : "/outbox/MailsByProject",
  ls_bbar_actions : [ { "itemId": "insert", "menu_item_text": "Neu", "must_save": true, "tooltip": "Neuen Datensatz erstellen", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-new", "overflowText": "Neu", "auto_save": true }, { "itemId": "detail", "menu_item_text": "Detail", "tooltip": "Detail-Fenster auf diesem Datensatz \u00f6ffnen", "panel_btn_handler": Lino.show_detail, "iconCls": "x-tbar-detail", "overflowText": "Detail", "auto_save": true }, { "itemId": null, "menu_item_text": "L\u00f6schen", "tooltip": "Diesen Datensatz l\u00f6schen", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "L\u00f6schen", "auto_save": false }, { "itemId": "do_print", "menu_item_text": "Drucken", "must_save": true, "tooltip": "Drucken", "panel_btn_handler": Lino.row_action_handler('do_print','GET',null), "iconCls": "x-tbar-print", "overflowText": "Drucken", "auto_save": true }, { "itemId": "send_mail", "menu_item_text": "E-Mail senden", "must_save": true, "tooltip": "E-Mail senden", "panel_btn_handler": Lino.row_action_handler('send_mail','GET',null), "iconCls": "x-tbar-email_send", "overflowText": "E-Mail senden", "auto_save": true } ],
  title : "E-Mail-Ausgang",
  page_length : 20,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "type": "date", "name": "date", "dateFormat": "d.m.Y" }, { "name": "subject" }, { "name": "recipients" }, { "name": "user" }, 'userHidden', { "type": "int", "name": "id" }, { "name": "owner_type" }, 'owner_typeHidden', { "name": "owner_id" }, 'owner_idHidden', { "name": "body" }, { "name": "sent" }, { "name": "owner" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 5,
  ls_grid_configs : [  ],
  content_type : 26,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 14,
  initComponent : function() {
    this.ls_detail_handler = Lino.outbox.MailsByProject.detail;
    this.ls_insert_handler = Lino.outbox.MailsByProject.insert;
    var ww = this.containing_window;
    var date2902 = new Lino.DateField({ "selectOnFocus": true, "allowBlank": false });
    var subject2903 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var recipients_htmlbox2904 = new Lino.HtmlBoxPanel({ "layout": "fit", "name": "recipients", "containing_panel": this, "items": new Ext.BoxComponent({autoScroll:true}), "title": "Empf\u00e4nger", "master_panel": this, "value": "<br/>", "always_enabled": true, "bodyStyle": "overflow-x:hidden;" });
    var user2905 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "preferred_width": 15, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/outbox/MailsByProject/user", "method": "GET" }) }), "pageSize": 20, "emptyText": "Benutzer ausw\u00e4hlen..." });
    var id2906 = new Ext.form.NumberField({ "selectOnFocus": true });
    var owner_type2907 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/outbox/MailsByProject/owner_type", "method": "GET" }) }), "pageSize": 20, "emptyText": "Inhaltstyp ausw\u00e4hlen..." });
    var owner_id2908 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/outbox/MailsByProject/owner_id", "method": "GET" }) }) });
    var body2909 = new Lino.RichTextPanel({ "selectOnFocus": true, "containing_panel": this, "title": "Inhalt" });
    var sent2910 = new Ext.form.DisplayField({ "disabled": true, "value": "<br>" });
    var owner_disp2911 = new Ext.form.DisplayField({ "disabled": true });
    this.before_row_edit = function(record) {
      recipients_htmlbox2904.refresh();
      owner_id2908.setContextValue('owner_type',record ? record.data['owner_typeHidden'] : undefined);
      body2909.refresh();
    };
    this.onRender = function(ct, position) {
      owner_type2907.on('change',Lino.chooser_handler(owner_id2908,'owner_type'));
      Lino.outbox.MailsByProject.GridPanel.superclass.onRender.call(this, ct, position);
    }
    this.ls_columns = [ { "colIndex": 0, "sortable": true, "xtype": "datecolumn", "format": "d.m.Y", "editable": true, "tooltip": "(outbox.MailsByProject.date) \n        The official date to be printed on the document.\n        ", "filter": { "type": "date", "dateFormat": "d.m.Y" }, "header": "Datum", "dataIndex": "date", "width": Lino.chars2width(9), "editor": date2902 }, { "colIndex": 1, "sortable": true, "header": "Betreff", "editable": true, "tooltip": "(outbox.MailsByProject.subject) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "subject", "editor": subject2903 }, { "width": Lino.chars2width(31), "colIndex": 2, "sortable": false, "dataIndex": "recipients", "header": "Empf\u00e4nger", "editable": false, "tooltip": "(outbox.MailsByProject.recipients) " }, { "colIndex": 3, "sortable": true, "header": "Absender", "editable": true, "tooltip": "(outbox.MailsByProject.user) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "user", "editor": user2905 }, new Lino.NullNumberColumn({ "colIndex": 4, "sortable": true, "format": "0", "editable": true, "tooltip": "(outbox.MailsByProject.id) ", "filter": { "type": "numeric" }, "header": "ID", "renderer": Lino.id_renderer, "editor": id2906, "width": Lino.chars2width(6), "dataIndex": "id" }), { "colIndex": 5, "sortable": true, "header": "Verkn\u00fcpft mit (Modell)", "editable": true, "tooltip": "(outbox.MailsByProject.owner_type) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "owner_type", "editor": owner_type2907 }, { "colIndex": 6, "sortable": true, "header": "Verkn\u00fcpft mit (Objekt)", "editable": true, "tooltip": "(outbox.MailsByProject.owner_id) ", "filter": { "type": "string" }, "width": Lino.chars2width(11), "dataIndex": "owner_id", "editor": owner_id2908 }, { "colIndex": 7, "sortable": false, "width": Lino.chars2width(61), "editable": true, "tooltip": "(outbox.MailsByProject.body) ", "filter": { "type": "string" }, "header": "body", "renderer": Lino.text_renderer, "hidden": true, "editor": body2909, "dataIndex": "body" }, { "width": Lino.chars2width(17), "colIndex": 8, "sortable": true, "dataIndex": "sent", "header": "sent", "editable": false, "tooltip": "(outbox.MailsByProject.sent) " }, { "width": Lino.chars2width(11), "colIndex": 9, "sortable": false, "dataIndex": "owner", "header": "Verkn\u00fcpft mit", "editable": false, "tooltip": "(outbox.MailsByProject.owner) " } ];
    Lino.outbox.MailsByProject.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.outbox.MailsByProject.put = function(rp,pk) { 
  Lino.run_row_action(rp,"/outbox/MailsByProject","GET",pk,"put",null);
};
Lino.outbox.MailsByProject.post = function(rp,pk) { 
  Lino.run_row_action(rp,"/outbox/MailsByProject","GET",pk,"post",null);
};

Lino.outbox.MailsByProject.insertPanel = Ext.extend(Lino.outbox.MailsByUser.InsertFormPanel,{
  empty_title: "Neu E-Mail-Ausgang",
  hide_navigator: true,
  ls_bbar_actions: [ { "itemId": "post", "menu_item_text": "Erstellen", "tooltip": "Datensatz erstellen und dann im Detail-Fenster \u00f6ffnen", "panel_btn_handler": function(panel){panel.save(null,true,'post')}, "text": "Erstellen", "overflowText": "Erstellen", "auto_save": false }, { "itemId": "poststay", "menu_item_text": "Erstellen ohne Detail", "tooltip": "Nach Erstellen des Datensatzes kein Detail-Fenster \u00f6ffnen", "panel_btn_handler": function(panel){panel.save(null,false,'poststay')}, "text": "Erstellen ohne Detail", "overflowText": "Erstellen ohne Detail", "auto_save": false } ],
  ls_url: "/outbox/MailsByProject",
  action_name: "insert",
  initComponent : function() {
    this.ls_detail_handler = Lino.outbox.MailsByProject.detail;
    this.ls_insert_handler = Lino.outbox.MailsByProject.insert;
    Lino.outbox.MailsByProject.insertPanel.superclass.initComponent.call(this);
  }
});

Lino.outbox.MailsByProject.insert = new Lino.WindowAction({ "draggable": true, "width": Lino.chars2width(60), "maximizable": true, "modal": true, "maximized": false, "height": Lino.rows2height(20) },function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.outbox.MailsByProject.insertPanel(p);
});
Lino.outbox.MailsByProject.poststay = function(rp,pk) { 
  Lino.run_row_action(rp,"/outbox/MailsByProject","GET",pk,"poststay",null);
};

Lino.outbox.MailsByProject.detailPanel = Ext.extend(Lino.outbox.MailsByUser.DetailFormPanel,{
  empty_title: "Detail E-Mail-Ausgang",
  ls_bbar_actions: [ { "itemId": "put", "menu_item_text": "Speichern", "tooltip": "\u00c4nderungen in diesem Formular speichern", "panel_btn_handler": function(panel){panel.save(null,false,'put')}, "iconCls": "x-tbar-save", "overflowText": "Speichern", "auto_save": false }, { "itemId": "insert", "menu_item_text": "Neu", "must_save": true, "tooltip": "Neuen Datensatz erstellen", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-new", "overflowText": "Neu", "auto_save": true }, { "itemId": null, "menu_item_text": "L\u00f6schen", "tooltip": "Diesen Datensatz l\u00f6schen", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "L\u00f6schen", "auto_save": false }, { "itemId": "do_print", "menu_item_text": "Drucken", "must_save": true, "tooltip": "Drucken", "panel_btn_handler": Lino.row_action_handler('do_print','GET',null), "iconCls": "x-tbar-print", "overflowText": "Drucken", "auto_save": true }, { "itemId": "send_mail", "menu_item_text": "E-Mail senden", "must_save": true, "tooltip": "E-Mail senden", "panel_btn_handler": Lino.row_action_handler('send_mail','GET',null), "iconCls": "x-tbar-email_send", "overflowText": "E-Mail senden", "auto_save": true } ],
  ls_url: "/outbox/MailsByProject",
  action_name: "detail",
  initComponent : function() {
    this.ls_detail_handler = Lino.outbox.MailsByProject.detail;
    this.ls_insert_handler = Lino.outbox.MailsByProject.insert;
    Lino.outbox.MailsByProject.detailPanel.superclass.initComponent.call(this);
  }
});

Lino.outbox.MailsByProject.detail = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.outbox.MailsByProject.detailPanel(p);
});
Lino.outbox.MailsByProject.do_print = function(rp,pk) { 
  Lino.run_row_action(rp,"/outbox/MailsByProject","GET",pk,"do_print",null);
};
Lino.outbox.MailsByProject.edit_template = function(rp,pk) { 
  Lino.run_row_action(rp,"/outbox/MailsByProject","GET",pk,"edit_template",null);
};
Lino.outbox.MailsByProject.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.outbox.MailsByProject.GridPanel(p);
});
Lino.outbox.MailsByProject.send_mail = function(rp,pk) { 
  Lino.run_row_action(rp,"/outbox/MailsByProject","GET",pk,"send_mail",null);
};

// js_render_GridPanel_class outbox.SentByPartner
Lino.outbox.SentByPartner.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "Keine Daten anzuzeigen." },
  ls_url : "/outbox/SentByPartner",
  ls_bbar_actions : [ { "itemId": "insert", "menu_item_text": "Neu", "must_save": true, "tooltip": "Neuen Datensatz erstellen", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-new", "overflowText": "Neu", "auto_save": true }, { "itemId": "detail", "menu_item_text": "Detail", "tooltip": "Detail-Fenster auf diesem Datensatz \u00f6ffnen", "panel_btn_handler": Lino.show_detail, "iconCls": "x-tbar-detail", "overflowText": "Detail", "auto_save": true }, { "itemId": null, "menu_item_text": "L\u00f6schen", "tooltip": "Diesen Datensatz l\u00f6schen", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "L\u00f6schen", "auto_save": false }, { "itemId": "do_print", "menu_item_text": "Drucken", "must_save": true, "tooltip": "Drucken", "panel_btn_handler": Lino.row_action_handler('do_print','GET',null), "iconCls": "x-tbar-print", "overflowText": "Drucken", "auto_save": true }, { "itemId": "send_mail", "menu_item_text": "E-Mail senden", "must_save": true, "tooltip": "E-Mail senden", "panel_btn_handler": Lino.row_action_handler('send_mail','GET',null), "iconCls": "x-tbar-email_send", "overflowText": "E-Mail senden", "auto_save": true } ],
  title : "E-Mail-Ausgang",
  page_length : 20,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "name": "sent" }, { "name": "subject" }, { "name": "user" }, 'userHidden', { "type": "int", "name": "id" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 4,
  ls_grid_configs : [  ],
  content_type : 26,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 6,
  initComponent : function() {
    this.ls_detail_handler = Lino.outbox.SentByPartner.detail;
    this.ls_insert_handler = Lino.outbox.SentByPartner.insert;
    var ww = this.containing_window;
    var sent5275 = new Ext.form.DisplayField({ "disabled": true, "value": "<br>" });
    var subject5276 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var user5277 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "preferred_width": 15, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/outbox/SentByPartner/user", "method": "GET" }) }), "pageSize": 20, "emptyText": "Benutzer ausw\u00e4hlen..." });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ { "width": Lino.chars2width(17), "colIndex": 0, "sortable": true, "dataIndex": "sent", "header": "sent", "editable": false, "tooltip": "(outbox.SentByPartner.sent) " }, { "colIndex": 1, "sortable": true, "header": "Betreff", "editable": true, "tooltip": "(outbox.SentByPartner.subject) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "subject", "editor": subject5276 }, { "colIndex": 2, "sortable": true, "header": "Absender", "editable": true, "tooltip": "(outbox.SentByPartner.user) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "user", "editor": user5277 } ];
    Lino.outbox.SentByPartner.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.outbox.SentByPartner.put = function(rp,pk) { 
  Lino.run_row_action(rp,"/outbox/SentByPartner","GET",pk,"put",null);
};
Lino.outbox.SentByPartner.post = function(rp,pk) { 
  Lino.run_row_action(rp,"/outbox/SentByPartner","GET",pk,"post",null);
};

Lino.outbox.SentByPartner.insertPanel = Ext.extend(Lino.outbox.MailsByUser.InsertFormPanel,{
  empty_title: "Neu E-Mail-Ausgang",
  hide_navigator: true,
  ls_bbar_actions: [ { "itemId": "post", "menu_item_text": "Erstellen", "tooltip": "Datensatz erstellen und dann im Detail-Fenster \u00f6ffnen", "panel_btn_handler": function(panel){panel.save(null,true,'post')}, "text": "Erstellen", "overflowText": "Erstellen", "auto_save": false }, { "itemId": "poststay", "menu_item_text": "Erstellen ohne Detail", "tooltip": "Nach Erstellen des Datensatzes kein Detail-Fenster \u00f6ffnen", "panel_btn_handler": function(panel){panel.save(null,false,'poststay')}, "text": "Erstellen ohne Detail", "overflowText": "Erstellen ohne Detail", "auto_save": false } ],
  ls_url: "/outbox/SentByPartner",
  action_name: "insert",
  initComponent : function() {
    this.ls_detail_handler = Lino.outbox.SentByPartner.detail;
    this.ls_insert_handler = Lino.outbox.SentByPartner.insert;
    Lino.outbox.SentByPartner.insertPanel.superclass.initComponent.call(this);
  }
});

Lino.outbox.SentByPartner.insert = new Lino.WindowAction({ "draggable": true, "width": Lino.chars2width(60), "maximizable": true, "modal": true, "maximized": false, "height": Lino.rows2height(20) },function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.outbox.SentByPartner.insertPanel(p);
});
Lino.outbox.SentByPartner.poststay = function(rp,pk) { 
  Lino.run_row_action(rp,"/outbox/SentByPartner","GET",pk,"poststay",null);
};

Lino.outbox.SentByPartner.detailPanel = Ext.extend(Lino.outbox.MailsByUser.DetailFormPanel,{
  empty_title: "Detail E-Mail-Ausgang",
  ls_bbar_actions: [ { "itemId": "put", "menu_item_text": "Speichern", "tooltip": "\u00c4nderungen in diesem Formular speichern", "panel_btn_handler": function(panel){panel.save(null,false,'put')}, "iconCls": "x-tbar-save", "overflowText": "Speichern", "auto_save": false }, { "itemId": "insert", "menu_item_text": "Neu", "must_save": true, "tooltip": "Neuen Datensatz erstellen", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-new", "overflowText": "Neu", "auto_save": true }, { "itemId": null, "menu_item_text": "L\u00f6schen", "tooltip": "Diesen Datensatz l\u00f6schen", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "L\u00f6schen", "auto_save": false }, { "itemId": "do_print", "menu_item_text": "Drucken", "must_save": true, "tooltip": "Drucken", "panel_btn_handler": Lino.row_action_handler('do_print','GET',null), "iconCls": "x-tbar-print", "overflowText": "Drucken", "auto_save": true }, { "itemId": "send_mail", "menu_item_text": "E-Mail senden", "must_save": true, "tooltip": "E-Mail senden", "panel_btn_handler": Lino.row_action_handler('send_mail','GET',null), "iconCls": "x-tbar-email_send", "overflowText": "E-Mail senden", "auto_save": true } ],
  ls_url: "/outbox/SentByPartner",
  action_name: "detail",
  initComponent : function() {
    this.ls_detail_handler = Lino.outbox.SentByPartner.detail;
    this.ls_insert_handler = Lino.outbox.SentByPartner.insert;
    Lino.outbox.SentByPartner.detailPanel.superclass.initComponent.call(this);
  }
});

Lino.outbox.SentByPartner.detail = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.outbox.SentByPartner.detailPanel(p);
});
Lino.outbox.SentByPartner.do_print = function(rp,pk) { 
  Lino.run_row_action(rp,"/outbox/SentByPartner","GET",pk,"do_print",null);
};
Lino.outbox.SentByPartner.edit_template = function(rp,pk) { 
  Lino.run_row_action(rp,"/outbox/SentByPartner","GET",pk,"edit_template",null);
};
Lino.outbox.SentByPartner.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.outbox.SentByPartner.GridPanel(p);
});
Lino.outbox.SentByPartner.send_mail = function(rp,pk) { 
  Lino.run_row_action(rp,"/outbox/SentByPartner","GET",pk,"send_mail",null);
};

// js_render_GridPanel_class uploads.MyUploads
Lino.uploads.MyUploads.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "Keine Daten anzuzeigen." },
  ls_url : "/uploads/MyUploads",
  ls_bbar_actions : [ { "itemId": "insert", "menu_item_text": "Neu", "must_save": true, "tooltip": "Neuen Datensatz erstellen", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-new", "overflowText": "Neu", "auto_save": true }, { "itemId": "detail", "menu_item_text": "Detail", "tooltip": "Detail-Fenster auf diesem Datensatz \u00f6ffnen", "panel_btn_handler": Lino.show_detail, "iconCls": "x-tbar-detail", "overflowText": "Detail", "auto_save": true }, { "itemId": null, "menu_item_text": "L\u00f6schen", "tooltip": "Diesen Datensatz l\u00f6schen", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "L\u00f6schen", "auto_save": false } ],
  title : "Meine Uploads",
  page_length : 20,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "name": "file" }, { "name": "description" }, { "name": "user" }, 'userHidden', { "name": "owner" }, { "type": "int", "name": "id" }, { "name": "owner_type" }, 'owner_typeHidden', { "name": "owner_id" }, 'owner_idHidden', { "name": "created" }, { "name": "modified" }, { "name": "mimetype" }, { "name": "type" }, 'typeHidden', { "type": "date", "name": "valid_until", "dateFormat": "d.m.Y" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 5,
  ls_grid_configs : [  ],
  content_type : 25,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 17,
  initComponent : function() {
    this.ls_detail_handler = Lino.uploads.MyUploads.detail;
    this.ls_insert_handler = Lino.uploads.MyUploads.insert;
    var ww = this.containing_window;
    var file5287 = Lino.file_field_handler(this,{ "selectOnFocus": true, "allowBlank": false, "maxLength": 100 });
    var description5288 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var user5289 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "preferred_width": 15, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/uploads/MyUploads/user", "method": "GET" }) }), "pageSize": 20, "emptyText": "Benutzer ausw\u00e4hlen..." });
    var owner_disp5290 = new Ext.form.DisplayField({ "disabled": true });
    var id5291 = new Ext.form.NumberField({ "selectOnFocus": true });
    var owner_type5292 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/uploads/MyUploads/owner_type", "method": "GET" }) }), "pageSize": 20, "emptyText": "Inhaltstyp ausw\u00e4hlen..." });
    var owner_id5293 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/uploads/MyUploads/owner_id", "method": "GET" }) }) });
    var created5294 = new Ext.form.DisplayField({ "disabled": true, "value": "<br>" });
    var modified5295 = new Ext.form.DisplayField({ "disabled": true, "value": "<br>" });
    var mimetype5296 = new Ext.form.TextField({ "disabled": true, "maxLength": 64 });
    var type5297 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/uploads/MyUploads/type", "method": "GET" }) }), "pageSize": 20, "emptyText": "Upload-Art ausw\u00e4hlen..." });
    var valid_until5298 = new Lino.DateField({ "selectOnFocus": true });
    this.before_row_edit = function(record) {
      owner_id5293.setContextValue('owner_type',record ? record.data['owner_typeHidden'] : undefined);
    };
    this.onRender = function(ct, position) {
      owner_type5292.on('change',Lino.chooser_handler(owner_id5293,'owner_type'));
      Lino.uploads.MyUploads.GridPanel.superclass.onRender.call(this, ct, position);
    }
    this.ls_columns = [ { "colIndex": 0, "sortable": true, "header": "File", "editable": true, "tooltip": "(uploads.MyUploads.file) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "file", "editor": file5287 }, { "colIndex": 1, "sortable": true, "header": "Beschreibung", "editable": true, "tooltip": "(uploads.MyUploads.description) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "description", "editor": description5288 }, { "colIndex": 2, "sortable": true, "header": "Autor", "editable": true, "tooltip": "(uploads.MyUploads.user) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "user", "editor": user5289 }, { "width": Lino.chars2width(11), "colIndex": 3, "sortable": false, "dataIndex": "owner", "header": "Verkn\u00fcpft mit", "editable": false, "tooltip": "(uploads.MyUploads.owner) " }, new Lino.NullNumberColumn({ "colIndex": 4, "sortable": true, "format": "0", "editable": true, "tooltip": "(uploads.MyUploads.id) ", "filter": { "type": "numeric" }, "header": "ID", "renderer": Lino.id_renderer, "editor": id5291, "width": Lino.chars2width(6), "dataIndex": "id" }), { "colIndex": 5, "sortable": true, "header": "Verkn\u00fcpft mit (Modell)", "editable": true, "tooltip": "(uploads.MyUploads.owner_type) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "owner_type", "editor": owner_type5292 }, { "colIndex": 6, "sortable": true, "header": "Verkn\u00fcpft mit (Objekt)", "editable": true, "tooltip": "(uploads.MyUploads.owner_id) ", "filter": { "type": "string" }, "width": Lino.chars2width(11), "dataIndex": "owner_id", "editor": owner_id5293 }, { "width": Lino.chars2width(17), "colIndex": 7, "sortable": true, "dataIndex": "created", "header": "Erstellt", "editable": false, "tooltip": "(uploads.MyUploads.created) " }, { "width": Lino.chars2width(17), "colIndex": 8, "sortable": true, "dataIndex": "modified", "header": "Bearbeitet", "editable": false, "tooltip": "(uploads.MyUploads.modified) " }, { "colIndex": 9, "sortable": true, "header": "MIME type", "editable": false, "tooltip": "(uploads.MyUploads.mimetype) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "mimetype" }, { "colIndex": 10, "sortable": true, "header": "Upload-Art", "editable": true, "tooltip": "(uploads.MyUploads.type) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "type", "editor": type5297 }, { "colIndex": 11, "sortable": true, "xtype": "datecolumn", "format": "d.m.Y", "editable": true, "tooltip": "(uploads.MyUploads.valid_until) ", "filter": { "type": "date", "dateFormat": "d.m.Y" }, "header": "g\u00fcltig bis", "dataIndex": "valid_until", "width": Lino.chars2width(9), "editor": valid_until5298 } ];
    Lino.uploads.MyUploads.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.uploads.MyUploads.put = function(rp,pk) { 
  Lino.run_row_action(rp,"/uploads/MyUploads","GET",pk,"put",null);
};
Lino.uploads.MyUploads.post = function(rp,pk) { 
  Lino.run_row_action(rp,"/uploads/MyUploads","GET",pk,"post",null);
};

Lino.uploads.MyUploads.insertPanel = Ext.extend(Lino.uploads.MyUploads.InsertFormPanel,{
  empty_title: "Neu Meine Uploads",
  hide_navigator: true,
  ls_bbar_actions: [ { "itemId": "post", "menu_item_text": "Erstellen", "tooltip": "Datensatz erstellen und dann im Detail-Fenster \u00f6ffnen", "panel_btn_handler": function(panel){panel.save(null,true,'post')}, "text": "Erstellen", "overflowText": "Erstellen", "auto_save": false }, { "itemId": "poststay", "menu_item_text": "Erstellen ohne Detail", "tooltip": "Nach Erstellen des Datensatzes kein Detail-Fenster \u00f6ffnen", "panel_btn_handler": function(panel){panel.save(null,false,'poststay')}, "text": "Erstellen ohne Detail", "overflowText": "Erstellen ohne Detail", "auto_save": false } ],
  ls_url: "/uploads/MyUploads",
  action_name: "insert",
  initComponent : function() {
    this.ls_detail_handler = Lino.uploads.MyUploads.detail;
    this.ls_insert_handler = Lino.uploads.MyUploads.insert;
    Lino.uploads.MyUploads.insertPanel.superclass.initComponent.call(this);
  }
});

Lino.uploads.MyUploads.insert = new Lino.WindowAction({ "draggable": true, "width": Lino.chars2width(60), "autoHeight": true, "maximizable": true, "modal": true, "maximized": false },function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.uploads.MyUploads.insertPanel(p);
});
Lino.uploads.MyUploads.poststay = function(rp,pk) { 
  Lino.run_row_action(rp,"/uploads/MyUploads","GET",pk,"poststay",null);
};

Lino.uploads.MyUploads.detailPanel = Ext.extend(Lino.uploads.MyUploads.DetailFormPanel,{
  empty_title: "Detail Meine Uploads",
  ls_bbar_actions: [ { "itemId": "put", "menu_item_text": "Speichern", "tooltip": "\u00c4nderungen in diesem Formular speichern", "panel_btn_handler": function(panel){panel.save(null,false,'put')}, "iconCls": "x-tbar-save", "overflowText": "Speichern", "auto_save": false }, { "itemId": "insert", "menu_item_text": "Neu", "must_save": true, "tooltip": "Neuen Datensatz erstellen", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-new", "overflowText": "Neu", "auto_save": true }, { "itemId": null, "menu_item_text": "L\u00f6schen", "tooltip": "Diesen Datensatz l\u00f6schen", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "L\u00f6schen", "auto_save": false } ],
  ls_url: "/uploads/MyUploads",
  action_name: "detail",
  initComponent : function() {
    this.ls_detail_handler = Lino.uploads.MyUploads.detail;
    this.ls_insert_handler = Lino.uploads.MyUploads.insert;
    Lino.uploads.MyUploads.detailPanel.superclass.initComponent.call(this);
  }
});

Lino.uploads.MyUploads.detail = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.uploads.MyUploads.detailPanel(p);
});
Lino.uploads.MyUploads.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.uploads.MyUploads.GridPanel(p);
});

// js_render_GridPanel_class households.MembersByHousehold
Lino.households.MembersByHousehold.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "Keine Daten anzuzeigen." },
  ls_url : "/households/MembersByHousehold",
  ls_bbar_actions : [ { "itemId": null, "menu_item_text": "L\u00f6schen", "tooltip": "Diesen Datensatz l\u00f6schen", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "L\u00f6schen", "auto_save": false } ],
  title : "Mitglieder",
  page_length : 20,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "name": "person" }, 'personHidden', { "name": "role" }, 'roleHidden', { "type": "date", "name": "start_date", "dateFormat": "d.m.Y" }, { "type": "date", "name": "end_date", "dateFormat": "d.m.Y" }, { "type": "int", "name": "id" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 6,
  ls_grid_configs : [  ],
  content_type : 37,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 8,
  initComponent : function() {
    var ww = this.containing_window;
    var person1565 = new Lino.RemoteComboFieldElement({ "preferred_width": 20, "allowBlank": false, "pageSize": 20, "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/households/MembersByHousehold/person", "method": "GET" }) }), "emptyText": "Person ausw\u00e4hlen..." });
    var role1566 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/households/MembersByHousehold/role", "method": "GET" }) }), "pageSize": 20, "emptyText": "Rolle in Haushalt ausw\u00e4hlen..." });
    var start_date1567 = new Lino.DateField({ "selectOnFocus": true });
    var end_date1568 = new Lino.DateField({ "selectOnFocus": true });
    var id1569 = new Ext.form.NumberField({ "selectOnFocus": true });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ { "colIndex": 0, "sortable": true, "header": "Person", "editable": true, "tooltip": "(households.MembersByHousehold.person) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "person", "editor": person1565 }, { "colIndex": 1, "sortable": true, "header": "Rolle in Haushalt", "editable": true, "tooltip": "(households.MembersByHousehold.role) The Role of this Person in this Household.\nList of choices is configured in `Configure --> Households --> Roles`.\n", "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "role", "editor": role1566 }, { "colIndex": 2, "sortable": true, "xtype": "datecolumn", "format": "d.m.Y", "editable": true, "tooltip": "(households.MembersByHousehold.start_date) ", "filter": { "type": "date", "dateFormat": "d.m.Y" }, "header": "From", "dataIndex": "start_date", "width": Lino.chars2width(9), "editor": start_date1567 }, { "colIndex": 3, "sortable": true, "xtype": "datecolumn", "format": "d.m.Y", "editable": true, "tooltip": "(households.MembersByHousehold.end_date) ", "filter": { "type": "date", "dateFormat": "d.m.Y" }, "header": "Until", "dataIndex": "end_date", "width": Lino.chars2width(9), "editor": end_date1568 }, new Lino.NullNumberColumn({ "colIndex": 4, "sortable": true, "format": "0", "editable": true, "tooltip": "(households.MembersByHousehold.id) ", "filter": { "type": "numeric" }, "header": "ID", "renderer": Lino.id_renderer, "editor": id1569, "width": Lino.chars2width(6), "dataIndex": "id" }) ];
    Lino.households.MembersByHousehold.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.households.MembersByHousehold.put = function(rp,pk) { 
  Lino.run_row_action(rp,"/households/MembersByHousehold","GET",pk,"put",null);
};
Lino.households.MembersByHousehold.post = function(rp,pk) { 
  Lino.run_row_action(rp,"/households/MembersByHousehold","GET",pk,"post",null);
};
Lino.households.MembersByHousehold.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.households.MembersByHousehold.GridPanel(p);
});

// js_render_GridPanel_class households.MembersByPerson
Lino.households.MembersByPerson.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "forceFit": true, "emptyText": "Keine Daten anzuzeigen." },
  ls_url : "/households/MembersByPerson",
  ls_bbar_actions : [ { "itemId": null, "menu_item_text": "L\u00f6schen", "tooltip": "Diesen Datensatz l\u00f6schen", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "L\u00f6schen", "auto_save": false } ],
  title : "Mitglied von",
  page_length : 20,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "name": "household" }, 'householdHidden', { "name": "role" }, 'roleHidden', { "type": "date", "name": "start_date", "dateFormat": "d.m.Y" }, { "type": "date", "name": "end_date", "dateFormat": "d.m.Y" }, { "type": "int", "name": "id" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 6,
  ls_grid_configs : [  ],
  content_type : 37,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 8,
  initComponent : function() {
    var ww = this.containing_window;
    var household1098 = new Lino.RemoteComboFieldElement({ "preferred_width": 20, "allowBlank": false, "pageSize": 20, "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/households/MembersByPerson/household", "method": "GET" }) }), "emptyText": "Haushalt ausw\u00e4hlen..." });
    var role1099 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/households/MembersByPerson/role", "method": "GET" }) }), "pageSize": 20, "emptyText": "Rolle in Haushalt ausw\u00e4hlen..." });
    var start_date1100 = new Lino.DateField({ "selectOnFocus": true });
    var end_date1101 = new Lino.DateField({ "selectOnFocus": true });
    var id1102 = new Ext.form.NumberField({ "selectOnFocus": true });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ { "colIndex": 0, "sortable": true, "header": "Haushalt", "editable": true, "tooltip": "(households.MembersByPerson.household) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "household", "editor": household1098 }, { "colIndex": 1, "sortable": true, "header": "Rolle in Haushalt", "editable": true, "tooltip": "(households.MembersByPerson.role) The Role of this Person in this Household.\nList of choices is configured in `Configure --> Households --> Roles`.\n", "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "role", "editor": role1099 }, { "colIndex": 2, "sortable": true, "xtype": "datecolumn", "format": "d.m.Y", "editable": true, "tooltip": "(households.MembersByPerson.start_date) ", "filter": { "type": "date", "dateFormat": "d.m.Y" }, "header": "From", "dataIndex": "start_date", "width": Lino.chars2width(9), "editor": start_date1100 }, { "colIndex": 3, "sortable": true, "xtype": "datecolumn", "format": "d.m.Y", "editable": true, "tooltip": "(households.MembersByPerson.end_date) ", "filter": { "type": "date", "dateFormat": "d.m.Y" }, "header": "Until", "dataIndex": "end_date", "width": Lino.chars2width(9), "editor": end_date1101 }, new Lino.NullNumberColumn({ "colIndex": 4, "sortable": true, "format": "0", "editable": true, "tooltip": "(households.MembersByPerson.id) ", "filter": { "type": "numeric" }, "header": "ID", "renderer": Lino.id_renderer, "editor": id1102, "width": Lino.chars2width(6), "dataIndex": "id" }) ];
    Lino.households.MembersByPerson.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.households.MembersByPerson.put = function(rp,pk) { 
  Lino.run_row_action(rp,"/households/MembersByPerson","GET",pk,"put",null);
};
Lino.households.MembersByPerson.post = function(rp,pk) { 
  Lino.run_row_action(rp,"/households/MembersByPerson","GET",pk,"post",null);
};
Lino.households.MembersByPerson.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.households.MembersByPerson.GridPanel(p);
});

// js_render_GridPanel_class households.MembersByRole
Lino.households.MembersByRole.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "Keine Daten anzuzeigen." },
  ls_url : "/households/MembersByRole",
  ls_bbar_actions : [ { "itemId": null, "menu_item_text": "L\u00f6schen", "tooltip": "Diesen Datensatz l\u00f6schen", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "L\u00f6schen", "auto_save": false } ],
  title : "Mitglieder",
  page_length : 20,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "name": "person" }, 'personHidden', { "name": "household" }, 'householdHidden', { "type": "date", "name": "start_date", "dateFormat": "d.m.Y" }, { "type": "date", "name": "end_date", "dateFormat": "d.m.Y" }, { "type": "int", "name": "id" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 6,
  ls_grid_configs : [  ],
  content_type : 37,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 8,
  initComponent : function() {
    var ww = this.containing_window;
    var person1592 = new Lino.RemoteComboFieldElement({ "preferred_width": 20, "allowBlank": false, "pageSize": 20, "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/households/MembersByRole/person", "method": "GET" }) }), "emptyText": "Person ausw\u00e4hlen..." });
    var household1593 = new Lino.RemoteComboFieldElement({ "preferred_width": 20, "allowBlank": false, "pageSize": 20, "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/households/MembersByRole/household", "method": "GET" }) }), "emptyText": "Haushalt ausw\u00e4hlen..." });
    var start_date1594 = new Lino.DateField({ "selectOnFocus": true });
    var end_date1595 = new Lino.DateField({ "selectOnFocus": true });
    var id1596 = new Ext.form.NumberField({ "selectOnFocus": true });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ { "colIndex": 0, "sortable": true, "header": "Person", "editable": true, "tooltip": "(households.MembersByRole.person) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "person", "editor": person1592 }, { "colIndex": 1, "sortable": true, "header": "Haushalt", "editable": true, "tooltip": "(households.MembersByRole.household) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "household", "editor": household1593 }, { "colIndex": 2, "sortable": true, "xtype": "datecolumn", "format": "d.m.Y", "editable": true, "tooltip": "(households.MembersByRole.start_date) ", "filter": { "type": "date", "dateFormat": "d.m.Y" }, "header": "From", "dataIndex": "start_date", "width": Lino.chars2width(9), "editor": start_date1594 }, { "colIndex": 3, "sortable": true, "xtype": "datecolumn", "format": "d.m.Y", "editable": true, "tooltip": "(households.MembersByRole.end_date) ", "filter": { "type": "date", "dateFormat": "d.m.Y" }, "header": "Until", "dataIndex": "end_date", "width": Lino.chars2width(9), "editor": end_date1595 }, new Lino.NullNumberColumn({ "colIndex": 4, "sortable": true, "format": "0", "editable": true, "tooltip": "(households.MembersByRole.id) ", "filter": { "type": "numeric" }, "header": "ID", "renderer": Lino.id_renderer, "editor": id1596, "width": Lino.chars2width(6), "dataIndex": "id" }) ];
    Lino.households.MembersByRole.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.households.MembersByRole.put = function(rp,pk) { 
  Lino.run_row_action(rp,"/households/MembersByRole","GET",pk,"put",null);
};
Lino.households.MembersByRole.post = function(rp,pk) { 
  Lino.run_row_action(rp,"/households/MembersByRole","GET",pk,"post",null);
};
Lino.households.MembersByRole.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.households.MembersByRole.GridPanel(p);
});

// js_render_GridPanel_class reception.AppointmentsByGuest
Lino.reception.AppointmentsByGuest.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "forceFit": true, "emptyText": "Keine Daten anzuzeigen." },
  ls_url : "/reception/AppointmentsByGuest",
  ls_bbar_actions : [ { "itemId": "duplicate", "menu_item_text": "Duplizieren", "must_save": true, "tooltip": "Duplizieren", "panel_btn_handler": Lino.row_action_handler('duplicate','GET',null), "iconCls": "x-tbar-duplicate", "overflowText": "Duplizieren", "auto_save": true }, { "itemId": "do_print", "menu_item_text": "Drucken", "must_save": true, "tooltip": "Drucken", "panel_btn_handler": Lino.row_action_handler('do_print','GET',null), "iconCls": "x-tbar-print", "overflowText": "Drucken", "auto_save": true }, { "itemId": "do_clear_cache", "menu_item_text": "Cache l\u00f6schen", "must_save": true, "tooltip": "Cache l\u00f6schen", "panel_btn_handler": Lino.row_action_handler('do_clear_cache','GET',null), "iconCls": "x-tbar-clearcache", "overflowText": "Cache l\u00f6schen", "auto_save": true }, { "itemId": "create_mail", "menu_item_text": "per E-Mail", "must_save": true, "tooltip": "Create an email from this", "panel_btn_handler": Lino.row_action_handler('create_mail','GET',null), "iconCls": "x-tbar-email_add", "overflowText": "per E-Mail", "auto_save": true } ],
  title : "Termine",
  page_length : 20,
  stripeRows : true,
  disable_editing : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "name": "event__when_text" }, { "name": "event__user" }, 'event__userHidden', { "name": "workflow_buttons" }, { "type": "int", "name": "id" }, { "name": "disabled_fields" }, { "name": "disabled_actions" } ],
  pk_index : 4,
  ls_grid_configs : [  ],
  content_type : 36,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 6,
  initComponent : function() {
    var ww = this.containing_window;
    var event__when_text_disp3072 = new Ext.form.DisplayField({ "disabled": true, "value": "<br/>", "always_enabled": true });
    var event__user3073 = new Lino.RemoteComboFieldElement({ "disabled": true, "preferred_width": 15, "store": new Lino.ComplexRemoteComboStore({  }), "pageSize": 20, "emptyText": "Benutzer ausw\u00e4hlen..." });
    var workflow_buttons_disp3074 = new Ext.form.DisplayField({ "disabled": true, "value": "<br/>", "always_enabled": true });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ { "width": Lino.chars2width(31), "colIndex": 0, "sortable": false, "dataIndex": "event__when_text", "header": "Wann", "editable": false, "tooltip": "(reception.AppointmentsByGuest.event__when_text) " }, { "colIndex": 1, "sortable": true, "header": "Verantwortlicher", "editable": false, "tooltip": "(reception.AppointmentsByGuest.event__user) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "event__user" }, { "width": Lino.chars2width(31), "colIndex": 2, "sortable": false, "dataIndex": "workflow_buttons", "header": "Arbeitsablauf", "editable": false, "tooltip": "(reception.AppointmentsByGuest.workflow_buttons) " } ];
    Lino.reception.AppointmentsByGuest.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.reception.AppointmentsByGuest.duplicate = function(rp,pk) { 
  Lino.run_row_action(rp,"/reception/AppointmentsByGuest","GET",pk,"duplicate",null);
};
Lino.reception.AppointmentsByGuest.wf3 = function(rp,pk) { 
  Lino.run_row_action(rp,"/reception/AppointmentsByGuest","GET",pk,"wf3",null);
};
Lino.reception.AppointmentsByGuest.wf4 = function(rp,pk) { 
  Lino.run_row_action(rp,"/reception/AppointmentsByGuest","GET",pk,"wf4",null);
};
Lino.reception.AppointmentsByGuest.do_print = function(rp,pk) { 
  Lino.run_row_action(rp,"/reception/AppointmentsByGuest","GET",pk,"do_print",null);
};
Lino.reception.AppointmentsByGuest.do_clear_cache = function(rp,pk) { 
  Lino.run_row_action(rp,"/reception/AppointmentsByGuest","GET",pk,"do_clear_cache",null);
};
Lino.reception.AppointmentsByGuest.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.reception.AppointmentsByGuest.GridPanel(p);
});
Lino.reception.AppointmentsByGuest.create_mail = function(rp,pk) { 
  Lino.run_row_action(rp,"/reception/AppointmentsByGuest","GET",pk,"create_mail",null);
};
Lino.reception.AppointmentsByGuest.receive = function(rp,pk) { 
  Lino.run_row_action(rp,"/reception/AppointmentsByGuest","GET",pk,"receive",null);
};
Lino.reception.AppointmentsByGuest.checkout = function(rp,pk) { 
  Lino.run_row_action(rp,"/reception/AppointmentsByGuest","GET",pk,"checkout",null);
};

// js_render_GridPanel_class jobs.CandidaturesByOffer
Lino.jobs.CandidaturesByOffer.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "Keine Daten anzuzeigen." },
  ls_url : "/jobs/CandidaturesByOffer",
  ls_bbar_actions : [ { "itemId": null, "menu_item_text": "L\u00f6schen", "tooltip": "Diesen Datensatz l\u00f6schen", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "L\u00f6schen", "auto_save": false } ],
  title : "Kandidaten",
  page_length : 20,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "type": "int", "name": "id" }, { "name": "sector" }, 'sectorHidden', { "name": "function" }, 'functionHidden', { "name": "person" }, 'personHidden', { "name": "job" }, 'jobHidden', { "type": "date", "name": "date_submitted", "dateFormat": "d.m.Y" }, { "name": "remark" }, { "name": "state" }, 'stateHidden', { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 0,
  ls_grid_configs : [  ],
  content_type : 66,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 14,
  initComponent : function() {
    var ww = this.containing_window;
    var id2475 = new Ext.form.NumberField({ "selectOnFocus": true });
    var sector2476 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/jobs/CandidaturesByOffer/sector", "method": "GET" }) }), "pageSize": 20, "emptyText": "Sektor ausw\u00e4hlen..." });
    var function2477 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/jobs/CandidaturesByOffer/function", "method": "GET" }) }), "pageSize": 20, "emptyText": "Funktion ausw\u00e4hlen..." });
    var person2478 = new Lino.RemoteComboFieldElement({ "preferred_width": 20, "allowBlank": false, "pageSize": 20, "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/jobs/CandidaturesByOffer/person", "method": "GET" }) }), "emptyText": "Klient ausw\u00e4hlen..." });
    var job2479 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "preferred_width": 20, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/jobs/CandidaturesByOffer/job", "method": "GET" }) }), "pageSize": 20, "emptyText": "Stelle ausw\u00e4hlen..." });
    var date_submitted2480 = new Lino.DateField({ "selectOnFocus": true, "allowBlank": false });
    var remark2481 = new Ext.form.TextArea({ "selectOnFocus": true, "growMax": 2000 });
    var state2482 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "forceSelection": true, "allowBlank": false, "store": Lino.jobs.CandidatureStates });
    this.before_row_edit = function(record) {
      function2477.setContextValue('sector',record ? record.data['sectorHidden'] : undefined);
    };
    this.onRender = function(ct, position) {
      sector2476.on('change',Lino.chooser_handler(function2477,'sector'));
      Lino.jobs.CandidaturesByOffer.GridPanel.superclass.onRender.call(this, ct, position);
    }
    this.ls_columns = [ new Lino.NullNumberColumn({ "colIndex": 0, "sortable": true, "format": "0", "editable": true, "tooltip": "(jobs.CandidaturesByOffer.id) ", "filter": { "type": "numeric" }, "header": "ID", "renderer": Lino.id_renderer, "editor": id2475, "width": Lino.chars2width(6), "dataIndex": "id" }), { "colIndex": 1, "sortable": true, "header": "Sektor", "editable": true, "tooltip": "(jobs.CandidaturesByOffer.sector) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "sector", "editor": sector2476 }, { "colIndex": 2, "sortable": true, "header": "Funktion", "editable": true, "tooltip": "(jobs.CandidaturesByOffer.function) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "function", "editor": function2477 }, { "colIndex": 3, "sortable": true, "header": "Klient", "editable": true, "tooltip": "(jobs.CandidaturesByOffer.person) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "person", "editor": person2478 }, { "colIndex": 4, "sortable": true, "header": "Stelle", "editable": true, "tooltip": "(jobs.CandidaturesByOffer.job) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "job", "editor": job2479 }, { "colIndex": 5, "sortable": true, "xtype": "datecolumn", "format": "d.m.Y", "editable": true, "tooltip": "(jobs.CandidaturesByOffer.date_submitted) Datum wann der SA die Kandidatur erfasst hat.", "filter": { "type": "date", "dateFormat": "d.m.Y" }, "header": "Anfragedatum", "dataIndex": "date_submitted", "width": Lino.chars2width(9), "editor": date_submitted2480 }, { "colIndex": 6, "sortable": false, "header": "Bemerkung", "editable": true, "tooltip": "(jobs.CandidaturesByOffer.remark) ", "filter": { "type": "string" }, "width": Lino.chars2width(61), "renderer": Lino.text_renderer, "editor": remark2481, "dataIndex": "remark" }, { "colIndex": 7, "sortable": true, "header": "Kandidatur-Zustand", "editable": true, "tooltip": "(jobs.CandidaturesByOffer.state) ", "filter": { "type": "string" }, "width": Lino.chars2width(20), "dataIndex": "state", "editor": state2482 } ];
    Lino.jobs.CandidaturesByOffer.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.jobs.CandidaturesByOffer.put = function(rp,pk) { 
  Lino.run_row_action(rp,"/jobs/CandidaturesByOffer","GET",pk,"put",null);
};
Lino.jobs.CandidaturesByOffer.post = function(rp,pk) { 
  Lino.run_row_action(rp,"/jobs/CandidaturesByOffer","GET",pk,"post",null);
};
Lino.jobs.CandidaturesByOffer.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.jobs.CandidaturesByOffer.GridPanel(p);
});

// js_render_GridPanel_class jobs.ExperiencesByOffer
Lino.jobs.ExperiencesByOffer.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "Keine Daten anzuzeigen." },
  ls_url : "/jobs/ExperiencesByOffer",
  ls_bbar_actions : [ { "itemId": null, "menu_item_text": "L\u00f6schen", "tooltip": "Diesen Datensatz l\u00f6schen", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "L\u00f6schen", "auto_save": false } ],
  title : "Kandidaten",
  page_length : 20,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "type": "int", "name": "id" }, { "name": "sector" }, 'sectorHidden', { "name": "function" }, 'functionHidden', { "name": "person" }, 'personHidden', { "name": "company" }, { "name": "title" }, { "name": "country" }, 'countryHidden', { "type": "date", "name": "started", "dateFormat": "d.m.Y" }, { "type": "date", "name": "stopped", "dateFormat": "d.m.Y" }, { "name": "remarks" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 0,
  ls_grid_configs : [  ],
  content_type : 72,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 15,
  initComponent : function() {
    var ww = this.containing_window;
    var id2463 = new Ext.form.NumberField({ "selectOnFocus": true });
    var sector2464 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/jobs/ExperiencesByOffer/sector", "method": "GET" }) }), "pageSize": 20, "emptyText": "Sektor ausw\u00e4hlen..." });
    var function2465 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/jobs/ExperiencesByOffer/function", "method": "GET" }) }), "pageSize": 20, "emptyText": "Funktion ausw\u00e4hlen..." });
    var person2466 = new Lino.RemoteComboFieldElement({ "preferred_width": 20, "allowBlank": false, "pageSize": 20, "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/jobs/ExperiencesByOffer/person", "method": "GET" }) }), "emptyText": "Klient ausw\u00e4hlen..." });
    var company2467 = new Ext.form.TextField({ "selectOnFocus": true, "allowBlank": false, "maxLength": 200 });
    var title2468 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var country2469 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/jobs/ExperiencesByOffer/country", "method": "GET" }) }), "pageSize": 20, "emptyText": "Land ausw\u00e4hlen..." });
    var started2470 = new Lino.DateField({ "selectOnFocus": true, "format": "m/Y", "plugins": "monthPickerPlugin" });
    var stopped2471 = new Lino.DateField({ "selectOnFocus": true, "format": "m/Y", "plugins": "monthPickerPlugin" });
    var remarks2472 = new Ext.form.TextArea({ "selectOnFocus": true, "growMax": 2000 });
    this.before_row_edit = function(record) {
      function2465.setContextValue('sector',record ? record.data['sectorHidden'] : undefined);
    };
    this.onRender = function(ct, position) {
      sector2464.on('change',Lino.chooser_handler(function2465,'sector'));
      Lino.jobs.ExperiencesByOffer.GridPanel.superclass.onRender.call(this, ct, position);
    }
    this.ls_columns = [ new Lino.NullNumberColumn({ "colIndex": 0, "sortable": true, "format": "0", "editable": true, "tooltip": "(jobs.ExperiencesByOffer.id) ", "filter": { "type": "numeric" }, "header": "ID", "renderer": Lino.id_renderer, "editor": id2463, "width": Lino.chars2width(6), "dataIndex": "id" }), { "colIndex": 1, "sortable": true, "header": "Sektor", "editable": true, "tooltip": "(jobs.ExperiencesByOffer.sector) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "sector", "editor": sector2464 }, { "colIndex": 2, "sortable": true, "header": "Funktion", "editable": true, "tooltip": "(jobs.ExperiencesByOffer.function) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "function", "editor": function2465 }, { "colIndex": 3, "sortable": true, "header": "Klient", "editable": true, "tooltip": "(jobs.ExperiencesByOffer.person) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "person", "editor": person2466 }, { "colIndex": 4, "sortable": true, "header": "Firma", "editable": true, "tooltip": "(jobs.ExperiencesByOffer.company) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "company", "editor": company2467 }, { "colIndex": 5, "sortable": true, "header": "Bezeichnung", "editable": true, "tooltip": "(jobs.ExperiencesByOffer.title) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "title", "editor": title2468 }, { "colIndex": 6, "sortable": true, "header": "Land", "editable": true, "tooltip": "(jobs.ExperiencesByOffer.country) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "country", "editor": country2469 }, { "colIndex": 7, "sortable": true, "xtype": "datecolumn", "format": "d.m.Y", "editable": true, "tooltip": "(jobs.ExperiencesByOffer.started) ", "filter": { "type": "date", "dateFormat": "d.m.Y" }, "header": "begonnen", "dataIndex": "started", "width": Lino.chars2width(9), "editor": started2470 }, { "colIndex": 8, "sortable": true, "xtype": "datecolumn", "format": "d.m.Y", "editable": true, "tooltip": "(jobs.ExperiencesByOffer.stopped) ", "filter": { "type": "date", "dateFormat": "d.m.Y" }, "header": "beendet", "dataIndex": "stopped", "width": Lino.chars2width(9), "editor": stopped2471 }, { "colIndex": 9, "sortable": false, "header": "Bemerkungen", "editable": true, "tooltip": "(jobs.ExperiencesByOffer.remarks) ", "filter": { "type": "string" }, "width": Lino.chars2width(61), "renderer": Lino.text_renderer, "editor": remarks2472, "dataIndex": "remarks" } ];
    Lino.jobs.ExperiencesByOffer.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.jobs.ExperiencesByOffer.put = function(rp,pk) { 
  Lino.run_row_action(rp,"/jobs/ExperiencesByOffer","GET",pk,"put",null);
};
Lino.jobs.ExperiencesByOffer.post = function(rp,pk) { 
  Lino.run_row_action(rp,"/jobs/ExperiencesByOffer","GET",pk,"post",null);
};
Lino.jobs.ExperiencesByOffer.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.jobs.ExperiencesByOffer.GridPanel(p);
});

// js_render_GridPanel_class pcsw.ContactsByClient
Lino.pcsw.ContactsByClient.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "Keine Daten anzuzeigen." },
  ls_url : "/pcsw/ContactsByClient",
  ls_bbar_actions : [ { "itemId": null, "menu_item_text": "L\u00f6schen", "tooltip": "Diesen Datensatz l\u00f6schen", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "L\u00f6schen", "auto_save": false } ],
  title : "Kontakte",
  page_length : 20,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "name": "type" }, 'typeHidden', { "name": "company" }, 'companyHidden', { "name": "contact_person" }, 'contact_personHidden', { "name": "contact_role" }, 'contact_roleHidden', { "name": "remark" }, { "type": "int", "name": "id" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 9,
  ls_grid_configs : [  ],
  content_type : 56,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 11,
  initComponent : function() {
    var ww = this.containing_window;
    var type2672 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/pcsw/ContactsByClient/type", "method": "GET" }) }), "pageSize": 20, "emptyText": "Klientenkontaktart ausw\u00e4hlen..." });
    var company2673 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "preferred_width": 20, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/pcsw/ContactsByClient/company", "method": "GET" }) }), "pageSize": 20, "emptyText": "Organisation ausw\u00e4hlen..." });
    var contact_person2674 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "preferred_width": 20, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/pcsw/ContactsByClient/contact_person", "method": "GET" }) }), "pageSize": 20, "emptyText": "Person ausw\u00e4hlen..." });
    var contact_role2675 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/pcsw/ContactsByClient/contact_role", "method": "GET" }) }), "pageSize": 20, "emptyText": "Funktion ausw\u00e4hlen..." });
    var remark2676 = new Ext.form.TextArea({ "selectOnFocus": true, "growMax": 2000 });
    var id2677 = new Ext.form.NumberField({ "selectOnFocus": true });
    this.before_row_edit = function(record) {
      company2673.setContextValue('type',record ? record.data['typeHidden'] : undefined);
      contact_person2674.setContextValue('company',record ? record.data['companyHidden'] : undefined);
    };
    this.onRender = function(ct, position) {
      type2672.on('change',Lino.chooser_handler(company2673,'type'));
      company2673.on('change',Lino.chooser_handler(contact_person2674,'company'));
      Lino.pcsw.ContactsByClient.GridPanel.superclass.onRender.call(this, ct, position);
    }
    this.ls_columns = [ { "colIndex": 0, "sortable": true, "header": "Klientenkontaktart", "editable": true, "tooltip": "(pcsw.ContactsByClient.type) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "type", "editor": type2672 }, { "colIndex": 1, "sortable": true, "header": "Organisation", "editable": true, "tooltip": "(pcsw.ContactsByClient.company) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "company", "editor": company2673 }, { "colIndex": 2, "sortable": true, "header": "Kontaktperson", "editable": true, "tooltip": "(pcsw.ContactsByClient.contact_person) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "contact_person", "editor": contact_person2674 }, { "colIndex": 3, "sortable": true, "header": "in seiner Eigenschaft als", "editable": true, "tooltip": "(pcsw.ContactsByClient.contact_role) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "contact_role", "editor": contact_role2675 }, { "colIndex": 4, "sortable": false, "header": "Bemerkungen", "editable": true, "tooltip": "(pcsw.ContactsByClient.remark) ", "filter": { "type": "string" }, "width": Lino.chars2width(61), "renderer": Lino.text_renderer, "editor": remark2676, "dataIndex": "remark" }, new Lino.NullNumberColumn({ "colIndex": 5, "sortable": true, "format": "0", "editable": true, "tooltip": "(pcsw.ContactsByClient.id) ", "filter": { "type": "numeric" }, "header": "ID", "renderer": Lino.id_renderer, "editor": id2677, "width": Lino.chars2width(6), "dataIndex": "id" }) ];
    Lino.pcsw.ContactsByClient.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.pcsw.ContactsByClient.put = function(rp,pk) { 
  Lino.run_row_action(rp,"/pcsw/ContactsByClient","GET",pk,"put",null);
};
Lino.pcsw.ContactsByClient.post = function(rp,pk) { 
  Lino.run_row_action(rp,"/pcsw/ContactsByClient","GET",pk,"post",null);
};
Lino.pcsw.ContactsByClient.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.pcsw.ContactsByClient.GridPanel(p);
});

// js_render_GridPanel_class pcsw.CoachingsByClient
Lino.pcsw.CoachingsByClient.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "forceFit": true, "emptyText": "Keine Daten anzuzeigen." },
  ls_url : "/pcsw/CoachingsByClient",
  ls_bbar_actions : [ { "itemId": null, "menu_item_text": "L\u00f6schen", "tooltip": "Diesen Datensatz l\u00f6schen", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "L\u00f6schen", "auto_save": false }, { "itemId": "create_visit", "menu_item_text": "Create visit", "tooltip": "Create a prompt event for this client with this coach.", "panel_btn_handler": Lino.param_action_handler(Lino.pcsw.Coachings.create_visit), "text": "Create visit", "overflowText": "Create visit", "auto_save": true } ],
  title : "Begleitungen",
  page_length : 20,
  params_panel_hidden : true,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "type": "date", "name": "start_date", "dateFormat": "d.m.Y" }, { "type": "date", "name": "end_date", "dateFormat": "d.m.Y" }, { "name": "user" }, 'userHidden', { "type": "boolean", "name": "primary" }, { "name": "type" }, 'typeHidden', { "name": "ending" }, 'endingHidden', { "type": "int", "name": "id" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 9,
  ls_grid_configs : [  ],
  content_type : 51,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 11,
  initComponent : function() {
    var ww = this.containing_window;
    var start_date2680 = new Lino.DateField({ "selectOnFocus": true });
    var end_date2681 = new Lino.DateField({ "selectOnFocus": true });
    var user2682 = new Lino.RemoteComboFieldElement({ "preferred_width": 15, "allowBlank": false, "pageSize": 20, "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/pcsw/CoachingsByClient/user", "method": "GET" }) }), "emptyText": "Benutzer ausw\u00e4hlen..." });
    var primary2683 = new Ext.form.Checkbox({ "selectOnFocus": true, "checked": false });
    var type2684 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/pcsw/CoachingsByClient/type", "method": "GET" }) }), "pageSize": 20, "emptyText": "Dienst ausw\u00e4hlen..." });
    var ending2685 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/pcsw/CoachingsByClient/ending", "method": "GET" }) }), "pageSize": 20, "emptyText": "Beendigungsgrund ausw\u00e4hlen..." });
    var id2686 = new Ext.form.NumberField({ "selectOnFocus": true });
    this.before_row_edit = function(record) {
      ending2685.setContextValue('type',record ? record.data['typeHidden'] : undefined);
    };
    this.onRender = function(ct, position) {
      type2684.on('change',Lino.chooser_handler(ending2685,'type'));
      Lino.pcsw.CoachingsByClient.GridPanel.superclass.onRender.call(this, ct, position);
    }
    this.ls_columns = [ { "colIndex": 0, "sortable": true, "xtype": "datecolumn", "format": "d.m.Y", "editable": true, "tooltip": "(pcsw.CoachingsByClient.start_date) ", "filter": { "type": "date", "dateFormat": "d.m.Y" }, "header": "Begleitet seit", "dataIndex": "start_date", "width": Lino.chars2width(9), "editor": start_date2680 }, { "colIndex": 1, "sortable": true, "xtype": "datecolumn", "format": "d.m.Y", "editable": true, "tooltip": "(pcsw.CoachingsByClient.end_date) ", "filter": { "type": "date", "dateFormat": "d.m.Y" }, "header": "bis", "dataIndex": "end_date", "width": Lino.chars2width(9), "editor": end_date2681 }, { "colIndex": 2, "sortable": true, "header": "Begleiter", "editable": true, "tooltip": "(pcsw.CoachingsByClient.user) ", "filter": { "type": "string" }, "width": Lino.chars2width(13), "dataIndex": "user", "editor": user2682 }, { "colIndex": 3, "sortable": false, "xtype": "checkcolumn", "header": "Prim\u00e4r", "editable": true, "tooltip": "(pcsw.CoachingsByClient.primary) There's at most one primary coach per client. \nEnabling this field will automatically make the other coachings non-primary.", "filter": { "type": "boolean" }, "width": Lino.chars2width(11), "dataIndex": "primary" }, { "colIndex": 4, "sortable": true, "header": "Dienst", "editable": true, "tooltip": "(pcsw.CoachingsByClient.type) ", "filter": { "type": "string" }, "width": Lino.chars2width(13), "dataIndex": "type", "editor": type2684 }, { "colIndex": 5, "sortable": true, "header": "Beendigungsgrund", "editable": true, "tooltip": "(pcsw.CoachingsByClient.ending) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "ending", "editor": ending2685 }, new Lino.NullNumberColumn({ "colIndex": 6, "sortable": true, "format": "0", "editable": true, "tooltip": "(pcsw.CoachingsByClient.id) ", "filter": { "type": "numeric" }, "header": "ID", "renderer": Lino.id_renderer, "hidden": true, "editor": id2686, "width": Lino.chars2width(6), "dataIndex": "id" }) ];
    Lino.pcsw.CoachingsByClient.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.pcsw.CoachingsByClient.put = function(rp,pk) { 
  Lino.run_row_action(rp,"/pcsw/CoachingsByClient","GET",pk,"put",null);
};
Lino.pcsw.CoachingsByClient.post = function(rp,pk) { 
  Lino.run_row_action(rp,"/pcsw/CoachingsByClient","GET",pk,"post",null);
};
Lino.pcsw.CoachingsByClient.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  p.params_panel = new Lino.pcsw.CoachingsByClient.ParamsPanel({});
  return new Lino.pcsw.CoachingsByClient.GridPanel(p);
});

// js_render_GridPanel_class pcsw.CoachingsByUser
Lino.pcsw.CoachingsByUser.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "Keine Daten anzuzeigen." },
  ls_url : "/pcsw/CoachingsByUser",
  ls_bbar_actions : [ { "itemId": null, "menu_item_text": "L\u00f6schen", "tooltip": "Diesen Datensatz l\u00f6schen", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "L\u00f6schen", "auto_save": false }, { "itemId": "create_visit", "menu_item_text": "Create visit", "tooltip": "Create a prompt event for this client with this coach.", "panel_btn_handler": Lino.param_action_handler(Lino.pcsw.Coachings.create_visit), "text": "Create visit", "overflowText": "Create visit", "auto_save": true } ],
  title : "Begleitungen",
  page_length : 20,
  params_panel_hidden : true,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "type": "date", "name": "start_date", "dateFormat": "d.m.Y" }, { "type": "date", "name": "end_date", "dateFormat": "d.m.Y" }, { "name": "client" }, 'clientHidden', { "name": "type" }, 'typeHidden', { "type": "boolean", "name": "primary" }, { "type": "int", "name": "id" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 7,
  ls_grid_configs : [  ],
  content_type : 51,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 9,
  initComponent : function() {
    var ww = this.containing_window;
    var start_date370 = new Lino.DateField({ "selectOnFocus": true });
    var end_date371 = new Lino.DateField({ "selectOnFocus": true });
    var client372 = new Lino.RemoteComboFieldElement({ "preferred_width": 20, "allowBlank": false, "pageSize": 20, "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/pcsw/CoachingsByUser/client", "method": "GET" }) }), "emptyText": "Klient ausw\u00e4hlen..." });
    var type373 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/pcsw/CoachingsByUser/type", "method": "GET" }) }), "pageSize": 20, "emptyText": "Dienst ausw\u00e4hlen..." });
    var primary374 = new Ext.form.Checkbox({ "selectOnFocus": true, "checked": false });
    var id375 = new Ext.form.NumberField({ "selectOnFocus": true });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ { "colIndex": 0, "sortable": true, "xtype": "datecolumn", "format": "d.m.Y", "editable": true, "tooltip": "(pcsw.CoachingsByUser.start_date) ", "filter": { "type": "date", "dateFormat": "d.m.Y" }, "header": "Begleitet seit", "dataIndex": "start_date", "width": Lino.chars2width(9), "editor": start_date370 }, { "colIndex": 1, "sortable": true, "xtype": "datecolumn", "format": "d.m.Y", "editable": true, "tooltip": "(pcsw.CoachingsByUser.end_date) ", "filter": { "type": "date", "dateFormat": "d.m.Y" }, "header": "bis", "dataIndex": "end_date", "width": Lino.chars2width(9), "editor": end_date371 }, { "colIndex": 2, "sortable": true, "header": "Klient", "editable": true, "tooltip": "(pcsw.CoachingsByUser.client) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "client", "editor": client372 }, { "colIndex": 3, "sortable": true, "header": "Dienst", "editable": true, "tooltip": "(pcsw.CoachingsByUser.type) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "type", "editor": type373 }, { "colIndex": 4, "sortable": false, "xtype": "checkcolumn", "header": "Prim\u00e4r", "editable": true, "tooltip": "(pcsw.CoachingsByUser.primary) There's at most one primary coach per client. \nEnabling this field will automatically make the other coachings non-primary.", "filter": { "type": "boolean" }, "width": Lino.chars2width(11), "dataIndex": "primary" }, new Lino.NullNumberColumn({ "colIndex": 5, "sortable": true, "format": "0", "editable": true, "tooltip": "(pcsw.CoachingsByUser.id) ", "filter": { "type": "numeric" }, "header": "ID", "renderer": Lino.id_renderer, "editor": id375, "width": Lino.chars2width(6), "dataIndex": "id" }) ];
    Lino.pcsw.CoachingsByUser.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.pcsw.CoachingsByUser.put = function(rp,pk) { 
  Lino.run_row_action(rp,"/pcsw/CoachingsByUser","GET",pk,"put",null);
};
Lino.pcsw.CoachingsByUser.post = function(rp,pk) { 
  Lino.run_row_action(rp,"/pcsw/CoachingsByUser","GET",pk,"post",null);
};
Lino.pcsw.CoachingsByUser.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  p.params_panel = new Lino.pcsw.CoachingsByClient.ParamsPanel({});
  return new Lino.pcsw.CoachingsByUser.GridPanel(p);
});

// js_render_GridPanel_class pcsw.NotesByPerson
Lino.pcsw.NotesByPerson.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "Keine Daten anzuzeigen." },
  ls_url : "/pcsw/NotesByPerson",
  ls_bbar_actions : [ { "itemId": "insert", "menu_item_text": "Neu", "must_save": true, "tooltip": "Neuen Datensatz erstellen", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-new", "overflowText": "Neu", "auto_save": true }, { "itemId": "duplicate", "menu_item_text": "Duplizieren", "must_save": true, "tooltip": "Duplizieren", "panel_btn_handler": Lino.row_action_handler('duplicate','GET',null), "iconCls": "x-tbar-duplicate", "overflowText": "Duplizieren", "auto_save": true }, { "itemId": "detail", "menu_item_text": "Detail", "tooltip": "Detail-Fenster auf diesem Datensatz \u00f6ffnen", "panel_btn_handler": Lino.show_detail, "iconCls": "x-tbar-detail", "overflowText": "Detail", "auto_save": true }, { "itemId": null, "menu_item_text": "L\u00f6schen", "tooltip": "Diesen Datensatz l\u00f6schen", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "L\u00f6schen", "auto_save": false }, { "itemId": "do_print", "menu_item_text": "Drucken", "must_save": true, "tooltip": "Drucken", "panel_btn_handler": Lino.row_action_handler('do_print','GET',null), "iconCls": "x-tbar-print", "overflowText": "Drucken", "auto_save": true }, { "itemId": "do_clear_cache", "menu_item_text": "Cache l\u00f6schen", "must_save": true, "tooltip": "Cache l\u00f6schen", "panel_btn_handler": Lino.row_action_handler('do_clear_cache','GET',null), "iconCls": "x-tbar-clearcache", "overflowText": "Cache l\u00f6schen", "auto_save": true }, { "itemId": "create_mail", "menu_item_text": "per E-Mail", "must_save": true, "tooltip": "Create an email from this", "panel_btn_handler": Lino.row_action_handler('create_mail','GET',null), "iconCls": "x-tbar-email_add", "overflowText": "per E-Mail", "auto_save": true } ],
  title : "Ereignisse/Notizen",
  page_length : 20,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "type": "date", "name": "date", "dateFormat": "d.m.Y" }, { "name": "event_type" }, 'event_typeHidden', { "name": "type" }, 'typeHidden', { "name": "subject" }, { "name": "body" }, { "name": "user" }, 'userHidden', { "name": "company" }, 'companyHidden', { "type": "int", "name": "id" }, { "name": "owner_type" }, 'owner_typeHidden', { "name": "owner_id" }, 'owner_idHidden', { "name": "build_time" }, { "name": "contact_person" }, 'contact_personHidden', { "name": "contact_role" }, 'contact_roleHidden', { "name": "language" }, 'languageHidden', { "name": "owner" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 11,
  ls_grid_configs : [  ],
  content_type : 93,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 25,
  initComponent : function() {
    this.ls_detail_handler = Lino.pcsw.NotesByPerson.detail;
    this.ls_insert_handler = Lino.pcsw.NotesByPerson.insert;
    var ww = this.containing_window;
    var date2853 = new Lino.DateField({ "selectOnFocus": true, "allowBlank": false });
    var event_type2854 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/pcsw/NotesByPerson/event_type", "method": "GET" }) }), "pageSize": 20, "emptyText": "Event Type ausw\u00e4hlen..." });
    var type2855 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/pcsw/NotesByPerson/type", "method": "GET" }) }), "pageSize": 20, "emptyText": "Notizart ausw\u00e4hlen..." });
    var subject2856 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var body2857 = new Lino.RichTextPanel({ "selectOnFocus": true, "containing_panel": this, "title": "Inhalt" });
    var user2858 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "preferred_width": 15, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/pcsw/NotesByPerson/user", "method": "GET" }) }), "pageSize": 20, "emptyText": "Benutzer ausw\u00e4hlen..." });
    var company2859 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "preferred_width": 20, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/pcsw/NotesByPerson/company", "method": "GET" }) }), "pageSize": 20, "emptyText": "Organisation ausw\u00e4hlen..." });
    var id2860 = new Ext.form.NumberField({ "selectOnFocus": true });
    var owner_type2861 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/pcsw/NotesByPerson/owner_type", "method": "GET" }) }), "pageSize": 20, "emptyText": "Inhaltstyp ausw\u00e4hlen..." });
    var owner_id2862 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/pcsw/NotesByPerson/owner_id", "method": "GET" }) }) });
    var build_time2863 = new Ext.form.DisplayField({ "disabled": true, "value": "<br>" });
    var contact_person2864 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "preferred_width": 20, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/pcsw/NotesByPerson/contact_person", "method": "GET" }) }), "pageSize": 20, "emptyText": "Person ausw\u00e4hlen..." });
    var contact_role2865 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/pcsw/NotesByPerson/contact_role", "method": "GET" }) }), "pageSize": 20, "emptyText": "Funktion ausw\u00e4hlen..." });
    var language2866 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "allowBlank": false, "store": [ [ "en", "Englisch" ], [ "fr", "Franz\u00f6sisch" ], [ "de", "Deutsch" ], [ "nl", "Niederl\u00e4ndisch" ] ] });
    var owner_disp2867 = new Ext.form.DisplayField({ "disabled": true });
    this.before_row_edit = function(record) {
      body2857.refresh();
      owner_id2862.setContextValue('owner_type',record ? record.data['owner_typeHidden'] : undefined);
      contact_person2864.setContextValue('company',record ? record.data['companyHidden'] : undefined);
    };
    this.onRender = function(ct, position) {
      owner_type2861.on('change',Lino.chooser_handler(owner_id2862,'owner_type'));
      company2859.on('change',Lino.chooser_handler(contact_person2864,'company'));
      Lino.pcsw.NotesByPerson.GridPanel.superclass.onRender.call(this, ct, position);
    }
    this.ls_columns = [ { "colIndex": 0, "sortable": true, "xtype": "datecolumn", "format": "d.m.Y", "editable": true, "tooltip": "(pcsw.NotesByPerson.date) ", "filter": { "type": "date", "dateFormat": "d.m.Y" }, "header": "Datum", "dataIndex": "date", "width": Lino.chars2width(9), "editor": date2853 }, { "colIndex": 1, "sortable": true, "header": "Ereignisart (Form)", "editable": true, "tooltip": "(pcsw.NotesByPerson.event_type) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "event_type", "editor": event_type2854 }, { "colIndex": 2, "sortable": true, "header": "Notizart (Inhalt)", "editable": true, "tooltip": "(pcsw.NotesByPerson.type) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "type", "editor": type2855 }, { "colIndex": 3, "sortable": true, "header": "Betreff", "editable": true, "tooltip": "(pcsw.NotesByPerson.subject) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "subject", "editor": subject2856 }, { "colIndex": 4, "sortable": false, "header": "body", "editable": true, "tooltip": "(pcsw.NotesByPerson.body) ", "filter": { "type": "string" }, "width": Lino.chars2width(61), "renderer": Lino.text_renderer, "editor": body2857, "dataIndex": "body" }, { "colIndex": 5, "sortable": true, "header": "Autor", "editable": true, "tooltip": "(pcsw.NotesByPerson.user) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "user", "editor": user2858 }, { "colIndex": 6, "sortable": true, "header": "Empf\u00e4nger (Organisation)", "editable": true, "tooltip": "(pcsw.NotesByPerson.company) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "company", "editor": company2859 }, new Lino.NullNumberColumn({ "colIndex": 7, "sortable": true, "format": "0", "editable": true, "tooltip": "(pcsw.NotesByPerson.id) ", "filter": { "type": "numeric" }, "header": "ID", "renderer": Lino.id_renderer, "editor": id2860, "width": Lino.chars2width(6), "dataIndex": "id" }), { "colIndex": 8, "sortable": true, "header": "Verkn\u00fcpft mit (Modell)", "editable": true, "tooltip": "(pcsw.NotesByPerson.owner_type) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "owner_type", "editor": owner_type2861 }, { "colIndex": 9, "sortable": true, "header": "Verkn\u00fcpft mit (Objekt)", "editable": true, "tooltip": "(pcsw.NotesByPerson.owner_id) ", "filter": { "type": "string" }, "width": Lino.chars2width(11), "dataIndex": "owner_id", "editor": owner_id2862 }, { "width": Lino.chars2width(17), "colIndex": 10, "sortable": true, "dataIndex": "build_time", "header": "Druckdatum", "editable": false, "tooltip": "(pcsw.NotesByPerson.build_time) " }, { "colIndex": 11, "sortable": true, "header": "Empf\u00e4nger (Person)", "editable": true, "tooltip": "(pcsw.NotesByPerson.contact_person) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "contact_person", "editor": contact_person2864 }, { "colIndex": 12, "sortable": true, "header": "in seiner Eigenschaft als", "editable": true, "tooltip": "(pcsw.NotesByPerson.contact_role) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "contact_role", "editor": contact_role2865 }, { "colIndex": 13, "sortable": true, "header": "Sprache", "editable": true, "tooltip": "(pcsw.NotesByPerson.language) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "language", "editor": language2866 }, { "width": Lino.chars2width(11), "colIndex": 14, "sortable": false, "dataIndex": "owner", "header": "Verkn\u00fcpft mit", "editable": false, "tooltip": "(pcsw.NotesByPerson.owner) " } ];
    Lino.pcsw.NotesByPerson.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.pcsw.NotesByPerson.put = function(rp,pk) { 
  Lino.run_row_action(rp,"/pcsw/NotesByPerson","GET",pk,"put",null);
};
Lino.pcsw.NotesByPerson.post = function(rp,pk) { 
  Lino.run_row_action(rp,"/pcsw/NotesByPerson","GET",pk,"post",null);
};

Lino.pcsw.NotesByPerson.insertPanel = Ext.extend(Lino.pcsw.NotesByPerson.InsertFormPanel,{
  empty_title: "Neu Ereignisse/Notizen",
  hide_navigator: true,
  ls_bbar_actions: [ { "itemId": "post", "menu_item_text": "Erstellen", "tooltip": "Datensatz erstellen und dann im Detail-Fenster \u00f6ffnen", "panel_btn_handler": function(panel){panel.save(null,true,'post')}, "text": "Erstellen", "overflowText": "Erstellen", "auto_save": false }, { "itemId": "poststay", "menu_item_text": "Erstellen ohne Detail", "tooltip": "Nach Erstellen des Datensatzes kein Detail-Fenster \u00f6ffnen", "panel_btn_handler": function(panel){panel.save(null,false,'poststay')}, "text": "Erstellen ohne Detail", "overflowText": "Erstellen ohne Detail", "auto_save": false } ],
  ls_url: "/pcsw/NotesByPerson",
  action_name: "insert",
  initComponent : function() {
    this.ls_detail_handler = Lino.pcsw.NotesByPerson.detail;
    this.ls_insert_handler = Lino.pcsw.NotesByPerson.insert;
    Lino.pcsw.NotesByPerson.insertPanel.superclass.initComponent.call(this);
  }
});

Lino.pcsw.NotesByPerson.insert = new Lino.WindowAction({ "draggable": true, "width": Lino.chars2width(60), "autoHeight": true, "maximizable": true, "modal": true, "maximized": false },function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.pcsw.NotesByPerson.insertPanel(p);
});
Lino.pcsw.NotesByPerson.poststay = function(rp,pk) { 
  Lino.run_row_action(rp,"/pcsw/NotesByPerson","GET",pk,"poststay",null);
};
Lino.pcsw.NotesByPerson.duplicate = function(rp,pk) { 
  Lino.run_row_action(rp,"/pcsw/NotesByPerson","GET",pk,"duplicate",null);
};

Lino.pcsw.NotesByPerson.detailPanel = Ext.extend(Lino.pcsw.NotesByPerson.DetailFormPanel,{
  empty_title: "Detail Ereignisse/Notizen",
  ls_bbar_actions: [ { "itemId": "put", "menu_item_text": "Speichern", "tooltip": "\u00c4nderungen in diesem Formular speichern", "panel_btn_handler": function(panel){panel.save(null,false,'put')}, "iconCls": "x-tbar-save", "overflowText": "Speichern", "auto_save": false }, { "itemId": "insert", "menu_item_text": "Neu", "must_save": true, "tooltip": "Neuen Datensatz erstellen", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-new", "overflowText": "Neu", "auto_save": true }, { "itemId": "duplicate", "menu_item_text": "Duplizieren", "must_save": true, "tooltip": "Duplizieren", "panel_btn_handler": Lino.row_action_handler('duplicate','GET',null), "iconCls": "x-tbar-duplicate", "overflowText": "Duplizieren", "auto_save": true }, { "itemId": null, "menu_item_text": "L\u00f6schen", "tooltip": "Diesen Datensatz l\u00f6schen", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "L\u00f6schen", "auto_save": false }, { "itemId": "do_print", "menu_item_text": "Drucken", "must_save": true, "tooltip": "Drucken", "panel_btn_handler": Lino.row_action_handler('do_print','GET',null), "iconCls": "x-tbar-print", "overflowText": "Drucken", "auto_save": true }, { "itemId": "do_clear_cache", "menu_item_text": "Cache l\u00f6schen", "must_save": true, "tooltip": "Cache l\u00f6schen", "panel_btn_handler": Lino.row_action_handler('do_clear_cache','GET',null), "iconCls": "x-tbar-clearcache", "overflowText": "Cache l\u00f6schen", "auto_save": true }, { "itemId": "create_mail", "menu_item_text": "per E-Mail", "must_save": true, "tooltip": "Create an email from this", "panel_btn_handler": Lino.row_action_handler('create_mail','GET',null), "iconCls": "x-tbar-email_add", "overflowText": "per E-Mail", "auto_save": true } ],
  ls_url: "/pcsw/NotesByPerson",
  action_name: "detail",
  initComponent : function() {
    this.ls_detail_handler = Lino.pcsw.NotesByPerson.detail;
    this.ls_insert_handler = Lino.pcsw.NotesByPerson.insert;
    Lino.pcsw.NotesByPerson.detailPanel.superclass.initComponent.call(this);
  }
});

Lino.pcsw.NotesByPerson.detail = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.pcsw.NotesByPerson.detailPanel(p);
});
Lino.pcsw.NotesByPerson.do_print = function(rp,pk) { 
  Lino.run_row_action(rp,"/pcsw/NotesByPerson","GET",pk,"do_print",null);
};
Lino.pcsw.NotesByPerson.do_clear_cache = function(rp,pk) { 
  Lino.run_row_action(rp,"/pcsw/NotesByPerson","GET",pk,"do_clear_cache",null);
};
Lino.pcsw.NotesByPerson.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.pcsw.NotesByPerson.GridPanel(p);
});
Lino.pcsw.NotesByPerson.create_mail = function(rp,pk) { 
  Lino.run_row_action(rp,"/pcsw/NotesByPerson","GET",pk,"create_mail",null);
};

// js_render_GridPanel_class pcsw.NotesByCompany
Lino.pcsw.NotesByCompany.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "Keine Daten anzuzeigen." },
  ls_url : "/pcsw/NotesByCompany",
  ls_bbar_actions : [ { "itemId": "insert", "menu_item_text": "Neu", "must_save": true, "tooltip": "Neuen Datensatz erstellen", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-new", "overflowText": "Neu", "auto_save": true }, { "itemId": "duplicate", "menu_item_text": "Duplizieren", "must_save": true, "tooltip": "Duplizieren", "panel_btn_handler": Lino.row_action_handler('duplicate','GET',null), "iconCls": "x-tbar-duplicate", "overflowText": "Duplizieren", "auto_save": true }, { "itemId": "detail", "menu_item_text": "Detail", "tooltip": "Detail-Fenster auf diesem Datensatz \u00f6ffnen", "panel_btn_handler": Lino.show_detail, "iconCls": "x-tbar-detail", "overflowText": "Detail", "auto_save": true }, { "itemId": null, "menu_item_text": "L\u00f6schen", "tooltip": "Diesen Datensatz l\u00f6schen", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "L\u00f6schen", "auto_save": false }, { "itemId": "do_print", "menu_item_text": "Drucken", "must_save": true, "tooltip": "Drucken", "panel_btn_handler": Lino.row_action_handler('do_print','GET',null), "iconCls": "x-tbar-print", "overflowText": "Drucken", "auto_save": true }, { "itemId": "do_clear_cache", "menu_item_text": "Cache l\u00f6schen", "must_save": true, "tooltip": "Cache l\u00f6schen", "panel_btn_handler": Lino.row_action_handler('do_clear_cache','GET',null), "iconCls": "x-tbar-clearcache", "overflowText": "Cache l\u00f6schen", "auto_save": true }, { "itemId": "create_mail", "menu_item_text": "per E-Mail", "must_save": true, "tooltip": "Create an email from this", "panel_btn_handler": Lino.row_action_handler('create_mail','GET',null), "iconCls": "x-tbar-email_add", "overflowText": "per E-Mail", "auto_save": true } ],
  title : "Ereignisse/Notizen",
  page_length : 20,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "type": "date", "name": "date", "dateFormat": "d.m.Y" }, { "name": "project" }, 'projectHidden', { "name": "event_type" }, 'event_typeHidden', { "name": "type" }, 'typeHidden', { "name": "subject" }, { "name": "body" }, { "name": "user" }, 'userHidden', { "type": "int", "name": "id" }, { "name": "owner_type" }, 'owner_typeHidden', { "name": "owner_id" }, 'owner_idHidden', { "name": "build_time" }, { "name": "contact_person" }, 'contact_personHidden', { "name": "contact_role" }, 'contact_roleHidden', { "name": "language" }, 'languageHidden', { "name": "owner" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 11,
  ls_grid_configs : [  ],
  content_type : 93,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 25,
  initComponent : function() {
    this.ls_detail_handler = Lino.pcsw.NotesByCompany.detail;
    this.ls_insert_handler = Lino.pcsw.NotesByCompany.insert;
    var ww = this.containing_window;
    var date898 = new Lino.DateField({ "selectOnFocus": true, "allowBlank": false });
    var project899 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "preferred_width": 20, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/pcsw/NotesByCompany/project", "method": "GET" }) }), "pageSize": 20, "emptyText": "Klient ausw\u00e4hlen..." });
    var event_type900 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/pcsw/NotesByCompany/event_type", "method": "GET" }) }), "pageSize": 20, "emptyText": "Event Type ausw\u00e4hlen..." });
    var type901 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/pcsw/NotesByCompany/type", "method": "GET" }) }), "pageSize": 20, "emptyText": "Notizart ausw\u00e4hlen..." });
    var subject902 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var body903 = new Lino.RichTextPanel({ "selectOnFocus": true, "containing_panel": this, "title": "Inhalt" });
    var user904 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "preferred_width": 15, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/pcsw/NotesByCompany/user", "method": "GET" }) }), "pageSize": 20, "emptyText": "Benutzer ausw\u00e4hlen..." });
    var id905 = new Ext.form.NumberField({ "selectOnFocus": true });
    var owner_type906 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/pcsw/NotesByCompany/owner_type", "method": "GET" }) }), "pageSize": 20, "emptyText": "Inhaltstyp ausw\u00e4hlen..." });
    var owner_id907 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/pcsw/NotesByCompany/owner_id", "method": "GET" }) }) });
    var build_time908 = new Ext.form.DisplayField({ "disabled": true, "value": "<br>" });
    var contact_person909 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "preferred_width": 20, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/pcsw/NotesByCompany/contact_person", "method": "GET" }) }), "pageSize": 20, "emptyText": "Person ausw\u00e4hlen..." });
    var contact_role910 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/pcsw/NotesByCompany/contact_role", "method": "GET" }) }), "pageSize": 20, "emptyText": "Funktion ausw\u00e4hlen..." });
    var language911 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "allowBlank": false, "store": [ [ "en", "Englisch" ], [ "fr", "Franz\u00f6sisch" ], [ "de", "Deutsch" ], [ "nl", "Niederl\u00e4ndisch" ] ] });
    var owner_disp912 = new Ext.form.DisplayField({ "disabled": true });
    this.before_row_edit = function(record) {
      body903.refresh();
      owner_id907.setContextValue('owner_type',record ? record.data['owner_typeHidden'] : undefined);
      var bp = this.get_base_params();
      contact_person909.setContextValue('mk',bp['mk']);
      contact_person909.setContextValue('mt',bp['mt']);
    };
    this.onRender = function(ct, position) {
      owner_type906.on('change',Lino.chooser_handler(owner_id907,'owner_type'));
      Lino.pcsw.NotesByCompany.GridPanel.superclass.onRender.call(this, ct, position);
    }
    this.ls_columns = [ { "colIndex": 0, "sortable": true, "xtype": "datecolumn", "format": "d.m.Y", "editable": true, "tooltip": "(pcsw.NotesByCompany.date) ", "filter": { "type": "date", "dateFormat": "d.m.Y" }, "header": "Datum", "dataIndex": "date", "width": Lino.chars2width(9), "editor": date898 }, { "colIndex": 1, "sortable": true, "header": "Klient", "editable": true, "tooltip": "(pcsw.NotesByCompany.project) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "project", "editor": project899 }, { "colIndex": 2, "sortable": true, "header": "Ereignisart (Form)", "editable": true, "tooltip": "(pcsw.NotesByCompany.event_type) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "event_type", "editor": event_type900 }, { "colIndex": 3, "sortable": true, "header": "Notizart (Inhalt)", "editable": true, "tooltip": "(pcsw.NotesByCompany.type) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "type", "editor": type901 }, { "colIndex": 4, "sortable": true, "header": "Betreff", "editable": true, "tooltip": "(pcsw.NotesByCompany.subject) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "subject", "editor": subject902 }, { "colIndex": 5, "sortable": false, "header": "body", "editable": true, "tooltip": "(pcsw.NotesByCompany.body) ", "filter": { "type": "string" }, "width": Lino.chars2width(61), "renderer": Lino.text_renderer, "editor": body903, "dataIndex": "body" }, { "colIndex": 6, "sortable": true, "header": "Autor", "editable": true, "tooltip": "(pcsw.NotesByCompany.user) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "user", "editor": user904 }, new Lino.NullNumberColumn({ "colIndex": 7, "sortable": true, "format": "0", "editable": true, "tooltip": "(pcsw.NotesByCompany.id) ", "filter": { "type": "numeric" }, "header": "ID", "renderer": Lino.id_renderer, "editor": id905, "width": Lino.chars2width(6), "dataIndex": "id" }), { "colIndex": 8, "sortable": true, "header": "Verkn\u00fcpft mit (Modell)", "editable": true, "tooltip": "(pcsw.NotesByCompany.owner_type) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "owner_type", "editor": owner_type906 }, { "colIndex": 9, "sortable": true, "header": "Verkn\u00fcpft mit (Objekt)", "editable": true, "tooltip": "(pcsw.NotesByCompany.owner_id) ", "filter": { "type": "string" }, "width": Lino.chars2width(11), "dataIndex": "owner_id", "editor": owner_id907 }, { "width": Lino.chars2width(17), "colIndex": 10, "sortable": true, "dataIndex": "build_time", "header": "Druckdatum", "editable": false, "tooltip": "(pcsw.NotesByCompany.build_time) " }, { "colIndex": 11, "sortable": true, "header": "Empf\u00e4nger (Person)", "editable": true, "tooltip": "(pcsw.NotesByCompany.contact_person) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "contact_person", "editor": contact_person909 }, { "colIndex": 12, "sortable": true, "header": "in seiner Eigenschaft als", "editable": true, "tooltip": "(pcsw.NotesByCompany.contact_role) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "contact_role", "editor": contact_role910 }, { "colIndex": 13, "sortable": true, "header": "Sprache", "editable": true, "tooltip": "(pcsw.NotesByCompany.language) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "language", "editor": language911 }, { "width": Lino.chars2width(11), "colIndex": 14, "sortable": false, "dataIndex": "owner", "header": "Verkn\u00fcpft mit", "editable": false, "tooltip": "(pcsw.NotesByCompany.owner) " } ];
    Lino.pcsw.NotesByCompany.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.pcsw.NotesByCompany.put = function(rp,pk) { 
  Lino.run_row_action(rp,"/pcsw/NotesByCompany","GET",pk,"put",null);
};
Lino.pcsw.NotesByCompany.post = function(rp,pk) { 
  Lino.run_row_action(rp,"/pcsw/NotesByCompany","GET",pk,"post",null);
};

Lino.pcsw.NotesByCompany.insertPanel = Ext.extend(Lino.pcsw.NotesByPerson.InsertFormPanel,{
  empty_title: "Neu Ereignisse/Notizen",
  hide_navigator: true,
  ls_bbar_actions: [ { "itemId": "post", "menu_item_text": "Erstellen", "tooltip": "Datensatz erstellen und dann im Detail-Fenster \u00f6ffnen", "panel_btn_handler": function(panel){panel.save(null,true,'post')}, "text": "Erstellen", "overflowText": "Erstellen", "auto_save": false }, { "itemId": "poststay", "menu_item_text": "Erstellen ohne Detail", "tooltip": "Nach Erstellen des Datensatzes kein Detail-Fenster \u00f6ffnen", "panel_btn_handler": function(panel){panel.save(null,false,'poststay')}, "text": "Erstellen ohne Detail", "overflowText": "Erstellen ohne Detail", "auto_save": false } ],
  ls_url: "/pcsw/NotesByCompany",
  action_name: "insert",
  initComponent : function() {
    this.ls_detail_handler = Lino.pcsw.NotesByCompany.detail;
    this.ls_insert_handler = Lino.pcsw.NotesByCompany.insert;
    Lino.pcsw.NotesByCompany.insertPanel.superclass.initComponent.call(this);
  }
});

Lino.pcsw.NotesByCompany.insert = new Lino.WindowAction({ "draggable": true, "width": Lino.chars2width(60), "autoHeight": true, "maximizable": true, "modal": true, "maximized": false },function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.pcsw.NotesByCompany.insertPanel(p);
});
Lino.pcsw.NotesByCompany.poststay = function(rp,pk) { 
  Lino.run_row_action(rp,"/pcsw/NotesByCompany","GET",pk,"poststay",null);
};
Lino.pcsw.NotesByCompany.duplicate = function(rp,pk) { 
  Lino.run_row_action(rp,"/pcsw/NotesByCompany","GET",pk,"duplicate",null);
};

Lino.pcsw.NotesByCompany.detailPanel = Ext.extend(Lino.pcsw.NotesByPerson.DetailFormPanel,{
  empty_title: "Detail Ereignisse/Notizen",
  ls_bbar_actions: [ { "itemId": "put", "menu_item_text": "Speichern", "tooltip": "\u00c4nderungen in diesem Formular speichern", "panel_btn_handler": function(panel){panel.save(null,false,'put')}, "iconCls": "x-tbar-save", "overflowText": "Speichern", "auto_save": false }, { "itemId": "insert", "menu_item_text": "Neu", "must_save": true, "tooltip": "Neuen Datensatz erstellen", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-new", "overflowText": "Neu", "auto_save": true }, { "itemId": "duplicate", "menu_item_text": "Duplizieren", "must_save": true, "tooltip": "Duplizieren", "panel_btn_handler": Lino.row_action_handler('duplicate','GET',null), "iconCls": "x-tbar-duplicate", "overflowText": "Duplizieren", "auto_save": true }, { "itemId": null, "menu_item_text": "L\u00f6schen", "tooltip": "Diesen Datensatz l\u00f6schen", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "L\u00f6schen", "auto_save": false }, { "itemId": "do_print", "menu_item_text": "Drucken", "must_save": true, "tooltip": "Drucken", "panel_btn_handler": Lino.row_action_handler('do_print','GET',null), "iconCls": "x-tbar-print", "overflowText": "Drucken", "auto_save": true }, { "itemId": "do_clear_cache", "menu_item_text": "Cache l\u00f6schen", "must_save": true, "tooltip": "Cache l\u00f6schen", "panel_btn_handler": Lino.row_action_handler('do_clear_cache','GET',null), "iconCls": "x-tbar-clearcache", "overflowText": "Cache l\u00f6schen", "auto_save": true }, { "itemId": "create_mail", "menu_item_text": "per E-Mail", "must_save": true, "tooltip": "Create an email from this", "panel_btn_handler": Lino.row_action_handler('create_mail','GET',null), "iconCls": "x-tbar-email_add", "overflowText": "per E-Mail", "auto_save": true } ],
  ls_url: "/pcsw/NotesByCompany",
  action_name: "detail",
  initComponent : function() {
    this.ls_detail_handler = Lino.pcsw.NotesByCompany.detail;
    this.ls_insert_handler = Lino.pcsw.NotesByCompany.insert;
    Lino.pcsw.NotesByCompany.detailPanel.superclass.initComponent.call(this);
  }
});

Lino.pcsw.NotesByCompany.detail = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.pcsw.NotesByCompany.detailPanel(p);
});
Lino.pcsw.NotesByCompany.do_print = function(rp,pk) { 
  Lino.run_row_action(rp,"/pcsw/NotesByCompany","GET",pk,"do_print",null);
};
Lino.pcsw.NotesByCompany.do_clear_cache = function(rp,pk) { 
  Lino.run_row_action(rp,"/pcsw/NotesByCompany","GET",pk,"do_clear_cache",null);
};
Lino.pcsw.NotesByCompany.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.pcsw.NotesByCompany.GridPanel(p);
});
Lino.pcsw.NotesByCompany.create_mail = function(rp,pk) { 
  Lino.run_row_action(rp,"/pcsw/NotesByCompany","GET",pk,"create_mail",null);
};

// js_render_GridPanel_class reception.CoachingsByClient
Lino.reception.CoachingsByClient.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "forceFit": true, "emptyText": "Keine Daten anzuzeigen." },
  ls_url : "/reception/CoachingsByClient",
  ls_bbar_actions : [ { "itemId": null, "menu_item_text": "L\u00f6schen", "tooltip": "Diesen Datensatz l\u00f6schen", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "L\u00f6schen", "auto_save": false }, { "itemId": "create_visit", "menu_item_text": "Create visit", "tooltip": "Create a prompt event for this client with this coach.", "panel_btn_handler": Lino.param_action_handler(Lino.pcsw.Coachings.create_visit), "text": "Create visit", "overflowText": "Create visit", "auto_save": true } ],
  title : "Begleiter",
  page_length : 20,
  params_panel_hidden : true,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "name": "user" }, 'userHidden', { "type": "boolean", "name": "primary" }, { "name": "type" }, 'typeHidden', { "name": "actions" }, { "type": "int", "name": "id" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 6,
  ls_grid_configs : [  ],
  content_type : 51,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 8,
  initComponent : function() {
    var ww = this.containing_window;
    var user3077 = new Lino.RemoteComboFieldElement({ "preferred_width": 15, "allowBlank": false, "pageSize": 20, "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/reception/CoachingsByClient/user", "method": "GET" }) }), "emptyText": "Benutzer ausw\u00e4hlen..." });
    var primary3078 = new Ext.form.Checkbox({ "selectOnFocus": true, "checked": false });
    var type3079 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/reception/CoachingsByClient/type", "method": "GET" }) }), "pageSize": 20, "emptyText": "Dienst ausw\u00e4hlen..." });
    var actions_disp3080 = new Ext.form.DisplayField({ "disabled": true, "value": "<br/>", "always_enabled": true });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ { "colIndex": 0, "sortable": true, "header": "Begleiter", "editable": true, "tooltip": "(reception.CoachingsByClient.user) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "user", "editor": user3077 }, { "colIndex": 1, "sortable": false, "xtype": "checkcolumn", "header": "Prim\u00e4r", "editable": true, "tooltip": "(reception.CoachingsByClient.primary) There's at most one primary coach per client. \nEnabling this field will automatically make the other coachings non-primary.", "filter": { "type": "boolean" }, "width": Lino.chars2width(11), "dataIndex": "primary" }, { "colIndex": 2, "sortable": true, "header": "Dienst", "editable": true, "tooltip": "(reception.CoachingsByClient.type) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "type", "editor": type3079 }, { "width": Lino.chars2width(31), "colIndex": 3, "sortable": false, "dataIndex": "actions", "header": "Actions", "editable": false, "tooltip": "(reception.CoachingsByClient.actions) " } ];
    Lino.reception.CoachingsByClient.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.reception.CoachingsByClient.put = function(rp,pk) { 
  Lino.run_row_action(rp,"/reception/CoachingsByClient","GET",pk,"put",null);
};
Lino.reception.CoachingsByClient.post = function(rp,pk) { 
  Lino.run_row_action(rp,"/reception/CoachingsByClient","GET",pk,"post",null);
};
Lino.reception.CoachingsByClient.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  p.params_panel = new Lino.pcsw.CoachingsByClient.ParamsPanel({});
  return new Lino.reception.CoachingsByClient.GridPanel(p);
});

// js_render_GridPanel_class accounts.AccountsByGroup
Lino.accounts.AccountsByGroup.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "Keine Daten anzuzeigen." },
  ls_url : "/accounts/AccountsByGroup",
  ls_bbar_actions : [ { "itemId": "duplicate", "menu_item_text": "Duplizieren", "must_save": true, "tooltip": "Duplizieren", "panel_btn_handler": Lino.row_action_handler('duplicate','GET',null), "iconCls": "x-tbar-duplicate", "overflowText": "Duplizieren", "auto_save": true }, { "itemId": null, "menu_item_text": "L\u00f6schen", "tooltip": "Diesen Datensatz l\u00f6schen", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "L\u00f6schen", "auto_save": false }, { "itemId": "move_up", "menu_item_text": "Rauf", "must_save": true, "tooltip": "Move this row one row upwards", "panel_btn_handler": Lino.row_action_handler('move_up','GET',null), "iconCls": "x-tbar-moveup", "overflowText": "Rauf", "auto_save": true }, { "itemId": "move_down", "menu_item_text": "Down", "must_save": true, "tooltip": "Move this row one row downwards", "panel_btn_handler": Lino.row_action_handler('move_down','GET',null), "iconCls": "x-tbar-movedown", "overflowText": "Down", "auto_save": true } ],
  title : "Konten",
  page_length : 20,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "name": "ref" }, { "name": "name" }, { "name": "name_fr" }, { "name": "name_de" }, { "name": "name_nl" }, { "name": "default_amount" }, { "name": "periods" }, { "type": "boolean", "name": "required_for_household" }, { "type": "boolean", "name": "required_for_person" }, { "name": "group" }, 'groupHidden', { "type": "int", "name": "id" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 11,
  ls_grid_configs : [  ],
  content_type : 42,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 13,
  initComponent : function() {
    var ww = this.containing_window;
    var ref3158 = new Ext.form.TextField({ "selectOnFocus": true, "boxMinWidth": Lino.chars2width(5), "maxLength": 5 });
    var name3159 = new Ext.form.TextField({ "selectOnFocus": true, "allowBlank": false, "maxLength": 200 });
    var name_fr3160 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var name_de3161 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var name_nl3162 = new Ext.form.TextField({ "selectOnFocus": true, "hidden": true, "maxLength": 200 });
    var default_amount3163 = new Ext.form.NumberField({ "selectOnFocus": true, "decimalPrecision": 2, "allowBlank": true, "decimalSeparator": "," });
    var periods3164 = new Ext.form.NumberField({ "selectOnFocus": true, "allowBlank": true, "value": 1, "allowDecimals": false });
    var required_for_household3165 = new Ext.form.Checkbox({ "selectOnFocus": true, "checked": false });
    var required_for_person3166 = new Ext.form.Checkbox({ "selectOnFocus": true, "checked": false });
    var group3167 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/accounts/AccountsByGroup/group", "method": "GET" }) }), "allowBlank": false, "pageSize": 20, "emptyText": "Kontengruppe ausw\u00e4hlen..." });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ { "colIndex": 0, "sortable": true, "header": "ref", "editable": true, "tooltip": "(accounts.AccountsByGroup.ref) ", "filter": { "type": "string" }, "width": Lino.chars2width(7), "dataIndex": "ref", "editor": ref3158 }, { "colIndex": 1, "sortable": true, "header": "Bezeichnung", "editable": true, "tooltip": "(accounts.AccountsByGroup.name) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "name", "editor": name3159 }, { "colIndex": 2, "sortable": true, "header": "Bezeichnung (fr)", "editable": true, "tooltip": "(accounts.AccountsByGroup.name_fr) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "name_fr", "editor": name_fr3160 }, { "colIndex": 3, "sortable": true, "header": "Bezeichnung (de)", "editable": true, "tooltip": "(accounts.AccountsByGroup.name_de) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "name_de", "editor": name_de3161 }, { "colIndex": 4, "sortable": true, "header": "Bezeichnung (nl)", "editable": true, "tooltip": "(accounts.AccountsByGroup.name_nl) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "name_nl", "hidden": true, "editor": name_nl3162 }, new Lino.NullNumberColumn({ "colIndex": 5, "sortable": true, "header": "Standard-Betrag", "editable": true, "tooltip": "(accounts.AccountsByGroup.default_amount) ", "filter": { "type": "numeric" }, "width": Lino.chars2width(13), "dataIndex": "default_amount", "editor": default_amount3163 }), new Lino.NullNumberColumn({ "colIndex": 6, "sortable": true, "format": "0/i", "editable": true, "tooltip": "(accounts.AccountsByGroup.periods) For how many months the entered amount counts. \nFor example 1 means a monthly amount, 12 a yearly amount.", "filter": { "type": "numeric" }, "header": "Perioden", "dataIndex": "periods", "width": Lino.chars2width(6), "editor": periods3164 }), { "colIndex": 7, "sortable": false, "xtype": "checkcolumn", "header": "verpflichtend f\u00fcr Haushalte", "editable": true, "tooltip": "(accounts.AccountsByGroup.required_for_household) ", "filter": { "type": "boolean" }, "width": Lino.chars2width(11), "dataIndex": "required_for_household" }, { "colIndex": 8, "sortable": false, "xtype": "checkcolumn", "header": "verpflichtend f\u00fcr Personen", "editable": true, "tooltip": "(accounts.AccountsByGroup.required_for_person) ", "filter": { "type": "boolean" }, "width": Lino.chars2width(11), "dataIndex": "required_for_person" }, { "colIndex": 9, "sortable": true, "header": "Kontengruppe", "editable": true, "tooltip": "(accounts.AccountsByGroup.group) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "group", "editor": group3167 } ];
    Lino.accounts.AccountsByGroup.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.accounts.AccountsByGroup.put = function(rp,pk) { 
  Lino.run_row_action(rp,"/accounts/AccountsByGroup","GET",pk,"put",null);
};
Lino.accounts.AccountsByGroup.post = function(rp,pk) { 
  Lino.run_row_action(rp,"/accounts/AccountsByGroup","GET",pk,"post",null);
};
Lino.accounts.AccountsByGroup.duplicate = function(rp,pk) { 
  Lino.run_row_action(rp,"/accounts/AccountsByGroup","GET",pk,"duplicate",null);
};
Lino.accounts.AccountsByGroup.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.accounts.AccountsByGroup.GridPanel(p);
});
Lino.accounts.AccountsByGroup.move_up = function(rp,pk) { 
  Lino.run_row_action(rp,"/accounts/AccountsByGroup","GET",pk,"move_up",null);
};
Lino.accounts.AccountsByGroup.move_down = function(rp,pk) { 
  Lino.run_row_action(rp,"/accounts/AccountsByGroup","GET",pk,"move_down",null);
};

// js_render_GridPanel_class newcomers.CompetencesByUser
Lino.newcomers.CompetencesByUser.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "Keine Daten anzuzeigen." },
  ls_url : "/newcomers/CompetencesByUser",
  ls_bbar_actions : [ { "itemId": "duplicate", "menu_item_text": "Duplizieren", "must_save": true, "tooltip": "Duplizieren", "panel_btn_handler": Lino.row_action_handler('duplicate','GET',null), "iconCls": "x-tbar-duplicate", "overflowText": "Duplizieren", "auto_save": true }, { "itemId": null, "menu_item_text": "L\u00f6schen", "tooltip": "Diesen Datensatz l\u00f6schen", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "L\u00f6schen", "auto_save": false }, { "itemId": "move_up", "menu_item_text": "Rauf", "must_save": true, "tooltip": "Move this row one row upwards", "panel_btn_handler": Lino.row_action_handler('move_up','GET',null), "iconCls": "x-tbar-moveup", "overflowText": "Rauf", "auto_save": true }, { "itemId": "move_down", "menu_item_text": "Down", "must_save": true, "tooltip": "Move this row one row downwards", "panel_btn_handler": Lino.row_action_handler('move_down','GET',null), "iconCls": "x-tbar-movedown", "overflowText": "Down", "auto_save": true } ],
  title : "Kompetenzen",
  page_length : 20,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "type": "int", "name": "seqno" }, { "name": "faculty" }, 'facultyHidden', { "type": "int", "name": "weight" }, { "type": "int", "name": "id" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 4,
  ls_grid_configs : [  ],
  content_type : 82,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 6,
  initComponent : function() {
    var ww = this.containing_window;
    var seqno360 = new Ext.form.NumberField({ "selectOnFocus": true });
    var faculty361 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/newcomers/CompetencesByUser/faculty", "method": "GET" }) }), "allowBlank": false, "pageSize": 20, "emptyText": "Fachbereich ausw\u00e4hlen..." });
    var weight362 = new Ext.form.NumberField({ "selectOnFocus": true });
    var id363 = new Ext.form.NumberField({ "selectOnFocus": true });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ new Lino.NullNumberColumn({ "colIndex": 0, "sortable": true, "format": "0", "editable": true, "tooltip": "(newcomers.CompetencesByUser.seqno) ", "filter": { "type": "numeric" }, "header": "Seq.-Nr.", "dataIndex": "seqno", "width": Lino.chars2width(6), "editor": seqno360 }), { "colIndex": 1, "sortable": true, "header": "Fachbereich", "editable": true, "tooltip": "(newcomers.CompetencesByUser.faculty) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "faculty", "editor": faculty361 }, new Lino.NullNumberColumn({ "colIndex": 2, "sortable": true, "format": "0", "editable": true, "tooltip": "(newcomers.CompetencesByUser.weight) Wieviel Aufwand mir pers\u00f6nlich ein Neuantrag in diesem Fachbereich verursacht\n(0 = gar kein Aufwand, 10 = maximaler Aufwand).", "filter": { "type": "numeric" }, "header": "Aufwand", "dataIndex": "weight", "width": Lino.chars2width(6), "editor": weight362 }), new Lino.NullNumberColumn({ "colIndex": 3, "sortable": true, "format": "0", "editable": true, "tooltip": "(newcomers.CompetencesByUser.id) ", "filter": { "type": "numeric" }, "header": "ID", "renderer": Lino.id_renderer, "editor": id363, "width": Lino.chars2width(6), "dataIndex": "id" }) ];
    Lino.newcomers.CompetencesByUser.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.newcomers.CompetencesByUser.put = function(rp,pk) { 
  Lino.run_row_action(rp,"/newcomers/CompetencesByUser","GET",pk,"put",null);
};
Lino.newcomers.CompetencesByUser.post = function(rp,pk) { 
  Lino.run_row_action(rp,"/newcomers/CompetencesByUser","GET",pk,"post",null);
};
Lino.newcomers.CompetencesByUser.duplicate = function(rp,pk) { 
  Lino.run_row_action(rp,"/newcomers/CompetencesByUser","GET",pk,"duplicate",null);
};
Lino.newcomers.CompetencesByUser.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.newcomers.CompetencesByUser.GridPanel(p);
});
Lino.newcomers.CompetencesByUser.move_up = function(rp,pk) { 
  Lino.run_row_action(rp,"/newcomers/CompetencesByUser","GET",pk,"move_up",null);
};
Lino.newcomers.CompetencesByUser.move_down = function(rp,pk) { 
  Lino.run_row_action(rp,"/newcomers/CompetencesByUser","GET",pk,"move_down",null);
};

// js_render_GridPanel_class newcomers.MyCompetences
Lino.newcomers.MyCompetences.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "Keine Daten anzuzeigen." },
  ls_url : "/newcomers/MyCompetences",
  ls_bbar_actions : [ { "itemId": "duplicate", "menu_item_text": "Duplizieren", "must_save": true, "tooltip": "Duplizieren", "panel_btn_handler": Lino.row_action_handler('duplicate','GET',null), "iconCls": "x-tbar-duplicate", "overflowText": "Duplizieren", "auto_save": true }, { "itemId": null, "menu_item_text": "L\u00f6schen", "tooltip": "Diesen Datensatz l\u00f6schen", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "L\u00f6schen", "auto_save": false }, { "itemId": "move_up", "menu_item_text": "Rauf", "must_save": true, "tooltip": "Move this row one row upwards", "panel_btn_handler": Lino.row_action_handler('move_up','GET',null), "iconCls": "x-tbar-moveup", "overflowText": "Rauf", "auto_save": true }, { "itemId": "move_down", "menu_item_text": "Down", "must_save": true, "tooltip": "Move this row one row downwards", "panel_btn_handler": Lino.row_action_handler('move_down','GET',null), "iconCls": "x-tbar-movedown", "overflowText": "Down", "auto_save": true } ],
  title : "Meine Kompetenzen",
  page_length : 20,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "type": "int", "name": "seqno" }, { "name": "faculty" }, 'facultyHidden', { "type": "int", "name": "weight" }, { "type": "int", "name": "id" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 4,
  ls_grid_configs : [  ],
  content_type : 82,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 6,
  initComponent : function() {
    var ww = this.containing_window;
    var seqno5430 = new Ext.form.NumberField({ "selectOnFocus": true });
    var faculty5431 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/newcomers/MyCompetences/faculty", "method": "GET" }) }), "allowBlank": false, "pageSize": 20, "emptyText": "Fachbereich ausw\u00e4hlen..." });
    var weight5432 = new Ext.form.NumberField({ "selectOnFocus": true });
    var id5433 = new Ext.form.NumberField({ "selectOnFocus": true });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ new Lino.NullNumberColumn({ "colIndex": 0, "sortable": true, "format": "0", "editable": true, "tooltip": "(newcomers.MyCompetences.seqno) ", "filter": { "type": "numeric" }, "header": "Seq.-Nr.", "dataIndex": "seqno", "width": Lino.chars2width(6), "editor": seqno5430 }), { "colIndex": 1, "sortable": true, "header": "Fachbereich", "editable": true, "tooltip": "(newcomers.MyCompetences.faculty) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "faculty", "editor": faculty5431 }, new Lino.NullNumberColumn({ "colIndex": 2, "sortable": true, "format": "0", "editable": true, "tooltip": "(newcomers.MyCompetences.weight) Wieviel Aufwand mir pers\u00f6nlich ein Neuantrag in diesem Fachbereich verursacht\n(0 = gar kein Aufwand, 10 = maximaler Aufwand).", "filter": { "type": "numeric" }, "header": "Aufwand", "dataIndex": "weight", "width": Lino.chars2width(6), "editor": weight5432 }), new Lino.NullNumberColumn({ "colIndex": 3, "sortable": true, "format": "0", "editable": true, "tooltip": "(newcomers.MyCompetences.id) ", "filter": { "type": "numeric" }, "header": "ID", "renderer": Lino.id_renderer, "editor": id5433, "width": Lino.chars2width(6), "dataIndex": "id" }) ];
    Lino.newcomers.MyCompetences.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.newcomers.MyCompetences.put = function(rp,pk) { 
  Lino.run_row_action(rp,"/newcomers/MyCompetences","GET",pk,"put",null);
};
Lino.newcomers.MyCompetences.post = function(rp,pk) { 
  Lino.run_row_action(rp,"/newcomers/MyCompetences","GET",pk,"post",null);
};
Lino.newcomers.MyCompetences.duplicate = function(rp,pk) { 
  Lino.run_row_action(rp,"/newcomers/MyCompetences","GET",pk,"duplicate",null);
};
Lino.newcomers.MyCompetences.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.newcomers.MyCompetences.GridPanel(p);
});
Lino.newcomers.MyCompetences.move_up = function(rp,pk) { 
  Lino.run_row_action(rp,"/newcomers/MyCompetences","GET",pk,"move_up",null);
};
Lino.newcomers.MyCompetences.move_down = function(rp,pk) { 
  Lino.run_row_action(rp,"/newcomers/MyCompetences","GET",pk,"move_down",null);
};

// js_render_GridPanel_class cbss.MyIdentifyPersonRequests
Lino.cbss.MyIdentifyPersonRequests.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "Keine Daten anzuzeigen." },
  ls_url : "/cbss/MyIdentifyPersonRequests",
  ls_bbar_actions : [ { "itemId": "insert", "menu_item_text": "Neu", "must_save": true, "tooltip": "Neuen Datensatz erstellen", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-new", "overflowText": "Neu", "auto_save": true }, { "itemId": "duplicate", "menu_item_text": "Duplizieren", "must_save": true, "tooltip": "Duplizieren", "panel_btn_handler": Lino.row_action_handler('duplicate','GET',null), "iconCls": "x-tbar-duplicate", "overflowText": "Duplizieren", "auto_save": true }, { "itemId": "detail", "menu_item_text": "Detail", "tooltip": "Detail-Fenster auf diesem Datensatz \u00f6ffnen", "panel_btn_handler": Lino.show_detail, "iconCls": "x-tbar-detail", "overflowText": "Detail", "auto_save": true }, { "itemId": null, "menu_item_text": "L\u00f6schen", "tooltip": "Diesen Datensatz l\u00f6schen", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "L\u00f6schen", "auto_save": false }, { "itemId": "do_print", "menu_item_text": "Drucken", "must_save": true, "tooltip": "Drucken", "panel_btn_handler": Lino.row_action_handler('do_print','GET',null), "iconCls": "x-tbar-print", "overflowText": "Drucken", "auto_save": true } ],
  title : "Meine IdentifyPerson-Anfragen",
  page_length : 20,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "type": "int", "name": "id" }, { "name": "person" }, 'personHidden', { "name": "sent" }, { "name": "status" }, 'statusHidden', { "name": "environment" }, { "name": "ticket" }, { "name": "request_xml" }, { "name": "response_xml" }, { "name": "debug_messages" }, { "name": "info_messages" }, { "name": "national_id" }, { "name": "birth_date" }, { "name": "sis_card_no" }, { "name": "id_card_no" }, { "name": "first_name" }, { "name": "last_name" }, { "name": "middle_name" }, { "name": "gender" }, 'genderHidden', { "type": "int", "name": "tolerance" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 0,
  ls_grid_configs : [  ],
  content_type : 92,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 23,
  initComponent : function() {
    this.ls_detail_handler = Lino.cbss.MyIdentifyPersonRequests.detail;
    this.ls_insert_handler = Lino.cbss.MyIdentifyPersonRequests.insert;
    var ww = this.containing_window;
    var id5463 = new Ext.form.NumberField({ "selectOnFocus": true });
    var person5464 = new Lino.RemoteComboFieldElement({ "preferred_width": 20, "allowBlank": false, "pageSize": 20, "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cbss/MyIdentifyPersonRequests/person", "method": "GET" }) }), "emptyText": "Klient ausw\u00e4hlen..." });
    var sent5465 = new Ext.form.DisplayField({ "disabled": true, "value": "<br>" });
    var status5466 = new Lino.ChoicesFieldElement({ "disabled": true, "forceSelection": true, "store": [['','<br>']].concat(Lino.cbss.RequestStates) });
    var environment5467 = new Ext.form.TextField({ "disabled": true, "boxMinWidth": Lino.chars2width(4), "maxLength": 4 });
    var ticket5468 = new Ext.form.TextField({ "disabled": true, "maxLength": 36 });
    var request_xml5469 = new Ext.form.TextArea({ "disabled": true, "growMax": 2000 });
    var response_xml5470 = new Ext.form.TextArea({ "disabled": true, "growMax": 2000 });
    var debug_messages5471 = new Ext.form.TextArea({ "disabled": true, "growMax": 2000 });
    var info_messages5472 = new Ext.form.TextArea({ "disabled": true, "growMax": 2000 });
    var national_id5473 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var birth_date5474 = new Lino.IncompleteDateField({ "selectOnFocus": true, "allowBlank": false });
    var sis_card_no5475 = new Ext.form.TextField({ "selectOnFocus": true, "boxMinWidth": Lino.chars2width(10), "maxLength": 10 });
    var id_card_no5476 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 20 });
    var first_name5477 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var last_name5478 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var middle_name5479 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var gender5480 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "forceSelection": true, "store": [['','<br>']].concat(Lino.lino.Genders) });
    var tolerance5481 = new Ext.form.NumberField({ "selectOnFocus": true, "allowBlank": false, "value": 0 });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ new Lino.NullNumberColumn({ "colIndex": 0, "sortable": true, "format": "0", "editable": true, "tooltip": "(cbss.MyIdentifyPersonRequests.id) ", "filter": { "type": "numeric" }, "header": "ID", "renderer": Lino.id_renderer, "editor": id5463, "width": Lino.chars2width(6), "dataIndex": "id" }), { "colIndex": 1, "sortable": true, "header": "Klient", "editable": true, "tooltip": "(cbss.MyIdentifyPersonRequests.person) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "person", "editor": person5464 }, { "width": Lino.chars2width(17), "colIndex": 2, "sortable": true, "dataIndex": "sent", "header": "Versendet", "editable": false, "tooltip": "(cbss.MyIdentifyPersonRequests.sent) The date and time when this request has been executed. \nThis is empty for requests than haven't been sent.\nRead-only." }, { "colIndex": 3, "sortable": true, "header": "Zustand", "editable": false, "tooltip": "(cbss.MyIdentifyPersonRequests.status) ", "filter": { "type": "string" }, "width": Lino.chars2width(13), "dataIndex": "status" }, { "colIndex": 4, "sortable": true, "header": "T/A/B", "editable": false, "tooltip": "(cbss.MyIdentifyPersonRequests.environment) ", "filter": { "type": "string" }, "width": Lino.chars2width(6), "dataIndex": "environment" }, { "colIndex": 5, "sortable": true, "header": "Ticket", "editable": false, "tooltip": "(cbss.MyIdentifyPersonRequests.ticket) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "ticket" }, { "colIndex": 6, "sortable": false, "header": "Abfrage", "editable": false, "tooltip": "(cbss.MyIdentifyPersonRequests.request_xml) The raw XML string that has (or would have) been sent.", "filter": { "type": "string" }, "width": Lino.chars2width(61), "dataIndex": "request_xml", "renderer": Lino.text_renderer }, { "colIndex": 7, "sortable": false, "header": "Antwort", "editable": false, "tooltip": "(cbss.MyIdentifyPersonRequests.response_xml) The raw XML response received. \n", "filter": { "type": "string" }, "width": Lino.chars2width(61), "dataIndex": "response_xml", "renderer": Lino.text_renderer }, { "colIndex": 8, "sortable": false, "header": "Debug-Meldungen", "editable": false, "tooltip": "(cbss.MyIdentifyPersonRequests.debug_messages) ", "filter": { "type": "string" }, "width": Lino.chars2width(61), "dataIndex": "debug_messages", "renderer": Lino.text_renderer }, { "colIndex": 9, "sortable": false, "header": "Info-Meldungen", "editable": false, "tooltip": "(cbss.MyIdentifyPersonRequests.info_messages) ", "filter": { "type": "string" }, "width": Lino.chars2width(61), "dataIndex": "info_messages", "renderer": Lino.text_renderer }, { "colIndex": 10, "sortable": true, "header": "NR-Nummer", "editable": true, "tooltip": "(cbss.MyIdentifyPersonRequests.national_id) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "national_id", "editor": national_id5473 }, { "colIndex": 11, "sortable": true, "header": "Geburtsdatum", "editable": true, "tooltip": "(cbss.MyIdentifyPersonRequests.birth_date) Uncomplete dates are allowed, e.g. \n\"00.00.1980\" means \"some day in 1980\", \n\"00.07.1980\" means \"in July 1980\"\nor \"23.07.0000\" means \"on a 23th of July\".", "filter": { "type": "string" }, "width": Lino.chars2width(13), "dataIndex": "birth_date", "editor": birth_date5474 }, { "colIndex": 12, "sortable": true, "header": "SIS-Karten-Nr", "editable": true, "tooltip": "(cbss.MyIdentifyPersonRequests.sis_card_no) The number of the SIS card used to authenticate the person.", "filter": { "type": "string" }, "width": Lino.chars2width(12), "dataIndex": "sis_card_no", "editor": sis_card_no5475 }, { "colIndex": 13, "sortable": true, "header": "ID-Karten-Nr", "editable": true, "tooltip": "(cbss.MyIdentifyPersonRequests.id_card_no) The number of the ID card used to authenticate the person.", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "id_card_no", "editor": id_card_no5476 }, { "colIndex": 14, "sortable": true, "header": "Vorname", "editable": true, "tooltip": "(cbss.MyIdentifyPersonRequests.first_name) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "first_name", "editor": first_name5477 }, { "colIndex": 15, "sortable": true, "header": "Familienname", "editable": true, "tooltip": "(cbss.MyIdentifyPersonRequests.last_name) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "last_name", "editor": last_name5478 }, { "colIndex": 16, "sortable": true, "header": "Mittelnamen", "editable": true, "tooltip": "(cbss.MyIdentifyPersonRequests.middle_name) Whatever this means...", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "middle_name", "editor": middle_name5479 }, { "colIndex": 17, "sortable": true, "header": "Geschlecht", "editable": true, "tooltip": "(cbss.MyIdentifyPersonRequests.gender) ", "filter": { "type": "string" }, "width": Lino.chars2width(10), "dataIndex": "gender", "editor": gender5480 }, new Lino.NullNumberColumn({ "colIndex": 18, "sortable": true, "format": "0", "editable": true, "tooltip": "(cbss.MyIdentifyPersonRequests.tolerance) \n      Falls Monat oder Tag des Geburtsdatums unbekannt sind, \n      um wieviel Monate bzw. Tage die Suche nach unten/oben ausgeweitet wird.\n      G\u00fcltige Werte: 0 bis 10.\n      ", "filter": { "type": "numeric" }, "header": "Toleranz", "dataIndex": "tolerance", "width": Lino.chars2width(6), "editor": tolerance5481 }) ];
    Lino.cbss.MyIdentifyPersonRequests.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.cbss.MyIdentifyPersonRequests.put = function(rp,pk) { 
  Lino.run_row_action(rp,"/cbss/MyIdentifyPersonRequests","GET",pk,"put",null);
};
Lino.cbss.MyIdentifyPersonRequests.post = function(rp,pk) { 
  Lino.run_row_action(rp,"/cbss/MyIdentifyPersonRequests","GET",pk,"post",null);
};

Lino.cbss.MyIdentifyPersonRequests.insertPanel = Ext.extend(Lino.cbss.IdentifyPersonRequests.InsertFormPanel,{
  empty_title: "Neu Meine IdentifyPerson-Anfragen",
  hide_navigator: true,
  ls_bbar_actions: [ { "itemId": "post", "menu_item_text": "Erstellen", "tooltip": "Datensatz erstellen und dann im Detail-Fenster \u00f6ffnen", "panel_btn_handler": function(panel){panel.save(null,true,'post')}, "text": "Erstellen", "overflowText": "Erstellen", "auto_save": false }, { "itemId": "poststay", "menu_item_text": "Erstellen ohne Detail", "tooltip": "Nach Erstellen des Datensatzes kein Detail-Fenster \u00f6ffnen", "panel_btn_handler": function(panel){panel.save(null,false,'poststay')}, "text": "Erstellen ohne Detail", "overflowText": "Erstellen ohne Detail", "auto_save": false } ],
  ls_url: "/cbss/MyIdentifyPersonRequests",
  action_name: "insert",
  initComponent : function() {
    this.ls_detail_handler = Lino.cbss.MyIdentifyPersonRequests.detail;
    this.ls_insert_handler = Lino.cbss.MyIdentifyPersonRequests.insert;
    Lino.cbss.MyIdentifyPersonRequests.insertPanel.superclass.initComponent.call(this);
  }
});

Lino.cbss.MyIdentifyPersonRequests.insert = new Lino.WindowAction({ "draggable": true, "width": Lino.chars2width(60), "autoHeight": true, "maximizable": true, "modal": true, "maximized": false },function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.cbss.MyIdentifyPersonRequests.insertPanel(p);
});
Lino.cbss.MyIdentifyPersonRequests.poststay = function(rp,pk) { 
  Lino.run_row_action(rp,"/cbss/MyIdentifyPersonRequests","GET",pk,"poststay",null);
};
Lino.cbss.MyIdentifyPersonRequests.duplicate = function(rp,pk) { 
  Lino.run_row_action(rp,"/cbss/MyIdentifyPersonRequests","GET",pk,"duplicate",null);
};

Lino.cbss.MyIdentifyPersonRequests.detailPanel = Ext.extend(Lino.cbss.IdentifyPersonRequests.DetailFormPanel,{
  empty_title: "Detail Meine IdentifyPerson-Anfragen",
  ls_bbar_actions: [ { "itemId": "put", "menu_item_text": "Speichern", "tooltip": "\u00c4nderungen in diesem Formular speichern", "panel_btn_handler": function(panel){panel.save(null,false,'put')}, "iconCls": "x-tbar-save", "overflowText": "Speichern", "auto_save": false }, { "itemId": "insert", "menu_item_text": "Neu", "must_save": true, "tooltip": "Neuen Datensatz erstellen", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-new", "overflowText": "Neu", "auto_save": true }, { "itemId": "duplicate", "menu_item_text": "Duplizieren", "must_save": true, "tooltip": "Duplizieren", "panel_btn_handler": Lino.row_action_handler('duplicate','GET',null), "iconCls": "x-tbar-duplicate", "overflowText": "Duplizieren", "auto_save": true }, { "itemId": null, "menu_item_text": "L\u00f6schen", "tooltip": "Diesen Datensatz l\u00f6schen", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "L\u00f6schen", "auto_save": false }, { "itemId": "do_print", "menu_item_text": "Drucken", "must_save": true, "tooltip": "Drucken", "panel_btn_handler": Lino.row_action_handler('do_print','GET',null), "iconCls": "x-tbar-print", "overflowText": "Drucken", "auto_save": true } ],
  ls_url: "/cbss/MyIdentifyPersonRequests",
  action_name: "detail",
  initComponent : function() {
    this.ls_detail_handler = Lino.cbss.MyIdentifyPersonRequests.detail;
    this.ls_insert_handler = Lino.cbss.MyIdentifyPersonRequests.insert;
    Lino.cbss.MyIdentifyPersonRequests.detailPanel.superclass.initComponent.call(this);
  }
});

Lino.cbss.MyIdentifyPersonRequests.detail = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.cbss.MyIdentifyPersonRequests.detailPanel(p);
});
Lino.cbss.MyIdentifyPersonRequests.do_print = function(rp,pk) { 
  Lino.run_row_action(rp,"/cbss/MyIdentifyPersonRequests","GET",pk,"do_print",null);
};
Lino.cbss.MyIdentifyPersonRequests.edit_template = function(rp,pk) { 
  Lino.run_row_action(rp,"/cbss/MyIdentifyPersonRequests","GET",pk,"edit_template",null);
};
Lino.cbss.MyIdentifyPersonRequests.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.cbss.MyIdentifyPersonRequests.GridPanel(p);
});

// js_render_GridPanel_class cbss.IdentifyRequestsByPerson
Lino.cbss.IdentifyRequestsByPerson.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "Keine Daten anzuzeigen." },
  ls_url : "/cbss/IdentifyRequestsByPerson",
  ls_bbar_actions : [ { "itemId": "insert", "menu_item_text": "Neu", "must_save": true, "tooltip": "Neuen Datensatz erstellen", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-new", "overflowText": "Neu", "auto_save": true }, { "itemId": "duplicate", "menu_item_text": "Duplizieren", "must_save": true, "tooltip": "Duplizieren", "panel_btn_handler": Lino.row_action_handler('duplicate','GET',null), "iconCls": "x-tbar-duplicate", "overflowText": "Duplizieren", "auto_save": true }, { "itemId": "detail", "menu_item_text": "Detail", "tooltip": "Detail-Fenster auf diesem Datensatz \u00f6ffnen", "panel_btn_handler": Lino.show_detail, "iconCls": "x-tbar-detail", "overflowText": "Detail", "auto_save": true }, { "itemId": null, "menu_item_text": "L\u00f6schen", "tooltip": "Diesen Datensatz l\u00f6schen", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "L\u00f6schen", "auto_save": false }, { "itemId": "do_print", "menu_item_text": "Drucken", "must_save": true, "tooltip": "Drucken", "panel_btn_handler": Lino.row_action_handler('do_print','GET',null), "iconCls": "x-tbar-print", "overflowText": "Drucken", "auto_save": true } ],
  title : "IdentifyPerson-Anfragen",
  page_length : 20,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "name": "user" }, 'userHidden', { "name": "sent" }, { "name": "status" }, 'statusHidden', { "type": "int", "name": "id" }, { "name": "environment" }, { "name": "ticket" }, { "name": "request_xml" }, { "name": "response_xml" }, { "name": "debug_messages" }, { "name": "info_messages" }, { "name": "national_id" }, { "name": "birth_date" }, { "name": "sis_card_no" }, { "name": "id_card_no" }, { "name": "first_name" }, { "name": "last_name" }, { "name": "middle_name" }, { "name": "gender" }, 'genderHidden', { "type": "int", "name": "tolerance" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 5,
  ls_grid_configs : [  ],
  content_type : 92,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 23,
  initComponent : function() {
    this.ls_detail_handler = Lino.cbss.IdentifyRequestsByPerson.detail;
    this.ls_insert_handler = Lino.cbss.IdentifyRequestsByPerson.insert;
    var ww = this.containing_window;
    var user5483 = new Lino.RemoteComboFieldElement({ "preferred_width": 15, "allowBlank": false, "pageSize": 20, "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cbss/IdentifyRequestsByPerson/user", "method": "GET" }) }), "emptyText": "Benutzer ausw\u00e4hlen..." });
    var sent5484 = new Ext.form.DisplayField({ "disabled": true, "value": "<br>" });
    var status5485 = new Lino.ChoicesFieldElement({ "disabled": true, "forceSelection": true, "store": [['','<br>']].concat(Lino.cbss.RequestStates) });
    var id5486 = new Ext.form.NumberField({ "selectOnFocus": true });
    var environment5487 = new Ext.form.TextField({ "disabled": true, "boxMinWidth": Lino.chars2width(4), "maxLength": 4 });
    var ticket5488 = new Ext.form.TextField({ "disabled": true, "maxLength": 36 });
    var request_xml5489 = new Ext.form.TextArea({ "disabled": true, "growMax": 2000 });
    var response_xml5490 = new Ext.form.TextArea({ "disabled": true, "growMax": 2000 });
    var debug_messages5491 = new Ext.form.TextArea({ "disabled": true, "growMax": 2000 });
    var info_messages5492 = new Ext.form.TextArea({ "disabled": true, "growMax": 2000 });
    var national_id5493 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var birth_date5494 = new Lino.IncompleteDateField({ "selectOnFocus": true, "allowBlank": false });
    var sis_card_no5495 = new Ext.form.TextField({ "selectOnFocus": true, "boxMinWidth": Lino.chars2width(10), "maxLength": 10 });
    var id_card_no5496 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 20 });
    var first_name5497 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var last_name5498 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var middle_name5499 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var gender5500 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "forceSelection": true, "store": [['','<br>']].concat(Lino.lino.Genders) });
    var tolerance5501 = new Ext.form.NumberField({ "selectOnFocus": true, "allowBlank": false, "value": 0 });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ { "colIndex": 0, "sortable": true, "header": "Autor", "editable": true, "tooltip": "(cbss.IdentifyRequestsByPerson.user) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "user", "editor": user5483 }, { "width": Lino.chars2width(17), "colIndex": 1, "sortable": true, "dataIndex": "sent", "header": "Versendet", "editable": false, "tooltip": "(cbss.IdentifyRequestsByPerson.sent) The date and time when this request has been executed. \nThis is empty for requests than haven't been sent.\nRead-only." }, { "colIndex": 2, "sortable": true, "header": "Zustand", "editable": false, "tooltip": "(cbss.IdentifyRequestsByPerson.status) ", "filter": { "type": "string" }, "width": Lino.chars2width(13), "dataIndex": "status" }, new Lino.NullNumberColumn({ "colIndex": 3, "sortable": true, "format": "0", "editable": true, "tooltip": "(cbss.IdentifyRequestsByPerson.id) ", "filter": { "type": "numeric" }, "header": "ID", "renderer": Lino.id_renderer, "editor": id5486, "width": Lino.chars2width(6), "dataIndex": "id" }), { "colIndex": 4, "sortable": true, "header": "T/A/B", "editable": false, "tooltip": "(cbss.IdentifyRequestsByPerson.environment) ", "filter": { "type": "string" }, "width": Lino.chars2width(6), "dataIndex": "environment" }, { "colIndex": 5, "sortable": true, "header": "Ticket", "editable": false, "tooltip": "(cbss.IdentifyRequestsByPerson.ticket) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "ticket" }, { "colIndex": 6, "sortable": false, "header": "Abfrage", "editable": false, "tooltip": "(cbss.IdentifyRequestsByPerson.request_xml) The raw XML string that has (or would have) been sent.", "filter": { "type": "string" }, "width": Lino.chars2width(61), "dataIndex": "request_xml", "renderer": Lino.text_renderer }, { "colIndex": 7, "sortable": false, "header": "Antwort", "editable": false, "tooltip": "(cbss.IdentifyRequestsByPerson.response_xml) The raw XML response received. \n", "filter": { "type": "string" }, "width": Lino.chars2width(61), "dataIndex": "response_xml", "renderer": Lino.text_renderer }, { "colIndex": 8, "sortable": false, "header": "Debug-Meldungen", "editable": false, "tooltip": "(cbss.IdentifyRequestsByPerson.debug_messages) ", "filter": { "type": "string" }, "width": Lino.chars2width(61), "dataIndex": "debug_messages", "renderer": Lino.text_renderer }, { "colIndex": 9, "sortable": false, "header": "Info-Meldungen", "editable": false, "tooltip": "(cbss.IdentifyRequestsByPerson.info_messages) ", "filter": { "type": "string" }, "width": Lino.chars2width(61), "dataIndex": "info_messages", "renderer": Lino.text_renderer }, { "colIndex": 10, "sortable": true, "header": "NR-Nummer", "editable": true, "tooltip": "(cbss.IdentifyRequestsByPerson.national_id) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "national_id", "editor": national_id5493 }, { "colIndex": 11, "sortable": true, "header": "Geburtsdatum", "editable": true, "tooltip": "(cbss.IdentifyRequestsByPerson.birth_date) Uncomplete dates are allowed, e.g. \n\"00.00.1980\" means \"some day in 1980\", \n\"00.07.1980\" means \"in July 1980\"\nor \"23.07.0000\" means \"on a 23th of July\".", "filter": { "type": "string" }, "width": Lino.chars2width(13), "dataIndex": "birth_date", "editor": birth_date5494 }, { "colIndex": 12, "sortable": true, "header": "SIS-Karten-Nr", "editable": true, "tooltip": "(cbss.IdentifyRequestsByPerson.sis_card_no) The number of the SIS card used to authenticate the person.", "filter": { "type": "string" }, "width": Lino.chars2width(12), "dataIndex": "sis_card_no", "editor": sis_card_no5495 }, { "colIndex": 13, "sortable": true, "header": "ID-Karten-Nr", "editable": true, "tooltip": "(cbss.IdentifyRequestsByPerson.id_card_no) The number of the ID card used to authenticate the person.", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "id_card_no", "editor": id_card_no5496 }, { "colIndex": 14, "sortable": true, "header": "Vorname", "editable": true, "tooltip": "(cbss.IdentifyRequestsByPerson.first_name) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "first_name", "editor": first_name5497 }, { "colIndex": 15, "sortable": true, "header": "Familienname", "editable": true, "tooltip": "(cbss.IdentifyRequestsByPerson.last_name) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "last_name", "editor": last_name5498 }, { "colIndex": 16, "sortable": true, "header": "Mittelnamen", "editable": true, "tooltip": "(cbss.IdentifyRequestsByPerson.middle_name) Whatever this means...", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "middle_name", "editor": middle_name5499 }, { "colIndex": 17, "sortable": true, "header": "Geschlecht", "editable": true, "tooltip": "(cbss.IdentifyRequestsByPerson.gender) ", "filter": { "type": "string" }, "width": Lino.chars2width(10), "dataIndex": "gender", "editor": gender5500 }, new Lino.NullNumberColumn({ "colIndex": 18, "sortable": true, "format": "0", "editable": true, "tooltip": "(cbss.IdentifyRequestsByPerson.tolerance) \n      Falls Monat oder Tag des Geburtsdatums unbekannt sind, \n      um wieviel Monate bzw. Tage die Suche nach unten/oben ausgeweitet wird.\n      G\u00fcltige Werte: 0 bis 10.\n      ", "filter": { "type": "numeric" }, "header": "Toleranz", "dataIndex": "tolerance", "width": Lino.chars2width(6), "editor": tolerance5501 }) ];
    Lino.cbss.IdentifyRequestsByPerson.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.cbss.IdentifyRequestsByPerson.put = function(rp,pk) { 
  Lino.run_row_action(rp,"/cbss/IdentifyRequestsByPerson","GET",pk,"put",null);
};
Lino.cbss.IdentifyRequestsByPerson.post = function(rp,pk) { 
  Lino.run_row_action(rp,"/cbss/IdentifyRequestsByPerson","GET",pk,"post",null);
};

Lino.cbss.IdentifyRequestsByPerson.insertPanel = Ext.extend(Lino.cbss.IdentifyPersonRequests.InsertFormPanel,{
  empty_title: "Neu IdentifyPerson-Anfragen",
  hide_navigator: true,
  ls_bbar_actions: [ { "itemId": "post", "menu_item_text": "Erstellen", "tooltip": "Datensatz erstellen und dann im Detail-Fenster \u00f6ffnen", "panel_btn_handler": function(panel){panel.save(null,true,'post')}, "text": "Erstellen", "overflowText": "Erstellen", "auto_save": false }, { "itemId": "poststay", "menu_item_text": "Erstellen ohne Detail", "tooltip": "Nach Erstellen des Datensatzes kein Detail-Fenster \u00f6ffnen", "panel_btn_handler": function(panel){panel.save(null,false,'poststay')}, "text": "Erstellen ohne Detail", "overflowText": "Erstellen ohne Detail", "auto_save": false } ],
  ls_url: "/cbss/IdentifyRequestsByPerson",
  action_name: "insert",
  initComponent : function() {
    this.ls_detail_handler = Lino.cbss.IdentifyRequestsByPerson.detail;
    this.ls_insert_handler = Lino.cbss.IdentifyRequestsByPerson.insert;
    Lino.cbss.IdentifyRequestsByPerson.insertPanel.superclass.initComponent.call(this);
  }
});

Lino.cbss.IdentifyRequestsByPerson.insert = new Lino.WindowAction({ "draggable": true, "width": Lino.chars2width(60), "autoHeight": true, "maximizable": true, "modal": true, "maximized": false },function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.cbss.IdentifyRequestsByPerson.insertPanel(p);
});
Lino.cbss.IdentifyRequestsByPerson.poststay = function(rp,pk) { 
  Lino.run_row_action(rp,"/cbss/IdentifyRequestsByPerson","GET",pk,"poststay",null);
};
Lino.cbss.IdentifyRequestsByPerson.duplicate = function(rp,pk) { 
  Lino.run_row_action(rp,"/cbss/IdentifyRequestsByPerson","GET",pk,"duplicate",null);
};

Lino.cbss.IdentifyRequestsByPerson.detailPanel = Ext.extend(Lino.cbss.IdentifyPersonRequests.DetailFormPanel,{
  empty_title: "Detail IdentifyPerson-Anfragen",
  ls_bbar_actions: [ { "itemId": "put", "menu_item_text": "Speichern", "tooltip": "\u00c4nderungen in diesem Formular speichern", "panel_btn_handler": function(panel){panel.save(null,false,'put')}, "iconCls": "x-tbar-save", "overflowText": "Speichern", "auto_save": false }, { "itemId": "insert", "menu_item_text": "Neu", "must_save": true, "tooltip": "Neuen Datensatz erstellen", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-new", "overflowText": "Neu", "auto_save": true }, { "itemId": "duplicate", "menu_item_text": "Duplizieren", "must_save": true, "tooltip": "Duplizieren", "panel_btn_handler": Lino.row_action_handler('duplicate','GET',null), "iconCls": "x-tbar-duplicate", "overflowText": "Duplizieren", "auto_save": true }, { "itemId": null, "menu_item_text": "L\u00f6schen", "tooltip": "Diesen Datensatz l\u00f6schen", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "L\u00f6schen", "auto_save": false }, { "itemId": "do_print", "menu_item_text": "Drucken", "must_save": true, "tooltip": "Drucken", "panel_btn_handler": Lino.row_action_handler('do_print','GET',null), "iconCls": "x-tbar-print", "overflowText": "Drucken", "auto_save": true } ],
  ls_url: "/cbss/IdentifyRequestsByPerson",
  action_name: "detail",
  initComponent : function() {
    this.ls_detail_handler = Lino.cbss.IdentifyRequestsByPerson.detail;
    this.ls_insert_handler = Lino.cbss.IdentifyRequestsByPerson.insert;
    Lino.cbss.IdentifyRequestsByPerson.detailPanel.superclass.initComponent.call(this);
  }
});

Lino.cbss.IdentifyRequestsByPerson.detail = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.cbss.IdentifyRequestsByPerson.detailPanel(p);
});
Lino.cbss.IdentifyRequestsByPerson.do_print = function(rp,pk) { 
  Lino.run_row_action(rp,"/cbss/IdentifyRequestsByPerson","GET",pk,"do_print",null);
};
Lino.cbss.IdentifyRequestsByPerson.edit_template = function(rp,pk) { 
  Lino.run_row_action(rp,"/cbss/IdentifyRequestsByPerson","GET",pk,"edit_template",null);
};
Lino.cbss.IdentifyRequestsByPerson.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.cbss.IdentifyRequestsByPerson.GridPanel(p);
});

// js_render_GridPanel_class cbss.ManageAccessRequestsByPerson
Lino.cbss.ManageAccessRequestsByPerson.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "Keine Daten anzuzeigen." },
  ls_url : "/cbss/ManageAccessRequestsByPerson",
  ls_bbar_actions : [ { "itemId": "insert", "menu_item_text": "Neu", "must_save": true, "tooltip": "Neuen Datensatz erstellen", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-new", "overflowText": "Neu", "auto_save": true }, { "itemId": "duplicate", "menu_item_text": "Duplizieren", "must_save": true, "tooltip": "Duplizieren", "panel_btn_handler": Lino.row_action_handler('duplicate','GET',null), "iconCls": "x-tbar-duplicate", "overflowText": "Duplizieren", "auto_save": true }, { "itemId": "detail", "menu_item_text": "Detail", "tooltip": "Detail-Fenster auf diesem Datensatz \u00f6ffnen", "panel_btn_handler": Lino.show_detail, "iconCls": "x-tbar-detail", "overflowText": "Detail", "auto_save": true }, { "itemId": null, "menu_item_text": "L\u00f6schen", "tooltip": "Diesen Datensatz l\u00f6schen", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "L\u00f6schen", "auto_save": false }, { "itemId": "do_print", "menu_item_text": "Drucken", "must_save": true, "tooltip": "Drucken", "panel_btn_handler": Lino.row_action_handler('do_print','GET',null), "iconCls": "x-tbar-print", "overflowText": "Drucken", "auto_save": true } ],
  title : "ManageAccess-Anfragen",
  page_length : 20,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "type": "int", "name": "id" }, { "name": "user" }, 'userHidden', { "name": "sent" }, { "name": "status" }, 'statusHidden', { "name": "environment" }, { "name": "ticket" }, { "name": "request_xml" }, { "name": "response_xml" }, { "name": "debug_messages" }, { "name": "info_messages" }, { "name": "national_id" }, { "name": "birth_date" }, { "name": "sis_card_no" }, { "name": "id_card_no" }, { "name": "first_name" }, { "name": "last_name" }, { "name": "sector" }, 'sectorHidden', { "name": "purpose" }, 'purposeHidden', { "type": "date", "name": "start_date", "dateFormat": "d.m.Y" }, { "type": "date", "name": "end_date", "dateFormat": "d.m.Y" }, { "name": "action" }, 'actionHidden', { "name": "query_register" }, 'query_registerHidden', { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 0,
  ls_grid_configs : [  ],
  content_type : 90,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 29,
  initComponent : function() {
    this.ls_detail_handler = Lino.cbss.ManageAccessRequestsByPerson.detail;
    this.ls_insert_handler = Lino.cbss.ManageAccessRequestsByPerson.insert;
    var ww = this.containing_window;
    var id5503 = new Ext.form.NumberField({ "selectOnFocus": true });
    var user5504 = new Lino.RemoteComboFieldElement({ "preferred_width": 15, "allowBlank": false, "pageSize": 20, "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cbss/ManageAccessRequestsByPerson/user", "method": "GET" }) }), "emptyText": "Benutzer ausw\u00e4hlen..." });
    var sent5505 = new Ext.form.DisplayField({ "disabled": true, "value": "<br>" });
    var status5506 = new Lino.ChoicesFieldElement({ "disabled": true, "forceSelection": true, "store": [['','<br>']].concat(Lino.cbss.RequestStates) });
    var environment5507 = new Ext.form.TextField({ "disabled": true, "boxMinWidth": Lino.chars2width(4), "maxLength": 4 });
    var ticket5508 = new Ext.form.TextField({ "disabled": true, "maxLength": 36 });
    var request_xml5509 = new Ext.form.TextArea({ "disabled": true, "growMax": 2000 });
    var response_xml5510 = new Ext.form.TextArea({ "disabled": true, "growMax": 2000 });
    var debug_messages5511 = new Ext.form.TextArea({ "disabled": true, "growMax": 2000 });
    var info_messages5512 = new Ext.form.TextArea({ "disabled": true, "growMax": 2000 });
    var national_id5513 = new Ext.form.TextField({ "selectOnFocus": true, "allowBlank": false, "maxLength": 200 });
    var birth_date5514 = new Lino.IncompleteDateField({ "selectOnFocus": true });
    var sis_card_no5515 = new Ext.form.TextField({ "selectOnFocus": true, "boxMinWidth": Lino.chars2width(10), "maxLength": 10 });
    var id_card_no5516 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 20 });
    var first_name5517 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var last_name5518 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var sector5519 = new Lino.RemoteComboFieldElement({ "disabled": true, "store": new Lino.ComplexRemoteComboStore({  }), "pageSize": 20, "emptyText": "Sektor ausw\u00e4hlen..." });
    var purpose5520 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cbss/ManageAccessRequestsByPerson/purpose", "method": "GET" }) }), "allowBlank": false, "pageSize": 20, "emptyText": "Eigenschafts-Code ausw\u00e4hlen..." });
    var start_date5521 = new Lino.DateField({ "selectOnFocus": true, "allowBlank": false });
    var end_date5522 = new Lino.DateField({ "selectOnFocus": true, "allowBlank": false });
    var action5523 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "forceSelection": true, "allowBlank": false, "store": Lino.cbss.ManageAction });
    var query_register5524 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "forceSelection": true, "allowBlank": false, "store": Lino.cbss.QueryRegister });
    this.before_row_edit = function(record) {
      purpose5520.setContextValue('sector',record ? record.data['sectorHidden'] : undefined);
    };
    this.onRender = function(ct, position) {
      sector5519.on('change',Lino.chooser_handler(purpose5520,'sector'));
      Lino.cbss.ManageAccessRequestsByPerson.GridPanel.superclass.onRender.call(this, ct, position);
    }
    this.ls_columns = [ new Lino.NullNumberColumn({ "colIndex": 0, "sortable": true, "format": "0", "editable": true, "tooltip": "(cbss.ManageAccessRequestsByPerson.id) ", "filter": { "type": "numeric" }, "header": "ID", "renderer": Lino.id_renderer, "editor": id5503, "width": Lino.chars2width(6), "dataIndex": "id" }), { "colIndex": 1, "sortable": true, "header": "Autor", "editable": true, "tooltip": "(cbss.ManageAccessRequestsByPerson.user) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "user", "editor": user5504 }, { "width": Lino.chars2width(17), "colIndex": 2, "sortable": true, "dataIndex": "sent", "header": "Versendet", "editable": false, "tooltip": "(cbss.ManageAccessRequestsByPerson.sent) The date and time when this request has been executed. \nThis is empty for requests than haven't been sent.\nRead-only." }, { "colIndex": 3, "sortable": true, "header": "Zustand", "editable": false, "tooltip": "(cbss.ManageAccessRequestsByPerson.status) ", "filter": { "type": "string" }, "width": Lino.chars2width(13), "dataIndex": "status" }, { "colIndex": 4, "sortable": true, "header": "T/A/B", "editable": false, "tooltip": "(cbss.ManageAccessRequestsByPerson.environment) ", "filter": { "type": "string" }, "width": Lino.chars2width(6), "dataIndex": "environment" }, { "colIndex": 5, "sortable": true, "header": "Ticket", "editable": false, "tooltip": "(cbss.ManageAccessRequestsByPerson.ticket) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "ticket" }, { "colIndex": 6, "sortable": false, "header": "Abfrage", "editable": false, "tooltip": "(cbss.ManageAccessRequestsByPerson.request_xml) The raw XML string that has (or would have) been sent.", "filter": { "type": "string" }, "width": Lino.chars2width(61), "dataIndex": "request_xml", "renderer": Lino.text_renderer }, { "colIndex": 7, "sortable": false, "header": "Antwort", "editable": false, "tooltip": "(cbss.ManageAccessRequestsByPerson.response_xml) The raw XML response received. \n", "filter": { "type": "string" }, "width": Lino.chars2width(61), "dataIndex": "response_xml", "renderer": Lino.text_renderer }, { "colIndex": 8, "sortable": false, "header": "Debug-Meldungen", "editable": false, "tooltip": "(cbss.ManageAccessRequestsByPerson.debug_messages) ", "filter": { "type": "string" }, "width": Lino.chars2width(61), "dataIndex": "debug_messages", "renderer": Lino.text_renderer }, { "colIndex": 9, "sortable": false, "header": "Info-Meldungen", "editable": false, "tooltip": "(cbss.ManageAccessRequestsByPerson.info_messages) ", "filter": { "type": "string" }, "width": Lino.chars2width(61), "dataIndex": "info_messages", "renderer": Lino.text_renderer }, { "colIndex": 10, "sortable": true, "header": "NR-Nummer", "editable": true, "tooltip": "(cbss.ManageAccessRequestsByPerson.national_id) The SSIN of the person to register/unregister/list.\n", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "national_id", "editor": national_id5513 }, { "colIndex": 11, "sortable": true, "header": "Geburtsdatum", "editable": true, "tooltip": "(cbss.ManageAccessRequestsByPerson.birth_date) Uncomplete dates are allowed, e.g. \n\"00.00.1980\" means \"some day in 1980\", \n\"00.07.1980\" means \"in July 1980\"\nor \"23.07.0000\" means \"on a 23th of July\".", "filter": { "type": "string" }, "width": Lino.chars2width(13), "dataIndex": "birth_date", "editor": birth_date5514 }, { "colIndex": 12, "sortable": true, "header": "SIS-Karten-Nr", "editable": true, "tooltip": "(cbss.ManageAccessRequestsByPerson.sis_card_no) The number of the SIS card used to authenticate the person.", "filter": { "type": "string" }, "width": Lino.chars2width(12), "dataIndex": "sis_card_no", "editor": sis_card_no5515 }, { "colIndex": 13, "sortable": true, "header": "ID-Karten-Nr", "editable": true, "tooltip": "(cbss.ManageAccessRequestsByPerson.id_card_no) The number of the ID card used to authenticate the person.", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "id_card_no", "editor": id_card_no5516 }, { "colIndex": 14, "sortable": true, "header": "Vorname", "editable": true, "tooltip": "(cbss.ManageAccessRequestsByPerson.first_name) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "first_name", "editor": first_name5517 }, { "colIndex": 15, "sortable": true, "header": "Familienname", "editable": true, "tooltip": "(cbss.ManageAccessRequestsByPerson.last_name) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "last_name", "editor": last_name5518 }, { "colIndex": 16, "sortable": true, "header": "Sektor", "editable": false, "tooltip": "(cbss.ManageAccessRequestsByPerson.sector) For register and unregister this element is ignored. \nIt can be used for list, \nwhen information about sectors is required.", "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "sector" }, { "colIndex": 17, "sortable": true, "header": "Eigenschafts-Code", "editable": true, "tooltip": "(cbss.ManageAccessRequestsByPerson.purpose) The purpose for which the inscription needs to be \nregistered/unregistered or listed. \nFor listing this field is optional, \nfor register/unregister it is mandatory.", "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "purpose", "editor": purpose5520 }, { "colIndex": 18, "sortable": true, "xtype": "datecolumn", "format": "d.m.Y", "editable": true, "tooltip": "(cbss.ManageAccessRequestsByPerson.start_date) ", "filter": { "type": "date", "dateFormat": "d.m.Y" }, "header": "Periode vom", "dataIndex": "start_date", "width": Lino.chars2width(9), "editor": start_date5521 }, { "colIndex": 19, "sortable": true, "xtype": "datecolumn", "format": "d.m.Y", "editable": true, "tooltip": "(cbss.ManageAccessRequestsByPerson.end_date) ", "filter": { "type": "date", "dateFormat": "d.m.Y" }, "header": "Periode bis", "dataIndex": "end_date", "width": Lino.chars2width(9), "editor": end_date5522 }, { "colIndex": 20, "sortable": true, "header": "Aktion", "editable": true, "tooltip": "(cbss.ManageAccessRequestsByPerson.action) ", "filter": { "type": "string" }, "width": Lino.chars2width(14), "dataIndex": "action", "editor": action5523 }, { "colIndex": 21, "sortable": true, "header": "Abfrageregister", "editable": true, "tooltip": "(cbss.ManageAccessRequestsByPerson.query_register) ", "filter": { "type": "string" }, "width": Lino.chars2width(13), "dataIndex": "query_register", "editor": query_register5524 } ];
    Lino.cbss.ManageAccessRequestsByPerson.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.cbss.ManageAccessRequestsByPerson.put = function(rp,pk) { 
  Lino.run_row_action(rp,"/cbss/ManageAccessRequestsByPerson","GET",pk,"put",null);
};
Lino.cbss.ManageAccessRequestsByPerson.post = function(rp,pk) { 
  Lino.run_row_action(rp,"/cbss/ManageAccessRequestsByPerson","GET",pk,"post",null);
};

Lino.cbss.ManageAccessRequestsByPerson.insertPanel = Ext.extend(Lino.cbss.ManageAccessRequests.InsertFormPanel,{
  empty_title: "Neu ManageAccess-Anfragen",
  hide_navigator: true,
  ls_bbar_actions: [ { "itemId": "post", "menu_item_text": "Erstellen", "tooltip": "Datensatz erstellen und dann im Detail-Fenster \u00f6ffnen", "panel_btn_handler": function(panel){panel.save(null,true,'post')}, "text": "Erstellen", "overflowText": "Erstellen", "auto_save": false }, { "itemId": "poststay", "menu_item_text": "Erstellen ohne Detail", "tooltip": "Nach Erstellen des Datensatzes kein Detail-Fenster \u00f6ffnen", "panel_btn_handler": function(panel){panel.save(null,false,'poststay')}, "text": "Erstellen ohne Detail", "overflowText": "Erstellen ohne Detail", "auto_save": false } ],
  ls_url: "/cbss/ManageAccessRequestsByPerson",
  action_name: "insert",
  initComponent : function() {
    this.ls_detail_handler = Lino.cbss.ManageAccessRequestsByPerson.detail;
    this.ls_insert_handler = Lino.cbss.ManageAccessRequestsByPerson.insert;
    Lino.cbss.ManageAccessRequestsByPerson.insertPanel.superclass.initComponent.call(this);
  }
});

Lino.cbss.ManageAccessRequestsByPerson.insert = new Lino.WindowAction({ "draggable": true, "width": Lino.chars2width(60), "autoHeight": true, "maximizable": true, "modal": true, "maximized": false },function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.cbss.ManageAccessRequestsByPerson.insertPanel(p);
});
Lino.cbss.ManageAccessRequestsByPerson.poststay = function(rp,pk) { 
  Lino.run_row_action(rp,"/cbss/ManageAccessRequestsByPerson","GET",pk,"poststay",null);
};
Lino.cbss.ManageAccessRequestsByPerson.duplicate = function(rp,pk) { 
  Lino.run_row_action(rp,"/cbss/ManageAccessRequestsByPerson","GET",pk,"duplicate",null);
};

Lino.cbss.ManageAccessRequestsByPerson.detailPanel = Ext.extend(Lino.cbss.ManageAccessRequests.DetailFormPanel,{
  empty_title: "Detail ManageAccess-Anfragen",
  ls_bbar_actions: [ { "itemId": "put", "menu_item_text": "Speichern", "tooltip": "\u00c4nderungen in diesem Formular speichern", "panel_btn_handler": function(panel){panel.save(null,false,'put')}, "iconCls": "x-tbar-save", "overflowText": "Speichern", "auto_save": false }, { "itemId": "insert", "menu_item_text": "Neu", "must_save": true, "tooltip": "Neuen Datensatz erstellen", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-new", "overflowText": "Neu", "auto_save": true }, { "itemId": "duplicate", "menu_item_text": "Duplizieren", "must_save": true, "tooltip": "Duplizieren", "panel_btn_handler": Lino.row_action_handler('duplicate','GET',null), "iconCls": "x-tbar-duplicate", "overflowText": "Duplizieren", "auto_save": true }, { "itemId": null, "menu_item_text": "L\u00f6schen", "tooltip": "Diesen Datensatz l\u00f6schen", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "L\u00f6schen", "auto_save": false }, { "itemId": "do_print", "menu_item_text": "Drucken", "must_save": true, "tooltip": "Drucken", "panel_btn_handler": Lino.row_action_handler('do_print','GET',null), "iconCls": "x-tbar-print", "overflowText": "Drucken", "auto_save": true } ],
  ls_url: "/cbss/ManageAccessRequestsByPerson",
  action_name: "detail",
  initComponent : function() {
    this.ls_detail_handler = Lino.cbss.ManageAccessRequestsByPerson.detail;
    this.ls_insert_handler = Lino.cbss.ManageAccessRequestsByPerson.insert;
    Lino.cbss.ManageAccessRequestsByPerson.detailPanel.superclass.initComponent.call(this);
  }
});

Lino.cbss.ManageAccessRequestsByPerson.detail = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.cbss.ManageAccessRequestsByPerson.detailPanel(p);
});
Lino.cbss.ManageAccessRequestsByPerson.do_print = function(rp,pk) { 
  Lino.run_row_action(rp,"/cbss/ManageAccessRequestsByPerson","GET",pk,"do_print",null);
};
Lino.cbss.ManageAccessRequestsByPerson.edit_template = function(rp,pk) { 
  Lino.run_row_action(rp,"/cbss/ManageAccessRequestsByPerson","GET",pk,"edit_template",null);
};
Lino.cbss.ManageAccessRequestsByPerson.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.cbss.ManageAccessRequestsByPerson.GridPanel(p);
});

// js_render_GridPanel_class cbss.MyManageAccessRequests
Lino.cbss.MyManageAccessRequests.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "Keine Daten anzuzeigen." },
  ls_url : "/cbss/MyManageAccessRequests",
  ls_bbar_actions : [ { "itemId": "insert", "menu_item_text": "Neu", "must_save": true, "tooltip": "Neuen Datensatz erstellen", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-new", "overflowText": "Neu", "auto_save": true }, { "itemId": "duplicate", "menu_item_text": "Duplizieren", "must_save": true, "tooltip": "Duplizieren", "panel_btn_handler": Lino.row_action_handler('duplicate','GET',null), "iconCls": "x-tbar-duplicate", "overflowText": "Duplizieren", "auto_save": true }, { "itemId": "detail", "menu_item_text": "Detail", "tooltip": "Detail-Fenster auf diesem Datensatz \u00f6ffnen", "panel_btn_handler": Lino.show_detail, "iconCls": "x-tbar-detail", "overflowText": "Detail", "auto_save": true }, { "itemId": null, "menu_item_text": "L\u00f6schen", "tooltip": "Diesen Datensatz l\u00f6schen", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "L\u00f6schen", "auto_save": false }, { "itemId": "do_print", "menu_item_text": "Drucken", "must_save": true, "tooltip": "Drucken", "panel_btn_handler": Lino.row_action_handler('do_print','GET',null), "iconCls": "x-tbar-print", "overflowText": "Drucken", "auto_save": true } ],
  title : "Meine ManageAccess-Anfragen",
  page_length : 20,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "type": "int", "name": "id" }, { "name": "person" }, 'personHidden', { "name": "sent" }, { "name": "status" }, 'statusHidden', { "name": "environment" }, { "name": "ticket" }, { "name": "request_xml" }, { "name": "response_xml" }, { "name": "debug_messages" }, { "name": "info_messages" }, { "name": "national_id" }, { "name": "birth_date" }, { "name": "sis_card_no" }, { "name": "id_card_no" }, { "name": "first_name" }, { "name": "last_name" }, { "name": "sector" }, 'sectorHidden', { "name": "purpose" }, 'purposeHidden', { "type": "date", "name": "start_date", "dateFormat": "d.m.Y" }, { "type": "date", "name": "end_date", "dateFormat": "d.m.Y" }, { "name": "action" }, 'actionHidden', { "name": "query_register" }, 'query_registerHidden', { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 0,
  ls_grid_configs : [  ],
  content_type : 90,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 29,
  initComponent : function() {
    this.ls_detail_handler = Lino.cbss.MyManageAccessRequests.detail;
    this.ls_insert_handler = Lino.cbss.MyManageAccessRequests.insert;
    var ww = this.containing_window;
    var id5526 = new Ext.form.NumberField({ "selectOnFocus": true });
    var person5527 = new Lino.RemoteComboFieldElement({ "preferred_width": 20, "allowBlank": false, "pageSize": 20, "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cbss/MyManageAccessRequests/person", "method": "GET" }) }), "emptyText": "Klient ausw\u00e4hlen..." });
    var sent5528 = new Ext.form.DisplayField({ "disabled": true, "value": "<br>" });
    var status5529 = new Lino.ChoicesFieldElement({ "disabled": true, "forceSelection": true, "store": [['','<br>']].concat(Lino.cbss.RequestStates) });
    var environment5530 = new Ext.form.TextField({ "disabled": true, "boxMinWidth": Lino.chars2width(4), "maxLength": 4 });
    var ticket5531 = new Ext.form.TextField({ "disabled": true, "maxLength": 36 });
    var request_xml5532 = new Ext.form.TextArea({ "disabled": true, "growMax": 2000 });
    var response_xml5533 = new Ext.form.TextArea({ "disabled": true, "growMax": 2000 });
    var debug_messages5534 = new Ext.form.TextArea({ "disabled": true, "growMax": 2000 });
    var info_messages5535 = new Ext.form.TextArea({ "disabled": true, "growMax": 2000 });
    var national_id5536 = new Ext.form.TextField({ "selectOnFocus": true, "allowBlank": false, "maxLength": 200 });
    var birth_date5537 = new Lino.IncompleteDateField({ "selectOnFocus": true });
    var sis_card_no5538 = new Ext.form.TextField({ "selectOnFocus": true, "boxMinWidth": Lino.chars2width(10), "maxLength": 10 });
    var id_card_no5539 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 20 });
    var first_name5540 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var last_name5541 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var sector5542 = new Lino.RemoteComboFieldElement({ "disabled": true, "store": new Lino.ComplexRemoteComboStore({  }), "pageSize": 20, "emptyText": "Sektor ausw\u00e4hlen..." });
    var purpose5543 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cbss/MyManageAccessRequests/purpose", "method": "GET" }) }), "allowBlank": false, "pageSize": 20, "emptyText": "Eigenschafts-Code ausw\u00e4hlen..." });
    var start_date5544 = new Lino.DateField({ "selectOnFocus": true, "allowBlank": false });
    var end_date5545 = new Lino.DateField({ "selectOnFocus": true, "allowBlank": false });
    var action5546 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "forceSelection": true, "allowBlank": false, "store": Lino.cbss.ManageAction });
    var query_register5547 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "forceSelection": true, "allowBlank": false, "store": Lino.cbss.QueryRegister });
    this.before_row_edit = function(record) {
      purpose5543.setContextValue('sector',record ? record.data['sectorHidden'] : undefined);
    };
    this.onRender = function(ct, position) {
      sector5542.on('change',Lino.chooser_handler(purpose5543,'sector'));
      Lino.cbss.MyManageAccessRequests.GridPanel.superclass.onRender.call(this, ct, position);
    }
    this.ls_columns = [ new Lino.NullNumberColumn({ "colIndex": 0, "sortable": true, "format": "0", "editable": true, "tooltip": "(cbss.MyManageAccessRequests.id) ", "filter": { "type": "numeric" }, "header": "ID", "renderer": Lino.id_renderer, "editor": id5526, "width": Lino.chars2width(6), "dataIndex": "id" }), { "colIndex": 1, "sortable": true, "header": "Klient", "editable": true, "tooltip": "(cbss.MyManageAccessRequests.person) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "person", "editor": person5527 }, { "width": Lino.chars2width(17), "colIndex": 2, "sortable": true, "dataIndex": "sent", "header": "Versendet", "editable": false, "tooltip": "(cbss.MyManageAccessRequests.sent) The date and time when this request has been executed. \nThis is empty for requests than haven't been sent.\nRead-only." }, { "colIndex": 3, "sortable": true, "header": "Zustand", "editable": false, "tooltip": "(cbss.MyManageAccessRequests.status) ", "filter": { "type": "string" }, "width": Lino.chars2width(13), "dataIndex": "status" }, { "colIndex": 4, "sortable": true, "header": "T/A/B", "editable": false, "tooltip": "(cbss.MyManageAccessRequests.environment) ", "filter": { "type": "string" }, "width": Lino.chars2width(6), "dataIndex": "environment" }, { "colIndex": 5, "sortable": true, "header": "Ticket", "editable": false, "tooltip": "(cbss.MyManageAccessRequests.ticket) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "ticket" }, { "colIndex": 6, "sortable": false, "header": "Abfrage", "editable": false, "tooltip": "(cbss.MyManageAccessRequests.request_xml) The raw XML string that has (or would have) been sent.", "filter": { "type": "string" }, "width": Lino.chars2width(61), "dataIndex": "request_xml", "renderer": Lino.text_renderer }, { "colIndex": 7, "sortable": false, "header": "Antwort", "editable": false, "tooltip": "(cbss.MyManageAccessRequests.response_xml) The raw XML response received. \n", "filter": { "type": "string" }, "width": Lino.chars2width(61), "dataIndex": "response_xml", "renderer": Lino.text_renderer }, { "colIndex": 8, "sortable": false, "header": "Debug-Meldungen", "editable": false, "tooltip": "(cbss.MyManageAccessRequests.debug_messages) ", "filter": { "type": "string" }, "width": Lino.chars2width(61), "dataIndex": "debug_messages", "renderer": Lino.text_renderer }, { "colIndex": 9, "sortable": false, "header": "Info-Meldungen", "editable": false, "tooltip": "(cbss.MyManageAccessRequests.info_messages) ", "filter": { "type": "string" }, "width": Lino.chars2width(61), "dataIndex": "info_messages", "renderer": Lino.text_renderer }, { "colIndex": 10, "sortable": true, "header": "NR-Nummer", "editable": true, "tooltip": "(cbss.MyManageAccessRequests.national_id) The SSIN of the person to register/unregister/list.\n", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "national_id", "editor": national_id5536 }, { "colIndex": 11, "sortable": true, "header": "Geburtsdatum", "editable": true, "tooltip": "(cbss.MyManageAccessRequests.birth_date) Uncomplete dates are allowed, e.g. \n\"00.00.1980\" means \"some day in 1980\", \n\"00.07.1980\" means \"in July 1980\"\nor \"23.07.0000\" means \"on a 23th of July\".", "filter": { "type": "string" }, "width": Lino.chars2width(13), "dataIndex": "birth_date", "editor": birth_date5537 }, { "colIndex": 12, "sortable": true, "header": "SIS-Karten-Nr", "editable": true, "tooltip": "(cbss.MyManageAccessRequests.sis_card_no) The number of the SIS card used to authenticate the person.", "filter": { "type": "string" }, "width": Lino.chars2width(12), "dataIndex": "sis_card_no", "editor": sis_card_no5538 }, { "colIndex": 13, "sortable": true, "header": "ID-Karten-Nr", "editable": true, "tooltip": "(cbss.MyManageAccessRequests.id_card_no) The number of the ID card used to authenticate the person.", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "id_card_no", "editor": id_card_no5539 }, { "colIndex": 14, "sortable": true, "header": "Vorname", "editable": true, "tooltip": "(cbss.MyManageAccessRequests.first_name) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "first_name", "editor": first_name5540 }, { "colIndex": 15, "sortable": true, "header": "Familienname", "editable": true, "tooltip": "(cbss.MyManageAccessRequests.last_name) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "last_name", "editor": last_name5541 }, { "colIndex": 16, "sortable": true, "header": "Sektor", "editable": false, "tooltip": "(cbss.MyManageAccessRequests.sector) For register and unregister this element is ignored. \nIt can be used for list, \nwhen information about sectors is required.", "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "sector" }, { "colIndex": 17, "sortable": true, "header": "Eigenschafts-Code", "editable": true, "tooltip": "(cbss.MyManageAccessRequests.purpose) The purpose for which the inscription needs to be \nregistered/unregistered or listed. \nFor listing this field is optional, \nfor register/unregister it is mandatory.", "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "purpose", "editor": purpose5543 }, { "colIndex": 18, "sortable": true, "xtype": "datecolumn", "format": "d.m.Y", "editable": true, "tooltip": "(cbss.MyManageAccessRequests.start_date) ", "filter": { "type": "date", "dateFormat": "d.m.Y" }, "header": "Periode vom", "dataIndex": "start_date", "width": Lino.chars2width(9), "editor": start_date5544 }, { "colIndex": 19, "sortable": true, "xtype": "datecolumn", "format": "d.m.Y", "editable": true, "tooltip": "(cbss.MyManageAccessRequests.end_date) ", "filter": { "type": "date", "dateFormat": "d.m.Y" }, "header": "Periode bis", "dataIndex": "end_date", "width": Lino.chars2width(9), "editor": end_date5545 }, { "colIndex": 20, "sortable": true, "header": "Aktion", "editable": true, "tooltip": "(cbss.MyManageAccessRequests.action) ", "filter": { "type": "string" }, "width": Lino.chars2width(14), "dataIndex": "action", "editor": action5546 }, { "colIndex": 21, "sortable": true, "header": "Abfrageregister", "editable": true, "tooltip": "(cbss.MyManageAccessRequests.query_register) ", "filter": { "type": "string" }, "width": Lino.chars2width(13), "dataIndex": "query_register", "editor": query_register5547 } ];
    Lino.cbss.MyManageAccessRequests.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.cbss.MyManageAccessRequests.put = function(rp,pk) { 
  Lino.run_row_action(rp,"/cbss/MyManageAccessRequests","GET",pk,"put",null);
};
Lino.cbss.MyManageAccessRequests.post = function(rp,pk) { 
  Lino.run_row_action(rp,"/cbss/MyManageAccessRequests","GET",pk,"post",null);
};

Lino.cbss.MyManageAccessRequests.insertPanel = Ext.extend(Lino.cbss.ManageAccessRequests.InsertFormPanel,{
  empty_title: "Neu Meine ManageAccess-Anfragen",
  hide_navigator: true,
  ls_bbar_actions: [ { "itemId": "post", "menu_item_text": "Erstellen", "tooltip": "Datensatz erstellen und dann im Detail-Fenster \u00f6ffnen", "panel_btn_handler": function(panel){panel.save(null,true,'post')}, "text": "Erstellen", "overflowText": "Erstellen", "auto_save": false }, { "itemId": "poststay", "menu_item_text": "Erstellen ohne Detail", "tooltip": "Nach Erstellen des Datensatzes kein Detail-Fenster \u00f6ffnen", "panel_btn_handler": function(panel){panel.save(null,false,'poststay')}, "text": "Erstellen ohne Detail", "overflowText": "Erstellen ohne Detail", "auto_save": false } ],
  ls_url: "/cbss/MyManageAccessRequests",
  action_name: "insert",
  initComponent : function() {
    this.ls_detail_handler = Lino.cbss.MyManageAccessRequests.detail;
    this.ls_insert_handler = Lino.cbss.MyManageAccessRequests.insert;
    Lino.cbss.MyManageAccessRequests.insertPanel.superclass.initComponent.call(this);
  }
});

Lino.cbss.MyManageAccessRequests.insert = new Lino.WindowAction({ "draggable": true, "width": Lino.chars2width(60), "autoHeight": true, "maximizable": true, "modal": true, "maximized": false },function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.cbss.MyManageAccessRequests.insertPanel(p);
});
Lino.cbss.MyManageAccessRequests.poststay = function(rp,pk) { 
  Lino.run_row_action(rp,"/cbss/MyManageAccessRequests","GET",pk,"poststay",null);
};
Lino.cbss.MyManageAccessRequests.duplicate = function(rp,pk) { 
  Lino.run_row_action(rp,"/cbss/MyManageAccessRequests","GET",pk,"duplicate",null);
};

Lino.cbss.MyManageAccessRequests.detailPanel = Ext.extend(Lino.cbss.ManageAccessRequests.DetailFormPanel,{
  empty_title: "Detail Meine ManageAccess-Anfragen",
  ls_bbar_actions: [ { "itemId": "put", "menu_item_text": "Speichern", "tooltip": "\u00c4nderungen in diesem Formular speichern", "panel_btn_handler": function(panel){panel.save(null,false,'put')}, "iconCls": "x-tbar-save", "overflowText": "Speichern", "auto_save": false }, { "itemId": "insert", "menu_item_text": "Neu", "must_save": true, "tooltip": "Neuen Datensatz erstellen", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-new", "overflowText": "Neu", "auto_save": true }, { "itemId": "duplicate", "menu_item_text": "Duplizieren", "must_save": true, "tooltip": "Duplizieren", "panel_btn_handler": Lino.row_action_handler('duplicate','GET',null), "iconCls": "x-tbar-duplicate", "overflowText": "Duplizieren", "auto_save": true }, { "itemId": null, "menu_item_text": "L\u00f6schen", "tooltip": "Diesen Datensatz l\u00f6schen", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "L\u00f6schen", "auto_save": false }, { "itemId": "do_print", "menu_item_text": "Drucken", "must_save": true, "tooltip": "Drucken", "panel_btn_handler": Lino.row_action_handler('do_print','GET',null), "iconCls": "x-tbar-print", "overflowText": "Drucken", "auto_save": true } ],
  ls_url: "/cbss/MyManageAccessRequests",
  action_name: "detail",
  initComponent : function() {
    this.ls_detail_handler = Lino.cbss.MyManageAccessRequests.detail;
    this.ls_insert_handler = Lino.cbss.MyManageAccessRequests.insert;
    Lino.cbss.MyManageAccessRequests.detailPanel.superclass.initComponent.call(this);
  }
});

Lino.cbss.MyManageAccessRequests.detail = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.cbss.MyManageAccessRequests.detailPanel(p);
});
Lino.cbss.MyManageAccessRequests.do_print = function(rp,pk) { 
  Lino.run_row_action(rp,"/cbss/MyManageAccessRequests","GET",pk,"do_print",null);
};
Lino.cbss.MyManageAccessRequests.edit_template = function(rp,pk) { 
  Lino.run_row_action(rp,"/cbss/MyManageAccessRequests","GET",pk,"edit_template",null);
};
Lino.cbss.MyManageAccessRequests.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.cbss.MyManageAccessRequests.GridPanel(p);
});

// js_render_GridPanel_class cbss.RetrieveTIGroupsRequestsByPerson
Lino.cbss.RetrieveTIGroupsRequestsByPerson.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "Keine Daten anzuzeigen." },
  ls_url : "/cbss/RetrieveTIGroupsRequestsByPerson",
  ls_bbar_actions : [ { "itemId": "insert", "menu_item_text": "Neu", "must_save": true, "tooltip": "Neuen Datensatz erstellen", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-new", "overflowText": "Neu", "auto_save": true }, { "itemId": "duplicate", "menu_item_text": "Duplizieren", "must_save": true, "tooltip": "Duplizieren", "panel_btn_handler": Lino.row_action_handler('duplicate','GET',null), "iconCls": "x-tbar-duplicate", "overflowText": "Duplizieren", "auto_save": true }, { "itemId": "detail", "menu_item_text": "Detail", "tooltip": "Detail-Fenster auf diesem Datensatz \u00f6ffnen", "panel_btn_handler": Lino.show_detail, "iconCls": "x-tbar-detail", "overflowText": "Detail", "auto_save": true }, { "itemId": null, "menu_item_text": "L\u00f6schen", "tooltip": "Diesen Datensatz l\u00f6schen", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "L\u00f6schen", "auto_save": false }, { "itemId": "do_print", "menu_item_text": "Drucken", "must_save": true, "tooltip": "Drucken", "panel_btn_handler": Lino.row_action_handler('do_print','GET',null), "iconCls": "x-tbar-print", "overflowText": "Drucken", "auto_save": true } ],
  title : "Tx25-Anfragen",
  page_length : 20,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "type": "int", "name": "id" }, { "name": "user" }, 'userHidden', { "name": "person" }, 'personHidden', { "name": "national_id" }, { "name": "language" }, 'languageHidden', { "type": "boolean", "name": "history" }, { "name": "status" }, 'statusHidden', { "name": "ticket" }, { "name": "sent" }, { "name": "environment" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 0,
  ls_grid_configs : [  ],
  content_type : 89,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 15,
  initComponent : function() {
    this.ls_detail_handler = Lino.cbss.RetrieveTIGroupsRequestsByPerson.detail;
    this.ls_insert_handler = Lino.cbss.RetrieveTIGroupsRequestsByPerson.insert;
    var ww = this.containing_window;
    var id5549 = new Ext.form.NumberField({ "selectOnFocus": true });
    var user5550 = new Lino.RemoteComboFieldElement({ "preferred_width": 15, "allowBlank": false, "pageSize": 20, "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cbss/RetrieveTIGroupsRequestsByPerson/user", "method": "GET" }) }), "emptyText": "Benutzer ausw\u00e4hlen..." });
    var person5551 = new Lino.RemoteComboFieldElement({ "preferred_width": 20, "allowBlank": false, "pageSize": 20, "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cbss/RetrieveTIGroupsRequestsByPerson/person", "method": "GET" }) }), "emptyText": "Klient ausw\u00e4hlen..." });
    var national_id5552 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var language5553 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "forceSelection": true, "store": [['','<br>']].concat(Lino.cbss.RequestLanguages) });
    var history5554 = new Ext.form.Checkbox({ "selectOnFocus": true, "checked": true });
    var status5555 = new Lino.ChoicesFieldElement({ "disabled": true, "forceSelection": true, "store": [['','<br>']].concat(Lino.cbss.RequestStates) });
    var ticket5556 = new Ext.form.TextField({ "disabled": true, "maxLength": 36 });
    var sent5557 = new Ext.form.DisplayField({ "disabled": true, "value": "<br>" });
    var environment5558 = new Ext.form.TextField({ "disabled": true, "boxMinWidth": Lino.chars2width(4), "maxLength": 4 });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ new Lino.NullNumberColumn({ "colIndex": 0, "sortable": true, "format": "0", "editable": true, "tooltip": "(cbss.RetrieveTIGroupsRequestsByPerson.id) ", "filter": { "type": "numeric" }, "header": "ID", "renderer": Lino.id_renderer, "editor": id5549, "width": Lino.chars2width(6), "dataIndex": "id" }), { "colIndex": 1, "sortable": true, "header": "Autor", "editable": true, "tooltip": "(cbss.RetrieveTIGroupsRequestsByPerson.user) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "user", "editor": user5550 }, { "colIndex": 2, "sortable": true, "header": "Klient", "editable": true, "tooltip": "(cbss.RetrieveTIGroupsRequestsByPerson.person) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "person", "editor": person5551 }, { "colIndex": 3, "sortable": true, "header": "NR-Nummer", "editable": true, "tooltip": "(cbss.RetrieveTIGroupsRequestsByPerson.national_id) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "national_id", "editor": national_id5552 }, { "colIndex": 4, "sortable": true, "header": "Sprache", "editable": true, "tooltip": "(cbss.RetrieveTIGroupsRequestsByPerson.language) ", "filter": { "type": "string" }, "width": Lino.chars2width(10), "dataIndex": "language", "editor": language5553 }, { "colIndex": 5, "sortable": false, "xtype": "checkcolumn", "header": "Historie", "editable": true, "tooltip": "(cbss.RetrieveTIGroupsRequestsByPerson.history) Whatever this means.", "filter": { "type": "boolean" }, "width": Lino.chars2width(11), "dataIndex": "history" }, { "colIndex": 6, "sortable": true, "header": "Zustand", "editable": false, "tooltip": "(cbss.RetrieveTIGroupsRequestsByPerson.status) ", "filter": { "type": "string" }, "width": Lino.chars2width(13), "dataIndex": "status" }, { "colIndex": 7, "sortable": true, "header": "Ticket", "editable": false, "tooltip": "(cbss.RetrieveTIGroupsRequestsByPerson.ticket) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "ticket" }, { "width": Lino.chars2width(17), "colIndex": 8, "sortable": true, "dataIndex": "sent", "header": "Versendet", "editable": false, "tooltip": "(cbss.RetrieveTIGroupsRequestsByPerson.sent) The date and time when this request has been executed. \nThis is empty for requests than haven't been sent.\nRead-only." }, { "colIndex": 9, "sortable": true, "header": "T/A/B", "editable": false, "tooltip": "(cbss.RetrieveTIGroupsRequestsByPerson.environment) ", "filter": { "type": "string" }, "width": Lino.chars2width(6), "dataIndex": "environment" } ];
    Lino.cbss.RetrieveTIGroupsRequestsByPerson.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.cbss.RetrieveTIGroupsRequestsByPerson.put = function(rp,pk) { 
  Lino.run_row_action(rp,"/cbss/RetrieveTIGroupsRequestsByPerson","GET",pk,"put",null);
};
Lino.cbss.RetrieveTIGroupsRequestsByPerson.post = function(rp,pk) { 
  Lino.run_row_action(rp,"/cbss/RetrieveTIGroupsRequestsByPerson","GET",pk,"post",null);
};

Lino.cbss.RetrieveTIGroupsRequestsByPerson.insertPanel = Ext.extend(Lino.cbss.RetrieveTIGroupsRequests.InsertFormPanel,{
  empty_title: "Neu Tx25-Anfragen",
  hide_navigator: true,
  ls_bbar_actions: [ { "itemId": "post", "menu_item_text": "Erstellen", "tooltip": "Datensatz erstellen und dann im Detail-Fenster \u00f6ffnen", "panel_btn_handler": function(panel){panel.save(null,true,'post')}, "text": "Erstellen", "overflowText": "Erstellen", "auto_save": false }, { "itemId": "poststay", "menu_item_text": "Erstellen ohne Detail", "tooltip": "Nach Erstellen des Datensatzes kein Detail-Fenster \u00f6ffnen", "panel_btn_handler": function(panel){panel.save(null,false,'poststay')}, "text": "Erstellen ohne Detail", "overflowText": "Erstellen ohne Detail", "auto_save": false } ],
  ls_url: "/cbss/RetrieveTIGroupsRequestsByPerson",
  action_name: "insert",
  initComponent : function() {
    this.ls_detail_handler = Lino.cbss.RetrieveTIGroupsRequestsByPerson.detail;
    this.ls_insert_handler = Lino.cbss.RetrieveTIGroupsRequestsByPerson.insert;
    Lino.cbss.RetrieveTIGroupsRequestsByPerson.insertPanel.superclass.initComponent.call(this);
  }
});

Lino.cbss.RetrieveTIGroupsRequestsByPerson.insert = new Lino.WindowAction({ "draggable": true, "width": Lino.chars2width(40), "autoHeight": true, "maximizable": true, "modal": true, "maximized": false },function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.cbss.RetrieveTIGroupsRequestsByPerson.insertPanel(p);
});
Lino.cbss.RetrieveTIGroupsRequestsByPerson.poststay = function(rp,pk) { 
  Lino.run_row_action(rp,"/cbss/RetrieveTIGroupsRequestsByPerson","GET",pk,"poststay",null);
};
Lino.cbss.RetrieveTIGroupsRequestsByPerson.duplicate = function(rp,pk) { 
  Lino.run_row_action(rp,"/cbss/RetrieveTIGroupsRequestsByPerson","GET",pk,"duplicate",null);
};

Lino.cbss.RetrieveTIGroupsRequestsByPerson.detailPanel = Ext.extend(Lino.cbss.RetrieveTIGroupsRequests.DetailFormPanel,{
  empty_title: "Detail Tx25-Anfragen",
  ls_bbar_actions: [ { "itemId": "put", "menu_item_text": "Speichern", "tooltip": "\u00c4nderungen in diesem Formular speichern", "panel_btn_handler": function(panel){panel.save(null,false,'put')}, "iconCls": "x-tbar-save", "overflowText": "Speichern", "auto_save": false }, { "itemId": "insert", "menu_item_text": "Neu", "must_save": true, "tooltip": "Neuen Datensatz erstellen", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-new", "overflowText": "Neu", "auto_save": true }, { "itemId": "duplicate", "menu_item_text": "Duplizieren", "must_save": true, "tooltip": "Duplizieren", "panel_btn_handler": Lino.row_action_handler('duplicate','GET',null), "iconCls": "x-tbar-duplicate", "overflowText": "Duplizieren", "auto_save": true }, { "itemId": null, "menu_item_text": "L\u00f6schen", "tooltip": "Diesen Datensatz l\u00f6schen", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "L\u00f6schen", "auto_save": false }, { "itemId": "do_print", "menu_item_text": "Drucken", "must_save": true, "tooltip": "Drucken", "panel_btn_handler": Lino.row_action_handler('do_print','GET',null), "iconCls": "x-tbar-print", "overflowText": "Drucken", "auto_save": true } ],
  ls_url: "/cbss/RetrieveTIGroupsRequestsByPerson",
  action_name: "detail",
  initComponent : function() {
    this.ls_detail_handler = Lino.cbss.RetrieveTIGroupsRequestsByPerson.detail;
    this.ls_insert_handler = Lino.cbss.RetrieveTIGroupsRequestsByPerson.insert;
    Lino.cbss.RetrieveTIGroupsRequestsByPerson.detailPanel.superclass.initComponent.call(this);
  }
});

Lino.cbss.RetrieveTIGroupsRequestsByPerson.detail = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.cbss.RetrieveTIGroupsRequestsByPerson.detailPanel(p);
});
Lino.cbss.RetrieveTIGroupsRequestsByPerson.do_print = function(rp,pk) { 
  Lino.run_row_action(rp,"/cbss/RetrieveTIGroupsRequestsByPerson","GET",pk,"do_print",null);
};
Lino.cbss.RetrieveTIGroupsRequestsByPerson.edit_template = function(rp,pk) { 
  Lino.run_row_action(rp,"/cbss/RetrieveTIGroupsRequestsByPerson","GET",pk,"edit_template",null);
};
Lino.cbss.RetrieveTIGroupsRequestsByPerson.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.cbss.RetrieveTIGroupsRequestsByPerson.GridPanel(p);
});

// js_render_GridPanel_class cbss.MyRetrieveTIGroupsRequests
Lino.cbss.MyRetrieveTIGroupsRequests.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "Keine Daten anzuzeigen." },
  ls_url : "/cbss/MyRetrieveTIGroupsRequests",
  ls_bbar_actions : [ { "itemId": "insert", "menu_item_text": "Neu", "must_save": true, "tooltip": "Neuen Datensatz erstellen", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-new", "overflowText": "Neu", "auto_save": true }, { "itemId": "duplicate", "menu_item_text": "Duplizieren", "must_save": true, "tooltip": "Duplizieren", "panel_btn_handler": Lino.row_action_handler('duplicate','GET',null), "iconCls": "x-tbar-duplicate", "overflowText": "Duplizieren", "auto_save": true }, { "itemId": "detail", "menu_item_text": "Detail", "tooltip": "Detail-Fenster auf diesem Datensatz \u00f6ffnen", "panel_btn_handler": Lino.show_detail, "iconCls": "x-tbar-detail", "overflowText": "Detail", "auto_save": true }, { "itemId": null, "menu_item_text": "L\u00f6schen", "tooltip": "Diesen Datensatz l\u00f6schen", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "L\u00f6schen", "auto_save": false }, { "itemId": "do_print", "menu_item_text": "Drucken", "must_save": true, "tooltip": "Drucken", "panel_btn_handler": Lino.row_action_handler('do_print','GET',null), "iconCls": "x-tbar-print", "overflowText": "Drucken", "auto_save": true } ],
  title : "Meine Tx25-Anfragen",
  page_length : 20,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "type": "int", "name": "id" }, { "name": "user" }, 'userHidden', { "name": "person" }, 'personHidden', { "name": "national_id" }, { "name": "language" }, 'languageHidden', { "type": "boolean", "name": "history" }, { "name": "status" }, 'statusHidden', { "name": "ticket" }, { "name": "sent" }, { "name": "environment" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 0,
  ls_grid_configs : [  ],
  content_type : 89,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 15,
  initComponent : function() {
    this.ls_detail_handler = Lino.cbss.MyRetrieveTIGroupsRequests.detail;
    this.ls_insert_handler = Lino.cbss.MyRetrieveTIGroupsRequests.insert;
    var ww = this.containing_window;
    var id5560 = new Ext.form.NumberField({ "selectOnFocus": true });
    var user5561 = new Lino.RemoteComboFieldElement({ "preferred_width": 15, "allowBlank": false, "pageSize": 20, "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cbss/MyRetrieveTIGroupsRequests/user", "method": "GET" }) }), "emptyText": "Benutzer ausw\u00e4hlen..." });
    var person5562 = new Lino.RemoteComboFieldElement({ "preferred_width": 20, "allowBlank": false, "pageSize": 20, "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cbss/MyRetrieveTIGroupsRequests/person", "method": "GET" }) }), "emptyText": "Klient ausw\u00e4hlen..." });
    var national_id5563 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var language5564 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "forceSelection": true, "store": [['','<br>']].concat(Lino.cbss.RequestLanguages) });
    var history5565 = new Ext.form.Checkbox({ "selectOnFocus": true, "checked": true });
    var status5566 = new Lino.ChoicesFieldElement({ "disabled": true, "forceSelection": true, "store": [['','<br>']].concat(Lino.cbss.RequestStates) });
    var ticket5567 = new Ext.form.TextField({ "disabled": true, "maxLength": 36 });
    var sent5568 = new Ext.form.DisplayField({ "disabled": true, "value": "<br>" });
    var environment5569 = new Ext.form.TextField({ "disabled": true, "boxMinWidth": Lino.chars2width(4), "maxLength": 4 });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ new Lino.NullNumberColumn({ "colIndex": 0, "sortable": true, "format": "0", "editable": true, "tooltip": "(cbss.MyRetrieveTIGroupsRequests.id) ", "filter": { "type": "numeric" }, "header": "ID", "renderer": Lino.id_renderer, "editor": id5560, "width": Lino.chars2width(6), "dataIndex": "id" }), { "colIndex": 1, "sortable": true, "header": "Autor", "editable": true, "tooltip": "(cbss.MyRetrieveTIGroupsRequests.user) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "user", "editor": user5561 }, { "colIndex": 2, "sortable": true, "header": "Klient", "editable": true, "tooltip": "(cbss.MyRetrieveTIGroupsRequests.person) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "person", "editor": person5562 }, { "colIndex": 3, "sortable": true, "header": "NR-Nummer", "editable": true, "tooltip": "(cbss.MyRetrieveTIGroupsRequests.national_id) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "national_id", "editor": national_id5563 }, { "colIndex": 4, "sortable": true, "header": "Sprache", "editable": true, "tooltip": "(cbss.MyRetrieveTIGroupsRequests.language) ", "filter": { "type": "string" }, "width": Lino.chars2width(10), "dataIndex": "language", "editor": language5564 }, { "colIndex": 5, "sortable": false, "xtype": "checkcolumn", "header": "Historie", "editable": true, "tooltip": "(cbss.MyRetrieveTIGroupsRequests.history) Whatever this means.", "filter": { "type": "boolean" }, "width": Lino.chars2width(11), "dataIndex": "history" }, { "colIndex": 6, "sortable": true, "header": "Zustand", "editable": false, "tooltip": "(cbss.MyRetrieveTIGroupsRequests.status) ", "filter": { "type": "string" }, "width": Lino.chars2width(13), "dataIndex": "status" }, { "colIndex": 7, "sortable": true, "header": "Ticket", "editable": false, "tooltip": "(cbss.MyRetrieveTIGroupsRequests.ticket) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "ticket" }, { "width": Lino.chars2width(17), "colIndex": 8, "sortable": true, "dataIndex": "sent", "header": "Versendet", "editable": false, "tooltip": "(cbss.MyRetrieveTIGroupsRequests.sent) The date and time when this request has been executed. \nThis is empty for requests than haven't been sent.\nRead-only." }, { "colIndex": 9, "sortable": true, "header": "T/A/B", "editable": false, "tooltip": "(cbss.MyRetrieveTIGroupsRequests.environment) ", "filter": { "type": "string" }, "width": Lino.chars2width(6), "dataIndex": "environment" } ];
    Lino.cbss.MyRetrieveTIGroupsRequests.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.cbss.MyRetrieveTIGroupsRequests.put = function(rp,pk) { 
  Lino.run_row_action(rp,"/cbss/MyRetrieveTIGroupsRequests","GET",pk,"put",null);
};
Lino.cbss.MyRetrieveTIGroupsRequests.post = function(rp,pk) { 
  Lino.run_row_action(rp,"/cbss/MyRetrieveTIGroupsRequests","GET",pk,"post",null);
};

Lino.cbss.MyRetrieveTIGroupsRequests.insertPanel = Ext.extend(Lino.cbss.RetrieveTIGroupsRequests.InsertFormPanel,{
  empty_title: "Neu Meine Tx25-Anfragen",
  hide_navigator: true,
  ls_bbar_actions: [ { "itemId": "post", "menu_item_text": "Erstellen", "tooltip": "Datensatz erstellen und dann im Detail-Fenster \u00f6ffnen", "panel_btn_handler": function(panel){panel.save(null,true,'post')}, "text": "Erstellen", "overflowText": "Erstellen", "auto_save": false }, { "itemId": "poststay", "menu_item_text": "Erstellen ohne Detail", "tooltip": "Nach Erstellen des Datensatzes kein Detail-Fenster \u00f6ffnen", "panel_btn_handler": function(panel){panel.save(null,false,'poststay')}, "text": "Erstellen ohne Detail", "overflowText": "Erstellen ohne Detail", "auto_save": false } ],
  ls_url: "/cbss/MyRetrieveTIGroupsRequests",
  action_name: "insert",
  initComponent : function() {
    this.ls_detail_handler = Lino.cbss.MyRetrieveTIGroupsRequests.detail;
    this.ls_insert_handler = Lino.cbss.MyRetrieveTIGroupsRequests.insert;
    Lino.cbss.MyRetrieveTIGroupsRequests.insertPanel.superclass.initComponent.call(this);
  }
});

Lino.cbss.MyRetrieveTIGroupsRequests.insert = new Lino.WindowAction({ "draggable": true, "width": Lino.chars2width(40), "autoHeight": true, "maximizable": true, "modal": true, "maximized": false },function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.cbss.MyRetrieveTIGroupsRequests.insertPanel(p);
});
Lino.cbss.MyRetrieveTIGroupsRequests.poststay = function(rp,pk) { 
  Lino.run_row_action(rp,"/cbss/MyRetrieveTIGroupsRequests","GET",pk,"poststay",null);
};
Lino.cbss.MyRetrieveTIGroupsRequests.duplicate = function(rp,pk) { 
  Lino.run_row_action(rp,"/cbss/MyRetrieveTIGroupsRequests","GET",pk,"duplicate",null);
};

Lino.cbss.MyRetrieveTIGroupsRequests.detailPanel = Ext.extend(Lino.cbss.RetrieveTIGroupsRequests.DetailFormPanel,{
  empty_title: "Detail Meine Tx25-Anfragen",
  ls_bbar_actions: [ { "itemId": "put", "menu_item_text": "Speichern", "tooltip": "\u00c4nderungen in diesem Formular speichern", "panel_btn_handler": function(panel){panel.save(null,false,'put')}, "iconCls": "x-tbar-save", "overflowText": "Speichern", "auto_save": false }, { "itemId": "insert", "menu_item_text": "Neu", "must_save": true, "tooltip": "Neuen Datensatz erstellen", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-new", "overflowText": "Neu", "auto_save": true }, { "itemId": "duplicate", "menu_item_text": "Duplizieren", "must_save": true, "tooltip": "Duplizieren", "panel_btn_handler": Lino.row_action_handler('duplicate','GET',null), "iconCls": "x-tbar-duplicate", "overflowText": "Duplizieren", "auto_save": true }, { "itemId": null, "menu_item_text": "L\u00f6schen", "tooltip": "Diesen Datensatz l\u00f6schen", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "L\u00f6schen", "auto_save": false }, { "itemId": "do_print", "menu_item_text": "Drucken", "must_save": true, "tooltip": "Drucken", "panel_btn_handler": Lino.row_action_handler('do_print','GET',null), "iconCls": "x-tbar-print", "overflowText": "Drucken", "auto_save": true } ],
  ls_url: "/cbss/MyRetrieveTIGroupsRequests",
  action_name: "detail",
  initComponent : function() {
    this.ls_detail_handler = Lino.cbss.MyRetrieveTIGroupsRequests.detail;
    this.ls_insert_handler = Lino.cbss.MyRetrieveTIGroupsRequests.insert;
    Lino.cbss.MyRetrieveTIGroupsRequests.detailPanel.superclass.initComponent.call(this);
  }
});

Lino.cbss.MyRetrieveTIGroupsRequests.detail = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.cbss.MyRetrieveTIGroupsRequests.detailPanel(p);
});
Lino.cbss.MyRetrieveTIGroupsRequests.do_print = function(rp,pk) { 
  Lino.run_row_action(rp,"/cbss/MyRetrieveTIGroupsRequests","GET",pk,"do_print",null);
};
Lino.cbss.MyRetrieveTIGroupsRequests.edit_template = function(rp,pk) { 
  Lino.run_row_action(rp,"/cbss/MyRetrieveTIGroupsRequests","GET",pk,"edit_template",null);
};
Lino.cbss.MyRetrieveTIGroupsRequests.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.cbss.MyRetrieveTIGroupsRequests.GridPanel(p);
});

// js_render_GridPanel_class uploads.UploadsByController
Lino.uploads.UploadsByController.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "Keine Daten anzuzeigen." },
  ls_url : "/uploads/UploadsByController",
  ls_bbar_actions : [ { "itemId": "insert", "menu_item_text": "Neu", "must_save": true, "tooltip": "Neuen Datensatz erstellen", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-new", "overflowText": "Neu", "auto_save": true }, { "itemId": "detail", "menu_item_text": "Detail", "tooltip": "Detail-Fenster auf diesem Datensatz \u00f6ffnen", "panel_btn_handler": Lino.show_detail, "iconCls": "x-tbar-detail", "overflowText": "Detail", "auto_save": true }, { "itemId": null, "menu_item_text": "L\u00f6schen", "tooltip": "Diesen Datensatz l\u00f6schen", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "L\u00f6schen", "auto_save": false } ],
  title : "Uploads",
  page_length : 20,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "name": "file" }, { "name": "type" }, 'typeHidden', { "name": "description" }, { "name": "user" }, 'userHidden', { "type": "int", "name": "id" }, { "name": "owner_type" }, 'owner_typeHidden', { "name": "owner_id" }, 'owner_idHidden', { "name": "created" }, { "name": "modified" }, { "name": "mimetype" }, { "type": "date", "name": "valid_until", "dateFormat": "d.m.Y" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 6,
  ls_grid_configs : [  ],
  content_type : 25,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 16,
  initComponent : function() {
    this.ls_detail_handler = Lino.uploads.UploadsByController.detail;
    this.ls_insert_handler = Lino.uploads.UploadsByController.insert;
    var ww = this.containing_window;
    var file5571 = Lino.file_field_handler(this,{ "selectOnFocus": true, "allowBlank": false, "maxLength": 100 });
    var type5572 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/uploads/UploadsByController/type", "method": "GET" }) }), "pageSize": 20, "emptyText": "Upload-Art ausw\u00e4hlen..." });
    var description5573 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var user5574 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "preferred_width": 15, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/uploads/UploadsByController/user", "method": "GET" }) }), "pageSize": 20, "emptyText": "Benutzer ausw\u00e4hlen..." });
    var id5575 = new Ext.form.NumberField({ "selectOnFocus": true });
    var owner_type5576 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/uploads/UploadsByController/owner_type", "method": "GET" }) }), "pageSize": 20, "emptyText": "Inhaltstyp ausw\u00e4hlen..." });
    var owner_id5577 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/uploads/UploadsByController/owner_id", "method": "GET" }) }) });
    var created5578 = new Ext.form.DisplayField({ "disabled": true, "value": "<br>" });
    var modified5579 = new Ext.form.DisplayField({ "disabled": true, "value": "<br>" });
    var mimetype5580 = new Ext.form.TextField({ "disabled": true, "maxLength": 64 });
    var valid_until5581 = new Lino.DateField({ "selectOnFocus": true });
    this.before_row_edit = function(record) {
      owner_id5577.setContextValue('owner_type',record ? record.data['owner_typeHidden'] : undefined);
    };
    this.onRender = function(ct, position) {
      owner_type5576.on('change',Lino.chooser_handler(owner_id5577,'owner_type'));
      Lino.uploads.UploadsByController.GridPanel.superclass.onRender.call(this, ct, position);
    }
    this.ls_columns = [ { "colIndex": 0, "sortable": true, "header": "File", "editable": true, "tooltip": "(uploads.UploadsByController.file) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "file", "editor": file5571 }, { "colIndex": 1, "sortable": true, "header": "Upload-Art", "editable": true, "tooltip": "(uploads.UploadsByController.type) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "type", "editor": type5572 }, { "colIndex": 2, "sortable": true, "header": "Beschreibung", "editable": true, "tooltip": "(uploads.UploadsByController.description) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "description", "editor": description5573 }, { "colIndex": 3, "sortable": true, "header": "Autor", "editable": true, "tooltip": "(uploads.UploadsByController.user) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "user", "editor": user5574 }, new Lino.NullNumberColumn({ "colIndex": 4, "sortable": true, "format": "0", "editable": true, "tooltip": "(uploads.UploadsByController.id) ", "filter": { "type": "numeric" }, "header": "ID", "renderer": Lino.id_renderer, "editor": id5575, "width": Lino.chars2width(6), "dataIndex": "id" }), { "colIndex": 5, "sortable": true, "header": "Verkn\u00fcpft mit (Modell)", "editable": true, "tooltip": "(uploads.UploadsByController.owner_type) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "owner_type", "editor": owner_type5576 }, { "colIndex": 6, "sortable": true, "header": "Verkn\u00fcpft mit (Objekt)", "editable": true, "tooltip": "(uploads.UploadsByController.owner_id) ", "filter": { "type": "string" }, "width": Lino.chars2width(11), "dataIndex": "owner_id", "editor": owner_id5577 }, { "width": Lino.chars2width(17), "colIndex": 7, "sortable": true, "dataIndex": "created", "header": "Erstellt", "editable": false, "tooltip": "(uploads.UploadsByController.created) " }, { "width": Lino.chars2width(17), "colIndex": 8, "sortable": true, "dataIndex": "modified", "header": "Bearbeitet", "editable": false, "tooltip": "(uploads.UploadsByController.modified) " }, { "colIndex": 9, "sortable": true, "header": "MIME type", "editable": false, "tooltip": "(uploads.UploadsByController.mimetype) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "mimetype" }, { "colIndex": 10, "sortable": true, "xtype": "datecolumn", "format": "d.m.Y", "editable": true, "tooltip": "(uploads.UploadsByController.valid_until) ", "filter": { "type": "date", "dateFormat": "d.m.Y" }, "header": "g\u00fcltig bis", "dataIndex": "valid_until", "width": Lino.chars2width(9), "editor": valid_until5581 } ];
    Lino.uploads.UploadsByController.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.uploads.UploadsByController.put = function(rp,pk) { 
  Lino.run_row_action(rp,"/uploads/UploadsByController","GET",pk,"put",null);
};
Lino.uploads.UploadsByController.post = function(rp,pk) { 
  Lino.run_row_action(rp,"/uploads/UploadsByController","GET",pk,"post",null);
};

Lino.uploads.UploadsByController.insertPanel = Ext.extend(Lino.uploads.MyUploads.InsertFormPanel,{
  empty_title: "Neu Uploads",
  hide_navigator: true,
  ls_bbar_actions: [ { "itemId": "post", "menu_item_text": "Erstellen", "tooltip": "Datensatz erstellen und dann im Detail-Fenster \u00f6ffnen", "panel_btn_handler": function(panel){panel.save(null,true,'post')}, "text": "Erstellen", "overflowText": "Erstellen", "auto_save": false }, { "itemId": "poststay", "menu_item_text": "Erstellen ohne Detail", "tooltip": "Nach Erstellen des Datensatzes kein Detail-Fenster \u00f6ffnen", "panel_btn_handler": function(panel){panel.save(null,false,'poststay')}, "text": "Erstellen ohne Detail", "overflowText": "Erstellen ohne Detail", "auto_save": false } ],
  ls_url: "/uploads/UploadsByController",
  action_name: "insert",
  initComponent : function() {
    this.ls_detail_handler = Lino.uploads.UploadsByController.detail;
    this.ls_insert_handler = Lino.uploads.UploadsByController.insert;
    Lino.uploads.UploadsByController.insertPanel.superclass.initComponent.call(this);
  }
});

Lino.uploads.UploadsByController.insert = new Lino.WindowAction({ "draggable": true, "width": Lino.chars2width(60), "autoHeight": true, "maximizable": true, "modal": true, "maximized": false },function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.uploads.UploadsByController.insertPanel(p);
});
Lino.uploads.UploadsByController.poststay = function(rp,pk) { 
  Lino.run_row_action(rp,"/uploads/UploadsByController","GET",pk,"poststay",null);
};

Lino.uploads.UploadsByController.detailPanel = Ext.extend(Lino.uploads.MyUploads.DetailFormPanel,{
  empty_title: "Detail Uploads",
  ls_bbar_actions: [ { "itemId": "put", "menu_item_text": "Speichern", "tooltip": "\u00c4nderungen in diesem Formular speichern", "panel_btn_handler": function(panel){panel.save(null,false,'put')}, "iconCls": "x-tbar-save", "overflowText": "Speichern", "auto_save": false }, { "itemId": "insert", "menu_item_text": "Neu", "must_save": true, "tooltip": "Neuen Datensatz erstellen", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-new", "overflowText": "Neu", "auto_save": true }, { "itemId": null, "menu_item_text": "L\u00f6schen", "tooltip": "Diesen Datensatz l\u00f6schen", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "L\u00f6schen", "auto_save": false } ],
  ls_url: "/uploads/UploadsByController",
  action_name: "detail",
  initComponent : function() {
    this.ls_detail_handler = Lino.uploads.UploadsByController.detail;
    this.ls_insert_handler = Lino.uploads.UploadsByController.insert;
    Lino.uploads.UploadsByController.detailPanel.superclass.initComponent.call(this);
  }
});

Lino.uploads.UploadsByController.detail = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.uploads.UploadsByController.detailPanel(p);
});
Lino.uploads.UploadsByController.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.uploads.UploadsByController.GridPanel(p);
});

// js_render_GridPanel_class outbox.MailsByController
Lino.outbox.MailsByController.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "Keine Daten anzuzeigen." },
  ls_url : "/outbox/MailsByController",
  ls_bbar_actions : [ { "itemId": "insert", "menu_item_text": "Neu", "must_save": true, "tooltip": "Neuen Datensatz erstellen", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-new", "overflowText": "Neu", "auto_save": true }, { "itemId": "detail", "menu_item_text": "Detail", "tooltip": "Detail-Fenster auf diesem Datensatz \u00f6ffnen", "panel_btn_handler": Lino.show_detail, "iconCls": "x-tbar-detail", "overflowText": "Detail", "auto_save": true }, { "itemId": null, "menu_item_text": "L\u00f6schen", "tooltip": "Diesen Datensatz l\u00f6schen", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "L\u00f6schen", "auto_save": false }, { "itemId": "do_print", "menu_item_text": "Drucken", "must_save": true, "tooltip": "Drucken", "panel_btn_handler": Lino.row_action_handler('do_print','GET',null), "iconCls": "x-tbar-print", "overflowText": "Drucken", "auto_save": true }, { "itemId": "send_mail", "menu_item_text": "E-Mail senden", "must_save": true, "tooltip": "E-Mail senden", "panel_btn_handler": Lino.row_action_handler('send_mail','GET',null), "iconCls": "x-tbar-email_send", "overflowText": "E-Mail senden", "auto_save": true } ],
  title : "E-Mail-Ausg\u00e4nge",
  page_length : 20,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "name": "sent" }, { "name": "recipients" }, { "name": "subject" }, { "type": "int", "name": "id" }, { "name": "owner_type" }, 'owner_typeHidden', { "name": "owner_id" }, 'owner_idHidden', { "name": "user" }, 'userHidden', { "name": "project" }, 'projectHidden', { "type": "date", "name": "date", "dateFormat": "d.m.Y" }, { "name": "body" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 3,
  ls_grid_configs : [  ],
  content_type : 26,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 15,
  initComponent : function() {
    this.ls_detail_handler = Lino.outbox.MailsByController.detail;
    this.ls_insert_handler = Lino.outbox.MailsByController.insert;
    var ww = this.containing_window;
    var sent943 = new Ext.form.DisplayField({ "disabled": true, "value": "<br>" });
    var recipients_htmlbox944 = new Lino.HtmlBoxPanel({ "layout": "fit", "name": "recipients", "containing_panel": this, "items": new Ext.BoxComponent({autoScroll:true}), "title": "Empf\u00e4nger", "master_panel": this, "value": "<br/>", "always_enabled": true, "bodyStyle": "overflow-x:hidden;" });
    var subject945 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var id946 = new Ext.form.NumberField({ "selectOnFocus": true });
    var owner_type947 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/outbox/MailsByController/owner_type", "method": "GET" }) }), "pageSize": 20, "emptyText": "Inhaltstyp ausw\u00e4hlen..." });
    var owner_id948 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/outbox/MailsByController/owner_id", "method": "GET" }) }) });
    var user949 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "preferred_width": 15, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/outbox/MailsByController/user", "method": "GET" }) }), "pageSize": 20, "emptyText": "Benutzer ausw\u00e4hlen..." });
    var project950 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "preferred_width": 20, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/outbox/MailsByController/project", "method": "GET" }) }), "pageSize": 20, "emptyText": "Klient ausw\u00e4hlen..." });
    var date951 = new Lino.DateField({ "selectOnFocus": true, "allowBlank": false });
    var body952 = new Lino.RichTextPanel({ "selectOnFocus": true, "containing_panel": this, "title": "Inhalt" });
    this.before_row_edit = function(record) {
      recipients_htmlbox944.refresh();
      owner_id948.setContextValue('owner_type',record ? record.data['owner_typeHidden'] : undefined);
      body952.refresh();
    };
    this.onRender = function(ct, position) {
      owner_type947.on('change',Lino.chooser_handler(owner_id948,'owner_type'));
      Lino.outbox.MailsByController.GridPanel.superclass.onRender.call(this, ct, position);
    }
    this.ls_columns = [ { "width": Lino.chars2width(17), "colIndex": 0, "sortable": true, "dataIndex": "sent", "header": "sent", "editable": false, "tooltip": "(outbox.MailsByController.sent) " }, { "width": Lino.chars2width(31), "colIndex": 1, "sortable": false, "dataIndex": "recipients", "header": "Empf\u00e4nger", "editable": false, "tooltip": "(outbox.MailsByController.recipients) " }, { "colIndex": 2, "sortable": true, "header": "Betreff", "editable": true, "tooltip": "(outbox.MailsByController.subject) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "subject", "editor": subject945 }, new Lino.NullNumberColumn({ "colIndex": 3, "sortable": true, "format": "0", "editable": true, "tooltip": "(outbox.MailsByController.id) ", "filter": { "type": "numeric" }, "header": "ID", "renderer": Lino.id_renderer, "editor": id946, "width": Lino.chars2width(6), "dataIndex": "id" }), { "colIndex": 4, "sortable": true, "header": "Verkn\u00fcpft mit (Modell)", "editable": true, "tooltip": "(outbox.MailsByController.owner_type) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "owner_type", "editor": owner_type947 }, { "colIndex": 5, "sortable": true, "header": "Verkn\u00fcpft mit (Objekt)", "editable": true, "tooltip": "(outbox.MailsByController.owner_id) ", "filter": { "type": "string" }, "width": Lino.chars2width(11), "dataIndex": "owner_id", "editor": owner_id948 }, { "colIndex": 6, "sortable": true, "header": "Absender", "editable": true, "tooltip": "(outbox.MailsByController.user) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "user", "editor": user949 }, { "colIndex": 7, "sortable": true, "header": "Klient", "editable": true, "tooltip": "(outbox.MailsByController.project) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "project", "editor": project950 }, { "colIndex": 8, "sortable": true, "xtype": "datecolumn", "format": "d.m.Y", "editable": true, "tooltip": "(outbox.MailsByController.date) \n        The official date to be printed on the document.\n        ", "filter": { "type": "date", "dateFormat": "d.m.Y" }, "header": "Datum", "dataIndex": "date", "width": Lino.chars2width(9), "editor": date951 }, { "colIndex": 9, "sortable": false, "width": Lino.chars2width(61), "editable": true, "tooltip": "(outbox.MailsByController.body) ", "filter": { "type": "string" }, "header": "body", "renderer": Lino.text_renderer, "hidden": true, "editor": body952, "dataIndex": "body" } ];
    Lino.outbox.MailsByController.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.outbox.MailsByController.put = function(rp,pk) { 
  Lino.run_row_action(rp,"/outbox/MailsByController","GET",pk,"put",null);
};
Lino.outbox.MailsByController.post = function(rp,pk) { 
  Lino.run_row_action(rp,"/outbox/MailsByController","GET",pk,"post",null);
};

Lino.outbox.MailsByController.insertPanel = Ext.extend(Lino.outbox.MailsByUser.InsertFormPanel,{
  empty_title: "Neu E-Mail-Ausg\u00e4nge",
  hide_navigator: true,
  ls_bbar_actions: [ { "itemId": "post", "menu_item_text": "Erstellen", "tooltip": "Datensatz erstellen und dann im Detail-Fenster \u00f6ffnen", "panel_btn_handler": function(panel){panel.save(null,true,'post')}, "text": "Erstellen", "overflowText": "Erstellen", "auto_save": false }, { "itemId": "poststay", "menu_item_text": "Erstellen ohne Detail", "tooltip": "Nach Erstellen des Datensatzes kein Detail-Fenster \u00f6ffnen", "panel_btn_handler": function(panel){panel.save(null,false,'poststay')}, "text": "Erstellen ohne Detail", "overflowText": "Erstellen ohne Detail", "auto_save": false } ],
  ls_url: "/outbox/MailsByController",
  action_name: "insert",
  initComponent : function() {
    this.ls_detail_handler = Lino.outbox.MailsByController.detail;
    this.ls_insert_handler = Lino.outbox.MailsByController.insert;
    Lino.outbox.MailsByController.insertPanel.superclass.initComponent.call(this);
  }
});

Lino.outbox.MailsByController.insert = new Lino.WindowAction({ "draggable": true, "width": Lino.chars2width(60), "maximizable": true, "modal": true, "maximized": false, "height": Lino.rows2height(20) },function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.outbox.MailsByController.insertPanel(p);
});
Lino.outbox.MailsByController.poststay = function(rp,pk) { 
  Lino.run_row_action(rp,"/outbox/MailsByController","GET",pk,"poststay",null);
};

Lino.outbox.MailsByController.detailPanel = Ext.extend(Lino.outbox.MailsByUser.DetailFormPanel,{
  empty_title: "Detail E-Mail-Ausg\u00e4nge",
  ls_bbar_actions: [ { "itemId": "put", "menu_item_text": "Speichern", "tooltip": "\u00c4nderungen in diesem Formular speichern", "panel_btn_handler": function(panel){panel.save(null,false,'put')}, "iconCls": "x-tbar-save", "overflowText": "Speichern", "auto_save": false }, { "itemId": "insert", "menu_item_text": "Neu", "must_save": true, "tooltip": "Neuen Datensatz erstellen", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-new", "overflowText": "Neu", "auto_save": true }, { "itemId": null, "menu_item_text": "L\u00f6schen", "tooltip": "Diesen Datensatz l\u00f6schen", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "L\u00f6schen", "auto_save": false }, { "itemId": "do_print", "menu_item_text": "Drucken", "must_save": true, "tooltip": "Drucken", "panel_btn_handler": Lino.row_action_handler('do_print','GET',null), "iconCls": "x-tbar-print", "overflowText": "Drucken", "auto_save": true }, { "itemId": "send_mail", "menu_item_text": "E-Mail senden", "must_save": true, "tooltip": "E-Mail senden", "panel_btn_handler": Lino.row_action_handler('send_mail','GET',null), "iconCls": "x-tbar-email_send", "overflowText": "E-Mail senden", "auto_save": true } ],
  ls_url: "/outbox/MailsByController",
  action_name: "detail",
  initComponent : function() {
    this.ls_detail_handler = Lino.outbox.MailsByController.detail;
    this.ls_insert_handler = Lino.outbox.MailsByController.insert;
    Lino.outbox.MailsByController.detailPanel.superclass.initComponent.call(this);
  }
});

Lino.outbox.MailsByController.detail = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.outbox.MailsByController.detailPanel(p);
});
Lino.outbox.MailsByController.do_print = function(rp,pk) { 
  Lino.run_row_action(rp,"/outbox/MailsByController","GET",pk,"do_print",null);
};
Lino.outbox.MailsByController.edit_template = function(rp,pk) { 
  Lino.run_row_action(rp,"/outbox/MailsByController","GET",pk,"edit_template",null);
};
Lino.outbox.MailsByController.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.outbox.MailsByController.GridPanel(p);
});
Lino.outbox.MailsByController.send_mail = function(rp,pk) { 
  Lino.run_row_action(rp,"/outbox/MailsByController","GET",pk,"send_mail",null);
};

// js_render_GridPanel_class changes.ChangesByMaster
Lino.changes.ChangesByMaster.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "Keine Daten anzuzeigen." },
  ls_url : "/changes/ChangesByMaster",
  ls_bbar_actions : [ { "itemId": "insert", "menu_item_text": "Neu", "must_save": true, "tooltip": "Neuen Datensatz erstellen", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-new", "overflowText": "Neu", "auto_save": true }, { "itemId": "detail", "menu_item_text": "Detail", "tooltip": "Detail-Fenster auf diesem Datensatz \u00f6ffnen", "panel_btn_handler": Lino.show_detail, "iconCls": "x-tbar-detail", "overflowText": "Detail", "auto_save": true }, { "itemId": null, "menu_item_text": "L\u00f6schen", "tooltip": "Diesen Datensatz l\u00f6schen", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "L\u00f6schen", "auto_save": false } ],
  title : "\u00c4nderungen",
  page_length : 20,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "name": "time" }, { "name": "user" }, 'userHidden', { "name": "type" }, 'typeHidden', { "name": "object" }, { "name": "diff" }, { "name": "object_type" }, 'object_typeHidden', { "name": "object_id" }, 'object_idHidden', { "type": "int", "name": "id" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 11,
  ls_grid_configs : [  ],
  content_type : 10,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 13,
  initComponent : function() {
    this.ls_detail_handler = Lino.changes.ChangesByMaster.detail;
    this.ls_insert_handler = Lino.changes.ChangesByMaster.insert;
    var ww = this.containing_window;
    var time605 = new Ext.form.DisplayField({ "selectOnFocus": true, "allowBlank": false, "value": "<br>" });
    var user606 = new Lino.RemoteComboFieldElement({ "preferred_width": 15, "allowBlank": false, "pageSize": 20, "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/changes/ChangesByMaster/user", "method": "GET" }) }), "emptyText": "Benutzer ausw\u00e4hlen..." });
    var type607 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "forceSelection": true, "allowBlank": false, "store": Lino.lino.ChangeTypes });
    var object_disp608 = new Ext.form.DisplayField({ "disabled": true });
    var diff609 = new Ext.form.TextArea({ "selectOnFocus": true, "growMax": 2000 });
    var object_type610 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/changes/ChangesByMaster/object_type", "method": "GET" }) }), "allowBlank": false, "pageSize": 20, "emptyText": "Inhaltstyp ausw\u00e4hlen..." });
    var object_id611 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "allowBlank": false, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/changes/ChangesByMaster/object_id", "method": "GET" }) }) });
    this.before_row_edit = function(record) {
      object_id611.setContextValue('object_type',record ? record.data['object_typeHidden'] : undefined);
    };
    this.onRender = function(ct, position) {
      object_type610.on('change',Lino.chooser_handler(object_id611,'object_type'));
      Lino.changes.ChangesByMaster.GridPanel.superclass.onRender.call(this, ct, position);
    }
    this.ls_columns = [ { "colIndex": 0, "sortable": true, "header": "time", "editable": true, "tooltip": "(changes.ChangesByMaster.time) ", "width": Lino.chars2width(17), "dataIndex": "time", "editor": time605 }, { "colIndex": 1, "sortable": true, "header": "Benutzer", "editable": true, "tooltip": "(changes.ChangesByMaster.user) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "user", "editor": user606 }, { "colIndex": 2, "sortable": true, "header": "\u00c4nderungsart", "editable": true, "tooltip": "(changes.ChangesByMaster.type) ", "filter": { "type": "string" }, "width": Lino.chars2width(16), "dataIndex": "type", "editor": type607 }, { "width": Lino.chars2width(11), "colIndex": 3, "sortable": false, "dataIndex": "object", "header": "Object", "editable": false, "tooltip": "(changes.ChangesByMaster.object) " }, { "colIndex": 4, "sortable": false, "header": "\u00c4nderungen", "editable": true, "tooltip": "(changes.ChangesByMaster.diff) ", "filter": { "type": "string" }, "width": Lino.chars2width(61), "renderer": Lino.text_renderer, "editor": diff609, "dataIndex": "diff" }, { "colIndex": 5, "sortable": true, "header": "Object type", "editable": true, "tooltip": "(changes.ChangesByMaster.object_type) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "object_type", "editor": object_type610 }, { "colIndex": 6, "sortable": true, "header": "object id", "editable": true, "tooltip": "(changes.ChangesByMaster.object_id) ", "filter": { "type": "string" }, "width": Lino.chars2width(11), "dataIndex": "object_id", "editor": object_id611 } ];
    Lino.changes.ChangesByMaster.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.changes.ChangesByMaster.put = function(rp,pk) { 
  Lino.run_row_action(rp,"/changes/ChangesByMaster","GET",pk,"put",null);
};
Lino.changes.ChangesByMaster.post = function(rp,pk) { 
  Lino.run_row_action(rp,"/changes/ChangesByMaster","GET",pk,"post",null);
};

Lino.changes.ChangesByMaster.insertPanel = Ext.extend(Lino.changes.ChangesByMaster.DetailFormPanel,{
  empty_title: "Neu \u00c4nderungen",
  hide_navigator: true,
  ls_bbar_actions: [ { "itemId": "post", "menu_item_text": "Erstellen", "tooltip": "Datensatz erstellen und dann im Detail-Fenster \u00f6ffnen", "panel_btn_handler": function(panel){panel.save(null,true,'post')}, "text": "Erstellen", "overflowText": "Erstellen", "auto_save": false }, { "itemId": "poststay", "menu_item_text": "Erstellen ohne Detail", "tooltip": "Nach Erstellen des Datensatzes kein Detail-Fenster \u00f6ffnen", "panel_btn_handler": function(panel){panel.save(null,false,'poststay')}, "text": "Erstellen ohne Detail", "overflowText": "Erstellen ohne Detail", "auto_save": false } ],
  ls_url: "/changes/ChangesByMaster",
  action_name: "insert",
  initComponent : function() {
    this.ls_detail_handler = Lino.changes.ChangesByMaster.detail;
    this.ls_insert_handler = Lino.changes.ChangesByMaster.insert;
    Lino.changes.ChangesByMaster.insertPanel.superclass.initComponent.call(this);
  }
});

Lino.changes.ChangesByMaster.insert = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.changes.ChangesByMaster.insertPanel(p);
});
Lino.changes.ChangesByMaster.poststay = function(rp,pk) { 
  Lino.run_row_action(rp,"/changes/ChangesByMaster","GET",pk,"poststay",null);
};

Lino.changes.ChangesByMaster.detailPanel = Ext.extend(Lino.changes.ChangesByMaster.DetailFormPanel,{
  empty_title: "Detail \u00c4nderungen",
  ls_bbar_actions: [ { "itemId": "put", "menu_item_text": "Speichern", "tooltip": "\u00c4nderungen in diesem Formular speichern", "panel_btn_handler": function(panel){panel.save(null,false,'put')}, "iconCls": "x-tbar-save", "overflowText": "Speichern", "auto_save": false }, { "itemId": "insert", "menu_item_text": "Neu", "must_save": true, "tooltip": "Neuen Datensatz erstellen", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-new", "overflowText": "Neu", "auto_save": true }, { "itemId": null, "menu_item_text": "L\u00f6schen", "tooltip": "Diesen Datensatz l\u00f6schen", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "L\u00f6schen", "auto_save": false } ],
  ls_url: "/changes/ChangesByMaster",
  action_name: "detail",
  initComponent : function() {
    this.ls_detail_handler = Lino.changes.ChangesByMaster.detail;
    this.ls_insert_handler = Lino.changes.ChangesByMaster.insert;
    Lino.changes.ChangesByMaster.detailPanel.superclass.initComponent.call(this);
  }
});

Lino.changes.ChangesByMaster.detail = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.changes.ChangesByMaster.detailPanel(p);
});
Lino.changes.ChangesByMaster.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.changes.ChangesByMaster.GridPanel(p);
});

// js_render_GridPanel_class about.Models
Lino.about.Models.GridPanel = Ext.extend(Lino.GridPanel,{
  ls_url : "/about/Models",
  ls_bbar_actions : [ { "itemId": "detail", "menu_item_text": "Detail", "tooltip": "Detail-Fenster auf diesem Datensatz \u00f6ffnen", "panel_btn_handler": Lino.show_detail, "iconCls": "x-tbar-detail", "overflowText": "Detail", "auto_save": true } ],
  title : "Models",
  page_length : 20,
  gc_name : 0,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "name": "app" }, { "name": "name" }, { "name": "docstring" }, { "name": "rows" }, { "name": "detail_action" }, { "name": "disabled_fields" }, { "name": "disabled_actions" } ],
  ls_grid_configs : [  ],
  viewConfig : { "emptyText": "Keine Daten anzuzeigen." },
  disable_editing : true,
  disabled_actions_index : 6,
  initComponent : function() {
    this.ls_detail_handler = Lino.about.Models.detail;
    var ww = this.containing_window;
    var app_disp5588 = new Ext.form.DisplayField({ "disabled": true, "value": "<br/>", "always_enabled": true });
    var name_disp5589 = new Ext.form.DisplayField({ "disabled": true, "value": "<br/>", "always_enabled": true });
    var docstring_disp5590 = new Ext.form.DisplayField({ "disabled": true, "value": "<br/>", "always_enabled": true });
    var rows5591 = new Ext.form.NumberField({ "disabled": true });
    var detail_action_disp5592 = new Ext.form.DisplayField({ "disabled": true, "value": "<br/>", "always_enabled": true });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ { "width": Lino.chars2width(31), "colIndex": 0, "sortable": false, "dataIndex": "app", "header": "app_label", "editable": false, "tooltip": "(about.Models.app) " }, { "width": Lino.chars2width(31), "colIndex": 1, "sortable": false, "dataIndex": "name", "header": "name", "editable": false, "tooltip": "(about.Models.name) " }, { "width": Lino.chars2width(31), "colIndex": 2, "sortable": false, "dataIndex": "docstring", "header": "docstring", "editable": false, "tooltip": "(about.Models.docstring) " }, new Lino.NullNumberColumn({ "colIndex": 3, "sortable": false, "format": "0", "editable": false, "tooltip": "(about.Models.rows) ", "header": "Zeilen", "dataIndex": "rows", "width": Lino.chars2width(6) }), { "width": Lino.chars2width(31), "colIndex": 4, "sortable": false, "dataIndex": "detail_action", "header": "detail_action", "editable": false, "tooltip": "(about.Models.detail_action) " } ];
    Lino.about.Models.GridPanel.superclass.initComponent.call(this);
  }
});


Lino.about.Models.detailPanel = Ext.extend(Lino.about.Models.DetailFormPanel,{
  empty_title: "Detail Models",
  ls_bbar_actions: [  ],
  ls_url: "/about/Models",
  action_name: "detail",
  initComponent : function() {
    this.ls_detail_handler = Lino.about.Models.detail;
    Lino.about.Models.detailPanel.superclass.initComponent.call(this);
  }
});

Lino.about.Models.detail = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.about.Models.detailPanel(p);
});
Lino.about.Models.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.about.Models.GridPanel(p);
});

// js_render_GridPanel_class about.FieldsByModel
Lino.about.FieldsByModel.GridPanel = Ext.extend(Lino.GridPanel,{
  ls_url : "/about/FieldsByModel",
  ls_bbar_actions : [  ],
  title : "Felder",
  page_length : 20,
  gc_name : 0,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "name": "name" }, { "name": "verbose_name" }, { "name": "help_text_column" }, { "name": "disabled_fields" }, { "name": "disabled_actions" } ],
  ls_grid_configs : [  ],
  viewConfig : { "emptyText": "Keine Daten anzuzeigen." },
  disable_editing : true,
  disabled_actions_index : 4,
  initComponent : function() {
    var ww = this.containing_window;
    var name_disp3704 = new Ext.form.DisplayField({ "disabled": true, "value": "<br/>", "always_enabled": true });
    var verbose_name_disp3705 = new Ext.form.DisplayField({ "disabled": true, "value": "<br/>", "always_enabled": true });
    var help_text_column_disp3706 = new Ext.form.DisplayField({ "disabled": true, "value": "<br/>", "always_enabled": true });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ { "width": Lino.chars2width(31), "colIndex": 0, "sortable": false, "dataIndex": "name", "header": "name", "editable": false, "tooltip": "(about.FieldsByModel.name) " }, { "width": Lino.chars2width(31), "colIndex": 1, "sortable": false, "dataIndex": "verbose_name", "header": "verbose name", "editable": false, "tooltip": "(about.FieldsByModel.verbose_name) " }, { "width": Lino.chars2width(31), "colIndex": 2, "sortable": false, "dataIndex": "help_text_column", "header": "help text", "editable": false, "tooltip": "(about.FieldsByModel.help_text_column) " } ];
    Lino.about.FieldsByModel.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.about.FieldsByModel.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.about.FieldsByModel.GridPanel(p);
});

// js_render_GridPanel_class about.SourceFiles
Lino.about.SourceFiles.GridPanel = Ext.extend(Lino.GridPanel,{
  ls_url : "/about/SourceFiles",
  ls_bbar_actions : [  ],
  title : "Source files",
  page_length : 20,
  gc_name : 0,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "name": "module_name" }, { "type": "int", "name": "code_lines" }, { "type": "int", "name": "doc_lines" }, { "name": "disabled_fields" }, { "name": "disabled_actions" } ],
  ls_grid_configs : [  ],
  viewConfig : { "emptyText": "Keine Daten anzuzeigen." },
  disable_editing : true,
  disabled_actions_index : 4,
  initComponent : function() {
    var ww = this.containing_window;
    var module_name5598 = new Ext.form.TextField({ "disabled": true, "maxLength": null });
    var code_lines5599 = new Ext.form.NumberField({ "disabled": true });
    var doc_lines5600 = new Ext.form.NumberField({ "disabled": true });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ { "width": Lino.chars2width(5), "colIndex": 0, "sortable": false, "dataIndex": "module_name", "header": "module name", "editable": false, "tooltip": "(about.SourceFiles.module_name) " }, new Lino.NullNumberColumn({ "colIndex": 1, "sortable": false, "format": "0", "editable": false, "tooltip": "(about.SourceFiles.code_lines) ", "header": "Code", "dataIndex": "code_lines", "width": Lino.chars2width(6) }), new Lino.NullNumberColumn({ "colIndex": 2, "sortable": false, "format": "0", "editable": false, "tooltip": "(about.SourceFiles.doc_lines) ", "header": "doc", "dataIndex": "doc_lines", "width": Lino.chars2width(6) }) ];
    Lino.about.SourceFiles.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.about.SourceFiles.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.about.SourceFiles.GridPanel(p);
});

// js_render_GridPanel_class reception.ButtonsTable
Lino.reception.ButtonsTable.GridPanel = Ext.extend(Lino.GridPanel,{
  ls_url : "/reception/ButtonsTable",
  ls_bbar_actions : [ { "itemId": null, "menu_item_text": "L\u00f6schen", "tooltip": "Diesen Datensatz l\u00f6schen", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "L\u00f6schen", "auto_save": false } ],
  title : "ButtonsTable",
  page_length : 20,
  gc_name : 0,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "name": "button" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  ls_grid_configs : [  ],
  viewConfig : { "getRowClass": Lino.getRowClass, "forceFit": true, "emptyText": "Keine Daten anzuzeigen." },
  disabled_actions_index : 2,
  initComponent : function() {
    var ww = this.containing_window;
    var button_disp5602 = new Ext.form.DisplayField({ "disabled": true, "value": "<br/>", "always_enabled": true });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ { "width": Lino.chars2width(31), "colIndex": 0, "sortable": false, "dataIndex": "button", "header": "Button", "editable": false, "tooltip": "(reception.ButtonsTable.button) " } ];
    Lino.reception.ButtonsTable.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.reception.ButtonsTable.put = function(rp,pk) { 
  Lino.run_row_action(rp,"/reception/ButtonsTable","GET",pk,"put",null);
};
Lino.reception.ButtonsTable.post = function(rp,pk) { 
  Lino.run_row_action(rp,"/reception/ButtonsTable","GET",pk,"post",null);
};
Lino.reception.ButtonsTable.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.reception.ButtonsTable.GridPanel(p);
});

// js_render_GridPanel_class reception.CreateNoteActionsByClient
Lino.reception.CreateNoteActionsByClient.GridPanel = Ext.extend(Lino.GridPanel,{
  ls_url : "/reception/CreateNoteActionsByClient",
  ls_bbar_actions : [  ],
  title : "Bescheinigung ausstellen",
  page_length : 20,
  gc_name : 0,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "name": "button" }, { "name": "disabled_fields" }, { "name": "disabled_actions" } ],
  ls_grid_configs : [  ],
  viewConfig : { "forceFit": true, "emptyText": "Keine Daten anzuzeigen." },
  disable_editing : true,
  disabled_actions_index : 2,
  initComponent : function() {
    var ww = this.containing_window;
    var button_disp3094 = new Ext.form.DisplayField({ "disabled": true, "value": "<br/>", "always_enabled": true });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ { "width": Lino.chars2width(31), "colIndex": 0, "sortable": false, "dataIndex": "button", "header": "Button", "editable": false, "tooltip": "(reception.CreateNoteActionsByClient.button) " } ];
    Lino.reception.CreateNoteActionsByClient.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.reception.CreateNoteActionsByClient.grid = new Lino.WindowAction({ "draggable": true, "width": Lino.chars2width(60), "maximizable": true, "modal": true, "maximized": false, "height": Lino.rows2height(20) },function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.reception.CreateNoteActionsByClient.GridPanel(p);
});

// js_render_GridPanel_class integ.CompareRequestsTable
Lino.integ.CompareRequestsTable.GridPanel = Ext.extend(Lino.GridPanel,{
  ls_url : "/integ/CompareRequestsTable",
  ls_bbar_actions : [  ],
  title : "Allgemeine Entwicklung",
  page_length : 20,
  gc_name : 0,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "name": "description" }, { "name": "old_value" }, { "name": "new_value" }, { "name": "disabled_fields" }, { "name": "disabled_actions" } ],
  ls_grid_configs : [  ],
  viewConfig : { "forceFit": true, "emptyText": "Keine Daten anzuzeigen." },
  disable_editing : true,
  disabled_actions_index : 4,
  initComponent : function() {
    var ww = this.containing_window;
    var description_disp5614 = new Ext.form.DisplayField({ "disabled": true, "value": "<br/>", "always_enabled": true });
    var old_value5615 = new Ext.form.NumberField({ "disabled": true });
    var new_value5616 = new Ext.form.NumberField({ "disabled": true });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ { "width": Lino.chars2width(31), "colIndex": 0, "sortable": false, "dataIndex": "description", "header": "Beschreibung", "editable": false, "tooltip": "(integ.CompareRequestsTable.description) " }, new Lino.NullNumberColumn({ "colIndex": 1, "sortable": false, "format": "0", "editable": false, "tooltip": "(integ.CompareRequestsTable.old_value) ", "header": "Anfangswert", "dataIndex": "old_value", "width": Lino.chars2width(6) }), new Lino.NullNumberColumn({ "colIndex": 2, "sortable": false, "format": "0", "editable": false, "tooltip": "(integ.CompareRequestsTable.new_value) ", "header": "Endwert", "dataIndex": "new_value", "width": Lino.chars2width(6) }) ];
    Lino.integ.CompareRequestsTable.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.integ.CompareRequestsTable.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.integ.CompareRequestsTable.GridPanel(p);
});

// js_render_GridPanel_class integ.PeriodicNumbers
Lino.integ.PeriodicNumbers.GridPanel = Ext.extend(Lino.GridPanel,{
  ls_url : "/integ/PeriodicNumbers",
  ls_bbar_actions : [  ],
  title : "Aktivit\u00e4t",
  page_length : 20,
  gc_name : 0,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "name": "description" }, { "name": "number" }, { "name": "disabled_fields" }, { "name": "disabled_actions" } ],
  ls_grid_configs : [  ],
  viewConfig : { "forceFit": true, "emptyText": "Keine Daten anzuzeigen." },
  disable_editing : true,
  disabled_actions_index : 3,
  initComponent : function() {
    var ww = this.containing_window;
    var description_disp5618 = new Ext.form.DisplayField({ "disabled": true, "value": "<br/>", "always_enabled": true });
    var number5619 = new Ext.form.NumberField({ "disabled": true });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ { "width": Lino.chars2width(31), "colIndex": 0, "sortable": false, "dataIndex": "description", "header": "Beschreibung", "editable": false, "tooltip": "(integ.PeriodicNumbers.description) " }, new Lino.NullNumberColumn({ "colIndex": 1, "sortable": false, "format": "0", "editable": false, "tooltip": "(integ.PeriodicNumbers.number) ", "header": "Anzahl", "dataIndex": "number", "width": Lino.chars2width(6) }) ];
    Lino.integ.PeriodicNumbers.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.integ.PeriodicNumbers.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.integ.PeriodicNumbers.GridPanel(p);
});

// js_render_GridPanel_class debts.SummaryTable
Lino.debts.SummaryTable.GridPanel = Ext.extend(Lino.GridPanel,{
  ls_url : "/debts/SummaryTable",
  ls_bbar_actions : [  ],
  title : "SummaryTable",
  page_length : 20,
  gc_name : 0,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "name": "desc" }, { "name": "amount" }, { "name": "disabled_fields" }, { "name": "disabled_actions" } ],
  ls_grid_configs : [  ],
  viewConfig : { "forceFit": true, "emptyText": "Keine Daten anzuzeigen." },
  disable_editing : true,
  disabled_actions_index : 3,
  initComponent : function() {
    var ww = this.containing_window;
    var desc_disp5621 = new Ext.form.DisplayField({ "disabled": true, "value": "<br/>", "always_enabled": true });
    var amount5622 = new Ext.form.NumberField({ "disabled": true, "decimalPrecision": 2, "decimalSeparator": "," });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ { "width": Lino.chars2width(31), "colIndex": 0, "sortable": false, "dataIndex": "desc", "header": "Beschreibung", "editable": false, "tooltip": "(debts.SummaryTable.desc) " }, new Lino.NullNumberColumn({ "width": Lino.chars2width(13), "colIndex": 1, "sortable": false, "dataIndex": "amount", "header": "Betrag", "editable": false, "tooltip": "(debts.SummaryTable.amount) " }) ];
    Lino.debts.SummaryTable.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.debts.SummaryTable.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.debts.SummaryTable.GridPanel(p);
});

// js_render_GridPanel_class cbss.IdentifyPersonResult
Lino.cbss.IdentifyPersonResult.GridPanel = Ext.extend(Lino.GridPanel,{
  ls_url : "/cbss/IdentifyPersonResult",
  ls_bbar_actions : [  ],
  title : "Resultate",
  page_length : 20,
  gc_name : 0,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "name": "national_id" }, { "name": "last_name" }, { "name": "first_name" }, { "name": "address" }, { "name": "birth_date" }, { "name": "birth_location" }, { "name": "civil_state" }, { "name": "workflow_buttons" }, { "name": "gender" }, 'genderHidden', { "name": "disabled_fields" }, { "name": "disabled_actions" } ],
  ls_grid_configs : [  ],
  viewConfig : { "emptyText": "Keine Daten anzuzeigen." },
  disable_editing : true,
  disabled_actions_index : 11,
  initComponent : function() {
    var ww = this.containing_window;
    var national_id_disp3517 = new Ext.form.DisplayField({ "disabled": true, "value": "<br/>", "always_enabled": true });
    var last_name_disp3518 = new Ext.form.DisplayField({ "disabled": true, "value": "<br/>", "always_enabled": true });
    var first_name_disp3519 = new Ext.form.DisplayField({ "disabled": true, "value": "<br/>", "always_enabled": true });
    var address_disp3520 = new Ext.form.DisplayField({ "disabled": true, "value": "<br/>", "always_enabled": true });
    var birth_date_disp3521 = new Ext.form.DisplayField({ "disabled": true, "value": "<br/>", "always_enabled": true });
    var birth_location_disp3522 = new Ext.form.DisplayField({ "disabled": true, "value": "<br/>", "always_enabled": true });
    var civil_state_disp3523 = new Ext.form.DisplayField({ "disabled": true, "value": "<br/>", "always_enabled": true });
    var workflow_buttons_disp3524 = new Ext.form.DisplayField({ "disabled": true, "value": "<br/>", "always_enabled": true });
    var gender3525 = new Lino.ChoicesFieldElement({ "disabled": true, "store": [ [ "M", "M\u00e4nnlich" ], [ "F", "Weiblich" ] ] });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ { "width": Lino.chars2width(11), "colIndex": 0, "sortable": false, "dataIndex": "national_id", "header": "NR-Nummer", "editable": false, "tooltip": "(cbss.IdentifyPersonResult.national_id) " }, { "width": Lino.chars2width(21), "colIndex": 1, "sortable": false, "dataIndex": "last_name", "header": "Familienname", "editable": false, "tooltip": "(cbss.IdentifyPersonResult.last_name) " }, { "width": Lino.chars2width(11), "colIndex": 2, "sortable": false, "dataIndex": "first_name", "header": "Vorname", "editable": false, "tooltip": "(cbss.IdentifyPersonResult.first_name) " }, { "width": Lino.chars2width(31), "colIndex": 3, "sortable": false, "dataIndex": "address", "header": "Adresse", "editable": false, "tooltip": "(cbss.IdentifyPersonResult.address) " }, { "width": Lino.chars2width(11), "colIndex": 4, "sortable": false, "dataIndex": "birth_date", "header": "Geburtsdatum", "editable": false, "tooltip": "(cbss.IdentifyPersonResult.birth_date) " }, { "width": Lino.chars2width(31), "colIndex": 5, "sortable": false, "dataIndex": "birth_location", "header": "Geburtsort", "editable": false, "tooltip": "(cbss.IdentifyPersonResult.birth_location) " }, { "width": Lino.chars2width(31), "colIndex": 6, "sortable": false, "dataIndex": "civil_state", "header": "Zivilstand", "editable": false, "tooltip": "(cbss.IdentifyPersonResult.civil_state) " }, { "width": Lino.chars2width(31), "colIndex": 7, "sortable": false, "dataIndex": "workflow_buttons", "header": "Arbeitsablauf", "editable": false, "tooltip": "(cbss.IdentifyPersonResult.workflow_buttons) " }, { "width": Lino.chars2width(21), "colIndex": 8, "sortable": false, "dataIndex": "gender", "header": "Geschlecht", "editable": false, "tooltip": "(cbss.IdentifyPersonResult.gender) " } ];
    Lino.cbss.IdentifyPersonResult.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.cbss.IdentifyPersonResult.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.cbss.IdentifyPersonResult.GridPanel(p);
});

// js_render_GridPanel_class cbss.RetrieveTIGroupsResult
Lino.cbss.RetrieveTIGroupsResult.GridPanel = Ext.extend(Lino.GridPanel,{
  ls_url : "/cbss/RetrieveTIGroupsResult",
  ls_bbar_actions : [  ],
  title : "Resultate",
  page_length : 20,
  gc_name : 0,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "name": "group" }, { "name": "type" }, { "type": "date", "name": "since", "dateFormat": "d.m.Y" }, { "name": "info" }, { "name": "disabled_fields" }, { "name": "disabled_actions" } ],
  ls_grid_configs : [  ],
  viewConfig : { "emptyText": "Keine Daten anzuzeigen." },
  disable_editing : true,
  disabled_actions_index : 5,
  initComponent : function() {
    var ww = this.containing_window;
    var group_disp3665 = new Ext.form.DisplayField({ "disabled": true, "value": "<br/>", "always_enabled": true });
    var type_disp3666 = new Ext.form.DisplayField({ "disabled": true, "value": "<br/>", "always_enabled": true });
    var since3667 = new Lino.DateField({ "disabled": true });
    var info_disp3668 = new Ext.form.DisplayField({ "disabled": true, "value": "<br/>", "always_enabled": true });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ { "width": Lino.chars2width(19), "colIndex": 0, "sortable": false, "dataIndex": "group", "header": "Gruppe", "editable": false, "tooltip": "(cbss.RetrieveTIGroupsResult.group) " }, { "width": Lino.chars2width(6), "colIndex": 1, "sortable": false, "dataIndex": "type", "header": "TI", "editable": false, "tooltip": "(cbss.RetrieveTIGroupsResult.type) " }, { "colIndex": 2, "sortable": false, "xtype": "datecolumn", "format": "d.m.Y", "editable": false, "tooltip": "(cbss.RetrieveTIGroupsResult.since) ", "header": "Seit", "dataIndex": "since", "width": Lino.chars2width(15) }, { "width": Lino.chars2width(51), "colIndex": 3, "sortable": false, "dataIndex": "info", "header": "Information", "editable": false, "tooltip": "(cbss.RetrieveTIGroupsResult.info) " } ];
    Lino.cbss.RetrieveTIGroupsResult.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.cbss.RetrieveTIGroupsResult.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.cbss.RetrieveTIGroupsResult.GridPanel(p);
});

Lino.lino.Report.showPanel = Ext.extend(Lino.lino.Report.DetailFormPanel,{
  empty_title: "Report",
  hide_navigator: true,
  ls_bbar_actions: [ { "itemId": "do_print", "menu_item_text": "Drucken", "must_save": true, "tooltip": "Drucken", "panel_btn_handler": Lino.row_action_handler('do_print','GET',null), "iconCls": "x-tbar-print", "overflowText": "Drucken", "auto_save": true } ],
  ls_url: "/lino/Report",
  initComponent : function() {
    this.ls_detail_handler = Lino.lino.Report.show;
    Lino.lino.Report.showPanel.superclass.initComponent.call(this);
  }
});

Lino.lino.Report.show = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.lino.Report.showPanel(p);
});

Lino.lino.Report.showPanel = Ext.extend(Lino.lino.Report.DetailFormPanel,{
  empty_title: "Report",
  hide_navigator: true,
  ls_bbar_actions: [ { "itemId": "do_print", "menu_item_text": "Drucken", "must_save": true, "tooltip": "Drucken", "panel_btn_handler": Lino.row_action_handler('do_print','GET',null), "iconCls": "x-tbar-print", "overflowText": "Drucken", "auto_save": true } ],
  ls_url: "/lino/Report",
  initComponent : function() {
    this.ls_detail_handler = Lino.lino.Report.show;
    Lino.lino.Report.showPanel.superclass.initComponent.call(this);
  }
});

Lino.lino.Report.show = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.lino.Report.showPanel(p);
});
Lino.lino.Report.do_print = function(rp,pk) { 
  Lino.run_row_action(rp,"/lino/Report","GET",pk,"do_print",null);
};

Lino.about.About.showPanel = Ext.extend(Lino.about.About.DetailFormPanel,{
  empty_title: "Info",
  hide_navigator: true,
  ls_bbar_actions: [ { "itemId": "do_print", "menu_item_text": "Drucken", "must_save": true, "tooltip": "Drucken", "panel_btn_handler": Lino.row_action_handler('do_print','GET',null), "iconCls": "x-tbar-print", "overflowText": "Drucken", "auto_save": true } ],
  ls_url: "/about/About",
  initComponent : function() {
    this.ls_detail_handler = Lino.about.About.show;
    Lino.about.About.showPanel.superclass.initComponent.call(this);
  }
});

Lino.about.About.show = new Lino.WindowAction({ "draggable": true, "width": Lino.chars2width(60), "maximizable": true, "modal": true, "maximized": false, "height": Lino.rows2height(20) },function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.about.About.showPanel(p);
});

Lino.about.About.showPanel = Ext.extend(Lino.about.About.DetailFormPanel,{
  empty_title: "Info",
  hide_navigator: true,
  ls_bbar_actions: [ { "itemId": "do_print", "menu_item_text": "Drucken", "must_save": true, "tooltip": "Drucken", "panel_btn_handler": Lino.row_action_handler('do_print','GET',null), "iconCls": "x-tbar-print", "overflowText": "Drucken", "auto_save": true } ],
  ls_url: "/about/About",
  initComponent : function() {
    this.ls_detail_handler = Lino.about.About.show;
    Lino.about.About.showPanel.superclass.initComponent.call(this);
  }
});

Lino.about.About.show = new Lino.WindowAction({ "draggable": true, "width": Lino.chars2width(60), "maximizable": true, "modal": true, "maximized": false, "height": Lino.rows2height(20) },function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.about.About.showPanel(p);
});
Lino.about.About.do_print = function(rp,pk) { 
  Lino.run_row_action(rp,"/about/About","GET",pk,"do_print",null);
};

Lino.system.Home.showPanel = Ext.extend(Lino.system.Home.DetailFormPanel,{
  empty_title: "Startseite",
  hide_navigator: true,
  ls_bbar_actions: [ { "itemId": "do_print", "menu_item_text": "Drucken", "must_save": true, "tooltip": "Drucken", "panel_btn_handler": Lino.row_action_handler('do_print','GET',null), "iconCls": "x-tbar-print", "overflowText": "Drucken", "auto_save": true } ],
  ls_url: "/system/Home",
  initComponent : function() {
    this.ls_detail_handler = Lino.system.Home.show;
    Lino.system.Home.showPanel.superclass.initComponent.call(this);
  }
});

Lino.system.Home.show = new Lino.WindowAction({  },function(){
  var p = { "hide_window_title": true, "hide_top_toolbar": true, "is_main_window": true };
  return new Lino.system.Home.showPanel(p);
});

Lino.system.Home.showPanel = Ext.extend(Lino.system.Home.DetailFormPanel,{
  empty_title: "Startseite",
  hide_navigator: true,
  ls_bbar_actions: [ { "itemId": "do_print", "menu_item_text": "Drucken", "must_save": true, "tooltip": "Drucken", "panel_btn_handler": Lino.row_action_handler('do_print','GET',null), "iconCls": "x-tbar-print", "overflowText": "Drucken", "auto_save": true } ],
  ls_url: "/system/Home",
  initComponent : function() {
    this.ls_detail_handler = Lino.system.Home.show;
    Lino.system.Home.showPanel.superclass.initComponent.call(this);
  }
});

Lino.system.Home.show = new Lino.WindowAction({  },function(){
  var p = { "hide_window_title": true, "hide_top_toolbar": true, "is_main_window": true };
  return new Lino.system.Home.showPanel(p);
});
Lino.system.Home.do_print = function(rp,pk) { 
  Lino.run_row_action(rp,"/system/Home","GET",pk,"do_print",null);
};

// js_render_GridPanel_class courses.CourseRequestStates
Lino.courses.CourseRequestStates.GridPanel = Ext.extend(Lino.GridPanel,{
  ls_url : "/courses/CourseRequestStates",
  ls_bbar_actions : [  ],
  title : "Zust\u00e4nde",
  page_length : 20,
  gc_name : 0,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "name": "value" }, { "name": "name" }, { "name": "text" }, { "name": "disabled_fields" }, { "name": "disabled_actions" } ],
  ls_grid_configs : [  ],
  viewConfig : { "emptyText": "Keine Daten anzuzeigen." },
  disable_editing : true,
  disabled_actions_index : 4,
  initComponent : function() {
    var ww = this.containing_window;
    var value5633 = new Ext.form.TextField({ "disabled": true, "maxLength": 20 });
    var name5634 = new Ext.form.TextField({ "disabled": true, "maxLength": 20 });
    var text5635 = new Ext.form.TextField({ "disabled": true, "maxLength": 50 });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ { "width": Lino.chars2width(22), "colIndex": 0, "sortable": false, "dataIndex": "value", "header": "Wert", "editable": false, "tooltip": "(courses.CourseRequestStates.value) " }, { "width": Lino.chars2width(22), "colIndex": 1, "sortable": false, "dataIndex": "name", "header": "name", "editable": false, "tooltip": "(courses.CourseRequestStates.name) " }, { "width": Lino.chars2width(22), "colIndex": 2, "sortable": false, "dataIndex": "text", "header": "Text", "editable": false, "tooltip": "(courses.CourseRequestStates.text) " } ];
    Lino.courses.CourseRequestStates.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.courses.CourseRequestStates.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.courses.CourseRequestStates.GridPanel(p);
});

// js_render_GridPanel_class cal.DurationUnits
Lino.cal.DurationUnits.GridPanel = Ext.extend(Lino.GridPanel,{
  ls_url : "/cal/DurationUnits",
  ls_bbar_actions : [  ],
  title : "DurationUnits",
  page_length : 20,
  gc_name : 0,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "name": "value" }, { "name": "name" }, { "name": "text" }, { "name": "disabled_fields" }, { "name": "disabled_actions" } ],
  ls_grid_configs : [  ],
  viewConfig : { "emptyText": "Keine Daten anzuzeigen." },
  disable_editing : true,
  disabled_actions_index : 4,
  initComponent : function() {
    var ww = this.containing_window;
    var value5637 = new Ext.form.TextField({ "disabled": true, "maxLength": 20 });
    var name5638 = new Ext.form.TextField({ "disabled": true, "maxLength": 20 });
    var text5639 = new Ext.form.TextField({ "disabled": true, "maxLength": 50 });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ { "width": Lino.chars2width(22), "colIndex": 0, "sortable": false, "dataIndex": "value", "header": "Wert", "editable": false, "tooltip": "(cal.DurationUnits.value) " }, { "width": Lino.chars2width(22), "colIndex": 1, "sortable": false, "dataIndex": "name", "header": "name", "editable": false, "tooltip": "(cal.DurationUnits.name) " }, { "width": Lino.chars2width(22), "colIndex": 2, "sortable": false, "dataIndex": "text", "header": "Text", "editable": false, "tooltip": "(cal.DurationUnits.text) " } ];
    Lino.cal.DurationUnits.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.cal.DurationUnits.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.cal.DurationUnits.GridPanel(p);
});

// js_render_GridPanel_class cal.Weekdays
Lino.cal.Weekdays.GridPanel = Ext.extend(Lino.GridPanel,{
  ls_url : "/cal/Weekdays",
  ls_bbar_actions : [  ],
  title : "Weekdays",
  page_length : 20,
  gc_name : 0,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "name": "value" }, { "name": "name" }, { "name": "text" }, { "name": "disabled_fields" }, { "name": "disabled_actions" } ],
  ls_grid_configs : [  ],
  viewConfig : { "emptyText": "Keine Daten anzuzeigen." },
  disable_editing : true,
  disabled_actions_index : 4,
  initComponent : function() {
    var ww = this.containing_window;
    var value5645 = new Ext.form.TextField({ "disabled": true, "maxLength": 20 });
    var name5646 = new Ext.form.TextField({ "disabled": true, "maxLength": 20 });
    var text5647 = new Ext.form.TextField({ "disabled": true, "maxLength": 50 });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ { "width": Lino.chars2width(22), "colIndex": 0, "sortable": false, "dataIndex": "value", "header": "Wert", "editable": false, "tooltip": "(cal.Weekdays.value) " }, { "width": Lino.chars2width(22), "colIndex": 1, "sortable": false, "dataIndex": "name", "header": "name", "editable": false, "tooltip": "(cal.Weekdays.name) " }, { "width": Lino.chars2width(22), "colIndex": 2, "sortable": false, "dataIndex": "text", "header": "Text", "editable": false, "tooltip": "(cal.Weekdays.text) " } ];
    Lino.cal.Weekdays.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.cal.Weekdays.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.cal.Weekdays.GridPanel(p);
});

// js_render_GridPanel_class pcsw.CoachingEvents
Lino.pcsw.CoachingEvents.GridPanel = Ext.extend(Lino.GridPanel,{
  ls_url : "/pcsw/CoachingEvents",
  ls_bbar_actions : [  ],
  title : "Beobachtungskriterium",
  page_length : 20,
  gc_name : 0,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "name": "value" }, { "name": "name" }, { "name": "text" }, { "name": "disabled_fields" }, { "name": "disabled_actions" } ],
  ls_grid_configs : [  ],
  viewConfig : { "emptyText": "Keine Daten anzuzeigen." },
  disable_editing : true,
  disabled_actions_index : 4,
  initComponent : function() {
    var ww = this.containing_window;
    var value5653 = new Ext.form.TextField({ "disabled": true, "maxLength": 20 });
    var name5654 = new Ext.form.TextField({ "disabled": true, "maxLength": 20 });
    var text5655 = new Ext.form.TextField({ "disabled": true, "maxLength": 50 });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ { "width": Lino.chars2width(22), "colIndex": 0, "sortable": false, "dataIndex": "value", "header": "Wert", "editable": false, "tooltip": "(pcsw.CoachingEvents.value) " }, { "width": Lino.chars2width(22), "colIndex": 1, "sortable": false, "dataIndex": "name", "header": "name", "editable": false, "tooltip": "(pcsw.CoachingEvents.name) " }, { "width": Lino.chars2width(22), "colIndex": 2, "sortable": false, "dataIndex": "text", "header": "Text", "editable": false, "tooltip": "(pcsw.CoachingEvents.text) " } ];
    Lino.pcsw.CoachingEvents.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.pcsw.CoachingEvents.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.pcsw.CoachingEvents.GridPanel(p);
});

// js_render_GridPanel_class lino.YesNo
Lino.lino.YesNo.GridPanel = Ext.extend(Lino.GridPanel,{
  ls_url : "/lino/YesNo",
  ls_bbar_actions : [  ],
  title : "Ja oder Nein",
  page_length : 20,
  gc_name : 0,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "name": "value" }, { "name": "name" }, { "name": "text" }, { "name": "disabled_fields" }, { "name": "disabled_actions" } ],
  ls_grid_configs : [  ],
  viewConfig : { "emptyText": "Keine Daten anzuzeigen." },
  disable_editing : true,
  disabled_actions_index : 4,
  initComponent : function() {
    var ww = this.containing_window;
    var value5657 = new Ext.form.TextField({ "disabled": true, "maxLength": 20 });
    var name5658 = new Ext.form.TextField({ "disabled": true, "maxLength": 20 });
    var text5659 = new Ext.form.TextField({ "disabled": true, "maxLength": 50 });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ { "width": Lino.chars2width(22), "colIndex": 0, "sortable": false, "dataIndex": "value", "header": "Wert", "editable": false, "tooltip": "(lino.YesNo.value) " }, { "width": Lino.chars2width(22), "colIndex": 1, "sortable": false, "dataIndex": "name", "header": "name", "editable": false, "tooltip": "(lino.YesNo.name) " }, { "width": Lino.chars2width(22), "colIndex": 2, "sortable": false, "dataIndex": "text", "header": "Text", "editable": false, "tooltip": "(lino.YesNo.text) " } ];
    Lino.lino.YesNo.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.lino.YesNo.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.lino.YesNo.GridPanel(p);
});

// js_render_GridPanel_class accounts.AccountTypes
Lino.accounts.AccountTypes.GridPanel = Ext.extend(Lino.GridPanel,{
  ls_url : "/accounts/AccountTypes",
  ls_bbar_actions : [  ],
  title : "AccountTypes",
  page_length : 20,
  gc_name : 0,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "name": "value" }, { "name": "name" }, { "name": "text" }, { "name": "disabled_fields" }, { "name": "disabled_actions" } ],
  ls_grid_configs : [  ],
  viewConfig : { "emptyText": "Keine Daten anzuzeigen." },
  disable_editing : true,
  disabled_actions_index : 4,
  initComponent : function() {
    var ww = this.containing_window;
    var value5669 = new Ext.form.TextField({ "disabled": true, "maxLength": 20 });
    var name5670 = new Ext.form.TextField({ "disabled": true, "maxLength": 20 });
    var text5671 = new Ext.form.TextField({ "disabled": true, "maxLength": 50 });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ { "width": Lino.chars2width(22), "colIndex": 0, "sortable": false, "dataIndex": "value", "header": "Wert", "editable": false, "tooltip": "(accounts.AccountTypes.value) " }, { "width": Lino.chars2width(22), "colIndex": 1, "sortable": false, "dataIndex": "name", "header": "name", "editable": false, "tooltip": "(accounts.AccountTypes.name) " }, { "width": Lino.chars2width(22), "colIndex": 2, "sortable": false, "dataIndex": "text", "header": "Text", "editable": false, "tooltip": "(accounts.AccountTypes.text) " } ];
    Lino.accounts.AccountTypes.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.accounts.AccountTypes.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.accounts.AccountTypes.GridPanel(p);
});

// js_render_GridPanel_class cal.Recurrencies
Lino.cal.Recurrencies.GridPanel = Ext.extend(Lino.GridPanel,{
  ls_url : "/cal/Recurrencies",
  ls_bbar_actions : [  ],
  title : "Recurrencies",
  page_length : 20,
  gc_name : 0,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "name": "value" }, { "name": "name" }, { "name": "text" }, { "name": "disabled_fields" }, { "name": "disabled_actions" } ],
  ls_grid_configs : [  ],
  viewConfig : { "emptyText": "Keine Daten anzuzeigen." },
  disable_editing : true,
  disabled_actions_index : 4,
  initComponent : function() {
    var ww = this.containing_window;
    var value5673 = new Ext.form.TextField({ "disabled": true, "maxLength": 20 });
    var name5674 = new Ext.form.TextField({ "disabled": true, "maxLength": 20 });
    var text5675 = new Ext.form.TextField({ "disabled": true, "maxLength": 50 });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ { "width": Lino.chars2width(22), "colIndex": 0, "sortable": false, "dataIndex": "value", "header": "Wert", "editable": false, "tooltip": "(cal.Recurrencies.value) " }, { "width": Lino.chars2width(22), "colIndex": 1, "sortable": false, "dataIndex": "name", "header": "name", "editable": false, "tooltip": "(cal.Recurrencies.name) " }, { "width": Lino.chars2width(22), "colIndex": 2, "sortable": false, "dataIndex": "text", "header": "Text", "editable": false, "tooltip": "(cal.Recurrencies.text) " } ];
    Lino.cal.Recurrencies.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.cal.Recurrencies.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.cal.Recurrencies.GridPanel(p);
});

// js_render_GridPanel_class properties.HowWell
Lino.properties.HowWell.GridPanel = Ext.extend(Lino.GridPanel,{
  ls_url : "/properties/HowWell",
  ls_bbar_actions : [  ],
  title : "HowWell",
  page_length : 20,
  gc_name : 0,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "name": "value" }, { "name": "name" }, { "name": "text" }, { "name": "disabled_fields" }, { "name": "disabled_actions" } ],
  ls_grid_configs : [  ],
  viewConfig : { "emptyText": "Keine Daten anzuzeigen." },
  disable_editing : true,
  disabled_actions_index : 4,
  initComponent : function() {
    var ww = this.containing_window;
    var value5677 = new Ext.form.TextField({ "disabled": true, "maxLength": 20 });
    var name5678 = new Ext.form.TextField({ "disabled": true, "maxLength": 20 });
    var text5679 = new Ext.form.TextField({ "disabled": true, "maxLength": 50 });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ { "width": Lino.chars2width(22), "colIndex": 0, "sortable": false, "dataIndex": "value", "header": "Wert", "editable": false, "tooltip": "(properties.HowWell.value) " }, { "width": Lino.chars2width(22), "colIndex": 1, "sortable": false, "dataIndex": "name", "header": "name", "editable": false, "tooltip": "(properties.HowWell.name) " }, { "width": Lino.chars2width(22), "colIndex": 2, "sortable": false, "dataIndex": "text", "header": "Text", "editable": false, "tooltip": "(properties.HowWell.text) " } ];
    Lino.properties.HowWell.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.properties.HowWell.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.properties.HowWell.GridPanel(p);
});

// js_render_GridPanel_class cv.CefLevel
Lino.cv.CefLevel.GridPanel = Ext.extend(Lino.GridPanel,{
  ls_url : "/cv/CefLevel",
  ls_bbar_actions : [  ],
  title : "CEF-Kategorien",
  page_length : 20,
  gc_name : 0,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "name": "value" }, { "name": "name" }, { "name": "text" }, { "name": "disabled_fields" }, { "name": "disabled_actions" } ],
  ls_grid_configs : [  ],
  viewConfig : { "emptyText": "Keine Daten anzuzeigen." },
  disable_editing : true,
  disabled_actions_index : 4,
  initComponent : function() {
    var ww = this.containing_window;
    var value5681 = new Ext.form.TextField({ "disabled": true, "maxLength": 20 });
    var name5682 = new Ext.form.TextField({ "disabled": true, "maxLength": 20 });
    var text5683 = new Ext.form.TextField({ "disabled": true, "maxLength": 50 });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ { "width": Lino.chars2width(22), "colIndex": 0, "sortable": false, "dataIndex": "value", "header": "Wert", "editable": false, "tooltip": "(cv.CefLevel.value) " }, { "width": Lino.chars2width(22), "colIndex": 1, "sortable": false, "dataIndex": "name", "header": "name", "editable": false, "tooltip": "(cv.CefLevel.name) " }, { "width": Lino.chars2width(22), "colIndex": 2, "sortable": false, "dataIndex": "text", "header": "Text", "editable": false, "tooltip": "(cv.CefLevel.text) " } ];
    Lino.cv.CefLevel.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.cv.CefLevel.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.cv.CefLevel.GridPanel(p);
});

// js_render_GridPanel_class jobs.CandidatureStates
Lino.jobs.CandidatureStates.GridPanel = Ext.extend(Lino.GridPanel,{
  ls_url : "/jobs/CandidatureStates",
  ls_bbar_actions : [  ],
  title : "Kandidatur-Zust\u00e4nde",
  page_length : 20,
  gc_name : 0,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "name": "value" }, { "name": "name" }, { "name": "text" }, { "name": "disabled_fields" }, { "name": "disabled_actions" } ],
  ls_grid_configs : [  ],
  viewConfig : { "emptyText": "Keine Daten anzuzeigen." },
  disable_editing : true,
  disabled_actions_index : 4,
  initComponent : function() {
    var ww = this.containing_window;
    var value5685 = new Ext.form.TextField({ "disabled": true, "maxLength": 20 });
    var name5686 = new Ext.form.TextField({ "disabled": true, "maxLength": 20 });
    var text5687 = new Ext.form.TextField({ "disabled": true, "maxLength": 50 });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ { "width": Lino.chars2width(22), "colIndex": 0, "sortable": false, "dataIndex": "value", "header": "Wert", "editable": false, "tooltip": "(jobs.CandidatureStates.value) " }, { "width": Lino.chars2width(22), "colIndex": 1, "sortable": false, "dataIndex": "name", "header": "name", "editable": false, "tooltip": "(jobs.CandidatureStates.name) " }, { "width": Lino.chars2width(22), "colIndex": 2, "sortable": false, "dataIndex": "text", "header": "Text", "editable": false, "tooltip": "(jobs.CandidatureStates.text) " } ];
    Lino.jobs.CandidatureStates.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.jobs.CandidatureStates.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.jobs.CandidatureStates.GridPanel(p);
});

// js_render_GridPanel_class outbox.RecipientType
Lino.outbox.RecipientType.GridPanel = Ext.extend(Lino.GridPanel,{
  ls_url : "/outbox/RecipientType",
  ls_bbar_actions : [  ],
  title : "RecipientType",
  page_length : 20,
  gc_name : 0,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "name": "value" }, { "name": "name" }, { "name": "text" }, { "name": "disabled_fields" }, { "name": "disabled_actions" } ],
  ls_grid_configs : [  ],
  viewConfig : { "emptyText": "Keine Daten anzuzeigen." },
  disable_editing : true,
  disabled_actions_index : 4,
  initComponent : function() {
    var ww = this.containing_window;
    var value5689 = new Ext.form.TextField({ "disabled": true, "maxLength": 20 });
    var name5690 = new Ext.form.TextField({ "disabled": true, "maxLength": 20 });
    var text5691 = new Ext.form.TextField({ "disabled": true, "maxLength": 50 });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ { "width": Lino.chars2width(22), "colIndex": 0, "sortable": false, "dataIndex": "value", "header": "Wert", "editable": false, "tooltip": "(outbox.RecipientType.value) " }, { "width": Lino.chars2width(22), "colIndex": 1, "sortable": false, "dataIndex": "name", "header": "name", "editable": false, "tooltip": "(outbox.RecipientType.name) " }, { "width": Lino.chars2width(22), "colIndex": 2, "sortable": false, "dataIndex": "text", "header": "Text", "editable": false, "tooltip": "(outbox.RecipientType.text) " } ];
    Lino.outbox.RecipientType.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.outbox.RecipientType.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.outbox.RecipientType.GridPanel(p);
});

// js_render_GridPanel_class cal.EventEvents
Lino.cal.EventEvents.GridPanel = Ext.extend(Lino.GridPanel,{
  ls_url : "/cal/EventEvents",
  ls_bbar_actions : [  ],
  title : "Beobachtungskriterium",
  page_length : 20,
  gc_name : 0,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "name": "value" }, { "name": "name" }, { "name": "text" }, { "name": "disabled_fields" }, { "name": "disabled_actions" } ],
  ls_grid_configs : [  ],
  viewConfig : { "emptyText": "Keine Daten anzuzeigen." },
  disable_editing : true,
  disabled_actions_index : 4,
  initComponent : function() {
    var ww = this.containing_window;
    var value5693 = new Ext.form.TextField({ "disabled": true, "maxLength": 20 });
    var name5694 = new Ext.form.TextField({ "disabled": true, "maxLength": 20 });
    var text5695 = new Ext.form.TextField({ "disabled": true, "maxLength": 50 });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ { "width": Lino.chars2width(22), "colIndex": 0, "sortable": false, "dataIndex": "value", "header": "Wert", "editable": false, "tooltip": "(cal.EventEvents.value) " }, { "width": Lino.chars2width(22), "colIndex": 1, "sortable": false, "dataIndex": "name", "header": "name", "editable": false, "tooltip": "(cal.EventEvents.name) " }, { "width": Lino.chars2width(22), "colIndex": 2, "sortable": false, "dataIndex": "text", "header": "Text", "editable": false, "tooltip": "(cal.EventEvents.text) " } ];
    Lino.cal.EventEvents.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.cal.EventEvents.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.cal.EventEvents.GridPanel(p);
});

// js_render_GridPanel_class countries.CityTypes
Lino.countries.CityTypes.GridPanel = Ext.extend(Lino.GridPanel,{
  ls_url : "/countries/CityTypes",
  ls_bbar_actions : [  ],
  title : "CityTypes",
  page_length : 20,
  gc_name : 0,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "name": "value" }, { "name": "name" }, { "name": "text" }, { "name": "disabled_fields" }, { "name": "disabled_actions" } ],
  ls_grid_configs : [  ],
  viewConfig : { "emptyText": "Keine Daten anzuzeigen." },
  disable_editing : true,
  disabled_actions_index : 4,
  initComponent : function() {
    var ww = this.containing_window;
    var value5709 = new Ext.form.TextField({ "disabled": true, "maxLength": 20 });
    var name5710 = new Ext.form.TextField({ "disabled": true, "maxLength": 20 });
    var text5711 = new Ext.form.TextField({ "disabled": true, "maxLength": 50 });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ { "width": Lino.chars2width(22), "colIndex": 0, "sortable": false, "dataIndex": "value", "header": "Wert", "editable": false, "tooltip": "(countries.CityTypes.value) " }, { "width": Lino.chars2width(22), "colIndex": 1, "sortable": false, "dataIndex": "name", "header": "name", "editable": false, "tooltip": "(countries.CityTypes.name) " }, { "width": Lino.chars2width(22), "colIndex": 2, "sortable": false, "dataIndex": "text", "header": "Text", "editable": false, "tooltip": "(countries.CityTypes.text) " } ];
    Lino.countries.CityTypes.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.countries.CityTypes.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.countries.CityTypes.GridPanel(p);
});

// js_render_GridPanel_class properties.DoYouLike
Lino.properties.DoYouLike.GridPanel = Ext.extend(Lino.GridPanel,{
  ls_url : "/properties/DoYouLike",
  ls_bbar_actions : [  ],
  title : "DoYouLike",
  page_length : 20,
  gc_name : 0,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "name": "value" }, { "name": "name" }, { "name": "text" }, { "name": "disabled_fields" }, { "name": "disabled_actions" } ],
  ls_grid_configs : [  ],
  viewConfig : { "emptyText": "Keine Daten anzuzeigen." },
  disable_editing : true,
  disabled_actions_index : 4,
  initComponent : function() {
    var ww = this.containing_window;
    var value5713 = new Ext.form.TextField({ "disabled": true, "maxLength": 20 });
    var name5714 = new Ext.form.TextField({ "disabled": true, "maxLength": 20 });
    var text5715 = new Ext.form.TextField({ "disabled": true, "maxLength": 50 });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ { "width": Lino.chars2width(22), "colIndex": 0, "sortable": false, "dataIndex": "value", "header": "Wert", "editable": false, "tooltip": "(properties.DoYouLike.value) " }, { "width": Lino.chars2width(22), "colIndex": 1, "sortable": false, "dataIndex": "name", "header": "name", "editable": false, "tooltip": "(properties.DoYouLike.name) " }, { "width": Lino.chars2width(22), "colIndex": 2, "sortable": false, "dataIndex": "text", "header": "Text", "editable": false, "tooltip": "(properties.DoYouLike.text) " } ];
    Lino.properties.DoYouLike.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.properties.DoYouLike.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.properties.DoYouLike.GridPanel(p);
});

// js_render_GridPanel_class cbss.RequestLanguages
Lino.cbss.RequestLanguages.GridPanel = Ext.extend(Lino.GridPanel,{
  ls_url : "/cbss/RequestLanguages",
  ls_bbar_actions : [  ],
  title : "RequestLanguages",
  page_length : 20,
  gc_name : 0,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "name": "value" }, { "name": "name" }, { "name": "text" }, { "name": "disabled_fields" }, { "name": "disabled_actions" } ],
  ls_grid_configs : [  ],
  viewConfig : { "emptyText": "Keine Daten anzuzeigen." },
  disable_editing : true,
  disabled_actions_index : 4,
  initComponent : function() {
    var ww = this.containing_window;
    var value5717 = new Ext.form.TextField({ "disabled": true, "maxLength": 20 });
    var name5718 = new Ext.form.TextField({ "disabled": true, "maxLength": 20 });
    var text5719 = new Ext.form.TextField({ "disabled": true, "maxLength": 50 });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ { "width": Lino.chars2width(22), "colIndex": 0, "sortable": false, "dataIndex": "value", "header": "Wert", "editable": false, "tooltip": "(cbss.RequestLanguages.value) " }, { "width": Lino.chars2width(22), "colIndex": 1, "sortable": false, "dataIndex": "name", "header": "name", "editable": false, "tooltip": "(cbss.RequestLanguages.name) " }, { "width": Lino.chars2width(22), "colIndex": 2, "sortable": false, "dataIndex": "text", "header": "Text", "editable": false, "tooltip": "(cbss.RequestLanguages.text) " } ];
    Lino.cbss.RequestLanguages.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.cbss.RequestLanguages.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.cbss.RequestLanguages.GridPanel(p);
});

// js_render_GridPanel_class cbss.ManageAction
Lino.cbss.ManageAction.GridPanel = Ext.extend(Lino.GridPanel,{
  ls_url : "/cbss/ManageAction",
  ls_bbar_actions : [  ],
  title : "ManageAction",
  page_length : 20,
  gc_name : 0,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "name": "value" }, { "name": "name" }, { "name": "text" }, { "name": "disabled_fields" }, { "name": "disabled_actions" } ],
  ls_grid_configs : [  ],
  viewConfig : { "emptyText": "Keine Daten anzuzeigen." },
  disable_editing : true,
  disabled_actions_index : 4,
  initComponent : function() {
    var ww = this.containing_window;
    var value5721 = new Ext.form.TextField({ "disabled": true, "maxLength": 20 });
    var name5722 = new Ext.form.TextField({ "disabled": true, "maxLength": 20 });
    var text5723 = new Ext.form.TextField({ "disabled": true, "maxLength": 50 });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ { "width": Lino.chars2width(22), "colIndex": 0, "sortable": false, "dataIndex": "value", "header": "Wert", "editable": false, "tooltip": "(cbss.ManageAction.value) " }, { "width": Lino.chars2width(22), "colIndex": 1, "sortable": false, "dataIndex": "name", "header": "name", "editable": false, "tooltip": "(cbss.ManageAction.name) " }, { "width": Lino.chars2width(22), "colIndex": 2, "sortable": false, "dataIndex": "text", "header": "Text", "editable": false, "tooltip": "(cbss.ManageAction.text) " } ];
    Lino.cbss.ManageAction.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.cbss.ManageAction.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.cbss.ManageAction.GridPanel(p);
});

// js_render_GridPanel_class pcsw.RefusalReasons
Lino.pcsw.RefusalReasons.GridPanel = Ext.extend(Lino.GridPanel,{
  ls_url : "/pcsw/RefusalReasons",
  ls_bbar_actions : [  ],
  title : "RefusalReasons",
  page_length : 20,
  gc_name : 0,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "name": "value" }, { "name": "name" }, { "name": "text" }, { "name": "disabled_fields" }, { "name": "disabled_actions" } ],
  ls_grid_configs : [  ],
  viewConfig : { "emptyText": "Keine Daten anzuzeigen." },
  disable_editing : true,
  disabled_actions_index : 4,
  initComponent : function() {
    var ww = this.containing_window;
    var value5725 = new Ext.form.TextField({ "disabled": true, "maxLength": 20 });
    var name5726 = new Ext.form.TextField({ "disabled": true, "maxLength": 20 });
    var text5727 = new Ext.form.TextField({ "disabled": true, "maxLength": 50 });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ { "width": Lino.chars2width(22), "colIndex": 0, "sortable": false, "dataIndex": "value", "header": "Wert", "editable": false, "tooltip": "(pcsw.RefusalReasons.value) " }, { "width": Lino.chars2width(22), "colIndex": 1, "sortable": false, "dataIndex": "name", "header": "name", "editable": false, "tooltip": "(pcsw.RefusalReasons.name) " }, { "width": Lino.chars2width(22), "colIndex": 2, "sortable": false, "dataIndex": "text", "header": "Text", "editable": false, "tooltip": "(pcsw.RefusalReasons.text) " } ];
    Lino.pcsw.RefusalReasons.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.pcsw.RefusalReasons.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.pcsw.RefusalReasons.GridPanel(p);
});

// js_render_GridPanel_class cbss.RequestStates
Lino.cbss.RequestStates.GridPanel = Ext.extend(Lino.GridPanel,{
  ls_url : "/cbss/RequestStates",
  ls_bbar_actions : [  ],
  title : "Zust\u00e4nde",
  page_length : 20,
  gc_name : 0,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "name": "value" }, { "name": "name" }, { "name": "text" }, { "name": "disabled_fields" }, { "name": "disabled_actions" } ],
  ls_grid_configs : [  ],
  viewConfig : { "emptyText": "Keine Daten anzuzeigen." },
  disable_editing : true,
  disabled_actions_index : 4,
  initComponent : function() {
    var ww = this.containing_window;
    var value5733 = new Ext.form.TextField({ "disabled": true, "maxLength": 20 });
    var name5734 = new Ext.form.TextField({ "disabled": true, "maxLength": 20 });
    var text5735 = new Ext.form.TextField({ "disabled": true, "maxLength": 50 });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ { "width": Lino.chars2width(22), "colIndex": 0, "sortable": false, "dataIndex": "value", "header": "Wert", "editable": false, "tooltip": "(cbss.RequestStates.value) " }, { "width": Lino.chars2width(22), "colIndex": 1, "sortable": false, "dataIndex": "name", "header": "name", "editable": false, "tooltip": "(cbss.RequestStates.name) " }, { "width": Lino.chars2width(22), "colIndex": 2, "sortable": false, "dataIndex": "text", "header": "Text", "editable": false, "tooltip": "(cbss.RequestStates.text) " } ];
    Lino.cbss.RequestStates.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.cbss.RequestStates.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.cbss.RequestStates.GridPanel(p);
});

// js_render_GridPanel_class lino.ChangeTypes
Lino.lino.ChangeTypes.GridPanel = Ext.extend(Lino.GridPanel,{
  ls_url : "/lino/ChangeTypes",
  ls_bbar_actions : [  ],
  title : "\u00c4nderungsarten",
  page_length : 20,
  gc_name : 0,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "name": "value" }, { "name": "name" }, { "name": "text" }, { "name": "disabled_fields" }, { "name": "disabled_actions" } ],
  ls_grid_configs : [  ],
  viewConfig : { "emptyText": "Keine Daten anzuzeigen." },
  disable_editing : true,
  disabled_actions_index : 4,
  initComponent : function() {
    var ww = this.containing_window;
    var value5737 = new Ext.form.TextField({ "disabled": true, "maxLength": 20 });
    var name5738 = new Ext.form.TextField({ "disabled": true, "maxLength": 20 });
    var text5739 = new Ext.form.TextField({ "disabled": true, "maxLength": 50 });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ { "width": Lino.chars2width(22), "colIndex": 0, "sortable": false, "dataIndex": "value", "header": "Wert", "editable": false, "tooltip": "(lino.ChangeTypes.value) " }, { "width": Lino.chars2width(22), "colIndex": 1, "sortable": false, "dataIndex": "name", "header": "name", "editable": false, "tooltip": "(lino.ChangeTypes.name) " }, { "width": Lino.chars2width(22), "colIndex": 2, "sortable": false, "dataIndex": "text", "header": "Text", "editable": false, "tooltip": "(lino.ChangeTypes.text) " } ];
    Lino.lino.ChangeTypes.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.lino.ChangeTypes.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.lino.ChangeTypes.GridPanel(p);
});

// js_render_GridPanel_class cal.AccessClasses
Lino.cal.AccessClasses.GridPanel = Ext.extend(Lino.GridPanel,{
  ls_url : "/cal/AccessClasses",
  ls_bbar_actions : [  ],
  title : "AccessClasses",
  page_length : 20,
  gc_name : 0,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "name": "value" }, { "name": "name" }, { "name": "text" }, { "name": "disabled_fields" }, { "name": "disabled_actions" } ],
  ls_grid_configs : [  ],
  viewConfig : { "emptyText": "Keine Daten anzuzeigen." },
  disable_editing : true,
  disabled_actions_index : 4,
  initComponent : function() {
    var ww = this.containing_window;
    var value5741 = new Ext.form.TextField({ "disabled": true, "maxLength": 20 });
    var name5742 = new Ext.form.TextField({ "disabled": true, "maxLength": 20 });
    var text5743 = new Ext.form.TextField({ "disabled": true, "maxLength": 50 });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ { "width": Lino.chars2width(22), "colIndex": 0, "sortable": false, "dataIndex": "value", "header": "Wert", "editable": false, "tooltip": "(cal.AccessClasses.value) " }, { "width": Lino.chars2width(22), "colIndex": 1, "sortable": false, "dataIndex": "name", "header": "name", "editable": false, "tooltip": "(cal.AccessClasses.name) " }, { "width": Lino.chars2width(22), "colIndex": 2, "sortable": false, "dataIndex": "text", "header": "Text", "editable": false, "tooltip": "(cal.AccessClasses.text) " } ];
    Lino.cal.AccessClasses.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.cal.AccessClasses.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.cal.AccessClasses.GridPanel(p);
});

// js_render_GridPanel_class cbss.QueryRegister
Lino.cbss.QueryRegister.GridPanel = Ext.extend(Lino.GridPanel,{
  ls_url : "/cbss/QueryRegister",
  ls_bbar_actions : [  ],
  title : "QueryRegister",
  page_length : 20,
  gc_name : 0,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "name": "value" }, { "name": "name" }, { "name": "text" }, { "name": "disabled_fields" }, { "name": "disabled_actions" } ],
  ls_grid_configs : [  ],
  viewConfig : { "emptyText": "Keine Daten anzuzeigen." },
  disable_editing : true,
  disabled_actions_index : 4,
  initComponent : function() {
    var ww = this.containing_window;
    var value5745 = new Ext.form.TextField({ "disabled": true, "maxLength": 20 });
    var name5746 = new Ext.form.TextField({ "disabled": true, "maxLength": 20 });
    var text5747 = new Ext.form.TextField({ "disabled": true, "maxLength": 50 });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ { "width": Lino.chars2width(22), "colIndex": 0, "sortable": false, "dataIndex": "value", "header": "Wert", "editable": false, "tooltip": "(cbss.QueryRegister.value) " }, { "width": Lino.chars2width(22), "colIndex": 1, "sortable": false, "dataIndex": "name", "header": "name", "editable": false, "tooltip": "(cbss.QueryRegister.name) " }, { "width": Lino.chars2width(22), "colIndex": 2, "sortable": false, "dataIndex": "text", "header": "Text", "editable": false, "tooltip": "(cbss.QueryRegister.text) " } ];
    Lino.cbss.QueryRegister.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.cbss.QueryRegister.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.cbss.QueryRegister.GridPanel(p);
});

// js_render_GridPanel_class isip.ContractEvents
Lino.isip.ContractEvents.GridPanel = Ext.extend(Lino.GridPanel,{
  ls_url : "/isip/ContractEvents",
  ls_bbar_actions : [  ],
  title : "Beobachtungskriterium",
  page_length : 20,
  gc_name : 0,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "name": "value" }, { "name": "name" }, { "name": "text" }, { "name": "disabled_fields" }, { "name": "disabled_actions" } ],
  ls_grid_configs : [  ],
  viewConfig : { "emptyText": "Keine Daten anzuzeigen." },
  disable_editing : true,
  disabled_actions_index : 4,
  initComponent : function() {
    var ww = this.containing_window;
    var value5749 = new Ext.form.TextField({ "disabled": true, "maxLength": 20 });
    var name5750 = new Ext.form.TextField({ "disabled": true, "maxLength": 20 });
    var text5751 = new Ext.form.TextField({ "disabled": true, "maxLength": 50 });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ { "width": Lino.chars2width(22), "colIndex": 0, "sortable": false, "dataIndex": "value", "header": "Wert", "editable": false, "tooltip": "(isip.ContractEvents.value) " }, { "width": Lino.chars2width(22), "colIndex": 1, "sortable": false, "dataIndex": "name", "header": "name", "editable": false, "tooltip": "(isip.ContractEvents.name) " }, { "width": Lino.chars2width(22), "colIndex": 2, "sortable": false, "dataIndex": "text", "header": "Text", "editable": false, "tooltip": "(isip.ContractEvents.text) " } ];
    Lino.isip.ContractEvents.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.isip.ContractEvents.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.isip.ContractEvents.GridPanel(p);
});

// js_render_GridPanel_class lino.Genders
Lino.lino.Genders.GridPanel = Ext.extend(Lino.GridPanel,{
  ls_url : "/lino/Genders",
  ls_bbar_actions : [  ],
  title : "Genders",
  page_length : 20,
  gc_name : 0,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "name": "value" }, { "name": "name" }, { "name": "text" }, { "name": "disabled_fields" }, { "name": "disabled_actions" } ],
  ls_grid_configs : [  ],
  viewConfig : { "emptyText": "Keine Daten anzuzeigen." },
  disable_editing : true,
  disabled_actions_index : 4,
  initComponent : function() {
    var ww = this.containing_window;
    var value5753 = new Ext.form.TextField({ "disabled": true, "maxLength": 20 });
    var name5754 = new Ext.form.TextField({ "disabled": true, "maxLength": 20 });
    var text5755 = new Ext.form.TextField({ "disabled": true, "maxLength": 50 });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ { "width": Lino.chars2width(22), "colIndex": 0, "sortable": false, "dataIndex": "value", "header": "Wert", "editable": false, "tooltip": "(lino.Genders.value) " }, { "width": Lino.chars2width(22), "colIndex": 1, "sortable": false, "dataIndex": "name", "header": "name", "editable": false, "tooltip": "(lino.Genders.name) " }, { "width": Lino.chars2width(22), "colIndex": 2, "sortable": false, "dataIndex": "text", "header": "Text", "editable": false, "tooltip": "(lino.Genders.text) " } ];
    Lino.lino.Genders.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.lino.Genders.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.lino.Genders.GridPanel(p);
});

// js_render_GridPanel_class pcsw.ClientEvents
Lino.pcsw.ClientEvents.GridPanel = Ext.extend(Lino.GridPanel,{
  ls_url : "/pcsw/ClientEvents",
  ls_bbar_actions : [  ],
  title : "Beobachtungskriterium",
  page_length : 20,
  gc_name : 0,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "name": "value" }, { "name": "name" }, { "name": "text" }, { "name": "disabled_fields" }, { "name": "disabled_actions" } ],
  ls_grid_configs : [  ],
  viewConfig : { "emptyText": "Keine Daten anzuzeigen." },
  disable_editing : true,
  disabled_actions_index : 4,
  initComponent : function() {
    var ww = this.containing_window;
    var value5757 = new Ext.form.TextField({ "disabled": true, "maxLength": 20 });
    var name5758 = new Ext.form.TextField({ "disabled": true, "maxLength": 20 });
    var text5759 = new Ext.form.TextField({ "disabled": true, "maxLength": 50 });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ { "width": Lino.chars2width(22), "colIndex": 0, "sortable": false, "dataIndex": "value", "header": "Wert", "editable": false, "tooltip": "(pcsw.ClientEvents.value) " }, { "width": Lino.chars2width(22), "colIndex": 1, "sortable": false, "dataIndex": "name", "header": "name", "editable": false, "tooltip": "(pcsw.ClientEvents.name) " }, { "width": Lino.chars2width(22), "colIndex": 2, "sortable": false, "dataIndex": "text", "header": "Text", "editable": false, "tooltip": "(pcsw.ClientEvents.text) " } ];
    Lino.pcsw.ClientEvents.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.pcsw.ClientEvents.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.pcsw.ClientEvents.GridPanel(p);
});

// js_render_GridPanel_class pcsw.ResidenceType
Lino.pcsw.ResidenceType.GridPanel = Ext.extend(Lino.GridPanel,{
  ls_url : "/pcsw/ResidenceType",
  ls_bbar_actions : [  ],
  title : "ResidenceType",
  page_length : 20,
  gc_name : 0,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "name": "value" }, { "name": "name" }, { "name": "text" }, { "name": "disabled_fields" }, { "name": "disabled_actions" } ],
  ls_grid_configs : [  ],
  viewConfig : { "emptyText": "Keine Daten anzuzeigen." },
  disable_editing : true,
  disabled_actions_index : 4,
  initComponent : function() {
    var ww = this.containing_window;
    var value5765 = new Ext.form.TextField({ "disabled": true, "maxLength": 20 });
    var name5766 = new Ext.form.TextField({ "disabled": true, "maxLength": 20 });
    var text5767 = new Ext.form.TextField({ "disabled": true, "maxLength": 50 });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ { "width": Lino.chars2width(22), "colIndex": 0, "sortable": false, "dataIndex": "value", "header": "Wert", "editable": false, "tooltip": "(pcsw.ResidenceType.value) " }, { "width": Lino.chars2width(22), "colIndex": 1, "sortable": false, "dataIndex": "name", "header": "name", "editable": false, "tooltip": "(pcsw.ResidenceType.name) " }, { "width": Lino.chars2width(22), "colIndex": 2, "sortable": false, "dataIndex": "text", "header": "Text", "editable": false, "tooltip": "(pcsw.ResidenceType.text) " } ];
    Lino.pcsw.ResidenceType.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.pcsw.ResidenceType.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.pcsw.ResidenceType.GridPanel(p);
});
