/*
 Copyright 2009-2013 Luc Saffre
 This file is part of the Lino project.
 Lino is free software; you can redistribute it and/or modify 
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 3 of the License, or
 (at your option) any later version.
 Lino is distributed in the hope that it will be useful, 
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the 
 GNU General Public License for more details.
 You should have received a copy of the GNU General Public License
 along with Lino; if not, see <http://www.gnu.org/licenses/>.
*/

// lino.js --- generated Tue Sep 24 21:48:35 2013 by Lino version 1.6.12.
Ext.BLANK_IMAGE_URL = '/media/extjs/resources/images/default/s.gif';
LANGUAGE_CHOICES = [ [ "en", "English" ], [ "fr", "French" ], [ "de", "German" ], [ "nl", "Dutch" ] ];
MEDIA_URL = "/media";

/* MonthPickerPlugin: thanks to keypoint @ sencha forum
   http://www.sencha.com/forum/showthread.php?74002-3.x-Ext.ux.MonthMenu&p=356860#post356860
*/
Ext.namespace('Ext.ux'); 

Ext.ux.MonthPickerPlugin = function() { 
    var picker; 
    var oldDateDefaults; 

    this.init = function(pk) { 
        picker = pk; 
        picker.onTriggerClick = picker.onTriggerClick.createSequence(onClick); 
        picker.getValue = picker.getValue.createInterceptor(setDefaultMonthDay).createSequence(restoreDefaultMonthDay); 
        picker.beforeBlur = picker.beforeBlur.createInterceptor(setDefaultMonthDay).createSequence(restoreDefaultMonthDay); 
    }; 

    function setDefaultMonthDay() { 
        oldDateDefaults = Date.defaults.d; 
        Date.defaults.d = 1; 
        return true; 
    } 

    function restoreDefaultMonthDay(ret) { 
        Date.defaults.d = oldDateDefaults; 
        return ret; 
    } 

    function onClick(e, el, opt) { 
        var p = picker.menu.picker; 
        p.activeDate = p.activeDate.getFirstDateOfMonth(); 
        if (p.value) { 
            p.value = p.value.getFirstDateOfMonth(); 
        } 

        p.showMonthPicker(); 
         
        if (!p.disabled) { 
            p.monthPicker.stopFx(); 
            p.monthPicker.show(); 

            p.mun(p.monthPicker, 'click', p.onMonthClick, p); 
            p.mun(p.monthPicker, 'dblclick', p.onMonthDblClick, p); 
            p.onMonthClick = p.onMonthClick.createSequence(pickerClick); 
            p.onMonthDblClick = p.onMonthDblClick.createSequence(pickerDblclick); 
            p.mon(p.monthPicker, 'click', p.onMonthClick, p); 
            p.mon(p.monthPicker, 'dblclick', p.onMonthDblClick, p); 
        } 
    } 

    function pickerClick(e, t) { 
        var el = new Ext.Element(t); 
        if (el.is('button.x-date-mp-cancel')) { 
            picker.menu.hide(); 
        } else if(el.is('button.x-date-mp-ok')) { 
            var p = picker.menu.picker; 
            p.setValue(p.activeDate); 
            p.fireEvent('select', p, p.value); 
        } 
    } 

    function pickerDblclick(e, t) { 
        var el = new Ext.Element(t); 
        if (el.parent() 
            && (el.parent().is('td.x-date-mp-month') 
            || el.parent().is('td.x-date-mp-year'))) { 

            var p = picker.menu.picker; 
            p.setValue(p.activeDate); 
            p.fireEvent('select', p, p.value); 
        } 
    } 
}; 

Ext.preg('monthPickerPlugin', Ext.ux.MonthPickerPlugin);  

//~ /* 
  //~ http://www.diloc.de/blog/2008/03/05/how-to-submit-ext-forms-the-right-way/
//~ */
//~ /**
 //~ * This submit action is basically the same as the normal submit action,
 //~ * only that it uses the fields getSubmitValue() to compose the values to submit,
 //~ * instead of looping over the input-tags in the form-tag of the form.
 //~ *
 //~ * To use it, just use the OOSubmit-plugin on either a FormPanel or a BasicForm,
 //~ * or explicitly call form.doAction('oosubmit');
 //~ *
 //~ * @param {Object} form
 //~ * @param {Object} options
 //~ */
//~ Ext.ux.OOSubmitAction = function(form, options){
    //~ Ext.ux.OOSubmitAction.superclass.constructor.call(this, form, options);
//~ };

//~ Ext.extend(Ext.ux.OOSubmitAction, Ext.form.Action.Submit, {
    //~ /**
    //~ * @cfg {boolean} clientValidation Determines whether a Form's fields are validated
    //~ * in a final call to {@link Ext.form.BasicForm#isValid isValid} prior to submission.
    //~ * Pass <tt>false</tt> in the Form's submit options to prevent this. If not defined, pre-submission field validation
    //~ * is performed.
    //~ */
    //~ type : 'oosubmit',

    //~ // private
    //~ /**
     //~ * This is nearly a copy of the original submit action run method
     //~ */
    //~ run : function(){
        //~ var o = this.options;
        //~ var method = this.getMethod();
        //~ var isPost = method == 'POST';

        //~ var params = this.options.params || {};
        //~ if (isPost) Ext.applyIf(params, this.form.baseParams);

        //~ //now add the form parameters
        //~ this.form.items.each(function(field)
        //~ {
            //~ if (!field.disabled)
            //~ {
                //~ //check if the form item provides a specialized getSubmitValue() and use that if available
                //~ if (typeof field.getSubmitValue == "function")
                    //~ params[field.getName()] = field.getSubmitValue();
                //~ else
                    //~ params[field.getName()] = field.getValue();
            //~ }
        //~ });

        //~ //convert params to get style if we are not post
        //~ if (!isPost) params=Ext.urlEncode(params);

        //~ if(o.clientValidation === false || this.form.isValid()){
            //~ Ext.Ajax.request(Ext.apply(this.createCallback(o), {
                //~ url:this.getUrl(!isPost),
                //~ method: method,
                //~ params:params, //add our values
                //~ isUpload: this.form.fileUpload
            //~ }));

        //~ }else if (o.clientValidation !== false){ // client validation failed
            //~ this.failureType = Ext.form.Action.CLIENT_INVALID;
            //~ this.form.afterAction(this, false);
        //~ }
    //~ },

//~ });
//~ //add our action to the registry of known actions
//~ Ext.form.Action.ACTION_TYPES['oosubmit'] = Ext.ux.OOSubmitAction;




/**
JC Watsons solution (adapted to ExtJS 3.3.1 by LS) is elegant and simple:
`A "fix" for unchecked checkbox submission  behaviour
<http://www.sencha.com/forum/showthread.php?28449>`_

Added special handling for checkbox inputs. 
ExtJS defines disabled checkboxes `readonly`, not `disabled` as for other inputs.

*/
Ext.lib.Ajax.serializeForm = function(form) {
    //~ console.log('20120203 linolib.js serializeForm',form);
    var fElements = form.elements || (document.forms[form] || Ext.getDom(form)).elements, 
        hasSubmit = false, 
        encoder = encodeURIComponent, 
        name, 
        data = '', 
        type, 
        hasValue;

    Ext.each(fElements, function(element){
        name = element.name;
        type = element.type;

        if (!element.disabled && name && !(type == 'checkbox' && element.readonly)) {
            if (/select-(one|multiple)/i.test(type)) {
                Ext.each(element.options, function(opt){
                    if (opt.selected) {
                        hasValue = opt.hasAttribute ? opt.hasAttribute('value') : opt.getAttributeNode('value').specified;
                        data += String.format("{0}={1}&", encoder(name), encoder(hasValue ? opt.value : opt.text));
                    }
                });
            } else if (!(/file|undefined|reset|button/i.test(type))) {
                //~ if (!(/radio|checkbox/i.test(type) && !element.checked) && !(type == 'submit' && hasSubmit)) {
                if (!(type == 'submit' && hasSubmit)) {
                    if (type == 'checkbox') {
                        //~ console.log('20111001',element,'data += ',encoder(name) + '=' + (element.checked ? 'on' : 'off') + '&');
                        data += encoder(name) + '=' + (element.checked ? 'on' : 'off') + '&';
                    } else {
                        //~ console.log('20111001',element,'data += ',encoder(name) + '=' + encoder(element.value) + '&');
                        data += encoder(name) + '=' + encoder(element.value) + '&';
                    }
                    hasSubmit = /submit/i.test(type);
                }
            }
        //~ } else {
            //~ console.log(name,type,element.readonly);
        }
    });
    return data.substr(0, data.length - 1);
};



/*
Set a long timeout of fifteen minutes. 
See /blog/2012/0307
*/
Ext.Ajax.timeout = 15 * 60 * 1000; 

/*
 * Thanks to 
 * `huuze <http://stackoverflow.com/users/10040/huuuze>`_ for the question
 * and to 
 * `chrisv <http://stackoverflow.com/users/683808/chrisv>`_
 * for the answer on
 * http://stackoverflow.com/questions/3764589/how-do-i-include-django-1-2s-csrf-token-in-a-javascript-generated-html-form/5485616#5485616
 * 
 * */
 
Ext.Ajax.on('beforerequest', function (conn, options) {
   if (!(/^http:.*/.test(options.url) || /^https:.*/.test(options.url))) {
     if (typeof(options.headers) == "undefined") {
       options.headers = {'X-CSRFToken': Ext.util.Cookies.get('csrftoken')};
     } else {
       options.headers.extend({'X-CSRFToken': Ext.util.Cookies.get('csrftoken')});
     }                        
   }
}, this);


/*
My fix for the "Cannot set QuickTips dismissDelay to 0" bug,
see http://www.sencha.com/forum/showthread.php?183515 
*/
Ext.override(Ext.QuickTip,{
  showAt : function(xy){
        var t = this.activeTarget;
        //~ console.log("20120224 QuickTip.showAt",this.title,this.dismissDelay,t.dismissDelay);
        if(t){
            if(!this.rendered){
                this.render(Ext.getBody());
                this.activeTarget = t;
            }
            if(t.width){
                this.setWidth(t.width);
                this.body.setWidth(this.adjustBodyWidth(t.width - this.getFrameWidth()));
                this.measureWidth = false;
            } else{
                this.measureWidth = true;
            }
            this.setTitle(t.title || '');
            this.body.update(t.text);
            this.autoHide = t.autoHide;
            // bugfix by Luc 20120226
            if (t.dismissDelay != undefined) this.dismissDelay = t.dismissDelay;
            //~ this.dismissDelay = t.dismissDelay || this.dismissDelay;
            if(this.lastCls){
                this.el.removeClass(this.lastCls);
                delete this.lastCls;
            }
            if(t.cls){
                this.el.addClass(t.cls);
                this.lastCls = t.cls;
            }
            if(this.anchor){
                this.constrainPosition = false;
            }else if(t.align){ 
                xy = this.el.getAlignToXY(t.el, t.align);
                this.constrainPosition = false;
            }else{
                this.constrainPosition = true;
            }
        }
        Ext.QuickTip.superclass.showAt.call(this, xy);
    }
});

/*
Another hack. See /docs/blog/2012/0228
*/
Ext.Element.addMethods(
    function() {
        var VISIBILITY      = "visibility",
            DISPLAY         = "display",
            HIDDEN          = "hidden",
            NONE            = "none",
            XMASKED         = "x-masked",
            XMASKEDRELATIVE = "x-masked-relative",
            data            = Ext.Element.data;

        return {
            
            mask : function(msg, msgCls) {
                var me  = this,
                    dom = me.dom,
                    dh  = Ext.DomHelper,
                    EXTELMASKMSG = "ext-el-mask-msg",
                    el,
                    mask;
                // removed the following lines. See /docs/blog/2012/0228
                //~ if (!(/^body/i.test(dom.tagName) && me.getStyle('position') == 'static')) {
                    //~ console.log(20120228,dom.tagName,me);
                    //~ me.addClass(XMASKEDRELATIVE); 
                //~ }
                if (el = data(dom, 'maskMsg')) {
                    el.remove();
                }
                if (el = data(dom, 'mask')) {
                    el.remove();
                }

                mask = dh.append(dom, {cls : "ext-el-mask"}, true);
                data(dom, 'mask', mask);

                me.addClass(XMASKED);
                mask.setDisplayed(true);
                
                if (typeof msg == 'string') {
                    var mm = dh.append(dom, {cls : EXTELMASKMSG, cn:{tag:'div'}}, true);
                    data(dom, 'maskMsg', mm);
                    mm.dom.className = msgCls ? EXTELMASKMSG + " " + msgCls : EXTELMASKMSG;
                    mm.dom.firstChild.innerHTML = msg;
                    mm.setDisplayed(true);
                    mm.center(me);
                }
                
                
                if (Ext.isIE && !(Ext.isIE7 && Ext.isStrict) && me.getStyle('height') == 'auto') {
                    mask.setSize(undefined, me.getHeight());
                }
                
                return mask;
            }

            
        };
    }()
);



Ext.namespace('Lino');
    
    

//~ Lino.subst_user_field = new Ext.form.ComboBox({});
//~ Lino.subst_user = null;
Lino.insert_subst_user = function(p){
    //~ console.log('20120714 insert_subst_user',Lino.subst_user,p);
    //~ if (Lino.subst_user_field.getValue()) {
    if (p.su) return;
    if (Lino.subst_user) {
        //~ p.su = Lino.subst_user_field.getValue();
        p.su = Lino.subst_user;
    //~ } else {
        //~ delete p.su;
    }
    //~ console.log('20120714 insert_subst_user -->',Lino.subst_user,p);
}

Lino.login_window = null;


Lino.show_login_window = function(on_login) {
  //~ console.log('20121103 show_login_window',arguments);
  //~ var current_window = Lino.current_window;
  if (Lino.login_window == null) {
    
      function do_login() { 
            //~ alert("20130923 do_login() started");
            Lino.viewport.loadMask.show()
            //~ Lino.body_loadMask.show()
            login_panel.getForm().submit({ 
                method:'POST', 
                waitTitle:'Connecting', 
                waitMsg:'Sending data...',
                success:function(){ 
                  //~ console.log('20130923 logged in',arguments);
                  //~ alert("20130923 do_login() success");
                  Lino.login_window.hide();
                  Lino.close_all_windows();
                  Lino.viewport.loadMask.hide();
                  if (typeof on_login == 'string') {
                      //~ console.log("20130829 on_login",on_login);
                      //~ alert("20130923 on_login gonna load_url");
                      Lino.load_url(on_login);
                      //~ eval(on_login);
                  } 
                  //~ else Lino.load_url(/);
                  //~ Lino.body_loadMask.hide();
                },
                failure: function(form,action) { 
                  //~ this.loadMask.hide();
                  //~ alert("20130923 do_login() failure");
                  Lino.on_submit_failure(form,action);
                  Lino.viewport.loadMask.hide()
                  //~ Lino.body_loadMask.hide()
                  //~ if (Lino.current_window) Lino.current_window.main_item.loadMask.hide()
                }
                //~ failure:function(form, action){ 
                    //~ alert_msg
                    //~ if(action.failureType == 'server'){ 
                        //~ obj = Ext.util.JSON.decode(action.response.responseText); 
                        //~ Ext.Msg.alert('Login Failed!', obj.errors.reason); 
                    //~ }else{ 
                        //~ Ext.Msg.alert('Warning!', 'Authentication server is unreachable : ' + action.response.responseText); 
                    //~ } 
                    //~ Lino.login_panel.getForm().reset(); 
                //~ } 
            }); 
      };
    
      var login_button = new Ext.Button({ 
        text:"Log in",
        formBind: true,	 
        // Function that fires when user clicks the button 
        handler: do_login});
    
      var login_panel = new Ext.FormPanel({ 
        //~ inspired by http://www.sencha.com/learn/a-basic-login/
        autoHeight:true,
        labelWidth:90,
        url:'/auth', 
        frame:true, 
        defaultType:'textfield',
        monitorValid:true,
        items:[{ 
            fieldLabel:"Username", 
            id: 'username',
            name:'username', 
            autoHeight:true,
            allowBlank:false 
        },{ 
            fieldLabel:"Password", 
            name:'password', 
            inputType:'password', 
            autoHeight:true,
            allowBlank:false 
        }],        
        buttons:[ login_button ]});
        
      Lino.login_window = new Ext.Window({
          layout:'fit',
          defaultButton: 'username',
          width:300,
          title:"Log in", 
          autoHeight:true,
          modal: true,
          closeAction: "hide",
          keys: {
            key: Ext.EventObject.ENTER,
            fn: function() { do_login()}
          },
          //~ defaultButton: login_button,
          //~ height:'auto',
          //~ closable: false,
          //~ resizable: false,
          //~ plain: true,
          //~ border: false,
          items: [login_panel] });
  };
  Lino.login_window.show();
};

Lino.logout = function(id,name) {
    //~ console.log('20121104 gonna log out',arguments);
    //~ Lino.do_action
    Lino.call_ajax_action(Lino.viewport,'GET',
        '/auth',{},'logout',undefined,undefined,function(){
        //~ console.log('20121104 logged out',arguments);
        //~ Lino.login_window.hide();
        Lino.close_all_windows();
    })
}

Lino.set_subst_user = function(id,name) {
    //~ console.log(20130723,'Lino.set_subst_user',id,name,Lino.current_window,Lino.viewport);
    Lino.subst_user = id;
//~ 
    if (Lino.current_window) 
        Lino.current_window.main_item.set_base_param("su",id);
    if (Lino.viewport) 
        Lino.permalink_handler(Lino.current_window)();
}



//~ Lino.select_subst_user = function(cmp,rec,value){
    //~ Lino.subst_user=value;
    //~ console.log(20120713,rec);
//~ }
    
Lino.current_window = null;
Lino.window_history = Array();
    
Lino.chars2width = function(cols) {  return cols * 9; }
Lino.rows2height = function(cols) {  return cols * 20; }



Lino.MainPanel = {
  is_home_page : false,
  setting_param_values : false,
  config_containing_window : function(wincfg) { }
  ,init_containing_window : function(win) { }
  ,is_loading : function() { 
      if (!this.rendered) return true;
      //~ return (Ext.select('.x-loading-msg').elements.length > 0);
      return true; 
    } 
  ,do_when_clean : function(auto_save,todo) { todo() }
  ,get_master_params : function() {
    var p = {}
    p['mt'] = this.content_type; 
    rec = this.get_current_record()
    if (rec) {
      if (rec.phantom) {
          p['mk'] = undefined; 
      }else{
          p['mk'] = rec.id; 
      }
    } else {
      p['mk'] = undefined;
    }
    //~ console.log('get_master_params returns',p,'using record',rec);
    return p;
  }
  ,get_permalink : function() {
    //~ var p = this.main_item.get_base_params() || {};
    var p = Ext.apply({},this.get_base_params());
    delete p.fmt;
    //~ if (p.fmt) delete p.fmt;
    Ext.apply(p,this.get_permalink_params());
    
    if (this.toggle_params_panel_btn) {
        p.sp = this.toggle_params_panel_btn.pressed;
        //~ if (this.toggle_params_panel_btn.pressed == this.params_panel_hidden) {
          //~ p.sp = true;
        //~ }
    }
    
    //~ Lino.insert_subst_user(p);
     //~ p.fmt = 'html';
    //~ console.log('get_permalink',p,this.get_permalink_params());
    if (this.is_home_page)
        //~ var url = '';
        var url = '/';
    else 
        var url = this.get_permalink_url();
    if (p.su == null) 
        delete p.su;
    if (Ext.urlEncode(p)) url = url + "?" + Ext.urlEncode(p);
    return url;
  }
  ,get_record_url : function(record_id) {
      var url = '/api' + this.ls_url
      //~ var url = this.containing_window.config.url_data; // ls_url;
      url += '/' + (record_id === undefined ? '-99999' : String(record_id));
      //~ if (record_id !== undefined) url += '/' + String(record_id);
      //~ url += '/' + String(record_id);
      return url;
  }
  ,get_permalink_url : function() {
      return '/api' + this.ls_url;
  }
  ,get_permalink_params : function() {
      //~ return {an:'grid'};
      var p = {};
      if (this.action_name)
          p.an = this.action_name;
      this.add_param_values(p,false)
      return p;
  }
  ,set_status : function(status) {}
  ,get_status : function() { return {}}
  ,refresh : function() {}
  ,get_base_params : function() { 
    var p = {};
    Lino.insert_subst_user(p);
    return p;
  }
  ,add_params_panel : function (tbar) {
      if (this.params_panel) {
        //~  20130923b
        //~ this.params_panel.autoHeight = true; // 20130924
        var t = this;
        var update = function() {
            var p = t.params_panel;
            //~ console.log("update", p.getSize().height,p.forceLayout,p.autoHeight);
            var w = t.get_containing_window();
            Lino.do_when_visible(w, function() {
                //~ p.doLayout(true); // doLayout(shallow, force)
                w.doLayout(true); // doLayout(shallow, force)
                //~ t.params_panel.on('afterlayout',update,t,{single:true});
            });
        };
        Lino.do_when_visible(this.params_panel, update);
        this.params_panel.on('show',update);
        this.params_panel.on('hide',update);
        //~ this.params_panel.on('bodyresize',update);
        this.params_panel.on('afterlayout',update);
        //~ this.params_panel.on('afterlayout',update,this,{single:true});
        //~ this.params_panel.on('bodyresize',update,this,{single:true});
        //~ this.params_panel.on('resize',update,this,{single:true});
        //~ this.params_panel.on('render',update,this,{single:true});
        
        // this.params_panel.on('render',
        //~ this.params_panel.on('afterlayout',update,this,{single:true,delay:200});
        //~ this.params_panel.on('bodyresize',update,this,{single:true,delay:200});
        this.toggle_params_panel_btn = new Ext.Button({ scope:this, 
          //~ text: "$_("[parameters]")", // gear
          iconCls: 'x-tbar-parameters',
          tooltip:"Show or hide the table parameters panel",
          enableToggle: true,
          //~ pressed: ! this.params_panel.hidden,
          pressed: ! this.params_panel_hidden,
          toggleHandler: function(btn,state) { 
            //~ console.log("20120210 add_params_panel",state,this.params_panel);
            if (state) {
                this.params_panel.show();
            } else {
                this.params_panel.hide();
            }
            //~ this.params_panel.on('afterlayout',update,this,{single:true});
            //~ t.get_containing_window().doLayout();
            //~ this.params_panel.on('afterlayout',function() {
                //~ console.log("20130918 afterlayout");
                //~ t.get_containing_window().doLayout(); // doLayout(shallow, force)
            //~ },this,{single:true});
          }
        }); 
        tbar = tbar.concat([this.toggle_params_panel_btn]);
        var refresh = function() {
            if (!t.setting_param_values) {
                t._force_dirty = true; 
                t.refresh();
            }
        }
        Ext.each(this.params_panel.fields,function(f) {
          //~ f.on('valid',function() {t.refresh()});
          if (f instanceof Ext.form.Checkbox) {
              f.on('check',refresh);
          } else if (f instanceof Ext.DatePicker) {
              f.on('select',refresh);
          } else if (f instanceof Ext.form.TriggerField) {
              f.on('select',refresh);
              //~ f.on('change',refresh);
              //~ f.on('valid',refresh);
          } else {
              if (! f.on) 
                  console.log("20121010 no method 'on'",f);
              else
                  f.on('change',refresh);
            }
          });
      }
      return tbar;
  }
  ,add_param_values : function (p,force_dirty) {
    if (this.params_panel) {
      /* 
      * 20120918 add param_values to the request string 
      * *only if the params_form is dirty*.
      * Otherwise Actor.default_params() would never be used.
      *
      * 20121023 But IntegClients.params_default has non-empty default values. 
      * Users must have the possibility to make them empty.
      * 
      * 20130605 : added `force_dirty` parameter because Checkbox fields don't 
      * mark their form as dirty when check is fired.
      * 
      * 20130721 : `force_dirty` not as a parameter but as 
      * `this._force_dirty` because
      * 
      * 20130915 : both _force_dirty and force_dirty parameter are needed.
      * 
      */
      if (force_dirty || this._force_dirty || this.params_panel.form.isDirty()) {
      //~ if (this._force_dirty || this.params_panel.form.isDirty()) {
        p.pv = this.get_param_values();
        //~ console.log("20130923 form is dirty (",force_dirty,this._force_dirty,this.params_panel.form.isDirty(),")");
        //~ console.log("20130923 form is dirty",p);
      }else{
        //~ console.log("20130923 form not dirty:",this.params_panel.form);
        if (this.status_param_values) 
          p.pv = Lino.fields2array(
            this.params_panel.fields,this.status_param_values);
      }
      //~ if (!this.params_panel.form.isDirty()) return;
      //~ p.pv = this.get_param_values();
      //~ console.log("20120203 add_param_values added pv",p.pv,"to",p);
    }
  },
  get_param_values : function() { // similar to get_field_values()
      return Lino.fields2array(this.params_panel.fields);
  },
  set_param_values : function(pv) {
    if (this.params_panel) {
      //~ console.log('20120203 MainPanel.set_param_values', pv);
      this.status_param_values = pv;
      //~ this.params_panel.form.suspendEvents(false);
      this.setting_param_values = true;
      if (pv) { 
          this.params_panel.form.my_loadRecord(pv);
      } else { 
        this.params_panel.form.reset(); 
      }
      this.setting_param_values = false;
      this._force_dirty = false; 
      //~ this.params_panel.form.resumeEvents();
    }
  }
};




Lino.Viewport = Ext.extend(Ext.Viewport,Lino.MainPanel);
Lino.Viewport = Ext.extend(Lino.Viewport,{
  layout : "fit"
  ,is_home_page : true
  ,initComponent : function(){
    Lino.Viewport.superclass.initComponent.call(this);
    this.on('render',function(){
      this.loadMask = new Ext.LoadMask(this.el,{msg:"Please wait..."});
      //~ console.log("20121118 Lino.viewport.loadMask",this.loadMask);
    },this);
  }
  ,get_base_params : function() { 
    var p = {};
    Lino.insert_subst_user(p);
    return p;
  }
  ,refresh : function() {
      var caller = this;
      //~ console.log("20121120 Lino.Viewport.refresh()");
      if (caller.loadMask) caller.loadMask.show();
      var success = function(response) {
        if (caller.loadMask) caller.loadMask.hide();
        if (response.responseText) {
          var result = Ext.decode(response.responseText);
          //~ console.log('Lino.do_action()',action.name,'result is',result);
          if (result.html) {
              Ext.getCmp('main_area').update(result.html);
          }
          if (result.message) {
              if (result.alert) {
                  //~ Ext.MessageBox.alert('Alert',result.alert_msg);
                  Ext.MessageBox.alert('Alert',result.message);
              } else {
                  Lino.notify(result.message);
              }
          }
          
          if (result.notify_msg) Lino.notify(result.notify_msg);
          if (result.js_code) { 
            var jsr = result.js_code(caller);
            //~ console.log('Lino.do_action()',action,'returned from js_code in',result);
          };
        }
      };
      var action = {
        url : '/api/main_html',
        waitMsg: "Please wait...",
        failure: Lino.ajax_error_handler(caller),
        success: success,
        method: 'GET',
        params: {}
      };
      Lino.insert_subst_user(action.params);
      Ext.Ajax.request(action);
    
  }
});




Lino.open_window = function(win,st,requesting_panel) {
  //~ console.log("20120918 Lino.open_window()",win,st);
  var cw = Lino.current_window;
  if (cw) {
    //~ console.log("20120918 Lino.open_window() save current status",cw.main_item.get_status());
    Lino.window_history.push({
      window:cw,
      status:cw.main_item.get_status()
    });
  }
  Lino.current_window = win;
  //~ if (st.su) 
      //~ Lino.subst_user_field.setValue(st.su);
  win.main_item.set_status(st,requesting_panel);
  win.show();
};

Lino.load_url = function(url) {
    //~ foo.bar.baz = 2; 
    //~ console.log("20121120 Lino.load_url()");
    //~ Lino.body_loadMask.show();
    Lino.viewport.loadMask.show();
    //~ location.replace(url);
    document.location = url;
}

Lino.close_window = function(status_update) {
  var cw = Lino.current_window;
  var ww = Lino.window_history.pop();
  if (ww) {
    //~ if (status_update) Ext.apply(ww.status,status_update);
    if (status_update) status_update(ww);
    ww.window.main_item.set_status(ww.status);
    Lino.current_window = ww.window;
  } else {
    Lino.current_window = null;
  }
  if (cw) cw.hide_really();
};

Lino.close_all_windows = function() {
  if (Lino.window_history.length == 0) {
      //~ Lino.viewport.refresh();
      var url =  "/"
      //~ console.log("20121120 Lino.close_all_windows() : no window_history");
      //~ if (ADMIN_URL) 
      var p = {};
      Lino.insert_subst_user(p)
      if (Ext.urlEncode(p)) url = url + "?" + Ext.urlEncode(p);
      Lino.load_url(url);
  } else {
    //~ console.log("20121120 Lino.close_all_windows() with window_history");
    while (Lino.window_history.length > 0) {
      Lino.close_window();
      //~ Lino.window_history.pop().hide_really();
    }
  }
  //~ Lino.current_window = null;
  //~ Lino.close_window();
  //~ var ww = 
}

Lino.kill_current_window = function() {
  var cw = Lino.current_window;
  Lino.current_window = null;
  if (cw) cw.hide_really();
};

Lino.calling_window = function() {
    if (Lino.window_history.length) return Lino.window_history[Lino.window_history.length-1];
}

//~ Lino.WindowAction = function(mainItemClass,windowConfig,mainConfig,ppf) {
Lino.WindowAction = function(windowConfig,main_item_fn) {
    //~ if(!mainConfig) mainConfig = {};
    //~ mainConfig.is_main_window = true;
    this.windowConfig = windowConfig;
    this.main_item_fn = main_item_fn;
    //~ if (ppf) mainConfig.params_panel.fields = ppf;
    //~ this.mainConfig = mainConfig;
    //~ this.mainItemClass = mainItemClass;
};

Lino.WindowAction = Ext.extend(Lino.WindowAction,{
    window : null,
    //~ mainItemClass: null,
    get_window : function() {
      //~ if(mainConfig) Ext.apply(this.mainConfig,mainConfig);
      if (this.window == null)  {
          //~ this.windowConfig.main_item = new this.mainItemClass(this.mainConfig);
          this.windowConfig.main_item = this.main_item_fn();
          this.window = new Lino.Window(this.windowConfig);
      }
      return this.window;
    },
    run : function(requesting_panel,status) {
      //~ console.log('20120625 window_action.run()',this)
      Lino.open_window(this.get_window(),status,requesting_panel);
    }
  
});


Lino.PanelMixin = {
  get_containing_window : function (){
      if (this.containing_window) return this.containing_window;
      return this.containing_panel.get_containing_window();
  }
  ,set_window_title : function(title) {
    //~ this.setTitle(title);
    var cw = this.get_containing_window();

    //~ if (cw) {
    //~ if (cw && cw.closable) {
    if (cw && !cw.main_item.hide_window_title) {
      //~ console.log('20111202 set_window_title(',title,') for',this.containing_window);
      //~ if (! this.containing_window.rendered) console.log("WARNING: not rendered!");
      cw.setTitle(title);
    //~ } else {
      //~ document.title = title;
    }
    //~ else console.log('20111202 not set_window_title(',title,') for',this);
  }
  
};


// Lino.status_bar = new Ext.ux.StatusBar({defaultText:'Lino version 1.6.12.'});
Lino.status_bar = new Ext.ux.StatusBar({
    autoClear: 10000, // 10 seconds
    defaultText:'Lino Welfare 1.1.9.'
    });



Lino.edit_tinymce_text = function(panel,options) {
  // `panel` is the RichTextPanel
  //~ console.log(20111220,panel);
  //~ var rec = panel.get_current_record();
  var rec = panel.containing_panel.get_current_record();
  var value = rec ? rec.data[panel.editor.name] : '';
  var saving = false;
  var todo_after_save = false;
  var discard_changes = false;
  
  
  function save() {
    //~ if (todo_after_save) {alert('tried to save again'); return; }
    if (saving) {alert('tried to save again'); return; }
    //~ var url = panel.containing_window.main_item.get_record_url(rec.id);
    var url = panel.containing_panel.get_record_url(rec.id);
    var params = Ext.apply({},panel.containing_panel.get_base_params());
    params[panel.editor.name] = editor.getValue();
    //~ params.su = Lino.subst_user;
    //~ Lino.insert_subst_user(params);
    var a = { 
      params: params, 
      method: 'PUT',
      url: url,
      failure: function() {
          //~ if (editor.ed.getContainer()) 
          editor.ed.setProgressState(0);
          todo_after_save = false;
          saving = false;
          console.log('tinymce.save() failed. sorry.',arguments);
        },
      success: function() {
        saving = false;
        //~ if (editor.ed.getContainer()) 
        editor.ed.setProgressState(0);
        rec.data[panel.editor.name] = editor.getValue();
        if(todo_after_save) {
            var fn = todo_after_save;
            todo_after_save = false;
            fn();
        }
        //~ panel.containing_window.set_current_record(rec);
        panel.refresh();
      }
    };
    //~ if (editor.ed.getContainer()) 
    editor.ed.setProgressState(1); // Show progress
    saving = true;
    //~ console.log(a);
    Ext.Ajax.request(a);
  };
  function save_callback() {
      save();
      //~ save(function(){editor.ed.setDirty(false);})
      /* return true have the save button disabled.  
      That's not perfect because the PUT is asynchronous 
      and the response is not yet known.
      */
      return true;
  }
  //~ var actions = [
    //~ {text:"Save",handler:save}
  //~ ]; 
  //~ console.log(20110610,panel.editor.disabled);
  var settings = {};
  Ext.apply(settings,{
        readonly: panel.editor.disabled,
        //~ language: "de",
        plugins : "save,emotions,spellchecker,advhr,insertdatetime,preview,table,searchreplace,template", 
        // Theme options - button# indicated the row# only
        theme_advanced_buttons1 : "save,cancel,|,bold,italic,underline,|,justifyleft,justifycenter,justifyright,fontselect,fontsizeselect,formatselect,|,search,replace",
        theme_advanced_buttons2 : "cut,copy,paste,template,|,bullist,numlist,|,outdent,indent,|,undo,redo,|,link,unlink,anchor,image,|,code,preview,|,forecolor,backcolor",
        theme_advanced_buttons3 : "insertdate,inserttime,|,spellchecker,advhr,,removeformat,|,sub,sup,|,charmap,emotions,|,tablecontrols",      
        theme_advanced_resizing : false,
        convert_urls : false,
        save_onsavecallback : save_callback,
        save_enablewhendirty : true
        //~ save_oncancelcallback: on_cancel
  });
  Ext.apply(settings,options);
  var editor = new Ext.ux.TinyMCE({
      value : value,
      tinymceSettings: settings
    });
  var win = new Ext.Window({
    title: rec.title, 
    //~ bbar: actions,
    layout: 'fit',
    items: editor,
    width: 600, 
    height:500,
    minWidth: 100,
		minHeight: 100,
    modal: true,
    resizable: true,
    maximizable: true,
    //~ maximized: true,
    //~ closeAction: "close"
    closeAction: "hide"
    //~ hideMode: "offsets",
    //~ constrainHeader: true,
    //~ bodyStyle: 'padding: 10px'
  });

  //~ win.on('beforeclose',function() {
  win.on('beforehide',function() {
    if (todo_after_save) return false;
    if (discard_changes) return true;
    if (editor.isDirty()) {
        //~ var ok = false;
        //~ var allowClose = true;
        var config = {title:"Confirmation"};
        config.buttons = Ext.MessageBox.YESNOCANCEL;
        config.msg = "Save changes to text ?";
        config.modal = true;
        config.fn = function(buttonId,text,opt) {
          //~ console.log('do_when_clean',buttonId)
          if (buttonId == "yes") {
              /* we cancel this close, but save()'s onSuccess will call again.*/
              //~ allowClose = false;
              todo_after_save = function(){win.hide();}
              editor.ed.execCommand('mceSave');
              //~ editor.ed.save(function(){win.close();});
          } else if (buttonId == "no") { 
              discard_changes = true;
              win.hide()
          //~ } else if (buttonId == "cancel") { 
            //~ ok = true;
              //~ allowClose = false;
          //~ } else { 
            //~ console.log('unknwon buttonId:',buttonId);
          }
        }
        Ext.MessageBox.show(config);
        return false;
        //~ return allowClose;
    }
  });
  win.show();
}







/* 
  Originally copied from Ext JS Library 3.3.1
  Modifications by Luc Saffre : 
  - rendering of phantom records
  - fire afteredit event
  - react on dblclcik, not on single click

 */
Lino.CheckColumn = Ext.extend(Ext.grid.Column, {

    processEvent : function(name, e, grid, rowIndex, colIndex){
        //~ console.log('20110713 Lino.CheckColumn.processEvent',name)
        if (name == 'click') {
        //~ if (name == 'mousedown') {
        //~ if (name == 'dblclick') {
            return this.toggleValue(grid, rowIndex, colIndex);
        } else {
            return Ext.grid.ActionColumn.superclass.processEvent.apply(this, arguments);
        }
    },
    
    toggleValue : function (grid,rowIndex,colIndex) {
        var record = grid.store.getAt(rowIndex);
        var dataIndex = grid.colModel.getDataIndex(colIndex);
        // 20120514
        //~ if(record.data.disabled_fields && record.data.disabled_fields[dataIndex]) {
          //~ Lino.notify("This field is disabled");
          //~ return false;
        //~ }
      
        //~ if (dataIndex in record.data['disabled_fields']) {
            //~ Lino.notify("This field is disabled.");
            //~ return false;
        //~ }
        var startValue = record.data[dataIndex];
        var value = !startValue;
        //~ record.set(this.dataIndex, value);
        var e = {
            grid: grid,
            record: record,
            field: dataIndex,
            originalValue: startValue,
            value: value,
            row: rowIndex,
            column: colIndex,
            cancel: false
        };
        if(grid.fireEvent("beforeedit", e) !== false && !e.cancel){
        //~ if(grid.fireEvent("validateedit", e) !== false && !e.cancel){
            record.set(dataIndex, value);
            delete e.cancel;
            grid.fireEvent("afteredit", e);
        }
        return false; // Cancel event propagation
    },

    renderer : function(v, p, record){
        if (record.phantom) return '';
        p.css += ' x-grid3-check-col-td'; 
        return String.format('<div class="x-grid3-check-col{0}">&#160;</div>', v ? '-on' : '');
    }

    // Deprecate use as a plugin. Remove in 4.0
    // init: Ext.emptyFn
});

// register ptype. Deprecate. Remove in 4.0
// Ext.preg('checkcolumn', Lino.CheckColumn);

// backwards compat. Remove in 4.0
// Ext.grid.CheckColumn = Lino.CheckColumn;

// register Column xtype
Ext.grid.Column.types.checkcolumn = Lino.CheckColumn;


/* 20110725 : 
Lino.on_tab_activate is necessary 
in contacts.Person.2.dtl 
(but don't ask me why...)
*/
Lino.on_tab_activate = function(item) {
  //~ console.log('activate',item); 
  if (item.rendered && item.doLayout) item.doLayout();
  //~ if (item.rendered) item.doLayout();
}

Lino.TimeField = Ext.extend(Ext.form.TimeField,{
  format: 'H:i',
  increment: 15
  });
Lino.DateField = Ext.extend(Ext.form.DateField,{
  boxMinWidth: Lino.chars2width(11),
  format: 'd.m.Y',
  altFormats: 'd/m/Y|Y-m-d'
  });
Lino.DatePickerField = Ext.extend(Ext.DatePicker,{
  //~ boxMinWidth: Lino.chars2width(11),
  format: 'd.m.Y',
  //~ altFormats: 'd/m/Y|Y-m-d'
  formatDate : function(date){
      //~ console.log("20121203 formatDate",this.name,date);
      return Ext.isDate(date) ? date.dateFormat(this.format) : date;
  }
  });
Lino.DateTimeField = Ext.extend(Ext.ux.form.DateTime,{
  dateFormat: 'd.m.Y',
  timeFormat: 'H:i'
  //~ ,hiddenFormat: 'd.m.Y H:i'
  });
Lino.URLField = Ext.extend(Ext.form.TriggerField,{
  triggerClass : 'x-form-search-trigger',
  //~ triggerClass : 'x-form-world-trigger',
  vtype: 'url',
  onTriggerClick : function() {
    //~ console.log('Lino.URLField.onTriggerClick',this.value)
    //~ document.location = this.value;
    window.open(this.getValue(),'_blank');
  }
});
Lino.IncompleteDateField = Ext.extend(Ext.form.TextField,{
  //~ regex: /^-?\d+-[01]\d-[0123]\d$/,
  //~ regex: /^[0123]\d\.[01]\d\.-?\d+$/,
  maxLength: 10,
  boxMinWidth: Lino.chars2width(10),
  regex: /^[0123]?\d\.[01]?\d\.-?\d+$/,
  regexText: 'Enter a date in format YYYY-MM-DD (use zeroes for unknown parts).'
  });


//~ Lino.make_dropzone = function(cmp) {
    //~ cmp.on('render', function(ct, position){
      //~ ct.el.on({
        //~ dragenter:function(event){
          //~ event.browserEvent.dataTransfer.dropEffect = 'move';
          //~ return true;
        //~ }
        //~ ,dragover:function(event){
          //~ event.browserEvent.dataTransfer.dropEffect = 'move';
          //~ event.stopEvent();
          //~ return true;
        //~ }
        //~ ,drop:{
          //~ scope:this
          //~ ,fn:function(event){
            //~ event.stopEvent();
            //~ console.log(20110516);
            //~ var files = event.browserEvent.dataTransfer.files;
            //~ if(files === undefined){
              //~ return true;
            //~ }
            //~ var len = files.length;
            //~ while(--len >= 0){
              //~ console.log(files[len]);
              //~ // this.processDragAndDropFileUpload(files[len]);
            //~ }
          //~ }
        //~ }
      //~ });
    //~ });
//~ };

//~ Lino.FileUploadField = Ext.ux.form.FileUploadField;

Lino.FileUploadField = Ext.extend(Ext.ux.form.FileUploadField,{
    onRender : function(ct, position){
      Lino.FileUploadField.superclass.onRender.call(this, ct, position);
      this.el.on({
        dragenter:function(event){
          event.browserEvent.dataTransfer.dropEffect = 'move';
          return true;
        }
        ,dragover:function(event){
          event.browserEvent.dataTransfer.dropEffect = 'move';
          event.stopEvent();
          return true;
        }
        ,drop:{
          scope:this
          ,fn:function(event){
            event.stopEvent();
            //~ console.log(20110516);
            var files = event.browserEvent.dataTransfer.files;
            if(files === undefined){
              return true;
            }
            var len = files.length;
            while(--len >= 0){
              console.log(files[len]);
              //~ this.processDragAndDropFileUpload(files[len]);
            }
          }
        }
      });
    }
});

Lino.FileField = Ext.extend(Ext.form.TriggerField,{
  triggerClass : 'x-form-search-trigger',
  editable: false,
  onTriggerClick : function() {
    //~ console.log('Lino.URLField.onTriggerClick',this.value)
    //~ document.location = this.value;
    if (this.getValue()) window.open(MEDIA_URL + '/'+this.getValue(),'_blank');
  }
});

Lino.file_field_handler = function(panel,config) {
  //~ if (instanceof Lino.DetailWrapper) {
  if (panel.action_name == 'insert') {
  //~ if (panel.get_current_record().phantom) {
      panel.has_file_upload = true;

      var f = new Lino.FileUploadField(config);
      //~ Lino.make_dropzone(f);
      return f;
      //~ return new Ext.ux.form.FileUploadField(config);
      //~ return new Lino.FileField(config);
      
  } else {
      //~ return new Lino.URLField(config);
      return new Lino.FileField(config);
  }
}

Lino.VBorderPanel = Ext.extend(Ext.Panel,{
    constructor : function(config) {
      config.layout = 'border';
      delete config.layoutConfig;
      Lino.VBorderPanel.superclass.constructor.call(this,config);
      for(var i=0; i < this.items.length;i++) {
        var item = this.items.get(i);
        if (this.isVertical(item) && item.collapsible) {
          item.on('collapse',this.onBodyResize,this);
          item.on('expand',this.onBodyResize,this);
        }
      }
    },
    isVertical : function(item) {
       return (item.region == 'north' || item.region == 'south' || item.region == 'center');
    },
    onBodyResize: function(w, h){
        //~ console.log('VBorderPanel.onBodyResize',this.title)
      if (this.isVisible()) { // to avoid "Uncaught TypeError: Cannot call method 'getHeight' of undefined."
        var sumflex = 0;
        var availableHeight = this.getInnerHeight();
        var me = this;
        this.items.each(function(item){
          if (me.isVertical(item)) {
              if (item.collapsed || item.flex == 0 || item.flex === undefined) {
                  if (item.rendered) availableHeight -= item.getHeight();
              } else {
                  sumflex += item.flex;
              }
          } 
          
        });
        //~ for(var i=0; i < this.items.length;i++) {
          //~ var item = this.items.get(i);
          //~ // if (this.isVertical(item) && item.getResizeEl()) {
          //~ if (this.isVertical(item)) {
              //~ if (item.collapsed || item.flex == 0 || item.flex === undefined) {
                  //~ // item.syncSize()
                  //~ // item.doLayout()
                  //~ // if (item.region == "north") console.log('region north',item.getHeight(),item.id, item);
                  //~ // if (item.getHeight() == 0) console.log(20100921,'both flex and getHeight() are 0!');
                  //~ availableHeight -= item.getHeight();
              //~ } else {
                  //~ sumflex += item.flex;
                  //~ // console.log(item.flex);
              //~ }
          //~ } 
          //~ // else console.log('non-vertical item in VBoderPanel:',item)
        //~ }
        var hunit = availableHeight / sumflex;
        //~ console.log('sumflex=',sumflex,'hunit=',hunit, 'availableHeight=',availableHeight);
        for(var i=0; i < this.items.length;i++) {
          var item = this.items.get(i);
          if (this.isVertical(item)) {
              if (item.flex != 0 && ! item.collapsed) {
                  item.setHeight(hunit * item.flex);
                  //~ console.log(item.region,' : height set to',item.getHeight());
              }
          }
          //~ else console.log('non-vertical item in VBoderPanel:',item)
        }
      }
      Lino.VBorderPanel.superclass.onBodyResize.call(this, w, h);
    }
});


/*
  modifications to the standard behaviour of a CellSelectionModel:
  
*/
Ext.override(Ext.grid.CellSelectionModel, {
//~ var dummy = {

    handleKeyDown : function(e){
        /* removed because F2 wouldn't pass
        if(!e.isNavKeyPress()){
            return;
        }
        */
        //~ console.log('handleKeyDown',e)
        var k = e.getKey(),
            g = this.grid,
            s = this.selection,
            sm = this,
            walk = function(row, col, step){
                return g.walkCells(
                    row,
                    col,
                    step,
                    g.isEditor && g.editing ? sm.acceptsNav : sm.isSelectable, 
                    sm
                );
            },
            cell, newCell, r, c, ae;

        switch(k){
            case e.ESC:
            case e.PAGE_UP:
            case e.PAGE_DOWN:
                break;
            default:
                // e.stopEvent(); // removed because Browser keys like Alt-Home, Ctrl-R wouldn't work
                break;
        }

        if(!s){
            cell = walk(0, 0, 1); 
            if(cell){
                this.select(cell[0], cell[1]);
            }
            return;
        }

        cell = s.cell;  
        r = cell[0];    
        c = cell[1];    
        
        switch(k){
            case e.TAB:
                if(e.shiftKey){
                    newCell = walk(r, c - 1, -1);
                }else{
                    newCell = walk(r, c + 1, 1);
                }
                break;
            case e.HOME:
                if (! (g.isEditor && g.editing)) {
                  if (!e.hasModifier()){
                      newCell = [r, 0];
                      //~ console.log('home',newCell);
                      break;
                  }else if(e.ctrlKey){
                      var t = g.getTopToolbar();
                      var activePage = Math.ceil((t.cursor + t.pageSize) / t.pageSize);
                      if (activePage > 1) {
                          e.stopEvent();
                          t.moveFirst();
                          return;
                      }
                      newCell = [0, c];
                      break;
                  }
                }
            case e.END:
                if (! (g.isEditor && g.editing)) {
                  c = g.colModel.getColumnCount()-1;
                  if (!e.hasModifier()) {
                      newCell = [r, c];
                      //~ console.log('end',newCell);
                      break;
                  }else if(e.ctrlKey){
                      var t = g.getTopToolbar();
                      var d = t.getPageData();
                      if (d.activePage < d.pages) {
                          e.stopEvent();
                          var self = this;
                          t.on('change',function(tb,pageData) {
                              var r = g.store.getCount()-2;
                              self.select(r, c);
                              //~ console.log('change',r,c);
                          },this,{single:true});
                          t.moveLast();
                          return;
                      } else {
                          newCell = [g.store.getCount()-1, c];
                          //~ console.log('ctrl-end',newCell);
                          break;
                      }
                  }
                }
            case e.DOWN:
                newCell = walk(r + 1, c, 1);
                break;
            case e.UP:
                newCell = walk(r - 1, c, -1);
                break;
            case e.RIGHT:
                newCell = walk(r, c + 1, 1);
                break;
            case e.LEFT:
                newCell = walk(r, c - 1, -1);
                break;
            case e.F2:
                if (!e.hasModifier()) {
                    if (g.isEditor && !g.editing) {
                        g.startEditing(r, c);
                        e.stopEvent();
                        return;
                    }
                    break;
                }
            case e.INSERT:
                if (!e.hasModifier()) {
                    if (g.ls_insert_handler && !g.editing) {
                        e.stopEvent();
                        Lino.show_insert(g);
                        return;
                    }
                    break;
                }
            case e.DELETE:
                if (!e.hasModifier()) {
                    if (!g.editing) {
                        e.stopEvent();
                        Lino.delete_selected(g);
                        return;
                    }
                    break;
                }
            case e.ENTER:
                e.stopEvent();
                g.onCellDblClick(r,c);
                break;
                
        }
        

        if(newCell){
          e.stopEvent();
          r = newCell[0];
          c = newCell[1];
          this.select(r, c); 
          if(g.isEditor && g.editing){ 
            ae = g.activeEditor;
            if(ae && ae.field.triggerBlur){
                ae.field.triggerBlur();
            }
            g.startEditing(r, c);
          }
        //~ } else if (g.isEditor && !g.editing && e.charCode) {
        //~ // } else if (!e.isSpecialKey() && g.isEditor && !g.editing) {
            //~ g.set_start_value(String.fromCharCode(e.charCode));
            //~ // g.set_start_value(String.fromCharCode(k));
            //~ // g.set_start_value(e.charCode);
            //~ g.startEditing(r, c);
            //~ // e.stopEvent();
            //~ return;
        // } else {
          // console.log('20120513',e,g);
        }
        
    }


//~ };
});

 

function PseudoConsole() {
    this.log = function() {};
};
if (typeof(console) == 'undefined') console = new PseudoConsole();

Lino.notify = function(msg) {
  if (msg == undefined) msg = ''; else console.log(msg);
  //~ Ext.getCmp('konsole').update(msg);
  Lino.status_bar.setStatus({
    text: msg,
    iconCls: 'ok-icon',
    clear: true // auto-clear after a set interval
  });
  //~ Ext.getCmp('konsole').setTitle(msg.replace(/\n/g,'<br/>'));
  //~ Ext.getCmp('konsole').update(msg.replace(/\n/g,'<br/>'));
};
Lino.alert = function(msg) {
  //~ if (msg == undefined) msg = ''; else console.log(msg);
  Ext.MessageBox.alert('Notify',msg);
};


//~ Lino.show_about = function() {
  //~ new Ext.Window({
    //~ width: 400, height: 400,
    //~ title: "About",
    //~ html: '<a href="http://www.extjs.com" target="_blank">ExtJS</a> version ' + Ext.version
  //~ }).show();
//~ };

function obj2str(o) {
  if (typeof o != 'object') return String(o);
  var s = '';
  for (var p in o) {
    s += p + ': ' + obj2str(o[p]) + '\n';
  }
  return s;
}

Lino.on_store_exception = function (store,type,action,options,response,arg) {
  //~ throw response;
  console.log("on_store_exception: store=",store,
    "type=",type,
    "action=",action,
    "options=",options,
    "response=",response,
    "arg=",arg);
  if (arg) { console.log(arg.stack)};
};

//~ Lino.on_submit_success = function(form, action) {
   //~ Lino.notify(action.result.message);
   //~ this.close();
//~ };

Lino.on_submit_failure = function(form, action) {
    //~ Lino.notify();
  // action may be undefined
    switch (action.failureType) {
        case Ext.form.Action.CLIENT_INVALID:
            Ext.Msg.alert('Client-side failure', 'Form fields may not be submitted with invalid values');
            break;
        case Ext.form.Action.CONNECT_FAILURE:
            Ext.Msg.alert('Connection failure', 'Ajax communication failed');
            break;
        case Ext.form.Action.SERVER_INVALID:
            Ext.Msg.alert('Server-side failure', action.result.message);
   }
};



/*
Lino.save_wc_handler = function(ww) {
  return function(event,toolEl,panel,tc) {
    var pos = panel.getPosition();
    var size = panel.getSize();
    wc = ww.get_window_config();
    Ext.applyIf(wc,{ 
      x:pos[0],y:pos[1],height:size.height,width:size.width,
      maximized:panel.maximized});
    Lino.do_action(ww,{url:'/window_configs/'+ww.config.permalink_name,params:wc,method:'POST'});
  }
};

*/

Lino.show_in_own_window_button = function(handler) {
  return {
    qtip: "Show this panel in own window", 
    id: "up",
    handler: function(event,toolEl,panel, tc) {
      //~ console.log('20111206 report_window_button',panel,handler);
      handler.run(null,{base_params:panel.containing_panel.get_master_params()});
    }
  }
}




Lino.delete_selected = function(panel) {
  //~ console.log("Lino.delete_selected",panel);
  var recs1 = panel.get_selected();
  var recs = [];
  for ( var i=0; i < recs1.length; i++ ) { if (! recs1[i].phantom) recs.push(recs1[i]); }
  if (recs.length == 0) {
    Lino.notify("Please select at least one record.");
    return;
  };
  if (recs.length == 1) {
      if (recs[0].disable_delete) {
        Lino.alert(recs[0].disable_delete);
        return;
      }
  };
  //~ console.log(recs);
  Ext.MessageBox.show({
    title: "Confirmation",
    msg: String.format("Delete {0} rows. Are you sure?",String(recs.length)),
    //~ msg: "Delete " + String(recs.length) + " rows. Are you sure?",
    //~ buttons: Ext.MessageBox.YESNOCANCEL,
    buttons: Ext.MessageBox.YESNO,
    fn: function(btn) {
      if (btn == 'yes') {
        for ( var i=0; i < recs.length; i++ ) {
          Lino.do_action(panel,{
              method:'DELETE',
              url:  '/api' + panel.ls_url + '/' + recs[i].id,
              after_success: panel.after_delete.createDelegate(panel)
          })
        }
        //~ caller.after_delete();
      }
      else Lino.notify("Dann eben nicht.");
    }
  });
};

Lino.action_handler = function (panel,on_success,on_confirm) {
  return function (response) {
    //~ console.log(20120608,panel);
    if (panel instanceof Lino.GridPanel) {
        //~ gridmode = false;
        gridmode = true;
        //~ console.log('20120608 yes');
    } else {
        gridmode = false;
        //~ console.log('20120608 no');
    }
    if (panel.loadMask) panel.loadMask.hide(); // 20120211
    if (!response.responseText) return ;
    var result = Ext.decode(response.responseText);
    //~ console.log('Lino.action_handler()','result is',result,'on_confirm is',on_confirm);
    
    if (result.eval_js) {
        //~ console.log(20120618,result.eval_js);
        eval(result.eval_js);
    }
    
    //~ if (result.goto_record) {
        //~ var js = "Lino." + result.goto_record[0] + '.detail.run';
        //~ var h = eval(js);
        //~ h(panel,{record_id:result.goto_record[1]});
    //~ }
    
    if (result.xcallback) {
        //~ var config = {title:"Confirmation"};
        var config = {title:result.xcallback.title};
        //~ config.buttons = Ext.MessageBox.YESNOCANCEL;
        //~ config.buttons = Ext.MessageBox.YESNO;
        config.buttons = result.xcallback.buttons;
        config.msg = result.message;
        config.fn = function(buttonId,text,opt) {
          panel.loadMask.show(); 
          //~ Lino.insert_subst_user(p);
          Ext.Ajax.request({
            method: 'GET',
            url: '/callbacks/'+result.xcallback.id + '/' + buttonId,
            //~ params: {bi: buttonId},
            success: Lino.action_handler(panel,on_success,on_confirm)
          });
          //~ Lino.call_ajax_action(panel,'GET',)
        }
        Ext.MessageBox.show(config);
        return;
    }
    
    if (on_success && result.success) on_success(result);
    
    //~ if (on_confirm && result.confirm_message) {
        //~ var config = {title:"Confirmation"};
        //~ // config.buttons = Ext.MessageBox.YESNOCANCEL;
        //~ config.buttons = Ext.MessageBox.YESNO;
        //~ config.msg = result.confirm_message;
        //~ config.fn = function(buttonId,text,opt) {
          //~ if (buttonId == "yes") {
              //~ on_confirm(panel,undefined,result.step);
          //~ }
        //~ }
        //~ Ext.MessageBox.show(config);
        //~ return;
    //~ }
    //~ if (result.dialog_fn) {
        //~ console.log('20120928 TODO',result.dialog_fn);
    //~ }
    if (result.data_record && ! gridmode) {
        //~ not used
        panel.set_status({data_record:result.data_record});
    }  else if (result.new_status && ! gridmode) {
        //~ not used
        //~ console.log('20120607 new_status');
        panel.set_status(result.new_status);
    } else if (result.goto_record_id != undefined && ! gridmode) {
        //~ Uncaught TypeError: Cannot call method 'run' of undefined 
        panel.load_record_id(result.goto_record_id);
    } 
    
    if (result.message) {
        //~ if (result.alert && ! gridmode) {
        if (result.alert) { // 20120628b 
            //~ Ext.MessageBox.alert('Alert',result.alert_msg);
            if (result.alert === true) result.alert = "Alert";
            Ext.MessageBox.alert(result.alert,result.message);
        } else {
            Lino.notify(result.message);
        }
    }
     
    if (result.refresh_all) {
        var cw = panel.get_containing_window();
        //~ console.log("20120123 refresh_all");
        if (cw) {
          cw.main_item.refresh();
        }
        //~ else console.log("20120123 cannot refresh_all",panel);
    } else {
        //~ console.log("20121212 b gonna refresh",panel);
        if (result.refresh) panel.refresh();
    }
    
    if (result.open_url) {
        //~ console.log(20111126,result.open_url);
        //~ if (!result.message)
            //~ Lino.notify('Open new window <a href="'+result.open_url+'" target="_blank">'+result.open_url+'</a>');
        window.open(result.open_url,'foo',"");
        //~ document.location = result.open_url;
    }
  }
};

Lino.do_action = function(caller,action) {
  action.success = function(response) {
    if (caller.loadMask) caller.loadMask.hide();
    //~ console.log('Lino.do_action()',action,'action success',response);
    if (action.after_success) {
        //~ console.log('Lino.do_action() calling after_success');
        action.after_success();
    }
    if (response.responseText) {
      var result = Ext.decode(response.responseText);
      //~ console.log('Lino.do_action()',action.name,'result is',result);
      if (result.message) {
          if (result.alert) {
              //~ Ext.MessageBox.alert('Alert',result.alert_msg);
              Ext.MessageBox.alert('Alert',result.message);
          } else {
              Lino.notify(result.message);
          }
      }
      
      //~ if (result.alert_msg) Ext.MessageBox.alert('Alert',result.alert_msg);
      //~ if (result.message) Lino.notify(result.message);
      if (result.notify_msg) Lino.notify(result.notify_msg);
      if (result.js_code) { 
        //~ console.log('Lino.do_action()',action,'gonna call js_code in',result);
        var jsr = result.js_code(caller);
        //~ console.log('Lino.do_action()',action,'returned from js_code in',result);
        if (action.after_js_code) {
          //~ console.log('Lino.do_action()',action,'gonna call after_js_code');
          action.after_js_code(jsr);
          //~ console.log('Lino.do_action()',action,'returned from after_js_code');
        //~ } else {
          //~ console.log('Lino.do_action()',action,' : after_js_code is false');
        }
      };
    }
  };
  Ext.applyIf(action,{
    waitMsg: "Please wait...",
    failure: Lino.ajax_error_handler(caller),
    params: {}
  });
  //~ action.params.su = Lino.subst_user;
  Lino.insert_subst_user(action.params);
  
  Ext.Ajax.request(action);
};

//~ Lino.gup = function( name )
//~ {
  //~ // Thanks to http://www.netlobo.com/url_query_string_javascript.html
  //~ name = name.replace(/[\[]/,"\\\[").replace(/[\]]/,"\\\]");
  //~ var regexS = "[\\?&]"+name+"=([^&#]*)";
  //~ var regex = new RegExp( regexS );
  //~ var results = regex.exec( window.location.href );
  //~ if( results == null )
    //~ return "";
  //~ else
    //~ return results[1];
//~ };

//~ Lino.refresh_handler = function (ww) {
  //~ return function() { 
      //~ console.log('refresh',ww);
      //~ ww.main_item.doLayout(false,true);
      //~ ww.main_item.syncSize();
  //~ }
//~ };

//~ Lino.tools_close_handler = function (ww) {
  //~ return function() { 
      //~ ww.close();
  //~ }
//~ };
Lino.permalink_handler = function (ww) {
  return function() { 
    //~ document.location = ww.main_item.get_permalink();
    //~ console.log('20130723 Lino.permalink_handler',ww);
    
    /* Uncaught TypeError: Cannot read property 'main_item' of null  */
    if (ww) {
        var url = ww.main_item.get_permalink();
    } else {
        var url = Lino.viewport.get_permalink();
    }
    Lino.load_url(url);
  }
};
//~ Lino.run_permalink = function() {
  //~ var plink = Lino.gup('permalink');
  //~ if(plink) { eval('Lino.'+plink); }
//~ }

Lino.ajax_error_handler = function(panel) {
  return function(response,options) {
    console.log('Ajax failure:',response,options);
    if (panel.loadMask) panel.loadMask.hide();
    if (response.responseText) {
      var lines = response.responseText.split('\n');
      if (lines.length > 10) {
          line = lines.splice(5,lines.length-10,"(...)");
      }
      Ext.MessageBox.alert(
        response.statusText,
        lines.join('<br/>')
        //~ response.responseText.replace(/\n/g,'<br/>'))
      )
    } else {
      Ext.MessageBox.alert('Action failed',
        'Lino server did not respond to Ajax request');
    }
  }
}
// Ext.Ajax.on('requestexception',Lino.ajax_error_handler)
 


Ext.QuickTips.init();

/* setting QuickTips dismissDelay to 0 */
// Apply a set of config properties to the singleton
//~ Ext.apply(Ext.QuickTips.getQuickTip(), {
//~ Ext.apply(Ext.ToolTip, {
    //~ dismissDelay: 0
    //~ autoHide: false,
    //~ closable: true,
    //~ maxWidth: 200,
    //~ minWidth: 100,
    //~ showDelay: 50      // Show 50ms after entering target
    //~ ,trackMouse: true
//~ });


//~ Ext.apply(Ext.QuickTip, {
    //~ dismissDelay: 0,
//~ });
  
Lino.quicktip_renderer = function(title,body) {
  return function(c) {
    //~ if (c instanceof Ext.Panel) var t = c.bwrap; else // 20130129
    if (c instanceof Ext.Panel) var t = c.header; else // 20130129
    var t = c.getEl();
    //~ console.log(20130129,t,title,body);
    //~ t.dismissDelay = 0;
    Ext.QuickTips.register({
      target: t,
      //~ cls: 'lino-quicktip-classical',
      dismissDelay: 0,
      //~ autoHide: false,
      showDelay: 50,      // Show 50ms after entering target
      //~ title: title,
      text: body
    });
  }
};


  
Lino.help_text_editor = function() {
  //~ var bp = {
      //~ mk:this.content_type,
      //~ mt:1
    //~ };
    //~ console.log(20120202,bp);
  //~ Lino.lino.ContentTypes.detail({},{base_params:bp});
  //~ Lino.lino.ContentTypes.detail.run(null,{record_id:this.content_type});
  Lino.lino.ContentTypes.detail.run(null,{record_id:this.content_type});
}

// Path to the blank image should point to a valid location on your server
//~ Ext.BLANK_IMAGE_URL = MEDIA_URL + '/extjs/resources/images/default/s.gif'; 


// used as Ext.grid.Column.renderer for id columns in order to hide the special id value -99999
Lino.id_renderer = function(value, metaData, record, rowIndex, colIndex, store) {
  //~ if (record.phantom) return '';
  return value;
}

Lino.raw_renderer = function(value, metaData, record, rowIndex, colIndex, store) {
  return value;
}

Lino.text_renderer = function(value, metaData, record, rowIndex, colIndex, store) {
  //~ return "not implemented"; 
  return value;
}

Lino.NullNumberColumn = Ext.extend(Ext.grid.Column, {
    align : 'right', 
    format : '0,00/i', 
    renderer : function(value, metaData, record, rowIndex, colIndex, store) {
        //~ console.log(20130128,"NullNumberColumn.renderer",value);
        if (value === null) return '';
        return Ext.util.Format.number(value, this.format);
    }
});

//~ Lino.NullNumberColumn = Ext.extend(Ext.grid.NumberColumn, {
    //~ align : 'right', 
    //~ constructor: function(cfg){
        //~ Ext.grid.NumberColumn.superclass.constructor.call(this, cfg);
        //~ var t = this;
        //~ this.renderer = function(value, metaData, record, rowIndex, colIndex, store) {
          //~ console.log(20130128,"NullNumberColumn.renderer",value);
          //~ if (value === null) return '';
          //~ return Ext.util.Format.number(value, t.format);
      //~ };
    //~ }
//~ });




//~ Lino.cell_button_renderer = function(value, metaData, record, rowIndex, colIndex, store) {
  //~ return '<input type="button" onclick="alert(value)" value=" ? ">' ;
//~ }


//~ Lino.default_renderer = function(value, metaData, record, rowIndex, colIndex, store) {
  //~ if (record.phantom) return '';
  //~ return value;
//~ }

Lino.fk_renderer = function(fkname,handlername) {
  //~ console.log('Lino.fk_renderer handler=',handler);
  return function(value, metaData, record, rowIndex, colIndex, store) {
    //~ console.log('Lino.fk_renderer',fkname,rowIndex,colIndex,record,metaData,store);
    //~ if (record.phantom) return '';
    if (value) {
        var s = '<a href="javascript:' ;
        s += handlername + '.run(null,{record_id:\'' + String(record.data[fkname]) + '\'})">';
        s += value + '</a>';
        //~ console.log('Lino.fk_renderer',value,'-->',s);
        return s
    }
    return '';
  }
};

Lino.lfk_renderer = function(panel,fkname) {
  //~ console.log('Lino.fk_renderer handler=',handler);
  var handlername = 'console.log';
  return function(value, metaData, record, rowIndex, colIndex, store) {
    //~ console.log('Lino.fk_renderer',fkname,rowIndex,colIndex,record,metaData,store);
    if (record.phantom) return '';
    if (value) {
        var s = '<a href="javascript:' ;
        s += handlername + '({},{record_id:\'' + String(record.data[fkname]) + '\'})">';
        s += value + '</a>';
        //~ console.log('Lino.fk_renderer',value,'-->',s);
        return s
    }
    return '';
  }
};

//~ Lino.gfk_renderer = function() {
  //~ return function(value, metaData, record, rowIndex, colIndex, store) {
    //~ if (record.phantom) return '';
    //~ console.log('Lino.gfk_renderer',value,colIndex,record,metaData,store);
    //~ return value;
  //~ }
//~ };


Lino.build_buttons = function(panel,actions) {
  //~ console.log("20121006 Lino.build_buttons",actions);
  if (actions) {
    var buttons = Array(actions.length);
    var cmenu = Array(actions.length);
    for (var i=0; i < actions.length; i++) { 
      var a = actions[i];
      //~ buttons[i] = new Ext.Toolbar.Button(a);
      if (a.menu) a.menu = Lino.build_buttons(panel,a.menu).bbar;
      buttons[i] = a;
      cmenu[i] = {
            text : a.menu_item_text,
            iconCls : a.iconCls,
            menu : a.menu
          };
      if (a.panel_btn_handler) {
          var h = a.panel_btn_handler.createCallback(panel);
          if (a.auto_save == true) {
              h = panel.do_when_clean.createDelegate(panel,[true,h]);
          } else if (a.auto_save == null) {
              h = panel.do_when_clean.createDelegate(panel,[false,h]);
          } else if (a.auto_save == false) {
              // h = h;
          } else {
              console.log("20120703 unhandled auto_save value",a)
          }
          buttons[i].handler = h;
          cmenu[i].handler = h;
          //~ if (buttons[i].xtype == 'splitbutton') {
              //~ cmenu[i].menu = a.menu;
          //~ } else {
              //~ cmenu[i].handler = h;
          //~ }
      } else {
          cmenu[i].handler = a.handler;
      }
    }
    return {bbar:buttons, cmenu:new Ext.menu.Menu(cmenu)};
  }
}

Lino.do_when_visible = function(cmp,todo) {
  //~ if (cmp.el && cmp.el.dom) 
  if (cmp.isVisible()) { 
    // 'visible' means 'rendered and not hidden'
    //~ console.log(cmp.title,'-> cmp is visible now');
    todo(); 
  //~ } else {
      //~ cmp.on('resize',todo,cmp,{single:true});
  //~ }
  //~ if (false) { // 20120213
  } else { 
    //~ console.log('Lino.do_when_visible() must defer because not isVisible()',todo,cmp);
    if (cmp.rendered) {
      //~ console.log(cmp,'-> cmp is rendered but not visible: and now?');
      //~ console.log(cmp.title,'-> cmp is rendered but not visible: try again in a moment...');
      //~ var fn = function() {Lino.do_when_visible(cmp,todo)};
      //~ fn.defer(100);
      
      Lino.do_when_visible.defer(50,this,[cmp,todo]);
      //~ Lino.do_when_visible.defer(100,this,[cmp,todo]);
      
    } else {
      //~ console.log(cmp.title,'-> after render');
      cmp.on('afterrender',todo,cmp,{single:true});
    }
  }
  
};    

/*
*/
Lino.do_on_current_record = function(panel,fn,phantom_fn) {
  var rec = panel.get_current_record();
  if (rec == undefined) {
    Lino.notify("There's no selected record.");
    return;
  }
  // 20120307 A VirtualTable with a Detail (lino.Models) has only "phantom" records.
  if (rec.phantom) {
    //~ if (!panel.editable) { console.log("20120312 not editable:",panel)}
    if (phantom_fn) {
      phantom_fn(panel);
    } else {
      Lino.notify("Action not available on phantom record.");
    }
    return;
  }
  return fn(rec);
};






Lino.call_ajax_action = function(panel,method,url,p,actionName,step,on_confirm,on_success) {
  p.an = actionName;
  if (!panel) {
      if (Lino.current_window) 
          panel = Lino.current_window.main_item;
      else panel = Lino.viewport;
  }
  //~ console.log("20130809 Lino.call_ajax_action",panel);
  Ext.apply(p,panel.get_base_params());
  
  if (panel.get_selected) {
      var selected_recs = panel.get_selected();
      //~ console.log("20130831",selected_recs);
      var rs = Array(selected_recs.length);
      for(var i=0; i < selected_recs.length;i++) {
          rs[i] = selected_recs[i].data.id;
      };
      p.sr = rs;
  }
  
  if (panel.loadMask) panel.loadMask.show(); 
  //~ p.$ext_requests.URL_PARAM_SUBST_USER = Lino.subst_user;
  //~ Lino.insert_subst_user(p);
    
  //~ if (step) p['$ext_requests.URL_PARAM_ACTION_STEP'] = step;
  //~ if (pp) pp(p); // "parameter processor" : first used for read beid card
  Ext.Ajax.request({
    method: method
    ,url: url
    ,params: p
    ,success: Lino.action_handler(panel,on_success,on_confirm)
    ,failure: Lino.ajax_error_handler(panel)
  });
};

Lino.row_action_handler = function(actionName,hm,pp) {
  var p = {};
  var fn = function(panel,btn,step) {
      if (pp) { p = pp(panel); if (! p) return; }
      
      if (panel.get_current_record == undefined) { // AFTER_20130725
        panel = Ext.getCmp(panel);
        if (panel == undefined) {
          Lino.notify("Invalid panel spec.");
          return;
        }
      }
      
      Lino.do_on_current_record(panel,function(rec) {
          //~ console.log(panel);
          //~ 20120723 Lino.call_ajax_action(panel,rec.id,actionName,step,fn);
          panel.add_param_values(p,true); // 20130915
          Lino.call_ajax_action(panel,hm,panel.get_record_url(rec.id),p,actionName,step,fn);
      });
  };
  return fn;
};

Lino.list_action_handler = function(ls_url,actionName,hm,pp) {
  var p = {};
  var url = '/api' + ls_url
  var fn = function(panel,btn,step) {
      //~ console.log("20121210 Lino.list_action_handler",arguments);
      //~ var url = ADMIN_URL + '/api' + panel.ls_url
      if (pp) { p = pp(panel);  if (! p) return; }
      panel.add_param_values(p,true); // 20130915
      Lino.call_ajax_action(panel,hm,url,p,actionName,step,fn);
  };
  return fn;
};

Lino.param_action_handler = function(window_action) { // 20121012
  var fn = function(panel,btn,step) {
    Lino.do_on_current_record(panel,function(rec) {
      //~ console.log(panel);
      //~ 20120723 Lino.call_ajax_action(panel,rec.id,actionName,step,fn);
      window_action.run(panel.getId(),{}); 
    });
  };
  return fn;
};


//~ 20130726 Lino.run_row_action = function(requesting_panel,url,pk,actionName,pp) {
Lino.run_row_action = function(requesting_panel,url,meth,pk,actionName,preprocessor) {
  //~ var panel = action.get_window().main_item;
  url = '/api' + url  + '/' + pk;
  var panel = Ext.getCmp(requesting_panel);
  if (preprocessor) var p = preprocessor(); else var p = {};
  var fn = function(panel,btn,step) {
    //~ 20120723 Lino.call_ajax_action(panel,pk,actionName,step,fn);
    //~ 20130726 Lino.call_ajax_action(panel,'GET',url,p,actionName,step,fn);
    Lino.call_ajax_action(panel,meth,url,p,actionName,step,fn);
  }
  fn(panel,null,null);
}



Lino.show_detail = function(panel,btn) {
  Lino.do_on_current_record(panel, 
    function(rec) {
      //~ panel.loadMask.show();
      Lino.run_detail_handler(panel,rec.id);
    },
    Lino.show_insert
  );
};

Lino.run_detail_handler = function(panel,pk) {
  var bp = panel.get_base_params();
  //~ var bp = {};
  panel.add_param_values(bp); // 20120918
  var status = {
    record_id:pk,
    base_params:bp
    //~ param_values: pv.$ext_requests.URL_PARAM_PARAM_VALUES
  }
  //~ console.log("20120918 Lino.show_detail",status);
  panel.ls_detail_handler.run(null,status);
  //~ panel.loadMask.hide();
  //~ panel.containing_window.window.hideMask();
  //~ panel.el.unmask();
}

Lino.show_fk_detail = function(combo,detail_action) {
    //~ console.log("Lino.show_fk_detail",combo,handler);
    pk = combo.getValue();
    if (pk) {
        detail_action.run(null,{record_id: pk})
      } else {
        Lino.notify("Cannot show detail for empty foreign key.");
      }
};

Lino.show_insert = function(panel,btn) {
  var bp = panel.get_base_params();
  //~ console.log('20120125 Lino.show_insert',bp)
  //~ panel.ls_insert_handler.run(null,{record_id:-99999,base_params:bp});
  panel.ls_insert_handler.run(panel.getId(),{record_id:-99999,base_params:bp});
};

//~ Lino.show_insert_duplicate = function(panel,btn) {
  //~ Lino.do_on_current_record(panel,
    //~ function(rec) {
      //~ var newRec = {};
      //~ Ext.apply(newRec,rec);
      //~ newRec.id = -99999;
      //~ panel.ls_insert_handler.run(null,{data_record:rec});
    //~ });
//~ };

//~ Lino.update_row_handler = function(action_name) {
  //~ return function(panel,btn) {
    //~ Lino.notify("Sorry, " + action_name + " is not implemented.");
  //~ }
//~ };




if (Ext.ux.grid !== undefined) {
    Lino.GridFilters = Ext.extend(Ext.ux.grid.GridFilters,{
      encode:true,
      local:false
    });
} else {
    Lino.GridFilters = function() {}; // dummy
    Ext.override(Lino.GridFilters,{
      init : function() {}
    });
};



//~ Lino.ButtonField = Ext.extend(Ext.form.TextField,{
//~ Lino.ButtonField = Ext.extend(Ext.form.Field,{
    //~ editable : false,
    //~ constructor : function(ww,config,params){
      //~ this.containing_window = ww;
      //~ if (params) Ext.apply(config,params);
      //~ Lino.ButtonField.superclass.constructor.call(this, config);
    //~ },
    //~ setButtons : function(buttons){
      //~ console.log('setButtons',buttons);
    //~ },
    //~ onRender : function(ct, position){
        //~ if(!this.el){
            //~ this.panel = new Ext.Container({items:[
              //~ {xtype:'button',text:'upload'},
              //~ {xtype:'button',text:'show'},
              //~ {xtype:'button',text:'edit'}
            //~ ]});
            //~ this.panel.ownerCt = this;
            //~ this.el = this.panel.getEl();

        //~ }
        //~ Lino.ButtonField.superclass.onRender.call(this, ct, position);
    //~ },

  
//~ });

Lino.FieldBoxMixin = {
  before_init : function(config,params) {
    if (params) Ext.apply(config,params);
    var actions = Lino.build_buttons(this,config.ls_bbar_actions);
    if (actions) config.bbar = actions.bbar;
  },
  //~ constructor : function(ww,config,params){
    //~ this.containing_window = ww;
    //~ if (params) Ext.apply(config,params);
    //~ var actions = Lino.build_buttons(this,config.ls_bbar_actions);
    //~ if (actions) config.bbar = actions.bbar;
    //~ Lino.FieldBoxMixin.superclass.constructor.call(this, config);
  //~ },
  do_when_clean : function(auto_save,todo) { todo() },
  //~ format_data : function(html) { return '<div class="htmlText">' + html + '</div>' },
  format_data : function(html) { return html },
  get_base_params : function() {
    // needed for insert action
    var p = Ext.apply({},this.base_params);
    Lino.insert_subst_user(p);
    return p;
  },
  set_base_params : function(p) {
    this.base_params = Ext.apply({},p);
    //~ if (p.param_values) this.set_param_values(p.param_values);  
  },
  clear_base_params : function() {
      this.base_params = {};
      Lino.insert_subst_user(this.base_params);
  },
  set_base_param : function(k,v) {
    this.base_params[k] = v;
  }
};



Lino.HtmlBoxPanel = Ext.extend(Ext.Panel,Lino.PanelMixin);
Lino.HtmlBoxPanel = Ext.extend(Lino.HtmlBoxPanel,Lino.FieldBoxMixin);
Lino.HtmlBoxPanel = Ext.extend(Lino.HtmlBoxPanel,{
  disabled_in_insert_window : true,
  constructor : function(config,params) {
    this.before_init(config,params);
    Lino.HtmlBoxPanel.superclass.constructor.call(this, config);
  },
  //~ constructor : function(ww,config,params){
    //~ this.ww = ww;
    //~ if (params) Ext.apply(config,params);
    //~ var actions = Lino.build_buttons(this,config.ls_bbar_actions);
    //~ if (actions) config.bbar = actions.bbar;
    //~ Lino.FieldBoxMixin.constructor.call(this, ww,config,params);
  //~ },
  //~ constructor : function(ww,config,params){
    //~ this.ww = ww;
    //~ if (params) Ext.apply(config,params);
    //~ var actions = Lino.build_buttons(this,config.ls_bbar_actions);
    //~ if (actions) config.bbar = actions.bbar;
    //~ Lino.FieldBoxMixin.superclass.constructor.call(this, config);
  //~ },
  //~ disable : function() { var tb = this.getBottomToolbar(); if(tb) tb.disable()},
  //~ enable : function() { var tb = this.getBottomToolbar(); if(tb) tb.enable()},
  onRender : function(ct, position){
    Lino.HtmlBoxPanel.superclass.onRender.call(this, ct, position);
    //~ console.log(20111125,this.containing_window);
    if (this.containing_panel) {
      this.containing_panel.on('enable',this.enable,this);
      this.containing_panel.on('disable',this.disable,this);
    }
    this.el.on({
      dragenter:function(event){
        event.browserEvent.dataTransfer.dropEffect = 'move';
        return true;
      }
      ,dragover:function(event){
        event.browserEvent.dataTransfer.dropEffect = 'move';
        event.stopEvent();
        return true;
      }
      ,drop:{
        scope:this
        ,fn:function(event){
          event.stopEvent();
          //~ console.log(20110516);
          var files = event.browserEvent.dataTransfer.files;
          if(files === undefined){
            return true;
          }
          var len = files.length;
          while(--len >= 0){
            console.log(files[len]);
            //~ this.processDragAndDropFileUpload(files[len]);
          }
          Lino.show_insert(this);
        }
      }
    });
  },
  refresh : function(unused) { 
      this.refresh_with_after();
  },
  refresh_with_after : function(after) {
    //~ if (this.master_panel) {
      var record = this.containing_panel.get_current_record();
      //~ console.log('HtmlBox.refresh()',this.title,record,record.title);
      var box = this.items.get(0);
      var todo = function() {
        if (this.disabled) return;
        //~ this.set_base_params(this.containing_window.get_base_params());
        this.set_base_params(this.containing_panel.get_master_params());
        var el = box.getEl();
        if (el) {
          el.update(record ? this.format_data(record.data[this.name]) : '');
          //~ console.log('20130723 HtmlBox.refresh()',this.name);
        //~ } else {
          //~ console.log('HtmlBox.refresh() failed for',this.name);
        }
      };
      Lino.do_when_visible(box,todo.createDelegate(this));
    //~ }
  }
});
//~ Ext.override(Lino.HtmlBoxPanel,Lino.FieldBoxMixin);



Lino.RichTextPanel = Ext.extend(Ext.Panel,Lino.PanelMixin);
Lino.RichTextPanel = Ext.extend(Lino.RichTextPanel,Lino.FieldBoxMixin);
Lino.RichTextPanel = Ext.extend(Lino.RichTextPanel,{
    
  //~ initComponent : function(){
    //~ Lino.RichTextPanel.superclass.initComponent.call(this);
  //~ },
  constructor : function(config,params) {
    //~ console.log('Lino.RichTextPanel.initComponent',this);
    //~ var url = TEMPLATES_URL + config.ls_url + "/" + String(rec.id) + "/" + config.name;
    //~ var url = TEMPLATES_URL + config.ls_url + "/" + config.name;
    var t = this;
    var tinymce_options = {
        theme : "advanced",
        content_css: '/media/lino/extjs/lino.css',
        language: 'en',
        //~ template_external_list_url : url,
        theme_advanced_toolbar_location : "top",
        theme_advanced_toolbar_align : "left",
        theme_advanced_statusbar_location : "bottom",
        template_popup_width : 700,
        template_popup_height : 500,
        template_replace_values : { 
            data_field : function(element){ 
                //~ console.log(20110722,fieldName,t.containing_window.get_current_record()); 
                var fieldName = element.innerHTML;
                element.innerHTML = t.containing_panel.get_current_record().data[fieldName];
            } 
        }
      };
      
    var editorConfig = {
      tinymceSettings: {
        plugins : "noneditable,template", 
        // Theme options - button# indicated the row# only
        theme_advanced_buttons1 : "bold,italic,underline,|,justifyleft,justifycenter,justifyright,|,bullist,numlist,|,outdent,indent,|,undo,redo,|,removeformat,template",
        theme_advanced_buttons2 : "",
        theme_advanced_buttons3 : "", // ,|,sub,sup,|,charmap",      
        theme_advanced_resizing : false
        //~ save_onsavecallback : save_callback,
        //~ save_enablewhendirty : true
        //~ save_oncancelcallback: on_cancel
        
    }};
    Ext.apply(editorConfig.tinymceSettings,tinymce_options);
    //~ editorConfig.name = config.action_name;
    editorConfig.name = config.name;
    delete config.name;
    //~ config.title = config.label;
    //~ delete config.label;
    this.before_init(config,params);
    
    this.editor = new Ext.ux.TinyMCE(editorConfig);
    var t = this;
    config.tools = [{
                      qtip: "Edit text in own window", 
                      id: "up",
                      handler: function(){
                        if(t.editor.isDirty()) {
                            var record = t.containing_panel.get_current_record();
                            record.data[t.editor.name] = t.editor.getValue();
                        }
                        Lino.edit_tinymce_text(t,tinymce_options)
                      }
                    }];
    
    config.items = this.editor;
    config.layout = "fit";
    Lino.RichTextPanel.superclass.constructor.call(this, config);
  },
  refresh : function(unused) { 
      this.refresh_with_after();
  },
  refresh_with_after : function(after) {
    var record = this.containing_panel.get_current_record();
    //~ console.log('RichTextPanel.refresh()',this.title,record.title,record);
    var todo = function() {
      //~ this.set_base_params(this.containing_window.get_base_params());
      if (record) {
        var url = '/templates' + this.containing_panel.ls_url + "/" 
            + String(record.id) + "/" + this.editor.name;
        //~ console.log('RichTextPanel.refresh()',url);
        if (this.editor.ed) this.editor.ed.settings.template_external_list_url = url;
        this.set_base_params(this.containing_panel.get_master_params());
        //~ var v = record ? this.format_data(record.data[this.editor.name]) : ''
        var v = this.format_data(record.data[this.editor.name])
        this.editor.setValue(v);
      } else {
        this.editor.setValue('(no data)');
      }
    };
    Lino.do_when_visible(this,todo.createDelegate(this));
  }
});
//~ Ext.override(Lino.RichTextPanel,Lino.FieldBoxMixin);



Lino.ActionFormPanel = Ext.extend(Ext.form.FormPanel,Lino.MainPanel);
Lino.ActionFormPanel = Ext.extend(Lino.ActionFormPanel,Lino.PanelMixin);
Lino.ActionFormPanel = Ext.extend(Lino.ActionFormPanel,Lino.FieldBoxMixin);
Lino.ActionFormPanel = Ext.extend(Lino.ActionFormPanel,{
  //~ layout:'fit'
  //~ ,autoHeight: true
  //~ ,frame: true
  window_title: "Action Parameters",
  constructor : function(config){
    config.bbar = [
        {text:'OK',handler:this.on_ok,scope:this},
        {text:'Cancel',handler:this.on_cancel,scope:this}
    ];
    //~ config.items = config.params_panel;
    Lino.ActionFormPanel.superclass.constructor.call(this, config);
  }
  //~ ,initComponent : function(){
    //~ Lino.ActionFormPanel.superclass.initComponent.call(this);
  //~ }
  ,on_cancel : function() { 
    this.get_containing_window().close();
  }
  ,on_ok : function() { 
    //~ var rp = this.requesting_panel;
    //~ console.log("on_ok",this.requesting_panel,arguments);
    var panel = this.requesting_panel;
    //~ if (panel == undefined) {
        //~ Lino.alert("Sorry, dialog actions don't work without a requesting_panel");
        //~ return;
    //~ }
    //~ var rec = panel.get_current_record();
    var actionName = this.action_name;
    var pk = this.base_params.mk;
    if (pk == undefined && panel) {
        pk = panel.get_current_record().id;
    }
    if (pk == undefined) {
        Lino.alert("Sorry, dialog action without base_params.mk");
        return;
    }
    var self = this;
    function on_success() { self.get_containing_window().close(); };
    var url = '/api' + this.ls_url + '/' + pk;
    var fn = function(panel,btn,step) {
      var p = {};
      self.add_field_values(p)
      //~ Lino.call_ajax_action(panel,'GET',panel.get_record_url(rec.id),p,actionName,step,fn,on_success);
      Lino.call_ajax_action(panel,'GET',url,p,actionName,step,fn,on_success);
    }
    fn(panel,null,null);
    
    
  }
  ,set_status : function(status,rp){
    this.requesting_panel = Ext.getCmp(rp);
    //~ console.log('20120918 ActionFormPanel.set_status()',status,rp,this.requesting_panel);
    this.clear_base_params();
    if (status == undefined) status = {};
    //~ if (status.param_values) 
    this.set_field_values(status.field_values);
    if (status.base_params) this.set_base_params(status.base_params);
  }
  
  ,add_field_values : function (p) { // similar to add_param_values()
      //~ 20121023 
      if (this.form.isDirty()) {
        p.fv = this.get_field_values();
      }else{
        if (this.status_field_values) 
          p.fv = Lino.fields2array(this.fields,this.status_field_values);
      }
      //~ if (!this.form.isDirty()) return;
      //~ p.$ext_requests.URL_PARAM_FIELD_VALUES = this.get_field_values();
      //~ console.log("20120203 add_param_values added pv",pv,"to",p);
  }
  ,get_field_values : function() {
      return Lino.fields2array(this.fields);
  }
  ,set_field_values : function(pv) {
      //~ console.log('20120203 MainPanel.set_param_values', pv);
      this.status_field_values = pv;
      if (pv) this.form.my_loadRecord(pv);
      else this.form.reset(); 
  }
  ,config_containing_window : function(wincfg) { 
      wincfg.title = this.window_title;
      wincfg.keys = [
        { key: Ext.EventObject.ENTER, fn: this.on_ok }
      ]
  }
});

//~ Lino.add_blank = function(oa) {
    //~ return [].concat(oa)
    //~ return 
    //~ }
    
Lino.fields2array = function(fields,values) {
    //~ console.log('20130605 fields2array gonna loop on', fields,values);
    var pv = Array(fields.length);
    for(var i=0; i < fields.length;i++) {
        var f = fields[i]
        if (values) 
          var v = values[f.name];
        else 
          var v = f.getValue();
        if (f.formatDate) {
            pv[i] = f.formatDate(v); 
        } else {
            pv[i] = v; // f.getValue(); 
        }
    }
    return pv;
}


Lino.FormPanel = Ext.extend(Ext.form.FormPanel,Lino.MainPanel);
Lino.FormPanel = Ext.extend(Lino.FormPanel,Lino.PanelMixin);
Lino.FormPanel = Ext.extend(Lino.FormPanel,{
  params_panel_hidden : false,
  //~ base_params : {},
  //~ trackResetOnLoad : true,
  //~ query_params : {},
  //~ 20110119b quick_search_text : '',
  constructor : function(config,params){
    if (params) Ext.apply(config,params);
    this.base_params = {};
    //~ ww.config.base_params.query = ''; // 20111018
    //~ console.log(config);
    //~ console.log('FormPanel.constructor() 1',config)
    //~ Ext.applyIf(config,{base_params:{}});
    //~ console.log('FormPanel.constructor() 2',config)
      
    config.trackResetOnLoad = true;
    
    Lino.FormPanel.superclass.constructor.call(this, config);
      
    //~ this.set_base_param('$URL_PARAM_FILTER',null); // 20111018
    //~ this.set_base_param('$URL_PARAM_FILTER',''); // 20111018
      
  },
  initComponent : function(){
    
    //~ console.log("20111201 containing_window",this.containing_window,this);
    
    var actions = Lino.build_buttons(this,this.ls_bbar_actions);
    if (actions) {
        this.bbar = actions.bbar;
    //~ } else {
        //~ this.bbar = [];
    }
    //~ Ext.apply(config,Lino.build_buttons(this,config.ls_bbar_actions));
    //~ config.bbar = Lino.build_buttons(this,config.ls_bbar_actions);
    //~ var config = this;
    
    //~ if (this.containing_window instanceof Lino.DetailWrapper) {
    
    //~ console.log('20120121 initComponent', this.action_name);
    //~ if (this.action_name == 'detail' | this.action_name == 'show') {
    //~ if (this.action_name != 'insert') {
    if (! this.hide_top_toolbar) {
      this.tbar = [];
      // 20111015    
      if (! this.hide_navigator) {
        this.record_selector = new Lino.RemoteComboFieldElement({
          store: new Lino.ComplexRemoteComboStore({
            //~ baseParams: this.containing_window.config.base_params,
            baseParams: this.get_base_params(),
            //~ value: this.containing_window.config.base_params.query,
            proxy: new Ext.data.HttpProxy({
              url: '/choices' + this.ls_url,
              method:'GET'
            })
          }),
          pageSize:25,
          listeners: { 
            scope:this, 
            select:function(combo,record,index) {
              //~ console.log('jumpto_select',arguments);
              this.goto_record_id(record.id);
            }
          },
          emptyText: "Go to record"
        })
        this.tbar = this.tbar.concat([this.record_selector]);
        
        this.tbar = this.tbar.concat([
          this.first = new Ext.Toolbar.Button({
            tooltip:"First",disabled:true,handler:this.moveFirst,scope:this,iconCls:'x-tbar-page-first'}),
          this.prev = new Ext.Toolbar.Button({
            tooltip:"Previous",disabled:true,handler:this.movePrev,scope:this,iconCls:'x-tbar-page-prev'}),
          this.next = new Ext.Toolbar.Button({
            tooltip:"Next",disabled:true,handler:this.moveNext,scope:this,iconCls:'x-tbar-page-next'}),
          this.last = new Ext.Toolbar.Button({
            tooltip:"Last",disabled:true,handler:this.moveLast,scope:this,iconCls:'x-tbar-page-last'})
        ]);
      }
      this.tbar = this.add_params_panel(this.tbar);
      
      //~ console.log(20101117,this.containing_window.refresh);
      this.tbar = this.tbar.concat([
        {
          //~ text:'Refresh',
          handler:function(){ this.do_when_clean(true,this.refresh.createDelegate(this)) },
          iconCls: 'x-tbar-loading',
          tooltip:"Reload current record",
          scope:this}
      ]);
          
      if (this.bbar) { // since 20121016
        if (this.tbar) {
            this.tbar = this.tbar.concat(['-']) ;
        } else {
          this.tbar = [];
        }
        this.tbar = this.tbar.concat(this.bbar) ;
        this.bbar = undefined;
      }
    
      this.tbar = this.tbar.concat([
          '->',
          this.displayItem = new Ext.Toolbar.TextItem({})
      ]);
          
    }
    //~ if (this.content_type && this.action_name != 'insert') {
      //~ this.bbar = this.bbar.concat([
        //~ '->',
        //~ { text: "[$_('Help Text Editor')]",
          //~ handler: Lino.help_text_editor,
          //~ qtip: "$_('Edit help texts for fields on this model.')",
          //~ scope: this}
      //~ ])
    //~ }
    //~ this.before_row_edit = config.before_row_edit.createDelegate(this);
      
    //~ if (this.master_panel) {
        //~ this.set_base_params(this.master_panel.get_master_params());
    //~ }
      
    Lino.FormPanel.superclass.initComponent.call(this);
    
    this.on('render',function(){
      this.loadMask = new Ext.LoadMask(this.bwrap,{msg:"Please wait..."});
    },this);
    
    
    //~ var this_ = this;
    //~ this.cascade(function(cmp){
      //~ // var active_field = false;
      //~ for (i = 0; i < this_.active_fields.length; i++) {
        //~ if (cmp.name == this_.active_fields[i]) {
            //~ // active_field = true; break;
            //~ cmp.on("change",function() {this_.save()});
        //~ }
      //~ };
      //~ if (active_field) {
      // if (cmp instanceof Lino.GridPanel) {
          //~ cmp.on("change",function() {this_.save()});
      //~ }
    //~ });
    
    if (this.action_name == 'insert') {
      this.cascade(function(cmp){
        // console.log('20110613 cascade',cmp);
        if (cmp.disabled_in_insert_window) {
            //~ cmp.disable();
            cmp.hide();
        }
      });
      
    }
    
  },
  
  unused_is_loading : function() { 
    if (this.current_record == null) {
        //~ console.log("20130515 current_record is null");
        return true; 
    }
    
    if (! this.loadMask) return true; // not even rendered: 
    if (! this.loadMask.el) return true; // not even rendered: 
    // thanks to Marco Pegoraro http://movableapp.com/2011/09/sencha-touch-loadmask-isvisible/
    var loading = (this.loadMask.el.select('.x-loading-msg').elements.length > 0);
    //~ console.log('20130515 GridPanel.is_loading() returns',loading);
    return loading;

    
    var loading = false;
    this.cascade(function(cmp){
        if (cmp instanceof Lino.GridPanel && cmp.is_loading()) {
            //~ console.log(20130515, cmp.title,'is loading');
            loading = true;
            return false;
        }
      });
    return loading;
    //~ var a = this.findByType(Lino.GridPanel);
    //~ for (i=0;i<a.length;i++) {
        //~ if (a[i].is_loading()) return true;
    //~ }
    //~ return false;
  },
  
  get_status : function(){
      var st = {
        base_params: this.get_base_params(),
        data_record : this.get_current_record()
        }
      var tp = this.items.get(0);
      if (tp instanceof Ext.TabPanel) {
        st.active_tab = tp.getActiveTab();
      }
      st.param_values = this.status_param_values;
      return st;
  },
  /* FormPanel */
  set_status : function(status,rp){
    this.requesting_panel = Ext.getCmp(rp);
    //~ console.log('20120918 FormPanel.set_status()',status);
    this.clear_base_params();
    if (status == undefined) status = {};
    //~ if (status.param_values) 
    this.set_param_values(status.param_values);
    if (status.base_params) this.set_base_params(status.base_params);
    var tp = this.items.get(0);
    if (tp instanceof Ext.TabPanel) {
      if (status.active_tab) {
        //~ console.log('20111201 active_tab',this.active_tab,this.items.get(0));
        //~ tp.activeTab = status.active_tab;
        tp.setActiveTab(status.active_tab);
        //~ this.main_item.items.get(0).activate(status.active_tab);
      } else {
        tp.setActiveTab(0);
      }
      }
    
    if (status.data_record) {
      //~ console.log('20111201 Lino.FormPanel with data_record',this.data_record.title,this.containing_window);
      //~ this.main_item.on_master_changed.defer(2000,this.main_item,[status.data_record]);
      //~ Lino.do_when_visible(this.main_item,function(){this.on_master_changed(status.data_record)});
      //~ this.main_item.on('afterrender',function(){
      //~   this.main_item.on_master_changed(status.data_record)},this,{single:true});
      /* must defer because because set_window_title() didn't work otherwise */
      this.set_current_record.createDelegate(this,[status.data_record]).defer(100);
      //~ this.set_current_record(this.data_record);
      //~ return;
    } else if (status.record_id != undefined) { 
      /* possible values include 0 and null, 0 being a valid record id, 
      null the equivalent of undefined
      */
      //~ this.main_item.goto_record_id(this.status.record_id);
      this.load_record_id(status.record_id);
    } else {
      this.set_current_record(undefined);
    }
  },
    
  get_base_params : function() {
    // needed for insert_action
    var p = Ext.apply({},this.base_params);
    Lino.insert_subst_user(p);
    return p;
    //~ return this.base_params;
  },
  set_base_params : function(p) {
    //~ this.base_params = Ext.apply({},this.base_params); // make sure it is an instance variable
    delete p['query'] // 20120725
    Ext.apply(this.base_params,p);
    if (this.record_selector) {
        var store = this.record_selector.getStore();
        for (k in p) store.setBaseParam(k,p[k]);
        delete this.record_selector.lastQuery;
        //~ console.log("20120725 record_selector.setBaseParam",p)
    }
  },
  clear_base_params : function() {
      this.base_params = {};
      Lino.insert_subst_user(this.base_params);
        
      //~ if (this.record_selector) {
          //~ var store = this.record_selector.getStore();
          //~ for (k in store.baseParams) store.setBaseParam(k,undefined);
          //~ delete this.record_selector.lastQuery;
          //~ console.log("20120725 record_selector.getBaseParams() -->",store.baseParams)
      //~ }
  },
  set_base_param : function(k,v) {
    //~ this.base_params = Ext.apply({},this.base_params); // make sure it is an instance variable
    this.base_params[k] = v;
    //~ if (this.record_selector) {
        //~ this.record_selector.getStore().setBaseParam(k,v);
        //~ delete this.record_selector.lastQuery;
    //~ }
  },
  
  after_delete : function() {
    if (this.current_record.navinfo.next)
      this.moveNext();
    else if (this.current_record.navinfo.prev)
      this.movePrev();
    else 
      this.abandon();
  },
  moveFirst : function() {this.goto_record_id(this.current_record.navinfo.first)},
  movePrev : function() {this.goto_record_id(this.current_record.navinfo.prev)},
  moveNext : function() {this.goto_record_id(this.current_record.navinfo.next)},
  moveLast : function() {this.goto_record_id(this.current_record.navinfo.last)},
  
  
  refresh : function(unused) { 
      this.refresh_with_after();
  },
  refresh_with_after : function(after) { 
    //~ console.log('20120121 Lino.FormPanel.refresh()',this);
    if (this.current_record) {
        this.load_record_id(this.current_record.id,after);
    } else {
        this.set_current_record(undefined,after);
    }
  },
  
  do_when_clean : function(auto_save,todo) {
    var this_ = this;
    if (this.form.isDirty()) {
        if (auto_save) {
            this_.save(todo);
        } else {
          //~ console.log('20111217 do_when_clean() form is dirty',this.form);
          var config = {title:"Confirmation"};
          config.buttons = Ext.MessageBox.YESNOCANCEL;
          config.msg = "Save changes to current record ?";
          config.fn = function(buttonId,text,opt) {
            //~ console.log('do_when_clean',buttonId)
            if (buttonId == "yes") {
                //~ Lino.submit_detail(this_,undefined,todo);
                //~ this_.containing_window.save(todo);
                this_.save(todo);
            } else if (buttonId == "no") { 
              todo();
            }
          }
        }
        Ext.MessageBox.show(config);
    }else{
      //~ console.log('do_when_clean : now!')
      todo();
    }
  },
  
  goto_record_id : function(record_id) {
    //~ console.log('20110701 Lino.FormPanel.goto_record_id()',record_id);
    //~ var this_ = this;
    //~ this.do_when_clean(function() { this_.load_record_id(record_id) }
    this.do_when_clean(true,this.load_record_id.createDelegate(this,[record_id]));
  },
  
  load_record_id : function(record_id,after) {
    var this_ = this;
    //~ var p = { fmt: this.containing_window.config.action_name};
    //~ var p = Ext.apply({},this.containing_window.config.base_params);
    var p = Ext.apply({},this.get_base_params());
    //~ Lino.insert_subst_user(p);
    //~ console.log('20110713 action_name=',this.containing_window.config.action_name,
      //~ 'base_params=',this.containing_window.config.base_params);
    if (this.action_name)
        p.an = this.action_name;
    //~ p.an = this.action_name;
    //~ p.an = this.containing_window.config.action_name;
    //~ p.fmt = 'json';
    //~ p.fmt = '$ext_requests.URL_FORMAT_JSON';
    p.rp = this.getId();
    //~ p.$ext_requests.URL_PARAM_SUBST_USER = Lino.subst_user;
    p.fmt = 'json';
    //~ 20110119b p['$URL_PARAM_FILTER'] = this.quick_search_text;
    //~ Ext.apply(p,this.query_params);
    this.add_param_values(p);
    //~ console.log('20121120 FormPanel.load_record_id',record_id,p);
    if (this.loadMask) this.loadMask.show();
    Ext.Ajax.request({ 
      waitMsg: 'Loading record...',
      method: 'GET',
      params: p,
      scope: this,
      url: this.get_record_url(record_id),
      success: function(response) {   
        // todo: convert to Lino.action_handler.... but result 
        if (this.loadMask) this.loadMask.hide();
        if (response.responseText) {
          var rec = Ext.decode(response.responseText);
          //~ console.log('20120918 goto_record_id success',rec);
          this.set_param_values(rec.param_values);
          this.set_current_record(rec,after);
        }
      },
      failure: Lino.ajax_error_handler(this)
    });
  },

  abandon : function () {
    Ext.MessageBox.alert('Note',
      "No more records to display. Detail window has been closed.");
    Lino.close_window();
    //~ if (this.containing_window) {
        //~ this.containing_window.hide();
    //~ }
  },
  
  set_current_record : function(record,after) {
    //~ console.log('20120722 Lino.FormPanel.set_current_record',record.title,record);
    if (this.record_selector) {
        this.record_selector.clearValue();
        // e.g. InsertWrapper FormPanel doesn't have a record_selector
    }
    this.current_record = record;
    //~ if (record) 
        //~ console.log('Lino.FormPanel.set_current_record',record.title,record);
    //~ else
        //~ console.log('Lino.FormPanel.set_current_record',record);
    //~ this.config.main_panel.form.load(record);    
    if (record) {
      this.enable();
      this.form.my_loadRecord(record.data);
      this.set_window_title(record.title);
      //~ this.getBottomToolbar().enable();
      var da = record.data.disabled_actions;
      if (da) {
          //~ console.log('20120528 disabled_actions =',da,this.getBottomToolbar());
          //~ 20121016 this.getBottomToolbar().items.each(function(item,index,length){
          var tb = this.getTopToolbar();
          if (tb) tb.items.each(function(item,index,length){
              //~ console.log('20120528 ',item.itemId,'-->',da[item.itemId]);
              if (da[item.itemId]) item.disable(); else item.enable();
          });
      };
      if (this.disable_editing | record.data.disable_editing) {
          //~ console.log("20120202 disable_editing",record.title);
          this.form.items.each(function(cmp){
            if (!cmp.always_enabled) cmp.disable();
          },this);
      } else {
          this.form.items.each(function(cmp){
            //~ console.log("20120202",cmp);
            if (record.data.disabled_fields[cmp.name]) cmp.disable();
            else cmp.enable();
          },this);
        
          //~ if (record.data.disabled_fields) {
              //~ for (i = 0; i < record.data.disabled_fields.length; i++) {
                  //~ var flds = this.find('name',record.data.disabled_fields[i]);
                  //~ if (flds.length == 1) { 
                    //~ flds[0].disable(); 
                  //~ }
              //~ }
          //~ }
      };
      if (this.first) {
        if (record.navinfo  && ! this.hide_navigator) {
          this.first.setDisabled(!record.navinfo.first);
          this.prev.setDisabled(!record.navinfo.prev);
          this.next.setDisabled(!record.navinfo.next);
          this.last.setDisabled(!record.navinfo.last);
          this.displayItem.setText(record.navinfo.message);
        } else {
          this.first.setDisabled(true);
          this.prev.setDisabled(true);
          this.next.setDisabled(true);
          this.last.setDisabled(true);
        }
      }
    } else {
      if (this.form.rendered) 
        this.form.reset(); /* FileUploadField would fail when resetting a non-rendered form */
      //~ this.disable();
      //~ this.getBottomToolbar().disable();
      this.form.items.each(function(cmp){
        cmp.disable();
      },this);
      this.set_window_title(this.empty_title);
      //~ this.containing_window.window.setTitle(this.empty_title);
      if (!this.hide_navigator) {
        this.first.disable();
        this.prev.disable();
        this.next.disable();
        this.last.disable();
      }
    }
    //~ console.log('20100531 Lino.DetailMixin.on_load_master_record',this.main_form);
    this.before_row_edit(record);
    if (after) after();
  },
  
  before_row_edit : function(record) {},
  search_change : function(field,oldValue,newValue) {
    //~ console.log('search_change',field.getValue(),oldValue,newValue)
    this.set_base_param('query',field.getValue()); 
    this.refresh();
  },
  
  get_selected : function() { return [ this.current_record ] },
  get_current_record : function() {  
    //~ console.log(20100714,this.current_record);
    return this.current_record 
  },
  
  get_permalink_url : function() {
      var rec = this.get_current_record();
      if (rec && ! rec.phantom && rec.id != -99998)
          return '/api' + this.ls_url + '/' + rec.id;
      return '/api' + this.ls_url;
    
  },
  get_permalink_params : function() {
    var p = {};
    //~ var p = {an:'detail'};
    if (this.action_name)
        p.an = this.action_name;
    //~ var p = {an:this.action_name};
    var main = this.items.get(0);
    if (main.activeTab) {
      var tab = main.items.indexOf(main.activeTab);
      //~ console.log('main.activeTab',tab,main.activeTab);
      if (tab) p.tab = tab;
    }
    this.add_param_values(p)
    return p;
  },
  
  /* 
  Lino.FormPanel.save() 
  */
  save : function(after,switch_to_detail,action_name) {
    //~ var panel = this;
    //~ console.log('20121120 FormPanel.save');
    this.loadMask.show();
    var rec = this.get_current_record();
    if (this.has_file_upload) this.form.fileUpload = true;
    //~ console.log('FormPanel.save()',rec);
    if (!action_name) action_name = this.action_name;
    if (rec) {
      var p = {};
      Ext.apply(p,this.get_base_params());
      p.rp = this.getId();
      //~ if (this.action_name) 
          //~ p.$ext_requests.URL_PARAM_ACTION_NAME = this.action_name;
      p.an = action_name;
      if (rec.phantom) {
        //~ if (this.action_name != 'insert') 
            //~ console.log("Warning: phantom record, but action_name is",this.action_name)
        this.form.submit({
          url: '/api' + this.ls_url,
          method: 'POST',
          params: p, 
          scope: this,
          success: function(form, action) {
            this.loadMask.hide();
            Lino.notify(action.result.message);
            /***
            Close this window, but update the status of the 
            calling window.
            If the calling window is a detail on the same table,
            then it should skip to the new record. But only then.
            A successful response usually has a data_record,
            except if it is a fileupload form where some mysterious 
            decoding problems (20120209) force us to return a record_id 
            which will lead to an additional GET.
            ***/
            var url = this.ls_url;
            var ww = Lino.calling_window();
            if (ww && ww.window.main_item instanceof Lino.FormPanel 
                   && ww.window.main_item.ls_url == this.ls_url) {
                //~ console.log("20120217 case 1");
                ww.status.record_id = action.result.record_id;
                ww.status.data_record = action.result.data_record;
                Lino.close_window();
            } else if (this.ls_detail_handler && switch_to_detail) {
                //~ console.log("20120217 case 2");
                Lino.kill_current_window();
                this.ls_detail_handler.run(null,{
                    record_id:action.result.record_id,
                    data_record: action.result.data_record,
                    base_params:this.get_base_params()
                });
            } else {
                //~ console.log("20120217 case 3");
                Lino.close_window();
            }
            //~ Lino.close_window(function(ww){
                //~ if (ww.window.main_item instanceof Lino.FormPanel 
                    //~ && ww.window.main_item.ls_url == url) {
                  //~ ww.status.record_id = action.result.record_id,
                  //~ ww.status.data_record = action.result.data_record
                //~ }
            //~ });
          },
          failure: function(form,action) { 
            this.loadMask.hide();
            Lino.on_submit_failure(form,action);
          },
          clientValidation: true
        })
      } else {
        //~ if (this.action_name != 'detail') 
            //~ console.log("Warning: non-phantom record, but action_name is",this.action_name)
        this.form.submit({
          url: '/api' + this.ls_url + '/' + rec.id,
          method: 'PUT',
          //~ headers: { 'HTTP_X_REQUESTED_WITH' : 'XMLHttpRequest'},
          scope: this,
          params: p, 
          success: function(form, action) {
            //~ panel.form.setValues(rec.data);
            //~ 20110701 panel.form.my_loadRecord(rec);
            this.loadMask.hide();
            Lino.notify(action.result.message);
            if (action.result.data_record)
                this.set_current_record(action.result.data_record,after);
            else
                console.log("Warning: no data_record in response to FormPanel.PUT")
            //~ this.refresh_with_after(after);
            //~ if (after) after(); else panel.refresh();
          },
          failure: function(form,action) { 
            this.loadMask.hide();
            Lino.on_submit_failure(form,action)},
          clientValidation: true
        })
      }
    } else Lino.notify("Sorry, no current record.");
  }
  
  ,on_cancel : function() { 
    this.get_containing_window().close();
  }
  ,on_ok : function() { 
      this.save(null,true);
      //~ var rec = this.get_current_record();
      //~ if (rec && rec.phantom)
          //~ this.do_when_clean(true,function() { Lino.close_window(); });
  }
  ,config_containing_window : function(wincfg) { 
      wincfg.keys = [
        { key: Ext.EventObject.ENTER, fn: this.on_ok, scope:this }
        ,{ key: Ext.EventObject.ESCAPE, fn: this.on_cancel, scope:this }
      ]
  }
  
  
  /* not used (no longer possible without .dtl files)
  , edit_detail_config : function () {
    var active_tab = {};
    var main = this.items.get(0);
    if (main.getActiveTab !== undefined) {
      var tabitem = main.getActiveTab();
      Ext.apply(active_tab,{$ext_requests.URL_PARAM_TAB : main.items.indexOf(tabitem)});
    }
    var editor = new Ext.form.TextArea();
    var close = function() { win.close(); }
    var _this = this;
    var save = function() { 
      //~ console.log(20110609,arguments); 
      var params = {desc: editor.getValue()};
      Ext.apply(params,active_tab);
      var a = { 
        params: params, 
        method: 'PUT',
        url: ADMIN_URL + '/detail_config' + _this.ls_url,
        failure : Lino.ajax_error_handler(this),
        success: Lino.action_handler( _this, function(result) {
          //~ console.log('detail_config/save success',result);
          win.close();
          document.location = _this.get_permalink();
        })
      };
      //~ console.log('detail_config/save sent',a);
      _this.loadMask.show(); // 20120211
      Ext.Ajax.request(a);
    }
    var save_btn = new Ext.Button({text:'Save',handler:save,disabled:true});
    var win = new Ext.Window({title:'Detail Layout',
      items:editor, layout:'fit',
      width:500,height:500,
      bbar:[{text:'Cancel',handler:close},save_btn]});
    var a = { 
      params:active_tab, 
      method:'GET',
      url:ADMIN_URL+'/detail_config'+_this.ls_url,
      success : function(response) {
        if (response.responseText) {
          var result = Ext.decode(response.responseText);
          if (result.success) {
            editor.setValue(result.desc);
            save_btn.enable();
          }
        }
      }
    };
    Ext.Ajax.request(a);
    win.show();
  }
  */
});



Lino.getRowClass = function(record, rowIndex, rowParams, store) {
    //~ console.log(20130816,record);
    //~ return 'x-grid3-row-green';
    return record.data.row_class;
  //~ if (true) {
      //~ return 'x-grid3-row-red';
  //~ }
  //~ if (record.phantom) {
    //~ console.log(20101009,record);
    //~ rowParams.bodyStyle = "color:red;background-color:blue";
    //~ return 'lino-phantom-row';
    //~ }
  //~ console.log('20101009 not a phantom:',record);
  //~ return '';
}

//~ FOO = 0;



Lino.GridStore = Ext.extend(Ext.data.ArrayStore,{ 
  autoLoad: false
  ,load: function(options) {
    //~ foo.bar = baz; // 20120213
    if (!options) options = {};
    if (!options.params) options.params = {};
    options.params.fmt = 'json';
    options.params.rp = this.grid_panel.getId();
    Lino.insert_subst_user(options.params); // since 20121016
      
    if (this.grid_panel.hide_top_toolbar) {
        //~ console.log("20120206 GridStore.load() toolbar is hidden");
        options.params.start = 0;
        if (this.grid_panel.preview_limit) {
          options.params.limit = this.grid_panel.preview_limit;
        }
    } else {
        var ps = this.grid_panel.calculatePageSize();
        if (!ps) {
            //~ this.gridpanel.on('render',this.load())
          //~ console.log("20120814 GridStore.load() failed to calculate pagesize");
          return false;
            //~ params.$URL_PARAM_LIMIT = 1;
            //~ this.grid_panel.on('render',this.load.createDelegate(this,options))
            //~ return;
        } 
        options.params.limit = ps;
      
        //~ options.params.start = this.grid_panel.getTopToolbar().cursor;
        //~ if (this.grid_panel.getTopToolbar().pageSize !=  ps) {
          //~ console.log("20120206 abort load because toolbar says pagesize",
            //~ this.grid_panel.getTopToolbar().pageSize,
            //~ "while actual pagesize is",ps);
            //~ return;
        //~ }
        
        this.grid_panel.getTopToolbar().pageSize =  ps;
        if (options.params.start == undefined)
            options.params.start = this.grid_panel.getTopToolbar().cursor;
      
    }
      
    this.grid_panel.add_param_values(options.params);
    //~ Lino.insert_subst_user(options.params);
    //~ console.log("20120814 GridStore.load()",options.params,this.baseParams);
    //~ if (FOO > 0) {
        //~ foo.bar = baz;
    //~ } else FOO += 1;
    return Lino.GridStore.superclass.load.call(this,options);
  }
});

Lino.get_current_grid_config = function(panel) {
    return panel.get_current_grid_config();
}

Lino.GridPanel = Ext.extend(Ext.grid.EditorGridPanel,Lino.MainPanel);
Lino.GridPanel = Ext.extend(Lino.GridPanel,Lino.PanelMixin);
Lino.GridPanel = Ext.extend(Lino.GridPanel,{
  quick_search_text : '',
  is_searching : false,
  disabled_in_insert_window : true,
  clicksToEdit:2,
  enableColLock: false,
  autoHeight: false,
  params_panel_hidden : false,
  preview_limit : undefined, 
  //~ loadMask: true,
  //~ viewConfig: {
          //~ getRowClass: Lino.getRowClass,
          //~ emptyText:"$_('No data to display.')"
        //~ },
  loadMask: {msg:"Please wait..."},
  
  constructor : function(config){

    config.plugins = [new Lino.GridFilters()];
    
    
    Lino.GridPanel.superclass.constructor.call(this,config);
    
    //~ if (this.containing_window) {
        //~ console.log("20111206 install refresh");
        //~ this.containing_window.on('show',this.refresh,this);
    //~ }
    
  },
  
  unused_is_loading : function() { 
    if (! this.loadMask.el) return true; // not even rendered: 
    // thanks to Marco Pegoraro http://movableapp.com/2011/09/sencha-touch-loadmask-isvisible/
    var loading = (this.loadMask.el.select('.x-loading-msg').elements.length > 0);
    //~ console.log('20130515 GridPanel.is_loading() returns',loading);
    return loading;
    //~ return this.store.getCount() > 0; 
    //~ return (this.loadMask.el.select('.x-loading-msg').elements.length)
    //~ return !this.viewReady; 
    //~ return this.loadMask.isVisible(); 
    //~ return !this.loadMask.disabled; 
  },
  
  unused_config_containing_window : function(wincfg) { 
      //~ temporarily remove save_grid_config button (see /blog(2012/1107)
      if (wincfg.tools != undefined) 
        wincfg.tools = [
          //~ {handler:this.save_grid_data,
            //~ qtip:"$_("Save Grid Data")",
            //~ scope:this, id:"save_data"}, // 20120814
          {handler:this.save_grid_config,
            qtip:"Save Grid Configuration",
            scope:this, id:"save"}
        ].concat(wincfg.tools);
      //~ wincfg.listeners = { show: ... };
  },
  init_containing_window : function(win) { 
    //~ console.log("20111206 install refresh");
    //~ win.on('show',this.refresh,this);
  },
  
  initComponent : function(){
    
    /* 
    Problem 20111206:
    When a GridPanel is the main item of the window, then it doesn't 
    have it's own header but uses the window's header bar.
    We must do this in initComponent because e.g. in beforerender 
    it's already to late: a header element has been created because 
    there was a title.
    But Lino.Window adds itself as `this.containing_window` 
    only after the GridPanel has been initialized.
    Workaround is to generate a line "params.containing_window = true;" 
    in the handler function.
    */ 
    //~ if (this.containing_window) {
    if (this.is_main_window) {
        //~ console.log(20111206, 'delete title',this.title,'from',this);
        //~ delete this.title;
        this.tools = undefined;  
        this.title = undefined;  /* simply deleting it 
          isn't enough because that would only 
          unhide the title defined in some base class. */
    } 
    //~ else console.log(20111206, 'dont delete title',this.title,'from',this);
    
    /* e.g. when slave gridwindow called from a permalink */
    //~ if (this.base_params) Ext.apply(bp,this.base_params);  
    //~ bp['fmt'] = 'json';
    
    //~ function on_proxy_write( proxy, action,data, response,rs,options) {
      //~ console.log('20120814 on_proxy_write',action,data,response)
      //~ this.getStore().doUpdate();
      //~ this.getStore().loadData(data);
    //~ }
    //~ function on_proxy_load( proxy, transactionObject, callbackOptions ) {
      //~ console.log('on_proxy_load',transactionObject)
    //~ }
    var proxy = new Ext.data.HttpProxy({ 
      // 20120814 
      url: '/api' + this.ls_url
      ,method: "GET"
      //~ ,url: ADMIN_URL + '/restful' + this.ls_url
      //~ ,restful: true 
      //~ ,listeners: {load:on_proxy_load} 
      //~ ,listeners: {write:on_proxy_write} 
    });
    //~ config.store = new Ext.data.JsonStore({ 
    //~ this.store = new Ext.data.ArrayStore({ 
    this.store = new Lino.GridStore({ 
      grid_panel: this
      ,listeners: { exception: Lino.on_store_exception }
      ,remoteSort: true
      ,totalProperty: "count"
      ,root: "rows"
      //~ ,id: "id" 
      ,proxy: proxy
      //~ autoLoad: this.containing_window ? true : false
      ,idIndex: this.pk_index
      //~ ,baseParams: bp
      ,fields: this.ls_store_fields
      ,idProperty: this.ls_id_property 
      // 20120814
      //~ ,writer : new Ext.data.JsonWriter({
        //~ writeAllFields: false
        //~ ,listful: true
      //~ })
      //~ ,restful : true
    });
      
    //~ console.log('config.pk_index',config.pk_index,config.store),
    delete this.ls_store_fields;
      
    var this_ = this;
    //~ var grid = this;
    this.store.on('load', function() {
        //~ console.log('20120814 GridStore.on(load)',this_.store);
        //~ var da = this_.store.reader.arrayData.disabled_actions;
        //~ if (da) {
            //~ this.cmenu.cascade(function(item){ 
              //~ console.log(20120531, item.itemId, da[item.itemId]);
              //~ if (da[item.itemId]) item.disable(); else item.enable();
            //~ });
        //~ };
        this_.set_param_values(this_.store.reader.arrayData.param_values);
        //~ this_.set_status(this_.store.reader.arrayData.status);
        //~ 20120918
        this.getView().getRowClass = Lino.getRowClass;
        if (this_.store.reader.arrayData.no_data_text) {
            //~ this.viewConfig.emptyText = this_.store.reader.arrayData.no_data_text;
            this.getView().emptyText = this_.store.reader.arrayData.no_data_text;
            this.getView().refresh();
        }
        if (this_.containing_window)
            this_.set_window_title(this_.store.reader.arrayData.title);
            //~ this_.containing_window.setTitle(this_.store.reader.arrayData.title);
        if (!this.is_searching) { // disabled 20121025: quick_search_field may not lose focus
          this.is_searching = false;
          if (this_.selModel.getSelectedCell){
              if (this_.getStore().getCount()) // there may be no data
                  this_.selModel.select(0,0); 
          } else {
              this_.selModel.selectFirstRow();
              this_.getView().focusEl.focus();
          }
        } 
        //~ else console.log("is_searching -> no focussing");
        //~ var t = this.getTopToolbar();
        //~ var activePage = Math.ceil((t.cursor + t.pageSize) / t.pageSize);
        //~ this.quick_search_field.focus(); // 20121024
      }, this
    );
    var actions = Lino.build_buttons(this,this.ls_bbar_actions);
    //~ Ext.apply(config,Lino.build_buttons(this,config.ls_bbar_actions));
    //~ config.bbar, this.cmenu = Lino.build_buttons(this,config.ls_bbar_actions);
    //~ this.cmenu = new Ext.menu.Menu({items: config.bbar});
    delete this.ls_bbar_actions
    if (actions) {
        this.cmenu = actions.cmenu;
    }
    
    if (!this.hide_top_toolbar) {  
      var tbar = [ 
        this.quick_search_field = new Ext.form.TextField({ 
          //~ fieldLabel: "Search"
          listeners: { 
            scope:this_
            //~ ,change:this_.search_change
            
            ,render: Lino.quicktip_renderer("Quick Search","Enter a text to use as quick search filter")
            
            //~ ,keypress: this.search_keypress 
            ,blur: function() { this.is_searching = false}
          }
          ,validator:function(value) { return this_.search_validate(value) }
          //~ ,tooltip: "Enter a quick search text, then press TAB"
          //~ value: text
          //~ scope:this, 
          //~ ,enableKeyEvents: true
          //~ listeners: { keypress: this.search_keypress }, 
          //~ id: "seachString" 
      })];
      tbar = this.add_params_panel(tbar);
      tbar = tbar.concat([
        { scope:this, 
          //~ text: "[csv]", 
          tooltip: "Export this table to a .csv file", 
          iconCls: 'x-tbar-csv',
          handler: function() { 
            //~ 20130116 var p = Ext.apply({},this.get_base_params());
            //~ 20130116 p.fmt = 'csv';
            //~ url += "?" + Ext.urlEncode(p);
            var p = this.get_current_grid_config();
            Ext.apply(p,this.get_base_params());
            p.fmt = "csv";
            this.add_param_values(p,true);
            
            window.open('/api'+this.ls_url + "?" + Ext.urlEncode(p)) 
          } },
        //~ { scope:this, 
          //~ text: "[html]", 
          //~ handler: function() { 
            //~ var p = this.get_current_grid_config();
            //~ Ext.apply(p,this.get_base_params());
            //~ p.$ext_requests.URL_PARAM_FORMAT = "$ext_requests.URL_FORMAT_PRINTER";
            //~ this.add_param_values(p);
            //~ window.open(ADMIN_URL+'/api'+this.ls_url + "?" + Ext.urlEncode(p)) 
          //~ } },
        { scope:this, 
          //~ text: "[html]", 
          tooltip: "Show this table in plain html", 
          iconCls: 'x-tbar-html',
          handler: function() { 
            var p = this.get_current_grid_config();
            Ext.apply(p,this.get_base_params());
            //~ since 20121226 p.$ext_requests.URL_PARAM_FORMAT = "$ext_requests.URL_FORMAT_PLAIN";
            this.add_param_values(p,true);
            //~ since 20121226 window.open(ADMIN_URL+'/api'+this.ls_url + "?" + Ext.urlEncode(p)) 
            window.open('plain'+this.ls_url + "?" + Ext.urlEncode(p)) 
          } }
        
      ]);
    
    
      var menu = [];
      var set_gc = function(index) {
        return function() {
          //~ console.log('set_gc() 20100812');
          this.getColumnModel().setConfig(
              this.apply_grid_config(index,this.ls_grid_configs,this.ls_columns));
        }
      }
      for (var i = 0; i < this.ls_grid_configs.length;i++) {
        var gc = this.ls_grid_configs[i];
        menu.push({text:gc.label,handler:set_gc(i),scope:this})
      }
      if(menu.length > 1) {
        tbar = tbar.concat([
          { text:"View",
            menu: menu,
            tooltip:"Select another view of this report"
          }
        ]);
      }
      
      if (actions) {
        tbar = tbar.concat(actions.bbar);
          //~ this.bbar = actions.bbar;
      }
      
      this.tbar = new Ext.PagingToolbar({ 
        store: this.store, 
        prependButtons: true, 
        //~ pageSize: this.page_length, 
        pageSize: 1, 
        displayInfo: true, 
        beforePageText: "Page",
        afterPageText: "of {0}",
        displayMsg: "Displaying {0} - {1} of {2}",
        firstText: "First page",
        lastText: "Last page",
        prevText: "Previous page",
        nextText: "Next page",
        items: tbar
      });
      //~ this.on('resize', function(cmp,aw,ah,rw,rh) {
          //~ var ps = this.calculatePageSize();
          //~ if (ps && ps != this.getTopToolbar().pageSize) {
              //~ // console.log('20120203 resize : pageSize',this.getTopToolbar().pageSize,'->',ps);
              //~ // this.getTopToolbar().pageSize =  ps;
              //~ cmp.refresh();
              //~ // this.getTopToolbar().doRefresh();
          //~ }
        //~ }, this);
      //~ this.on('resize', function(cmp,aw,ah,rw,rh) {
          //~ cmp.getTopToolbar().pageSize = this.calculatePageSize(aw,ah,rw,rh) || 10;
          //~ cmp.refresh();
        //~ }, this, {delay:500});
    }
    
    //~ delete this.page_length
    
    
      
    if (this.cell_edit) {
      this.selModel = new Ext.grid.CellSelectionModel()
      this.get_selected = function() {
        //~ console.log(this.getSelectionModel().selection);
        if (this.selModel.selection)
            return [ this.selModel.selection.record ];
        return [this.store.getAt(0)];
      };
      this.get_current_record = function() { 
        if (this.getSelectionModel().selection) 
          return this.selModel.selection.record;
        return this.store.getAt(0);
      };
    } else { 
      this.selModel = new Ext.grid.RowSelectionModel() 
      this.get_selected = function() {
        var sels = this.selModel.getSelections();
        if (sels.length == 0) sels = [this.store.getAt(0)];
        return sels
        //~ var sels = this.getSelectionModel().getSelections();
        //~ return Ext.pluck(sels,'id');
      };
      this.get_current_record = function() { 
        var rec = this.selModel.getSelected();
        if (rec == undefined) rec = this.store.getAt(0);
        return rec
      };
    };
    delete this.cell_edit;
    
    this.columns  = this.apply_grid_config(this.gc_name,this.ls_grid_configs,this.ls_columns);
    
    //~ var grid = this;
    //~ this.colModel = new Ext.grid.ColumnModel({
      //~ columns: this.apply_grid_config(this.gc_name,this.ls_grid_configs,this.ls_columns),
      //~ isCellEditable: function(col, row) {
        //~ var record = grid.store.getAt(row);
        //~ console.log('20120514',col,record); // dataIndex
        //~ var dataIndex = grid.colModel.getDataIndex(col);
        //~ if (dataIndex in record.data['disabled_fields']) {
            //~ Lino.notify("$_("This field is disabled")");
            //~ return false;
        //~ }
        //~ return Ext.grid.ColumnModel.prototype.isCellEditable.call(this, col, row);
      //~ }
    //~ });    
    
    
    Lino.GridPanel.superclass.initComponent.call(this);
    
    //~ if (this.containing_window) 
        //~ this.on('afterlayout', this.refresh, this);
        //~ this.on('afterrender', this.refresh,this);
    //~ else
        //~ this.on('show', this.refresh,this);
    //~ this.on('afterlayout', function() {
      //~ if (this.id == "ext-comp-1157") 
        //~ console.log("20120213 afterlayout",this); 
      //~ // this.refresh();
      //~ },this);
    //~ this.on('afterrender', this.refresh);
    //~ this.on('resize', this.refresh,this,{delay:500});
    //~ this.on('resize', function(){console.log("20120213 resize",arguments)},this);
    this.on('resize', function(){
      //~ console.log("20120213 resize",arguments)
      this.refresh();
      },this);
    this.on('viewready', function(){
      //~ console.log("20120213 resize",arguments);
      this.view_is_ready = true;
      this.refresh(); // removed 20130911
      },this);
    this.on('afteredit', this.on_afteredit); // 20120814
    //~ this.on('afteredit', this.new_on_afteredit);
    this.on('beforeedit', this.on_beforeedit);
    this.on('beforeedit',function(e) { this.before_row_edit(e.record)},this);
    this.on('cellcontextmenu', Lino.cell_context_menu, this);
    //~ this.on('contextmenu', Lino.grid_context_menu, this);
    
    
    //~ if (this.id == "ext-comp-1157") captureEvents(this);    
    
  },
  
  //~ onResize : function(){
      //~ console.log("20120206 GridPanel.onResize",arguments);
      //~ Lino.GridPanel.superclass.onResize.apply(this, arguments);
      //~ this.refresh();
  //~ },
  
  
  get_status : function(){
    var st = { base_params : this.get_base_params()};
    if (!this.hide_top_toolbar) {
        st.current_page = this.getTopToolbar().current;
    }
    st.param_values = this.status_param_values;
    //~ console.log("20120213 GridPanel.get_status",st);
    return st;
  },
  
  /* 
  Lino.GridPanel.set_status() 
  */
  set_status : function(status){
    //~ console.log("20130605 GridPanel.set_status",status);
    this.clear_base_params();
    if (status == undefined) status = {};
    this.set_param_values(status.param_values);
    if (status.base_params) { 
      this.set_base_params(status.base_params);
    }
    if (status.show_params_panel != undefined) {
        if (this.toggle_params_panel_btn) {
            //~ this.toggle_params_panel_btn.toggle(status.show_params_panel=='true');
            this.toggle_params_panel_btn.toggle(status.show_params_panel);
        }
    }
    if (!this.hide_top_toolbar) {
      //~ console.log("20120213 GridPanel.getTopToolbar().changePage",
          //~ status.current_page || 1);
      this.getTopToolbar().changePage(status.current_page || 1);
    }
    //~ this.fireEvent('resize');
    //~ this.refresh.defer(100,this); 
    //~ this.onResize.defer(100,this); 
    //~ this.refresh(); 
    //~ this.doLayout(); 
    //~ this.onResize(); 
    //~ this.store.load();
  },
  
  refresh : function(unused) { 
    this.refresh_with_after();
  },
  refresh_with_after : function(after) { 
    //~ Lino.notify('Lino.GridPanel.refresh '+this.store.proxy.url);
    //~ var bp = { fmt:'json' }
    if (! this.view_is_ready) return;
    
    if (this.containing_panel) {
        //~ Ext.apply(p,this.master_panel.get_master_params());
        //~ Ext.apply(options.params,this.containing_panel.get_master_params());
        this.set_base_params(this.containing_panel.get_master_params());
        // 20130911
        if (!this.store.baseParams.mk) {  
            return;
        }
    }
    
    
    //~ console.log('20130911 Lino.GridPanel.refresh_with_after',this.containing_panel.get_master_params());
    
    var options = {};
    if (after) {
        options.callback = function(r,options,success) {if(success) after()}
    }
      
    //~ if (!this.rendered) {
        //~ console.log("20120206 GridPanel.refresh() must wait until rendered",options);
        //~ this.grid_panel.on('render',this.load.createDelegate(this,options))
        //~ return;
    //~ }
    
    this.store.load(options);
  },
  
  /* pageSize depends on grid height (Trying to remove scrollbar)
  Thanks to 
  - Christophe Badoit on http://www.sencha.com/forum/showthread.php?82647
  - http://www.sencha.com/forum/archive/index.php/t-37231.html
  */
  calculatePageSize : function(second_attempt) {
    //~ if (!this.rendered) { 
    if (!this.view_is_ready) { 
      //~ console.log('Cannot calculatePageSize() : not rendered');
      return false; }
    //~ if (!this.isVisible()) { 
      //~ console.log('calculatePageSize : not visible');
      //~ return false; }
      
    //~ console.log('getFrameHeight() is',this.getFrameHeight());
    //~ console.log('getView().scroller.getHeight() is',this.getView().scroller.getHeight());
    //~ console.log('mainBody.getHeight() is',this.getView().mainBody.getHeight());
    //~ console.log('getInnerHeight() is',this.getInnerHeight());
    //~ console.log('getHeight() is',this.getHeight());
    //~ console.log('el.getHeight() is',this.getEl().getHeight());
    //~ console.log('getGridEl().getHeight() is',this.getGridEl().getHeight());
    //~ console.log('getOuterSize().height is',this.getOuterSize().height);
    //~ console.log('getBox().height is',this.getBox().height);
    //~ console.log('getResizeEl.getHeight() is',this.getResizeEl().getHeight());
    //~ console.log('getLayoutTarget().getHeight() is',this.getLayoutTarget().getHeight());
      
    //~ var rowHeight = 52; // experimental value
    var row = this.view.getRow(0);
    if (row) {
      //~ console.log('20120213 yes');
      var rowHeight = Ext.get(row).getHeight();
    } else {
        //~ var rowHeight = this.getFrameHeight();
        //~ var rowHeight = 10; // reasonably smallest approximative value
        //~ There is no data yet. Construct a fake row and get its height
        var Element = Ext.Element;
        var gv = this.view;
        var fakeBody = new Element(Element.fly(gv.scroller).child('div.x-grid3-body'));
        var rowTemplate = gv.templates.row;
        var cellTemplate = gv.templates.cell;
        var tstyle  = 'width:' + gv.getGridInnerWidth() + 'px;';
        var cells = cellTemplate.apply({value:'&#160;'});
        var markup = rowTemplate.apply({
                tstyle: tstyle,
                cols  : 1,
                cells : cells,
                alt   : ''
            });        
        fakeBody.dom.innerHTML = gv.templates.body.apply({rows: markup});
        var row = fakeBody.dom.childNodes[0];
        var rowHeight = Ext.get(row).getHeight();
    }
    //~ console.log('rowHeight is ',rowHeight,this,caller);
    //~ this.getView().syncScroll();
    //~ this.getView().initTemplates();
    var height = this.getView().scroller.getHeight();
    //~ console.log('getView().scroller.getHeight() is',this.getView().scroller.getHeight());
    //~ console.log('getInnerHeight() - getFrameHeight() is',
      //~ this.getInnerHeight(), '-',
      //~ this.getFrameHeight(), '=',
      //~ this.getInnerHeight() - this.getFrameHeight());
    //~ var height = this.getView().mainBody.getHeight();
    //~ var height = this.getView().mainWrap.getHeight();
    //~ var height = this.getView().resizeMarker.getHeight();
    //~ this.syncSize();
    //~ var height = this.getInnerHeight() - this.getFrameHeight();
    //~ var height = this.getHeight() - this.getFrameHeight();
    height -= Ext.getScrollBarWidth(); // leave room for a possible horizontal scrollbar... 
    //~ height -= this.getView().scrollOffset;
    var ps = Math.floor(height / rowHeight);
    //~ console.log('20130816 calculatePageSize():',height,'/',rowHeight,'->',ps);
    ps -= 1; // leave room for a possible phantom row
    //~ return (ps > 1 ? ps : false);
    if (ps > 1) return ps;
    //~ console.log('calculatePageSize() found less than 1 row:',height,'/',rowHeight,'->',ps);
    //~ foo.bar = baz; // 20120213
    return 5; // preview_limit
    //~ if (second_attempt) {
        //~ console.log('calculatePageSize() abandons after second attempt:',
          //~ height,'/',rowHeight,'->',ps);
      //~ return 5;
    //~ }
    //~ return this.calculatePageSize.defer(500,this,[true]);
  },
  
  onCellDblClick : function(grid, row, col){
      //~ console.log("20120307 onCellDblClick",this,grid, row, col);
      if (this.ls_detail_handler) {
          //~ Lino.notify('show detail');
          Lino.show_detail(this);
          return false;
      }else{
        //~ console.log('startEditing');
        this.startEditing(row,col);
      }
  },
  
  get_base_params : function() {
    //~ return this.containing_window.config.base_params;
    //~ console.log(20120717,this.store.baseParams);
    var p = Ext.apply({},this.store.baseParams);
    Lino.insert_subst_user(p);
    //~ console.log("20120717 GRidPanel.get_base_params() returns",p);
    return p;
    //~ return this.store.baseParams;
  },
  set_base_params : function(p) {
    //~ console.log('20130911 GridPanel.set_base_params',p)
    for (k in p) this.store.setBaseParam(k,p[k]);
    //~ this.store.baseParams = p;
    if (p.query) 
        this.quick_search_field.setValue(p.query);
    //~ if (p.param_values) 
        //~ this.set_param_values(p.param_values);  
  },
  clear_base_params : function() {
      this.store.baseParams = {};
      Lino.insert_subst_user(this.store.baseParams);
  },
  set_base_param : function(k,v) {
    this.store.setBaseParam(k,v);
  },
  
  //~ get_permalink_params : function() {
    //~ var p = {};
    //~ return p;
  //~ },
  
  before_row_edit : function(record) {},
    
  //~ search_keypress : function(){
    //~ console.log("2012124 search_keypress",arguments);
  //~ },
  search_validate : function(value) {
    if (value == this.quick_search_text) return true;
    this.is_searching = true;
    //~ console.log('search_validate',value)
    this.quick_search_text = value;
    this.set_base_param('query',value); 
    //~ this.getTopToolbar().changePage(1);
    this.getTopToolbar().moveFirst();
    //~ this.refresh();
    return true;
  },
  
  search_change : function(field,oldValue,newValue) {
    //~ console.log('search_change',field.getValue(),oldValue,newValue)
    this.set_base_param('query',field.getValue()); 
    this.getTopToolbar().moveFirst();
    //~ this.refresh();
  },
  
  apply_grid_config : function(index,grid_configs,rpt_columns) {
    //~ var rpt_columns = this.ls_columns;
    var gc = grid_configs[index];    
    //~ console.log('apply_grid_config() 20100812',name,gc);
    this.gc_name = index;
    if (gc == undefined) {
      return rpt_columns;
      //~ config.columns = config.ls_columns;
      //~ return;
    } 
    //~ delete config.ls_filters
    
    //~ console.log(20100805,config.ls_columns);
    var columns = Array(gc.columns.length);
    for (var j = 0; j < rpt_columns.length;j++) {
      var col = rpt_columns[j];
      for (var i = 0; i < gc.columns.length; i++) {
        if (col.dataIndex == gc.ci[i]) {
          col.width = gc.cw[i];
          col.hidden = gc.ch[i];
          columns[i] = col;
          break;
        }
      }
    }
    
    //~ var columns = Array(rpt_columns.length);
    //~ for (var i = 0; i < rpt_columns.length; i++) {
      //~ columns[i] = rpt_columns[gc.columns[i]];
      //~ columns[i].width = gc.widths[i];
    //~ }
    
    //~ if (gc.hidden_cols) {
      //~ for (var i = 0; i < gc.hidden_cols.length; i++) {
        //~ var hc = gc.hidden_cols[i];
        //~ for (var j = 0; j < columns.length;j++) {
          //~ var col = columns[j];
          //~ if (col.dataIndex == hc) {
            //~ col.hidden = true;
            //~ break
          //~ }
        //~ }
      //~ }
    //~ }
    if (gc.filters) {
      //~ console.log(20100811,'config.ls_filters',config.ls_filters);
      //~ console.log(20100811,'config.ls_grid_config.filters',config.ls_grid_config.filters);
      for (var i = 0; i < gc.filters.length; i++) {
        var fv = gc.filters[i];
        for (var j = 0; j < columns.length;j++) {
          var col = columns[j];
          if (col.dataIndex == fv.field) {
            //~ console.log(20100811, f,' == ',fv);
            if (fv.type == 'string') {
              col.filter.value = fv.value;
              //~ if (fv.comparison !== undefined) f.comparison = fv.comparison;
            } else {
              //~ console.log(20100811, fv);
              col.filter.value = {};
              col.filter.value[fv.comparison] = fv.value;
            }
            break;
          }
        };
      }
    }
    
    return columns;
    //~ config.columns = cols;
    //~ delete config.ls_columns
  },
  
  get_current_grid_config : function () {
    var cm = this.getColumnModel();
    var widths = Array(cm.config.length);
    var hiddens = Array(cm.config.length);
    //~ var hiddens = Array(cm.config.length);
    var columns = Array(cm.config.length);
    //~ var columns = Array(cm.config.length);
    //~ var hidden_cols = [];
    //~ var filters = this.filters.getFilterValues();
    var p = this.filters.buildQuery(this.filters.getFilterData())
    for (var i = 0; i < cm.config.length; i++) {
      var col = cm.config[i];
      columns[i] = col.dataIndex;
      //~ hiddens[i] = col.hidden;
      widths[i] = col.width;
      hiddens[i] = col.hidden;
      //~ if (col.hidden) hidden_cols.push(col.dataIndex);
    }
    //~ p['hidden_cols'] = hidden_cols;
    p.cw = widths;
    p.ch = hiddens;
    p.ci = columns;
    //~ p['widths'] = widths;
    //~ p['hiddens'] = hiddens;
    //~ p['columns'] = columns;
    p['name'] = this.gc_name;
    //~ var gc = this.ls_grid_configs[this.gc_name];
    //~ if (gc !== undefined) 
        //~ p['label'] = gc.label
    //~ console.log('20100810 save_grid_config',p);
    return p;
  },
  
  unused_manage_grid_configs : function() {
    var data = [];
    for (k in this.ls_grid_configs) {
      var v = this.ls_grid_configs[k];
      var i = [k,String(v.columns),String(v.hidden_cols),String(v.filters)];
      data.push(i)
    }
    if (this.ls_grid_configs[this.gc_name] == undefined) {
      var v = this.get_current_grid_config();
      var i = [k,String(v.columns),String(v.hidden_cols),String(v.filters)];
      data.push(i);
    }
    //~ console.log(20100811, data);
    var main = new Ext.grid.GridPanel({
      store: new Ext.data.ArrayStore({
        idIndex:0,
        fields:['name','columns','hidden_cols','filters'],
        autoDestroy:true,
        data: data}),
      //~ autoHeight:true,
      selModel: new Ext.grid.RowSelectionModel(),
      listeners: { 
        rowdblclick: function(grid,rowIndex,e) {
          console.log('row doubleclicked',grid, rowIndex,e);
        },
        rowclick: function(grid,rowIndex,e) {
          console.log('row clicked',grid, rowIndex,e);
        }
      },
      columns: [ 
        {dataIndex:'name',header:'Name'}, 
        {dataIndex:'columns',header:'columns'}, 
        {dataIndex:'hidden_cols',header:'hidden columns'}, 
        {dataIndex:'filters',header:'filters'} 
      ]
    });
    var win = new Ext.Window({title:'GridConfigs Manager',layout:'fit',items:main,height:200});
    win.show();
  },
  
  unused_edit_grid_config : function(name) {
    gc = this.ls_grid_configs[name];
    var win = new Ext.Window({
      title:'Edit Grid Config',layout:'vbox', 
      //~ layoutConfig:'stretch'
      items:[
        {xtype:'text', value: gc.name},
        {xtype:'text', value: gc.columns},
        {xtype:'text', value: gc.hidden_cols},
        {xtype:'text', value: gc.filters}
      ]
    });
    win.show();
  },
  
  save_grid_config : function () {
    //~ console.log('TODO: save_grid_config',this);
    //~ p.column_widths = Ext.pluck(this.colModel.columns,'width');
    var a = { 
      params:this.get_current_grid_config(), 
      method:'PUT',
      url:'/grid_config' + this.ls_url,
      success: Lino.action_handler(this),
      scope: this,
      failure: Lino.ajax_error_handler(this)
    };
    this.loadMask.show(); // 20120211
    Ext.Ajax.request(a);
    //~ Lino.do_action(this,a);
  },
  
  on_beforeedit : function(e) {
    //~ console.log('20130128 GridPanel.on_beforeedit()',e,e.record.data.disable_editing);
    if(this.disable_editing | e.record.data.disable_editing) {
      e.cancel = true;
      Lino.notify("This record is disabled");
      return;
    }
    if(e.record.data.disabled_fields && e.record.data.disabled_fields[e.field]) {
      e.cancel = true;
      Lino.notify("This field is disabled");
      return;
    }
    //~ if (e.record.data.disabled_fields) {
      //~ for (i in e.record.data.disabled_fields) {
        //~ if(e.record.data.disabled_fields[i] == e.field) {
          //~ e.cancel = true;
          //~ Lino.notify(String.format('Field "{0}" is disabled for this record',e.field));
          //~ return
        //~ }
      //~ }
    //~ }
  },
  save_grid_data : function() {
      //~ console.log("20120814 save_grid_data");
      this.getStore().commitChanges();
  },
  new_on_afteredit : function(e) {
      //~ this.getStore().commitChanges();
      //~ this.getStore().doUpdate();
      //~ this.getStore().loadData(data);
      console.log("20120814 new_on_afteredit",e);
  },
  on_afteredit : function(e) {
    /*
    e.grid - The grid that fired the event
    e.record - The record being edited
    e.field - The field name being edited
    e.value - The value being set
    e.originalValue - The original value for the field, before the edit.
    e.row - The grid row index
    e.column - The grid column index
    */
    var p = {};
    //~ console.log('20101130 modified: ',e.record.modified);
    //~ console.log('20101130 value: ',e.value);
    //~ var p = e.record.getChanges();
    //~ console.log('20101130 getChanges: ',e.record.getChanges());
    //~ this.before_row_edit(e.record);
    for(k in e.record.getChanges()) {
        var v = e.record.get(k);
    //~ for(k in e.record.modified) {
        //~ console.log('20101130',k,'=',v);
        //~ var cm = e.grid.getColumnModel();
        //~ var di = cm.getDataIndex(k);
        var f = e.record.fields.get(k);
        //~ console.log('20101130 f = ',f);
        //~ var v = e.record.get(di);
        if (f.type.type == 'date') {
            p[k] = Ext.util.Format.date(v, f.dateFormat);
        }else{
            p[k] = v;
            var v = e.record.get(k+'Hidden');
            if (v !== undefined) {
              p[k+'Hidden'] = v;
            }
        }
        //~ var i = cm.findColumnIndex(k);
        //~ var r = cm.getRenderer(i);
        //~ var editor = cm.getCellEditor(i,e.row);
        //~ var col = e.grid.getColumnModel().getColumnById(k);
        //~ console.log('20101130 r = ',r(v));
        //~ var f = e.record.fields[k];
        //~ console.log('20101130 f = ',f);
        //~ console.log('20101130 editor = ',editor);
        //~ p[k] = f.getValue();
        //~ p[k] = r(v);
    }
    //~ console.log('20101130 p:',p);
    //~ var cm = e.grid.getColumnModel();
    //~ var di = cm.getDataIndex(e.column);
    //~ var f = e.record.fields.get(di);
    //~ console.log('20101130 f = ',f);
    //~ if (f.type.type == 'date') e.record.set(di,Ext.util.Format.date(e.value, f.dateFormat));
    
    
    //~ var p = e.record.data;
    
    // var p = {};
    //~ p['grid_afteredit_colname'] = e.field;
    //~ p[e.field] = e.value;
    //~ console.log('20100723 GridPanel.on_afteredit()',e);
    // add value used by ForeignKeyStoreField CHOICES_HIDDEN_SUFFIX
    // not sure whether this is still needed:
    p[e.field+'Hidden'] = e.value;
    //~ p.su = Lino.subst_user;
    Lino.insert_subst_user(p);
    // this one is needed so that this field can serve as choice context:
    e.record.data[e.field+'Hidden'] = e.value;
    // p[pk] = e.record.data[pk];
    // console.log("grid_afteredit:",e.field,'=',e.value);
    Ext.apply(p,this.get_base_params()); // needed for POST, ignored for PUT
    //~ Ext.apply(p,this.containing_window.config.base_params);
    //~ 20121109 p['$ext_requests.URL_PARAM_ACTION_NAME'] = 'grid';
    var self = this;
    var req = {
        params:p,
        waitMsg: 'Saving your data...',
        success: Lino.action_handler( this, function(result) {
          //~ if (result.data_record) {
          if (result.refresh_all) {
              var cw = self.get_containing_window();
              if (cw) {
                  cw.main_item.refresh();
              }
              else console.log("20120123 cannot refresh_all",self);
          } else if (result.rows) {
              //~ self.getStore().loadData(result,true);
              var r = self.getStore().reader.readRecords(result);
              if (e.record.phantom) {
                  //~ console.log("20120816 afteredit.success POST",r);
                  self.getStore().insert(e.row,r.records);
              }else{
                  //~ console.log("20120816 afteredit.success PUT",r);
                  self.getStore().doUpdate(r.records[0]);
              }
              self.getStore().rejectChanges(); /* 
              get rid of the red triangles without saving the record again
              */
              //~ self.getStore().commitChanges(); // get rid of the red triangles
          } else {
              self.getStore().commitChanges(); // get rid of the red triangles
              self.getStore().reload();        // reload our datastore.
          }
          }),
        scope: this,
        failure: Lino.ajax_error_handler(this)
    };
    if (e.record.phantom) {
      req.params.an = 'post'; // SubmitInsert.action_name
      Ext.apply(req,{
        method: 'POST',
        url: '/api' + this.ls_url
      });
    } else {
      req.params.an = 'put'; // SubmitDetail.action_name
      Ext.apply(req,{
        method: 'PUT',
        url: '/api' + this.ls_url + '/' + e.record.id
      });
    }
    //~ console.log('20110406 on_afteredit',req);
    this.loadMask.show(); // 20120211
    Ext.Ajax.request(req);
  },

  afterRender : function() {
    Lino.GridPanel.superclass.afterRender.call(this);
    // this.getView().mainBody.focus();
    // console.log(20100114,this.getView().getRows());
    // if (this.getView().getRows().length > 0) {
    //  this.getView().focusRow(1);
    // }
    //~ this.my_load_mask = new Ext.LoadMask(this.getEl(), {
        //~ msg:'$_("Please wait...")',
        //~ store:this.store});
      
    var tbar = this.getTopToolbar();
    // tbar.on('change',function() {this.getView().focusRow(1);},this);
    // tbar.on('change',function() {this.getSelectionModel().selectFirstRow();this.getView().mainBody.focus();},this);
    // tbar.on('change',function() {this.getView().mainBody.focus();},this);
    // tbar.on('change',function() {this.getView().focusRow(1);},this);
    this.nav = new Ext.KeyNav(this.getEl(),{
      pageUp: function() {tbar.movePrevious(); },
      pageDown: function() {tbar.moveNext(); },
      home: function() {tbar.moveFirst(); },
      end: function() {tbar.moveLast(); },
      scope: this
    });
  },
  after_delete : function() {
    //~ console.log('Lino.GridPanel.after_delete');
    this.refresh();
  },
  add_row_listener : function(fn,scope) {
    this.getSelectionModel().addListener('rowselect',fn,scope);
  },
  postEditValue : function(value, originalValue, r, field){
    value = Lino.GridPanel.superclass.postEditValue.call(this,value,originalValue,r,field);
    //~ console.log('GridPanel.postEdit()',value, originalValue, r, field);
    return value;
  },
  
  set_start_value : function(v) {
      this.start_value = v;
  },
  preEditValue : function(r, field){
      if (this.start_value) {
        var v = this.start_value;
        delete this.start_value;
        this.activeEditor.selectOnFocus = false;
        return v;
      }
      var value = r.data[field];
      return this.autoEncode && Ext.isString(value) ? Ext.util.Format.htmlDecode(value) : value;
  },
  
  on_master_changed : function() {
    //~ if (! this.enabled) return;
    //~ cmp = this;
    //~ console.log('20130911 Lino.GridPanel.on_master_changed()',this.title,this.rendered);
    if (! this.rendered) return; // 20120213
    var todo = function() {
      if (this.disabled) return;
      //~ if (this.disabled) return;
      //~ if (this.enabled) {
          //~ var src = caller.config.url_data + "/" + record.id + ".jpg"
          //~ console.log(20111125, this.containing_window);
          //~ for (k in p) this.getStore().setBaseParam(k,p[k]);
          //~ console.log('Lino.GridPanel.on_master_changed()',this.title,p);
          this.refresh();
          //~ this.set_base_params(this.master_panel.get_master_params());
          //~ this.getStore().load(); 
      //~ }
    };
    Lino.do_when_visible(this,todo.createDelegate(this));
  },
  load_record_id : function(record_id,after) {
      Lino.run_detail_handler(this,record_id)
  }
  
});
  

//~ Lino.MainPanelMixin = {
  //~ tbar_items : function() {
      //~ return ;
  //~ }
//~ };

//~ Ext.override(Lino.GridPanel,Lino.MainPanelMixin);
//~ Ext.override(Lino.FormPanel,Lino.MainPanelMixin);

//~ Lino.grid_context_menu = function(e) {
  //~ console.log('contextmenu',arguments);
//~ }

Lino.cell_context_menu = function(grid,row,col,e) {
  //~ console.log('20120531 cellcontextmenu',grid,row,col,e,grid.store.reader.arrayData.rows[row]);
  e.stopEvent();
  //~ grid.getView().focusCell(row,col);
  grid.getSelectionModel().select(row,col);
  //~ console.log(grid.store.getAt(row));
  //~ grid.getView().focusRow(row);
  //~ return;
  if(!grid.cmenu.el){grid.cmenu.render(); }
  //~ if(e.record.data.disabled_fields) {
  
  var da = grid.store.reader.arrayData.rows[row][grid.disabled_actions_index];
  if (da) {
      this.cmenu.cascade(function(item){ 
        //~ console.log(20120531, item.itemId, da[item.itemId]);
        if (da[item.itemId]) item.disable(); else item.enable();
      });
  };
  
  var xy = e.getXY();
  xy[1] -= grid.cmenu.el.getHeight();
  grid.cmenu.showAt(xy);
}


//~ Lino.load_main_menu = function() {
  //~ Ext.Ajax.request({
    //~ waitMsg: 'Loading main menu...',
    //~ method: 'GET',
    //~ url: '/menu',
    //~ success: Lino.on_load_menu,
    //~ failure: Lino.ajax_error_handler
  //~ });
//~ };



//~ Lino.SlavePlugin = function(caller) {
  //~ this.caller = caller;
//~ };

Lino.chooser_handler = function(combo,name) {
  return function(cmp,newValue,oldValue) {
    //~ console.log('Lino.chooser_handler()',cmp,oldValue,newValue);
    combo.setContextValue(name,newValue);
  }
};



Lino.ComboBox = Ext.extend(Ext.form.ComboBox,{
  forceSelection: true,
  triggerAction: 'all',
  minListWidth:230,
  autoSelect: false,
  selectOnFocus: true, // select any existing text in the field immediately on focus.
  submitValue: true,
  displayField: 'text', // 'text', 
  valueField: 'value', // 'value',
  
  //~ initComponent : Ext.form.ComboBox.prototype.initComponent.createSequence(function() {
  initComponent : function(){
      this.contextParams = {};
      //~ Ext.form.ComboBox.initComponent(this);
      Lino.ComboBox.superclass.initComponent.call(this);
  },
  setValue : function(v,record_data){
      /*
      Based on feature request developed in http://extjs.net/forum/showthread.php?t=75751
      */
      /* `record_data` is used to get the text corresponding to this value */
      //~ if(this.name == 'city') 
      //~ console.log('20120203', this.name,'.setValue(', v ,') this=', this,'record_data=',record_data);
      var text = v;
      if(this.valueField){
        if(v == null || v == '') { 
            //~ if (this.name == 'birth_country') 
                //~ console.log(this.name,'.setValue',v,'no lookup needed, value is empty');
            //~ v = undefined;
            v = '';
            //~ text = '';
        } else if (Ext.isDefined(record_data)) {
          text = record_data[this.name];
          //~ if (this.name == 'birth_country') 
            //~ console.log(this.name,'.setValue',v,'got text ',text,' from record ',record);
        } else {
          // if(this.mode == 'remote' && !Ext.isDefined(this.store.totalLength)){
          if(this.mode == 'remote' && ( this.lastQuery === null || (!Ext.isDefined(this.store.totalLength)))){
              //~ if (this.name == 'birth_country') console.log(this.name,'.setValue',v,'store not yet loaded');
              this.store.on('load', this.setValue.createDelegate(this, arguments), null, {single: true});
              if(this.store.lastOptions === null || this.lastQuery === null){
                  var params;
                  if(this.valueParam){
                      params = {};
                      params[this.valueParam] = v;
                  }else{
                      var q = this.allQuery;
                      this.lastQuery = q;
                      this.store.setBaseParam(this.queryParam, q);
                      params = this.getParams(q);
                  }
                  //~ if (this.name == 'birth_country') 
                    //~ console.log(this.name,'.setValue',v,' : call load() with params ',params);
                  this.store.load({params: params});
              //~ }else{
                  //~ if (this.name == 'birth_country') 
                    //~ console.log(this.name,'.setValue',v,' : but store is loading',this.store.lastOptions);
              }
              return;
          //~ }else{
              //~ if (this.name == 'birth_country') 
                //~ console.log(this.name,'.setValue',v,' : store is loaded, lastQuery is "',this.lastQuery,'"');
          }
          var r = this.findRecord(this.valueField, v);
          if(r){
              text = r.data[this.displayField];
          }else if(this.valueNotFoundText !== undefined){
              text = this.valueNotFoundText;
          }
        }
      }
      this.lastSelectionText = text;
      //~ this.lastSelectionText = v;
      if(this.hiddenField){
          //~ this.hiddenField.originalValue = v;
          this.hiddenField.value = v;
      }
      Ext.form.ComboBox.superclass.setValue.call(this, text);
      this.value = v; // needed for grid.afteredit
  },
  
  getParams : function(q){
    // p = Ext.form.ComboBox.superclass.getParams.call(this, q);
    // causes "Ext.form.ComboBox.superclass.getParams is undefined"
    var p = {};
    //p[this.queryParam] = q;
    if(this.pageSize){
        //~ p.start = 0;
        //~ p.limit = this.pageSize;
        p['start'] = 0;
        p['limit'] = this.pageSize;
    }
    // now my code:
    if(this.contextParams) Ext.apply(p,this.contextParams);
    //~ if(this.contextParams && this.contextValues) {
      //~ for(i = 0; i <= this.contextParams.length; i++)
        //~ p[this.contextParams[i]] = this.contextValues[i];
    //~ }
    return p;
  },
  setContextValue : function(name,value) {
    //~ console.log('setContextValue',this,this.name,':',name,'=',value);
    //~ if (this.contextValues === undefined) {
        //~ this.contextValues = Array(); // this.contextParams.length);
    //~ }
    if (this.contextParams[name] != value) {
      //~ console.log('setContextValue 1',this.contextParams);
      this.contextParams[name] = value;
      this.lastQuery = null;
      //~ console.log('setContextValue 2',this.contextParams);
    }
  }
});

Lino.ChoicesFieldElement = Ext.extend(Lino.ComboBox,{
  mode: 'local'
});


Lino.SimpleRemoteComboStore = Ext.extend(Ext.data.JsonStore,{
  forceSelection: true,
  constructor: function(config){
      Lino.SimpleRemoteComboStore.superclass.constructor.call(this, Ext.apply(config, {
          totalProperty: 'count',
          root: 'rows',
          id: 'value', // ext_requests.CHOICES_VALUE_FIELD
          fields: ['value' ], // ext_requests.CHOICES_VALUE_FIELD, // ext_requests.CHOICES_TEXT_FIELD
          listeners: { exception: Lino.on_store_exception }
      }));
  }
});

Lino.ComplexRemoteComboStore = Ext.extend(Ext.data.JsonStore,{
  constructor: function(config){
      Lino.ComplexRemoteComboStore.superclass.constructor.call(this, Ext.apply(config, {
          totalProperty: 'count',
          root: 'rows',
          id: 'value', // ext_requests.CHOICES_VALUE_FIELD
          fields: ['value','text'], // ext_requests.CHOICES_VALUE_FIELD, // ext_requests.CHOICES_TEXT_FIELD
          listeners: { exception: Lino.on_store_exception }
      }));
  }
});

Lino.RemoteComboFieldElement = Ext.extend(Lino.ComboBox,{
  mode: 'remote',
  //~ forceSelection:false,
  minChars: 2, // default 4 is too much
  queryDelay: 300, // default 500 is maybe slow
  queryParam: 'query', 
  //~ typeAhead: true,
  //~ selectOnFocus: true, // select any existing text in the field immediately on focus.
  resizable: true
});

/*
Thanks to Animal for posting the basic idea:
http://www.sencha.com/forum/showthread.php?15842-2.0-SOLVED-Combobox-twintrigger-clear&p=76130&viewfull=1#post76130

*/
Lino.TwinCombo = Ext.extend(Lino.RemoteComboFieldElement,{
    trigger2Class : 'x-form-search-trigger',
    //~ trigger2Class : 'x-tbar-detail',
    initComponent : function() {
        //~ Lino.TwinCombo.superclass.initComponent.call(this);
        Lino.ComboBox.prototype.initComponent.call(this);
        Ext.form.TwinTriggerField.prototype.initComponent.call(this);
    },
    onTrigger2Click : function() {
        //~ console.log('onTrigger2Click',this,arguments);
    }
  });
//~ Lino.TwinCombo.prototype.initComponent = Ext.form.TwinTriggerField.prototype.initComponent;
Lino.TwinCombo.prototype.getTrigger = Ext.form.TwinTriggerField.prototype.getTrigger;
Lino.TwinCombo.prototype.getOuterSize = Ext.form.TwinTriggerField.prototype.getOuterSize;
Lino.TwinCombo.prototype.initTrigger = Ext.form.TwinTriggerField.prototype.initTrigger;
Lino.TwinCombo.prototype.onTrigger1Click = Ext.form.ComboBox.prototype.onTriggerClick;
//~ Lino.TwinCombo.prototype.onTrigger2Click = function() {
    //~ console.log('onTrigger2Click',arguments);
//~ };



Lino.SimpleRemoteComboFieldElement = Ext.extend(Lino.RemoteComboFieldElement,{
  displayField: 'value', 
  valueField: null,
  forceSelection: false
});




Lino.Window = Ext.extend(Ext.Window,{
  //~ layout: "fit", 
  closeAction : 'hide',
  renderTo: 'main_area', 
  constrain: true,
  maximized: true,
  draggable: false,
  width: 700,
  height: 500,
  maximizable: false,
  constructor : function (config) {
    if (config.main_item.params_panel) {
        config.layout = 'border';
        config.main_item.region = 'center';
        config.main_item.params_panel.region = 'north';
        //~ config.main_item.params_panel.autoHeight = false; // 20130924
        config.main_item.params_panel.hidden = config.main_item.params_panel_hidden;
        config.items = [config.main_item.params_panel, config.main_item];
        //~ 20130923b
    } else {
        config.layout = 'fit';
        config.items = config.main_item;
    }
    this.main_item = config.main_item; 
    
    delete config.main_item;
    //~ delete config.params_item;
    
    //~ this.main_item = config.items.get(0);
    this.main_item.containing_window = this;
    
    //~ console.log('20120110 Lino.Window.constructor() 1');
    //~ if (Lino.current_window) { // all windows except the top are closable
    if (this.main_item.hide_window_title) { 
      config.closable = false;
      config.frame = false;
      config.shadow = false;
      //~ config.border = true;
      //~ config.title = undefined;
      //~ config.tools = null;
      delete config.title;
      delete config.tools;
    } else {
      config.title = this.main_item.empty_title;
      config.closable = true;
      config.tools = [ 
        { qtip: 'permalink', handler: Lino.permalink_handler(this), id: "pin" }
      ];
      if (this.main_item.content_type && this.main_item.action_name != 'insert') {
        config.tools = [ {
          handler: Lino.help_text_editor,
          qtip: "Edit help texts for fields on this model.",
          scope: this.main_item,
          id: "gear"
        }].concat(config.tools);
      }
        
    //~ { qtip: '', handler: Lino.save_wc_handler(this), id: "save" }, 
    //~ { qtip: this.config.qtip, handler: Lino.save_wc_handler(this), id: "save" }, 
    //~ { qtip: 'Call doLayout() on main Container.', handler: Lino.refresh_handler(this), id: "refresh" },
    //~ if (this.main_item.params_panel) {
        //~ config.tools = config.tools.concat([ 
          //~ { qtip: 'Show/hide parameter panel', handler: this.toggle_params_panel, id: "gear", scope:this } 
        //~ ]);
    //~ }
    //~ if (config.closable !== false) {
      // if undefined, will take default behaviour
      //~ config.tools = config.tools.concat([ 
        //~ { qtip: 'close', handler: this.hide, id: "close", scope:this } 
      //~ ]);
    }
    
    this.main_item.config_containing_window(config);
    
    //~ console.log('20120110 Lino.Window.constructor() 2');
    Lino.Window.superclass.constructor.call(this,config);
    
    //~ console.log('20120110 Lino.Window.constructor() 3');
    
  },
  initComponent : function() {
    this.main_item.init_containing_window(this);
    Lino.Window.superclass.initComponent.call(this);
  
  },
  hide : function() { 
      this.main_item.do_when_clean(false,function() { 
        Lino.close_window(); });
  },
  hide_really : function() { 
    Lino.Window.superclass.hide.call(this);
  },
  onRender : function(ct, position){
    //~ console.log('20120110 Lino.Window.onRender() 1');
    Lino.Window.superclass.onRender.call(this, ct, position);
    var main_area = Ext.getCmp('main_area')
    //~ console.log('20120110 Lino.Window.onRender() 2');
  
    this.on('show', function(win) {
        //~ console.log('20120110 Lino.Window.on show 1');
        main_area.on('resize', win.onWindowResize, win);
    });
    this.on('hide', function(win) {
        main_area.un('resize', win.onWindowResize, win);
    });
    //~ console.log('20120110 Lino.Window.onRender() 3');
  }
});


Lino.unused_ParamWindow = Ext.extend(Lino.Window,{
  //~ layout: "border", 
  constructor : function (config) {
    Lino.ParamWindow.superclass.constructor.call(this,config);
    this.main_item = config.items; // `items` must be a single component
    config.layout = 'border';
    this.main_item.region = 'center';
    config.params.region = 'north';
    config.items = [config.params, config.items];
    //~ delete config.params;
  }
});




(function(){
    var ns = Ext.ns('Ext.ux.plugins');

    /**
     * @class Ext.ux.plugins.DefaultButton
     * @extends Object
     *
     * Plugin for Button that will click() the button if the user presses ENTER while
     * a component in the button's form has focus.
     *
     * @author Stephen Friedrich
     * @date 09-DEC-2009
     * @version 0.1
     *
     */
    ns.DefaultButton =  Ext.extend(Object, {
        init: function(button) {
            button.on('afterRender', setupKeyListener, button);
        }
    });

    function setupKeyListener() {
        var formPanel = this.findParentByType('form');
        new Ext.KeyMap(formPanel.el, {
            key: Ext.EventObject.ENTER,
            shift: false,
            alt: false,
            fn: function(keyCode, e){
                if(e.target.type === 'textarea' && !e.ctrlKey) {
                    return true;
                }

                this.el.select('button').item(0).dom.click();
                return false;
            },
            scope: this
        });
    }

    Ext.ComponentMgr.registerPlugin('defaultButton', ns.DefaultButton);

})(); 

Ext.override(Ext.form.BasicForm,{
    my_loadRecord : function(values){
    //~ loadRecord : function(record){
        /* Same as ExtJS's loadRecord() (setValues()), except that we 
        forward also the record to field.setValue() so that Lino.Combobox 
        can use it. 
        */
        //~ console.log('20120918 my_loadRecord',values)
        if(Ext.isArray(values)){ 
            for(var i = 0, len = values.length; i < len; i++){
                var v = values[i];
                var f = this.findField(v.id);
                if(f){
                    f.setValue(v.value,values);
                    if(this.trackResetOnLoad){
                        f.originalValue = f.getValue();
                    }
                }
            }
        }else{ 
            var field, id;
            for(id in values){
                if(!Ext.isFunction(values[id]) && (field = this.findField(id))){
                    field.setValue(values[id],values);
                    if(this.trackResetOnLoad){
                        field.originalValue = field.getValue();
                        //~ if (field.hiddenField) {
                          //~ field.hiddenField.originalValue = field.hiddenField.value;
                        //~ }
                    }
                }
            }
        }
        return this;
    }
});




function initializeFooBarDropZone(cmp) {
    //~ console.log('initializeFooBarDropZone',cmp);
    cmp.dropTarget = new Ext.dd.DropTarget(cmp.bwrap, {
      //~ ddGroup     : 'gridDDGroup',
      notifyEnter : function(ddSource, e, data) {
        console.log('notifyEnter',ddSource,e,data);
        //Add some flare to invite drop.
        cmp.body.stopFx();
        cmp.body.highlight();
      },
      notifyDrop  : function(ddSource, e, data){
        console.log('notifyDrop',ddSource,e,data);
        // Reference the record (single selection) for readability
        //~ var selectedRecord = ddSource.dragData.selections[0];


        // Load the record into the form
        //~ formPanel.getForm().my_loadRecord(selectedRecord);


        // Delete record from the grid.  not really required.
        //~ ddSource.grid.store.remove(selectedRecord);

        return(true);
      }
    })
}



Lino.show_mti_child = function(fieldname,detail_handler) {
  //~ console.log('show_mti_child',this);
  //~ console.log('show_mti_child',panel.find("main_area"));
  rec = Lino.current_window.main_item.get_current_record();
  //~ rec = panel.get_current_record();
  if (rec) {
    //~ console.log('show_mti_child',Lino.current_window,rec);
    if (rec.phantom) {
      Lino.notify('Not allowed on phantom record.');
    }else if (rec.data[fieldname]) {
      //~ console.log('show_mti_child',rec.id);
      //~ detail_handler(Lino.current_window.main_item,{},{record_id:rec.id});
      detail_handler.run(null,{record_id:rec.id});
      //~ window.open(urlroot + '/' + rec.id);
      //~ document.location = urlroot + '/' + rec.id;
      //~ window.open(urlroot + '/' + rec.id,'_blank');
    } else {
      Lino.alert("Cannot show MTI child if checkbox is off.");
    }
  } else {
    Lino.notify('No current record.');
  }
};






/*
Mappings towards lino.modlib.cal.models.PanelCalendars
*/
// Sset SS = Ssite.modules.cal.PanelCalendars.get_handle(Sui).store
Ext.ensible.cal.CalendarMappings = {
    CalendarId:   {name:'ID',       mapping: 'id', type: 'int'},
    Title:        {name:'CalTitle', mapping: 'babel_name', type: 'string'},
    Description:  {name:'Desc',     mapping: 'description', type: 'string'},
    ColorId:      {name:'Color',    mapping: 'color', type: 'int'},
    IsHidden:     {name:'Hidden',   mapping: 'is_hidden', type: 'boolean'},    
};
Ext.ensible.cal.CalendarRecord.reconfigure();  


/*
Mappings towards lino.modlib.cal.models.PanelEvents 
*/
// Sset SS = Ssite.modules.cal.PanelEvents.get_handle(Sui).store
Ext.ensible.cal.EventMappings = {
    EventId:     {name: 'ID',        mapping: 'id', type:'int'},
    CalendarId:  {name: 'CalID',     mapping: 'calendarHidden', type: 'int'},
    Title:       {name: 'EvtTitle',  mapping: 'summary'},
    StartDate:   {name: 'StartDt',   mapping: 'start_dt', 
      type: 'date', 
      dateFormat: "Y-m-d\TH:i:s" },
    EndDate:     {name: 'EndDt',     mapping: 'end_dt', 
      type: 'date', 
      dateFormat: "Y-m-d\TH:i:s"},
    RRule:       {name: 'RecurRule', mapping: 'rsetHidden'},
    Location:    {name: 'Location',  mapping: 'placeHidden'},
    Notes:       {name: 'Desc',      mapping: 'description'},
    Url:         {name: 'LinkUrl',   mapping: 'url'},
    IsAllDay:    {name: 'AllDay',    mapping: 'all_day', type: 'boolean'},
    Reminder:    {name: 'Reminder',  mapping: 'reminder'}
    
};
Ext.ensible.cal.EventRecord.reconfigure();


//~ Lino.on_eventclick = 
    
Lino.on_editdetails = 

Lino.format_time = function(dt) {
    return dt.getHours() + ':' + dt.getMinutes();
}
    
Lino.on_eventdelete = function() {
  //~ console.log("Lino.on_eventdelete",arguments);
};

Lino.on_eventadd  = function(cp,rec,el) {
  //~ console.log("Lino.on_eventadd ",arguments);
  return false;
}
    
Lino.on_eventresize  = function(cp,rec,el) {
  //~ console.log("Lino.on_eventresize ",arguments);
  //~ Lino.cal.Events.insert(cp);
  //~ return false;
}
    
Lino.on_eventupdate  = function(cp,rec,el) {
  //~ console.log("Lino.on_eventupdate",arguments);
  //~ Lino.cal.Events.insert(cp);
  //~ return false;
}
    

//~ Lino.eventStore = new Ext.ensible.cal.EventStore({ 
//~ Lino.eventStore = new Ext.data.ArrayStore({ 
Lino.unused_eventStore = new Ext.data.JsonStore({ 
  listeners: { exception: Lino.on_store_exception }
  ,url: '/restful/cal/PanelEvents'
  ,restful : true
  ,proxy: new Ext.data.HttpProxy({ 
      //~ url: '/restful/cal/PanelEvents', 
      url: '/restful/cal/PanelEvents', 
      disableCaching: false // no need for cache busting when loading via Ajax
      //~ disableCaching:true,
  })
  ,fields: Ext.ensible.cal.EventRecord.prototype.fields.getRange()
  ,totalProperty: "count"
  ,root: "rows"
  ,idProperty: Ext.ensible.cal.EventMappings.EventId.mapping
  ,writer : new Ext.data.JsonWriter({
    writeAllFields: false
  })
  ,load: function(options) {
    //~ foo.bar = baz; // 20120213
      if (!options) options = {};
      if (!options.params) options.params = {};
      //~ options.params.$ext_requests.URL_PARAM_TEAM_VIEW = Lino.calendar_app.team_view_button.pressed;
      
      var view = this.cal_panel.getActiveView();
      var bounds = view.getViewBounds();
      //~ var p = {sd:'05.02.2012',ed:'11.02.2012'};
      //~ var p = {};
      options.params[view.dateParamStart] = bounds.start.format(view.dateParamFormat);
      options.params[view.dateParamEnd] = bounds.end.format(view.dateParamFormat);
      Lino.insert_subst_user(options.params);
      //~ Ext.apply(options.params,p)
      //~ console.log('20120710 eventStore.load()',this.baseParams,options);
    
    return Ext.data.JsonStore.prototype.load.call(this,options);
  }
});

//~ Lino.eventStore.on('load', function() {
//~ });


    //~ Lino.subst_user = id;


//~ Lino.calendarStore = new Ext.data.ArrayStore({ 
Lino.unused_calendarStore = new Ext.data.JsonStore({ 
      listeners: { exception: Lino.on_store_exception }
      ,restful : true
      ,proxy: new Ext.data.HttpProxy({ 
          //~ url: '/restful/cal/PanelCalendars?fmt=json', 
          url: '/restful/cal/PanelCalendars?fmt=%7B%7Bext_requests.URL_FORMAT_JSON%7D%7D', 
          disableCaching: false // no need for cache busting when loading via Ajax
          //~ restful : true
          //~ method: "GET"
      })
      //~ ,autoLoad: true
      //~ ,remoteSort: true
      //~ ,baseParams: bp
      ,totalProperty: "count"
      ,root: "rows"
      ,fields: Ext.ensible.cal.CalendarRecord.prototype.fields.getRange()
      ,idProperty: Ext.ensible.cal.CalendarMappings.CalendarId.mapping
      //~ ,idIndex: Ext.ensible.cal.CalendarMappings.CalendarId.mapping
    });


Lino.CalendarCfg = {
    dateParamFormat: 'd.m.Y',
    dateParamStart:'sd',
    dateParamEnd:'ed'
};
//~ 20120704 Lino.CalendarPanel = Ext.extend(Ext.ensible.cal.CalendarPanel,Lino.MainPanel);
//~ Lino.CalendarPanel = Ext.extend(Lino.CalendarPanel,{
Ext.override(Ext.ensible.cal.CalendarPanel,Lino.MainPanel);
Ext.override(Ext.ensible.cal.CalendarPanel,{
  //~ empty_title : "\$ui.get_actor('cal.Panel').report.label",
  empty_title : "Calendar"
  ,activeItem: 1 // 0: day, 1: week
  ,ls_url: '/cal/CalendarPanel'
  //~ ,disableCaching:true
  //~ ,eventStore: Lino.eventStore
  //~ ,calendarStore: Lino.calendarStore
  //~ ,initComponent : function(){
    //~ Ext.ensible.cal.CalendarPanel.superclass.initComponent.call(this);
    //~ this.eventStore.on('load',function(){
      //~ console.log("20130808",Lino.eventStore);
      //~ if (this.eventStore.reader.jsonData) {
        //~ console.log("20130808 b",this.eventStore.reader.jsonData.title);
        //~ this.set_window_title(this.eventStore.reader.jsonData.title);
      //~ }
    //~ },this);
  //~ }
  ,listeners: { 
    editdetails: function(cp,rec,el) {
      //~ console.log("Lino.on_editdetails",arguments);
      if (rec.data.ID)
          Lino.cal.PanelEvents.detail.run(null,{
              record_id:rec.data.ID,
              base_params:this.app_instance.event_store.baseParams});
      return false;
    }
    ,eventclick: function(cp,rec,el) {
      //~ console.log("Lino.on_eventclick",arguments);
      //~ Lino.cal.Events.detail_action.run({record_id:rec.data.ID});
      Lino.cal.PanelEvents.detail.run(null,{
            record_id:rec.data.ID,
                base_params:this.app_instance.event_store.baseParams});
      return false;
    }
    //~ ,eventadd: Lino.on_eventadd
    //~ ,eventdelete: Lino.on_eventdelete
    //~ ,eventresize: Lino.on_eventresize
    ,afterrender : function(config) {
      //~ console.log("20120704 afterrender");
      this.app_instance.calendar_store.load();
      //~ console.log("20120704 afterrender calls eventStore.load()",p);
      this.app_instance.event_store.cal_panel = this;
      //~ Lino.eventStore.load({params:p});
      //~ 20130905 removed: this.app_instance.event_store.load();
      //~ Lino.CalendarPanel.superclass.constructor.call(this, config);
      //~ console.log(20120118, config,this);
    }
    }
  ,enableEditDetails: false
  //~ ,monthViewCfg: Lino.CalendarCfg
  //~ ,weekViewCfg: Lino.CalendarCfg
  //~ ,multiDayViewCfg: Lino.CalendarCfg
  //~ ,multiWeekViewCfg: Lino.CalendarCfg
  //~ ,dayViewCfg: Lino.CalendarCfg
  //~ ,initComponent : function() {
    //~ // this.on('eventadd',Lino.on_eventadd);
    //~ Lino.CalendarPanel.superclass.initComponent.call(this);
  //~ }
});




Lino.CalendarAppPanel = Ext.extend(Ext.Panel,Lino.MainPanel);
Lino.CalendarAppPanel = Ext.extend(Lino.CalendarAppPanel,Lino.PanelMixin);
Lino.CalendarAppPanel = Ext.extend(Lino.CalendarAppPanel,{
  app_instance : null
  //~ empty_title : "\$ui.get_actor('cal.Panel').report.label",
  ,empty_title : "Calendar"
  ,ls_url: '/cal/CalendarPanel'
  ,set_status : function(status,rp) { 
      this.requesting_panel = Ext.getCmp(rp);
      //~ console.log('20120918 CalendarAppPanel.set_status()',status,rp,this.requesting_panel);
      this.clear_base_params();
      if (status == undefined) status = {};
      //~ if (status.param_values) 
      //~ this.set_field_values(status.field_values);
      if (status.base_params) this.set_base_params(status.base_params);
      this.refresh();
      }
  ,refresh : function() {
      //~ this.app_instance.event_store.reload(); 20130905
      this.app_instance.event_store.load();
  }
  ,layout: 'fit'
  ,get_base_params : function() {
    var p = Ext.apply({},this.base_params);
    Lino.insert_subst_user(p);
    return p;
  }
  ,set_base_params : function(p) {
    this.base_params = Ext.apply(this.app_instance.event_store.baseParams,p);
    this.app_instance.event_store.baseParams = this.base_params;
  }
  ,clear_base_params : function() {
      this.base_params = {};
      Lino.insert_subst_user(this.base_params);
  }
  ,set_base_param : function(k,v) {
      if (!this.base_params) this.base_params = {};
      this.base_params[k] = v;
  }
});

Lino.CalendarApp = function() { return {
  team_view_button : null 
  ,get_main_panel : function() {
      var cap = null;
      this.event_store = new Ext.data.JsonStore({ 
          listeners: { exception: Lino.on_store_exception }
          //~ ,url: '/restful/cal/PanelEvents'
          ,url: '//restful/cal/PanelEvents'
          ,restful : true
          ,proxy: new Ext.data.HttpProxy({ 
              //~ url: '/restful/cal/PanelEvents', 
              url: '//restful/cal/PanelEvents', 
              disableCaching: false // no need for cache busting when loading via Ajax
              //~ disableCaching:true,
          })
          ,fields: Ext.ensible.cal.EventRecord.prototype.fields.getRange()
          ,totalProperty: "count"
          ,root: "rows"
          ,idProperty: Ext.ensible.cal.EventMappings.EventId.mapping
          ,writer : new Ext.data.JsonWriter({
            writeAllFields: false
          })
          ,load: function(options) {
            //~ foo.bar = baz; // 20120213
              if (!options) options = {};
              if (!options.params) options.params = {};
              //~ options.params.$ext_requests.URL_PARAM_TEAM_VIEW = Lino.calendar_app.team_view_button.pressed;
              
              var view = this.cal_panel.getActiveView();
              var bounds = view.getViewBounds();
              //~ var p = {sd:'05.02.2012',ed:'11.02.2012'};
              //~ var p = {};
              options.params[view.dateParamStart] = bounds.start.format(view.dateParamFormat);
              options.params[view.dateParamEnd] = bounds.end.format(view.dateParamFormat);
              Lino.insert_subst_user(options.params);
              //~ this.cal_panel.base_params.su.toString();
              //~ if (this.cal_panel) {
                  Ext.apply(options.params,this.cal_panel.base_params);
              //~ }
              //~ Ext.apply(options.params,p)
              //~ console.log('20130905 eventStore.load()',this.cal_panel,this.baseParams,options.params);
            
            return Ext.data.JsonStore.prototype.load.call(this,options);
          }
      });

      //~ Lino.calendarStore
      this.calendar_store = new Ext.data.JsonStore({ 
          listeners: { exception: Lino.on_store_exception }
          ,restful : true
          ,proxy: new Ext.data.HttpProxy({ 
              //~ url: '/restful/cal/PanelCalendars?fmt=json', 
              url: '/restful/cal/PanelCalendars?fmt=%7B%7Bext_requests.URL_FORMAT_JSON%7D%7D', 
              disableCaching: false // no need for cache busting when loading via Ajax
              //~ restful : true
              //~ method: "GET"
          })
          //~ ,autoLoad: true
          //~ ,remoteSort: true
          //~ ,baseParams: bp
          ,totalProperty: "count"
          ,root: "rows"
          ,fields: Ext.ensible.cal.CalendarRecord.prototype.fields.getRange()
          ,idProperty: Ext.ensible.cal.CalendarMappings.CalendarId.mapping
          //~ ,idIndex: Ext.ensible.cal.CalendarMappings.CalendarId.mapping
      });
      
      cap = new Lino.CalendarAppPanel({ 
          app_instance: this, 
          items : 
        //~ [{
          //~ id: 'app-header',
          //~ region: 'north',
          //~ height: 35,
          //~ border: false,
          // contentEl: 'app-header-content'
        //~ },
      {
          id: 'app-center',
          title: '...', // will be updated to the current view's date range
          region: 'center',
          layout: 'border',
          listeners: {
              'afterrender': function(){
                  Ext.getCmp('app-center').header.addClass('app-center-header');
              }
          },
          items: [{
              id:'app-west',
              region: 'west',
              width: 176,
              border: false,
              items: [{
                  xtype: 'datepicker',
                  id: 'app-nav-picker',
                  cls: 'ext-cal-nav-picker',
                  listeners: {
                      'select': {
                          fn: function(dp, dt){
                              //~ Lino.calendarPanel.setStartDate(dt);
                              this.setStartDate(dt);
                          },
                          scope: this
                      }
                  }
              //~ },{ 
                //~ layout:'fit',
                //~ items: [
                  //~ new Ext.form.Checkbox({
                    //~ boxLabel:"$_('Team view')",
                    //~ hideLabel:true
                    //~ listeners: { click: }
                  //~ })
                //~ ]
              },{ 
                layout:'form',
                items: [
                  this.team_view_button = new Ext.Button({
                    text:"Team view",
                    enableToggle:true,
                    pressed:false,
                    toggleHandler: function(btn,state) { 
                      //~ console.log('20120716 teamView.toggle()');
                      this.event_store.setBaseParam('tv',state);
                      this.event_store.load();
                      //~ Lino.eventStore.load({params:{$ext_requests.URL_PARAM_TEAM_VIEW:state}});
                      //~ console.log("team view",state);
                    }
                  })
                ]
              },{
                  xtype: 'extensible.calendarlist',
                  store: this.calendar_store,
                  border: false,
                  width: 175
              }]
          },{
              xtype: 'extensible.calendarpanel', // Ext.ensible.cal.CalendarPanel
              eventStore: this.event_store,
              app_instance: this,
              calendarStore: this.calendar_store,
              border: false,
              id:'app-calendar',
              region: 'center',
              //~ activeItem: 3, // month view
              
              // Any generic view options that should be applied to all sub views:
              viewConfig: {
                  // Lino.CalendarCfg
                  dateParamFormat: 'd.m.Y',
                  dateParamStart:'sd',
                  dateParamEnd:'ed',
                
                  //enableFx: false,
                  //ddIncrement: 10, //only applies to DayView and subclasses, but convenient to put it here
                  viewStartHour: 8,
                  viewEndHour: 18
                  //minEventDisplayMinutes: 15
              },
              
              // View options specific to a certain view (if the same options exist in viewConfig
              // they will be overridden by the view-specific config):
              monthViewCfg: {
                  showHeader: true,
                  showWeekLinks: true,
                  showWeekNumbers: true,
                  eventBodyMarkup: ['{Title}',
                    //~ '<tpl if="url">',
                        //~ '<a href="{url}">XX</a>',
                    //~ '</tpl>',
                    '<tpl if="_isReminder">',
                        '<i class="ext-cal-ic ext-cal-ic-rem">&#160;</i>',
                    '</tpl>',
                    '<tpl if="_isRecurring">',
                        '<i class="ext-cal-ic ext-cal-ic-rcr">&#160;</i>',
                    '</tpl>',
                    '<tpl if="spanLeft">',
                        '<i class="ext-cal-spl">&#160;</i>',
                    '</tpl>',
                    '<tpl if="spanRight">',
                        '<i class="ext-cal-spr">&#160;</i>',
                    '</tpl>'
                ].join('')
              },
              
              multiWeekViewCfg: {
                  //weekCount: 3
              },
              
              // Some optional CalendarPanel configs to experiment with:
              //readOnly: true,
              //showDayView: false,
              //showMultiDayView: true,
              //showWeekView: false,
              //showMultiWeekView: false,
              //showMonthView: false,
              //showNavBar: false,
              //showTodayText: false,
              //showTime: false,
              //editModal: true,
              //enableEditDetails: false,
              //title: 'My Calendar', // the header of the calendar, could be a subtitle for the app
              
              // Once this component inits it will set a reference to itself as an application
              // member property for easy reference in other functions within App.
              //~ initComponent: function() {
                  //~ Lino.calendarPanel = this;
                  //~ this.constructor.prototype.initComponent.apply(this, arguments);
              //~ },
              
              listeners: {
                  //~ 'eventclick': {
                      //~ fn: function(vw, rec, el){
                          //~ this.clearMsg();
                      //~ },
                      //~ scope: this
                  //~ },
                  'eventover': function(vw, rec, el){
                      //console.log('Entered evt rec='+rec.data[Ext.ensible.cal.EventMappings.Title.name]', view='+ vw.id +', el='+el.id);
                  },
                  'eventout': function(vw, rec, el){
                      //console.log('Leaving evt rec='+rec.data[Ext.ensible.cal.EventMappings.Title.name]+', view='+ vw.id +', el='+el.id);
                  },
                  'eventadd': {
                      fn: function(cp, rec){
                          this.showMsg('Event '+ rec.data[Ext.ensible.cal.EventMappings.Title.name] +' was added');
                      },
                      scope: this
                  },
                  'eventupdate': {
                      fn: function(cp, rec){
                          this.showMsg('Event '+ rec.data[Ext.ensible.cal.EventMappings.Title.name] +' was updated');
                      },
                      scope: this
                  },
                  'eventdelete': {
                      fn: function(cp, rec){
                          //this.eventStore.remove(rec);
                          this.showMsg('Event '+ rec.data[Ext.ensible.cal.EventMappings.Title.name] +' was deleted');
                      },
                      scope: this
                  },
                  'eventcancel': {
                      fn: function(cp, rec){
                          // edit canceled
                      },
                      scope: this
                  },
                  'viewchange': {
                      fn: function(p, vw, dateInfo){
                          if(this.editWin){
                              this.editWin.hide();
                          };
                          if(dateInfo !== null){
                              // will be null when switching to the event edit form so ignore
                              Ext.getCmp('app-nav-picker').setValue(dateInfo.activeDate);
                              this.updateTitle(dateInfo.viewStart, dateInfo.viewEnd);
                          }
                          
                      },
                      scope: this
                  },
                  'dayclick': {
                      fn: function(vw, dt, ad, el){
                          this.clearMsg();
                      },
                      scope: this
                  },
                  'rangeselect': {
                      fn: function(vw, dates, onComplete){
                          this.clearMsg();
                      },
                      scope: this
                  },
                  'eventmove': {
                      fn: function(vw, rec){
                          rec.commit();
                          var time = rec.data[Ext.ensible.cal.EventMappings.IsAllDay.name] ? '' : ' \\a\\t g:i a';
                          this.showMsg('Event '+ rec.data[Ext.ensible.cal.EventMappings.Title.name] +' was moved to '+
                              rec.data[Ext.ensible.cal.EventMappings.StartDate.name].format('F jS'+time));
                      },
                      scope: this
                  },
                  'eventresize': {
                      fn: function(vw, rec){
                          rec.commit();
                          this.showMsg('Event '+ rec.data[Ext.ensible.cal.EventMappings.Title.name] +' was updated');
                      },
                      scope: this
                  },
                  'eventdelete': {
                      fn: function(win, rec){
                          this.event_store.remove(rec);
                          this.showMsg('Event '+ rec.data[Ext.ensible.cal.EventMappings.Title.name] +' was deleted');
                      },
                      scope: this
                  },
                  'initdrag': {
                      fn: function(vw){
                          if(this.editWin && this.editWin.isVisible()){
                              this.editWin.hide();
                          }
                      },
                      scope: this
                  }
              }
          }]
        }
        //~ ]
        
      });
      
      this.event_store.on('load',function(){
        //~ console.log("20130905 on event_store load",this.event_store.reader.jsonData);
        if (this.event_store.reader.jsonData) {
          //~ console.log("20130808 b",this.event_store.reader.jsonData.title);
          //~ console.log("20130808 c",this);
          cap.set_window_title(this.event_store.reader.jsonData.title);
        }
      },this);
      
      //~ cap.app_instance = this;
      return cap;
      
  }
  ,updateTitle: function(startDt, endDt){
      var p = Ext.getCmp('app-center');
      
      if(startDt.clearTime().getTime() == endDt.clearTime().getTime()){
          p.setTitle(startDt.format('F j, Y'));
      }
      else if(startDt.getFullYear() == endDt.getFullYear()){
          if(startDt.getMonth() == endDt.getMonth()){
              p.setTitle(startDt.format('F j') + ' - ' + endDt.format('j, Y'));
          }
          else{
              p.setTitle(startDt.format('F j') + ' - ' + endDt.format('F j, Y'));
          }
      }
      else{
          p.setTitle(startDt.format('F j, Y') + ' - ' + endDt.format('F j, Y'));
      }
  }
  // This is an application-specific way to communicate CalendarPanel event messages back to the user.
  // This could be replaced with a function to do "toast" style messages, growl messages, etc. This will
  // vary based on application requirements, which is why it's not baked into the CalendarPanel.
  ,showMsg: function(msg){
      Lino.notify(msg);
      //~ Ext.fly('app-msg').update(msg).removeClass('x-hidden');
  }
  
  ,clearMsg: function(){
      Lino.notify('');
      //~ Ext.fly('app-msg').update('').addClass('x-hidden');
  }
}
};




/*
captureEvents utility by Aaron Conran
<http://www.sencha.com/learn/grid-faq/>

Ext.onReady(function(){
    var grid = new Ext.grid.GridPanel({
        ... 
    });
    captureEvents(grid);
});
*/
function captureEvents(observable) {
    Ext.util.Observable.capture(
        observable,
        function(eventName) {
            console.info(eventName);
        },
        this
    );		
}
 






Lino.main_menu = [ { "menu": { "items": [ { "text": "Persons", "handler": function() {Lino.contacts.Persons.grid.run(null)} }, { "text": " \u25b6 Clients", "handler": function() {Lino.pcsw.Clients.grid.run(null)} }, { "text": "Companies", "handler": function() {Lino.contacts.Companies.grid.run(null)} }, "-", { "text": "Partners (all)", "handler": function() {Lino.contacts.Partners.grid.run(null)} }, { "text": "Households", "handler": function() {Lino.households.Households.grid.run(null)} } ] }, "text": "Contacts" }, { "menu": { "items": [ { "text": "My Outbox", "handler": function() {Lino.outbox.MyOutbox.grid.run(null)} }, { "text": "My Events/Notes", "handler": function() {Lino.notes.MyNotes.grid.run(null)} } ] }, "text": "Office" }, { "menu": { "items": [ { "text": "Calendar", "iconCls": "x-tbar-calendar", "handler": function() {Lino.cal.CalendarPanel.grid.run(null)}, "listeners": { "render": Lino.quicktip_renderer("Foo","Displays your events in a classical \"calendar view\", \nwith the possibility to switch between daily, weekly, monthly view.") } }, { "text": "My events", "listeners": { "render": Lino.quicktip_renderer("Foo","Table of all my calendar events.") }, "handler": function() {Lino.cal.MyEvents.grid.run(null)} }, { "text": "My tasks", "listeners": { "render": Lino.quicktip_renderer("Foo","Table of all my tasks.") }, "handler": function() {Lino.cal.MyTasks.grid.run(null)} }, { "text": "My guests", "handler": function() {Lino.cal.MyGuests.grid.run(null)} }, { "text": "My presences", "listeners": { "render": Lino.quicktip_renderer("Foo","Shows all my presences in calendar events, independently of their state.") }, "handler": function() {Lino.cal.MyPresences.grid.run(null)} } ] }, "text": "Calendar" }, { "menu": { "items": [ { "text": "Clients", "handler": function() {Lino.reception.Clients.grid.run(null)} }, { "text": "Waiting visitors", "listeners": { "render": Lino.quicktip_renderer("Foo","Shows the visitors in the waiting room.") }, "handler": function() {Lino.reception.WaitingVisitors.grid.run(null)} }, { "text": "Busy visitors", "listeners": { "render": Lino.quicktip_renderer("Foo","Shows the visitors who are busy with some agent.") }, "handler": function() {Lino.reception.BusyVisitors.grid.run(null)} }, { "text": "Gone visitors", "listeners": { "render": Lino.quicktip_renderer("Foo","Shows the visitors who have gone.") }, "handler": function() {Lino.reception.GoneVisitors.grid.run(null)} }, { "text": "Visitors waiting for me", "handler": function() {Lino.reception.MyWaitingVisitors.grid.run(null)} } ] }, "text": "Reception" }, { "menu": { "items": [ { "text": "Clients", "listeners": { "render": Lino.quicktip_renderer("Foo","Wie Kontakte --> Klienten, aber mit DSBE-spezifischen Kolonnen und Filterparametern.") }, "handler": function() {Lino.integ.Clients.grid.run(null)} }, { "text": "ISIPs", "handler": function() {Lino.isip.MyContracts.grid.run(null)} }, { "text": "Art.60\u00a77 contracts", "handler": function() {Lino.jobs.MyContracts.grid.run(null)} }, { "text": "Job Providers", "handler": function() {Lino.jobs.JobProviders.grid.run(null)} }, { "text": "Jobs", "listeners": { "render": Lino.quicktip_renderer("Foo","\n    Eine Stelle ist ein Arbeitsplatz bei einem Stellenabieter. \n    ") }, "handler": function() {Lino.jobs.Jobs.grid.run(null)} }, { "text": "Job Offers", "handler": function() {Lino.jobs.Offers.grid.run(null)} } ] }, "text": "Integration" }, { "menu": { "items": [ { "text": "Course providers", "handler": function() {Lino.courses.CourseProviders.grid.run(null)} }, { "text": "Course Offers", "handler": function() {Lino.courses.CourseOffers.grid.run(null)} }, { "text": "Pending Course Requests", "handler": function() {Lino.courses.PendingCourseRequests.grid.run(null)} } ] }, "text": "Courses" }, { "menu": { "items": [ { "text": "New Clients", "listeners": { "render": Lino.quicktip_renderer("Foo","Liste der neuen Klienten zwecks Zuweisung \neines Begleiters oder Ablehnen des Hilfeantrags.") }, "handler": function() {Lino.newcomers.NewClients.grid.run(null)} }, { "text": "Available Coaches", "listeners": { "render": Lino.quicktip_renderer("Foo","List of users available for new coachings") }, "handler": function() {Lino.newcomers.AvailableCoaches.grid.run(null)} } ] }, "text": "Newcomers" }, { "menu": { "items": [ { "text": "Clients", "listeners": { "render": Lino.quicktip_renderer("Foo","Wie Kontakte --> Klienten, aber mit Kolonnen und Filterparametern f\u00fcr Schuldnerberatung.") }, "handler": function() {Lino.pcsw.DebtsClients.grid.run(null)} }, { "text": "My Budgets", "handler": function() {Lino.debts.MyBudgets.grid.run(null)} } ] }, "text": "Debts mediation" }, { "menu": { "items": [ { "menu": { "items": [ { "text": "Data Test Clients", "listeners": { "render": Lino.quicktip_renderer("Foo","Table of Clients whose data seems unlogical or inconsistent.") }, "handler": function() {Lino.pcsw.ClientsTest.grid.run(null)} } ] }, "text": "PCSW" }, { "menu": { "items": [ { "text": "Users with their Clients", "handler": function() {Lino.integ.UsersWithClients.grid.run(null)} }, { "text": "Contracts Situation", "listeners": { "render": Lino.quicktip_renderer("Foo","Open a detail window on this record") }, "handler": function() {Lino.jobs.JobsOverview.show.run(null,{ "record_id": -99998 })} }, { "text": "Activity Report", "listeners": { "render": Lino.quicktip_renderer("Foo","Open a detail window on this record") }, "handler": function() {Lino.integ.ActivityReport.show.run(null,{ "record_id": -99998 })} } ] }, "text": "Integration" } ] }, "text": "Listings" }, { "menu": { "items": [ { "menu": { "items": [ { "text": "My Text Field Templates", "handler": function() {Lino.system.MyTextFieldTemplates.grid.run(null)} }, { "text": "Upload Types", "handler": function() {Lino.uploads.UploadTypes.grid.run(null)} }, { "text": "Note Types", "handler": function() {Lino.notes.NoteTypes.grid.run(null)} }, { "text": "Event Types", "handler": function() {Lino.notes.EventTypes.grid.run(null)} } ] }, "text": "Office" }, { "menu": { "items": [ { "text": "Site Parameters", "iconCls": "x-tbar-application_form", "handler": function() {Lino.system.SiteConfigs.detail.run(null,{ "record_id": 1 })} }, { "text": "Users", "listeners": { "render": Lino.quicktip_renderer("Foo","Shows the list of all users on this site.") }, "handler": function() {Lino.users.Users.grid.run(null)} }, { "text": "Teams", "handler": function() {Lino.users.Teams.grid.run(null)} }, { "text": "content types", "handler": function() {Lino.system.ContentTypes.grid.run(null)} }, { "text": "Help Texts", "handler": function() {Lino.system.HelpTexts.grid.run(null)} } ] }, "text": "System" }, { "menu": { "items": [ { "text": "Countries", "listeners": { "render": Lino.quicktip_renderer("Foo","\n    A country is a geographic entity considered a \"nation\".\n    ") }, "handler": function() {Lino.countries.Countries.grid.run(null)} }, { "text": "Places", "listeners": { "render": Lino.quicktip_renderer("Foo","\n    The table of known geographical places.\n    A geographical place can be a city, a town, a suburb, \n    a province, a lake... any named geographic entity,\n    except for countries because these have their own table.\n    ") }, "handler": function() {Lino.countries.Cities.grid.run(null)} }, { "text": "company types", "handler": function() {Lino.contacts.CompanyTypes.grid.run(null)} }, { "text": "Functions", "handler": function() {Lino.contacts.RoleTypes.grid.run(null)} }, { "text": "Languages", "handler": function() {Lino.languages.Languages.grid.run(null)} } ] }, "text": "Contacts" }, { "menu": { "items": [ { "text": "Property Groups", "handler": function() {Lino.properties.PropGroups.grid.run(null)} }, { "text": "Property Types", "handler": function() {Lino.properties.PropTypes.grid.run(null)} } ] }, "text": "Properties" }, { "menu": { "items": [ { "text": "Rooms", "listeners": { "render": Lino.quicktip_renderer("Foo","List of rooms where calendar events can happen.") }, "handler": function() {Lino.cal.Rooms.grid.run(null)} }, { "text": "Priorities", "listeners": { "render": Lino.quicktip_renderer("Foo","List of possible priorities of calendar events.") }, "handler": function() {Lino.cal.Priorities.grid.run(null)} }, { "text": "Guest Roles", "listeners": { "render": Lino.quicktip_renderer("Foo","The role of a guest expresses what the \n    partner is going to do there.") }, "handler": function() {Lino.cal.GuestRoles.grid.run(null)} }, { "text": "Calendars", "listeners": { "render": Lino.quicktip_renderer("Foo","The list of calendars defined on this system.\n    A calendar is a list of events which have certain things in common,\n    especially they are displayed in the same colour in the calendar panel") }, "handler": function() {Lino.cal.Calendars.grid.run(null)} } ] }, "text": "Calendar" }, { "menu": { "items": [ { "text": "Household Roles", "handler": function() {Lino.households.Roles.grid.run(null)} }, { "text": "Household Types", "handler": function() {Lino.households.Types.grid.run(null)} } ] }, "text": "Households" }, { "menu": { "items": [ { "text": "Account Charts", "handler": function() {Lino.accounts.Charts.grid.run(null)} }, { "text": "Account Groups", "handler": function() {Lino.accounts.Groups.grid.run(null)} }, { "text": "Accounts", "handler": function() {Lino.accounts.Accounts.grid.run(null)} } ] }, "text": "Accounting" }, { "menu": { "items": [ { "text": "Integration Phases", "listeners": { "render": Lino.quicktip_renderer("Foo","Liste des phases d'int\u00e9gration possibles.") }, "handler": function() {Lino.pcsw.PersonGroups.grid.run(null)} }, { "text": "activities", "listeners": { "render": Lino.quicktip_renderer("Foo","Liste des \"activit\u00e9s\" ou \"codes profession\".") }, "handler": function() {Lino.pcsw.Activities.grid.run(null)} }, { "text": "Exclusion Types", "listeners": { "render": Lino.quicktip_renderer("Foo","Liste des raisons possibles d'arr\u00eater temporairement \n    le paiement d'une aide financi\u00e8re pr\u00e9vue.") }, "handler": function() {Lino.pcsw.ExclusionTypes.grid.run(null)} }, { "text": "Coaching types", "listeners": { "render": Lino.quicktip_renderer("Foo","Liste des types d'accompagnement.") }, "handler": function() {Lino.pcsw.CoachingTypes.grid.run(null)} }, { "text": "Coaching termination reasons", "listeners": { "render": Lino.quicktip_renderer("Foo","A list of reasons expressing why a coaching was ended") }, "handler": function() {Lino.pcsw.CoachingEndings.grid.run(null)} }, { "text": "Dispense reasons", "listeners": { "render": Lino.quicktip_renderer("Foo","A list of reasons for being dispensed") }, "handler": function() {Lino.pcsw.DispenseReasons.grid.run(null)} }, { "text": "Client Contact types", "listeners": { "render": Lino.quicktip_renderer("Foo","Liste des types de contacts client.") }, "handler": function() {Lino.pcsw.ClientContactTypes.grid.run(null)} } ] }, "text": "PCSW" }, { "menu": { "items": [ { "text": "ISIP Types", "handler": function() {Lino.isip.ContractTypes.grid.run(null)} }, { "text": "Contract termination reasons", "handler": function() {Lino.isip.ContractEndings.grid.run(null)} }, { "text": "Examination Policies", "handler": function() {Lino.isip.ExamPolicies.grid.run(null)} }, { "text": "study types", "handler": function() {Lino.isip.StudyTypes.grid.run(null)} }, { "text": "Job Contract Types", "handler": function() {Lino.jobs.ContractTypes.grid.run(null)} }, { "text": "Job Types", "handler": function() {Lino.jobs.JobTypes.grid.run(null)} }, { "text": "Job Sectors", "handler": function() {Lino.jobs.Sectors.grid.run(null)} }, { "text": "Job Functions", "handler": function() {Lino.jobs.Functions.grid.run(null)} }, { "text": "Work Schedules", "handler": function() {Lino.jobs.Schedules.grid.run(null)} }, { "text": "Work Regimes", "handler": function() {Lino.jobs.Regimes.grid.run(null)} } ] }, "text": "Integration" }, { "menu": { "items": [ { "text": "Course Contents", "handler": function() {Lino.courses.CourseContents.grid.run(null)} } ] }, "text": "Courses" }, { "menu": { "items": [ { "text": "Brokers", "handler": function() {Lino.newcomers.Brokers.grid.run(null)} }, { "text": "Faculties", "handler": function() {Lino.newcomers.Faculties.grid.run(null)} } ] }, "text": "Newcomers" }, { "menu": { "items": [ { "text": "Sectors", "handler": function() {Lino.cbss.Sectors.grid.run(null)} }, { "text": "Purposes", "handler": function() {Lino.cbss.Purposes.grid.run(null)} } ] }, "text": "CBSS" } ] }, "text": "Configure" }, { "menu": { "items": [ { "menu": { "items": [ { "text": "Text Field Templates", "handler": function() {Lino.system.TextFieldTemplates.grid.run(null)} }, { "text": "Uploads", "handler": function() {Lino.uploads.Uploads.grid.run(null)} }, { "text": "Outgoing Mails", "handler": function() {Lino.outbox.Mails.grid.run(null)} }, { "text": "Attachments", "handler": function() {Lino.outbox.Attachments.grid.run(null)} }, { "text": "Events/Notes", "handler": function() {Lino.notes.Notes.grid.run(null)} } ] }, "text": "Office" }, { "menu": { "items": [ { "text": "Authorities", "handler": function() {Lino.users.Authorities.grid.run(null)} }, { "text": "User Groups", "handler": function() {Lino.lino.UserGroups.grid.run(null)} }, { "text": "User Levels", "handler": function() {Lino.lino.UserLevels.grid.run(null)} }, { "text": "User Profiles", "handler": function() {Lino.lino.UserProfiles.grid.run(null)} }, { "text": "Changes", "handler": function() {Lino.changes.Changes.grid.run(null)} } ] }, "text": "System" }, { "menu": { "items": [ { "text": "Contact Persons", "handler": function() {Lino.contacts.Roles.grid.run(null)} } ] }, "text": "Contacts" }, { "menu": { "items": [ { "text": "Tasks", "listeners": { "render": Lino.quicktip_renderer("Foo","A calendar task is something you need to do.\n    ") }, "handler": function() {Lino.cal.Tasks.grid.run(null)} }, { "text": "Guests", "listeners": { "render": Lino.quicktip_renderer("Foo","A guest is a partner invited to an event.\n    ") }, "handler": function() {Lino.cal.Guests.grid.run(null)} }, { "text": "Subscriptions", "handler": function() {Lino.cal.Subscriptions.grid.run(null)} }, { "text": "Event states", "listeners": { "render": Lino.quicktip_renderer("Foo","The possible states of a calendar event.") }, "handler": function() {Lino.cal.EventStates.grid.run(null)} }, { "text": "Guest states", "handler": function() {Lino.cal.GuestStates.grid.run(null)} }, { "text": "Task states", "handler": function() {Lino.cal.TaskStates.grid.run(null)} } ] }, "text": "Calendar" }, { "menu": { "items": [ { "text": "Household Members", "handler": function() {Lino.households.Members.grid.run(null)} } ] }, "text": "Households" }, { "menu": { "items": [ { "text": "Coachings", "listeners": { "render": Lino.quicktip_renderer("Foo","Liste des accompagnements.") }, "handler": function() {Lino.pcsw.Coachings.grid.run(null)} }, { "text": "Client Contacts", "listeners": { "render": Lino.quicktip_renderer("Foo","Liste des contacts clients.") }, "handler": function() {Lino.pcsw.ClientContacts.grid.run(null)} }, { "text": "exclusions", "listeners": { "render": Lino.quicktip_renderer("Foo","Liste des exclusions.") }, "handler": function() {Lino.pcsw.Exclusions.grid.run(null)} }, { "text": "Clients", "handler": function() {Lino.pcsw.AllClients.grid.run(null)} }, { "text": "Civil states", "handler": function() {Lino.pcsw.CivilState.grid.run(null)} }, { "text": "Client states", "handler": function() {Lino.pcsw.ClientStates.grid.run(null)} }, { "text": "eID card types", "handler": function() {Lino.lino.BeIdCardTypes.grid.run(null)} } ] }, "text": "PCSW" }, { "menu": { "items": [ { "text": "language knowledges", "handler": function() {Lino.cv.LanguageKnowledges.grid.run(null)} } ] }, "text": "CV" }, { "menu": { "items": [ { "text": "ISIPs", "handler": function() {Lino.isip.Contracts.grid.run(null)} }, { "text": "Art.60\u00a77 contracts", "handler": function() {Lino.jobs.Contracts.grid.run(null)} }, { "text": "Job Candidatures", "handler": function() {Lino.jobs.Candidatures.grid.run(null)} }, { "text": "Studies & education", "handler": function() {Lino.jobs.Studies.grid.run(null)} } ] }, "text": "Integration" }, { "menu": { "items": [ { "text": "Courses", "handler": function() {Lino.courses.Courses.grid.run(null)} }, { "text": "Course Requests", "handler": function() {Lino.courses.CourseRequests.grid.run(null)} } ] }, "text": "Courses" }, { "text": "Competences", "handler": function() {Lino.newcomers.Competences.grid.run(null)} }, { "menu": { "items": [ { "text": "Budgets", "handler": function() {Lino.debts.Budgets.grid.run(null)} }, { "text": "Budget Entries", "handler": function() {Lino.debts.Entries.grid.run(null)} } ] }, "text": "Debts mediation" }, { "menu": { "items": [ { "text": "IdentifyPerson Requests", "handler": function() {Lino.cbss.IdentifyPersonRequests.grid.run(null)} }, { "text": "ManageAccess Requests", "handler": function() {Lino.cbss.ManageAccessRequests.grid.run(null)} }, { "text": "Tx25 Requests", "handler": function() {Lino.cbss.RetrieveTIGroupsRequests.grid.run(null)} } ] }, "text": "CBSS" }, { "text": "Properties", "handler": function() {Lino.properties.Properties.grid.run(null)} } ] }, "text": "Explorer" }, { "menu": { "items": [ { "text": "About", "listeners": { "render": Lino.quicktip_renderer("Foo","Show information about this site.") }, "handler": function() {Lino.about.About.show.run(null,{ "record_id": -99998 })} } ] }, "text": "Site" }, { "text": "Home", "handler": function() {Lino.close_all_windows()} } ];
Ext.namespace('Lino.system.SiteConfigs')
Ext.namespace('Lino.system.ContentTypes')
Ext.namespace('Lino.system.HelpTexts')
Ext.namespace('Lino.system.TextFieldTemplates')
Ext.namespace('Lino.users.Users')
Ext.namespace('Lino.users.MySettings')
Ext.namespace('Lino.users.UsersOverview')
Ext.namespace('Lino.users.Teams')
Ext.namespace('Lino.users.Memberships')
Ext.namespace('Lino.users.Authorities')
Ext.namespace('Lino.changes.Changes')
Ext.namespace('Lino.countries.Countries')
Ext.namespace('Lino.countries.Cities')
Ext.namespace('Lino.properties.PropGroups')
Ext.namespace('Lino.properties.PropTypes')
Ext.namespace('Lino.properties.Properties')
Ext.namespace('Lino.properties.PropChoices')
Ext.namespace('Lino.contacts.CompanyTypes')
Ext.namespace('Lino.contacts.Partners')
Ext.namespace('Lino.contacts.Companies')
Ext.namespace('Lino.contacts.RoleTypes')
Ext.namespace('Lino.contacts.Roles')
Ext.namespace('Lino.contacts.Persons')
Ext.namespace('Lino.outbox.Recipients')
Ext.namespace('Lino.outbox.Mails')
Ext.namespace('Lino.outbox.Attachments')
Ext.namespace('Lino.cal.Calendars')
Ext.namespace('Lino.cal.Subscriptions')
Ext.namespace('Lino.cal.Rooms')
Ext.namespace('Lino.cal.Priorities')
Ext.namespace('Lino.cal.Events')
Ext.namespace('Lino.cal.OneEvent')
Ext.namespace('Lino.cal.MyEvents')
Ext.namespace('Lino.cal.MyAssignedEvents')
Ext.namespace('Lino.cal.Tasks')
Ext.namespace('Lino.cal.MyTasks')
Ext.namespace('Lino.cal.GuestRoles')
Ext.namespace('Lino.cal.Guests')
Ext.namespace('Lino.cal.MyPresences')
Ext.namespace('Lino.cal.MyPendingPresences')
Ext.namespace('Lino.cal.MyGuests')
Ext.namespace('Lino.cal.PanelCalendars')
Ext.namespace('Lino.cal.PanelEvents')
Ext.namespace('Lino.uploads.UploadTypes')
Ext.namespace('Lino.uploads.Uploads')
Ext.namespace('Lino.households.Types')
Ext.namespace('Lino.households.Households')
Ext.namespace('Lino.households.Roles')
Ext.namespace('Lino.households.Members')
Ext.namespace('Lino.reception.ExpectedGuests')
Ext.namespace('Lino.reception.BusyVisitors')
Ext.namespace('Lino.reception.WaitingVisitors')
Ext.namespace('Lino.reception.GoneVisitors')
Ext.namespace('Lino.reception.MyWaitingVisitors')
Ext.namespace('Lino.reception.MyBusyVisitors')
Ext.namespace('Lino.reception.MyGoneVisitors')
Ext.namespace('Lino.notes.NoteTypes')
Ext.namespace('Lino.notes.EventTypes')
Ext.namespace('Lino.notes.Notes')
Ext.namespace('Lino.cv.LanguageKnowledges')
Ext.namespace('Lino.cv.PersonProperties')
Ext.namespace('Lino.isip.ContractTypes')
Ext.namespace('Lino.isip.ExamPolicies')
Ext.namespace('Lino.isip.ContractEndings')
Ext.namespace('Lino.isip.StudyTypes')
Ext.namespace('Lino.isip.Contracts')
Ext.namespace('Lino.isip.MyContracts')
Ext.namespace('Lino.jobs.Schedules')
Ext.namespace('Lino.jobs.Regimes')
Ext.namespace('Lino.jobs.JobProviders')
Ext.namespace('Lino.jobs.ContractTypes')
Ext.namespace('Lino.jobs.Sectors')
Ext.namespace('Lino.jobs.Functions')
Ext.namespace('Lino.jobs.Contracts')
Ext.namespace('Lino.jobs.MyContracts')
Ext.namespace('Lino.jobs.Offers')
Ext.namespace('Lino.jobs.Studies')
Ext.namespace('Lino.jobs.Experiences')
Ext.namespace('Lino.jobs.Candidatures')
Ext.namespace('Lino.jobs.Jobs')
Ext.namespace('Lino.jobs.JobTypes')
Ext.namespace('Lino.jobs.ContractsSearch')
Ext.namespace('Lino.pcsw.Clients')
Ext.namespace('Lino.pcsw.DebtsClients')
Ext.namespace('Lino.pcsw.AllClients')
Ext.namespace('Lino.pcsw.ClientsTest')
Ext.namespace('Lino.pcsw.PersonGroups')
Ext.namespace('Lino.pcsw.Activities')
Ext.namespace('Lino.pcsw.DispenseReasons')
Ext.namespace('Lino.pcsw.Dispenses')
Ext.namespace('Lino.pcsw.ExclusionTypes')
Ext.namespace('Lino.pcsw.Exclusions')
Ext.namespace('Lino.pcsw.AidTypes')
Ext.namespace('Lino.pcsw.ClientContactTypes')
Ext.namespace('Lino.pcsw.ClientContacts')
Ext.namespace('Lino.pcsw.CoachingTypes')
Ext.namespace('Lino.pcsw.CoachingEndings')
Ext.namespace('Lino.pcsw.Coachings')
Ext.namespace('Lino.reception.Clients')
Ext.namespace('Lino.languages.Languages')
Ext.namespace('Lino.accounts.Charts')
Ext.namespace('Lino.accounts.Groups')
Ext.namespace('Lino.accounts.Accounts')
Ext.namespace('Lino.courses.CourseProviders')
Ext.namespace('Lino.courses.CourseContents')
Ext.namespace('Lino.courses.Courses')
Ext.namespace('Lino.courses.CourseOffers')
Ext.namespace('Lino.courses.CourseRequests')
Ext.namespace('Lino.courses.PendingCourseRequests')
Ext.namespace('Lino.integ.Clients')
Ext.namespace('Lino.integ.CoachingEndingsByUser')
Ext.namespace('Lino.integ.CoachingEndingsByType')
Ext.namespace('Lino.integ.ContractEndingsByType')
Ext.namespace('Lino.integ.JobsContractEndingsByType')
Ext.namespace('Lino.integ.ContractsPerUserAndContractType')
Ext.namespace('Lino.integ.JobsContractsPerUserAndContractType')
Ext.namespace('Lino.integ.StudyTypesAndContracts')
Ext.namespace('Lino.integ.CompaniesAndContracts')
Ext.namespace('Lino.integ.JobProvidersAndContracts')
Ext.namespace('Lino.newcomers.Brokers')
Ext.namespace('Lino.newcomers.Faculties')
Ext.namespace('Lino.newcomers.Competences')
Ext.namespace('Lino.newcomers.NewClients')
Ext.namespace('Lino.newcomers.AvailableCoaches')
Ext.namespace('Lino.debts.Budgets')
Ext.namespace('Lino.debts.Actors')
Ext.namespace('Lino.debts.Entries')
Ext.namespace('Lino.debts.EntriesByType')
Ext.namespace('Lino.cbss.Sectors')
Ext.namespace('Lino.cbss.Purposes')
Ext.namespace('Lino.cbss.IdentifyPersonRequests')
Ext.namespace('Lino.cbss.ManageAccessRequests')
Ext.namespace('Lino.cbss.RetrieveTIGroupsRequests')
Ext.namespace('Lino.sessions.SessionTable')
Ext.namespace('Lino.system.MyTextFieldTemplates')
Ext.namespace('Lino.users.MembershipsByUser')
Ext.namespace('Lino.users.AuthoritiesGiven')
Ext.namespace('Lino.users.AuthoritiesTaken')
Ext.namespace('Lino.countries.CitiesByCity')
Ext.namespace('Lino.countries.CitiesByCountry')
Ext.namespace('Lino.properties.PropsByGroup')
Ext.namespace('Lino.properties.PropsByType')
Ext.namespace('Lino.properties.ChoicesByType')
Ext.namespace('Lino.contacts.PartnersByCity')
Ext.namespace('Lino.contacts.PartnersByCountry')
Ext.namespace('Lino.contacts.RolesByCompany')
Ext.namespace('Lino.contacts.RolesByPerson')
Ext.namespace('Lino.outbox.RecipientsByMail')
Ext.namespace('Lino.outbox.MyOutbox')
Ext.namespace('Lino.outbox.MailsByUser')
Ext.namespace('Lino.outbox.MailsByProject')
Ext.namespace('Lino.outbox.SentByPartner')
Ext.namespace('Lino.outbox.AttachmentsByMail')
Ext.namespace('Lino.cal.SubscriptionsByCalendar')
Ext.namespace('Lino.cal.SubscriptionsByUser')
Ext.namespace('Lino.cal.EventsByCalendar')
Ext.namespace('Lino.cal.EventsByRoom')
Ext.namespace('Lino.cal.EventsByProject')
Ext.namespace('Lino.cal.TasksByUser')
Ext.namespace('Lino.cal.TasksByProject')
Ext.namespace('Lino.cal.GuestsByEvent')
Ext.namespace('Lino.cal.GuestsByRole')
Ext.namespace('Lino.cal.GuestsByPartner')
Ext.namespace('Lino.uploads.MyUploads')
Ext.namespace('Lino.households.HouseholdsByType')
Ext.namespace('Lino.households.MembersByHousehold')
Ext.namespace('Lino.households.MembersByPerson')
Ext.namespace('Lino.households.MembersByRole')
Ext.namespace('Lino.reception.AppointmentsByPartner')
Ext.namespace('Lino.notes.MyNotes')
Ext.namespace('Lino.notes.NotesByType')
Ext.namespace('Lino.notes.NotesByEventType')
Ext.namespace('Lino.notes.NotesByProject')
Ext.namespace('Lino.cv.LanguageKnowledgesByPerson')
Ext.namespace('Lino.cv.KnowledgesByLanguage')
Ext.namespace('Lino.cv.PropsByPerson')
Ext.namespace('Lino.cv.PersonPropsByProp')
Ext.namespace('Lino.cv.ConfiguredPropsByPerson')
Ext.namespace('Lino.cv.SkillsByPerson')
Ext.namespace('Lino.cv.SoftSkillsByPerson')
Ext.namespace('Lino.cv.ObstaclesByPerson')
Ext.namespace('Lino.isip.ContractsByPerson')
Ext.namespace('Lino.isip.ContractsByPolicy')
Ext.namespace('Lino.isip.ContractsByType')
Ext.namespace('Lino.isip.ContractsByEnding')
Ext.namespace('Lino.isip.ContractsByStudyType')
Ext.namespace('Lino.jobs.FunctionsBySector')
Ext.namespace('Lino.jobs.ContractsByPerson')
Ext.namespace('Lino.jobs.ContractsByProvider')
Ext.namespace('Lino.jobs.ContractsByPolicy')
Ext.namespace('Lino.jobs.ContractsByEnding')
Ext.namespace('Lino.jobs.ContractsByJob')
Ext.namespace('Lino.jobs.ContractsByRegime')
Ext.namespace('Lino.jobs.ContractsBySchedule')
Ext.namespace('Lino.jobs.StudiesByCountry')
Ext.namespace('Lino.jobs.StudiesByCity')
Ext.namespace('Lino.jobs.StudiesByPerson')
Ext.namespace('Lino.jobs.ExperiencesByFunction')
Ext.namespace('Lino.jobs.ExperiencesByPerson')
Ext.namespace('Lino.jobs.CandidaturesByPerson')
Ext.namespace('Lino.jobs.CandidaturesBySector')
Ext.namespace('Lino.jobs.CandidaturesByFunction')
Ext.namespace('Lino.jobs.CandidaturesByJob')
Ext.namespace('Lino.jobs.CandidaturesByOffer')
Ext.namespace('Lino.jobs.ExperiencesByOffer')
Ext.namespace('Lino.jobs.JobsByProvider')
Ext.namespace('Lino.jobs.JobsByType')
Ext.namespace('Lino.jobs.ContractsByType')
Ext.namespace('Lino.jobs.JobsOverviewByType')
Ext.namespace('Lino.pcsw.ClientsByNationality')
Ext.namespace('Lino.pcsw.DispensesByClient')
Ext.namespace('Lino.pcsw.ExclusionsByClient')
Ext.namespace('Lino.pcsw.ContactsByClient')
Ext.namespace('Lino.pcsw.CoachingsByClient')
Ext.namespace('Lino.pcsw.CoachingsByUser')
Ext.namespace('Lino.pcsw.CoachingsByEnding')
Ext.namespace('Lino.pcsw.NotesByPerson')
Ext.namespace('Lino.pcsw.NotesByCompany')
Ext.namespace('Lino.reception.CoachingsByClient')
Ext.namespace('Lino.accounts.GroupsByChart')
Ext.namespace('Lino.accounts.AccountsByGroup')
Ext.namespace('Lino.courses.CoursesByOffer')
Ext.namespace('Lino.courses.CourseOffersByProvider')
Ext.namespace('Lino.courses.CourseOffersByContent')
Ext.namespace('Lino.courses.CourseRequestsByPerson')
Ext.namespace('Lino.courses.CourseRequestsByContent')
Ext.namespace('Lino.courses.RequestsByCourse')
Ext.namespace('Lino.courses.ParticipantsByCourse')
Ext.namespace('Lino.courses.CandidatesByCourse')
Ext.namespace('Lino.newcomers.CompetencesByUser')
Ext.namespace('Lino.newcomers.CompetencesByFaculty')
Ext.namespace('Lino.newcomers.MyCompetences')
Ext.namespace('Lino.newcomers.ClientsByFaculty')
Ext.namespace('Lino.newcomers.AvailableCoachesByClient')
Ext.namespace('Lino.debts.MyBudgets')
Ext.namespace('Lino.debts.BudgetsByPartner')
Ext.namespace('Lino.debts.ActorsByBudget')
Ext.namespace('Lino.debts.ActorsByPartner')
Ext.namespace('Lino.debts.EntriesByBudget')
Ext.namespace('Lino.debts.ExpensesByBudget')
Ext.namespace('Lino.debts.IncomesByBudget')
Ext.namespace('Lino.debts.LiabilitiesByBudget')
Ext.namespace('Lino.debts.AssetsByBudget')
Ext.namespace('Lino.debts.DistByBudget')
Ext.namespace('Lino.cbss.MyIdentifyPersonRequests')
Ext.namespace('Lino.cbss.IdentifyRequestsByPerson')
Ext.namespace('Lino.cbss.ManageAccessRequestsByPerson')
Ext.namespace('Lino.cbss.MyManageAccessRequests')
Ext.namespace('Lino.cbss.RetrieveTIGroupsRequestsByPerson')
Ext.namespace('Lino.cbss.MyRetrieveTIGroupsRequests')
Ext.namespace('Lino.uploads.UploadsByController')
Ext.namespace('Lino.system.HelpTextsByModel')
Ext.namespace('Lino.notes.NotesByOwner')
Ext.namespace('Lino.cal.TasksByController')
Ext.namespace('Lino.outbox.MailsByController')
Ext.namespace('Lino.changes.ChangesByMaster')
Ext.namespace('Lino.outbox.AttachmentsByController')
Ext.namespace('Lino.cal.EventsByController')
Ext.namespace('Lino.about.Models')
Ext.namespace('Lino.about.FieldsByModel')
Ext.namespace('Lino.about.Inspector')
Ext.namespace('Lino.about.SourceFiles')
Ext.namespace('Lino.reception.ButtonsTable')
Ext.namespace('Lino.reception.CreateNoteActionsByClient')
Ext.namespace('Lino.reception.CreateEventActionsByClient')
Ext.namespace('Lino.integ.UsersWithClients')
Ext.namespace('Lino.integ.CompareRequestsTable')
Ext.namespace('Lino.integ.PeriodicNumbers')
Ext.namespace('Lino.debts.PrintEntriesByBudget')
Ext.namespace('Lino.debts.PrintExpensesByBudget')
Ext.namespace('Lino.debts.PrintIncomesByBudget')
Ext.namespace('Lino.debts.PrintLiabilitiesByBudget')
Ext.namespace('Lino.debts.PrintAssetsByBudget')
Ext.namespace('Lino.debts.SummaryTable')
Ext.namespace('Lino.debts.ResultByBudget')
Ext.namespace('Lino.debts.DebtsByBudget')
Ext.namespace('Lino.debts.BailiffDebtsByBudget')
Ext.namespace('Lino.cbss.IdentifyPersonResult')
Ext.namespace('Lino.cbss.RetrieveTIGroupsResult')
Ext.namespace('Lino.lino.Report')
Ext.namespace('Lino.about.About')
Ext.namespace('Lino.system.Home')
Ext.namespace('Lino.cal.CalendarPanel')
Ext.namespace('Lino.jobs.OldJobsOverview')
Ext.namespace('Lino.jobs.JobsOverview')
Ext.namespace('Lino.integ.ActivityReport')
Ext.namespace('Lino.courses.CourseRequestStates')
Ext.namespace('Lino.cal.DurationUnits')
Ext.namespace('Lino.cal.TaskStates')
Ext.namespace('Lino.cal.Weekdays')
Ext.namespace('Lino.lino.UserLevels')
Ext.namespace('Lino.pcsw.CoachingEvents')
Ext.namespace('Lino.lino.YesNo')
Ext.namespace('Lino.cal.EventStates')
Ext.namespace('Lino.lino.BeIdCardTypes')
Ext.namespace('Lino.accounts.AccountTypes')
Ext.namespace('Lino.cal.Recurrencies')
Ext.namespace('Lino.properties.HowWell')
Ext.namespace('Lino.cv.CefLevel')
Ext.namespace('Lino.jobs.CandidatureStates')
Ext.namespace('Lino.outbox.RecipientType')
Ext.namespace('Lino.cal.EventEvents')
Ext.namespace('Lino.cal.GuestStates')
Ext.namespace('Lino.pcsw.CivilState')
Ext.namespace('Lino.pcsw.ClientStates')
Ext.namespace('Lino.countries.CityTypes')
Ext.namespace('Lino.properties.DoYouLike')
Ext.namespace('Lino.cbss.RequestLanguages')
Ext.namespace('Lino.cbss.ManageAction')
Ext.namespace('Lino.pcsw.RefusalReasons')
Ext.namespace('Lino.lino.UserGroups')
Ext.namespace('Lino.cbss.RequestStates')
Ext.namespace('Lino.lino.ChangeTypes')
Ext.namespace('Lino.cal.AccessClasses')
Ext.namespace('Lino.cbss.QueryRegister')
Ext.namespace('Lino.isip.ContractEvents')
Ext.namespace('Lino.lino.Genders')
Ext.namespace('Lino.pcsw.ClientEvents')
Ext.namespace('Lino.lino.UserProfiles')
Ext.namespace('Lino.pcsw.ResidenceType')

// ChoiceLists: 
Lino.courses.CourseRequestStates = [ [ "10", "Open" ], [ "20", "Registered" ], [ "30", "Passed" ], [ "40", "Award" ], [ "50", "Failed" ], [ "60", "Aborted" ], [ "70", "Inactive" ] ];
Lino.cal.DurationUnits = [ [ "s", "seconds" ], [ "m", "minutes" ], [ "h", "hours" ], [ "D", "days" ], [ "W", "weeks" ], [ "M", "months" ], [ "Y", "years" ] ];
Lino.cal.TaskStates = [ [ "10", "To do" ], [ "20", "Started" ], [ "30", "Done" ], [ "50", "Cancelled" ] ];
Lino.cal.Weekdays = [ [ "1", "Monday" ], [ "2", "Tuesday" ], [ "3", "Wednesday" ], [ "4", "Thursday" ], [ "5", "Friday" ], [ "6", "Saturday" ], [ "7", "Sunday" ] ];
Lino.lino.UserLevels = [ [ "10", "Guest" ], [ "30", "User" ], [ "40", "Manager" ], [ "50", "Administrator" ] ];
Lino.pcsw.CoachingEvents = [ [ "10", "Started" ], [ "20", "Active" ], [ "30", "Ended" ] ];
Lino.lino.YesNo = [ [ "y", "Yes" ], [ "n", "No" ] ];
Lino.cal.EventStates = [ [ "10", "Suggested" ], [ "20", "Draft" ], [ "50", "Took place" ], [ "70", "Cancelled" ], [ "40", "Notified" ] ];
Lino.lino.BeIdCardTypes = [ [ "1", "Belgian citizen" ], [ "6", "Kids card (< 12 year)" ], [ "11", "Foreigner card A" ], [ "12", "Foreigner card B" ], [ "13", "Foreigner card C" ], [ "14", "Foreigner card D" ], [ "15", "Foreigner card E" ], [ "16", "Foreigner card E+" ], [ "17", "Foreigner card F" ], [ "18", "Foreigner card F+" ] ];
Lino.accounts.AccountTypes = [ [ "A", "Assets" ], [ "L", "Liabilities" ], [ "I", "Incomes" ], [ "E", "Expenses" ], [ "C", "Capital" ], [ "B", "Bank accounts" ] ];
Lino.cal.Recurrencies = [ [ "D", "daily" ], [ "W", "weekly" ], [ "M", "monthly" ], [ "Y", "yearly" ], [ "P", "per weekday" ] ];
Lino.properties.HowWell = [ [ "0", "not at all" ], [ "1", "a bit" ], [ "2", "moderate" ], [ "3", "quite well" ], [ "4", "very well" ] ];
Lino.cv.CefLevel = [ [ "A1", "A1 (basic language skills)" ], [ "A2", "A2 (basic language skills)" ], [ "A2+", "A2+ (basic language skills)" ], [ "B1", "B1 (independent use of language)" ], [ "B2", "B2 (independent use of language)" ], [ "B2+", "B2+ (independent use of language)" ], [ "C1", "C1 (proficient use of language)" ], [ "C2", "C2 (proficient use of language)" ], [ "C2+", "C2+ (proficient use of language)" ] ];
Lino.jobs.CandidatureStates = [ [ "10", "Active" ], [ "20", "Probation" ], [ "25", "Probation failed" ], [ "27", "Working" ], [ "30", "Inactive" ] ];
Lino.outbox.RecipientType = [ [ "to", "to" ], [ "cc", "cc" ], [ "bcc", "bcc" ] ];
Lino.cal.EventEvents = [ [ "10", "Okay" ], [ "20", "Pending" ] ];
Lino.cal.GuestStates = [ [ "10", "Invited" ], [ "20", "Accepted" ], [ "30", "Rejected" ], [ "40", "Present" ], [ "50", "Absent" ], [ "44", "Waiting" ], [ "45", "Busy" ], [ "46", "Gone" ] ];
Lino.pcsw.CivilState = [ [ "10", "Single" ], [ "13", "Single cohabitating" ], [ "18", "Single with child" ], [ "20", "Married" ], [ "21", "Married (living alone)" ], [ "22", "Married (living with another partner)" ], [ "30", "Widowed" ], [ "33", "Widow cohabitating" ], [ "40", "Divorced" ], [ "50", "Separated" ] ];
Lino.pcsw.ClientStates = [ [ "10", "Newcomer" ], [ "20", "Refused" ], [ "30", "Coached" ], [ "50", "Former" ] ];
Lino.countries.CityTypes = [ [ "10", "Member State" ], [ "11", "Division" ], [ "12", "Region" ], [ "13", "Community" ], [ "14", "Territory" ], [ "20", "County" ], [ "21", "Province" ], [ "22", "Shire" ], [ "23", "Subregion" ], [ "24", "Department" ], [ "25", "Arrondissement" ], [ "26", "Prefecture" ], [ "27", "District" ], [ "28", "Sector" ], [ "50", "City" ], [ "51", "Town" ], [ "52", "Municipality" ], [ "54", "Parish" ], [ "55", "Township" ], [ "56", "Quarter" ], [ "61", "Borough" ], [ "62", "Small borough" ], [ "70", "Village" ] ];
Lino.properties.DoYouLike = [ [ "0", "certainly not" ], [ "1", "rather not" ], [ "2", "normally" ], [ "3", "quite much" ], [ "4", "very much" ] ];
Lino.cbss.RequestLanguages = [ [ "nl", "Dutch" ], [ "fr", "French" ], [ "de", "German" ] ];
Lino.cbss.ManageAction = [ [ "1", "Register" ], [ "2", "Unregister" ], [ "3", "List" ] ];
Lino.pcsw.RefusalReasons = [ [ "10", "Information request (No coaching needed)" ], [ "20", "PCSW is not competent" ], [ "30", "Client did not return" ] ];
Lino.lino.UserGroups = [ [ "office", "office (Office)" ], [ "reception", "reception (Reception)" ], [ "accounting", "accounting (Accounting)" ], [ "integ", "integ (Integration)" ], [ "newcomers", "newcomers (Newcomers)" ], [ "debts", "debts (Debts mediation)" ], [ "cbss", "cbss (CBSS)" ] ];
Lino.cbss.RequestStates = [ [ "10", "Sent" ], [ "20", "Failed" ], [ "25", "Validated" ], [ "30", "OK" ], [ "40", "Warnings" ], [ "50", "Errors" ] ];
Lino.lino.ChangeTypes = [ [ "C", "Create" ], [ "U", "Update" ], [ "D", "Delete" ], [ "R", "Remove child" ], [ "A", "Add child" ], [ "M", "Merge" ] ];
Lino.cal.AccessClasses = [ [ "10", "Private" ], [ "20", "Show busy" ], [ "30", "Public" ] ];
Lino.cbss.QueryRegister = [ [ "1", "Primary" ], [ "2", "Secondary" ], [ "3", "All" ] ];
Lino.isip.ContractEvents = [ [ "10", "Started" ], [ "20", "Active" ], [ "30", "Ended" ], [ "40", "Signed" ] ];
Lino.lino.Genders = [ [ "M", "Male" ], [ "F", "Female" ] ];
Lino.pcsw.ClientEvents = [ [ "10", "Active" ], [ "20", "ISIP" ], [ "21", "Art.60\u00a77 contract" ], [ "22", "Dispense" ], [ "30", "Exclusion" ], [ "40", "Note" ], [ "50", "Created" ], [ "60", "Modified" ] ];
Lino.lino.UserProfiles = [ [ "000", "000 (Anonymous)" ], [ "100", "100 (Integration Agent)" ], [ "110", "110 (Integration Agent (Manager))" ], [ "200", "200 (Newcomers consultant)" ], [ "210", "210 (Reception clerk)" ], [ "300", "300 (Debts consultant)" ], [ "400", "400 (Social agent)" ], [ "900", "900 (Administrator)" ] ];
Lino.pcsw.ResidenceType = [ [ "1", "Registry of citizens" ], [ "2", "Registry of foreigners" ], [ "3", "Waiting for registry" ] ];

Lino.cal.Tasks.ParamsPanel = Ext.extend(Ext.form.FormPanel,{
  autoScroll: false,
  border: false,
  hideCheckBoxLabels: true,
  frame: true,
  bodyBorder: false,
  labelAlign: "top",
  layout: 'form',
  autoHeight: true,
  initComponent : function() {
    var containing_panel = this;
    var start_date283 = new Lino.DateField({ "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Period from</span>", "name": "start_date", "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Periode vom","(cal.Tasks.start_date) Start date of observed period") }, "anchor": "-20" });
    var end_date284 = new Lino.DateField({ "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">until</span>", "name": "end_date", "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("bis","(cal.Tasks.end_date) End date of observed period") }, "anchor": "-20" });
    var user285 = new Lino.TwinCombo({ "preferred_width": 15, "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Managed by</span>", "name": "user", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.users.Users.detail)}, "hiddenName": "userHidden", "listeners": { "render": Lino.quicktip_renderer("Verwaltet durch","(cal.Tasks.user) Only rows managed by this user.") }, "selectOnFocus": true, "emptyText": "Select a User...", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/Tasks/user", "method": "GET" }) }) });
    var state286 = new Lino.ChoicesFieldElement({ "autoHeight": true, "forceSelection": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">State</span>", "name": "state", "hiddenName": "stateHidden", "listeners": { "render": Lino.quicktip_renderer("Zustand","(cal.Tasks.state) Only rows having this state.") }, "selectOnFocus": true, "anchor": "-20", "store": [['','<br>']].concat(Lino.cal.TaskStates) });
    var project287 = new Lino.TwinCombo({ "preferred_width": 20, "autoHeight": true, "fieldLabel": "Client", "name": "project", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.pcsw.Clients.detail)}, "hiddenName": "projectHidden", "listeners": { "render": Lino.quicktip_renderer("Klient","(cal.Tasks.project) ") }, "selectOnFocus": true, "emptyText": "Select a Client...", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/Tasks/project", "method": "GET" }) }) });
    var main_1_panel288 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 144, "hideCheckBoxLabels": true, "items": [ { "flex": 11, "autoHeight": true, "layout": "form", "xtype": "panel", "items": start_date283, "labelAlign": "top" }, { "flex": 11, "autoHeight": true, "layout": "form", "xtype": "panel", "items": end_date284, "labelAlign": "top" }, { "flex": 29, "autoHeight": true, "layout": "form", "xtype": "panel", "items": user285, "labelAlign": "top" }, { "flex": 17, "autoHeight": true, "layout": "form", "xtype": "panel", "items": state286, "labelAlign": "top" }, { "flex": 29, "autoHeight": true, "layout": "form", "xtype": "panel", "items": project287, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    this.items = [ main_1_panel288 ];
    this.fields = [ start_date283, end_date284, user285, state286, project287 ];
    Lino.cal.Tasks.ParamsPanel.superclass.initComponent.call(this);
  }
});


Lino.jobs.JobsOverviewByType.ParamsPanel = Ext.extend(Ext.form.FormPanel,{
  autoHeight: true,
  frame: true,
  layoutConfig: { "align": "stretchmax" },
  hideCheckBoxLabels: true,
  autoScroll: false,
  labelWidth: 162,
  border: false,
  bodyBorder: false,
  labelAlign: "top",
  layout: 'form',
  autoHeight: true,
  initComponent : function() {
    var containing_panel = this;
    var contract_type5096 = new Lino.TwinCombo({ "preferred_width": 20, "autoHeight": true, "fieldLabel": "Job Contract Type", "name": "contract_type", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.jobs.ContractTypes.detail)}, "hiddenName": "contract_typeHidden", "listeners": { "render": Lino.quicktip_renderer("Job Contract Type","(jobs.JobsOverviewByType.contract_type) ") }, "selectOnFocus": true, "emptyText": "Select a Job Contract Type...", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/jobs/JobsOverviewByType/contract_type", "method": "GET" }) }) });
    var date5097 = new Lino.DateField({ "autoHeight": true, "fieldLabel": "Date", "name": "date", "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Date","(jobs.JobsOverviewByType.date) ") }, "anchor": "-20" });
    this.items = [ { "flex": 71, "autoHeight": true, "layout": "form", "xtype": "panel", "items": contract_type5096, "labelAlign": "top" }, { "flex": 28, "autoHeight": true, "layout": "form", "xtype": "panel", "items": date5097, "labelAlign": "top" } ];
    this.fields = [ contract_type5096, date5097 ];
    Lino.jobs.JobsOverviewByType.ParamsPanel.superclass.initComponent.call(this);
  }
});


Lino.isip.Contracts.ParamsPanel = Ext.extend(Ext.form.FormPanel,{
  autoScroll: false,
  autoHeight: true,
  border: false,
  hideCheckBoxLabels: true,
  frame: true,
  bodyBorder: false,
  labelAlign: "top",
  layout: 'form',
  autoHeight: true,
  initComponent : function() {
    var containing_panel = this;
    var user2214 = new Lino.TwinCombo({ "preferred_width": 15, "autoHeight": true, "fieldLabel": "User", "name": "user", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.users.Users.detail)}, "hiddenName": "userHidden", "listeners": { "render": Lino.quicktip_renderer("Benutzer","(isip.Contracts.user) ") }, "selectOnFocus": true, "emptyText": "Select a User...", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/isip/Contracts/user", "method": "GET" }) }) });
    var type2215 = new Lino.TwinCombo({ "preferred_width": 20, "autoHeight": true, "fieldLabel": "ISIP Type", "name": "type", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.isip.ContractTypes.detail)}, "hiddenName": "typeHidden", "listeners": { "render": Lino.quicktip_renderer("VSE-Art","(isip.Contracts.type) ") }, "selectOnFocus": true, "emptyText": "Select a ISIP Type...", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/isip/Contracts/type", "method": "GET" }) }) });
    var start_date2216 = new Lino.DateField({ "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Period from</span>", "name": "start_date", "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Periode vom","(isip.Contracts.start_date) Start date of observed period") }, "anchor": "-20" });
    var end_date2217 = new Lino.DateField({ "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">until</span>", "name": "end_date", "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("bis","(isip.Contracts.end_date) End date of observed period") }, "anchor": "-20" });
    var observed_event2218 = new Lino.ChoicesFieldElement({ "autoHeight": true, "forceSelection": true, "fieldLabel": "Observed event", "name": "observed_event", "hiddenName": "observed_eventHidden", "listeners": { "render": Lino.quicktip_renderer("Beobachtungskriterium","(isip.Contracts.observed_event) ") }, "selectOnFocus": true, "anchor": "-20", "store": [['','<br>']].concat(Lino.isip.ContractEvents) });
    var main_1_panel2219 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 30, "autoHeight": true, "layout": "form", "xtype": "panel", "items": user2214, "labelAlign": "top" }, { "flex": 30, "autoHeight": true, "layout": "form", "xtype": "panel", "items": type2215, "labelAlign": "top" }, { "flex": 12, "autoHeight": true, "layout": "form", "xtype": "panel", "items": start_date2216, "labelAlign": "top" }, { "flex": 12, "autoHeight": true, "layout": "form", "xtype": "panel", "items": end_date2217, "labelAlign": "top" }, { "flex": 15, "autoHeight": true, "layout": "form", "xtype": "panel", "items": observed_event2218, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 198, "border": false, "anchor": "-20", "labelAlign": "top" });
    var company2225 = new Lino.TwinCombo({ "preferred_width": 20, "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Company</span>", "name": "company", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.contacts.Companies.detail)}, "hiddenName": "companyHidden", "listeners": { "render": Lino.quicktip_renderer("Organisation","(isip.Contracts.company) Nur Konventionen mit dieser Organisation als Drittpartner.") }, "selectOnFocus": true, "emptyText": "Select a Company...", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/isip/Contracts/company", "method": "GET" }) }) });
    var study_type2226 = new Lino.TwinCombo({ "autoHeight": true, "fieldLabel": "study type", "name": "study_type", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.isip.StudyTypes.detail)}, "emptyText": "Select a study type...", "listeners": { "render": Lino.quicktip_renderer("Ausbildungsart","(isip.Contracts.study_type) ") }, "selectOnFocus": true, "hiddenName": "study_typeHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/isip/Contracts/study_type", "method": "GET" }) }) });
    var ending_success2227 = new Lino.ChoicesFieldElement({ "autoHeight": true, "forceSelection": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Successfully ended</span>", "name": "ending_success", "hiddenName": "ending_successHidden", "listeners": { "render": Lino.quicktip_renderer("Erfolgreich abgeschlossen","(isip.Contracts.ending_success) Contrats termin\u00e9s avec succ\u00e8s.") }, "selectOnFocus": true, "anchor": "-20", "store": [['','<br>']].concat(Lino.lino.YesNo) });
    var ending2228 = new Lino.TwinCombo({ "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Reason of termination</span>", "name": "ending", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.isip.ContractEndings.detail)}, "emptyText": "Select a Reason of termination...", "listeners": { "render": Lino.quicktip_renderer("Beendigungsgrund","(isip.Contracts.ending) Nur Konventionen mit diesem Beendigungsgrund.") }, "selectOnFocus": true, "hiddenName": "endingHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/isip/Contracts/ending", "method": "GET" }) }) });
    var main_2_panel2229 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 26, "autoHeight": true, "layout": "form", "xtype": "panel", "items": company2225, "labelAlign": "top" }, { "flex": 20, "autoHeight": true, "layout": "form", "xtype": "panel", "items": study_type2226, "labelAlign": "top" }, { "flex": 26, "autoHeight": true, "layout": "form", "xtype": "panel", "items": ending_success2227, "labelAlign": "top" }, { "flex": 26, "autoHeight": true, "layout": "form", "xtype": "panel", "items": ending2228, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 234, "border": false, "anchor": "-20", "labelAlign": "top" });
    this.items = [ main_1_panel2219, main_2_panel2229 ];
    this.fields = [ user2214, type2215, start_date2216, end_date2217, observed_event2218, company2225, study_type2226, ending_success2227, ending2228 ];
    Lino.isip.Contracts.ParamsPanel.superclass.initComponent.call(this);
  }
});


Lino.jobs.JobsOverview.ParamsPanel = Ext.extend(Ext.form.FormPanel,{
  autoHeight: true,
  frame: true,
  layoutConfig: { "align": "stretchmax" },
  hideCheckBoxLabels: true,
  autoScroll: false,
  labelWidth: 99,
  border: false,
  bodyBorder: false,
  labelAlign: "top",
  layout: 'form',
  autoHeight: true,
  initComponent : function() {
    var containing_panel = this;
    var job_type2878 = new Lino.TwinCombo({ "autoHeight": true, "fieldLabel": "Job Type", "name": "job_type", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.jobs.JobTypes.detail)}, "emptyText": "Select a Job Type...", "listeners": { "render": Lino.quicktip_renderer("Stellenart","(jobs.JobsOverview.job_type) ") }, "selectOnFocus": true, "hiddenName": "job_typeHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/jobs/JobsOverview/job_type", "method": "GET" }) }) });
    var today2879 = new Lino.DateField({ "autoHeight": true, "fieldLabel": "Date", "name": "today", "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Datum","(jobs.JobsOverview.today) ") }, "anchor": "-20" });
    this.items = [ { "flex": 71, "autoHeight": true, "layout": "form", "xtype": "panel", "items": job_type2878, "labelAlign": "top" }, { "flex": 28, "autoHeight": true, "layout": "form", "xtype": "panel", "items": today2879, "labelAlign": "top" } ];
    this.fields = [ job_type2878, today2879 ];
    Lino.jobs.JobsOverview.ParamsPanel.superclass.initComponent.call(this);
  }
});


Lino.pcsw.Clients.ParamsPanel = Ext.extend(Ext.form.FormPanel,{
  autoScroll: false,
  autoHeight: true,
  border: false,
  hideCheckBoxLabels: true,
  frame: true,
  bodyBorder: false,
  labelAlign: "top",
  layout: 'form',
  autoHeight: true,
  initComponent : function() {
    var containing_panel = this;
    var aged_from70 = new Ext.form.NumberField({ "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Aged from</span>", "name": "aged_from", "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Alter von","(pcsw.Clients.aged_from) Nur Klienten, die mindestens so alt sind.") }, "anchor": "-20" });
    var aged_to71 = new Ext.form.NumberField({ "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Aged to</span>", "name": "aged_to", "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Alter bis","(pcsw.Clients.aged_to) Nur Klienten, die h\u00f6chstens so alt sind.") }, "anchor": "-20" });
    var gender72 = new Lino.ChoicesFieldElement({ "autoHeight": true, "forceSelection": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Gender</span>", "name": "gender", "hiddenName": "genderHidden", "listeners": { "render": Lino.quicktip_renderer("Geschlecht","(pcsw.Clients.gender) Nur Personen, deren Feld \"Geschlecht\" ausgef\u00fcllt ist und dem angegebenen Wert entspricht.") }, "selectOnFocus": true, "anchor": "-20", "store": [['','<br>']].concat(Lino.lino.Genders) });
    var nationality73 = new Lino.TwinCombo({ "autoHeight": true, "fieldLabel": "Nationality", "name": "nationality", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.countries.Countries.detail)}, "emptyText": "Select a Country...", "listeners": { "render": Lino.quicktip_renderer("Staatsangeh\u00f6rigkeit","(pcsw.Clients.nationality) ") }, "selectOnFocus": true, "hiddenName": "nationalityHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/pcsw/Clients/nationality", "method": "GET" }) }) });
    var also_obsolete74 = new Ext.form.Checkbox({ "autoHeight": true, "hideLabel": true, "checked": false, "name": "also_obsolete", "listeners": { "render": Lino.quicktip_renderer("Auch veraltete Daten","(pcsw.Clients.also_obsolete) Auch Datens\u00e4tze anzeigen, die als veraltet markiert sind.") }, "boxLabel": "Also obsolete data", "selectOnFocus": true, "anchor": "-20" });
    var main_1_panel75 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 10, "autoHeight": true, "layout": "form", "xtype": "panel", "items": aged_from70, "labelAlign": "top" }, { "flex": 10, "autoHeight": true, "layout": "form", "xtype": "panel", "items": aged_to71, "labelAlign": "top" }, { "flex": 18, "autoHeight": true, "layout": "form", "xtype": "panel", "items": gender72, "labelAlign": "top" }, { "flex": 40, "autoHeight": true, "layout": "form", "xtype": "panel", "items": nationality73, "labelAlign": "top" }, { "flex": 20, "autoHeight": true, "layout": "form", "xtype": "panel", "items": also_obsolete74, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 189, "border": false, "anchor": "-20", "labelAlign": "top" });
    var client_state81 = new Lino.ChoicesFieldElement({ "autoHeight": true, "forceSelection": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">State</span>", "name": "client_state", "hiddenName": "client_stateHidden", "listeners": { "render": Lino.quicktip_renderer("Zustand","(pcsw.Clients.client_state) Nur Klienten mit diesem Status (Aktenzustand).") }, "selectOnFocus": true, "anchor": "-20", "store": [['','<br>']].concat(Lino.pcsw.ClientStates) });
    var coached_by82 = new Lino.TwinCombo({ "preferred_width": 15, "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Coached by</span>", "name": "coached_by", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.users.Users.detail)}, "hiddenName": "coached_byHidden", "listeners": { "render": Lino.quicktip_renderer("Begleitet durch","(pcsw.Clients.coached_by) Nur Klienten, die eine Begleitung mit diesem Benutzer haben.") }, "selectOnFocus": true, "emptyText": "Select a User...", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/pcsw/Clients/coached_by", "method": "GET" }) }) });
    var and_coached_by83 = new Lino.TwinCombo({ "preferred_width": 15, "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">and by</span>", "name": "and_coached_by", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.users.Users.detail)}, "hiddenName": "and_coached_byHidden", "listeners": { "render": Lino.quicktip_renderer("und durch","(pcsw.Clients.and_coached_by) Nur Klienten, die auch mit diesem Benutzer eine Begleitung haben.") }, "selectOnFocus": true, "emptyText": "Select a User...", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/pcsw/Clients/and_coached_by", "method": "GET" }) }) });
    var start_date84 = new Lino.DateField({ "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Period from</span>", "name": "start_date", "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Periode vom","(pcsw.Clients.start_date) Start date of observed period") }, "anchor": "-20" });
    var end_date85 = new Lino.DateField({ "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">until</span>", "name": "end_date", "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("bis","(pcsw.Clients.end_date) End date of observed period") }, "anchor": "-20" });
    var observed_event86 = new Lino.ChoicesFieldElement({ "autoHeight": true, "forceSelection": true, "fieldLabel": "Observed event", "name": "observed_event", "hiddenName": "observed_eventHidden", "listeners": { "render": Lino.quicktip_renderer("Beobachtungskriterium","(pcsw.Clients.observed_event) ") }, "selectOnFocus": true, "anchor": "-20", "store": [['','<br>']].concat(Lino.pcsw.ClientEvents) });
    var only_primary87 = new Ext.form.Checkbox({ "autoHeight": true, "hideLabel": true, "checked": false, "name": "only_primary", "listeners": { "render": Lino.quicktip_renderer("Nur prim\u00e4re Begleitungen","(pcsw.Clients.only_primary) Nur Klienten, die eine effektive <b>prim\u00e4re</b> Begleitung haben.") }, "boxLabel": "Only primary clients", "selectOnFocus": true, "anchor": "-20" });
    var main_2_panel88 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 11, "autoHeight": true, "layout": "form", "xtype": "panel", "items": client_state81, "labelAlign": "top" }, { "flex": 20, "autoHeight": true, "layout": "form", "xtype": "panel", "items": coached_by82, "labelAlign": "top" }, { "flex": 20, "autoHeight": true, "layout": "form", "xtype": "panel", "items": and_coached_by83, "labelAlign": "top" }, { "flex": 8, "autoHeight": true, "layout": "form", "xtype": "panel", "items": start_date84, "labelAlign": "top" }, { "flex": 8, "autoHeight": true, "layout": "form", "xtype": "panel", "items": end_date85, "labelAlign": "top" }, { "flex": 20, "autoHeight": true, "layout": "form", "xtype": "panel", "items": observed_event86, "labelAlign": "top" }, { "flex": 10, "autoHeight": true, "layout": "form", "xtype": "panel", "items": only_primary87, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 225, "border": false, "anchor": "-20", "labelAlign": "top" });
    this.items = [ main_1_panel75, main_2_panel88 ];
    this.fields = [ aged_from70, aged_to71, gender72, nationality73, also_obsolete74, client_state81, coached_by82, and_coached_by83, start_date84, end_date85, observed_event86, only_primary87 ];
    Lino.pcsw.Clients.ParamsPanel.superclass.initComponent.call(this);
  }
});


Lino.newcomers.AvailableCoaches.ParamsPanel = Ext.extend(Ext.form.FormPanel,{
  autoHeight: true,
  frame: true,
  layoutConfig: { "align": "stretchmax" },
  hideCheckBoxLabels: true,
  autoScroll: false,
  labelWidth: 189,
  border: false,
  bodyBorder: false,
  labelAlign: "top",
  layout: 'form',
  autoHeight: true,
  initComponent : function() {
    var containing_panel = this;
    var for_client1982 = new Lino.TwinCombo({ "preferred_width": 20, "autoHeight": true, "fieldLabel": "Show suggested agents for", "name": "for_client", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.pcsw.Clients.detail)}, "hiddenName": "for_clientHidden", "listeners": { "render": Lino.quicktip_renderer("Zeige Vorschl\u00e4ge f\u00fcr","(newcomers.AvailableCoaches.for_client) ") }, "selectOnFocus": true, "emptyText": "Select a Client...", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/newcomers/AvailableCoaches/for_client", "method": "GET" }) }) });
    var since1983 = new Lino.DateField({ "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">New clients since</span>", "name": "since", "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Neue Klienten seit","(newcomers.AvailableCoaches.since) Neue Klienten sind die, deren Begleitung nach diesem Datum beginnt") }, "anchor": "-20" });
    this.items = [ { "flex": 71, "autoHeight": true, "layout": "form", "xtype": "panel", "items": for_client1982, "labelAlign": "top" }, { "flex": 28, "autoHeight": true, "layout": "form", "xtype": "panel", "items": since1983, "labelAlign": "top" } ];
    this.fields = [ for_client1982, since1983 ];
    Lino.newcomers.AvailableCoaches.ParamsPanel.superclass.initComponent.call(this);
  }
});


Lino.jobs.Contracts.ParamsPanel = Ext.extend(Ext.form.FormPanel,{
  autoScroll: false,
  autoHeight: true,
  border: false,
  hideCheckBoxLabels: true,
  frame: true,
  bodyBorder: false,
  labelAlign: "top",
  layout: 'form',
  autoHeight: true,
  initComponent : function() {
    var containing_panel = this;
    var user1333 = new Lino.TwinCombo({ "preferred_width": 15, "autoHeight": true, "fieldLabel": "User", "name": "user", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.users.Users.detail)}, "hiddenName": "userHidden", "listeners": { "render": Lino.quicktip_renderer("Benutzer","(jobs.Contracts.user) ") }, "selectOnFocus": true, "emptyText": "Select a User...", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/jobs/Contracts/user", "method": "GET" }) }) });
    var type1334 = new Lino.TwinCombo({ "preferred_width": 20, "autoHeight": true, "fieldLabel": "Only contracts of type", "name": "type", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.jobs.ContractTypes.detail)}, "hiddenName": "typeHidden", "listeners": { "render": Lino.quicktip_renderer("Vertragsart","(jobs.Contracts.type) ") }, "selectOnFocus": true, "emptyText": "Select a Job Contract Type...", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/jobs/Contracts/type", "method": "GET" }) }) });
    var start_date1335 = new Lino.DateField({ "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Period from</span>", "name": "start_date", "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Periode vom","(jobs.Contracts.start_date) Start date of observed period") }, "anchor": "-20" });
    var end_date1336 = new Lino.DateField({ "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">until</span>", "name": "end_date", "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("bis","(jobs.Contracts.end_date) End date of observed period") }, "anchor": "-20" });
    var observed_event1337 = new Lino.ChoicesFieldElement({ "autoHeight": true, "forceSelection": true, "fieldLabel": "Observed event", "name": "observed_event", "hiddenName": "observed_eventHidden", "listeners": { "render": Lino.quicktip_renderer("Beobachtungskriterium","(jobs.Contracts.observed_event) ") }, "selectOnFocus": true, "anchor": "-20", "store": [['','<br>']].concat(Lino.isip.ContractEvents) });
    var main_1_panel1338 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 30, "autoHeight": true, "layout": "form", "xtype": "panel", "items": user1333, "labelAlign": "top" }, { "flex": 30, "autoHeight": true, "layout": "form", "xtype": "panel", "items": type1334, "labelAlign": "top" }, { "flex": 12, "autoHeight": true, "layout": "form", "xtype": "panel", "items": start_date1335, "labelAlign": "top" }, { "flex": 12, "autoHeight": true, "layout": "form", "xtype": "panel", "items": end_date1336, "labelAlign": "top" }, { "flex": 15, "autoHeight": true, "layout": "form", "xtype": "panel", "items": observed_event1337, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 198, "border": false, "anchor": "-20", "labelAlign": "top" });
    var company1344 = new Lino.TwinCombo({ "preferred_width": 20, "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Company</span>", "name": "company", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.contacts.Companies.detail)}, "hiddenName": "companyHidden", "listeners": { "render": Lino.quicktip_renderer("Organisation","(jobs.Contracts.company) Nur Konventionen mit dieser Organisation als Drittpartner.") }, "selectOnFocus": true, "emptyText": "Select a Company...", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/jobs/Contracts/company", "method": "GET" }) }) });
    var ending_success1345 = new Lino.ChoicesFieldElement({ "autoHeight": true, "forceSelection": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Successfully ended</span>", "name": "ending_success", "hiddenName": "ending_successHidden", "listeners": { "render": Lino.quicktip_renderer("Erfolgreich abgeschlossen","(jobs.Contracts.ending_success) Contrats termin\u00e9s avec succ\u00e8s.") }, "selectOnFocus": true, "anchor": "-20", "store": [['','<br>']].concat(Lino.lino.YesNo) });
    var ending1346 = new Lino.TwinCombo({ "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Reason of termination</span>", "name": "ending", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.isip.ContractEndings.detail)}, "emptyText": "Select a Reason of termination...", "listeners": { "render": Lino.quicktip_renderer("Beendigungsgrund","(jobs.Contracts.ending) Nur Konventionen mit diesem Beendigungsgrund.") }, "selectOnFocus": true, "hiddenName": "endingHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/jobs/Contracts/ending", "method": "GET" }) }) });
    var main_2_panel1347 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 42, "autoHeight": true, "layout": "form", "xtype": "panel", "items": company1344, "labelAlign": "top" }, { "flex": 14, "autoHeight": true, "layout": "form", "xtype": "panel", "items": ending_success1345, "labelAlign": "top" }, { "flex": 42, "autoHeight": true, "layout": "form", "xtype": "panel", "items": ending1346, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 234, "border": false, "anchor": "-20", "labelAlign": "top" });
    this.items = [ main_1_panel1338, main_2_panel1347 ];
    this.fields = [ user1333, type1334, start_date1335, end_date1336, observed_event1337, company1344, ending_success1345, ending1346 ];
    Lino.jobs.Contracts.ParamsPanel.superclass.initComponent.call(this);
  }
});


Lino.pcsw.ClientsTest.ParamsPanel = Ext.extend(Ext.form.FormPanel,{
  autoScroll: false,
  autoHeight: true,
  border: false,
  hideCheckBoxLabels: true,
  frame: true,
  bodyBorder: false,
  labelAlign: "top",
  layout: 'form',
  autoHeight: true,
  initComponent : function() {
    var containing_panel = this;
    var aged_from2846 = new Ext.form.NumberField({ "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Aged from</span>", "name": "aged_from", "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Alter von","(pcsw.ClientsTest.aged_from) Nur Klienten, die mindestens so alt sind.") }, "anchor": "-20" });
    var aged_to2847 = new Ext.form.NumberField({ "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Aged to</span>", "name": "aged_to", "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Alter bis","(pcsw.ClientsTest.aged_to) Nur Klienten, die h\u00f6chstens so alt sind.") }, "anchor": "-20" });
    var gender2848 = new Lino.ChoicesFieldElement({ "autoHeight": true, "forceSelection": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Gender</span>", "name": "gender", "hiddenName": "genderHidden", "listeners": { "render": Lino.quicktip_renderer("Geschlecht","(pcsw.ClientsTest.gender) Nur Personen, deren Feld \"Geschlecht\" ausgef\u00fcllt ist und dem angegebenen Wert entspricht.") }, "selectOnFocus": true, "anchor": "-20", "store": [['','<br>']].concat(Lino.lino.Genders) });
    var also_obsolete2849 = new Ext.form.Checkbox({ "autoHeight": true, "hideLabel": true, "checked": false, "name": "also_obsolete", "listeners": { "render": Lino.quicktip_renderer("Auch veraltete Daten","(pcsw.ClientsTest.also_obsolete) Auch Datens\u00e4tze anzeigen, die als veraltet markiert sind.") }, "boxLabel": "Also obsolete data", "selectOnFocus": true, "anchor": "-20" });
    var main_1_panel2850 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 17, "autoHeight": true, "layout": "form", "xtype": "panel", "items": aged_from2846, "labelAlign": "top" }, { "flex": 17, "autoHeight": true, "layout": "form", "xtype": "panel", "items": aged_to2847, "labelAlign": "top" }, { "flex": 31, "autoHeight": true, "layout": "form", "xtype": "panel", "items": gender2848, "labelAlign": "top" }, { "flex": 34, "autoHeight": true, "layout": "form", "xtype": "panel", "items": also_obsolete2849, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 189, "border": false, "anchor": "-20", "labelAlign": "top" });
    var client_state2855 = new Lino.ChoicesFieldElement({ "autoHeight": true, "forceSelection": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">State</span>", "name": "client_state", "hiddenName": "client_stateHidden", "listeners": { "render": Lino.quicktip_renderer("Zustand","(pcsw.ClientsTest.client_state) Nur Klienten mit diesem Status (Aktenzustand).") }, "selectOnFocus": true, "anchor": "-20", "store": [['','<br>']].concat(Lino.pcsw.ClientStates) });
    var coached_by2856 = new Lino.TwinCombo({ "preferred_width": 15, "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Coached by</span>", "name": "coached_by", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.users.Users.detail)}, "hiddenName": "coached_byHidden", "listeners": { "render": Lino.quicktip_renderer("Begleitet durch","(pcsw.ClientsTest.coached_by) Nur Klienten, die eine Begleitung mit diesem Benutzer haben.") }, "selectOnFocus": true, "emptyText": "Select a User...", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/pcsw/ClientsTest/coached_by", "method": "GET" }) }) });
    var and_coached_by2857 = new Lino.TwinCombo({ "preferred_width": 15, "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">and by</span>", "name": "and_coached_by", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.users.Users.detail)}, "hiddenName": "and_coached_byHidden", "listeners": { "render": Lino.quicktip_renderer("und durch","(pcsw.ClientsTest.and_coached_by) Nur Klienten, die auch mit diesem Benutzer eine Begleitung haben.") }, "selectOnFocus": true, "emptyText": "Select a User...", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/pcsw/ClientsTest/and_coached_by", "method": "GET" }) }) });
    var start_date2858 = new Lino.DateField({ "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Period from</span>", "name": "start_date", "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Periode vom","(pcsw.ClientsTest.start_date) Start date of observed period") }, "anchor": "-20" });
    var end_date2859 = new Lino.DateField({ "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">until</span>", "name": "end_date", "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("bis","(pcsw.ClientsTest.end_date) End date of observed period") }, "anchor": "-20" });
    var observed_event2860 = new Lino.ChoicesFieldElement({ "autoHeight": true, "forceSelection": true, "fieldLabel": "Observed event", "name": "observed_event", "hiddenName": "observed_eventHidden", "listeners": { "render": Lino.quicktip_renderer("Beobachtungskriterium","(pcsw.ClientsTest.observed_event) ") }, "selectOnFocus": true, "anchor": "-20", "store": [['','<br>']].concat(Lino.pcsw.ClientEvents) });
    var main_2_panel2861 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 12, "autoHeight": true, "layout": "form", "xtype": "panel", "items": client_state2855, "labelAlign": "top" }, { "flex": 22, "autoHeight": true, "layout": "form", "xtype": "panel", "items": coached_by2856, "labelAlign": "top" }, { "flex": 22, "autoHeight": true, "layout": "form", "xtype": "panel", "items": and_coached_by2857, "labelAlign": "top" }, { "flex": 9, "autoHeight": true, "layout": "form", "xtype": "panel", "items": start_date2858, "labelAlign": "top" }, { "flex": 9, "autoHeight": true, "layout": "form", "xtype": "panel", "items": end_date2859, "labelAlign": "top" }, { "flex": 22, "autoHeight": true, "layout": "form", "xtype": "panel", "items": observed_event2860, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 198, "border": false, "anchor": "-20", "labelAlign": "top" });
    var invalid_niss2868 = new Ext.form.Checkbox({ "autoHeight": true, "hideLabel": true, "checked": true, "name": "invalid_niss", "listeners": { "render": Lino.quicktip_renderer("auf g\u00fcltige NISS pr\u00fcfen","(pcsw.ClientsTest.invalid_niss) ") }, "boxLabel": "Check NISS validity", "selectOnFocus": true, "anchor": "-20" });
    var overlapping_contracts2869 = new Ext.form.Checkbox({ "autoHeight": true, "hideLabel": true, "checked": true, "name": "overlapping_contracts", "listeners": { "render": Lino.quicktip_renderer("auf Vertrags\u00fcberschneidungen pr\u00fcfen","(pcsw.ClientsTest.overlapping_contracts) ") }, "boxLabel": "Check for overlapping contracts", "selectOnFocus": true, "anchor": "-20" });
    var only_primary2870 = new Ext.form.Checkbox({ "autoHeight": true, "hideLabel": true, "checked": false, "name": "only_primary", "listeners": { "render": Lino.quicktip_renderer("Nur prim\u00e4re Begleitungen","(pcsw.ClientsTest.only_primary) Nur Klienten, die eine effektive <b>prim\u00e4re</b> Begleitung haben.") }, "boxLabel": "Only primary clients", "selectOnFocus": true, "anchor": "-20" });
    var nationality2871 = new Lino.TwinCombo({ "autoHeight": true, "fieldLabel": "Nationality", "name": "nationality", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.countries.Countries.detail)}, "emptyText": "Select a Country...", "listeners": { "render": Lino.quicktip_renderer("Staatsangeh\u00f6rigkeit","(pcsw.ClientsTest.nationality) ") }, "selectOnFocus": true, "hiddenName": "nationalityHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/pcsw/ClientsTest/nationality", "method": "GET" }) }) });
    var main_3_panel2872 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 20, "autoHeight": true, "layout": "form", "xtype": "panel", "items": invalid_niss2868, "labelAlign": "top" }, { "flex": 20, "autoHeight": true, "layout": "form", "xtype": "panel", "items": overlapping_contracts2869, "labelAlign": "top" }, { "flex": 20, "autoHeight": true, "layout": "form", "xtype": "panel", "items": only_primary2870, "labelAlign": "top" }, { "flex": 40, "autoHeight": true, "layout": "form", "xtype": "panel", "items": nationality2871, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 324, "border": false, "anchor": "-20", "labelAlign": "top" });
    this.items = [ main_1_panel2850, main_2_panel2861, main_3_panel2872 ];
    this.fields = [ aged_from2846, aged_to2847, gender2848, also_obsolete2849, client_state2855, coached_by2856, and_coached_by2857, start_date2858, end_date2859, observed_event2860, invalid_niss2868, overlapping_contracts2869, only_primary2870, nationality2871 ];
    Lino.pcsw.ClientsTest.ParamsPanel.superclass.initComponent.call(this);
  }
});


Lino.integ.Clients.ParamsPanel = Ext.extend(Ext.form.FormPanel,{
  autoScroll: false,
  autoHeight: true,
  border: false,
  hideCheckBoxLabels: true,
  frame: true,
  bodyBorder: false,
  labelAlign: "top",
  layout: 'form',
  autoHeight: true,
  initComponent : function() {
    var containing_panel = this;
    var client_state2520 = new Lino.ChoicesFieldElement({ "autoHeight": true, "forceSelection": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">State</span>", "name": "client_state", "hiddenName": "client_stateHidden", "listeners": { "render": Lino.quicktip_renderer("State","(integ.Clients.client_state) Nur Klienten mit diesem Status (Aktenzustand).") }, "selectOnFocus": true, "anchor": "-20", "store": [['','<br>']].concat(Lino.pcsw.ClientStates) });
    var coached_by2521 = new Lino.TwinCombo({ "preferred_width": 15, "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Coached by</span>", "name": "coached_by", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.users.Users.detail)}, "hiddenName": "coached_byHidden", "listeners": { "render": Lino.quicktip_renderer("AI","(integ.Clients.coached_by) Nur Klienten, die eine Begleitung mit diesem Benutzer haben.") }, "selectOnFocus": true, "emptyText": "Select a User...", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/integ/Clients/coached_by", "method": "GET" }) }) });
    var and_coached_by2522 = new Lino.TwinCombo({ "preferred_width": 15, "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">and by</span>", "name": "and_coached_by", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.users.Users.detail)}, "hiddenName": "and_coached_byHidden", "listeners": { "render": Lino.quicktip_renderer("et par","(integ.Clients.and_coached_by) Nur Klienten, die auch mit diesem Benutzer eine Begleitung haben.") }, "selectOnFocus": true, "emptyText": "Select a User...", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/integ/Clients/and_coached_by", "method": "GET" }) }) });
    var start_date2523 = new Lino.DateField({ "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Period from</span>", "name": "start_date", "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("P\u00e9riode du","(integ.Clients.start_date) Start date of observed period") }, "anchor": "-20" });
    var end_date2524 = new Lino.DateField({ "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">until</span>", "name": "end_date", "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("au ","(integ.Clients.end_date) End date of observed period") }, "anchor": "-20" });
    var observed_event2525 = new Lino.ChoicesFieldElement({ "autoHeight": true, "forceSelection": true, "fieldLabel": "Observed event", "name": "observed_event", "hiddenName": "observed_eventHidden", "listeners": { "render": Lino.quicktip_renderer("Observed event","(integ.Clients.observed_event) ") }, "selectOnFocus": true, "anchor": "-20", "store": [['','<br>']].concat(Lino.pcsw.ClientEvents) });
    var main_1_panel2526 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 12, "autoHeight": true, "layout": "form", "xtype": "panel", "items": client_state2520, "labelAlign": "top" }, { "flex": 22, "autoHeight": true, "layout": "form", "xtype": "panel", "items": coached_by2521, "labelAlign": "top" }, { "flex": 22, "autoHeight": true, "layout": "form", "xtype": "panel", "items": and_coached_by2522, "labelAlign": "top" }, { "flex": 9, "autoHeight": true, "layout": "form", "xtype": "panel", "items": start_date2523, "labelAlign": "top" }, { "flex": 9, "autoHeight": true, "layout": "form", "xtype": "panel", "items": end_date2524, "labelAlign": "top" }, { "flex": 22, "autoHeight": true, "layout": "form", "xtype": "panel", "items": observed_event2525, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 135, "border": false, "anchor": "-20", "labelAlign": "top" });
    var aged_from2533 = new Ext.form.NumberField({ "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Aged from</span>", "name": "aged_from", "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Age: de","(integ.Clients.aged_from) Nur Klienten, die mindestens so alt sind.") }, "anchor": "-20" });
    var aged_to2534 = new Ext.form.NumberField({ "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Aged to</span>", "name": "aged_to", "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Age: jusque","(integ.Clients.aged_to) Nur Klienten, die h\u00f6chstens so alt sind.") }, "anchor": "-20" });
    var gender2535 = new Lino.ChoicesFieldElement({ "autoHeight": true, "forceSelection": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Gender</span>", "name": "gender", "hiddenName": "genderHidden", "listeners": { "render": Lino.quicktip_renderer("Sexe","(integ.Clients.gender) Nur Personen, deren Feld \"Geschlecht\" ausgef\u00fcllt ist und dem angegebenen Wert entspricht.") }, "selectOnFocus": true, "anchor": "-20", "store": [['','<br>']].concat(Lino.lino.Genders) });
    var nationality2536 = new Lino.TwinCombo({ "autoHeight": true, "fieldLabel": "Nationality", "name": "nationality", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.countries.Countries.detail)}, "emptyText": "Select a Country...", "listeners": { "render": Lino.quicktip_renderer("Nationalit\u00e9","(integ.Clients.nationality) ") }, "selectOnFocus": true, "hiddenName": "nationalityHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/integ/Clients/nationality", "method": "GET" }) }) });
    var also_obsolete2537 = new Ext.form.Checkbox({ "autoHeight": true, "hideLabel": true, "checked": false, "name": "also_obsolete", "listeners": { "render": Lino.quicktip_renderer("aussi clients obsol\u00e8tes","(integ.Clients.also_obsolete) Auch Datens\u00e4tze anzeigen, die als veraltet markiert sind.") }, "boxLabel": "Also obsolete data", "selectOnFocus": true, "anchor": "-20" });
    var main_2_panel2538 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 10, "autoHeight": true, "layout": "form", "xtype": "panel", "items": aged_from2533, "labelAlign": "top" }, { "flex": 10, "autoHeight": true, "layout": "form", "xtype": "panel", "items": aged_to2534, "labelAlign": "top" }, { "flex": 18, "autoHeight": true, "layout": "form", "xtype": "panel", "items": gender2535, "labelAlign": "top" }, { "flex": 40, "autoHeight": true, "layout": "form", "xtype": "panel", "items": nationality2536, "labelAlign": "top" }, { "flex": 20, "autoHeight": true, "layout": "form", "xtype": "panel", "items": also_obsolete2537, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 216, "border": false, "anchor": "-20", "labelAlign": "top" });
    var language2544 = new Lino.TwinCombo({ "autoHeight": true, "fieldLabel": "Language knowledge", "name": "language", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.languages.Languages.detail)}, "emptyText": "Select a Language...", "listeners": { "render": Lino.quicktip_renderer("Connaissance de langue","(integ.Clients.language) ") }, "selectOnFocus": true, "hiddenName": "languageHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/integ/Clients/language", "method": "GET" }) }) });
    var wanted_property2545 = new Lino.TwinCombo({ "autoHeight": true, "fieldLabel": "Wanted skill", "name": "wanted_property", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.properties.Properties.detail)}, "emptyText": "Select a Property...", "listeners": { "render": Lino.quicktip_renderer("Comp\u00e9tence requise","(integ.Clients.wanted_property) ") }, "selectOnFocus": true, "hiddenName": "wanted_propertyHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/integ/Clients/wanted_property", "method": "GET" }) }) });
    var group2546 = new Lino.RemoteComboFieldElement({ "autoHeight": true, "fieldLabel": "Integration phase", "name": "group", "pageSize": 20, "emptyText": "Select a Integration Phase...", "listeners": { "render": Lino.quicktip_renderer("Phase d'int\u00e9gration","(integ.Clients.group) ") }, "selectOnFocus": true, "hiddenName": "groupHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/integ/Clients/group", "method": "GET" }) }) });
    var only_active2547 = new Ext.form.Checkbox({ "autoHeight": true, "hideLabel": true, "checked": false, "name": "only_active", "listeners": { "render": Lino.quicktip_renderer("Clients actifs seulement","(integ.Clients.only_active) Show only clients in 'active' integration phases") }, "boxLabel": "Only active clients", "selectOnFocus": true, "anchor": "-20" });
    var only_primary2548 = new Ext.form.Checkbox({ "autoHeight": true, "hideLabel": true, "checked": false, "name": "only_primary", "listeners": { "render": Lino.quicktip_renderer("Dossiers primaires seulement","(integ.Clients.only_primary) Nur Klienten, die eine effektive <b>prim\u00e4re</b> Begleitung haben.") }, "boxLabel": "Only primary clients", "selectOnFocus": true, "anchor": "-20" });
    var main_3_panel2549 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 25, "autoHeight": true, "layout": "form", "xtype": "panel", "items": language2544, "labelAlign": "top" }, { "flex": 25, "autoHeight": true, "layout": "form", "xtype": "panel", "items": wanted_property2545, "labelAlign": "top" }, { "flex": 25, "autoHeight": true, "layout": "form", "xtype": "panel", "items": group2546, "labelAlign": "top" }, { "flex": 12, "autoHeight": true, "layout": "form", "xtype": "panel", "items": only_active2547, "labelAlign": "top" }, { "flex": 12, "autoHeight": true, "layout": "form", "xtype": "panel", "items": only_primary2548, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 261, "border": false, "anchor": "-20", "labelAlign": "top" });
    this.items = [ main_1_panel2526, main_2_panel2538, main_3_panel2549 ];
    this.fields = [ client_state2520, coached_by2521, and_coached_by2522, start_date2523, end_date2524, observed_event2525, aged_from2533, aged_to2534, gender2535, nationality2536, also_obsolete2537, language2544, wanted_property2545, group2546, only_active2547, only_primary2548 ];
    Lino.integ.Clients.ParamsPanel.superclass.initComponent.call(this);
  }
});


Lino.cal.Guests.ParamsPanel = Ext.extend(Ext.form.FormPanel,{
  autoScroll: false,
  autoHeight: true,
  border: false,
  hideCheckBoxLabels: true,
  frame: true,
  bodyBorder: false,
  labelAlign: "top",
  layout: 'form',
  autoHeight: true,
  initComponent : function() {
    var containing_panel = this;
    var start_date1475 = new Lino.DateField({ "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Period from</span>", "name": "start_date", "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Periode vom","(cal.Guests.start_date) Start date of observed period") }, "anchor": "-20" });
    var end_date1476 = new Lino.DateField({ "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">until</span>", "name": "end_date", "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("bis","(cal.Guests.end_date) End date of observed period") }, "anchor": "-20" });
    var user1477 = new Lino.TwinCombo({ "preferred_width": 15, "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Responsible user</span>", "name": "user", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.users.Users.detail)}, "hiddenName": "userHidden", "listeners": { "render": Lino.quicktip_renderer("Verantwortlicher","(cal.Guests.user) Only rows managed by this user.") }, "selectOnFocus": true, "emptyText": "Select a User...", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/Guests/user", "method": "GET" }) }) });
    var event_state1478 = new Lino.ChoicesFieldElement({ "autoHeight": true, "forceSelection": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Event state</span>", "name": "event_state", "hiddenName": "event_stateHidden", "listeners": { "render": Lino.quicktip_renderer("Zustand Termin","(cal.Guests.event_state) Only rows having this event state.") }, "selectOnFocus": true, "anchor": "-20", "store": [['','<br>']].concat(Lino.cal.EventStates) });
    var guest_state1479 = new Lino.ChoicesFieldElement({ "autoHeight": true, "forceSelection": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Guest state</span>", "name": "guest_state", "hiddenName": "guest_stateHidden", "listeners": { "render": Lino.quicktip_renderer("Zustand Gast","(cal.Guests.guest_state) Only rows having this guest state.") }, "selectOnFocus": true, "anchor": "-20", "store": [['','<br>']].concat(Lino.cal.GuestStates) });
    var main_1_panel1480 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 13, "autoHeight": true, "layout": "form", "xtype": "panel", "items": start_date1475, "labelAlign": "top" }, { "flex": 13, "autoHeight": true, "layout": "form", "xtype": "panel", "items": end_date1476, "labelAlign": "top" }, { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": user1477, "labelAlign": "top" }, { "flex": 21, "autoHeight": true, "layout": "form", "xtype": "panel", "items": event_state1478, "labelAlign": "top" }, { "flex": 18, "autoHeight": true, "layout": "form", "xtype": "panel", "items": guest_state1479, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 153, "border": false, "anchor": "-20", "labelAlign": "top" });
    var project1486 = new Lino.TwinCombo({ "preferred_width": 20, "autoHeight": true, "fieldLabel": "Client", "name": "project", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.pcsw.Clients.detail)}, "hiddenName": "projectHidden", "listeners": { "render": Lino.quicktip_renderer("Klient","(cal.Guests.project) ") }, "selectOnFocus": true, "emptyText": "Select a Client...", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/Guests/project", "method": "GET" }) }) });
    var partner1487 = new Lino.TwinCombo({ "preferred_width": 20, "autoHeight": true, "fieldLabel": "Partner", "name": "partner", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.contacts.Partners.detail)}, "hiddenName": "partnerHidden", "listeners": { "render": Lino.quicktip_renderer("Partner","(cal.Guests.partner) ") }, "selectOnFocus": true, "emptyText": "Select a Partner...", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/Guests/partner", "method": "GET" }) }) });
    var main_2_panel1488 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": project1486, "labelAlign": "top" }, { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": partner1487, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 72, "border": false, "anchor": "-20", "labelAlign": "top" });
    this.items = [ main_1_panel1480, main_2_panel1488 ];
    this.fields = [ start_date1475, end_date1476, user1477, event_state1478, guest_state1479, project1486, partner1487 ];
    Lino.cal.Guests.ParamsPanel.superclass.initComponent.call(this);
  }
});


Lino.cal.Events.ParamsPanel = Ext.extend(Ext.form.FormPanel,{
  autoScroll: false,
  autoHeight: true,
  border: false,
  hideCheckBoxLabels: true,
  frame: true,
  bodyBorder: false,
  labelAlign: "top",
  layout: 'form',
  autoHeight: true,
  initComponent : function() {
    var containing_panel = this;
    var start_date1413 = new Lino.DateField({ "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Period from</span>", "name": "start_date", "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Periode vom","(cal.Events.start_date) Start date of observed period") }, "anchor": "-20" });
    var end_date1414 = new Lino.DateField({ "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">until</span>", "name": "end_date", "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("bis","(cal.Events.end_date) End date of observed period") }, "anchor": "-20" });
    var observed_event1415 = new Lino.ChoicesFieldElement({ "autoHeight": true, "forceSelection": true, "fieldLabel": "Observed event", "name": "observed_event", "hiddenName": "observed_eventHidden", "listeners": { "render": Lino.quicktip_renderer("Beobachtungskriterium","(cal.Events.observed_event) ") }, "selectOnFocus": true, "anchor": "-20", "store": [['','<br>']].concat(Lino.cal.EventEvents) });
    var state1416 = new Lino.ChoicesFieldElement({ "autoHeight": true, "forceSelection": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">State</span>", "name": "state", "hiddenName": "stateHidden", "listeners": { "render": Lino.quicktip_renderer("Zustand","(cal.Events.state) Only rows having this state.") }, "selectOnFocus": true, "anchor": "-20", "store": [['','<br>']].concat(Lino.cal.EventStates) });
    var main_1_panel1417 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 20, "autoHeight": true, "layout": "form", "xtype": "panel", "items": start_date1413, "labelAlign": "top" }, { "flex": 20, "autoHeight": true, "layout": "form", "xtype": "panel", "items": end_date1414, "labelAlign": "top" }, { "flex": 25, "autoHeight": true, "layout": "form", "xtype": "panel", "items": observed_event1415, "labelAlign": "top" }, { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": state1416, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 198, "border": false, "anchor": "-20", "labelAlign": "top" });
    var user1422 = new Lino.TwinCombo({ "preferred_width": 15, "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Managed by</span>", "name": "user", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.users.Users.detail)}, "hiddenName": "userHidden", "listeners": { "render": Lino.quicktip_renderer("Verwaltet durch","(cal.Events.user) Only rows managed by this user.") }, "selectOnFocus": true, "emptyText": "Select a User...", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/Events/user", "method": "GET" }) }) });
    var assigned_to1423 = new Lino.TwinCombo({ "preferred_width": 15, "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Assigned to</span>", "name": "assigned_to", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.users.Users.detail)}, "hiddenName": "assigned_toHidden", "listeners": { "render": Lino.quicktip_renderer("Zugewiesen zu","(cal.Events.assigned_to) Only events assigned to this user.") }, "selectOnFocus": true, "emptyText": "Select a User...", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/Events/assigned_to", "method": "GET" }) }) });
    var project1424 = new Lino.TwinCombo({ "preferred_width": 20, "autoHeight": true, "fieldLabel": "Client", "name": "project", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.pcsw.Clients.detail)}, "hiddenName": "projectHidden", "listeners": { "render": Lino.quicktip_renderer("Klient","(cal.Events.project) ") }, "selectOnFocus": true, "emptyText": "Select a Client...", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/Events/project", "method": "GET" }) }) });
    var calendar1425 = new Lino.TwinCombo({ "autoHeight": true, "fieldLabel": "Calendar", "name": "calendar", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.cal.Calendars.detail)}, "emptyText": "Select a Calendar...", "listeners": { "render": Lino.quicktip_renderer("Kalender","(cal.Events.calendar) ") }, "selectOnFocus": true, "hiddenName": "calendarHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/Events/calendar", "method": "GET" }) }) });
    var show_appointments1426 = new Lino.ChoicesFieldElement({ "autoHeight": true, "forceSelection": true, "fieldLabel": "Appointments", "name": "show_appointments", "hiddenName": "show_appointmentsHidden", "listeners": { "render": Lino.quicktip_renderer("Termine","(cal.Events.show_appointments) ") }, "selectOnFocus": true, "anchor": "-20", "store": [['','<br>']].concat(Lino.lino.YesNo) });
    var main_2_panel1427 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 22, "autoHeight": true, "layout": "form", "xtype": "panel", "items": user1422, "labelAlign": "top" }, { "flex": 22, "autoHeight": true, "layout": "form", "xtype": "panel", "items": assigned_to1423, "labelAlign": "top" }, { "flex": 22, "autoHeight": true, "layout": "form", "xtype": "panel", "items": project1424, "labelAlign": "top" }, { "flex": 22, "autoHeight": true, "layout": "form", "xtype": "panel", "items": calendar1425, "labelAlign": "top" }, { "flex": 8, "autoHeight": true, "layout": "form", "xtype": "panel", "items": show_appointments1426, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 144, "border": false, "anchor": "-20", "labelAlign": "top" });
    this.items = [ main_1_panel1417, main_2_panel1427 ];
    this.fields = [ start_date1413, end_date1414, observed_event1415, state1416, user1422, assigned_to1423, project1424, calendar1425, show_appointments1426 ];
    Lino.cal.Events.ParamsPanel.superclass.initComponent.call(this);
  }
});


Lino.jobs.OldJobsOverview.ParamsPanel = Ext.extend(Ext.form.FormPanel,{
  autoHeight: true,
  frame: true,
  layoutConfig: { "align": "stretchmax" },
  hideCheckBoxLabels: true,
  autoScroll: false,
  labelWidth: 162,
  border: false,
  bodyBorder: false,
  labelAlign: "top",
  layout: 'form',
  autoHeight: true,
  initComponent : function() {
    var containing_panel = this;
    var contract_type5126 = new Lino.TwinCombo({ "preferred_width": 20, "autoHeight": true, "fieldLabel": "Job Contract Type", "name": "contract_type", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.jobs.ContractTypes.detail)}, "hiddenName": "contract_typeHidden", "listeners": { "render": Lino.quicktip_renderer("Job Contract Type","(jobs.OldJobsOverview.contract_type) ") }, "selectOnFocus": true, "emptyText": "Select a Job Contract Type...", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/jobs/OldJobsOverview/contract_type", "method": "GET" }) }) });
    var date5127 = new Lino.DateField({ "autoHeight": true, "fieldLabel": "Date", "name": "date", "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Date","(jobs.OldJobsOverview.date) ") }, "anchor": "-20" });
    var job_type5128 = new Lino.TwinCombo({ "autoHeight": true, "fieldLabel": "Job Type", "name": "job_type", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.jobs.JobTypes.detail)}, "emptyText": "Select a Job Type...", "listeners": { "render": Lino.quicktip_renderer("Job Type","(jobs.OldJobsOverview.job_type) ") }, "selectOnFocus": true, "hiddenName": "job_typeHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/jobs/OldJobsOverview/job_type", "method": "GET" }) }) });
    this.items = [ { "flex": 41, "autoHeight": true, "layout": "form", "xtype": "panel", "items": contract_type5126, "labelAlign": "top" }, { "flex": 16, "autoHeight": true, "layout": "form", "xtype": "panel", "items": date5127, "labelAlign": "top" }, { "flex": 41, "autoHeight": true, "layout": "form", "xtype": "panel", "items": job_type5128, "labelAlign": "top" } ];
    this.fields = [ contract_type5126, date5127, job_type5128 ];
    Lino.jobs.OldJobsOverview.ParamsPanel.superclass.initComponent.call(this);
  }
});


Lino.contacts.Persons.ParamsPanel = Ext.extend(Ext.form.FormPanel,{
  autoScroll: false,
  border: false,
  hideCheckBoxLabels: true,
  frame: true,
  bodyBorder: false,
  labelAlign: "top",
  layout: 'form',
  autoHeight: true,
  initComponent : function() {
    var containing_panel = this;
    var gender1703 = new Lino.ChoicesFieldElement({ "autoHeight": true, "forceSelection": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Gender</span>", "name": "gender", "hiddenName": "genderHidden", "listeners": { "render": Lino.quicktip_renderer("Geschlecht","(contacts.Persons.gender) Nur Personen, deren Feld \"Geschlecht\" ausgef\u00fcllt ist und dem angegebenen Wert entspricht.") }, "selectOnFocus": true, "anchor": "-20", "store": [['','<br>']].concat(Lino.lino.Genders) });
    var also_obsolete1704 = new Ext.form.Checkbox({ "autoHeight": true, "hideLabel": true, "checked": false, "name": "also_obsolete", "listeners": { "render": Lino.quicktip_renderer("Auch veraltete Daten","(contacts.Persons.also_obsolete) Auch Datens\u00e4tze anzeigen, die als veraltet markiert sind.") }, "boxLabel": "Also obsolete data", "selectOnFocus": true, "anchor": "-20" });
    var main_1_panel1705 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 189, "hideCheckBoxLabels": true, "items": [ { "flex": 47, "autoHeight": true, "layout": "form", "xtype": "panel", "items": gender1703, "labelAlign": "top" }, { "flex": 52, "autoHeight": true, "layout": "form", "xtype": "panel", "items": also_obsolete1704, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    this.items = [ main_1_panel1705 ];
    this.fields = [ gender1703, also_obsolete1704 ];
    Lino.contacts.Persons.ParamsPanel.superclass.initComponent.call(this);
  }
});


Lino.pcsw.Coachings.ParamsPanel = Ext.extend(Ext.form.FormPanel,{
  autoScroll: false,
  autoHeight: true,
  border: false,
  hideCheckBoxLabels: true,
  frame: true,
  bodyBorder: false,
  labelAlign: "top",
  layout: 'form',
  autoHeight: true,
  initComponent : function() {
    var containing_panel = this;
    var start_date128 = new Lino.DateField({ "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Period from</span>", "name": "start_date", "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Periode vom","(pcsw.Coachings.start_date) Start date of observed period") }, "anchor": "-20" });
    var end_date129 = new Lino.DateField({ "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">until</span>", "name": "end_date", "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("bis","(pcsw.Coachings.end_date) End date of observed period") }, "anchor": "-20" });
    var observed_event130 = new Lino.ChoicesFieldElement({ "autoHeight": true, "forceSelection": true, "fieldLabel": "Observed event", "name": "observed_event", "hiddenName": "observed_eventHidden", "listeners": { "render": Lino.quicktip_renderer("Beobachtungskriterium","(pcsw.Coachings.observed_event) ") }, "selectOnFocus": true, "anchor": "-20", "store": [['','<br>']].concat(Lino.pcsw.CoachingEvents) });
    var coached_by131 = new Lino.TwinCombo({ "preferred_width": 15, "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Coached by</span>", "name": "coached_by", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.users.Users.detail)}, "hiddenName": "coached_byHidden", "listeners": { "render": Lino.quicktip_renderer("Begleitet durch","(pcsw.Coachings.coached_by) Nur Begleitungen dieses Benutzers.") }, "selectOnFocus": true, "emptyText": "Select a User...", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/pcsw/Coachings/coached_by", "method": "GET" }) }) });
    var and_coached_by132 = new Lino.TwinCombo({ "preferred_width": 15, "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">and by</span>", "name": "and_coached_by", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.users.Users.detail)}, "hiddenName": "and_coached_byHidden", "listeners": { "render": Lino.quicktip_renderer("und durch","(pcsw.Coachings.and_coached_by) ... und auch Begleitungen dieses Benutzers.") }, "selectOnFocus": true, "emptyText": "Select a User...", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/pcsw/Coachings/and_coached_by", "method": "GET" }) }) });
    var main_1_panel133 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 12, "autoHeight": true, "layout": "form", "xtype": "panel", "items": start_date128, "labelAlign": "top" }, { "flex": 12, "autoHeight": true, "layout": "form", "xtype": "panel", "items": end_date129, "labelAlign": "top" }, { "flex": 15, "autoHeight": true, "layout": "form", "xtype": "panel", "items": observed_event130, "labelAlign": "top" }, { "flex": 30, "autoHeight": true, "layout": "form", "xtype": "panel", "items": coached_by131, "labelAlign": "top" }, { "flex": 30, "autoHeight": true, "layout": "form", "xtype": "panel", "items": and_coached_by132, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 198, "border": false, "anchor": "-20", "labelAlign": "top" });
    var primary_coachings139 = new Lino.ChoicesFieldElement({ "autoHeight": true, "forceSelection": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Primary coachings</span>", "name": "primary_coachings", "hiddenName": "primary_coachingsHidden", "listeners": { "render": Lino.quicktip_renderer("Prim\u00e4re Begleitungen","(pcsw.Coachings.primary_coachings) Accompagnements primaires.") }, "selectOnFocus": true, "anchor": "-20", "store": [['','<br>']].concat(Lino.lino.YesNo) });
    var coaching_type140 = new Lino.RemoteComboFieldElement({ "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Coaching type</span>", "name": "coaching_type", "pageSize": 20, "emptyText": "Select a Coaching type...", "listeners": { "render": Lino.quicktip_renderer("Dienst","(pcsw.Coachings.coaching_type) Nur Begleitungen dieses Dienstes.") }, "selectOnFocus": true, "hiddenName": "coaching_typeHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/pcsw/Coachings/coaching_type", "method": "GET" }) }) });
    var ending141 = new Lino.TwinCombo({ "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Reason of termination</span>", "name": "ending", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.pcsw.CoachingEndings.detail)}, "emptyText": "Select a Reason of termination...", "listeners": { "render": Lino.quicktip_renderer("Beendigungsgrund","(pcsw.Coachings.ending) Nur Begleitungen mit diesem Beendigungsgrund.") }, "selectOnFocus": true, "hiddenName": "endingHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/pcsw/Coachings/ending", "method": "GET" }) }) });
    var main_2_panel142 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 14, "autoHeight": true, "layout": "form", "xtype": "panel", "items": primary_coachings139, "labelAlign": "top" }, { "flex": 42, "autoHeight": true, "layout": "form", "xtype": "panel", "items": coaching_type140, "labelAlign": "top" }, { "flex": 42, "autoHeight": true, "layout": "form", "xtype": "panel", "items": ending141, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 189, "border": false, "anchor": "-20", "labelAlign": "top" });
    this.items = [ main_1_panel133, main_2_panel142 ];
    this.fields = [ start_date128, end_date129, observed_event130, coached_by131, and_coached_by132, primary_coachings139, coaching_type140, ending141 ];
    Lino.pcsw.Coachings.ParamsPanel.superclass.initComponent.call(this);
  }
});


Lino.about.Inspector.ParamsPanel = Ext.extend(Ext.form.FormPanel,{
  autoHeight: true,
  frame: true,
  layoutConfig: { "align": "stretchmax" },
  hideCheckBoxLabels: true,
  autoScroll: false,
  labelWidth: 153,
  border: false,
  bodyBorder: false,
  labelAlign: "top",
  layout: 'form',
  autoHeight: true,
  initComponent : function() {
    var containing_panel = this;
    var inspected5116 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Inspected object", "name": "inspected", "maxLength": 100, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Inspected object","(about.Inspector.inspected) ") }, "anchor": "-20" });
    var show_callables5117 = new Ext.form.Checkbox({ "autoHeight": true, "hideLabel": true, "checked": false, "name": "show_callables", "listeners": { "render": Lino.quicktip_renderer("show callables","(about.Inspector.show_callables) ") }, "boxLabel": "show callables", "selectOnFocus": true, "anchor": "-20" });
    this.items = [ { "flex": 67, "autoHeight": true, "layout": "form", "xtype": "panel", "items": inspected5116, "labelAlign": "top" }, { "flex": 32, "autoHeight": true, "layout": "form", "xtype": "panel", "items": show_callables5117, "labelAlign": "top" } ];
    this.fields = [ inspected5116, show_callables5117 ];
    Lino.about.Inspector.ParamsPanel.superclass.initComponent.call(this);
  }
});


Lino.courses.PendingCourseRequests.ParamsPanel = Ext.extend(Ext.form.FormPanel,{
  autoScroll: false,
  autoHeight: true,
  border: false,
  hideCheckBoxLabels: true,
  frame: true,
  bodyBorder: false,
  labelAlign: "top",
  layout: 'form',
  autoHeight: true,
  initComponent : function() {
    var containing_panel = this;
    var aged_from1634 = new Ext.form.NumberField({ "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Aged from</span>", "name": "aged_from", "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Alter von","(courses.PendingCourseRequests.aged_from) Nur Klienten, die mindestens so alt sind.") }, "anchor": "-20" });
    var aged_to1635 = new Ext.form.NumberField({ "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Aged to</span>", "name": "aged_to", "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Alter bis","(courses.PendingCourseRequests.aged_to) Nur Klienten, die h\u00f6chstens so alt sind.") }, "anchor": "-20" });
    var gender1636 = new Lino.ChoicesFieldElement({ "autoHeight": true, "forceSelection": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Gender</span>", "name": "gender", "hiddenName": "genderHidden", "listeners": { "render": Lino.quicktip_renderer("Geschlecht","(courses.PendingCourseRequests.gender) Nur Personen, deren Feld \"Geschlecht\" ausgef\u00fcllt ist und dem angegebenen Wert entspricht.") }, "selectOnFocus": true, "anchor": "-20", "store": [['','<br>']].concat(Lino.lino.Genders) });
    var nationality1637 = new Lino.TwinCombo({ "autoHeight": true, "fieldLabel": "Nationality", "name": "nationality", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.countries.Countries.detail)}, "emptyText": "Select a Country...", "listeners": { "render": Lino.quicktip_renderer("Staatsangeh\u00f6rigkeit","(courses.PendingCourseRequests.nationality) ") }, "selectOnFocus": true, "hiddenName": "nationalityHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/courses/PendingCourseRequests/nationality", "method": "GET" }) }) });
    var also_obsolete1638 = new Ext.form.Checkbox({ "autoHeight": true, "hideLabel": true, "checked": false, "name": "also_obsolete", "listeners": { "render": Lino.quicktip_renderer("Auch veraltete Daten","(courses.PendingCourseRequests.also_obsolete) Auch Datens\u00e4tze anzeigen, die als veraltet markiert sind.") }, "boxLabel": "Also obsolete data", "selectOnFocus": true, "anchor": "-20" });
    var main_1_panel1639 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 10, "autoHeight": true, "layout": "form", "xtype": "panel", "items": aged_from1634, "labelAlign": "top" }, { "flex": 10, "autoHeight": true, "layout": "form", "xtype": "panel", "items": aged_to1635, "labelAlign": "top" }, { "flex": 18, "autoHeight": true, "layout": "form", "xtype": "panel", "items": gender1636, "labelAlign": "top" }, { "flex": 40, "autoHeight": true, "layout": "form", "xtype": "panel", "items": nationality1637, "labelAlign": "top" }, { "flex": 20, "autoHeight": true, "layout": "form", "xtype": "panel", "items": also_obsolete1638, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 189, "border": false, "anchor": "-20", "labelAlign": "top" });
    var client_state1645 = new Lino.ChoicesFieldElement({ "autoHeight": true, "forceSelection": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">State</span>", "name": "client_state", "hiddenName": "client_stateHidden", "listeners": { "render": Lino.quicktip_renderer("Zustand","(courses.PendingCourseRequests.client_state) Nur Klienten mit diesem Status (Aktenzustand).") }, "selectOnFocus": true, "anchor": "-20", "store": [['','<br>']].concat(Lino.pcsw.ClientStates) });
    var coached_by1646 = new Lino.TwinCombo({ "preferred_width": 15, "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Coached by</span>", "name": "coached_by", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.users.Users.detail)}, "hiddenName": "coached_byHidden", "listeners": { "render": Lino.quicktip_renderer("Begleitet durch","(courses.PendingCourseRequests.coached_by) Nur Klienten, die eine Begleitung mit diesem Benutzer haben.") }, "selectOnFocus": true, "emptyText": "Select a User...", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/courses/PendingCourseRequests/coached_by", "method": "GET" }) }) });
    var and_coached_by1647 = new Lino.TwinCombo({ "preferred_width": 15, "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">and by</span>", "name": "and_coached_by", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.users.Users.detail)}, "hiddenName": "and_coached_byHidden", "listeners": { "render": Lino.quicktip_renderer("und durch","(courses.PendingCourseRequests.and_coached_by) Nur Klienten, die auch mit diesem Benutzer eine Begleitung haben.") }, "selectOnFocus": true, "emptyText": "Select a User...", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/courses/PendingCourseRequests/and_coached_by", "method": "GET" }) }) });
    var start_date1648 = new Lino.DateField({ "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Period from</span>", "name": "start_date", "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Periode vom","(courses.PendingCourseRequests.start_date) Start date of observed period") }, "anchor": "-20" });
    var end_date1649 = new Lino.DateField({ "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">until</span>", "name": "end_date", "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("bis","(courses.PendingCourseRequests.end_date) End date of observed period") }, "anchor": "-20" });
    var observed_event1650 = new Lino.ChoicesFieldElement({ "autoHeight": true, "forceSelection": true, "fieldLabel": "Observed event", "name": "observed_event", "hiddenName": "observed_eventHidden", "listeners": { "render": Lino.quicktip_renderer("Beobachtungskriterium","(courses.PendingCourseRequests.observed_event) ") }, "selectOnFocus": true, "anchor": "-20", "store": [['','<br>']].concat(Lino.pcsw.ClientEvents) });
    var only_primary1651 = new Ext.form.Checkbox({ "autoHeight": true, "hideLabel": true, "checked": false, "name": "only_primary", "listeners": { "render": Lino.quicktip_renderer("Nur prim\u00e4re Begleitungen","(courses.PendingCourseRequests.only_primary) Nur Klienten, die eine effektive <b>prim\u00e4re</b> Begleitung haben.") }, "boxLabel": "Only primary clients", "selectOnFocus": true, "anchor": "-20" });
    var main_2_panel1652 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 11, "autoHeight": true, "layout": "form", "xtype": "panel", "items": client_state1645, "labelAlign": "top" }, { "flex": 20, "autoHeight": true, "layout": "form", "xtype": "panel", "items": coached_by1646, "labelAlign": "top" }, { "flex": 20, "autoHeight": true, "layout": "form", "xtype": "panel", "items": and_coached_by1647, "labelAlign": "top" }, { "flex": 8, "autoHeight": true, "layout": "form", "xtype": "panel", "items": start_date1648, "labelAlign": "top" }, { "flex": 8, "autoHeight": true, "layout": "form", "xtype": "panel", "items": end_date1649, "labelAlign": "top" }, { "flex": 20, "autoHeight": true, "layout": "form", "xtype": "panel", "items": observed_event1650, "labelAlign": "top" }, { "flex": 10, "autoHeight": true, "layout": "form", "xtype": "panel", "items": only_primary1651, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 225, "border": false, "anchor": "-20", "labelAlign": "top" });
    var request_state1660 = new Lino.ChoicesFieldElement({ "autoHeight": true, "forceSelection": true, "fieldLabel": "State", "name": "request_state", "hiddenName": "request_stateHidden", "listeners": { "render": Lino.quicktip_renderer("Zustand","(courses.PendingCourseRequests.request_state) ") }, "selectOnFocus": true, "anchor": "-20", "store": [['','<br>']].concat(Lino.courses.CourseRequestStates) });
    var course_content1661 = new Lino.TwinCombo({ "autoHeight": true, "fieldLabel": "Course Content", "name": "course_content", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.courses.CourseContents.detail)}, "emptyText": "Select a Course Content...", "listeners": { "render": Lino.quicktip_renderer("Kursinhalt","(courses.PendingCourseRequests.course_content) ") }, "selectOnFocus": true, "hiddenName": "course_contentHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/courses/PendingCourseRequests/course_content", "method": "GET" }) }) });
    var course_provider1662 = new Lino.TwinCombo({ "preferred_width": 20, "autoHeight": true, "fieldLabel": "Course provider", "name": "course_provider", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.courses.CourseProviders.detail)}, "hiddenName": "course_providerHidden", "listeners": { "render": Lino.quicktip_renderer("Kursanbieter","(courses.PendingCourseRequests.course_provider) ") }, "selectOnFocus": true, "emptyText": "Select a Course provider...", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/courses/PendingCourseRequests/course_provider", "method": "GET" }) }) });
    var course_offer1663 = new Lino.TwinCombo({ "autoHeight": true, "fieldLabel": "Course Offer", "name": "course_offer", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.courses.CourseOffers.detail)}, "emptyText": "Select a Course Offer...", "listeners": { "render": Lino.quicktip_renderer("Kursangebot","(courses.PendingCourseRequests.course_offer) ") }, "selectOnFocus": true, "hiddenName": "course_offerHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/courses/PendingCourseRequests/course_offer", "method": "GET" }) }) });
    var main_3_panel1664 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 17, "autoHeight": true, "layout": "form", "xtype": "panel", "items": request_state1660, "labelAlign": "top" }, { "flex": 27, "autoHeight": true, "layout": "form", "xtype": "panel", "items": course_content1661, "labelAlign": "top" }, { "flex": 27, "autoHeight": true, "layout": "form", "xtype": "panel", "items": course_provider1662, "labelAlign": "top" }, { "flex": 27, "autoHeight": true, "layout": "form", "xtype": "panel", "items": course_offer1663, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 117, "border": false, "anchor": "-20", "labelAlign": "top" });
    this.items = [ main_1_panel1639, main_2_panel1652, main_3_panel1664 ];
    this.fields = [ aged_from1634, aged_to1635, gender1636, nationality1637, also_obsolete1638, client_state1645, coached_by1646, and_coached_by1647, start_date1648, end_date1649, observed_event1650, only_primary1651, request_state1660, course_content1661, course_provider1662, course_offer1663 ];
    Lino.courses.PendingCourseRequests.ParamsPanel.superclass.initComponent.call(this);
  }
});


Lino.integ.ActivityReport.ParamsPanel = Ext.extend(Ext.form.FormPanel,{
  autoHeight: true,
  frame: true,
  layoutConfig: { "align": "stretchmax" },
  hideCheckBoxLabels: true,
  autoScroll: false,
  labelWidth: 108,
  border: false,
  bodyBorder: false,
  labelAlign: "top",
  layout: 'form',
  autoHeight: true,
  initComponent : function() {
    var containing_panel = this;
    var start_date2885 = new Lino.DateField({ "autoHeight": true, "allowBlank": false, "fieldLabel": "Period from", "name": "start_date", "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Periode vom","(integ.ActivityReport.start_date) ") }, "anchor": "-20" });
    var end_date2886 = new Lino.DateField({ "autoHeight": true, "allowBlank": false, "fieldLabel": "until", "name": "end_date", "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("bis","(integ.ActivityReport.end_date) ") }, "anchor": "-20" });
    var include_jobs2887 = new Ext.form.Checkbox({ "autoHeight": true, "hideLabel": true, "checked": false, "name": "include_jobs", "listeners": { "render": Lino.quicktip_renderer("Art.60\u00a77","(integ.ActivityReport.include_jobs) ") }, "boxLabel": "Art.60\u00a77", "selectOnFocus": true, "anchor": "-20" });
    var include_isip2888 = new Ext.form.Checkbox({ "autoHeight": true, "hideLabel": true, "checked": false, "name": "include_isip", "listeners": { "render": Lino.quicktip_renderer("VSE","(integ.ActivityReport.include_isip) ") }, "boxLabel": "ISIP", "selectOnFocus": true, "anchor": "-20" });
    this.items = [ { "flex": 22, "autoHeight": true, "layout": "form", "xtype": "panel", "items": start_date2885, "labelAlign": "top" }, { "flex": 22, "autoHeight": true, "layout": "form", "xtype": "panel", "items": end_date2886, "labelAlign": "top" }, { "flex": 27, "autoHeight": true, "layout": "form", "xtype": "panel", "items": include_jobs2887, "labelAlign": "top" }, { "flex": 27, "autoHeight": true, "layout": "form", "xtype": "panel", "items": include_isip2888, "labelAlign": "top" } ];
    this.fields = [ start_date2885, end_date2886, include_jobs2887, include_isip2888 ];
    Lino.integ.ActivityReport.ParamsPanel.superclass.initComponent.call(this);
  }
});


Lino.newcomers.NewClients.ParamsPanel = Ext.extend(Ext.form.FormPanel,{
  autoHeight: true,
  frame: true,
  layoutConfig: { "align": "stretchmax" },
  hideCheckBoxLabels: true,
  autoScroll: false,
  labelWidth: 225,
  border: false,
  bodyBorder: false,
  labelAlign: "top",
  layout: 'form',
  autoHeight: true,
  initComponent : function() {
    var containing_panel = this;
    var new_since2497 = new Lino.DateField({ "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">New clients since</span>", "name": "new_since", "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Neue Klienten seit","(newcomers.NewClients.new_since) Auch Klienten, die erst seit Kurzem begleitet sind.") }, "anchor": "-20" });
    var also_refused2498 = new Ext.form.Checkbox({ "autoHeight": true, "hideLabel": true, "checked": false, "name": "also_refused", "listeners": { "render": Lino.quicktip_renderer("Auch abgelehnte Klienten","(newcomers.NewClients.also_refused) ") }, "boxLabel": "Also refused clients", "selectOnFocus": true, "anchor": "-20" });
    var also_obsolete2499 = new Ext.form.Checkbox({ "autoHeight": true, "hideLabel": true, "checked": false, "name": "also_obsolete", "listeners": { "render": Lino.quicktip_renderer("Auch veraltete Daten","(newcomers.NewClients.also_obsolete) ") }, "boxLabel": "Also obsolete records", "selectOnFocus": true, "anchor": "-20" });
    var coached_by2500 = new Lino.TwinCombo({ "preferred_width": 15, "autoHeight": true, "fieldLabel": "Coached by", "name": "coached_by", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.users.Users.detail)}, "hiddenName": "coached_byHidden", "listeners": { "render": Lino.quicktip_renderer("Begleitet durch","(newcomers.NewClients.coached_by) ") }, "selectOnFocus": true, "emptyText": "Select a User...", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/newcomers/NewClients/coached_by", "method": "GET" }) }) });
    this.items = [ { "flex": 16, "autoHeight": true, "layout": "form", "xtype": "panel", "items": new_since2497, "labelAlign": "top" }, { "flex": 20, "autoHeight": true, "layout": "form", "xtype": "panel", "items": also_refused2498, "labelAlign": "top" }, { "flex": 20, "autoHeight": true, "layout": "form", "xtype": "panel", "items": also_obsolete2499, "labelAlign": "top" }, { "flex": 41, "autoHeight": true, "layout": "form", "xtype": "panel", "items": coached_by2500, "labelAlign": "top" } ];
    this.fields = [ new_since2497, also_refused2498, also_obsolete2499, coached_by2500 ];
    Lino.newcomers.NewClients.ParamsPanel.superclass.initComponent.call(this);
  }
});


Lino.pcsw.Clients.merge_row_ActionFormPanel = Ext.extend(Lino.ActionFormPanel,{
  autoScroll: false,
  autoHeight: true,
  border: false,
  layout: "form",
  labelWidth: 72,
  hideCheckBoxLabels: true,
  frame: true,
  bodyBorder: false,
  labelAlign: "top",
  action_name: 'merge_row',
  ls_url: "/pcsw/Clients",
  window_title: "Merge",
  autoHeight: true,
  initComponent : function() {
    var containing_panel = this;
    var merge_to32 = new Lino.TwinCombo({ "preferred_width": 20, "autoHeight": true, "fieldLabel": "into...", "allowBlank": false, "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.pcsw.Clients.detail)}, "emptyText": "Select a Client...", "listeners": { "render": Lino.quicktip_renderer("into...","(<MergeAction merge_row (u'Merge')>.merge_to) ") }, "selectOnFocus": true, "hiddenName": "merge_toHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/apchoices/pcsw/Clients/merge_row/merge_to", "method": "GET" }) }), "name": "merge_to" });
    var pcsw_Dispense33 = new Ext.form.Checkbox({ "autoHeight": true, "hideLabel": true, "checked": false, "name": "pcsw_Dispense", "listeners": { "render": Lino.quicktip_renderer("Dispenses","(<MergeAction merge_row (u'Merge')>.pcsw_Dispense) ") }, "boxLabel": "Dispenses", "selectOnFocus": true, "anchor": "-20" });
    var pcsw_Coaching34 = new Ext.form.Checkbox({ "autoHeight": true, "hideLabel": true, "checked": false, "name": "pcsw_Coaching", "listeners": { "render": Lino.quicktip_renderer("Coachings","(<MergeAction merge_row (u'Merge')>.pcsw_Coaching) ") }, "boxLabel": "Coachings", "selectOnFocus": true, "anchor": "-20" });
    var keep_volatiles_1_panel35 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": pcsw_Dispense33, "labelAlign": "top" }, { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": pcsw_Coaching34, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 90, "border": false, "anchor": "-20", "labelAlign": "top" });
    var cv_LanguageKnowledge38 = new Ext.form.Checkbox({ "autoHeight": true, "hideLabel": true, "checked": false, "name": "cv_LanguageKnowledge", "listeners": { "render": Lino.quicktip_renderer("language knowledges","(<MergeAction merge_row (u'Merge')>.cv_LanguageKnowledge) ") }, "boxLabel": "language knowledges", "selectOnFocus": true, "anchor": "-20" });
    var properties_PersonProperty39 = new Ext.form.Checkbox({ "autoHeight": true, "hideLabel": true, "checked": false, "name": "properties_PersonProperty", "listeners": { "render": Lino.quicktip_renderer("Properties","(<MergeAction merge_row (u'Merge')>.properties_PersonProperty) ") }, "boxLabel": "Properties", "selectOnFocus": true, "anchor": "-20" });
    var keep_volatiles_2_panel40 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": cv_LanguageKnowledge38, "labelAlign": "top" }, { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": properties_PersonProperty39, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 180, "border": false, "anchor": "-20", "labelAlign": "top" });
    var keep_volatiles_panel43 = new Ext.form.FieldSet({ "autoHeight": true, "layout": "form", "title": "Also reassign volatile related objects", "items": [ keep_volatiles_1_panel35, keep_volatiles_2_panel40 ], "frame": true, "bodyBorder": false, "autoScroll": false, "hideCheckBoxLabels": true, "border": false, "anchor": "-20", "labelAlign": "top" });
    var reason44 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Reason", "name": "reason", "listeners": { "render": Lino.quicktip_renderer("Reason","(<MergeAction merge_row (u'Merge')>.reason) ") }, "maxLength": 100, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    this.items = [ { "autoHeight": true, "layout": "form", "xtype": "panel", "items": merge_to32, "anchor": "-20", "labelAlign": "top" }, keep_volatiles_panel43, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": reason44, "anchor": "-20", "labelAlign": "top" } ];
    this.fields = [ merge_to32, pcsw_Dispense33, pcsw_Coaching34, cv_LanguageKnowledge38, properties_PersonProperty39, reason44 ];
    Lino.pcsw.Clients.merge_row_ActionFormPanel.superclass.initComponent.call(this);
  }
});


Lino.pcsw.Clients.wf1_ActionFormPanel = Ext.extend(Lino.ActionFormPanel,{
  autoScroll: false,
  border: false,
  layout: "vbox",
  labelWidth: 63,
  hideCheckBoxLabels: true,
  frame: true,
  layoutConfig: { "align": "stretch" },
  bodyBorder: false,
  labelAlign: "top",
  action_name: 'wf1',
  ls_url: "/pcsw/Clients",
  window_title: "Refuse",
  initComponent : function() {
    var containing_panel = this;
    var reason27 = new Lino.ChoicesFieldElement({ "autoHeight": true, "forceSelection": true, "fieldLabel": "reason", "allowBlank": false, "hiddenName": "reasonHidden", "listeners": { "render": Lino.quicktip_renderer("reason","(<RefuseClient wf1 (u'Refuse')>.reason) ") }, "selectOnFocus": true, "anchor": "-20", "store": Lino.pcsw.RefusalReasons, "name": "reason" });
    var remark28 = new Ext.form.TextArea({ "listeners": { "render": Lino.quicktip_renderer("Remark","(<RefuseClient wf1 (u'Refuse')>.remark) ") }, "fieldLabel": "Remark", "name": "remark", "growMax": 2000, "selectOnFocus": true, "anchor": "-20 -10" });
    this.items = [ { "items": reason27, "autoHeight": true, "layout": "form", "xtype": "panel", "labelAlign": "top" }, { "items": remark28, "labelAlign": "top", "layout": "form", "xtype": "panel", "flex": 83 } ];
    this.fields = [ reason27, remark28 ];
    Lino.pcsw.Clients.wf1_ActionFormPanel.superclass.initComponent.call(this);
  }
});


Lino.reception.Clients.create_visit_ActionFormPanel = Ext.extend(Lino.ActionFormPanel,{
  autoScroll: false,
  autoHeight: true,
  border: false,
  layout: "form",
  labelWidth: 63,
  hideCheckBoxLabels: true,
  frame: true,
  bodyBorder: false,
  labelAlign: "top",
  action_name: 'create_visit',
  ls_url: "/reception/Clients",
  window_title: "Create visit",
  autoHeight: true,
  initComponent : function() {
    var containing_panel = this;
    var user53 = new Lino.TwinCombo({ "preferred_width": 15, "autoHeight": true, "fieldLabel": "User", "allowBlank": false, "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.users.Users.detail)}, "emptyText": "Select a User...", "listeners": { "render": Lino.quicktip_renderer("User","(<CreateClientVisit create_visit (u'Create visit')>.user) ") }, "selectOnFocus": true, "hiddenName": "userHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/apchoices/reception/Clients/create_visit/user", "method": "GET" }) }), "name": "user" });
    var summary54 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Reason", "name": "summary", "maxLength": null, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Reason","(<CreateClientVisit create_visit (u'Create visit')>.summary) ") }, "anchor": "-20" });
    this.items = [ { "autoHeight": true, "layout": "form", "xtype": "panel", "items": user53, "anchor": "-20", "labelAlign": "top" }, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": summary54, "anchor": "-20", "labelAlign": "top" } ];
    this.fields = [ user53, summary54 ];
    Lino.reception.Clients.create_visit_ActionFormPanel.superclass.initComponent.call(this);
  }
});


Lino.cal.Guests.checkin_ActionFormPanel = Ext.extend(Lino.ActionFormPanel,{
  autoScroll: false,
  border: false,
  layout: "vbox",
  labelWidth: 270,
  hideCheckBoxLabels: true,
  frame: true,
  layoutConfig: { "align": "stretch" },
  bodyBorder: false,
  labelAlign: "top",
  action_name: 'checkin',
  ls_url: "/cal/Guests",
  window_title: "Checkin",
  initComponent : function() {
    var containing_panel = this;
    var notify_subject20 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Summary", "name": "notify_subject", "maxLength": 200, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Summary","(<CheckinVisitor checkin (u'Checkin')>.notify_subject) ") }, "anchor": "-20" });
    var notify_body21 = new Ext.form.TextArea({ "listeners": { "render": Lino.quicktip_renderer("Description","(<CheckinVisitor checkin (u'Checkin')>.notify_body) ") }, "fieldLabel": "Description", "name": "notify_body", "growMax": 2000, "selectOnFocus": true, "anchor": "-20 -10" });
    var notify_silent22 = new Ext.form.Checkbox({ "autoHeight": true, "hideLabel": true, "checked": false, "name": "notify_silent", "listeners": { "render": Lino.quicktip_renderer("Don't send email notification","(<CheckinVisitor checkin (u'Checkin')>.notify_silent) ") }, "boxLabel": "Don't send email notification", "selectOnFocus": true, "anchor": "-20" });
    this.items = [ { "items": notify_subject20, "autoHeight": true, "layout": "form", "xtype": "panel", "labelAlign": "top" }, { "items": notify_body21, "labelAlign": "top", "layout": "form", "xtype": "panel", "flex": 71 }, { "items": notify_silent22, "autoHeight": true, "layout": "form", "xtype": "panel", "labelAlign": "top" } ];
    this.fields = [ notify_subject20, notify_body21, notify_silent22 ];
    Lino.cal.Guests.checkin_ActionFormPanel.superclass.initComponent.call(this);
  }
});


Lino.cal.Guests.wf1_ActionFormPanel = Ext.extend(Lino.ActionFormPanel,{
  autoScroll: false,
  border: false,
  layout: "vbox",
  labelWidth: 270,
  hideCheckBoxLabels: true,
  frame: true,
  layoutConfig: { "align": "stretch" },
  bodyBorder: false,
  labelAlign: "top",
  action_name: 'wf1',
  ls_url: "/cal/Guests",
  window_title: "Accept",
  initComponent : function() {
    var containing_panel = this;
    var notify_subject6 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Summary", "name": "notify_subject", "maxLength": 200, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Summary","(<AcceptInvitation wf1 (u'Accept')>.notify_subject) ") }, "anchor": "-20" });
    var notify_body7 = new Ext.form.TextArea({ "listeners": { "render": Lino.quicktip_renderer("Description","(<AcceptInvitation wf1 (u'Accept')>.notify_body) ") }, "fieldLabel": "Description", "name": "notify_body", "growMax": 2000, "selectOnFocus": true, "anchor": "-20 -10" });
    var notify_silent8 = new Ext.form.Checkbox({ "autoHeight": true, "hideLabel": true, "checked": false, "name": "notify_silent", "listeners": { "render": Lino.quicktip_renderer("Don't send email notification","(<AcceptInvitation wf1 (u'Accept')>.notify_silent) ") }, "boxLabel": "Don't send email notification", "selectOnFocus": true, "anchor": "-20" });
    this.items = [ { "items": notify_subject6, "autoHeight": true, "layout": "form", "xtype": "panel", "labelAlign": "top" }, { "items": notify_body7, "labelAlign": "top", "layout": "form", "xtype": "panel", "flex": 71 }, { "items": notify_silent8, "autoHeight": true, "layout": "form", "xtype": "panel", "labelAlign": "top" } ];
    this.fields = [ notify_subject6, notify_body7, notify_silent8 ];
    Lino.cal.Guests.wf1_ActionFormPanel.superclass.initComponent.call(this);
  }
});


Lino.pcsw.Coachings.create_visit_ActionFormPanel = Ext.extend(Lino.ActionFormPanel,{
  autoScroll: false,
  autoHeight: true,
  border: false,
  layout: "form",
  labelWidth: 63,
  hideCheckBoxLabels: true,
  frame: true,
  bodyBorder: false,
  labelAlign: "top",
  action_name: 'create_visit',
  ls_url: "/pcsw/Coachings",
  window_title: "Create visit",
  autoHeight: true,
  initComponent : function() {
    var containing_panel = this;
    var user48 = new Lino.TwinCombo({ "preferred_width": 15, "autoHeight": true, "fieldLabel": "User", "allowBlank": false, "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.users.Users.detail)}, "emptyText": "Select a User...", "listeners": { "render": Lino.quicktip_renderer("User","(<CreateCoachingVisit create_visit (u'Create visit')>.user) ") }, "selectOnFocus": true, "hiddenName": "userHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/apchoices/pcsw/Coachings/create_visit/user", "method": "GET" }) }), "name": "user" });
    var summary49 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Reason", "name": "summary", "maxLength": null, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Reason","(<CreateCoachingVisit create_visit (u'Create visit')>.summary) ") }, "anchor": "-20" });
    this.items = [ { "autoHeight": true, "layout": "form", "xtype": "panel", "items": user48, "anchor": "-20", "labelAlign": "top" }, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": summary49, "anchor": "-20", "labelAlign": "top" } ];
    this.fields = [ user48, summary49 ];
    Lino.pcsw.Coachings.create_visit_ActionFormPanel.superclass.initComponent.call(this);
  }
});


Lino.cal.Guests.wf2_ActionFormPanel = Ext.extend(Lino.ActionFormPanel,{
  autoScroll: false,
  border: false,
  layout: "vbox",
  labelWidth: 270,
  hideCheckBoxLabels: true,
  frame: true,
  layoutConfig: { "align": "stretch" },
  bodyBorder: false,
  labelAlign: "top",
  action_name: 'wf2',
  ls_url: "/cal/Guests",
  window_title: "Reject",
  initComponent : function() {
    var containing_panel = this;
    var notify_subject13 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Summary", "name": "notify_subject", "maxLength": 200, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Summary","(<RejectInvitation wf2 (u'Reject')>.notify_subject) ") }, "anchor": "-20" });
    var notify_body14 = new Ext.form.TextArea({ "listeners": { "render": Lino.quicktip_renderer("Description","(<RejectInvitation wf2 (u'Reject')>.notify_body) ") }, "fieldLabel": "Description", "name": "notify_body", "growMax": 2000, "selectOnFocus": true, "anchor": "-20 -10" });
    var notify_silent15 = new Ext.form.Checkbox({ "autoHeight": true, "hideLabel": true, "checked": false, "name": "notify_silent", "listeners": { "render": Lino.quicktip_renderer("Don't send email notification","(<RejectInvitation wf2 (u'Reject')>.notify_silent) ") }, "boxLabel": "Don't send email notification", "selectOnFocus": true, "anchor": "-20" });
    this.items = [ { "items": notify_subject13, "autoHeight": true, "layout": "form", "xtype": "panel", "labelAlign": "top" }, { "items": notify_body14, "labelAlign": "top", "layout": "form", "xtype": "panel", "flex": 71 }, { "items": notify_silent15, "autoHeight": true, "layout": "form", "xtype": "panel", "labelAlign": "top" } ];
    this.fields = [ notify_subject13, notify_body14, notify_silent15 ];
    Lino.cal.Guests.wf2_ActionFormPanel.superclass.initComponent.call(this);
  }
});


Lino.newcomers.AvailableCoachesByClient.assign_coach_ActionFormPanel = Ext.extend(Lino.ActionFormPanel,{
  autoScroll: false,
  border: false,
  layout: "vbox",
  labelWidth: 270,
  hideCheckBoxLabels: true,
  frame: true,
  layoutConfig: { "align": "stretch" },
  bodyBorder: false,
  labelAlign: "top",
  action_name: 'assign_coach',
  ls_url: "/newcomers/AvailableCoachesByClient",
  window_title: "Assign",
  initComponent : function() {
    var containing_panel = this;
    var notify_subject58 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Summary", "name": "notify_subject", "maxLength": 200, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Summary","(<AssignCoach assign_coach (u'Assign')>.notify_subject) ") }, "anchor": "-20" });
    var notify_body59 = new Ext.form.TextArea({ "listeners": { "render": Lino.quicktip_renderer("Description","(<AssignCoach assign_coach (u'Assign')>.notify_body) ") }, "fieldLabel": "Description", "name": "notify_body", "growMax": 2000, "selectOnFocus": true, "anchor": "-20 -10" });
    var notify_silent60 = new Ext.form.Checkbox({ "autoHeight": true, "hideLabel": true, "checked": false, "name": "notify_silent", "listeners": { "render": Lino.quicktip_renderer("Don't send email notification","(<AssignCoach assign_coach (u'Assign')>.notify_silent) ") }, "boxLabel": "Don't send email notification", "selectOnFocus": true, "anchor": "-20" });
    this.items = [ { "items": notify_subject58, "autoHeight": true, "layout": "form", "xtype": "panel", "labelAlign": "top" }, { "items": notify_body59, "labelAlign": "top", "layout": "form", "xtype": "panel", "flex": 71 }, { "items": notify_silent60, "autoHeight": true, "layout": "form", "xtype": "panel", "labelAlign": "top" } ];
    this.fields = [ notify_subject58, notify_body59, notify_silent60 ];
    Lino.newcomers.AvailableCoachesByClient.assign_coach_ActionFormPanel.superclass.initComponent.call(this);
  }
});


Lino.contacts.Companies.merge_row_ActionFormPanel = Ext.extend(Lino.ActionFormPanel,{
  autoScroll: false,
  autoHeight: true,
  border: false,
  layout: "form",
  labelWidth: 72,
  hideCheckBoxLabels: true,
  frame: true,
  bodyBorder: false,
  labelAlign: "top",
  action_name: 'merge_row',
  ls_url: "/contacts/Companies",
  window_title: "Merge",
  autoHeight: true,
  initComponent : function() {
    var containing_panel = this;
    var merge_to1 = new Lino.TwinCombo({ "preferred_width": 20, "autoHeight": true, "fieldLabel": "into...", "allowBlank": false, "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.contacts.Companies.detail)}, "emptyText": "Select a Company...", "listeners": { "render": Lino.quicktip_renderer("into...","(<MergeAction merge_row (u'Merge')>.merge_to) ") }, "selectOnFocus": true, "hiddenName": "merge_toHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/apchoices/contacts/Companies/merge_row/merge_to", "method": "GET" }) }), "name": "merge_to" });
    var reason2 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Reason", "name": "reason", "listeners": { "render": Lino.quicktip_renderer("Reason","(<MergeAction merge_row (u'Merge')>.reason) ") }, "maxLength": 100, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    this.items = [ { "autoHeight": true, "layout": "form", "xtype": "panel", "items": merge_to1, "anchor": "-20", "labelAlign": "top" }, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": reason2, "anchor": "-20", "labelAlign": "top" } ];
    this.fields = [ merge_to1, reason2 ];
    Lino.contacts.Companies.merge_row_ActionFormPanel.superclass.initComponent.call(this);
  }
});


Lino.isip.Contracts.InsertFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  autoHeight: true,
  content_type: 64,
  initComponent : function() {
    var containing_panel = this;
    var client2288 = new Lino.TwinCombo({ "preferred_width": 20, "autoHeight": true, "fieldLabel": "Client", "allowBlank": false, "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.pcsw.Clients.detail)}, "emptyText": "Select a Client...", "listeners": { "render": Lino.quicktip_renderer("Klient","(isip.Contracts.client) ") }, "selectOnFocus": true, "hiddenName": "clientHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/isip/Contracts/client", "method": "GET" }) }), "name": "client" });
    var type2289 = new Lino.TwinCombo({ "preferred_width": 20, "autoHeight": true, "fieldLabel": "Contract Type", "name": "type", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.isip.ContractTypes.detail)}, "hiddenName": "typeHidden", "listeners": { "render": Lino.quicktip_renderer("Vertragsart","(isip.Contracts.type) ") }, "selectOnFocus": true, "emptyText": "Select a ISIP Type...", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/isip/Contracts/type", "method": "GET" }) }) });
    var company2290 = new Lino.TwinCombo({ "preferred_width": 20, "autoHeight": true, "fieldLabel": "Company", "name": "company", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.contacts.Companies.detail)}, "hiddenName": "companyHidden", "listeners": { "render": Lino.quicktip_renderer("Organisation","(isip.Contracts.company) ") }, "selectOnFocus": true, "emptyText": "Select a Company...", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/isip/Contracts/company", "method": "GET" }) }) });
    var main_2_panel2291 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": type2289, "labelAlign": "top" }, { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": company2290, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 117, "border": false, "anchor": "-20", "labelAlign": "top" });
    var main_panel2294 = new Ext.Panel({ "hideCheckBoxLabels": true, "autoHeight": true, "border": false, "layout": "form", "labelWidth": 63, "autoScroll": false, "items": [ { "autoHeight": true, "layout": "form", "xtype": "panel", "items": client2288, "anchor": "-20", "labelAlign": "top" }, main_2_panel2291 ], "frame": true, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel2294;
    this.before_row_edit = function(record) {
    }
    Lino.isip.Contracts.InsertFormPanel.superclass.initComponent.call(this);
    // active_fields:
    company2290.on("change",function(){this.save()},this);
  }
});


Lino.outbox.Mails.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 31,
  initComponent : function() {
    var containing_panel = this;
    var subject243 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Subject", "name": "subject", "maxLength": 200, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Betreff","(outbox.Mails.subject) ") }, "anchor": "-20" });
    var project244 = new Lino.TwinCombo({ "preferred_width": 20, "autoHeight": true, "fieldLabel": "Client", "name": "project", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.pcsw.Clients.detail)}, "hiddenName": "projectHidden", "listeners": { "render": Lino.quicktip_renderer("Klient","(outbox.Mails.project) ") }, "selectOnFocus": true, "emptyText": "Select a Client...", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/outbox/Mails/project", "method": "GET" }) }) });
    var date245 = new Lino.DateField({ "autoHeight": true, "allowBlank": false, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Date</span>", "name": "date", "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Datum","(outbox.Mails.date) \n        The official date to be printed on the document.\n        ") }, "anchor": "-20" });
    var main_1_panel246 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 72, "hideCheckBoxLabels": true, "items": [ { "flex": 42, "autoHeight": true, "layout": "form", "xtype": "panel", "items": subject243, "labelAlign": "top" }, { "flex": 40, "autoHeight": true, "layout": "form", "xtype": "panel", "items": project244, "labelAlign": "top" }, { "flex": 16, "autoHeight": true, "layout": "form", "xtype": "panel", "items": date245, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var user250 = new Lino.TwinCombo({ "preferred_width": 15, "autoHeight": true, "fieldLabel": "Sender", "name": "user", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.users.Users.detail)}, "hiddenName": "userHidden", "listeners": { "render": Lino.quicktip_renderer("Absender","(outbox.Mails.user) ") }, "selectOnFocus": true, "emptyText": "Select a User...", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/outbox/Mails/user", "method": "GET" }) }) });
    var sent251 = new Ext.form.DisplayField({ "disabled": true, "autoHeight": true, "fieldLabel": "sent", "name": "sent", "listeners": { "render": Lino.quicktip_renderer("sent","(outbox.Mails.sent) ") }, "value": "<br>", "anchor": "-20" });
    var id252 = new Ext.form.NumberField({ "autoHeight": true, "fieldLabel": "ID", "name": "id", "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("ID","(outbox.Mails.id) ") }, "anchor": "-20" });
    var owner_disp253 = new Ext.form.DisplayField({ "disabled": true, "autoHeight": true, "fieldLabel": "Controlled by", "anchor": "-20", "name": "owner" });
    var main_2_panel254 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 126, "hideCheckBoxLabels": true, "items": [ { "flex": 39, "autoHeight": true, "layout": "form", "xtype": "panel", "items": user250, "labelAlign": "top" }, { "flex": 31, "autoHeight": true, "layout": "form", "xtype": "panel", "items": sent251, "labelAlign": "top" }, { "flex": 9, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id252, "labelAlign": "top" }, { "flex": 19, "autoHeight": true, "layout": "form", "xtype": "panel", "items": owner_disp253, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var RecipientsByMail_grid265 = new Lino.outbox.RecipientsByMail.GridPanel({ "flex": 55, "listeners": { "render": Lino.quicktip_renderer("Empf\u00e4nger","(outbox.outbox.RecipientsByMail) ") }, "hide_top_toolbar": true, "containing_panel": this, "tools": [ Lino.show_in_own_window_button(Lino.outbox.RecipientsByMail.grid) ], "preview_limit": 15, "master_panel": this });
    var AttachmentsByMail_htmlbox266 = new Lino.HtmlBoxPanel({ "flex": 22, "layout": "fit", "name": "AttachmentsByMail", "containing_panel": this, "items": new Ext.BoxComponent({autoScroll:true}), "title": "Attachments", "master_panel": this, "value": "<br/>", "always_enabled": true, "listeners": { "render": Lino.quicktip_renderer("Anh\u00e4nge","(outbox.Mails.AttachmentsByMail) ") }, "bodyStyle": "overflow-x:hidden;", "tools": [ Lino.show_in_own_window_button(Lino.outbox.AttachmentsByMail.grid) ] });
    var UploadsByController_htmlbox267 = new Lino.HtmlBoxPanel({ "flex": 22, "ls_bbar_actions": [ { "itemId": "insert", "menu_item_text": "New", "must_save": true, "tooltip": "Insert a new record", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-add", "overflowText": "New", "auto_save": true } ], "name": "UploadsByController", "containing_panel": this, "items": new Ext.BoxComponent({autoScroll:true}), "title": "Uploads", "master_panel": this, "value": "<br/>", "always_enabled": true, "listeners": { "render": Lino.quicktip_renderer("Uploads","(outbox.Mails.UploadsByController) ") }, "bodyStyle": "overflow-x:hidden;", "ls_insert_handler": Lino.uploads.UploadsByController.insert, "layout": "fit", "tools": [ Lino.show_in_own_window_button(Lino.uploads.UploadsByController.grid) ] });
    var main_3_panel268 = new Ext.Panel({ "flex": 29, "border": false, "layout": "hbox", "labelWidth": 72, "hideCheckBoxLabels": true, "items": [ RecipientsByMail_grid265, AttachmentsByMail_htmlbox266, UploadsByController_htmlbox267 ], "autoScroll": false, "layoutConfig": { "align": "stretch" }, "frame": false, "labelAlign": "top" });
    var body269 = new Lino.RichTextPanel({ "selectOnFocus": true, "flex": 58, "containing_panel": this, "name": "body", "title": "Body" });
    var main_panel270 = new Ext.Panel({ "autoScroll": false, "border": false, "layout": "vbox", "labelWidth": 0, "hideCheckBoxLabels": true, "items": [ main_1_panel246, main_2_panel254, main_3_panel268, body269 ], "frame": true, "layoutConfig": { "align": "stretch" }, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel270;
    this.before_row_edit = function(record) {
      RecipientsByMail_grid265.on_master_changed();
      AttachmentsByMail_htmlbox266.refresh();
      UploadsByController_htmlbox267.refresh();
      body269.refresh();
    }
    Lino.outbox.Mails.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.system.TextFieldTemplates.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 2,
  initComponent : function() {
    var containing_panel = this;
    var id2900 = new Ext.form.NumberField({ "autoHeight": true, "fieldLabel": "ID", "name": "id", "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("ID","(system.TextFieldTemplates.id) ") }, "anchor": "-20" });
    var name2901 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Designation", "name": "name", "listeners": { "render": Lino.quicktip_renderer("Bezeichnung","(system.TextFieldTemplates.name) ") }, "maxLength": 200, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var user2902 = new Lino.TwinCombo({ "preferred_width": 15, "autoHeight": true, "fieldLabel": "Author", "name": "user", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.users.Users.detail)}, "hiddenName": "userHidden", "listeners": { "render": Lino.quicktip_renderer("Autor","(system.TextFieldTemplates.user) ") }, "selectOnFocus": true, "emptyText": "Select a User...", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/system/TextFieldTemplates/user", "method": "GET" }) }) });
    var team2903 = new Lino.RemoteComboFieldElement({ "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Team</span>", "name": "team", "pageSize": 20, "emptyText": "Select a Team...", "listeners": { "render": Lino.quicktip_renderer("Team","(system.TextFieldTemplates.team) If not empty, then this template is reserved to members of this team.") }, "selectOnFocus": true, "hiddenName": "teamHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/system/TextFieldTemplates/team", "method": "GET" }) }) });
    var main_1_panel2904 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 7, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id2900, "labelAlign": "top" }, { "flex": 31, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name2901, "labelAlign": "top" }, { "flex": 30, "autoHeight": true, "layout": "form", "xtype": "panel", "items": user2902, "labelAlign": "top" }, { "flex": 30, "autoHeight": true, "layout": "form", "xtype": "panel", "items": team2903, "labelAlign": "top" } ], "region": "north", "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "split": true, "autoScroll": false, "labelWidth": 108, "border": false, "frame": false, "labelAlign": "top" });
    var description2909 = new Ext.form.TextArea({ "listeners": { "render": Lino.quicktip_renderer("Beschreibung","(system.TextFieldTemplates.description) ") }, "fieldLabel": "Description", "name": "description", "growMax": 2000, "selectOnFocus": true, "anchor": "-20 -10" });
    var text2910 = new Lino.RichTextPanel({ "flex": 5, "split": true, "containing_panel": this, "selectOnFocus": true, "region": "south", "title": "Template Text", "name": "text" });
    var main_panel2911 = new Lino.VBorderPanel({ "autoScroll": false, "border": false, "labelWidth": 117, "hideCheckBoxLabels": true, "items": [ main_1_panel2904, { "flex": 5, "layout": "form", "xtype": "panel", "items": description2909, "region": "center", "labelAlign": "top", "split": true }, text2910 ], "frame": true, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel2911;
    this.before_row_edit = function(record) {
      text2910.refresh();
    }
    Lino.system.TextFieldTemplates.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.accounts.Charts.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 49,
  initComponent : function() {
    var containing_panel = this;
    var id3620 = new Ext.form.NumberField({ "autoHeight": true, "fieldLabel": "ID", "name": "id", "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("ID","(accounts.Charts.id) ") }, "anchor": "-20" });
    var name3621 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Designation", "name": "name", "listeners": { "render": Lino.quicktip_renderer("Bezeichnung","(accounts.Charts.name) ") }, "maxLength": 200, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var name_fr3622 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Designation (fr)", "name": "name_fr", "maxLength": 200, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Bezeichnung (fr)","(accounts.Charts.name_fr) ") }, "anchor": "-20" });
    var name_de3623 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Designation (de)", "name": "name_de", "maxLength": 200, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Bezeichnung (de)","(accounts.Charts.name_de) ") }, "anchor": "-20" });
    var name_nl3624 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Designation (nl)", "name": "name_nl", "listeners": { "render": Lino.quicktip_renderer("Bezeichnung (nl)","(accounts.Charts.name_nl) ") }, "maxLength": 200, "selectOnFocus": true, "hidden": true, "anchor": "-20" });
    var main_1_panel3625 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 153, "hideCheckBoxLabels": true, "items": [ { "flex": 5, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id3620, "labelAlign": "top" }, { "flex": 23, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name3621, "labelAlign": "top" }, { "flex": 23, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_fr3622, "labelAlign": "top" }, { "flex": 23, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_de3623, "labelAlign": "top" }, { "flex": 23, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_nl3624, "hidden": true, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var GroupsByChart_grid3669 = new Lino.accounts.GroupsByChart.GridPanel({ "flex": 83, "listeners": { "render": Lino.quicktip_renderer("Kontengruppen","(accounts.accounts.GroupsByChart) ") }, "hide_top_toolbar": true, "containing_panel": this, "tools": [ Lino.show_in_own_window_button(Lino.accounts.GroupsByChart.grid) ], "preview_limit": 15, "master_panel": this });
    var main_panel3670 = new Ext.Panel({ "autoScroll": false, "border": false, "layout": "vbox", "hideCheckBoxLabels": true, "items": [ main_1_panel3625, GroupsByChart_grid3669 ], "frame": true, "layoutConfig": { "align": "stretch" }, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel3670;
    this.before_row_edit = function(record) {
      GroupsByChart_grid3669.on_master_changed();
    }
    Lino.accounts.Charts.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.isip.ContractEndings.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 68,
  initComponent : function() {
    var containing_panel = this;
    var name3815 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "designation", "name": "name", "listeners": { "render": Lino.quicktip_renderer("Bezeichnung","(isip.ContractEndings.name) ") }, "maxLength": 200, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var use_in_isip3816 = new Ext.form.Checkbox({ "autoHeight": true, "hideLabel": true, "checked": true, "name": "use_in_isip", "listeners": { "render": Lino.quicktip_renderer("VSE","(isip.ContractEndings.use_in_isip) ") }, "boxLabel": "ISIP", "selectOnFocus": true, "anchor": "-20" });
    var use_in_jobs3817 = new Ext.form.Checkbox({ "autoHeight": true, "hideLabel": true, "checked": true, "name": "use_in_jobs", "listeners": { "render": Lino.quicktip_renderer("Art.60\u00a77","(isip.ContractEndings.use_in_jobs) ") }, "boxLabel": "Art.60\u00a77", "selectOnFocus": true, "anchor": "-20" });
    var is_success3818 = new Ext.form.Checkbox({ "autoHeight": true, "hideLabel": true, "checked": false, "name": "is_success", "listeners": { "render": Lino.quicktip_renderer("Erfolgreich abgeschlossen","(isip.ContractEndings.is_success) ") }, "boxLabel": "Success", "selectOnFocus": true, "anchor": "-20" });
    var needs_date_ended3819 = new Ext.form.Checkbox({ "autoHeight": true, "hideLabel": true, "checked": false, "name": "needs_date_ended", "listeners": { "render": Lino.quicktip_renderer("erfordert Enddatum","(isip.ContractEndings.needs_date_ended) ") }, "boxLabel": "Require date ended", "selectOnFocus": true, "anchor": "-20" });
    var main_2_panel3820 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 234, "hideCheckBoxLabels": true, "items": [ { "flex": 25, "autoHeight": true, "layout": "form", "xtype": "panel", "items": use_in_isip3816, "labelAlign": "top" }, { "flex": 25, "autoHeight": true, "layout": "form", "xtype": "panel", "items": use_in_jobs3817, "labelAlign": "top" }, { "flex": 25, "autoHeight": true, "layout": "form", "xtype": "panel", "items": is_success3818, "labelAlign": "top" }, { "flex": 25, "autoHeight": true, "layout": "form", "xtype": "panel", "items": needs_date_ended3819, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var isip_ContractsByEnding_grid3845 = new Lino.isip.ContractsByEnding.GridPanel({ "flex": 41, "hide_top_toolbar": true, "containing_panel": this, "params_panel_hidden": true, "master_panel": this, "preview_limit": 15, "listeners": { "render": Lino.quicktip_renderer("VSEs","(isip.isip.ContractsByEnding) ") }, "tools": [ Lino.show_in_own_window_button(Lino.isip.ContractsByEnding.grid) ] });
    var jobs_ContractsByEnding_grid3873 = new Lino.jobs.ContractsByEnding.GridPanel({ "flex": 41, "hide_top_toolbar": true, "containing_panel": this, "params_panel_hidden": true, "master_panel": this, "preview_limit": 15, "listeners": { "render": Lino.quicktip_renderer("Art.60\u00a77-Konventionen","(jobs.jobs.ContractsByEnding) ") }, "tools": [ Lino.show_in_own_window_button(Lino.jobs.ContractsByEnding.grid) ] });
    var main_panel3874 = new Ext.Panel({ "autoScroll": false, "border": false, "layout": "vbox", "labelWidth": 108, "hideCheckBoxLabels": true, "items": [ { "items": name3815, "autoHeight": true, "layout": "form", "xtype": "panel", "labelAlign": "top" }, main_2_panel3820, isip_ContractsByEnding_grid3845, jobs_ContractsByEnding_grid3873 ], "frame": true, "layoutConfig": { "align": "stretch" }, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel3874;
    this.before_row_edit = function(record) {
      isip_ContractsByEnding_grid3845.on_master_changed();
      jobs_ContractsByEnding_grid3873.on_master_changed();
    }
    Lino.isip.ContractEndings.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.system.ContentTypes.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 6,
  initComponent : function() {
    var containing_panel = this;
    var id3147 = new Ext.form.NumberField({ "autoHeight": true, "fieldLabel": "ID", "name": "id", "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("ID","(system.ContentTypes.id) ") }, "anchor": "-20" });
    var name3148 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "name", "name": "name", "listeners": { "render": Lino.quicktip_renderer("name","(system.ContentTypes.name) ") }, "maxLength": 100, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var app_label3149 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "app label", "name": "app_label", "listeners": { "render": Lino.quicktip_renderer("app label","(system.ContentTypes.app_label) ") }, "maxLength": 100, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var model3150 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "python model class name", "name": "model", "listeners": { "render": Lino.quicktip_renderer("Python Modell-Klassenname","(system.ContentTypes.model) ") }, "maxLength": 100, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var base_classes_disp3151 = new Ext.form.DisplayField({ "autoHeight": true, "fieldLabel": "Base classes", "name": "base_classes", "value": "<br/>", "always_enabled": true, "disabled": true, "listeners": { "render": Lino.quicktip_renderer("Base classes","(system.ContentTypes.base_classes) ") }, "anchor": "-20" });
    var main_1_panel3152 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 234, "hideCheckBoxLabels": true, "items": [ { "flex": 5, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id3147, "labelAlign": "top" }, { "flex": 21, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name3148, "labelAlign": "top" }, { "flex": 21, "autoHeight": true, "layout": "form", "xtype": "panel", "items": app_label3149, "labelAlign": "top" }, { "flex": 21, "autoHeight": true, "layout": "form", "xtype": "panel", "items": model3150, "labelAlign": "top" }, { "flex": 30, "autoHeight": true, "layout": "form", "xtype": "panel", "items": base_classes_disp3151, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var system_HelpTextsByModel_grid3164 = new Lino.system.HelpTextsByModel.GridPanel({ "flex": 62, "listeners": { "render": Lino.quicktip_renderer("Hilfetexte","(system.system.HelpTextsByModel) ") }, "hide_top_toolbar": true, "containing_panel": this, "tools": [ Lino.show_in_own_window_button(Lino.system.HelpTextsByModel.grid) ], "preview_limit": 15, "master_panel": this });
    var main_panel3165 = new Ext.Panel({ "autoScroll": false, "border": false, "layout": "vbox", "hideCheckBoxLabels": true, "items": [ main_1_panel3152, system_HelpTextsByModel_grid3164 ], "frame": true, "layoutConfig": { "align": "stretch" }, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel3165;
    this.before_row_edit = function(record) {
      system_HelpTextsByModel_grid3164.on_master_changed();
    }
    Lino.system.ContentTypes.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.cbss.RetrieveTIGroupsRequests.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 94,
  initComponent : function() {
    var containing_panel = this;
    var id5042 = new Ext.form.NumberField({ "autoHeight": true, "fieldLabel": "ID", "name": "id", "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("ID","(cbss.RetrieveTIGroupsRequests.id) ") }, "anchor": "-20" });
    var person5043 = new Lino.TwinCombo({ "preferred_width": 20, "autoHeight": true, "fieldLabel": "Client", "allowBlank": false, "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.pcsw.Clients.detail)}, "emptyText": "Select a Client...", "listeners": { "render": Lino.quicktip_renderer("Klient","(cbss.RetrieveTIGroupsRequests.person) ") }, "selectOnFocus": true, "hiddenName": "personHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cbss/RetrieveTIGroupsRequests/person", "method": "GET" }) }), "name": "person" });
    var user5044 = new Lino.TwinCombo({ "preferred_width": 15, "autoHeight": true, "fieldLabel": "Author", "allowBlank": false, "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.users.Users.detail)}, "emptyText": "Select a User...", "listeners": { "render": Lino.quicktip_renderer("Autor","(cbss.RetrieveTIGroupsRequests.user) ") }, "selectOnFocus": true, "hiddenName": "userHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cbss/RetrieveTIGroupsRequests/user", "method": "GET" }) }), "name": "user" });
    var environment5045 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "T/A/B", "name": "environment", "boxMinWidth": Lino.chars2width(4), "disabled": true, "listeners": { "render": Lino.quicktip_renderer("T/A/B","(cbss.RetrieveTIGroupsRequests.environment) ") }, "maxLength": 4, "anchor": "-20" });
    var sent5046 = new Ext.form.DisplayField({ "disabled": true, "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Sent</span>", "name": "sent", "listeners": { "render": Lino.quicktip_renderer("Versendet","(cbss.RetrieveTIGroupsRequests.sent) The date and time when this request has been executed. \nThis is empty for requests than haven't been sent.\nRead-only.") }, "value": "<br>", "anchor": "-20" });
    var status5047 = new Lino.ChoicesFieldElement({ "autoHeight": true, "forceSelection": true, "fieldLabel": "State", "name": "status", "hiddenName": "statusHidden", "disabled": true, "listeners": { "render": Lino.quicktip_renderer("Zustand","(cbss.RetrieveTIGroupsRequests.status) ") }, "anchor": "-20", "store": [['','<br>']].concat(Lino.cbss.RequestStates) });
    var ticket5048 = new Ext.form.TextField({ "disabled": true, "autoHeight": true, "fieldLabel": "Ticket", "name": "ticket", "maxLength": 36, "listeners": { "render": Lino.quicktip_renderer("Ticket","(cbss.RetrieveTIGroupsRequests.ticket) ") }, "anchor": "-20" });
    var info_1_panel5049 = new Ext.form.FieldSet({ "autoHeight": true, "layout": "hbox", "title": "Request information", "layoutConfig": { "align": "stretchmax" }, "frame": false, "bodyBorder": true, "autoScroll": false, "items": [ { "flex": 5, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id5042, "labelAlign": "top" }, { "flex": 20, "autoHeight": true, "layout": "form", "xtype": "panel", "items": person5043, "labelAlign": "top" }, { "flex": 20, "autoHeight": true, "layout": "form", "xtype": "panel", "items": user5044, "labelAlign": "top" }, { "flex": 5, "autoHeight": true, "layout": "form", "xtype": "panel", "items": environment5045, "labelAlign": "top" }, { "flex": 16, "autoHeight": true, "layout": "form", "xtype": "panel", "items": sent5046, "labelAlign": "top" }, { "flex": 12, "autoHeight": true, "layout": "form", "xtype": "panel", "items": status5047, "labelAlign": "top" }, { "flex": 21, "autoHeight": true, "layout": "form", "xtype": "panel", "items": ticket5048, "labelAlign": "top" } ], "hideCheckBoxLabels": true, "labelWidth": 90, "border": false, "labelAlign": "top" });
    var national_id5057 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "National ID", "name": "national_id", "maxLength": 200, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("NR-Nummer","(cbss.RetrieveTIGroupsRequests.national_id) ") }, "anchor": "-20" });
    var language5058 = new Lino.ChoicesFieldElement({ "autoHeight": true, "forceSelection": true, "fieldLabel": "Language", "name": "language", "hiddenName": "languageHidden", "listeners": { "render": Lino.quicktip_renderer("Sprache","(cbss.RetrieveTIGroupsRequests.language) ") }, "selectOnFocus": true, "anchor": "-20", "store": [['','<br>']].concat(Lino.cbss.RequestLanguages) });
    var history5059 = new Ext.form.Checkbox({ "autoHeight": true, "hideLabel": true, "checked": true, "name": "history", "listeners": { "render": Lino.quicktip_renderer("Historie","(cbss.RetrieveTIGroupsRequests.history) Whatever this means.") }, "boxLabel": "History", "selectOnFocus": true, "anchor": "-20" });
    var parameters_panel5060 = new Ext.form.FieldSet({ "autoHeight": true, "layout": "hbox", "title": "Parameters", "layoutConfig": { "align": "stretchmax" }, "frame": false, "bodyBorder": true, "autoScroll": false, "items": [ { "flex": 52, "autoHeight": true, "layout": "form", "xtype": "panel", "items": national_id5057, "labelAlign": "top" }, { "flex": 22, "autoHeight": true, "layout": "form", "xtype": "panel", "items": language5058, "labelAlign": "top" }, { "flex": 25, "autoHeight": true, "layout": "form", "xtype": "panel", "items": history5059, "labelAlign": "top" } ], "hideCheckBoxLabels": true, "labelWidth": 90, "border": false, "labelAlign": "top" });
    var cbss_RetrieveTIGroupsResult_grid5064 = new Lino.cbss.RetrieveTIGroupsResult.GridPanel({ "flex": 71, "listeners": { "render": Lino.quicktip_renderer("Resultate","(cbss.cbss.RetrieveTIGroupsResult) ") }, "hide_top_toolbar": true, "containing_panel": this, "tools": [ Lino.show_in_own_window_button(Lino.cbss.RetrieveTIGroupsResult.grid) ], "preview_limit": 15, "master_panel": this });
    var request_panel5065 = new Ext.Panel({ "layout": "vbox", "title": "Request", "items": [ info_1_panel5049, parameters_panel5060, cbss_RetrieveTIGroupsResult_grid5064 ], "frame": true, "layoutConfig": { "align": "stretch" }, "hideCheckBoxLabels": true, "listeners": { "activate": Lino.on_tab_activate }, "autoScroll": false, "border": false, "bodyBorder": false, "labelAlign": "top" });
    var response_xml5066 = new Ext.form.TextArea({ "disabled": true, "listeners": { "render": Lino.quicktip_renderer("Antwort","(cbss.RetrieveTIGroupsRequests.response_xml) The raw XML response received. \n") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Response</span>", "name": "response_xml", "growMax": 2000, "anchor": "-20 -10" });
    var info_messages5067 = new Ext.form.TextArea({ "disabled": true, "listeners": { "render": Lino.quicktip_renderer("Info-Meldungen","(cbss.RetrieveTIGroupsRequests.info_messages) ") }, "fieldLabel": "Info messages", "name": "info_messages", "growMax": 2000, "anchor": "-20 -10" });
    var debug_messages5068 = new Ext.form.TextArea({ "disabled": true, "listeners": { "render": Lino.quicktip_renderer("Debug-Meldungen","(cbss.RetrieveTIGroupsRequests.debug_messages) ") }, "fieldLabel": "Debug messages", "name": "debug_messages", "growMax": 2000, "anchor": "-20 -10" });
    var technical_panel5069 = new Lino.VBorderPanel({ "autoScroll": false, "listeners": { "activate": Lino.on_tab_activate }, "border": false, "labelWidth": 144, "title": "Technical", "hideCheckBoxLabels": true, "items": [ { "flex": 5, "layout": "form", "xtype": "panel", "items": response_xml5066, "region": "north", "labelAlign": "top", "split": true }, { "flex": 5, "layout": "form", "xtype": "panel", "items": info_messages5067, "region": "center", "labelAlign": "top", "split": true }, { "flex": 5, "layout": "form", "xtype": "panel", "items": debug_messages5068, "region": "south", "labelAlign": "top", "split": true } ], "frame": true, "bodyBorder": false, "labelAlign": "top" });
    var main_panel5073 = new Ext.TabPanel({ "hideCheckBoxLabels": true, "border": false, "split": true, "autoScroll": false, "items": [ request_panel5065, technical_panel5069 ], "activeTab": 0, "bodyBorder": false, "frame": true, "labelAlign": "top" });
    this.items = main_panel5073;
    this.before_row_edit = function(record) {
      cbss_RetrieveTIGroupsResult_grid5064.on_master_changed();
    }
    Lino.cbss.RetrieveTIGroupsRequests.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.system.SiteConfigs.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 4,
  initComponent : function() {
    var containing_panel = this;
    var site_company3046 = new Lino.TwinCombo({ "preferred_width": 20, "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">The company that runs this site</span>", "name": "site_company", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.contacts.Companies.detail)}, "hiddenName": "site_companyHidden", "listeners": { "render": Lino.quicktip_renderer("Firma, die diesen Site betreibt","(system.SiteConfigs.site_company) The Company to be used as sender in documents.") }, "selectOnFocus": true, "emptyText": "Select a Company...", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/system/SiteConfigs/site_company", "method": "GET" }) }) });
    var next_partner_id3047 = new Ext.form.NumberField({ "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Next partner id</span>", "name": "next_partner_id", "value": 100, "listeners": { "render": Lino.quicktip_renderer("N\u00e4chste Partnernummer","(system.SiteConfigs.next_partner_id) N\u00e4chste Partnernummer") }, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var general_1_panel3048 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 66, "autoHeight": true, "layout": "form", "xtype": "panel", "items": site_company3046, "labelAlign": "top" }, { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": next_partner_id3047, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 288, "border": false, "anchor": "-20", "labelAlign": "top" });
    var job_office3051 = new Lino.TwinCombo({ "preferred_width": 20, "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Local job office</span>", "name": "job_office", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.contacts.Companies.detail)}, "hiddenName": "job_officeHidden", "listeners": { "render": Lino.quicktip_renderer("Lokales Arbeitsamt","(system.SiteConfigs.job_office) The Company whose contact persons \n            will be choices for `Person.job_office_contact`.") }, "selectOnFocus": true, "emptyText": "Select a Company...", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/system/SiteConfigs/job_office", "method": "GET" }) }) });
    var debts_bailiff_type3052 = new Lino.RemoteComboFieldElement({ "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Bailiff</span>", "name": "debts_bailiff_type", "pageSize": 20, "emptyText": "Select a Client Contact type...", "listeners": { "render": Lino.quicktip_renderer("Gerichtsvollzieher","(system.SiteConfigs.debts_bailiff_type) Klientenkontaktart Gerichtsvollzieher") }, "selectOnFocus": true, "hiddenName": "debts_bailiff_typeHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/system/SiteConfigs/debts_bailiff_type", "method": "GET" }) }) });
    var master_budget3053 = new Lino.TwinCombo({ "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Master budget</span>", "name": "master_budget", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.debts.Budgets.detail)}, "emptyText": "Select a Budget...", "listeners": { "render": Lino.quicktip_renderer("Budget-Kopiervorlage","(system.SiteConfigs.master_budget) Das Budget, dessen Inhalt in neue Budgets kopiert wird.") }, "selectOnFocus": true, "hiddenName": "master_budgetHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/system/SiteConfigs/master_budget", "method": "GET" }) }) });
    var general_2_panel3054 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": job_office3051, "labelAlign": "top" }, { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": debts_bailiff_type3052, "labelAlign": "top" }, { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": master_budget3053, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 189, "border": false, "anchor": "-20", "labelAlign": "top" });
    var signer13058 = new Lino.TwinCombo({ "preferred_width": 20, "autoHeight": true, "fieldLabel": "Secretary", "name": "signer1", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.contacts.Persons.detail)}, "hiddenName": "signer1Hidden", "listeners": { "render": Lino.quicktip_renderer("Sekret\u00e4r","(system.SiteConfigs.signer1) ") }, "selectOnFocus": true, "emptyText": "Select a Person...", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/system/SiteConfigs/signer1", "method": "GET" }) }) });
    var signer23059 = new Lino.TwinCombo({ "preferred_width": 20, "autoHeight": true, "fieldLabel": "President", "name": "signer2", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.contacts.Persons.detail)}, "hiddenName": "signer2Hidden", "listeners": { "render": Lino.quicktip_renderer("Pr\u00e4sident","(system.SiteConfigs.signer2) ") }, "selectOnFocus": true, "emptyText": "Select a Person...", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/system/SiteConfigs/signer2", "method": "GET" }) }) });
    var general_3_panel3060 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": signer13058, "labelAlign": "top" }, { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": signer23059, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 90, "border": false, "anchor": "-20", "labelAlign": "top" });
    var signer1_function3063 = new Lino.RemoteComboFieldElement({ "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">First signer function</span>", "name": "signer1_function", "pageSize": 20, "emptyText": "Select a Function...", "listeners": { "render": Lino.quicktip_renderer("Funktion des ersten Unterzeichners","(system.SiteConfigs.signer1_function) Kontaktfunktion \"Sekret\u00e4r\"") }, "selectOnFocus": true, "hiddenName": "signer1_functionHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/system/SiteConfigs/signer1_function", "method": "GET" }) }) });
    var signer2_function3064 = new Lino.RemoteComboFieldElement({ "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Second signer function</span>", "name": "signer2_function", "pageSize": 20, "emptyText": "Select a Function...", "listeners": { "render": Lino.quicktip_renderer("Funktion des zweiten Unterzeichners","(system.SiteConfigs.signer2_function) Kontaktfunktion \"Pr\u00e4sident\"") }, "selectOnFocus": true, "hiddenName": "signer2_functionHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/system/SiteConfigs/signer2_function", "method": "GET" }) }) });
    var general_4_panel3065 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": signer1_function3063, "labelAlign": "top" }, { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": signer2_function3064, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 324, "border": false, "anchor": "-20", "labelAlign": "top" });
    var general_panel3068 = new Ext.Panel({ "autoHeight": true, "layout": "form", "title": "General", "items": [ general_1_panel3048, general_2_panel3054, general_3_panel3060, general_4_panel3065 ], "frame": true, "bodyBorder": false, "hideCheckBoxLabels": true, "listeners": { "activate": Lino.on_tab_activate }, "autoScroll": false, "border": false, "labelAlign": "top" });
    var system_note_type3069 = new Lino.TwinCombo({ "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Default system note type</span>", "name": "system_note_type", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.notes.EventTypes.detail)}, "emptyText": "Select a Event Type...", "listeners": { "render": Lino.quicktip_renderer("Default system note type","(system.SiteConfigs.system_note_type) Note Type used by system notes.\nIf this is empty, then system notes won't create any entry to the Notes table.") }, "selectOnFocus": true, "hiddenName": "system_note_typeHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/system/SiteConfigs/system_note_type", "method": "GET" }) }) });
    var default_build_method3070 = new Lino.ChoicesFieldElement({ "autoHeight": true, "fieldLabel": "Default build method", "name": "default_build_method", "value": "appyodt", "hiddenName": "default_build_methodHidden", "listeners": { "render": Lino.quicktip_renderer("Standard-Konstruktionsmethode","(system.SiteConfigs.default_build_method) ") }, "selectOnFocus": true, "anchor": "-20", "store": [ [ "appyodt", "AppyOdtBuildMethod" ], [ "appypdf", "AppyPdfBuildMethod" ], [ "appyrtf", "AppyRtfBuildMethod" ], [ "latex", "LatexBuildMethod" ], [ "pisa", "PisaBuildMethod" ], [ "rtf", "RtfBuildMethod" ] ] });
    var constants_1_panel3071 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": system_note_type3069, "labelAlign": "top" }, { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": default_build_method3070, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 270, "border": false, "anchor": "-20", "labelAlign": "top" });
    var propgroup_skills3074 = new Lino.TwinCombo({ "autoHeight": true, "fieldLabel": "Skills Property Group", "name": "propgroup_skills", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.properties.PropGroups.detail)}, "emptyText": "Select a Property Group...", "listeners": { "render": Lino.quicktip_renderer("Eigenschaftsgruppe F\u00e4higkeiten","(system.SiteConfigs.propgroup_skills) ") }, "selectOnFocus": true, "hiddenName": "propgroup_skillsHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/system/SiteConfigs/propgroup_skills", "method": "GET" }) }) });
    var propgroup_softskills3075 = new Lino.TwinCombo({ "autoHeight": true, "fieldLabel": "Soft Skills Property Group", "name": "propgroup_softskills", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.properties.PropGroups.detail)}, "emptyText": "Select a Property Group...", "listeners": { "render": Lino.quicktip_renderer("Eigenschaftsgruppe Sozialkompetenzen","(system.SiteConfigs.propgroup_softskills) ") }, "selectOnFocus": true, "hiddenName": "propgroup_softskillsHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/system/SiteConfigs/propgroup_softskills", "method": "GET" }) }) });
    var propgroup_obstacles3076 = new Lino.TwinCombo({ "autoHeight": true, "fieldLabel": "Obstacles Property Group", "name": "propgroup_obstacles", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.properties.PropGroups.detail)}, "emptyText": "Select a Property Group...", "listeners": { "render": Lino.quicktip_renderer("Eigenschaftsgruppe Hindernisse","(system.SiteConfigs.propgroup_obstacles) ") }, "selectOnFocus": true, "hiddenName": "propgroup_obstaclesHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/system/SiteConfigs/propgroup_obstacles", "method": "GET" }) }) });
    var constants_2_panel3077 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": propgroup_skills3074, "labelAlign": "top" }, { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": propgroup_softskills3075, "labelAlign": "top" }, { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": propgroup_obstacles3076, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 333, "border": false, "anchor": "-20", "labelAlign": "top" });
    var residence_permit_upload_type3081 = new Lino.RemoteComboFieldElement({ "autoHeight": true, "fieldLabel": "Upload Type for residence permit", "name": "residence_permit_upload_type", "pageSize": 20, "emptyText": "Select a Upload Type...", "listeners": { "render": Lino.quicktip_renderer("Upload-Art Aufenthaltserlaubnis","(system.SiteConfigs.residence_permit_upload_type) ") }, "selectOnFocus": true, "hiddenName": "residence_permit_upload_typeHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/system/SiteConfigs/residence_permit_upload_type", "method": "GET" }) }) });
    var work_permit_upload_type3082 = new Lino.RemoteComboFieldElement({ "autoHeight": true, "fieldLabel": "Upload Type for work permit", "name": "work_permit_upload_type", "pageSize": 20, "emptyText": "Select a Upload Type...", "listeners": { "render": Lino.quicktip_renderer("Upload-Art Arbeitserlaubnis","(system.SiteConfigs.work_permit_upload_type) ") }, "selectOnFocus": true, "hiddenName": "work_permit_upload_typeHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/system/SiteConfigs/work_permit_upload_type", "method": "GET" }) }) });
    var driving_licence_upload_type3083 = new Lino.RemoteComboFieldElement({ "autoHeight": true, "fieldLabel": "Upload Type for driving licence", "name": "driving_licence_upload_type", "pageSize": 20, "emptyText": "Select a Upload Type...", "listeners": { "render": Lino.quicktip_renderer("Upload-Art F\u00fchrerschein","(system.SiteConfigs.driving_licence_upload_type) ") }, "selectOnFocus": true, "hiddenName": "driving_licence_upload_typeHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/system/SiteConfigs/driving_licence_upload_type", "method": "GET" }) }) });
    var constants_3_panel3084 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": residence_permit_upload_type3081, "labelAlign": "top" }, { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": work_permit_upload_type3082, "labelAlign": "top" }, { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": driving_licence_upload_type3083, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 288, "border": false, "anchor": "-20", "labelAlign": "top" });
    var client_calendar3088 = new Lino.TwinCombo({ "autoHeight": true, "fieldLabel": "Default calendar for client events", "name": "client_calendar", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.cal.Calendars.detail)}, "emptyText": "Select a Calendar...", "listeners": { "render": Lino.quicktip_renderer("Kalender f\u00fcr Kliententermine","(system.SiteConfigs.client_calendar) ") }, "selectOnFocus": true, "hiddenName": "client_calendarHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/system/SiteConfigs/client_calendar", "method": "GET" }) }) });
    var prompt_calendar3089 = new Lino.TwinCombo({ "autoHeight": true, "fieldLabel": "Default calendar for prompt events", "name": "prompt_calendar", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.cal.Calendars.detail)}, "emptyText": "Select a Calendar...", "listeners": { "render": Lino.quicktip_renderer("Default calendar for prompt events","(system.SiteConfigs.prompt_calendar) ") }, "selectOnFocus": true, "hiddenName": "prompt_calendarHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/system/SiteConfigs/prompt_calendar", "method": "GET" }) }) });
    var constants_4_panel3090 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": client_calendar3088, "labelAlign": "top" }, { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": prompt_calendar3089, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 315, "border": false, "anchor": "-20", "labelAlign": "top" });
    var client_guestrole3093 = new Lino.TwinCombo({ "autoHeight": true, "fieldLabel": "Default guest role of client in events.", "name": "client_guestrole", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.cal.GuestRoles.detail)}, "emptyText": "Select a Guest Role...", "listeners": { "render": Lino.quicktip_renderer("Rolle des Klienten in Terminen","(system.SiteConfigs.client_guestrole) ") }, "selectOnFocus": true, "hiddenName": "client_guestroleHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/system/SiteConfigs/client_guestrole", "method": "GET" }) }) });
    var team_guestrole3094 = new Lino.TwinCombo({ "autoHeight": true, "fieldLabel": "Guest role for team members", "name": "team_guestrole", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.cal.GuestRoles.detail)}, "emptyText": "Select a Guest Role...", "listeners": { "render": Lino.quicktip_renderer("Rolle der anderen bei Gruppenterminen","(system.SiteConfigs.team_guestrole) ") }, "selectOnFocus": true, "hiddenName": "team_guestroleHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/system/SiteConfigs/team_guestrole", "method": "GET" }) }) });
    var constants_5_panel3095 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": client_guestrole3093, "labelAlign": "top" }, { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": team_guestrole3094, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 342, "border": false, "anchor": "-20", "labelAlign": "top" });
    var attestation_note_nature3098 = new Lino.TwinCombo({ "autoHeight": true, "fieldLabel": "Event type of attestations", "name": "attestation_note_nature", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.notes.EventTypes.detail)}, "emptyText": "Select a Event Type...", "listeners": { "render": Lino.quicktip_renderer("Event type of attestations","(system.SiteConfigs.attestation_note_nature) ") }, "selectOnFocus": true, "hiddenName": "attestation_note_natureHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/system/SiteConfigs/attestation_note_nature", "method": "GET" }) }) });
    var constants_panel3099 = new Ext.Panel({ "autoHeight": true, "layout": "form", "title": "Constants", "items": [ constants_1_panel3071, constants_2_panel3077, constants_3_panel3084, constants_4_panel3090, constants_5_panel3095, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": attestation_note_nature3098, "anchor": "-20", "labelAlign": "top" } ], "frame": true, "bodyBorder": false, "hideCheckBoxLabels": true, "listeners": { "activate": Lino.on_tab_activate }, "autoScroll": false, "labelWidth": 243, "border": false, "labelAlign": "top" });
    var cbss_org_unit3101 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Requesting organisation</span>", "name": "cbss_org_unit", "maxLength": 50, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Anfragende Organisation","(system.SiteConfigs.cbss_org_unit) In CBSS requests, identifies the requesting organization.\nFor PCSWs this is the enterprise number \n(CBE, KBO) and should have 10 digits and no formatting characters.\n\nUsed in SSDN requests as text of the `AuthorizedUser\\OrgUnit` element . \nUsed in new style requests as text of the `CustomerIdentification\\cbeNumber` element . \n") }, "anchor": "-20" });
    var sector3102 = new Lino.RemoteComboFieldElement({ "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Sector</span>", "name": "sector", "pageSize": 20, "emptyText": "Select a Sector...", "listeners": { "render": Lino.quicktip_renderer("Sektor","(system.SiteConfigs.sector) The CBSS sector/subsector of the requesting organization.        \nFor PCSWs this is always 17.1.\nUsed in SSDN requests as text of the `MatrixID` and `MatrixSubID` \nelements of `AuthorizedUser`. \nUsed in ManageAccess requests as default value \nfor the non-editable field `sector` \n(which defines the choices of the `purpose` field).\n") }, "selectOnFocus": true, "hiddenName": "sectorHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/system/SiteConfigs/sector", "method": "GET" }) }) });
    var ssdn_user_id3103 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">SSDN User Id</span>", "name": "ssdn_user_id", "maxLength": 50, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("SSDN User Id","(system.SiteConfigs.ssdn_user_id) Used in SSDN requests as text of the `AuthorizedUser\\UserID` element.\n") }, "anchor": "-20" });
    var ssdn_email3104 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">SSDN email address</span>", "name": "ssdn_email", "maxLength": 75, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("SSDN email address","(system.SiteConfigs.ssdn_email) Used in SSDN requests as text of the `AuthorizedUser\\Email` element.\n") }, "anchor": "-20" });
    var cbss_1_panel3105 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 25, "autoHeight": true, "layout": "form", "xtype": "panel", "items": cbss_org_unit3101, "labelAlign": "top" }, { "flex": 24, "autoHeight": true, "layout": "form", "xtype": "panel", "items": sector3102, "labelAlign": "top" }, { "flex": 25, "autoHeight": true, "layout": "form", "xtype": "panel", "items": ssdn_user_id3103, "labelAlign": "top" }, { "flex": 25, "autoHeight": true, "layout": "form", "xtype": "panel", "items": ssdn_email3104, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 216, "border": false, "anchor": "-20", "labelAlign": "top" });
    var cbss_http_username3110 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">HTTP username</span>", "name": "cbss_http_username", "maxLength": 50, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("HTTP username","(system.SiteConfigs.cbss_http_username) Used in the http header of new-style requests.\n") }, "anchor": "-20" });
    var cbss_http_password3111 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">HTTP password</span>", "name": "cbss_http_password", "maxLength": 50, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("HTTP password","(system.SiteConfigs.cbss_http_password) Used in the http header of new-style requests.\n") }, "anchor": "-20" });
    var cbss_2_panel3112 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": cbss_http_username3110, "labelAlign": "top" }, { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": cbss_http_password3111, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 126, "border": false, "anchor": "-20", "labelAlign": "top" });
    var cbss_panel3115 = new Ext.Panel({ "autoHeight": true, "layout": "form", "title": "CBSS", "items": [ cbss_1_panel3105, cbss_2_panel3112 ], "frame": true, "bodyBorder": false, "hideCheckBoxLabels": true, "listeners": { "activate": Lino.on_tab_activate }, "autoScroll": false, "border": false, "labelAlign": "top" });
    var main_panel3116 = new Ext.TabPanel({ "hideCheckBoxLabels": true, "border": false, "split": true, "autoScroll": false, "items": [ general_panel3068, constants_panel3099, cbss_panel3115 ], "activeTab": 0, "bodyBorder": false, "frame": true, "labelAlign": "top" });
    this.items = main_panel3116;
    this.before_row_edit = function(record) {
    }
    Lino.system.SiteConfigs.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.jobs.JobProviders.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 79,
  initComponent : function() {
    var containing_panel = this;
    var prefix1201 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "prefix", "name": "prefix", "maxLength": 200, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("prefix","(jobs.JobProviders.prefix) ") }, "anchor": "-20" });
    var name1202 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Name", "name": "name", "listeners": { "render": Lino.quicktip_renderer("Name","(jobs.JobProviders.name) ") }, "maxLength": 200, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var id1203 = new Ext.form.NumberField({ "autoHeight": true, "fieldLabel": "ID", "name": "id", "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("ID","(jobs.JobProviders.id) ") }, "anchor": "-20" });
    var language1204 = new Lino.ChoicesFieldElement({ "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Language</span>", "allowBlank": false, "hiddenName": "languageHidden", "listeners": { "render": Lino.quicktip_renderer("Sprache","(jobs.JobProviders.language) Die Sprache, in der Dokumente ausgestellt werden sollen.") }, "selectOnFocus": true, "anchor": "-20", "store": [ [ "en", "English" ], [ "fr", "French" ], [ "de", "German" ], [ "nl", "Dutch" ] ], "name": "language" });
    var intro_box_1_panel1205 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 31, "autoHeight": true, "layout": "form", "xtype": "panel", "items": prefix1201, "labelAlign": "top" }, { "flex": 31, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name1202, "labelAlign": "top" }, { "flex": 7, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id1203, "labelAlign": "top" }, { "flex": 29, "autoHeight": true, "layout": "form", "xtype": "panel", "items": language1204, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 72, "border": false, "anchor": "-20", "labelAlign": "top" });
    var vat_id1210 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "VAT id", "name": "vat_id", "maxLength": 200, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("MWSt.-Nr.","(jobs.JobProviders.vat_id) ") }, "anchor": "-20" });
    var activity1211 = new Lino.RemoteComboFieldElement({ "autoHeight": true, "fieldLabel": "activity", "name": "activity", "pageSize": 20, "emptyText": "Select a activity...", "listeners": { "render": Lino.quicktip_renderer("Beruf","(jobs.JobProviders.activity) ") }, "selectOnFocus": true, "hiddenName": "activityHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/jobs/JobProviders/activity", "method": "GET" }) }) });
    var type1212 = new Lino.RemoteComboFieldElement({ "autoHeight": true, "fieldLabel": "Company type", "name": "type", "pageSize": 20, "emptyText": "Select a company type...", "listeners": { "render": Lino.quicktip_renderer("Organisationsart","(jobs.JobProviders.type) ") }, "selectOnFocus": true, "hiddenName": "typeHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/jobs/JobProviders/type", "method": "GET" }) }) });
    var intro_box_2_panel1213 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 23, "autoHeight": true, "layout": "form", "xtype": "panel", "items": vat_id1210, "labelAlign": "top" }, { "flex": 38, "autoHeight": true, "layout": "form", "xtype": "panel", "items": activity1211, "labelAlign": "top" }, { "flex": 38, "autoHeight": true, "layout": "form", "xtype": "panel", "items": type1212, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 153, "border": false, "anchor": "-20", "labelAlign": "top" });
    var bank_account11217 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Bank account 1", "name": "bank_account1", "maxLength": 40, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Bankkonto 1","(jobs.JobProviders.bank_account1) ") }, "anchor": "-20" });
    var bank_account21218 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Bank account 2", "name": "bank_account2", "maxLength": 40, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Bankkonto 2","(jobs.JobProviders.bank_account2) ") }, "anchor": "-20" });
    var is_obsolete1219 = new Ext.form.Checkbox({ "autoHeight": true, "hideLabel": true, "checked": false, "name": "is_obsolete", "listeners": { "render": Lino.quicktip_renderer("veraltet","(jobs.JobProviders.is_obsolete) Altf\u00e4lle sind Partner, deren Stammdaten nicht mehr gepflegt werden und \nf\u00fcr neue Operationen nicht benutzt werden k\u00f6nnen.") }, "boxLabel": "obsolete", "selectOnFocus": true, "anchor": "-20" });
    var intro_box_3_panel1220 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 40, "autoHeight": true, "layout": "form", "xtype": "panel", "items": bank_account11217, "labelAlign": "top" }, { "flex": 40, "autoHeight": true, "layout": "form", "xtype": "panel", "items": bank_account21218, "labelAlign": "top" }, { "flex": 19, "autoHeight": true, "layout": "form", "xtype": "panel", "items": is_obsolete1219, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 108, "border": false, "anchor": "-20", "labelAlign": "top" });
    var intro_box_panel1224 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "form", "hideCheckBoxLabels": true, "items": [ intro_box_1_panel1205, intro_box_2_panel1213, intro_box_3_panel1220 ], "frame": true, "bodyBorder": false, "labelAlign": "top" });
    var country1225 = new Lino.TwinCombo({ "autoHeight": true, "fieldLabel": "Country", "name": "country", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.countries.Countries.detail)}, "emptyText": "Select a Country...", "listeners": { "render": Lino.quicktip_renderer("Land","(jobs.JobProviders.country) ") }, "selectOnFocus": true, "hiddenName": "countryHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/jobs/JobProviders/country", "method": "GET" }) }) });
    var region1226 = new Lino.TwinCombo({ "autoHeight": true, "fieldLabel": "Region", "name": "region", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.countries.Cities.detail)}, "emptyText": "Select a Place...", "listeners": { "render": Lino.quicktip_renderer("Region","(jobs.JobProviders.region) ") }, "selectOnFocus": true, "hiddenName": "regionHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/jobs/JobProviders/region", "method": "GET" }) }) });
    var box3_1_panel1227 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": country1225, "labelAlign": "top" }, { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": region1226, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 63, "border": false, "anchor": "-20", "labelAlign": "top" });
    var city1230 = new Lino.TwinCombo({ "autoHeight": true, "forceSelection": false, "fieldLabel": "Place", "name": "city", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.countries.Cities.detail)}, "emptyText": "Select a Place...", "listeners": { "render": Lino.quicktip_renderer("Ort","(jobs.JobProviders.city) ") }, "selectOnFocus": true, "hiddenName": "cityHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/jobs/JobProviders/city", "method": "GET" }) }) });
    var zip_code1231 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Zip code", "name": "zip_code", "boxMinWidth": Lino.chars2width(10), "listeners": { "render": Lino.quicktip_renderer("Postleitzahl","(jobs.JobProviders.zip_code) ") }, "maxLength": 10, "selectOnFocus": true, "anchor": "-20" });
    var box3_2_panel1232 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 66, "autoHeight": true, "layout": "form", "xtype": "panel", "items": city1230, "labelAlign": "top" }, { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": zip_code1231, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 117, "border": false, "anchor": "-20", "labelAlign": "top" });
    var street_prefix1235 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Street prefix</span>", "name": "street_prefix", "maxLength": 200, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Pr\u00e4fix Stra\u00dfe","(jobs.JobProviders.street_prefix) Text to print before name of street, but to ignore for sorting.") }, "anchor": "-20" });
    var street1236 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Street</span>", "name": "street", "maxLength": 200, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Stra\u00dfe","(jobs.JobProviders.street) Name of street. Without house number.") }, "anchor": "-20" });
    var street_no1237 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">No.</span>", "name": "street_no", "boxMinWidth": Lino.chars2width(10), "listeners": { "render": Lino.quicktip_renderer("Nr.","(jobs.JobProviders.street_no) House number") }, "maxLength": 10, "selectOnFocus": true, "anchor": "-20" });
    var street_box1238 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Box</span>", "name": "street_box", "boxMinWidth": Lino.chars2width(10), "listeners": { "render": Lino.quicktip_renderer("Box","(jobs.JobProviders.street_box) Text to print after :attr:`steet_no` on the same line") }, "maxLength": 10, "selectOnFocus": true, "anchor": "-20" });
    var box3_3_panel1239 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 30, "autoHeight": true, "layout": "form", "xtype": "panel", "items": street_prefix1235, "labelAlign": "top" }, { "flex": 36, "autoHeight": true, "layout": "form", "xtype": "panel", "items": street1236, "labelAlign": "top" }, { "flex": 16, "autoHeight": true, "layout": "form", "xtype": "panel", "items": street_no1237, "labelAlign": "top" }, { "flex": 16, "autoHeight": true, "layout": "form", "xtype": "panel", "items": street_box1238, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 126, "border": false, "anchor": "-20", "labelAlign": "top" });
    var addr21244 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Address line after street</span>", "name": "addr2", "maxLength": 200, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Adresszeile nach Stra\u00dfe","(jobs.JobProviders.addr2) Address line to print below street line") }, "anchor": "-20" });
    var box3_panel1245 = new Ext.Panel({ "flex": 62, "autoHeight": true, "layout": "form", "items": [ box3_1_panel1227, box3_2_panel1232, box3_3_panel1239, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": addr21244, "anchor": "-20", "labelAlign": "top" } ], "frame": true, "bodyBorder": false, "autoScroll": false, "hideCheckBoxLabels": true, "labelWidth": 216, "border": false, "labelAlign": "top" });
    var email1247 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "E-Mail", "name": "email", "maxLength": 75, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("E-Mail","(jobs.JobProviders.email) ") }, "anchor": "-20" });
    var url1248 = new Lino.URLField({ "autoHeight": true, "fieldLabel": "URL", "name": "url", "maxLength": 200, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("URL","(jobs.JobProviders.url) ") }, "anchor": "-20" });
    var phone1249 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Phone", "name": "phone", "maxLength": 200, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Telefon","(jobs.JobProviders.phone) ") }, "anchor": "-20" });
    var gsm1250 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "GSM", "name": "gsm", "maxLength": 200, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("GSM","(jobs.JobProviders.gsm) ") }, "anchor": "-20" });
    var box4_panel1251 = new Ext.Panel({ "flex": 37, "autoHeight": true, "layout": "form", "items": [ { "autoHeight": true, "layout": "form", "xtype": "panel", "items": email1247, "anchor": "-20", "labelAlign": "top" }, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": url1248, "anchor": "-20", "labelAlign": "top" }, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": phone1249, "anchor": "-20", "labelAlign": "top" }, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": gsm1250, "anchor": "-20", "labelAlign": "top" } ], "frame": true, "bodyBorder": false, "autoScroll": false, "hideCheckBoxLabels": true, "labelWidth": 72, "border": false, "labelAlign": "top" });
    var address_box_panel1256 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "hideCheckBoxLabels": true, "items": [ box3_panel1245, box4_panel1251 ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var remarks1257 = new Ext.form.TextArea({ "listeners": { "render": Lino.quicktip_renderer("Bemerkungen","(jobs.JobProviders.remarks) ") }, "fieldLabel": "Remarks", "name": "remarks", "growMax": 2000, "selectOnFocus": true, "anchor": "-20 -10" });
    var contacts_RolesByCompany_grid1258 = new Lino.contacts.RolesByCompany.GridPanel({ "flex": 42, "listeners": { "render": Lino.quicktip_renderer("Kontaktpersonen","(contacts.contacts.RolesByCompany) ") }, "hide_top_toolbar": true, "containing_panel": this, "tools": [ Lino.show_in_own_window_button(Lino.contacts.RolesByCompany.grid) ], "preview_limit": 15, "master_panel": this });
    var bottom_box_panel1259 = new Ext.Panel({ "flex": 41, "border": false, "layout": "hbox", "labelWidth": 108, "hideCheckBoxLabels": true, "items": [ { "items": remarks1257, "labelAlign": "top", "layout": "form", "xtype": "panel", "flex": 57 }, contacts_RolesByCompany_grid1258 ], "autoScroll": false, "layoutConfig": { "align": "stretch" }, "frame": false, "labelAlign": "top" });
    var general_panel1261 = new Ext.Panel({ "layout": "vbox", "title": "General", "items": [ intro_box_panel1224, address_box_panel1256, bottom_box_panel1259 ], "frame": true, "layoutConfig": { "align": "stretch" }, "hideCheckBoxLabels": true, "listeners": { "activate": Lino.on_tab_activate }, "autoScroll": false, "border": false, "bodyBorder": false, "labelAlign": "top" });
    var pcsw_NotesByCompany_grid1262 = new Lino.pcsw.NotesByCompany.GridPanel({ "listeners": { "activate": Lino.on_tab_activate }, "hide_top_toolbar": true, "containing_panel": this, "title": "Events/Notes", "tools": [ Lino.show_in_own_window_button(Lino.pcsw.NotesByCompany.grid) ], "preview_limit": 15, "master_panel": this });
    var JobsByProvider_grid1568 = new Lino.jobs.JobsByProvider.GridPanel({ "flex": 5, "hide_top_toolbar": true, "containing_panel": this, "region": "north", "preview_limit": 15, "master_panel": this, "listeners": { "render": Lino.quicktip_renderer("Stellen","(jobs.jobs.JobsByProvider) ") }, "split": true, "tools": [ Lino.show_in_own_window_button(Lino.jobs.JobsByProvider.grid) ] });
    var ContractsByProvider_grid1596 = new Lino.jobs.ContractsByProvider.GridPanel({ "flex": 5, "hide_top_toolbar": true, "containing_panel": this, "region": "center", "params_panel_hidden": true, "master_panel": this, "preview_limit": 15, "listeners": { "render": Lino.quicktip_renderer("Art.60\u00a77-Konventionen","(jobs.jobs.ContractsByProvider) ") }, "split": true, "tools": [ Lino.show_in_own_window_button(Lino.jobs.ContractsByProvider.grid) ] });
    var jobs_panel1597 = new Lino.VBorderPanel({ "autoScroll": false, "listeners": { "activate": Lino.on_tab_activate }, "border": false, "title": "Jobs", "hideCheckBoxLabels": true, "items": [ JobsByProvider_grid1568, ContractsByProvider_grid1596 ], "frame": true, "bodyBorder": false, "labelAlign": "top" });
    var main_panel1598 = new Ext.TabPanel({ "hideCheckBoxLabels": true, "border": false, "split": true, "autoScroll": false, "items": [ general_panel1261, pcsw_NotesByCompany_grid1262, jobs_panel1597 ], "activeTab": 0, "bodyBorder": false, "frame": true, "labelAlign": "top" });
    this.items = main_panel1598;
    this.before_row_edit = function(record) {
      region1226.setContextValue('country',record ? record.data['countryHidden'] : undefined);
      city1230.setContextValue('country',record ? record.data['countryHidden'] : undefined);
      city1230.setContextValue('region',record ? record.data['regionHidden'] : undefined);
      contacts_RolesByCompany_grid1258.on_master_changed();
      pcsw_NotesByCompany_grid1262.on_master_changed();
      JobsByProvider_grid1568.on_master_changed();
      ContractsByProvider_grid1596.on_master_changed();
    }
    this.onRender = function(ct, position) {
      country1225.on('change',Lino.chooser_handler(region1226,'country'));
      country1225.on('change',Lino.chooser_handler(city1230,'country'));
      region1226.on('change',Lino.chooser_handler(city1230,'region'));
      Lino.jobs.JobProviders.DetailFormPanel.superclass.onRender.call(this, ct, position);
    }
    Lino.jobs.JobProviders.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.cbss.IdentifyPersonRequests.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 97,
  initComponent : function() {
    var containing_panel = this;
    var id4846 = new Ext.form.NumberField({ "autoHeight": true, "fieldLabel": "ID", "name": "id", "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("ID","(cbss.IdentifyPersonRequests.id) ") }, "anchor": "-20" });
    var person4847 = new Lino.TwinCombo({ "preferred_width": 20, "autoHeight": true, "fieldLabel": "Client", "allowBlank": false, "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.pcsw.Clients.detail)}, "emptyText": "Select a Client...", "listeners": { "render": Lino.quicktip_renderer("Klient","(cbss.IdentifyPersonRequests.person) ") }, "selectOnFocus": true, "hiddenName": "personHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cbss/IdentifyPersonRequests/person", "method": "GET" }) }), "name": "person" });
    var user4848 = new Lino.TwinCombo({ "preferred_width": 15, "autoHeight": true, "fieldLabel": "Author", "allowBlank": false, "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.users.Users.detail)}, "emptyText": "Select a User...", "listeners": { "render": Lino.quicktip_renderer("Autor","(cbss.IdentifyPersonRequests.user) ") }, "selectOnFocus": true, "hiddenName": "userHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cbss/IdentifyPersonRequests/user", "method": "GET" }) }), "name": "user" });
    var environment4849 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "T/A/B", "name": "environment", "boxMinWidth": Lino.chars2width(4), "disabled": true, "listeners": { "render": Lino.quicktip_renderer("T/A/B","(cbss.IdentifyPersonRequests.environment) ") }, "maxLength": 4, "anchor": "-20" });
    var sent4850 = new Ext.form.DisplayField({ "disabled": true, "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Sent</span>", "name": "sent", "listeners": { "render": Lino.quicktip_renderer("Versendet","(cbss.IdentifyPersonRequests.sent) The date and time when this request has been executed. \nThis is empty for requests than haven't been sent.\nRead-only.") }, "value": "<br>", "anchor": "-20" });
    var status4851 = new Lino.ChoicesFieldElement({ "autoHeight": true, "forceSelection": true, "fieldLabel": "State", "name": "status", "hiddenName": "statusHidden", "disabled": true, "listeners": { "render": Lino.quicktip_renderer("Zustand","(cbss.IdentifyPersonRequests.status) ") }, "anchor": "-20", "store": [['','<br>']].concat(Lino.cbss.RequestStates) });
    var ticket4852 = new Ext.form.TextField({ "disabled": true, "autoHeight": true, "fieldLabel": "Ticket", "name": "ticket", "maxLength": 36, "listeners": { "render": Lino.quicktip_renderer("Ticket","(cbss.IdentifyPersonRequests.ticket) ") }, "anchor": "-20" });
    var info_1_panel4853 = new Ext.form.FieldSet({ "autoHeight": true, "layout": "hbox", "title": "Request information", "layoutConfig": { "align": "stretchmax" }, "frame": false, "bodyBorder": true, "autoScroll": false, "items": [ { "flex": 5, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id4846, "labelAlign": "top" }, { "flex": 20, "autoHeight": true, "layout": "form", "xtype": "panel", "items": person4847, "labelAlign": "top" }, { "flex": 20, "autoHeight": true, "layout": "form", "xtype": "panel", "items": user4848, "labelAlign": "top" }, { "flex": 5, "autoHeight": true, "layout": "form", "xtype": "panel", "items": environment4849, "labelAlign": "top" }, { "flex": 16, "autoHeight": true, "layout": "form", "xtype": "panel", "items": sent4850, "labelAlign": "top" }, { "flex": 12, "autoHeight": true, "layout": "form", "xtype": "panel", "items": status4851, "labelAlign": "top" }, { "flex": 21, "autoHeight": true, "layout": "form", "xtype": "panel", "items": ticket4852, "labelAlign": "top" } ], "hideCheckBoxLabels": true, "labelWidth": 90, "border": false, "labelAlign": "top" });
    var national_id4861 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "National ID", "name": "national_id", "maxLength": 200, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("NR-Nummer","(cbss.IdentifyPersonRequests.national_id) ") }, "anchor": "-20" });
    var p1_panel4863 = new Ext.form.FieldSet({ "flex": 25, "layout": "vbox", "title": "Using the national ID", "layoutConfig": { "align": "stretch" }, "frame": true, "bodyBorder": false, "autoScroll": false, "items": [ { "items": national_id4861, "autoHeight": true, "layout": "form", "xtype": "panel", "labelAlign": "top" }, { "flex": 50, "html": "<br/>", "xtype": "label" } ], "hideCheckBoxLabels": true, "labelWidth": 90, "border": false, "labelAlign": "top" });
    var first_name4865 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "First name", "name": "first_name", "maxLength": 200, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Vorname","(cbss.IdentifyPersonRequests.first_name) ") }, "anchor": "-20" });
    var middle_name4866 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Middle name</span>", "name": "middle_name", "maxLength": 200, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Mittelnamen","(cbss.IdentifyPersonRequests.middle_name) Whatever this means...") }, "anchor": "-20" });
    var last_name4867 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Last name", "name": "last_name", "maxLength": 200, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Familienname","(cbss.IdentifyPersonRequests.last_name) ") }, "anchor": "-20" });
    var p2_1_panel4868 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": first_name4865, "labelAlign": "top" }, { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": middle_name4866, "labelAlign": "top" }, { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": last_name4867, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 117, "border": false, "anchor": "-20", "labelAlign": "top" });
    var birth_date4872 = new Lino.IncompleteDateField({ "autoHeight": true, "allowBlank": false, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Birth date</span>", "name": "birth_date", "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Geburtsdatum","(cbss.IdentifyPersonRequests.birth_date) Uncomplete dates are allowed, e.g. \n\"00.00.1980\" means \"some day in 1980\", \n\"00.07.1980\" means \"in July 1980\"\nor \"23.07.0000\" means \"on a 23th of July\".") }, "anchor": "-20" });
    var tolerance4873 = new Ext.form.NumberField({ "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Tolerance</span>", "name": "tolerance", "value": 0, "listeners": { "render": Lino.quicktip_renderer("Toleranz","(cbss.IdentifyPersonRequests.tolerance) \n      Falls Monat oder Tag des Geburtsdatums unbekannt sind, \n      um wieviel Monate bzw. Tage die Suche nach unten/oben ausgeweitet wird.\n      G\u00fcltige Werte: 0 bis 10.\n      ") }, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var gender4874 = new Lino.ChoicesFieldElement({ "autoHeight": true, "forceSelection": true, "fieldLabel": "Gender", "name": "gender", "hiddenName": "genderHidden", "listeners": { "render": Lino.quicktip_renderer("Geschlecht","(cbss.IdentifyPersonRequests.gender) ") }, "selectOnFocus": true, "anchor": "-20", "store": [['','<br>']].concat(Lino.lino.Genders) });
    var p2_2_panel4875 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 46, "autoHeight": true, "layout": "form", "xtype": "panel", "items": birth_date4872, "labelAlign": "top" }, { "flex": 19, "autoHeight": true, "layout": "form", "xtype": "panel", "items": tolerance4873, "labelAlign": "top" }, { "flex": 34, "autoHeight": true, "layout": "form", "xtype": "panel", "items": gender4874, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 117, "border": false, "anchor": "-20", "labelAlign": "top" });
    var p2_panel4879 = new Ext.form.FieldSet({ "flex": 75, "autoHeight": true, "layout": "form", "title": "Using phonetic search", "items": [ p2_1_panel4868, p2_2_panel4875 ], "frame": true, "bodyBorder": false, "autoScroll": false, "hideCheckBoxLabels": true, "border": false, "labelAlign": "top" });
    var parameters_panel4880 = new Ext.form.FieldSet({ "autoHeight": true, "layout": "hbox", "title": "Parameters", "layoutConfig": { "align": "stretchmax" }, "frame": false, "bodyBorder": true, "autoScroll": false, "items": [ p1_panel4863, p2_panel4879 ], "hideCheckBoxLabels": true, "border": false, "labelAlign": "top" });
    var IdentifyPersonResult_grid4891 = new Lino.cbss.IdentifyPersonResult.GridPanel({ "flex": 62, "listeners": { "render": Lino.quicktip_renderer("Resultate","(cbss.cbss.IdentifyPersonResult) ") }, "hide_top_toolbar": true, "containing_panel": this, "tools": [ Lino.show_in_own_window_button(Lino.cbss.IdentifyPersonResult.grid) ], "preview_limit": 15, "master_panel": this });
    var request_panel4892 = new Ext.Panel({ "layout": "vbox", "title": "Request", "items": [ info_1_panel4853, parameters_panel4880, IdentifyPersonResult_grid4891 ], "frame": true, "layoutConfig": { "align": "stretch" }, "hideCheckBoxLabels": true, "listeners": { "activate": Lino.on_tab_activate }, "autoScroll": false, "border": false, "bodyBorder": false, "labelAlign": "top" });
    var response_xml4893 = new Ext.form.TextArea({ "disabled": true, "listeners": { "render": Lino.quicktip_renderer("Antwort","(cbss.IdentifyPersonRequests.response_xml) The raw XML response received. \n") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Response</span>", "name": "response_xml", "growMax": 2000, "anchor": "-20 -10" });
    var info_messages4894 = new Ext.form.TextArea({ "disabled": true, "listeners": { "render": Lino.quicktip_renderer("Info-Meldungen","(cbss.IdentifyPersonRequests.info_messages) ") }, "fieldLabel": "Info messages", "name": "info_messages", "growMax": 2000, "anchor": "-20 -10" });
    var debug_messages4895 = new Ext.form.TextArea({ "disabled": true, "listeners": { "render": Lino.quicktip_renderer("Debug-Meldungen","(cbss.IdentifyPersonRequests.debug_messages) ") }, "fieldLabel": "Debug messages", "name": "debug_messages", "growMax": 2000, "anchor": "-20 -10" });
    var technical_panel4896 = new Lino.VBorderPanel({ "autoScroll": false, "listeners": { "activate": Lino.on_tab_activate }, "border": false, "labelWidth": 144, "title": "Technical", "hideCheckBoxLabels": true, "items": [ { "flex": 5, "layout": "form", "xtype": "panel", "items": response_xml4893, "region": "north", "labelAlign": "top", "split": true }, { "flex": 5, "layout": "form", "xtype": "panel", "items": info_messages4894, "region": "center", "labelAlign": "top", "split": true }, { "flex": 5, "layout": "form", "xtype": "panel", "items": debug_messages4895, "region": "south", "labelAlign": "top", "split": true } ], "frame": true, "bodyBorder": false, "labelAlign": "top" });
    var main_panel4900 = new Ext.TabPanel({ "hideCheckBoxLabels": true, "border": false, "split": true, "autoScroll": false, "items": [ request_panel4892, technical_panel4896 ], "activeTab": 0, "bodyBorder": false, "frame": true, "labelAlign": "top" });
    this.items = main_panel4900;
    this.before_row_edit = function(record) {
      IdentifyPersonResult_grid4891.on_master_changed();
    }
    Lino.cbss.IdentifyPersonRequests.DetailFormPanel.superclass.initComponent.call(this);
    // active_fields:
    person4847.on("change",function(){this.save()},this);
  }
});


Lino.reception.MyWaitingVisitors.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 41,
  disable_editing: true,
  initComponent : function() {
    var containing_panel = this;
    var event2716 = new Lino.TwinCombo({ "autoHeight": true, "fieldLabel": "Event", "allowBlank": false, "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.cal.OneEvent.detail)}, "emptyText": "Select a Event...", "listeners": { "render": Lino.quicktip_renderer("Termin","(reception.MyWaitingVisitors.event) ") }, "selectOnFocus": true, "hiddenName": "eventHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/reception/MyWaitingVisitors/event", "method": "GET" }) }), "name": "event" });
    var client2717 = new Lino.TwinCombo({ "preferred_width": 20, "autoHeight": true, "fieldLabel": "Client", "name": "client", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.pcsw.Clients.detail)}, "hiddenName": "clientHidden", "disabled": true, "listeners": { "render": Lino.quicktip_renderer("Klient","(reception.MyWaitingVisitors.client) ") }, "emptyText": "Select a Client...", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({  }) });
    var role2718 = new Lino.TwinCombo({ "autoHeight": true, "fieldLabel": "Role", "name": "role", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.cal.GuestRoles.detail)}, "emptyText": "Select a Guest Role...", "listeners": { "render": Lino.quicktip_renderer("Rolle","(reception.MyWaitingVisitors.role) ") }, "selectOnFocus": true, "hiddenName": "roleHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/reception/MyWaitingVisitors/role", "method": "GET" }) }) });
    var main_1_panel2719 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 63, "hideCheckBoxLabels": true, "items": [ { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": event2716, "labelAlign": "top" }, { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": client2717, "labelAlign": "top" }, { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": role2718, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var state2723 = new Lino.ChoicesFieldElement({ "autoHeight": true, "forceSelection": true, "fieldLabel": "State", "allowBlank": false, "hiddenName": "stateHidden", "listeners": { "render": Lino.quicktip_renderer("Zustand","(reception.MyWaitingVisitors.state) ") }, "selectOnFocus": true, "anchor": "-20", "store": Lino.cal.GuestStates, "name": "state" });
    var remark2724 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Remark", "name": "remark", "maxLength": 200, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Bemerkung","(reception.MyWaitingVisitors.remark) ") }, "anchor": "-20" });
    var workflow_buttons_disp2725 = new Ext.form.DisplayField({ "autoHeight": true, "fieldLabel": "Workflow", "name": "workflow_buttons", "value": "<br/>", "always_enabled": true, "disabled": true, "listeners": { "render": Lino.quicktip_renderer("Arbeitsablauf","(reception.MyWaitingVisitors.workflow_buttons) ") }, "anchor": "-20" });
    var main_2_panel2726 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 126, "hideCheckBoxLabels": true, "items": [ { "flex": 17, "autoHeight": true, "layout": "form", "xtype": "panel", "items": state2723, "labelAlign": "top" }, { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": remark2724, "labelAlign": "top" }, { "flex": 48, "autoHeight": true, "layout": "form", "xtype": "panel", "items": workflow_buttons_disp2725, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var outbox_MailsByController_grid2730 = new Lino.outbox.MailsByController.GridPanel({ "flex": 55, "listeners": { "render": Lino.quicktip_renderer("E-Mail-Ausg\u00e4nge","(outbox.outbox.MailsByController) ") }, "hide_top_toolbar": true, "containing_panel": this, "tools": [ Lino.show_in_own_window_button(Lino.outbox.MailsByController.grid) ], "preview_limit": 15, "master_panel": this });
    var main_panel2731 = new Ext.Panel({ "autoScroll": false, "border": false, "layout": "vbox", "hideCheckBoxLabels": true, "items": [ main_1_panel2719, main_2_panel2726, outbox_MailsByController_grid2730 ], "frame": true, "layoutConfig": { "align": "stretch" }, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel2731;
    this.before_row_edit = function(record) {
      outbox_MailsByController_grid2730.on_master_changed();
    }
    Lino.reception.MyWaitingVisitors.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.courses.CourseOffers.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 86,
  initComponent : function() {
    var containing_panel = this;
    var id946 = new Ext.form.NumberField({ "autoHeight": true, "fieldLabel": "ID", "name": "id", "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("ID","(courses.CourseOffers.id) ") }, "anchor": "-20" });
    var title947 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Name", "name": "title", "listeners": { "render": Lino.quicktip_renderer("Name","(courses.CourseOffers.title) ") }, "maxLength": 200, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var content948 = new Lino.TwinCombo({ "autoHeight": true, "fieldLabel": "Course Content", "allowBlank": false, "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.courses.CourseContents.detail)}, "emptyText": "Select a Course Content...", "listeners": { "render": Lino.quicktip_renderer("Kursinhalt","(courses.CourseOffers.content) ") }, "selectOnFocus": true, "hiddenName": "contentHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/courses/CourseOffers/content", "method": "GET" }) }), "name": "content" });
    var provider949 = new Lino.TwinCombo({ "preferred_width": 20, "autoHeight": true, "fieldLabel": "Course provider", "allowBlank": false, "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.courses.CourseProviders.detail)}, "emptyText": "Select a Course provider...", "listeners": { "render": Lino.quicktip_renderer("Kursanbieter","(courses.CourseOffers.provider) ") }, "selectOnFocus": true, "hiddenName": "providerHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/courses/CourseOffers/provider", "method": "GET" }) }), "name": "provider" });
    var main_1_panel950 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 11, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id946, "labelAlign": "top" }, { "flex": 30, "autoHeight": true, "layout": "form", "xtype": "panel", "items": title947, "labelAlign": "top" }, { "flex": 28, "autoHeight": true, "layout": "form", "xtype": "panel", "items": content948, "labelAlign": "top" }, { "flex": 28, "autoHeight": true, "layout": "form", "xtype": "panel", "items": provider949, "labelAlign": "top" } ], "region": "north", "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "split": true, "autoScroll": false, "labelWidth": 117, "border": false, "frame": false, "labelAlign": "top" });
    var description955 = new Lino.RichTextPanel({ "flex": 5, "split": true, "containing_panel": this, "selectOnFocus": true, "region": "center", "title": "Description", "name": "description" });
    var CoursesByOffer_grid1011 = new Lino.courses.CoursesByOffer.GridPanel({ "flex": 5, "hide_top_toolbar": true, "containing_panel": this, "region": "south", "preview_limit": 15, "master_panel": this, "listeners": { "render": Lino.quicktip_renderer("Kurse","(courses.courses.CoursesByOffer) ") }, "split": true, "tools": [ Lino.show_in_own_window_button(Lino.courses.CoursesByOffer.grid) ] });
    var main_panel1012 = new Lino.VBorderPanel({ "autoScroll": false, "border": false, "labelWidth": 0, "hideCheckBoxLabels": true, "items": [ main_1_panel950, description955, CoursesByOffer_grid1011 ], "frame": true, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel1012;
    this.before_row_edit = function(record) {
      description955.refresh();
      CoursesByOffer_grid1011.on_master_changed();
    }
    Lino.courses.CourseOffers.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.changes.Changes.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 15,
  disable_editing: true,
  initComponent : function() {
    var containing_panel = this;
    var time829 = new Ext.form.DisplayField({ "autoHeight": true, "fieldLabel": "time", "name": "time", "value": "<br>", "listeners": { "render": Lino.quicktip_renderer("time","(changes.Changes.time) ") }, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var user830 = new Lino.TwinCombo({ "preferred_width": 15, "autoHeight": true, "fieldLabel": "User", "allowBlank": false, "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.users.Users.detail)}, "emptyText": "Select a User...", "listeners": { "render": Lino.quicktip_renderer("Benutzer","(changes.Changes.user) ") }, "selectOnFocus": true, "hiddenName": "userHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/changes/Changes/user", "method": "GET" }) }), "name": "user" });
    var type831 = new Lino.ChoicesFieldElement({ "autoHeight": true, "forceSelection": true, "fieldLabel": "Change Type", "allowBlank": false, "hiddenName": "typeHidden", "listeners": { "render": Lino.quicktip_renderer("\u00c4nderungsart","(changes.Changes.type) ") }, "selectOnFocus": true, "anchor": "-20", "store": Lino.lino.ChangeTypes, "name": "type" });
    var master_disp832 = new Ext.form.DisplayField({ "disabled": true, "autoHeight": true, "fieldLabel": "Master", "anchor": "-20", "name": "master" });
    var object_disp833 = new Ext.form.DisplayField({ "disabled": true, "autoHeight": true, "fieldLabel": "Object", "anchor": "-20", "name": "object" });
    var id834 = new Ext.form.NumberField({ "autoHeight": true, "fieldLabel": "ID", "name": "id", "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("ID","(changes.Changes.id) ") }, "anchor": "-20" });
    var main_1_panel835 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 117, "hideCheckBoxLabels": true, "items": [ { "flex": 21, "autoHeight": true, "layout": "form", "xtype": "panel", "items": time829, "labelAlign": "top" }, { "flex": 26, "autoHeight": true, "layout": "form", "xtype": "panel", "items": user830, "labelAlign": "top" }, { "flex": 19, "autoHeight": true, "layout": "form", "xtype": "panel", "items": type831, "labelAlign": "top" }, { "flex": 13, "autoHeight": true, "layout": "form", "xtype": "panel", "items": master_disp832, "labelAlign": "top" }, { "flex": 13, "autoHeight": true, "layout": "form", "xtype": "panel", "items": object_disp833, "labelAlign": "top" }, { "flex": 6, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id834, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var diff842 = new Ext.form.TextArea({ "listeners": { "render": Lino.quicktip_renderer("\u00c4nderungen","(changes.Changes.diff) ") }, "fieldLabel": "Changes", "name": "diff", "growMax": 2000, "selectOnFocus": true, "anchor": "-20 -10" });
    var main_panel843 = new Ext.Panel({ "autoScroll": false, "border": false, "layout": "vbox", "labelWidth": 99, "hideCheckBoxLabels": true, "items": [ main_1_panel835, { "items": diff842, "labelAlign": "top", "layout": "form", "xtype": "panel", "flex": 83 } ], "frame": true, "layoutConfig": { "align": "stretch" }, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel843;
    this.before_row_edit = function(record) {
    }
    Lino.changes.Changes.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.cal.Tasks.InsertFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  autoHeight: true,
  content_type: 34,
  initComponent : function() {
    var containing_panel = this;
    var summary322 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Summary", "name": "summary", "maxLength": 200, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Kurzbeschreibung","(cal.Tasks.summary) ") }, "anchor": "-20" });
    var user323 = new Lino.TwinCombo({ "preferred_width": 15, "autoHeight": true, "fieldLabel": "Author", "name": "user", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.users.Users.detail)}, "hiddenName": "userHidden", "listeners": { "render": Lino.quicktip_renderer("Autor","(cal.Tasks.user) ") }, "selectOnFocus": true, "emptyText": "Select a User...", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/Tasks/user", "method": "GET" }) }) });
    var project324 = new Lino.TwinCombo({ "preferred_width": 20, "autoHeight": true, "fieldLabel": "Client", "name": "project", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.pcsw.Clients.detail)}, "hiddenName": "projectHidden", "listeners": { "render": Lino.quicktip_renderer("Klient","(cal.Tasks.project) ") }, "selectOnFocus": true, "emptyText": "Select a Client...", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/Tasks/project", "method": "GET" }) }) });
    var main_2_panel325 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": user323, "labelAlign": "top" }, { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": project324, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 63, "border": false, "anchor": "-20", "labelAlign": "top" });
    var main_panel328 = new Ext.Panel({ "hideCheckBoxLabels": true, "autoHeight": true, "border": false, "layout": "form", "labelWidth": 153, "autoScroll": false, "items": [ { "autoHeight": true, "layout": "form", "xtype": "panel", "items": summary322, "anchor": "-20", "labelAlign": "top" }, main_2_panel325 ], "frame": true, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel328;
    this.before_row_edit = function(record) {
    }
    Lino.cal.Tasks.InsertFormPanel.superclass.initComponent.call(this);
  }
});


Lino.notes.EventTypes.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 99,
  initComponent : function() {
    var containing_panel = this;
    var id2986 = new Ext.form.NumberField({ "autoHeight": true, "fieldLabel": "ID", "name": "id", "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("ID","(notes.EventTypes.id) ") }, "anchor": "-20" });
    var name2987 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Designation", "name": "name", "listeners": { "render": Lino.quicktip_renderer("Bezeichnung","(notes.EventTypes.name) ") }, "maxLength": 200, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var name_fr2988 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Designation (fr)", "name": "name_fr", "maxLength": 200, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Bezeichnung (fr)","(notes.EventTypes.name_fr) ") }, "anchor": "-20" });
    var name_de2989 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Designation (de)", "name": "name_de", "maxLength": 200, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Bezeichnung (de)","(notes.EventTypes.name_de) ") }, "anchor": "-20" });
    var name_nl2990 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Designation (nl)", "name": "name_nl", "listeners": { "render": Lino.quicktip_renderer("Bezeichnung (nl)","(notes.EventTypes.name_nl) ") }, "maxLength": 200, "selectOnFocus": true, "hidden": true, "anchor": "-20" });
    var main_1_panel2991 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 5, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id2986, "labelAlign": "top" }, { "flex": 23, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name2987, "labelAlign": "top" }, { "flex": 23, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_fr2988, "labelAlign": "top" }, { "flex": 23, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_de2989, "labelAlign": "top" }, { "flex": 23, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_nl2990, "hidden": true, "labelAlign": "top" } ], "region": "north", "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "split": true, "autoScroll": false, "labelWidth": 153, "border": false, "frame": false, "labelAlign": "top" });
    var remark2997 = new Ext.form.TextArea({ "listeners": { "render": Lino.quicktip_renderer("Bemerkung","(notes.EventTypes.remark) ") }, "fieldLabel": "Remark", "name": "remark", "growMax": 2000, "selectOnFocus": true, "anchor": "-20 -10" });
    var notes_NotesByEventType_grid3013 = new Lino.notes.NotesByEventType.GridPanel({ "flex": 6, "hide_top_toolbar": true, "containing_panel": this, "region": "south", "preview_limit": 15, "master_panel": this, "listeners": { "render": Lino.quicktip_renderer("Ereignisse/Notizen","(notes.notes.NotesByEventType) ") }, "split": true, "tools": [ Lino.show_in_own_window_button(Lino.notes.NotesByEventType.grid) ] });
    var main_panel3014 = new Lino.VBorderPanel({ "autoScroll": false, "border": false, "labelWidth": 90, "hideCheckBoxLabels": true, "items": [ main_1_panel2991, { "flex": 3, "layout": "form", "xtype": "panel", "items": remark2997, "region": "center", "labelAlign": "top", "split": true }, notes_NotesByEventType_grid3013 ], "frame": true, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel3014;
    this.before_row_edit = function(record) {
      notes_NotesByEventType_grid3013.on_master_changed();
    }
    Lino.notes.EventTypes.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.households.Roles.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 43,
  initComponent : function() {
    var containing_panel = this;
    var name3551 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Designation", "name": "name", "listeners": { "render": Lino.quicktip_renderer("Bezeichnung","(households.Roles.name) ") }, "maxLength": 200, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var name_fr3552 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Designation (fr)", "name": "name_fr", "maxLength": 200, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Bezeichnung (fr)","(households.Roles.name_fr) ") }, "anchor": "-20" });
    var name_de3553 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Designation (de)", "name": "name_de", "maxLength": 200, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Bezeichnung (de)","(households.Roles.name_de) ") }, "anchor": "-20" });
    var name_nl3554 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Designation (nl)", "name": "name_nl", "listeners": { "render": Lino.quicktip_renderer("Bezeichnung (nl)","(households.Roles.name_nl) ") }, "maxLength": 200, "selectOnFocus": true, "hidden": true, "anchor": "-20" });
    var name_giving3555 = new Ext.form.Checkbox({ "autoHeight": true, "hideLabel": true, "checked": false, "name": "name_giving", "listeners": { "render": Lino.quicktip_renderer("namensgebend","(households.Roles.name_giving) When the `name` field of a Household is empty, \nits value is computed by joining the `Last Name` \nof all name-giving members with a dash (\"-\").\n      ") }, "boxLabel": "name-giving", "selectOnFocus": true, "anchor": "-20" });
    var main_1_panel3556 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 153, "hideCheckBoxLabels": true, "items": [ { "flex": 22, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name3551, "labelAlign": "top" }, { "flex": 22, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_fr3552, "labelAlign": "top" }, { "flex": 22, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_de3553, "labelAlign": "top" }, { "flex": 22, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_nl3554, "hidden": true, "labelAlign": "top" }, { "flex": 10, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_giving3555, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var MembersByRole_grid3568 = new Lino.households.MembersByRole.GridPanel({ "flex": 83, "listeners": { "render": Lino.quicktip_renderer("Mitglieder","(households.households.MembersByRole) ") }, "hide_top_toolbar": true, "containing_panel": this, "tools": [ Lino.show_in_own_window_button(Lino.households.MembersByRole.grid) ], "preview_limit": 15, "master_panel": this });
    var main_panel3569 = new Ext.Panel({ "autoScroll": false, "border": false, "layout": "vbox", "hideCheckBoxLabels": true, "items": [ main_1_panel3556, MembersByRole_grid3568 ], "frame": true, "layoutConfig": { "align": "stretch" }, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel3569;
    this.before_row_edit = function(record) {
      MembersByRole_grid3568.on_master_changed();
    }
    Lino.households.Roles.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.jobs.Functions.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 70,
  initComponent : function() {
    var containing_panel = this;
    var id4113 = new Ext.form.NumberField({ "autoHeight": true, "fieldLabel": "ID", "name": "id", "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("ID","(jobs.Functions.id) ") }, "anchor": "-20" });
    var name4114 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Designation", "name": "name", "listeners": { "render": Lino.quicktip_renderer("Bezeichnung","(jobs.Functions.name) ") }, "maxLength": 200, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var name_fr4115 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Designation (fr)", "name": "name_fr", "maxLength": 200, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Bezeichnung (fr)","(jobs.Functions.name_fr) ") }, "anchor": "-20" });
    var name_de4116 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Designation (de)", "name": "name_de", "maxLength": 200, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Bezeichnung (de)","(jobs.Functions.name_de) ") }, "anchor": "-20" });
    var name_nl4117 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Designation (nl)", "name": "name_nl", "listeners": { "render": Lino.quicktip_renderer("Bezeichnung (nl)","(jobs.Functions.name_nl) ") }, "maxLength": 200, "selectOnFocus": true, "hidden": true, "anchor": "-20" });
    var sector4118 = new Lino.TwinCombo({ "autoHeight": true, "fieldLabel": "Job Sector", "allowBlank": false, "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.jobs.Sectors.detail)}, "emptyText": "Select a Job Sector...", "listeners": { "render": Lino.quicktip_renderer("Sektor","(jobs.Functions.sector) ") }, "selectOnFocus": true, "hiddenName": "sectorHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/jobs/Functions/sector", "method": "GET" }) }), "name": "sector" });
    var main_1_panel4119 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 153, "hideCheckBoxLabels": true, "items": [ { "flex": 4, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id4113, "labelAlign": "top" }, { "flex": 19, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name4114, "labelAlign": "top" }, { "flex": 19, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_fr4115, "labelAlign": "top" }, { "flex": 19, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_de4116, "labelAlign": "top" }, { "flex": 19, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_nl4117, "hidden": true, "labelAlign": "top" }, { "flex": 18, "autoHeight": true, "layout": "form", "xtype": "panel", "items": sector4118, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var remark4126 = new Ext.form.TextArea({ "listeners": { "render": Lino.quicktip_renderer("Bemerkung","(jobs.Functions.remark) ") }, "fieldLabel": "Remark", "name": "remark", "growMax": 2000, "selectOnFocus": true, "anchor": "-20 -10" });
    var CandidaturesByFunction_grid4135 = new Lino.jobs.CandidaturesByFunction.GridPanel({ "flex": 31, "listeners": { "render": Lino.quicktip_renderer("Stellenanfragen","(jobs.jobs.CandidaturesByFunction) ") }, "hide_top_toolbar": true, "containing_panel": this, "tools": [ Lino.show_in_own_window_button(Lino.jobs.CandidaturesByFunction.grid) ], "preview_limit": 15, "master_panel": this });
    var ExperiencesByFunction_grid4146 = new Lino.jobs.ExperiencesByFunction.GridPanel({ "flex": 31, "listeners": { "render": Lino.quicktip_renderer("Berufserfahrungen","(jobs.jobs.ExperiencesByFunction) ") }, "hide_top_toolbar": true, "containing_panel": this, "tools": [ Lino.show_in_own_window_button(Lino.jobs.ExperiencesByFunction.grid) ], "preview_limit": 15, "master_panel": this });
    var main_panel4147 = new Ext.Panel({ "autoScroll": false, "border": false, "layout": "vbox", "labelWidth": 90, "hideCheckBoxLabels": true, "items": [ main_1_panel4119, { "items": remark4126, "labelAlign": "top", "layout": "form", "xtype": "panel", "flex": 31 }, CandidaturesByFunction_grid4135, ExperiencesByFunction_grid4146 ], "frame": true, "layoutConfig": { "align": "stretch" }, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel4147;
    this.before_row_edit = function(record) {
      CandidaturesByFunction_grid4135.on_master_changed();
      ExperiencesByFunction_grid4146.on_master_changed();
    }
    Lino.jobs.Functions.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.cal.Events.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 40,
  initComponent : function() {
    var containing_panel = this;
    var calendar1434 = new Lino.TwinCombo({ "autoHeight": true, "fieldLabel": "Calendar", "name": "calendar", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.cal.Calendars.detail)}, "emptyText": "Select a Calendar...", "listeners": { "render": Lino.quicktip_renderer("Kalender","(cal.Events.calendar) ") }, "selectOnFocus": true, "hiddenName": "calendarHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/Events/calendar", "method": "GET" }) }) });
    var summary1435 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Summary", "name": "summary", "maxLength": 200, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Kurzbeschreibung","(cal.Events.summary) ") }, "anchor": "-20" });
    var project1436 = new Lino.TwinCombo({ "preferred_width": 20, "autoHeight": true, "fieldLabel": "Client", "name": "project", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.pcsw.Clients.detail)}, "hiddenName": "projectHidden", "listeners": { "render": Lino.quicktip_renderer("Klient","(cal.Events.project) ") }, "selectOnFocus": true, "emptyText": "Select a Client...", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/Events/project", "method": "GET" }) }) });
    var general_1_panel1437 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 153, "hideCheckBoxLabels": true, "items": [ { "flex": 32, "autoHeight": true, "layout": "form", "xtype": "panel", "items": calendar1434, "labelAlign": "top" }, { "flex": 34, "autoHeight": true, "layout": "form", "xtype": "panel", "items": summary1435, "labelAlign": "top" }, { "flex": 32, "autoHeight": true, "layout": "form", "xtype": "panel", "items": project1436, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var start_date1441 = new Lino.DateField({ "autoHeight": true, "fieldLabel": "Start date", "name": "start_date", "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Beginnt am","(cal.Events.start_date) ") }, "anchor": "-20" });
    var start_time1442 = new Lino.TimeField({ "autoHeight": true, "fieldLabel": "Start time", "name": "start_time", "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Beginnt um","(cal.Events.start_time) ") }, "anchor": "-20" });
    var start_panel1443 = new Ext.Panel({ "flex": 22, "autoHeight": true, "layout": "hbox", "items": [ { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": start_date1441, "labelAlign": "top" }, { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": start_time1442, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "autoScroll": false, "hideCheckBoxLabels": true, "labelWidth": 99, "border": false, "labelAlign": "top" });
    var end_date1446 = new Lino.DateField({ "autoHeight": true, "fieldLabel": "End Date", "name": "end_date", "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Endet am","(cal.Events.end_date) ") }, "anchor": "-20" });
    var end_time1447 = new Lino.TimeField({ "autoHeight": true, "fieldLabel": "End Time", "name": "end_time", "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Endet um","(cal.Events.end_time) ") }, "anchor": "-20" });
    var end_panel1448 = new Ext.Panel({ "flex": 22, "autoHeight": true, "layout": "hbox", "items": [ { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": end_date1446, "labelAlign": "top" }, { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": end_time1447, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "autoScroll": false, "hideCheckBoxLabels": true, "labelWidth": 81, "border": false, "labelAlign": "top" });
    var user1451 = new Lino.TwinCombo({ "preferred_width": 15, "autoHeight": true, "fieldLabel": "Responsible user", "name": "user", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.users.Users.detail)}, "hiddenName": "userHidden", "listeners": { "render": Lino.quicktip_renderer("Verantwortlicher","(cal.Events.user) ") }, "selectOnFocus": true, "emptyText": "Select a User...", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/Events/user", "method": "GET" }) }) });
    var assigned_to1452 = new Lino.TwinCombo({ "preferred_width": 15, "autoHeight": true, "fieldLabel": "Assigned to", "name": "assigned_to", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.users.Users.detail)}, "hiddenName": "assigned_toHidden", "listeners": { "render": Lino.quicktip_renderer("Zugewiesen zu","(cal.Events.assigned_to) ") }, "selectOnFocus": true, "emptyText": "Select a User...", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/Events/assigned_to", "method": "GET" }) }) });
    var general_2_panel1453 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 153, "hideCheckBoxLabels": true, "items": [ start_panel1443, end_panel1448, { "flex": 27, "autoHeight": true, "layout": "form", "xtype": "panel", "items": user1451, "labelAlign": "top" }, { "flex": 27, "autoHeight": true, "layout": "form", "xtype": "panel", "items": assigned_to1452, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var room1456 = new Lino.TwinCombo({ "autoHeight": true, "fieldLabel": "Room", "name": "room", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.cal.Rooms.detail)}, "emptyText": "Select a Room...", "listeners": { "render": Lino.quicktip_renderer("Raum","(cal.Events.room) ") }, "selectOnFocus": true, "hiddenName": "roomHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/Events/room", "method": "GET" }) }) });
    var priority1457 = new Lino.RemoteComboFieldElement({ "autoHeight": true, "fieldLabel": "Priority", "name": "priority", "pageSize": 20, "emptyText": "Select a Priority...", "listeners": { "render": Lino.quicktip_renderer("Priorit\u00e4t","(cal.Events.priority) ") }, "selectOnFocus": true, "hiddenName": "priorityHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/Events/priority", "method": "GET" }) }) });
    var access_class1458 = new Lino.ChoicesFieldElement({ "autoHeight": true, "forceSelection": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Access Class</span>", "name": "access_class", "hiddenName": "access_classHidden", "listeners": { "render": Lino.quicktip_renderer("Zugriffsklasse","(cal.Events.access_class) Ob dieser Termin  privat, \u00f6ffentlich oder halb \u00f6ffentlich ist") }, "selectOnFocus": true, "anchor": "-20", "store": [['','<br>']].concat(Lino.cal.AccessClasses) });
    var transparent1459 = new Ext.form.Checkbox({ "autoHeight": true, "hideLabel": true, "checked": false, "name": "transparent", "listeners": { "render": Lino.quicktip_renderer("nicht blockierend","(cal.Events.transparent) Dieser Termin l\u00e4sst auch andere Termine zur gleichen Zeit zu.") }, "boxLabel": "Transparent", "selectOnFocus": true, "anchor": "-20" });
    var general_3_panel1460 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 162, "hideCheckBoxLabels": true, "items": [ { "flex": 32, "autoHeight": true, "layout": "form", "xtype": "panel", "items": room1456, "labelAlign": "top" }, { "flex": 32, "autoHeight": true, "layout": "form", "xtype": "panel", "items": priority1457, "labelAlign": "top" }, { "flex": 19, "autoHeight": true, "layout": "form", "xtype": "panel", "items": access_class1458, "labelAlign": "top" }, { "flex": 16, "autoHeight": true, "layout": "form", "xtype": "panel", "items": transparent1459, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var owner_disp1465 = new Ext.form.DisplayField({ "disabled": true, "autoHeight": true, "fieldLabel": "Controlled by", "anchor": "-20", "name": "owner" });
    var workflow_buttons_disp1466 = new Ext.form.DisplayField({ "autoHeight": true, "fieldLabel": "Workflow", "name": "workflow_buttons", "value": "<br/>", "always_enabled": true, "disabled": true, "listeners": { "render": Lino.quicktip_renderer("Arbeitsablauf","(cal.Events.workflow_buttons) ") }, "anchor": "-20" });
    var general_4_panel1467 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 126, "hideCheckBoxLabels": true, "items": [ { "flex": 25, "autoHeight": true, "layout": "form", "xtype": "panel", "items": owner_disp1465, "labelAlign": "top" }, { "flex": 75, "autoHeight": true, "layout": "form", "xtype": "panel", "items": workflow_buttons_disp1466, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var description1470 = new Lino.RichTextPanel({ "selectOnFocus": true, "flex": 46, "containing_panel": this, "name": "description", "title": "Description" });
    var GuestsByEvent_grid1522 = new Lino.cal.GuestsByEvent.GridPanel({ "flex": 53, "listeners": { "render": Lino.quicktip_renderer("G\u00e4ste","(cal.cal.GuestsByEvent) ") }, "hide_top_toolbar": true, "containing_panel": this, "tools": [ Lino.show_in_own_window_button(Lino.cal.GuestsByEvent.grid) ], "preview_limit": 15, "master_panel": this });
    var general_5_panel1523 = new Ext.Panel({ "flex": 45, "border": false, "layout": "hbox", "labelWidth": 0, "hideCheckBoxLabels": true, "items": [ description1470, GuestsByEvent_grid1522 ], "autoScroll": false, "layoutConfig": { "align": "stretch" }, "frame": false, "labelAlign": "top" });
    var general_panel1524 = new Ext.Panel({ "layout": "vbox", "title": "General", "items": [ general_1_panel1437, general_2_panel1453, general_3_panel1460, general_4_panel1467, general_5_panel1523 ], "frame": true, "layoutConfig": { "align": "stretch" }, "hideCheckBoxLabels": true, "listeners": { "activate": Lino.on_tab_activate }, "autoScroll": false, "border": false, "bodyBorder": false, "labelAlign": "top" });
    var id1525 = new Ext.form.NumberField({ "autoHeight": true, "fieldLabel": "ID", "name": "id", "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("ID","(cal.Events.id) ") }, "anchor": "-20" });
    var created1526 = new Ext.form.DisplayField({ "disabled": true, "autoHeight": true, "fieldLabel": "Created", "name": "created", "listeners": { "render": Lino.quicktip_renderer("Erstellt","(cal.Events.created) ") }, "value": "<br>", "anchor": "-20" });
    var modified1527 = new Ext.form.DisplayField({ "disabled": true, "autoHeight": true, "fieldLabel": "Modified", "name": "modified", "listeners": { "render": Lino.quicktip_renderer("Bearbeitet","(cal.Events.modified) ") }, "value": "<br>", "anchor": "-20" });
    var state1528 = new Lino.ChoicesFieldElement({ "autoHeight": true, "forceSelection": true, "fieldLabel": "State", "allowBlank": false, "hiddenName": "stateHidden", "listeners": { "render": Lino.quicktip_renderer("Zustand","(cal.Events.state) ") }, "selectOnFocus": true, "anchor": "-20", "store": Lino.cal.EventStates, "name": "state" });
    var more_1_panel1529 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 99, "hideCheckBoxLabels": true, "items": [ { "flex": 8, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id1525, "labelAlign": "top" }, { "flex": 34, "autoHeight": true, "layout": "form", "xtype": "panel", "items": created1526, "labelAlign": "top" }, { "flex": 34, "autoHeight": true, "layout": "form", "xtype": "panel", "items": modified1527, "labelAlign": "top" }, { "flex": 22, "autoHeight": true, "layout": "form", "xtype": "panel", "items": state1528, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var outbox_MailsByController_grid1534 = new Lino.outbox.MailsByController.GridPanel({ "flex": 83, "listeners": { "render": Lino.quicktip_renderer("E-Mail-Ausg\u00e4nge","(outbox.outbox.MailsByController) ") }, "hide_top_toolbar": true, "containing_panel": this, "tools": [ Lino.show_in_own_window_button(Lino.outbox.MailsByController.grid) ], "preview_limit": 15, "master_panel": this });
    var more_panel1535 = new Ext.Panel({ "layout": "vbox", "title": "More", "items": [ more_1_panel1529, outbox_MailsByController_grid1534 ], "frame": true, "layoutConfig": { "align": "stretch" }, "hideCheckBoxLabels": true, "listeners": { "activate": Lino.on_tab_activate }, "autoScroll": false, "border": false, "bodyBorder": false, "labelAlign": "top" });
    var main_panel1536 = new Ext.TabPanel({ "hideCheckBoxLabels": true, "border": false, "split": true, "autoScroll": false, "items": [ general_panel1524, more_panel1535 ], "activeTab": 0, "bodyBorder": false, "frame": true, "labelAlign": "top" });
    this.items = main_panel1536;
    this.before_row_edit = function(record) {
      description1470.refresh();
      GuestsByEvent_grid1522.on_master_changed();
      outbox_MailsByController_grid1534.on_master_changed();
    }
    Lino.cal.Events.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.cal.Events.InsertFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  autoHeight: true,
  content_type: 40,
  initComponent : function() {
    var containing_panel = this;
    var summary1537 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Summary", "name": "summary", "maxLength": 200, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Kurzbeschreibung","(cal.Events.summary) ") }, "anchor": "-20" });
    var start_date1538 = new Lino.DateField({ "autoHeight": true, "fieldLabel": "Start date", "name": "start_date", "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Beginnt am","(cal.Events.start_date) ") }, "anchor": "-20" });
    var start_time1539 = new Lino.TimeField({ "autoHeight": true, "fieldLabel": "Start time", "name": "start_time", "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Beginnt um","(cal.Events.start_time) ") }, "anchor": "-20" });
    var start_panel1540 = new Ext.Panel({ "flex": 50, "autoHeight": true, "layout": "hbox", "items": [ { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": start_date1538, "labelAlign": "top" }, { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": start_time1539, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "autoScroll": false, "hideCheckBoxLabels": true, "labelWidth": 99, "border": false, "labelAlign": "top" });
    var end_date1543 = new Lino.DateField({ "autoHeight": true, "fieldLabel": "End Date", "name": "end_date", "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Endet am","(cal.Events.end_date) ") }, "anchor": "-20" });
    var end_time1544 = new Lino.TimeField({ "autoHeight": true, "fieldLabel": "End Time", "name": "end_time", "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Endet um","(cal.Events.end_time) ") }, "anchor": "-20" });
    var end_panel1545 = new Ext.Panel({ "flex": 50, "autoHeight": true, "layout": "hbox", "items": [ { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": end_date1543, "labelAlign": "top" }, { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": end_time1544, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "autoScroll": false, "hideCheckBoxLabels": true, "labelWidth": 81, "border": false, "labelAlign": "top" });
    var main_2_panel1548 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "hideCheckBoxLabels": true, "items": [ start_panel1540, end_panel1545 ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "anchor": "-20", "labelAlign": "top" });
    var calendar1549 = new Lino.TwinCombo({ "autoHeight": true, "fieldLabel": "Calendar", "name": "calendar", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.cal.Calendars.detail)}, "emptyText": "Select a Calendar...", "listeners": { "render": Lino.quicktip_renderer("Kalender","(cal.Events.calendar) ") }, "selectOnFocus": true, "hiddenName": "calendarHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/Events/calendar", "method": "GET" }) }) });
    var project1550 = new Lino.TwinCombo({ "preferred_width": 20, "autoHeight": true, "fieldLabel": "Client", "name": "project", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.pcsw.Clients.detail)}, "hiddenName": "projectHidden", "listeners": { "render": Lino.quicktip_renderer("Klient","(cal.Events.project) ") }, "selectOnFocus": true, "emptyText": "Select a Client...", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/Events/project", "method": "GET" }) }) });
    var main_3_panel1551 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": calendar1549, "labelAlign": "top" }, { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": project1550, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 81, "border": false, "anchor": "-20", "labelAlign": "top" });
    var main_panel1554 = new Ext.Panel({ "hideCheckBoxLabels": true, "autoHeight": true, "border": false, "layout": "form", "labelWidth": 153, "autoScroll": false, "items": [ { "autoHeight": true, "layout": "form", "xtype": "panel", "items": summary1537, "anchor": "-20", "labelAlign": "top" }, main_2_panel1548, main_3_panel1551 ], "frame": true, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel1554;
    this.before_row_edit = function(record) {
    }
    Lino.cal.Events.InsertFormPanel.superclass.initComponent.call(this);
  }
});


Lino.countries.Countries.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 16,
  initComponent : function() {
    var containing_panel = this;
    var isocode1029 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">ISO code</span>", "name": "isocode", "boxMinWidth": Lino.chars2width(4), "listeners": { "render": Lino.quicktip_renderer("ISO-Code","(countries.Countries.isocode)         The two-letter code for this country as defined by ISO 3166-1. \n        For countries that no longer exist it may be a 4-letter code.") }, "maxLength": 4, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var name1030 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Designation", "name": "name", "listeners": { "render": Lino.quicktip_renderer("Bezeichnung","(countries.Countries.name) ") }, "maxLength": 200, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var name_fr1031 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Designation (fr)", "name": "name_fr", "maxLength": 200, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Bezeichnung (fr)","(countries.Countries.name_fr) ") }, "anchor": "-20" });
    var name_de1032 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Designation (de)", "name": "name_de", "maxLength": 200, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Bezeichnung (de)","(countries.Countries.name_de) ") }, "anchor": "-20" });
    var name_nl1033 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Designation (nl)", "name": "name_nl", "listeners": { "render": Lino.quicktip_renderer("Bezeichnung (nl)","(countries.Countries.name_nl) ") }, "maxLength": 200, "selectOnFocus": true, "hidden": true, "anchor": "-20" });
    var short_code1034 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Short code</span>", "name": "short_code", "boxMinWidth": Lino.chars2width(4), "listeners": { "render": Lino.quicktip_renderer("Short code","(countries.Countries.short_code) A short abbreviation for regional usage. Obsolete.") }, "maxLength": 4, "selectOnFocus": true, "anchor": "-20" });
    var inscode1035 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">INS code</span>", "name": "inscode", "boxMinWidth": Lino.chars2width(3), "listeners": { "render": Lino.quicktip_renderer("INS-Code","(countries.Countries.inscode) The official code for this country used by statbel.fgov.be") }, "maxLength": 3, "selectOnFocus": true, "anchor": "-20" });
    var main_1_panel1036 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 153, "hideCheckBoxLabels": true, "items": [ { "flex": 5, "autoHeight": true, "layout": "form", "xtype": "panel", "items": isocode1029, "labelAlign": "top" }, { "flex": 21, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name1030, "labelAlign": "top" }, { "flex": 21, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_fr1031, "labelAlign": "top" }, { "flex": 21, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_de1032, "labelAlign": "top" }, { "flex": 21, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_nl1033, "hidden": true, "labelAlign": "top" }, { "flex": 5, "autoHeight": true, "layout": "form", "xtype": "panel", "items": short_code1034, "labelAlign": "top" }, { "flex": 4, "autoHeight": true, "layout": "form", "xtype": "panel", "items": inscode1035, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var countries_CitiesByCountry_grid1155 = new Lino.countries.CitiesByCountry.GridPanel({ "flex": 50, "listeners": { "render": Lino.quicktip_renderer("Orte","(countries.countries.CitiesByCountry) ") }, "hide_top_toolbar": true, "containing_panel": this, "tools": [ Lino.show_in_own_window_button(Lino.countries.CitiesByCountry.grid) ], "preview_limit": 15, "master_panel": this });
    var jobs_StudiesByCountry_grid1168 = new Lino.jobs.StudiesByCountry.GridPanel({ "flex": 50, "listeners": { "render": Lino.quicktip_renderer("Ausbildungen und Studien","(jobs.jobs.StudiesByCountry) ") }, "hide_top_toolbar": true, "containing_panel": this, "tools": [ Lino.show_in_own_window_button(Lino.jobs.StudiesByCountry.grid) ], "preview_limit": 15, "master_panel": this });
    var main_2_panel1169 = new Ext.Panel({ "flex": 83, "border": false, "layout": "hbox", "hideCheckBoxLabels": true, "items": [ countries_CitiesByCountry_grid1155, jobs_StudiesByCountry_grid1168 ], "autoScroll": false, "layoutConfig": { "align": "stretch" }, "frame": false, "labelAlign": "top" });
    var main_panel1170 = new Ext.Panel({ "autoScroll": false, "border": false, "layout": "vbox", "hideCheckBoxLabels": true, "items": [ main_1_panel1036, main_2_panel1169 ], "frame": true, "layoutConfig": { "align": "stretch" }, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel1170;
    this.before_row_edit = function(record) {
      countries_CitiesByCountry_grid1155.on_master_changed();
      jobs_StudiesByCountry_grid1168.on_master_changed();
    }
    Lino.countries.Countries.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.countries.Cities.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 17,
  initComponent : function() {
    var containing_panel = this;
    var name1054 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Designation", "name": "name", "listeners": { "render": Lino.quicktip_renderer("Bezeichnung","(countries.Cities.name) ") }, "maxLength": 200, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var name_fr1055 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Designation (fr)", "name": "name_fr", "maxLength": 200, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Bezeichnung (fr)","(countries.Cities.name_fr) ") }, "anchor": "-20" });
    var name_de1056 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Designation (de)", "name": "name_de", "maxLength": 200, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Bezeichnung (de)","(countries.Cities.name_de) ") }, "anchor": "-20" });
    var name_nl1057 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Designation (nl)", "name": "name_nl", "listeners": { "render": Lino.quicktip_renderer("Bezeichnung (nl)","(countries.Cities.name_nl) ") }, "maxLength": 200, "selectOnFocus": true, "hidden": true, "anchor": "-20" });
    var country1058 = new Lino.TwinCombo({ "autoHeight": true, "fieldLabel": "Country", "allowBlank": false, "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.countries.Countries.detail)}, "emptyText": "Select a Country...", "listeners": { "render": Lino.quicktip_renderer("Land","(countries.Cities.country) ") }, "selectOnFocus": true, "hiddenName": "countryHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/countries/Cities/country", "method": "GET" }) }), "name": "country" });
    var inscode1059 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">INS code</span>", "name": "inscode", "boxMinWidth": Lino.chars2width(5), "listeners": { "render": Lino.quicktip_renderer("INS-Code","(countries.Cities.inscode) The official code for this place used by statbel.fgov.be") }, "maxLength": 5, "selectOnFocus": true, "anchor": "-20" });
    var zip_code1060 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "zip code", "name": "zip_code", "boxMinWidth": Lino.chars2width(8), "listeners": { "render": Lino.quicktip_renderer("zip code","(countries.Cities.zip_code) ") }, "maxLength": 8, "selectOnFocus": true, "anchor": "-20" });
    var main_1_panel1061 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 153, "hideCheckBoxLabels": true, "items": [ { "flex": 17, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name1054, "labelAlign": "top" }, { "flex": 17, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_fr1055, "labelAlign": "top" }, { "flex": 17, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_de1056, "labelAlign": "top" }, { "flex": 17, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_nl1057, "hidden": true, "labelAlign": "top" }, { "flex": 16, "autoHeight": true, "layout": "form", "xtype": "panel", "items": country1058, "labelAlign": "top" }, { "flex": 5, "autoHeight": true, "layout": "form", "xtype": "panel", "items": inscode1059, "labelAlign": "top" }, { "flex": 7, "autoHeight": true, "layout": "form", "xtype": "panel", "items": zip_code1060, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var parent1069 = new Lino.TwinCombo({ "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Part of</span>", "name": "parent", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.countries.Cities.detail)}, "emptyText": "Select a Place...", "listeners": { "render": Lino.quicktip_renderer("Teil von","(countries.Cities.parent) The superordinate geographic place of which this place is a part.") }, "selectOnFocus": true, "hiddenName": "parentHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/countries/Cities/parent", "method": "GET" }) }) });
    var type1070 = new Lino.RemoteComboFieldElement({ "autoHeight": true, "fieldLabel": "Place Type", "name": "type", "hiddenName": "typeHidden", "listeners": { "render": Lino.quicktip_renderer("Ortsart","(countries.Cities.type) ") }, "selectOnFocus": true, "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/countries/Cities/type", "method": "GET" }) }) });
    var id1071 = new Ext.form.NumberField({ "autoHeight": true, "fieldLabel": "ID", "name": "id", "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("ID","(countries.Cities.id) ") }, "anchor": "-20" });
    var main_2_panel1072 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 81, "hideCheckBoxLabels": true, "items": [ { "flex": 57, "autoHeight": true, "layout": "form", "xtype": "panel", "items": parent1069, "labelAlign": "top" }, { "flex": 28, "autoHeight": true, "layout": "form", "xtype": "panel", "items": type1070, "labelAlign": "top" }, { "flex": 14, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id1071, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var CitiesByCity_grid1150 = new Lino.countries.CitiesByCity.GridPanel({ "flex": 41, "listeners": { "render": Lino.quicktip_renderer("Unterteilungen","(countries.countries.CitiesByCity) ") }, "hide_top_toolbar": true, "containing_panel": this, "tools": [ Lino.show_in_own_window_button(Lino.countries.CitiesByCity.grid) ], "preview_limit": 15, "master_panel": this });
    var contacts_PartnersByCity_grid1151 = new Lino.contacts.PartnersByCity.GridPanel({ "flex": 50, "listeners": { "render": Lino.quicktip_renderer("Partner","(contacts.contacts.PartnersByCity) ") }, "hide_top_toolbar": true, "containing_panel": this, "tools": [ Lino.show_in_own_window_button(Lino.contacts.PartnersByCity.grid) ], "preview_limit": 15, "master_panel": this });
    var jobs_StudiesByCity_grid1152 = new Lino.jobs.StudiesByCity.GridPanel({ "flex": 50, "listeners": { "render": Lino.quicktip_renderer("Ausbildungen und Studien","(jobs.jobs.StudiesByCity) ") }, "hide_top_toolbar": true, "containing_panel": this, "tools": [ Lino.show_in_own_window_button(Lino.jobs.StudiesByCity.grid) ], "preview_limit": 15, "master_panel": this });
    var main_4_panel1153 = new Ext.Panel({ "flex": 41, "border": false, "layout": "hbox", "hideCheckBoxLabels": true, "items": [ contacts_PartnersByCity_grid1151, jobs_StudiesByCity_grid1152 ], "autoScroll": false, "layoutConfig": { "align": "stretch" }, "frame": false, "labelAlign": "top" });
    var main_panel1154 = new Ext.Panel({ "autoScroll": false, "border": false, "layout": "vbox", "hideCheckBoxLabels": true, "items": [ main_1_panel1061, main_2_panel1072, CitiesByCity_grid1150, main_4_panel1153 ], "frame": true, "layoutConfig": { "align": "stretch" }, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel1154;
    this.before_row_edit = function(record) {
      type1070.setContextValue('country',record ? record.data['countryHidden'] : undefined);
      CitiesByCity_grid1150.on_master_changed();
      contacts_PartnersByCity_grid1151.on_master_changed();
      jobs_StudiesByCity_grid1152.on_master_changed();
    }
    this.onRender = function(ct, position) {
      country1058.on('change',Lino.chooser_handler(type1070,'country'));
      Lino.countries.Cities.DetailFormPanel.superclass.onRender.call(this, ct, position);
    }
    Lino.countries.Cities.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.courses.CourseProviders.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 84,
  initComponent : function() {
    var containing_panel = this;
    var prefix880 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "prefix", "name": "prefix", "maxLength": 200, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("prefix","(courses.CourseProviders.prefix) ") }, "anchor": "-20" });
    var name881 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Name", "name": "name", "listeners": { "render": Lino.quicktip_renderer("Name","(courses.CourseProviders.name) ") }, "maxLength": 200, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var id882 = new Ext.form.NumberField({ "autoHeight": true, "fieldLabel": "ID", "name": "id", "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("ID","(courses.CourseProviders.id) ") }, "anchor": "-20" });
    var language883 = new Lino.ChoicesFieldElement({ "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Language</span>", "allowBlank": false, "hiddenName": "languageHidden", "listeners": { "render": Lino.quicktip_renderer("Sprache","(courses.CourseProviders.language) Die Sprache, in der Dokumente ausgestellt werden sollen.") }, "selectOnFocus": true, "anchor": "-20", "store": [ [ "en", "English" ], [ "fr", "French" ], [ "de", "German" ], [ "nl", "Dutch" ] ], "name": "language" });
    var intro_box_1_panel884 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 31, "autoHeight": true, "layout": "form", "xtype": "panel", "items": prefix880, "labelAlign": "top" }, { "flex": 31, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name881, "labelAlign": "top" }, { "flex": 7, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id882, "labelAlign": "top" }, { "flex": 29, "autoHeight": true, "layout": "form", "xtype": "panel", "items": language883, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 72, "border": false, "anchor": "-20", "labelAlign": "top" });
    var vat_id889 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "VAT id", "name": "vat_id", "maxLength": 200, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("MWSt.-Nr.","(courses.CourseProviders.vat_id) ") }, "anchor": "-20" });
    var activity890 = new Lino.RemoteComboFieldElement({ "autoHeight": true, "fieldLabel": "activity", "name": "activity", "pageSize": 20, "emptyText": "Select a activity...", "listeners": { "render": Lino.quicktip_renderer("Beruf","(courses.CourseProviders.activity) ") }, "selectOnFocus": true, "hiddenName": "activityHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/courses/CourseProviders/activity", "method": "GET" }) }) });
    var type891 = new Lino.RemoteComboFieldElement({ "autoHeight": true, "fieldLabel": "Company type", "name": "type", "pageSize": 20, "emptyText": "Select a company type...", "listeners": { "render": Lino.quicktip_renderer("Organisationsart","(courses.CourseProviders.type) ") }, "selectOnFocus": true, "hiddenName": "typeHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/courses/CourseProviders/type", "method": "GET" }) }) });
    var intro_box_2_panel892 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 23, "autoHeight": true, "layout": "form", "xtype": "panel", "items": vat_id889, "labelAlign": "top" }, { "flex": 38, "autoHeight": true, "layout": "form", "xtype": "panel", "items": activity890, "labelAlign": "top" }, { "flex": 38, "autoHeight": true, "layout": "form", "xtype": "panel", "items": type891, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 153, "border": false, "anchor": "-20", "labelAlign": "top" });
    var bank_account1896 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Bank account 1", "name": "bank_account1", "maxLength": 40, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Bankkonto 1","(courses.CourseProviders.bank_account1) ") }, "anchor": "-20" });
    var bank_account2897 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Bank account 2", "name": "bank_account2", "maxLength": 40, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Bankkonto 2","(courses.CourseProviders.bank_account2) ") }, "anchor": "-20" });
    var is_obsolete898 = new Ext.form.Checkbox({ "autoHeight": true, "hideLabel": true, "checked": false, "name": "is_obsolete", "listeners": { "render": Lino.quicktip_renderer("veraltet","(courses.CourseProviders.is_obsolete) Altf\u00e4lle sind Partner, deren Stammdaten nicht mehr gepflegt werden und \nf\u00fcr neue Operationen nicht benutzt werden k\u00f6nnen.") }, "boxLabel": "obsolete", "selectOnFocus": true, "anchor": "-20" });
    var intro_box_3_panel899 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 40, "autoHeight": true, "layout": "form", "xtype": "panel", "items": bank_account1896, "labelAlign": "top" }, { "flex": 40, "autoHeight": true, "layout": "form", "xtype": "panel", "items": bank_account2897, "labelAlign": "top" }, { "flex": 19, "autoHeight": true, "layout": "form", "xtype": "panel", "items": is_obsolete898, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 108, "border": false, "anchor": "-20", "labelAlign": "top" });
    var intro_box_panel903 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "form", "hideCheckBoxLabels": true, "items": [ intro_box_1_panel884, intro_box_2_panel892, intro_box_3_panel899 ], "frame": true, "bodyBorder": false, "labelAlign": "top" });
    var country904 = new Lino.TwinCombo({ "autoHeight": true, "fieldLabel": "Country", "name": "country", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.countries.Countries.detail)}, "emptyText": "Select a Country...", "listeners": { "render": Lino.quicktip_renderer("Land","(courses.CourseProviders.country) ") }, "selectOnFocus": true, "hiddenName": "countryHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/courses/CourseProviders/country", "method": "GET" }) }) });
    var region905 = new Lino.TwinCombo({ "autoHeight": true, "fieldLabel": "Region", "name": "region", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.countries.Cities.detail)}, "emptyText": "Select a Place...", "listeners": { "render": Lino.quicktip_renderer("Region","(courses.CourseProviders.region) ") }, "selectOnFocus": true, "hiddenName": "regionHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/courses/CourseProviders/region", "method": "GET" }) }) });
    var box3_1_panel906 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": country904, "labelAlign": "top" }, { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": region905, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 63, "border": false, "anchor": "-20", "labelAlign": "top" });
    var city909 = new Lino.TwinCombo({ "autoHeight": true, "forceSelection": false, "fieldLabel": "Place", "name": "city", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.countries.Cities.detail)}, "emptyText": "Select a Place...", "listeners": { "render": Lino.quicktip_renderer("Ort","(courses.CourseProviders.city) ") }, "selectOnFocus": true, "hiddenName": "cityHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/courses/CourseProviders/city", "method": "GET" }) }) });
    var zip_code910 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Zip code", "name": "zip_code", "boxMinWidth": Lino.chars2width(10), "listeners": { "render": Lino.quicktip_renderer("Postleitzahl","(courses.CourseProviders.zip_code) ") }, "maxLength": 10, "selectOnFocus": true, "anchor": "-20" });
    var box3_2_panel911 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 66, "autoHeight": true, "layout": "form", "xtype": "panel", "items": city909, "labelAlign": "top" }, { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": zip_code910, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 117, "border": false, "anchor": "-20", "labelAlign": "top" });
    var street_prefix914 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Street prefix</span>", "name": "street_prefix", "maxLength": 200, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Pr\u00e4fix Stra\u00dfe","(courses.CourseProviders.street_prefix) Text to print before name of street, but to ignore for sorting.") }, "anchor": "-20" });
    var street915 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Street</span>", "name": "street", "maxLength": 200, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Stra\u00dfe","(courses.CourseProviders.street) Name of street. Without house number.") }, "anchor": "-20" });
    var street_no916 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">No.</span>", "name": "street_no", "boxMinWidth": Lino.chars2width(10), "listeners": { "render": Lino.quicktip_renderer("Nr.","(courses.CourseProviders.street_no) House number") }, "maxLength": 10, "selectOnFocus": true, "anchor": "-20" });
    var street_box917 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Box</span>", "name": "street_box", "boxMinWidth": Lino.chars2width(10), "listeners": { "render": Lino.quicktip_renderer("Box","(courses.CourseProviders.street_box) Text to print after :attr:`steet_no` on the same line") }, "maxLength": 10, "selectOnFocus": true, "anchor": "-20" });
    var box3_3_panel918 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 30, "autoHeight": true, "layout": "form", "xtype": "panel", "items": street_prefix914, "labelAlign": "top" }, { "flex": 36, "autoHeight": true, "layout": "form", "xtype": "panel", "items": street915, "labelAlign": "top" }, { "flex": 16, "autoHeight": true, "layout": "form", "xtype": "panel", "items": street_no916, "labelAlign": "top" }, { "flex": 16, "autoHeight": true, "layout": "form", "xtype": "panel", "items": street_box917, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 126, "border": false, "anchor": "-20", "labelAlign": "top" });
    var addr2923 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Address line after street</span>", "name": "addr2", "maxLength": 200, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Adresszeile nach Stra\u00dfe","(courses.CourseProviders.addr2) Address line to print below street line") }, "anchor": "-20" });
    var box3_panel924 = new Ext.Panel({ "flex": 62, "autoHeight": true, "layout": "form", "items": [ box3_1_panel906, box3_2_panel911, box3_3_panel918, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": addr2923, "anchor": "-20", "labelAlign": "top" } ], "frame": true, "bodyBorder": false, "autoScroll": false, "hideCheckBoxLabels": true, "labelWidth": 216, "border": false, "labelAlign": "top" });
    var email926 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "E-Mail", "name": "email", "maxLength": 75, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("E-Mail","(courses.CourseProviders.email) ") }, "anchor": "-20" });
    var url927 = new Lino.URLField({ "autoHeight": true, "fieldLabel": "URL", "name": "url", "maxLength": 200, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("URL","(courses.CourseProviders.url) ") }, "anchor": "-20" });
    var phone928 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Phone", "name": "phone", "maxLength": 200, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Telefon","(courses.CourseProviders.phone) ") }, "anchor": "-20" });
    var gsm929 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "GSM", "name": "gsm", "maxLength": 200, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("GSM","(courses.CourseProviders.gsm) ") }, "anchor": "-20" });
    var box4_panel930 = new Ext.Panel({ "flex": 37, "autoHeight": true, "layout": "form", "items": [ { "autoHeight": true, "layout": "form", "xtype": "panel", "items": email926, "anchor": "-20", "labelAlign": "top" }, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": url927, "anchor": "-20", "labelAlign": "top" }, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": phone928, "anchor": "-20", "labelAlign": "top" }, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": gsm929, "anchor": "-20", "labelAlign": "top" } ], "frame": true, "bodyBorder": false, "autoScroll": false, "hideCheckBoxLabels": true, "labelWidth": 72, "border": false, "labelAlign": "top" });
    var address_box_panel935 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "hideCheckBoxLabels": true, "items": [ box3_panel924, box4_panel930 ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var remarks936 = new Ext.form.TextArea({ "listeners": { "render": Lino.quicktip_renderer("Bemerkungen","(courses.CourseProviders.remarks) ") }, "fieldLabel": "Remarks", "name": "remarks", "growMax": 2000, "selectOnFocus": true, "anchor": "-20 -10" });
    var contacts_RolesByCompany_grid937 = new Lino.contacts.RolesByCompany.GridPanel({ "flex": 42, "listeners": { "render": Lino.quicktip_renderer("Kontaktpersonen","(contacts.contacts.RolesByCompany) ") }, "hide_top_toolbar": true, "containing_panel": this, "tools": [ Lino.show_in_own_window_button(Lino.contacts.RolesByCompany.grid) ], "preview_limit": 15, "master_panel": this });
    var bottom_box_panel938 = new Ext.Panel({ "flex": 41, "border": false, "layout": "hbox", "labelWidth": 108, "hideCheckBoxLabels": true, "items": [ { "items": remarks936, "labelAlign": "top", "layout": "form", "xtype": "panel", "flex": 57 }, contacts_RolesByCompany_grid937 ], "autoScroll": false, "layoutConfig": { "align": "stretch" }, "frame": false, "labelAlign": "top" });
    var general_panel940 = new Ext.Panel({ "layout": "vbox", "title": "General", "items": [ intro_box_panel903, address_box_panel935, bottom_box_panel938 ], "frame": true, "layoutConfig": { "align": "stretch" }, "hideCheckBoxLabels": true, "listeners": { "activate": Lino.on_tab_activate }, "autoScroll": false, "border": false, "bodyBorder": false, "labelAlign": "top" });
    var pcsw_NotesByCompany_grid941 = new Lino.pcsw.NotesByCompany.GridPanel({ "listeners": { "activate": Lino.on_tab_activate }, "hide_top_toolbar": true, "containing_panel": this, "title": "Events/Notes", "tools": [ Lino.show_in_own_window_button(Lino.pcsw.NotesByCompany.grid) ], "preview_limit": 15, "master_panel": this });
    var CourseOffersByProvider_grid1013 = new Lino.courses.CourseOffersByProvider.GridPanel({ "listeners": { "activate": Lino.on_tab_activate }, "hide_top_toolbar": true, "containing_panel": this, "title": "Course Offers", "tools": [ Lino.show_in_own_window_button(Lino.courses.CourseOffersByProvider.grid) ], "preview_limit": 15, "master_panel": this });
    var main_panel1014 = new Ext.TabPanel({ "hideCheckBoxLabels": true, "border": false, "split": true, "autoScroll": false, "items": [ general_panel940, pcsw_NotesByCompany_grid941, CourseOffersByProvider_grid1013 ], "activeTab": 0, "bodyBorder": false, "frame": true, "labelAlign": "top" });
    this.items = main_panel1014;
    this.before_row_edit = function(record) {
      region905.setContextValue('country',record ? record.data['countryHidden'] : undefined);
      city909.setContextValue('country',record ? record.data['countryHidden'] : undefined);
      city909.setContextValue('region',record ? record.data['regionHidden'] : undefined);
      contacts_RolesByCompany_grid937.on_master_changed();
      pcsw_NotesByCompany_grid941.on_master_changed();
      CourseOffersByProvider_grid1013.on_master_changed();
    }
    this.onRender = function(ct, position) {
      country904.on('change',Lino.chooser_handler(region905,'country'));
      country904.on('change',Lino.chooser_handler(city909,'country'));
      region905.on('change',Lino.chooser_handler(city909,'region'));
      Lino.courses.CourseProviders.DetailFormPanel.superclass.onRender.call(this, ct, position);
    }
    Lino.courses.CourseProviders.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.isip.StudyTypes.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 67,
  initComponent : function() {
    var containing_panel = this;
    var name3973 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Designation", "name": "name", "listeners": { "render": Lino.quicktip_renderer("Bezeichnung","(isip.StudyTypes.name) ") }, "maxLength": 200, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var name_fr3974 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Designation (fr)", "name": "name_fr", "maxLength": 200, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Bezeichnung (fr)","(isip.StudyTypes.name_fr) ") }, "anchor": "-20" });
    var name_de3975 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Designation (de)", "name": "name_de", "maxLength": 200, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Bezeichnung (de)","(isip.StudyTypes.name_de) ") }, "anchor": "-20" });
    var name_nl3976 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Designation (nl)", "name": "name_nl", "listeners": { "render": Lino.quicktip_renderer("Bezeichnung (nl)","(isip.StudyTypes.name_nl) ") }, "maxLength": 200, "selectOnFocus": true, "hidden": true, "anchor": "-20" });
    var id3977 = new Ext.form.NumberField({ "autoHeight": true, "fieldLabel": "ID", "name": "id", "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("ID","(isip.StudyTypes.id) ") }, "anchor": "-20" });
    var main_1_panel3978 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 153, "hideCheckBoxLabels": true, "items": [ { "flex": 23, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name3973, "labelAlign": "top" }, { "flex": 23, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_fr3974, "labelAlign": "top" }, { "flex": 23, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_de3975, "labelAlign": "top" }, { "flex": 23, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_nl3976, "hidden": true, "labelAlign": "top" }, { "flex": 5, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id3977, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var ContractsByStudyType_grid4004 = new Lino.isip.ContractsByStudyType.GridPanel({ "flex": 83, "hide_top_toolbar": true, "containing_panel": this, "params_panel_hidden": true, "master_panel": this, "preview_limit": 15, "listeners": { "render": Lino.quicktip_renderer("VSEs","(isip.isip.ContractsByStudyType) ") }, "tools": [ Lino.show_in_own_window_button(Lino.isip.ContractsByStudyType.grid) ] });
    var main_panel4005 = new Ext.Panel({ "autoScroll": false, "border": false, "layout": "vbox", "hideCheckBoxLabels": true, "items": [ main_1_panel3978, ContractsByStudyType_grid4004 ], "frame": true, "layoutConfig": { "align": "stretch" }, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel4005;
    this.before_row_edit = function(record) {
      ContractsByStudyType_grid4004.on_master_changed();
    }
    Lino.isip.StudyTypes.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.properties.PropTypes.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 20,
  initComponent : function() {
    var containing_panel = this;
    var id3288 = new Ext.form.NumberField({ "autoHeight": true, "fieldLabel": "ID", "name": "id", "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("ID","(properties.PropTypes.id) ") }, "anchor": "-20" });
    var name3289 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Designation", "name": "name", "listeners": { "render": Lino.quicktip_renderer("Bezeichnung","(properties.PropTypes.name) ") }, "maxLength": 200, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var name_fr3290 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Designation (fr)", "name": "name_fr", "maxLength": 200, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Bezeichnung (fr)","(properties.PropTypes.name_fr) ") }, "anchor": "-20" });
    var name_de3291 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Designation (de)", "name": "name_de", "maxLength": 200, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Bezeichnung (de)","(properties.PropTypes.name_de) ") }, "anchor": "-20" });
    var name_nl3292 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Designation (nl)", "name": "name_nl", "listeners": { "render": Lino.quicktip_renderer("Bezeichnung (nl)","(properties.PropTypes.name_nl) ") }, "maxLength": 200, "selectOnFocus": true, "hidden": true, "anchor": "-20" });
    var choicelist3293 = new Lino.ChoicesFieldElement({ "autoHeight": true, "fieldLabel": "Choices List", "name": "choicelist", "hiddenName": "choicelistHidden", "listeners": { "render": Lino.quicktip_renderer("Auswahliste","(properties.PropTypes.choicelist) ") }, "selectOnFocus": true, "anchor": "-20", "store": [ [ "countries.CityTypes", "CityTypes" ], [ "lino.ChangeTypes", "Change Types" ], [ "lino.Genders", "Genders" ], [ "lino.UserGroups", "User Groups" ], [ "lino.UserLevels", "User Levels" ], [ "lino.UserProfiles", "User Profiles" ], [ "lino.YesNo", "Yes or no" ], [ "properties.DoYouLike", "DoYouLike" ], [ "properties.HowWell", "HowWell" ] ] });
    var default_value3294 = new Lino.RemoteComboFieldElement({ "autoHeight": true, "fieldLabel": "default value", "name": "default_value", "hiddenName": "default_valueHidden", "listeners": { "render": Lino.quicktip_renderer("Standardwert","(properties.PropTypes.default_value) ") }, "selectOnFocus": true, "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/properties/PropTypes/default_value", "method": "GET" }) }) });
    var main_1_panel3295 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 4, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id3288, "labelAlign": "top" }, { "flex": 17, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name3289, "labelAlign": "top" }, { "flex": 17, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_fr3290, "labelAlign": "top" }, { "flex": 17, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_de3291, "labelAlign": "top" }, { "flex": 17, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_nl3292, "hidden": true, "labelAlign": "top" }, { "flex": 16, "autoHeight": true, "layout": "form", "xtype": "panel", "items": choicelist3293, "labelAlign": "top" }, { "flex": 8, "autoHeight": true, "layout": "form", "xtype": "panel", "items": default_value3294, "labelAlign": "top" } ], "region": "north", "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "split": true, "autoScroll": false, "labelWidth": 153, "border": false, "frame": false, "labelAlign": "top" });
    var ChoicesByType_grid3310 = new Lino.properties.ChoicesByType.GridPanel({ "flex": 5, "hide_top_toolbar": true, "containing_panel": this, "region": "center", "preview_limit": 15, "master_panel": this, "listeners": { "render": Lino.quicktip_renderer("Auswahlm\u00f6glichkeiten","(properties.properties.ChoicesByType) ") }, "split": true, "tools": [ Lino.show_in_own_window_button(Lino.properties.ChoicesByType.grid) ] });
    var PropsByType_grid3318 = new Lino.properties.PropsByType.GridPanel({ "flex": 5, "hide_top_toolbar": true, "containing_panel": this, "region": "south", "preview_limit": 15, "master_panel": this, "listeners": { "render": Lino.quicktip_renderer("Eigenschaften","(properties.properties.PropsByType) ") }, "split": true, "tools": [ Lino.show_in_own_window_button(Lino.properties.PropsByType.grid) ] });
    var main_panel3319 = new Lino.VBorderPanel({ "autoScroll": false, "border": false, "hideCheckBoxLabels": true, "items": [ main_1_panel3295, ChoicesByType_grid3310, PropsByType_grid3318 ], "frame": true, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel3319;
    this.before_row_edit = function(record) {
      default_value3294.setContextValue('choicelist',record ? record.data['choicelistHidden'] : undefined);
      ChoicesByType_grid3310.on_master_changed();
      PropsByType_grid3318.on_master_changed();
    }
    this.onRender = function(ct, position) {
      choicelist3293.on('change',Lino.chooser_handler(default_value3294,'choicelist'));
      Lino.properties.PropTypes.DetailFormPanel.superclass.onRender.call(this, ct, position);
    }
    Lino.properties.PropTypes.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.jobs.Regimes.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 81,
  initComponent : function() {
    var containing_panel = this;
    var id4222 = new Ext.form.NumberField({ "autoHeight": true, "fieldLabel": "ID", "name": "id", "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("ID","(jobs.Regimes.id) ") }, "anchor": "-20" });
    var name4223 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Designation", "name": "name", "listeners": { "render": Lino.quicktip_renderer("Bezeichnung","(jobs.Regimes.name) ") }, "maxLength": 200, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var name_fr4224 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Designation (fr)", "name": "name_fr", "maxLength": 200, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Bezeichnung (fr)","(jobs.Regimes.name_fr) ") }, "anchor": "-20" });
    var name_de4225 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Designation (de)", "name": "name_de", "maxLength": 200, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Bezeichnung (de)","(jobs.Regimes.name_de) ") }, "anchor": "-20" });
    var name_nl4226 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Designation (nl)", "name": "name_nl", "listeners": { "render": Lino.quicktip_renderer("Bezeichnung (nl)","(jobs.Regimes.name_nl) ") }, "maxLength": 200, "selectOnFocus": true, "hidden": true, "anchor": "-20" });
    var main_1_panel4227 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 153, "hideCheckBoxLabels": true, "items": [ { "flex": 5, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id4222, "labelAlign": "top" }, { "flex": 23, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name4223, "labelAlign": "top" }, { "flex": 23, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_fr4224, "labelAlign": "top" }, { "flex": 23, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_de4225, "labelAlign": "top" }, { "flex": 23, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_nl4226, "hidden": true, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var ContractsByRegime_grid4260 = new Lino.jobs.ContractsByRegime.GridPanel({ "flex": 83, "hide_top_toolbar": true, "containing_panel": this, "params_panel_hidden": true, "master_panel": this, "preview_limit": 15, "listeners": { "render": Lino.quicktip_renderer("Art.60\u00a77-Konventionen","(jobs.jobs.ContractsByRegime) ") }, "tools": [ Lino.show_in_own_window_button(Lino.jobs.ContractsByRegime.grid) ] });
    var main_panel4261 = new Ext.Panel({ "autoScroll": false, "border": false, "layout": "vbox", "hideCheckBoxLabels": true, "items": [ main_1_panel4227, ContractsByRegime_grid4260 ], "frame": true, "layoutConfig": { "align": "stretch" }, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel4261;
    this.before_row_edit = function(record) {
      ContractsByRegime_grid4260.on_master_changed();
    }
    Lino.jobs.Regimes.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.lino.Report.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  disable_editing: true,
  initComponent : function() {
    var containing_panel = this;
    var body_htmlbox2894 = new Lino.HtmlBoxPanel({ "layout": "fit", "name": "body", "containing_panel": this, "items": new Ext.BoxComponent({autoScroll:true}), "bodyStyle": "overflow-x:hidden;", "value": "<br/>", "always_enabled": true, "listeners": { "render": Lino.quicktip_renderer(null,"(lino.Report.body) ") } });
    var main_panel2895 = new Ext.Panel({ "autoScroll": false, "border": false, "layout": "fit", "labelWidth": 0, "hideCheckBoxLabels": true, "items": [ body_htmlbox2894 ], "frame": true, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel2895;
    this.before_row_edit = function(record) {
      body_htmlbox2894.refresh();
    }
    Lino.lino.Report.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.contacts.Partners.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 27,
  initComponent : function() {
    var containing_panel = this;
    var name754 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Name", "name": "name", "listeners": { "render": Lino.quicktip_renderer("Name","(contacts.Partners.name) ") }, "maxLength": 200, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var country755 = new Lino.TwinCombo({ "autoHeight": true, "fieldLabel": "Country", "name": "country", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.countries.Countries.detail)}, "emptyText": "Select a Country...", "listeners": { "render": Lino.quicktip_renderer("Land","(contacts.Partners.country) ") }, "selectOnFocus": true, "hiddenName": "countryHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/contacts/Partners/country", "method": "GET" }) }) });
    var region756 = new Lino.TwinCombo({ "autoHeight": true, "fieldLabel": "Region", "name": "region", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.countries.Cities.detail)}, "emptyText": "Select a Place...", "listeners": { "render": Lino.quicktip_renderer("Region","(contacts.Partners.region) ") }, "selectOnFocus": true, "hiddenName": "regionHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/contacts/Partners/region", "method": "GET" }) }) });
    var city757 = new Lino.TwinCombo({ "autoHeight": true, "forceSelection": false, "fieldLabel": "Place", "name": "city", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.countries.Cities.detail)}, "emptyText": "Select a Place...", "listeners": { "render": Lino.quicktip_renderer("Ort","(contacts.Partners.city) ") }, "selectOnFocus": true, "hiddenName": "cityHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/contacts/Partners/city", "method": "GET" }) }) });
    var zip_code758 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Zip code", "name": "zip_code", "boxMinWidth": Lino.chars2width(10), "listeners": { "render": Lino.quicktip_renderer("Postleitzahl","(contacts.Partners.zip_code) ") }, "maxLength": 10, "selectOnFocus": true, "anchor": "-20" });
    var address_box_2_panel759 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 28, "autoHeight": true, "layout": "form", "xtype": "panel", "items": country755, "labelAlign": "top" }, { "flex": 28, "autoHeight": true, "layout": "form", "xtype": "panel", "items": region756, "labelAlign": "top" }, { "flex": 28, "autoHeight": true, "layout": "form", "xtype": "panel", "items": city757, "labelAlign": "top" }, { "flex": 14, "autoHeight": true, "layout": "form", "xtype": "panel", "items": zip_code758, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 117, "border": false, "anchor": "-20", "labelAlign": "top" });
    var addr1764 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Address line before street</span>", "name": "addr1", "maxLength": 200, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Adresszeile vor Stra\u00dfe","(contacts.Partners.addr1) Address line before street") }, "anchor": "-20" });
    var street_prefix765 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Street prefix</span>", "name": "street_prefix", "maxLength": 200, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Pr\u00e4fix Stra\u00dfe","(contacts.Partners.street_prefix) Text to print before name of street, but to ignore for sorting.") }, "anchor": "-20" });
    var street766 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Street</span>", "name": "street", "maxLength": 200, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Stra\u00dfe","(contacts.Partners.street) Name of street. Without house number.") }, "anchor": "-20" });
    var street_no767 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">No.</span>", "name": "street_no", "boxMinWidth": Lino.chars2width(10), "listeners": { "render": Lino.quicktip_renderer("Nr.","(contacts.Partners.street_no) House number") }, "maxLength": 10, "selectOnFocus": true, "anchor": "-20" });
    var street_box768 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Box</span>", "name": "street_box", "boxMinWidth": Lino.chars2width(10), "listeners": { "render": Lino.quicktip_renderer("Box","(contacts.Partners.street_box) Text to print after :attr:`steet_no` on the same line") }, "maxLength": 10, "selectOnFocus": true, "anchor": "-20" });
    var address_box_4_panel769 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 30, "autoHeight": true, "layout": "form", "xtype": "panel", "items": street_prefix765, "labelAlign": "top" }, { "flex": 36, "autoHeight": true, "layout": "form", "xtype": "panel", "items": street766, "labelAlign": "top" }, { "flex": 16, "autoHeight": true, "layout": "form", "xtype": "panel", "items": street_no767, "labelAlign": "top" }, { "flex": 16, "autoHeight": true, "layout": "form", "xtype": "panel", "items": street_box768, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 126, "border": false, "anchor": "-20", "labelAlign": "top" });
    var addr2774 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Address line after street</span>", "name": "addr2", "maxLength": 200, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Adresszeile nach Stra\u00dfe","(contacts.Partners.addr2) Address line to print below street line") }, "anchor": "-20" });
    var address_box_panel775 = new Ext.form.FieldSet({ "flex": 66, "autoHeight": true, "layout": "form", "title": "Address", "items": [ { "autoHeight": true, "layout": "form", "xtype": "panel", "items": name754, "anchor": "-20", "labelAlign": "top" }, address_box_2_panel759, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": addr1764, "anchor": "-20", "labelAlign": "top" }, address_box_4_panel769, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": addr2774, "anchor": "-20", "labelAlign": "top" } ], "frame": true, "bodyBorder": false, "autoScroll": false, "hideCheckBoxLabels": true, "labelWidth": 216, "border": false, "labelAlign": "top" });
    var id779 = new Ext.form.NumberField({ "autoHeight": true, "fieldLabel": "ID", "name": "id", "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("ID","(contacts.Partners.id) ") }, "anchor": "-20" });
    var language780 = new Lino.ChoicesFieldElement({ "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Language</span>", "allowBlank": false, "hiddenName": "languageHidden", "listeners": { "render": Lino.quicktip_renderer("Sprache","(contacts.Partners.language) Die Sprache, in der Dokumente ausgestellt werden sollen.") }, "selectOnFocus": true, "anchor": "-20", "store": [ [ "en", "English" ], [ "fr", "French" ], [ "de", "German" ], [ "nl", "Dutch" ] ], "name": "language" });
    var info_box_panel781 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 20, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id779, "labelAlign": "top" }, { "flex": 80, "autoHeight": true, "layout": "form", "xtype": "panel", "items": language780, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 72, "border": false, "anchor": "-20", "labelAlign": "top" });
    var email784 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "E-Mail", "name": "email", "maxLength": 75, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("E-Mail","(contacts.Partners.email) ") }, "anchor": "-20" });
    var url785 = new Lino.URLField({ "autoHeight": true, "fieldLabel": "URL", "name": "url", "maxLength": 200, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("URL","(contacts.Partners.url) ") }, "anchor": "-20" });
    var phone786 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Phone", "name": "phone", "maxLength": 200, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Telefon","(contacts.Partners.phone) ") }, "anchor": "-20" });
    var gsm787 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "GSM", "name": "gsm", "maxLength": 200, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("GSM","(contacts.Partners.gsm) ") }, "anchor": "-20" });
    var fax788 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Fax", "name": "fax", "maxLength": 200, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Fax","(contacts.Partners.fax) ") }, "anchor": "-20" });
    var contact_box_5_panel789 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": gsm787, "labelAlign": "top" }, { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": fax788, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 36, "border": false, "anchor": "-20", "labelAlign": "top" });
    var contact_box_panel792 = new Ext.form.FieldSet({ "flex": 33, "autoHeight": true, "layout": "form", "title": "Contact", "items": [ info_box_panel781, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": email784, "anchor": "-20", "labelAlign": "top" }, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": url785, "anchor": "-20", "labelAlign": "top" }, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": phone786, "anchor": "-20", "labelAlign": "top" }, contact_box_5_panel789 ], "frame": true, "bodyBorder": false, "autoScroll": false, "hideCheckBoxLabels": true, "labelWidth": 72, "border": false, "labelAlign": "top" });
    var general_1_panel796 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "hideCheckBoxLabels": true, "items": [ address_box_panel775, contact_box_panel792 ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var remarks797 = new Ext.form.TextArea({ "listeners": { "render": Lino.quicktip_renderer("Bemerkungen","(contacts.Partners.remarks) ") }, "fieldLabel": "Remarks", "name": "remarks", "growMax": 2000, "selectOnFocus": true, "anchor": "-20 -10" });
    var activity798 = new Lino.RemoteComboFieldElement({ "autoHeight": true, "fieldLabel": "activity", "name": "activity", "pageSize": 20, "emptyText": "Select a activity...", "listeners": { "render": Lino.quicktip_renderer("Beruf","(contacts.Partners.activity) ") }, "selectOnFocus": true, "hiddenName": "activityHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/contacts/Partners/activity", "method": "GET" }) }) });
    var bank_account1799 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Bank account 1", "name": "bank_account1", "maxLength": 40, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Bankkonto 1","(contacts.Partners.bank_account1) ") }, "anchor": "-20" });
    var bank_account2800 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Bank account 2", "name": "bank_account2", "maxLength": 40, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Bankkonto 2","(contacts.Partners.bank_account2) ") }, "anchor": "-20" });
    var is_obsolete801 = new Ext.form.Checkbox({ "autoHeight": true, "hideLabel": true, "checked": false, "name": "is_obsolete", "listeners": { "render": Lino.quicktip_renderer("veraltet","(contacts.Partners.is_obsolete) Altf\u00e4lle sind Partner, deren Stammdaten nicht mehr gepflegt werden und \nf\u00fcr neue Operationen nicht benutzt werden k\u00f6nnen.") }, "boxLabel": "obsolete", "selectOnFocus": true, "anchor": "-20" });
    var bottom_box_2_panel802 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 108, "hideCheckBoxLabels": true, "items": [ { "flex": 27, "autoHeight": true, "layout": "form", "xtype": "panel", "items": activity798, "labelAlign": "top" }, { "flex": 29, "autoHeight": true, "layout": "form", "xtype": "panel", "items": bank_account1799, "labelAlign": "top" }, { "flex": 29, "autoHeight": true, "layout": "form", "xtype": "panel", "items": bank_account2800, "labelAlign": "top" }, { "flex": 13, "autoHeight": true, "layout": "form", "xtype": "panel", "items": is_obsolete801, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var is_person807 = new Ext.form.Checkbox({ "boxLabel": "is Person (<a href=\"javascript:Lino.show_mti_child('is_person',Lino.contacts.Persons.detail)\">show</a>)", "autoHeight": true, "hideLabel": true, "name": "is_person", "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("ist eine Person","(contacts.Partners.is_person) Ob dieser Partner auch eine Person ist.") }, "anchor": "-20" });
    var is_company808 = new Ext.form.Checkbox({ "boxLabel": "is Company (<a href=\"javascript:Lino.show_mti_child('is_company',Lino.contacts.Companies.detail)\">show</a>)", "autoHeight": true, "hideLabel": true, "name": "is_company", "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("ist eine Organisation","(contacts.Partners.is_company) Ob dieser Partner auch eine Organisation ist.") }, "anchor": "-20" });
    var is_household809 = new Ext.form.Checkbox({ "boxLabel": "is Household (<a href=\"javascript:Lino.show_mti_child('is_household',Lino.households.Households.detail)\">show</a>)", "autoHeight": true, "hideLabel": true, "name": "is_household", "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("ist ein Haushalt","(contacts.Partners.is_household) ") }, "anchor": "-20" });
    var created810 = new Ext.form.DisplayField({ "disabled": true, "autoHeight": true, "fieldLabel": "Created", "name": "created", "listeners": { "render": Lino.quicktip_renderer("Erstellt","(contacts.Partners.created) ") }, "value": "<br>", "anchor": "-20" });
    var modified811 = new Ext.form.DisplayField({ "disabled": true, "autoHeight": true, "fieldLabel": "Modified", "name": "modified", "listeners": { "render": Lino.quicktip_renderer("Bearbeitet","(contacts.Partners.modified) ") }, "value": "<br>", "anchor": "-20" });
    var bottom_box_3_panel812 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 198, "hideCheckBoxLabels": true, "items": [ { "flex": 16, "autoHeight": true, "layout": "form", "xtype": "panel", "items": is_person807, "labelAlign": "top" }, { "flex": 16, "autoHeight": true, "layout": "form", "xtype": "panel", "items": is_company808, "labelAlign": "top" }, { "flex": 16, "autoHeight": true, "layout": "form", "xtype": "panel", "items": is_household809, "labelAlign": "top" }, { "flex": 25, "autoHeight": true, "layout": "form", "xtype": "panel", "items": created810, "labelAlign": "top" }, { "flex": 25, "autoHeight": true, "layout": "form", "xtype": "panel", "items": modified811, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var bottom_box_panel818 = new Ext.Panel({ "flex": 58, "layout": "vbox", "items": [ { "items": remarks797, "labelAlign": "top", "layout": "form", "xtype": "panel", "flex": 71 }, bottom_box_2_panel802, bottom_box_3_panel812 ], "frame": true, "layoutConfig": { "align": "stretch" }, "autoScroll": false, "hideCheckBoxLabels": true, "labelWidth": 108, "border": false, "bodyBorder": false, "labelAlign": "top" });
    var general_panel820 = new Ext.Panel({ "layout": "vbox", "title": "General", "items": [ general_1_panel796, bottom_box_panel818 ], "frame": true, "layoutConfig": { "align": "stretch" }, "hideCheckBoxLabels": true, "listeners": { "activate": Lino.on_tab_activate }, "autoScroll": false, "border": false, "bodyBorder": false, "labelAlign": "top" });
    var changes_ChangesByMaster_grid845 = new Lino.changes.ChangesByMaster.GridPanel({ "listeners": { "activate": Lino.on_tab_activate }, "hide_top_toolbar": true, "containing_panel": this, "title": "Changes", "tools": [ Lino.show_in_own_window_button(Lino.changes.ChangesByMaster.grid) ], "preview_limit": 15, "master_panel": this });
    var debts_BudgetsByPartner_grid846 = new Lino.debts.BudgetsByPartner.GridPanel({ "flex": 5, "hide_top_toolbar": true, "containing_panel": this, "region": "north", "preview_limit": 15, "master_panel": this, "listeners": { "render": Lino.quicktip_renderer("Ist Hauptpartner in folgenden Budgets:","(debts.debts.BudgetsByPartner) ") }, "split": true, "tools": [ Lino.show_in_own_window_button(Lino.debts.BudgetsByPartner.grid) ] });
    var debts_ActorsByPartner_grid847 = new Lino.debts.ActorsByPartner.GridPanel({ "flex": 5, "hide_top_toolbar": true, "containing_panel": this, "region": "center", "preview_limit": 15, "master_panel": this, "listeners": { "render": Lino.quicktip_renderer("Ist Akteur in folgenden Budgets:","(debts.debts.ActorsByPartner) ") }, "split": true, "tools": [ Lino.show_in_own_window_button(Lino.debts.ActorsByPartner.grid) ] });
    var debts_panel848 = new Lino.VBorderPanel({ "autoScroll": false, "listeners": { "activate": Lino.on_tab_activate }, "border": false, "title": "Debts mediation", "hideCheckBoxLabels": true, "items": [ debts_BudgetsByPartner_grid846, debts_ActorsByPartner_grid847 ], "frame": true, "bodyBorder": false, "labelAlign": "top" });
    var main_panel849 = new Ext.TabPanel({ "hideCheckBoxLabels": true, "border": false, "split": true, "autoScroll": false, "items": [ general_panel820, changes_ChangesByMaster_grid845, debts_panel848 ], "activeTab": 0, "bodyBorder": false, "frame": true, "labelAlign": "top" });
    this.items = main_panel849;
    this.before_row_edit = function(record) {
      region756.setContextValue('country',record ? record.data['countryHidden'] : undefined);
      city757.setContextValue('country',record ? record.data['countryHidden'] : undefined);
      city757.setContextValue('region',record ? record.data['regionHidden'] : undefined);
      changes_ChangesByMaster_grid845.on_master_changed();
      debts_BudgetsByPartner_grid846.on_master_changed();
      debts_ActorsByPartner_grid847.on_master_changed();
    }
    this.onRender = function(ct, position) {
      country755.on('change',Lino.chooser_handler(region756,'country'));
      country755.on('change',Lino.chooser_handler(city757,'country'));
      region756.on('change',Lino.chooser_handler(city757,'region'));
      Lino.contacts.Partners.DetailFormPanel.superclass.onRender.call(this, ct, position);
    }
    Lino.contacts.Partners.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.jobs.Sectors.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 69,
  initComponent : function() {
    var containing_panel = this;
    var id4093 = new Ext.form.NumberField({ "autoHeight": true, "fieldLabel": "ID", "name": "id", "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("ID","(jobs.Sectors.id) ") }, "anchor": "-20" });
    var name4094 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Designation", "name": "name", "listeners": { "render": Lino.quicktip_renderer("Bezeichnung","(jobs.Sectors.name) ") }, "maxLength": 200, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var name_fr4095 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Designation (fr)", "name": "name_fr", "maxLength": 200, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Bezeichnung (fr)","(jobs.Sectors.name_fr) ") }, "anchor": "-20" });
    var name_de4096 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Designation (de)", "name": "name_de", "maxLength": 200, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Bezeichnung (de)","(jobs.Sectors.name_de) ") }, "anchor": "-20" });
    var name_nl4097 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Designation (nl)", "name": "name_nl", "listeners": { "render": Lino.quicktip_renderer("Bezeichnung (nl)","(jobs.Sectors.name_nl) ") }, "maxLength": 200, "selectOnFocus": true, "hidden": true, "anchor": "-20" });
    var main_1_panel4098 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 5, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id4093, "labelAlign": "top" }, { "flex": 23, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name4094, "labelAlign": "top" }, { "flex": 23, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_fr4095, "labelAlign": "top" }, { "flex": 23, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_de4096, "labelAlign": "top" }, { "flex": 23, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_nl4097, "hidden": true, "labelAlign": "top" } ], "region": "north", "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "split": true, "autoScroll": false, "labelWidth": 153, "border": false, "frame": false, "labelAlign": "top" });
    var remark4104 = new Ext.form.TextArea({ "listeners": { "render": Lino.quicktip_renderer("Bemerkung","(jobs.Sectors.remark) ") }, "fieldLabel": "Remark", "name": "remark", "growMax": 2000, "selectOnFocus": true, "anchor": "-20 -10" });
    var FunctionsBySector_grid4149 = new Lino.jobs.FunctionsBySector.GridPanel({ "flex": 66, "listeners": { "render": Lino.quicktip_renderer("Funktionen","(jobs.jobs.FunctionsBySector) ") }, "hide_top_toolbar": true, "containing_panel": this, "tools": [ Lino.show_in_own_window_button(Lino.jobs.FunctionsBySector.grid) ], "preview_limit": 15, "master_panel": this });
    var main_2_panel4150 = new Ext.Panel({ "flex": 5, "layout": "hbox", "items": [ { "items": remark4104, "labelAlign": "top", "layout": "form", "xtype": "panel", "flex": 33 }, FunctionsBySector_grid4149 ], "region": "center", "layoutConfig": { "align": "stretch" }, "hideCheckBoxLabels": true, "split": true, "autoScroll": false, "labelWidth": 90, "border": false, "frame": false, "labelAlign": "top" });
    var CandidaturesBySector_grid4160 = new Lino.jobs.CandidaturesBySector.GridPanel({ "flex": 5, "hide_top_toolbar": true, "containing_panel": this, "region": "south", "preview_limit": 15, "master_panel": this, "listeners": { "render": Lino.quicktip_renderer("Stellenanfragen","(jobs.jobs.CandidaturesBySector) ") }, "split": true, "tools": [ Lino.show_in_own_window_button(Lino.jobs.CandidaturesBySector.grid) ] });
    var main_panel4161 = new Lino.VBorderPanel({ "autoScroll": false, "border": false, "hideCheckBoxLabels": true, "items": [ main_1_panel4098, main_2_panel4150, CandidaturesBySector_grid4160 ], "frame": true, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel4161;
    this.before_row_edit = function(record) {
      FunctionsBySector_grid4149.on_master_changed();
      CandidaturesBySector_grid4160.on_master_changed();
    }
    Lino.jobs.Sectors.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.notes.Notes.InsertFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  autoHeight: true,
  content_type: 98,
  initComponent : function() {
    var containing_panel = this;
    var event_type334 = new Lino.TwinCombo({ "autoHeight": true, "fieldLabel": "Event Type (Form)", "name": "event_type", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.notes.EventTypes.detail)}, "emptyText": "Select a Event Type...", "listeners": { "render": Lino.quicktip_renderer("Ereignisart (Form)","(notes.Notes.event_type) ") }, "selectOnFocus": true, "hiddenName": "event_typeHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/notes/Notes/event_type", "method": "GET" }) }) });
    var type335 = new Lino.TwinCombo({ "autoHeight": true, "fieldLabel": "Note Type (Content)", "name": "type", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.notes.NoteTypes.detail)}, "emptyText": "Select a Note Type...", "listeners": { "render": Lino.quicktip_renderer("Notizart (Inhalt)","(notes.Notes.type) ") }, "selectOnFocus": true, "hiddenName": "typeHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/notes/Notes/type", "method": "GET" }) }) });
    var main_1_panel336 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": event_type334, "labelAlign": "top" }, { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": type335, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 171, "border": false, "anchor": "-20", "labelAlign": "top" });
    var subject339 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Subject", "name": "subject", "maxLength": 200, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Betreff","(notes.Notes.subject) ") }, "anchor": "-20" });
    var project340 = new Lino.TwinCombo({ "preferred_width": 20, "autoHeight": true, "fieldLabel": "Client", "name": "project", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.pcsw.Clients.detail)}, "hiddenName": "projectHidden", "listeners": { "render": Lino.quicktip_renderer("Klient","(notes.Notes.project) ") }, "selectOnFocus": true, "emptyText": "Select a Client...", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/notes/Notes/project", "method": "GET" }) }) });
    var company341 = new Lino.TwinCombo({ "preferred_width": 20, "autoHeight": true, "fieldLabel": "Recipient (Organization)", "name": "company", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.contacts.Companies.detail)}, "hiddenName": "companyHidden", "listeners": { "render": Lino.quicktip_renderer("Empf\u00e4nger (Organisation)","(notes.Notes.company) ") }, "selectOnFocus": true, "emptyText": "Select a Company...", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/notes/Notes/company", "method": "GET" }) }) });
    var main_3_panel342 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": project340, "labelAlign": "top" }, { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": company341, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 225, "border": false, "anchor": "-20", "labelAlign": "top" });
    var main_panel345 = new Ext.Panel({ "hideCheckBoxLabels": true, "autoHeight": true, "border": false, "layout": "form", "labelWidth": 72, "autoScroll": false, "items": [ main_1_panel336, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": subject339, "anchor": "-20", "labelAlign": "top" }, main_3_panel342 ], "frame": true, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel345;
    this.before_row_edit = function(record) {
    }
    Lino.notes.Notes.InsertFormPanel.superclass.initComponent.call(this);
  }
});


Lino.isip.ExamPolicies.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 66,
  initComponent : function() {
    var containing_panel = this;
    var id3897 = new Ext.form.NumberField({ "autoHeight": true, "fieldLabel": "ID", "name": "id", "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("ID","(isip.ExamPolicies.id) ") }, "anchor": "-20" });
    var name3898 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Designation", "name": "name", "listeners": { "render": Lino.quicktip_renderer("Bezeichnung","(isip.ExamPolicies.name) ") }, "maxLength": 200, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var name_fr3899 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Designation (fr)", "name": "name_fr", "maxLength": 200, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Bezeichnung (fr)","(isip.ExamPolicies.name_fr) ") }, "anchor": "-20" });
    var name_de3900 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Designation (de)", "name": "name_de", "maxLength": 200, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Bezeichnung (de)","(isip.ExamPolicies.name_de) ") }, "anchor": "-20" });
    var name_nl3901 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Designation (nl)", "name": "name_nl", "listeners": { "render": Lino.quicktip_renderer("Bezeichnung (nl)","(isip.ExamPolicies.name_nl) ") }, "maxLength": 200, "selectOnFocus": true, "hidden": true, "anchor": "-20" });
    var main_1_panel3902 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 153, "hideCheckBoxLabels": true, "items": [ { "flex": 5, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id3897, "labelAlign": "top" }, { "flex": 23, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name3898, "labelAlign": "top" }, { "flex": 23, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_fr3899, "labelAlign": "top" }, { "flex": 23, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_de3900, "labelAlign": "top" }, { "flex": 23, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_nl3901, "hidden": true, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var max_events3908 = new Ext.form.NumberField({ "autoHeight": true, "fieldLabel": "Number of events", "name": "max_events", "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Anzahl Termine","(isip.ExamPolicies.max_events) ") }, "anchor": "-20" });
    var every3909 = new Ext.form.NumberField({ "autoHeight": true, "fieldLabel": "Repeat every", "name": "every", "value": 0, "listeners": { "render": Lino.quicktip_renderer("... alle","(isip.ExamPolicies.every) ") }, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var every_unit3910 = new Lino.ChoicesFieldElement({ "autoHeight": true, "forceSelection": true, "fieldLabel": "Recurrency", "name": "every_unit", "hiddenName": "every_unitHidden", "listeners": { "render": Lino.quicktip_renderer("Wiederholung","(isip.ExamPolicies.every_unit) ") }, "selectOnFocus": true, "anchor": "-20", "store": [['','<br>']].concat(Lino.cal.Recurrencies) });
    var calendar3911 = new Lino.TwinCombo({ "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Calendar</span>", "name": "calendar", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.cal.Calendars.detail)}, "emptyText": "Select a Calendar...", "listeners": { "render": Lino.quicktip_renderer("Kalender","(isip.ExamPolicies.calendar) The calendar to which events will be generated.") }, "selectOnFocus": true, "hiddenName": "calendarHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/isip/ExamPolicies/calendar", "method": "GET" }) }) });
    var main_2_panel3912 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 135, "hideCheckBoxLabels": true, "items": [ { "flex": 11, "autoHeight": true, "layout": "form", "xtype": "panel", "items": max_events3908, "labelAlign": "top" }, { "flex": 11, "autoHeight": true, "layout": "form", "xtype": "panel", "items": every3909, "labelAlign": "top" }, { "flex": 31, "autoHeight": true, "layout": "form", "xtype": "panel", "items": every_unit3910, "labelAlign": "top" }, { "flex": 45, "autoHeight": true, "layout": "form", "xtype": "panel", "items": calendar3911, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var isip_ContractsByPolicy_grid3937 = new Lino.isip.ContractsByPolicy.GridPanel({ "flex": 41, "hide_top_toolbar": true, "containing_panel": this, "params_panel_hidden": true, "master_panel": this, "preview_limit": 15, "listeners": { "render": Lino.quicktip_renderer("VSEs","(isip.isip.ContractsByPolicy) ") }, "tools": [ Lino.show_in_own_window_button(Lino.isip.ContractsByPolicy.grid) ] });
    var jobs_ContractsByPolicy_grid3965 = new Lino.jobs.ContractsByPolicy.GridPanel({ "flex": 41, "hide_top_toolbar": true, "containing_panel": this, "params_panel_hidden": true, "master_panel": this, "preview_limit": 15, "listeners": { "render": Lino.quicktip_renderer("Art.60\u00a77-Konventionen","(jobs.jobs.ContractsByPolicy) ") }, "tools": [ Lino.show_in_own_window_button(Lino.jobs.ContractsByPolicy.grid) ] });
    var main_panel3966 = new Ext.Panel({ "autoScroll": false, "border": false, "layout": "vbox", "hideCheckBoxLabels": true, "items": [ main_1_panel3902, main_2_panel3912, isip_ContractsByPolicy_grid3937, jobs_ContractsByPolicy_grid3965 ], "frame": true, "layoutConfig": { "align": "stretch" }, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel3966;
    this.before_row_edit = function(record) {
      isip_ContractsByPolicy_grid3937.on_master_changed();
      jobs_ContractsByPolicy_grid3965.on_master_changed();
    }
    Lino.isip.ExamPolicies.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.outbox.Mails.InsertFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 31,
  initComponent : function() {
    var containing_panel = this;
    var project271 = new Lino.TwinCombo({ "preferred_width": 20, "autoHeight": true, "fieldLabel": "Client", "name": "project", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.pcsw.Clients.detail)}, "hiddenName": "projectHidden", "listeners": { "render": Lino.quicktip_renderer("Klient","(outbox.Mails.project) ") }, "selectOnFocus": true, "emptyText": "Select a Client...", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/outbox/Mails/project", "method": "GET" }) }) });
    var subject272 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Subject", "name": "subject", "maxLength": 200, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Betreff","(outbox.Mails.subject) ") }, "anchor": "-20" });
    var body273 = new Lino.RichTextPanel({ "selectOnFocus": true, "flex": 71, "containing_panel": this, "name": "body", "title": "Body" });
    var main_panel274 = new Ext.Panel({ "autoScroll": false, "border": false, "layout": "vbox", "labelWidth": 72, "hideCheckBoxLabels": true, "items": [ { "items": project271, "autoHeight": true, "layout": "form", "xtype": "panel", "labelAlign": "top" }, { "items": subject272, "autoHeight": true, "layout": "form", "xtype": "panel", "labelAlign": "top" }, body273 ], "frame": true, "layoutConfig": { "align": "stretch" }, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel274;
    this.before_row_edit = function(record) {
      body273.refresh();
    }
    Lino.outbox.Mails.InsertFormPanel.superclass.initComponent.call(this);
  }
});


Lino.about.About.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  disable_editing: true,
  initComponent : function() {
    var containing_panel = this;
    var server_status_disp5093 = new Ext.form.DisplayField({ "autoHeight": true, "fieldLabel": "Server status", "name": "server_status", "value": "<br/>", "always_enabled": true, "disabled": true, "listeners": { "render": Lino.quicktip_renderer("Server-Status","(about.About.server_status) ") }, "anchor": "-20" });
    var main_panel5094 = new Ext.Panel({ "autoScroll": false, "border": false, "layout": "vbox", "labelWidth": 126, "hideCheckBoxLabels": true, "items": [ { "flex": 25, "html": "<div class=\"htmlText\"><span>This is <a href=\"http://welfare.lino-framework.org\" target=\"_blank\">Lino Welfare</a> 1.1.9 using <a href=\"http://www.lino-framework.org\" target=\"_blank\">Lino</a> 1.6.12, <a href=\"http://north.lino-framework.org\" target=\"_blank\">North</a> 0.1.7, <a href=\"http://site.lino-framework.org\" target=\"_blank\">djangosite</a> 0.1.8, <a href=\"http://www.djangoproject.com\" target=\"_blank\">Django</a> 1.5.1, <a href=\"http://www.python.org/\" target=\"_blank\">Python</a> 2.7.3, <a href=\"http://babel.edgewall.org/\" target=\"_blank\">Babel</a> 1.0, <a href=\"http://jinja.pocoo.org/\" target=\"_blank\">Jinja</a> 2.6, <a href=\"http://sphinx-doc.org/\" target=\"_blank\">Sphinx</a> 1.2b1, <a href=\"http://labix.org/python-dateutil\" target=\"_blank\">python-dateutil</a> 2.1, <a href=\"http://pypi.python.org/pypi/odfpy\" target=\"_blank\">OdfPy</a> ODFPY/0.9.6, <a href=\"http://docutils.sourceforge.net/\" target=\"_blank\">docutils</a> 0.8.1, <a href=\"https://fedorahosted.org/suds/\" target=\"_blank\">suds</a> 0.4, <a href=\"http://pyyaml.org/\" target=\"_blank\">PyYaml</a> 3.10, <a href=\"http://appyframework.org/pod.html\" target=\"_blank\">Appy</a> 0.8.3 (2013/02/22 15:29), <a href=\"http://www.sencha.com\" target=\"_blank\">ExtJS</a> <a href=\"#\" onclick=\"alert('ExtJS client version is ' + Ext.version);\" title=\"Click to see ExtJS client version\">(version)</a>, <a href=\"http://ext.ensible.com/products/calendar/\" target=\"_blank\">Extensible</a> <a href=\"#\" onclick=\"alert('Extensible Calendar version is ' + Ext.ensible.version);\" title=\"Click to see Extensible Calendar version\">(version)</a>, <a href=\"http://www.famfamfam.com/lab/icons/silk/\" target=\"_blank\">Silk Icons</a> 1.3</span><p>Server l&#228;uft seit : <b>Dienstag, 24. September 2013 um 21:48:17.930998</b></p><p>Source timestamps:</p><ul><li>lino : <b>Dienstag, 24. September 2013 um 21:41:05.295918</b></li><li>lino_welfare : <b>Montag, 23. September 2013 um 21:38:24.172139</b></li><li>djangosite : <b>Sonntag, 15. September 2013 um 15:07:52.398691</b></li><li>north : <b>Mittwoch, 11. September 2013 um 11:18:49.521708</b></li><li>atelier : <b>Sonntag, 8. September 2013 um 18:48:36.565282</b></li><li>django : <b>Freitag, 30. August 2013 um 13:02:10.834631</b></li></ul></div>", "xtype": "label" }, { "items": server_status_disp5093, "autoHeight": true, "layout": "form", "xtype": "panel", "labelAlign": "top" } ], "frame": true, "layoutConfig": { "align": "stretch" }, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel5094;
    this.before_row_edit = function(record) {
    }
    Lino.about.About.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.jobs.ContractTypes.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 78,
  initComponent : function() {
    var containing_panel = this;
    var id4016 = new Ext.form.NumberField({ "autoHeight": true, "fieldLabel": "ID", "name": "id", "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("ID","(jobs.ContractTypes.id) ") }, "anchor": "-20" });
    var name4017 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Designation", "name": "name", "listeners": { "render": Lino.quicktip_renderer("Bezeichnung","(jobs.ContractTypes.name) ") }, "maxLength": 200, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var name_fr4018 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Designation (fr)", "name": "name_fr", "maxLength": 200, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Bezeichnung (fr)","(jobs.ContractTypes.name_fr) ") }, "anchor": "-20" });
    var name_de4019 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Designation (de)", "name": "name_de", "maxLength": 200, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Bezeichnung (de)","(jobs.ContractTypes.name_de) ") }, "anchor": "-20" });
    var name_nl4020 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Designation (nl)", "name": "name_nl", "listeners": { "render": Lino.quicktip_renderer("Bezeichnung (nl)","(jobs.ContractTypes.name_nl) ") }, "maxLength": 200, "selectOnFocus": true, "hidden": true, "anchor": "-20" });
    var main_1_panel4021 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 153, "hideCheckBoxLabels": true, "items": [ { "flex": 5, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id4016, "labelAlign": "top" }, { "flex": 23, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name4017, "labelAlign": "top" }, { "flex": 23, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_fr4018, "labelAlign": "top" }, { "flex": 23, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_de4019, "labelAlign": "top" }, { "flex": 23, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_nl4020, "hidden": true, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var ref4027 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Reference", "name": "ref", "maxLength": 20, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Referenz","(jobs.ContractTypes.ref) ") }, "anchor": "-20" });
    var build_method4028 = new Lino.ChoicesFieldElement({ "autoHeight": true, "fieldLabel": "Build method", "name": "build_method", "hiddenName": "build_methodHidden", "listeners": { "render": Lino.quicktip_renderer("Konstruktionsmethode","(jobs.ContractTypes.build_method) ") }, "selectOnFocus": true, "anchor": "-20", "store": [ [ "appyodt", "AppyOdtBuildMethod" ], [ "appypdf", "AppyPdfBuildMethod" ], [ "appyrtf", "AppyRtfBuildMethod" ], [ "latex", "LatexBuildMethod" ], [ "pisa", "PisaBuildMethod" ], [ "rtf", "RtfBuildMethod" ] ] });
    var template4029 = new Lino.SimpleRemoteComboFieldElement({ "autoHeight": true, "fieldLabel": "Template", "name": "template", "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Vorlage","(jobs.ContractTypes.template) ") }, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/jobs/ContractTypes/template", "method": "GET" }) }), "anchor": "-20" });
    var main_2_panel4030 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 189, "hideCheckBoxLabels": true, "items": [ { "flex": 41, "autoHeight": true, "layout": "form", "xtype": "panel", "items": ref4027, "labelAlign": "top" }, { "flex": 39, "autoHeight": true, "layout": "form", "xtype": "panel", "items": build_method4028, "labelAlign": "top" }, { "flex": 19, "autoHeight": true, "layout": "form", "xtype": "panel", "items": template4029, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var ContractsByType_grid4062 = new Lino.jobs.ContractsByType.GridPanel({ "flex": 71, "hide_top_toolbar": true, "containing_panel": this, "params_panel_hidden": true, "master_panel": this, "preview_limit": 15, "listeners": { "render": Lino.quicktip_renderer("Art.60\u00a77-Konventionen","(jobs.jobs.ContractsByType) ") }, "tools": [ Lino.show_in_own_window_button(Lino.jobs.ContractsByType.grid) ] });
    var main_panel4063 = new Ext.Panel({ "autoScroll": false, "border": false, "layout": "vbox", "hideCheckBoxLabels": true, "items": [ main_1_panel4021, main_2_panel4030, ContractsByType_grid4062 ], "frame": true, "layoutConfig": { "align": "stretch" }, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel4063;
    this.before_row_edit = function(record) {
      template4029.setContextValue('build_method',record ? record.data['build_methodHidden'] : undefined);
      ContractsByType_grid4062.on_master_changed();
    }
    this.onRender = function(ct, position) {
      build_method4028.on('change',Lino.chooser_handler(template4029,'build_method'));
      Lino.jobs.ContractTypes.DetailFormPanel.superclass.onRender.call(this, ct, position);
    }
    Lino.jobs.ContractTypes.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.uploads.Uploads.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 30,
  initComponent : function() {
    var containing_panel = this;
    var file4429 = Lino.file_field_handler(this,{ "autoHeight": true, "fieldLabel": "File", "name": "file", "listeners": { "render": Lino.quicktip_renderer("File","(uploads.Uploads.file) ") }, "maxLength": 100, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var user4430 = new Lino.TwinCombo({ "preferred_width": 15, "autoHeight": true, "fieldLabel": "Author", "name": "user", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.users.Users.detail)}, "hiddenName": "userHidden", "listeners": { "render": Lino.quicktip_renderer("Autor","(uploads.Uploads.user) ") }, "selectOnFocus": true, "emptyText": "Select a User...", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/uploads/Uploads/user", "method": "GET" }) }) });
    var main_1_panel4431 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 54, "hideCheckBoxLabels": true, "items": [ { "flex": 51, "autoHeight": true, "layout": "form", "xtype": "panel", "items": file4429, "labelAlign": "top" }, { "flex": 48, "autoHeight": true, "layout": "form", "xtype": "panel", "items": user4430, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var type4434 = new Lino.RemoteComboFieldElement({ "autoHeight": true, "fieldLabel": "Upload Type", "name": "type", "pageSize": 20, "emptyText": "Select a Upload Type...", "listeners": { "render": Lino.quicktip_renderer("Upload-Art","(uploads.Uploads.type) ") }, "selectOnFocus": true, "hiddenName": "typeHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/uploads/Uploads/type", "method": "GET" }) }) });
    var description4435 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Description", "name": "description", "maxLength": 200, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Beschreibung","(uploads.Uploads.description) ") }, "anchor": "-20" });
    var valid_until4436 = new Lino.DateField({ "autoHeight": true, "fieldLabel": "valid until", "name": "valid_until", "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("g\u00fcltig bis","(uploads.Uploads.valid_until) ") }, "anchor": "-20" });
    var main_2_panel4437 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 117, "hideCheckBoxLabels": true, "items": [ { "flex": 40, "autoHeight": true, "layout": "form", "xtype": "panel", "items": type4434, "labelAlign": "top" }, { "flex": 42, "autoHeight": true, "layout": "form", "xtype": "panel", "items": description4435, "labelAlign": "top" }, { "flex": 16, "autoHeight": true, "layout": "form", "xtype": "panel", "items": valid_until4436, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var modified4441 = new Ext.form.DisplayField({ "disabled": true, "autoHeight": true, "fieldLabel": "Modified", "name": "modified", "listeners": { "render": Lino.quicktip_renderer("Bearbeitet","(uploads.Uploads.modified) ") }, "value": "<br>", "anchor": "-20" });
    var created4442 = new Ext.form.DisplayField({ "disabled": true, "autoHeight": true, "fieldLabel": "Created", "name": "created", "listeners": { "render": Lino.quicktip_renderer("Erstellt","(uploads.Uploads.created) ") }, "value": "<br>", "anchor": "-20" });
    var owner_disp4443 = new Ext.form.DisplayField({ "disabled": true, "autoHeight": true, "fieldLabel": "Controlled by", "anchor": "-20", "name": "owner" });
    var main_3_panel4444 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 126, "hideCheckBoxLabels": true, "items": [ { "flex": 38, "autoHeight": true, "layout": "form", "xtype": "panel", "items": modified4441, "labelAlign": "top" }, { "flex": 38, "autoHeight": true, "layout": "form", "xtype": "panel", "items": created4442, "labelAlign": "top" }, { "flex": 23, "autoHeight": true, "layout": "form", "xtype": "panel", "items": owner_disp4443, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var cal_TasksByController_grid4448 = new Lino.cal.TasksByController.GridPanel({ "flex": 62, "hide_top_toolbar": true, "containing_panel": this, "params_panel_hidden": true, "master_panel": this, "preview_limit": 15, "listeners": { "render": Lino.quicktip_renderer("Aufgaben","(cal.cal.TasksByController) ") }, "tools": [ Lino.show_in_own_window_button(Lino.cal.TasksByController.grid) ] });
    var main_panel4449 = new Ext.Panel({ "autoScroll": false, "border": false, "layout": "vbox", "hideCheckBoxLabels": true, "items": [ main_1_panel4431, main_2_panel4437, main_3_panel4444, cal_TasksByController_grid4448 ], "frame": true, "layoutConfig": { "align": "stretch" }, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel4449;
    this.before_row_edit = function(record) {
      cal_TasksByController_grid4448.on_master_changed();
    }
    Lino.uploads.Uploads.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.contacts.Companies.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 24,
  initComponent : function() {
    var containing_panel = this;
    var prefix410 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "prefix", "name": "prefix", "maxLength": 200, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("prefix","(contacts.Companies.prefix) ") }, "anchor": "-20" });
    var name411 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Name", "name": "name", "listeners": { "render": Lino.quicktip_renderer("Name","(contacts.Companies.name) ") }, "maxLength": 200, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var id412 = new Ext.form.NumberField({ "autoHeight": true, "fieldLabel": "ID", "name": "id", "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("ID","(contacts.Companies.id) ") }, "anchor": "-20" });
    var language413 = new Lino.ChoicesFieldElement({ "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Language</span>", "allowBlank": false, "hiddenName": "languageHidden", "listeners": { "render": Lino.quicktip_renderer("Sprache","(contacts.Companies.language) Die Sprache, in der Dokumente ausgestellt werden sollen.") }, "selectOnFocus": true, "anchor": "-20", "store": [ [ "en", "English" ], [ "fr", "French" ], [ "de", "German" ], [ "nl", "Dutch" ] ], "name": "language" });
    var intro_box_1_panel414 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 31, "autoHeight": true, "layout": "form", "xtype": "panel", "items": prefix410, "labelAlign": "top" }, { "flex": 31, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name411, "labelAlign": "top" }, { "flex": 7, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id412, "labelAlign": "top" }, { "flex": 29, "autoHeight": true, "layout": "form", "xtype": "panel", "items": language413, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 72, "border": false, "anchor": "-20", "labelAlign": "top" });
    var vat_id419 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "VAT id", "name": "vat_id", "maxLength": 200, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("MWSt.-Nr.","(contacts.Companies.vat_id) ") }, "anchor": "-20" });
    var activity420 = new Lino.RemoteComboFieldElement({ "autoHeight": true, "fieldLabel": "activity", "name": "activity", "pageSize": 20, "emptyText": "Select a activity...", "listeners": { "render": Lino.quicktip_renderer("Beruf","(contacts.Companies.activity) ") }, "selectOnFocus": true, "hiddenName": "activityHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/contacts/Companies/activity", "method": "GET" }) }) });
    var type421 = new Lino.RemoteComboFieldElement({ "autoHeight": true, "fieldLabel": "Company type", "name": "type", "pageSize": 20, "emptyText": "Select a company type...", "listeners": { "render": Lino.quicktip_renderer("Organisationsart","(contacts.Companies.type) ") }, "selectOnFocus": true, "hiddenName": "typeHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/contacts/Companies/type", "method": "GET" }) }) });
    var intro_box_2_panel422 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 23, "autoHeight": true, "layout": "form", "xtype": "panel", "items": vat_id419, "labelAlign": "top" }, { "flex": 38, "autoHeight": true, "layout": "form", "xtype": "panel", "items": activity420, "labelAlign": "top" }, { "flex": 38, "autoHeight": true, "layout": "form", "xtype": "panel", "items": type421, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 153, "border": false, "anchor": "-20", "labelAlign": "top" });
    var bank_account1426 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Bank account 1", "name": "bank_account1", "maxLength": 40, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Bankkonto 1","(contacts.Companies.bank_account1) ") }, "anchor": "-20" });
    var bank_account2427 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Bank account 2", "name": "bank_account2", "maxLength": 40, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Bankkonto 2","(contacts.Companies.bank_account2) ") }, "anchor": "-20" });
    var is_obsolete428 = new Ext.form.Checkbox({ "autoHeight": true, "hideLabel": true, "checked": false, "name": "is_obsolete", "listeners": { "render": Lino.quicktip_renderer("veraltet","(contacts.Companies.is_obsolete) Altf\u00e4lle sind Partner, deren Stammdaten nicht mehr gepflegt werden und \nf\u00fcr neue Operationen nicht benutzt werden k\u00f6nnen.") }, "boxLabel": "obsolete", "selectOnFocus": true, "anchor": "-20" });
    var intro_box_3_panel429 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 40, "autoHeight": true, "layout": "form", "xtype": "panel", "items": bank_account1426, "labelAlign": "top" }, { "flex": 40, "autoHeight": true, "layout": "form", "xtype": "panel", "items": bank_account2427, "labelAlign": "top" }, { "flex": 19, "autoHeight": true, "layout": "form", "xtype": "panel", "items": is_obsolete428, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 108, "border": false, "anchor": "-20", "labelAlign": "top" });
    var intro_box_panel433 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "form", "hideCheckBoxLabels": true, "items": [ intro_box_1_panel414, intro_box_2_panel422, intro_box_3_panel429 ], "frame": true, "bodyBorder": false, "labelAlign": "top" });
    var country434 = new Lino.TwinCombo({ "autoHeight": true, "fieldLabel": "Country", "name": "country", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.countries.Countries.detail)}, "emptyText": "Select a Country...", "listeners": { "render": Lino.quicktip_renderer("Land","(contacts.Companies.country) ") }, "selectOnFocus": true, "hiddenName": "countryHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/contacts/Companies/country", "method": "GET" }) }) });
    var region435 = new Lino.TwinCombo({ "autoHeight": true, "fieldLabel": "Region", "name": "region", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.countries.Cities.detail)}, "emptyText": "Select a Place...", "listeners": { "render": Lino.quicktip_renderer("Region","(contacts.Companies.region) ") }, "selectOnFocus": true, "hiddenName": "regionHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/contacts/Companies/region", "method": "GET" }) }) });
    var box3_1_panel436 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": country434, "labelAlign": "top" }, { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": region435, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 63, "border": false, "anchor": "-20", "labelAlign": "top" });
    var city439 = new Lino.TwinCombo({ "autoHeight": true, "forceSelection": false, "fieldLabel": "Place", "name": "city", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.countries.Cities.detail)}, "emptyText": "Select a Place...", "listeners": { "render": Lino.quicktip_renderer("Ort","(contacts.Companies.city) ") }, "selectOnFocus": true, "hiddenName": "cityHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/contacts/Companies/city", "method": "GET" }) }) });
    var zip_code440 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Zip code", "name": "zip_code", "boxMinWidth": Lino.chars2width(10), "listeners": { "render": Lino.quicktip_renderer("Postleitzahl","(contacts.Companies.zip_code) ") }, "maxLength": 10, "selectOnFocus": true, "anchor": "-20" });
    var box3_2_panel441 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 66, "autoHeight": true, "layout": "form", "xtype": "panel", "items": city439, "labelAlign": "top" }, { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": zip_code440, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 117, "border": false, "anchor": "-20", "labelAlign": "top" });
    var street_prefix444 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Street prefix</span>", "name": "street_prefix", "maxLength": 200, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Pr\u00e4fix Stra\u00dfe","(contacts.Companies.street_prefix) Text to print before name of street, but to ignore for sorting.") }, "anchor": "-20" });
    var street445 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Street</span>", "name": "street", "maxLength": 200, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Stra\u00dfe","(contacts.Companies.street) Name of street. Without house number.") }, "anchor": "-20" });
    var street_no446 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">No.</span>", "name": "street_no", "boxMinWidth": Lino.chars2width(10), "listeners": { "render": Lino.quicktip_renderer("Nr.","(contacts.Companies.street_no) House number") }, "maxLength": 10, "selectOnFocus": true, "anchor": "-20" });
    var street_box447 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Box</span>", "name": "street_box", "boxMinWidth": Lino.chars2width(10), "listeners": { "render": Lino.quicktip_renderer("Box","(contacts.Companies.street_box) Text to print after :attr:`steet_no` on the same line") }, "maxLength": 10, "selectOnFocus": true, "anchor": "-20" });
    var box3_3_panel448 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 30, "autoHeight": true, "layout": "form", "xtype": "panel", "items": street_prefix444, "labelAlign": "top" }, { "flex": 36, "autoHeight": true, "layout": "form", "xtype": "panel", "items": street445, "labelAlign": "top" }, { "flex": 16, "autoHeight": true, "layout": "form", "xtype": "panel", "items": street_no446, "labelAlign": "top" }, { "flex": 16, "autoHeight": true, "layout": "form", "xtype": "panel", "items": street_box447, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 126, "border": false, "anchor": "-20", "labelAlign": "top" });
    var addr2453 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Address line after street</span>", "name": "addr2", "maxLength": 200, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Adresszeile nach Stra\u00dfe","(contacts.Companies.addr2) Address line to print below street line") }, "anchor": "-20" });
    var box3_panel454 = new Ext.Panel({ "flex": 62, "autoHeight": true, "layout": "form", "items": [ box3_1_panel436, box3_2_panel441, box3_3_panel448, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": addr2453, "anchor": "-20", "labelAlign": "top" } ], "frame": true, "bodyBorder": false, "autoScroll": false, "hideCheckBoxLabels": true, "labelWidth": 216, "border": false, "labelAlign": "top" });
    var email456 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "E-Mail", "name": "email", "maxLength": 75, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("E-Mail","(contacts.Companies.email) ") }, "anchor": "-20" });
    var url457 = new Lino.URLField({ "autoHeight": true, "fieldLabel": "URL", "name": "url", "maxLength": 200, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("URL","(contacts.Companies.url) ") }, "anchor": "-20" });
    var phone458 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Phone", "name": "phone", "maxLength": 200, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Telefon","(contacts.Companies.phone) ") }, "anchor": "-20" });
    var gsm459 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "GSM", "name": "gsm", "maxLength": 200, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("GSM","(contacts.Companies.gsm) ") }, "anchor": "-20" });
    var box4_panel460 = new Ext.Panel({ "flex": 37, "autoHeight": true, "layout": "form", "items": [ { "autoHeight": true, "layout": "form", "xtype": "panel", "items": email456, "anchor": "-20", "labelAlign": "top" }, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": url457, "anchor": "-20", "labelAlign": "top" }, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": phone458, "anchor": "-20", "labelAlign": "top" }, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": gsm459, "anchor": "-20", "labelAlign": "top" } ], "frame": true, "bodyBorder": false, "autoScroll": false, "hideCheckBoxLabels": true, "labelWidth": 72, "border": false, "labelAlign": "top" });
    var address_box_panel465 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "hideCheckBoxLabels": true, "items": [ box3_panel454, box4_panel460 ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var remarks466 = new Ext.form.TextArea({ "listeners": { "render": Lino.quicktip_renderer("Bemerkungen","(contacts.Companies.remarks) ") }, "fieldLabel": "Remarks", "name": "remarks", "growMax": 2000, "selectOnFocus": true, "anchor": "-20 -10" });
    var is_courseprovider467 = new Ext.form.Checkbox({ "boxLabel": "is Course Provider (<a href=\"javascript:Lino.show_mti_child('is_courseprovider',Lino.courses.CourseProviders.detail)\">show</a>)", "autoHeight": true, "hideLabel": true, "name": "is_courseprovider", "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("ist Kursanbieter","(contacts.Companies.is_courseprovider) ") }, "anchor": "-20" });
    var is_jobprovider468 = new Ext.form.Checkbox({ "boxLabel": "is Job Provider (<a href=\"javascript:Lino.show_mti_child('is_jobprovider',Lino.jobs.JobProviders.detail)\">show</a>)", "autoHeight": true, "hideLabel": true, "name": "is_jobprovider", "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Stellenanbieter","(contacts.Companies.is_jobprovider) ") }, "anchor": "-20" });
    var client_contact_type469 = new Lino.RemoteComboFieldElement({ "autoHeight": true, "fieldLabel": "Client Contact type", "name": "client_contact_type", "pageSize": 20, "emptyText": "Select a Client Contact type...", "listeners": { "render": Lino.quicktip_renderer("Klientenkontaktart","(contacts.Companies.client_contact_type) ") }, "selectOnFocus": true, "hiddenName": "client_contact_typeHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/contacts/Companies/client_contact_type", "method": "GET" }) }) });
    var box5_2_panel470 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 171, "hideCheckBoxLabels": true, "items": [ { "flex": 25, "autoHeight": true, "layout": "form", "xtype": "panel", "items": is_courseprovider467, "labelAlign": "top" }, { "flex": 25, "autoHeight": true, "layout": "form", "xtype": "panel", "items": is_jobprovider468, "labelAlign": "top" }, { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": client_contact_type469, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var box5_panel474 = new Ext.Panel({ "flex": 57, "layout": "vbox", "items": [ { "items": remarks466, "labelAlign": "top", "layout": "form", "xtype": "panel", "flex": 83 }, box5_2_panel470 ], "frame": true, "layoutConfig": { "align": "stretch" }, "autoScroll": false, "hideCheckBoxLabels": true, "labelWidth": 108, "border": false, "bodyBorder": false, "labelAlign": "top" });
    var contacts_RolesByCompany_grid480 = new Lino.contacts.RolesByCompany.GridPanel({ "flex": 42, "listeners": { "render": Lino.quicktip_renderer("Kontaktpersonen","(contacts.contacts.RolesByCompany) ") }, "hide_top_toolbar": true, "containing_panel": this, "tools": [ Lino.show_in_own_window_button(Lino.contacts.RolesByCompany.grid) ], "preview_limit": 15, "master_panel": this });
    var bottom_box_panel481 = new Ext.Panel({ "flex": 46, "border": false, "layout": "hbox", "hideCheckBoxLabels": true, "items": [ box5_panel474, contacts_RolesByCompany_grid480 ], "autoScroll": false, "layoutConfig": { "align": "stretch" }, "frame": false, "labelAlign": "top" });
    var general_panel482 = new Ext.Panel({ "layout": "vbox", "title": "General", "items": [ intro_box_panel433, address_box_panel465, bottom_box_panel481 ], "frame": true, "layoutConfig": { "align": "stretch" }, "hideCheckBoxLabels": true, "listeners": { "activate": Lino.on_tab_activate }, "autoScroll": false, "border": false, "bodyBorder": false, "labelAlign": "top" });
    var pcsw_NotesByCompany_grid499 = new Lino.pcsw.NotesByCompany.GridPanel({ "listeners": { "activate": Lino.on_tab_activate }, "hide_top_toolbar": true, "containing_panel": this, "title": "Events/Notes", "tools": [ Lino.show_in_own_window_button(Lino.pcsw.NotesByCompany.grid) ], "preview_limit": 15, "master_panel": this });
    var main_panel500 = new Ext.TabPanel({ "hideCheckBoxLabels": true, "border": false, "split": true, "autoScroll": false, "items": [ general_panel482, pcsw_NotesByCompany_grid499 ], "activeTab": 0, "bodyBorder": false, "frame": true, "labelAlign": "top" });
    this.items = main_panel500;
    this.before_row_edit = function(record) {
      region435.setContextValue('country',record ? record.data['countryHidden'] : undefined);
      city439.setContextValue('country',record ? record.data['countryHidden'] : undefined);
      city439.setContextValue('region',record ? record.data['regionHidden'] : undefined);
      contacts_RolesByCompany_grid480.on_master_changed();
      pcsw_NotesByCompany_grid499.on_master_changed();
    }
    this.onRender = function(ct, position) {
      country434.on('change',Lino.chooser_handler(region435,'country'));
      country434.on('change',Lino.chooser_handler(city439,'country'));
      region435.on('change',Lino.chooser_handler(city439,'region'));
      Lino.contacts.Companies.DetailFormPanel.superclass.onRender.call(this, ct, position);
    }
    Lino.contacts.Companies.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.contacts.Partners.InsertFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  autoHeight: true,
  content_type: 27,
  initComponent : function() {
    var containing_panel = this;
    var name720 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Name", "name": "name", "listeners": { "render": Lino.quicktip_renderer("Name","(contacts.Partners.name) ") }, "maxLength": 200, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var language721 = new Lino.ChoicesFieldElement({ "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Language</span>", "allowBlank": false, "hiddenName": "languageHidden", "listeners": { "render": Lino.quicktip_renderer("Sprache","(contacts.Partners.language) Die Sprache, in der Dokumente ausgestellt werden sollen.") }, "selectOnFocus": true, "anchor": "-20", "store": [ [ "en", "English" ], [ "fr", "French" ], [ "de", "German" ], [ "nl", "Dutch" ] ], "name": "language" });
    var email722 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "E-Mail", "name": "email", "maxLength": 75, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("E-Mail","(contacts.Partners.email) ") }, "anchor": "-20" });
    var main_2_panel723 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 48, "autoHeight": true, "layout": "form", "xtype": "panel", "items": language721, "labelAlign": "top" }, { "flex": 51, "autoHeight": true, "layout": "form", "xtype": "panel", "items": email722, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 72, "border": false, "anchor": "-20", "labelAlign": "top" });
    var main_panel726 = new Ext.Panel({ "hideCheckBoxLabels": true, "autoHeight": true, "border": false, "layout": "form", "labelWidth": 45, "autoScroll": false, "items": [ { "autoHeight": true, "layout": "form", "xtype": "panel", "items": name720, "anchor": "-20", "labelAlign": "top" }, main_2_panel723 ], "frame": true, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel726;
    this.before_row_edit = function(record) {
    }
    Lino.contacts.Partners.InsertFormPanel.superclass.initComponent.call(this);
  }
});


Lino.contacts.Persons.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 25,
  initComponent : function() {
    var containing_panel = this;
    var last_name1709 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Last name", "name": "last_name", "listeners": { "render": Lino.quicktip_renderer("Familienname","(contacts.Persons.last_name) ") }, "maxLength": 200, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var first_name1710 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "First name", "name": "first_name", "listeners": { "render": Lino.quicktip_renderer("Vorname","(contacts.Persons.first_name) ") }, "maxLength": 200, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var gender1711 = new Lino.ChoicesFieldElement({ "autoHeight": true, "forceSelection": true, "fieldLabel": "Gender", "name": "gender", "hiddenName": "genderHidden", "listeners": { "render": Lino.quicktip_renderer("Geschlecht","(contacts.Persons.gender) ") }, "selectOnFocus": true, "anchor": "-20", "store": [['','<br>']].concat(Lino.lino.Genders) });
    var title1712 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Title</span>", "name": "title", "maxLength": 200, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Anrede","(contacts.Persons.title) Text to print before first_name as part of the first address line.") }, "anchor": "-20" });
    var name_box_panel1713 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 38, "autoHeight": true, "layout": "form", "xtype": "panel", "items": last_name1709, "labelAlign": "top" }, { "flex": 27, "autoHeight": true, "layout": "form", "xtype": "panel", "items": first_name1710, "labelAlign": "top" }, { "flex": 16, "autoHeight": true, "layout": "form", "xtype": "panel", "items": gender1711, "labelAlign": "top" }, { "flex": 18, "autoHeight": true, "layout": "form", "xtype": "panel", "items": title1712, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 117, "border": false, "anchor": "-20", "labelAlign": "top" });
    var country1718 = new Lino.TwinCombo({ "autoHeight": true, "fieldLabel": "Country", "name": "country", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.countries.Countries.detail)}, "emptyText": "Select a Country...", "listeners": { "render": Lino.quicktip_renderer("Land","(contacts.Persons.country) ") }, "selectOnFocus": true, "hiddenName": "countryHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/contacts/Persons/country", "method": "GET" }) }) });
    var region1719 = new Lino.TwinCombo({ "autoHeight": true, "fieldLabel": "Region", "name": "region", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.countries.Cities.detail)}, "emptyText": "Select a Place...", "listeners": { "render": Lino.quicktip_renderer("Region","(contacts.Persons.region) ") }, "selectOnFocus": true, "hiddenName": "regionHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/contacts/Persons/region", "method": "GET" }) }) });
    var city1720 = new Lino.TwinCombo({ "autoHeight": true, "forceSelection": false, "fieldLabel": "Place", "name": "city", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.countries.Cities.detail)}, "emptyText": "Select a Place...", "listeners": { "render": Lino.quicktip_renderer("Ort","(contacts.Persons.city) ") }, "selectOnFocus": true, "hiddenName": "cityHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/contacts/Persons/city", "method": "GET" }) }) });
    var zip_code1721 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Zip code", "name": "zip_code", "boxMinWidth": Lino.chars2width(10), "listeners": { "render": Lino.quicktip_renderer("Postleitzahl","(contacts.Persons.zip_code) ") }, "maxLength": 10, "selectOnFocus": true, "anchor": "-20" });
    var address_box_2_panel1722 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 28, "autoHeight": true, "layout": "form", "xtype": "panel", "items": country1718, "labelAlign": "top" }, { "flex": 28, "autoHeight": true, "layout": "form", "xtype": "panel", "items": region1719, "labelAlign": "top" }, { "flex": 28, "autoHeight": true, "layout": "form", "xtype": "panel", "items": city1720, "labelAlign": "top" }, { "flex": 14, "autoHeight": true, "layout": "form", "xtype": "panel", "items": zip_code1721, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 117, "border": false, "anchor": "-20", "labelAlign": "top" });
    var addr11727 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Address line before street</span>", "name": "addr1", "maxLength": 200, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Adresszeile vor Stra\u00dfe","(contacts.Persons.addr1) Address line before street") }, "anchor": "-20" });
    var street_prefix1728 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Street prefix</span>", "name": "street_prefix", "maxLength": 200, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Pr\u00e4fix Stra\u00dfe","(contacts.Persons.street_prefix) Text to print before name of street, but to ignore for sorting.") }, "anchor": "-20" });
    var street1729 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Street</span>", "name": "street", "maxLength": 200, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Stra\u00dfe","(contacts.Persons.street) Name of street. Without house number.") }, "anchor": "-20" });
    var street_no1730 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">No.</span>", "name": "street_no", "boxMinWidth": Lino.chars2width(10), "listeners": { "render": Lino.quicktip_renderer("Nr.","(contacts.Persons.street_no) House number") }, "maxLength": 10, "selectOnFocus": true, "anchor": "-20" });
    var street_box1731 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Box</span>", "name": "street_box", "boxMinWidth": Lino.chars2width(10), "listeners": { "render": Lino.quicktip_renderer("Box","(contacts.Persons.street_box) Text to print after :attr:`steet_no` on the same line") }, "maxLength": 10, "selectOnFocus": true, "anchor": "-20" });
    var address_box_4_panel1732 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 30, "autoHeight": true, "layout": "form", "xtype": "panel", "items": street_prefix1728, "labelAlign": "top" }, { "flex": 36, "autoHeight": true, "layout": "form", "xtype": "panel", "items": street1729, "labelAlign": "top" }, { "flex": 16, "autoHeight": true, "layout": "form", "xtype": "panel", "items": street_no1730, "labelAlign": "top" }, { "flex": 16, "autoHeight": true, "layout": "form", "xtype": "panel", "items": street_box1731, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 126, "border": false, "anchor": "-20", "labelAlign": "top" });
    var addr21737 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Address line after street</span>", "name": "addr2", "maxLength": 200, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Adresszeile nach Stra\u00dfe","(contacts.Persons.addr2) Address line to print below street line") }, "anchor": "-20" });
    var address_box_panel1738 = new Ext.form.FieldSet({ "flex": 66, "autoHeight": true, "layout": "form", "title": "Address", "items": [ name_box_panel1713, address_box_2_panel1722, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": addr11727, "anchor": "-20", "labelAlign": "top" }, address_box_4_panel1732, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": addr21737, "anchor": "-20", "labelAlign": "top" } ], "frame": true, "bodyBorder": false, "autoScroll": false, "hideCheckBoxLabels": true, "labelWidth": 216, "border": false, "labelAlign": "top" });
    var id1741 = new Ext.form.NumberField({ "autoHeight": true, "fieldLabel": "ID", "name": "id", "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("ID","(contacts.Persons.id) ") }, "anchor": "-20" });
    var language1742 = new Lino.ChoicesFieldElement({ "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Language</span>", "allowBlank": false, "hiddenName": "languageHidden", "listeners": { "render": Lino.quicktip_renderer("Sprache","(contacts.Persons.language) Die Sprache, in der Dokumente ausgestellt werden sollen.") }, "selectOnFocus": true, "anchor": "-20", "store": [ [ "en", "English" ], [ "fr", "French" ], [ "de", "German" ], [ "nl", "Dutch" ] ], "name": "language" });
    var info_box_panel1743 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id1741, "labelAlign": "top" }, { "flex": 66, "autoHeight": true, "layout": "form", "xtype": "panel", "items": language1742, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 72, "border": false, "anchor": "-20", "labelAlign": "top" });
    var email1746 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "E-Mail", "name": "email", "maxLength": 75, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("E-Mail","(contacts.Persons.email) ") }, "anchor": "-20" });
    var url1747 = new Lino.URLField({ "autoHeight": true, "fieldLabel": "URL", "name": "url", "maxLength": 200, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("URL","(contacts.Persons.url) ") }, "anchor": "-20" });
    var phone1748 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Phone", "name": "phone", "maxLength": 200, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Telefon","(contacts.Persons.phone) ") }, "anchor": "-20" });
    var gsm1749 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "GSM", "name": "gsm", "maxLength": 200, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("GSM","(contacts.Persons.gsm) ") }, "anchor": "-20" });
    var fax1750 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Fax", "name": "fax", "maxLength": 200, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Fax","(contacts.Persons.fax) ") }, "anchor": "-20" });
    var contact_box_5_panel1751 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": gsm1749, "labelAlign": "top" }, { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": fax1750, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 36, "border": false, "anchor": "-20", "labelAlign": "top" });
    var contact_box_panel1754 = new Ext.form.FieldSet({ "flex": 33, "autoHeight": true, "layout": "form", "title": "Contact", "items": [ info_box_panel1743, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": email1746, "anchor": "-20", "labelAlign": "top" }, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": url1747, "anchor": "-20", "labelAlign": "top" }, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": phone1748, "anchor": "-20", "labelAlign": "top" }, contact_box_5_panel1751 ], "frame": true, "bodyBorder": false, "autoScroll": false, "hideCheckBoxLabels": true, "labelWidth": 72, "border": false, "labelAlign": "top" });
    var general_1_panel1758 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "hideCheckBoxLabels": true, "items": [ address_box_panel1738, contact_box_panel1754 ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var activity1759 = new Lino.RemoteComboFieldElement({ "autoHeight": true, "fieldLabel": "activity", "name": "activity", "pageSize": 20, "emptyText": "Select a activity...", "listeners": { "render": Lino.quicktip_renderer("Beruf","(contacts.Persons.activity) ") }, "selectOnFocus": true, "hiddenName": "activityHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/contacts/Persons/activity", "method": "GET" }) }) });
    var bank_account11760 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Bank account 1", "name": "bank_account1", "maxLength": 40, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Bankkonto 1","(contacts.Persons.bank_account1) ") }, "anchor": "-20" });
    var bank_account21761 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Bank account 2", "name": "bank_account2", "maxLength": 40, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Bankkonto 2","(contacts.Persons.bank_account2) ") }, "anchor": "-20" });
    var is_obsolete1762 = new Ext.form.Checkbox({ "autoHeight": true, "hideLabel": true, "checked": false, "name": "is_obsolete", "listeners": { "render": Lino.quicktip_renderer("veraltet","(contacts.Persons.is_obsolete) Altf\u00e4lle sind Partner, deren Stammdaten nicht mehr gepflegt werden und \nf\u00fcr neue Operationen nicht benutzt werden k\u00f6nnen.") }, "boxLabel": "obsolete", "selectOnFocus": true, "anchor": "-20" });
    var bottom_box_1_panel1763 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 108, "hideCheckBoxLabels": true, "items": [ { "flex": 27, "autoHeight": true, "layout": "form", "xtype": "panel", "items": activity1759, "labelAlign": "top" }, { "flex": 29, "autoHeight": true, "layout": "form", "xtype": "panel", "items": bank_account11760, "labelAlign": "top" }, { "flex": 29, "autoHeight": true, "layout": "form", "xtype": "panel", "items": bank_account21761, "labelAlign": "top" }, { "flex": 13, "autoHeight": true, "layout": "form", "xtype": "panel", "items": is_obsolete1762, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var is_client1768 = new Ext.form.Checkbox({ "boxLabel": "is Client (<a href=\"javascript:Lino.show_mti_child('is_client',Lino.pcsw.Clients.detail)\">show</a>)", "autoHeight": true, "hideLabel": true, "name": "is_client", "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("ist Klient","(contacts.Persons.is_client) Ob diese Person ein Klient ist") }, "anchor": "-20" });
    var created1769 = new Ext.form.DisplayField({ "disabled": true, "autoHeight": true, "fieldLabel": "Created", "name": "created", "listeners": { "render": Lino.quicktip_renderer("Erstellt","(contacts.Persons.created) ") }, "value": "<br>", "anchor": "-20" });
    var modified1770 = new Ext.form.DisplayField({ "disabled": true, "autoHeight": true, "fieldLabel": "Modified", "name": "modified", "listeners": { "render": Lino.quicktip_renderer("Bearbeitet","(contacts.Persons.modified) ") }, "value": "<br>", "anchor": "-20" });
    var bottom_box_2_panel1771 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 99, "hideCheckBoxLabels": true, "items": [ { "flex": 23, "autoHeight": true, "layout": "form", "xtype": "panel", "items": is_client1768, "labelAlign": "top" }, { "flex": 38, "autoHeight": true, "layout": "form", "xtype": "panel", "items": created1769, "labelAlign": "top" }, { "flex": 38, "autoHeight": true, "layout": "form", "xtype": "panel", "items": modified1770, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var remarks1775 = new Ext.form.TextArea({ "listeners": { "render": Lino.quicktip_renderer("Bemerkungen","(contacts.Persons.remarks) ") }, "fieldLabel": "Remarks", "name": "remarks", "growMax": 2000, "selectOnFocus": true, "anchor": "-20 -10" });
    var contacts_RolesByPerson_grid1780 = new Lino.contacts.RolesByPerson.GridPanel({ "flex": 27, "listeners": { "render": Lino.quicktip_renderer("Kontaktperson f\u00fcr","(contacts.contacts.RolesByPerson) ") }, "hide_top_toolbar": true, "containing_panel": this, "tools": [ Lino.show_in_own_window_button(Lino.contacts.RolesByPerson.grid) ], "preview_limit": 15, "master_panel": this });
    var households_MembersByPerson_grid1787 = new Lino.households.MembersByPerson.GridPanel({ "flex": 36, "listeners": { "render": Lino.quicktip_renderer("Mitglied von","(households.households.MembersByPerson) ") }, "hide_top_toolbar": true, "containing_panel": this, "tools": [ Lino.show_in_own_window_button(Lino.households.MembersByPerson.grid) ], "preview_limit": 15, "master_panel": this });
    var bottom_box_3_panel1788 = new Ext.Panel({ "flex": 71, "border": false, "layout": "hbox", "labelWidth": 108, "hideCheckBoxLabels": true, "items": [ { "items": remarks1775, "labelAlign": "top", "layout": "form", "xtype": "panel", "flex": 36 }, contacts_RolesByPerson_grid1780, households_MembersByPerson_grid1787 ], "autoScroll": false, "layoutConfig": { "align": "stretch" }, "frame": false, "labelAlign": "top" });
    var bottom_box_panel1790 = new Ext.Panel({ "flex": 58, "border": false, "layout": "vbox", "bodyBorder": false, "hideCheckBoxLabels": true, "items": [ bottom_box_1_panel1763, bottom_box_2_panel1771, bottom_box_3_panel1788 ], "autoScroll": false, "layoutConfig": { "align": "stretch" }, "frame": true, "labelAlign": "top" });
    var general_panel1791 = new Ext.Panel({ "layout": "vbox", "title": "General", "items": [ general_1_panel1758, bottom_box_panel1790 ], "frame": true, "layoutConfig": { "align": "stretch" }, "hideCheckBoxLabels": true, "listeners": { "activate": Lino.on_tab_activate }, "autoScroll": false, "border": false, "bodyBorder": false, "labelAlign": "top" });
    var debts_BudgetsByPartner_grid1792 = new Lino.debts.BudgetsByPartner.GridPanel({ "flex": 5, "hide_top_toolbar": true, "containing_panel": this, "region": "north", "preview_limit": 15, "master_panel": this, "listeners": { "render": Lino.quicktip_renderer("Ist Hauptpartner in folgenden Budgets:","(debts.debts.BudgetsByPartner) ") }, "split": true, "tools": [ Lino.show_in_own_window_button(Lino.debts.BudgetsByPartner.grid) ] });
    var debts_ActorsByPartner_grid1793 = new Lino.debts.ActorsByPartner.GridPanel({ "flex": 5, "hide_top_toolbar": true, "containing_panel": this, "region": "center", "preview_limit": 15, "master_panel": this, "listeners": { "render": Lino.quicktip_renderer("Ist Akteur in folgenden Budgets:","(debts.debts.ActorsByPartner) ") }, "split": true, "tools": [ Lino.show_in_own_window_button(Lino.debts.ActorsByPartner.grid) ] });
    var debts_panel1794 = new Lino.VBorderPanel({ "autoScroll": false, "listeners": { "activate": Lino.on_tab_activate }, "border": false, "title": "Debts mediation", "hideCheckBoxLabels": true, "items": [ debts_BudgetsByPartner_grid1792, debts_ActorsByPartner_grid1793 ], "frame": true, "bodyBorder": false, "labelAlign": "top" });
    var main_panel1795 = new Ext.TabPanel({ "hideCheckBoxLabels": true, "border": false, "split": true, "autoScroll": false, "items": [ general_panel1791, debts_panel1794 ], "activeTab": 0, "bodyBorder": false, "frame": true, "labelAlign": "top" });
    this.items = main_panel1795;
    this.before_row_edit = function(record) {
      region1719.setContextValue('country',record ? record.data['countryHidden'] : undefined);
      city1720.setContextValue('country',record ? record.data['countryHidden'] : undefined);
      city1720.setContextValue('region',record ? record.data['regionHidden'] : undefined);
      contacts_RolesByPerson_grid1780.on_master_changed();
      households_MembersByPerson_grid1787.on_master_changed();
      debts_BudgetsByPartner_grid1792.on_master_changed();
      debts_ActorsByPartner_grid1793.on_master_changed();
    }
    this.onRender = function(ct, position) {
      country1718.on('change',Lino.chooser_handler(region1719,'country'));
      country1718.on('change',Lino.chooser_handler(city1720,'country'));
      region1719.on('change',Lino.chooser_handler(city1720,'region'));
      Lino.contacts.Persons.DetailFormPanel.superclass.onRender.call(this, ct, position);
    }
    Lino.contacts.Persons.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.languages.Languages.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 46,
  initComponent : function() {
    var containing_panel = this;
    var id3207 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "id", "name": "id", "boxMinWidth": Lino.chars2width(3), "listeners": { "render": Lino.quicktip_renderer("id","(languages.Languages.id) ") }, "maxLength": 3, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var iso23208 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "iso2", "name": "iso2", "boxMinWidth": Lino.chars2width(2), "listeners": { "render": Lino.quicktip_renderer("iso2","(languages.Languages.iso2) ") }, "maxLength": 2, "selectOnFocus": true, "anchor": "-20" });
    var name3209 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Designation", "name": "name", "listeners": { "render": Lino.quicktip_renderer("Bezeichnung","(languages.Languages.name) ") }, "maxLength": 200, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var name_fr3210 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Designation (fr)", "name": "name_fr", "maxLength": 200, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Bezeichnung (fr)","(languages.Languages.name_fr) ") }, "anchor": "-20" });
    var name_de3211 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Designation (de)", "name": "name_de", "maxLength": 200, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Bezeichnung (de)","(languages.Languages.name_de) ") }, "anchor": "-20" });
    var name_nl3212 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Designation (nl)", "name": "name_nl", "listeners": { "render": Lino.quicktip_renderer("Bezeichnung (nl)","(languages.Languages.name_nl) ") }, "maxLength": 200, "selectOnFocus": true, "hidden": true, "anchor": "-20" });
    var main_1_panel3213 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 153, "hideCheckBoxLabels": true, "items": [ { "flex": 4, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id3207, "labelAlign": "top" }, { "flex": 4, "autoHeight": true, "layout": "form", "xtype": "panel", "items": iso23208, "labelAlign": "top" }, { "flex": 22, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name3209, "labelAlign": "top" }, { "flex": 22, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_fr3210, "labelAlign": "top" }, { "flex": 22, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_de3211, "labelAlign": "top" }, { "flex": 22, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_nl3212, "hidden": true, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var cv_KnowledgesByLanguage_grid3226 = new Lino.cv.KnowledgesByLanguage.GridPanel({ "flex": 83, "listeners": { "render": Lino.quicktip_renderer("Sprachkenntnisse","(cv.cv.KnowledgesByLanguage) ") }, "hide_top_toolbar": true, "containing_panel": this, "tools": [ Lino.show_in_own_window_button(Lino.cv.KnowledgesByLanguage.grid) ], "preview_limit": 15, "master_panel": this });
    var main_panel3227 = new Ext.Panel({ "autoScroll": false, "border": false, "layout": "vbox", "hideCheckBoxLabels": true, "items": [ main_1_panel3213, cv_KnowledgesByLanguage_grid3226 ], "frame": true, "layoutConfig": { "align": "stretch" }, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel3227;
    this.before_row_edit = function(record) {
      cv_KnowledgesByLanguage_grid3226.on_master_changed();
    }
    Lino.languages.Languages.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.contacts.Persons.InsertFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  autoHeight: true,
  content_type: 25,
  initComponent : function() {
    var containing_panel = this;
    var title1796 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Title</span>", "name": "title", "maxLength": 200, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Anrede","(contacts.Persons.title) Text to print before first_name as part of the first address line.") }, "anchor": "-20" });
    var first_name1797 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "First name", "name": "first_name", "listeners": { "render": Lino.quicktip_renderer("Vorname","(contacts.Persons.first_name) ") }, "maxLength": 200, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var last_name1798 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Last name", "name": "last_name", "listeners": { "render": Lino.quicktip_renderer("Familienname","(contacts.Persons.last_name) ") }, "maxLength": 200, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var main_1_panel1799 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": title1796, "labelAlign": "top" }, { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": first_name1797, "labelAlign": "top" }, { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": last_name1798, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 117, "border": false, "anchor": "-20", "labelAlign": "top" });
    var gender1803 = new Lino.ChoicesFieldElement({ "autoHeight": true, "forceSelection": true, "fieldLabel": "Gender", "name": "gender", "hiddenName": "genderHidden", "listeners": { "render": Lino.quicktip_renderer("Geschlecht","(contacts.Persons.gender) ") }, "selectOnFocus": true, "anchor": "-20", "store": [['','<br>']].concat(Lino.lino.Genders) });
    var language1804 = new Lino.ChoicesFieldElement({ "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Language</span>", "allowBlank": false, "hiddenName": "languageHidden", "listeners": { "render": Lino.quicktip_renderer("Sprache","(contacts.Persons.language) Die Sprache, in der Dokumente ausgestellt werden sollen.") }, "selectOnFocus": true, "anchor": "-20", "store": [ [ "en", "English" ], [ "fr", "French" ], [ "de", "German" ], [ "nl", "Dutch" ] ], "name": "language" });
    var main_2_panel1805 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 31, "autoHeight": true, "layout": "form", "xtype": "panel", "items": gender1803, "labelAlign": "top" }, { "flex": 68, "autoHeight": true, "layout": "form", "xtype": "panel", "items": language1804, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 99, "border": false, "anchor": "-20", "labelAlign": "top" });
    var main_panel1808 = new Ext.Panel({ "hideCheckBoxLabels": true, "autoHeight": true, "border": false, "layout": "form", "autoScroll": false, "items": [ main_1_panel1799, main_2_panel1805 ], "frame": true, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel1808;
    this.before_row_edit = function(record) {
    }
    Lino.contacts.Persons.InsertFormPanel.superclass.initComponent.call(this);
  }
});


Lino.pcsw.Clients.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 57,
  initComponent : function() {
    var containing_panel = this;
    var last_name1822 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Last name", "name": "last_name", "listeners": { "render": Lino.quicktip_renderer("Familienname","(pcsw.Clients.last_name) ") }, "maxLength": 200, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var first_name1823 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "First name", "name": "first_name", "listeners": { "render": Lino.quicktip_renderer("Vorname","(pcsw.Clients.first_name) ") }, "maxLength": 200, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var title1824 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Title</span>", "name": "title", "maxLength": 200, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Anrede","(pcsw.Clients.title) Text to print before first_name as part of the first address line.") }, "anchor": "-20" });
    var box1_1_panel1825 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 45, "autoHeight": true, "layout": "form", "xtype": "panel", "items": last_name1822, "labelAlign": "top" }, { "flex": 32, "autoHeight": true, "layout": "form", "xtype": "panel", "items": first_name1823, "labelAlign": "top" }, { "flex": 21, "autoHeight": true, "layout": "form", "xtype": "panel", "items": title1824, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 117, "border": false, "anchor": "-20", "labelAlign": "top" });
    var country1829 = new Lino.TwinCombo({ "autoHeight": true, "fieldLabel": "Country", "name": "country", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.countries.Countries.detail)}, "emptyText": "Select a Country...", "listeners": { "render": Lino.quicktip_renderer("Land","(pcsw.Clients.country) ") }, "selectOnFocus": true, "hiddenName": "countryHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/pcsw/Clients/country", "method": "GET" }) }) });
    var city1830 = new Lino.TwinCombo({ "autoHeight": true, "forceSelection": false, "fieldLabel": "Place", "name": "city", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.countries.Cities.detail)}, "emptyText": "Select a Place...", "listeners": { "render": Lino.quicktip_renderer("Ort","(pcsw.Clients.city) ") }, "selectOnFocus": true, "hiddenName": "cityHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/pcsw/Clients/city", "method": "GET" }) }) });
    var zip_code1831 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Zip code", "name": "zip_code", "boxMinWidth": Lino.chars2width(10), "listeners": { "render": Lino.quicktip_renderer("Postleitzahl","(pcsw.Clients.zip_code) ") }, "maxLength": 10, "selectOnFocus": true, "anchor": "-20" });
    var box1_2_panel1832 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 40, "autoHeight": true, "layout": "form", "xtype": "panel", "items": country1829, "labelAlign": "top" }, { "flex": 40, "autoHeight": true, "layout": "form", "xtype": "panel", "items": city1830, "labelAlign": "top" }, { "flex": 20, "autoHeight": true, "layout": "form", "xtype": "panel", "items": zip_code1831, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 117, "border": false, "anchor": "-20", "labelAlign": "top" });
    var street_prefix1836 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Street prefix</span>", "name": "street_prefix", "maxLength": 200, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Pr\u00e4fix Stra\u00dfe","(pcsw.Clients.street_prefix) Text to print before name of street, but to ignore for sorting.") }, "anchor": "-20" });
    var street1837 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Street</span>", "name": "street", "maxLength": 200, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Stra\u00dfe","(pcsw.Clients.street) Name of street. Without house number.") }, "anchor": "-20" });
    var street_no1838 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">No.</span>", "name": "street_no", "boxMinWidth": Lino.chars2width(10), "listeners": { "render": Lino.quicktip_renderer("Nr.","(pcsw.Clients.street_no) House number") }, "maxLength": 10, "selectOnFocus": true, "anchor": "-20" });
    var street_box1839 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Box</span>", "name": "street_box", "boxMinWidth": Lino.chars2width(10), "listeners": { "render": Lino.quicktip_renderer("Box","(pcsw.Clients.street_box) Text to print after :attr:`steet_no` on the same line") }, "maxLength": 10, "selectOnFocus": true, "anchor": "-20" });
    var box1_3_panel1840 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 30, "autoHeight": true, "layout": "form", "xtype": "panel", "items": street_prefix1836, "labelAlign": "top" }, { "flex": 36, "autoHeight": true, "layout": "form", "xtype": "panel", "items": street1837, "labelAlign": "top" }, { "flex": 16, "autoHeight": true, "layout": "form", "xtype": "panel", "items": street_no1838, "labelAlign": "top" }, { "flex": 16, "autoHeight": true, "layout": "form", "xtype": "panel", "items": street_box1839, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 126, "border": false, "anchor": "-20", "labelAlign": "top" });
    var addr21845 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Address line after street</span>", "name": "addr2", "maxLength": 200, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Adresszeile nach Stra\u00dfe","(pcsw.Clients.addr2) Address line to print below street line") }, "anchor": "-20" });
    var box1_panel1846 = new Ext.form.FieldSet({ "flex": 61, "autoHeight": true, "layout": "form", "title": "Address", "items": [ box1_1_panel1825, box1_2_panel1832, box1_3_panel1840, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": addr21845, "anchor": "-20", "labelAlign": "top" } ], "frame": true, "bodyBorder": false, "autoScroll": false, "hideCheckBoxLabels": true, "labelWidth": 216, "border": false, "labelAlign": "top" });
    var id1848 = new Ext.form.NumberField({ "autoHeight": true, "fieldLabel": "ID", "name": "id", "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("ID","(pcsw.Clients.id) ") }, "anchor": "-20" });
    var language1849 = new Lino.ChoicesFieldElement({ "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Language</span>", "allowBlank": false, "hiddenName": "languageHidden", "listeners": { "render": Lino.quicktip_renderer("Sprache","(pcsw.Clients.language) Die Sprache, in der Dokumente ausgestellt werden sollen.") }, "selectOnFocus": true, "anchor": "-20", "store": [ [ "en", "English" ], [ "fr", "French" ], [ "de", "German" ], [ "nl", "Dutch" ] ], "name": "language" });
    var box2_1_panel1850 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 37, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id1848, "labelAlign": "top" }, { "flex": 62, "autoHeight": true, "layout": "form", "xtype": "panel", "items": language1849, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 72, "border": false, "anchor": "-20", "labelAlign": "top" });
    var email1853 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "E-Mail", "name": "email", "maxLength": 75, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("E-Mail","(pcsw.Clients.email) ") }, "anchor": "-20" });
    var phone1854 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Phone", "name": "phone", "maxLength": 200, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Telefon","(pcsw.Clients.phone) ") }, "anchor": "-20" });
    var fax1855 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Fax", "name": "fax", "maxLength": 200, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Fax","(pcsw.Clients.fax) ") }, "anchor": "-20" });
    var box2_3_panel1856 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": phone1854, "labelAlign": "top" }, { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": fax1855, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 72, "border": false, "anchor": "-20", "labelAlign": "top" });
    var gsm1859 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "GSM", "name": "gsm", "maxLength": 200, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("GSM","(pcsw.Clients.gsm) ") }, "anchor": "-20" });
    var box2_panel1860 = new Ext.form.FieldSet({ "flex": 38, "autoHeight": true, "layout": "form", "title": "Contact", "items": [ box2_1_panel1850, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": email1853, "anchor": "-20", "labelAlign": "top" }, box2_3_panel1856, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": gsm1859, "anchor": "-20", "labelAlign": "top" } ], "frame": true, "bodyBorder": false, "autoScroll": false, "hideCheckBoxLabels": true, "labelWidth": 63, "border": false, "labelAlign": "top" });
    var general_1_panel1863 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "hideCheckBoxLabels": true, "items": [ box1_panel1846, box2_panel1860 ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "anchor": "-20", "labelAlign": "top" });
    var gender1864 = new Lino.ChoicesFieldElement({ "autoHeight": true, "forceSelection": true, "fieldLabel": "Gender", "name": "gender", "hiddenName": "genderHidden", "listeners": { "render": Lino.quicktip_renderer("Geschlecht","(pcsw.Clients.gender) ") }, "selectOnFocus": true, "anchor": "-20", "store": [['','<br>']].concat(Lino.lino.Genders) });
    var birth_date1865 = new Lino.IncompleteDateField({ "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Birth date</span>", "name": "birth_date", "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Geburtsdatum","(pcsw.Clients.birth_date) Uncomplete dates are allowed, e.g. \n\"00.00.1980\" means \"some day in 1980\", \n\"00.07.1980\" means \"in July 1980\"\nor \"23.07.0000\" means \"on a 23th of July\".") }, "anchor": "-20" });
    var age_disp1866 = new Ext.form.DisplayField({ "autoHeight": true, "fieldLabel": "Age", "name": "age", "value": "<br/>", "always_enabled": true, "disabled": true, "listeners": { "render": Lino.quicktip_renderer("Alter","(pcsw.Clients.age) ") }, "anchor": "-20" });
    var civil_state1867 = new Lino.ChoicesFieldElement({ "autoHeight": true, "forceSelection": true, "fieldLabel": "Civil state", "name": "civil_state", "hiddenName": "civil_stateHidden", "listeners": { "render": Lino.quicktip_renderer("Zivilstand","(pcsw.Clients.civil_state) ") }, "selectOnFocus": true, "anchor": "-20", "store": [['','<br>']].concat(Lino.pcsw.CivilState) });
    var noble_condition1868 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">noble condition</span>", "name": "noble_condition", "maxLength": 50, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Adelstitel","(pcsw.Clients.noble_condition) The eventual noble condition of this person. Imported from TIM.") }, "anchor": "-20" });
    var box3_1_panel1869 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 14, "autoHeight": true, "layout": "form", "xtype": "panel", "items": gender1864, "labelAlign": "top" }, { "flex": 17, "autoHeight": true, "layout": "form", "xtype": "panel", "items": birth_date1865, "labelAlign": "top" }, { "flex": 14, "autoHeight": true, "layout": "form", "xtype": "panel", "items": age_disp1866, "labelAlign": "top" }, { "flex": 22, "autoHeight": true, "layout": "form", "xtype": "panel", "items": civil_state1867, "labelAlign": "top" }, { "flex": 30, "autoHeight": true, "layout": "form", "xtype": "panel", "items": noble_condition1868, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 117, "border": false, "anchor": "-20", "labelAlign": "top" });
    var birth_country1875 = new Lino.TwinCombo({ "autoHeight": true, "fieldLabel": "Birth country", "name": "birth_country", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.countries.Countries.detail)}, "emptyText": "Select a Country...", "listeners": { "render": Lino.quicktip_renderer("Geburtsland","(pcsw.Clients.birth_country) ") }, "selectOnFocus": true, "hiddenName": "birth_countryHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/pcsw/Clients/birth_country", "method": "GET" }) }) });
    var birth_place1876 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Birth place", "name": "birth_place", "maxLength": 200, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Geburtsort","(pcsw.Clients.birth_place) ") }, "anchor": "-20" });
    var nationality1877 = new Lino.TwinCombo({ "autoHeight": true, "fieldLabel": "Nationality", "name": "nationality", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.countries.Countries.detail)}, "emptyText": "Select a Country...", "listeners": { "render": Lino.quicktip_renderer("Staatsangeh\u00f6rigkeit","(pcsw.Clients.nationality) ") }, "selectOnFocus": true, "hiddenName": "nationalityHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/pcsw/Clients/nationality", "method": "GET" }) }) });
    var national_id1878 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "National ID", "name": "national_id", "maxLength": 200, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("NR-Nummer","(pcsw.Clients.national_id) ") }, "anchor": "-20" });
    var box3_2_panel1879 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 28, "autoHeight": true, "layout": "form", "xtype": "panel", "items": birth_country1875, "labelAlign": "top" }, { "flex": 29, "autoHeight": true, "layout": "form", "xtype": "panel", "items": birth_place1876, "labelAlign": "top" }, { "flex": 21, "autoHeight": true, "layout": "form", "xtype": "panel", "items": nationality1877, "labelAlign": "top" }, { "flex": 21, "autoHeight": true, "layout": "form", "xtype": "panel", "items": national_id1878, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 180, "border": false, "anchor": "-20", "labelAlign": "top" });
    var box3_panel1884 = new Ext.form.FieldSet({ "autoHeight": true, "layout": "form", "title": "Birth", "items": [ box3_1_panel1869, box3_2_panel1879 ], "frame": true, "bodyBorder": false, "autoScroll": false, "hideCheckBoxLabels": true, "border": false, "anchor": "-20", "labelAlign": "top" });
    var eid_info_disp1885 = new Ext.form.DisplayField({ "autoHeight": true, "fieldLabel": "eID card", "name": "eid_info", "value": "<br/>", "always_enabled": true, "disabled": true, "listeners": { "render": Lino.quicktip_renderer("eID-Karte","(pcsw.Clients.eid_info) ") }, "anchor": "-20" });
    var created1886 = new Ext.form.DisplayField({ "disabled": true, "autoHeight": true, "fieldLabel": "Created", "name": "created", "listeners": { "render": Lino.quicktip_renderer("Erstellt","(pcsw.Clients.created) ") }, "value": "<br>", "anchor": "-20" });
    var modified1887 = new Ext.form.DisplayField({ "disabled": true, "autoHeight": true, "fieldLabel": "Modified", "name": "modified", "listeners": { "render": Lino.quicktip_renderer("Bearbeitet","(pcsw.Clients.modified) ") }, "value": "<br>", "anchor": "-20" });
    var box4_3_panel1888 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": created1886, "labelAlign": "top" }, { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": modified1887, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 99, "border": false, "anchor": "-20", "labelAlign": "top" });
    var box4_panel1891 = new Ext.Panel({ "flex": 82, "autoHeight": true, "layout": "form", "items": [ box3_panel1884, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": eid_info_disp1885, "anchor": "-20", "labelAlign": "top" }, box4_3_panel1888 ], "frame": true, "bodyBorder": false, "autoScroll": false, "hideCheckBoxLabels": true, "labelWidth": 90, "border": false, "labelAlign": "top" });
    var image_htmlbox1893 = new Lino.HtmlBoxPanel({ "flex": 17, "layout": "fit", "name": "image", "containing_panel": this, "items": new Ext.BoxComponent({autoScroll:true}), "bodyStyle": "overflow-x:hidden;", "value": "<br/>", "always_enabled": true, "listeners": { "render": Lino.quicktip_renderer(null,"(pcsw.Clients.image) ") } });
    var general_2_panel1894 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ box4_panel1891, image_htmlbox1893 ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 0, "border": false, "anchor": "-20", "labelAlign": "top" });
    var general_panel1895 = new Ext.Panel({ "autoHeight": true, "layout": "form", "title": "Person", "items": [ general_1_panel1863, general_2_panel1894 ], "frame": true, "bodyBorder": false, "hideCheckBoxLabels": true, "listeners": { "activate": Lino.on_tab_activate }, "autoScroll": false, "border": false, "labelAlign": "top" });
    var in_belgium_since1896 = new Lino.DateField({ "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Lives in Belgium since</span>", "name": "in_belgium_since", "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Lebt in Belgien seit","(pcsw.Clients.in_belgium_since) Since when this person in Belgium lives.\n<b>Important:</b> help_text can be formatted.") }, "anchor": "-20" });
    var residence_type1897 = new Lino.ChoicesFieldElement({ "autoHeight": true, "forceSelection": true, "fieldLabel": "Residence type", "name": "residence_type", "hiddenName": "residence_typeHidden", "listeners": { "render": Lino.quicktip_renderer("Register","(pcsw.Clients.residence_type) ") }, "selectOnFocus": true, "anchor": "-20", "store": [['','<br>']].concat(Lino.pcsw.ResidenceType) });
    var gesdos_id1898 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Gesdos ID", "name": "gesdos_id", "maxLength": 40, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Gesdos-Nr","(pcsw.Clients.gesdos_id) ") }, "anchor": "-20" });
    var status_1_panel1899 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 24, "autoHeight": true, "layout": "form", "xtype": "panel", "items": in_belgium_since1896, "labelAlign": "top" }, { "flex": 40, "autoHeight": true, "layout": "form", "xtype": "panel", "items": residence_type1897, "labelAlign": "top" }, { "flex": 34, "autoHeight": true, "layout": "form", "xtype": "panel", "items": gesdos_id1898, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 189, "border": false, "anchor": "-20", "labelAlign": "top" });
    var bank_account11903 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Bank account 1", "name": "bank_account1", "maxLength": 40, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Bankkonto 1","(pcsw.Clients.bank_account1) ") }, "anchor": "-20" });
    var bank_account21904 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Bank account 2", "name": "bank_account2", "maxLength": 40, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Bankkonto 2","(pcsw.Clients.bank_account2) ") }, "anchor": "-20" });
    var status_2_panel1905 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": bank_account11903, "labelAlign": "top" }, { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": bank_account21904, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 108, "border": false, "anchor": "-20", "labelAlign": "top" });
    var job_agents1908 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Job agents", "name": "job_agents", "maxLength": 100, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Interim-Agenturen","(pcsw.Clients.job_agents) ") }, "anchor": "-20" });
    var group1909 = new Lino.RemoteComboFieldElement({ "autoHeight": true, "fieldLabel": "Integration phase", "name": "group", "pageSize": 20, "emptyText": "Select a Integration Phase...", "listeners": { "render": Lino.quicktip_renderer("Integrationsphase","(pcsw.Clients.group) ") }, "selectOnFocus": true, "hiddenName": "groupHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/pcsw/Clients/group", "method": "GET" }) }) });
    var status_3_panel1910 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 56, "autoHeight": true, "layout": "form", "xtype": "panel", "items": job_agents1908, "labelAlign": "top" }, { "flex": 43, "autoHeight": true, "layout": "form", "xtype": "panel", "items": group1909, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 162, "border": false, "anchor": "-20", "labelAlign": "top" });
    var status_panel1913 = new Ext.Panel({ "flex": 68, "autoHeight": true, "border": false, "layout": "form", "hideCheckBoxLabels": true, "items": [ status_1_panel1899, status_2_panel1905, status_3_panel1910 ], "frame": true, "autoScroll": false, "bodyBorder": false, "labelAlign": "top" });
    var aid_type1914 = new Lino.RemoteComboFieldElement({ "autoHeight": true, "fieldLabel": "aid type", "name": "aid_type", "pageSize": 20, "emptyText": "Select a aid type...", "listeners": { "render": Lino.quicktip_renderer("Sozialhilfeart","(pcsw.Clients.aid_type) ") }, "selectOnFocus": true, "hiddenName": "aid_typeHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/pcsw/Clients/aid_type", "method": "GET" }) }) });
    var income_ag1915 = new Ext.form.Checkbox({ "autoHeight": true, "hideLabel": true, "checked": false, "name": "income_ag", "listeners": { "render": Lino.quicktip_renderer("Arbeitslosengeld","(pcsw.Clients.income_ag) ") }, "boxLabel": "unemployment benefit", "selectOnFocus": true, "anchor": "-20" });
    var income_wg1916 = new Ext.form.Checkbox({ "autoHeight": true, "hideLabel": true, "checked": false, "name": "income_wg", "listeners": { "render": Lino.quicktip_renderer("Wartegeld","(pcsw.Clients.income_wg) ") }, "boxLabel": "waiting pay", "selectOnFocus": true, "anchor": "-20" });
    var income_2_panel1917 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": income_ag1915, "labelAlign": "top" }, { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": income_wg1916, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 153, "border": false, "anchor": "-20", "labelAlign": "top" });
    var income_kg1920 = new Ext.form.Checkbox({ "autoHeight": true, "hideLabel": true, "checked": false, "name": "income_kg", "listeners": { "render": Lino.quicktip_renderer("Krankengeld","(pcsw.Clients.income_kg) ") }, "boxLabel": "sickness benefit", "selectOnFocus": true, "anchor": "-20" });
    var income_rente1921 = new Ext.form.Checkbox({ "autoHeight": true, "hideLabel": true, "checked": false, "name": "income_rente", "listeners": { "render": Lino.quicktip_renderer("Rente","(pcsw.Clients.income_rente) ") }, "boxLabel": "retirement pension", "selectOnFocus": true, "anchor": "-20" });
    var income_3_panel1922 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": income_kg1920, "labelAlign": "top" }, { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": income_rente1921, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 108, "border": false, "anchor": "-20", "labelAlign": "top" });
    var income_misc1925 = new Ext.form.Checkbox({ "autoHeight": true, "hideLabel": true, "checked": false, "name": "income_misc", "listeners": { "render": Lino.quicktip_renderer("andere Einkommen","(pcsw.Clients.income_misc) ") }, "boxLabel": "other incomes", "selectOnFocus": true, "anchor": "-20" });
    var income_panel1926 = new Ext.Panel({ "flex": 31, "autoHeight": true, "layout": "form", "items": [ { "autoHeight": true, "layout": "form", "xtype": "panel", "items": aid_type1914, "anchor": "-20", "labelAlign": "top" }, income_2_panel1917, income_3_panel1922, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": income_misc1925, "anchor": "-20", "labelAlign": "top" } ], "frame": true, "bodyBorder": false, "autoScroll": false, "hideCheckBoxLabels": true, "labelWidth": 153, "border": false, "labelAlign": "top" });
    var status_tab_1_panel1929 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "hideCheckBoxLabels": true, "items": [ status_panel1913, income_panel1926 ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var pcsw_DispensesByClient_grid1935 = new Lino.pcsw.DispensesByClient.GridPanel({ "flex": 3, "hide_top_toolbar": true, "containing_panel": this, "region": "north", "preview_limit": 15, "master_panel": this, "listeners": { "render": Lino.quicktip_renderer("Dispenzen","(pcsw.pcsw.DispensesByClient) ") }, "split": true, "tools": [ Lino.show_in_own_window_button(Lino.pcsw.DispensesByClient.grid) ] });
    var pcsw_ExclusionsByClient_grid1941 = new Lino.pcsw.ExclusionsByClient.GridPanel({ "flex": 3, "hide_top_toolbar": true, "containing_panel": this, "region": "center", "preview_limit": 15, "master_panel": this, "listeners": { "render": Lino.quicktip_renderer("AG-Sperren","(pcsw.pcsw.ExclusionsByClient) ") }, "split": true, "tools": [ Lino.show_in_own_window_button(Lino.pcsw.ExclusionsByClient.grid) ] });
    var suche_panel1942 = new Lino.VBorderPanel({ "flex": 50, "border": false, "hideCheckBoxLabels": true, "items": [ pcsw_DispensesByClient_grid1935, pcsw_ExclusionsByClient_grid1941 ], "frame": true, "autoScroll": false, "bodyBorder": false, "labelAlign": "top" });
    var is_seeking1943 = new Ext.form.Checkbox({ "autoHeight": true, "hideLabel": true, "checked": false, "name": "is_seeking", "listeners": { "render": Lino.quicktip_renderer("Arbeit suchend","(pcsw.Clients.is_seeking) ") }, "boxLabel": "is seeking work", "selectOnFocus": true, "anchor": "-20" });
    var unemployed_since1944 = new Lino.DateField({ "autoHeight": true, "fieldLabel": "Seeking work since", "name": "unemployed_since", "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("eingetragen seit","(pcsw.Clients.unemployed_since) ") }, "anchor": "-20" });
    var work_permit_suspended_until1945 = new Lino.DateField({ "autoHeight": true, "fieldLabel": "suspended until", "name": "work_permit_suspended_until", "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Wartezeit bis","(pcsw.Clients.work_permit_suspended_until) ") }, "anchor": "-20" });
    var papers_1_panel1946 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 153, "hideCheckBoxLabels": true, "items": [ { "flex": 38, "autoHeight": true, "layout": "form", "xtype": "panel", "items": is_seeking1943, "labelAlign": "top" }, { "flex": 30, "autoHeight": true, "layout": "form", "xtype": "panel", "items": unemployed_since1944, "labelAlign": "top" }, { "flex": 30, "autoHeight": true, "layout": "form", "xtype": "panel", "items": work_permit_suspended_until1945, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var needs_residence_permit1950 = new Ext.form.Checkbox({ "autoHeight": true, "hideLabel": true, "checked": false, "name": "needs_residence_permit", "listeners": { "render": Lino.quicktip_renderer("Braucht Aufenthaltserlaubnis","(pcsw.Clients.needs_residence_permit) ") }, "boxLabel": "Needs residence permit", "selectOnFocus": true, "anchor": "-20" });
    var needs_work_permit1951 = new Ext.form.Checkbox({ "autoHeight": true, "hideLabel": true, "checked": false, "name": "needs_work_permit", "listeners": { "render": Lino.quicktip_renderer("Braucht Arb.Erl.","(pcsw.Clients.needs_work_permit) ") }, "boxLabel": "Needs work permit", "selectOnFocus": true, "anchor": "-20" });
    var papers_2_panel1952 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 261, "hideCheckBoxLabels": true, "items": [ { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": needs_residence_permit1950, "labelAlign": "top" }, { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": needs_work_permit1951, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var residence_permit_disp1955 = new Ext.form.DisplayField({ "autoHeight": true, "fieldLabel": "Residence permit", "name": "residence_permit", "value": "<br/>", "always_enabled": true, "disabled": true, "listeners": { "render": Lino.quicktip_renderer("Aufenthaltserlaubnis","(pcsw.Clients.residence_permit) ") }, "anchor": "-20" });
    var work_permit_disp1956 = new Ext.form.DisplayField({ "autoHeight": true, "fieldLabel": "Work permit", "name": "work_permit", "value": "<br/>", "always_enabled": true, "disabled": true, "listeners": { "render": Lino.quicktip_renderer("Arbeitserlaubnis","(pcsw.Clients.work_permit) ") }, "anchor": "-20" });
    var driving_licence_disp1957 = new Ext.form.DisplayField({ "autoHeight": true, "fieldLabel": "driving licence", "name": "driving_licence", "value": "<br/>", "always_enabled": true, "disabled": true, "listeners": { "render": Lino.quicktip_renderer("F\u00fchrerschein","(pcsw.Clients.driving_licence) ") }, "anchor": "-20" });
    var papers_3_panel1958 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 189, "hideCheckBoxLabels": true, "items": [ { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": residence_permit_disp1955, "labelAlign": "top" }, { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": work_permit_disp1956, "labelAlign": "top" }, { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": driving_licence_disp1957, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var UploadsByController_htmlbox1962 = new Lino.HtmlBoxPanel({ "flex": 37, "ls_bbar_actions": [ { "itemId": "insert", "menu_item_text": "New", "must_save": true, "tooltip": "Insert a new record", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-add", "overflowText": "New", "auto_save": true } ], "name": "UploadsByController", "containing_panel": this, "items": new Ext.BoxComponent({autoScroll:true}), "title": "Uploads", "master_panel": this, "value": "<br/>", "always_enabled": true, "listeners": { "render": Lino.quicktip_renderer("Uploads","(pcsw.Clients.UploadsByController) ") }, "bodyStyle": "overflow-x:hidden;", "ls_insert_handler": Lino.uploads.UploadsByController.insert, "layout": "fit", "tools": [ Lino.show_in_own_window_button(Lino.uploads.UploadsByController.grid) ] });
    var papers_panel1963 = new Ext.Panel({ "flex": 50, "layout": "vbox", "items": [ papers_1_panel1946, papers_2_panel1952, papers_3_panel1958, UploadsByController_htmlbox1962 ], "frame": true, "layoutConfig": { "align": "stretch" }, "autoScroll": false, "hideCheckBoxLabels": true, "labelWidth": 72, "border": false, "bodyBorder": false, "labelAlign": "top" });
    var status_tab_2_panel1964 = new Ext.Panel({ "flex": 66, "border": false, "layout": "hbox", "hideCheckBoxLabels": true, "items": [ suche_panel1942, papers_panel1963 ], "autoScroll": false, "layoutConfig": { "align": "stretch" }, "frame": false, "labelAlign": "top" });
    var status_tab_panel1965 = new Ext.Panel({ "layout": "vbox", "title": "Status", "items": [ status_tab_1_panel1929, status_tab_2_panel1964 ], "frame": true, "layoutConfig": { "align": "stretch" }, "hideCheckBoxLabels": true, "listeners": { "activate": Lino.on_tab_activate }, "autoScroll": false, "border": false, "bodyBorder": false, "labelAlign": "top" });
    var workflow_buttons_disp1966 = new Ext.form.DisplayField({ "autoHeight": true, "fieldLabel": "Workflow", "name": "workflow_buttons", "value": "<br/>", "always_enabled": true, "disabled": true, "listeners": { "render": Lino.quicktip_renderer("Arbeitsablauf","(pcsw.Clients.workflow_buttons) ") }, "anchor": "-20" });
    var broker1967 = new Lino.RemoteComboFieldElement({ "autoHeight": true, "fieldLabel": "Broker", "name": "broker", "pageSize": 20, "emptyText": "Select a Broker...", "listeners": { "render": Lino.quicktip_renderer("Vermittler","(pcsw.Clients.broker) ") }, "selectOnFocus": true, "hiddenName": "brokerHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/pcsw/Clients/broker", "method": "GET" }) }) });
    var faculty1968 = new Lino.TwinCombo({ "autoHeight": true, "fieldLabel": "Faculty", "name": "faculty", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.newcomers.Faculties.detail)}, "emptyText": "Select a Faculty...", "listeners": { "render": Lino.quicktip_renderer("Fachbereich","(pcsw.Clients.faculty) ") }, "selectOnFocus": true, "hiddenName": "facultyHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/pcsw/Clients/faculty", "method": "GET" }) }) });
    var newcomers_left_panel1969 = new Ext.Panel({ "flex": 33, "autoHeight": true, "layout": "form", "items": [ { "autoHeight": true, "layout": "form", "xtype": "panel", "items": workflow_buttons_disp1966, "anchor": "-20", "labelAlign": "top" }, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": broker1967, "anchor": "-20", "labelAlign": "top" }, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": faculty1968, "anchor": "-20", "labelAlign": "top" } ], "frame": true, "bodyBorder": false, "autoScroll": false, "hideCheckBoxLabels": true, "labelWidth": 126, "border": false, "labelAlign": "top" });
    var newcomers_AvailableCoachesByClient_grid2100 = new Lino.newcomers.AvailableCoachesByClient.GridPanel({ "flex": 66, "listeners": { "render": Lino.quicktip_renderer("Verf\u00fcgbare Begleiter","(newcomers.newcomers.AvailableCoachesByClient) ") }, "hide_top_toolbar": true, "containing_panel": this, "tools": [ Lino.show_in_own_window_button(Lino.newcomers.AvailableCoachesByClient.grid) ], "preview_limit": 15, "master_panel": this });
    var coaching_1_panel2101 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "hideCheckBoxLabels": true, "items": [ newcomers_left_panel1969, newcomers_AvailableCoachesByClient_grid2100 ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var pcsw_ContactsByClient_grid2102 = new Lino.pcsw.ContactsByClient.GridPanel({ "flex": 50, "listeners": { "render": Lino.quicktip_renderer("Kontakte","(pcsw.pcsw.ContactsByClient) ") }, "hide_top_toolbar": true, "containing_panel": this, "tools": [ Lino.show_in_own_window_button(Lino.pcsw.ContactsByClient.grid) ], "preview_limit": 15, "master_panel": this });
    var pcsw_CoachingsByClient_grid2111 = new Lino.pcsw.CoachingsByClient.GridPanel({ "flex": 50, "hide_top_toolbar": true, "containing_panel": this, "params_panel_hidden": true, "preview_limit": 15, "master_panel": this, "listeners": { "render": Lino.quicktip_renderer("Begleitungen","(pcsw.pcsw.CoachingsByClient) ") }, "tools": [ Lino.show_in_own_window_button(Lino.pcsw.CoachingsByClient.grid) ] });
    var coaching_2_panel2112 = new Ext.Panel({ "flex": 50, "border": false, "layout": "hbox", "hideCheckBoxLabels": true, "items": [ pcsw_ContactsByClient_grid2102, pcsw_CoachingsByClient_grid2111 ], "autoScroll": false, "layoutConfig": { "align": "stretch" }, "frame": false, "labelAlign": "top" });
    var coaching_panel2113 = new Ext.Panel({ "layout": "vbox", "title": "Coaching", "items": [ coaching_1_panel2101, coaching_2_panel2112 ], "frame": true, "layoutConfig": { "align": "stretch" }, "hideCheckBoxLabels": true, "listeners": { "activate": Lino.on_tab_activate }, "autoScroll": false, "border": false, "bodyBorder": false, "labelAlign": "top" });
    var jobs_StudiesByPerson_grid2126 = new Lino.jobs.StudiesByPerson.GridPanel({ "flex": 5, "hide_top_toolbar": true, "containing_panel": this, "region": "north", "preview_limit": 15, "master_panel": this, "listeners": { "render": Lino.quicktip_renderer("Ausbildungen und Studien","(jobs.jobs.StudiesByPerson) List of studies for a given person.") }, "split": true, "tools": [ Lino.show_in_own_window_button(Lino.jobs.StudiesByPerson.grid) ] });
    var jobs_ExperiencesByPerson_grid2136 = new Lino.jobs.ExperiencesByPerson.GridPanel({ "flex": 5, "hide_top_toolbar": true, "containing_panel": this, "region": "center", "preview_limit": 15, "master_panel": this, "listeners": { "render": Lino.quicktip_renderer("Berufserfahrungen","(jobs.jobs.ExperiencesByPerson) ") }, "split": true, "tools": [ Lino.show_in_own_window_button(Lino.jobs.ExperiencesByPerson.grid) ] });
    var education_panel2137 = new Lino.VBorderPanel({ "autoScroll": false, "listeners": { "activate": Lino.on_tab_activate }, "border": false, "title": "Education", "hideCheckBoxLabels": true, "items": [ jobs_StudiesByPerson_grid2126, jobs_ExperiencesByPerson_grid2136 ], "frame": true, "bodyBorder": false, "labelAlign": "top" });
    var cv_LanguageKnowledgesByPerson_grid2144 = new Lino.cv.LanguageKnowledgesByPerson.GridPanel({ "flex": 5, "hide_top_toolbar": true, "containing_panel": this, "region": "north", "preview_limit": 15, "master_panel": this, "listeners": { "render": Lino.quicktip_renderer("Sprachkenntnisse","(cv.cv.LanguageKnowledgesByPerson) ") }, "split": true, "tools": [ Lino.show_in_own_window_button(Lino.cv.LanguageKnowledgesByPerson.grid) ] });
    var courses_CourseRequestsByPerson_grid2155 = new Lino.courses.CourseRequestsByPerson.GridPanel({ "flex": 5, "hide_top_toolbar": true, "containing_panel": this, "region": "center", "preview_limit": 15, "master_panel": this, "listeners": { "render": Lino.quicktip_renderer("Kursanfragen","(courses.courses.CourseRequestsByPerson) ") }, "split": true, "tools": [ Lino.show_in_own_window_button(Lino.courses.CourseRequestsByPerson.grid) ] });
    var languages_panel2156 = new Lino.VBorderPanel({ "autoScroll": false, "listeners": { "activate": Lino.on_tab_activate }, "border": false, "title": "Languages", "hideCheckBoxLabels": true, "items": [ cv_LanguageKnowledgesByPerson_grid2144, courses_CourseRequestsByPerson_grid2155 ], "frame": true, "bodyBorder": false, "labelAlign": "top" });
    var cv_SkillsByPerson_grid2163 = new Lino.cv.SkillsByPerson.GridPanel({ "flex": 35, "listeners": { "render": Lino.quicktip_renderer("Fachkompetenzen","(cv.cv.SkillsByPerson) ") }, "hide_top_toolbar": true, "containing_panel": this, "tools": [ Lino.show_in_own_window_button(Lino.cv.SkillsByPerson.grid) ], "preview_limit": 15, "master_panel": this });
    var cv_SoftSkillsByPerson_grid2170 = new Lino.cv.SoftSkillsByPerson.GridPanel({ "flex": 35, "listeners": { "render": Lino.quicktip_renderer("Sozialkompetenzen","(cv.cv.SoftSkillsByPerson) ") }, "hide_top_toolbar": true, "containing_panel": this, "tools": [ Lino.show_in_own_window_button(Lino.cv.SoftSkillsByPerson.grid) ], "preview_limit": 15, "master_panel": this });
    var skills2171 = new Ext.form.TextArea({ "listeners": { "render": Lino.quicktip_renderer("Sonstige F\u00e4higkeiten","(pcsw.Clients.skills) ") }, "fieldLabel": "Other skills", "name": "skills", "growMax": 2000, "selectOnFocus": true, "anchor": "-20 -10" });
    var competences_1_panel2172 = new Ext.Panel({ "flex": 5, "layout": "hbox", "items": [ cv_SkillsByPerson_grid2163, cv_SoftSkillsByPerson_grid2170, { "items": skills2171, "labelAlign": "top", "layout": "form", "xtype": "panel", "flex": 28 } ], "region": "north", "layoutConfig": { "align": "stretch" }, "hideCheckBoxLabels": true, "split": true, "autoScroll": false, "labelWidth": 189, "border": false, "frame": false, "labelAlign": "top" });
    var cv_ObstaclesByPerson_grid2180 = new Lino.cv.ObstaclesByPerson.GridPanel({ "flex": 55, "listeners": { "render": Lino.quicktip_renderer("Hindernisse","(cv.cv.ObstaclesByPerson) ") }, "hide_top_toolbar": true, "containing_panel": this, "tools": [ Lino.show_in_own_window_button(Lino.cv.ObstaclesByPerson.grid) ], "preview_limit": 15, "master_panel": this });
    var obstacles2181 = new Ext.form.TextArea({ "listeners": { "render": Lino.quicktip_renderer("Hindernisse","(pcsw.Clients.obstacles) ") }, "fieldLabel": "Obstacles", "name": "obstacles", "growMax": 2000, "selectOnFocus": true, "anchor": "-20 -10" });
    var competences_2_panel2182 = new Ext.Panel({ "flex": 5, "layout": "hbox", "items": [ cv_ObstaclesByPerson_grid2180, { "items": obstacles2181, "labelAlign": "top", "layout": "form", "xtype": "panel", "flex": 44 } ], "region": "center", "layoutConfig": { "align": "stretch" }, "hideCheckBoxLabels": true, "split": true, "autoScroll": false, "labelWidth": 108, "border": false, "frame": false, "labelAlign": "top" });
    var competences_panel2184 = new Lino.VBorderPanel({ "autoScroll": false, "listeners": { "activate": Lino.on_tab_activate }, "border": false, "title": "Competences", "hideCheckBoxLabels": true, "items": [ competences_1_panel2172, competences_2_panel2182 ], "frame": true, "bodyBorder": false, "labelAlign": "top" });
    var jobs_CandidaturesByPerson_grid2193 = new Lino.jobs.CandidaturesByPerson.GridPanel({ "listeners": { "activate": Lino.on_tab_activate }, "hide_top_toolbar": true, "containing_panel": this, "title": "Job Requests", "tools": [ Lino.show_in_own_window_button(Lino.jobs.CandidaturesByPerson.grid) ], "preview_limit": 15, "master_panel": this });
    var isip_ContractsByPerson_grid2296 = new Lino.isip.ContractsByPerson.GridPanel({ "flex": 5, "hide_top_toolbar": true, "containing_panel": this, "region": "north", "params_panel_hidden": true, "master_panel": this, "preview_limit": 15, "listeners": { "render": Lino.quicktip_renderer("VSEs","(isip.isip.ContractsByPerson) ") }, "split": true, "tools": [ Lino.show_in_own_window_button(Lino.isip.ContractsByPerson.grid) ] });
    var jobs_ContractsByPerson_grid2324 = new Lino.jobs.ContractsByPerson.GridPanel({ "flex": 5, "hide_top_toolbar": true, "containing_panel": this, "region": "center", "params_panel_hidden": true, "master_panel": this, "preview_limit": 15, "listeners": { "render": Lino.quicktip_renderer("Art.60\u00a77-Konventionen","(jobs.jobs.ContractsByPerson) ") }, "split": true, "tools": [ Lino.show_in_own_window_button(Lino.jobs.ContractsByPerson.grid) ] });
    var contracts_panel2325 = new Lino.VBorderPanel({ "autoScroll": false, "listeners": { "activate": Lino.on_tab_activate }, "border": false, "title": "Contracts", "hideCheckBoxLabels": true, "items": [ isip_ContractsByPerson_grid2296, jobs_ContractsByPerson_grid2324 ], "frame": true, "bodyBorder": false, "labelAlign": "top" });
    var pcsw_NotesByPerson_grid2326 = new Lino.pcsw.NotesByPerson.GridPanel({ "listeners": { "activate": Lino.on_tab_activate }, "hide_top_toolbar": true, "containing_panel": this, "title": "History", "tools": [ Lino.show_in_own_window_button(Lino.pcsw.NotesByPerson.grid) ], "preview_limit": 15, "master_panel": this });
    var find_appointment_disp2327 = new Ext.form.DisplayField({ "autoHeight": true, "fieldLabel": "Find appointment", "name": "find_appointment", "value": "<br/>", "always_enabled": true, "disabled": true, "listeners": { "render": Lino.quicktip_renderer("Termin finden","(pcsw.Clients.find_appointment) ") }, "anchor": "-20" });
    var cal_EventsByProject_grid2333 = new Lino.cal.EventsByProject.GridPanel({ "flex": 5, "hide_top_toolbar": true, "containing_panel": this, "region": "center", "params_panel_hidden": true, "master_panel": this, "preview_limit": 15, "listeners": { "render": Lino.quicktip_renderer("Termine","(cal.cal.EventsByProject) ") }, "split": true, "tools": [ Lino.show_in_own_window_button(Lino.cal.EventsByProject.grid) ] });
    var cal_TasksByProject_grid2355 = new Lino.cal.TasksByProject.GridPanel({ "flex": 5, "hide_top_toolbar": true, "containing_panel": this, "region": "south", "params_panel_hidden": true, "master_panel": this, "preview_limit": 15, "listeners": { "render": Lino.quicktip_renderer("Aufgaben","(cal.cal.TasksByProject) ") }, "split": true, "tools": [ Lino.show_in_own_window_button(Lino.cal.TasksByProject.grid) ] });
    var calendar_panel2356 = new Lino.VBorderPanel({ "autoScroll": false, "listeners": { "activate": Lino.on_tab_activate }, "border": false, "labelWidth": 126, "title": "Calendar", "hideCheckBoxLabels": true, "items": [ { "autoHeight": true, "layout": "form", "xtype": "panel", "items": find_appointment_disp2327, "region": "north", "labelAlign": "top", "split": true }, cal_EventsByProject_grid2333, cal_TasksByProject_grid2355 ], "frame": true, "bodyBorder": false, "labelAlign": "top" });
    var outbox_MailsByProject_grid2368 = new Lino.outbox.MailsByProject.GridPanel({ "listeners": { "activate": Lino.on_tab_activate }, "hide_top_toolbar": true, "containing_panel": this, "title": "Outbox", "tools": [ Lino.show_in_own_window_button(Lino.outbox.MailsByProject.grid) ], "preview_limit": 15, "master_panel": this });
    var activity2369 = new Lino.RemoteComboFieldElement({ "autoHeight": true, "fieldLabel": "activity", "name": "activity", "pageSize": 20, "emptyText": "Select a activity...", "listeners": { "render": Lino.quicktip_renderer("Beruf","(pcsw.Clients.activity) ") }, "selectOnFocus": true, "hiddenName": "activityHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/pcsw/Clients/activity", "method": "GET" }) }) });
    var client_state2370 = new Lino.ChoicesFieldElement({ "autoHeight": true, "forceSelection": true, "fieldLabel": "State", "allowBlank": false, "hiddenName": "client_stateHidden", "listeners": { "render": Lino.quicktip_renderer("Zustand","(pcsw.Clients.client_state) ") }, "selectOnFocus": true, "anchor": "-20", "store": Lino.pcsw.ClientStates, "name": "client_state" });
    var refusal_reason2371 = new Lino.ChoicesFieldElement({ "autoHeight": true, "forceSelection": true, "fieldLabel": "refusal reason", "name": "refusal_reason", "hiddenName": "refusal_reasonHidden", "listeners": { "render": Lino.quicktip_renderer("refusal reason","(pcsw.Clients.refusal_reason) ") }, "selectOnFocus": true, "anchor": "-20", "store": [['','<br>']].concat(Lino.pcsw.RefusalReasons) });
    var unavailable_until2372 = new Lino.DateField({ "autoHeight": true, "fieldLabel": "Unavailable until", "name": "unavailable_until", "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Nicht verf\u00fcgbar bis","(pcsw.Clients.unavailable_until) ") }, "anchor": "-20" });
    var unavailable_why2373 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "reason", "name": "unavailable_why", "maxLength": 100, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Grund","(pcsw.Clients.unavailable_why) ") }, "anchor": "-20" });
    var misc_1_panel2374 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 180, "hideCheckBoxLabels": true, "items": [ { "flex": 16, "autoHeight": true, "layout": "form", "xtype": "panel", "items": activity2369, "labelAlign": "top" }, { "flex": 9, "autoHeight": true, "layout": "form", "xtype": "panel", "items": client_state2370, "labelAlign": "top" }, { "flex": 36, "autoHeight": true, "layout": "form", "xtype": "panel", "items": refusal_reason2371, "labelAlign": "top" }, { "flex": 12, "autoHeight": true, "layout": "form", "xtype": "panel", "items": unavailable_until2372, "labelAlign": "top" }, { "flex": 25, "autoHeight": true, "layout": "form", "xtype": "panel", "items": unavailable_why2373, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var is_cpas2380 = new Ext.form.Checkbox({ "autoHeight": true, "hideLabel": true, "checked": false, "name": "is_cpas", "listeners": { "render": Lino.quicktip_renderer("Sozialhilfeempf\u00e4nger","(pcsw.Clients.is_cpas) ") }, "boxLabel": "receives social help", "selectOnFocus": true, "anchor": "-20" });
    var is_senior2381 = new Ext.form.Checkbox({ "autoHeight": true, "hideLabel": true, "checked": false, "name": "is_senior", "listeners": { "render": Lino.quicktip_renderer("Altenheim","(pcsw.Clients.is_senior) ") }, "boxLabel": "is senior", "selectOnFocus": true, "anchor": "-20" });
    var is_obsolete2382 = new Ext.form.Checkbox({ "autoHeight": true, "hideLabel": true, "checked": false, "name": "is_obsolete", "listeners": { "render": Lino.quicktip_renderer("veraltet","(pcsw.Clients.is_obsolete) Altf\u00e4lle sind Partner, deren Stammdaten nicht mehr gepflegt werden und \nf\u00fcr neue Operationen nicht benutzt werden k\u00f6nnen.") }, "boxLabel": "obsolete", "selectOnFocus": true, "anchor": "-20" });
    var misc_2_panel2383 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 189, "hideCheckBoxLabels": true, "items": [ { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": is_cpas2380, "labelAlign": "top" }, { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": is_senior2381, "labelAlign": "top" }, { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": is_obsolete2382, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var remarks2387 = new Ext.form.TextArea({ "listeners": { "render": Lino.quicktip_renderer("Bemerkungen","(pcsw.Clients.remarks) ") }, "fieldLabel": "Remarks", "name": "remarks", "growMax": 2000, "selectOnFocus": true, "anchor": "-20 -10" });
    var remarks22388 = new Ext.form.TextArea({ "listeners": { "render": Lino.quicktip_renderer("Bemerkungen (Sozialsekretariat)","(pcsw.Clients.remarks2) ") }, "fieldLabel": "Remarks (Social Office)", "name": "remarks2", "growMax": 2000, "selectOnFocus": true, "anchor": "-20 -10" });
    var misc_3_panel2389 = new Ext.Panel({ "flex": 41, "border": false, "layout": "hbox", "labelWidth": 288, "hideCheckBoxLabels": true, "items": [ { "items": remarks2387, "labelAlign": "top", "layout": "form", "xtype": "panel", "flex": 50 }, { "items": remarks22388, "labelAlign": "top", "layout": "form", "xtype": "panel", "flex": 50 } ], "autoScroll": false, "layoutConfig": { "align": "stretch" }, "frame": false, "labelAlign": "top" });
    var contacts_RolesByPerson_grid2392 = new Lino.contacts.RolesByPerson.GridPanel({ "flex": 33, "listeners": { "render": Lino.quicktip_renderer("Kontaktperson f\u00fcr","(contacts.contacts.RolesByPerson) ") }, "hide_top_toolbar": true, "containing_panel": this, "tools": [ Lino.show_in_own_window_button(Lino.contacts.RolesByPerson.grid) ], "preview_limit": 15, "master_panel": this });
    var households_MembersByPerson_grid2393 = new Lino.households.MembersByPerson.GridPanel({ "flex": 66, "listeners": { "render": Lino.quicktip_renderer("Mitglied von","(households.households.MembersByPerson) ") }, "hide_top_toolbar": true, "containing_panel": this, "tools": [ Lino.show_in_own_window_button(Lino.households.MembersByPerson.grid) ], "preview_limit": 15, "master_panel": this });
    var misc_4_panel2394 = new Ext.Panel({ "flex": 41, "border": false, "layout": "hbox", "hideCheckBoxLabels": true, "items": [ contacts_RolesByPerson_grid2392, households_MembersByPerson_grid2393 ], "autoScroll": false, "layoutConfig": { "align": "stretch" }, "frame": false, "labelAlign": "top" });
    var misc_panel2395 = new Ext.Panel({ "layout": "vbox", "title": "Miscellaneous", "items": [ misc_1_panel2374, misc_2_panel2383, misc_3_panel2389, misc_4_panel2394 ], "frame": true, "layoutConfig": { "align": "stretch" }, "hideCheckBoxLabels": true, "listeners": { "activate": Lino.on_tab_activate }, "autoScroll": false, "border": false, "bodyBorder": false, "labelAlign": "top" });
    var cbss_identify_person_disp2396 = new Ext.form.DisplayField({ "autoHeight": true, "fieldLabel": "IdentifyPerson Requests", "name": "cbss_identify_person", "value": "<br/>", "always_enabled": true, "disabled": true, "listeners": { "render": Lino.quicktip_renderer("IdentifyPerson-Anfragen","(pcsw.Clients.cbss_identify_person) ") }, "anchor": "-20" });
    var cbss_manage_access_disp2397 = new Ext.form.DisplayField({ "autoHeight": true, "fieldLabel": "ManageAccess Requests", "name": "cbss_manage_access", "value": "<br/>", "always_enabled": true, "disabled": true, "listeners": { "render": Lino.quicktip_renderer("ManageAccess-Anfragen","(pcsw.Clients.cbss_manage_access) ") }, "anchor": "-20" });
    var cbss_retrieve_ti_groups_disp2398 = new Ext.form.DisplayField({ "autoHeight": true, "fieldLabel": "Tx25 Requests", "name": "cbss_retrieve_ti_groups", "value": "<br/>", "always_enabled": true, "disabled": true, "listeners": { "render": Lino.quicktip_renderer("Tx25-Anfragen","(pcsw.Clients.cbss_retrieve_ti_groups) ") }, "anchor": "-20" });
    var cbss_1_panel2399 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 216, "hideCheckBoxLabels": true, "items": [ { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": cbss_identify_person_disp2396, "labelAlign": "top" }, { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": cbss_manage_access_disp2397, "labelAlign": "top" }, { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": cbss_retrieve_ti_groups_disp2398, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var cbss_summary_htmlbox2403 = new Lino.HtmlBoxPanel({ "flex": 50, "layout": "fit", "name": "cbss_summary", "containing_panel": this, "items": new Ext.BoxComponent({autoScroll:true}), "title": "CBSS summary", "bodyStyle": "overflow-x:hidden;", "value": "<br/>", "always_enabled": true, "listeners": { "render": Lino.quicktip_renderer("Zusammenfassung ZDSS","(pcsw.Clients.cbss_summary) ") } });
    var cbss_panel2404 = new Ext.Panel({ "layout": "vbox", "title": "CBSS", "items": [ cbss_1_panel2399, cbss_summary_htmlbox2403 ], "frame": true, "layoutConfig": { "align": "stretch" }, "hideCheckBoxLabels": true, "listeners": { "activate": Lino.on_tab_activate }, "autoScroll": false, "labelWidth": 189, "border": false, "bodyBorder": false, "labelAlign": "top" });
    var debts_BudgetsByPartner_grid2405 = new Lino.debts.BudgetsByPartner.GridPanel({ "flex": 5, "hide_top_toolbar": true, "containing_panel": this, "region": "north", "preview_limit": 15, "master_panel": this, "listeners": { "render": Lino.quicktip_renderer("Ist Hauptpartner in folgenden Budgets:","(debts.debts.BudgetsByPartner) ") }, "split": true, "tools": [ Lino.show_in_own_window_button(Lino.debts.BudgetsByPartner.grid) ] });
    var debts_ActorsByPartner_grid2406 = new Lino.debts.ActorsByPartner.GridPanel({ "flex": 5, "hide_top_toolbar": true, "containing_panel": this, "region": "center", "preview_limit": 15, "master_panel": this, "listeners": { "render": Lino.quicktip_renderer("Ist Akteur in folgenden Budgets:","(debts.debts.ActorsByPartner) ") }, "split": true, "tools": [ Lino.show_in_own_window_button(Lino.debts.ActorsByPartner.grid) ] });
    var debts_panel2407 = new Lino.VBorderPanel({ "autoScroll": false, "listeners": { "activate": Lino.on_tab_activate }, "border": false, "title": "Debts mediation", "hideCheckBoxLabels": true, "items": [ debts_BudgetsByPartner_grid2405, debts_ActorsByPartner_grid2406 ], "frame": true, "bodyBorder": false, "labelAlign": "top" });
    var main_panel2408 = new Ext.TabPanel({ "hideCheckBoxLabels": true, "border": false, "split": true, "autoScroll": false, "items": [ general_panel1895, status_tab_panel1965, coaching_panel2113, education_panel2137, languages_panel2156, competences_panel2184, jobs_CandidaturesByPerson_grid2193, contracts_panel2325, pcsw_NotesByPerson_grid2326, calendar_panel2356, outbox_MailsByProject_grid2368, misc_panel2395, cbss_panel2404, debts_panel2407 ], "activeTab": 0, "bodyBorder": false, "frame": true, "labelAlign": "top" });
    this.items = main_panel2408;
    this.before_row_edit = function(record) {
      city1830.setContextValue('country',record ? record.data['countryHidden'] : undefined);
      city1830.setContextValue('region',record ? record.data['regionHidden'] : undefined);
      image_htmlbox1893.refresh();
      pcsw_DispensesByClient_grid1935.on_master_changed();
      pcsw_ExclusionsByClient_grid1941.on_master_changed();
      UploadsByController_htmlbox1962.refresh();
      newcomers_AvailableCoachesByClient_grid2100.on_master_changed();
      pcsw_ContactsByClient_grid2102.on_master_changed();
      pcsw_CoachingsByClient_grid2111.on_master_changed();
      jobs_StudiesByPerson_grid2126.on_master_changed();
      jobs_ExperiencesByPerson_grid2136.on_master_changed();
      cv_LanguageKnowledgesByPerson_grid2144.on_master_changed();
      courses_CourseRequestsByPerson_grid2155.on_master_changed();
      cv_SkillsByPerson_grid2163.on_master_changed();
      cv_SoftSkillsByPerson_grid2170.on_master_changed();
      cv_ObstaclesByPerson_grid2180.on_master_changed();
      jobs_CandidaturesByPerson_grid2193.on_master_changed();
      isip_ContractsByPerson_grid2296.on_master_changed();
      jobs_ContractsByPerson_grid2324.on_master_changed();
      pcsw_NotesByPerson_grid2326.on_master_changed();
      cal_EventsByProject_grid2333.on_master_changed();
      cal_TasksByProject_grid2355.on_master_changed();
      outbox_MailsByProject_grid2368.on_master_changed();
      contacts_RolesByPerson_grid2392.on_master_changed();
      households_MembersByPerson_grid2393.on_master_changed();
      cbss_summary_htmlbox2403.refresh();
      debts_BudgetsByPartner_grid2405.on_master_changed();
      debts_ActorsByPartner_grid2406.on_master_changed();
    }
    this.onRender = function(ct, position) {
      country1829.on('change',Lino.chooser_handler(city1830,'country'));
      Lino.pcsw.Clients.DetailFormPanel.superclass.onRender.call(this, ct, position);
    }
    Lino.pcsw.Clients.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.notes.NoteTypes.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 100,
  initComponent : function() {
    var containing_panel = this;
    var id2938 = new Ext.form.NumberField({ "autoHeight": true, "fieldLabel": "ID", "name": "id", "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("ID","(notes.NoteTypes.id) ") }, "anchor": "-20" });
    var name2939 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Designation", "name": "name", "listeners": { "render": Lino.quicktip_renderer("Bezeichnung","(notes.NoteTypes.name) ") }, "maxLength": 200, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var name_fr2940 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Designation (fr)", "name": "name_fr", "maxLength": 200, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Bezeichnung (fr)","(notes.NoteTypes.name_fr) ") }, "anchor": "-20" });
    var name_de2941 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Designation (de)", "name": "name_de", "maxLength": 200, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Bezeichnung (de)","(notes.NoteTypes.name_de) ") }, "anchor": "-20" });
    var name_nl2942 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Designation (nl)", "name": "name_nl", "listeners": { "render": Lino.quicktip_renderer("Bezeichnung (nl)","(notes.NoteTypes.name_nl) ") }, "maxLength": 200, "selectOnFocus": true, "hidden": true, "anchor": "-20" });
    var main_1_panel2943 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 153, "hideCheckBoxLabels": true, "items": [ { "flex": 5, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id2938, "labelAlign": "top" }, { "flex": 23, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name2939, "labelAlign": "top" }, { "flex": 23, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_fr2940, "labelAlign": "top" }, { "flex": 23, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_de2941, "labelAlign": "top" }, { "flex": 23, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_nl2942, "hidden": true, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var build_method2949 = new Lino.ChoicesFieldElement({ "autoHeight": true, "fieldLabel": "Build method", "name": "build_method", "hiddenName": "build_methodHidden", "listeners": { "render": Lino.quicktip_renderer("Konstruktionsmethode","(notes.NoteTypes.build_method) ") }, "selectOnFocus": true, "anchor": "-20", "store": [ [ "appyodt", "AppyOdtBuildMethod" ], [ "appypdf", "AppyPdfBuildMethod" ], [ "appyrtf", "AppyRtfBuildMethod" ], [ "latex", "LatexBuildMethod" ], [ "pisa", "PisaBuildMethod" ], [ "rtf", "RtfBuildMethod" ] ] });
    var template2950 = new Lino.SimpleRemoteComboFieldElement({ "autoHeight": true, "fieldLabel": "Template", "name": "template", "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Vorlage","(notes.NoteTypes.template) ") }, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/notes/NoteTypes/template", "method": "GET" }) }), "anchor": "-20" });
    var body_template2951 = new Lino.SimpleRemoteComboFieldElement({ "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Body template</span>", "name": "body_template", "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Body template","(notes.NoteTypes.body_template) The body template to be used when \nrendering a printable of this type. This is a list of files \nwith extension `.body.html`.") }, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/notes/NoteTypes/body_template", "method": "GET" }) }), "anchor": "-20" });
    var email_template2952 = new Lino.SimpleRemoteComboFieldElement({ "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Email template</span>", "name": "email_template", "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("E-Mail-Vorlage","(notes.NoteTypes.email_template) The name of the file to be used as \ntemplate when creating an email from a mailable of this type.") }, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/notes/NoteTypes/email_template", "method": "GET" }) }), "anchor": "-20" });
    var attach_to_email2953 = new Ext.form.Checkbox({ "autoHeight": true, "hideLabel": true, "checked": false, "name": "attach_to_email", "listeners": { "render": Lino.quicktip_renderer("als Anhang per E-Mail","(notes.NoteTypes.attach_to_email) Whether the printable file should be attached to the email\nwhen creating an email from a mailable of this type.\n") }, "boxLabel": "Attach to email", "selectOnFocus": true, "anchor": "-20" });
    var main_2_panel2954 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 198, "hideCheckBoxLabels": true, "items": [ { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": build_method2949, "labelAlign": "top" }, { "flex": 16, "autoHeight": true, "layout": "form", "xtype": "panel", "items": template2950, "labelAlign": "top" }, { "flex": 16, "autoHeight": true, "layout": "form", "xtype": "panel", "items": body_template2951, "labelAlign": "top" }, { "flex": 16, "autoHeight": true, "layout": "form", "xtype": "panel", "items": email_template2952, "labelAlign": "top" }, { "flex": 16, "autoHeight": true, "layout": "form", "xtype": "panel", "items": attach_to_email2953, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var remark2960 = new Ext.form.TextArea({ "listeners": { "render": Lino.quicktip_renderer("Bemerkung","(notes.NoteTypes.remark) ") }, "fieldLabel": "Remark", "name": "remark", "growMax": 2000, "selectOnFocus": true, "anchor": "-20 -10" });
    var notes_NotesByType_grid2976 = new Lino.notes.NotesByType.GridPanel({ "flex": 41, "listeners": { "render": Lino.quicktip_renderer("Ereignisse/Notizen","(notes.notes.NotesByType) ") }, "hide_top_toolbar": true, "containing_panel": this, "tools": [ Lino.show_in_own_window_button(Lino.notes.NotesByType.grid) ], "preview_limit": 15, "master_panel": this });
    var main_panel2977 = new Ext.Panel({ "autoScroll": false, "border": false, "layout": "vbox", "labelWidth": 90, "hideCheckBoxLabels": true, "items": [ main_1_panel2943, main_2_panel2954, { "items": remark2960, "labelAlign": "top", "layout": "form", "xtype": "panel", "flex": 41 }, notes_NotesByType_grid2976 ], "frame": true, "layoutConfig": { "align": "stretch" }, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel2977;
    this.before_row_edit = function(record) {
      template2950.setContextValue('build_method',record ? record.data['build_methodHidden'] : undefined);
      notes_NotesByType_grid2976.on_master_changed();
    }
    this.onRender = function(ct, position) {
      build_method2949.on('change',Lino.chooser_handler(template2950,'build_method'));
      Lino.notes.NoteTypes.DetailFormPanel.superclass.onRender.call(this, ct, position);
    }
    Lino.notes.NoteTypes.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.cbss.ManageAccessRequests.InsertFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  autoHeight: true,
  content_type: 95,
  initComponent : function() {
    var containing_panel = this;
    var person5000 = new Lino.TwinCombo({ "preferred_width": 20, "autoHeight": true, "fieldLabel": "Client", "allowBlank": false, "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.pcsw.Clients.detail)}, "emptyText": "Select a Client...", "listeners": { "render": Lino.quicktip_renderer("Klient","(cbss.ManageAccessRequests.person) ") }, "selectOnFocus": true, "hiddenName": "personHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cbss/ManageAccessRequests/person", "method": "GET" }) }), "name": "person" });
    var action5001 = new Lino.ChoicesFieldElement({ "autoHeight": true, "forceSelection": true, "fieldLabel": "Action", "allowBlank": false, "hiddenName": "actionHidden", "listeners": { "render": Lino.quicktip_renderer("Aktion","(cbss.ManageAccessRequests.action) ") }, "selectOnFocus": true, "anchor": "-20", "store": Lino.cbss.ManageAction, "name": "action" });
    var start_date5002 = new Lino.DateField({ "autoHeight": true, "allowBlank": false, "fieldLabel": "Period from", "name": "start_date", "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Periode vom","(cbss.ManageAccessRequests.start_date) ") }, "anchor": "-20" });
    var end_date5003 = new Lino.DateField({ "autoHeight": true, "allowBlank": false, "fieldLabel": "Period until", "name": "end_date", "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Periode bis","(cbss.ManageAccessRequests.end_date) ") }, "anchor": "-20" });
    var p1_1_panel5004 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 44, "autoHeight": true, "layout": "form", "xtype": "panel", "items": action5001, "labelAlign": "top" }, { "flex": 27, "autoHeight": true, "layout": "form", "xtype": "panel", "items": start_date5002, "labelAlign": "top" }, { "flex": 27, "autoHeight": true, "layout": "form", "xtype": "panel", "items": end_date5003, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 108, "border": false, "anchor": "-20", "labelAlign": "top" });
    var purpose5008 = new Lino.RemoteComboFieldElement({ "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Purpose</span>", "allowBlank": false, "pageSize": 20, "emptyText": "Select a Purpose...", "listeners": { "render": Lino.quicktip_renderer("Eigenschafts-Code","(cbss.ManageAccessRequests.purpose) The purpose for which the inscription needs to be \nregistered/unregistered or listed. \nFor listing this field is optional, \nfor register/unregister it is mandatory.") }, "selectOnFocus": true, "hiddenName": "purposeHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cbss/ManageAccessRequests/purpose", "method": "GET" }) }), "name": "purpose" });
    var query_register5009 = new Lino.ChoicesFieldElement({ "autoHeight": true, "forceSelection": true, "fieldLabel": "Query Register", "allowBlank": false, "hiddenName": "query_registerHidden", "listeners": { "render": Lino.quicktip_renderer("Abfrageregister","(cbss.ManageAccessRequests.query_register) ") }, "selectOnFocus": true, "anchor": "-20", "store": Lino.cbss.QueryRegister, "name": "query_register" });
    var p1_2_panel5010 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 62, "autoHeight": true, "layout": "form", "xtype": "panel", "items": purpose5008, "labelAlign": "top" }, { "flex": 37, "autoHeight": true, "layout": "form", "xtype": "panel", "items": query_register5009, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 162, "border": false, "anchor": "-20", "labelAlign": "top" });
    var p1_panel5013 = new Ext.form.FieldSet({ "autoHeight": true, "layout": "form", "title": "Requested action", "items": [ p1_1_panel5004, p1_2_panel5010 ], "frame": true, "bodyBorder": false, "autoScroll": false, "hideCheckBoxLabels": true, "border": false, "anchor": "-20", "labelAlign": "top" });
    var national_id5014 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">National ID</span>", "name": "national_id", "listeners": { "render": Lino.quicktip_renderer("NR-Nummer","(cbss.ManageAccessRequests.national_id) The SSIN of the person to register/unregister/list.\n") }, "maxLength": 200, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var sis_card_no5015 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">SIS card number</span>", "name": "sis_card_no", "boxMinWidth": Lino.chars2width(10), "listeners": { "render": Lino.quicktip_renderer("SIS-Karten-Nr","(cbss.ManageAccessRequests.sis_card_no) The number of the SIS card used to authenticate the person.") }, "maxLength": 10, "selectOnFocus": true, "anchor": "-20" });
    var id_card_no5016 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">ID card number</span>", "name": "id_card_no", "maxLength": 20, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("ID-Karten-Nr","(cbss.ManageAccessRequests.id_card_no) The number of the ID card used to authenticate the person.") }, "anchor": "-20" });
    var proof_1_panel5017 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 39, "autoHeight": true, "layout": "form", "xtype": "panel", "items": national_id5014, "labelAlign": "top" }, { "flex": 20, "autoHeight": true, "layout": "form", "xtype": "panel", "items": sis_card_no5015, "labelAlign": "top" }, { "flex": 39, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id_card_no5016, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 126, "border": false, "anchor": "-20", "labelAlign": "top" });
    var first_name5021 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "First name", "name": "first_name", "maxLength": 200, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Vorname","(cbss.ManageAccessRequests.first_name) ") }, "anchor": "-20" });
    var last_name5022 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Last name", "name": "last_name", "maxLength": 200, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Familienname","(cbss.ManageAccessRequests.last_name) ") }, "anchor": "-20" });
    var birth_date5023 = new Lino.IncompleteDateField({ "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Birth date</span>", "name": "birth_date", "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Geburtsdatum","(cbss.ManageAccessRequests.birth_date) Uncomplete dates are allowed, e.g. \n\"00.00.1980\" means \"some day in 1980\", \n\"00.07.1980\" means \"in July 1980\"\nor \"23.07.0000\" means \"on a 23th of July\".") }, "anchor": "-20" });
    var proof_2_panel5024 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 38, "autoHeight": true, "layout": "form", "xtype": "panel", "items": first_name5021, "labelAlign": "top" }, { "flex": 38, "autoHeight": true, "layout": "form", "xtype": "panel", "items": last_name5022, "labelAlign": "top" }, { "flex": 22, "autoHeight": true, "layout": "form", "xtype": "panel", "items": birth_date5023, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 117, "border": false, "anchor": "-20", "labelAlign": "top" });
    var proof_panel5028 = new Ext.form.FieldSet({ "autoHeight": true, "layout": "form", "title": "Proof of authentication", "items": [ proof_1_panel5017, proof_2_panel5024 ], "frame": true, "bodyBorder": false, "autoScroll": false, "hideCheckBoxLabels": true, "border": false, "anchor": "-20", "labelAlign": "top" });
    var main_panel5029 = new Ext.Panel({ "hideCheckBoxLabels": true, "autoHeight": true, "border": false, "layout": "form", "labelWidth": 63, "autoScroll": false, "items": [ { "autoHeight": true, "layout": "form", "xtype": "panel", "items": person5000, "anchor": "-20", "labelAlign": "top" }, p1_panel5013, proof_panel5028 ], "frame": true, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel5029;
    this.before_row_edit = function(record) {
      purpose5008.setContextValue('sector',record ? record.data['sectorHidden'] : undefined);
    }
    Lino.cbss.ManageAccessRequests.InsertFormPanel.superclass.initComponent.call(this);
    // active_fields:
    person5000.on("change",function(){this.save()},this);
  }
});


Lino.cbss.ManageAccessRequests.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 95,
  initComponent : function() {
    var containing_panel = this;
    var id4946 = new Ext.form.NumberField({ "autoHeight": true, "fieldLabel": "ID", "name": "id", "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("ID","(cbss.ManageAccessRequests.id) ") }, "anchor": "-20" });
    var person4947 = new Lino.TwinCombo({ "preferred_width": 20, "autoHeight": true, "fieldLabel": "Client", "allowBlank": false, "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.pcsw.Clients.detail)}, "emptyText": "Select a Client...", "listeners": { "render": Lino.quicktip_renderer("Klient","(cbss.ManageAccessRequests.person) ") }, "selectOnFocus": true, "hiddenName": "personHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cbss/ManageAccessRequests/person", "method": "GET" }) }), "name": "person" });
    var user4948 = new Lino.TwinCombo({ "preferred_width": 15, "autoHeight": true, "fieldLabel": "Author", "allowBlank": false, "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.users.Users.detail)}, "emptyText": "Select a User...", "listeners": { "render": Lino.quicktip_renderer("Autor","(cbss.ManageAccessRequests.user) ") }, "selectOnFocus": true, "hiddenName": "userHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cbss/ManageAccessRequests/user", "method": "GET" }) }), "name": "user" });
    var environment4949 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "T/A/B", "name": "environment", "boxMinWidth": Lino.chars2width(4), "disabled": true, "listeners": { "render": Lino.quicktip_renderer("T/A/B","(cbss.ManageAccessRequests.environment) ") }, "maxLength": 4, "anchor": "-20" });
    var sent4950 = new Ext.form.DisplayField({ "disabled": true, "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Sent</span>", "name": "sent", "listeners": { "render": Lino.quicktip_renderer("Versendet","(cbss.ManageAccessRequests.sent) The date and time when this request has been executed. \nThis is empty for requests than haven't been sent.\nRead-only.") }, "value": "<br>", "anchor": "-20" });
    var status4951 = new Lino.ChoicesFieldElement({ "autoHeight": true, "forceSelection": true, "fieldLabel": "State", "name": "status", "hiddenName": "statusHidden", "disabled": true, "listeners": { "render": Lino.quicktip_renderer("Zustand","(cbss.ManageAccessRequests.status) ") }, "anchor": "-20", "store": [['','<br>']].concat(Lino.cbss.RequestStates) });
    var ticket4952 = new Ext.form.TextField({ "disabled": true, "autoHeight": true, "fieldLabel": "Ticket", "name": "ticket", "maxLength": 36, "listeners": { "render": Lino.quicktip_renderer("Ticket","(cbss.ManageAccessRequests.ticket) ") }, "anchor": "-20" });
    var info_1_panel4953 = new Ext.form.FieldSet({ "autoHeight": true, "layout": "hbox", "title": "Request information", "layoutConfig": { "align": "stretchmax" }, "frame": false, "bodyBorder": true, "autoScroll": false, "items": [ { "flex": 5, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id4946, "labelAlign": "top" }, { "flex": 20, "autoHeight": true, "layout": "form", "xtype": "panel", "items": person4947, "labelAlign": "top" }, { "flex": 20, "autoHeight": true, "layout": "form", "xtype": "panel", "items": user4948, "labelAlign": "top" }, { "flex": 5, "autoHeight": true, "layout": "form", "xtype": "panel", "items": environment4949, "labelAlign": "top" }, { "flex": 16, "autoHeight": true, "layout": "form", "xtype": "panel", "items": sent4950, "labelAlign": "top" }, { "flex": 12, "autoHeight": true, "layout": "form", "xtype": "panel", "items": status4951, "labelAlign": "top" }, { "flex": 21, "autoHeight": true, "layout": "form", "xtype": "panel", "items": ticket4952, "labelAlign": "top" } ], "hideCheckBoxLabels": true, "labelWidth": 90, "border": false, "labelAlign": "top" });
    var action4961 = new Lino.ChoicesFieldElement({ "autoHeight": true, "forceSelection": true, "fieldLabel": "Action", "allowBlank": false, "hiddenName": "actionHidden", "listeners": { "render": Lino.quicktip_renderer("Aktion","(cbss.ManageAccessRequests.action) ") }, "selectOnFocus": true, "anchor": "-20", "store": Lino.cbss.ManageAction, "name": "action" });
    var start_date4962 = new Lino.DateField({ "autoHeight": true, "allowBlank": false, "fieldLabel": "Period from", "name": "start_date", "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Periode vom","(cbss.ManageAccessRequests.start_date) ") }, "anchor": "-20" });
    var end_date4963 = new Lino.DateField({ "autoHeight": true, "allowBlank": false, "fieldLabel": "Period until", "name": "end_date", "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Periode bis","(cbss.ManageAccessRequests.end_date) ") }, "anchor": "-20" });
    var p1_1_panel4964 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 44, "autoHeight": true, "layout": "form", "xtype": "panel", "items": action4961, "labelAlign": "top" }, { "flex": 27, "autoHeight": true, "layout": "form", "xtype": "panel", "items": start_date4962, "labelAlign": "top" }, { "flex": 27, "autoHeight": true, "layout": "form", "xtype": "panel", "items": end_date4963, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 108, "border": false, "anchor": "-20", "labelAlign": "top" });
    var purpose4968 = new Lino.RemoteComboFieldElement({ "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Purpose</span>", "allowBlank": false, "pageSize": 20, "emptyText": "Select a Purpose...", "listeners": { "render": Lino.quicktip_renderer("Eigenschafts-Code","(cbss.ManageAccessRequests.purpose) The purpose for which the inscription needs to be \nregistered/unregistered or listed. \nFor listing this field is optional, \nfor register/unregister it is mandatory.") }, "selectOnFocus": true, "hiddenName": "purposeHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cbss/ManageAccessRequests/purpose", "method": "GET" }) }), "name": "purpose" });
    var query_register4969 = new Lino.ChoicesFieldElement({ "autoHeight": true, "forceSelection": true, "fieldLabel": "Query Register", "allowBlank": false, "hiddenName": "query_registerHidden", "listeners": { "render": Lino.quicktip_renderer("Abfrageregister","(cbss.ManageAccessRequests.query_register) ") }, "selectOnFocus": true, "anchor": "-20", "store": Lino.cbss.QueryRegister, "name": "query_register" });
    var p1_2_panel4970 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 62, "autoHeight": true, "layout": "form", "xtype": "panel", "items": purpose4968, "labelAlign": "top" }, { "flex": 37, "autoHeight": true, "layout": "form", "xtype": "panel", "items": query_register4969, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 162, "border": false, "anchor": "-20", "labelAlign": "top" });
    var p1_panel4973 = new Ext.form.FieldSet({ "flex": 37, "autoHeight": true, "layout": "form", "title": "Requested action", "items": [ p1_1_panel4964, p1_2_panel4970 ], "frame": true, "bodyBorder": false, "autoScroll": false, "hideCheckBoxLabels": true, "border": false, "labelAlign": "top" });
    var national_id4974 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">National ID</span>", "name": "national_id", "listeners": { "render": Lino.quicktip_renderer("NR-Nummer","(cbss.ManageAccessRequests.national_id) The SSIN of the person to register/unregister/list.\n") }, "maxLength": 200, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var sis_card_no4975 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">SIS card number</span>", "name": "sis_card_no", "boxMinWidth": Lino.chars2width(10), "listeners": { "render": Lino.quicktip_renderer("SIS-Karten-Nr","(cbss.ManageAccessRequests.sis_card_no) The number of the SIS card used to authenticate the person.") }, "maxLength": 10, "selectOnFocus": true, "anchor": "-20" });
    var id_card_no4976 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">ID card number</span>", "name": "id_card_no", "maxLength": 20, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("ID-Karten-Nr","(cbss.ManageAccessRequests.id_card_no) The number of the ID card used to authenticate the person.") }, "anchor": "-20" });
    var proof_1_panel4977 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 39, "autoHeight": true, "layout": "form", "xtype": "panel", "items": national_id4974, "labelAlign": "top" }, { "flex": 20, "autoHeight": true, "layout": "form", "xtype": "panel", "items": sis_card_no4975, "labelAlign": "top" }, { "flex": 39, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id_card_no4976, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 126, "border": false, "anchor": "-20", "labelAlign": "top" });
    var first_name4981 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "First name", "name": "first_name", "maxLength": 200, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Vorname","(cbss.ManageAccessRequests.first_name) ") }, "anchor": "-20" });
    var last_name4982 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Last name", "name": "last_name", "maxLength": 200, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Familienname","(cbss.ManageAccessRequests.last_name) ") }, "anchor": "-20" });
    var birth_date4983 = new Lino.IncompleteDateField({ "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Birth date</span>", "name": "birth_date", "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Geburtsdatum","(cbss.ManageAccessRequests.birth_date) Uncomplete dates are allowed, e.g. \n\"00.00.1980\" means \"some day in 1980\", \n\"00.07.1980\" means \"in July 1980\"\nor \"23.07.0000\" means \"on a 23th of July\".") }, "anchor": "-20" });
    var proof_2_panel4984 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 38, "autoHeight": true, "layout": "form", "xtype": "panel", "items": first_name4981, "labelAlign": "top" }, { "flex": 38, "autoHeight": true, "layout": "form", "xtype": "panel", "items": last_name4982, "labelAlign": "top" }, { "flex": 22, "autoHeight": true, "layout": "form", "xtype": "panel", "items": birth_date4983, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 117, "border": false, "anchor": "-20", "labelAlign": "top" });
    var proof_panel4988 = new Ext.form.FieldSet({ "flex": 62, "autoHeight": true, "layout": "form", "title": "Proof of authentication", "items": [ proof_1_panel4977, proof_2_panel4984 ], "frame": true, "bodyBorder": false, "autoScroll": false, "hideCheckBoxLabels": true, "border": false, "labelAlign": "top" });
    var parameters_panel4989 = new Ext.form.FieldSet({ "autoHeight": true, "layout": "hbox", "title": "Parameters", "layoutConfig": { "align": "stretchmax" }, "frame": false, "bodyBorder": true, "autoScroll": false, "items": [ p1_panel4973, proof_panel4988 ], "hideCheckBoxLabels": true, "border": false, "labelAlign": "top" });
    var result_htmlbox4990 = new Lino.HtmlBoxPanel({ "flex": 50, "layout": "fit", "name": "result", "containing_panel": this, "items": new Ext.BoxComponent({autoScroll:true}), "title": "Result", "bodyStyle": "overflow-x:hidden;", "value": "<br/>", "always_enabled": true, "listeners": { "render": Lino.quicktip_renderer("Resultat","(cbss.ManageAccessRequests.result) ") } });
    var request_panel4991 = new Ext.Panel({ "layout": "vbox", "title": "Request", "items": [ info_1_panel4953, parameters_panel4989, result_htmlbox4990 ], "frame": true, "layoutConfig": { "align": "stretch" }, "hideCheckBoxLabels": true, "listeners": { "activate": Lino.on_tab_activate }, "autoScroll": false, "labelWidth": 81, "border": false, "bodyBorder": false, "labelAlign": "top" });
    var response_xml4992 = new Ext.form.TextArea({ "disabled": true, "listeners": { "render": Lino.quicktip_renderer("Antwort","(cbss.ManageAccessRequests.response_xml) The raw XML response received. \n") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Response</span>", "name": "response_xml", "growMax": 2000, "anchor": "-20 -10" });
    var info_messages4993 = new Ext.form.TextArea({ "disabled": true, "listeners": { "render": Lino.quicktip_renderer("Info-Meldungen","(cbss.ManageAccessRequests.info_messages) ") }, "fieldLabel": "Info messages", "name": "info_messages", "growMax": 2000, "anchor": "-20 -10" });
    var debug_messages4994 = new Ext.form.TextArea({ "disabled": true, "listeners": { "render": Lino.quicktip_renderer("Debug-Meldungen","(cbss.ManageAccessRequests.debug_messages) ") }, "fieldLabel": "Debug messages", "name": "debug_messages", "growMax": 2000, "anchor": "-20 -10" });
    var technical_panel4995 = new Lino.VBorderPanel({ "autoScroll": false, "listeners": { "activate": Lino.on_tab_activate }, "border": false, "labelWidth": 144, "title": "Technical", "hideCheckBoxLabels": true, "items": [ { "flex": 5, "layout": "form", "xtype": "panel", "items": response_xml4992, "region": "north", "labelAlign": "top", "split": true }, { "flex": 5, "layout": "form", "xtype": "panel", "items": info_messages4993, "region": "center", "labelAlign": "top", "split": true }, { "flex": 5, "layout": "form", "xtype": "panel", "items": debug_messages4994, "region": "south", "labelAlign": "top", "split": true } ], "frame": true, "bodyBorder": false, "labelAlign": "top" });
    var main_panel4999 = new Ext.TabPanel({ "hideCheckBoxLabels": true, "border": false, "split": true, "autoScroll": false, "items": [ request_panel4991, technical_panel4995 ], "activeTab": 0, "bodyBorder": false, "frame": true, "labelAlign": "top" });
    this.items = main_panel4999;
    this.before_row_edit = function(record) {
      purpose4968.setContextValue('sector',record ? record.data['sectorHidden'] : undefined);
      result_htmlbox4990.refresh();
    }
    Lino.cbss.ManageAccessRequests.DetailFormPanel.superclass.initComponent.call(this);
    // active_fields:
    person4947.on("change",function(){this.save()},this);
  }
});


Lino.households.Households.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 44,
  initComponent : function() {
    var containing_panel = this;
    var type542 = new Lino.TwinCombo({ "autoHeight": true, "fieldLabel": "Household Type", "name": "type", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.households.Types.detail)}, "emptyText": "Select a Household Type...", "listeners": { "render": Lino.quicktip_renderer("Haushaltsart","(households.Households.type) ") }, "selectOnFocus": true, "hiddenName": "typeHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/households/Households/type", "method": "GET" }) }) });
    var name543 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Name", "name": "name", "listeners": { "render": Lino.quicktip_renderer("Name","(households.Households.name) ") }, "maxLength": 200, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var language544 = new Lino.ChoicesFieldElement({ "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Language</span>", "allowBlank": false, "hiddenName": "languageHidden", "listeners": { "render": Lino.quicktip_renderer("Sprache","(households.Households.language) Die Sprache, in der Dokumente ausgestellt werden sollen.") }, "selectOnFocus": true, "anchor": "-20", "store": [ [ "en", "English" ], [ "fr", "French" ], [ "de", "German" ], [ "nl", "Dutch" ] ], "name": "language" });
    var id545 = new Ext.form.NumberField({ "autoHeight": true, "fieldLabel": "ID", "name": "id", "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("ID","(households.Households.id) ") }, "anchor": "-20" });
    var intro_box_1_panel546 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 117, "hideCheckBoxLabels": true, "items": [ { "flex": 35, "autoHeight": true, "layout": "form", "xtype": "panel", "items": type542, "labelAlign": "top" }, { "flex": 37, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name543, "labelAlign": "top" }, { "flex": 17, "autoHeight": true, "layout": "form", "xtype": "panel", "items": language544, "labelAlign": "top" }, { "flex": 8, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id545, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var country551 = new Lino.TwinCombo({ "autoHeight": true, "fieldLabel": "Country", "name": "country", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.countries.Countries.detail)}, "emptyText": "Select a Country...", "listeners": { "render": Lino.quicktip_renderer("Land","(households.Households.country) ") }, "selectOnFocus": true, "hiddenName": "countryHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/households/Households/country", "method": "GET" }) }) });
    var region552 = new Lino.TwinCombo({ "autoHeight": true, "fieldLabel": "Region", "name": "region", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.countries.Cities.detail)}, "emptyText": "Select a Place...", "listeners": { "render": Lino.quicktip_renderer("Region","(households.Households.region) ") }, "selectOnFocus": true, "hiddenName": "regionHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/households/Households/region", "method": "GET" }) }) });
    var box3_1_panel553 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": country551, "labelAlign": "top" }, { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": region552, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 63, "border": false, "anchor": "-20", "labelAlign": "top" });
    var city556 = new Lino.TwinCombo({ "autoHeight": true, "forceSelection": false, "fieldLabel": "Place", "name": "city", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.countries.Cities.detail)}, "emptyText": "Select a Place...", "listeners": { "render": Lino.quicktip_renderer("Ort","(households.Households.city) ") }, "selectOnFocus": true, "hiddenName": "cityHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/households/Households/city", "method": "GET" }) }) });
    var zip_code557 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Zip code", "name": "zip_code", "boxMinWidth": Lino.chars2width(10), "listeners": { "render": Lino.quicktip_renderer("Postleitzahl","(households.Households.zip_code) ") }, "maxLength": 10, "selectOnFocus": true, "anchor": "-20" });
    var box3_2_panel558 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 66, "autoHeight": true, "layout": "form", "xtype": "panel", "items": city556, "labelAlign": "top" }, { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": zip_code557, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 117, "border": false, "anchor": "-20", "labelAlign": "top" });
    var street_prefix561 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Street prefix</span>", "name": "street_prefix", "maxLength": 200, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Pr\u00e4fix Stra\u00dfe","(households.Households.street_prefix) Text to print before name of street, but to ignore for sorting.") }, "anchor": "-20" });
    var street562 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Street</span>", "name": "street", "maxLength": 200, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Stra\u00dfe","(households.Households.street) Name of street. Without house number.") }, "anchor": "-20" });
    var street_no563 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">No.</span>", "name": "street_no", "boxMinWidth": Lino.chars2width(10), "listeners": { "render": Lino.quicktip_renderer("Nr.","(households.Households.street_no) House number") }, "maxLength": 10, "selectOnFocus": true, "anchor": "-20" });
    var street_box564 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Box</span>", "name": "street_box", "boxMinWidth": Lino.chars2width(10), "listeners": { "render": Lino.quicktip_renderer("Box","(households.Households.street_box) Text to print after :attr:`steet_no` on the same line") }, "maxLength": 10, "selectOnFocus": true, "anchor": "-20" });
    var box3_3_panel565 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 30, "autoHeight": true, "layout": "form", "xtype": "panel", "items": street_prefix561, "labelAlign": "top" }, { "flex": 36, "autoHeight": true, "layout": "form", "xtype": "panel", "items": street562, "labelAlign": "top" }, { "flex": 16, "autoHeight": true, "layout": "form", "xtype": "panel", "items": street_no563, "labelAlign": "top" }, { "flex": 16, "autoHeight": true, "layout": "form", "xtype": "panel", "items": street_box564, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 126, "border": false, "anchor": "-20", "labelAlign": "top" });
    var addr2570 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Address line after street</span>", "name": "addr2", "maxLength": 200, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Adresszeile nach Stra\u00dfe","(households.Households.addr2) Address line to print below street line") }, "anchor": "-20" });
    var activity571 = new Lino.RemoteComboFieldElement({ "autoHeight": true, "fieldLabel": "activity", "name": "activity", "pageSize": 20, "emptyText": "Select a activity...", "listeners": { "render": Lino.quicktip_renderer("Beruf","(households.Households.activity) ") }, "selectOnFocus": true, "hiddenName": "activityHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/households/Households/activity", "method": "GET" }) }) });
    var bank_account1572 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Bank account 1", "name": "bank_account1", "maxLength": 40, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Bankkonto 1","(households.Households.bank_account1) ") }, "anchor": "-20" });
    var bank_account2573 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Bank account 2", "name": "bank_account2", "maxLength": 40, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Bankkonto 2","(households.Households.bank_account2) ") }, "anchor": "-20" });
    var box3_5_panel574 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 45, "autoHeight": true, "layout": "form", "xtype": "panel", "items": activity571, "labelAlign": "top" }, { "flex": 27, "autoHeight": true, "layout": "form", "xtype": "panel", "items": bank_account1572, "labelAlign": "top" }, { "flex": 27, "autoHeight": true, "layout": "form", "xtype": "panel", "items": bank_account2573, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 108, "border": false, "anchor": "-20", "labelAlign": "top" });
    var box3_panel578 = new Ext.Panel({ "flex": 62, "autoHeight": true, "layout": "form", "items": [ box3_1_panel553, box3_2_panel558, box3_3_panel565, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": addr2570, "anchor": "-20", "labelAlign": "top" }, box3_5_panel574 ], "frame": true, "bodyBorder": false, "autoScroll": false, "hideCheckBoxLabels": true, "labelWidth": 216, "border": false, "labelAlign": "top" });
    var email580 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "E-Mail", "name": "email", "maxLength": 75, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("E-Mail","(households.Households.email) ") }, "anchor": "-20" });
    var url581 = new Lino.URLField({ "autoHeight": true, "fieldLabel": "URL", "name": "url", "maxLength": 200, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("URL","(households.Households.url) ") }, "anchor": "-20" });
    var phone582 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Phone", "name": "phone", "maxLength": 200, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Telefon","(households.Households.phone) ") }, "anchor": "-20" });
    var gsm583 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "GSM", "name": "gsm", "maxLength": 200, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("GSM","(households.Households.gsm) ") }, "anchor": "-20" });
    var box4_panel584 = new Ext.Panel({ "flex": 37, "autoHeight": true, "layout": "form", "items": [ { "autoHeight": true, "layout": "form", "xtype": "panel", "items": email580, "anchor": "-20", "labelAlign": "top" }, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": url581, "anchor": "-20", "labelAlign": "top" }, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": phone582, "anchor": "-20", "labelAlign": "top" }, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": gsm583, "anchor": "-20", "labelAlign": "top" } ], "frame": true, "bodyBorder": false, "autoScroll": false, "hideCheckBoxLabels": true, "labelWidth": 72, "border": false, "labelAlign": "top" });
    var address_box_panel589 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "hideCheckBoxLabels": true, "items": [ box3_panel578, box4_panel584 ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var remarks590 = new Ext.form.TextArea({ "listeners": { "render": Lino.quicktip_renderer("Bemerkungen","(households.Households.remarks) ") }, "fieldLabel": "Remarks", "name": "remarks", "growMax": 2000, "selectOnFocus": true, "anchor": "-20 -10" });
    var households_MembersByHousehold_grid597 = new Lino.households.MembersByHousehold.GridPanel({ "flex": 50, "listeners": { "render": Lino.quicktip_renderer("Mitglieder","(households.households.MembersByHousehold) ") }, "hide_top_toolbar": true, "containing_panel": this, "tools": [ Lino.show_in_own_window_button(Lino.households.MembersByHousehold.grid) ], "preview_limit": 15, "master_panel": this });
    var bottom_box_panel598 = new Ext.Panel({ "flex": 45, "border": false, "layout": "hbox", "labelWidth": 108, "hideCheckBoxLabels": true, "items": [ { "items": remarks590, "labelAlign": "top", "layout": "form", "xtype": "panel", "flex": 49 }, households_MembersByHousehold_grid597 ], "autoScroll": false, "layoutConfig": { "align": "stretch" }, "frame": false, "labelAlign": "top" });
    var general_panel600 = new Ext.Panel({ "layout": "vbox", "title": "General", "items": [ intro_box_1_panel546, address_box_panel589, bottom_box_panel598 ], "frame": true, "layoutConfig": { "align": "stretch" }, "hideCheckBoxLabels": true, "listeners": { "activate": Lino.on_tab_activate }, "autoScroll": false, "border": false, "bodyBorder": false, "labelAlign": "top" });
    var debts_BudgetsByPartner_grid709 = new Lino.debts.BudgetsByPartner.GridPanel({ "flex": 5, "hide_top_toolbar": true, "containing_panel": this, "region": "north", "preview_limit": 15, "master_panel": this, "listeners": { "render": Lino.quicktip_renderer("Ist Hauptpartner in folgenden Budgets:","(debts.debts.BudgetsByPartner) ") }, "split": true, "tools": [ Lino.show_in_own_window_button(Lino.debts.BudgetsByPartner.grid) ] });
    var debts_ActorsByPartner_grid717 = new Lino.debts.ActorsByPartner.GridPanel({ "flex": 5, "hide_top_toolbar": true, "containing_panel": this, "region": "center", "preview_limit": 15, "master_panel": this, "listeners": { "render": Lino.quicktip_renderer("Ist Akteur in folgenden Budgets:","(debts.debts.ActorsByPartner) ") }, "split": true, "tools": [ Lino.show_in_own_window_button(Lino.debts.ActorsByPartner.grid) ] });
    var debts_panel718 = new Lino.VBorderPanel({ "autoScroll": false, "listeners": { "activate": Lino.on_tab_activate }, "border": false, "title": "Debts mediation", "hideCheckBoxLabels": true, "items": [ debts_BudgetsByPartner_grid709, debts_ActorsByPartner_grid717 ], "frame": true, "bodyBorder": false, "labelAlign": "top" });
    var main_panel719 = new Ext.TabPanel({ "hideCheckBoxLabels": true, "border": false, "split": true, "autoScroll": false, "items": [ general_panel600, debts_panel718 ], "activeTab": 0, "bodyBorder": false, "frame": true, "labelAlign": "top" });
    this.items = main_panel719;
    this.before_row_edit = function(record) {
      region552.setContextValue('country',record ? record.data['countryHidden'] : undefined);
      city556.setContextValue('country',record ? record.data['countryHidden'] : undefined);
      city556.setContextValue('region',record ? record.data['regionHidden'] : undefined);
      households_MembersByHousehold_grid597.on_master_changed();
      debts_BudgetsByPartner_grid709.on_master_changed();
      debts_ActorsByPartner_grid717.on_master_changed();
    }
    this.onRender = function(ct, position) {
      country551.on('change',Lino.chooser_handler(region552,'country'));
      country551.on('change',Lino.chooser_handler(city556,'country'));
      region552.on('change',Lino.chooser_handler(city556,'region'));
      Lino.households.Households.DetailFormPanel.superclass.onRender.call(this, ct, position);
    }
    Lino.households.Households.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.debts.Budgets.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 91,
  initComponent : function() {
    var containing_panel = this;
    var date610 = new Lino.DateField({ "autoHeight": true, "fieldLabel": "Date", "name": "date", "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Datum","(debts.Budgets.date) ") }, "anchor": "-20" });
    var partner611 = new Lino.TwinCombo({ "preferred_width": 20, "autoHeight": true, "fieldLabel": "Partner", "allowBlank": false, "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.contacts.Partners.detail)}, "emptyText": "Select a Partner...", "listeners": { "render": Lino.quicktip_renderer("Partner","(debts.Budgets.partner) ") }, "selectOnFocus": true, "hiddenName": "partnerHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/debts/Budgets/partner", "method": "GET" }) }), "name": "partner" });
    var id612 = new Ext.form.NumberField({ "autoHeight": true, "fieldLabel": "ID", "name": "id", "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("ID","(debts.Budgets.id) ") }, "anchor": "-20" });
    var user613 = new Lino.TwinCombo({ "preferred_width": 15, "autoHeight": true, "fieldLabel": "Author", "name": "user", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.users.Users.detail)}, "hiddenName": "userHidden", "listeners": { "render": Lino.quicktip_renderer("Autor","(debts.Budgets.user) ") }, "selectOnFocus": true, "emptyText": "Select a User...", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/debts/Budgets/user", "method": "GET" }) }) });
    var general_1_panel614 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 15, "autoHeight": true, "layout": "form", "xtype": "panel", "items": date610, "labelAlign": "top" }, { "flex": 37, "autoHeight": true, "layout": "form", "xtype": "panel", "items": partner611, "labelAlign": "top" }, { "flex": 9, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id612, "labelAlign": "top" }, { "flex": 37, "autoHeight": true, "layout": "form", "xtype": "panel", "items": user613, "labelAlign": "top" } ], "region": "north", "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "split": true, "autoScroll": false, "labelWidth": 72, "border": false, "frame": false, "labelAlign": "top" });
    var intro619 = new Lino.RichTextPanel({ "flex": 5, "split": true, "containing_panel": this, "selectOnFocus": true, "region": "center", "title": "Introduction", "name": "intro" });
    var ActorsByBudget_grid626 = new Lino.debts.ActorsByBudget.GridPanel({ "flex": 5, "hide_top_toolbar": true, "containing_panel": this, "region": "south", "preview_limit": 15, "master_panel": this, "listeners": { "render": Lino.quicktip_renderer("Budget-Akteure","(debts.debts.ActorsByBudget) To be filled if there is more than one person involved.") }, "split": true, "tools": [ Lino.show_in_own_window_button(Lino.debts.ActorsByBudget.grid) ] });
    var general_panel627 = new Lino.VBorderPanel({ "autoScroll": false, "listeners": { "activate": Lino.on_tab_activate }, "border": false, "labelWidth": 0, "title": "General", "hideCheckBoxLabels": true, "items": [ general_1_panel614, intro619, ActorsByBudget_grid626 ], "frame": true, "bodyBorder": false, "labelAlign": "top" });
    var ExpensesByBudget_grid639 = new Lino.debts.ExpensesByBudget.GridPanel({ "flex": 5, "hide_top_toolbar": true, "containing_panel": this, "region": "north", "preview_limit": 15, "master_panel": this, "listeners": { "render": Lino.quicktip_renderer("Ausgaben","(debts.debts.ExpensesByBudget) ") }, "split": true, "tools": [ Lino.show_in_own_window_button(Lino.debts.ExpensesByBudget.grid) ] });
    var IncomesByBudget_grid651 = new Lino.debts.IncomesByBudget.GridPanel({ "flex": 5, "hide_top_toolbar": true, "containing_panel": this, "region": "center", "preview_limit": 15, "master_panel": this, "listeners": { "render": Lino.quicktip_renderer("Eink\u00fcnfte","(debts.debts.IncomesByBudget) ") }, "split": true, "tools": [ Lino.show_in_own_window_button(Lino.debts.IncomesByBudget.grid) ] });
    var entries1_panel652 = new Lino.VBorderPanel({ "autoScroll": false, "listeners": { "activate": Lino.on_tab_activate }, "border": false, "title": "Expenses & Income", "hideCheckBoxLabels": true, "items": [ ExpensesByBudget_grid639, IncomesByBudget_grid651 ], "frame": true, "bodyBorder": false, "labelAlign": "top" });
    var LiabilitiesByBudget_grid666 = new Lino.debts.LiabilitiesByBudget.GridPanel({ "flex": 5, "hide_top_toolbar": true, "containing_panel": this, "region": "north", "preview_limit": 15, "master_panel": this, "listeners": { "render": Lino.quicktip_renderer("Verpflichtungen","(debts.debts.LiabilitiesByBudget) ") }, "split": true, "tools": [ Lino.show_in_own_window_button(Lino.debts.LiabilitiesByBudget.grid) ] });
    var AssetsByBudget_grid676 = new Lino.debts.AssetsByBudget.GridPanel({ "flex": 5, "hide_top_toolbar": true, "containing_panel": this, "region": "center", "preview_limit": 15, "master_panel": this, "listeners": { "render": Lino.quicktip_renderer("Verm\u00f6gen","(debts.debts.AssetsByBudget) ") }, "split": true, "tools": [ Lino.show_in_own_window_button(Lino.debts.AssetsByBudget.grid) ] });
    var entries2_panel677 = new Lino.VBorderPanel({ "autoScroll": false, "listeners": { "activate": Lino.on_tab_activate }, "border": false, "title": "Liabilities & Assets", "hideCheckBoxLabels": true, "items": [ LiabilitiesByBudget_grid666, AssetsByBudget_grid676 ], "frame": true, "bodyBorder": false, "labelAlign": "top" });
    var ResultByBudget_htmlbox678 = new Lino.HtmlBoxPanel({ "flex": 3, "layout": "fit", "name": "ResultByBudget", "containing_panel": this, "items": new Ext.BoxComponent({autoScroll:true}), "region": "north", "title": "Incomes & Expenses", "master_panel": this, "value": "<br/>", "always_enabled": true, "listeners": { "render": Lino.quicktip_renderer("Einnahmen & Ausgaben","(debts.Budgets.ResultByBudget) Shows the Incomes & Expenses for this budget.") }, "bodyStyle": "overflow-x:hidden;", "split": true, "tools": [ Lino.show_in_own_window_button(Lino.debts.ResultByBudget.grid) ] });
    var DebtsByBudget_htmlbox679 = new Lino.HtmlBoxPanel({ "flex": 3, "layout": "fit", "name": "DebtsByBudget", "containing_panel": this, "items": new Ext.BoxComponent({autoScroll:true}), "region": "center", "title": "Debts", "master_panel": this, "value": "<br/>", "always_enabled": true, "listeners": { "render": Lino.quicktip_renderer("Schulden","(debts.Budgets.DebtsByBudget) ") }, "bodyStyle": "overflow-x:hidden;", "split": true, "tools": [ Lino.show_in_own_window_button(Lino.debts.DebtsByBudget.grid) ] });
    var BailiffDebtsByBudget_htmlbox680 = new Lino.HtmlBoxPanel({ "flex": 3, "layout": "fit", "name": "BailiffDebtsByBudget", "containing_panel": this, "items": new Ext.BoxComponent({autoScroll:true}), "region": "south", "title": "Bailiff Debts", "master_panel": this, "value": "<br/>", "always_enabled": true, "listeners": { "render": Lino.quicktip_renderer("Schulden (Gerichtsvollzieher)","(debts.Budgets.BailiffDebtsByBudget) ") }, "bodyStyle": "overflow-x:hidden;", "split": true, "tools": [ Lino.show_in_own_window_button(Lino.debts.BailiffDebtsByBudget.grid) ] });
    var summary1_panel681 = new Lino.VBorderPanel({ "flex": 42, "border": false, "labelWidth": 270, "hideCheckBoxLabels": true, "items": [ ResultByBudget_htmlbox678, DebtsByBudget_htmlbox679, BailiffDebtsByBudget_htmlbox680 ], "frame": true, "autoScroll": false, "bodyBorder": false, "labelAlign": "top" });
    var conclusion682 = new Lino.RichTextPanel({ "selectOnFocus": true, "flex": 71, "containing_panel": this, "name": "conclusion", "title": "Conclusion" });
    var dist_amount683 = new Ext.form.NumberField({ "autoHeight": true, "decimalPrecision": 2, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Distributable amount</span>", "name": "dist_amount", "decimalSeparator": ",", "value": 120, "listeners": { "render": Lino.quicktip_renderer("Verteilbarer Betrag","(debts.Budgets.dist_amount) Der monatlich verf\u00fcgbare Gesamtbetrag f\u00fcr Tabelle Schuldenverteilung.") }, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var build_time684 = new Ext.form.DisplayField({ "disabled": true, "autoHeight": true, "fieldLabel": "build time", "name": "build_time", "listeners": { "render": Lino.quicktip_renderer("Druckdatum","(debts.Budgets.build_time) ") }, "value": "<br>", "anchor": "-20" });
    var summary2_2_panel685 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 180, "hideCheckBoxLabels": true, "items": [ { "flex": 42, "autoHeight": true, "layout": "form", "xtype": "panel", "items": dist_amount683, "labelAlign": "top" }, { "flex": 57, "autoHeight": true, "layout": "form", "xtype": "panel", "items": build_time684, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var include_yearly_incomes688 = new Ext.form.Checkbox({ "autoHeight": true, "hideLabel": true, "checked": false, "name": "include_yearly_incomes", "listeners": { "render": Lino.quicktip_renderer("J\u00e4hrliche Einkommen ber\u00fccksichtigen","(debts.Budgets.include_yearly_incomes) Check this to include yearly incomes in the Debts Overview table of this Budget.") }, "boxLabel": "Include yearly incomes", "selectOnFocus": true, "anchor": "-20" });
    var print_empty_rows689 = new Ext.form.Checkbox({ "autoHeight": true, "hideLabel": true, "checked": false, "name": "print_empty_rows", "listeners": { "render": Lino.quicktip_renderer("Auch leere Eintr\u00e4ge drucken","(debts.Budgets.print_empty_rows) Check this to print also empty rows for later completion.") }, "boxLabel": "Print empty rows", "selectOnFocus": true, "anchor": "-20" });
    var print_todos690 = new Ext.form.Checkbox({ "autoHeight": true, "hideLabel": true, "checked": false, "name": "print_todos", "listeners": { "render": Lino.quicktip_renderer("To-do-Liste drucken","(debts.Budgets.print_todos) Eintr\u00e4ge im Feld \"To-do\" werden nur ausgedruckt, \nwenn die Option \"To-dos drucken\" des Budgets angekreuzt ist. \nDiese Option wird aber momentan noch ignoriert \n(d.h. To-do-Liste wird gar nicht ausgedruckt), \nweil wir noch \u00fcberlegen m\u00fcssen, *wie* sie ausgedruckt werden sollen. \nVielleicht mit Fu\u00dfnoten?") }, "boxLabel": "Print to-do list", "selectOnFocus": true, "anchor": "-20" });
    var summary2_3_panel691 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 324, "hideCheckBoxLabels": true, "items": [ { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": include_yearly_incomes688, "labelAlign": "top" }, { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": print_empty_rows689, "labelAlign": "top" }, { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": print_todos690, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var summary2_panel695 = new Ext.Panel({ "flex": 57, "layout": "vbox", "items": [ conclusion682, summary2_2_panel685, summary2_3_panel691 ], "frame": true, "layoutConfig": { "align": "stretch" }, "autoScroll": false, "hideCheckBoxLabels": true, "labelWidth": 0, "border": false, "bodyBorder": false, "labelAlign": "top" });
    var summary_tab_1_panel696 = new Ext.Panel({ "flex": 9, "layout": "hbox", "items": [ summary1_panel681, summary2_panel695 ], "region": "north", "layoutConfig": { "align": "stretch" }, "hideCheckBoxLabels": true, "split": true, "autoScroll": false, "border": false, "frame": false, "labelAlign": "top" });
    var DistByBudget_htmlbox697 = new Lino.HtmlBoxPanel({ "flex": 3, "layout": "fit", "name": "DistByBudget", "containing_panel": this, "items": new Ext.BoxComponent({autoScroll:true}), "region": "center", "title": "Debts distribution", "master_panel": this, "value": "<br/>", "always_enabled": true, "listeners": { "render": Lino.quicktip_renderer("Schuldenverteilung","(debts.Budgets.DistByBudget) R\u00e9partition au marc-le-franc.\nTabelle mit einer Zeile pro Eintrag in \"Verpflichtungen\", dessen Option \"verteilen\" angekreuzt ist. \nDer verf\u00fcgbare Betrag wird dabei proportional zum geschuldeten Betrag aufgeteilt.\n") }, "bodyStyle": "overflow-x:hidden;", "split": true, "tools": [ Lino.show_in_own_window_button(Lino.debts.DistByBudget.grid) ] });
    var summary_tab_panel698 = new Lino.VBorderPanel({ "autoScroll": false, "listeners": { "activate": Lino.on_tab_activate }, "border": false, "labelWidth": 171, "title": "Summary", "hideCheckBoxLabels": true, "items": [ summary_tab_1_panel696, DistByBudget_htmlbox697 ], "frame": true, "bodyBorder": false, "labelAlign": "top" });
    var preview_htmlbox699 = new Lino.HtmlBoxPanel({ "layout": "fit", "name": "preview", "title": "Preview", "items": new Ext.BoxComponent({autoScroll:true}), "containing_panel": this, "bodyStyle": "overflow-x:hidden;", "value": "<br/>", "always_enabled": true, "listeners": { "activate": Lino.on_tab_activate } });
    var main_panel700 = new Ext.TabPanel({ "hideCheckBoxLabels": true, "border": false, "split": true, "autoScroll": false, "items": [ general_panel627, entries1_panel652, entries2_panel677, summary_tab_panel698, preview_htmlbox699 ], "activeTab": 0, "bodyBorder": false, "frame": true, "labelAlign": "top" });
    this.items = main_panel700;
    this.before_row_edit = function(record) {
      intro619.refresh();
      ActorsByBudget_grid626.on_master_changed();
      ExpensesByBudget_grid639.on_master_changed();
      IncomesByBudget_grid651.on_master_changed();
      LiabilitiesByBudget_grid666.on_master_changed();
      AssetsByBudget_grid676.on_master_changed();
      ResultByBudget_htmlbox678.refresh();
      DebtsByBudget_htmlbox679.refresh();
      BailiffDebtsByBudget_htmlbox680.refresh();
      conclusion682.refresh();
      DistByBudget_htmlbox697.refresh();
      preview_htmlbox699.refresh();
    }
    Lino.debts.Budgets.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.system.TextFieldTemplates.InsertFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  autoHeight: true,
  content_type: 2,
  initComponent : function() {
    var containing_panel = this;
    var name2913 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Designation", "name": "name", "listeners": { "render": Lino.quicktip_renderer("Bezeichnung","(system.TextFieldTemplates.name) ") }, "maxLength": 200, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var user2914 = new Lino.TwinCombo({ "preferred_width": 15, "autoHeight": true, "fieldLabel": "Author", "name": "user", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.users.Users.detail)}, "hiddenName": "userHidden", "listeners": { "render": Lino.quicktip_renderer("Autor","(system.TextFieldTemplates.user) ") }, "selectOnFocus": true, "emptyText": "Select a User...", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/system/TextFieldTemplates/user", "method": "GET" }) }) });
    var team2915 = new Lino.RemoteComboFieldElement({ "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Team</span>", "name": "team", "pageSize": 20, "emptyText": "Select a Team...", "listeners": { "render": Lino.quicktip_renderer("Team","(system.TextFieldTemplates.team) If not empty, then this template is reserved to members of this team.") }, "selectOnFocus": true, "hiddenName": "teamHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/system/TextFieldTemplates/team", "method": "GET" }) }) });
    var main_2_panel2916 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": user2914, "labelAlign": "top" }, { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": team2915, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 54, "border": false, "anchor": "-20", "labelAlign": "top" });
    var main_panel2919 = new Ext.Panel({ "hideCheckBoxLabels": true, "autoHeight": true, "border": false, "layout": "form", "labelWidth": 108, "autoScroll": false, "items": [ { "autoHeight": true, "layout": "form", "xtype": "panel", "items": name2913, "anchor": "-20", "labelAlign": "top" }, main_2_panel2916 ], "frame": true, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel2919;
    this.before_row_edit = function(record) {
    }
    Lino.system.TextFieldTemplates.InsertFormPanel.superclass.initComponent.call(this);
  }
});


Lino.debts.Budgets.InsertFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  autoHeight: true,
  content_type: 91,
  initComponent : function() {
    var containing_panel = this;
    var partner701 = new Lino.TwinCombo({ "preferred_width": 20, "autoHeight": true, "fieldLabel": "Partner", "allowBlank": false, "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.contacts.Partners.detail)}, "emptyText": "Select a Partner...", "listeners": { "render": Lino.quicktip_renderer("Partner","(debts.Budgets.partner) ") }, "selectOnFocus": true, "hiddenName": "partnerHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/debts/Budgets/partner", "method": "GET" }) }), "name": "partner" });
    var date702 = new Lino.DateField({ "autoHeight": true, "fieldLabel": "Date", "name": "date", "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Datum","(debts.Budgets.date) ") }, "anchor": "-20" });
    var user703 = new Lino.TwinCombo({ "preferred_width": 15, "autoHeight": true, "fieldLabel": "Author", "name": "user", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.users.Users.detail)}, "hiddenName": "userHidden", "listeners": { "render": Lino.quicktip_renderer("Autor","(debts.Budgets.user) ") }, "selectOnFocus": true, "emptyText": "Select a User...", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/debts/Budgets/user", "method": "GET" }) }) });
    var main_2_panel704 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 28, "autoHeight": true, "layout": "form", "xtype": "panel", "items": date702, "labelAlign": "top" }, { "flex": 71, "autoHeight": true, "layout": "form", "xtype": "panel", "items": user703, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 54, "border": false, "anchor": "-20", "labelAlign": "top" });
    var main_panel707 = new Ext.Panel({ "hideCheckBoxLabels": true, "autoHeight": true, "border": false, "layout": "form", "labelWidth": 72, "autoScroll": false, "items": [ { "autoHeight": true, "layout": "form", "xtype": "panel", "items": partner701, "anchor": "-20", "labelAlign": "top" }, main_2_panel704 ], "frame": true, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel707;
    this.before_row_edit = function(record) {
    }
    Lino.debts.Budgets.InsertFormPanel.superclass.initComponent.call(this);
  }
});


Lino.jobs.Jobs.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 76,
  initComponent : function() {
    var containing_panel = this;
    var name1274 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Name", "name": "name", "listeners": { "render": Lino.quicktip_renderer("Name","(jobs.Jobs.name) ") }, "maxLength": 100, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var provider1275 = new Lino.TwinCombo({ "preferred_width": 20, "autoHeight": true, "fieldLabel": "Job Provider", "name": "provider", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.jobs.JobProviders.detail)}, "hiddenName": "providerHidden", "listeners": { "render": Lino.quicktip_renderer("Stellenanbieter","(jobs.Jobs.provider) ") }, "selectOnFocus": true, "emptyText": "Select a Job Provider...", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/jobs/Jobs/provider", "method": "GET" }) }) });
    var contract_type1276 = new Lino.TwinCombo({ "preferred_width": 20, "autoHeight": true, "fieldLabel": "Contract Type", "name": "contract_type", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.jobs.ContractTypes.detail)}, "hiddenName": "contract_typeHidden", "listeners": { "render": Lino.quicktip_renderer("Vertragsart","(jobs.Jobs.contract_type) ") }, "selectOnFocus": true, "emptyText": "Select a Job Contract Type...", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/jobs/Jobs/contract_type", "method": "GET" }) }) });
    var type1277 = new Lino.TwinCombo({ "autoHeight": true, "fieldLabel": "Job Type", "name": "type", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.jobs.JobTypes.detail)}, "emptyText": "Select a Job Type...", "listeners": { "render": Lino.quicktip_renderer("Stellenart","(jobs.Jobs.type) ") }, "selectOnFocus": true, "hiddenName": "typeHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/jobs/Jobs/type", "method": "GET" }) }) });
    var id1278 = new Ext.form.NumberField({ "autoHeight": true, "fieldLabel": "ID", "name": "id", "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("ID","(jobs.Jobs.id) ") }, "anchor": "-20" });
    var main_1_panel1279 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 144, "hideCheckBoxLabels": true, "items": [ { "flex": 24, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name1274, "labelAlign": "top" }, { "flex": 23, "autoHeight": true, "layout": "form", "xtype": "panel", "items": provider1275, "labelAlign": "top" }, { "flex": 23, "autoHeight": true, "layout": "form", "xtype": "panel", "items": contract_type1276, "labelAlign": "top" }, { "flex": 23, "autoHeight": true, "layout": "form", "xtype": "panel", "items": type1277, "labelAlign": "top" }, { "flex": 5, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id1278, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var sector1285 = new Lino.TwinCombo({ "autoHeight": true, "fieldLabel": "Job Sector", "name": "sector", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.jobs.Sectors.detail)}, "emptyText": "Select a Job Sector...", "listeners": { "render": Lino.quicktip_renderer("Sektor","(jobs.Jobs.sector) ") }, "selectOnFocus": true, "hiddenName": "sectorHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/jobs/Jobs/sector", "method": "GET" }) }) });
    var function1286 = new Lino.TwinCombo({ "autoHeight": true, "fieldLabel": "Job Function", "name": "function", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.jobs.Functions.detail)}, "emptyText": "Select a Job Function...", "listeners": { "render": Lino.quicktip_renderer("Funktion","(jobs.Jobs.function) ") }, "selectOnFocus": true, "hiddenName": "functionHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/jobs/Jobs/function", "method": "GET" }) }) });
    var capacity1287 = new Ext.form.NumberField({ "autoHeight": true, "fieldLabel": "capacity", "name": "capacity", "value": 1, "listeners": { "render": Lino.quicktip_renderer("Kapazit\u00e4t","(jobs.Jobs.capacity) ") }, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var hourly_rate1288 = new Ext.form.NumberField({ "autoHeight": true, "decimalPrecision": 2, "fieldLabel": "hourly rate", "name": "hourly_rate", "decimalSeparator": ",", "listeners": { "render": Lino.quicktip_renderer("Stundensatz","(jobs.Jobs.hourly_rate) ") }, "selectOnFocus": true, "anchor": "-20", "allowBlank": true });
    var main_2_panel1289 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 108, "hideCheckBoxLabels": true, "items": [ { "flex": 35, "autoHeight": true, "layout": "form", "xtype": "panel", "items": sector1285, "labelAlign": "top" }, { "flex": 35, "autoHeight": true, "layout": "form", "xtype": "panel", "items": function1286, "labelAlign": "top" }, { "flex": 8, "autoHeight": true, "layout": "form", "xtype": "panel", "items": capacity1287, "labelAlign": "top" }, { "flex": 21, "autoHeight": true, "layout": "form", "xtype": "panel", "items": hourly_rate1288, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var remark1294 = new Ext.form.TextArea({ "listeners": { "render": Lino.quicktip_renderer("Bemerkung","(jobs.Jobs.remark) ") }, "fieldLabel": "Remark", "name": "remark", "growMax": 2000, "selectOnFocus": true, "anchor": "-20 -10" });
    var CandidaturesByJob_grid1303 = new Lino.jobs.CandidaturesByJob.GridPanel({ "flex": 66, "listeners": { "render": Lino.quicktip_renderer("Stellenanfragen","(jobs.jobs.CandidaturesByJob) ") }, "hide_top_toolbar": true, "containing_panel": this, "tools": [ Lino.show_in_own_window_button(Lino.jobs.CandidaturesByJob.grid) ], "preview_limit": 15, "master_panel": this });
    var main_3_panel1304 = new Ext.Panel({ "flex": 41, "border": false, "layout": "hbox", "labelWidth": 90, "hideCheckBoxLabels": true, "items": [ { "items": remark1294, "labelAlign": "top", "layout": "form", "xtype": "panel", "flex": 33 }, CandidaturesByJob_grid1303 ], "autoScroll": false, "layoutConfig": { "align": "stretch" }, "frame": false, "labelAlign": "top" });
    var ContractsByJob_grid1566 = new Lino.jobs.ContractsByJob.GridPanel({ "flex": 41, "hide_top_toolbar": true, "containing_panel": this, "params_panel_hidden": true, "master_panel": this, "preview_limit": 15, "listeners": { "render": Lino.quicktip_renderer("Art.60\u00a77-Konventionen","(jobs.jobs.ContractsByJob) ") }, "tools": [ Lino.show_in_own_window_button(Lino.jobs.ContractsByJob.grid) ] });
    var main_panel1567 = new Ext.Panel({ "autoScroll": false, "border": false, "layout": "vbox", "hideCheckBoxLabels": true, "items": [ main_1_panel1279, main_2_panel1289, main_3_panel1304, ContractsByJob_grid1566 ], "frame": true, "layoutConfig": { "align": "stretch" }, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel1567;
    this.before_row_edit = function(record) {
      function1286.setContextValue('sector',record ? record.data['sectorHidden'] : undefined);
      CandidaturesByJob_grid1303.on_master_changed();
      ContractsByJob_grid1566.on_master_changed();
    }
    this.onRender = function(ct, position) {
      sector1285.on('change',Lino.chooser_handler(function1286,'sector'));
      Lino.jobs.Jobs.DetailFormPanel.superclass.onRender.call(this, ct, position);
    }
    Lino.jobs.Jobs.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.pcsw.CoachingEndings.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 50,
  initComponent : function() {
    var containing_panel = this;
    var id3717 = new Ext.form.NumberField({ "autoHeight": true, "fieldLabel": "ID", "name": "id", "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("ID","(pcsw.CoachingEndings.id) ") }, "anchor": "-20" });
    var name3718 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Designation", "name": "name", "listeners": { "render": Lino.quicktip_renderer("Bezeichnung","(pcsw.CoachingEndings.name) ") }, "maxLength": 200, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var name_fr3719 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Designation (fr)", "name": "name_fr", "maxLength": 200, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Bezeichnung (fr)","(pcsw.CoachingEndings.name_fr) ") }, "anchor": "-20" });
    var name_de3720 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Designation (de)", "name": "name_de", "maxLength": 200, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Bezeichnung (de)","(pcsw.CoachingEndings.name_de) ") }, "anchor": "-20" });
    var name_nl3721 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Designation (nl)", "name": "name_nl", "listeners": { "render": Lino.quicktip_renderer("Bezeichnung (nl)","(pcsw.CoachingEndings.name_nl) ") }, "maxLength": 200, "selectOnFocus": true, "hidden": true, "anchor": "-20" });
    var seqno3722 = new Ext.form.NumberField({ "autoHeight": true, "fieldLabel": "Seq.No.", "name": "seqno", "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Seq.-Nr.","(pcsw.CoachingEndings.seqno) ") }, "anchor": "-20" });
    var main_1_panel3723 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 153, "hideCheckBoxLabels": true, "items": [ { "flex": 5, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id3717, "labelAlign": "top" }, { "flex": 22, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name3718, "labelAlign": "top" }, { "flex": 22, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_fr3719, "labelAlign": "top" }, { "flex": 22, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_de3720, "labelAlign": "top" }, { "flex": 22, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_nl3721, "hidden": true, "labelAlign": "top" }, { "flex": 5, "autoHeight": true, "layout": "form", "xtype": "panel", "items": seqno3722, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var CoachingsByEnding_grid3738 = new Lino.pcsw.CoachingsByEnding.GridPanel({ "flex": 83, "hide_top_toolbar": true, "containing_panel": this, "params_panel_hidden": true, "master_panel": this, "preview_limit": 15, "listeners": { "render": Lino.quicktip_renderer("Begleitungen","(pcsw.pcsw.CoachingsByEnding) ") }, "tools": [ Lino.show_in_own_window_button(Lino.pcsw.CoachingsByEnding.grid) ] });
    var main_panel3739 = new Ext.Panel({ "autoScroll": false, "border": false, "layout": "vbox", "hideCheckBoxLabels": true, "items": [ main_1_panel3723, CoachingsByEnding_grid3738 ], "frame": true, "layoutConfig": { "align": "stretch" }, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel3739;
    this.before_row_edit = function(record) {
      CoachingsByEnding_grid3738.on_master_changed();
    }
    Lino.pcsw.CoachingEndings.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.users.Users.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 12,
  initComponent : function() {
    var containing_panel = this;
    var username1987 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Username</span>", "name": "username", "listeners": { "render": Lino.quicktip_renderer("Benutzername","(users.Users.username) Required. Must be unique.") }, "maxLength": 30, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var profile1988 = new Lino.ChoicesFieldElement({ "autoHeight": true, "forceSelection": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">User Profile</span>", "name": "profile", "hiddenName": "profileHidden", "listeners": { "render": Lino.quicktip_renderer("Benutzerprofil","(users.Users.profile) Users with an empty `profile` field are considered inactive and cannot log in.") }, "selectOnFocus": true, "anchor": "-20", "store": [['','<br>']].concat(Lino.lino.UserProfiles) });
    var partner1989 = new Lino.TwinCombo({ "preferred_width": 20, "autoHeight": true, "fieldLabel": "Partner", "name": "partner", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.contacts.Partners.detail)}, "hiddenName": "partnerHidden", "listeners": { "render": Lino.quicktip_renderer("Partner","(users.Users.partner) ") }, "selectOnFocus": true, "emptyText": "Select a Partner...", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/users/Users/partner", "method": "GET" }) }) });
    var box1_1_panel1990 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 34, "autoHeight": true, "layout": "form", "xtype": "panel", "items": username1987, "labelAlign": "top" }, { "flex": 32, "autoHeight": true, "layout": "form", "xtype": "panel", "items": profile1988, "labelAlign": "top" }, { "flex": 32, "autoHeight": true, "layout": "form", "xtype": "panel", "items": partner1989, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 135, "border": false, "anchor": "-20", "labelAlign": "top" });
    var first_name1994 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "First name", "name": "first_name", "maxLength": 30, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Vorname","(users.Users.first_name) ") }, "anchor": "-20" });
    var last_name1995 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Last name", "name": "last_name", "maxLength": 30, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Familienname","(users.Users.last_name) ") }, "anchor": "-20" });
    var initials1996 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Initials", "name": "initials", "boxMinWidth": Lino.chars2width(10), "listeners": { "render": Lino.quicktip_renderer("Initialien","(users.Users.initials) ") }, "maxLength": 10, "selectOnFocus": true, "anchor": "-20" });
    var box1_2_panel1997 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 39, "autoHeight": true, "layout": "form", "xtype": "panel", "items": first_name1994, "labelAlign": "top" }, { "flex": 39, "autoHeight": true, "layout": "form", "xtype": "panel", "items": last_name1995, "labelAlign": "top" }, { "flex": 20, "autoHeight": true, "layout": "form", "xtype": "panel", "items": initials1996, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 117, "border": false, "anchor": "-20", "labelAlign": "top" });
    var email2001 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "e-mail address", "name": "email", "maxLength": 75, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("e-mail address","(users.Users.email) ") }, "anchor": "-20" });
    var language2002 = new Lino.ChoicesFieldElement({ "autoHeight": true, "fieldLabel": "Language", "name": "language", "hiddenName": "languageHidden", "listeners": { "render": Lino.quicktip_renderer("Sprache","(users.Users.language) ") }, "selectOnFocus": true, "anchor": "-20", "store": [ [ "en", "English" ], [ "fr", "French" ], [ "de", "German" ], [ "nl", "Dutch" ] ] });
    var box1_3_panel2003 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 51, "autoHeight": true, "layout": "form", "xtype": "panel", "items": email2001, "labelAlign": "top" }, { "flex": 48, "autoHeight": true, "layout": "form", "xtype": "panel", "items": language2002, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 135, "border": false, "anchor": "-20", "labelAlign": "top" });
    var id2006 = new Ext.form.NumberField({ "autoHeight": true, "fieldLabel": "ID", "name": "id", "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("ID","(users.Users.id) ") }, "anchor": "-20" });
    var created2007 = new Ext.form.DisplayField({ "disabled": true, "autoHeight": true, "fieldLabel": "Created", "name": "created", "listeners": { "render": Lino.quicktip_renderer("Erstellt","(users.Users.created) ") }, "value": "<br>", "anchor": "-20" });
    var modified2008 = new Ext.form.DisplayField({ "disabled": true, "autoHeight": true, "fieldLabel": "Modified", "name": "modified", "listeners": { "render": Lino.quicktip_renderer("Bearbeitet","(users.Users.modified) ") }, "value": "<br>", "anchor": "-20" });
    var box1_4_panel2009 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 13, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id2006, "labelAlign": "top" }, { "flex": 43, "autoHeight": true, "layout": "form", "xtype": "panel", "items": created2007, "labelAlign": "top" }, { "flex": 43, "autoHeight": true, "layout": "form", "xtype": "panel", "items": modified2008, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 99, "border": false, "anchor": "-20", "labelAlign": "top" });
    var box1_panel2013 = new Ext.Panel({ "flex": 66, "autoHeight": true, "border": false, "layout": "form", "hideCheckBoxLabels": true, "items": [ box1_1_panel1990, box1_2_panel1997, box1_3_panel2003, box1_4_panel2009 ], "frame": true, "autoScroll": false, "bodyBorder": false, "labelAlign": "top" });
    var MembershipsByUser_grid2016 = new Lino.users.MembershipsByUser.GridPanel({ "flex": 33, "hide_top_toolbar": true, "containing_panel": this, "preview_limit": 15, "master_panel": this, "listeners": { "render": Lino.quicktip_renderer("Meine Team-Mitglieder","(users.users.MembershipsByUser) ") }, "tools": [ Lino.show_in_own_window_button(Lino.users.MembershipsByUser.grid) ], "hideHeaders": true });
    var general_1_panel2017 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "hideCheckBoxLabels": true, "items": [ box1_panel2013, MembershipsByUser_grid2016 ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var remarks2018 = new Ext.form.TextArea({ "listeners": { "render": Lino.quicktip_renderer("Bemerkungen","(users.Users.remarks) ") }, "fieldLabel": "Remarks", "name": "remarks", "growMax": 2000, "selectOnFocus": true, "anchor": "-20 -10" });
    var AuthoritiesGiven_grid2021 = new Lino.users.AuthoritiesGiven.GridPanel({ "flex": 33, "hide_top_toolbar": true, "containing_panel": this, "preview_limit": 15, "master_panel": this, "listeners": { "render": Lino.quicktip_renderer("Erteilte Vollmachten","(users.users.AuthoritiesGiven) ") }, "tools": [ Lino.show_in_own_window_button(Lino.users.AuthoritiesGiven.grid) ], "hideHeaders": true });
    var general_2_panel2022 = new Ext.Panel({ "flex": 50, "border": false, "layout": "hbox", "labelWidth": 108, "hideCheckBoxLabels": true, "items": [ { "items": remarks2018, "labelAlign": "top", "layout": "form", "xtype": "panel", "flex": 66 }, AuthoritiesGiven_grid2021 ], "autoScroll": false, "layoutConfig": { "align": "stretch" }, "frame": false, "labelAlign": "top" });
    var general_panel2024 = new Ext.Panel({ "layout": "vbox", "title": "General", "items": [ general_1_panel2017, general_2_panel2022 ], "frame": true, "layoutConfig": { "align": "stretch" }, "hideCheckBoxLabels": true, "listeners": { "activate": Lino.on_tab_activate }, "autoScroll": false, "border": false, "bodyBorder": false, "labelAlign": "top" });
    var calendar2025 = new Lino.TwinCombo({ "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Default calendar</span>", "name": "calendar", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.cal.Calendars.detail)}, "emptyText": "Select a Calendar...", "listeners": { "render": Lino.quicktip_renderer("Standard-Kalender","(users.Users.calendar) The default calendar for your events and tasks.") }, "selectOnFocus": true, "hiddenName": "calendarHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/users/Users/calendar", "method": "GET" }) }) });
    var access_class2026 = new Lino.ChoicesFieldElement({ "autoHeight": true, "forceSelection": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Default access class</span>", "allowBlank": false, "hiddenName": "access_classHidden", "listeners": { "render": Lino.quicktip_renderer("Standardm\u00e4\u00dfige Zugriffsklasse","(users.Users.access_class) Die standardm\u00e4\u00dfige Zugriffsklasse f\u00fcr Ihre Termine und Aufgaben") }, "selectOnFocus": true, "anchor": "-20", "store": Lino.cal.AccessClasses, "name": "access_class" });
    var cal_left_1_panel2027 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 270, "hideCheckBoxLabels": true, "items": [ { "flex": 62, "autoHeight": true, "layout": "form", "xtype": "panel", "items": calendar2025, "labelAlign": "top" }, { "flex": 37, "autoHeight": true, "layout": "form", "xtype": "panel", "items": access_class2026, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var cal_SubscriptionsByUser_grid2034 = new Lino.cal.SubscriptionsByUser.GridPanel({ "flex": 83, "listeners": { "render": Lino.quicktip_renderer("Abonnements","(cal.cal.SubscriptionsByUser) ") }, "hide_top_toolbar": true, "containing_panel": this, "tools": [ Lino.show_in_own_window_button(Lino.cal.SubscriptionsByUser.grid) ], "preview_limit": 15, "master_panel": this });
    var cal_left_panel2035 = new Ext.Panel({ "flex": 33, "border": false, "layout": "vbox", "bodyBorder": false, "hideCheckBoxLabels": true, "items": [ cal_left_1_panel2027, cal_SubscriptionsByUser_grid2034 ], "autoScroll": false, "layoutConfig": { "align": "stretch" }, "frame": true, "labelAlign": "top" });
    var cal_TasksByUser_grid2057 = new Lino.cal.TasksByUser.GridPanel({ "flex": 66, "hide_top_toolbar": true, "containing_panel": this, "params_panel_hidden": true, "preview_limit": 15, "master_panel": this, "listeners": { "render": Lino.quicktip_renderer("Aufgaben","(cal.cal.TasksByUser) ") }, "tools": [ Lino.show_in_own_window_button(Lino.cal.TasksByUser.grid) ] });
    var cal_1_panel2058 = new Ext.Panel({ "autoScroll": false, "listeners": { "activate": Lino.on_tab_activate }, "border": false, "layout": "hbox", "title": "Calendar", "hideCheckBoxLabels": true, "items": [ cal_left_panel2035, cal_TasksByUser_grid2057 ], "frame": false, "layoutConfig": { "align": "stretch" }, "labelAlign": "top" });
    var newcomer_quota2059 = new Ext.form.NumberField({ "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Newcomers Quota</span>", "name": "newcomer_quota", "value": 0, "listeners": { "render": Lino.quicktip_renderer("Quote NZ","(users.Users.newcomer_quota) Wieviel Arbeitszeit dieser Benutzer f\u00fcr Neuantr\u00e4ge zur Verf\u00fcgung steht\n(100 = ganztags, 50 = halbtags, 0 = gar nicht).\nWenn zwei Benutzer die gleiche Belastungspunktzahl haben, \naber einer davon sich nur zu 50% um Neuantr\u00e4ge k\u00fcmmert, \ngilt er als doppelt so belastet wie sein Kollege.\n") }, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var coaching_type2060 = new Lino.RemoteComboFieldElement({ "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Coaching type</span>", "name": "coaching_type", "pageSize": 20, "emptyText": "Select a Coaching type...", "listeners": { "render": Lino.quicktip_renderer("Dienst","(users.Users.coaching_type) The default CoachingType used when creating Coachings.") }, "selectOnFocus": true, "hiddenName": "coaching_typeHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/users/Users/coaching_type", "method": "GET" }) }) });
    var coaching_supervisor2061 = new Ext.form.Checkbox({ "autoHeight": true, "hideLabel": true, "checked": false, "name": "coaching_supervisor", "listeners": { "render": Lino.quicktip_renderer("Benachrichtigung wenn ein Begleiter zugewiesen wird","(users.Users.coaching_supervisor) Wenn ein Neuantrag einem Begleiter zugewiesen wurde, wird au\u00dfer dem Begleiter auch dieser Benutzer benachrichtigt.") }, "boxLabel": "Notify me when a coach has been assigned", "selectOnFocus": true, "anchor": "-20" });
    var newcomers_CompetencesByUser_grid2067 = new Lino.newcomers.CompetencesByUser.GridPanel({ "flex": 62, "listeners": { "render": Lino.quicktip_renderer("Kompetenzen","(newcomers.newcomers.CompetencesByUser) ") }, "hide_top_toolbar": true, "containing_panel": this, "tools": [ Lino.show_in_own_window_button(Lino.newcomers.CompetencesByUser.grid) ], "preview_limit": 15, "master_panel": this });
    var coaching_a_panel2068 = new Ext.Panel({ "flex": 33, "layout": "vbox", "items": [ { "items": newcomer_quota2059, "autoHeight": true, "layout": "form", "xtype": "panel", "labelAlign": "top" }, { "items": coaching_type2060, "autoHeight": true, "layout": "form", "xtype": "panel", "labelAlign": "top" }, { "items": coaching_supervisor2061, "autoHeight": true, "layout": "form", "xtype": "panel", "labelAlign": "top" }, newcomers_CompetencesByUser_grid2067 ], "frame": true, "layoutConfig": { "align": "stretch" }, "autoScroll": false, "hideCheckBoxLabels": true, "labelWidth": 468, "border": false, "bodyBorder": false, "labelAlign": "top" });
    var pcsw_CoachingsByUser_grid2079 = new Lino.pcsw.CoachingsByUser.GridPanel({ "flex": 66, "hide_top_toolbar": true, "containing_panel": this, "params_panel_hidden": true, "preview_limit": 15, "master_panel": this, "listeners": { "render": Lino.quicktip_renderer("Begleitungen","(pcsw.pcsw.CoachingsByUser) ") }, "tools": [ Lino.show_in_own_window_button(Lino.pcsw.CoachingsByUser.grid) ] });
    var coaching_1_panel2080 = new Ext.Panel({ "autoScroll": false, "listeners": { "activate": Lino.on_tab_activate }, "border": false, "layout": "hbox", "title": "Coaching", "hideCheckBoxLabels": true, "items": [ coaching_a_panel2068, pcsw_CoachingsByUser_grid2079 ], "frame": false, "layoutConfig": { "align": "stretch" }, "labelAlign": "top" });
    var main_panel2081 = new Ext.TabPanel({ "hideCheckBoxLabels": true, "border": false, "split": true, "autoScroll": false, "items": [ general_panel2024, cal_1_panel2058, coaching_1_panel2080 ], "activeTab": 0, "bodyBorder": false, "frame": true, "labelAlign": "top" });
    this.items = main_panel2081;
    this.before_row_edit = function(record) {
      MembershipsByUser_grid2016.on_master_changed();
      AuthoritiesGiven_grid2021.on_master_changed();
      cal_SubscriptionsByUser_grid2034.on_master_changed();
      cal_TasksByUser_grid2057.on_master_changed();
      newcomers_CompetencesByUser_grid2067.on_master_changed();
      pcsw_CoachingsByUser_grid2079.on_master_changed();
    }
    Lino.users.Users.DetailFormPanel.superclass.initComponent.call(this);
    // active_fields:
    partner1989.on("change",function(){this.save()},this);
  }
});


Lino.cal.Calendars.InsertFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  autoHeight: true,
  content_type: 38,
  initComponent : function() {
    var containing_panel = this;
    var name3525 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Designation", "name": "name", "listeners": { "render": Lino.quicktip_renderer("Bezeichnung","(cal.Calendars.name) ") }, "maxLength": 200, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var name_fr3526 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Designation (fr)", "name": "name_fr", "maxLength": 200, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Bezeichnung (fr)","(cal.Calendars.name_fr) ") }, "anchor": "-20" });
    var name_de3527 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Designation (de)", "name": "name_de", "maxLength": 200, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Bezeichnung (de)","(cal.Calendars.name_de) ") }, "anchor": "-20" });
    var name_nl3528 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Designation (nl)", "name": "name_nl", "listeners": { "render": Lino.quicktip_renderer("Bezeichnung (nl)","(cal.Calendars.name_nl) ") }, "maxLength": 200, "selectOnFocus": true, "hidden": true, "anchor": "-20" });
    var main_1_panel3529 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 25, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name3525, "labelAlign": "top" }, { "flex": 25, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_fr3526, "labelAlign": "top" }, { "flex": 25, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_de3527, "labelAlign": "top" }, { "flex": 25, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_nl3528, "hidden": true, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 153, "border": false, "anchor": "-20", "labelAlign": "top" });
    var type3534 = new Lino.ChoicesFieldElement({ "autoHeight": true, "fieldLabel": "Type", "allowBlank": false, "value": "local", "hiddenName": "typeHidden", "listeners": { "render": Lino.quicktip_renderer("Art","(cal.Calendars.type) ") }, "selectOnFocus": true, "anchor": "-20", "store": [ [ "local", "Local Calendar" ], [ "google", "Google Calendar" ] ], "name": "type" });
    var invite_team_members3535 = new Lino.RemoteComboFieldElement({ "autoHeight": true, "fieldLabel": "Team", "name": "invite_team_members", "pageSize": 20, "emptyText": "Select a Team...", "listeners": { "render": Lino.quicktip_renderer("Team","(cal.Calendars.invite_team_members) ") }, "selectOnFocus": true, "hiddenName": "invite_team_membersHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/Calendars/invite_team_members", "method": "GET" }) }) });
    var color3536 = new Ext.form.NumberField({ "autoHeight": true, "fieldLabel": "color", "name": "color", "value": 1, "listeners": { "render": Lino.quicktip_renderer("Farbe","(cal.Calendars.color) ") }, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var main_2_panel3537 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 44, "autoHeight": true, "layout": "form", "xtype": "panel", "items": type3534, "labelAlign": "top" }, { "flex": 44, "autoHeight": true, "layout": "form", "xtype": "panel", "items": invite_team_members3535, "labelAlign": "top" }, { "flex": 11, "autoHeight": true, "layout": "form", "xtype": "panel", "items": color3536, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 54, "border": false, "anchor": "-20", "labelAlign": "top" });
    var invite_client3541 = new Ext.form.Checkbox({ "autoHeight": true, "hideLabel": true, "checked": false, "name": "invite_client", "listeners": { "render": Lino.quicktip_renderer("Klient einladen","(cal.Calendars.invite_client) ") }, "boxLabel": "Invite client", "selectOnFocus": true, "anchor": "-20" });
    var main_panel3542 = new Ext.Panel({ "hideCheckBoxLabels": true, "autoHeight": true, "border": false, "layout": "form", "labelWidth": 144, "autoScroll": false, "items": [ main_1_panel3529, main_2_panel3537, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": invite_client3541, "anchor": "-20", "labelAlign": "top" } ], "frame": true, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel3542;
    this.before_row_edit = function(record) {
    }
    Lino.cal.Calendars.InsertFormPanel.superclass.initComponent.call(this);
  }
});


Lino.about.Models.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  disable_editing: true,
  initComponent : function() {
    var containing_panel = this;
    var app_disp5101 = new Ext.form.DisplayField({ "autoHeight": true, "fieldLabel": "app_label", "name": "app", "value": "<br/>", "always_enabled": true, "disabled": true, "listeners": { "render": Lino.quicktip_renderer("app_label","(about.Models.app) ") }, "anchor": "-20" });
    var name_disp5102 = new Ext.form.DisplayField({ "autoHeight": true, "fieldLabel": "name", "name": "name", "value": "<br/>", "always_enabled": true, "disabled": true, "listeners": { "render": Lino.quicktip_renderer("name","(about.Models.name) ") }, "anchor": "-20" });
    var docstring_disp5103 = new Ext.form.DisplayField({ "autoHeight": true, "fieldLabel": "docstring", "name": "docstring", "value": "<br/>", "always_enabled": true, "disabled": true, "listeners": { "render": Lino.quicktip_renderer("docstring","(about.Models.docstring) ") }, "anchor": "-20" });
    var rows5104 = new Ext.form.NumberField({ "disabled": true, "autoHeight": true, "fieldLabel": "Rows", "name": "rows", "listeners": { "render": Lino.quicktip_renderer("Rows","(about.Models.rows) ") }, "anchor": "-20" });
    var main_1_panel5105 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 90, "hideCheckBoxLabels": true, "items": [ { "flex": 31, "autoHeight": true, "layout": "form", "xtype": "panel", "items": app_disp5101, "labelAlign": "top" }, { "flex": 31, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_disp5102, "labelAlign": "top" }, { "flex": 31, "autoHeight": true, "layout": "form", "xtype": "panel", "items": docstring_disp5103, "labelAlign": "top" }, { "flex": 5, "autoHeight": true, "layout": "form", "xtype": "panel", "items": rows5104, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var about_FieldsByModel_grid5114 = new Lino.about.FieldsByModel.GridPanel({ "flex": 62, "listeners": { "render": Lino.quicktip_renderer("Fields","(about.about.FieldsByModel) ") }, "hide_top_toolbar": true, "containing_panel": this, "tools": [ Lino.show_in_own_window_button(Lino.about.FieldsByModel.grid) ], "preview_limit": 15, "master_panel": this });
    var main_panel5115 = new Ext.Panel({ "autoScroll": false, "border": false, "layout": "vbox", "hideCheckBoxLabels": true, "items": [ main_1_panel5105, about_FieldsByModel_grid5114 ], "frame": true, "layoutConfig": { "align": "stretch" }, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel5115;
    this.before_row_edit = function(record) {
      about_FieldsByModel_grid5114.on_master_changed();
    }
    Lino.about.Models.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.cal.Tasks.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 34,
  initComponent : function() {
    var containing_panel = this;
    var start_date295 = new Lino.DateField({ "autoHeight": true, "fieldLabel": "Start date", "name": "start_date", "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Beginnt am","(cal.Tasks.start_date) ") }, "anchor": "-20" });
    var due_date296 = new Lino.DateField({ "autoHeight": true, "fieldLabel": "Due date", "name": "due_date", "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Zahlungsziel","(cal.Tasks.due_date) ") }, "anchor": "-20" });
    var id297 = new Ext.form.NumberField({ "autoHeight": true, "fieldLabel": "ID", "name": "id", "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("ID","(cal.Tasks.id) ") }, "anchor": "-20" });
    var workflow_buttons_disp298 = new Ext.form.DisplayField({ "autoHeight": true, "fieldLabel": "Workflow", "name": "workflow_buttons", "value": "<br/>", "always_enabled": true, "disabled": true, "listeners": { "render": Lino.quicktip_renderer("Arbeitsablauf","(cal.Tasks.workflow_buttons) ") }, "anchor": "-20" });
    var main_1_panel299 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 126, "hideCheckBoxLabels": true, "items": [ { "flex": 15, "autoHeight": true, "layout": "form", "xtype": "panel", "items": start_date295, "labelAlign": "top" }, { "flex": 15, "autoHeight": true, "layout": "form", "xtype": "panel", "items": due_date296, "labelAlign": "top" }, { "flex": 9, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id297, "labelAlign": "top" }, { "flex": 58, "autoHeight": true, "layout": "form", "xtype": "panel", "items": workflow_buttons_disp298, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var summary304 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Summary", "name": "summary", "maxLength": 200, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Kurzbeschreibung","(cal.Tasks.summary) ") }, "anchor": "-20" });
    var user305 = new Lino.TwinCombo({ "preferred_width": 15, "autoHeight": true, "fieldLabel": "Author", "name": "user", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.users.Users.detail)}, "hiddenName": "userHidden", "listeners": { "render": Lino.quicktip_renderer("Autor","(cal.Tasks.user) ") }, "selectOnFocus": true, "emptyText": "Select a User...", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/Tasks/user", "method": "GET" }) }) });
    var project306 = new Lino.TwinCombo({ "preferred_width": 20, "autoHeight": true, "fieldLabel": "Client", "name": "project", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.pcsw.Clients.detail)}, "hiddenName": "projectHidden", "listeners": { "render": Lino.quicktip_renderer("Klient","(cal.Tasks.project) ") }, "selectOnFocus": true, "emptyText": "Select a Client...", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/Tasks/project", "method": "GET" }) }) });
    var main_3_panel307 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 63, "hideCheckBoxLabels": true, "items": [ { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": user305, "labelAlign": "top" }, { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": project306, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var calendar310 = new Lino.TwinCombo({ "autoHeight": true, "fieldLabel": "Calendar", "name": "calendar", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.cal.Calendars.detail)}, "emptyText": "Select a Calendar...", "listeners": { "render": Lino.quicktip_renderer("Kalender","(cal.Tasks.calendar) ") }, "selectOnFocus": true, "hiddenName": "calendarHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/Tasks/calendar", "method": "GET" }) }) });
    var owner_disp311 = new Ext.form.DisplayField({ "disabled": true, "autoHeight": true, "fieldLabel": "Controlled by", "anchor": "-20", "name": "owner" });
    var created312 = new Ext.form.DisplayField({ "disabled": true, "autoHeight": true, "fieldLabel": "Created", "name": "created", "listeners": { "render": Lino.quicktip_renderer("Erstellt","(cal.Tasks.created) ") }, "value": "<br>", "anchor": "-20" });
    var modified313 = new Ext.form.DisplayField({ "disabled": true, "autoHeight": true, "fieldLabel": "Modified", "name": "modified", "listeners": { "render": Lino.quicktip_renderer("Bearbeitet","(cal.Tasks.modified) ") }, "value": "<br>", "anchor": "-20" });
    var main_4_panel314 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 126, "hideCheckBoxLabels": true, "items": [ { "flex": 28, "autoHeight": true, "layout": "form", "xtype": "panel", "items": calendar310, "labelAlign": "top" }, { "flex": 14, "autoHeight": true, "layout": "form", "xtype": "panel", "items": owner_disp311, "labelAlign": "top" }, { "flex": 28, "autoHeight": true, "layout": "form", "xtype": "panel", "items": created312, "labelAlign": "top" }, { "flex": 28, "autoHeight": true, "layout": "form", "xtype": "panel", "items": modified313, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var description319 = new Lino.RichTextPanel({ "selectOnFocus": true, "flex": 45, "containing_panel": this, "name": "description", "title": "Description" });
    var main_panel320 = new Ext.Panel({ "autoScroll": false, "border": false, "layout": "vbox", "labelWidth": 153, "hideCheckBoxLabels": true, "items": [ main_1_panel299, { "items": summary304, "autoHeight": true, "layout": "form", "xtype": "panel", "labelAlign": "top" }, main_3_panel307, main_4_panel314, description319 ], "frame": true, "layoutConfig": { "align": "stretch" }, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel320;
    this.before_row_edit = function(record) {
      description319.refresh();
    }
    Lino.cal.Tasks.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.jobs.JobTypes.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 80,
  initComponent : function() {
    var containing_panel = this;
    var id4069 = new Ext.form.NumberField({ "autoHeight": true, "fieldLabel": "ID", "name": "id", "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("ID","(jobs.JobTypes.id) ") }, "anchor": "-20" });
    var name4070 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Designation", "name": "name", "maxLength": 200, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Bezeichnung","(jobs.JobTypes.name) ") }, "anchor": "-20" });
    var main_1_panel4071 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 108, "hideCheckBoxLabels": true, "items": [ { "flex": 19, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id4069, "labelAlign": "top" }, { "flex": 80, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name4070, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var JobsByType_grid4084 = new Lino.jobs.JobsByType.GridPanel({ "flex": 83, "listeners": { "render": Lino.quicktip_renderer("Stellen","(jobs.jobs.JobsByType) ") }, "hide_top_toolbar": true, "containing_panel": this, "tools": [ Lino.show_in_own_window_button(Lino.jobs.JobsByType.grid) ], "preview_limit": 15, "master_panel": this });
    var main_panel4085 = new Ext.Panel({ "autoScroll": false, "border": false, "layout": "vbox", "hideCheckBoxLabels": true, "items": [ main_1_panel4071, JobsByType_grid4084 ], "frame": true, "layoutConfig": { "align": "stretch" }, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel4085;
    this.before_row_edit = function(record) {
      JobsByType_grid4084.on_master_changed();
    }
    Lino.jobs.JobTypes.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.jobs.OldJobsOverview.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  disable_editing: true,
  initComponent : function() {
    var containing_panel = this;
    var body_htmlbox5124 = new Lino.HtmlBoxPanel({ "layout": "fit", "name": "body", "containing_panel": this, "items": new Ext.BoxComponent({autoScroll:true}), "bodyStyle": "overflow-x:hidden;", "value": "<br/>", "always_enabled": true, "listeners": { "render": Lino.quicktip_renderer(null,"(jobs.OldJobsOverview.body) ") } });
    var main_panel5125 = new Ext.Panel({ "autoScroll": false, "border": false, "layout": "fit", "labelWidth": 0, "hideCheckBoxLabels": true, "items": [ body_htmlbox5124 ], "frame": true, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel5125;
    this.before_row_edit = function(record) {
      body_htmlbox5124.refresh();
    }
    Lino.jobs.OldJobsOverview.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.cbss.IdentifyPersonRequests.InsertFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  autoHeight: true,
  content_type: 97,
  initComponent : function() {
    var containing_panel = this;
    var person4901 = new Lino.TwinCombo({ "preferred_width": 20, "autoHeight": true, "fieldLabel": "Client", "allowBlank": false, "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.pcsw.Clients.detail)}, "emptyText": "Select a Client...", "listeners": { "render": Lino.quicktip_renderer("Klient","(cbss.IdentifyPersonRequests.person) ") }, "selectOnFocus": true, "hiddenName": "personHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cbss/IdentifyPersonRequests/person", "method": "GET" }) }), "name": "person" });
    var national_id4902 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "National ID", "name": "national_id", "maxLength": 200, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("NR-Nummer","(cbss.IdentifyPersonRequests.national_id) ") }, "anchor": "-20" });
    var main_1_panel4903 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 48, "autoHeight": true, "layout": "form", "xtype": "panel", "items": person4901, "labelAlign": "top" }, { "flex": 51, "autoHeight": true, "layout": "form", "xtype": "panel", "items": national_id4902, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 90, "border": false, "anchor": "-20", "labelAlign": "top" });
    var first_name4906 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "First name", "name": "first_name", "maxLength": 200, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Vorname","(cbss.IdentifyPersonRequests.first_name) ") }, "anchor": "-20" });
    var middle_name4907 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Middle name</span>", "name": "middle_name", "maxLength": 200, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Mittelnamen","(cbss.IdentifyPersonRequests.middle_name) Whatever this means...") }, "anchor": "-20" });
    var last_name4908 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Last name", "name": "last_name", "maxLength": 200, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Familienname","(cbss.IdentifyPersonRequests.last_name) ") }, "anchor": "-20" });
    var p2_1_panel4909 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": first_name4906, "labelAlign": "top" }, { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": middle_name4907, "labelAlign": "top" }, { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": last_name4908, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 117, "border": false, "anchor": "-20", "labelAlign": "top" });
    var birth_date4913 = new Lino.IncompleteDateField({ "autoHeight": true, "allowBlank": false, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Birth date</span>", "name": "birth_date", "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Geburtsdatum","(cbss.IdentifyPersonRequests.birth_date) Uncomplete dates are allowed, e.g. \n\"00.00.1980\" means \"some day in 1980\", \n\"00.07.1980\" means \"in July 1980\"\nor \"23.07.0000\" means \"on a 23th of July\".") }, "anchor": "-20" });
    var tolerance4914 = new Ext.form.NumberField({ "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Tolerance</span>", "name": "tolerance", "value": 0, "listeners": { "render": Lino.quicktip_renderer("Toleranz","(cbss.IdentifyPersonRequests.tolerance) \n      Falls Monat oder Tag des Geburtsdatums unbekannt sind, \n      um wieviel Monate bzw. Tage die Suche nach unten/oben ausgeweitet wird.\n      G\u00fcltige Werte: 0 bis 10.\n      ") }, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var gender4915 = new Lino.ChoicesFieldElement({ "autoHeight": true, "forceSelection": true, "fieldLabel": "Gender", "name": "gender", "hiddenName": "genderHidden", "listeners": { "render": Lino.quicktip_renderer("Geschlecht","(cbss.IdentifyPersonRequests.gender) ") }, "selectOnFocus": true, "anchor": "-20", "store": [['','<br>']].concat(Lino.lino.Genders) });
    var p2_2_panel4916 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 46, "autoHeight": true, "layout": "form", "xtype": "panel", "items": birth_date4913, "labelAlign": "top" }, { "flex": 19, "autoHeight": true, "layout": "form", "xtype": "panel", "items": tolerance4914, "labelAlign": "top" }, { "flex": 34, "autoHeight": true, "layout": "form", "xtype": "panel", "items": gender4915, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 117, "border": false, "anchor": "-20", "labelAlign": "top" });
    var p2_panel4920 = new Ext.form.FieldSet({ "autoHeight": true, "layout": "form", "title": "Phonetic search", "items": [ p2_1_panel4909, p2_2_panel4916 ], "frame": true, "bodyBorder": false, "autoScroll": false, "hideCheckBoxLabels": true, "border": false, "anchor": "-20", "labelAlign": "top" });
    var main_panel4921 = new Ext.Panel({ "hideCheckBoxLabels": true, "autoHeight": true, "border": false, "layout": "form", "autoScroll": false, "items": [ main_1_panel4903, p2_panel4920 ], "frame": true, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel4921;
    this.before_row_edit = function(record) {
    }
    Lino.cbss.IdentifyPersonRequests.InsertFormPanel.superclass.initComponent.call(this);
    // active_fields:
    person4901.on("change",function(){this.save()},this);
  }
});


Lino.reception.Clients.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 57,
  initComponent : function() {
    var containing_panel = this;
    var client_info_disp97 = new Ext.form.DisplayField({ "disabled": true, "flex": 34, "listeners": { "render": Lino.quicktip_renderer(null,"(reception.Clients.client_info) ") }, "name": "client_info", "value": "<br/>", "always_enabled": true });
    var image_htmlbox98 = new Lino.HtmlBoxPanel({ "flex": 17, "layout": "fit", "name": "image", "containing_panel": this, "items": new Ext.BoxComponent({autoScroll:true}), "bodyStyle": "overflow-x:hidden;", "value": "<br/>", "always_enabled": true, "listeners": { "render": Lino.quicktip_renderer(null,"(reception.Clients.image) ") } });
    var birth_date99 = new Lino.IncompleteDateField({ "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Birth date</span>", "name": "birth_date", "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Geburtsdatum","(reception.Clients.birth_date) Uncomplete dates are allowed, e.g. \n\"00.00.1980\" means \"some day in 1980\", \n\"00.07.1980\" means \"in July 1980\"\nor \"23.07.0000\" means \"on a 23th of July\".") }, "anchor": "-20" });
    var age_disp100 = new Ext.form.DisplayField({ "autoHeight": true, "fieldLabel": "Age", "name": "age", "value": "<br/>", "always_enabled": true, "disabled": true, "listeners": { "render": Lino.quicktip_renderer("Alter","(reception.Clients.age) ") }, "anchor": "-20" });
    var gender101 = new Lino.ChoicesFieldElement({ "autoHeight": true, "forceSelection": true, "fieldLabel": "Gender", "name": "gender", "hiddenName": "genderHidden", "listeners": { "render": Lino.quicktip_renderer("Geschlecht","(reception.Clients.gender) ") }, "selectOnFocus": true, "anchor": "-20", "store": [['','<br>']].concat(Lino.lino.Genders) });
    var birth_country102 = new Lino.TwinCombo({ "autoHeight": true, "fieldLabel": "Birth country", "name": "birth_country", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.countries.Countries.detail)}, "emptyText": "Select a Country...", "listeners": { "render": Lino.quicktip_renderer("Geburtsland","(reception.Clients.birth_country) ") }, "selectOnFocus": true, "hiddenName": "birth_countryHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/reception/Clients/birth_country", "method": "GET" }) }) });
    var birth_place103 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Birth place", "name": "birth_place", "maxLength": 200, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Geburtsort","(reception.Clients.birth_place) ") }, "anchor": "-20" });
    var box3_panel104 = new Ext.Panel({ "flex": 23, "autoHeight": true, "layout": "form", "items": [ { "autoHeight": true, "layout": "form", "xtype": "panel", "items": birth_date99, "anchor": "-20", "labelAlign": "top" }, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": age_disp100, "anchor": "-20", "labelAlign": "top" }, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": gender101, "anchor": "-20", "labelAlign": "top" }, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": birth_country102, "anchor": "-20", "labelAlign": "top" }, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": birth_place103, "anchor": "-20", "labelAlign": "top" } ], "frame": true, "bodyBorder": false, "autoScroll": false, "hideCheckBoxLabels": true, "labelWidth": 117, "border": false, "labelAlign": "top" });
    var national_id110 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "National ID", "name": "national_id", "maxLength": 200, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("NR-Nummer","(reception.Clients.national_id) ") }, "anchor": "-20" });
    var gesdos_id111 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Gesdos ID", "name": "gesdos_id", "maxLength": 40, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Gesdos-Nr","(reception.Clients.gesdos_id) ") }, "anchor": "-20" });
    var nationality112 = new Lino.TwinCombo({ "autoHeight": true, "fieldLabel": "Nationality", "name": "nationality", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.countries.Countries.detail)}, "emptyText": "Select a Country...", "listeners": { "render": Lino.quicktip_renderer("Staatsangeh\u00f6rigkeit","(reception.Clients.nationality) ") }, "selectOnFocus": true, "hiddenName": "nationalityHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/reception/Clients/nationality", "method": "GET" }) }) });
    var box3c_panel113 = new Ext.Panel({ "flex": 24, "autoHeight": true, "layout": "form", "items": [ { "autoHeight": true, "layout": "form", "xtype": "panel", "items": national_id110, "anchor": "-20", "labelAlign": "top" }, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": gesdos_id111, "anchor": "-20", "labelAlign": "top" }, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": nationality112, "anchor": "-20", "labelAlign": "top" } ], "frame": true, "bodyBorder": false, "autoScroll": false, "hideCheckBoxLabels": true, "labelWidth": 180, "border": false, "labelAlign": "top" });
    var general_1_panel117 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 0, "hideCheckBoxLabels": true, "items": [ client_info_disp97, image_htmlbox98, box3_panel104, box3c_panel113 ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var AppointmentsByPartner_grid122 = new Lino.reception.AppointmentsByPartner.GridPanel({ "flex": 42, "listeners": { "render": Lino.quicktip_renderer("Termine","(reception.reception.AppointmentsByPartner) ") }, "hide_top_toolbar": true, "containing_panel": this, "tools": [ Lino.show_in_own_window_button(Lino.reception.AppointmentsByPartner.grid) ], "preview_limit": 15, "master_panel": this });
    var reception_CoachingsByClient_grid147 = new Lino.reception.CoachingsByClient.GridPanel({ "flex": 57, "hide_top_toolbar": true, "containing_panel": this, "params_panel_hidden": true, "preview_limit": 15, "master_panel": this, "listeners": { "render": Lino.quicktip_renderer("Begleiter","(reception.reception.CoachingsByClient) ") }, "tools": [ Lino.show_in_own_window_button(Lino.reception.CoachingsByClient.grid) ] });
    var general_2_panel148 = new Ext.Panel({ "flex": 41, "border": false, "layout": "hbox", "hideCheckBoxLabels": true, "items": [ AppointmentsByPartner_grid122, reception_CoachingsByClient_grid147 ], "autoScroll": false, "layoutConfig": { "align": "stretch" }, "frame": false, "labelAlign": "top" });
    var general_panel149 = new Ext.Panel({ "layout": "vbox", "title": "General", "items": [ general_1_panel117, general_2_panel148 ], "frame": true, "layoutConfig": { "align": "stretch" }, "hideCheckBoxLabels": true, "listeners": { "activate": Lino.on_tab_activate }, "autoScroll": false, "border": false, "bodyBorder": false, "labelAlign": "top" });
    var country150 = new Lino.TwinCombo({ "autoHeight": true, "fieldLabel": "Country", "name": "country", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.countries.Countries.detail)}, "emptyText": "Select a Country...", "listeners": { "render": Lino.quicktip_renderer("Land","(reception.Clients.country) ") }, "selectOnFocus": true, "hiddenName": "countryHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/reception/Clients/country", "method": "GET" }) }) });
    var city151 = new Lino.TwinCombo({ "autoHeight": true, "forceSelection": false, "fieldLabel": "Place", "name": "city", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.countries.Cities.detail)}, "emptyText": "Select a Place...", "listeners": { "render": Lino.quicktip_renderer("Ort","(reception.Clients.city) ") }, "selectOnFocus": true, "hiddenName": "cityHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/reception/Clients/city", "method": "GET" }) }) });
    var zip_code152 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Zip code", "name": "zip_code", "boxMinWidth": Lino.chars2width(10), "listeners": { "render": Lino.quicktip_renderer("Postleitzahl","(reception.Clients.zip_code) ") }, "maxLength": 10, "selectOnFocus": true, "anchor": "-20" });
    var contact1_1_panel153 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 39, "autoHeight": true, "layout": "form", "xtype": "panel", "items": country150, "labelAlign": "top" }, { "flex": 39, "autoHeight": true, "layout": "form", "xtype": "panel", "items": city151, "labelAlign": "top" }, { "flex": 21, "autoHeight": true, "layout": "form", "xtype": "panel", "items": zip_code152, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 117, "border": false, "anchor": "-20", "labelAlign": "top" });
    var street157 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Street</span>", "name": "street", "maxLength": 200, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Stra\u00dfe","(reception.Clients.street) Name of street. Without house number.") }, "anchor": "-20" });
    var street_no158 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">No.</span>", "name": "street_no", "boxMinWidth": Lino.chars2width(10), "listeners": { "render": Lino.quicktip_renderer("Nr.","(reception.Clients.street_no) House number") }, "maxLength": 10, "selectOnFocus": true, "anchor": "-20" });
    var street_box159 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Box</span>", "name": "street_box", "boxMinWidth": Lino.chars2width(10), "listeners": { "render": Lino.quicktip_renderer("Box","(reception.Clients.street_box) Text to print after :attr:`steet_no` on the same line") }, "maxLength": 10, "selectOnFocus": true, "anchor": "-20" });
    var contact1_2_panel160 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 48, "autoHeight": true, "layout": "form", "xtype": "panel", "items": street157, "labelAlign": "top" }, { "flex": 25, "autoHeight": true, "layout": "form", "xtype": "panel", "items": street_no158, "labelAlign": "top" }, { "flex": 25, "autoHeight": true, "layout": "form", "xtype": "panel", "items": street_box159, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 63, "border": false, "anchor": "-20", "labelAlign": "top" });
    var addr2164 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Address line after street</span>", "name": "addr2", "maxLength": 200, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Adresszeile nach Stra\u00dfe","(reception.Clients.addr2) Address line to print below street line") }, "anchor": "-20" });
    var contact1_panel165 = new Ext.Panel({ "flex": 71, "autoHeight": true, "layout": "form", "items": [ contact1_1_panel153, contact1_2_panel160, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": addr2164, "anchor": "-20", "labelAlign": "top" } ], "frame": true, "bodyBorder": false, "autoScroll": false, "hideCheckBoxLabels": true, "labelWidth": 216, "border": false, "labelAlign": "top" });
    var email167 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "E-Mail", "name": "email", "maxLength": 75, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("E-Mail","(reception.Clients.email) ") }, "anchor": "-20" });
    var phone168 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Phone", "name": "phone", "maxLength": 200, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Telefon","(reception.Clients.phone) ") }, "anchor": "-20" });
    var gsm169 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "GSM", "name": "gsm", "maxLength": 200, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("GSM","(reception.Clients.gsm) ") }, "anchor": "-20" });
    var box2_panel170 = new Ext.Panel({ "flex": 28, "autoHeight": true, "layout": "form", "items": [ { "autoHeight": true, "layout": "form", "xtype": "panel", "items": email167, "anchor": "-20", "labelAlign": "top" }, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": phone168, "anchor": "-20", "labelAlign": "top" }, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": gsm169, "anchor": "-20", "labelAlign": "top" } ], "frame": true, "bodyBorder": false, "autoScroll": false, "hideCheckBoxLabels": true, "labelWidth": 72, "border": false, "labelAlign": "top" });
    var contact_1_panel174 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "hideCheckBoxLabels": true, "items": [ contact1_panel165, box2_panel170 ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var pcsw_ContactsByClient_grid182 = new Lino.pcsw.ContactsByClient.GridPanel({ "flex": 62, "listeners": { "render": Lino.quicktip_renderer("Kontakte","(pcsw.pcsw.ContactsByClient) ") }, "hide_top_toolbar": true, "containing_panel": this, "tools": [ Lino.show_in_own_window_button(Lino.pcsw.ContactsByClient.grid) ], "preview_limit": 15, "master_panel": this });
    var contact_panel183 = new Ext.Panel({ "layout": "vbox", "title": "Contact", "items": [ contact_1_panel174, pcsw_ContactsByClient_grid182 ], "frame": true, "layoutConfig": { "align": "stretch" }, "hideCheckBoxLabels": true, "listeners": { "activate": Lino.on_tab_activate }, "autoScroll": false, "border": false, "bodyBorder": false, "labelAlign": "top" });
    var CreateNoteActionsByClient_grid186 = new Lino.reception.CreateNoteActionsByClient.GridPanel({ "flex": 33, "hide_top_toolbar": true, "containing_panel": this, "preview_limit": 15, "master_panel": this, "listeners": { "render": Lino.quicktip_renderer("Bescheinigung ausstellen","(reception.reception.CreateNoteActionsByClient) ") }, "tools": [ Lino.show_in_own_window_button(Lino.reception.CreateNoteActionsByClient.grid) ], "hideHeaders": true });
    var pcsw_NotesByPerson_grid347 = new Lino.pcsw.NotesByPerson.GridPanel({ "flex": 66, "listeners": { "render": Lino.quicktip_renderer("Ereignisse/Notizen","(pcsw.pcsw.NotesByPerson) ") }, "hide_top_toolbar": true, "containing_panel": this, "tools": [ Lino.show_in_own_window_button(Lino.pcsw.NotesByPerson.grid) ], "preview_limit": 15, "master_panel": this });
    var history_1_panel348 = new Ext.Panel({ "autoScroll": false, "listeners": { "activate": Lino.on_tab_activate }, "border": false, "layout": "hbox", "title": "History", "hideCheckBoxLabels": true, "items": [ CreateNoteActionsByClient_grid186, pcsw_NotesByPerson_grid347 ], "frame": false, "layoutConfig": { "align": "stretch" }, "labelAlign": "top" });
    var main_panel349 = new Ext.TabPanel({ "hideCheckBoxLabels": true, "border": false, "split": true, "autoScroll": false, "items": [ general_panel149, contact_panel183, history_1_panel348 ], "activeTab": 0, "bodyBorder": false, "frame": true, "labelAlign": "top" });
    this.items = main_panel349;
    this.before_row_edit = function(record) {
      image_htmlbox98.refresh();
      AppointmentsByPartner_grid122.on_master_changed();
      reception_CoachingsByClient_grid147.on_master_changed();
      city151.setContextValue('country',record ? record.data['countryHidden'] : undefined);
      city151.setContextValue('region',record ? record.data['regionHidden'] : undefined);
      pcsw_ContactsByClient_grid182.on_master_changed();
      CreateNoteActionsByClient_grid186.on_master_changed();
      pcsw_NotesByPerson_grid347.on_master_changed();
    }
    this.onRender = function(ct, position) {
      country150.on('change',Lino.chooser_handler(city151,'country'));
      Lino.reception.Clients.DetailFormPanel.superclass.onRender.call(this, ct, position);
    }
    Lino.reception.Clients.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.cbss.RetrieveTIGroupsRequests.InsertFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  autoHeight: true,
  content_type: 94,
  initComponent : function() {
    var containing_panel = this;
    var person5074 = new Lino.TwinCombo({ "preferred_width": 20, "autoHeight": true, "fieldLabel": "Client", "allowBlank": false, "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.pcsw.Clients.detail)}, "emptyText": "Select a Client...", "listeners": { "render": Lino.quicktip_renderer("Klient","(cbss.RetrieveTIGroupsRequests.person) ") }, "selectOnFocus": true, "hiddenName": "personHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cbss/RetrieveTIGroupsRequests/person", "method": "GET" }) }), "name": "person" });
    var national_id5075 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "National ID", "name": "national_id", "maxLength": 200, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("NR-Nummer","(cbss.RetrieveTIGroupsRequests.national_id) ") }, "anchor": "-20" });
    var language5076 = new Lino.ChoicesFieldElement({ "autoHeight": true, "forceSelection": true, "fieldLabel": "Language", "name": "language", "hiddenName": "languageHidden", "listeners": { "render": Lino.quicktip_renderer("Sprache","(cbss.RetrieveTIGroupsRequests.language) ") }, "selectOnFocus": true, "anchor": "-20", "store": [['','<br>']].concat(Lino.cbss.RequestLanguages) });
    var main_2_panel5077 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 70, "autoHeight": true, "layout": "form", "xtype": "panel", "items": national_id5075, "labelAlign": "top" }, { "flex": 30, "autoHeight": true, "layout": "form", "xtype": "panel", "items": language5076, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 90, "border": false, "anchor": "-20", "labelAlign": "top" });
    var history5080 = new Ext.form.Checkbox({ "autoHeight": true, "hideLabel": true, "checked": true, "name": "history", "listeners": { "render": Lino.quicktip_renderer("Historie","(cbss.RetrieveTIGroupsRequests.history) Whatever this means.") }, "boxLabel": "History", "selectOnFocus": true, "anchor": "-20" });
    var main_panel5081 = new Ext.Panel({ "hideCheckBoxLabels": true, "autoHeight": true, "border": false, "layout": "form", "labelWidth": 81, "autoScroll": false, "items": [ { "autoHeight": true, "layout": "form", "xtype": "panel", "items": person5074, "anchor": "-20", "labelAlign": "top" }, main_2_panel5077, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": history5080, "anchor": "-20", "labelAlign": "top" } ], "frame": true, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel5081;
    this.before_row_edit = function(record) {
    }
    Lino.cbss.RetrieveTIGroupsRequests.InsertFormPanel.superclass.initComponent.call(this);
  }
});


Lino.cal.Guests.InsertFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  autoHeight: true,
  content_type: 41,
  initComponent : function() {
    var containing_panel = this;
    var event1515 = new Lino.TwinCombo({ "autoHeight": true, "fieldLabel": "Event", "allowBlank": false, "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.cal.OneEvent.detail)}, "emptyText": "Select a Event...", "listeners": { "render": Lino.quicktip_renderer("Termin","(cal.Guests.event) ") }, "selectOnFocus": true, "hiddenName": "eventHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/Guests/event", "method": "GET" }) }), "name": "event" });
    var partner1516 = new Lino.TwinCombo({ "preferred_width": 20, "autoHeight": true, "fieldLabel": "Partner", "allowBlank": false, "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.contacts.Partners.detail)}, "emptyText": "Select a Partner...", "listeners": { "render": Lino.quicktip_renderer("Partner","(cal.Guests.partner) ") }, "selectOnFocus": true, "hiddenName": "partnerHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/Guests/partner", "method": "GET" }) }), "name": "partner" });
    var role1517 = new Lino.TwinCombo({ "autoHeight": true, "fieldLabel": "Role", "name": "role", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.cal.GuestRoles.detail)}, "emptyText": "Select a Guest Role...", "listeners": { "render": Lino.quicktip_renderer("Rolle","(cal.Guests.role) ") }, "selectOnFocus": true, "hiddenName": "roleHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/Guests/role", "method": "GET" }) }) });
    var main_panel1518 = new Ext.Panel({ "hideCheckBoxLabels": true, "autoHeight": true, "border": false, "layout": "form", "labelWidth": 72, "autoScroll": false, "items": [ { "autoHeight": true, "layout": "form", "xtype": "panel", "items": event1515, "anchor": "-20", "labelAlign": "top" }, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": partner1516, "anchor": "-20", "labelAlign": "top" }, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": role1517, "anchor": "-20", "labelAlign": "top" } ], "frame": true, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel1518;
    this.before_row_edit = function(record) {
    }
    Lino.cal.Guests.InsertFormPanel.superclass.initComponent.call(this);
  }
});


Lino.jobs.JobsOverview.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  disable_editing: true,
  initComponent : function() {
    var containing_panel = this;
    var preview_htmlbox2883 = new Lino.HtmlBoxPanel({ "layout": "fit", "name": "preview", "containing_panel": this, "items": new Ext.BoxComponent({autoScroll:true}), "bodyStyle": "overflow-x:hidden;", "value": "<br/>", "always_enabled": true, "listeners": { "render": Lino.quicktip_renderer(null,"(jobs.JobsOverview.preview) ") } });
    var main_panel2884 = new Ext.Panel({ "autoScroll": false, "border": false, "layout": "fit", "labelWidth": 0, "hideCheckBoxLabels": true, "items": [ preview_htmlbox2883 ], "frame": true, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel2884;
    this.before_row_edit = function(record) {
      preview_htmlbox2883.refresh();
    }
    Lino.jobs.JobsOverview.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.properties.Properties.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 18,
  initComponent : function() {
    var containing_panel = this;
    var id3252 = new Ext.form.NumberField({ "autoHeight": true, "fieldLabel": "ID", "name": "id", "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("ID","(properties.Properties.id) ") }, "anchor": "-20" });
    var group3253 = new Lino.TwinCombo({ "autoHeight": true, "fieldLabel": "Property Group", "allowBlank": false, "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.properties.PropGroups.detail)}, "emptyText": "Select a Property Group...", "listeners": { "render": Lino.quicktip_renderer("Eigenschaftsgruppe","(properties.Properties.group) ") }, "selectOnFocus": true, "hiddenName": "groupHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/properties/Properties/group", "method": "GET" }) }), "name": "group" });
    var type3254 = new Lino.TwinCombo({ "autoHeight": true, "fieldLabel": "Property Type", "allowBlank": false, "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.properties.PropTypes.detail)}, "emptyText": "Select a Property Type...", "listeners": { "render": Lino.quicktip_renderer("Eigenschafts-Datentyp","(properties.Properties.type) ") }, "selectOnFocus": true, "hiddenName": "typeHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/properties/Properties/type", "method": "GET" }) }), "name": "type" });
    var main_1_panel3255 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 198, "hideCheckBoxLabels": true, "items": [ { "flex": 11, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id3252, "labelAlign": "top" }, { "flex": 44, "autoHeight": true, "layout": "form", "xtype": "panel", "items": group3253, "labelAlign": "top" }, { "flex": 44, "autoHeight": true, "layout": "form", "xtype": "panel", "items": type3254, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var name3259 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Designation", "name": "name", "listeners": { "render": Lino.quicktip_renderer("Bezeichnung","(properties.Properties.name) ") }, "maxLength": 200, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var name_fr3260 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Designation (fr)", "name": "name_fr", "maxLength": 200, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Bezeichnung (fr)","(properties.Properties.name_fr) ") }, "anchor": "-20" });
    var name_de3261 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Designation (de)", "name": "name_de", "maxLength": 200, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Bezeichnung (de)","(properties.Properties.name_de) ") }, "anchor": "-20" });
    var name_nl3262 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Designation (nl)", "name": "name_nl", "listeners": { "render": Lino.quicktip_renderer("Bezeichnung (nl)","(properties.Properties.name_nl) ") }, "maxLength": 200, "selectOnFocus": true, "hidden": true, "anchor": "-20" });
    var main_2_panel3263 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 153, "hideCheckBoxLabels": true, "items": [ { "flex": 25, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name3259, "labelAlign": "top" }, { "flex": 25, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_fr3260, "labelAlign": "top" }, { "flex": 25, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_de3261, "labelAlign": "top" }, { "flex": 25, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_nl3262, "hidden": true, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var cv_PersonPropsByProp_grid3274 = new Lino.cv.PersonPropsByProp.GridPanel({ "flex": 71, "listeners": { "render": Lino.quicktip_renderer("Eigenschaften","(cv.cv.PersonPropsByProp) ") }, "hide_top_toolbar": true, "containing_panel": this, "tools": [ Lino.show_in_own_window_button(Lino.cv.PersonPropsByProp.grid) ], "preview_limit": 15, "master_panel": this });
    var main_panel3275 = new Ext.Panel({ "autoScroll": false, "border": false, "layout": "vbox", "hideCheckBoxLabels": true, "items": [ main_1_panel3255, main_2_panel3263, cv_PersonPropsByProp_grid3274 ], "frame": true, "layoutConfig": { "align": "stretch" }, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel3275;
    this.before_row_edit = function(record) {
      cv_PersonPropsByProp_grid3274.on_master_changed();
    }
    Lino.properties.Properties.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.cal.Rooms.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 35,
  initComponent : function() {
    var containing_panel = this;
    var id3326 = new Ext.form.NumberField({ "autoHeight": true, "fieldLabel": "ID", "name": "id", "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("ID","(cal.Rooms.id) ") }, "anchor": "-20" });
    var name3327 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Designation", "name": "name", "listeners": { "render": Lino.quicktip_renderer("Bezeichnung","(cal.Rooms.name) ") }, "maxLength": 200, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var name_fr3328 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Designation (fr)", "name": "name_fr", "maxLength": 200, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Bezeichnung (fr)","(cal.Rooms.name_fr) ") }, "anchor": "-20" });
    var name_de3329 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Designation (de)", "name": "name_de", "maxLength": 200, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Bezeichnung (de)","(cal.Rooms.name_de) ") }, "anchor": "-20" });
    var name_nl3330 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Designation (nl)", "name": "name_nl", "listeners": { "render": Lino.quicktip_renderer("Bezeichnung (nl)","(cal.Rooms.name_nl) ") }, "maxLength": 200, "selectOnFocus": true, "hidden": true, "anchor": "-20" });
    var main_1_panel3331 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 153, "hideCheckBoxLabels": true, "items": [ { "flex": 5, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id3326, "labelAlign": "top" }, { "flex": 23, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name3327, "labelAlign": "top" }, { "flex": 23, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_fr3328, "labelAlign": "top" }, { "flex": 23, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_de3329, "labelAlign": "top" }, { "flex": 23, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_nl3330, "hidden": true, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var cal_EventsByRoom_grid3362 = new Lino.cal.EventsByRoom.GridPanel({ "flex": 83, "hide_top_toolbar": true, "containing_panel": this, "params_panel_hidden": true, "master_panel": this, "preview_limit": 15, "listeners": { "render": Lino.quicktip_renderer("Termine","(cal.cal.EventsByRoom) ") }, "tools": [ Lino.show_in_own_window_button(Lino.cal.EventsByRoom.grid) ] });
    var main_panel3363 = new Ext.Panel({ "autoScroll": false, "border": false, "layout": "vbox", "hideCheckBoxLabels": true, "items": [ main_1_panel3331, cal_EventsByRoom_grid3362 ], "frame": true, "layoutConfig": { "align": "stretch" }, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel3363;
    this.before_row_edit = function(record) {
      cal_EventsByRoom_grid3362.on_master_changed();
    }
    Lino.cal.Rooms.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.courses.Courses.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 83,
  initComponent : function() {
    var containing_panel = this;
    var id961 = new Ext.form.NumberField({ "autoHeight": true, "fieldLabel": "ID", "name": "id", "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("ID","(courses.Courses.id) ") }, "anchor": "-20" });
    var start_date962 = new Lino.DateField({ "autoHeight": true, "allowBlank": false, "fieldLabel": "start date", "name": "start_date", "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Beginndatum","(courses.Courses.start_date) ") }, "anchor": "-20" });
    var offer963 = new Lino.TwinCombo({ "autoHeight": true, "fieldLabel": "Course Offer", "allowBlank": false, "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.courses.CourseOffers.detail)}, "emptyText": "Select a Course Offer...", "listeners": { "render": Lino.quicktip_renderer("Kursangebot","(courses.Courses.offer) ") }, "selectOnFocus": true, "hiddenName": "offerHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/courses/Courses/offer", "method": "GET" }) }), "name": "offer" });
    var title964 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Name", "name": "title", "maxLength": 200, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Name","(courses.Courses.title) ") }, "anchor": "-20" });
    var main_1_panel965 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 108, "hideCheckBoxLabels": true, "items": [ { "flex": 14, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id961, "labelAlign": "top" }, { "flex": 14, "autoHeight": true, "layout": "form", "xtype": "panel", "items": start_date962, "labelAlign": "top" }, { "flex": 35, "autoHeight": true, "layout": "form", "xtype": "panel", "items": offer963, "labelAlign": "top" }, { "flex": 36, "autoHeight": true, "layout": "form", "xtype": "panel", "items": title964, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var remark970 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Remark", "name": "remark", "maxLength": 200, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Bemerkung","(courses.Courses.remark) ") }, "anchor": "-20" });
    var courses_ParticipantsByCourse_grid1001 = new Lino.courses.ParticipantsByCourse.GridPanel({ "flex": 41, "listeners": { "render": Lino.quicktip_renderer("Teilnehmer","(courses.courses.ParticipantsByCourse) ") }, "hide_top_toolbar": true, "containing_panel": this, "tools": [ Lino.show_in_own_window_button(Lino.courses.ParticipantsByCourse.grid) ], "preview_limit": 15, "master_panel": this });
    var courses_CandidatesByCourse_grid1008 = new Lino.courses.CandidatesByCourse.GridPanel({ "flex": 41, "listeners": { "render": Lino.quicktip_renderer("Kandidaten","(courses.courses.CandidatesByCourse) ") }, "hide_top_toolbar": true, "containing_panel": this, "tools": [ Lino.show_in_own_window_button(Lino.courses.CandidatesByCourse.grid) ], "preview_limit": 15, "master_panel": this });
    var main_panel1009 = new Ext.Panel({ "autoScroll": false, "border": false, "layout": "vbox", "labelWidth": 90, "hideCheckBoxLabels": true, "items": [ main_1_panel965, { "items": remark970, "autoHeight": true, "layout": "form", "xtype": "panel", "labelAlign": "top" }, courses_ParticipantsByCourse_grid1001, courses_CandidatesByCourse_grid1008 ], "frame": true, "layoutConfig": { "align": "stretch" }, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel1009;
    this.before_row_edit = function(record) {
      courses_ParticipantsByCourse_grid1001.on_master_changed();
      courses_CandidatesByCourse_grid1008.on_master_changed();
    }
    Lino.courses.Courses.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.courses.CourseRequests.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 82,
  initComponent : function() {
    var containing_panel = this;
    var date_submitted976 = new Lino.DateField({ "autoHeight": true, "allowBlank": false, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">date submitted</span>", "name": "date_submitted", "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Anfragedatum","(courses.CourseRequests.date_submitted) Datum, an dem die Anfrage erstellt wurde.") }, "anchor": "-20" });
    var person977 = new Lino.TwinCombo({ "preferred_width": 20, "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Client</span>", "allowBlank": false, "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.pcsw.Clients.detail)}, "emptyText": "Select a Client...", "listeners": { "render": Lino.quicktip_renderer("Klient","(courses.CourseRequests.person) Le client qui d\u00e9sire suivre un cours.") }, "selectOnFocus": true, "hiddenName": "personHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/courses/CourseRequests/person", "method": "GET" }) }), "name": "person" });
    var content978 = new Lino.TwinCombo({ "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Course content</span>", "allowBlank": false, "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.courses.CourseContents.detail)}, "emptyText": "Select a Course Content...", "listeners": { "render": Lino.quicktip_renderer("Kursinhalt","(courses.CourseRequests.content) Der gew\u00fcnschte Kursinhalt.)") }, "selectOnFocus": true, "hiddenName": "contentHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/courses/CourseRequests/content", "method": "GET" }) }), "name": "content" });
    var offer979 = new Lino.TwinCombo({ "autoHeight": true, "fieldLabel": "Course Offer", "name": "offer", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.courses.CourseOffers.detail)}, "emptyText": "Select a Course Offer...", "listeners": { "render": Lino.quicktip_renderer("Kursangebot","(courses.CourseRequests.offer) ") }, "selectOnFocus": true, "hiddenName": "offerHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/courses/CourseRequests/offer", "method": "GET" }) }) });
    var urgent980 = new Ext.form.Checkbox({ "autoHeight": true, "hideLabel": true, "checked": false, "name": "urgent", "listeners": { "render": Lino.quicktip_renderer("professionelle Eingliederung","(courses.CourseRequests.urgent) Ankreuzen, wenn der Kurs f\u00fcr die Arbeitssuche ben\u00f6tigt wird.") }, "boxLabel": "Needed for job search", "selectOnFocus": true, "anchor": "-20" });
    var main_1_panel981 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 261, "hideCheckBoxLabels": true, "items": [ { "flex": 10, "autoHeight": true, "layout": "form", "xtype": "panel", "items": date_submitted976, "labelAlign": "top" }, { "flex": 25, "autoHeight": true, "layout": "form", "xtype": "panel", "items": person977, "labelAlign": "top" }, { "flex": 25, "autoHeight": true, "layout": "form", "xtype": "panel", "items": content978, "labelAlign": "top" }, { "flex": 25, "autoHeight": true, "layout": "form", "xtype": "panel", "items": offer979, "labelAlign": "top" }, { "flex": 12, "autoHeight": true, "layout": "form", "xtype": "panel", "items": urgent980, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var course987 = new Lino.TwinCombo({ "autoHeight": true, "fieldLabel": "Course found", "name": "course", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.courses.Courses.detail)}, "emptyText": "Select a Course...", "listeners": { "render": Lino.quicktip_renderer("Kurs gefunden","(courses.CourseRequests.course) ") }, "selectOnFocus": true, "hiddenName": "courseHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/courses/CourseRequests/course", "method": "GET" }) }) });
    var state988 = new Lino.ChoicesFieldElement({ "autoHeight": true, "forceSelection": true, "fieldLabel": "State", "allowBlank": false, "hiddenName": "stateHidden", "listeners": { "render": Lino.quicktip_renderer("Zustand","(courses.CourseRequests.state) ") }, "selectOnFocus": true, "anchor": "-20", "store": Lino.courses.CourseRequestStates, "name": "state" });
    var date_ended989 = new Lino.DateField({ "autoHeight": true, "fieldLabel": "date ended", "name": "date_ended", "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Enddatum","(courses.CourseRequests.date_ended) ") }, "anchor": "-20" });
    var id990 = new Ext.form.NumberField({ "autoHeight": true, "fieldLabel": "ID", "name": "id", "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("ID","(courses.CourseRequests.id) ") }, "anchor": "-20" });
    var main_2_panel991 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 126, "hideCheckBoxLabels": true, "items": [ { "flex": 40, "autoHeight": true, "layout": "form", "xtype": "panel", "items": course987, "labelAlign": "top" }, { "flex": 26, "autoHeight": true, "layout": "form", "xtype": "panel", "items": state988, "labelAlign": "top" }, { "flex": 16, "autoHeight": true, "layout": "form", "xtype": "panel", "items": date_ended989, "labelAlign": "top" }, { "flex": 16, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id990, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var remark996 = new Ext.form.TextArea({ "listeners": { "render": Lino.quicktip_renderer("Bemerkung","(courses.CourseRequests.remark) ") }, "fieldLabel": "Remark", "name": "remark", "growMax": 2000, "selectOnFocus": true, "anchor": "-20 -10" });
    var UploadsByController_htmlbox997 = new Lino.HtmlBoxPanel({ "flex": 33, "ls_bbar_actions": [ { "itemId": "insert", "menu_item_text": "New", "must_save": true, "tooltip": "Insert a new record", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-add", "overflowText": "New", "auto_save": true } ], "name": "UploadsByController", "containing_panel": this, "items": new Ext.BoxComponent({autoScroll:true}), "title": "Uploads", "master_panel": this, "value": "<br/>", "always_enabled": true, "listeners": { "render": Lino.quicktip_renderer("Uploads","(courses.CourseRequests.UploadsByController) ") }, "bodyStyle": "overflow-x:hidden;", "ls_insert_handler": Lino.uploads.UploadsByController.insert, "layout": "fit", "tools": [ Lino.show_in_own_window_button(Lino.uploads.UploadsByController.grid) ] });
    var main_3_panel998 = new Ext.Panel({ "flex": 71, "border": false, "layout": "hbox", "labelWidth": 90, "hideCheckBoxLabels": true, "items": [ { "items": remark996, "labelAlign": "top", "layout": "form", "xtype": "panel", "flex": 66 }, UploadsByController_htmlbox997 ], "autoScroll": false, "layoutConfig": { "align": "stretch" }, "frame": false, "labelAlign": "top" });
    var main_panel1000 = new Ext.Panel({ "autoScroll": false, "border": false, "layout": "vbox", "hideCheckBoxLabels": true, "items": [ main_1_panel981, main_2_panel991, main_3_panel998 ], "frame": true, "layoutConfig": { "align": "stretch" }, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel1000;
    this.before_row_edit = function(record) {
      offer979.setContextValue('content',record ? record.data['contentHidden'] : undefined);
      UploadsByController_htmlbox997.refresh();
    }
    this.onRender = function(ct, position) {
      content978.on('change',Lino.chooser_handler(offer979,'content'));
      Lino.courses.CourseRequests.DetailFormPanel.superclass.onRender.call(this, ct, position);
    }
    Lino.courses.CourseRequests.DetailFormPanel.superclass.initComponent.call(this);
    // active_fields:
    offer979.on("change",function(){this.save()},this);
  }
});


Lino.cal.GuestRoles.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 37,
  initComponent : function() {
    var containing_panel = this;
    var id3381 = new Ext.form.NumberField({ "autoHeight": true, "fieldLabel": "ID", "name": "id", "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("ID","(cal.GuestRoles.id) ") }, "anchor": "-20" });
    var name3382 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Designation", "name": "name", "listeners": { "render": Lino.quicktip_renderer("Bezeichnung","(cal.GuestRoles.name) ") }, "maxLength": 200, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var name_fr3383 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Designation (fr)", "name": "name_fr", "maxLength": 200, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Bezeichnung (fr)","(cal.GuestRoles.name_fr) ") }, "anchor": "-20" });
    var name_de3384 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Designation (de)", "name": "name_de", "maxLength": 200, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Bezeichnung (de)","(cal.GuestRoles.name_de) ") }, "anchor": "-20" });
    var name_nl3385 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Designation (nl)", "name": "name_nl", "listeners": { "render": Lino.quicktip_renderer("Bezeichnung (nl)","(cal.GuestRoles.name_nl) ") }, "maxLength": 200, "selectOnFocus": true, "hidden": true, "anchor": "-20" });
    var main_1_panel3386 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 153, "hideCheckBoxLabels": true, "items": [ { "flex": 5, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id3381, "labelAlign": "top" }, { "flex": 23, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name3382, "labelAlign": "top" }, { "flex": 23, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_fr3383, "labelAlign": "top" }, { "flex": 23, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_de3384, "labelAlign": "top" }, { "flex": 23, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_nl3385, "hidden": true, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var build_method3392 = new Lino.ChoicesFieldElement({ "autoHeight": true, "fieldLabel": "Build method", "name": "build_method", "hiddenName": "build_methodHidden", "listeners": { "render": Lino.quicktip_renderer("Konstruktionsmethode","(cal.GuestRoles.build_method) ") }, "selectOnFocus": true, "anchor": "-20", "store": [ [ "appyodt", "AppyOdtBuildMethod" ], [ "appypdf", "AppyPdfBuildMethod" ], [ "appyrtf", "AppyRtfBuildMethod" ], [ "latex", "LatexBuildMethod" ], [ "pisa", "PisaBuildMethod" ], [ "rtf", "RtfBuildMethod" ] ] });
    var template3393 = new Lino.SimpleRemoteComboFieldElement({ "autoHeight": true, "fieldLabel": "Template", "name": "template", "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Vorlage","(cal.GuestRoles.template) ") }, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/GuestRoles/template", "method": "GET" }) }), "anchor": "-20" });
    var email_template3394 = new Lino.SimpleRemoteComboFieldElement({ "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Email template</span>", "name": "email_template", "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("E-Mail-Vorlage","(cal.GuestRoles.email_template) The name of the file to be used as \ntemplate when creating an email from a mailable of this type.") }, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/GuestRoles/email_template", "method": "GET" }) }), "anchor": "-20" });
    var attach_to_email3395 = new Ext.form.Checkbox({ "autoHeight": true, "hideLabel": true, "checked": false, "name": "attach_to_email", "listeners": { "render": Lino.quicktip_renderer("als Anhang per E-Mail","(cal.GuestRoles.attach_to_email) Whether the printable file should be attached to the email\nwhen creating an email from a mailable of this type.\n") }, "boxLabel": "Attach to email", "selectOnFocus": true, "anchor": "-20" });
    var main_2_panel3396 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 198, "hideCheckBoxLabels": true, "items": [ { "flex": 40, "autoHeight": true, "layout": "form", "xtype": "panel", "items": build_method3392, "labelAlign": "top" }, { "flex": 20, "autoHeight": true, "layout": "form", "xtype": "panel", "items": template3393, "labelAlign": "top" }, { "flex": 20, "autoHeight": true, "layout": "form", "xtype": "panel", "items": email_template3394, "labelAlign": "top" }, { "flex": 20, "autoHeight": true, "layout": "form", "xtype": "panel", "items": attach_to_email3395, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var cal_GuestsByRole_grid3413 = new Lino.cal.GuestsByRole.GridPanel({ "flex": 71, "listeners": { "render": Lino.quicktip_renderer("G\u00e4ste","(cal.cal.GuestsByRole) ") }, "hide_top_toolbar": true, "containing_panel": this, "tools": [ Lino.show_in_own_window_button(Lino.cal.GuestsByRole.grid) ], "preview_limit": 15, "master_panel": this });
    var main_panel3414 = new Ext.Panel({ "autoScroll": false, "border": false, "layout": "vbox", "hideCheckBoxLabels": true, "items": [ main_1_panel3386, main_2_panel3396, cal_GuestsByRole_grid3413 ], "frame": true, "layoutConfig": { "align": "stretch" }, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel3414;
    this.before_row_edit = function(record) {
      template3393.setContextValue('build_method',record ? record.data['build_methodHidden'] : undefined);
      cal_GuestsByRole_grid3413.on_master_changed();
    }
    this.onRender = function(ct, position) {
      build_method3392.on('change',Lino.chooser_handler(template3393,'build_method'));
      Lino.cal.GuestRoles.DetailFormPanel.superclass.onRender.call(this, ct, position);
    }
    Lino.cal.GuestRoles.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.system.Home.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  disable_editing: true,
  initComponent : function() {
    var containing_panel = this;
    var quick_links_htmlbox5121 = new Lino.HtmlBoxPanel({ "flex": 1, "layout": "fit", "name": "quick_links", "containing_panel": this, "items": new Ext.BoxComponent({autoScroll:true}), "region": "north", "bodyStyle": "overflow-x:hidden;", "value": "<br/>", "always_enabled": true, "listeners": { "render": Lino.quicktip_renderer(null,"(system.Home.quick_links) ") }, "split": true });
    var welcome_htmlbox5122 = new Lino.HtmlBoxPanel({ "flex": 3, "layout": "fit", "name": "welcome", "containing_panel": this, "items": new Ext.BoxComponent({autoScroll:true}), "region": "center", "title": "Welcome", "bodyStyle": "overflow-x:hidden;", "value": "<br/>", "always_enabled": true, "listeners": { "render": Lino.quicktip_renderer("Welcome","(system.Home.welcome) ") }, "split": true });
    var main_panel5123 = new Lino.VBorderPanel({ "autoScroll": false, "border": false, "labelWidth": 72, "hideCheckBoxLabels": true, "items": [ quick_links_htmlbox5121, welcome_htmlbox5122 ], "frame": true, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel5123;
    this.before_row_edit = function(record) {
      quick_links_htmlbox5121.refresh();
      welcome_htmlbox5122.refresh();
    }
    Lino.system.Home.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.users.Users.InsertFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  autoHeight: true,
  content_type: 12,
  initComponent : function() {
    var containing_panel = this;
    var username2082 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Username</span>", "name": "username", "listeners": { "render": Lino.quicktip_renderer("Benutzername","(users.Users.username) Required. Must be unique.") }, "maxLength": 30, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var email2083 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "e-mail address", "name": "email", "maxLength": 75, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("e-mail address","(users.Users.email) ") }, "anchor": "-20" });
    var main_1_panel2084 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": username2082, "labelAlign": "top" }, { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": email2083, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 135, "border": false, "anchor": "-20", "labelAlign": "top" });
    var first_name2087 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "First name", "name": "first_name", "maxLength": 30, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Vorname","(users.Users.first_name) ") }, "anchor": "-20" });
    var last_name2088 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Last name", "name": "last_name", "maxLength": 30, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Familienname","(users.Users.last_name) ") }, "anchor": "-20" });
    var main_2_panel2089 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": first_name2087, "labelAlign": "top" }, { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": last_name2088, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 117, "border": false, "anchor": "-20", "labelAlign": "top" });
    var partner2092 = new Lino.TwinCombo({ "preferred_width": 20, "autoHeight": true, "fieldLabel": "Partner", "name": "partner", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.contacts.Partners.detail)}, "hiddenName": "partnerHidden", "listeners": { "render": Lino.quicktip_renderer("Partner","(users.Users.partner) ") }, "selectOnFocus": true, "emptyText": "Select a Partner...", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/users/Users/partner", "method": "GET" }) }) });
    var language2093 = new Lino.ChoicesFieldElement({ "autoHeight": true, "fieldLabel": "Language", "name": "language", "hiddenName": "languageHidden", "listeners": { "render": Lino.quicktip_renderer("Sprache","(users.Users.language) ") }, "selectOnFocus": true, "anchor": "-20", "store": [ [ "en", "English" ], [ "fr", "French" ], [ "de", "German" ], [ "nl", "Dutch" ] ] });
    var profile2094 = new Lino.ChoicesFieldElement({ "autoHeight": true, "forceSelection": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">User Profile</span>", "name": "profile", "hiddenName": "profileHidden", "listeners": { "render": Lino.quicktip_renderer("Benutzerprofil","(users.Users.profile) Users with an empty `profile` field are considered inactive and cannot log in.") }, "selectOnFocus": true, "anchor": "-20", "store": [['','<br>']].concat(Lino.lino.UserProfiles) });
    var main_4_panel2095 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 35, "autoHeight": true, "layout": "form", "xtype": "panel", "items": language2093, "labelAlign": "top" }, { "flex": 64, "autoHeight": true, "layout": "form", "xtype": "panel", "items": profile2094, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 135, "border": false, "anchor": "-20", "labelAlign": "top" });
    var main_panel2098 = new Ext.Panel({ "hideCheckBoxLabels": true, "autoHeight": true, "border": false, "layout": "form", "labelWidth": 72, "autoScroll": false, "items": [ main_1_panel2084, main_2_panel2089, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": partner2092, "anchor": "-20", "labelAlign": "top" }, main_4_panel2095 ], "frame": true, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel2098;
    this.before_row_edit = function(record) {
    }
    Lino.users.Users.InsertFormPanel.superclass.initComponent.call(this);
    // active_fields:
    partner2092.on("change",function(){this.save()},this);
  }
});


Lino.pcsw.Clients.InsertFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  autoHeight: true,
  content_type: 57,
  initComponent : function() {
    var containing_panel = this;
    var first_name350 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "First name", "name": "first_name", "listeners": { "render": Lino.quicktip_renderer("Vorname","(pcsw.Clients.first_name) ") }, "maxLength": 200, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var last_name351 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Last name", "name": "last_name", "listeners": { "render": Lino.quicktip_renderer("Familienname","(pcsw.Clients.last_name) ") }, "maxLength": 200, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var main_1_panel352 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": first_name350, "labelAlign": "top" }, { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": last_name351, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 117, "border": false, "anchor": "-20", "labelAlign": "top" });
    var national_id355 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "National ID", "name": "national_id", "maxLength": 200, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("NR-Nummer","(pcsw.Clients.national_id) ") }, "anchor": "-20" });
    var gender356 = new Lino.ChoicesFieldElement({ "autoHeight": true, "forceSelection": true, "fieldLabel": "Gender", "name": "gender", "hiddenName": "genderHidden", "listeners": { "render": Lino.quicktip_renderer("Geschlecht","(pcsw.Clients.gender) ") }, "selectOnFocus": true, "anchor": "-20", "store": [['','<br>']].concat(Lino.lino.Genders) });
    var language357 = new Lino.ChoicesFieldElement({ "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Language</span>", "allowBlank": false, "hiddenName": "languageHidden", "listeners": { "render": Lino.quicktip_renderer("Sprache","(pcsw.Clients.language) Die Sprache, in der Dokumente ausgestellt werden sollen.") }, "selectOnFocus": true, "anchor": "-20", "store": [ [ "en", "English" ], [ "fr", "French" ], [ "de", "German" ], [ "nl", "Dutch" ] ], "name": "language" });
    var main_3_panel358 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 31, "autoHeight": true, "layout": "form", "xtype": "panel", "items": gender356, "labelAlign": "top" }, { "flex": 68, "autoHeight": true, "layout": "form", "xtype": "panel", "items": language357, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 99, "border": false, "anchor": "-20", "labelAlign": "top" });
    var main_panel361 = new Ext.Panel({ "hideCheckBoxLabels": true, "autoHeight": true, "border": false, "layout": "form", "labelWidth": 90, "autoScroll": false, "items": [ main_1_panel352, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": national_id355, "anchor": "-20", "labelAlign": "top" }, main_3_panel358 ], "frame": true, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel361;
    this.before_row_edit = function(record) {
    }
    Lino.pcsw.Clients.InsertFormPanel.superclass.initComponent.call(this);
  }
});


Lino.properties.PropGroups.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 19,
  initComponent : function() {
    var containing_panel = this;
    var id3234 = new Ext.form.NumberField({ "autoHeight": true, "fieldLabel": "ID", "name": "id", "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("ID","(properties.PropGroups.id) ") }, "anchor": "-20" });
    var name3235 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Designation", "name": "name", "listeners": { "render": Lino.quicktip_renderer("Bezeichnung","(properties.PropGroups.name) ") }, "maxLength": 200, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var name_fr3236 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Designation (fr)", "name": "name_fr", "maxLength": 200, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Bezeichnung (fr)","(properties.PropGroups.name_fr) ") }, "anchor": "-20" });
    var name_de3237 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Designation (de)", "name": "name_de", "maxLength": 200, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Bezeichnung (de)","(properties.PropGroups.name_de) ") }, "anchor": "-20" });
    var name_nl3238 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Designation (nl)", "name": "name_nl", "listeners": { "render": Lino.quicktip_renderer("Bezeichnung (nl)","(properties.PropGroups.name_nl) ") }, "maxLength": 200, "selectOnFocus": true, "hidden": true, "anchor": "-20" });
    var main_1_panel3239 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 153, "hideCheckBoxLabels": true, "items": [ { "flex": 5, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id3234, "labelAlign": "top" }, { "flex": 23, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name3235, "labelAlign": "top" }, { "flex": 23, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_fr3236, "labelAlign": "top" }, { "flex": 23, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_de3237, "labelAlign": "top" }, { "flex": 23, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_nl3238, "hidden": true, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var PropsByGroup_grid3276 = new Lino.properties.PropsByGroup.GridPanel({ "flex": 83, "listeners": { "render": Lino.quicktip_renderer("Eigenschaften","(properties.properties.PropsByGroup) ") }, "hide_top_toolbar": true, "containing_panel": this, "tools": [ Lino.show_in_own_window_button(Lino.properties.PropsByGroup.grid) ], "preview_limit": 15, "master_panel": this });
    var main_panel3277 = new Ext.Panel({ "autoScroll": false, "border": false, "layout": "vbox", "hideCheckBoxLabels": true, "items": [ main_1_panel3239, PropsByGroup_grid3276 ], "frame": true, "layoutConfig": { "align": "stretch" }, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel3277;
    this.before_row_edit = function(record) {
      PropsByGroup_grid3276.on_master_changed();
    }
    Lino.properties.PropGroups.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.jobs.Offers.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 74,
  initComponent : function() {
    var containing_panel = this;
    var name2790 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Name", "name": "name", "maxLength": 100, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Name","(jobs.Offers.name) ") }, "anchor": "-20" });
    var provider2791 = new Lino.TwinCombo({ "preferred_width": 20, "autoHeight": true, "fieldLabel": "Job Provider", "name": "provider", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.jobs.JobProviders.detail)}, "hiddenName": "providerHidden", "listeners": { "render": Lino.quicktip_renderer("Stellenanbieter","(jobs.Offers.provider) ") }, "selectOnFocus": true, "emptyText": "Select a Job Provider...", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/jobs/Offers/provider", "method": "GET" }) }) });
    var sector2792 = new Lino.TwinCombo({ "autoHeight": true, "fieldLabel": "Job Sector", "name": "sector", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.jobs.Sectors.detail)}, "emptyText": "Select a Job Sector...", "listeners": { "render": Lino.quicktip_renderer("Sektor","(jobs.Offers.sector) ") }, "selectOnFocus": true, "hiddenName": "sectorHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/jobs/Offers/sector", "method": "GET" }) }) });
    var function2793 = new Lino.TwinCombo({ "autoHeight": true, "fieldLabel": "Job Function", "name": "function", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.jobs.Functions.detail)}, "emptyText": "Select a Job Function...", "listeners": { "render": Lino.quicktip_renderer("Funktion","(jobs.Offers.function) ") }, "selectOnFocus": true, "hiddenName": "functionHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/jobs/Offers/function", "method": "GET" }) }) });
    var main_1_panel2794 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 144, "hideCheckBoxLabels": true, "items": [ { "flex": 25, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name2790, "labelAlign": "top" }, { "flex": 24, "autoHeight": true, "layout": "form", "xtype": "panel", "items": provider2791, "labelAlign": "top" }, { "flex": 24, "autoHeight": true, "layout": "form", "xtype": "panel", "items": sector2792, "labelAlign": "top" }, { "flex": 24, "autoHeight": true, "layout": "form", "xtype": "panel", "items": function2793, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var selection_from2799 = new Lino.DateField({ "autoHeight": true, "fieldLabel": "selection from", "name": "selection_from", "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Beginn Auswahl","(jobs.Offers.selection_from) ") }, "anchor": "-20" });
    var selection_until2800 = new Lino.DateField({ "autoHeight": true, "fieldLabel": "selection until", "name": "selection_until", "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Ende Auswahl","(jobs.Offers.selection_until) ") }, "anchor": "-20" });
    var start_date2801 = new Lino.DateField({ "autoHeight": true, "fieldLabel": "start date", "name": "start_date", "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Beginndatum","(jobs.Offers.start_date) ") }, "anchor": "-20" });
    var main_2_panel2802 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 135, "hideCheckBoxLabels": true, "items": [ { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": selection_from2799, "labelAlign": "top" }, { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": selection_until2800, "labelAlign": "top" }, { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": start_date2801, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var remark2806 = new Ext.form.TextArea({ "listeners": { "render": Lino.quicktip_renderer("Bemerkung","(jobs.Offers.remark) ") }, "fieldLabel": "Remark", "name": "remark", "growMax": 2000, "selectOnFocus": true, "anchor": "-20 -10" });
    var ExperiencesByOffer_grid2813 = new Lino.jobs.ExperiencesByOffer.GridPanel({ "flex": 53, "listeners": { "render": Lino.quicktip_renderer("Experiences","(jobs.jobs.ExperiencesByOffer) ") }, "hide_top_toolbar": true, "containing_panel": this, "tools": [ Lino.show_in_own_window_button(Lino.jobs.ExperiencesByOffer.grid) ], "preview_limit": 15, "master_panel": this });
    var CandidaturesByOffer_grid2819 = new Lino.jobs.CandidaturesByOffer.GridPanel({ "flex": 46, "listeners": { "render": Lino.quicktip_renderer("Kandidaten","(jobs.jobs.CandidaturesByOffer) ") }, "hide_top_toolbar": true, "containing_panel": this, "tools": [ Lino.show_in_own_window_button(Lino.jobs.CandidaturesByOffer.grid) ], "preview_limit": 15, "master_panel": this });
    var main_4_panel2820 = new Ext.Panel({ "flex": 41, "border": false, "layout": "hbox", "hideCheckBoxLabels": true, "items": [ ExperiencesByOffer_grid2813, CandidaturesByOffer_grid2819 ], "autoScroll": false, "layoutConfig": { "align": "stretch" }, "frame": false, "labelAlign": "top" });
    var main_panel2821 = new Ext.Panel({ "autoScroll": false, "border": false, "layout": "vbox", "labelWidth": 90, "hideCheckBoxLabels": true, "items": [ main_1_panel2794, main_2_panel2802, { "items": remark2806, "labelAlign": "top", "layout": "form", "xtype": "panel", "flex": 41 }, main_4_panel2820 ], "frame": true, "layoutConfig": { "align": "stretch" }, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel2821;
    this.before_row_edit = function(record) {
      function2793.setContextValue('sector',record ? record.data['sectorHidden'] : undefined);
      ExperiencesByOffer_grid2813.on_master_changed();
      CandidaturesByOffer_grid2819.on_master_changed();
    }
    this.onRender = function(ct, position) {
      sector2792.on('change',Lino.chooser_handler(function2793,'sector'));
      Lino.jobs.Offers.DetailFormPanel.superclass.onRender.call(this, ct, position);
    }
    Lino.jobs.Offers.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.reception.WaitingVisitors.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 41,
  disable_editing: true,
  initComponent : function() {
    var containing_panel = this;
    var event2681 = new Lino.TwinCombo({ "autoHeight": true, "fieldLabel": "Event", "allowBlank": false, "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.cal.OneEvent.detail)}, "emptyText": "Select a Event...", "listeners": { "render": Lino.quicktip_renderer("Termin","(reception.WaitingVisitors.event) ") }, "selectOnFocus": true, "hiddenName": "eventHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/reception/WaitingVisitors/event", "method": "GET" }) }), "name": "event" });
    var client2682 = new Lino.TwinCombo({ "preferred_width": 20, "autoHeight": true, "fieldLabel": "Client", "name": "client", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.pcsw.Clients.detail)}, "hiddenName": "clientHidden", "disabled": true, "listeners": { "render": Lino.quicktip_renderer("Klient","(reception.WaitingVisitors.client) ") }, "emptyText": "Select a Client...", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({  }) });
    var role2683 = new Lino.TwinCombo({ "autoHeight": true, "fieldLabel": "Role", "name": "role", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.cal.GuestRoles.detail)}, "emptyText": "Select a Guest Role...", "listeners": { "render": Lino.quicktip_renderer("Rolle","(reception.WaitingVisitors.role) ") }, "selectOnFocus": true, "hiddenName": "roleHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/reception/WaitingVisitors/role", "method": "GET" }) }) });
    var main_1_panel2684 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 63, "hideCheckBoxLabels": true, "items": [ { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": event2681, "labelAlign": "top" }, { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": client2682, "labelAlign": "top" }, { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": role2683, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var state2688 = new Lino.ChoicesFieldElement({ "autoHeight": true, "forceSelection": true, "fieldLabel": "State", "allowBlank": false, "hiddenName": "stateHidden", "listeners": { "render": Lino.quicktip_renderer("Zustand","(reception.WaitingVisitors.state) ") }, "selectOnFocus": true, "anchor": "-20", "store": Lino.cal.GuestStates, "name": "state" });
    var remark2689 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Remark", "name": "remark", "maxLength": 200, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Bemerkung","(reception.WaitingVisitors.remark) ") }, "anchor": "-20" });
    var workflow_buttons_disp2690 = new Ext.form.DisplayField({ "autoHeight": true, "fieldLabel": "Workflow", "name": "workflow_buttons", "value": "<br/>", "always_enabled": true, "disabled": true, "listeners": { "render": Lino.quicktip_renderer("Arbeitsablauf","(reception.WaitingVisitors.workflow_buttons) ") }, "anchor": "-20" });
    var main_2_panel2691 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 126, "hideCheckBoxLabels": true, "items": [ { "flex": 17, "autoHeight": true, "layout": "form", "xtype": "panel", "items": state2688, "labelAlign": "top" }, { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": remark2689, "labelAlign": "top" }, { "flex": 48, "autoHeight": true, "layout": "form", "xtype": "panel", "items": workflow_buttons_disp2690, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var outbox_MailsByController_grid2695 = new Lino.outbox.MailsByController.GridPanel({ "flex": 55, "listeners": { "render": Lino.quicktip_renderer("E-Mail-Ausg\u00e4nge","(outbox.outbox.MailsByController) ") }, "hide_top_toolbar": true, "containing_panel": this, "tools": [ Lino.show_in_own_window_button(Lino.outbox.MailsByController.grid) ], "preview_limit": 15, "master_panel": this });
    var main_panel2696 = new Ext.Panel({ "autoScroll": false, "border": false, "layout": "vbox", "hideCheckBoxLabels": true, "items": [ main_1_panel2684, main_2_panel2691, outbox_MailsByController_grid2695 ], "frame": true, "layoutConfig": { "align": "stretch" }, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel2696;
    this.before_row_edit = function(record) {
      outbox_MailsByController_grid2695.on_master_changed();
    }
    Lino.reception.WaitingVisitors.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.households.Types.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 45,
  initComponent : function() {
    var containing_panel = this;
    var name3576 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Designation", "name": "name", "listeners": { "render": Lino.quicktip_renderer("Bezeichnung","(households.Types.name) ") }, "maxLength": 200, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var name_fr3577 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Designation (fr)", "name": "name_fr", "maxLength": 200, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Bezeichnung (fr)","(households.Types.name_fr) ") }, "anchor": "-20" });
    var name_de3578 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Designation (de)", "name": "name_de", "maxLength": 200, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Bezeichnung (de)","(households.Types.name_de) ") }, "anchor": "-20" });
    var name_nl3579 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Designation (nl)", "name": "name_nl", "listeners": { "render": Lino.quicktip_renderer("Bezeichnung (nl)","(households.Types.name_nl) ") }, "maxLength": 200, "selectOnFocus": true, "hidden": true, "anchor": "-20" });
    var main_1_panel3580 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 153, "hideCheckBoxLabels": true, "items": [ { "flex": 25, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name3576, "labelAlign": "top" }, { "flex": 25, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_fr3577, "labelAlign": "top" }, { "flex": 25, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_de3578, "labelAlign": "top" }, { "flex": 25, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_nl3579, "hidden": true, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var HouseholdsByType_grid3612 = new Lino.households.HouseholdsByType.GridPanel({ "flex": 83, "listeners": { "render": Lino.quicktip_renderer("Haushalte","(households.households.HouseholdsByType) ") }, "hide_top_toolbar": true, "containing_panel": this, "tools": [ Lino.show_in_own_window_button(Lino.households.HouseholdsByType.grid) ], "preview_limit": 15, "master_panel": this });
    var main_panel3613 = new Ext.Panel({ "autoScroll": false, "border": false, "layout": "vbox", "hideCheckBoxLabels": true, "items": [ main_1_panel3580, HouseholdsByType_grid3612 ], "frame": true, "layoutConfig": { "align": "stretch" }, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel3613;
    this.before_row_edit = function(record) {
      HouseholdsByType_grid3612.on_master_changed();
    }
    Lino.households.Types.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.courses.CourseContents.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 85,
  initComponent : function() {
    var containing_panel = this;
    var id4265 = new Ext.form.NumberField({ "autoHeight": true, "fieldLabel": "ID", "name": "id", "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("ID","(courses.CourseContents.id) ") }, "anchor": "-20" });
    var name4266 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Name", "name": "name", "maxLength": 200, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Name","(courses.CourseContents.name) ") }, "anchor": "-20" });
    var main_1_panel4267 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 19, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id4265, "labelAlign": "top" }, { "flex": 80, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name4266, "labelAlign": "top" } ], "region": "north", "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "split": true, "autoScroll": false, "labelWidth": 45, "border": false, "frame": false, "labelAlign": "top" });
    var courses_CourseOffersByContent_grid4274 = new Lino.courses.CourseOffersByContent.GridPanel({ "flex": 5, "hide_top_toolbar": true, "containing_panel": this, "region": "center", "preview_limit": 15, "master_panel": this, "listeners": { "render": Lino.quicktip_renderer("Kursangebote","(courses.courses.CourseOffersByContent) ") }, "split": true, "tools": [ Lino.show_in_own_window_button(Lino.courses.CourseOffersByContent.grid) ] });
    var courses_CourseRequestsByContent_grid4285 = new Lino.courses.CourseRequestsByContent.GridPanel({ "flex": 5, "hide_top_toolbar": true, "containing_panel": this, "region": "south", "preview_limit": 15, "master_panel": this, "listeners": { "render": Lino.quicktip_renderer("Kursanfragen","(courses.courses.CourseRequestsByContent) ") }, "split": true, "tools": [ Lino.show_in_own_window_button(Lino.courses.CourseRequestsByContent.grid) ] });
    var main_panel4286 = new Lino.VBorderPanel({ "autoScroll": false, "border": false, "hideCheckBoxLabels": true, "items": [ main_1_panel4267, courses_CourseOffersByContent_grid4274, courses_CourseRequestsByContent_grid4285 ], "frame": true, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel4286;
    this.before_row_edit = function(record) {
      courses_CourseOffersByContent_grid4274.on_master_changed();
      courses_CourseRequestsByContent_grid4285.on_master_changed();
    }
    Lino.courses.CourseContents.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.cal.Guests.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 41,
  initComponent : function() {
    var containing_panel = this;
    var event1492 = new Lino.TwinCombo({ "autoHeight": true, "fieldLabel": "Event", "allowBlank": false, "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.cal.OneEvent.detail)}, "emptyText": "Select a Event...", "listeners": { "render": Lino.quicktip_renderer("Termin","(cal.Guests.event) ") }, "selectOnFocus": true, "hiddenName": "eventHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/Guests/event", "method": "GET" }) }), "name": "event" });
    var partner1493 = new Lino.TwinCombo({ "preferred_width": 20, "autoHeight": true, "fieldLabel": "Partner", "allowBlank": false, "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.contacts.Partners.detail)}, "emptyText": "Select a Partner...", "listeners": { "render": Lino.quicktip_renderer("Partner","(cal.Guests.partner) ") }, "selectOnFocus": true, "hiddenName": "partnerHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/Guests/partner", "method": "GET" }) }), "name": "partner" });
    var role1494 = new Lino.TwinCombo({ "autoHeight": true, "fieldLabel": "Role", "name": "role", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.cal.GuestRoles.detail)}, "emptyText": "Select a Guest Role...", "listeners": { "render": Lino.quicktip_renderer("Rolle","(cal.Guests.role) ") }, "selectOnFocus": true, "hiddenName": "roleHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/Guests/role", "method": "GET" }) }) });
    var main_1_panel1495 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 72, "hideCheckBoxLabels": true, "items": [ { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": event1492, "labelAlign": "top" }, { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": partner1493, "labelAlign": "top" }, { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": role1494, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var state1499 = new Lino.ChoicesFieldElement({ "autoHeight": true, "forceSelection": true, "fieldLabel": "State", "allowBlank": false, "hiddenName": "stateHidden", "listeners": { "render": Lino.quicktip_renderer("Zustand","(cal.Guests.state) ") }, "selectOnFocus": true, "anchor": "-20", "store": Lino.cal.GuestStates, "name": "state" });
    var remark1500 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Remark", "name": "remark", "maxLength": 200, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Bemerkung","(cal.Guests.remark) ") }, "anchor": "-20" });
    var workflow_buttons_disp1501 = new Ext.form.DisplayField({ "autoHeight": true, "fieldLabel": "Workflow", "name": "workflow_buttons", "value": "<br/>", "always_enabled": true, "disabled": true, "listeners": { "render": Lino.quicktip_renderer("Arbeitsablauf","(cal.Guests.workflow_buttons) ") }, "anchor": "-20" });
    var main_2_panel1502 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 126, "hideCheckBoxLabels": true, "items": [ { "flex": 17, "autoHeight": true, "layout": "form", "xtype": "panel", "items": state1499, "labelAlign": "top" }, { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": remark1500, "labelAlign": "top" }, { "flex": 48, "autoHeight": true, "layout": "form", "xtype": "panel", "items": workflow_buttons_disp1501, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var waiting_since1506 = new Ext.form.DisplayField({ "disabled": true, "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Waiting since</span>", "name": "waiting_since", "listeners": { "render": Lino.quicktip_renderer("Wartet seit","(cal.Guests.waiting_since) Time when the visitor arrived (checked in).") }, "value": "<br>", "anchor": "-20" });
    var busy_since1507 = new Ext.form.DisplayField({ "disabled": true, "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Waiting until</span>", "name": "busy_since", "listeners": { "render": Lino.quicktip_renderer("Hat gewartet bis","(cal.Guests.busy_since) Time when the visitor was received by agent.") }, "value": "<br>", "anchor": "-20" });
    var gone_since1508 = new Ext.form.DisplayField({ "disabled": true, "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Present until</span>", "name": "gone_since", "listeners": { "render": Lino.quicktip_renderer("Anwesend bis","(cal.Guests.gone_since) Time when the visitor left (checked out).") }, "value": "<br>", "anchor": "-20" });
    var main_3_panel1509 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 153, "hideCheckBoxLabels": true, "items": [ { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": waiting_since1506, "labelAlign": "top" }, { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": busy_since1507, "labelAlign": "top" }, { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": gone_since1508, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var outbox_MailsByController_grid1513 = new Lino.outbox.MailsByController.GridPanel({ "flex": 50, "listeners": { "render": Lino.quicktip_renderer("E-Mail-Ausg\u00e4nge","(outbox.outbox.MailsByController) ") }, "hide_top_toolbar": true, "containing_panel": this, "tools": [ Lino.show_in_own_window_button(Lino.outbox.MailsByController.grid) ], "preview_limit": 15, "master_panel": this });
    var main_panel1514 = new Ext.Panel({ "autoScroll": false, "border": false, "layout": "vbox", "hideCheckBoxLabels": true, "items": [ main_1_panel1495, main_2_panel1502, main_3_panel1509, outbox_MailsByController_grid1513 ], "frame": true, "layoutConfig": { "align": "stretch" }, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel1514;
    this.before_row_edit = function(record) {
      outbox_MailsByController_grid1513.on_master_changed();
    }
    Lino.cal.Guests.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.contacts.Companies.InsertFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  autoHeight: true,
  content_type: 24,
  initComponent : function() {
    var containing_panel = this;
    var name501 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Name", "name": "name", "listeners": { "render": Lino.quicktip_renderer("Name","(contacts.Companies.name) ") }, "maxLength": 200, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var language502 = new Lino.ChoicesFieldElement({ "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Language</span>", "allowBlank": false, "hiddenName": "languageHidden", "listeners": { "render": Lino.quicktip_renderer("Sprache","(contacts.Companies.language) Die Sprache, in der Dokumente ausgestellt werden sollen.") }, "selectOnFocus": true, "anchor": "-20", "store": [ [ "en", "English" ], [ "fr", "French" ], [ "de", "German" ], [ "nl", "Dutch" ] ], "name": "language" });
    var email503 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "E-Mail", "name": "email", "maxLength": 75, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("E-Mail","(contacts.Companies.email) ") }, "anchor": "-20" });
    var main_2_panel504 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": language502, "labelAlign": "top" }, { "flex": 66, "autoHeight": true, "layout": "form", "xtype": "panel", "items": email503, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 72, "border": false, "anchor": "-20", "labelAlign": "top" });
    var type507 = new Lino.RemoteComboFieldElement({ "autoHeight": true, "fieldLabel": "Company type", "name": "type", "pageSize": 20, "emptyText": "Select a company type...", "listeners": { "render": Lino.quicktip_renderer("Organisationsart","(contacts.Companies.type) ") }, "selectOnFocus": true, "hiddenName": "typeHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/contacts/Companies/type", "method": "GET" }) }) });
    var id508 = new Ext.form.NumberField({ "autoHeight": true, "fieldLabel": "ID", "name": "id", "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("ID","(contacts.Companies.id) ") }, "anchor": "-20" });
    var main_3_panel509 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 80, "autoHeight": true, "layout": "form", "xtype": "panel", "items": type507, "labelAlign": "top" }, { "flex": 20, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id508, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 153, "border": false, "anchor": "-20", "labelAlign": "top" });
    var main_panel512 = new Ext.Panel({ "hideCheckBoxLabels": true, "autoHeight": true, "border": false, "layout": "form", "labelWidth": 45, "autoScroll": false, "items": [ { "autoHeight": true, "layout": "form", "xtype": "panel", "items": name501, "anchor": "-20", "labelAlign": "top" }, main_2_panel504, main_3_panel509 ], "frame": true, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel512;
    this.before_row_edit = function(record) {
    }
    Lino.contacts.Companies.InsertFormPanel.superclass.initComponent.call(this);
  }
});


Lino.jobs.Schedules.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 72,
  initComponent : function() {
    var containing_panel = this;
    var id4176 = new Ext.form.NumberField({ "autoHeight": true, "fieldLabel": "ID", "name": "id", "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("ID","(jobs.Schedules.id) ") }, "anchor": "-20" });
    var name4177 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Designation", "name": "name", "listeners": { "render": Lino.quicktip_renderer("Bezeichnung","(jobs.Schedules.name) ") }, "maxLength": 200, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var name_fr4178 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Designation (fr)", "name": "name_fr", "maxLength": 200, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Bezeichnung (fr)","(jobs.Schedules.name_fr) ") }, "anchor": "-20" });
    var name_de4179 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Designation (de)", "name": "name_de", "maxLength": 200, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Bezeichnung (de)","(jobs.Schedules.name_de) ") }, "anchor": "-20" });
    var name_nl4180 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Designation (nl)", "name": "name_nl", "listeners": { "render": Lino.quicktip_renderer("Bezeichnung (nl)","(jobs.Schedules.name_nl) ") }, "maxLength": 200, "selectOnFocus": true, "hidden": true, "anchor": "-20" });
    var main_1_panel4181 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 153, "hideCheckBoxLabels": true, "items": [ { "flex": 5, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id4176, "labelAlign": "top" }, { "flex": 23, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name4177, "labelAlign": "top" }, { "flex": 23, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_fr4178, "labelAlign": "top" }, { "flex": 23, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_de4179, "labelAlign": "top" }, { "flex": 23, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_nl4180, "hidden": true, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var ContractsBySchedule_grid4214 = new Lino.jobs.ContractsBySchedule.GridPanel({ "flex": 83, "hide_top_toolbar": true, "containing_panel": this, "params_panel_hidden": true, "master_panel": this, "preview_limit": 15, "listeners": { "render": Lino.quicktip_renderer("Art.60\u00a77-Konventionen","(jobs.jobs.ContractsBySchedule) ") }, "tools": [ Lino.show_in_own_window_button(Lino.jobs.ContractsBySchedule.grid) ] });
    var main_panel4215 = new Ext.Panel({ "autoScroll": false, "border": false, "layout": "vbox", "hideCheckBoxLabels": true, "items": [ main_1_panel4181, ContractsBySchedule_grid4214 ], "frame": true, "layoutConfig": { "align": "stretch" }, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel4215;
    this.before_row_edit = function(record) {
      ContractsBySchedule_grid4214.on_master_changed();
    }
    Lino.jobs.Schedules.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.cal.Calendars.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 38,
  initComponent : function() {
    var containing_panel = this;
    var type3440 = new Lino.ChoicesFieldElement({ "autoHeight": true, "fieldLabel": "Type", "allowBlank": false, "value": "local", "hiddenName": "typeHidden", "listeners": { "render": Lino.quicktip_renderer("Art","(cal.Calendars.type) ") }, "selectOnFocus": true, "anchor": "-20", "store": [ [ "local", "Local Calendar" ], [ "google", "Google Calendar" ] ], "name": "type" });
    var name3441 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Designation", "name": "name", "listeners": { "render": Lino.quicktip_renderer("Bezeichnung","(cal.Calendars.name) ") }, "maxLength": 200, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var name_fr3442 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Designation (fr)", "name": "name_fr", "maxLength": 200, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Bezeichnung (fr)","(cal.Calendars.name_fr) ") }, "anchor": "-20" });
    var name_de3443 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Designation (de)", "name": "name_de", "maxLength": 200, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Bezeichnung (de)","(cal.Calendars.name_de) ") }, "anchor": "-20" });
    var name_nl3444 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Designation (nl)", "name": "name_nl", "listeners": { "render": Lino.quicktip_renderer("Bezeichnung (nl)","(cal.Calendars.name_nl) ") }, "maxLength": 200, "selectOnFocus": true, "hidden": true, "anchor": "-20" });
    var id3445 = new Ext.form.NumberField({ "autoHeight": true, "fieldLabel": "ID", "name": "id", "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("ID","(cal.Calendars.id) ") }, "anchor": "-20" });
    var main_1_panel3446 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 153, "hideCheckBoxLabels": true, "items": [ { "flex": 18, "autoHeight": true, "layout": "form", "xtype": "panel", "items": type3440, "labelAlign": "top" }, { "flex": 19, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name3441, "labelAlign": "top" }, { "flex": 19, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_fr3442, "labelAlign": "top" }, { "flex": 19, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_de3443, "labelAlign": "top" }, { "flex": 19, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_nl3444, "hidden": true, "labelAlign": "top" }, { "flex": 4, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id3445, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var invite_team_members3453 = new Lino.RemoteComboFieldElement({ "autoHeight": true, "fieldLabel": "Team", "name": "invite_team_members", "pageSize": 20, "emptyText": "Select a Team...", "listeners": { "render": Lino.quicktip_renderer("Team","(cal.Calendars.invite_team_members) ") }, "selectOnFocus": true, "hiddenName": "invite_team_membersHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/Calendars/invite_team_members", "method": "GET" }) }) });
    var event_label3454 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Event label", "name": "event_label", "value": "Appointment", "listeners": { "render": Lino.quicktip_renderer("Event label","(cal.Calendars.event_label) ") }, "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var event_label_fr3455 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Event label (fr)", "name": "event_label_fr", "maxLength": 200, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Event label (fr)","(cal.Calendars.event_label_fr) ") }, "anchor": "-20" });
    var event_label_de3456 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Event label (de)", "name": "event_label_de", "maxLength": 200, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Event label (de)","(cal.Calendars.event_label_de) ") }, "anchor": "-20" });
    var event_label_nl3457 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Event label (nl)", "name": "event_label_nl", "listeners": { "render": Lino.quicktip_renderer("Event label (nl)","(cal.Calendars.event_label_nl) ") }, "maxLength": 200, "selectOnFocus": true, "hidden": true, "anchor": "-20" });
    var main_2_panel3458 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 153, "hideCheckBoxLabels": true, "items": [ { "flex": 19, "autoHeight": true, "layout": "form", "xtype": "panel", "items": invite_team_members3453, "labelAlign": "top" }, { "flex": 20, "autoHeight": true, "layout": "form", "xtype": "panel", "items": event_label3454, "labelAlign": "top" }, { "flex": 20, "autoHeight": true, "layout": "form", "xtype": "panel", "items": event_label_fr3455, "labelAlign": "top" }, { "flex": 20, "autoHeight": true, "layout": "form", "xtype": "panel", "items": event_label_de3456, "labelAlign": "top" }, { "flex": 20, "autoHeight": true, "layout": "form", "xtype": "panel", "items": event_label_nl3457, "hidden": true, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var url_template3464 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "URL template", "name": "url_template", "maxLength": 200, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("URL-Vorlage","(cal.Calendars.url_template) ") }, "anchor": "-20" });
    var username3465 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Username", "name": "username", "maxLength": 200, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Benutzername","(cal.Calendars.username) ") }, "anchor": "-20" });
    var password3466 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Password", "name": "password", "inputType": "password", "listeners": { "render": Lino.quicktip_renderer("Passwort","(cal.Calendars.password) ") }, "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var main_3_panel3467 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 117, "hideCheckBoxLabels": true, "items": [ { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": url_template3464, "labelAlign": "top" }, { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": username3465, "labelAlign": "top" }, { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": password3466, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var readonly3471 = new Ext.form.Checkbox({ "autoHeight": true, "hideLabel": true, "checked": false, "name": "readonly", "listeners": { "render": Lino.quicktip_renderer("schreibgesch\u00fctzt","(cal.Calendars.readonly) ") }, "boxLabel": "read-only", "selectOnFocus": true, "anchor": "-20" });
    var is_appointment3472 = new Ext.form.Checkbox({ "autoHeight": true, "hideLabel": true, "checked": true, "name": "is_appointment", "listeners": { "render": Lino.quicktip_renderer("Event is an appointment","(cal.Calendars.is_appointment) ") }, "boxLabel": "Event is an appointment", "selectOnFocus": true, "anchor": "-20" });
    var invite_client3473 = new Ext.form.Checkbox({ "autoHeight": true, "hideLabel": true, "checked": false, "name": "invite_client", "listeners": { "render": Lino.quicktip_renderer("Klient einladen","(cal.Calendars.invite_client) ") }, "boxLabel": "Invite client", "selectOnFocus": true, "anchor": "-20" });
    var color3474 = new Ext.form.NumberField({ "autoHeight": true, "fieldLabel": "color", "name": "color", "value": 1, "listeners": { "render": Lino.quicktip_renderer("Farbe","(cal.Calendars.color) ") }, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var start_date3475 = new Lino.DateField({ "autoHeight": true, "fieldLabel": "Start date", "name": "start_date", "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Beginnt am","(cal.Calendars.start_date) ") }, "anchor": "-20" });
    var main_4_panel3476 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 216, "hideCheckBoxLabels": true, "items": [ { "flex": 23, "autoHeight": true, "layout": "form", "xtype": "panel", "items": readonly3471, "labelAlign": "top" }, { "flex": 23, "autoHeight": true, "layout": "form", "xtype": "panel", "items": is_appointment3472, "labelAlign": "top" }, { "flex": 23, "autoHeight": true, "layout": "form", "xtype": "panel", "items": invite_client3473, "labelAlign": "top" }, { "flex": 11, "autoHeight": true, "layout": "form", "xtype": "panel", "items": color3474, "labelAlign": "top" }, { "flex": 18, "autoHeight": true, "layout": "form", "xtype": "panel", "items": start_date3475, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var build_method3482 = new Lino.ChoicesFieldElement({ "autoHeight": true, "fieldLabel": "Build method", "name": "build_method", "hiddenName": "build_methodHidden", "listeners": { "render": Lino.quicktip_renderer("Konstruktionsmethode","(cal.Calendars.build_method) ") }, "selectOnFocus": true, "anchor": "-20", "store": [ [ "appyodt", "AppyOdtBuildMethod" ], [ "appypdf", "AppyPdfBuildMethod" ], [ "appyrtf", "AppyRtfBuildMethod" ], [ "latex", "LatexBuildMethod" ], [ "pisa", "PisaBuildMethod" ], [ "rtf", "RtfBuildMethod" ] ] });
    var template3483 = new Lino.SimpleRemoteComboFieldElement({ "autoHeight": true, "fieldLabel": "Template", "name": "template", "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Vorlage","(cal.Calendars.template) ") }, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/Calendars/template", "method": "GET" }) }), "anchor": "-20" });
    var email_template3484 = new Lino.SimpleRemoteComboFieldElement({ "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Email template</span>", "name": "email_template", "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("E-Mail-Vorlage","(cal.Calendars.email_template) The name of the file to be used as \ntemplate when creating an email from a mailable of this type.") }, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/Calendars/email_template", "method": "GET" }) }), "anchor": "-20" });
    var attach_to_email3485 = new Ext.form.Checkbox({ "autoHeight": true, "hideLabel": true, "checked": false, "name": "attach_to_email", "listeners": { "render": Lino.quicktip_renderer("als Anhang per E-Mail","(cal.Calendars.attach_to_email) Whether the printable file should be attached to the email\nwhen creating an email from a mailable of this type.\n") }, "boxLabel": "Attach to email", "selectOnFocus": true, "anchor": "-20" });
    var main_5_panel3486 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 198, "hideCheckBoxLabels": true, "items": [ { "flex": 40, "autoHeight": true, "layout": "form", "xtype": "panel", "items": build_method3482, "labelAlign": "top" }, { "flex": 20, "autoHeight": true, "layout": "form", "xtype": "panel", "items": template3483, "labelAlign": "top" }, { "flex": 20, "autoHeight": true, "layout": "form", "xtype": "panel", "items": email_template3484, "labelAlign": "top" }, { "flex": 20, "autoHeight": true, "layout": "form", "xtype": "panel", "items": attach_to_email3485, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var EventsByCalendar_grid3517 = new Lino.cal.EventsByCalendar.GridPanel({ "flex": 77, "hide_top_toolbar": true, "containing_panel": this, "params_panel_hidden": true, "master_panel": this, "preview_limit": 15, "listeners": { "render": Lino.quicktip_renderer("Termine","(cal.cal.EventsByCalendar) ") }, "tools": [ Lino.show_in_own_window_button(Lino.cal.EventsByCalendar.grid) ] });
    var SubscriptionsByCalendar_grid3522 = new Lino.cal.SubscriptionsByCalendar.GridPanel({ "flex": 22, "listeners": { "render": Lino.quicktip_renderer("Abonnements","(cal.cal.SubscriptionsByCalendar) ") }, "hide_top_toolbar": true, "containing_panel": this, "tools": [ Lino.show_in_own_window_button(Lino.cal.SubscriptionsByCalendar.grid) ], "preview_limit": 15, "master_panel": this });
    var main_6_panel3523 = new Ext.Panel({ "flex": 50, "border": false, "layout": "hbox", "hideCheckBoxLabels": true, "items": [ EventsByCalendar_grid3517, SubscriptionsByCalendar_grid3522 ], "autoScroll": false, "layoutConfig": { "align": "stretch" }, "frame": false, "labelAlign": "top" });
    var main_panel3524 = new Ext.Panel({ "autoScroll": false, "border": false, "layout": "vbox", "hideCheckBoxLabels": true, "items": [ main_1_panel3446, main_2_panel3458, main_3_panel3467, main_4_panel3476, main_5_panel3486, main_6_panel3523 ], "frame": true, "layoutConfig": { "align": "stretch" }, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel3524;
    this.before_row_edit = function(record) {
      template3483.setContextValue('build_method',record ? record.data['build_methodHidden'] : undefined);
      EventsByCalendar_grid3517.on_master_changed();
      SubscriptionsByCalendar_grid3522.on_master_changed();
    }
    this.onRender = function(ct, position) {
      build_method3482.on('change',Lino.chooser_handler(template3483,'build_method'));
      Lino.cal.Calendars.DetailFormPanel.superclass.onRender.call(this, ct, position);
    }
    Lino.cal.Calendars.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.newcomers.Faculties.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 89,
  initComponent : function() {
    var containing_panel = this;
    var id4297 = new Ext.form.NumberField({ "autoHeight": true, "fieldLabel": "ID", "name": "id", "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("ID","(newcomers.Faculties.id) ") }, "anchor": "-20" });
    var name4298 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Designation", "name": "name", "listeners": { "render": Lino.quicktip_renderer("Bezeichnung","(newcomers.Faculties.name) ") }, "maxLength": 200, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var name_fr4299 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Designation (fr)", "name": "name_fr", "maxLength": 200, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Bezeichnung (fr)","(newcomers.Faculties.name_fr) ") }, "anchor": "-20" });
    var name_de4300 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Designation (de)", "name": "name_de", "maxLength": 200, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Bezeichnung (de)","(newcomers.Faculties.name_de) ") }, "anchor": "-20" });
    var name_nl4301 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Designation (nl)", "name": "name_nl", "listeners": { "render": Lino.quicktip_renderer("Bezeichnung (nl)","(newcomers.Faculties.name_nl) ") }, "maxLength": 200, "selectOnFocus": true, "hidden": true, "anchor": "-20" });
    var weight4302 = new Ext.form.NumberField({ "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Work effort</span>", "name": "weight", "value": 10, "listeners": { "render": Lino.quicktip_renderer("Aufwand","(newcomers.Faculties.weight) Wieviel Aufwand ein Neuantrag in diesem Fachbereich allgemein verursacht\n(0 = gar kein Aufwand, 10 = maximaler Aufwand).") }, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var main_1_panel4303 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 5, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id4297, "labelAlign": "top" }, { "flex": 22, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name4298, "labelAlign": "top" }, { "flex": 22, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_fr4299, "labelAlign": "top" }, { "flex": 22, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_de4300, "labelAlign": "top" }, { "flex": 22, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_nl4301, "hidden": true, "labelAlign": "top" }, { "flex": 5, "autoHeight": true, "layout": "form", "xtype": "panel", "items": weight4302, "labelAlign": "top" } ], "region": "north", "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "split": true, "autoScroll": false, "labelWidth": 153, "border": false, "frame": false, "labelAlign": "top" });
    var CompetencesByFaculty_grid4315 = new Lino.newcomers.CompetencesByFaculty.GridPanel({ "flex": 5, "hide_top_toolbar": true, "containing_panel": this, "region": "center", "preview_limit": 15, "master_panel": this, "listeners": { "render": Lino.quicktip_renderer("Kompetenzen","(newcomers.newcomers.CompetencesByFaculty) ") }, "split": true, "tools": [ Lino.show_in_own_window_button(Lino.newcomers.CompetencesByFaculty.grid) ] });
    var ClientsByFaculty_grid4389 = new Lino.newcomers.ClientsByFaculty.GridPanel({ "flex": 5, "hide_top_toolbar": true, "containing_panel": this, "region": "south", "params_panel_hidden": true, "master_panel": this, "preview_limit": 15, "listeners": { "render": Lino.quicktip_renderer("Klienten","(newcomers.newcomers.ClientsByFaculty) ") }, "split": true, "tools": [ Lino.show_in_own_window_button(Lino.newcomers.ClientsByFaculty.grid) ] });
    var main_panel4390 = new Lino.VBorderPanel({ "autoScroll": false, "border": false, "hideCheckBoxLabels": true, "items": [ main_1_panel4303, CompetencesByFaculty_grid4315, ClientsByFaculty_grid4389 ], "frame": true, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel4390;
    this.before_row_edit = function(record) {
      CompetencesByFaculty_grid4315.on_master_changed();
      ClientsByFaculty_grid4389.on_master_changed();
    }
    Lino.newcomers.Faculties.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.isip.Contracts.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 64,
  initComponent : function() {
    var containing_panel = this;
    var id2235 = new Ext.form.NumberField({ "autoHeight": true, "fieldLabel": "ID", "name": "id", "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("ID","(isip.Contracts.id) ") }, "anchor": "-20" });
    var client2236 = new Lino.TwinCombo({ "preferred_width": 20, "autoHeight": true, "fieldLabel": "Client", "allowBlank": false, "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.pcsw.Clients.detail)}, "emptyText": "Select a Client...", "listeners": { "render": Lino.quicktip_renderer("Klient","(isip.Contracts.client) ") }, "selectOnFocus": true, "hiddenName": "clientHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/isip/Contracts/client", "method": "GET" }) }), "name": "client" });
    var type2237 = new Lino.TwinCombo({ "preferred_width": 20, "autoHeight": true, "fieldLabel": "Contract Type", "name": "type", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.isip.ContractTypes.detail)}, "hiddenName": "typeHidden", "listeners": { "render": Lino.quicktip_renderer("Vertragsart","(isip.Contracts.type) ") }, "selectOnFocus": true, "emptyText": "Select a ISIP Type...", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/isip/Contracts/type", "method": "GET" }) }) });
    var user2238 = new Lino.TwinCombo({ "preferred_width": 15, "autoHeight": true, "fieldLabel": "Author", "name": "user", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.users.Users.detail)}, "hiddenName": "userHidden", "listeners": { "render": Lino.quicktip_renderer("Autor","(isip.Contracts.user) ") }, "selectOnFocus": true, "emptyText": "Select a User...", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/isip/Contracts/user", "method": "GET" }) }) });
    var user_asd2239 = new Lino.TwinCombo({ "preferred_width": 15, "autoHeight": true, "fieldLabel": "responsible (ASD)", "name": "user_asd", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.users.Users.detail)}, "hiddenName": "user_asdHidden", "listeners": { "render": Lino.quicktip_renderer("Verantwortlicher (ASD)","(isip.Contracts.user_asd) ") }, "selectOnFocus": true, "emptyText": "Select a User...", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/isip/Contracts/user_asd", "method": "GET" }) }) });
    var general_1_panel2240 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 207, "hideCheckBoxLabels": true, "items": [ { "flex": 9, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id2235, "labelAlign": "top" }, { "flex": 30, "autoHeight": true, "layout": "form", "xtype": "panel", "items": client2236, "labelAlign": "top" }, { "flex": 24, "autoHeight": true, "layout": "form", "xtype": "panel", "items": type2237, "labelAlign": "top" }, { "flex": 18, "autoHeight": true, "layout": "form", "xtype": "panel", "items": user2238, "labelAlign": "top" }, { "flex": 18, "autoHeight": true, "layout": "form", "xtype": "panel", "items": user_asd2239, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var study_type2246 = new Lino.TwinCombo({ "autoHeight": true, "fieldLabel": "study type", "name": "study_type", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.isip.StudyTypes.detail)}, "emptyText": "Select a study type...", "listeners": { "render": Lino.quicktip_renderer("Ausbildungsart","(isip.Contracts.study_type) ") }, "selectOnFocus": true, "hiddenName": "study_typeHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/isip/Contracts/study_type", "method": "GET" }) }) });
    var company2247 = new Lino.TwinCombo({ "preferred_width": 20, "autoHeight": true, "fieldLabel": "Company", "name": "company", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.contacts.Companies.detail)}, "hiddenName": "companyHidden", "listeners": { "render": Lino.quicktip_renderer("Organisation","(isip.Contracts.company) ") }, "selectOnFocus": true, "emptyText": "Select a Company...", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/isip/Contracts/company", "method": "GET" }) }) });
    var contact_person2248 = new Lino.TwinCombo({ "preferred_width": 20, "autoHeight": true, "fieldLabel": "represented by", "name": "contact_person", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.contacts.Persons.detail)}, "hiddenName": "contact_personHidden", "listeners": { "render": Lino.quicktip_renderer("Vertreten durch","(isip.Contracts.contact_person) ") }, "selectOnFocus": true, "emptyText": "Select a Person...", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/isip/Contracts/contact_person", "method": "GET" }) }) });
    var contact_role2249 = new Lino.RemoteComboFieldElement({ "autoHeight": true, "fieldLabel": "represented as", "name": "contact_role", "pageSize": 20, "emptyText": "Select a Function...", "listeners": { "render": Lino.quicktip_renderer("in seiner Eigenschaft als","(isip.Contracts.contact_role) ") }, "selectOnFocus": true, "hiddenName": "contact_roleHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/isip/Contracts/contact_role", "method": "GET" }) }) });
    var general_2_panel2250 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 234, "hideCheckBoxLabels": true, "items": [ { "flex": 25, "autoHeight": true, "layout": "form", "xtype": "panel", "items": study_type2246, "labelAlign": "top" }, { "flex": 25, "autoHeight": true, "layout": "form", "xtype": "panel", "items": company2247, "labelAlign": "top" }, { "flex": 25, "autoHeight": true, "layout": "form", "xtype": "panel", "items": contact_person2248, "labelAlign": "top" }, { "flex": 25, "autoHeight": true, "layout": "form", "xtype": "panel", "items": contact_role2249, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var applies_from2255 = new Lino.DateField({ "autoHeight": true, "fieldLabel": "applies from", "name": "applies_from", "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Laufzeit von","(isip.Contracts.applies_from) ") }, "anchor": "-20" });
    var applies_until2256 = new Lino.DateField({ "autoHeight": true, "fieldLabel": "applies until", "name": "applies_until", "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Laufzeit bis","(isip.Contracts.applies_until) ") }, "anchor": "-20" });
    var exam_policy2257 = new Lino.TwinCombo({ "autoHeight": true, "fieldLabel": "Examination Policy", "name": "exam_policy", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.isip.ExamPolicies.detail)}, "emptyText": "Select a Examination Policy...", "listeners": { "render": Lino.quicktip_renderer("Auswertungsstrategie","(isip.Contracts.exam_policy) ") }, "selectOnFocus": true, "hiddenName": "exam_policyHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/isip/Contracts/exam_policy", "method": "GET" }) }) });
    var language2258 = new Lino.ChoicesFieldElement({ "autoHeight": true, "fieldLabel": "Language", "allowBlank": false, "hiddenName": "languageHidden", "listeners": { "render": Lino.quicktip_renderer("Sprache","(isip.Contracts.language) ") }, "selectOnFocus": true, "anchor": "-20", "store": [ [ "en", "English" ], [ "fr", "French" ], [ "de", "German" ], [ "nl", "Dutch" ] ], "name": "language" });
    var general_3_panel2259 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 189, "hideCheckBoxLabels": true, "items": [ { "flex": 18, "autoHeight": true, "layout": "form", "xtype": "panel", "items": applies_from2255, "labelAlign": "top" }, { "flex": 18, "autoHeight": true, "layout": "form", "xtype": "panel", "items": applies_until2256, "labelAlign": "top" }, { "flex": 45, "autoHeight": true, "layout": "form", "xtype": "panel", "items": exam_policy2257, "labelAlign": "top" }, { "flex": 18, "autoHeight": true, "layout": "form", "xtype": "panel", "items": language2258, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var date_decided2264 = new Lino.DateField({ "autoHeight": true, "fieldLabel": "date decided", "name": "date_decided", "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Beschlossen am","(isip.Contracts.date_decided) ") }, "anchor": "-20" });
    var date_issued2265 = new Lino.DateField({ "autoHeight": true, "fieldLabel": "date issued", "name": "date_issued", "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Ausgestellt am","(isip.Contracts.date_issued) ") }, "anchor": "-20" });
    var date_ended2266 = new Lino.DateField({ "autoHeight": true, "fieldLabel": "date ended", "name": "date_ended", "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Enddatum","(isip.Contracts.date_ended) ") }, "anchor": "-20" });
    var ending2267 = new Lino.TwinCombo({ "autoHeight": true, "fieldLabel": "Reason of termination", "name": "ending", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.isip.ContractEndings.detail)}, "emptyText": "Select a Reason of termination...", "listeners": { "render": Lino.quicktip_renderer("Beendigungsgrund","(isip.Contracts.ending) ") }, "selectOnFocus": true, "hiddenName": "endingHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/isip/Contracts/ending", "method": "GET" }) }) });
    var general_4_panel2268 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 153, "hideCheckBoxLabels": true, "items": [ { "flex": 18, "autoHeight": true, "layout": "form", "xtype": "panel", "items": date_decided2264, "labelAlign": "top" }, { "flex": 18, "autoHeight": true, "layout": "form", "xtype": "panel", "items": date_issued2265, "labelAlign": "top" }, { "flex": 18, "autoHeight": true, "layout": "form", "xtype": "panel", "items": date_ended2266, "labelAlign": "top" }, { "flex": 45, "autoHeight": true, "layout": "form", "xtype": "panel", "items": ending2267, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var cal_TasksByController_grid2273 = new Lino.cal.TasksByController.GridPanel({ "flex": 45, "hide_top_toolbar": true, "containing_panel": this, "params_panel_hidden": true, "master_panel": this, "preview_limit": 15, "listeners": { "render": Lino.quicktip_renderer("Aufgaben","(cal.cal.TasksByController) ") }, "tools": [ Lino.show_in_own_window_button(Lino.cal.TasksByController.grid) ] });
    var cal_EventsByController_grid2274 = new Lino.cal.EventsByController.GridPanel({ "flex": 54, "hide_top_toolbar": true, "containing_panel": this, "params_panel_hidden": true, "master_panel": this, "preview_limit": 15, "listeners": { "render": Lino.quicktip_renderer("Termine","(cal.cal.EventsByController) ") }, "tools": [ Lino.show_in_own_window_button(Lino.cal.EventsByController.grid) ] });
    var general_5_panel2275 = new Ext.Panel({ "flex": 55, "border": false, "layout": "hbox", "hideCheckBoxLabels": true, "items": [ cal_TasksByController_grid2273, cal_EventsByController_grid2274 ], "autoScroll": false, "layoutConfig": { "align": "stretch" }, "frame": false, "labelAlign": "top" });
    var general_panel2276 = new Ext.Panel({ "layout": "vbox", "title": "General", "items": [ general_1_panel2240, general_2_panel2250, general_3_panel2259, general_4_panel2268, general_5_panel2275 ], "frame": true, "layoutConfig": { "align": "stretch" }, "hideCheckBoxLabels": true, "listeners": { "activate": Lino.on_tab_activate }, "autoScroll": false, "border": false, "bodyBorder": false, "labelAlign": "top" });
    var stages2277 = new Lino.RichTextPanel({ "selectOnFocus": true, "flex": 50, "containing_panel": this, "name": "stages", "title": "stages" });
    var goals2278 = new Lino.RichTextPanel({ "selectOnFocus": true, "flex": 50, "containing_panel": this, "name": "goals", "title": "goals" });
    var isip_1_panel2279 = new Ext.Panel({ "flex": 5, "layout": "hbox", "items": [ stages2277, goals2278 ], "region": "north", "layoutConfig": { "align": "stretch" }, "hideCheckBoxLabels": true, "split": true, "autoScroll": false, "labelWidth": 0, "border": false, "frame": false, "labelAlign": "top" });
    var duties_asd2280 = new Lino.RichTextPanel({ "selectOnFocus": true, "flex": 50, "containing_panel": this, "name": "duties_asd", "title": "duties ASD" });
    var duties_dsbe2281 = new Lino.RichTextPanel({ "selectOnFocus": true, "flex": 50, "containing_panel": this, "name": "duties_dsbe", "title": "duties DSBE" });
    var isip_2_panel2282 = new Ext.Panel({ "flex": 5, "layout": "hbox", "items": [ duties_asd2280, duties_dsbe2281 ], "region": "center", "layoutConfig": { "align": "stretch" }, "hideCheckBoxLabels": true, "split": true, "autoScroll": false, "labelWidth": 0, "border": false, "frame": false, "labelAlign": "top" });
    var duties_company2283 = new Lino.RichTextPanel({ "selectOnFocus": true, "flex": 50, "containing_panel": this, "name": "duties_company", "title": "duties company" });
    var duties_person2284 = new Lino.RichTextPanel({ "selectOnFocus": true, "flex": 50, "containing_panel": this, "name": "duties_person", "title": "duties person" });
    var isip_3_panel2285 = new Ext.Panel({ "flex": 5, "layout": "hbox", "items": [ duties_company2283, duties_person2284 ], "region": "south", "layoutConfig": { "align": "stretch" }, "hideCheckBoxLabels": true, "split": true, "autoScroll": false, "labelWidth": 0, "border": false, "frame": false, "labelAlign": "top" });
    var isip_panel2286 = new Lino.VBorderPanel({ "autoScroll": false, "listeners": { "activate": Lino.on_tab_activate }, "border": false, "title": "ISIP", "hideCheckBoxLabels": true, "items": [ isip_1_panel2279, isip_2_panel2282, isip_3_panel2285 ], "frame": true, "bodyBorder": false, "labelAlign": "top" });
    var main_panel2287 = new Ext.TabPanel({ "hideCheckBoxLabels": true, "border": false, "split": true, "autoScroll": false, "items": [ general_panel2276, isip_panel2286 ], "activeTab": 0, "bodyBorder": false, "frame": true, "labelAlign": "top" });
    this.items = main_panel2287;
    this.before_row_edit = function(record) {
      contact_person2248.setContextValue('company',record ? record.data['companyHidden'] : undefined);
      cal_TasksByController_grid2273.on_master_changed();
      cal_EventsByController_grid2274.on_master_changed();
      stages2277.refresh();
      goals2278.refresh();
      duties_asd2280.refresh();
      duties_dsbe2281.refresh();
      duties_company2283.refresh();
      duties_person2284.refresh();
    }
    this.onRender = function(ct, position) {
      company2247.on('change',Lino.chooser_handler(contact_person2248,'company'));
      Lino.isip.Contracts.DetailFormPanel.superclass.onRender.call(this, ct, position);
    }
    Lino.isip.Contracts.DetailFormPanel.superclass.initComponent.call(this);
    // active_fields:
    company2247.on("change",function(){this.save()},this);
  }
});


Lino.isip.ContractTypes.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 65,
  initComponent : function() {
    var containing_panel = this;
    var id3764 = new Ext.form.NumberField({ "autoHeight": true, "fieldLabel": "ID", "name": "id", "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("ID","(isip.ContractTypes.id) ") }, "anchor": "-20" });
    var name3765 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Designation", "name": "name", "listeners": { "render": Lino.quicktip_renderer("Bezeichnung","(isip.ContractTypes.name) ") }, "maxLength": 200, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var name_fr3766 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Designation (fr)", "name": "name_fr", "maxLength": 200, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Bezeichnung (fr)","(isip.ContractTypes.name_fr) ") }, "anchor": "-20" });
    var name_de3767 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Designation (de)", "name": "name_de", "maxLength": 200, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Bezeichnung (de)","(isip.ContractTypes.name_de) ") }, "anchor": "-20" });
    var name_nl3768 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Designation (nl)", "name": "name_nl", "listeners": { "render": Lino.quicktip_renderer("Bezeichnung (nl)","(isip.ContractTypes.name_nl) ") }, "maxLength": 200, "selectOnFocus": true, "hidden": true, "anchor": "-20" });
    var main_1_panel3769 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 153, "hideCheckBoxLabels": true, "items": [ { "flex": 5, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id3764, "labelAlign": "top" }, { "flex": 23, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name3765, "labelAlign": "top" }, { "flex": 23, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_fr3766, "labelAlign": "top" }, { "flex": 23, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_de3767, "labelAlign": "top" }, { "flex": 23, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_nl3768, "hidden": true, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var ref3775 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Reference", "name": "ref", "maxLength": 20, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Referenz","(isip.ContractTypes.ref) ") }, "anchor": "-20" });
    var build_method3776 = new Lino.ChoicesFieldElement({ "autoHeight": true, "fieldLabel": "Build method", "name": "build_method", "hiddenName": "build_methodHidden", "listeners": { "render": Lino.quicktip_renderer("Konstruktionsmethode","(isip.ContractTypes.build_method) ") }, "selectOnFocus": true, "anchor": "-20", "store": [ [ "appyodt", "AppyOdtBuildMethod" ], [ "appypdf", "AppyPdfBuildMethod" ], [ "appyrtf", "AppyRtfBuildMethod" ], [ "latex", "LatexBuildMethod" ], [ "pisa", "PisaBuildMethod" ], [ "rtf", "RtfBuildMethod" ] ] });
    var template3777 = new Lino.SimpleRemoteComboFieldElement({ "autoHeight": true, "fieldLabel": "Template", "name": "template", "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Vorlage","(isip.ContractTypes.template) ") }, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/isip/ContractTypes/template", "method": "GET" }) }), "anchor": "-20" });
    var exam_policy3778 = new Lino.TwinCombo({ "autoHeight": true, "fieldLabel": "Examination Policy", "name": "exam_policy", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.isip.ExamPolicies.detail)}, "emptyText": "Select a Examination Policy...", "listeners": { "render": Lino.quicktip_renderer("Auswertungsstrategie","(isip.ContractTypes.exam_policy) ") }, "selectOnFocus": true, "hiddenName": "exam_policyHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/isip/ContractTypes/exam_policy", "method": "GET" }) }) });
    var needs_study_type3779 = new Ext.form.Checkbox({ "autoHeight": true, "hideLabel": true, "checked": false, "name": "needs_study_type", "listeners": { "render": Lino.quicktip_renderer("erfordert Ausbildungsart ","(isip.ContractTypes.needs_study_type) ") }, "boxLabel": "needs Study type", "selectOnFocus": true, "anchor": "-20" });
    var main_2_panel3780 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 234, "hideCheckBoxLabels": true, "items": [ { "flex": 25, "autoHeight": true, "layout": "form", "xtype": "panel", "items": ref3775, "labelAlign": "top" }, { "flex": 24, "autoHeight": true, "layout": "form", "xtype": "panel", "items": build_method3776, "labelAlign": "top" }, { "flex": 12, "autoHeight": true, "layout": "form", "xtype": "panel", "items": template3777, "labelAlign": "top" }, { "flex": 24, "autoHeight": true, "layout": "form", "xtype": "panel", "items": exam_policy3778, "labelAlign": "top" }, { "flex": 12, "autoHeight": true, "layout": "form", "xtype": "panel", "items": needs_study_type3779, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var ContractsByType_grid3806 = new Lino.isip.ContractsByType.GridPanel({ "flex": 71, "hide_top_toolbar": true, "containing_panel": this, "params_panel_hidden": true, "master_panel": this, "preview_limit": 15, "listeners": { "render": Lino.quicktip_renderer("VSEs","(isip.isip.ContractsByType) ") }, "tools": [ Lino.show_in_own_window_button(Lino.isip.ContractsByType.grid) ] });
    var main_panel3807 = new Ext.Panel({ "autoScroll": false, "border": false, "layout": "vbox", "hideCheckBoxLabels": true, "items": [ main_1_panel3769, main_2_panel3780, ContractsByType_grid3806 ], "frame": true, "layoutConfig": { "align": "stretch" }, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel3807;
    this.before_row_edit = function(record) {
      template3777.setContextValue('build_method',record ? record.data['build_methodHidden'] : undefined);
      ContractsByType_grid3806.on_master_changed();
    }
    this.onRender = function(ct, position) {
      build_method3776.on('change',Lino.chooser_handler(template3777,'build_method'));
      Lino.isip.ContractTypes.DetailFormPanel.superclass.onRender.call(this, ct, position);
    }
    Lino.isip.ContractTypes.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.accounts.Groups.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 48,
  initComponent : function() {
    var containing_panel = this;
    var ref3639 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "ref", "name": "ref", "boxMinWidth": Lino.chars2width(5), "listeners": { "render": Lino.quicktip_renderer("ref","(accounts.Groups.ref) ") }, "maxLength": 5, "selectOnFocus": true, "anchor": "-20" });
    var name3640 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Designation", "name": "name", "listeners": { "render": Lino.quicktip_renderer("Bezeichnung","(accounts.Groups.name) ") }, "maxLength": 200, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var name_fr3641 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Designation (fr)", "name": "name_fr", "maxLength": 200, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Bezeichnung (fr)","(accounts.Groups.name_fr) ") }, "anchor": "-20" });
    var name_de3642 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Designation (de)", "name": "name_de", "maxLength": 200, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Bezeichnung (de)","(accounts.Groups.name_de) ") }, "anchor": "-20" });
    var name_nl3643 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Designation (nl)", "name": "name_nl", "listeners": { "render": Lino.quicktip_renderer("Bezeichnung (nl)","(accounts.Groups.name_nl) ") }, "maxLength": 200, "selectOnFocus": true, "hidden": true, "anchor": "-20" });
    var main_1_panel3644 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 153, "hideCheckBoxLabels": true, "items": [ { "flex": 6, "autoHeight": true, "layout": "form", "xtype": "panel", "items": ref3639, "labelAlign": "top" }, { "flex": 23, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name3640, "labelAlign": "top" }, { "flex": 23, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_fr3641, "labelAlign": "top" }, { "flex": 23, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_de3642, "labelAlign": "top" }, { "flex": 23, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_nl3643, "hidden": true, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var account_type3650 = new Lino.ChoicesFieldElement({ "autoHeight": true, "forceSelection": true, "fieldLabel": "Account Type", "name": "account_type", "hiddenName": "account_typeHidden", "listeners": { "render": Lino.quicktip_renderer("Kontenart","(accounts.Groups.account_type) ") }, "selectOnFocus": true, "anchor": "-20", "store": [['','<br>']].concat(Lino.accounts.AccountTypes) });
    var id3651 = new Ext.form.NumberField({ "autoHeight": true, "fieldLabel": "ID", "name": "id", "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("ID","(accounts.Groups.id) ") }, "anchor": "-20" });
    var main_2_panel3652 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 90, "hideCheckBoxLabels": true, "items": [ { "flex": 76, "autoHeight": true, "layout": "form", "xtype": "panel", "items": account_type3650, "labelAlign": "top" }, { "flex": 23, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id3651, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var help_text3655 = new Lino.RichTextPanel({ "selectOnFocus": true, "flex": 41, "containing_panel": this, "name": "help_text", "title": "Introduction" });
    var AccountsByGroup_grid3667 = new Lino.accounts.AccountsByGroup.GridPanel({ "flex": 41, "listeners": { "render": Lino.quicktip_renderer("Konten","(accounts.accounts.AccountsByGroup) ") }, "hide_top_toolbar": true, "containing_panel": this, "tools": [ Lino.show_in_own_window_button(Lino.accounts.AccountsByGroup.grid) ], "preview_limit": 15, "master_panel": this });
    var main_panel3668 = new Ext.Panel({ "autoScroll": false, "border": false, "layout": "vbox", "labelWidth": 0, "hideCheckBoxLabels": true, "items": [ main_1_panel3644, main_2_panel3652, help_text3655, AccountsByGroup_grid3667 ], "frame": true, "layoutConfig": { "align": "stretch" }, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel3668;
    this.before_row_edit = function(record) {
      help_text3655.refresh();
      AccountsByGroup_grid3667.on_master_changed();
    }
    Lino.accounts.Groups.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.jobs.Contracts.InsertFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  autoHeight: true,
  content_type: 75,
  initComponent : function() {
    var containing_panel = this;
    var client1561 = new Lino.TwinCombo({ "preferred_width": 20, "autoHeight": true, "fieldLabel": "Client", "allowBlank": false, "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.pcsw.Clients.detail)}, "emptyText": "Select a Client...", "listeners": { "render": Lino.quicktip_renderer("Klient","(jobs.Contracts.client) ") }, "selectOnFocus": true, "hiddenName": "clientHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/jobs/Contracts/client", "method": "GET" }) }), "name": "client" });
    var job1562 = new Lino.TwinCombo({ "preferred_width": 20, "autoHeight": true, "fieldLabel": "Job", "allowBlank": false, "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.jobs.Jobs.detail)}, "emptyText": "Select a Job...", "listeners": { "render": Lino.quicktip_renderer("Stelle","(jobs.Contracts.job) ") }, "selectOnFocus": true, "hiddenName": "jobHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/jobs/Contracts/job", "method": "GET" }) }), "name": "job" });
    var main_panel1563 = new Ext.Panel({ "hideCheckBoxLabels": true, "autoHeight": true, "border": false, "layout": "form", "labelWidth": 63, "autoScroll": false, "items": [ { "autoHeight": true, "layout": "form", "xtype": "panel", "items": client1561, "anchor": "-20", "labelAlign": "top" }, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": job1562, "anchor": "-20", "labelAlign": "top" } ], "frame": true, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel1563;
    this.before_row_edit = function(record) {
    }
    Lino.jobs.Contracts.InsertFormPanel.superclass.initComponent.call(this);
    // active_fields:
    job1562.on("change",function(){this.save()},this);
  }
});


Lino.notes.Notes.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 98,
  initComponent : function() {
    var containing_panel = this;
    var date203 = new Lino.DateField({ "autoHeight": true, "allowBlank": false, "fieldLabel": "Date", "name": "date", "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Datum","(notes.Notes.date) ") }, "anchor": "-20" });
    var event_type204 = new Lino.TwinCombo({ "autoHeight": true, "fieldLabel": "Event Type (Form)", "name": "event_type", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.notes.EventTypes.detail)}, "emptyText": "Select a Event Type...", "listeners": { "render": Lino.quicktip_renderer("Ereignisart (Form)","(notes.Notes.event_type) ") }, "selectOnFocus": true, "hiddenName": "event_typeHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/notes/Notes/event_type", "method": "GET" }) }) });
    var type205 = new Lino.TwinCombo({ "autoHeight": true, "fieldLabel": "Note Type (Content)", "name": "type", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.notes.NoteTypes.detail)}, "emptyText": "Select a Note Type...", "listeners": { "render": Lino.quicktip_renderer("Notizart (Inhalt)","(notes.Notes.type) ") }, "selectOnFocus": true, "hiddenName": "typeHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/notes/Notes/type", "method": "GET" }) }) });
    var left_1_panel206 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 171, "hideCheckBoxLabels": true, "items": [ { "flex": 16, "autoHeight": true, "layout": "form", "xtype": "panel", "items": date203, "labelAlign": "top" }, { "flex": 41, "autoHeight": true, "layout": "form", "xtype": "panel", "items": event_type204, "labelAlign": "top" }, { "flex": 41, "autoHeight": true, "layout": "form", "xtype": "panel", "items": type205, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var project210 = new Lino.TwinCombo({ "preferred_width": 20, "autoHeight": true, "fieldLabel": "Client", "name": "project", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.pcsw.Clients.detail)}, "hiddenName": "projectHidden", "listeners": { "render": Lino.quicktip_renderer("Klient","(notes.Notes.project) ") }, "selectOnFocus": true, "emptyText": "Select a Client...", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/notes/Notes/project", "method": "GET" }) }) });
    var subject211 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Subject", "name": "subject", "maxLength": 200, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Betreff","(notes.Notes.subject) ") }, "anchor": "-20" });
    var left_2_panel212 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 72, "hideCheckBoxLabels": true, "items": [ { "flex": 48, "autoHeight": true, "layout": "form", "xtype": "panel", "items": project210, "labelAlign": "top" }, { "flex": 51, "autoHeight": true, "layout": "form", "xtype": "panel", "items": subject211, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var company215 = new Lino.TwinCombo({ "preferred_width": 20, "autoHeight": true, "fieldLabel": "Recipient (Organization)", "name": "company", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.contacts.Companies.detail)}, "hiddenName": "companyHidden", "listeners": { "render": Lino.quicktip_renderer("Empf\u00e4nger (Organisation)","(notes.Notes.company) ") }, "selectOnFocus": true, "emptyText": "Select a Company...", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/notes/Notes/company", "method": "GET" }) }) });
    var contact_person216 = new Lino.TwinCombo({ "preferred_width": 20, "autoHeight": true, "fieldLabel": "Recipient (Person)", "name": "contact_person", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.contacts.Persons.detail)}, "hiddenName": "contact_personHidden", "listeners": { "render": Lino.quicktip_renderer("Empf\u00e4nger (Person)","(notes.Notes.contact_person) ") }, "selectOnFocus": true, "emptyText": "Select a Person...", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/notes/Notes/contact_person", "method": "GET" }) }) });
    var left_3_panel217 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 225, "hideCheckBoxLabels": true, "items": [ { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": company215, "labelAlign": "top" }, { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": contact_person216, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var user220 = new Lino.TwinCombo({ "preferred_width": 15, "autoHeight": true, "fieldLabel": "Author", "name": "user", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.users.Users.detail)}, "hiddenName": "userHidden", "listeners": { "render": Lino.quicktip_renderer("Autor","(notes.Notes.user) ") }, "selectOnFocus": true, "emptyText": "Select a User...", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/notes/Notes/user", "method": "GET" }) }) });
    var language221 = new Lino.ChoicesFieldElement({ "autoHeight": true, "fieldLabel": "Language", "allowBlank": false, "hiddenName": "languageHidden", "listeners": { "render": Lino.quicktip_renderer("Sprache","(notes.Notes.language) ") }, "selectOnFocus": true, "anchor": "-20", "store": [ [ "en", "English" ], [ "fr", "French" ], [ "de", "German" ], [ "nl", "Dutch" ] ], "name": "language" });
    var build_time222 = new Ext.form.DisplayField({ "disabled": true, "autoHeight": true, "fieldLabel": "build time", "name": "build_time", "listeners": { "render": Lino.quicktip_renderer("Druckdatum","(notes.Notes.build_time) ") }, "value": "<br>", "anchor": "-20" });
    var id223 = new Ext.form.NumberField({ "autoHeight": true, "fieldLabel": "ID", "name": "id", "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("ID","(notes.Notes.id) ") }, "anchor": "-20" });
    var left_4_panel224 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 99, "hideCheckBoxLabels": true, "items": [ { "flex": 25, "autoHeight": true, "layout": "form", "xtype": "panel", "items": user220, "labelAlign": "top" }, { "flex": 20, "autoHeight": true, "layout": "form", "xtype": "panel", "items": language221, "labelAlign": "top" }, { "flex": 41, "autoHeight": true, "layout": "form", "xtype": "panel", "items": build_time222, "labelAlign": "top" }, { "flex": 12, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id223, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var body229 = new Lino.RichTextPanel({ "selectOnFocus": true, "flex": 55, "containing_panel": this, "name": "body", "title": "Body" });
    var left_panel230 = new Ext.Panel({ "flex": 66, "layout": "vbox", "items": [ left_1_panel206, left_2_panel212, left_3_panel217, left_4_panel224, body229 ], "frame": true, "layoutConfig": { "align": "stretch" }, "autoScroll": false, "hideCheckBoxLabels": true, "labelWidth": 0, "border": false, "bodyBorder": false, "labelAlign": "top" });
    var UploadsByController_htmlbox231 = new Lino.HtmlBoxPanel({ "flex": 3, "ls_bbar_actions": [ { "itemId": "insert", "menu_item_text": "New", "must_save": true, "tooltip": "Insert a new record", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-add", "overflowText": "New", "auto_save": true } ], "name": "UploadsByController", "containing_panel": this, "items": new Ext.BoxComponent({autoScroll:true}), "region": "north", "title": "Uploads", "master_panel": this, "value": "<br/>", "always_enabled": true, "listeners": { "render": Lino.quicktip_renderer("Uploads","(notes.Notes.UploadsByController) ") }, "bodyStyle": "overflow-x:hidden;", "ls_insert_handler": Lino.uploads.UploadsByController.insert, "layout": "fit", "tools": [ Lino.show_in_own_window_button(Lino.uploads.UploadsByController.grid) ], "split": true });
    var outbox_MailsByController_grid277 = new Lino.outbox.MailsByController.GridPanel({ "flex": 5, "hide_top_toolbar": true, "containing_panel": this, "region": "center", "preview_limit": 15, "master_panel": this, "listeners": { "render": Lino.quicktip_renderer("E-Mail-Ausg\u00e4nge","(outbox.outbox.MailsByController) ") }, "split": true, "tools": [ Lino.show_in_own_window_button(Lino.outbox.MailsByController.grid) ] });
    var cal_TasksByController_grid330 = new Lino.cal.TasksByController.GridPanel({ "flex": 5, "hide_top_toolbar": true, "containing_panel": this, "region": "south", "params_panel_hidden": true, "master_panel": this, "preview_limit": 15, "listeners": { "render": Lino.quicktip_renderer("Aufgaben","(cal.cal.TasksByController) ") }, "split": true, "tools": [ Lino.show_in_own_window_button(Lino.cal.TasksByController.grid) ] });
    var right_panel331 = new Lino.VBorderPanel({ "flex": 33, "border": false, "labelWidth": 72, "hideCheckBoxLabels": true, "items": [ UploadsByController_htmlbox231, outbox_MailsByController_grid277, cal_TasksByController_grid330 ], "frame": true, "autoScroll": false, "bodyBorder": false, "labelAlign": "top" });
    var main_1_panel332 = new Ext.Panel({ "autoScroll": false, "border": false, "layout": "hbox", "hideCheckBoxLabels": true, "items": [ left_panel230, right_panel331 ], "frame": false, "layoutConfig": { "align": "stretch" }, "labelAlign": "top" });
    var main_panel333 = new Ext.Panel({ "autoScroll": false, "border": false, "layout": "fit", "hideCheckBoxLabels": true, "items": [ main_1_panel332 ], "frame": true, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel333;
    this.before_row_edit = function(record) {
      contact_person216.setContextValue('company',record ? record.data['companyHidden'] : undefined);
      body229.refresh();
      UploadsByController_htmlbox231.refresh();
      outbox_MailsByController_grid277.on_master_changed();
      cal_TasksByController_grid330.on_master_changed();
    }
    this.onRender = function(ct, position) {
      company215.on('change',Lino.chooser_handler(contact_person216,'company'));
      Lino.notes.Notes.DetailFormPanel.superclass.onRender.call(this, ct, position);
    }
    Lino.notes.Notes.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.jobs.Contracts.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 75,
  initComponent : function() {
    var containing_panel = this;
    var id1352 = new Ext.form.NumberField({ "autoHeight": true, "fieldLabel": "ID", "name": "id", "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("ID","(jobs.Contracts.id) ") }, "anchor": "-20" });
    var client1353 = new Lino.TwinCombo({ "preferred_width": 20, "autoHeight": true, "fieldLabel": "Client", "allowBlank": false, "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.pcsw.Clients.detail)}, "emptyText": "Select a Client...", "listeners": { "render": Lino.quicktip_renderer("Klient","(jobs.Contracts.client) ") }, "selectOnFocus": true, "hiddenName": "clientHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/jobs/Contracts/client", "method": "GET" }) }), "name": "client" });
    var user1354 = new Lino.TwinCombo({ "preferred_width": 15, "autoHeight": true, "fieldLabel": "Author", "name": "user", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.users.Users.detail)}, "hiddenName": "userHidden", "listeners": { "render": Lino.quicktip_renderer("Autor","(jobs.Contracts.user) ") }, "selectOnFocus": true, "emptyText": "Select a User...", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/jobs/Contracts/user", "method": "GET" }) }) });
    var user_asd1355 = new Lino.TwinCombo({ "preferred_width": 15, "autoHeight": true, "fieldLabel": "responsible (ASD)", "name": "user_asd", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.users.Users.detail)}, "hiddenName": "user_asdHidden", "listeners": { "render": Lino.quicktip_renderer("Verantwortlicher (ASD)","(jobs.Contracts.user_asd) ") }, "selectOnFocus": true, "emptyText": "Select a User...", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/jobs/Contracts/user_asd", "method": "GET" }) }) });
    var language1356 = new Lino.ChoicesFieldElement({ "autoHeight": true, "fieldLabel": "Language", "allowBlank": false, "hiddenName": "languageHidden", "listeners": { "render": Lino.quicktip_renderer("Sprache","(jobs.Contracts.language) ") }, "selectOnFocus": true, "anchor": "-20", "store": [ [ "en", "English" ], [ "fr", "French" ], [ "de", "German" ], [ "nl", "Dutch" ] ], "name": "language" });
    var box1_1_panel1357 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 207, "hideCheckBoxLabels": true, "items": [ { "flex": 11, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id1352, "labelAlign": "top" }, { "flex": 35, "autoHeight": true, "layout": "form", "xtype": "panel", "items": client1353, "labelAlign": "top" }, { "flex": 21, "autoHeight": true, "layout": "form", "xtype": "panel", "items": user1354, "labelAlign": "top" }, { "flex": 21, "autoHeight": true, "layout": "form", "xtype": "panel", "items": user_asd1355, "labelAlign": "top" }, { "flex": 11, "autoHeight": true, "layout": "form", "xtype": "panel", "items": language1356, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var job1363 = new Lino.TwinCombo({ "preferred_width": 20, "autoHeight": true, "fieldLabel": "Job", "allowBlank": false, "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.jobs.Jobs.detail)}, "emptyText": "Select a Job...", "listeners": { "render": Lino.quicktip_renderer("Stelle","(jobs.Contracts.job) ") }, "selectOnFocus": true, "hiddenName": "jobHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/jobs/Contracts/job", "method": "GET" }) }), "name": "job" });
    var type1364 = new Lino.TwinCombo({ "preferred_width": 20, "autoHeight": true, "fieldLabel": "Contract Type", "name": "type", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.jobs.ContractTypes.detail)}, "hiddenName": "typeHidden", "listeners": { "render": Lino.quicktip_renderer("Vertragsart","(jobs.Contracts.type) ") }, "selectOnFocus": true, "emptyText": "Select a Job Contract Type...", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/jobs/Contracts/type", "method": "GET" }) }) });
    var company1365 = new Lino.TwinCombo({ "preferred_width": 20, "autoHeight": true, "fieldLabel": "Company", "name": "company", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.contacts.Companies.detail)}, "hiddenName": "companyHidden", "listeners": { "render": Lino.quicktip_renderer("Organisation","(jobs.Contracts.company) ") }, "selectOnFocus": true, "emptyText": "Select a Company...", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/jobs/Contracts/company", "method": "GET" }) }) });
    var contact_person1366 = new Lino.TwinCombo({ "preferred_width": 20, "autoHeight": true, "fieldLabel": "represented by", "name": "contact_person", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.contacts.Persons.detail)}, "hiddenName": "contact_personHidden", "listeners": { "render": Lino.quicktip_renderer("Vertreten durch","(jobs.Contracts.contact_person) ") }, "selectOnFocus": true, "emptyText": "Select a Person...", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/jobs/Contracts/contact_person", "method": "GET" }) }) });
    var contact_role1367 = new Lino.RemoteComboFieldElement({ "autoHeight": true, "fieldLabel": "represented as", "name": "contact_role", "pageSize": 20, "emptyText": "Select a Function...", "listeners": { "render": Lino.quicktip_renderer("in seiner Eigenschaft als","(jobs.Contracts.contact_role) ") }, "selectOnFocus": true, "hiddenName": "contact_roleHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/jobs/Contracts/contact_role", "method": "GET" }) }) });
    var box1_2_panel1368 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 234, "hideCheckBoxLabels": true, "items": [ { "flex": 20, "autoHeight": true, "layout": "form", "xtype": "panel", "items": job1363, "labelAlign": "top" }, { "flex": 20, "autoHeight": true, "layout": "form", "xtype": "panel", "items": type1364, "labelAlign": "top" }, { "flex": 20, "autoHeight": true, "layout": "form", "xtype": "panel", "items": company1365, "labelAlign": "top" }, { "flex": 20, "autoHeight": true, "layout": "form", "xtype": "panel", "items": contact_person1366, "labelAlign": "top" }, { "flex": 20, "autoHeight": true, "layout": "form", "xtype": "panel", "items": contact_role1367, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var applies_from1374 = new Lino.DateField({ "autoHeight": true, "fieldLabel": "applies from", "name": "applies_from", "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Laufzeit von","(jobs.Contracts.applies_from) ") }, "anchor": "-20" });
    var duration1375 = new Lino.SimpleRemoteComboFieldElement({ "autoHeight": true, "fieldLabel": "duration (days)", "name": "duration", "value": null, "listeners": { "render": Lino.quicktip_renderer("Dauer (Arbeitstage)","(jobs.Contracts.duration) ") }, "selectOnFocus": true, "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/jobs/Contracts/duration", "method": "GET" }) }) });
    var applies_until1376 = new Lino.DateField({ "autoHeight": true, "fieldLabel": "applies until", "name": "applies_until", "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Laufzeit bis","(jobs.Contracts.applies_until) ") }, "anchor": "-20" });
    var exam_policy1377 = new Lino.TwinCombo({ "autoHeight": true, "fieldLabel": "Examination Policy", "name": "exam_policy", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.isip.ExamPolicies.detail)}, "emptyText": "Select a Examination Policy...", "listeners": { "render": Lino.quicktip_renderer("Auswertungsstrategie","(jobs.Contracts.exam_policy) ") }, "selectOnFocus": true, "hiddenName": "exam_policyHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/jobs/Contracts/exam_policy", "method": "GET" }) }) });
    var box1_3_panel1378 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 189, "hideCheckBoxLabels": true, "items": [ { "flex": 17, "autoHeight": true, "layout": "form", "xtype": "panel", "items": applies_from1374, "labelAlign": "top" }, { "flex": 21, "autoHeight": true, "layout": "form", "xtype": "panel", "items": duration1375, "labelAlign": "top" }, { "flex": 17, "autoHeight": true, "layout": "form", "xtype": "panel", "items": applies_until1376, "labelAlign": "top" }, { "flex": 43, "autoHeight": true, "layout": "form", "xtype": "panel", "items": exam_policy1377, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var regime1383 = new Lino.TwinCombo({ "autoHeight": true, "fieldLabel": "Work Regime", "name": "regime", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.jobs.Regimes.detail)}, "emptyText": "Select a Work Regime...", "listeners": { "render": Lino.quicktip_renderer("Regime","(jobs.Contracts.regime) ") }, "selectOnFocus": true, "hiddenName": "regimeHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/jobs/Contracts/regime", "method": "GET" }) }) });
    var schedule1384 = new Lino.TwinCombo({ "autoHeight": true, "fieldLabel": "Work Schedule", "name": "schedule", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.jobs.Schedules.detail)}, "emptyText": "Select a Work Schedule...", "listeners": { "render": Lino.quicktip_renderer("Stundenplan","(jobs.Contracts.schedule) ") }, "selectOnFocus": true, "hiddenName": "scheduleHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/jobs/Contracts/schedule", "method": "GET" }) }) });
    var hourly_rate1385 = new Ext.form.NumberField({ "autoHeight": true, "decimalPrecision": 2, "fieldLabel": "hourly rate", "name": "hourly_rate", "decimalSeparator": ",", "listeners": { "render": Lino.quicktip_renderer("Stundensatz","(jobs.Contracts.hourly_rate) ") }, "selectOnFocus": true, "anchor": "-20", "allowBlank": true });
    var refund_rate1386 = new Lino.SimpleRemoteComboFieldElement({ "autoHeight": true, "fieldLabel": "refund rate", "name": "refund_rate", "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("R\u00fcckzahlung","(jobs.Contracts.refund_rate) ") }, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/jobs/Contracts/refund_rate", "method": "GET" }) }), "anchor": "-20" });
    var box1_4_panel1387 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 108, "hideCheckBoxLabels": true, "items": [ { "flex": 28, "autoHeight": true, "layout": "form", "xtype": "panel", "items": regime1383, "labelAlign": "top" }, { "flex": 42, "autoHeight": true, "layout": "form", "xtype": "panel", "items": schedule1384, "labelAlign": "top" }, { "flex": 14, "autoHeight": true, "layout": "form", "xtype": "panel", "items": hourly_rate1385, "labelAlign": "top" }, { "flex": 14, "autoHeight": true, "layout": "form", "xtype": "panel", "items": refund_rate1386, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var reference_person1392 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "reference person", "name": "reference_person", "maxLength": 200, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Referenzperson","(jobs.Contracts.reference_person) ") }, "anchor": "-20" });
    var build_time1393 = new Ext.form.DisplayField({ "disabled": true, "autoHeight": true, "fieldLabel": "build time", "name": "build_time", "listeners": { "render": Lino.quicktip_renderer("Druckdatum","(jobs.Contracts.build_time) ") }, "value": "<br>", "anchor": "-20" });
    var box1_5_panel1394 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 135, "hideCheckBoxLabels": true, "items": [ { "flex": 56, "autoHeight": true, "layout": "form", "xtype": "panel", "items": reference_person1392, "labelAlign": "top" }, { "flex": 43, "autoHeight": true, "layout": "form", "xtype": "panel", "items": build_time1393, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var date_decided1397 = new Lino.DateField({ "autoHeight": true, "fieldLabel": "date decided", "name": "date_decided", "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Beschlossen am","(jobs.Contracts.date_decided) ") }, "anchor": "-20" });
    var date_issued1398 = new Lino.DateField({ "autoHeight": true, "fieldLabel": "date issued", "name": "date_issued", "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Ausgestellt am","(jobs.Contracts.date_issued) ") }, "anchor": "-20" });
    var date_ended1399 = new Lino.DateField({ "autoHeight": true, "fieldLabel": "date ended", "name": "date_ended", "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Enddatum","(jobs.Contracts.date_ended) ") }, "anchor": "-20" });
    var ending1400 = new Lino.TwinCombo({ "autoHeight": true, "fieldLabel": "Reason of termination", "name": "ending", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.isip.ContractEndings.detail)}, "emptyText": "Select a Reason of termination...", "listeners": { "render": Lino.quicktip_renderer("Beendigungsgrund","(jobs.Contracts.ending) ") }, "selectOnFocus": true, "hiddenName": "endingHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/jobs/Contracts/ending", "method": "GET" }) }) });
    var box1_6_panel1401 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 153, "hideCheckBoxLabels": true, "items": [ { "flex": 18, "autoHeight": true, "layout": "form", "xtype": "panel", "items": date_decided1397, "labelAlign": "top" }, { "flex": 18, "autoHeight": true, "layout": "form", "xtype": "panel", "items": date_issued1398, "labelAlign": "top" }, { "flex": 18, "autoHeight": true, "layout": "form", "xtype": "panel", "items": date_ended1399, "labelAlign": "top" }, { "flex": 45, "autoHeight": true, "layout": "form", "xtype": "panel", "items": ending1400, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var responsibilities1406 = new Lino.RichTextPanel({ "selectOnFocus": true, "flex": 45, "containing_panel": this, "name": "responsibilities", "title": "responsibilities" });
    var box1_panel1407 = new Ext.Panel({ "flex": 70, "layout": "vbox", "items": [ box1_1_panel1357, box1_2_panel1368, box1_3_panel1378, box1_4_panel1387, box1_5_panel1394, box1_6_panel1401, responsibilities1406 ], "frame": true, "layoutConfig": { "align": "stretch" }, "autoScroll": false, "hideCheckBoxLabels": true, "labelWidth": 0, "border": false, "bodyBorder": false, "labelAlign": "top" });
    var cal_EventsByController_grid1556 = new Lino.cal.EventsByController.GridPanel({ "flex": 5, "hide_top_toolbar": true, "containing_panel": this, "region": "north", "params_panel_hidden": true, "master_panel": this, "preview_limit": 15, "listeners": { "render": Lino.quicktip_renderer("Termine","(cal.cal.EventsByController) ") }, "split": true, "tools": [ Lino.show_in_own_window_button(Lino.cal.EventsByController.grid) ] });
    var cal_TasksByController_grid1557 = new Lino.cal.TasksByController.GridPanel({ "flex": 5, "hide_top_toolbar": true, "containing_panel": this, "region": "center", "params_panel_hidden": true, "master_panel": this, "preview_limit": 15, "listeners": { "render": Lino.quicktip_renderer("Aufgaben","(cal.cal.TasksByController) ") }, "split": true, "tools": [ Lino.show_in_own_window_button(Lino.cal.TasksByController.grid) ] });
    var right_panel1558 = new Lino.VBorderPanel({ "flex": 30, "border": false, "hideCheckBoxLabels": true, "items": [ cal_EventsByController_grid1556, cal_TasksByController_grid1557 ], "frame": true, "autoScroll": false, "bodyBorder": false, "labelAlign": "top" });
    var main_1_panel1559 = new Ext.Panel({ "autoScroll": false, "border": false, "layout": "hbox", "hideCheckBoxLabels": true, "items": [ box1_panel1407, right_panel1558 ], "frame": false, "layoutConfig": { "align": "stretch" }, "labelAlign": "top" });
    var main_panel1560 = new Ext.Panel({ "autoScroll": false, "border": false, "layout": "fit", "hideCheckBoxLabels": true, "items": [ main_1_panel1559 ], "frame": true, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel1560;
    this.before_row_edit = function(record) {
      contact_person1366.setContextValue('company',record ? record.data['companyHidden'] : undefined);
      responsibilities1406.refresh();
      cal_EventsByController_grid1556.on_master_changed();
      cal_TasksByController_grid1557.on_master_changed();
    }
    this.onRender = function(ct, position) {
      company1365.on('change',Lino.chooser_handler(contact_person1366,'company'));
      Lino.jobs.Contracts.DetailFormPanel.superclass.onRender.call(this, ct, position);
    }
    Lino.jobs.Contracts.DetailFormPanel.superclass.initComponent.call(this);
    // active_fields:
    job1363.on("change",function(){this.save()},this);
    company1365.on("change",function(){this.save()},this);
    contact_person1366.on("change",function(){this.save()},this);
    contact_role1367.on("change",function(){this.save()},this);
  }
});


Lino.uploads.Uploads.InsertFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  autoHeight: true,
  content_type: 30,
  initComponent : function() {
    var containing_panel = this;
    var file4450 = Lino.file_field_handler(this,{ "autoHeight": true, "fieldLabel": "File", "name": "file", "listeners": { "render": Lino.quicktip_renderer("File","(uploads.Uploads.file) ") }, "maxLength": 100, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var user4451 = new Lino.TwinCombo({ "preferred_width": 15, "autoHeight": true, "fieldLabel": "Author", "name": "user", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.users.Users.detail)}, "hiddenName": "userHidden", "listeners": { "render": Lino.quicktip_renderer("Autor","(uploads.Uploads.user) ") }, "selectOnFocus": true, "emptyText": "Select a User...", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/uploads/Uploads/user", "method": "GET" }) }) });
    var main_1_panel4452 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 51, "autoHeight": true, "layout": "form", "xtype": "panel", "items": file4450, "labelAlign": "top" }, { "flex": 48, "autoHeight": true, "layout": "form", "xtype": "panel", "items": user4451, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 54, "border": false, "anchor": "-20", "labelAlign": "top" });
    var type4455 = new Lino.RemoteComboFieldElement({ "autoHeight": true, "fieldLabel": "Upload Type", "name": "type", "pageSize": 20, "emptyText": "Select a Upload Type...", "listeners": { "render": Lino.quicktip_renderer("Upload-Art","(uploads.Uploads.type) ") }, "selectOnFocus": true, "hiddenName": "typeHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/uploads/Uploads/type", "method": "GET" }) }) });
    var valid_until4456 = new Lino.DateField({ "autoHeight": true, "fieldLabel": "valid until", "name": "valid_until", "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("g\u00fcltig bis","(uploads.Uploads.valid_until) ") }, "anchor": "-20" });
    var main_2_panel4457 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 71, "autoHeight": true, "layout": "form", "xtype": "panel", "items": type4455, "labelAlign": "top" }, { "flex": 28, "autoHeight": true, "layout": "form", "xtype": "panel", "items": valid_until4456, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 99, "border": false, "anchor": "-20", "labelAlign": "top" });
    var description4460 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Description", "name": "description", "maxLength": 200, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Beschreibung","(uploads.Uploads.description) ") }, "anchor": "-20" });
    var main_panel4461 = new Ext.Panel({ "hideCheckBoxLabels": true, "autoHeight": true, "border": false, "layout": "form", "labelWidth": 117, "autoScroll": false, "items": [ main_1_panel4452, main_2_panel4457, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": description4460, "anchor": "-20", "labelAlign": "top" } ], "frame": true, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel4461;
    this.before_row_edit = function(record) {
    }
    Lino.uploads.Uploads.InsertFormPanel.superclass.initComponent.call(this);
  }
});

Lino.contacts.Companies.merge_row = new Lino.WindowAction({ "draggable": true, "width": Lino.chars2width(50), "autoHeight": true, "maximizable": true, "modal": true, "maximized": false },function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.contacts.Companies.merge_row_ActionFormPanel({});
});
Lino.cal.GuestStates.wf1 = new Lino.WindowAction({ "draggable": true, "width": Lino.chars2width(50), "maximizable": true, "modal": true, "maximized": false, "height": Lino.rows2height(15) },function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.cal.Guests.wf1_ActionFormPanel({});
});
Lino.cal.GuestStates.wf2 = new Lino.WindowAction({ "draggable": true, "width": Lino.chars2width(50), "maximizable": true, "modal": true, "maximized": false, "height": Lino.rows2height(15) },function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.cal.Guests.wf2_ActionFormPanel({});
});
Lino.cal.Guests.checkin = new Lino.WindowAction({ "draggable": true, "width": Lino.chars2width(50), "maximizable": true, "modal": true, "maximized": false, "height": Lino.rows2height(15) },function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.cal.Guests.checkin_ActionFormPanel({});
});
Lino.pcsw.ClientStates.wf1 = new Lino.WindowAction({ "draggable": true, "width": Lino.chars2width(50), "maximizable": true, "modal": true, "maximized": false, "height": Lino.rows2height(15) },function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.pcsw.Clients.wf1_ActionFormPanel({});
});
Lino.pcsw.Clients.merge_row = new Lino.WindowAction({ "draggable": true, "width": Lino.chars2width(70), "autoHeight": true, "maximizable": true, "modal": true, "maximized": false },function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.pcsw.Clients.merge_row_ActionFormPanel({});
});
Lino.pcsw.Coachings.create_visit = new Lino.WindowAction({ "draggable": true, "width": Lino.chars2width(50), "autoHeight": true, "maximizable": true, "modal": true, "maximized": false },function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.pcsw.Coachings.create_visit_ActionFormPanel({});
});
Lino.reception.Clients.create_visit = new Lino.WindowAction({ "draggable": true, "width": Lino.chars2width(50), "autoHeight": true, "maximizable": true, "modal": true, "maximized": false },function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.reception.Clients.create_visit_ActionFormPanel({});
});
Lino.newcomers.AvailableCoachesByClient.assign_coach = new Lino.WindowAction({ "draggable": true, "width": Lino.chars2width(50), "maximizable": true, "modal": true, "maximized": false, "height": Lino.rows2height(15) },function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.newcomers.AvailableCoachesByClient.assign_coach_ActionFormPanel({});
});

// js_render_GridPanel_class system.SiteConfigs
Lino.system.SiteConfigs.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "No data to display." },
  ls_url : "/system/SiteConfigs",
  ls_bbar_actions : [ { "panel_btn_handler": Lino.list_action_handler('/system/SiteConfigs','as_pdf','GET',Lino.get_current_grid_config), "xtype": "splitbutton", "text": null, "menu": [ { "itemId": "as_pdf", "menu_item_text": "Table (landscape)", "must_save": true, "tooltip": "Show this table as a pdf document", "panel_btn_handler": Lino.list_action_handler('/system/SiteConfigs','as_pdf','GET',Lino.get_current_grid_config), "text": "Table (landscape)", "overflowText": "Table (landscape)", "auto_save": true }, { "itemId": "as_pdf_p", "menu_item_text": "Table (portrait)", "must_save": true, "tooltip": "Show this table as a pdf document", "panel_btn_handler": Lino.list_action_handler('/system/SiteConfigs','as_pdf_p','GET',Lino.get_current_grid_config), "text": "Table (portrait)", "overflowText": "Table (portrait)", "auto_save": true } ], "iconCls": "x-tbar-pdf", "menu_item_text": "Table (landscape)" }, { "itemId": "detail", "menu_item_text": "Detail", "tooltip": "Open a detail window on this record", "panel_btn_handler": Lino.show_detail, "iconCls": "x-tbar-application_form", "overflowText": "Detail", "auto_save": true }, { "itemId": "do_build", "menu_item_text": "Rebuild site cache", "must_save": true, "panel_btn_handler": Lino.row_action_handler('do_build','GET',null), "text": "Rebuild site cache", "overflowText": "Rebuild site cache", "auto_save": true } ],
  cell_edit : true,
  title : "site configs",
  page_length : 20,
  stripeRows : true,
  disabled_actions_index : 52,
  ls_store_fields : [ { "type": "int", "name": "id" }, { "name": "default_build_method" }, 'default_build_methodHidden', { "name": "signer1" }, 'signer1Hidden', { "name": "signer2" }, 'signer2Hidden', { "name": "signer1_function" }, 'signer1_functionHidden', { "name": "signer2_function" }, 'signer2_functionHidden', { "type": "int", "name": "next_partner_id" }, { "name": "site_company" }, 'site_companyHidden', { "name": "client_calendar" }, 'client_calendarHidden', { "name": "client_guestrole" }, 'client_guestroleHidden', { "name": "team_guestrole" }, 'team_guestroleHidden', { "name": "prompt_calendar" }, 'prompt_calendarHidden', { "name": "system_note_type" }, 'system_note_typeHidden', { "name": "propgroup_skills" }, 'propgroup_skillsHidden', { "name": "propgroup_softskills" }, 'propgroup_softskillsHidden', { "name": "propgroup_obstacles" }, 'propgroup_obstaclesHidden', { "name": "attestation_note_nature" }, 'attestation_note_natureHidden', { "name": "job_office" }, 'job_officeHidden', { "name": "residence_permit_upload_type" }, 'residence_permit_upload_typeHidden', { "name": "work_permit_upload_type" }, 'work_permit_upload_typeHidden', { "name": "driving_licence_upload_type" }, 'driving_licence_upload_typeHidden', { "name": "debts_bailiff_type" }, 'debts_bailiff_typeHidden', { "name": "master_budget" }, 'master_budgetHidden', { "name": "sector" }, 'sectorHidden', { "name": "cbss_org_unit" }, { "name": "ssdn_user_id" }, { "name": "ssdn_email" }, { "name": "cbss_http_username" }, { "name": "cbss_http_password" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 0,
  ls_grid_configs : [  ],
  content_type : 4,
  ls_id_property : "id",
  gc_name : 0,
  initComponent : function() {
    this.ls_detail_handler = Lino.system.SiteConfigs.detail;
    var ww = this.containing_window;
    var id3016 = new Ext.form.NumberField({ "selectOnFocus": true });
    var default_build_method3017 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "store": [ [ "appyodt", "AppyOdtBuildMethod" ], [ "appypdf", "AppyPdfBuildMethod" ], [ "appyrtf", "AppyRtfBuildMethod" ], [ "latex", "LatexBuildMethod" ], [ "pisa", "PisaBuildMethod" ], [ "rtf", "RtfBuildMethod" ] ], "value": "appyodt" });
    var signer13018 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "preferred_width": 20, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/system/SiteConfigs/signer1", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a Person..." });
    var signer23019 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "preferred_width": 20, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/system/SiteConfigs/signer2", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a Person..." });
    var signer1_function3020 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/system/SiteConfigs/signer1_function", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a Function..." });
    var signer2_function3021 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/system/SiteConfigs/signer2_function", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a Function..." });
    var next_partner_id3022 = new Ext.form.NumberField({ "selectOnFocus": true, "allowBlank": false, "value": 100 });
    var site_company3023 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "preferred_width": 20, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/system/SiteConfigs/site_company", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a Company..." });
    var client_calendar3024 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/system/SiteConfigs/client_calendar", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a Calendar..." });
    var client_guestrole3025 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/system/SiteConfigs/client_guestrole", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a Guest Role..." });
    var team_guestrole3026 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/system/SiteConfigs/team_guestrole", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a Guest Role..." });
    var prompt_calendar3027 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/system/SiteConfigs/prompt_calendar", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a Calendar..." });
    var system_note_type3028 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/system/SiteConfigs/system_note_type", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a Event Type..." });
    var propgroup_skills3029 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/system/SiteConfigs/propgroup_skills", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a Property Group..." });
    var propgroup_softskills3030 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/system/SiteConfigs/propgroup_softskills", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a Property Group..." });
    var propgroup_obstacles3031 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/system/SiteConfigs/propgroup_obstacles", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a Property Group..." });
    var attestation_note_nature3032 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/system/SiteConfigs/attestation_note_nature", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a Event Type..." });
    var job_office3033 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "preferred_width": 20, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/system/SiteConfigs/job_office", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a Company..." });
    var residence_permit_upload_type3034 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/system/SiteConfigs/residence_permit_upload_type", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a Upload Type..." });
    var work_permit_upload_type3035 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/system/SiteConfigs/work_permit_upload_type", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a Upload Type..." });
    var driving_licence_upload_type3036 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/system/SiteConfigs/driving_licence_upload_type", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a Upload Type..." });
    var debts_bailiff_type3037 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/system/SiteConfigs/debts_bailiff_type", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a Client Contact type..." });
    var master_budget3038 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/system/SiteConfigs/master_budget", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a Budget..." });
    var sector3039 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/system/SiteConfigs/sector", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a Sector..." });
    var cbss_org_unit3040 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 50 });
    var ssdn_user_id3041 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 50 });
    var ssdn_email3042 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 75 });
    var cbss_http_username3043 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 50 });
    var cbss_http_password3044 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 50 });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ new Lino.NullNumberColumn({ "colIndex": 0, "sortable": true, "format": "0", "editable": true, "tooltip": "(system.SiteConfigs.id) ", "filter": { "type": "numeric" }, "header": "ID", "renderer": Lino.id_renderer, "editor": id3016, "width": Lino.chars2width(6), "dataIndex": "id" }), { "colIndex": 1, "sortable": true, "header": "Default build method", "editable": true, "tooltip": "(system.SiteConfigs.default_build_method) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "default_build_method", "editor": default_build_method3017 }, { "colIndex": 2, "sortable": true, "header": "Secretary", "editable": true, "tooltip": "(system.SiteConfigs.signer1) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('signer1Hidden','Lino.contacts.Persons.detail'), "editor": signer13018, "dataIndex": "signer1" }, { "colIndex": 3, "sortable": true, "header": "President", "editable": true, "tooltip": "(system.SiteConfigs.signer2) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('signer2Hidden','Lino.contacts.Persons.detail'), "editor": signer23019, "dataIndex": "signer2" }, { "colIndex": 4, "sortable": true, "header": "First signer function", "editable": true, "tooltip": "(system.SiteConfigs.signer1_function) Contact function to designate the secretary.", "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "signer1_function", "editor": signer1_function3020 }, { "colIndex": 5, "sortable": true, "header": "Second signer function", "editable": true, "tooltip": "(system.SiteConfigs.signer2_function) Contact function to designate the president.", "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "signer2_function", "editor": signer2_function3021 }, new Lino.NullNumberColumn({ "colIndex": 6, "sortable": true, "format": "0", "editable": true, "tooltip": "(system.SiteConfigs.next_partner_id) The next automatic id for any new partner.", "filter": { "type": "numeric" }, "header": "Next partner id", "dataIndex": "next_partner_id", "width": Lino.chars2width(6), "editor": next_partner_id3022 }), { "colIndex": 7, "sortable": true, "header": "The company that runs this site", "editable": true, "tooltip": "(system.SiteConfigs.site_company) The Company to be used as sender in documents.", "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('site_companyHidden','Lino.contacts.Companies.detail'), "editor": site_company3023, "dataIndex": "site_company" }, { "colIndex": 8, "sortable": true, "header": "Default calendar for client events", "editable": true, "tooltip": "(system.SiteConfigs.client_calendar) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('client_calendarHidden','Lino.cal.Calendars.detail'), "editor": client_calendar3024, "dataIndex": "client_calendar" }, { "colIndex": 9, "sortable": true, "header": "Default guest role of client in events.", "editable": true, "tooltip": "(system.SiteConfigs.client_guestrole) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('client_guestroleHidden','Lino.cal.GuestRoles.detail'), "editor": client_guestrole3025, "dataIndex": "client_guestrole" }, { "colIndex": 10, "sortable": true, "header": "Guest role for team members", "editable": true, "tooltip": "(system.SiteConfigs.team_guestrole) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('team_guestroleHidden','Lino.cal.GuestRoles.detail'), "editor": team_guestrole3026, "dataIndex": "team_guestrole" }, { "colIndex": 11, "sortable": true, "header": "Default calendar for prompt events", "editable": true, "tooltip": "(system.SiteConfigs.prompt_calendar) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('prompt_calendarHidden','Lino.cal.Calendars.detail'), "editor": prompt_calendar3027, "dataIndex": "prompt_calendar" }, { "colIndex": 12, "sortable": true, "header": "Default system note type", "editable": true, "tooltip": "(system.SiteConfigs.system_note_type) Note Type used by system notes.\nIf this is empty, then system notes won't create any entry to the Notes table.", "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('system_note_typeHidden','Lino.notes.EventTypes.detail'), "editor": system_note_type3028, "dataIndex": "system_note_type" }, { "colIndex": 13, "sortable": true, "header": "Skills Property Group", "editable": true, "tooltip": "(system.SiteConfigs.propgroup_skills) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('propgroup_skillsHidden','Lino.properties.PropGroups.detail'), "editor": propgroup_skills3029, "dataIndex": "propgroup_skills" }, { "colIndex": 14, "sortable": true, "header": "Soft Skills Property Group", "editable": true, "tooltip": "(system.SiteConfigs.propgroup_softskills) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('propgroup_softskillsHidden','Lino.properties.