#!/usr/bin/env python
# -*- coding: UTF-8 -*-
"""
This is a `Python dump <http://north.lino-framework.org>`_
created using Lino 1.6.11, Jinja 2.6, Sphinx 1.2b1, python-dateutil 2.1, OdfPy ODFPY/0.9.6, docutils 0.8.1, suds 0.4, PyYaml 3.10, Appy 0.8.3 (2013/02/22 15:29), Babel 1.0, djangosite 0.1.7, Django 1.5.1, Python 2.7.3.

"""
from __future__ import unicode_literals
        
import os
os.environ['DJANGO_SETTINGS_MODULE'] = 'lino_welfare.settings.demo'
SOURCE_VERSION = '1.1.9'
from decimal import Decimal
from datetime import datetime as dt
from datetime import time,date
from django.conf import settings

from django.core.management import call_command
#~ settings.SITE.startup()
call_command('initdb')


from django.contrib.contenttypes.models import ContentType
from north.dpy import create_mti_child
from north.dpy import DpyLoader
from north.dbutils import resolve_model
from north.dbutils import set_language

            
def new_content_type_id(m):
    if m is None: return m
    # if not fmn: return None
    # m = resolve_model(fmn)
    ct = ContentType.objects.get_for_model(m)
    if ct is None: return None
    return ct.pk
    

def bv2kw(fieldname,values):
    """
    Needed if `Site.languages` changed between dumpdata and loaddata
    """
    return settings.SITE.babelkw(fieldname,en=values[0],fr=values[1],de=values[2],nl=values[3])
    
accounts_Account = resolve_model("accounts.Account")
accounts_Chart = resolve_model("accounts.Chart")
accounts_Group = resolve_model("accounts.Group")
cal_Calendar = resolve_model("cal.Calendar")
cal_Event = resolve_model("cal.Event")
cal_Guest = resolve_model("cal.Guest")
cal_GuestRole = resolve_model("cal.GuestRole")
cal_Priority = resolve_model("cal.Priority")
cal_Room = resolve_model("cal.Room")
cal_Subscription = resolve_model("cal.Subscription")
cal_Task = resolve_model("cal.Task")
cbss_IdentifyPersonRequest = resolve_model("cbss.IdentifyPersonRequest")
cbss_ManageAccessRequest = resolve_model("cbss.ManageAccessRequest")
cbss_Purpose = resolve_model("cbss.Purpose")
cbss_RetrieveTIGroupsRequest = resolve_model("cbss.RetrieveTIGroupsRequest")
cbss_Sector = resolve_model("cbss.Sector")
changes_Change = resolve_model("changes.Change")
contacts_Company = resolve_model("contacts.Company")
contacts_CompanyType = resolve_model("contacts.CompanyType")
contacts_Partner = resolve_model("contacts.Partner")
contacts_Person = resolve_model("contacts.Person")
contacts_Role = resolve_model("contacts.Role")
contacts_RoleType = resolve_model("contacts.RoleType")
countries_City = resolve_model("countries.City")
countries_Country = resolve_model("countries.Country")
courses_Course = resolve_model("courses.Course")
courses_CourseContent = resolve_model("courses.CourseContent")
courses_CourseOffer = resolve_model("courses.CourseOffer")
courses_CourseProvider = resolve_model("courses.CourseProvider")
courses_CourseRequest = resolve_model("courses.CourseRequest")
cv_LanguageKnowledge = resolve_model("cv.LanguageKnowledge")
debts_Actor = resolve_model("debts.Actor")
debts_Budget = resolve_model("debts.Budget")
debts_Entry = resolve_model("debts.Entry")
households_Household = resolve_model("households.Household")
households_Member = resolve_model("households.Member")
households_Role = resolve_model("households.Role")
households_Type = resolve_model("households.Type")
isip_Contract = resolve_model("isip.Contract")
isip_ContractEnding = resolve_model("isip.ContractEnding")
isip_ContractType = resolve_model("isip.ContractType")
isip_ExamPolicy = resolve_model("isip.ExamPolicy")
isip_StudyType = resolve_model("isip.StudyType")
jobs_Candidature = resolve_model("jobs.Candidature")
jobs_Contract = resolve_model("jobs.Contract")
jobs_ContractType = resolve_model("jobs.ContractType")
jobs_Experience = resolve_model("jobs.Experience")
jobs_Function = resolve_model("jobs.Function")
jobs_Job = resolve_model("jobs.Job")
jobs_JobProvider = resolve_model("jobs.JobProvider")
jobs_JobType = resolve_model("jobs.JobType")
jobs_Offer = resolve_model("jobs.Offer")
jobs_Regime = resolve_model("jobs.Regime")
jobs_Schedule = resolve_model("jobs.Schedule")
jobs_Sector = resolve_model("jobs.Sector")
jobs_Study = resolve_model("jobs.Study")
languages_Language = resolve_model("languages.Language")
newcomers_Broker = resolve_model("newcomers.Broker")
newcomers_Competence = resolve_model("newcomers.Competence")
newcomers_Faculty = resolve_model("newcomers.Faculty")
notes_EventType = resolve_model("notes.EventType")
notes_Note = resolve_model("notes.Note")
notes_NoteType = resolve_model("notes.NoteType")
outbox_Attachment = resolve_model("outbox.Attachment")
outbox_Mail = resolve_model("outbox.Mail")
outbox_Recipient = resolve_model("outbox.Recipient")
pcsw_Activity = resolve_model("pcsw.Activity")
pcsw_AidType = resolve_model("pcsw.AidType")
pcsw_Client = resolve_model("pcsw.Client")
pcsw_ClientContact = resolve_model("pcsw.ClientContact")
pcsw_ClientContactType = resolve_model("pcsw.ClientContactType")
pcsw_Coaching = resolve_model("pcsw.Coaching")
pcsw_CoachingEnding = resolve_model("pcsw.CoachingEnding")
pcsw_CoachingType = resolve_model("pcsw.CoachingType")
pcsw_Dispense = resolve_model("pcsw.Dispense")
pcsw_DispenseReason = resolve_model("pcsw.DispenseReason")
pcsw_Exclusion = resolve_model("pcsw.Exclusion")
pcsw_ExclusionType = resolve_model("pcsw.ExclusionType")
pcsw_PersonGroup = resolve_model("pcsw.PersonGroup")
properties_PersonProperty = resolve_model("properties.PersonProperty")
properties_PropChoice = resolve_model("properties.PropChoice")
properties_PropGroup = resolve_model("properties.PropGroup")
properties_PropType = resolve_model("properties.PropType")
properties_Property = resolve_model("properties.Property")
system_HelpText = resolve_model("system.HelpText")
system_SiteConfig = resolve_model("system.SiteConfig")
system_TextFieldTemplate = resolve_model("system.TextFieldTemplate")
uploads_Upload = resolve_model("uploads.Upload")
uploads_UploadType = resolve_model("uploads.UploadType")
users_Authority = resolve_model("users.Authority")
users_Membership = resolve_model("users.Membership")
users_Team = resolve_model("users.Team")
users_User = resolve_model("users.User")


def create_accounts_chart(id, name):
    kw = dict()
    kw.update(id=id)
    if name is not None: kw.update(bv2kw('name',name))
    return accounts_Chart(**kw)

def create_accounts_group(id, name, chart_id, ref, account_type, help_text):
    kw = dict()
    kw.update(id=id)
    if name is not None: kw.update(bv2kw('name',name))
    kw.update(chart_id=chart_id)
    kw.update(ref=ref)
    kw.update(account_type=account_type)
    kw.update(help_text=help_text)
    return accounts_Group(**kw)

def create_accounts_account(id, name, seqno, chart_id, group_id, ref, type, help_text, required_for_household, required_for_person, periods, default_amount):
    kw = dict()
    kw.update(id=id)
    if name is not None: kw.update(bv2kw('name',name))
    kw.update(seqno=seqno)
    kw.update(chart_id=chart_id)
    kw.update(group_id=group_id)
    kw.update(ref=ref)
    kw.update(type=type)
    kw.update(help_text=help_text)
    kw.update(required_for_household=required_for_household)
    kw.update(required_for_person=required_for_person)
    if periods is not None: periods = Decimal(periods)
    kw.update(periods=periods)
    if default_amount is not None: default_amount = Decimal(default_amount)
    kw.update(default_amount=default_amount)
    return accounts_Account(**kw)

def create_cal_guestrole(id, name, build_method, template, attach_to_email, email_template):
    kw = dict()
    kw.update(id=id)
    if name is not None: kw.update(bv2kw('name',name))
    kw.update(build_method=build_method)
    kw.update(template=template)
    kw.update(attach_to_email=attach_to_email)
    kw.update(email_template=email_template)
    return cal_GuestRole(**kw)

def create_cal_priority(id, name, ref):
    kw = dict()
    kw.update(id=id)
    if name is not None: kw.update(bv2kw('name',name))
    kw.update(ref=ref)
    return cal_Priority(**kw)

def create_cal_room(id, name):
    kw = dict()
    kw.update(id=id)
    if name is not None: kw.update(bv2kw('name',name))
    return cal_Room(**kw)

def create_cbss_purpose(id, name, sector_code, code):
    kw = dict()
    kw.update(id=id)
    if name is not None: kw.update(bv2kw('name',name))
    kw.update(sector_code=sector_code)
    kw.update(code=code)
    return cbss_Purpose(**kw)

def create_cbss_sector(id, name, code, subcode, abbr):
    kw = dict()
    kw.update(id=id)
    if name is not None: kw.update(bv2kw('name',name))
    kw.update(code=code)
    kw.update(subcode=subcode)
    if abbr is not None: kw.update(bv2kw('abbr',abbr))
    return cbss_Sector(**kw)

def create_contacts_companytype(id, name, abbr):
    kw = dict()
    kw.update(id=id)
    if name is not None: kw.update(bv2kw('name',name))
    if abbr is not None: kw.update(bv2kw('abbr',abbr))
    return contacts_CompanyType(**kw)

def create_contacts_roletype(id, name, use_in_contracts):
    kw = dict()
    kw.update(id=id)
    if name is not None: kw.update(bv2kw('name',name))
    kw.update(use_in_contracts=use_in_contracts)
    return contacts_RoleType(**kw)

def create_countries_country(name, isocode, short_code, iso3, inscode):
    kw = dict()
    if name is not None: kw.update(bv2kw('name',name))
    kw.update(isocode=isocode)
    kw.update(short_code=short_code)
    kw.update(iso3=iso3)
    kw.update(inscode=inscode)
    return countries_Country(**kw)

def create_countries_city(id, name, country_id, zip_code, type, parent_id, inscode):
    kw = dict()
    kw.update(id=id)
    if name is not None: kw.update(bv2kw('name',name))
    kw.update(country_id=country_id)
    kw.update(zip_code=zip_code)
    kw.update(type=type)
    kw.update(parent_id=parent_id)
    kw.update(inscode=inscode)
    return countries_City(**kw)

def create_courses_coursecontent(id, name):
    kw = dict()
    kw.update(id=id)
    kw.update(name=name)
    return courses_CourseContent(**kw)

def create_households_role(id, name, name_giving):
    kw = dict()
    kw.update(id=id)
    if name is not None: kw.update(bv2kw('name',name))
    kw.update(name_giving=name_giving)
    return households_Role(**kw)

def create_households_type(id, name):
    kw = dict()
    kw.update(id=id)
    if name is not None: kw.update(bv2kw('name',name))
    return households_Type(**kw)

def create_isip_contractending(id, name, use_in_isip, use_in_jobs, is_success, needs_date_ended):
    kw = dict()
    kw.update(id=id)
    kw.update(name=name)
    kw.update(use_in_isip=use_in_isip)
    kw.update(use_in_jobs=use_in_jobs)
    kw.update(is_success=is_success)
    kw.update(needs_date_ended=needs_date_ended)
    return isip_ContractEnding(**kw)

def create_isip_studytype(id, name):
    kw = dict()
    kw.update(id=id)
    if name is not None: kw.update(bv2kw('name',name))
    return isip_StudyType(**kw)

def create_jobs_jobtype(id, seqno, name, remark):
    kw = dict()
    kw.update(id=id)
    kw.update(seqno=seqno)
    kw.update(name=name)
    kw.update(remark=remark)
    return jobs_JobType(**kw)

def create_jobs_regime(id, name):
    kw = dict()
    kw.update(id=id)
    if name is not None: kw.update(bv2kw('name',name))
    return jobs_Regime(**kw)

def create_jobs_schedule(id, name):
    kw = dict()
    kw.update(id=id)
    if name is not None: kw.update(bv2kw('name',name))
    return jobs_Schedule(**kw)

def create_jobs_sector(id, name, remark):
    kw = dict()
    kw.update(id=id)
    if name is not None: kw.update(bv2kw('name',name))
    kw.update(remark=remark)
    return jobs_Sector(**kw)

def create_jobs_function(id, name, remark, sector_id):
    kw = dict()
    kw.update(id=id)
    if name is not None: kw.update(bv2kw('name',name))
    kw.update(remark=remark)
    kw.update(sector_id=sector_id)
    return jobs_Function(**kw)

def create_languages_language(name, id, iso2):
    kw = dict()
    if name is not None: kw.update(bv2kw('name',name))
    kw.update(id=id)
    kw.update(iso2=iso2)
    return languages_Language(**kw)

def create_newcomers_broker(id, name):
    kw = dict()
    kw.update(id=id)
    kw.update(name=name)
    return newcomers_Broker(**kw)

def create_newcomers_faculty(id, name, weight):
    kw = dict()
    kw.update(id=id)
    if name is not None: kw.update(bv2kw('name',name))
    kw.update(weight=weight)
    return newcomers_Faculty(**kw)

def create_notes_eventtype(id, name, remark, body):
    kw = dict()
    kw.update(id=id)
    if name is not None: kw.update(bv2kw('name',name))
    kw.update(remark=remark)
    kw.update(body=body)
    return notes_EventType(**kw)

def create_notes_notetype(id, name, build_method, template, attach_to_email, email_template, important, remark, body_template, is_attestation):
    kw = dict()
    kw.update(id=id)
    if name is not None: kw.update(bv2kw('name',name))
    kw.update(build_method=build_method)
    kw.update(template=template)
    kw.update(attach_to_email=attach_to_email)
    kw.update(email_template=email_template)
    kw.update(important=important)
    kw.update(remark=remark)
    kw.update(body_template=body_template)
    kw.update(is_attestation=is_attestation)
    return notes_NoteType(**kw)

def create_pcsw_activity(id, name, lst104):
    kw = dict()
    kw.update(id=id)
    kw.update(name=name)
    kw.update(lst104=lst104)
    return pcsw_Activity(**kw)

def create_contacts_partner(id, created, modified, country_id, city_id, region_id, zip_code, name, addr1, street_prefix, street, street_no, street_box, addr2, language, email, url, phone, gsm, fax, remarks, is_obsolete, activity_id, bank_account1, bank_account2):
    kw = dict()
    kw.update(id=id)
    kw.update(created=created)
    kw.update(modified=modified)
    kw.update(country_id=country_id)
    kw.update(city_id=city_id)
    kw.update(region_id=region_id)
    kw.update(zip_code=zip_code)
    kw.update(name=name)
    kw.update(addr1=addr1)
    kw.update(street_prefix=street_prefix)
    kw.update(street=street)
    kw.update(street_no=street_no)
    kw.update(street_box=street_box)
    kw.update(addr2=addr2)
    kw.update(language=language)
    kw.update(email=email)
    kw.update(url=url)
    kw.update(phone=phone)
    kw.update(gsm=gsm)
    kw.update(fax=fax)
    kw.update(remarks=remarks)
    kw.update(is_obsolete=is_obsolete)
    kw.update(activity_id=activity_id)
    kw.update(bank_account1=bank_account1)
    kw.update(bank_account2=bank_account2)
    return contacts_Partner(**kw)

def create_contacts_person(partner_ptr_id, first_name, last_name, gender, birth_date, title, father_id, mother_id):
    return create_mti_child(contacts_Partner,partner_ptr_id,contacts_Person,first_name=first_name,last_name=last_name,gender=gender,birth_date=birth_date,title=title,father_id=father_id,mother_id=mother_id)
def create_households_household(partner_ptr_id, prefix, type_id):
    return create_mti_child(contacts_Partner,partner_ptr_id,households_Household,partner_ptr_id=partner_ptr_id,prefix=prefix,type_id=type_id)
def create_households_member(id, role_id, household_id, person_id, start_date, end_date):
    kw = dict()
    kw.update(id=id)
    kw.update(role_id=role_id)
    kw.update(household_id=household_id)
    kw.update(person_id=person_id)
    kw.update(start_date=start_date)
    kw.update(end_date=end_date)
    return households_Member(**kw)

def create_pcsw_aidtype(id, name):
    kw = dict()
    kw.update(id=id)
    if name is not None: kw.update(bv2kw('name',name))
    return pcsw_AidType(**kw)

def create_pcsw_clientcontacttype(id, name):
    kw = dict()
    kw.update(id=id)
    if name is not None: kw.update(bv2kw('name',name))
    return pcsw_ClientContactType(**kw)

def create_contacts_company(partner_ptr_id, prefix, vat_id, type_id, client_contact_type_id):
    return create_mti_child(contacts_Partner,partner_ptr_id,contacts_Company,prefix=prefix,vat_id=vat_id,type_id=type_id,client_contact_type_id=client_contact_type_id)
def create_contacts_role(id, type_id, person_id, company_id):
    kw = dict()
    kw.update(id=id)
    kw.update(type_id=type_id)
    kw.update(person_id=person_id)
    kw.update(company_id=company_id)
    return contacts_Role(**kw)

def create_courses_courseprovider(company_ptr_id):
    return create_mti_child(contacts_Company,company_ptr_id,courses_CourseProvider)
def create_courses_courseoffer(id, title, content_id, provider_id, description):
    kw = dict()
    kw.update(id=id)
    kw.update(title=title)
    kw.update(content_id=content_id)
    kw.update(provider_id=provider_id)
    kw.update(description=description)
    return courses_CourseOffer(**kw)

def create_courses_course(id, offer_id, title, start_date, remark):
    kw = dict()
    kw.update(id=id)
    kw.update(offer_id=offer_id)
    kw.update(title=title)
    kw.update(start_date=start_date)
    kw.update(remark=remark)
    return courses_Course(**kw)

def create_jobs_jobprovider(company_ptr_id):
    return create_mti_child(contacts_Company,company_ptr_id,jobs_JobProvider)
def create_jobs_offer(id, sector_id, function_id, name, provider_id, selection_from, selection_until, start_date, remark):
    kw = dict()
    kw.update(id=id)
    kw.update(sector_id=sector_id)
    kw.update(function_id=function_id)
    kw.update(name=name)
    kw.update(provider_id=provider_id)
    kw.update(selection_from=selection_from)
    kw.update(selection_until=selection_until)
    kw.update(start_date=start_date)
    kw.update(remark=remark)
    return jobs_Offer(**kw)

def create_pcsw_coachingtype(id, name):
    kw = dict()
    kw.update(id=id)
    if name is not None: kw.update(bv2kw('name',name))
    return pcsw_CoachingType(**kw)

def create_pcsw_coachingending(id, name, seqno, type_id):
    kw = dict()
    kw.update(id=id)
    if name is not None: kw.update(bv2kw('name',name))
    kw.update(seqno=seqno)
    kw.update(type_id=type_id)
    return pcsw_CoachingEnding(**kw)

def create_pcsw_dispensereason(id, name, seqno):
    kw = dict()
    kw.update(id=id)
    if name is not None: kw.update(bv2kw('name',name))
    kw.update(seqno=seqno)
    return pcsw_DispenseReason(**kw)

def create_pcsw_exclusiontype(id, name):
    kw = dict()
    kw.update(id=id)
    kw.update(name=name)
    return pcsw_ExclusionType(**kw)

def create_pcsw_persongroup(id, name, ref_name, active):
    kw = dict()
    kw.update(id=id)
    kw.update(name=name)
    kw.update(ref_name=ref_name)
    kw.update(active=active)
    return pcsw_PersonGroup(**kw)

def create_pcsw_client(person_ptr_id, national_id, nationality_id, card_number, card_valid_from, card_valid_until, card_type, card_issuer, noble_condition, remarks2, gesdos_id, is_cpas, is_senior, group_id, birth_place, birth_country_id, civil_state, health_insurance_id, pharmacy_id, residence_type, in_belgium_since, unemployed_since, needs_residence_permit, needs_work_permit, work_permit_suspended_until, aid_type_id, income_ag, income_wg, income_kg, income_rente, income_misc, is_seeking, unavailable_until, unavailable_why, obstacles, skills, job_agents, job_office_contact_id, client_state, refusal_reason, broker_id, faculty_id):
    return create_mti_child(contacts_Person,person_ptr_id,pcsw_Client,national_id=national_id,nationality_id=nationality_id,card_number=card_number,card_valid_from=card_valid_from,card_valid_until=card_valid_until,card_type=card_type,card_issuer=card_issuer,noble_condition=noble_condition,remarks2=remarks2,gesdos_id=gesdos_id,is_cpas=is_cpas,is_senior=is_senior,group_id=group_id,birth_place=birth_place,birth_country_id=birth_country_id,civil_state=civil_state,health_insurance_id=health_insurance_id,pharmacy_id=pharmacy_id,residence_type=residence_type,in_belgium_since=in_belgium_since,unemployed_since=unemployed_since,needs_residence_permit=needs_residence_permit,needs_work_permit=needs_work_permit,work_permit_suspended_until=work_permit_suspended_until,aid_type_id=aid_type_id,income_ag=income_ag,income_wg=income_wg,income_kg=income_kg,income_rente=income_rente,income_misc=income_misc,is_seeking=is_seeking,unavailable_until=unavailable_until,unavailable_why=unavailable_why,obstacles=obstacles,skills=skills,job_agents=job_agents,job_office_contact_id=job_office_contact_id,client_state=client_state,refusal_reason=refusal_reason,broker_id=broker_id,faculty_id=faculty_id)
def create_courses_courserequest(id, person_id, offer_id, content_id, date_submitted, urgent, state, course_id, remark, date_ended):
    kw = dict()
    kw.update(id=id)
    kw.update(person_id=person_id)
    kw.update(offer_id=offer_id)
    kw.update(content_id=content_id)
    kw.update(date_submitted=date_submitted)
    kw.update(urgent=urgent)
    kw.update(state=state)
    kw.update(course_id=course_id)
    kw.update(remark=remark)
    kw.update(date_ended=date_ended)
    return courses_CourseRequest(**kw)

def create_cv_languageknowledge(id, person_id, language_id, spoken, written, native, cef_level):
    kw = dict()
    kw.update(id=id)
    kw.update(person_id=person_id)
    kw.update(language_id=language_id)
    kw.update(spoken=spoken)
    kw.update(written=written)
    kw.update(native=native)
    kw.update(cef_level=cef_level)
    return cv_LanguageKnowledge(**kw)

def create_jobs_experience(id, sector_id, function_id, person_id, company, title, country_id, started, stopped, remarks):
    kw = dict()
    kw.update(id=id)
    kw.update(sector_id=sector_id)
    kw.update(function_id=function_id)
    kw.update(person_id=person_id)
    kw.update(company=company)
    kw.update(title=title)
    kw.update(country_id=country_id)
    kw.update(started=started)
    kw.update(stopped=stopped)
    kw.update(remarks=remarks)
    return jobs_Experience(**kw)

def create_jobs_study(id, country_id, city_id, person_id, type_id, content, started, stopped, success, language_id, school, remarks):
    kw = dict()
    kw.update(id=id)
    kw.update(country_id=country_id)
    kw.update(city_id=city_id)
    kw.update(person_id=person_id)
    kw.update(type_id=type_id)
    kw.update(content=content)
    kw.update(started=started)
    kw.update(stopped=stopped)
    kw.update(success=success)
    kw.update(language_id=language_id)
    kw.update(school=school)
    kw.update(remarks=remarks)
    return jobs_Study(**kw)

def create_pcsw_clientcontact(id, company_id, contact_person_id, contact_role_id, client_id, type_id, remark):
    kw = dict()
    kw.update(id=id)
    kw.update(company_id=company_id)
    kw.update(contact_person_id=contact_person_id)
    kw.update(contact_role_id=contact_role_id)
    kw.update(client_id=client_id)
    kw.update(type_id=type_id)
    kw.update(remark=remark)
    return pcsw_ClientContact(**kw)

def create_pcsw_dispense(id, client_id, reason_id, remarks, start_date, end_date):
    kw = dict()
    kw.update(id=id)
    kw.update(client_id=client_id)
    kw.update(reason_id=reason_id)
    kw.update(remarks=remarks)
    kw.update(start_date=start_date)
    kw.update(end_date=end_date)
    return pcsw_Dispense(**kw)

def create_pcsw_exclusion(id, person_id, type_id, excluded_from, excluded_until, remark):
    kw = dict()
    kw.update(id=id)
    kw.update(person_id=person_id)
    kw.update(type_id=type_id)
    kw.update(excluded_from=excluded_from)
    kw.update(excluded_until=excluded_until)
    kw.update(remark=remark)
    return pcsw_Exclusion(**kw)

def create_properties_propgroup(id, name):
    kw = dict()
    kw.update(id=id)
    if name is not None: kw.update(bv2kw('name',name))
    return properties_PropGroup(**kw)

def create_properties_proptype(id, name, choicelist, default_value, limit_to_choices, multiple_choices):
    kw = dict()
    kw.update(id=id)
    if name is not None: kw.update(bv2kw('name',name))
    kw.update(choicelist=choicelist)
    kw.update(default_value=default_value)
    kw.update(limit_to_choices=limit_to_choices)
    kw.update(multiple_choices=multiple_choices)
    return properties_PropType(**kw)

def create_properties_propchoice(id, type_id, value, text):
    kw = dict()
    kw.update(id=id)
    kw.update(type_id=type_id)
    kw.update(value=value)
    if text is not None: kw.update(bv2kw('text',text))
    return properties_PropChoice(**kw)

def create_properties_property(id, name, group_id, type_id):
    kw = dict()
    kw.update(id=id)
    if name is not None: kw.update(bv2kw('name',name))
    kw.update(group_id=group_id)
    kw.update(type_id=type_id)
    return properties_Property(**kw)

def create_properties_personproperty(id, group_id, property_id, value, person_id, remark):
    kw = dict()
    kw.update(id=id)
    kw.update(group_id=group_id)
    kw.update(property_id=property_id)
    kw.update(value=value)
    kw.update(person_id=person_id)
    kw.update(remark=remark)
    return properties_PersonProperty(**kw)

def create_system_helptext(id, content_type_id, field, help_text):
    kw = dict()
    kw.update(id=id)
    content_type_id = new_content_type_id(content_type_id)
    kw.update(content_type_id=content_type_id)
    kw.update(field=field)
    kw.update(help_text=help_text)
    return system_HelpText(**kw)

def create_uploads_uploadtype(id, name):
    kw = dict()
    kw.update(id=id)
    kw.update(name=name)
    return uploads_UploadType(**kw)

def create_users_team(id, name):
    kw = dict()
    kw.update(id=id)
    if name is not None: kw.update(bv2kw('name',name))
    return users_Team(**kw)

def create_cal_calendar(id, name, seqno, build_method, template, attach_to_email, email_template, type, description, url_template, username, password, readonly, start_date, color, event_label, invite_team_members_id, invite_client):
    kw = dict()
    kw.update(id=id)
    if name is not None: kw.update(bv2kw('name',name))
    kw.update(seqno=seqno)
    kw.update(build_method=build_method)
    kw.update(template=template)
    kw.update(attach_to_email=attach_to_email)
    kw.update(email_template=email_template)
    kw.update(type=type)
    kw.update(description=description)
    kw.update(url_template=url_template)
    kw.update(username=username)
    kw.update(password=password)
    kw.update(readonly=readonly)
    kw.update(start_date=start_date)
    kw.update(color=color)
    if event_label is not None: kw.update(bv2kw('event_label',event_label))
    kw.update(invite_team_members_id=invite_team_members_id)
    kw.update(invite_client=invite_client)
    return cal_Calendar(**kw)

def create_isip_exampolicy(id, name, start_date, start_time, end_date, end_time, every_unit, every, monday, tuesday, wednesday, thursday, friday, saturday, sunday, max_events, calendar_id):
    kw = dict()
    kw.update(id=id)
    if name is not None: kw.update(bv2kw('name',name))
    kw.update(start_date=start_date)
    kw.update(start_time=start_time)
    kw.update(end_date=end_date)
    kw.update(end_time=end_time)
    kw.update(every_unit=every_unit)
    kw.update(every=every)
    kw.update(monday=monday)
    kw.update(tuesday=tuesday)
    kw.update(wednesday=wednesday)
    kw.update(thursday=thursday)
    kw.update(friday=friday)
    kw.update(saturday=saturday)
    kw.update(sunday=sunday)
    kw.update(max_events=max_events)
    kw.update(calendar_id=calendar_id)
    return isip_ExamPolicy(**kw)

def create_isip_contracttype(id, name, build_method, template, ref, exam_policy_id, needs_study_type):
    kw = dict()
    kw.update(id=id)
    if name is not None: kw.update(bv2kw('name',name))
    kw.update(build_method=build_method)
    kw.update(template=template)
    kw.update(ref=ref)
    kw.update(exam_policy_id=exam_policy_id)
    kw.update(needs_study_type=needs_study_type)
    return isip_ContractType(**kw)

def create_jobs_contracttype(id, name, build_method, template, ref, exam_policy_id):
    kw = dict()
    kw.update(id=id)
    if name is not None: kw.update(bv2kw('name',name))
    kw.update(build_method=build_method)
    kw.update(template=template)
    kw.update(ref=ref)
    kw.update(exam_policy_id=exam_policy_id)
    return jobs_ContractType(**kw)

def create_jobs_job(id, sector_id, function_id, name, type_id, provider_id, contract_type_id, hourly_rate, capacity, remark):
    kw = dict()
    kw.update(id=id)
    kw.update(sector_id=sector_id)
    kw.update(function_id=function_id)
    kw.update(name=name)
    kw.update(type_id=type_id)
    kw.update(provider_id=provider_id)
    kw.update(contract_type_id=contract_type_id)
    if hourly_rate is not None: hourly_rate = Decimal(hourly_rate)
    kw.update(hourly_rate=hourly_rate)
    kw.update(capacity=capacity)
    kw.update(remark=remark)
    return jobs_Job(**kw)

def create_jobs_candidature(id, sector_id, function_id, person_id, job_id, date_submitted, remark, state):
    kw = dict()
    kw.update(id=id)
    kw.update(sector_id=sector_id)
    kw.update(function_id=function_id)
    kw.update(person_id=person_id)
    kw.update(job_id=job_id)
    kw.update(date_submitted=date_submitted)
    kw.update(remark=remark)
    kw.update(state=state)
    return jobs_Candidature(**kw)

def create_users_user(id, created, modified, username, password, profile, initials, first_name, last_name, email, remarks, language, partner_id, access_class, calendar_id, coaching_type_id, coaching_supervisor, newcomer_quota):
    kw = dict()
    kw.update(id=id)
    kw.update(created=created)
    kw.update(modified=modified)
    kw.update(username=username)
    kw.update(password=password)
    kw.update(profile=profile)
    kw.update(initials=initials)
    kw.update(first_name=first_name)
    kw.update(last_name=last_name)
    kw.update(email=email)
    kw.update(remarks=remarks)
    kw.update(language=language)
    kw.update(partner_id=partner_id)
    kw.update(access_class=access_class)
    kw.update(calendar_id=calendar_id)
    kw.update(coaching_type_id=coaching_type_id)
    kw.update(coaching_supervisor=coaching_supervisor)
    kw.update(newcomer_quota=newcomer_quota)
    return users_User(**kw)

def create_cal_event(id, owner_type_id, owner_id, user_id, created, modified, project_id, build_time, start_date, start_time, end_date, end_time, summary, description, uid, calendar_id, access_class, sequence, auto_type, transparent, room_id, priority_id, state, assigned_to_id):
    kw = dict()
    kw.update(id=id)
    owner_type_id = new_content_type_id(owner_type_id)
    kw.update(owner_type_id=owner_type_id)
    kw.update(owner_id=owner_id)
    kw.update(user_id=user_id)
    kw.update(created=created)
    kw.update(modified=modified)
    kw.update(project_id=project_id)
    kw.update(build_time=build_time)
    kw.update(start_date=start_date)
    kw.update(start_time=start_time)
    kw.update(end_date=end_date)
    kw.update(end_time=end_time)
    kw.update(summary=summary)
    kw.update(description=description)
    kw.update(uid=uid)
    kw.update(calendar_id=calendar_id)
    kw.update(access_class=access_class)
    kw.update(sequence=sequence)
    kw.update(auto_type=auto_type)
    kw.update(transparent=transparent)
    kw.update(room_id=room_id)
    kw.update(priority_id=priority_id)
    kw.update(state=state)
    kw.update(assigned_to_id=assigned_to_id)
    return cal_Event(**kw)

def create_cal_guest(id, build_time, event_id, partner_id, role_id, state, remark, waiting_since, waiting_until, present_until):
    kw = dict()
    kw.update(id=id)
    kw.update(build_time=build_time)
    kw.update(event_id=event_id)
    kw.update(partner_id=partner_id)
    kw.update(role_id=role_id)
    kw.update(state=state)
    kw.update(remark=remark)
    kw.update(waiting_since=waiting_since)
    kw.update(waiting_until=waiting_until)
    kw.update(present_until=present_until)
    return cal_Guest(**kw)

def create_cal_subscription(id, user_id, calendar_id, is_hidden):
    kw = dict()
    kw.update(id=id)
    kw.update(user_id=user_id)
    kw.update(calendar_id=calendar_id)
    kw.update(is_hidden=is_hidden)
    return cal_Subscription(**kw)

def create_cal_task(id, owner_type_id, owner_id, user_id, created, modified, project_id, start_date, start_time, summary, description, uid, calendar_id, access_class, sequence, auto_type, due_date, due_time, percent, state):
    kw = dict()
    kw.update(id=id)
    owner_type_id = new_content_type_id(owner_type_id)
    kw.update(owner_type_id=owner_type_id)
    kw.update(owner_id=owner_id)
    kw.update(user_id=user_id)
    kw.update(created=created)
    kw.update(modified=modified)
    kw.update(project_id=project_id)
    kw.update(start_date=start_date)
    kw.update(start_time=start_time)
    kw.update(summary=summary)
    kw.update(description=description)
    kw.update(uid=uid)
    kw.update(calendar_id=calendar_id)
    kw.update(access_class=access_class)
    kw.update(sequence=sequence)
    kw.update(auto_type=auto_type)
    kw.update(due_date=due_date)
    kw.update(due_time=due_time)
    kw.update(percent=percent)
    kw.update(state=state)
    return cal_Task(**kw)

def create_cbss_identifypersonrequest(id, user_id, person_id, sent, status, environment, ticket, request_xml, response_xml, debug_messages, info_messages, national_id, birth_date, sis_card_no, id_card_no, first_name, last_name, middle_name, gender, tolerance):
    kw = dict()
    kw.update(id=id)
    kw.update(user_id=user_id)
    kw.update(person_id=person_id)
    kw.update(sent=sent)
    kw.update(status=status)
    kw.update(environment=environment)
    kw.update(ticket=ticket)
    kw.update(request_xml=request_xml)
    kw.update(response_xml=response_xml)
    kw.update(debug_messages=debug_messages)
    kw.update(info_messages=info_messages)
    kw.update(national_id=national_id)
    kw.update(birth_date=birth_date)
    kw.update(sis_card_no=sis_card_no)
    kw.update(id_card_no=id_card_no)
    kw.update(first_name=first_name)
    kw.update(last_name=last_name)
    kw.update(middle_name=middle_name)
    kw.update(gender=gender)
    kw.update(tolerance=tolerance)
    return cbss_IdentifyPersonRequest(**kw)

def create_cbss_manageaccessrequest(id, user_id, person_id, sent, status, environment, ticket, request_xml, response_xml, debug_messages, info_messages, national_id, birth_date, sis_card_no, id_card_no, first_name, last_name, sector_id, purpose_id, start_date, end_date, action, query_register):
    kw = dict()
    kw.update(id=id)
    kw.update(user_id=user_id)
    kw.update(person_id=person_id)
    kw.update(sent=sent)
    kw.update(status=status)
    kw.update(environment=environment)
    kw.update(ticket=ticket)
    kw.update(request_xml=request_xml)
    kw.update(response_xml=response_xml)
    kw.update(debug_messages=debug_messages)
    kw.update(info_messages=info_messages)
    kw.update(national_id=national_id)
    kw.update(birth_date=birth_date)
    kw.update(sis_card_no=sis_card_no)
    kw.update(id_card_no=id_card_no)
    kw.update(first_name=first_name)
    kw.update(last_name=last_name)
    kw.update(sector_id=sector_id)
    kw.update(purpose_id=purpose_id)
    kw.update(start_date=start_date)
    kw.update(end_date=end_date)
    kw.update(action=action)
    kw.update(query_register=query_register)
    return cbss_ManageAccessRequest(**kw)

def create_cbss_retrievetigroupsrequest(id, user_id, person_id, sent, status, environment, ticket, request_xml, response_xml, debug_messages, info_messages, national_id, language, history):
    kw = dict()
    kw.update(id=id)
    kw.update(user_id=user_id)
    kw.update(person_id=person_id)
    kw.update(sent=sent)
    kw.update(status=status)
    kw.update(environment=environment)
    kw.update(ticket=ticket)
    kw.update(request_xml=request_xml)
    kw.update(response_xml=response_xml)
    kw.update(debug_messages=debug_messages)
    kw.update(info_messages=info_messages)
    kw.update(national_id=national_id)
    kw.update(language=language)
    kw.update(history=history)
    return cbss_RetrieveTIGroupsRequest(**kw)

def create_changes_change(id, time, type, user_id, object_type_id, object_id, master_type_id, master_id, diff):
    kw = dict()
    kw.update(id=id)
    kw.update(time=time)
    kw.update(type=type)
    kw.update(user_id=user_id)
    object_type_id = new_content_type_id(object_type_id)
    kw.update(object_type_id=object_type_id)
    kw.update(object_id=object_id)
    master_type_id = new_content_type_id(master_type_id)
    kw.update(master_type_id=master_type_id)
    kw.update(master_id=master_id)
    kw.update(diff=diff)
    return changes_Change(**kw)

def create_debts_budget(id, user_id, build_time, date, partner_id, print_todos, print_empty_rows, include_yearly_incomes, intro, conclusion, dist_amount):
    kw = dict()
    kw.update(id=id)
    kw.update(user_id=user_id)
    kw.update(build_time=build_time)
    kw.update(date=date)
    kw.update(partner_id=partner_id)
    kw.update(print_todos=print_todos)
    kw.update(print_empty_rows=print_empty_rows)
    kw.update(include_yearly_incomes=include_yearly_incomes)
    kw.update(intro=intro)
    kw.update(conclusion=conclusion)
    if dist_amount is not None: dist_amount = Decimal(dist_amount)
    kw.update(dist_amount=dist_amount)
    return debts_Budget(**kw)

def create_debts_actor(id, seqno, budget_id, partner_id, header, remark):
    kw = dict()
    kw.update(id=id)
    kw.update(seqno=seqno)
    kw.update(budget_id=budget_id)
    kw.update(partner_id=partner_id)
    kw.update(header=header)
    kw.update(remark=remark)
    return debts_Actor(**kw)

def create_debts_entry(id, seqno, budget_id, account_type, account_id, partner_id, amount, actor_id, circa, distribute, todo, remark, description, periods, monthly_rate, bailiff_id):
    kw = dict()
    kw.update(id=id)
    kw.update(seqno=seqno)
    kw.update(budget_id=budget_id)
    kw.update(account_type=account_type)
    kw.update(account_id=account_id)
    kw.update(partner_id=partner_id)
    if amount is not None: amount = Decimal(amount)
    kw.update(amount=amount)
    kw.update(actor_id=actor_id)
    kw.update(circa=circa)
    kw.update(distribute=distribute)
    kw.update(todo=todo)
    kw.update(remark=remark)
    kw.update(description=description)
    if periods is not None: periods = Decimal(periods)
    kw.update(periods=periods)
    if monthly_rate is not None: monthly_rate = Decimal(monthly_rate)
    kw.update(monthly_rate=monthly_rate)
    kw.update(bailiff_id=bailiff_id)
    return debts_Entry(**kw)

def create_isip_contract(id, user_id, build_time, signer1_id, signer2_id, company_id, contact_person_id, contact_role_id, client_id, language, applies_from, applies_until, date_decided, date_issued, user_asd_id, exam_policy_id, ending_id, date_ended, type_id, stages, goals, duties_asd, duties_dsbe, duties_company, duties_person, study_type_id):
    kw = dict()
    kw.update(id=id)
    kw.update(user_id=user_id)
    kw.update(build_time=build_time)
    kw.update(signer1_id=signer1_id)
    kw.update(signer2_id=signer2_id)
    kw.update(company_id=company_id)
    kw.update(contact_person_id=contact_person_id)
    kw.update(contact_role_id=contact_role_id)
    kw.update(client_id=client_id)
    kw.update(language=language)
    kw.update(applies_from=applies_from)
    kw.update(applies_until=applies_until)
    kw.update(date_decided=date_decided)
    kw.update(date_issued=date_issued)
    kw.update(user_asd_id=user_asd_id)
    kw.update(exam_policy_id=exam_policy_id)
    kw.update(ending_id=ending_id)
    kw.update(date_ended=date_ended)
    kw.update(type_id=type_id)
    kw.update(stages=stages)
    kw.update(goals=goals)
    kw.update(duties_asd=duties_asd)
    kw.update(duties_dsbe=duties_dsbe)
    kw.update(duties_company=duties_company)
    kw.update(duties_person=duties_person)
    kw.update(study_type_id=study_type_id)
    return isip_Contract(**kw)

def create_jobs_contract(id, user_id, build_time, signer1_id, signer2_id, company_id, contact_person_id, contact_role_id, client_id, language, applies_from, applies_until, date_decided, date_issued, user_asd_id, exam_policy_id, ending_id, date_ended, type_id, job_id, duration, regime_id, schedule_id, hourly_rate, refund_rate, reference_person, responsibilities, remark):
    kw = dict()
    kw.update(id=id)
    kw.update(user_id=user_id)
    kw.update(build_time=build_time)
    kw.update(signer1_id=signer1_id)
    kw.update(signer2_id=signer2_id)
    kw.update(company_id=company_id)
    kw.update(contact_person_id=contact_person_id)
    kw.update(contact_role_id=contact_role_id)
    kw.update(client_id=client_id)
    kw.update(language=language)
    kw.update(applies_from=applies_from)
    kw.update(applies_until=applies_until)
    kw.update(date_decided=date_decided)
    kw.update(date_issued=date_issued)
    kw.update(user_asd_id=user_asd_id)
    kw.update(exam_policy_id=exam_policy_id)
    kw.update(ending_id=ending_id)
    kw.update(date_ended=date_ended)
    kw.update(type_id=type_id)
    kw.update(job_id=job_id)
    kw.update(duration=duration)
    kw.update(regime_id=regime_id)
    kw.update(schedule_id=schedule_id)
    if hourly_rate is not None: hourly_rate = Decimal(hourly_rate)
    kw.update(hourly_rate=hourly_rate)
    kw.update(refund_rate=refund_rate)
    kw.update(reference_person=reference_person)
    kw.update(responsibilities=responsibilities)
    kw.update(remark=remark)
    return jobs_Contract(**kw)

def create_newcomers_competence(id, user_id, seqno, faculty_id, weight):
    kw = dict()
    kw.update(id=id)
    kw.update(user_id=user_id)
    kw.update(seqno=seqno)
    kw.update(faculty_id=faculty_id)
    kw.update(weight=weight)
    return newcomers_Competence(**kw)

def create_notes_note(id, owner_type_id, owner_id, user_id, project_id, build_time, company_id, contact_person_id, contact_role_id, date, type_id, event_type_id, subject, body, language):
    kw = dict()
    kw.update(id=id)
    owner_type_id = new_content_type_id(owner_type_id)
    kw.update(owner_type_id=owner_type_id)
    kw.update(owner_id=owner_id)
    kw.update(user_id=user_id)
    kw.update(project_id=project_id)
    kw.update(build_time=build_time)
    kw.update(company_id=company_id)
    kw.update(contact_person_id=contact_person_id)
    kw.update(contact_role_id=contact_role_id)
    kw.update(date=date)
    kw.update(type_id=type_id)
    kw.update(event_type_id=event_type_id)
    kw.update(subject=subject)
    kw.update(body=body)
    kw.update(language=language)
    return notes_Note(**kw)

def create_outbox_mail(id, owner_type_id, owner_id, user_id, project_id, date, subject, body, sent):
    kw = dict()
    kw.update(id=id)
    owner_type_id = new_content_type_id(owner_type_id)
    kw.update(owner_type_id=owner_type_id)
    kw.update(owner_id=owner_id)
    kw.update(user_id=user_id)
    kw.update(project_id=project_id)
    kw.update(date=date)
    kw.update(subject=subject)
    kw.update(body=body)
    kw.update(sent=sent)
    return outbox_Mail(**kw)

def create_outbox_attachment(id, owner_type_id, owner_id, mail_id):
    kw = dict()
    kw.update(id=id)
    owner_type_id = new_content_type_id(owner_type_id)
    kw.update(owner_type_id=owner_type_id)
    kw.update(owner_id=owner_id)
    kw.update(mail_id=mail_id)
    return outbox_Attachment(**kw)

def create_outbox_recipient(id, mail_id, partner_id, type, address, name):
    kw = dict()
    kw.update(id=id)
    kw.update(mail_id=mail_id)
    kw.update(partner_id=partner_id)
    kw.update(type=type)
    kw.update(address=address)
    kw.update(name=name)
    return outbox_Recipient(**kw)

def create_pcsw_coaching(id, user_id, client_id, start_date, end_date, type_id, primary, ending_id):
    kw = dict()
    kw.update(id=id)
    kw.update(user_id=user_id)
    kw.update(client_id=client_id)
    kw.update(start_date=start_date)
    kw.update(end_date=end_date)
    kw.update(type_id=type_id)
    kw.update(primary=primary)
    kw.update(ending_id=ending_id)
    return pcsw_Coaching(**kw)

def create_system_siteconfig(id, default_build_method, signer1_id, signer2_id, signer1_function_id, signer2_function_id, next_partner_id, site_company_id, team_guestrole_id, client_guestrole_id, client_calender_id, system_note_type_id, propgroup_skills_id, propgroup_softskills_id, propgroup_obstacles_id, attestation_note_nature_id, job_office_id, residence_permit_upload_type_id, work_permit_upload_type_id, driving_licence_upload_type_id, debts_bailiff_type_id, master_budget_id, sector_id, cbss_org_unit, ssdn_user_id, ssdn_email, cbss_http_username, cbss_http_password):
    kw = dict()
    kw.update(id=id)
    kw.update(default_build_method=default_build_method)
    kw.update(signer1_id=signer1_id)
    kw.update(signer2_id=signer2_id)
    kw.update(signer1_function_id=signer1_function_id)
    kw.update(signer2_function_id=signer2_function_id)
    kw.update(next_partner_id=next_partner_id)
    kw.update(site_company_id=site_company_id)
    kw.update(team_guestrole_id=team_guestrole_id)
    kw.update(client_guestrole_id=client_guestrole_id)
    kw.update(client_calender_id=client_calender_id)
    kw.update(system_note_type_id=system_note_type_id)
    kw.update(propgroup_skills_id=propgroup_skills_id)
    kw.update(propgroup_softskills_id=propgroup_softskills_id)
    kw.update(propgroup_obstacles_id=propgroup_obstacles_id)
    kw.update(attestation_note_nature_id=attestation_note_nature_id)
    kw.update(job_office_id=job_office_id)
    kw.update(residence_permit_upload_type_id=residence_permit_upload_type_id)
    kw.update(work_permit_upload_type_id=work_permit_upload_type_id)
    kw.update(driving_licence_upload_type_id=driving_licence_upload_type_id)
    kw.update(debts_bailiff_type_id=debts_bailiff_type_id)
    kw.update(master_budget_id=master_budget_id)
    kw.update(sector_id=sector_id)
    kw.update(cbss_org_unit=cbss_org_unit)
    kw.update(ssdn_user_id=ssdn_user_id)
    kw.update(ssdn_email=ssdn_email)
    kw.update(cbss_http_username=cbss_http_username)
    kw.update(cbss_http_password=cbss_http_password)
    return system_SiteConfig(**kw)

def create_system_textfieldtemplate(id, user_id, name, description, team_id, text):
    kw = dict()
    kw.update(id=id)
    kw.update(user_id=user_id)
    kw.update(name=name)
    kw.update(description=description)
    kw.update(team_id=team_id)
    kw.update(text=text)
    return system_TextFieldTemplate(**kw)

def create_uploads_upload(id, owner_type_id, owner_id, user_id, created, modified, file, mimetype, type_id, valid_until, description):
    kw = dict()
    kw.update(id=id)
    owner_type_id = new_content_type_id(owner_type_id)
    kw.update(owner_type_id=owner_type_id)
    kw.update(owner_id=owner_id)
    kw.update(user_id=user_id)
    kw.update(created=created)
    kw.update(modified=modified)
    kw.update(file=file)
    kw.update(mimetype=mimetype)
    kw.update(type_id=type_id)
    kw.update(valid_until=valid_until)
    kw.update(description=description)
    return uploads_Upload(**kw)

def create_users_authority(id, user_id, authorized_id):
    kw = dict()
    kw.update(id=id)
    kw.update(user_id=user_id)
    kw.update(authorized_id=authorized_id)
    return users_Authority(**kw)

def create_users_membership(id, user_id, team_id):
    kw = dict()
    kw.update(id=id)
    kw.update(user_id=user_id)
    kw.update(team_id=team_id)
    return users_Membership(**kw)



settings.SITE.install_migrations(globals())

loader = DpyLoader()
set_language()
os.chdir(os.path.dirname(__file__))

execfile("accounts_chart.py")
execfile("accounts_group.py")
execfile("accounts_account.py")
execfile("cal_guestrole.py")
execfile("cal_priority.py")
execfile("cal_room.py")
execfile("cbss_purpose.py")
execfile("cbss_sector.py")
execfile("contacts_companytype.py")
execfile("contacts_roletype.py")
execfile("countries_country.py")
execfile("countries_city.py")
execfile("courses_coursecontent.py")
execfile("households_role.py")
execfile("households_type.py")
execfile("isip_contractending.py")
execfile("isip_studytype.py")
execfile("jobs_jobtype.py")
execfile("jobs_regime.py")
execfile("jobs_schedule.py")
execfile("jobs_sector.py")
execfile("jobs_function.py")
execfile("languages_language.py")
execfile("newcomers_broker.py")
execfile("newcomers_faculty.py")
execfile("notes_eventtype.py")
execfile("notes_notetype.py")
execfile("pcsw_activity.py")
execfile("contacts_partner.py")
execfile("contacts_person.py")
execfile("households_household.py")
execfile("households_member.py")
execfile("pcsw_aidtype.py")
execfile("pcsw_clientcontacttype.py")
execfile("contacts_company.py")
execfile("contacts_role.py")
execfile("courses_courseprovider.py")
execfile("courses_courseoffer.py")
execfile("courses_course.py")
execfile("jobs_jobprovider.py")
execfile("jobs_offer.py")
execfile("pcsw_coachingtype.py")
execfile("pcsw_coachingending.py")
execfile("pcsw_dispensereason.py")
execfile("pcsw_exclusiontype.py")
execfile("pcsw_persongroup.py")
execfile("pcsw_client.py")
execfile("courses_courserequest.py")
execfile("cv_languageknowledge.py")
execfile("jobs_experience.py")
execfile("jobs_study.py")
execfile("pcsw_clientcontact.py")
execfile("pcsw_dispense.py")
execfile("pcsw_exclusion.py")
execfile("properties_propgroup.py")
execfile("properties_proptype.py")
execfile("properties_propchoice.py")
execfile("properties_property.py")
execfile("properties_personproperty.py")
execfile("system_helptext.py")
execfile("uploads_uploadtype.py")
execfile("users_team.py")
execfile("cal_calendar.py")
execfile("isip_exampolicy.py")
execfile("isip_contracttype.py")
execfile("jobs_contracttype.py")
execfile("jobs_job.py")
execfile("jobs_candidature.py")
execfile("users_user.py")
execfile("cal_event.py")
execfile("cal_guest.py")
execfile("cal_subscription.py")
execfile("cal_task.py")
execfile("cbss_identifypersonrequest.py")
execfile("cbss_manageaccessrequest.py")
execfile("cbss_retrievetigroupsrequest.py")
execfile("changes_change.py")
execfile("debts_budget.py")
execfile("debts_actor.py")
execfile("debts_entry.py")
execfile("isip_contract.py")
execfile("jobs_contract.py")
execfile("newcomers_competence.py")
execfile("notes_note.py")
execfile("outbox_mail.py")
execfile("outbox_attachment.py")
execfile("outbox_recipient.py")
execfile("pcsw_coaching.py")
execfile("system_siteconfig.py")
execfile("system_textfieldtemplate.py")
execfile("uploads_upload.py")
execfile("users_authority.py")
execfile("users_membership.py")
