# -*- coding: UTF-8 -*-
## Copyright 2012 Luc Saffre
## This file is part of the Lino project.
## Lino is free software; you can redistribute it and/or modify 
## it under the terms of the GNU General Public License as published by
## the Free Software Foundation; either version 3 of the License, or
## (at your option) any later version.
## Lino is distributed in the hope that it will be useful, 
## but WITHOUT ANY WARRANTY; without even the implied warranty of
## MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the 
## GNU General Public License for more details.
## You should have received a copy of the GNU General Public License
## along with Lino; if not, see <http://www.gnu.org/licenses/>.

"""
The raw data (in UPPERCASE variables) was originally copied from 

- LAST_NAMES_BELGIUM : http://www.lavoute.org/debuter/Belgique.htm
- LAST_NAMES_FRANCE : http://www.nom-famille.com/noms-les-plus-portes-en-france.html
- MALE_FIRST_NAMES_FRANCE and FEMALE_FIRST_NAMES_FRANCE :
  http://meilleursprenoms.com/site/LesClassiques/LesClassiques.htm
- STREETS_OF_LIEGE: http://fr.wikipedia.org/wiki/Liste_des_rues_de_Li%C3%A8ge

"""

LAST_NAMES_BELGIUM = u"""
 
A

Adam

Adami

Adriaenssens

Adriaen

Adriaensen

Adriaenssen

Adriencense

Adriensence

Adrienssens

Aelter

Aelters

Aelterman

Aerens

Aerts

Aertsens 

Albumazard

Alloo

Alsteen

Andersson

André

Andries

Andriessen

Anthon

Antoine

Appelbaum

Applaer

Arimont

Arquin

Arteman

B

Baert

Bartholomeeus

Bastien 

Bastin

Baugnet

Baugniet

Baugniez

Bauwens

Beauve

Beck

Beckers

Bernard

Bertrand

Bietmé

Blaas

Blankaert

Blanquaert

Blondeel

Blondeeuw

Blondoo

Bodart

Bodson

Boeck

Boesmans

Bogaert

Bogaerts

Bogemans

Booghmans

Borremans

Borsu

Borsus 

Borsut 

Bosmans

Bouch

Bouchhout

Bouillère

Bouillet

Boulanger

Bourton

Bouxin

Brasseur

Brouck

Broucke

Broucq

Broucque

Brouhier

Brug

Bruggesman

Bruynseel 

Bruynseels

Burger

Burghgraeve

Burgmeester

Burton

Burtont

Buyle

C

Calbert 

Callebaut

Callebert 

Callebout

Camby

Cappelaere

Cappelaire 

Cappelier 

Cappeliez 

Cappellier 

Carbonez

Carbonnez

Carlier

Casteau

Castel

Castiaux

Cauderlier

Caudron

Cauvel

Cauvet

Cauvin

Cavard

Ceulemans

Chantry

Charlier

Chêneboit

Chestay

Chestia

Chrispeels

Christiaens

Christoffel

Claes

Claessens

Claeys

Claus

Cléban

Clébant

Clerx

Colinus

Collard

Colleye
Collignon
Collin
Colson
Cool
Cools
Coppens
Corain
Corijn
Corin
Cornelis
Cornet
Corrin
Corring
Corringer
Coryn
Coudyser
Couhysder
Coutijser 
Coutiser 
Crab 
Crabbe
Crama

Crépez

Crespel

Crevisse

Crevits

Crispeel

Crispeels

Crispel

Crispiels

Cuvelier

Cuypers

D

Daan

Daels

Daems

Dalmans

Damard 

Damart

Danis

Dany 

Danys 

Dapvril

Daufresne

Dawance

De Backer

De Bisschop

De Bloedt

De Blonde

De Boeck

De Bosscher

De Bosschere

De Bruyn

De Busschere

De Buyle

De Clercq

De Cock

De Coninck

De Conninck

De Coster

De Cruyenaere

De Cuyper

De Decker

De Doncker

De Draier

De Flandre

De Frankrijker

De Greef

De Griek

De Groot

De Groote

De Guchteneere

De Haese

De Hert

De Hertog

De Hoorne

De Kimpe

De Markgraef

De Meester

De Meulenaer

De Meyer

De Molder

De Munck

De Muynck

De Muyncke

 De Muynek

 De Muynke

De Naeyer

De Nayer 

 De Pannemacker

De Pannemaecker

De Pauss

De Pauw

De Pelsemaeker

De Pester 

De Potter

De Praeter

De Prester

De Ridder

De Ridere

De Rovéréaz

De Rudere

De Sachte

De Saedeleer

De Saert

De Schepper

De Schoone

De Smedt

De Smet

De Smeytere

De Smidt

De Smit 

 De Smyter

De Stracke

De Sueter

De Vette

De Voghels

De Vos

De Vrient

De Wilde

De Winter

Debacker

Debaere

Debakker

Debaut

Debecker

Debekker

Debled

Deboschere

Deboscker

Deboskre

Debosscher

Debosschere

Debusschere

Debuyst

Declerck

Declercq

Decock

Decocq

Decrucq

Decruyenaere

Defaux

Defawe

Degroote

Dehoorne

Dehorne

Dehornes

Deilgat

Dejong

Dejonghe

Dekale

Dekimpe 

Dekoch

Dekuiper

Dekyndt

Delacuvellerie

Delafosse 

Delahaye 

Delahayes 

Delbouille

Delboulle

Delcorps

Delflache

Delfosse

Delgat 

Delhaye

Delhoste 

Delhotte

Delmare

Delmer

Delobbe

Delobe 

Delobes 

Delplace

Delvaux

Demain

Demeiere

Demeyer

Demoor

Demoore

 Demunck

Demunck

Demuynck

Den Ouste

Denaeyer

Denayer

Deneyer

Denis

Denoor

Depannemaecker

Depelsemacker

Depelsemaeker

Depelsenaire 

Depelseneer 

Depercenaire 

Depester 

Depiéreux 

Depierreux 

Depireux 

Depoorter

Depoortere 

Depooter 

Depootere 

Deporter 

Deportere 

Depoterre

Deprez

Deramaix

Deroosse

Desandrouins

Descamps

Deschepper

Desmedt

Desmet

Desmets

Desmeytere

Desmidt

Desmidts 

Desmit

Desmyter

Desmytter

Desmyttere

 Despineto

Després 

Despret 

Desprets 

Despretz 

Desprey 

Desprez 

Destoute

Deswart

Deswarte

Dethier

Deur

Deurwaerder

Devis

Devloo

Devos

Devriend

Dewever

Dewit

Dewitte

Dewyse

D'Haeyer

Dhaeyer

D'Hoeraen

Dhoeraen

D'hoolaege

Dierckx

Dierik

Doeraene

Dolhaeghe

Domiens

Dominicus

Dondaine

Dondeine 

Dondenne 

Dondeyne 

Doolaeg(h)e

Doolaegue

Doolage

Doorn

Doorne

Doorneman

Draier

Dresselaers

Dubled

Dubois

Dumont

Dupont

Duquesnay

Duquesne

Duquesnoy

E

Ebrard

Eeckeman

Eerkens

Erckens

Erk

Erken

Erkens

Etienne

Euvrard

Evert

Evrard

Evras

Evrat

Eyck

Eysermans

F

Fawat

Faweux

Fee

Felix

Flamenck

Floche

Floquet

Fontaine

Fonteyne

Fraigany

Fraigneux

Francoeur

François

Francon

Frankel

Franken

Frankeur

Frans

Fransman

Fransolet

Franzman

Frijer

G

Gabriels

Gadisseur

Gadisseux

Gasthuys

Gaudisseu

Geerts

Gehucht

Geiregat

Geeregat 

Gendebien

Genot

Georges

Gérard

Gerlache

Gerlaxhe 

Germay

Germéa

Germeau

Ghiste

Gilles

Gillet

Gilson

Gits

Giets

Gidts

Geets

Geerts

Glaze

Glazeman

Goethals

Goffin

Gomaert

Gomardt

Goor

Goossens

Goud

Goudman

Goudsmith

Gourdet

Gousson

Graas

Greggs

Gregh

Grégoire

Gregoor

Grewis

Groot

Groote

Grotaers

Guillaume

Guyaux

H

Haesen

Haesevoets

Halasi

Halazy

Hamers

Hanssens

Hardas 

Hardat

Hardy

Heerbrant

Hendrick

Hendrickx

Hendriks

Henry

Herbrand 

Herbrandt 

Herbrant 

Herman

Hermann 

Hermans

Herten

Hertogs

Hertogue

Heylen

Heymans

Heynemans

Heyrman

Hinck

Hinckel

Hincker

Hinkel

Hinkels

Hinkens

Hinker

Hinkle

Hoefnagel 

Hoefnagels 

Holemans

Honnay

Horlin

Houvenaghel

Hoyois

Hubert

Huig

I

Ickx

Istace 

Istasse 

J

Jaak

Jaap

Jacob

Jacobs

Jacques

Jacquet

Jan

Janhes

Jansen

Janssen

Janssens

Jef

Jenot

Jeuniaux

Joire

Jone

Joneau

Jonet

Jongers

Jonné

Jonet

Jonnet

Jordaens

Jorez

Joris

Jorissen

Jozef

Julianus

Julius

Jurgen

K

Kaalman

Kaisin

Keetels

Kenens 

Kenes 

Kenis 

Kennens 

Kennes 

Kennis 

Kesteloot

Ketel

Ketelsmit

Kiecken

Kimpe 

Kinnen 

Klein 

Kleineman

Kleiner 

Kleinerman

Kleinman 

Klerk

Kleynen

Klingeleers

Kobus

Koeck

Konninckx

Koolman

Korring

Kramers

Kreemers

Kuipers

L

Labbez

Lacroix

Laenen 

Laenens 

Lafontaine 

Lambert

Lambrechts

Lanen 

Lanens 

Langlez

Lapayre

Laseur

Laseure

Lauffer

Laurent

Lauwers

Le Mayeur

Le Provost

Leboutte

Lebrun

Leclerc

Leclercq

Lecocq

Lecomte

Ledecq

Leenhard

Leenhart

Lefebvre

Lefèvre

Legrand

Lejeune

Lemaire

Lemmens

Lemonnier

Lemounie

Lenaerts

Lénel 

Lénelle

Lennel 

Léonard

Lepoutre

Leprette

Lepropre

Leroy

Lescohy

Lesoil

Lesoile 

Lesoille 

Levecq

Lewek

Libert

Liens

Liephoudt

Liepot

Liepout

Lieseborghs

Liesenborghs

Lietaer

Lietaert

Lietar

Liétar

Liétard

Liétart

Lievens

Lievesoons 

Lievevrouw 

Lievrouw

Liévrouw

Lievrow 

Linglay

Linglet

Liphout

Lisenborgh

Lisenborgs

Locreille 

Locrel

Locrelle 

Lode

Loo

Lorfèvre

Lorphêvre

Losseau

Losset

Louis

Louzeau

Lowie

Ludovicus

Lugen

Lugens 

Lust

Lustig

Luyer

Luyrik

Luyten

Lyphoudt 

Lyphout

M

Maca

Maertens

Maes

Maessen

Mahieu

Maka

Malchamp 

Malchamps 

Malmedier

Malmedy

Malmendier

Mangon

Maqua

Marchal

Marckx

Marcus

Mardaga

Maréchal

Maria

Mark

Markgraff

Martens

Martin

Martins

Massart

Masson

Mathieu

Mathissen

Mathy

Matthys

Mauchamp 

Mauchamps 

Maurichon

Maurissen

Maurits

Mayeur

Mayeux

Mechelaere

Meert

Meertens

Meester

Meeus

Melaerts 

Mellaerts

Merchié

Merchier

Mergeai

Mergeay

Merjai

Merjay

Mertens

Mertes

Merts 

Mertz 

Meulemans

Meulemeesters

Meunier

Meurice

Mewis

Mewissen

Michaël

Michaux

Michel

Michiels

Mixhel

Mochamps

Moens

Moeyaert 

Moiling

Moinil

Molemans

Molenaers

Monceau

Moncia

Monciaux

Monsay

Monteyne

Moreau

Mouyart

Moyaert 

Mullenders

Munck

Muynck

N

Nachtegael

Nagelmaekers

Nagels

Natus

Neel

Neels

Neuray

Neureau

Neuret

Neurot

Neuts 

Neuven

Neven

Nguyen

Nicolas

Nicolaus

Nicolus

Nijs

Niklaas

Noël

Nuts 

Nuttin

O

Ochin

Olivier

Olyff

P

Paindavaine

Pannaye

Parmentier

Pas

Pauss

Pauwels

Peeters

Pelser

Pelsmaeker

Peschon

Peschoniez

Pester

Petersen

Petit

Pierre

Piet

Pieters

Pietersen

Piette

Pirard

Piron

Pirotte

Plaats

Poels

Poelsmans

Poncelet

Pools

Posson

Potstainer

Potter

Pottiaux

Pottié

Potty

Poyon

Praat

Premereur 

Premmereur

Prevostel

Priesse

Prisse

Proost

Prost

Proust

Putmans

Putmans

Puttemans

Puttemans

Putman 

Q

Quaisin

Quesnay

Quesne

Quesneau

Quesnel

Quesney

Quesnoy

Queval

R

Raes

Ramael

Raucent

Rauscent

Rausin 

Raussain

Raussent

Raussin 

Raveydts

Ravignat

Remy

Renard

Retelet

Ricaart

Ricaert

Ricard

Robaert

Robbert

Robert

Roels

Roland

Rooseels

Roosengardt

Rosseel

Rousseau

S

Saintmaux 

Saint-Maux

Sanctorum

Santilman

Schmitz

Schnock

Schoenmakers

Schoenman

Schoone

Scorier

Scuvie

Scuvie

Segers

Seghers

Seppen

Servais

Shoen

Sijmen

Simoens

Simon

Simons

Sinnesaël

Sinnesal 

Slagmolder

Slagmulder

Slamulder

Smal

Smeets

Smet

Smets

Smit

Smolders

Smulders

Somers

Sottiaux

Spinette

Sprecher

Stas

Stass 

Stassaert 

Stassar 

Stassard 

Stassart 

Stasse 

Stassiaux 

Stassin 

Stassinet 

Statius 

Steculorum

Stefaans

Stercken

Sterckmans

Sterckx

Stevens

Stier

Stiers

Stievens

Stine

Stoffel

Stordair

Stordeur

Stoutmans

Swart

Swarte

T

Tack

Taverner

Teissant

Terreur

Thijs

Thiry

Thissen

Thomas

Thonnisen

Thuiliau

Thuiliaux

Thuiliet

Thys

Tibaut

Timmerman

Timmermans

T'Jampens

Tjampens

Toussaint

Trausch

Tuiliau

Tuiliaux

Tuilliet

Tuin

Tumson

Tweelinckx

U

Urbain

Urting

V

Van Acker

Van Aelter

Van Belle

Van Berckel

Van Bergh

Van Caenegem

Van Caeneghem

Van Daele

Van Damme

Van de Loo

Van de Pas 

Van de Poel

Van de Slijke

Van de Slycke

Van de Veld

Van de Velde

Van den Bergh

Van den Bogaerde

Van den Borne

Van den Bossche

Van den Broeck

Van den Broecke

Van den Camp

Van den Castele

Van den Dael

Van den Dorpe

Van den Tuin

Van Den

Van der Brug

Van der Gucht

Van der Pas 

Van der Slijke

Van der Slikke

Van der Slycke

Van der Vleuten 

Van Doren

Van Dorp

Van Dorpe

Van Dovlaeghe

Van Dyck

Van Engeland

Van Esch

Van Escht

Van Eyck

Van Hecke

Van Hoof

Van Hoorebeke

Van Hoorenbeeck

Van Horenbeck

Van Horenbeeck

 Van Lierde

Van Noye

Van Noÿe

Van Pé

Van Pede

Van Pée

Van Roy

Van Sinaey

Van Slijke

Van Slycke

Van Steerteghem

Van Steerteghen

Van Steirteghem

Van Vleuten 

Vanbattel

Vanbergh

Vandamme

Vandenberghe

Vandenbossche 

Vandenbussche

Vandendorpe

Vandeputte

Vanderhorst

Vanderlinden

Vanderplaetsen

Vandevelde

Vandoolaeghe

Vandorpe

Vanlierde

Vanpé

Vanpede

Vanpée

Vansteertegem

Vecq

Veld

Veldmann

Vellemans

Veraghe

Veraghen

Verbeeck

Verbeke

Verbruggen

Vercammen

Vercheval

Verdoolaeg(h)e

Verhaege

Verhaegen

Verhaeghe

Verhaeghen

Verhaegue

Verhage

Verhagen

Verhaghe

Verhelst

Verheyen

Verhoeven

Verlinden

Vermeer 

Vermeersch

Vermeiren

Vermeren 

Vermeulen

Vermotte 

Verplaetse

Verplancke

Verplancken

Verschueren

Verslijke

Verslycke

Verstraete

Verstraeten

Vervoort

Vet

Vette

Viatour

 Vieutemps 

Vieutems 

Vieuxtemps

Vilain 

Vincent 

Vinchent

Visje

Vlaamsche

Vlaeminck

Vlaemynck

Vlaminck

Vlamynck

Vlemincks

Vleminckx

Vleminx

Vlemynckx

Vogels

Volckaert

Volkaert

Volkaerts

Volkart

Volkert

Voller

Vos

Vossen

Vrank

Vrindt

Vrolijt

Vrolyck

Vullers

W

Wagemans

Wagenmann 

Waghon 

Wagon

Walle

Wastiaux 

Watrigant 

Watriquant 

Watteau 

Watteau

Watteaux 

Watteaux

Wattecamp 

Wattecamps

Wattecant 

Watteel

Wattel

Wattelle

Wattiau 

Wattiaux 

Wattieaux 

Wauters

Weers 

Weerts

Wek

Wevers

Weynen

Wilbaert

Wilfart

Willems

Willock

Willocq

Wilock

Wintgens

Wouter

Wouters

Wuyts

Wylock
Wylocke

Y

Yildirim
Yilmaz

Z

Zadelaar
Zegers
Zeggers
Zègres
"""


LAST_NAMES_FRANCE = u"""
Martin	236 172
Bernard	131 901
Thomas	119 078
Dubois	114 001
Durand	111 510
Robert	106 161
Moreau	103 056
Petit	95 876
Simon	95 733
Michel	93 581
Leroy	88 722
Laurent	85 243
Lefebvre	82 670
Bertrand	75 030
Roux	74 955
David	73 150
Garnier	67 829
Legrand	67 475
Garcia	67 162
Bonnet	66 124
Lambert	65 724
Girard	65 228
Morel	64 537
Andre	64 301
Dupont	63 520
Guerin	62 971
Fournier	61 770
Lefevre	61 662
Rousseau	58 884
Francois	58 409
Fontaine	57 783
Mercier	56 702
Roussel	56 300
Boyer	56 024
Blanc	54 714
Henry	54 212
Chevalier	53 741
Masson	52 966
Clement	51 177
Perrin	50 834
Lemaire	50 038
Dumont	49 834
Meyer	48 796
Marchand	47 763
Joly	47 337
Gauthier	47 218
Mathieu	47 178
Nicolas	46 761
Nguyen	46 605
Robin	46 329
Barbier	45 635
Lucas	44 369
Schmitt	44 128
Duval	44 075
Gerard	43 762
Noel	43 263
Gautier	42 411
Dufour	42 209
Meunier	41 833
Brunet	41 807
Blanchard	41 477
Leroux	41 162
Caron	40 845
Lopez	40 431
Giraud	39 896
Fabre	39 592
Pierre	39 469
Gaillard	39 260
Sanchez	39 133
Riviere	39 018
Renard	37 607
Perez	37 371
Renaud	37 274
Lemoine	37 222
Arnaud	37 173
Jean	36 901
Colin	36 289
Brun	36 159
Philippe	35 922
Picard	35 912
Rolland	35 870
Olivier	35 384
Vidal	34 737
Leclercq	34 630
Aubert	34 477
Hubert	34 429
Bourgeois	34 380
Roy	33 798
Guillaume	33 518
Adam	32 624
Dupuy	31 895
Louis	31 785
Maillard	31 752
Aubry	31 184
Charpentier	30 139
Benoit	30 055
Berger	29 640
Royer	29 425
Poirier	29 345
Dupuis	29 339
Rodriguez	29 330
Jacquet	29 274
Moulin	29 065
Charles	29 041
Lecomte	28 980
Deschamps	28 823
Fernandez	28 547
Guillot	28 526
Collet	28 333
Prevost	28 129
Germain	27 664
Bailly	27 588
Guyot	27 419
Perrot	27 293
Le gall	27 140
Renault	27 138
Le roux	26 551
Vasseur	26 431
Herve	26 272
Gonzalez	26 182
Barre	26 084
Breton	26 057
Huet	25 961
Bertin	25 960
Carpentier	25 809
Lebrun	25 749
Carre	25 435
Boucher	25 365
Menard	25 135
Rey	24 943
Klein	24 750
Weber	24 727
Collin	24 553
Cousin	24 314
Millet	24 310
Tessier	23 978
Leveque	23 737
Le goff	23 704
Lesage	23 599
Marchal	23 525
Leblanc	23 492
Bouchet	23 442
Etienne	23 413
Jacob	23 328
Humbert	23 315
Bouvier	23 290
Leger	23 273
Perrier	23 182
Pelletier	22 952
Remy	22 824
"""


FEMALE_FIRST_NAMES_FRANCE = u"""
Adélaïde, Adèle, Agnès, Alix, Béatrice, Beatrix, Elizabeth, Hélène, Héloïse, Isabeau, Iseult, Irène, Mahaut, Margot, Mathilde, Mélissende, Pétronille, Yolande,
Adèle, Aimée, Alice, Appoline, Augustine, Céleste, Célie, Emma, Élise, Églantine, Eugénie, Irène, Jeanne, Joséphine, Léopoldine, Léontine, Lucie, Louise, Madeleine, Mathilde, Ophélie, Pauline, Rose, Zoé
Albanie, Alexine, Aglaé, Alina, Alma, Angèle, Appoline, Armance, Arthémise, Augustine, Blanche, Célestine, Colombe, Dina, Elia, Émerence, Eulalie, Eugénie, Félicie, Fleurine, Gracianne, Honorine, Jeanne, Léona, Léonie, Léontine, Lilly, Louise, Matilde, Noémi, Pétronille, Philomène, Rose, Salomée, Sidonie, Victoire, Victorine Zélie
"""

MALE_FIRST_NAMES_FRANCE = u"""
Ambroise, Amédée, Anastase, Arthur, Augustin, Aymeric, Béranger, Geoffroy, Grégoire, Guillaume, Léon, Louis, Théodore, Thibaut, Tristan,
Alfred, Alphonse, Amédée, Aristide, Augustin, Barthélémy, Cyprien, Eugène, Ferdinand, Félix, Gustave, Jules, Justin, Léon, Théophile, Victor, Virgile,
Abel, Achille, Aimé, Anatole, Anthime, Auguste, Augustin, Célestin, Edgar, Emile, Ernest, Faustin, Félix, Gaston, Gustave, Jules, Léon, Léopold, Louis, Marceau, Marius, Max, Melchior, Oscar, Philémon, Rubens, Sully, Théodore, Théophile, Victor, Victorin, Wilhem
"""

# copied from http://fr.wikipedia.org/w/index.php?title=Liste_des_rues_de_Li%C3%A8ge&action=edit
STREETS_OF_LIEGE = u"""
{{ébauche|Liège}}
Cet article dresse une liste (incomplète) des voies ([[voirie]]s et [[Place (voie)|places]]) de la [[Ville de Belgique|ville]] de [[Liège]] en [[Belgique]].

{{SommaireCompact}}

==2==
<div style="-moz-column-count:3; column-count:3; -webkit-column-count:3;">
*[[Place du 20-Août]]
</div>

==A==
<div style="-moz-column-count:3; column-count:3; -webkit-column-count:3;">

* [[Rue de l'Abattoir]]
* [[Rue des Abeilles (Liège)|Rue des Abeilles]]
* [[Rue des Acacias (Liège)|Rue des Acacias]]
* [[Rue de l'Académie]]
* [[Avenue Albert Mahiels]]
* [[Rue Ambiorix]]
* [[Rue d'Amercoeur]]
* [[rue des Anglais (Liège)|Rue des Anglais]]
* [[Rue d'Ans]]
* [[Quai des Ardennes]]
* [[Rue Armand Stouls]]
* [[Rue Auguste Hock]]
* [[Rue des Augustins (Liège)|Rue des Augustins]]
* [[Impasse de l'Avenir]]
* [[Boulevard d'Avroy]]
* [[Rue d'Awans]]

</div>

==B==
<div style="-moz-column-count:3; column-count:3; -webkit-column-count:3;">
* [[La Batte]]<ref>Batte signifiant ''quai'' en [[wallon]], on ne doit donc pas dire quai de la Batte</ref>
* [[Rue Basse-Wez]]
* [[Rue Beauregard (Liège)|Rue Beauregard]]
* [[Place des Béguinages]]
* [[Rue Bernimolin]]
* [[Rue Bidaut]]
* [[Avenue Blonden]]
* [[Rue Bois Gotha]]
* [[Quai Bonaparte]]
* [[Rue Bonne-Fortune]]
* [[Rue Bonne-Nouvelle]]
* [[Rue des Bons Enfants (Liège)|Rue des Bons Enfants]]
* [[Rue du Bosquet (Liège)|Rue du Bosquet]]
* [[Rue de la Boucherie (Liège)]]
* [[Quai de la Boverie]]
* [[Rue de Bruxelles (Liège)|Rue de Bruxelles]]
* [[Montagne de Bueren]]

</div>

==C==
<div style="-moz-column-count:3; column-count:3; -webkit-column-count:3;">
* [[Rue de Campine]]
* [[Rue des Carmes (Liège)|Rue des Carmes]]
* [[Place des Carmes]]
* [[Rue de la Casquette]]
* [[Place de la Cathédrale]]
* [[Rue de la Cathédrale]]
* [[Boulevard César Thomson]]
* [[Rue des Champs]]
* [[Rue Charles Bartholomez]]
* [[Rue Charles Magnette]]
* [[Avenue Rogier (Liège)|Avenue Charles Rogier]]
* [[Thier de la Chartreuse]]
* [[Rue de Chaudfontaine]]
* [[Rue Chauve-Souris (Liège)|Rue Chauve-Souris]]
* [[Rue de la Cité (Liège)|Rue de la Cité]]
* [[Rue des Clarisses]]
* [[Boulevard de la Constitution]]
* [[Rue du Coq]]
* [[Rue Counotte]]
* [[Rue Cour Petit]]
* [[Place Crèvecœur]]
* [[Rue des Croisiers]]
* [[Rue des Croix-de-Guerre]]
</div>

==D==
<div style="-moz-column-count:3; column-count:3; -webkit-column-count:3;">
* [[Rue Darchis]]
* [[Rue Dartois]]
* [[Rue Dehin]]
* [[Rue Denis Sotiau]]
* [[Rue Dony]]
* [[Rue Douffet]]
</div>

==E==
<div style="-moz-column-count:3; column-count:3; -webkit-column-count:3;">
* [[Boulevard Émile de Laveleye]]
* [[Avenue Émile Digneffe]]
* [[Rue Émile Gérard]]
* [[Rue Émile Vandervelde (Liège)|Rue Émile Vandervelde]]
* [[Rue En Bois]]
* [[Rue Ernest de Bavière]]
* [[Rue Ernest Solvay (Liège)|Rue Ernest Solvay]]
* [[Rue Éracle]]
* [[Rue Eugène Houdret]]
* [[Rue de l'Étuve (Liège)|Rue de l'Étuve]]
</div>

==F==
<div style="-moz-column-count:3; column-count:3; -webkit-column-count:3;">
* [[Féronstrée]]
* [[Rue de Fétinne]]
* [[Rue Fond Saint-Servais]]
* [[Rue fond des Tawes]]
* [[Rue des Fontaines-Roland]]
* [[Rue des Fossés]]
* [[Rue de Fragnée]]
* [[Place des Franchises]]
* [[Boulevard Frankignoul]]
* [[Ernest-Frédéric Nyst|Rue Frédéric Nyst]]
* [[Rue aux Frênes]]
* [[Boulevard Frère-Orban]]
</div>

==G==
<div style="-moz-column-count:3; column-count:3; -webkit-column-count:3;">
* [[Rue Gaston Laboulle]]
* [[Rue Gaucet]]
* [[Quai de Gaulle]]
* [[Rue du Général de Gaulle]]
* [[Rue du Général Bertrand]]
* [[Place du Général Leman]]
* [[Rue Georges Simenon]]
* [[Quai Godefroid Kurth]]
* [[Quai de la Goffe]]
* [[Rue de la Goffe]]
* [[Impasse Graindor]]
* [[Rue Gramme (Liège)|Rue Gramme]]
* [[Rue Grande Bêche]]
* [[Rue des Gravillons]]
* [[Rue Grétry (Liège)|Rue Grétry]]
* [[Rue du Gros Gland]]
* [[Place des Guillemins]]
* [[Rue des Guillemins]]
</div>

==H==
<div style="-moz-column-count:3; column-count:3; -webkit-column-count:3;">
* [[Rue de la Halle]]
* [[Rue de Harlez]]
* [[Rue d'Harscamp]]
* [[Rue du Haut-Pré]]
* [[Place du Haut-Pré]]
* [[Rue Hazinelle]]
* [[Rue Henri Baron]]
* [[Rue Henri Koch (Liège)|Rue Henri Koch]]
* [[Rue Henri Maus (Liège)|Rue Henri Maus]]
* [[Rue Herman Reuleaux]]
* [[Rue de Hesbaye]]
* [[Rue Hocheporte]]
* [[Rue Hors-Château]]
* [[Rue des Houblonnières]]
* [[Rue Hullos]]
</div>

==I==
<div style="-moz-column-count:3; column-count:3; -webkit-column-count:3;">
* [[Place d'Italie (Liège)|Place d'Italie]]
* [[Rue des Ixellois]]
</div>

==J==
<div style="-moz-column-count:3; column-count:3; -webkit-column-count:3;">
* [[Rue Jambe de Bois]]
* [[Rue du Jardin Botanique]]
* [[Rue Jean Bury]]
* [[Rue Jean d'Outremeuse]]
* [[Rue Jean Haust]]
* [[Rue Joffre]]
* [[Rue de Joie]]
* [[Rue Jonckeu]]
* [[Rue Jondry]]
* [[Rue des Jonquilles (Liège)|Rue des Jonquilles]]
* [[Place Joseph de Bronckart]]
* [[Rue Joseph Demoulin]]
* [[Rue Joseph Henrion]]
* [[Rue Joseph Lacroix]]
* [[Rue Joseph Wauters (Liège) |Rue Joseph Wauters]]

</div>

==L==
<div style="-moz-column-count:3; column-count:3; -webkit-column-count:3;">
* [[Rue Lairesse]]
* [[Rue de Lantin]]
* [[Rue du Laveu (Liège)|Rue du Laveu]]
* [[Rue de la Légia]]
* [[Rue Lemille]]
* [[Passage Lemonnier]]
* [[Rue Léon Mignon (Liège)|Rue Léon Mignon]] 
* [[Rue Léopold]]
* [[Rue Libotte]]
* [[Rue de Londres (Liège)|Rue de Londres]]
* [[Quai de Longdoz]]
* [[Rue Louis Abry]]
* [[Rue Louis Fraigneux]]
* [[Rue Louvrex]]
* [[Avenue du Luxembourg]]
</div>

==M==
<div style="-moz-column-count:3; column-count:3; -webkit-column-count:3;">
* [[Quai de Maestricht]]
* [[Rue des Maraîchers (Liège)|Rue des Maraîchers]]
* [[Place du Marché (Liège)|Place du Marché]]
* [[Quai Marcellis]]
* [[Quai Mativa]]
* [[Avenue Maurice Destenay]]
* [[Rue Méan]]
* [[Quai sur Meuse]]
* [[Rue Mississippi]] 
* [[Rue du Mont Saint-Martin]]
* [[Rue Montagne Sainte-Walburge]]
</div>

==N==
<div style="-moz-column-count:3; column-count:3; -webkit-column-count:3;">
* [[Rue de Namur]]
* [[Rue Naniot]]
* [[Rue Natalis]]
* [[Place des Nations-Unies (Liège)|Place des Nations-Unies]]
* [[En Neuvice]]
</div>

==O==
<div style="-moz-column-count:3; column-count:3; -webkit-column-count:3;">
* [[Place de l'Opéra (Liège)|Place de l'Opéra]]
* [[Quai Orban]]
* [[Rue Oscar Rémy]]
* [[Quai de l'Ourthe]]
</div>

==P==
<div style="-moz-column-count:3; column-count:3; -webkit-column-count:3;">
* [[Rue Paradis (Liège)|Rue Paradis]]
* [[Rue du Parc]]
* [[Rue du Palais (Liège)|Rue du Palais]]
* [[Rue de Paris (Liège)|Rue de Paris]]
* [[Au Péri]]
* [[Boulevard Piercot]]
* [[Rue Pierreuse]]
* [[Rue du Plan Incliné]]
* [[Rue Plumier]]
* [[Rue Pont-d'Avroy]]
* [[Rue Pont-d'Ile]]
* [[Rue du Pot d'Or]]
* [[Potiérue]]
* [[Rue des Prébendiers]]
* [[Rue Publémont]]
* [[Rue Puits-en-Sock]]
* [[Rue du Puits]]
</div>

==R==
<div style="-moz-column-count:3; column-count:3; -webkit-column-count:3;">
* [[Rue des Récollets (Liège)|Rue des Récollets]]
* [[Rue de la Régence (Liège)|Rue de la Régence]]
* [[Rue Regnier-Poncelet (Liège)|Rue Regnier-Poncelet]]
* [[Avenue Reine Elisabeth]]
* [[Rue des Remparts]]
* [[Place de la République française]]
* [[Rue de la Résistance]]
* [[Quai de la Ribuée]]
* [[Rue des Rivageois]]
* [[Rue Robertson]]
* [[Quai de Rome]]
* [[Quai Roosevelt]]
* [[Rue Roture]]
</div>

==S==
<div style="-moz-column-count:3; column-count:3; -webkit-column-count:3;">
* [[Place Saint-Barthélemy]]
* [[Place Saint-Denis]]
* [[Rue Saint-Gilles (Liège)|Rue Saint-Gilles]]
* [[Place Saint-Jacques (Liège)|Place Saint-Jacques]]
* [[Place Saint-Lambert (Liège)|Place Saint-Lambert]]
* [[Rue Saint-Laurent (Liège)|Rue Saint-Laurent]]
* [[Esplanade Saint-Léonard (Liège)|Esplanade Saint-Léonard]]
* [[Rue Saint-Léonard]]
* [[Rue Sainte-Marie (Liège)|Rue Sainte-Marie]]
* [[Rue Saint-Martin-en-Île]]
* [[Place Saint-Michel (Liège)|Place Saint-Michel]]
* [[Rue Saint-Michel (Liège)|Rue Saint-Michel]]
* [[Place Saint-Paul (Liège)|Place Saint-Paul]]
* [[Rue Saint-Paul (Liège)|Rue Saint-Paul]]
* [[Rue Saint-Pierre (Liège)|Rue Saint-Pierre]]
* [[Rue Saint-Remacle]]
* [[Rue Saint-Remy]]
* [[Rue Saint-Séverin (Liège)|Rue Saint-Séverin]]
* [[Rue Sainte-Croix]]
* [[Rue Sainte-Marguerite (Liège)|Rue Sainte-Marguerite]]
* [[Place Sainte-Véronique]]
* [[Rue Sainte-Véronique]]
* [[Rue Sainte-Walburge]]
* [[Boulevard Saucy]]
* [[Boulevard de la Sauvenière]]
* [[Rue de Sclessin]]
* [[Rue de Seraing]]
* [[Rue de la Sirène]]
* [[Rue Soubre]]
* [[Rue Sous l'Eau]]
* [[Rue de Spa (Liège)|Rue de Spa]]
* [[Rue Stappers]]
* [[Rue de Stavelot]]
* [[Rue Suavius]]
</div>

==T==
<div style="-moz-column-count:3; column-count:3; -webkit-column-count:3;">
* [[Quai des Tanneurs]]
* [[Rue des Tanneurs (Liège)|Rue des Tanneurs]]
* [[Rue des Tawes]]
* [[Rue du Terris (Liège)|Rue du Terris]]
* [[Place du Tertre (Liège)|Place du Tertre]]
* [[Rue du Thier-à-Liège]]
* [[Chaussée de Tongres]]
* [[Rue Tournant Saint-Paul]]
* [[Rue Toussaint Beaujean]]
</div>

* [[Rue de l'Université (Liège)|Rue de l'Université]]
* [[Rue des Urbanistes]]
* [[Impasse des Ursulines (Liège)|Impasse des Ursulines]]

* [[Rue Valdor]]
* [[Quai Édouard van Beneden]]
* [[Rue Varin]]
* [[Rue des Vennes]]
* [[Rue du Vertbois (Liège)|Rue du Vertbois]]
* [[Rue du Vieux Mayeur]]
* [[Impasse du Vieux Pont des Arches]]
* [[Rue Villette]]
* [[Vinâve d'Île]]<ref>Vinâve signifiant ''artère principale'' en [[wallon]], on ne doit donc pas dire rue du Vinâve d'Île</ref>
* [[Rue Volière (Liège)|Rue Volière]]

* [[Rue des Wallons (Liège)|Rue des Wallons]]
* [[Rue de Waroux]]
* [[Rue de Wazon]]
* [[Rue de Wetzlar]]
* [[Rue Wiertz (Liège)|Rue Wiertz]]

* [[Place Xavier Neujean]]


"""

import re
STREET_RE = re.compile(r"\*\s*\[\[(.+)\]\]\s*$")



from django.conf import settings
from lino.utils.choicelists import Gender
from lino.utils import Cycler
from lino import dd

def objects():
    streets = []
    for ln in STREETS_OF_LIEGE.splitlines():
        if ln and ln[0] == '*':
            m = re.match(STREET_RE, ln)
            if m:
                s = m.group(1).strip()
                if '|' in s:
                    s = s.split('|')[1]
                streets.append(s)
          
          
    last_names = []
    if False:
        for ln in LAST_NAMES_FRANCE.splitlines():
            if ln:
                a = ln.split()
                if len(a) == 3:
                    last_names.append(a[0].strip())
                elif len(a) == 4:
                    last_names.append(a[0].strip()+' '+a[1].strip())
                
    for ln in LAST_NAMES_BELGIUM.splitlines():
        if len(ln) > 1:
            last_names.append(ln.strip())
            
    last_names = Cycler(last_names)
    male_first_names = Cycler([name.strip() for name in MALE_FIRST_NAMES_FRANCE.split(',')])
    female_first_names = Cycler([name.strip() for name in FEMALE_FIRST_NAMES_FRANCE.split(',')])

    Person = dd.resolve_model(settings.LINO.person_model)
    City = dd.resolve_model('countries.City')
    
    CITIES = Cycler(City.objects.filter(country_id='BE',zip_code__startswith='40'))
    STREETS = Cycler(streets)
    
    common = dict(language='fr',country_id='BE')
    for i in range(100):
        yield Person(
          first_name=male_first_names.pop(),
          last_name=last_names.pop(),
          gender=Gender.male,
          city=CITIES.pop(),
          street=STREETS.pop(),
          **common
        )
    for i in range(100):
        yield Person(
          first_name=female_first_names.pop(),
          last_name=last_names.pop(),
          gender=Gender.female,
          city=CITIES.pop(),
          street=STREETS.pop(),
          **common
        )
