/*
 * Decompiled with CFR 0.152.
 */
package be.fedict.eid.applet;

import be.fedict.eid.applet.Applet;
import be.fedict.eid.applet.DiagnosticTests;
import be.fedict.eid.applet.Messages;
import be.fedict.eid.applet.Runtime;
import be.fedict.eid.applet.Status;
import be.fedict.eid.applet.Version;
import be.fedict.eid.applet.View;
import be.fedict.eid.applet.io.AppletSSLSocketFactory;
import be.fedict.eid.applet.io.HttpURLConnectionHttpReceiver;
import be.fedict.eid.applet.io.HttpURLConnectionHttpTransmitter;
import be.fedict.eid.applet.io.LocalAppletProtocolContext;
import be.fedict.eid.applet.sc.DiagnosticCallbackHandler;
import be.fedict.eid.applet.sc.PcscEid;
import be.fedict.eid.applet.sc.PcscEidSpi;
import be.fedict.eid.applet.sc.Task;
import be.fedict.eid.applet.sc.TaskRunner;
import be.fedict.eid.applet.shared.AdministrationMessage;
import be.fedict.eid.applet.shared.AppletProtocolMessageCatalog;
import be.fedict.eid.applet.shared.AuthenticationContract;
import be.fedict.eid.applet.shared.AuthenticationDataMessage;
import be.fedict.eid.applet.shared.AuthenticationRequestMessage;
import be.fedict.eid.applet.shared.CheckClientMessage;
import be.fedict.eid.applet.shared.ClientEnvironmentMessage;
import be.fedict.eid.applet.shared.ContinueInsecureMessage;
import be.fedict.eid.applet.shared.DiagnosticMessage;
import be.fedict.eid.applet.shared.FileDigestsDataMessage;
import be.fedict.eid.applet.shared.FilesDigestRequestMessage;
import be.fedict.eid.applet.shared.FinishedMessage;
import be.fedict.eid.applet.shared.HelloMessage;
import be.fedict.eid.applet.shared.IdentificationRequestMessage;
import be.fedict.eid.applet.shared.IdentityDataMessage;
import be.fedict.eid.applet.shared.InsecureClientMessage;
import be.fedict.eid.applet.shared.KioskMessage;
import be.fedict.eid.applet.shared.SignCertificatesDataMessage;
import be.fedict.eid.applet.shared.SignCertificatesRequestMessage;
import be.fedict.eid.applet.shared.SignRequestMessage;
import be.fedict.eid.applet.shared.SignatureDataMessage;
import be.fedict.eid.applet.shared.annotation.ResponsesAllowed;
import be.fedict.eid.applet.shared.protocol.ProtocolStateMachine;
import be.fedict.eid.applet.shared.protocol.Transport;
import be.fedict.eid.applet.shared.protocol.Unmarshaller;
import java.awt.Component;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.CookieHandler;
import java.net.HttpURLConnection;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.DigestInputStream;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.cert.X509Certificate;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Observable;
import java.util.Observer;
import javax.security.auth.login.FailedLoginException;
import javax.security.auth.login.LoginException;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Controller {
    private final View view;
    private final Runtime runtime;
    private final Messages messages;
    private final PcscEidSpi pcscEidSpi;
    private final ProtocolStateMachine protocolStateMachine;
    private final String[] SUPPORTED_FILES_DIGEST_ALGOS = new String[]{"SHA1", "SHA-1", "SHA-256", "SHA-384", "SHA-512"};
    public static final String APPLET_SERVICE_PARAM = "AppletService";

    public Controller(View view, Runtime runtime, Messages messages) {
        this.view = view;
        this.runtime = runtime;
        this.messages = messages;
        try {
            Class<?> pcscEidClass = Class.forName("be.fedict.eid.applet.sc.PcscEid");
            Constructor<?> pcscEidConstructor = pcscEidClass.getConstructor(View.class, Messages.class);
            this.pcscEidSpi = (PcscEidSpi)pcscEidConstructor.newInstance(this.view, this.messages);
        }
        catch (Exception e) {
            String msg = "error loading PC/SC eID component: " + e.getMessage();
            this.view.addDetailMessage(msg);
            throw new RuntimeException(msg);
        }
        this.pcscEidSpi.addObserver(new PcscEidObserver());
        LocalAppletProtocolContext protocolContext = new LocalAppletProtocolContext(this.view);
        this.protocolStateMachine = new ProtocolStateMachine(protocolContext);
    }

    private <T> T sendMessage(Object message, Class<T> responseClass) throws MalformedURLException, IOException {
        Object responseObject = this.sendMessage(message);
        if (!responseClass.equals(responseObject.getClass())) {
            throw new RuntimeException("response message not of type: " + responseClass.getName());
        }
        Object response = responseObject;
        return (T)response;
    }

    private Object sendMessage(Object message) throws MalformedURLException, IOException {
        Class<?>[] responsesAllowed;
        this.addDetailMessage("sending message: " + message.getClass().getSimpleName());
        Class<?> messageClass = message.getClass();
        ResponsesAllowed responsesAllowedAnnotation = messageClass.getAnnotation(ResponsesAllowed.class);
        if (null == responsesAllowedAnnotation) {
            throw new RuntimeException("message should have a @ResponsesAllowed constraint");
        }
        this.protocolStateMachine.checkRequestMessage(message);
        String userAgent = this.runtime.getParameter("UserAgent");
        boolean noChunkedTransferEncoding = false;
        String noChunkedTransferEncodingParam = this.runtime.getParameter("NoChunkedTransferEncoding");
        if (null != noChunkedTransferEncodingParam) {
            noChunkedTransferEncoding = Boolean.parseBoolean(noChunkedTransferEncodingParam);
            this.addDetailMessage("no chunked transfer-encoding: " + noChunkedTransferEncoding);
        }
        HttpURLConnection connection = this.getServerConnection();
        HttpURLConnectionHttpTransmitter httpTransmitter = new HttpURLConnectionHttpTransmitter(connection, userAgent, noChunkedTransferEncoding);
        Transport.transfer(message, httpTransmitter);
        int responseCode = connection.getResponseCode();
        if (200 != responseCode) {
            String msg = 404 == responseCode ? "HTTP NOT FOUND! eID Applet Service not running?" : Integer.toString(responseCode);
            this.view.addDetailMessage("HTTP response code: " + msg);
            this.printHttpResponseContent(connection);
            throw new IOException("error sending message to service. HTTP status code: " + msg);
        }
        Unmarshaller unmarshaller = new Unmarshaller(new AppletProtocolMessageCatalog());
        HttpURLConnectionHttpReceiver httpReceiver = new HttpURLConnectionHttpReceiver(connection);
        Object responseObject = unmarshaller.receive(httpReceiver);
        if (!this.isOfClass(responseObject, responsesAllowed = responsesAllowedAnnotation.value())) {
            throw new RuntimeException("response not of correct type: " + responseObject.getClass());
        }
        this.addDetailMessage("response message: " + responseObject.getClass().getSimpleName());
        this.protocolStateMachine.checkResponseMessage(responseObject);
        return responseObject;
    }

    private void printHttpResponseContent(HttpURLConnection connection) {
        InputStream errorStream = connection.getErrorStream();
        if (null == errorStream) {
            return;
        }
        BufferedReader reader = new BufferedReader(new InputStreamReader(errorStream));
        try {
            String line;
            while (null != (line = reader.readLine())) {
                this.view.addDetailMessage(line);
            }
        }
        catch (IOException e) {
            this.view.addDetailMessage("I/O error: " + e.getMessage());
        }
    }

    private boolean isOfClass(Object object, Class<?>[] classes) {
        for (Class<?> clazz : classes) {
            if (!clazz.equals(object.getClass())) continue;
            return true;
        }
        return false;
    }

    public Object run() {
        this.printEnvironment();
        try {
            Applet applet = this.runtime.getApplet();
            String language = applet.getParameter("Language");
            HelloMessage helloMessage = new HelloMessage(language);
            Object resultMessage = this.sendMessage(helloMessage);
            if (resultMessage instanceof CheckClientMessage) {
                this.addDetailMessage("Need to check the client secure environment...");
                ClientEnvironmentMessage clientEnvMessage = new ClientEnvironmentMessage();
                clientEnvMessage.javaVersion = System.getProperty("java.version");
                clientEnvMessage.javaVendor = System.getProperty("java.vendor");
                clientEnvMessage.osName = System.getProperty("os.name");
                clientEnvMessage.osArch = System.getProperty("os.arch");
                clientEnvMessage.osVersion = System.getProperty("os.version");
                clientEnvMessage.readerList = this.pcscEidSpi.getReaderList();
                clientEnvMessage.navigatorAppName = this.runtime.getParameter("NavigatorAppName");
                clientEnvMessage.navigatorAppVersion = this.runtime.getParameter("NavigatorAppVersion");
                clientEnvMessage.navigatorUserAgent = this.runtime.getParameter("NavigatorUserAgent");
                resultMessage = this.sendMessage(clientEnvMessage);
                if (resultMessage instanceof InsecureClientMessage) {
                    InsecureClientMessage insecureClientMessage = (InsecureClientMessage)resultMessage;
                    if (insecureClientMessage.warnOnly) {
                        int result = JOptionPane.showConfirmDialog(this.view.getParentComponent(), "Your system has been marked as insecure client environment.\nDo you want to continue the eID operation?", "Insecure Client Environment", 2, 2);
                        if (0 != result) {
                            this.setStatusMessage(Status.ERROR, Messages.MESSAGE_ID.SECURITY_ERROR);
                            this.addDetailMessage("insecure client environment");
                            return null;
                        }
                        resultMessage = this.sendMessage(new ContinueInsecureMessage());
                    } else {
                        JOptionPane.showMessageDialog(this.view.getParentComponent(), "Your system has been marked as insecure client environment.", "Insecure Client Environment", 0);
                        this.setStatusMessage(Status.ERROR, Messages.MESSAGE_ID.SECURITY_ERROR);
                        this.addDetailMessage("received an insecure client environment message");
                        return null;
                    }
                }
            }
            if (resultMessage instanceof DiagnosticMessage) {
                this.diagnosticMode();
            }
            if (resultMessage instanceof KioskMessage) {
                this.kioskMode();
            }
            if (resultMessage instanceof AdministrationMessage) {
                AdministrationMessage administrationMessage = (AdministrationMessage)resultMessage;
                boolean changePin = administrationMessage.changePin;
                boolean unblockPin = administrationMessage.unblockPin;
                boolean removeCard = administrationMessage.removeCard;
                boolean logoff = administrationMessage.logoff;
                boolean requireSecureReader = administrationMessage.requireSecureReader;
                this.addDetailMessage("change pin: " + changePin);
                this.addDetailMessage("unblock pin: " + unblockPin);
                this.addDetailMessage("remove card: " + removeCard);
                this.addDetailMessage("logoff: " + logoff);
                this.addDetailMessage("require secure reader: " + requireSecureReader);
                this.administration(unblockPin, changePin, logoff, removeCard, requireSecureReader);
            }
            if (resultMessage instanceof FilesDigestRequestMessage) {
                FilesDigestRequestMessage filesDigestRequestMessage = (FilesDigestRequestMessage)resultMessage;
                resultMessage = this.performFilesDigestOperation(filesDigestRequestMessage.digestAlgo);
            }
            if (resultMessage instanceof SignCertificatesRequestMessage) {
                SignCertificatesRequestMessage signCertificatesRequestMessage = (SignCertificatesRequestMessage)resultMessage;
                SignCertificatesDataMessage signCertificatesDataMessage = this.performSignCertificatesOperation(signCertificatesRequestMessage);
                resultMessage = this.sendMessage(signCertificatesDataMessage);
            }
            if (resultMessage instanceof SignRequestMessage) {
                SignRequestMessage signRequestMessage = (SignRequestMessage)resultMessage;
                resultMessage = this.performEidSignOperation(signRequestMessage);
            }
            if (resultMessage instanceof AuthenticationRequestMessage) {
                AuthenticationRequestMessage authnRequest = (AuthenticationRequestMessage)resultMessage;
                resultMessage = this.performEidAuthnOperation(authnRequest);
            }
            if (resultMessage instanceof IdentificationRequestMessage) {
                IdentificationRequestMessage identificationRequestMessage = (IdentificationRequestMessage)resultMessage;
                this.addDetailMessage("include address: " + identificationRequestMessage.includeAddress);
                this.addDetailMessage("include photo: " + identificationRequestMessage.includePhoto);
                this.addDetailMessage("include integrity data: " + identificationRequestMessage.includeIntegrityData);
                this.addDetailMessage("include certificates: " + identificationRequestMessage.includeCertificates);
                this.addDetailMessage("remove card: " + identificationRequestMessage.removeCard);
                this.addDetailMessage("identity data usage: " + identificationRequestMessage.identityDataUsage);
                resultMessage = this.performEidIdentificationOperation(identificationRequestMessage.includeAddress, identificationRequestMessage.includePhoto, identificationRequestMessage.includeIntegrityData, identificationRequestMessage.includeCertificates, identificationRequestMessage.removeCard, identificationRequestMessage.identityDataUsage);
            }
            if (resultMessage instanceof FinishedMessage) {
                FinishedMessage finishedMessage = (FinishedMessage)resultMessage;
                if (null != finishedMessage.errorCode) {
                    switch (finishedMessage.errorCode) {
                        case CERTIFICATE: {
                            this.addDetailMessage("something wrong with your certificate");
                            this.setStatusMessage(Status.ERROR, Messages.MESSAGE_ID.SECURITY_ERROR);
                            return null;
                        }
                        case CERTIFICATE_EXPIRED: {
                            this.setStatusMessage(Status.ERROR, Messages.MESSAGE_ID.CERTIFICATE_EXPIRED_ERROR);
                            return null;
                        }
                        case CERTIFICATE_REVOKED: {
                            this.setStatusMessage(Status.ERROR, Messages.MESSAGE_ID.CERTIFICATE_REVOKED_ERROR);
                            return null;
                        }
                        case CERTIFICATE_NOT_TRUSTED: {
                            this.setStatusMessage(Status.ERROR, Messages.MESSAGE_ID.CERTIFICATE_NOT_TRUSTED);
                            return null;
                        }
                    }
                    this.setStatusMessage(Status.ERROR, Messages.MESSAGE_ID.GENERIC_ERROR);
                    this.addDetailMessage("error code @ finish: " + (Object)((Object)finishedMessage.errorCode));
                    return null;
                }
            }
        }
        catch (SecurityException e) {
            this.setStatusMessage(Status.ERROR, Messages.MESSAGE_ID.SECURITY_ERROR);
            this.addDetailMessage("error: " + e.getMessage());
            return null;
        }
        catch (Throwable e) {
            StackTraceElement[] stackTrace;
            this.addDetailMessage("error: " + e.getMessage());
            this.addDetailMessage("error type: " + e.getClass().getName());
            for (StackTraceElement stackTraceElement : stackTrace = e.getStackTrace()) {
                this.addDetailMessage("at " + stackTraceElement.getClassName() + "." + stackTraceElement.getMethodName() + ":" + stackTraceElement.getLineNumber());
            }
            Throwable cause = e.getCause();
            if (null != cause) {
                this.addDetailMessage("Caused by: " + cause.getClass().getName() + ": " + cause.getMessage());
                for (StackTraceElement stackTraceElement : stackTrace = cause.getStackTrace()) {
                    this.addDetailMessage("at " + stackTraceElement.getClassName() + "." + stackTraceElement.getMethodName() + ":" + stackTraceElement.getLineNumber());
                }
                if (FailedLoginException.class == cause.getClass()) {
                    this.setStatusMessage(Status.ERROR, Messages.MESSAGE_ID.PIN_INCORRECT);
                    return null;
                }
                if (LoginException.class == cause.getClass()) {
                    if (null == cause.getMessage()) {
                        this.setStatusMessage(Status.ERROR, Messages.MESSAGE_ID.PIN_BLOCKED);
                        return null;
                    }
                    this.setStatusMessage(Status.ERROR, Messages.MESSAGE_ID.SECURITY_ERROR);
                    return null;
                }
            }
            if ("javax.smartcardio.CardException".equals(e.getClass().getName())) {
                this.setStatusMessage(Status.ERROR, Messages.MESSAGE_ID.CARD_ERROR);
                this.addDetailMessage("card error: " + e.getMessage());
                return null;
            }
            this.setStatusMessage(Status.ERROR, Messages.MESSAGE_ID.GENERIC_ERROR);
            return null;
        }
        this.setStatusMessage(Status.NORMAL, Messages.MESSAGE_ID.DONE);
        this.runtime.gotoTargetPage();
        return null;
    }

    private void diagnosticMode() {
        this.addDetailMessage("diagnostic mode...");
        this.osDiagnosticTest();
        this.jvmDiagnosticTest();
        this.browserDiagnosticTest();
        ControllerDiagnosticCallbackHandler callbackHandler = new ControllerDiagnosticCallbackHandler();
        X509Certificate authnCertificate = this.pcscEidSpi.diagnosticTests(callbackHandler);
        this.pcscEidSpi.close();
        this.mscapiDiagnosticTest(authnCertificate);
        this.view.resetProgress(1);
    }

    private void jvmDiagnosticTest() {
        String javaVersion = System.getProperty("java.version");
        String javaVendor = System.getProperty("java.vendor");
        String javaRuntimeDescription = javaVendor + " " + javaVersion;
        this.view.addTestResult(DiagnosticTests.JAVA_RUNTIME, true, javaRuntimeDescription);
    }

    private void osDiagnosticTest() {
        String osName = System.getProperty("os.name");
        String osVersion = System.getProperty("os.version");
        String osArch = System.getProperty("os.arch");
        String osDescription = osName + " " + osVersion + " (" + osArch + ")";
        this.view.addTestResult(DiagnosticTests.OS, true, osDescription);
    }

    private void browserDiagnosticTest() {
        Class<?> jsObjectClass;
        ClassLoader classLoader = Controller.class.getClassLoader();
        try {
            jsObjectClass = classLoader.loadClass("netscape.javascript.JSObject");
        }
        catch (ClassNotFoundException e) {
            this.addDetailMessage("JSObject class not found");
            this.addDetailMessage("not running inside a browser?");
            this.view.addTestResult(DiagnosticTests.BROWSER, false, e.getMessage());
            return;
        }
        try {
            Method getWindowMethod = jsObjectClass.getMethod("getWindow", java.applet.Applet.class);
            Method getMemberMethod = jsObjectClass.getMethod("getMember", String.class);
            Object windowJSObject = getWindowMethod.invoke(null, this.runtime.getApplet());
            Object navigatorJSObject = getMemberMethod.invoke(windowJSObject, "navigator");
            Object userAgent = getMemberMethod.invoke(navigatorJSObject, "userAgent");
            this.addDetailMessage("user agent: " + userAgent);
            this.view.addTestResult(DiagnosticTests.BROWSER, true, userAgent.toString());
        }
        catch (Exception e) {
            this.view.addTestResult(DiagnosticTests.BROWSER, false, e.getMessage());
            return;
        }
    }

    private void mscapiDiagnosticTest(X509Certificate authnCertificate) {
        Enumeration<String> aliases;
        KeyStore keyStore;
        String osName = System.getProperty("os.name");
        if (!osName.startsWith("Windows")) {
            this.view.addDetailMessage("skipping MSCAPI test as we're not on windows");
            return;
        }
        try {
            keyStore = KeyStore.getInstance("Windows-MY");
            keyStore.load(null, null);
            aliases = keyStore.aliases();
        }
        catch (Exception e) {
            this.view.addDetailMessage("error loading MSCAPI keystore: " + e.getMessage());
            this.view.addTestResult(DiagnosticTests.MSCAPI, false, e.getMessage());
            return;
        }
        String eIDSubjectName = null;
        while (aliases.hasMoreElements()) {
            String subjectName;
            X509Certificate certificate;
            String alias = aliases.nextElement();
            this.view.addDetailMessage("alias: " + alias);
            try {
                certificate = (X509Certificate)keyStore.getCertificate(alias);
            }
            catch (KeyStoreException e) {
                this.view.addDetailMessage("error loading MSCAPI certificate: " + e.getMessage());
                this.view.addTestResult(DiagnosticTests.MSCAPI, false, e.getMessage());
                return;
            }
            if (!certificate.equals(authnCertificate)) continue;
            eIDSubjectName = subjectName = certificate.getSubjectX500Principal().toString();
        }
        if (null == eIDSubjectName) {
            this.view.addTestResult(DiagnosticTests.MSCAPI, false, "No eID certificate found in the Windows keystore");
            return;
        }
        this.view.addTestResult(DiagnosticTests.MSCAPI, true, eIDSubjectName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SignCertificatesDataMessage performSignCertificatesOperation(SignCertificatesRequestMessage signCertificatesRequestMessage) throws Exception {
        byte[] rootCaCertFile;
        byte[] citizenCaCertFile;
        byte[] signCertFile;
        this.addDetailMessage("performing sign certificates retrieval operation...");
        boolean includeIdentity = signCertificatesRequestMessage.includeIdentity;
        boolean includeAddress = signCertificatesRequestMessage.includeAddress;
        boolean includePhoto = signCertificatesRequestMessage.includePhoto;
        boolean includeIntegrityData = signCertificatesRequestMessage.includeIntegrityData;
        byte[] identityFile = null;
        byte[] addressFile = null;
        byte[] photoFile = null;
        byte[] identitySignFile = null;
        byte[] addressSignFile = null;
        byte[] nrnCertFile = null;
        this.setStatusMessage(Status.NORMAL, Messages.MESSAGE_ID.DETECTING_CARD);
        this.waitForEIdCardPcsc();
        try {
            this.setStatusMessage(Status.NORMAL, Messages.MESSAGE_ID.READING_IDENTITY);
            if (includeIdentity || includeAddress || includePhoto) {
                boolean response = this.view.privacyQuestion(includeAddress, includePhoto, null);
                if (!response) {
                    this.pcscEidSpi.close();
                    throw new SecurityException("user did not agree to release eID identity information");
                }
                this.setStatusMessage(Status.NORMAL, Messages.MESSAGE_ID.OK);
                this.setStatusMessage(Status.NORMAL, Messages.MESSAGE_ID.READING_IDENTITY);
            }
            signCertFile = this.pcscEidSpi.readFile(PcscEid.SIGN_CERT_FILE_ID);
            this.addDetailMessage("size sign cert file: " + signCertFile.length);
            citizenCaCertFile = this.pcscEidSpi.readFile(PcscEid.CA_CERT_FILE_ID);
            this.addDetailMessage("size citizen CA cert file: " + citizenCaCertFile.length);
            rootCaCertFile = this.pcscEidSpi.readFile(PcscEid.ROOT_CERT_FILE_ID);
            this.addDetailMessage("size root CA cert file: " + rootCaCertFile.length);
            if (includeIdentity || includeAddress || includePhoto) {
                if (includeIdentity) {
                    this.addDetailMessage("reading identity file");
                    identityFile = this.pcscEidSpi.readFile(PcscEid.IDENTITY_FILE_ID);
                    if (includeIntegrityData) {
                        this.addDetailMessage("reading identity sign file");
                        identitySignFile = this.pcscEidSpi.readFile(PcscEid.IDENTITY_SIGN_FILE_ID);
                    }
                }
                if (includeAddress) {
                    this.addDetailMessage("reading address file");
                    addressFile = this.pcscEidSpi.readFile(PcscEid.ADDRESS_FILE_ID);
                    if (includeIntegrityData) {
                        this.addDetailMessage("reading address sign file");
                        addressSignFile = this.pcscEidSpi.readFile(PcscEid.ADDRESS_SIGN_FILE_ID);
                    }
                }
                if (includePhoto) {
                    this.addDetailMessage("reading photo file");
                    photoFile = this.pcscEidSpi.readFile(PcscEid.PHOTO_FILE_ID);
                }
                if (null != identitySignFile || null != addressSignFile) {
                    this.addDetailMessage("reading NRN certificate file");
                    nrnCertFile = this.pcscEidSpi.readFile(PcscEid.RRN_CERT_FILE_ID);
                }
            }
        }
        finally {
            this.pcscEidSpi.close();
        }
        SignCertificatesDataMessage signCertificatesDataMessage = new SignCertificatesDataMessage(signCertFile, citizenCaCertFile, rootCaCertFile, identityFile, addressFile, photoFile, identitySignFile, addressSignFile, nrnCertFile);
        return signCertificatesDataMessage;
    }

    private void kioskMode() throws IllegalArgumentException, SecurityException, IOException, InterruptedException, NoSuchFieldException, IllegalAccessException, InvocationTargetException, NoSuchMethodException, Exception {
        this.addDetailMessage("entering Kiosk Mode...");
        this.view.setStatusMessage(Status.NORMAL, Messages.MESSAGE_ID.KIOSK_MODE);
        while (true) {
            Class<?> jsObjectClass;
            if (!this.pcscEidSpi.isEidPresent()) {
                this.pcscEidSpi.waitForEidPresent();
            }
            this.addDetailMessage("waiting for card removal...");
            this.pcscEidSpi.removeCard();
            this.addDetailMessage("card removed");
            ClassLoader classLoader = Controller.class.getClassLoader();
            try {
                jsObjectClass = classLoader.loadClass("netscape.javascript.JSObject");
            }
            catch (ClassNotFoundException e) {
                this.addDetailMessage("JSObject class not found");
                this.addDetailMessage("not running inside a browser?");
                continue;
            }
            Method getWindowMethod = jsObjectClass.getMethod("getWindow", java.applet.Applet.class);
            Object jsObject = getWindowMethod.invoke(null, this.runtime.getApplet());
            Method callMethod = jsObjectClass.getMethod("call", String.class, Class.forName("[Ljava.lang.Object;"));
            String removeCardCallback = this.runtime.getParameter("RemoveCardCallback");
            if (null != removeCardCallback) {
                this.addDetailMessage("invoking javascript callback: " + removeCardCallback);
                callMethod.invoke(jsObject, removeCardCallback, new Object[0]);
                continue;
            }
            this.addDetailMessage("missing RemoveCardCallback parameter");
        }
    }

    private Object performFilesDigestOperation(String filesDigestAlgo) throws NoSuchAlgorithmException, IOException {
        this.addDetailMessage("files digest algorithm: " + filesDigestAlgo);
        boolean isSupportedFilesDigestAlgo = false;
        for (String supportedFilesDigestAlgo : this.SUPPORTED_FILES_DIGEST_ALGOS) {
            if (!supportedFilesDigestAlgo.equals(filesDigestAlgo)) continue;
            isSupportedFilesDigestAlgo = true;
            break;
        }
        if (!isSupportedFilesDigestAlgo) {
            throw new SecurityException("files digest algo not supported: " + filesDigestAlgo);
        }
        MessageDigest messageDigest = MessageDigest.getInstance(filesDigestAlgo);
        this.setStatusMessage(Status.NORMAL, Messages.MESSAGE_ID.SELECT_FILES);
        JFileChooser fileChooser = new JFileChooser();
        fileChooser.setMultiSelectionEnabled(true);
        int returnCode = fileChooser.showDialog(this.getParentComponent(), this.messages.getMessage(Messages.MESSAGE_ID.SELECT_FILES));
        if (0 != returnCode) {
            throw new RuntimeException("file selection aborted");
        }
        this.setStatusMessage(Status.NORMAL, Messages.MESSAGE_ID.DIGESTING_FILES);
        FileDigestsDataMessage fileDigestsDataMessage = new FileDigestsDataMessage();
        fileDigestsDataMessage.fileDigestInfos = new LinkedList<String>();
        File[] selectedFiles = fileChooser.getSelectedFiles();
        long totalSize = 0L;
        for (File selectedFile : selectedFiles) {
            totalSize += selectedFile.length();
        }
        int BUFFER_SIZE = 10240;
        int progressMax = (int)(totalSize / 10240L);
        this.view.resetProgress(progressMax);
        this.addDetailMessage("total data size to digest: " + totalSize / 1024L + " KiB");
        for (File selectedFile : selectedFiles) {
            fileDigestsDataMessage.fileDigestInfos.add(filesDigestAlgo);
            long fileSize = selectedFile.length();
            this.addDetailMessage(selectedFile.getAbsolutePath() + ": " + fileSize / 1024L + " KiB");
            FileInputStream fileInputStream = new FileInputStream(selectedFile);
            DigestInputStream digestInputStream = new DigestInputStream(fileInputStream, messageDigest);
            byte[] buffer = new byte[10240];
            while (-1 != digestInputStream.read(buffer)) {
                this.view.increaseProgress();
            }
            digestInputStream.close();
            byte[] fileDigestValue = messageDigest.digest();
            messageDigest.reset();
            String fileDigest = Controller.toHex(fileDigestValue);
            fileDigestsDataMessage.fileDigestInfos.add(fileDigest);
            fileDigestsDataMessage.fileDigestInfos.add(selectedFile.getName());
        }
        this.view.setProgressIndeterminate();
        Object resultMessage = this.sendMessage(fileDigestsDataMessage);
        return resultMessage;
    }

    public static String toHex(byte[] data) {
        StringBuffer stringBuffer = new StringBuffer();
        for (byte b : data) {
            stringBuffer.append(Controller.toHex(b >> 4));
            stringBuffer.append(Controller.toHex(b));
        }
        return stringBuffer.toString();
    }

    private static char toHex(int value) {
        switch (value &= 0xF) {
            case 10: {
                return 'A';
            }
            case 11: {
                return 'B';
            }
            case 12: {
                return 'C';
            }
            case 13: {
                return 'D';
            }
            case 14: {
                return 'E';
            }
            case 15: {
                return 'F';
            }
        }
        return (char)(48 + value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private FinishedMessage performEidSignOperation(SignRequestMessage signRequestMessage) throws Exception {
        byte[] rootCaCertFile;
        byte[] citizenCaCertFile;
        byte[] signCertFile;
        byte[] signatureValue;
        boolean logoff = signRequestMessage.logoff;
        boolean removeCard = signRequestMessage.removeCard;
        boolean requireSecureReader = signRequestMessage.requireSecureReader;
        this.addDetailMessage("logoff: " + logoff);
        this.addDetailMessage("remove card: " + removeCard);
        this.addDetailMessage("require secure smart card reader: " + requireSecureReader);
        this.setStatusMessage(Status.NORMAL, Messages.MESSAGE_ID.DETECTING_CARD);
        this.waitForEIdCardPcsc();
        this.setStatusMessage(Status.NORMAL, Messages.MESSAGE_ID.SIGNING);
        try {
            String signatureCreationLabel = this.messages.getMessage(Messages.MESSAGE_ID.SIGNATURE_CREATION);
            String signQuestionLabel = this.messages.getMessage(Messages.MESSAGE_ID.SIGN_QUESTION);
            String signatureAlgoLabel = this.messages.getMessage(Messages.MESSAGE_ID.SIGNATURE_ALGO);
            int response = JOptionPane.showConfirmDialog(this.getParentComponent(), signQuestionLabel + " \"" + signRequestMessage.description + "\"?\n" + signatureAlgoLabel + ": " + signRequestMessage.digestAlgo + " with RSA", signatureCreationLabel, 0);
            if (0 != response) {
                throw new SecurityException("sign operation aborted");
            }
            signatureValue = this.pcscEidSpi.sign(signRequestMessage.digestValue, signRequestMessage.digestAlgo, requireSecureReader);
            int maxProgress = 0;
            maxProgress += 5;
            maxProgress += 5;
            this.view.resetProgress(maxProgress += 5);
            signCertFile = this.pcscEidSpi.readFile(PcscEid.SIGN_CERT_FILE_ID);
            citizenCaCertFile = this.pcscEidSpi.readFile(PcscEid.CA_CERT_FILE_ID);
            rootCaCertFile = this.pcscEidSpi.readFile(PcscEid.ROOT_CERT_FILE_ID);
            this.view.setProgressIndeterminate();
            if (signRequestMessage.logoff && !signRequestMessage.removeCard) {
                this.pcscEidSpi.logoff();
            }
            if (signRequestMessage.removeCard) {
                this.setStatusMessage(Status.NORMAL, Messages.MESSAGE_ID.REMOVE_CARD);
                this.pcscEidSpi.removeCard();
            }
        }
        finally {
            this.pcscEidSpi.close();
        }
        SignatureDataMessage signatureDataMessage = new SignatureDataMessage(signatureValue, signCertFile, citizenCaCertFile, rootCaCertFile);
        Object responseMessage = this.sendMessage(signatureDataMessage);
        if (!(responseMessage instanceof FinishedMessage)) {
            throw new RuntimeException("finish expected");
        }
        FinishedMessage finishedMessage = (FinishedMessage)responseMessage;
        return finishedMessage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void administration(boolean unblockPin, boolean changePin, boolean logoff, boolean removeCard, boolean requireSecureReader) throws Exception {
        this.waitForEIdCardPcsc();
        try {
            if (unblockPin) {
                this.setStatusMessage(Status.NORMAL, Messages.MESSAGE_ID.PIN_UNBLOCK);
                this.pcscEidSpi.unblockPin(requireSecureReader);
            }
            if (changePin) {
                this.setStatusMessage(Status.NORMAL, Messages.MESSAGE_ID.PIN_CHANGE);
                this.pcscEidSpi.changePin(requireSecureReader);
            }
            if (logoff) {
                this.pcscEidSpi.logoff();
            }
            if (removeCard) {
                this.setStatusMessage(Status.NORMAL, Messages.MESSAGE_ID.REMOVE_CARD);
                this.pcscEidSpi.removeCard();
            }
        }
        finally {
            this.pcscEidSpi.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private FinishedMessage performEidAuthnOperation(AuthenticationRequestMessage authnRequest) throws Exception {
        byte[] signatureValue;
        boolean response;
        InetAddress inetAddress;
        String hostname;
        byte[] challenge = authnRequest.challenge;
        boolean removeCard = authnRequest.removeCard;
        boolean includeHostname = authnRequest.includeHostname;
        boolean includeInetAddress = authnRequest.includeInetAddress;
        boolean logoff = authnRequest.logoff;
        boolean preLogoff = authnRequest.preLogoff;
        boolean sessionIdChannelBinding = authnRequest.sessionIdChannelBinding;
        boolean serverCertificateChannelBinding = authnRequest.serverCertificateChannelBinding;
        boolean includeIdentity = authnRequest.includeIdentity;
        boolean includeCertificates = authnRequest.includeCertificates;
        boolean includeAddress = authnRequest.includeAddress;
        boolean includePhoto = authnRequest.includePhoto;
        boolean includeIntegrityData = authnRequest.includeIntegrityData;
        boolean requireSecureReader = authnRequest.requireSecureReader;
        String transactionMessage = authnRequest.transactionMessage;
        if (challenge.length < 20) {
            throw new SecurityException("challenge should be at least 20 bytes long.");
        }
        this.addDetailMessage("include hostname: " + includeHostname);
        this.addDetailMessage("include inet address: " + includeInetAddress);
        this.addDetailMessage("remove card after authn: " + removeCard);
        this.addDetailMessage("logoff: " + logoff);
        this.addDetailMessage("pre-logoff: " + preLogoff);
        this.addDetailMessage("TLS session Id channel binding: " + sessionIdChannelBinding);
        this.addDetailMessage("server certificate channel binding: " + serverCertificateChannelBinding);
        this.addDetailMessage("include identity: " + includeIdentity);
        this.addDetailMessage("include certificates: " + includeCertificates);
        this.addDetailMessage("include address: " + includeAddress);
        this.addDetailMessage("include photo: " + includePhoto);
        this.addDetailMessage("include integrity data: " + includeIntegrityData);
        this.addDetailMessage("require secure smart card reader: " + requireSecureReader);
        this.addDetailMessage("transaction message: " + transactionMessage);
        if (includeHostname) {
            URL documentBase = this.runtime.getDocumentBase();
            hostname = documentBase.getHost();
            this.addDetailMessage("hostname: " + hostname);
        } else {
            hostname = null;
        }
        if (includeInetAddress) {
            URL documentBase = this.runtime.getDocumentBase();
            inetAddress = InetAddress.getByName(documentBase.getHost());
            this.addDetailMessage("inet address: " + inetAddress.getHostAddress());
        } else {
            inetAddress = null;
        }
        Object sessionId = sessionIdChannelBinding ? AppletSSLSocketFactory.getActualSessionId() : null;
        Object encodedServerCertificate = serverCertificateChannelBinding ? AppletSSLSocketFactory.getActualEncodedServerCertificate() : null;
        this.setStatusMessage(Status.NORMAL, Messages.MESSAGE_ID.DETECTING_CARD);
        this.waitForEIdCardPcsc();
        this.setStatusMessage(Status.NORMAL, Messages.MESSAGE_ID.AUTHENTICATING);
        byte[] salt = this.pcscEidSpi.getChallenge(20);
        AuthenticationContract authenticationContract = new AuthenticationContract(salt, hostname, inetAddress, (byte[])sessionId, (byte[])encodedServerCertificate, challenge);
        byte[] toBeSigned = authenticationContract.calculateToBeSigned();
        if ((includeIdentity || includeAddress || includePhoto) && !(response = this.view.privacyQuestion(includeAddress, includePhoto, null))) {
            this.pcscEidSpi.close();
            throw new SecurityException("user did not agree to release eID identity information");
        }
        byte[] identityData = null;
        byte[] addressData = null;
        byte[] photoData = null;
        byte[] identitySignatureData = null;
        byte[] addressSignatureData = null;
        byte[] rrnCertData = null;
        byte[] authnCertFile = null;
        byte[] signCertFile = null;
        byte[] citCaCertFile = null;
        byte[] rootCaCertFile = null;
        byte[] signedTransactionMessage = null;
        try {
            if (preLogoff) {
                this.view.addDetailMessage("performing a pre-logoff");
                this.pcscEidSpi.logoff();
            }
            signatureValue = this.pcscEidSpi.signAuthn(toBeSigned, requireSecureReader);
            if (null != transactionMessage) {
                signedTransactionMessage = this.pcscEidSpi.signTransactionMessage(transactionMessage, requireSecureReader);
            }
            int maxProgress = 0;
            maxProgress += 5;
            maxProgress += 5;
            maxProgress += 5;
            if (includeIdentity) {
                ++maxProgress;
            }
            if (includeAddress) {
                ++maxProgress;
            }
            if (includePhoto) {
                maxProgress += 11;
            }
            if (includeIntegrityData) {
                if (includeIdentity) {
                    ++maxProgress;
                }
                if (includeAddress) {
                    ++maxProgress;
                }
                maxProgress += 5;
            }
            this.view.resetProgress(maxProgress);
            TaskRunner taskRunner = new TaskRunner(this.pcscEidSpi, this.view);
            authnCertFile = taskRunner.run(new Task<byte[]>(){

                @Override
                public byte[] run() throws Exception {
                    return Controller.this.pcscEidSpi.readFile(PcscEid.AUTHN_CERT_FILE_ID);
                }
            });
            citCaCertFile = taskRunner.run(new Task<byte[]>(){

                @Override
                public byte[] run() throws Exception {
                    return Controller.this.pcscEidSpi.readFile(PcscEid.CA_CERT_FILE_ID);
                }
            });
            rootCaCertFile = taskRunner.run(new Task<byte[]>(){

                @Override
                public byte[] run() throws Exception {
                    return Controller.this.pcscEidSpi.readFile(PcscEid.ROOT_CERT_FILE_ID);
                }
            });
            if (includeCertificates) {
                this.addDetailMessage("reading sign certificate file...");
                signCertFile = taskRunner.run(new Task<byte[]>(){

                    @Override
                    public byte[] run() throws Exception {
                        return Controller.this.pcscEidSpi.readFile(PcscEid.SIGN_CERT_FILE_ID);
                    }
                });
                this.addDetailMessage("size non-repud cert file: " + signCertFile.length);
            }
            if (includeIdentity || includeAddress || includePhoto) {
                this.setStatusMessage(Status.NORMAL, Messages.MESSAGE_ID.READING_IDENTITY);
            }
            if (includeIdentity) {
                identityData = taskRunner.run(new Task<byte[]>(){

                    @Override
                    public byte[] run() throws Exception {
                        return Controller.this.pcscEidSpi.readFile(PcscEid.IDENTITY_FILE_ID);
                    }
                });
            }
            if (includeAddress) {
                addressData = taskRunner.run(new Task<byte[]>(){

                    @Override
                    public byte[] run() throws Exception {
                        return Controller.this.pcscEidSpi.readFile(PcscEid.ADDRESS_FILE_ID);
                    }
                });
            }
            if (includePhoto) {
                photoData = taskRunner.run(new Task<byte[]>(){

                    @Override
                    public byte[] run() throws Exception {
                        return Controller.this.pcscEidSpi.readFile(PcscEid.PHOTO_FILE_ID);
                    }
                });
            }
            if (includeIntegrityData) {
                if (includeIdentity) {
                    identitySignatureData = taskRunner.run(new Task<byte[]>(){

                        @Override
                        public byte[] run() throws Exception {
                            return Controller.this.pcscEidSpi.readFile(PcscEid.IDENTITY_SIGN_FILE_ID);
                        }
                    });
                }
                if (includeAddress) {
                    addressSignatureData = taskRunner.run(new Task<byte[]>(){

                        @Override
                        public byte[] run() throws Exception {
                            return Controller.this.pcscEidSpi.readFile(PcscEid.ADDRESS_SIGN_FILE_ID);
                        }
                    });
                }
                rrnCertData = taskRunner.run(new Task<byte[]>(){

                    @Override
                    public byte[] run() throws Exception {
                        return Controller.this.pcscEidSpi.readFile(PcscEid.RRN_CERT_FILE_ID);
                    }
                });
            }
            this.view.setProgressIndeterminate();
            if (logoff && !removeCard) {
                this.pcscEidSpi.logoff();
            }
            if (removeCard) {
                this.setStatusMessage(Status.NORMAL, Messages.MESSAGE_ID.REMOVE_CARD);
                this.pcscEidSpi.removeCard();
            }
        }
        finally {
            this.pcscEidSpi.close();
        }
        AuthenticationDataMessage authenticationDataMessage = new AuthenticationDataMessage(salt, (byte[])sessionId, signatureValue, authnCertFile, citCaCertFile, rootCaCertFile, signCertFile, identityData, addressData, photoData, identitySignatureData, addressSignatureData, rrnCertData, (byte[])encodedServerCertificate, signedTransactionMessage);
        Object responseMessage = this.sendMessage(authenticationDataMessage);
        if (!(responseMessage instanceof FinishedMessage)) {
            throw new RuntimeException("finish expected");
        }
        FinishedMessage finishedMessage = (FinishedMessage)responseMessage;
        return finishedMessage;
    }

    private void printEnvironment() {
        Version version = new Version();
        this.addDetailMessage("eID browser applet version: " + version.getVersion());
        this.addDetailMessage("Java version: " + System.getProperty("java.version"));
        this.addDetailMessage("Java vendor: " + System.getProperty("java.vendor"));
        this.addDetailMessage("OS: " + System.getProperty("os.name"));
        this.addDetailMessage("OS version: " + System.getProperty("os.version"));
        this.addDetailMessage("OS arch: " + System.getProperty("os.arch"));
        this.addDetailMessage("Web application URL: " + this.runtime.getDocumentBase());
        this.addDetailMessage("Current time: " + new Date());
        CookieHandler cookieHandler = CookieHandler.getDefault();
        if (null != cookieHandler) {
            URL documentBase = this.runtime.getApplet().getDocumentBase();
            try {
                Map<String, List<String>> headers = cookieHandler.get(documentBase.toURI(), new HashMap<String, List<String>>());
                List<String> cookieHeaderValues = headers.get("Cookie");
                if (null == cookieHeaderValues || cookieHeaderValues.isEmpty()) {
                    this.addDetailMessage("ERROR: no session cookie detected!");
                } else {
                    this.addDetailMessage("session cookie detected");
                }
            }
            catch (Exception e) {
                this.addDetailMessage("error getting cookies from default cookie handler");
            }
        }
    }

    public void addDetailMessage(String detailMessage) {
        this.view.addDetailMessage(detailMessage);
    }

    private FinishedMessage performEidIdentificationOperation(boolean includeAddress, boolean includePhoto, boolean includeIntegrityData, boolean includeCertificates, boolean removeCard, String identityDataUsage) throws Exception {
        this.waitForEIdCardPcsc();
        this.setStatusMessage(Status.NORMAL, Messages.MESSAGE_ID.READING_IDENTITY);
        boolean response = this.view.privacyQuestion(includeAddress, includePhoto, identityDataUsage);
        if (!response) {
            this.pcscEidSpi.close();
            throw new SecurityException("user did not agree to release eID identity information");
        }
        this.addDetailMessage("Reading identity file...");
        int maxProgress = 1;
        if (includeAddress) {
            ++maxProgress;
        }
        if (includePhoto) {
            maxProgress += 11;
        }
        if (includeIntegrityData) {
            ++maxProgress;
            if (includeAddress) {
                ++maxProgress;
            }
            maxProgress += 5;
            maxProgress += 5;
        }
        if (includeCertificates) {
            maxProgress += 5;
            maxProgress += 5;
            maxProgress += 5;
            if (!includeIntegrityData) {
                maxProgress += 5;
            }
        }
        this.view.resetProgress(maxProgress);
        TaskRunner taskRunner = new TaskRunner(this.pcscEidSpi, this.view);
        byte[] idFile = taskRunner.run(new Task<byte[]>(){

            @Override
            public byte[] run() throws Exception {
                return Controller.this.pcscEidSpi.readFile(PcscEid.IDENTITY_FILE_ID);
            }
        });
        this.addDetailMessage("Size identity file: " + idFile.length);
        byte[] addressFile = null;
        if (includeAddress) {
            this.addDetailMessage("Read address file...");
            addressFile = taskRunner.run(new Task<byte[]>(){

                @Override
                public byte[] run() throws Exception {
                    return Controller.this.pcscEidSpi.readFile(PcscEid.ADDRESS_FILE_ID);
                }
            });
            this.addDetailMessage("Size address file: " + addressFile.length);
        }
        byte[] photoFile = null;
        if (includePhoto) {
            this.addDetailMessage("Read photo file...");
            photoFile = taskRunner.run(new Task<byte[]>(){

                @Override
                public byte[] run() throws Exception {
                    return Controller.this.pcscEidSpi.readFile(PcscEid.PHOTO_FILE_ID);
                }
            });
        }
        byte[] identitySignatureFile = null;
        byte[] addressSignatureFile = null;
        byte[] rrnCertFile = null;
        byte[] rootCertFile = null;
        if (includeIntegrityData) {
            this.addDetailMessage("Read identity signature file...");
            identitySignatureFile = taskRunner.run(new Task<byte[]>(){

                @Override
                public byte[] run() throws Exception {
                    return Controller.this.pcscEidSpi.readFile(PcscEid.IDENTITY_SIGN_FILE_ID);
                }
            });
            if (includeAddress) {
                this.addDetailMessage("Read address signature file...");
                addressSignatureFile = taskRunner.run(new Task<byte[]>(){

                    @Override
                    public byte[] run() throws Exception {
                        return Controller.this.pcscEidSpi.readFile(PcscEid.ADDRESS_SIGN_FILE_ID);
                    }
                });
            }
            this.addDetailMessage("Read national registry certificate file...");
            rrnCertFile = taskRunner.run(new Task<byte[]>(){

                @Override
                public byte[] run() throws Exception {
                    return Controller.this.pcscEidSpi.readFile(PcscEid.RRN_CERT_FILE_ID);
                }
            });
            this.addDetailMessage("size RRN cert file: " + rrnCertFile.length);
            this.addDetailMessage("reading root certificate file...");
            rootCertFile = taskRunner.run(new Task<byte[]>(){

                @Override
                public byte[] run() throws Exception {
                    return Controller.this.pcscEidSpi.readFile(PcscEid.ROOT_CERT_FILE_ID);
                }
            });
            this.addDetailMessage("size Root CA cert file: " + rootCertFile.length);
        }
        byte[] authnCertFile = null;
        byte[] signCertFile = null;
        byte[] caCertFile = null;
        if (includeCertificates) {
            this.addDetailMessage("reading authn certificate file...");
            authnCertFile = taskRunner.run(new Task<byte[]>(){

                @Override
                public byte[] run() throws Exception {
                    return Controller.this.pcscEidSpi.readFile(PcscEid.AUTHN_CERT_FILE_ID);
                }
            });
            this.addDetailMessage("size authn cert file: " + authnCertFile.length);
            this.addDetailMessage("reading sign certificate file...");
            signCertFile = taskRunner.run(new Task<byte[]>(){

                @Override
                public byte[] run() throws Exception {
                    return Controller.this.pcscEidSpi.readFile(PcscEid.SIGN_CERT_FILE_ID);
                }
            });
            this.addDetailMessage("size non-repud cert file: " + signCertFile.length);
            this.addDetailMessage("reading citizen CA certificate file...");
            caCertFile = taskRunner.run(new Task<byte[]>(){

                @Override
                public byte[] run() throws Exception {
                    return Controller.this.pcscEidSpi.readFile(PcscEid.CA_CERT_FILE_ID);
                }
            });
            this.addDetailMessage("size Cit CA cert file: " + caCertFile.length);
            if (null == rootCertFile) {
                this.addDetailMessage("reading root certificate file...");
                rootCertFile = taskRunner.run(new Task<byte[]>(){

                    @Override
                    public byte[] run() throws Exception {
                        return Controller.this.pcscEidSpi.readFile(PcscEid.ROOT_CERT_FILE_ID);
                    }
                });
                this.addDetailMessage("size Root CA cert file: " + rootCertFile.length);
            }
        }
        this.view.setProgressIndeterminate();
        if (removeCard) {
            this.setStatusMessage(Status.NORMAL, Messages.MESSAGE_ID.REMOVE_CARD);
            this.pcscEidSpi.removeCard();
        }
        this.pcscEidSpi.close();
        this.setStatusMessage(Status.NORMAL, Messages.MESSAGE_ID.TRANSMITTING_IDENTITY);
        IdentityDataMessage identityData = new IdentityDataMessage(idFile, addressFile, photoFile, identitySignatureFile, addressSignatureFile, rrnCertFile, rootCertFile, authnCertFile, signCertFile, caCertFile);
        FinishedMessage finishedMessage = this.sendMessage(identityData, FinishedMessage.class);
        return finishedMessage;
    }

    private void waitForEIdCardPcsc() throws Exception {
        this.setStatusMessage(Status.NORMAL, Messages.MESSAGE_ID.DETECTING_CARD);
        if (!this.pcscEidSpi.hasCardReader()) {
            this.setStatusMessage(Status.NORMAL, Messages.MESSAGE_ID.CONNECT_READER);
            this.pcscEidSpi.waitForCardReader();
        }
        if (!this.pcscEidSpi.isEidPresent()) {
            this.setStatusMessage(Status.NORMAL, Messages.MESSAGE_ID.INSERT_CARD_QUESTION);
            this.pcscEidSpi.waitForEidPresent();
        }
    }

    private HttpURLConnection getServerConnection() throws MalformedURLException, IOException {
        String appletServiceParam = this.runtime.getParameter(APPLET_SERVICE_PARAM);
        if (null == appletServiceParam) {
            throw new IllegalArgumentException("no AppletService parameter specified");
        }
        URL appletServiceUrl = new URL(this.runtime.getDocumentBase(), appletServiceParam);
        AppletSSLSocketFactory.installSocketFactory(this.view);
        HttpURLConnection connection = (HttpURLConnection)appletServiceUrl.openConnection();
        return connection;
    }

    private void setStatusMessage(Status status, Messages.MESSAGE_ID messageId) {
        this.view.setStatusMessage(status, messageId);
    }

    public Component getParentComponent() {
        return this.view.getParentComponent();
    }

    private class PcscEidObserver
    implements Observer {
        private PcscEidObserver() {
        }

        public void update(Observable observable, Object arg) {
            Controller.this.view.increaseProgress();
        }
    }

    private class ControllerDiagnosticCallbackHandler
    implements DiagnosticCallbackHandler {
        private ControllerDiagnosticCallbackHandler() {
        }

        public void addTestResult(DiagnosticTests test, boolean success, String information) {
            Controller.this.view.addTestResult(test, success, information);
        }
    }
}

